﻿USE sofia;
DROP TABLE IF EXISTS sofia.xavNT_vpl;
CREATE TABLE xavNT_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES xavNT_vpl WRITE;
INSERT INTO xavNT_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Ã hã rob'ui'éré hã Zezu Cristuhu hi'rata norĩ za'ratazé. Ta hã Dawihi nhihudu, duré Abra'ãhã nhihudu. ");
INSERT INTO xavNT_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Abra'ã hã Izatihi mama. Izati hã Zacoho mama. Zaco hã Zuda norĩ mama, tisisãnawã norĩ me. ");
INSERT INTO xavNT_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Zuda hã Perezihi mama, duré Zeraha mama. Ĩna zahuré hã Tama na ĩsisi hã. Duré Perezi hã Esirõhõ mama. Duré Esirõ hã Arãhã mama, ta hã. ");
INSERT INTO xavNT_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Arã hã Aminadabehe mama. Duré Aminadabe hã Nasõhõ mama. Duré Nasõ hã Samohõ mama. ");
INSERT INTO xavNT_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Samo hã Bu'azihi mama. Bu'azihi na hã Ra'abi na ĩsisi hã. Duré Bu'azi hã Obedihi mama. Obedihi na nhisi hã, Ruti na ĩsisi hã. Duré Obedi hã Zéséhé mama. ");
INSERT INTO xavNT_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Zésé hã Dawihi mama, dama ĩpire mama. Dawi hã Saromahã mama. Uri'asi ĩdâ'â mro wa, ma podo, Saroma hã. ");
INSERT INTO xavNT_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Saroma hã Robu'ãhã mama. Duré Robu'ã hã Abizaha mama. Duré Abiza hã Azaha mama. ");
INSERT INTO xavNT_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Aza hã Zosapaha mama. Duré Zosapa hã Zorãhã mama. Zorã hã Uzi'asihi hi'rada. ");
INSERT INTO xavNT_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Uzi'asi hã Zotãhã mama. Duré Zotã hã Acasihi mama. Duré Acasi hã Ezetizaha mama, ta hã. ");
INSERT INTO xavNT_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Ezetiza hã Manaséhé mama. Duré Manasé hã Amosihi mama. Amosi hã Zozi'asihi mama, ta hã. ");
INSERT INTO xavNT_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Zozi'asi hã Zeconiza norĩ mama, tisisãnawã norĩ me. Babironiza u Izarazéhé nhihudu norĩ, da te séme da, da te simroi mono ré, ma tô ta norĩ hã tipoto za'ra. ");
INSERT INTO xavNT_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Tawamhã Izarazéhé nhihudu norĩ, Babironiza u da te simroi mono za'u si, ma tô Zeconiza hã poto, Sarati'é hã. Sarati'é hã Zorobabéhé mama, ta hã. ");
INSERT INTO xavNT_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Zorobabé hã Abi'udihi mama. Duré Abi'udi hã Eri'atĩhĩ mama. Duré Eri'atĩ hã Azoho mama. ");
INSERT INTO xavNT_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Azo hã Sadotihi mama. Duré Sadoti hã Atĩhĩ mama. Duré Atĩ hã Eri'udihi mama. ");
INSERT INTO xavNT_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eri'udi hã Eri'azaha mama. Duré Eri'aza hã Matãhã mama. Duré Matã hã Zacoho mama, ta hã. ");
INSERT INTO xavNT_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Zaco hã Zuzéhé mama. Zuzé hã Marizaha mro. Mariza hã, Zezusihi na, ta hã. Zezusi hã, ta hã Cristu, 'Re ĩhâimana u'âsi mono te te ĩpisudu, Danho'reptui'wa da, da te 're ĩsisi za'ra mono. ");
INSERT INTO xavNT_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Ãne hã 14 na dahi'rata norĩ hâiba za'ra hã, Abra'ãhã hawimhã, Dawihi u hã. Duré 14 na dahi'rata norĩ hâiba za'ra hã Dawihi hawimhã, Izarazéhé nhihudu norĩ, da te ĩsimroi mono zéb u hã, Babironiza u. Duré 14 na dahi'rata norĩ hâiba za'ra hã Izarazéhé nhihudu norĩ, da te ĩsimroi mono zém hawimhã, Cristu ĩpotozéb u hã. ");
INSERT INTO xavNT_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Tawamhã ãne Zezu Cristuhu potozé hã: Mariza hã Zezusi, ãma ĩna da hã ma tô sima ropisutu zahuré Zuzéhé me, sina mro zahuré da. Tane nherẽ, sina mro zahuré õ ré, ma tô 'Re ĩhâimana u'âsi mono pẽ'ẽzani na tiwasã Mariza hã, te te sa'rese õ nherẽ. ");
INSERT INTO xavNT_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Tawamhã aibâ hã Marizaha ãma ĩmro da hã 're morĩ wẽ di, Zuzé na ĩsisi hã. Ta hã marĩ ĩwẽ si te te 're 'manharĩ u'âsi. Taha wa, ma tô sima rosa'rata, ãma ĩmro da ropisudu hã pi'uriwi za te te siwi ĩpari na hã, duré danho'a ĩwasété na te te ãma hiri wa, da te dasiwi waihu'u za'ra tõ da. ");
INSERT INTO xavNT_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Ãne na te te sima rosa'rata wamhã, hâiwa hawi Wanhib'apito ma romhuri'wa hã ma tô tãma sihâi'ré, sõtõ 'rowi. Ãne te tãma tinha: — Zuzé, Dawihi nhihudu, asina aihâtâ'â tõ, Marizaha ãma aimro tõ da hã. Ta hã ma tô tiwasã, 'Re ĩhâimana u'âsi mono pẽ'ẽzani na. ");
INSERT INTO xavNT_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Ĩ'ra hã 'watébrémi na te za tãma podo. Tawamhã Zezusi na te za ĩsisi. Danho'reptui'wa te wasu'u, ĩsisi hã. Taha si te za tinhib'a'uwẽ hã te te 're anho'reptu, ĩwasété hawi, duré 'Re ĩhâimana u'âsi mono te te 're ĩdahâ za'ra mono zém hawi. ");
INSERT INTO xavNT_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","23","Ãne da hã ma tô pisutu, Zezusihi ma, 'Re ĩhâimana u'âsi mono hã duréihã tizadawa wasu'u 'rata 'wai ma, Iza'izaha ma, te te ĩwaihu'uzém na te te ãma uwaimrami da. Ãne ma tô tãma waihu'u, duréihã: “Pi'õi ubuni hã te za tiwasã. Duré ĩ'ra hã te za tãma waptãrã, aibâ na. Taha nhisi hã za, Emanuwé na ĩsisi hã.” ('Re ĩhâimana u'âsi mono, wasiré 're ĩmorĩ u'â, te wasu'u, ĩsisi hã.) Ãne 'Re ĩhâimana u'âsi mono te te ãma ĩrowaihu'uzé hã, duréihã. ");
INSERT INTO xavNT_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Tawamhã Zuzé hã utu wamhã, hâiwa hawi Wanhib'apito ma romhuri'wa te te tãma ĩwaihu'uzéb zarina, ma tô ãma timro oto, Marizaha ãma, awa'awi. ");
INSERT INTO xavNT_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Tane nherẽ, Zuzé hã te te sima ãma rosa'rata õ di a'â Marizaha ãma, ĩ'ra tãma waptã'ã õ ré. Taré te ĩré 'madâ. Tawamhã ĩ'ra tãma waptã'ã wamhã, Zuzé hã ma tô sisi, Zezusi na. ");
INSERT INTO xavNT_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Tawamhã Zezusi hã ma tô podo, Berẽ na 'ri nho'õmo nhisi ãma, Zudeza na danhipti'a nho'õmo nhisi ãma. Apito Erodi hã, Izarazéhé nhihudu norĩ te te 're 'madâ'â za'ra mono ré, ma waptãrã. Waptã'ã parip si, ma tô wasi na romnhoré'wa norĩ hã aihutu Zeruzarẽ u, bâtâ pusizém hawi, rowaihu'u pese 'wa norĩ hã. ");
INSERT INTO xavNT_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Tawamhã te sô anharĩ za'ra, Zezusihi zô: — E mahãta 'watébrémi, zudezu norĩ nhib'apito da, ĩpodo hã. Wa norĩ hã wa tô 'madâ'â za'ra ni, wasi hã, bâtâ pusizém niwĩmhã, zudezu norĩ nhib'apito da, ĩpotozé te te ĩwasu'u hã. Taha wa, wa we ai'aba'ré ni, ãma wawata za'ra da. — Ãne ma tô sô anharĩ za'ra. ");
INSERT INTO xavNT_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Tawamhã apito Erodi te te wapari wamhã, hâtâ'â uptabi di, uburé Zeruzarẽ ãma 're ĩdasi'ubumroi mono norĩ zama. ");
INSERT INTO xavNT_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Tawamhã apito Erodi hã ma tô 'rã'õtõ, 'Re ĩhâimana u'âsi mono ma, da'ãma romhuri'wa ĩpire norĩ hã, duré ĩsimiroti na rob'ui'éré 'rata na dama rowahutu'wa norĩ hã te te sadanharĩ za'ra da: — E mame te za waptãrã, 'Re ĩhâimana u'âsi mono te te ĩpisudu hã, Danho'reptui'wa da. — Ãne te sadanharĩ za'ra. ");
INSERT INTO xavNT_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Tawamhã ma ãma sada'âbâ za'ra: — Berẽ na 'ri nho'õmo nhisi ãma te za waptãrã, Zudeza na danhipti'a nho'õmo nhisi ãma. Duréihã 'Re ĩhâimana u'âsi mono zadawa wasu'u 'rata 'wa hã ma tô ãne na ãma rob'ui'éré siro, 'Re ĩhâimana u'âsi mono mreme na: ");
INSERT INTO xavNT_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","“A norĩ wa'wa hã Berẽ ãma 're aihâimana za'ra wa'aba mono norĩ hã Zudaha nhihudu norĩ nhipti'ai ãma 're aihâimana za'ra wa'aba mono norĩ hã dama aiwapu na 're aihâimana za'ra wa'aba mono newa, te za oto dama asisi za'ẽtẽ na dama 're aihâimana u'âsi za'ra wa'aba mo. E marĩ wa. Tame danhib'apito da hã za poto wa, ĩ̱nhib'a'uwẽ norĩ hã te te 're ab'madâ'â pese mono da, Izarazéhé nhihudu norĩ hã.” Ãne duréihã ma tô ãma rob'ui'éré siro, 'Re ĩhâimana u'âsi mono zadawa wasu'u'wa hã. ");
INSERT INTO xavNT_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Tawamhã Erodi hã ma tô sô tihârâ za'ra, bâtâ pusizém hawi ĩsihutu norĩ zô, pi'uriwi te te sadanharĩ za'ra da, ta norĩ hã: — E mahãna ma tô wasi hã watobro. — Ãne te sadanharĩ za'ra. ");
INSERT INTO xavNT_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Te te sadanharĩ za'ra pari, ma tô tãma rob'ru za'ra, Berẽ u si'aba'ré da. Ãne te duré tãma rob'ru za'ra: — Mo oto ai'aba'réi wa'aba, 'watébrémi zô asinharĩ pese za'ra wa'aba da. Sõpẽtẽ za'ra wa'aba wamhã, ma'ãpé apâ we asiwi ĩ̱po're pu'u aba za, te waihu'u da, ĩtẽme ĩ̱morĩ da duré wa hã, ãma ĩ̱wata da, ĩ̱zama. — Ãne ma tô tãma waihu'u za'ra, apito Erodi hã. ");
INSERT INTO xavNT_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Tawamhã apito mreme te te wapari za'ra parimhã, robzabui'wa norĩ hã te oto ai'aba'ré, Berẽ u. Tawamhã bâdâdi na si'aba'réi ré, ma tô wasi hã 'madâ'â za'ra, tô õ hã tirob ãma ré te te ĩ'madâ'â za'ra hã. Te ĩsõwa timorĩ za'ra. Tawamhã ma tô oto mazazâ. 'Watébrémi ĩsãmrazém nho'õmoi baba, te oto za, wasi hã. ");
INSERT INTO xavNT_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Tawamhã aibâ norĩ hã wasi te te 'madâ'â za'ra wamhã, toi uptabi za'ra di. Taha wa, te 're to za'ra. ");
INSERT INTO xavNT_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Tawamhã 'ri para u ma tô asisi. Sisisi wamhã, ma tô sabu za'ra 'watébrémi hã, ĩna ĩré sãmra ré, Mariza hã. Tawamhã hi'rãtitõ ma tô asimro, ãma wata za'ra da. Taha pari, ma tô 'ridawa za'ra, tinhimiro'wapézéb za'ra hã. Ma tô ãma sawi za'ra, tinhoprub za'ra zém na; ẽtẽ'ubuzi pré oru hã, duré wedewati ĩsadaze hã, duré wedewati ĩsadaze si'u'ẽne hã. Taha na ma tô tãma tinhoprub za'ra. ");
INSERT INTO xavNT_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Tawamhã rosawẽrẽ na ma tô 'Re ĩhâimana u'âsi mono hã tãma waihu'u za'ra, bâtâ pusizém hawi ĩsihutu norĩ ma, apâ si'aba'ré tõ da, Erodihi u. Taha wa, te bâdâdi amo na apâ ai'aba'ré, tirob u. ");
INSERT INTO xavNT_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Tawamhã aibâ norĩ si'aba'ré za'u si, ma tô hâiwa hawi Wanhib'apito ma romhuri'wa hã Zuzéhé ma sihâi'ré, sõtõ 'rowi. Ãne te tãma rowasu'u: — Apito Erodi hã ma tô dama rob'ru, ai'uté zô danhopré mono da, ĩsadawa para da te wĩrĩ da. Taha wa, te za oto ai'u. Ai'uté hã sa'ra na. Duré ĩna zama ĩré saprõni Ezitu u, tame a'â ĩré aimasisi aba da, dawi. Tawamhã apâ we ĩ'ane wa'aba zéb da hã, wa hã te aima ĩwaihu'uzéb zô si, te za asina asimipa. — Ãne ma tãma waihu'u, hâiwa ãma romhuri'wa hã. ");
INSERT INTO xavNT_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Tawamhã Zuzé hã ma tô udu. Utu wamhã, awa'awi ma tô ai'utére hã sa'ra. Ĩna hã ma tô ĩré saprõ barana, Ezitu u. ");
INSERT INTO xavNT_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Tawamhã tame te oto ĩré aimasisi zahuré, apito Erodi hã ĩdâ'âzéb u. Ãne ma tô tiromhâiba, duréihã 'Re ĩhâimana u'âsi mono, tizadawa wasu'u 'rata 'wai ma, te te ĩwaihu'uzém na te te sina uwaimrami da. Ãne ma tô tãma waihu'u siro: “Wa hã ĩ̱'ra, wa satõ, Ezitu hawi morĩ da.” Ãne duréihã 'Re ĩhâimana u'âsi mono mreme hã, ti'ra ãma hã. ");
INSERT INTO xavNT_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Tawamhã apito Erodi hã aibâ norĩ, bâtâ pusizém hawi we ĩsi'aba'ré norĩ hã pi'uriwi tiwi ĩsi'aba'ré na te te ãma rowaihu'u za'ra wa, ma tô ab'rui pese. Sib'rui wa, tãma da'wapéi'wa norĩ hã ma tô satõrĩ za'ra Berẽ u, 'watébrémi zô si'aba'ré da, uburé te te dawi uprosi mono da, maparane ãma ĩwahu mono õ hã, Berẽ ãma 're ĩdahâimana za'ra mono norĩ 'ra hã, duré Berẽ 'rata 're ĩdahâimana za'ra mono norĩ 'ra zama. Aibâ norĩ hã wasi te te ĩ'madâ'â za'ra zém na te te tãma ĩwaihu'u za'ra zéb zarina, ma tô apito Erodi hã ãne 'manha. ");
INSERT INTO xavNT_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Ãne ma tô tiromhâiba, duréihã 'Re ĩhâimana u'âsi mono zadawa wasu'u 'rata 'wa te te ĩrowasu'uzéb zarina, Zeremiasi hã. Ma tô ãne ãma rob'ui'éré siro, 'Re ĩhâimana u'âsi mono mreme na: ");
INSERT INTO xavNT_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“Rama na romnhisi ãma hã dawawa hã ma tô wapari za'ra ni, dazadari 'rãihâ hã. Raté hã te aiwa'õ, ti'ra norĩ ãma. Pẽ'ẽzé uptabi wa, te te sima wẽ õ di, da te ĩpẽ'ẽtété da hã, ĩ'ra norĩ hã uburé tiwi si'utõrĩ wa.” Ãne ma tô Zeremiasi hã rowasu'u. ");
INSERT INTO xavNT_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Tawamhã apito Erodi dâ'â parimhã, ma tô hâiwa ãma Wanhib'apito ma romhuri'wa hã Zuzéhé ma sihâi'ré, sõtõ 'rowi, Ezitu ãma sãmra ré. ");
INSERT INTO xavNT_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","Ãne te tãma tinha: — Oto ai'utu. 'Watébrémi hã oto subzari aba. Ĩna ĩré saprõni, Izarazéhé nhihudu norĩ nhipti'ai u. Aibâ norĩ hã 'watébrémi te te aré siwi wĩrĩ da, sô ĩsi'aba'ré norĩ hã ma tô tidâ'â za'ra. — Ãne te tãma rowasu'u. ");
INSERT INTO xavNT_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Tawamhã Zuzé hã utu wamhã, ma tô apâ saprõni zahuré 'watébrémi hã, ĩna me, Izarazéhé nhihudu norĩ nhipti'ai u. ");
INSERT INTO xavNT_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Tane nherẽ, ma tô wapa Aterazu, apito Erodihi 'ra wasu'u hã, timama nhowa're're ĩsébré na hã Zudeza ãma te te 're ĩda'ab'madâ'â mono da hã. Taha wa, pahi di, tame ĩré 're ĩhâimana zahuré mono da hã. Tawamhã sõtõ 'rowi ma tô tãma waihu'u na sahu, hâiwa ãma 'Re ĩhâimana u'âsi mono ma romhuri'wa hã, Zuzéhé ma, Zudeza u neb zahuré tõ da, Darireza na danhipti'a nho'õmo nhisi u si neb da. Taha wa, ma tô tamomop si tineb zahuré, Zuzé norĩ hã. ");
INSERT INTO xavNT_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Tame te oto 're simasisi zahuré, Nazaré na 'ri wa'õtõ nhisi ãma. Ãne ĩromhâimanazé hã, duréihã 'Re ĩhâimana u'âsi mono zadawa wasu'u 'rata 'wa norĩ nhimi'ui'éré hã te te ãma uwaimrami da. Ãne duréihã ĩwasu'u na rob'ui'éré 'rada hã: “Ta hã Nazaré ãma 're ĩsãmra mono na te za oto da te 're sisi za'ra.” Ãne ma tô waihu'u sirõmo za'ra, za da te dasima 're ĩwasu'u za'ra mono zéb da na hã. ");
INSERT INTO xavNT_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Tawamhã wahub ahâ na ãma wahu pari, ma tô Zuwã Batita hã mo a'ubuni u, Zudeza na danhipti'a nho'õmo nhisi ãma, 'Re ĩhâimana u'âsi mono zadawa wasu'u na te te dama ãma sãna'rata da. ");
INSERT INTO xavNT_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","Ãne te dama rowasu'u: — Ma'ãpé, aiwasété wi aipizari za'ra wa'aba. 'Re ĩhâimana u'âsi mono, da'ãma 're ĩsib'a'uwẽ mono zéb u hã romhuture di oto. — Ãne te dama rowahutu, Zuwã Batita hã. ");
INSERT INTO xavNT_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Duréihã Iza'iza hã ma tô Zuwã Batitaha ãma rob'ui'éré siro, 'Re ĩhâimana u'âsi mono zadawa wasu'u 'rata 'wa hã. Ãne ĩsimi'ui'éré hã: “Ni'wa hã te za te te dama 're rob'mahârâ, a'ubuni wi: Bâdâdi hã asiwi ropese aba, Wanhib'apito zô. Ĩmana 'rãmi bâdâdi hã sô sa'ra wa'aba, awa'awi da.” Ãne ma tô Iza'iza hã ãma rob'ui'éré, romhâ ré. ");
INSERT INTO xavNT_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Zuwã hã awaru ba'õmore zéré 'manharĩ na te 're si'uza. Duré romhâ 'manharĩ hâiwaré na te 're si'usisi. 'Riti na si te 're sa. Duré rom na ropĩni na zama te 're sa. ");
INSERT INTO xavNT_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Tawamhã Zeruzarẽ ãma 're ĩdasi'ubumroi mono norĩ hã, duré Zudeza na danhipti'a nho'õmo nhisi ãma daza'rui mono bâ 're ĩdahâimana za'ra mono hã, duré Zodã pa nhisi 'rata 're ĩdahâimana za'ra mono norĩ zama, ma tô ĩtẽme 're dasito, daro mono bâ. Ĩsimirowasu'u hã da te 're wapari za'ra mono da, ma tô ĩtẽme 're dasito. ");
INSERT INTO xavNT_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Taha wa, dawasété na ma tô 're dasiwẽ'õ za'ra 'râwi, sõ'awi, 'Re ĩhâimana u'âsi mono ma. Dawasété na 're dasiwẽ'õ za'ra mono sidâpâsi, ma tô Zuwã Batita hã â dawabzuri hã te te dama 're ab'manharĩ, Zodã pa ãma. ");
INSERT INTO xavNT_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Tawamhã Zuwã hã ma tô 'madâ'â za'ra, parisezu norĩ hã ahâ uptabi na, duré sadusezu norĩ hã. Te ĩtẽme ai'aba'ré, â dawabzuri te te dame 'manharĩ za'ra da. Tawamhã Zuwã hã te te 'madâ'â za'ra wamhã, te tãma nharĩ za'ra, parisezu norĩ ma: — A norĩ wa'wa hã wahi ne te 're anomro aba mo. E 'wa simiroti zarina, te we ĩ̱tẽme ai'aba'réi wa'wa bété, â dawabzuri si ĩ'manharĩ za'ra wa'aba zém na, 'Re ĩhâimana u'âsi mono nhimihâzé wi, asisõ'reptu za'ra wa'aba da bâ, aiwasédé hã rẽme za'ra wa'aba õ nherẽ. ");
INSERT INTO xavNT_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Sena na aiwasédé hã ĩrẽme za'ra wa'aba zém na, da te 're aiwaihu'u za'ra wa'aba mono da, te za oto 're anomro wẽ wa'aba mo. ");
INSERT INTO xavNT_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Duré Abra'ãhã nhihudu wẽ te, asina 're rosa'rata za'ra wa'aba mono õ di za, 'Re ĩhâimana u'âsi mono te te 're ĩ'aihâ za'ra wa'aba mono õ na hã. 'Re ĩhâimana u'âsi mono ma, waihu'u pese di, ã ẽtẽ norĩ ma, te te nharĩ da, tãma si'a'uwẽ za'ra da, Abra'ãhã nhihudu oto 're hâimana za'ra mono da, ẽne hã. ");
INSERT INTO xavNT_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Hâtâra hã te za oto ni'wa hã sarõtõ, wedepa nhihârizéb da hã. Uburé wede hã 're ĩ'rãi pese za'ra mono õ hã te za te te ãma 're anhihâri. Tawamhã unhama u te za te te 're anhamra. — Ãne te dama ãma simiré'é Zuwã hã, 'Re ĩhâimana u'âsi mono nhimihâzém na hã. ");
INSERT INTO xavNT_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Te duré dama tinha: — Wa hã wa tô â uptabi na si te 're aihâiba ubu za'ra wa'wa, â dawabzuri hã te aima 're ab'manharĩ aba mono wamhã, aiwasété wi 're aipizari za'ra wa'aba mono zém na, da te oto ãma 're aiwaihu'u za'ra wa'aba mono da. Tane nherẽ, ĩ̱za'u si te za ĩ̱ma ĩpire uptabi hã wei wi. Taha si te za oto 'Re ĩhâimana u'âsi mono pẽ'ẽzani na te te duré 're aihâiba ubu za'ra wa'wa, unhama ne na zama, â na te aima 're ĩ'ab'manharĩ aba mono ne hã. Ta hã ĩ̱ma pire uptabi wa, ĩpara'uza hã te tãma mrami waihu'u õ di za, tãma ĩ̱wapure wa. ");
INSERT INTO xavNT_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Wei morĩ wapsi, te za da'ãma aipo'o. Buru nho, da te 're upõrĩ za'ra mono parimhã, te za da te 're sa'wari za'ra, ĩsa'warizéb 're. Tawamhã ĩtomhâ na te za da te ãma 're ro'o za'ra. Ĩro hã sa'ẽtẽ nherẽ, da te wĩrĩ waihu'u õ di za. Tane ĩ̱ma ĩpire hã wei morĩ wapsi, te za da'ãma aipo'o, tridu upõrĩ za'wari ne, ĩtomhâ za'wari ne. — Ãne ma tô dama rowasu'u, Zuwã Batita hã. ");
INSERT INTO xavNT_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Tawamhã Zezusi hã ma tô mo, Darireza na danhipti'a nho'õmo nhisi hawi, Zodã pa u, tame Zuwã Batita, â dawabzuri hã te te tãma 'manharĩ da. ");
INSERT INTO xavNT_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Tane nherẽ, ma tô pibu Zuwã Batita hã, ĩsimirosa'rada hã te te tiwi ãma saprĩ da, â dawabzuri te te tãma 'manharĩ tõ da. Ãne te tãma tinha: — E marĩ da, te ĩ̱ma aipire uptabi nherẽ, ĩ̱ma asi'ru, â dawabzuri hã te aima 'manharĩ da. A hã te aré ĩ̱ma ĩ'manha. ");
INSERT INTO xavNT_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Tawamhã Zezusi hã asa te tãma tinha: — Tane tô. Ĩbâ ma te asina ĩ̱ma ĩwaihu. Tane nherẽ, te za ĩ̱ma ĩ'manha, 'Re ĩhâimana u'âsi mono te te wama ĩpisutuzéb zarina, wa te wasina uwaimrami da. — Ãne ma tô tãma waihu'u Zezusi hã, Zuwã Batitaha ma. Taha wa, Zuwã hã ma tô ãma saze. Ma tô â dawabzuri hã tãma 'manha, Zezusihi ma. ");
INSERT INTO xavNT_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Tawamhã â dawabzuri te te tãma 'manharĩ pari, ma tô â hawi watobro, Zezusi hã. Watobro wi, ma tô hâiwa hã tãma si'ridawa. Tawamhã Zezusi hã ma tô tisã, 'Re ĩhâimana u'âsi mono pẽ'ẽzani hã we ĩtẽme ĩmorĩ hã hâiwa hawi, utu'u ne hã. Tawamhã ma tô ãma za. ");
INSERT INTO xavNT_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Tawamhã hâiwa hawi te we ãma tinha: — Ã hã ĩ̱'ra. Ĩ̱ma sawi uptabi di. Tãma ĩ̱to za'ẽtẽ uptabi di. — Ãne te we tinha, Ĩmama hã. ");
INSERT INTO xavNT_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Tawamhã 'Re ĩhâimana u'âsi mono pẽ'ẽzani hã ma tô Zezusi hã saprõ a'ubuni u, tame Wa'uburé hã te te nasi pibu da. ");
INSERT INTO xavNT_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Tawamhã a'ubuni wi sãmra ré, ma tô bâdâ hã 40 na ãma ai'utõ, sai ãna sãmra ré hã. 40 na ma duré ãma timara. Tãma mrab uptabi di. ");
INSERT INTO xavNT_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Tawamhã Wa'uburé ma tô ĩtẽme wi. Ĩtẽme wisi wamhã, te tãma tinha: — Sena a hã 'Re ĩhâimana u'âsi mono 'ra wamhã, ma'ãpé ẽtẽ ma nharĩ, ĩ'u'ẽtẽ wapu na aima si'manharĩ za'ra da. ");
INSERT INTO xavNT_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Tawamhã Zezusi asa te tãma tinha, ãne: — 'Re ĩhâimana u'âsi mono mreme na rob'ui'éré hã ãne: “Dasa na si 're danhiptete za'ra mono õ di za. 'Re ĩhâimana u'âsi mono te te dama 're ĩ'awaihu'u mono zém na zama, te za 're danhiptete za'ra.” — Ãne te tãma tinha, Zezusi hã. ");
INSERT INTO xavNT_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Taha pari, Wa'uburé hã ma tô Zezusi hã saprõ Zeruzarẽ u, 'ri nho'u ĩwẽ uptabi u, te te duré pibu da. 'Re ĩhâimana u'âsi mono ãma 're ĩdawata za'ra mono zéb u, te saprõ, 'ri nhisi u, sab da hâimo, 'ri 'rãihâ uptabi nhisi. ");
INSERT INTO xavNT_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Tawamhã ãne te tãma tinha, Wa'uburé hã: — Sena a hã 'Re ĩhâimana u'âsi mono 'ra wamhã, ma'ãpé atobro, ti'ai u. 'Re ĩhâimana u'âsi mono, te za, u, hâiwa hawi we atẽme satõrĩ za'ra, tãma ĩromhuri'wa norĩ hã, te te ai'madâ'â za'ra da. Tinhib'rata na te za, u, siwi asapa, ẽne hã te te ai'u'a õ'umnhasite, aipara wi. Ãne 'Re ĩhâimana u'âsi mono zadawa wasu'u'wa nhimi'ui'éré hã, duréihã, ĩbaihâ na hã. ");
INSERT INTO xavNT_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Tawamhã Zezusi hã te asa tãma tinha: — Mare di. “Asib'apito za'ra wa'wa hã, 'Re ĩhâimana u'âsi mono hã marĩ hã te te aima 're pisutu za'ra wa'aba mono õ nherẽ, 're pibu za'ra wa'aba mono õ di za, ta hã te te 're aipawaptob za'ra wa'aba mono zô.” Ãne duré ĩmreme na rob'ui'éré, ĩbaihâ na hã. — Ãne te Zezusi hã tãma tinha. ");
INSERT INTO xavNT_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Taha pari, te duré Wa'uburé Zezusi hã saprõ, ẽtẽ 'rãihâ u, danhib'apito norĩ nhipti'ai mono bâ te te rob'madâ'â mono da, uburé ro ĩwẽ uptabi hã te te ab'madâ'â mono da. ");
INSERT INTO xavNT_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Tawamhã Wa'uburé te ãne tãma ropisutu, Zezusihi ma: — Asib'apito na ĩ̱'ãma aiwata da, te za aihi'rãtitõ ĩ̱ma aime. Tawamhã ã hã uburé wa za aima tisõ, ate da. ");
INSERT INTO xavNT_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Tawamhã Zezusi te asa tãma tinha: — Satanasi, mo oto aimorĩ, ĩ̱nhiti. 'Re ĩhâimana u'âsi mono zadawa wasu'u'wa, ma tô ãne rob'ui'éré: “Uburé Danhib'apito uptabi ãma si, te za 're aiwata za'ra wa'aba mo, 'Re ĩhâimana u'âsi mono ãma si. Taha ma si te za 're ĩromhuri za'ra wa'aba mo, Asib'apito za'ra wa'aba ma si.” Ãne ĩmreme na rob'ui'éré, ĩbaihâ na hã. — Ãne te rob'ui'éré 'rada hã tãma 'rãzarõtõ Zezusi hã, Satanasihi ma. ");
INSERT INTO xavNT_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Tawamhã Wa'uburé ma tô ĩhawi mo. Morĩ wamhã, hâiwa ãma romhuri'wa norĩ hã ma tô we ĩtẽme aihutu, te te siwi pawaptob da, Zezusi hã. ");
INSERT INTO xavNT_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Tawamhã Zezusi hã Zuwã da te ĩsẽrẽzé wasu'u te te wapari wa, ma tô mo, Darireza na danhipti'a nho'õmo nhisi u. ");
INSERT INTO xavNT_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Tawamhã Nazaré ãma 're ĩsãmra mono da hã, te te sima rowẽ õ di oto. Taha wa, Capana'u na 'ri nho'õmo nhisi u si ma tô mo, tame oto 're sãmra mono da, Darireza ãma ĩsõ'u zapoto 'rata, Zeburõhõ nhihudu norĩ nhipti'a niwĩ, duré Naptarihi nhihudu norĩ nhipti'a niwĩ. ");
INSERT INTO xavNT_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Ãne ma tô Zezusi hã 'manha, duréihã Iza'iza hã te te ãma ĩrob'ui'érézéb zarina te te sina uwaimrami da, 'Re ĩhâimana u'âsi mono zadawa wasu'u 'rata 'wa hã. Ãne ĩsimi'ui'éré hã 'Re ĩhâimana u'âsi mono mreme na: ");
INSERT INTO xavNT_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","16","“Zeburõhõ nhihudu norĩ nhipti'ai ãma 're ĩdahâimana za'ra mono, duré Naptarihi nhihudu norĩ nhipti'ai ãma zama, ĩsõ'u tẽme bâdâdi wa, 're ĩdahâimana za'ra mono hã, Zodã na pa nhisi zara niwĩ 're ĩdahâimana za'ra mono hã, Darireza ãma zudezu'õ norĩ hã dawazari 're ĩhâimana za'ra mono norĩ hã te uburé robra na 're dahâimana za'ra. Tane nherẽ, te za oto rowa'a za'ẽne hã da te 're 'madâ'â za'ra, tame. Te za oto dama rowa'a, dapẽ'ẽ 're robra na 're ĩdanomro mono norĩ ma.” Ãne Iza'izaha nhimi'ui'éré wasu'u hã, Zeburõhõ nhihudu norĩ 're ĩhâimana za'ra mono norĩ ãma hã, Naptarihi nhihudu norĩ ãma zama. ");
INSERT INTO xavNT_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Tawamhã ta hawim haré ma oto romhuri na sãna'rata Zezusi hã, Timama zadawa wasu'u na. Ãne ma tinhimirowasu'u na dama ãma sãna'rata: — Aiwasété wi te za oto 're aipizari za'ra wa'aba mo. Ãhãna bâdâ hã ma tô oto ĩwa waptãrã, 'Re ĩhâimana u'âsi mono hã da'ãma 're ĩsib'a'uwẽ mono zéb da hã. ");
INSERT INTO xavNT_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Tawamhã Zezusi hã Darireza na ĩsõ'u nhisi zaihâi baba 're morĩ wamhã, ma tô aibâ norĩ hã sãmri zahuré, tepe mrami na romhuri'wa norĩ hã, tisisãnawãi me: Sima na ĩsisi hã, Pedru na ĩsisi amo hã. Duré ĩno hã Ãdéré na ĩsisi hã. Ĩsõ'ui wa, te nasi abazipara hã wabzuri zahuré, tepe zô. ");
INSERT INTO xavNT_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Tawamhã Zezusi hã te sô tihârâ zahuré: — We ane wa'aba, ĩ̱siré 're ane wa'aba da oto, romhuri na aima ĩ̱sisanho wa'aba da, ĩ̱ma 're ĩda'awaibui wa'aba mono zéb da hã. — Ãne te sô tihârâ zahuré, Zezusi hã. ");
INSERT INTO xavNT_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Taha wa, ma te awa'awi tãma marẽme zahuré abazipara ma, Zezusihi siré 're neb zahuré da oto. ");
INSERT INTO xavNT_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Tawamhã syry na sina pahâ wi, ma duré 'madâ'â zahuré, Ti'adu norĩ hã Zuwãhã me. Ta norĩ hã Zebedehe 'ra zahuré. Timama siré te abazipara sisinarĩ hã te te ãma a'rã'õtõ zahuré apâ, uba're wa. Tawamhã te duré sô tihârâ zahuré. ");
INSERT INTO xavNT_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Sô hârâ zahuré wamhã, awa'awi ma tô tinhimiromhuri ma marẽme zahuré. Timama zama ma rẽme zahuré, Zezusihi siré 're neb zahuré da. ");
INSERT INTO xavNT_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Tawamhã daza'rui mono bâ te 're mo Zezusi hã, Darireza na danhipti'a nho'õmo nhisi ãma hã. Zudezu norĩ te, rowahutuzé mono bâ, ma tô te te dama 're rowahutu. 'Re ĩhâimana u'âsi mono, da'ãma 're ĩsib'a'uwẽ mono zé wasu'u na te duré te te dama 're rowasu'u, ĩwasu'uwẽ na. Dahâzé mono bâ ma duré da'apese. Hâzé u'âsi wa, sib'uware na 're ĩnomro mono norĩ zama ma apese, Zezusi hã. ");
INSERT INTO xavNT_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Tawamhã Zezusi te te ĩda'apesezém na, ma tô rowasu'u hã te te ropé, Siriza na danhipti'a nho'õmo nhisi ãma. Taha wa, ma tô ĩtẽme da te 're 'wasari dahâzé mono bâ, uburé aimawi hã dahâzé da te 're ĩsépata za'ra mono norĩ hã, wa'uburé te te 're ĩwamnarĩ za'ra mono norĩ hã, duré da'rã siwamnarĩ wa, 're ĩdahâiba popo'o za'ra mono norĩ hã, duré ĩmorĩ'õ norĩ hã. Uburé ma tô da'apese, Zezusi hã. ");
INSERT INTO xavNT_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Taha wa, ma tô da'ahâ uptabi na ĩsarina dasi'ré, Darireza hawi, duré Decapori hawimhã, duré Zeruzarẽ hawimhã, duré Zudeza na danhipti'a nho'õmo nhisi hawimhã. Duré Zodã pa zara niwĩ 're ĩdasi'ubumroi mono norĩ zama ma tô ĩtẽme dasito. ");
INSERT INTO xavNT_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Tawamhã Zezusi hã da'ahâ uptabi na te te da'madâ'â wamhã, ẽtẽ 'rãihâ na ma tô sai'u, tame a'â sãmra da. Tawamhã ĩsiré 're ĩnomro mono norĩ hã ma tô 'râwi ĩtẽme ubumro. ");
INSERT INTO xavNT_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Tawamhã tame ma tô Zezusi hã tinhimirowahutu na tãma sãna'rata za'ra, ãne: ");
INSERT INTO xavNT_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","— Ni'wam norĩ hã umnhasi sina 'râwi 're ĩsipawapto waihu'u za'ra mono õ na 're siwaihu'u za'ra mono wamhã, duré 'Re ĩhâimana u'âsi mono si za ta norĩ hã ĩ'upana te te 're ĩpawapto wẽ za'ra mono na te te sina 're waihu'u za'ra mono wamhã, ta norĩ si te za rowẽ na 're hâimana za'ra, ãma 're sib'a'uwẽ za'ra mono wa. ");
INSERT INTO xavNT_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","— Duré, ni'wam norĩ hã ti'ab ré dawasété u'âsi 're danomro mono wa, da'ãma 're ĩpẽ'ẽzé za'ra mono norĩ hã ta norĩ ma si tãma 're rowẽ za'ẽtẽ za'ra mono di za. Ta norĩ ma si te za 'Re ĩhâimana u'âsi mono hã te te tãma 're pisutu za'ra, toi u'âsi 're ĩhâimana za'ra mono zéb da hã. ");
INSERT INTO xavNT_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","— Duré, ni'wam norĩ hã tiwaihu'u pese na 'râwi 're ĩsi'madâ'â ze za'ra mono õ norĩ hã, 'Re ĩhâimana u'âsi mono si te te sima 're ĩ'madâ'â za'ra mono norĩ hã, ta norĩ ma si, tãma 're rowẽ za'ẽtẽ za'ra mono di za. Ta norĩ ma si te za 'Re ĩhâimana u'âsi mono hã ĩwẽ hã te te 're tãma anhomri, te te tãma 're ĩropisutu za'ra mono zéb zarina. ");
INSERT INTO xavNT_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","— Duré, ni'wam norĩ hã 'Re ĩhâimana u'âsi mono te te sima 're ĩwẽ za'ra mono zéb uwaibaba, uburé marĩ ĩwẽ hã te te tãma 're ĩ'manharĩ za'ra mono da si, te te sima 're wẽ za'ra mono wamhã, ta norĩ ma si, tãma 're rowẽ za'ẽtẽ za'ra mono di za. Ta norĩ ma si, te za 'Re ĩhâimana u'âsi mono hã te te tãma ãma 're a'uwaimrami, rowẽ te te tãma 're ĩ'apisutu mono zém na hã. ");
INSERT INTO xavNT_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","— Duré, ni'wam norĩ hã da'ãma 're ĩpẽ'ẽzé za'ra mono zéb zarina, da'ãma 're ĩsina mono norĩ hã, ta norĩ ma si, tãma 're rowẽ za'ẽtẽ za'ra mono di za. Ta norĩ ãma si te za 'Re ĩhâimana u'âsi mono hã ãma tipẽ'ẽzé za'ra, za da'ãma ĩsipo'ozéb ãma hã. ");
INSERT INTO xavNT_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","— Duré, ni'wam norĩ hã marĩ wasété zô 're sipizari za'ra mono ãna 'Re ĩhâimana u'âsi mono ma si, tãma 're ĩsihâiba nhomri u'âsi za'ra mono norĩ hã ta norĩ ma si, tãma 're rowẽ za'ẽtẽ za'ra mono di za. Ta norĩ si te za titõmo na 'Re ĩhâimana u'âsi mono hã te te 're 'madâ'â za'ra, 'râwi. ");
INSERT INTO xavNT_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","— Duré, rowẽ na dasiré 're dahâimana za'ra mono da, ni'wam norĩ hã tinhimiroti wẽ na te te 're dapawaptob u'âsi za'ra mono wamhã, ta norĩ ma si, tãma 're rowẽ za'ẽtẽ za'ra mono di za. Ta norĩ si te za ti'ra na te te 're sisi za'ra, 'Re ĩhâimana u'âsi mono hã. ");
INSERT INTO xavNT_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","— Duré, ni'wam norĩ hã 'Re ĩhâimana u'âsi mono te te sima 're ĩwẽ za'ra mono zéb zarina, uburé marĩ ĩwẽ hã te te 're 'manharĩ za'ra mono da si, te te sima 're wẽ za'ra mono wa, da te tãma 're ĩrob'manharĩ wasété za'ra mono norĩ ma si, tãma 're rowẽ uptabi za'ra mono di za. E marĩ wa. 'Re ĩhâimana u'âsi mono hã ta norĩ ãma 're sib'a'uwẽ za'ra mono wa. — Ãne ma tô Zezusi hã tãma rowasu'u za'ra, tisiré 're ĩnomro mono norĩ ma. ");
INSERT INTO xavNT_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","Tawamhã ãne te duré tãma rowahutu za'ra: — Ĩ̱zazei'wa oto 're anomro aba mono wa, da te ai'ãma 're wasété za'ra wa'aba mono nherẽ, duré da te aima 're rob'manharĩ wasété za'ra wa'aba mono nherẽ, duré dazadawa nhipese na taré da te dama 're aiwasu'u wasété za'ra wa'aba mono nherẽ, ĩ̱wi 're aipizari za'ra wa'aba mono õ wamhã, aima 're rowẽ uptabi za'ra wa'aba mono di za. ");
INSERT INTO xavNT_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Taha wa, ma'ãpé atoi u'âsi, ãma 're anomro aba mono za. 'Re ĩhâimana u'âsi mono hã te za marĩ ĩwẽ hã sa'ẽtẽ na te te aima 're sõmri za'ra wa'wa, hâiwa ãma asô 're ĩsimi'wara aba mono hã. Duréihã 'Re ĩhâimana u'âsi mono zadawa wasu'u 'rata 'wa norĩ ma, ma tô da te tãma 're rob'manharĩ u'âsi za'ra, da te aima 're ĩrob'manharĩ wasété za'ra wa'aba mono ne. — Ãne na ma tô Zezusi hã tãma waihu'u sirõmo za'ra romhâ ré, te te waihu'u zara da. ");
INSERT INTO xavNT_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Tawamhã ãne te duré tãma rowasu'u za'ra, tisiré 're ĩnomro mono norĩ ma: — Ãne wa za duré aima ãma romnhimiré'é za'ra wa'wa. A norĩ wa'wa hã sa ne, te za dama 're aihâimana za'ra wa'aba mo. Sa na hã dasa hã ãma se ti, dasai warĩrĩzé wa. Tane nherẽ, oto 're se si'utõrĩ za'ra mono wamhã, niha da te 'manharĩ waihu'u õ di, apâ se da, dasa da te ãma 're ĩwarĩrĩ za'ra mono da hã. Marĩ dai õ di oto, dama hã. Taré te za da te 're sa'wari za'ra rob u, marĩ dai õ wa oto. Taha wa, te za oto taré ĩsisiwi 're danomro, dapara na. Tane duré, a norĩ wa'wa hã ĩ̱zadawa wasu'u na dama 're romhuri wẽ za'ra wa'aba mono nherẽ, oto romhuri hã 're sahâri za'ra wa'aba mono wamhã, marĩ dai õ di oto, 're aihâimana za'ra wa'aba mono zé hã za, ĩ̱ma hã. ");
INSERT INTO xavNT_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","— Ãne wa za duré aima ãma romnhimiré'é za'ra wa'wa. A norĩ wa'wa hã rob'uiwẽzém ne, te za dama 're aihâimana za'ra wa'aba mo. 'Re dasimani za'ra mono tõ da, da te dasima 're ĩrob'uiwẽ za'ra mono ne, te za 're ĩdanhimroi wẽ wa'aba mo, 'Re ĩhâimana u'âsi mono u. 'Rinho'u hã sa'a nhisiwi, da te 're ĩ'ri za'ra mono hã dawi 're simani waihu'u za'ra mono õ di. 'Madâ'â pese di, dama hã. Tane duré, a norĩ wa'wa hã dawi 're aimani waihu'u za'ra wa'aba mono õ di za. Sõ'awi te za dama 're ĩ̱wasu'u wẽ u'âsi za'ra wa'aba mo. ");
INSERT INTO xavNT_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Duré, rob'uiwẽzé hã da te ro'o wamhã, e piza'a na te za upsibi ni. Mare di. Ĩsima'warazém na si te za sõ'awi da te 're sõré, 'ri paramhã te te dama 're rob'uiwẽ za'ra mono da, 'ri 're, 're ĩdasi'ubumroi mono norĩ ma. ");
INSERT INTO xavNT_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Tane duré, a norĩ wa'wa hã te za sõ'awi dama 're aihâimana za'ra wa'aba mo, rob'uiwẽzé hã sõ'awi te te dama 're ĩrob'uiwẽ za'ra mono ne. Uburé marĩ hã te za dama 're ĩ'manharĩ wẽ u'âsi za'ra wa'aba mo, dama 're ĩ'manharĩ wẽ za'ra wa'aba mono zé hã da te 're ĩ'madâ'â za'ra mono zéb zarina, Aimama za'ra wa'aba ãma 're dawata za'ra mono da, hâiwa ãma 're ĩsãmra mono ãma. ");
INSERT INTO xavNT_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","— Duré, rosa'rata na ĩ̱'ãma upa za'ra wa'aba õ di za, duréihã 'Re ĩhâimana u'âsi mono nhimiroti 'rata na Mozési te te ãma ĩrob'ui'érézé hã, duré ĩsadawa wasu'u 'rata 'wa norĩ nhimiroti zama, te dawi sawi da, we ĩ̱morĩ na hã ti'ai u. Ta norĩ nhimirowasu'u 'rada hã te dawi ĩsawi da hã, we ĩ̱morĩ õ di. Mare di. 'Re ĩhâimana u'âsi mono nhimiroti 'rata na rob'ui'éré hã te ĩ̱sina ĩ'uwaimrami da si, wa wei mo. ");
INSERT INTO xavNT_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Tô sena, wa za ãne aima waihu'u sirõmo za'ra wa'wa. Hâiwa norĩ hã ti'ai me nimahã na si'utõrĩ zahuré da nherẽ, duréihã 'Re ĩhâimana u'âsi mono nhimiroti 'rata na rob'ui'éré hã pire na te za tô dama 're hâimana u'âsi. Nima hã dawi 'masi'utõrĩ waihu'u õ di za, ĩ'ui'éré misi hã, duré ĩ'ui'éré 'rãzazazé hã, ĩwaptẽrẽ mono bâ. Za niha dama 're ĩromhâimana mono zéb da hã, ĩbaihâ na duréihã ĩsadawa wasu'u'wa norĩ te te ãma ĩrob'ui'éré sirõmo za'ra zéb zarina, rob'rãsutuzéb u za niha dama 're romhâimana uptabi za'ra mono õ ré, si'utõrĩ za'ra õ di za, ĩsimiroti na rob'ui'éré 'rata norĩ hã. ");
INSERT INTO xavNT_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Duré, ni'wam norĩ hã 'Re ĩhâimana u'âsi mono nhimiroti 'rata na rob'ui'éré hã nima hã roti hã taré dama 're 'maihâimana mono newa, te te 're 'madâ'â za'ra mono õ wamhã, duré ĩsine da te 're 'madâ'â tõ za'ra mono da, te te dama ãma 're roti za'ra mono wamhã, ta norĩ si te za dama wapu na 're hâimana za'ra, 'Re ĩhâimana u'âsi mono, da'ãma 're ĩsib'a'uwẽ mono zéb ãma hã. Tane nherẽ, ni'wam norĩ si ĩsimiroti na rob'ui'éré 'rada hã te te 're 'madâ'â pese za'ra mono wamhã, duré ĩsine da te 're 'madâ'â pese za'ra mono da, te te dama ãma 're roti za'ra mono wamhã, ta norĩ si te za dama pire na 're hâimana za'ra, da'ãma 're ĩsib'a'uwẽ mono zéb ãma hã. ");
INSERT INTO xavNT_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Ãne wa za duré aima waihu'u za'ra wa'wa. Parisezu norĩ hâimanazém nhipai u, duré 'Re ĩhâimana u'âsi mono nhimiroti na rob'ui'éré na dama rowahutu'wa norĩ hâimanazém nhipai u, Wamama te te sima 're ĩ'aiwẽ za'ra wa'aba mono zéb zarina si, 're aihâimana wẽ za'ra wa'aba mono wamhã, tawapsi, te za dame 're asisisi aba mo, 'Re ĩhâimana u'âsi mono, da'ãma 're ĩsib'a'uwẽ mono zéb u hã. ");
INSERT INTO xavNT_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","— Ãne hã ma tô duré 're ĩwapari za'ra wa'aba mo, duréihã 'Re ĩhâimana u'âsi mono te te dama ĩrotizé hã: “'Re danhimroi wa'aba mono õ di za. Ni'wam norĩ hã te te 're danhimroi mono wamhã, te za dawasété na dawaihu'u'wa norĩ u da te 're simro, ta norĩ hã ĩwasété na te te siwi 're waihu'u za'ra mono wa, te te dama 're 'ru za'ra mono da, da te dasiwi 're simroi mono da.” Ãne duréihã aihi'rata norĩ wa'aba ma, ma tô roti. ");
INSERT INTO xavNT_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Ãne na roti hã tô sena nherẽ, wa za oto wa hã aimawi aima waihu'u za'ra wa'wa, ãne na roti na hã. Ni'wam norĩ hã tisiré 're ĩhâimana za'ra mono norĩ da, 're siti'ru za'ra mono wamhã, ta norĩ hã te za 'Re ĩhâimana u'âsi mono hã te te siwi 're awẽ'õ, ĩwasété na te te 're ĩ'awaihu'u mono zéb zarina. Duré ãté ni'wa hã te za tisiré ma tinha, ãne: “A hã, marĩ da, 're aihâimana mono õ.” Ãne ni'wam norĩ hã te te dama 're nharĩ za'ra mono wamhã, te za da te 're simro, zudezu norĩ ma roti'wa norĩ u, dawasété na dawaihu'u'wa norĩ tẽme, ta norĩ hã te te siwi 're wẽ'õ za'ra mono da, ĩwasété na te te siwi 're waihu'u za'ra mono wa. Duré ni'wa hã ãté ãne te za tisiré ma tinha: “E niha asimiza'rese'õ a hã, 'Re ĩhâimana u'âsi mono wasu'u na hã.” Ãne ni'wam norĩ hã tisiré ma, te te 're nharĩ za'ra mono wamhã, ãté ta norĩ hã te za ropipa u 're sisisi, unhama ro'o u'âsi u. ");
INSERT INTO xavNT_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","24","Ãté a norĩ wa'wa hã te za 're anomro aba mo, 'Re ĩhâimana u'âsi mono nhorõwa u, marĩ hã tãma asõprubzéb da hã, wedeza ne nhisiwi 're sa'ra za'ra wa'aba mono da, tãma danhoprubzé nomrizé nhisiwi. Tawapsi ãté te za asina 're aipo're pu'u za'ra wa'aba mo, marĩ hã asiré ma, 're 'manharĩ wasété za'ra wa'aba mono wa, asisada 're aihâimana za'ra wa'aba mono zém na hã. Ãne wa, te za a'â asisô 're ĩsa'ra wa'aba mo, 'Re ĩhâimana u'âsi mono ma, asõprubzé hã wedeza ne nho're, asiré u a'â asitẽme 're anomro aba mono da, asima 're asiwasu'u za'ra wa'aba mono wa, apâ duré asina 're asiwadi za'ra wa'aba mono da. Taha parip si te za apâ 're anomro aba mo, 'Re ĩhâimana u'âsi mono nhorõwa u, tãma asõprubzé hã oto tãma 're sõmri za'ra wa'aba mono da. ");
INSERT INTO xavNT_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","— Ãté ni'wa hã te za sima ai'ãma rosa'rata 'wa, dama rowairébé'wai u te te ai'mazaprõni aba da, marĩ tiwi ĩ'mai'manharĩ wasété aba zém na te te tãma ai'maiwasu'u wa'aba da. Ãne wamhã, te te ai'mazaprõni aba õ ré, te za tãma ai'masiwasu'u wa'wa, te te ãma ai'mazazei wa'aba wa, dama rowairébé'wa norĩ u, te te ai'mazaprõni aba tõ da, damrami'wai ma, te te ai'mai'rui wa'aba tõ da, dazazéb 're, da te ai'manherẽ aba tõ da. ");
INSERT INTO xavNT_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Dazazéb 're, da te ai'manherẽ aba wamhã, marĩ hã dawi ĩ'mai'manharĩ wasété aba wa'rãmi, dama asi'maiwa'âbâ 'rãsutu pese aba õ nherẽ, ta hawi ai'maiwatobro waihu'u aba õ di za. Tô sena, wa ãne na hã aima rowasu'u za'ra wa'wa. ");
INSERT INTO xavNT_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","— Ãne hã ma tô duré 're ĩwapari za'ra wa'aba mo, duréihã 'Re ĩhâimana u'âsi mono te te dama ĩrotizém na hã: “Aimro na asiwi 're asipsaihuri za'ra wa'aba mono õ di za.” ");
INSERT INTO xavNT_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Ãne na roti hã tô sena nherẽ, wa za oto wa hã aimawi aima roti za'ra wa'wa, tô õhõ na roti na hã. Ni'wam norĩ hã pi'õ, titõmo na te te 're 'madâ'â ze za'ra mono wa, te te 're waibui mono da, te te sima ãma 're rosa'rata za'ra mono wamhã, taha na zama te za tiwasédé hã te te 're 'manharĩ za'ra, tinhimirosa'rata na si nherẽ. ");
INSERT INTO xavNT_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Duré marĩ hã atõmo nhimire niwĩm na 're 'madâ'â za'ra wa'aba mono wa, aiwasédé hã 're waibui wa'aba mono wamhã, tawamhã atõmo nhimire niwĩ asiwi 're sani za'ra wa'aba mono wa, romhâ na asisiti 're ĩsãmra aba mono ne, te za oto 're anomro wẽ wa'aba mo. Ato hã sahuré aima 're hâimana za'ra wa'aba mono õ nherẽ, aima 're rowẽ uptabi za'ra wa'aba mono di za. Aihâiba wahuré ré, duré atõmo zahuré ré, 'Re ĩhâimana u'âsi mono hã ropipa u, te te 're asãmra aba mono wamhã, aima 're rowẽ za'ra wa'aba mono õ di za. ");
INSERT INTO xavNT_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Duré, asib'rata nhimire niwĩm na aiwasédé hã 're waibui wa'aba mono wamhã, asiwi 're sihâri za'ra wa'aba mono wa, romhâ na asisiti 're ĩsãmra aba mono ne, te za oto 're anomro wẽ wa'aba mo. Asib'rada hã sahuré aima 're hâimana za'ra wa'aba mono õ nherẽ, aima 're rowẽ uptabi za'ra wa'aba mono di za. Aihâiba wahuré ré, duré asib'rata zahuré ré, ropipa u 're asisisi aba mono wamhã, aima 're rowẽ za'ra wa'aba mono õ di za. ");
INSERT INTO xavNT_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","— Duréihã 'Re ĩhâimana u'âsi mono te te duré dama ĩrotizé hã, ãne: “Aibâ norĩ hã timro te te 're rẽme za'ra mono õ ré, te za rob'ui'éré hã te te tãma 're sõmri za'ra, za te te ĩrẽmezém na. Taha parip si, te za oto timro hã te te 're rẽme za'ra, pibu pese na.” Ãne duréihã Mozési te te ãma ĩrob'ui'érézé hã, ãne na hã. ");
INSERT INTO xavNT_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Ãne na roti hã tô sena nherẽ, wa za oto wa hã aimawi aima waihu'u za'ra wa'wa, tô õhõ na roti na hã. Pi'õ norĩ hã aibâ aimawi na 're sipsaihuri za'ra mono õ nherẽ, ĩmro te te 're rẽme za'ra mono wamhã, tiwasédé hã te za te te 're 'manharĩ za'ra, aibâ norĩ hã. E marĩ wa. Pi'õ norĩ hã ĩmro te te 're rẽme za'ra mono nherẽ, aibâ aimawi na duré apâ 're mro zahu za'ra mono wamhã, tawapsi te za tiwasédé hã te te 're 'manharĩ za'ra, pi'õ norĩ hã. Taha wa, aibâ norĩ hã tiwasédé te te tãma 're ĩ'manharĩ za'ra mono zém hawi wa, te za duré õ norĩ zama aibâ aimawi na 're mro za'ra mono wa, tiwasédé hã te te 're 'manharĩ za'ra. Duré aibâ norĩ hã, pi'õ, da te 're ĩrẽme za'ra mono na 're mro za'ra mono wamhã, tawapsi, te za duré ta norĩ zama tiwasédé hã te te ãma 're 'manharĩ za'ra, aibâ norĩ hã. ");
INSERT INTO xavNT_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","— Ãne hã ma tô duré 're ĩwapari za'ra wa'aba mo, duréihã 'Re ĩhâimana u'âsi mono te te dama ĩrotizém na Mozési te te ãma ĩrob'ui'érézé hã: “'Re ĩhâimana u'âsi mono nho'a, marĩ na dama 're ropisutu za'ra wa'aba mono wamhã, te za tô dama ãma 're ĩ'uwaimrami za'ra wa'aba mo.” Ãne duréihã 'Re ĩhâimana u'âsi mono te te dama ĩrotizém na rob'ui'éré hã. ");
INSERT INTO xavNT_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","35","Ãne na roti hã tô sena nherẽ, wa za oto wa hã aimawi aima waihu'u za'ra wa'wa, tô õhõ na roti na hã. Marĩ pire na taré dama 're ropisutu za'ra wa'aba mono õ di za oto, 'Re ĩhâimana u'âsi mono nho'a. Mare di. Duré ãne na dama 're ropisutu za'ra wa'aba mono õ di za: “Hâiwa hã tô sena wahuré 're ĩsa'wari mono ne, wa duré wa hã tô sena aima ropisutu.” Ãne wasu'u zarina taré dama 're ropisutu za'ra wa'aba mono õ di za. E marĩ wa. Hâiwa hã taré hã 're ĩhâimana mono õ wa, tame 'Re ĩhâimana u'âsi mono hã 're sãmra u'âsi mono wa, ta hawi te te we duré 're da'ab'madâ'â mono wa. Duré ãne na dama 're ropisutu za'ra wa'aba mono õ di za: “Ti'a hã tô sena wahuré 're ĩsa'wari mono ne, wa duré wa hã tô sena aima ropisutu.” Ãne wasu'u zarina taré dama 're ropisutu za'ra wa'aba mono õ di za. E marĩ wa. Ti'a zama pire wa, 'Re ĩhâimana u'âsi mono te si wa. Duré ãne na dama 're ropisutu za'ra wa'aba mono õ di za: “Zeruzarẽ na 'ri nho'õmo nhisi hã tô sena 're ĩsa'wari mono ne, wa duré wa hã tô sena aima ropisutu.” Ãne wasu'u zarina taré dama 're ropisutu za'ra wa'aba mono õ di za. E marĩ wa. Ta hã 'Re ĩhâimana u'âsi mono te si wa duré, uburé Danhib'apito uptabi te si wa. ");
INSERT INTO xavNT_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Duré ãne na dama 're ropisutu za'ra wa'aba mono õ di za: “Ĩ̱'rã hã tô sena ĩ̱ma 're ĩhâimana mono ne, wa duré wa hã tô sena aima ropisutu.” Ãne wasu'u zarina taré dama 're ropisutu za'ra wa'aba mono õ di za. E marĩ wa. Ai'rã za'ra wa'wa hã ate za'ra wa'aba õ wa, 'Re ĩhâimana u'âsi mono te si wa. Asi'uihâ na aséré hã asima 're 'rãdâ'â waihu'u za'ra wa'aba mono õ di. Duré asi'uihâ na 're asiséré'a waihu'u za'ra wa'aba mono õ di. ");
INSERT INTO xavNT_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Marĩ hã dama 're 'manharĩ za'ra wa'aba mono da, asina dama 're ropisutu za'ra wa'aba mono wamhã, ãne si te za dama 're ĩnharĩ za'ra wa'aba mo: “Ĩhe. Wa za tô 'manha.” Duré marĩ hã dama 're 'manharĩ za'ra wa'aba mono da, asima 're wẽ za'ra wa'aba mono õ wamhã, ãne si te za duré dama 're ĩnharĩ za'ra wa'aba mo: “Mare di. Wa hã te 'manharĩ õ di za.” Ãne si te za dama 're ĩnharĩ za'ra wa'aba mo. Ãne si dama 're nharĩ za'ra wa'aba mono õ wamhã, Wa'uburé nhimiwada'uri zarina te za aiwasédé hã 're ĩ'manharĩ za'ra wa'aba mo. ");
INSERT INTO xavNT_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","— Ãne hã ma tô duré 're ĩwapari za'ra wa'aba mo, duréihã 'Re ĩhâimana u'âsi mono te te dama ĩrotizém na hã: “Ni'wam norĩ hã te te 're datõmo wamnarĩ za'ra mono wamhã, te za asa da te 're tõmo wamnarĩ za'ra ĩwa'rãmi, aiwab da. Duré ni'wam norĩ hã da'wa te te dawi 're prub za'ra mono wamhã, te za duré asa ĩwa'rãmi da te 're 'waprub za'ra, aiwab da.” Ãne na duréihã roti hã. ");
INSERT INTO xavNT_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Tane nherẽ, wa za duré wa hã aimawi aima waihu'u za'ra wa'wa, tô õhõ na rotizém na hã. Da te aima 're rob'manharĩ wasété za'ra wa'aba mono nherẽ, asa dama ãma 're wa'rãmi za'ra wa'aba mono õ di za. Atob'rata nhimire niwĩ da te 're aihâ za'ra wa'aba mono wamhã, dama ãma 're wa'rãmi za'ra wa'aba mono õ di za. Taré te za 're aipizari za'ra wa'aba mo, atob'rata amo niwĩ, da te duré 're aihâ za'ra wa'aba mono da. ");
INSERT INTO xavNT_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Ãté ni'wa hã te za ai'ãma wa'aba sima rosa'rata, dawasété na dawaihu'u'wa norĩ u te te ai'mazaprõni aba da, marĩ tiwi ĩ'mai'manharĩ wasété aba zém na te te tãma ai'maiwasu'u wa'aba da. Tawamhã ãté te za tãma ai'maiwasu'u wa'wa, ta norĩ hã te te aima 'maipisutu aba da, asõ'utu'u ĩwa'âbâ syryre hã ĩwa'rãmi tãma 'manhomri aba da, tiwi ĩ'mai'manharĩ wasété aba wa'rãmimhã. Ãne wamhã, te te aiwi 'mai'âri aba wamhã, asi'ubuzéb zama te za tãma ĩ'manhomri 'wa, wa'âbâ za'ẽtẽ nherẽ, te te aiwi 'maiwaptẽrẽ õ nherẽ. ");
INSERT INTO xavNT_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Duré, ni'wam norĩ hã bâdâdi na marĩ hã misi ti'ai pibuzém na tãma 're 'wasari aba mono da, te te aima 're 'ru za'ra wa'aba mono wamhã, asi'uihâ na te za asima 're ĩwẽ za'ra wa'aba mo, taha nhipai u, maparane ti'ai pibuzém na tãma 're 'wasari aba mono da a'â. ");
INSERT INTO xavNT_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Duré marĩ hã da te aiwi 're waptẽrẽ za'ra wa'aba mono wamhã, te za dama 're ĩsõmri za'ra wa'aba mo. Duré marĩ hã asibro hã taré a'â da te aiwi 're waptẽrẽ za'ra wa'aba mono wamhã, dawi 're sawi za'ra wa'aba mono õ di za, asimarĩ 'wa hã. Te za tô taré dama 're ĩsõmri za'ra wa'aba mo, a'â. ");
INSERT INTO xavNT_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","— Ãne hã ma tô duré 're ĩwapari za'ra wa'aba mo: “Asiré 're aihâimana za'ra wa'aba mono norĩ si te za 're ĩsawi pese za'ra wa'aba mo. Ai'ruiwapari'wa norĩ si te za asa asiwi 're ĩwẽ'õ pese za'ra wa'aba mo.” ");
INSERT INTO xavNT_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Tane nherẽ, wa za duré wa hã aimawi aima waihu'u za'ra wa'wa, tô õhõ na rotizém na hã. Ai'ruiwapari'wa norĩ hã te za 're ĩsawi pese za'ra wa'aba mo. Duré te te aima 're ĩrob'manharĩ wasété za'ra wa'aba mono norĩ ãma, te za 're aimreme zusi aba mo, 'Re ĩhâimana u'âsi mono ma, ĩwẽ si te te tãma 're apisutu mono da, ta norĩ ma. ");
INSERT INTO xavNT_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Ãne te za dama 're ĩ'manharĩ za'ra wa'aba mo, Aimama aba 'ra na sena na da te 're aiwaihu'u za'ra wa'aba mono da, hâiwa ãma 're ĩsãmra mono 'ra na. E marĩ wa, te za ai'ruiwapari'wa norĩ hã 're ĩsawi pese za'ra wa'aba mo. Ni'wai ma, ĩsawi hã te te ba'a õ wa, 'Re ĩhâimana u'âsi mono hã. Uburé te te 're da'azawi pese, te te 're ĩsawi pese za'ra mono norĩ hã, duré te te 're ĩsawi õ za'ra mono norĩ zama. Aiwapsi te bâdâ hã te te dama 're rob'uiwẽ za'ra, 're ĩnomro wẽ mono norĩ ma, duré 're ĩnomro wasété mono norĩ ma zama, 'Re ĩhâimana u'âsi mono nhimipisutuzéb zarina. Aiwapsi te duré tã hã dama 're ta'a za'ra, 'Re ĩhâimana u'âsi mono nhimiroti te te 're ĩ'madâ'â pese za'ra mono norĩ ma, duré te te 're ĩwapari za'ra mono õ norĩ ma zama, ĩsimipisutuzéb zarina. ");
INSERT INTO xavNT_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Rob'uiprazé ubumroi'wa norĩ hã bété. Ta norĩ hã dawi 're sipsaihuri u'âsi za'ra mono wa, te 're nomro wasété. Ta norĩ hã te tizawi pese 'wa norĩ si te te 're sawi za'ra. Tawamhã asawi pese 'wa norĩ si, 're sawi pese za'ra wa'aba mono wamhã, e te za 'Re ĩhâimana u'âsi mono hã ĩwẽ hã te te aima 're sõmri za'ra wa'wa. Mare di. Ĩwẽ hã te te aima 're sõmri za'ra wa'aba mono õ di za. ");
INSERT INTO xavNT_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Duré 'Re ĩhâimana u'âsi mono waihu'u'õ'wa norĩ hã te te 're saze za'ra mono õ nherẽ, te tisiwadi norĩ ma, marĩ ĩwẽ hã te te tãma 're 'manharĩ za'ra, siré 're ĩhâimana za'ra mono norĩ ma hã. A norĩ wa'wa hã bété, asiré 're aihâimana za'ra wa'aba mono norĩ ma si, marĩ ĩwẽ hã tãma 're 'manharĩ za'ra wa'aba mono wamhã, aiwapsi te aiwasété na dame 're aihâimana za'ra wa'aba mo, 'Re ĩhâimana u'âsi mono waihu'u'õ'wa norĩ siré. ");
INSERT INTO xavNT_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Taha wa, te za a norĩ wa'wa hã uburé 're ĩdazawi pese za'ra wa'aba mo, 'Re ĩhâimana u'âsi mono hã te te da'ãma 're a'upai mono ãna, uburé te te 're ĩda'azawi pese mono ne. ");
INSERT INTO xavNT_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","— 'Re ĩhâimana u'âsi mono ãma, 're aiwata za'ra wa'aba mono da, marĩ hã dama 're ĩ'manharĩ wẽ za'ra wa'aba mono zém na hã ãma 're aihâimana za'ra wa'aba mono õ di za, danho'a hã, ãne na hã taré da te 're ai'madâ'â wẽ za'ra wa'aba mono zô. Asimiza'rese te za 're anomro aba mo, ãne hã 're 'manharĩ za'ra wa'aba mono tõ da. Ãne hã danho'a 're 'manharĩ za'ra wa'aba mono wamhã, Aimama 'wa hã hâiwa ãma 're ĩhâimana mono hã tinhoprubzé ĩwẽ uptabi hã te te aima 're sõmri za'ra wa'aba mono õ di za, marĩ ĩwẽ hã 're ĩ'manharĩ za'ra wa'aba mono zé wa'rãmimhã. ");
INSERT INTO xavNT_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","— Taha wa, ĩsibrob'õ norĩ ma, marĩ hã tãma 're ĩsõmri za'ra wa'aba mono zém na, da te 're aiwẽsãmri za'ra wa'aba mono da, dama 're asiwasu'u za'ra wa'aba mono õ di za, ãne na hã. Ãne hã te ni'wam norĩ hã te te dama 're 'manharĩ za'ra, 'Re ĩhâimana u'âsi mono ãma 're ĩdawata za'ra mono zéb 're, 'ri 're, duré 'ri nhi'riti na 're ĩdahâimana za'ra mono norĩ ma zama. 'Re hâimana wẽ za'ra mono newa, te ta norĩ hã ãma 're dawata za'ra mono zô, ãne hã te te dama 're 'manharĩ za'ra. Tawamhã, ãma 're dawata za'ra mono wamhã, taha na si te za tô ãma 're hâimana za'ra. 'Re ĩhâimana u'âsi mono nhoprubzé hã nimahã bâtâ na hã tãma 're hâimana za'ra mono õ di za. Tô sena, wa ãne hã aima waihu'u sirõmo za'ra wa'wa. ");
INSERT INTO xavNT_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","4","Taha wa, ni'wai wi, marĩ zô 're rowaptâ'â mono wa, 're pawaptob za'ra wa'aba mono wamhã, sõ'awi 're pawaptob za'ra wa'aba mono õ di za, da te ãma 're aiwaihu'u za'ra wa'aba mono tõ da, marĩ na 're ĩpawaptob za'ra wa'aba mono zém na hã. Dama 're ĩrob'manharĩ wẽ za'ra wa'aba mono zém na hã, da te 're ai'madâ'â za'ra wa'aba mono õ nherẽ, te Aimama aba si te te ai'ãma 're 'madâ'â za'ra wa'wa. Taha wa, te za taha si ĩwẽ hã te te aima 're sõmri za'ra wa'wa, ĩwa'rãmi. ");
INSERT INTO xavNT_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","— Duré ni'wam norĩ hã te te sima 're ĩwẽ za'ra mono zéb zarina, te danho'a 're mreme zusi, 'Re ĩhâimana u'âsi mono ma. Hâiwi 're simasa mono sina, te 'Re ĩhâimana u'âsi mono ãma 're ĩdawata za'ra mono zéb ãma, 're mreme zusi, 're hâimana wẽ za'ra mono newa, da te 're 'madâ'â wẽ za'ra mono da. 'Ri nhi'riti wa, bâdâdi sitob ãma, te duré ãne 're mreme zusi, da'ahâ norĩ nho'a. Tawamhã, da te 're 'madâ'â wẽ za'ra mono wa, ãma 're dawata za'ra mono wamhã, taha na si te za tô ãma 're hâimana za'ra. Nimahã na hã 'Re ĩhâimana u'âsi mono nhoprubzé hã tãma 're ĩhâimana za'ra mono da hã, mare uptabi di za, ta norĩ ma hã. Tô sena wa ãne na aima waihu'u sirõmo za'ra wa'wa. ");
INSERT INTO xavNT_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Duré, a norĩ wa'wa hã 'Re ĩhâimana u'âsi mono ma, 're aimreme zusi aba mono da, te za 'ri para u 're asisisi aba mo, asõrõwa 'ri 're wa'wa u. Tawamhã te za asiré 're ĩ'ridawa nhitob za'ra wa'aba mo, Aimama aba ma, 're aimreme zusi aba mono da, romnhiwasi nimahã bâtâ na da te 're ĩ'madâ'â waihu'u za'ra mono õ ma hã. Ãne wamhã, aihâiba pisutu 're aimreme zusi aba mono ré, Aimama aba si te te ai'ãma 're 'madâ'â za'ra wa'aba mono wa, te za taha si ĩwẽ hã te te aima 're sõmri za'ra wa'wa, ĩwa'rãmi. ");
INSERT INTO xavNT_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","— Duré, 'Re ĩhâimana u'âsi mono ma, 're aimreme zusi aba mono wamhã, taré aimreme na 're sahu ahâ za'ra wa'aba mono õ di za apâre, 'Re ĩhâimana u'âsi mono hã te te 're aiwapari za'ra wa'aba mono õ newa. 'Re ĩhâimana u'âsi mono waihu'u'õ'wa norĩ si te timreme na te te tãma 're sahu u'âsi za'ra taré, taha zarina si te te 're pawaptob za'ra mono da newa. ");
INSERT INTO xavNT_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Taha wa, ta norĩ ne 're aimreme zusi aba mono õ di za. E marĩ wa. Aimama aba wi, marĩ hã tiwi 're waptẽrẽ za'ra wa'aba mono õ ré, marĩ zô aiwi 're ĩrowaptâ'â za'ra wa'aba mono zé hã, te te 're awaihu'u sirõmo mono wa. ");
INSERT INTO xavNT_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Ãhã zarina si te za 're aimreme zusi aba mo, 'Re ĩhâimana u'âsi mono ma: “Wamama, hâiwa ãma 're asãmra mono hã, asisi wẽ na uburé da te 're aiwaihu'u za'ra mono da, wa aima da'ãma 're ĩ̱mreme. ");
INSERT INTO xavNT_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Uburé da'ãma 're asib'a'uwẽ mono da, wa duré da'ãma 're ĩ̱mreme. Hâiwa ãma aima romhuri'wa norĩ hã, asima 're ĩwẽ mono zéb zarina si, te te 're ĩ'aiwapari pese za'ra mono ne, ti'ai ãma uburé da te duré 're aiwapari pese za'ra mono da, wa da'ãma 're ĩ̱mreme. ");
INSERT INTO xavNT_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Ã bâtâ na, wei wama 're anhomri mono, wasa hã ãma 're ĩwasaihuri mono zéb da hã. ");
INSERT INTO xavNT_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Dawasédé hã da te wa'ãma 're 'manharĩ za'ra mono wa, wa te wasina 're ĩ'madâ'â za'ra mono õ ne, a hã duré wa'ãma 're ab'madâ'â mono õ di za, wawasédé hã. ");
INSERT INTO xavNT_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Duré, 're wa'ab'madâ'â nhimini mono õ di za, Wa'uburé hã te te 're wa'a'upi mono wa, wawasété u 're warere'e tõ mono da. Ma'ãpé, 're wa'anho'reptui u'âsi mono, ĩwasété uptabi wi.” Ãne si te za Aimama aba wi, 're ĩrowaptẽrẽ za'ra wa'aba mo. — Ãne ma tô Zezusi hã tãma waihu'u za'ra, tisiré 're ĩnomro mono norĩ ma. ");
INSERT INTO xavNT_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","15","Tawamhã ãne te duré tãma roti za'ra: — Dawasédé hã da te ai'ãma 're ĩ'manharĩ za'ra wa'aba mono zé hã asina 're 'madâ'â u'âsi za'ra wa'aba mono wamhã, Aimama 'wa hã te za duré uburé aiwasédé hã 're ĩ'manharĩ za'ra wa'aba mono zé hã te te ai'ãma 're 'madâ'â u'âsi za'ra wa'wa. Dawasédé hã da te ai'ãma 're 'manharĩ za'ra wa'aba mono nherẽ, asina 're 'madâ'â za'ra wa'aba mono õ wamhã, tawapsi, aiwasédé hã te te ai'ãma 're 'madâ'â za'ra wa'aba mono õ di za Aimama 'wa hã, hâiwa ãma 're ĩsãmra mono hã. ");
INSERT INTO xavNT_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","— 'Re ĩhâimana u'âsi mono ma, 're aimreme zusi aba mono da, asai ãna a'â 're aihâimana za'ra wa'aba mono wamhã, ai'ubu pire na 're aihâimana za'ra wa'aba mono õ di za. Ni'wam norĩ si te za ubu pire na sai ãna 're mreme zusi, 're nomro wẽ mono newa, da te 're 'madâ'â wẽ za'ra mono da. Tawamhã, da te 're 'madâ'â wẽ za'ra mono wa, ãma 're dawata za'ra mono wamhã, taha si te za tô tãma 're hâimana za'ra. Nimahã na 'Re ĩhâimana u'âsi mono nhoprubzé hã tãma 're hâimana za'ra mono õ di za, ta norĩ ma hã. Tô sena wa ãne na hã aima waihu'u sirõmo za'ra wa'wa. ");
INSERT INTO xavNT_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","18","Taha wa, a norĩ wa'wa hã 'Re ĩhâimana u'âsi mono ma, 're aimreme zusi aba mono da, asai ãna a'â 're aihâimana za'ra wa'aba mono wamhã, te za taré â na 're asi'ubu upsõ za'ra wa'aba mo, tô 're aihâimana za'ra wa'aba mono zém na 're aihâimana za'ra wa'aba mono da. Te za duré taré 're asiwarĩrĩ za'ra wa'aba mo, a'â asai ãna 'Re ĩhâimana u'âsi mono ma, 're aihâimana za'ra wa'aba mono zém na, da te 're aiwaihu'u za'ra wa'aba mono tõ da, Aimama aba si te te 're aiwaihu'u za'ra wa'aba mono da, datõmo na da te 're ĩ'madâ'â waihu'u za'ra mono õ si. Ãne wamhã, aihâiba pisutu, asai ãna a'â tãma 're aimreme zusi aba mono ré, Aimama aba si te te ai'ãma 're 'madâ'â za'ra wa'aba mono wa, te za ĩwẽ hã te te aima 're sõmri za'ra wa'wa, ĩwa'rãmi. ");
INSERT INTO xavNT_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","— Marĩ ĩwa'âbâ za'ẽne hã asima si 're ubumroi pese za'ra wa'aba mono õ di za, ti'a 're anomro aba mono ré hã. Ti'ai ãma marĩ na 're ĩdanhimarĩ za'ra mono hã si'utõrĩ pese di, dawi 're u're su'u za'ra mono wa, duré zazahâi hâzapu'u'wa hã te te dawi 're hâiwasété za'ra mono wa. Ĩsipsaihuri norĩ hã te za duré dawi sô 're sisisi, dawi 're sipsaihuri za'ra mono da, danhimarĩ na. ");
INSERT INTO xavNT_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Hâiwa ãma asimarĩ za'ra wa'wa hã ĩsi'utõrĩ'õ zô si te za asima 're ĩrob'ruiwapari za'ra wa'aba mo, 'Re ĩhâimana u'âsi mono, ĩwẽ uptabi hã te te asô 're ĩ'madâ'â pese za'ra wa'aba mono zô si. Tame marĩ hã dawi 're u're waihu'u za'ra mono õ di. Zazahâi hâzapu'u'wa hã te te duré dawi 're hâiwasété waihu'u za'ra mono õ di. Duré ĩsipsaihuri norĩ hã dawi 're sipsaihuri waihu'u za'ra mono õ di, tamemhã. ");
INSERT INTO xavNT_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Ti'ai ãma asimarĩ ahâ zô si 're rob'ruiwapari za'ra wa'aba mono wamhã, taha na si te za aipẽ'ẽ 're, asima 're ĩrosa'rata u'âsi za'ra wa'aba mo, hâiwa ãma ĩwẽ hã ĩsi'utõrĩ'õ upana. Duré hâiwa ãma ĩwẽ uptabi zô si, asima 're rob'ruiwapari za'ra wa'aba mono wamhã, taha na si te za asima 're ĩrosa'rata u'âsi za'ra wa'aba mo, 'Re ĩhâimana u'âsi mono, ĩwẽ te te asô 're ĩ'apisutu aba mono zô si. ");
INSERT INTO xavNT_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","23","— Rob'uiwẽzé hã te za da te dasima 're ro'o za'ra, dama rob'madâ'â pibu pese da. Tane duré, dato hã aiwa rob'uiwẽzém ne. Datõmo wẽ wamhã, dama rob'madâ'â pese di. Datob'a wamhã, dama rob'madâ'â waihu'u õ di. Tane duré, a norĩ wa'wa hã asimirosa'rata wẽ za'ra wa'aba wamhã, te za rowa'a na ne 're aihâimana u'âsi za'ra wa'aba mo. Duré, asimirosa'rata wasété za'ra wa'aba wamhã, robra na ne te za 're aihâimana za'ra wa'aba mo. ");
INSERT INTO xavNT_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","— Dama romhuri'wa hã ĩsib'apito maparane wamhã, aiwa te te tãma 're romhuri wẽ zahuré mono õ di za. Ĩsib'apito maparane wamhã, sahuré te te 're sawi pese zahuré mono õ di za. Misi te za te te 're sawi pese. Ĩhâiba amo si te za te te siwi 're wẽ'õ. Duré sahuré te te 're wapari pese zahuré mono õ di za, romhuri'wa hã. Misi te za te te 're wapari pese. Ĩhâiba amo si te za te te 're 'ruiwapari. Tane, a norĩ wa'wa hã rob'uiprazéb zô si, asima 're romhuri za'ra wa'aba mono wamhã, 'Re ĩhâimana u'âsi mono ma, 're romhuri wẽ waihu'u za'ra wa'aba mono õ di za. Mare di. ");
INSERT INTO xavNT_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","— Taha wa, wa za duré ãne aima waihu'u za'ra wa'wa. Marĩ na 're aihâtâ'â za'ra wa'aba mono õ di za, asazé wa'aba na, duré 're ĩ'âhuri aba mono õ na zama. Duré ai'uzazém na zama, asina 're aihâtâ'â za'ra wa'aba mono õ di za. E taré wasa zô si wa za 're wahâimana za'ra. Mare di. Wasazé nhipai u pire uptabi di, wahâimanazé hã. E taré 're ĩwasi'uza za'ra mono zép si, te wahâiba hã wama 're hâimana za'ra. Mare di. Marĩ ĩwẽ uptabi da, te wahâiba hã wama 're hâimana za'ra. ");
INSERT INTO xavNT_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Duré, sire norĩ hã bété. Ta norĩ hã te te sima 're robzuri mono õ di. Duré te te sima 're rob'rãihâri za'ra mono õ di. Robza'razéb ãma te te sisa 're robza'wari za'ra mono õ di duré, ãma 're ĩsaihuri mono zéb da hã. Tane nherẽ, te Aimama 'wa hã hâiwa ãma 're ĩsãmra mono hã ĩsa hã te te tãma 're anhomri u'âsi. E tawamhã sire si te te 're azawi pese, 'Re ĩhâimana u'âsi mono hã. Mare di. Sire zawi nhipai u, tãma asawi uptabi za'ra wa'aba di. Taha wa, sire te te 're ĩ'ab'madâ'â mono zém nhipai u, te za te te 're ai'madâ'â pese za'ra wa'wa, Aimama 'wa hã, asina 're aihâtâ'â za'ra wa'aba mono tõ da. ");
INSERT INTO xavNT_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Duré, 're atâ'â za'ra wa'aba mono zém na asina 're aihâtâ'â za'ra wa'aba mono wamhã, e asibâtâ na 're atâ'â za'ra wa'aba mono õ di za. E asibâtâ nhipai u, te za 're aihâimana siroptub za'ra wa'aba mo. Mare di. Asina 're aihâtâ'â za'ra wa'aba mono zéb zarina, asibâtâ nhipai u 're aihâimana siroptub za'ra wa'aba mono õ di za. ");
INSERT INTO xavNT_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","— E marĩ wa, te bété ai'uzazéb õ na asina 're aihâtâ'â za'ra wa'aba mo. E asina 're aihâtâ'â za'ra wa'aba mono zéb zarina, te za rowẽ na 're aihâimana za'ra wa'aba mo. Mare di. Ma'ãpé, romnhirãrã 're ĩhâimana za'ra mono zém na rosa'rata za'ra wa'aba a'â, rom na 're ĩsimasa mono na hã. Ta norĩ hã ti'uzazéb da hã, te te sisada 're 'manharĩ za'ra mono da, te te 're romhuri za'ra mono õ di. ");
INSERT INTO xavNT_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Tane nherẽ, dama 'madâ'â zei uptabi di, romnhirãrã hã. Apito Saroma hã sibro pese wa, uza wẽ uptabi na 're si'uza mono nherẽ, taha nhipai u, dama 'madâ'â zei uptabi di, romnhirãrã hã. ");
INSERT INTO xavNT_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Romnhirãrã hã hâiwi 're simnhatã mono ré, te za du hã ĩré da te 're wazâri za'ra, unhama da, da te 're ub'rã za'ra mono da. Taha wa, 're simasam hâ mono dai õ nherẽ, ma tô wẽ uptabi na te te 're ab'manharĩ, 'Re ĩhâimana u'âsi mono hã. E tawamhã, ai'uzazé hã te te aima 're sõmri za'ra wa'aba mono õ di za bété. Te za tô te te aima 're sõmri za'ra wa'wa, du hâimanazéb zawi nhipai u te te 're asawi pese za'ra wa'aba mono wa, a norĩ wa'wa hã. E niha Aimama 'wa hã asina 're umnhasi za'ra wa'aba mono õ di, taha si ai'uzazé hã te te aima 're sõmri za'ra wa'aba mono wa. ");
INSERT INTO xavNT_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","32","Aimama 'wa hã hâiwa ãma 're ĩsãmra mono ma hã, tãma aiwaihu'u pese za'ra wa'aba di, marĩ zô aiwi 're ĩrowaptâ'â za'ra wa'aba mono zém na hã. Taha wa, marĩ na asina 're aihâtâ'â za'ra wa'aba mono õ di za. Ãté asina 're aihâtâ'â za'ra wa'aba mono wa, te za ãne asima 're ĩrosa'rata za'ra wa'aba mono zéb zarina, ãne asima 're ĩnharĩ za'ra wa'aba mo: “E ma hawi te za mra hã wama 're wairébé, duré wa te 're ĩ'âhuri mono zéb da hã, duré wa'uzazéb da hã.” Ãne na asima 're rosa'rata za'ra wa'aba mono õ di za. 'Re ĩhâimana u'âsi mono waihu'u'õ'wa norĩ hã, taha zô si te sima 're sõpré, sina 're hâtâ'â za'ra mono wa. ");
INSERT INTO xavNT_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","'Re ĩhâimana u'âsi mono hã ãma 're ĩsib'a'uwẽ za'ra mono norĩ ma, ĩwẽ uptabi hã te te tãma 're ĩsõmri za'ra mono zéb zô si, te za asima 're asõpré u'âsi aba mo. 'Re ĩhâimana u'âsi mono te te sima 're aiwẽ za'ra wa'aba mono zéb zarina si, 're anomro wẽ wa'aba mono da, te za asima 're ĩwẽ u'âsi za'ra wa'aba mo. Tawamhã, ãhã zô si 're asõpré wa'aba mono wamhã, marĩ zô aiwi 're ĩrowaptâ'â za'ra wa'aba mono zéb uwaibaba, te za tô te te aima 're anhomri 'wa, Aimama 'wa hã. ");
INSERT INTO xavNT_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Awẽ sidâpâsi te marĩ hã asada 're hâimana za'ra wa'wa. Tane nherẽ, oto ai'ãma 're awẽ za'ra wa'aba mono wamhã, te za asina 're ĩwaihu'u za'ra wa'aba mo, 'Re ĩhâimana u'âsi mono te te 're aipawaptob za'ra wa'aba mono zém na hã, marĩ hã asada 're hâimana za'ra wa'aba mono nherẽ. Taha wa, za duré ai'ãma 're ĩ'awẽ za'ra wa'aba mono zé bâtâ na hã 're aihâimana za'ra wa'aba mono zém na hã, asina 're aihâtâ'â za'ra wa'aba mono õ di za. 'Re ĩhâimana u'âsi mono si te za awẽ sidâpâsi bâdâ hã te te ai'ãma 're ab'madâ'â 'wa. ");
INSERT INTO xavNT_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","— Dawasédé hã da'ãma 're ĩsa'ra za'ra wa'aba mono zéb zarina, asiwi 're dawẽ'õ za'ra wa'aba mono õ di za, taha zarina 'Re ĩhâimana u'âsi mono hã te te siwi 're aiwẽ'õ za'ra wa'aba mono tõ da. ");
INSERT INTO xavNT_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Asi'uihâ na asiwi 're dawẽ'õ pese za'ra wa'aba mono wamhã, taha zarina te za tô 'Re ĩhâimana u'âsi mono hã te te siwi 're aiwẽ'õ pese za'ra wa'wa, ĩwa'rãmi. Asiwi 're dawẽ'õ za'ra wa'aba mono õ wamhã, tawapsi, te te siwi 're aiwẽ'õ za'ra wa'aba mono õ di za, ãne na hã aiwa. ");
INSERT INTO xavNT_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","5","Ãne, wa za duré ãma aima romnhimiré'é za'ra wa'wa. Ãté wede wa'õno hã atob 're te nomro, sabui õ nherẽ. E niha te za bété sô ĩtõmo 'madâ, wede nhiprubre wazere da, asisãnawã tõmo hawimhã. E ãne hã ĩ'uwaibaba. Mare di. Wede wa'õno hã atob 're ĩnomro hã sabui õ nherẽ, e niha te za tãma ĩnha: “Ropru hã a'â te aima wazere, atõmo hawimhã.” Mare di. Wede wa'õno hã te za a'â atõmo hawimhã ĩwaze. Tawamhã te za sô airĩtĩ wẽ, wazere da, asisãnawã tõmo hawimhã, wede nhiprubre hã. ");
INSERT INTO xavNT_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","— Duré 'Re ĩhâimana u'âsi mono 'ruiwapari'wa norĩ ma, ĩwasu'uwẽ na tãma 're rowasu'u za'ra wa'aba mono õ di za, te te ãma 're ĩwasété za'ra mono norĩ ma hã. E marĩ wa. Ta norĩ hã wapsã ma, marĩ ĩse hã da te tãma 're a za'ra mono nherẽ, dazô 're sipizari za'ra mono wa, te te 're ĩdahâzu mono ne, te za ta norĩ hã asada 're hâimana wasété za'ra wa'wa. Uhâbâ norĩ hã marĩ wẽ zô, sima 're sõpré waihu'u mono õ di. Marĩ ĩwẽ hã wa'âbâ za'ẽtẽ nherẽ, uhâbâi ma, da te 're sãmra mono wa, taré te te 're ĩwati'i za'ra mono ne, te za ta norĩ hã taré te te 're wapari za'ra, ĩwasu'uwẽ hã. Taha wa, ta norĩ ma, 're rowasu'u za'ra wa'aba mono õ di za, 'Re ĩhâimana u'âsi mono 'ruiwapari'wa norĩ ma hã. ");
INSERT INTO xavNT_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","8","— 'Re ĩhâimana u'âsi mono wi, te za ĩwẽ hã 're ĩwaptẽrẽ za'ra wa'aba mo. Tawamhã te za tô te te aima 're anhomri 'wa. Ĩwẽ zô si te za duré asima 're asõpré u'âsi aba mo. Tawamhã taha zarina te za tô te te aima ãma 're a'uwaimrami 'wa, 'Re ĩhâimana u'âsi mono hã, 'râwi aima 're hâimana za'ra wa'aba mono da. Duré ni'wa hã 'ri tede'wa zô te te 're ĩ'ridawa ta'a mono ne, te za ĩwẽ hã tiwi 're ĩwaptẽrẽ za'ra wa'aba mo. Tawamhã 'ri tede'wa te te tãma ĩ'ridawa ne, te za tô 'Re ĩhâimana u'âsi mono hã te te aima 're anhomri 'wa, ĩwẽ hã, si'uihâ na. ");
INSERT INTO xavNT_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Ãne, wa za duré aima ãma romnhimiré'é za'ra wa'wa. Ai'ra hã ĩ'u'ẽtẽ wapu te te aiwi 'maiwaptẽrẽ aba wamhã, e ẽne te aré tãma ĩ'manhomri 'wa, te te ĩwaptẽrẽ upana. Mare di. Ĩ'u'ẽtẽ wapu si te aré tãma ĩ'manhomri 'wa, te te 'rẽne da, ai'ra wa'wa hã. ");
INSERT INTO xavNT_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Duré, tebe te te aiwi 'maiwaptẽrẽ aba wamhã, e wahi te aré tãma ĩ'manhomri 'wa, te te ĩwaptẽrẽ upana. Mare di. Tepe si te aré tãma ĩ'manhomri 'wa, te te 'rẽne da. ");
INSERT INTO xavNT_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Tane duré, a norĩ wa'wa hã 're anomro wẽ uptabi aba mono õ nherẽ, te marĩ ĩwẽ si tô ai'ra norĩ ma, 're ĩsõmri za'ra wa'aba mo. E tawamhã Aimama 'wa hã hâiwa ãma 're ĩsãmra mono hã wẽ uptabi na 're hâimana mono nherẽ, e ai'ra norĩ ma 're asõprub za'ra wa'aba mono zém nhipai u, te te aima 're sõmri za'ra wa'aba mono õ di za bété, tinhoprubzé ĩwẽ hã. Te za tô ĩsipai u te te aima 're sõmri za'ra wa'wa ĩwẽ hã, tiwi 're ĩwaptẽrẽ za'ra wa'aba mono zéb uwaibaba. ");
INSERT INTO xavNT_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","— Marĩ ĩwẽ si da te aima 're 'manharĩ za'ra wa'aba mono da, asima 're ĩdawẽ za'ra wa'aba mono ne, te za marĩ ĩwẽ si dama 're ĩ'manharĩ u'âsi za'ra wa'aba mo, ĩwa'rãmi. Ãne duréihã 'Re ĩhâimana u'âsi mono nhimiroti na Mozési te te ãma ĩrob'ui'éré hã te wama wasu'u za'ra, duréihã ĩsadawa wasu'u 'rata 'wa norĩ nhimi'ui'éré zama. ");
INSERT INTO xavNT_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","14","— Duré, ropipa u 're ĩdanhisisi mono zé hã bâdâdi hã sa'ẽtẽ uptabi di. Duré ĩsitobzé hã, sa'ẽtẽ uptabi di. Taha wa, dama wapure di, ãma 're ĩdanomro mono zéb da hã, bâdâdi hã sa'ẽtẽ uptabi wa. Taha wa, te da'ahâ uptabi na ãma 're danomro, ropipa u, tamomo 're danhisisi mono wa, da te 're robzépata u'âsi za'ra mono da. Tane nherẽ, 'Re ĩhâimana u'âsi mono 'rata 're ĩdahâimana u'âsi za'ra mono zéb u, 're ĩdanhisisi mono zéb da hã, bâdâdi nhitobzé hã syryre di. Tamomo bâdâdi hã syry uptabire di duré, ãma 're ĩdanomro mono zéb da hã. Dama pire di, ãma 're ĩdanomro mono zéb da hã. Taha wa, te da'umro na si da te dasina 're uwaimrami za'ra. Taha wa, ma'ãpé, sada 're asiptete za'ra wa'aba mono, bâdâdi nhitobzé ĩsyryre na si 're asisisi aba mono da, rowẽ uptabi u. ");
INSERT INTO xavNT_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","— Duré, 'Re ĩhâimana u'âsi mono zadawa wasu'u uptabi õ 'wa norĩ wi, te za 're asi'madâ'â pese za'ra wa'aba mo. Ta norĩ hã tô sena dasiré 're hâimana wẽ za'ra mono newa, te za te te dama 're roti za'ra taré. Ta norĩ hã te abaze zahi ne 're hâimana u'âsi za'ra, ĩsazei'wa norĩ zada. ");
INSERT INTO xavNT_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Ta norĩ hã uburé marĩ hã te te 're ĩ'manharĩ za'ra mono zém na te za ãma 're ĩwaihu'u za'ra wa'aba mo, 'Re ĩhâimana u'âsi mono zadawa wasu'u uptabi 'wai õ na hã. E 'wabzéré hã te za rob'rã na 're 'rã za'ra, uwa 'ru 'rã na. Mare di. Uwa 'ru 'rã na 're 'rãi waihu'u za'ra mono õ di, 'wabzéré hã. Duré, e apto hã rob'rã ĩse na te za 're 'rã za'ra. Mare di. Ãma 're 'rãi waihu'u za'ra mono õ di, apto hã. ");
INSERT INTO xavNT_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","18","Duré rowede hã wẽ wamhã, 're 'rãi wasété za'ra mono õ di za. Te za 're 'rãi wẽ u'âsi za'ra. Wasété wapsi, te za 're 'rãi wasété u'âsi za'ra. Ta norĩ hã 're 'rãi wẽ waihu'u za'ra mono õ di za. ");
INSERT INTO xavNT_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Rowede hã 're 'rã za'ra mono õ wa, te za da te 're sãna'rata nhihâri za'ra, unhama u da te 're sãmra mono da. ");
INSERT INTO xavNT_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Tane, aibâ norĩ hã roti tô senai'õ na te te dama 're ĩroti za'ra mono norĩ hã uburé marĩ hã te te 're ĩ'manharĩ wasété za'ra mono zém na, te za ãma 're ĩwaihu'u za'ra wa'aba mo, 'Re ĩhâimana u'âsi mono zadawa wasu'u uptabi 'wai õ na hã. ");
INSERT INTO xavNT_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","— Ãté ni'wam norĩ hã te za dama 're siwasu'u za'ra, ãne: “Zezusi hã ta hã Ĩ̱nhib'apito. Wa hã tãma romhuri'wa, wa tô 're ĩ̱hâimana u'âsi.” Ãne ni'wam norĩ hã dama 're siwasu'u za'ra mono nherẽ, uburé 're sisisi mono õ di za, 'Re ĩhâimana u'âsi mono, da'ãma 're ĩsib'a'uwẽ mono zéb u hã. Ni'wam norĩ si te za 'Re ĩhâimana u'âsi mono nhib'a'uwẽ, 're hâimana za'ra, Ĩ̱mama hã hâiwa ãma 're ĩsãmra mono hã te te sima 're ĩ'awẽ mono zéb zarina, marĩ ĩwẽ si te te 're ĩ'manharĩ za'ra mono norĩ si. ");
INSERT INTO xavNT_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Nimahã bâtâ na ropsi'utõrĩzéb ãma, Ĩ̱mama za oto da'ãma ĩsipo'ozéb ãma hã te za da'ahâ na ĩ̱ma nharĩ za'ra ni, ãne: “Wanhib'apito, Wanhib'apito, wa norĩ hã asadawa para, wa tô wa te dama 're sadawa wasu'u za'ra, 'Re ĩhâimana u'âsi mono hã. Asadawa para, wa tô duré wa'uburé hã wa te dama 're sãmra za'ra. Marĩ dama ĩ'manharĩ waihu'u'õ hã wa tô duré wa te dama 're 'manharĩ za'ra, asadawa para.” Ãne na hã da'ahâ na te za ĩ̱ma tasiwasu'u za'ra ni, ĩ̱nhib'a'uwẽ uptabi hã 're danomro mono newa. ");
INSERT INTO xavNT_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Tane nherẽ, wa za wa hã ĩ̱si'uihâ na tãma nharĩ za'ra, ãne: “Te aiwaihu'u za'ra wa'aba õ di, ĩ̱zazei'wa na. Marĩ ĩwasété si ma tô 're ĩ'manharĩ u'âsi za'ra wa'aba mo. Mo oto ai'aba'réi wa'aba, ĩ̱nhiti.” Ãne wa za ta norĩ ma nharĩ za'ra, misi haré. ");
INSERT INTO xavNT_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","25","— Ãne, wa za duré ãma aima simiré'é za'ra wa'wa, 'ri'wai wasu'u na. 'Ri'wa hã tãma rosa'rata waihu'u pese wa, ma tô ẽtẽ nhisiwi 'ri hã 'manha, siptete na 're sa mono da. Tawamhã tã hã pĩni za'ẽtẽ na 're ta'a mono wa, ma tô 're âpré. 'Re âpré mono wamhã, 'ri u ma tô 're praba, â hã. Rowa'u'u za'ẽne hã ma tô duré 're pusi, 'ri uwaibaba, te te me da aré. Tane nherẽ, 'ri hã simei õ di, ẽtẽ nhisiwi te te sima 'ri wa, aibâ hã. Tane duré, ã hã te ĩrotizé hã ni'wam norĩ hã te te 're wapari za'ra mono wa, te te oto 're 'madâ'â pese za'ra mono wamhã, ta norĩ si te za rowẽ na 're hâimana u'âsi za'ra, 'Re ĩhâimana u'âsi mono 'rata. ");
INSERT INTO xavNT_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","27","— 'Ri'wa hâiba amo na, wa za duré ãma aima simiré'é za'ra wa'wa, tãma ĩrosa'rata waihu'u õ hã. Ta hã supara nhisiwip si ma tô sima 'ri, siptete na tãma 're sab u'âsi mono da newa. Tawamhã tã hã pĩni za'ẽtẽ na 're ta'a mono wa, ma tô 're âpré. 'Re âpré mono wamhã, 'ri u ma tô 're praba, â hã. Rowa'u'u za'ẽne hã ma tô duré 're pusi, 'ri uwaibaba. Tawamhã 'ri hã ma tô 'marõwĩ, awa'awi. Tane duré, ã hã te ĩrotizé hã ni'wam norĩ hã tipo're na te te 're wapari za'ra mono nherẽ, te te 're 'madâ'â za'ra mono õ wamhã, ta norĩ si te za si'uihâ na 're sisimini za'ra, 'Re ĩhâimana u'âsi mono 'rata za 're ĩdahâimana u'âsi za'ra mono zé hã. ");
INSERT INTO xavNT_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Tawamhã Zezusi hã ãne na te te dama rowasu'u parimhã, ma tô ãma tatob'uzu za'ra ni, te te dama ĩrowahutuzém na hã. ");
INSERT INTO xavNT_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","'Re ĩhâimana u'âsi mono nhimiroti 'rata na rob'ui'éré na dama rowahutu'wa norĩ, simirowasu'u wapure na te te dama 're ĩrowahutu za'ra mono ne, te te dama 're rowahutu mono õ di, Zezusi hã. Simirowahutu pire uptabi na ma tô te te dama 're rowasu'u. Taha wa, ma ãma tatob'uzu za'ra ni, dama ĩwaihu'u'õ hã te te dama wasu'u wa. ");
INSERT INTO xavNT_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Tawamhã Zezusi hã ma tô ẽtẽ 'rãihâ hawi si'ra. Te te si'rai wamhã, da'ahâ uptabi na ma tô ĩsarina ai'aba'ré ni. ");
INSERT INTO xavNT_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Tawamhã aibâ ĩ'wa're ré hã ma tô ĩtẽme wi. Ĩtẽme wisi wamhã, ma tô hi'rãtitõ nhamra, ĩpapara. Te tãma tinha: — Apito, ĩ̱ma aiwaihu'u pese di, asimipese waihu'u pese na. Taha wa, asima ĩ̱wẽ wamhã, te za ĩ̱pe. ");
INSERT INTO xavNT_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Tawamhã Zezusi ma tô tinhib'rada hã wahutu, te te ãma upi da. Te te upi wamhã, te tãma tinha: — Tane tô. Wa tô ĩ̱sima aiwẽ, te aipese da. Tâibâ oto aihâzé hã. Tawamhã awa'awi ma ĩ'wa're hã tãma apa. ");
INSERT INTO xavNT_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Tawamhã Zezusi hã te tãma tinha, ãne: — Ĩ̱wapari pese, asina. Ni'wai ma, asina ĩ̱wasu'u õ di za, te aipesezém na hã. Sasedoti u si te za aimo, aihâiba wẽ zô te te aihâiba 'madâ'â da. Taha parip si, te za tãma asõpru 'Re ĩhâimana u'âsi mono ma, Mozésihi nhimiroti zarina, aipesezém na da te ãma aiwaihu'u za'ra da, sena na. — Ãne te Zezusi hã tãma roti, aibâ te te ĩpese ma. ");
INSERT INTO xavNT_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Tawamhã Zezusi hã Capana'u na 'ri nho'õmo nhisi u ma tô wi. Wisi wamhã, ma tô aibâ sõpẽtẽ, romanu hã. Ta hã da'wapéi'wa norĩ wada'uri'wa. Tawamhã, te te sõpẽtẽ wamhã, ma tô aibâ hã tãma ti'ru Zezusihi ma, tãma ĩromhuri'wa hã te te tãma pese da. ");
INSERT INTO xavNT_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","Ãne te tãma tinha: — Apito, ĩ̱ma romhuri'wa hã ĩ̱nhorõwa ãma te nomro. Hâzé uptabi di. Hâzé uptabi wa, sirési waihu'u õ di, hâzé za'ẽtẽ wa. ");
INSERT INTO xavNT_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Tawamhã Zezusi hã te asa tãma tinha: — Wa za ãma mo tô, te pese da. ");
INSERT INTO xavNT_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Tawamhã romanu hã te duré tãma tinha, da'wapéi'wa norĩ wada'uri'wa hã: — Tô'ã, apito. Wa hã aima ĩ̱wapure di, ĩ̱nhorõwa u asébré da hã. Ma'ãpé, taré ã hawi pese aimreme na, séptâ'â da. Tawamhã te za tãma tirowẽ, ĩ̱ma romhuri'wai ma. ");
INSERT INTO xavNT_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Wa hã da'wapéi'wa norĩ wada'uri'wa zapari romhuri'wa. Ĩ̱zapari te duré 're hâimana za'ra, da'wapéi'wa norĩ hã. Nimomo te 'mazatõrĩ wamhã, te za 'maimo. Duré sô ĩ̱'maihârâ wamhã, te za we 'maimo, ĩ̱tẽme. Duré ĩ̱ma romhuri'wai ma, marĩ hã te 'rui wamhã, te za 'manha awa'awi, ĩ̱zadawa para. — Ãne te siwasu'u, Zezusihi ma. ");
INSERT INTO xavNT_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Tawamhã Zezusi hã ãne hã te te wapari wamhã, ma tô ãma titob'uzu, ĩsiwasu'uzém na. Taha wa, ĩsarina ĩdasi'aba'ré norĩ ma, ma tô nharĩ za'ra: — Tô sena wa aima waihu'u za'ra wa'wa. Ã hã te te sina ĩ̱'umnhasizém na hã niwa te ĩ'madâ'â õ, Izarazéhé nhihudu norĩ nhipti'ai ãma hã. Ta norĩ hã te te ãma siwi wabzu õ di, te te sina ĩ̱'umnhasizém na hã. ");
INSERT INTO xavNT_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Ãne, wa za duré aima waihu'u za'ra wa'wa. Da'ahâ uptabi na te za 're dasihutu, bâtâ pusizém hawi, duré bâtâ zasizém hawi, 'Re ĩhâimana u'âsi mono u, ĩsiré 're dasaihuri mono da, da'ãma 're ĩsib'a'uwẽ mono zéb ãma. Abra'ãhã siré te za 're dasi'ubumro, duré Izatihi siré, duré Zacoho siré. ");
INSERT INTO xavNT_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Tane nherẽ, ni'wam norĩ hã 'Re ĩhâimana u'âsi mono, ãma 're sib'a'uwẽ za'ra mono da nherẽ, ĩsiré 're si'ubumroi mono da nherẽ, te za sãmra sisiti, robra si 're ĩsa'wari mono u. Tame te za sina 're 'ry'ry. Te za duré 're 'wasitete za'ra, te te 're robzépata za'ẽtẽ za'ra mono wa. — Ãne ma tô Zezusi hã dama rowasu'u. ");
INSERT INTO xavNT_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Tawamhã te duré da'wapéi'wa norĩ wada'uri'wai ma tinha: — Mo oto aimorĩ apâ, asõrõwa u. Asina ĩ̱'umnhasizéb zarina, wa za aipawapto. Tawamhã ãne te te tãma nharĩ wi, ma tô tipese, romanuhu ma, romhuri'wa hã. ");
INSERT INTO xavNT_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Tawamhã Zezusi hã Pedruhu nhorõwa u ma tô mo. Morĩ wamhã, ĩmaprewa ma tô sabu. Hâzé ré, te nomro waptâ wa, wa'ro na. ");
INSERT INTO xavNT_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Tawamhã ma tô sib'rata upi, Zezusi hã. Te te sib'rata upi wamhã, ma tô tiwahâ. Tawamhã ma tô wahudu, pi'õ hã. Wahutu wamhã, ma tô ĩsa hã tãma tisõ Zezusihi ma, sa da. ");
INSERT INTO xavNT_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Tawamhã bâdâ sébrézéb u, ma tô wa'uburé ré 're ĩdanomro mono hã da te simro, Zezusihi u, ahâ uptabi na. Tawamhã misi si te nasi dama azatõ wa'uburé hã, misi haré timreme na si. Uburé ĩhâzé ré norĩ zama te apese duré. ");
INSERT INTO xavNT_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Ãne ma tô Zezusi hã te te 're da'apawapto, Iza'iza hã duréihã te te ãma ĩrob'ui'érézéb zarina te te sina uwaimrami da. Ãne Iza'izaha nhimi'ui'éré hã: “Wahâzé mono bâ, ma tô te te wawi 're awaibu.” Ãne duréihã 'Re ĩhâimana u'âsi mono zadawa wasu'u 'rata 'wa nhimi'ui'éré hã, Zezusihi ãma hã. ");
INSERT INTO xavNT_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Tawamhã Zezusi hã da'ahâ uptabi na da te dasiwi ĩ'uirĩ za'ra norĩ hã ma tô 'madâ'â za'ra. Te te da'ab'madâ'â wamhã, ma tô tisiré 're ĩnomro mono norĩ ma rob'ru za'ra, ĩsõ'u na te te saprĩ za'ra da, zara u. ");
INSERT INTO xavNT_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Tawamhã 'Re ĩhâimana u'âsi mono nhimiroti na rowahutu'wa hã ma tô ĩtẽme wi, Zezusihi u. Ãne te tãma tinha: — Rowahutu'wa, ãhãna wa ĩ̱sima aiwẽ, asiré 're ĩ̱morĩ da oto, daro mono bâ. ");
INSERT INTO xavNT_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Tawamhã Zezusi te asa tãma tinha: — Wapsã wawẽre hã ab're 're, ĩsõrõwa hã. Duré si norĩ hã tizasi te te sima 're 'manharĩ za'ra, tinhorõwa da hã. Tazahã, wa hã ti'ai ãma dasiré ĩ̱podo hã ĩ̱nhorõwa õ di, ãma 're ĩ̱wa'utu mono zéb da hã. Hâiwi si wa datẽme 're morĩ u'â. ");
INSERT INTO xavNT_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Tawamhã Zezusi ma tô duré aibâ hâiba amo 'mahâ, ĩsarina 're ĩmorĩ hã, ĩsiré 're morĩ u'âsi da oto. Tawamhã aibâ hã te asa tãma tinha: — Apito, a'â apâ ĩ̱morĩ, ĩ̱mama hã ĩ̱wi dâ'â wa, ĩ̱sisa'u te ãma ti'a da. — Ãne te sina 'mahâ. ");
INSERT INTO xavNT_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Tane nherẽ, te Zezusi hã tãma tinha, asa: — Õne haré te za ĩ̱siré 're aimo oto. Ĩdâ'â norĩ hã te za tisiré ĩdâ'â norĩ ãma te te 're ti'a za'ra. ");
INSERT INTO xavNT_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Tawamhã Zezusi hã ma tô ãzé, uba're 're. Ĩsiré 're ĩnomro mono norĩ zama ma ĩsiré asisi, ĩsiré si'aba'ré da. ");
INSERT INTO xavNT_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Tawamhã uba're na si'aba'réi ré, ma tô rowa'u'u za'ẽne hã tiwi tiwatobro za'ra. Â sisasi hã te te ĩré wabzuri za'ra, uba're hã. Tane nherẽ, Zezusi te nhono. ");
INSERT INTO xavNT_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Tawamhã ĩsiré 're ĩnomro mono norĩ hã ma tô ĩtẽme sina roptob za'ra, te te siwi utu da. Tawamhã ãne te 'mahârâ za'ra: — Wanhib'apito, ma'ãpé wanho'reptu za'ra na. Wa za ai'utõrĩ ni. ");
INSERT INTO xavNT_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Tawamhã Zezusi hã te tãma nharĩ za'ra: — E marĩ da, ma aipahi za'ra wa'wa. E ĩ̱'umnhasi za'ra wa'aba ãna. Tawamhã ma tô wahudu, Zezusi hã. Wahutu wamhã, ma tô rowa'u'u ma tinha, te te sazâri da, â sisasisi ma zama. Tawamhã ma tô sazâ, rowa'u hã. Ma tô duré ti'âtu. ");
INSERT INTO xavNT_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Tawamhã ma tô ãma titob'uzu za'ra, ĩsiré 're ĩnomro mono norĩ hã. Ãne te sima nharĩ za'ra: — Pra, e niha ĩwaihu'u pe, õ hã. Ĩsadawa hawi ma rowa'u hã sazâ, â sisasisi zama. — Ãne te sima rowasu'u za'ra, ĩsiré 're ĩnomro mono norĩ hã. ");
INSERT INTO xavNT_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Tawamhã Zezusi hã ma tô mo, Dadara na danhipti'a nho'õmo nhisi u, Darireza na ĩsõ'u nhisi zara u. Tame ma tô aibâ norĩ hã sõpẽtẽ zahuré, wa'uburé ré 're ĩneb zahuré hã. Adâ'â 'ru hawi, ma we sina uzusi zahuré, ẽtẽ zahâpâ ab're sirõmo 're, 're ĩsimasisi u'âsi zahuré mono zém hawi. Ta norĩ hã ĩsipãrĩ su'u zahuré, duré simimnhasi zahuré di. Taha wa, 're ĩhâimana zahuré mono zé wa'wai baba 're danomro waihu'u mono õ di. ");
INSERT INTO xavNT_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Tawamhã rosa'rese õ ré, ma tô sa'ẽtẽ 'mahârâ zahuré Zezusi hã, ãne: — 'Re ĩhâimana u'âsi mono 'ra, e marĩ wa'ãma 'manharĩ da, te we aimo, wawa'wai baba. E ropsi'utõrĩzé wana wa'ahâri da, te we aimo, wa te robzépata da. ");
INSERT INTO xavNT_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Tawamhã romhâ prã na te uhâbâ hã tisa hã te te 're huri, ahâ na. ");
INSERT INTO xavNT_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Tawamhã wa'uburé norĩ hã aibâ norĩ pẽ'ẽ 're, 're ĩhâimana za'ra mono hã te sa'ẽtẽ sina 'mahârâ za'ra: — Nimomo wazatõrĩ za'ra da wamhã, ma'ãpé uhâbâ norĩ u wazatõrĩ za'ra na, ĩhâiba 're, 're wahâimana za'ra mono da. ");
INSERT INTO xavNT_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Tawamhã Zezusi hã ma tô õne haré tãma rob'ru za'ra: — Mo oto ai'aba'réi wa'aba. Tawamhã uhâbâ hâiba 're ma tô sisisi, wa'uburé norĩ hã. Taha wa, te sa'ẽtẽ sisa're, uhâbâ norĩ hã, ĩ'rãsipra u. Âi ba ma tô rere. Taha wa, ma ai'utõ, â na uburé. ");
INSERT INTO xavNT_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Tawamhã uhâbâ 'madâ'â'wa norĩ hã ma tô ĩsiti sisa're. 'Ri nho'õmo u ma tô sisa're. Tame ma tô uburé dama rowasu'u za'ra, aibâ norĩ ma, niha ĩromhâimana zahuré zém na hã, wa'uburé ré 're ĩneb zahuré ma. ");
INSERT INTO xavNT_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Tawamhã 'ri nho'õmo ãma 're ĩdasi'ubumroi mono norĩ hã ma tô aihĩni tawairébé ni, Zezusi hã da te dasina uzusi za'ra da. Tawamhã ma tô sãmri za'ra ni. Da te dasiwi sãmri wamhã, ma tô tãma rob'ru za'ra ni: — Ma'ãpé, warom nhiti aimorĩ, nimomo. — Ãne te dasiwi satõrĩ ni, Zezusi hã. ");
INSERT INTO xavNT_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Tawamhã Zezusi hã ma tô uba're 're ãzé, zara u te te saprĩ da. Te te saprĩ wamhã, ma tô 'ri nho'õmo u wi, tirob u. ");
INSERT INTO xavNT_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Tamomo ma tô ni'wam norĩ hã we siwi ti'â, ĩmorĩ'õ hã ĩsimiwaptâ ré. Ĩmorĩ'õ hã za te te ĩpese na ma tô ãma umnhasi za'ra, Zezusi hã. Tawamhã Zezusi hã taha na ma tô sina simirosa'rata waihu'u za'ra, aibâ norĩ hã. Taha wa, te ĩmorĩ'õ ma tinha: — Ĩ̱siwadi, aiwi robzei'õ tõ. Aiwasédé hã 're ĩ'ab'manharĩ wasété mono zé hã te ai'ãma 're ab'madâ'â mono õ di za oto. — Ãne te tãma tinha. ");
INSERT INTO xavNT_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Tawamhã ni'wam norĩ hã 'Re ĩhâimana u'âsi mono nhimiroti 'rata na rob'ui'éré na dama rowahutu'wa norĩ hã ma tô 'râwi sima rowasu'u za'ra, ãne: — Õ hã te 'Re ĩhâimana u'âsi mono ãma wasété. ");
INSERT INTO xavNT_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Tane nherẽ, Zezusi hã ma tô sina waihu'u, ĩsimirosa'rata za'ra hã. Taha wa, te tãma nharĩ za'ra: — E marĩ da, ma tô ãne ĩ̱'ãma ĩrosa'rata wasété za'ra wa'wa. ");
INSERT INTO xavNT_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Wa hã dawasédé hã te dama 're ĩ'apari waihu'u pese mono zém na hã, sena na ĩ̱waihu'u za'ra wa'aba da hã, e niha te za ĩwaihu'u za'ra wa'wa. Aibâ ma, wa tô tinha: “Aiwasédé hã 're ĩ'ab'manharĩ mono zé hã te ai'ãma 're ab'madâ'â mono õ di za oto.” Ãne na si ĩ̱mreme wamhã, aima pibu prã za'ra wa'aba di. Ã hã ĩmorĩ'õ hã wahutu da, duré oto morĩ da, te tãma nharĩ wapsi, te za ĩwaihu'u za'ra wa'wa, ĩ̱waihu'u pese na sena na ĩ̱waihu'u pese za'ra wa'aba da oto. Taha wapsi, aima pibu pese za'ra wa'aba di za. ");
INSERT INTO xavNT_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Ti'ai ãma dasiré ĩ̱podo hã ĩ̱ma waihu'u pese di, dawasédé te dama 're ĩ'apari mono da hã, 'Re ĩhâimana u'âsi mono zadawa para. Ãne na asiwi ĩ̱waihu'u za'ra wa'aba da, wa za ĩhi'ré ma tinha, wahutu da. Tawamhã ĩmorĩ'õ ma, te tinha Zezusi hã: — Ma'ãpé, aiwahutu. Asa'warizé hã âri, asõrõwa u aimorĩ da oto. ");
INSERT INTO xavNT_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Tawamhã awa'awi ma tô wahudu aibâ hã, tinhorõwa u morĩ da. ");
INSERT INTO xavNT_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Tawamhã ãne hã da te 'madâ'â za'ra wamhã, ma tô tãma tapẽ'ẽwara za'ra ni, dama sa'rese õ wa. Ma tô duré 'Re ĩhâimana u'âsi mono ãma tawata za'ra ni, tiwaihu'u pe hã te te dama 're anhomri mono wa. ");
INSERT INTO xavNT_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Tawamhã Zezusi hã ma tô mo, dahawi. Morĩ ré, ma tô ĩ̱sã, danhib'apito ma, rob'uiprazé ubumroi'wa hã, Mateusi na ĩ̱nhisi hã. Ĩ̱nhimiromhurizéb ãma wa nhamra, rob'uiprazé te dawi 're ĩ'a'ubumroi mono zéb ãma. Tawamhã Zezusi hã te ĩ̱'mahâ: — We aimorĩ, ĩ̱siré 're aimorĩ da oto. Tawamhã awa'awi wa tô wahudu, ĩsiré 're ĩ̱morĩ da oto. ");
INSERT INTO xavNT_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Tawamhã barana wa oto wasiré wasaihuri ni Zezusi norĩ hã, ĩsiré 're ĩwanomro mono norĩ me. Ĩ̱nhorõwa ãma wa wasaihuri ni. Wasaihuri ré, ma tô rob'uiprazé ubumroi'wa norĩ hã ĩtẽme asisi 'ri para u, ahâ na, ĩsiré saihuri da. Ni'wam norĩ hã zudezu nherẽ, parisezu norĩ nhimiroti zarina 're ĩhâimana za'ra mono õ norĩ zama ma tô duré ĩtẽme aihutu, Zezusihi u. ");
INSERT INTO xavNT_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Tawamhã parisezu norĩ hã ãne hã te te 'madâ'â za'ra wamhã, ma tô Zezusihi siré 're ĩwanomro mono norĩ hã wazadanharĩ za'ra, ãne: — E niha bâ, te asib'apito za'ra wa'wa hã rob'uiprazé ubumroi'wa norĩ siré tisa, dawasété na 're ĩdahâimana za'ra mono norĩ siré zama. ");
INSERT INTO xavNT_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Tawamhã Zezusi hã te te sina wapari za'ra wa, ma tô tãma nharĩ za'ra, ãne: — Hâzé ãna 're ĩnomro mono norĩ zô, dawede'wa hã 're siwasutu za'ra mono õ di, te te 're wede za'ra mono da. Ĩhâzé ré norĩ zô si te za 're siwasutu za'ra, te te 're pese za'ra mono da. ");
INSERT INTO xavNT_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Duréihã ma tô 'Re ĩhâimana u'âsi mono zadawa wasu'u'wa hã ãne na rob'ui'éré, 'Re ĩhâimana u'âsi mono mreme na: “Asimizama hã ĩ̱ma 're ĩzata za'ra wa'aba mono zô hã, sô 're ĩ̱nhimipari mono õ di oto. Asimizawi pese zarina, da'ãma 're aiwamri za'ra wa'aba mono da si, wa ĩ̱sima te 're aiwẽ za'ra wa'wa oto.” Ãne duréihã 'Re ĩhâimana u'âsi mono mreme na rob'ui'éré hã sô sabu za'ra wa'aba ĩbaihâ hã, waihu'u pese za'ra wa'aba da. Dawẽ na 're ĩdanomro mono norĩ zô ĩ̱sitẽme 're ĩ̱hârâ mono da, we ĩ̱morĩ õ di. Dawasété na 're ĩdanomro mono norĩ zô si 're ĩ̱hârâ mono da, wa wei mo. ");
INSERT INTO xavNT_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Tawamhã Zuwã Batitaha siré 're ĩnomro mono norĩ hã ma tô Zezusihi u ai'aba'ré. Tawamhã ãne te siwi sadanha: — Wa norĩ hã, duré parisezu norĩ hã 'Re ĩhâimana u'âsi mono ma, 're wamreme zusi mono da hã, wasai ãna wa a'â 're wahâimana za'ra, bâtâ na. E marĩ wa, sai ãna a'â 're hâimana za'ra mono õ di bété, asiré 're ĩnomro mono norĩ hã. ");
INSERT INTO xavNT_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Taha wa, te Zezusi hã asa tãma nharĩ za'ra: — Aibâ hã ĩmrozéb u, sô ĩhârâ za'ra norĩ hã sihutu wamhã, e aibâ ĩmro da hã ĩsiré sãmra za'ra ré, te za robzei'õ na tihâimana za'ra, ta norĩ hã. Mare di. Ãnei õ di. Niwapsi te za bâdâ hã ĩwa waptãrã, aibâ ĩmro da hã ĩsiwadi norĩ wa'wa hawi, da te tiwi ĩ'âri za'ra zéb da hã. Tawapsi te za tô sai ãna 're si'ubumro, robzei'õ na. ");
INSERT INTO xavNT_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","— Duré da'uza hã hâ'ratare wamhã, te za hâihata. E tawamhã ĩhâté hânhihâri na te za hâiwa'aba ni. Mare di. Ĩhâté hânhihâri na da te hâiwa'aba wamhã, da te ĩré hâ'upsõi wamhã, te za tihâzahutu, ĩhâiwa'abazé hã. Tawamhã te za oto hâsisinarĩ pese, da'uza 'rada hã. ");
INSERT INTO xavNT_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Duré e romhâ 'manharĩ 'rata 're, te za uwa 'rãi wa'u ĩsé hã da te 're sé, wa'ui ware õ ré. Mare di. Wa'ui ware õ ré, da te 're séme mono wamhã, oto wa'ui ware wamhã, te za romhâ 'manharĩ 'ratare hã sina wazu. Tawamhã uwa 'rãi wa'u ĩsé hã te za asa'wa. Romhâ 'manharĩ hã te za duré hâihaiwamna. Ĩtép si'uiwa na si, te za da te 're sé, dawi 're sisa'wari za'ra mono tõ da, rob'rãi wa'u zé té hã. Tawapsi, romhâ 'manharĩ hã dawi 're hâsiwamnarĩ za'ra mono õ di za duré. — Ãne ma tô Zezusi hã ãma romnhimiré'é, uwa 'ru 'rãi wa'u ĩsé, da te 're ĩséme mono zém na hã. ");
INSERT INTO xavNT_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Tawamhã Zezusi hã te te dama rowasu'u ré, ma tô aibâ hã ĩtẽme wi, dama roti'wa hã. Ĩtẽme wisi wamhã, ma tô hi'rãtitõ ĩpapara nhamra. Tawamhã te tãma tinha, ãne: — Ĩ̱'ra hã azarudu hã ma tô ĩ̱wi dârâ, ãhãna si. Tane nherẽ, ma'ãpé ãma ĩ̱me aimorĩ, asib'rada ãma hiri da, hâiwa'utu da, ĩ̱ma 're morĩ da apâ. ");
INSERT INTO xavNT_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Tawamhã Zezusi hã ma tô wahudu. Wahutu wamhã, ma tô ĩsiré mo. Ĩsiré 're ĩwanomro mono norĩ zama, wa ĩsiré ai'aba'ré ni. ");
INSERT INTO xavNT_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Tawamhã morĩ ré, te pi'õ hã we ĩsarina mo, ĩbabarãi hawi. Pi'õ hã ĩhâzé te te ĩsazâri'õ, 12 na ma tô ãma tiwahu, ĩhâzé te te 're 'manharĩ mono ré hã. We ĩsarina morĩ wamhã, ma tô ĩ'uza hânhisudu hã upi. ");
INSERT INTO xavNT_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Ta hã ma tô ãne sima rosa'rata: “Ĩ'uza si te tiwi upi nherẽ, wa za séptârâ.” Ãne te sima rosa'rata, pi'õ hã. ");
INSERT INTO xavNT_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Tawamhã pi'õ, ĩ'uza te te upi wamhã, ma tô Zezusi hã sô aipi'ra. Sipi'rai wamhã, ma tô pi'õ hã tisã. Ãne te tãma tinha: — Ĩ̱siwadi, aiwi robzei'õ tõ. Za te aipesezém na, ĩ̱'umnhasi zarina ma tô aihâzé hã aima apa. Tawamhã awa'awi ma tô pi'õ hã séptârâ. ");
INSERT INTO xavNT_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Taha pari, te mo Zezusi hã, dama roti'wa nhorõwa u. Morĩ wamhã, rowamreme'wa norĩ hã ma tô sõpẽtẽ za'ra, adâ'â ãma simnhihãsi ré. Da'ahâ na ma tô da'anhopẽtẽ, ãma ĩda'ry'ry norĩ hã. ");
INSERT INTO xavNT_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Tawamhã ãne te dama tinha: — Mo oto aiwairébé aba. Azarudu hã dâ'â õ di. Taré te nhono. Tawamhã ma tô ãma tawa'ẽ za'ra ni, dâ'â uptabi nherẽ, taré ĩsõtõ na te te waihu'u wa, Zezusi hã. ");
INSERT INTO xavNT_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Tawamhã rob u ma tô tawairébé ni. Dawairébé wi, ma tô Zezusi hã ãzé 'ri 're wa'wa u, azarudu ĩnomrozéb u. Tawamhã awa'awi ma tô pa'â. Te te pa'âri wamhã, ma tô awa'awi wahudu, azarudu hã. ");
INSERT INTO xavNT_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Tawamhã ĩwasu'u hã ma tô te te ropé daro mono bâ, Darireza na danhipti'a nho'õmo nhisi 'remhã. ");
INSERT INTO xavNT_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Tawamhã 'ri para hawi watobro wamhã, morĩ ré, ma tô aibâ norĩ hã ĩsarina tineb zahuré, ĩtob'a zahuré hã. Tawamhã te 'mahârâ zahuré, ãne: — Dawihi nhihudu, ma'ãpé wa'ãma aipẽ'ẽzé na. ");
INSERT INTO xavNT_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Tawamhã 'ri para u ma tô ãzé, Zezusi hã. Sébré wi, ma tô ĩtob'a norĩ hã ĩtẽme aimasisi zahuré. Tawamhã Zezusi hã te sadanharĩ zahuré: — E te asina ĩ̱'umnhasi 'wa, te ato pese aba da hã. Tawamhã asa te tãma nharĩ zahuré: — Ĩhe, wa tô wasina ai'umnhasi ni, apito. ");
INSERT INTO xavNT_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Tawamhã Zezusi hã ma tô tõmo upi zahuré. Te duré tãma nharĩ zahuré: — Asina ĩ̱'umnhasi aba zéb zarina, wa za tô ato pese 'wa. ");
INSERT INTO xavNT_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Tawamhã ma tô oto tito pese zahuré, aibâ norĩ hã. Ma tô duré sadawa uwati zahuré, ãne: — Te aima ĩ'manharĩ wẽ wa'aba zém na, dama ĩ̱wasu'u wa'aba õ di za. Tô'ã. — Ãne te sina sadawa uwati zahuré. ");
INSERT INTO xavNT_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Tane nherẽ, oto neb zahuré wamhã, ma tô tisiwasu'u na te te ropé zahuré ropâ, Zezusi te te ĩpese zahuré zém na. ");
INSERT INTO xavNT_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Tawamhã Zezusi te te ĩto pese zahuré neb za'u si, ma tô aibâ hã we ĩtẽme dasiwi saprõni ni Zezusihi u, wa'uburé ré wa, mreme'õ u'âsi 're ĩhâimana mono hã. ");
INSERT INTO xavNT_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Tawamhã Zezusi hã ma tô wa'uburé ma rob'ru, ĩhawi watobro da, ĩsiti. Te te tãma rob'rui wi, ma tô aibâ hã mreme watobro. Taha wa, ma ãma tatob'uzu za'ra ni. Te duré dasima nharĩ za'ra ni, ãne: — Niwa, wa te ĩ'madâ'â za'ra õ, ãne hã, Izarazéhé nhihudu norĩ nhipti'ai 'remhã. ");
INSERT INTO xavNT_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Tane nherẽ, ma tô parisezu norĩ hã taré ĩwasédé hã ãma hiri za'ra, ãne: — Wa'uburé norĩ nhib'apito zadawa para, te õ hã wa'uburé hã te te dama 're anhamra, Satanasihi zadawa para. — Ãne ma tô parisezu norĩ hã siwi wẽ'õ, Zezusi hã. ");
INSERT INTO xavNT_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Tawamhã Zezusi hã ma tô datẽme 're mo, 'ri wa'õtõ mono bâ, te te dama 're rowahutu mono da, zudezu norĩ te, rowahutuzé mono bâ. 'Re ĩhâimana u'âsi mono, da'ãma 're ĩsib'a'uwẽ mono zé wasu'u na te te dama 're rowasu'u, ĩwasu'uwẽ na. Dahâzé mono bâ ma tô duré da'apese. Hâzé u'âsi wa, sib'uware na 're ĩnomro mono norĩ zama te apese, Zezusi hã. ");
INSERT INTO xavNT_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Tawamhã da'ahâ uptabi na te te da'ab'madâ'â wamhã, ma tô Zezusi hã da'ãma aiwamri tipẽ'ẽ na, pone'ẽrebâ 'madâ'â ãna 're ĩnomro mono ne, robzei ãna 're dahâimana za'ra mono wa, 're dasipawapto waihu'u za'ra mono õ wa. ");
INSERT INTO xavNT_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Tawamhã ĩsiré 're ĩwanomro mono norĩ ma, te tinha, ãne: — Amnho hã sa'ẽtẽ uptabi di, da te 're ĩ'ubumroi mono da hã. Tane nherẽ, sada hã da'umrore di, ĩ'ubumroi'wa da hã. ");
INSERT INTO xavNT_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Taha wa, ma'ãpé tiwi 're rowaptẽrẽ u'âsi za'ra wa'aba mono, rob're tede'wai wi, romhuri'wa da hã we te te da'azatõrĩ da da'ahâ na, rob're hã te te 're ubumro za'ra mono da. — Ãne ma tô Zezusi hã da'ãma romnhimiré'é. ");
INSERT INTO xavNT_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Tawamhã Zezusi hã ma tô sitẽme wazô hâ, ĩsiré 're ĩwanomro mono norĩ zô, 12 na wahâiba norĩ zô. Wazô hârâ za'ra wamhã, ma tô wama pisutu za'ra, ĩwaihu'u pese zarina ĩsadawa para, wa'uburé norĩ te te 're ĩdawamnarĩ za'ra mono hã wa te dama 're sãmra za'ra mono da. Duré ĩhâzé ré norĩ hã dahâzé mono bâ ĩsadawa para, wa te 're dapese za'ra mono da, ma tô duré wama pisutu za'ra, duré hâzé u'âsi 're hâimana za'ra mono wa, 're ĩsib'uwa pese za'ra mono norĩ zama. ");
INSERT INTO xavNT_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Zezusi hã daro mono bâ te za oto wazatõrĩ za'ra, ĩsiré 're ĩwanomro mono norĩ hã, ĩsadawa para wa te dama 're sadawa wasu'u za'ra mono da. Tizadawa wasu'u'wa na, ma tô wanhisi za'ra oto, Zezusi hã. Wanhisi za'ra hã, ãne: Sima na ĩsisi hã. Taha nhisi amo hã Pedru. Duré ĩno nhisi hã Ãdéré na ĩsisi hã. Duré Ti'adu, duré Ti'aduhu no, Zuwã. Ta norĩ hã Zebedehe 'ra norĩ. ");
INSERT INTO xavNT_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","4","Duré Piripi, duré Batoromezu, duré Tome, duré wa hã Mateusi. Wa hã rob'uiprazé ubumroi'wa aré. Duré Ti'adu, Apezuhu 'ra hã. Duré Tadezu, duré Sima aimawi hã. Ta hã ma tô aré dame 're hâimana, romanu norĩ zada, tirom hawi apâ te te 're satõrĩ za'ra mono da. Duré Zudasi Icarizoti, Zezusi hã te te dama ĩhâiba nhomri da hã. ");
INSERT INTO xavNT_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Tawamhã Zezusi hã te te wazatõrĩ za'ra da, ma tô ãne wama roti za'ra, 12 na wahâiba norĩ ma hã: — Zudezu'õ norĩ nhipti'ai u 're anomro aba mono õ di za. Duré samaritanu norĩ nhipti'ai u 'ri nho'õmo mono bâ, 're asisisi aba mono õ di za. ");
INSERT INTO xavNT_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Izarazéhé nhihudu norĩ u si te za 're anomro aba mo, pone'ẽrebâ 'madâ'â ãna, siwa'ru 're ĩnomro mono ne, 're ĩdahâimana za'ra mono norĩ u si. ");
INSERT INTO xavNT_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Ãne te za dama 're ĩrowahutu za'ra wa'aba mo: “'Re ĩhâimana u'âsi mono, da'ãma 're ĩsib'a'uwẽ mono zéb u hã romhuture di oto.” ");
INSERT INTO xavNT_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Ĩhâzé ré norĩ hã te za duré 're ĩpese za'ra wa'aba mo. 'Re dadâ'â za'ra mono nherẽ, te za duré 're ĩdahâiwa'utu za'ra wa'aba mo. Ĩ'wa're ré norĩ zama te za 're ĩpese za'ra wa'aba mo. Wa'uburé hã te za dama 're ĩsãmra za'ra wa'aba mo. Wa'âbâ ãna wa tô ĩ̱waihu'u pe hã aima sõmri za'ra wa'wa. Taha wa, wa'âbâ ãna te za ãne uburé dama ãma 're ĩ'uwaimrami wẽ za'ra wa'aba mo. ");
INSERT INTO xavNT_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Rob'uiprazé ĩsapotore hã asiré 're 'wasari aba mono õ di za, ẽtẽ'ubuzi pré oru hã duré ẽtẽ'ubuzi'a prata zama. ");
INSERT INTO xavNT_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Dama romhuri'wai ma, te za dasa hã da te tãma 're sõmri za'ra, tiwi sô robaba wa. Taha wa, nimomo 're anomro aba mono wamhã, romramizé hã asiré 're 'wasari aba mono õ di za. Duré ai'uza misire ré si te za 're anomro aba mo. Aipara'uza misire ré si te za duré 're anomro aba mo. Wedehu hã asiwazusizé hã misire te za duré asiré 're ĩ'wasari aba mo. ");
INSERT INTO xavNT_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","— Nimomo daza'rui u 're anomro aba mono wamhã, asô 're ĩtob'uzu za'ra wa'aba mono norĩ u si te za 're asisisi aba mo. Tawamhã tame te za ĩsiré 're aihâimana za'ra wa'aba mo, 'ri tede'wa siré, nimomo 're anomro aba mono zéb u hã. ");
INSERT INTO xavNT_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Danhorõwa u 're asisisi aba mono wamhã, ãne te za 're ĩdazawi za'ra wa'aba mo: “Rowẽ na 're aihâimana za'ra wa'aba mono.” Ãne te za 're ĩdazawi za'ra wa'aba mo. ");
INSERT INTO xavNT_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Tawamhã danhorõwa u 're aihutu aba mono wi, da te 're ai'mazasi wẽ za'ra wa'aba mono wamhã, 're ĩsawi za'ra wa'aba mono zéb zarina, te za rowẽ na 're hâimana za'ra, 'ri tede'wa norĩ hã. Duré da te 're ai'mazasi wẽ za'ra wa'aba mono õ wamhã, rowẽ na 're hâimana za'ra mono õ di za, 'ri tede'wa norĩ hã. ");
INSERT INTO xavNT_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Duré nimomo darob u 're aihutu aba mono wamhã, asô 're datob'uzu za'ra wa'aba mono õ wamhã, da te 're aiwapari ze za'ra wa'aba mono õ wamhã, ta hawi te za 're aiwairébé aba mo. 'Re anomro aba mono zéb u, te za asisa'u aipara zapru hã 're ĩtata'a za'ra wa'aba mo, ti'ai u 're rere'e mono da, dapo're õ na 're danomro mono wa, 'râwi 're dasisãmri za'ra mono da. ");
INSERT INTO xavNT_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Tô sena, wa aima waihu'u za'ra wa'wa. Niwapsi 'Re ĩhâimana u'âsi mono, da'ãma ĩsipo'ozéb ãma hã Sodoma ãma duré Domora ãma 're ĩdahâimana wasété uptabi za'ra mono norĩ ma, te te ĩrob'manharĩ pipa zém nhipai u, te za asô 're ĩtob'uzu za'ra wa'aba mono õ norĩ hã te te tãma 're arob'manharĩ za'ẽtẽ. — Ãne ma tô Zezusi hã wama waihu'u za'ra, ĩsiré 're ĩwanomro mono norĩ ma. ");
INSERT INTO xavNT_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","Tawamhã Zezusi te duré wama rowasu'u za'ra, ĩsiré 're ĩwanomro mono norĩ ma: — Ma'ãpé ĩ̱wapari pese za'ra wa'aba. Pone'ẽrebâire, robzahi wa'wa u 're ĩsisisi mono ne, wa za datẽme asatõrĩ za'ra wa'wa. Taha wa, te za asimiza'rese 're anomro aba mo, wahi ne. Duré utu'u, marĩ ĩwasédé hã te te 're ĩ'manharĩ za'ra mono õ ne, te za 're anomro wẽ wa'aba mo. ");
INSERT INTO xavNT_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Taha wa, te za 're asipibui pese za'ra wa'aba mo, dawi. Ãté ni'wam norĩ hã te za te te sima 're aiwẽ za'ra wa'wa, te te 're aiwaibui wa'aba mono da, zudezu norĩ ma roti'wa norĩ u, te te 're asimroi wa'aba mono da. Tawamhã ta norĩ hã te te siwi 're aiwẽ'õ za'ra wa'aba mono zéb zarina, te za duré ĩsimirowahutuzéb ãma da te 're ai'maipré'é 'wa, romhâ nhorõ 'manharĩ na. ");
INSERT INTO xavNT_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Duré ĩ̱'ãma si 're anomro aba mono wa, te za dama ĩpire norĩ u da te 're asimroi wa'wa, zudezu'õ norĩ nhib'apito norĩ u, te te 're aiwaihu'u za'ra wa'aba mono zéb zarina, te te siwi 're aiwẽ'õ za'ra wa'aba mono da. Taha ré, ĩsõ're 're aimasa aba mono ré, te za ĩ̱wasu'uwẽ na tãma 're ĩrowasu'u za'ra wa'aba mo, ĩsib'a'uwẽ norĩ ma zama. ");
INSERT INTO xavNT_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Tawamhã dama ĩpire norĩ u, da te 're asimroi wa'aba mono wamhã, asimirosa'rata na asisõwa asina 're aihâtâ'â za'ra wa'aba mono õ di za, niha tãma 're asiwasu'u za'ra wa'aba mono zém na da hã. Da te aima 're ĩropipa za'ra wa'aba mono zéb u, da te 're asimroi wa'aba mono wamhã, 'Re ĩhâimana u'âsi mono te za te te aima 're sõmri za'ra wa'wa, niha tãma 're asiwasu'u za'ra wa'aba mono zéb da hã. ");
INSERT INTO xavNT_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Tãma 're asiwasu'u za'ra wa'aba mono wamhã, asi'uihâ na asimirosa'rata na tãma 're aimreme zusi aba mono õ di za. 'Re ĩhâimana u'âsi mono, Tipẽ'ẽzani na te te aima 're ĩwaihu'u za'ra wa'aba mono zéb zarina si, te za tãma 're asiwasu'u za'ra wa'aba mo, danhib'apito norĩ ma. ");
INSERT INTO xavNT_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","— Da te 're ĩ̱zaze za'ra mono 'ru te, te za dasisãnawãi uptabi nherẽ, da te dasima 're dahâiba nhomri za'ra, da te 're danhimroi mono da. Damama norĩ hã te za ti'ra ma, ãne te te tãma 're rob'manharĩ wasété za'ra, 'râwim nherẽ. Duré da'ra norĩ hã timama uptabi da nherẽ, te za sada 're hâimana za'ra, te te dama 're hâiba nhomri za'ra mono da, da te 're simroi mono da, ĩna me. ");
INSERT INTO xavNT_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Uburé te za da te 're ai'ruiwapari za'ra wa'wa, ĩ̱zazei'wa 're anomro aba mono wa. Tane nherẽ, asiptete sina õne haré ĩ̱'ãma 're anomro u'âsi aba mono wamhã, te za asina 're ĩ'uwaimrami za'ra wa'aba mo, asõ'reptu za'ra wa'aba zé hã. ");
INSERT INTO xavNT_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Tawamhã nimame 'ri nho'õmo ãma da te 're ai'ruiwapari za'ra wa'aba mono wa, da te aima 're 'manharĩ wasété za'ra wa'aba mono wamhã, ta hawi te za 're aimani za'ra wa'aba mo, 'ri nho'õmo amoi u 're anomro aba mono da. Tô sena wa aima waihu'u za'ra wa'wa. Izarazéhé nhihudu norĩ nhipti'ai 're, 'ri wa'õtõ mono bâ ĩ̱wasu'uwẽ na romhuri 'rãsutu za'ra wa'aba õ ré, wa za we dama ĩ̱sihâi'ré apâ, dasiré ĩ̱podo hã. ");
INSERT INTO xavNT_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","25","— Romnhoré'wa norĩ hã te te 're romnhoré za'ra mono ré hã, pire na 're hâimana waihu'u za'ra mono õ di, tãma ĩromnhoré'wa norĩ ma hã. Tane nherẽ, romnhoré hã te te 're 'ruiwapari u'âsi za'ra mono wamhã, zahadu wapsi te za tãma ĩromnhoré'wa norĩ ne oto 're hâimana za'ra, aiwa. Duré te te dama 're ĩromhuri za'ra mono norĩ hã te te dama 're romhuri za'ra mono ré hã, hâimana pire na 're hâimana waihu'u za'ra mono õ di, tinhib'apito norĩ nhipai u hã. Tane nherẽ, tipire zô te te 're rob'ruiwapari u'âsi za'ra mono wamhã, zahadu wapsi te za tinhib'apito ne pire na 're hâimana za'ra oto. Ĩ̱'ruiwapari'wa norĩ hã te Bezebu na te te 're ĩ̱nhisi za'ra, wa'uburé norĩ nhib'apito nhisi na. Ãne te ta norĩ hã te te ĩ̱'ãma 're wasété za'ra. Taha wa, taha nhipai u te za duré te te ai'ãma 're wasété uptabi za'ra wa'wa, ĩ̱siré 're anomro aba mono wa. ");
INSERT INTO xavNT_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","Tawamhã Zezusi te duré wama rowasu'u za'ra, ĩsiré 're ĩwanomro mono norĩ ma: — Taha wa, dama 're aipahi za'ra wa'aba mono õ di za. Uburé marĩ hã upsibi na 're ĩhâimana za'ra mono hã zahadu wapsi te za suwa nhamra ni. Duré uburé marĩ hã pi'uriwi 're ĩhâimana za'ra mono hã te za niwapsi waihu'u za'ra ni. ");
INSERT INTO xavNT_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Uburé pi'uriwi te aima 're ĩwaihu'u za'ra wa'aba mono hã te za oto sõ'awi dama ãma 're ĩrowasu'u za'ra wa'aba mo. ");
INSERT INTO xavNT_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Dahâiba te te dawi 're ĩsimroi mono norĩ ma hã, tãma 're aipahi za'ra wa'aba mono õ di za, dapẽ'ẽzani hã te te dawi 're simroi waihu'u mono õ nherẽ. 'Re ĩhâimana u'âsi mono si te za asima 're ĩpipa za'ra wa'aba mo. Taha ma si waihu'u pese di, dahâiba hã duré dapẽ'ẽzani zama, te te dawi 're ĩ'a'uprosi mono zéb da hã. ");
INSERT INTO xavNT_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Sire wa'â hã wa'âbâ syryre nherẽ, uburé Damama zadawa para õ nherẽ, 're si'utõrĩ mono da hã, mare di, sire norĩ hã. ");
INSERT INTO xavNT_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Tane duré, aséré za'rata aba zama, tãma waihu'u pese di, 'Re ĩhâimana u'âsi mono ma hã. Simi'madâ'â pese uptabi di. ");
INSERT INTO xavNT_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Sire hã tãma sawi pese za'ra nherẽ, sire zawi nhipai u, tãma asawi uptabi za'ra wa'aba di, 'Re ĩhâimana u'âsi mono ma hã. Taha wa, asina 're aihâtâ'â za'ra wa'aba mono õ di za. — Ãne ma tô wama rowasu'u za'ra Zezusi hã, ĩsiré 're ĩwanomro mono norĩ ma hã. ");
INSERT INTO xavNT_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","Tawamhã Zezusi hã te duré wama rowasu'u za'ra, ĩsiré 're ĩwanomro mono norĩ ma: — Ni'wam norĩ hã ĩ̱zazei'wa na dama 're siwasu'u za'ra mono wamhã, wa hã wa za duré Ĩ̱mama nho'a te 're awasu'u, ĩ̱zazei'wa na, hâiwa ãma 're ĩsãmra mono nho'a. ");
INSERT INTO xavNT_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Tazahã, ni'wam norĩ hã ĩ̱zazei'õ'wa na dama 're siwasu'u za'ra mono wamhã, wa hã wa za duré Ĩ̱mama nho'a te 're awasu'u, ĩ̱zazei'õ'wa na, hâiwa ãma 're ĩsãmra mono nho'a. — Ãne te wama rowasu'u za'ra, Zezusi hã. ");
INSERT INTO xavNT_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","Tawamhã te duré ĩsiré 're ĩwanomro mono norĩ ma rowasu'u za'ra, Zezusi hã: — E ti'ai u we ĩ̱morĩ wa, te za ti'ab ré rowẽ na si dasiré 're dahâimana za'ra, simisutu. Mare di. Ãne hã ĩ̱'ãma 're rosa'rata za'ra wa'aba mono õ di za. Ti'ai u we ĩ̱morĩ wa, rowẽ na si 're dahâimana za'ra mono õ di za. Te za ĩ̱'ãma dasima 're dasiwanhizari. Te za duré ĩ̱'ãma 're dasi'wapé za'ra. ");
INSERT INTO xavNT_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Ti'ai u we ĩ̱morĩ wa, te za da'ra si'aibâ norĩ hã timama ãma 're sitob'ru za'ra. Da'ra sipi'õ norĩ hã te za duré tina ãma 're sitob'ru za'ra. Duré dasani'aba norĩ hã te za timaprebaba sipi'õi ãma 're sitob'ru za'ra. ");
INSERT INTO xavNT_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Ãne te za dasisãnawãi uptabi nherẽ, dasina 're danhitob'ru uptabi za'ra, 'râwi dasiré 're dahâimana za'ra mono nherẽ. ");
INSERT INTO xavNT_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","— Ni'wam norĩ hã te te 're ĩ̱zawi za'ra mono zém nhipai u, timama norĩ hã te te 're sawi pese za'ra mono wamhã, ĩ̱'ãma 're nomro waihu'u mono õ di za. Duré ni'wam norĩ hã ĩ̱zawi nhipai u ti'ra norĩ te te 're sawi pese za'ra mono wamhã, ĩ̱'ãma 're nomro waihu'u mono õ di za duré. ");
INSERT INTO xavNT_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Wedepo'o nhonhi'rãmi hã, daza'ozéb da, da te dasisada 're ĩ'wasari mono ne, ni'wam norĩ hã da te 're simroi mono da nherẽ, sisawi ãna ĩ̱zarina 're nomro mono wapsi, te za ĩ̱'ãma 're hâimana u'âsi za'ra. Ãnei õ wamhã, ĩ̱'ãma 're nomro waihu'u mono õ di za. ");
INSERT INTO xavNT_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Ni'wam norĩ hã si'uihâ na tihâimanazép si te te sima 're sawi za'ra mono wamhã, rowẽ ĩsi'utõrĩ'õ hã te te sina 're uwaimrami za'ra mono õ di za. Ni'wam norĩ hã ĩ̱zarina 're nomro mono da, 're sihâiba zawi za'ra mono õ wapsi, te za te te sina 're uwaimrami za'ra, rowẽ hã. — Ãne ma tô wama rowasu'u za'ra, Zezusi hã. ");
INSERT INTO xavNT_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","Tawamhã te duré ãne na wama rowasu'u za'ra, ĩsiré 're ĩwanomro mono norĩ ma: — Ni'wam norĩ hã te te 're aiwaibui wẽ wa'aba mono wamhã, ta norĩ hã ai'u'âbâ wa'aba te za te te siwi 're ĩ̱mrami wẽ. Ta norĩ hã te te siwi 're ĩ̱mrami wẽ mono wa, we ĩ̱zatõrĩ'wa zama te za duré ĩ̱siré te te siwi 're mrami wẽ. ");
INSERT INTO xavNT_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Ãté ni'wa hã te za 'Re ĩhâimana u'âsi mono zadawa wasu'u'wa hã âri wẽ, ĩsadawa wasu'u'wa na te te waihu'u wa. Ãne ni'wam norĩ hã te te 're 'manharĩ wẽ za'ra mono wamhã, tizadawa wasu'u'wa norĩ ma, za te te 're ĩ'awa'âbâ mono ne, te za 'Re ĩhâimana u'âsi mono hã te te tãma 're awa'âbâ aiwa, damrami wẽ 'wa norĩ ma hã. Ãté ni'wa hã te za duré 'Re ĩhâimana u'âsi mono nhimiroti zarina 're ĩmorĩ wẽ uptabi hã âri wẽ, 're ĩmorĩ wẽ uptabi na te te waihu'u wa. Ãne ni'wam norĩ hã te te 're 'manharĩ wẽ za'ra mono wamhã, tinhimiroti 'madâ'â pese 'wa norĩ ma, za te te 're ĩ'awa'âbâ mono ne, te za duré 'Re ĩhâimana u'âsi mono hã te te tãma 're awa'âbâ aiwa. ");
INSERT INTO xavNT_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","— Ãté ni'wa hã te za ĩ̱zazei'wai ma, â wahâ hã tãma õ, te te hâ'rẽne da, ĩsiré ĩ̱zazei'wa norĩ ma ĩwapu ma, 're ĩmorĩ na te te waihu'u wa. Ãne hã ĩ̱zazei'wa norĩ hã marĩ 'rare na nherẽ, ni'wam norĩ hã te te 're pawaptob za'ra mono wamhã, 'Re ĩhâimana u'âsi mono, za te te tãma 're ĩ'awa'âbâ mono zé hã te za te te sina 're uwaimrami za'ra. Tô sena, wa aima waihu'u za'ra wa'wa. — Ãne ma tô Zezusi hã wama rowasu'u za'ra, daro mono bâ te te ĩwazatõrĩ za'ra zéb u hã. ");
INSERT INTO xavNT_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Tawamhã 12 na ĩsiré 're ĩwanomro mono norĩ ma, ãne na te te wama roti za'ra pari wamhã, ma tô mo Zezusi hã, dama ĩsãmrazém hawi, tamomo 'ri nho'õmo mono bâ te te dama rowahutu mono da. ");
INSERT INTO xavNT_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Tawamhã Zuwã Batita, dazazéb 're sãmra ré, ma tô Cristuhu wasu'u hã wapa, marĩ te te dama 're ĩ'ab'manharĩ wẽ mono zé hã. Te te wapari wamhã, ma tô ĩsiré 're ĩnomro mono norĩ hã 'mazatõrĩ za'ra, Zezusi hã te te siwi 'mazadanharĩ da. ");
INSERT INTO xavNT_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","Ãne ma tô siwi sadanha: — E a hã Zuwã Batita te te dama 're aiwasu'u mono, te we aimo. E zahadu aimawi zô, wa za 're wanhimipari za'ra. ");
INSERT INTO xavNT_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Tawamhã Zezusi hã te asa tãma nharĩ za'ra, ãne: — Mo oto apâ ai'aba'réi wa'aba Zuwãhã u, marĩ hã ĩwapari za'ra wa'aba zém na tãma rowasu'u za'ra wa'aba da, marĩ hã ĩ'madâ'â za'ra wa'aba zém na zama. ");
INSERT INTO xavNT_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Ĩtob'a norĩ hã to pese za'ra wa, ma tô apâ te te 're rob'madâ'â za'ra. Ĩmorĩ'õ norĩ hã te oto para na 're nomro. Duré ĩ'wa're ré norĩ hã ma tô 're pese za'ra. Hâiba wẽ na te oto 're nomro. Duré ĩpo'reptõ norĩ hã te oto 're simipari za'ra. Duré 're ĩdâ'â za'ra mono norĩ hã ma tô duré apâ 're hâiwa'utu za'ra. Ĩ̱wasu'uwẽ hã ma tô duré ĩsibrob'õ norĩ hã te te 're wapari za'ra. Ãne na te za tãma ĩrowasu'u za'ra wa'wa, Zuwãhã ma. ");
INSERT INTO xavNT_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Ni'wam norĩ hã, wa hã 'Re ĩhâimana u'âsi mono zadawa para we ĩ̱morĩ na, 'râwi ĩ̱'ãma 're siwawã za'ra mono õ wamhã, ta norĩ ma si tãma 're rowẽ uptabi za'ra mono di za. — Ãne te tãma rowasu'u za'ra, Zezusi hã. ");
INSERT INTO xavNT_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Tawamhã Zuwã Batitaha siré 're ĩnomro mono norĩ hã apâ si'aba'réi wamhã, ma tô Zezusi hã dama rowasu'u, Zuwã Batitaha hâimanazém na. Da'ahâ na ĩdasi'ubumroi mono norĩ ma, te ãne tãma rowasu'u za'ra: — Zuwã hã a'ubuni wi 're sãmra mono ré, ma tô ĩtẽme 're anomro aba mo, 're sabu za'ra wa'aba mono da. E tawamhã du teihi 'rãihâ hã uware wa, rowa'u te te 're ĩhâpâ za'ra mono ne, Zuwã Batita hã roti da, sib'uware na 're hâimana mono wa, ma tô ĩtẽme 're anomro aba mo. Mare di. Ta hã roti da, siptete na ma tô 're hâimana. ");
INSERT INTO xavNT_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","E uza wẽ na 're si'uza mono wa, ma tô ĩtẽme 're anomro aba mo, 're sabu za'ra wa'aba mono da. Mare di. Uza wẽ na 're si'uza mono õ di. Uza wẽ ré 're ĩnomro mono norĩ hã, te danhib'apito nhorõwa ãma si 're si'ubumro, 'ri 'rãihâ ãma si. ");
INSERT INTO xavNT_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Ma'ãpé, ĩ̱ma wasu'u za'ra wa'aba za. E 'Re ĩhâimana u'âsi mono zadawa wasu'u'wai wa, te ĩtẽme 're anomro aba mo, 're sabu za'ra wa'aba mono da. Tane tô. Õ hã uburé ĩwana 'Re ĩhâimana u'âsi mono zadawa wasu'u'wa norĩ nhipai u te pire na 're hâimana, Zuwã hã. ");
INSERT INTO xavNT_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Duréihã ma tô 'Re ĩhâimana u'âsi mono zadawa wasu'u'wa hã ãne ãma rob'ui'éré, Zuwãhã ãma, 'Re ĩhâimana u'âsi mono mreme na: “Ĩ̱zadawa wasu'u'wa, wa za aiwana satõ, te te asô ropese mono da.” Ãne duréihã 'Re ĩhâimana u'âsi mono mreme na rob'ui'éré, ĩbaihâ na hã. ");
INSERT INTO xavNT_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Tô sena wa aima waihu'u za'ra wa'wa. Uburé ĩwana 're ĩnomro mono norĩ hã te te siwi ãma wabzu za'ra õ di Zuwã Batita hã, ĩsimiromhuri pire na hã. Tane nherẽ, 'Re ĩhâimana u'âsi mono te te 're ĩda'azawi mono zéb zarina te te 're ĩda'apawapto mono zé hã, hâiba ré ré, te te waihu'u õ di za, Zuwã Batita hã. Ni'wam norĩ si, 'Re ĩhâimana u'âsi mono nhib'a'uwẽ norĩ si te za te te sina 're waihu'u za'ra, ĩ'uirĩ na. Taha wa, ta norĩ hã te za pire na 're hâimana za'ra, Zuwã Batitaha nhipai u. Duré ni'wam norĩ hã 'Re ĩhâimana u'âsi mono nhib'a'uwẽ norĩ hã, tisiré norĩ ma, wapu na 're hâimana za'ra mono nherẽ, te za pire na 're hâimana za'ra, Zuwã Batitaha nhipai u, ta norĩ si ĩ'uirĩ na te te sina 're waihu'u za'ra mono wa za, 'Re ĩhâimana u'âsi mono te te 're ĩda'apawapto mono zé hã. ");
INSERT INTO xavNT_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Zuwã Batita hã, 'Re ĩhâimana u'âsi mono te te dama 're ĩsadawa wasu'u mono zém na te te dama ãma ĩsãna'ratazém hawim haré, te oto ni'wam norĩ hã sib'ru na 're hâimana za'ra, 'Re ĩhâimana u'âsi mono hã da'ãma 're sib'a'uwẽ mono tõ da. Da te dasima 're wẽ za'ra mono nherẽ, te ta norĩ hã te te dawi 're ro'wa'rutu za'ra, 'Re ĩhâimana u'âsi mono hã ãma 're sib'a'uwẽ za'ra mono tõ da. ");
INSERT INTO xavNT_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Zuwãhã wana ré hã, ma tô 'Re ĩhâimana u'âsi mono zadawa wasu'u 'rata 'wa norĩ hã te te ãma 're rob'ui'éré za'ra Mozésihi zama, 'Re ĩhâimana u'âsi mono, za da'ãma 're ĩsib'a'uwẽ mono zé wasu'u na hã. ");
INSERT INTO xavNT_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Tawamhã ĩsimirowasu'u za'ra na, 're saze za'ra wa'aba mono wamhã, taha zarina te za duré ãne 're ĩsaze za'ra wa'aba mo, Eriasi ti'ai u za we ĩmorĩ na Zuwã te te ĩwasu'u na hã. ");
INSERT INTO xavNT_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Asimipari pese aba wamhã, ma'ãpé ĩ̱wapari pese za'ra wa'aba. ");
INSERT INTO xavNT_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","17","— E 'wai ãma, wa za oto romnhimiré'é, ãhãna 're ĩdahâimana za'ra mono norĩ ãma hã. Ai'uté norĩ ãma, wa za simiré'é. 'Ri nhi'riti wa, rowedezéb ãma si'ubumroi ré, te za ãne si'mahârâ za'ra, ai'uté norĩ hã: “Wa norĩ hã wa tô aima rowamreme za'ra wa'aba ni aré, dasina damro wa, rowamremezém na. Tane nherẽ, ãma ato za'ra wa'aba õ di. Duré da te dasina 're ti'a za'ra mono wa, rowamremezém na wa tô aré aima rowamreme za'ra wa'aba ni. Tane nherẽ, wame ai'ry'ry wa'aba õ di.” Ãne te za si'mahârâ za'ra. Ãne wa tô ai'uté norĩ ãma simiré'é, ãhãna 're ĩdahâimana za'ra mono norĩ hã. ");
INSERT INTO xavNT_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Duré Zuwã Batita hã te te dama 're sadawa wasu'u mono ré, 'Re ĩhâimana u'âsi mono 'madâ'â sina ma tô sai ãna te te 're romhuri, misi bâtâ na. Duré uwa 'ru 'rãi wa'u hã te te dame 're hâsi mono õ di. Taha wa, ma tô da te tãma 're nharĩ wasété za'ra. Ãne ma tô da te tãma 're nharĩ za'ra: “Õ hã wa'uburé te te 're pibui u'âsi.” ");
INSERT INTO xavNT_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Duré wa hã ti'ai ãma dasiré ĩ̱podo hã wa ĩ̱to sina dasiré 're ĩ̱sa, dasazém na. Uwa 'rãi wa'u ĩsé hã wa duré te dame 're hâsi. Taha wa, ma tô ãne na da te ĩ̱ma 're nharĩ wasété za'ra: “Ma'ãpé 'madâ'â za'ra wa'aba. Õhõta te aibâ hã sa za'ẽtẽ na 're sai u'âsi. Ta hã uwa 'ru 'rãi wa'u zei'wa duré. Rob'uiprazé ubumroi'wa norĩ siwadi ta hã, uburé siwa'ru 're ĩdanomro mono norĩ siwadi.” Ãne ma tô da te ĩ̱ma 're nharĩ wasété za'ra. Ni'wam norĩ hã 'Re ĩhâimana u'âsi mono nhimiroti zarina 're nomro mono wamhã, te za marĩ ĩwẽ si te te 're 'manharĩ u'âsi za'ra. Ãne wa, te za ĩwaihu'u pese za'ra wa'wa, tô sena 'Re ĩhâimana u'âsi mono nhimiroti ĩwẽ uptabi na hã. — Ãne ma tô Zezusi hã dama rowasu'u. ");
INSERT INTO xavNT_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Tawamhã nima niwĩmhã 'ri wa'õtõ mono bâ 're ĩdahâimana za'ra mono norĩ hã dawasété wi 're dasipizari za'ra mono õ wa, ma tô Zezusi hã siwi dawẽ'õ, tiwaihu'u pese na marĩ dama ĩ'manharĩ waihu'u'õ hã tamep si te te dama 're ab'manharĩ wẽ u'âsi mono nherẽ. ");
INSERT INTO xavNT_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","Ãne te 'ri wa'õtõ ãma ma tinha Zezusi hã, 'ri wa'õtõ 're, 're ĩdahâimana za'ra mono norĩ ma: — Corazi na 'ri wa'õtõ nhisi ãma 're aihâimana za'ra wa'aba mono norĩ ma, aima 're ropipa uptabi za'ra wa'aba mono di za, Besada na 'ri wa'õtõ nhisi ãma 're aihâimana za'ra wa'aba mono norĩ ma zama. Marĩ dama ĩ'manharĩ waihu'u'õ hã asõ'a za'ra wa'aba, te 're ĩ'ab'manharĩ wẽ mono ne, Tiru ãma 'ri nho'õmo ãma, duré Sido ãma 'ri nho'õmo ãma 're ĩdahâimana za'ra mono norĩ nho'a, te dama 're ab'manharĩ mono 'wa'âhã, duréi te aré ta norĩ hã 're sipizari za'ra, tiwasété wi. Tiwasété wi 're ĩsipizari za'ra mono zém na, da te 're waihu'u za'ra mono da, te aré 'ru'a hã ti'rã nhisiwi te te 're sa'wari za'ra. Te duré aré sa'u ĩhâiro na 're si'uza za'ra. ");
INSERT INTO xavNT_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Tô sena wa aima waihu'u za'ra wa'wa. Niwapsi 'Re ĩhâimana u'âsi mono, da'ãma ĩsipo'ozéb ãma hã Tiru ãma duré Sido ãma 're ĩdahâimana wasété za'ra mono norĩ ma, te te ĩrob'manharĩ pipa zém nhipai u, te za te te 're aihâ za'ra za'ẽtẽ za'ra wa'wa, 'Re ĩhâimana u'âsi mono hã. ");
INSERT INTO xavNT_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Duré Capana'u ãma 're aihâimana za'ra wa'aba mono norĩ hã e danhipai u aipire na 're aihâimana za'ra wa'aba mono da, ma tô asina 're ĩrosa'rata za'ra wa'aba mo. Ropipa u si, te za 'Re ĩhâimana u'âsi mono hã te te 're asãmra 'wa, dapẽ'ẽ 're dadâ'â u'âsi ne 're ĩdahâimana za'ra mono zéb u. Marĩ dama ĩ'manharĩ waihu'u'õ hã asõ'a za'ra wa'aba, te dama 're ĩ'ab'manharĩ wẽ mono ne, duréihã Sodoma ãma 're ĩdahâimana wasété za'ra mono norĩ hã te ãma 're pawaptob za'ra mono 'wa'âhã, aré si'utõrĩ õ di, ta norĩ hã. Rowẽ na te aré 're hâimana u'âsi za'ra. ");
INSERT INTO xavNT_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Niwapsi 'Re ĩhâimana u'âsi mono hã da'ãma ĩsipo'ozéb ãma hã Sodoma ãma 're ĩdahâimana wasété za'ra mono norĩ ma, te te ĩrob'manharĩ pipa zém nhipai u, te za te te 're aihâ za'ra za'ẽtẽ za'ra wa'wa, tô sena. — Ãne ma tô Zezusi hã dama waihu'u, Capana'u ãma 're ĩdahâimana za'ra mono norĩ ma hã. ");
INSERT INTO xavNT_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Tawamhã Zezusi hã te duré Timama ma mre: — Ĩ̱mama, a hã Danhib'apito uptabi, hâiwa ãma zama, ti'ai ãma zama. A hã ma tô rowaihu'u pese 'wa norĩ wi 're ĩ'anhito mo, roti ĩwẽ hã te te waihu'u za'ra tõ da. Rowaihu'u prãi 'wa na 're ĩhâimana za'ra mono norĩ ma si, ma tô marĩ ĩwẽ hã 're ĩ'awaihu'u mo. Taha wa, wa ai'ãma ĩ̱wata, asõpru wa. ");
INSERT INTO xavNT_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Tane tô, Ĩ̱mama. Asima 're ĩ'awẽ mono zéb uwaibaba si, ma tô õ norĩ ma si 're ĩ'awaihu'u mo. — Ãne Zezusi hã ma tô Timama ma mre. ");
INSERT INTO xavNT_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Taha wa, te duré wama nharĩ za'ra, ĩsiré 're ĩwanomro mono norĩ ma: — Ĩ̱mama ma tô ĩ̱ma waihu'u, uburé 're ĩhâimana mono zé hã. Ni'wam norĩ hã si'uihâ na te te 're ĩ̱waihu'u za'ra mono õ di, 're ĩ̱hâimana mono zém na hã. Ĩ̱mama si ma tô ti'ra na ĩ̱waihu'u pese, 're ĩ̱hâimana mono zém na hã. Duré dasi'uihâ na Ĩ̱mama, da te 're waihu'u za'ra mono õ di za. Ĩ̱wétési wa tô Ĩ̱mama hã waihu'u pese, 're ĩhâimana mono zém na hã. Te ĩ̱sima 're ĩ'awẽ mono zéb uwaibaba si, wa za ni'wam norĩ ma si te 're awaihu'u, ta norĩ zama Ĩ̱mama hã te te waihu'u za'ra da, 're ĩhâimana mono zém na hã. — Ãne ma tô wama waihu'u za'ra, Zezusi hã. ");
INSERT INTO xavNT_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Tawamhã Zezusi hã te oto uburé dama tinha, ãne: — Marĩ ĩpire, da te 're 'wasari mono wamhã, te za 're dazadâ'â wairébé. Tane te duré a norĩ wa'wa hã 're asiwasutu u'âsi za'ra wa'aba mo, dama rowahutu'wa norĩ nhimirowasu'u hã 're ĩ'madâ'â pese za'ra wa'aba mono zéb zarina, 'Re ĩhâimana u'âsi mono te te 're asõ'reptu za'ra wa'aba mono da newa. Tane nherẽ, asina 're uwaimrami waihu'u za'ra wa'aba mono õ di za. Ãne hã uburé 're aihâimana za'ra wa'aba mono norĩ hã ma'ãpé we ĩ̱zô 're asõpré u'âsi aba mono. We ĩ̱zô 're asõpré u'âsi aba mono wamhã, wa za te 're aipẽ'ẽ nomri za'ra wa'wa, 're asiwasutu za'ra wa'aba mono tõ da oto. ");
INSERT INTO xavNT_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Wa hã ĩ̱pẽ'ẽ na ĩ̱nhimizawi pese uptabi di. Atãma ĩ̱hâimanazé hã. Taha wa, ma'ãpé ĩ̱'ãma 're sasõmri za'ra wa'aba mono, ĩ̱'ãma 're waihu'u pese za'ra wa'aba mono da. Tawapsi te za aipẽ ĩ're aima 're simi'wara 'wa. ");
INSERT INTO xavNT_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Marĩ ĩwapure, da te 're 'wasari mono wamhã, 're ĩdazadâ'â wairébé mono õ ne, te za aipẽ'ẽ wapu na 're anomro aba mo oto, ĩ̱nhimiroti zarina si. ");
INSERT INTO xavNT_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Tawamhã wa norĩ hã sabadu na wa tô ro'rahâri za'ra ni Zezusi norĩ hã, buru nho wa'wai baba, zudezu norĩ te, romhuri zahârizém na. Tawamhã ĩsiré 're ĩwanomro mono norĩ hã mrap te, wa tô aro 'rã ne hã da te 're ĩzuri mono hã wa te wasima 'rãnhinarĩ tridu 'rã hã, wa te huri mono da. ");
INSERT INTO xavNT_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Tawamhã parisezu norĩ hã te te ãma wa'madâ'â za'ra wamhã, Zezusihi ma, te nharĩ za'ra, ãne: — E 'madâ'â za'ra ãna, asiré 're ĩnomro mono norĩ hã. Ta norĩ hã ma tô aro 'rã ne hã te te sima 'rãnhinarĩ, sabadu na wawa'utuzém na nherẽ. Taha wa, wahi'rata nhimiroti hã ma tô ãma upa za'ra, dawa'utuzé bâtâ na romhuri, wa te dawi 're ĩsawi za'ra mono zém na roti hã. ");
INSERT INTO xavNT_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Tawamhã Zezusi hã te asa tãma nharĩ za'ra: — E apito Dawihi wasu'u na rob'ui'éré hã 're sõré za'ra wa'aba mono ã bâ, te te ĩrob'manharĩzém na tisiré norĩ me, mra te te simroi wamhã. ");
INSERT INTO xavNT_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","'Re ĩhâimana u'âsi mono ãma 're ĩdawata za'ra mono zéb u, ma tô ãzé, apito Dawi hã. Sébré wamhã, ma tô 'mai'rẽ, ĩ'u'ẽne hã. Ĩsiré norĩ zama ma tô tihu, 'Re ĩhâimana u'âsi mono ma, aré da te ĩsa'ra hã. 'Re ĩhâimana u'âsi mono, ma tô pisutu aré, da'ãma romhuri'wa norĩ si ĩ'u'ẽne hã te te 're huri mono da, sasedoti norĩ si. Tane nherẽ, ma tô 'mai'rẽne za'ra, Dawi norĩ hã. Te te 'mai'rẽne za'ra nherẽ, 'Re ĩhâimana u'âsi mono hã te te siwi wẽ'õ za'ra õ di, ta norĩ hã. ");
INSERT INTO xavNT_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","E sasedoti norĩ wasu'u zama, 're sõré za'ra wa'aba mono õ di duré, 'Re ĩhâimana u'âsi mono nhimiroti na Mozési te te ãma ĩrob'ui'éré na hã. Ta hã ma tô 're ĩsõré za'ra wa'aba mo, tô. Taha wa, te za oto ãma ĩwaihu'u pese za'ra wa'wa. Duréihã ta norĩ hã ma tô te te 're romhuri za'ra sabadu na, dawa'utuzém na nherẽ, 'Re ĩhâimana u'âsi mono ãma 're ĩdawata za'ra mono zéb ãma. Tawamhã 'Re ĩhâimana u'âsi mono hã romhuri zahârizém na romhuri hã te te dawi sawi nherẽ, te te 're romhuri za'ra mono wamhã, ĩwasédé hã te te ãma 're sa'ra mono õ di ta norĩ ãma hã, dawa'utuzém na te te 're romhuri za'ra mono nherẽ. ");
INSERT INTO xavNT_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Tô sena, wa aima waihu'u za'ra wa'wa. Ĩ̱nhimiroti hã pire uptabi di, duréi roti ma hã, 'Re ĩhâimana u'âsi mono nhorõwa ãma da'ãma romhuri'wa norĩ hâimanazém na, danhimiroti ma hã. ");
INSERT INTO xavNT_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Duréihã 'Re ĩhâimana u'âsi mono zadawa wasu'u'wa hã ma tô ãne na rob'ui'éré ĩbaihâ na hã, 'Re ĩhâimana u'âsi mono mreme na: “Asimizama hã ĩ̱ma 're ĩzata za'ra wa'aba mono zô, 're ĩ̱nhimipari mono õ di oto. Asimizawi pese zarina da'ãma 're aiwamri za'ra wa'aba mono da si, wa ĩ̱sima te 're aiwẽ za'ra wa'wa oto.” Ãne hã ãma waihu'u za'ra wa'aba wamhã, aré ĩwasédé hã ãma sa'ra wa'aba õ di, ĩ̱siré 're ĩnomro mono norĩ ãma hã, marĩ ĩwasédé hã te te 'manharĩ za'ra õ wa, ã bâtâ na. ");
INSERT INTO xavNT_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Wa hã 'Re ĩhâimana u'âsi mono te te ĩ̱pisudu, dasiré ĩ̱poto da, ti'ai ãma. Taha wa, dama ĩ̱pire di, romhuri zahârizém na roti hã te dama 're ĩ'apisutu mono zéb da hã. — Ãne ma tô Zezusi hã tãma siwasu'u za'ra, parisezu norĩ ma. ");
INSERT INTO xavNT_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Tawamhã Zezusi hã ta norĩ hawi morĩ wamhã, zudezu norĩ te, rowahutuzéb u ma tô ãzé. ");
INSERT INTO xavNT_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Tame te aibâ hã nhamra, ĩsimizu'rã're hã. Tawamhã ni'wam norĩ hã ma tô sima wẽ za'ra, duréihã 'Re ĩhâimana u'âsi mono nhimiroti na Mozési te te ãma ĩrob'ui'éré na hã sabadu na romhuri zahârizém na roti hã, te te ãma upai wa, Zezusihi ãma ĩwasédé hã te te ãma hiri za'ra da. Ma tô ãne siwi ãma sadanha, Zezusi hã: — Dawa'utuzém na dapesezé hã romhuri zahârizém na hã, e Mozésihi nhimi'ui'éré zarina. — Ãne te ãma siwi sadanha. ");
INSERT INTO xavNT_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Tawamhã asa te tãma nharĩ za'ra, Zezusi hã: — Pone'ẽrebâ hã aima 'maihâimana aba wamhã, ab're 'rehâ wa, aiwi 'maiwaptã'ã aba wamhã, e te aré ĩ'maiwazere 'wa, 'manho'reptui aba da hã. Te aré tô ĩ'maiwazere 'wa, romhuri zahârizém na 'maiwaptã'ã nherẽ, pone'ẽrebâ hã. ");
INSERT INTO xavNT_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Duré, 'Re ĩhâimana u'âsi mono hã pone'ẽrebâ te te 're azawi pese mono nherẽ, pone'ẽrebâ zawi nhipai u, tãma dazawi uptabi di. Taha wa, sabadu na romhuri zahârizém na ni'wam norĩ hã marĩ te te dama 're 'manharĩ wẽ za'ra mono wamhã, duréihã 'Re ĩhâimana u'âsi mono nhimiroti zarina, te za tô te te 're 'manharĩ za'ra, te te ãma 're upa za'ra mono ãna, ta norĩ hã. — Ãne te tãma rowasu'u za'ra, Zezusi hã. ");
INSERT INTO xavNT_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Tawamhã ĩsimizu'rã're ma, te duré tinha, Zezusi hã: — Ma'ãpé, asimizu wahutu. Tawamhã ma tô tinhimizu hã wahutu, aibâ hã. Te te wahutu wamhã, awa'awi ma tô tinhimizu pese apâ. Ĩsimizu amo ne, wẽ di oto. ");
INSERT INTO xavNT_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Tawamhã te te pese pari, ma tô parisezu norĩ hã wairé, te te sima ãma roti za'ra da, Zezusihi ãma, da te dasiwi wĩrĩ da, ĩsadawa parab za'ra. ");
INSERT INTO xavNT_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Tawamhã Zezusi hã ma tô sina waihu'u, parisezu norĩ te te sima ãma ĩroti za'ra zé hã te te siwi wĩrĩ da. Taha wa, ma tô ĩhawi timorĩ za'ra. Ĩhawi morĩ za'ra wamhã, da'ahâ na ma tô ĩsarina ai'aba'ré ni. Tawamhã daro mono bâ 're morĩ ré, ma tô uburé dahâzé ré hã da'apese, Zezusi hã. ");
INSERT INTO xavNT_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Te te da'apese parimhã, ma tô duré sina da'azadawa uwati, da te dasina 're wasu'u za'ra mono tõ da. ");
INSERT INTO xavNT_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Ãne ma tô Zezusi hã sina da'azadawa uwati, duréihã 'Re ĩhâimana u'âsi mono mreme na, Iza'iza hã ĩsadawa wasu'u 'rata 'wa te te ãma ĩrob'ui'érézé hã te te ãma uwaimrami da. Ãne duréihã 'Re ĩhâimana u'âsi mono mreme na rob'ui'éré hã: ");
INSERT INTO xavNT_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“Ãhãta te ĩpisudu ĩ̱ma romhuri'wa da, te 're ĩsawi pese mono hã. Taha ãma si wa ãma 're ĩ̱toi u'âsi. Taha ma, wa za ĩ̱pẽ'ẽzani hã tãma tisõ. Tawamhã daro mono bâ te 're ĩda'anho'reptui mono zé wasu'u na te za te te dama 're rowasu'u, da te 're ĩwaihu'u za'ra mono zéb da hã. ");
INSERT INTO xavNT_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Ta hã awa'awi te te dama 're anharĩ mono õ di za. Ãma 're ĩdawata za'ra mono zéb da hã, mreme 'rãihâ na te te dama 're rowasu'u mono õ di za, sõ'awimhã. ");
INSERT INTO xavNT_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Duré, buru teihi hã sihâpâ na 're simasa mono wamhã, e te za da te 're si'ẽ. Mare di. Taré te za da te 're wahutu za'ra, wahu na apâ 're simasa mono da. Tane duré, sib'uware na ĩ̱'ãma 're ĩnomro mono norĩ ma, te te tãma 're rob'manharĩ wasété za'ra mono õ di za, ta hã. Duré ĩro'ore hã ro'o nhib'uware nherẽ, da te 're ĩsimroi mono õ ne, sib'uware na ĩ̱'ãma 're ĩnomro mono norĩ ma, te te tãma 're rob'manharĩ wasété za'ra mono õ di za duré. Ta norĩ ãma te za 're siwamri u'âsi za'ra. Tawamhã nimahã na si te za oto ĩsimipawapto wẽ zéb zarina, da te 're waihu'u za'ra, dapoto mono bâ, te 're ĩda'anho'reptui mono zém na hã, ĩsitob'ru norĩ hã te te dawi 're ro'wa'rutu u'âsi za'ra mono nherẽ, da te 're waihu'u za'ra mono tõ da, te 're ĩda'anho'reptui mono zé wasu'u hã. ");
INSERT INTO xavNT_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Tawamhã daro mono bâ te za tô sena sô 're danhimipari za'ra, te te 're ĩda'anho'reptui mono zéb zô.” Ãne duréihã 'Re ĩhâimana u'âsi mono mreme na rob'ui'éré hã, Zezusihi ãma hã. ");
INSERT INTO xavNT_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Tawamhã Zezusihi tẽme, ma tô aibâ hã dasiwi saprõni ni, wa'uburé te te 're pibui u'âsi mono wa, ĩtob'a hã duré ĩmreme'õ hã. Tawamhã Zezusi hã ma tô pese. Te te pese parip si, ma oto mreme watobro, apâ. Te te rob'madâ'â wẽ di duré, aibâ hã. ");
INSERT INTO xavNT_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Tawamhã da'ahâ na ma ãma tatob'uzu za'ra ni. Taha wa, te dasima nharĩ za'ra ni, ãne: — Ãté õ hã apito Dawihi nhihudu, sô 're ĩwanhimipari za'ra mono. — Ãne te dasima ãma romnomri za'ra ni. ");
INSERT INTO xavNT_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Tawamhã ãne na parisezu norĩ te te dawapari za'ra wamhã, ma tô sima nharĩ za'ra, ãne, ta norĩ hã: — Õ hã Bezebuhu zadawa para, ma tô wa'uburé hã te te dama 're anhamra, wa'uburé norĩ nhib'apito zadawa para. Bezebu hã tiwaihu'u pe hã te te tãma 're sõmri mono õ 'wa'âhã, aré te te dama 're anhamra waihu'u mono õ di, wa'uburé hã. — Ãne ma tô parisezu norĩ hã Zezusihi nhimiromhuri na sima rowasu'u za'ra. ");
INSERT INTO xavNT_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Tawamhã te te ãma ĩrosa'rata wasété za'ra na, ma tô sina waihu'u za'ra, Zezusi hã. Taha wa, te ãne tãma ãma romnhimiré'é za'ra: — Danhib'apito nhib'a'uwẽ norĩ hã 'râwim nherẽ, oto sisada 're simasa mono wamhã, te aré 're si'uprosi. Duré 'ri nho'õmo ãma 're ĩdahâimana za'ra mono norĩ hã sisada 're hâimana za'ra mono wamhã, te aré 're si'uprosi. Duré dasisãnawã nherẽ, 'râwi dasisada 're dahâimana za'ra mono wa, 're dasi'wapé za'ra mono wamhã, te aré 're dasi'uprosi, 'râwim nherẽ. ");
INSERT INTO xavNT_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Tane duré, wa'uburé norĩ hã Satanasihi nhib'a'uwẽ, simisutu 're hâimana za'ra mono nherẽ, dapẽ'ẽ hawi 're wairébé mono da, te te sima 're rob'ru za'ra mono wamhã, te aré sisada 're hâimana za'ra, wa'uburé norĩ hã. Tawamhã sisada 're sipo'o za'ra mono wa, te aré wara sina 're si'utõrĩ, Satanasihi nhib'a'uwẽ norĩ hã. Ãne, ĩ̱ma ĩnharĩ za'ra wa'aba zéb zarina, Bezebuhu zadawa para, wa'uburé te dama 're anhamra mono 'wa'âhã, 'râwim nherẽ, te aré tô sisada 're simasa. Taha zarina, te aré tô ta norĩ hã 're si'uprosi. ");
INSERT INTO xavNT_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","28","Ma tô ĩ̱ma ĩnharĩ za'ra wa'wa, Bezebuhu zadawa para wa'uburé te dama 're ĩ'anhamra mono na. Asiré norĩ hã bété. E 'wa sadawa para, te bété wa'uburé norĩ hã te te dama 're sãmra, ta norĩ hã. E Bezebuhu zadawa para. Mare di. E Bezebuhu zadawa para wa'uburé te te dama 're ĩsãmra mono na, ma tô dama 're ĩwasu'u za'ra wa'aba mo. Mare di. Ãne na dama 're wasu'u za'ra wa'aba mono õ di. Taha wa, ma tô ãma ĩ'upa za'ra wa'wa, ĩ̱ma ĩnharĩ za'ra wa'aba zém na hã, Bezebuhu zadawa para, wa'uburé te dama 're ĩ'anhamra mono na. 'Re ĩhâimana u'âsi mono pẽ'ẽzani zadawa parap si, wa tô te dama 're anhamra, wa'uburé hã. Taha zarina si, te za oto ĩwaihu'u za'ra wa'wa, tô sena 'Re ĩhâimana u'âsi mono, ai'ãma 're ĩsib'a'uwẽ za'ra wa'aba mono zéb da, te te ãma ĩsãna'rata na hã. ");
INSERT INTO xavNT_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","— Ni'wa hã aibâ ĩsiptete nhorõwa u sébré wamhã, te te sima pawasisi õ ré, ĩsimarĩ hã te te tiwi ubumroi waihu'u õ di za, aibâ ĩsiptete wi hã. Te te sima pawasisi wapsi, te za ĩsimarĩ hã tiwi ubumro oto, 'ri 're tãma ĩromnhimi'wara hã. ");
INSERT INTO xavNT_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","— Ni'wam norĩ hã ĩ̱wẽ'wa 're nomro mono õ wamhã, ta norĩ hã te ĩ̱zada 're hâimana za'ra. Duré ni'wam norĩ hã 'Re ĩhâimana u'âsi mono u, te 're ĩda'anhimroi mono ne, te te 're danhimroi mono õ wamhã, ta norĩ hã te 'Re ĩhâimana u'âsi mono nhiti, te te 're dazatõrĩ za'ra. ");
INSERT INTO xavNT_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Taha wa, wa za duré ãne aima waihu'u za'ra wa'wa. Dawasédé hã da te 're 'manharĩ za'ra mono nherẽ, duré 'Re ĩhâimana u'âsi mono ãma da te 're wasété za'ra mono nherẽ, dawasété na tãma 're dasiwasu'u za'ra mono wamhã, tãma waihu'u pese di, dawasédé hã te te dama 're ĩ'apari mono zéb da hã, te te oto da'ãma 're ab'madâ'â tõ mono da. Tane nherẽ, 'Re ĩhâimana u'âsi mono pẽ'ẽzani ãma, da te 're wasété za'ra mono wamhã, taha na dawasédé hã te te dama 're apari mono õ di za oto. Te za te te da'ãma 're ab'madâ'â u'âsi, 'Re ĩhâimana u'âsi mono hã. ");
INSERT INTO xavNT_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Duré ni'wam norĩ hã dasiré ĩ̱poto ãma te te ĩ̱'ãma 're wasété za'ra mono wamhã, oto tiwasété na 'Re ĩhâimana u'âsi mono ma, 're siwasu'u za'ra mono wamhã, tãma waihu'u pese di, ãne hã ĩwasédé hã te te tãma 're pari za'ra mono da, te te oto ãma 're 'madâ'â tõ za'ra mono da. Tane nherẽ, ni'wam norĩ hã 'Re ĩhâimana u'âsi mono pẽ'ẽzani ãma te te 're wasété za'ra mono wamhã, te za õhõ na ĩwasédé hã te te ãma 're 'madâ'â u'âsi za'ra, 'Re ĩhâimana u'âsi mono hã. — Ãne na ma tô tãma rowasu'u za'ra, Zezusi hã. ");
INSERT INTO xavNT_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Tawamhã Zezusi hã ma tô duré tãma romnhimiré'é za'ra, rowede ĩwẽ na. Rowede ĩwasété na ma tô duré tãma romnhimiré'é za'ra, parisezu norĩ ãma. Ãne te tãma ãma romnhimiré'é za'ra, parisezu norĩ ma: — Rowede hã wẽ wamhã, te za 're 'rãi wẽ u'âsi za'ra. Rowede hã wasété wamhã, te za duré 're 'rãi wasété u'âsi za'ra. Rowede, 're ĩ'rã za'ra mono zéb zarina te za ãma waihu'u za'ra ni, rowede ĩwẽ na, duré rowede ĩwasété na hã. ");
INSERT INTO xavNT_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","A norĩ wa'wa hã te wahi ne 're anomro aba mo. Dapẽ'ẽ 're, da te 're ĩrosa'rata za'ra mono zéb zarina te za 're damreme zusi. Taha wa, aiwasété na 're aihâimana za'ra wa'aba mono wa, marĩ ĩwẽ na 're aimreme zusi waihu'u aba mono õ di. Aipẽ'ẽ 're, 're ĩrosa'rata wasété za'ra wa'aba mono zéb zarina si, te marĩ ĩwasété na si 're aimreme zusi aba mo, a norĩ wa'wa hã. ");
INSERT INTO xavNT_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Ni'wa hã 're morĩ wẽ wamhã, tipẽ'ẽ 're tinhimirosa'rata wẽ hawim na te za 're mreme wẽ u'âsi. Duré ni'wa hã 're morĩ wasété wamhã, tinhimirosa'rata wasété hawim na te za duré 're mreme wasété u'âsi. ");
INSERT INTO xavNT_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","— Tô sena, wa za aima waihu'u za'ra wa'wa. 'Re ĩhâimana u'âsi mono, za da'ãma ĩsipo'ozéb ãma hã dahâiba mono bâ te za tãma tasiwasu'u za'ra ni, rosa'rata ãna marĩ ĩwasété na te te dama 're ĩnharĩ za'ra mono zém na hã. ");
INSERT INTO xavNT_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Taha wa, ti'ab ré uburé marĩ na 're aimreme zusi aba mono zéb zarina, te za 'Re ĩhâimana u'âsi mono hã aima rowairébé za'ra wa'wa, za da'ãma ĩsipo'ozéb ãma hã. Ti'ab ré, marĩ ĩwẽ na 're aimreme zusi aba mono zéb zarina si, te za aiwẽsãmri za'ra wa'wa. Duré, marĩ ĩwasété na 're aimreme zusi aba mono zéb zarina si, te za siwi aiwẽ'õ za'ra wa'wa, 'Re ĩhâimana u'âsi mono hã. — Ãne ma tô Zezusi hã tãma waihu'u sirõmo za'ra, parisezu norĩ ma. ");
INSERT INTO xavNT_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Tawamhã parisezu norĩ hã, 'Re ĩhâimana u'âsi mono nhimiroti na rob'ui'éré na dama rowahutu'wa norĩ me, ma tô Zezusihi ma, nharĩ za'ra, ãne: — Rowahutu'wa, wa wasima wẽ za'ra ni, marĩ dama ĩ'manharĩ waihu'u'õ hã aiwaihu'u pese na wanho'a 'manharĩ da, wa te 'madâ'â za'ra da, 'Re ĩhâimana u'âsi mono zadawa para dama 're ĩ'ab'manharĩ mono na, sena na wa te ãma aiwaihu'u za'ra da. — Ãne te Zezusihi wi waptẽrẽ za'ra, ta norĩ hã. ");
INSERT INTO xavNT_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","40","Tawamhã Zezusi hã te asa tãma nharĩ za'ra, ãne: — Nimosi aipoto té wa'aba mono hã, ĩ'aihâimana wasété za'ra wa'wa. 'Re ĩhâimana u'âsi mono zô 're asimipari za'ra wa'aba mono zahã, ma tô ĩ̱wi ĩwaptẽrẽ za'ra wa'wa, marĩ dama ĩ'manharĩ waihu'u'õ hã te 'manharĩ da, asõ'a za'ra wa'aba, 'Re ĩhâimana u'âsi mono zadawa para, te dama 're ĩ'ab'manharĩ mono na sena na ĩ̱waihu'u za'ra wa'aba da. Tane nherẽ, te 'manharĩ õ di za, ãhãna. Ãne si wa za a'â aima waihu'u za'ra wa'wa. Duréihã Zona hã 'Re ĩhâimana u'âsi mono zadawa wasu'u 'rata 'wa hã si'ubdatõ ma tô bâdâ hã ãma ai'utõ, tebe ĩsa'ẽtẽ di'i 're, hâimana ré hã. Taha parimhã, ma tô 'Re ĩhâimana u'âsi mono hã sõ'reptu. Â zada'ré u ma tô ĩré 'rãiwatobro, rob u, tebe hã, Zonahã ré. Tane duré, wa hã dasiré ĩ̱podo hã si'ubdatõ bâdâ hã te za ĩ̱'ãma ai'utõ, ĩ̱dâ'â wa, ab're 're ĩ̱nomro ré hã. Taha parip si, wa za duré hâiwa'udu, apâ. Ãne wapsi, te za ĩwaihu'u za'ra wa'wa, 'Re ĩhâimana u'âsi mono hawi we ĩ̱morĩ na sena na oto ĩ̱waihu'u za'ra wa'aba da. ");
INSERT INTO xavNT_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Niwamhã 'Re ĩhâimana u'âsi mono, za da'ãma ĩsipo'ozéb ãma hã, duréihã Niniwé na 'ri nho'õmo nhisi ãma 're ĩdasi'ubumroi mono norĩ hã te za asada tihâimana za'ra wa'wa, aiwasédé hã te te ai'ãma hiri za'ra wa'aba da, 'Re ĩhâimana u'âsi mono nho'a. E marĩ wa. Duréihã Zona hã 'Re ĩhâimana u'âsi mono te te tãma 're sadawa wasu'u za'ra mono wamhã, ma tô te te 're wapari za'ra. Taha wa, ma tô ta norĩ hã tiwasété wi 're sipizari za'ra. Zonahã nhimiroti hã pire nherẽ, ĩsipai u ĩ̱nhimiroti si pire uptabi di. Tane nherẽ, a norĩ wa'wa hã ĩ̱zaze za'ra wa'aba õ di, 'Re ĩhâimana u'âsi mono nhimipisutuzéb zarina we atẽme ĩ̱morĩ aba na hã. Taha wa, te za tô ĩ'uwaibaba aiwasédé hã ai'ãma sa'ra wa'wa, Niniwé ãma 're ĩdasi'ubumroi mono norĩ hã. ");
INSERT INTO xavNT_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Niwamhã 'Re ĩhâimana u'âsi mono, za da'ãma ĩsipo'ozéb ãma hã, duréihã danhib'apito sipi'õ hã Saba na romnhisi ãma te te 're ĩda'ab'madâ'â mono hã te za duré asada tihâimana 'wa, aiwasédé hã te te ai'ãma hiri za'ra wa'aba da, 'Re ĩhâimana u'âsi mono nho'a. E marĩ wa. Ta hã duréihã romhâ uptabi nherẽ, ma tô wi, apito Saromahã u, ĩsimiroti hã te te wapari da, ĩsimiroti hã dahâimanazém na rowaihu'u na hã wẽ uptabi wa. Taha nhimiroti hã pire nherẽ, ĩsipai u ĩ̱nhimiroti si pire uptabi di. Tane nherẽ, ĩ̱nhimiroti hã aima wapari ze za'ra wa'aba õ di. Taha wa, te za tô ĩ'uwaibaba aiwasédé hã ai'ãma hiri za'ra wa'wa, danhib'apito sipi'õ hã. ");
INSERT INTO xavNT_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","44","— Ãne wa za duré aima ãma romnhimiré'é za'ra wa'wa. Ãté wa'uburé hã te za aibâ hawi 'maiwatobro. Watobro wamhã, a'ubuni wi te za 're mo, rob'ré na. Tawamhã dazô 're rĩtĩ baba mono wa, nimomo wa'utu õ wa, te za sima tinha: “Ĩ̱nhorõwa 'rata u, wa za apâ mo, ãma 're ĩ̱nhorõwa u'âsi mono da oto, ĩpẽ'ẽ 'remhã.” Ãne te za sima tinha. Tawamhã apâ te za oto mo, aibâ u, ĩpẽ'ẽ 're apâ sébré da. Tawamhã ĩhawi watobro haré, te aré hâiba baba na 're hâimana, 'ri hã baba na 're simasa mono wa, 'ri 're wa'wa su'u na 're ĩsimasa mono ne, duré 'ri paramhã robza'ra wẽ u'âsi 're ĩromnhimi'wara mono ne. Taha wa, wa'uburé ma, wẽ di, aibâ hã apâ ãma 're ĩsõrõwa mono da hã. ");
INSERT INTO xavNT_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Tawamhã tisiré norĩ zô te za mo wa'uburé hã, si'u ãma 're sõrõwa za'ra mono da. Tawamhã te za ĩtẽme ãwisi za'ra, 7 na ĩhâiba za'ra hã ĩsipai u ĩwasété uptabi za'ra hã. Tawamhã siré te za tô ãma 're sõrõwa za'ra, aibâ ãma. Aibâ ma, tãma rowẽ prã ti aré, wa'uburé misi, ãma 're sõrõwa mono ré hã, ĩpẽ'ẽ 'remhã. Ahâ na oto ĩwa 're hâimana za'ra mono wa, tãma rowẽ õ uptabi di oto. Tane duré, a norĩ wa'wa hã aima 're rowẽ prã za'ra wa'aba mono di aré. Tane nherẽ, aiwasété wi 're aipizari za'ra wa'aba mono newa, zahadu ĩ̱zazei ãna 're aihâimana wasété u'âsi za'ra wa'aba mono wa, aima 're rowẽ õ uptabi za'ra wa'aba mono di za oto. — Ãne ma tô Zezusi hã tãma waihu'u za'ra, parisezu norĩ ma, rowahutu'wa norĩ ma zama. ");
INSERT INTO xavNT_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Tawamhã Zezusi hã te te dama rowasu'u ré, ma tô ĩno norĩ hã ĩtẽme aihutu, tina me. Tawamhã rowi simasa wamhã, ma tô da'maipo're pu'u za'ra, Zezusihi ma, da te 'mairowasu'u da, ĩtẽme watobro za'ra da, rob u. ");
INSERT INTO xavNT_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Tawamhã Zezusihi ma, ma tô 'mairowasu'u ni, ãne: — Ano norĩ hã te rowi asô aimasa, ana me. Te sima aiwẽ za'ra, marĩ na te te aima rowasu'u za'ra da. ");
INSERT INTO xavNT_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Tawamhã Zezusi hã ma uburé dama waihu'u, ãne: — E 'wa hã ĩ̱na. E 'wam norĩ hã ĩ̱no norĩ. — Ãne hã ma dama waihu'u, Zezusi hã. ");
INSERT INTO xavNT_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","50","Tawamhã tinhiptõmo na ĩsiré 're ĩwanomro mono norĩ hã te te wawasu'u za'ra sina, te duré dama tinha: — Ãhãta, ĩ̱na. Ãhãta ĩ̱no norĩ. Ãhãta ĩ̱hidiba norĩ. Ni'wam norĩ hã Ĩ̱mama, hâiwa ãma 're ĩsãmra mono hã te te sima 're ĩwẽ za'ra mono zéb zarina, te te tãma ãma 're ĩ'uwaimrami za'ra mono norĩ si, ta norĩ hã ĩ̱no, duré ĩ̱hidiba, duré ĩ̱na. — Ãne ma tô Zezusi hã dama siwaihu'u, (da te waihu'u za'ra dai õ nherẽ). ");
INSERT INTO xavNT_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Tawamhã tô taha bâtâ na ma tô Zezusi hã watobro 'ri hawi, ĩsõ'ui u morĩ da. Tame ma tô nhamra, ĩsõ'u zaihâ na, te te dama rowahutu da. ");
INSERT INTO xavNT_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Tawamhã da'ahâ uptabi na ma tô ĩtẽme dasito, da te wapari za'ra da. Da'ahâ uptabi na da te dasiwi uirĩ wa, ma tô uba're wa dawi ãzé, Zezusi hã. Uba're wa, te oto nhamra. Tawamhã ĩsõ'u zaihâ na te ĩ'rata aimasam ni. ");
INSERT INTO xavNT_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Taha wa, te Zezusi hã tinhimiromnhimiré'é na dama rowahutu, ãne: — Aibâ hã te buru u mo, ti'ai hâibâdâ wa, amnho hã te te anhamra mono da, poto mono da. ");
INSERT INTO xavNT_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Tawamhã, amnho hã te te anhamra mono wamhã, nima norĩ hã bâdâdi zababa ma rere'e. Tawamhã sire hã ma te te uprosi uburé, poto mono õ ré. ");
INSERT INTO xavNT_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Ẽtẽ nhisiwi ma duré nima norĩ hã rere'e. Ti'ai baihâire di, ẽtẽ nhisiwimhã. Ti'ai baihâire wa, ma tô 'wanhipré su'u, amnho hã. ");
INSERT INTO xavNT_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Tawamhã bâdâ hã oto 'rãiwatobro wamhã, rowa'ro wa, ma ro'wanhipré hã ti'wanhipré 'ré za'ra, ĩsari hã te te rowa'réi mono õ wa. ");
INSERT INTO xavNT_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Nima norĩ hã ma duré rere'e, wab'ru wazari. Tawamhã siré ma tô 'wanhipré. Siré 'wanhipré mono wamhã, ma te te ubu, wab'ru hã. Taha wa, 'rãi mono õ di, ta norĩ hã. ");
INSERT INTO xavNT_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Ti'ai wẽ wa, ma duré nima norĩ hã rere'e. Tawamhã, oto 'wanhipré 'rãihâ mono wamhã, ma tô ti'rã za'ra. 'Rãi mono wamhã, nima niwĩmhã 'rãi ahâ prã ti, amnho hã. Duré nima niwĩmhã 'rãi ahâ di. Duré nima niwĩmhã 'rãi pese uptabi di. — Ãne na ma tô Zezusi hã dama ãma romnhimiré'é. ");
INSERT INTO xavNT_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Tawamhã ãne na ma tô duré dama ãma 'rãsutu, tinhimiroti na: — Asimipari pese za'ra wa'aba wamhã, ma'ãpé ĩ̱wapari pese za'ra wa'aba, ĩ̱nhimirowasu'u na hã waihu'u za'ra wa'aba da. — Ãne ma tô dama waihu'u, da te waihu'u za'ra da. ");
INSERT INTO xavNT_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Tawamhã wa norĩ hã ĩsiré 're ĩwanomro mono norĩ hã wa tô Zezusihi u ubumro ni. Tawamhã ãne, wa oto wasiwi sadanharĩ ni: — E marĩ wa, te romnhimiré'é na si dama 're ĩrowahutu mo. — Ãne, wa wasiwi sadanharĩ za'ra ni, wa norĩ zama, wa te waihu'u za'ra õ wa. ");
INSERT INTO xavNT_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Tawamhã Zezusi hã te asa wama nharĩ za'ra, ãne: — 'Re ĩhâimana u'âsi mono hã a norĩ wa'aba ma si, ma tô aima waihu'u za'ra wa'wa, dama ĩwaihu'u'õ hã, da'ãma 're ĩsib'a'uwẽ mono zém na hã, sõ'awi te te dama waihu'u õ nherẽ. ");
INSERT INTO xavNT_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Ni'wam norĩ hã 'Re ĩhâimana u'âsi mono nhimirowaihu hã te te 're 'ruiwapari u'âsi za'ra mono wamhã, taha zarina te za 'Re ĩhâimana u'âsi mono hã sa'ẽtẽ na tãma ãma 're sõprub za'ra, te te aré ãma 're ĩrowaihu'u za'ra mono zém nhipai u, te te waihu'u pese za'ra da oto. Tane nherẽ, ni'wam norĩ hã ĩsimirowaihu'u na te te 're 'ruiwapari za'ra mono õ wamhã, ta norĩ wi te za tinhimirowaihu hã tãma waihu'u pese za'ra õ nherẽ, te te tiwi 're awaibu 'Re ĩhâimana u'âsi mono hã, te te aré ãma 're ĩwaihu'u za'ra mono zé hã. ");
INSERT INTO xavNT_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Ĩ̱nhimiromhuri hã datõmo na da te 're 'madâ'â za'ra mono nherẽ, te taré da te 're 'madâ'â za'ra, da te ãma 're waihu'u za'ra mono ãna. Duré ĩ̱nhimiroti hã dapo're na da te 're wapari za'ra mono nherẽ, te taré da te 're wapari za'ra, da te ãma 're waihu'u za'ra mono ãna. Taha wa, wa romnhimiré'é na si te dama 're rowasu'u. ");
INSERT INTO xavNT_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Duréihã Iza'iza hã, 'Re ĩhâimana u'âsi mono zadawa wasu'u'wa hã ma tô da'ãma rob'ui'éré, za da'ãma 're ĩromhâimana mono zém na hã. Taha wa, ãhãna ma tô da'ãma uwaimra. Ãne duréihã ĩsimi'ui'éré hã, 'Re ĩhâimana u'âsi mono mreme na hã: “Ĩ̱nhimiroti hã dapo're na da te 're wapari u'âsi za'ra mono nherẽ, taré te za da te 're wapari za'ra, da te ãma 're waihu'u za'ra mono ãna. Duré ĩ̱nhimiromhuri hã datõmo na da te 're 'madâ'â u'âsi za'ra mono nherẽ, taré te za da te 're 'madâ'â za'ra, da te ãma 're waihu'u za'ra mono ãna. ");
INSERT INTO xavNT_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","E marĩ wa. Dapẽ'ẽ 're, da te 're ĩrosa'rata za'ra mono zé hã sitom haré te za ĩré 're dahâimana u'âsi za'ra, da te ĩ̱'ãma 're rosa'rata wẽ za'ra mono õ wa. Dapo're nhitom haré, te za duré 're dahâimana za'ra, ĩ̱nhimiroti hã da te 're wapari ze za'ra mono õ wa. Duré datõmo sitom haré te za 're dahâimana za'ra, ĩ̱nhimiromhuri hã dama 'madâ'â zei õ wa. Ãnei õ 'wa'âhã, te aré ĩ̱nhimiromhuri hã da te 're 'madâ'â ze za'ra, datõmo na. Te aré duré da te 're wapari ze za'ra, ĩ̱nhimiroti hã. Te aré duré da te 're ĩ̱waihu'u pese za'ra, dapẽ'ẽ 're, da te ĩ̱'ãma 're rosa'rata wẽ za'ra mono wa. Taha zarina si, te aré duré ĩ̱tẽme 're dasipizari za'ra, dawasété wi hã. Tawamhã dahâzé wa, da te 're ĩdapese za'ra mono ne, wa aré dawasédé hã te dama 're apari, te da'ãma 're ab'madâ'â tõ mono da oto.” Ãne duréihã, 'Re ĩhâimana u'âsi mono mreme na rob'ui'éré hã. ");
INSERT INTO xavNT_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","17","Tawamhã ĩsiré 're ĩwanomro mono norĩ ma, te oto nharĩ za'ra, Zezusi hã: — A norĩ wa'wa hã ĩ̱nhimiromhuri, atõmo na 're 'madâ'â za'ra wa'aba mono wamhã, ma tô ĩ̱'ãma ĩwaihu'u pese za'ra wa'wa. Duré ĩ̱nhimiroti hã aipo're na 're wapari za'ra wa'aba mono wamhã, ma tô duré ĩ̱'ãma ĩwaihu'u pese za'ra wa'wa. Taha wa, aima 're rowẽ uptabi za'ra wa'aba mono di, a norĩ wa'aba ma si. Tô sena wa ãne hã aima waihu'u za'ra wa'wa. Duréihã 'Re ĩhâimana u'âsi mono zadawa wasu'u 'rata 'wa norĩ hã duré ĩsimiroti 'madâ'â pese 'wa norĩ hã te aré te te sima 're wẽ uptabi za'ra, ĩ̱nhimiromhuri na 're ĩ̱'madâ'â za'ra wa'aba mono zé hã te te 're 'madâ'â za'ra mono da. Ma tô duré aré te te sima 're wẽ za'ra, ĩ̱nhimiroti na 're ĩ̱wapari za'ra wa'aba mono zé hã te te 're wapari za'ra mono da. Taha wa, a norĩ wa'aba ma si, aima 're rowẽ uptabi za'ra wa'aba mono di za. — Ãne hã ma tô wama waihu'u za'ra, Zezusi hã. ");
INSERT INTO xavNT_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","Tawamhã Zezusi hã ma tô duré wama waihu'u za'ra: — Ma'ãpé, ĩ̱wapari pese za'ra wa'aba. Ãhãna wa za oto aima waihu'u za'ra wa'wa, amnho potozém na te ãma ĩsimiré'ézé hã waihu'u za'ra wa'aba da. ");
INSERT INTO xavNT_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Amnho hã aibâ te te ĩ'anhamra mono hã, 'Re ĩhâimana u'âsi mono zadawa wasu'u, te wasu'u. Ni'wam norĩ hã 'Re ĩhâimana u'âsi mono, da'ãma 're ĩsib'a'uwẽ mono zé wasu'u hã, tipo're na te te 're wapari za'ra mono nherẽ, te te ãma 're rosa'rata ze za'ra mono õ wamhã, te te ãma waihu'u pese za'ra õ di za. Ta norĩ hã amnho hã bâdâdi zababa ĩrere'e mono ne, te 're hâimana za'ra. Amnho hã sire te te ĩ'uprosi mono ne, te za ĩwasété uptabi hã ĩtẽme 're simasisi za'ra, 'Re ĩhâimana u'âsi mono zadawa wasu'u hã tipo're na taré te te 're ĩwapari za'ra mono hã te te tiwi 're awaibui mono da, Wa'uburé hã. ");
INSERT INTO xavNT_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Duré ni'wam norĩ hã aiwa amnho hã ẽtẽ nhisiwi, ti'ai baihâire wa ĩrere'e mono ne, te 're hâimana za'ra. 'Re ĩhâimana u'âsi mono zadawa wasu'u hã te te 're wapari za'ra mono wamhã, amnho hã ti'ai baihâire wa ĩpoto su'u mono ne, te ta norĩ hã awa'awi te te ãma 're saze za'ra, to sina. ");
INSERT INTO xavNT_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Tane nherẽ, ĩsadawa wasu'u hã te te 're saze za'ra mono wa, da te tãma 're ĩrob'manharĩ wasété za'ra mono zéb zarina, te te 're robzépata za'ra mono wamhã, te za sazei utõrĩ za'ra. Amnho hã ti'ai baihâire wa, ĩrere'e mono hã sari õ wa, ĩ'wanhipré 'ré mono ne, te za romhutu na sazei utõrĩ za'ra, ta norĩ hã. ");
INSERT INTO xavNT_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Duré ni'wam norĩ hã aiwa amnho hã wab'ru wazari ĩrere'e mono ne, te 're hâimana za'ra. Wab'ru hã ro'wanhipré siré 'wanhipré mono wa, te te oto ubu mono wa, ĩ'rã za'ra õ ne, 'Re ĩhâimana u'âsi mono zadawa wasu'u hã tipo're na te te 're wapari za'ra mono nherẽ, ĩwẽ hã te te 're 'manharĩ za'ra mono õ di za, ta norĩ hã. Tihâimanazém na si te za sina 're hâtâ'â u'âsi za'ra. Duré danhibro pe hã wẽ uptabi newa te za taha zô si te te 're rob'ruiwapari u'âsi za'ra. Taha wa, amnho 'wanhipré hã ĩ'rã za'ra õ ne, 're nomro wẽ mono õ di za, ta norĩ hã. ");
INSERT INTO xavNT_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Duré ni'wam norĩ hã aiwa amnho hã ti'ai wẽ wa ĩrere'e mono ne, te za 're hâimana za'ra. Ta norĩ hã 'Re ĩhâimana u'âsi mono zadawa wasu'u te te 're wapari za'ra mono wamhã, te za te te sima 're wẽ uptabi za'ra, te te 're waihu'u pese za'ra mono da. Tawamhã, rowede ĩ'rãi pese uptabi ne, te za wẽ u'âsi 're hâimana za'ra, ta norĩ hã. — Ãne ma tô Zezusi hã wama waihu'u za'ra, te te da'ãma ĩromnhimiré'ézé hã. ");
INSERT INTO xavNT_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Tawamhã Zezusi hã ma tô duré wama ãma romnhimiré'é za'ra, ãne: — 'Re ĩhâimana u'âsi mono, da'ãma 're ĩsib'a'uwẽ mono zém na, wa za oto aima ãma romnhimiré'é za'ra wa'wa, ãne. Aibâ hã tiburu na ma tô amnho potozé ĩwẽ hã te te a're, amnho hã tãma 'rã da. ");
INSERT INTO xavNT_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Tawamhã nimahã na barana danhotõ mono ré, ĩsitob'ru hã ma tô ĩburu u mo. Wab'ru hã ma tô te te a're, amnho ĩwẽ wazari. Te te a're mono pari, ma tô apâ mo. ");
INSERT INTO xavNT_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Tawamhã rob're hã ma tô prédu. Taha wa, ma tô 'rã. 'Rãi mono wamhã, dama 'madâ'â pibu pese di oto, wab'ru hã ĩwazari ĩpoto mono na hã. ");
INSERT INTO xavNT_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Tawamhã buru tede'wai ma, romhuri'wa norĩ hã ma tô ĩtẽme aihutu. Ĩtẽme sihutu wamhã, ãne te tãma rowasu'u za'ra: “Apito, oro amnho hã ĩwẽ si aiburu na a're mono za, ma wab'ru hã ĩsiré 'wanhipré.” Ãne te ãma siwi sadanha, buru tede'wa hã. ");
INSERT INTO xavNT_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","— Tawamhã buru tede'wa hã te asa tãma nharĩ za'ra, ãne: “Ni'wa hã ĩ̱'ruiwapari'wa, ma tô ãne ĩ̱ma 'manha.” Tawamhã tãma ĩromhuri'wa norĩ hã te siwi sadanha, ãne: “E ãne hã aima wẽ di, wab'ru hã uburé wa te ĩsanoi mono da hã, tãma ropese da.” ");
INSERT INTO xavNT_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","— Tawamhã asa te tãma nharĩ za'ra: “Tô'ã. Rob're hã ĩ'rãi ré hã ĩsu sano za'ra wa'aba tõ da, taha wa, sano za'ra wa'aba õ di za a'â, wab'ru hã. ");
INSERT INTO xavNT_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","A'â simisutu siré prédu mono, roptehâri na da te 're ĩsãna'rata mono zéb u hã. Tawapsi wa za oto roptehâri na romhuri'wa norĩ ma 'ru za'ra, wab'ru uimrehẽne te te siwi sanoi mono da, te te duré wasisi mono da, unhama u te te siwi sãmra da, si'unhama da. Taha parip si, te za oto tehâri za'ra, amnho za'razéb u te te siwi sa'ra da, ĩ̱ma.” — Ãne na ma tô Zezusi hã ãma romnhimiré'é, 'Re ĩhâimana u'âsi mono, da'ãma 're ĩsib'a'uwẽ mono zém na hã, ãne hã sõ'awib õ nherẽ. ");
INSERT INTO xavNT_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Tawamhã romnhimiré'é na ma tô duré wama rowasu'u za'ra, Zezusi hã, ĩsiré 're ĩwanomro mono norĩ ma: — 'Re ĩhâimana u'âsi mono, da'ãma 're ĩsib'a'uwẽ mono zém na, wa za duré aima ãma simiré'é za'ra wa'wa, motada nhamare na, aibâ tiburu na te te ĩ'a're hã. ");
INSERT INTO xavNT_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Motada nhamare hã uburé romnhamare norĩ ma syryre nherẽ, oto prédu mono wamhã, uburé romnhamare, da te 're ĩzuri mono hã te za te te 're sipai pese za'ra. Papo za'ẽtẽ wamhã, ĩsu 'rowi te za si norĩ hã te te sima 're sasi za'ra. — Ãne na ma tô duré Zezusi hã wama ãma romnhimiré'é za'ra. ");
INSERT INTO xavNT_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Tawamhã Zezusi hã ma tô duré ãne na wama ãma romnhimiré'é za'ra, ĩsiré 're ĩwanomro mono norĩ ma: — 'Re ĩhâimana u'âsi mono, da'ãma 're ĩsib'a'uwẽ mono zém na, wa za duré aima ãma romnhimiré'é za'ra wa'wa, ãne. Pi'õ hã te za ĩ'u'ẽtẽ wapuzé hã syry na sa'wa, aro 'rã ne zu pese wazari, tridu 'rã zu pese wazari. Aro 'rã ne zub'a si, sa'ẽtẽ uptabi di. Tawamhã te te wazari pese wamhã, te za tidupto, ĩ'u'ẽne hã. Sa'ẽtẽ uptabi di za oto. Ãne duré, 'Re ĩhâimana u'âsi mono, da'ãma 're ĩsib'a'uwẽ mono zé hã. — Ãne na ma tô duré Zezusi hã ãma romnhimiré'é. ");
INSERT INTO xavNT_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Marĩ na te te dama ãma 're romnhimiré'é mono nherẽ, te te dama ãma 're arowasu'u mono õ di, Zezusi hã. Romnhimiré'é na si ma tô te te dama 're rowasu'u. ");
INSERT INTO xavNT_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Duréihã 'Re ĩhâimana u'âsi mono zadawa wasu'u 'rata 'wa te te ãma ĩrob'ui'érézéb zarina te te sina uwaimrami da, ma tô romnhimiré'é na si te te dama 're rowasu'u, Zezusi hã. Ãne duréihã ãma ĩrob'ui'éré siro hã: “Te dama 're rowasu'u mono wamhã, wa za te dama ãma 're aromnhimiré'é. Wa za duré te dama 're awaihu'u, ropoto na'rata hawimhã dama ĩwaihu'u'õ hã.” Ãne duréihã 'Re ĩhâimana u'âsi mono zadawa wasu'u 'rata 'wa te te ãma ĩrob'ui'éré siro hã. ");
INSERT INTO xavNT_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Tawamhã Zezusi hã ma tô dawi mo. Dawi morĩ wamhã, ma tô 'ri para u ãzé. Tawamhã ĩsiré 're ĩwanomro mono norĩ hã wa tô 'râwi ĩtẽme ubumro ni, wa te wasiwi sadanharĩ da, ãne: — Ma'ãpé wama waihu'u za'ra na. E marĩ na ma tô wab'ru na hã ãma ĩromnhimiré. E marĩ te wasu'u. ");
INSERT INTO xavNT_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Tawamhã Zezusi hã te asa wama nharĩ za'ra, ãne: — Aibâ hã tiburu na amnho ĩwẽ te te ĩ'a're mono hã, wa hã 'Re ĩhâimana u'âsi mono zadawa para dasiré ĩ̱podo hã, te ĩ̱wasu'u. ");
INSERT INTO xavNT_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Duré aibâ buru hã, daro mono bâ ti'ai wa, 're ĩdahâimana za'ra mono hã te dawasu'u. Duré amnho ĩwẽ hã uburé 'Re ĩhâimana u'âsi mono, ãma 're ĩsib'a'uwẽ za'ra mono norĩ, te wasu'u. Duré wab'ru hã Ĩwasété uptabi nhib'a'uwẽ norĩ, te wasu'u, Wa'uburé nhib'a'uwẽ norĩ hã. ");
INSERT INTO xavNT_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Duré buru tede'wa nhitob'ru hã wab'ru hã ĩburu na te te tiwi ĩ'azuri mono hã wa'uburé norĩ nhib'apito te wasu'u, tô õ hã. Duré da te 're ĩroptehâri za'ra mono zé hã rob'rãsutuzéb ãma za da'ãma ĩsipo'ozé, te wasu'u. Duré buru nho ubumroi'wa norĩ hã hâiwa ãma 'Re ĩhâimana u'âsi mono ma, romhuri'wa norĩ, te wasu'u. ");
INSERT INTO xavNT_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Wab'ru hã da te 're sano za'ra mono wa, unhama u da te 're ĩsãmra mono ne, te za dama tiromhâiba, rob'rãsutuzéb ãma hã. ");
INSERT INTO xavNT_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Wa hã dasiré ĩ̱podo hã hâiwa ãma ĩ̱ma romhuri'wa norĩ hã wa za we satõrĩ za'ra ti'ai u, marĩ ĩwasédé hã da te 're ĩ'manharĩ u'âsi za'ra mono norĩ hã te te da'ubumro za'ra da, 'Re ĩhâimana u'âsi mono nhib'a'uwẽ norĩ nhiti. Dawasédé hã da te 're 'manharĩ za'ra mono da, te te dama 're ĩroti za'ra mono norĩ zama te za ubumro za'ra, hâiwa ãma ĩ̱ma romhuri'wa norĩ hã. Wab'ru hã da te 're ĩsano za'ra mono ne, te za da'ubumro za'ra, õne haré. ");
INSERT INTO xavNT_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Taha parimhã te za unhama ro'o za'ẽtẽ u danhamra, ropipa u. Tame te za 're da'ry'ry u'âsi. Te za duré 're da'wasitete u'âsi za'ra, da te oto 're robzépata za'ẽtẽ za'ra mono wa. ");
INSERT INTO xavNT_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Tawamhã 'Re ĩhâimana u'âsi mono nhimiroti te te 're ĩ'madâ'â pese za'ra mono norĩ si, te za pire na dama 're hâimana za'ra. Bâdâ hã daro mono bâ te te dama 're rob'uiwẽ za'ra mono wa, uburé da te 're ĩ'madâ'â za'ra mono ne, te za uburé da te 're waihu'u za'ra, pire na oto dama 're ĩhâimana za'ra mono na, Wamama za oto da'ãma 're ĩsib'a'uwẽ mono zéb ãma hã. Asimipari pese za'ra wa'aba wamhã, ma'ãpé ĩ̱wapari pese za'ra wa'aba, ĩ̱nhimiroti na hã. — Ãne ma tô Zezusi hã wama rowasu'u za'ra. ");
INSERT INTO xavNT_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Tawamhã ãne te duré wama rowasu'u za'ra: — 'Re ĩhâimana u'âsi mono, da'ãma 're ĩsib'a'uwẽ mono zém na, wa za duré aima ãma romnhimiré'é za'ra wa'wa, ãne. Aibâ hã daburu na te te romhuri ré, ma tô ẽtẽ'ubuzi ĩwa'âbâ za'ẽtẽ uptabi hã 'masã, ti'ai 'rowi ni'wa hã te te aré dawi ĩsuwa hã. Te te sãmri wamhã, ma tô apâ dawi suwa tame, da te sãmri tõ da. Tawamhã toi uptabi wa, ma tô uburé tinhibro hã dama wede, buru hã tô õ hã te te dawi uipra da, ẽtẽ'ubuzi, ĩwa ĩnomro hã te te sima âri da. Ãne 'Re ĩhâimana u'âsi mono, da'ãma 're ĩsib'a'uwẽ mono zé wasu'u hã. ");
INSERT INTO xavNT_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","— Ãne duré, 'Re ĩhâimana u'âsi mono, da'ãma 're ĩsib'a'uwẽ mono zé hã. Aibâ hã ma tô sima wẽ, dasima danhipesezé hã ẽtẽwaipo ĩwa'âbâ za'ẽne hã te te dawi 'manhopẽtẽ wa, te te sima uipra da, dama ĩ'madâ'â ze hã. ");
INSERT INTO xavNT_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Tawamhã ẽtẽwaipo ĩwa'âbâ za'ẽtẽ uptabi hã te te 'masãmri wamhã, uburé tinhibro hã ma tô dama wede, ẽtẽwaipo hã te te sima uipra da. Ãne 'Re ĩhâimana u'âsi mono hã da'ãma 're ĩsib'a'uwẽ mono zé wasu'u hã. — Ãne ma tô Zezusi hã wama rowasu'u za'ra, ĩsiré 're ĩwanomro mono norĩ ma, wa te waihu'u za'ra da, sõ'awib õ nherẽ. ");
INSERT INTO xavNT_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","48","Tawamhã Zezusi hã ma tô duré ãne na wama rowasu'u za'ra, tinhimiromnhimiré'é na: — Ãne hã duré, 'Re ĩhâimana u'âsi mono, da'ãma 're ĩsib'a'uwẽ mono zé hã. Tepe mrami'wa norĩ hã ma tô abazipara hã sô siwi time, ĩsõ'ui wa. Te te siwi mei wamhã, ahâ na ma tô siwi ãma 'mai'âri za'ra, ĩpoto mono bâ, tebe hã. Tawamhã tebe hã ahâ uptabi wamhã, ma tô abazipara hã siwi tisa, â zada'ré u. Tame ma tô oto tebe hã ĩwẽ si siwi waibu, si'õtõ 're, te te 'manherẽ za'ra da. Tebe siwamnarĩ norĩ hã da te 're ĩhuri mono õ hã ma tô taré siwi sãmra. ");
INSERT INTO xavNT_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Tane te za dama tiromhâiba, rob'rãsutuzéb ãma hã. Hâiwa ãma romhuri'wa norĩ hã te za we dazô ai'aba'ré ti'ai u, dawasété na 're ĩdahâimana u'âsi mono norĩ si te te da'ubumro za'ra da, 'Re ĩhâimana u'âsi mono nhimiroti te te 're ĩ'madâ'â pese za'ra mono norĩ nhiti, te te dazani za'ra da oto. ");
INSERT INTO xavNT_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Tawamhã unhama ro'o za'ẽtẽ u te za oto danhamra, ropipa u. Tame te za 're da'ry'ry u'âsi. Te za duré 're da'wasitete u'âsi za'ra, da te 're robzépata za'ẽtẽ za'ra mono wa. — Ãne Zezusi hã te te wama ãma ĩromnhimiré'é za'ra zé wasu'u hã. ");
INSERT INTO xavNT_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Tawamhã Zezusi hã ma tô wazadanharĩ za'ra, ĩsiré 're ĩwanomro mono norĩ hã: — E ma tô asiwi ĩwaihu'u 'wa, uburé te aima ãma ĩromnhimiré'é za'ra wa'aba zé hã. Tawamhã asa wa tãma nharĩ za'ra ni: — Ĩhe. Wa tô waihu'u za'ra ni. ");
INSERT INTO xavNT_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Tawamhã ãne te duré wama rowasu'u za'ra, Zezusi hã: — Wa za duré aima ãma romnhimiré'é za'ra wa'wa, ãne. Ãté 'ri tede'wa te za marĩ ĩwẽ hã te te 're azani, 'ri 're wa'wa 're ĩromnhimi'wara mono zém hawi, te te dama 're anhomri mono da. E tawamhã marĩ ĩ'ratare si te za te te dama 're azani. Mare di. Marĩ ĩtéb zama te za duré te te dama 're azani, te te dama 're anhomri mono da. Tane duré, ni'wam norĩ hã 'Re ĩhâimana u'âsi mono nhimiroti waihu'u pese 'wa norĩ hã da'ãma 're ĩsib'a'uwẽ mono zé wasu'u te te waihu'u pese za'ra wamhã, ta norĩ hã te za ĩsimiroti ĩtéb zama te te dama 're waihu'u za'ra, ĩsimiroti 'rata me. — Ãne ma tô wama rowasu'u za'ra, Zezusi hã. ");
INSERT INTO xavNT_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","56","Tawamhã Zezusi hã marĩ nhimiré'é na te te dama arowasu'u pari, ma tô mo, aré 're ĩhâimana mono zéb u. Tamomo wisi wamhã, te oto dama rowahutu, zudezu norĩ te, rowahutuzéb ãma. Tawamhã ĩsimiroti hã da te wapari za'ra wamhã, ma tô ãma tatob'uzu za'ra ni. Te duré dasima ãma nharĩ za'ra ni, ãne: — Õ hã wede'é na romhuri'wai 'ra. Ĩna nhisi hã, Mariza na ĩsisi hã. Duré ĩno norĩ nhisi hã Ti'adu, duré Zuzé, duré Sima, duré Zudasi. Ĩhidiba norĩ hã te duré wa'rata 're hâimana za'ra. E niha ma bété õhõ si uburé marĩ hã waihu'u, tiwaihu'u pese na te te dama 're ĩrowasu'u mono zéb da hã, duré marĩ dama ĩ'manharĩ waihu'u'õ hã te te dama 're ĩ'ab'manharĩ wẽ mono zéb da hã. — Ãne ma tô ãma dasima romnhoré za'ra ni. ");
INSERT INTO xavNT_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Taha wa, ma tô dasiwi wẽ'õ ni, Zezusi hã. Taha wa, te Zezusi hã ãne dama tinha: — 'Re ĩhâimana u'âsi mono zadawa wasu'u'wa norĩ hã daro mono bâ datẽme 're nomro mono wamhã, ĩsimiroti na wazép sina, te za sô 're datob'uzu za'ra. Ĩsipti'ai ãma 're ĩhâimana za'ra mono norĩ si, sô 're datob'uzu za'ra mono õ di, ĩsipti'ai ãma wa. Ĩsisãnawã norĩ zama, ĩsõrõwa ãma 're ĩsi'ubumroi mono norĩ hã te te duré siwi 're hâiba wazé mono õ di. — Ãne hã ma tô dama waihu'u, Zezusi hã. ");
INSERT INTO xavNT_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Tawamhã ĩsimipawaptobzém na da te dasina 're umnhasi za'ra mono õ wa, marĩ dama ĩ'manharĩ waihu'u'õ hã ahâ na te te dama 'manharĩ õ di, tamemhã. ");
INSERT INTO xavNT_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Tawamhã apito Erodi hã Darireza na danhipti'a nho'õmo nhisi ãma te te 're da'madâ'â mono ré, ma tô Zezusihi wasu'u hã wapa. ");
INSERT INTO xavNT_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Ĩwasu'u hã te te wapari wamhã, ma tô te te tãma 're ĩromhuri za'ra mono norĩ ma rowasu'u, Zezusihi hâiba na: — Zuwã Batita te dama 'rui wa, da te wĩrĩ wa, apâ ĩhâiwa'udu, ta hã. Taha wa, te tiwaihu'u pese na te te dama 're ab'manharĩ, marĩ dama ĩ'manharĩ waihu'u'õ hã. ");
INSERT INTO xavNT_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","4","Ãne ma tô apito Erodi hã Zezusihi wasu'u na tãma rowasu'u za'ra. Ta hã ma tô aré tinoi mro zô rowasutu, Erodiza na pi'õ nhisi zô. Ĩno nhisi hã Piripi na ĩsisi hã. Zuwã Batita hã ma tô aré te te tãma 're roti u'âsi, ãne: “'Re ĩhâimana u'âsi mono nhimiroti 'rata na rob'ui'éré hã te te ãma roti õ di, asisãnawãi mro na aimro da hã. Tãma wẽ õ di, 'Re ĩhâimana u'âsi mono ma hã.” — Ãne ma tô te te tãma 're roti u'âsi, Erodihi ma. Tane nherẽ, ma tô apito Erodi hã tinoi mro na tiwi ãma ai'ré. Taha wa, ma tô dama ti'ru, Zuwã Batita hã da te âri da, da te pawasisi da, duré da te sẽrẽ da, dazazéb 're. ");
INSERT INTO xavNT_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Apito Erodi hã ma tô sima wẽ aré, te te dama 'ru da, Zuwã Batita da te wĩrĩ da. Tane nherẽ, pahi di zudezu norĩ ma hã, Zuwã Batita hã 'Re ĩhâimana u'âsi mono zadawa wasu'u'wa na da te waihu'u za'ra wa. ");
INSERT INTO xavNT_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Tawamhã Erodihi waptã'ãzém na ma tô dato hã dasiwi 'manharĩ ni. Tawamhã Erodizaha 'ra hã ma tô danho'a apese azarudu hã, apito Erodihi nho'a zama. Taha wa, te te 'madâ'â ze ti, apito Erodi hã. ");
INSERT INTO xavNT_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Taha zarina, ma tô azarutu ma ropisutu, ãne: — Tô sena, wa za uburé marĩ hã aima tisõ, asima ĩwẽzéb uwaibaba, ĩ̱wi ĩwaptẽrẽzéb zarina. ");
INSERT INTO xavNT_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Tawamhã ĩna hã te te tãma ĩrotizéb zarina, ma tô tiwi rowaptẽ, ãne: — Zuwã Batitaha 'rã si, wa ĩ̱sima wẽ, piza'a 'renho'a wa, ĩ̱ma hiri da, ãhãna awa'awi. ");
INSERT INTO xavNT_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Taha wa, ma tô apito Erodihi wi tirobzei'õ. Tane nherẽ, sô ĩhârâ norĩ nho'a te te azarutu ma ropisutu wa, ma tô ãma tãma uwaimra, te te tiwi ĩwaptẽrẽzéb uwaibaba. ");
INSERT INTO xavNT_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Ma tô dama ti'ru oto, dazazéb u Zuwã Batitaha zô da'maimorĩ da, da te butu nhizâri da. ");
INSERT INTO xavNT_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Da te butu nhizâri wamhã, ma tô oto siwi ti'â ĩ'rã hã, azarutu ma, piza'a 'renho'a wa. Tawamhã ma tô tina ma ti'â oto, azarudu hã. ");
INSERT INTO xavNT_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Tawamhã Zuwãhã siré 're ĩnomro mono norĩ hã ma tô sô ai'aba'ré, ĩhâiba zô, te te siwi âri da, te te siwi sẽrẽ da, ab're 're. Taha parip si, te ai'aba'ré Zezusihi u, te te tãma rowasu'u za'ra da. ");
INSERT INTO xavNT_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Tawamhã Zezusi hã Zuwãhã wasu'u te te wapari wamhã, ma tô danhiti mo uba're na siwaprosi, romnhiwasi sãmra da. Tane nherẽ, nimomo ĩsãmra na ĩwasu'u hã da te wapari za'ra wamhã, ma tô darom hawi tawairébé ni da'ahâ na, ĩsarina dasi'aba'ré da ĩsõ'rãmi, ti'ai baba. ");
INSERT INTO xavNT_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Tawamhã Zezusi hã uba're hawi watobro wamhã, da'ahâ uptabi na ma tô da'ab'madâ. Te te da'ab'madâ'â wamhã, ma tô da'ãma tipẽ'ẽzé, Zezusi hã. Taha wa, ĩhâzé ré norĩ hã tame ĩsi'ubumro norĩ hã ma tô apese. ");
INSERT INTO xavNT_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Tawamhã hâiwahâ pesere, wa norĩ hã ĩsiré 're ĩwanomro mono norĩ hã wa tô ĩtẽme ubumro ni, Zezusihi u. Ãne, wa tô tãma nharĩ za'ra ni: — Ma tô tihâiwahâ. Ãme a'ubuni wi, wa wahâimana za'ra ni, 'ri nhiti. Taha wa, ma'ãpé dama rob'ru na, 'ri wa'õtõ u dasi'aba'ré da, dasa hã da te dasima uipra za'ra da. ");
INSERT INTO xavNT_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Tawamhã Zezusi hã te asa wama nharĩ za'ra, ãne: — Mare di. Dasi'aba'réi õ di za. A norĩ wa'wa hã te za dasa hã dama ĩ'a za'ra wa'wa, dasaihuri da. ");
INSERT INTO xavNT_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Tawamhã wa duré asa tãma nharĩ za'ra ni, Zezusihi ma: — Ĩ'u'ẽtẽ wapu hã 5 na te wama tihâimana za'rare. Duré pe'a hã maparanere. Ã norĩ si, umrore di. ");
INSERT INTO xavNT_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Tawamhã Zezusi hã te oto wama 'ru za'ra: — Ma'ãpé we ĩ̱ma waibui wa'aba, ĩ'u'ẽtẽ wapu hã, duré pe'a hã. ");
INSERT INTO xavNT_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Tawamhã te oto dama tinha, duiroi wa, dasi'ubumroi mono da. Taha pari, ma tô oto ĩ'u'ẽtẽ wapu hã waibu, 5 na ĩhâiba hã. Duré pe'a hã maparane. Tawamhã hâiwa u te ĩré rob'madâ, Timama ãma wata da, sõpru wa. Taha pari, ma tô te te wẽ'ẽ, ĩ'u'ẽtẽ wapu hã. Ĩsiré 're ĩwanomro mono norĩ ma, ma tô wama sõmri za'ra, wa te dama sõmri za'ra mono da. ");
INSERT INTO xavNT_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Tawamhã aihĩni ma tô dasa hã huri ni. Ma tô da te 'mahâpãrĩ. Tawamhã Zezusihi siré 're ĩwanomro mono norĩ hã wa tô apâ si'õtõ 're, wa te sé danho'rada hã, ĩ'u'ẽtẽ wẽ'ẽ hã pe'a wẽ'ẽ zama. 12 na si'õno hã ĩré hã, danho'rata ré hã. Si'õtõ 'remhã 'masisi di. ");
INSERT INTO xavNT_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Aibâ norĩ hã 5 miu na ĩhâiba za'ra hã ĩsaihuri norĩ hã, aibâ norĩ za'rata si hã. Pi'õ norĩ hã duré ai'uté norĩ hã sa'rata õ di. ");
INSERT INTO xavNT_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Tawamhã Zezusi hã ma tô wama rob'ru za'ra, ĩsiré 're ĩwanomro mono norĩ ma, uba're wa, wanhisisi da, ĩwana zara u wa te saprĩ za'ra da ĩsõ'u na, waza'u za'ra te te dama rob'ru da, darob u apâ da te ropéi mono da. ");
INSERT INTO xavNT_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Te te dama rob'rui pari, te oto Zezusi hã mo sa'a u, siwaprosi Timama ma mreme da. Tame siwaprosi sãmra ré, ma tô ãma timara. ");
INSERT INTO xavNT_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Taha ré, ĩsiré 're ĩwanomro mono norĩ hã wa tô â wa'wa u wahâimana za'ra ni, uba're na. Tame ma tô â sisasi hã te te waré wabzuri za'ra uba're hã, rowa'u'u za'ẽne hã ĩsõ'õmoi baba te te rowapõrĩ za'ra wa. ");
INSERT INTO xavNT_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Tawamhã zahadu mara hâ ré, te Zezusi hã watẽme timorĩ za'ra, â nhisi baba. ");
INSERT INTO xavNT_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Tawamhã, wa te wasiwi 'madâ'â wamhã, wa tô tãma wapẽ'ẽwara za'ra ni, adâ watẽme morĩ za'ra newa. Ãne, wa wasima 'mahârâ za'ra ni: — Õhõta adâ'â hâiba warõ, te wei watẽme mo. — Ãne, wa wasima 'mahârâ za'ra ni. Tawamhã tãma wapahi za'ra wa, wa tô tãma wazadari za'ra ni. ");
INSERT INTO xavNT_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Tawamhã awa'awi ma tô Zezusi hã wama si'mahârâ za'ra: — Wa hã wa we atẽme ĩ̱morĩ 'wa. Ĩ̱ma aipahi za'ra wa'aba õ di za. ");
INSERT INTO xavNT_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Tawamhã Pedru te tãma tinha, ãne: — Wanhib'apito, tô sena a hã wamhã, ma'ãpé we ĩ̱zô aihârâ, â nhisi baba ãma atẽme ĩ̱morĩ da, asabzéb u. ");
INSERT INTO xavNT_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Tawamhã asa te tãma tinha, Pedruhu ma: — We aimorĩ pé, ĩ̱tẽme. Taha wa, ma tô uba're hawi watobro Pedru hã, â nhisi baba morĩ da, Zezusihi u. ");
INSERT INTO xavNT_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Tawamhã â nhisi baba ĩtẽme morĩ wa, ma tô rowa'u'u za'ẽtẽ ma tipahi, Pedru hã. Taha wa, ma tô tizadari. Ma tô aré ãzé, â 'rowi. Te sina 'mahâ, ãne: — Wanhib'apito, ma'ãpé ĩ̱nho'reptu na, ĩ̱dâ'â tõ da. ");
INSERT INTO xavNT_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Tawamhã awa'awi ma tô Zezusi hã pa'â, tinhib'rata na. Ãne te tãma tinha, Pedruhu ma: — E niha ĩ̱zaze syry di. E marĩ da, ma tô 'râwi ĩ̱'ãma asiwawã, te aipawaptobzém na hã. — Ãne ma tô tãma tinha, Zezusi hã. ");
INSERT INTO xavNT_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Tawamhã uba're 're ma tô tizasi zahuré, Zezusi norĩ hã Pedruhu me. Zasi zahuré wi, ma tô rowa'u hã tiwa'u'utu. ");
INSERT INTO xavNT_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Tawamhã ĩsiré 're ĩwanomro mono norĩ hã wa tô ãma wawata za'ra ni, Zezusihi ãma. Ãne wa ãma wawata za'ra ni: — Wanhib'apito, a hã tô sena 'Re ĩhâimana u'âsi mono 'ra, te 're aimo. — Ãne wa ãma wawata za'ra ni. ");
INSERT INTO xavNT_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Tawamhã wa norĩ hã wa tô saprĩ za'ra ni, Zezusihi me, ĩsõ'u na. Wa te saprĩ za'ra wamhã, wa tô aihutu ni, Zenezaré na danhipti'a nho'õmo nhisi u. ");
INSERT INTO xavNT_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Tamemhã ma tô dasiwi waihu'u ni, Zezusi hã. Taha wa, ma tô Zezusihi wasu'u na ãma dasima da te ropé, 'ri wa'õtõ mono bâ, ti'ai 're dasi'rata 're ĩdahâimana za'ra mono norĩ hã. Tawamhã da'ahâ na ma tô ĩhâzé ré norĩ hã ĩtẽme 'wasari ni. ");
INSERT INTO xavNT_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Tawamhã ma tô ĩhâzé ré norĩ hã tiwi waptẽrẽ za'ra, ĩ'uza nhisutu si te te tiwi upi za'ra da. Tawamhã ĩ'uza nhisutu si te te nasi upi za'ra nherẽ, ma tô tizéptâ'â za'ra, uburé ĩhâzé ré norĩ hã, awa'awi. ");
INSERT INTO xavNT_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Tawamhã parisezu norĩ hã, duré 'Re ĩhâimana u'âsi mono nhimiroti na rob'ui'éré na dama rowahutu'wa norĩ hã ma tô ai'aba'ré Zeruzarẽ hawi, Zezusi hã te te siwi ãma sadanharĩ da, zudezu norĩ hi'rata nhimiroti na. Ãne te siwi sadanha, ãma: ");
INSERT INTO xavNT_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","— E niha asiré 're ĩnomro mono norĩ hã te te 'madâ'â za'ra õ di, duréi wahi'rata norĩ nhimiroti hã. Ta norĩ hã 're saihuri mono õ ré, 're simisõi pese za'ra mono õ di. Ãne wa, te ta norĩ hã wahâimanazé hã te te ãma wawi 're upa za'ra. ");
INSERT INTO xavNT_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Tawamhã asa te Zezusi hã tãma nharĩ za'ra: — E niha bâ bété, a norĩ wa'wa hã 'Re ĩhâimana u'âsi mono nhimiroti hã 're 'madâ'â za'ra wa'aba mono õ di, te bété asimiroti na si 'râwi 're asi'madâ'â za'ra wa'aba mo. ");
INSERT INTO xavNT_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Duréihã 'Re ĩhâimana u'âsi mono hã ma tô ãne dama roti: “Aimama norĩ hã te za 're ĩwazéb za'ra wa'aba mo, ana zama.” Ãne ĩsimiroti amo hã duré: “Ni'wam norĩ hã timama nherẽ, duré tina nherẽ, te te ãma 're wasété za'ra mono wamhã, te za da te 're simro.” Ãne ĩsimiroti hã duréihã. ");
INSERT INTO xavNT_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","6","Tane nherẽ, te aimawi dama 're ĩroti za'ra wa'aba mo, ãne: “Ãté ni'wa hã te za sima rosa'rata, marĩ hã timama norĩ ma, te te sõmri da, te te ãma pawaptob zahuré da. Tane nherẽ, te za tipẽ'ẽ na sima tinha: ‘Ã hã 'Re ĩhâimana u'âsi mono te hã.’ Ãne wamhã, timama norĩ ma, te te sõmri zahuré õ di za, te te ãma pawaptob zahuré da.” Ãne te dama 're ĩroti wasété za'ra wa'aba mo. 'Râwi asimiroti na si 're anomro aba mono da, ma tô 'Re ĩhâimana u'âsi mono nhimiroti hã asiwi 're ĩwẽ'õ za'ra wa'aba mo. ");
INSERT INTO xavNT_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","A norĩ wa'wa hã aihâimana si'ahâ za'ra wa'aba di. Duréihã Iza'iza hã ma tô ĩ'uwaibaba ai'ãma rob'ui'éré sirõmo za'ra wa'wa, za 're ĩ'aihâimana za'ra wa'aba mono zém na hã. 'Re ĩhâimana u'âsi mono mreme na ma tô ãne na ai'ãma rob'ui'éré sirõmo za'ra wa'wa: ");
INSERT INTO xavNT_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","“Õ norĩ hã tô sena newa, te timreme na si taré ĩ̱'ãma 're wata za'ra. Tane nherẽ, te tipẽ'ẽ 're aimawi zô si te te 're rosa'rata u'âsi za'ra, ĩ̱'upana. ");
INSERT INTO xavNT_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Danhimiroti zarina si, te ta norĩ hã te te dama 're rowahutu za'ra, ĩ̱nhimiroti zarina newa. Taha wa, senai õ di, ta norĩ hã ĩ̱'ãma 're ĩwata za'ra mono zé hã.” Ãne ma tô ai'ãma waihu'u sirõmo za'ra wa'wa, 'Re ĩhâimana u'âsi mono zadawa wasu'u'wa hã, duréihã. — Ãne ma tô Zezusi hã tãma rowasu'u za'ra, parisezu norĩ ma. ");
INSERT INTO xavNT_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Tawamhã Zezusi hã ma tô sima dazô hâ, ĩsimirowasu'u hã da te wapari za'ra da. Ãne te dama tinha: — Ma'ãpé, ĩ̱wapari pese za'ra wa'aba za, marĩ hã waihu'u za'ra wa'aba da, ãma. ");
INSERT INTO xavNT_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Uburé marĩ na 're dasaihuri mono wamhã, dapẽ'ẽ 're, 're sisisi mono wamhã, taha na 're dasiwasété za'ra mono õ di za 'râwi. Dapẽ'ẽ hawim na danhimirosa'rata wasété zarina, da te dasima 're nharĩ wasété za'ra mono wapsi, te za 're dasiwasété za'ra, 'râwi. — Ãne ma tô Zezusi hã dama waihu'u. ");
INSERT INTO xavNT_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Tawamhã wa norĩ hã ĩsiré 're ĩwanomro mono norĩ hã wa tô ĩtẽme ubumro ni, Zezusihi u, wa te wasiwi ãma sadanharĩ za'ra da, ãne: — E ma tô asina ĩwaihu'u za'ra. Parisezu norĩ hã ma tô aimreme hã siwi wẽ'õ pese za'ra. ");
INSERT INTO xavNT_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Tawamhã Zezusi hã te asa wama ãma romnhimiré'é za'ra, parisezu norĩ ãma: — Ĩ̱mama hã hâiwa ãma 're ĩsãmra mono hã rob're te te ĩ'a're'õ hã taha si te za uburé te te 're aza'o'o. ");
INSERT INTO xavNT_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Parisezu norĩ ãma 're aihâtâ'â za'ra wa'aba mono õ di za. Si'uihâ na 're hâimana za'ra mono. Ni'wa hã te za tisiré hã saprõ, ĩtob'a zahuré hã. Te te saprõni wamhã, te za ab're 're siré tiwaptã'ã zahuré. Tane te parisezu norĩ hã tob'a ne te te 're danhimro. — Ãne ma tô Zezusi hã wama ãma romnhimiré'é za'ra, ĩsiré 're ĩwanomro mono norĩ ma. ");
INSERT INTO xavNT_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Tawamhã Pedru te ãma 'mahâ, Zezusi hã: — Ma'ãpé ãma wama rowasu'u za'ra na, taha na ãma ĩromnhimiré'é na hã wa te waihu'u za'ra da. ");
INSERT INTO xavNT_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Tawamhã Zezusi te asa wama nharĩ za'ra: — E niha a norĩ wa'aba zama, waihu'u za'ra wa'aba õ di bété. ");
INSERT INTO xavNT_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Dasa hã da te 're huri mono wamhã, taré te za dadub 're, 're sisisi. Taha pari, te za duré apâ 're wairébé, dahâiba hawi. ");
INSERT INTO xavNT_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Tazahã, dapẽ'ẽ hawi da te 're ĩsani za'ra mono na si, te za 'râwi 're dasiwasété za'ra. ");
INSERT INTO xavNT_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Dapẽ'ẽ 're, danhimirosa'rata wasété hawim na si, te za dawasédé hã uburé da te 're 'manharĩ za'ra, dasipãrĩ hã, duré dasina danhimisaihuri hã, duré marĩ na danhimisaihuri hã, duré dazadawa nhipe hã, duré da te da'ãma 're ĩwasété za'ra mono hã. ");
INSERT INTO xavNT_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Ãne uburé dapẽ'ẽ 're, da te 're rosa'rata wasété za'ra mono wapsi, te za dawasédé hã da te 're 'manharĩ za'ra. Tane nherẽ, danhimisõi ãna 're dasaihuri mono wamhã, ãma 're dasiwasété waihu'u za'ra mono õ di za. Mare di. — Ãne ma tô Zezusi hã wama waihu'u za'ra. ");
INSERT INTO xavNT_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Tawamhã Zezusi hã ma tô mo Zenezaré hawi, Tiru na 'ri nho'õmo nhisi niwĩ, Sido na 'ri nho'õmo nhisi niwĩb zama. ");
INSERT INTO xavNT_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Tame sãmra ré, ma tô pi'õ zudezu'õ hã ĩtẽme wi, Cana'ã norĩ siré hã, ta niwĩ 're ĩsãmra mono hã. Ĩtẽme wisi wamhã, ma tô 'mahâ, ãne: — Apito, Dawihi nhihudu, ma'ãpé ĩ̱'ãma aipẽ'ẽzé na. Ĩ̱'ra sipi'õ, wa'uburé ré 're hâimana u'âsi mono wa, te te 're robzépata za'ẽtẽ u'âsi. ");
INSERT INTO xavNT_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Tawamhã ãne na pi'õ te te 'mahârâ nherẽ, te te sada'âbâ õ di asa, Zezusi hã. Tawamhã wa norĩ hã ĩsiré 're ĩwanomro mono norĩ hã wa tô ĩtẽme ai'ré za'ra ni, Zezusihi u. Ãne, wa tô tãma 'ru za'ra ni: — Ma'ãpé pi'õ satõrĩ apâ, wa hawi morĩ da. Wazarina te we 're mo. Te duré we te te wa'ab'mahârâ, mreme 'rãihâ na. ");
INSERT INTO xavNT_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Tawamhã Zezusi te wama nharĩ za'ra, asa: — Pone'ẽrebâ 're ĩsimani za'ra mono norĩ zô si, ma tô we Ĩ̱mama hã ĩ̱zatõ, Izarazéhé nhihudu norĩ zô si. ");
INSERT INTO xavNT_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Tawamhã ãne na Zezusi hã te te rowasu'u wamhã, ma tô pi'õ ĩtẽme mo. Ma tô hi'rãtitõ ĩpapara aime. Tawamhã te tãma tinha, ãne: — Apito, ma'ãpé ĩ̱'ãma aime na. ");
INSERT INTO xavNT_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Tawamhã Zezusi te tãma tinha: — E 're dasaihuri mono ré, te za dasa hã da'ra wi, da te 're waibu, wapsã ma, da te 're sa'wari za'ra mono da. Mare di. Ãne hã ĩ'uwaibaba õ di. — Ãne te Zezusi hã pi'õi ma ãma romnhimiré'é, zudezu'õ norĩ ãma hã, sõ'awib õ nherẽ. ");
INSERT INTO xavNT_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Tawamhã pi'õ hã te duré asa tãma tinha, ãne: — Apito, tô ĩbâ ma tane hã ĩ̱ma ĩwaihu. Tane nherẽ, wapsã hã wedeza zahâpâ ĩtede'wa sai'a'a hã te za te te 're huri, ĩsahâpâ 're ĩrere'e mono hã. ");
INSERT INTO xavNT_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Tawamhã pi'õi mreme te te wapari wamhã, te tãma tinha, Zezusi hã: — Pi'õ, wa tô aiwaihu'u, aima ĩ̱'umnhasi za'ẽtẽ na, ĩ̱wi ĩwaptẽrẽzéb zarina te aima ĩ'manharĩ da hã. Taha wa, wa za aima ãma uwaimra, tô. — Ãne ma tô Zezusi hã tãma waihu'u, pi'õi ma. Tawamhã ãne te te tãma nharĩ wi, ma tô wa'uburé hã ĩ'ra sipi'õi hawi watobro. Taha wa, ma tô tipese oto. ");
INSERT INTO xavNT_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Tawamhã ta hawi te oto mo Zezusi hã, Darireza na ĩsõ'u zapoto nhisi u. Ta hawi te duré sa'a u mo, sa'a nhisiwi sãmra da. ");
INSERT INTO xavNT_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Tame sãmra ré, ma tô da'ahâ uptabi na ĩtẽme aihutu ni. Ĩhâzé ré norĩ hã ma tô ĩtẽme da te simro, ĩmorĩ'õ norĩ hã, duré ĩtob'a norĩ hã, duré ĩ'rãtẽire norĩ hã, duré ĩmreme'õ norĩ hã. Uburé siwa'ru ma tô ĩhâzé ré norĩ ãma dasito, ĩpapara da te sõré da. Tawamhã uburé ma tô da'apese, Zezusi hã. ");
INSERT INTO xavNT_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Tawamhã ĩmreme'õ norĩ hã ma tô mreme wairé. Duré ĩ'rãtẽire norĩ hã ma tô timorĩ wẽ za'ra. Ĩmorĩ'õ norĩ hã para na te oto 're nomro. Ĩtob'a norĩ hã te duré rob'madâ'â za'ra oto. Tawamhã ãne hã da te 'madâ'â za'ra wamhã, ma tô ãma tatob'uzu za'ra ni. 'Re ĩhâimana u'âsi mono ãma, ma tô duré ãma tawata za'ra ni, Izarazéhé nhihudu norĩ nhib'apito ãma. ");
INSERT INTO xavNT_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Tawamhã Zezusi hã ma tô ĩsiré 're ĩwanomro mono norĩ zô sima wazô tihârâ za'ra. Tawamhã te wama nharĩ za'ra, ãne: — Ãhãna ĩ̱'rata dasi'ubumroi ré, ma tô dasa hã dawi ai'utõ, bâdâ si'ubdatõ da'ãma si'utõrĩ wa. Taha wa, da'ãma ĩ̱pẽ'ẽzé di, wa hã. Dasai õ nherẽ, te dama rob'rui waihu'u õ di, apâ da te ropéi mono da hã. Danhib'uware wa, bâdâdi wa, dawi robra za'ra õ'umnhasite, te dama rob'rui waihu'u õ di. ");
INSERT INTO xavNT_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Tawamhã wa norĩ hã ĩsiré 're ĩwanomro mono norĩ hã wa tô wasiwi sadanharĩ ni, Zezusi hã: — E niha wa za ĩ'u'ẽtẽ wapu hã 'masãmri za'ra ni, a'ubuni wi wasi'ubumro nherẽ, dahâiba mono bâ wa te dama ĩ'a za'ra da hã. Da'ahâ uptabi di. ");
INSERT INTO xavNT_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Tawamhã te asa wazadanharĩ za'ra, Zezusi hã: — E niha te ĩ'u'ẽtẽ wapu hã aima tihâimana za'ra wa'wa. Tawamhã ãne te asa tãma wasu'u za'ra: — 7 na te wama tihâimana za'ra. Duré pe'a hã umrore na te tihâiba. — Ãne, wa asa tãma wasu'u za'ra ni. ");
INSERT INTO xavNT_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Tawamhã Zezusi te dama rob'ru, ti'ai wa dasi'ubumroi mono da. ");
INSERT INTO xavNT_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Taha pari, ma tô duré 7 na ĩ'u'ẽtẽ wapu hã waibu, pe'a zama, 'Re ĩhâimana u'âsi mono ãma wata da, sõpru wa. Ãma wata pari, ma tô te te wẽ'ẽ, ĩ'u'ẽtẽ wapu hã, pe'a zama. Ĩsiré 're ĩwanomro mono norĩ ma, ma tô wama sõmri za'ra, wa te dama sõmri za'ra mono da. ");
INSERT INTO xavNT_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Tawamhã uburé ma tô tasaihuri ni. Ma da te 'mahâpãrĩ. Tawamhã ĩsiré 're ĩwanomro mono norĩ hã wa tô danho'rada hã apâ wa te ubumro za'ra, 7 na si'õno hã ĩsi'atarẽme ré hã. ");
INSERT INTO xavNT_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Aibâ norĩ hã tisa te te ĩhuri norĩ hã 4 miu na ĩhâiba za'ra hã. Pi'õ norĩ hã duré ai'uté norĩ hã sa'rata õ di. ");
INSERT INTO xavNT_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Tawamhã Zezusi hã te oto dama rob'ru, apâ dasi'aba'ré da, darob u. Taha pari, ma tô uba're 're ãzé, Madadã na danhipti'a nho'õmo nhisi u te te saprĩ da. ");
INSERT INTO xavNT_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Tawamhã parisezu norĩ hã duré sadusezu norĩ hã ma tô Zezusihi u ai'aba'ré, te te tãma 'ru za'ra da, marĩ dama ĩ'manharĩ waihu'u'õ hã te te 'manharĩ da, ĩsõ'a za'ra, 'Re ĩhâimana u'âsi mono zadawa para di pâ, marĩ hã tô sena te te 'manharĩ zô. Ãne ma tô tãma 'ru za'ra, te te siwi pibu da, Zezusi hã. ");
INSERT INTO xavNT_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Tawamhã Zezusi hã te asa tãma nharĩ za'ra: — Bâdâ ĩsébrézéb u hâiwa pré wamhã, te za ãne asima 're ĩrowasu'u za'ra wa'aba mo: “Awẽmhã hâiwa wẽ di za oto.” ");
INSERT INTO xavNT_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Duré nimahã na bâdâ 'rãi watobrozéb u, hâiwa nhirõtõ si simi'wara wamhã, ĩwatobrozéb ãma si bâdâ te te hâiwa nhirõtõ pré wamhã, te za duré ãne asima 're ĩrowasu'u za'ra wa'aba mo: “Ãhãna hã tã te za we tita'a.” Ãne hã hâiwa u 're asimizawẽrẽ za'ra wa'aba mono wamhã, aima waihu'u pese za'ra wa'aba di, tã 're ĩta'a mono zéb da hã duré 're ĩhâiwa pese mono zéb da hã. Tane nherẽ, ãhãna uburé 're ĩromhâimana mono zé hã 'madâ'â za'ra wa'aba nherẽ, za 're ĩromhâimana mono zéb da hã waihu'u za'ra wa'aba õ di. ");
INSERT INTO xavNT_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Nimosi aipoto té wa'aba mono hã ĩ'aihâimana wasété za'ra wa'wa. 'Re ĩhâimana u'âsi mono zô, 're asimipari za'ra wa'aba mono zahã, te ĩ̱ma ĩ'ru za'ra wa'wa, marĩ dama ĩ'manharĩ waihu'u'õ hã te aima 'manharĩ za'ra wa'aba da. Tane nherẽ, te 'manharĩ õ di za. Duréihã Zonahã ma ĩromhâimanazém na si te za ãma aipo're pu'u za'ra wa'wa, 'Re ĩhâimana u'âsi mono, marĩ dama ĩ'manharĩ waihu'u'õ hã te te tãma ĩ'manharĩzém na. — Ãne ma tô Zezusi hã tãma waihu'u za'ra, parisezu norĩ ma, duré sadusezu norĩ ma zama. Tawamhã Zezusi hã te oto tiwi timorĩ za'ra, nimomo morĩ da. ");
INSERT INTO xavNT_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Tawamhã wa norĩ hã wa tô saprĩ za'ra ni, Zezusihi me, ĩsõ'u na. Wa te saprĩ za'ra wamhã, wa tô ĩ'u'ẽtẽ wapu na po're ha'âri za'ra ni. Taha wa, wa wa'ubana ai'aba'ré ni. ");
INSERT INTO xavNT_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Tawamhã Zezusi hã ma tô wama nharĩ za'ra, ĩsiré 're ĩwanomro mono norĩ ma: — Ma'ãpé 're asi'madâ'â pese za'ra wa'aba mono, ĩ'u'ẽtẽ wapuzém nhiti 're anomro aba mono da, parisezu norĩ nhimi'manharĩzém nhiti, sadusezu norĩ me. — Ãne ma tô wama ãma romnhimiré'é za'ra, sõ'awib õ nherẽ. ");
INSERT INTO xavNT_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Tawamhã wa norĩ hã wa wasima nharĩ za'ra ni, ãne: — Ãté õ hã ĩ'u'ẽtẽ wapu hã wa te wei wasiré 'mai'âri õ wa, ma tô ãne wama nharĩ za'ra. ");
INSERT INTO xavNT_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Tawamhã Zezusi hã wanhimirosa'rata za'ra hã te te sina waihu'u wa, te wama nharĩ za'ra, ãne: — E niha te ĩ'u'ẽtẽ wapu hã aima ĩhâimana za'ra wa'aba õ na, sô asimrami za'ra wa'wa. E asiwi ĩ̱'umnhasi za'ra wa'aba ãna. ");
INSERT INTO xavNT_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","E zahadu bété asiwi ĩ̱zadaihu'u za'ra wa'aba ã bâ. E ma tô ãma aipo're si'âri za'ra wa'wa, 5 miu na aibâ norĩ ma, ĩ'u'ẽtẽ wapu hã 5 na te ĩwẽ'ẽi mono zém na hã. E niha si'õno hã ĩ'masisi za'ra wa'wa hã, ĩ'u'ẽtẽ wapu wẽ'ẽi ré hã. E ma tô duré ãma aipo're si'âri za'ra wa'wa. ");
INSERT INTO xavNT_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Duré 4 miu na aibâ norĩ ma, ĩ'u'ẽtẽ wapu hã 7 na te wẽ'ẽi mono wamhã, e niha si'õno hã ĩ'masisi aba mono hã. E ma tô duré ãma aipo're si'âri za'ra wa'wa. ");
INSERT INTO xavNT_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","E niha bâ waihu'u za'ra wa'aba õ di bété, ĩ'u'ẽtẽ wapu 'manharĩzém na te ĩnharĩ uptabi õ zém na hã. Ma'ãpé 're asi'madâ'â pese za'ra wa'aba mono, ĩ'u'ẽtẽ wapuzém nhiti 're anomro aba mono da, parisezu norĩ nhimi'manharĩzém nhiti, sadusezu norĩ me. ");
INSERT INTO xavNT_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Tawamhã ĩsiré 're ĩwanomro mono norĩ hã wa tô wasina waihu'u za'ra ni, Zezusihi mreme hã, ĩ'u'ẽtẽ wapu 'manharĩzém na te te wama ĩnharĩ uptabi õ na hã, parisezu norĩ nhimiroti wasété na te te ãma ĩsimiré'ézém na si, sadusezu norĩ me. ");
INSERT INTO xavNT_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Tawamhã Zezusi hã te oto mo darob amoi u, apito Piripihi te, Sézareza na 'ri nho'õmo nhisi niwĩ. Tame ma tô wazadanharĩ za'ra, ĩsiré 're ĩwanomro mono norĩ hã: — E niha ma tô dasima ĩ̱wasu'u za'ra ni, dasiré ĩ̱podo hã ti'ai ãma. E 'wa hã, wa hã wa 're mo. ");
INSERT INTO xavNT_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Tawamhã ãne wa asa tãma nharĩ za'ra ni: — Aiwasu'u hã, ahâ di. A hã, u, Zuwã Batita, apâ aihâiwa'udu. Duré a hã, u, Eriasi apâ we ĩ'aimorĩ. Duré a hã, u, Zeremiasi. Duré a hã, u, duréihã 'Re ĩhâimana u'âsi mono zadawa wasu'u 'rata 'wa ĩhâiba amo, apâ aihâiwa'udu. ");
INSERT INTO xavNT_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Tawamhã Zezusi hã te duré wazadanharĩ za'ra: — A norĩ wa'wa hã bété, e niha ma tô asima 're ĩ̱wasu'u za'ra wa'aba mo. ");
INSERT INTO xavNT_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Tawamhã Sima Pedru te asa tãma tinha: — A hã Cristu, 'Re ĩhâimana u'âsi mono te te aipisudu, Danho'reptui'wa da. A hã 'Re ĩhâimana u'âsi mono 'ra. ");
INSERT INTO xavNT_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Tawamhã Zezusi, te Pedru oto 'mahâ: — Sima, Zuwãhã 'ra, aima 're rowẽ mono di. Ma tô ãma ĩ'uwaimra. A hã danhimirowasu'u hawi, ãne na ĩ̱waihu'u õ di. Ĩ̱mama, hâiwa ãma 're ĩsãmra mono si ma tô ãne na aima ĩ̱waihu'u. — Ãne ma tô Zezusi hã wẽsã Pedru hã, te te ĩwaihu'uzém na. ");
INSERT INTO xavNT_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Tawamhã te duré tãma ãma romnhimiré'é: — Pedru, ãne wa za aima waihu'u. Ẽtẽ na, wa ai'ãma simiré'é. Ni'wa hã ẽtẽ nhisiwi te za 'ri na'rada hã 'manha, 'ri hã siptete na 're sa mono da, tãma. Tane hã 'Re ĩhâimana u'âsi mono te te ĩ̱pisutu na, ma tô ĩ̱waihu'u na'ra. Taha wa, ni'wa hã ẽtẽ nhisiwi te te ĩ'ri ne, te za oto ĩ̱waihu'u na'rata zém hawim na ĩ̱waihu'u za'ra ni, za da te 're ĩ̱zaze za'ra mono norĩ hã. 'Re ĩdadâ'â za'ra mono zé hã dama siptete nherẽ, pire nherẽ, ĩ̱zazei'wa norĩ ãma te te ai'uté waihu'u za'ra õ di za. ");
INSERT INTO xavNT_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Danhib'apito, 'ri za'ẽtẽ 're, 're ĩsãmra mono hã te za 'ridawazé hã tãma ĩromhuri'wai ma tisõ, te te dama ãma 're 'ridawa mono wa, ãma 're danhisisi mono da. Tane, wa za aima tisõ 'ridawazé hã, 'Re ĩhâimana u'âsi mono, da'ãma 're ĩsib'a'uwẽ mono zéb u, dama 're a'ridawa mono da, ãma 're danhisisi mono da. Uburé marĩ hã da te 're 'manharĩ tõ za'ra mono da, dawi 're ĩ'azawi mono hã te za 'Re ĩhâimana u'âsi mono hã te te ãma 're asaze, hâiwa ãma. Duré uburé marĩ hã dawi 're ĩ'azawi mono õ hã te za duré te te ãma 're ai'uzei pese. — Ãne ma tô Zezusi hã tãma waihu'u, Pedruhu ma. ");
INSERT INTO xavNT_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Taha wa, Zezusi hã ma tô sina wazadawa uwati za'ra, ĩsiré 're ĩwanomro mono norĩ hã, wa te dama wasu'u tõ za'ra da a'â, Danho'reptui'wa na 'Re ĩhâimana u'âsi mono te te ĩpisutu na hã. ");
INSERT INTO xavNT_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Tawamhã ta hawim haré te oto tidâ'âzém na wama 're siwasu'u u'âsi sõ'awi Zezusi hã, tihâiwa'utuzém na zama. Ãne ma tô wama 're siwasu'u za'ra, ĩsiré 're ĩwanomro mono norĩ ma: — Ĩ̱mama te te ĩ̱ma ĩpisutuzéb zarina wa za mo, Zeruzarẽ u. Tamemhã zudezu norĩ ma roti'wa norĩ hã, duré 'Re ĩhâimana u'âsi mono ma da'ãma romhuri'wa ĩpire norĩ hã, duré ĩsimiroti na rob'ui'éré 'rata na dama rowahutu'wa norĩ hã te za ĩ̱ma rob'manharĩ wasété za'ra. Taha zarina, wa za robzépata za'ẽtẽ. Te za duré dasiwi ĩ̱wĩrĩ ni. Tawamhã bâdâ maparane ĩ̱'ãma si'utõrĩ õ ré, wa za hâiwa'udu apâ. ");
INSERT INTO xavNT_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Tawamhã Pedru ma tô Zezusi hã sima saprõ tisiré norĩ nhiti, romnhiwasi, tãma ĩsiwasu'u za'ra zé hã te te tiwi sawi da. Ãne te tãma tinha: — Wanhib'apito, ãne hã ai'ãma ĩromhâimana da hã mare di za. 'Re ĩhâimana u'âsi mono hã te te aima ba'a da si, wa ĩ̱sima wẽ, da te aima rob'manharĩ tõ da. ");
INSERT INTO xavNT_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Tawamhã Zezusi hã ma tô aipi'ra, Pedruhu u. Ãne te tãma tinha: — Satanasi, mo oto aimorĩ, ĩ̱nhiti. Marĩ hã bâdâdi wa, 're ĩsimi'wara mono, te te 're ĩda'marõpãrĩ za'ra mono ne, te ĩ̱wasutu mo, Ĩ̱mama te te ĩ̱ma ĩpisutuzéb zarina te ĩ̱sina dama uwaimrami tõ da. 'Re ĩhâimana u'âsi mono nhimirosa'rata nei õ di, asimirosa'rada hã. Ti'ai ãma danhimirosa'rata zarina si te ĩ̱'ãma ĩrosa'ra, a hã. ");
INSERT INTO xavNT_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Tawamhã Zezusi te duré wama nharĩ za'ra, ĩsiré 're ĩwanomro mono norĩ ma: — Ni'wam norĩ hã ĩ̱siré 're nomro u'âsi mono da, te te sima 're ĩ̱wẽ za'ra mono wamhã, tihâimanazém na te te 're rosa'rata za'ra mono õ di za. Tiza'ozéb ré, ĩ̱zarina 're ĩnomro mono ne, te za ĩ̱siré 're nomro, da te 're simroi mono da nherẽ. ");
INSERT INTO xavNT_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Ni'wam norĩ hã tihâimanazé te te sima 're sawi za'ra mono wamhã, rowẽ ĩsi'utõrĩ'õ hã te te sina 're uwaimrami za'ra mono õ di za. Ni'wam norĩ hã ĩ̱zarina 're nomro mono da, tihâimanazé te te sima 're sawi za'ra mono õ wapsi, tawapsi te za te te sina 're uwaimrami za'ra, rowẽ hã. ");
INSERT INTO xavNT_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Ãté ni'wa hã te za tinhibro hã te te sima 're a'ubumroi pese, sibrob ahâ uptabi da. Tawamhã te za oto dârâ. Ti'ab ré, sibrob ahâ nherẽ, e tãma 're rowẽ mono di za, rowẽ ĩsi'utõrĩ'õ hã te te sina uwaimrami õ wamhã. Mare di. Tãma 're rowẽ mono õ di za. Ti'ai ãma, simarĩ ahâ uptabi nherẽ, tãma waihu'u õ di za, marĩ na ĩsiwa'âbâzéb da hã, rowẽ ãma 're ĩhâimana mono zéb da hã. ");
INSERT INTO xavNT_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Wa hã ti'ai ãma dasiré ĩ̱podo, niwapsi wa za wei mo apâ, Ĩ̱mama zadawa para, hâiwa ãma tãma ĩromhuri'wa norĩ siré. Tamep si uburé marĩ hã da te 're ĩ'manharĩ za'ra mono zéb zarina, wa za dama rowairébé, ĩwẽ norĩ ma, duré ĩwasété norĩ ma zama. ");
INSERT INTO xavNT_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Tô sena wa aima rowasu'u za'ra wa'wa. A norĩ wa'wa hã aihĩni õ nherẽ, ai'matâ'â aba õ ré, te za ĩ̱'madâ'â za'ra wa'wa ti'ai ãma dasiré ĩ̱podo hã, uburé Danhib'apito uptabi na apâ we ĩ̱morĩ wamhã. — Ãne ma tô wama siwasu'u za'ra, Zezusi hã. ");
INSERT INTO xavNT_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Tawamhã bâdâ 6 na ãma si'utõrĩ pari, ma tô Zezusi hã Pedru norĩ si te te simro, Ti'adu norĩ zama ĩnoi me, Zuwãhã me. Ẽtẽ 'rãihâ u, ma tô te te simro. ");
INSERT INTO xavNT_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Tame si'ubumroi ré, ma tô Zezusi hã aimawi tihâiba na saprĩ, Pedru norĩ nho'a. Ma tô ti'uburã pese, bâtâ ro'o ne. Duré ĩ'uza hã rã uptabi di, rowa'a za'ẽtẽ ne. ");
INSERT INTO xavNT_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Tawamhã Pedru norĩ hã ma tô 'madâ'â za'ra, Mozési norĩ hã, Eriasihi me. Zezusihi me, te sima rowasu'u za'ra. ");
INSERT INTO xavNT_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Tawamhã Pedru te Zezusihi ma tinha, ãne: — Wanhib'apito, ãme wama rowẽ za'ra di. Aima wẽ wamhã, uridi hã si'ubdatõ te aima 'manharĩ za'ra wa'aba da, wa tô rosa'rata, ate da hã, duré Mozésihi te da hã, duré Eriasihi te da hã. ");
INSERT INTO xavNT_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Tawamhã ãne Pedru te te tãma nharĩ ré, ma tô hâiwa nhirõtõ'a za'ẽne hã we hâiba zuwa za'ra, Zezusi norĩ hã. Tawamhã hâiwa nhirõtõ'a hawi, ma tô 'Re ĩhâimana u'âsi mono hã mre: — Ã hã ĩ̱'ra, te 're ĩsawi pese mono. Tãma 're ĩ̱to za'ẽtẽ mono di. Ma'ãpé ĩsimiroti hã 're wapari pese za'ra wa'aba mono za. ");
INSERT INTO xavNT_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Tawamhã Pedru norĩ hã Zezusihi siré ĩsi'aba'ré norĩ hã, 'Re ĩhâimana u'âsi mono mreme te te wapari za'ra wamhã, ma tô tãma tipahi za'ra. Tãma pahi za'ra wa, ma tô ti'ai wa rere, dumana na. Ti'ubu na ma tô roptob za'ra. ");
INSERT INTO xavNT_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Tawamhã Zezusi hã ma tô ĩtẽme ai'ré za'ra. Simi'wara ré, ma tô upi za'ra, tinhib'rata na. Te te upi za'ra wamhã, te tãma nharĩ za'ra: — Ma'ãpé aiwahutu za'ra wa'aba. Aipahi za'ra wa'aba tõ. ");
INSERT INTO xavNT_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Tawamhã ma tô ti'rãiwahutu za'ra oto, te te rob'madâ'â za'ra da. Te te rob'madâ'â za'ra wamhã, Zezusihi si ma tô 'madâ'â za'ra. ");
INSERT INTO xavNT_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Tawamhã ẽtẽ 'rãihâ hawi, ma tô si'ra za'ra, Zezusi norĩ hã. Si'aba'réi ré, ma tô Zezusi hã Pedru norĩ hã sadawa uwati za'ra, ãne: — Ẽtẽ 'rãihâ ãma ĩ'madâ'â za'ra wa'wa hã dama wasu'u za'ra wa'aba õ di za a'â. Wa hã ti'ai ãma dasiré ĩ̱podo hã ab're hawi, Ĩ̱mama te te ĩ̱hâiwa'utu parip si, te za dama 're ĩrowasu'u za'ra wa'aba mo. ");
INSERT INTO xavNT_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Tawamhã Pedru norĩ hã te oto ãma siwi sadanha, ãne: — E marĩ wa, te dama rowahutu'wa norĩ hã te te dama 're roti za'ra, Cristu, Danho'reptui'wa da, 'Re ĩhâimana u'âsi mono te te ĩpisutu wana, Eriasi za we ĩmorĩ na hã. ");
INSERT INTO xavNT_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Tawamhã Zezusi hã te asa tãma nharĩ za'ra: — Duréihã 'Re ĩhâimana u'âsi mono zadawa wasu'u'wa hã ma tô ĩ'uwaibaba ãma rob'ui'éré, Eriasi za we apâ ĩmorĩzém na te te ropese da. ");
INSERT INTO xavNT_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Tane nherẽ, wa za aima waihu'u za'ra wa'wa. Eriasi hã ma tô wei morĩ pa. Tane nherẽ, õ hã da te dasiwi waihu'u õ wa, ma tô tãma rob'manharĩ wasété za'ra ni, da te dasima ĩwẽ za'ra zéb zarina. Tane te za duré da te ĩ̱ma 're rob'manharĩ wasété za'ra, ti'ai ãma dasiré ĩ̱poto ma hã. ");
INSERT INTO xavNT_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Tawamhã Pedru norĩ hã ma tô waihu'u za'ra, Zezusi te te tãma ĩrowasu'u za'ra zé hã, Eriasihi upana Zuwã Batita te te ĩwasu'u na hã. ");
INSERT INTO xavNT_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Tawamhã wa norĩ hã wa tô apâ ai'aba'ré ni, Zezusihi me, da'ahâ uptabi na sô ĩdahâimana za'ra u. Tawamhã aibâ hã ma tô Zezusihi u wi. Wisi wamhã, ma tô ĩpapara nhamra, hi'rãtitõ. ");
INSERT INTO xavNT_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","Tawamhã te tãma tinha, Zezusihi ma: — Apito, ma'ãpé ĩ̱'ra ãma aipẽ'ẽzé na. Te 're sitete u'âsi. 'Re sitete u'âsi mono wa, te unhama u 're waptã'ã, âi ba zama. ");
INSERT INTO xavNT_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Asiré 're ĩnomro mono norĩ u, wa tô aré saprõ. Tane nherẽ, te te siwi pese waihu'u õ di, ta norĩ hã. ");
INSERT INTO xavNT_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Tawamhã Zezusi ma tô tinha, ãne: — E niha bété ai'rata 're ĩ̱nhamra u'âsi za'ra wa'aba mono nherẽ, asina 're ĩ̱'umnhasi za'ra wa'aba mono õ di, te 're ĩ'aipawaptob za'ra wa'aba mono zéb da hã. Nimosi aipoto té wa'aba mono hã ĩ'aihâimana wasété za'ra wa'wa. E ĩ̱pẽ'ẽzé u'âsi, wa za ai'rata 're ĩ̱morĩ u'âsi 'wa, 're ĩ̱'umnhasi za'ra wa'aba mono õ wa. Ma'ãpé we ĩ̱tẽme saprõni aba, ai'repudu hã. ");
INSERT INTO xavNT_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Tawamhã wa'uburé ma, ma tô rob'ru Zezusi hã, ai'repudu te te 're ĩpibui u'âsi mono nhiti, morĩ da. Te te tãma rob'rui wi, ma tô awa'awi watobro, ai'reputu hawi. Tawamhã awa'awi ma tãma tirowẽ, ai'reputu ma hã. ");
INSERT INTO xavNT_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Tawamhã wa norĩ hã ĩsiré 're ĩwanomro mono norĩ hã, wa tô wahâiba pisutu ĩtẽme ai'ré za'ra ni Zezusihi u, romnhiwasi wa te wasiwi sadanharĩ da. Ãne, wa tô wasiwi sadanharĩ ni: — E niha bâ bété wa norĩ hã, wa'uburé ma, wa te rob'ru za'ra nherẽ, wa te wasiwi ĩmei waihu'u õ, tãma. ");
INSERT INTO xavNT_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","21","Tawamhã Zezusi hã te asa wama nharĩ za'ra: — 'Re ĩhâimana u'âsi mono hã syry na 're umnhasi za'ra wa'aba mono wa, tãma mei waihu'u za'ra wa'aba õ di. Tô sena, wa aima waihu'u za'ra wa'wa. Motada nhamare hã syryre nherẽ, da te 're wamhã, oto poto wamhã, wede za'ẽtẽ uptabi di. Tane, a norĩ wa'wa hã syryre na 'Re ĩhâimana u'âsi mono 're umnhasi za'ra wa'aba mono wamhã, syryre na nherẽ, uburé marĩ hã te aré 're ĩ'manharĩ za'ra wa'aba mo, asi'uihâ na aima waihu'u za'ra wa'aba õ nherẽ. Ã ẽtẽ 'rãihâ ma, te aré ĩnharĩ za'ra wa'wa, si'uihâ na si'ré da, ĩsabzém nhiti. Tawamhã te aré tô ai'ré. — Ãne ma tô Zezusi hã wama waihu'u za'ra, ĩsiré 're ĩwanomro mono norĩ ma. ");
INSERT INTO xavNT_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Tawamhã wa norĩ hã Zezusihi siré wa tô asimro ni, Darireza na danhipti'a nho'õmo nhisi ãma. Wasiré wasi'ubumroi wamhã, ma tô Zezusi hã wama siwasu'u za'ra, ãne: — Wa hã dasiré ĩ̱podo hã te za dasima ĩ̱hâiba nhomri za'ra ni. ");
INSERT INTO xavNT_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Te za ĩ̱wĩrĩ ni duré, dasiwi. Tane nherẽ, bâdâ maparane ĩ̱'ãma si'utõrĩ õ ré, te za Ĩ̱mama hã apâ ĩ̱hâiwa'utu. Tawamhã, wa te wapari za'ra wamhã, ma tô wawi tirobzei'õ pese za'ra, ĩsiré 're ĩwanomro mono norĩ wi. ");
INSERT INTO xavNT_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Tawamhã wa norĩ hã Zezusihi siré 're ĩwanomro mono norĩ hã wa tô ai'aba'ré ni, Capana'u na 'ri nho'õmo nhisi u. Wasihutu wamhã, rob'uiprazé ubumroi'wa norĩ hã ma tô Pedru siwi sadanha, 'Re ĩhâimana u'âsi mono ãma 're ĩdawata za'ra mono zé ma, rob'uiprazé ubumroi'wa norĩ hã. Ãne ma tô siwi sadanha: — E asib'apito za'ra wa'wa hã rowahutuzé 'madâ'âzéb da, te te dame 're wa'âbâ mono õ di. ");
INSERT INTO xavNT_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","— Ĩhe. Te te 're wa'âbâ. — Ãne ma tô sada'â, Pedru hã. Tawamhã Pedru ma tô ãzé 'ri para u, Zezusihi zarina, te te ãma sadanharĩ da. Sébré wamhã, ma tô Zezusi hã timreme na sõzâ, Pedru hã: — Sima, e niha ma asimirosa'rada ĩwaihu. Daro mono bâ danhib'apito norĩ ma, e 'wam norĩ hã te rob'uiprazé hã te te tãma 're po'o za'ra. E ĩsib'a'uwẽ norĩ hã, e darob zô te te da'ãma 're ĩ'ai'uté za'ra mono norĩ si te za te te tãma 're po'o za'ra. — Ãne te sadanha, Zezusi hã. ");
INSERT INTO xavNT_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Tawamhã Pedru te asa tãma tinha: — Darob zô te te da'ãma 're ĩ'ai'uté za'ra mono norĩ si, te za te te 're wa'âbâ za'ra. Tawamhã Zezusi hã te duré tãma tinha, ãne: — Tane tô. Daro mono bâ danhib'apito nhib'a'uwẽ norĩ, tinhib'apito ma, te te 're ĩwa'âbâ za'ra mono da hã mare di. (Tane, wa hã Ĩ̱mama nhib'a'uwẽ wa, rowahutuzé 'madâ'âzéb da, te dame 're wa'âbâ mono õ nherẽ, te ãma dame 're upai mono õ di za.) ");
INSERT INTO xavNT_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Tane nherẽ, wawasédé, da te wa'ãma 're sa'ra mono õ'umnhasite, wa za wa'âbâ za'ra ni, ãhãna hã. Ma'ãpé ai'maimorĩ aba ĩsõ'ui u, tepe zô 'maimei wa'aba da. Tawamhã ĩmorĩ'rada 'mai'âri aba wamhã, te za ĩ'masari waré wa'wa, rob u. Tawamhã ĩsadai'ré 're, te za ĩ'manhopẽtẽ 'wa, rob'uiprazé ĩsapotore hã. Ta hã ĩwabre za, rowahutuzé 'madâ'âzéb da hã te ĩwa'âbâzéb da hã, duré ãma ĩwa'âbâ za'ra wa'aba zéb da hã. Taha wa, rob'uiprazé ĩsapotore hã 'mai'âri aba wamhã, te za asiwi ĩ'mai'âri 'wa, rowahutuzé ma, rob'uiprazé ubumroi'wa norĩ u, ãma wa'âbâ za'ra wa'aba da. — Ãne te tinha, Zezusi hã. ");
INSERT INTO xavNT_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Tawamhã wa norĩ hã Zezusihi siré 're ĩwanomro mono norĩ hã wa tô ĩtẽme ubumro ni, wa te wasiwi sadanharĩ da, ãne: — E 'wa hã 'Re ĩhâimana u'âsi mono nhib'a'uwẽ, siré 're ĩhâimana za'ra mono norĩ hã danhipai u dama ĩpire. ");
INSERT INTO xavNT_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Tawamhã Zezusi hã ma tô ai'uté hã 'mahâ, ĩsiré 're ĩwanomro mono norĩ wa'wa, te te sãrĩ da. ");
INSERT INTO xavNT_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","Tawamhã te wama nharĩ za'ra oto: — Tô sena, wa aima waihu'u za'ra wa'wa. Aihâimanazém na saprĩ za'ra wa'aba õ wamhã, 'Re ĩhâimana u'âsi mono hã ai'ãma 're sib'a'uwẽ za'ra wa'aba mono õ di za. Dama ĩwapu na ai'uté hâimanazém ne 're aihâimana za'ra wa'aba mono wapsi, te za ai'ãma 're sib'a'uwẽ za'ra wa'wa. ");
INSERT INTO xavNT_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Ni'wam norĩ hã ã ai'uté ne tipire na 'râwi 're si'madâ'â za'ra mono õ wapsi, te za pire na 're hâimana u'âsi za'ra, 'Re ĩhâimana u'âsi mono, da'ãma 're ĩsib'a'uwẽ mono zéb ãma hã. ");
INSERT INTO xavNT_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Duré ni'wam norĩ hã te te 're ĩ̱zawi pese za'ra mono wa, ai'uté zô 're tob'uzu za'ra mono wamhã, ta norĩ u'âbâ te duré ĩ̱zô 're tob'uzu za'ra. — Ãne ma tô wama waihu'u za'ra, ĩsiré 're ĩwanomro mono norĩ ma. ");
INSERT INTO xavNT_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Tawamhã Zezusi hã te duré wama rowasu'u za'ra, ãne: — Ãhãta ai'uté norĩ te asimro. Ãté ni'wa hã te za tinhimiroti wasété na ãma ropé, ai'uté norĩ ãma, te te sina 're ĩ̱'umnhasi za'ra mono norĩ ãma. Tawamhã ĩsimiroti wasété hawi, ai'uté te te ĩ̱'mairẽme wamhã, tãma ropipa uptabi di za, tãma ĩroti wasété 'wai ma hã, 'Re ĩhâimana u'âsi mono, za te te azâri wa. Ĩbutu na ẽtẽ tõmo wawẽ, da te ãma wasisi pari, dâ'â da, âi ba da te mei 'wa'âhã, tãma ropipa di aré. Tane nherẽ, ĩsimiroti wasété zarina ai'uté te te ĩ̱rẽme wamhã, tãma ropipa uptabi di za, roti wasété'wai ma hã. ");
INSERT INTO xavNT_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Danhimiroti wasété hawi 're dasi'marõpãrĩ u'âsi za'ra mono wa, taha wa, dama 're ropipa uptabi za'ra mono di za, daro mono bâ. Te za tô da te 're ĩ̱rẽme za'ra. Tane nherẽ, tinhimiroti wasété hawi te te 're ĩda'marõpãrĩ za'ra mono norĩ ma si, danhipai u tãma 're ropipa uptabi za'ra mono di za. ");
INSERT INTO xavNT_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","— Asib'rata na aiwasédé hã 're waibui wa'aba mono wamhã, duré aipara na aiwasédé hã 're waibui wa'aba mono wamhã, te za asiwi 're ĩsihâri za'ra wa'aba mo, 're sãmra aba mono da. Asib'rada asiwi 're sihâri za'ra wa'aba mono newa, duré aipara hã asiwi 're sihâri za'ra wa'aba mono newa, te za oto misire ré si newa, hâiwa u 're anomro aba mo, 're asimroi u'âsi aba mono da oto, tame. Tawapsi aima 're rowẽ uptabi za'ra wa'aba mono di za. Tane nherẽ, asib'rata zahuré ré, duré aipara zahuré ré, unhama u'âsi u 'Re ĩhâimana u'âsi mono te te 're asãmra aba mono wamhã, aima 're ropipa uptabi za'ra wa'aba mono di za. ");
INSERT INTO xavNT_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Duré atõmo na marĩ 're 'madâ'â za'ra wa'aba mono wa, aiwasété na 're asi'marõpãrĩ za'ra wa'aba mono wamhã, ato hã te za asiwi 're ĩsani za'ra wa'aba mo, 're sãmra aba mono da. Tawamhã ato hã asiwi 're sani za'ra wa'aba mono newa, te za atõmo misire ré si newa, 're asisisi aba mo, hâiwa u, 're ai'ubumroi u'âsi aba mono da, tame. Tawapsi aima 're rowẽ uptabi za'ra wa'aba mono di za. Tane nherẽ, atõmo zahuré ré ropipa u unhama u'âsi u, 'Re ĩhâimana u'âsi mono te te 're asãmra aba mono wamhã, aima 're ropipa uptabi za'ra wa'aba mono di za. — Ãne ma tô Zezusi hã ĩsiré 're ĩwanomro mono norĩ ma, wama waihu'u sirõmo za'ra. ");
INSERT INTO xavNT_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","11","Tawamhã Zezusi hã te duré wama rowasu'u za'ra, ĩsiré 're ĩwanomro mono norĩ ma: — Ãhãta ai'uté norĩ hã te asimro. Ãma 're rosa'rata wasété za'ra wa'aba mono tõ, dama ĩwapu newa. Tô sena, wa aima rowasu'u za'ra wa'wa. Hâiwa ãma 'Re ĩhâimana u'âsi mono ma romhuri'wa norĩ hã te ai'uté mono bâ te te 're 'madâ'â pese za'ra, misi si, tite mono bâ. Ta norĩ hã te Ĩ̱mama nho'a te te 're 'madâ'â pese za'ra, hâiwa ãma 're ĩsãmra mono nho'a. ");
INSERT INTO xavNT_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","— Wa za oto aima ãma romnhimiré'é za'ra wa'wa. Aibâ hã pone'ẽrebâ 100 na ĩsimizama hâiba hã misi tiwi 'masimani wamhã, e sô rĩtĩ mono õ di za. Te za tô sô 're rĩtĩ. Pone'ẽrebâire hã te za a'â rẽme za'ra 99 na ĩhâiba hã. Ĩsa'u rom na tisa te te 're huri mono ré, te za sô rĩtĩ, tiwi ĩsimani zô. ");
INSERT INTO xavNT_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Tawamhã te te sãmri wẽ te, te za 're to, pone'ẽrebâ tede'wa hã. Pone'ẽrebâ hã ĩsimani'õ norĩ hã rowẽ u'âsi tãma 're hâimana za'ra mono wa, tãma 're ĩrowẽ mono zém nhipai u, te za 're to za'ẽtẽ. ");
INSERT INTO xavNT_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Tane, ã ai'uté norĩ hã Aimama aba wi, 're ĩsimani za'ra mono da hã sô 're simipari mono õ di, tãma wẽ õ wa. — Ãne ma tô Zezusi hã pone'ẽrebâire ĩsimanizém na simiré'é. ");
INSERT INTO xavNT_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","Ãne te duré rowasu'u, Zezusi hã: — Asisãnawã, asiré ĩsazei'wa nherẽ, asada 're wasété za'ra wa'aba mono wamhã, te za ĩtẽme 're anomro aba mo, asada 're ĩwasété za'ra wa'aba mono zém na tãma 're asiwasu'u za'ra wa'aba mono da, aihâiba pisutu. Tawamhã tãma 're asiwaihu'u za'ra wa'aba mono zé hã te te 're wapari za'ra mono wamhã, te za apâ asina 're asisãnawã za'ra wa'aba mo. ");
INSERT INTO xavNT_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Tane nherẽ, te te 're aiwapari za'ra wa'aba mono õ wamhã, te za oto asiré ĩsazei'wa hã misi, niwamhã maparane asiré 're ĩsimroi wa'aba mo, asada 're ĩwasété za'ra wa'aba mono u, oto ĩsõ'a zahuré tãma 're asiwaihu'u za'ra wa'aba mono da, ta norĩ nho'a. Duréihã 'Re ĩhâimana u'âsi mono nhimiroti na rob'ui'éré hã ãma 're uwaimrami za'ra wa'aba mono da, te za ãne 're ĩ'manharĩ za'ra wa'aba mo, asima. Ãne ĩsimiroti na rob'ui'éré hã: “Ni'wam norĩ hã sada 're dawasété za'ra mono wamhã, dahâiba maparane nho'a te za dama 're siwaihu'u za'ra, ĩwapari'wa norĩ hã danho'a te te ãma 're mreme waptob za'ra mono da.” Ãne duréihã 'Re ĩhâimana u'âsi mono nhimiroti na rob'ui'éré, ĩbaihâ na hã. ");
INSERT INTO xavNT_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Tawamhã asiré ĩsazei'wa norĩ nho'a tãma 're roti za'ra wa'aba mono nherẽ, te te 're aiwapari za'ra wa'aba mono õ wamhã, te za oto uburé asiré ĩsazei'wa norĩ ma 're ĩrowasu'u za'ra wa'aba mo, asada 're ĩwasété za'ra wa'aba mono zém na. Tawamhã uburé asiré ĩsazei'wa norĩ hã te te 're wapari za'ra mono õ wamhã, ĩsazei'õ'wa hâimanazém ne, te za oto ãma 're ĩrosa'rata za'ra wa'aba mo, tiwasété na 're siwaihu'u za'ra mono õ wa oto. — Ãne ma tô Zezusi hã wama waihu'u za'ra, ĩsiré 're ĩwanomro mono norĩ ma. ");
INSERT INTO xavNT_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Tawamhã te duré wama rowasu'u za'ra Zezusi hã, ĩsiré 're ĩwanomro mono norĩ ma: — Tô sena wa aima waihu'u za'ra wa'wa. Uburé marĩ hã da te 're 'manharĩ tõ za'ra mono da, dawi 're ĩsawi za'ra wa'aba mono hã te za 'Re ĩhâimana u'âsi mono hã te te ãma 're asaze za'ra wa'wa, hâiwa ãma. Duré uburé marĩ hã dawi 're ĩsawi za'ra wa'aba mono õ hã, te za duré te te ãma 're ai'uzei pese za'ra wa'wa. ");
INSERT INTO xavNT_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","— Ãne wa za duré aima waihu'u za'ra wa'wa, tô sena. Ni'wam norĩ hã maparane nherẽ, marĩ na ti'ai ãma 're asisaze za'ra wa'aba mono wamhã, Ĩ̱mama wi 're ĩrowaptẽrẽ za'ra wa'aba mono zéb uwaibaba, te za te te aima ãma 're a'uwaimrami 'wa, hâiwa ãma 're ĩsãmra mono hã. ");
INSERT INTO xavNT_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Ni'wam norĩ hã maparane, ãté si'ubdatõ nherẽ, ĩ̱zadawa para 're mreme zusi mono da, siré 're si'ubumroi mono wamhã, wa hã wa za tame duré ĩsiré 're ĩ̱hâimana za'ra. — Ãne ma tô wama rowasu'u za'ra, Zezusi hã. ");
INSERT INTO xavNT_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Tawamhã Pedru hã ma tô Zezusihi u ai'ré, te te sadanharĩ da. Ãne te sadanha: — Wanhib'apito, wasiré ĩsazei'wa nherẽ, ĩ̱zada 're ĩwasété u'âsi mono zé hã e mame ĩsa'ratazém nhitõ ãma wa za ĩ̱sina 'madâ'â zazâ, ĩwasédé te ĩ̱sina ĩ'madâ'â'õzém na hã za. E 7 ãma. ");
INSERT INTO xavNT_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Tawamhã Zezusi te asa tãma tinha: — Mare di. 7 ãma asina 'madâ'â zazâri õ di za. Ãté 77 ãma si te za asina ĩ'madâ'â zazâ, ĩwasédé hã asina ĩ'madâ'â'õzém na hã. ");
INSERT INTO xavNT_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Ãne, wa za oto aima ãma romnhimiré'é za'ra wa'wa, 'Re ĩhâimana u'âsi mono, da'ãma 're ĩsib'a'uwẽ mono zém na hã. Tawamhã ti'ai ãma danhib'apito hã ma tô rosa'rata, tite rob'uiprazé te te sa'rata da, ĩsapari tãma rob'madâ'â'wa norĩ hã rob'uiprazé te te tiwi 're ĩwaptẽrẽ za'ra mono hã wahuré ĩsõwa're're te te tãma 're sõmri za'ra mono zô. ");
INSERT INTO xavNT_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Tawamhã te te ãma sãna'rata wi, ma tô ĩtẽme saprõni ni aibâ hã, ĩsapari rob'madâ'â'wa hã. Ta hã ma tô rob'uiprazé hã tinhib'apito wi te te 're awaptẽrẽ, sa'ẽtẽ uptabi na. Sa'ẽtẽ uptabi wa, niwa ĩsõwa're're te te tãma ĩsõmri da hã waihu'u õ di. ");
INSERT INTO xavNT_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Tawamhã te te tãma sõmri waihu'u õ wa, ma tô ĩsib'apito hã dama ti'ru, da te wede da, da te uipra da, ĩmro zama, ĩ'ra norĩ zama, pawa'âbâ ãna te te dama 're romhuri za'ra mono da oto. Uburé ĩsibro hã da te dama wede za'ra da, ma tô dama ti'ru duré, rob'uiprazé te te tiwi 're ĩ'awaptẽrẽ mono hã te te ãma wa'âbâ da. ");
INSERT INTO xavNT_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Tawamhã õ hã tô tãma rob'madâ'â'wa hã aré, ma tô hi'rãtitõ tãma aime ĩpapara, tinhib'apito ma. Tawamhã te tiwi waptẽ, ãne: “Apito, a'â ĩ̱zapari ze na asimi'ẽ na. Zahadu uburé wa za aima wa'â, wa hã.” Ãne ma tô tãma siwaihu'u, aibâ hã. ");
INSERT INTO xavNT_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","— Tawamhã ĩsib'apito hã ma tô ãma aiwamri, ĩmreme na. Taha wa, ma tô tãma sisisi apâ, õne haré nomro da, te te tãma sõmri tõ da. Õne haré ma duré satõ oto, apâ morĩ da. ");
INSERT INTO xavNT_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Tawamhã õ hã aibâ hã te oto mo. Morĩ wamhã, ma tô tisiré romhuri'wa hã sõpẽtẽ. Taha wi, ma tô duréihã rob'uiprazé misi bâtâ na dapawa'âbâzé hã waptẽ syry na, apito hawi ĩmorĩ wi. Tawamhã ĩsõwa're're te te tãma sõmri õ wa, ma tô ti'â, ĩbutu na awa'awi. Ĩbutu na te te tété sina, ma tô tiwi waptẽ, ãne: “Ma'ãpé ãhãna ĩ̱ma sõmri, zahadu ĩ̱ma ĩwa'âbâ õ hã.” Ãne te tiwi waptẽ. ");
INSERT INTO xavNT_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","— Tawamhã ĩsiré romhuri'wa ma tô hi'rãtitõ nhamra ĩpapara, te te tiwi rowaptẽrẽ da, ãne: “Ma'ãpé, ĩ̱zapari ze na a'â syry na. Wa za tô aima tisõ uburé, ĩsõwa're're.” ");
INSERT INTO xavNT_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","— Tawamhã ãne te te tiwi waptẽrẽ nherẽ, te te ãma sazei õ di. Te te ãma sazei õ wa, ma tô dama ti'ru, da te sẽrẽ da, dazazéb 're. Rob'uiprazé hã te te tãma sõmri wapsi, te za dama ti'ru, apâ da te wazere da, dazazém hawi. ");
INSERT INTO xavNT_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Tawamhã ĩsiré rob'madâ'â'wa norĩ hã ma tô ĩwasu'u hã wapari za'ra, te te dama ĩ'ru na hã da te sẽrẽ da, dazazéb 're. Te te wapari za'ra wamhã, ma tô sada tihâimana za'ra. Ma tô duré ai'aba'ré, tinhib'apito ma, te te siwi wasu'u da. ");
INSERT INTO xavNT_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Tawamhã te te tãma wasu'u za'ra parimhã, ma tô ĩsib'apito hã sô hâ, dazazéb 're danherẽ'wa zô. Sô hârâ wamhã, ãne te tãma tinha: “A hã romhuri wasété 'wa, ĩ̱wi ĩwaptẽrẽzéb zarina wa tô po're ha'â, rob'uiprazé ĩ̱wi 're ĩ'awaptẽrẽ mono zém na hã apâ ĩ̱ma sõmri õ nherẽ. Te 'ruiwapari õ di. ");
INSERT INTO xavNT_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","E niha bâ bété, ãma aipẽ'ẽzé õ di asiré romhuri'wai ãma hã, wa hã ai'ãma ĩ̱pẽ'ẽzé ne.” Ãne te tãma tinha ĩsib'apito hã, tãma rob'madâ'â'wai ma. ");
INSERT INTO xavNT_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","— Tawamhã ĩsib'apito hã ma tô ab'rui pese. Sib'rui wa, ma tô dama ti'ru, dazazéb 're da te sẽrẽ da, da te tãma 're ĩrob'manharĩ u'âsi za'ra mono zém na, tame te te 're robzépata mono da. Rob'uiprazé te te tiwi 're ĩ'awaptẽrẽ mono nhowa're're tinhib'apito ma, te te tãma sõmri wapsi, te za wazere ni apâ. — Ãne ma tô Zezusi hã wama ãma romnhimiré'é za'ra, ĩsiré 're ĩwanomro mono norĩ ma. ");
INSERT INTO xavNT_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Tawamhã ãne ma tô timreme hã wama 'rãsutu za'ra, Zezusi hã: — Ãne hã asiré ĩsazei'wa hã asada 're ĩwasété za'ra wa'aba mono zém na sena na asina 're 'madâ'â zahâri za'ra wa'aba mono õ wamhã, te za Ĩ̱mama hã te te aima 're rob'manharĩ wasété za'ra wa'wa aihâiba mono bâ wa'aba, hâiwa ãma 're ĩsãmra mono hã. ");
INSERT INTO xavNT_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Tawamhã ãne na Zezusi te te rowasu'u parimhã, ma tô Darireza hawi mo, Zudeza na danhipti'a nho'õmo nhisi u morĩ da, Zodã pa zara u. ");
INSERT INTO xavNT_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Da'ahâ uptabi na te ĩsarina ai'aba'ré ni. Tawamhã Zudeza u wisi wamhã, ma tô ĩhâzé ré norĩ hã apese, tame. ");
INSERT INTO xavNT_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Tawamhã parisezu norĩ hã ni'wam norĩ hã ma tô ĩtẽme aihutu Zezusihi u, te te siwi sadawa pibu da, timreme na te te upai wa, te te siwi mreme wẽ'õ da. Ãne ma tô siwi sadanha: — E aibâ hã te za timro hã marĩ ĩpire hã te te tiwi 're 'manharĩ za'ra mono õ nherẽ, te te 're rẽme za'ra. E wahi'rata norĩ nhimiroti zarina, ãne hã. ");
INSERT INTO xavNT_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Tawamhã Zezusi hã te asa tãma nharĩ za'ra: — E ĩbaihâ na ãne hã 're sõré za'ra wa'aba mono ã bâ, 'Re ĩhâimana u'âsi mono nhimiroti 'rata na rob'ui'éré hã. Ãne rob'ui'éré hã: “Ropoto na'rata hawimhã ma tô 'Re ĩhâimana u'âsi mono hã a'uwẽ hã aibâ na 'manha. Pi'õ zama ma tô duré 'manha.” Ãne duréihã ĩbaihâ na rob'ui'éré hã. ");
INSERT INTO xavNT_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Ãne ma tô duré roti 'Re ĩhâimana u'âsi mono hã, ĩbaihâ na hã: “Taha wa, aibâ hã 're mro za'ra mono wamhã, te za timama norĩ hã te te 're rẽme za'ra, timro me si siré 're simasisi zahuré mono da oto. Sina 're hâiba sitob zahuré mono wa, maparane ĩhâiba nherẽ, misi ĩhâiba ne, te za siré 're simasisi u'âsi zahuré oto.” — Ãne 'Re ĩhâimana u'âsi mono nhimiroti 'rata na rob'ui'éré hã. ");
INSERT INTO xavNT_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Ãne wa, dasina 're damro za'ra mono wamhã, dahâiba maparane nherẽ, te za oto dahâiba misi ne dasiré 're dasi'ubumro. Taha wa, 'Re ĩhâimana u'âsi mono, dasi'ãma te te 're da'ahâiba to mono nherẽ, ni'wa hã da'ãma 're siwanhizari mono õ di za. Mare di. — Ãne ma tô Zezusi hã parisezu norĩ ma waihu'u za'ra. ");
INSERT INTO xavNT_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Tawamhã parisezu norĩ hã ma tô duré siwi sadanha, Zezusi hã: — Oro zapre te Mozési hã te te wama 're roti za'ra, aibâ hã timro te te 're rẽme za'ra mono da wamhã, timro te te 're ĩrẽme za'ra mono zém na rob'ui'éré te te tãma 're sõmri za'ra mono da, te te duré ĩré 're satõrĩ za'ra mono da, ĩsiti oto sina 're pahâ za'ra mono da. — Ãne te siwi sadanha. ");
INSERT INTO xavNT_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Tawamhã Zezusi hã te asa tãma nharĩ za'ra, ãne: — Ta hã Mozési hã aipẽ'ẽ tete za'ra wa'aba wa, ma tô ãne na te te aima 're roti za'ra wa'wa. Tane nherẽ, ropoto na'rata hawimhã, ãne na 're ĩromhâimana mono zé hã robaba di. ");
INSERT INTO xavNT_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Taha wa, tô sena wa za duré aima waihu'u za'ra wa'wa. Ni'wa hã aibâ hã, ĩmro aibâ na sipsaihuri õ nherẽ, timro te te mei wamhã, pi'õ aimawi na mro wamhã, te za tiwasédé hã 'manha, aibâ hã. ");
INSERT INTO xavNT_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Tawamhã wa norĩ hã Zezusihi siré 're ĩwanomro mono norĩ hã wa tãma nharĩ za'ra ni, ãne: — Tane ze te bâ, damro ãna te za 're danomro pé. ");
INSERT INTO xavNT_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Tawamhã Zezusi hã te duré asa wama nharĩ za'ra: — Ã hã te ãma ĩrowasu'uzé hã aihĩni da te 're ĩwaihu'u za'ra mono da hã mare di za. 'Re ĩhâimana u'âsi mono te te tãma 're ĩwaihu'u za'ra mono norĩ si, te za te te 're waihu'u pese za'ra, ãne hã. ");
INSERT INTO xavNT_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Aibâ hã ni'wam norĩ hã 're ĩpoto za'ra mono zém hawim haré, 're 'ra waihu'u za'ra mono õ wa, te za ta norĩ si mro ãna 're nomro, õne haré. Duré aibâ hã ni'wam norĩ hã da te 're sihâri za'ra mono wamhã, oto 're 'ra waihu'u za'ra mono õ wa, te za duré ta norĩ hã mro ãna 're nomro. Duré ni'wam norĩ hã te za tihâiba hã te te 're sawi pese za'ra 'râwi, 're mro za'ra mono tõ da, 'Re ĩhâimana u'âsi mono nhib'a'uwẽ si 're nomro mono da. Ni'wam norĩ hã ãne hã te te 're waihu'u pese za'ra mono wamhã, te za tô ãma 're sõpré u'âsi. — Ãne ma tô Zezusi hã wama waihu'u za'ra, ĩsiré 're ĩwanomro mono norĩ ma. ");
INSERT INTO xavNT_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Tawamhã ma tô Zezusihi u, ai'uté da te simro, tinhib'rada hã ĩ'rã nhisiwi, te te nasi ãma aza'ra sina, Timama ma, ãma mreme za'ra da. Tane nherẽ, ĩsiré 're ĩwanomro mono norĩ hã wa tô dama nharĩ za'ra ni, da te ĩtẽme simro tõ mono da, ai'uté norĩ hã. ");
INSERT INTO xavNT_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Tawamhã Zezusi te wama nharĩ za'ra, ĩsiré 're ĩwanomro mono norĩ ma: — Tô'ã. Dawi rosawi za'ra wa'aba tõ. A'â we ĩ̱tẽme da te simroi mono, ai'uté norĩ hã. Ã norĩ hã ai'uté norĩ hã õne haré simizazei pese na 're ĩhâimana za'ra mono ne, tane ni'wam norĩ hã 're hâimana za'ra mono wapsi, ta norĩ hã te za 'Re ĩhâimana u'âsi mono hã ãma 're sib'a'uwẽ za'ra. — Ãne te wama rowasu'u za'ra, Zezusi hã. ");
INSERT INTO xavNT_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Tawamhã tinhib'rada, ĩ'rã nhisiwi te te nasi ãma aza'ra sina te hâiwa u nasi ãma timreme za'ra. Taha pari ma tô mo. ");
INSERT INTO xavNT_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Tawamhã nimahã bâtâ na ma tô aibâ hã mo, Zezusihi u, te te sadanharĩ da. Ãne te sadanha: — Rowahutu'wa, e marĩ ĩwẽ hã wa za 'manha, 're ĩdanomro u'âsi mono zé hã te ĩ̱sina ĩ'uwaimrami da hã. ");
INSERT INTO xavNT_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Tawamhã Zezusi te asa tãma tinha: — E marĩ da, te ãne ĩ̱zadanha, marĩ ĩwẽ hã da te 're ĩ'manharĩ za'ra mono zém na hã. Misire 're ĩmorĩ wẽ uptabi hã te 're hâimana. 'Re ĩhâimana u'âsi mono nhimiroti 'rata na Mozési te te ãma rob'ui'éré hã 're 'madâ'â pese mono wapsi, te za asina ĩ'uwaimra, dadâ'â ãna 're ĩdanomro u'âsi mono zé hã. ");
INSERT INTO xavNT_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Tawamhã aibâ te duré sadanha, Zezusi hã: — E ma hã 'Re ĩhâimana u'âsi mono nhimiroti 'rata na rob'ui'éré hã wa za te 're 'madâ'â pese. Tawamhã asa te tãma tinha, Zezusi hã: — “'Re danhimroi wa'aba mono õ di za. Duré aimro na asiwi 're asipsaihuri za'ra wa'aba mono õ di za. Duré danhibrom na dawi 're asipsaihuri za'ra wa'aba mono õ di za. Duré dawasu'u wasété na dama 're asadawa nhipese za'ra wa'aba mono õ di za. ");
INSERT INTO xavNT_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Duré aimama hã te za 're ĩwazé pese za'ra wa'aba mo, ana zama. Te za duré uburé 're ĩdazawi pese za'ra wa'aba mo. Marĩ ĩwẽ zô asima 're asõpré wa'aba mono ne, te za duré uburé dama zama sô 're asõpré wa'aba mo, ĩwẽ zô.” — Ãne ma tô Zezusi hã tãma waihu'u, aibâ ma. ");
INSERT INTO xavNT_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Tawamhã ĩprédupté hã ma duré ãma sada'â apâ, tô õ hã: — Tô õhõ si, wa tô 'Re ĩhâimana u'âsi mono nhimiroti 'rata na rob'ui'éré hã te 're 'madâ'â pese, uburé. E marĩ, wa za 'manha, ãhã nhipai u hã bété. ");
INSERT INTO xavNT_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Tawamhã Zezusi te asa tãma tinha, ãne: — Rowẽ na 're aihâimana mono zéb zô, 're rosa'rata mono wamhã, mo oto aimorĩ, uburé asibro hã dama wede mono da, da te aiwi ĩ'uipra za'ra zé hã rob'uiprazé hã ĩsibrob'õ norĩ ma, sõmri mono da. Tawapsi asibro pese di za, hâiwa ãma. Taha parip si te za we apâ aimo ĩ̱tẽme, ĩ̱siré 're aimorĩ da oto. ");
INSERT INTO xavNT_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Tawamhã ãne hã te te wapari wamhã, ma tô aibâ ĩprédupté hã robzei ãna mo, tinhibro pese si te te sima sawi wa. ");
INSERT INTO xavNT_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Tawamhã ĩsa'u ma tô Zezusi hã wama waihu'u za'ra, ĩsiré 're ĩwanomro mono norĩ ma: — Tô sena wa aima waihu'u za'ra wa'wa. Ĩsibro pese norĩ hã 'Re ĩhâimana u'âsi mono, da'ãma 're ĩsib'a'uwẽ mono zéb u 're ĩsisisi mono da hã, pire di. Tãma pire uptabi za'ra di za. ");
INSERT INTO xavNT_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","E niha te za awaru ba'õmore hã ĩsi'uwazi para'õtõ zapu'u 're ãzé. Sébré waihu'u õ di. Tane, ĩsibro pese norĩ hã si'uihâ na 're sisisi waihu'u mono õ di za, 'Re ĩhâimana u'âsi mono, da'ãma 're ĩsib'a'uwẽ mono zéb u hã. — Ãne ma tô wama waihu'u za'ra, Zezusi hã. ");
INSERT INTO xavNT_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Tawamhã ãne ĩmreme hã wa te wapari za'ra wamhã, wa tô ãma watob'uzu za'ra ni, ĩsiré 're ĩwanomro mono norĩ hã. Tawamhã wa wasisadanharĩ za'ra ni, ãma: — Ĩsibro pese norĩ ma, waihu'u za'ra õ wamhã, e 'wam norĩ hã te za bété danho'reptuzé hã te te sina 're uwaimrami za'ra, dadâ'â ãna 're ĩdanomro u'âsi mono zé hã. ");
INSERT INTO xavNT_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Tawamhã Zezusi hã te wa'madâ'â pese za'ra, ĩsiré 're ĩwanomro mono norĩ hã. Tawamhã, te te wa'madâ'â pese za'ra wamhã, te duré asa wama nharĩ za'ra: — Dasi'uihâ na danho'reptuzé hã da te dasina 're uwaimrami za'ra mono õ di za. Dama waihu'u õ di. 'Re ĩhâimana u'âsi mono si siminho'reptu waihu'u pese di. Taha ma si waihu'u pese di, uburé marĩ hã te te 're ĩ'ab'manharĩ mono zéb da hã. ");
INSERT INTO xavNT_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Tawamhã Pedru te tãma siwasu'u, ãne: — Wa norĩ hã wa tô wanhibro hã uburé rẽme pese za'ra ni wasipara, asiré 're wanomro mono da oto. Ãne wamhã, e marĩ te za 'Re ĩhâimana u'âsi mono hã te te wama 're apisutu, te te wama 're ĩ'anhomri mono da hã. ");
INSERT INTO xavNT_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Tawamhã Zezusi te asa wama nharĩ za'ra: — Ãne, tô sena wa za duré aima waihu'u za'ra wa'wa. Niwapsi wa hã dasiré ĩ̱podo hã wa za ro ĩtéb ãma danhib'apito simasisizém na 're ĩ̱nhamra. Ĩ̱simasisizé ĩwẽ uptabi ãma wa za 're ĩ̱nhamra, te 're da'ab'madâ'â u'âsi mono da oto. Tame te za duré a norĩ wa'wa hã ĩ̱siré 're anomro aba mono norĩ hã 12 na danhib'apito simasisizém na 're asimroi wa'aba mo, aipire na Izarazéhé 'ra nhihudu mono bâ 're 'madâ'â za'ra wa'aba mono da. ");
INSERT INTO xavNT_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Ãté ni'wam norĩ hã te za tinhorõwa hã te te 're rẽme pese za'ra, duré ãté tisisãnawã norĩ hã, duré ãté timama norĩ hã, duré ãté ti'ra norĩ hã, duré ãté tinhipti'a hã. Ãté ĩ̱siré 're nomro mono da, te za uburé marĩ hã te te 're rẽme pese za'ra. Ta norĩ ma, te za uburé marĩ te te 're ĩrẽme za'ra mono zém nhipai u pese, 'Re ĩhâimana u'âsi mono te te tãma 're anhomri. Ta norĩ ma si te za dadâ'â ãna 're ĩdanomro u'âsi mono zé hã te te tãma 're apisutu. ");
INSERT INTO xavNT_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Ni'wam norĩ hã dama ĩpire na ti'ab ré 're hâimana za'ra mono nherẽ, te za 'Re ĩhâimana u'âsi mono hã te te tãma 're apisutu da'ahâ na, wapu na 're hâimana za'ra mono da oto, za da'ãma 're ĩsib'a'uwẽ mono zéb ãma hã. Duré ni'wam norĩ hã ti'ab ré dama wapu na 're hâimana za'ra mono nherẽ, te za te te tãma 're apisutu, pire na oto 're hâimana za'ra mono da. — Ãne ma tô Zezusi hã wama waihu'u sirõmo za'ra, ĩsiré 're ĩwanomro mono norĩ ma. ");
INSERT INTO xavNT_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Tawamhã Zezusi hã ma tô duré romnhimiré'é na wama rowasu'u za'ra, ĩsiré 're ĩwanomro mono norĩ ma: — 'Re ĩhâimana u'âsi mono, da'ãma 're ĩsib'a'uwẽ mono zém na, wa za duré aima ãma romnhimiré'é za'ra wa'wa, ãne. Aibâ hã buru tede'wa hã bâdâ 'rãiwatobro wi, ma tô mo, tãma ĩromhuri'wa norĩ da hã, te te da'maipisutu za'ra da, te te ãma tãma romhuri za'ra da, uwa 'ru na. ");
INSERT INTO xavNT_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Tawamhã te te da'anhopẽtẽ wamhã, ma tô tãma pisutu za'ra, misi bâtâ na dapawa'âbâzéb uwaibaba te te ãma pawa'âbâ za'ra mono da. Taha wa, ma tô ãma saze za'ra, tãma ĩromhuri za'ra 'wa da hã. Tawamhã ma tô tãma rob'ru za'ra, misi bâtâ na te te romhuri za'ra da, rob're na, uwa 'ru na. ");
INSERT INTO xavNT_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Tawamhã mararé ma tô duré mo, bâtâ si'ré na, 'ri nhi'riti wa, da te dasima 're ĩrowede za'ra mono zéb u. Tame ma tô duré aibâ norĩ hã sõpẽtẽ za'ra, romhuri ãna taré da'rata ĩsi'ubumro hã. ");
INSERT INTO xavNT_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Tawamhã ãne ma tô tãma nharĩ za'ra: “A norĩ wa'wa hã te za oto ai'aba'réi wa'wa ĩ̱buru u, uwa 'ru na dame romhuri za'ra wa'aba da. Tawamhã dapawa'âbâzéb uwaibaba, wa za duré aipawa'âbâ za'ra wa'wa.” Ãne ma tô duré buru tede'wa hã tãma pisutu za'ra. ");
INSERT INTO xavNT_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","— Tawamhã ĩburu u te oto ai'aba'ré, te te tãma romhuri za'ra da. Tawamhã abzuma ma tô duré aibâ norĩ hã sõpẽtẽ za'ra, buru tede'wa hã. Taha wa, te duré satõrĩ za'ra, ĩburu na te te dame romhuri za'ra da. Bâdâ sipra wi, ma duré sõpẽtẽ za'ra aibâ norĩ hã, aimawi hã. Tô õhõ si ma duré tãma pisutu za'ra. Tawamhã ta norĩ hã te duré dazarina ai'aba'ré. ");
INSERT INTO xavNT_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Tawamhã hâiwahâ pesere te duré mo buru tede'wa hã, 'ri nhi'riti wa, da te dasima 're ĩrowede za'ra mono zéb u. Tawamhã aibâ norĩ hã ma duré sõpẽtẽ za'ra aimawi hã, romhuri ãna taré da'rata ĩsi'ubumro hã. Te te sõpẽtẽ za'ra wamhã, ãne te sadanharĩ za'ra: “E marĩ wa, te taré asimroi wa'wa, bâtâ bâ, marĩ hã dame 'manharĩ za'ra wa'aba ãna.” ");
INSERT INTO xavNT_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","— Tawamhã asa te tãma nharĩ za'ra, ãne: “Ni'wa hã marĩ hã te te wama pisutu õ di, wa te tãma ĩromhuri za'ra zéb da hã. Taha wa, marĩ na wa te dame romhuri za'ra õ di, ã bâtâ na hã.” — Tawamhã buru tede'wa te duré tãma rob'ru za'ra: “Mo oto a norĩ wa'aba zama dazarina ai'aba'réi wa'aba, ĩ̱buru na dame romhuri za'ra wa'aba da, uwa 'ru na.” Ãne ma tô buru tede'wa hã satõrĩ za'ra. ");
INSERT INTO xavNT_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","— Tawamhã mara simei wamhã, tãma ĩromhuri'wa norĩ 'madâ'â'wai ma, te tinha ãne, buru tede'wa hã: “Ma'ãpé, uburé ĩ̱ma romhuri'wa norĩ zô aihârâ za'ra na oto, pawa'âbâ mono da. Tawamhã daza'u romhuri na te te ĩsãna'rata za'ra norĩ, uimrehẽne te za ĩpawa'âbâ na'rata za'ra. Taha parip si te za duré romhuri na ĩsãna'rata'wa norĩ hã ĩpawa'âbâ za'ra.” Ãne ma tô tãma waihu'u, buru tede'wa hã. ");
INSERT INTO xavNT_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","— Tawamhã hâiwahâ pesere, romhuri na te te ĩsãna'rata za'ra hã ma tô rob'uiprazé hã waibu hâiba mono bâ, misi bâtâ na dapawa'âbâzéb uwaibaba, bâtâ bâ te te romhuri za'ra õ nherẽ. ");
INSERT INTO xavNT_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","11","Tawamhã dawana romhuri na te te ĩsãna'rata za'ra norĩ hã ma tô duré hâiba mono bâ waibu rob'uiprazé hã, aiwapsi. Tane nherẽ, te te waibui wamhã, ma tô tãma nharĩ za'ra, buru tede'wai ma, ĩsa'u romhuri na te te ĩsãna'rata za'ra norĩ pawa'âbâ nhipai u, te te waibui õ wa. ");
INSERT INTO xavNT_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","Ãne te mreme nhiti'ru na tãma nharĩ za'ra: “Õ norĩ hã hâiwahâ si romhuri na te te ĩsãna'rata za'ra hã misi bâtâ za'ratazé hã ma tô sina uprosi za'ra. Wa norĩ hã bété. Bâtâ bâ, wa te ĩromhuri za'ra hã, rowa'ro uptabi nherẽ. E niha bâ, ma bété õ norĩ zama tipawa'â hã waibu, aiwa wapawa'âbâ za'ra me.” ");
INSERT INTO xavNT_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","— Tawamhã aibâ norĩ siré ma, te misi tinha, buru tede'wa hã: “Ĩ̱siwaihu, ĩ̱wapari pese. Wa hã te aima 'manharĩ wasété õ di, ãne hã. Oro ãma ĩ̱zaze za, bâtâ bâre ĩ̱ma romhuri da, tô misi bâtâ na dapawa'âbâzéb uwaibaba te aipawa'âbâ da. ");
INSERT INTO xavNT_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Ma tô dame asima ĩ'âri pa. Taha wa, te za oto aimo. Wa tô ĩ̱sima wẽ, aiwa aipawa'âbâ za'ra wa'aba ne te pawa'âbâ za'ra da, asa'u wa'aba romhuri na te te ĩsãna'rata za'ra norĩ hã. ");
INSERT INTO xavNT_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Te ĩ̱sima ĩwẽ zéb zarina, ĩ̱te rob'uiprazém na te da'apawa'âbâ wamhã, e ĩ̱wasédé wa tô 'manha. Mare di. Ĩ̱wasédé hã te 'manharĩ õ di. Ãté taré dama ĩ̱nhopru wa, ma tô ĩ̱zada asahi, bâtâ bâ te te ĩ̱ma romhuri za'ra õ nherẽ, bâtâ na dapawa'âbâzém na te pawa'âbâ za'ra 'ru te.” Ãne ma tô buru tede'wa hã tãma siwaihu'u, tãma ĩromhuri'wai ma. — Ãne ma tô Zezusi hã wama ãma romnhimiré'é za'ra, ĩsiré 're ĩwanomro mono norĩ ma. ");
INSERT INTO xavNT_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Tawamhã ãne ma tô Zezusi hã timreme na wama 'rãsutu za'ra: — Ni'wam norĩ hã dama pire na ti'ab ré 're hâimana za'ra mono nherẽ, 'Re ĩhâimana u'âsi mono si te za te te tãma 're pisutu za'ra, wapu na 're hâimana za'ra mono da oto, za da'ãma 're ĩsib'a'uwẽ mono zéb ãma hã. Duré ni'wam norĩ hã ti'ab ré dama wapu na 're hâimana za'ra mono nherẽ, te za te te tãma 're pisutu za'ra, pire na oto 're hâimana za'ra mono da. — Ãne ma tô timreme na wama 'rãsutu za'ra, Zezusi hã. ");
INSERT INTO xavNT_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Tawamhã wa norĩ hã Zeruzarẽ u wa oto ai'aba'ré ni, Zezusihi siré. Wasi'aba'réi ré, ma tô wahâiba pisutu, wama rowasu'u za'ra, ĩsiré 're ĩwanomro mono norĩ ma, 12 na wahâiba za'ra ma. Ãne te wama rowasu'u za'ra, Zezusi hã: ");
INSERT INTO xavNT_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","— Ĩ̱wapari pese za'ra wa'aba. Ãhãna, wa Zeruzarẽ u ai'aba'ré ni. Tame wa hã dasiré ĩ̱podo hã te za dasima ĩ̱hâiba nhomri ni, sasedoti ĩpire norĩ ma, 'Re ĩhâimana u'âsi mono nhimiroti 'rata na rob'ui'éré na dama rowahutu'wa norĩ ma zama. Ta norĩ hã ĩ̱wasédé te te ĩ̱'ãma ĩsa'ra za'ra zéb zarina, te za dama ĩ̱'ru za'ra, da te ĩ̱wĩrĩ da, dasiwi. ");
INSERT INTO xavNT_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Taha zarina te za oto zudezu'õ norĩ ma siwi ĩ̱hâiba nho. Tawamhã te za ĩ̱'ãma tiwa'ẽ za'ra, zudezu'õ norĩ hã. Te za ĩ̱'ãma wasété za'ra ni duré. Te za duré da te dasiwi 're ĩ̱pré'é. Taha parip si, te za wedepo'o nhonhi'rãmi na dasiwi ĩ̱zasõmri ni hâiwi, ĩ̱dâ'â da. Tane nherẽ, bâdâ maparane ĩ̱'ãma si'utõrĩ õ ré, wa za apâ hâiwa'udu. — Ãne ma tô wama siwaihu'u sirõmo za'ra, Zezusi hã. ");
INSERT INTO xavNT_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Tawamhã Zebedehe mro hã ma tô Zezusihi u mo, ti'ra si'aibâ norĩ siré. Ĩtẽme morĩ wamhã, tãma pire wa, ma tô tãma aiwẽ'ẽ, ti'ra norĩ ma, te te tiwi rowaptẽrẽ da. ");
INSERT INTO xavNT_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Tawamhã Zezusi hã te pi'õ sadanha, ãne: — E marĩ ma tô asima ĩ̱wẽ, te aima ãma ĩ'uwaimrami da hã. Tawamhã pi'õ te asa tãma tinha: — Ma'ãpé, ĩ̱'ra norĩ ma, tãma ropisutu sirõmo zahuré na, danhib'apito simasisizém na asimire niwĩ duré asimi'e niwĩ dama pire na 're simasisi u'âsi zahuré mono da, za 'Re ĩhâimana u'âsi mono hã da'ãma ĩsib'a'uwẽzéb ãma hã. — Ãne te Zezusihi wi rowaptẽ, ti'ra norĩ ma, pi'õ hã. ");
INSERT INTO xavNT_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Tawamhã Zezusi hã te ĩ'ra norĩ ma oto rowasu'u zahuré, ãne: — E marĩ da, te rosa'rata ãna asina ĩ̱zadanharĩ 'wa. Wa hã wa za robzépata za'ẽtẽ, dawi ĩ̱sisawi ãna. E tawamhã sada asiptete aba di, za te ĩrobzépata za'ẽtẽ ne, ĩrobzépata aba da hã. Tawamhã asa te tãma nharĩ zahuré, Zebedehe 'ra norĩ hã: — Ĩhe. Sada wanhiptete di za, asine wa te ĩrobzépata da hã. — Ãne ma asa tizadawa na tãma wa'rãmi zahuré, Zezusihi ma. ");
INSERT INTO xavNT_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Tawamhã Zezusi hã te duré tãma rowasu'u zahuré, ãne: — Te za tô ĩ̱sine ĩrobzépata za'ẽtẽ 'wa. Tane nherẽ, ĩ̱si'uihâ na te aipisutu waihu'u aba õ di za, dama aipire wa'aba na 're aihâimana aba mono zéb da hã, ĩ̱nhimire niwĩ, duré ĩ̱nhimi'e niwĩmhã. Ĩ̱mama te te ĩpisutu za'ra norĩ si te za dama pire na ĩ̱'rata 're hâimana u'âsi za'ra. Ta norĩ hã te pisutu za'ra õ di za, wa hã. — Ãne te tãma siwasu'u zahuré, Zezusi hã. ");
INSERT INTO xavNT_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Tawamhã Zezusihi siré 're ĩwanomro mono norĩ hã 10 na wahâiba za'ra hã, Zebedehe 'ra norĩ mreme wa te wapari za'ra wamhã, wa tô sada wanhiti'ru za'ra ni. ");
INSERT INTO xavNT_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Taha wa, Zezusi hã te sima wazô tihârâ za'ra, ĩsiré 're ĩwanomro mono norĩ zô. Tawamhã ãne te wama nharĩ za'ra: — Ti'ai ãma danhib'apito norĩ hã te pire uptabi na dama 're hâimana za'ra. Sa'ẽtẽ te duré te te 're dawada'uri za'ra, ĩsimiroti hã da te 're 'madâ'â pese za'ra mono da. ");
INSERT INTO xavNT_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Tane asima 're aihâimana za'ra wa'aba mono õ di za, a norĩ wa'wa hã. Asiré norĩ ma, ai'maipire wa'aba da, asina 're 'mairob'ruiwapari aba mono wamhã, te za asiré hã 're ĩ'maipawaptob u'âsi aba mo, marĩ zô 're ai'manhimnhasi aba mono ãna. ");
INSERT INTO xavNT_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Duré 'râwi asima aipire uptabi na 're ai'maihâimana aba mono da, asima 'maiwẽ uptabi aba wamhã, pawa'âbâ ãna romhuri'wa ne, te za asima 're ĩ'mairomhuri wẽ wa'aba mo. ");
INSERT INTO xavNT_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Tane duré, wa hã dasiré ĩ̱podo hã da te ĩ̱ma 're romhuri za'ra mono da, we ĩ̱morĩ õ di, ti'ai u. Te 're da'apawapto mono da si, wa wei datẽme mo, ĩ̱sihâiba zawi ãna dazada ĩ̱dâ'â da, da'upana te da'awa'âbâ da. — Ãne ma tô Zezusi hã wama siwasu'u za'ra. ");
INSERT INTO xavNT_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Tawamhã wa norĩ hã wa tô ai'aba'ré ni, Zezusihi siré, Zerico hawi. Wasi'aba'réi wamhã, da'ahâ na ma tô wazarina hã ai'aba'ré ni. ");
INSERT INTO xavNT_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Tawamhã aibâ ĩtob'a norĩ hã bâdâdi waptoma ĩsimasisi zahuré hã ma tô Zezusihi wasu'u hã wapari zahuré, bâdâdi na ĩsababa za te te ĩro'razâri zahuré na hã. Ãne hã te te wapari zahuré wamhã, te nasi sina 'mahârâ zahuré, ãne: — Dawihi nhihudu, ma'ãpé wa'ãma aipẽ'ẽzé na. — Ãne te nasi sina 'mahârâ zahuré, ĩtob'a norĩ hã. ");
INSERT INTO xavNT_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Tawamhã da'ahâ na Zezusihi zarina ĩdasi'aba'ré norĩ hã ma tô tãma nharĩ za'ra, ari'iwi simasisi zahuré da. Tane nherẽ, sa'ẽtẽ te nasi sina 'mahârâ zahuré, ãne: — Apito, Dawihi nhihudu, ma'ãpé wa'ãma aipẽ'ẽzé na. ");
INSERT INTO xavNT_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Tawamhã ma Zezusi hã ĩ'rata mazazâri zahuré, bâdâdi wa. Taha wa, te 'mahârâ zahuré, ĩtob'a norĩ hã: — E marĩ te asima ĩwẽ wa'wa, te aima ĩ'manharĩ aba da hã. ");
INSERT INTO xavNT_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Tawamhã asa te tãma nharĩ zahuré: — Apito, wato pese da, wa wasima wẽ ni. — Ãne ma tizadawa na tãma wa'rãmi zahuré, ĩtob'a norĩ hã. ");
INSERT INTO xavNT_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Tawamhã Zezusi hã ma tô ãma tipẽ'ẽzé zahuré, ĩtob'a norĩ ãma. Taha wa, ma tô tõmo upi zahuré, apâ tõmo wẽ zahuré da. Te te tõmo upi zahuré wi, awa'awi ma tô tito pese zahuré. Te te rob'madâ'â wẽ zahuré di oto. Tawamhã Zezusihi zarina te oto tineb zahuré, awa'awi. ");
INSERT INTO xavNT_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Tawamhã wa norĩ hã wa tô oto ai'aba'ré ni, Zezusihi siré, Zeruzarẽ u. Tawamhã wa tô rob'umhutu za'ra ni oto, Betazé na 'ri wa'õtõ nhisi u. Oriwera na ẽtẽ 'rãihâ nhisi ãma 'ri wa'õno hã. Wa te rob'umhutu za'ra wamhã, ma tô Zezusi hã ĩsiré 're ĩwanomro mono norĩ hã maparane wa'mazatõ sisõwa, 'ri wa'õtõ u. ");
INSERT INTO xavNT_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","Ãne ma tô satõrĩ zahuré: — Õwa te za ane wa'wa, 'ri wa'õtõ u, asõ're uwaibaba wa'aba. Tawamhã aimasisi aba wi, te za awaru po'repore hã ĩsãmri 'wa, butu wazi na da te ãma wasisi haré, ĩsa hã. Tame te duré ĩ'ra hã ĩsiré za. Tawamhã te za ĩwasihu zahuré wa'wa, sahuré we ĩ̱ma saprõni aba da. ");
INSERT INTO xavNT_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Tawamhã ni'wa hã awaru po'repore, sahuré we ĩ̱ma ĩsaprõni aba na te te asadanharĩ aba wamhã, ãne te za tãma ĩ̱zadawa wasu'u wa'wa, asa: “Wanhib'apito hã marĩ õ wa, ãma morĩ da, wa we sô wanem ni, wa te tãma saprõni zahuré da.” Ãne hã tãma waihu'u aba wi, te za ãma asazei wa'wa, sahuré we ĩ̱ma saprõni aba da, awaru po'repore hã. — Ãne ma tô Zezusi hã tãma waihu'u zahuré. ");
INSERT INTO xavNT_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Duréihã 'Re ĩhâimana u'âsi mono zadawa wasu'u 'rata 'wa te te ãma ĩrob'ui'éré sirõmo zéb zarina te te sina uwaimrami da, ma tô Zezusi hã ãne tãma pisutu zahuré, awaru po'repore te te ĩtẽme saprõni zahuré da. Ãne duréihã ãma ĩrob'ui'éré siro hã: ");
INSERT INTO xavNT_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Ma'ãpé, tãma rowasu'u za'ra wa'aba, Si'ã na ẽtẽ 'rãihâ nhisi ãma 're ĩdasi'ubumroi mono norĩ ma, ãne: ‘Õhõta te we oto atẽme timorĩ 'wa, asib'apito za'ra wa'wa hã. Ta hã dazada 're ĩhâimana mono õ hã ĩsimizawi pe hã te we ãma mo, awaru po'repore na, ĩpréduptém na hã.’ ” Ãne duréihã 'Re ĩhâimana u'âsi mono zadawa wasu'u'wa nhimi'ui'éré hã, Zeruzarẽ ãma 're ĩdasi'ubumroi mono norĩ ma hã. ");
INSERT INTO xavNT_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Tawamhã Zezusi te te tãma ĩpisutu zahuré zéb zarina, ma tô awaru po'repore norĩ zô tineb zahuré, wasiré norĩ hã. ");
INSERT INTO xavNT_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Tawamhã, te te sãmri zahuré wamhã, ma tô apâ saprõni zahuré Zezusihi u, awaru po'repore hã ĩ'ra ré. Tawamhã tisi'ubuzém na ma tô tãma ba'ubu zahuré. Taha pari, ma tô ãma darõno Zezusi hã, ãma morĩ da. ");
INSERT INTO xavNT_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Tawamhã da'ahâ uptabi na ma tô dasi'ubuzém na tãma waptâ za'ra ni bâdâdi na, ĩsisiwi ĩmorĩzéb da hã, dama pire wa, sô 're datob'uzu za'ra mono wa. Wedepa nhipti su na zama ma duré tãma waptâ za'ra ni. ");
INSERT INTO xavNT_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Tawamhã Zezusihi nhowa ĩdasi'aba'ré norĩ hã duré ĩsarina ĩdasi'aba'ré norĩ zama te nasi dasima 'mahârâ za'ra ni, ãne: — Apito Dawihi nhihudu ãma, 're wawata za'ra wa'aba mono. Wanhib'apito zadawa para, te we oto mo. 'Re ĩhâimana u'âsi mono hã ĩwẽ si te te tãma 're pisutu u'âsi mono neza. 'Re ĩhâimana u'âsi mono ãma zama duré 're wawata za'ra wa'aba mono, hâiwa ãma 're ĩsãmra mono ãma, wei watẽme te te satõrĩ wẽ te. — Ãne te nasi dasima 'mahârâ za'ra ni, da'ahâ na. ");
INSERT INTO xavNT_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Tawamhã Zeruzarẽ u ma oto wi, Zezusi hã. Wisi wamhã, ĩwa 're ĩdasi'ubumroi mono norĩ hã ma tô da'ahâ uptabi na 're dasiwairõtõ, da te dasima 'mahârâ za'ra sina. Taha wa, te nasi tasisadanharĩ za'ra ni, ãne: — E 'wa hã, õ hã bété. ");
INSERT INTO xavNT_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Tawamhã Zezusihi zarina ĩdasi'aba'ré norĩ hã ma tô dama nharĩ za'ra, Zeruzarẽ ãma 're ĩdasi'ubumroi mono norĩ ma: — Ã hã Zezusi, 'Re ĩhâimana u'âsi mono zadawa wasu'u'wa, Nazaré na 'ri wa'õtõ nhisi hawi we ĩmorĩ hã, Darireza na danhipti'a nho'õmo nhisi hawi. — Ãne ma tô ĩsiré ĩdasi'aba'ré norĩ hã dama wasu'u za'ra. ");
INSERT INTO xavNT_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Tawamhã Zezusi hã ma tô oto ãzé, 'ri 'rãihâ u, 'Re ĩhâimana u'âsi mono ãma 're ĩdawata za'ra mono zéb u. Tame te dama rowede'wa norĩ hã 're si'ubumro, dawi marĩ uipra'wa norĩ zama, 'ri 'wawi wa'ra 're. Tawamhã Zezusi hã ta norĩ hã te te 'madâ'â za'ra wamhã, ma tô te te sate, rob u. Wedeza hã rob'uiprazém na te te dawi ãma 're ĩsaprĩ za'ra mono norĩ te hã ma tô te te tiwi anhamra, utu'u te te dama 're ĩwede za'ra mono norĩ simasisizéb zama. ");
INSERT INTO xavNT_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Tawamhã Zezusi hã ãne te tãma nharĩ za'ra, rowede'wa norĩ ma: — Duréihã wahi'rada hã ma tô ãne na rob'ui'éré, 'Re ĩhâimana u'âsi mono mreme na: “Ĩ̱nhorõwa hã ĩwa ĩ̱ma 're ĩdamreme zusi mono zém na, te za da te 're sisi za'ra, 'ri hã.” Ãne te tinha. Tane nherẽ, a norĩ wa'wa hã ma tô ĩwa asima ãma 're ĩrob'manharĩ wasété za'ra wa'aba mo. Taha wa, danhibrom na dawi 're ĩsipsaihuri za'ra mono norĩ, 're ĩsi'ubumroi mono zém ne, te oto 'ri hã 're sa, wasété uptabi na. Ãne duréihã ai'ãma rob'ui'éré za'ra wa'wa hã, ĩbaihâ na hã. — Ãne na ma tô Zezusi hã tãma waihu'u za'ra, duréi rowasu'u na hã. ");
INSERT INTO xavNT_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Tawamhã Zezusi hã 'Re ĩhâimana u'âsi mono nhorõwa ãma 'ri 'wawi wa'ra 're, zahadu sãmra ré, ma tô da'ahâ na ĩtẽme dasito, ĩtob'a norĩ hã ĩmorĩ waihu'u'õ norĩ zama. Ĩtẽme dasito mono wamhã, ma tô da'apese, uburé ĩhâzé ré norĩ hã. ");
INSERT INTO xavNT_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Tawamhã ai'uté norĩ hã ma tô nasi sima 'mahârâ za'ra, ãne: “Apito Dawihi nhihudu ãma, 're wawata za'ra wa'aba mono.” Ãne te nasi sima 'mahârâ za'ra, 'ri 'wawi wa'ra 're, sãmra ré. Tawamhã 'Re ĩhâimana u'âsi mono ma, da'ãma romhuri'wa norĩ ma, ĩpire norĩ hã tisiré ma, duré ĩsimiroti na rob'ui'éré 'rata na dama rowahutu'wa norĩ hã, ai'uté norĩ te te nasi sima ĩ'mahârâ za'ra zé hã te te wapari za'ra wamhã, duré tinhimiromhõsi na Zezusi te te 're ĩda'apawapto mono zé te te 'madâ'â za'ra wamhã, ma tô sada tizahi za'ra, Zezusihi zada. ");
INSERT INTO xavNT_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Tawamhã ta norĩ hã te Zezusi hã siwi sadanha: — E wapari õ di, ai'uté norĩ mreme hã. E asina sadawa uwati za'ra ãna. — Ãne te tãma nharĩ za'ra, rowahutu'wa norĩ hã. Tawamhã Zezusi hã asa te duré tãma nharĩ za'ra, ãne: — Wa tô wapari za'ra. A norĩ wa'wa hã bété. E sõré za'ra wa'aba õ di, wahi'rata nhimi'ui'éré hã: “Ai'uté norĩ ma, ma tô ĩwaihu'u sirõmo za'ra, ai'utépré norĩ ma zama, ĩwẽ na si ai'ãma 're wata za'ra mono da.” Ãne ma tô wahi'rada hã ĩ̱'ãma rob'ui'éré siro, ĩbaihâ na hã. — Ãne ma tãma waihu'u za'ra. ");
INSERT INTO xavNT_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Tawamhã Zezusi hã te oto ĩhawi timorĩ za'ra, Betãnha na 'ri wa'õtõ nhisi u, tame a'â sõtõ da. ");
INSERT INTO xavNT_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Tawamhã mararé ma tô Zezusi hã apâ mo Zeruzarẽ u, ĩsiré 're ĩwanomro mono norĩ me. Morĩ ré, ma tô mra hã tĩwĩ, Zezusi hã. ");
INSERT INTO xavNT_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Tawamhã wede hã ma tisã, bâdâdi zada'ré ĩsa hã. Pidera na wede nhisi hã. Te te sãmri wamhã, ma tô ĩtẽme apa, te te sabu da, ĩ'rã zô. Tane nherẽ, 'rãi ãna te za, ĩsui ré si. Tawamhã pidera wede ma, te oto tinha: — Niwa ĩ'ai'rã da hã, mare di za oto. Ai'rã'õ u'âsi, te za oto 're asa mo. — Ãne te wede ma tinha, Zezusi hã. Tawamhã awa'awi ma wede hã tiwede'ré oto. ");
INSERT INTO xavNT_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Tawamhã wa norĩ hã Zezusihi siré 're ĩwanomro mono norĩ hã ãne hã wa te 'madâ'â za'ra wamhã, wa tô ãma watob'uzu za'ra ni. Taha wa, wa tô Zezusi hã wasiwi sadanharĩ ni, ãne: — E niha ma awa'awi tiwede'ré, pidera wede hã. ");
INSERT INTO xavNT_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Tawamhã Zezusi te asa wama nharĩ za'ra: — Tô sena wa aima waihu'u za'ra wa'wa. 'Re ĩhâimana u'âsi mono hã 're wawã za'ra wa'aba mono ãna, õhõ si 're umnhasi za'ra wa'aba mono wamhã, te za marĩ hã aima waihu'u pese za'ra wa'aba õ nherẽ, 're ĩ'manharĩ za'ra wa'aba mo ĩsadawa para, wa hã pidera wede ma, te ĩnharĩ ne, ãne hã aiwa. Õhõta ẽtẽ 'rãihâ te za. 'Re ĩhâimana u'âsi mono si 're umnhasi za'ra wa'aba mono wamhã, te za ẽtẽ 'rãihâ ma ĩnharĩ za'ra wa'wa, 'râwi sisa'o'o da, âi ba waptã'ã da. Tawamhã asadawa para wa'aba, te za tô âi ba waptãrã, ẽtẽ 'rãihâ hã. Ãne 'Re ĩhâimana u'âsi mono si 're umnhasi za'ra wa'aba mono wamhã, te za tô ĩsadawa para, marĩ ĩwẽ hã 're ĩ'manharĩ za'ra wa'aba mo, aima waihu'u pese za'ra wa'aba õ nherẽ, ãne hã. ");
INSERT INTO xavNT_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","'Re ĩhâimana u'âsi mono hã 're umnhasi za'ra wa'aba mono sina, marĩ na tiwi 're rowaptẽrẽ za'ra wa'aba mono wamhã, tô sena te za te te aima ãma 're a'uwaimrami 'wa. — Ãne hã ma tô Zezusi hã wama waihu'u za'ra, ĩsiré 're ĩwanomro mono norĩ ma. ");
INSERT INTO xavNT_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Tawamhã Zezusi hã ma tô apâ mo, 'Re ĩhâimana u'âsi mono nhorõwa u. Tame te oto dama rowahutu, 'ri 'wawi wa'ra 're. Tawamhã sasedoti ĩpire norĩ hã ma tô ĩtẽme aimasa, zudezu norĩ ma roti'wa norĩ zama. Tawamhã Zezusi hã te siwi sadanha, ãne: — E 'wa sadawa para, te bété ãne hã marĩ hã dama 're ĩ'ab'manharĩ mo. E 'wa hã, aipisutu'wa. ");
INSERT INTO xavNT_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Tawamhã Zezusi te asa tãma nharĩ za'ra: — Wa hã wa za a'â asadanharĩ na aima ãma wa'rãmi za'ra wa'wa. Tawamhã ĩ'uwaibaba, ĩ̱ma waihu'u za'ra wa'aba wapsi, wa za asa aima wasu'u za'ra wa'wa, ni'wa sadawa para te dama 're ĩ'ab'manharĩ mono na hã. ");
INSERT INTO xavNT_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Ãne wa za asadanharĩ za'ra wa'wa: E 'wa sadawa para, ma tô Zuwã hã â dawabzuri hã te te dama 're ab'manharĩ bété. E 'Re ĩhâimana u'âsi mono zadawa para. E dazadawa para. — Ãne ma tô Zezusi hã sadanharĩ za'ra, te te tãma waihu'u za'ra da, a'â. Tawamhã 'râwi te sima nharĩ za'ra, dama rowahutu'wa norĩ hã: — E niha, wa za tãma waihu'u za'ra ni, õne wamhã. 'Re ĩhâimana u'âsi mono zadawa para, â dawabzuri te te dama 're ĩ'ab'manharĩ mono na wa te tãma waihu'u za'ra wamhã, te za wazadanharĩ na sahu za'ra, ãne: “E niha bété, Zuwã Batitaha nhimirowasu'u hã saze za'ra wa'aba õ di, dame.” ");
INSERT INTO xavNT_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Tane nherẽ, taré dazadawa parap si â dawabzuri te te dama 're ĩ'ab'manharĩ mono na wa te tãma waihu'u za'ra wamhã, wa za wasina wapahi za'ra ni dama, niha da te wama rob'manharĩ za'ra õ'umnhasite. E marĩ wa. Zuwã Batita hã 'Re ĩhâimana u'âsi mono zadawa wasu'u'wa 're ĩmorĩ na, da te 're saze za'ra mono wa. — Ãne te 'râwi sima nharĩ za'ra. ");
INSERT INTO xavNT_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Tawamhã Zezusihi ma, te oto asa nharĩ za'ra: — Wa norĩ hã wa te waihu'u za'ra õ di, ni'wa sadawa para, Zuwã Batita hã â dawabzuri te te dama 're ĩ'ab'manharĩ mono zé hã. Tawamhã Zezusi hã asa ma tizadawa na tãma wa'rãmi za'ra: — Tane tô. A norĩ wa'wa hã ĩ̱ma waihu'u za'ra wa'aba õ nherẽ, wa hã te duré aima waihu'u za'ra wa'aba õ di za, ni'wa sadawa para marĩ hã te dama 're ĩ'ab'manharĩ mono na hã. — Ãne ma tô Zezusi hã asa tãma waihu'u za'ra, dama rowahutu'wa norĩ ma hã. ");
INSERT INTO xavNT_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Tawamhã Zezusi hã te duré tãma rowasu'u za'ra, 'Re ĩhâimana u'âsi mono ma, da'ãma romhuri'wa norĩ ma, ãne: — Wa za oto aima ãma romnhimiré'é za'ra wa'wa. Ma'ãpé ãma rosa'rata pese za'ra wa'aba za. Aibâ hã te 're sãmra. Maparane ĩ'ra hã. Tawamhã ti'ra poto 'rata ma, ma tô rob'ru, ãne: “Ĩ̱'ra, mo oto aimorĩ buru u, romhuri da, ã bâtâ na.” ");
INSERT INTO xavNT_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","— Tawamhã asa te tãma tinha, ĩ'ra poto'rada hã: “Te ĩ̱sima rowẽ õ di, ĩ̱morĩ da hã. Wa za nhamra u'â.” Ãne ma tô timama ma waihu'u asa. Tane nherẽ, te te ĩnharĩzém na ãma ronomro wapsi, ma tô tinhimirosa'rata na ãma saprĩ. Taha wa, ma tô oto mo buru u, te te romhuri da. ");
INSERT INTO xavNT_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","— Tawamhã ti'ra hâiba amoi ma, te duré rob'ru, ĩdub'rata ma, te te ĩrob'ruzém ne, buru u morĩ da, te te romhuri da. Tawamhã ĩ'ra hã te asa tãma tinha, timama ma, ãne: “Wẽ di tô, ĩ̱mama. Wa za tô mo, te romhuri da.” Tane nherẽ, ta hã timama mreme hã awa'awi te te saze nherẽ, morĩ õ di, buru u. ");
INSERT INTO xavNT_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","— E 'wa hã tawamhã, timama te te sina ĩsaze hã te te tãma ĩrob'ruzéb uwaibaba, ĩmorĩ da hã. E ĩdub'rada. E ĩno. — Ãne ma tô Zezusi hã ãma sadanharĩ za'ra, 'Re ĩhâimana u'âsi mono ma, da'ãma romhuri'wa norĩ nhib'apito norĩ hã, duré zudezu norĩ ma rowahutu'wa norĩ hã. Tawamhã asa te tãma nharĩ za'ra: — Dama ĩpoto'rada ma tô timama mreme hã sina saze. Tawamhã Zezusi te duré ãne tãma rowasu'u za'ra: — Tane tô. Tane duré, danhib'apito ma rob'uiprazé ubumroi'wa norĩ hã duré pi'õ hã aibâ zô si siwa'ru 're ĩhâimana za'ra mono norĩ hã, ta norĩ hã aré 're hâimana wasété za'ra mono nherẽ, ãté te za 're sisisi, 'Re ĩhâimana u'âsi mono, da'ãma 're ĩsib'a'uwẽ mono zéb u hã, ta norĩ si tô sena na te te 're sazei pese za'ra mono wamhã. Tane nherẽ, a norĩ wa'wa hã ãté dame 're asisisi aba mono õ di za. Tô sena, wa ãne na hã aima waihu'u sirõmo za'ra wa'wa. ");
INSERT INTO xavNT_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Zuwã Batita hã ma tô aré atẽme timorĩ za'ra wa'wa, 'Re ĩhâimana u'âsi mono te te sima 're ĩ'aiwẽ za'ra wa'aba mono zéb zarina 're anomro wẽ wa'aba mono zéb da hã, te te aima 're wasu'u za'ra wa'aba mono da. Tane nherẽ, ĩsimirowasu'u na hã ãma 're saze za'ra wa'aba mono õ di. Rob'uiprazé ubumroi'wa norĩ si ma tô ãma saze za'ra ĩsimirowasu'u na hã, pi'õ hã aibâ zô si siwa'ru 're ĩhâimana za'ra mono norĩ zama. Tawamhã ta norĩ hã atõmo na 're 'madâ'â za'ra wa'aba mono nherẽ, a norĩ wa'aba zama asimirosa'rata na 're saprĩ za'ra wa'aba mono õ di, ĩsimirowasu'u na ãma 're ĩsaze za'ra wa'aba mono zéb da hã. — Ãne ma tô Zezusi hã tãma wasu'u za'ra, 'Re ĩhâimana u'âsi mono ma da'ãma romhuri'wa norĩ nhib'apito norĩ ma, duré dama rowahutu'wa norĩ ma zama. ");
INSERT INTO xavNT_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Tawamhã Zezusi hã te duré ãne tãma rowasu'u za'ra: — Ãne wa za duré aima ãma romnhimiré'é za'ra wa'wa. Ma'ãpé, ĩ̱wapari pese za'ra wa'aba za. Aibâ hã te 're sãmra, buru tede'wa hã. Tawamhã tiburu ãma ma tô a're, uwa 'ru hã. Te te a're pari, ma tô buru 'wawi wa'ra. Ma tô duré ẽtẽ nhisiwi sada ab're, ĩwa uwa 'rãi watizéb da hã, ĩwa'u zô. Taha pari, 'ri 'rãihâ hã ma duré buru wa'wa 'manha, ĩsipsaihuri norĩ zô, dasipapara rob'madâ'âzéb da hã. Tawamhã ma tô ni'wam norĩ hã sisõ'a ré pisutu za'ra, ĩburu hã te te sô 're 'madâ'â za'ra mono da. Uwa 'ru 'rã hã 're 'rã prédub za'ra mono wapsi, te za te te tãma 're po'o za'ra, buru tede'wai ma hã. Taha pari, te oto mo, buru tede'wa hã darob amoi u, tamomo a'â sãmra da. ");
INSERT INTO xavNT_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Tawamhã oto 'rãi prédu mono wa, ma tô buru tede'wa hã tãma ĩromhuri'wa norĩ hã satõrĩ za'ra tiburu u, uwa 'ru 'rã hã buru 'madâ'â'wa norĩ te te tãma ĩpo'o za'ra zô. ");
INSERT INTO xavNT_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Tawamhã buru u sihutu wamhã, ma tô buru tede'wa te te ĩsatõrĩ za'ra hã siwi waibu, buru 'madâ'â'wa norĩ hã. Tawamhã buru tede'wai ma, romhuri'wa norĩ ma, ma tô rob'manharĩ wasété za'ra. Taha wa, ma tô misi siwi azâ. Ĩhâiba amo ma duré siwi tĩwĩ. Ĩhâiba amo ma duré ẽtẽ na siwi u'a za'ẽtẽ, dâ'â da. ");
INSERT INTO xavNT_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Tawamhã buru tede'wa hã te duré sô satõrĩ za'ra, tãma ĩromhuri'wa norĩ hã, ahâ na. Tawamhã, ta norĩ hã buru u sihutu wamhã, ma duré tãma rob'manharĩ wasété za'ra, buru 'madâ'â'wa norĩ hã. ");
INSERT INTO xavNT_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Tawamhã 'râwi te oto sima rosa'rata, buru tede'wa hã: “Ĩ̱'ra si'aibâ hã te ĩtẽme satõrĩ za'ra wamhã, ãté te za siwi hâiba wazé.” Ãne te sima rosa'rata, buru tede'wa hã. Tawamhã uburé da te tiwi uprosi za'ra wa, te oto ti'ra uptabi hã satõ, tãma ĩburu 'madâ'â'wa norĩ u. ");
INSERT INTO xavNT_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Tawamhã wisi wamhã, buru 'madâ'â'wa norĩ hã te te duré sima sãmri za'ra wamhã, te ãne sima 'mahârâ za'ra: “Õhõta buru tede'wai 'ra hã te wei mo, timama uirĩ na buru tede'wa da hã. Wa te wasiwi wĩrĩ aba, buru hã wate za'ra da.” Ãne na ma tô sima 'mahârâ za'ra, buru 'madâ'â'wa norĩ hã. ");
INSERT INTO xavNT_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","— Tawamhã wisi wi, ma tô siwi ti'â, buru tede'wai 'ra hã. Buru nhiti ma tô siwi waze. Tame ma tô siwi tĩwĩ, buru 'madâ'â'wa norĩ hã. Ãne buru tede'wai 'ra wasu'u 'rãsudu hã. ");
INSERT INTO xavNT_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Tawamhã Zezusi hã te oto sadanharĩ za'ra, 'Re ĩhâimana u'âsi mono ma da'ãma romhuri'wa norĩ nhib'apito norĩ hã, ãne: — Buru tede'wa hã tiburu u apâ wisi wamhã, e marĩ te za tãma 'manharĩ za'ra, tãma ĩburu 'madâ'â'wa norĩ ma hã. ");
INSERT INTO xavNT_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Tawamhã asa te tãma nharĩ za'ra: — Buru tede'wa hã ãma pẽ'ẽzé za'ra ãna, te za dama 'ru za'ra, da te dasiwi uprosi da, aibâ ĩwasété uptabi norĩ hã. Tawamhã te za duré da'apisutu, dama ĩ'umnha hã tãma ĩburu 'madâ'â'wa da hã. Ta norĩ hã te za ĩ'uwaibaba si te te tãma 're po'o za'ra, uwa 'ru 'rã hã, 're 'rã prédub za'ra mono wa. — Ãne ma asa tãma waihu'u za'ra, Zezusihi ma, 'Re ĩhâimana u'âsi mono ma da'ãma romhuri'wa norĩ nhib'apito norĩ hã. ");
INSERT INTO xavNT_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Tawamhã Zezusi hã te oto sina ãma simiré'é ẽtẽ na, ãne: — Oro 'Re ĩhâimana u'âsi mono zadawa wasu'u na rob'ui'éré hã 're sõré za'ra wa'aba mono za, aima waihu'u za'ra wa'aba õ di bété. Ãne ĩbaihâ na rob'ui'éré hã: “Ẽtẽ tomhâpâ wẽ hã 'ri na'ratazéb da hã, wẽ uptabi nherẽ, wasété newa, 'ri'wa norĩ te te aré siwi ĩwẽ'õ hã 'ri na'rata uparizéb da, te oto 're sa'wari u'âsi, pire na. Uburé Danhib'apito hã ma tô ãne hã pisutu, 'ri na'rata uparizéb da, pire na 're ĩsa'wari mono da hã. Taha wa, ãne na wa te ãma 're rosa'rata za'ra mono wamhã, wa ãma 're watob'uzu u'âsi za'ra, wa norĩ hã.” Ãne duréihã wahi'rata nhimi'ui'éré na rowasu'u hã. ");
INSERT INTO xavNT_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","— Ẽtẽ tomhâpâ wẽ hã da te dasiwi ĩwẽ'õ ne, a norĩ wa'wa hã asiwi 're ĩ̱wẽ'õ za'ra wa'aba mono wa, 'Re ĩhâimana u'âsi mono nhib'a'u'wẽ, 're aihâimana u'âsi za'ra wa'aba mono õ di za. Ai'upana wa'aba si te za oto 'Re ĩhâimana u'âsi mono hã da'ãma 're sib'a'uwẽ, ĩsimiroti te te 're ĩ'madâ'â pese za'ra mono norĩ ãma. Tô sena, wa ãne na aima waihu'u za'ra wa'wa. ");
INSERT INTO xavNT_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Duré, ẽtẽ tomhâpâ nhisiwi, zé'a 'manharĩ hã 're rere'e mono wa, 're ĩsipru pese za'ra mono ne, te za ĩ̱wẽ'õ'wa norĩ hã hâ za'ra, 'Re ĩhâimana u'âsi mono hã. Duré ẽtẽ tomhâbâ hã zé'a 'manharĩ nhisiwi 're rere'e mono wa, te te 're ĩpru pese za'ra mono ne, te za 'Re ĩhâimana u'âsi mono wẽ'õ'wa norĩ si hâ za'ra. Ta norĩ ãma hã 're sib'a'uwẽ za'ra mono õ di za. — Ãne ma tô Zezusi hã sina ãma simiré'é, ẽtẽ wasu'u na hã. ");
INSERT INTO xavNT_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Tawamhã sasedoti ĩpire norĩ hã, duré parisezu norĩ hã, Zezusi te te ãma ĩromnhimiré'ézé hã te te wapari za'ra wamhã, ma tô sina waihu'u za'ra, tô õ norĩ udâna te te ãma ĩromnhimiré'é mono na hã. ");
INSERT INTO xavNT_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Taha wa, ma tô aré sima hâiba 'ru za'ra, te te dama 'ru za'ra da, dazazéb 're da te dasiwi sẽrẽ da, Zezusi hã. Tane nherẽ, ma tô dama tipahi za'ra aibâ norĩ hã, Zezusi hã 'Re ĩhâimana u'âsi mono zadawa wasu'u'wa, oto 're ĩmorĩ na da te 're saze za'ra mono wa, da'ahâ na. ");
INSERT INTO xavNT_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Tawamhã Zezusi hã ma tô duré romnhimiré'é na tãma rowasu'u za'ra, parisezu norĩ ma, ãne: ");
INSERT INTO xavNT_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","— 'Re ĩhâimana u'âsi mono, da'ãma 're ĩsib'a'uwẽ mono zém na wa za duré aima ãma romnhimiré'é za'ra wa'wa, ãne. Apito 'ra si'aibâ hã tãma mro wẽ te, tãma ĩrowẽzéb zarina ma tô sima roti, dasa hã te te dama 'manharĩ da, sa'ẽtẽ na, ti'ra mrozém na hã. ");
INSERT INTO xavNT_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Tawamhã ma tô ĩsiré dasaihuri da, da'apisutu. Taha parip si ma tô tãma ĩromhuri'wa norĩ hã satõrĩ za'ra, dazô hãsi da, ĩtẽme dasihutu da, ĩsiré dasaihuri da. Tane nherẽ, ta norĩ hã te te sima rowẽ za'ra õ di, ĩtẽme si'aba'ré da hã, ĩsiré ĩsaihuri da hã aré. ");
INSERT INTO xavNT_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Taha wa, te duré apito, tãma ĩromhuri'wa norĩ hâiba amo hã satõrĩ za'ra, ãne: “Mo oto ai'aba'réi wa'aba, aré sô ĩ̱hârâ 'rata za'ra norĩ zô. Tawamhã ãne te za tãma ĩ̱zadawa wasu'u za'ra wa'wa: ‘Powawẽ norĩ hã, duré powawẽ zapu da te dasima ĩhâipese za'ra hã ma dasiwi simro ni. Uburé ma tô marĩ hã dasiwi 'rã'õtõ ni, dasa da te ĩhurizéb da hã. Taha wa, te za we ĩ̱tẽme ai'aba'réi wa'wa oto, wasiré wasa hã wa te huri da, ĩ̱'ra ĩ̱ma ĩmrozém na.’ Ãne te za ta norĩ ma ĩ̱zadawa wasu'u za'ra wa'wa.” Ãne ma tô apito hã tãma ĩromhuri'wa norĩ ma waihu'u za'ra. Tawamhã apito hã te te sô satõrĩ za'ra wa, te oto sô ai'aba'ré. ");
INSERT INTO xavNT_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","— Tane nherẽ, sô ĩhârâ 'rata za'ra norĩ hã sô simipari za'ra õ di, ĩtẽme si'aba'ré da, ĩsiré saihuri da hã. Taha wa, sô simipari za'ra ãna ma tô ni'wam norĩ hã tiburu u ai'aba'ré, duré tinhimiromhurizéb u hã. ");
INSERT INTO xavNT_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Ni'wam norĩ hã ma tô apito ma romhuri'wa norĩ hã siwi waibu. Te te waibui pari wamhã, ma tô niha tãma rob'manharĩ wasété za'ra. Taha pari, ma uprosi uburé. ");
INSERT INTO xavNT_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Tawamhã apito hã tãma ĩromhuri'wa norĩ, da te ĩ'uprosi wasu'u te te wapari wamhã, ma tô ab'rui pese. Taha wa, tãma da'wapéi'wa norĩ hã ma tô ĩtẽme satõrĩ za'ra, tãma ĩromhuri'wa norĩ, da te tiwi ĩ'uprosi za'ra u. Tawamhã da'wapéi'wa norĩ hã ma tô uprosi, ta norĩ hã. Ma tô duré ta norĩ nhorõwa hã te te 'ri su, 'ri nho'õmo wa, aré tãma 're ĩsimasa mono hã. ");
INSERT INTO xavNT_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Taha pari, ma tô duré sô hâ, tãma ĩromhuri'wa norĩ zô, aimawi norĩ zô. Tawamhã ãne te tãma nharĩ za'ra: “Dasazéb da hã tâibâ ma tô api pari za'ra ni, ĩ̱'ra ĩmrozém na dasa da te ĩhurizéb da hã. Tane nherẽ, sô ĩ̱hârâ 'rata za'ra norĩ hã we si'aba'réi õ di. Ĩbâre ma tô ta norĩ zô rowasédé hã tiwatobro za'ra, sô ĩ̱hârâ za'ra nherẽ, te te ĩ̱wapari za'ra õ wa. ");
INSERT INTO xavNT_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Taha wa, te za oto dazô ĩropéi wa'aba mo 'ri nhi'riti mono bâ, dasai u we danhimroi wa'aba mono da, danhopẽtẽ za'ra wa'aba mono sidâpâsi.” Ãne te satõrĩ za'ra, apito hã. ");
INSERT INTO xavNT_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","— Tawamhã te oto ai'aba'ré, 'ri nhi'riti mono bâ, dazô sõpré mono da. Tawamhã te te danhopẽtẽ za'ra mono sidâpâsi, ma tô te te dazatõrĩ za'ra da'ahâ na, 're ĩdanomro wẽ mono hã, 're ĩdanomro wasété mono norĩ zama. Tawamhã da'ahâ uptabi na ma tô 'ri 're wa'wa nho'u hã dasiwi sitom ni, apito 'ra ĩmrozém na dasai u, dasi'rã'õtõ wa. ");
INSERT INTO xavNT_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","Tawamhã apito hã ma tô datẽme ãzé, dasi'rã'õtõzéb u, te te da'ab'madâ'â da. Datẽme sébré wamhã, ma tô aibâ hã 'madâ'â pese, dasina damro wa, da'uzazé hã te te dame sima 'manherẽ õ wa, ĩhâi wẽ hã. ");
INSERT INTO xavNT_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Tawamhã ãne te sadanha, apito hã: “Ĩ̱siwaihu, e niha bâ ma we tane ré asé, dasina damro wa, da'uzazé hã we dame asima sẽrẽ ãna.” Ãne te sadanha. — Tawamhã aibâ hã te ari'iwi za, niha te te tãma nharĩ waihu'u õ wa, te te tãma ãma upai wa. ");
INSERT INTO xavNT_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Tawamhã apito hã ma tô ãne tãma ĩromhuri'wa norĩ ma nharĩ za'ra: “Ma'ãpé, ã hã aibâ hã asiwi âri aba, asiwi pawasisi aba da, duré asiwi hiwasisi aba da, rob u asiwi mei wa'aba da, robra u. Tame te za oto sina tiwawa, sina pẽ'ẽzé wa. Te za duré 'wasitete, te te oto robzépata za'ẽtẽ wa.” Ãne ma tô apito hã tãma waihu'u za'ra. — Ãne na ma tô Zezusi hã tãma ãma romnhimiré'é za'ra. ");
INSERT INTO xavNT_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Tawamhã Zezusi hã ma tô ãne na timreme na 'rãsutu: — 'Re ĩhâimana u'âsi mono hã da'ahâ uptabi na dazô 're hârâ mono nherẽ, da'umro na si te za da'ãma 're sib'a'uwẽ. — Ãne na ma tô Zezusi hã timreme na tãma 'rãsutu za'ra. ");
INSERT INTO xavNT_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Tawamhã parisezu norĩ hã ma tô ai'aba'ré Zezusihi nhiti, si'rã'õtõ da, a'â. Si'rã'õtõ wamhã, ma tô sima ãma roti za'ra, Zezusi hã te te siwi pibu da, tinhimirowasu'u na te te tãma ãma upa za'ra zô, te te tãma ãma upa za'ra wa, da te dasiwi wẽ'õ da, duré da te dasiwi âri da. ");
INSERT INTO xavNT_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Tawamhã Zezusihi u ma tô 'mazatõrĩ za'ra, tizadawa zapari'wa norĩ hã, apito Erodihi nhimiroti wẽ 'wa norĩ zama. Tawamhã Zezusihi u sihutu wamhã, ãne te siwi sadanha: — Rowahutu'wa, asadawa nhipese õ na 're aihâimana mono zém na hã wa tô aiwaihu'u za'ra ni. Tô sena na te ĩwẽ na si dama 're ĩrowasu'u u'âsi mo, 'Re ĩhâimana u'âsi mono nhimiroti zarina si. Asimiroti hã da te dasiwi 're wẽ'õ za'ra mono nherẽ, te tô õhõ na si dama 're ĩ'aroti u'âsi mo. Duré ni'wam norĩ hã dama pire na 're hâimana za'ra mono nherẽ, aimawi hã aima 're hâimana mono õ di. Aiwapsi te 're dahâimana za'ra, aima hã. ");
INSERT INTO xavNT_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Taha wa, wa za oto wa norĩ hã wasiwi asadanharĩ za'ra ni, ãne. E Roma ãma danhib'apito uptabi ma, wa za rob'uiprazé hã wa te tãma 're po'o za'ra, ĩsimiwada'uri zarina. E 'Re ĩhâimana u'âsi mono ma, wẽ di, ãne hã. E tãma wẽ õ di. Ma'ãpé wama waihu'u za'ra na asimirosa'rada hã, wa te waihu'u za'ra da. — Ãne te siwi sadanha, Zezusi hã te te ãma tãma upa za'ra zô, timreme na hã. ");
INSERT INTO xavNT_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Tawamhã tinhimirosa'rata wasété zarina te te sima ãma ĩroti za'ra zé hã ma tô sina waihu'u, Zezusi hã. Taha wa, ma ãne tãma tizadawa na wa'rãmi za'ra: — A norĩ wa'wa hã te asadawa nhipese na 're aihâimana za'ra wa'aba mo. E marĩ da, te ãne na asiwi ĩ̱zadanharĩ 'wa, ĩ̱mreme na te aima ãma upa za'ra wa'aba da newa, asiwi ĩ̱wẽ'õ wa'aba da. ");
INSERT INTO xavNT_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Tane wamhã, ma'ãpé rob'uiprazé ĩsapotore hã we ĩ̱ma 'mai'âri aba pé, te 'madâ'â da, romanu norĩ nhib'apito ma, da te tãma 're ĩpo'o za'ra mono zéb da si, rob'uiprazé ĩsapotore hã. Taha wa, nima hawi ma rob'uiprazé ĩsapotore hã tãma 'mai'ãwisi ni. ");
INSERT INTO xavNT_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Tawamhã Zezusi hã te te 'madâ'â wamhã, te oto sadanharĩ za'ra: — E 'wai hâibarĩ, rob'uiprazé ĩsapotore na hã. E 'wa sisi ui'éré duré, ãma hã. ");
INSERT INTO xavNT_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Tawamhã asa te tãma nharĩ za'ra: — Ã hã, Roma ãma danhib'apito hâibarĩ, duré taha nhisi ui'éré. Tawamhã Zezusi hã ma duré tãma waihu'u za'ra, ãne: — Taha wa, Roma ãma danhib'apito ma, te za ĩsimiwada'uri zarina, marĩ hã tãma 're ĩpo'o za'ra wa'aba mo apâ, ĩte wa. Tane duré, 'Re ĩhâimana u'âsi mono ma, te za marĩ hã ĩsimiwada'uri zarina si tãma 're ĩsõmri za'ra wa'aba mo apâ, ĩte wa, marĩ hã. — Ãne ma tãma waihu'u za'ra, Zezusi hã. ");
INSERT INTO xavNT_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Tawamhã parisezu norĩ zadawa zapari'wa norĩ hã ãne na te te wapari za'ra wamhã, ma tô ãma titob'uzu za'ra. Tawamhã Zezusihi ãma, marĩ te te 'manharĩ za'ra ãna, ma tô ĩhawi ai'aba'ré, apâ. ");
INSERT INTO xavNT_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Tawamhã sadusezu norĩ hã ma duré ĩtẽme aihutu Zezusihi u, te te siwi sadanharĩ da, tinhimirowasu'u na te te tãma ãma upa za'ra zô. Ta norĩ hã 're dadâ'â za'ra mono wamhã, ab're hawi apâ 're ĩdahâiwa'utu za'ra mono õ na te te dama 're ĩroti za'ra mono. ");
INSERT INTO xavNT_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","Tawamhã, Zezusihi u simasa wamhã, te tãma nharĩ za'ra, ãne: — Rowahutu'wa, duréihã wahi'rada Mozési hã ma tô ãne dama rob'ui'éré, 'Re ĩhâimana u'âsi mono nhimiroti na: “Aibâ hã 'ra õ ré, 're dâ'â za'ra mono wamhã, te za ĩno hã ãma 're mro za'ra, tizédé'aba mro na, 're 'ra za'ra mono da, ĩwasu'u hã si'utõrĩ tõ da, ĩsédé'aba wasu'u hã.” Ãne na Mozésihi nhimi'ui'éré hã, wahi'rata norĩ ma hã. — Ãne ma Zezusihi ma waihu'u za'ra, sadusezu norĩ hã. ");
INSERT INTO xavNT_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Tawamhã Zezusihi ma, te duré rowasu'u za'ra, ãne: — Dasisãnawã si 're ĩhâimana za'ra mono norĩ wasu'u hã wa za oto aima wasu'u za'ra ni. Ta norĩ wasu'u hã wa te waihu'u za'ra da, wa za ãma asadanharĩ za'ra ni za. Dasisãnawã si hã ma tô wasiré 're si'ubumro aré, wasiré zudezu norĩ hã 7 na ĩhâiba za'ra hã, aibâ norĩ hã. Tawamhã ĩpoto'rada hã ma tô timro. Mro nherẽ, ti'ra hã sisõ'a ré te te 'maipoto õ ré, ma tô dârâ. Taha wa, ĩ'uirĩ na ma tô ĩsõsi hã ãma timro tizédé'aba mro na, Mozésihi nhimi'ui'éré zarina. ");
INSERT INTO xavNT_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Tawamhã ĩsõsibi zama ma tô dârâ, 'ra õ ré. Taha wa, ma duré taha nhosi hã ãma timro, tizédé'aba mro na. Tawamhã taha zama ma duré dârâ, ti'ra hã sisa'u te te 'maipoto õ ré. Ãne zarina ma tô uburé ĩdub'rata norĩ hã dâ'â sidâpâsi, nasi ãma timro za'ra aré, sisõwa're're. Tawamhã uburé ma sisarina ai'utõrĩ za'ra, 'mai'ra õ ré. ");
INSERT INTO xavNT_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Tawamhã pi'õ zama ma tô duré dârâ, timro norĩ zarina. ");
INSERT INTO xavNT_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Aibâ norĩ hã 7 na ĩhâiba za'ra hã ma tô pi'õi ãma siparabâsi nasi ãma timro za'ra. Ãne ma tô tãma tiromhâimana za'ra. Tawamhã e 'wai mro uptabi za bété pi'õ hã, ab're hawi 're dahâiwa'utu za'ra mono wamhã. — Ãne te Zezusi hã siwi sadanha, sadusezu norĩ hã. ");
INSERT INTO xavNT_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Tawamhã Zezusi hã asa te tãma nharĩ za'ra: — Ab're hawi apâ 're ĩdahâiwa'utu za'ra mono zé wasu'u na, 'Re ĩhâimana u'âsi mono nhimiroti 'rata na rob'ui'éré hã aima ĩwaihu'u za'ra wa'aba õ zarina, ma tô ãma ĩ'upa za'ra wa'wa, asimirosa'rata na hã. 'Re ĩhâimana u'âsi mono, tiwaihu'u pese na te te 're ĩda'ahâiwa'utu mono zé wasu'u na zama, aima ĩwaihu'u za'ra wa'aba õ zarina, ma tô asimirosa'rata na ãma ĩ'upa za'ra wa'wa. ");
INSERT INTO xavNT_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","'Re ĩhâimana u'âsi mono hã ab're hawi apâ te te 're da'ahâiwa'utu mono wamhã, hâiwa ãma romhuri'wa norĩ ne, te za oto 're dahâimana u'âsi za'ra, dasina 're damro za'ra mono ãna. ");
INSERT INTO xavNT_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","'Re ĩhâimana u'âsi mono hã ab're hawi te te 're ĩda'ahâiwa'utu mono zém na, a norĩ wa'wa hã 're saze za'ra wa'aba mono õ di. E 're sõré za'ra wa'aba mono õ di bété, duréihã 'Re ĩhâimana u'âsi mono mreme na rob'ui'éré hã, wahi'rada Mozésihi ma, ĩsiwasu'uzé hã, ãne na hã: ");
INSERT INTO xavNT_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","“Wa hã Abra'ãhã nhib'apito, wa 're ĩ̱hâimana u'âsi, duré Izatihi nhib'apito, duré Zacoho nhib'apito.” Ãne ma tô 'Re ĩhâimana u'âsi mono hã Abra'ã norĩ uirĩ na nherẽ, Mozésihi ma, siwaihu'u. Wahi'rata norĩ hã dawi 're dâ'â za'ra mono nherẽ, 'Re ĩhâimana u'âsi mono wi, 're dâ'â za'ra mono õ di. Taha wa, ma tô Ĩsib'apito za'ra na siwasu'u. Dâ'â u'âsi 're hâimana za'ra mono 'wa'âhã, Ĩsib'apito za'ra na aré siwasu'u õ di. — Ãne ma tô Zezusi hã Abra'ã norĩ wasu'u hã tãma waihu'u za'ra, sadusezu norĩ ma. ");
INSERT INTO xavNT_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Tawamhã ãne hã da'ahâ uptabi na da te wapari za'ra wa, ma tô ãma tatob'uzu za'ra ni, ĩsimirowasu'u na hã. ");
INSERT INTO xavNT_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Ãne na Zezusi hã te te tãma rowasu'u za'ra wamhã, ari'iwi te oto aimasa, sadusezu norĩ hã, niha te te ãma sada'âbâ waihu'u za'ra õ wa, waihu'u pese uptabi wa, Zezusi hã. Tawamhã parisezu norĩ hã ãne na te te wapari za'ra wamhã, ma tô sitẽme ubumro a'â, Zezusihi u siré si'aba'ré da. ");
INSERT INTO xavNT_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Tawamhã 'Re ĩhâimana u'âsi mono nhimiroti 'rata na dama rowahutu'wa hã tô parisezu norĩ siré hã ma tô Zezusi hã sadanha, te te tãma ãma upa zô, te te pibu da, ãne: ");
INSERT INTO xavNT_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","— Rowahutu'wa, e ma hã bété, danhipai u ĩpire uptabi hã, 'Re ĩhâimana u'âsi mono nhimiroti na Mozési te te ãma ĩrob'ui'éré hã, ĩbaihâ na hã. ");
INSERT INTO xavNT_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Tawamhã Zezusi hã asa te tãma tinha, ãne: — 'Re ĩhâimana u'âsi mono nhimiroti, danhipai u ĩpire uptabi hã, ãne: “'Re ĩhâimana u'âsi mono hã, Asib'apito za'ra wa'wa hã 're morĩ wa, te za asiwi 're ĩsawi pese za'ra wa'aba mo, sena na. Taha zarina, te za ĩsimiroti na ãma 're ĩrosa'rata u'âsi za'ra wa'aba mo. Taha zarina, te za duré asimi'ẽ na tãma 're ĩromhuri u'âsi za'ra wa'aba mo.” ");
INSERT INTO xavNT_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Ãne 'Re ĩhâimana u'âsi mono nhimiroti, danhipai u ĩpire uptabi wasu'u hã. ");
INSERT INTO xavNT_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Duré 'Re ĩhâimana u'âsi mono nhimiroti amo hã, aiwa ĩpire uptabi hã, ãne: “Te za 're ĩdazawi pese za'ra wa'aba mo, uburé. Marĩ ĩwẽ zô asima 're asõpré wa'aba mono ne, te za duré uburé dama zama sô 're asõpré wa'aba mo, ĩwẽ zô.” Ãne ĩsimiroti amo hã ĩpire uptabi hã, Mozési te te ãma ĩrob'ui'érézé hã. ");
INSERT INTO xavNT_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Ã norĩ si, 'Re ĩhâimana u'âsi mono nhimiroti ma, pire uptabi zahuré di. Uburé 'Re ĩhâimana u'âsi mono nhimiroti na Mozési te te ãma ĩ'arob'ui'éré mono hã duré ĩsadawa wasu'u 'rata 'wa norĩ zama te te ãma 're ĩrob'ui'éré za'ra mono zé hã, e marĩ te ãma wasu'u za'ra, ã norĩ hã. Tô õ norĩ na si te ãma rowasu'u za'ra, 'Re ĩhâimana u'âsi mono, da te dasiwi 're ĩsawi pese za'ra mono zéb da hã, duré 're ĩdasisawi pese za'ra mono zéb da hã. — Ãne ma tô Zezusi hã 'Re ĩhâimana u'âsi mono nhimiroti na dama rowahutu'wai ma waihu'u. ");
INSERT INTO xavNT_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Tawamhã parisezu norĩ hã zahadu siré hâimana za'ra ré, te Zezusi hã sadanharĩ za'ra, ãne: ");
INSERT INTO xavNT_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","— E niha asimirosa'rata za'ra wa'wa hã Danho'reptui'wa da, 'Re ĩhâimana u'âsi mono te te ĩpisutu na, we datẽme ĩmorĩ na hã. E 'wa sihudu na ma bété a norĩ wa'wa hã ãma ĩwaihu'u za'ra wa'wa. Tawamhã asa te tãma rowasu'u za'ra, parisezu norĩ hã: — Apito Dawihi nhihudu te za, u, 're mo. — Ãne te duré asa tãma nharĩ za'ra. ");
INSERT INTO xavNT_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Tawamhã Zezusi te duré tãma rowasu'u za'ra: — Tane wamhã, ma'ãpé ãma rosa'rata pese za'ra wa'aba, ãne na hã. Duréihã apito Dawi hã ma tô tinhib'apito na sisi, Danho'reptui'wa da, 'Re ĩhâimana u'âsi mono te te ĩpisudu hã. 'Re ĩhâimana u'âsi mono pẽ'ẽzani nhimipawaptobzéb zarina, ma tô tinhib'apito na sisi. Oro Dawihi mreme wasu'u na rob'ui'éré hã, ãne hã nomro za: ");
INSERT INTO xavNT_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","“'Re ĩhâimana u'âsi mono, ma tô Ĩ̱nhib'apito ma tinha, ãne: ‘Ĩ̱'rata te za 're asãmra mo ĩ̱nhimire niwĩ, dama aipire na ĩ̱siré 're aihâimana u'âsi mono da. Asitob'ru norĩ nhiptetezé hã wa za te tiwi 're a'uprosi, wapu na aima 're hâimana za'ra mono da oto, duré aima sib'uwa na 're hâimana za'ra mono da oto.’ Ãne ma tô tãma waihu'u.” Ãne apito Dawihi mreme wasu'u na rob'ui'éré hã. ");
INSERT INTO xavNT_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Dawi hã tinhib'apito na te te sisi nherẽ, e niha te za ĩsihudu si 're hâimana, Danho'reptui'wa da, 'Re ĩhâimana u'âsi mono te te ĩpisudu hã. Ma'ãpé ãma rosa'rata pese za'ra wa'aba, waihu'u za'ra wa'aba da. — Ãne na te Zezusi hã tãma rowasu'u za'ra, parisezu norĩ ma. ");
INSERT INTO xavNT_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Tawamhã ni'wa hã te te ãma sada'âbâ waihu'u õ di oto, Zezusihi zada, 're ĩsiwamnhasi za'ra mono norĩ hã, parisezu norĩ hã. Taha wa, Zezusi hã timreme na te te tãma ãma upa za'ra zô, te te siwi sadanharĩ waihu'u za'ra õ di oto ta norĩ hã, te te sina mreme wazéb za'ra wa oto. ");
INSERT INTO xavNT_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Tawamhã Zezusi hã ma tô dama rowasu'u, ĩsiré 're ĩwanomro mono norĩ ma zama, ãne: ");
INSERT INTO xavNT_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","— 'Re ĩhâimana u'âsi mono nhimiroti 'rata na rob'ui'éré na dama rowahutu'wa norĩ hã duré parisezu norĩ hã dama pire za'ra di, 'Re ĩhâimana u'âsi mono nhimiroti zarina Mozési te te ãma ĩrob'ui'érézém na te te dama 're ĩrowasu'u za'ra mono zéb da hã. ");
INSERT INTO xavNT_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Taha wa, parisezu norĩ nhimiroti hã te za 're ĩwapari pese za'ra wa'aba mo, ãma 're anomro aba mono da. Tane nherẽ, 're ĩhâimana za'ra mono zéb zarina, ĩsine 're aihâimana za'ra wa'aba mono õ di za. E marĩ wa. Te te dama 're ĩroti za'ra mono zém na si 're sõpré mono õ wa, ta norĩ hã. ");
INSERT INTO xavNT_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Danhoihi waptob ãna, marĩ ĩpire uptabi hã da te 're 'wasari mono da, da te dama 're ĩromnhibu za'ra mono ne, te ta norĩ hã tinhimiroti na zama te te dama 're roti u'âsi za'ra, 'Re ĩhâimana u'âsi mono nhimiroti upana, taha na si 're danomro mono da, dama pire uptabi nherẽ, da te dasina 're ĩ'uwaimrami za'ra mono zéb da hã. Tane nherẽ, ta norĩ hã te te 're dapawaptob za'ra mono õ di, ãma 're ĩdanomro wẽ mono zéb da hã. ");
INSERT INTO xavNT_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Taré da te 're 'madâ'â wẽ za'ra mono da, te marĩ hã te te 're 'manharĩ za'ra, danho'a. Powawẽ hâ 'manharĩ hã 'Re ĩhâimana u'âsi mono nhimiroti ui'éré na ĩbaihâ nhemezébre hã ĩsa'ẽtẽ uptabi na si te ãma 're si'uihâ wasisi za'ra, tipaihi wib zama, 're nomro wẽ mono newa, da te 're 'madâ'â wẽ za'ra mono da. Taha da, te duré ti'uza hâpa za'ru pa ré na 're si'uza za'ra. ");
INSERT INTO xavNT_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Te duré te te sima 're pisutu za'ra, dama ĩpire norĩ simasisizém na si 're si'ubumroi mono da, dasa da te 're huri mono sidâpâsi, duré rowahutuzé mono bâ, 'ri hã 're ĩsimasa mono zéb 'remhã. ");
INSERT INTO xavNT_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Te duré te te sima 're wẽ za'ra, dama ĩpire norĩ hã damreme ĩpire na da te 're ĩsawi za'ra mono ne, dahâimana prédup sina da te 're sawi za'ra mono da, da'ahâ na 'ri nhi'riti wa, da te dasima 're ĩrowede za'ra mono zéb ãma hã. Te duré te te sima 're wẽ za'ra, da te 're sawi za'ra mono wamhã, rowahutu'wa na da te 're sisi za'ra mono sina, da te 're sawi za'ra mono da, dama 're ĩdapire za'ra mono norĩ 'mahârâzém na. Ãne te ta norĩ hã uburé marĩ hã te te sima 're wẽ za'ra, dama ĩpire zarina, da te 're 'madâ'â wẽ za'ra mono da. ");
INSERT INTO xavNT_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Tane nherẽ, te a norĩ wa'wa hã simisutu asisãnawã 're anomro aba mo, asiré ĩsazei'wai wa. Duré misire Asib'apito wa'wa hã. Taha wa, “rowahutu'wa” na dama aiwaptẽrẽ pire na da te 're asisi za'ra wa'aba mono da, 're asi'madâ'â ze za'ra wa'aba mono õ di za, a norĩ wa'wa hã. ");
INSERT INTO xavNT_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Dawaptẽrẽ pire wẽ te, aimama za'ra wa'aba na 're danhisi za'ra wa'aba mono õ di za. E marĩ wa. Misire te Aimama za'ra wa'wa hã 're hâimana hâiwa ãma, siwaprosi. ");
INSERT INTO xavNT_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Wa hã misire Asib'apito za'ra wa'wa hã wa 're ĩ̱hâimana, 'Re ĩhâimana u'âsi mono, ĩ̱wétési te te ĩ̱pisutu wa, Danho'reptui'wa da. Taha wa, 're asi'madâ'â ze za'ra wa'aba mono õ di za, danhib'apito na da te 're ĩ'asisi za'ra wa'aba mono zéb da hã. ");
INSERT INTO xavNT_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Asiré norĩ ma ai'maipire wa'aba da, asina 'mairob'ruiwapari aba wamhã, te za 're ĩ'maipawaptob u'âsi aba mo, marĩ zô 're ai'manhimnhasi aba mono ãna. ");
INSERT INTO xavNT_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Ni'wam norĩ hã pire na 'râwi sina 're sõpré mono wamhã, 'Re ĩhâimana u'âsi mono si te za tãma pisutu za'ra, wapu na dama 're hâimana za'ra mono da oto. Duré, ni'wam norĩ hã pire na 'râwi 're si'madâ'â za'ra mono õ wamhã, ta norĩ ma si te za pisutu za'ra, pire na oto dama 're hâimana za'ra mono da. — Ãne ma tô Zezusi hã dama waihu'u, ĩsiré 're ĩwanomro mono norĩ ma zama. ");
INSERT INTO xavNT_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","14","Tawamhã parisezu norĩ ma, te oto rowasu'u za'ra Zezusi hã, ãne: — Parisezu norĩ, duré dama rowahutu'wa norĩ, aihâimana uptabi õ na dama 're aihâimana za'ra wa'aba mono wa, aima 're ropipa uptabi za'ra wa'aba mono di za. 'Ridawa hã 're danhisisi tõ mono da, da te dawi 're ĩsitob za'ra mono ne, te a norĩ wa'wa hã dawi 're ĩsawi za'ra wa'aba mo, 'Re ĩhâimana u'âsi mono, da'ãma 're ĩsib'a'uwẽ mono zéb u 're danomro tõ mono da. A norĩ wa'aba zama te 'Re ĩhâimana u'âsi mono wi 're asihâiba zawi za'ra wa'aba mo, ai'ãma 're sib'a'uwẽ za'ra wa'aba mono tõ da. ");
INSERT INTO xavNT_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","— Parisezu norĩ, duré dama rowahutu'wa norĩ, a norĩ wa'aba ma, aima 're ropipa uptabi za'ra wa'aba mono di za. Ma tô datẽme 're ĩropéi wa'aba mo daro mono bâ, dama 're rowasu'u za'ra wa'aba mono da, asimirowasu'u na da te 're asaze za'ra wa'aba mono da. Tawamhã ni'wam norĩ hã asiniwĩ 're sipizari za'ra wa'aba mono wamhã, 're anomro wasété aba mono zéb zarina, ma tô 're hâimana wasété uptabi za'ra, asimiroti wasété aba zarina. Taha wa, ropipa ãma 'Re ĩhâimana u'âsi mono te te 're aihâ za'ra wa'aba mono zém nhipai u, te za te te 're hâ za'ra za'ẽtẽ, ta norĩ hã. ");
INSERT INTO xavNT_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","— A norĩ wa'aba ma, aima 're ropipa uptabi za'ra wa'aba mono di za. E ni'wa hã tob'a nherẽ, te za dazaprõni wẽ. Mare di. Tane te duré a norĩ wa'wa hã roti senai'õ na dama 're ĩroti wasété za'ra wa'aba mo, 'Re ĩhâimana u'âsi mono nhimiroti hã sena na waihu'u za'ra wa'aba õ wa. Ãne te dama 're ĩroti wasété za'ra wa'aba mo: “Ãté ni'wam norĩ hã te za marĩ na te te dama 're ropisutu za'ra. Tawamhã ãté tô sena te te dama 're ĩropisutu za'ra mono zém na, da te 're saze za'ra mono da, te za 'Re ĩhâimana u'âsi mono nhorõwa nhisi hã te te ãma dama 're waptob za'ra, tinhimiropisutu me. Ãne na te te dama ãma 're uwaimrami za'ra mono õ nherẽ, 'Re ĩhâimana u'âsi mono hã te te 're hâ za'ra mono õ di za. Tane nherẽ, ni'wam norĩ hã marĩ na te te dama 're ropisutu za'ra mono wamhã, oru 'manharĩ hã ẽtẽ'ubuzi pré 'manharĩ hã, 'Re ĩhâimana u'âsi mono nhorõwa 're, 're ĩsimasa mono na te te dama 're rowasu'u za'ra mono nherẽ, te te dama ãma 're uwaimrami za'ra mono õ wamhã, te za te te 're hâ za'ra, 'Re ĩhâimana u'âsi mono hã.” Ãne te ai'rã ahâ na dama 're ĩroti za'ra wa'aba mo, tô senai'õ na. ");
INSERT INTO xavNT_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","E niha waihu'u za'ra wa'aba õ di bété, 'Re ĩhâimana u'âsi mono nhimiroti hã. Datob'a na 're ĩdanomro mono ne, te 're anomro aba mo. Ẽtẽ'ubuzi pré 'manharĩ hã 'ri 're wa'wa 'Re ĩhâimana u'âsi mono nhorõwa ãma 're simasa mono wa, tãma sawi di, oru 'manharĩ hã. Oru 'manharĩ hã ĩsõrõwa ãma 're simasa mono õ 'wa'âhã, aré tãma sawi õ di. Taha wa, 'ri hã 'Re ĩhâimana u'âsi mono ãma 're ĩdawata za'ra mono zé hã oru 'manharĩ, ĩwa 're ĩsimasa mono zawi nhipai u, sawi uptabi di tãma, 'ri hã. Taha wa, 'Re ĩhâimana u'âsi mono nhorõwa nhisi na zama taré dama 're dasiwaptob za'ra mono õ di za. E ãne hã asima waihu'u za'ra wa'aba ã bâ. ");
INSERT INTO xavNT_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Ãne na te duré dama 're ĩroti wasété za'ra wa'aba mo: “Ni'wa hã marĩ na te te dama 're ropisutu mono wamhã, 'Re ĩhâimana u'âsi mono nhorõwa ãma, tãma danhoprubzé nomrizém nhisi na wedeza ne nhisi na te te dama ãma 're waptob za'ra mono wamhã, duré te te dama ãma 're uwaimrami za'ra mono õ wamhã, tane nherẽ, 'Re ĩhâimana u'âsi mono hã te te azâri õ di za. Tane nherẽ, ni'wa hã tãma danhoprubzé nomrizém nhisiwi, tinhoprubzé te te ĩhiri nhisi na dama ãma 're siwaptob za'ra mono wamhã, duré te te dama ãma 're uwaimrami za'ra mono õ wamhã, tawapsi te za azâ, 'Re ĩhâimana u'âsi mono hã.” Ãne te duré siwa'ru dama 're ĩroti za'ra wa'aba mo, tô senai'õ na. ");
INSERT INTO xavNT_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","E niha waihu'u za'ra wa'aba õ di bété, 'Re ĩhâimana u'âsi mono nhimiroti hã. Datob'a na 're ĩdanomro mono ne, te 're anomro aba mo. Danhoprubzé hã tãma danhoprubzé nomrizém nhisiwi, da te tãma 're ĩsa'ra mono zé hã 'Re ĩhâimana u'âsi mono ma, sawi di. Tane nherẽ, tãma 're ĩdanhoprub za'ra mono zé hã ĩsõrõwa ãma tãma danhoprubzé nomrizém nhisiwi 're simi'wara mono õ 'wa'âhã, aré tãma sawi prã ti, 'Re ĩhâimana u'âsi mono ma hã. Taha wa, tãma danhoprubzé nomrizé hã tãma 're ĩdanhoprub za'ra mono zéb zawi nhipai u, tãma sawi uptabi di. E ãne hã asima waihu'u za'ra wa'aba õ di bété. ");
INSERT INTO xavNT_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Taha wa, ni'wam norĩ hã 'Re ĩhâimana u'âsi mono ma, danhoprubzé nomrizém nhisi na dama ãma 're siwaptob za'ra mono wamhã, taha nhisi zarina te duré uburé ĩsisiwi danhoprubzém nhisi na zama dama ãma 're siwaptob za'ra. ");
INSERT INTO xavNT_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Duré ni'wam norĩ hã 'Re ĩhâimana u'âsi mono nhorõwa nhisi na dama ãma 're siwaptob za'ra mono wamhã, taha nhisi zarina te duré ĩwa 're ĩsãmra mono nhisi na 're siwaptob za'ra, 'Re ĩhâimana u'âsi mono nhisi na. ");
INSERT INTO xavNT_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Duré ni'wam norĩ hã hâiwa nhisi na dama 're siwaptob za'ra mono wamhã, taha nhisi zarina te duré 'Re ĩhâimana u'âsi mono, pire na te te 're ĩda'ab'madâ'â mono zém nhisi na dama ãma 're siwaptob za'ra, ĩwa 're ĩsãmra mono nhisi na zama, tô õhõ nhisi na. ");
INSERT INTO xavNT_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","— Parisezu norĩ, duré dama rowahutu'wa norĩ, aihâimana uptabi õ na dama 're aihâimana za'ra wa'aba mono wa, aima 're ropipa uptabi za'ra wa'aba mono di za. 'Re ĩhâimana u'âsi mono nhimiroti 'rada hã taha ma, tãma ĩpire prã si te 're ĩ'madâ'â pese za'ra wa'aba mo. Wesuirã ĩsu zadazei mono hã ma tô 'Re ĩhâimana u'âsi mono ma, ĩsimiroti 'rata zarina, tãma 're ĩpo'o za'ra wa'aba mo, syry na, oterã na dasai wazarizém nhisi hã, duré wesuirã ze, duré cominhu. Tane nherẽ, ĩsimiroti pire na Mozési te te ãma ĩ'arob'ui'éré mono hã 're 'madâ'â za'ra wa'aba mono õ di, ĩsarina si dama 're ĩrob'manharĩ wẽ za'ra wa'aba mono zéb da hã, duré da'ãma 're aipẽ'ẽzé za'ra wa'aba mono zéb da hã, duré 'Re ĩhâimana u'âsi mono wi, 're aipizari za'ra wa'aba mono ãna 're anomro aba mono zéb da hã. Ãne hã ĩsimiroti ĩpire prã norĩ zu, 're 'madâ'â za'ra wa'aba mono 'wa'âhã, te aré tô sena aihâimanazém na asina tãma 're ĩ'uwaimrami za'ra wa'aba mo, 'Re ĩhâimana u'âsi mono ma. ");
INSERT INTO xavNT_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","E ĩtob'a hã simizaprõni wẽ bâ. Mare di. Tane te duré a norĩ wa'wa hã roti senai'õ na dama 're ĩroti wasété u'âsi za'ra wa'aba mo, 'Re ĩhâimana u'âsi mono nhimiroti hã sena na aima waihu'u pese za'ra wa'aba õ wa. Ĩsimiroti pire norĩ hã 're 'madâ'â za'ra wa'aba mono õ nherẽ, ĩsimiroti ĩpire prã norĩ si, 're ĩ'madâ'â pese za'ra wa'aba mono zéb da si, te 're asiwasutu u'âsi za'ra wa'aba mo. ");
INSERT INTO xavNT_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","— Parisezu norĩ, duré dama rowahutu'wa norĩ, aihâimana uptabi õ na dama 're aihâimana za'ra wa'aba mono wa, aima 're ropipa uptabi za'ra wa'aba mono di za. Ãne na wa za aima ãma romnhimiré'é za'ra wa'wa: Hâsizé hã duré pratu hã ĩmana wawip si, da te 're upsõ za'ra mono wamhã, ĩwa'wamhã wasété di, zahadu upto wa. Tane, a norĩ wa'wa hã 're anomro wẽ wa'aba mono newa, da te 're ai'madâ'â wẽ za'ra wa'aba mono da, te 'Re ĩhâimana u'âsi mono nhimiroti ĩpire prã norĩ si 're ĩ'madâ'â pese za'ra wa'aba mo, danho'a. Tane nherẽ, aipẽ'ẽ 'remhã asimirosa'rata wasété na te zahadu ĩré 're aihâimana u'âsi za'ra wa'aba mo. Te duré danhibrob na si 're ĩda'ruiwapari za'ra wa'aba mo. Aihâimana uptabi õ zarina, te duré marĩ na dawi 're asipsaihuri za'ra wa'aba mo. ");
INSERT INTO xavNT_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Parisezu norĩ, datob'a ne 're ĩ'aihâimana za'ra wa'aba mono norĩ, ma'ãpé aihâimana wasété za'ra wa'aba zé hã rẽme pese za'ra wa'aba, danhimihâsizé wa'wa hã upto wa, da te 're ĩ'upsõ za'ra mono ne. Tawapsi te za oto 're anomro wẽ wa'aba mono zém na sena na da te 're aiwaihu'u za'ra wa'wa. ");
INSERT INTO xavNT_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","28","— Parisezu norĩ, duré dama rowahutu'wa norĩ, aihâimana uptabi õ na dama 're aihâimana za'ra wa'aba mono wa, aima 're ropipa uptabi za'ra wa'aba mono di za. Ãne na wa za duré aima ãma romnhimiré'é za'ra wa'wa: Adâ'â 'ru hã ĩmana wawimhã te za a ni, ĩ'madâ'â ze zéb da hã. Tane nherẽ, 're ĩdadâ'â za'ra mono norĩ hi hã te ĩwa 're simi'wara u'âsi ab're 're, dahâiba 'ro zama. Ĩwasété si te ĩwa 're simi'wara, ab're 'remhã. Tane duré, a norĩ wa'wa hã 're aihâimana wẽ za'ra wa'aba mono newa, te da te 're ai'madâ'â wẽ za'ra wa'wa, sõ'awim na hã. Tane nherẽ, aipẽ'ẽ 'remhã aiwasété uptabi na te ĩré 're aihâimana za'ra wa'aba mo. Aihâimana uptabi õ zéb zarina si, te dama 're anomro aba mo. ");
INSERT INTO xavNT_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","— Parisezu norĩ, duré dama rowahutu'wa norĩ, aihâimana uptabi õ na dama 're aihâimana za'ra wa'aba mono wa, aima 're ropipa uptabi za'ra wa'aba mono di za. A norĩ wa'wa hã duréihã 'Re ĩhâimana u'âsi mono zadawa wasu'u 'rata 'wa norĩ nhimirowasu'u hã aima 're wẽ uptabi za'ra wa'aba mono newa, ma tô ta norĩ 'ru na marĩ hã 're ĩ'manharĩ za'ra wa'aba mo, ĩ'madâ'â ze zéb da hã, 'Re ĩhâimana u'âsi mono nhimiroti 'madâ'â pese 'wa norĩ 'ru na hã. ");
INSERT INTO xavNT_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Asina 're aiwata za'ra wa'aba mono sina, te duré ãne dama 're asiwasu'u za'ra wa'aba mo: “Wa norĩ hã wahi'rata norĩ siré 're wahâimana za'ra mono 'wa'âhã, 'Re ĩhâimana u'âsi mono zadawa wasu'u 'rata 'wa norĩ hã wa te aré 're simroi mono õ di, ĩsiré za'ra.” Ãne te dama 're asiwasu'u za'ra wa'aba mo. ");
INSERT INTO xavNT_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","E marĩ te bété aima wasu'u za'ra wa'wa, 'Re ĩhâimana u'âsi mono zadawa wasu'u 'rata 'wa pãrĩ'wa norĩ nhihudu na dama 're asiwasu'u za'ra wa'aba mono zé hã. Ĩsine marĩ ĩwasété si 're ĩ'manharĩ za'ra wa'aba mono zé, te aima wasu'u za'ra wa'wa. ");
INSERT INTO xavNT_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Taha wa, aihi'rata norĩ te te 're ĩrob'manharĩ na'rata wasété za'ra mono zéb zarina, 're anomro aba mono tô, asima ãma 're sa'ẽtẽ za'ra wa'aba mono da, aima wẽ za'ra wa'aba ze te bâ. ");
INSERT INTO xavNT_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Parisezu norĩ, a norĩ wa'wa hã wahi nhipãrĩ pese ne, te 're anomro aba mo. E ropipa u, 'Re ĩhâimana u'âsi mono te te 're asatõrĩ za'ra wa'aba mono zém na ĩsimihâzé wi, tiwi 're aiwairébé aba mono da bâ. ");
INSERT INTO xavNT_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Ni'wam norĩ hã wa za oto te 're satõrĩ za'ra, atẽme 're nomro aba mono da, Ĩ̱mama 'Re ĩhâimana u'âsi mono hã te te aima 're sadawa wasu'u za'ra wa'aba mono da, ĩsimiroti na te te aima 're rowahutu za'ra wa'aba mono da, ãma 're anomro wẽ wa'aba mono da oto. Tane nherẽ, ĩ̱zadawa para õ nherẽ, te za 're ĩsimroi wa'aba mo ta norĩ hã, 'Re ĩhâimana u'âsi mono zadawa wasu'u'wa norĩ hã. Te za duré dama 're ĩ'ru za'ra wa'aba mo, wedepo'o nhonhi'rãmi na hâiwi da te 're sasõmri za'ra mono da, 're dâ'â za'ra mono da, hâiwi. Rowahutuzéb 're, te za duré 're ĩhâ za'ra wa'aba mo, powawẽ hâiwaré na. 'Ri wa'õtõ mono bâ te za duré sô 're anomro aba mo, 'Re ĩhâimana u'âsi mono zadawa wasu'u'wa norĩ zô, tãma 're rob'manharĩ wasété za'ra wa'aba mono da, ta norĩ ma zama. ");
INSERT INTO xavNT_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Duréihã aihi'rata 'wa hã ma tô Abé hã tĩwĩ, marĩ te te 'manharĩ wasété õ nherẽ. Ta hawim haré, ma tô aihi'rata norĩ hã te te 're danhimro za'ra da'ahâ na, 're danomro wasété mono õ nherẽ. Daza'u si ma duré Zacaria hã siwi tĩwĩ. Ta hã Baratizaha 'ra, 'Re ĩhâimana u'âsi mono ma da'ãma romhuri'wa. 'Re ĩhâimana u'âsi mono nhorõwa ãma 'ri 'wawi wa'ra 're, tãma danhoprubzé nomrizéb 'rata te te tãma romhuri ré, ma tô wĩrĩ ni, wedeza ne 'rata. Ãne ma tô aihi'rata norĩ hã da'ahâ na te te 're danhimro, 'Re ĩhâimana u'âsi mono nhimiroti si te te 're 'madâ'â pese za'ra mono nherẽ, ta norĩ hã. Ta norĩ ne, te duré a norĩ wa'wa hã dama 're ĩrob'manharĩ wasété za'ra wa'aba mo. Taha wa, wa hã wa za aiwasédé hã te ai'ãma 're sa'ra wa'wa, uburé aihi'rata norĩ te te 're ĩdanhimroi mono zéb zarina. Taha wa, te za te te 're aihâ za'ra za'ẽtẽ za'ra wa'wa, 'Re ĩhâimana u'âsi mono hã. ");
INSERT INTO xavNT_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Ãne hã wa tô sena, aima waihu'u za'ra wa'wa. 'Re ĩhâimana u'âsi mono hã te za tô te te 're aihâ za'ra za'ẽtẽ 'wa, nimosi ĩ'aipoto té wa'aba mono hã ĩ'aihâimana za'ra wa'wa hã, ãne na dama 're ĩrob'manharĩ wasété za'ra wa'aba mono zéb zarina, aihi'rata norĩ nhipãrĩ zarina zama. — Ãne ma tô Zezusi hã parisezu norĩ ãma simiré'é za'ra, ĩhi'rata norĩ na. ");
INSERT INTO xavNT_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Tawamhã Zezusi te duré dama tinha, ãne: — Zeruzarẽ ãma 're ai'ubumroi wa'aba mono norĩ ãma, ai'ãma ĩ̱pẽ'ẽzé za'ra wa'aba di. Aihi'rata norĩ hã ma tô 'Re ĩhâimana u'âsi mono zadawa wasu'u 'rata 'wa norĩ hã te te 're simroi u'âsi. Datẽme te te 're ĩsatõrĩ za'ra mono norĩ zama, te duré te te 're simroi u'âsi, ẽtẽ na. Si'a hã ti'ra zawi te, 're ĩpapo za'ra mono ne, wa aré te ĩ̱sima 're aiwẽ u'âsi za'ra wa'wa, ĩ̱sitẽme te 're ai'awaibui wa'aba mono da. Tane nherẽ, asima 're ĩ̱wẽ za'ra wa'aba mono õ di asa. ");
INSERT INTO xavNT_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Taha wa, tinhorõwa hã te za oto tirẽ, 'Re ĩhâimana u'âsi mono hã, ãma 're ĩ'aiwata za'ra wa'aba mono zé hã. Baba na te za oto 're sa, 'ri 'rãihâ hã. Ma'ãpé ãne na ĩ̱zadaihu'u za'ra wa'aba. ");
INSERT INTO xavNT_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Duré a norĩ wa'wa hã ĩ̱hâiba 'madâ'â na sahu za'ra wa'aba õ di za, a'â. Niwapsi te za duré ĩ̱hâiba 'madâ'â za'ra wa'wa, ãne na ĩ̱waihu'u za'ra wa'aba wapsi: “Zezusi hã, ta hã 'Re ĩhâimana u'âsi mono zadawa para we ĩmorĩ ti'ai u, Danho'reptui'wa da. Taha wa, ĩwẽ si te te tãma 're anhomri u'âsi, Ĩmama hã.” Ãne na aipẽ'ẽ 're ĩ̱waihu'u za'ra wa'aba wapsi, te za ĩ̱hâiba 'madâ'â na duré ĩsahu za'ra wa'wa. Ãne ma tô Zezusi hã dama siwaihu'u. ");
INSERT INTO xavNT_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Tawamhã wa norĩ hã wa tô wawairébé ni, Zezusihi siré, 'ri 'rãihâ hawi, 'Re ĩhâimana u'âsi mono ãma 're ĩdawata za'ra mono zém hawi. Aré oto morĩ da, ma rob u watobro, Zezusi hã. Tane nherẽ, wa norĩ hã ĩsiré 're ĩwanomro mono norĩ hã wa tô 'râwi ĩtẽme aimasam ni, 'Re ĩhâimana u'âsi mono nhorõwa hã te te wama wasu'u za'ra da, uburé 'ri 'wawi wa'ra 're, 'ri, 're ĩsimasa mono zama. ");
INSERT INTO xavNT_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Tawamhã Zezusi te wama nharĩ za'ra, ãne: — Ãhãta tô 'ri hã wẽ na 're simasa mono ré, te ĩ'madâ'â za'ra wa'wa. Tane nherẽ, niwapsi te za dasiwi pru pese ni, ẽtẽ na 'ri hã. Tawamhã misi si te za oto simi'wara, ẽne hã. Sisisiwi 'manomro waihu'u õ di za oto, ẽne hã. Tâibâ za oto. Tô sena, wa ãne hã aima waihu'u za'ra wa'wa. — Ãne ma tô Zezusi hã wama waihu'u sirõmo za'ra, ĩsiré 're ĩwanomro mono norĩ ma. ");
INSERT INTO xavNT_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Tawamhã Zezusi hã te oto nhamra, Oriwera na ẽtẽ 'rãihâ nhisi ãma. Sahâ na sãmra wamhã, wa tô 'râwi ĩtẽme ubumro ni Zezusihi u, ĩsiré 're ĩwanomro mono norĩ hã, wahâiba pisutu wa te wasiwi sadanharĩ za'ra da, ãne: — E niwa te za ãne hã ãma tiromhâiba, 'ri nhamrazéb da hã. Ma'ãpé wama waihu'u za'ra na, marĩ ĩwatobrozé hã, ĩsõwa wa te ãma waihu'u sirõmo za'ra da. Duré e marĩ te za watobro, apâ we aimorĩzéb da hã, wa te ãma ĩwaihu'u sirõmo za'ra zéb da hã, duré rob'rãsutuzéb u hã bâdâ, ĩwa ĩwaptã'ãzéb da hã. — Ãne wa tô wasiwi sadanharĩ ni, Zezusi hã. ");
INSERT INTO xavNT_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","5","Tawamhã Zezusi hã te ãne na asa wama rowasu'u za'ra: — Ni'wam norĩ hã te za sadawa nhipese na sisarina datẽme 're nomro, ahâ na. Wa hã newa, te za taré ĩ̱nhisi na dama 're siwasu'u za'ra, Cristu na, Danho'reptui'wa na. Tawamhã da'ahâ na te za ta norĩ ãma da te 're sasõmri za'ra, tô sena newa, dama 're ĩsiwasu'u za'ra mono zé hã. Taha wa, te za a norĩ wa'wa hã aihâimana nhimiza'rese, 're aihâimana za'ra wa'aba mo, sadawa nhipese sina, datẽme 're ĩnomro mono norĩ ãma, 're sasõmri za'ra wa'aba mono tõ da. ");
INSERT INTO xavNT_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","'Re dasi'wapé za'ra mono wa, da te dasina 're ĩropupu'u za'ra mono zé hã te za 're ĩwapari za'ra wa'aba mo, romhâ na 're ĩdasi'wapé za'ra mono norĩ wasu'u zama. Ãne hã 're wapari za'ra wa'aba mono wamhã, tãma 're aipahi za'ra wa'aba mono õ di za, dasi'wapéi ma hã. Dasi'wapé te za tô dazada 're wairébé. Tane nherẽ, ta hã rob'rãsutu õ di. ");
INSERT INTO xavNT_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Danhipti'ai amoi u te za dasisô 're dapra, 're dasi'wapé za'ra mono da. Tawamhã daro mono bâ te za tô 're dasiwasutu za'ra. Nima niwĩmhã danho õ wa, te za duré da te 're robzépata za'ra, dasa syryre wa. Nima niwĩm norĩ ré hã te za duré ti'a hã daré 're popo'o za'ra. ");
INSERT INTO xavNT_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Ãne na dama 're romhâimana mono wamhã, za daré ĩrob'rãsutu na'rata zé, te wasu'u, pi'õi ãma ĩwasã hã 're ĩsépu'u na'rata za'ra mono ne hã. Ãhã haré dazô 're wairébé mono õ di za. — Ãne ma tô Zezusi hã wama rowaihu'u za'ra, romhâ ré. ");
INSERT INTO xavNT_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","Ãne ma tô duré wama rowaihu'u za'ra, ĩsiré 're ĩwanomro mono norĩ ma: — Tawamhã ãne na oto daré 're romhâimana mono wamhã, te za da te 're aiwaibui wa'wa, da te dama 're ai'ru za'ra wa'aba mono da, rowasédé hã da te aima 're 'manharĩ za'ra wa'aba mono da, duré da te 're asimroi wa'aba mono da. Ĩ̱zazei'wa oto 're anomro aba mono wa, te za uburé da te 're ai'ruiwapari za'ra wa'wa, daro mono bâ. ");
INSERT INTO xavNT_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Ãne na daré 're romhâimana mono ré, te za ĩ̱zazei'wa norĩ hã te te 're ĩ̱zazei utõrĩ za'ra, ahâ na. 'Râwim nherẽ, te za duré dama 're sihâiba nhomri za'ra, da te 're ĩ'ruiwapari za'ra mono zéb zarina, da te 're waibui mono da. Ĩ̱zazei'wai wa, tisisãnawã na sima 're hâimana za'ra mono nherẽ, te za oto 're si'ruiwapari za'ra, 'râwim nherẽ. ");
INSERT INTO xavNT_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","'Re ĩhâimana u'âsi mono zadawa wasu'u'wa newa, roti tô senai'õ na te te dama 're ĩroti za'ra mono norĩ hã te za datẽme 're nomro, sadawa nhipese na te te dama 're rowasu'u za'ra mono da, taré. Tawamhã ĩsimiroti hã te za tô da te 're saze za'ra, tô sena newa, ta norĩ hã sadawa nhipese na taré dama 're siwasu'u za'ra mono nherẽ. ");
INSERT INTO xavNT_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Duré dawasété uptabi na si da'ahâ uptabi na za oto 're danomro mono wa, te za 're ĩdasisawi za'ra mono zé hã dawi 're si'utõrĩ za'ra. ");
INSERT INTO xavNT_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Tane nherẽ, ni'wam norĩ hã rob'rãsutu u siptete sina ĩ̱'ãma 're nomro u'âsi mono wamhã, duré ĩ̱wi 're sipizari za'ra mono õ wamhã, ta norĩ si te za ropipa hawi tinho'reptuzé hã te te sina 're uwaimrami za'ra. ");
INSERT INTO xavNT_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","'Re ĩhâimana u'âsi mono, da'ãma 're ĩsib'a'uwẽ mono zé wasu'u hã ĩwẽ uptabi hã, ĩ̱zazei'wa norĩ hã te za daro mono bâ te te dama 're wasu'u za'ra, daro mono bâ da te oto 're wapari za'ra mono da, da te ãma 're ĩsaze za'ra mono zéb da hã. Tame te za oto tirob'rãsutu. — Ãne ma tô Zezusi hã wama rowaihu'u za'ra, romhâ ré. ");
INSERT INTO xavNT_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","16","Tawamhã Zezusi hã ma duré ãne na wama rowaihu'u sirõmo za'ra: — Zahadu wapsi, te za asiwi ĩ'madâ'â za'ra wa'wa, marĩ ĩwasété uptabi hã. 'Re ĩhâimana u'âsi mono nhorõwa ãma te za tihâiba, te te siwi ĩwẽ'õ pe hã. Taha ãma ma tô Dani'é hã rob'ui'éré siro duréihã, 'Re ĩhâimana u'âsi mono zadawa wasu'u 'rata 'wa hã. (Ãhã wasu'u na rob'ui'éré hã 're sõré za'ra wa'aba mono wamhã, ma'ãpé ãma 're rosa'rata pese za'ra wa'aba mono za, waihu'u za'ra wa'aba da.) Tawamhã ãne hã za oto daré romhâimana wamhã, rowasété si te za a'â daré 're sa'wari. Taha wa, Zudeza na danhipti'a nho'õmo nhisi ãma 're ĩsi'ubumroi mono norĩ hã, wara sina te za 're sisa're, ẽtẽ 'rãihâ u tiwi simani za'ra da, duré sisõ'reptu za'ra da. ");
INSERT INTO xavNT_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Ni'wam norĩ hã 'ri nhisi hâpâ ãma si'ubumroi wamhã, tinhibrob zô sisisi õ di za a'â, 'ri para u hã. Õne haré te za dame sisa're, ẽtẽ 'rãihâ u, ta norĩ hã. ");
INSERT INTO xavNT_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Duré ni'wam norĩ hã buru ãma te te romhuri za'ra wamhã, 'ri tẽme sisa'rei mono õ di za apâ, tisi'ubuzéb zô. Mare di. Õne haré te za duré ta norĩ hã ẽtẽ 'rãihâ u dame sisa're. ");
INSERT INTO xavNT_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Ãne hã rowasédé hã daré hâimana wamhã, ĩwasã ré norĩ ma hã tãma ropipa uptabi za'ra di za, ĩ'ra pré ré norĩ ma zama. ");
INSERT INTO xavNT_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Taha wa, te za 'Re ĩhâimana u'âsi mono ma 're aimreme zusi aba mo, rowa'u'u wahâ 're sa'wari mono ré, duré sabadu na romhuri zahârizém na bâdâ hã te te pisutu tõ da, ẽtẽ 'rãihâ u asa'rei wa'aba mono zéb da hã, rowasété wi aimani za'ra wa'aba zéb da hã. ");
INSERT INTO xavNT_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Rowasédé hã oto dazô 're wairébé mono wamhã, te za oto robzépata za'ẽtẽ za'ra ni. 'Re ĩhâimana u'âsi mono te te ĩ'aropoto na'rata mono zém hawimhã, ãne na hã da te 're robzépata za'ẽtẽ uptabi za'ra mono õ di. Niwamhã ãne na hã da te 're robzépata zahu za'ra mono õ di za. ");
INSERT INTO xavNT_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","'Re ĩhâimana u'âsi mono hã ma tô sima pisutu, bâdâ hã za da te 're ĩrobzépata za'ra mono zéb da hã, te te dama wãtari da, rowasété ré da'ãma romhâimana pahâ tõ da. Ãne hã te te sima pisutu õ 'wa'âhã, te aré uburé dasi'utõrĩ pese, za daré ĩrob'rãsutuzém na hã. 'Re ĩhâimana u'âsi mono hã ãma 're sib'a'uwẽ za'ra mono da, te te sima 're ĩ'apisutu mono norĩ zawi te, te za ãne hã 'manha. ");
INSERT INTO xavNT_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","— Za da te 're robzépata za'ẽtẽ za'ra mono ré, ãté ni'wam norĩ hã te za te te aima 're da'mahârâ za'ra wa'wa, ãne: “Ãhãta, Cristu, 'Re ĩhâimana u'âsi mono te te ĩpisudu, Danho'reptui'wa da.” Ãté aimawi norĩ hã te za duré ãne te te aima 're da'mahârâ za'ra wa'wa: “Õhõta, Cristu.” Ãne wamhã, ãma 're dazaze za'ra wa'aba mono õ di za, damreme na hã. ");
INSERT INTO xavNT_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","E marĩ wa, wa ãne aima waihu'u za'ra wa'wa. Ni'wam norĩ hã te za datẽme 're nomro, danho'reptui'wa na, niha wamhã, 'Re ĩhâimana u'âsi mono zadawa wasu'u'wa na dama 're siwasu'u za'ra mono da, sadawa nhipese na. Ta norĩ hã marĩ dama ĩ'manharĩ waihu'u'õ hã te za duré te te dama 're 'manharĩ za'ra, 'Re ĩhâimana u'âsi mono zadawa para newa, da te ãma 're sasõmri za'ra mono da. Ĩsazei'wa norĩ zama te te dame ãma 're saze za'ra mono da, te za ãne na te te dama 're romhõsi za'ra. Tane nherẽ, te te dame 're sazei waihu'u za'ra mono õ di za ta norĩ hã, 'Re ĩhâimana u'âsi mono te te sima 're apisutu sirõmo mono wa, ãma 're sib'a'uwẽ za'ra mono da. ");
INSERT INTO xavNT_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Ãne hã wa aima waihu'u sirõmo za'ra wa'wa, zahadu romhâimana õ ré. Taha wa, ma'ãpé ãma 're asõpré u'âsi aba mono za, ãne na hã. ");
INSERT INTO xavNT_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","— Ãté ni'wam norĩ hã te za taré te te aima 're rowasu'u za'ra wa'wa, ãne: “Danho'reptui'wa da, 'Re ĩhâimana u'âsi mono te te ĩpisudu hã ma tô wei mo, apâ. Õhõta te nhamra, a'ubuni wi.” Ãne hã 're wapari za'ra wa'aba mono wamhã, a'ubuni u 're anomro aba mono õ di za, ĩ̱zô 're asõpré wa'aba mono da. Ãté te za duré ãne da te aima 're rowasu'u za'ra wa'wa: “Ãhãta ma dawi aima'u.” Ãne wamhã, ãma 're dazaze za'ra wa'aba mono õ di za, senai'õ na hã, wa hã pi'uriwi nimahã na hã za we apâ ĩ̱morĩ õ na dâ'âsina. ");
INSERT INTO xavNT_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Tã 're si'ubuzi za'ra mono wamhã, dama rob'madâ'â pibu pese di, hâiwa mono bâ hã. Tane duré, wa hã dasiré ĩ̱podo hã apâ we ĩ̱morĩ wamhã, aihĩni te za ĩ̱'madâ'â za'ra ni. ");
INSERT INTO xavNT_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","— Sipahudu hã marĩ dâ'â u 're si'rã'õtõ mono wamhã, dama pibui pese za'ra di, marĩ hã 're dâ'â za'ra mono wa, 're ĩsimi'wara mono zé hã. Tane, wa hã apâ we ĩ̱morĩzé hã uburé dama ĩ̱pibu pese za'ra di za oto. — Ãne ma tô Zezusi hã wama sina rowaihu'u sirõmo za'ra, ĩsiré 're ĩwanomro mono norĩ ma. ");
INSERT INTO xavNT_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","Ãne na ma duré wama waihu'u sirõmo za'ra: — Tawamhã da te 're robzépata za'ẽtẽ za'ra mono parip si, awa'awi te za bâtâ na tirobra. A'amo zama te te rob'uiwẽ õ di za oto. Wasi norĩ hã te za duré rere, hâiwa hawi. Uburé hâiwa na 're ĩsimasa mono hã te za duré 're sisa're. ");
INSERT INTO xavNT_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Ãne hã daré romhâimana pari, marĩ hã te za watobro hâiwa na, dama ĩ̱pibu pese zéb da hã, wa hã dasiré ĩ̱podo, apâ we ĩ̱morĩzém na da te ĩ̱'ãma waihu'u za'ra da oto. Tawapsi te za oto daro mono bâ dasiwi ĩ̱'madâ'â ni, hâiwa'a na we ĩ̱morĩ ré. Ĩ̱waihu'u pese na wa za wei mo apâ, duré ĩ̱hâiba na hã rowa'a za'ẽtẽ ré. Da te dasiwi ĩ̱'madâ'â za'ra wamhã, te za 're dazadari za'ra, robzawi te, danhimiza'rese ĩ̱zô 're danhimipari za'ra mono õ wa. ");
INSERT INTO xavNT_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Tawamhã hâiwa ãma ĩ̱ma romhuri'wa hã tinhimnhihârâzém na te za oto amnhihâ, hârâ 'rãihâ uptabi na, daro mono bâ da te ĩwapari za'ra da hã. Simnhihârâ wi, hâiwa hawi ĩ̱ma romhuri'wa norĩ hã wa za we dazô satõrĩ za'ra, ti'ai u. Tawamhã 'Re ĩhâimana u'âsi mono hã ãma 're sib'a'uwẽ za'ra mono da, te te sima 're ĩ'apisutu mono norĩ hã te za we daro mono bâ te te simro, ĩ̱tẽme. — Ãne na ma tô Zezusi hã romhâ ré wama waihu'u sirõmo za'ra. ");
INSERT INTO xavNT_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","Tawamhã ãne te duré wama rowasu'u za'ra: — Pidera wede na, wa za oto aima ãma romnhimiré'é za'ra wa'wa, waihu'u za'ra wa'aba da. Pidera wede panhipti hã wapti'i wamhã, duré ĩsu té hã 're wairébé mono wamhã, tawapsi te za oto ãma ĩwaihu'u za'ra wa'wa, tã 're ĩta'a mono zéb u 're ĩromhutu mono zém na hã. ");
INSERT INTO xavNT_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Tane duré, marĩ hã 're ĩromhâimana mono zéb da, te aima ĩwasu'u za'ra wa'aba zéb zarina, 'madâ'â za'ra wa'aba wamhã, te za ĩwaihu'u za'ra wa'wa, rob'rãsutuzé hã za oto ĩwatobro na hã. ");
INSERT INTO xavNT_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Tô sena, wa ãne hã aima waihu'u sirõmo za'ra wa'wa. Ã hã uburé rowasédé hã dazô 're wairébé mono ré, ti'ai ãma 're ĩdahâimana za'ra mono norĩ hã 're dâ'â za'ra mono õ ré, te za ĩsõ'a za'ra ti'rãsutu, romhâimanazé hã. ");
INSERT INTO xavNT_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Nimahã na te za hâiwa norĩ hã ai'utõrĩ zahuré, ti'ai me. Si'utõrĩ zahuré nherẽ, ĩ̱nhimirowasu'u hã si'utõrĩ waihu'u õ di za. Pire na te za dama 're hâimana u'âsi. — Ãne ma tô Zezusi hã wama waihu'u za'ra, ĩsiré 're ĩwanomro mono norĩ ma. ");
INSERT INTO xavNT_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","Tawamhã Zezusi hã ma duré ãne na wama waihu'u sirõmo za'ra: — Ãne hã uburé za daré 're ĩromhâimana mono zéb da hã, ni'wa hã bâdâ hã te te waihu'u õ di. Hâiwa ãma romhuri'wa norĩ zama, bâdâ hã te te waihu'u za'ra õ di duré. Wa hã 'Re ĩhâimana u'âsi mono 'ra nherẽ, te duré bâdâ hã waihu'u õ di. Ĩ̱mama ma si, waihu'u pese di bâdâ hã. ");
INSERT INTO xavNT_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Danhimiza'rese ãna 're danomro mono ré, wa za wei mo apâ dasiré ĩ̱podo hã, duréihã Nowé 're hâimana mono ré hã, danhimiza'rese ãna 're ĩdahâimana za'ra mono ne. ");
INSERT INTO xavNT_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Ta norĩ hã daro mono bâ daré âpusi mono õ ré hã, ma tô 're saihuri, tisa na. Te te 're âhuri duré, rowẽ na 're rosa'wari u'âsi mono da newa. Te duré sina 're mro za'ra. Ãne ma tô danhimiza'rese ãna 're dahâimana za'ra, Nowé hã uba're ne 'manharĩ 're sébré õ ré, 'ri ne 'manharĩ 'remhã. ");
INSERT INTO xavNT_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Tawamhã rosa'rese õ ré, ma tô daré âpusi. Tawamhã uburé ma dasi'utõrĩ pese, â na. Tane duré, wa hã dasiré ĩ̱podo hã danhimiza'rese ãna 're danomro mono ré, wa za wei mo, apâ. ");
INSERT INTO xavNT_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","— Ãté aibâ norĩ hã buru na siré te te romhuri zahuré ré, wa za we apâ mo, dazô. Tawamhã ĩhâiba amo hã ãté te za tiwi ti'â hâiwa u, 'Re ĩhâimana u'âsi mono hã. Ĩhâiba amo si te za tirẽ. ");
INSERT INTO xavNT_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Ãté pi'õ norĩ hã siré 'ru'u zahuré ré, te za tiwi ti'â, ĩhâiba amo hã. Tawamhã ĩhâiba amo si te za tirẽ, 'Re ĩhâimana u'âsi mono hã. ");
INSERT INTO xavNT_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Taha wa, te za asimiza'rese, ĩ̱zô 're asimipari u'âsi za'ra wa'aba mo, wa hã Asib'apito za'ra wa'wa hã apâ we ĩ̱morĩzé hã bâdâ hã waihu'u za'ra wa'aba õ wa. ");
INSERT INTO xavNT_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Wa za duré aima ãma romnhimiré'é za'ra wa'wa, ãma rosa'rata za'ra wa'aba da. 'Ri tede'wa hã ĩsõrõwa u ĩsipsaihuri ĩwisizé hã, bâdâ te te waihu'u sirõmo wamhã, tawamhã barana te za sô rob'madâ'â u'âsi, sõtõ ãna, 'ri para u sébré tõ da, tiwi sipsaihuri õ'umnhasite. ");
INSERT INTO xavNT_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Tane duré, a norĩ wa'wa hã te za asimiza'rese ĩ̱zô 're asõpré u'âsi aba mo. E marĩ wa. Wa hã dasiré ĩ̱podo hã nimahã bâtâ na ĩ̱zô asimipari za'ra wa'aba õ zém na za we apâ ĩ̱morĩ na dâ'âsina. — Ãne te Zezusi hã wama roti za'ra, ĩsiré 're ĩwanomro mono norĩ ma, wanhimiza'rese sô 're wanhimipari za'ra mono da. ");
INSERT INTO xavNT_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Tawamhã Zezusi te duré wama ãma romnhimiré'é za'ra, ãne: — Dama romhuri'wa ĩ'umnha hã duré ĩsimiroti wẽ hã, e niha 're ĩhâimana mono zé hã. Ãne hã 're hâimana mono wamhã, te za ĩsib'apito hã nimomo tiwi morĩ õ ré, tãma pisutu, uburé tãma ĩromhuri'wa norĩ hã ĩsa'u nherẽ, te te sô 'madâ'â za'ra da. Te za duré tãma roti, bâtâ pisutuzém na ĩsazéb da hã, te te tãma ãma uwaimrami za'ra da, tãma ĩromhuri'wa norĩ ma. ");
INSERT INTO xavNT_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Tawamhã apâ we ĩmorĩzéb u, tinhib'apito nhimiroti hã te te tãma ãma uwaimrami wamhã, tãma rowẽ di za, romhuri'wai ma hã. ");
INSERT INTO xavNT_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Taha ma, tãma rowẽ uptabi di za tô. E marĩ wa. Ĩsib'apito hã apâ wisi wapsi, te za tãma pisutu, uburé ĩsimarĩ hã te te tãma 're 'madâ'â u'âsi mono da oto, tãma umnhasi uptabi wa. ");
INSERT INTO xavNT_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Tazahã, tinhib'apito za're'ra, ĩsimiroti hã te te tãma ãma uwaimrami õ wamhã, tãma rowẽ õ di za. Ãté apito za're'ra, te za 'râwi sima tinha: “Ĩ̱nhib'apito hã simahudu õ di.” ");
INSERT INTO xavNT_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","Tawamhã sô rowaptâ'â wẽ te, te za oto tizapari romhuri'wa norĩ hã te te 're ahâ za'ra. Âzé hã te za duré te te 're hâsi, âzézei'wa norĩ siré. Siwa'ru te za oto 're hâimana. ");
INSERT INTO xavNT_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Tawamhã simisa'rese ãna hâimana ré, te za ĩsib'apito hã ĩtẽme wi apâ, sô ĩsimipari õ zém na nimahã bâtâ na, siwa'ru. ");
INSERT INTO xavNT_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Tawamhã sa'ẽtẽ te za azâ, tãma ĩromhuri'wa hã. Tane ni'wam norĩ hã apâ we ĩ̱morĩ õ ré, 'Re ĩhâimana u'âsi mono nhimiroti te te 're 'madâ'â pese za'ra mono õ wamhã, te za tãma pisutu za'ra, ropipa u 're sisisi mono da, dasiré, ĩsimiroti hã te te 're 'madâ'â pese za'ra mono newa, taré ãma 're dawata za'ra mono da, 're ĩhâimana wasété za'ra mono norĩ zu. Tame te za oto 're 'ry'ry. Te za duré 're 'wasitete za'ra, te te 're robzépata za'ẽtẽ za'ra mono wa. — Ãne na ma tô Zezusi hã wama waihu'u za'ra, ĩsiré 're ĩwanomro mono norĩ ma. ");
INSERT INTO xavNT_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Tawamhã Zezusi hã ma tô tinhimiromnhimiré'é na wama rowasu'u za'ra, ĩsiré 're ĩwanomro mono norĩ ma, ãne: — Nimahã na si 'Re ĩhâimana u'âsi mono, da'ãma 're ĩsib'a'uwẽ mono zéb da, apâ we dazô ĩ̱morĩ wamhã, ni'wam norĩ si te za, ĩ̱zô 're simipari za'ra mono sina, hâimana nhimiza'rese 're hâimana za'ra. Ã norĩ wasu'u zarina, wa za ãma aima romnhimiré'é za'ra wa'wa, ãne. Pi'õ ĩpréduptém norĩ hã barana ma tô ai'aba'ré, dasina damro u, 10 na ĩhâiba za'ra hã, ĩmro'õ norĩ hã. Aibâ hã za azarutu na ĩmro zô simipari za'ra da, ma tô ĩtẽme ai'aba'ré, pi'õ nhorõwa u. Âro'ore hã te siré 'wasa hâiba bâ, aibâ hã za pi'õ na ĩmro u wisi wa, te te tãma ãma rob'uiwẽ za'ra da, zudezu norĩ hâimanazéb zarina. ");
INSERT INTO xavNT_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","4","Tane nherẽ, pi'õ ĩpréduptém norĩ hã 5 na si ma tô hâiba mono bâ rob'rãi wa'u to hã siré 'wasa, simhi ne ẽtẽ 'manharĩ 're, âro'ore da hã, ta norĩ si hâimana nhimiza'rese 're hâimana za'ra mono wa. Ĩhâiba amo norĩ hã 5 na ĩhâiba za'ra hã te te siré 'mai'âri za'ra õ di, rob'rãi wa'u tob ré hã simhi ne ẽtẽ 'manharĩ 'remhã, hâimana nhimiza'rese 're hâimana za'ra mono õ wa. ");
INSERT INTO xavNT_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Tawamhã aibâ zô te tirowaptâ'â hâ, za pi'õ na ĩmro zô. Sô rowaptâ'â wamhã, ma tô aptâ hã simro. Taha wa, ma tô nasi titomhâima'ã za'ra. Taha wa, te oto tinhotõ za'ra, ĩwana. ");
INSERT INTO xavNT_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","— Tawamhã mara wa'wa ma tô ni'wa hã 'mahâ: “Õhõta te we oto aibâ hã mo. We aiwairébé su'u aba, wa te wasina uzusi za'ra hâ.” Ãne te ni'wa hã aibâ hã dama 'mahâ. ");
INSERT INTO xavNT_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","— Tawamhã pi'õ ĩpréduptém norĩ hã sô ĩsimipari za'ra hã ma tô ti'utu za'ra. Utu za'ra wamhã, âro'ore na wedenhorõ hã ma tô sõrõ nhihâri za'ra, ro'o wẽ da. ");
INSERT INTO xavNT_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Tawamhã hâimana nhimiza'rese ãna 're ĩhâimana za'ra mono norĩ hã ma tô tiwi rowaptẽrẽ za'ra, tihâiba amo norĩ wi, hâimana nhimiza'rese sina 're ĩhâimana za'ra mono norĩ wi: “Ma'ãpé syry na wama sa'wari za'ra wa'aba, âro'ore na rob'rãi wa'u to hã. Âro'ore hã wate za'ra hã te za oto wawi tidâ'â za'ra.” Ãne te pi'õ ĩpréduptém norĩ hã tisiré norĩ wi rowaptẽrẽ za'ra. ");
INSERT INTO xavNT_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","— Tawamhã asa te tãma nharĩ za'ra: “Rob'rãi wa'u to hã wa te aima sõmri za'ra wa'aba õ di za. Mara wab õ di za, wa te aima a za'ra wa'aba wamhã. Te za wawi ai'utõrĩ za'ra. Ma'ãpé tiha, da te 're ĩ'uipra za'ra mono zéb u, ai'aba'ré su'u aba, tamemhã asima 'mai'uipra za'ra wa'aba da.” Ãne te satõrĩ za'ra, tisiré norĩ hã. ");
INSERT INTO xavNT_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","— Tawamhã pi'õ ĩpréduptém norĩ hã hâimana nhimiza'rese ãna 're ĩhâimana za'ra mono norĩ hã ma tô ai'aba'ré, rob'rãi wa'u tob zô, te te sima 'mai'uipra za'ra da. Tawamhã ta norĩ za'u si ma tô aibâ hã wi, timro zô. Wisi wamhã, pi'õ ĩpréduptém norĩ hã 5 na ĩhâiba hã hâimana nhimiza'rese 're ĩhâimana za'ra mono norĩ hã ma tô ĩsiré asisi 'ri para u, ĩsiré saihuri da, sina ĩmro zahuré zém na. Sisisi wamhã, ma tô ĩré 'ridawa nhitop tete za'ra ni. ");
INSERT INTO xavNT_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","— Ãma ronomro za'ra wapsi, ma tô ĩhâiba amo norĩ hã aihutu apâ, pi'õ ĩpréduptém norĩ hã, aibâ hã pi'õi ãma ĩmrozéb u hã. Sihutu wamhã, ãne te nasi 'mahârâ za'ra, rowi hawi: “Apito, apito, wei wama 'ridawa za'ra na, ãma atẽme wanhisisi da.” ");
INSERT INTO xavNT_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","— Tawamhã aibâ hã pi'õ na ĩmro hã te asa tãma nharĩ za'ra: “Mare di. Te aima 'ridawa za'ra wa'aba õ di za, ĩ̱ma aiwaihu'u za'ra wa'aba õ wa.” Ãhã wasu'u na wa tô aima ãma romnhimiré'é za'ra wa'wa, ãne na hã. ");
INSERT INTO xavNT_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","— Taha wa, a norĩ wa'wa hã aihâimana nhimiza'rese te za ĩ̱zô 're asõpré u'âsi aba mo, bâdâ hã aima waihu'u za'ra wa'aba õ wa, apâ za we ĩ̱morĩzé hã. — Ãne ma tô Zezusi hã wama waihu'u sirõmo za'ra, ĩsiré 're ĩwanomro mono norĩ ma. ");
INSERT INTO xavNT_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","15","Tawamhã Zezusi hã ma duré tinhimiromnhimiré'é na marĩ hã wama waihu'u za'ra, ĩsiré 're ĩwanomro mono norĩ ma, ãne: — 'Re ĩhâimana u'âsi mono, za da'ãma 're ĩsib'a'uwẽ mono zém na, wa za duré aima ãma romnhimiré'é za'ra wa'wa, ãne. Aibâ hã ma tô sima rowẽ, darob amoi u morĩ da. Tawamhã morĩ õ ré, ma tô sô tihârâ za'ra, tãma ĩromhuri'wa norĩ zô, tite rob'uiprazé hã te te tãma sõmri za'ra da, ĩsa'u te te sô 're 'madâ'â za'ra mono da, duré tãma sina hâ'â da, taré 're simi'wara tõ mono da, rob'uiprazé hã. Ĩsimiromhuri wẽ na tãma ĩ'umnhasi za'ra zarina, ma tô tãma sõmri za'ra. Ĩmorĩ'rata ma hã ma tô 5 miu na tãma tisõ rob'uiprazé ĩsapotore hã, oru 'manharĩ hã. Duré ĩsãna're ma hã 2 miu na ma tô tãma tisõ. Duré da'rãsutu'wai ma hã, miu na ma tô tãma tisõ. Taha pari te oto mo, darob amoi u, danhib'apito hã. ");
INSERT INTO xavNT_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Tawamhã tãma ĩromhuri'wa hã, 5 miu na rob'uiprazé ĩsapotore te te ĩ'âri hã õne haré ma tãma sina hâ, te te ãma ĩromhuri wẽ zéb zarina. Tawamhã 5 miu na nherẽ, ma tô duré 5 miu na ãma ato, ĩsib'apito te te tãma ĩsõmri na hã. Uburé hã 10 miu na oto, rob'uiprazé ĩsapotore hâiba hã, ãma sito wamhã. ");
INSERT INTO xavNT_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Tane duré tãma ĩromhuri'wa hã 2 miu na rob'uiprazé ĩsapotore te te ĩ'âri hã ma tô duré tãma sina hâ. 2 miu na nherẽ, ma tô duré 2 miu na ãma ato. Uburé hã 4 miu na ĩhâiba hã oto. ");
INSERT INTO xavNT_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Tane nherẽ, tãma ĩromhuri'wa hã miu na rob'uiprazé ĩsapotore te te ĩ'âri hã tinhib'apito nhimiroti te te 'madâ'â õ di. Taré ma tô sada ab're, tinhib'apito wi, rob'uiprazé hã te te sẽrẽ da. ");
INSERT INTO xavNT_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","— Tawamhã ãma ronomro hâ wapsi, ma tô ĩsib'apito za'ra hã apâ ĩtẽme tiwisi za'ra, darob amoi hawi. Wisi wi, te sô tihârâ za'ra, tãma ĩromhuri'wa norĩ zô, rob'uiprazé ĩsapotore hã niha si te te hâimana mono zô, te te tãma wasu'u za'ra da. ");
INSERT INTO xavNT_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Tawamhã romhuri'wa hã 5 miu na rob'uiprazé te te aré ĩ'âri hã ma tô ĩtẽme ãzé ĩmorĩ'rata na, tinhib'apito u. Ãne te tãma tinha: “Apito, rob'uiprazé ĩsapotore hã 5 miu na ma tô ĩ̱ma ĩsõ, asa'u aima sina hâ'â da, tawapsi, aima ãma ĩ̱sitob da, taré aiwi simi'wara tõ da. Ãhãta ma tô sina hâ, 5 miu na, te ãma aima ĩromhuri wẽ zéb zarina. Uburé hã 10 miu na oto ĩhâiba hã, rob'uiprazé ĩsapotore hã. Ãhãta te asô nomro.” Ãne te romhuri'wa hã tinhib'apito ma wasu'u, tinhimiromhuri hã. ");
INSERT INTO xavNT_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","— Tawamhã ĩsib'apito te asa tãma tinha, ãne: “Wẽ di tô. A hã ĩ̱ma romhuri wẽ 'wa. Ĩ̱ma ai'umnhasi di. Rob'uiprazé hã syryre nherẽ, ma tô ãma ĩromhuri wẽ, ĩ̱zô. Taha wa, ãhã nhipai u wa za oto aima pisutu, marĩ ahâ uptabi na ĩ̱ma 're ab'madâ'â u'âsi mono da. Te za oto ĩ̱siré 're aihâimana mo, wasiré ãma 're watoi u'âsi mono da.” Ãne ma tô tãma ropisutu siro, tãma ĩromhuri wẽ 'wai ma. ");
INSERT INTO xavNT_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","— Tawamhã romhuri'wa hã 2 miu na rob'uiprazé te te aré ĩ'âri hã ma tô duré ĩtẽme ãzé, tinhib'apito u. Tawamhã ãne te tãma tinha: “Apito, rob'uiprazé ĩsapotore hã 2 miu na ma tô ĩ̱ma ĩsõ, asa'u aima sina hâ'â da, tawapsi, aima ãma ĩ̱sitob da, taré aiwi simi'wara tõ da. Ãhãta ma tô aima sina hâ, 2 miu na, te ãma ĩromhuri wẽ zéb zarina, aima. Uburé hã 4 miu na ĩhâiba hã rob'uiprazé ĩsapotore hã. Ãhãta te asô nomro.” Ãne te romhuri'wa hã tinhib'apito ma siwasu'u, tinhimiromhurizém na. ");
INSERT INTO xavNT_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","— Tawamhã ĩsib'apito asa te tãma tinha, ãne: “Wẽ di tô. A hã ĩ̱ma romhuri wẽ 'wa. Ĩ̱ma ai'umnhasi di. Rob'uiprazé hã syryre nherẽ, ma tô ãma ĩ̱zô ĩromhuri wẽ. Taha wa, ãhã nhipai u wa za duré aima pisutu, marĩ ahâ uptabi na ĩ̱ma 're ab'madâ'â u'âsi mono da. Te za oto ĩ̱siré 're aihâimana mo, wasiré ãma 're watoi u'âsi mono da.” Ãne ma tô duré tãma ropisutu siro, tãma ĩromhuri wẽ 'wai ma hã. ");
INSERT INTO xavNT_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","— Tawamhã romhuri'wa hã miu na rob'uiprazé te te aré ĩ'âri hã ma tô duré ĩtẽme ãzé, tinhib'apito u. Tawamhã ãne te tãma tinha, ta hã senai õ na hã: “Apito, ĩ̱ma aiwaihu'u pese di. A hã da'ãma 're aipẽ'ẽzé mono õ. Ni'wa hã te te dame 're rob're mono õ nherẽ, danho hã tite da, te te dawi sima 're ĩ'a'rãihâri mono ne, te danhimarĩ hã dawi asima 're ĩ'awaibui mo, ate da. ");
INSERT INTO xavNT_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Ãne na te aiwaihu'u wa, wa tô aima ĩ̱pahi. Taha wa, te aiwi simini wa, niha ĩ̱ma rob'manharĩ õ'umnhasite, wa tô rob'uiprazé ĩsapotore hã simi'u ti'ai 'rowi, wẽ na asô 're sa'wari mono da. Ãhãta te wẽ na asô nomro, uburé ate rob'uiprazé hã te asô 're 'madâ'â mono da, ĩ̱ma ĩsõmri hã.” Ãne te romhuri'wa hã tãma siwasu'u, tinhib'apito ma. ");
INSERT INTO xavNT_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","— Tawamhã ĩsib'apito, te ãne asa tãma tinha: “A hã ĩ̱ma romhuri wasété 'wa. Aiwa'a uptabi di. Ma tô ĩ̱'ãma ĩrosa'ra, marĩ hã date nherẽ, te dawi ĩ̱sima 're ĩ'awaibui mono na, ĩ̱te da. Ãne ma tô ĩ̱'ãma ĩrosa'ra, asima. ");
INSERT INTO xavNT_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Ãne na 're ĩ̱hâimana mono wamhã, e marĩ wa bété, rob'uiprazé ĩ̱zô sẽrẽ õ di, wedehâpâ 're. Tawamhã apâ we ĩ̱wisi wapsi, te aima ĩsõmri nhipai u, wa aré ĩ̱sima waze uburé, ĩ̱zô sina hâ'â wa.” Ãne ma tô tãma waihu'u, tãma ĩromhuri wasété 'wai ma. ");
INSERT INTO xavNT_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","29","Tawamhã te duré tãma rowasu'u za'ra, uburé ĩ'rata ĩsimasam norĩ ma: “Ni'wam norĩ hã marĩ ahâ nherẽ, simi'ẽ na te te 're romhuri za'ra mono wamhã, te za ãma tãma 're dasito, marĩ na. Tane nherẽ, ni'wam norĩ hã marĩ syryre na simi'ẽ na te te ãma 're romhuri za'ra mono õ wamhã, te za syryre nherẽ, tiwi sani za'ra ni. Taha wa, te za tiwi ĩ'âri 'wa, rob'uiprazé ĩsapotore hã, ĩ̱ma romhuri wasété 'wai wi, 10 miu na te te ĩ̱zô ĩhâiba ma, sõmri aba da. ");
INSERT INTO xavNT_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Taha pari, te za asiwi ĩmei wa'wa rob u, robra u. Tame te za oto sina tiwawa. Te za duré 'wasitete, te te robzépata za'ẽtẽ wa.” Ãne ĩsib'apito hã ma tô dama hâiba 'ru. — Ãne na ma tô Zezusi hã wama ãma romnhimiré'é za'ra, ĩsiré 're ĩwanomro mono norĩ ma. ");
INSERT INTO xavNT_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Tawamhã Zezusi hã ma tô duré romhâ ré wama rowaihu'u sirõmo za'ra, ãne: — Wa hã ti'ai ãma dasiré ĩ̱podo hã niwapsi wa za wei mo apâ Ĩ̱mama zadawa para, hâiwa ãma tãma ĩromhuri'wa norĩ siré. Tawapsi wa za danhib'apito simasisizém na 're ĩ̱nhamra, ĩ̱pire na te 're da'ab'madâ'â u'âsi mono da oto. ");
INSERT INTO xavNT_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Tame te za aihĩni pese ĩ̱nho're aimasam ni, daro mono bâ 're ĩdahâimana za'ra mono norĩ hã, dapoto mono bâ. Tawamhã tame wa za oto da'ãma aipo'o. Pone'ẽrebâ 'madâ'â'wa hã te za tinhimizama na 're sipo'o, pone'ẽrebâ zéré mapu hã, pone'ẽrebâ zéré uzé zama. Tane wa za duré wa hã da'ãma aipo'o, ĩwẽ hã duré ĩwasédé hã. ");
INSERT INTO xavNT_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","'Re ĩhâimana u'âsi mono nhimiroti te te 're ĩ'madâ'â pese za'ra mono norĩ hã ĩ̱nhimire niwĩ wa za sõré, ta norĩ si te 're awẽsãmri mono wa. 'Re ĩdanomro wasété mono norĩ hã ĩ̱nhimi'e niwĩ wa za duré sõré, ta norĩ si te ĩ̱siwi 're awẽ'õ pese mono wa. ");
INSERT INTO xavNT_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Tawamhã wa hã uburé Danhib'apito hã wa za ãne ta norĩ ma nharĩ za'ra, ĩ̱nhimire niwĩm norĩ ma: “Ĩ̱mama, ĩwẽ si te te aima 're ĩsõmri za'ra wa'aba mono norĩ hã te za oto ĩ̱'rata 're aihâimana u'âsi za'ra wa'aba mo. Duréihã te te aropoto mono wamhã, ma tô sima aipisutu za'ra wa'wa, ai'ãma 're sib'a'uwẽ za'ra wa'aba mono da. Taha wa, te za oto ĩ̱'rata 're aihâimana u'âsi za'ra wa'aba mo, ai'ãma 're sib'a'uwẽ u'âsi za'ra wa'aba mono da oto. ");
INSERT INTO xavNT_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Ti'ab ré, mram na 're ĩ̱hâimana mono ré hã, ma tô mra hã ĩ̱ma 're ĩsõmri za'ra wa'aba mo. Duré 'rubu ré ma tô â hã ĩ̱ma 're ĩ'õb za'ra wa'aba mo. Duré asiré õ nherẽ, ma tô ĩ̱zô 're atob'uzu za'ra wa'aba mo, asõrõwa u atẽme 're ĩ̱zasi aba mono da. ");
INSERT INTO xavNT_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Ĩ̱'uza õ ré, ma tô asiwi 're ĩ̱'uza za'ra wa'aba mo. Duré ĩ̱hâzé wa, ma tô asiwi 're ĩ̱pibui wa'aba mo. Dazazéb 're, 're ĩ̱za mono ré, ma tô duré asiwi 're ĩ̱zabu za'ra wa'aba mo. Ãne na 're ĩ̱pawaptob u'âsi za'ra wa'aba mono wa, hâiwa ãma te za oto ĩ̱siré 're anomro u'âsi aba mo, Ĩ̱mama hã ai'ãma 're ĩsib'a'uwẽ za'ra wa'aba mono zéb ãma hã.” Ãne na wa za nimahã na hã tãma ĩ̱siwasu'u za'ra, ĩ̱nhimire niwĩ ĩsimasam norĩ ma. ");
INSERT INTO xavNT_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","— Tawamhã õ norĩ hã 'Re ĩhâimana u'âsi mono nhimiroti te te 're ĩ'madâ'â pese za'ra mono norĩ hã te za sina ĩ̱zadanharĩ za'ra, ãne: “Wanhib'apito, e niwa wa tô mra hã wa te aima 're sõmri za'ra, mram na 're aihâimana mono ré hã. E niwa duré 'rubu na 're aihâimana mono ré, wa tô â hã wa te aima 're õb za'ra. ");
INSERT INTO xavNT_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","E niwa wa tô aiwaihu'u õ nherẽ, asô 're watob'uzu za'ra, wanhorõwa u zama 're azasi mono da. E niwa wa tô duré ai'uzazéb da hã wa te aima 're sõmri za'ra, ai'uza õ wa. ");
INSERT INTO xavNT_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","E niwa wa tô duré wa te wasiwi 're aipibu, aihâzé ré. E niwa wa tô duré atẽme 're wanomro, wa te 're asabu za'ra mono da, dazazéb 're, 're asa mono ré hã.” Ãne te za ta norĩ hã sina amrami za'ra, ĩ̱ma. ");
INSERT INTO xavNT_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","— Tawamhã wa hã uburé Danhib'apito hã wa za ta norĩ ma ãne tãma rowasu'u za'ra: “Tô sena wa aima rowasu'u za'ra wa'wa. Ĩ̱sisãnawã norĩ hã ti'ab ré ãne na te te 're robzépata za'ra mono wamhã, dama wapu na 're hâimana za'ra mono nherẽ, marĩ ĩwẽ hã tô õhõ na hã tãma 're 'manharĩ wẽ za'ra wa'aba mono wamhã, ta norĩ hâiba u'âbâ ma tô ĩ̱ma 're ĩ'manharĩ wẽ za'ra wa'aba mo.” Ãne na wa za ta norĩ ma waihu'u za'ra. ");
INSERT INTO xavNT_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","— Tawamhã ĩ̱nhimi'e niwĩ ĩsimasam norĩ ma, wa za nharĩ za'ra oto, ãne: “A norĩ wa'wa hã ma tô 'Re ĩhâimana u'âsi mono hã te te siwi 're aiwẽ'õ pese za'ra wa'wa. Mo oto ĩ̱nhiti ai'aba'réi wa'aba, unhama ro'o u'âsi u, wa'uburé norĩ zô 'Re ĩhâimana u'âsi mono te te ĩpisutuzéb u, ta norĩ nhib'apito zô zama. ");
INSERT INTO xavNT_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Ti'ab ré mram na 're ĩ̱hâimana mono ré hã, ĩ̱sa hã ĩ̱ma 're sõmri za'ra wa'aba mono õ di. Duré 'rubu ré, â hã ĩ̱ma 're õb za'ra wa'aba mono õ di. ");
INSERT INTO xavNT_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Wa hã aima ĩ̱waihu'u za'ra wa'aba õ nherẽ, ĩ̱zô 're atob'uzu za'ra wa'aba mono õ di, asõrõwa u 're ĩ̱zasi aba mono da hã. Duré ĩ̱'uza õ ré, asiwi 're ĩ̱'uza za'ra wa'aba mono õ di. Duré ĩ̱hâzé ré, asiwi 're ĩ̱pibu za'ra wa'aba mono õ di. Dazazéb 're, 're ĩ̱za mono ré, ĩ̱tẽme 're anomro aba mono õ di, 're ĩ̱zabu za'ra wa'aba mono da.” Ãne wa za ta norĩ ma nharĩ za'ra, ĩ̱nhimi'e niwĩ ĩsimasam norĩ ma hã. ");
INSERT INTO xavNT_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","— Tawamhã ta norĩ hã te za asa ĩ̱ma nharĩ za'ra, ãne: “Apito, e niwa wa tô taré wa te 're ai'madâ'â za'ra, mram na 're aihâimana mono ré hã, duré 'rubu 're sépata mono ré hã, duré wama aiwaihu'u õ nherẽ, nima hawi watẽme 're aimasisi mono na hã, duré ai'uza ãna 're aimorĩ wamhã, duré aihâzé na 're aihâimana mono ré hã, duré dazazéb 're, 're asa mono ré hã. E niwa wa tô ãne na hã taré wa te 're ai'madâ'â za'ra, wa te wasiwi 're aipawaptob za'ra mono ãna.” Ãne te za duré ta norĩ hã ĩ̱zadanharĩ na ĩ̱ma wa'rãmi za'ra, ĩ̱nhimi'e niwĩ ĩsimasam norĩ hã. ");
INSERT INTO xavNT_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","— Tawamhã ta norĩ ma, wa za duré ãne rowasu'u za'ra: “Tô sena wa aima rowasu'u za'ra wa'wa. Ti'ab ré, ã norĩ hã dama wapu na 're ĩhâimana za'ra mono norĩ hã ãne na te te 're robzépata za'ra mono ré hã, marĩ ĩwẽ na 're pawaptob za'ra wa'aba mono õ di. 'Re pawaptob za'ra wa'aba mono õ wamhã, ta norĩ hâiba u'âbâ, asiwi 're ĩ̱pawaptob za'ra wa'aba mono õ di duré.” Ãne wa za ta norĩ ma, tãma waihu'u na wa'rãmi za'ra, ĩ̱nhimi'e niwĩ ĩsimasam norĩ ma hã. ");
INSERT INTO xavNT_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","— Tawamhã ta norĩ hã te za oto ai'aba'ré, 'Re ĩhâimana u'âsi mono nhiti, ĩsimihâzém na za te te 're ĩrobzépata u'âsi za'ra mono zéb u hã. 'Re ĩhâimana u'âsi mono nhimiroti te te 're ĩ'madâ'â pese za'ra mono norĩ si, te za ĩ'rata 're hâimana u'âsi za'ra, rowẽ u'âsi ãma. ");
INSERT INTO xavNT_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Tawamhã Zezusi hã tinhimiroti na uburé ãne na te te dama rowahutu parimhã, ma tô wama nharĩ za'ra, ĩsiré 're ĩwanomro mono norĩ ma, ãne: ");
INSERT INTO xavNT_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","— Romhuture di oto, dato hã da te 're ĩ'manharĩ za'ra mono zéb u hã, 'Re ĩhâimana u'âsi mono, Ezitu hawi te te ĩdawaibuzém na ãma dasipo're pu'u za'ra da, Pascowa na dato nhisi hã. Awẽ amo na te za ĩwa waptãrã, bâdâ hã. Ãne hã aima waihu'u pese za'ra wa'aba di. Tawapsi te za oto dasiwi ĩ̱hâiba nhomri ni, Danho'reptui'wa da 'Re ĩhâimana u'âsi mono te te ĩ̱pisudu hã, da te dasiwi ĩ̱zasõmri da hâiwi, wedepo'o nhonhi'rãmi na. — Ãne ma tô Zezusi hã sina wama rowasu'u sirõmo za'ra, ĩsiré 're ĩwanomro mono norĩ ma. ");
INSERT INTO xavNT_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Tawamhã sasedoti ĩpire norĩ hã, duré zudezu norĩ ma roti'wa norĩ hã ma tô si'rã'õtõ, Caipasihi nhorõwa u, 'ri za'ẽtẽ u. Ta hã sasedoti ĩpire uptabi, 're ĩhâimana mono, 'Re ĩhâimana u'âsi mono ma, da'ãma romhuri'wa. ");
INSERT INTO xavNT_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Tawamhã, sitẽme si'rã'õtõ wamhã, ma tô sima ãma rosa'rata za'ra. Taha wa, te roti hã pi'uriwi siwi 'manha, Zezusi hã pi'uriwi te te siwi âri da, da te oto dasiwi wĩrĩ da. ");
INSERT INTO xavNT_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Ãne te sima ãma roti za'ra: — Dasa hã da te 'manharĩ za'ra ré, wa te wasiwi âri õ di za, wazada dazahi za'ra õ'umnhasite, wazada dahâimana za'ra tõ da. — Ãne ma tô sima ãma roti 'rãsutu za'ra. ");
INSERT INTO xavNT_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Tawamhã Zezusi hã ma tô mo, Betãnha na 'ri wa'õtõ nhisi u. Tame te oto nhamra, Simahã nhorõwa ãma, ĩ'wa're ré nhorõwa ãma. ");
INSERT INTO xavNT_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Tawamhã sai ma sãmra ré, ma tô pi'õ hã ĩtẽme wi, Zezusihi u. Wedewa'u zadaze hã ma siré sada ãwisi, ẽtẽ 'manharĩ 'remhã, simhi ne 'remhã ĩdup syryre wamhã. Wa'âbâ za'ẽtẽ di ta hã, wedewa'u zadaze hã. Wa'âbâ za'ẽtẽ nherẽ, ma tô Zezusihi 'rã nhisiwi sa'wa pi'õ hã, tãma sawi wa. ");
INSERT INTO xavNT_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","9","Tawamhã wa norĩ hã Zezusihi siré 're ĩwanomro mono norĩ hã ãne hã wa te 'madâ'â za'ra wamhã, wa tô sada ab'ru za'ra ni, pi'õ da. Taha wa, wa tô wasima ãma nharĩ za'ra ni, ãne: — Oro õ hã wa'âbâ za'ẽtẽ za, ma taré ĩ'rã nhisiwi sa'wa, wedewa'u zadaze hã. Te te dama wede 'wa'âhã, aré wa'âbâ za'ẽtẽ di. Tawamhã ĩwa'â hã te aré ĩsibrob'õ norĩ ma, te te sõmri. — Ãne wa tô wasima ãma nharĩ za'ra ni, pi'õ nhoprubzém na hã. ");
INSERT INTO xavNT_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Tawamhã Zezusi hã wa te wasima ãma ĩnharĩ za'ra zé hã te te wawi waihu'u za'ra wamhã, te ãne na wazadanharĩ za'ra: — E marĩ da, te pi'õi ma ĩnharĩ za'ra wa'wa. Tãma nharĩ za'ra wa'aba tõ. Tô'ã. Ĩ'uwaibaba ma tô ãne na hã ãma ĩ̱zawi wẽ. ");
INSERT INTO xavNT_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Ĩsibrob'õ norĩ hã te ai'rata 're si'ubumroi u'âsi 'wa, 're ĩpawaptob za'ra wa'aba mono zéb da hã. Tanei õ di, wa hã. Ai'rata 're ĩ̱nhamra u'âsi aba mono õ di za oto. ");
INSERT INTO xavNT_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Pi'õ hã wedewa'u zadaze hã ĩ̱'rã nhisiwi te te sa'wari wamhã, za ĩ̱dâ'â wa, da te dasiwi ĩ̱nherẽzéb u te te ãma ĩ̱hâiba u'ré da, ma tô ãne hã ĩ̱ma 'manha, zudezu norĩ hâimanazéb zarina. ");
INSERT INTO xavNT_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Daro mono bâ te za ĩ̱wasu'u wẽ na da te 're dapo're pu'u za'ra. Tawamhã pi'õ hã te te ĩ̱ma ĩ'manharĩ wẽ zém na zama, te za da te dasima 're wasu'u u'âsi za'ra, ãma 're dasipo're pu'u za'ra mono da. Tô sena, wa ãne aima waihu'u za'ra wa'wa. — Ãne ma tô Zezusi hã wama waihu'u za'ra, ĩsiré 're ĩwanomro mono norĩ ma. ");
INSERT INTO xavNT_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Tawamhã 12 na Zezusihi siré 're ĩwanomro mono norĩ hã misi wa tô wa'maimorĩ ni, Zudasi Icarizoti na ĩsisi hã sasedoti ĩpire norĩ u, te te sadanharĩ za'ra da. ");
INSERT INTO xavNT_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","Tawamhã ãne te sadanharĩ za'ra: — Zezusi hã ma tô asima ĩwẽ za'ra wa'wa, asiwi âri aba da. E ãne hã aima wẽ za'ra wa'aba di za, te aima ĩhâiba nhomri za'ra wa'aba da hã. Aima wẽ za'ra wa'aba wamhã, e niha te za ĩ̱ma ĩ̱wa'âbâ za'ra wa'wa. — Ãne te ãma sadanharĩ za'ra, Zudasi Icarizoti hã, 'Re ĩhâimana u'âsi mono ma, da'ãma romhuri'wa norĩ ĩpire za'ra norĩ hã. Tawamhã ãne na ãma sisaze za'ra wamhã, ma tô rob'uiprazé ĩsapotore hã tãma sa'rata za'ra, 30 na ẽtẽ'ubuzi'a prata 'manharĩ hã. Taha pari, ma tô tãma sõmri za'ra, Zudasihi ma. ");
INSERT INTO xavNT_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Tawamhã ta hawim haré te oto Zudasi hã sima ãma rob'madâ'â u'âsi, nimahã bâtâ na Zezusi te te oto dama ĩhâiba nhomrizéb da hã, danhimiza'rese ãna dahâimana za'ra ré. ");
INSERT INTO xavNT_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Tawamhã bâdâ ma tô ĩwa waptãrã, ĩ'u'ẽtẽ duptoi'õ, da te 're ĩhuri mono zé hã, Pascowa na dato nhisi hã. Taha ré, wa tô Zezusihi siré 're ĩwanomro mono norĩ hã wasina tété za'ra ni, wa te wasiwi sadanharĩ za'ra da, ãne: — E momo ma tô asima ĩrowẽ, asô ĩwanhipi za'ra zéb da hã, Pascowa na dato nhisi na ĩwasaihurizéb da hã. — Ãne, wa tô wasiwi sadanharĩ ni, Zezusi hã. ");
INSERT INTO xavNT_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Tawamhã Zezusi te asa wama nharĩ za'ra: — 'Ri ahâ u te za oto ai'aba'réi wa'wa, aibâ hã asiwi sõpẽtẽ aba da. Tawamhã ãne te za tãma ĩ̱zadawa wasu'u wa'wa: “Wama rowahutu'wa hã wa za aima sadawa wasu'u za'ra ni, ãne: ‘Ĩ̱nhibâdâ hã romhuture di oto, Ĩ̱mama te te ĩpisutuzé hã, ĩ̱'ãma. Asõrõwa ãma wa za wasa hã huri ni, ĩ̱siré 're ĩnomro mono norĩ me, Pascowa na dato nhisi na 're ĩdasaihuri mono zém na hã.’ ” Ãne te za tãma ĩ̱zadawa wasu'u za'ra wa'wa, aibâ ma. — Ãne hã ma tô Zezusi hã wama waihu'u za'ra. ");
INSERT INTO xavNT_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Tawamhã ĩsiré 're ĩwanomro mono norĩ hã wa tô ãma uwaimrami za'ra ni, te te wama ĩwaihu'u za'ra zéb zarina. Wanhipi wa tô 'manharĩ za'ra ni, Pascowa na dato nhisizém na. ");
INSERT INTO xavNT_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Tawamhã mara wamhã, wa oto asimro ni, wasiré wasaihuri da, 12 na wahâiba za'ra hã, Zezusihi me. ");
INSERT INTO xavNT_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Tawamhã wasaihuri ré, ma tô Zezusi hã wama waihu'u sirõmo za'ra, ãne: — Tô sena, wa aima waihu'u sirõmo za'ra wa'wa. Misire te za dama ĩ̱'maihâiba nhomri 'wa. ");
INSERT INTO xavNT_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Ãne, wa te wasina mreme wapari za'ra wamhã, ma tô wawi tirobzei'õ pese za'ra, ĩsiré 're ĩwanomro mono norĩ wi hã. Ãhã wamhã, misi si wa tô nasi ãma tãma romnomri za'ra ni, ãne: — Wanhib'apito, e wa hã te dama aihâiba nhomri da bâ, te ãne wama ĩnharĩ za'ra. — Ãne, wa nasi wasina tãma amrami za'ra ni, ãne na hã wasiwaihu'u za'ra õ wa. ");
INSERT INTO xavNT_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Tawamhã asa te Zezusi hã duré wama nharĩ za'ra: — Za dama ĩ̱hâiba nhomri'wa hã, ĩ'u'ẽne hã te za piza'a 're ĩ̱siré di'i. ");
INSERT INTO xavNT_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Wa hã ti'ai ãma dasiré ĩ̱podo hã duréihã ma tô ĩ̱dâ'âzém na rob'ui'éré sirõmo za'ra, 'Re ĩhâimana u'âsi mono zadawa wasu'u'wa norĩ hã. Ta norĩ hã te te ĩ̱'ãma ĩrob'ui'éré za'ra zéb zarina wa za ãma mo tô, ĩ̱dâ'âzéb u. Tane nherẽ, aibâ ma, tãma 're ropipa uptabi mono di za, za te te dama ĩ̱hâiba nhomri'wai ma hã. 'Re ĩhâimana u'âsi mono za te te azâri wamhã, te za sima rosa'rata, ãne: “Ĩ̱poto õ 'wa'âhã, aré wẽ di. E marĩ wa. Ãne na te 're robzépata mono õ wa aré.” Ãne te za 'râwi si'ãma rosa'rata, za dama ĩ̱hâiba nhomri'wa hã. — Ãne ma tô Zezusi hã wama waihu'u za'ra. ");
INSERT INTO xavNT_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Tawamhã Zudasi hã dama ĩsõmri'wa da hã te Zezusi hã sina sadanha, ãne: — Rowahutu'wa, e wa hã za te dama ĩ'aihâiba nhomri na, ma tô asina ĩ̱waihu. Tawamhã asa te Zezusi hã tãma tinha: — Tane tô. Asi'uihâ na ma tô ãne na hã asiwaihu. — Ãne ma tô Zezusi hã tizadawa na tãma wa'rã. ");
INSERT INTO xavNT_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Tawamhã wasaihuri ré, ma tô ĩ'u'ẽne hã ti'â, Zezusi hã. 'Re ĩhâimana u'âsi mono ãma te ĩré ãma tiwata, sõpru wa. Taha pari, ma tô te te wẽ'ẽ, ĩ'u'ẽne hã. Te te wẽ'ẽi mono parimhã, ma tô te te wama sõmri, ĩsiré 're ĩwanomro mono norĩ ma. Ãne te oto wama nharĩ za'ra: — Ã, ĩ'u'ẽne hã huri aba. Ã hã ĩ̱hâiba te wasu'u. — Ãne ma tô Zezusi hã sina wama waihu'u za'ra. ");
INSERT INTO xavNT_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Taha pari, hâsizé hã ma duré ti'â, uwa 'ru 'rãi wa'u ĩsé ré hã. 'Re ĩhâimana u'âsi mono ãma te duré tiwata, sõpru wa. Taha pari, ma tô ĩré te te wama sõmri, uwa 'rãi wa'u ĩsé ré hã. Ãne te duré wama nharĩ za'ra: — Ã, rob'rãi wa'u hã âhuri aba, aihĩni. ");
INSERT INTO xavNT_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Ã hã ĩ̱wapru, te wasu'u. Rob'rãi wa'u za'wari ne, te za ĩ̱wapru hã ĩ̱wi asa'wa, da'ahâ zada ĩ̱dâ'â wamhã, 'Re ĩhâimana u'âsi mono hã dawasédé hã te te oto 're ab'madâ'â tõ mono da, da'ãma. Ã hã ĩ̱wapru, ĩ̱wi sisa'wari wamhã, 'Re ĩhâimana u'âsi mono hã tinhib'a'uwẽ ma, te te tãma ĩropisutuzé hã tô sena za te te tãma ãma 're ĩ'uwaimrami mono zé, te wasu'u. ");
INSERT INTO xavNT_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Tô sena, wa za aima ĩ̱siwasu'u za'ra wa'wa. Ãne hã rob'rãi wa'u te 're hâsi mono õ di za oto, a'â. Niwapsi Ĩ̱mama hã uburé da'ãma 're sib'a'uwẽ mono wapsi, wa za duré te 're hâsi, asiré wa'aba. — Ãne ma tô wama siwasu'u za'ra, ĩsiré 're ĩwanomro mono norĩ ma. ");
INSERT INTO xavNT_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Tawamhã wanho're na wa tô ãma wawata za'ra ni, 'Re ĩhâimana u'âsi mono ãma. Wanho're za'ra parimhã, wa tô wawairébé ni, Oriwera na ẽtẽ 'rãihâ nhisi u wasi'aba'ré da. ");
INSERT INTO xavNT_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Tawamhã Zezusi hã ma tô ĩsiré 're ĩwanomro mono norĩ ma rowasu'u za'ra, ãne: — A norĩ wa'wa hã ã barana, niha ĩ̱ma romhâimana wamhã, te za aihĩni asiwi ĩ̱rẽme 'wa. Duréihã 'Re ĩhâimana u'âsi mono zadawa wasu'u'wa hã ma tô ãne na ĩ̱'ãma rob'ui'éré siro, 'Re ĩhâimana u'âsi mono mreme na hã: “Pone'ẽrebâ 'madâ'â'wa hã wa za tĩwĩ. Tawamhã pone'ẽrebâ hã te za ropé.” Ãne na duréihã 'Re ĩhâimana u'âsi mono mreme na rob'ui'éré, ĩbaihâ na hã. ");
INSERT INTO xavNT_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Tane nherẽ, asiwi ĩ̱rẽme aba nherẽ, ab're hawi apâ ĩ̱hâiwa'utu parip si, wa za aiwana ĩ̱morĩ 'wa, Darireza na danhipti'a nho'õmo nhisi u, tamomo ĩ̱nhopẽtẽ za'ra wa'aba da. — Ãne ma tô Zezusi hã wama siwasu'u za'ra, ĩsiré 're ĩwanomro mono norĩ ma. ");
INSERT INTO xavNT_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Tawamhã Pedru, te Zezusihi ma tinha: — Asiré 're ĩwanomro mono norĩ hã aihĩni za te te airẽme za'ra nherẽ, wa hã te dame airẽme õ di za. ");
INSERT INTO xavNT_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Tawamhã Zezusi te asa tãma tinha, Pedruhu ma: — Tô sena wa za aima rowasu'u. Ãma aipo're pu'u za. Ã barana si'a hârâ õ ré, te za si'ubdatõ dawi ĩ̱'udâ, aima ĩ̱za'rese õ na. ");
INSERT INTO xavNT_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Tawamhã Pedru te duré tãma tinha, Zezusihi ma: — Wa hã asiré ĩ̱dâ'â da nherẽ, te dawi ai'udâ õ di za, te ĩ'aiwaihu'u õ na hã. — Ãne ma Pedru hã tizadawa na tãma wa'rã. Tawamhã õhõ na si, wa tô wa norĩ hã ĩsiré 're ĩwanomro mono norĩ hã tãma wasiwasu'u za'ra ni, za wa te dawi ĩ'udâ za'ra õ na hã. ");
INSERT INTO xavNT_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Tawamhã Zezusihi me, wa tô ai'aba'ré ni oto, Zésemani na rob're nhisi u. Wasihutu wamhã, ma tô wama nharĩ za'ra, ĩsiré 're ĩwanomro mono norĩ ma, ãne: — Ãme ĩ̱zô asimroi wa'aba. Õwa wa za a'â mo asiti wa'aba, romnhiwasi Ĩ̱mama ma, ĩ̱mreme da. — Ãne ma wama siwaihu'u za'ra, Zezusi hã. ");
INSERT INTO xavNT_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Tawamhã Pedru hã te siré saprõ, Zebedehe 'ra norĩ me. Tawamhã ma tô tiwi tirobzei'õ pese, Zezusihi wi. Za te te ĩrobzépatazé hã ma tô sima simimnhasi. ");
INSERT INTO xavNT_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Tawamhã Pedru norĩ ma, te rowasu'u, Zezusi hã: — Ĩ̱pẽ'ẽzé hã sa'ẽtẽ na te ĩ̱ma tihâiba. Ĩ̱pẽ'ẽzé uptabi wa, wa aré dârâ. Ãme a'â asimroi wa'aba ĩ̱'rata, asõtõ ãna. Asõpré u'âsi aba. — Ãne ma tãma waihu'u za'ra, Pedru norĩ ma. ");
INSERT INTO xavNT_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Tawamhã romhâ prã na ma tô ĩsiti timorĩ za'ra, Zezusi hã. Dumana na te nomro ti'ai wa, Timama ma, mreme da. Ãne te tãma mre: — Ĩ̱mama, asima wẽ wamhã, ĩ̱ma ba'a, ĩ̱dâ'âzé hã te sépata tõ da. Tane nherẽ, te ĩ̱sima ĩwẽzéb uwaibaba, ĩ̱ma pisutu õ di za. Asima ĩwẽzéb uwaibaba si, te 'manharĩ da hã, ĩ̱ma wẽ di. — Ãne te Timama ma siwasu'u, Zezusi hã. ");
INSERT INTO xavNT_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","41","Tawamhã Timama ma mreme pari, ma tô apâ mo, Pedru norĩ u. Sõtõ za'ra ré, ma tô siza za'ra. Tawamhã Pedruhu ma, te tinha, Zezusi hã: — E niha asimiza'rese syry na asãmra da hã, aima waihu'u õ di, ĩ̱siré. Satanasihi zada, asiptete sina 're aihâimana za'ra wa'aba mono da, asima 're wẽ za'ra wa'aba mono nherẽ, asi'uihâ na sada 're asiptete waihu'u za'ra wa'aba mono õ di. Taha wa, asimiza'rese te za ai'ubumroi wa'wa ãhãna hã, 'Re ĩhâimana u'âsi mono wi, asima rowaptẽrẽ za'ra wa'aba da, Wa'uburé nhimiwada'uri wasété wi, te te aipawaptob za'ra wa'aba da. — Ãne ma tô Zezusi hã tãma waihu'u za'ra. ");
INSERT INTO xavNT_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Tawamhã te duré romhâ prã na ĩsiti timorĩ za'ra, Timama ma mreme da. Ãne te tãma mre: — Ĩ̱mama, ĩ̱dâ'âzé hã te sépata da, asima wẽ wamhã, ĩ̱ma wẽ di duré, asima ĩwẽzéb uwaibaba, ĩ̱ma pisutu da. — Ãne te Timama ma siwasu'u, Zezusi hã. ");
INSERT INTO xavNT_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Timama ma mreme pari, te duré apâ mo, Pedru norĩ u. Sõtõ za'ra ré, ma duré siza za'ra. Aptâ'â si te huri u'âsi, sõpré waihu'u ãna. ");
INSERT INTO xavNT_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Tawamhã apâ te duré ĩsiti timorĩ za'ra Zezusi hã, Timama ma mreme da. Si'ubdatõ ma oto sina siri. Tô õhõ na si te tãma mre, tãma ĩmreme na'rata zéb zarina. ");
INSERT INTO xavNT_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Tawamhã apâ te duré mo, Pedru norĩ u. Ãne te duré tãma nharĩ za'ra: — E niha bâ te zahadu asõtõ za'ra wa'wa bété. Ma'ãpé, waihu'u za'ra wa'aba. Romhuture di oto bâdâ hã, Ĩ̱mama te te ĩ̱'ãma ĩpisutuzé hã. Wa hã ti'ai ãma dasiré ĩ̱podo hã te za aibâ hã tãma ĩ̱hâiba nhomri za'ra oto, aibâ ĩwasété norĩ ma. ");
INSERT INTO xavNT_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Oto aiwahutu za'ra wa'aba. Wasi'aba'réi hâ. Õhõta te we oto mo, dama ĩ̱hâiba nhomri'wa da hã. — Ãne ma Zezusi hã sina tãma waihu'u za'ra, tisiré norĩ ma. ");
INSERT INTO xavNT_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Tawamhã Zezusi hã zahadu te te rowasu'u ré, ma we Zudasi hã sô wi, aré ĩsiré 're ĩwanomro mono norĩ siré, 12 na wahâiba za'ra siré hã. Da'ahâ na te duré we ĩsiré ai'aba'ré ni, sib'ézé 'wa pa ré, uibroi ré zama. Sasedoti ĩpire norĩ zadawa para te we ai'aba'ré, zudezu norĩ ma roti'wa norĩ zadawa para zama. ");
INSERT INTO xavNT_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Ãne ma tô Zudasi hã tãma waihu'u za'ra, te te siwi ĩ'âri wana ré hã: “Aibâ hã te tob'rata hârâ wamhã, ta hã te za asiwi ĩ'âri 'wa.” Ãne ma tô dama waihu'u, te te ãma ĩrosa'ratazém na hã, Zudasi hã. ");
INSERT INTO xavNT_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Tawamhã wisi wi, ma tô ĩtẽme mo õne haré, Zezusihi u, awa'awi. Ãne te sawi, timreme na: — Rowahutu'wa, rowẽ na 're aihâimana mono. Tawamhã tob'rata hârâ na ma tô sawi, Zezusi hã. ");
INSERT INTO xavNT_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Tawamhã Zezusi asa te tãma tinha, ãne: — Ĩ̱siwadi, te we tô ĩ̱zô aimo, marĩ hã ĩ̱'ãma 'manharĩ da. Ma'ãpé, niha ĩ̱ma rob'manharĩ su'u. Tawamhã ma tô sô ai'ré za'ra oto, Zezusihi zô, te te siwi âri da. Te te siwi âri wamhã, ma tô siwi pawasisi. ");
INSERT INTO xavNT_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Tawamhã Zezusihi siré 're ĩmorĩ hã ĩ'rata ĩsa hã ma tô sib'ézé 'wapa waze. Te te wazere wi, ma romhuri'wa hã ãma po're nhizâ, sasedoti ĩpire uptabi ma, romhuri'wa hã. ");
INSERT INTO xavNT_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Tawamhã Zezusi te tãma tinha, ĩ'u'a'wai ma: — Ma'ãpé, sib'ézé 'wapa hã apâ sẽrẽ. Ni'wam norĩ hã sib'ézé 'wapa na te te 're danhimroi mono wamhã, asa sib'ézé 'wapa na te za da te 're simro, tô te te ãma 're ĩdanhimroi mono zéb zarina. ");
INSERT INTO xavNT_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Te ĩ̱sima wẽ 'wa'âhã, wa aré Ĩ̱mama wi waptẽ, hâiwa ãma tãma ĩromhuri'wa norĩ hã ahâ uptabi na te te we ĩ̱tẽme satõrĩ za'ra da, ãhãna ĩ̱'ãma sisaprĩ za'ra da, dawi. E ãne na ĩ̱'ãma rosa'rada hã waihu'u õ di bété. ");
INSERT INTO xavNT_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Ĩ̱'ãma dawi sisaprĩ za'ra wamhã, 'Re ĩhâimana u'âsi mono hã te te ĩ̱'ãma uwaimrami õ di aré, duréihã ĩsadawa wasu'u'wa norĩ te te ĩ̱'ãma ĩrob'ui'éré za'ra zéb zarina hã, za niha ĩ̱'ãma ĩromhâimanazém na hã. Taha wa, te tiwi waptẽrẽ õ di za, Ĩ̱mama wi. — Ãne ma tô Zezusi hã tãma waihu'u, sib'ézé 'wapa na te te ĩda'mai'u'a ma. ");
INSERT INTO xavNT_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Tawamhã Zezusi hã te oto dama rowasu'u, ãne: — E wa hã danhibrob zô dapãrĩ'wa pâ, ma bété we ĩ̱zô aihutu 'wa, sib'ézé 'wapa ré, uibroi ré zama. Bâtâ sidâpâsi wa tô asõ'a wa'aba 're ĩ̱simasisi, 'Re ĩhâimana u'âsi mono ãma 're ĩdawata za'ra mono zéb ãma 'ri 'wawi wa'ra 're, te dama 're rowahutu mono da. Zapre bété, tameb ré asiwi ĩ̱'âri za'ra wa'aba õ di. ");
INSERT INTO xavNT_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Tane tô. Ãne hã ma tô ĩ̱'ãma tiromhâiba ãhãna hã, duréihã 'Re ĩhâimana u'âsi mono zadawa wasu'u 'rata 'wa norĩ nhimi'ui'éré hã te te ĩ̱'ãma uwaimrami da. — Ãne te dama siwasu'u, Zezusi hã. Tawamhã ĩsiré 're ĩwanomro mono norĩ hã wa tô oto rẽme za'ra ni. Wawara sina wa dawi wasisa're. ");
INSERT INTO xavNT_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Tawamhã Zezusi, da te oto dasiwi âri wamhã, ma tô dasiwi saprõni ni, Caipasihi nhorõwa u, 'Re ĩhâimana u'âsi mono ma da'ãma romhuri'wa ĩpire uptabi nhorõwa u, sasedoti ĩpire uptabi u. Tame ma tô sô si'rã'õtõ, 'Re ĩhâimana u'âsi mono nhimiroti 'rata na rob'ui'éré na dama rowahutu'wa norĩ hã, duré dama roti'wa norĩ hã. ");
INSERT INTO xavNT_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Zezusi hã da te dasiwi saprõni ré, te Pedru hã romhâ na te te pibu. Sasedoti ĩpire uptabi nhorõwa u, te ĩsarina mo. Wisi wamhã, 'ri 'wawi wa'ra 're, ma ãzé. Sébré wamhã, tame te dame nhamra rowi, 'Re ĩhâimana u'âsi mono nhorõwa 'madâ'â'wa norĩ me. Zezusi hã te te 'madâ'â da, te nhamra, niha da te tãma rob'manharĩ õ'umnhasite. ");
INSERT INTO xavNT_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Tawamhã sasedoti ĩpire norĩ hã, duré uburé zudezu norĩ ma roti'wa norĩ hã, te ni'wam norĩ zô tinhopré, Zezusi hã marĩ te te 're ĩ'ab'manharĩ wasété mono zém na, sadawa nhipese na te te siwi ãma hiri da, tawapsi romanu norĩ hã te te siwi wĩrĩ da. ");
INSERT INTO xavNT_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Tawamhã da'ahâ na ma tô taré Zezusihi ãma ĩwasédé hã sa'ra ni, dama roti'wa norĩ nho'a. Tane nherẽ, ãma dasisaze za'ra õ di, ĩwasédé hã dasisõ'a da te ãma ĩsa'ra za'ra zém na hã, taha zarina si, da te oto dasiwi ĩwẽ'õzéb da hã. Taré te nasi ĩwasédé hã ãma sa'ra ni, dazadawa nhipese na. Tawamhã aibâ norĩ hã ma tô sipisutu zahuré, dama ĩpire norĩ nho'a, ĩwasédé hã te te ãma ĩhiri zahuré zéb da hã. ");
INSERT INTO xavNT_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","Ãne te oto wasu'u zahuré Zezusi hã, ĩsõ'a za'ra: — Ã hã aibâ hã ma tô ãne dama siwasu'u, sadawa nhipese na: “Wa hã ĩ̱ma waihu'u pese di, ã hã 'ri 'rãihâ hã te sãmra da, 'Re ĩhâimana u'âsi mono ãma 're ĩdawata za'ra mono zé hã, duré apâ te 'ri su'u da, si'ubdatõ bâdâ hã ĩ̱'ãma si'utõrĩ õ ré, te 'ri pari da.” Ãne ma tô dama siwasu'u. — Ãne te aibâ norĩ hã Zezusi hã taré wasu'u zahuré. ");
INSERT INTO xavNT_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Tawamhã sasedoti ĩpire uptabi hã ma tô hâiwi za, dawa'wa. Ãne te sadanha, Zezusi hã: — E asadawa na dama ãma wa'rãmi ãna, da te dasiwi ĩ'aiwasu'u wasété na hã. E tô ĩsarina ma tô aiwasédé hã ai'ãma hiri zahuré. E taré. — Ãne te sadanha. ");
INSERT INTO xavNT_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Tane nherẽ, te Zezusi hã ari'iwi za. Tawamhã sasedoti ĩpire uptabi hã te duré sadanha: — E a hã Danho'reptui'wa da, 'Re ĩhâimana u'âsi mono te te ĩ'aipisudu. E a hã 'Re ĩhâimana u'âsi mono 'ra. Ma'ãpé sena na wama asiwasu'u na. Wawi ai'udâ tõ, 'Re ĩhâimana u'âsi mono nho'a. ");
INSERT INTO xavNT_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Tawamhã Zezusi te asa tãma tinha: — Tahata ma tô tane hã tô ĩ̱'ãma ĩwaihu. Ãne wa za duré aima ĩ̱siwasu'u za'ra wa'wa. Wa hã dasiré ĩ̱podo hã te za asiwi ĩ̱'madâ'â za'ra wa'wa, ĩwaihu'u pese uptabi nhimire niwĩ 're ĩ̱nhamra mono na, dama ĩ̱pire na. Hâiwa'a na apâ we ĩ̱morĩ wamhã, te za ãne na ĩ̱'madâ'â za'ra wa'wa. — Ãne ma tô Zezusi hã tãma siwasu'u za'ra. ");
INSERT INTO xavNT_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Tawamhã sasedoti ĩpire uptabi hã, Zezusihi mreme te te wapari wamhã, ma tô ti'uza hã hâiwazu, te te wẽ'õ wa, tipẽ'ẽ na sada sahi wa. Tawamhã ĩsi'rã'õtõ norĩ ma, te oto tinha, ãne: — Tâibâ oto. Aibâ aimawi norĩ zô, ai'maihârâ aba õ di za, Zezusi te te wama ĩwasu'u za'ra da hã, ĩwasété na. 'Re ĩhâimana u'âsi mono newa, si'uihâ na ma tô tiwaihu'u pe hã sina tihi, wasine 're hâimana mono nherẽ. Si'uihâ na ma tô timreme wasété. Ĩmreme ma tô ĩwapari za'ra wa'wa. ");
INSERT INTO xavNT_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","E marĩ tawamhã, ma tô ãma ĩpisutu za'ra wa'wa. — Ãne te ãma da'a'mahâ. Tawamhã asa te tãma nharĩ za'ra: — Tiwasédé hã ma tô 'manha. Te za tô dârâ. ");
INSERT INTO xavNT_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Tawamhã te te oto siwi wẽ'õ pese za'ra wa, ma tô tizadaipro na nasi siwi ubu uptob za'ra. Tinhib'rata hi'rãti na, te duré nasi siwi ahâ. Tinhib'rata na te duré nasi ĩ'ubu wi siwi ahâ. ");
INSERT INTO xavNT_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","Tawamhã te te nasi siwi ahâri sina, te nasi 'mahârâ za'ra, ãne: — A hã danho'reptui'wai wamhã, ma'ãpé ai'azâri'wa norĩ hã wama wasu'u za'ra na. — Ãne te nasi ãma wa'ẽ za'ra sina 'mahârâ za'ra. ");
INSERT INTO xavNT_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Tawamhã Pedru, 'ri 'wawi wa'ra 're, rowi sãmra ré, ma tô pi'õ hã 'râwi ĩtẽme za. Sasedoti ĩpire uptabi ma romhuri'wa, pi'õ hã. Ãne te tãma tinha, Pedruhu ma: — A zama te Zezusihi siré 're aimo, Darireza ãma aré 're ĩsãmra mono siré. ");
INSERT INTO xavNT_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Tawamhã Pedru te tiwi ai'udâ, uburé danho'a, ãne: — Te waihu'u õ di, we ĩ̱ma ĩnharĩ hã. — Ãne ma pi'õi ma, asa tizadawa na wa'rã. ");
INSERT INTO xavNT_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Tawamhã te oto mo, 'ri 'wawi wa'ra ãma 'ridawa u. Tame sãmra ré, ma tô duré pi'õ ĩhâiba amo hã tisã Pedru hã, 'Re ĩhâimana u'âsi mono ma da'ãma romhuri'wa norĩ nhib'apito ma romhuri'wa hã. Te te sãmri wamhã, ĩ'rata ĩsimasam norĩ ma, te wasu'u za'ra, ãne: — Õ hã Zezusihi siré 're ĩmorĩ, Nazaré ãma aré 're ĩsãmra mono siré. ");
INSERT INTO xavNT_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Tawamhã Pedru te duré dawi ai'udâ, ãne: — Tô sena, wa aima ĩ̱siwasu'u za'ra wa'wa, 'Re ĩhâimana u'âsi mono nho'a. Ta hã ĩ̱ma sa'rese õ di, aibâ hã. ");
INSERT INTO xavNT_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Tawamhã syry na ãma ronomro wi, ma duré ĩ'rata ĩsimasam norĩ hã 'râwi ĩtẽme aimasa Pedruhu u, te te tãma nharĩ za'ra da, ãne: — Darireza ãma 're ĩdamreme zusi mono ne, aimreme hã. Taha wa, wa tô wasiwi aiwaihu'u ni, Darireza ãma aré 're asãmra mono na. Taha wa, tô sena wa tô duré wasiwi aiwaihu'u ni, Zezusihi siré 're ĩnomro mono norĩ siré 're aimorĩ na. — Ãne hã ma tô tãma waihu'u za'ra, Pedruhu ma. ");
INSERT INTO xavNT_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Tawamhã Pedru te asa tãma nharĩ za'ra, ãne: — Mare di. Tane na ĩ̱waihu'u nherẽ, õ hã ĩ̱ma sa'rese õ di. Tô sena te aiwi udâ za'ra wa'aba di pâ, 'Re ĩhâimana u'âsi mono te te ĩ̱'azâri pé. — Ãne te tãma sina waihu'u za'ra. Tawamhã ãne na dama siwasu'u wi, ma tô si'a hã hârâ watobro, awa'awi. ");
INSERT INTO xavNT_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Tawamhã Zezusi te te tãma ĩwaihu'uzém na ma sina po're puru, Pedru hã. Ãne Zezusi te te tãma ĩwaihu'u sirõmo zé hã, ĩsõwa: “Si'a hã hârâ õ ré, si'ubdatõ te za dawi ĩ̱'udâ, ĩ̱zadawa para õ nherẽ.” Ãne Zezusi hã te te tãma ĩwaihu'u sirõmo zé hã. Tawamhã ãne na oto ĩmreme na sina po're pu'u wamhã, ma tô watobro rob u, Pedru hã. Taha wa, te oto aiwa'õ, sina pẽ'ẽzé uptabi wa. ");
INSERT INTO xavNT_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Tawamhã mararé ma uburé sasedoti ĩpire norĩ hã, duré zudezu norĩ ma roti'wa norĩ hã si'rã'õtõ, te te sima ãma roti za'ra da, Zezusihi ãma, te te dama sõmri za'ra da, da te dasiwi ĩwĩrĩzéb da hã. Taha da, te roti hã sima 'manharĩ za'ra, Zezusihi hâiba na. ");
INSERT INTO xavNT_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Tawamhã sasedoti ĩpire norĩ zadawa para, ma tô Zezusi hã dasiwi pawasisi ni, da te dasiwi saprõni da, Piratuhu u. Ta hã Zudeza na danhipti'a nho'õmo nhisi ãma da'madâ'â'wa, romanu norĩ nhib'apito uptabi nhimipisudu. Tawamhã ĩtẽme da te dasiwi ãwisi wamhã, ma tô tãma hâiba nhomri ni, Zezusi hã, Piratuhu ma. ");
INSERT INTO xavNT_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Tawamhã Zudasi, dama ĩhâiba nhomri'wa hã, Zezusi dâ'â da, da te dasiwi ĩpisutu na siwaihu'u wamhã, ma tô si'ruiwapa. Taha wa, 30 na rob'uiprazé ĩsapotore hã ẽtẽ'ubuzi'a prata 'manharĩ hã ma tô apâ tãma sõmri za'ra, sasedoti ĩpire norĩ ma, duré zudezu norĩ ma roti'wa norĩ ma zama. ");
INSERT INTO xavNT_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Tawamhã ãne ma tô tãma siwaihu'u za'ra: — Ĩ̱wasédé hã wa tô 'manha, ãhãna hã. Marĩ hã te te 'manharĩ wasété õ nherẽ, wa tô aima hâiba nhomri za'ra wa'wa, asiwi wĩrĩ aba da. — Ãne na ma tô tãma siwẽ'õ za'ra Zudasi hã, dama ĩpire norĩ ma. Tawamhã asa te tãma nharĩ za'ra: — E marĩ, wa te wasiwi ãma 'manharĩ da bâ. E wate bâ. Ta hã ate hã. Asiwaprosi ma aiwasédé hã ãma ĩ'manha. — Ãne ma asa tãma waihu'u za'ra, Zudasihi ma. ");
INSERT INTO xavNT_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Tawamhã Zudasi hã rob'uiprazé ĩsapotore ma tô sãmra, 'Re ĩhâimana u'âsi mono ãma 're ĩdawata za'ra mono zéb ãma, 'ri para. Te te sãmra pari, ma tô watobro rob u. Tawamhã siwĩrĩ da, ma tô 'râwi sisõ'reti, wedenhorõ na. ");
INSERT INTO xavNT_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Tawamhã 'Re ĩhâimana u'âsi mono ma, da'ãma romhuri'wa norĩ ĩpire za'ra hã ma tô rob'uiprazé ĩsapotore hã siwi waibu, sasedoti ĩpire norĩ hã. Te te siwi waibui wamhã, ma tô sima ãma roti za'ra, ãne: — Ã hã rob'uiprazé hã dawaprui wa'âbâzé. Taha wa, 'Re ĩhâimana u'âsi mono nhimiroti na Mozési te te ãma ĩrob'ui'érézéb zarinai õ wa, rob'uiprazé nhemezéb 're, wa te wasiwi sẽrẽ waihu'u õ di za, wedehâpâ 're, 'Re ĩhâimana u'âsi mono ãma 're ĩdawata za'ra mono zéb te, danhoprubzé wazari. — Ãne ma tô sima ãma rowaihu'u za'ra. ");
INSERT INTO xavNT_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Taha wa, ãma sisaze za'ra parimhã, tô õhõ na rob'uiprazém na ti'a hã ma tô siwi uipra, zé na piza 'manharĩ'wa nhipti'a hã. Darob amoi hawi, Zeruzarẽ u 're ĩdasihutu mono norĩ hã tame 're dadâ'â za'ra mono wa, adâ da te 're ĩséme mono zéb da hã, ma siwi uipra, ãma. ");
INSERT INTO xavNT_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Taha wa, ti'a hã Dawaprui wa'âbâ na da te dasiwi ĩ'uipra na te oto da te 're sisi za'ra. ");
INSERT INTO xavNT_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","10","Ãne ma tô tiromhâiba, duréihã 'Re ĩhâimana u'âsi mono zadawa wasu'u 'rata 'wa hã te te ãma ĩrowaihu'u sirõmo zéb zarina, Zeremiasi na ĩsisi hã. Ãne na ma tô ãma rob'ui'éré siro, duréihã: “Tawamhã 30 na rob'uiprazé ĩsapotore hã ma tô ubuni na siwi ti'â, zé'a na piza 'manharĩ'wa nhipti'a hã te te siwi ãma uipra da. Taha wa, ma tô Izarazéhé nhihudu norĩ hã siwi pisutu, 30 na te te tãma ĩwa'âbâ za'ra zéb da hã. Ãne ma tô 'manharĩ za'ra, 'Re ĩhâimana u'âsi mono te te ĩ̱ma ĩ'ruzéb zarina, te tãma 'ru za'ra da.” Ãne duréihã ma tô Zeremiasi hã ãma rob'ui'éré siro, ãne na hã. ");
INSERT INTO xavNT_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Tawamhã Zezusi hã Zudeza ãma da'madâ'â'wa nho're, te oto za, Piratuhu nho're. Tawamhã Piratu te sadanha, ãne: — E a hã, zudezu norĩ nhib'apito. Tawamhã Zezusi te asa tãma tinha: — Tahata ma tô tane hã tô ĩ̱'ãma ĩwaihu. — Ãne ma asa tizadawa na tãma ãma wa'rã. ");
INSERT INTO xavNT_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Tawamhã sasedoti ĩpire norĩ hã duré dama roti'wa norĩ hã ma tô siwi wasu'u wasété za'ra Zezusi hã, Piratuhu ma. Tane nherẽ, Zezusi hã tizadawa na te te tãma ãma wa'rãmi za'ra õ di, asa. ");
INSERT INTO xavNT_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Tawamhã Piratu te oto sadanha: — E asina dazadawa 'rui õ di bété, da te nasi dasiwi aiwasu'u wasété za'ra zém na hã. E asi'uihâ na asadawa na wa'rãmi ãna, dama. — Ãne ma tô aré Piratu hã Zezusihi ma waihu'u. ");
INSERT INTO xavNT_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Tawamhã dama ĩpire norĩ hã te te nasi siwi wasu'u wasété za'ra nherẽ, tizadawa na te te ãma wa'rãmi õ di, Zezusi hã. Te te ãma wa'rãmi õ uptabi di. Ãne wa, ma tô apito Piratu hã ãma titob'uzu, Zezusihi ãma. ");
INSERT INTO xavNT_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Pascowa na dasai 'manharĩzép sidâpâsi, ma tô apito Piratu hã misi si te te 're da'azani, dazazém hawi, da te tiwi 're ĩwaptẽrẽ za'ra mono zéb zarina. ");
INSERT INTO xavNT_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Aibâ hã dazazéb 're, te dame 're sa, Barabasi na ĩsisi hã, ĩhâimana wasété na dama ĩwaihu'u pe hã. ");
INSERT INTO xavNT_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","18","Zezusi hã ĩwẽ na si te te dama 're rowahutu mono 'ru te, ma tô zudezu norĩ ma ĩpire za'ra norĩ hã te te siwi 're 'ruiwapari, õ norĩ upana Zezusihi ãma si 're datob'uzu za'ra mono 'ru te. Ãne zarina ma tô siwi hâiba nhomri za'ra tãma, apito Piratuhu ma. Ãne na da te dasiwi 're ĩ'ruiwapari za'ra mono zéb zarina, da te tãma ĩhâiba nhomri na ma tô apito Piratu hã ãma da'awaihu'u. Taha wa, te ãne ãma da'azadanha, da'ahâ na, ĩtẽme dasi'rã'õtõ wa: — E 'wa hã te tawamhã asima ĩwẽ za'ra wa'wa, te tãma ĩrob'ru da hã. E Barabasi. E Zezusi, Danho'reptui'wa da, 'Re ĩhâimana u'âsi mono te te ĩpisutu na da te 're ĩsisi za'ra mono. — Ãne te ĩhâiba na zahuré ãma da'azadanha, Piratu hã. ");
INSERT INTO xavNT_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Tawamhã Piratu hã te te 're ĩda'awaihu'u mono zéb da, roti ma, 're ĩsimasisi mono zéb ãma sãmra ré, ma tô ĩmro hã timreme hã tãma tisõ. Ãne ma tãma waihu'u: — Ma'ãpé ãma rosazâri, aibâ ãma. Ta hã tiha te te 're ab'manharĩ mono õ di. Barana hã ĩ̱nhotõ 'rowi te ĩsawẽrẽzém na hã wa tô ãma robzépata za'ẽtẽ, taha na hã. Ãma ĩ̱pẽ'ẽzé uptabi di. Taha wa, te za ãma ĩrosazâ. — Ãne na ma tô ĩmro hã tãma sadawa wasu'u ni, Piratuhu ma. ");
INSERT INTO xavNT_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Ãne ré, ma tô sasedoti ĩpire norĩ hã duré dama roti'wa norĩ hã da'ahâ norĩ ma 're sadawa si'aba'ré za'ra, Barabasihi si Piratuhu wi, da te waptẽrẽ za'ra da, dazazém hawi te te tãma rob'ru da, duré Zezusihi si te te dama hâiba nhomri da, taha si da te dasiwi wĩrĩ da, ĩsadawa para. ");
INSERT INTO xavNT_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Tawamhã apito Piratu hã ma tô duré da'mahârâ na sahu, ãne: — E 'wa hã te tawamhã asima ĩwẽ za'ra wa'wa, te aima tãma ĩrob'ru za'ra wa'aba da hã, dazazém hawi aima watobro za'ra wa'aba da. Tawamhã asa te tãma nharĩ za'ra ni: — Barabasihi ma, rob'ru na, taha si dazazém hawi watobro da. ");
INSERT INTO xavNT_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Tawamhã Piratu te duré ãma da'azadanharĩ zahu, ãne: — E marĩ, wa za tawamhã aima ãma pisutu za'ra wa'wa, Zezusihi ãma hã, Danho'reptui'wa da, 'Re ĩhâimana u'âsi mono te te ĩpisutu na da te 're ĩsisi za'ra mono ãma hã. Tawamhã aihĩni ma tô ãne ãma 'mahârâ za'ra ni: — Wedepo'o nhonhi'rãmi na da te dasiwi sasõmri, dâ'â da. ");
INSERT INTO xavNT_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Tawamhã Piratu te duré asa dama tinha: — E marĩ te te 're ab'manharĩ wasété mono bâ. — Ãne te dama tinha, asa. Tane nherẽ, ãne na hã da te wapari õ di. Dahârâ 'rãihâ na te oto nasi 'mahârâ za'ra ni: — Wedepo'o nhonhi'rãmi na da te dasiwi sasõmri, dâ'âre da. — Ãne te dahârâ 'rãihâ na nasi dasiwi 'mahârâ u'âsi ni, Zezusihi hâiba na. ");
INSERT INTO xavNT_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Tawamhã Piratu, marĩ hã te te oto ãma waihu'u õ di, da te oto dasiwi ãma ĩrosazârizéb da hã. Aihĩni te oto õhõ da si tahâimana za'ra ni, Zezusihi da, dazahi uptabi na. Ãne na te te sina waihu'u wamhã, ma tô piza'a zô da'mazatõ, ãma sisimisõ da, uburé danho'a. Tawamhã Zezusihi ãma marĩ ĩwasédé hã te te ĩ'manharĩ õ na aihĩni da te ĩwaihu'u za'ra zéb da hã, ma tô danho'a sisimisõ. Ãne te duré dama siwasu'u: — Zezusi hã da te wĩrĩ da, te dama 'rui wamhã, ĩ̱wasédé hã te 'manharĩ õ di za, wa hã. Mare di. Ate za'ra wa'aba si, ta hã. — Ãne te Piratu hã dama siwasu'u. ");
INSERT INTO xavNT_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Tawamhã asa te tãma nharĩ za'ra ni: — Wẽ di tô. Wa te wasiwi ĩwaptẽrẽzéb zarina, da te dasiwi wĩrĩ wamhã, 'Re ĩhâimana u'âsi mono te te wahâ za'ra pé tô, wa'ra norĩ zama wanhihudu norĩ zama, wawasédé hã wa te ãma 'manharĩ za'ra di pâ. — Ãne ma asa tãma tasiwaihu'u za'ra ni, Piratuhu ma. ");
INSERT INTO xavNT_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Tawamhã da te tiwi ĩhâiba waptẽrẽ za'ra zéb uwaibaba, ma tô Piratu hã da'wapéi'wa norĩ ma 'ru za'ra oto, Barabasihi ma si te te tãma rob'ru da, dazazém hawi dama watobro da. Ma tô duré tãma 'ru za'ra, Zezusi hã powawẽ hâiwaré na te te siwi 're pré'é mono da, taha pari te te duré siwi sasõmri da, wedepo'o nhonhi'rãmi na dâ'â da oto. ");
INSERT INTO xavNT_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Tawamhã Piratuhu ma da'wapéi'wa norĩ hã ma tô Zezusi hã siwi 'mazé ĩsõrõwa u, 'ri 'rãihâ u. Te te siwi 'mazébré wamhã, tame da'wapéi'wa norĩ hã ma tô aihĩni ãma si'rã'õtõ. ");
INSERT INTO xavNT_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Tawamhã ĩ'uza hã ma tô siwi waze. Tisi'ubuzém na ma ĩwa'rãmi siwi ãma hâiba ubu, ti'uza hâpa ĩhâ pré na, danhib'apito ãma 're ĩsi'uza za'ra mono zém ne hã. ");
INSERT INTO xavNT_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","'Wabzéré panhipti hã ma duré sada 'ma'manharĩ za'ra, ĩ'wa ahâ hã. Taha pari, ma ĩ'rã nhisiwi tãma hiri za'ra, te te ãma siwi sõpre da, danhib'apito hã ãma 're ĩsisõpre za'ra mono ne hã. Wedehu ma duré ĩsib'rata tãma hiri za'ra, ĩsib'rata nhimire niwĩ, danhib'apito hã tinhiwedehu ré, 're ĩsimasisi mono ne. Tawamhã hi'rãtitõ ma tô nasi ĩsõ're tãma asimro, ãma wa'ẽ za'ra sina te te nasi sawi za'ra da, ãne: — Zudezu norĩ nhib'apito, rowẽ na 're aihâimana mono. — Ãne te nasi ãma tiwa'ẽ za'ra, tô sena newa. ");
INSERT INTO xavNT_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Tizadaipro na te duré nasi siwi uptob za'ra. Wedehu te duré nasi tiwi mrami za'ra, ĩ'rãi wi, te te nasi siwi ãma ahâri da. ");
INSERT INTO xavNT_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Tawamhã nasi ãma wa'ẽ za'ra parimhã, zazahâ hâpa ĩhâpré hã ma tô apâ tiwi wazere za'ra. Apâ ma duré siwi uza, 're ĩsi'uza mono zém na. Taha pari, te oto siwi saprõ, te te siwi sasõmri da oto, wedepo'o nhonhi'rãmi na. ");
INSERT INTO xavNT_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","'Ri nho'õmo nhiti te te oto Zezusi hã siwi wazere wamhã, aibâ hã ma tô siwi tisã, Sima na ĩsisi hã. Sireni na ĩsa'ru nhisi hã. Te te siwi sãmri wamhã, ma tô tãma 'ru za'ra da'wapéi'wa norĩ hã, wedepo'o nhonhi'rãmi hã tinhisé te te tãma âri da, Zezusi te te sisada ĩ'âri hã. ");
INSERT INTO xavNT_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Tawamhã ma tô oto siwi ãwisi, Dodota na sa'a nhisi u, da te 're ĩdanhimroi mono zéb u. Dodota hã wasimremezém na Da'rãihi na sa'a nhisi, te wasu'u. ");
INSERT INTO xavNT_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Tamomo te te siwi ãwisi wamhã, uwa 'ru 'rãi wa'u ĩsé hã ma tô aré tãma sõmri za'ra Zezusihi ma, wedewa'u ĩsé na ĩwazari ré hã, te te hâ'rẽne da. Tane nherẽ, te te téiwai wamhã, te te sima wẽ õ di, te te hâ'rẽne da, Zezusi hã. ");
INSERT INTO xavNT_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Tawamhã ma tô oto siwi sasõ, wedepo'o nhonhi'rãmi na. Te te siwi sasõmri pari, ma tô ẽtẽ zapotore ĩ'ui'éré ré hã nasi sima sãmra da'wapéi'wa norĩ hã, Zezusihi uzazéb zô. Taha zarina, ma tô sima ãma aipé. ");
INSERT INTO xavNT_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Taha pari, te oto ĩ'rata asimro, Zezusi hã te te dawi 'madâ'â za'ra da, hâiwi sa'o ré. ");
INSERT INTO xavNT_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Tawamhã Zezusihi 'rã nho'õmoi baba ma tô siwi sasõ, wedepo'o na rob'ui'éré hã, ĩwasédé hã da te ãma ĩhirizéb ui'éré ré hã. Ãne ãma ĩrob'ui'éré hã: “Ã hã Zezusi, zudezu norĩ nhib'apito.” ");
INSERT INTO xavNT_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Zezusihi me ma tô aibâ norĩ hã dasiwi sasõmri zahuré ni, ĩsiré dâ'â zahuré da. Danhibrob zô dapãrĩ'wa norĩ, aibâ norĩ hã. Te ãma aiwa'aba zahuré ĩsimire niwĩ, duré ĩsimi'e niwĩmhã. ");
INSERT INTO xavNT_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Ĩwa'wai baba, da te nasi ĩro'rahâri za'ra norĩ hã te nasi ãma tawa'ẽ za'ra ni, Zezusihi ãma. Nasi ãma da'rãsiwanarĩ za'ra sina, te nasi ãma wasété za'ra ni. ");
INSERT INTO xavNT_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","Ãma dawa'ẽ sina, te duré nasi ãne tãma nharĩ za'ra ni: — Oro a hã asima roti za, 'ri 'rãihâ hã sãmra da, 'Re ĩhâimana u'âsi mono ãma 're ĩdawata za'ra mono zé hã, duré apâ 'ri da, si'ubdatõ bâdâ hã ai'ãma si'utõrĩ õ ré. A hã tô sena 'Re ĩhâimana u'âsi mono 'ra wamhã, ma'ãpé asisõ'reptu na. Wedepo'o nhonhi'rãmi hawi we si'ra na, atâ'â tõ da. — Ãne te nasi ãma dawa'ẽ za'ra sina 'mahârâ za'ra ni. ");
INSERT INTO xavNT_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Sasedoti ĩpire norĩ zama te duré nasi ãma tiwa'ẽ za'ra, 'Re ĩhâimana u'âsi mono nhimiroti 'rata na rob'ui'éré na dama rowahutu'wa norĩ zama, dama roti'wa norĩ zama. Ãne te nasi ta norĩ hã ãma tiwa'ẽ za'ra: ");
INSERT INTO xavNT_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","— Oro õ hã Izarazéhé nhihudu norĩ nhib'apito za. E niha hã bété, tinhimiromhõsi na te te 're da'anho'reptui mono nherẽ, 'râwi sisõ'reptu waihu'u õ di bété oto. Ãhãna wedepo'o nhonhi'rãmi hawi, we te te si'ra pé, wa te wasina ĩ'umnhasi za'ra zéb da hã. ");
INSERT INTO xavNT_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Õ hã ma tô 'Re ĩhâimana u'âsi mono hã te te sina 're umnhasi, ĩsiré 'râwi 're ĩmorĩ u'âsi na. Ma tô duré dama 're siwasu'u, 'Re ĩhâimana u'âsi mono 'ra na. Ma'ãpé ãhãna 'Re ĩhâimana u'âsi mono te te sõ'reptu oto, wanho'a. — Ãne te nasi ãma tiwa'ẽ za'ra, zudezu norĩ ma ĩpire za'ra norĩ hã. ");
INSERT INTO xavNT_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Tawamhã danhibrob zô dapãrĩ'wa norĩ hã ma tô duré nasi dasiré ãma tiwa'ẽ zahuré, ĩsiré dâ'â zahuré da, da te dasiwi ĩsasõmri zahuré hã. ");
INSERT INTO xavNT_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Tawamhã ma tô ti'abzuma oto. Abzuma wamhã, ma tô tirobra, daro mono bâ. Bâdâ siprazéb u, te oto robra si nomro. ");
INSERT INTO xavNT_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Tawamhã bâdâ sipra wi, te Zezusi hã Timama hã sa'ẽtẽ sina 'mahâ: — Eri, Eri, rema sabatani. Ãne wamremezém na hã: “Ĩ̱nhib'apito, Ĩ̱nhib'apito, e marĩ da, ma tô oto ĩ̱rẽ.” ");
INSERT INTO xavNT_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Tawamhã ni'wam norĩ hã ĩ'rata ĩsimasam norĩ hã Zezusihi hârâ te te wapari za'ra wamhã, ma tô sima rowasu'u za'ra, ãne: — Õhõta Eriasihi zô te hâ, te te we pawaptob da. — Ãne te sima ãma romnomri za'ra. ");
INSERT INTO xavNT_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Tawamhã ni'wa hã ĩ'rata ĩsimasam norĩ siré hã si'aba'ré na ma tô piza 're upsõzém ne hã 'mai'â, uwa 'ru 'rãi wa'u ĩsé na te te tãma ãma di'i da, Zezusihi ma, ĩwa'âbâ syry na. Tawamhã wedewaré 'rãsutu na ma tô ãma sapu'u, Zezusihi ma, te te wẽ da, te te upsõmri da. ");
INSERT INTO xavNT_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Tane nherẽ, ĩsiré ĩsimasam norĩ hã ma tô ãma sipa'uwati za'ra, ãne: — A'â pé, wanhimipari za'ra wa'aba a'â, Eriasi we ĩtẽme morĩ õ'umnhasite, te te sõ'reptu da, dâ'â tõ da. — Ãne te a'â siwi ãma pa'uwati, te te tãma sõmri tõ da, te te ĩ'upsõmri da hã. ");
INSERT INTO xavNT_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Tawamhã Zezusi hã ma tô duré tihârâ 'rãihâ na ãma sahu, ĩrẽme ma. Taha pari ma pẽ'ẽ hai'utõ. ");
INSERT INTO xavNT_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Dâ'â wi, zazahâ ĩhâpa hã 'ri 're wa'wa nhitobzé hã ma uihâ na hâihaipo'o aiwa, hâimo hawi pi'reba, 'Re ĩhâimana u'âsi mono nhorõwa ãma hã. Ti'a hã te duré sãsã'ã. Sãsã'ã wamhã, ẽtẽ tõmo wawẽ hã ti'a 're ĩsimi'wara mono zama ma tõmo sipo'o. ");
INSERT INTO xavNT_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","53","Taha wa, ma tô duré adâ'â 'ru hã si'ridawa za'ra. Si'ridawa za'ra wamhã, 'Re ĩhâimana u'âsi mono nhib'a'uwẽ norĩ hã aré 're ĩdâ'â za'ra mono hã ma tô apâ ahâiwa'utu ahâ uptabi na, 'Re ĩhâimana u'âsi mono hã. Ta norĩ hã, Zezusi hã ab're hawi za hâiwa'utu parimhã, te za ab're hawi wairé. Tawamhã Zeruzarẽ u te za asisi, 'ri nho'u ĩwẽ uptabi u, dama sihâi'ré za'ra da. Tawamhã da'ahâ uptabi na te za ãma tanhopré ni, tame. ");
INSERT INTO xavNT_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Tawamhã Zezusi te te dawi ĩ'madâ'â za'ra norĩ hã da'wapéi'wa norĩ hã, duré da'wapéi'wa norĩ wada'uri'wai me, ti'a ĩsãsã ĩwatobro hã te te 'madâ'â za'ra wamhã, duré uburé ropipa ĩwairébé mono te te 'madâ'â za'ra wamhã, ma tô sa'ẽtẽ uptabi tipẽ'ẽwara za'ra. Tawamhã ãne te sima nharĩ za'ra: — Nare õ hã, 'Re ĩhâimana u'âsi mono 'ra. — Ãne ma tô ta norĩ hã ãma titob'uzu za'ra, da'wapéi'wa norĩ hã. ");
INSERT INTO xavNT_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Tawamhã pi'õ norĩ hã ahâ na te 'madâ'â za'ra romhâ na, Zezusi hã hâiwi sa'o ré. Ta norĩ hã ma tô ĩsiré 're nomro Darireza hawi, Zeruzarẽ u, te te siwi 're pawaptob za'ra mono da. ");
INSERT INTO xavNT_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Ta norĩ me, te Mariza Madarena hã dame za. Marizaha hâiba amo zama te dame za. Taha 'ra hã Ti'adu, Zuzé duré. Zebedehe mro zama te duré pi'õ norĩ me za. ");
INSERT INTO xavNT_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Tawamhã ma tô bâdâ hã aipra pese oto. Taha wa, aibâ ĩsibro pe hã ma tô mo Piratuhu u, Zuzé na ĩsisi hã. Ta hã Arimateza na 'ri nho'õmo nhisi ãma 're ĩsãmra mono. Ta hã Zezusihi nhimiroti si te te 're ĩ'madâ'â pese mono. ");
INSERT INTO xavNT_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Tawamhã, Piratuhu u oto morĩ wamhã, ma tô Zezusihi hâiba hã tiwi waptẽ, ab're 're, te te sẽrẽ da. Tawamhã apito Piratu ma tô dama ti'ru, Zezusihi hâiba hã da te tãma 'ru da. ");
INSERT INTO xavNT_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Tawamhã Zuzé hã Zezusihi hâiba, ma tô ti'â. Taha pari ma tô ubu, zazahâ ĩhâirã na. ");
INSERT INTO xavNT_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Te te hâiba ubu pari, ma oto tite ab're sirõmo wa tisẽ Zuzé hã, sa'a zahâpâ da te aré tãma ĩ'ab're sirõmo wa. Taha pari ma tô ẽtẽ tõmo zapodo hã te te pizari, ab're te te ãma ĩré sitob da. Te te sito pari, te oto mo, õne haré. ");
INSERT INTO xavNT_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Zuzé hã Zezusihi hâiba te te sẽrẽ ré, te pi'õ norĩ hã ab're nho'õmoi baba aimasisi zahuré, Mariza Madarena norĩ hã duré Mariza ĩhâiba amoi me. 'Râwi te te ãma 'madâ'â zahuré da, te ĩ'rata aimasisi zahuré. ");
INSERT INTO xavNT_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Tawamhã oto ãma awẽ wamhã, sasedoti ĩpire norĩ hã, duré parisezu norĩ hã ma tô Piratuhu nhorõwa u si'rã'õtõ, sabadu na romhuri zahârizém na. ");
INSERT INTO xavNT_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Ĩtẽme si'rã'õtõ wamhã, ãne te tãma nharĩ za'ra: — Apito, õ hã ĩsadawa nhipe hã zahadu 're morĩ ré, dama 're ĩsiwasu'u mono zém na wa tô ãma wapo're pu'u za'ra ni, ãhãna hã. Ãne te dama 're siwasu'u: “Bâdâ si'ubdatõ ĩ̱'ãma si'utõrĩ õ ré, wa za apâ hâiwa'udu.” Ãne dama 're ĩsiwasu'u mono zé hã. ");
INSERT INTO xavNT_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Taha wa, ãté ĩsiré 're ĩnomro mono norĩ hã te za apâ siwi waze ĩhâiba hã, pi'uriwi. Tawamhã ãté sadawa nhipese na te za duré dama wasu'u za'ra, apâ ab're hawi ĩhâiwa'utu na hã. Zezusi hã 're morĩ ré, sadawa nhipese na te tô dama 're siwasu'u. Tane nherẽ, ĩsiré 're ĩnomro mono norĩ hã ãne na te te dama wasu'u za'ra wamhã, taha nhipai u te za duré dama sadawa hapese za'ra. Taha wa, te za dama ĩ'ru, sa'a zahâpâ ab're nhitobzé hã da te ĩré dasiwi 'madâ'â pese da, si'ubdatõ bâdâ, ãma ĩsi'utõrĩzéb u hã, ĩhâiba hã te te siwi wazere za'ra õ'umnhasite, pi'uriwi. — Ãne ma tô parisezu norĩ hã tiwi rowaptẽrẽ za'ra, 'Re ĩhâimana u'âsi mono ma da'ãma romhuri'wa norĩ nhib'apito norĩ me. ");
INSERT INTO xavNT_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Tawamhã Piratu te asa tãma nharĩ za'ra: — Tane tô. Da'wapéi'wa norĩ hã wa za tô pisutu za'ra, asiré si'aba'réi wa'aba da, ab're u. Mo oto ĩtẽme ai'aba'réi wa'aba pé, da'wapéi'wa norĩ ma, 'ru za'ra wa'aba da, ab're nhitobzé hã te te siwi 'madâ'â pese za'ra da, dawi. — Ãne te ĩtẽme tãma rob'ru za'ra, apito Piratu hã. ");
INSERT INTO xavNT_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Tawamhã ab're u te oto ai'aba'ré, da'wapéi'wa norĩ siré. Tawamhã ẽtẽ tõmo zapodo hã, ab're nhitobzé hã marĩ na ma tô siwi upto, sitop tete na ĩré sab da, da te dasiwi sa'ré tõ da. Da'wapéi'wa norĩ ma, ma tô duré roti za'ra, ab're nhitobzéb 'rata simasab da, te te siwi 'madâ'â u'âsi za'ra da, sõtõ za'ra ãna. ");
INSERT INTO xavNT_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Sabadu parimhã rowa'a wi, dumidu na ma tô Mariza Madarena norĩ hã sisaprõni zahuré Marizaha me, sa'a zahâpâ ab're u, Zezusi da te ĩsẽrẽzéb u. ");
INSERT INTO xavNT_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Tawamhã simiza'rese õ ré, ma tô ti'a hã ĩré 're tiwara zahuré, hâiwa hawi Wanhib'apito ma romhuri'wa hã ĩtẽme wisi zahuré wamhã. Tawamhã hâiwa ãma romhuri'wa hã ma tô ab're nhitobzé hã sa'ré, ẽtẽ tõmo wawẽ hã. Te te sa'réi wamhã, ma tô ĩsisiwi nhamra. ");
INSERT INTO xavNT_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Tã si'ubuzi ne ĩhâiba hã. Ĩ'uza hã rã uptabi di. ");
INSERT INTO xavNT_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Tawamhã ab're 'madâ'â'wa norĩ hã ma tô tipahi za'ra. Pahi uptabi za'ra wa, ma tô tirẽrẽ'ẽ za'ra. Tawamhã ti'ai u ma tô tãma ana. Dadâ'â wa, darési ãna 're ĩdanhimi'wara mono ne, ma tô rési ãna daba'wara. ");
INSERT INTO xavNT_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Tawamhã hâiwa ãma romhuri'wa hã ma tô tãma nharĩ zahuré, pi'õ norĩ ma, ãne: — Ĩ̱ma aipahi wa'aba tõ. Zezusi hã da te dasiwi wĩrĩ wa, wedepo'o nhonhi'rãmi na da te dasiwi ĩsasõmri zô robzabui wa'aba da, te we ane wa'wa. Wa hã wa tô aiwaihu'u 'wa, we sô ĩrobzabui wa'aba zém na hã. ");
INSERT INTO xavNT_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Tane nherẽ, ãme hâimana õ di. Te te sina ĩrotizéb zarina ma tô hâiwa'udu. We ane wa'aba pé, ĩnomrozé hã sabui wa'aba da. ");
INSERT INTO xavNT_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Taha parip si, te za sa'ẽtẽ ane wa'wa, ĩsiré 're ĩnomro mono norĩ ma, wasu'u za'ra wa'aba da. Ãne te za tãma ĩwasu'u za'ra wa'wa: “Ma tô hâiwa'udu. Darireza u ma tô asõwa timorĩ za'ra wa'wa. Tamep si te za ĩsabu za'ra wa'wa.” Ãne na ĩmreme na ãma aipo're simrami aba tõ. — Ãne ma tô hâiwa ãma romhuri'wa hã pi'õ norĩ ma waihu'u zahuré. ");
INSERT INTO xavNT_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Taha wa, te sa'ẽtẽ oto asamro zahuré ab're hawi, pahi te. Pahi zahuré nherẽ, tãma rowẽ zahuré di, pi'õ norĩ ma hã. Zezusihi siré 're ĩwanomro mono norĩ ma, te te rowasu'u zahuré da, te asamro zahuré. ");
INSERT INTO xavNT_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Sisamroi ré, ma tô Zezusi hã sõpẽtẽ zahuré, pi'õ norĩ hã. Simiza'rese ãna sisamroi ré, ma sõpẽtẽ zahuré. Tawamhã Zezusi hã ma tô sawi zahuré, ãne: — Rowẽ na 're aihâimana aba mono. — Ãne te sawi zahuré, Zezusi hã. Tawamhã pi'õ norĩ hã ma tô oto 'râwi ĩtẽme aima'wara zahuré. Tinhib'rata na te te para zawi zahuré sina, ma tô ãma tiwata zahuré, tãma pire zahuré wa. ");
INSERT INTO xavNT_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Tawamhã Zezusi te tãma nharĩ zahuré: — Aipahi wa'aba tõ. Mo oto ane wa'aba, ĩ̱sisãnawã norĩ ma, ĩ̱wasu'u wa'aba da, Darireza u ĩ̱zarina ãma si'aba'ré da. Tamep si te za ĩ̱zabu za'ra. ");
INSERT INTO xavNT_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Tawamhã Mariza Madarena norĩ hã zahadu neb zahuré ré, ma tô ab're 'madâ'â'wa norĩ hã ni'wam norĩ hã ai'aba'ré, Zeruzarẽ u. Zahadu te duré ni'wam norĩ hã asimro, ab're 'rata. Tawamhã Zeruzarẽ u ĩsi'aba'ré norĩ hã, sasedoti ĩpire norĩ ma, ma tô rowasu'u za'ra, uburé ĩromhâimana mono zém na hã. ");
INSERT INTO xavNT_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Tawamhã sasedoti ĩpire norĩ hã ma tô duré si'rã'õtõ, zudezu norĩ ma roti'wa norĩ me, te te sima ãma roti za'ra da. Tawamhã ma tô rob'uiprazé hã sa'ẽtẽ na tãma sõmri za'ra, da'wapéi'wa norĩ ma, ab're 'madâ'â'wa norĩ ma, dama 're sadawa nhipese za'ra mono da, Zezusihi wasu'u na. ");
INSERT INTO xavNT_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","Te te tãma sõmri za'ra sina, te ãne nasi tãma nharĩ za'ra: — Ãne te za dama ĩrowasu'u za'ra wa'wa, Zezusihi hâiba na hã: “Ĩsiré 're ĩnomro mono norĩ hã barana ma we sô aihutu. Wanhotõ ré ma tô siwi waze.” Ãne te za dama ĩrowasu'u za'ra wa'wa. ");
INSERT INTO xavNT_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Tawamhã Zudeza na danhipti'a nho'õmo nhisi ãma danhib'apito hã ãne hã te te wapari wamhã, wa za tãma aiwasu'u wẽ za'ra wa'aba ni, asada sahi za'ra wa'aba tõ da, marĩ ĩ'upa za'ra wa'aba õ na hã, niha te te aima rob'manharĩ za'ra wa'aba tõ da. — Ãne ma tô tãma roti za'ra, da'wapéi'wa norĩ ma. ");
INSERT INTO xavNT_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Tawamhã ab're 'madâ'â'wa norĩ hã ma tô rob'uiprazé hã waibu, da'wapéi'wa norĩ hã. Te te sima waibui wamhã, 'Re ĩhâimana u'âsi mono ma da'ãma romhuri'wa norĩ nhib'apito norĩ, te te tãma ĩroti za'ra zéb zarina, ma tô 'manharĩ za'ra, ĩmreme hã. Ãne ma tô Zezusihi hâiba na rowasu'u zadawa nhipe hã te te ropé, zudezu norĩ nhipti'ai 'remhã. Ta hawim haré te zahadu rowasu'u zadawa nhipe hã 're hâimana, Zezusihi hâiba na hã. ");
INSERT INTO xavNT_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Tawamhã wa norĩ hã Zezusihi siré 're ĩwanomro mono norĩ hã wa tô ai'aba'ré ni Darireza u, 11 na wahâiba za'ra hã. Ẽtẽ 'rãihâ u wa ai'aba'ré ni, Zezusi te te wama ĩpisutu za'ra zéb u. ");
INSERT INTO xavNT_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Tawamhã Zezusi hã wa te wasiwi sãmri wamhã, wa tô ãma wawata za'ra ni. Tane nherẽ, nima norĩ hã wa tô wawã za'ra ni, õ hãi õ newa. ");
INSERT INTO xavNT_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Tawamhã Zezusi hã ma tô 'râwi watẽme timorĩ za'ra oto. Ma tô wama nharĩ za'ra, ãne: — Ĩ̱mama hã ma tô ĩ̱ma pisutu, ĩsadawa para dama ĩ̱pire na 're ĩ̱hâimana mono da, ti'ai ãma, hâiwa ãma zama. ");
INSERT INTO xavNT_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Taha wa, te za 're ĩropéi wa'aba mo a'uwẽ mono bâ, dama 're ĩ̱zadawa wasu'u za'ra wa'aba mono da, a'uwẽ mono bâ da te 're ĩ̱zaze za'ra mono da, taha zarina ĩ̱nhimiroti 'madâ'â'wa 're dahâimana za'ra mono da oto. Da te 're ĩ̱zaze za'ra mono sidâpâsi, te za â dawabzuri hã dama 're ĩ'manharĩ za'ra wa'aba mo, Ĩ̱mama nhisi na, duré ĩ̱nhisi na, duré Ĩ̱mama pẽ'ẽzani nhisi na, ta norĩ zadawa para. ");
INSERT INTO xavNT_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Te za duré dama 're ĩroti za'ra wa'aba mo, uburé te aima 're ĩroti za'ra wa'aba mono zéb zarina, ĩ̱nhimiroti si da te 're 'madâ'â u'âsi za'ra mono da. Õne u'âsi, wa za asiré 're ĩ̱morĩ u'âsi za'ra wa'wa, ro ĩsi'utõrĩzéb u hã. Ãne na aipo're si'âri za'ra wa'aba õ di za. — Ãne ma tô Zezusi hã wama siwaihu'u za'ra sisa'u, ĩsiré 're ĩwanomro mono norĩ ma.");
INSERT INTO xavNT_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","3","Ãhãna ĩsãna'rata hawi, wa za aima rowasu'u za'ra wa'wa, Zezu Cristuhu wasu'uwẽ na, 'Re ĩhâimana u'âsi mono 'ra wasu'u na. Romhâ ré, ma tô ãma rob'ui'éré siro, Iza'iza hã, 'Re ĩhâimana u'âsi mono zadawa wasu'u 'rata 'wa hã. Duréihã 'Re ĩhâimana u'âsi mono hã, ti'ra ma, te te ĩwaihu'uzém na ma tô ãma rob'ui'éré, ãne: “Wa hã wa za satõ ĩ̱zadawa wasu'u'wa hã, aiwana, te te asô ropese mono da. Ãne te za te te dama 're rob'mahârâ, mreme 'rãihâ sina, a'ubuni wi: Ni'wa hã te za te te dama 're rob'mahârâ, a'ubuni wi: Bâdâdi hã asiwi ropese aba, Wanhib'apito zô. Ĩmana 'rãmi bâdâdi hã sô sa'ra wa'aba, awa'awi da.” Ãne ma tô Iza'iza hã ãma rob'ui'éré, romhâ ré. ");
INSERT INTO xavNT_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Tawamhã Iza'iza te te dama ĩrob'ui'éré zarina, te oto Zuwã Batita hã â dawabzuri hã te te dama 're ab'manharĩ, a'ubuni wi. Ãne te oto te te dama 're roti: — Ma'ãpé, aiwasété wi aipizari za'ra wa'aba, 'Re ĩhâimana u'âsi mono, marĩ 're ĩ'manharĩ wasété za'ra wa'aba mono zé hã te te aima pari za'ra wa'aba da. Tawamhã â dawabzuri hã wa za te aima 're 'manharĩ za'ra wa'wa. — Ãne ma tô te te dama 're roti, Zuwã Batita hã. ");
INSERT INTO xavNT_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Da'ahâ uptabi na te ĩtẽme 're dasito, Zudeza na danhipti'a nho'õmo nhisi hawi. Zeruzarẽ na 'ri nho'õmo nhisi hawib zama, te ĩtẽme 're dasito. Tawamhã dasisõ'a dawasété na, 'Re ĩhâimana u'âsi mono ma 're dasiwasu'u za'ra mono wamhã, ma tô â dawabzuri hã te te dama 're ab'manharĩ Zuwã hã, Zodã pa na â nhisi ãma. ");
INSERT INTO xavNT_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Zuwã hã awaru ba'õmore zéré 'manharĩ na te 're si'uza. Duré romhâ 'manharĩ hâiwaré na te ãma 're si'usisi. 'Riti na si, te 're sa. Ropĩni na zama te duré 're sa. ");
INSERT INTO xavNT_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Ãne te te oto dama 're rowasu'u: — Ĩ̱za'u si te za ĩ̱ma ĩpire uptabi hã wei wi. Ĩ̱ma pire uptabi wa, ĩpara'uza wasisizé, te tãma wasihu waihu'u õ di za. ");
INSERT INTO xavNT_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Wa hã wa tô â uptabi na si te 're aihâiba ubu za'ra wa'wa, â dawabzuri hã te aima 're ab'manharĩ aba mono wamhã. Tanei õ di za oto. Ĩ̱ma ĩpire hã wei wisi wapsi, te za oto 'Re ĩhâimana u'âsi mono pẽ'ẽzani na te te 're aihâiba ubu za'ra wa'wa, ĩré 're anomro u'âsi aba mono da. Wẽ uptabi di, Ĩpẽ'ẽzani hã. — Ãne ma tô Zuwã Batita hã te te dama 're wasu'u. ");
INSERT INTO xavNT_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Tawamhã ãne te te dama 're wasu'u mono ré, ma tô Zezusi hã ĩtẽme wi, Nazaré na 'ri wa'õtõ nhisi hawi. Darireza na danhipti'a nho'õmo nhisi ãma, Nazaré hã. Ĩtẽme wisi wamhã, ma â dawabzuri hã Zezusihi ma 'manha, Zodã pa na â nhisi ãma. ");
INSERT INTO xavNT_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Tawamhã â hawi watobro wi, ma hâiwa hã aipo'o. Hâiwa hawi, ma we 'Re ĩhâimana u'âsi mono pẽ'ẽzani hã ĩtẽme si'ra, utu'u ne. Ma tô sina 'madâ, Zezusi hã. ");
INSERT INTO xavNT_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Tawamhã hâiwa hawi, te we 'Re ĩhâimana u'âsi mono hã Zezusihi ma tinha: — A hã ĩ̱'ra. Ĩ̱ma asawi uptabi di. Aima ĩ̱to za'ẽtẽ uptabi di. — Ãne te we tãma tinha, Ĩmama hã. ");
INSERT INTO xavNT_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Tawamhã Zezusi hã â dawabzuri te te 'manharĩ pari, te oto 'Re ĩhâimana u'âsi mono pẽ'ẽzani hã satõ, a'ubuni u sãmra da. Taha wa, te oto mo. ");
INSERT INTO xavNT_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Tawamhã a'ubuni wi sãmra ré, bâdâ hã ahâ na ma ãma si'utõrĩ, 40 na. Tame sãmra ré, Satanasi hã te aré nasi wada'u, ĩsimiroti na te te saze da. A'ubuni ãma abaze zahi hã te 're hâimana za'ra. Tane nherẽ, 'Re ĩhâimana u'âsi mono ma romhuri'wa norĩ hã hâiwa hawimhã, te we siwi 'madâ'â pese. ");
INSERT INTO xavNT_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Tawamhã Zezusi hã te mo, Darireza na danhipti'a nho'õmo nhisi u. Zuwã Batita hã dazazéb 're, da te dasiwi sẽrẽ pari, te Zezusi hã mo. Tawamhã rowasu'u wẽ hã, 'Re ĩhâimana u'âsi mono te te tãma ĩsõmri na, te Zezusi hã te te dama 're rowasu'u oto. ");
INSERT INTO xavNT_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Ãne te tinha: — Ãhãna bâdâ hã ma tô oto ĩwa waptãrã, 'Re ĩhâimana u'âsi mono, da'ãma 're ĩsib'a'uwẽ mono zéb da hã. Ma'ãpé aiwasété wi, 're aipizari za'ra wa'aba mono za, 'Re ĩhâimana u'âsi mono niwĩ, ĩwasu'uwẽ hã 're saze za'ra wa'aba mono da. — Ãne ma tô te te dama 're rowasu'u, Zezusi hã. ");
INSERT INTO xavNT_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Tawamhã â zaihâ u ma tô wi, Zezusi hã, Darireza na ĩsõ'u nhisi u hã. Wisi wamhã, â zababa 're morĩ ré, ma tô tepe mrami na romhuri'wa norĩ hã sõpẽtẽ zahuré. Ta norĩ hã Sima Pedru na ĩsisi hã ĩsisãnawãi me, Ãdéréhé me. Tepe zô, te nasi abazipara hã wabzuri zahuré. ");
INSERT INTO xavNT_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Tawamhã ãne te Zezusi hã 'mahârâ zahuré: — We ane wa'aba, ĩ̱siré 're ane wa'aba da oto, romhuri na aima ĩ̱sisanho wa'aba da, ĩ̱ma 're ĩda'awaibui wa'aba mono zém na da hã. — Ãne ma tô tãma waihu'u zahuré. ");
INSERT INTO xavNT_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Tawamhã õne haré ma tãma marẽme zahuré, abazipara ma. Zezusihi siré te oto tineb zahuré. ");
INSERT INTO xavNT_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Tawamhã syry na sina pahâ wi, ma duré 'madâ'â zahuré, Ti'adu norĩ hã Zuwãhã me. Ta norĩ hã Zebedehe 'ra zahuré. Abazipara sisinarĩ hã te te ãma a'rã'õtõ zahuré apâ, uba're wa. ");
INSERT INTO xavNT_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Tawamhã Zezusi te duré sô tihârâ zahuré, ĩsiré neb zahuré da. Tawamhã õne haré timama hã ma rẽme zahuré, tãma ĩromhuri'wa norĩ zama, uba're 're ĩsi'ubumro norĩ hã, Zezusihi siré 're neb zahuré da oto. ");
INSERT INTO xavNT_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Tawamhã Zezusi norĩ hã ma tô aihutu, Capana'u na 'ri nho'õmo nhisi u. Tawamhã sabadu na wa, ma awa'awi ãzé Zezusi hã, zudezu norĩ te rowahutuzéb u, te te dama rowahutu da, tô romhuri zahârizém na hã. ");
INSERT INTO xavNT_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","'Re ĩhâimana u'âsi mono nhimiroti 'rata na rob'ui'éré na dama rowahutu'wa norĩ nhimirowasu'u nei õ di, Zezusi te te dama ĩrowahutu mono zé hã. Simirowahutu pire na te dama rowahutu. Simirowasu'u wẽ wa, ma tô ãma tatob'uzu za'ra ni. ");
INSERT INTO xavNT_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Tawamhã te te dama rowasu'u ré, ma we aibâ hã ãzé, rowahutuzéb u, wa'uburé ré 're ĩmorĩ hã. Sébré wi, te sa'ẽtẽ 'mahâ: ");
INSERT INTO xavNT_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","— Zezusi, Nazaré nhihudu, e marĩ zô te we aimo. E wa'uprosi da, te we aimo. A hã ĩ̱ma aiwaihu'u pese di, 'Re ĩhâimana u'âsi mono, we te te asatõrĩ na hã. Aiwẽ uptabi di, a hã. — Ãne te 'mahâ. ");
INSERT INTO xavNT_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Tawamhã Zezusi te asa tãma tinha, wa'uburé ma: — Tô'ã, we ĩ̱ma nharĩ tõ. Mo oto aibâ hawi aiwatobro. ");
INSERT INTO xavNT_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Tawamhã sisa'u te sa'ẽtẽ hâiba wasutu, wa'uburé hã. Tawamhã sadari sina, ma aibâ hawi watobro. ");
INSERT INTO xavNT_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Tawamhã ma ãma tatob'uzu za'ra ni. 'Râwi te ãma dasima rowasu'u za'ra ni, ãne: — Õ hã, e niha. Wama ĩsa'rese õ na, te wama rowahutu. Wa'uburé norĩ ma, te te rob'rui wamhã, ma tô wapari za'ra, ĩmreme hã. — Ãne te dasima ãma romnhoré za'ra ni. ");
INSERT INTO xavNT_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Taha wa, Zezusihi wasu'u hã ma tô waptu na ropé, Darireza na danhipti'a nho'õmo nhisi 're, daro mono bâ. ");
INSERT INTO xavNT_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Taha pari, ma tô Zezusi norĩ hã rowahutuzém hawi wairé, Sima Pedru norĩ nhorõwa u si'aba'ré da. Tisiséme me, Ãdéréhé me, te siré 're simasisi zahuré, Sima Pedru norĩ hã. Ta norĩ hã, Ti'adu norĩ me, Zuwã norĩ me, ma asisi 'ri para u, Zezusihi siré. ");
INSERT INTO xavNT_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Tame te Simahã maprewa hã hâzé ré nomro, wa'ro na. Tawamhã sisisi wi, te Zezusihi ma 'mahârâ za'ra, hâzé na ĩnomro na. ");
INSERT INTO xavNT_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Taha wa, te oto ĩtẽme mo, ĩnomrozéb u. Tawamhã ma pa'â, wahutu da. Taha wa, ma awa'awi tiwahâ. Tawamhã ma tô tãma api za'ra Zezusi norĩ ma, saihuri da. ");
INSERT INTO xavNT_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Tawamhã bâdâ sébrézéb u, ma tô ĩtẽme tasi'ãwisi za'ra ni, Zezusihi u, dahâzé mono bâ. Wa'uburé ré 're ĩdanomro mono norĩ zama, ma ĩtẽme ãwisi za'ra ni. ");
INSERT INTO xavNT_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Uburé 'ri ahâ 're, 're ĩdasi'ubumroi mono norĩ hã ma ĩtẽme tasi'rã'õtõ ni, 'ri nho're uwaibaba. ");
INSERT INTO xavNT_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Tawamhã dahâzé mono bâ, ma da'apese, da'ahâ na. Duré timreme na ma wa'uburé norĩ hã dama anhamra, ahâ na. Wa'uburé norĩ hã ma tô waihu'u za'ra Zezusi hã, 'Re ĩhâimana u'âsi mono 'ra na. Taha wa, Zezusi ma tô wa'uburé norĩ hã sadawa uwati za'ra, te te dama rowasu'u za'ra tõ da. ");
INSERT INTO xavNT_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Tawamhã robza'rã ré, ma wahudu Zezusi hã, 'ri nhiti morĩ da, a'ubuni u. Tame te a'â tihâiba, 'Re ĩhâimana u'âsi mono ma, mreme da. ");
INSERT INTO xavNT_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Tawamhã Sima Pedru norĩ hã te Zezusihi zô sõpré ropâ, tisiré norĩ me hã, te te siwi sõpẽtẽ da. ");
INSERT INTO xavNT_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Tawamhã te te siwi sõpẽtẽ wamhã, te tãma rowasu'u za'ra: — Aihĩni te asô tanhopré ni. ");
INSERT INTO xavNT_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Tawamhã Zezusi te asa tãma nharĩ za'ra: — Oto wasi'aba'réi wa'aba, 'râwi 'ri wa'õtõ 're, 're ĩdahâimana za'ra mono u, tamomo zama te ĩwasu'uwẽ na da'apo're pu'u mono da. Taha da, wa wei mo. — Ãne ma Zezusi hã tãma siwaihu'u za'ra. ");
INSERT INTO xavNT_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Tawamhã daro mono bâ te 're mo, Darireza na danhipti'a nho'õmo nhisi ãma 're ĩdasi'ubumroi mono norĩ ma, ĩwasu'uwẽ hã te te dama 're wasu'u mono da, zudezu norĩ te, rowahutuzé mono bâ. Wa'uburé hã te te duré dama 're anhamra. ");
INSERT INTO xavNT_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Tawamhã aibâ hã ma ĩtẽme wi, ĩ'wa're ré hã. Hi'rãtitõ ma aime, Zezusihi papara, te te tãma nharĩ da, ãne: — Ĩ̱ma aiwaihu'u pese di, asimipese waihu'u pese na hã. Taha wa, asima ĩ̱wẽ wamhã, te za ĩ̱pe. — Ãne te Zezusihi ma si'ru, te te pese da. ");
INSERT INTO xavNT_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Tawamhã Zezusi hã ãma pẽ'ẽzé wa, ma tô tinhib'rada hã wahutu, te te ãma upi da. Te te upi wamhã, ãne te tãma tinha: — Tane tô. Wa tô ĩ̱sima aiwẽ, te aipese da. Tâibâ oto aihâzé hã. — Ãne ma Zezusi hã tãma waihu'u asa. ");
INSERT INTO xavNT_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Tawamhã awa'awi ma ĩ'wa're hã tãma apa. Ma tô tihâiba wẽ oto. ");
INSERT INTO xavNT_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","44","Tawamhã Zezusi hã ma tô sina sadawa uwati, te te dama sina wasu'u tõ da. Ãne te tãma tinha: — Ĩ̱wapari pese, asina. Ni'wai ma, asina ĩ̱wasu'u õ di za, te aipesezém na. Sasedoti u si te za aimo, 'Re ĩhâimana u'âsi mono ma, da'ãma romhuri'wai u si, aihâiba wẽ zô te te aihâiba 'madâ'â da. Taha parip si, 'Re ĩhâimana u'âsi mono ma, te za asõpru, Mozésihi nhimiroti zarina, aipesezém na da te ãma aiwaihu'u za'ra da, sena na. — Ãne ma tô aibâ hã satõ, Zezusi hã. ");
INSERT INTO xavNT_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Tazahã aibâ hã rowasu'u wẽ na ma tô ãma ropé. Taha wa, sõ'awi 'ri ahâ u hã datẽme 're ne waihu'u mono õ di, Zezusi hã. Taha wa, a'ubuni wi te a'â 're hâimana, danhiti. Tame 're hâimana mono ré, te ĩtẽme 're dasihutu, daro mono bâ, da te 're sabu za'ra mono da. ");
INSERT INTO xavNT_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Syry na ãma ronomro parip si, ma Zezusi norĩ hã apâ aihutu, Capana'u na danhipti'a nho'õmo nhisi u. Tawamhã awa'awi ma ĩwasu'u hã ropé, 'ri para ãma oto ĩhâimana na hã, Zezusi hã. ");
INSERT INTO xavNT_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Tawamhã da'ahâ na ma ĩtẽme dasito. Da'ahâ na ĩtẽme dasito mono wamhã, 'ri 're wa'wa ãma hã da'masisi di, 'ridawa ãma zama. ");
INSERT INTO xavNT_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Tawamhã Zezusi hã rowasu'u wẽ na te te dama rowasu'u ré, aibâ norĩ hã ma tô ĩhi'ré hã ĩtẽme siwi ãwisi, ĩsimiwaptâ wa. Aibâ norĩ hã maparane si'uiwa na ĩhâiba za'ra hã. ");
INSERT INTO xavNT_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Tazahã da'ahâ wamhã, te te siwi 'mazébré waihu'u õ di, Zezusihi u hã. Taha wa, sipapara 'ri nhisi hawi, ma tô siwi 'ri 're pu'u za'ra sada, Zezusihi uwaibaba te te siwi hiri da. Tawamhã ma tô ãma siwi si'ra, ĩsa'warizéb ré, ĩhi'ré hã. ");
INSERT INTO xavNT_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Aibâ norĩ hã ma tô Zezusi hã siwi ãma umnhasi, ĩsiwadi hã za te te ĩpesezém na. Zezusi hã ma tô tiwi waihu'u za'ra, sina ĩsimirosa'rata za'ra hã. Taha wa, te ĩhi'ré ma tinha: — Ĩ̱siwadi, aiwasédé hã 're ĩ'ab'manharĩ wasété mono zé hã, te ai'ãma 're ab'madâ'â mono õ di za oto. — Ãne ma tô tãma waihu'u, ĩhi'ré ma. ");
INSERT INTO xavNT_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Tame aibâ norĩ hã te dame asimro, 'Re ĩhâimana u'âsi mono nhimiroti 'rata na rob'ui'éré na dama rowahutu'wa norĩ hã. ");
INSERT INTO xavNT_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","Ta norĩ hã te 'râwi sima ãma rosa'rata za'ra, ãne: — E niha te aibâ ma tinha bété, õ hã, ĩmorĩ'õ ma. 'Re ĩhâimana u'âsi mono ma, wẽ õ di, aibâ ma, te te ĩnharĩzé hã. Dawasédé hã da te 're ĩ'manharĩ wasété za'ra mono zé hã, ni'wa hã te te dama 're apari waihu'u mono õ di. 'Re ĩhâimana u'âsi mono ma si waihu'u pese di, dawasédé hã te te dama 're ĩ'apari mono zé hã. — Ãne te Zezusihi ãma sima rosa'rata za'ra, rowahutu'wa norĩ hã. ");
INSERT INTO xavNT_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Tawamhã 'râwi te te sima ãma ĩrosa'rata za'ra zém na, ma tô sina waihu'u, Zezusi hã. Taha wa, te tãma nharĩ za'ra: — E marĩ da, te ãne ĩ̱'ãma ĩrosa'rata za'ra wa'wa. ");
INSERT INTO xavNT_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Wa hã dawasédé hã te dama 're ĩ'apari waihu'u pese mono na, e niha te za ĩwaihu'u za'ra wa'wa, sena na ĩ̱waihu'u za'ra wa'aba da. Ĩhi'ré ma, wa tô tinha: “Aiwasédé hã 're ĩ'ab'manharĩ wasété mono zé hã, te ai'ãma 're ab'madâ'â mono õ di za oto.” Ãne hã ĩ̱mreme si wamhã, aima pibu prã za'ra wa'aba di tô. Ã hã ĩmorĩ'õ hã wahutu da, duré tiza'warizé hã te te sima âri da, oto morĩ da, te tãma nharĩ wapsi, te za ĩwaihu'u za'ra wa'wa, ĩ̱waihu'u pese na sena na ĩ̱waihu'u pese za'ra wa'aba da oto. Taha wapsi, aima pibu pese za'ra wa'aba di za oto. ");
INSERT INTO xavNT_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Ti'ai ãma dasiré ĩ̱podo hã ĩ̱ma waihu'u pese di, dawasédé te dama 're ĩ'apari mono da hã, 'Re ĩhâimana u'âsi mono zadawa para. Ãne na asiwi ĩ̱waihu'u za'ra wa'aba da, wa za ĩhi'ré ma tinha, wahutu da. Tawamhã ĩhi'ré ma, te tinha oto: ");
INSERT INTO xavNT_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","— Ma'ãpé, aiwahutu. Asa'warizé âri, asõrõwa u aimorĩ da oto. ");
INSERT INTO xavNT_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Tawamhã awa'awi ma tô wahudu, aibâ hã. Tiza'warizé, ma tô ti'â. Rob u, ma tô ĩré watobro, danho'a. Taha wa, uburé, ma ãma tatob'uzu za'ra ni. 'Re ĩhâimana u'âsi mono ãma, te duré ãma tawata za'ra ni. Ãne ma tô dasima rowasu'u za'ra ni: — Ãne hã niwa wa te ĩ'madâ'â za'ra õ. — Ãne ma tô dasima rowasu'u za'ra ni. ");
INSERT INTO xavNT_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Tawamhã Darireza ãma ĩsõ'u zapoto u, te apâ mo Zezusi hã. Da'ahâ na ma tô ĩtẽme 're danomro. Tawamhã dasihutu sidâpâsi te nasi dama rowahutu, rowasu'u wẽ na. ");
INSERT INTO xavNT_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Tawamhã morĩ ré, ma tô aibâ tisã, danhib'apito ma, dawi rob'uiprazé ubumroi'wa hã, Réwi na ĩsisi hã, Apezuhu 'ra hã. Tinhimiromhurizéb ãma te nhamra, rob'uiprazé te te dawi 're ĩ'a'ubumroi mono zéb ãma. Tawamhã Zezusi hã te 'mahâ: — We aiwahutu, ĩ̱siré 're aimorĩ da oto. — Ãne te 'mahâ. Tawamhã awa'awi ma wahudu Réwi hã, ĩsiré oto 're morĩ da. ");
INSERT INTO xavNT_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Tawamhã syry na ãma ronomro wamhã, Zezusi hã te tisa, Réwihi nhorõwa ãma. Ĩsiré 're ĩnomro mono norĩ zama, te ĩsiré tisaihu. Da'ahâ na duré ĩsarina ĩdasi'aba'ré hã te duré ĩsiré tasaihuri ni. Ta norĩ hã rob'uiprazé ubumroi'wa, duré parisezu norĩ nhimiroti zarina 're ĩhâimana za'ra mono õ. ");
INSERT INTO xavNT_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Tawamhã ta norĩ me sai ma, sãmra ré, ma tô Zezusi hã 'madâ'â za'ra, dama rowahutu'wa norĩ hã, parisezu norĩ hã. Ta norĩ hã Zezusihi siré 're ĩnomro mono norĩ ma, te nharĩ za'ra: — E niha bâ, te bété rob'uiprazé ubumroi'wa norĩ siré tisa, dawasété na 're ĩdahâimana za'ra mono norĩ siré zama. ");
INSERT INTO xavNT_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Tawamhã Zezusi hã ãne te te sina wapari za'ra wamhã, ma tô tãma nharĩ za'ra, ãne: — Hâzé ãna 're ĩnomro mono norĩ zô, dawede'wa hã 're siwasutu za'ra mono õ di, te te 're wede za'ra mono da. Ĩhâzé ré norĩ zô si te za 're siwasutu za'ra, te te 're pese za'ra mono da. Tane duré wa hã. Dawẽ na 're ĩdanomro mono norĩ zô, ĩ̱sitẽme 're ĩ̱hârâ mono da, we ĩ̱morĩ õ di. Dawasété na 're ĩdanomro mono norĩ zô si, 're ĩ̱hârâ mono da, wa wei mo. — Ãne ma tô dawede'wa na tãma siwasu'u za'ra, Zezusi hã. ");
INSERT INTO xavNT_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Tawamhã Zuwã Batitaha siré 're ĩnomro mono norĩ hã, duré parisezu norĩ hã, ã bâtâ na te saihuri ãna tihâimana za'ra, 'Re ĩhâimana u'âsi mono ma, mreme zusi da. Taha wa, ni'wam norĩ hã te Zezusihi ma, nharĩ za'ra: — Zuwãhã siré 're ĩnomro mono norĩ hã, duré parisezu norĩ hã, ã bâtâ na saihuri ãna te tihâimana za'ra, 'Re ĩhâimana u'âsi mono ma, mreme zusi da. E marĩ wa, asiré 're ĩnomro mono norĩ hã, saihuri ãna ã bâtâ na hâimana za'ra õ di bété, tãma mreme zusi da. ");
INSERT INTO xavNT_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Tawamhã Zezusi, ma tô asa tãma waihu'u za'ra: — Aibâ hã ĩmrozéb u, sô ĩhârâ za'ra norĩ hã sihutu wamhã, e saihuri ãna, te za tihâimana za'ra. Mare di. Saihuri ãna hâimana za'ra õ di za. Aibâ ĩmro da hã ĩ'rata sãmra za'ra ré, te za tô ĩsiré tisa hã tihu, to sina. ");
INSERT INTO xavNT_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Niwapsi te za bâdâ hã ĩwa waptãrã, aibâ ĩmro da hã ĩsiwadi norĩ wa'wa hawi, da te tiwi ĩ'âri za'ra zéb da hã. Tawapsi te za tô sai ãna 're si'ubumro, robzei'õ na. — Ãne sõ'awib õ nherẽ, ma tô aibâ ĩmrozé wasu'u na, sina ãma simiré'é, Zezusi hã. ");
INSERT INTO xavNT_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Tawamhã ãne ma duré tãma waihu'u za'ra: — Da'uza hâ 'ratare hã, e te za ĩhâi wẽ na ãma hâiwa'aba ni, ĩhâ nhihâri tém na. Mare di. Ãne wamhã, te za dawi 're hâzahutu za'ra. Tawamhã ĩhâ'rada hã te za sina hâta. Te za oto dawi hâihatari za'ẽtẽ. ");
INSERT INTO xavNT_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Duré e romhâ 'manharĩ 'rata 're, te za uwa 'rãi wa'u ĩsé hã da te 're sé, wa'ui ware õ ré. Mare di. Wa'ui ware õ ré, da te 're séme mono wamhã, oto wa'ui ware wamhã, te za romhâ 'manharĩ 'ratare hã sina wazu. Tawamhã uwa 'rãi wa'u ĩsé hã te za asa'wa. Romhâ 'manharĩ hã te za duré hâihaiwamna. Ĩtép si'uiwa na si, te za da te 're sé, rob'rãi wa'u té hã. — Ãne sõ'awib õ nherẽ, ma tô tinhimiroti tém na tãma rowasu'u za'ra, Zezusi hã. ");
INSERT INTO xavNT_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Tawamhã romhuri zahârizém na, ma tô buru nho wa'wai baba ro'rahâri za'ra Zezusi norĩ hã, sabadu na. Ĩsiré 're ĩnomro mono norĩ hã ma tô te te sima 'rãnhinarĩ za'ra, te te huri mono da. ");
INSERT INTO xavNT_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Tawamhã parisezu norĩ hã te Zezusihi ma nharĩ za'ra: — E niha, romhuri zahârizém na nherẽ, te te sima 'rãnhinarĩ za'ra, asiré 're ĩnomro mono norĩ hã, wahi'rata norĩ hã romhuri zahârizém na te te dawi 're sawi za'ra mono nherẽ. ");
INSERT INTO xavNT_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Tawamhã Zezusi ma asa tãma waihu'u za'ra: — E apito Dawihi wasu'u na rob'ui'éré hã 're sõré za'ra wa'aba mono ã bâ, te te ĩrob'manharĩzém na, ĩsiré norĩ me, mra te te simroi wamhã. ");
INSERT INTO xavNT_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","'Re ĩhâimana u'âsi mono ãma 're ĩdawata za'ra mono zéb u, ma tô ãzé, apito Dawi hã. Abi'ata hã 're hâimana mono ré, ma tô ãzé. 'Re ĩhâimana u'âsi mono ma da'ãma romhuri'wa ĩpire uptabi, Abi'ata hã, sasedoti ĩpire uptabi hã. Tawamhã sébré wamhã, ma tô 'mai'rẽ ĩ'u'ẽne hã, Dawi hã, 'Re ĩhâimana u'âsi mono ma, aré da te ĩsa'ra za'ra hã. Duré tisiré norĩ ma, ma tô tãma a za'ra. 'Re ĩhâimana u'âsi mono, ma tô aré pisutu, da'ãma romhuri'wa norĩ si, ĩ'u'ẽne hã te te 're ĩhuri mono da hã, sasedoti norĩ si. Tane nherẽ, ma tô 'mai'rẽne za'ra, Dawi norĩ hã. — Ãne ma tô tãma hâimanazéb 'rãzarõtõ za'ra Zezusi hã, parisezu norĩ ma. ");
INSERT INTO xavNT_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","28","Tawamhã ãne ma tô Zezusi hã tãma 'rãsutu za'ra, timreme na: — Wa hã 'Re ĩhâimana u'âsi mono te te ĩ̱pisudu, dasiré ĩ̱poto da, ti'ai ãma. Taha wa, dama ĩ̱pire di, sabadu na roti hã te dama 're ĩ'apisutu mono zéb da hã. — Ãne ma tô tãma waihu'u za'ra, parisezu norĩ ma. ");
INSERT INTO xavNT_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Tawamhã zudezu norĩ te, rowahutuzéb u, ma duré ãzé Zezusi hã. Tame te aibâ hã dame nhamra, ĩsimizu'rã're hã. ");
INSERT INTO xavNT_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Tame te ni'wam norĩ hã Zezusi hã siwi 'madâ, zudezu norĩ te, romhuri zahârizém na, aibâ hã te te pese zô. E marĩ da. Sabadu na te te pese wa, te te siwi wẽ'õ da, romhuri zahârizém na roti, te te ĩ'madâ'â õ na. ");
INSERT INTO xavNT_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Tawamhã Zezusi hã te aibâ 'mahâ: — We aimorĩ ãwa. ");
INSERT INTO xavNT_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Te duré da'ab'mahâ: — E niha romhuri zahârizém na roti hã. E marĩ, wa za wa te dama 're 'manharĩ za'ra, romhuri zahârizém na, sabadu na hã. E ĩwẽ na, wa za wa te 're dapawaptob za'ra. E ĩwasété si, wa za wa te dama 're 'manharĩ za'ra. E romhuri zahârizém na, wa za wa te 're danho'reptu za'ra. E bâtâ na, wa te 're danho'reptu za'ra mono ãna, wa za taré wa te 're da'madâ'â za'ra. — Ãne te da'a'mahâ. Tawamhã ni'wa hã asa te te ãma sada'âbâ õ di, Zezusi te te ĩsadanharĩ za'ra zém na hã. ");
INSERT INTO xavNT_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Tawamhã Zezusi te da'ab'madâ. Te te ãma ĩrosa'rata norĩ ãma hã, toi õ di. Simirosa'rata wasété nhiptete za'ra wa, ta norĩ ãma pẽ'ẽzé za'ra di. Tawamhã ĩsimizu'rã're ma, te tinha: — Ma'ãpé, asimizu wahutu. Tawamhã ma tô tinhimizu hã wahutu, aibâ hã. Taha wa, ma tô tinhimizu pese. ");
INSERT INTO xavNT_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Te te pese pari, ma awa'awi wairé, parisezu norĩ hã. Tawamhã Erodihi niwĩ 're ĩhâimana za'ra mono norĩ me, ma tô sima ãma roti za'ra, Zezusi te te sima hâiba za'ré za'ra da. ");
INSERT INTO xavNT_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","8","Tawamhã Zezusi norĩ hã te ai'aba'ré, Darireza na ĩsõ'u nhisi u. Da'ahâ uptabi na te ĩsarina ai'aba'ré ni, Darireza na danhipti'a nho'õmo nhisi hawimhã, duré Zudeza na danhipti'a nho'õmo nhisi hawimhã, duré Zeruzarẽ hawimhã, duré Idumeza hawimhã, duré Zodã pa zara hawimhã, duré Tiru hawimhã, duré Sido hawimhã. Zezusihi wasu'u hã ma tô wapari za'ra ni aré, te te 're ĩda'apawapto mono zé wasu'u na hã. Taha wa, ma tô ĩtẽme dasito, daro mono bâ. ");
INSERT INTO xavNT_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","10","Uburé ĩhâzé ré norĩ hã te ĩtẽme 're sisãmra, te te siwi upi da, tinhib'rata na. Taha wa, tisiré 're ĩnomro mono norĩ ma, te 'ru za'ra, uba're hã te te 'ma'âri za'ra da dawi, ĩwap sébré da, da te dasiwi hâiba wati tõ da. ");
INSERT INTO xavNT_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Wa'uburé te te 're ĩda'awamnarĩ mono norĩ hã, Zezusi te te 're 'madâ'â za'ra mono wamhã, hi'rãtitõ te ĩpapara 're sina. Te duré siwi 'mahâ, sa'ẽtẽ: — A hã 'Re ĩhâimana u'âsi mono 'ra. ");
INSERT INTO xavNT_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Taha wa, wa'uburé norĩ hã 'Re ĩhâimana u'âsi mono 'ra na te te dama sisi tõ za'ra da, te sina sadawa uwati za'ra, Zezusi hã. ");
INSERT INTO xavNT_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Tawamhã ẽtẽ 'rãihâ na, ma tô sai'u Zezusi hã. Tame te te sima ĩwẽzéb uwaibaba, te sitẽme sô tihârâ za'ra, aibâ norĩ zô. Sitẽme sô hârâ za'ra wa, ma tô ĩtẽme aihutu 'râwi. ");
INSERT INTO xavNT_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Tawamhã 12 na ĩhâiba za'ra hã ma tô pisutu za'ra, ĩsiré a'â 're hâimana za'ra mono da, nimahã na te te datẽme satõrĩ za'ra da, za te te 're ĩda'anho'reptui mono zé wasu'u na, ĩsõwa te te 're dapo're pu'u za'ra mono da, ĩsadawa para. Tizadawa wasu'u'wa na ma tô sisi za'ra oto. ");
INSERT INTO xavNT_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Ma tô duré pisutu za'ra, ĩwaihu'u pese zarina, wa'uburé norĩ te te dama 're sãmra za'ra mono da. ");
INSERT INTO xavNT_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","17","Aibâ norĩ hã, 12 na ĩhâiba hã ãne ĩsisi za'ra hã: Sima hã Pedru na, ma tô sisi té, Zezusi hã. Ĩsiré norĩ hã ãne ĩsisi za'ra hã: Ti'adu, duré Zuwã, Zebedehe 'ra norĩ hã. Bu'anezi na, ma tô sisi téb zahuré, Ti'adu norĩ hã Zezusi hã. Bu'anezi na, ĩsisi hã, tãirãrã te wasu'u, ĩsisi té hã. ");
INSERT INTO xavNT_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","19","Duré ĩsiré norĩ hã ãne ĩsisi za'ra hã: Ãdéré, duré Piripi, duré Batoromezu, duré Mateusi, duré Tome, duré Ti'adu, Apezuhu 'ra hã, duré Tadezu, duré Sima, Zeroti norĩ niwĩ aré 're ĩhâimana mono hã, duré Zudasi Icarizoti, si'uihâ na Zezusihi hâiba nhomri'wa da hã dama. Ãne ĩsisi za'ra hã. ");
INSERT INTO xavNT_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Tawamhã Zezusi hã 'ri tẽme oto morĩ wamhã, da'ahâ na ma duré ĩtẽme dasito. Ĩtẽme dasito mono wa, Zezusi norĩ hã saihuri waihu'u õ di. ");
INSERT INTO xavNT_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Tawamhã Zezusihi wasu'u te te wapari za'ra wa, ma tô sô ai'aba'ré, ĩsisãnawã norĩ hã. Ma tô ni'wam norĩ hã ĩ'rã siwamnarĩ na Zezusihi ãma romnomri za'ra. Taha wab zama, te sô ai'aba'ré, Zezusihi zô, ĩsisãnawã norĩ hã. ");
INSERT INTO xavNT_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","'Re ĩhâimana u'âsi mono nhimiroti 'rata na rob'ui'éré na dama rowahutu'wa norĩ hã, Zeruzarẽ hawi datẽme ĩsihutu norĩ hã, ãne te taré sima rowasu'u za'ra, Zezusihi hâiba na: — Õ hã Bezebuhu zadawa para te 're mo, wa'uburé norĩ nhib'apito zadawa para. Bezebu hã romhõsi na te te 're pawapto, wa'uburé te te dama 're anhamra mono da. — Ãne te taré 'râwi sima rowasu'u za'ra Zezusihi hâiba na, zudezu norĩ ma, rowahutu'wa norĩ hã. ");
INSERT INTO xavNT_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","26","Tawamhã Zezusi te sima sô tihârâ za'ra, rowahutu'wa norĩ zô, marĩ hã te te tãma waihu'u za'ra da, romnhimiré'é na. Tawamhã ĩtẽme simasa wamhã, ãne te tãma nharĩ za'ra: — E niha te za Satanasi hã tinhib'a'uwẽ norĩ hã te te dama 're sãmra. Te te dama 're ĩsãmra mono da hã, mare di. Ãne wa za aima ãma romnhimiré'é za'ra wa'wa, waihu'u za'ra wa'aba da. Danhib'apito nhib'a'uwẽ norĩ hã 'râwim nherẽ, oto sisada 're simasa mono wamhã, te aré 're si'uprosi. Duré dasisãnawã nherẽ, dasisada 're dasimasa mono wamhã, te aré 're dasi'uprosi, 'râwim nherẽ. Tane duré Satanasihi nhib'a'uwẽ norĩ hã 'râwi sisada 're simasa mono wamhã, te aré 're si'uprosi. Tâibâ aré ĩsib'a'uwẽ norĩ hã. Taha wa, Satanasi hã tinhib'a'uwẽ norĩ hã te te dama 're ĩsãmra mono da hã, mare di. ");
INSERT INTO xavNT_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","— Ãne wa za duré aima rowasu'u za'ra wa'wa, marĩ hã ãma waihu'u za'ra wa'aba da. Ni'wa hã aibâ ĩsiptete nhorõwa u, sébré wamhã, ĩsibro hã te te tiwi ubumro da, te te tiwi ubumroi waihu'u õ di za, te te sima pawasisi õ ré hã. Te za a'â sima pawasisi. Taha parip si, te za ĩsibro hã tiwi ubumro, 'ri 're ĩromnhimi'wara mono hã, aibâ ĩsiptete wi. — Ãne te tãma rowasu'u za'ra, Zezusi hã. ");
INSERT INTO xavNT_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Ma duré tãma waihu'u za'ra: — Ma'ãpé, ĩ̱wapari pese za'ra wa'aba za. Dawasédé hã da te 're 'manharĩ za'ra mono nherẽ, duré 'Re ĩhâimana u'âsi mono ãma, da te ãma 're wasété za'ra mono nherẽ, dawasété na tãma 're dasiwasu'u za'ra mono wamhã, dawasédé hã tãma waihu'u pese di, te te dama 're ĩ'apari mono zéb da hã, te te oto da'ãma 're ab'madâ'â tõ mono da. ");
INSERT INTO xavNT_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","30","Tane nherẽ, Ĩpẽ'ẽzani hã wẽ nherẽ, ĩsimiromhuri na da te 're wẽ'õ pese za'ra mono wamhã, taha na dawasédé hã te te dama 're apari mono õ di za. Te za te te da'ãma 're ab'madâ'â u'âsi, 'Re ĩhâimana u'âsi mono hã. — Ãne Zezusi ma tô tãma waihu'u za'ra, rowahutu'wa norĩ ma, taré te te sima rowasu'u za'ra wa, wa'uburé zadawa para, 're ĩmorĩ na. Ãne wẽ'õ te, ma tô ãne tãma waihu'u za'ra, te te waihu'u za'ra da. ");
INSERT INTO xavNT_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Tawamhã Zezusihi no norĩ hã ma tô ĩtẽme aihutu, tina me. Rowi simasab ré, ma da'maipo're pu'u za'ra, Zezusihi zô da'maihârâ da, ĩtẽme watobro za'ra da. ");
INSERT INTO xavNT_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Da'ahâ na te ĩ'rata asimro ni. Tawamhã ni'wam norĩ hã te tãma rowasu'u za'ra, ãne: — Ano norĩ hã te rowi asô aimasa, ana me. Te asô tihârâ za'ra. — Ãne te oto tãma rowasu'u za'ra. ");
INSERT INTO xavNT_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Tawamhã tãma ĩrowasu'u'wa norĩ ma, ma tô waihu'u za'ra, ãne: — E 'wa hã ĩ̱na. E 'wam norĩ hã ĩ̱no norĩ. ");
INSERT INTO xavNT_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Tawamhã siwi ĩ'uirĩ'wa norĩ 'madâ'â sina, te ãne tinha: — Ãhãta ĩ̱na. Ãhãta ĩ̱no norĩ. Ãhãta ĩ̱hidiba norĩ. ");
INSERT INTO xavNT_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Ni'wam norĩ hã 'Re ĩhâimana u'âsi mono te te sima 're ĩwẽ za'ra mono zéb zarina, te te tãma ãma 're ĩ'uwaimrami za'ra mono norĩ hã, ta norĩ hã ĩ̱no, duré ta norĩ hã ĩ̱hidiba, duré ta norĩ hã ĩ̱na. — Ãne Zezusi ma tô tãma waihu'u za'ra, da te waihu'u za'ra da. ");
INSERT INTO xavNT_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Tawamhã Zezusi hã te duré dama rowahutu, Darireza ãma, ĩsõ'u zapoto 'rata. Da'ahâ uptabi na ĩtẽme dasito mono wa, ma uba're wa ãzé, â zada'ré prã na. ");
INSERT INTO xavNT_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Tawamhã sa'ẽtẽ na ma tô dama rowaihu'u marĩ na, tinhimirowasu'u na romnhimiré'ézém na. Ãne te dama tinha: ");
INSERT INTO xavNT_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","— Ma'ãpé ĩ̱wapari pese za'ra wa'aba za. Amnho potozé wasu'u na, wa za aima rowasu'u za'ra wa'wa. Aibâ hã te buru u mo, ti'ai hâibâdâ wa, amnho hã te te anhamra mono da, poto mono da. ");
INSERT INTO xavNT_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Tawamhã, amnho hã te te anhamra mono wamhã, nima norĩ hã bâdâdi zababa ma tô rere'e. Tawamhã sire hã ma te te uprosi uburé, poto mono õ ré. ");
INSERT INTO xavNT_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Ẽtẽ nhisiwi ma duré nima norĩ hã rere'e. Ti'ai baihâire wa, ma tô 'wanhipré su'u, amnho hã. ");
INSERT INTO xavNT_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Tawamhã bâdâ hã oto 'rãiwatobro wamhã, rowa'ro wa, ma ti'wanhipré 'ré za'ra, ĩsari hã te te rowa'réi mono õ wa. ");
INSERT INTO xavNT_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Nima norĩ hã ma duré rere'e, wab'ru wazari. Tawamhã siré ma tô 'wanhipré. Siré 'wanhipré mono wamhã, ma te te ubu, wab'ru hã. Taha wa, 'rãi mono õ di, ta norĩ hã. ");
INSERT INTO xavNT_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Ti'ai wẽ wa, ma duré nima norĩ hã rere'e. Tawamhã oto 'wanhipré 'rãihâ mono wamhã, ma tô ti'rã za'ra. 'Rãi mono wamhã, nima niwĩmhã 'rãi ahâ prã ti, rob're hã. Duré nima niwĩmhã 'rãi ahâ di. Duré nima niwĩmhã 'rãi pese uptabi di. — Ãne amnho potozé wasu'u na, ma tô dama rowasu'u, Zezusi hã. ");
INSERT INTO xavNT_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Tawamhã ãne ma tô ãma dama 'rãsutu, timreme na: — Asimipari pese za'ra wa'aba wamhã, ma'ãpé ĩ̱wapari pese za'ra wa'aba, ĩ̱nhimirowasu'u na hã waihu'u za'ra wa'aba da. — Ãne ma tô ãma dama waihu'u. ");
INSERT INTO xavNT_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Tawamhã dazahutu parip si, ni'wam norĩ dame ĩsimasa hã ma tô ĩtẽme sina rotété za'ra dawa'rãmi, aibâ 12 na ĩhâiba norĩ me. Tawamhã ãne te siwi 'mahâ: — E niha amnho potozém na rowasu'u hã. ");
INSERT INTO xavNT_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","12","Taha wa, Zezusi asa ma tô ãma sada'âbâ za'ra: — 'Re ĩhâimana u'âsi mono hã a norĩ wa'aba ma si, ma tô aima waihu'u za'ra wa'wa, dama ĩwaihu'u'õ hã, da'ãma 're ĩsib'a'uwẽ mono zém na hã, sõ'awi te te dama waihu'u õ nherẽ. Ĩ̱zazei'õ'wa norĩ ma, wa za ĩ̱nhimiromnhimiré'é na si te tãma 're rowasu'u za'ra. Tawamhã ta norĩ hã titõmo na te te 're rob'madâ'â za'ra mono nherẽ, taré te za te te 're rob'madâ'â za'ra. Duré 're simipari za'ra mono nherẽ, taré te za 're simipari za'ra, te te 're waihu'u za'ra mono ãna. Te te 're waihu'u za'ra mono wamhã, te aré tiwasété wi 're sipizari za'ra, 'Re ĩhâimana u'âsi mono niwĩ, ĩwasédé hã te te ãma 're ab'madâ'â tõ mono da. — Ãne ma tô tãma waihu'u za'ra, Zezusi hã. ");
INSERT INTO xavNT_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Tawamhã ma duré tãma waihu'u za'ra: — A norĩ wa'wa hã waihu'u za'ra wa'aba õ wamhã, amnho potozém na te ĩrowasu'u hã, e niha te za tawamhã ĩ̱nhimirowasu'u amo hã ĩwaihu'u za'ra wa'wa. — Ãne ma tô tãma waihu'u za'ra. ");
INSERT INTO xavNT_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Tawamhã ma duré tãma waihu'u za'ra: — Amnho hã aibâ te te ĩ'anhamra mono hã, 'Re ĩhâimana u'âsi mono zadawa wasu'u, te wasu'u. ");
INSERT INTO xavNT_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Ni'wam norĩ hã 'Re ĩhâimana u'âsi mono zadawa wasu'u hã, tipo're na te te 're ĩwapari za'ra mono hã, aiwa amnho hã bâdâdi zababa ĩrere'e mono ne, te za 're hâimana za'ra. Awa'awi te te wapari za'ra wamhã, Satanasi hã te za ĩtẽme tiwisi za'ra, 'Re ĩhâimana u'âsi mono zadawa wasu'u hã te te tiwi âri za'ra da. ");
INSERT INTO xavNT_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Ni'wam norĩ hã aiwa amnho hã ẽtẽ nhisiwi ĩrere'e mono ne, te za 're hâimana za'ra. 'Re ĩhâimana u'âsi mono zadawa wasu'u hã te te 're wapari za'ra mono wamhã, te za te te 're saze za'ra awa'awi, to sina. ");
INSERT INTO xavNT_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Tane nherẽ, te za te te 're sazei hutu za'ra. Tawamhã ãté robzépada hã duré rowasédé hã te za ĩsazei'õ'wa norĩ hã te te tãma 're 'manharĩ za'ra. Tawamhã 'Re ĩhâimana u'âsi mono zadawa wasu'u hã aré te te 're ĩsaze za'ra mono zé hã, te za te te 're sazei utõrĩ za'ra. ");
INSERT INTO xavNT_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Ni'wam norĩ hã aiwa amnho hã wab'ru wazari ĩrere'e mono ne, te 're hâimana za'ra. 'Re ĩhâimana u'âsi mono zadawa wasu'u hã te za te te 're wapari za'ra, taré. ");
INSERT INTO xavNT_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","Ãté marĩ na si te za duré te te 're rosa'rata za'ra. Ãté danhibro pese na si, te za te te sima 're rosa'rata za'ra, ĩwẽ uptabi newa. Ãté marĩ hã te za te te sima 're wẽ uptabi za'ra. Tawamhã rob're ĩ'rãi õ ne, tãma 're hâimana wẽ za'ra mono õ di za. ");
INSERT INTO xavNT_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Ni'wam norĩ hã aiwa amnho hã ti'ai wẽ wa ĩrere'e mono ne, te za 're hâimana za'ra. Ta norĩ hã 'Re ĩhâimana u'âsi mono zadawa wasu'u hã te te 're wapari za'ra mono wamhã, te za te te sima 're wẽ za'ẽtẽ za'ra. Tawamhã rob're ĩ'rãi pese uptabi ne, te za hâimana wẽ uptabi na 're hâimana za'ra. — Ãne ma tô tinhimirowasu'u hã tãma 'rãsutu za'ra, Zezusi hã. ");
INSERT INTO xavNT_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Tawamhã te duré tãma rowasu'u za'ra: — Rob'uiwẽzé hã 'ri 're wa'wa u, da te âri wamhã, e piza'a na te za upsibi ni. E daza'warizéb 'rowi, te za sãrĩ ni. Mare di. Ĩsima'warazém na si te za sõ'awi da te 're sõré, te te dama 're rob'uiwẽ za'ra mono da. ");
INSERT INTO xavNT_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","23","Taha wa, marĩ hã a'â dama ĩwaihu'u'õ hã, niwapsi dama waihu'u pese di za. Aipo're na ma tô ĩ̱nhimiroti hã ĩwapari za'ra wa'wa. Taha wa, ma'ãpé ãma 're rosa'rata za'ra wa'aba mono, waihu'u za'ra wa'aba da. ");
INSERT INTO xavNT_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","25","— Ni'wam norĩ hã 'Re ĩhâimana u'âsi mono hã ĩsimirowaihu'u na te te 're 'ruiwapari u'âsi za'ra mono wamhã, taha zarina te za 'Re ĩhâimana u'âsi mono hã sa'ẽtẽ na tãma ãma 're sõprub za'ra, te te aré ãma 're ĩwaihu'u za'ra mono zém nhipai u, te te waihu'u pese za'ra da oto. Tane nherẽ, ni'wam norĩ hã ĩsimirowaihu'u na te te 're 'ruiwapari za'ra mono õ wamhã, ta norĩ wi te za tinhimirowaihu hã tãma waihu'u pese za'ra õ nherẽ, te te tiwi 're awaibu 'Re ĩhâimana u'âsi mono hã, te te aré ãma 're ĩwaihu'u za'ra mono zé hã. — Ãne ma tô tãma waihu'u za'ra, Zezusi hã. ");
INSERT INTO xavNT_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Tawamhã ma duré tãma waihu'u za'ra: — 'Re ĩhâimana u'âsi mono hã da'ãma 're ĩsib'a'uwẽ mono zém na, wa za aima rowasu'u za'ra wa'wa, ãne. Aibâ hã ti'ai wa, te za amnho hã te te anhamra, poto mono da. ");
INSERT INTO xavNT_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Tawamhã aibâ hã rĩtĩ ré nherẽ, duré sõtõ ré nherẽ, si'uihâ na te za ti'wanhipré za'ra, amnho hã. Te za ti'rãihâ za'ra. E niha te za ti'wanhipré za'ra. E niha te za ti'rãihâ za'ra. Aibâ hã te te waihu'u õ di. ");
INSERT INTO xavNT_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Ti'ai 'rowim nherẽ, te za si'uihâ na 're 'wanhipré za'ra, 're 'rã za'ra mono da. Te za a'â ti'wanhipré za'ra. Taha parip si, te za 're sitoro wairébé. Taha parip si te za 're 'rã za'ra. ");
INSERT INTO xavNT_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","'Rãi 'ré wapsi, te za oto 'rãihâ, ro'wa na aibâ hã, bâdâ hã oto ĩwa waptã'ã wa, te te ĩ'rãihârizéb da hã. — Ãne ma tô tãma rowasu'u za'ra, Zezusi hã. ");
INSERT INTO xavNT_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Tawamhã ma duré tãma waihu'u za'ra: — 'Re ĩhâimana u'âsi mono, da'ãma 're ĩsib'a'uwẽ mono zé hã, e marĩ na, wa za ãma romnhimiré'é. ");
INSERT INTO xavNT_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Motada nhamare na, wa za aima ãma romnhimiré'é za'ra wa'wa, 'Re ĩhâimana u'âsi mono, da'ãma 're ĩsib'a'uwẽ mono zé hã. Motada nhamare hã syry uptabire di, aimawi norĩ ma hã. ");
INSERT INTO xavNT_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Tazahã da te 're zuri mono wamhã, 're 'wanhipré za'ra mono wamhã, te za ti'rãihâ za'ra. Aimawi rob're hã te te 're sipai pese za'ra. Papo za'ẽtẽ wamhã, ĩsu 'rowi te za si norĩ hã te te sima 're sasi za'ra. Ãne wa aima ãma romnhimiré'é za'ra wa'wa. — Ãne te tinha, Zezusi hã. ");
INSERT INTO xavNT_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Ãne ma tô Zezusi hã tinhimirowasu'u ahâ na te te ãma 're romnhimiré'é, marĩ hã da te ãma 're ĩwaihu'u za'ra mono zéb da hã. ");
INSERT INTO xavNT_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Tinhimiromnhimiré'é na si, ma tô te te dama 're rowasu'u. Tisiré 're ĩnomro mono norĩ ma si, ma tô hâiba pisutu za'ra, te te tãma 're awaihu'u pese, sõ'awi. ");
INSERT INTO xavNT_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Tawamhã Zezusi hã barana ma tô satõrĩ za'ra, tisiré 're ĩnomro mono norĩ hã: — Oto zara u, wa te saprĩ za'ra wa'aba. — Ãne ma tô satõrĩ za'ra. ");
INSERT INTO xavNT_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Tawamhã te a'â dazatõrĩ za'ra, apâ dasi'aba'ré da. Taha pari, Zezusi hã uba're 're ĩsébrézéb 're, ma asisi ĩsarina, zara u te te saprĩ za'ra da. Ni'wam norĩ hã te duré siré sari za'ra uba're hã, Zezusihi zarina. ");
INSERT INTO xavNT_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Tawamhã rowa'u hã ma tô watobro, sa'ẽtẽ na. Tawamhã âsisasi hã sa'ẽtẽ wamhã, ma tô nasi asisi, uba're wa. Â hã te te ĩ'masisizéb u hã romhuture di oto. ");
INSERT INTO xavNT_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Tane nherẽ, te Zezusi hã nhono, uba're na're ãma. Da'rã zaparizém na te 'rã zapa. Taha wa, ma tô siwi utu. Ãne te oto siwi 'mahâ: — Rowahutu'wa, wa za ai'utõrĩ ni. E wa'ãma aipẽ'ẽzé za'ra õ di za. ");
INSERT INTO xavNT_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Tawamhã ma tô wahudu. Wahutu wamhã, rowa'u'u ma, te tinha, wa'u'utu da. Duré âsisasisi ma zama, te tinha, ãne: — Ma'ãpé ai'âtu na. Tawamhã ma tô sazâ, rowa'u hã. Ma tô duré ti'âtu oto. ");
INSERT INTO xavNT_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Tawamhã Zezusi hã te ãne tãma nharĩ za'ra: — E marĩ da, ma aipahi za'ra wa'wa. E niha zahadu asiwi 're ĩ̱'umnhasi za'ra wa'aba mono zé hã aima 're hâimana za'ra wa'aba mono õ di. ");
INSERT INTO xavNT_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Tawamhã te sima rowasu'u za'ra: — Pra, e niha õ hã ĩwaihu'u pe. Ĩsadawa hawi ma rowa'u hã sazâ, âsisasisi zama. — Ãne te sima rowasu'u za'ra. Õne hã tãma sa'rese za'ra õ wa, ma tãma tipahi za'ra. ");
INSERT INTO xavNT_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Tawamhã Zezusi norĩ hã ma tô zara u aihutu, Zeraza na danhipti'a nho'õmo nhisi u. Darireza ãma ĩsõ'u zapoto zara niwĩ, Zeraza hã. ");
INSERT INTO xavNT_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Tawamhã uba're hawi watobro wamhã, ma tô aibâ hã wa'uburé ré 're ĩmorĩ hã sina uzusi. ");
INSERT INTO xavNT_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","4","Aibâ hã adâ'â 'ru hawi, ma tô ĩtẽme watobro. Adâ'â 'ru ãma, te 're sãmra. Te aré da te 're pawasisi, ĩsi'uwazi nhorõ rutu na. Te aré duré da te 're hiwasisi. Tazahã ma tô te te sina 're anhinarĩ. Ni'wa hã sada 're siptete waihu'u mono õ di. ");
INSERT INTO xavNT_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Bâtâ sidâpâsi, duré mara sidâpâsi te adâ'â 'ru ãma 're hâimana, ẽtẽ 'rãihâ ãma zama, sadari sina. Ẽtẽ na te duré 're sisihâri u'âsi. ");
INSERT INTO xavNT_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Romhâ na, ma tô aibâ hã tisã, Zezusi hã. Te te sãmri wa, te ĩtẽme wara, Zezusihi u. Tawamhã hi'rãtitõ ma tô ĩpapara aime. ");
INSERT INTO xavNT_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","Sa'ẽtẽ te 'mahâ, ãne: — Zezusi, 'Re ĩhâimana u'âsi mono, danhipai u 're ĩsãmra mono 'ra, e marĩ ĩ̱'ãma 'manharĩ da, te we aimo. Ĩ̱'azâri õ di za. 'Re ĩhâimana u'âsi mono nho'a, wa ĩ̱sina aipa'uwati. ");
INSERT INTO xavNT_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Ãne te Zezusihi ma tinha wa'uburé hã, te te tãma rob'rui wa, aibâ hâiba hawi watobro da. ");
INSERT INTO xavNT_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Tawamhã Zezusi te ĩsisi zô sadanha: — E niha asisi hã. — Ahâ na, ĩ̱nhisi hã. E marĩ wa. Wa norĩ hã wa'ahâ wa. — Ãne te Zezusihi ma sisisi. ");
INSERT INTO xavNT_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Tawamhã Zezusihi wi, te nasi tiwi rowaptẽ, wa'uburé norĩ ma, te te rob'ru tõ da, darob amoi u, si'aba'ré tõ da. ");
INSERT INTO xavNT_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Tawamhã romhutu na te uhâbâ hã tisa te te 're huri, ahâ na, sa'a ãma. ");
INSERT INTO xavNT_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Tawamhã wa'uburé norĩ hã te Zezusihi wi sina rowaptẽrẽ za'ra, uhâbâi u: — Ma'ãpé uhâbâi u wazatõrĩ za'ra na, ĩhâiba 're, 're wasi'ubumroi mono da oto. ");
INSERT INTO xavNT_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Tawamhã ma tô tãma rob'ru za'ra, aibâ hâiba hawi wairébé da, uhâbâ hâiba 're, sisisi da. Tawamhã uhâbâ hâiba 're sisisi wi, uhâbâ te sisa're, wara sina, ĩ'rã sipra u. Âi ba ma rere. Âi ba rere'e wa, ma uburé ai'utõ, uhâbâ hã. 2 miu na ma tidâ'â za'ra. ");
INSERT INTO xavNT_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Si'utõrĩ wi, te uhâbâ 'madâ'â'wa norĩ hã ĩsiti sisa're wara sina, 'ri ahâ u, te te dama rowasu'u za'ra da, rom na 'ri wa'õtõ ãma zama. Tawamhã da'ahâ na ma tô ĩtẽme ai'aba'ré ni, da te 'madâ'â za'ra da. ");
INSERT INTO xavNT_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Tawamhã Zezusihi u dasihutu wamhã, ma tô aibâ hã 'madâ'â za'ra ni, wa'uburé norĩ ré aré 're ĩmorĩ hã. Uza ré, te oto nhamra, rowẽ na. Tawamhã ma tô tãma tapahi za'ra ni, õne hã dama sa'rese õ wa. ");
INSERT INTO xavNT_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Tawamhã ãma ĩ'madâ'â za'ra 'wa norĩ hã, te aibâ wasu'u hã dama wasu'u za'ra, ĩsihutu norĩ ma. Aibâ hã Zezusi te te ĩpawaptobzém na, duré uhâbâi ma, te te ĩrob'manharĩzém na zama, te dama rowasu'u za'ra. ");
INSERT INTO xavNT_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Tawamhã, te siwi satõ, danhipti'ai hawi watobro da, Zezusi hã. ");
INSERT INTO xavNT_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Taha wa, Zezusi ma oto ãzé uba're wa, danhiti morĩ da. Uba're wa, sébré wi, te aibâ hã ãne sina 'mahâ, wa'uburé ré aré 're ĩmorĩ hã: — Ma'ãpé ĩ̱ma pisutu, asiré 're ĩ̱morĩ da. ");
INSERT INTO xavNT_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Tane nherẽ, Zezusi te te ãma sazei õ di. Taha wa, ma te aibâ ma waihu'u, ãne: — Apâ te za aimo, asõrõwa u, 'Re ĩhâimana u'âsi mono, ĩwẽ na te te aipawaptobzém na asisãnawã norĩ ma, asiwasu'u da. ");
INSERT INTO xavNT_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Tawamhã te oto mo, aibâ hã. Zezusi, ĩwẽ na te te ĩpawaptobzém na, ma tô te te dama 're rowasu'u, Decapori na danhipti'a nho'õmo nhisi 're. Tawamhã ĩsimirowasu'u na da te 're wapari za'ra mono wamhã, ma tô ãma 're datob'uzu za'ra. ");
INSERT INTO xavNT_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Tawamhã Zezusi hã ma tô apâ saprĩ, zara u. Da'ahâ na, ma ĩtẽme tasi'rã'õtõ ni, â zaihâ u hã. ");
INSERT INTO xavNT_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Tawamhã aibâ hã ma ĩtẽme wi, Zairu na ĩsisi hã zudezu norĩ te, rowahutuzé 'madâ'â'wa hã. Ĩtẽme wisi wi, ma tô hi'rãtitõ aime, Zezusihi papara. ");
INSERT INTO xavNT_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","Ãne te tãma tinha: — Ĩ̱'ra hã hâzé ahâ di, azaruture hã. Te za ĩ̱wi dârâ. Taha wa, te za ãma ĩ̱siré aimo, asib'rada hã ãma nomri da, ĩ̱ma pese da, dâ'â tõ da. — Ãne ma tô tãma tinha. ");
INSERT INTO xavNT_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Tawamhã Zezusi te ĩme mo. Da'ahâ na ĩsiré dasi'aba'réi wamhã, ma dasiwi hâiba wati ni. ");
INSERT INTO xavNT_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Tawamhã morĩ ré, ma pi'õ hã ĩtẽme wi, ĩhâzé te te 're ĩ'manharĩ mono hã. Wahub ahâ na te hâzé ré 're hâimana, 12 na ãma ĩwahubzé hã. ");
INSERT INTO xavNT_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Dawede'wa norĩ hã ma tô ahâ na te te 're wede za'ra. Dawede'wa nhib'rata 're hâimana mono ré, ma tô te te 're robzépata za'ẽtẽ, pi'õ hã. Uburé tinhibro hã ma tiwede'wa norĩ ma uprosi, tiwede wa'âbâzém na. Taha wa, 're séptâ'â mono õ wa, ma tô ĩhâzé hã te te tiwi 're wasété u'âsi, ĩhâiba hã. ");
INSERT INTO xavNT_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","29","Tawamhã Zezusihi wasu'u te te wapari wamhã, dawa'wa u ma tô ãzé, ĩbabarãi hawi. Ãne ĩsimirosa'rada hã: “Zezusihi uza si te tiwi upi nherẽ, wa za ĩ̱pese.” Ãne te sima rosa'rata, pi'õ hã. Taha wa, te ĩtẽme mo. Ĩ'uza si ma tiwi upi. Tawamhã ĩ'uza te te tiwi upi wi, awa'awi ma tô séptârâ. Marĩ hã tãma ĩsipari na, ma tô 'râwi sihâiba waihu'u. ");
INSERT INTO xavNT_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Awa'awi ma tô duré sina waihu'u, Zezusi hã tiwaihu'u pese na te te ĩda'maipese na. Taha wa, ma aipi'ra, da'ahâ wa'wa. Ãne te tawamhã da'a'mahâ: — E 'wa hã ma ĩ̱'uza hã ĩ̱wi upi. ");
INSERT INTO xavNT_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Tawamhã ĩsiré 're ĩnomro mono norĩ hã te asa tãma nharĩ za'ra: — Oro aihĩni ai'ãma wasi'uirĩ mono za, te ĩwa'azadanha. — Ãne te asa tãma nharĩ za'ra, ĩsiré 're ĩnomro mono norĩ hã. ");
INSERT INTO xavNT_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Tane nherẽ, Zezusi hã ti'upi'wa zô te te 're rob'madâ'â. ");
INSERT INTO xavNT_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Taha wa, te ĩtẽme mo, pi'õ hã. Ma tô sihâiba waihu'u, ĩhâzé te te tãma ĩpari na. Taha wa, pahi nherẽ, te ĩtẽme mo, rẽrẽ'ẽ sina. Hi'rãtitõ ma aime Zezusihi papara, tãma siwasu'u da. Ma tô tãma siwasu'u pese, pi'õ hã. ");
INSERT INTO xavNT_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Tawamhã Zezusi ma tô tãma waihu'u: — Ĩ̱hidiba, za te aipesezém na, asina ĩ̱'umnhasi wa, ma tô aihâzé hã aima apa. Rowẽ na si aimorĩ. Ma tô aipe. — Ãne ma tô tãma waihu'u. ");
INSERT INTO xavNT_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Tawamhã pi'õi ma, te te rowasu'u ré, ma tô aihutu, Zairuhu nhorõwa hawimhã tãma ĩromhuri'wa norĩ hã. Ãne te tãma rowasu'u za'ra: — Ai'ra azaruture hã ma tô aiwi dârâ. Simiromhuri nherẽ, rowahutu'wai wi, ro'wa'ré õ'umnhasite, te za ãma ĩrosazâ. — Ãne te tãma rowasu'u za'ra. ");
INSERT INTO xavNT_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","37","Tazahã ĩsimirowasu'u za'ra hã te te 'madâ'â õ di, Zezusi hã. Taha wa, te Zairuhu ma tinha: — Ai'ra wasu'u ma, aipahi tõ. Ĩ̱wétési ĩ̱'umnhasi, te aipawaptob da. — Ãne ma tãma waihu'u. Ni'wa hã ĩsiré morĩ tõ da, ma tô pisutu za'ra, Pedru norĩ hã Ti'adu, Zuwã norĩ me si, ĩsiré si'aba'réi da, Zairuhu 'ra u. Ti'adu, duré Zuwã, ta norĩ hã tisisãnawã zahuré. ");
INSERT INTO xavNT_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Tawamhã Zairuhu nhorõwa u sihutu wamhã, ma tô da'ab'madâ, Zezusi hã. Azarutu ãma te ta'ry'ry ni, dawawai 'rãihâ sina. Taha wa, ro'wa'rutu di 'ri paramhã. ");
INSERT INTO xavNT_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Tawamhã te dama tinha: — E marĩ wa, te ai'ahâ na aiwa'õ za'ra wa'wa. Azaruture hã dâ'â õ di. Taré te nhono. — Ãne ma tô tãma waihu'u za'ra. ");
INSERT INTO xavNT_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Tawamhã asa te tãma nharĩ za'ra: — Oro taré sõtõ za. Pẽ'ẽzani õ di. Tawamhã Zezusi hã ma tô dama rob'ru, rob u dawairébé da, uburé. Si'ubdatõ ĩsiré 're ĩnomro mono norĩ hã ma tô ĩsiré asisi, 'ri 're wa'wa u, ĩnomrozéb u hã. Ĩna norĩ si, ma tô ĩsiré tizasi zahuré. ");
INSERT INTO xavNT_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Tawamhã ma tô pa'â, Zezusi hã. Ãne te tãma tinha: — Tarita tumi. Ãne ãma ĩsaprĩzé hã: “Azaruture aiwahutu.” ");
INSERT INTO xavNT_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Tô awa'awi azaruture hã ma wahudu, 12 na ãma ĩwahu hã. Para na te oto 're mo. Tawamhã uburé 'ri para ĩsimasam norĩ hã ma ãma titob'uzu za'ra. ");
INSERT INTO xavNT_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Tawamhã Zezusi te ĩna norĩ ma nharĩ zahuré, rowasu'u na te te dama ãma ropé zahuré tõ da. Mram na si, te duré wada'uri zahuré, ti'ra ma, te te a zahuré da. ");
INSERT INTO xavNT_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Tawamhã Zezusi norĩ hã Nazaré u, ma tô apâ ai'aba'ré, Zezusi hã aré 're ĩhâimana mono zéb u. ");
INSERT INTO xavNT_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","4","Tawamhã datẽme sihutu wamhã, zudezu norĩ te, romhuri zahârizém na te oto dama rowahutu, sabadu na, rowahutuzéb ãma. Da'ahâ na da te wapari za'ra wamhã, ma tô ãma tatob'uzu za'ra ni, ĩsimirowasu'u na hã. Ãne te duré ãma tasisadanharĩ za'ra ni: — Pra. E ma hawimhã, ma uburé marĩ hã awaihu'u, waihu'u pese na, te te dama 're ĩrowasu'u mono da hã. E niha bété õhõ ma si waihu'u pese di, marĩ dama ĩ'manharĩ waihu'u'õ hã te te dama 're ĩ'ab'manharĩ wẽ mono zéb da hã. Õ hã wede'é na romhuri'wa, Marizaha 'ra. Ĩno norĩ hã Ti'adu, duré Zuzé, duré Zuda, duré Sima. Ĩhidiba norĩ hã te duré wa'rata 're hâimana za'ra. — Ãne te ãma dasima romnhoré za'ra ni. Ãne wa, Zezusihi zô datob'uzu za'ra õ di, dama waihu'u pese wa, ãne na hã. Taha wa, ma ãne dama waihu'u, Zezusi hã: — 'Re ĩhâimana u'âsi mono zadawa wasu'u'wa norĩ hã daro mono bâ datẽme 're nomro mono wamhã, ĩsimiroti na wazép sina, te za sô 're datob'uzu za'ra. Ĩsipti'ai ãma si sô 're datob'uzu za'ra mono õ di za, ĩsipti'ai ãma wa. Ĩsisãnawã norĩ zama, sô 're tob'uzu za'ra mono õ di za, ĩsõrõwa ãma ĩsiré 're ĩdahâimana za'ra mono norĩ zama. — Ãne sõ'awib õ nherẽ, ma tô dama siwasu'u, Zezusi hã. ");
INSERT INTO xavNT_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Taha wa, Nazaré ãma sô datob'uzu za'ra õ wa, marĩ dama ĩ'manharĩ waihu'u'õ hã ahâ na te te dama 'manharĩ õ di, tiwaihu'u pese na hã. Ni'wam norĩ si, ma tô upi za'ra, tinhib'rata na te te pese za'ra da, da'umro na. ");
INSERT INTO xavNT_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Taha wa, 'Re ĩhâimana u'âsi mono zadawa wasu'u'wa na da te dasiwi saze za'ra õ wa, te taré da'ãma rosa'rata, da te dasiwi ĩsaze za'ra õ zém na hã. Tawamhã Nazaré 'rata 're ĩdahâimana za'ra mono norĩ ma, te te 're rowahutu oto Zezusi hã, 'ri wa'õtõ mono bâ. ");
INSERT INTO xavNT_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Tawamhã tisiré 're ĩnomro mono norĩ zô, te tihârâ za'ra, aibâ 12 na ĩhâiba norĩ zô. Taha pari, ma tô maparane si te te apisutu, daro mono bâ si'aba'ré da, datẽme. Si'aba'réi õ ré, ma tô duré tãma pisutu za'ra, ĩsimiromhõsi zarina, wa'uburé hã te te dama 're sãmra za'ra mono da. ");
INSERT INTO xavNT_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Ma duré tãma waihu'u za'ra, marĩ hã te te siré 'wasari tõ da, bâdâdi na da hã. Tisiwazusizéb ré si si'aba'ré da, ma tô tãma waihu'u za'ra. Mra hã duré romramizé hã duré rob'uiprazé hã te te 'wasari tõ da, ma tô duré tãma waihu'u za'ra. ");
INSERT INTO xavNT_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Tipara'uza ré si si'aba'ré da, ma tô tãma waihu'u za'ra. Duré da'uza ĩhâpa ĩsõ'utu'u hã te te 'wasari tõ da, tihâiba na ré si si'aba'ré da, ma tô tãma waihu'u za'ra. ");
INSERT INTO xavNT_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Ãne ma tô duré tãma waihu'u za'ra: — Darob u, 're aihutu aba mono wamhã, te te 're ĩ'aiwaibui wẽ wa'aba mono norĩ nhorõwa ãma si, te za a'â 're asimroi wa'aba mo, darob amoi u, duré 're aiwairébé aba mono õ ré. ");
INSERT INTO xavNT_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Da te 're aiwaibui wẽ za'ra wa'aba mono õ wamhã, duré da te 're aiwapari ze za'ra wa'aba mono õ wamhã, te za dahawi 're aiwairébé su'u aba mo. Tawamhã dahawi 're aiwairébé aba mono õ ré, te za asisa'u aipara zapru hã 're ĩtata'a za'ra wa'aba mo, ti'ai u 're rere'e mono da, dapo're õ na 're danomro mono wa, 'râwi 're dasisãmri za'ra mono da. — Ãne ma tô tãma waihu'u za'ra. ");
INSERT INTO xavNT_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Tawamhã ĩsiré 're ĩnomro mono norĩ hã te oto datẽme ai'aba'ré, te te dama 're sadawa wasu'u za'ra mono da, dawasété wi 're dasipizari za'ra mono da, 'Re ĩhâimana u'âsi mono niwĩ. ");
INSERT INTO xavNT_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Wa'uburé hã te te oto dama 're sãmra za'ra. Duré azeitona 'rãi wa'u wam na, te te 're da'rãi u'ré za'ra mono pari, ma tô da'ahâ na te te 're dapese za'ra, dahâzé u'âsi 're ĩdahâimana za'ra mono hã. ");
INSERT INTO xavNT_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Tawamhã apito Erodi hã ma tô Zezusihi wasu'u hã wapa, ĩwasu'uwẽ hã daro mono bâ waptã'ã mono wa. Ãne te ni'wam norĩ hã Zezusihi wasu'u na taré te te sima 're romnomri za'ra: — Õ hã, Zuwã Batita apâ ĩhâiwa'udu. Taha wa, te marĩ hã dama ĩ'manharĩ waihu'u'õ hã te te dama 're ab'manharĩ, tiwaihu'u pese na. — Ãne te te sima ãma 're romnomri za'ra, taré. ");
INSERT INTO xavNT_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Ni'wam norĩ hã te duré te te sima ãma 're romnomri za'ra, ãne: — Õ hã Eriasi, duréihã dâ'â nherẽ, apâ ĩhâiwa'udu. — Ãne te te ãma sima 're romnomri za'ra, taré. Ni'wam norĩ hã te duré te te sima ãma 're romnomri za'ra, ãne: — Õ hã 'Re ĩhâimana u'âsi mono zadawa wasu'u'wa, duréihã 're ĩnomro mono norĩ ne hã. — Ãne te Zezusihi wasu'u na taré da te dasima ãma 're romnomri za'ra. ");
INSERT INTO xavNT_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Tawamhã apito Erodi, ma tô Zezusihi wasu'u na hã danhimirowasu'u hã wapa. Tawamhã ãne te tinha: — Tô õ hã, Zuwã Batita. Te 'rui wa, da te butu nhizâri nherẽ, apâ ĩhâiwa'udu te 're mo. — Ãne ma tô Erodi hã Zuwã Batita dama wasu'u, ta hã newa. ");
INSERT INTO xavNT_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","18","Erodi hã ma tô aré dama ti'ru, Zuwã Batita da te dasiwi pawasisi da, da te dasiwi sẽrẽ da, dazazéb 're, 're sa mono da. Ãne ma tô Erodi hã Zuwãhã ma, rob'manharĩ wasété. E marĩ da. Ĩmro ma, tãma rowẽ da, Erodizaha ma. Tinoi wi, ãma ĩsi'ré na, ma timro, Piripihi mro na, Erodi hã. Ãma mro wa, Zuwã ma tô Erodihi ma tinha: “'Re ĩhâimana u'âsi mono nhimiroti hã ãne: ‘Asisãnawãi mro hã tiwi ãma 're ai'ré za'ra wa'aba mono õ di za.’ ” — Ãne ma tô Erodihi ma waihu'u, 'Re ĩhâimana u'âsi mono nhimiroti hã. ");
INSERT INTO xavNT_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","20","Taha wa, Erodiza hã te te sina 're mreme 'ruiwapari, Zuwã hã. Te te wĩrĩ neza. Tane nherẽ, te te wĩrĩ waihu'u õ di. E marĩ wa. Erodi hã te te tiwi 're 'madâ'â pese, Zuwã Batita hã. Zuwã hã wẽ uptabi na, te dama 're hâimana. Ãne na ma tô ĩhâimanazém na waihu'u, Erodi hã. Taha wa, sina 're pahi mono wa, ma tô dawi te te 're 'madâ'â pese, Zuwã hã. Zuwãhã nhimirowasu'u hã te nasi wapa, Erodi hã. Tawamhã wapari ze na nasi te te wapari wa, zahadu rosa'rada te te sima ãma waihu'u õ di Erodi hã, Zuwã Batitaha ãma hã. ");
INSERT INTO xavNT_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Tawamhã ma tô bâdâ hã pisutu Erodi hã, ĩwa ĩwaptã'ãzém na dasipo're pu'u za'ra wa, ĩsiré dasa hã da te huri da. Taha wa, ma tô dama ĩpire norĩ hã ĩsiré tisa tihu, da'wapéi'wa norĩ nhib'apito norĩ hã, duré Darireza na danhipti'a nho'õmo nhisi ãma dama ĩpire 're ĩhâimana za'ra mono hã. Tawamhã aihĩni dasiré dasaihuri ré, Erodizaha ma wẽ di, Zuwã Batita ĩdâ'âzéb da hã. ");
INSERT INTO xavNT_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Taha wa, dasaihuri ré, ma Erodizaha 'ra sipi'õ hã ãzé 'ri para u, dama sipese da. Tawamhã Erodi norĩ hã ma tô ãma uze za'ra, tãma sipese za'ra wẽ te. Taha wa, te apito hã azarutu ma tinha: — Marĩ ĩ̱wi waptẽrẽ, asima ĩwẽzéb uwaibaba. Tawamhã wa za aima tisõ. ");
INSERT INTO xavNT_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Tô sena marĩ ĩ̱wi waptẽrẽ wamhã, wa za aima ãma uwaimra. Ĩ̱nhipti'a ĩ̱wi waptẽrẽ wamhã, aiwa wa za ãma aipo'o aima, ate da, duré ĩ̱te da. — Ãne ma tô tãma waihu'u, azarutu ma. ");
INSERT INTO xavNT_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Taha wa, te tina u a'â mo, marĩ hã apito wi te te ĩwaptẽrẽ da na, te te sadawa pibu da, tina hã. Tawamhã ĩna hã ãne te asa tãma tinha: — Ma'ãpé, Zuwã Batitaha 'rã si tiwi waptẽrẽ, taha si te te aima sõmri da. — Ãne ma ti'ra ma waihu'u. ");
INSERT INTO xavNT_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Taha wa, si'aba'ré na ma apâ ãzé apito u, azarudu hã. Tawamhã ãne te apito ma tinha: — Zuwã Batitaha 'rã si, wa ĩ̱sima wẽ, piza'a 're nho'a wa, ĩ̱ma hiri da, ãhãna awa'awi. — Ãne te tiwi waptẽ. ");
INSERT INTO xavNT_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Tawamhã ma tô tiwi tirobzei'õ, apito Erodihi wi. Tane nherẽ, uburé sô ĩdahârâ norĩ nho'a, te te azarutu ma ropisutu wa, ma tô tãma ãma uwaimra, te te tiwi ĩwaptẽrẽzéb uwaibaba. ");
INSERT INTO xavNT_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Tawamhã ma tô ti'ru, awa'awi ĩ'rã te te we âri da, da'wapéi'wa hã. Tawamhã awa'awi te sô mo, dazazéb u. Tame awa'awi ma tô butu nhizâ, Zuwã Batita hã. ");
INSERT INTO xavNT_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Taha wa, te awa'awi ti'â, piza'a 'renho'a wa, azarutu ma, te te sõmri da. Te te tãma sõmri parip si, ma tina ma oto tisõ, Zuwã Batitaha 'rã hã. ");
INSERT INTO xavNT_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Tawamhã Zuwã Batitaha zawi'wa norĩ hã ĩwasu'u te te wapari za'ra wamhã, ma tô sô ai'aba'ré, ĩhâiba zô, te te siwi sẽrẽ da, ab're 're. ");
INSERT INTO xavNT_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Tawamhã Zezusihi zadawa wasu'u'wa norĩ hã darob amoi hawi apâ sihutu wamhã, Zezusihi ma, ma tô siwasu'u za'ra, ĩwẽ na te te ĩdapawaptob za'ra mono zém na hã. Duré te te dama ĩrowasu'u za'ra mono zém na zama ma tô tãma siwasu'u za'ra. ");
INSERT INTO xavNT_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Tawamhã da'ahâ uptabi na ĩtẽme dasisamarĩ pese wa, saihuri waihu'u õ di, Zezusi norĩ hã. Taha wa, ma tô ãne satõrĩ za'ra, Zezusi hã: — Oto wasi'aba'réi wa'aba a'ubuni u, wawa'utu za'ra da a'â, danhiti. ");
INSERT INTO xavNT_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Tawamhã hâiba pisutu te oto ai'aba'ré, uba're u. Uba're wa, ma tô asisi, zara u te te saprĩ za'ra da, danhiti hâimana za'ra da a'â, zara niwĩ. ");
INSERT INTO xavNT_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Tane nherẽ, da'ahâ na ma tô waihu'u za'ra ni, zara u te te ĩsaprĩ za'ra na hã. Taha wa, ma tô ĩsõ'rãmib za'ra dasisa're, â zada'réi baba, Zezusi norĩ nho'rãmi, daza'rui mono bâ 're ĩdahâimana za'ra mono norĩ hã. Tawamhã Zezusi norĩ wana, ma tô aihutu ni. ");
INSERT INTO xavNT_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Tawamhã Zezusi hã uba're hawi watobro wi, ma tô da'ahâ uptabi na da'ab'madâ. Taha wa, ma tô da'ãma tipẽ'ẽzé, pone'ẽrebâ 'madâ'â ãna 're ĩnomro mono ne, 're danomro mono wa. Tawamhã tame ma tô marĩ na tinhimirowasu'u ahâ uptabi na dapawapto, Zezusi hã. ");
INSERT INTO xavNT_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Tame tiwi hâiwahâ wamhã, Zezusihi siré 're ĩnomro mono norĩ hã ma ĩtẽme ubumro. Ãne ma Zezusihi ma waihu'u za'ra: — A'ubuni wi wahâimana za'ra ré, ma wawi tihâiwahâ za'ra. ");
INSERT INTO xavNT_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","E dama rob'rui õ di za, dasi'aba'ré da, marĩ hã dasazéb da, da te dasima uipra za'ra da, re na 'ri ĩsimasa mono u, 'ri wa'õtõ u zama. ");
INSERT INTO xavNT_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Tawamhã Zezusi, ma tô asa tãma waihu'u za'ra: — Mare di. A norĩ wa'wa hã te za dama ĩ'a za'ra wa'wa, dasaihuri da. Tawamhã asa ma duré tãma waihu'u za'ra, Zezusihi ma: — E niha wa za dasa hã dama uipra za'ra ni, da'ahâ uptabi nherẽ. Rob'uiprazé hã ahâ uptabi na, wama hâimana za'ra 'wa'âhã, 200 na wa aré dasa hã dama uipra za'ra ni, ĩ'u'ẽtẽ wapu hã. ");
INSERT INTO xavNT_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Tawamhã Zezusi te asa sô sadanharĩ za'ra: — E niha te bété ĩ'u'ẽtẽ wapu hã aima tihâimana za'ra wa'wa. Ma'ãpé sô sabu za'ra wa'aba. Tawamhã ĩsiré 're ĩnomro mono norĩ hã te te sabu za'ra pari wamhã, Zezusihi ma, te wasu'u za'ra: — 5 na ĩhâiba hã ĩ'u'ẽtẽ wapu hã, duré maparane pe'a hã. — Ãne ma apâ Zezusihi ma waihu'u za'ra. ");
INSERT INTO xavNT_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Tawamhã Zezusi hã ma tô dama waihu'u, dui wa, dawa'õtõ mono bâ dasi'ubumroi mono da, uburé. ");
INSERT INTO xavNT_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Taha wa, dui wa, te oto dasi'ubumro, ni'wam norĩ si 100 na ĩhâiba hã, duré ni'wam norĩ hã 50 na ĩhâiba hã. ");
INSERT INTO xavNT_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Tawamhã ma tô oto ĩ'u'ẽtẽ wapu hã waibu, 5 na ĩhâiba hã. Pe'a zama ma duré timra. Tawamhã hâiwa u te ĩré rob'madâ. Timama ãma te tiwata, sõpru wa. Taha pari, ma tô te te wẽ'ẽ, ĩ'u'ẽtẽ wapu hã. Te te wẽ'ẽi mono pari, ma tô tisiré 're ĩnomro mono norĩ ma sõmri za'ra, te te dama sõmri za'ra mono da. Pe'a zama, ma tô te te wẽ'ẽ zahuré, te te duré dama sõmri za'ra mono da. ");
INSERT INTO xavNT_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Tawamhã ĩ'u'ẽtẽ wapu hã umrore nherẽ, wẽ'ẽi ahâ di. Duré pe'a hã maparane nherẽ, wẽ'ẽi ahâ di. Taha wa, ma tô aihĩni dasa hã huri ni. Ma tô duré da te 'mahâpãrĩ. Da'ahâ uptabi nherẽ, da'ãma si'utõrĩ õ di. ");
INSERT INTO xavNT_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Tawamhã ĩsiré 're ĩnomro mono norĩ hã ma tô apâ si'õtõ 're te te sé, danho'rada hã, ĩ'u'ẽtẽ wapu wẽ'ẽ hã, pe'a wẽ'ẽ zama. 12 na ĩré hã si'õno hã, danho'rata ré hã. Si'õtõ 'remhã 'masisi di. ");
INSERT INTO xavNT_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","5 miu na aibâ norĩ hã ĩhâiba hã, ĩ'u'ẽtẽ wapu na ĩsaihuri hã. ");
INSERT INTO xavNT_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Taha pari, ma tô Zezusi hã tãma rob'ru za'ra, tisiré 're ĩnomro mono norĩ ma, uba're wa sisisi da, ĩwana te te saprĩ za'ra da zara u, Besada na 'ri wa'õtõ nhisi u, si'aba'ré da, ĩwana. Tawamhã Zezusi hã te a'â ĩsa'u tizab za'ra, te te dama rob'ru da, danhorõwa u, da te ropéi mono da. ");
INSERT INTO xavNT_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Te te dama rob'rui pari, te ẽtẽ 'rãihâ u mo, Timama ma, mreme da. ");
INSERT INTO xavNT_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Tawamhã oto tiwi mara za'ra wamhã, uba're hã â wa'wa u, ma tô ĩré tihâimana za'ra. Taha ré, Zezusi hã siwaprosi te a'â tihâiba, ẽtẽ 'rãihâ ãma. ");
INSERT INTO xavNT_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Tawamhã ẽtẽ 'rãihâ hawi, ma tô 'madâ'â za'ra tisiré 're ĩnomro mono norĩ hã, uba're sari na si'u'ẽtẽ za'ra mono ré, rowa'u'u za'ẽne apâ te te tiwi wabzuri za'ra mono wa, uba're hã ĩsõ'õmoi baba te te rowapõrĩ za'ra wa. Taha ré, ma tô Zezusi hã ĩtẽme timorĩ za'ra â nhisi baba, mara hâ ré. Tawamhã ĩsõ'rãmi te aré timorĩ za'ra, Zezusi hã. ");
INSERT INTO xavNT_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","50","Â nhisi baba ĩtẽme morĩ za'ra wamhã, te ãma rosa'rata za'ra, adâ'â hâiba warõ newa. Taha wa, tãma pahi za'ra wa, te tãma 're sadari za'ra. Taha wa, te Zezusi hã awa'awi tãma si'mahârâ za'ra, ãne: — Wa hã wa we atẽme ĩ̱morĩ 'wa. Ĩ̱ma aipahi za'ra wa'aba õ di za. ");
INSERT INTO xavNT_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","52","Tawamhã awa'awi uba're wa, ma tô ĩtẽme tizébré za'ra. Sébré wi, ma rowa'u hã sazâ. Taha wa, rowa'u te te ĩsazârizém na, ma ãma titob'uzu za'ra, ĩsiré 're ĩnomro mono norĩ hã. E marĩ wa. Zezusi hã ĩ'u'ẽtẽ wapu te te dama wẽ'ẽi mono wamhã, ahâ di. Tane nherẽ, te te siwi ãma waihu'u su'u õ di, ĩwaihu'u pese uptabi na hã. ");
INSERT INTO xavNT_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Tawamhã Zezusi norĩ hã ma tô saprĩ za'ra, ĩsõ'u na zara u. Te te saprĩ za'ra wamhã, ma tô aihutu, Zenezaré na danhipti'a nho'õmo nhisi u. Tame ma tô â zada'ré ãma, uba're na ãma wasisi za'ra. ");
INSERT INTO xavNT_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Tawamhã uba're hawi wairébé wamhã, awa'awi ma tô dasiwi waihu'u za'ra ni, Zezusi hã. ");
INSERT INTO xavNT_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Tawamhã daza'rui mono bâ, ma tô ĩhâzé ré norĩ hã ĩtẽme 'wasari ni, Zezusihi hâimanazéb u, ĩsimiwaptâ ré. ");
INSERT INTO xavNT_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Daro mono bâ te Zezusi hã datẽme 're mo, 'ri wa'õtõ u zama 'ri nho'õmo u zama, re na 'ri ĩsimasa mono u zama. Darob u datẽme 're simasisi mono wi, ma tô ĩhâzé ré norĩ hã da te tãma 're sa'ra za'ra, 'ri nhi'riti wa, da te dasina 're ĩ'ubumroi mono zéb ãma. Tawamhã ma tô tiwi rowaptẽrẽ za'ra ni, ĩ'uza nhisutu si ĩhâzé ré norĩ hã te te tiwi 're upi za'ra mono da. Tawamhã ĩ'uza nhisutu si te te tiwi 're upi za'ra mono nherẽ, ma tô 're séptâ'â za'ra, uburé ĩhâzé ré norĩ hã. ");
INSERT INTO xavNT_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Tawamhã aibâ norĩ hã Zeruzarẽ hawi ĩsihudu hã ma tô Zezusihi u si'rã'õtõ, zudezu norĩ hã. Ta norĩ hã parisezu, duré 'Re ĩhâimana u'âsi mono nhimiroti 'rata na rob'ui'éré na dama rowahutu'wa norĩ. ");
INSERT INTO xavNT_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Ta norĩ hã ma tô 'madâ'â za'ra, Zezusihi siré 're ĩnomro mono norĩ hã, parisezu norĩ nhimiroti hã te te 'madâ'â za'ra ãna, saihuri wa, simisõi pese ãna. ");
INSERT INTO xavNT_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","4","Zudezu norĩ hã tihi'rata norĩ nhimiroti zarina si, te 're hâimana za'ra. Tisiré zudezu norĩ nhipai u, te taha si te te 're 'madâ'â pese za'ra, parisezu norĩ hã. Taha wa, 're simisõi pese za'ra mono parip si, te za 're saihuri. Duré marĩ hã dasai wedezém hawi 'ri tẽme te te 're ĩ'ãwisi za'ra mono hã, te za te te 're upsõi pese za'ra, ãma 're saihuri mono õ ré. Duré te za hâsizé hã te te 're upsõi pese za'ra, duré piza'a hã duré piza'a ĩsi'uwazi 'manharĩ hã, tihi'rata norĩ nhimiroti zarina. ");
INSERT INTO xavNT_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Taha wa, parisezu norĩ hã Zezusihi u si'rã'õtõ wamhã, ma tô Zezusi hã siwi 'mahâ, rowahutu'wa norĩ me: — E marĩ wa, te bété asiré 're ĩnomro mono norĩ hã simisõi ãna 're saihuri, wahi'rata norĩ nhimiroti na te te rosa'rata za'ra ãna. ");
INSERT INTO xavNT_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","7","Taha wa, ma tô Zezusi hã asa ãma sada'âbâ za'ra, ãne: — Tô senai õ di, 're aihâimana za'ra wa'aba mono zé hã. Duréihã Iza'iza hã ma tô ĩ'uwaibaba ai'ãma rob'ui'éré sirõmo za'ra wa'wa, aihâimanazéb za'ra wa'aba na hã. 'Re ĩhâimana u'âsi mono mreme na ma tô ãne na ai'ãma rob'ui'éré sirõmo za'ra wa'wa: “Õ norĩ hã tô sena newa, te timreme na si taré ĩ̱'ãma 're wata za'ra. Tane nherẽ, te tipẽ'ẽ 're aimawi zô si te te 're rosa'rata u'âsi za'ra, ĩ̱'upana. Danhimiroti zarina si, te ta norĩ hã te te dama 're rowahutu za'ra, ĩ̱nhimiroti zarina newa. Taha wa, senai õ di, ta norĩ hã ĩ̱'ãma 're ĩwata za'ra mono zé hã.” — Ãne ma tô tãma waihu'u, 'Re ĩhâimana u'âsi mono hã. Taha wa, ma tô ãne da'ãma rob'ui'éré, Iza'iza hã. Duréi pese, te te da'ãma rob'ui'éré nherẽ, tô sena na te aiwasu'u za'ra wa'wa. ");
INSERT INTO xavNT_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","A norĩ wa'wa hã, 'Re ĩhâimana u'âsi mono nhimiroti na 're asapa'a za'ra wa'aba mono õ di. Ti'ai ãma danhimiroti na si, te 're aihâimana za'ra wa'aba mo. — Ãne ma tô parisezu norĩ ma 're ĩhâimana za'ra mono zé hã tãma waihu'u za'ra, Zezusi hã. ");
INSERT INTO xavNT_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Ãne ma tô duré tãma waihu'u za'ra: — A norĩ wa'wa hã aihâimana nhipese sina te 're ĩrẽme za'ra wa'aba mo 'Re ĩhâimana u'âsi mono nhimiroti hã, 'râwi asimirosa'rata na si 're aihâimana za'ra wa'aba mono da. ");
INSERT INTO xavNT_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Duréihã Mozési hã ma tô dama roti, ãne: “Aimama hã te za 're ĩwazéb za'ra wa'aba mo, ana zama.” Ãne ĩsimiroti amo hã duré: “Ni'wam norĩ hã timama ãma nherẽ, duré tina ãma nherẽ, te te ãma 're wasété za'ra mono wamhã, te za da te 're simro.” Ãne ĩsimiroti hã duréihã. ");
INSERT INTO xavNT_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","12","Tane nherẽ, te ãhãna hã asimiroti za'ra wa'aba zéb zarina si 're dahâimana za'ra, damama norĩ hã da te 're pawaptob za'ra mono ãna, dana norĩ zama. Ãté ni'wai ma, te za ĩsibro hã 're hâimana, timama hã duré tina hã te te ĩpawaptob zahuré zéb da hã. Wẽ nherẽ, te za ãté ãne timama ma waihu'u, tina ma zama: “Marĩ na te aipawapto wa'aba da hã, te ĩ̱sima wẽ nherẽ hã, tane nherẽ, wa tô 'Re ĩhâimana u'âsi mono ma, ãma ropisutu, te tãma sõmri da, ãma ĩ̱wata zéb da hã.” Ãté ãne te za timama ma waihu'u, tina ma zama. Ãne wamhã, te za tãma 're ĩwaihu'u wasété za'ra wa'aba mo, ãne: “Re ĩhâimana u'âsi mono ma, ma tô ĩropisutu pa. Taha wa, te za tãma ãma ĩ'uwaimra, aimama norĩ, ãma pawaptob zahuré õ nherẽ, ana me.” Ãne ma tô dama 're ĩroti wasété za'ra wa'aba mo. ");
INSERT INTO xavNT_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Ãne wa, 'Re ĩhâimana u'âsi mono zadawa wasu'u hã aima wapu za'ra wa'aba di, ĩsimiroti upana aihi'rata norĩ nhimiroti na si, dama 're roti u'âsi za'ra wa'aba mono wa. Tane duré aimawi na dama 're ĩroti za'ra wa'aba mono zé hã, ahâ uptabi di. — Ãne parisezu norĩ 're ĩhâimana za'ra mono zém na, ma tô Zezusi hã tãma rowaihu'u za'ra. ");
INSERT INTO xavNT_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Tawamhã Zezusi te duré sima dazô hâ, te te dama roti da, ãne: — Ma'ãpé, ĩ̱nhimirowasu'u hã wapari pese za'ra wa'aba za, marĩ hã waihu'u za'ra wa'aba da ãma. ");
INSERT INTO xavNT_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","16","Uburé marĩ na 're dasaihuri mono wamhã, taha na 're dasiwasété za'ra mono õ di za. Dapẽ'ẽ hawim na danhimirosa'rata wasété zarina, da te dasima 're nharĩ wasété za'ra mono wapsi, te za 're dasiwasété za'ra, 'râwi. — Ãne ma tô dama rowasu'u, da te dasina waihu'u za'ra da. ");
INSERT INTO xavNT_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Tawamhã te te dama rowasu'u pari, te oto ai'aba'ré, 'ri tẽme, tisiré 're ĩnomro mono norĩ me. Tawamhã 'ri tẽme sihutu wapsi, te oto siwi sadanha, ĩsiré 're ĩnomro mono norĩ hã, marĩ na te te dama ĩrowasu'uzém na hã te te tãma waihu'u za'ra da, 'râwi 're ĩdasiwasété za'ra mono zém na hã. ");
INSERT INTO xavNT_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Tawamhã ma tô tãma waihu'u za'ra: — E niha a norĩ wa'aba ma zama, aima waihu'u za'ra wa'aba õ di bété. Dasa hã da te 're huri mono wamhã, taha na 're dasiwasété za'ra mono õ di za 'râwi. ");
INSERT INTO xavNT_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","E marĩ wa. Dapẽ'ẽ na, da te 're ĩrosa'rata za'ra mono zéb u, 're sisisi mono õ wa za, dasa hã. Danomo u si, te za 're sisisi, dasa hã. Taha pari, te za 're wairébé apâ, rob u. — Ãne ma tô tãma waihu'u za'ra, te te ãma waihu'u za'ra da, dasai mono bâ ĩwẽ na 're ĩdasaihuri mono zéb da hã. ");
INSERT INTO xavNT_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","22","Ãne ma duré tãma waihu'u za'ra: — Dapẽ'ẽ hawi, da te 're ĩsani za'ra mono na si, te za 'râwi 're dasiwasété za'ra. Dapẽ'ẽ 're, danhimirosa'rata wasété hawim na si, te dawasédé hã uburé da te 're 'manharĩ za'ra, marĩ na danhipsaihuri hã, duré dasipãrĩ hã, duré dasina danhipsaihuri hã, duré danhibrom na da'ruiwapari hã, duré dawasété 'manharĩ hã, duré dazadawa nhipe hã, duré marĩ na danhiminho'ru hã, duré danhisi wasédé hã, duré marĩ na 'râwi dasina dawada hã, duré 'râwi dawasété na 're ĩdasisãmri za'ra mono õ zé hã. ");
INSERT INTO xavNT_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Dasi'uihâ na te za 'râwi da te dasima 're rosa'rata wasété za'ra. Taha pari, te za uburé marĩ hã ĩwasétére hã da te 're 'manharĩ za'ra. Ãne wapsi, te za 'râwi 're dasiwasété za'ra. — Ãne ma tô Zezusi hã tãma waihu'u za'ra, tisiré 're ĩnomro mono norĩ ma. ");
INSERT INTO xavNT_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Tawamhã Zezusi norĩ hã te oto ai'aba'ré, darob amoi u. Tiru na 'ri nho'õmo nhisi 'rata, daro hã. Tawamhã 'ri para u ma tô asisi. Tame ĩsãmrazém na da te dasiwi ĩwaihu'uzéb da hã, te te sima wẽ õ di, Zezusi hã. Tane nherẽ, a'â da te sa'rese ãna, sãmra waihu'u õ di. ");
INSERT INTO xavNT_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","26","Tawamhã pi'õ hã ma tô duré ĩsãmrazém na danhimirowasu'u hã wapa. Zezusihi wasu'u te te wapari wi, ma awa'awi ĩtẽme mo. Ĩ'ra hã ba'õtõre hã, wa'uburé hã te te 're wamnarĩ mono wa, te ĩtẽme mo, te te tãma wasu'u da. Tawamhã ĩtẽme wisi wi, ma tô Zezusihi papara aime, hi'rãtitõ. Pi'õ hã deredu na ĩpodo, zudezu'õ, Siru Penisiza nhihudu. Tane nherẽ, ma tô Zezusihi wi rowaptẽ, wa'uburé ma, te te rob'ru da, ĩ'ra ma watobro da, ĩ'ra hã rowẽ na si, tãma 're hâimana mono da oto. ");
INSERT INTO xavNT_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Tawamhã Zezusi te asa tãma tinha pi'õi ma, ãne: — Ĩmorĩ'rata na te za da'ra ma, ĩsa hã da te tãma 're sõmri za'ra, tisa hã te te 're 'mahâpãrĩ za'ra mono da, a'â. Da'ra sa hã ĩmorĩ'rata na wapsã ma, da te 're sãmra mono wamhã, ĩ'uwaibaba õ di. ");
INSERT INTO xavNT_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Tawamhã, pi'õ hã ma asa ãma sada'â: — Tô ĩ'uwaibaba, ma tane hã ĩ̱ma ĩwaihu. Tane nherẽ, te za da'ra saipru hã, da'ra norĩ wi 're rere'e mono wamhã, wapsã hã te te 're huri, wedezai 'rowi. ");
INSERT INTO xavNT_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Tawamhã Zezusi ma duré asa tãma waihu'u: — Tane tô. Asa ãma ĩ̱ma uwaimrami wẽ wa, te za oto apâ aimo, 'ri tẽme. Ai'ra ma, ma tô wa'uburé hã watobro. ");
INSERT INTO xavNT_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Tawamhã pi'õ hã te apâ mo, tinhorõwa u. Wisi wamhã, rowẽ na ma tô ti'ra hã sabu, waptâ nomro ré. Ĩwana ma tô tãma watobro, wa'uburé hã. Taha wa, tãma rowẽ di oto. ");
INSERT INTO xavNT_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Tawamhã Zezusi norĩ hã Tiru na 'ri nho'õmo nhisi 'rata, hâimana za'ra pari, ma tô ai'aba'ré. Sido na daza'ru nhisi wa'wai baba, ma tô ro'rahâri za'ra. Duré Decapori na danhipti'a nho'õmo nhisi wa'wai baba, ma tô ro'rahâri za'ra, 10 na daza'ru wa'wai baba. Tawamhã Darireza ãma â zaihâ u, ma tô aihutu, ĩsõ'ui u. ");
INSERT INTO xavNT_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Tawamhã ĩsõ'u zaihâ u sihutu wamhã, aibâ ĩpo'reptõ hã ma tô ĩtẽme dasiwi saprõni ni, ĩmreme waihu'u'õ hã. Tawamhã Zezusihi ma, te oto 'ru za'ra, siwi ĩsaprõni'wa norĩ hã tinhib'rada te te ãma hiri da, te te pese da. ");
INSERT INTO xavNT_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Tawamhã Zezusi hã ma tô aibâ hã danhiti sima saprõ. Tawamhã tinhipto hã ma tô ĩpo're 're tiza. Taha pari, ma duré tizadaipro na tinhipto hã sada di'i, te te ãma soto u'ré da. ");
INSERT INTO xavNT_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Taha pari, te hâiwa u rob'madâ. Hâiwa u te te rob'madâ'â sina, aibâ ãma pẽ'ẽzé wa, tipẽ'ẽ 're te ãi'ã. Tawamhã tisimremezém na te tãma tinha: — Epata. — Ãne ãma ĩsaprĩzé hã, wamreme na: “Aipo're 'repu'u.” ");
INSERT INTO xavNT_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Tawamhã ma tô po're 'repuru oto, awa'awi. Duré ma tô tinhoto wairo. Tawamhã mreme wẽ di oto, aibâ ĩmreme waihu'u'õ hã. ");
INSERT INTO xavNT_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Tawamhã Zezusi hã te sina dazadawa uwati pese, ĩwasu'u na da te dasima ãma ropé tõ da. Tane nherẽ, ĩ'madâ'â'wa norĩ hã te nasi dama rowasu'u za'ra, aibâ te te ĩpesezém na. ");
INSERT INTO xavNT_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Tawamhã ĩsimirowasu'u, da te wapari za'ra wamhã, ma tô ãma tatob'uzu za'ra ni. Ãne te Zezusi hã dasima wasu'u za'ra ni: — Tô sena, te uburé marĩ ĩwẽ hã te te dama 're ab'manharĩ. Ĩpo'reptõ hã ma tô pese, ĩmreme waihu'u'õ hã. — Ãne te ãma tawata za'ra ni. ");
INSERT INTO xavNT_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Tawamhã syry na ãma ronomro parip si, ma tô duré apâ ĩtẽme tasi'rã'õtõ ni, Zezusihi u hã. Tawamhã marĩ na dasaihuri õ wa, dasazé hã oto hâimana õ wa, te Zezusi hã sima sô tihârâ za'ra, tisiré 're ĩnomro mono norĩ zô. ");
INSERT INTO xavNT_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","Ãne te tãma siwasu'u za'ra: — Ãhãna ĩ̱'rata dasi'ubumroi ré, ma tô dasa hã dawi ai'utõ, bâdâ si'ubdatõ da'ãma si'utõrĩ wa. Taha wa, da'ãma ĩ̱pẽ'ẽzé di, wa hã. ");
INSERT INTO xavNT_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Mram nherẽ, te dama rob'rui wamhã, te za dasi'marõpãrĩ za'ra bâdâdi na, danhib'uware wa, romhâ hawi we ĩdasihutu norĩ hã. ");
INSERT INTO xavNT_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Tawamhã asa te tãma nharĩ za'ra, ãne: — E niha wa za dasa hã dama 'mai'uipra za'ra ni, wa te dama sõmri za'ra mono da. Ãmemhã a'ubuni wi, wa ai'ubumro ni. ");
INSERT INTO xavNT_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Tawamhã Zezusi te asa sadanharĩ za'ra, ãne: — E niha te ĩ'u'ẽtẽ wapu hã aima tihâimana za'ra wa'wa. — 7 na te wama tihâimana za'ra. — Ãne ma tô tãma waihu'u za'ra asa. ");
INSERT INTO xavNT_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Taha wa, ma tô Zezusi hã dama rob'ru, ti'ai wa, dasi'ubumroi mono da. Taha pari, ma tô duré 7 na ĩ'u'ẽtẽ wapu hã waibu, 'Re ĩhâimana u'âsi mono ãma wata da, sõpru wa. Ãma wata pari, ma tô te te wẽ'ẽ, ĩ'u'ẽtẽ wapu hã. Tawamhã tisiré 're ĩnomro mono norĩ ma, ma tô te te sõmri, te te dama sõmri za'ra mono da. ");
INSERT INTO xavNT_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Pe'a hã ĩsyryre hã te duré tãma ti'maihâiba, ĩsebre siro hã. Tawamhã 'Re ĩhâimana u'âsi mono ãma te duré tiwata, pe'a ĩsyryre na zama, sõpru wa. Taha pari, te duré tãma 'ru za'ra, te te dama sõmri za'ra mono da. ");
INSERT INTO xavNT_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Tawamhã aihĩni te oto dasa hã huri ni. Dasa hã ma da te 'mahâpãrĩ, aihĩni. Taha pari, dasa ĩsi'azazâri hã ĩsiré 're ĩnomro mono norĩ hã ma tô apâ te te sé. Si'õno hã 7 na ĩhâiba wa, ma tô ãma 'masisi za'ra. ");
INSERT INTO xavNT_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Ĩdasaihuri za'ra norĩ hâiba za'ratazé hã, 4 miu u, ma watobro, ãté. Taha pari, te oto Zezusi hã dama rob'ru, apâ darob u, da te ropéi mono da. ");
INSERT INTO xavNT_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Tawamhã te te dama rob'rui pari, ma uba're wa asisi, Zezusi norĩ hã, zara u te te saprĩ za'ra da, Damanuta na ti'a nhisi u si'aba'ré da. ");
INSERT INTO xavNT_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Tawamhã parisezu norĩ hã ma Zezusihi u aihutu, ĩsimirowasu'u na te te saze za'ra õ wa, ĩsadawa wa'rãmi te te nasi tãma nharĩ za'ra da. Tawamhã Zezusihi wi, te oto rowaptẽrẽ za'ra, tiwaihu'u pese na marĩ dama ĩ'manharĩ waihu'u'õ hã te te tãma 'manharĩ za'ra da. E marĩ da. Tô sena 'Re ĩhâimana u'âsi mono zadawa para, dama ĩwaihu'u'õ hã te te 're ĩ'ab'manharĩ mono zô, te te siwi pibu za'ra da. Taré te te siwi wẽ'õ da, te ãne tiwi rowaptẽrẽ za'ra. ");
INSERT INTO xavNT_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Tawamhã Zezusi hã ãma pẽ'ẽzé za'ra wa, ma sa'ẽtẽ pẽ'ẽwaze. Tawamhã te sima tinha, ãne: — E niha ma tô nimosi dapoto tém norĩ hã siwi ĩ̱wada'u, marĩ dama ĩ'manharĩ waihu'u'õ hã ĩsõ'a te tãma 'manharĩ za'ra da. Mare di, ãne hã. Te tãma 'manharĩ za'ra õ di za. — Ãne te sima tinha, Zezusi hã. ");
INSERT INTO xavNT_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Taha pari, te tiwi timorĩ za'ra. Uba're wa, ma oto ãzé, zara u te te saprĩ da apâ. ");
INSERT INTO xavNT_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Tawamhã zara u, ma tô oto aihutu, Zezusi norĩ hã. Ĩ'u'ẽtẽ wapu hã siré te te 'ma'âri za'ra da nherẽ, ma tô ãma po're ha'âri za'ra, ĩsiré 're ĩnomro mono norĩ hã. Misire te nomro, uba're 'remhã. ");
INSERT INTO xavNT_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Tawamhã Zezusi ma ãne tãma waihu'u za'ra: — Ma'ãpé, 're asi'madâ'â pese za'ra wa'aba mono, ĩ'u'ẽtẽ wapuzém nhiti 're anomro aba mono da, parisezu norĩ nhimi'manharĩzém nhiti, apito Erodihi me. ");
INSERT INTO xavNT_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Tawamhã te sima nharĩ za'ra, ãne: — Ĩ'u'ẽtẽ wapu hã ãté wama hâimana za'ra õ wa, ma ãne wama waihu'u za'ra. ");
INSERT INTO xavNT_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Tawamhã Zezusi ma sina wapari za'ra. Taha wa, te sadanharĩ za'ra, ãne: — E niha te ĩ'u'ẽtẽ wapu hã aima ĩhâimana za'ra wa'aba õ na, sô asimrami za'ra wa'wa. E asiwi ĩ̱zadaihu'u za'ra wa'aba õ di bété, ĩ'u'ẽtẽ wapuzém na te aima ĩwaihu'u za'ra wa'aba zém na hã. E niha waihu'u su'u za'ra wa'aba õ di bété. ");
INSERT INTO xavNT_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","19","E niha atõmo na marĩ 're 'madâ'â za'ra wa'aba mono nherẽ, aima waihu'u za'ra wa'aba õ di. E niha aipo're na marĩ 're wapari za'ra wa'aba mono nherẽ, aima waihu'u za'ra wa'aba õ di. 5 na ĩ'u'ẽtẽ wapu hâiba hã te dama ĩwẽ'ẽi ahâ mono zém na hã, duré 5 miu na dahâiba nherẽ, aihĩni ĩdasaihurizém na hã, e ma ãma aipo're si'âri za'ra wa'wa. E niha si'õtõ hâiba hã ĩré danho'rada hã ĩsi'azazâri hã, apâ ĩwa ĩséme aba mono hã. — Ãne te Zezusi hã sadanharĩ za'ra. Tawamhã asa ma Zezusihi ma waihu'u za'ra: — Si'õno hã 12 na ĩhâiba hã danho'rata ré hã. ");
INSERT INTO xavNT_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Tawamhã Zezusi hã ĩsadanharĩ na, ma duré tãma ãma sahu za'ra: — Duré, 7 na ĩ'u'ẽtẽ wapu hã hâimana nherẽ, te dama ĩwẽ'ẽi ahâ mono zém na hã, duré 4 miu na dahâiba nherẽ, da te 'mahâpãrĩ mono wamhã, e niha si'õtõ hâiba hã danho'rata ré hã. — Ãne te sadanharĩ za'ra. — Si'õno hã, 7 na ĩhâiba hã danho'rata ré hã. — Ãne ma asa tãma waihu'u za'ra. ");
INSERT INTO xavNT_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Tawamhã Zezusi te duré tãma nharĩ za'ra: — E niha bété zahadu ĩ̱waihu'u za'ra wa'aba õ di, ĩ̱waihu'u pese na hã. — Ãne ma tô Zezusi hã tãma nharĩ za'ra. ");
INSERT INTO xavNT_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Taha pari, te oto ai'aba'ré Zezusi norĩ hã, Besada na 'ri wa'õtõ nhisi u. Tawamhã datẽme sihutu wamhã, aibâ ĩtob'a hã ma tô ĩtẽme dasiwi saprõni ni, Zezusihi u. Tinhib'rata na te te upi da, te te to pese da, te tãma 'ru za'ra, siwi ĩsaprõni'wa norĩ hã. ");
INSERT INTO xavNT_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Tawamhã Zezusi hã ma ĩtob'a hã pa'â, danhiti te te sima saprõni da. Tawamhã tizadaipro na ma sada sisiptõmo di'i, te te ãma tob'u'ré da, aibâ hã. Taha pari, ma duré tinhib'rada hã ãma tihi. Taha parimhã, te sadanha, ãne: — E zahadu marĩ hã 'madâ'â õ di. E ma tô marĩ hã ĩ'madâ. ");
INSERT INTO xavNT_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Tawamhã aibâ te te rob'madâ'â wamhã, Zezusihi ma, te asa tinha, ãne: — Zahadu te rob'madâ'â pese õ di. Aibâ norĩ hã te ai'aba'ré, wede ne ĩhâiba za'ra hã. — Ãne ma asa tãma waihu'u, te te rob'madâ'â pese waihu'u õ wa. ");
INSERT INTO xavNT_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Taha wa, tinhib'rada hã ma tô duré ãma tino, ĩtomhâ ãma, Zezusi hã. Tawamhã ma tô tito pese oto, aibâ hã. Te rob'madâ'â wẽ di oto. ");
INSERT INTO xavNT_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Tawamhã Zezusi hã te aibâ ma rob'ru, tinhorõwa u morĩ waré da oto, apâ morĩ tõ da, 'ri wa'õtõ u hã. ");
INSERT INTO xavNT_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Taha pari, Zezusi norĩ hã te oto 're nomro, 'ri wa'õtõ mono bâ. Apito Piripihi te, Sézareza na 'ri nho'õmo nhisi niwĩ, 'ri wa'õno hã. Tawamhã bâdâdi na si'aba'ré sina, te tãma nharĩ za'ra, Zezusi hã: — E niha ma tô da te dasima 're ĩ̱wasu'u za'ra. E 'wa hã, wa hã. ");
INSERT INTO xavNT_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Tawamhã asa ma tãma waihu'u za'ra: — Aiwasu'u hã, ahâ di. A hã, u, Zuwã Batita, apâ aihâiwa'udu. A hã, u, Eriasi apâ we ĩ'aimorĩ. A hã, u, 'Re ĩhâimana u'âsi mono zadawa wasu'u 'rata 'wa hâiba amo, duréi pese atâ'â nherẽ, apâ aihâiwa'udu. ");
INSERT INTO xavNT_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Tawamhã Zezusi te duré sina sadanharĩ za'ra: — A norĩ wa'wa hã bété, e niha ma tô asima 're ĩ̱wasu'u za'ra wa'aba mo. Tawamhã Pedruhu si, ma asa tãma waihu'u na wa'rã: — A hã Cristu, 'Re ĩhâimana u'âsi mono te te aipisudu, Danho'reptui'wa da. ");
INSERT INTO xavNT_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Tawamhã Zezusi te sina sadawa uwati za'ra, Danho'reptui'wa na, te te a'â dama wasu'u za'ra tõ da. ");
INSERT INTO xavNT_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","32","Tawamhã ãne te Zezusi hã tãma siwasu'u za'ra, tisiré 're ĩnomro mono norĩ ma: — Ti'ai ãma dasiré ĩ̱podo hã, 'Re ĩhâimana u'âsi mono te te ĩ̱ma ĩpisutuzéb zarina, wa za robzépata za'ẽtẽ. Wama roti'wa norĩ hã te za siwi ĩ̱wẽ'õ za'ra, ĩhi norĩ hã. Sasedoti ĩpire norĩ zama, duré dama rowahutu'wa norĩ zama, te za siwi ĩ̱wẽ'õ za'ra. Tawapsi te za dasiwi ĩ̱wĩrĩ ni. Tawamhã bâdâ maparane ĩ̱'ãma si'utõrĩ õ ré, wa za hâiwa'udu apâ. — Ãne sõ'awi ma tô Zezusi hã tãma siwasu'u za'ra, tãma ĩrob'rãsutuzém na hã te te ãma waihu'u sirõmo za'ra da. Tawamhã Pedru hã ãne tãma ĩsiwasu'u za'ra zé hã te te tiwi sawi da, te sima saprõ Zezusi hã, tisiré norĩ nhiti. ");
INSERT INTO xavNT_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Tawamhã te te sina wapari wamhã, tisiré 're ĩnomro mono norĩ u, ma aipi'ra. Tawamhã Pedruhu ma, te ãne tinha: — Satanasi, mo oto aimorĩ, ĩ̱nhiti. 'Re ĩhâimana u'âsi mono nhimirosa'rata zarina rosa'rata õ di, a hã. Danhimirosa'rata zarina si, te ĩ̱'ãma ĩrosa'ra, a hã. ");
INSERT INTO xavNT_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Taha pari, Zezusi te duré sima dazô hâ, uburé ĩtẽme dasi'rã'õtõ mono da. Tisiré 're ĩnomro mono norĩ zô zama, te duré tihârâ za'ra sima. Tawamhã ãne ma si'ãma dama rowaihu'u: — Ni'wam norĩ hã ĩ̱siré 're nomro u'âsi mono da, te te sima 're ĩ̱wẽ za'ra mono wamhã, tihâimanazém na te te 're rosa'rata za'ra mono õ di za. Tiza'ozéb ré, ĩ̱zarina 're ĩnomro mono ne, da te dasiwi uprosi da nherẽ, te za ĩ̱siré 're nomro. ");
INSERT INTO xavNT_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Ni'wam norĩ hã si'uihâ na tihâimanazép si te te sima 're sawi za'ra mono wamhã, rowẽ ĩsi'utõrĩ'õ hã te te sina 're uwaimrami za'ra mono õ di za. Ni'wam norĩ hã ĩ̱zarina 're nomro mono da, duré ĩ̱zadawa wasu'u'wa 're nomro mono wa, 're sihâiba zawi za'ra mono õ wapsi, te za te te sina 're uwaimrami za'ra, rowẽ hã. ");
INSERT INTO xavNT_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","37","Ãté ni'wa hã te za tinhibro hã te te sima 're a'ubumroi pese, sibrob ahâ uptabi da. Tawamhã te za oto dârâ. Ti'ab ré sibrob ahâ nherẽ, e tãma 're rowẽ mono di za, rowẽ ĩsi'utõrĩ'õ hã te te sina 're uwaimrami mono õ wamhã. Mare di. Tãma 're rowẽ mono õ di za. Ti'ai ãma simarĩ ahâ uptabi nherẽ, tãma waihu'u õ di za, marĩ na ĩsiwa'âbâzéb da hã, rowẽ ãma 're ĩhâimana mono zéb da hã. — Ãne Zezusi ma tô dama waihu'u siro, da te waihu'u za'ra da. ");
INSERT INTO xavNT_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Ma tô duré dama rowaihu'u ãne: — Ãhãna da'ahâ na 'Re ĩhâimana u'âsi mono nhimiroti hã ma tô rẽme za'ra ni. Dawasété na si te oto 're danomro, ã nimosi dapoto té mono hã. Tawamhã ni'wam norĩ hã ĩ̱zazei'wa na, duré ĩ̱mreme wapari pese 'wa na, ãté dama 're siwasu'u za'ra mono õ di za, 're siséb za'ra mono õ'umnhasite. Ãté te za dawi 're si'udâ za'ra, ĩ̱zazei'õ'wa ne. Ti'ai ãma dasiré ĩ̱podo hã nimahã na si, wa za wei mo apâ. Ĩ̱mama te hã, rowa'a za'ẽtẽ ré, wa za wei mo, hâiwa ãma tãma ĩromhuri'wa norĩ siré. Tawamhã apâ we ĩ̱morĩ wapsi, ĩ̱'udâ'wa norĩ hã ĩ̱zazei'wa na te waihu'u za'ra õ di za. — Ãne ma tô dama rowasu'u, Zezusi hã. ");
INSERT INTO xavNT_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Tawamhã Zezusi hã ma duré dama waihu'u, ãne: — Tô sena wa aima rowasu'u za'ra wa'wa. Aihĩni õ nherẽ, ai'matâ'â aba õ ré, te za tiwaihu'u pese na 'Re ĩhâimana u'âsi mono, da'ãma 're ĩsib'a'uwẽ mono zé hã ãma ĩ'madâ'â za'ra wa'wa. — Ãne ma Zezusi hã dama waihu'u siro, da te dasina waihu'u za'ra da. ");
INSERT INTO xavNT_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Tawamhã bâdâ 6 na ãma si'utõrĩ pari, ma tô Zezusi hã Pedru norĩ si te te simro, Ti'adu norĩ me, Zuwãhã zama. Ẽtẽ 'rãihâ u ma tô ai'aba'ré. Tame ma tô Zezusi hã tihâiba na saprĩ, Pedru norĩ nho'a. ");
INSERT INTO xavNT_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Ĩ'uza hã ma tô tihâirã uptabi. Rowa'a za'ẽtẽ ne, ma ai'ubuzi, rã uptabi na. Da'uza hã da te 're hâ upsõi pese za'ra mono nherẽ, hâirã prã ti, Zezusihi uza ma hã. ");
INSERT INTO xavNT_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Tawamhã dahi'rata norĩ hã ma tô 'madâ'â za'ra, Eriasi norĩ hã Mozésihi me. Zezusihi me, te sima rowasu'u za'ra. ");
INSERT INTO xavNT_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","6","Tawamhã Pedru te Zezusihi ma tinha, ãne: — Rowahutu'wa, ãme wama rowẽ za'ra di. Si'ubdatõ, wa za aima 'ri za'ra wa'aba ni aihâiba bâ wa'aba, ate da hã, duré Mozésihi te da hã, duré Eriasihi te da hã. — Ãne ma Pedru hã tãma waihu'u, a'â te te rosa'rata ãna. Te te 'madâ'â za'ra wa, ma tãma tipahi za'ra, Pedru norĩ hã. ");
INSERT INTO xavNT_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Tawamhã hâiwa nhirõtõ'a za'ẽne hã ma ubu za'ra, Zezusi norĩ hã. Taha wa, hâiwa nhirõtõ'a hawi, ma we tãma nharĩ za'ra, 'Re ĩhâimana u'âsi mono hã, Pedru norĩ ma: — Ã hã ĩ̱'ra, te 're ĩsawi pese mono. Ma'ãpé ĩsimiroti hã 're wapari pese za'ra wa'aba mono za. ");
INSERT INTO xavNT_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Taha wamhã, taré te titõmo na sô rowaimrami za'ra. Zezusihi si te ãma siwi 'madâ, siwaprosi ĩsam na. ");
INSERT INTO xavNT_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Tawamhã ẽtẽ 'rãihâ hawi, ma oto si'ra za'ra, Zezusi norĩ hã. Si'aba'ré sina, te Zezusi hã tãma nharĩ za'ra, ãne: — Ẽtẽ 'rãihâ ãma ĩ'madâ'â za'ra wa'aba zém na hã, dama rowasu'u za'ra wa'aba õ di za a'â. Wa hã ti'ai ãma dasiré ĩ̱podo hã ab're hawi ĩ̱hâiwa'utu parip si, te za dama 're ĩrowasu'u za'ra wa'aba mo. ");
INSERT INTO xavNT_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Tawamhã ĩmreme ma tô wapari za'ra, Pedru norĩ hã. Taha wa, te 'râwi sima rowasu'u za'ra, ãne: — E niha ĩsiwasu'uzé hã ab're hawi, za te te ĩhâiwa'utu na. Wa norĩ hã wama waihu'u za'ra õ di. — Ãne te 'râwi sima rowasu'u za'ra. ");
INSERT INTO xavNT_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Tawamhã te oto siwi sadanha, Zezusi hã: — E marĩ wa, te rowahutu'wa norĩ hã te te dama 're rowasu'u za'ra bété, Cristu, Danho'reptui'wa da, 'Re ĩhâimana u'âsi mono te te ĩpisutu wana, Eriasi za we ĩmorĩ na hã. ");
INSERT INTO xavNT_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","13","Tawamhã Zezusi ma tô asa tãma waihu'u za'ra: — Duréihã 'Re ĩhâimana u'âsi mono zadawa wasu'u'wa hã ma tô ĩ'uwaibaba ãma rob'ui'éré ĩbaihâ na, Eriasi za we apâ ĩmorĩzém na te te ropese da. Tane nherẽ, wa za aima waihu'u za'ra wa'wa. Eriasi hã ma tô wei morĩ pa. Da te dasima ĩwẽ za'ra zéb zarina, ma tô tãma rob'manharĩ wasété za'ra ni, ĩwana da te duré ãma ĩrob'ui'érézéb zarina. 'Re ĩhâimana u'âsi mono zadawa wasu'u'wa norĩ hã ma tô ĩ̱'ãma rob'ui'éré sirõmo za'ra, ti'ai ãma dasiré ĩ̱poto ãma hã, sa'ẽtẽ na za te ĩrobzépatazém na hã, duré za da te dasiwi ĩ̱wẽ'õzém na hã. E marĩ wa, ma tô ãne ĩ̱'ãma rob'ui'éré sirõmo za'ra. — Ãne te Zezusi hã sina sadanharĩ za'ra. ");
INSERT INTO xavNT_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Tawamhã Zezusi norĩ hã te oto apâ ai'aba'ré, tisiré norĩ u. Ĩwana za'ra ma tô da'ahâ na tasi'rã'õtõ ni. Tame 'Re ĩhâimana u'âsi mono nhimiroti ui'éré na rowahutu'wa norĩ hã te nasi ĩsadawa wa'rãmi tãma nharĩ za'ra, Zezusihi siré 're ĩnomro mono norĩ ma, ĩsimirowasu'u na te te saze za'ra õ wa. ");
INSERT INTO xavNT_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Zezusi hã da te 'madâ'â za'ra wamhã, uburé ma tô ãma tatob'uzu za'ra ni. Taha wa, ma tô ĩtẽme dasisa're, da te sawi za'ra da. ");
INSERT INTO xavNT_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Tawamhã Zezusi te dama tinha: — E marĩ na, te asima ĩrowasu'u za'ra wa'wa. ");
INSERT INTO xavNT_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Tawamhã aibâ hã dawa'wa hawi te 'mahâ: — Rowahutu'wa, ĩ̱'ra wa we atẽme saprõ, ĩ̱ma pawaptob da. Wa'uburé te te 're upi mono wa, mreme õ u'âsi te 're sãmra. ");
INSERT INTO xavNT_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Wa'uburé hã te te 're wabzuri, ti'ai u. Tawamhã ĩsadaipro hã te tiwi 're pusi. Te duré 're 'wahãihãsi. Te duré 're sitete. Te duré 're sib'uwa. Wa tô aré waptẽrẽ za'ra, asiré 're ĩnomro mono norĩ hã wa'uburé te te siwi me da, tãma. Tane nherẽ, tãma waihu'u za'ra õ di, ĩ̱'ra ma, te te siwi ĩme da hã. — Ãne te aibâ hã rowasu'u, Zezusihi ma. ");
INSERT INTO xavNT_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Tawamhã aibâ mreme te te wapari wamhã, ma tô tisiré 're ĩnomro mono norĩ ma tinha: — E niha bété ai'rata 're ĩ̱nhamra u'âsi aba mono nherẽ, asina 're ĩ̱'umnhasi za'ra wa'aba mono õ di bété, te 're ĩ'aipawaptob za'ra wa'aba mono zéb da hã. E ĩ̱pẽ'ẽzé u'âsi, wa za ai'rata 're ĩ̱morĩ 'wa, 're ĩ̱'umnhasi za'ra wa'aba mono õ wa. Ma'ãpé, ai'repudu hã we ĩ̱tẽme saprõni aba. ");
INSERT INTO xavNT_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Tawamhã ma tô ĩtẽme siwi saprõ, ai'repudu hã. Ĩtẽme te te siwi ãwisi wi, te wa'uburé hã Zezusi hã 'madâ. Taha wa, te sisa'u ai'repudu hã wasutu. Sa'ẽtẽ te 're sipizari, ti'ai wa. Ma duré sadaiproi waze. ");
INSERT INTO xavNT_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Tawamhã Zezusi hã te ĩmama hã ãma sadanha: — E niha ma tô ãma tiwahu, ai'ra hã ĩré 're hâimana mono ré hã. — Ĩ̱'ra hã sapore ré, ma tô 're siwamnarĩ. ");
INSERT INTO xavNT_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Unhama u te te 're wabzuri wa'uburé hã, unhama na te te wĩrĩ da. Âi ba zama te te 're wabzuri, â na te te wĩrĩ da. Tô sena aiwaihu'u pese wamhã, wapawapto na. Ma'ãpé, wa'ãma aipẽ'ẽzé na. ");
INSERT INTO xavNT_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Tawamhã ãne te Zezusi hã tãma tinha: — E niha te ãne ĩ̱ma ĩnha, tô sena ĩ̱waihu'u pese wamhã, te aipawapto wa'aba da hã, ai'ra ãma. Ĩ̱waihu'u pese na, da te 're ĩ̱'umnhasi za'ra mono wamhã, uburé dama waihu'u pese di za, marĩ na da te 're ĩdapawaptob za'ra mono zéb da hã. — Ãne ma tô Zezusi hã tãma waihu'u. ");
INSERT INTO xavNT_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Tawamhã awa'awi te aibâ hã Zezusihi ma tinha: — Asimipawaptobzém na, wa tô ai'umnhasi. Ma'ãpé, 're ĩ̱pawaptob u'âsi mono, asimipawaptobzém na te 're asazei pese mono da oto. Taha da, wa aima ĩ̱siwasu'u. ");
INSERT INTO xavNT_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Tawamhã Zezusi hã ĩtẽme ĩdasi'rã'õtõ norĩ hã da'ahâ na te te da'ab'madâ'â wamhã, ma tô wa'uburé ma rob'ru, ãne: — Wa'uburé, ai'repudu 're upi u'âsi mono wa, te mreme'õ u'âsi 're hâimana. Te duré po'reptõ u'âsi 're sãmra. Aiwatobro, ai'reputu hawi. Niwa apâ asébré tõ, ai'reputu u. ");
INSERT INTO xavNT_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Tawamhã wa'uburé, ma tizadari. Sisa'u te duré wasutu, ai'repudu hã. Tawamhã ĩhawi ma tô watobro. Ai'repudu hã rési ãna te oto nomro, dâ'â newa. Taha wa, te dasima rowasu'u za'ra ni, ai'repudu hã ĩdâ'â na. ");
INSERT INTO xavNT_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Tane nherẽ, ma tô Zezusi hã ai'repudu hã pa'â. Ma tô hâiwi wahutu, para na sab da. ");
INSERT INTO xavNT_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Taha pari, ma asisi 'ri para u, Zezusi norĩ hã. Tame hâiba pisutu ma tô si'ãma sadanharĩ za'ra, ĩsiré 're ĩnomro mono norĩ hã: — E niha bâ bété wa norĩ hã, wa'uburé ma, wa te rob'ru za'ra nherẽ, wa te wasiwi ĩmei waihu'u õ, tãma. ");
INSERT INTO xavNT_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Tawamhã asa ma Zezusi hã ãne tãma waihu'u za'ra: — 'Re ĩhâimana u'âsi mono ma, te za a'â 're damreme zusi ãma. Taha parip si, dama waihu'u pese di za, wa'uburé hã dama 're ĩwairébé mono zéb da hã. — Ãne ma tãma waihu'u za'ra. ");
INSERT INTO xavNT_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","31","Tawamhã Zezusi norĩ hã ta hawi te oto ai'aba'ré. Darireza na danhipti'a nho'õmo nhisi wa'wai baba, ma ro'rahâri za'ra. Zezusi hã ma tô sima wẽ, ĩhâimanazém na a'â da te sa'rese za'ra tõ da, tisiré 're ĩnomro mono norĩ ma, a'â hâiba pisutu tãma siwasu'u za'ra da. Tawamhã ma tô tãma siwasu'u za'ra, ãne: — Wa hã dasiré ĩ̱podo hã te za dasima ĩ̱hâiba nhomri ni. Te za duré dasiwi ĩ̱wĩrĩ ni. Da te dasiwi ĩ̱wĩrĩ wamhã, bâdâ maparane ĩ̱'ãma si'utõrĩ õ ré, wa za apâ hâiwa'udu ab're hawi, ĩ̱dâ'â uptabi nherẽ. — Ãne te tãma siwasu'u za'ra, tisiré 're ĩnomro mono norĩ ma. ");
INSERT INTO xavNT_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Tawamhã te te siwi sadaihu'u za'ra õ di, tãma ĩsiwasu'u za'ra zém na hã. Tane nherẽ, tãma pahi za'ra wa, te te siwi ãma sadanharĩ õ di oto. Ari'iwi te oto asimro. ");
INSERT INTO xavNT_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Tawamhã Capana'u na 'ri nhisi u, ma tô oto aihutu, Zezusi norĩ hã. Tame 'ri para u sisisi wamhã, te Zezusi hã sadanharĩ za'ra, tisiré 're ĩnomro mono norĩ hã, ãne: — Bâdâdi na we wasi'aba'réi ré hã e marĩ na, te we asima ĩrowasu'u za'ra wa'aba mo. ");
INSERT INTO xavNT_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Tazahã te ari'iwi tihâimana za'ra oto, bâdâdi na si'aba'ré sina, sipibu za'ra wa aré, 'râwi sima ĩ'maipire zô. ");
INSERT INTO xavNT_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Zezusi hã ma tô nhamra oto. Tisiré 're ĩnomro mono norĩ zô, te tihârâ za'ra, sitẽme. Ãne te tãma nharĩ za'ra: — Ni'wam norĩ hã dama pire da, 'râwi te te si'ãma 're rosa'rata za'ra mono wamhã, dama ĩwapu ne, te za dama 're si'ai'uté za'ra. ");
INSERT INTO xavNT_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","37","Taha pari, ma ai'uté hã pa'â, tisiré 're ĩnomro mono norĩ wa'wa, te te sãrĩ da, tipa. Tawamhã tipa te te sãrĩ sina, ma ãne tãma waihu'u za'ra: — Ni'wam norĩ hã te te 're ĩ̱zawi pese za'ra mono wa, ai'uté zô 're tob'uzu za'ra mono wamhã, ta norĩ u'âbâ te duré ĩ̱zô 're tob'uzu za'ra. Tawamhã, e ĩ̱zô si te 're tob'uzu za'ra. Mare di. We ĩ̱zatõrĩ'wa zô zama te sô 're tob'uzu za'ra. — Ãne ma tô tãma waihu'u za'ra, te te waihu'u za'ra da. ");
INSERT INTO xavNT_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Tawamhã Zuwã hã te Zezusihi ma siwasu'u: — Rowahutu'wa, aibâ wa tô 'madâ'â za'ra ni, asisi na wa'uburé ma, te te 're ĩrob'rui mono hã, dama 're wairébé mono da. Tawamhã ma tô dama 're wairébé. Õ hã wasiré 're morĩ õ di. Taha wa, wa tô tiwi sawi za'ra ni, asisi na wa'uburé ma, te te 're arob'ru tõ mono da, wasiré 're morĩ õ wa. — Ãne te Zezusihi ma siwasu'u, Zuwã hã. ");
INSERT INTO xavNT_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","40","Tawamhã Zezusi hã ma tô asa tãma waihu'u za'ra, Zuwã norĩ ma: — Tiwi sawi za'ra wa'aba õ di za, te te 're ĩda'apawapto mono zé hã. Ãté ni'wam norĩ hã ĩ̱waihu'u pese zarina, te za ĩwẽ hã te te dama 're 'manharĩ za'ra, dama ĩ'manharĩ waihu'u'õ hã. E taha pari, te za ta norĩ hã awa'awi na ĩ̱nhisi wasété za'ra. Mare di. Te te 're ĩ̱nhisi wasété za'ra mono õ di za. E marĩ wa. Ni'wam norĩ hã wazada 're hâimana za'ra mono õ wamhã, ta norĩ hã wahâiba niwĩ te za 're hâimana za'ra. Taha wa, aibâ hã wahâiba niwĩ 're hâimana mono nherẽ, tiwi sawi za'ra wa'aba õ di za, te te 're ĩda'apawapto mono zé hã. — Ãne ma tô tãma waihu'u za'ra. ");
INSERT INTO xavNT_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Tawamhã ma tô duré tãma nharĩ za'ra: — Ma'ãpé, ĩ̱wapari pese za'ra wa'aba asina. A norĩ wa'wa hã ĩ̱zazei'wa 're aihâimana za'ra wa'aba mono wa, â hã ni'wam norĩ hã te te aima 're sõmri za'ra wa'aba mono wamhã, 'Re ĩhâimana u'âsi mono, za te te tãma 're ĩ'awa'âbâ mono zé hã tiwi 're simani za'ra mono õ di za. Te za te te sina 're uwaimrami za'ra. — Ãne ma tô tãma siwaihu'u za'ra Zezusi hã, tisiré 're ĩnomro mono norĩ ma. ");
INSERT INTO xavNT_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Tawamhã Zezusi hã roti na ma duré tãma ãma uzusi za'ra: — Ãté ã norĩ hã, ai'uté dama ĩwapu ne, te za 're nomro, ĩ̱zazei'wa norĩ hã. Tawamhã ãté ni'wa simiroti zarina, te za ĩ̱'mairẽ. Tawamhã tãma ĩroti wasété'wai ma hã, tãma rowẽ õ uptabi di za, 'Re ĩhâimana u'âsi mono, za te te azâri wa. Ĩbutu na ẽtẽ tõmo wawẽ, da te ãma wasisi pari, âi ba da te mei 'wa'âhã, uihâ na dâ'â da, tãma rowẽ õ di aré. Tane nherẽ, ĩsimiroti wasétézéb zarina, ĩ̱zazei'wa te te ĩ̱rẽme wamhã, tãma rowẽ õ uptabi di za, roti wasété'wai ma hã. ");
INSERT INTO xavNT_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Taha wa, wa za ãne aima waihu'u za'ra wa'wa. Asib'rata na aiwasédé hã 're waibui wa'aba mono wamhã, asib'rada asiwi 're ĩsihâri za'ra wa'aba mono newa, te za oto 're anomro wẽ wa'aba mo. Asib'rada misire ré si rowẽ uptabi u, 're asisisi aba mono wamhã, aima 're rowẽ za'ra wa'aba mono di za, hâiwa ãma hã. Asib'rata zahuré ré, ropipa u 're asisisi aba mono wamhã, unhama u'âsi u, aima 're ropipa uptabi za'ra wa'aba mono di za. ");
INSERT INTO xavNT_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","45","Duré nimomo 're aiwairébé aba mono wa, aiwasédé hã 're waibui wa'aba mono wamhã, aipara asiwi 're ĩsihâri za'ra wa'aba mono newa, te za oto 're anomro waré wa'aba mo. Aipara misire ré si, rowẽ uptabi u 're asisisi aba mono wamhã, aima 're rowẽ za'ra wa'aba mono di za, hâiwa ãma hã. Aipara zahuré ré ropipa u, 're asisisi aba mono wamhã, aima 're ropipa uptabi za'ra wa'aba mono di za. ");
INSERT INTO xavNT_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","47","Duré marĩ hã atõmo na 're 'madâ'â za'ra wa'aba mono wa, aiwasédé hã 're waibui wa'aba mono wamhã, tawamhã ato asiwi 're ĩsani za'ra wa'aba mono newa, te za oto 're anomro waré wa'aba mo. Atõmo misire ré si, 'Re ĩhâimana u'âsi mono u, 're asisisi aba mono wamhã, Asib'apito wa'aba u, aima 're rowẽ za'ra wa'aba mono di za. Atõmo zahuré ré ropipa u, 'Re ĩhâimana u'âsi mono te te 're asãmra aba mono wamhã, aima 're ropipa uptabi za'ra wa'aba mono di za. ");
INSERT INTO xavNT_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Ropipa ãma ubu hã te te 're ĩdahâiba uprosi za'ra mono hã, si'utõrĩ õ di. Duré uzâ hã si'utõrĩ waihu'u õ di. Õne u'â te 're hâimana u'âsi. — Ãne Zezusi ma tô tãma waihu'u za'ra, tisiré 're ĩnomro mono norĩ ma. ");
INSERT INTO xavNT_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Tawamhã ãne ma duré tãma waihu'u za'ra: — Marĩ na da te 're ĩrobzépata za'ra mono zém na, te za te te 're da'apibu, 'Re ĩhâimana u'âsi mono hã, tô sena ĩ̱zazei'wa 're danomro mono zô. ");
INSERT INTO xavNT_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Wa za duré aima rowasu'u za'ra wa'wa, ãne. Sa na hã dasa hã ãma se ti, dasai warĩrĩzéb da hã. Tane nherẽ, oto 're se si'utõrĩ mono wamhã, niha da te 'manharĩ waihu'u õ di, apâ se da, dasa da te ãma 're ĩwarĩrĩ za'ra mono da hã. Sa na, wa za duré aima rowasu'u za'ra wa'wa, ãne. Ni'wam norĩ hâimanazéb zarina, te za dasi'u syry na sa na 're dasaihuri, dasisawi te. Tane asisawi te, te za rowẽ na asiré 're aihâimana za'ra wa'aba mo. — Ãne ma tô tãma waihu'u za'ra Zezusi hã, tisiré 're ĩnomro mono norĩ ma. ");
INSERT INTO xavNT_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Tawamhã Zezusi hã Capana'u hawi te oto mo, Zudeza na danhipti'a nho'õmo nhisi u, morĩ da. Tawamhã Zodã pa zara u, ma tô saprĩ. Te te saprĩ wamhã, da'ahâ uptabi na ma tô duré ĩtẽme dasito. Taha wa, te duré dama rowahutu, te te dama 're ĩrowahutu u'âsi mono zém na, Zezusi hã. ");
INSERT INTO xavNT_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Tawamhã ni'wam norĩ hã parisezu norĩ hã, timreme na te te tãma ãma upa za'ra wa, te te siwi mreme wẽ'õ da, ma ãne siwi sadawa pibu: — Aibâ norĩ hã timro me sima 're siwanhizari za'ra mono wamhã, e wahi'rata norĩ nhimiroti zarina, te za timro hã time, aibâ hã. — Ãne te siwi sadanha. ");
INSERT INTO xavNT_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Tawamhã asa ma Zezusi hã sada'âbâ za'ra: — E niha ma tô Mozési hã bété dama waihu'u aré, damro me dasiwi 're ĩdasiwanhizari za'ra mono zém na hã. ");
INSERT INTO xavNT_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Tawamhã asa ma duré ãma sada'âbâ za'ra: — Mozési hã ãne ma tô dama roti: Aibâ norĩ hã timro me, siwi 're siwanhizari za'ra mono õ ré, te za rob'ui'éré hã timro ma te te 're sõmri za'ra pi'õi ma, da te ãma 're waihu'u za'ra mono da, te te ĩmezém na hã. Taha parip si, te za oto pi'õi ma, te te 're rob'ru za'ra. ");
INSERT INTO xavNT_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Tawamhã Zezusi te duré asa tãma nharĩ za'ra: — Ta hã Mozési hã aipẽ'ẽ tete za'ra wa'aba wa, ma tô ãne na te te aima 're roti za'ra wa'wa. ");
INSERT INTO xavNT_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Ropoto na'rata hawimhã, ãnei õ di. Ropoto na'rata hawimhã, ma tô 'Re ĩhâimana u'âsi mono hã aibâ hã poto, a'uwẽ na. Pi'õ zama ma tô duré poto. ");
INSERT INTO xavNT_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Taha wa, aibâ hã 're mro za'ra mono wamhã, te za timama norĩ hã te te 're rẽme za'ra, timro me si, siré 're simasisi zahuré mono da oto. ");
INSERT INTO xavNT_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Sina hâiba sitob zahuré wamhã, maparane ĩhâiba nherẽ, misi ĩhâiba ne, te za siré 're hâimana u'âsi zahuré oto. ");
INSERT INTO xavNT_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Taha wa, 'Re ĩhâimana u'âsi mono, dasi'ãma te te 're da'ahâiba to mono nherẽ, ni'wa hã da'ãma 're siwanhizari mono õ di za. Mare di. — Ãne ma tô Zezusi hã parisezu norĩ ma waihu'u za'ra. ");
INSERT INTO xavNT_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Taha pari, 'ri tẽme sihutu wamhã, ĩsiré 're ĩnomro mono norĩ hã ma tô ãma siwi sadanha. ");
INSERT INTO xavNT_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Tawamhã Zezusi asa ma tô tãma waihu'u za'ra: — Ni'wa hã aibâ hã timro te te mei wamhã, pi'õ aimawi na mro wamhã, te za tiwasédé hã 'manha, aibâ hã. ");
INSERT INTO xavNT_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Duré ni'wa hã pi'õ hã, timro te te mei wamhã, aibâ aimawi na mro wamhã, te za duré tiwasédé hã 'manha, pi'õ hã. — Ãne ma tô tãma waihu'u za'ra. ");
INSERT INTO xavNT_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Taha pari, ma tô da'ra hã ãwisi za'ra ni Zezusihi u, 'Re ĩhâimana u'âsi mono ma, ãma mreme za'ra da, te te 're apawaptob u'âsi mono da, ĩwẽ na. Tane nherẽ, ĩsiré 're ĩnomro mono norĩ hã ma tô dawẽ'õ za'ra, da'ra hã da te ĩtẽme 'wasari tõ da, Zezusihi u. ");
INSERT INTO xavNT_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Ãne te te ĩdawẽ'õ za'ra zém na hã, te te wapari ze za'ra õ di, Zezusi hã. Taha wa, te ãne tãma nharĩ za'ra: — Tô'ã. Dawi rosawi za'ra wa'aba tõ. A'â we ĩ̱tẽme da te simroi mono, ai'uté norĩ hã. Ã norĩ hã ai'uté norĩ hã õne haré simizazei pese na 're ĩhâimana za'ra mono ne, tane ni'wam norĩ hã 're hâimana za'ra mono wapsi, te za 'Re ĩhâimana u'âsi mono hã ãma 're sib'a'uwẽ za'ra. ");
INSERT INTO xavNT_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Tô sena, wa aima waihu'u za'ra wa'wa. Ni'wam norĩ hã ai'uté dama ĩwapu ne, 're hâimana za'ra mono õ wamhã, 'Re ĩhâimana u'âsi mono, da'ãma 're ĩsib'a'uwẽ mono zéb u, 're sisisi mono õ di za. — Ãne ma tô tãma waihu'u za'ra, Zezusi hã. ");
INSERT INTO xavNT_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Tawamhã awa'awi ma tô nasi ai'uté hã dawi azaza tipa. Duré tinhib'rata na te te nasi upi za'ra sina, 'Re ĩhâimana u'âsi mono wi, ma tô ãma arowaptẽ, ĩwẽ hã te te tãma 're anhomri mono da. ");
INSERT INTO xavNT_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Zezusi norĩ hã sina pahâ za'ra õ ré, te aibâ hã ĩsarina tiwara za'ra. Ãma wisi za'ra wamhã, Zezusihi papara ma aime hi'rãtitõ. Tawamhã ãne te sina sadanha: — Rowahutu'wa, aiwẽ di a hã. E marĩ ĩwẽ hã wa za 'manha, 're ĩdanomro u'âsi mono zé hã te ĩ̱sina ĩ'uwaimrami da hã. ");
INSERT INTO xavNT_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Tawamhã asa te Zezusi hã tãma tinha: — E niha te ĩ̱'ãma aiwa, ĩ̱wẽ na. 'Re ĩhâimana u'âsi mono si ĩwẽ uptabi hã, õhõ si. Ni'wa hã ĩsine hã mare di. ");
INSERT INTO xavNT_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","A hã aima waihu'u pese di, 'Re ĩhâimana u'âsi mono nhimiroti hã. Ãne dama ĩsimiroti hã: “'Re danhimroi wa'aba mono õ di za. Duré aimro na asiwi 're asipsaihuri za'ra wa'aba mono õ di za. Duré danhibrom na dawi 're asipsaihuri za'ra wa'aba mono õ di za. Duré dahâiba wasu'u na dama 're asadawa nhipese za'ra wa'aba mono õ di za. Duré dama 're asadawa nhipese za'ra wa'aba mono õ di za. Duré aimama hã te za 're ĩwazé pese mo, ana zama.” Ãne 'Re ĩhâimana u'âsi mono nhimiroti hã. ");
INSERT INTO xavNT_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Tawamhã asa te Zezusihi ma siwasu'u: — Rowahutu'wa, ĩ̱prédu wi, wa tô te 're 'madâ'â pese, ĩsimiroti hã. ");
INSERT INTO xavNT_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Tawamhã Zezusi hã te aibâ 'madâ, sawi sina. Ãne te tãma tinha: — Zahadu te misi aiwi sô rowaptâ, tãma ãma ĩ'uwaimrami'õ hã. Mo oto aimorĩ apâ, asibro hã uburé dama wede mono da, ĩwa'âbâ zô, ĩsibrob'õ norĩ ma, sõmri mono da. Ãne wamhã, duré asibro pese di za, hâiwa ãma. Taha parip si, te za we apâ aimo ĩ̱tẽme, ĩ̱siré 're aimorĩ da oto. — Ãne ma tô aibâ ma waihu'u, Zezusi hã. ");
INSERT INTO xavNT_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Aibâ hã ãne hã te te wapari wamhã, ma tô tiwi tirobzei'õ. E marĩ wa. Sibrob ahâ uptabi wa. Taha wa, te oto mo apâ, robzei ãna. ");
INSERT INTO xavNT_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Tawamhã aibâ za'u, te Zezusi hã 'madâ'â za'ra, tisiré 're ĩnomro mono norĩ hã. Taha wa, ma tô ãne tãma waihu'u za'ra: — Ĩsibro pese norĩ hã 'Re ĩhâimana u'âsi mono, da'ãma 're ĩsib'a'uwẽ mono zéb u 're ĩsisisi mono da hã, pire di. Tãma pire uptabi za'ra di za. ");
INSERT INTO xavNT_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Tawamhã te ãma rosa'rata za'ra, te te tãma ĩwaihu'u za'ra zém na hã. Ãne ma duré tãma waihu'u za'ra: — Ĩ̱siwadi norĩ, e niha te za 'Re ĩhâimana u'âsi mono ãma, 're sib'apito za'ra, ĩtẽme 're ĩsisisi mono zéb da hã. Tãma pire uptabi za'ra di. ");
INSERT INTO xavNT_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","E niha te za awaru ba'õmore hã ĩsi'uwazi para'õtõ zapu'u 're ãzé. Sébré waihu'u õ di. Tane, ĩsibro pese norĩ hã si'uihâ na 're sisisi waihu'u mono õ di za, 'Re ĩhâimana u'âsi mono, da'ãma 're ĩsib'a'uwẽ mono zéb u hã. — Ãne ma tô tãma waihu'u za'ra, Zezusi hã. ");
INSERT INTO xavNT_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Ãne ĩmreme hã te te wapari za'ra wamhã, ma tô ãma titob'uzu za'ra. Tawamhã te ãma sisadanharĩ za'ra, ãne: — Ĩsibro pese norĩ ma, waihu'u za'ra õ wamhã, e 'wam norĩ hã te za bété danho'reptuzé hã te te sina 're uwaimrami za'ra, dadâ'â ãna 're ĩdanomro u'âsi mono zé hã. Ãté ni'wai õ di. ");
INSERT INTO xavNT_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Tawamhã Zezusi hã te 'madâ'â za'ra. Ãne ma tô tãma waihu'u za'ra: — Dasi'uihâ na danho'reptuzé hã, da te dasina 're uwaimrami za'ra mono õ di za. Dama waihu'u õ di. 'Re ĩhâimana u'âsi mono si siminho'reptu waihu'u pese di. Taha ma si, uburé marĩ hã 'manharĩ waihu'u pese uptabi di. — Ãne ma tô tãma waihu'u za'ra. ");
INSERT INTO xavNT_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Tawamhã Pedru hã te asa tãma siwasu'u: — Wa norĩ hã uburé wa tô wanhibro hã wasipara rẽme za'ra ni, asiré 're wanomro mono da oto. ");
INSERT INTO xavNT_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Tawamhã Zezusi hã ãne ma duré tãma waihu'u za'ra: — Tane tô. Ĩ̱wapari pese za'ra wa'aba. Ãté ni'wa hã te te 're ĩ̱zawi pese mono zéb zarina, te za tinhorõwa hã a'â tirẽ, te te dama 're ĩ̱zadawa wasu'u mono da. Ãté tisisãnawã norĩ, duré tihidiba norĩ te za a'â rẽme za'ra. Ãté tina, timama, duré ti'ra norĩ hã te za a'â rẽme za'ra. Ãté tinhipti'a zama, te za a'â tirẽ. ");
INSERT INTO xavNT_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","Ãne wamhã, ti'ai ãma 're morĩ ré, te za marĩ ĩwẽ uptabi hã ahâ na tãma 're hâimana za'ra, 'Re ĩhâimana u'âsi mono nhib'ratamhã, ĩsõrõwa za'ra hã, ĩsisãnawã norĩ hã, ĩhidiba norĩ hã, ĩ'ra norĩ hã, duré ĩsipti'a hã. Marĩ ĩwẽ hã tãma 're ĩhâimana za'ra mono zu, te za duré rowasédé hã tãma 're hâimana za'ra, taré da te 're ĩ'ruiwapari za'ra mono zéb zarina. Niwapsi te za duré tãma pisutu, dâ'â ãna 're morĩ u'âsi da, rowẽ uptabi ãma, 'Re ĩhâimana u'âsi mono hã. ");
INSERT INTO xavNT_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Ni'wam norĩ hã ahâ uptabi na pire na ti'ab ré dama 're hâimana za'ra mono nherẽ, te za 'Re ĩhâimana u'âsi mono hã te te tãma 're apisutu, wapu na 're hâimana za'ra mono da oto, za da'ãma 're ĩsib'a'uwẽ mono zéb ãma hã. Duré ni'wam norĩ hã ahâ uptabi na ti'ab ré wapu na dama 're hâimana za'ra mono nherẽ, te za te te tãma 're apisutu, pire na oto 're hâimana za'ra mono da. — Ãne ma tô romhâ ré tãma waihu'u sirõmo za'ra, tisiré 're ĩnomro mono norĩ ma. ");
INSERT INTO xavNT_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Tawamhã Zezusi norĩ hã ma oto sai'uri za'ra, bâdâdi na sõ'a na, Zeruzarẽ u. Zezusi hã tisiré 're ĩnomro mono norĩ nhowa, ma tô mo. Sina hâtâ'â ãna, morĩ wa, te ãma rosa'rata za'ra. Taha wa, ma tô ĩsiré 're ĩnomro mono norĩ me ĩsi'aba'ré norĩ hã sina tipahi za'ra. Tawamhã danhiti te sima satõrĩ za'ra, tisiré 're ĩnomro mono norĩ hã, te te tãma rowasu'u sirõmo za'ra da, za tãma ĩromhâimanazém na. ");
INSERT INTO xavNT_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","34","Tawamhã ãne te tãma rowasu'u za'ra: — Ĩ̱wapari pese za'ra wa'aba. Ãhãna Zeruzarẽ u, wa ai'aba'ré ni. Tame wa hã ti'ai ãma dasiré ĩ̱podo hã te za dasima ĩ̱hâiba nhomri ni, sasedoti ĩpire norĩ ma, 'Re ĩhâimana u'âsi mono nhimiroti 'rata na rob'ui'éré na dama rowahutu'wa norĩ ma zama. Ta norĩ hã ĩ̱wasédé te te ĩ̱'ãma ĩsa'ra za'ra zéb zarina, te za dama ĩ̱'ru za'ra, da te ĩ̱wĩrĩ da, dasiwi. Tawamhã zudezu'õ norĩ ma, te za siwi ĩ̱hâiba nho. Ta norĩ hã te za ĩ̱'ãma tiwa'ẽ za'ra, zudezu'õ norĩ hã. Tizadaipro na te za duré nasi siwi ĩ̱'upto. Te za duré te te siwi 're ĩ̱pré'é. Tawamhã te za oto siwi ĩ̱wĩ. Tane nherẽ, bâdâ maparane ĩ̱'ãma si'utõrĩ õ ré, wa za apâ hâiwa'udu. — Ãne ma tô tãma siwasu'u sirõmo za'ra, Zezusi hã. ");
INSERT INTO xavNT_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Taha pari, Ti'adu hã Zuwãhã me, Zebedehe 'ra zahuré hã, ma tô Zezusihi u sina rotété zahuré, te te tãma nharĩ zahuré da, ãne: — Rowahutu'wa, wa za aiwi rowaptẽrẽ ni. Ma'ãpé, ãma wama uwaimrami, wa te wasima ĩwẽ hã. ");
INSERT INTO xavNT_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Tawamhã Zezusi ma ãma sada'âbâ zahuré: — E niha ma tô asima ĩ̱wẽ wa'wa, te aima ãma ĩ'uwaimrami aba da hã, asima ĩwẽ wa'aba zé hã. — Ãne te sadanharĩ zahuré. ");
INSERT INTO xavNT_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Tawamhã asa te duré tãma nharĩ zahuré, Zezusihi ma: — Niwamhã danhib'apito simasisizém na te za 're asãmra mo, dama aipire uptabi na 're aihâimana mono da. Ãhã wa, ma'ãpé wapisutu, asimire niwĩ 're wa'manhamra mono da, duré asimi'e niwĩb zama, asine dama wapire na 're wahâimana mono da. ");
INSERT INTO xavNT_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Tawamhã te duré asa tãma nharĩ zahuré: — Rosa'rata ãna te ãne asina ĩ̱zadanharĩ 'wa. Wa hã wa za robzépata za'ẽtẽ, dawi ĩ̱sisawi ãna. E tawamhã sada asiptete aba di za, za te ĩrobzépata za'ẽtẽ ne, ĩrobzépata aba da hã. ");
INSERT INTO xavNT_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Tawamhã asa te duré Zezusihi ma siwaihu'u zahuré: — Ĩhe. Sada wanhiptete di za, asine wa te ĩrobzépata da hã. Tawamhã Zezusi ma duré asa tãma waihu'u zahuré: — Te za tô ĩ̱sine ĩrobzépata za'ẽtẽ 'wa. ");
INSERT INTO xavNT_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Tane nherẽ, ĩ̱si'uihâ na te aipisutu waihu'u aba õ di, dama aipire wa'aba na 're aihâimana aba mono zéb da hã ĩ̱nhimire niwĩ, duré ĩ̱nhimi'e niwĩ. 'Re ĩhâimana u'âsi mono si te za te te dama 're apisutu, te te sima 're ĩda'awẽ mono zéb uwaibaba, dama pire na ĩ̱'rata 're dahâimana u'âsi za'ra mono da. — Ãne ma tô tãma waihu'u zahuré, Ti'adu norĩ ma. ");
INSERT INTO xavNT_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Tawamhã Zezusihi siré 're ĩnomro mono norĩ hã 10 na ĩhâiba za'ra hã, Ti'adu norĩ mreme te te wapari za'ra wamhã, ma tô sada tinhiti'ru za'ra. ");
INSERT INTO xavNT_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Taha wa, Zezusi te sô tihârâ za'ra, 'râwi ĩtẽme si'rã'õtõ da. Tawamhã ãne ma tô tãma waihu'u za'ra: — Ti'ai ãma danhib'apito na da te 're ĩwamri za'ra mono norĩ hã te pire uptabi na dama 're hâimana za'ra. Sa'ẽtẽ te duré te te 're dawada'uri za'ra, ĩsimiroti hã da te 're 'madâ'â za'ra mono da. ");
INSERT INTO xavNT_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Tane asima 're aihâimana za'ra wa'aba mono õ di za, a norĩ wa'wa hã. Asiré norĩ ma, ai'maipire wa'aba da, asima 're 'mairob'ruiwapari aba mono wamhã, te za asiré hã 're ĩ'maipawaptob u'âsi aba mo, marĩ zô 're a'manhimnhasi aba mono ãna. ");
INSERT INTO xavNT_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Duré 'râwi asima aipire uptabi na, 're ai'maihâimana aba mono da, asima 'maiwẽ uptabi aba wamhã, pawa'âbâ ãna romhuri'wa ne, te za asima 're ĩ'mairomhuri wẽ wa'aba mo. ");
INSERT INTO xavNT_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Tane duré, wa hã dasiré ĩ̱podo hã da te ĩ̱ma 're romhuri za'ra mono da, we ĩ̱morĩ õ di, ti'ai u. Te 're da'apawapto mono da si, wa wei datẽme mo, ĩ̱sihâiba zawi ãna dazada ĩ̱dâ'â da, da'upana te da'awa'âbâ da. — Ãne ma tô tãma siwaihu'u za'ra Zezusi hã, te te ãma waihu'u za'ra da. ");
INSERT INTO xavNT_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Tawamhã Zezusi norĩ hã ma tô oto aihutu, Zerico na 'ri nho'õmo nhisi u. Zerico hawi duré si'aba'réi wamhã, da'ahâ uptabi na te ĩsiré ai'aba'ré ni. Si'aba'réi ré, ma tô aibâ hã sõpẽtẽ za'ra ĩtob'a hã, bâdâdi zababa ĩsãmra hã. Ĩtob'a hã Batimezu na ĩsisi hã, Timezuhu 'ra. Rob'uiprazém na te nasi da'awa, da te tãma a za'ra da. ");
INSERT INTO xavNT_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Tawamhã ma tô Zezusihi wasu'u hã wapa, Nazaré nhihudu hã ĩsababa te te ĩro'razâri na hã. Taha wa, te te sina 'mahârâ, sa'ẽtẽ, ĩtob'a hã: — Zezusi, Dawihi nhihudu, ma'ãpé ĩ̱'ãma aipẽ'ẽzé na. — Ãne te nasi sina 'mahâ. ");
INSERT INTO xavNT_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Tawamhã da'ahâ na te tãma nharĩ za'ra ni, ari'iwi sãmra da. Tane nherẽ, te nasi sa'ẽtẽ sina 'mahâ: — Dawihi nhihudu, ĩ̱'ãma aipẽ'ẽzé na. ");
INSERT INTO xavNT_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Tawamhã ma tô mazazâ, Zezusi hã. Ãne te dama ti'ru: — Sô aihârâ za'ra wa'aba, we ĩ̱tẽme morĩ da. Taha wa, te dasiwi 'mahârâ ni, ĩtob'a hã: — Aiwahutu. Zezusi hã te asô hâ, ĩtẽme aimorĩ da. Aima rowẽ di za oto. ");
INSERT INTO xavNT_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Tawamhã Batimezu hã tisi'ubuzé ma tô time, si'aba'ré na wahutu da, Zezusihi u morĩ da. ");
INSERT INTO xavNT_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Ĩtẽme wisi wamhã, Zezusi te ãne sadanha: — E marĩ te asima ĩwẽ, te ãma aima ĩ'uwaimrami da hã. — Rowahutu'wa, ĩ̱to pese da, wa ĩ̱sima wẽ, apâ te 're rob'madâ'â mono da. — Ãne te asa tãma si'ru. ");
INSERT INTO xavNT_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Tawamhã Zezusi te ãne tãma tinha: — Te za oto aimo. Asina ĩ̱'umnhasi wa, ma tô ato pe. Tawamhã awa'awi ma tô rob'madâ'â wẽ, aibâ hã. Tawamhã Zezusihi zarina te oto mo, bâdâdi na. ");
INSERT INTO xavNT_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","2","Tawamhã Zezusi norĩ hã Zeruzarẽ u si'aba'réi wamhã, ma tô a'â aihutu, Oriwera na ẽtẽ 'rãihâ nhisi u. Ẽtẽ 'rãihâ 'rata, te 'ri wa'õno hã 're hâimana zahuré, Betazé hã duré Betãnha. Tawamhã Zezusi hã sisõwa ma tô tisiré 're ĩnomro mono norĩ hã 'mazatõrĩ zahuré maparane. Ãne te tãma rob'ru zahuré: — Õwa te za oto ane wa'wa, 'ri wa'õtõ u, asõ're uwaibaba wa'aba. Ãma aimasisi aba wi, awa'awi te za awaru po'repore hã ĩsõpẽtẽ 'wa, ĩprédupté hã, zahadu ni'wa hã nimomo ãma ĩmorĩ'õ hã. Da te ãma wasisi haré, te za. Tawamhã da te ãma ĩwasisizé hã te za ĩwasihui wa'wa, we ĩ̱ma saprõni aba da. ");
INSERT INTO xavNT_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Ni'wa hã ãne te te asadanharĩ aba wamhã: “E marĩ da, ma ĩwasihui wa'wa, ãma ĩwasisizé hã,” tawamhã asa te za ãne tãma ĩwaihu'u 'wa: “Wanhib'apito hã marĩ õ wa, ãma morĩ da, wa tãma wasihu ni. Te za we aima sõmri su'u apâ.” Ãne te za tãma ĩ̱zadawa wasu'u wa'wa, ĩtede'wai ma. ");
INSERT INTO xavNT_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Tawamhã te oto sô tineb zahuré, awaru po'repore zô. Simasisi wi, awaru po'repore ma tô sõpẽtẽ zahuré. 'Ridawa 'rata, te wasisi haré za. ");
INSERT INTO xavNT_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Te te wasihu zahuré wamhã, ma tô ni'wam norĩ hã ãma 'mahârâ za'ra, ĩ'rata ĩsimasam norĩ hã: — E marĩ te a norĩ wa'wa hã ĩ'manharĩ 'wa. E marĩ da, te asapa'abâ ĩwasihui wa'wa, awaru po'repore hã. ");
INSERT INTO xavNT_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Tawamhã asa ma tô dazada'âbâ zahuré, Zezusi hã te te tãma ĩwaihu'u zahuré zém na. Taha wa, ma tô tãma 'ru zahuré ni, awaru po'repore hã te te saprõni zahuré da, Zezusihi ma. ");
INSERT INTO xavNT_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Tawamhã te te ãwisi zahuré wamhã, awa'awi ma tô tãma ba'ubu zahuré, tisi'ubuzém na. Taha pari, ma tô ãma darõno, Zezusi hã. ");
INSERT INTO xavNT_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Ãma sarõtõ wamhã, da'ahâ na ma tô bâdâdi hã tãma waptâ za'ra ni, dasi'ubuzém na. Ni'wam norĩ hã rom na ĩsupo suiwawẽ te te ĩ'manhizâri za'ra na, ma duré tãma waptâ za'ra. ");
INSERT INTO xavNT_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Tawamhã Zezusihi nhowa ĩsi'aba'ré norĩ hã ĩsarina ĩsi'aba'ré norĩ zama, mreme 'rãihâ na te sima 'mahârâ za'ra: — 'Re ĩhâimana u'âsi mono ãma 're wawata za'ra wa'aba mono. Ĩsadawa para we ĩmorĩ ma, ĩwẽ si te te tãma 're pisutu u'âsi mono neza. Apito Dawihi ma, te te ĩropisutuzéb zarina, te we oto mo, watẽmeb za'ra, Wanhib'apito 're hâimana mono da. ");
INSERT INTO xavNT_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","'Re ĩhâimana u'âsi mono hã tô sena sõprub di. — Ãne te ãma tawata za'ra ni. ");
INSERT INTO xavNT_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Tawamhã Zeruzarẽ u oto wisi wamhã, 'Re ĩhâimana u'âsi mono ãma 're ĩdawata za'ra mono zéb u, ma ãzé Zezusi hã, te te robzabu da. Tame tiwi hâiwahâ wa, te oto mo, Betãnha na 'ri wa'õtõ nhisi u, tisiré norĩ me, aibâ 12 na ĩhâiba za'ra norĩ me. ");
INSERT INTO xavNT_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Tawamhã bâtâ amo na Betãnha hawi te apâ ai'aba'ré, Zeruzarẽ u. Morĩ ré, ma tô mra hã tĩwĩ, Zezusi hã. ");
INSERT INTO xavNT_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Tawamhã si'aba'réi ré, romhâ ré, ma wede hã tisã, pidera wede hã. Sui hâza'õtõ wa, te sô mo, 'rãi õ'umnhasite. Tawamhã 'râwi ĩsu si ma tô 'madâ. Ĩ'rã hã robaba di. Zahadu a'amo hã watobro õ di, ĩ'rã uptabi zéb da hã. ");
INSERT INTO xavNT_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Tawamhã Zezusi te wede ma tinha: — Ai'rã hã da te 're huri mono õ di za oto. Ai'rã'õ u'âsi, te za oto 're asa mo. Tawamhã ma tô mreme wapari za'ra, wede ma, te te ĩnharĩzém na hã, ĩsiré 're ĩnomro mono norĩ hã. ");
INSERT INTO xavNT_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Tawamhã Zezusi norĩ hã ma tô Zeruzarẽ u apâ aihutu. 'Re ĩhâimana u'âsi mono ãma 're ĩdawata za'ra mono zéb u, ma tô asisi, 'ri 'wawi wa'ra 're. Tame te da te 're rowede za'ra. Ni'wam norĩ hã te duré te te dawi 're rob'uipra za'ra. Tawamhã dama rowede'wa norĩ hã ma tô Zezusi hã te te sate, rob u. Te te dawi 're ĩrob'uipra za'ra mono norĩ zama, te te sate. Duré rob'uiprazém na te te dawi ãma 're ĩsaprĩ za'ra mono norĩ wi, ma wedeza hã te te tiwi anhamra, utu'u wede'wa norĩ simasisizéb zama. ");
INSERT INTO xavNT_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Te duré dawi rosawi, 'ri 'rãihâ nho're wa'wai baba, da te 're ro'wasari tõ mono da. ");
INSERT INTO xavNT_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Te duré dama rowasu'u, da te ãma ĩrob'ui'érézéb zarina, ãne: — Duréihã wahi'rada hã ma tô ãne na rob'ui'éré ĩbaihâ na, 'Re ĩhâimana u'âsi mono mreme na: “Ĩ̱nhorõwa hã ĩwa ĩ̱ma 're ĩdamreme zusi mono zém na, te za da te 're sisi za'ra, 'ri hã.” Ãne te tinha. Tane nherẽ, a norĩ wa'wa hã ma tô ĩwa asima ãma 're ĩrob'manharĩ wasété za'ra wa'aba mo. Taha wa, danhibrom na dawi 're ĩsipsaihuri za'ra mono norĩ, 're ĩsi'ubumroi mono zém ne, te oto 'ri hã 're sa, wasété uptabi na. — Ãne ma tô Zezusi hã dama waihu'u, da te waihu'u za'ra da. ");
INSERT INTO xavNT_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Tawamhã aibâ norĩ hã ma tô ĩwasu'u hã wapari za'ra, sasedoti ĩpire norĩ hã, rowahutu'wa norĩ zama. Ãne hã te te wapari za'ra wamhã, ma tô ta norĩ hã sima ãma rosa'rata za'ra, te te siwi wĩrĩ da. Tane nherẽ, Zezusihi nhimiroti na, da'ahâ na ãma 're dawata za'ra mono wa, te te sima danhimimnhasi za'ra wa, te te siwi wĩrĩ õ di za a'â. ");
INSERT INTO xavNT_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Tawamhã bâdâ sébré wi, te Zezusi norĩ hã Zeruzarẽ hawi apâ ai'aba'ré, Betãnha na daza'ru nhisi u. ");
INSERT INTO xavNT_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Awẽm na mararé si'aba'réi wamhã, ma tô Zezusi norĩ hã 'madâ'â za'ra, pidera wede hã, uburé ĩwede 'ré na. ");
INSERT INTO xavNT_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Tawamhã Pedru hã ma tô ãma po're puru, Zezusi hã wede ma, te te ĩnharĩzém na hã. Tawamhã ãne te Zezusihi ma tinha: — Rowahutu'wa, 'madâ'â. Õhõta pidera wede. Ahâmhâ tãma ĩnharĩ hã ma tô tiwede'ré. ");
INSERT INTO xavNT_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","23","Tawamhã Zezusi te asa tãma tinha: — Tô sena wa aima waihu'u za'ra wa'wa. 'Re ĩhâimana u'âsi mono si, te za asiwi 're ĩ'umnhasi za'ra wa'aba mo, te te 're aipawaptob za'ra wa'aba mono da. Tawamhã ã ẽtẽ 'rãihâ ma, nharĩ za'ra wa'aba wamhã, uihâ na sisa'o'o da, âi ba sime da, te za ãma aima uwaimrami za'ra wa'wa. 'Râwi asiwawã za'ra wa'aba õ di za, za te te aima ãma ĩ'uwaimrami za'ra wa'aba zém na hã. Tãma ĩnharĩ za'ra wa'aba zéb uwaibaba, za te te ãma aima ĩ'uwaimrami aba na, te za ãma ĩsaze za'ra wa'wa. Tawamhã te za tô te te ãma aima 're a'uwaimrami 'wa, 'Re ĩhâimana u'âsi mono hã. ");
INSERT INTO xavNT_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Taha wa, wa aima waihu'u za'ra wa'wa. 'Re ĩhâimana u'âsi mono ma, 're aimreme zusi aba mono wamhã, duré marĩ na tiwi 're rowaptẽrẽ za'ra wa'aba mono wamhã, za te te ãma aima 're ĩ'a'uwaimrami aba mono zém na, te za ãma 're ĩsaze za'ra wa'aba mo. Tawamhã te za tô te te ãma aima 're a'uwaimrami u'âsi 'wa. ");
INSERT INTO xavNT_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","26","'Re ĩhâimana u'âsi mono ma, 're aimreme zusi aba mono da wamhã, te za a'â aiwi 're da'ru simani za'ra wa'wa. Dawasédé hã da'ãma 're 'madâ'â za'ra wa'aba mono õ di za oto. Tawamhã Aimama 'wa hã hâiwa ãma 're ĩsãmra mono hã te te duré ai'ãma 're 'madâ'â za'ra wa'aba mono õ di za oto, aiwasété 'wa hã. — Ãne ma tô tãma waihu'u za'ra, Zezusi hã. ");
INSERT INTO xavNT_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Tawamhã ma tô apâ aihutu Zeruzarẽ u, Zezusi norĩ hã. 'Re ĩhâimana u'âsi mono ãma 're ĩdawata za'ra mono zéb ãma, 'ri 'wawi wa'ra 're, te 're mo, Zezusi hã. Tame 're morĩ ré, ma tô aibâ norĩ hã ĩtẽme aihutu, sasedoti ĩpire norĩ hã, duré dama rowahutu'wa norĩ hã, duré zudezu norĩ ma roti'wa norĩ hã. ");
INSERT INTO xavNT_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Tawamhã ãne te siwi sadanha: — E 'wa sadawa para, te bété ãne hã marĩ hã dama 're ĩ'ab'manharĩ mo. E 'wa hã, aipisutu'wa. ");
INSERT INTO xavNT_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Tawamhã Zezusi te asa tãma nharĩ za'ra: — Wa hã wa za duré asadanharĩ na aima ãma wa'rãmi za'ra wa'wa. We ĩ̱ma waihu'u za'ra wa'aba wapsi, wa za duré wa hã aima waihu'u za'ra wa'wa, ĩ̱pisutu'wa hã. ");
INSERT INTO xavNT_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Ma'ãpé, we ĩ̱ma waihu'u za'ra wa'aba. E 'wa sadawa para, te Zuwã Batita hã â dawabzuri te te dama 're ab'manharĩ. E 'Re ĩhâimana u'âsi mono zadawa para. E taré dazadawa parap si. — Ãne te Zezusi hã sadanharĩ za'ra. ");
INSERT INTO xavNT_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Tawamhã 'râwi te sima nharĩ za'ra: — E niha, wa za tãma waihu'u za'ra ni, õne wamhã. 'Re ĩhâimana u'âsi mono zadawa para, â dawabzuri te te dama 're ĩ'ab'manharĩ mono na, wa te tãma waihu'u za'ra wamhã, te za wazadanharĩ na sahu za'ra, ãne: “E niha bété, Zuwã Batitaha nhimirowasu'u hã saze za'ra wa'aba õ di.” ");
INSERT INTO xavNT_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Tazahã dazadawa parap si, â dawabzuri te te dama 're ĩ'ab'manharĩ mono na, wa te tãma waihu'u za'ra wamhã, te za wazada tazahi za'ra ni. — Ãne te 'râwi sima nharĩ za'ra, dapipa te, Zuwã Batita hã tô sena 'Re ĩhâimana u'âsi mono zadawa wasu'u'wa 're ĩmorĩ na, da te 're saze za'ra mono wa. ");
INSERT INTO xavNT_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Taha wa, sada dazahi za'ra õ'umnhasite, sina pahi za'ra wa, ma tô duré Zezusihi ma waihu'u na wa'rãmi za'ra, ãne: — Ni'wa sadawa para, ma tô Zuwã hã â dawabzuri hã te te dama 're ab'manharĩ. Wa norĩ hã wa te waihu'u za'ra õ di, ĩpisutu'wa hã. Tawamhã Zezusi te asa tãma nharĩ za'ra: — A norĩ wa'wa hã ĩ̱ma waihu'u aba õ nherẽ, wa hã te duré aima waihu'u za'ra wa'aba õ di za, ni'wa sadawa para, marĩ hã te dama 're ĩ'ab'manharĩ mono na. — Ãne ma tô Zezusi hã tãma timreme na wa'rãmi za'ra. ");
INSERT INTO xavNT_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Tawamhã tinhimirowasu'u na ma tô duré tãma ãma sãna'rata za'ra, ãne: — Aibâ hã te 're sãmra, buru tede'wa hã. Tawamhã tiburu ãma ma tô a're, uwa 'ru hã. Te te a're pari, ma tô buru 'wawi wa'ra. Ma tô duré ẽtẽ nhisiwi sada ab're, uwa 'rãi watizéb da hã, ĩwa'u zô. Taha pari, 'ri 'rãihâ hã ma duré buru wa'wa 'manha, ĩsipsaihuri norĩ zô, dasipapara rob'madâ'âzéb da hã. Tawamhã ma tô ni'wam norĩ hã sisõ'a ré pisutu za'ra, ĩburu hã te te sô 're 'madâ'â za'ra mono da. Uwa 'ru 'rã hã 're 'rãi prédub za'ra mono wapsi, te za te te tãma 're po'o za'ra, buru tede'wai ma hã. Taha pari, te oto mo, buru tede'wa hã darob amoi u, tamomo a'â sãmra da. ");
INSERT INTO xavNT_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Tawamhã oto 'rãi prédu mono wa, ma tô buru tede'wa hã tãma ĩromhuri'wa hã 'mazatõ tiburu u, uwa 'ru 'rã hã buru 'madâ'â'wa norĩ te te tãma ĩpo'o za'ra zô. ");
INSERT INTO xavNT_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Tane nherẽ, ĩtẽme wisi za'ra wi, ma tô siwi ti'â, te te siwi azâri da. Tawamhã ubana ma tô siwi satõ apâ. ");
INSERT INTO xavNT_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Taha pari, te duré ĩwa'rãmi sô 'mazatõ, tãma ĩromhuri'wa hã. Tane nherẽ, buru u ĩtẽme wisi za'ra wamhã, ma tô tãma rob'manharĩ wasété za'ra. Ĩ'rãi wi, ma tô siwi azâ. ");
INSERT INTO xavNT_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Taha pari, te duré 'mazatõ, ĩwa'rãmi. Tane nherẽ, ma tô siwi tĩwĩ, buru na romhuri'wa norĩ hã. Siwa'rãmi sihutu sidâpâsi, ma tô nasi hâ za'ra. Ma tô duré nasi simro. ");
INSERT INTO xavNT_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Tawamhã buru tede'wai 'ra si te oto ĩ'rata 're hâimana, danhowa're're te te ĩsatõrĩ da hã, ĩburu na romhuri'wa norĩ u. Ĩ'ra hã tãma sawi pese uptabi di. Tãma sawi nherẽ, ma tô satõ, buru na romhuri'wa norĩ u, morĩ da. Ãne te ĩmama hã sima rosa'rata: “Ĩ̱'ra si'aibâ hã te ĩtẽme satõrĩ za'ra wamhã, ãté te za siwi hâiba wazé.” ");
INSERT INTO xavNT_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Tane nherẽ, buru na romhuri'wa norĩ u wisi wamhã, te ãne sima 'mahârâ za'ra: “Õhõta buru tede'wai 'ra hã te wei mo, timama uirĩ na buru tede'wa da hã. Wa te wasiwi wĩrĩ aba, buru hã wate za'ra da.” Ãne ma tô sima 'mahârâ za'ra, buru na romhuri'wa norĩ hã. ");
INSERT INTO xavNT_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","— Tawamhã ma tô siwi ti'â, buru tede'wai 'ra hã, te te siwi wĩrĩ da. Te te siwi wĩrĩ pari, ma tô ĩhâiba hã siwi time, buru nhiti. ");
INSERT INTO xavNT_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","— Buru na romhuri'wa norĩ ma hã e niha te za buru tede'wa hã tãma rob'manharĩ za'ra. Te za sô timorĩ za'ra, uburé te te uprosi da, buru na romhuri'wa norĩ hã. Tawamhã te za duré aimawi da'maipisutu, tiburu 'madâ'â'wa da. — Ãne buru na romhuri'wa norĩ wasu'u hã ma tô tãma wasu'u za'ra, Zezusi hã. ");
INSERT INTO xavNT_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Tawamhã te duré 'mahârâ za'ra: — Oro 'Re ĩhâimana u'âsi mono zadawa wasu'u na rob'ui'éré hã 're sõré za'ra wa'aba mono za, aima waihu'u za'ra wa'aba õ di bété. Ãne ĩbaihâ na rob'ui'éré hã: “Ẽtẽ tomhâpâ wẽ hã 'ri na'ratazéb da hã wẽ uptabi nherẽ, 'ri'wa norĩ te te siwi ĩwẽ'õ hã te oto pire na 're sa'wari u'âsi. ");
INSERT INTO xavNT_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Uburé Danhib'apito hã ma tô ãne hã pisutu, 'ri na'rata uparizéb da, pire na 're ĩsa'wari mono da hã. Taha wa, ãne na wa te ãma 're rosa'rata za'ra mono wamhã, wa ãma 're watob'uzu u'âsi za'ra, wa norĩ hã.” Ãne ma tô ẽtẽ wasu'u na tãma rob'rãzarõtõ za'ra, Zezusi hã. ");
INSERT INTO xavNT_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Buru na romhuri'wa norĩ wasu'u hã te te dama wasu'u wamhã, tisiré zudezu norĩ ma, pire na 're ĩhâimana za'ra mono norĩ, te wasu'u, Zezusi hã, 'Re ĩhâimana u'âsi mono ma, da'ãma romhuri'wa norĩ hã, duré dama rowahutu'wa norĩ hã, duré dama roti'wa norĩ hã. Ãne na ma tô sina waihu'u za'ra. Taha 'ru te, te aré siwi ti'â. Tane nherẽ, da'ahâ nhimimnhasi te, te õne haré ai'aba'ré, ĩsiti. ");
INSERT INTO xavNT_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Tawamhã 'Re ĩhâimana u'âsi mono ma, da'ãma romhuri'wa norĩ hã ma tô parisezu norĩ hã 'mazatõrĩ za'ra, Zezusihi u si'aba'ré da. Erodihi niwĩ 're ĩhâimana za'ra mono norĩ zama, ma tô ĩtẽme 'mazatõrĩ za'ra, tinhimiroti na te te upai wa, te te siwi wẽ'õ za'ra da. ");
INSERT INTO xavNT_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Tawamhã ĩtẽme sihutu wamhã, te siwi sadanha: — Rowahutu'wa, tô sena na wa tô aimreme na aiwaihu'u za'ra ni. Danhimirosa'rata na 're aihâimana mono õ di. Duré dapire na 're dahâimana za'ra mono nherẽ, aima hã aiwapsi dahâimanazé hã. 'Re ĩhâimana u'âsi mono nhimiroti zarina si, te uburé marĩ hã dama 're ĩ'awaihu'u mo, sena na. Taha wa, te za asimirosa'rada hã wama ĩwaihu'u za'ra, wa te aiwapari za'ra da. E Roma ãma danhib'apito uptabi ma, wa za rob'uiprazé hã wa te 're po'o za'ra, ĩsimiwada'uri zarina. E 'Re ĩhâimana u'âsi mono ma, wẽ di. E tãma wẽ õ di. — Ãne ma tô ãma siwi sadanha, Zezusi hã. ");
INSERT INTO xavNT_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Tô sena te te siwi ãma waihu'u za'ra da newa, ma tô siwi sadanha. Ãne na hã senai õ na, ma tô sina waihu'u, Zezusi hã. Taha wa, te ãne tãma nharĩ za'ra: — E marĩ da, te ãne na asiwi ĩ̱zadanharĩ 'wa, ĩ̱mreme na te aima ãma upa za'ra wa'aba da newa, asiwi ĩ̱wẽ'õ wa'aba da. Tane wamhã, ma'ãpé rob'uiprazé ĩsapotore hã we ĩ̱ma 'mai'âri aba, te 'madâ'â da. ");
INSERT INTO xavNT_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Tawamhã ma tô ni'wa hã tãma tisõ, Zezusihi ma. Te ãma dazadanharĩ za'ra, ãne: — E 'wai hâibarĩ, rob'uiprazé ĩsapotore na hã. E 'wa sisi ui'éré duré, ãma hã. Tawamhã asa ma tô tãma waihu'u za'ra: — Ã hã, Roma ãma danhib'apito hâibarĩ, duré taha nhisi ui'éré. ");
INSERT INTO xavNT_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Tawamhã Zezusi ma duré asa tãma waihu'u za'ra: — Roma ãma danhib'apito ma, te za ĩsimiwada'uri zarina, marĩ tãma 're ĩpo'o za'ra wa'aba mo apâ, ĩte wa. Tane duré, 'Re ĩhâimana u'âsi mono ma, te za marĩ hã ĩsimiwada'uri zarina, tãma 're ĩsõmri za'ra wa'aba mo apâ, ĩte wa marĩ hã. — Ãne ma tô asa tãma waihu'u za'ra. Tawamhã ma tô ãma titob'uzu za'ra, te te tãma ĩwaihu'u za'ra zém na asa, Zezusi hã. ");
INSERT INTO xavNT_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","19","Taha pari, ni'wam norĩ hã ma ĩtẽme aihutu, Zezusihi u, sadusezu norĩ hã. Ta norĩ hã 're dadâ'â za'ra mono wamhã, ab're hawi apâ 're ĩdahâiwa'utu za'ra mono õ na te te dama 're ĩroti za'ra mono. Ta norĩ hã te tãma rowasu'u za'ra, Zezusihi ma, ãne: — Rowahutu'wa, wahi'rada Mozési hã ma tô ãne dama roti: “Aibâ ĩmro ré hã 'ra õ ré, dâ'â wamhã, tizédé'aba mro na te za timro ĩno hã, ai'uté hã te te 'maipoto da, ĩwa ĩsédé'aba 'ra ne, 're morĩ da.” Ãne wahi'rata nhimiroti na rob'ui'éré hã. ");
INSERT INTO xavNT_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Wa za oto aima rowasu'u za'ra ni, dasisãnawã si 're ĩhâimana za'ra mono norĩ wasu'u na. Aibâ hã sisãnawã si, te 're hâimana za'ra, 7 na ĩhâiba za'ra hã. Tawamhã ĩpoto'rada hã ma tô timro oto. Tawamhã 'ra õ ré, ma dârâ, aibâ hã. ");
INSERT INTO xavNT_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Tawamhã ĩsõsi hã ma tô ãma timro pi'õi ãma hã, ĩsõwa're're. Ta hã 'ra õ ré, ma duré dârâ. Taha nhosi, ãma mro wamhã, 'ra õ ré, ma duré dârâ. ");
INSERT INTO xavNT_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Aibâ norĩ hã ma tô nasi sisõwa're're ãma timro za'ra, pi'õi ãma, 7 na ĩhâiba za'ra hã aibâ norĩ hã. Tane nherẽ, 'ra õ ré, ma tô sisarina ai'utõ. Tawamhã nimahã bâtâ na ma tô duré pi'õ hã, timro norĩ zarina, dârâ. ");
INSERT INTO xavNT_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Aibâ norĩ hã 7 na ĩhâiba za'ra hã, misi pi'õ nherẽ, ma tô nasi sisõwa're're ãma timro za'ra. Tawamhã 're ĩdadâ'â za'ra mono norĩ hã, 'Re ĩhâimana u'âsi mono, ab're hawi za apâ oto te te 're da'ahâiwa'utu mono wamhã, e 'wai me te za oto 're simasisi zahuré. — Ãne te ãma siwi sadanha, sadusezu norĩ hã. ");
INSERT INTO xavNT_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Tawamhã Zezusi te asa tãma rowasu'u za'ra: — A norĩ wa'wa hã ma tô rosa'rata na ãma ĩ'upa za'ra wa'wa, ab're hawi, za apâ 're ĩdahâiwa'utu za'ra mono õ na hã. E marĩ wa. 'Re ĩhâimana u'âsi mono zadawa wasu'u na rob'ui'éré hã 're sõré za'ra wa'aba mono nherẽ, aima waihu'u za'ra wa'aba õ wa, duré tiwaihu'u pese na, za ab're hawi apâ te te 're ĩda'ahâiwa'utu mono zé hã, aima waihu'u za'ra wa'aba õ wa. ");
INSERT INTO xavNT_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","'Re ĩhâimana u'âsi mono hã ab're hawi apâ te te 're da'ahâiwa'utu mono wamhã, hâiwa ãma romhuri'wa norĩ ne, te za oto 're dahâimana u'âsi za'ra, dasina 're damro za'ra mono ãna. ");
INSERT INTO xavNT_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Marĩ, wa za duré aima waihu'u za'ra wa'wa, 're dadâ'â za'ra mono pari, apâ 're ĩdanomro mono zé wasu'u na. Wede zapore ĩro'o na ma tô ãma rob'ui'éré, Mozési hã. E niha 're sõré za'ra wa'aba mono nherẽ, aima waihu'u za'ra wa'aba õ di. Ãne ma tô Mozésihi ma siwasu'u, 'Re ĩhâimana u'âsi mono hã: “Wa hã Abra'ãhã nhib'apito, wa 're ĩ̱hâimana u'âsi, duré Izatihi nhib'apito, duré Zacoho nhib'apito.” Ãne ma tô Mozésihi ma siwasu'u, 'Re ĩhâimana u'âsi mono hã, Abra'ã norĩ uirĩ na nherẽ. ");
INSERT INTO xavNT_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Wahi'rata norĩ hã dawi 're dâ'â za'ra mono nherẽ, 'Re ĩhâimana u'âsi mono wi, 're dâ'â za'ra mono õ di. Taha wa, ma tô Ĩsib'apito za'ra na siwasu'u. Dâ'â u'âsi 're hâimana za'ra mono 'wa'âhã, Ĩsib'apito na aré siwasu'u õ di. Ãne wa, ma tô rosa'rata na ãma ĩ'upa za'ra wa'wa, ab're hawi apâ 're ĩdahâiwa'utu za'ra mono õ na hã. — Ãne ma tô Zezusi hã tãma waihu'u za'ra, sadusezu norĩ ma. ");
INSERT INTO xavNT_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Tawamhã 'Re ĩhâimana u'âsi mono nhimiroti 'rata na rob'ui'éré na dama rowahutu'wa hã ma tô ãma mreme wapa, da'rata ĩsa hã. Zezusi hã sadusezu norĩ ma, te te rowasu'u wẽ wa, te ãne sadanha: — 'Re ĩhâimana u'âsi mono nhimiroti hã e ma hã te tihâiba, uburé dama ĩpire uptabi hã. ");
INSERT INTO xavNT_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Tawamhã Zezusi hã ma tô ãma sada'â asa: — 'Re ĩhâimana u'âsi mono nhimiroti, danhipai u ĩpire uptabi hã ãne: “Izarazéhé nhihudu norĩ, ma'ãpé ĩ̱wapari pese za'ra wa'aba za. 'Re ĩhâimana u'âsi mono hã Wanhib'apito hã, misire danhib'apito uptabi, te 're hâimana. ");
INSERT INTO xavNT_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Taha wa, Asib'apito 're hâimana aba mono wa, te za asiwi 're ĩsawi pese za'ra wa'aba mo, sena na. Taha zarina, te za ĩsimiroti na ãma 're ĩrosa'rata u'âsi za'ra wa'aba mo. Taha zarina, te za duré asimi'ẽ na tãma 're ĩromhuri u'âsi za'ra wa'aba mo.” Ãne ĩsimiroti hã danhipai u ĩpire uptabi hã. ");
INSERT INTO xavNT_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Ãne duré ĩsimiroti hâiba amo hã aiwa ĩpire uptabi hã: “Uburé te za 're ĩdazawi pese za'ra wa'aba mo. Marĩ ĩwẽ zô asima 're asõpré wa'aba mono ne, te za duré uburé dama zama sô 're asõpré wa'aba mo, ĩwẽ zô.” Ã norĩ si ĩsimiroti hã, ĩpire uptabi zahuré hã. Ĩsipai u hã roti hã 'maihâimana õ di, ĩpire uptabi hã. ");
INSERT INTO xavNT_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Tawamhã rowahutu'wa hã te asa tãma tinha: — Tane tô rowahutu'wa. Tô sena uptabi, asimirowasu'u hã. Misire danhib'apito uptabi te 're hâimana, 'Re ĩhâimana u'âsi mono hã. Ni'wa hã 're hâimana mono õ di, ĩsipai u hã. ");
INSERT INTO xavNT_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Taha wa, wa za tô wa te 're sawi pese za'ra, 'Re ĩhâimana u'âsi mono hã. Taha zarina, wa za ĩsimiroti na wa te ãma 're rosa'rata u'âsi za'ra. Wa za duré wanhimi'ẽ na wa te tãma 're romhuri u'âsi za'ra. Wa za duré wa te 're dazawi pese za'ra. Marĩ ĩwẽ zô wasima 're ĩwanhopré mono ne, wa za uburé dama zama sô 're wanhopré, ĩwẽ zô. Wa norĩ hã wa za wanhimizama hã duré wanhimarĩ hã wa te tãma 're sõmri za'ra, 'Re ĩhâimana u'âsi mono ma, da te tãma 're zata za'ra mono da, ĩzatazém na. Ãne wamhã, tãma wẽ di, 'Re ĩhâimana u'âsi mono ma. Tane nherẽ, maparane ĩsimiroti hã ĩpire uptabi hã wa te 're 'madâ'â pese za'ra mono wamhã, tãma wẽ uptabi di za. — Ãne ma tô Zezusihi ma waihu'u na wa'rã, rowahutu'wa hã. ");
INSERT INTO xavNT_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Tawamhã rowahutu'wa hã te te tãma ãma uwaimrami wẽ wa, ma duré Zezusi hã tãma waihu'u: — Tane tô. A hã, 'Re ĩhâimana u'âsi mono, da'ãma 're ĩsib'a'uwẽ mono zém nhiti, romhâ na aihâimana õ di, ãhãna hã. — Ãne ma tô tãma waihu'u, rowahutu'wai ma. Taha parimhã, ni'wa hã te te sadanharĩ na sahu õ di oto, Zezusi hã tinhimiroti na te te ãma upai õ wa. ");
INSERT INTO xavNT_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Tawamhã bâtâ na te Zezusi hã dama rowahutu, 'Re ĩhâimana u'âsi mono ãma 're ĩdawata za'ra mono zé 'wawi, wa'ra 're. Tawamhã te te dama rowahutu ré, te da'mahâ: — E niha rowahutu'wa norĩ hã te te dama 're rowasu'u za'ra, Dawihi nhihudu 're ĩmorĩ na hã, 'Re ĩhâimana u'âsi mono te te ĩpisutu na hã Danho'reptui'wa da. ");
INSERT INTO xavNT_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Duréihã apito Dawi hã ma tô danho'reptui'wa na ãma rob'ui'éré, 'Re ĩhâimana u'âsi mono hã Tipẽ'ẽzani na te te tãma ĩwaihu'uzéb zarina. Ãne ãma ĩrob'ui'éré hã: “'Re ĩhâimana u'âsi mono hã ma tô Ĩ̱nhib'apito ma tinha, ãne: ‘Ĩ̱'rata te za 're asãmra mo, ĩ̱nhimire niwĩ dama aipire na ĩ̱siré 're aihâimana u'âsi mono da. Asitob'ru norĩ nhiptetezé hã wa za te tiwi 're a'uprosi, wapu na aima 're hâimana za'ra mono da oto, duré aima sib'uwa na 're hâimana za'ra mono da oto.’ ” — Ãne te tãma tinha. Ãne duréihã, ma tô ãma rob'ui'éré, apito Dawi hã. ");
INSERT INTO xavNT_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Danho'reptui'wa da hã tinhib'apito na ma tô sisi, Dawi hã. Ĩsib'apito 're morĩ nherẽ, e niha te za ĩsa'u si poto nherẽ, Danho'reptui'wa da hã ĩsihudu na 're hâimana. — Ãne ma tô da'ahâ na da'mahâ, Zezusi hã. Tawamhã Zezusihi nhimiroti hã wẽ wa, ma da'ahâ na wapari ze za'ra ni. ");
INSERT INTO xavNT_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","39","Tawamhã Zezusi hã ma duré dama waihu'u, ãne: — Ma'ãpé rowahutu'wa norĩ hâimanazé hã waihu'u za'ra wa'aba. Ta norĩ hã uza pa ré, 're ĩnomro mono da si, tãma ĩwẽ za'ra hã. Duré dama pire na 're hâimana za'ra mono wa, 'ri nhi'riti wa, da te dasina 're ĩ'ubumroi mono zéb ãma, da te 're ĩwazéb za'ra mono da si, ma tô te te sima 're wẽ za'ra. Duré dama ĩpire norĩ simasisizém na 're si'ubumroi mono da si, tãma ĩwẽ za'ra hã, rowahutuzéb ãma duré 'ri para dasiré 're ĩdasaihuri mono zéb ãma hã. ");
INSERT INTO xavNT_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Dama rowahutu'wa zahã, te sadawa nhipese na pi'õi mrotõ norĩ wi, ĩsimarĩ na 're sipsaihuri za'ra. Tane nherẽ, te ta norĩ hã danho'a 'Re ĩhâimana u'âsi mono ma 're mreme zusi hâ, 're hâimana wẽ uptabi za'ra mono newa. Taha wa, te te dama 're ĩrob'manharĩ za'ra mono zém nhipai u, te za 'Re ĩhâimana u'âsi mono hã te te tãma 're rob'manharĩ za'ẽtẽ za'ra. — Ãne ma tô dama rowasu'u, rowahutu'wa norĩ hâimanazém na. ");
INSERT INTO xavNT_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Tawamhã 'Re ĩhâimana u'âsi mono ma, rob'uiprazé da te 're ĩséme mono zéb 'rata, te nhamra Zezusi hã, 'ri 'wawi wa'ra 're. Rob'uiprazé, da te nasi séme za'ra ré, te da'ab'madâ. Ĩsibro pese norĩ hã, ahâ na te nasi séme za'ra, rob'uiprazé hã sa'ẽtẽ na. ");
INSERT INTO xavNT_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Taha ré, ma tô wi pi'õi mrotõ hã, ĩsibrob'õ hã. Tawamhã rob'uiprazé ĩsapotore hã ma tô tiza, syryre nherẽ. ");
INSERT INTO xavNT_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","44","Tawamhã tisiré 're ĩnomro mono norĩ zô, te sima sô tihârâ za'ra, Zezusi hã. Ãne te tãma rowasu'u za'ra: — Tô sena ã pi'õi mrotõ hã sibrob'õ nherẽ, ma tô tinhoprubzém na uburé da'a'rãnhipa. Ĩsiré ĩséme'wa norĩ hã rob'uiprazé, nasi tãma ĩsi'atarẽme za'ra si, te nasi sé. Tanei õ di, pi'õi mrotõ hã. Simarĩ õ nherẽ, tihâimanazéb da, te te aré ĩtédé hã ma tô ĩbâre tãma tisõ, wahuré. Ãne wamhã, ma tô tinhoprubzém na uburé da'a'rãnhipa. — Ãne ma tô Zezusi hã tãma waihu'u za'ra, tisiré 're ĩnomro mono norĩ ma hã. ");
INSERT INTO xavNT_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Tawamhã Zezusi norĩ hã 'Re ĩhâimana u'âsi mono ãma 're ĩdawata za'ra mono zé 'wawi wa'ra hawi, oto wairébé wi, misi te ĩsiré hã 'mai'mahâ: — Rowahutu'wa, 'ri hã 'madâ'â za'ra na. Ẽne hã e ĩtõmo wasétére. E ĩ'ri wasétére duré. — Ãne te tãma ãma tiwata, 'ri wẽ na. ");
INSERT INTO xavNT_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Tawamhã Zezusi te asa tãma tinha, ãne: — Ã hã 'ri ĩ'madâ'â za'ra wa'wa hã, nimahã na si te za dasiwi pru pese ni, ẽtẽ na 'ri hã. Tawamhã misi si te za oto simi'wara, ẽne hã. Sisisiwi 'manomro waihu'u õ di za oto, ẽne hã. Tâibâ za oto. — Ãne ma tô 'ri na tãma ãma rowasu'u sirõmo za'ra Zezusi hã, te te waihu'u za'ra da. ");
INSERT INTO xavNT_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Tawamhã Zezusi hã te oto nhamra, Oriwera na ẽtẽ 'rãihâ nhisi ãma, tisiré 're ĩnomro mono norĩ me. Sisõ're u, te 'ri 'madâ, 'Re ĩhâimana u'âsi mono nhorõwa hã. Te te 'madâ'â ré, te siwi sadanha, hâiba pisutu Pedru norĩ hã, Ti'adu, Zuwã, Ãdéré norĩ me: ");
INSERT INTO xavNT_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","— E niwa te za ãne hã ãma tiromhâiba, 'ri nhamrazéb da hã. E marĩ te za watobro, da te ĩwaihu'uzéb da hã. Ma'ãpé, wama waihu'u za'ra na, ĩsõwa wa te ãma ĩwaihu'u sirõmo za'ra zéb da hã. ");
INSERT INTO xavNT_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","6","Tawamhã Zezusi ma tô asa tãma waihu'u za'ra, ãne: — Ni'wam norĩ hã te za sadawa nhipese na sisarina datẽme 're nomro, ahâ na. Wa hã newa, te za taré ĩ̱nhisi na we 're siwasu'u za'ra, danho'reptui'wa na. Tawamhã da'ahâ na te za ta norĩ ãma da te 're sasõmri za'ra, tô sena newa, dama 're ĩsiwasu'u za'ra mono zé hã. Taha wa, te za a norĩ wa'wa hã asimiza'rese tiwi 're aihâimana za'ra wa'aba mo, sadawa nhipese sina datẽme 're ĩnomro mono norĩ ãma, 're sasõmri za'ra wa'aba mono tõ da. ");
INSERT INTO xavNT_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","'Re dasi'wapé za'ra mono wa, da te dasina 're ĩropupu'u za'ra mono zé hã, duré romhâ na 're ĩdasi'wapé za'ra mono norĩ wasu'u zama, 're wapari za'ra wa'aba mono wamhã, tãma 're aipahi za'ra wa'aba mono õ di za. Dasi'wapé te za tô dazada 're wairébé. Tane nherẽ, da'ãma rob'rãsutu uptabi õ di za a'â. ");
INSERT INTO xavNT_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Danhipti'ai amoi u te za dasisô 're dapra, 're dasi'wapé za'ra mono da. Tawamhã daro mono bâ te za tô 're dasiwasutu za'ra. Nima niwĩmhã, te za duré ti'a hã daré 're popo'o za'ra. Duré danho õ wa, te za da te 're robzépata za'ra, dasa syryre wa. Ãne hã rowasédé, dazô 're wairébé mono wamhã, za daré ĩrob'rãsutu na'rata zé, te wasu'u, pi'õi ãma ĩwasã hã 're ĩsépu'u na'rata za'ra mono ne. Ãhã haré dazô 're wairébé mono õ di za. ");
INSERT INTO xavNT_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","— Ma'ãpé, aihâimana nhimiza'rese, 're aihâimana za'ra wa'aba mono za. Niwapsi te za a norĩ wa'wa hã da te 're aipawasisi za'ra wa'wa, roti'wa norĩ u, da te 're asimroi wa'aba mono da. Tawamhã ta norĩ zadawa para, te za rowahutuzéb ãma da te 're aihâ za'ra wa'wa, romhâ nhorõ 'manharĩ na. Ĩ̱zazei'wa 're anomro aba mono wa, te za da te 're asimroi wa'wa, dama ĩpire norĩ u, duré danhib'apito norĩ u zama. Ãne wamhã, te za tãma 're ĩrowasu'u za'ra wa'aba mo, ĩ̱zazei'wa 're anomro aba mono na. ");
INSERT INTO xavNT_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Rob'rãsutu õ ré, te za ĩ̱wasu'u wẽ na te te 're dapo're pu'u za'ra, daro mono bâ, ĩ̱zazei'wa norĩ hã. ");
INSERT INTO xavNT_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Tawamhã dama ĩpire norĩ u da te 're asimroi wa'aba mono wamhã, asimirosa'rata na asisõwa asina 're aihâtâ'â za'ra wa'aba mono õ di za, niha tãma 're asiwasu'u za'ra wa'aba mono zéb da hã. Misi bâtâ na, aihâimanazém na da te 're aiwaihu'u za'ra wa'aba mono zém na, 'Re ĩhâimana u'âsi mono hã te za te te aima 're waihu'u za'ra wa'wa, dama ãma 're asiwaihu'u za'ra wa'aba mono zéb da hã. Asimirosa'rata na, asi'uihâ na dama 're asiwasu'u za'ra wa'aba mono da hã, mare di. 'Re ĩhâimana u'âsi mono pẽ'ẽzani hã te za te te 're aipawaptob za'ra wa'wa, dama 're asiwasu'u za'ra wa'aba mono zéb da hã. ");
INSERT INTO xavNT_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Niwamhã te za dasisãnawãi uptabi nherẽ, da te dasima 're dahâiba nhomri za'ra, da te 're simroi mono da. Damama norĩ hã te za ti'ra ma, ãne te te tãma 're 'manharĩ wasété za'ra, 'râwim nherẽ. Duré da'ra norĩ hã timama uptabi da nherẽ, te za sada 're hâimana za'ra, te te dama 're hâiba nhomri za'ra mono da, da te 're simroi mono da, ĩna me. ");
INSERT INTO xavNT_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Ĩ̱zazei'wa oto 're anomro aba mono wa, te za uburé da te 're ai'ruiwapari za'ra wa'wa. Tane nherẽ, õne haré ĩ̱'ãma 're anomro u'âsi aba mono wamhã, te za asõ'reptuzé hã asina 're ĩ'uwaimrami za'ra wa'aba mo. — Ãne ma tô Zezusi hã tisiré 're ĩnomro mono norĩ ma, waihu'u za'ra, te te sina waihu'u sirõmo za'ra da. ");
INSERT INTO xavNT_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","Tawamhã ma duré tãma waihu'u za'ra: — Nimahã na te za asiwi ĩ'madâ'â za'ra wa'wa, 'Re ĩhâimana u'âsi mono te te siwi ĩwẽ'õ pe hã, te te dawi ĩrosawizéb ãma ĩsa hã. (Ãhã wasu'u na rob'ui'éré hã 're sõré za'ra wa'aba mono wamhã, ma'ãpé ãma 're rosa'rata pese za'ra wa'aba mono za, waihu'u za'ra wa'aba da.) Tawamhã ãne hã za oto daré romhâimana wamhã, rowasété si te za a'â daré 're sa'wari. Taha wa, Zudeza na danhipti'a nho'õmo nhisi ãma 're ĩsi'ubumroi mono norĩ hã, wara sina te za sisa're, ẽtẽ 'rãihâ u ta norĩ hã tiwi simani za'ra da, duré sisõ'reptu za'ra da. ");
INSERT INTO xavNT_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Ni'wam norĩ hã 'ri nhisi hâpâ ãma si'ubumroi wamhã, tinhibrob zô sisisi õ di za a'â, 'ri para u. Õne haré te za dame sisa're, ẽtẽ 'rãihâ u, ta norĩ hã. ");
INSERT INTO xavNT_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Duré ni'wam norĩ hã buru ãma te te romhuri za'ra wamhã, 'ri tẽme sisa'rei mono õ di za apâ, tisi'ubuzéb zô. Mare di. Õne haré te za duré ta norĩ hã ẽtẽ 'rãihâ u dame sisa're. ");
INSERT INTO xavNT_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Ãne hã rowasédé hã daré hâimana wamhã, ĩwasã ré norĩ ma hã tãma ropipa uptabi za'ra di za, ĩ'ra pré ré norĩ ma zama. ");
INSERT INTO xavNT_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Taha wa, rowa'u'u wahâ 'rowi, marĩ hã dazô watobro tõ da, te za 'Re ĩhâimana u'âsi mono wi, 're ĩrowaptẽrẽ za'ra wa'aba mo. ");
INSERT INTO xavNT_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","E marĩ wa. Rowasédé hã oto dazô 're wairébé mono wamhã, te za oto robzépata za'ẽtẽ za'ra ni. 'Re ĩhâimana u'âsi mono te te ĩ'aropoto na'rata mono zém hawimhã, ãne na da te ĩrobzépata za'ẽtẽ uptabi za'ra õ. Niwamhã ãne na hã da te 're robzépata zahu za'ra mono õ di za. ");
INSERT INTO xavNT_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","'Re ĩhâimana u'âsi mono hã ma tô sima pisutu, bâdâ hã za da te 're ĩrobzépata za'ra mono zéb da hã, te te dama wãtari da, rowasété ré da'ãma romhâimana pahâ tõ da. Ãne hã te te sima pisutu õ 'wa'âhã, te aré uburé dasi'utõrĩ pese, za da'ãma ĩrob'rãsutuzém na hã. 'Re ĩhâimana u'âsi mono hã ãma 're sib'a'uwẽ za'ra mono da, te te sima 're ĩ'apisutu mono norĩ zawi te, te za ãne hã 'manha. ");
INSERT INTO xavNT_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","— Marĩ hã wa za duré aima waihu'u za'ra wa'wa. Ãté ni'wam norĩ hã te za taré te te aima 're rowasu'u za'ra wa'wa, ãne: “Ãhãta danho'reptui'wa da, 'Re ĩhâimana u'âsi mono te te ĩpisudu hã te nhamra. Õhõta te nhamra.” Ãne wamhã, ãma 're dazaze za'ra wa'aba mono õ di za, damreme na hã. ");
INSERT INTO xavNT_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","E marĩ wa, wa ãne aima waihu'u za'ra wa'wa. Ni'wam norĩ hã te za datẽme 're nomro, danho'reptui'wa na, niha wamhã, 'Re ĩhâimana u'âsi mono zadawa wasu'u'wa na dama 're siwasu'u za'ra mono da, sadawa nhipese na. Ta norĩ hã marĩ dama ĩ'manharĩ waihu'u'õ hã te za te te dama 're 'manharĩ za'ra, 'Re ĩhâimana u'âsi mono zadawa para newa, da te ãma 're sasõmri za'ra mono da. Ĩsazei'wa norĩ zama te te dame ãma 're saze za'ra mono da, te za ãne na te te dama 're romhõsi za'ra. Tane nherẽ, te te dame 're sazei waihu'u za'ra mono õ di za ta norĩ hã, 'Re ĩhâimana u'âsi mono te te sima 're apisutu sirõmo mono wa, ãma 're sib'a'uwẽ za'ra mono da. ");
INSERT INTO xavNT_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Ãne hã wa aima waihu'u sirõmo za'ra wa'wa, romhâ ré, pibui pese sina, ãma sô 're rob'madâ'â za'ra wa'aba mono da. — Ãne ma tô tãma waihu'u sirõmo za'ra, Zezusi hã. ");
INSERT INTO xavNT_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","Tawamhã Zezusi ma duré tãma waihu'u za'ra, tisiré 're ĩnomro mono norĩ ma: — Da te robzépata za'ra pari wamhã, bâdâ hã te za titobra. A'amo zama te te rob'uiwẽ õ di za oto. ");
INSERT INTO xavNT_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Wasi hã te za duré hâiwa hawi rere. Uburé hâiwa na 're ĩsimasa mono hã te za duré 're sisa're. ");
INSERT INTO xavNT_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Tawamhã ti'ai ãma dasiré ĩ̱podo hã, hâiwa'a na wa za wei mo apâ, danho'a. Ĩ̱waihu'u pese uptabi na, wa za wei mo apâ, duré ĩ̱hâiba na rowa'a za'ẽtẽ uptabi na. ");
INSERT INTO xavNT_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Tawamhã hâiwa ãma ĩ̱ma romhuri'wa norĩ hã wa za we dazô satõrĩ za'ra, Ropoto'wa te te sima 're ĩ'apisutu mono norĩ zô, te te ĩtẽme da'ubumro za'ra mono da, daro mono bâ. — Ãne ma tô romhâ ré tãma waihu'u sirõmo za'ra. ");
INSERT INTO xavNT_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","Tawamhã Zezusi hã ma duré ãne tãma waihu'u za'ra: — Pidera wede na wa za oto aima ãma romnhimiré'é za'ra wa'wa, waihu'u za'ra wa'aba da. Pidera wede panhipti hã wapti'i wamhã, duré ĩsu té hã 're wairébé mono wamhã, tawapsi te za oto ãma ĩwaihu'u za'ra wa'wa, tã 're ĩta'a mono zéb u 're ĩromhutu mono zém na hã. ");
INSERT INTO xavNT_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Tane duré, marĩ hã 're ĩromhâimana mono zéb da, te aima ĩwasu'u za'ra wa'aba zéb zarina, 'madâ'â za'ra wa'aba wamhã, te za ãma ĩrowaihu'u za'ra wa'wa, rob'rãsudu hã za oto ĩwatobro na hã. ");
INSERT INTO xavNT_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Tô sena wa ãne hã aima waihu'u sirõmo za'ra wa'wa. Ã hã uburé rowasédé hã dazô 're wairébé mono ré, ti'ai ãma 're ĩdasi'ubumroi mono norĩ hã ta norĩ hã 're dâ'â za'ra mono õ ré, te za ĩsõ'a za'ra ti'rãsutu, rowasédé hã. ");
INSERT INTO xavNT_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Nimahã na te za hâiwa norĩ hã ai'utõrĩ zahuré, ti'ai me. Si'utõrĩ zahuré nherẽ, ĩ̱nhimiroti hã si'utõrĩ waihu'u õ di za. Pire na te za dama 're hâimana u'âsi. — Ãne ma tô tãma waihu'u za'ra, te te waihu'u sirõmo za'ra da. ");
INSERT INTO xavNT_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","Tawamhã ãne ma duré tinhimiroti 'rãsudu hã tãma waihu'u sirõmo za'ra, Zezusi hã: — Ãne hã uburé za daré 're ĩromhâimana mono zéb da hã, ni'wa hã bâdâ hã te te waihu'u õ di. Hâiwa ãma romhuri'wa norĩ zama, te te waihu'u za'ra õ di duré. Wa hã 'Re ĩhâimana u'âsi mono 'ra nherẽ, te duré bâdâ hã waihu'u õ di. Ĩ̱mama ma si, waihu'u pese di, bâdâ hã. ");
INSERT INTO xavNT_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","A norĩ wa'aba zama, bâdâ hã waihu'u za'ra wa'aba õ wa, ma'ãpé asimiza'rese, 're aihâimana za'ra wa'aba mono za. ");
INSERT INTO xavNT_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Romnhimiré'é na, wa za marĩ hã aima waihu'u za'ra wa'wa. Ãté aibâ hã te za tinhorõwa hawi watobro, romhâ na 're morĩ da. Tawamhã sisõ'a ré, tãma ĩromhuri'wa norĩ ma, te za romhuri hã te te tãma pisutu. Duré 'ridawa 'madâ'â'wai ma zama te za roti, te te sô 're rob'madâ'â pese mono da. ");
INSERT INTO xavNT_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","36","'Ri tede'wa hã apâ za ĩwisizé hã, bâdâ te te waihu'u za'ra õ di, tãma ĩromhuri'wa norĩ hã. Apâ tinhorõwa u ĩwisizé hã, ãté hâiwahâ, ãté mara wa'wa, ãté si'a hârâ wi, ãté awẽ wi. Tane bâdâ hã apâ we ĩ̱morĩzé hã waihu'u za'ra wa'aba õ wa, te za asimiza'rese ĩ̱zô 're asimipari za'ra wa'aba mo, a norĩ wa'aba zama, 're asõtõ za'ra wa'aba mono newa, asimiza'rese ãna 're aihâimana za'ra wa'aba mono ré, apâ we ĩ̱morĩ õ'umnhasite. ");
INSERT INTO xavNT_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Ãne hã aima si, te waihu'u za'ra wa'aba õ di. Uburé ĩ̱zazei'wa norĩ udâna zama, wa aima waihu'u sirõmo za'ra wa'wa, asimiza'rese, ĩ̱zô 're asimipari za'ra wa'aba mono da. — Ãne Zezusi hã 'ri tede'wai wasu'u na te te sina ĩsimiré'ézé wasu'u 'rãsudu hã. ");
INSERT INTO xavNT_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Maparane te oto sô rowaptâ bâtâ zô hã, dato hã da te 're ĩ'manharĩ za'ra mono zéb u hã, 'Re ĩhâimana u'âsi mono, Ezitu hawi te te ĩdawaibuzém na ãma dasipo're pu'u za'ra da, Pascowa na dato nhisi hã. Tawapsi dasi'rã'õtõ ré, te za romhuri na ĩ'u'ẽtẽ duptoi'õ hã huri ni. Tawamhã bâdâ ĩwa waptã'ã õ ré, te sasedoti ĩpire norĩ hã rowahutu'wa norĩ me, sima ãma rosa'rata za'ra, Zezusi hã pi'uriwi te te siwi âri da, da te dasiwi wĩrĩ da. ");
INSERT INTO xavNT_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Ãne te sima ãma roti za'ra: — Dato hã hâimana ré, wa te wasiwi âri õ di za, wama dazahi za'ra õ'umnhasite, uburé hã wazada hâimana za'ra tõ da. — Ãne ma tô sima ãma roti za'ra. ");
INSERT INTO xavNT_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Tawamhã Zezusi hã Betãnha na 'ri wa'õtõ nhisi ãma, te a'â tihâiba, Simahã nhorõwa ãma, ĩ'wa're ré hã, aré ta hã. Tame sai ma, sãmra ré, ma tô we pi'õ hã ãzé, 'ri para u. Wedewa'u zadaze hã ẽtẽ 'manharĩ 'remhã, ma siré ãwisi. Wedewa'u zadaze hã, nadu na ĩsisi hã, ĩwa'âbâ za'ẽne hã. Tawamhã ĩsé hã ma tô sô pru. Taha pari, ma Zezusihi 'rã nhisiwi sa'wa. ");
INSERT INTO xavNT_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Ni'wam norĩ hã tame ĩhâimana za'ra hã ma tô ãma wẽ'õ za'ra. Taha wa, ma tô sima rowasu'u za'ra: — E niha, ma taré ãma si'uba, wedewa'u zadaze na hã. ");
INSERT INTO xavNT_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Te te dama wede 'wa'âhã, ĩwa'â hã ĩsa'ẽtẽ uptabi hã 300 na te aré tihâiba, rob'uiprazé ĩsapotore hã, ĩsibrob'õ norĩ ma, te te sõmri mono da. — Ãne ma sima ãma rowaihu'u za'ra, ĩtede'wai upana nherẽ. Pi'õi ãma, ma tô duré wasété za'ra. ");
INSERT INTO xavNT_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Tawamhã Zezusi hã te tãma nharĩ za'ra: — Tô'ã. Pi'õ hã rowẽ na hâimana. E marĩ da, ma tô sada asahi za'ra wa'wa. Pi'õ hã ĩwẽ uptabi hã ma tô ĩ̱ma 'manha. ");
INSERT INTO xavNT_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Ĩsibrob'õ norĩ hã te ai'rata 're si'ubumroi u'âsi 'wa. Nimahã bâtâ na, asima 're ĩwẽ za'ra wa'aba mono zéb uwaibaba si, te za 're ĩpawaptob za'ra wa'aba mo, ĩsimarĩ'õ norĩ hã. Tanei õ di, wa hã. Ai'rata 're ĩ̱nhamra u'âsi aba mono õ di za oto. ");
INSERT INTO xavNT_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Pi'õ hã ma tô ĩ'uwaibaba tô ĩ̱ma 'manha, ĩwẽ hã. Ã hã ĩ̱dâ'â wana ré, ma tô ãma ĩ̱hâiba zadaze, da te ĩré ĩ̱nherẽzéb u. ");
INSERT INTO xavNT_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Tô sena, wa ãne aima waihu'u za'ra wa'wa. Daro mono bâ te za ĩ̱wasu'uwẽ na da te 're dapo're pu'u za'ra. Tawamhã pi'õ hã te te ĩ̱ma ĩ'manharĩ wẽ zém na zama, te za da te dasima 're wasu'u u'âsi za'ra, ãma 're dasipo're pu'u za'ra mono da. — Ãne ma tô Zezusi hã tãma waihu'u za'ra, ãma ĩwẽ'õ'wa norĩ ma. ");
INSERT INTO xavNT_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Tawamhã Zudasi Icarizoti hã te mo, sasedoti ĩpire norĩ u. Aibâ 12 na Zezusihi siré 're ĩnomro mono norĩ siré 're ĩmorĩ, Zudasi hã. Zezusihi ãma te te tãma ãma roti za'ra da, te ĩtẽme timorĩ za'ra, te te tãma ãma rowairébé za'ra da, Zezusi za te te tãma ĩhâiba nhomri za'ra zém na hã. ");
INSERT INTO xavNT_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Tawamhã Zudasihi mreme te te wapari za'ra wamhã, tãma rowẽ uptabi za'ra di. Taha wa, ma tô rob'uiprazém na tãma ropisutu za'ra, te te tãma wa'âbâ za'ra da. Tawamhã Zudasi hã te oto sima rosa'rata, nimahã bâtâ na te te dama ĩhâiba nhomri da hã. ");
INSERT INTO xavNT_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Tawamhã bâdâ ma tô oto ĩwa waptãrã, ĩ'u'ẽtẽ duptoi'õ, da te ĩhurizéb da hã. Ã bâtâ na, ĩmorĩ'rata na zudezu norĩ hã te za pone'ẽrebâ 'ra hã te te sima 're simro, tisa te te ãma ĩhurizéb da hã, Pascowa na dato nhisi na hã. Tawamhã Zezusihi siré 're ĩnomro mono norĩ hã, te ãne siwi sadanha: — E momo ma tô asima ĩwẽ, asô ĩwa'manhipizéb da hã, Pascowa na dato nhisi na ĩwasaihurizéb da hã. — Ãne te siwi sadanha. ");
INSERT INTO xavNT_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Tawamhã Zezusi hã ma tô tisiré 're ĩnomro mono norĩ hã 'mazatõrĩ zahuré. Ãne ma tô tãma rob'ru zahuré: — 'Ri ahâ u, ane wa'aba. Tame te za aibâ hã ĩsõpẽtẽ 'wa, piza'a te te ĩ'âri hã, â ré. Tawamhã ĩsarina te za ane wa'wa, 'ri tẽme. ");
INSERT INTO xavNT_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Aibâ hã nimomo sébré wamhã, te za 'ri tede'wa hã ĩsadanharĩ 'wa: “Rowahutu'wa hã te tinha: E ma niwĩ 'ri 're wa'wa hã, ĩ̱siré 're ĩnomro mono norĩ me, ĩwa ĩwasaihurizéb da hã, Pascowa na dato nhisi na hã.” ");
INSERT INTO xavNT_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Tawamhã 'ri tede'wa hã, hâimo 'ri 're wa'wa za'ẽne hã te za aima 'mazabui wa'wa. Tame te uburé ĩwa romhaimasa wedeza hã, danhamrazé hã. Tame te za wazô ĩrobza'ra pese 'wa. — Ãne ma tãma waihu'u zahuré. ");
INSERT INTO xavNT_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Tawamhã te oto tineb zahuré, 'ri ahâ u. Tamomo simasisi wamhã, Zezusi te te tãma ĩwaihu'u zahuré zéb uwaibaba, ma tô sabu zahuré. Tawamhã tinhipi ma tô 'manharĩ zahuré, Pascowa na dato nhisi na da hã. ");
INSERT INTO xavNT_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Tawamhã ma'rã wi, ma tô aihutu Zezusi norĩ hã 'ri tẽme, aibâ 12 na ĩhâiba za'ra norĩ me. ");
INSERT INTO xavNT_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Tawamhã sai ma, si'ubumroi ré, ma tô Zezusi hã tãma waihu'u sirõmo za'ra, ãne: — Tô sena, wa aima waihu'u sirõmo za'ra wa'wa. A norĩ wa'wa hã ĩ̱siré asaihuri aba nherẽ, misire te za dama ĩ̱'maihâiba nhomri 'wa. ");
INSERT INTO xavNT_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Tawamhã ãne te te sina wapari za'ra wamhã, ma tô tiwi tirobzei'õ za'ra. Taha wa, ma tô siparabâsi si'mahârâ za'ra: — E wa hã. ");
INSERT INTO xavNT_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Tawamhã Zezusi asa ma tãma waihu'u za'ra: — Misire te za tô dama ĩ̱'maihâiba nhomri 'wa. Ĩ'u'ẽne hã ĩ̱siré piza'a 're te te ĩdi hã, te za dama ĩ̱hâiba nho. ");
INSERT INTO xavNT_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Wa hã ti'ai ãma dasiré ĩ̱podo hã duréihã ma tô ĩ̱dâ'âzém na rob'ui'éré sirõmo za'ra ĩbaihâ na, 'Re ĩhâimana u'âsi mono zadawa wasu'u'wa norĩ hã. Ĩ̱'ãma rob'ui'érézéb zarina wa za tô mo, ĩ̱dâ'âzéb u. Tane nherẽ, aibâ ma, tãma 're ropipa uptabi mono di za, za te te dama ĩ̱hâiba nhomri'wai ma hã. 'Re ĩhâimana u'âsi mono, za te te azâri wamhã, te za sima rosa'rata, ãne: “Ĩ̱poto õ 'wa'âhã, aré wẽ di, ãne na hã te aré 're robzépata mono õ wa.” Ãne te za 'râwi si'ãma rosa'rata, za dama ĩ̱hâiba nhomri'wa hã. — Ãne ma tô tãma waihu'u za'ra, te te waihu'u sirõmo za'ra da. ");
INSERT INTO xavNT_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Tawamhã saihuri ré, ma tô ti'â, ĩ'u'ẽne hã. 'Re ĩhâimana u'âsi mono ãma te tiwata, sõpru wa. Taha pari, ma tô te te wẽ'ẽ, ĩ'u'ẽne hã. Te te wẽ'ẽi mono parimhã, tisiré 're ĩnomro mono norĩ ma, ma tô te te sõmri. Ãne ma tãma sina waihu'u za'ra: — Ã, ĩ'u'ẽne hã huri aba. Ã hã ĩ̱hâiba, te wasu'u. ");
INSERT INTO xavNT_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Taha pari, ma duré ti'â hâsizé hã, uwa 'ru 'rãi wa'ui ré hã. 'Re ĩhâimana u'âsi mono ãma te duré tiwata, sõpru wa. Taha pari, ma tô tãma sõmri za'ra, uwa 'ru 'rãi wa'ui ré hã. Tawamhã aihĩni ma âhu. ");
INSERT INTO xavNT_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Ãne ma duré tãma sina waihu'u za'ra, Zezusi hã: — Ã hã ĩ̱wapru, te wasu'u. Rob'rãi wa'u za'wari ne, te za ĩ̱wapru hã ĩ̱wi asa'wa, da'ahâ zada ĩ̱dâ'â wamhã. Ã hã ĩ̱wapru hã ĩ̱wi sisa'wari wamhã, 'Re ĩhâimana u'âsi mono hã tinhib'a'uwẽ ma, te te tãma ĩropisutuzé hã tô sena za te te tãma ãma 're ĩ'uwaimrami mono zé, te wasu'u. ");
INSERT INTO xavNT_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Tô sena wa za aima ĩ̱siwasu'u za'ra wa'wa. Ã hã rob'rãi wa'u hã te 're hâsi mono õ di za oto, a'â. 'Re ĩhâimana u'âsi mono hã za uburé da'ãma ĩsib'a'uwẽ zéb ãma si, wa za duré te 're hâsi. — Ãne ma tô tãma siwasu'u za'ra. ");
INSERT INTO xavNT_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Tawamhã Zezusi norĩ hã tinho're na te oto ãma tiwata za'ra, 'Re ĩhâimana u'âsi mono ãma. Taha pari, ma tô wairé, Oriwera na ẽtẽ 'rãihâ nhisi u si'aba'ré da. ");
INSERT INTO xavNT_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Tawamhã ãne ma Zezusi hã tisiré 're ĩnomro mono norĩ ma, waihu'u za'ra: — A norĩ wa'wa hã ĩ̱zadawa para õ nherẽ, te za aihĩni asiwi ĩ̱rẽme 'wa. Duréihã 'Re ĩhâimana u'âsi mono zadawa wasu'u'wa hã ma tô ãne na ĩ̱'ãma rob'ui'éré siro, 'Re ĩhâimana u'âsi mono mreme na hã: “Pone'ẽrebâ 'madâ'â'wa hã wa za tĩwĩ. Tawamhã pone'ẽrebâ hã te za ropé.” Ãne ĩ̱'ãma rowasu'u na rob'ui'éré, ĩbaihâ na hã. ");
INSERT INTO xavNT_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Tane nherẽ, ab're hawi apâ ĩ̱hâiwa'utu parip si, wa za aiwana ĩ̱morĩ 'wa, Darireza na danhipti'a nho'õmo nhisi u, tamomo ĩ̱nhopẽtẽ za'ra wa'aba da. ");
INSERT INTO xavNT_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Tawamhã Pedru hã te Zezusihi ma tinha: — Aihĩni za te te airẽme za'ra nherẽ, wa hã te airẽme õ di za. ");
INSERT INTO xavNT_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Tawamhã Pedruhu ma, te Zezusi hã asa tinha, ãne: — Tô sena wa za aima waihu'u. Ã barana, si'a hã tihârâ na te te sahu õ ré, te za si'ubdatõ dawi ĩ̱'udâ, aima ĩ̱za'rese õ na. — Ãne ma tô tãma waihu'u siro. ");
INSERT INTO xavNT_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Tawamhã mreme tete sina, te asa tãma tinha, Pedru hã: — Wa hã asiré ĩ̱dâ'â da nherẽ, te dawi ai'udâ õ di za. — Ãne te Zezusihi ma siwasu'u. Tawamhã uburé ĩsiré 're ĩnomro mono norĩ hã ma tô õhõ na si tãma siwasu'u za'ra, za te te dawi ĩ'udâ za'ra õ na hã. ");
INSERT INTO xavNT_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Tawamhã Zezusi norĩ hã ma tô aihutu, Zésemani na rob're nhisi u. Sihutu wamhã, ãne te tãma nharĩ za'ra: — Ãme ĩ̱zô asimroi wa'aba. Wa hã wa za a'â asiti ĩmorĩ 'wa, romnhiwasi Ĩ̱mama ma, ĩ̱mreme da. ");
INSERT INTO xavNT_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Tawamhã Pedru norĩ hã te siré saprõni za'ra, Ti'adu norĩ hã, Zuwãhã me. Tawamhã te te sina rosa'rata pese wamhã, sina pẽ'ẽzé uptabi di. ");
INSERT INTO xavNT_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Taha wa, Pedru norĩ ma, ma ãne sina tãma rowaihu'u za'ra: — Ĩ̱pẽ'ẽzé hã sa'ẽtẽ na te ĩ̱ma tihâiba. Ĩ̱pẽ'ẽzé uptabi wa, wa aré dârâ. Ãme a'â asimroi wa'aba ĩ̱'rata, asõtõ za'ra wa'aba ãna. Asõpré u'âsi aba. — Ãne ma tô tãma waihu'u za'ra. ");
INSERT INTO xavNT_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Tawamhã romhâ prã na te ĩsiti timorĩ za'ra. Tawamhã hi'rãtitõ ma tô nhamra. Sãmra wamhã, ma tô aiwẽ'ẽ, ti'ai u. Tawamhã Timama wi, te rowaptẽ, robzépada hã te te tãma ba'a da. ");
INSERT INTO xavNT_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Ãne ma tô Timama wi rowaptẽ: — Ĩ̱mama, uburé marĩ hã aima waihu'u pese di. Taha wa, ma'ãpé robzépada hã ĩ̱ma ba'a za, te robzépata za'ẽtẽ tõ da. Tane nherẽ, ãne aima ĩ̱siwasu'uzéb uwaibaba, te ĩ̱sina uwaimrami da, wa hã te ĩ̱sima ĩwẽzém na ĩ̱ma pisutu õ di za. A hã ĩ̱ma ĩwẽzéb uwaibaba si, te ĩ̱sina uwaimrami da, te za ĩ̱ma ĩpisu. — Ãne ma tô Timama wi sina rowaptẽ. ");
INSERT INTO xavNT_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Tawamhã Timama ma, mreme pari, te apâ mo, si'ubdatõ tisiré 're ĩnomro mono norĩ u. Tawamhã sõtõ za'ra ré, ma tô siza za'ra. Taha wa, te Pedru 'mahâ, utu da: — Sima, e niha te asõ. E niha asimiza'rese rob'madâ'â waihu'u õ di, syry na. ");
INSERT INTO xavNT_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Satanasihi zada, asiptete sina 're aihâimana za'ra wa'aba mono da, asima 're wẽ za'ra wa'aba mono nherẽ, asi'uihâ na sada 're asiptete waihu'u za'ra wa'aba mono õ di. Taha wa, asimiza'rese te za ai'ubumroi wa'wa ãhãna hã, 'Re ĩhâimana u'âsi mono wi, asima rowaptẽrẽ za'ra wa'aba da, Wa'uburé nhimiwada'urizé wi, te te aipawaptob za'ra wa'aba da. — Ãne ma tô tãma waihu'u za'ra. ");
INSERT INTO xavNT_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Tawamhã Pedru norĩ nhiti, te duré apâ mo, Timama ma mreme da. Tawamhã õhõ na si, te duré Timama wi rowaptẽ. ");
INSERT INTO xavNT_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Timama ma, mreme pari, te duré apâ ĩtẽme timorĩ za'ra. Tawamhã sõtõ za'ra ré, ma duré siza za'ra. Tãma aptâ'â uptabi za'ra wa, te tinhotõ pese za'ra, sõpré waihu'u ãna. Tawamhã utu za'ra da, Zezusi te te 'mahârâ za'ra wamhã, asa te te tãma ĩwaihu'u za'ra da hã, mare di. ");
INSERT INTO xavNT_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Tawamhã ĩsiti te duré timorĩ za'ra. Taha pari, ma duré apâ sina siri. Si'ubdatõ tinem na, ma tô oto ãma sahu. Tawamhã sõtõ za'ra ré, ma tô duré apâ siza za'ra. Taha wa, te ãne 'mahârâ za'ra: — E niha bâ te zahadu asõtõ za'ra wa'wa bété. Te duré aiwa'utu za'ra wa'wa. Tô'ã oto. Bâdâ ma tô oto ĩwa waptãrã. Ti'ai ãma dasiré ĩ̱podo, te za oto ĩ̱hâiba nhomri ni, aibâ ĩwasété norĩ ma. ");
INSERT INTO xavNT_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Oto aiwahutu za'ra wa'aba, wasi'aba'ré da. Õhõta te wei oto mo, dama ĩ̱hâiba nhomri'wa da hã. — Ãne te tãma 'mahârâ za'ra. ");
INSERT INTO xavNT_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Zezusi hã te te tãma 'mahârâ za'ra ré, ma Zudasi hã ĩtẽme wi, Zezusihi siré aré 're ĩmorĩ hã. Da'ahâ uptabi na ma tô ĩsiré sô aihutu ni, sib'ézé 'wapa ré, uibroi ré zama. Sasedoti ĩpire norĩ zadawa para, duré rowahutu'wa norĩ zadawa para, duré zudezu norĩ ma, roti'wa norĩ zadawa para zama, ma tô sô aihutu ni. ");
INSERT INTO xavNT_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Zudasi hã ma tô ãne dama ĩpire norĩ ma, roti aré: — Aibâ hã te tob'rata hârâ wamhã, ta hã te za asiwi ĩ'âri 'wa. Tawamhã asiptete sina, te za asiwi ĩsaprõni 'wa. — Ãne ma tô Zudasi hã tãma waihu'u za'ra, te te siwi ĩ'âri wana ré hã. ");
INSERT INTO xavNT_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Tawamhã Zudasi hã Zezusihi u oto wisi wamhã, ãne te 'mahâ: — Rowahutu'wa. Tawamhã tob'rata hârâ na, ma tô sawi, Zezusi hã. ");
INSERT INTO xavNT_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Tawamhã ma tô oto dasiwi âri ni. ");
INSERT INTO xavNT_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Tawamhã Zezusihi siré ĩsa hã, ma tô sib'ézé 'wapa hã waze. Te te wazere wi, ma romhuri'wa hã ãma po're nhizâ, sasedoti ĩpire uptabi ma romhuri'wa hã. ");
INSERT INTO xavNT_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Tawamhã Zezusi hã sô ĩdasihutu norĩ ma, te tinha, ãne: — E wa hã danhibrob zô dapãrĩ'wa pâ, ma bété we ĩ̱zô aihutu 'wa, sib'ézé 'wapa ré, uibroi ré zama. ");
INSERT INTO xavNT_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Bâtâ sidâpâsi wa tô asõ'a za'ra wa'aba te 're da'apawapto, ĩ̱nhimirowasu'u na, 'Re ĩhâimana u'âsi mono ãma 're ĩdawata za'ra mono zé 'wawi, wa'ra 're. Zapre tameb ré asiwi ĩ̱'âri aba õ di bété. Tane nherẽ, te za tô asiwi ĩ̱'âri 'wa, ĩ̱'ãma rob'ui'érézé hã te ĩ̱sina uwaimrami hâ. — Ãne ma tãma sina waihu'u za'ra. ");
INSERT INTO xavNT_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Tawamhã ĩsiré 're ĩnomro mono norĩ hã aihĩni ma siwi tirẽ. Wara sina, ma dama ropé. ");
INSERT INTO xavNT_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Aibâ hã ĩprédupté hã, Zezusihi zarina ĩmorĩ hã ma tô ni'wam norĩ hã siwi ti'â, ĩ'ubuzém na. ");
INSERT INTO xavNT_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","Tane nherẽ, ma tô tãma rẽme za'ra, ti'ubuzé hã. Tawamhã ai'uréiwi te oto dawi wara, ĩprédupté hã. ");
INSERT INTO xavNT_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Tawamhã Zezusi hã te oto dasiwi saprõni ni, 'Re ĩhâimana u'âsi mono ma da'ãma romhuri'wa ĩpire uptabi nhorõwa u, sasedoti ĩpire uptabi nhorõwa u. Tame ĩwana ma tô si'rã'õtõ, sasedoti ĩpire norĩ hã, duré zudezu norĩ ma roti'wa norĩ hã, duré rowahutu'wa norĩ hã. ");
INSERT INTO xavNT_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Zezusi hã da te dasiwi saprõni ré, te Pedru hã romhâ na te te pibu, sasedoti ĩpire uptabi nhorõwa u. Tawamhã 'ri 'wawi wa'ra 're, ma ãzé. Sébré wamhã, ma tô nhamra unhama dawa, hâi'ro da, romhuri'wa norĩ me. ");
INSERT INTO xavNT_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","56","Tawamhã sasedoti ĩpire norĩ hã duré uburé zudezu norĩ ma roti'wa norĩ hã, te ni'wam norĩ zô tinhopré za'ra, Zezusi hã marĩ te te 're ĩ'ab'manharĩ wasété mono zém na, sadawa nhipese na te te siwi ãma hiri da, tawapsi romanu norĩ hã te te siwi wĩrĩ da. Tawamhã da'ahâ na dazadawa nhipese na, Zezusihi ãma ĩsimiroti wasété na da te ãma sa'ra za'ra nherẽ, ãma dasisaze za'ra õ di. ");
INSERT INTO xavNT_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Tawamhã ni'wam norĩ hã ma tiwahutu zahuré hâiwi, Zezusi hã sadawa nhipese newa, ĩsadawa nhipe te te ãma hiri zahuré da, ãne: ");
INSERT INTO xavNT_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","— Wa norĩ hã wa tô wasi'uihâ na ĩsimirowasu'u hã wapari ni. 'Re ĩhâimana u'âsi mono nhorõwa hã te za, u, sãmra, ẽtẽ na da te dasiwi ĩ'ri hã. Tawamhã te za, u, aimawi 'ri duré. Da te dasiwi ĩ'ri da hã, mare di. Te te 'ri ré hã, bâdâ hã si'ubdatõ te za, u, ãma ne, te te ãma romhuri ré hã. Ãne taré dama siwasu'u ré, wa tô wapari ni, wasi'uihâ na. — Ãne te Zezusi dama wasu'u zahuré, taré. ");
INSERT INTO xavNT_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Tane nherẽ, 'Re ĩhâimana u'âsi mono ma da'ãma romhuri'wa norĩ hã te te siwi sadawa pibu zahuré wamhã, aiwab õ di, te te dama ĩwasu'u zahuré zé hã. ");
INSERT INTO xavNT_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Tawamhã 'Re ĩhâimana u'âsi mono ma da'ãma romhuri'wa ĩpire uptabi hã dawa'wa ma hâiwi za, Zezusi hã uihâ na te te sadanharĩ da, ãne: — E asadawa na dama ãma wa'rãmi ãna, da te dasiwi ĩ'aiwasu'u wasété na hã. E tô ĩsarina ma tô aiwasédé hã ai'ãma hiri zahuré. E taré. — Ãne te sadanha. ");
INSERT INTO xavNT_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Tane nherẽ, te Zezusi hã ari'iwi za. Te te ãma wa'rãmi õ di, timreme na. Tawamhã 'Re ĩhâimana u'âsi mono ma da'ãma romhuri'wa ĩpire uptabi hã te duré sadanharĩ na sahu, sasedoti ĩpire uptabi hã: — E tô sena a hã, 'Re ĩhâimana u'âsi mono te te aipisudu, Danho'reptui'wa da. E tô sena 'Re ĩhâimana u'âsi mono 'ra, a hã. ");
INSERT INTO xavNT_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Tawamhã Zezusi hã asa te tãma siwasu'u oto: — Ĩhe. Wa hã, Danho'reptui'wa. Wa hã 'Re ĩhâimana u'âsi mono 'ra. A norĩ wa'wa hã aihĩni te za ĩ̱'madâ'â za'ra wa'wa, ti'ai ãma dasiré ĩ̱podo hã, 'Re ĩhâimana u'âsi mono nhimire niwĩ, 're ĩ̱nhamra mono na, ĩwaihu'u pese 'rata. Hâiwa'a na apâ we ĩ̱morĩ wamhã, te za ãne na ĩ̱'madâ'â za'ra wa'wa. — Ãne ma tô tãma siwasu'u sirõmo za'ra. ");
INSERT INTO xavNT_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Tawamhã te te sadawa 'rui wa, ma ti'uza hã hâiwazu, sasedoti ĩpire uptabi hã. Tawamhã ãne ma tô ãma da'mahâ: — Tâibâ oto. Aibâ aimawi norĩ zô, ai'maihârâ aba õ di za, Zezusi te te wama ĩwasu'u za'ra da hã, ĩwasété na. ");
INSERT INTO xavNT_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","'Re ĩhâimana u'âsi mono newa, si'uihâ na ma tô tiwaihu'u pe hã sina tihi, wasine 're hâimana mono nherẽ. Si'uihâ na ma tô timreme wasété. Ĩmreme ma tô ĩwapari za'ra wa'wa. E marĩ tawamhã, ma tô ãma ĩpisutu za'ra wa'wa. — Ãne te ãma da'mahâ. Tawamhã aihĩni ma tô sima wẽ za'ra, da te dasiwi wĩrĩ da. ");
INSERT INTO xavNT_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Tawamhã te te siwi wẽ'õ wa, ma tô nasi ni'wam norĩ hã siwi ubu upto, tizadaipro na. Zazahâ na ma duré siwi ubu ubu. Taha pari, ma tô duré nasi siwi ahâ. Ãne ré, te nasi siwi 'mahâ: — E 'wa hã ai'azâri'wa. Ma'ãpé, waihu'u. — Ãne te nasi siwi 'mahâ. 'Re ĩhâimana u'âsi mono ãma 're ĩdawata za'ra mono zé 'madâ'â'wa norĩ zama, ma tô siwi ti'â, te te nasi siwi ahâri da. ");
INSERT INTO xavNT_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Ãne ré, te zahadu Pedru hã dame nhamra, 'ri 'wawi wa'ra 're, pi'reba 'ri zahâpâ. Tawamhã tame sãmra ré, ma we pi'õ hã datẽme wi, sasedoti ĩpire uptabi ma romhuri'wa hã. ");
INSERT INTO xavNT_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Wisi wi, ma Pedru hã tisã, unhama ãma hâi'ro ré. Tawamhã te te 'madâ'â pese pari, te Pedruhu ma tinha: — A zama te duré Zezusihi siré 're aimo, Nazaré ãma 're ĩhâimana mono siré. ");
INSERT INTO xavNT_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Tawamhã Pedru te asa tãma tinha: — Tane na ĩ̱waihu'u nherẽ, õ hã ĩ̱ma sa'rese õ di. — Ãne te pi'õi wi ai'udâ, Pedru hã. Tawamhã 'ri nhi'riti u te oto mo, 'ridawa u morĩ da, dapusizéb u. Tawamhã si'a ma oto hâ. ");
INSERT INTO xavNT_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Tawamhã ma tô romhuri'wa sipi'õ hã tisã Pedru hã, 'ri nhi'riti ãma. Tawamhã ĩ'rata ĩsimasam norĩ ma, te wasu'u za'ra: — Ã hã Zezusi norĩ siré, 're ĩmorĩ. ");
INSERT INTO xavNT_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Tawamhã Pedru te duré tiwi ai'udâ. Tawamhã ãma ronomro õ ré, te duré tãma nharĩ za'ra, ĩ'rata ĩsimasa hã: — Tô sena, a hã Zezusi norĩ siré, te 're aimo. A hã tô, Darireza ãma 're ĩ'aihâimana mono. ");
INSERT INTO xavNT_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Tawamhã Pedru te asa tãma nharĩ za'ra: — Mare di. Tane na ĩ̱waihu'u nherẽ, õ hã ĩ̱ma sa'rese õ di. Tô sena te aiwi udâ za'ra wa'aba di pâ, 'Re ĩhâimana u'âsi mono te te ĩ̱'azâri pé. — Ãne te tãma sina waihu'u za'ra. ");
INSERT INTO xavNT_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Tawamhã si'a hã awa'awi ma tihârâ na sahu. Tawamhã Zezusi te te tãma ĩwaihu'uzém na, ma sina po're puru, Pedru hã. Ãne ma tô Zezusi hã aré tãma waihu'u siro: “Si'a hã tihârâ na te te sahu õ ré, te za si'ubdatõ dawi ĩ̱'udâ, ĩ̱zadawa para õ nherẽ.” Tawamhã Zezusihi mreme na sina po're pu'u wa, te oto aiwa'õ, Pedru hã. ");
INSERT INTO xavNT_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","2","Tawamhã awẽm na mararé, ma duré si'rã'õtõ, sasedoti ĩpire norĩ hã, duré zudezu norĩ ma roti'wa norĩ hã, duré 'Re ĩhâimana u'âsi mono nhimiroti 'rata na rob'ui'éré na dama rowahutu'wa norĩ hã. Zezusihi ãma te te sima roti za'ra da, ma si'rã'õtõ, dama roti'wa ĩpire norĩ me. Taha pari, ma oto siwi pawasisi Zezusi hã, Piratuhu u te te siwi saprõni da. Tawamhã ĩtẽme te te siwi ãwisi wamhã, Piratu te Zezusi sadanha: — E a hã, zudezu norĩ nhib'apito. Tawamhã Zezusi te asa tãma tinha: — Tahata ma tô tane hã tô ĩ̱'ãma ĩwaihu. — Ãne te tãma tinha. ");
INSERT INTO xavNT_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Tawamhã sasedoti ĩpire norĩ hã te Zezusihi ãma ĩwasédé hã sa'ra za'ra taré, marĩ ĩwasétére na 'Re ĩhâimana u'âsi mono ma, da'ãma romhuri'wa norĩ ĩpire za'ra hã. ");
INSERT INTO xavNT_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Taha wa, Piratu te Zezusi 'mahâ: — Marĩ ahâ na ma tô ai'ãma sa'ra za'ra ni. E asadawa na tãma ãma wa'rãmi za'ra õ di za. — Ãne te 'mahâ. ");
INSERT INTO xavNT_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Tane nherẽ, tizadawa na te te wa'rãmi õ di, Zezusi hã. Taha wa, ma tô Piratu hã ãma titob'uzu, tizadawa na te te ãma wa'rãmi õ wa. ");
INSERT INTO xavNT_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","7","Wahub sidâpâsi, ma tô apito Piratu hã misi si te te 're da'azani, dazazéb 're, 're ĩdasimasa mono norĩ hã 're dawairébé mono da, misi si. 'Re ĩhâimana u'âsi mono, tinhimihâzé te te dama ĩba'azém na dasa da te dasiwi 're ĩ'manharĩ za'ra mono zém na, ma tô te te 're da'azani, da te tiwi 're ĩwaptẽrẽ za'ra mono zéb uwaibaba. Aibâ hã dazazéb 're, te dame 're sa, Barabasi na ĩsisi hã. Romanu norĩ da, dasi'wapé watobro wamhã, te te da'mapãrĩ za'ra wa, ma tô séme ni, dazazéb 're. ");
INSERT INTO xavNT_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Tawamhã ma duré bâtâ na Piratuhu u tasi'rã'õtõ ni, da te tiwi rowaptẽrẽ za'ra da, te te 're ĩ'manharĩ wẽ mono zéb zarina, misi te te dama 'mairob'ru da, dazazém hawi da'maiwatobro da, apâ morĩ da. ");
INSERT INTO xavNT_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","10","Tawamhã Piratu te da'a'mahâ: — Zudezu norĩ, e asib'apito za'ra wa'aba ma, wa za rob'ru, apâ morĩ da. — Ãne te da'a'mahâ, Zezusihi ãma. Sasedoti ĩpire norĩ hã Zezusi te te sõ'ru za'ra wa, ma tô ĩtẽme siwi ãwisi, Piratuhu u. Ãne na ma tô Piratu hã ãma dawaihu'u. ");
INSERT INTO xavNT_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Piratu hã Zezusi hã apâ morĩ da, te te nasi ãma da'ab'mahârâ nherẽ, te sasedoti ĩpire norĩ hã nasi dawada'uri za'ra, Barabasihi si da te waptẽrẽ za'ra da, tiwi, Zezusihi upana te te wazere da. ");
INSERT INTO xavNT_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Tawamhã Piratu te duré da'ab'mahâ: — E marĩ, wa za bété aima ãma pisutu za'ra wa'wa, asib'apito na asiwi 're ĩsisi za'ra wa'aba mono ãma hã, te aima ãma ĩ'uwaimrami za'ra wa'aba zéb da hã. ");
INSERT INTO xavNT_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","— Wedepo'o nhonhi'rãmi na da te dasiwi sasõmri, dâ'â da. — Ãne te nasi sa'ẽtẽ ãma 'mahârâ za'ra ni, Piratu hã. ");
INSERT INTO xavNT_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","— E marĩ te te 're ab'manharĩ wasété mono bâ. — Ãne te ãma da'ab'mahâ, Piratu hã. Tane nherẽ, hârâ 'rãihâ na te nasi ãma 'mahârâ za'ra, Piratu hã: — Wedepo'o nhonhi'rãmi na, da te dasiwi sasõmri, dâ'â da. ");
INSERT INTO xavNT_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Tawamhã Piratu hã dama rowẽ za'ra da, ma tô da'wapéi'wa norĩ ma 'ru za'ra, Barabasihi ma si te te tãma rob'ru za'ra da, dazazém hawi watobro da, apâ 're morĩ da. Taha pari, te Zezusi tãma 'ru za'ra, da'wapéi'wa norĩ ma, powawẽ hâi waré na te te siwi 're pré'é mono da, taha pari, te te duré siwi sasõmri da, wedepo'o nhonhi'rãmi na dâ'â da oto. ");
INSERT INTO xavNT_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Tawamhã da'wapéi'wa norĩ hã ma tô Zezusi hã siwi ãwisi, Piratuhu nhorõwa u, 'ri 're wa'wa nho'õmo u. Tamemhã te oto sitẽme sisô tihârâ za'ra, uburé sitẽme si'rã'õtõ da. ");
INSERT INTO xavNT_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Tawamhã dasi'ubuzém na ma tô Zezusi hã siwi ãma hâiba ubu, ĩhâ pré na. 'Wabzéré panhipti na ma duré siwi sõpre. ");
INSERT INTO xavNT_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Tawamhã sisarina te nasi timreme na sawi za'ra, taré: — Zudezu norĩ nhib'apito, rowẽ na aihâimana. ");
INSERT INTO xavNT_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Tawamhã ĩ'rãi wi, ma tô nasi siwi ahâ, wedehu waré na. Te duré nasi siwi upto, tizadaipro na. Te duré nasi hi'rãtitõ tãma asimro, Zezusihi papara, ãma wata za'ra da newa. ");
INSERT INTO xavNT_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Tawamhã nasi ãma wa'ẽ za'ra parimhã, tisi'ubuzém na te te siwi ãma ĩhâiba ubu hã ma tô apâ tiwi wazere za'ra. Ĩ'uzazém na ma oto apâ siwi uza. Taha pari, te oto rob u siwi saprõ, wedepo'o nhonhi'rãmi na te te siwi sasõmri da, 'ri nho'õmo nhiti. ");
INSERT INTO xavNT_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Tawamhã bâdâdi na te te siwi saprõni ré, ma tô aibâ hã siwi sõpẽtẽ, Sima na ĩsisi hã, tirom hawi we ĩmorĩ hã, 'ri ahâ u. Ĩsa'ru nhisi hã, Sireni na. Sima hã Aresãdiri norĩ mama, Rupuhu me. Tawamhã da'wapéi'wa norĩ hã, Simahã ma, ma tô 'ru za'ra, wedepo'o nhonhi'rãmi hã te te tãma âri da, Zezusihi ma. ");
INSERT INTO xavNT_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Tawamhã Dodota na romnhisi u, ma tô siwi saprõ, Zezusi hã. Dodota na romnhisi hã, da'rãihi te wasu'u. ");
INSERT INTO xavNT_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Tawamhã da'wapéi'wa norĩ hã te aré tãma sõmri za'ra, uwa 'ru 'rãi wa'u ĩsé hã te te hâ'rẽne da, miha na wedepa wa'u nhisi na, ĩwazari ré hã. Tane nherẽ, te te hâ'rẽne õ di, Zezusi hã. ");
INSERT INTO xavNT_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Taha pari, ma tô oto wedepo'o nhonhi'rãmi na siwi sasõ. Te te siwi sasõmri pari, ma tô ẽtẽ zapotore ĩ'ui'éré ré hã nasi sima sãmra da'wapéi'wa norĩ hã, pibu pese na Zezusihi uza hã te te siwi waibu da. ");
INSERT INTO xavNT_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Zezusi te te siwi ĩsasõmrizém na hã, bâdâ ma tô oto tinho're za'a. ");
INSERT INTO xavNT_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Zezusihi 'rãi uwaibaba wedepo'o na rob'ui'éré hã ma siwi tété, da te dasiwi ĩwẽ'õ za'ra zém na, da te dasiwi ãma waihu'u za'ra da. Ãne ãma ĩrob'ui'éré hã: Ã hã, zudezu norĩ nhib'apito. ");
INSERT INTO xavNT_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Zezusihi siré, ma tô duré aibâ norĩ hã sasõmri zahuré ni, danhibrob zô dapãrĩ'wa norĩ hã. Zezusihi ãma te aiwa'aba zahuré ĩsimire niwĩ, duré ĩsimi'e niwĩ. ");
INSERT INTO xavNT_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Ãne ãma ĩromhâimanazé hã ma tô rob'ui'éré zarina, sina uwaimra, Zezusi hã. Ãne duréihã ãma ĩrob'ui'éré hã: “Ĩwasété norĩ zu, te za taré dasiwi wẽ'õ ni.” Ãne ãma ĩrob'ui'éré hã, ĩbaihâ na hã. ");
INSERT INTO xavNT_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","30","Tawamhã ĩwa'wai baba, da te nasi ro'rahâri za'ra sidâpâsi, te nasi ãma tawa'ẽ za'ra ni, Zezusihi ãma. Nasi ãma da'rã siwanarĩ za'ra sina, te nasi ãma wasété za'ra ni: — Oro a hã asima roti za, 'ri 'rãihâ hã sãmra da, 'Re ĩhâimana u'âsi mono ãma 're ĩdawata za'ra mono zé hã, si'ubdatõ bâdâ hã ai'ãma si'utõrĩ õ ré, duré apâ 'ri da. Ma'ãpé, asisõ'reptu na. Wedepo'o nhonhi'rãmi hawi we si'ra na, atâ'â tõ da. — Ãne te nasi ãma tiwa'ẽ za'ra. ");
INSERT INTO xavNT_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Duré sasedoti ĩpire norĩ hã te nasi ãma wa'ẽ sina, ãne sima nharĩ za'ra ãma, rowahutu'wa norĩ me: — Oro te te 're da'anho'reptui mono za, 'râwi sisõ'reptui õ di bété. ");
INSERT INTO xavNT_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Ma'ãpé, ãne ré, wedepo'o nhonhi'rãmi hawi we te te si'ra wanho'a, Danho'reptui'wa hã Izarazéhé nhihudu norĩ nhib'apito hã, wa te wasina ĩ'umnhasi za'ra zéb da hã. — Ãne ma sima ãma rowaihu'u za'ra. Tawamhã ĩsiré ĩsa'o zahuré zama, te nasi tãma nharĩ wasété zahuré, Zezusihi ma. ");
INSERT INTO xavNT_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Tawamhã ma tô ti'abzuma. Abzuma wamhã, ma tô tirobra, daro mono bâ. Bâdâ siprazéb u, te oto robra si nomro. ");
INSERT INTO xavNT_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Tawamhã si'ubdatõ bâtâ ãma, te Zezusi hã Timama hã sina 'mahâ, hârâ 'rãihâ na ãne: — Eroi, Eroi, rema sabatani. Ĩhârâzém na hã, ãma ĩsaprĩzé hã, ãne: — Ĩ̱nhib'apito, Ĩ̱nhib'apito, e marĩ da, ma tô oto ĩ̱rẽ. — Ãne ãma ĩsaprĩzé hã. ");
INSERT INTO xavNT_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Tawamhã ni'wam norĩ hã ĩ'rata ĩsimasam norĩ hã Zezusihi hârâ te te wapari za'ra wamhã, ma tô sima rowasu'u za'ra, ãne: — Õhõta wapari aba. Eriasihi zô te hâ, te te we pawaptob da. ");
INSERT INTO xavNT_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Tawamhã ni'wa hã si'aba'ré na ma tô piza're upsõzém ne hã 'mai'â, uwa 'ru 'rãi wa'u ĩsé na te te tãma ãma di'i da, Zezusihi ma, ĩwa'âbâ syry na. Tawamhã wedewaré 'rãsutu na ma tô ãma sapu'u, Zezusihi ma, te te wẽ da, te te upsõmri da. Taha pari, te ãne dama tinha: — A'â pé wanhimipari za'ra wa'aba, Eriasi we sô morĩ õ'umnhasite, wedepo'o nhonhi'rãmi hawi, te te si'ra da. — Ãne ma dama waihu'u. ");
INSERT INTO xavNT_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Tawamhã Zezusi hã hârâ 'rãihâ na te hâ, ĩrẽme ma. Taha pari, ma pẽ'ẽ hai'utõ. ");
INSERT INTO xavNT_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Zezusi hã dâ'â wi, zazahâ ĩhâpa hã 'ri 're wa'wa nhitobzé hã ma uihâ na hâihaipo'o aiwa, hâimo hawi pi'reba, 'Re ĩhâimana u'âsi mono nhorõwa ãma hã. ");
INSERT INTO xavNT_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Zezusi hã hâiwi sa'o ré, da'wapéi'wa norĩ wada'uri'wa hã ĩsõ're te za, ĩpapara, romanu hã. Tawamhã Zezusi hã ĩrẽme ma hârâ 'rãihâ na hârâ wamhã, te te wapari wamhã, ma ãma rowaihu'u: — Nare õ hã, 'Re ĩhâimana u'âsi mono 'ra. ");
INSERT INTO xavNT_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Pi'õ norĩ zama, romhâ hawi te Zezusi hã 'madâ'â za'ra. Nima norĩ nhisi hã ãne: Mariza Madarena, duré Sarome, duré Mariza, Zuzé norĩ na hã Ti'aduhu me. Ti'adu hã ĩhâiba té. ");
INSERT INTO xavNT_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Zezusi hã Darireza ãma 're morĩ ré hã, pi'õ norĩ hã ĩsiré te 're nomro. Ma tô duré marĩ na te te siwi 're pawapto. Ta norĩ siré, te duré pi'õ norĩ hã ahâ na Zeruzarẽ u ai'aba'ré, Zezusihi siré. Ta norĩ zama te romhâ hawi siwi 'madâ'â za'ra. ");
INSERT INTO xavNT_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","43","Sabadu u bâdâ 're ĩne mono u, te zudezu norĩ hã te te sima 're ropese za'ra, sabadu na hã te te 're romhuri za'ra mono õ na dâ'âsina. Tawamhã sabadu u oto hâiwahâ wa, romhuri 'rãsutuzéb ãma te Zuzé hã Piratuhu u mo. Arimateza ãma te aré 're hâimana, Zuzé hã. Zudezu norĩ ma roti'wa ĩpire, ta hã. Taha wa, te nasi si'rã'õtõ, siré dama roti'wa ĩpire za'ra norĩ me. Zuzé hã, 'Re ĩhâimana u'âsi mono da'ãma 're ĩsib'a'uwẽ mono zéb zô, te 're simipari u'âsi. Tawamhã romhuri zahârizéb u, romhuture wa, ma tô sada aptete Zuzé hã, Piratuhu u morĩ da, Zezusihi hâiba hã te te tiwi waptẽrẽ da, ab're sirõmo 're, te te sẽrẽ da. ");
INSERT INTO xavNT_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Zuzé hã, Zezusi hã ĩdâ'â na te te tãma rowasu'u wamhã, Piratu hã te ãma rosa'rata, dâ'â su'u wa. Tawamhã Piratu hã da'wapéi'wa norĩ wada'uri'wa zô te hâ, ĩdâ'âzém na te te ãma sadanharĩ da, tô sena zô. ");
INSERT INTO xavNT_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Tawamhã tô sena Zezusi hã ĩdâ'â na te te tãma rowasu'u parimhã, Zuzéhé ma, te oto Piratu hã tãma ti'ru, Zezusihi hâiba hã ab're sirõmo 're, te te sẽrẽ da. ");
INSERT INTO xavNT_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Tawamhã Zuzé hã zazahâ, ma sada uipra, ĩhâirã hã. Taha pari, Zezusihi hâiba hã ma oto si'ra, wedepo'o nhonhi'rãmi hawi. Tawamhã zazahâ ĩhâirã na ma ubu. Te te ubu pari, ma tô ab're 're tisẽ. Sa'a zahâpâ ẽtẽ wa, ab're sirõmo 're, ma tisẽ. Taha pari, te ẽtẽ tõmo wawẽ hã te te pizari, ab're te te ãma ĩré sitob da. ");
INSERT INTO xavNT_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Ãne Zezusihi hâiba te te sẽrẽ ré, ma tô pi'õ norĩ hã ãma 'madâ'â zahuré, Mariza Madarena hã Marizaha me. Ta hã Zuzéhé na. Tawamhã ma tô sabu zahuré, nimame Zuzé te te ĩsẽrẽzé hã. ");
INSERT INTO xavNT_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Tawamhã bâdâ oto sébré wamhã, tâibâ oto sabadu hã romhuri zahârizé hã zudezu norĩ te hã. Tawamhã pi'õ norĩ hã ĩwa'u zadaze hã, ma tô siwi uipra, te te siwi ãma hâiba u'ré da, Zezusi hã. Pi'õ norĩ nhisi hã Mariza Madarena, duré Sarome, duré Mariza, Ti'aduhu na hã. ");
INSERT INTO xavNT_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Tawamhã pi'õ norĩ hã mararé te ai'aba'ré, sa'a zahâpâ ab're u, bâdâ 'rãiwatobro wi, dumidu na. ");
INSERT INTO xavNT_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Bâdâdi na si'aba'réi ré, ma ãne sima waihu'u za'ra: — E 'wa hã te za ẽne hã wama sa'ré za'ra, ab're nhitobzé hã. ");
INSERT INTO xavNT_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Ab're nhitobzé hã ẽne hã tõmo wawẽ uptabi wa, ma ãne sima waihu'u za'ra. Tane nherẽ, sihutu wamhã, ẽne da te ĩsa'ré na ma tô 'madâ'â za'ra. ");
INSERT INTO xavNT_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Tawamhã ab're 're, sisisi wamhã, ma tô aibâ hã siwi sõpẽtẽ ĩprédupté hã, uza hâirã ré ĩsãmra hã. Ĩnomrozé nhimire niwĩ te nhamra. Taha wa, pi'õ norĩ hã ma tãma tipẽ'ẽwara za'ra. ");
INSERT INTO xavNT_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Tawamhã ãne te tãma nharĩ za'ra, pi'õ norĩ ma: — Ĩ̱ma aipahi za'ra wa'aba tõ. Zezusi hã Nazaré ãma aré ĩprédu hã wedepo'o nhonhi'rãmi na, da te dasiwi ĩsasõmri zô robzabu za'ra wa'aba da, te we ai'aba'réi wa'wa. Ãne na, wa tô aiwaihu'u za'ra wa'wa. Ãme hâimana õ di oto. Apâ ma tô hâiwa'udu. Ma'ãpé, ĩnomrozé hã sabu za'ra wa'aba. Robaba di. ");
INSERT INTO xavNT_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Taha wa, te za oto apâ ai'aba'réi wa'wa, Pedru norĩ ma tãma rowasu'u za'ra wa'aba da, ãne: “Zezusi hã aiwana te za, u, timorĩ 'wa, Darireza u. Tame te za, u, ĩsõpẽtẽ za'ra wa'wa, aima ĩsiwaihu'u za'ra wa'aba zéb zarina.” — Ãne ma tô pi'õ norĩ ma waihu'u za'ra. ");
INSERT INTO xavNT_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Tawamhã ma wairé ab're hawi, wara sina sisa'rei mono da. Tãma pẽ'ẽwara za'ra wa, te tirẽrẽ'ẽ za'ra. Pahi te, ni'wai ma, te te rowasu'u za'ra õ di a'â. ");
INSERT INTO xavNT_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Zezusi hã dumidu na ma tô apâ hâiwa'udu, mararé. Tawamhã ĩmorĩ'rata na ma tô Mariza Madarenahã ma, sihâi'ré. Ti'ai baba 're morĩ ré, ma tô taha ma, wa'uburé hã 7 na sãmra. ");
INSERT INTO xavNT_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Tawamhã Zezusihi siré 're ĩnomro mono norĩ u, te mo Mariza Madarena hã, te te tãma rowasu'u za'ra da. Tãma robzei'õ za'ra di. Pẽ'ẽzé uptabi za'ra wa, te aiwa'õ za'ra. Ãne ré, ma tô ĩtẽme tiwisi za'ra, Mariza Madarena hã. ");
INSERT INTO xavNT_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Tawamhã Zezusi apâ 're ĩmorĩ na, duré ĩtẽme ĩwisizém na hã te te tãma rowasu'u za'ra wamhã, te te ãma saze za'ra õ di. ");
INSERT INTO xavNT_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Taha pari, ma duré Zezusi hã aimawi tihâiba na sihâi'ré, maparane tizazei'wa norĩ ma. Rom na bâdâdi na neb ré, ma tô ĩtẽme tiwisi zahuré. ");
INSERT INTO xavNT_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Tawamhã apâ te tineb zahuré, Zezusihi siré 're ĩnomro mono norĩ ma, te te rowasu'u zahuré da. Tane nherẽ, te te tãma rowasu'u za'ra nherẽ, te te ãma saze za'ra õ di duré. ");
INSERT INTO xavNT_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Tawamhã Zezusi hã tisiré 're ĩnomro mono norĩ u ma duré wi, sai ma, si'ubumroi ré, 11 na ĩhâiba za'ra u. Tawamhã timreme ma tô tãma pẽtẽ za'ra, siwi ĩsabui'wa norĩ nhimirowasu'u hã te te saze za'ra õ wa, apâ ĩhâiwa'utuzém na da te ĩwasu'u na hã. ");
INSERT INTO xavNT_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Taha wa, te ãne oto tãma nharĩ za'ra: — Daro mono bâ te za oto 're ĩropéi wa'aba mo, a'uwẽ mono bâ, ĩ̱wasu'uwẽ na 're dapo're pu'u za'ra wa'aba mono da. ");
INSERT INTO xavNT_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Tawamhã Danho'reptui'wa na da te dasina 're ĩ̱'umnhasi za'ra mono wa, â dawabzuri hã da te 're 'manharĩ za'ra mono wamhã, te za te te 're da'anho'reptu, 'Re ĩhâimana u'âsi mono hã. Da te dasina 're ĩ̱'umnhasi za'ra mono õ wamhã, 'Re ĩhâimana u'âsi mono te za te te 're da'awẽ'õ. ");
INSERT INTO xavNT_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Da te dasina 're ĩ̱'umnhasi za'ra mono wamhã, wa za te 're da'apawapto, ĩ̱waihu'u pese zarina, marĩ dama ĩ'manharĩ waihu'u'õ hã te te dama 're ab'manharĩ wẽ mono da, ĩ̱wasu'u na tô sena na da te 're waihu'u za'ra mono da. Ãne te za te te 're dapawaptob za'ra. Ĩ̱nhisi na te za wa'uburé hã te te dama 're sãmra za'ra, ĩ̱zadawa para. Duré 're ĩdasisadaihu'u za'ra mono õ na zama, te za 're mreme zusi. ");
INSERT INTO xavNT_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Sa'rese ãna, wahi hã te te 're waibui mono nherẽ, duré dapãrĩzé hã te te 're âhuri mono nherẽ, tãma 're rowẽ za'ra mono di za. Duré, tinhib'rata na ĩhâzé ré norĩ hã te te 're upi za'ra mono wamhã, te za 're séptâ'â za'ra, ĩhâzé ré norĩ hã. — Ãne ma tô tãma waihu'u sirõmo za'ra, tisiré 're ĩnomro mono norĩ ma. ");
INSERT INTO xavNT_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Wanhib'apito Zezusi hã te te tãma rowasu'u za'ra pari, ma tô hâiwa u tiwi âri za'ra, 'Re ĩhâimana u'âsi mono nhimire niwĩ oto 're sãmra mono da, pire uptabi na. ");
INSERT INTO xavNT_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Tawamhã ĩsiré 're ĩnomro mono norĩ hã ĩsadawa para, ma tô te te ropé daro mono bâ, ĩwasu'uwẽ na te te 're dapo're pu'u za'ra mono da. Wanhib'apito hã ma tô te te 're pawaptob za'ra, ĩsimi'manharĩ waihu'u pese zarina, marĩ dama ĩ'manharĩ waihu'u'õ hã te te dama 're ab'manharĩ wẽ mono da, ĩsimirowasu'u za'ra na tô sena uptabi, da te 're waihu'u za'ra mono da.");
INSERT INTO xavNT_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","4","Tezopiru, asawi di. Ãhãna wa za aima rob'ui'éré, Wanhib'apito Zezu Cristuhu wasu'u na, sena na waihu'u da. Ni'wam norĩ hã ma tô Zezusihi wasu'u na te te 're dapo're pu'u na'rata za'ra, titõmo na te te ãma 're ĩ'madâ'â za'ra mono norĩ hã. Ta norĩ hã ma tô ĩwasu'u na'rata hawi wama rowasu'u za'ra. Tawamhã ĩsimirowasu'u zarina, ma tô ĩwasu'u na ãma rob'ui'éré za'ra ni, da'ahâ na. Taha wa, wa hã wa duré ĩ̱sima wẽ, te ãma aima rob'ui'éré da. Ĩwasu'u na'rata hawi, wa tô rosa'rata pese, te waihu'u pese da. Ni'wam norĩ hã ma tô ĩwasu'u hã aima wasu'u za'ra. Taha wa, wa tô ĩ̱sima wẽ, upsãtã pese na te aima rowasu'u da, rob'ui'éré na, Zezusihi wasu'u hã sena na waihu'u da. ");
INSERT INTO xavNT_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Erodi hã zudezu norĩ nhipti'ai 're, apito na 're hâimana mono ré hã, aibâ hã te 're hâimana, Zacaria na ĩsisi hã. Zacaria hã sasedoti, 'Re ĩhâimana u'âsi mono ma da'ãma romhuri'wa. Abizaha nhihudu norĩ me, te te tãma 're romhuri za'ra. Ĩmro nhisi hã, Izabé na ĩsisi hã. Izabéhé hi'rada hã, Arã na ĩsisi hã. 'Re ĩhâimana u'âsi mono ma, da'ãma romhuri'wa, Arã hã. ");
INSERT INTO xavNT_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Zacaria norĩ hã ma tô 're hâimana wẽ zahuré. 'Re ĩhâimana u'âsi mono nhimiroti te te 're 'madâ'â pese zahuré. Taha wa, tãma wẽ zahuré di, 'Re ĩhâimana u'âsi mono ma. ");
INSERT INTO xavNT_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Tane nherẽ, 'ra zahuré õ di. Izabé hã 'ra waihu'u õ wa, ma tô 'ra ãna si'ĩhi zahuré. ");
INSERT INTO xavNT_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Tawamhã nimahã bâtâ na ma tô Zacaria hã tinhimiromhuri hã 'manha, sasedoti te te 're ĩ'manharĩ za'ra mono hã, 'Re ĩhâimana u'âsi mono ãma 're ĩdawata za'ra mono zéb 'remhã. Taha te hã bâtâ wa, ma tô romhuri 'manha. ");
INSERT INTO xavNT_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Ĩsiré norĩ hã ma tô tãma pisutu za'ra, 'ri para u sébré da, te te tãma romhuri da. Taha wa, 'ri para u, ma tô oto ãzé Zacaria hã, wedewati ĩsadaze hã wedeza ne na te te tãma zata da. ");
INSERT INTO xavNT_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","11","Tawamhã te te tãma zata ré, te ai'ubumro ni rowi, 'Re ĩhâimana u'âsi mono ma, mreme zusi da. Ãne ré, hâiwa hawimhã uburé Danhib'apito ma romhuri'wa hã ma tô tãma sihâi'ré. Wedeza nhimire niwĩ te za, ĩsõ're uwaibaba, ro'o ré, wedewati ĩsadaze hã. ");
INSERT INTO xavNT_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Tawamhã te te sãmri wamhã, ma tãma pẽ'ẽwara, Zacaria hã. Te te rosa'rata waihu'u õ di. ");
INSERT INTO xavNT_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Tawamhã te tãma tinha: — Zacaria, aipahi tõ. 'Re ĩhâimana u'âsi mono, ma tô aimreme hã wapa, tiwi ĩrowaptẽrẽzém na hã. Aimro te za oto ti'ra. Waptã'ã wapsi, ai'ra te za ĩsisi, Zuwã na. ");
INSERT INTO xavNT_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Ai'ra hã aima waptã'ã aba wapsi, aima rowẽ wa'aba di za. Da'ahâ norĩ ma zama, rowẽ za'ra di za. ");
INSERT INTO xavNT_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","16","Prédu wapsi, ĩsimiroti hã pire di za. Taha wa, te za ĩsimiroti pire na waihu'u, 'Re ĩhâimana u'âsi mono hã. Uwa 'rãi wa'u ĩsé hã te te 're hâsi mono õ di za. Duré âzé hã te te 're hâsi mono õ di za. Waptã'ã hawim haré, te za 'Re ĩhâimana u'âsi mono pẽ'ẽzani ré 're mo. Taha si, te za te te 're wapari pese. Taha wa, te za tisiré Izarazéhé nhihudu norĩ hã te te 're apawapto tinhimiroti na, 'Re ĩhâimana u'âsi mono nhimiroti si, da te 're 'madâ'â pese za'ra mono da oto. ");
INSERT INTO xavNT_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","'Re ĩhâimana u'âsi mono zadawa wasu'u'wa, te za 're mo. Wahi'rada Eriasihi ne, te za 're mo, mreme pire na, duré waihu'u pese na. Tawamhã ai'ra nhimiroti zarina, te za damama norĩ hã ti'ra norĩ hã te te 're sawi pese za'ra. Duré dapo're õ wamhã, te za apâ 're dasipizari za'ra, 're ĩdanomro wẽ mono zarina, oto 're danomro mono da. Ãne wamhã, te za danhimiza'rese sô 're danhimipari za'ra, Danhib'apito zô. — Ãne ma tô ĩwana ré ãma tãma rowasu'u, Zacariaha ma, hâiwa hawi romhuri'wa hã. ");
INSERT INTO xavNT_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Tawamhã Zacaria asa ma tô sadanha, romhuri'wa hã: — E niha wa za asaze, tane na hã. Wa hã ĩ̱hi uptabire oto. Duré ĩ̱mro zama, ĩhi uptabire. — Ãne hâiwa hawi romhuri'wai ma, te tinha. ");
INSERT INTO xavNT_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Tawamhã te duré asa tãma tinha: — Wa hã Dabrizé, 'Re ĩhâimana u'âsi mono ma romhuri'wa. Ta hã ma tô we ĩ̱zatõ, rowasu'uwẽ hã te aima wasu'u da. ");
INSERT INTO xavNT_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Tazahã, ĩ̱nhimirowasu'u na ĩ̱zazei õ di, sena na. Taha wa, te za aima rob'manha 'Re ĩhâimana u'âsi mono hã, aimreme õ na, ai'ra waptã'ãzéb u. Ai'ra waptã'ã wapsi, te za apâ aima tisõ, aimreme hã. — Ãne ma tô tãma rowasu'u, Dabrizé hã. ");
INSERT INTO xavNT_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Zahadu te rowi sô mapari za'ra ni, Zacariaha zô. Sô danhimipari za'ra wamhã, ma ãma tatob'uzu za'ra ni, sô ĩrowaptâ'âzém na hã, 'ri para. ");
INSERT INTO xavNT_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Tawamhã Zacaria hã ma tô oto datẽme watobro, rob u. Datẽme watobro wamhã, mreme waihu'u õ di. Taha wa, te dasima nharĩ za'ra ni: — Marĩ hã ma tô sõ'awi sabu Zacaria hã, danhotõ 'rowi, da te 're ĩrosawẽrẽ za'ra mono ne hã. — Ãne te dasima nharĩ za'ra ni. Tawamhã, mreme waihu'u õ wa, ma tô tinhiptõmo na si dama rowasu'u. ");
INSERT INTO xavNT_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Tawamhã Zacaria, te te romhuri pari, te apâ mo, ãma 're ĩdawata za'ra mono zém hawi, tinhorõwa u. ");
INSERT INTO xavNT_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Syry na ãma ronomro wi, ma tô tiwasã, Izabé hã. Tawamhã a'amo ĩmrotõ na ãma ĩsi'utõrĩzém na hã watobro õ di, tinhorõwa hawimhã. ");
INSERT INTO xavNT_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Tawamhã te sima tinha: — Ãhãna ma tô Wanhib'apito hã ĩ̱pawapto. Da te oto ĩ̱ma 're nharĩ za'ra mono õ di za, ĩ̱'ra õ na hã. — Ãne te tinha, Izabé hã. ");
INSERT INTO xavNT_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","27","Tawamhã a'amo ĩmropâ hã Izabéhé ãma oto si'utõrĩ wamhã, ĩwasã na hã, 'Re ĩhâimana u'âsi mono hã ma we duré satõ ti'ai u, Dabrizé hã, hâiwa ãma tãma ĩromhuri'wa hã. Nazaré u, ma we satõ, pi'õi ubuni ma, te te sadawa wasu'u da. Darireza na danhipti'a nho'õmo nhisi ãma, Nazaré hã. Pi'õ nhisi hã, Mariza na ĩsisi hã. Ta hã, azarudu. Niwapsi, Zuzéhé me te za sina timro zahuré, apito Dawihi nhihudu me. ");
INSERT INTO xavNT_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Tawamhã ma tô we ĩtẽme wi, Marizaha u, hâiwa ãma romhuri'wa hã. Ĩtẽme wisi wamhã, te tãma tinha: — Mariza, rowẽ na 're aihâimana mono. 'Re ĩhâimana u'âsi mono, ma tô aiwẽsã, Wanhib'apito hã. Taha wa, te za aima tinhopru, ĩwẽ uptabi na. — Ãne te tãma rowasu'u, Marizaha ma. ");
INSERT INTO xavNT_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Tane nherẽ, Mariza hã te te waihu'u õ di, ĩsimirowasu'u hã. Taha wa, tipẽ'ẽ na, te sima tinha: — E niha bâ, te õne ĩ̱ma tinha. — Ãne te sima tinha. ");
INSERT INTO xavNT_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Tawamhã te duré tãma tinha, hâiwa hawi romhuri'wa hã: — Mariza, aipahi tõ. 'Re aimorĩ wẽ na, ma tô 'Re ĩhâimana u'âsi mono hã aiwẽsã. ");
INSERT INTO xavNT_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Taha wa, te za aiwasã. Ai'ra te za aibâ na aima podo. Ai'ra hã poto wapsi, Zezusi na te za ĩsisi. ");
INSERT INTO xavNT_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Ai'ra hã prédu wapsi, dama pire na te za 're mo. 'Re ĩhâimana u'âsi mono 'ra na ĩsisi hã za, danhipai u ĩpire uptabi 'ra na. Ta hã uburé Danhib'apito uptabi hã te za ti'ra ma pisutu, tihi'rata ne, si'apito da, Dawihi ne. ");
INSERT INTO xavNT_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Danhib'apito 're morĩ wa, Zacoho nhihudu sidâpâsi, te za Ĩsib'apito 're sãmra. Õne u'âsi. Te za ãma 're sib'a'uwẽ u'âsi za'ra. — Ãne te Marizaha ma rowasu'u, hâiwa hawi romhuri'wa hã. ");
INSERT INTO xavNT_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Tawamhã asa te tãma tinha, Mariza hã: — E niha wa za ĩ̱'ra, aibâ te sa'rese õ nherẽ. — Ãne te tãma tinha. ");
INSERT INTO xavNT_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Tawamhã asa te tãma tinha: — 'Re ĩhâimana u'âsi mono, te za we aipawapto, tiwaihu'u pese na aiwasã da, ai'ra da. Taha da, te za Tipẽ'ẽzani hã we atẽme satõ. Taha wa, 'Re ĩhâimana u'âsi mono 'ra na, te za ai'ra hã da te 're sisi za'ra. — Ãne te Marizaha ma rowasu'u. ");
INSERT INTO xavNT_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Te duré tãma tinha: — Ana wapté hã wa za duré aima wasu'u, Izabé hã. Si'ĩhi uptabi nherẽ, ma tô tiwasã. 'Ra waihu'u õ na, ma tô da te 're wasu'u za'ra. Tazahã, wasã ré sãmra ré hã, 6 na ma tô oto ãma ai'utõ, a'amo hã. ");
INSERT INTO xavNT_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Uburé marĩ hã tãma waihu'u pese di, 'Re ĩhâimana u'âsi mono ma. Taha wa, ma tô tiwasã. — Ãne ma tô tãma rowasu'u. ");
INSERT INTO xavNT_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Tawamhã Mariza te asa tãma tinha: — Wa hã, Wanhib'apito ma, romhuri'wa. Ta hã te te ĩ̱ma pisutu wa, wa tô ĩ̱sima wẽ, ĩmreme hã. — Ãne Mariza te tãma tinha. Tawamhã te te tãma rowasu'u pari, ma tô mo apâ hâiwa u, romhuri'wa hã. ");
INSERT INTO xavNT_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","40","Tawamhã bâdâ umro na ãma si'utõrĩ pari, ma tô Mariza hã sima robza'ra pese, tina waptéb u morĩ da, Izabéhé u. Tawamhã Zudeza na danhipti'a nho'õmo nhisi u, te ĩtẽme mo si'aba'ré na, 'ri ahâ u, sa'a u. Tawamhã ma tô oto wi, Zacariaha nhorõwa u. 'Ri para u sébré wamhã, ma tô tina wapté hã sawi. ");
INSERT INTO xavNT_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Tawamhã Izabé hã Mariza te te ĩsawizém na te te wapari wamhã, ma tô ĩwasã hã 're rési, ĩdi'i 'remhã. Tawamhã ma tô ti'ra wapté ma rowasu'u, Izabé hã. ");
INSERT INTO xavNT_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","'Re ĩhâimana u'âsi mono pẽ'ẽzani te te tãma ĩwaihu'uzéb zarina, rowẽ te, te mreme 'rãihâ na tãma rowasu'u, ãne: — A hã pi'õ norĩ nhipai u, ma tô aima tinhopru, ĩwẽ uptabi na, 'Re ĩhâimana u'âsi mono hã. Ai'ra ma zama, te za tinhopru, ĩwẽ uptabi na, ai'uté norĩ nhipai u. ");
INSERT INTO xavNT_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Duré a hã Wanhib'apito na te za 're aimo. Taha wa, ĩ̱ma aipire di. Tane nherẽ, asisawi õ di, we ĩ̱tẽme aimorĩ tõ da. Taha wa, ĩ̱ma rowẽ di. ");
INSERT INTO xavNT_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Aimreme na ĩ̱zawi wi, ma tô ĩ̱'ra hã 're rési, ĩ̱di'i 'remhã, rowẽ te. ");
INSERT INTO xavNT_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","A hã aima rowẽ di. E tihai wa. Wanhib'apito hã te te aima ĩnharĩzém na ãma sazei wa, sena na. Taha wa, aima rowẽ di. — Ãne te ti'ra wapté ma tinha, Izabé hã. ");
INSERT INTO xavNT_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Tawamhã Mariza te tinha: ");
INSERT INTO xavNT_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","49","— Wanhib'apito ãma, wa za 're ĩ̱wata u'âsi. 'Re ĩhâimana u'âsi mono hã Ĩ̱nho'reptui'wa, te 're mo. Tãma ĩ̱wapure nherẽ, ma tô ĩ̱'ãma rosa'rata. Taha wa, ĩ̱pẽ'ẽ na, wa 're ĩ̱to. 'Re ĩhâimana u'âsi mono hã ĩwaihu'u pe hã, ĩwẽ uptabi hã ĩwẽ na ma tô ĩ̱ma 'manha. Taha wa, ĩwẽ na te te ĩ̱ma ĩ'manharĩ wẽ na, te za dasima da te 're ĩ̱wasu'u u'âsi. ");
INSERT INTO xavNT_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Ĩmreme, da te 're 'madâ'â pese za'ra mono wamhã, te za da'ãma 're pẽ'ẽzé u'âsi. Õne u'âsi. ");
INSERT INTO xavNT_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Tiwaihu'u pese na 'râwi sina 're ĩwata za'ra mono norĩ hã te za te te wama 're awano'õ. ");
INSERT INTO xavNT_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Apito norĩ hã te za roti hawi te te 're azani, wapure na oto 're nomro mono da. Tipire na sina 're ĩwata za'ra mono õ norĩ si te za te te 're apisutu, pire na oto 're nomro mono da. ");
INSERT INTO xavNT_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Mra, da te 're sépata za'ra mono wamhã, sa'ẽtẽ na te za dama 're sõpru. Ĩsibrob ahâ norĩ hã te za sisiti te te 're azatõrĩ, ubana oto 're nomro mono da. ");
INSERT INTO xavNT_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","55","Duréihã wahi'rata norĩ ma, ma tô ropisutu, ĩsihudu sidâpâsi te te 're apawapto mono da. Taha wa, ma tô wa norĩ hã Izarazéhé nhihudu norĩ hã te te 're wa'apawapto, wa te tãma 're ĩromhuri za'ra mono hã. Simizawi pese wa, ma tô Abra'ãhã ãma 're pẽ'ẽzé u'âsi. Tiwi simani õ di. Duré ĩsihudu sidâpâsi, ma tô ãma 're pẽ'ẽzé u'âsi za'ra. Tiwi simani za'ra õ di. Ãne 'Re ĩhâimana u'âsi mono ãma te tiwata, Mariza hã. ");
INSERT INTO xavNT_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Tawamhã Izabéhé 'rata sãmra ré, ma tô a'amo hã si'ubdatõ ãma ai'utõ. Taha pari, te apâ mo Mariza hã, tinhorõwa u. ");
INSERT INTO xavNT_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Tawamhã Izabéhé ãma ĩ'ra hã ĩsépu'uzé hã ma tô bâdâ hã ĩwa waptãrã. Tawamhã ma tô tãma podo, 'watébrémi na. ");
INSERT INTO xavNT_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Poto wamhã, ĩ'rata 're ĩsõrõwa za'ra mono norĩ hã ma tô ĩwasu'u hã wapari za'ra. Ĩsisãnawã norĩ zama, ma tô ĩwasu'u hã wapari za'ra, 'Re ĩhâimana u'âsi mono hã tiwẽ hã te te tãma ĩsõmri na hã. Taha wa, te uburé ĩsabâdâ 're to za'ra. ");
INSERT INTO xavNT_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Tawamhã bâdâ hã ĩwaptã'ãzém na hã, 7 na ma tô ãma ai'utõ. Taha wa, awẽm na ma oto sihâiwata nhizâri ni. 'Re ĩhâimana u'âsi mono nhib'a'uwẽ 're morĩ da, ĩpibui pese zéb da, ma sihâiwata nhizâri ni. Tawamhã ĩmama nhisi na, te aré sisi za'ra ai'uté hã, Zacaria na, ĩsisãnawã norĩ hã. ");
INSERT INTO xavNT_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Tazahã, ĩna hã te tãma nharĩ za'ra: — Maze di. Zuwã na, te za tinhisi. — Ãne te tãma nharĩ za'ra. ");
INSERT INTO xavNT_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Tawamhã asa te tãma nharĩ za'ra: — E mahãta ĩmama sisãnawã, ãma ĩsisizéb da hã. E Zuwã na, ma tô ti'manhisi. Mare di. Ĩmama sisãnawã hã ãma 'manhisi õ di, Zuwã na. — Ãne te ĩna ma nharĩ za'ra ni. ");
INSERT INTO xavNT_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Tawamhã Zacaria te sadanharĩ za'ra, ĩ'ra nhisi na. ");
INSERT INTO xavNT_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Tawamhã tinhiptõmo na, ma tô dama tinha, ĩbaihâ te te tãma âri za'ra da, ti'ra nhisi na te te rob'ui'éré da. Tawamhã wedepo'ore hã ma tô tãma âri ni, ĩsyryre hã. Tawamhã ãne ma tô rob'ui'éré: “Zuwã na ĩsisi hã za.” Ãne ma tô tãma waihu'u za'ra. Tawamhã ĩsisãnawã norĩ hã te ãma titob'uzu za'ra, tinhisi na te te sisi õ wa. ");
INSERT INTO xavNT_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Tawamhã ti'ra nhisi na te te rob'ui'éré pari, ma oto mreme watobro apâ, Zacaria hã. Tawamhã 'Re ĩhâimana u'âsi mono ãma te tiwata, sõpru wa. ");
INSERT INTO xavNT_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Tawamhã 'ri 'rata 're ĩsi'ubumroi mono norĩ hã ĩwasu'u te te wapari za'ra wamhã, ma tô tãma tipahi za'ra, õne hã tãma sa'rese za'ra õ wa. Tawamhã sa'a ãma, ma tô ĩwasu'u wapari za'ra ni, daro mono bâ, Zudeza na danhipti'a nho'õmo nhisi ãma. ");
INSERT INTO xavNT_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Tawamhã, da te wapari za'ra wamhã, ĩwasu'u hã wẽ wa, te ãma rosa'rata u'âsi za'ra ni. Te duré ãma tasisadanharĩ za'ra ni: — Prédu wamhã, e marĩ na te za 're hâimana, 'watébrémi hã. — Ãne te dasima nharĩ za'ra ni, ĩwẽ na te te sada 'manharĩ wa, Zuwãhã zada, 'Re ĩhâimana u'âsi mono hã. ");
INSERT INTO xavNT_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Tawamhã Zacaria hã 'Re ĩhâimana u'âsi mono pẽ'ẽzani nhimipawaptom na, ma tô mre, 'Re ĩhâimana u'âsi mono zadawa wasu'u na, ãne: ");
INSERT INTO xavNT_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","— 'Re ĩhâimana u'âsi mono hã wẽ di, Wanhib'apito hã. Wẽ wa, wa za ãma 're wawata u'âsi za'ra. Wa norĩ hã Izarazéhé nhihudu, te za we oto wapawaptob za'ra, wanhitob'ru nhimiwada'uri hã wama wapu za'ra da, rowẽ na 're wasi'ubumroi mono da. ");
INSERT INTO xavNT_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Ma tô we oto watẽme satõ ĩwaihu'u pe hã, Wanho'reptui'wa da hã, apito Dawihi nhihudu hã. Tãma ĩromhuri'wa, Dawi hã. ");
INSERT INTO xavNT_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Ãne duréihã, ma tô romhâ ré rowa'õtõ za'ra dama, 'Re ĩhâimana u'âsi mono zadawa wasu'u 'rata 'wa norĩ hã, te te sima ĩpisutu za'ra norĩ hã. Wẽ uptabi za'ra di. ");
INSERT INTO xavNT_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Wazawi'õ'wa norĩ wi, ma tô wama ãma ropisutu, 'Re ĩhâimana u'âsi mono hã, te te 're wa'anho'reptui mono da, wawẽ'õ'wa norĩ, te te 're wawada'uri tõ za'ra mono da. ");
INSERT INTO xavNT_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Te za tô te te dama 're ab'manharĩ wẽ u'âsi, wahi'rata norĩ ma, te te ĩropisutuzéb uwaibaba. Tô sena te te tãma ĩropisutuzé hã, te za te te ãma 're a'uwaimrami u'âsi. Tiwi simani õ di za. ");
INSERT INTO xavNT_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","75","Duréihã ma tô Abra'ãhã ma tinha, tô sena ĩsihudu te te 're wa'apawapto mono da, wawẽ'õ'wa norĩ wi, te te 're wa'anho'reptui mono da, wapahi ãna, wa te tãma 're romhuri za'ra mono da, duré ti'ai ãma ré, ĩsõ'a 're wanomro mono da, wawẽ uptabi na. Ãne Zacaria hã ma tô dama tinha. ");
INSERT INTO xavNT_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Te duré tinha, ti'ra ma: — 'Re ĩhâimana u'âsi mono hã, danhipai u ĩpire uptabi. A hã ĩsadawa wasu'u'wa, te za 're aimo. Ĩsadawa wasu'u'wa na, te za aiwaihu'u za'ra ni. Datẽme te za 're aimo, Wanhib'apito wana, asimiroti na 're da'apawapto mono da, Wanhib'apito zô danhimipari sina 're danomro wẽ mono da. ");
INSERT INTO xavNT_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Datẽme 're aimorĩ wamhã, te za 're ĩda'apo're pu'u mo, ãne: “'Re ĩhâimana u'âsi mono hã te za te te aima 're apari 'wa, marĩ hã 're ĩ'manharĩ wasété za'ra wa'aba mono zé hã. Ãne te za te te 're asõ'reptu za'ra wa'wa.” Ãne te za 're ĩda'apo're pu'u mo. ");
INSERT INTO xavNT_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Wahuré te tãma 're hâimana, ĩpẽ'ẽzézé hã, duré ĩsimizawi pese zé hã. Ãne 'Re ĩhâimana u'âsi mono hã, Wanhib'apito hã. Taha wa, te za oto te te 're wa'anho'reptu, rowẽ na 're wanomro mono da. Bâdâ 'rãi watobro wamhã, tâibâ oto robra hã. Tawamhã dama 're rowẽ za'ra mono di za. Tane, Wanho'reptui'wa hã te te wama 're apari mono wamhã, marĩ, wa te 're ĩ'manharĩ wasété za'ra mono zé hã, taha wa, wama 're rowẽ za'ra mono di za. ");
INSERT INTO xavNT_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Tawamhã ab're pipa te, robzei'õ u'âsi, 're wanomro mono õ di za. Te za oto te te 're wa'anhimroi wẽ, rowẽ na 're ĩwanomro mono zém na. Ãne Zacaria hã te ti'ra ma rowasu'u. ");
INSERT INTO xavNT_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Tawamhã 'watébrémi hã ma tô tiprédu. Ĩhâiba hã siptete di, prédu wamhã. Tiwasété wi siptete wamhã, 're morĩ wẽ di. A'ubuni wi, te oto 're sãmra. Bâdâ ĩwa waptã'ã wapsi, te za datẽme 're mo, te te dama 're sadawa wasu'u mono da, Izarazéhé nhihudu norĩ ma. ");
INSERT INTO xavNT_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","2","Tawamhã Zuwã hã waptã'ã wamhã, ma tô Roma ãma danhib'apito Adusitu hã dama ti'ru, uburé danhisi na, da te daza'rata za'ra da. Dahâiba te te waihu'u da, ma tô dama ti'ru, daza'ratazé hã. Daza'rui mono bâ danhib'apito uptabi, apito Adusitu hã. Tawamhã ma tô dahâiba za'rata na sãna'rata za'ra ni, Sirenizu hã, ĩsadawa para te te dama 're roti mono ré, Siriza na ti'a nhisi ãma. ");
INSERT INTO xavNT_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Taha wa, dahi'rata za'ru u, ma tô 're danomro daro mono bâ, danhisi na da te 're daza'rata za'ra mono da. ");
INSERT INTO xavNT_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Taha wa, Zuzé hã te mo, tihi'rata za'ru u. Apito Dawi hã ĩhi'rata wa, tihi'rata za'ru u te mo, Berẽ u. Zudeza na danhipti'a nho'õmo nhisi ãma, Berẽ hã. Nazaré hawi te mo, Berẽ u. Darireza na danhipti'a nho'õmo nhisi ãma, Nazaré hã. ");
INSERT INTO xavNT_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Timro me, te tineb zahuré Marizaha me, ĩsisi na, da te dame rob'ui'éré zahuré da. Wasã ré, te saprõ. ");
INSERT INTO xavNT_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","7","Tawamhã Berẽ u, ma tô aimasisi zahuré. Berẽ ãma simasisi ré, ma tô ĩwasã hã ãma sépu, te te ãma ĩrosõwada 'rada hã. Tawamhã ma tô tãma waptãrã, aibâ 'rare hã. Waptã'ã wamhã, zazahâ pa na ma tô ubu, ĩna hã. Te te ubu pari, ma tô tihi, nomro da, danhimizama hã 're ĩsaihuri mono zéb 're, wede're wa. 'Re ĩdanhimi'wara mono zéb ãma hã, 'ri 're baba hã tãma 'maihâimana zahuré õ wa, ma tame tihi. ");
INSERT INTO xavNT_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Tamemhã pone'ẽrebâ 'madâ'â'wa norĩ hã ma tô mara bâre asimro, Berẽ 'rata. Tinhimizama te 'madâ'â za'ra a'ubuni wi, rom na. ");
INSERT INTO xavNT_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Tawamhã tinhimizama te te 'madâ'â za'ra ré, misi, ma tãma sihâi'ré za'ra, hâiwa hawimhã uburé Danhib'apito ma romhuri'wa hã. Tawamhã aibâ norĩ 'rata, rowa'a ma tô tãma rowa'a za'ra. Rowa'a sa'ẽtẽ di, 'Re ĩhâimana u'âsi mono hawimhã. Tawamhã, ĩsisiwi rowa'a za'ra wamhã, ma tô tãma tipahi za'ra. ");
INSERT INTO xavNT_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Tawamhã hâiwa hawi romhuri'wa, te tãma nharĩ za'ra: — Aipahi za'ra wa'aba tõ. Wa hã wa wei mo, rowasu'uwẽ hã te aima wasu'u za'ra wa'aba da. Rowasu'uwẽ hã da te wapari za'ra wamhã, dama 're rowẽ uptabi za'ra mono di za. ");
INSERT INTO xavNT_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Ã bâtâ na ma tô waptãrã Berẽ ãma, danho'reptui'wa da hã, Dawihi za'rui ãma. Ta hã 'Re ĩhâimana u'âsi mono te te ĩpisudu, Danho'reptui'wa da, uburé Danhib'apito da hã. ");
INSERT INTO xavNT_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Ĩwaptã'ãzé hã tô sena na waihu'u za'ra wa'aba da, te za ai'uté hã ĩsabu za'ra wa'wa. Wede're wa, te nomro, zazahâ pa na, ubu ré. — Ãne te tãma rowasu'u za'ra, hâiwa hawi romhuri'wa hã. ");
INSERT INTO xavNT_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Tawamhã awa'awi ma tô tãma sihâi'ré za'ra romhuri'wa norĩ hã, ahâ uptabi na, hâiwa hawimhã. 'Re ĩhâimana u'âsi mono ãma te tiwata za'ra, ãne: ");
INSERT INTO xavNT_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","— 'Re ĩhâimana u'âsi mono hã sõprub di, hâiwa ãma 're ĩsãmra mono hã. Ma tô sima dawẽ, ĩwẽ hã te te dama 're anhomri mono da, rowẽ na 're danomro mono da oto, ti'ai ãma hã. — Ãne te tinho're na ãma tiwata za'ra. ");
INSERT INTO xavNT_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Tawamhã romhuri'wa norĩ hã hâiwa u apâ si'aba'réi wamhã, pone'ẽrebâ 'madâ'â'wa norĩ hã ma tô sima nharĩ za'ra: — Oto wasi'aba'réi wa'aba Berẽ u, Wanhib'apito, marĩ te te wama ĩwaihu'u za'ra hã wa te sabu za'ra da. — Ãne te si'ru za'ra. ");
INSERT INTO xavNT_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Tawamhã si'aba'ré na te oto ai'aba'ré, Berẽ u. Tame ma tô sabu za'ra Mariza hã, Zuzéhé me. Ai'uté zama, ma duré sabu za'ra. Danhimizama sazé wa, wede're wa, te nomro. ");
INSERT INTO xavNT_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Te te 'madâ'â za'ra wamhã, ma tô Zuzé norĩ ma rowasu'u za'ra, hâiwa hawi romhuri'wa norĩ nhimirowasu'u na, ai'uté ãma hã. ");
INSERT INTO xavNT_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Uburé da te wapari za'ra wamhã, ma tô ãma tatob'uzu za'ra ni, pone'ẽrebâ 'madâ'â'wa norĩ nhimirowasu'u na hã. ");
INSERT INTO xavNT_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Mariza hã ĩsimirowasu'u na te te 're rosa'rata u'âsi, tipẽ'ẽ na. ");
INSERT INTO xavNT_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Taha pari, te apâ ai'aba'ré, pone'ẽrebâ 'madâ'â'wa norĩ hã. Morĩ sina, te ãma tiwata za'ra, 'Re ĩhâimana u'âsi mono ãma, rowasu'u te te ĩwapari za'ra zém na, duré te te ĩ'madâ'â za'ra zém na. Hâiwa hawi romhuri'wa nhimirowasu'u zarina, tô sena na te te waihu'u za'ra wa, ma tô tinho're na ãma tiwata za'ra. ");
INSERT INTO xavNT_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Romhuri misi ãma si'utõrĩ pari, ai'uté ĩwaptã'ãzém na hã, ma tô oto sihâiwata nhizâri ni. Ma tô duré sisi zahuré ĩna norĩ hã, Zezusi na. Ã hã ĩsisi hã waptã'ã õ ré, hâiwa hawi romhuri'wa te te tãma ĩwaihu'uzéb zarina, ma sisi zahuré. ");
INSERT INTO xavNT_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","24","Tawamhã bâdâ ma tô oto ĩwa waptãrã, 'Re ĩhâimana u'âsi mono nhimiroti te te ãma uwaimrami zahuré da, Zuzé norĩ hã, Marizaha me. Te za ãma uwaimrami zahuré, ti'ra na, duré pi'õ na. Ãne Mozésihi nhimi'ui'éré hã, 'Re ĩhâimana u'âsi mono nhimiroti na: “Aibâ 'rare, waptã'ã wamhã, te te ãma ĩrosõwada 'rada hã te za ĩmama norĩ te te tãma 're sõmri za'ra apâ, 'Re ĩhâimana u'âsi mono ma.” Ãne ĩsimiroti hã. Ĩsimiroti hâiba amo hã, ãne: “Pi'õ hã 're 'ra za'ra mono wamhã, te za maparane naire hã te te tãma 're sõmri za'ra, 'Re ĩhâimana u'âsi mono ma. Naire õ wamhã, te za maparane utu'ure te te tãma 're sõmri za'ra, apâ tãma 're hâiba wẽ za'ra mono da, pi'õ norĩ hã.” Ãne ĩsimiroti hã. Taha wa, ĩsimiroti zarina, te oto Zuzé norĩ hã tineb zahuré ti'ra ré, Zeruzarẽ u, 'Re ĩhâimana u'âsi mono ma, ti'ra te te sõmri zahuré da, duré si te te tãma sõmri zahuré da, da te tãma zata zahuré da. ");
INSERT INTO xavNT_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Tawamhã aibâ hã te 're sãmra Zeruzarẽ ãma, Simi'ã na ĩsisi hã. Wẽ na te 're mo, Simi'ã hã. 'Re ĩhâimana u'âsi mono nhimiroti hã te te 're 'madâ'â pese. Danho'reptui'wa zô, te 're simipari u'âsi, Izarazéhé nhihudu norĩ te te sõ'reptu za'ra da. ");
INSERT INTO xavNT_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","'Re ĩhâimana u'âsi mono pẽ'ẽzani ré, te 're mo, Simi'ã hã. Ĩpẽ'ẽzani hã ma tô tãma ropisutu, ãne: “Atâ'â õ ré, te za Danho'reptui'wa da hã ĩsabu, 'Re ĩhâimana u'âsi mono te te ĩpisudu hã.” Ãne ma tô Simi'ãhã ma waihu'u siro. ");
INSERT INTO xavNT_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Tawamhã te te tãma ĩwaihu'uzéb zarina, te oto mo, 'Re ĩhâimana u'âsi mono ãma 're ĩdawata za'ra mono zéb u, Simi'ã hã. Ĩsa'u si, ma tô tizasi zahuré, Zuzé norĩ hã, 'Re ĩhâimana u'âsi mono nhimiroti te te ãma uwaimrami zahuré da. ");
INSERT INTO xavNT_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Tawamhã Simi'ã, ma tô tipa ti'â ĩ'ra hã, 'Re ĩhâimana u'âsi mono ãma wata da. Ãne te ãma tiwata: ");
INSERT INTO xavNT_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","— Ãhãna ma tô ãma ĩ̱ma ĩ'uwaimra, aimreme hã. Taha wa, ĩ̱to na, wa za a'ré. ");
INSERT INTO xavNT_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Wa hã ĩ̱tõmo na, wa tô oto sabu, danho'reptui'wa da hã. ");
INSERT INTO xavNT_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Uburé da'udâna zama ĩpisudu hã wa tô sabu. ");
INSERT INTO xavNT_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Rob'uiwẽzé hã te te bâdâdi uiwẽ wamhã, damorĩ wẽ di. Tane te za zudezu'õ norĩ ma, te te 're awaihu'u asimiroti hã, ãma 're nomro wẽ mono da. Wa norĩ ma, 're rowẽ za'ra mono di za, asib'a'uwẽ norĩ ma, Izarazéhé nhihudu norĩ ma, ĩsabâdâ za da te dasima 're wawasu'u wẽ u'âsi za'ra mono wa. Ãne te 'Re ĩhâimana u'âsi mono ãma tiwata, Simi'ã hã. ");
INSERT INTO xavNT_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Tawamhã Simi'ãhã mreme, 'watébrémi ãma te te wapari zahuré wamhã, ma tô ãma titob'uzu zahuré, ĩmama norĩ hã, ĩna me. ");
INSERT INTO xavNT_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","35","Tawamhã Simi'ã hã te tiwi rowaptẽ, 'Re ĩhâimana u'âsi mono wi, te te 're pawaptob zahuré mono da. Marizaha ma, te duré tinha: — 'Re ĩhâimana u'âsi mono, ma tô ai'ra hã pisutu, watẽme wei morĩ da, Izarazé na warom nhisi u. Tawamhã, watẽme wei morĩ wa, te za da'ahâ na danho'reptuzé hã da te dasina 're waihu'u za'ra. Tane nherẽ, da'ahâ na danho'reptuzé hã da te dasina 're waihu'u za'ra mono õ di za. Danho'reptui'wa na da te dasina 're waihu'u za'ra mono da, te te pisutu nherẽ, niwapsi te za ai'ra hã dasiwi wẽ'õ ni, da'ahâ na. Tawamhã da te dasiwi wẽ'õ wamhã, dama waihu'u pese di za oto, danhimirosa'rata wasédé hã ai'ra ãma hã. Sib'ézé ĩ'wa pese na, da te 're danhihâri za'ra mono wamhã, dama 're rowẽ za'ra mono õ di za. Tane ai'ra hã da te dasiwi wẽ'õ wamhã, aipẽ'ẽzé ahâ di za. — Ãne te romhâ ré Zezusihi na ma rowasu'u, Simi'ã hã. ");
INSERT INTO xavNT_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","38","Tawamhã pi'õ hã te 're hâimana, Ãna na ĩsisi hã. 'Re ĩhâimana u'âsi mono zadawa wasu'u'wa, pi'õ hã. Ĩmama nhisi hã, Panuwé na ĩsisi hã. Ĩhi'rata nhisi hã, Asé na ĩsisi hã. Ma tô oto si'ĩhi uptabi, Ãna hã. Sahuré 're simasisi zahuré mono ré, ma tô ãma tiwahub zahuré, 7 na. Tawamhã ĩmro, ma tô dârâ. Tiwi ĩdâ'âzém na hã ma tô oto ãma tiwahub ahâ, 84 na. Pi'õ hã te 're sãmra u'âsi, 'Re ĩhâimana u'âsi mono ãma 're ĩdawata za'ra mono zéb ãma, 'ri 'wawi wa'ra ãma. Rowa'a ré zama, te ãma 're wata, barana zama. Nimahã bâtâ na si, te sai ãna 're sãmra, 'Re ĩhâimana u'âsi mono ma, 're mreme mono da. Tawamhã Simi'ã hã Marizaha ma, te te rowasu'u ré, ma tô ĩtẽme tiwisi za'ra, Ãna hã. Tawamhã ai'uté te te sabui wẽ te, 'Re ĩhâimana u'âsi mono ãma te tiwata, sõpru wa. Tawamhã ma tô te te dama 're wasu'u, Danho'reptui'wa da hã, ai'uté hã. Danho'reptui'wa zô, 're ĩsimipari za'ra mono norĩ ma, ma tô te te 're rowasu'u za'ra. Ta norĩ hã te sô 're simipari za'ra, te te da'anho'reptu da, Zeruzarẽ ãma. ");
INSERT INTO xavNT_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Zuzé norĩ hã zahadu te aimasisi, Zeruzarẽ ãma. Tame simasisi ré, ma tô ãma uwaimrami zahuré, uburé 'Re ĩhâimana u'âsi mono nhimiroti hã. Tawamhã te oto tineb zahuré apâ, tirob u. Darireza na danhipti'a nho'õmo nhisi u, te tineb zahuré apâ, Nazaré u. Tawamhã ma tô aimasisi zahuré apâ, tinhorõwa u. ");
INSERT INTO xavNT_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Tawamhã ma tô tiprédu, 'watébrémi hã. Hâiba nhiptete di oto. Ĩsimiroti hã wẽ uptabi di duré. 'Re ĩhâimana u'âsi mono te te 're pawapto mono wa, wẽ uptabi di, ĩsimiroti hã. ");
INSERT INTO xavNT_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Wahup sidâpâsi, te Zezusihi mama norĩ hã dame 're neb zahuré Zeruzarẽ u, dato hã da te 're ĩ'manharĩ za'ra mono zéb u hã, 'Re ĩhâimana u'âsi mono, Ezitu hawi te te ĩdawaibuzém na ãma dasipo're pu'u za'ra da, Pascowa na dato nhisi hã. ");
INSERT INTO xavNT_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Tawamhã 12 na Zezusihi ãma wahu wamhã, te duré ĩme timorĩ zahuré oto, datoi u hã. ");
INSERT INTO xavNT_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Tawamhã dasi'rã'õtõ pari, ĩmama norĩ hã ma tô dame tipusi zahuré, tirob u apâ neb zahuré da. Tazahã, Zezusi hã te zahadu nhamra, Zeruzarẽ ãma, timama norĩ za'u. Ĩsa'u ĩsãmra zahuré zém na hã te te waihu'u zahuré õ di. ");
INSERT INTO xavNT_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Dame morĩ newa, te ĩmama norĩ hã dame tineb zahuré apâ, tirob u, te te ãma rosa'rata zahuré ãna. Bâtâ bâ, te dame tineb zahuré. Tawamhã te sô da'ab'madâ'â zahuré. Ĩsisãnawã norĩ, te te sô ab'madâ'â zahuré. Ĩsiwadi norĩ zama, te duré sô ab'madâ'â zahuré. Tane nherẽ, ma tô sô amrami zahuré. ");
INSERT INTO xavNT_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Tawamhã, sô simrami zahuré wamhã, te apâ tineb zahuré, sô rĩtĩ zahuré da. ");
INSERT INTO xavNT_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Tawamhã si'ubdatõ bâdâ ãma ne wapsi, ma tô sõpẽtẽ zahuré, 'Re ĩhâimana u'âsi mono nhorõwa ãma dame sãmra ré. Zudezu norĩ ma, rowahutu'wa norĩ me, te dame nhamra. Tame te Zezusi hã da'awapa, roti na. Te duré roti na da'azadanha, roti hã te te tãma waihu'u pese za'ra da. ");
INSERT INTO xavNT_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Zezusi hã roti te te waihu'u pese wa, ma tô ãma tatob'uzu za'ra ni, ĩsimirowaihu'u na hã. ");
INSERT INTO xavNT_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Duré ĩmama norĩ hã te te 'madâ'â zahuré wamhã, ma duré ãma titob'uzu zahuré. Tawamhã ĩna te tãma tinha: — Ĩ̱'ra, e tiha da, ma tô ãne hã wama ĩ'manha. Taré wa tô asô 're warĩtĩ, aimama me, wapẽ'ẽzé sina. — Ãne te ĩna hã tãma tinha. ");
INSERT INTO xavNT_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Tawamhã te asa tãma nharĩ zahuré: — E marĩ da, ma tô ĩ̱zô 're airĩtĩ aba mo. E ĩ̱'ãma rowaihu'u aba ãna, ĩ̱mama nhorõwa ãma ĩ̱nhamra na hã. ");
INSERT INTO xavNT_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Tane nherẽ, te te waihu'u zahuré õ di, te te ĩnharĩzém na hã. ");
INSERT INTO xavNT_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Tawamhã Zezusi te ĩme timorĩ zahuré apâ, Nazaré u. Tame timama norĩ mreme, te te 're wapari pese. Ĩna hã ĩ'ra tãma ĩsiwasu'uzéb zahuré na, te te 're rosa'rata u'âsi, tipẽ'ẽ na. ");
INSERT INTO xavNT_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Tawamhã ma tô oto tiprédu, Zezusi hã. Ĩsimiroti hã wẽ uptabi di. Wẽ na 're morĩ wa, ma tô wẽsã, 'Re ĩhâimana u'âsi mono hã. Ĩsiré zudezu norĩ hã ma tô duré wẽsãmri za'ra. ");
INSERT INTO xavNT_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Tawamhã 15 na ma tô ãma tiwahu, Tiberizuhu ãma, danhib'apito na 're hâimana mono ré, Roma ãma. Ĩsadawa para, te Põsi'u Piratu hã te te dama 're roti, Zudeza na danhipti'a nho'õmo nhisi ãma. Duré Erodi hã te te dama 're roti ĩsadawa para, Darireza na danhipti'a nho'õmo nhisi ãma. Duré Erodihi no hã Piripi hã te te dama 're roti, ĩsadawa para, Itureza na danhipti'a nho'õmo nhisi ãma, duré Taraconiti na danhipti'a nho'õmo nhisi ãma. Duré Risãniza hã te te dama 're roti, ĩsadawa para, Abireni na danhipti'a nho'õmo nhisi ãma. ");
INSERT INTO xavNT_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Duré Anasi hã, Caipasihi me, dama pire uptabi na te 're tineb zahuré, sasedoti na hã. Uburé 'Re ĩhâimana u'âsi mono ma, da'ãma romhuri'wa norĩ ma, pire zahuré di. Ãne wamhã, ma tô 'Re ĩhâimana u'âsi mono hã timreme hã Zuwãhã ma tisõ, a'ubuni u 're sãmra mono ré. Zacariaha 'ra, Zuwã hã. Ĩsadawa para te te dama 're roti mono da, ma tô timreme hã tãma tisõ. ");
INSERT INTO xavNT_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Taha wa, Zuwã hã te oto datẽme 're mo, Zodã pa 'rata, 're ĩsi'ubumroi mono norĩ u. Tawamhã, datẽme 're morĩ wamhã, ãne te te dama 're roti: — Ma'ãpé, aiwasété wi aipizari za'ra wa'aba, 'Re ĩhâimana u'âsi mono, marĩ 're ĩ'manharĩ wasété za'ra wa'aba mono zé hã te te aima pari za'ra wa'aba da. Tawamhã â dawabzuri hã wa za te aima 're ab'manharĩ 'wa. — Ãne ma tô te te dama 're roti, Zuwã Batita hã. ");
INSERT INTO xavNT_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Ãne wamhã, ma tô sina uwaimra romhâ ré, Iza'iza te te dama ĩrowasu'uzé hã. Ãne, 'Re ĩhâimana u'âsi mono zadawa wasu'u 'rata 'wa, te te dama ĩrowasu'uzém na rob'ui'éré hã: “Ni'wa hã te za te te dama 're rob'mahârâ, a'ubuni wi: Bâdâdi hã asiwi ropese aba, Wanhib'apito zô. Ĩmana 'rãmi bâdâdi hã sô sa'ra wa'aba, awa'awi da. ");
INSERT INTO xavNT_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Sa'a wa'wa, rob'rehâ hã te za asiwi ĩsito wa'wa, aiwab da. Sa'a zama, te za asiwi ĩhâpâ 'wa. Bâdâdi nhi'oto wamhã, ĩmana 'rãmi te za asiwi ĩhiri 'wa, awa'awi da. Roptâi wamhã, te za asiwi ĩromhâpâ 'wa, aiwab da. ");
INSERT INTO xavNT_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Tawamhã, watẽme wei wisi wamhã, te za aihĩni sabu za'ra ni, 'Re ĩhâimana u'âsi mono te te ĩpisudu hã, Danho'reptui'wa da. Ãne te za ni'wa hã te te dama 're roti, a'ubuni wi.” Ãne romhâ ré, ma tô ãma rob'ui'éré, Iza'iza hã. ");
INSERT INTO xavNT_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Tawamhã da'ahâ na ma tô Zuwãhã u 're dasihutu, â dawabzuri hã te te dama 're ab'manharĩ mono da. Tawamhã â dawabzuri hã te te dama 're ab'manharĩ mono õ ré, te ãne te te dama 're anharĩ: — A norĩ wa'wa hã wahi ne, te 're anomro aba mo. E 'wa simiroti zarina, te we ĩ̱tẽme ai'aba'réi wa'wa bété, taré â dawabzuri hã 'manharĩ za'ra wa'aba wa, 'Re ĩhâimana u'âsi mono nhimihâzé wi, asisõ'reptu za'ra wa'aba da bâ, aiwasédé hã rẽme za'ra wa'aba õ nherẽ. ");
INSERT INTO xavNT_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Sena na aiwasédé hã ĩrẽme za'ra wa'aba zém na, da te 're aiwaihu'u za'ra wa'aba mono da, te za oto 're anomro wẽ wa'aba mo. Duré Abra'ãhã nhihudu wẽ te, asina 're rosa'rata za'ra wa'aba mono õ di za, 'Re ĩhâimana u'âsi mono te te 're ĩ'aihâ za'ra wa'aba mono õ na hã. 'Re ĩhâimana u'âsi mono ma, waihu'u pese di, ã ẽtẽ norĩ ma, te te nharĩ da, tãma si'a'uwẽ za'ra da, Abra'ãhã nhihudu oto 're nomro mono da oto, ẽne hã. ");
INSERT INTO xavNT_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Hâtâra hã ma tô ni'wa hã sarõtõ oto, wede te te ãma sari nhihâri da. Uburé wede hã 're ĩ'rãi pese za'ra mono õ hã te za te te ãma 're anhihâri. Tawamhã unhama u te za te te 're anhamra. — Ãne te dama ãma simiré'é Zuwã hã, 'Re ĩhâimana u'âsi mono nhimihâzém na hã. ");
INSERT INTO xavNT_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Tawamhã ĩsimirowasu'u hã da te 're wapari za'ra mono wamhã, te sadanharĩ za'ra ni, ãne: — E marĩ, wa za 'manharĩ za'ra ni, ĩwẽ hã, 'Re ĩhâimana u'âsi mono te te wama rob'manharĩ za'ra tõ da hã. — Ãne te sadanharĩ za'ra ni. ");
INSERT INTO xavNT_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Tawamhã asa te tãma nharĩ za'ra: — Te za 're asipawaptob za'ra wa'aba mo. Ni'wa hã, ti'uza ĩsõ'utu'u hã maparane wamhã, te za tihâiba amoi ma misi tisõ, uza õ wa. Duré ni'wa hã, tisa hã te za tihâiba amoi ma tisõ, sai õ wa. — Ãne te tãma roti za'ra. ");
INSERT INTO xavNT_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Tawamhã danhib'apito ma, rob'uiprazé ubumroi'wa norĩ hã ma ĩtẽme aihutu, â dawabzuri te te tãma 'manharĩ za'ra da. Tawamhã ĩtẽme sihutu wamhã, te siwi 'mahâ: — Rowahutu'wa, wa norĩ hã bété e marĩ, wa za 'manharĩ za'ra ni ĩwẽ hã, 'Re ĩhâimana u'âsi mono te te wama rob'manharĩ za'ra tõ da hã. — Ãne te sadanharĩ za'ra. ");
INSERT INTO xavNT_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Tawamhã asa te tãma nharĩ za'ra: — Ĩ'uwaibaba si, te za dawi 're ĩwaptẽrẽ za'ra wa'aba mo, rob'uiprazé hã. Ãma dawi 're pararé za'ra wa'aba mono õ di za. — Ãne ma tô tãma waihu'u za'ra, Zuwã hã. ");
INSERT INTO xavNT_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Tawamhã da'wapéi'wa norĩ hã te duré siwi 'mahâ: — Wa norĩ hã bété, e marĩ, wa za 'manharĩ za'ra ni, ĩwẽ hã, 'Re ĩhâimana u'âsi mono te te wama rob'manharĩ za'ra tõ da hã. — Ãne te sadanharĩ za'ra. Tawamhã asa te tãma nharĩ za'ra: — Asiptete na, rob'uiprazé hã dawi 're waibu za'ra wa'aba mono õ di za. Duré asadawa nhipese na, rob'uiprazé hã dawi 're waptẽrẽ za'ra wa'aba mono õ di za. Duré aipawa'âbâ 'wa hã 're ĩwaibui aba mono na hã asima ãma 're rowẽ pese za'ra wa'aba mono. — Ãne ma tô tãma waihu'u za'ra, da'wapéi'wa norĩ ma. ");
INSERT INTO xavNT_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Tawamhã, Zuwã hã ma tô te te dama 're rowasu'u, Danho'reptui'wa, za we ĩmorĩ na hã. Tawamhã te dasima nharĩ za'ra ni, ãne: — Ãté wanho'reptui'wa da hã romhutu na, te za wei mo. Ãté Zuwã hã, wanho'reptui'wa. — Ãne te dasima nharĩ za'ra ni. ");
INSERT INTO xavNT_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Tazahã, ãne ma tô dama tinha, Zuwã hã: — Wa hã wa tô â na si â dawabzuri hã te aima 're 'manharĩ za'ra wa'wa. Ĩ̱za'u si te za ĩ̱ma ĩpire uptabi hã wei wi. Ĩ̱ma pire wa, ĩpara'uza wasisizé, te tãma wasihu waihu'u õ di za. Ĩ̱ma ĩpire hã wei morĩ wapsi, te za Tipẽ'ẽzani hã te te aima 're anhomri 'wa, unhama ro'o ne hã. ");
INSERT INTO xavNT_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Wei morĩ wapsi, te za da'ãma aipo'o. Buru nho, da te 're upõrĩ za'ra mono parimhã, te za da te 're sa'wari za'ra, ĩsa'warizéb 're. Tawamhã ĩtomhâ te za da te ãma ro'o za'ra. Ĩro hã sa'ẽtẽ nherẽ, da te wĩrĩ waihu'u õ di za. Tane, ĩ̱ma ĩpire hã wei morĩ wapsi, te za da'ãma aipo'o, tridu upõrĩ za'wari ne, ĩtomhâ za'wari ne. — Ãne ma tô Zuwã Batita hã dama rowasu'u. ");
INSERT INTO xavNT_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Ĩwasu'uwẽ na te te 're da'apo're pu'u, Zuwã Batita hã. Tawamhã marĩ na hã ĩsimirowasu'u hã ahâ di, 're danomro wẽ mono da, te te dama 're roti mono ré hã. ");
INSERT INTO xavNT_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Tawamhã apito Erodihi ma, te duré tinha, wasété na 're morĩ wa. Tinoi mro, ma tô ti'â, Erodi hã. Ĩnoi mro nhisi hã, Erodiza na. Ma tô duré tiwasédé hã te te 're ab'manharĩ. Taha wa, te tãma tinha, Zuwã hã. ");
INSERT INTO xavNT_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Taha wa, Erodi hã ma tô Zuwã hã dama ti'ru, dazazéb 're, da te sẽrẽ da. Ãne wamhã, ma tô ĩsipai u tiwasédé hã 'manha, Erodi hã. ");
INSERT INTO xavNT_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","22","Tawamhã dazazéb 're, zahadu da te sẽrẽ õ ré, te â dawabzuri hã te te dama 're ab'manharĩ, Zuwã hã. Te te dama ab'manharĩ parimhã, Zezusihi ma zama, ma 'manha. Tawamhã Zezusi hã te mre, 'Re ĩhâimana u'âsi mono ma. Mreme ré, hâiwa ma we si'ridawa, ĩsisi nho'õmoi baba. Tawamhã 'Re ĩhâimana u'âsi mono pẽ'ẽzani hã ma we ĩtẽme wi, utu'u ne. Hâiwa hawi, te we tãma tinha, ãne: — A hã ĩ̱'ra. Ĩ̱ma asawi uptabi di. Aima ĩ̱to za'ẽtẽ uptabi di. — Ãne te we tãma tinha, Ĩmama hã. ");
INSERT INTO xavNT_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Zezusi hã 30 na ãma ĩwahub ãma, ma tô romhuri na sãna'rata, Timama zadawa wasu'u na hã. Zuzéhé 'ra newa, ma tô ĩ'ra na, da te 're sisi za'ra. Zuzéhé poto'wa nhisi hã, Eri na ĩsisi hã. ");
INSERT INTO xavNT_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Erihi poto'wa nhisi hã, Matati na ĩsisi hã. Matatihi poto'wa nhisi hã, Réwi na ĩsisi hã. Réwihi poto'wa nhisi hã, Meti na ĩsisi hã. Metihi poto'wa nhisi hã, Zana'i na ĩsisi hã. Zana'ihi poto'wa nhisi hã, Zuzé na ĩsisi hã. ");
INSERT INTO xavNT_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Zuzéhé poto'wa nhisi hã, Matatiza na ĩsisi hã. Matatiza poto'wa nhisi hã, Amosi na ĩsisi hã. Amosihi poto'wa nhisi hã, Na'u na ĩsisi hã. Na'uhu poto'wa nhisi hã, Eziri na ĩsisi hã. Ezirihi poto'wa nhisi hã, Nada'i na ĩsisi hã. ");
INSERT INTO xavNT_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Nada'ihi poto'wa nhisi hã, Ma'ati na ĩsisi hã. Ma'atihi poto'wa nhisi hã, Matatiza na ĩsisi hã. Matatizaha poto'wa nhisi hã, Seme na ĩsisi hã. Semehẽ poto'wa nhisi hã, Zuzé na ĩsisi hã. Zuzéhé poto'wa nhisi hã, Zoda na ĩsisi hã. ");
INSERT INTO xavNT_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Zodaha poto'wa nhisi hã, Zuwãna na ĩsisi hã. Zuwãnahã poto'wa nhisi hã, Reza na ĩsisi hã. Rezaha poto'wa nhisi hã, Zorobabé na ĩsisi hã. Zorobabéhé poto'wa nhisi hã, Sarati'é na ĩsisi hã. Sarati'éhé poto'wa nhisi hã, Neri na ĩsisi hã. ");
INSERT INTO xavNT_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Nerihi poto'wa nhisi hã, Meti na ĩsisi hã. Metihi poto'wa nhisi hã, Adi na ĩsisi hã. Adihi poto'wa nhisi hã, Cosã na ĩsisi hã. Cosãhã poto'wa nhisi hã, Emadã na ĩsisi hã. Emadãhã poto'wa nhisi hã, Ere na ĩsisi hã. ");
INSERT INTO xavNT_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Erehe poto'wa nhisi hã, Zuzuwé na ĩsisi hã. Zuzuwéhé poto'wa nhisi hã, Eri'ézé na ĩsisi hã. Eri'ézéhé poto'wa nhisi hã, Zorĩ na ĩsisi hã. Zorĩhĩ poto'wa nhisi hã, Matati na ĩsisi hã. Matatihi poto'wa nhisi hã, Réwi na ĩsisi hã. ");
INSERT INTO xavNT_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Réwihi poto'wa nhisi hã, Simi'ã na ĩsisi hã. Simi'ãhã poto'wa nhisi hã, Zuda na ĩsisi hã. Zudaha poto'wa nhisi hã, Zuzé na ĩsisi hã. Zuzéhé poto'wa nhisi hã, Zona na ĩsisi hã. Zonahã poto'wa nhisi hã, Eri'atĩ na ĩsisi hã. ");
INSERT INTO xavNT_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Eri'atĩhĩ poto'wa nhisi hã, Mereza na ĩsisi hã. Merezaha poto'wa nhisi hã, Mena na ĩsisi hã. Menahã poto'wa nhisi hã, Matata na ĩsisi hã. Matataha poto'wa nhisi hã, Natã na ĩsisi hã. Natãhã poto'wa nhisi hã, Dawi na ĩsisi hã. ");
INSERT INTO xavNT_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Dawihi poto'wa nhisi hã, Zésé na ĩsisi hã. Zéséhé poto'wa nhisi hã, Obedi na ĩsisi hã. Obedihi poto'wa nhisi hã, Bu'azi na ĩsisi hã. Bu'azihi poto'wa nhisi hã, Sara na ĩsisi hã. Saraha poto'wa nhisi hã, Nasõ na ĩsisi hã. ");
INSERT INTO xavNT_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Nasõhõ poto'wa nhisi hã, Aminadabe na ĩsisi hã. Aminadabehe poto'wa nhisi hã, Ademi na ĩsisi hã. Ademihĩ poto'wa nhisi hã, Arini na ĩsisi hã. Arinihi poto'wa nhisi hã, Esirõ na ĩsisi hã. Esirõhõ poto'wa nhisi hã, Perezi na ĩsisi hã. Perezihi poto'wa nhisi hã, Zuda na ĩsisi hã. ");
INSERT INTO xavNT_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Zudaha poto'wa nhisi hã, Zaco na ĩsisi hã. Zacoho poto'wa nhisi hã, Izati na ĩsisi hã. Izatihi poto'wa nhisi hã, Abra'ã na ĩsisi hã. Abra'ãhã poto'wa nhisi hã, Tera na ĩsisi hã. Teraha poto'wa nhisi hã, Na'o na ĩsisi hã. ");
INSERT INTO xavNT_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Na'oho poto'wa nhisi hã, Serudi na ĩsisi hã. Serudihi poto'wa nhisi hã, Rada'u na ĩsisi hã. Rada'uhu poto'wa nhisi hã, Peredi na ĩsisi hã. Peredihi poto'wa nhisi hã, Ébé na ĩsisi hã. Ébéhé poto'wa nhisi hã, Sera na ĩsisi hã. ");
INSERT INTO xavNT_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Seraha poto'wa nhisi hã, Ca'ina na ĩsisi hã. Ca'inahã poto'wa nhisi hã, Apasadi na ĩsisi hã. Apasadihi poto'wa nhisi hã, Sẽ na ĩsisi hã. Sẽhẽ poto'wa nhisi hã, Nowé na ĩsisi hã. Nowéhé poto'wa nhisi hã, Rameti na ĩsisi hã. ");
INSERT INTO xavNT_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Rametihi poto'wa nhisi hã, Matuzarẽ na ĩsisi hã. Matuzarẽhẽ poto'wa nhisi hã, Enoti na ĩsisi hã. Enotihi poto'wa nhisi hã, Zareti na ĩsisi hã. Zaretihi poto'wa nhisi hã, Marere na ĩsisi hã. Marerehe poto'wa nhisi hã, Ca'ina na ĩsisi hã. ");
INSERT INTO xavNT_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Ca'inahã poto'wa nhisi hã, Enosi na ĩsisi hã. Enosihi poto'wa nhisi hã, Sete na ĩsisi hã. Setehe poto'wa nhisi hã, Adã na ĩsisi hã. Adãhã poto'wa hã, 'Re ĩhâimana u'âsi mono. ");
INSERT INTO xavNT_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Tawamhã Zodã pa hawi, te oto mo Zezusi hã, tirob u apâ morĩ da. 'Re ĩhâimana u'âsi mono pẽ'ẽzani ré, te 're mo. Taha si, te te 're wapari pese. Tawamhã Ĩpẽ'ẽzani hã te saprõ, a'ubuni u. ");
INSERT INTO xavNT_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","A'ubuni wi hâimana ré hã, bâdâ hã ahâ na ma tô ãma ai'utõ, 40 na. Tame hâimana ré, ma tô ĩtẽme wi Wa'uburé hã, te te nasi pibu da, ĩsimiroti na te te saze da. Taha ré hã, sai ãna te tihâiba, Zezusi hã. Taha wa, ma tô mra hã sépata. ");
INSERT INTO xavNT_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Tawamhã Wa'uburé hã te Zezusihi ma tinha, ãne: — Sena a hã, 'Re ĩhâimana u'âsi mono 'ra wamhã, ma'ãpé ẽtẽ ma nharĩ, ĩ'u'ẽtẽ wapu na aima si'manharĩ da. ");
INSERT INTO xavNT_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Tawamhã Zezusi te asa tãma tinha: — 'Re ĩhâimana u'âsi mono mreme na rob'ui'éré hã, ãne: “Dasa na si 're danhiptete za'ra mono õ di za.” — Ãne te Zezusi hã tãma rowasu'u, Wa'uburé ma. ");
INSERT INTO xavNT_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Tawamhã Wa'uburé hã te Zezusi saprõ, sa'a nhisi u. Tawamhã sa'a nhisi sima'wara wamhã, ma tô Zezusihi ma tinha, danhib'apito norĩ nhipti'ai mono bâ, te te rob'madâ'â mono da. ");
INSERT INTO xavNT_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","7","Tawamhã te te rob'madâ'â mono pari, te duré tãma tinha, Zezusihi ma: — Uburé danhipti'a hã ma tô ĩ̱ma sõmri ni, ĩ̱te da. Tawamhã te ĩ̱sima ĩwẽzéb uwaibaba, wa za dama tisõ. Aihi'rãtitõ, te za ĩ̱nho're ĩ̱ma aime, asib'apito na ĩ̱'ãma aiwata da. Tawamhã wa za aima tisõ danhipti'ai mono bâ, ate da. Tawamhã danhipai u, dama aipire di za. Duré asibrob ahâ uptabi di za. — Ãne te Zezusihi ma tinha. ");
INSERT INTO xavNT_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Taha wa, te Zezusi hã asa tãma tinha: — Mare di. 'Re ĩhâimana u'âsi mono zadawa wasu'u'wa, ma tô ãne rob'ui'éré, ĩbaihâ na hã: “Uburé Danhib'apito uptabi ãma si, te za 're aiwata za'ra wa'aba mo, 'Re ĩhâimana u'âsi mono ãma si. Taha ma si, te za 're ĩromhuri za'ra wa'aba mo, Asib'apito za'ra wa'aba ma si.” Ãne ĩmreme na rob'ui'éré hã. — Ãne te Zezusi hã tãma rob'rãzarõtõ. ");
INSERT INTO xavNT_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","11","Tawamhã Wa'uburé hã ma tô Zezusi hã saprõ Zeruzarẽ u, te te duré pibu da. 'Re ĩhâimana u'âsi mono ãma 're ĩdawata za'ra mono zéb u, te saprõ, 'ri nhisi u sab da hâimo, 'ri 'rãihâ uptabi nhisi. Tawamhã Zezusihi ma, te tinha: — Sena a hã 'Re ĩhâimana u'âsi mono 'ra wamhã, ma'ãpé ã hawi atobro, ti'ai u. 'Re ĩhâimana u'âsi mono, te za, u, hâiwa hawi we atẽme satõrĩ za'ra, te te ai'madâ'â za'ra da, tãma ĩromhuri'wa norĩ hã. Tinhib'rata na te za, u, siwi asapa, ẽne hã te te ai'u'a õ'umnhasite, aipara wi. Ãne 'Re ĩhâimana u'âsi mono zadawa wasu'u'wa nhimirob'ui'éré, ĩbaihâ na hã. — Ãne ma tô Zezusihi ma sadawa 'rãzarõtõ, wa'rui'wa hã. ");
INSERT INTO xavNT_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Tawamhã Zezusi te asa tãma tinha: — Mare di. “Asib'apito za'ra wa'wa hã 'Re ĩhâimana u'âsi mono hã, marĩ hã te te aima 're pisutu za'ra wa'aba mono õ nherẽ, 're pibu za'ra wa'aba mono õ di za, ta hã te te 're aipawaptob za'ra wa'aba mono zô.” Ãne ĩmreme na rob'ui'éré hã. — Ãne te Zezusi hã duré tãma rob'rãzarõtõ. ");
INSERT INTO xavNT_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Tawamhã Wa'uburé hã taré te te Zezusi hã pibui mono pari, te oto ĩsiti mo, ĩsimiroti na te te sazei õ wa, a'â sadawa utu da. ");
INSERT INTO xavNT_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Tawamhã apâ te mo Darireza u, Zezusi hã. 'Re ĩhâimana u'âsi mono pẽ'ẽzani ré, te 're mo. Ĩré 're morĩ wa, te waihu'u pese na 're mo. Tawamhã ma tô ĩwasu'u hã wapari za'ra ni, Darireza ãma daro mono bâ. ");
INSERT INTO xavNT_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Zezusi hã te te dama 're rowahutu, zudezu norĩ te, rowahutuzé mono bâ. Tawamhã da te 're wapari za'ra mono wamhã, te ãma 're dawata za'ra, ĩsimirowasu'u hã wẽ uptabi wa. ");
INSERT INTO xavNT_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Tawamhã Nazaré u te mo Zezusi hã, tiprédubzéb u. Sabadu sidâpâsi dame 're zasi mono wa, ma duré dame ãzé, zudezu norĩ te, rowahutuzéb u, romhuri zahârizém na hã. Tawamhã rowahutuzéb ãma sãmra wamhã, ma wahudu. Hâiwi te za, 'Re ĩhâimana u'âsi mono mreme ui'éré hã te te dama sõré da. ");
INSERT INTO xavNT_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Tawamhã ma tô tãma sõmri ni, Iza'izaha nhimi'ui'éré hã. 'Re ĩhâimana u'âsi mono zadawa wasu'u 'rata 'wa, Iza'iza hã. Tawamhã ma tô oto sima sõzi, ĩbaihâ hã. Te te sõzi wamhã, ma tô tisã, da te ãma ĩrob'ui'éré hã, ãne: ");
INSERT INTO xavNT_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“'Re ĩhâimana u'âsi mono, ma tô ĩ̱ma tisõ, Tipẽ'ẽzani hã. Ta hã ma tô ĩ̱pisutu, ĩwasu'uwẽ na, ĩsibrob'õ norĩ hã te 're apo're pu'u mono da. Ma tô we ĩ̱zatõ, dama romhuri'wa da, da te ĩwaibu za'ra norĩ hã te 're apawapto mono da, apâ oto 're nomro mono da, robze u'âsi. Duré ĩtob'a hã te 're ato pese mono da, ma tô we ĩ̱zatõ, datõmo wẽ na apâ oto 're danomro mono da, robze na. Duré ma tô we ĩ̱zatõ, da te tãma 're ĩ'manharĩ wasété za'ra mono zém hawi, te 're da'awaibui mono da. ");
INSERT INTO xavNT_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","'Re ĩhâimana u'âsi mono hã te te sima ĩropisutuzé hã ma tô ĩwa waptãrã, tinhib'a'uwẽ hã te te 're ĩ'anho'reptui mono zéb da hã. Taha wasu'u na te 're da'apo're pu'u mono da, ma tô wẽ ĩ̱zatõ.” Ãne ma tô Iza'izaha nhimi'ui'éré hã dama sõré, Zezusi hã. ");
INSERT INTO xavNT_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Tawamhã te te sõré pari, ma tô apâ sito, ĩbaihâ hã. Tawamhã apâ ma tô tãma tisõ, dapawapto'wai ma. Tawamhã ma tô nhamra, te te dama rowasu'u da. Uburé rowahutuzéb ãma ĩsi'ubumro norĩ hã tãma rĩtĩ si'ẽ za'ra ãna, ma tô Zezusi hã siwi 'madâ'â pese. ");
INSERT INTO xavNT_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Taha wa, ma tô Zezusi hã tãma nharĩ za'ra, ãne: — Wa tô aima sõré za'ra wa'wa, 'Re ĩhâimana u'âsi mono mreme ui'éré hã. Ĩwasu'u hã ma tô ĩwapari za'ra wa'wa. Ãhãna ĩ̱wapari za'ra wa'aba ré, ma tô oto we ãma uwaimra, 'Re ĩhâimana u'âsi mono hã. — Ãne Zezusi ma tô tãma rowasu'u za'ra. ");
INSERT INTO xavNT_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Tawamhã ĩsimirowasu'u hã wẽ wa, aihĩni te ãma tawata za'ra ni. Mreme wẽ uptabi wa, ma ãma tatob'uzu za'ra ni. Tazahã, te dasima nharĩ za'ra ni, ãne: — E niha õ hã simirowasu'u waihu'u pese di, Zuzéhé 'ra nherẽ. — Ãne te dasima nharĩ za'ra ni. ");
INSERT INTO xavNT_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Tawamhã Zezusi te dama tinha: — Ãté da te dasima ĩnharĩ za'ra zém na, te za ĩ̱ma ĩnharĩ za'ra wa'wa, ãne: “Wawede'wa, ma'ãpé 'râwi asipese.” Ãté te za duré ĩ̱ma ĩnharĩ za'ra wa'wa, ãne: “Ma'ãpé, ãmeb zama 're wa'apawapto mono, aiwaihu'u pese na, Capana'u ãma 're ĩda'apawapto mono ne. Aiwasu'u hã wa tô wapari za'ra ni.” Ãté, ãne te za ĩ̱ma ĩnharĩ za'ra wa'wa. — Ãne te Zezusi tãma nharĩ za'ra. ");
INSERT INTO xavNT_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Te duré tãma nharĩ za'ra, ãne: — 'Re ĩhâimana u'âsi mono zadawa wasu'u'wa norĩ zô, 're datob'uzu za'ra mono õ di, ĩsipti'ai ãma wa. Mare di. Sô 're datob'uzu za'ra mono õ di za. ");
INSERT INTO xavNT_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","26","Ĩ̱wapari pese za'ra wa'aba. Wahi'rada Eriasi hã, 'Re ĩhâimana u'âsi mono zadawa wasu'u'wa, te 're mo. Tawamhã ti'ai ãma 're morĩ ré hã, tãi ãna hã ma tô da'ãma tiwahu, si'ubdatõ. Tãi õ wa, mra hã te da te 're sépata za'ra. Tawamhã ĩmrotõ ahâ nherẽ, Izarazé na darom nhisi ãma, ma tô darob amoi u satõ, zudezu'õ u, 'Re ĩhâimana u'âsi mono hã. Sido na danhipti'a nho'õmo nhisi u, ma tô pi'õ mrotõ u satõ, Sarepata na 'ri nho'õmo nhisi u. ");
INSERT INTO xavNT_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Duré wahi'rada Erisezu hã 're morĩ ré hã, da'ahâ na te 're danomro, ĩ'wa're ré hã, Izarazé na darom nhisi 'remhã. Tane nherẽ, aibâ misi, ma tô pese, Na'ama na ĩsisi hã, Siriza na 're ĩhâimana mono hã zudezu'õ hã. — Ãne, Zezusi ma tô tãma rob'rãzarõtõ za'ra. ");
INSERT INTO xavNT_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Taha wa, ĩsimirowasu'u hã te te wapari za'ra wamhã, ma tô sada tazahi za'ra ni, rowahutuzéb ãma ĩsi'ubumro norĩ hã. ");
INSERT INTO xavNT_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Tawamhã ma tô sô tiwahutu za'ra, rob u te te siwi wazere da. Ma tô te te ãma robâdâ za'ra, 'ri nho'õmo nhiti. Sa'a na, ma tô ãma siwi sai'u, sa'a nhisi hawi, ĩ'rã sipra u te te siwi me da. ");
INSERT INTO xavNT_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Tazahã, ma tô dawa'wai baba ro'razâ. Dahawi te oto mo. ");
INSERT INTO xavNT_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Tawamhã Capana'u na 'ri nho'õmo nhisi u, te mo Zezusi hã. Darireza ãma, Capana'u hã. Tame sabadu na te dama rowahutu, zudezu norĩ te, rowahutuzéb ãma. ");
INSERT INTO xavNT_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Tawamhã mreme pire na te te dama rowasu'u wamhã, ma ãma tatob'uzu za'ra ni. ");
INSERT INTO xavNT_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Tame te aibâ hã dame nhamra, zudezu norĩ te, rowahutuzéb ãma, wa'uburé ré 're ĩmorĩ hã. Tawamhã aibâ hã te sa'ẽtẽ 'mahâ, ãne: ");
INSERT INTO xavNT_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","— Zezusi, Nazaré nhihudu, e marĩ zô, te we aimo. E wa'uprosi da, te we aimo. A hã ĩ̱ma aiwaihu'u pese di, 'Re ĩhâimana u'âsi mono we te te asatõrĩ na hã. Aiwẽ uptabi di, a hã. — Ãne te 'mahâ. ");
INSERT INTO xavNT_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Taha wa, ma tô Zezusi hã wa'uburé ma tinha, ãne: — Tô'ã, we ĩ̱ma nharĩ tõ. Mo oto aiwatobro, aibâ hawi. — Ãne ma tô tãma rob'ru, wa'uburé ma. Tawamhã sisa'u ma tô aibâ hã time ti'ai u, danho'a. Taha pari, ma aibâ hawi watobro. Te te u'a õ di. ");
INSERT INTO xavNT_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Tawamhã, da te 'madâ'â za'ra wamhã, ma ãma tatob'uzu za'ra ni, uburé. Taha wa, te ãne dasima nharĩ za'ra ni: — Õ hã mreme pire di. Waihu'u pese di. Dahawi si'aba'ré da, te za tãma rob'ru za'ra. Tawamhã te za dahawi ai'aba'ré. — Ãne te dasima nharĩ za'ra ni. ");
INSERT INTO xavNT_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Taha wa, Zezusihi wasu'u hã wa'uburé te te dama ĩsãmra na, ma tô ĩwasu'u hã ropé, daro mono bâ. ");
INSERT INTO xavNT_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Tawamhã ma tô watobro rowahutuzém hawi, Zezusi hã. Simahã nhorõwa u, te oto mo. Tame Simahã maprebaba sipi'õ hã, hâzé ré te nomro, wa'ro za'ẽtẽ na. Taha wa, ma tô Zezusihi ma wasu'u za'ra ni. ");
INSERT INTO xavNT_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Taha wa, ĩsimiwaptâ u te ĩtẽme mo. Ĩ'rata te za. Tawamhã ĩwa'ro ma, te tinha, wahâ da. Taha wa, ma tô tiwahâ. Awa'awi ma tô wahudu. Wahutu wamhã, ma tô tãma api za'ra, saihuri da. ");
INSERT INTO xavNT_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Tawamhã bâdâ sébrézéb u, ma tô we ĩtẽme ãwisi za'ra ni Zezusihi u, ĩsiwadi norĩ hã, ĩhâzé sipu'u norĩ hã. Tawamhã tinhib'rada, ma tô te te da'ãma aza'ra, misi si. Taha wa, ma tô tazéptâ'â za'ra ni. ");
INSERT INTO xavNT_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Duré wa'uburé hã ma tô dahawi wairé. Da'ahâ na, ĩré 're ĩdanomro mono norĩ hawi, ma tô wairé, wa'uburé norĩ hã. Tawamhã dahawi wairébé sina, te ãne 'mahârâ za'ra: — A hã, 'Re ĩhâimana u'âsi mono 'ra. — Ãne te wa'uburé norĩ hã 'mahârâ za'ra. Zezusi hã, Danho'reptui'wa da, 'Re ĩhâimana u'âsi mono te te ĩpisutu na te te waihu'u za'ra wa, ma tô Zezusi hã ĩmreme hã tiwi sisisi za'ra sa'ẽtẽ, ari'iwi dahawi wairébé da. ");
INSERT INTO xavNT_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Tawamhã awẽ ma tô watobro, 'ri nho'õmo hawi, a'ubuni u morĩ da, Zezusi hã. Taha wa, ma tô sô danhopré. Da te sõpẽtẽ za'ra wamhã, ma tô ãma ropti za'ra ni, nimomo danhiti morĩ tõ da. ");
INSERT INTO xavNT_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Taha wa, te Zezusi hã asa tãma nharĩ za'ra: — 'Re ĩhâimana u'âsi mono hã danhib'apito uptabi hã, te te dapawapto waihu'u pese di. Ta hã ma tô we ĩ̱zatõ, ĩwasu'uwẽ na te 're da'apo're pu'u mono da, daza'rui mono bâ. Taha wa, a norĩ wa'aba si te 're aipo're pu'u za'ra wa'aba mono õ di za, ĩwasu'uwẽ na hã. Uburé wa za ĩwasu'uwẽ na te 're da'apo're pu'u. — Ãne te tãma siwasu'u za'ra, Zezusi hã. ");
INSERT INTO xavNT_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Taha wa, te datẽme 're mo, zudezu norĩ te, rowahutuzé mono bâ, ĩwasu'uwẽ na te te 're da'apo're pu'u mono da, daro mono bâ. ");
INSERT INTO xavNT_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Tawamhã Zezusi hã te nhamra, ĩsõ'u zaihâ na. Zenezaré na ĩsõ'u nhisi ãma te nhamra, 'Re ĩhâimana u'âsi mono te te dama sadawa wasu'u da. Da'ahâ uptabi na ma tô ĩtẽme dasito, da te wapari za'ra da. ");
INSERT INTO xavNT_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Tawamhã uba're maparane ma tô sabu zahuré. Ĩsõ'u zaihâ na, te da'wa. Tepe na romhuri'wa norĩ hã ma tô ĩwana wairé. Abazipara, te oto upsõ za'ra. ");
INSERT INTO xavNT_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Tawamhã Zezusi ma tô ãzé, uba're wa, Simahã te 're. Tawamhã, uba're wa, sébré wamhã, te Simahã ma tinha, syry na te te ĩré sa'ré da, supara'ré nhiti. Tawamhã uba're wa, te oto nhamra, te te dama rowasu'u da. ");
INSERT INTO xavNT_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Tawamhã, te te dama rowasu'u pari wamhã, te Simahã ma tinha, ãne: — Uba're hã asiré sari, â 'rehâ u, abazipara hã asiré norĩ me, tepe zô sãmra aba da. — Ãne te Simahã ma tinha. ");
INSERT INTO xavNT_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Taha wa, ma tô Sima hã asa tãma siwasu'u, ãne: — Mara bâre, wa tô wei wa te sô sãmra. Tane nherẽ, wa te 'mai'âri za'ra õ di. Tepe õ di. Tane nherẽ, ĩ'ruzéb zarina wa za sô sãmra ni. — Ãne te Zezusihi ma tinha asa. Tawamhã te oto sô sari za'ra, â wa'wa u. ");
INSERT INTO xavNT_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Taha wa, abazipara, ma tô â wa'wa u sô sãmra. Tawamhã tebe hã ahâ na ma tô waibu za'ra, abazipara na. Taha wa, te aré te te sina sinarĩ, abazipara hã. ");
INSERT INTO xavNT_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Tawamhã tisiré tepe mrami'wa norĩ zô ma tô pahamrimi zahuré, uba're ĩhâiba amo hã te te ĩtẽme sari zahuré da, te te ãma pawaptob za'ra da. Taha wa, te ĩtẽme sari zahuré. Tawamhã uba're wa, ma tô sãmra za'ra, aibâ norĩ hã. Tebe hã uba're si'uiwa na hã 'masisi zahuré di. Tebe hã ahâ uptabi wa, te aré sina 'mazasi zahuré, uba're hã. ");
INSERT INTO xavNT_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","10","Tebe ahâ na te te awaibui wamhã, ma tô ãma titob'uzu za'ra. Ti'adu norĩ zama, ma tô ãma titob'uzu zahuré, Zuwãhã me. Ta norĩ hã Zebedehe 'ra zahuré. Ĩsiré tepe na, te te 're romhuri zahuré, Simahã siré. Tawamhã hi'rãtitõ, ma aime Zezusihi papara, Sima Pedru hã, tebe ahâ na te te 'madâ'â wamhã. Ãne te Zezusihi ma tinha: — Ĩ̱'rata asãmra õ di za. Te za oto aimo, ĩ̱nhiti. Wa hã ĩ̱wasétére di. — Ãne te Zezusihi ma siwasu'u. Tawamhã Zezusi te asa tãma tinha: — Asina aipahi õ di za. Tepe na 're ĩromhuri mono ne, te za oto ĩ̱ma 're ĩda'awaibui wẽ mo. — Ãne te Zezusi hã Simahã ma tinha. ");
INSERT INTO xavNT_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Tawamhã uba're, ma tô sani za'ra, rob'ré u. Uburé ma tô marĩ hã rẽme za'ra, tinhimiromhuri za'ra zé hã, Zezusihi siré oto 're nomro mono da. ");
INSERT INTO xavNT_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Tawamhã Zezusi hã te nhamra, 'ri nho'õmo ãma. Tame te aibâ hã 're sãmra, ĩ'wa're ré hã. Uburé ĩhâiba na, ĩ'wa're hã. Tawamhã Zezusi te te sõpẽtẽ wamhã, hi'rãtitõ ma aime, Zezusihi papara. Ti'ai u, ma tô ti'ubu na ropto. Tawamhã Zezusihi ma, te tinha, ãne: — Apito, ĩ̱ma aiwaihu'u pese di, asimipese waihu'u pese na hã. Taha wa, te za ĩ̱pe, asima ĩ̱wẽ wamhã. — Ãne te tãma tinha. ");
INSERT INTO xavNT_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Tawamhã tinhib'rada hã ma tô wahutu Zezusi hã, te te ãma upi da. Te te upi wamhã, te tãma tinha: — Wa tô ĩ̱sima aiwẽ, te aipese da. Tâibâ za oto aihâzé hã. — Ãne te tãma tinha. Tawamhã awa'awi ma ĩ'wa're hã tãma apa. ");
INSERT INTO xavNT_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Tawamhã Zezusi ma tô sina sadawa uwati, te te dama sina wasu'u tõ da. Te tãma tinha, ãne: — 'Re ĩhâimana u'âsi mono ma, da'ãma romhuri'wai u, te za aimo, aihâiba wẽ zô te te aihâiba 'madâ'â da. Taha parip si, te za tãma asõpru, 'Re ĩhâimana u'âsi mono ma, Mozésihi nhimiroti zarina, dama aipibu pese zéb da, aipesezém na hã. — Ãne te tãma tinha, Zezusi hã. ");
INSERT INTO xavNT_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Tane nherẽ, ma tô Zezusihi wasu'u hã wapari za'ra ni, daro mono bâ. Taha wa, ma tô da'ahâ na ĩtẽme 're dasihutu, da te 're wapari za'ra mono da. Duré te te 're da'apese mono da, ma tô ĩtẽme 're dasihutu. ");
INSERT INTO xavNT_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Tane nherẽ, Zezusi hã ma tô dawi 're ne, a'ubuni u, 're mreme mono da, Timama ma. ");
INSERT INTO xavNT_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Tawamhã apâ datẽme wisi wamhã, te nimahã bâtâ na dama rowasu'u, Zezusi hã. Te te dama rowasu'u ré, te ĩ'rata ai'ubumro, parisezu norĩ hã. Rowahutu'wa norĩ me, te ĩ'rata ai'ubumro, 'Re ĩhâimana u'âsi mono nhimiroti 'rata na rob'ui'éré na dama rowahutu'wa norĩ hã. Ta norĩ hã ma tô ĩtẽme sito Darireza hawi, duré Zudeza hawi, duré Zeruzarẽ hawi. Tawamhã 'Re ĩhâimana u'âsi mono tiwaihu'u pe hã, te te tãma ĩsõmri na, ma tô da'apese, Zezusi hã. ");
INSERT INTO xavNT_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Tawamhã aibâ norĩ hã, ĩhi'ré hã ma tô siwi ti'â, ĩsimiwaptâ wa. Ma tô sima wẽ za'ra, 'ri para u te te siwi 'mazébré da, Zezusihi nho're te te siwi hiri da. ");
INSERT INTO xavNT_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Tazahã da'ahâ wamhã, te te siwi 'mazébré waihu'u õ di. Tawamhã 'ri nhisi hawi, ma tô tãma 'ri 're pu'u za'ra, te te siwi 'mazébré da. Tawamhã dawa'wa ma tô siwi tihi, Zezusihi nho're, ĩsa'warizéb ré. ");
INSERT INTO xavNT_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Zezusi hã simiwaihu'u pese wa, ma tô ãma saze za'ra. Taha wa, ma tô siwi ti'â, te te pese da. Zezusi ma tô sina waihu'u siro, te te ãma ĩsaze za'ra na. Taha wa, te ĩhi'ré ma tinha, ãne: — Ĩ̱siwadi, aiwasédé hã 're ĩ'ab'manharĩ wasété mono zé hã te ai'ãma 're ab'madâ'â mono õ di za oto. — Ãne te ĩhi'ré ma tinha, ãne: ");
INSERT INTO xavNT_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Tawamhã rowahutu'wa norĩ hã te parisezu norĩ me tãma nharĩ za'ra, tipẽ'ẽ na: — E niha ma tô bété õ hã tãma tinha, ĩmorĩ'õ ma. 'Re ĩhâimana u'âsi mono ma, wẽ õ di, aibâ ma, te te ĩnharĩzé hã. Dawasédé hã da te 're ĩ'manharĩ wasété za'ra mono zé hã, ni'wa hã te te dama 're apari waihu'u mono õ di. 'Re ĩhâimana u'âsi mono ma si, waihu'u pese di, dawasédé hã te te dama 're ĩ'apari mono da hã. — Ãne te Zezusihi ma nharĩ za'ra, tipẽ'ẽ na. ");
INSERT INTO xavNT_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Tawamhã Zezusi ma tô sina waihu'u za'ra, ĩsimirosa'rata za'ra hã. Taha wa, te tãma nharĩ za'ra: — E marĩ da, te ãne ĩ̱'ãma ĩrosa'rata za'ra wa'wa. ");
INSERT INTO xavNT_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","24","Wa hã dawasédé hã te dama 're ĩ'apari waihu'u pese mono na, e niha te za ĩwaihu'u za'ra wa'wa, sena na ĩ̱waihu'u za'ra wa'aba da hã. Aibâ ma, wa tô tinha, ãne: “Aiwasédé hã 're ĩ'ab'manharĩ wasété mono zé hã, te ai'ãma 're ab'madâ'â mono õ di za oto.” Ãne hã ĩ̱mreme si wamhã, aima pibu prã za'ra wa'aba di tô. Ã hã ĩmorĩ'õ hã wahutu da, duré oto morĩ da, te tãma nharĩ wapsi, te za ĩwaihu'u za'ra wa'wa, ĩ̱waihu'u pese na sena na ĩ̱waihu'u za'ra wa'aba da oto. Ti'ai ãma dasiré ĩ̱podo hã ĩ̱ma waihu'u pese di, dawasédé te dama 're ĩ'apari mono da hã, 'Re ĩhâimana u'âsi mono zadawa para. Ãne na asiwi ĩ̱waihu'u za'ra wa'aba da, wa za ĩhi'ré ma tinha, wahutu da. Tawamhã ĩhi'ré ma, te oto tinha: — Ma'ãpé, aiwahutu. Asa'warizé hã âri, asõrõwa u aimorĩ da oto. — Ãne te aibâ ma tinha. ");
INSERT INTO xavNT_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Tawamhã awa'awi ma tô aibâ hã wahudu, danho'a. Tiza'warizé, ma tô siré ti'â. Tinhorõwa u, te oto mo. Morĩ sina, te ãma tiwata, 'Re ĩhâimana u'âsi mono ãma. ");
INSERT INTO xavNT_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Tawamhã uburé ma tô ãma tatob'uzu za'ra ni. 'Re ĩhâimana u'âsi mono ãma, te tawata za'ra ni. Ãne te dasima nharĩ za'ra ni: — Aibâ te te ĩpesezé hã, wẽ uptabi di. Ãhãna, wa tô wasiwi 'madâ'â za'ra ni. — Ãne te dasima nharĩ za'ra ni. ");
INSERT INTO xavNT_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Tawamhã rob u, ma tô watobro, Zezusi hã. Watobro wamhã, ma aibâ hã 'madâ, danhib'apito ma, dawi rob'uiprazé ubumroi'wa hã, Réwi na ĩsisi hã. Ĩsimiromhurizéb ãma sãmra ré, ma tô 'madâ. Tame te da te tãma 're sõmri za'ra rob'uiprazé hã, ĩ'ubumrozéb ãma, danhib'apito nhimiwada'uri zarina. Tawamhã Zezusi hã ma tô ãne 'mahâ: — We aimorĩ, ĩ̱siré 're aimorĩ da oto. ");
INSERT INTO xavNT_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Tawamhã ma wahudu. Tinhimiromhurizé, ma tô tirẽ, Zezusihi siré 're morĩ da oto. ");
INSERT INTO xavNT_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Tawamhã Zezusi te te sawi da, ma tô tinhorõwa ãma dasa hã dama 'manha, sa'ẽtẽ na. Zezusihi siré, te za dasa hã huri ni. Taha wa, rob'uiprazé ubumroi'wa norĩ hã te ĩ'rata ai'ubumro, ĩsiré saihuri da, da'ahâ na. Ni'wam norĩ zama, te ĩsiré tisa tihu. ");
INSERT INTO xavNT_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Tawamhã saihuri da, si'ubumroi ré, ma tô 'madâ'â za'ra parisezu norĩ hã, rowahutu'wa norĩ me. Taha wa, te ãne tãma nharĩ za'ra, Zezusihi siré 're ĩnomro mono norĩ ma: — E niha bâ, te bété dawazari asaihuri 'wa, rob'uiprazé ubumroi'wa norĩ siré, dawasété na 're ĩdanomro mono norĩ siré zama. — Ãne te tãma nharĩ za'ra. ");
INSERT INTO xavNT_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Taha wa, te Zezusi hã tãma nharĩ za'ra, ãne: — Hâzé ãna 're ĩnomro mono norĩ zô, dawede'wa hã 're siwasutu za'ra mono õ di, te te 're wede za'ra mono da. Ĩhâzé ré norĩ zô si te za 're siwasutu za'ra, te te 're pese za'ra mono da. ");
INSERT INTO xavNT_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Tane duré wa hã, dawẽ na 're ĩdanomro mono norĩ zô, ĩ̱sitẽme 're ĩ̱hârâ mono da, we ĩ̱morĩ õ di. Dawasété na 're ĩdanomro mono norĩ zô si, 're ĩ̱hârâ mono da, wa wei mo, dawasédé hã da te 're rẽme pese za'ra mono da, 're danomro wẽ mono da oto. — Ãne ma tô Zezusi hã tãma waihu'u za'ra. ");
INSERT INTO xavNT_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Tawamhã ni'wam norĩ hã te Zezusihi ma nharĩ za'ra, ãne: — Zuwã Batitaha siré 're ĩnomro mono norĩ hã nimahã bâtâ na si, te sai ãna 're si'ubumro, 'Re ĩhâimana u'âsi mono ma, te te 're romhuri za'ra mono da, parisezu norĩ zadawa 'madâ'â pese 'wa norĩ zama. Ãnei õ di, asiré 're ĩnomro mono norĩ hã. Te 're saihuri u'âsi, asiré. Te duré asiré te te 're âhuri. Ãne te Zezusihi ma nharĩ za'ra. ");
INSERT INTO xavNT_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Taha wa, te Zezusi hã asa tãma nharĩ za'ra: — Aibâ hã ĩmrozéb u, sô ĩhârâ za'ra norĩ hã sihutu wamhã, e te za dasa hã tiwi sawi za'ra ni, saihuri ãna si'ubumro da, ta norĩ hã. Mare di. Aibâ ĩmro da hã, ĩ'rata sãmra za'ra ré, te za tô ĩsiré tisa tihu, to sina. ");
INSERT INTO xavNT_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Niwapsi te za bâdâ hã ĩwa waptãrã, aibâ ĩmro da hã ĩsiwadi norĩ wa'wa hawi, da te tiwi ĩ'âri za'ra zéb da hã. Tawapsi te za tô sai ãna 're si'ubumro, robzei ãna. — Ãne ma tô Zezusi hã tãma rowasu'u za'ra. Ãne sõ'awib õ nherẽ, te te si'ãma ĩsimiré'ézé hã. ");
INSERT INTO xavNT_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Tawamhã te duré ãma romnhimiré'é, ãne: — Zazahâ ĩhâiwẽ hã e te za sizâri ni, ĩhâ'ratare hã da te ãma hâiwa'aba da. Mare di. Ãne wamhã, te za aiwamna, ĩhâiwẽ hã. Duré ĩhâtém na da te hâiwa'aba wamhã, aiwab õ di, ĩhâ hã. Hâiwẽ hâ õ di. ");
INSERT INTO xavNT_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Duré e romhâ 'manharĩ 'rata 're, te za uwa 'rãi wa'u ĩsé hã da te 're sé, wa'ui ware õ ré. Mare di. Wa'ui ware õ ré, da te 're séme mono wamhã, oto wa'ui ware wamhã, te za romhâ 'manharĩ 'ratare hã sina wazu. Tawamhã uwa 'rãi wa'u ĩsé hã te za asa'wa. Romhâ 'manharĩ hã te za duré hâihaiwamna. ");
INSERT INTO xavNT_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Ĩtép si'uiwa na si, te za da te 're sé, rob'rãi wa'u zé té hã. — Ãne te Zezusi hã tãma rowasu'u za'ra. ");
INSERT INTO xavNT_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Te duré tãma ãma simiré'é za'ra: — Uwa 'rãi wa'u ĩsé ĩ'ratare hã da te 're âhuri mono pari, e te za da te dasima 're wẽ za'ra, uwa 'rãi wa'u zé ĩté hã. Mare di. Ãté ĩté hã da te dasima 're wẽ za'ra mono õ di za. Te za dasima da te 're nharĩ za'ra: “Ĩwa'u 'ratare si, wẽ uptabi di.” Ãne te za dasima da te 're nharĩ za'ra. — Ãne te Zezusi hã tãma ãma simiré'é za'ra, sõ'awib õ nherẽ. ");
INSERT INTO xavNT_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Tawamhã sabadu na, Zezusi norĩ hã ma tô ro'rahâri za'ra, amnho wa'wai baba, zudezu norĩ te, romhuri zahârizém na. Tawamhã tridu 'rã ne hã ma tô te te sima 'rãnhinarĩ, tinhib'rata na te te sima tomhâiwazu za'ra da, te te huri mono da, ĩsiré 're ĩnomro mono norĩ hã. ");
INSERT INTO xavNT_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Tawamhã parisezu norĩ hã te tãma nharĩ za'ra: — Wahi'rada Mozési hã ma tô wama roti, sabadu na, wa te 're romhuri za'ra mono tõ da. E marĩ da, te bété ĩromhuri za'ra wa'wa, ãne te te wama roti õ nherẽ. — Ãne te tãma nharĩ za'ra. ");
INSERT INTO xavNT_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Tawamhã Zezusi te asa tãma nharĩ za'ra, ãne: — E apito Dawihi wasu'u na rob'ui'éré hã 're sõré za'ra wa'aba mono ã bâ, te te ĩrob'manharĩzém na hã, tisiré norĩ me. ");
INSERT INTO xavNT_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Mra te te simroi wamhã, ma tô ãzé 'ri para u, 'Re ĩhâimana u'âsi mono ãma 're ĩdawata za'ra mono zéb u. Tawamhã sébré wamhã, ma tô 'ma'rẽ ĩ'u'ẽne hã, 'Re ĩhâimana u'âsi mono ma, aré da te ĩsa'ra za'ra hã. Duré tisiré norĩ ma, ma tô tãma a za'ra. 'Re ĩhâimana u'âsi mono, ma tô aré pisutu, da'ãma romhuri'wa norĩ si, ĩ'u'ẽne hã te te 're ĩhuri mono da hã, sasedoti norĩ si. Tane nherẽ, ma tô 'ma'rẽne za'ra, Dawi norĩ hã. — Ãne Zezusi hã ma tô parisezu norĩ ma Dawihi wasu'u hã 'rãzarõtõ za'ra. ");
INSERT INTO xavNT_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Te duré tãma nharĩ za'ra: — Wa hã 'Re ĩhâimana u'âsi mono te te ĩ̱pisudu, dasiré ĩ̱poto da, ti'ai ãma. Taha wa, dama ĩ̱pire di, sabadu na roti hã te dama 're ĩ'apisutu mono zéb da hã. — Ãne ma tô tãma waihu'u za'ra, Zezusi hã. ");
INSERT INTO xavNT_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Tawamhã sabadu ĩhâiba amo na, ma tô duré ãzé zudezu norĩ te, rowahutuzéb u, Zezusi hã. Tame te duré aibâ hã dame nhamra, ĩsimire niwĩ ĩsimizu'rã're hã. ");
INSERT INTO xavNT_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Tawamhã 'Re ĩhâimana u'âsi mono nhimiroti 'rata na rob'ui'éré na dama rowahutu'wa norĩ hã ma tô siwi 'madâ Zezusi hã, sabadu na te te pese zô, romhuri zahârizém na hã. Parisezu norĩ me, te simiza'rese sina 'madâ'â za'ra. Mozésihi nhimiroti te te 'madâ'â õ wa, te te siwi wẽ'õ da, te 'madâ'â pese za'ra. ");
INSERT INTO xavNT_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Tawamhã Zezusi ma tô sina waihu'u za'ra, ĩsimirosa'rata za'ra hã. Tawamhã aibâ ma, te tinha: — Aiwahutu, dawa'wa asab da. — Ãne te tãma tinha. Tawamhã aibâ ma tô wahudu. Hâiwi te za. ");
INSERT INTO xavNT_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Tawamhã Zezusi ma tô ãma sadanharĩ za'ra, ãne: — Wa za asadanharĩ za'ra wa'wa. E niha 'Re ĩhâimana u'âsi mono nhimiroti hã, sabadu na hã, romhuri zahârizé bâtâ na roti hã. E ma hã ĩwẽ, wa te 're ĩ'manharĩ za'ra mono zéb da hã sabadu na hã. E ma hã ĩwẽ'õ. E wa te ãma 're dapawaptob za'ra mono õ di za. E wa te ãma 're danho'reptu za'ra mono õ di za. E niwamhã wa za taré wa te 're da'madâ'â za'ra, 're dadâ'â za'ra mono da. — Ãne te Zezusi hã sadanharĩ za'ra. ");
INSERT INTO xavNT_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Tawamhã Zezusi te ab'madâ, te te siwi ĩ'uirĩ za'ra norĩ hã. Tawamhã ĩsimizu'rã're ma, te tinha: — Ma'ãpé, asimizu wahutu. — Tawamhã ma tô tinhimizu wahutu, aibâ hã. Tawamhã awa'awi ma tô tinhimizu pese. ");
INSERT INTO xavNT_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Tawamhã rowahutu'wa norĩ hã ma tô sada tizahi za'ra, Zezusihi zada. Tawamhã te sima rosa'rata za'ra, marĩ hã te te tãma 'manharĩ za'ra da. ");
INSERT INTO xavNT_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Tawamhã ẽtẽ 'rãihâ na ma tô Zezusi hã sai'u, 'Re ĩhâimana u'âsi mono ma, mreme da. Tawamhã mara bâ te tãma mre. ");
INSERT INTO xavNT_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Taha wa, awẽ wi ma tô sô tihârâ za'ra, tizazei'wa norĩ zô. Tawamhã ĩtẽme sihutu wamhã, ma tô pisutu za'ra, 12 na ĩhâiba za'ra hã ĩsiré 're nomro mono da. Ma tô oto sisi za'ra, tizadawa wasu'u'wa na. ");
INSERT INTO xavNT_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Ta norĩ nhisi za'ra hã ãne: Sima Pedru, tinoi me, Ãdéréhé me. Pedru na te za sisi té, Zezusi hã. Duré Ti'adu norĩ hã tisisãnawãi me Zuwãhã me, duré Piripi norĩ hã, Batoromezuhu me, ");
INSERT INTO xavNT_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","duré Mateusi norĩ hã, Tomehẽ me, duré Ti'adu, Apezuhu 'ra hã, duré Sima Zeroti, ");
INSERT INTO xavNT_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","duré Zudasi Ti'aduhu 'ra hã, duré Zudasi Icarizoti hã, dama ĩhâiba nhomri'wa da hã. ");
INSERT INTO xavNT_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Tawamhã Zezusi norĩ hã ma tô sa'a hawi si'ra za'ra. Tawamhã ti'ai haré u sihutu õ ré, te a'â nhamra, sõnhihâpâ ãma, tizazei'wa norĩ me. Ĩsazei'wa norĩ hã ahâ di. Tame duré da'ahâ uptabi na, te sô ai'ubumro ni. Daro mono bâ, ma tô ĩwana sô tasi'rã'õtõ ni, Zudeza na danhipti'a nho'õmo nhisi hawi, duré Zeruzarẽ hawi, duré Tiru na 'ri nho'õmo nhisi hawi, duré Sido hawib zama. Â zaihâ na Tiru hã, duré Sido hã, 'ri nho'u. ");
INSERT INTO xavNT_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Zezusihi mreme hã da te wapari za'ra da, ma tô ĩtẽme dasito. Duré te te da'apese da zama, ma tô ĩtẽme ai'aba'ré ni, duré wa'uburé te te dama anhamra da. Tawamhã ma tô dama anhamra. ");
INSERT INTO xavNT_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Simipese waihu'u pese wa, ma tô dasima wẽ za'ra ni, danhib'rata na da te upi za'ra da, rowẽ na oto 're dasi'ubumroi mono da. ");
INSERT INTO xavNT_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Tawamhã Zezusi hã te tisiré 're ĩnomro mono norĩ hã 'madâ'â pese za'ra. Taha wa, te ãne tãma nharĩ za'ra: — Ãté asibrob ãna, te oto 're anomro aba mo. Tane nherẽ, aima 're robze za'ra wa'aba mono di za. 'Re ĩhâimana u'âsi mono hã, Danhib'apito uptabi. Taha wa, ĩsib'a'uwẽ 're anomro aba mono wa, aima 're robze za'ra wa'aba mono di za. ");
INSERT INTO xavNT_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","— Ãté mra, te oto 're ĩsépata za'ra wa'aba mo. Tane nherẽ, te za robze na 're aihâimana za'ra wa'aba mo. Niwapsi mra hã, ahâ di za. — Ãté te oto 're ai'ry'ry wa'aba mo, aipẽ'ẽzé za'ra wa'aba wa. Tane nherẽ, te za robze na 're aihâimana za'ra wa'aba mo. Niwapsi te za aipẽ'ẽ 're, 're ato za'ra wa'aba mo, rowẽ te. ");
INSERT INTO xavNT_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","— Wa hã ti'ai ãma dasiré ĩ̱podo. A norĩ wa'wa hã ĩ̱zazei'wa, 're anomro aba mono wa, ãté te za da te 're ai'ruiwapari za'ra wa'wa. Ãté te za da te 're aiwẽ'õ za'ra wa'wa. Ãté te za da te aima 're nharĩ wasété za'ra wa'wa. Ãté aiwasédé hã te za taré da te ai'ãma 're sa'ra za'ra wa'wa. Ãne wamhã, te za robze na 're aihâimana za'ra wa'aba mo. ");
INSERT INTO xavNT_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Rowẽ te, te za 're asarõtõ za'ra wa'aba mo. A norĩ wa'aba ma si, rowasédé hã da te aima 're 'manharĩ za'ra wa'aba mono õ di za. Wahi'rata norĩ ma, ma tô rowasédé hã da te aima 're 'manharĩ za'ra duré, 'Re ĩhâimana u'âsi mono zadawa wasu'u 'rata 'wa norĩ ma. Taha wa, da te 're ai'ruiwapari za'ra wa'aba mono nherẽ, aima 're rowẽ za'ra wa'aba mono di za. Niwapsi, 'Re ĩhâimana u'âsi mono, te za marĩ ĩwẽ hã te te aima 're sõmri za'ra wa'wa, hâiwa ãma asô 're ĩsimi'wara aba mono hã. Taha wa, aima 're rowẽ za'ra wa'aba mono di za. — Ãne romhâ ré ma tô tãma waihu'u sirõmo za'ra, tisiré 're ĩnomro mono norĩ ma. ");
INSERT INTO xavNT_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Taha pari, te uburé dama tinha oto: — Ãté asibrob ahâ na, te a'â 're aihâimana za'ra wa'aba mo. Niwapsi tâibâ za oto asibrob ahâ za'ra wa'wa hã. Tawamhã robzei õ na, te za 're ai'ubumroi wa'aba mo. ");
INSERT INTO xavNT_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","— Ãté asai ahâ na, te a'â 're aihâimana za'ra wa'aba mo. Niwapsi, te za mra hã 're ĩsépata za'ra wa'aba mo. Tawamhã te za robzei õ na 're aihâimana za'ra wa'aba mo. — Ãté rowẽ te, te a'â aipẽ'ẽ na 're ato za'ra wa'aba mo. Niwapsi te za robzei ãna 're asimroi wa'aba mo. Tawapsi te za 're ai'ry'ry wa'aba mo. ");
INSERT INTO xavNT_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","— Tane duréihã ma tô aibâ norĩ ãma 're dawata za'ra. 'Re ĩhâimana u'âsi mono zadawa wasu'u uptabi 'wa newa, ma tô ãma 're dawata za'ra, wahi'rata norĩ hã. Taha wa, a'â ai'ãma 're dawata za'ra wa'aba mono nherẽ, niwapsi aima 're rowẽ za'ra wa'aba mono õ di za. — Ãne ma tô dama rowasu'u, Zezusi hã. ");
INSERT INTO xavNT_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","Te duré dama tinha: — Ĩ̱wapari'wa norĩ, wa za aima waihu'u za'ra wa'wa, ãne hã: Asawi'õ'wai wa'aba norĩ hã te za 're ĩsawi pese za'ra wa'aba mo. Duré ai'ruiwapari'wa norĩ ma, te za marĩ tãma 're ĩ'manharĩ wẽ za'ra wa'aba mo, ĩwẽ na. ");
INSERT INTO xavNT_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Duré da te aima 're nharĩ wasété za'ra wa'aba mono nherẽ, te za da'ãma 're aimreme zusi aba mo, 'Re ĩhâimana u'âsi mono ma, ĩwẽ hã te te dama 're anhomri mono da. Da te aima 're rob'manharĩ wasété za'ra wa'aba mono nherẽ, te za 'Re ĩhâimana u'âsi mono wi 're ĩrowaptẽrẽ za'ra wa'aba mo, te te 're da'apawapto mono da. ");
INSERT INTO xavNT_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Ai'u'rata wi, da te 're aihâ za'ra wa'aba mono wamhã, dama ãma 're wa'rãmi za'ra wa'aba mono õ di za. Taré te za 're aipizari za'ra wa'aba mo, ai'u'rata amo niwĩ, da te 're aihâ za'ra wa'aba mono da. Duré asi'ubuzé hã da te aiwi 're waibui wa'aba mono wamhã, dawi 're sawi za'ra wa'aba mono õ di za, asõ'utu'u zama, da te aiwi 're waibui wa'aba mono da. ");
INSERT INTO xavNT_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Marĩ hã da te aiwi 're waptẽrẽ za'ra wa'aba mono wamhã, te za dama 're ĩsõmri za'ra wa'aba mo. Ãté ni'wa hã te za asibro hã aiwi âri 'wa. Tawamhã sô aihârâ õ di za, apâ te te aima sõmri da. ");
INSERT INTO xavNT_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Marĩ ĩwẽ si, da te aima 're 'manharĩ za'ra wa'aba mono da, asima 're ĩdawẽ za'ra wa'aba mono ne, te za marĩ ĩwẽ si dama 're ĩ'manharĩ u'âsi za'ra wa'aba mo, ĩwa'rãmi. ");
INSERT INTO xavNT_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","— Siwa'ru, te za 're ĩdazawi pese za'ra wa'aba mo. Dawasété na 're ĩdanomro mono hã, tizawi pese 'wa si, te te 're sawi pese za'ra. Tanei õ di, a norĩ wa'wa hã za. Ãne wamhã, ĩwẽ na te te 're asawi za'ra wa'aba mono õ di za, 'Re ĩhâimana u'âsi mono hã. Taha wa, te za uburé 're ĩdazawi pese za'ra wa'aba mo. ");
INSERT INTO xavNT_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Duré, uburé te za marĩ hã dama 're ĩ'manharĩ wẽ za'ra wa'aba mo. Dawasété na 're ĩdanomro mono norĩ hã, tizawi pese 'wa norĩ ma si, te za te te tãma 're 'manharĩ wẽ za'ra. Tanei õ di, a norĩ wa'wa hã za. Ãne wamhã, e niha te za 're ĩ'umnhasi za'ra wa'aba mo, ĩwẽ na te te aima ãma 're ĩ'a'uwaimrami aba mono da hã, 'Re ĩhâimana u'âsi mono hã. Taha wa, te za marĩ hã uburé dama 're ĩ'manharĩ wẽ za'ra wa'aba mo. ");
INSERT INTO xavNT_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Duré, uburé te za dama 're asõprub za'ra wa'aba mo. Ãté marĩ hã te za da te aiwi 're waptẽrẽ za'ra wa'wa, a'â dama 're sõmri za'ra wa'aba mono da. Tawamhã te za dama 're ĩsõmri za'ra wa'aba mo, ĩwa'rãmib zô 're asimnhasi za'ra wa'aba mono ãna. Dawasété na 're ĩdanomro mono hã te marĩ hã tisiré norĩ ma si, te te 're sõmri za'ra, te te siwi 're waptẽrẽ za'ra mono wamhã. Tawamhã te duré ĩwa'rãmib zô 're simnhasi za'ra. Tanei õ di, a norĩ wa'wa hã za. Ãne wamhã, ĩwẽ na te te 're asawi za'ra wa'aba mono õ di za, 'Re ĩhâimana u'âsi mono hã. Taha wa, te za uburé dama 're asõprub za'ra wa'aba mo. ");
INSERT INTO xavNT_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Dawasété na 're ĩdanomro mono ne, 're anomro aba mono õ di za. Uburé te za 're ĩdazawi pese za'ra wa'aba mo. Asitob'ru norĩ zama, te za 're ĩsawi pese za'ra wa'aba mo. Uburé te za marĩ hã tãma 're ĩ'manharĩ wẽ za'ra wa'aba mo. Ãté marĩ hã te za da te aiwi 're waptẽrẽ za'ra wa'wa, syry na a'â dama 're sõmri za'ra wa'aba mono da. Tawamhã te za tãma 're ĩsõmri za'ra wa'aba mo. Ĩwa'rãmib zô 're asimnhasi za'ra wa'aba mono õ di za. Ãne wamhã, te za ĩwẽ na te te 're asawi za'ra wa'wa, 'Re ĩhâimana u'âsi mono hã. Ĩ'ra te za 're aihâimana za'ra wa'aba mo, danhipai u ĩpire uptabi 'ra hã. Marĩ wẽ na, uburé te dama 're sõpru. Ĩsõprum na ãma 're ĩdawata za'ra mono õ norĩ ma zama, te dama 're sõpru. Dawasété na 're ĩdanomro mono ma zama, te 're sõpru. ");
INSERT INTO xavNT_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Taha wa, te za Aimama aba ne, 're anomro aba mo, aiwẽ na. — Ãne ma tô Zezusi hã tãma roti za'ra. ");
INSERT INTO xavNT_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","Ma duré tãma waihu'u za'ra, ãne: — Dawasédé hã da'ãma 're ĩsa'ra za'ra wa'aba mono zéb zarina, asiwi 're dawẽ'õ za'ra wa'aba mono õ di za. Tawamhã te te siwi 're aiwẽ'õ za'ra wa'aba mono õ di za, 'Re ĩhâimana u'âsi mono hã. Dawasédé hã da'ãma 're ĩsa'ra za'ra wa'aba mono zéb zarina, dama 're nharĩ za'ra wa'aba mono õ di za. Tawamhã 'Re ĩhâimana u'âsi mono, te te aima 're anharĩ aba mono õ di za. Marĩ, da te aima 're ĩ'manharĩ wasété za'ra wa'aba mono zé hã, asina 're 'madâ'â za'ra wa'aba mono õ di za. Tawamhã aiwasété'wa hã te te 're ab'madâ'â mono õ di za, 'Re ĩhâimana u'âsi mono hã. ");
INSERT INTO xavNT_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Asibrom na te za dama 're asõprub za'ra wa'aba mo, ĩsimarĩ'õ norĩ ma. Tawamhã 'Re ĩhâimana u'âsi mono hã te za marĩ hã ĩwa'rãmi sa'ẽtẽ na te te aima 're sõmri za'ra wa'wa. Marĩ na asima 're asõprub za'ẽtẽ za'ra wa'aba mono ne, te za aima 're sõprub za'ẽtẽ za'ra wa'wa. Sa'ẽtẽ na dama 're sõmri za'ra wa'aba mono wamhã, te za sa'ẽtẽ na te te aima 're sõmri za'ra wa'wa, ĩwa'rãmi, 'Re ĩhâimana u'âsi mono hã. Syry na dama 're sõmri za'ra wa'aba mono wamhã, te za syry na te te aima 're sõmri za'ra wa'wa. — Ãne ma tô Zezusi hã tãma waihu'u za'ra. ");
INSERT INTO xavNT_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Tawamhã ãne te tãma ãma romnhimiré'é za'ra: — Ni'wam norĩ hã tob'a zahuré wamhã, nimomo sisaprõni zahuré wamhã, sisaprõni wẽ zahuré õ di za. Te za siré tiwaptã'ã zahuré, ab're u. — Ãne ma tô tãma rowasu'u za'ra. ");
INSERT INTO xavNT_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Te duré tãma rowasu'u za'ra, ãne: — Romnhoré'wa norĩ hã te te 're romnhoré za'ra mono ré hã, pire na 're hâimana waihu'u za'ra mono õ di, tãma ĩromnhoré'wa norĩ ma hã. Niwapsi te te 're uprosi za'ra mono wapsi, te za te te 're waihu'u za'ẽtẽ za'ra, tãma ĩromnhoré'wa ne hã. — Ãne ma tô tãma rowasu'u za'ra. ");
INSERT INTO xavNT_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","Te duré tãma rowasu'u za'ra, ãne: — Ãté wede wa'õno hã atob 're, te nomro, sabui õ nherẽ. E niha te za bété sô ĩtõmo 'madâ, wede nhiprubre wazere da, asisãnawã tõmo hawimhã. ");
INSERT INTO xavNT_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Wede wa'õno hã atob 're ĩnomro, sabui õ nherẽ, e niha te za tãma ĩnha: “Ropru hã a'â te aima wazere, atõmo hawimhã.” Mare di. Wede wa'õno hã te za a'â atõmo hawimhã ĩwaze. Tawamhã te za sô airĩtĩ wẽ, wazere da, asisãnawã tõmo hawimhã, wede nhiprubre hã. — Ãne ma tô Zezusi hã tãma rowasu'u za'ra. ");
INSERT INTO xavNT_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","45","Tawamhã Zezusi ma tô da'ãma ãma romnhimiré'é, rob'rã na, ãne: — Rowede hã wẽ wamhã, 're 'rãi wasété za'ra mono õ di za, wede wẽ wa. Wasété wamhã, 're 'rãi wẽ za'ra mono õ di za, wede wasété wa. 'Re 'rãi wẽ za'ra mono wamhã, te za ãma waihu'u za'ra ni, rowede ĩwẽ na. E wab'ru u, te za 're aimo, rob'rã ĩse zô. Mare di. Wab'ru na 're simnhatã mono õ di, rob'rã ĩse hã. E aptob u, te za 're aimo, rob'rã ĩse zô. Mare di. Aptom na 're simnhatã mono õ di, rob'rã ĩse hã. Ãne ni'wa hã 're morĩ wẽ wamhã, tipẽ'ẽ 're, tinhimirosa'rata wẽ hawim na, te za 're mreme wẽ u'âsi. Duré ni'wa hã 're morĩ wasété wamhã, tinhimirosa'rata wasété hawim na, te za duré 're mreme wasété u'âsi. Danhimirosa'rata zarina, te za tô õne u'âsi 're damreme zusi. — Ãne Zezusi ma tô tãma waihu'u za'ra. ");
INSERT INTO xavNT_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","Te duré tãma nharĩ za'ra, ãne: — E marĩ da, ma tô Asib'apito na asiwi 're ĩ̱nhisi za'ra wa'aba mo, ĩ̱nhimiroti hã 're 'madâ'â pese za'ra wa'aba mono õ nherẽ. ");
INSERT INTO xavNT_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Ãté ni'wam norĩ hã te za we ĩ̱tẽme aihutu, ĩ̱nhimiroti hã te te wapari za'ra da. Tawamhã te te wapari za'ra wamhã, te za oto ĩ̱nhimiroti hã te te 're 'madâ'â pese za'ra. ");
INSERT INTO xavNT_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Taha wa, wa za ĩ̱nhimiroti 'madâ'â'wai ãma simiré'é, 'ri'wa na. Aibâ hã ma tô ab're, 'ri da, ti'ai 'rowi ẽne hã ĩnomro u. Tawamhã ma tô ãma tipahâ, ab're na. Ab're 'rehâ di oto. Tawamhã ẽtẽ nhisiwi ma tô 'ri, aibâ hã. Tawamhã âpré wamhã, â hã ma tô 're praba, 'ri u. Tete na ma tô 'ri hã 'manha, aibâ hã. Taha wa, rési ãna te 're sa, 'ri hã. ");
INSERT INTO xavNT_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Ãté ni'wam norĩ hã te za ĩ̱nhimiroti hã tipo're na te te 're wapari za'ra. Tane nherẽ, te te 're 'madâ'â za'ra mono õ di za, ĩ̱nhimiroti hã. Taha wa, wa za ĩ̱nhimiroti 'madâ'â'õ'wai ãma simiré'é, 'ri'wa ĩhâiba amo na. Aibâ hã 'ri na'rata da, te te ab're õ di. Ti'a nhisiwip si, ma tô sima 'ri. Tawamhã 'ri u, â 're praba mono wamhã, â, ma tô 'marõwĩ, 'ri hã. Tâibâ oto. Taha wa, ma tô aipru pese, 'ri hã. — Ãne ma tô 'ri'wa na simiré'é dama Zezusi hã, da te waihu'u za'ra da. ");
INSERT INTO xavNT_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Tawamhã te te dama roti parimhã, te oto mo Zezusi hã, Capana'u na 'ri nho'õmo nhisi u. Tawamhã ma tô wi. ");
INSERT INTO xavNT_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Tame aibâ hã te 're hâimana romanu hã, da'wapéi'wa norĩ wada'uri'wa. Tãma ĩromhuri'wa hã te te sawi pese di. Hâzé na te oto nomro, tãma ĩromhuri'wa hã. Hâzé ahâ wa, te za oto dârâ. ");
INSERT INTO xavNT_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Tawamhã hâzé na nomro ré, ma tô Zezusihi wasu'u hã wapa, romanu hã. Taha wa, ma tô zudezu norĩ ma roti'wa norĩ hã 'mazatõrĩ za'ra, Zezusihi zô, ĩhâzé ré hã te te pese da. ");
INSERT INTO xavNT_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Tawamhã te te sô ĩsatõrĩ za'ra hã ma tô ĩtẽme aihutu, Zezusihi u. Ĩtẽme sihutu wamhã, ma tô tãma rowasu'u za'ra: — Aibâ hã ĩwẽ, romanu hã. Wẽ wa, pawapto na. ");
INSERT INTO xavNT_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Wasiré õ nherẽ, te te 're wa'azawi pese. Taha wa, ma tô ĩsiminhimi'ru zarina wama 'ri za'ra ni, wate da, rowahutuzé hã. Ta hã ma tô duré pawa'âbâ za'ra, 'ri'wa norĩ hã. — Ãne te Zezusihi ma rowasu'u za'ra. ");
INSERT INTO xavNT_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Tawamhã Zezusi te ĩsiré timorĩ za'ra. Ma tô oto rosahutu za'ra, 'ri u. Te te rosahutu za'ra wamhã, romanu hã ma tô tisiwadi norĩ hã 'mazatõrĩ za'ra, te te tãma 'mazadawa wasu'u za'ra da, Zezusihi ma. Tawamhã te te uzusi za'ra wamhã, ãne te tãma 'mairowasu'u za'ra, Zezusihi ma: — Wasiwadi hã zudezu'õ nherẽ, ãté asébré õ di za, u, ĩsõrõwa u. A hã, u, aiwẽ di. Õ hã, u, wẽ prã ti. Wẽ prãi wa, ãté ĩsõrõwa u asébré õ di za, u. ");
INSERT INTO xavNT_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Wẽ prãi wa, si'uihâ na we atẽme morĩ õ di za, u, tãma ĩromhuri'wa hã tãma pese da. Romhâ na nherẽ, aimreme pire wa, te za, u, aimreme na tãma ĩpe, rowẽ na tãma 're sãmra mono da. ");
INSERT INTO xavNT_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Romanu hã, damreme ĩpire hã tãma waihu'u pese di, u. Ĩsib'apito norĩ mreme hã tãma pire za'ra di, u. Duré õ hã, u, ĩmreme hã pire di, tinhib'a'uwẽ norĩ ma, da'wapéi'wa norĩ ma. Tawamhã, te te 'mazatõrĩ wamhã, te za, u, mo, ĩsadawa para. Sô hârâ wa, te za u, ĩtẽme wi, ĩsadawa para. Duré marĩ hã tãma ĩromhuri'wai ma, te te 'rui wamhã, te za, u, tãma 'manha, te te tãma ĩ'ruzéb uwaibaba. Taha wa, aimreme hã pire wa, te za, u, tãma ĩpe, tãma ĩromhuri'wa hã, rowẽ na tãma 're sãmra mono da. — Ãne te Zezusihi ma sadawa wasu'u za'ra, romanuhu siwadi norĩ hã. ");
INSERT INTO xavNT_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Tawamhã Zezusi hã ãne hã te te wapari wamhã, ma tô ãma titob'uzu, ĩsimirowasu'u za'ra na, romanuhu ãma hã. Tawamhã ma aipi'ra, datẽme. Da'ahâ uptabi na ĩsarina ĩsi'aba'ré norĩ u, ma aipi'ra. Ãne te dama tinha: — Tô sena, wa aima waihu'u za'ra wa'wa. Ã hã te te sina ĩ̱'umnhasizém na hã, niwa te ĩ'madâ'â õ, Izarazéhé nhihudu norĩ nhipti'ai ãma hã. Ta norĩ hã te te ãma siwi wabzu õ di, te te sina ĩ̱'umnhasizém na hã. — Ãne Zezusi hã te tinha, ĩsarina ĩsi'aba'ré norĩ ma. ");
INSERT INTO xavNT_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Tawamhã apâ ma tô ai'aba'ré, romanu siwadi norĩ hã, ĩsõrõwa u. Sihutu wamhã, ma tô ĩhâzé ré hã sabu za'ra. Rowẽ na te oto nhamra, hâzé ãna. ");
INSERT INTO xavNT_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Tawamhã ãma ronomro õ ré, te Zezusi hã mo, 'ri wa'õtõ u. Na'ĩ na 'ri wa'õtõ nhisi u, te mo. Ĩsiré 're ĩnomro mono norĩ hã te ĩsiré ai'aba'ré. Da'ahâ na te duré ĩsiré ai'aba'ré ni. ");
INSERT INTO xavNT_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Tawamhã 'ri wa'õtõ 'wawi wa'ra u, ma tô rob'uwe za'ra, Zezusi norĩ hã, 'ridawa u. Tawamhã ĩwab'rere, ma tô dasiwi âri ni, ab're u, ĩmrotõ 'ra ĩdâ hã. Misire aibâ ĩ'ra hã. Da'ahâ na te ĩsiré ai'aba'ré ni, ĩmrotõ siré, ab're u. ");
INSERT INTO xavNT_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Tawamhã ĩmrotõ te te 'madâ'â wamhã, ma tô ãma tipẽ'ẽzé, Zezusi hã. Tawamhã ma tô tãma tinha, wawa tõ da. ");
INSERT INTO xavNT_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Tawamhã ma tô oto ĩtẽme wi. Te te âri za'ra ré, ma tinhib'rata na ĩré upi. Taha wa, ma ĩré mazahâri za'ra. Tawamhã te oto 'mahâ: — Ai'repudu, wa za aima tinha: Ai'utu. — Ãne te 'mahâ. ");
INSERT INTO xavNT_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Tawamhã ai'repudu hã ma tô udu. Sahâ na te oto nhamra. Tawamhã tãma rowẽ wa, te oto mre. Taha wa, te Zezusi hã ĩna ma ti'ru, ãne: — Ã ai'ra, ãma saprõni. — Ãne te tãma tinha. Dâ'â zahã, oto sahâ na sãmra wa, ma tãma tapẽ'ẽwara za'ra ni. ");
INSERT INTO xavNT_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Ãne te dasima nharĩ za'ra ni: — Tinhib'a'uwẽ norĩ hã te za we te te 're wa'apawapto, 'Re ĩhâimana u'âsi mono hã. Ma tô we watẽme satõ, tizadawa wasu'u'wa hã. Mreme pire uptabi di. — Ãne 'Re ĩhâimana u'âsi mono ãma, te tawata za'ra ni. ");
INSERT INTO xavNT_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Tawamhã ĩwasu'u hã ma tô wapari za'ra ni, daro mono bâ, Zezusi te te ĩhâiwa'utuzé wasu'u hã. Zudezu norĩ rob 'rata, 're ĩdasi'ubumroi mono norĩ zama, ma tô ĩwasu'u hã wapari za'ra ni. ");
INSERT INTO xavNT_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","19","Tawamhã Zezusi te te ĩhâiwa'utuzé hã ma tô Zuwãhã ma wasu'u za'ra, ĩsadawa 'madâ'â pese 'wa norĩ hã. Tawamhã maparane te sô tihârâ zahuré, Wanhib'apito u neb zahuré da, te te sadanharĩ zahuré da. Ãne Zuwã te tãma nharĩ zahuré: — Ane wa'aba wamhã, te za ĩsadanharĩ 'wa, ãne: “E a hã Zuwã Batita te te dama 're aiwasu'u mono, te we aimo. E zahadu aimawi zô, wa za 're wanhimipari za'ra.” Ãne te za tãma ĩ̱zadawa wasu'u wa'wa. — Ãne Zuwã hã ma tô tãma nharĩ zahuré. ");
INSERT INTO xavNT_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Tawamhã Zezusihi u, te tineb zahuré. Ĩtẽme simasisi wamhã, ma tô sadanharĩ zahuré: — E a hã Zuwã Batita te te dama 're aiwasu'u mono, te we aimo. E zahadu aimawi zô, wa za 're wanhimipari za'ra. — Ãne te sadanharĩ zahuré. ");
INSERT INTO xavNT_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Tawamhã ĩsõ'a zahuré, te a'â da'apese da'ahâ na, Zezusi hã. Duré wa'uburé ré, 're ĩdanomro mono hã ma tô dama anhamra. Duré ĩtob'a norĩ hã ma tô ato pese, ahâ na. ");
INSERT INTO xavNT_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Tawamhã te te da'apese parimhã, te oto tãma nharĩ zahuré, Zuwã Batitaha mreme 'madâ'â pese 'wa norĩ ma, ãne: — Apâ te za ane wa'wa Zuwãhã u, tãma ĩ̱wasu'u wa'aba da. Ĩtob'a norĩ hã to pese za'ra wa, ma tô apâ te te 're rob'madâ'â za'ra. Ĩmorĩ'õ norĩ hã te oto para na 're nomro. Duré ĩ'wa're ré norĩ hã ma tô 're pese za'ra. Hâiba wẽ na te oto 're nomro. Duré ĩpo'reptõ norĩ hã te oto 're simipari za'ra. Duré 're ĩdâ'â za'ra mono norĩ hã ma tô duré apâ 're hâiwa'utu za'ra. Ĩ̱wasu'uwẽ hã ma tô duré ĩsibrob'õ norĩ hã te te 're wapari za'ra. Ãne na te za tãma ĩrowasu'u za'ra wa'wa, Zuwãhã ma. ");
INSERT INTO xavNT_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Ni'wam norĩ hã, wa hã 'Re ĩhâimana u'âsi mono zadawa para we ĩ̱morĩ na, 'râwi ĩ̱'ãma 're siwawã za'ra mono õ wamhã, ta norĩ ma si tãma 're rowẽ uptabi za'ra mono di za. — Ãne ma tô Zezusi hã tãma waihu'u zahuré. ");
INSERT INTO xavNT_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Tawamhã apâ te tineb zahuré Zuwã Batitaha u, aibâ norĩ hã. Tawamhã ĩsa'u zahuré si, te Zuwã hã dama wasu'u wẽ, Zezusi hã. Da'ahâ na ĩdasi'ubumroi mono norĩ ma, te ãne tãma rowasu'u za'ra: — A'ubuni u, ma tô 're anomro aba mo, Zuwã hã sabu za'ra wa'aba da. E tawamhã du teihi 'rãihâ hã uware wa, rowa'u te te 're ĩhâpâ za'ra mono ne, Zuwã Batita hã roti da, sib'uware na 're hâimana mono wa, ma tô ĩtẽme 're anomro aba mo. Mare di. Ta hã roti da, siptete na ma tô 're hâimana. ");
INSERT INTO xavNT_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","E uza wẽ na 're si'uza mono wa, ma tô ĩtẽme 're anomro aba mo, 're sabu za'ra wa'aba mono da. Mare di. Uza wẽ na 're si'uza mono õ di. Uza wẽ ré 're ĩnomro mono norĩ hã, te apito nhorõwa ãma 're si'ubumro. Uburé marĩ hã ĩwẽ uptabi si, te tãma 're hâimana za'ra, ta norĩ ma. ");
INSERT INTO xavNT_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Ma'ãpé, ĩ̱ma wasu'u za'ra wa'aba za. E 'Re ĩhâimana u'âsi mono zadawa wasu'u'wai wa, te ĩtẽme 're anomro aba mo, 're sabu za'ra wa'aba mono da. Tane tô. Ĩwana ĩsadawa wasu'u'wa norĩ hã, ĩpire na te te siwi ãma wabzu za'ra õ di, Zuwã hã. ");
INSERT INTO xavNT_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Duréihã ma tô 'Re ĩhâimana u'âsi mono zadawa wasu'u'wa hã ãne ãma rob'ui'éré, Zuwãhã ãma, 'Re ĩhâimana u'âsi mono mreme na: “Ĩ̱zadawa wasu'u'wa, wa za aiwana satõ, te te asô ropese mono da.” Ãne duréihã ãma rob'ui'éré hã, ĩbaihâ na hã. ");
INSERT INTO xavNT_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Te duré tãma rowasu'u za'ra, Zezusi hã: — Uburé ĩwana 're ĩnomro mono norĩ hã te te siwi ãma wabzu za'ra õ di Zuwã hã, ĩsimiromhuri pire na hã. Tane nherẽ, 'Re ĩhâimana u'âsi mono te te 're ĩda'azawi mono zéb zarina, te te 're ĩda'apawapto mono zé hã, hâiba ré ré, te te waihu'u õ di za, Zuwã hã. Ni'wam norĩ si, 'Re ĩhâimana u'âsi mono nhib'a'uwẽ norĩ si te za te te sina 're waihu'u za'ra, ĩ'uirĩ na. Taha wa, ta norĩ hã te za pire na 're hâimana za'ra, Zuwã Batitaha nhipai u. Duré ni'wam norĩ hã 'Re ĩhâimana u'âsi mono nhib'a'uwẽ norĩ hã, tisiré norĩ ma, wapu na 're hâimana za'ra mono nherẽ, te za pire na 're hâimana za'ra, Zuwã Batitaha nhipai u, ta norĩ si ĩ'uirĩ na te te sina 're waihu'u za'ra mono wa, 'Re ĩhâimana u'âsi mono te te 're ĩda'apawapto mono zé hã. — Ãne ma tô Zezusi hã dama wasu'u, Zuwã hã. ");
INSERT INTO xavNT_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Tawamhã uburé ma tô ĩsimirowasu'u hã wapari za'ra ni. Danhib'apito ma, rob'uiprazé ubumroi'wa norĩ zama, ma tô dame wapari za'ra. Ta norĩ hã ma tô oto wapari pese za'ra, 'Re ĩhâimana u'âsi mono nhimiroti hã. Taha wa, ma tô Zuwã hã â dawabzuri hã tãma 'manharĩ za'ra. ");
INSERT INTO xavNT_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Tazahã, parisezu norĩ hã rowahutu'wa norĩ me, ma tô siwi wẽ'õ za'ra 'râwi, 'Re ĩhâimana u'âsi mono te te sima ĩda'awẽzé hã. Taha wa, te te siwi wẽ'õ za'ra wa, â dawabzuri hã te te tãma 'manharĩ za'ra õ di, Zuwã hã. ");
INSERT INTO xavNT_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Tawamhã Zezusi te duré dama tinha: — E 'wam norĩ ãma, wa za ãma simiré'é za'ra, ã nimosi dapoto tém norĩ ãma hã. ");
INSERT INTO xavNT_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Ãté ai'uté norĩ ãma, wa za ãma simiré'é za'ra. 'Ri nhi'riti wa, da te dasina 're ĩ'ubumroi mono zéb ãma si'ubumroi ré, ãne ai'uté norĩ hã te za si'mahârâ za'ra: “Wa norĩ hã wa tô aima rowamreme za'ra wa'aba ni aré, dasina damro wa, rowamremezém na. Tazahã, ãma ato za'ra wa'aba õ di. Duré da te dasina 're ti'a za'ra mono wa, rowamremezém na, wa tô aré aima rowamreme za'ra wa'aba ni. Tazahã, a norĩ wa'wa hã wazu ai'ry'ry wa'aba õ di.” Ãne te za si'mahârâ za'ra. ");
INSERT INTO xavNT_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Tane a norĩ wa'wa hã. Zuwã Batita hã te sai ãna nasi aimasisi. Duré uwa 'rãi wa'u ĩsé hã te te 're hâsi mono õ di. Tazahã, ãne 're hâimana mono wa, ma tô tãma 're ĩnharĩ wasété za'ra wa'aba mo, wa'uburé ré 're ĩmorĩ na. ");
INSERT INTO xavNT_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Wa hã ti'ai ãma dasiré ĩ̱podo hã dasazém na, wa 're ĩ̱sa. Uwa 'rãi wa'u ĩsé hã wa duré te dame 're hâsi. Tazahã, ĩ̱sa za'ẽtẽ na 're ĩ̱sai mono na, duré uwa 'rãi wa'u zé zei 'wa na, ma tô ĩ̱ma 're ĩnharĩ wasété za'ra wa'aba mo. Duré siwa'ru 're ĩdanomro mono norĩ siwadi na, ma tô ĩ̱ma 're ĩnharĩ wasété za'ra wa'aba mo. ");
INSERT INTO xavNT_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Tane tô. 'Re ĩhâimana u'âsi mono nhimiroti hã, wẽ di. Tawamhã ĩsimiroti hã da te dasima 're wẽ za'ra mono wamhã, te za ĩwẽ hã da te 're waihu'u za'ra. Da te 're wẽ'õ za'ra mono õ di za, ĩwẽ hã dasiwi. — Ãne Zezusi ma tô tãma siwasu'u za'ra. ");
INSERT INTO xavNT_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Tawamhã aibâ parisezu hã ma tô Zezusihi zô hâ, ĩme sa da. Taha wa, te Zezusi hã ĩsõrõwa u mo. Tawamhã ma tô nhamra tame, sa da. ");
INSERT INTO xavNT_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Tame 'ri wa'õtõ ãma hã ma tô ĩwasu'u hã wapa pi'õ hã, siwa'ru 're ĩmorĩ hã. Parisezu nhorõwa ãma sa da, ĩsãmra na ma tô wapa. Taha wa, ma tô simhi ti'â, Zezusihi zarina, wedewa'u zadaze ré hã. Simhi hã, ẽtẽ'a 'manharĩ. Wa'âbâ za'ẽtẽ di, wedewa'u zadaze hã. ");
INSERT INTO xavNT_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Tawamhã Zezusihi babarã na ma tô nhamra, wawa sina. Wawai wamhã, Zezusihi para nhisiwi, ma tô ti'upĩni a'a. Taha wa, te tizéré na tãma u'õ. Tawamhã da te 're ĩdatob'rata hârâ za'ra mono ne, tizadawa na ma tô para hârâ. Ma tô wedewa'u zadaze hã ĩpara nhisiwi sa'wa, pi'õ na. ");
INSERT INTO xavNT_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Tawamhã, parisezu te te 'madâ'â wamhã, ma tô tipẽ'ẽ na tãma tinha, Zezusihi ma: — Tô sena, 'Re ĩhâimana u'âsi mono zadawa wasu'u'wai 'wa'âhã, te aré ĩwasété na ãma waihu'u, pi'õi ãma hã. Tawamhã te aré tiwi sisawi, te te upi tõ da. — Ãne ma tô tipẽ'ẽ na tãma tinha. ");
INSERT INTO xavNT_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Tawamhã ĩsimirosa'rada hã te te sina waihu'u wa, te aibâ ma tinha, Zezusi hã: — Sima, marĩ, wa za aima waihu'u, waihu'u da. — Ãne te tãma tinha. Tawamhã Sima te asa tãma tinha: — Ma'ãpé, ĩ̱ma waihu'u, marĩ hã te waihu'u da. ");
INSERT INTO xavNT_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Taha wa, te Zezusi hã tãma rowasu'u oto, ãne: — Aibâ norĩ hã ma tô rob'uiprazéb õ wa, taré a'â dawi 'maiwaptẽrẽ zahuré. Ĩmorĩ'rada hã 500 na ma tô dawi waptẽ. Duré ĩhâiba amo hã, 50 na ma tô dawi waptẽ. Niwapsi te za ĩsõwa're're tãma sõmri zahuré, aibâ ma. ");
INSERT INTO xavNT_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Tawamhã rob'uiprazéb õ wa, ĩsõwa're're te te tãma sõmri zahuré õ di. Sõpru wa, ma tô tãma waihu'u zahuré aibâ hã, ĩsõwa're're te te tãma sõmri zahuré tõ da. — Ãne ma tô Simahã ma rowasu'u, Zezusi hã. Tawamhã te oto ãma sadanha: — E 'wa hã te za sawi pese, aibâ ĩsõpru hã. E 500 na te te tãma ĩsõmri hã te za sawi pese. E 50 na te te tãma ĩsõmri hã te za sawi pese. — Ãne Zezusi te sadanha. ");
INSERT INTO xavNT_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Tawamhã Sima te asa tãma tinha: — Ãté 500 na te te tãma ĩsõmri hã te za sawi pese. — Ãne Sima, te Zezusihi ma tinha. Tawamhã Zezusi te duré asa tãma tinha: — Tane tô. Ĩ'uwaibaba ma tô ĩ̱ma ĩwaihu. — Ãne ma tô ãma saze. ");
INSERT INTO xavNT_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Tawamhã pi'õi u sipi'rai wamhã, te duré tãma tinha, Simahã ma: — Ãhãta, pi'õ hã. Tãma ĩ̱zawi pese di. A hã we ĩ̱zébré wamhã, â hã dama 'rui õ di, da te ĩ̱para upsõ da. Pi'õ si ma tô ĩ̱para upsõ, ti'upĩni na. Ma tô duré tizéré na ĩ̱para u'õ. ");
INSERT INTO xavNT_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","A hã we ĩ̱wisi wi, ĩ̱zawi õ di, ĩ̱tob'rata hârâ na. Pi'õ si ĩ̱zébré wi, ma tô ĩ̱para hârâ. ");
INSERT INTO xavNT_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","A hã dama ĩ̱'rui õ di, azeitona 'rãi wa'ui wam na da te ĩ̱zéré u'ré da, ĩ̱ma robze da. Pi'õ hã wedewa'u zadaze pire hã ma tô ĩ̱para nhisiwi sa'wa. ");
INSERT INTO xavNT_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Tãma ĩ̱zawi uptabi wa, ma tô ĩ̱ma 'manharĩ wẽ. Marĩ hã te te 're ĩ'ab'manharĩ wasété mono zé hã ahâ nherẽ, wa tô tãma tipa. Taha wa, tãma ĩ̱zawi uptabi di, te tãma apari wa. Dawasété ahâ na 're dasisãmri za'ra mono õ wamhã, da te dasina 're waihu'u za'ra mono õ di za, 'Re ĩhâimana u'âsi mono, dawasété ahâ na te te dama 're ĩ'apari mono zé hã. Tawamhã 'Re ĩhâimana u'âsi mono, dama sawi prã ti za. Dawasété ahâ na 're dasisãmri za'ra mono wapsi, te za da te dasina 're waihu'u za'ra, 'Re ĩhâimana u'âsi mono, dawasété ahâ na te te dama 're ĩ'apari mono zé hã. Tawamhã 'Re ĩhâimana u'âsi mono, dama sawi uptabi di za. — Ãne ma tô Simahã ma waihu'u, Zezusi hã. ");
INSERT INTO xavNT_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Tawamhã pi'õi ma, te oto tinha: — Marĩ hã 're ĩ'ab'manharĩ wasété mono zé hã wa tô oto aima tipa. — Ãne te pi'õi ma tinha. ");
INSERT INTO xavNT_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Tawamhã Zezusihi mreme, ma tô pi'õi ãma wapari za'ra, ĩsiré ĩsaihuri norĩ hã. Taha wa, ma tô tipẽ'ẽ na tãma nharĩ za'ra: — E 'wa hã õ hã, marĩ, da te 're ĩ'manharĩ wasété za'ra mono zé hã, te te dama 're ĩ'apari mono hã. — Ãne te tãma nharĩ za'ra, tipẽ'ẽ na. ");
INSERT INTO xavNT_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Tawamhã Zezusi te duré pi'õi ma tinha: — Ĩ̱zazei wa, wa tô aipawapto, aiwasédé hã rẽme pese da. Rowẽ na te za oto 're aimo. — Ãne te pi'õi ma tinha, Zezusi hã. ");
INSERT INTO xavNT_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Tawamhã ãma ronomro wapsi, te Zezusi hã datẽme 're mo, daro mono bâ. 'Ri nho'õmo mono bâ, te datẽme 're mo, 'ri wa'õtõ mono bâ. Tawamhã datẽme 're morĩ wamhã, ma tô ĩwasu'uwẽ na te te 're da'apo're pu'u, 'Re ĩhâimana u'âsi mono, da'ãma 're ĩsib'a'uwẽ mono zé wasu'u na. Datẽme 're morĩ wamhã, aibâ norĩ hã 12 na ĩhâiba za'ra hã, te ĩsiré 're nomro. ");
INSERT INTO xavNT_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Pi'õ norĩ zama, te ĩsiré 're nomro, wa'uburé, te te tãma 're ĩ'anhamra mono norĩ hã. Duré, ĩhâzé hã te te tãma 're ĩ'apari mono norĩ zama, te ĩsiré 're nomro. Pi'õ nhisi hã, Mariza Madarena na ĩsisi hã, wa'uburé hã, 7 na ĩhâiba za'ra hã te te tãma ĩsãmra za'ra hã. ");
INSERT INTO xavNT_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Duré, Zuwãna na pi'õ nhisi hã. Cuzaha mro hã, apito Erodihi ma romhuri'wai mro hã. Duré, Suzana na pi'õ nhisi hã. Aimawi norĩ hã te duré ĩsiré 're nomro, pi'õ norĩ hã, ahâ na. Ta norĩ hã tinhimarĩ na, te Zezusi norĩ hã te te 're pawaptob za'ra. ");
INSERT INTO xavNT_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Tawamhã da'ahâ na ma tô ĩtẽme aihutu ni Zezusihi u, 'ri ahâ mono bâ, da te sabu za'ra da. Tawamhã, ĩtẽme dasi'rã'õtõ wamhã, ma tô dama romnhimiré'é, ãne: ");
INSERT INTO xavNT_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","— Aibâ hã te buru u mo, ti'ai hâibâdâ na, amnho hã te te anhamra mono da, poto mono da. Tawamhã, amnho hã te te anhamra mono wamhã, nima norĩ hã bâdâdi zababa ma rere'e. Taha wa, ma tô dapara na nasi wati'i za'ra ni, tiwi ĩrere'e mono hã. Sire hã ma duré te te uprosi, poto mono õ ré. ");
INSERT INTO xavNT_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Ẽtẽ nhisiwi, ma duré nima norĩ hã rere'e, amnho hã. Ti'a baihâire di, ẽtẽ nhisiwimhã. Tawamhã, 'wanhipré wairébé mono wamhã, ti'ai wa'ro wamhã, ma 'wanhipré 'ré. ");
INSERT INTO xavNT_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Nima norĩ hã ma duré rere'e, wab'ru wazari. Tawamhã siré ma tô 'wanhipré. Siré 'wanhipré mono wamhã, ma te te ubu, wab'ru hã. Taha wa, ma tô te te uprosi. ");
INSERT INTO xavNT_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Ti'ai wẽ wa, ma duré nima norĩ hã rere'e. Ma tô oto 'rã. 'Rãi mono wamhã, 'rãi pese uptabi di, rob're hã. — Ãne Zezusi ma tô dama rowasu'u. Te duré dama tinha: — Asimipari pese za'ra wa'aba wamhã, ma'ãpé ĩ̱wapari pese za'ra wa'aba ĩ̱nhimirowasu'u na hã, waihu'u za'ra wa'aba da. — Ãne te dama tinha. ");
INSERT INTO xavNT_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Tawamhã Zezusihi siré 're ĩnomro mono norĩ si, te sadanharĩ za'ra: — E marĩ na, te ãma ĩsimiré, amnho potozém na hã. — Ãne te sadanharĩ za'ra. ");
INSERT INTO xavNT_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Tawamhã Zezusi asa te tãma nharĩ za'ra: — 'Re ĩhâimana u'âsi mono hã ma tô dawi sawi, a'â da te waihu'u tõ za'ra da, da'ãma 're ĩsib'a'uwẽ mono zé wasu'u hã. A norĩ wa'aba ma si, ma tô oto ĩwasu'u hã aima waihu'u za'ra wa'wa, waihu'u za'ra wa'aba da, dama ĩwaihu'u'õ hã. Taha wa, wa tô ĩ̱nhimiromnhimiré'é na si, te dama 're arowasu'u. Tawamhã dapo're na, da te 're wapari za'ra mono nherẽ, da te waihu'u za'ra õ di za, ãma ĩsimiré'ézé hã. ");
INSERT INTO xavNT_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","— Ãhãna, wa za aima waihu'u za'ra wa'wa, te ãma ĩsimiré'ézé hã waihu'u za'ra wa'aba da. Amnho potozé hã, 'Re ĩhâimana u'âsi mono mreme, te wasu'u. ");
INSERT INTO xavNT_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Amnho hã bâdâdi zababa ĩrere'e mono hã, aimawi a'uwẽ, te wasu'u. Ta norĩ hã ãté te za ĩsadawa wasu'u hã taré tipo're na te te 're wapari za'ra. Tawamhã te za Wa'uburé hã ĩtẽme 're sihutu ãté, te te tãma 're roti za'ra mono da, te te 're saze za'ra mono tõ da, te te 're sõ'reptu za'ra mono tõ da, 'Re ĩhâimana u'âsi mono hã. Tawamhã wa'rui'wa nhimiroti zarina, te te saze za'ra õ di za, 'Re ĩhâimana u'âsi mono zadawa wasu'u hã. ");
INSERT INTO xavNT_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Duré amnho hã ẽtẽ nhisiwi ĩrere'e mono hã, aimawi a'uwẽ, te wasu'u. Ta norĩ hã ãté te za 'Re ĩhâimana u'âsi mono zadawa wasu'u hã te te 're wapari za'ra, tipo're na. Tawamhã te za ĩwasu'u ma 're to za'ra. Tazahã, õne haré te te 're saze za'ra mono õ di za. Ãté, te za te te 're saze hutu za'ra. Ãté rowasédé hã da te tãma 're 'manharĩ za'ra mono õ'umnhasite, te za apâ 're sipizari za'ra. ");
INSERT INTO xavNT_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Duré amnho hã wab'ru wazari ĩ'a'a mono hã, aimawi a'uwẽ, te wasu'u. Ta norĩ hã ãté te za taré tipo're na te te 're wapari za'ra, ĩsadawa wasu'u hã. Tazahã, marĩ wamhã, õhõ ãma si 're nomro mono õ di za. Ãté, marĩ na si te za te te 're rosa'rata za'ra sima, ãté rob'uiprazém na si, ãté titozém na si. Tawamhã rob'rã ĩ'rã wẽ prã ne, 're hâimana wẽ uptabi za'ra mono õ di za. ");
INSERT INTO xavNT_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Amnho hã ti'ai wẽ wa, te te ĩ'anhamra mono hã, aimawi a'uwẽ, te wasu'u. Ta norĩ hã ãté te za tipo're na te te 're wapari za'ra, 'Re ĩhâimana u'âsi mono zadawa wasu'u hã. Tawamhã te za te te 're 'madâ'â pese za'ra. Õne haré, te za ĩsimiroti na 're nomro. Tawamhã rob'rã ĩ'rãi wẽ uptabi ne, hâimana wẽ uptabi na, te za oto 're hâimana za'ra. Ãne amnho potozé wasu'u na, wa aima ãma simiré'é za'ra wa'wa. — Ãne, Zezusi te tãma rowasu'u za'ra, tisiré 're ĩnomro mono norĩ ma. ");
INSERT INTO xavNT_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Tawamhã rob'uiwẽzém na te duré ãma simiré'é: — Rob'uiwẽzé hã da te ro'o wamhã, e piza'a na te za upsibi ni. E daza'warizéb 'rowi, te za sãrĩ ni. Mare di. Ĩsima'warazém na si, te za sõ'awi da te 're sõré, rowa'a na 're danhisisi mono da. Taha da, te za ro'o ni, rob'uiwẽzé hã. ");
INSERT INTO xavNT_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Tane, ĩ̱mreme hã a'â te dama ĩwaihu'u'õ hã te za niwapsi waihu'u za'ra ni. Taha wa, wa tô rob'uiwẽzém na ãne ãma simiré'é. ");
INSERT INTO xavNT_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","— Taha wa, ma'ãpé ĩ̱mreme hã 're wapari pese za'ra wa'aba mono. Tawamhã ĩ̱zadawa wasu'u hã te za te te aima 're waihu'u za'ẽtẽ za'ra wa'wa, 'Re ĩhâimana u'âsi mono hã. Ĩ̱mreme hã 're wapari pese za'ra wa'aba mono õ wamhã, te za apâ te te aiwi 're awaibui wa'wa, ĩ̱zadawa wasu'u hã. Tawamhã ĩ̱mreme waihu'u'wa na, 'râwi 're asi'madâ'â ze za'ra wa'aba mono nherẽ, te za ĩ̱mreme waihu'u'õ'wa ne, oto 're anomro aba mo. — Ãne te Zezusi hã tisiré 're ĩnomro mono norĩ ma rowasu'u za'ra. ");
INSERT INTO xavNT_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Tawamhã Zezusihi u, te ĩna hã mo, ĩno norĩ me. Te te sabu za'ra da, te ĩtẽme ai'aba'ré. Tazahã, da'ahâ uptabi wamhã, ĩtẽme sisisi waihu'u õ di. ");
INSERT INTO xavNT_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Tawamhã Zezusihi ma, ma tô ni'wa hã rowasu'u, ãne: — Ano norĩ hã te rowi asô aimasa, ana me. Te sima wẽ za'ra, te te asabu za'ra da. — Ãne ma tô tãma rowasu'u ni. ");
INSERT INTO xavNT_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Tawamhã Zezusi te uburé dama tinha: — Ni'wam norĩ hã, 'Re ĩhâimana u'âsi mono zadawa wasu'u hã tipo're na te te 're wapari za'ra mono wamhã, duré te te 're 'madâ'â pese za'ra mono wamhã, ta norĩ hã ĩ̱na, duré ĩ̱no. — Ãne Zezusi ma tô dama waihu'u. ");
INSERT INTO xavNT_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Tawamhã bâtâ na, te Zezusi hã tãma nharĩ za'ra: — Oto zara u, wa te saprĩ za'ra wa'aba. — Ãne te tãma nharĩ za'ra, tisiré 're ĩnomro mono norĩ ma. Tawamhã uba're wa, ma tô asisi, zara u te te saprĩ za'ra da, ĩsõ'u na. ");
INSERT INTO xavNT_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Tawamhã te te siré sari za'ra ré, te oto Zezusi hã nhono, uba're wa. Sõtõ ré, ma tô rowa'u ĩsa'ẽne hã watobro. Taha wa, uba're 're, ma tô â hã ãzé. Uba're 'remhã, â hã 'masisi wamhã, simimnhasi di oto. ");
INSERT INTO xavNT_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Taha wa, ma Zezusihi u tiwahutu za'ra, te te siwi utu da. Tawamhã ãne te siwi 'mahâ: — Rowahutu'wa, rowahutu'wa, wa za ai'utõrĩ ni. — Ãne te 'mahârâ za'ra. Tawamhã Zezusi ma tô udu. Ma tô wahudu. Rowa'u'u ma, te tinha, te te sazâri da. Duré â ma, te tinha, âtu da. Taha wa, ma tô sazâ, rowa'u hã. Ma tô ti'âtu oto. ");
INSERT INTO xavNT_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Tawamhã tisiré 're ĩnomro mono norĩ ma, te tinha: — E niha bâ asiwi ĩ̱'umnhasi aba õ di. — Ãne te tãma nharĩ za'ra. Taha wa, te sima nharĩ za'ra: — E niha õ hã aibâ hã. Rowa'u'u ma, te tinha. Tawamhã rowa'u hã ma tô sazâ. Duré, â nhibzaihâ ma, te tinha. Taha wa, ma tô ti'âtu. Ĩmreme hã ma tô wapari zahuré. — Ãne te sima nharĩ za'ra. Mreme pire wa, ma ãma titob'uzu za'ra. Õne hã tãma sa'rese za'ra õ wa, ma tô tãma tipahi za'ra, ĩsiré 're ĩnomro mono norĩ hã. ");
INSERT INTO xavNT_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Tawamhã Darireza na danhipti'a nho'õmo nhisi hawi, te ĩsõ'u na siré sari za'ra, te te saprĩ za'ra da, zara u, Zezusi norĩ hã. Tawamhã ma tô oto aihutu zara u, Zeraza na danhipti'a nho'õmo nhisi niwĩ. ");
INSERT INTO xavNT_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Tawamhã uba're hawi, ma tô watobro, Zezusi hã. Watobro wamhã, ma tô aibâ hã ĩtẽme wi, wa'uburé ré 're ĩmorĩ hã. 'Re si'uza mono õ di oto, aibâ hã. Ai'uréiwi, te oto 're mo. Duré 'ri 're, 're sãmra mono õ di oto. Adâ'â 'ru ãma si te oto 're sãmra, ẽtẽ wa, ab're sirõmo ãma. Tame 're hâimana mono ré hã, ma tô ãma tironomro pese. ");
INSERT INTO xavNT_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","29","Aibâ hã da'rata 're sãmra mono ré, ma tô da te 're 'madâ'â za'ra, 're pusi tõ mono da. Ma tô da te dasiwi 're hi wasisi, ĩsi'uwazi nhorõ rutu na. Te duré da te dasiwi 're pa wasisi. Tazahã, tihi wasisizé hã te te sina 're anhinarĩ, tipawasisizéb zama. Taha pari, te wa'uburé hã te te siwi 're saprõni, a'ubuni u. Tawamhã aibâ hã Zezusi te te 'madâ'â wamhã, ma tô 're sadari. Taha wa, hi'rãtitõ ma aime, Zezusihi papara. Tawamhã mreme 'rãihâ na te tãma tinha, ãne: — Zezusi, 'Re ĩhâimana u'âsi mono 'ra, e marĩ ĩ̱'ãma 'manharĩ da, te we aimo. Ĩ̱'azâri õ di za. Ãne, wa ĩ̱sina aipa'uwati. — Ãne te Zezusihi ma tinha, wa'uburé ma, te te rob'rui wa, aibâ hawi watobro da. ");
INSERT INTO xavNT_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Tawamhã Zezusi hã te sadanha, ĩsisi zô: — E niha asisi hã. — Ahâ na, ĩ̱nhisi hã. — Ãne te aibâ hã tãma sisisi, wa'uburé hã ãma ahâ wa. ");
INSERT INTO xavNT_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","32","Tawamhã romhutu na te uhâbâ norĩ hã tisa te te 're huri ahâ na, sa'a zahâpâ para wi. Tawamhã wa'uburé norĩ hã te Zezusihi wi rowaptẽrẽ za'ra sina, rob'rehâ u te te satõrĩ tõ za'ra da. Uhâbâi u, te te satõrĩ za'ra da, te sina rowaptẽrẽ za'ra, uhâbâ hâiba 're, 're si'ubumroi mono da. Taha wa, ma tô Zezusi hã ãma saze za'ra. ");
INSERT INTO xavNT_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Tawamhã aibâ hawi ma tô wairé wa'uburé norĩ hã, uhâbâi u si'aba'ré da, ĩhâiba 're, 're si'ubumroi mono da. Tawamhã, ĩtẽme sisisi wamhã, uhâbâ norĩ hã te sisa're, wara sina. Sa'a hawi, te pi'reba sisa're, ĩsõ'ui u. Tawamhã âi ba ma tô rere. Taha wa, ma ai'utõ uburé. ");
INSERT INTO xavNT_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Tawamhã uhâbâ 'madâ'â'wa norĩ hã te te 'madâ'â za'ra wamhã, te ĩsiti datẽme sisa're, wara sina. 'Ri nho'õmo ãma, ma tô dama rowasu'u za'ra. Rom na, 'ri wa'õtõ ãma zama, ma tô dama rowasu'u za'ra. ");
INSERT INTO xavNT_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Tawamhã ĩsimirowasu'u hã da te wapari za'ra wamhã, te ĩtẽme ai'aba'ré ni, da te sabu za'ra da. Zezusihi u dasihutu wamhã, ma tô aibâ hã 'madâ'â za'ra ni, wa'uburé ĩhawi ĩwairébé hã. Uza ré, te oto nhamra Zezusihi papara, rowẽ na. Tawamhã tãma rowẽ wa, ma tô tãma tipahi za'ra, dama 're ĩrowẽ za'ra mono zé hã tãma sa'rese za'ra õ wa. ");
INSERT INTO xavNT_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Tawamhã ãma ĩ'madâ'â za'ra 'wa norĩ hã te aibâ wasu'u hã dama wasu'u za'ra, ĩsihutu norĩ ma. Aibâ, Zezusi te te ĩpawaptobzém na, te tãma rowasu'u za'ra. ");
INSERT INTO xavNT_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Tawamhã aibâ wasu'u te te wapari za'ra wamhã, ma tô tãma tipẽ'ẽwara za'ra. Taha wa, te Zezusihi ma rob'ru za'ra, ĩrom nhiti morĩ za'ra da. Aihĩni te tãma rob'ru za'ra, Zeraza na danhipti'a nho'õmo nhisi ãma 're ĩsi'ubumroi mono norĩ hã. Tawamhã Zezusi te za oto ãzé, uba're wa, danhiti morĩ da. ");
INSERT INTO xavNT_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Tawamhã aibâ te sina 'mahâ, Zezusihi siré 're morĩ da, te te tãma pisutu da, wa'uburé ĩhawi ĩwairébé hã. Tane nherẽ, te Zezusi hã aibâ ma tinha, ãne: ");
INSERT INTO xavNT_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","— Apâ aimorĩ, asõrõwa u, 'Re ĩhâimana u'âsi mono, ĩwẽ na te te aipawaptobzém na asisãnawã norĩ ma, asiwasu'u da. — Ãne te aibâ ma tinha. Tawamhã aibâ te oto mo, tinhorõwa u, 'ri baba dama siwasu'u mono da, Zezusi te te ĩpawaptobzém na hã. ");
INSERT INTO xavNT_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Tawamhã ma tô Zezusi norĩ hã apâ saprĩ za'ra, zara u. Zara niwĩ, ma tô da'ahâ na ĩwana sô ropsãmri za'ra ni. Tawamhã apâ datẽme wisi wẽ te, ma Zezusi hã sawi za'ra ni, dato sina. ");
INSERT INTO xavNT_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","42","Tawamhã ma tô aibâ hã ĩtẽme wi, Zairu na ĩsisi hã, zudezu norĩ te, rowahutuzéb ãma dawada'uri'wa hã. Ĩtẽme wisi wi, ma tô hi'rãtitõ aime, Zezusihi papara, ti'ra ãma te te sadawa pibu da, ĩsõrõwa u morĩ da, ĩ'ra hã hâzé wa, te te tãma pese da. Ĩ'ra hã pi'õ pisi, azarudu hã 12 na ãma ĩwahu. Hâzé ahâ wa, te za oto tiwi dârâ. Tawamhã Zezusi te oto mo, ĩsõrõwa u. Morĩ ré, te da'ahâ na ãma dasi'uirĩ. Ma dasiwi hõti ni. ");
INSERT INTO xavNT_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","44","Tawamhã bâdâdi na morĩ ré, ma tô pi'õ hã wi, Zezusihi u, ĩhâzé ré hã, marĩ te te 're ĩ'manharĩ mono hã. Hâzé ré, ma tô ãma tiwahub ahâ, 12 na ãma ĩwahubzé hã. Dawede'wa norĩ ma, ma tô uburé tinhibro hã uprosi, tisiwa'âbâzém na. Tazahã, dawede'wa norĩ hã te te siwi hõsi õ di, ĩwede na hã. Tawamhã pi'õ hã, Zezusihi babarã niwĩ ma tô saprĩ. Ĩ'uza 'rãsudu hã ma tô tiwi upi. Taha wa, ma awa'awi séptârâ. Tâibâ oto ĩhâzé hã. ");
INSERT INTO xavNT_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Taha wa, ma tô ãne da'mahâ, Zezusi hã: — E 'wa hã ma ĩ̱'uza hã ĩ̱wi upi. — Ãne te da'mahâ. Tane nherẽ, te tãma amrami za'ra ni. Taha wa, te Pedru hã tãma tinha: — Rowahutu'wa, oro aihĩni ai'ãma wasi'uirĩ mono za, wa wasiwi aihõti ni. — Ãne te tãma tinha. ");
INSERT INTO xavNT_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Tawamhã Zezusi asa te tãma tinha: — Ni'wa hã ma tô ĩ̱'uza hã ĩ̱wi upi. Ĩ̱waihu'u pese na, wa tô pese. Ãne, wa tô ĩ̱sina waihu'u. — Ãne te tãma tinha. ");
INSERT INTO xavNT_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Tawamhã ma tô pi'õ hã sina wapa, Zezusihi mreme hã. Da te sa'rese ãna, sãmra õ di oto, pi'õ hã. Ãne ma tô sina waihu'u. Tawamhã rẽrẽ'ẽ sina, ma tô Zezusihi papara aime hi'rãtitõ. Danho'a te Zezusihi ma siwasu'u pese, ãne: — Ĩ̱hâzé wa, wa ai'uza aiwi upi, ĩ̱pese da. Tawamhã awa'awi wa tô séptârâ. — Ãne te tãma siwasu'u. ");
INSERT INTO xavNT_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Tawamhã Zezusi te tãma tinha: — Ĩ̱hidiba, za te aipesezém na ĩ̱'umnhasi wa, ma tô aihâzé hã aima apa. Rowẽ na te za oto 're aimo. — Ãne, Zezusi ma tô tãma tinha. ");
INSERT INTO xavNT_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Tawamhã pi'õi ma, te te rowasu'u ré, ma tô ãma wi, aibâ hã. Zairuhu u, ma wi. Ĩsõrõwa hawi, ma ĩtẽme wi, rowahutuzéb ãma 're da'anhimi'rui mono 'wai u hã. Tawamhã te Zairuhu ma rowasu'u aibâ hã, ãne: — Ai'ra hã ma tô aiwi dârâ, azaruture hã. Rowahutu'wai wi, ro'wa'ré õ'umnhasite, simiromhuri nherẽ. — Ãne te tãma tinha. ");
INSERT INTO xavNT_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Tawamhã Zezusi ma tô sina wapa. Taha wa, te Zairuhu ma tinha: — Ai'ra wasu'u ma, aipahi tõ. Ĩ̱wétési asina ĩ̱'umnhasi, te aipawaptob da. Ĩ̱wétési ĩ̱'umnhasi wamhã, rowẽ na te za oto aima 're sãmra. — Ãne te Zezusi hã tãma tinha. ");
INSERT INTO xavNT_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Tawamhã Zezusi hã Zairuhu nhorõwa u oto wisi wamhã, ma tô pisutu za'ra, Pedru norĩ si ĩsiré sisisi da, Zuwã hã duré Ti'adu hã, azaruture mama norĩ siré hã. ");
INSERT INTO xavNT_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Tame da'ahâ na te ãma ta'ry'ry ni, dapẽ'ẽzé te. Taha wa, te Zezusi hã dama tinha, ãne: — Ãma ai'ry'ry wa'aba õ di za. Azaruture hã dâ'â õ di. Taré te nhono. — Ãne te dama tinha. ");
INSERT INTO xavNT_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Tawamhã asa te tãma nharĩ za'ra ni: — Oro taré sõtõ za, te pẽ'ẽzani ãna nomro. — Ãne te tãma nharĩ za'ra ni. Ĩdâ'âzém na, ma tô waihu'u za'ra ni. Taha wa, ma tô ãne tãma nharĩ za'ra ni. ");
INSERT INTO xavNT_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Tazahã, te te damreme 'madâ'â õ di, Zezusi hã. Ma tô pa'â. Mreme 'rãihâ na, te tãma tinha, ãne: — Azaruture, aiwahutu. — Ãne te tãma tinha. ");
INSERT INTO xavNT_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Tawamhã ma tô apâ pẽ'ẽ waze, awa'awi. Hâiwi te oto za. Taha wa, mram na te wada'uri zahuré, te te tãma a zahuré da, ĩmama norĩ hã. ");
INSERT INTO xavNT_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Taha wa, ĩ'ra apâ hâiwa'utu wa, ma tô ãma titob'uzu zahuré, ĩmama norĩ hã, timro me. Taha wa, tãma rowẽ zahuré di. Tane nherẽ, te ĩ'ra na sadawa uwati zahuré, te te dama rowasu'u zahuré tõ da a'â. ");
INSERT INTO xavNT_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Tawamhã Zezusi hã ma tô sitẽme sô tihârâ za'ra, ĩsiré 're ĩnomro mono norĩ zô, aibâ norĩ hã 12 na ĩhâiba za'ra hã zô. Tawamhã ma tô tãma pisutu za'ra, waihu'u pese na 're nomro mono da, wa'uburé norĩ hã te te dama 're sãmra za'ra mono da, duré ĩhâzé ré norĩ hã te te 're pese za'ra mono da, ĩsadawa para. ");
INSERT INTO xavNT_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Tawamhã ma tô duré satõrĩ za'ra, ĩwasu'uwẽ na te te 're dapo're pu'u za'ra mono da, 'Re ĩhâimana u'âsi mono, da'ãma 're ĩsib'a'uwẽ mono zé wasu'u na. Taha wasu'u na te te 're dapo're pu'u za'ra mono da, ma tô satõrĩ za'ra. Duré te te 're dapese za'ra mono da, ma tô datẽme satõrĩ za'ra. ");
INSERT INTO xavNT_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Ãne te tãma roti za'ra: — Ai'ubana te za 're anomro aba mo. Marĩ hã asiré 're 'wasari aba mono õ di za, asiwazusizé hã, duré romramizé hã. Marĩ hã 'wasari aba õ di za, mra hã, duré rob'uiprazé hã, duré ai'uzazé hã, asõ'utu'u wa'wa hã. Datẽme 're aihutu aba mono wapsi, ãté 're aihutu aba mono wi, te za da te 're asawi za'ra wa'wa. ");
INSERT INTO xavNT_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Tawamhã asô ĩhârâ 'rata aba nhorõwa ãma si, te za 're ai'ubumroi wa'aba mo, 're aiwairébé aba mono õ ré. ");
INSERT INTO xavNT_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Datẽme 're aihutu aba mono wamhã, ãté asô 're datob'uzu za'ra wa'aba mono õ di za. Tawamhã dahawi te za 're aiwairébé aba mo, darob amoi u. Dahawi 're aiwairébé aba mono wamhã, aipara'uza zapru hã te za 're ĩtata'a za'ra wa'aba mo, ti'ai u 're rere'e mono da, dawasété ma ropibuma, asimirowasu'u na, da te dasiwi 're aiwẽ'õ za'ra wa'aba mono wa. — Ãne ma tô tãma roti za'ra, Zezusi hã. ");
INSERT INTO xavNT_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Tawamhã te oto datẽme ai'aba'ré, 'ri wa'õtõ mono bâ. Daro mono bâ, ma tô ĩwasu'uwẽ na te te 're dapo're pu'u za'ra, Zezusihi siré 're ĩnomro mono norĩ hã. Ma tô duré te te 're dapese za'ra. ");
INSERT INTO xavNT_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Tawamhã apito Erodi hã, Darireza na danhipti'a nho'õmo nhisi ãma da'madâ'â'wa hã ma tô Zezusihi wasu'u hã wapa. Ãne ma tô ni'wam norĩ hã ãma rosa'rata za'ra, Zezusihi ãma hã: — Ãté Zuwã Batita apâ ĩhâiwa'udu. ");
INSERT INTO xavNT_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","9","Ãté Eriasi apâ we ĩmorĩ. Ãté 'Re ĩhâimana u'âsi mono zadawa wasu'u 'rata 'wa, duréi pese ĩdâ, apâ ĩhâiwa'udu. — Ãne ma tô Zezusihi ãma romnomri za'ra ni. Tawamhã Erodi te tinha: — Wa hã te waihu'u õ di. Ãté ni'wa hã. Wa hã, Zuwã hã wa tô dama ti'ru, da te 'rã nhizâri da. Tâibâ Zuwã hã. E 'wa hã bété ĩwasu'u hã, te ĩwapari hã. Te sabu neza. — Ãne te tinha, Erodi hã. ");
INSERT INTO xavNT_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Tawamhã ĩsadawa wasu'u'wa norĩ hã ma tô aihutu apâ, Zezusihi u, ĩsadawa para datẽme ĩsi'aba'ré norĩ hã. Sihutu wamhã, ma tô tãma siwasu'u za'ra, te te 're ĩdapawaptob za'ra mono zém na. Zezusi hã te oto te te simro siré, Besada na 'ri nhisi u, hâiba pisutu. ");
INSERT INTO xavNT_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Tazahã ma tô ĩwasu'u hã wapari za'ra ni. Taha wa, da'ahâ na te ĩsarina ai'aba'ré ni. Ĩtẽme dasihutu wamhã, uburé ma tô dazawi, Zezusi hã. 'Re ĩhâimana u'âsi mono hã da'ãma 're ĩsib'a'uwẽ mono zém na, te dama rowasu'u, Zezusi hã. Duré, ĩhâzé ré norĩ hã ma tô pese za'ra. ");
INSERT INTO xavNT_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Ãne ré, ma tô tihâiwahâ. Taha wa, ma ĩtẽme ubumro, ĩsiré 're ĩnomro mono norĩ hã, 12 na ĩhâiba za'ra hã, te te tãma nharĩ za'ra da, ãne: — Ãmemhã robaba di, 'ri hã. Õhõta romhuture di, 'ri wa'õtõ u hã. Duré, re na 'ri ĩsimasa mono u hã, romhuture di. Ma'ãpé tamomo dazatõrĩ za'ra na, dasa hã da te huri da, danhotõ za'ra da zama. — Ãne te tãma nharĩ za'ra. ");
INSERT INTO xavNT_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Taha wa, te Zezusi hã asa tãma nharĩ za'ra: — Mare di. A norĩ wa'wa hã te za dama ĩ'a za'ra wa'wa, dasaihuri da. — Ãne te tãma nharĩ za'ra. Taha wa, te asa tãma nharĩ za'ra: — Wasazé hã syryre di. Ĩ'u'ẽtẽ wapu hã 5 na si, ĩhâiba hã. Duré pe'a hã maparanere. E da'ahâ uptabi nherẽ, wa za tawamhã ai'aba'ré ni, dasazé hã wa te dama uipra za'ra da. — Ãne te tãma nharĩ za'ra, tame da'ahâ uptabi na, dasimasa wa. ");
INSERT INTO xavNT_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Aibâ norĩ hã 5 miu na ĩhâiba za'ra hã te aimasa. Zezusi hã te duré asa tãma nharĩ za'ra: — Ma'ãpé, dama roti za'ra wa'aba, 50 na si dasi'ubumroi mono da, da'upsãtã pese na. — Ãne te tãma nharĩ za'ra. ");
INSERT INTO xavNT_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Tawamhã te dama nharĩ za'ra, 50 na si dasi'ubumroi mono da, da'upsãtã pese na. ");
INSERT INTO xavNT_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Tawamhã ĩ'u'ẽtẽ wapu hã ma oto waibu Zezusi hã, 5 na ĩhâiba hã. Pe'a ma duré timra. Hâiwa u te ĩré rob'madâ, timama ãma wata da, sõpru wa. Taha pari, ma tô te te wẽ'ẽ, ĩ'u'ẽtẽ wapu hã. Pe'a zama, ma tô te te wẽ'ẽ. Ma tô te te sõmri oto, tisiré 're ĩnomro mono norĩ ma, te te dama sõmri mono da. ");
INSERT INTO xavNT_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Tawamhã dasa hã aihĩni ma tô huri ni. Ma tô da te 'mahâpãrĩ. Da te 'mahâpãrĩ mono parip si, ma tô si'õtõ wa, te te apâ ubumro za'ra, danho'rada hã, Zezusihi siré 're ĩnomro mono norĩ hã. Si'õno hã ahâ di, danho'rata ré hã, 12 na ĩhâiba hã. ");
INSERT INTO xavNT_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Tawamhã Zezusi hã bâtâ na te nhamra danhiti, mreme da, 'Re ĩhâimana u'âsi mono ma. Aibâ norĩ hã te ĩ'rata asimro, ĩsiré 're ĩnomro mono norĩ hã. Timama ma, mreme pari, te sadanharĩ za'ra tisiré norĩ hã, ãne: — E niha ma tô dasima ĩ̱wasu'u za'ra ni. E 'wa hã wa hã, wa 're mo. — Ãne te sadanharĩ za'ra. ");
INSERT INTO xavNT_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Taha wa, te asa tãma nharĩ za'ra: — Aiwasu'u hã, ahâ di. A hã, u, Zuwã Batita, apâ aihâiwa'udu. A hã, u, Eriasi apâ we aimorĩ. A hã, u, 'Re ĩhâimana u'âsi mono zadawa wasu'u 'rata 'wa, duréi pese atâ, apâ aihâiwa'udu. Ãne, wa tô aiwasu'u hã wapari za'ra ni. — Ãne te Zezusihi ma rowasu'u za'ra. ");
INSERT INTO xavNT_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Tawamhã Zezusi te duré sadanharĩ za'ra, ãne: — A norĩ wa'wa hã bété, e niha ma tô asima 're ĩ̱wasu'u za'ra wa'aba mo. — Ãne te sadanharĩ za'ra. Taha wa, te Pedru hã tãma tinha, ãne: — A hã Danho'reptui'wa, 'Re ĩhâimana u'âsi mono te te aipisudu. — Ãne te tãma tinha. ");
INSERT INTO xavNT_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Tawamhã Zezusi te sadawa uwati za'ra, te te a'â dama wasu'u tõ za'ra da, Danho'reptui'wa na. ");
INSERT INTO xavNT_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Taha wa, te tãma siwasu'u za'ra, ãne: — Wa hã ti'ai ãma dasiré ĩ̱podo hã, wa za robzépata za'ẽtẽ. Dama roti'wa norĩ hã te za siwi ĩ̱wẽ'õ za'ra. Duré 'Re ĩhâimana u'âsi mono ma, da'ãma romhuri'wa ĩpire norĩ hã, te za siwi ĩ̱wẽ'õ za'ra, sasedoti ĩpire norĩ hã. Rowahutu'wa norĩ zama, te za siwi ĩ̱wẽ'õ za'ra. Taha wa, te za dasiwi ĩ̱wĩrĩ ni. Tawamhã bâdâ maparane ĩ̱'ãma si'utõrĩ õ ré, wa za hâiwa'udu apâ. — Ãne te tãma siwasu'u za'ra, Zezusi hã. ");
INSERT INTO xavNT_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Tawamhã te uburé oto dama tinha, ãne: — Ni'wam norĩ hã ĩ̱siré 're nomro u'âsi mono da, te te sima 're ĩ̱wẽ za'ra mono wamhã, tihâimanazém na te te 're rosa'rata za'ra mono õ di za. Awẽ sidâpâsi, tiza'ozéb ré, ĩ̱zarina 're ĩnomro mono ne, da te dasiwi uprosi da nherẽ, te za ĩ̱siré 're nomro. ");
INSERT INTO xavNT_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Ni'wam norĩ hã tihâimanazé te te sima 're sawi za'ra mono wamhã, rowẽ ĩsi'utõrĩ'õ hã te te sina 're uwaimrami za'ra mono õ di za. Ni'wam norĩ hã ĩ̱zarina 're nomro mono da, tihâimanazé te te sima 're sawi za'ra mono õ wapsi, te za te te sina 're uwaimrami za'ra, rowẽ hã. ");
INSERT INTO xavNT_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Ãté ni'wa hã te za tinhibro hã te te sima 're a'ubumroi pese, sibrob ahâ uptabi da. Tawamhã te za oto dârâ. Ti'ab ré sibrob ahâ nherẽ, e tãma 're rowẽ mono di za, rowẽ ĩsi'utõrĩ'õ hã te te sina uwaimrami õ wamhã. Mare di. Tãma 're rowẽ mono õ di za. ");
INSERT INTO xavNT_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Ni'wam norĩ hã dapipa te, ĩ̱zazei'wa na, duré ĩ̱mreme 'madâ'â pese 'wa na, ãté dama 're siwasu'u za'ra mono õ di za, 're siséb za'ra mono õ'umnhasite. Ãté te za dawi 're si'udâ za'ra, ĩ̱zazei'õ'wa newa. Nimahã na, wa hã ti'ai ãma dasiré ĩ̱podo hã wa za wei mo apâ, ĩ̱hâiba na hã rowa'a za'ẽtẽ na. Ĩ̱mama hã rowa'a ré, te 're hâimana u'âsi. Hâiwa ãma tãma ĩromhuri'wa norĩ zama te duré ĩré 're hâimana u'âsi za'ra, hâimana wẽ na. Tane duré wa hã, wa za duré rowa'a za'ẽtẽ ré wei mo apâ. Tawamhã, apâ we ĩ̱morĩ wapsi, ĩ̱'udâ'wa norĩ hã ĩ̱zazei'wa na te sisi za'ra õ di za, ta norĩ hã. ");
INSERT INTO xavNT_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Tô sena wa aima rowasu'u za'ra wa'wa. Aihĩni õ nherẽ, ai'matâ'â aba õ ré, te za 'Re ĩhâimana u'âsi mono, da'ãma 're ĩsib'a'uwẽ mono zé hã ãma ĩ'madâ'â za'ra wa'wa. — Ãne ma tô dama waihu'u, Zezusi hã. ");
INSERT INTO xavNT_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Romhuri hã misi ãma si'utõrĩ pari, ma tô Zezusi hã te te siré simro, Pedru norĩ hã Zuwã norĩ me, Ti'adu norĩ me, 'Re ĩhâimana u'âsi mono ma, mreme da. Ẽtẽ 'rãihâ na, ma tô sai'uri za'ra. ");
INSERT INTO xavNT_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Zezusi hã Timama ma, mreme ré hã, aimawi oto ĩ'ubu hã. Duré, ma tô ti'uza hâirã. Hâirã uptabi di, ĩ'uza hã. Ma ai'ubuzi. ");
INSERT INTO xavNT_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","31","Tawamhã aibâ hã maparane, ma tô ĩtẽme sihâi'ré zahuré, Mozési norĩ hã, Eriasihi me. Ĩhâiba na hã rowa'a sa'ẽtẽ zahuré di. Ta norĩ hã Zezusihi me, te sima rowasu'u za'ra, 'Re ĩhâimana u'âsi mono te te tãma ĩpisutuzéb zarina, za ĩdâ'âzém na Zeruzarẽ ãma. ");
INSERT INTO xavNT_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Te te sima rowasu'u za'ra ré, te Pedru norĩ hã tinhotõ za'ra. Sõtõ pese za'ra di. Oto utu za'ra wamhã, ma tô Zezusi hã 'madâ'â za'ra. Ĩhâiba na hã rowa'a sa'ẽtẽ di. Aibâ norĩ zama ĩ'rata ĩsima'wara zama ma tô 'madâ'â za'ra. ");
INSERT INTO xavNT_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Aibâ norĩ hã oto apâ tiwi neb zahuré wa za, te Pedru hã Zezusihi ma tinha, ãne: — Rowahutu'wa, ãme wama rowẽ za'ra di. Si'ubdatõ, wa za aima 'ri za'ra wa'aba ni, aihâiba bâ wa'aba, ate da hã, duré Mozésihi te da hã, duré Eriasihi te da hã. — Ãne te tãma tinha, te te rosa'rata ãna, Pedru hã. ");
INSERT INTO xavNT_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Tawamhã Zezusihi ma, te te nharĩ ré, ma hâiwa nhirõtõ'a za'ẽne hã we hâiba zuwa za'ra, Zezusi norĩ hã. Taha wa, ma tãma tipahi za'ra. ");
INSERT INTO xavNT_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Hâiwa nhirõtõ hawi, te we 'Re ĩhâimana u'âsi mono hã tãma nharĩ za'ra, ãne: — Ã hã ĩ̱'ra, te ĩpisudu. Ma'ãpé ĩsimiroti hã 're wapari pese za'ra wa'aba mono za. — Ãne te we tãma nharĩ za'ra, Pedru norĩ ma. ");
INSERT INTO xavNT_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","We tãma mreme pari wamhã, siwaprosi te oto za, Zezusi hã. Ari'iwi te a'â tihâimana za'ra, mreme ãna, ĩsiré 're ĩnomro mono norĩ hã. Ni'wai ma, te te rowasu'u za'ra õ di a'â, te te ĩ'madâ'â za'ra zém na hã. ");
INSERT INTO xavNT_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Tawamhã awẽpsi ma tô ẽtẽ 'rãihâ hawi si'ra za'ra, Zezusi norĩ hã. Taha wa, da'ahâ na ma tô danhopẽtẽ za'ra, Zezusihi u ĩdasi'aba'ré hã. ");
INSERT INTO xavNT_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Aibâ hã dawa'wa ĩsa hã ma tô 'mahâ, ãne: — Rowahutu'wa, ĩ̱'ra ma, wa aiwi rowaptẽ, ĩ̱ma pese da. Ĩ̱'ra misire hã, ai'repudu. ");
INSERT INTO xavNT_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Wa'uburé hã te za upi. Te te upi wamhã, te za tizadari, ĩ̱'ra hã. Te za sitete. Te za sadaiproi watobro. Te te 're u'a u'âsi. Te te sazâri õ di. Õne u'â. ");
INSERT INTO xavNT_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Asiré 're ĩnomro mono norĩ ma, wa tô aré tãma 'ru za'ra, wa'uburé te te tãma me za'ra da. Tazahã, te te tãma mei waihu'u za'ra õ di. — Ãne te Zezusihi ma rowasu'u, ĩmama hã. ");
INSERT INTO xavNT_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Tawamhã te Zezusi hã tãma nharĩ za'ra, ãne: — E niha bété, ai'rata 're ĩ̱nhamra u'âsi aba mono nherẽ, asina 're ĩ̱'umnhasi za'ra wa'aba mono õ di, te 're ĩ'aipawaptob za'ra wa'aba mono zéb da hã. E niha te aiwasété na si 're anomro aba mo. E ĩ̱pẽ'ẽzé u'âsi, wa za ai'rata 're ĩ̱morĩ 'wa, 're ĩ̱'umnhasi za'ra wa'aba mono õ wa. — Ãne te tãma nharĩ za'ra. Taha wa, te aibâ ma tinha, ãne: — We ĩ̱tẽme saprõni pé, ai'ra hã. ");
INSERT INTO xavNT_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Tawamhã te te ĩtẽme saprõni ré, ma tô wa'uburé hã 'marõwĩ. Te sitete. Taha wa, te Zezusi hã tãma rob'ru, ai'reputu hawi watobro da. Taha wa, ma ĩhawi watobro. Rowẽ na te oto 're sãmra, ai'repudu hã. Taha wa, te Zezusi hã ĩmama ma tinha, ãne: — Ãhãta ai'ra hã. Tãma rowẽ di oto. — Ãne ma tô ĩmama ma waihu'u, Zezusi hã. ");
INSERT INTO xavNT_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Taha wa, ma ãma tatob'uzu za'ra ni, waihu'u pese uptabi wa, 'Re ĩhâimana u'âsi mono hã. Zezusi te te 're ĩda'apese mono zém na, ãma datob'uzu za'ra ré, te tisiré 're ĩnomro mono norĩ ma Zezusi hã tinha, ãne: ");
INSERT INTO xavNT_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","— Wa za aima ĩ̱siwasu'u za'ra wa'wa. Aima ĩ̱siwasu'u za'ra wa'aba zém na, aipo're si'âri za'ra wa'aba õ di za. Wa hã ti'ai ãma dasiré ĩ̱podo hã te za dasima ĩ̱hâiba nhomri ni. — Ãne te tãma siwasu'u za'ra. ");
INSERT INTO xavNT_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Tane nherẽ, te te siwi waihu'u za'ra õ di, te te sina ĩrowasu'uzém na hã. Ma tô tiwi sawi za'ra Zezusi hã, te te waihu'u pese za'ra tõ da a'â, te te sina ĩrowasu'uzé hã. Taha wa, te te sina ĩrowasu'uzé ma, pahi za'ra wa, te te siwi sadanharĩ za'ra õ di, ãma. Taha wa, te ari'iwi ai'ubumro. ");
INSERT INTO xavNT_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Tawamhã sima ĩ'maipire zô sõpré wa, ãma sisaze za'ra õ wa, te timreme na 'râwi si'wapé za'ra, ĩsiré 're ĩnomro mono norĩ hã. ");
INSERT INTO xavNT_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Ĩsimirosa'rada hã ma tô waihu'u za'ra, Zezusi hã. Taha wa, ma tô ai'uté hã sisababa tisã. ");
INSERT INTO xavNT_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Te duré tãma nharĩ za'ra, ãne: — Ni'wam norĩ hã te te 're ĩ̱zawi pese za'ra mono wa, ai'uté zô 're tob'uzu za'ra mono wamhã, ta norĩ u'âbâ te duré ĩ̱zô 're tob'uzu za'ra. Tawamhã, e ĩ̱zô si te 're tob'uzu za'ra. Mare di. We ĩ̱zatõrĩ'wa zô zama te duré sô 're tob'uzu za'ra. Dama ĩwapu norĩ hã 're sawi pese za'ra wa'aba mono wamhã, asima ai'maipire zô asõpré wa'aba ãna, wa za aipire na te 're ai'awaihu'u 'wa. — Ãne, Zezusi ma tô tãma waihu'u za'ra, tisiré 're ĩnomro mono norĩ ma. ");
INSERT INTO xavNT_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Tawamhã Zuwã hã te tinha, ãne: — Rowahutu'wa, aibâ, wa tô 'madâ'â za'ra ni, asisi na wa'uburé ma, te te 're ĩrob'rui mono hã, dama 're wairébé mono da. Taha wa, ma tô dama 're wairébé. Õ hã, wasiré 're morĩ õ di. Taha wa, wa tô tiwi sawi za'ra ni, asisi na wa'uburé ma, te te 're arob'ru tõ mono da, wasiré 're morĩ õ wa. — Ãne te Zezusihi ma siwasu'u, Zuwã hã. ");
INSERT INTO xavNT_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Taha wa, te Zezusi hã asa tãma nharĩ za'ra, Zuwã norĩ ma: — Tiwi sawi za'ra wa'aba õ di za, ĩsimiromhuri hã. Ãté ni'wa hã te te 're aiwasu'u wasété za'ra wa'aba mono õ di za. Tane wamhã, aiwẽ wa'aba 'wa na, te za ãma ĩwaihu'u za'ra wa'wa. Taha wa, aibâ hã aiwẽ wa'aba 'wa, 're morĩ nherẽ, tiwi sawi za'ra wa'aba õ di za, ĩsimiromhuri hã. — Ãne, Zezusi te tãma roti za'ra, tisiré 're ĩnomro mono norĩ ma. ");
INSERT INTO xavNT_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Zezusi hã hâiwa u za ĩmorĩzé hã romhuture wa, ma tô sina roti, Zeruzarẽ u morĩ da. ");
INSERT INTO xavNT_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Taha wa, ma tô aibâ norĩ hã sisõwa satõrĩ za'ra, ĩsãmrazéb da hã, te te sô 'maipisutu za'ra da. Si'aba'réi wamhã, ma tô aihutu, 'ri wa'õtõ u. Samaritanu norĩ rob ãma, 'ri wa'õno hã. ");
INSERT INTO xavNT_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Sihutu wamhã, sô tob'uzu za'ra õ di, samaritanu norĩ hã. Zeruzarẽ u, za morĩ wa, te te sima wẽ za'ra õ di, ĩ'rata sãmra za'ra da, Zezusi hã. ");
INSERT INTO xavNT_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Tawamhã samaritanu norĩ wasu'u, ma tô wapari zahuré, Ti'adu norĩ hã, Zuwãhã me. Ĩwasu'u hã te te wapari zahuré wamhã, te Zezusi 'mahârâ zahuré, ãne: — E aima wẽ di, unhama zô wahârâ da, hâiwa hawi we te te da'uprosi da. — Ãne te 'mahârâ zahuré. ");
INSERT INTO xavNT_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Taha wa, ma Zezusi hã ĩtẽme aipi'ra zahuré. Ĩmreme hã ma tô tiwi sisisi zahuré. ");
INSERT INTO xavNT_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Taha pari, ma tô ai'aba'ré, 'ri wa'õtõ hâiba amoi u. ");
INSERT INTO xavNT_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Tawamhã bâdâdi na si'aba'réi ré, te aibâ hã Zezusihi ma tinha, ãne: — Nimomo 're aimorĩ wamhã, asiré, wa za 're mo. — Ãne te Zezusihi ma tinha. ");
INSERT INTO xavNT_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Taha wa, te Zezusi hã asa tãma tinha: — Wapsã wawẽre hã, ab're 're ĩsõrõwa hã. Si norĩ hã te duré tizasi hã te te sima 're 'manharĩ za'ra, tinhorõwa da hã. Tanei õ di wa hã, ti'ai ãma dasiré ĩ̱podo hã. Marĩ ĩ̱ma hâimana õ di, 're ĩ̱wa'utu mono zéb da hã. Hâiwi si wa datẽme 're morĩ u'â. — Ãne, Zezusi ma tô tãma siwasu'u. ");
INSERT INTO xavNT_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Tawamhã Zezusi te aibâ hâiba amo 'mahâ, ĩsiré morĩ da. Taha wa, te asa tãma tinha: — Apito, a'â apâ ĩ̱morĩ, nimahã bâtâ na ĩ̱mama hã ĩ̱wi dâ'â wa, ĩ̱sisa'u te ãma ti'a da. — Ãne te sina 'mahâ. ");
INSERT INTO xavNT_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Tane nherẽ, te aibâ ma tinha asa: — Ĩdâ'â norĩ hã te za tisiré ĩdâ'â norĩ ãma, te te 're ti'a za'ra. A hã te za datẽme 're aimo, 'Re ĩhâimana u'âsi mono, da'ãma 're ĩsib'a'uwẽ mono zém na, 're da'apo're pu'u mono da. — Ãne te aibâ ma tinha. ");
INSERT INTO xavNT_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Aibâ hâiba amo hã te duré Zezusi 'mahâ, ãne: — Wa hã wa za asiré 're mo. A'â ĩ̱sisãnawã norĩ, te sawi za'ra, ĩ̱sisa'u. — Ãne te Zezusihi ma tinha. ");
INSERT INTO xavNT_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Taha wa, ma tô tãma ãma romnhimiré'é Zezusi hã, ãne: — Ãté ni'wa hã te za romhuri na sãna'rata, ti'a te te hâibâdâ da. Siwa'rãmi te te nasi 'madâ'â wamhã, tinhib'apito ma, romhuri'wa da hã mare di. Tane duré, 'Re ĩhâimana u'âsi mono, da'ãma 're ĩsib'a'uwẽ mono zém na romhuri'wa da hã mare di, misi, da te 're pisutu za'ra mono õ wa. — Ãne ma tô aibâ ma waihu'u, Zezusi hã. ");
INSERT INTO xavNT_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Taha pari, ma tô Zezusi hã aibâ ahâ na pisutu za'ra, ĩsõwa datẽme 're nomro mono da, 72 na aibâ norĩ hâiba za'ra hã. Maparane si, ma tô te te apisutu, 'ri wa'õtõ mono bâ ĩwana te te datẽme ropéi mono da, za datẽme ĩmorĩzé wana, datẽme si'aba'ré da. ");
INSERT INTO xavNT_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Taha wa, si'aba'réi õ ré, te tãma romnhimiré'é za'ra, ãne: — Amnho hã sa'ẽtẽ na 're simi'wara mono wamhã, duré romhuri'wa norĩ hã umrore wamhã, te za buru tede'wai wi waptẽrẽ za'ra, sada dasitob da. Tane a norĩ wa'wa hã ai'umrore wa'aba wa, te za 'Re ĩhâimana u'âsi mono wi 're ĩrowaptẽrẽ za'ra wa'aba mo, te te 're da'apisutu mono da, ĩsadawa wasu'u'wa da hã. ");
INSERT INTO xavNT_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Te za oto datẽme 're ĩropéi wa'aba mo. Pone'ẽrebâ 'ra, robzahi wa'wa u 're ĩsisisi mono ne, wa za datẽme asatõrĩ za'ra wa'wa, datẽme 're ropéi wa'aba mono da oto. ");
INSERT INTO xavNT_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Marĩ hã asiré 're 'wasari aba mono õ di za, ro'wapézé hã, duré rob'uiprazé nhemezé hã, duré aipara'uza hã. Duré, 're asimizahâri za'ra wa'aba mono õ di za, bâdâdi wa, 're dazawi za'ra wa'aba mono da. ");
INSERT INTO xavNT_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Duré, danhorõwa u 're aihutu aba mono wamhã, te za a'â 're ĩdazawi za'ra wa'aba mo, rowẽ na 're dahâimana za'ra mono da. ");
INSERT INTO xavNT_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Simizawi pese wamhã, 'ri tede'wa hã rowẽ na te za 're hâimana. Mreme wasété wamhã, rowẽ na 're hâimana mono õ di za. ");
INSERT INTO xavNT_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Datẽme 're aihutu aba mono wamhã, 'ri baba 're anomro aba mono õ di za. 'Re aihutu aba mono zéb ãma si, te za 're aihâimana za'ra wa'aba mo. Tame te za danhipi hã da te aima 're ĩsõmri za'ra wa'aba mono na 're asaihuri aba mo. Tame te za duré 're ĩ'âhuri aba mo. Romhuri'wa pawa'â hã tãma 're ĩwairébé mono ne, te za taré asa hã da te aima 're sõmri za'ra wa'wa, wa'âbâ ãna asimirowasu'u wa'rãmi wa'aba. ");
INSERT INTO xavNT_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","— Datẽme 're aihutu aba mono wamhã, ãté 're aihutu aba mono wi, te za da te 're asawi za'ra wa'wa. Duré danhipi, da te aima 're ĩsõmri za'ra wa'aba mono na te za 're asaihuri aba mo. ");
INSERT INTO xavNT_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Tame 're ai'ubumroi wa'aba mono ré, te za 're ĩdapese za'ra wa'aba mo. Duré te za ãne dama 're ĩrowasu'u za'ra wa'aba mo: “Ãhãna bâdâ hã ma tô oto ĩwa waptãrã, 'Re ĩhâimana u'âsi mono hã da'ãma 're ĩsib'a'uwẽ mono zéb da hã.” Ãne te za dama 're ĩrowasu'u za'ra wa'aba mo. ");
INSERT INTO xavNT_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","11","Datẽme 're aihutu aba mono wamhã, da te 're asawi za'ra wa'aba mono õ di za ãté. Taha wa, te za dahawi 're aiwairébé aba mo. Dahawi 're aiwairébé aba mono õ ré, te za dama 're ĩrowasu'u za'ra wa'aba mo, ãne: “Wanhimirowasu'u na, ma tô asiwi ĩwawẽ'õ za'ra wa'wa. Taha wa, wa za wapara zapru hã wamirĩ za'ra ni, rere'e da, ti'a hã, aiwasété na ãma 're asiwaihu'u za'ra wa'aba mono zéb da hã. Ãhãna bâdâ hã ma tô oto ĩwa waptãrã, 'Re ĩhâimana u'âsi mono hã da'ãma 're ĩsib'a'uwẽ mono zéb da hã. Ãne na, te za ĩwaihu'u za'ra wa'wa.” Ãne te za aiwẽ'õ'wa norĩ wa'aba ma 're ĩrowasu'u za'ra wa'aba mo. — Ãne te tãma roti za'ra, Zezusi hã. ");
INSERT INTO xavNT_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Ma duré tãma waihu'u za'ra, ãne: — Niwapsi, aiwẽ'õ'wa norĩ wa'aba ma hã, 're robze za'ra mono õ di za. Niwapsi bâdâ hã ĩwa ĩwaptã'ãzém na, te za dazô nhamra, marĩ, da te 're ĩ'manharĩ za'ra mono zém na, te te 're da'awaihu'u mono da, 'Re ĩhâimana u'âsi mono hã. Sodoma ãma 're ĩdasi'ubumroi mono norĩ ma, te te ĩrob'manharĩ pipa zém nhipai u, te za tô aiwẽ'õ'wa norĩ wa'aba ma, te te tãma 're arob'manharĩ za'ẽtẽ. — Ãne ma tô Zezusi hã tãma waihu'u za'ra, tisiré 're ĩnomro mono norĩ ma. ");
INSERT INTO xavNT_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Tinhimiroti na ma tô duré ãne ãma uzusi, Zezusi hã: — Corazi na 'ri wa'õtõ nhisi ãma 're aihâimana za'ra wa'aba mono norĩ ma, aima 're ropipa uptabi za'ra wa'aba mono di za, Besada na 'ri wa'õtõ nhisi ãma 're aihâimana za'ra wa'aba mono norĩ ma zama. Marĩ, dama ĩ'manharĩ waihu'u'õ hã asõ'a za'ra wa'aba, te 're ĩ'ab'manharĩ wẽ mono ne, Tiru ãma 'ri nho'õmo ãma, duré Sido ãma 'ri nho'õmo ãma 're ĩdahâimana za'ra mono norĩ nho'a, te dama 're ab'manharĩ mono 'wa'âhã, duréi te aré ta norĩ hã 're sipizari za'ra, tiwasété wi. Tiwasété wi 're ĩsipizari za'ra mono zém na, da te 're waihu'u za'ra mono da, te aré 'ru'a hã ti'rã ãma te te 're sa'wari za'ra. Te duré aré sa'u ĩhâiro na 're si'uza za'ra. ");
INSERT INTO xavNT_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Tane nherẽ, tanei õ di, a norĩ wa'wa hã. Niwapsi 'Re ĩhâimana u'âsi mono, da'ãma ĩsipo'ozéb ãma hã, Tiru ãma duré Sido ãma 're ĩdahâimana wasété za'ra mono norĩ ma, te te ĩrob'manharĩ pipa zém nhipai u, te za te te 're aihâ za'ra za'ẽtẽ za'ra wa'wa, 'Re ĩhâimana u'âsi mono hã. ");
INSERT INTO xavNT_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Capana'u ãma 're aihâimana za'ra wa'aba mono norĩ hã, e danhipai u aipire na 're aihâimana za'ra wa'aba mono da, ma tô asina 're ĩrosa'rata za'ra wa'aba mo. Ropipa u si, te za 'Re ĩhâimana u'âsi mono hã te te 're asãmra 'wa. — Ãne Zezusi ma tô tãma nharĩ za'ra, da'ãma pẽ'ẽzé uptabi wa. ");
INSERT INTO xavNT_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Tawamhã te tãma nharĩ za'ra, tisiré 're ĩnomro mono norĩ ma, ãne: — Ni'wam norĩ hã ĩ̱zadawa wasu'u na, te te 're aiwapari pese za'ra wa'aba mono wamhã, ĩ̱mreme 'madâ'â pese 'wa na, wa za ta norĩ hã te ĩ̱sina 're awaihu'u. Duré ni'wam norĩ hã ĩ̱zadawa wasu'u na te te 're aiwẽ'õ za'ra wa'aba mono wamhã, ĩ̱wẽ'õ'wa na, wa za duré ta norĩ hã ĩ̱sina te 're awaihu'u. We ĩ̱zatõrĩ'wai wẽ'õ'wa na zama, wa za ta norĩ hã te ĩ̱sina 're awaihu'u. — Ãne ma tô tãma waihu'u za'ra, tisiré 're ĩnomro mono norĩ ma, Zezusi hã. ");
INSERT INTO xavNT_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Tawamhã datẽme 're nomro mono pari, ma tô apâ aihutu ĩtẽme, aibâ norĩ hã, 72 na ĩhâiba za'ra hã. Tãma rowẽ za'ra wa, toi uptabi za'ra di. Taha wa, te ãne siwasu'u za'ra, Zezusihi ma: — Wanhib'apito, asisi na, wa tô wa'uburé ma, wa te 're rob'ru za'ra, dahawi 're wairébé mono da. Taha wa, ma tô te te 're wawapari za'ra, ta norĩ hã. — Ãne te tãma siwasu'u za'ra. ");
INSERT INTO xavNT_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Taha wa, ma tô Zezusi hã asa tãma waihu'u za'ra, ãne: — Tane tô. 'Re ĩhâimana u'âsi mono hã ma tô Satanasi hã wa'rui'wa hã hâiwa hawi time. Waptã'ã wamhã, wa tô 'madâ. Wara sina, ma waptãrã, tãiwapsa'a ne. ");
INSERT INTO xavNT_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Ĩ̱wapari pese za'ra wa'aba. Wa tô aima waihu'u za'ra wa'wa, ĩ̱zadawa para, wahi norĩ hã duré apa'apa 'wa nhi'oto norĩ hã, aipara na 're simroi wa'aba mono da. Wa'rui'wa hã dama siptete nherẽ, te za asiptete sina tiwi 're anomro aba mo. Tawamhã te te 're aihõsi za'ra wa'aba mono õ di za, wa'rui'wa hã. Niha te te aima 're rob'manharĩ za'ra wa'aba mono õ di za. ");
INSERT INTO xavNT_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Asimirob'ru zarina wa'aba, wa'uburé hã dama 're wairébé mono wa, ma tô 're ato za'ra wa'aba mo. Tane nherẽ, taha nhipai u te za 're ato uptabi za'ra wa'aba mo, asisi hã hâiwa ãma 're hâimana za'ra wa'aba mono wa, asisi ui'éré za'ra wa'wa hã. — Ãne ma tô Zezusi hã tãma waihu'u za'ra. ");
INSERT INTO xavNT_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Tame 'Re ĩhâimana u'âsi mono pẽ'ẽzani te te tãma ĩwaihu'uzéb zarina, te 're to, Zezusi hã. Toi uptabi di oto. Taha wa, te Timama ma tinha, ãne: — Ĩ̱mama, a hã Danhib'apito uptabi, hâiwa ãma zama, ti'ai ãma zama. Ã norĩ hã marĩ te te waihu'u za'ẽtẽ za'ra õ di. Tane nherẽ, ma tô marĩ ĩwẽ hã tãma ĩwaihu'u za'ra. Rowaihu'u pese 'wa norĩ ma hã, marĩ hã ĩwẽ hã tãma waihu'u za'ra õ di. Tane tô, Ĩ̱mama. Asima ĩwẽzéb uwaibaba, ma tô ã norĩ ma si a'â ĩwaihu'u za'ra, marĩ ĩwẽ hã. Taha wa, wa ai'ãma ĩ̱wata, asõpru wa. — Ãne te Timama ma tinha, Zezusi hã. ");
INSERT INTO xavNT_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Te duré tãma nharĩ za'ra, aibâ norĩ ma: — Ĩ̱mama ma tô ĩ̱ma waihu'u, uburé 're ĩhâimana mono zé hã. Ni'wam norĩ hã si'uihâ na te te 're ĩ̱waihu'u za'ra mono õ di, 're ĩ̱hâimana mono zém na hã. Ĩ̱mama si ma tô ti'ra na ĩ̱waihu'u pese, 're ĩ̱hâimana mono zém na hã. Duré dasi'uihâ na Ĩ̱mama, da te 're waihu'u za'ra mono õ di za. Ĩ̱wétési wa tô Ĩ̱mama hã waihu'u pese, 're ĩhâimana mono zém na hã. Te ĩ̱sima 're ĩ'awẽ mono zéb uwaibaba si, wa za ni'wam norĩ ma, te 're awaihu'u, ta norĩ zama Ĩ̱mama hã te te waihu'u za'ra da, 're ĩhâimana mono zém na. — Ãne ma tô tãma waihu'u za'ra, Zezusi hã. ");
INSERT INTO xavNT_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","24","Taha pari, ma tô aipi'ra, tisiré 're ĩnomro mono norĩ u, siwaprosi te te tãma rowasu'u za'ra da. Taha wa, te ãne tãma nharĩ za'ra: — A norĩ wa'wa hã aima 're rowẽ za'ra wa'aba mono di. Atõmo na ma tô 're ĩ'madâ'â za'ra wa'aba mo, te dama 're ĩ'ab'manharĩ wẽ mono zé hã. Aiwana wa'aba, ma tô da'ahâ na 're dasi'ubumro, 'Re ĩhâimana u'âsi mono zadawa wasu'u'wa norĩ hã, danhib'apito norĩ zama. Ta norĩ hã ma tô aré te te sima 're wẽ za'ra, te te 're 'madâ'â za'ra mono da, 're ĩ'madâ'â za'ra wa'aba mono zé hã. Ma tô duré te te sima 're wẽ za'ra, te te 're wapari za'ra mono da, 're ĩwapari za'ra wa'aba mono zé hã. Taha wa, a norĩ wa'aba ma si, 're rowẽ za'ra wa'aba mono di. — Ãne ma tô tãma waihu'u za'ra, Zezusi hã. ");
INSERT INTO xavNT_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Tame ma tô aibâ hã wahudu hâiwi, 'Re ĩhâimana u'âsi mono nhimiroti na dama rowahutu'wa hã. Zezusi te te ĩroti na te te pibu da, ma tô ãne 'mahâ: — Rowahutu'wa, e marĩ, wa za te 're ab'manharĩ ĩwẽ hã, 're ĩ̱hâimana u'âsi mono zéb da hã, te ĩ̱sina uwaimrami da hã, hâiwa ãma. — Ãne te 'mahâ. ");
INSERT INTO xavNT_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Taha wa, te Zezusi hã asa tãma tinha: — E niha 'Re ĩhâimana u'âsi mono nhimiroti na, ĩwasu'u na rob'ui'éré hã. E niha asimirosa'rada hã, ãma. — Ãne te sadanha. ");
INSERT INTO xavNT_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Taha wa, ma tô aibâ hã ãma sada'â asa: — 'Re ĩhâimana u'âsi mono hã, Asib'apito za'ra wa'wa hã 're morĩ wa, te za asiwi 're ĩsawi pese za'ra wa'aba mo. Taha zarina, te za ĩsimiroti na ãma 're ĩrosa'rata u'âsi za'ra wa'aba mo. Taha zarina, te za duré asimi'ẽ na tãma 're ĩromhuri u'âsi za'ra wa'aba mo. Te za duré 're ĩdazawi pese za'ra wa'aba mo, uburé. Marĩ ĩwẽ zô asima 're asõpré wa'aba mono ne, te za duré uburé dama zama sô 're asõpré wa'aba mo, ĩwẽ zô. Ãne ĩsimiroti na rob'ui'éré hã. — Ãne ma tô aibâ hã Zezusihi ma rob'rãzarõtõ. ");
INSERT INTO xavNT_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Taha wa, te Zezusi hã asa duré tãma tinha: — Tane tô. Ĩ'uwaibaba ma tô ĩ̱ma ĩwaihu. Tawamhã, taha zarina 're aihâimana mono wamhã, 'Re ĩhâimana u'âsi mono 'rata te za 're aihâimana u'âsi mo, hâiwa ãma. — Ãne te aibâ ma tinha. ");
INSERT INTO xavNT_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Aibâ hã, uburé te te 're da'azawi pese mono õ di. Taha wa, te asa Zezusihi ma tinha: — E 'wam norĩ hã wa za wa te 're sawi pese za'ra. — Ãne te Zezusihi ma tinha. ");
INSERT INTO xavNT_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Taha wa, te Zezusi hã tãma romnhimiré'é, ãne: — Aibâ hã ma tô si'ra Zeruzarẽ hawi, Zerico u morĩ da. Tawamhã morĩ ré, ma tô sô wairé, ĩsipsaihuri norĩ hã. Ĩ'uza, ma tô tiwi sani za'ra. Te te siwi 're pré'é. Te aré oto siwi tĩwĩ. Te te siwi 're pré'é mono pari, te oto ai'aba'ré. ");
INSERT INTO xavNT_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Tawamhã ĩsa'u za'ra si te sasedoti hã mo duré, da te ĩ'u'iti wa'wai baba, 'Re ĩhâimana u'âsi mono ma, da'ãma romhuri'wa hã. Aibâ hã te te sãmri wamhã, bâdâdi zada'ré niwĩ, te timorĩ waré, ĩsiti. ");
INSERT INTO xavNT_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Tawamhã aibâ ĩhâiba amo hã te duré ĩwa'wai baba mo, Réwihi nhihudu hã, sasedoti norĩ pawapto'wa hã. Aibâ te te 'madâ'â wamhã, te duré bâdâdi zada'ré niwĩ mo, ĩsiti. ");
INSERT INTO xavNT_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Tawamhã te duré aibâ hâiba amo hã ĩwa'wai baba mo, darob amoi u morĩ da. Ta hã, samaritanu. Ta hã ma tô 'madâ, aibâ ĩhâzé ré hã. Te te 'madâ'â wamhã, ma tô ãma tipẽ'ẽzé. ");
INSERT INTO xavNT_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Taha wa, ma tô ĩtẽme mo. Ma tô 'wa're upsõ, rob'rãi wa'u ĩsé na. Taha pari, ma tô 'wa're u'ré, rob'rãi wa'u na, ĩwab ré na. Te te u'réi parimhã, ma tô 'wa're ubu. Taha pari, ma tô tinhimizama ba nhisiwi tihi, 're ĩdanhimi'wara mono zéb u te te hiri da. Tame te 'madâ, a'â. ");
INSERT INTO xavNT_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Tawamhã awẽmhã, rob'uiprazé hã ma tô 'ri tede'wai ma tisõ, maparane ĩsapotore hã, ẽtẽ'ubuzi'a prata 'manharĩ hã. Te tãma tinha, ãne: “Ĩ̱zô 'madâ'â pese. Apâ we ĩ̱morĩ wapsi, wa za aima wa'âbâ 'rãsutu, ĩwab õ wamhã, rob'uiprazé hã.” Ãne ma tô 'ri tede'wai ma tinha, samaritanu hã. Ãne samaritanu wasu'u hã. — Ãne ma tô rowasu'u Zezusi hã, rowahutu'wai ma. ");
INSERT INTO xavNT_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Tawamhã Zezusi hã te oto aibâ hã ãma sadanha: — Aibâ si'ubdatõ, ma tô siparabâsi aibâ wa'wai baba ai'aba'ré, da te aré ĩwĩrĩ wa'wai baba. E 'wa hã ĩsawi pese 'wa, te 're mo. — Ãne te sadanha, Zezusi hã. ");
INSERT INTO xavNT_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Taha wa, te asa tãma tinha: — Aibâ pawapto'wa, ta hã ĩsawi pese 'wa. — Ãne te Zezusihi ma tinha. Zezusi te duré asa tãma tinha: — Tane tô. Mo oto aimorĩ, ĩsine 're aimorĩ da. — Ãne ma tô tãma waihu'u Zezusi hã, rowahutu'wai ma. ");
INSERT INTO xavNT_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Tawamhã Zezusi norĩ hã te duré ai'aba'ré, ĩsiré 're ĩnomro mono norĩ me. 'Ri wa'õtõ u, ma tô aihutu. Sihutu wamhã, ma tô pi'õ hã Zezusihi ma tinha, 'ri para u sisisi da, Mata na pi'õ nhisi hã. ");
INSERT INTO xavNT_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","'Ri para u sisisi wamhã, ma tô Mariza hã Zezusihi 'rata nhamra, ti'a, ĩsimirowasu'u hã te te wapari da. Mataha no, Mariza hã. ");
INSERT INTO xavNT_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Mata hã si'wa'rutu di, 'ri paramhã romhuri hã ahâ wa. Taha wa, te Zezusihi u mo, Mata hã. Ãne te tãma tinha: — Ĩ̱no hã, ĩ̱'ãma sapa'a õ di. Ĩ̱siwaprosi, wa romhu. Romhuri hã ahâ di. Ĩ̱'ãma aipẽ'ẽzé wamhã, ma'ãpé we ĩ̱tẽme satõrĩ, te te ĩ̱pawaptob da. — Ãne Mata te Zezusihi ma tinha. ");
INSERT INTO xavNT_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Taha wa, ma tô Wanhib'apito hã asa tãma tinha: — Mata, marĩ hã ahâ wamhã, tô asi'wa'rutu di. ");
INSERT INTO xavNT_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Marĩ hã misi ĩwẽ hã asima pisutu õ di. Ta hã ma tô Marizaha si sima pisutu. Taha wa, ni'wa hã ĩwẽ hã te te tiwi âri õ di za, te te ĩwaparizé hã. — Ãne Zezusi ma tô Mataha ma waihu'u. ");
INSERT INTO xavNT_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Tawamhã nimahã bâtâ na, te Zezusi hã nhamra, Timama ma, mreme da. Tãma mreme pari, ma tô misi ĩsiré 're ĩnomro mono norĩ hã 'mai'mahâ: — Wanhib'apito, ma'ãpé wama waihu'u, 'Re ĩhâimana u'âsi mono ma, 're ĩwamreme zusi mono zéb da hã, wa te waihu'u za'ra da. Zuwã hã tinhimi'ubumro norĩ ma, te te ĩwaihu'u ne, te za wama ĩwaihu, wa te waihu'u za'ra da. — Ãne te tãma tinha. ");
INSERT INTO xavNT_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Taha wa, ma tô Zezusi hã asa tãma nharĩ za'ra: — Ãne te za 're aimreme zusi aba mo, 'Re ĩhâimana u'âsi mono ma: “Wamama, asisi wẽ na uburé da te 're aiwaihu'u za'ra mono da, wa aima da'ãma 're ĩ̱mreme. Uburé da'ãma 're asib'a'uwẽ mono da, wa duré da'ãma 're ĩ̱mreme. ");
INSERT INTO xavNT_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Awẽ sidâpâsi, wei wama 're anhomri mono, wasa hã ãma 're ĩwasaihuri mono zéb da hã. ");
INSERT INTO xavNT_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Dawasédé hã da te wa'ãma 're 'manharĩ za'ra mono wa, wa te wasina 're ĩ'madâ'â za'ra mono õ zarina, a hã duré wa'ãma 're ab'madâ'â mono õ di za, wawasédé hã. Duré, 're wa'ab'madâ'â nhimini mono õ di za, Wa'uburé hã te te 're wa'a'upi mono wa, wawasété u 're warere'e tõ mono da.” Ãne ma tô Zezusi hã tãma waihu'u za'ra, tisiré 're ĩnomro mono norĩ ma. ");
INSERT INTO xavNT_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Taha pari, te tãma ãma romnhimiré'é za'ra, tisiré 're ĩnomro mono norĩ ma, ãne: — Ãté, asiwadi te za mara wa'wa atẽme ti'maiwisi 'wa, asõrõwa wa'aba u hã. Tawamhã, ãté marĩ õ wa, te za ai'maimorĩ 'wa, asiwadi hâiba amo nhorõwa u. Rowi, te za tãma ĩ'manharĩ 'wa: “Wa we atẽme mo, ĩ'u'ẽtẽ wapu hã ĩ̱ma 'manhomri da a'â taré. Taha wa, te za si'ubdatõ ĩ̱ma ĩsõ a'â. ");
INSERT INTO xavNT_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","Nimosi ma tô we ĩ̱tẽme wi, ĩ̱siwadi hã, romhâ hawimhã. Tane nherẽ, marĩ õ di, te tãma ĩsõmri da hã.” Ãté, ãne te za tãma ĩ'manharĩ 'wa, 'ri tede'wai ma. ");
INSERT INTO xavNT_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","8","— Taha wa, te za ãté asa aima 'manharĩ 'wa: “Tane nherẽ, ĩ̱'utu zei õ di. Taha wa, ĩ'u'ẽtẽ wapu hã te aima sõmri neza. Wa tô 'rinhito. Ĩ̱'ra norĩ me, wa oto wanhotõ za'ra ni.” Ãté, ãne te za aima 'manharĩ 'wa, asiwadi wa'wa hã. Tazahã, te za sô wahudu, ĩ'u'ẽtẽ wapu zô, tiwi ĩwaptẽrẽzéb uwaibaba, te te aima 'manhomri da. E marĩ wa, te za aima 'manho. E asiwadi wa, te za aima 'manho. Mare di. Taha wab õ di. Marĩ õ wa, nasi tiwi waptẽrẽ wa, te za aima 'manho. ");
INSERT INTO xavNT_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","10","Taha wa, 'Re ĩhâimana u'âsi mono wi, te za ĩwẽ hã 're ĩwaptẽrẽ u'âsi za'ra wa'aba mo. Tawamhã te za tô te te aima 're anhomri 'wa. Ĩwẽ zô si te za duré asima 're asõpré u'âsi aba mo. Tawamhã taha zarina te za tô te te aima ãma 're a'uwaimrami 'wa, 'Re ĩhâimana u'âsi mono hã, 'râwi aima 're hâimana za'ra wa'aba mono da. Duré ni'wa hã 'ri tede'wa zô, te te 're ĩ'ridawa ta'a mono ne, te za ĩwẽ hã tiwi 're ĩwaptẽrẽ za'ra wa'aba mo. Tawamhã 'ri tede'wa te te tãma ĩ'ridawa ne, te za tô te te aima 're anhomri 'wa, ĩwẽ hã, 'Re ĩhâimana u'âsi mono hã. ");
INSERT INTO xavNT_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Ãne, wa za duré aima ãma romnhimiré'é za'ra wa'wa. Damama na 're ai'maihâimana aba mono wamhã, ãté ai'ra hã pe'a hã te za aiwi waptẽ. E tawamhã, te za wahi hã tãma ĩsõ. Mare di. Pe'a si, te za tô tãma ĩsõ, te te 'rẽne da. ");
INSERT INTO xavNT_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Duré ai'ra hã, si'a're hã te te aiwi waptẽrẽ wamhã, e te za apa'apa 'wa nhi'odo hã tãma ĩsõ. Mare di. Si'a're si, te za tô tãma ĩsõ. ");
INSERT INTO xavNT_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Tane duré, a norĩ wa'wa hã 're anomro wẽ uptabi aba mono õ nherẽ, te za marĩ ĩwẽ si tô ai'ra norĩ ma 're ĩsõmri za'ra wa'aba mo. Aimama 'wa hã hâiwa ãma 're ĩhâimana mono hã, te za asõpru wa'aba zém nhipai u, ĩwẽ hã te te aima 're sõmri za'ẽtẽ za'ra wa'wa, tiwi 're rowaptẽrẽ za'ra wa'aba mono wamhã. Tipẽ'ẽzani hã te za te te aima 're anhomri 'wa. — Ãne ma tô Zezusi hã tãma waihu'u za'ra, tisiré 're ĩnomro mono norĩ ma. ");
INSERT INTO xavNT_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Tawamhã Zezusi hã aibâ ma, ma tô wa'uburé hã time. Ĩpẽ'ẽ 're, sãmra wa, mreme waihu'u õ di aré, aibâ hã. Oto aibâ hawi watobro wamhã, ma tô mreme watobro, aibâ hã. Taha wa, ma tô ãma tatob'uzu za'ra ni. ");
INSERT INTO xavNT_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Tazahã, ni'wam norĩ hã dame ĩsimasam norĩ hã, te Zezusihi ma nharĩ wasété za'ra, ãne: — Bezebuhu zadawa para, ma tô wa'uburé hã te te dama 're anhamra, wa'uburé norĩ nhib'apito zadawa para. — Ãne te tãma nharĩ wasété za'ra. ");
INSERT INTO xavNT_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Ĩhâiba amo norĩ hã te duré wada'uri za'ra, ãne: — Ma'ãpé wanho'a, marĩ dama ĩ'manharĩ waihu'u'õ hã wama 'manharĩ za'ra na, aiwaihu'u pese na, 'Re ĩhâimana u'âsi mono zadawa para, wa'uburé, dama 're ĩ'anhamra mono na, wa te aiwaihu'u za'ra da. — Ãne te wada'uri za'ra. ");
INSERT INTO xavNT_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","19","Taha wa, ma tô sina waihu'u za'ra, te te ãma ĩrosa'rata wasété za'ra na, Zezusi hã. Taha wa, te tãma ãma romnhimiré'é za'ra, ãne: — Danhib'apito nhib'a'uwẽ norĩ hã 'râwim nherẽ, oto sisada 're simasa mono wamhã, te aré 're si'uprosi. Duré, dasisãnawã nherẽ, dasisada 're dasimasa mono wamhã, te aré 're dasi'uprosi. Tane duré, Satanasihi nhib'a'uwẽ norĩ hã sisada 're simasa mono wamhã, e niha te za sina 're sapa'a za'ra. Waihu'u õ di, ta norĩ hâimanazé hã. Ma tô ĩ̱ma ĩnharĩ za'ra wa'wa, Bezebuhu zadawa para, wa'uburé te dama 're ĩ'anhamra mono na. Asiré norĩ hã bété. E 'wa sadawa para, te bété wa'uburé norĩ hã te te dama 're sãmra, ta norĩ hã. E Bezebuhu zadawa para. Mare di. Ãne, wasu'u za'ra wa'aba õ di. Taha wa, ma tô ĩ̱wasu'u za'ra wa'wa, ĩ'upa na, Bezebuhu zadawa para, wa'uburé, te dama 're ĩ'anhamra mono na. ");
INSERT INTO xavNT_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Tô sena, wa 'Re ĩhâimana u'âsi mono zadawa para si, te dama 're anhamra, wa'uburé hã. Taha zarina si, te za oto ĩwaihu'u za'ra wa'wa, tô sena 'Re ĩhâimana u'âsi mono, ai'ãma 're ĩsib'a'uwẽ za'ra wa'aba mono zéb da, te te ãma ĩsãna'rata na hã. — Ãne ma tô tãma waihu'u za'ra, Zezusi hã. ");
INSERT INTO xavNT_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Te duré tãma ãma romnhimiré'é za'ra, ãne: — Ãté, aibâ ĩsiptede hã te za 're 'manhamra. Tawamhã si'wa'rutu ré, te za tinhorõwa te te dawi 're 'madâ'â pese. Taha wa, te za rowẽ na sa 're romnhimi'wara, ĩsibro hã, da te upi ãna. ");
INSERT INTO xavNT_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Ãté aibâ ĩsiptete u te za oto wi, ĩsipai u ĩsiptete uptabi hã. Tãma siptete wa, te za 'marõwĩ. Te za tiwi waibu ĩsi'wa'rudu hã, te te ĩ'umnhasizé hã. Uburé ĩsibrob zama te za tiwi waibu. Tawamhã te za oto dama ãma aipé. — Ãne te tãma ãma romnhimiré'é za'ra, Zezusi hã. ");
INSERT INTO xavNT_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Te duré tinha: — Ni'wam norĩ hã ĩ̱wẽ'wa 're nomro mono õ wamhã, ta norĩ hã te ĩ̱zada 're hâimana za'ra. Duré ni'wam norĩ hã te te 're ĩ̱pawaptob za'ra mono õ wamhã, ĩ̱tẽme te 're ĩda'ubumroi mono na hã ta norĩ hã ĩ̱nhiti dazatõrĩ'wa na te za 're hâimana za'ra. — Ãne ma tô tãma waihu'u za'ra, tiwẽ'õ'wa norĩ ma. ");
INSERT INTO xavNT_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Te duré tãma ãma romnhimiré'é za'ra, Zezusi hã, ãne: — Ãté wa'uburé hã te za aibâ hawi 'maiwatobro. Te za duré a'ubuni wi 're mo, â'õ wa'wai baba. Te za dazô 're rĩtĩ. Dazô 're rĩtĩ baba mono wa, nimomo wa'utu õ wa, te za sima tinha: “Ĩ̱nhorõwa 'rata u, wa za apâ mo, ãma 're ĩ̱nhorõwa u'âsi mono da, ĩpẽ'ẽ 'remhã.” Ãne te za sima tinha. ");
INSERT INTO xavNT_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Tawamhã te za apâ mo aibâ u, ĩpẽ'ẽ 're, apâ sébré da. Tawamhã ĩhawi watobro haré, te aré hâiba baba na 're hâimana, 'ri hã baba na 're simasa mono wa, 'ri 're wa'wa su'u na 're ĩsimasa mono ne, duré 'ri paramhã robza'ra wẽ u'âsi, 're ĩromnhimi'wara mono ne. Taha wa, wa'uburé ma, wẽ di, aibâ hã apâ ãma 're ĩsõrõwa mono da hã. ");
INSERT INTO xavNT_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Tawamhã te za rob u watobro, tisiré norĩ zô morĩ da, wa'uburé hã. Tawamhã te za ĩtẽme ãwisi za'ra, 7 na ĩhâiba hã ĩsipai u ĩwasété uptabi za'ra hã, si'u ãma 're sõrõwa za'ra mono da, aibâ ãma. Tãma rowẽ prã ti aré, wa'uburé misi, ãma 're sõrõwa mono ré hã, ĩpẽ'ẽ 'remhã. Ahâ na oto ãma 're sõrõwa za'ra mono wa, tãma rowẽ'õ uptabi di oto. — Ãne, Zezusi ma tô tãma rowasu'u za'ra. ");
INSERT INTO xavNT_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Taha wasu'u te te dama wasu'u pari, te pi'õ hã Zezusihi ma tinha, dawa'wa ĩsa hã: — Asépata'wai ma, 're rowẽ mono di za, aiprédu'wai ma. A hã ĩsimiprédu wa, tãma 're rowẽ mono di za. — Ãne te pi'õ hã Zezusihi ma tinha, mreme 'rãihâ na. ");
INSERT INTO xavNT_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Taha wa, te Zezusi hã asa tãma tinha: — Tane tô. Tãma 're rowẽ mono nherẽ, ĩsipai u ni'wam norĩ ma, 're rowẽ uptabi za'ra mono di za. Ni'wam norĩ hã, 'Re ĩhâimana u'âsi mono zadawa wasu'u hã tipo're na te te 're wapari za'ra mono wamhã, duré te te 're 'madâ'â pese za'ra mono wamhã, tãma 're rowẽ uptabi za'ra mono di za. — Ãne ma tô pi'õi ma waihu'u, Zezusi hã. ");
INSERT INTO xavNT_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","30","Tawamhã Zezusihi tẽme ma oto dasina tahâ'â ni. Taha wa, te dama tinha: — E niha ã nimosi dapoto té mono hã ĩ'aihâimana wasété za'ra wa'wa. Ma tô ĩ̱ma ĩ'ru za'ra wa'wa, marĩ dama ĩ'manharĩ waihu'u'õ hã te 'manharĩ da, asõ'a za'ra wa'aba, ĩ̱waihu'u pese na, 'Re ĩhâimana u'âsi mono te te ĩ̱wẽsãmri na, ĩ̱waihu'u za'ra wa'aba da. Taha wa, taré 'madâ'â za'ra wa'aba da, niha te 'manharĩ õ di za. 'Re ĩhâimana u'âsi mono hã, tiwaihu'u pese na niha Zonahã ma, te te ĩ'manharĩ wẽ ne, te za niwapsi 'manha, dama ĩ'manharĩ waihu'u'õ hã. Duréihã, Zonahã ma, te te 'manharĩ wẽ wamhã, ĩsadawa para datẽme ĩmorĩ na, ma tô waihu'u za'ra, Niniwé ãma 're ĩdasi'ubumroi mono norĩ hã. Tane, wa hã ti'ai ãma dasiré ĩ̱poto ma, te za niha ĩ̱ma 'manharĩ wẽ, ĩsadawa para atẽme ĩ̱morĩ aba na, ĩ̱waihu'u za'ra wa'aba da. ");
INSERT INTO xavNT_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Niwamhã 'Re ĩhâimana u'âsi mono, za da'ãma ĩsipo'ozéb ãma hã, duréihã danhib'apito sipi'õ hã Saba na romnhisi ãma te te 're ĩda'ab'madâ'â mono hã, te za duré asada tihâimana 'wa, aiwasédé hã te te ai'ãma sa'ra wa'aba da, 'Re ĩhâimana u'âsi mono nho'a. E marĩ wa. Ta hã duréihã romhâ uptabi nherẽ, ĩwi, apito Saromahã u, ĩsimiroti hã te te wapari da, ĩsimiroti hã dahâimanazém na rowaihu'u na hã wẽ uptabi wa. Taha nhimiroti hã pire nherẽ, ĩsipai u ĩ̱nhimiroti si pire uptabi di. Tane nherẽ, ĩ̱nhimiroti hã aima wapari ze za'ra wa'aba õ di. Taha wa, te za tô ĩ'uwaibaba aiwasédé hã ai'ãma sa'ra wa'wa, danhib'apito sipi'õ hã. ");
INSERT INTO xavNT_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Niwamhã 'Re ĩhâimana u'âsi mono, za da'ãma ĩsipo'ozéb ãma hã, duréihã Niniwé na 'ri nho'õmo nhisi ãma 're ĩdasi'ubumroi mono norĩ hã te za asada tihâimana za'ra wa'wa, aiwasédé hã te te ai'ãma sa'ra wa'aba da, 'Re ĩhâimana u'âsi mono nho'a. E marĩ wa. Duréihã Zona hã 'Re ĩhâimana u'âsi mono te te tãma 're sadawa wasu'u za'ra mono wamhã, ma tô te te 're wapari za'ra. Taha wa, ma tô ta norĩ hã tiwasété wi 're sipizari za'ra. Zonahã nhimiroti hã pire nherẽ, ĩsipai u ĩ̱nhimiroti si pire uptabi di. Tane nherẽ, a norĩ wa'wa hã ĩ̱zaze za'ra wa'aba õ di, 'Re ĩhâimana u'âsi mono nhimipisutuzéb zarina, we atẽme ĩ̱morĩ aba na hã. Taha wa, te za tô ĩ'uwaibaba aiwasédé hã ai'ãma sa'ra wa'wa, Niniwé ãma 're ĩdasi'ubumroi mono norĩ hã. — Ãne te dama tinha, Zezusi hã. ");
INSERT INTO xavNT_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Taha wa, te duré tãma ãma romnhimiré'é za'ra, ãne: — Rob'uiwẽzé hã da te ro'o wamhã, e te za nima niwĩ dawi simi'uri ni. E piza'a na, te za upsibi ni. Mare di. Ĩsima'warazém na si te za sõ'awi da te 're sõré, rowa'a na 're danhisisi mono da. Taha da, te za ro'o ni, rob'uiwẽzé hã. ");
INSERT INTO xavNT_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Tane duré dato hã, aiwa rob'uiwẽzé me. Datõmo wẽ wamhã, dama rob'madâ'â wẽ di. Datob'a wamhã, dama rob'madâ'â waihu'u õ di. Tane duré, a norĩ wa'wa hã asimirosa'rata wẽ za'ra wa'aba wamhã, te za ĩwẽ hã asimirosa'rata na 're ĩwaihu'u za'ra wa'aba mo. Duré, asimirosa'rata wasété za'ra wa'aba wamhã, ĩwẽ hã 're waihu'u za'ra wa'aba mono õ di za. ");
INSERT INTO xavNT_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Taha wa, 'râwi te za asimirosa'rata na 're asi'madâ'â za'ra wa'aba mo. ");
INSERT INTO xavNT_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Wa za duré aima ãma romnhimiré'é za'ra wa'wa, ãne: Rob'uiwẽzé hã te te aima 're rob'uiwẽ za'ra wa'aba mono wamhã, uburé aihâiba ma hã 're rowa'a za'ra wa'aba mono di za. Aiwi 're robra za'ra wa'aba mono õ di za. Tane, asimirosa'rata wẽ za'ra wa'aba wamhã, te za aiwasédé hã 're ĩwẽ'õ za'ra wa'aba mo, ĩwẽ si 're waihu'u za'ra wa'aba mono da. — Ãne ma tô dama waihu'u, Zezusi hã. ");
INSERT INTO xavNT_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Tawamhã tame te te dama rowasu'u pari, ma tô aibâ hã tãma tinha, ĩsõrõwa u morĩ da, ĩsiré sa da. Aibâ hã, parisezu. Taha wa, ma tô Zezusi hã ãma saze. Tawamhã 'ri para u sébré wamhã, te nhamra, sa da. ");
INSERT INTO xavNT_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Tane nherẽ, sai õ ré, simisõi õ di Zezusi hã, dahi'rada hã 're ĩsimisõ za'ra mono zéb zarina hã. Taha wa, te parisezu hã tãma tinha, tipẽ'ẽ na, simisõi õ wa. ");
INSERT INTO xavNT_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Tawamhã ma tô Wanhib'apito hã tãma tinha, Zezusi hã: — Parisezu norĩ, wa za aima ãma romnhimiré'é za'ra wa'wa, ãne: Hâsizé hã duré pratu hã ĩmana wawip si, da te 're upsõ za'ra mono wamhã, ĩwa'wamhã wasété di, zahadu upto wa. Tane, a norĩ wa'wa hã 're anomro wẽ wa'aba mono newa, da te 're ai'madâ'â wẽ za'ra wa'aba mono da, te 'Re ĩhâimana u'âsi mono nhimiroti ĩpire prã norĩ si 're ĩ'madâ'â pese za'ra wa'aba mo, danho'a. Tane nherẽ, aipẽ'ẽ 'remhã asimirosa'rata wasété na te zahadu ĩré 're aihâimana u'âsi za'ra wa'aba mo. Danhibrob na si te duré 're ĩda'ruiwapari za'ra wa'aba mo. Aihâimana nhipese zarina, te duré marĩ na dawi 're asipsaihuri za'ra wa'aba mo. ");
INSERT INTO xavNT_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","E niha waihu'u za'ra wa'aba õ di bété. Uburé Dapoto'wa hã e wahâiba na si, ma tô te te 're wa'awaihu'u. Mare di. Wanhimirosa'rata na zama, ma tô te te 're wa'awaihu'u, 'Re ĩhâimana u'âsi mono hã. ");
INSERT INTO xavNT_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Taha wa, ma'ãpé ĩsibrob'õ norĩ ma, 're asõprub za'ra wa'aba mono. Ãne dama 're 'manharĩ za'ra wa'aba mono wamhã, asimirosa'rata wẽ na, te za te te 're ai'awaihu'u 'wa, 'Re ĩhâimana u'âsi mono hã. ");
INSERT INTO xavNT_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","— Parisezu norĩ, a norĩ wa'aba ma, aima 're ropipa uptabi za'ra wa'aba mono di za. Ma tô asimiromhuri wa'â hã 'Re ĩhâimana u'âsi mono ma, 're ĩpo'o u'âsi za'ra wa'aba mo, wesuirã zapore wa'â hã, syry na tãma 're sõmri za'ra wa'aba mono da. Uburé danhipi wazarizé wa'â hã tãma 're po'o nhimini za'ra wa'aba mono õ di. Ta hã, wẽ di. Tazahã, ĩsimarĩ'õ norĩ ma, 're asõprub za'ra wa'aba mono õ di. Duré 'Re ĩhâimana u'âsi mono, 're sawi pese za'ra wa'aba mono õ di. Ma tô tãma 're asõprub za'ra wa'aba mo. Ĩbâre aré ĩsimarĩ'õ norĩ ma, 're asõprub za'ra wa'aba mono 'wa'âhã. Tazahã, ma tô 're ĩ'mararé za'ra wa'aba mo. Taha wa, niwapsi aima 're robze za'ra wa'aba mono õ di za. ");
INSERT INTO xavNT_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","— Parisezu norĩ, ai'ãma ĩ̱pẽ'ẽzé za'ra wa'aba di. Aima 're ropipa uptabi za'ra wa'aba mono di za. Dama ĩpire norĩ simasisizém na, 're asimro zei wa'aba mono di, rowahutuzéb ãma. Duré 'ri nhi'riti wa, da te dasina 're ĩ'ubumroi mono zéb ãma asisi pire na, da te 're asawi za'ra wa'aba mono wamhã, asina 're dawapari ze za'ra wa'aba mono di. Taha wa, niwapsi aima 're robze za'ra wa'aba mono õ di za. ");
INSERT INTO xavNT_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","— A norĩ wa'aba ma, aima 're ropipa uptabi za'ra wa'aba mono di za. Taha wa, wa za aima ãma romnhimiré'é za'ra wa'wa, ãne. Ãté ni'wa hã adâ'â 'ru uwaibaba te za mo, sa'rese ãna, ti'ai haré newa. Taha wa, te za siwasété. Tane aiwẽ za'ra wa'aba newa, asirã za'ra wa'aba zarina 're danomro mono wamhã, te za 're dasiwasété za'ra. Taha wa, aiwẽ prã za'ra wa'aba wa, aima 're robze za'ra wa'aba mono õ di za. — Ãne Zezusi te tãma nharĩ za'ra, parisezu norĩ ma. ");
INSERT INTO xavNT_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Tawamhã aibâ hã te Zezusihi ma tinha: — Rowahutu'wa, parisezu norĩ, wẽ'õ za'ra wa, ma tô ta norĩ zu, wa norĩ zama ĩwa'awẽ'õ. — Ãne te Zezusihi ma tinha, 'Re ĩhâimana u'âsi mono nhimiroti na dama rowahutu'wa hã. ");
INSERT INTO xavNT_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Tawamhã Zezusi te asa tãma tinha: — Rowahutu'wa norĩ, ai'ãma ĩ̱pẽ'ẽzé za'ra wa'aba di. A norĩ wa'aba ma zama, aima 're ropipa uptabi za'ra wa'aba mono di za. Wa za aima ãma romnhimiré'é za'ra wa'wa, ãne: Ãté marĩ ĩpire uptabi hã te za ni'wa hã dama sibu, te te sõihi waptob ãna. Tane a norĩ wa'wa hã. Dama asimiroti za'ra wa'aba zé hã ahâ uptabi na ma tô dama 're ĩpisutu za'ra wa'aba mo, da te 're 'madâ'â za'ra mono da, 're dapawaptob za'ra wa'aba mono ãna. Taha wa, te robzei'õ na oto 're danomro. Taha wa, aima 're robze za'ra wa'aba mono di za. ");
INSERT INTO xavNT_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","49","— A norĩ wa'aba ma, aima 're ropipa uptabi za'ra wa'aba mono di za. Aihi'rata aba norĩ hã ma tô 'Re ĩhâimana u'âsi mono zadawa wasu'u 'rata 'wa norĩ hã te te 're simro, ĩsadawa wasu'u na te te 're wẽ'õ za'ra mono wa. A norĩ wa'wa hã ĩsadawa wasu'u na, 're wẽ za'ra wa'aba mono newa, ma tô ẽtẽ tõmo wawẽ hã 're ĩsõré za'ra wa'aba mo, ab're 'wawi, dama ĩpibu pese zéb da, ĩ'ru hã. Tazahã, aihi'rata aba ne, ma tô ĩsadawa wasu'u hã 're ĩwẽ'õ za'ra wa'aba mo. E marĩ, te bété wasu'u, ab're 'wawi ẽtẽ tõmo wawẽ, 're ĩsõré za'ra wa'aba mono hã. Aihi'rata 'wa, ĩsadawa wasu'u 'rata 'wa norĩ te te 're ĩsimroi mono zé, ma tô 're ĩsaze za'ra wa'aba mo. Ãne te wasu'u, ab're 'wawi ẽtẽ tõmo wawẽ, 're ĩsõré wa'aba mono hã. Aiwana wa'aba, ma tô romhâ ré dapo're pu'u, 'Re ĩhâimana u'âsi mono hã. Datẽme, wa za te 're da'azatõrĩ, da te dama 're ĩ̱zadawa wasu'u za'ra mono da. Tazahã, ĩ̱zadawa para õ nherẽ, te za da te 're simro, ni'wam norĩ hã. Rowasédé hã te za duré da te tãma 're 'manharĩ za'ra, ni'wam norĩ ma. Ãne, tãma waihu'u pese sirõmo wa, ma tô romhâ ré dapo're pu'u, 'Re ĩhâimana u'âsi mono hã. ");
INSERT INTO xavNT_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","51","Ropoto na'rata hawi, ma tô ãma dasiwi sãna'rata ni, ĩsadawa wasu'u 'rata 'wai pãrĩ na hã. Ĩmorĩ'rada hã ma tô Abé hã wĩrĩ 'rata ni. Abéhé za'u si, ma tô ĩsadawa wasu'u'wa sidâpâsi, da te 're simro. Zacariaha zama, ma duré wĩrĩ ni, 'ri nho're ãma. 'Re ĩhâimana u'âsi mono ãma 're ĩdawata za'ra mono zém nho're ãma, ma wĩrĩ ni. Ĩbabarã na te 'ri hã za, 'ri ĩwẽ hã. Õ niwĩmhã, tãma danhoprubzé nomrizé te za, wedeza ne hã. Tame sab ré, ma wĩrĩ ni, Zacaria hã. Taha wa, te za 'ruiwa'âbâ za'ra, uburé tizadawa wasu'u'wa norĩ hã, da te 're ĩsimroi mono norĩ hã. Taha wa, ã nimosi dapoto té mono hã ĩ'aihâimana za'ra wa'wa hã, te za aima rob'manharĩ za'ra wa'wa, ĩsadawa wasu'u'wa norĩ, ĩsimirowasu'u na 're wẽ'õ za'ra wa'aba mono 'ru te. ");
INSERT INTO xavNT_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","— Rowahutu'wa norĩ, a norĩ wa'aba ma, aima 're ropipa uptabi za'ra wa'aba mono di za. E marĩ wa. Wa za ãma romnhimiré'é, ãne: Ãté, aibâ hã te za 'manhamra, 'ridawa tétézéb ré. Ta hã 're zasi mono õ di, 'ri para u hã. Duré, 'ri para u 're danhisisi mono õ di, te te dawi 're azawi mono wa, 'ridawa tétézé hã. Tane, a norĩ wa'wa hã 're 'madâ'â pese za'ra wa'aba mono õ di, 'Re ĩhâimana u'âsi mono nhimiroti hã. Ma tô duré dawi 're ĩsawi za'ra wa'aba mo, ĩsimiroti mono bâ, da te 're waihu'u za'ra mono tõ da. — Ãne ma tô Zezusi hã tãma rowasu'u za'ra, rowahutu'wa norĩ ma. ");
INSERT INTO xavNT_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","54","Tawamhã rob u, ma tô watobro, Zezusi hã. Watobro wamhã, te rowahutu'wa norĩ hã tãma nharĩ za'ra, parisezu norĩ me. Te te sadawa 'ru za'ra wa, te duré sadanharĩ na sima tirẽ, timreme na te te ãma upa zô, te te ãma upai wa, te te siwi wẽ'õ za'ra da. Tazahã, timreme na te te ãma upai õ di, Zezusi hã. ");
INSERT INTO xavNT_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","3","Tawamhã ma tô dasina tahâ'â ni. Da'ahâ uptabi di oto. Da'ahâ uptabi wa, ma tô 're dasipara wati'i za'ra. Ãhã wa, te Zezusi hã a'â tãma nharĩ za'ra, tisiré 're ĩnomro mono norĩ ma, ãne: — Parisezu norĩ hâimanazé hã, tô senai õ di. Taha wa, te za tiwi 're asi'madâ'â pese za'ra wa'aba mo, ĩ'u'ẽtẽ wapuzém nhiti 're anomro aba mono da, parisezu norĩ nhimi'manharĩzém nhiti. Wa za ãma simiré'é, ãne: Ãté te za marĩ hã da te dawi 're sahâri za'ra, da te 're waihu'u tõ za'ra mono da, danhimirowasu'uzé hã, danhimi'manharĩzé hã. Tane nherẽ, te za niwapsi waihu'u za'ra ni. Tane barana, aihâiba pisutu dama asimirowasu'uzé hã te za rowa'a ré dama asimirowasu'uzém na aiwasu'u za'ra wa'aba ni. Duré 'ri nhitob ré, aihâiba pisutu dama asimirowasu'uzé hã, te za sõ'awi dama asimirowasu'uzém na aiwasu'u za'ra wa'aba ni. Taha wa, te za 'râwi 're asi'madâ'â za'ra wa'aba mo, parisezu norĩ hâimanazéb zarina, 're aihâimana za'ra wa'aba mono tõ da, tô senai õ wa, 're ĩhâimana za'ra mono zé hã, ta norĩ hã. ");
INSERT INTO xavNT_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","5","— Ĩ̱siwadi norĩ, tô sena wa za aima rowasu'u za'ra wa'wa. Da te 're ai'uprosi aba mono da nherẽ, asima 're dapipa za'ra wa'aba mono õ di za. Da te 're ai'uprosi aba mono pari, niha oto da te aima 're rob'manharĩ za'ra wa'aba mono õ di za oto. Aipãrĩ'wa norĩ hã ropipa u, te te 're asãmra waihu'u aba mono õ di za oto. 'Re ĩhâimana u'âsi mono ma si, waihu'u pese di, ropipa u dawabzurizé hã. Taha wa, taha si te za tô 're ĩpipa za'ra wa'aba mo. ");
INSERT INTO xavNT_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","7","— Wa za aima ãma romnhimiré'é za'ra wa'wa. Sire wa'â hã wa'âbâ syryre nherẽ, ãma po're si'âri waihu'u õ di, 'Re ĩhâimana u'âsi mono hã. Tane duré, aséré za'rata aba zama, tãma waihu'u pese di. Sire hã tãma sawi pese za'ra nherẽ, sire zawi nhipai u, tãma asawi uptabi za'ra wa'aba di, 'Re ĩhâimana u'âsi mono ma hã. Taha wa, te za asina aihâtâ'â ãna 're anomro aba mo. — Ãne ma tô tãma waihu'u za'ra Zezusi hã, tisiré 're ĩnomro mono norĩ ma. ");
INSERT INTO xavNT_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","Te duré tãma nharĩ za'ra: — Ni'wam norĩ hã ĩ̱zazei'wa na danho'a dama 're siwasu'u za'ra mono wamhã, wa hã ti'ai ãma dasiré ĩ̱podo hã wa za duré ĩ̱zazei'wa na te 're awasu'u, hâiwa ãma 'Re ĩhâimana u'âsi mono ma romhuri'wa norĩ nho'a. ");
INSERT INTO xavNT_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Tanei õ di za, ni'wam norĩ hã ĩ̱zazei'õ'wa na dama 're siwasu'u za'ra mono wamhã. Ãne wamhã, ĩ̱zazei'õ'wa na wa za duré te 're awasu'u, hâiwa ãma 'Re ĩhâimana u'âsi mono ma romhuri'wa norĩ nho'a. ");
INSERT INTO xavNT_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","— Ãté ni'wam norĩ hã dasiré ĩ̱poto ma, te za ĩ̱ma nharĩ wasété za'ra. Tane nherẽ, tiwasété na 'Re ĩhâimana u'âsi mono ma, siwasu'u za'ra wamhã, te te ãma 'madâ'â za'ra õ di za oto, ĩwasédé hã. Tazahã, ni'wam norĩ hã, Ĩpẽ'ẽzani hã te te 're wẽ'õ u'âsi za'ra mono wamhã, te za te te ãma 're 'madâ'â u'âsi za'ra ĩwasédé hã, 'Re ĩhâimana u'âsi mono hã. ");
INSERT INTO xavNT_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","— Ãté ĩ̱zazei'wai wa, te za taré da te 're aiwẽ'õ za'ra wa'wa. Taha wa, ãté te za rowahutuzéb u, da te 're asimroi wa'wa, ĩ̱zazei'wa na, da te 're aiwaihu'u za'ra wa'aba mono da. Ãté roti'wa norĩ u, te za da te 're asimroi wa'wa, ãté danhib'apito norĩ u. Tane nherẽ, asina 're aihâtâ'â za'ra wa'aba mono õ di za. Tãma asiwasu'u za'ra wa'aba zéb zô, 're rosa'rata za'ra wa'aba mono õ di za. ");
INSERT INTO xavNT_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Nimahã bâtâ na, da te aiwaihu'u za'ra wa'aba wamhã, te za 'Re ĩhâimana u'âsi mono hã Tipẽ'ẽzani na aima waihu'u za'ra wa'wa, dama 're asiwasu'u za'ra wa'aba mono zéb da hã. Taha wa, asina 're aihâtâ'â za'ra wa'aba mono õ di za. — Ãne ma tô tãma waihu'u za'ra, Zezusi hã. ");
INSERT INTO xavNT_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Tawamhã aibâ hã dawa'wa ĩsa hã te Zezusihi ma tinha, ãne: — Rowahutu'wa, ĩ̱dub'rada hã ma'ãpé ĩ̱'ãma wada'uri, te te ĩ̱ma po'o da, wamama hã wawi dâ'â õ ré, te te wama ĩpisudu hã. — Ãne te tãma tinha. ");
INSERT INTO xavNT_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Taha wa, te Zezusi hã asa tãma tinha: — Mare di. E 'wa hã ma tô ĩ̱pisutu, te ai'ãma wada'uri da, te te aima po'o da hã. Ni'wa te te ĩ̱pisutu õ di. — Ãne te aibâ ma tinha. ");
INSERT INTO xavNT_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Tawamhã te uburé dama tinha: — Ma'ãpé, ĩ̱wapari pese za'ra wa'aba. 'Râwi te za 're asi'madâ'â za'ra wa'aba mo, asimarĩ ahâ zô, 're rob'ruiwapari za'ra wa'aba mono tõ da. Danhimarĩ ahâ uptabi nherẽ, robze u'âsi, ãma 're danomro mono õ di za. Rowẽzéb õ di, ta hã. — Ãne ma tô Zezusi hã tãma waihu'u za'ra. ");
INSERT INTO xavNT_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","17","Te duré ãma romnhimiré'é, ãne: — Aibâ hã te 're hâimana, ĩsimarĩ ahâ hã. Buru nho ahâ wamhã, 'râwi te sima rosa'rata, ãne: “'Ri hã 'ri 're sy'yre di, buru nho za'warizéb da hã. E marĩ wa za 'manha. ");
INSERT INTO xavNT_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Ãté ri wa za sãmra, te 'ri za'ẽtẽ da, buru nho za'warizéb da hã. Tamomo, wa za ubumro buru nho hã, 'ri za'ẽtẽ u. Ĩ̱nhimarĩ zama, wa za sa'ra, buru nho zu hã. ");
INSERT INTO xavNT_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Taha parip si, wa za ĩ̱sima tinha, ãne: ‘Ãhãna ĩ̱ma rowẽ di. Marĩ hã ahâ na, te ĩ̱za daba'wara, ĩwẽ hã. Ĩ̱wi ĩropsi'utõrĩ da hã, mare di. Wahub ahâ na, te za ĩ̱'ãma tiwahu, ĩ̱sa hã ĩ̱ma 're hâimana mono ré hã. Wa za oto 're ĩ̱wa'utu u'âsi. Ãté, te 're romhuri mono õ di za oto. Ãté ãhãna si, wa za oto 're ĩ̱sa. Wa za te 're zâsi u'âsi. Marĩ na, wa za 're ĩ̱to, ĩ̱tozém na.’ ” Ãne te aibâ hã sima rosa'rata. ");
INSERT INTO xavNT_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Taha wa, te 'Re ĩhâimana u'âsi mono hã tãma tinha: “A hã ma tô ãma ĩ'upa za'ẽ, asimirosa'rata na. Ã barana te za atâ. Atâ'â wamhã, e 'wa te hã za oto asimarĩ hã, asima si 're ĩ'a'ubumroi pese mono hã.” Ãne te aibâ ma tinha. ");
INSERT INTO xavNT_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","— Tane, danhimarĩ hã dasima si, da te 're ubumroi pese za'ra mono wamhã, 'Re ĩhâimana u'âsi mono ma, 're danhoprub za'ra mono ãna, te za taré da te dasima 're ubumroi pese za'ra, danhimarĩ hã. — Ãne ma tô Zezusi hã tãma waihu'u za'ra. ");
INSERT INTO xavNT_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Tawamhã Zezusi te tinha, tisiré 're ĩnomro mono norĩ ma, ãne: — Taha wa, wa za duré ãne aima waihu'u za'ra wa'wa. Marĩ na 're aihâtâ'â za'ra wa'aba mono õ di za. Asazé wa'aba na asina 're aihâtâ'â za'ra wa'aba mono õ di za. Duré, ai'uza õ na zama asina 're aihâtâ'â za'ra wa'aba mono õ di za. ");
INSERT INTO xavNT_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Wasazém nhipai u pire uptabi di, wahâimanazé hã. Duré, wa'uzazém nhipai u pire uptabi di, wahâiba hã. ");
INSERT INTO xavNT_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Õhõta, si norĩ hã. Ma'ãpé, 'madâ'â za'ra wa'aba. Si norĩ hã te te sima 're robzuri mono õ di. Te te duré sima 're rob'rãihâri za'ra mono õ di. Duré robza'warizéb õ di, ĩsazéb za'warizéb da hã. Tane nherẽ, te ĩsa hã te te tãma 're anhomri u'âsi, 'Re ĩhâimana u'âsi mono hã. E si norĩ si, te te 're azawi pese. Mare di. Si hã tãma sawi pese za'ra nherẽ, si zawi nhipai u, tãma asawi uptabi za'ra wa'aba di. ");
INSERT INTO xavNT_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","26","Duré 're atâ'â za'ra wa'aba mono zém na, asina 're aihâtâ'â za'ra wa'aba mono wamhã, e asibâtâ na 're atâ'â za'ra wa'aba mono õ di za. E asibâtâ nhipai u, te za 're anomro siroptu wa'aba mo. Mare di. Asina 're aihâtâ'â za'ra wa'aba mono zéb zarina, asibâtâ nhipai u 're anomro siroptu wa'aba mono õ di za. E marĩ da, te za bété marĩ na 're aihâtâ'â za'ra wa'aba mo. ");
INSERT INTO xavNT_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Ma'ãpé, romnhirãrã 're ĩhâimana za'ra mono zém na rosa'rata za'ra wa'aba a'â, rom na 're ĩsimasa mono na hã. Ta norĩ hã ti'uzazéb da hã, te te sisada 're 'manharĩ za'ra mono da, te te 're romhuri za'ra mono õ di, zazahâ da hã. Tane nherẽ, dama 'madâ'â zei uptabi di, romnhirãrã hã. Apito Saroma hã uza wẽ uptabi na 're si'uza mono nherẽ, taha nhipai u, dama 'madâ'â zei uptabi di, romnhirãrã hã. ");
INSERT INTO xavNT_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Romnhirãrã hã hâiwi 're simnhatã mono ré, te za du hã ĩré da te 're wazâri za'ra, unhama da, da te 're ub'rã za'ra mono da. Taha wa, 're simasam hâ mono dai õ nherẽ, ma tô wẽ uptabi na te te 're ab'manharĩ, 'Re ĩhâimana u'âsi mono hã. E tawamhã, ai'uzazé hã te te aima 're sõmri za'ra wa'aba mono õ di za bété. Te za tô te te aima 're anhomri 'wa. E niha Aimama 'wa hã asina 're umnhasi za'ra wa'aba mono õ di bété, taha si ai'uzazé hã za te te aima 're ĩ'anhomri aba mono na hã. ");
INSERT INTO xavNT_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","31","Taha wa, marĩ na asina 're aihâtâ'â za'ra wa'aba mono õ di za. Asazéb zô si, duré â zô si, 're asõpré wa'aba mono õ di za. Taha zô si, te za ĩsazei'õ'wa norĩ hã 're sõpré. Aimama 'wa hã ma tô aiwaihu'u za'ra wa'wa, marĩ hã aiwi sô 're ĩrowaptâ'â za'ra wa'aba mono na. Aimama 'wa hã, 'Re ĩhâimana u'âsi mono, Danhib'apito uptabi. Taha wa, õhõ si, te za 're ĩpisutu za'ra wa'aba mo, õhõ ãma si 're anomro aba mono da. Tawamhã marĩ hã aiwi sô 're ĩrowaptâ'â za'ra wa'aba mono zéb uwaibaba, te za te te aima 're anhomri 'wa, Aimama 'wa hã. — Ãne, ma tô Zezusi hã tãma waihu'u za'ra, tisiré 're ĩnomro mono norĩ ma. ");
INSERT INTO xavNT_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Te duré tãma nharĩ za'ra: — Ĩ̱siré norĩ, ai'umrore wa'aba nherẽ, asina 're aihâtâ'â za'ra wa'aba mono õ di za. Aimama 'wa hã Danhib'apito uptabi hã, te za aima pisutu za'ra wa'wa, ĩsiré dama 're roti za'ra wa'aba mono da. Ãne ma tô sima aiwẽ za'ra wa'wa. ");
INSERT INTO xavNT_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","34","Taha wa, te za uburé asimarĩ hã dama ĩwede za'ra wa'wa, ĩwa'âbâ zô, ĩsimarĩ'õ norĩ ma, sõmri aba mono da. Tawamhã asimarĩ hã ĩsi'utõrĩ'õ hã te za hâiwa ãma asô 're hâimana u'âsi za'ra wa'wa, wẽ u'âsi na. Tame, ĩsipsaihuri norĩ hã sô 're sisisi waihu'u mono õ di za. Tame duré, da'uza hâzapu'u'wa hã 're hâimana za'ra mono õ di. Ti'ai ãma asimarĩ ahâ zô si 're rob'ruiwapari za'ra wa'aba mono wamhã, taha na si te za aipẽ'ẽ 're, asima 're ĩrosa'rata u'âsi za'ra wa'aba mo, hâiwa ãma ĩwẽ hã ĩsi'utõrĩ'õ upana. Duré hâiwa ãma ĩwẽ uptabi zô si, asima 're rob'ruiwapari za'ra wa'aba mono wamhã, taha na si te za asima 're ĩrosa'rata u'âsi za'ra wa'aba mo, 'Re ĩhâimana u'âsi mono hã ĩwẽ hã te te asô 're ĩ'apisutu aba mono zô si. — Ãne ma tô tãma waihu'u za'ra, Zezusi hã. ");
INSERT INTO xavNT_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","36","Tawamhã Zezusi hã te duré tãma romnhimiré'é za'ra, ãne: — Romhuri'wa norĩ hã hâimana nhimiza'rese sina, te za tinhib'apito zô 're simipari za'ra. Tane, te za aihâimana nhimiza'rese sina, 're aihâimana za'ra wa'aba mo. Ãté dasina damrozéb u, te za ĩsib'apito hã tiwi timorĩ za'ra, dame sa da. Tawamhã apâ wisi õ ré, te za si'uza za'ra, tãma ĩromhuri'wa norĩ hã, te te tãma romhuri za'ra da. Te za sô ro'o za'ra rob'uiwẽzé hã, rowa'a na sébré da, ĩsib'apito za'ra hã. Tawamhã 'ri tẽme wisi wi, te za ĩsib'apito za'ra hã 'ridawa ta'a, te te tãma 'ridawa za'ra da. Taha wa, te za awa'awi tãma 'ridawa za'ra. ");
INSERT INTO xavNT_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","38","Tãma ĩromhuri'wa norĩ hã sõtõ ãna, sô simipari za'ra wamhã, tãma rowẽ za'ra di za. Tawamhã ãté mara wa'wa, te za apâ wi, ĩsib'apito za'ra hã. Ãté si'a hârâ wi, te za apâ wi. Hâimana nhimiza'rese sina, sô 're simipari za'ra mono ré, apâ wisi wamhã, tãma rowẽ za'ra di za, tãma ĩromhuri'wa norĩ ma hã. Tawamhã apito nherẽ, sai õ ré, te za a'â ti'uza na ãma saprĩ, ĩsa te te tãma sõmri mono da, tãma ĩromhuri'wa norĩ ma. Te za duré tãma nharĩ za'ra, tisai ma, si'ubumro da. Taha pari, te za duré tãma sõmri za'ra, ĩsa hã. ");
INSERT INTO xavNT_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Wa za duré ãma simiré'é, ãma rosa'rata za'ra wa'aba da. Dahâimana nhimiza'rese ãna, 're dahâimana za'ra mono ré, te za ĩsipsaihuri norĩ hã danhibrob zô 're sisisi, 'ri para u hã. Bâdâ hã we ĩsébrézé hã 'ri tede'wa te te waihu'u wamhã, te za tiwi 'madâ'â pese, sébré tõ da, 'ri para u. ");
INSERT INTO xavNT_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Tane te za a norĩ wa'wa hã aihâimana nhimiza'rese ĩ̱zô 're asimipari u'âsi za'ra wa'aba mo. Wa hã ti'ai ãma dasiré ĩ̱podo hã, wa za wei mo apâ, ĩ̱zô asimipari za'ra wa'aba õ zém na, nimahã bâtâ na. Taha wa, te za aihâimana nhimiza'rese ĩ̱zô 're asimipari u'âsi za'ra wa'aba mo. — Ãne te Zezusi hã tãma roti za'ra, tisiré 're ĩnomro mono norĩ ma. ");
INSERT INTO xavNT_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Tawamhã Pedru te 'mahâ: — Apito, e 'wai udâna, te ãne ãma ĩsimiré. E uburé da'udâna zama, te ãma ĩsimiré. — Ãne te sadanha. ");
INSERT INTO xavNT_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Taha wa, te Wanhib'apito hã asa ãma romnhimiré'é, Zezusi hã ãne: — Dama romhuri'wa ĩ'umnha hã duré ĩsimiroti wẽ hã, e niha 're ĩhâimana mono zé hã. Ãne hã 're hâimana mono wamhã, te za ĩsib'apito hã nimomo tiwi morĩ õ ré, tãma pisutu, uburé tãma ĩromhuri'wa norĩ hã ĩsa'u nherẽ, te te sô 'madâ'â za'ra da. Te za duré tãma pisutu, bâtâ pisutuzém na ĩsazéb da hã, te te tãma ãma uwaimrami za'ra da, tãma ĩromhuri'wa norĩ ma. ");
INSERT INTO xavNT_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","44","Tawamhã apâ we ĩmorĩzéb u, tinhib'apito nhimiroti hã te te tãma ãma uwaimrami wamhã, tãma rowẽ di za, romhuri'wai ma hã. Taha ma, tãma rowẽ uptabi di za tô. E marĩ wa. Ĩsib'apito hã apâ wisi wapsi, te za tãma pisutu, uburé ĩsimarĩ hã te te tãma 're 'madâ'â u'âsi mono da oto, tãma umnhasi uptabi wa. ");
INSERT INTO xavNT_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Tazahã, tinhib'apito za're'ra, dama 're hâimana wẽ mono õ wamhã, tãma 're rowẽ mono õ di za. Ãté apito za're'ra, te za 'râwi sima tinha, ãne: “Ĩ̱nhib'apito hã simahudu õ di.” Ãté, ãne te za sima tinha. Taha wa, sô rowaptâ'â wẽ te, te za oto tizapari romhuri'wa norĩ hã te te 're ahâ za'ra ãté, aibâ norĩ hã pi'õ norĩ zama. Ãté, te za taré tisa zô si 're hâimana. Ãté te za âzé hã te te 're hâsi. Õne u'âsi, te te 're hâsi mono wa, te za 'rãi wasété na 're hâimana. ");
INSERT INTO xavNT_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Tawamhã rosa'rese ãna hâimana ré, te za ĩsib'apito hã ĩtẽme wi apâ, sô ĩsimipari õ zém na nimahã bâtâ na, siwa'ru. Taha wa, te za sa'ẽtẽ azâ, tãma ĩromhuri'wa hã. Sib'ézé 'wa pa na, te za te te wa'õtõ. Taha wa, te za dapo're'õ norĩ zu robzei'õ te te sina 're sõ'õtõ, tãma ĩromhuri'wa hã. ");
INSERT INTO xavNT_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","— Ãté, ni'wa hã te za waihu'u pese, tinhib'apito nhimiroti hã, tãma ĩromhuri'wa hã. Tane nherẽ, wa'a te, ĩsimiroti hã te te 're uwaimrami mono õ di za. Taha wa, te za sa'ẽtẽ azâri ni, powawẽ hâiwaré na, apito zadawa para. ");
INSERT INTO xavNT_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Ãté, ni'wai ma, waihu'u pese õ di za, ĩsib'apito nhimiroti hã. Tawamhã marĩ te za upa. Taha wa, te za syry na si azâri ni, tãma waihu'u pese õ wa, ĩsib'apito nhimiroti hã. Ãté te za ni'wai ma waihu'u pese, tinhimiroti hã, 'Re ĩhâimana u'âsi mono hã. Te te tãma waihu'u pese wamhã, te za sô 're simipari, danhipai u te te tãma ãma 're uwaimrami mono da, ĩsimiroti hã. — Ãne ma tô tãma waihu'u za'ra, Zezusi hã. ");
INSERT INTO xavNT_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Te duré tãma nharĩ za'ra: — Ti'ai u, wa wei mo, ti'a na te sazu da, zata da. Zata sirõmo 'wa'âhã, aré ĩ̱ma wẽ di. ");
INSERT INTO xavNT_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Wa za a'â robzépata za'ẽtẽ. Te robzépata õ ré hã, rosa'rata ahâ di za. ");
INSERT INTO xavNT_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","E datẽme we ĩ̱morĩ wa, te za ti'ab ré rowẽ na si dasiré 're dahâimana za'ra, simisutu. Mare di. Ãne hã ĩ̱'ãma 're rosa'rata za'ra wa'aba mono õ di za. Rosa'rata na te za ĩ̱'ãma dasima aipo'o za'ra ni. ");
INSERT INTO xavNT_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Ãté, 5 na ĩhâiba hã te 'ri ãma siré 're si'ubumro. Ta norĩ hã te za rosa'rata na ĩ̱'ãma sima aipo'o za'ra. Ãté, si'ubdatõ te za ĩ̱wẽ'wa, 're hâimana za'ra. Ãté maparane te za ĩ̱wẽ'õ'wa, 're hâimana zahuré. Ãté, maparane te za ĩ̱wẽ'wa hã 're hâimana zahuré. Ãté duré si'ubdatõ te za ĩ̱wẽ'õ'wa hã 're hâimana za'ra. ");
INSERT INTO xavNT_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Ãté, damama hã te za ti'ra norĩ hã wẽ'õ za'ra, ĩ̱zazei'wa 're hâimana za'ra mono wa, ĩ'ra si'aibâ hã. Ãté, da'ra norĩ hã te za timama hã siwi wẽ'õ za'ra, ĩ̱zazei'wa, 're hâimana mono wa, ĩmama hã. Ãté, dana hã te za ti'ra norĩ hã wẽ'õ za'ra, ĩ̱zazei'wa, 're hâimana za'ra mono wa, ĩ'ra sipi'õ hã. Ãté, pi'õ norĩ hã te za tina hã siwi wẽ'õ, ĩ̱zazei'wa, 're hâimana mono wa, ĩna hã. Ãté, damaprewa hã te za tisani'aba norĩ hã wẽ'õ za'ra, ĩ̱zazei'wa 're hâimana za'ra mono wa, ĩsani'aba norĩ hã. Ãté, pi'õ norĩ hã te za timaprebaba norĩ hã wẽ'õ za'ra, ĩ̱zazei'wa, 're hâimana za'ra mono wa, ĩmaprebaba norĩ hã. — Ãne ma tô tãma waihu'u za'ra Zezusi hã, tisiré 're ĩnomro mono norĩ ma. ");
INSERT INTO xavNT_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Uburé te oto dama tinha: — Ãté, te za hâiwa nhirõno ĩ'madâ'â za'ra wa'wa, bâtâ pusizém niwĩ. Taha wa, te za asima ĩrowasu'u za'ra wa'wa, ãne: “Tã, te za we tita'a.” Ãté, ãne te za asima ĩrowasu'u za'ra wa'wa, awa'awi. Tawamhã tã hã te za we tita'a tô. ");
INSERT INTO xavNT_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Ãté, rowa'u hã te za wei watobro, hâiwa'a're nhimi'e hawi. Taha wa, te za ãne asima ĩrowasu'u za'ra wa'wa, “Te za oto tirowa'ro.” Ãne te za asima ĩrowasu'u za'ra wa'wa. Tawamhã te za tô tirowa'ro. ");
INSERT INTO xavNT_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Marĩ hã ti'ai ãma hã, duré hâiwa na hã aima waihu'u pese za'ra wa'aba di, 'madâ'â za'ra wa'aba wamhã. E niha bété tane aiwa, aima waihu'u pese za'ra wa'aba õ di, marĩ te te ĩwasu'u hã, te dama 're ĩ'ab'manharĩ wẽ mono zé hã, ãma 're ĩ̱'madâ'â za'ra wa'aba mono nherẽ. — Ãne ma tô dama tinha, Zezusi hã. ");
INSERT INTO xavNT_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","58","Uburé ma, te duré dama tinha: — E marĩ wa, asina 're roti wẽ za'ra wa'aba mono õ di, ĩwẽ hã 're 'manharĩ za'ra wa'aba mono da. Wa za ãma simiré'é, ãne: Ãté, ni'wa hã te za asaprõ, dama 're ĩrowairébé mono 'wa, 're ĩsãmra mono zéb u. Marĩ 'manharĩ wa, te za asaprõ, te te tãma aiwasu'u da. Taha wa, te za bâdâdi na ane wa'aba ré, tãma asiwasu'u aiwasété na, rowairébé'wai u te te asaprõni tõ da, damrami'wai ma, te te ai'ru tõ da, dazazéb 're, te te asẽrẽ tõ da. ");
INSERT INTO xavNT_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Te te asẽrẽ wamhã, asiwa'âbâ 'rãsutu pese õ nherẽ, ta hawi aiwatobro waihu'u õ di za. Ãne, wa aima waihu'u za'ra wa'wa, asina 're roti wẽ za'ra wa'aba mono da, ĩwẽ hã 're 'manharĩ za'ra wa'aba mono da. — Ãne, ma tô tãma waihu'u za'ra, Zezusi hã. ");
INSERT INTO xavNT_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Tawamhã Zezusi te te dama rowasu'u ré, ma tô ni'wam norĩ hã ĩtẽme aihutu. Taha wa, te tãma rowasu'u za'ra, Zezusihi ma: — A'uwẽ norĩ hã ma tô simro ni, Darireza tede'wa norĩ hã. Piratuhu nhimiwada'uri zarina, ma tô simro ni. 'Re ĩhâimana u'âsi mono ma, tinhimizama te te simroi ré, ma tô uprosi ni. — Ãne te Zezusihi ma rowasu'u za'ra. ");
INSERT INTO xavNT_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Tawamhã Zezusi te asa tãma nharĩ za'ra: — E Darireza norĩ hã ma tô danhipai u tiwasédé hã te te 're 'manharĩ za'ra. E taha wa, ma tô tidâ'â za'ra. E ãne, ma tô ãma ĩrosa'rata za'ra wa'wa. ");
INSERT INTO xavNT_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Mare di. Taha wab õ di. Ta norĩ hã danhipai u, tiwasédé hã te te 're 'manharĩ za'ra mono õ di. Tane nherẽ, ma tô tidâ'â za'ra. Tane, te za tô a norĩ wa'wa hã ĩsine 're atâ'â za'ra wa'aba mo, aiwasété wi 're aipizari za'ra wa'aba mono õ wamhã. ");
INSERT INTO xavNT_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","A'uwẽ norĩ hã, Siro'é na 'ri sipo'o ãma 're ĩsi'ubumroi mono norĩ nhisiwi, ma tô 'ri 'rãihâ hã waptãrã, da'madâ'âzé hã. Taha wa, ma da'ahâ na ai'utõrĩ ni. 18 na ma 'ri hã da'uprosi. Ta norĩ hã bété, e ma tô danhipai u tiwasédé hã te te 're 'manharĩ za'ra, Zeruzarẽ ãma 're ĩdahâimana za'ra mono norĩ upana. E taha wa, ma tô tidâ'â za'ra. ");
INSERT INTO xavNT_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Mare di. Taha wab õ di. Ta norĩ hã danhipai u, tiwasédé hã te te 're 'manharĩ za'ra mono õ di. Tane nherẽ, ma tô tidâ'â za'ra. Tane, te za tô a norĩ wa'wa hã ĩsine 're atâ'â za'ra wa'aba mo, aiwasété wi 're aipizari za'ra wa'aba mono õ wamhã. — Ãne ma tô tãma waihu'u za'ra, Zezusi hã. ");
INSERT INTO xavNT_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Tawamhã te tãma ãma romnhimiré'é za'ra ãne, Zezusi hã: — Aibâ hã te 're 'maihâimana, buru tede'wa hã. Ĩburu ãma hã, rob'ru hã te 're hâimana za'ra, uwa 'ru hã. Pidera wede hã te duré tame 're sa. Tawamhã bâtâ na te mo, pidera 'rã zô. Tane nherẽ, ĩ'rã hã te te 'masãmri õ di. 'Rãi ãna te za. ");
INSERT INTO xavNT_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Taha wa, te buru 'madâ'â'wai ma tinha, ãne: “Si'ubdatõ, ma tô ĩ̱'ãma tiwahu oto, taré nasi we sô ĩ̱neb ré hã, pidera 'rã zô. Wa tô 'madâ'â wa'a. Te za ĩsizâ. E marĩ da, te za taré 're sab u'âsi, 're 'rãi mono ãna.” Ãne te romhuri'wai ma tinha. ");
INSERT INTO xavNT_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Tawamhã romhuri'wa hã te asa tãma tinha: “Apito, misi ãma wahu a'â. Wa hã wa za ab're, powawẽ nhana na te uirĩ da, wẽ na sab da. ");
INSERT INTO xavNT_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Wahub amo na 'rãi wamhã, wẽ di za. 'Rãi õ wapsi, te za ĩ̱ma ĩ'ru, te sizâri da.” Ãne, romhuri'wa te tinha, buru tede'wai ma. — Ãne ma tô tãma ãma romnhimiré'é za'ra, Zezusi hã. ");
INSERT INTO xavNT_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Tawamhã romhuri zahârizém na ma tô dama rowasu'u Zezusi hã, zudezu norĩ te, rowahutuzéb ãma. ");
INSERT INTO xavNT_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Tame te pi'õ hã ĩhâzé ré hã dame nhamra. Hâzé ré ma tô ãma tiwahub ahâ, 18 na, wa'uburé te te 're upi u'âsi mono wa. Sihâpâ u'âsi, te 're mo, wãi wahutu ãna. ");
INSERT INTO xavNT_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Tawamhã Zezusi te te sabui wamhã, te 'mahâ: — Pi'õ, aihâzé hã te za oto aima apa. ");
INSERT INTO xavNT_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Taha pari, ma tô tinhib'rada hã ãma tihi. Tawamhã ma tô awa'awi wãi wahudu. Wãi wahutu wamhã, te ãma tiwata, 'Re ĩhâimana u'âsi mono ãma, te te pese wẽ te. ");
INSERT INTO xavNT_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Tane nherẽ, rowahutuzé 'madâ'â'wa hã ma tô sada tizahi, Zezusihi zada, sabadu na te te pese wa. Taha wa, te uburé dama tinha: — Bâdâ hã, 6 na ĩhâiba hã, wa te 're ĩromhuri za'ra mono zéb da hã. Taha bâtâ na si, te za we 're anomro aba mo, da te 're aipese za'ra wa'aba mono da. Sabadu na hã mare di za, romhuri zahârizém na hã. — Ãne ma tô dama waihu'u, rowahutuzé 'madâ'â'wa hã. ");
INSERT INTO xavNT_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","16","Tawamhã Wanhib'apito te tãma tinha: — Oro sabadu na te dapese wa, ĩ̱ma nharĩ za, te za powawẽ hã awaru po'repore zama, 're ĩwasihu za'ra wa'aba mo, âi ba, 're simroi wa'aba mono da, te te 're âhuri mono da. Ãhãta pi'õ hã, Abra'ãhã nhihudu hã. Satanasi hã te te 're pibui mono ré hã, ma tô 18 na ãma tiwahu. Sabadu na nherẽ, wa tô pese, hâzé ãna oto 're hâimana mono da. E niha bâ bété, aima wẽ za'ra wa'aba õ di, sabadu na te ĩpesezé hã rowẽ na pi'õ hã oto 're ĩmorĩ da hã. — Ãne ma tô Zezusi hã tãma waihu'u, dawasété na dasisãmri ma ropibuma. ");
INSERT INTO xavNT_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Tawamhã, Zezusihi mreme hã te te wapari za'ra wamhã, ma tô ĩwẽ'õ'wa norĩ hã aséb za'ra, Zezusihi mreme ma. Ĩwẽ'wa norĩ ma, rowẽ za'ra di. Marĩ hã te te dama 're ab'manharĩ wẽ mono wa, te 're to za'ra, tipẽ'ẽ na. ");
INSERT INTO xavNT_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","19","Tawamhã Zezusi hã te dama tinha, ãne: — E niha, wa za ãma simiré'é, 'Re ĩhâimana u'âsi mono, da'ãma 're ĩsib'a'uwẽ mono zém na hã. Motada nhamare na, wa za ãma simiré'é. Motada nhamare hã aibâ hã ma tô a're. Tawamhã ma tô tiwa'ru. Wa'rui wamhã, papo za'ẽtẽ di oto. Tawamhã si hã te ĩsu 'rowi, te te sima 're sasi za'ra. Ãne, 'Re ĩhâimana u'âsi mono, da'ãma 're ĩsib'a'uwẽ mono zé hã. — Ãne ma tô ãma simiré'é, Zezusi hã. ");
INSERT INTO xavNT_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Te duré dama tinha: — E marĩ na, wa za duré ãma simiré'é, 'Re ĩhâimana u'âsi mono, da'ãma 're ĩsib'a'uwẽ mono zém na hã. ");
INSERT INTO xavNT_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Ĩ'u'ẽtẽ wapuzém na, wa za ãma simiré'é. Pi'õ hã te za ĩ'u'ẽtẽ wapuzé hã syry na sa'wa, tridu 'rã zu pese wazari. Tridu zup si, sa'ẽtẽ uptabi di. Tawamhã te te wazari pese wamhã, te za tidupto, ĩ'u'ẽne hã. Sa'ẽtẽ uptabi di za oto. Ãne duré, 'Re ĩhâimana u'âsi mono, da'ãma 're ĩsib'a'uwẽ mono zé hã. — Ãne ma tô ãma simiré'é, Zezusi hã. ");
INSERT INTO xavNT_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Tawamhã Zezusi norĩ hã te oto ai'aba'ré, Zeruzarẽ u. 'Ri nho'õmo mono bâ, te te dama 're rowasu'u u'âsi Zezusi hã, 'ri wa'õtõ u zama. ");
INSERT INTO xavNT_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Tawamhã te ni'wa hã sadanha: — Apito, e da'umro na si, te za danho'reptuzé hã da te dasina 're waihu'u za'ra. — Ãne te sadanha. Taha wa, ma tô Zezusi hã asa uburé dama tinha: ");
INSERT INTO xavNT_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","— Tô sena, te za niwapsi da'ahâ na da te dasima 're wẽ za'ra, 'Re ĩhâimana u'âsi mono u 're danhisisi mono da. Tazahã, ĩtẽme 're danhisisi mono õ di za. Taha wa, 'ri para u 'ridawa 're sy'yre na 're danhisisi mono da, sada 're ĩdanhiptete za'ra mono ne, te za sada 're asiptete za'ra wa'aba mo, 'Re ĩhâimana u'âsi mono u 're asisisi aba mono da. ");
INSERT INTO xavNT_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Nimahã na te za 'ri tede'wa hã wahudu, te te siré 'rinhitop tete da. Tawamhã te za ĩ'ridawa ta'a za'ra wa'wa, rowi 're ai'ubumroi wa'aba mono hã. 'Ri tede'wa hã te za ĩ'mahârâ za'ra wa'wa, ãne: “Apito, ma'ãpé we wazô 'ridawa za'ra na, ãma atẽme wanhisisi da.” Ãne te za 're ĩ'mahârâ za'ra wa'aba mo. Tazahã, te za asa aima nharĩ za'ra wa'wa, ãne: “Te aiwaihu'u za'ra wa'aba õ di. E ma hawimhã, a norĩ wa'wa hã.” ");
INSERT INTO xavNT_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Tawamhã ãne te za asa tãma asiwasu'u za'ra wa'wa: “Wa norĩ hã, wa tô asiré wasaihuri ni. Asiré, wa tô duré âhuri ni. Warob ãma hã ma tô duré dama 're ĩrowahutu mo, waza'ru ãma hã.” Ãne te za 'ri tede'wai ma asiwasu'u za'ra wa'wa. ");
INSERT INTO xavNT_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Taha wa, te za asa duré aima nharĩ za'ra wa'wa, ãne: “Te aiwaihu'u za'ra wa'aba õ di, ĩ̱zazei'wa na hã. Aiwasédé hã ma tô 're ĩ'manharĩ u'âsi za'ra wa'aba mo. Mo oto ai'aba'réi wa'aba, ĩ̱nhiti.” Ãne te za aima rob'ru za'ra wa'wa. ");
INSERT INTO xavNT_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Tawamhã rowẽ uptabi ãma, 'Re ĩhâimana u'âsi mono 'rata 're ĩsi'ubumroi mono hã te za ĩ'madâ'â za'ra wa'wa, Abra'ã norĩ hã, duré Izati, duré Zaco, duré uburé ĩsadawa wasu'u'wa norĩ hã. Tazahã, a norĩ wa'wa hã te za rowi 're ai'ubumroi u'âsi aba mo. Taha wa, te za asina 're ai'ry'ry aba mo. Te za duré 're ai'wasitete za'ra wa'aba mo, 're robzépata za'ẽtẽ za'ra wa'aba mono wa. ");
INSERT INTO xavNT_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Daro mono bâ, te za ĩtẽme 're dasihutu, 'Re ĩhâimana u'âsi mono 'rata 're dasaihuri mono da, Danhib'apito uptabi na 're ĩhâimana mono zéb u. Bâtâ pusizém hawi, te za ĩtẽme 're dasihutu, bâtâ zasizém hawib zama, duré hâiwa'a're nhimire hawib zama, duré hâiwa'a're nhimi'e hawib zama. ");
INSERT INTO xavNT_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Tawapsi, te za dama ĩwapu ma nharĩ za'ra, dama pire na 're hâimana za'ra mono da oto. Duré, dama ĩpire ma, te za nharĩ za'ra, dama wapu na 're hâimana za'ra mono da oto. — Ãne ma tô Zezusi hã tãma waihu'u sirõmo za'ra. ");
INSERT INTO xavNT_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Tawamhã Zezusi hã te te apo're pu'u parip si, awa'awi ma tô ĩtẽme 'maihaihutu, parisezu norĩ hã. Taha wa, ma tô Zezusihi ma rob'ru za'ra, ãne: — Mo oto ã hawi aimorĩ. E marĩ wa. Apito Erodi hã ma tô sima aiwẽ, da te dasiwi aiwĩrĩ da. — Ãne te tãma rob'ru za'ra. ");
INSERT INTO xavNT_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Tawamhã Zezusi hã apâ te tãma rob'ru za'ra: — Mo oto ĩtẽme ai'aba'réi wa'aba apâ, tãma ĩ̱zadawa wasu'u za'ra wa'aba da, wapsã wawẽ ne 're ĩmorĩ ma. Wa'uburé hã wa tô te dama 're anhamra. Wa duré te 're da'apese, ã bâtâ na duré awẽm na. Awẽ amo na, wa za ĩ̱nhimiromhuri hã uprosi. Ãne te za tãma ĩ̱zadawa wasu'u za'ra wa'wa, Erodihi ma. ");
INSERT INTO xavNT_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","— Zeruzarẽ ãma, ma tô da te 're simro, 'Re ĩhâimana u'âsi mono zadawa wasu'u 'rata 'wa norĩ hã. Õne u'âsi. Taha wa, wa za ãma mo, ãhãna, awẽb zama, awẽ amo na zama, tame, da te dasiwi ĩ̱wĩrĩ da, ĩsadawa wasu'u'wa hã. — Ãne ma tô Zezusi tãma siwasu'u za'ra, parisezu norĩ ma. ");
INSERT INTO xavNT_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Tawamhã ma tô sisõwa tinha, Zezusi hã: — Zeruzarẽ ãma 're ai'ubumroi wa'aba mono norĩ ãma, ai'ãma ĩ̱pẽ'ẽzé za'ra wa'aba di. Aihi'rata norĩ wa'wa hã ma tô 'Re ĩhâimana u'âsi mono zadawa wasu'u 'rata 'wa norĩ hã te te 're simroi u'âsi, ẽtẽ na. Datẽme te te 're ĩsatõrĩ za'ra mono norĩ zama, ma tô duré te te 're simroi u'âsi, ẽtẽ na. Si'a hã ti'ra zawi te, 're ĩpapo za'ra mono ne, wa aré te ĩ̱sima 're aiwẽ u'âsi za'ra wa'wa, ĩ̱sitẽme te 're ai'awaibui wa'aba mono da. Tane nherẽ, asima 're ĩ̱wẽ za'ra wa'aba mono õ di asa. ");
INSERT INTO xavNT_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Taha wa, tinhorõwa hã te za oto tirẽ, 'Re ĩhâimana u'âsi mono hã, ãma 're ĩ'aiwata za'ra wa'aba mono zé hã. Duré a norĩ wa'wa hã, ĩ̱hâiba 'madâ'â na sahu za'ra wa'aba õ di za a'â. Niwapsi duré ĩ̱hâiba 'madâ'â za'ra wa'aba wa, te za ãne asima ĩ̱wasu'u za'ra wa'wa: “'Re ĩhâimana u'âsi mono zadawa para we ĩmorĩ ma, 're rowẽ za'ẽtẽ mono di za.” Ãne te za asima ĩ̱wasu'u za'ra wa'wa, ĩ̱hâiba 'madâ'â na duré sahu za'ra wa'aba wa. Ãne na aipẽ'ẽ 're asina ĩ̱waihu'u za'ra wa'aba wapsi, te za ĩ̱hâiba 'madâ'â na duré ĩsahu za'ra wa'wa. — Ãne ma tô sisõwa tinha, Zezusi hã. ");
INSERT INTO xavNT_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Zudezu norĩ te, romhuri zahârizém na ma tô Zezusi hã ãzé, aibâ nhorõwa u, ĩsiré sa da. Aibâ hã, parisezu. Ĩsiré parisezu norĩ ma, pire di, aibâ hã. Tame 'ri para, ĩsi'ubumro norĩ hã ma tô Zezusi hã 'madâ'â za'ra. ");
INSERT INTO xavNT_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Tame sãmra ré, ma aibâ ĩhâzé ré hã ĩtẽme wi, Zezusihi u. Hâzé wa, te dupto zahuré di. Duré, paihi dupto zahuré di. ");
INSERT INTO xavNT_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Taha wa, ma tô Zezusi hã rowahutu'wa norĩ hã azadanha, parisezu norĩ me: — E romhuri zahârizém na, wa za wa te 're dapese za'ra, sabadu na hã. E ma tô wawi sawi, 'Re ĩhâimana u'âsi mono hã, sabadu na, wa te 're dapese tõ za'ra mono da. E niha ĩsimiroti na rob'ui'éré hã. — Ãne te Zezusi hã azadanha, rowahutu'wa norĩ hã. ");
INSERT INTO xavNT_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Tane nherẽ, asa te te ãma sada'âbâ za'ra õ di. Tawamhã Zezusi hã ma tô aibâ hã pa'â. Ma tô pese. Taha pari, ma tô tãma rob'ru, morĩ da oto, 'ri tẽme. ");
INSERT INTO xavNT_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Tawamhã aibâ za'u si, te tãma nharĩ za'ra, ãne: — Ãté ai'ra hã te za aiwi ti'maiwaptã'ã 'wa, â zô ab're u, ãté powawẽ hã. Tawamhã e â zô ab're hawimhã asiwi wazere aba õ di za, romhuri zahârizém na nherẽ. — Ãne ma tô Zezusi hã asa ãma azadanha. ");
INSERT INTO xavNT_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Tazahã asa te te ãma sada'âbâ waihu'u za'ra õ di. ");
INSERT INTO xavNT_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Tawamhã wedeza na dasi'ubumroi wamhã, ma tô ni'wam norĩ hã dama ĩpire norĩ te na ai'ubumro, dame sô ĩdahârâ za'ra norĩ hã. Ãne ma tô ãma da'madâ, Zezusi hã. Taha wa, ma tô tãma ãma romnhimiré'é za'ra, ãne: ");
INSERT INTO xavNT_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","— Ni'wa hã asô hârâ wamhã, dasina damro u dame asa da, aimorĩ wamhã, dama ĩpire norĩ te na, asãmra õ di za. E marĩ wa. Ãté, aima ĩpire hã te dame tihâiba, dame sô ĩdahârâ hã. ");
INSERT INTO xavNT_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Tawamhã te za aima tinha, 'ri tede'wa hã, õ niwĩ asãmra da, asãmrazém na sãmra da, aima ĩpire hã. Taha wa, te te aima ĩnharĩ ma, asiséb di za. Da'rãsutu u, te za oto asã. ");
INSERT INTO xavNT_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Taha wa, ãne tõ da, dame asa da, asô dahârâ wamhã, da'rãsutu u, te za a'â asã. E marĩ da. 'Ri tede'wa hã si'uihâ na si te te aima pisutu da, dama ĩpire norĩ 'rata asãmra da, asa da. Danho'a te te aima pisutu wamhã, aima rowẽ uptabi di za. ");
INSERT INTO xavNT_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Tane, ni'wa hã pire wẽ te, 'râwi sina 're wata mono wamhã, 'Re ĩhâimana u'âsi mono, te za tãma pisutu, wapu na 're hâimana mono da oto. Duré ni'wa hã, tipire na 'râwi 're si'madâ'â mono õ wamhã, te za tãma pisutu, dama pire na 're hâimana mono da oto. — Ãne ma tô tãma waihu'u, Zezusi hã. ");
INSERT INTO xavNT_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Tawamhã dame sa da, sô ĩhârâ ma, te tinha, Zezusi hã: — Dasaihurizé, dama 're 'manharĩ mono wamhã, ãté sô aihârâ za'ra õ di za, asiwadi norĩ zô hã duré asisãnawã norĩ zô hã, duré aimama norĩ zô hã duré ĩsibrob ahâ norĩ zô hã, aiwaptoma 're ĩsi'ubumroi mono norĩ zô hã. Ta norĩ zô aihârâ wamhã, asiré saihuri da, te za asa asô tihârâ za'ra, te te asa aima ãma wa'rãmi za'ra da. ");
INSERT INTO xavNT_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Taha wa, dasaihurizé hã dama 'manharĩ wamhã, te za ĩsibrob'õ norĩ zô aihârâ za'ra, duré ĩmorĩ'õ norĩ zô, duré ĩ'rãtẽire norĩ zô, duré ĩtob'a norĩ zô. ");
INSERT INTO xavNT_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Ãne wamhã, aima 're rowẽ mono di za. E marĩ wa. Ta norĩ hã simarĩ õ di, marĩ na te te aima ãma ĩwa'rãmi za'ra zéb da hã. 'Re ĩhâimana u'âsi mono si, te za asõprubzé wa'rãmi aima tisõ. 'Re ĩnomro wẽ mono norĩ te te ahâiwa'utu wapsi, te za aima ãma uwaimra. — Ãne ma tô 'ri tede'wai ma waihu'u, Zezusi hã. ");
INSERT INTO xavNT_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Tame ma tô aibâ hã dame nhamra, 'ri para, sa da. Tawamhã Zezusi te te dama ĩwaihu'uzé hã ma tô dame wapa. Taha wa, te Zezusihi ma tinha: — 'Re ĩhâimana u'âsi mono, Danhib'apito uptabi na 're ĩhâimana mono zéb ãma, ĩ'rata 're ĩsaihuri mono norĩ ma, 're rowẽ uptabi za'ra mono di za. — Ãne te Zezusihi ma tinha. ");
INSERT INTO xavNT_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Tawamhã Zezusi hã te asa aibâ wasu'u hã tãma wasu'u, ãne: — Aibâ hã dasa hã sa'ẽtẽ na te te dama 'manharĩ da, ma tô sina roti. Tawamhã te te dama 'manharĩ õ ré, ma tô da'apo're pu'u siro, da'ahâ na ĩtẽme dasihutu da, ĩsiré dasaihuri da. ");
INSERT INTO xavNT_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Sipi pari wamhã, tãma ĩromhuri'wai ma, te tinha, ãne: “Mo oto aimorĩ dazô, we dasi'aba'ré da. Dasa hã te oto dazô aimasa.” Ãne te tãma tinha. Taha wa, romhuri'wa hã ma tô datẽme mo, dazô hârâ da. ");
INSERT INTO xavNT_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","— Tane nherẽ, te nasi aibâ norĩ hã siparabâsi niha tãma nharĩ za'ra, romhuri'wai ma, te te sima wẽ za'ra õ wa. Sô ĩhârâ 'rada hã te tãma tinha, ãne: “Ãma ĩ̱morĩ neza. Tane nherẽ, ti'a hã wa 'mai'uipra. Tamomop si wa za mo, te sabu da. Ãne asib'apito ma, ĩ̱zadawa wasu'u na za.” Ãne te tãma ĩromhuri'wai ma tinha. ");
INSERT INTO xavNT_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","— Tawamhã ĩhâiba amo hã te duré tãma tinha: “Ãma ĩ̱morĩ neza. Tane nherẽ, powawẽ hã wa 'mai'uipra, 10 na ĩhâiba za'ra hã. Tamomop si wa za mo, te sabu za'ra da, te te romhuri wẽ za'ra zô. Ãne, asib'apito ma, ĩ̱zadawa wasu'u na za.” Ãne te romhuri'wai ma tinha. ");
INSERT INTO xavNT_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","— Ĩhâiba amo hã te duré tãma siwasu'u: “Nimosi, wa ĩ̱mro. Taha wa, dame ĩ̱sa da, ãma ĩ̱morĩ waihu'u õ di.” Ãne te romhuri'wai ma tinha. ");
INSERT INTO xavNT_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","— Taha wa, te apâ mo romhuri'wa hã, tinhib'apito ma, te te sadawa wasu'u za'ra da. Te te wapari wamhã, ma tô ab'rui pese, ĩsib'apito hã. Taha wa, te ãne tãma tinha: “Ai'aba'ré na dazô 're aimorĩ, 'ri nhi'riti na we danhimroi mono da, ĩsibrob'õ norĩ hã, duré ĩmorĩ wẽ'õ norĩ hã, duré ĩtob'a norĩ hã, duré ĩ'rãtẽire norĩ hã.” Ãne te tãma rob'ru. Taha wa, te ta norĩ zô si mo, we te te simroi mono da. ");
INSERT INTO xavNT_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","— We te te danhimroi mono pari, te tinha, tinhib'apito ma: “Apito, wa tô aimreme hã ãma uwaimra, aima. Zahadu da'masisi õ di.” Ãne te tãma tinha. ");
INSERT INTO xavNT_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","— Taha wa, te ĩsib'apito hã duré asa tãma tinha: “Tane wamhã, dazô airĩtĩ mono pé, bâdâdi na. Da'manhopẽtẽ wamhã, ta norĩ hã te za we ĩsimroi mo, ĩ̱nhorõwa hã da te dasiwi 'masisi da. ");
INSERT INTO xavNT_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Tô sena, wa aima waihu'u za'ra wa'wa. Sô ĩ̱hârâ 'rata norĩ hã, ĩ̱sa na saihuri õ di za.” Ãne te ĩsib'apito hã tãma tinha. — Ãne te aibâ ma rowasu'u, Zezusi hã. ");
INSERT INTO xavNT_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Tawamhã Zezusi norĩ hã si'aba'réi ré, te da'ahâ na ĩsarina ai'aba'ré ni. Tawamhã ma tô Zezusi hã datẽme aipi'ra. Ãne te dama tinha: ");
INSERT INTO xavNT_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","— Ãté, ni'wam norĩ hã te za we ĩ̱tẽme ai'aba'ré, ĩ̱zazei'wa, 're nomro mono da. Tawamhã te za te te 're ĩ̱zawi pese za'ra, timama zawi nhipai u, duré tina zawi nhipai u, duré timro zawi nhipai u, duré ti'ra norĩ zawi nhipai u, duré tisisãnawã norĩ zawi nhipai u, duré tihâimanazém nhipai u. ");
INSERT INTO xavNT_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Tiza'ozéb ré, ĩ̱zarina 're ĩnomro mono ne, da te 're uprosi za'ra mono da nherẽ, te za ĩ̱siré 're nomro. Ãnei õ wamhã, ĩ̱zazei'wa na te 're waihu'u za'ra mono õ di za. — Ãne ma tô dama waihu'u, Zezusi hã. ");
INSERT INTO xavNT_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Te duré dama tinha: — 'Ri'wa na, wa za aima ãma romnhimiré'é za'ra wa'wa. Ãté, a norĩ wa'wa hã te za asima ĩ'mairosa'rata 'wa, asima 'mai'ri wa'aba da, rob'madâ'âzéb da. Taha wa, te za a'â ĩ'mairosa'rata 'wa, 'ri wa'âbâzéb da, rob'uiprazé hã, ĩwab zô. ");
INSERT INTO xavNT_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","30","Ãnei õ wamhã, ãté õne haré te za ĩsãna'rata si ĩ'manharĩ 'wa. 'Ri 'rãihâ hã 'mai'uprosi aba õ di za. Da te sabu za'ra wamhã, te za ai'ãma 're dawa'ẽ za'ra wa'wa: “Oro te te 'ri 'ru za, te õne haré za.” Ãne te za ai'ãma 're dawa'ẽ za'ra wa'wa. Ãne, 'ri'wa na te aima ãma ĩsimiré'é za'ra wa'aba zé hã. ");
INSERT INTO xavNT_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","33","— Duré apito na, wa za aima ãma simiré'é za'ra wa'wa. Ãté danhib'apito te za dama 're 'manhamra. Ĩsib'a'uwẽ norĩ hã dasi'wapé 'manharĩ'wa norĩ hã te ahâ na 're si'ubumro, 10 miu na ĩhâiba za'ra hã. Tawamhã ma tô apito hâiba amoi wasu'u wapa, danhib'apito hã. Dasi'wapé 'manharĩ'wa hã te we, u, ahâ uptabi na te te simro tinhib'a'uwẽ hã, 20 miu na, u, ĩhâiba za'ra hã. Tawamhã dazô wairébé õ ré, te za a'â nhamra, ĩsib'a'uwẽ hã, dazada siptete za'ra zô. Dazada ĩsiptete za'ra õ na, te te waihu'u za'ra wamhã, te za tinhitob'ru norĩ u da'mazatõ, te te tãma 'mazadawa wasu'u da, ĩsib'apito za'ra ma. Ĩsitob'ru norĩ hã zahadu romhâ ré, te za ĩtẽme da'mazatõ, we dasihutu tõ da, dasi'wapé za'ra tõ da. Ãne, apito na te aima ãma ĩsimiré'é za'ra wa'aba zé hã. Tane ĩ̱zazei'wa, 're anomro aba mono da, marĩ hã asima 're sawi za'ra wa'aba mono õ di za, aipẽ'ẽ 're. Marĩ hã aipẽ'ẽ 're, asima 're sawi za'ra wa'aba mono wamhã, ĩ̱zazei'wa na te 're aiwaihu'u za'ra wa'aba mono õ di za. — Ãne ma tô dama waihu'u, Zezusi hã. ");
INSERT INTO xavNT_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","Te duré dama tinha, Zezusi hã: — Sa na hã dasa hã ãma se ti, dasai warĩrĩzé wa. Tane nherẽ, oto 're se si'utõrĩ mono wamhã, niha da te 're 'manharĩ waihu'u mono õ di, apâ se da. ");
INSERT INTO xavNT_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Sei õ wamhã, ti'a hã wẽ da, ti'ai wa, da te 're sa'wari za'ra mono õ di za. Duré powawẽ nhana ubumro nhisiwi, da te 're sa'wari za'ra mono õ di za. Taré, te za rob u, da te 're sa'wari za'ra, marĩ dai õ wa oto. Ãne romnhimiré'ézé hã. Asimipari pese za'ra wa'aba wamhã, ma'ãpé ĩ̱wapari pese za'ra wa'aba. — Ãne te Zezusi hã dama si'ru. ");
INSERT INTO xavNT_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Tawamhã Zezusihi u ma tô aihutu ni, da'ahâ na, ĩmreme hã da te wapari za'ra da. Danhib'apito ma, rob'uiprazé ubumroi'wa norĩ hã ma tô duré ĩtẽme aihutu, siwa'ru 're ĩnomro mono norĩ zama. ");
INSERT INTO xavNT_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Tawamhã parisezu norĩ hã te ãne tãma nharĩ za'ra, 'Re ĩhâimana u'âsi mono nhimiroti 'rata na rob'ui'éré na dama rowahutu'wa norĩ me: — Õ hã ma tô ãma 're siwadi za'ra, siwa'ru 're ĩnomro mono ãma hã. Ta norĩ siré, te nasi tisa. — Ãne te Zezusihi ma nharĩ za'ra. ");
INSERT INTO xavNT_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Taha wa, Zezusi hã ma tô tãma ãma romnhimiré'é za'ra, ãne: ");
INSERT INTO xavNT_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","— Asimizama hã ahâ wamhã, ãté misi te za aiwi aimani, 100 na ĩhâiba za'ra wamhã. E tawamhã, sô airĩtĩ mono õ di za, aiwi 'masimani wamhã. Te za tô sô airĩtĩ mo, apâ âri da. Asimizama zô airĩtĩ mono ré, te za 99 na ĩhâiba za'ra hã asa'u daba'wara, ĩtehutu wa. ");
INSERT INTO xavNT_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Tawamhã aiwi ĩsimani hã oto sãmri wamhã, atoi uptabi di za. Taha wa, te za asisé we ĩ'â apâ, sãmri wẽ te. ");
INSERT INTO xavNT_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","'Ri tẽme ãwisi wamhã, te za sô aihârâ za'ra, asiwadi norĩ zô. 'Râwi ai'rata 're ĩsõrõwa za'ra mono norĩ zô zama, te za sô aihârâ za'ra. Tawamhã te za tãma ĩrowasu'u za'ra, ãne: “Ãhãna ĩ̱ma rowẽ di. Ĩ̱nhimizama hã wa tô tisã, ĩ̱wi ĩsimani hã. Ĩ̱zabâdâ te za 're ato za'ra wa'aba mo.” Ãne te za tãma ĩrowasu'u za'ra. ");
INSERT INTO xavNT_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","— Tane duré, ni'wa hã siwa'ru 're ĩmorĩ hã tiwasédé hã te te oto rẽme pese wamhã, hâiwa ãma 're ĩsi'ubumroi mono norĩ hã te za tãma 're to za'ra, misi nherẽ. Õhõ ãma si, te za 're toi uptabi za'ra, 're ĩnomro wẽ mono norĩ nhipai u hã, 99 na ĩhâiba za'ra nhipai u hã. Ta norĩ hã 're nomro wẽ mono wa, tiwasété na 're ĩsiwẽ'õ za'ra mono da hã, mare di. — Ãne ma tô tãma rowasu'u za'ra, rowahutu'wa norĩ ma, Zezusi hã. ");
INSERT INTO xavNT_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Tawamhã Zezusi hã te duré tãma ãma romnhimiré'é za'ra, ãne: — Pi'õ te, rob'uiprazé hã ahâ wamhã, ãté misi te za tiwi 'maihaimani, 10 na hâimana za'ra wamhã, ĩsapotore hã. E tawamhã sô 're rĩtĩ mono õ di za, tiwi 'masimani wamhã. Te za tô sô 're rĩtĩ. Ĩro'ore hã te za duré sô ro'o, sô rĩtĩ da. Te za duré sô 'ri 're wamro. Sô 're rĩtĩ pese mono wamhã, te za oto tisã. ");
INSERT INTO xavNT_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Tawamhã te te sãmri wẽ te, tisiwadi norĩ zô te za oto tihârâ za'ra. Ĩ'rata ĩsõrõwa za'ra norĩ zô zama, te za tihârâ za'ra. Tawamhã, te za oto tãma rowasu'u za'ra, ãne: “Ãhãna, ĩ̱ma rowẽ di. Rob'uiprazé ĩsapotore hã wa tô tisã, ĩ̱wi ĩsimani hã. Ĩ̱zabâdâ te za 're ato za'ra wa'aba mo duré, a norĩ wa'aba zama.” Ãne te za tãma rowasu'u za'ra. ");
INSERT INTO xavNT_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","— Tane duré, ni'wa hã siwa'ru 're ĩmorĩ hã, tiwasédé hã te te oto rẽme pese wamhã, hâiwa ãma 'Re ĩhâimana u'âsi mono ma romhuri'wa norĩ hã te za ãma 're to za'ra, tiwasédé hã te te rẽme pese wẽ te, misi nherẽ. — Ãne ma tô tãma rowasu'u za'ra, Zezusi hã. ");
INSERT INTO xavNT_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Zezusi hã te duré tãma ãma romnhimiré'é za'ra, ãne: — Aibâ 'ra hã maparane. ");
INSERT INTO xavNT_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Tawamhã te bâtâ na ĩno hã timama wi waptẽ, tinhibrom na ãma tãma siwanhizari zahuré da. — Taha wa, ma ĩmama hã ãma tãma aipo'o zahuré. ");
INSERT INTO xavNT_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Ãma ronomro õ ré, te uburé tinhibro hã sima ubumro, darob amo u morĩ da, ĩno hã. Darob amoi u wisi wamhã, wasété ahâ na te 're mo. Marĩ na si, ma taré tinhibro hã uprosi, ĩmama te te tãma ĩpo hã. ");
INSERT INTO xavNT_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","— Tawamhã tinhibro hã ma uburé uprosi pese oto, ai'repudu hã. Tawamhã tame darob ãma 're ĩdasi'ubumroi mono norĩ hã ma tô duré mram na 're dasi'ubumro. Dasai õ di. Taha wa, ma tô ai'repudu hã mra hã dame sépata. ");
INSERT INTO xavNT_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Taha wa, te aibâ u mo, te te tãma 're romhuri mono da, tame. Taha wa, ma tô aibâ hã satõ tiburu u, buru ãma uhâbâ te te tãma 're 'madâ'â mono da. ");
INSERT INTO xavNT_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Mrap te, ma tô sima wẽ, uhâbâ sa na 're sai mono da. Mra, te te 're sépata mono nherẽ, ai'reputu ma hã, da te 're ai mono õ di. ");
INSERT INTO xavNT_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Taha wa, ma tô si'ãma rosa'rata, ãne: “Ĩ̱mama ma, romhuri'wa norĩ hã ahâ nherẽ, ma tô dasa hã 're si'azahâri. Wa hã wa ãme mra hã te 're sépata za'ẽtẽ. ");
INSERT INTO xavNT_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Taha wa, wa za oto mo, ĩ̱mama u apâ. Ĩ̱wisi wamhã, wa za ĩ̱mama ma ĩ̱siwasu'u, ãne: ‘Ĩ̱mama, ĩ̱wasété na wa tô 're mo. 'Re ĩhâimana u'âsi mono nhimiroti hã, wa tô upa. Asimiroti zama, wa duré upa. ");
INSERT INTO xavNT_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Ĩ̱wasété wa, ãté ĩ̱'ãma 're ai'ra mono õ di za oto. Aima romhuri'wa da, oto 're ĩ̱morĩ da, te za ĩ̱ma ĩpisu.’ ” Ãne ma tô rosa'rada hã sima 'manha, ai'repudu hã. ");
INSERT INTO xavNT_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","— Tawamhã aré 're ĩsãmra mono zém hawi te oto mo, timama nhorõwa u. Tawamhã zahadu romhâ ré, ma ĩmama hã tisã ti'ra hã. Taha wa, te ĩtẽme wara, ĩ'ra hã te te sina pẽ'ẽ tari wa. Ĩtẽme wisi wamhã, tinho'utu ma tô ti'â, ti'ra hã. Tob'rata hârâ na, ma duré sawi. ");
INSERT INTO xavNT_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Tawamhã te timama ma tinha, ai'repudu hã: “Ĩ̱mama, ĩ̱wasété na, wa tô 're mo. 'Re ĩhâimana u'âsi mono nhimiroti hã, wa tô upa. Asimiroti zama, wa duré upa. Ĩ̱wasété wa, ãté ĩ̱'ãma 're ai'ra mono õ di za.” Ãne te timama ma siwasu'u, ai'repudu hã. ");
INSERT INTO xavNT_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","— Wasété na 're morĩ nherẽ, te te wẽ'õ õ di, ti'ra hã, ĩmama hã. Tãma ĩromhuri'wa norĩ hã te oto 'mahârâ za'ra sa'ẽtẽ, zazahâ ĩhâiwẽ we te te siwi 'mai'âri da, te te siwi ãma uza da. Duré ĩsiptõmohi wasisizé, te te tãma sẽrẽ za'ra da, ma tô 'mahârâ za'ra. Duré ĩpara'uza zama te te tãma sẽrẽ za'ra da, ma tô 'mahârâ za'ra. ");
INSERT INTO xavNT_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Taha wa, te duré tãma nharĩ za'ra: “Powawẽ zapu zama, we ãwisi aba, wĩrĩ aba da, ĩhâipe hã. ");
INSERT INTO xavNT_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","E marĩ wa. Ĩ̱'ra hã dâ'â newa. Tane nherẽ, dâ'â õ di. Ma tô aré ãma ropsisa'rese'õ. Tane nherẽ, ma tô we apâ wi. Taha wa, wasa hã wa za oto wasiré huri ni, rowẽ te.” Ãne ĩmama te tãma nharĩ za'ra, te te tãma 're ĩromhuri za'ra mono norĩ ma. Taha na ma tô dasa hã dama 'manha. ");
INSERT INTO xavNT_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","— Tawamhã ĩno hã wisi wamhã, ĩdub'rada hã te buru ãma nhamra. 'Ri tẽme te oto mo. Te te oto rob'umhutu wa, ma tô rowamreme hã wapa, te te ĩrowamreme za'ra hã. Dapara 'rasi zama, ma tô wapa, rowẽ te, dasima 're ĩdato za'ra mono zé hã. ");
INSERT INTO xavNT_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Taha wa, te romhuri'wa hã 'mahâ, ãne: “E marĩ, te 'manharĩ za'ra ni.” Ãne te sadanha. ");
INSERT INTO xavNT_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","— “Ano hã rowẽ na ma tô wei wi. Taha wa, wei wisi wẽ te, ma tô wama ti'ru aimama hã, powawẽ ĩhâipe hã wa te wĩrĩ da, wasaihuri da.” Ãne te ĩdub'rata ma rowasu'u, romhuri'wa hã. ");
INSERT INTO xavNT_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","— Tawamhã ma ĩdub'rada hã tizahi. 'Ri para u sébré da hã, te te sima wẽ õ di. Tawamhã ĩmama, ma ĩtẽme watobro, te te tãma nharĩ da, sébré da. Tane nherẽ, sébré zei õ di. ");
INSERT INTO xavNT_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Tane nherẽ, te timama ma tinha: “Wa hã wa tô te aima 're romhuri pese. Ĩ̱'ãma wahub ahâ di, te aima 're romhuri mono ré hã. Niwa, aimreme hã te simini õ di. Tane nherẽ, marĩ ĩ̱ma sõmri õ di, pone'ẽrebâ hã, dasa hã te ĩ̱siwadi norĩ ma 'manharĩ da. ");
INSERT INTO xavNT_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Ãhãna ai'ra hã ma tô wi. Asibro hã tãma ĩpo hã ma tô pi'õ na uprosi. Tane nherẽ, ma tô wisi wi, dama ĩ'ru, powawẽ ĩhâipe hã da te tãma wĩrĩ da.” Ãne te timama ma tinha, ĩdub'rada hã. ");
INSERT INTO xavNT_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","— Tawamhã ĩmama te asa tãma tinha: “Ĩ̱'ra, a hã ĩ̱'rata, te 're asãmra u'âsi mo. Marĩ hã ĩ̱nhibro hã, uburé ate hã. ");
INSERT INTO xavNT_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Uburé wama rowẽ za'ra wa, wa tô dasa hã dama 'manha, ĩ̱'ra hã ĩwisizém na. Ano hã dâ'â newa. Tane nherẽ, dâ'â õ di. Ma tô aré ãma ropsisa'rese'õ. Tane nherẽ, ma tô we apâ wi.” Ãne ma tô ti'ra ma waihu'u. — Ãne Zezusi ma tô tãma rowasu'u za'ra, rowahutu'wa norĩ ma. ");
INSERT INTO xavNT_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Zezusi hã te duré ãne tãma rowasu'u za'ra, tisiré 're ĩnomro mono norĩ ma: — Aibâ hã te 're hâimana, ĩsibrob ahâ hã. Tãma ĩromhuri'wa hã te duré 're sãmra, tãma rob'madâ'â'wa hã. Tawamhã ma tô tãma 'mairowasu'u ni, ãne: “Rob'uiprazé hã te te aiwi 're anhimini, aima rob'madâ'â'wa hã.” Ãne te tãma 'mairowasu'u ni. ");
INSERT INTO xavNT_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Taha wa, te sô hâ, tãma ĩrob'madâ'â'wa zô. Te tãma tinha, ãne: “Aiwasu'u hã wa tô wapa. Ĩ̱ma 're ĩrob'madâ'â mono zé hã, tâibâ za oto. Te za rob'ui'éré hã oto ĩ̱ma ĩsõ, uburé ĩ̱nhimarĩ na 're ĩrob'ui'éré mono zé hã.” Ãne te tãma tinha, tãma ĩrob'madâ'â'wai ma. ");
INSERT INTO xavNT_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","— Tawamhã te 'râwi sima tinha, tãma ĩrob'madâ'â'wa hã: “Ĩ̱nhib'apito, ma tô ĩ̱ma tinha, te tãma 're romhuri mono tõ da oto. E marĩ, wa za oto te 're 'manharĩ. Ĩ̱nhiptete uptabi õ di, buru na te dama 're ĩromhuri mono zéb da hã. Duré ĩ̱nhiséb di za, rob'uiprazém na te 're da'awari mono wamhã. ");
INSERT INTO xavNT_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Ĩhe, wa tô ĩ̱sima waihu'u, marĩ te ĩ'manharĩ da hã, ĩ̱'ãma 're dasiwadi za'ra mono da. Tawamhã, apito te te ĩ̱mei wamhã, ãté ĩ̱siwadi norĩ hã te za te te siwi 're ĩ̱mrami, tinhorõwa u, ĩsiré 're ĩ̱sa za'ra mono da.” — Ãne te 'râwi sima tinha. ");
INSERT INTO xavNT_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","— Tawamhã te sô hã, apito ma, marĩ te te ĩwa'âbâ za'ra õ norĩ zô. Tawamhã ĩtẽme ĩwisi 'rada hã te sadanha: “E niha tãma ĩwa'âbâ'õ hã zahadu, rowa'rãmimhã.” ");
INSERT INTO xavNT_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","— “Piza'a, 100 na ĩhâiba za'ra hã, azeitona 'rãi wa'ui wab ré hã.” — Ãne te tãma rowasu'u. Taha wa, te asa tãma tinha: “Ãhãta ĩwa'âbâ'õ na, rob'ui'éré hã. Asãmra. 50 na ãma rob'ui'éré, rowa'rãmimhã, tãma wa'âbâ da.” — Ãne te aibâ ma ti'ru, tãma ĩrob'madâ'â'wa hã. Taha wa, te te tãma ĩ'ru zarina, ma tô ahâ prã na ãma rob'ui'éré. ");
INSERT INTO xavNT_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","— Tawamhã aibâ hâiba amo hã ma duré ĩtẽme wi. Tawamhã te sadanha: “A hã bété, e niha tãma ĩwa'âbâ'õ hã zahadu, rowa'rãmimhã.” — “Sa'u hã, miu na ĩhâiba hã, tridu ré hã te tãma ĩwa'âbâ'õ hã.” — Ãne te tãma rowasu'u. — Tawamhã te asa tãma tinha: “Ma'ãpé, 800 na ãma rob'ui'éré, rowa'rãmimhã tãma ĩsõmri da.” — Ãne te tãma ti'ru, rob'madâ'â'wa hã. Taha wa, te te tãma ĩ'ru zarina, ma ahâ prã na ãma rob'ui'éré. ");
INSERT INTO xavNT_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","— Te te dama ĩ'rui wasu'u, te te wapari wamhã, te tinha, ĩsib'apito hã: “Pra. E niha rosa'rada tãma ĩwaihu'u pe.” Ãne te ĩsa'u tãma tinha. — Ãne Zezusi te tãma rowasu'u za'ra, tisiré 're ĩnomro mono norĩ ma. Ma tô duré tãma waihu'u za'ra: — Marĩ zô si, da te 're ĩrosa'rata za'ra mono norĩ ma, waihu'u pese di, rosa'rada hã, rowa'a nhib'a'uwẽ norĩ nhipai u. ");
INSERT INTO xavNT_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Taha wa, ti'ab ré te za asimarĩ na 're ĩdazawi za'ra wa'aba mo, ãma 're asiwadi za'ra wa'aba mono da. Asimarĩ hã asipara 're rẽme za'ra wa'aba mono wapsi, hâiwa u, asõrõwa u 're asisisi aba mono wi, te za asô 're tob'uzu za'ra wa'wa, asawi'wa norĩ wa'wa hã. — Ãne Zezusi te tãma roti za'ra, tisiré 're ĩnomro mono norĩ ma. ");
INSERT INTO xavNT_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Te duré tãma nharĩ za'ra: — Ãté ni'wam norĩ hã te za danhibrob 'rare hã, dazô te te 're 'madâ'â wẽ za'ra. Tawamhã dama umnhasi wa, te za da te tãma 're pisutu za'ra, danhibrob ahâ na, te te dazô 're 'madâ'â za'ra mono da oto. Tane, danhibrob 'rare, dazô te te 're 'madâ'â wasété za'ra mono wamhã, te za da te 're waihu'u za'ra, ĩsa'ẽtẽ na zama, za dawi 're ĩsipsaihuri za'ra mono na. ");
INSERT INTO xavNT_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Ti'ai ãma danhimarĩ hã, dazô 're 'madâ'â wasété za'ra wa'aba mono wamhã, e 'wa hã te za marĩ ĩwẽ uptabi hã te te aima 're pisutu za'ra wa'wa, sô 're 'madâ'â za'ra wa'aba mono da. Mare di. Ni'wa, te te aima 're pisutu za'ra wa'aba mono õ di za. ");
INSERT INTO xavNT_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Marĩ hã date hã, dazô 're 'madâ'â wasété za'ra wa'aba mono wamhã, e niha te za marĩ ĩwẽ hã da te aima 're sõmri za'ra wa'wa, ate da. Mare di. Ni'wa te te aima 're sõmri za'ra wa'aba mono õ di za. — Ãne Zezusi ma tô tãma waihu'u za'ra. ");
INSERT INTO xavNT_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Te duré tãma nharĩ za'ra: — Dama romhuri'wa hã ĩsib'apito maparane wamhã, aiwa te te tãma 're romhuri wẽ zahuré mono õ di za. Duré sahuré te te 're sawi pese zahuré mono õ di za. Misi te za te te 're sawi pese. Ĩhâiba amo si te za te te siwi 're wẽ'õ. Duré sahuré te te 're wapari pese zahuré mono õ di za, romhuri'wa hã. Misi te za te te 're wapari pese. Ĩhâiba amo si te za te te 're 'ruiwapari. Tane, a norĩ wa'wa hã rob'uiprazéb zô si asima 're romhuri za'ra wa'aba mono wamhã, e aiwa asimiromhuri za'ra wa'wa hã za, 'Re ĩhâimana u'âsi mono ma, romhuri me. Mare di. Aiwab õ di. — Ãne ma tô Zezusi hã tãma waihu'u za'ra, tisiré 're ĩnomro mono norĩ ma. ");
INSERT INTO xavNT_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Tawamhã parisezu norĩ hã ma tô Zezusihi mreme hã wapari za'ra. Tawamhã rob'uiprazé zei 'wa, 're nomro mono wa, ma tô Zezusihi ma nharĩ za'ra. ");
INSERT INTO xavNT_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Taha wa, te Zezusi hã tãma nharĩ za'ra, ãne: — A norĩ wa'wa hã aiwẽ newa, te ai'ãma 're dawata za'ra wa'wa. Tazahã asimirosa'rata 'wa hã, 'Re ĩhâimana u'âsi mono ma, waihu'u pese di. Ãté, marĩ na te za dasima ãma 're dawata za'ra, ĩwẽ newa. Tazahã tãma wẽ õ wamhã, te za te te 're awẽ'õ, 'Re ĩhâimana u'âsi mono hã. ");
INSERT INTO xavNT_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","— Uburé marĩ hã Mozési te te dama 're ĩ'apisutu mono hã, da te 're 'madâ'â za'ra mono da, duré 'Re ĩhâimana u'âsi mono zadawa wasu'u 'rata 'wa norĩ nhimiroti hã ma tô dasipara bâ si, da te 're pese za'ra, Zuwã Batita datẽme morĩ õ ré. Tawamhã ĩwasu'uwẽ hã te oto da te 're wapari za'ra, 'Re ĩhâimana u'âsi mono hã, da'ãma 're ĩsib'a'uwẽ mono zé wasu'u hã. Taha wa, marĩ zô dasima ĩwẽzéb uwaibaba, da te 're ĩrob'ruiwapari za'ra mono ne, te za oto da te dasima 're rob'ruiwapari za'ra, ĩtẽme 're dasihutu mono da. ");
INSERT INTO xavNT_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","— Pire u'âsi, te za dama 're hâimana za'ra, uburé marĩ hã, 'Re ĩhâimana u'âsi mono te te dama 're ĩ'apisutu mono hã, da te 're 'madâ'â za'ra mono da, ĩsimiroti na rob'ui'éré 'rada hã. Hâiwa hã si'utõrĩ nherẽ, duré ti'a hã si'utõrĩ nherẽ, te za pire u'âsi dama 're hâimana u'âsi. — Ãne ma tô tãma waihu'u za'ra. ");
INSERT INTO xavNT_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","— Ni'wa hã aibâ hã timro te te rẽme wamhã, duré pi'õ aimawi na mro wamhã, te za tiwasédé hã 'manha, aibâ hã. Duré, pi'õ, da te ĩme na aibâ mro wamhã, te za duré 'manharĩ wasété. — Ãne, Zezusi ma tô tãma waihu'u za'ra, parisezu norĩ ma. ");
INSERT INTO xavNT_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Tawamhã Zezusi hã te duré tãma rowasu'u za'ra, parisezu norĩ ma, ãne: — Aibâ hã te 're mo, ĩsibro pe hã. Zazahâ ĩwa'âbâ za'ẽtẽ na si, te 're si'uza. Duré dasa ĩwẽ uptabi na si, te 're sa. ");
INSERT INTO xavNT_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Tawamhã aibâ ĩhâiba amo hã te 're sãmra, ĩsibrob'õ hã, ĩ'wa're ré hã, Razaru na ĩsisi hã. Ĩsiwadi norĩ hã te te siwi 're mrami, ĩsibro pese nhorõwa u, te te siwi 're simizusi mono da, 'ridawa u. ");
INSERT INTO xavNT_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Dasai rere'e na si, te 're sa. Wapsã si ma tô ĩ'wa're hã te te 're upsõmri siwi. ");
INSERT INTO xavNT_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Tawamhã ma tô oto dârâ, ĩsibrob'õ hã. Dâ'â wamhã, hâiwa u ma tô siwi ti'â, 'Re ĩhâimana u'âsi mono ma, romhuri'wa norĩ hã. Abra'ãhã 'rata, te oto 're sãmra, dame 're sai mono da. Ĩsibro pe hã ma tô duré dârâ. Dâ'â wamhã, ma tô dasiwi sẽrẽ ni, ab're 're. ");
INSERT INTO xavNT_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Tawamhã ropipa hã te te oto 're sépata za'ẽtẽ, adâ 're ĩsi'ubumroi mono zéb ãma hã. Ta hawi ma tô rob'madâ, ĩsibro pe hã. Te te rob'madâ'â wamhã, ma tô Abra'ã hã tisã, romhâ na. Ĩ'rata te Razaru hã nhamra, ĩsibrob'õ hã. ");
INSERT INTO xavNT_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Te te 'madâ'â wamhã, ma tô tãma si'mahâ, ãne: “Wahi'rada Abra'ã, ĩ̱'ãma aipẽ'ẽzé na. Ma'ãpé, Razaru hã we ĩ̱tẽme satõrĩ, â we te te ĩ̱ma âri da, te te ãma ĩ̱nhoto di'i da, tinhiptõmo na, ĩ̱nhoto wahâ da. Ãme ropipa, wa oto te 're sépata za'ẽtẽ, unhama ãma.” Ãne te Abra'ãhã ma siwasu'u. ");
INSERT INTO xavNT_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","— Taha wa, ma tô Abra'ã hã asa tãma tinha, ĩsibro pese ma: “Ĩ̱nhihudu, aihâiba ré ré, aima 're rowẽ mono di. Uburé marĩ ĩwẽ hã ma tô asô 're simi'wara. Razaru hã, marĩ hã ĩwasétére si, ma tô da te tãma 're sõmri za'ra. Ãhãna hã rowẽ na te oto 're hâimana. A hã te oto ropipa, 're ĩsépata mo. ");
INSERT INTO xavNT_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Duré, ab're 'rehâ hã ĩsa'ẽne hã te 're sa'wari, wawa'wa. Taha wa, wa te ãma 're saprĩ waihu'u za'ra mono õ di, atẽme wa'aba hã. Duré a norĩ wa'wa hã we 're saprĩ waihu'u za'ra wa'aba mono õ di, watẽme hã.” Ãne te tãma tinha, Abra'ã hã. ");
INSERT INTO xavNT_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","— Tawamhã ĩsibro pe hã te asa tãma tinha: “Wahi'rada Abra'ã, tane wamhã, ma'ãpé Razaru hã satõrĩ, ĩ̱mama nhorõwa u. ");
INSERT INTO xavNT_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","Tame te ĩ̱sisãnawã norĩ hã 're si'ubumro, 5 na ĩhâiba za'ra hã. Ropipa, wa oto te 're sépata. Taha wa, te za ĩsatõ, ĩtẽme morĩ za'ra da, te te tãma rowasu'u za'ra da, ĩ̱zarina we 're sisisi tõ mono da, ropipa u.” Ãne te Abra'ãhã ma tinha. ");
INSERT INTO xavNT_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","— Taha wa, ma tô duré Abra'ã hã asa tãma tinha: “'Re ĩhâimana u'âsi mono nhimiroti na Mozési te te ãma ĩrob'ui'éré hã te nomro, ano norĩ 'ratamhã. 'Re ĩhâimana u'âsi mono zadawa wasu'u 'rata 'wa norĩ nhimi'ui'éré zama, te ĩ'rata tinomro za'ra. Ta hã te za te te 're wapari za'ra za, ti'ai ãma ré.” Ãne ma tô ĩsibro pese ma rowasu'u, Abra'ã hã. ");
INSERT INTO xavNT_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","— Ĩsibro pe hã te duré asa tãma tinha: “Tane nherẽ, te te saze za'ra õ di, ĩsimiroti na hã. Ni'wa hã dâ'â nherẽ, hâiwa'utu wamhã, ĩtẽme morĩ za'ra wamhã, te za ĩsimirowasu'u na saze za'ra, ĩ̱sisãnawã norĩ hã. Ãne wapsi, te za tiwasédé hã rẽme pese za'ra, rowẽ na oto 're nomro mono da.” Ãne te Abra'ãhã ma tinha. ");
INSERT INTO xavNT_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","— Tawamhã Abra'ã hã te duré asa tãma tinha: “Ano norĩ hã Mozésihi nhimiroti hã te te saze za'ra õ di. Duré 'Re ĩhâimana u'âsi mono zadawa wasu'u'wa norĩ nhimiroti zama, te te saze za'ra õ di. Ãne wamhã, ni'wa hã dâ'â nherẽ, apâ hâiwa'utu wamhã, e te aré ãma saze za'ra. Te te ãma saze za'ra õ di aré, ĩsimirowasu'u na hã.” Ãne Abra'ã hã ma tô tãma waihu'u, ĩsibro pese ma. ");
INSERT INTO xavNT_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Tawamhã Zezusi te tãma nharĩ za'ra, tisiré 're ĩnomro mono norĩ ma: — Ãté ni'wa simiroti zarina, te za ni'wam norĩ hã 're hâimana wasété za'ra. Tawamhã roti wasété'wai ma, 're ropipa za'ra mono di za. ");
INSERT INTO xavNT_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Ãhãta, ai'uté norĩ hã. Ãté, ni'wa simiroti zarina, te za ai'uté hã 're 'maihâimana wasété. Tawamhã tãma ĩroti wasété'wai ma, 're ropipa mono di za. Ĩbutu na ẽtẽ tõmo wawẽ hã da te ãma wasisi pari, dâ'â da, âi ba da te mei wamhã, tãma ropipa di, tãma ĩroti wasété 'wai ma hã. Tane nherẽ, ĩsimiroti wasété zarina, ai'uté te te ĩ̱rẽme wamhã, taha nhipai u hã tãma ropipa uptabi di za, roti wasété'wai ma hã. ");
INSERT INTO xavNT_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Taha wa, te za 'râwi asina 're asõpré wa'aba mo, 're anomro wẽ wa'aba mono zéb zô. Ãté asisãnawã hã te za asada 're wasété za'ra wa'wa. Ãne wamhã, aimreme wẽ na, te za tãma 're ĩroti za'ra wa'aba mo, asada 're wasété za'ra wa'aba mono tõ da. Tiwasété na aima 're siwẽ'õ za'ra wa'aba mono wamhã, te za tãma 're ĩnharĩ za'ra wa'aba mo, ãne: “Te ĩ̱sina 'madâ'â õ di, ĩ̱zada aiwasétézé hã.” Ãne te za tãma 're ĩnharĩ za'ra wa'aba mo. ");
INSERT INTO xavNT_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Ãté, ã bâtâ na te za bâtâ bâ asada 're wasété za'ra wa'wa, asisãnawã norĩ hã. Ãté 7 na asada ĩwasétézé hã za. Tane nherẽ, tiwasété na aima siwẽ'õ wa'aba da, apâ atẽme nasi simasisi aba wamhã, te za nasi tãma ĩnharĩ 'wa: “Te ĩ̱sina 'madâ'â õ di, ĩ̱zada aiwasétézé hã.” — Ãne ma tô Zezusi hã tãma waihu'u za'ra, tisiré 're ĩnomro mono norĩ ma. ");
INSERT INTO xavNT_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Tawamhã ĩsadawa wasu'u'wa norĩ hã ma tô tiwi rowaptẽrẽ za'ra, ãne: — Wanhib'apito, wama 're aza'ẽtẽ u'âsi mono, wa te wasina 're ĩ'ai'umnhasi za'ra mono zé hã. — Ãne te tiwi rowaptẽrẽ za'ra. ");
INSERT INTO xavNT_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Taha wa, te Zezusi hã asa tãma ãma romnhimiré'é za'ra, ãne: — Motada nhamare hã syryre nherẽ, da te 're wamhã, oto poto wamhã, wede za'ẽtẽ uptabi di. Tane, a norĩ wa'wa hã asina 're ĩ̱'umnhasi za'ra wa'aba mono zé hã, syryre na nherẽ, aima 're hâimana za'ra wa'aba mono wamhã, te aré pidera wede ma ĩnharĩ za'ra wa'wa, ãne: “Ma'ãpé asi'uihâ na asisa'o'o, â 're, asi're da.” Tawamhã te aré asadawa zamarĩ za'ra wa'wa, pidera wede hã. — Ãne, Zezusi ma tô tãma waihu'u za'ra, tisiré 're ĩnomro mono norĩ ma. ");
INSERT INTO xavNT_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Ma duré tãma waihu'u za'ra, ãne: — Ãté aima romhuri'wa hã te 're 'manhamra, ãté buru na te te aima 're ĩromhuri mono hã, ãté pone'ẽrebâ 'madâ'â'wa. Tawamhã bâtâ na te za atẽme wi, romhuri hawimhã. 'Ri para u sébré wamhã, e te za ãne tãma ĩnha: “We oto asãmra, asa da.” E ãne, te za tãma ĩnha. ");
INSERT INTO xavNT_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","9","Mare di. Ãne te za tãma ĩnha: “A'â ĩ̱ma asipi na. Asipi parip si, zazahâi wa'õtõ na asi'usisi, ĩ̱sa hã we ĩ̱ma ĩré âri da, â zama. Ĩ̱sai parip si, te za asa. Te za duré ĩhâ'rẽ.” Ãne te za tãma ĩnha. Tawamhã te za aima ãma uwaimra, tãma ĩ'ru zarina. Asiminhimi'ru hã te te ãma aima uwaimrami wa, e te za sô amnhasi, ãma aiwata zô. Mare di. Sô simnhasi õ di za. ");
INSERT INTO xavNT_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Tane a norĩ wa'wa hã, asib'apito nhimiwada'uri 'wa, ĩ̱ma ãma 're uwaimrami za'ra wa'aba mono wamhã, te za 're ĩnharĩ za'ra wa'aba mo, ãne: “Sô 're wanhimnhasi za'ra mono õ di za, wa'ãma 're aiwata za'ra mono zô hã. Taré aima romhuri'wai wa, wa tô wa te ãma aima 're uwaimrami za'ra, asimiwada'uri hã.” Ãne te za 're ĩnharĩ za'ra wa'aba mo. — Ãne, Zezusi ma tô tãma waihu'u za'ra, tisiré 're ĩnomro mono norĩ ma. ");
INSERT INTO xavNT_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Tawamhã Zezusi norĩ hã te oto ai'aba'ré, Zeruzarẽ u. Darireza hã Samariza me 're ĩsiwaptob zahuré mono wa'wai baba, te ai'aba'ré, bâdâdi na. ");
INSERT INTO xavNT_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","'Ri wa'õtõ u sihutu õ ré, ma tô aibâ norĩ me si'uzusi za'ra. Aibâ norĩ hã ĩ'wa're ré hã, 10 na ĩhâiba za'ra hã. Romhâ prã na ma tô tãma 'mazahâri za'ra. ");
INSERT INTO xavNT_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","Tame ma tô sina 'mahârâ za'ra, ãne: — Zezusi, rowahutu'wa, wa'ãma aipẽ'ẽzé za'ra na, wapese za'ra da. — Ãne te sina 'mahârâ za'ra. ");
INSERT INTO xavNT_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Taha wa, te Zezusi hã tãma nharĩ za'ra, ãne: — Õwa te za ai'aba'réi wa'wa, sasedoti norĩ u, 'Re ĩhâimana u'âsi mono ma, da'ãma romhuri'wa norĩ u, te te aiwaihu'u za'ra wa'aba da, aséptâ'â za'ra wa'aba zém na hã. — Ãne te tãma nharĩ za'ra. Taha wa, te ai'aba'ré, ĩ'wa're ré norĩ hã. Bâdâdi na si'aba'réi ré, ma tô tizéptâ'â za'ra. ");
INSERT INTO xavNT_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Tawamhã ma tô misi apâ mo Zezusihi u, tihâiba hã te te 'madâ'â wa. Ta hã samaritanu. 'Re ĩhâimana u'âsi mono ãma wata sina, te apâ mo, mreme 'rãihâ sina. ");
INSERT INTO xavNT_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Zezusihi u wisi wamhã, ĩsahâpâ ma aime, hi'rãtitõ. Te te ĩpesezém na te ãma tiwata, aibâ hã. ");
INSERT INTO xavNT_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Taha wa, te Zezusi hã tinha, ãne: — Aibâ hã 10 na ĩhâiba za'ra hã, wa tô pese za'ra. E mahãta aibâ norĩ hã, 9 na ĩhâiba za'ra hã. ");
INSERT INTO xavNT_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Wasiré zudezu'õ nherẽ, e niha te we ãhã si mo apâ siwaprosi. 'Re ĩhâimana u'âsi mono ãma wata da, ĩsimipese waihu'u pese na. ");
INSERT INTO xavNT_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Tawamhã Zezusi hã te aibâ ma tinha, ãne: — Hâiwi asa na, asõrõwa u aimorĩ da oto. A hã ma tô ĩ̱zaze, te aipesezém na. Taha wa, ma tô aséptâ, ĩ̱zazei wa. — Ãne ma tô aibâ ma waihu'u, Zezusi hã. ");
INSERT INTO xavNT_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Tawamhã parisezu norĩ hã ma tô Zezusi hã siwi sadanha, ãne: — E niwa te za bâdâ hã ĩwa waptãrã, 'Re ĩhâimana u'âsi mono, da'ãma 're ĩsib'a'uwẽ mono zéb da hã. — Ãne te siwi 'mazadanha. Taha wa, Zezusi te asa tãma nharĩ za'ra, ãne: — 'Re ĩhâimana u'âsi mono, da'ãma 're sib'a'uwẽ mono wapsi, marĩ hã datõmo na a'â, da te 're 'madâ'â za'ra mono õ di za. ");
INSERT INTO xavNT_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Taha wa, ãne da te 're romnhoré za'ra mono õ di za: “Ãhãta, da'ãma 're ĩsib'a'uwẽ mono zé hã. Õhõta, da'ãma 're ĩsib'a'uwẽ mono zé hã.” Ãne, da te 're romnhoré za'ra mono õ di za. E marĩ wa. Dapẽ'ẽ 're, 're hâimana mono wa, da'ãma 're ĩsib'a'uwẽ mono zé hã. — Ãne, Zezusi ma tô tãma rowasu'u za'ra, parisezu norĩ ma. ");
INSERT INTO xavNT_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Tawamhã te tãma nharĩ za'ra, tisiré 're ĩnomro mono norĩ ma, ãne: — Niwapsi te za asima ĩwẽ za'ra wa'wa, bâdâ ĩwa waptã'ã da, ti'ai ãma dasiré ĩpodo hã te te dama 're ĩroti mono zé hã. Ãté ãne te za asima ĩnharĩ za'ra wa'wa: “Misi bâtâ na nherẽ, Wanhib'apito na, wa te wasina waihu'u za'ra neza.” Ãne te za asima ĩnharĩ za'ra wa'wa. Tawamhã a'â asina waihu'u za'ra wa'aba õ di za. ");
INSERT INTO xavNT_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Ĩ̱zadawa para õ nherẽ, te za ni'wam norĩ hã te te aima 're romnhoré za'ra wa'wa, taré: “Ãhãta ti'ai ãma dasiré ĩpodo hã te nhamra. Õhõta, te nhamra.” Ãne te za te te aima 're romnhoré za'ra wa'wa, taré. Ãne wamhã, danhimirowasu'u zarina, ĩ̱zô 're rob'madâ'â za'ra wa'aba mono õ di za. ");
INSERT INTO xavNT_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Tã si'ubuzi, te te 're rowa'a mono wamhã, dama rob'madâ'â pibu pese di, hâiwa mono bâ hã. Tane, ti'ai ãma dasiré ĩ̱podo hã apâ wei ĩ̱morĩ wamhã, aihĩni te za ĩ̱'madâ'â za'ra ni. ");
INSERT INTO xavNT_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Tazahã, wa za a'â robzépata za'ẽtẽ, ã nimosi dapoto tém norĩ hã te te siwi ĩ̱wẽ'õ za'ra wa. ");
INSERT INTO xavNT_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Tawamhã ĩ̱zô 're ĩdanhimipari za'ra mono õ zém na, wa za wei mo apâ. Apâ we ĩ̱morĩzéb u hã Nowé 're hâimana mono ré, 're ĩdahâimana za'ra mono ne, te za 're dahâimana za'ra za. ");
INSERT INTO xavNT_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Ta norĩ hã daré âpusi mono õ ré hã, ma tô simiza'rese ãna tisa te te 're huri, rowẽ na 're nomro u'âsi mono da newa. Simiza'rese ãna te duré te te 're âhuri. Rowẽ na te duré sina 're mro za'ra. Ãne, 're ĩdahâimana za'ra mono zé hã, Nowé hã 'ri ne 'manharĩ 're, sébré õ ré. Sébré parip si, ma tô oto tã hã we tita'a. Ti'ai hawib zama, ma â pu'u. Taha wa, ma uburé â na dasi'utõrĩ. ");
INSERT INTO xavNT_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Duré, Ro hã 're hâimana mono ré, 're ĩdahâimana za'ra mono zém ne, te za 're dahâimana za'ra, apâ we ĩ̱morĩzéb u hã. Ta norĩ hã ma tô 're saihuri. Ma tô duré te te 're âhuri. Marĩ hã ma tô da te dasiwi 're uipra za'ra duré. Ma tô da te dasima 're rowede za'ra. Daburu ãma, ma tô da te 're robzuri. Ma tô duré da te dasima 're 'ri za'ra. Ãne, 're ĩdahâimana za'ra mono zé hã. ");
INSERT INTO xavNT_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Tawamhã bâtâ na, Sodoma hawi Roho watobrozém na hã ma tô dasi'utõrĩ. Tã we ĩta'a ne, ma we uzâ hã asa'wa ti'ai u, ẽtẽ ro'o nhizédé uzé pire zama. Taha wa, ma uburé dasi'utõrĩ. ");
INSERT INTO xavNT_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Tane, ti'ai ãma dasiré ĩ̱podo hã apâ we ĩ̱morĩzéb u hã te za 're dahâimana za'ra. Ĩ̱zô 're danhimipari za'ra mono õ di za. ");
INSERT INTO xavNT_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Apâ we ĩ̱morĩ õ ré, ãté te za ni'wam norĩ hã ai'ubumro, 'ri nhisi hâpâ na. Tawamhã, apâ we ĩ̱morĩ wamhã, tinhibrob zô te te si'ra za'ra õ di za. Mare di. Awa'awi te za tinhorõwa hawi ai'aba'ré, tinhibrob zô sisisi ãna. Duré tiburu hawi, apâ 'ri tẽme si'aba'réi õ di za. Mare di. Õne haré te za duré ta norĩ hã ẽtẽ 'rãihâ u dame sisa're. ");
INSERT INTO xavNT_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Ma'ãpé Roho mro wasu'u na 're rosa'rata u'âsi za'ra wa'aba mono, ĩsine 're anomro aba mono tõ da. ");
INSERT INTO xavNT_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Ni'wam norĩ hã si'uihâ na tihâimanazép si te te sima 're sawi za'ra mono wamhã, rowẽ ĩsi'utõrĩ'õ hã te te sina 're uwaimrami za'ra mono õ di za. Ni'wam norĩ hã ĩ̱zarina 're nomro mono da, 're sihâiba zawi za'ra mono õ wapsi, te za te te sina 're uwaimrami za'ra, rowẽ hã. ");
INSERT INTO xavNT_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Taha barana te za ni'wam norĩ hã siré tinhotõ zahuré, ãté. Siré sõtõ zahuré ré, ĩhâiba amo hã te za 'Re ĩhâimana u'âsi mono hã ti'â, hâiwa u. Ĩhâiba amo si te za tirẽ. ");
INSERT INTO xavNT_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Ãté, pi'õ norĩ hã te za siré ti'ru'u zahuré. Siré 'ru'u zahuré ré, te za ti'â, ĩhâiba amo hã. Ĩhâiba amo si te za tirẽ, 'Re ĩhâimana u'âsi mono hã. Tô sena, wa aima waihu'u za'ra wa'wa. ");
INSERT INTO xavNT_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Ãté, aibâ norĩ hã te za siré romhuri zahuré, buru ãma. Tawamhã ĩhâiba amo hã te za ti'â hâiwa u, 'Re ĩhâimana u'âsi mono hã. Ĩhâiba amo si te za duré tirẽ. — Ãne, ma tô Zezusi hã tãma waihu'u za'ra, tisiré 're ĩnomro mono norĩ ma. ");
INSERT INTO xavNT_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Tawamhã te sadanharĩ za'ra, ãne: — E mame te za ãne tiromhâiba. — Ãne te ãma sadanharĩ za'ra. Taha wa, te Zezusi hã asa tãma ãma romnhimiré'é za'ra, ãne: — Sipahudu hã marĩ dâ'â u 're si'rã'õtõ mono wamhã, dama pibui pese di, marĩ hã 're dâ'â za'ra mono wa, 're ĩsimi'wara mono zé hã. — Ãne ma tô tãma rowasu'u za'ra. ");
INSERT INTO xavNT_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Tawamhã Zezusi hã ma tô tãma ãma romnhimiré'é za'ra, tisiré 're ĩnomro mono norĩ ma, wa'a ãna 'Re ĩhâimana u'âsi mono wi, te te 're rowaptẽrẽ u'âsi za'ra mono da, te te 're pawaptob u'âsi za'ra mono da. Ãne te ãma simiré'é: ");
INSERT INTO xavNT_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","— Aibâ hã te 're hâimana, 'ri nho'õmo ãma, dama rowairébé'wa hã. 'Re ĩhâimana u'âsi mono nhimiroti 'madâ'â'õ'wa ta hã, duré danhimiroti na zama ĩsimiwazéb õ. ");
INSERT INTO xavNT_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Tame ma tô pi'õi mrotõ hã 're sãmra. Te ĩtẽme 're neb u'âsi, te te tãma 're rowairébé mono da ne. Ãne te te tiwi 're rowaptẽrẽ: “Ĩ̱'ãma aime na. Ma'ãpé ĩ̱zawi'õ'wai ma roti na, te te ĩ̱ma 'manharĩ wasété tõ da.” Ãne te nasi tãma tinha. ");
INSERT INTO xavNT_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","5","— Tane nherẽ, duréi nherẽ, te te pawaptob õ di. Tawamhã ĩtẽme 're neb u'âsi mono wa, te oto 'râwi sima tinha, dama rowairébé'wa hã: “Wa hã 'Re ĩhâimana u'âsi mono nhimiroti, te 'madâ'â õ nherẽ, duré danhimiroti na ĩ̱nhimiwazéb õ nherẽ, te te sina ĩ̱wa'a wa, wa za oto tãma rowairébé, marĩ te te sima ĩwẽ na. Te tãma rowairébé õ wamhã, ĩ̱tẽme 're neb u'âsi mono wamhã, te za te te 're ĩ̱wasutu u'âsi, timreme na. Ãne õ'umnhasite, wa za oto pawapto.” Ãne te sima tinha, tipẽ'ẽ na. — Ãne te Zezusi tãma rowasu'u za'ra, tisiré 're ĩnomro mono norĩ ma. ");
INSERT INTO xavNT_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Te duré tãma nharĩ za'ra, Wanhib'apito hã ãne: — Ma'ãpé, ãma rosa'rata za'ra wa'aba, dama rowairébé'wa, te te sina ĩrotizém na hã. ");
INSERT INTO xavNT_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Wẽ prã zahã, te za, u, ĩmrotõ hã pawapto. E bété tinhib'a'uwẽ hã te te 're pawaptob za'ra mono õ di za, 'Re ĩhâimana u'âsi mono hã. Ãté rowa'a na, ãté barana te za sô 're hãsi, te te 're pawaptob za'ra mono da. E bété te te 're pawaptop su'u za'ra mono õ di za. ");
INSERT INTO xavNT_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Mare di. Te te sima 're ĩwẽ za'ra mono zarina, te za tô te te 're pawaptob za'ra. Te za te te 're pawaptop su'u za'ra. Te te 're pawaptob za'ra mono nherẽ, e niha za, ti'ai ãma dasiré ĩ̱podo hã, apâ we ĩ̱morĩ wapsi. E te za da te 're ĩ̱zaze za'ra. E ti'ai ãma te za dama tihâiba, da te dasina 're ĩ̱'umnhasi za'ra mono zé hã. — Ãne te Zezusi hã ãma sadanharĩ za'ra, tisiré 're ĩnomro mono norĩ hã. ");
INSERT INTO xavNT_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Tawamhã Zezusi hã te za duré dama ãma romnhimiré'é, ni'wam norĩ udâna. Ta norĩ hã 're hâimana wẽ za'ra mono newa, ma tô 'râwi sina 're wata za'ra. Tihâiba amo norĩ hã te duré te te siwi 're wẽ'õ za'ra, wasété za'ra newa. Taha wa, ma tô tãma ãma simiré'é za'ra, ãne: ");
INSERT INTO xavNT_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","— Aibâ norĩ hã ma tô tizasi zahuré, 'Re ĩhâimana u'âsi mono ãma 're ĩdawata za'ra mono zéb u, tãma mreme zahuré da. Aibâ norĩ hã, parisezu, duré danhib'apito ma, rob'uiprazéb ubumroi'wa. ");
INSERT INTO xavNT_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Zasi wamhã, hâiwi te oto za, parisezu hã, rob'uiprazéb ubumroi'wa nhiti. Ãne ma tô mre: “'Re ĩhâimana u'âsi mono, ãhãna, wa za ai'ãma ĩ̱wata. E marĩ wa. Wa hã ĩ̱siré aibâ norĩ ne, ĩ̱wasété na 're ĩ̱morĩ õ di. Danhibrob zô, te 're rob'ruiwapari mono õ di. Wa hã rob'uiprazém na, dawi 're ĩ̱nhipsaihuri mono õ di. Duré pi'õ na zama, dawi 're ĩ̱nhipsaihuri mono õ di. Taha wa, wa za duré ai'ãma ĩ̱wata, õhõ ne, rob'uiprazéb ubumroi'wa ne, 're ĩ̱morĩ õ wa. ");
INSERT INTO xavNT_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Maparane bâtâ na romhuri sidâpâsi, wa ĩ̱sai ãna 're ĩ̱nhamra, te aima 're romhuri mono da, ĩ̱mreme na. Ĩ̱pawa'â hã wa duré te aima 're po'o, syry na.” Ãne ma tô parisezu hã tiwẽ hã sina tihi, 'Re ĩhâimana u'âsi mono ma. ");
INSERT INTO xavNT_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","— Tanei õ di, rob'uiprazéb ubumroi'wa hã. Hâiwi te za, romhâ na. Te ti'rã po. 'Râwi siwẽ'õ wa, 'rãi wahutu õ di. Ãne te tãma siwasu'u: “'Re ĩhâimana u'âsi mono, wa hã ĩ̱wasété di. Ĩ̱wasété wa, ĩ̱'ãma aipẽ'ẽzé na, ĩ̱wasédé hã ĩ̱ma pari da.” Ãne te tãma siwasu'u, tiwasété na. ");
INSERT INTO xavNT_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Taha wa, ma tô Zezusi hã dama tinha, ãne: — Tô sena, wa aima waihu'u za'ra wa'wa. Rob'uiprazéb ubumroi'wa si, rowẽ na te apâ mo tinhorõwa u, parisezu upana. E marĩ wa. 'Re ĩhâimana u'âsi mono te te wẽsãmri wa, tãma ĩsiwasu'uzém na, duré wasété nherẽ, marĩ te te 're ĩ'manharĩ wasété mono na, te te 're 'madâ'â mono õ wab zama. Ni'wam norĩ hã danhipai u wẽ newa, tiwẽ na sina 're wata za'ra mono wamhã, 'Re ĩhâimana u'âsi mono, te za tãma pisutu za'ra, wapu na dama 're hâimana za'ra mono da. Duré ni'wam norĩ hã tiwẽ na sina 're wata za'ra mono õ wamhã, 'Re ĩhâimana u'âsi mono, te za tãma pisutu za'ra, pire na dama 're hâimana za'ra mono da. — Ãne Zezusi ma tô dama waihu'u. ");
INSERT INTO xavNT_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Taha pari, ma duré ni'wam norĩ hã ai'uté hã ãwisi za'ra, Zezusihi u, ai'uté ãma mreme da, ĩwẽ hã te te tãma 're anhomri mono da, ai'uté ma. Tawamhã ĩsiré 're ĩnomro mono norĩ hã te te da'madâ'â za'ra wamhã, ma tô tãma nharĩ za'ra. ");
INSERT INTO xavNT_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Tawamhã ma tô Zezusi hã ai'uté norĩ zô hâ, ĩtẽme si'aba'ré da. Te duré tisiré 're ĩnomro mono norĩ ma tinha, ãne: — Tô'ã. Dawi rosawi za'ra wa'aba õ di za. A'â we ĩ̱tẽme da te simroi mono, ai'uté norĩ hã. Ã ai'uté norĩ hã õne haré simizazei pese na 're ĩhâimana za'ra mono ne, tane ni'wam norĩ hã 're hâimana za'ra mono wapsi, te za 'Re ĩhâimana u'âsi mono hã ãma 're sib'a'uwẽ za'ra, ta norĩ ãma hã. ");
INSERT INTO xavNT_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Tô sena, wa aima waihu'u za'ra wa'wa. Ni'wam norĩ hã ai'uté hã simizazei pese na 're ĩhâimana za'ra mono ne, 'Re ĩhâimana u'âsi mono ãma 're si'apito za'ra mono da, te te sina 're saze za'ra mono õ wamhã, ãma 're sib'a'uwẽ za'ra mono õ di za. — Ãne ma tô Zezusi hã tãma waihu'u za'ra. ");
INSERT INTO xavNT_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Tawamhã roti'wa hã te Zezusi sadanha, zudezu hã: — Rowahutu'wa, aiwẽ di. E marĩ ĩwẽ hã wa za 'manha, 're ĩdanomro u'âsi mono zé hã te ĩ̱sina ĩ'uwaimrami da hã. — Ãne te Zezusi sadanha. ");
INSERT INTO xavNT_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Taha wa, te Zezusi hã asa tãma tinha: — E niha te ĩ̱'ãma aiwa, ĩ̱wẽ na. 'Re ĩhâimana u'âsi mono si, ĩwẽ uptabi hã, õhõ si. ");
INSERT INTO xavNT_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Aima waihu'u pese di, 'Re ĩhâimana u'âsi mono nhimiroti hã. Ãne, dama ĩsimiroti hã: “Aimro na asiwi 're asipsaihuri za'ra wa'aba mono õ di za. Duré, 're danhimroi wa'aba mono õ di za. Duré, danhibrom na dawi 're asipsaihuri za'ra wa'aba mono õ di za. Duré, dahâiba na dama 're asadawa nhipese za'ra wa'aba mono õ di za. Duré aimama hã te za 're ĩwazé pese mo, ana zama.” — Ãne ma tô Zezusi hã tãma rob'rãzarõtõ, 'Re ĩhâimana u'âsi mono nhimiroti na hã. ");
INSERT INTO xavNT_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Tawamhã aibâ hã te duré asa tãma tinha, ãne: — Ĩ̱prédu wi, wa tô te 're wapari pese, ĩsimiroti hã. Õne u'âsi. Te 'madâ'â nhimini õ di. — Ãne te Zezusihi ma sihâimanazéb 'rãzarõtõ, roti'wa hã. ");
INSERT INTO xavNT_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Ĩsihâimanazéb 'rãzarõno hã te te wapari wamhã, te asa tãma tinha, Zezusi hã: — Tane nherẽ, misi te zahadu aihâimanazéb zô aiwi rowaptâ. Ma'ãpé, uburé asibro hã dama wede mono, ĩwa'âbâ zô, ĩsibrob'õ norĩ ma, sõmri mono da. Tawapsi, asibro pese di za, hâiwa ãma hã. Asibro hã dama wede mono parip si, te za apâ we ĩ̱tẽme aimo, ĩ̱siré 're aimorĩ da oto. — Ãne te roti'wai ma tinha, Zezusi hã. ");
INSERT INTO xavNT_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Ãne aibâ ma, te te roti wamhã, sibrob ahâ uptabi wa, ma tô tiwi tirobzei'õ, tinhibrob zawi te. ");
INSERT INTO xavNT_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Tawamhã Zezusi hã tiwi ĩrobzei'õ na ma tô waihu'u. Taha wa, te ãma simiré'é, ãne: — Ĩsibro pese norĩ hã 'Re ĩhâimana u'âsi mono, da'ãma 're ĩsib'a'uwẽ mono zéb u 're ĩsisisi mono da hã, pire di. Tãma pire uptabi za'ra di za. ");
INSERT INTO xavNT_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","E niha te za awaru ba'õmore hã ĩsi'uwazi para'õtõ zapu'u 're ãzé. Sébré waihu'u õ di. Tane, ĩsibro pese norĩ hã si'uihâ na 're sisisi waihu'u mono õ di za, 'Re ĩhâimana u'âsi mono, da'ãma 're ĩsib'a'uwẽ mono zéb u hã. — Ãne ma tô tãma waihu'u za'ra, Zezusi hã. ");
INSERT INTO xavNT_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Taha wa, te ĩwapari'wa norĩ hã sadanharĩ za'ra, ãne: — Ĩsibro pese norĩ ma, waihu'u za'ra õ wamhã, e 'wam norĩ hã te za bété danho'reptuzé hã te te sina 're uwaimrami za'ra, dadâ'â ãna 're ĩdanomro u'âsi mono zé hã. Ãté ni'wai õ di. — Ãne te siwi sadanha. ");
INSERT INTO xavNT_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Tawamhã Zezusi hã ma tô asa tãma nharĩ za'ra: — Dasi'uihâ na danho'reptuzé hã da te dasina 're uwaimrami za'ra mono õ di za. Dama waihu'u õ di. 'Re ĩhâimana u'âsi mono si siminho'reptu waihu'u pese di. — Ãne ma tô Zezusi hã tãma waihu'u za'ra. ");
INSERT INTO xavNT_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Tawamhã Pedru hã te sadanha: — Wa norĩ hã wa tô wanhorõwa hã wasipara rẽme za'ra ni, asiré 're wanomro mono da oto. — Ãne te Zezusihi ma tinha. ");
INSERT INTO xavNT_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Taha wa, te asa tãma tinha, Zezusi hã: — Tane tô. Tô sena wa za aima waihu'u za'ra wa'wa. Ãté, ni'wam norĩ hã te za tinhorõwa hã rẽme za'ra, 'Re ĩhâimana u'âsi mono, da'ãma 're ĩsib'a'uwẽ mono zé, te te dama 're wasu'u za'ra mono da. Ãté timro hã te za a'â te te 're rẽme za'ra, ãté, tisisãnawã norĩ hã, ãté timama hã, ãté tina hã, ãté ti'ra norĩ hã. ");
INSERT INTO xavNT_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","Tawamhã ti'ab ré, te za tô marĩ hã te te tãma 're anhomri za'ẽtẽ, ĩwa'rãmimhã, 'Re ĩhâimana u'âsi mono hã. Te za tô duré tãma pisutu za'ra, niwa, rowẽ hã te te sina 're ĩ'uwaimrami za'ra mono zéb da hã, hâiwa ãma. — Ãne ma tô tãma waihu'u za'ra, Zezusi hã. ");
INSERT INTO xavNT_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Tawamhã Zezusi hã hâiba pisutu ma tô sani za'ra, tisiré 're ĩnomro mono norĩ hã, aibâ 12 na ĩhâiba za'ra hã. Ãne te tãma nharĩ za'ra: — Ĩ̱wapari pese za'ra wa'aba. Ãhãna, wa Zeruzarẽ u ai'aba'ré ni. Tame te za marĩ hã ĩ̱zô watobro. 'Re ĩhâimana u'âsi mono zadawa wasu'u'wa norĩ hã, dasiré ĩ̱poto ãma, te te ĩ̱'ãma ĩrob'ui'éré za'ra zéb zarina, te za marĩ hã ĩ̱zô watobro. ");
INSERT INTO xavNT_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Te za, u, dasiwi ĩ̱'âri ni, zudezu'õ norĩ ma, da te dasiwi ĩ̱hâiba nhomri da. Te za, u, ĩ̱'ãma tawa'ẽ za'ra ni, zudezu'õ norĩ hã. Te za, u, ĩ̱'ãma wasété za'ra. Tizadaipro na te za, u, nasi siwi ĩ̱'uptob za'ra. ");
INSERT INTO xavNT_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Te za, u, da te dasiwi 're ĩ̱pré'é. Taha pari, te za, u, dasiwi ĩ̱wĩrĩ ni. Tane nherẽ, bâdâ maparane ĩ̱'ãma si'utõrĩ õ ré, wa za, u, apâ hâiwa'udu. — Ãne ma tô sina tãma rob'rãzarõtõ za'ra, tisiré 're ĩnomro mono norĩ ma. ");
INSERT INTO xavNT_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Tazahã, tãma pibu prã za'ra di, te te tãma sina ĩrob'rãzarõtõ za'ra zé hã. Tãma waihu'u za'ra õ di, te te tãma ĩwaihu'u za'ra zé hã. ");
INSERT INTO xavNT_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Tawamhã Zezusi norĩ hã ma tô rob'umhutu za'ra oto, Zerico na 'ri nho'õmo nhisi u. Tame te aibâ hã ĩtob'a hã nhamra, bâdâdi zababa te te 're ĩda'awari mono hã. ");
INSERT INTO xavNT_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Aibâ hã ma tô da'awapa, da'ahâ na da te ĩro'rahâri za'ra hã. Taha wa, te anha: — E niha bâ. ");
INSERT INTO xavNT_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Taha wa, te asa tãma rowasu'u za'ra ni: — Zezusi, Nazaré hawi we ĩmorĩ, ma ro'razâ. — Ãne te tãma rowasu'u za'ra ni. ");
INSERT INTO xavNT_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Tawamhã te ĩtob'a hã nasi 'mahâ: — Zezusi, Dawihi nhihudu, ma'ãpé ĩ̱'ãma aipẽ'ẽzé na. — Ãne te nasi 'mahâ. ");
INSERT INTO xavNT_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Tawamhã danhowa ĩsi'aba'ré, te tãma nharĩ za'ra, ari'iwi sãmra da. Tazahã, te te wapari za'ra õ di. Taha wa, te nasi 'mahâ: — Dawihi nhihudu, ĩ̱'ãma aipẽ'ẽzé na. — Ãne te nasi 'mahâ. ");
INSERT INTO xavNT_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Taha wa, ma tô Zezusi hã mazazâ. Te dama ti'ru, ĩtob'a hã da te saprõni da, ĩtẽme. Ĩtẽme da te saprõni wamhã, Zezusi te sadanha: ");
INSERT INTO xavNT_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","— E marĩ te asima ĩ̱wẽ, te ãma aima ĩ'uwaimrami da hã. — Ãne te Zezusi sadanha. — Apito, ĩ̱to pese da, wa ĩ̱sima aiwẽ, apâ te 're rob'madâ'â mono da. — Ãne te asa tãma tinha, ĩtob'a hã. ");
INSERT INTO xavNT_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Tawamhã te Zezusi hã tãma tinha: — Rob'madâ'â. Asina ĩ̱'umnhasi wa, ma ato pe. — Ãne te Zezusi tãma tinha. ");
INSERT INTO xavNT_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Tawamhã awa'awi ma tô rob'madâ'â wẽ, aibâ hã. Zezusihi siré te oto mo, 'Re ĩhâimana u'âsi mono ãma, wata sina. Uburé, ãma ĩ'madâ'â'wa norĩ zama, te 'Re ĩhâimana u'âsi mono ãma tiwata za'ra. Ãne Zezusi, ĩtob'a te te ĩto pesezé wasu'u hã. ");
INSERT INTO xavNT_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Tawamhã Zezusi hã Zerico u, ma tô wi. Wisi wamhã, 'ri nho'õmo wa'wai baba, ma ro'razâ. ");
INSERT INTO xavNT_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Zerico ãma, te aibâ hã 're hâimana, ĩsibro pe hã, Zateu na ĩsisi hã. Danhib'apito ma, rob'uiprazéb ubumroi'wa norĩ 'madâ'â'wa, Zateu hã. ");
INSERT INTO xavNT_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Ta hã ma tô sima wẽ, Zezusi hã te te sabu da, te te hâiba pibu da. Tane nherẽ, da'ahâ uptabi wamhã, te te 'madâ'â waihu'u õ di Zezusi hã, sapore wa, Zateu hã. ");
INSERT INTO xavNT_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Taha wa, ma tô danho'a wara, wede u, te te sai'uri da, sipapara te te 'madâ'â da, ĩwa'wai baba za wei morĩ wa, Zezusi hã. ");
INSERT INTO xavNT_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Tawamhã Zezusi hã wede u oto wisi wamhã, hâimo te rob'madâ. Taha wa, te 'mahâ Zateu hã, ãne: — Zateu, ai'aba'ré na si'ra na. Ã bâtâ na hã asõrõwa ãma ĩ̱hâimana hâ. ");
INSERT INTO xavNT_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Taha wa, ma si'aba'ré na si'ra. To sina, ma tô tãma tinha, ĩsõrõwa u ĩsiré morĩ da, ĩ'rata a'â sãmra da. ");
INSERT INTO xavNT_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Tawamhã ĩsõrõwa u sébré wamhã, te dasima nharĩ za'ra ni, Zezusihi za'u, ãne: — Zapre, ma bété ĩsõrõwa u ãzé, aibâ ĩwasété nhorõwa u. — Ãne te dasima nharĩ za'ra ni. ");
INSERT INTO xavNT_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Zateu hã hâiwi te oto za, Wanhib'apito ma, siwasu'u da. Tawamhã ãne te tãma tinha: — Ãhãta, ĩ̱nhibro hã wa za ãma aipo'o, ĩsibrob'õ norĩ ma, te sõmri mono da. Duré, dawi ĩ̱nhipsaihuri wamhã, wa za, te ĩsimi'uri nhowa're're, dama ãma 'rãnhipa, ĩwa'rãmi. Rob'uiprazé misi wamhã, wa za maparane si'uiwa na dama ãma 'rãnhipa. — Ãne te Zezusihi ma siwasu'u. ");
INSERT INTO xavNT_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","10","Taha wa, te Zezusi hã dama tinha: — Ãhãna hã rowẽ di oto, ĩsõrõwa ãma hã. Ã hã aibâ hã ma tô tinho'reptuzé hã sina waihu'u. Abra'ãhã nhihudu, te za tô oto 're mo. Taha da, wa tô we datẽme mo, te 're da'anho'reptui mono da, dawẽ na oto 're danomro mono da. Wa hã ti'ai ãma dasiré ĩ̱podo. — Ãne ma tô dama siwasu'u, Zezusi hã. ");
INSERT INTO xavNT_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Tawamhã ma tô wapari za'ra ni, Zezusihi mreme hã. Taha wa, te za duré tãma ãma romnhimiré'é za'ra. E marĩ wa. Zeruzarẽ u, ĩwisizéb u hã, romhuture di oto. Ãne wamhã, te dasina rosa'rata za'ra ni: — Ãté, bâdâ te za oto ĩwa waptãrã, 'Re ĩhâimana u'âsi mono, da'ãma 're ĩsib'a'uwẽ mono zéb da hã. — Ãne te dasina rosa'rata za'ra ni. ");
INSERT INTO xavNT_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Taha wa, te ãma simiré'é Zezusi hã, ãne: — Aibâ hã dama ĩpire hã darob amoi u ma tô mo, tinhib'apito hã te te sabu da. Ĩsib'apito hã te za pisutu, apito na dama 're hâimana mono da, ĩrob ãma. Taha da, te za mo, si'apito da. Taha parip si, te za wei mo apâ, tirob u. ");
INSERT INTO xavNT_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Taha wa, te morĩ õ ré, sitẽme sô tihârâ za'ra, tãma ĩromhuri'wa norĩ zô, 10 na ĩhâiba za'ra norĩ zô. Misi si, ma tô te te tãma sõmri, rob'uiprazé ĩsapotore hã. Ẽtẽ'ubuzi ĩpré 'manharĩ, ta hã, oru 'manharĩ. Tawamhã te ãne tãma 'ru za'ra: “Marĩ hã te za 're ĩ'manharĩ za'ra wa'aba mo, rob'uiprazém na ãma atob za'ra wa'aba da, apâ we ĩ̱morĩ õ ré.” Ãne te tãma 'ru za'ra. Taha pari, te oto tiwi timorĩ za'ra. ");
INSERT INTO xavNT_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","— Dama si'apito da nherẽ, ĩrob 're, 're ĩdahâimana za'ra mono hã te siwi 'ruiwapa, dama si'apito tõ da. Taha wa, te ĩsarina siwi da'mazatõ, ĩsib'apito ma, te te ãma dazadawa wasu'u za'ra da. ");
INSERT INTO xavNT_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","— Tane nherẽ, ma tô aibâ hã ĩsib'apito hã pisutu, dama si'apito da. Taha wa, ma tô wi apâ, tirob u. Wisi wi, ma tô sitẽme sô tihârâ za'ra, tãma ĩromhuri'wa norĩ zô hã, niha ãma sitob za'ra wamhã, te te waihu'u da. ");
INSERT INTO xavNT_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Tawamhã ĩtẽme ĩwisi 'rada hã te tãma tinha, ãne: “Apito, rob'uiprazé ĩsapotore hã ma tô ĩ̱ma ĩsõ, misi. 10 na ĩhâiba za'ra hã, wa tô ãma ato.” Ãne te tãma siwasu'u, ĩtẽme ĩwisi 'rada hã. ");
INSERT INTO xavNT_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","— Tawamhã ĩsib'apito te asa tãma tinha: “Wẽ di tô. A hã, romhuri wẽ 'wa. Marĩ hã 'rare nherẽ, ma tô ĩ̱ma 're ĩ'manharĩ wẽ u'âsi mo. Ĩ̱ma ai'umnhasi di. Taha wa, wa za oto aipisutu, 're da'ab'madâ'â mono da. 'Ri ahâ, wa za aima pisutu za'ra, 10 na 'ri ĩhâiba za'ra hã tame 're da'ab'madâ'â mono da.” — Ãne te tãma tinha. ");
INSERT INTO xavNT_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","— Tawamhã ĩsãna'remhã, ma we duré ĩtẽme wi. Ta hã te duré tinhib'apito ma tinha: “Apito, rob'uiprazé ĩsapotore hã ma tô ĩ̱ma ĩsõ. Ĩmrotõ na ĩhâiba za'ra hã, wa tô ãma ato.” Ãne te tãma wasu'u, tinhib'apito ma. ");
INSERT INTO xavNT_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","— Taha wa, te ĩsib'apito hã asa tãma tinha: “Tane tô. 'Ri ahâ hã ĩmrotõ na, wa za aima pisutu za'ra, tame 're da'ab'madâ'â mono da.” Ãne te tãma tinha. ");
INSERT INTO xavNT_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","— Tawamhã ĩsãna'remhã, ma we duré ĩtẽme wi. Tinhib'apito ma, te tinha: “Apito, ãhãta rob'uiprazé ate hã, ĩ̱ma ĩsõmri hã. Zazahâ na, wa tô ubu, te asô 'madâ'â pese da. ");
INSERT INTO xavNT_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","A hã, da'ãma aipẽ'ẽzé õ di. Date hã te dawi asima 're ĩ'apisutu mo, ate da. Duré asimirob're õ nherẽ, te za asima 're ĩrob'rãihâri mo, ate da, danho hã. Ãne na, wa tô aiwaihu'u. Taha wa, aipipa di.” Ãne te tãma tinha. ");
INSERT INTO xavNT_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","— Tawamhã ĩsib'apito te asa tãma tinha: “A hã ĩ̱ma romhuri wasété 'wa, te 're aimo. Aimreme wẽ õ wa, wa za aimreme hã aima sizusi, aimreme zarina te aiwẽ'õ da. Ĩ̱te na, ma tô u, ĩ̱waihu, da'ãma ĩ̱pẽ'ẽzé õ na. Wa hã wa za date hã te ĩ̱sima 're apisutu, u, ĩ̱te da. Duré wa za, u, te ĩ̱sima 're a'rãihâri, ĩ̱te da, danho hã. Ãne ma tô ĩ̱ma ĩnha. ");
INSERT INTO xavNT_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Ãne na 're ĩ̱hâimana mono wamhã, e marĩ wa bété rob'uiprazé hã ĩ̱zô sẽrẽ õ di, wedehâpâ 're. Ãne we apâ ĩ̱morĩ wapsi, te aima ĩsõmri nhipai u, wa aré ĩ̱sima waze, ĩ̱zô sina hâ'â wa.” Ãne te romhuri'wai ma tinha. ");
INSERT INTO xavNT_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","— Taha wa, te ĩ'rata ĩsimasam norĩ ma ti'ru: “Ma'ãpé, tiwi âri aba rob'uiprazé hã, 10 na te te ĩhâiba ma, sõmri aba da.” Ãne te ti'ru, ĩsib'apito hã. ");
INSERT INTO xavNT_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","— Tawamhã asa te tãma nharĩ za'ra: “Oro õhõ te hã, 10 na ĩhâiba za.” Ãne te tãma nharĩ za'ra, tinhib'apito ma. ");
INSERT INTO xavNT_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","— Asa te duré tãma nharĩ za'ra: “Tô sena wa aima waihu'u za'ra wa'wa. Ni'wam norĩ hã marĩ ahâ nherẽ, simi'ẽ na te te 're romhuri za'ra mono wamhã, te za ãma tãma 're dasito, marĩ na. Tane nherẽ, ni'wam norĩ hã marĩ na syryre nherẽ, simi'ẽ na te te ãma 're romhuri za'ra mono õ wamhã, te za syryre nherẽ, tiwi sani za'ra ni. ");
INSERT INTO xavNT_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Oto ĩ̱'rui'wa norĩ hã we ĩ̱tẽme ãwisi za'ra wa'aba. Ma tô siwi ĩ̱wẽ'õ za'ra, tãma ĩ̱si'apito za'ra tõ da. Taha wa, te za ĩ̱nho'a asiwi ĩsimroi wa'wa.” Ãne ma tô ĩsib'apito tãma 'ru za'ra. — Ãne te dama ãma romnhimiré'é, Zezusi hã. ");
INSERT INTO xavNT_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Tawamhã te te dama rowasu'u pari, te oto danhowa mo, Zeruzarẽ u, Zezusi hã. ");
INSERT INTO xavNT_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","30","'Ri wa'õtõ u, ma tô rob'umhutu oto, Betazé u hã, duré Betãnha u hã. Oriwera na ẽtẽ 'rãihâ nhisi 'rata, 'ri wa'õno hã. Tisiré 're ĩnomro mono norĩ hã ma tô sisõwa satõrĩ zahuré, maparane. Ãne te tãma rob'ru zahuré, Zezusi hã: — Õwa te za datẽme ane wa'wa, 'ri wa'õtõ u, asõ're uwaibaba wa'aba. Aimasisi aba wi, te za awaru po'repore ĩsãmri 'wa, ĩprédupté hã, zahadu ni'wa ãma ĩmorĩ'õ hã. Butu wazi na te za, da te ãma wasisi haré. Tawamhã te za ĩwasihui wa'wa, we saprõni aba da. ");
INSERT INTO xavNT_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Ni'wa hã ãne te te asadanharĩ aba wamhã: “E marĩ da, te ĩwasihui wa'wa,” tawamhã, ãne te za asa tãma ĩnharĩ 'wa: “Wanhib'apito hã ãma morĩ da, wa tãma wasihu ni.” Ãne te za asa tãma ĩnharĩ 'wa. — Ãne ma tô Zezusi hã tãma waihu'u zahuré. ");
INSERT INTO xavNT_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Tawamhã te oto tineb zahuré. Zezusi te te tãma ĩwasu'u zahuré zéb uwaibaba, ma tô sãmri zahuré, awaru po'repore hã. ");
INSERT INTO xavNT_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Te te wasihu zahuré wamhã, ĩtede'wa norĩ hã te sadanharĩ zahuré: — E marĩ da, te asapa'abâ ĩwasihui wa'wa ari'iwi. — Ãne te tãma nharĩ zahuré. ");
INSERT INTO xavNT_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Taha wa, te asa tãma nharĩ zahuré: — Wanhib'apito, marĩ õ wa, ãma morĩ da, wa tãma wasihu ni. — Ãne ma tô tãma waihu'u zahuré. ");
INSERT INTO xavNT_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Tawamhã te oto saprõni zahuré, awaru po'repore hã, Zezusihi ma. Te te tãma ãwisi zahuré wamhã, ma tô tisi'ubuzém na tãma ba'ubu zahuré. Tawamhã ma tô Zezusi pawaptob zahuré, ãma sarõtõ da. ");
INSERT INTO xavNT_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Ãma morĩ ré, ma tô dasi'ubuzém na bâdâdi hã da te waptâ za'ra. ");
INSERT INTO xavNT_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","38","Tawamhã ma tô rob'umhutu, Zeruzarẽ u hã. Oriwera na te za oto si'ra, Zeruzarẽ u wisi da. Tamomo, te da'ahâ na Zezusihi zarina ai'aba'ré ni, ĩsazei'wa norĩ hã. Ma tô te te ãma 're 'madâ'â za'ra aré, Zezusi te te 're ĩda'apawapto mono zém na, tiwaihu'u pese uptabi na. Taha wa, te oto damreme 'rãihâ na dasima nharĩ za'ra ni, ãne: — Uburé Danhib'apito te we oto mo, 'Re ĩhâimana u'âsi mono zadawa para. Tãma 're rowẽ za'ẽtẽ mono di za. Rowẽ hã hâiwa ãma 're ĩsa'wari u'âsi mono da si, wa wasima wẽ za'ra ni. — Ãne te dasima nharĩ za'ra ni. ");
INSERT INTO xavNT_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Taha wa, parisezu norĩ hã dawa'wa ĩsi'aba'ré hã, te Zezusihi ma nharĩ za'ra: — Rowahutu'wa, ma'ãpé asazei'wa norĩ hã sadawa uwati za'ra na, ari'iwi si'aba'ré da. — Ãne te tãma nharĩ za'ra. ");
INSERT INTO xavNT_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Tawamhã te Zezusi hã asa tãma nharĩ za'ra: — Tô sena wa aima waihu'u za'ra wa'wa. Ari'iwi si'aba'réi 'wa'âhã, te aré tô ẽne hã mreme 'rãihâ na, 'Re ĩhâimana u'âsi mono ãma tiwata za'ra. — Ãne ma tô tãma waihu'u za'ra, parisezu norĩ ma. ");
INSERT INTO xavNT_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Tawamhã Zezusi hã ma tô rob'umhutu oto, Zeruzarẽ u hã. 'Ri ahâ hã te te 'madâ'â wamhã, te aiwa'õ, ĩwa 're ĩdasi'ubumroi mono norĩ ãma hã. ");
INSERT INTO xavNT_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","Taha wa, te ãne tinha: — Ãhãna dama 're ĩrowẽ za'ra mono zé hã dama waihu'u za'ra 'wa'âhã, aré dama 're rowẽ za'ra mono di. Tane nherẽ, dama waihu'u za'ra õ di. Taha wa, da'ãma ĩ̱pẽ'ẽzé di. ");
INSERT INTO xavNT_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Niwapsi, te za danhitob'ru norĩ hã daré 'ri uirĩ za'ra. Ti'a za'wari na te za te te 're 'ri uirĩ za'ra, ĩmana wawi, 're dawairébé tõ mono da, nimomo. ");
INSERT INTO xavNT_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Danhitob'ru norĩ hã te za 'ri hã daré te te 're sãmra za'ra. 'Ri hã, tâibâ za oto. 'Ri tede'wa zama, te za uprosi za'ra. 'Ri tâibâ wamhã, ẽne hã te za oto re na 're simi'wara, 'rizé hã. 'Re ĩhâimana u'âsi mono, te aré danho'reptu za'ra. Tane nherẽ, danho'reptui'wa, datẽme ĩwisi na hã da te waihu'u za'ra õ di. — Ãne ma tô romhâ ré da'ãma rowa'õtõ siro, Zezusi hã. ");
INSERT INTO xavNT_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Tawamhã 'Re ĩhâimana u'âsi mono ãma 're ĩdawata za'ra mono zéb u, ma tô ãzé Zezusi hã, 'ri 'wawi wa'ra 're. Sébré wamhã, ma tô rowede'wa norĩ hã te te sate, rob u wairébé da. ");
INSERT INTO xavNT_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Ãne te tãma nharĩ za'ra: — Duréihã wahi'rada hã ma tô ãne na rob'ui'éré ĩbaihâ na hã, 'Re ĩhâimana u'âsi mono mreme na: “Ĩ̱nhorõwa hã ĩwa ĩ̱ma 're ĩdamreme zusi mono zém na, te za da te 're sisi za'ra, 'ri hã.” Ãne te tinha. Tane nherẽ, ma tô a norĩ wa'wa hã ĩwa asima 're ĩrob'manharĩ wasété za'ra wa'aba mo. Taha wa, danhibrom na dawi 're ĩsipsaihuri za'ra mono norĩ, 're ĩsi'ubumroi mono zém ne, te oto 'ri hã 're sa, wasété uptabi na. — Ãne te Zezusi hã tãma nharĩ za'ra. ");
INSERT INTO xavNT_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Tawamhã bâtâ sidâpâsi, te nasi dama rowasu'u Zezusi hã, 'ri 'wawi wa'ra 're. Ni'wam norĩ hã ma tô Zezusi hã sima 'ru za'ra, te te siwi wĩrĩ da. Ta norĩ hã 'Re ĩhâimana u'âsi mono ma, da'ãma romhuri'wa ĩpire norĩ hã, duré ĩsimiroti na rob'ui'éré 'rata na dama rowahutu'wa norĩ hã, duré roti'wa norĩ hã. ");
INSERT INTO xavNT_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Tane nherẽ, Zezusi te te siwi wĩrĩ da nherẽ, te te siwi wĩrĩ õ di. E marĩ wa. Te te 're ĩwapari za'ra mono norĩ hã ahâ wa, te te siwi wĩrĩ waihu'u õ di. ");
INSERT INTO xavNT_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Nimahã bâtâ na te Zezusi hã nhamra, 'Re ĩhâimana u'âsi mono ãma 're ĩdawata za'ra mono zéb ãma. 'Ri 'wawi wa'ra 're, te nhamra, te te dama rowahutu da, duré ĩwasu'uwẽ na te te da'apo're pu'u da. Tawamhã aibâ norĩ hã ma ĩtẽme aimasa. Ta norĩ hã sasedoti ĩpire norĩ hã, duré 'Re ĩhâimana u'âsi mono nhimiroti 'rata na rob'ui'éré na dama rowahutu'wa norĩ, duré zudezu norĩ ma roti'wa norĩ. ");
INSERT INTO xavNT_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Ĩtẽme simasa wamhã, te siwi sadanha: — E 'wa sadawa para, te bété ãne hã dama 're ĩ'ab'manharĩ mo. E 'wa hã, aipisutu'wa. Ma'ãpé wama asiwasu'u za'ra na, wa te waihu'u za'ra da. — Ãne te siwi sadanha. ");
INSERT INTO xavNT_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Taha wa, te Zezusi hã asa tãma nharĩ za'ra: — Wa hã wa za duré a'â asadanharĩ na ãma aima wa'rãmi za'ra wa'wa. ");
INSERT INTO xavNT_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","E 'wa sadawa para, ma tô Zuwã hã â dawabzuri hã te te dama 're ab'manharĩ. E 'Re ĩhâimana u'âsi mono zadawa para. E dazadawa parap si. Ma'ãpé, Zuwãhã ãma asimirosa'rada hã, ĩ̱ma waihu'u za'ra wa'aba. — Ãne te Zezusi hã tãma nharĩ za'ra. ");
INSERT INTO xavNT_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Taha wa, te 'râwi sima nharĩ za'ra, ãne: — E niha, wa za tãma waihu'u za'ra ni, õne wamhã. 'Re ĩhâimana u'âsi mono zadawa para, â dawabzuri te te dama 're ĩ'ab'manharĩ mono na, wa te tãma waihu'u za'ra wamhã, te za wazadanharĩ na sahu za'ra, ãne: “E niha bété, Zuwã Batitaha nhimirowasu'u hã saze za'ra wa'aba õ di, dame.” Ãté ãne, te za wama nharĩ za'ra. ");
INSERT INTO xavNT_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Ma tô da te 're saze za'ra Zuwã hã, 'Re ĩhâimana u'âsi mono zadawa wasu'u'wa 're ĩmorĩ na. Tawamhã dazadawa parap si, â dawabzuri te te dama 're ĩ'ab'manharĩ mono na, wa te tãma nharĩ za'ra wamhã, ãté te za ẽtẽ na dasiwi wa'uprosi ni. — Ãne te sima nharĩ za'ra, 'râwi. ");
INSERT INTO xavNT_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Tawamhã Zezusihi ma, te oto nharĩ za'ra: — Ni'wa sadawa para, ma tô Zuwã hã â dawabzuri hã te te dama 're ab'manharĩ. Wa norĩ hã wa te waihu'u za'ra õ di, ĩpisutu'wa hã. — Ãne te tãma nharĩ za'ra. ");
INSERT INTO xavNT_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Taha wa, te asa tãma nharĩ za'ra, Zezusi hã: — A norĩ wa'wa hã ĩ̱ma waihu'u za'ra wa'aba õ nherẽ, wa hã te duré aima waihu'u za'ra wa'aba õ di za, ni'wa sadawa para, te dama 're ĩ'ab'manharĩ mono na hã. — Ãne te Zezusi hã asa tãma nharĩ za'ra. ");
INSERT INTO xavNT_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Tawamhã Zezusi hã te duré dama romnhimiré'é, tinhimirowasu'u na, ãne: — Aibâ hã te 're hâimana, buru tede'wa hã. Tawamhã tiburu ãma ma tô a're, uwa 'ru hã. Taha wa, ma tô ni'wam norĩ hã sisõ'a ré pisutu za'ra, ĩburu hã te te sô 're 'madâ'â za'ra mono da. Uwa 'ru 'rã hã 're 'rãi prédub za'ra mono wapsi, te za ĩwa'rãmi te te tãma 're po'o za'ra, buru tede'wai ma hã. Taha pari, te oto mo, buru tede'wa hã darob amoi u, tamomo a'â hâimana da. Tame te a'â 're hâimana hâ. ");
INSERT INTO xavNT_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Tawamhã oto 'rãi prédu mono wa, ma tô buru tede'wa hã tãma ĩromhuri'wa hã 'mazatõ tiburu u, uwa 'ru 'rã hã buru 'madâ'â'wa norĩ te te tãma ĩpo'o za'ra zô. Tazahã, buru u wisi wamhã, ma tô romhuri'wa hã siwi azâ, buru 'madâ'â'wa norĩ hã. Taha wa, te ubana siwi satõ apâ, ĩsib'apito u. ");
INSERT INTO xavNT_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Ĩtẽme wisi wamhã, ĩwa'rãmimhã te duré sô 'mazatõ. Tazahã, buru u wisi wamhã, ma duré siwi azâ, buru 'madâ'â'wa norĩ hã. Ma tô tãma rob'manharĩ wasété za'ra. Taha wa, te duré ubana apâ siwi satõ, ĩsib'apito u. ");
INSERT INTO xavNT_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Ĩwa'rãmi ma tô duré sô 'mazatõ, buru tede'wa hã. Si'ubdatõ oto te te ĩsatõrĩ za'ra zé hã. Tazahã, buru u wisi wamhã, ma duré siwi azâ. Ma siwi u'a. Buru hawi, te duré siwi satõ apâ. ");
INSERT INTO xavNT_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Taha wa, te 'râwi sima tinha, buru tede'wa hã, ãne: “E marĩ, wa za 'manha. Ãté ĩ̱'ra hã wa za oto satõ, buru 'madâ'â'wa norĩ u hã, ĩ̱ma sawi pese nherẽ, ĩ̱'ra hã. Ĩ̱buru u te satõrĩ wamhã, ãté te za siwi hâiba wazé.” Ãne te 'râwi sima tinha, buru tede'wa hã. Tawamhã ti'ra si'aibâ hã te oto satõ, tiburu u. ");
INSERT INTO xavNT_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","— Tawamhã buru u oto morĩ wamhã, buru 'madâ'â'wa norĩ hã ma tô romhâ ré sima sãmri za'ra. Taha wa, te sima 'mahârâ za'ra, ãne: “Õhõta buru tede'wai 'ra hã te wei mo, timama uirĩ na buru tede'wa da hã. Oto wa te wasiwi wĩrĩ aba, buru hã wate za'ra da oto.” Ãne te sima 'ru za'ra. ");
INSERT INTO xavNT_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","— Tawamhã buru hawi ma siwi time. Ma tô siwi tĩwĩ. Ãne, buru 'madâ'â'wai 'ra wasu'u hã. — Ãne wamhã, e marĩ te za 'manha, buru tede'wa hã. ");
INSERT INTO xavNT_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Te za sô timorĩ za'ra, uburé te te uprosi da. Tawamhã te za duré aimawi da'maipisutu, tiburu 'madâ'â'wa da hã. — Ãne, Zezusi ma tô tãma rowasu'u za'ra. Tawamhã ĩsimirowasu'u hã da te wapari za'ra wamhã, te nharĩ za'ra ni, ãne: — Rowasédé hã watobro õ neza. — Ãne te nharĩ za'ra ni. ");
INSERT INTO xavNT_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Tawamhã Zezusi te da'ab'madâ'â pese. Te dama tinha, ãne: — Ẽtẽ wasu'u na rob'ui'éré hã, ãne: Ẽtẽ tomhâpâ wẽ hã 'ri na'ratazéb da hã, wẽ uptabi nherẽ, wasété newa, 'ri'wa norĩ te te aré siwi ĩwẽ'õ hã 'ri na'rata uparizéb da, te oto 're sa'wari u'âsi, pire na.” Ãne, ẽtẽ wasu'u na rob'ui'éré, ĩbaihâ na hã. ");
INSERT INTO xavNT_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Duré, ẽtẽ tomhâpâ nhisiwi, zé'a 'manharĩ hã 're rere'e mono wa, 're ĩsiprub za'ra mono ne, te za ĩ̱wẽ'õ'wa norĩ hã hâ za'ra, 'Re ĩhâimana u'âsi mono hã. Duré ẽtẽ tomhâbâ hã zé'a 'manharĩ nhisiwi, 're rere'e mono wa, te te 're ĩpru pese za'ra mono ne, te za ĩ̱wẽ'õ'wa norĩ hã hâ za'ra, sa'ẽtẽ uptabi na. Ta norĩ ãma hã 're sib'a'uwẽ za'ra mono õ di za. — Ãne te Zezusi hã sina ãma simiré'é. ");
INSERT INTO xavNT_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Buru 'madâ'â'wa norĩ wasu'u te te dama wasu'u wamhã, ma tô sina waihu'u za'ra, dama rowahutu'wa norĩ hã. Sasedoti norĩ hã sima ĩpire za'ra norĩ me, ma tô sina waihu'u za'ra. Taha 'ru te, te aré sima wẽ za'ra, te te siwi âri da, Zezusi hã, awa'awi. Tane nherẽ, dama pahi za'ra wa, ma tô siwi ãma rosazâ a'â. ");
INSERT INTO xavNT_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Taha wa, ma tô taré a'â ãma 're sõpré. Ãne te aibâ norĩ ma tãma ãma roti za'ra: — Zezusihi u te za ai'aba'réi wa'wa, marĩ na asiwi sadanharĩ za'ra wa'aba da, tô sena, marĩ asiwi waihu'u za'ra wa'aba dai õ nherẽ, ĩsimirowasu'u na hã. Tawapsi te za asiwi ĩsadanharĩ za'ra wa'wa, tinhimirowasu'u na te te ãma upa zô, te te ãma upai wa, wanhib'apito u, wa te wasiwi saprõni da, marĩ te te tãma 'manharĩ wasété da. — Ãne te aibâ norĩ ma roti za'ra. Tawamhã ma tô rob'uiprazém na tãma wa'âbâ za'ra, Zezusi za te te siwi ĩsadanharĩ'wa norĩ ma. ");
INSERT INTO xavNT_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Ĩtẽme simasa wamhã, te ãne siwi sadanha, aibâ norĩ hã: — Rowahutu'wa, aimreme hã tô sena na, wa tô aiwaihu'u za'ra ni. Asimirowahutu zama wẽ di. Asimiroti na 're da'ab'mairẽme mono õ di. Sena na te dama 're ĩ'aroti mo, 'Re ĩhâimana u'âsi mono nhimirotizéb zarina. ");
INSERT INTO xavNT_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Ãne wa, a hã ma'ãpé, marĩ hã wama waihu'u za'ra na, marĩ hã wa te waihu'u za'ra da. E Roma ãma danhib'apito uptabi ma, wa za rob'uiprazé hã wa te tãma 're po'o za'ra, ĩsimiwada'urizéb zarina. E 'Re ĩhâimana u'âsi mono ma, wẽ di. E tãma wẽ õ di. Ãne niha ĩsimiroti hã ãma. — Ãne te siwi sadanha. ");
INSERT INTO xavNT_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Tazahã ma tô sina waihu'u, Zezusi hã. Tinhimirowasu'u na te te tãma ãma upa za'ra da newa, ma tô ãne siwi sadanharĩ za'ra. Taha wa, te tãma nharĩ za'ra, aibâ norĩ ma: ");
INSERT INTO xavNT_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","— Rob'uiprazé ĩsapotore hã we ĩ̱ma 'maiwẽ wa'aba, te 'madâ'â da. E 'wai hâibarĩ, rob'uiprazé ĩsapotore na hã. E 'wa sisi ui'éré duré, ãma hã. Tawamhã ma asa ãma sada'âbâ za'ra, ãne: — Roma ãma danhib'apito hâibarĩ ã hã, duré taha nhisi ui'éré, ã hã. — Ãne te asa tãma nharĩ za'ra. ");
INSERT INTO xavNT_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Tawamhã Zezusi hã te duré asa tãma nharĩ za'ra: — Roma ãma danhib'apito ma, te za ĩsimiwada'uri zarina rob'uiprazé hã tãma 're ĩpo'o za'ra wa'aba mo apâ, ĩte wa. Tane duré, 'Re ĩhâimana u'âsi mono ma, te za marĩ hã ĩsimiwada'uri zarina tãma 're ĩsõmri za'ra wa'aba mo apâ, ĩte wa. — Ãne ma tô tãma waihu'u za'ra, Zezusi hã. ");
INSERT INTO xavNT_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Tinhimirowasu'u na te te tãma ãma upa za'ra da newa, ma tô danho'a siwi sadanha, aibâ norĩ hã. Tazahã, tinhimirowasu'u na te te tãma ãma upa za'ra õ di, Zezusi hã. Ĩsimirowasu'u hã, wẽ uptabi di. Wẽ uptabi wa, ma ãma titob'uzu za'ra, aibâ norĩ hã. Taha wa, te ari'iwi tihâimana za'ra oto. ");
INSERT INTO xavNT_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","28","Tawamhã ma we aibâ norĩ hã ĩtẽme aimasa, Zezusihi u. Aibâ norĩ hã, sadusezu. Ta norĩ hã 're dadâ'â za'ra mono wamhã, ab're hawi apâ 're ĩdahâiwa'utu za'ra mono õ na, te te dama 're ĩroti za'ra mono. Zezusihi u simasa wamhã, ma tô tãma rob'rãzarõtõ za'ra, ãne: — Rowahutu'wa, wahi'rada Mozési hã ma tô ãne dama roti: “Aibâ ĩmro ré hã 'ra õ ré, dâ'â wamhã, tizédé'aba mro na, te za timro ĩsisãnawã hã, ai'uté hã te te 'maipoto da, ĩwa ĩsédé'aba 'ra ne, 're morĩ da.” Ãne, wahi'rata nhimiroti na rob'ui'éré hã. — Ãne te Zezusihi ma sadawa 'rãzarõtõ za'ra, sadusezu norĩ hã. ");
INSERT INTO xavNT_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Te duré tãma rowasu'u za'ra: — Aibâ hã ĩsisãnawã si hã te 're hâimana za'ra, 7 na ĩhâiba za'ra hã. Tawamhã ĩpoto'rada hã ma tô timro oto. Tazahã, 'ra õ ré, ma tô dârâ, aibâ hã. ");
INSERT INTO xavNT_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Taha wa, ma tô ĩsõsi hã duré ãma timro, tizédé'aba mro na. Tane nherẽ, ma duré dârâ, 'ra õ ré. ");
INSERT INTO xavNT_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Taha wa, ma tô taha nhosi hã duré ãma timro. Tane nherẽ, ma duré dârâ, 'ra õ ré. Ãne siparabâsi, ma tô aré sisõwa're're nasi ãma timro za'ra. Tawamhã ma tô oto uburé sisarina ai'utõ, 'ra õ ré. ");
INSERT INTO xavNT_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Tawamhã pi'õ zama ma tô oto dârâ, timro norĩ zarina. ");
INSERT INTO xavNT_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Ĩmro 7 na ĩhâiba za'ra wamhã, e 'wai mro za bété pi'õ hã, ab're hawi apâ te te 're da'ahâiwa'utu mono wamhã, 'Re ĩhâimana u'âsi mono hã. — Ãne te siwi sadanha, sadusezu norĩ hã. ");
INSERT INTO xavNT_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Taha wa, te Zezusi hã asa tãma rowasu'u za'ra, ãne: — Ti'ab ré si, te za dasina 're damro za'ra. ");
INSERT INTO xavNT_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Hâiwa ãma hã, dasina 're damro za'ra mono õ di za oto. Niwapsi, te za ab're hawi ahâiwa'utu, 'Re ĩhâimana u'âsi mono hã te te 're ĩ'awẽsãmri mono norĩ hã, hâiwa ãma ĩ'rata 're si'ubumroi u'âsi mono da. ");
INSERT INTO xavNT_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","'Re ĩhâimana u'âsi mono ma romhuri'wa norĩ ne, te za dâ'â ãna 're hâimana u'âsi za'ra, dâ'â waihu'u ãna. 'Re ĩhâimana u'âsi mono 'ra, te za 're dahâimana za'ra, ab're hawi za te te da'ahâiwa'utu wa. ");
INSERT INTO xavNT_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","38","Mozési hã ma tô dama waihu'u, ab're hawi 'Re ĩhâimana u'âsi mono te te 're ĩda'ahâiwa'utu mono zém na hã. Wede zapore ĩro'o na, te te dama ãma rob'ui'éré wamhã, ma tô 'Re ĩhâimana u'âsi mono dama wasu'u, tihi'rata norĩ nhib'apito na. Abra'ãhã nhib'apito, te, u, 're hâimana, 'Re ĩhâimana u'âsi mono hã. Duré Izatihi nhib'apito, te, u, 're hâimana. Duré Zacoho nhib'apito te, u, 're hâimana. Ãne te dama rowasu'u, Mozési hã. 'Re ĩdahâimana u'âsi za'ra mono nhib'apito, te 're mo, 'Re ĩhâimana u'âsi mono hã. Dahâiba hâ nhib'apito, 're morĩ õ di. Aihĩni te ĩsõ'a 're dahâimana za'ra. 'Re ĩdadâ'â za'ra mono norĩ zama, te ĩsõ'a 're hâimana za'ra. Ãne, Mozési te te dama ĩrowasu'uzéb zarina, wa tô waihu'u za'ra ni. — Ãne ma tô tãma sadawa 'rãzarõtõ za'ra, sadusezu norĩ ma, Zezusi hã. ");
INSERT INTO xavNT_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Tawamhã te rowahutu'wa norĩ hã Zezusihi ma nharĩ za'ra: — Asimirowasu'u hã wẽ di, rowahutu'wa. — Ãne te ãma tiwata za'ra. ");
INSERT INTO xavNT_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Taha wa, ma tô roti wẽ na sõwada za'ra, sadusezu norĩ hã. Taha wa, marĩ na te te siwi sadanharĩ waihu'u õ di oto, te te sina mreme wazéb za'ra wa, ta norĩ hã. ");
INSERT INTO xavNT_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Tawamhã Zezusi hã te da'azadanha, ãne: — Danho'reptui'wa da, 'Re ĩhâimana u'âsi mono te te ĩpisudu hã Dawihi nhihudu te za, u, 're mo. E marĩ wa, te ĩsihudu na wasu'u za'ra ni. ");
INSERT INTO xavNT_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","43","Apito Dawi hã ma tô tinhib'apito na danho'reptui'wa hã sisi, tinho're na. Ãne, Dawihi nho're na rob'ui'éré hã: “'Re ĩhâimana u'âsi mono, ma tô Ĩ̱nhib'apito ma, tinha: ‘Ĩ̱'rata te za 're asãmra mo, ĩ̱nhimire niwĩ dama aipire na ĩ̱siré 're aihâimana u'âsi mono da. Wa hã wa za te tãma 're nharĩ za'ra, asitob'ru norĩ ma, aima 're sib'uwa za'ra mono da.’ ” Ãne Dawihi nho're wasu'u na rob'ui'éré, 'Re ĩhâimana u'âsi mono ma danho're na, Saumusi na ĩbaihâ nhisi na hã. ");
INSERT INTO xavNT_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Dawi hã tinhib'apito na te te sisi nherẽ, e niha te za ĩsihudu si 're hâimana, Danho'reptui'wa da, 'Re ĩhâimana u'âsi mono te te ĩpisudu hã. — Ãne ma tô Zezusi hã da'azadanha. ");
INSERT INTO xavNT_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Tawamhã uburé, da te wapari za'ra ré, te Zezusi hã tinha, tisiré 're ĩnomro mono norĩ ma: ");
INSERT INTO xavNT_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","— Ma'ãpé, rowahutu'wa norĩ hã waihu'u za'ra wa'aba, ĩhâimanazém na hã. Ta norĩ hã uza pa ré, 're nomro mono da si, tãma ĩwẽ za'ra hã. Duré 'ri nhi'riti wa, da te dasina 're ĩ'ubumroi mono zéb ãma dama pire wa, da te 're wazéb za'ra mono da, ma tô te te sima 're wẽ za'ra. Duré dama ĩpire norĩ simasisizém na 're ĩsi'ubumroi mono da si, tãma ĩwẽ za'ra hã, rowahutuzéb ãma duré 'ri para dasiré 're ĩdasaihuri mono zéb ãma hã. ");
INSERT INTO xavNT_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Rowahutu'wa zahã, te za pi'õi mrotõ norĩ wi, ĩsibro hã te te tiwi 're uprosi za'ra. Tane nherẽ, te ta norĩ hã danho'a 'Re ĩhâimana u'âsi mono ma, 're mreme zusi hâ, 're hâimana wẽ uptabi za'ra mono newa. Taha wa, te te dama 're ĩ'arob'manharĩ mono zém nhipai u, te za 'Re ĩhâimana u'âsi mono hã te te tãma 're rob'manharĩ za'ẽtẽ za'ra. — Ãne ma tô tãma waihu'u za'ra, tisiré 're ĩnomro mono norĩ ma. ");
INSERT INTO xavNT_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Tawamhã 'Re ĩhâimana u'âsi mono ãma 're ĩdawata za'ra mono zéb ãma, ma tô da'ab'madâ Zezusi hã, danhoprubzé, da te 're ĩséme mono zéb 're, ĩsibro pese norĩ hã te te séme ré, 'Re ĩhâimana u'âsi mono ma. Ãne na ma tô da'ab'madâ, 'ri 'wawi wa'ra 're, Zezusi hã. ");
INSERT INTO xavNT_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Pi'õi mrotõ zama ma duré 'madâ, ĩsibrob'õ hã. Ta hã ma tô rob'uiprazé ĩsapotore hã dame tiza, marĩ te te ãma ĩ'uipra da hã aré, syryre nherẽ. ");
INSERT INTO xavNT_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","4","Taha wa, te Zezusi hã tinha, tisiré 're ĩnomro mono norĩ ma: — Tô sena, ã hã pi'õi mrotõ hã sibrob õ nherẽ, ma tô tinhoprum na uburé da'a'rãnhipa. Ĩsiré norĩ hã rob'uiprazé hã nasi tãma ĩsi'atarẽme za'ra si, te nasi sé. Tanei õ di, pi'õi mrotõ hã. Simarĩ õ nherẽ, tihâimanazéb da, te te aré ĩtédé hã ma tô ĩbâre tãma tisõ. Ãne wamhã, ma tô tinhoprum na uburé da'a'rãnhipa. — Ãne ma tô Zezusi hã tãma waihu'u za'ra, tisiré 're ĩnomro mono norĩ ma. ");
INSERT INTO xavNT_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Tawamhã ni'wam norĩ hã ma tô 'ri 'rãihâ ãma tiwata za'ra, ãne: — Ẽne hã wẽ uptabi di, 'ri 'manharĩzé hã. Duré waipo wẽ di, danhibzari hã. — Ãne te 'ri ãma tiwata za'ra, 'Re ĩhâimana u'âsi mono nhorõwa ãma. Taha wa, te Zezusi hã tinha: ");
INSERT INTO xavNT_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","— Niwapsi te za dasiwi prum ni, ẽtẽ na 'ri hã. Tawamhã misi si te za oto simi'wara, ẽne hã. Sisisiwi 'manomro waihu'u õ di za oto, ẽne hã. Tâibâ za oto. — Ãne ma tô romhâ ré ãma rowa'õtõ, Zezusi hã. ");
INSERT INTO xavNT_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Tawamhã te siwi sadanha: — Rowahutu'wa, e niwa te za ãne na hã ãma tiromhâiba. E marĩ te za watobro, ĩsõwa, wa te ãma ĩwaihu'u sirõmo za'ra zéb da hã. — Ãne te sadanharĩ za'ra. ");
INSERT INTO xavNT_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Taha wa, te Zezusi hã asa tãma nharĩ za'ra: — Ni'wam norĩ hã te za sadawa nhipese na sisarina datẽme 're nomro, ahâ na. Wa hã ne, te za taré ĩ̱nhisi na dama 're siwasu'u za'ra, danho'reptui'wa na. Taré te za duré te te dama 're rowasu'u za'ra, ãne: “Bâdâ te za oto ĩwa waptãrã, 'Re ĩhâimana u'âsi mono te te ĩpisudu hã.” Ãne te za taré te te dama 're rowasu'u za'ra. Taha wa, te za aihâimana nhimiza'rese tiwi 're aihâimana za'ra wa'aba mo, sadawa nhipese sina datẽme 're ĩnomro mono norĩ ãma, 're sasõmri za'ra wa'aba mono tõ da. ");
INSERT INTO xavNT_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","'Re dasi'wapé za'ra mono wa, da te dasina 're ĩropupu'u za'ra mono zé hã 're wapari za'ra wa'aba mono wamhã, tãma 're aipahi za'ra wa'aba mono õ di za. Duré ti'ai ãma danhib'apito norĩ hã, da te 're ĩsani za'ra mono zé wasu'u hã 're wapari za'ra wa'aba mono wamhã, tãma 're aipahi za'ra wa'aba mono õ di za. Dasi'wapé hã te za a'â 're wairébé. Danhib'apito hã te za a'â da te 're sani za'ra, tô. Tane nherẽ, rob'rãsutu uptabi õ di za a'â. — Ãne ma tô romhâ ré tãma waihu'u sirõmo za'ra, Zezusi hã. ");
INSERT INTO xavNT_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Ma duré tãma waihu'u za'ra, ãne: — Danhipti'ai amoi u te za dasisô 're dapra a'â, 're dasi'wapé za'ra mono da. Tawamhã daro mono bâ te za tô 're dasiwasutu za'ra. ");
INSERT INTO xavNT_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Nima niwĩmhã te za duré ti'a hã daré 're popo'o za'ra, sa'ẽtẽ. Nima niwĩmhã, danho õ wa, te za da te 're robzépata za'ra, dasa syryre wa. Nima niwĩmhã te za duré dahâzé ĩpire uptabi hã te te 're daduri. Marĩ ĩpipa hã te za duré hâiwa nho're na danho'a 're wairébé. ");
INSERT INTO xavNT_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","— Ãne na romhâimana õ ré, te za da te 're aiwaibui wa'wa. Rowasédé hã te za duré da te aima 're 'manharĩ za'ra wa'wa. Rowahutuzéb u, te za da te 're ai'mazasi za'ra wa'wa, aihâimanazém na da te 're aiwaihu'u za'ra wa'aba mono da. Taha wa, te za taré da te 're aiwẽ'õ za'ra wa'wa. Taha pari, te za da te 're aséme 'wa, dazazéb 're, 're aimasa wa'aba mono da. Ĩ̱zazei'wa 're anomro aba mono 'ru te, te za duré da te 're asimroi wa'wa, danhib'apito norĩ u. Roti'wa, si'upana te te ĩpisutu norĩ u zama, te za da te 're asimroi wa'wa. ");
INSERT INTO xavNT_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Ãne wamhã, ĩ̱wasu'uwẽ na te za 're ĩdapo're pu'u za'ra wa'aba mo. ");
INSERT INTO xavNT_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Duré asisõwa, asina aihâtâ'â te, asiwasu'uzéb zô 're rosa'rata hâ za'ra wa'aba mono õ di za. ");
INSERT INTO xavNT_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Wa hã wa za te 're aipawaptob za'ra wa'wa, danhib'apito norĩ ma, 're asiwasu'u za'ra wa'aba mono zéb da hã. Ãne wa, aimreme wẽ na te za aiwẽ'õ'wa norĩ hã 're ĩsõwada za'ra wa'aba mo. ");
INSERT INTO xavNT_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Ni'wam norĩ hã te za te te dama 're ai'ru za'ra wa'wa, dazazéb 're, da te 're aséme aba mono da. Ãté aimama norĩ hã te za te te dama 're ai'ru za'ra wa'wa, ãté asisãnawã norĩ hã, ãté asiwadi norĩ hã. Ãté asawi'wa norĩ zama te za te te dama 're ai'ru za'ra wa'wa. Taha zarina, te za ai'mai'uprosi aba ni. ");
INSERT INTO xavNT_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Ĩ̱zazei'wa oto 're anomro aba mono wa, te za uburé da te 're ai'ruiwapari za'ra wa'wa. ");
INSERT INTO xavNT_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Tane nherẽ, aihâimanazé hã aiwi 're si'utõrĩ uptabi za'ra wa'aba mono õ di za. ");
INSERT INTO xavNT_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Taha wa, te za 're asiptete za'ra wa'aba mo, ĩ̱'ãma 're anomro u'âsi aba mono da. Tawapsi, te za asõ'reptuzé hã asina 're ĩ'uwaimrami za'ra wa'aba mo. — Ãne ma tô tãma waihu'u sirõmo za'ra, tisiré 're ĩnomro mono norĩ ma. ");
INSERT INTO xavNT_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","Tawamhã Zezusi hã ma duré tãma waihu'u sirõmo za'ra, ãne: — Niwapsi te za dasi'wapéi 'manharĩ'wa norĩ hã Zeruzarẽ u aihutu, 'ri 'wawi wa'ra, te te siwi uirĩ da. Ta norĩ hã 'madâ'â za'ra wa'aba wamhã, te za ĩwaihu'u sirõmo za'ra wa'wa, za te te daré ĩ'ri nhamra mono na hã. ");
INSERT INTO xavNT_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Zudeza ãma, dame 're ai'ubumroi wa'aba mono wamhã, te za ẽtẽ 'rãihâ u asa'rei wa'aba mo, aiwara sina. 'Ri ahâ ãma 're ai'ubumroi wa'aba mono wamhã, te za aiwairébé su'u 'wa, 'ri ahâ nhiti. Rom na 're ai'ubumroi wa'aba mono wamhã, 'ri ahâ u 're asisisi aba mono õ di za. ");
INSERT INTO xavNT_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","'Re ĩhâimana u'âsi mono te te dama 're arob'manharĩ mono wa, te za rowasété si a'â 're sa'wari. Taha ré, te za marĩ hã uburé dazô pusi, romhâ ré, 'Re ĩhâimana u'âsi mono zadawa wasu'u'wa norĩ hã te te ãma ĩrob'ui'éré za'ra zéb zarina. ");
INSERT INTO xavNT_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Tawamhã ãne hã rowasédé hã daré romhâimana wamhã, ĩwasã ré norĩ ma hã tãma ropipa uptabi za'ra di za, ĩ'ra pré ré norĩ ma zama. 'Re ĩhâimana u'âsi mono hã te te dama 're ĩ'arob'manharĩ pipa mono zé bâtâ na hã, tãma 're ropipa za'ra mono di za, zudezu norĩ ma. ");
INSERT INTO xavNT_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Sib'ézé 'wapa na hã da'ahâ na te za tadâ'â za'ra ni. Duré, ni'wam norĩ hã daro mono bâ, te za da te simro. Te za da te ãma ropé, daro mono bâ. 'Re ĩhâimana u'âsi mono zazei'õ'wa norĩ hã sahi sina te za a'â te te dama 're roti za'ra, Zeruzarẽ ãma, zudezu'õ norĩ hã. Bâdâ hã ĩwa tãma ĩwaptã'ã za'ra zéb u, te za da'madâ'â 'rãsutu za'ra. — Ãne ma tô romhâ ré tãma waihu'u za'ra, tisiré 're ĩnomro mono norĩ ma. ");
INSERT INTO xavNT_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","Romhâ ré, ma tô duré ãne hã tãma waihu'u sirõmo za'ra, Zezusi hã: — Niwapsi te za marĩ aimawi hã 'madâ'â za'ra ni, bâtâ na hã, a'amo na zama, wasi norĩ na zama. Â poré a'a 'reptã'ã ma, te za tapahi za'ra ni, â poré nhibzaihâ ma zama. Daro mono bâ, dama robzei'õ uptabi za'ra di za. ");
INSERT INTO xavNT_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Marĩ hã hâiwa na 're ĩsimasa mono hã, tizabzéb ãma 're simasab u'âsi mono õ di za. Taha wa, te za daro mono bâ dawi tirobra za'ra, rowasédé hã dazô ĩwatobrozém na te te rosa'rata pipa za'ra wa. ");
INSERT INTO xavNT_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Tawamhã ti'ai ãma dasiré ĩ̱podo hã hâiwa'a na, wa za wei apâ mo, danho'a. Ĩ̱waihu'u pese uptabi na, wa za wei mo apâ, duré ĩ̱hâiba na hã rowa'a sa'ẽtẽ uptabi na. ");
INSERT INTO xavNT_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Ãne wana ré, marĩ hã pusi mono wamhã, te za asiptete na 're aihâimana u'âsi za'ra wa'aba mo. Duré 're ai'rãiwahutu za'ra wa'aba mono. E marĩ wa. Romhutu na te za asõ'reptu za'ra wa'aba zé hã asina ĩ'uwaimrami za'ra wa'wa. — Ãne ma tô romhâ ré tãma waihu'u sirõmo za'ra, tisiré 're ĩnomro mono norĩ ma, Zezusi hã. ");
INSERT INTO xavNT_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Zezusi hã te duré romnhimiré'é, pidera wede na, ãne: — Ma'ãpé pidera 'rã na rosa'rata za'ra wa'aba, wede ĩpoto mono bâ. ");
INSERT INTO xavNT_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Ĩsu té hã 're wairébé mono wamhã, te za ãma 're ĩwaihu'u za'ra wa'aba mo, tã 're ĩta'a mono zéb u, 're ĩrob'umhutu mono zém na hã. ");
INSERT INTO xavNT_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Tane duré, marĩ hã 're ĩromhâimana mono zéb da, te aima ĩwasu'u za'ra wa'aba zéb zarina, 'madâ'â za'ra wa'aba wamhã, te za ãma ĩrowaihu'u za'ra wa'wa, romhuture di oto, 'Re ĩhâimana u'âsi mono, da'ãma 're ĩsib'a'uwẽ mono zéb u hã. ");
INSERT INTO xavNT_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Tô sena, wa ãne na aima waihu'u sirõmo za'ra wa'wa. Ã hã uburé rowasédé hã dazô 're wairébé mono ré, ti'ai ãma 're ĩdasi'ubumroi mono norĩ hã ta norĩ hã 're dâ'â za'ra mono õ ré, te za ĩsõ'a za'ra ti'rãsutu, rowasédé hã. ");
INSERT INTO xavNT_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Nimahã na te za hâiwa norĩ hã ai'utõrĩ zahuré, ti'ai me. Si'utõrĩ zahuré nherẽ, ĩ̱nhimiroti hã si'utõrĩ õ di za. Pire na te za dama 're hâimana u'âsi. — Ãne ma tô Zezusi hã tãma waihu'u za'ra, tisiré 're ĩnomro mono norĩ ma. ");
INSERT INTO xavNT_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","35","Tawamhã Zezusi hã tinhimiroti na ma tô tãma 'rãsutu za'ra, ãne: — Asimiza'rese sina, te za 're aihâimana za'ra wa'aba mo. Datoi u hã âsipãrĩ na 're asapa'a za'ra wa'aba mono õ di za. Marĩ na si 're rosa'rata za'ra wa'aba mono õ di za. E marĩ wa. Rosa'rese õ ré, bâdâ ĩpire, ĩwa waptã'ã õ'umnhasite. Rosa'rese õ ré, te robzari hã ĩtede'wa hã te te 're waibu, wedenhorõ na. Tane, duré rosa'rese õ ré, te za bâdâ ĩpire hã ĩwa waptãrã, uburé ti'ai ãma hã. ");
INSERT INTO xavNT_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Taha wa, te za asimiza'rese sina 're aihâimana u'âsi za'ra wa'aba mo. Te za duré asima 're ĩrowaptẽrẽ u'âsi za'ra wa'aba mo. E marĩ da. Marĩ hã 're wairébé mono wamhã, asiptete na 're aihâimana za'ra wa'aba mono da, apâ we ĩ̱morĩ wa, ĩ̱nho're asisép te, ai'rãipo tõ za'ra wa'aba da, ti'ai ãma dasiré ĩ̱poto nho're. — Ãne ma tô Zezusi hã tãma waihu'u za'ra. ");
INSERT INTO xavNT_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Tawamhã Zezusi hã bâtâ sidâpâsi, te nasi dama rowasu'u, 'ri 'wawi wa'ra 're, 'Re ĩhâimana u'âsi mono ãma 're ĩdawata za'ra mono zéb ãma. Barana hã te nasi ne, Oriwera na ẽtẽ 'rãihâ nhisi u. Tame ma tô nasi ãma ti'awẽ. ");
INSERT INTO xavNT_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Awẽ wi, te nasi ĩtẽme dasito, 'Re ĩhâimana u'âsi mono nhorõwa u, ĩmreme hã da te nasi wapari za'ra da. ");
INSERT INTO xavNT_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Ĩ'u'ẽtẽ duptoi'õ, da te 're ĩhuri mono zéb u hã, romhuture di oto, Pascowa na dato nhisi u hã. ");
INSERT INTO xavNT_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","'Re ĩhâimana u'âsi mono ma, da'ãma romhuri'wa ĩpire norĩ hã, te rowahutu'wa norĩ me sima ãma rosa'rata za'ra, pi'uriwi te te siwi wĩrĩ da, Zezusi hã. Dama pahi za'ra wa, te ãne sima ãma rosa'rata za'ra. ");
INSERT INTO xavNT_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Tawamhã Satanasi hã ma tô oto Zudasihi pẽ'ẽ 're ãzé. Icarizoti na, Zudasihi nhisi hâiba amo hã. Zezusihi me dame 're ĩmorĩ, Zudasi hã, 12 na ĩhâiba za'ra siré hã. ");
INSERT INTO xavNT_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Tawamhã te oto mo, sasedoti ĩpire norĩ u. Duré, 'Re ĩhâimana u'âsi mono ãma 're ĩdawata za'ra mono zé 'madâ'â'wa norĩ u, te mo, ĩpire norĩ u, Zezusihi ãma te te sadawa pibu za'ra da, te te dama hâiba nhomri da. ");
INSERT INTO xavNT_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Ĩmreme te te wapari za'ra wamhã, tãma rowẽ za'ra di. Taha wa, te tãma ropisutu za'ra, rob'uiprazé te te tãma sõmri za'ra da. ");
INSERT INTO xavNT_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Taha wa, ma tô Zudasi hã ãma saze za'ra, rob'uiprazé te te tãma sõmri za'ra da, sasedoti ĩpire norĩ hã. Taha wa, te oto rosa'rata, nimahã bâtâ na Zezusi te te dama hâiba nhomri da, danhimiza'rese õ ré. ");
INSERT INTO xavNT_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Tawamhã bâdâ hã ma tô ĩwa waptãrã oto, ĩ'u'ẽtẽ duptoi'õ, da te 're ĩhuri mono zé hã. Zudezu norĩ hã te za pone'ẽrebâ 'ra hã simro, tisaihurizéb da, Pascowa na dato nhisi na da hã. ");
INSERT INTO xavNT_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Taha wa, te Zezusi hã Pedru norĩ ma rob'ru zahuré, Zuwãhã me, ãne: — Mo oto ane wa'aba, wazô asipi wa'aba da, Pascowa te bâtâ na ĩwasaihurizéb da hã. — Ãne te tãma rob'ru zahuré. ");
INSERT INTO xavNT_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Tawamhã te Pedru norĩ hã sadanharĩ zahuré, ãne: — E momo ma tô asima ĩrowẽ, asô ĩwanhipi za'ra zéb da hã. — Ãne te sadanharĩ zahuré. ");
INSERT INTO xavNT_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Taha wa, te Zezusi asa tãma nharĩ zahuré: — Ĩ̱wapari pese aba. 'Ri ahâ u aimasisi aba wamhã, aibâ hã te za ĩsõpẽtẽ 'wa, piza'a â ré, te te ĩ'âri hã. Sõpẽtẽ aba wamhã, pibui wa'aba mono za, 'ri para u ĩsébrézéb u. ");
INSERT INTO xavNT_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Tame te za 'ri tede'wa hã ĩsadanharĩ 'wa, ãne: “Rowahutu'wa hã te wama tinha, wa te asadanharĩ da: E ma niwĩ 'ri 're wa'wa hã, ĩ̱siré 're ĩnomro mono norĩ me, ĩwa ĩwasaihurizéb da hã, Pascowa na dato nhisi na hã.” ");
INSERT INTO xavNT_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Tawamhã 'ri tede'wa, te za hâimo 'ri 're wa'wa za'ẽne hã aima pisutu 'wa, marĩ ĩ'ubumro sirõmo ãma. Tame te za wazô ĩrobza'ra pese 'wa. — Ãne te Zezusi hã tãma roti zahuré. ");
INSERT INTO xavNT_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Tawamhã 'ri ahâ u simasisi wamhã, Zezusi te te tãma ĩ'awasu'u zahuré zéb uwaibaba, ma tô uburé anhopẽtẽ zahuré. Tame ma tô dasa hã 'manharĩ zahuré, Pascowa na dato nhisi na da hã. ");
INSERT INTO xavNT_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Tawamhã te za oto tasaihuri ni. Taha wa, te oto Zezusi norĩ hã ai'ubumro, saihuri da, tizadawa wasu'u'wa norĩ me. ");
INSERT INTO xavNT_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Tawamhã te oto tãma siwasu'u za'ra, ãne: — Wa tô ĩ̱sima wẽ upta, aime ĩ̱sa za'ra wa'aba da, te robzépata õ ré, Pascowa na 're ĩdasaihuri mono zém na. ");
INSERT INTO xavNT_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Ãne, ĩ̱sa na 're ĩ̱sai mono õ di za oto. Bâdâ ĩwa waptã'ã wapsi, 'Re ĩhâimana u'âsi mono hã uburé da'ãma 're sib'a'uwẽ mono wapsi, wa za duré 're ĩ̱sa. Tawapsi, dasaihurizé hã marĩ te te ĩwasu'u hã te ĩ̱sina uwaimrami wapsi, wa za duré 're ĩ̱sa. — Ãne ma tô tãma siwaihu'u za'ra. ");
INSERT INTO xavNT_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Tawamhã ma hâsizé hã ti'â, uwa 'ru 'rãi wa'ui ré hã. 'Re ĩhâimana u'âsi mono ãma te tiwata, sõpru wa. Te duré tãma nharĩ za'ra: — Ã, âhuri aba, uburé. ");
INSERT INTO xavNT_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Ã hã te 're hâsi mono õ di za oto, a'â. Niwapsi, wa za duré te 're hâsi, 'Re ĩhâimana u'âsi mono hã uburé da'ãma 're sib'a'uwẽ mono wapsi. — Ãne te tãma siwasu'u za'ra. ");
INSERT INTO xavNT_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Ĩ'u'ẽne hã ma duré ti'â. 'Re ĩhâimana u'âsi mono ãma te duré ĩré ãma tiwata, sõpru wa. Taha pari, ma tô te te wẽ'ẽ, ĩ'u'ẽne hã. Te te wẽ'ẽi mono parimhã, ma tô te te tãma sõmri, tisiré 're ĩnomro mono norĩ ma. Te duré tãma nharĩ za'ra, ãne: — Ã, ĩ'u'ẽne hã huri aba. Ã hã ĩ̱hâiba, te wasu'u, za asada ĩ̱sisõmri aba zé hã. Ã hã te za 're ĩhuri aba mo, ĩ̱'ãma 're asipo're pu'u u'âsi za'ra wa'aba mono zéb da hã. — Ãne te tãma nharĩ za'ra. ");
INSERT INTO xavNT_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Tawamhã saihuri pari, ma duré hâsizé hã ti'â, uwa 'ru 'rãi wa'u ĩsé ré hã. Te tãma nharĩ za'ra: — 'Re ĩhâimana u'âsi mono te te dama ĩropisutuzép té, te wasu'u, rob'rãi wa'u hã. Rob'rãi wa'u za'wari ne, asada ĩ̱dâ'â za'ra wa'aba wamhã, te za ĩ̱wi puru, ĩ̱wapru hã. Tô sena, te za te te dama ãma 're a'uwaimrami, te te dama ĩropisutuzép té hã. Ãne na waihu'u za'ra wa'aba da, te za ĩ̱wi puru, ĩ̱wapru hã. ");
INSERT INTO xavNT_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Ma'ãpé, asiwi waihu'u aba. Ni'wa hã ĩ̱zawi'wa newa, te ĩ̱me nhamra, wedeza na, dama ĩ̱nhomri'wa da hã. ");
INSERT INTO xavNT_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Wa hã ti'ai ãma dasiré ĩ̱podo hã wa za dârâ, 'Re ĩhâimana u'âsi mono te te ĩ̱ma ĩpisutuzéb zarina. Ĩ̱dâ'â da, te te ĩ̱ma pisutu nherẽ, aibâ ma, tãma 're ropipa uptabi mono di za, za te te dama ĩ̱hâiba nhomri'wai ma hã. — Ãne ma tô tãma waihu'u za'ra. ");
INSERT INTO xavNT_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Taha wa, te 'râwi sisadanharĩ za'ra, ãne: — E 'wa hã te za dama tisõ. — Ãne te 'râwi sisadanharĩ za'ra. ");
INSERT INTO xavNT_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Tawamhã sima ĩ'maipire zô sõpré wa, ãma sisaze za'ra õ wa, te timreme na 'râwi si'wapé za'ra, ĩsiré 're ĩnomro mono norĩ hã. ");
INSERT INTO xavNT_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Taha wa, te Zezusi tãma nharĩ za'ra, ãne: — Ti'ai ãma danhib'apito norĩ hã, simiwada'uri pese za'ra di. Duré, ĩsiwaihu'u zarina, te za dama marĩ 'manharĩ wẽ 'wa na, da te 're sisi za'ra. ");
INSERT INTO xavNT_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Tane asima 're aihâimana za'ra wa'aba mono õ di za, a norĩ wa'wa hã. Asiré norĩ ma, aipire wa'aba nherẽ, te za tãma 're asidai'uté za'ra wa'aba mo. Duré dawada'uri'wa, 're anomro aba mono nherẽ, aiwapu na te za dama 're ĩromhuri za'ra wa'aba mo. ");
INSERT INTO xavNT_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","E 'wa hã, dama ĩpire. E tisa da, wedeza na ĩsãmra, dama ĩpire. E dama dasai 'wapéi'wa hã dama ĩpire. Tisa da, wedeza na ĩsãmra hã, tô dama ĩpire. Tazahã, wa hã dama dasai 'wapéi'wa ne, wa 're mo. ");
INSERT INTO xavNT_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","— A norĩ wa'wa hã marĩ te 're sépata mono ré, ma tô ĩ̱siré 're anomro u'âsi aba mo. ");
INSERT INTO xavNT_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Taha wa, roti'wa da, dama ĩ̱pire na 're ĩ̱hâimana mono da, Ĩ̱mama te te ĩ̱ma ĩpisutu ne, tane wa za duré wa hã aipisutu za'ra wa'wa, dama aipire na 're aihâimana za'ra wa'aba mono da, dama roti'wa da. ");
INSERT INTO xavNT_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","A norĩ wa'wa hã niwapsi, te za ĩ̱siré 're asimroi wa'aba mo, wedeza na wasiré 're wasaihuri mono da, wa te 're âhuri mono da zama. Danhib'apito simasisizém na, te za 're ai'ubumroi wa'aba mo, Izarazéhé nhihudu norĩ ma, 're roti za'ra wa'aba mono da. Wahi'rada Izarazé hã, 12 na ĩ'ra si'aibâ norĩ hã. Taha nhihudu norĩ hã te za 're ĩ'madâ'â za'ra wa'aba mo. — Ãne ma tô Zezusi hã tãma waihu'u sirõmo za'ra, te te waihu'u za'ra da. ");
INSERT INTO xavNT_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Tawamhã Zezusi hã te Pedruhu ma tinha, ãne: — Sima, ĩ̱wapari pese. Satanasi hã ma tô 'Re ĩhâimana u'âsi mono wi aiwaptẽrẽ za'ra wa'wa, tô sena ĩ̱zazei uptabi 'wa zô, te te aipibu za'ra wa'aba da. Tridu hã ĩ'rã uptabi zô, da te 're ĩ'upõrĩ za'ra mono ne, te za te te 're aipibu za'ra wa'wa, ĩ̱zazei uptabi 'wa zô. ");
INSERT INTO xavNT_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Sima, tane nherẽ, Ĩ̱mama wi, wa tô te 're rowaptẽrẽ aima, te te 're aipawaptob u'âsi mono da, ĩ̱'ãma 're aimorĩ u'âsi da. Apâ ĩ̱tẽme aipi'rai wapsi, te za asisãnawã norĩ hã 're ĩpawaptob za'ra mo, hâimana nhiptete na 're nomro mono da. — Ãne te Pedruhu ma tinha. ");
INSERT INTO xavNT_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Tawamhã Pedru hã te asa tãma tinha, ãne: — Apito, wa tô ĩ̱sima wẽ, asiré ãma ĩ̱morĩ da, asiré, da te ĩ̱nherẽ da nherẽ, duré asiré ĩ̱dâ'â da nherẽ. — Ãne te Pedru hã tãma siwasu'u. ");
INSERT INTO xavNT_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Taha wa, te Zezusi hã asa tãma tinha, ãne: — Pedru, ĩ̱wapari pese. Ĩ̱zadawa para õ nherẽ, ã bâtâ na si'a hârâ õ ré, te za si'ubdatõ dawi ĩ̱'udâ, aima ĩ̱za'rese õ na. — Ãne ma tô romhâ ré tãma waihu'u siro, Pedruhu ma. ");
INSERT INTO xavNT_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Tawamhã Zezusi te sadanharĩ za'ra, tisiré 're ĩnomro mono norĩ hã, ãne: — Datẽme te asatõrĩ za'ra wa'aba wamhã, wa tô aré aiwi sawi za'ra wa'wa, marĩ hã asiré 'wasari aba tõ da, rob'uiprazém nhemezé hã, duré ro'wapézé hã, duré aipara'uzazé wa'wa hã. E tawamhã marĩ hã aiwi sô rowaptâ'â aba õ di. — Ãne te Zezusi hã sadanharĩ za'ra. — Marĩ zô, wawi rowaptâ'â za'ra õ di. — Ãne te asa tãma nharĩ za'ra. ");
INSERT INTO xavNT_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Taha wa, te Zezusi hã tãma nharĩ za'ra, ãne: — Rob'uiprazém nhemezé, ate wamhã, te za oto ĩ'â, duré ro'wapézé, ate wamhã. Duré sib'ézé 'wapa õ wamhã, te za asi'upsibizé dama ĩwe, ĩwa'âbâ na sib'ézé 'wapa, asima uipra da. ");
INSERT INTO xavNT_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","E marĩ wa, wa ãne aima 'ru za'ra wa'wa. Ĩ̱wasété newa, te za rowasété 'manharĩ'wa norĩ zu ĩ̱ma rob'manharĩ za'ra ni. Ãne, duréihã ma tô romhâ ré ĩ̱'ãma rob'ui'éré sirõmo za'ra ĩbaihâ na, 'Re ĩhâimana u'âsi mono zadawa wasu'u'wa norĩ hã. Taha wa, te za ĩ̱'ãma rob'ui'éré zarina, tô ĩ̱'ãma uwaimrami za'ra ni. — Ãne ma tô Zezusi hã romhâ ré sina tãma rowaihu'u sirõmo za'ra. ");
INSERT INTO xavNT_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Tawamhã ãne te asa tãma nharĩ za'ra, ĩsiré 're ĩnomro mono norĩ hã: — Wanhib'apito, ãhãta sib'ézé 'wapa maparane. — Wẽ di tô. Taha si. — Ãne te asa tãma nharĩ za'ra, Zezusi hã. ");
INSERT INTO xavNT_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Tawamhã Zezusi hã ma oto rob u watobro, ẽtẽ 'rãihâ u morĩ da, Oriwera u. Tamomo 're ĩne mono zéb u te duré mo, Oriwera u. Ĩsiré 're ĩnomro mono norĩ hã te ĩme ai'aba'ré. ");
INSERT INTO xavNT_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Tawamhã te te sima ĩwẽzéb u, ma tô ãma aihutu. Tame Zezusi te tãma roti za'ra, ãne: — Ma'ãpé, asima rowaptẽrẽ za'ra wa'aba, 'Re ĩhâimana u'âsi mono wi, te te aipawaptob za'ra wa'aba da, Wa'uburé nhimiwada'uri wi. — Ãne te tãma nharĩ za'ra. ");
INSERT INTO xavNT_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Tawamhã ĩsiti za'ra te mo, siwaprosi sãmra da, romhâ prã na. Tame ma hi'rãtitõ nhamra, Timama ma, mreme da. ");
INSERT INTO xavNT_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","Ãne te Timama ma mre: — Ĩ̱mama, asima wẽ wamhã, ĩ̱ma ba'a ĩ̱dâ'âzé hã, te robzépata tõ da. Tane nherẽ, te ĩ̱sima ĩwẽzéb uwaibaba, ĩ̱ma pisutu õ di za. Aima ĩwẽzéb uwaibaba, te 'manharĩ da hã ĩ̱ma wẽ di. — Ãne te Timama wi rowaptẽ. ");
INSERT INTO xavNT_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Tawamhã ma ĩtẽme sihâi'ré, hâiwa ãma romhuri'wa hã, te te pawaptob da, siptete na 're morĩ da, Zezusi hã. ");
INSERT INTO xavNT_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Tiwi robzei'õ uptabi nherẽ, ma tô duré mre, Timama ma, mreme 'rãihâ na. Taha wa, ma tô 're su'u a'a, dawapru ne, ti'ai wa. ");
INSERT INTO xavNT_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Tawamhã Timama ma, mreme pari, ma tô wahudu, tisiré 're ĩnomro mono norĩ u morĩ da apâ. Sõtõ za'ra ré, ma siza za'ra. Pẽ'ẽzé uptabi za'ra wa, te tinhotõ za'ra. ");
INSERT INTO xavNT_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Taha wa, te tãma nharĩ za'ra, ãne: — E marĩ wa, te asõtõ za'ra wa'wa. Aiwahutu za'ra wa'aba. 'Re ĩhâimana u'âsi mono wi, rowaptẽrẽ za'ra wa'aba asima, Wa'uburé nhimiwada'uri wi, te te aipawaptob za'ra wa'aba da. — Ãne te tãma nharĩ za'ra. ");
INSERT INTO xavNT_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Tawamhã Zezusi te te tãma nharĩ za'ra ré, ma ĩtẽme aihutu ni, da'ahâ na. Zudasi hã 12 na Zezusihi siré 're ĩnomro mono norĩ me hã aré, ta hã 're ĩmorĩ, te te sô danhimro, Zezusihi zô. Tawamhã Zezusihi u, ma ai'ré, 'râwi te te sawi da, tob'rata hârâ na. ");
INSERT INTO xavNT_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Taha wa, te Zezusi hã tãma tinha, ãne: — Zudasi, oro ĩ̱zawi pese 'wa zahã, ma ĩ̱tob'rata hârâ na taré dama ĩ̱zawi, ti'ai ãma dasiré ĩ̱podo hã da te ĩ̱waihu'u za'ra da. — Ãne te tãma tinha. ");
INSERT INTO xavNT_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Tawamhã ĩsiré 're ĩnomro mono norĩ hã ma tô oto waihu'u za'ra, da te oto dasiwi ĩ'âri da na hã. Taha wa, te siwi sadanha, ãne: — Wanhib'apito, e wa te da'wapé za'ra õ di za, wanhi'wa na, sib'ézé 'wapa na. — Ãne te sina sadanharĩ za'ra. ");
INSERT INTO xavNT_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Taha wa, Zezusihi siré hã ma da'u'a ni, sib'ézé 'wapa na. Sasedoti ĩpire uptabi ma romhuri'wa hã ma po're nhizâri ni, ĩsimire niwĩ. ");
INSERT INTO xavNT_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Tawamhã ma tô Zezusi hã tãma tinha, ãne: — Tô'ã. Tane hã 'manharĩ tõ. — Ãne te tãma tinha. Tawamhã ma po're upi, tinhib'rata na. Taha wa, ma tipo're wẽ apâ. ");
INSERT INTO xavNT_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Zezusihi zô ĩsihudu hã ta norĩ hã sasedoti ĩpire norĩ, duré 'Re ĩhâimana u'âsi mono nhorõwa 'madâ'â'wa norĩ, ĩpire norĩ, duré zudezu norĩ ma roti'wa norĩ. Taha wa, ma tô Zezusi hã tãma nharĩ za'ra, ãne: — E wa hã danhibrob zô dapãrĩ'wa pâ, ma bété we ĩ̱zô aihutu 'wa, sib'ézé 'wapa ré, uibroi ré zama. ");
INSERT INTO xavNT_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Bâtâ sidâpâsi, wa tô asõ'a wa'aba nasi aimasisi, 'Re ĩhâimana u'âsi mono ãma 're ĩdawata za'ra mono zéb ãma. E niha bâ tameb ré, asiwi ĩ̱'âri aba õ di bété. Ãhãna ma tô bâdâ hã ĩwa waptãrã, asiwi ĩ̱'âri aba zéb da hã, robra tede'wa hã pire na 're ĩmorĩzéb da hã. — Ãne ma tô Zezusi hã tãma waihu'u za'ra. ");
INSERT INTO xavNT_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Tawamhã ma tô oto siwi ti'â, Zezusi hã. Te te siwi âri wamhã, ma tô siwi saprõ, sasedoti u, ĩpire uptabi nhorõwa u. Pedru hã te romhâ na te te dapibu. ");
INSERT INTO xavNT_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","'Ri 'wawi wa'ra 're, da te dasima ĩpré za'ra u, ma wi, Pedru hã. Tame te nhamra Pedru hã, uzâ, da te dasiwi ĩ'uirĩ norĩ 'rata. ");
INSERT INTO xavNT_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Unhama ãma sãmra ré, ma tô pi'õ hã 'madâ, romhuri'wa hã. Taha wa, te 'madâ'â pese, te te waihu'u da. Te te waihu'u wamhã, te oto dama 'mahâ, ãne: — Ãhã zama, te Zezusihi siré 're mo. — Ãne te pi'õ dama wasu'u. ");
INSERT INTO xavNT_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Tane nherẽ, ma tô tiwi ai'udâ, ãne: — Mare di. Ĩ̱ma sa'rese õ di, ta hã. — Ãne te pi'õi ma tinha asa. ");
INSERT INTO xavNT_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Tawamhã ãma ronomro pari, te duré aibâ hã Pedru 'madâ, sãmra ré. Taha wa, te Pedruhu ma tinha, ãne: — A zama, te dasiré 're aimo. — Ãne te tãma tinha. Tazahã, Pedru te asa tãma tinha, ãne: — Mare di. Wa hã, õ norĩ siré hãi õ di. — Ãne te aibâ ma tinha. ");
INSERT INTO xavNT_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Tawamhã bâtâ pibuzé hã misi te te sa'oto wi, te duré ni'wa hã tãma tinha, ãne: — A hã te tô ĩsiré 're aimo. A hã, Darireza hawimhã duré. — Ãne te tãma tinha. ");
INSERT INTO xavNT_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Taha wa, te duré Pedru hã asa tãma tinha, ãne: — Mare di. Tane ĩ̱ma ĩnharĩ hã, te waihu'u õ di. Sa'rese õ di. — Ãne te aibâ ma tinha. Ãne na timreme hã te te 'rãsutu wi, ma awa'awi si'a hã hâ. ");
INSERT INTO xavNT_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Taha wa, ma tô Wanhib'apito hã aipi'ra. Sipi'rai wamhã, te Pedru hã 'madâ'â pese. Te te 'madâ'â wamhã, ma Wanhib'apito mreme na po're puru, Pedru hã. Romhâ ré, ma tô tãma waihu'u siro, te te dawi ĩ'udâzém na, Zezusi hã. Ãne ma tô tãma tinha: “Ã bâtâ na si'a hã hârâ õ ré, te za si'ubdatõ dawi ĩ̱'udâ, ĩ̱zadawa para õ nherẽ.” Ãne ma tô romhâ ré, Pedruhu ma waihu'u siro. ");
INSERT INTO xavNT_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Ãne na oto ĩmreme na sina po're pu'u wamhã, ma tô watobro rob u, Pedru hã. Taha wa, te oto aiwa'õ, sina pẽ'ẽzé uptabi wa. ");
INSERT INTO xavNT_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Tawamhã aibâ norĩ hã ma tô Zezusihi ma nharĩ wasété za'ra, siwi ĩ'madâ'â'wa norĩ hã. Te duré nasi siwi ahâ. ");
INSERT INTO xavNT_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Zazahâ na ma duré siwi 'rã ubu. Taha wa, te tãma nharĩ za'ra, ãne: — Ma'ãpé wama waihu'u zara na, ni'wa hã ai'azâri'wa hã. E niha ĩsisi hã. — Ãne te nasi tãma nharĩ za'ra, te te nasi siwi ahâri sina. ");
INSERT INTO xavNT_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Te duré tãma nharĩ wasété za'ra, ĩwasété na. ");
INSERT INTO xavNT_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Tawamhã mararé ma tô zudezu norĩ ma roti'wa norĩ hã si'rã'õtõ, duré sasedoti ĩpire norĩ hã, duré 'Re ĩhâimana u'âsi mono nhimiroti 'rata na rob'ui'éré na dama rowahutu'wa norĩ hã. Si'rã'õtõ wamhã, ma tô dama 'ru za'ra, Zezusi hã da te we dasiwi saprõni za'ra da, ĩtẽmeb za'ra. ");
INSERT INTO xavNT_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Da te ĩtẽme dasiwi ãwisi wamhã, te siwi sadanha, Zezusi hã, ãne: — E a hã 'Re ĩhâimana u'âsi mono te te ĩ'aipisudu, Danho'reptui'wa da. Ma'ãpé, wama asiwasu'u za'ra na. Taha wa, te Zezusi hã asa tãma nharĩ za'ra, ãne: — Danho'reptui'wa na aima ĩ̱siwasu'u za'ra wa'aba wamhã, e te za ãma ĩ̱zaze za'ra wa'wa. Ãté ãma ĩ̱zaze za'ra wa'aba õ di za. ");
INSERT INTO xavNT_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Duré, ĩ̱zadanharĩ za'ra wa'aba wa'rãmi, te asadanharĩ za'ra wa'aba wamhã, e marĩ te za ĩ̱ma ĩwaihu'u za'ra wa'wa. Marĩ hã ĩ̱ma waihu'u za'ra wa'aba õ di za. ");
INSERT INTO xavNT_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Tane nherẽ, wa hã ti'ai ãma dasiré ĩ̱podo hã, wa za oto dama ĩ̱pire na 're ĩ̱nhamra, dama ĩpire uptabi 'rata. Wa za oto ĩsimire niwĩ 're ĩ̱nhamra, 'Re ĩhâimana u'âsi mono 'rata. — Ãne te Zezusi hã tãma siwasu'u za'ra. ");
INSERT INTO xavNT_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Tawamhã te duré siwi sadanha, ãne: — E tawamhã, 'Re ĩhâimana u'âsi mono 'ra na, ma tô 're asi'madâ'â mo. — Ãne te siwi sadanha. Taha wa, te duré asa tãma nharĩ za'ra, Zezusi hã: — A norĩ wa'wa hã te ĩnharĩ za'ra wa'wa, tane na hã. — Ãne te tãma nharĩ za'ra. ");
INSERT INTO xavNT_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Tawamhã te sima nharĩ za'ra: — Tâibâ oto. Da te wama ĩwasu'u za'ra zéb zô, wanhimipari za'ra õ di za oto. Wasi'uihâ na wa tô ĩsiwasu'uzé hã wapari za'ra ni. — Ãne te sima nharĩ za'ra, dama ĩpire norĩ hã. ");
INSERT INTO xavNT_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Taha pari, ma tô aihĩni tiwahutu za'ra, Zezusi hã te te siwi saprõni da, Piratuhu u. ");
INSERT INTO xavNT_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Tawamhã te te ĩtẽme siwi ãwisi wamhã, ma tô siwi wasu'u wasété, ãne: — Ã hã ma tô dawi ro'wa'rutu, tinhimirowasu'u na. Roma ãma danhib'apito ma, rob'uiprazé hã da te tãma 're po'o za'ra mono tõ da, ma tô te te 're da'apa'uwati. Danhib'apito na te duré dama 're siwasu'u, 'Re ĩhâimana u'âsi mono te te ĩpisutu na, Danho'reptui'wa da. — Ãne te taré Zezusi wasu'u za'ra, Piratuhu ma. ");
INSERT INTO xavNT_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Tawamhã Piratu te Zezusihi ma tinha: — E a hã, zudezu norĩ nhib'apito. — Ãne te sadanha. Taha wa, ma tô Zezusi hã asa tãma tinha, ãne: — Tahata ma tô tane hã ĩ̱'ãma ĩwaihu tô. — Ãne ma tô tizadawa na tãma wa'rã, Zezusi hã. ");
INSERT INTO xavNT_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Tawamhã Piratu te dama tinha, ãne: — Ĩwasété na te waihu'u õ di, wasété wa, te ĩwẽ'õzéb da hã. — Ãne te sasedoti ĩpire norĩ ma nharĩ za'ra, 'Re ĩhâimana u'âsi mono ma da'ãma romhuri'wa ĩpire norĩ me, uburé dama zama. ");
INSERT INTO xavNT_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Tane nherẽ, te mreme tete na asa tãma nharĩ za'ra, ãne: — Tinhimirowasu'u na, ma tô te te dawi 're ro'wa'rutu, tinhimirowasu'u na, daza'rui mono bâ, Zudeza ãma. Darireza ãma, ma tô roti na sãna'rata. Ãhãta ma tô wei wi oto. — Ãne te taré wasu'u za'ra, Piratuhu ma, Zezusi hã. ");
INSERT INTO xavNT_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","7","Tawamhã te Piratu hã da'azadanha, damreme te te wapari wa: — E ã hã, Darireza hawi te wei mo. — Ãne te da'azadanha. — Ĩhe. Ta hawi te wei mo, tiza'rui hawi. — Ãne te asa tãma rowasu'u za'ra ni. Apito Erodi te te dama 're ĩroti mono zé, Darireza na danhipti'a nho'õmo nhisi hã. Taha wa, Piratu te te wapari wamhã, te tãma 'ru za'ra, Erodihi u te te siwi saprõni da, tame za a'â sãmra wa, Zeruzarẽ ãma. ");
INSERT INTO xavNT_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Erodi hã Zezusihi wasu'u hã ma tô te te 're wapari. Taha wa, ma tô te te sima 're wẽ u'âsi, Zezusi te te sabu da. Tawamhã, ĩtẽme da te dasiwi ãwisi wamhã, toi uptabi di Erodi hã, titõmo na te te oto 'madâ'â wa. Ĩsõ'a, marĩ dama ĩ'manharĩ waihu'u'õ hã tiwaihu'u pese na te te 'manharĩ da, ma tô aré sima wẽ, Erodi hã. ");
INSERT INTO xavNT_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Taha wa, ma tô Erodi hã marĩ na sadanharĩ ahâ, Zezusi hã. Tazahã, te te sada'âbâ õ di asa. ");
INSERT INTO xavNT_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Taha wa, te oto Erodihi u aimasa, sasedoti ĩpire norĩ hã. Rowahutu'wa norĩ me, te ĩtẽme aimasa. Mreme tete sina, ma taré siwi pisutu za'ra, Zezusi hã. ");
INSERT INTO xavNT_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Tawamhã Erodi norĩ hã ma tô Zezusihi ãma tiwa'ẽ za'ra, taré. Tinhib'a'uwẽ norĩ me, ma ãma tiwa'ẽ za'ra, da'wapéi'wa norĩ me. Ma tô ãma tito za'ra. Dasi'ubuzém na ma tô siwi ãma hâiba ubu, ĩwẽ na. Tawamhã Erodi hã te oto dama ti'ru, apâ da te dasiwi saprõni da, Piratuhu u. Taha wa, te apâ siwi saprõ. ");
INSERT INTO xavNT_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Piratu norĩ hã Erodihi me, te aré 're si'ruiwapari zahuré. Ãhãna, ma tô oto sisawi zahuré. ");
INSERT INTO xavNT_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Tawamhã Piratu te sitẽme dazô hâ, sasedoti ĩpire norĩ zô, 'Re ĩhâimana u'âsi mono ma, da'ãma romhuri'wa ĩpire norĩ zô. Duré roti'wa norĩ zô, te tihârâ za'ra, ĩsib'a'uwẽ norĩ me, te te ĩtẽme ubumro da. ");
INSERT INTO xavNT_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","Ĩtẽme sihutu wamhã, te tãma nharĩ za'ra: — We ĩ̱tẽme asiwi ãwisi aba wi hã, ma tô ãne ĩ̱ma ĩwasu'u za'ra wa'wa: “Ãhã nhimirowasu'u zarina, te oto ro'wa'rutu na 're dahâimana za'ra.” Ãne ma tô ĩ̱ma ĩwasu'u za'ra wa'wa. Taha wa, wa tô asõ'a za'ra wa'aba, sadanharĩ pese aré, ĩwasété zô, ĩwasédé hã ãma sa'ra za'ra wa'aba wa. Tazahã, marĩ hã ãma hâimana õ di, ĩwasédé hã. ");
INSERT INTO xavNT_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Erodi hã te te duré sadanharĩ wamhã, marĩ hã te te ĩ'manharĩ wasété zé hã te te duré ãma sõpẽtẽ õ di. Taha wa, ma tô we apâ watẽme satõrĩ za'ra, marĩ hã ãma hâimana õ wa. Marĩ te te 'manharĩ wasété õ nherẽ, e niha wa za dama ti'ru, da te dasiwi wĩrĩ da. Mare di. ");
INSERT INTO xavNT_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Taré wa za da'wapéi'wa norĩ ma 'ru za'ra, te te siwi 're pré'é mono da. Taha parimhã, wa za satõ, apâ morĩ da. — Ãne te Piratu hã tãma nharĩ za'ra. ");
INSERT INTO xavNT_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Pascowa na dasaihurizép sidâpâsi, ma tô Piratu hã dazazém hawi te te 're da'azani, misi si. ");
INSERT INTO xavNT_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Tawamhã aihĩni te damreme 'rãihâ na tãma nharĩ za'ra ni, ãne: — Da te dasiwi wĩrĩre. Barabasihi si, wama wazere za'ra na apâ. — Ãne te ãma 'mahârâ za'ra ni, Piratu hã. ");
INSERT INTO xavNT_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Barabasi hã dazazéb 're, te dame 're sa. Ĩsimiroti zarina, ma tô dasi'wapé hã watobro, romanu norĩ zada, Zeruzarẽ ãma. Ma tô duré da'maiwĩ, Barabasi hã. Taha wa, ma tô dasiwi sẽrẽ ni, dazazéb 're, sab da. ");
INSERT INTO xavNT_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Piratu hã ma tô sima wẽ, Zezusi hã apâ te te satõrĩ da. Taha wa, te ãne duré dama tinha. ");
INSERT INTO xavNT_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Tane nherẽ, damreme 'rãihâ na te nasi 'mahârâ za'ra ni, ãne: — Wedepo'o nhonhi'rãmi na, da te dasiwi sasõmri, dâ'â da. — Ãne te nasi 'mahârâ za'ra ni. ");
INSERT INTO xavNT_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Tawamhã te Piratu hã duré dama tinha: — E marĩ te te 're ab'manharĩ wasété mono bâ. Ĩwasété zô, te sadanharĩ wamhã, marĩ hã ãma hâimana õ di. E niha wa za bété taré dama ti'ru, da te dasiwi wĩrĩ da. Mare di. Taré wa za ti'ru, da te dasiwi 're pré'é mono da. Taha parip si, te za mo, ĩ̱zadawa para. — Ãne Piratu te dama tinha. Si'ubdatõ oto ĩmreme hã. ");
INSERT INTO xavNT_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Tane nherẽ, te aihĩni norĩ hã ãma sé za'ra, mreme 'rãihâ na, ãne: — Wedepo'o nhonhi'rãmi na sa'o, dâ'â da. — Ãne te nasi 'mahârâ za'ra ni. Taha wa, Piratu ma tô oto dawapa. ");
INSERT INTO xavNT_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Da te tiwi ĩwaptẽrẽzéb uwaibaba, ma tô pisutu, wedepo'o nhonhi'rãmi na sa'o da, Zezusi hã, dâ'â da. ");
INSERT INTO xavNT_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Da te dasima ĩwẽ za'ra zéb uwaibaba, ma tô dama ti'ru, aibâ, da te wazere da, dazazém hawi watobro da, apâ morĩ da. Aibâ nhimiroti zarina, ma tô dasi'wapé hã watobro aré, romanu norĩ zada hã. Ma tô duré da'maiwĩ, aibâ hã. Taha wa, ma tô sẽrẽ ni, dazazéb 're, sab da. Tawamhã Piratu te oto ti'ru, Zezusi hã te te siwi âri da da'wapéi'wa norĩ hã, da te dasima ĩwẽ za'ra zéb uwaibaba, te te tãma 'manharĩ za'ra da, Zezusihi ma. ");
INSERT INTO xavNT_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Tawamhã Zezusi hã te oto siwi saprõ, ĩdâ'âzéb u. Te te siwi saprõni ré, ma tô buru hawimhã aibâ hã da'razâ. Aibâ nhisi hã, Sima na ĩsisi hã. Simahã za'ru nhisi hã, Sireni na. Te te da'razâri wa, ma tô siwi pa'â, da'wapéi'wa norĩ hã. Ĩsisé ma tô tãma hiri za'ra wedepo'o nhonhi'rãmi hã, Zezusihi zarina te te âri da. Taha wa, te ĩsarina ti'â. ");
INSERT INTO xavNT_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Tawamhã da'ahâ na te Zezusihi zarina ai'aba'ré ni. Pi'õ zama, te dame ai'aba'ré, wawa sina. Zezusihi ãma pẽ'ẽzé uptabi za'ra wa, te 'ry'ry. ");
INSERT INTO xavNT_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Taha wa, Zezusi hã ma tô ĩtẽme aipi'ra za'ra, pi'õ norĩ u, te te tãma nharĩ za'ra da, ãne: — Pi'õ norĩ, Zeruzarẽ ãma 're ai'ubumroi wa'aba mono norĩ hã, ĩ̱zô ai'ry'ry wa'aba tõ. Ãté asisô si, te za 're ai'ry'ry wa'aba mo, ai'ra norĩ zô zama. ");
INSERT INTO xavNT_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Niwapsi dama 're rowasété za'ra mono di za. Taha wa, te za nharĩ za'ra ni, ãne: “Pi'õi 'ra'õ norĩ ma si, 're rowẽ za'ra mono di za, duré niwa ai'uté te te ĩwapsõmri za'ra õ norĩ ma zama.” Ãne te za nharĩ za'ra ni. ");
INSERT INTO xavNT_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Duré dama rowasété wapsi, ẽtẽ 'rãihâ ma, te za tasi'ru za'ra ni, danhisiwi waptã'ã da, te te da'uprosi da. Duré sa'a ma, te za tasi'ru za'ra ni, te te dazuwa za'ra da. ");
INSERT INTO xavNT_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","E marĩ da, wa tô romhâ ré aima rowa'õtõ za'ra wa'wa. Ãhãna, mi wapti'i ré, te za oto rowasédé hã ĩ̱ma 'manharĩ za'ra ni. Mi hã 'ré wamhã, e niha za bété. Dama 're rowasété uptabi za'ra mono di za. — Ãne te Zezusi hã pi'õ norĩ ma nharĩ za'ra. ");
INSERT INTO xavNT_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Zezusihi me, te aibâ norĩ hã dasiwi saprõni zahuré ni, ĩsiré dâ'â zahuré da, ta norĩ hã. Rowasété 'manharĩ'wa zahuré, aibâ norĩ hã. ");
INSERT INTO xavNT_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Tawamhã ma tô oto ãwisi za'ra, Da'rãihi na romnhisi u. Tame ma tô siwi sasõ Zezusi hã, wedepo'o nhonhi'rãmi na dâ'â da. Ma duré rowasété 'manharĩ'wa norĩ hã ĩsiré sasõmri zahuré ni. Te ãma aiwa'aba zahuré, ĩsimire niwĩ, duré ĩsimi'e niwĩ. ");
INSERT INTO xavNT_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Tawamhã Zezusi hã te Timama ma tinha, ãne: — Ĩ̱mama, da'ãma 'madâ'â õ di za, da te ĩ̱ma ĩ'manharĩ wasété za'ra zé hã. Da te dasiwi ĩ̱waihu'u ãna, ma tô ĩ̱ma 'manharĩ wasété za'ra ni. — Ãne te Timama ma tinha, Zezusi hã. Tawamhã ẽtẽ zapotore ĩ'ui'éré ré hã ma tô nasi sima sãmra, Zezusihi uzazéb zô. Taha zarina, ma tô sima ãma aipé. ");
INSERT INTO xavNT_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Zezusi norĩ hã simnhatã ré, te zudezu norĩ hã ĩ'rata asimro, te te 'madâ'â za'ra da. Taha wa, te roti'wa norĩ hã sima nharĩ za'ra, ãne: — Ma tô te te 're da'anho'reptu aré. Tô sena Danho'reptui'wa da, 'Re ĩhâimana u'âsi mono te te pisutu wamhã, ma'ãpé sisõ'reptu. — Ãne ma tô ãma tiwa'ẽ za'ra. ");
INSERT INTO xavNT_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Da'wapéi'wa norĩ zama, ma tô ãma tiwa'ẽ za'ra. Tawamhã ma ĩtẽme ai'ré za'ra, te te tãma wẽ za'ra da, uwa 'ru 'rãi wa'u ĩsé hã, ĩwa'âbâ syry hã. ");
INSERT INTO xavNT_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","Ãne te tãma nharĩ za'ra: — A hã zudezu norĩ nhib'apito wamhã, ma'ãpé asisõ'reptu na. — Ãne te tãma nharĩ za'ra, da'wapéi'wa norĩ hã. ");
INSERT INTO xavNT_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Zezusihi 'rãi uwaibaba, te ãma ĩrob'ui'éré ré hã da'o. “Ã hã, zudezu norĩ nhib'apito.” Ãne ãma ĩrob'ui'éré hã. ");
INSERT INTO xavNT_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Tawamhã rowasété 'manharĩ'wa hâiba amo hã te tãma tinha, ãne: — A hã Danho'reptui'wa da, 'Re ĩhâimana u'âsi mono te te aipisutu wamhã, ma'ãpé asisõ'reptu na. Wa norĩ zama, wanho'reptu na. — Ãne te Zezusihi ma tinha, wa'ẽ sina. ");
INSERT INTO xavNT_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Taha wa, ma ĩsiré hã ãma sadapsisi, ãne: — Tô'ã. E 'Re ĩhâimana u'âsi mono nhimihâzé, asima pipa ã bâ, ma tô tane tãma ĩnha. Wa norĩ hã wa wasiré waza'o ni, apito nhimiwada'uri zarina. Taré, da te wama rob'manharĩ õ di, dasiwi. ");
INSERT INTO xavNT_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Wa norĩ hã wawasété wa, ma tô wama rob'manharĩ ni. Tazahã, ã hã marĩ hã te te dama 'manharĩ wasété õ di. — Ãne te tãma tinha. ");
INSERT INTO xavNT_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Taha wa, te Zezusihi ma tinha, ãne: — Zezusi, ĩ̱'ãma aipo're pu'u za, Danhib'apito na apâ we aimorĩ wamhã. — Ãne te Zezusihi ma tinha. ");
INSERT INTO xavNT_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Taha wa, te Zezusi hã asa tãma tinha, ãne: — Tô sena wa za aima waihu'u. Ã bâtâ na te za ĩ̱'rata 're asãmra mo, rowẽ uptabi ãma. — Ãne ma tô aibâ ma ropisutu, Zezusi hã. ");
INSERT INTO xavNT_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Tawamhã ma tô ti'abzuma oto. Abzuma wamhã, ma tô tirobra, daro mono bâ. Bâdâ siprazéb u, te oto robra si nomro. ");
INSERT INTO xavNT_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Bâdâ sipra wi, ma tô zazahâ hã hâihaipo'o, 'ri 're wa'wa nhitobzé hã, 'Re ĩhâimana u'âsi mono ãma 're ĩdawata za'ra mono zéb ãma hã. ");
INSERT INTO xavNT_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Taha wa, ma tô Zezusi hã Timama ma tinha, mreme 'rãihâ na: — Ĩ̱mama. Ãhãta, wa za ĩ̱pẽ'ẽzani hã aima tisõ, asib'rata. — Ãne te si'mahâ, mreme 'rãihâ na. Tawamhã awa'awi ma pẽ'ẽ hai'utõ oto. ");
INSERT INTO xavNT_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Tawamhã aibâ hã ma tô ãma rob'madâ, da'wapéi'wa norĩ wada'uri'wa hã, romanu hã. Te te ãma rob'madâ'â wamhã, te ãma tiwata, 'Re ĩhâimana u'âsi mono ãma. Ãne te tinha: — Nare õ hã, aibâ 're ĩmorĩ wẽ tô. — Ãne te tinha. ");
INSERT INTO xavNT_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Tawamhã da'ahâ na ma tô tasi'rã'õtõ ni, da te ãma rob'madâ'â za'ra da. Tawamhã Zezusi hã dâ'â wi, te 'ri tẽme apâ ai'aba'ré ni, dawawa sina. Ãma dapẽ'ẽzé uptabi za'ra di. ");
INSERT INTO xavNT_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Zezusihi zawi pese'wa norĩ hã, romhâ na ma tô ãma 'madâ'â za'ra. Pi'õ norĩ zama, te romhâ na ãma 'madâ'â za'ra, Darireza hawi ĩsarina ĩsi'aba'ré norĩ hã. ");
INSERT INTO xavNT_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","51","Aibâ hã te 're hâimana, Zuzé na ĩsisi hã. Arimateza na ĩsa'ru nhisi hã, Zudeza na danhipti'a nho'õmo nhisi ãma. Aibâ hã ĩwẽ. Hâimana wẽ uptabi di, dama. 'Re ĩhâimana u'âsi mono, da'ãma 're ĩsib'a'uwẽ mono zéb zô, te 're simipari u'âsi. Ta hã, roti'wa ĩpire. Zudezu norĩ ma roti'wa ĩpire norĩ siré, te 're simasisi. Tazahã, Zezusi te te siwi âri da, te te sima ãma roti za'ra wamhã, te te ãma dazazei õ di. ");
INSERT INTO xavNT_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Zezusi hã dâ'â wamhã, te oto Piratuhu u mo Zuzé hã, Zezusihi hâiba hã te te tiwi waptẽrẽ da. ");
INSERT INTO xavNT_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Taha wa, ma tô ãma saze, Piratu hã. Taha wa, ma tô si'ra, wedepo'o nhonhi'rãmi hawi, Zuzé hã. Te te si'rai wamhã, ma tô hâiba ubu, zazahâ ĩhâirã na. Taha pari, ma tô tisẽ, ab're wa, ẽtẽ zahâpâ ab're sirõmo wa. Tame ma tô Zezusihi hâiba hã tisẽ, da te ĩwa ĩda'manherẽ'õ wa. ");
INSERT INTO xavNT_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Ãhã romhuri 'rãsutu na ma tisẽ. Romhutu na te za zudezu norĩ hã romhuri zahârizé hã 'madâ'â za'ra. ");
INSERT INTO xavNT_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Tawamhã Zuzé hã ab're u morĩ wamhã, ma tô pi'õ norĩ hã ĩsarina ai'aba'ré. Zezusihi zarina, Darireza na danhipti'a nho'õmo nhisi hawi we ĩsi'aba'ré, pi'õ norĩ hã. Tawamhã ab're hã ma tô sabu za'ra. Duré Zezusihi hâiba, Zuzé te te ĩsẽrẽzé hã ma tô sabu za'ra. ");
INSERT INTO xavNT_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Tawamhã 'ri tẽme te apâ ai'aba'ré. Taha wa, ma tô marĩ hã sada wa'u za'ra, wedewa'u ĩsadaze hã, te te siwi ãma hâiba u'ré da. Romhuri zahârizém na hã ma tô tiwa'utu za'ra, 'Re ĩhâimana u'âsi mono te te ĩpisutuzéb zarina. ");
INSERT INTO xavNT_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Dumidu na rowa'a wi, te pi'õ norĩ hã ai'aba'ré, ab're u. Marĩ wa'u te siré âri za'ra, ĩsadaze hã. ");
INSERT INTO xavNT_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Ab're u sihutu wamhã, ẽne ma tô 'madâ'â za'ra, ab're nhitobzé hã. Sitob õ di oto. Ni'wa hã ma tô ab're nhiti pi'ra. ");
INSERT INTO xavNT_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Tawamhã sisisi wamhã, te te sãmri za'ra õ di, Wanhib'apito Zezusihi hâiba hã. Robaba di. ");
INSERT INTO xavNT_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Te te waihu'u za'ra õ wa, te ãne sima rosa'rata za'ra: — E niha ab're hã baba di. E mahãta ĩhâiba. — Ãne te sima sô amrami za'ra. Tawamhã aibâ norĩ hã maparane ma ĩtẽme aima'wa. Ĩ'uza hã ma ai'ubuzi zahuré. ");
INSERT INTO xavNT_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Taha wa, ma tô pi'õ norĩ hã tãma tipahi za'ra. Pahi te, ma tô aiwẽ'ẽ za'ra, ti'ai u. Taha wa, te ãne tãma nharĩ za'ra, pi'õ norĩ ma: — E niha da, te ĩhâiba zô ĩrob'madâ'â za'ra wa'wa, adâ'â 'ru ãma. Apâ ma tô hâiwa'udu. ");
INSERT INTO xavNT_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","7","Ãme nomro õ di oto. Ma tô hâiwa'udu. Darireza ãma 're sãmra mono ré, ma tô romhâ ré aima siwasu'u sirõmo za'ra wa'wa aré, ãne: “Wa hã ti'ai ãma dasiré ĩ̱podo hã te za dama ĩ̱nhomri ni, aibâ ĩwasété norĩ ma. Wedepo'o nhonhi'rãmi na te za dasiwi ĩ̱zasõmri ni, ĩ̱dâ'â da. Bâdâ maparane ĩ̱'ãma si'utõrĩ õ ré, wa za apâ hâiwa'udu.” Ãne ma tô romhâ ré aima siwasu'u sirõmo za'ra wa'wa. — Ãne ma tô Zezusihi mreme na ãma po're pu'u za'ra, aibâ norĩ hã. ");
INSERT INTO xavNT_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Taha wa, ma tô pi'õ norĩ hã ãma tipo're pu'u za'ra, Zezusihi mreme na. ");
INSERT INTO xavNT_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Taha pari, te ab're hawi apâ ai'aba'ré, ĩsazei'wa norĩ u. Aibâ 11 na ĩhâiba za'ra norĩ ma, ma tô rowasu'u pese za'ra, Zezusihi siré 're ĩnomro mono norĩ ma. Ĩsiré ĩsi'ubumro norĩ ma zama, ma tô tãma rowasu'u pese za'ra. ");
INSERT INTO xavNT_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Pi'õ norĩ nhisi hã, ãne: Mariza Madarena, duré Zuwãna, duré Mariza, Ti'aduhu na. Ta norĩ hã ĩsiré pi'õ norĩ me, ab're u ĩsi'aba'ré hã, te Zezusihi zadawa wasu'u'wa norĩ ma rowasu'u pese za'ra. ");
INSERT INTO xavNT_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Tane nherẽ, ĩsimirowasu'u na te te saze za'ra õ di, taré newa. ");
INSERT INTO xavNT_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Tane nherẽ, Pedru hã ma tô wahudu, ab're u wara da, te te sabu da. Ab're u wisi wamhã, ma tô sô aiwẽ'ẽ, te te sô rob'madâ'â da. Sô siwẽ'ẽi wamhã, ĩ'ubuzéb si, ma tô sabu. Taha wa, ma tô apâ mo 'ri tẽme, tob'uzu sina, marĩ hã ĩhâimana na. ");
INSERT INTO xavNT_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Tawamhã tô taha bâtâ na te tineb zahuré, Emausi na 'ri wa'õtõ nhisi u, Zezusihi zazei'wa norĩ hã. Zeruzarẽ hawi te tineb zahuré, 'ri wa'õtõ u. Zeruzarẽ hawimhã, 10 na ti'ai pibuzé hã, Emausi u hã. ");
INSERT INTO xavNT_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Nep sina, ma tô te te sima rowasu'u zahuré, uburé marĩ hã ĩwairébé mono na. ");
INSERT INTO xavNT_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Te te sima rowasu'u zahuré mono ré, duré ãma sisada'âbâ zahuré mono ré, ma tô Zezusi hã ãma tiwisi zahuré. Te oto ĩme timorĩ zahuré. ");
INSERT INTO xavNT_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Titõmo na ma tô 'madâ'â zahuré. Tane nherẽ, te te waihu'u zahuré õ di, ni'wa newa. ");
INSERT INTO xavNT_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Tawamhã Zezusi te sadanharĩ zahuré, ãne: — E marĩ, te asima ĩwasu'u wa'aba mo, bâdâdi na ane wa'aba sina. — Ãne te sadanharĩ zahuré. Taha wa, ma tô mazahâri zahuré. Ubu pire zahuré di. ");
INSERT INTO xavNT_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Tawamhã ma tô ĩhâiba amo hã sadanha, Tezopasi na ĩsisi hã: — Zeruzarẽ ãma 're asãmra mono nherẽ, e aiwétési aima ĩsa'rese õ, ã nimosi marĩ hã ĩwairébé mono hã. — Ãne te sadanha, Tezopasi hã. ");
INSERT INTO xavNT_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Taha wa, ma tô Zezusi hã asa sadanharĩ zahuré: — E marĩ, wairébé mono bâ bété. — Ãne te sadanharĩ zahuré. — Zezusi, Nazaré hawi ĩmorĩ ma, ma tô rob'manharĩ wasété za'ra ni. 'Re ĩhâimana u'âsi mono zadawa wasu'u'wa, te 're mo aré. Tiwaihu'u pese na ma tô marĩ hã te te dama 're ab'manharĩ aré, ĩwẽ hã. Duré mreme pire na, te 're mo. Ãne na ma tô waihu'u, 'Re ĩhâimana u'âsi mono hã. Ãne na hã uburé ma tô waihu'u za'ra ni. ");
INSERT INTO xavNT_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Tane nherẽ, wa'madâ'â'wa norĩ hã sasedoti ĩpire norĩ hã ma tô danhib'apito u siwi saprõ. Roti'wa norĩ dama ĩpire norĩ me, ma tô ĩtẽme siwi saprõ, te te dama 'ru za'ra da, da te dasiwi wĩrĩ da. Taha wa, ma tô ĩsimiwada'uri zarina, dasiwi sasõmri ni, wedepo'o nhonhi'rãmi na dâ'â da. ");
INSERT INTO xavNT_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Izarazéhé nhihudu norĩ hã, danhimiwada'uri na oto 're wahâimana za'ra mono tõ da, te te 're wa'apawapto mono da ne, wa tô 're wanhimnhasi za'ra aré. Ãhãna bâdâ maparane ma tô ãma ne, da te ĩwĩrĩzém na hã. ");
INSERT INTO xavNT_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","23","Ni'wam norĩ hã pi'õ norĩ hã ma tô ai'aba'ré ab're u, wasiré ĩsazei'wa norĩ hã. Tane nherẽ, te te siwi sãmri za'ra õ di, ĩhâiba hã. Ab're hã baba na, ma tô sô sabu za'ra. Apâ sihutu wamhã, ãne te wama rowasu'u za'ra: “'Re ĩhâimana u'âsi mono ma romhuri'wa norĩ si, wa tô wasiwi 'madâ'â za'ra ni, hâiwa hawi we ĩne hã. Zezusi hã, u, dâ'â õ di. Te u, oto 're mo. Ãne ma tô wama rowasu'u zahuré.” Ãne te pi'õ norĩ hã wama rowasu'u za'ra. Taha wa, wa tô ãma watob'uzu za'ra ni, ĩsimirowasu'u za'ra na hã. ");
INSERT INTO xavNT_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Taha wa, ma tô wasiré norĩ hã 'mane, pi'õi wa'rãmi, ab're u. Te te robzabu zahuré wamhã, ab're hã baba na ma tô duré sabu zahuré, pi'õ norĩ nhimirowasu'u zarina. Te duré wama rowasu'u za'ra, Zezusihi hâiba hã te te ĩsãmri zahuré õ na. — Ãne te tãma rowasu'u zahuré, Zezusihi ma, Tezopasi norĩ hã. ");
INSERT INTO xavNT_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","26","Tawamhã Zezusi hã te asa tãma nharĩ zahuré, ãne: — E niha bété, waihu'u su'u aba õ di, sazei aba da, 'Re ĩhâimana u'âsi mono zadawa wasu'u 'rata 'wa norĩ nhimirowasu'u mono bâ, Danho'reptui'wa na rob'ui'éré hã. Danho'reptui'wa da, 'Re ĩhâimana u'âsi mono te te ĩpisudu hã te za a'â robzépata, rowasédé, da te tãma 'manharĩ wamhã. Taha parip si, te za rowẽ ãma 're sãmra, 'Re ĩhâimana u'âsi mono te te tãma ĩpisutuzéb uwaibaba. — Ãne ma tô Zezusi hã tãma waihu'u zahuré, sõ'awi tãma siwasu'u zahuré õ nherẽ, Danho'reptui'wa na. ");
INSERT INTO xavNT_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Romhâ ré, ma tô ĩwana Danho'reptui'wa na rob'ui'éré za'ra ni. Tawamhã Mozési te te ãma ĩrob'ui'éré na, te oto tãma rob'rãzarõtõ zahuré. Taha pari, uburé 'Re ĩhâimana u'âsi mono zadawa wasu'u 'rata 'wa norĩ, te te ãma ĩrob'ui'éré za'ra na, te tãma rob'rãzarõtõ zahuré. ");
INSERT INTO xavNT_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Tawamhã ma tô rob'umhutu za'ra oto, 'ri wa'õtõ u hã, Emausi u hã. Zezusi hã te aré tiwi timorĩ waré zahuré. ");
INSERT INTO xavNT_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Taha wa, ma tô tãma nharĩ zahuré, tiwi morĩ zahuré tõ da: — Wa'rata asãmra a'â. Ma tô wawi tihâiwahâ. Te za wawi tirobra. — Ãne te tãma nharĩ zahuré. Taha wa, ma tô ãzé 'ri para u, ĩ'rata sãmra zahuré da, a'â. ");
INSERT INTO xavNT_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Tawamhã ĩ'rata te tinhamra zahuré, siré saihuri da. Sãmra wamhã, ma tô ĩ'u'ẽne hã ti'â, Zezusi hã. 'Re ĩhâimana u'âsi mono ãma te tiwata, sõpru wa. Taha pari, ma tô te te wẽ'ẽ, ĩ'u'ẽne hã. Ma tô tãma sõmri zahuré. ");
INSERT INTO xavNT_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Taha wa, ma tô oto waihu'u zahuré, Zezusi hã. Tazahã, ma tô tiwi aimani zahuré. ");
INSERT INTO xavNT_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Taha wa, te ĩsa'u sima rowasu'u zahuré, ãne: — Bâdâdi na we te te wama rowasu'u mono ré hã, e watoi õre, wapẽ'ẽ 'remhã. Wato sina, wa we wa te wapari. Wapari ze ti. — Ãne te sima rowasu'u zahuré. ");
INSERT INTO xavNT_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Tawamhã awa'awi, ma tô tiwahutu zahuré, Zeruzarẽ u neb da apâ. Simasisi wamhã, ma tô Zezusihi siré norĩ hã sabu za'ra, 11 na ĩhâiba za'ra hã. 'Ri para, te siré ai'ubumro, ĩsazei'wa norĩ me. ");
INSERT INTO xavNT_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","— Tô sena, ma tô Wanhib'apito hã hâiwa'udu. Simahã ma, ma tô sihâi'ré. — Ãne te tãma rowasu'u za'ra, datẽme ĩsimasisi norĩ ma. ");
INSERT INTO xavNT_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Tawamhã Wanhib'apito, bâdâdi na ĩtẽme ĩwisi zahuré na, ma tô asa dama rowasu'u zahuré, ĩsazei'wa norĩ ma. Duré, Wanhib'apito te te ĩwaihu'u zahuré zém na, ma tô siwasu'u zahuré. Ĩ'u'ẽne te te tãma ĩwẽ'ẽ zahuré na, ma tô duré Wanhib'apito hã waihu'u zahuré. Ãne na ma tô siwasu'u zahuré, Zezusihi zazei'wa norĩ ma. ");
INSERT INTO xavNT_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Tawamhã ĩsazei'wa norĩ ma, te te rowasu'u zahuré ré, ma tô Zezusi hã ĩwa'wa tizab za'ra. Ãne te tãma nharĩ za'ra: — Rowẽ na 're aihâimana za'ra wa'aba mono. — Ãne te tãma nharĩ za'ra. ");
INSERT INTO xavNT_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Tawamhã dahâiba warõ newa, ma tô tãma tipẽ'ẽwara za'ra. ");
INSERT INTO xavNT_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Taha wa, te Zezusi hã tãma nharĩ za'ra, ãne: — E marĩ da, ma tô ĩ̱ma aipẽ'ẽwara za'ra wa'wa. E marĩ da, ma tô ĩ̱wawã za'ra wa'wa, ĩ̱hâiwa'utuzém na. ");
INSERT INTO xavNT_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Ĩ̱nhib'rada, 'madâ'â za'ra wa'aba. Duré ĩ̱para hã 'madâ'â za'ra wa'aba. Ma'ãpé oto ĩ̱zaze za'ra wa'aba. Wa hã tô, Zezusi. Dahâiba warõ hã nhi õ di, duré hi õ di. Wa hã ĩ̱nhi ré hã, duré ĩ̱hi ré hã. Ma'ãpé asib'rata na ĩ̱'upi za'ra wa'aba, tô sena ĩ̱zaze za'ra wa'aba da. ");
INSERT INTO xavNT_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","— Ãne ma tô Zezusi hã tãma si'ru za'ra. Taha wa, ma tô tinhib'rada hã tãma sõ'a za'ra, duré tipara hã. ");
INSERT INTO xavNT_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Ĩmreme te te wapari za'ra wamhã, te 're to za'ra, tipẽ'ẽ na. Tãma rowẽ uptabi za'ra di. Tane nherẽ, Zezusi hã hâiwa'utu õ newa, te te ãma saze za'ra õ di. Taha wa, mrab zô te sadanharĩ za'ra oto, Zezusi hã: — E mra, te aima tihâimana za'ra wa'wa. — Ãne te sadanharĩ za'ra. ");
INSERT INTO xavNT_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Tawamhã syry na ma tô tãma sõmri za'ra, tepe zebre hã. ");
INSERT INTO xavNT_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Tawamhã ma ti'â, te te 'rẽne da, ĩsõ'a za'ra. ");
INSERT INTO xavNT_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Taha wa, te Zezusi hã tãma nharĩ za'ra, ãne: — Romhâ ré wa tô aima rowasu'u za'ra wa'wa, ai'rata 're ĩ̱nhamra za'ra wa'aba mono ré hã, marĩ hã za ĩ̱zô ĩwairébé mono na, Mozésihi nhimi'ui'éré zarina, duré 'Re ĩhâimana u'âsi mono zadawa wasu'u 'rata 'wa norĩ nhimi'ui'éré zarina, duré ĩsõ're na rob'ui'éré zarina. — Ãne te Zezusi hã tãma nharĩ za'ra. ");
INSERT INTO xavNT_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","46","Tawamhã ma tô ãne tãma waihu'u za'ra, ĩbaihâ na rob'ui'éré zarina: — Romhâ ré ma tô ãne ĩ̱'ãma rob'ui'éré za'ra ni: “Danho'reptui'wa te za robzépata za'ẽtẽ, 'Re ĩhâimana u'âsi mono te te ĩpisudu hã. Tane nherẽ, bâdâ maparane ãma si'utõrĩ õ ré, te za hâiwa'udu apâ, ab're hawi. ");
INSERT INTO xavNT_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Duré, te za ĩwasu'uwẽ na ĩsadawa para te te 're dapo're pu'u za'ra, ãne: ‘Dawasédé hã te za da te 're rẽme pese za'ra. Tawamhã te za te te dama 're apari dawasédé hã, 'Re ĩhâimana u'âsi mono hã.’ Ãne te za ĩwasu'uwẽ na uburé te te ãma 're dapo're pu'u za'ra, daro mono bâ. Zeruzarẽ ãma ĩsãna'rada hã za.” Ãne ma tô duré romhâ ré ãma rob'ui'éré za'ra, ĩbaihâ na hã. ");
INSERT INTO xavNT_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","A norĩ wa'wa hã ma tô ĩ̱'ãma ĩ'madâ'â za'ra wa'wa, ĩ̱dâ'âzé hã. Duré ĩ̱hâiwa'utuzé hã ma tô ĩ̱'ãma ĩwaihu'u za'ra wa'wa. Taha wa, te za ĩ̱wasu'u wẽ'wa, 're anomro aba mo. ");
INSERT INTO xavNT_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Wa hã wa za we atẽme satõrĩ za'ra wa'wa, Ĩ̱mama te te aima ĩropisutu za'ra wa'aba zéb zarina. Taha wa, te za a'â 'ri ahâ ãma sô asimipari za'ra wa'wa, hâiwa hawi te we atẽme ĩsatõrĩ za'ra wa'aba zéb u, ĩ̱waihu'u pese na 're ĩ̱morĩ ne, 're anomro aba mono da. — Ãne te Zezusi hã tãma nharĩ za'ra, tisiré 're ĩnomro mono norĩ ma. ");
INSERT INTO xavNT_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Tawamhã Zezusi hã ma tô tisiré 're ĩnomro mono norĩ hã te te simro, 'ri ahâ nhiti, Betãnha na 'ri wa'õtõ nhisi u. Tamomo te te rob'umhutu za'ra wamhã, ma tô tinhib'rada hã wahutu, tisi hawimhã, ĩwẽ hã te te tãma sõmri za'ra da, Zezusi hã. ");
INSERT INTO xavNT_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Tawamhã taha ré, ma tô tiwi timorĩ za'ra. Ĩmama hã ma tô tiwi âri za'ra, hâiwa u. ");
INSERT INTO xavNT_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Tawamhã ĩsa'u, te Zezusihi ãma tiwata za'ra, hi'rãtitõ. To sina, te apâ ai'aba'ré, Zeruzarẽ u. ");
INSERT INTO xavNT_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Tawamhã 'Re ĩhâimana u'âsi mono ãma 're ĩdawata za'ra mono zéb ãma, te 're si'ubumroi u'âsi, 'ri 'wawi wa'ra 're, ãma 're wata u'âsi za'ra mono da.");
INSERT INTO xavNT_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Duréihã ti'ai õ ré hã, marĩ õ uptabi di. Ropoto na te te sãna'rata õ ré, te 're mo, 'Re ĩhâimana u'âsi mono mreme na ĩsisi hã. Ta hã te siré 're simasisi u'âsi zahuré, 'Re ĩhâimana u'âsi mono me. Duré ta hã 'Re ĩhâimana u'âsi mono. ");
INSERT INTO xavNT_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Ti'ai õ ré hã, te siré 're simasisi zahuré, marĩ õ uptabi ré hã. ");
INSERT INTO xavNT_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Ta hã ma tô uburé te te ro'apoto, 'Re ĩhâimana u'âsi mono te te tãma ĩpisutuzéb zarina. Te te ro'apoto mono õ 'wa'âhã, aré marĩ õ uptabi di. ");
INSERT INTO xavNT_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Ta hã rowẽ na 're ĩdahâimana u'âsi za'ra mono zé nhomri'wa, te dama 're hâimana, 'Re ĩhâimana u'âsi mono mreme na ĩsisi hã. Dama rob'uiwẽ'wa ne, rowa'a na damorĩ wẽ na 're danomro mono da, te za roti wẽ na te te dama 're awaihu'u. ");
INSERT INTO xavNT_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Robra na ne, dawasété na 're danomro mono nherẽ, te za dama rob'uiwẽ'wa ne 're ĩmorĩ hã te te 're da'apawaptob u'âsi, tinhimiroti na. Niwa da te dawi uprosi waihu'u õ di za ĩsimiroti hã, dawasété na 're ĩdanomro mono norĩ hã. ");
INSERT INTO xavNT_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Tawamhã 'Re ĩhâimana u'âsi mono hã ma tô aibâ hã satõ, te te dama 're sadawa wasu'u mono da. Aibâ nhisi hã Zuwã na ĩsisi hã. ");
INSERT INTO xavNT_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Ta hã ma tô te te dama 're wasu'u, rob'uiwẽ'wa ne 're ĩmorĩ wasu'u hã. ");
INSERT INTO xavNT_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Zuwã hã rob'uiwẽ'wa ne 're ĩmorĩ hã 're hâimana mono õ di. Rob'uiwẽ'wa ne 're ĩmorĩ wasu'u na te te 're da'apo're pu'u mono da si, ma tô we datẽme wi, Zuwã hã. ");
INSERT INTO xavNT_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Rob'uiwẽ'wa ne 're ĩmorĩ hã tô sena ĩsimiroti hã. Ta hã ti'ai u ma we datẽme wi, aihĩni ĩsimiroti hã da te waihu'u pese za'ra da. ");
INSERT INTO xavNT_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","11","Ta hã te oto ti'ai ãma 're hâimana, 'Re ĩhâimana u'âsi mono mreme na ĩsisi hã. Tazahã 'Re ĩhâimana u'âsi mono zadawa para, te te ro'apoto mono nherẽ, ro'apoto mono 'wa na da te waihu'u za'ra õ di. Tisiré zudezu norĩ rob u, ma tô wei mo. Tane nherẽ, sô 're tob'uzu za'ra mono õ di, ta norĩ hã. ");
INSERT INTO xavNT_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Ni'wam norĩ si ma tô sô 're tob'uzu za'ra. Ma tô te te ãma 're sasõmri za'ra. Taha wa, ma tô ta norĩ si pisutu za'ra, 'Re ĩhâimana u'âsi mono 'ra, 're hâimana za'ra mono da. ");
INSERT INTO xavNT_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","E ĩ'ra siro, ma tô ta norĩ hã 're rere'e, ti'ai ãma timama sipoto na. Mare di. Taha zarina, ĩ'ra siro, 're rere'e mono õ di. 'Re ĩhâimana u'âsi mono si ma tô ãma 're 'ra za'ra. ");
INSERT INTO xavNT_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Dama 'Re ĩhâimana u'âsi mono wasu'u'wa da hã, wa'rata 're sãmra mono da, ma tô sihâiba. Simizawi pese uptabi di. Ĩsimiroti hã wẽ uptabi di. 'Re ĩhâimana u'âsi mono 'ra wa, õhõ si 're morĩ wẽ uptabi di. Misire ĩ'ra hã. Õhõ si, waihu'u pese uptabi di. Wa norĩ hã wa tô wasiwi waihu'u za'ra ni, 're ĩmorĩ wẽ uptabi na. Ĩwaihu'u pese na zama, wa tô waihu'u za'ra ni. ");
INSERT INTO xavNT_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Ta hã ma tô Zuwã Batita hã te te dama 're wasu'u, 'Re ĩhâimana u'âsi mono 'ra na, da te 're waihu'u za'ra mono da. Ãne ĩtẽme wisi wamhã, te dama 'mahâ, Zuwã Batita hã: — Õhõta aibâ hã te wei mo. Ĩwana, wa tô te aima 're wasu'u za'ra wa'wa: “Õ hã ĩ̱za'u si wei morĩ nherẽ, ĩ̱ma pire di. E marĩ wa. Ĩ̱poto õ ré, 're morĩ u'âsi wa.” — Ãne ma tô dama rowasu'u, Zuwã Batita hã. ");
INSERT INTO xavNT_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","17","Duréihã wahi'rada Mozési hã ma tô te te dama 're roti, 'Re ĩhâimana u'âsi mono nhimiroti zarina. 'Re ĩhâimana u'âsi mono te te tãma ĩwaihu'uzéb zarina, ma tô te te dama 're roti, ãma 're danomro wẽ mono da. Zezu Cristu hã ma tô õhõ si te te dama 're waihu'u, dawasété nherẽ, 'Re ĩhâimana u'âsi mono te te 're ĩda'azawi pese mono zém na. Simizawi pese uptabi wa, te te 're wa'apawaptob u'âsi, ãma 're wanomro wẽ mono da, Zezu Cristu hã. ");
INSERT INTO xavNT_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Ti'ai ãma 're ĩdanomro mono hã datõmo na da te 're 'madâ'â za'ra mono õ di, 'Re ĩhâimana u'âsi mono hã. Õhõ si, ma tô Timama hã 'madâ, siré 're simasisi u'âsi zahuré mono wa, Timama me. Ĩ'ra hã misire, 'Re ĩhâimana u'âsi mono 'ra hã. Ta hã ma tô te te dama 're wasu'u u'âsi Timama hã, da te 're waihu'u za'ra mono da. ");
INSERT INTO xavNT_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Tawamhã aibâ norĩ hã ma tô aihutu, Zuwã Batitaha u, 'Re ĩhâimana u'âsi mono ma, da'ãma romhuri'wa norĩ hã. Tipawapto'wa norĩ me, ma tô ĩtẽme aihutu, réwita norĩ me. Zudezu norĩ ma roti'wa norĩ hã te te satõrĩ za'ra wa, ma ĩtẽme aihutu, Zeruzarẽ hawi. Tawamhã ĩtẽme sihutu wamhã, te siwi sadanharĩ za'ra, ãne: — E 'wa hã, a hã. ");
INSERT INTO xavNT_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Taha wa, te ãne tãma siwasu'u za'ra: — Wa hã Cristu õ di, 'Re ĩhâimana u'âsi mono te te ĩpisudu hã, Danho'reptui'wa da. ");
INSERT INTO xavNT_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Te duré siwi sadanharĩ za'ra: — E 'wa hã bété, a hã. E a hã, Eriasi apâ aihâiwa'udu. Tawamhã asa te duré tãma nharĩ za'ra: — Mare di. Ta hãi õ di, wa hã. Taha wa, te duré siwi sadanha: — E a hã, 'Re ĩhâimana u'âsi mono zadawa wasu'u'wa zô, 're ĩdanhimipari za'ra mono, te 're aimo. Tawamhã asa te duré tãma nharĩ za'ra: — Mare di. Wa hã, ta hãi õ di. ");
INSERT INTO xavNT_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Tawamhã te duré siwi sadanha: — E 'wa hã bété, a hã. Ma'ãpé wei wama asiwasu'u su'u za'ra na, wa te aiwaihu'u za'ra da, wei wazatõrĩ'wa norĩ ma, wa te aiwasu'u za'ra da. ");
INSERT INTO xavNT_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Taha wa, te oto tãma siwasu'u za'ra, ãne: — Wa hã a'ubuni wi, dama roti'wa. Ãne, wa tô te dama 're rob'mahârâ: “Wanhib'apito zô, te za bâdâdi hã ĩmana 'rãmi asiwi ĩsa'ra wa'aba mo, awa'awi da.” Ãne ma tô wahi'rada Iza'iza hã te te dama 're roti aré, 'Re ĩhâimana u'âsi mono zadawa wasu'u 'rata 'wa hã. Tane wa tô duré wa hã te dama 're roti, ĩsimiroti zarina. — Ãne te Zuwã Batita hã tãma siwasu'u za'ra, aibâ norĩ ma. ");
INSERT INTO xavNT_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","25","Tawamhã asa te tãma nharĩ za'ra, ãne: — Ma tô wama asiwasu'u za'ra. A hã, Cristu õ di. A hã, Eriasi õ di. A hã, 'Re ĩhâimana u'âsi mono zadawa wasu'u'wa zô, 're ĩdanhimipari za'ra mono õ di. E marĩ da, te bété â dawabzuri hã dama 're ĩ'ab'manharĩ mo, a hãi õ nherẽ. — Ãne te tãma nharĩ za'ra. ");
INSERT INTO xavNT_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","27","Tawamhã Zuwã te asa tãma nharĩ za'ra, ãne: — Â na si, wa tô â dawabzuri hã te dama 're ab'manharĩ. Tane nherẽ, ĩ̱za'u si we ĩmorĩ hã 'Re ĩhâimana u'âsi mono te te dama 're sadawa wasu'u mono da, ma tô wei wi. Zahadu sa'rese za'ra wa'aba õ di, a norĩ wa'wa hã. Ta hã ĩ̱ma pire wa, ĩpara'uza wasisizé te tãma wasihu waihu'u õ di. — Ãne Zuwã Batita hã te tãma siwasu'u za'ra. ");
INSERT INTO xavNT_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Ãne romhâimanazé hã Betãnha na 'ri wa'õtõ nhisi ãma Zodã zara niwĩ â dawabzuri te te dama 're ĩ'ab'manharĩzéb ãma hã. ");
INSERT INTO xavNT_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Tawamhã awẽ ma tô Zuwã Batita hã Zezusi hã tisã, ĩtẽme morĩ ré. Te te sãmri wi, te dama 'mahâ, ãne: — Õhõta te we oto mo, Pone'ẽrebâ hã, 'Re ĩhâimana u'âsi mono te te ĩpisudu hã dawasédé hã te te dama 're apari mono da. ");
INSERT INTO xavNT_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Ĩwana wa tô ãne hã aima wasu'u za'ra wa'wa: “Ĩ̱za'u we ĩmorĩ hã ĩ̱ma pire di. Ĩ̱poto õ ré, 're morĩ u'âsi wa, ĩ̱ma pire di.” Ãne, wa tô aima rowasu'u za'ra wa'wa. ");
INSERT INTO xavNT_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Wa hã te duré waihu'u õ di aré, 'Re ĩhâimana u'âsi mono te te ĩpisutu na hã Danho'reptui'wa da. Tazahã, wa norĩ hã Izarazéhé nhihudu hã wa te waihu'u za'ra da, wa â dawabzuri hã te dama 're ab'manharĩ. ");
INSERT INTO xavNT_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","33","— Ĩ̱si'uihâ na, wa hã te duré waihu'u õ di. 'Re ĩhâimana u'âsi mono, ma tô ĩ̱ma waihu'u, te te ĩpisudu hã. Ãne te ĩ̱ma wasu'u: “Ĩtẽme wa za satõ Ĩ̱pẽ'ẽzani hã, te ĩpisutu u. Ĩhawi morĩ õ di za. Ĩ'rata te za 're sãmra u'âsi. A hã te za ãma ĩ'madâ. Ãma 'madâ'â wamhã, te za oto ĩwaihu, õ hã te ĩpisutu na, Ĩ̱pẽ'ẽzani te te dama 're anhomri mono da.” Ãne ĩ̱zatõrĩ'wa hã te ĩ̱ma wasu'u. Tô sena ma tô ĩ̱ma rowasu'u. Wa hã wa tô ãma 'madâ. Ma tô we ĩtẽme mo, hâiwa hawi utu'u ne, 'Re ĩhâimana u'âsi mono pẽ'ẽzani hã. Ĩhawi morĩ õ di. ");
INSERT INTO xavNT_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Wa hã wa tô ãma 'madâ. Tô sena, wa aima rowasu'u za'ra wa'wa. Õ hã, 'Re ĩhâimana u'âsi mono 'ra. — Ãne te dama wasu'u, Zuwã Batita hã. ");
INSERT INTO xavNT_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Tawamhã awẽ te duré Zuwã Batita hã wasiré tihâiba. Wa norĩ hã ĩsiré 're wane wa, wa ĩsiré aima'wara ni. Tawamhã wasiré wasimasab ré, ma Zezusi hã ro'razâ. ");
INSERT INTO xavNT_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Tawamhã, Zuwã Batita hã te te 'madâ'â wamhã, te dama 'mahâ: — Õhõta Pone'ẽrebâ, 'Re ĩhâimana u'âsi mono hawi we ĩmorĩ. ");
INSERT INTO xavNT_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Tawamhã Zuwã Batitaha mreme hã wa te wapari wa, wa tô oto wanem ni, Zezusihi zarina. ");
INSERT INTO xavNT_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Taha wa, Zezusi hã ma wei wazô aipi'ra. Te wei wa'madâ. Tawamhã te wama tinha, ãne: — E marĩ zô, te we ane wa'wa. Tawamhã asa wa tãma nharĩ ni: — Rowahutu'wa, asãmrazé hã wa te waihu'u da, wa wei wanem ni. ");
INSERT INTO xavNT_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","40","Tawamhã Zezusi te wama tinha: — Oto pé ĩ̱zaprõni aba, ĩ̱nhamrazé hã sabui wa'aba da. Taha wa, wa oto ĩme wanem ni, ĩsãmrazéb u. Wasihutuzéb u ma tô bâdâ hã we tinho're za'a. Tawamhã bâtâ na wa ĩ'rata aimasisi ni, Ãdéréhé me. Simahã no, Ãdéré hã. ");
INSERT INTO xavNT_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Tawamhã tidub'rata zô te mo, Ãdéré hã. Te te sãmri wamhã, ãne te tãma rowasu'u: — Danho'reptui'wa hã wa tô sõpẽtẽ ni, 'Re ĩhâimana u'âsi mono te te ĩpisudu hã. Danho'reptui'wa hã ta hã “Cristu”, damreme amo na hã. ");
INSERT INTO xavNT_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Tawamhã ma tô Zezusihi u we saprõ apâ. We te te ĩtẽme ãwisi wamhã, Zezusi te Sima hã 'madâ. Te tãma tinha: — A hã Sima, Zuwãhã 'ra. Ãhãna wa za asisi na saprĩ. Sepasi na asisi hã za oto. — Ãne te tãma tinha. Ãma ĩsaprĩ hã Pedru na ĩsisi hã. ");
INSERT INTO xavNT_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Tawamhã awẽ Darireza na danhipti'a nho'õmo nhisi u morĩ da, te Zezusi hã sina ropisutu. Taha wa, wa ĩsiré oto ai'aba'ré ni. Wasi'aba'réi ré, wa tô aibâ hã sõpẽtẽ za'ra ni, Piripi na ĩsisi hã. Tawamhã Zezusi te tãma tinha: — We aimorĩ, ĩ̱siré 're aimorĩ da oto. Taha wa, te oto ĩsiré mo. ");
INSERT INTO xavNT_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Piripihi za'ru hã Besada na 'ri nhisi hã. Tame te duré Ãdéré norĩ hã 're simasisi zahuré, Pedruhu me. ");
INSERT INTO xavNT_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Tawamhã Piripi te Natãna'éhé zô mo. Te te sãmri wamhã, ãne te tãma tinha: — Aibâ hã wa tô sabu za'ra ni, wahi'rada Mozési te te ãma ĩrob'ui'éré siro hã romhâ ré, 'Re ĩhâimana u'âsi mono zadawa wasu'u 'rata 'wa norĩ zama ĩsa'u te te ãma ĩrob'ui'éré za'ra hã. Ta hã Zezusi, Nazaré hawi we ĩmorĩ hã, Zuzéhé 'ra hã. — Ãne te Piripi hã tãma rowasu'u. ");
INSERT INTO xavNT_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Tawamhã te Natãna'é hã asa tãma tinha, ãne: — Oro Nazaré hawi ĩwẽ hã wei morĩ õm ne. Tawamhã Piripi asa te tãma tinha: — We aimorĩ, wanem hâ, sabu da. Taha wa, te apâ ĩtẽme saprõ. ");
INSERT INTO xavNT_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Tawamhã te te sãmri wi, te Zezusi hã tãma tinha, Natãna'éhé ma, ãne: — Õhõta te wei mo, Izarazéhé nhihudu uptabi hã 're ĩmorĩ wẽ uptabi hã. Sadawa nhipese ãna te 're mo. ");
INSERT INTO xavNT_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Taha wa, te Natãna'é hã asa tãma tinha: — E niha ma tô ĩ̱waihu. Taha wa, te duré Zezusi asa tãma tinha: — Piripi hã te te ai'mahârâ õ ré, wa tô ai'madâ, pidera wede 'rowi asãmra ré. ");
INSERT INTO xavNT_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Tawamhã Natãna'é asa te duré tãma tinha: — Rowahutu'wa, a hã 'Re ĩhâimana u'âsi mono 'ra. A hã uburé Izarazéhé nhihudu norĩ nhib'apito. ");
INSERT INTO xavNT_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","51","Tawamhã Zezusi asa te duré tãma tinha: — Tane tô. Wede 'rowi asãmra ré, te aiwaihu'u wa, ma tô asina ĩ̱waihu, asina ĩ̱wapari wa. Ĩ̱waihu'u pese wa, ma tô ĩ̱'ãma atob'uzu. Niwapsi te za marĩ hã ĩ'madâ, ĩ̱waihu'u pese na marĩ hã te aima ĩwaihu'uzém nhipai u. Asõ'a wa'aba, te za hâiwa hã we 'ridawa, ĩ̱nho'õmoi baba. Tawamhã siwa'rãmi te za nasi we ĩ̱tẽme ai'aba'ré hâiwa hawi, 'Re ĩhâimana u'âsi mono ma romhuri'wa norĩ hã, dasiré ĩ̱poto u hã. — Ãne ma tô tãma waihu'u sirõmo za'ra, Zezusi hã. ");
INSERT INTO xavNT_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Tawamhã maparane ma tô wa'ãma timara. Taha pari, dasaihurizé hã ma tô 'manharĩ za'ra ni, dasina damrozém na hã. Cana na 'ri wa'õtõ nhisi ãma, ma tô 'manharĩ za'ra ni. Darireza na danhipti'a nho'õmo nhisi ãma, Cana hã. Zezusihi na hã te tame dame tihâiba. ");
INSERT INTO xavNT_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Zezusihi zô zama, te tahârâ ni, ĩsiré 're ĩwanomro mono norĩ zô zama, dasina damro u wasi'aba'ré da. Taha wa, wa duré wa norĩ hã dame asimro ni. ");
INSERT INTO xavNT_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Tawamhã, ma tô uwa 'ru 'rãi wa'u ĩsé hã da'ãma ai'utõ, da te 'mahâpãrĩ mono õ ré. Taha wa, te Zezusihi ma ĩna hã tinha, ãne: — Uwa 'ru 'rãi wa'u ĩsé hã ma tô da'ãma ai'utõ, da te 'mahâpãrĩ mono õ ré. ");
INSERT INTO xavNT_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Tawamhã Zezusi asa te tãma tinha: — Ãté a hã ĩ̱ma waihu'u õ di za, marĩ te ĩ'manharĩ da hã. Bâdâ zahadu ĩwa waptã'ã õ di, ãne te ĩ'manharĩ da hã. ");
INSERT INTO xavNT_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Taha wa, te ĩna hã romhuri'wa norĩ ma tinha, ãne: — Tiha te te aima waihu'u za'ra wa'aba wamhã, ma'ãpé ĩmreme hã 'madâ'â pese za'ra wa'aba za. — Ãne te tãma nharĩ za'ra. ");
INSERT INTO xavNT_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Tame te piza hã 're simasa ẽtẽ 'manharĩ hã, â ré hã 6 na ĩhâiba hã. Nima norĩ hã 80 na â za'ratazé hã, duré nima norĩ hã 120 na â za'ratazé hã. 'Re wasaihuri mono õ ré hã, wahi'rata norĩ nhimiroti zarina, wa 're wanhimisõ za'ra, wa norĩ hã zudezu wa. Taha da, te 're simasa, piza ĩsa'ẽne hã. ");
INSERT INTO xavNT_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Tawamhã Zezusi te romhuri'wa norĩ ma tinha, ãne: — Â hã nasi amrami za'ra wa'aba, piza 're sa'wari za'ra wa'aba da. 'Masisi za'ra wa'aba. Tawamhã ma tô siwi 'masisi, piza 'remhã â hã. ");
INSERT INTO xavNT_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Tawamhã Zezusi te tãma nharĩ za'ra, ãne: — Ma'ãpé, â hã oto amrami za'ra wa'aba, danhipi na dawada'uri'wai u 'wasari aba da, te te téiwa pibu da. ");
INSERT INTO xavNT_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","10","Tawamhã ma tô ĩtẽme 'wasa, te te téiwa da. Te te téiwai wamhã, â si õ di oto. Ma tô sirob'rãi wa'u. Nima hawi uwa 'ru 'rãi wa'u ĩsé hã te te waihu'u õ di, danhipi na dawada'uri'wa hã. Romhuri'wa norĩ si ma tô waihu'u za'ra. Tawamhã te te téiwa wamhã, sina ĩmro zahuré zô, te hâ, aibâ zô. Taha wa, te ãne tãma tinha: — E niha ma bété ĩsei uptabi si dawi ĩté, wasaihuri na'rata hawi, wa te âhuri tõ da. Dasaihuri na'rata hawi, te ĩsei uptabi hã da te dama 're sõmri za'ra, da te 're âhuri mono da. Sa'ẽtẽ na da te 're âhuri mono wapsi, te za ĩwa'u zei prã hã da te dama 're sõmri za'ra. Tanei õ di, a hã. Nimosi ma tô ĩsei uptabi hã dama ĩ'ru, da te âhuri da. — Ãne te aibâ ma tinha, danhipi na dawada'uri'wa hã. ");
INSERT INTO xavNT_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Ãne hã marĩ dama ĩ'manharĩ waihu'u'õ hã te te dama ĩ'manharĩzém na ma tô Zezusi hã dapawaptom na sãna'rata, tiwaihu'u pese na, Cana na 'ri nho'õmo nhisi ãma. Darireza na danhipti'a nho'õmo nhisi 'remhã, Cana hã. Taha wa, waihu'u pese wa, wa tô wasina umnhasi za'ra ni, ĩsiré 're ĩwanomro mono norĩ hã. ");
INSERT INTO xavNT_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Tawamhã Capana'u na 'ri nho'õmo nhisi u te oto mo, Zezusi hã. Ĩna zama te ĩsiré mo. Ĩno norĩ zama te ĩsiré ai'aba'ré. Wa norĩ zama, wa ĩsiré ai'aba'ré ni, ĩsiré 're wanomro mono wa. Tawamhã, wasihutu wamhã, syry na wa tame asimro ni. ");
INSERT INTO xavNT_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Romhuture di oto, zudezu norĩ te, dato hã da te 're ĩ'manharĩ za'ra mono zéb u hã, 'Re ĩhâimana u'âsi mono, Ezitu hawi te te ĩdawaibuzém na ãma dasipo're pu'u za'ra da, Pascowa na dato nhisi hã. Tawamhã romhuture wa, datoi u te oto mo Zeruzarẽ u, Zezusi hã. Wa norĩ zama, wa duré ĩsiré ai'aba'ré ni. ");
INSERT INTO xavNT_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Zeruzarẽ ãma te 'ri za'ẽne hã 're sa, 'Re ĩhâimana u'âsi mono ãma 're ĩdawata za'ra mono zé hã. 'Ri 'wawi wa'ra 're, te aibâ norĩ hã 're si'ubumro. Ta norĩ hã powawẽ te te dama 're wede za'ra, duré pone'ẽrebâ, duré utu'u. Ĩhâiba amo norĩ hã te duré rob'uiprazém na te te dawi ãma 're saprĩ za'ra. ");
INSERT INTO xavNT_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Tawamhã Zezusi hã aibâ norĩ hã te te 'madâ'â za'ra wamhã, ma tô marĩ hã sada 'manharĩ za'ra, wedenhorõ na te te ãma sate mono da, rob u. Tawamhã ma tô te te sate, ĩsimizama ré. Wedeza hã ma tô duré tiwi pizari za'ra, rob'uiprazé hã te te tiwi sãmra za'ra da, te te dawi ãma 're ĩsaprĩ za'ra mono norĩ wi. ");
INSERT INTO xavNT_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Te duré tãma rob'ru za'ra, utu'u wede'wa norĩ ma, ãne: — Mo oto rob u sani za'ra wa'aba. 'Ri hã ã hã, Ĩ̱mama ãma 're ĩdawata za'ra mono zé. Ãme dama 're rowede za'ra wa'aba mono õ di za oto. — Ãne te tãma nharĩ za'ra. ");
INSERT INTO xavNT_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Taha wa, wa tô ãma wapo're pu'u za'ra ni, 'Re ĩhâimana u'âsi mono zadawa wasu'u'wai mreme ui'éré na. Ãne duréihã ma tô wahi'rada hã tinha, 'Re ĩhâimana u'âsi mono ma: “Asõrõwa da hã marĩ na te romhuri za'ẽtẽ wa, wa tô ĩwa ãma waze, asawi te.” Ãne ĩmreme na wa tô wapo're pu'u za'ra ni. ");
INSERT INTO xavNT_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Taha wa, te dama ĩpire norĩ hã tãma nharĩ za'ra, ãne: — E 'wa sadawa para, ma tô ĩdazate mo, rob u. 'Re ĩhâimana u'âsi mono zadawa para, sate mono wamhã, e marĩ te za ĩ'manha, dama ĩ'manharĩ waihu'u'õ hã wa te ãma aiwaihu'u za'ra da. ");
INSERT INTO xavNT_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Tawamhã Zezusi te asa tãma nharĩ za'ra, ãne: — Marĩ hã wa za aima wasu'u za'ra wa'wa, ãma ĩ̱waihu'u za'ra wa'aba zéb da hã. Ã hã 'ri hã asiwi sãmra aba wamhã, wa za apâ 'ri su'u. Bâdâ misi te za ĩ̱'ãma mo, apâ te 'ri ré hã. — Ãne te tãma siwasu'u za'ra. ");
INSERT INTO xavNT_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Tawamhã asa te tãma nharĩ za'ra: — E niha te za ĩ'ri su. E niha bâdâ misi te za ai'ãma mo, apâ 'ri ré, a hã. Ã hã da te dasiwi 'ri su'u õ di, 'ri za'ẽtẽ wa. Wahub ahâ na ma tô da'ãma tiwahu, da te dasiwi 'ri za'ra ré hã. 46 na ma tô ãma dawi tiwahu. — Ãne asa te Zezusihi ma nharĩ za'ra. ");
INSERT INTO xavNT_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","'Ri te te wasu'u wamhã, tihâiba te wasu'u, Zezusi hã. Sõ'awi siwasu'u õ wa, ĩmreme hã dama pibu prã za'ra di. ");
INSERT INTO xavNT_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Ab're hawi hâiwa'utu wapsi, wa za ãma wapo're pu'u za'ra ni, apâ za te te ĩ'ri wasu'u na hã. Wa za wasima rowasu'u za'ra ni, ãne: “Tô sena na ma tô Zezusi hã tihâiwa'utuzém na dama siwasu'u. Tô sena na ma tô duré wahi'rata norĩ hã romhâ ré ĩhâiwa'utuzém na rob'ui'éré sirõmo za'ra ĩbaihâ na, 'Re ĩhâimana u'âsi mono zadawa wasu'u'wa norĩ hã.” Ãne, wa za wasima rowasu'u za'ra ni. ");
INSERT INTO xavNT_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Tawamhã Zezusi hã zahadu Zeruzarẽ ãma hâimana ré, ma tô Pascowa na dato nhisi hã dasiwi 'manharĩ ni. Tame sãmra ré, ma tô marĩ dama ĩ'manharĩ waihu'u'õ hã te te dama 're ab'manharĩ wẽ, tiwaihu'u pese na, 'Re ĩhâimana u'âsi mono we te te ĩsatõrĩ na, da te waihu'u za'ra da. Taha wa, marĩ dama ĩ'manharĩ waihu'u'õ hã danho'a te te dama 're ab'manharĩ mono wẽ te, ma tô da'ahâ na saze za'ra ni. ");
INSERT INTO xavNT_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","25","Tane nherẽ, da te dasina ĩ'umnhasi za'ra na, te te sina damreme zazei õ di, Zezusi hã. E marĩ wa. Uburé danhimirosa'rada hã tãma waihu'u pese wa. Ni'wa ĩ'upana te te tãma 're da'awaihu'u mono õ di, Zezusihi ma. Si'uihâ na ma tô te te 're da'awaihu'u, danhimirosa'rata na. Taha wa, tô sena da te dasina umnhasi za'ra õ wa, te te sina damreme zazei õ di, Zezusi hã. ");
INSERT INTO xavNT_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Aibâ hã te 're hâimana, Nicodemosi na ĩsisi hã. Ta hã roti'wa, wasiré zudezu. Parisezu na, wa tô wa te 're sisi za'ra, wahi'rata norĩ nhimiroti, parisezu norĩ siré te te 're 'madâ'â pese mono wa. ");
INSERT INTO xavNT_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Ta hã ma tô Zezusihi u wi, barana. Ĩtẽme wisi wamhã, ãne te tãma tinha: — Rowahutu'wa, 'Re ĩhâimana u'âsi mono hã ma tô wei watẽme asatõ, wama 're rowasu'u mono da. Ãne wa tô ai'ãma waihu'u za'ra ni. Taha zadawa para, ma tô marĩ hã dama ĩ'manharĩ waihu'u'õ hã dama 're ĩ'ab'manharĩ wẽ u'âsi mo, da te ãma aiwaihu'u za'ra da, we te te asatõrĩ na. Ta hã te te aima 're waihu'u mono õ 'wa'âhã, a hã ĩwaihu'u'õ hã dama 're ab'manharĩ mono õ di aré. — Ãne te Zezusihi ma tinha. ");
INSERT INTO xavNT_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Taha wa, te Zezusi hã asa tãma tinha: — Tô sena, wa aima waihu'u. Dapẽ'ẽ 're, 're dapoto téb za'ra mono õ wamhã, 'Re ĩhâimana u'âsi mono nhib'a'uwẽ 're danomro mono õ di za. ");
INSERT INTO xavNT_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Tawamhã Nicodemosi te duré asa tãma tinha: — E niha te za aibâ hã si'ĩhi nherẽ, tipoto té. E niha te za tina dub're apâ ãzé, duré apâ poto téb da. — Ãne te Zezusihi ma tinha. ");
INSERT INTO xavNT_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","6","Tawamhã Zezusi te duré asa tãma tinha: — Tô sena, wa aima waihu'u za'ra wa'wa. Ai'uté hã dama 're poto za'ra mono wamhã, 'Re ĩhâimana u'âsi mono nhib'a'uwẽ, 're nomro sirõmo mono õ di za. Tipẽ'ẽzani hã te te dama 're anhomri mono wapsi, te za 're dapoto téb za'ra, dapẽ'ẽ 're. Tawapsi te za oto ĩsib'a'uwẽ si 're danomro. 'Re ĩhâimana u'âsi mono hã 're ĩdanomro wasété mono hawi te te 're da'a'upsõi mono wa, duré Tipẽ'ẽzani hã te te dama 're anhomri mono wapsi, te za oto dapẽ'ẽ 're, 're dapoto téb za'ra. Tawapsi te za oto duré ĩsib'a'uwẽ 're danomro. Dapẽ'ẽ 're, 're dapoto téb za'ra mono õ wamhã, 'Re ĩhâimana u'âsi mono nhib'a'uwẽ, 're danomro mono õ di za. ");
INSERT INTO xavNT_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","A hã, aipoto tém neza. Ãne te aima nharĩ wa, ĩ̱ma nharĩ õ di za, ãne: “E niha wa za ĩ̱poto té.” ");
INSERT INTO xavNT_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Rowa'u wa za aima wasu'u, waihu'u da. Rowa'u hã te te 're rowapõrĩ mono wamhã, ĩpupu'u si wa wa te 're wapari za'ra. Ĩpupu'u na si wa za wa te 're waihu'u za'ra, 're ĩwairébé mono zém na hã. Uihâ na te rowa'u hã 're wairébé, nimomo 're wa'u'u 'rãsutu za'ra mono da. E ma hawi te rowa'u hã 're wairébé na'rata. E momo te duré 're wa'u'u 'rãsutu za'ra. Wama waihu'u pese za'ra õ di. Tane dama waihu'u pese õ di, dapẽ'ẽ 're, 're ĩdapoto téb za'ra mono zé hã. Dama waihu'u pese õ nherẽ, te za 'Re ĩhâimana u'âsi mono hã te te dama 're anhomri, Tipẽ'ẽzani hã dapẽ'ẽ 're, 're ĩdapoto téb za'ra mono zém na, da te dasina 're waihu'u za'ra mono da. — Ãne te Zezusi hã tãma rowasu'u. ");
INSERT INTO xavNT_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Tawamhã Nicodemosi te duré asa tãma tinha: — E niha te za Tipẽ'ẽzani hã te te dama 're anhomri, dapẽ'ẽ 're, 're dapoto téb za'ra mono da. ");
INSERT INTO xavNT_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Taha wa, te duré Zezusi hã asa tãma tinha: — A hã Izarazéhé nhihudu norĩ ma, rowahutu'wa. Tane nherẽ, ĩ̱nhimirowasu'u hã aima pibui prã ti. E niha waihu'u õ di bété. ");
INSERT INTO xavNT_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Tô sena, wa aima waihu'u za'ra wa'wa. Wa norĩ hã marĩ hã wama waihu'u pese wa, duré wa te 'madâ'â wa, wa ãne wa te dama 're wasu'u. Tane nherẽ, wa te aima 're rowasu'u za'ra wa'aba mono nherẽ, ãma 're wazaze za'ra wa'aba mono õ di. ");
INSERT INTO xavNT_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Ti'ai ãma romhâimanazé hã, wa tô aima wasu'u za'ra wa'wa. Tane nherẽ, te aima wasu'u za'ra wa'aba nherẽ, ãma ĩ̱zaze za'ra wa'aba õ di. E niha te za tawamhã hâiwa ãma da te 're ĩwaihu'u za'ra mono zéb da hã te aima wasu'u za'ra wa'aba wamhã, ãma ĩ̱zaze za'ra wa'wa. Ãté ãma ĩ̱zaze za'ra wa'aba õ di za. ");
INSERT INTO xavNT_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Ni'wa hã hâiwa u sébré õ di, apâ wei morĩ da, hâiwa ãma romhâimanazé hã te te dama 're wasu'u mono da. Wa hã ti'ai ãma dasiré ĩ̱podo hã ĩ̱siwaprosi, wa we hâiwa hawi mo, te dama 're rowasu'u mono da. ");
INSERT INTO xavNT_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","15","— Duréihã Mozési hã ma tô a'ubuni wi wahi ne 'manharĩ hã sasõ, ĩsi'uwazi waipo 'manharĩ hã, wedewaré na sa'o da. Ta hã wahi te te ĩsari za'ra hã te te 'madâ'â za'ra wamhã, ma tô tizéptâ'â za'ra. Dâ'â za'ra õ di. Tane te za duré wa hã dasiwi ĩ̱zasõmri ni, wedepo'o nhonhi'rãmi na ĩ̱za'o da. Tawamhã wa za dazada dârâ. E marĩ da. Danho'reptui'wa na da te dasina 're ĩ̱'umnhasi za'ra mono wa, 're dadâ'â za'ra mono ãna, 're dasi'ubumroi u'âsi mono da, hâiwa ãma, 'Re ĩhâimana u'âsi mono 'rata. ");
INSERT INTO xavNT_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","'Re ĩhâimana u'âsi mono hã te te 're da'azawi pese uptabi. Taha wa, ma tô ti'ra hã misi nherẽ, we tisõ, dazada dâ'â da. Tawamhã ĩ'ra, da te dasina 're umnhasi za'ra mono wamhã, dadâ'â ãna te za hâiwa ãma ĩ'rata 're dasi'ubumroi u'âsi. Ropipa ãma ĩsiti 're dasi'ubumroi mono õ di za. ");
INSERT INTO xavNT_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Dapo're'õ u'âsi 're danomro mono wa, te te 're da'ahâ za'ra mono da, we te te satõrĩ õ di ti'ra hã, 'Re ĩhâimana u'âsi mono hã. 'Re ĩdanomro wasété mono hawi te te 're da'anho'reptui mono da si, ma tô we satõ, ti'ai u. ");
INSERT INTO xavNT_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","19","— Ni'wam norĩ hã ĩ'ra te te sina 're umnhasi za'ra mono wamhã, e 'Re ĩhâimana u'âsi mono hã te za te te tãma 're nharĩ za'ra, ãne: “Aiwẽ'õ za'ra wa'aba wa, wa za te 're aihâ za'ra wa'wa.” Ãne na hã te te tãma 're nharĩ za'ra mono õ di za. Tizazei'õ'wa norĩ ma si te za ãne na te te tãma 're nharĩ za'ra, ĩ'ra te te sina 're umnhasi za'ra mono õ wa. Duré tiwasédé te te sima 're sawi pese za'ra mono wa, te za ãne na te te tãma 're anharĩ. 'Re ĩmorĩ wẽ uptabi hã ti'ai u ma tô wei mo, rowa'a ĩwẽ hã. Ta hã wẽ nherẽ, da te dasiwi 're sawi pese za'ra mono õ di. Dapo're'õ u'âsi 're danomro mono wa, te robra si da te dasima 're sawi pese za'ra. ");
INSERT INTO xavNT_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Ni'wam norĩ hã 're nomro wasété u'âsi mono wamhã, te za 're ĩmorĩ wẽ uptabi hã te te 're 'ruiwapari za'ra, rowa'a ĩwẽ hã. Tawamhã ĩtẽme 're nomro mono õ di za, ĩsimirosa'rata wasété na te te 're awaihu'u mono wa, 're siséb za'ra mono õ'umnhasite. ");
INSERT INTO xavNT_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","'Re ĩnomro wẽ mono norĩ si te za ĩtẽme 're nomro, rowa'a u. E marĩ da. 'Re ĩhâimana u'âsi mono nhimiroti si te te 're ĩ'madâ'â pese mono na, te te 're awaihu'u mono da. — Ãne ma tô Zezusi hã Nicodemosihi ma waihu'u. ");
INSERT INTO xavNT_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Tawamhã Zezusi hã te mo, Zudeza na danhipti'a nho'õmo nhisi u. Wa norĩ hã wa ĩsiré ai'aba'ré ni. Wasihutu wamhã, tame wa a'â wahâimana za'ra ni. Tame te Zezusi hã â dawabzuri hã dama ab'manha. ");
INSERT INTO xavNT_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","24","Zuwã Batita hã te duré te te dama 're ab'manharĩ â dawabzuri hã, wanhiti. Sarĩ na 'ri nhisi 'rata â hã, sa'ẽtẽ di. Taha wa, te tame a'â nhamra, Eno na â nhisi 'rata, Zuwã Batita hã. Tawamhã te nasi ĩtẽme dasito, â dawabzuri hã te te dama 'manharĩ da. Zahadu Zuwã hã danhib'apito te te 'rui õ di, da te dasiwi sẽrẽ da, dazazéb 're. Taha wa, te zahadu te te dama 're ab'manharĩ. ");
INSERT INTO xavNT_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Tawamhã aibâ me te timreme na ai'wapé, Zuwãhã siré 're ĩnomro mono norĩ hã. Â dawabzuri wasu'u na te ai'wapé za'ra. ");
INSERT INTO xavNT_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Taha wa, ma Zuwã Batitaha tẽme aimasa, ĩsiré 're ĩnomro mono norĩ hã. Ãne te tãma wasu'u za'ra: — Rowahutu'wa, Zodã zara niwĩ aihâimana ré, ma tô Zezusi hã we atẽme wi. Wisi wi, ma tô dama ĩwasu'u, 'Re ĩhâimana u'âsi mono te te ĩpisutu na Danho'reptui'wa da. E niha te bété õ hã te te duré dama 're ab'manharĩ, â dawabzuri hã. Zezusihi u si te oto aihĩni 're danomro. — Ãne te tãma rowasu'u za'ra. ");
INSERT INTO xavNT_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","28","Tawamhã Zuwã asa te tãma nharĩ za'ra, ãne: — 'Re ĩhâimana u'âsi mono si te za te te dama 're apisutu romhuri hã, da te tãma 're romhuri za'ra mono da. Wa tô aré aima ĩ̱siwasu'u za'ra wa'wa, ãne: “Ta hã ma tô datẽme ĩ̱zatõ ĩwana, Danho'reptui'wa te dama 're wasu'u mono da. Wa hã, Cristu õ di. Danho'reptui'wa da, te te ĩ̱pisutu õ di.” Ãne na hã aima ĩ̱siwasu'u za'ra wa'aba zém na hã ma tô aré ĩ̱wapari za'ra wa'wa. — Ãne Zuwã Batita hã te tãma siwasu'u za'ra. ");
INSERT INTO xavNT_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Tawamhã aibâ ĩmro siwadi na ma tô sina simiré'é, ãne: — Dasina 're damro za'ra mono wamhã, aibâ hã oto mro wa, ĩsiwadi hã toi uptabi di. Aibâ hã ĩmro hã tito na siwasu'u wamhã, toi uptabi di, ĩsiwadi hã. Tane duré wa hã, ĩ̱toi uptabi di. E marĩ wa. Da'ahâ na oto 're danomro mono wa, Zezusihi u. ");
INSERT INTO xavNT_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Taha wasu'u hã, wasu'u za'ẽtẽ uptabi di za oto, dama. Wa hã oto ĩ̱wasu'u syryre di za. Tane nherẽ, ĩ̱ma rowẽ uptabi di. — Ãne te tãma siwasu'u za'ra, Zuwã Batita hã. ");
INSERT INTO xavNT_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Hâiwa hawi we ĩmorĩ hã, uburé dama pire uptabi di. Wa norĩ hã ti'ai ãma a'uwẽ wa, marĩ hã ti'ai ãma, wa te 're ĩ'madâ'â za'ra mono si, wa wa te dama 're wasu'u za'ra. Hâiwa hawi we ĩmorĩ si, uburé dama pire uptabi di. ");
INSERT INTO xavNT_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Hâiwa ãma uburé te te 're ĩ'ab'madâ'â mono na, duré te te 're ĩ'awapari mono na, te za sena na te te dama 're wasu'u. Taha wa, te te dama ãma 're arowasu'u mono wamhã, mreme pire uptabi di. Tane nherẽ, aihĩni ĩmreme hã da te 're saze za'ra mono õ di. ");
INSERT INTO xavNT_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Da te 're saze za'ra mono wamhã, ãne te za da te dasima 're wasu'u za'ra: “Tô sena, ma tô ti'ra na te te dama 're wasu'u, 'Re ĩhâimana u'âsi mono hã.” Ãne te za ĩsazei'wa norĩ hã te te sima 're rowasu'u za'ra. ");
INSERT INTO xavNT_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Ti'ra we te te satõrĩ wamhã, ma tô Tipẽ'ẽzani hã tãma tisõ, ĩré 're morĩ u'âsi da. Taha wa, te Timama nhimiroti si te te dama 're wasu'u. ");
INSERT INTO xavNT_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Ti'ra te te 're sawi pese uptabi, 'Re ĩhâimana u'âsi mono hã. Tawamhã ma tô pisutu, uburé dama pire uptabi da. Duré uburé marĩ ma pire da, ma tô ti'ra hã pisutu, hâiwa ãma ti'ai ãma zama. ");
INSERT INTO xavNT_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Ĩ'ra hã Danho'reptui'wa na da te dasina 're umnhasi za'ra mono wamhã, dama 're rowẽ za'ra mono di za. 'Re dadâ'â za'ra mono ãna, te za 're dasi'ubumroi u'âsi ĩ'rata, hâiwa ãma. Ĩmreme, da te 're wapari za'ra mono õ wamhã, dama 're rowẽ za'ra mono õ di za. 'Re ĩhâimana u'âsi mono nhimihâzé hã te za da te dasina 're waihu'u u'âsi za'ra, ĩ'ra mreme hã da te 're wapari za'ra mono õ wa. ");
INSERT INTO xavNT_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Tawamhã parisezu norĩ hã ma tô Zezusihi wasu'u hã wapari za'ra. Ãne ma tô dasima wasu'u za'ra ni: “Da'umro na si te oto 're dahâimana za'ra, Zuwã Batitaha nhimiroti 'madâ'â'wa hã. Da'umro na si te â dawabzuri hã te te dama 're ab'manharĩ. Zezusihi nhimiroti 'madâ'â'wa si te oto da'ahâ na 're dahâimana za'ra.” ");
INSERT INTO xavNT_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","Ãne, da te dasima rowasu'u za'ra nherẽ, si'uihâ na te te dama 're ab'manharĩ mono õ di, Zezusi hã. Wa norĩ si, wa ĩsadawa para wa te dama 're 'manharĩ za'ra, â dawabzuri hã. ");
INSERT INTO xavNT_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Tawamhã Zezusihi ãma danhimirowasu'u hã parisezu norĩ u ĩwaptã'ã na te te waihu'u wamhã, te ĩsiti timorĩ za'ra, Zudeza na danhipti'a nho'õmo nhisi hawi. Apâ te mo, Darireza na danhipti'a nho'õmo nhisi u. Wa norĩ hã wa ĩsiré ai'aba'ré ni, ĩsiré 're wanomro mono wa. ");
INSERT INTO xavNT_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","6","Tawamhã Darireza u morĩ wamhã, ma tô sima wẽ, awa'awi dawa'wai baba te te ro'razâri da. Taha wa, wa tô samaritanu norĩ ro wa'wai baba, ro'rahâri za'ra ni, Samariza na danhipti'a nho'õmo nhisi wa'wai baba. Wa tô oto rob'umhutu za'ra ni, 'ri nho'õmo u, Sica u hã. Tawamhã â zô ab're u, wa tô aihutu ni, abzumazéb u. Zuzéhé nhipti'ai ãma te â zô ab're hã 're hâimana, Zaco hã ti'ra ma, ti'a hã te te ĩsõmri wa. Tame te Zezusi hã nhamra, â zô ab're ãma. Te te ãma wazere wa, te tame nhamra. ");
INSERT INTO xavNT_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","8","Tawamhã 'ri nho'õmo u, wa tô ai'aba'ré ni, wasa hã wa te wasisa 'mai'uipra za'ra da. Zezusihi si te waza'u tinhamra za'ra, â zô ab're ãma. Tame sãmra ré, te we pi'õ hã mo, â zô, samaritanu na ĩwaptẽrẽ hã. Tawamhã â zô ab're u wisi wi, te Zezusi hã 'mahâ, ãne: — Â we ĩ̱ma a'âri, te hâ'rẽne da. 'Rubu di. ");
INSERT INTO xavNT_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Tawamhã te pi'õ hã asa tãma tinha: — E niha te â hã ĩ̱wi ĩwaptẽ, wasiré samaritanu õ nherẽ. A hã zudezu. — Zudezu norĩ hã duré samaritanu norĩ hã siré 're hâimana za'ra mono õ wa, te ãne pi'õ hã tãma tinha. ");
INSERT INTO xavNT_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Taha wa, ma tô Zezusi hã asa tãma tinha: — 'Re ĩhâimana u'âsi mono nhoprubzé hã waihu'u 'wa'âhã, duré ĩ̱waihu'u 'wa'âhã, te aré â hã ĩ̱wi ĩwaptẽ. Tawamhã â u'â hã wa aré aima tisõ. ");
INSERT INTO xavNT_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Taha wa, te duré pi'õ hã asa tãma tinha: — Â zô ab're hã, ab're 'rehâ di. A hã ai'ubana te asã. Tiha na â hã a'âri õ di za. E niha te za tawamhã ĩ'a'â, â u'â hã. ");
INSERT INTO xavNT_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Wahi'rada Zaco hã ma tô dama tisõ ã hã, â zô ab're hã. Ti'ra norĩ me te te 're ĩ'âhuri mono zé, ã hã wanhib'â hã. Ĩsimizama zama te te 're ĩ'âhuri mono zé. Wahi'rada hã wama pire za'ra di. E a hã tãma aipire wa, te za bété â u'â hã ĩ̱ma ĩsõ. — Ãne te pi'õ hã asa tãma tinha. ");
INSERT INTO xavNT_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Tawamhã Zezusi te duré asa tãma tinha: — Tane tô. Ã hã da te 're âhuri mono wamhã, apâre 'rubu di. ");
INSERT INTO xavNT_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Ĩ̱nhib'â hã te dama 're anhomri mono wa, da te 're âhuri mono wamhã, 'rubu ãna te za ĩré 're dasi'ubumroi u'âsi. Ub're 're ĩsidototo u'âsi za'ra mono ne, dawi 're si'utõrĩ waihu'u za'ra mono õ di za, da te 're âhuri mono wamhã. Tawamhã 're dadâ'â za'ra mono ãna, te za 're dasi'ubumroi u'âsi, hâiwa ãma. ");
INSERT INTO xavNT_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Taha wa, te pi'õ hã oto tiwi waptẽ, ĩsib'â hã: — Ta hã asib'â hã te za ĩ̱ma ĩsõ, te 're 'rubu u'âsi tõ mono da, we sô 're ĩ̱neb u'âsi tõ mono da. ");
INSERT INTO xavNT_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Taha wa, te Zezusi hã tãma rob'ru, ãne: — Mo oto aimorĩ aimro zô, we ĩ̱tẽme saprõni da. ");
INSERT INTO xavNT_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Tane nherẽ, ma tô pi'õ hã ãne tãma siwasu'u: — Wa hã ĩ̱mro õ di. Taha wa, te Zezusi hã oto tãma rowasu'u: — Tane tô. Ãhãna oto aimro õ di. ");
INSERT INTO xavNT_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","A hã 5 na aimro hã aré. Ãhãna hã aimro uptabi õ di. Taré te asiré 're aimasisi aba mo, aibâ me. Tô sena ma tô ĩ̱ma asiwasu'u, aimro õ na hã. ");
INSERT INTO xavNT_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Pi'õ hã te duré asa tãma tinha: — Wa tô oto aiwaihu'u. A hã 'Re ĩhâimana u'âsi mono zadawa wasu'u'wa, te 're aimo. ");
INSERT INTO xavNT_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","E mame te za 'Re ĩhâimana u'âsi mono ãma 're dawata za'ra. E ã ẽtẽ 'rãihâ ãma. E Zeruzarẽ ãma. Ã ẽtẽ 'rãihâ hã ma tô wahi'rata norĩ hã pisutu za'ra, ãme ãma 're dawata za'ra mono da. Asiré zudezu norĩ hã ma tô Zeruzarẽ hã pisutu za'ra, tame ãma 're dawata za'ra mono da. ");
INSERT INTO xavNT_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Tawamhã Zezusi te duré pi'õi ma tinha: — Niwapsi, ãne da te dasima 're wasu'u za'ra mono õ di za oto: “Ã ẽtẽ 'rãihâ ãma si, te za Wamama ãma 're dawata za'ra.” Duré ãne da te dasima 're wasu'u za'ra mono õ di za: “Zeruzarẽ ãma si te za ãma 're dawata za'ra.” ");
INSERT INTO xavNT_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","24","Ãhãna te za oto daro mono bâ ãma 're wata za'ra, ĩsazei uptabi 'wa norĩ hã. 'Re ĩhâimana u'âsi mono pẽ'ẽzani ré 're nomro mono wa, te za tô sena ãma 're wata za'ra. Te za tãma 're sisõmri u'âsi za'ra, ĩsimiroti zarina si 're nomro mono da. Ta norĩ si ma tô te te sima 're awẽ, ãma 're wata u'âsi za'ra mono da. 'Re ĩhâimana u'âsi mono hã waihu'u pese uptabi di. Hâiba õ nherẽ, te daro mono bâ 're sãmra, Ĩpẽ'ẽzani hã. Taha wa, te za oto daro mono bâ ãma 're wata za'ra, ĩsazei uptabi 'wa norĩ hã. Ĩpẽ'ẽzani ré 're nomro mono wa, te za tô sena ãma 're wata za'ra. Te za tãma 're sisõmri u'âsi za'ra, ĩsimiroti zarina si 're nomro mono da. A norĩ wa'wa hã te ãma 're aiwata za'ra wa'aba mo. Tane nherẽ, waihu'u za'ra wa'aba õ di, 'Re ĩhâimana u'âsi mono hã. Wa norĩ hã wa tô waihu'u za'ra ni. Taha wa, wa ãma 're wawata u'âsi za'ra. 'Re ĩhâimana u'âsi mono te te ĩpisudu hã Danho'reptui'wa da, ta hã zudezu. Ãne na hã wama waihu'u pese za'ra di. — Ãne Zezusi te pi'õi ma rowasu'u. ");
INSERT INTO xavNT_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Tawamhã pi'õ te duré tãma tinha: — Niwapsi te za we datẽme wi, Danho'reptui'wa da, 'Re ĩhâimana u'âsi mono te te ĩpisudu hã, Cristu na da te 're ĩsisi za'ra mono hã. Wei wisi wapsi, te za uburé 'Re ĩhâimana u'âsi mono nhimiroti hã te te wama 're awaihu'u, wa te 're waihu'u za'ra mono da. Ãne na hã ĩ̱ma waihu'u pese di, ĩwasu'u hã. ");
INSERT INTO xavNT_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Tawamhã Zezusi te duré asa tãma tinha: — Wa hã wa tô we datẽme wi. Wa hã te aima ĩrowasu'u hã Danho'reptui'wa, wa 're mo. — Ãne te pi'õi ma siwasu'u, Zezusi hã. ");
INSERT INTO xavNT_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Tawamhã pi'õi ma siwasu'u ré, wa tô ĩtẽme aihutu ni. Pi'õi ma nherẽ, siwasu'u wa, wa ãma watob'uzu za'ra ni, wanhimirosa'rata na si. Tane nherẽ, pi'õ hã wa te wasiwi sadanharĩ õ di, ãne: “E marĩ zô te ĩ'rata asa.” Duré Zezusi hã ãne wa te wasiwi sadanharĩ õ di: “E niha te pi'õi ma nherẽ, asiwasu'u. E marĩ da, te pi'õi ma nherẽ, ĩrowasu'u.” Ãne, wa te wasiwi sadanharĩ za'ra õ di. ");
INSERT INTO xavNT_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","29","Taha pari, te pi'õ hã oto mo, 'ri tẽme. Sisa'u ma piza hã tirẽ. Wisi wamhã, ma tô dazô hâ awa'awi, ãne: — Oto wasi'aba'réi wa'aba, aibâ hã sabu za'ra wa'aba da. Uburé te 're ĩ'ab'manharĩ mono zé hã ma tô ĩ̱ma waihu'u. Ãté õ hã 'Re ĩhâimana u'âsi mono te te ĩpisudu, Danho'reptui'wa da. ");
INSERT INTO xavNT_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Taha wa, te we oto awa'awi ĩtẽme ai'aba'ré ni, da'ahâ na. ");
INSERT INTO xavNT_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Wa norĩ hã pi'õ morĩ za'u si, wa ĩsa hã tãma 'ru za'ra ni, sa da. ");
INSERT INTO xavNT_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Tawamhã Zezusi te wama nharĩ za'ra, ãne: — Ĩ̱sa hã te ĩ̱ma tihâiba, aima ĩwaihu'u'õ za'ra wa'wa hã. ");
INSERT INTO xavNT_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Ãne hã te te wama waihu'u za'ra wa, wa tô wasima nharĩ za'ra ni: — Ãté ĩsa hã ma we tãma 'mai'ãwisi ni, nima hawi. ");
INSERT INTO xavNT_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Tawamhã te Zezusi hã asa wama nharĩ za'ra, ãne: — 'Re dasaihuri mono wamhã, dama 're rowẽ za'ra mono di za. Tane, wa hã. We ĩ̱zatõrĩ'wa te te ĩ̱'ãma ĩrotizé hã te ĩ̱sina uwaimrami wamhã, ĩ̱ma rowẽ di za. Ĩ̱nhimiromhuri hã te tãma uprosi wamhã, ĩ̱ma rowẽ di za duré. — Ãne Zezusi te wama siwasu'u za'ra. ");
INSERT INTO xavNT_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Te duré wama rowasu'u: — Daburu hã ma tô ĩ'madâ'â za'ra wa'wa. 'Madâ'â za'ra wa'aba wa, ma tô ãne ĩrowasu'u za'ra wa'wa: “Zahadu romhâ di, danho hã da te 're ĩ'rãihâri za'ra mono zéb u hã. Maparane si'uiwa na a'amo hã ãma 're si'utõrĩ mono parip si, te za amnho hã da te 're 'rãihâri za'ra. Tawapsi dama romhuri ahâ di za oto.” Ãne te a norĩ wa'wa hã ĩrowasu'u za'ra wa'wa. Ãne, wa za wa hã aima rowasu'u za'ra wa'wa oto, waihu'u za'ra wa'aba da. Buru hã 'madâ'â za'ra wa'aba. Õhõta te we oto ai'aba'ré ni. Romhuture di oto, da te ĩ̱zaze za'ra zéb u hã. Aima romhuri ahâ za'ra wa'aba di za, da te 're ĩ̱zaze za'ra mono zém na da hã. — Ãne te wama siwasu'u, Zezusi hã. ");
INSERT INTO xavNT_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Te duré wama rowasu'u za'ra, ãne: — Danho hã dama 're 'rãi'ré za'ra mono wapsi, te za da te 're 'rãihâri za'ra, buru tede'wai ma. Da te tãma 're uprosi za'ra mono wapsi, te za te te 're da'apawa'âbâ, buru tede'wa hã. Romhuri te te 're uprosi za'ra mono wamhã, tãma 're rowẽ za'ra mono di za oto, rob'rãihâri'wa norĩ ma hã. Robzuri'wa norĩ ma zama 're rowẽ za'ra mono di za. Tane wa hã buru tede'wa ne, wa za te tãma 're wa'âbâ za'ra, ĩ̱zadawa wasu'u'wa norĩ ma. Ta norĩ ma zama tãma 're rowẽ za'ra mono di za. E marĩ wa. Te te dama 're ĩ̱zadawa wasu'u za'ra mono ré, da te 're ĩ̱zaze za'ra mono wa. Duré dadâ'â ãna hâiwa ãma 're dasi'ubumroi u'âsi mono wa za, taha wa, tãma 're rowẽ za'ra mono di za. ");
INSERT INTO xavNT_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","38","Daburu na da te 're robzuri za'ra mono wamhã, te za duré da te 're 'rãihâri za'ra. Tawamhã ni'wa hã te te rob're nherẽ, te te 'rãihâri õ wamhã, te za wasu'u ni, ãne: “Õ hã ma rob're 'rata. Tane nherẽ, te te 'rãihâri õ di, si'uihâ na. Ĩ'upana sô ĩromhuri'wa si ma ĩsimiromhuri hã uprosi.” Ãne te za wasu'u ni. Tane ma tô aibâ norĩ hã aiwana te te dama 're ĩ̱wasu'u 'rata za'ra. Taha wa, te za oto da te 're ĩ̱zaze za'ra, a norĩ wa'aba zama 're ĩ̱zadawa wasu'u za'ra wa'aba mono nherẽ, datẽme te 're asatõrĩ za'ra wa'aba mono wamhã. — Ãne Zezusi ma tô wama rowasu'u za'ra, ĩsiré 're wanomro mono wa. ");
INSERT INTO xavNT_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","40","Tawamhã ahâ na ma tô ĩtẽme aihutu samaritanu norĩ hã, 'ri nho'õmo hawi. Pi'õ nhimirowasu'u hã da te saze sirõmo za'ra wa, ma tô we ĩtẽme aihutu ni. Ãne 'ri tẽme wisi wi, ma tô aré pi'õ hã dama rowasu'u: “Õ hã aibâ hã uburé te 're ĩ'ab'manharĩ mono zé hã ma tô ĩ̱ma waihu'u.” Ãne ma tô aré dama rowasu'u. Tawamhã ĩtẽme dasihutu wamhã, te ãma ropti za'ra ni, a'â da'rata sãmra da. Taha wa, te syry na da'rata nhamra, 'ri nho'õmo ãma. Tame sãmra ré, te bâdâ hã maparane ãma ne. ");
INSERT INTO xavNT_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Taha wa, da'ahâ na ma tô dasina umnhasi za'ra ni, dasi'uihâ na ĩmreme hã da te wapari za'ra wa. Danho'reptui'wa na ma tô saze za'ra ni, 'Re ĩhâimana u'âsi mono te te ĩpisutu na hã. ");
INSERT INTO xavNT_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Tawamhã te ãne pi'õi ma nharĩ za'ra, pi'õ nhimirowasu'u wapari'wa norĩ hã: — Asimirowasu'u hã wa te wapari za'ra wa, wa tô saze za'ra ni. Ãhãna wasi'uihâ na wa tô ĩmreme hã wapari za'ra ni. Taha wa, wa oto waihu'u za'ra ni, õ hã Danho'reptui'wa te 're mo. — Ãne te samaritanu norĩ hã tãma nharĩ za'ra, pi'õi ma. ");
INSERT INTO xavNT_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Tame sãmra pari, te oto apâ mo Darireza na danhipti'a nho'õmo nhisi u, Zezusi hã. Wa norĩ hã wa ĩsiré ai'aba'ré ni. ");
INSERT INTO xavNT_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","45","Zezusi hã ma tô ãne nasi wama rowasu'u za'ra aré: “'Re ĩhâimana u'âsi mono zadawa wasu'u'wa norĩ hã ĩrob ãma 're ĩdasi'ubumroi mono norĩ si, ĩsimiroti na wazép sina sô 're datob'uzu za'ra mono õ di.” Ãne Zezusi hã ma tô wama sina wasu'u za'ra aré. Taha wa, te apâ mo, Darireza u. Apâ wasihutu wamhã, ma tô dasima wẽ za'ra ni, da'rata 're sãmra mono da. E marĩ wa. Ta norĩ hã ma tô aihutu Zeruzarẽ u, Pascowa na datoi wa, dame si'rã'õtõ da. Tame ma tô ãma 'madâ'â za'ra, Zezusi hã tiwaihu'u pese na te te ĩdapawaptobzém na. Taha wa, ma tô sô tatob'uzu za'ra ni, Darireza ãma 're ĩdasi'ubumroi mono norĩ hã. ");
INSERT INTO xavNT_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Tawamhã Zezusi hã ma tô apâ wi, Cana na 'ri wa'õtõ nhisi u. Darireza na danhipti'a nho'õmo nhisi ãma, Cana hã. Tame ma tô Zezusi hã â na uwa 'ru 'rãi wa'u ĩsé 'manha aré, te te 're ĩromhõsi mono na. Cana ãma sãmra ré, ma tô aibâ hã ĩtẽme wi, Capana'u na 'ri nho'õmo nhisi hawi. Ta hã apito zadawa zapari'wa. ");
INSERT INTO xavNT_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Zezusihi wasu'u hã te te wapari sirõmo wa, ma ĩtẽme wi, ĩ'ra hã hâzé wa. Ãne te dasima wasu'u za'ra ni: “Zudeza hawi ma tô Zezusi hã wi, Darireza u.” Tawamhã ĩtẽme wisi wamhã, ãne te ti'ra hã tãma wasu'u, wawa sina: “Ĩ̱'ra hã hâzé ahâ wa, wa we asô mo, ĩ̱ma pese da. Te za oto ĩ̱wi dârâ.” ");
INSERT INTO xavNT_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Tawamhã Zezusi te asa tãma tinha: — E niha te za marĩ dama ĩ'manharĩ waihu'u'õ hã te dama 're ĩ'ab'manharĩ mono zéb zarina si 're ĩ̱zaze za'ra wa'aba mo. ");
INSERT INTO xavNT_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Taha wa, te asa tãma tinha, aibâ hã: — Ĩ̱'ra hã ĩ̱wi dâ'â õ ré, ĩ̱siré ãma aimorĩ, ĩtẽme. ");
INSERT INTO xavNT_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Tawamhã Zezusi te duré asa tãma tinha: — Te za oto apâ aimo, ĩtẽme. Ai'ra hã aiwi dâ'â õ di za. Rowẽ na te za aima 're mo. — Ãne te tãma tinha, Zezusi hã. Tawamhã ma aibâ hã ti'ra na mreme zaze. Taha wa, te apâ mo, ti'ra u. Tane nherẽ, bâtâ na ti'ra u wisi sirõmo õ di. Misi ma a'â nhono. Awẽpsi te za wi, ti'ra u hã. ");
INSERT INTO xavNT_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Tawamhã tãma ĩromhuri'wa norĩ hã 'ri tẽme wisi õ ré, ma tô sina uzusi za'ra. Ma tô tãma rowasu'u za'ra, ãne: — Ai'ra hã hâzé õ di. Rowẽ na te oto nhamra. ");
INSERT INTO xavNT_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Taha wa, ma tô ĩmama hã asa ãma sadanharĩ za'ra, ãne: — E mame bâtâ na ma tô séptârâ. Tawamhã te ãne asa tãma rowasu'u za'ra: — Bâdâ sipra wi ma tô tiwahâ. ");
INSERT INTO xavNT_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Tawamhã ĩmama te tãma rowasu'u za'ra oto: — Tane tô. Ahâmhâ bâdâ sipra wi, ma tô Zezusi hã ãne ĩ̱ma tinha: “Ai'ra hã aiwi dâ'â õ di za. Rowẽ na te za aima 're mo.” — Ãne te tãma rowasu'u za'ra, Zezusihi mreme na. Taha wa, ma tô Zezusi hã sazei pese, aibâ hã. Ĩmro zama ma tô saze. Aihĩni ma tô saze za'ra Zezusi hã, ti'ra norĩ me. Tãma ĩromhuri'wa norĩ zama ma duré saze za'ra. ");
INSERT INTO xavNT_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Ãne Darireza na danhipti'a nho'õmo nhisi ãma ma tô tiwaihu'u pese na marĩ ĩ'manharĩ waihu'u'õ hã dama 'manha Zezusi hã, Zudeza hawi wisi wi. Ãne dapawaptom na ma tô ãma sahu, 'Re ĩhâimana u'âsi mono we te te ĩsatõrĩ na, da te waihu'u za'ra da. ");
INSERT INTO xavNT_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Tawamhã daro mono bâ ma tô Zeruzarẽ ãma tasi'rã'õtõ ni, 'Re ĩhâimana u'âsi mono ãma dawata za'ra da. Taha wa, ma tô Zeruzarẽ u dame mo Zezusi hã, dame ãma wata da. Wa norĩ hã wa ĩsiré ai'aba'ré ni duré, ĩsiré 're wanomro mono wa. ");
INSERT INTO xavNT_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","5","Tawamhã Zeruzarẽ ãma te aibâ hã 're sãmra, ĩhâzé ré hã. 38 na ma tô oto ãma tiwahu, tihâzé te te 're sépata mono ré hã. Ta hã te dame nomro, ĩhâzé ré norĩ me, ĩtob'a norĩ me, duré ĩ'rãtẽire norĩ me, duré ĩhi'ré norĩ me zama. Pu'u 'rata te ta norĩ hã 're simi'wara, pu'u wawẽ 'rata. 'Ri 'wawi wa'ra ãma, pu hã. Tame 'ridawa hã pone'ẽrebâ 'mazasizé hã. Wamremezém na Betezata na 'ridawa nhisi hã. Pu'u 'rata te uridi hã 're simasa, 5 na ĩhâiba hã. Tame te da'ahâ na 're danhimi'wara uriti wa, ĩhâzé ré hã. Hâiwa ãma Danhib'apito uptabi ma romhuri'wa zô, te dasina 're danhimipari za'ra. Ta hã te we 're ne hâiwa hawi, â hã te te 're upi mono wa, 're âsisasisi mono da. Tawamhã ni'wa hã â sisasisi ré, te te ĩsi'rai 'rada hã te za séptârâ. ");
INSERT INTO xavNT_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Tawamhã Zezusi hã ma tô oto datẽme wi, ĩhâzé ré norĩ u. Wisi wi, ma aibâ hã tisã. Hâzé ré ãma ĩwahub ahâ na ma tô waihu'u, Zezusi hã. Taha wa, te aibâ ma tinha: — E aséptâ'â da hã te asima ĩwẽ. ");
INSERT INTO xavNT_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Tawamhã aibâ ma asa sada'â: — Apito, ni'wa hã hâimana õ di, 're âsisasisi mono ré, ĩ̱'ãma ĩsi'rai'wa da hã pu'u u. Âi ba atãma hâire nasi ĩ̱si'réi mono ré, te nasi ĩ̱wana si'ra za'ra ni, âi ba. — Ãne te aibâ hã Zezusihi ma siwasu'u. ");
INSERT INTO xavNT_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Taha wa, ma tô Zezusi hã tãma tinha, ãne: — Ma'ãpé, aiwahutu. Asa'warizé hã âri, aimorĩ da oto. ");
INSERT INTO xavNT_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Taha wa, ma awa'awi tipese, aibâ hã. Pese wamhã, tiza'warizé hã ma tô ti'â. Tawamhã para na te oto 're mo. Ãne na hã sabadu na ma tô tiromhâiba, romhuri zahârizém na. ");
INSERT INTO xavNT_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Taha wa, ma tô zudezu norĩ nhib'apito norĩ hã tãma nharĩ za'ra, ãne: — 'Re ĩhâimana u'âsi mono ma tô dama roti, da te 're romhuri za'ra mono tõ da, sabadu na hã. A hã ĩsimiroti 'madâ'â ãna te asa'warizé hã 're ĩ'â, romhuri zahârizém na hã. ");
INSERT INTO xavNT_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Taha wa, te aibâ hã asa tãma nharĩ za'ra: — Aibâ hã ĩ̱pese'wa hã ma tô ĩ̱za'warizé hã ĩ̱ma ti'ru. Ĩ̱para na oto 're ĩ̱morĩ da, te duré ĩ̱ma tinha. ");
INSERT INTO xavNT_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Tawamhã te sadanharĩ za'ra: — E 'wa hã ma tô asa'warizé hã aima ti'ru. E 'wa hã ma tô duré aima tinha, aipara na 're aimorĩ da hã oto. ");
INSERT INTO xavNT_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Taha wa, ma tô duré aibâ hã asa tãma nharĩ za'ra: — Me. Te waihu'u õ di, wa hã. — Ãne te tãma nharĩ za'ra. Zezusi hã te te pese pari, ãma sapa'a õ di. Da'ahâ wa, te awa'awi ĩsiti mo. Ãne wa, Zezusihi nhisi hã te te waihu'u õ di, aibâ hã. ");
INSERT INTO xavNT_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Tawamhã 'ri 'wawi wa'ra 're, ma tô aibâ hã sõpẽtẽ Zezusi hã, 'Re ĩhâimana u'âsi mono ãma 're ĩdawata za'ra mono zéb ãma. Te te sõpẽtẽ wamhã, ãne te aibâ ma tinha, Zezusi hã: — Ma tô oto aséptâ, ãhãna hã. Taha wa, aiwasédé hã 're 'manharĩ mono õ di za oto, 're 'manharĩ u'âsi mono wa, marĩ ĩwasété uptabi hã aima romhâimana õ'umnhasite. — Ãne te tãma tinha. ");
INSERT INTO xavNT_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Tawamhã aibâ te mo, dama ĩpire norĩ u. Ãne te tãma siwasu'u za'ra: — Ĩ̱pese'wa hã, wa tô waihu'u. Zezusi hã ma tô ĩ̱pese. ");
INSERT INTO xavNT_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Taha wa, dama ĩpire norĩ hã te oto sada tihâimana za'ra, romhuri zahârizém na te te pese wa, sabadu na. ");
INSERT INTO xavNT_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Tawamhã Zezusi hã ma tô tãma nharĩ za'ra, ãne: — Ĩ̱mama hã te za te te 're da'apawaptob u'âsi. Ĩ̱zama wa za duré te 're da'apawapto. — Ãne te tãma siwasu'u za'ra. ");
INSERT INTO xavNT_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Taha wa, te ãma sima roti za'ra, te te siwi wĩrĩ da, romhuri zahârizé hã ĩsimiroti za'ra zarina, te te 'madâ'â õ wa, duré 'Re ĩhâimana u'âsi mono hã Timama na te te wasu'u wa, aiwa ĩwaihu'u pese zahuré na hã. ");
INSERT INTO xavNT_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Tawamhã Zezusi hã te duré tãma nharĩ za'ra: — Tô sena, wa aima waihu'u za'ra wa'wa. Wa hã ĩ̱si'uihâ na dama ĩ'manharĩ waihu'u'õ na te 're da'apawapto waihu'u mono õ di. Ĩ̱mama zadawa para, wa tô te 're da'apawapto. Ĩ̱mama hã tiwaihu'u pese na te te 're ĩda'apawapto mono ne, wa tô te 're da'apawapto. ");
INSERT INTO xavNT_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Wa hã ĩ'ra wa, te te 're ĩ̱zawi pese. Ta hã ma tô ĩ̱pisutu, dama ĩ'manharĩ waihu'u'õ na te te 're ĩda'apawapto mono ne, te duré 're da'apawapto mono da. Wa hã te 're da'apese mono wa, ma tô ĩ̱'ãma 're datob'uzu za'ra. Zahadu wapsi, Ĩ̱mama te za duré ĩ̱ma tinha, tiwaihu'u pese na te te 're da'apawapto mono zarina, te 're da'apawapto mono da. Tawamhã te za duré ĩ̱'ãma 're datob'uzu za'ra, ĩ̱waihu'u pese uptabi wa. ");
INSERT INTO xavNT_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","'Re dadâ'â za'ra mono wa, te Ĩ̱mama hã ab're hawi te te 're da'ahâiwa'utu, apâ 're danomro u'âsi mono da. Ĩ̱zama te ĩ̱sima 're ĩ'awẽ mono norĩ ma, wa za duré te 're anharĩ, apâ 're hâiwa'utu za'ra mono wa, 're nomro u'âsi mono da, wa hã ĩ'ra wa. Tawapsi te za da te 're ĩ̱waihu'u za'ra, ĩ̱waihu'u pese uptabi na. ");
INSERT INTO xavNT_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","23","Ĩ̱mama hã 'râwi sipisutu õ di, ti'ai ãma dahâimanazéb zarina te te dama 're arowairébé mono da. Taha da, ma tô ti'ra wa, ĩ̱pisutu. E marĩ da. Ãma 're ĩdawata za'ra mono ne, ĩsine ĩ̱waihu'u pese wa, ĩ̱'ãma zama 're dawata za'ra mono da. Ĩ̱'ãma 're dawata za'ra mono õ wamhã, we ĩ̱zatõrĩ'wai ãma zama duré 're dawata za'ra mono õ di za, Ĩ̱mama ãma. ");
INSERT INTO xavNT_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","25","— Ĩ̱mreme hã da te 're wapari za'ra mono wamhã, duré we ĩ̱zatõrĩ'wa hã da te dasina 're umnhasi za'ra mono wamhã, te za tipẽ'ẽ na sina uwaimrami sirõmo za'ra, rowẽ na 're ĩdahâimana u'âsi za'ra mono zé hã. 'Re ĩhâimana u'âsi mono nhimihâzé hã te te sina 're waihu'u za'ra mono õ di za. Te za tipẽ'ẽ na ãma saprĩ sirõmo za'ra, dapẽ'ẽ 're, dadâ'â u'âsi 're ĩdahâimana za'ra mono zém hawi, dapẽ'ẽ 're rowẽ na 're ĩdahâimana u'âsi za'ra mono zéb u hã. ");
INSERT INTO xavNT_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Ĩ̱mama hã dapẽ'ẽ 're, dadâ'â ãna rowẽ na 're ĩdahâimana u'âsi za'ra mono zé nhomri'wa dama. Ĩ'ra wa, ma tô duré ĩ̱pisutu, ĩ̱zama 're ĩdahâimana u'âsi za'ra mono zé nhomri'wa na dama 're ĩ̱hâimana mono da. ");
INSERT INTO xavNT_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Ta hã ma tô duré ĩ̱ma tinha, ti'ai ãma dahâimanazéb zarina, te dama 're arowairébé mono da, ĩsadawa para wa hã ti'ai ãma dasiré ĩ̱podo hã 're ĩ̱hâimana mono wa. ");
INSERT INTO xavNT_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","29","— Ĩ̱mreme na atob'uzu za'ra wa'aba mono õ di za. Niwapsi te za 're ĩdadâ'â za'ra mono hã tahâiwa'utu za'ra ni. Ĩ̱hârâ hã da te wapari za'ra wa, te za ab're hawi tawairébé ni. Tawamhã 're ĩnomro wẽ mono norĩ hã te za apâ hâiwa'utu za'ra, rowẽ u'âsi 're hâimana u'âsi za'ra mono da oto, 'Re ĩhâimana u'âsi mono 'rata. 'Re ĩnomro wasété mono norĩ zama, te za duré apâ hâiwa'utu za'ra, 'Re ĩhâimana u'âsi mono nhimihâzé hã te te sina 're waihu'u za'ra mono da. ");
INSERT INTO xavNT_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","— Ĩ̱nhimipisutu zarina si, marĩ na te dama 're arowairébé mono õ di za. Ĩ̱mama nhimipisutu zarina si, wa za ti'ai ãma 're ĩdahâimana za'ra mono zéb zarina, te dama 're arowairébé. Ĩ̱nhimipisutu zarina, marĩ na te dama 're arowairébé mono da, te ĩ̱sima 're da'awẽ mono õ di, wa hã. We ĩ̱zatõrĩ'wa nhimipisutu zarina si, te dama 're arowairébé mono da, wa ĩ̱sima te 're da'awẽ u'âsi. Taha wa, te dama 're arowairébé mono wamhã, te dama ãma upa za'ra õ di za. Duré ropipa hã 're ĩnomro wasété mono norĩ ma, te 're apisutu mono wamhã, te tãma ãma upa za'ra õ di za. ");
INSERT INTO xavNT_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","— Ĩ̱siwaprosi uptabi, aima ĩ̱siwasu'u za'ra wa'aba õ di. Ni'wa te te ĩ̱zadawa waptob õ wamhã, ãté te za ĩ̱zadawa nhipese na ĩ̱ma 're ĩnharĩ za'ra wa'aba mo. Taha wa, ĩ̱siwaprosi uptabi, aima ĩ̱siwasu'u za'ra wa'aba õ di. ");
INSERT INTO xavNT_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Ĩhâiba amo hã ma tô ĩ̱zadawa wapto. Tô sena ma tô aima sina ĩ̱wasu'u za'ra wa'wa. Ãne na wa tô waihu'u. ");
INSERT INTO xavNT_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","37","— Â ro'ore hã te te dama rob'uiwẽ wamhã, dama rowẽ di. Tane Zuwã Batita hã ma tô simi'ẽ na te te dama 're sadawa wasu'u, 'Re ĩhâimana u'âs