﻿USE sofia;
DROP TABLE IF EXISTS sofia.wuv_vpl;
CREATE TABLE wuv_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES wuv_vpl WRITE;
INSERT INTO wuv_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Fei wa'afa'aiaa minaa fei wawapuge i nomai wagina Jesus Christ, mei pai David, mei pai Abraham: ");
INSERT INTO wuv_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Abraham na fuainaa Isaac, mei amaa Jacob. Jacob na fuainaa Judah mawe ei lofuna, ");
INSERT INTO wuv_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Judah na fuainaa Perez ma Zerah. Inaa lagua, Tamar. Perez na fuainaa Hezron, mei amaa Ram. ");
INSERT INTO wuv_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Ram na fuainaa Amminadab. Amminadab na fuainaa Nahshon. Nahshon na fuainaa Salmon. ");
INSERT INTO wuv_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salmon na fuainaa Boaz ma mei inaa Boaz, Rahab. Boaz na fuainaa Obed ma mei inaa Obed, Ruth. Obed na fuainaa Jesse ");
INSERT INTO wuv_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","ma Jesse na fuainaa mei hapara David. David na fuainaa Solomon. Mei inaa Solomon, hia do'o haroo Uriah. ");
INSERT INTO wuv_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Solomon na fuainaa Rehoboam. Rehoboam na fuainaa Abijah. Abijah na fuainaa Asa. ");
INSERT INTO wuv_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asa na fuainaa Jehoshaphat. Jehoshaphat na fuainaa Jehoram. Jehoram na fuainaa Uzziah. ");
INSERT INTO wuv_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Uzziah na fuainaa Jotham. Jotham na fuainaa Ahaz. Ahaz na fuainaa Hezekiah. ");
INSERT INTO wuv_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Hezekiah na fuainaa Manasseh. Manasseh na fuainaa Amon. Amon na fuainaa Josiah. ");
INSERT INTO wuv_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Ma Josiah na fuainaa Jeconiah mawe ei lofuna a'a fei au rona suganaa ro'ou Babylon. ");
INSERT INTO wuv_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Nenee fei ro'aa suganaa ro'ou Babylon: Jeconiah na fuainaa Shealtiel. Shealtiel na fuainaa Zerubbabel. ");
INSERT INTO wuv_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Zerubbabel na fuainaa Abiud. Abiud na fuainaa Eliakim. Eliakim na fuainaa Azor. ");
INSERT INTO wuv_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Azor na fuainaa Zadok. Zadok na fuainaa Akim. Akim na fuainaa Eliud. ");
INSERT INTO wuv_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eliud na fuainaa Eleazar. Eleazar na fuainaa Matthan. Matthan na fuainaa Jacob. ");
INSERT INTO wuv_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Ma Jacob na fuainaa Joseph mei haroo Mary, mei i wanininaa Jesus, mei rona roroinia Christ. ");
INSERT INTO wuv_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Si'ei, puduu ei tawe watolaa Abraham ma David, hefua ma obao. Ina pa'i hefua ma obao watolaa David ma fei ba hefi'a na suganaa ro'ou Babylon ma hefua ma obao watolaa fei gutaa ro'ou i Babylon ma fei waniniaa mei Christ. ");
INSERT INTO wuv_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Fei waniniaa Jesus Christ na nomai ale'ei: mei inana Mary na tama'ai'au ba i lalainaa Joseph, ma'uaa ana lagutawe hainofipui ma na pa'idii iana a'a fei Spiriti Apuna. ");
INSERT INTO wuv_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Si'ei ba mei harona, Joseph, hia hemea wanewane rama'a, lomi na nunumiai ba i famamafaia pudaa rama'a, ina nara ba i fi'alagipa'ai a'ana. ");
INSERT INTO wuv_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Ma'uaa nenee fei naranarana fei, hemea alo'aloo mei Fasu na fa'arewa a'ana laloo mefina ma na ware, “Joseph, mena na'uu David, apuna ma'au ba o duginaa Mary humumu ale'ei haromu, uaa fei na toro laloo iana, pa'ana a'a fei Spiriti Apuna. ");
INSERT INTO wuv_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","I wanininaa hemea baduu wawane ma onei roroinaa harana Jesus, uaa i fatela'anaa ei rama'aa gufuna a'a ei hafelo'aa ro'ou.” ");
INSERT INTO wuv_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Ei manumanu ei, pa'afina ba i fafa'uainaa tamanu mei Fasu nadii wareia a'a mei mamama'a: ");
INSERT INTO wuv_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“Mei nanao a'u'uanarai atawe dinaa a'a hemea wawane, i pa'i iana ma i wanininaa hemea baduu wawane ma ro'aa roroinia Immanuel”—hanuna ba “Mei Haidaa i a'a o'ou.” ");
INSERT INTO wuv_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","I'a wera Joseph, ina bigi'aa tamanu mei alo'aloo mei Fasu na ware ba inei bigi'ia. Ma ina noduginaa Mary humuna ale'ei harona. ");
INSERT INTO wuv_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Ma'uaa lomi na hainofipui a'ana nopa'aloo fei ba na wanini mei baduu wawane. Ma mei amana na roroinaa fei harana ba Jesus. ");
INSERT INTO wuv_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","A'a fei au haparaiaa Herod, Jesus na wanini yei Bethlehem fawelei Judea. Nenee fei waniniana, ei ano'ano, noramiaa ro'ou pepei anaa halo, rona nomai Jerusalem ");
INSERT INTO wuv_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","ma i'igai, “Amaia mei ina wanini ba haparaa ei Jew? Hai'ouna fanunupa'aa fei pi'una pepei anaa halo ma ba hai'ou losuinia.” ");
INSERT INTO wuv_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","I'a guainaa fei mei hapara Herod, hia ma minaa ei rama'aa Jerusalem, ronamina naranara watauda. ");
INSERT INTO wuv_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","I'a harofigupuinaa minaa ei famamoaa humuu mei Haidaa mawe ei feroiaa law, na i'iginaa ro'odu ba i wanini hitani mei Christ. ");
INSERT INTO wuv_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Rona ware, “Yei Bethlehem, i fawelei Judea, uaa sifeni, feni ne'iaa mei mamama'a: ");
INSERT INTO wuv_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","“‘Ma'uaa yoi, Bethlehem, yena malalaa Judea, fa'ua ba onamina pusu'oroi ma'uaa, ana ona bauana a'a ei bauaniaa Judah; uaa, i a'amu iwe nomai hemea hapara ma i oma'aa ei maroau, rama'aa Israel ale'ei hemea oma'aa ei sipsipi.’” ");
INSERT INTO wuv_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Si'ei, Herod na haro'u'ugainaa ei ano'ano ma i'igifagiginaa ro'ou fei pa'aa au ro'aa fanunupa'aa fei pi'u. ");
INSERT INTO wuv_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Ma ina ware, “Hamonei aunu ma labagifarawaninaa mei baduu. Hamona labagipa'ia, mi warefanau ma ana u'aree losuinia.” Ma ina alonaa ro'ou yei Bethlehem. ");
INSERT INTO wuv_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Ro'aa guaidigaa wareaa mei hapara, rona aunulao ma fei pi'u, fei fanunupa'aa ro'ou pepei anaa halo, na nolao i ma'aa ro'ou ma no'ulao fawelei i wagina mei baduu. ");
INSERT INTO wuv_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Ro'aa fanunupa'aa fei pi'u, ronamina ni'eni'e. ");
INSERT INTO wuv_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Ro'aa nopa'aloo fei humu, rona ma'apa'aa mei baduu mawe mei inana Mary ma rona fa'unaa du'uu ro'ou ma losuinia. Si'ei, rona gigiaa ei pa ro'ou ma fania ei fanaa ro'ou—ei gold ma ei manumanu dufaa ma hefi'adiai ranuu ei haihai na dufa. ");
INSERT INTO wuv_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Ma si'ei ba rona apa'idigia laloo ei mefii ro'ou ba ronei'aa hadiwe'ainaa a'a Herod, rona tonaa hepalodiai tala ma hadiwe'idinaa gufuu ro'ou. ");
INSERT INTO wuv_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Ro'aa aunudii, hemea alo'aloo mei Fasu na fa'arewa a'a Joseph laloo fei mefi. Ina ware, “Asi'adugaa mei baduu mawe mei inana ma ponipa'ainaa Egypt. Guta yena hawina na warefa'aio, uaa Herod fi labaginaa mei baduu ba i fo'afama'eia.” ");
INSERT INTO wuv_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Si'ei, i nopoilao Joseph na asi'adugaa mei baduu ma mei inana ma rona aununaa Egypt ");
INSERT INTO wuv_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","ma ina guta yei nopa'aloo fei ma'eaa Herod. Ma si'ei, napa'aa fa'uai tamanu inadii wareia mei Fasu a'a mei mamama'a: “Una harofa'asi'anamii mei na'uu, baduu wawane, yei Egypt.” ");
INSERT INTO wuv_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","I'a narapa'ia Herod ba rona sifi'ia ei ano'ano, namina sibafafelo ma na faniwarea ba ronei fo'afama'eaa minaa ei baduu wawane yei Bethlehem ma yei a'a ei gufu i malalana, ei rona pa'i guai igisimasi mawe ei rotaa pa'i guai igisimasi, ale'ei fei au i guainia a'a ei ano'ano. ");
INSERT INTO wuv_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Si'ei ba ei wareaa mamama'a Jeremiah napa'aa fa'uai: ");
INSERT INTO wuv_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“Rona guainaa hepalo lao yei Ramah, ai'aiga ma baua faloloa'ia, Rachel na aigaa ei na'una; ma lomi na nunuminaa nemea ba i faloloa'inia, uaa lomi rona oadiai.” ");
INSERT INTO wuv_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","I ma'edii Herod, hemea alo'aloo mei Fasu na fa'arewa a'a Joseph laloo fei mefi yei Egypt ");
INSERT INTO wuv_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","ma na warenaa a'ana, “Asi'aa, dugaa mei baduu mawe mei inana ma dinaa fei gufu Israel, uaa ei ba ro'aa fo'afama'eaa mei baduu, rona ma'edii.” ");
INSERT INTO wuv_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Si'ei, na asi'aa, dugaa mei baduu mawe mei inana ma rona dinaa fei gufu Israel. ");
INSERT INTO wuv_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Ma'uaa i'a guainia ba Archelaus na tonaa fei haparaiaa mei amana Herod yei Judea, ina ma'au ba i dinaa yei. Si'ei ba laloo fei mefina na tonaa hefaa warefa'aia, na momo'ainaa Galilee ");
INSERT INTO wuv_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","ma naree guta laloo hefaa gufu, harana Nazareth. Si'ei, nawe pa'aa fa'uai ei wareaa ei mamama'a: “Ro'awe ware ba hia, hemea Nazareth.” ");
INSERT INTO wuv_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","A'a ei arewaa ei, John, mei Pudugufaia na nomai ma na u'u yei Judea fawelei abaa wawawau rama'a ");
INSERT INTO wuv_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","ma na ware, “Filoginaa naranaraa hamu'ou, uaa fei haparaiaa mei Haidaa na rafi'i.” ");
INSERT INTO wuv_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Simeni, meni idii wareia mei mamama'a Isaiah: “Fei lao hemea i haroharomai fawelei abaa wawawau rama'a, ‘Ra'a'augaa fei talaa mei Fasu, fawanewaneaa ei talana.’” ");
INSERT INTO wuv_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Fei susuu John, bigi'aa ro'ou hugoo camel ma fei adii walana, hudii manulelele. Ei hanana, teraupu ma musilao podu. ");
INSERT INTO wuv_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Ei rama'a noramiaa ro'odu Jerusalem ma minaa ei gufu i Judea ma fawelei Jordan, rona dinaa a'ana. ");
INSERT INTO wuv_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Rona warefania ei hafelo'aa ro'odu ma ina pudugufinaa ro'odu laloo fei Ranu Jordan. ");
INSERT INTO wuv_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Ma'uaa i'a fanunupa'aa watauda Pharisee ma Sadducee ba rona nomai fawelei ifi pudugufainaa ei rama'a, ina warefanaa ro'ou, “Hamu'ou ena na'uu wa'awa'a! Hini mei i warefa'aiaa hamu'ou ba hamonei ponipa'ai a'a fei au sibaa, fei ba i nomai? ");
INSERT INTO wuv_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Ei maumau hamu'ou nei fama'aia ba hamona filogidigaa naranaraa hamu'ou. ");
INSERT INTO wuv_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Apuna naranara ale'ei ba ‘amaa hai'ou, Abraham.’ U'ei warefanaa hamu'odu ba mei Haidaa na hawia ba i fa'asi'afani na'uu Abraham a'a ei mugoo. ");
INSERT INTO wuv_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Fei poa na udedii wagii ei waraa ei haihai ma tamanu haihai lomi na fuafarawani, i reresuminaa hafi. ");
INSERT INTO wuv_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","“A pudugufinaa hamu'ou ranu wagii fei filogiaa naranara. Ma'uaa neneu, iwe nomai hemea na faufaudiai laraa yau ma yau ana lomi na rawani ba a talaitonaa ei hafenaa pinena. I pudugufinaa hamu'ou Spiriti Apuna fininaa hafi. ");
INSERT INTO wuv_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Fei nuenueina na udedii i panina ba i famama'aa fei e'eaa nuenueina ma i tolafui'augaa ei wheat laloo fei ude'udee ro'ou ma ei meme, i siminaa fei hafi lomi i peretoo.” ");
INSERT INTO wuv_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Jesus noranamai Galilee ma na dinaa yei Jordan ba nei pudugufinia John. ");
INSERT INTO wuv_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Ma'uaa John ba i pauninia ma na ware, “Yoi nei pudugufinau. Tani o nomai a'au?” ");
INSERT INTO wuv_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Jesus na ware, “Agunei bigi'ia ale'eni e'eni. Ina wanewane ba agua bigi'aa feni ba i fafa'uainaa ei diware'augaa mei Haidaa.” Ma si'ei, John na ugainia. ");
INSERT INTO wuv_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","I'a pudugufaidii Jesus, ina asi'aa laloo fei ranu ma ana ei ua, na gigi fei gufu pafea ma ina fanunupa'aa fei Spiritii mei Haidaa, fei maumauna ale'ei pune fi falorogio pafona. ");
INSERT INTO wuv_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Ma hepalo lao na harogio i gufu pafea ma na ware, “Simeni, meni na'uu, meni una haguia ma unamina ni'eni'e a'ana.” ");
INSERT INTO wuv_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","I dii, fei Spiriti na noduginaa Jesus fawelei abaa wawawau rama'a ba nei manimania mei hani'u. ");
INSERT INTO wuv_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Nenee fei i fabao laloo gunaroa pa'aniaa arewaa ma poi, ina bao. ");
INSERT INTO wuv_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Mei manimania na nomai a'ana ma na ware, “Nabaa yoi Na'uu mei Haidaa, ware a'a eni mugoo ba ronei filoginaa faraa pidaua.” ");
INSERT INTO wuv_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Jesus na ware, “Rona ne'idigia ba: ‘Ei rama'a, lomi ro'aa gutalao a'a ei faraa pidaua ua, ma'uaa a'a minaa ei warea noranamai haba'umuu mei Haidaa.’” ");
INSERT INTO wuv_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","I dii, mei hani'u na noduginaa hia a'a fei baua gufu na apunai ma na fa'ufalarainia pafoo fei sidesidee fei humuu mei Haidaa. ");
INSERT INTO wuv_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Ina ware, “Nabaa yoi Na'uu mei Haidaa, fapasinaa yoi pu. Uaa rona ne'idigia: “‘I ware a'a ei alo'alona ba ronei hadumio ma ro'aa poronaa yoi pafea a'a ei panii ro'odu ba nepalo mugoo nei'aa bi'a'ainaa pinemu.’” ");
INSERT INTO wuv_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Jesus na warenaa a'ana, “Ana na ne'idii: ‘Apuna manimaniaa mei Fasu, mei Haidaniamu.’” ");
INSERT INTO wuv_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","I didiai, mei hani'u na noduginaa hia a'a hepalo tarea maugeni ma fama'aia minaa ei gufuu ei hapara a'a feni ano ma ei fananamaiaa ro'ou. ");
INSERT INTO wuv_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Ina ware, “Minaa e'eni a fanio nabaa o fa'unaa du'umu ma losuinau.” ");
INSERT INTO wuv_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Jesus na warefania, “Faraua a'au, Satan! Uaa na ne'idii ba ‘Losuinaa mei Fasu, mei Haidaniamu ma biginenegi'uaia.’” ");
INSERT INTO wuv_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","I dii, mei hani'u na di'ininia ma ei alo'alo, rona nomai a'ana ma hadumia. ");
INSERT INTO wuv_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","I'a guainia Jesus ba rona aunaa John humuu bobo'aia, na hadiwe'inaa Galilee. ");
INSERT INTO wuv_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Na di'ininaa Nazareth ma aunu, reguta Capernaum, yei papaa fei ranu fawelei Zebulun ma Naphtali— ");
INSERT INTO wuv_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","ba i fafa'uainaa ei idii wareia mei mamama'a Isaiah: ");
INSERT INTO wuv_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“Fei malalaa Zebulun ma fei malalaa Naphtali, fei tala dinaa agi i papaa Jordan ma fei gufu Galilee, fei gufuu ei Gentile— ");
INSERT INTO wuv_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","ei rama'a rona guta laloo fei roromaa, rona fanunupa'aa hepalo baua we'ai; ma a'a ei rona guta i malalaa fei hanunuu fei ma'ea, fei we'ai na arewa.” ");
INSERT INTO wuv_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","A'a fei au fei ma nolao, Jesus nawe u'u'u, “Filoginaa naranaraa hamu'ou, uaa fei haparaiaa mei Haidaa na rafi'i.” ");
INSERT INTO wuv_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Ei fi talailao piyee Agii Galilee, Jesus na fanunupa'aa laguei filofui, Simon, mei rona roroinia Peter ma mei lofuna Andrew. Lagu'ei sumai lepo laloo fei agi, uaa lagua dia'agi. ");
INSERT INTO wuv_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Na ware Jesus, “Nomai. Nenerau ma a feroinaa hamugua tonaa rama'a ale'ei hamuna'o to nia.” ");
INSERT INTO wuv_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Ana ei ua, lagunadii augaa ei lepoo lagua ma nenegia. ");
INSERT INTO wuv_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","I'a nodilao, na fanunupa'aa helaguidiai filofui, James ma John. Lagua, na'uu Zebedee. Lagua laloo fei wa a'a mei amaa lagua Zebedee ma lagu'ei hinu'aa ei lepoo lagua. Jesus na harofaa lagua ");
INSERT INTO wuv_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","ma ana ei ua, laguna di'ininaa fei wa mawe mei amaa lagua ma nenegia. ");
INSERT INTO wuv_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Jesus na tatalai yei Galilee ma feroi laloo ei synagogue ro'ou, na u'ugaa fei rawani'a warea wagii fei haparaia ma na fapedugaa minaa ei mau funua ma ei hafelo'aa unuu ei rama'a. ");
INSERT INTO wuv_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Fei u'ugana namina talaipedunaa Syria ma ei rama'a, rona duginamii a'ana minaa ei rona funu a'a watauda mau funua, ei naminapa'aa fi'i unuu ro'ou, ei rona wadu'aa ro'ou ei pigea, ei rona'o memeroi mawe ei na ma'e unuu ro'ou ma ina farawaninaa ro'ou. ");
INSERT INTO wuv_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Hefi'a baua gupuu rama'a, noramiaa ro'ou, Galilee, Decapolis, Jerusalem, Judea ma ei gufu fipepei Jordan, rona nenegia. ");
INSERT INTO wuv_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","I'a fanunupa'aa ei gupuu rama'a, na fanenaa pafoo fei maugeni ma na guta. Ei otalai nenerana, rona nomai a'ana ");
INSERT INTO wuv_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","ma ina'aa feroinaa ro'ou ma na ware: ");
INSERT INTO wuv_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Ni'eni'ea a'a ei rona fapapanai a'a mei Haidaa, uaa fei haparaia pafea, manumanuu ro'ou. ");
INSERT INTO wuv_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Ni'eni'ea a'a ei ronapa'aa faloloa'i, uaa i pa'i nemea ba i farawaninaa ei naranaraa ro'ou. ");
INSERT INTO wuv_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Ni'eni'ea a'a ei rona fafafauaa naranaraa ro'ou, uaa ro'awe tonaa fei malagufu. ");
INSERT INTO wuv_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Ni'eni'ea a'a ei rona bao ma sigigi wagii ei wanewaneaa manumanu, uaa ro'awe magu. ");
INSERT INTO wuv_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Ni'eni'ea a'a ei rona faloloa'inaa hefi'a, uaa nemea iwe faloloa'inaa ro'ou. ");
INSERT INTO wuv_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Ni'eni'ea a'a ei na fafa'arai ei naranaraa ro'ou, uaa ro'aa fanunupa'aa mei Haidaa. ");
INSERT INTO wuv_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Ni'eni'ea a'a ei rona'o fapedugaa fisibaiaa hefi'a, uaa nemeadiai iwe roroinaa ro'ou na'uu mei Haidaa. ");
INSERT INTO wuv_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Ni'eni'ea a'a ei rona to fi'ia wagii ei manumanu na wanewane, uaa fei haparaia pafea, manumanuu ro'ou. ");
INSERT INTO wuv_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","“Ni'eni'ea a'a hamu'ou nabaa ena rama'a, rona warefafeloaa hamu'ou, haperararaiaa hamu'ou ma warefasifi ba hamona bigi'aa ei maumau hafelo ma rona bigi'aa ei manumanu ei a'a hamu'ou, uaa yau. ");
INSERT INTO wuv_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Ni'eni'e ma unuwenuwe, uaa na bauanai fei pono'aa hamu'ou i pafea, uaa ana rona haperararaiaa ei mamama'a mina. ");
INSERT INTO wuv_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","“Hamu'ou ale'ei agii feni malagufu. Ma'uaa nabaa fei agi na pa'ai fei agi'agiana, batanai ba i agi'agiadiai? Lomidiai bigi'ana; hepalo ua bigi'ana ba ro'aa siminaa ano ma ro'aa talaihapuninia ei rama'a. ");
INSERT INTO wuv_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","“Hamu'ou ale'ei we'ai feni malagufu. Hepalo baua gufu pafoo maugeni, pa'aa lomi i ude'opa'aipa'i. ");
INSERT INTO wuv_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Ana lomi ba ei rama'a, ro'aa ha'inaa ei we'ai ro'ou ma augia haroo hepalo hagi. Ma'uaa ro'aa augia pafoo fei ude'udena ma i we'ainaa minaa ei rama'a laloo fei humu. ");
INSERT INTO wuv_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Ana ale'ei, fawe'ainaa ei we'ai hamu'odu i pudaa ei rama'a ba ro'aa fanunupa'aa ei rawani'a bigi'aa hamu'ou ma uduginaa mei Amaa hamu'ou pafea. ");
INSERT INTO wuv_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","“Apuna nara ba eni a nomai ba a fapedugaa fei Law o ei Mamama'a; abaa eni a nomai ba a fapedugaa ro'ou, ma'uaa ba a bigi'aa tamanu ronadii wareia. ");
INSERT INTO wuv_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","A warefa'uai a'a hamu'ou ba, i apa'ai fei haroo pafea ma feni malagufu, ma'uaa lomi ba i pa'ai ma'ida ne'ia, o hepalo dibaa nene'i wagii fei Law hawina ba minaa ei manumanu lalona na nodigimai. ");
INSERT INTO wuv_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Hini i barafeaa ma'ida ei warea lalona ma feroinaa hefi'a ba ronei bigi'ia ale'ei, hia, lomi ba i pa'i harana a'a fei haparaia pafea, ma'uaa hini i feroi ma neneraa eni warea eni, iwe pa'i baua harana a'a fei haparaia pafea. ");
INSERT INTO wuv_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Uaa u'ei warefanaa hamu'ou ba nabaa ei wanewaneaa hamu'ou lomi i muainaa ei wanewaneaa ei Pharisee mawe ei feroiaa law, pa'aa lomi ba hamo'aa wadu'ainaa laloo fei haparaia pafea. ");
INSERT INTO wuv_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","“Hamona aida ba ei rama'aa mina, rona guainia ba, ‘Apuna fo'afama'e, ma hini i fo'afama'e, i oa a'a fei dududua.’ ");
INSERT INTO wuv_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Ma'uaa u'ei warefanaa hamu'ou ba hini i siba a'a mei lofuna, ana i oa a'a fei dududua. Hepalodiai, hini i ware ‘Raca’ a'a mei lofuna, hia, i u i pudaa ei Sanhedrin. Ma'uaa hini i ware ba, ‘Yoi pa'aa lomi apa'amu!’ i fagiana a'a fei hafi lomi i peretoo. ");
INSERT INTO wuv_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","“Si'ei, nabaa o'aa augaa ei fanamu a'a fei tawahafi na apunai yei humuu mei Haidaa ma yei ona nonominia ba mei lofumu na pa'i awatana a'amu, ");
INSERT INTO wuv_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","di'augaa fena fanamu yena i ma'aa fena tawahafi na apunai. Ma do'o aunu ma fawanewaneia a'a mei lofumu. Nene, hadiwe'imai ma fanaa fei fanamu. ");
INSERT INTO wuv_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","“Fawanewanebatafainia a'a mei i bidi ununa a'amu, mei ba i dududuio. Bigi'ia ei hamu'eifi talailao i ma'aa tala. Nabaa lomi, i aunaa yoi i panii mei fadududua ma mei fadududua i aunaa yoi panii mei ba ipowe aunaa yoi humuu bobo'aia. ");
INSERT INTO wuv_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","A warefa'uai a'amu, lomi o asi'aa hawina ona hodipedugaa ei mugoo po'ina. ");
INSERT INTO wuv_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","“Hamona aida ba ei rama'aa mina, rona guainia ba, ‘Onei'aa fiharoharoipa'ai.’ ");
INSERT INTO wuv_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Ma'uaa u'ei warefanaa hamu'ou ba hini i nanamainaa nemea pifine, ina fiharoharoipa'aidii a'ana laloo fei naranarana. ");
INSERT INTO wuv_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Nabaa fei pudamu pepei ma'au i fafeloio, walesiminia. Ina rawani ba hepalo ua manumanuu unumu na pa'ai laraa fei ba minaa ei unumu i baroronaa waduhero. ");
INSERT INTO wuv_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Ma nabaa fei panimu pepei ma'au i fafeloio, famosuia ma siminia. Ina rawani ba hepalo ua manumanuu unumu na pa'ai laraa fei ba minaa ei unumu i baroronaa waduhero. ");
INSERT INTO wuv_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","“Ina udedii fei warea ba, ‘Hini mei i di'ininaa mei harona pifine, inei fania hepalo ne'ifa'aia ba lagu'aa fi'alagii.’ ");
INSERT INTO wuv_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Ma'uaa u'ei warefanaa hamu'ou ba hini i fi'alagii a'a mei harona pifine, nabaa mei pifine mei lomi na fiharoharoipa'ai, i fapasiaa mei pifine mei, ale'ei ba hia na fiharoharoipa'ai ma hini nemea i lalainaa mei pifine, mei i fi'alagii a'a mei harona, hia, na fiharoharoipa'ai. ");
INSERT INTO wuv_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","“Hamona aida ba ei rama'a mina, rona guaidigia ale'ei ba, ‘Onei'aa madi'inaa ei fa'unaiamu; ma'uaa bigi'aa tamanu ona warefa'uanainia a'a mei Fasu.’ ");
INSERT INTO wuv_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Ma'uaa a warefanaa hamu'ou ba, apunawe fa'unainaa hepalo manumanu: ale'ei fei gufu pafea, uaa fei, gutanaa mei Haidaa; ");
INSERT INTO wuv_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","o feni malagufu, uaa feni, labenaa pinena; o fa'unainaa Jerusalem, uaa fei, gufuu mei Baua Hapara. ");
INSERT INTO wuv_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Apuna fa'unainaa fei tabamu, uaa lomi ba owe fafilogipa'aa hepalo hugoo taba ba i po'i o hararapa'o. ");
INSERT INTO wuv_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Ma nabaa hamo'aa ware ba ‘Hi'i’ wagii hepalo manumanu, ware ua ba ‘Hi'i’ ma nabaa hamo'aa ware ba ‘Lo'e’, ware ua ba ‘Lo'e’, nabaa na pa'idilao warea, fei, noranamai a'a mei hafelo'a. ");
INSERT INTO wuv_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","“Hamona guaidigia ba, ‘Nabaa nemea i waleaa pudaa nemea, ana i waleaa pudana ma nabaa nemea i fa'aguguaa difoo nemea, ana i fa'aguguaa difona.’ ");
INSERT INTO wuv_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Ma'uaa u'ei warefanaa hamu'ou ba onei'aa fadugeaa nemea hafelo'a rama'a. Nabaa nemea i laparaa manufimu pepei ma'au, momo'aifania pepei anaa. ");
INSERT INTO wuv_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Ma nabaa nemea i dududuio ba i tonaa fei lawalawamu, fania fei hawaa ugumu anaa. ");
INSERT INTO wuv_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Nabaa nemea forafora i fatalainio ale'ena heai kilometre, talaifipui a'ana ale'ena guai kilometre. ");
INSERT INTO wuv_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Fani a'a hini i i'igainio ma apuna ofadugaa mei ba ido'o to a'amu ma nene, i hodi'ia. ");
INSERT INTO wuv_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","“Hamona aida ba rona ware ale'ei mina ba, ‘Haguaa mei gufumu ma fahafelo a'a mei bidibidii unumu.’ ");
INSERT INTO wuv_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Ma'uaa u'ei warefanaa hamu'ou: Haguaa ei bidibidii unuu hamu'ou ma lafulafunaa ei rona haperararaiaa hamu'ou ");
INSERT INTO wuv_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","ba hamowe oa ale'ei na'uu mei Amaa hamu'ou pafea. Ina fa'asi'anaa fei halo a'a ei hafelo'a mawe ei rawani'a ma faropanaa fei maunu a'a ei rona wanewane mawe ei lomi rona wanewane. ");
INSERT INTO wuv_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Nabaa hamona haguaa ena rona haguaa hamu'ou, tamanu pono'a ba hamo'aa tonia? Haa, ei otonaa mugoo po'ii gavaman, lomi rona'o bigi'ia ale'ei? ");
INSERT INTO wuv_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Ma nabaa hamu'ou farawani ua a'a ei lofuu hamu'ou, batanai ei ba ei maumau hamu'ou i muainaa hefi'a? Haa, ei roromaa, lomi rona'o bigi'ia ale'ei? ");
INSERT INTO wuv_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Ei maumau hamu'ou neiminapa'aa fafa'arai ua ana ale'ei ei maumau mei Amaa hamu'ou pafea. ");
INSERT INTO wuv_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","“Hamonei'aa bigi'aa ei rawani'a bigi'aa hamu'ou i pudaa rama'a ba ro fanunuia. Nabaa hamona bigi'ia, lomi ba hamo'aa pa'i pono'aa hamu'ou a'a mei Amaa hamu'ou pafea. ");
INSERT INTO wuv_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","“Si'ei, nabaa ona fani a'a ei lomi rona pa'i, apuna warefa'aiaa ei rama'a a'a ei maniwa, ale'ei rona'o bigi'ia ei ware'oni laloo ei synagogue ma yei ma'aa tala ba ei rama'a ronei fani ma'aua a'a ro'ou. A warefa'uai a'a hamu'ou ba rona todigaa minaa ei pono'aa ro'ou ena rona tenaa ro'ou ei rama'a. ");
INSERT INTO wuv_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Ma'uaa ena ona fani a'a ei lomi rona pa'i, apuna fa'aiaa fei panimu pepei mauwi ba tamanu ei bigi'aa fei panimu pepei ma'au ");
INSERT INTO wuv_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","ma ei fanamu i ude'opa'ai. Ma mei Amamu, mei i fanunupa'aa ei bigi'opaiamu, iwe fani pono'amu. ");
INSERT INTO wuv_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","“Ena hamona lafulafu, apuna bigi'ia ale'ei ena ware'oni, uaa rona nunuminia ba ro'aa ufalarai ma lafulafu laloo fei synagogue ma i ma'aa tala ba ei rama'a, ro'aa fanunupa'aa ro'ou. A warefa'uai a'a hamu'ou ba rona todigaa minaa ei pono'aa ro'ou. ");
INSERT INTO wuv_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Ma'uaa ena hamona'o lafulafu, wadu'inaa humuu hamu'ou, fare'aa fei gigei ma lafulafunaa a'a mei Amaa hamu'ou, mei lomi hamo'aa fanunupa'ia. Ma mei Amaa hamu'ou, mei i fanunupa'aa ei bigi'opa'aiaa hamu'ou, iwe fani pono'aa hamu'ou. ");
INSERT INTO wuv_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Ma ena hamona'o lafulafu, apuna bababau'u ua ale'ei ei rama'aa roromaa, uaa rona nara ba i guaipa'aa ro'ou a'a ei watauda wareaa ro'ou. ");
INSERT INTO wuv_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Apuna neneraa ei maumau ro'ou, uaa hamotawe i'iginia ma mei Amaa hamu'ou na apa'idigaa ei nunumiaa hamu'ou. ");
INSERT INTO wuv_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","“Si'ei ba ei mau lafulafuaa hamu'ou nei ale'eni feni ba: “‘Mena Amaa hai'ou pafea, fei haramu na honua, ");
INSERT INTO wuv_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","fei haparaiamu nei nomai, ei nunumiamu, hai'ou bigi'ia yeni malagufu, ana ale'ei rona'o bigi'ia yena gufu pafea. ");
INSERT INTO wuv_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Fani hanaa hai'ou wagieni ma laloo minaa ena hepapalo arewaa. ");
INSERT INTO wuv_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Futoaa ei hafelo'aa hai'ou, ana ale'ei hai'ouna'o futoaa hafelo'aa ei rona fahafelo a'a hai'ou. ");
INSERT INTO wuv_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Onei'aa duginaa hai'ou a'a ei manimania, ma'uaa dugitata'ainaa hai'ou a'a mei hafelo'a.’ ");
INSERT INTO wuv_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Uaa, nabaa hamu'ou futoaa ei hafelo'a ena rama'a, ena rona bigifahafelo a'a hamu'ou, mei Amaa hamu'ou pafea, ana i futoaa ei hafelo'aa hamu'ou. ");
INSERT INTO wuv_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Ma'uaa, nabaa lomi hamo'aa futoaa ei hafelo'aa ena rama'a, ei rona bigifahafelo a'a hamu'ou, mei Amaa hamu'ou pafea, ana lomi i futoaa ei hafelo'aa hamu'ou. ");
INSERT INTO wuv_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","“Ena hamona fabao, apuna fanunufaloloa'i ale'ei fei mau bigi'aa ena ware'oni, uaa rona'o fanunufaloloa'i ba ei rama'a, ronei fanunu'apa'ia ba ro'ei fabao ei. A warefa'uai a'a hamu'ou ba rona todigaa minaa ei pono'aa ro'ou. ");
INSERT INTO wuv_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Ma'uaa ena hamona fabao, igi pao tabaa hamu'ou ma rapu'aa pudaa hamu'ou ");
INSERT INTO wuv_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","ba ei rama'a, lomi ro'aa fanunu'apa'ia ba hamo'ei fabao ma'uaa, unaa mei Amaa hamu'ou, mei lomi hamona fanunupa'ia; ma mei Amaa hamu'ou, mei na fanunupa'aa ei bigi'opa'aiaa hamu'ou, iwe fani pono'aa hamu'ou. ");
INSERT INTO wuv_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","“Apuna auma'aa ei pa'aa rawani'a manumanumu yeni malagufu, yeni na pa'i pugo'a ma po'ai i fafeloia ma ei fafanao ro'aa wadu'ai ma topa'ainia. ");
INSERT INTO wuv_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Ma'uaa auma'aiaa ei pa'aa rawani'a manumanumu yei gufu pafea, uaa lomi na pa'i pugo'a ma po'ai i fafeloia ma lomi na pa'i fafanao ba ro'aa wadu'ai ma topa'ai. ");
INSERT INTO wuv_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Uaa hitani ei augamu ei pa'aa rawani'a manumanumu, ana na ude yena fena naranaramu. ");
INSERT INTO wuv_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","“Fei puda, we'ai fei unu. Nabaa fei pudamu na rawani, minaa fei unumu, ana imina we'a. ");
INSERT INTO wuv_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Ma'uaa, nabaa fei pudamu na hafelo, minaa fei unumu, ana imina roroma. Si'ei ba, nabaa fei we'ai a'amu na roro, iminapa'aa rorofafelo! ");
INSERT INTO wuv_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","“Lomi nemea i nafii a'a helagui fasu. Nabaa ale'ei, i fabidibidinaa ununa nemea ma haguaa nemea, o i bigifawe'i a'a nemea ma narafafelo a'a nemea. Lomi na hawia ba o nafii a'a minaa lagua—mei Haidaa ma fei Mugoo Po'i. ");
INSERT INTO wuv_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","“Si'ei, u'ei warefanaa hamu'ou, apuna naranara watauda a'a fei gutanaa hamu'ou ale'ei ba hamo'aa hana o hunumaa tamanu; o, a'a ei unuu hamu'ou ba hamo'aa rafe tamanu. Haa, fei gutanaa hamu'ou, manumanuu du'ua ua? Ma ei unuu hamu'ou, manumanuu lawalawa ua? ");
INSERT INTO wuv_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Fanununaa ei manufifidau; lomi rona faro, o hufu, o auma'a i laloo leaa ro'ou, ma'uaa mei Amaa hamu'ou pafea na faguaa ro'ou. A'a ba fei gutanaa hamu'ou baua manumanu laraa fei gutanaa ro'ou? ");
INSERT INTO wuv_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Nemea hamu'ou ana i famalapa'ia gutanana wagii fei ba i naranara watauda? ");
INSERT INTO wuv_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","“Hamatani hamomina naranara watauda a'a ei lawalawaa hamu'ou? Fanununaa ei lily fei ano ba batanai ro'ei habe. Lomi rona bigifatemu o tawitawi. ");
INSERT INTO wuv_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Ma'uaa u'ei warefanaa hamu'ou ba Solomon a'a ei watauda rawani'a hawerana, lomi na lawalawai ale'ei ei manumanu ei. ");
INSERT INTO wuv_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Nabaa mei Haidaa na fani hawera a'a ei guanaa feni ano, ei yeni wagieni ma narani hanaa fei hafi, haa, lomi ba i fanidiai hawera a'a hamu'ou ena lomi na we'i naranaraa hamu'ou? ");
INSERT INTO wuv_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Hee, apuna naranara watauda ma ware ale'ei ba, ‘O'aa hanaiaa tamanu?’, o ‘O'aa hunumaa tamanu?’, o ‘O'aa haweginaa tamanu?’ ");
INSERT INTO wuv_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Uaa ei rama'aa roromaa, rona ponineneraa minaa ei manumanu ei ma mei Amaa hamu'ou pafea na aidadii ba hamonei pa'i ei manumanu ei. ");
INSERT INTO wuv_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Ma'uaa do'o labarainaa fei haparaiana ma fei wanewaneana ma minaa ei manumanu i pafoimai a'a hamu'ou. ");
INSERT INTO wuv_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Si'ei, apuna naranara wataudanaa fei narani, uaa ei awataa fei narani, manumanuu narani. Ei awataa laloo hepalo arewaa, ana hawii fei arewaa fei. ");
INSERT INTO wuv_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","“Apuna fanunufarapa a'a hefi'a, o mei Haidaa ana i fanunufarapa a'amu. ");
INSERT INTO wuv_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Uaa batanai fafanunuamu a'a hefi'a, ana owe tonia ale'ei ei mau bigi'amu—nabaa puduu fanamu watauda o ma'ida, ana watauda o ma'ida i hadiwe'imai a'amu. ");
INSERT INTO wuv_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","“Tani o fanunuaa ei bareuaa pudaa mei lofumu ma lomi ona narapa'aa fei hewagu i pudamu? ");
INSERT INTO wuv_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Tani o ware a'a mei lofumu ale'ei ba, ‘Yau, ba a suagisuminaa ei bareuaa pudamu,’ ma ana ona pa'i hewagu i pudamu? ");
INSERT INTO wuv_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Yoi, mena ware'oni, oneido'o tosiminaa fei baua haihai pudamu ma owe fanunufarawani ba o'aa huguaa pudaa mei lofumu. ");
INSERT INTO wuv_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","“Apuna fanaa ei ponoto ei manumanu na apunai, uaa ro'aa momo'imai ma tadudigedigeo; ma apuna siminaa ei hapemu pearl a'a ei moimoi, uaa, ona bigi'ia ale'ei, ro'aa hapuninia haroo pinee ro'ou. ");
INSERT INTO wuv_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","“I'igai ma hamowe to; labarai ma hamowe labagipa'i; faba'aba'a a'a fei gigei ma iwe gigi a'a hamu'ou. ");
INSERT INTO wuv_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Uaa hini i i'igai, i to; mei i labarai, i pa'i; ma mei i faba'aba'a a'a fei gigei, i gigi a'ana. ");
INSERT INTO wuv_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","“Nabaa mei na'u i i'igainaa fei faraa pidaua, hini hamu'ou i fania hepalo mugoo? ");
INSERT INTO wuv_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","O nabaa i i'igainaa hepalo nia, i fania hepalo wa'a? ");
INSERT INTO wuv_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Fa'ua ba hamona hafelo ma'uaa, hamona'aida fani rawani'a manumanu a'a ei na'uu hamu'ou. Ma nabaa ale'ei, mei Amaa hamu'ou pafea imina fanidiai watauda rawani'a manumanu a'a ei rona i'iginia! ");
INSERT INTO wuv_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Si'ei, wagii minaa ei manumanu, hamonei bigi'ia a'a ei rama'a ana ale'ei hamona nunuminia ba ronei bigi'ia a'a hamu'ou, uaa hefeni, feni pa'aa hanuu fei Law ma ei Mamama'a. ");
INSERT INTO wuv_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","“Wadu'ai a'a fei pusu'o gigei. Uaa, na lare fei gigei wagii fei baua tala i dinaa ma'ea ma watauda, rona wadu'ai lalona. ");
INSERT INTO wuv_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Ma'uaa na pusu'oroi fei gigei wagii fei migigii tala i dinaa fawelei na pa'i harenua ma hefi'a ua na labagipa'ia. ");
INSERT INTO wuv_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","“Wagi'inaa hamu'ou a'a ei mamama'a sifisifi. Uaa, rona nomai a'a hamu'ou, maumau ro'ou ale'ei sipsipi ma'uaa, pa'aa maumau ro'ou ale'ei ponotoo podu. ");
INSERT INTO wuv_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","A'a ei fuaa ro'ou, hamo'aa fanunu'apa'aa ro'ou. Ei rama'a, rona'o hufu'aa ei hanamoo, o ei nasi dupuaa ei wowo'ii na hogia ununa? ");
INSERT INTO wuv_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Ana ale'ei, minaa ei rawani'a haihai na pa'i rawani'a fuaa ro'ou ma'uaa, ei hafelo'a haihai, lomi na pa'i rawani'a fuaa ro'ou. ");
INSERT INTO wuv_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Hepalo rawani'a haihai, lomi ba i pa'i hafelo'a fuana ma hepalo hafelo'a haihai, lomi ba i pa'i rawani'a fuana. ");
INSERT INTO wuv_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Tamanu fei haihai lomi na pa'i rawani'a fuana, rowe reresiminaa hafi. ");
INSERT INTO wuv_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Si'ei ba a'a ei fuaa ro'ou, hamowe fanunu'apa'aa ro'ou. ");
INSERT INTO wuv_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","“A'a ba minaa ei rona ware a'au ba, ‘Mena Fasu, mena Fasu,’ ba ro'aa wadu'ainaa laloo fei haparaia pafea ma'uaa, ana uniaa mei i bigi'aa fei nunumiaa mei Amau i pafea. ");
INSERT INTO wuv_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","A'a fei arewaa fei, watauda ro'aa warenaa a'au ba, ‘Mena Fasu, mena Fasu, haa, lomi hai'ouna'odii ware'au a'a fei haramu ale'ei ei mamama'a ma abaa hai'ouna'o fawala'anaa watauda pigea ma bigi'aa watauda foigia a'a fei haramu?’ ");
INSERT INTO wuv_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Ma a warefa'arewa a'a ro'ou ba, ‘Lomi una apa'aa hamu'ou. Di'ininau, hamu'ou ena hamona'u bigi'aa ei hafelo'a!’ ");
INSERT INTO wuv_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","“Si'ei, hini i guainaa eni wareau ma biginenegia, tawi'ana ale'ei mei rama'a na pa'i apa'ana, mei na faduaa fei humuna pafoo na'a. ");
INSERT INTO wuv_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Na ropa fei maunu, na mere fei lamalamana ma fei lalarena na agifanima'aiaa fei humu; ma'uaa lomi na worosi uaa fei fasu'ufufugoina na ude pafoo na'a. ");
INSERT INTO wuv_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Ma'uaa hini i guainaa eni wareau ma lomi na biginenegia, tawi'ana ale'ei mei lomi na pa'i apa'ana, mei na faduaa fei humuna pafoo piye. ");
INSERT INTO wuv_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Na ropa fei maunu, na mere fei lamalamana, fei lalarena na agifanima'aiaa fei humu ma na pasimeme'ainaa pu.” ");
INSERT INTO wuv_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","I'a warepedugaa ei manumanu ei Jesus, fei gupuu rama'a, namina nanawala pudaa ro'ou a'a ei feroiana ");
INSERT INTO wuv_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","uaa, ina feroi ale'ei hemea na pa'i foraforana ma abaa ale'ei ei feroiaa law. ");
INSERT INTO wuv_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","I'a upugio a'a fei maugeni, hefi'a baua gupuu rama'a, rona nenegia. ");
INSERT INTO wuv_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Hemea na watawatai ununa na nomai ma fa'unaa du'una i ma'ana ma na ware, “Mena Fasu, nabaa ina rawani a'amu, fafafa'arainau.” ");
INSERT INTO wuv_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Jesus na roainalao fei panina ma idoaa mei rama'a mei. Ina ware, “Na rawani a'au. Inei fafa'arai ena unumu!” Ana ei ua, ina pedu ei watawataa ununa. ");
INSERT INTO wuv_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Ma Jesus na warefania, “Apuna warefanaa nemea. Ma'uaa aunu ma fama'aa ena unumu a'a mei bauaniaa humuu mei Haidaa ma fanaa tamanu Moses nadii wareia ba onei fani ma fei, ale'ei u'ugamu a'a ro'ou.” ");
INSERT INTO wuv_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","I'a nopa'aloo fei gufu Capernaum, hemea centurion na nomai a'ana ma na i'iginia ba inei hadumia. ");
INSERT INTO wuv_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","Ina ware, “Mena Fasu, mei nafiu na haino i humu, uaa na ma'e ununa ma namina tonaa fi'ina.” ");
INSERT INTO wuv_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Jesus na warenaa a'ana, “Yau, a dii ma re farawaninia.” ");
INSERT INTO wuv_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Mei centurion mei, na ware, “Mena Fasu, yau abaa rawani'a rama'a ba o wadu'aimai humuu. Ma'uaa onei ware ua ma i rawanidiai mei nafiu. ");
INSERT INTO wuv_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Uaa ana yau na pa'i hemea bauaniau ma yau hemea bauaniaa hefi'a rama'aa fo'aa. A ware a'a hemea ba ‘Nowau,’ ma i nolao ma hemeadiai ba, ‘Nomai,’ ma i nomai. A warenaa a'a mei nafiu ba, ‘Bigi'aa feni,’ ma i bigi'ia.” ");
INSERT INTO wuv_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","I'a guainaa fei Jesus, na maduofo ma na warenaa a'a ei ro nenegia ba, “A warefa'uai a'a hamu'ou ba lomi una apa'aa hemea Israel napa'aa we'i naranarana ale'eni meni. ");
INSERT INTO wuv_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","U'ei ware a'a hamu'ou ba watauda, rowe nomai i pepei anaa halo ma i pepei pasiaa halo ma to gutaa ro'ou i a'a fei baua hananaa a'a Abraham, Isaac ma Jacob i a'a fei haparaia pafea. ");
INSERT INTO wuv_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Ma'uaa hefi'a na'uu fei gufu haparaiaa, rowe oanaa ano laloo fei roromaa fawelei na pa'i ai'aiga ma fi'u'uiaa difo.” ");
INSERT INTO wuv_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Nawe ware Jesus a'a mei centurion mei, “Nowau! A pa'aa bigi'ia, ana ale'ei ona nara ba a bigi'ia.” Ma mei nafina na rawani ana a'a fei au fei. ");
INSERT INTO wuv_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","I'a wadu'imai i laloo fei humuu Peter Jesus, na fanunupa'aa mei inaa haroo Peter na babai ununa ma na haino pafoo tawa. ");
INSERT INTO wuv_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Ina idoaa panina ma na pedu fei babaiaa ununa ma ina asi'aa ma fipowe hasufani hanana. ");
INSERT INTO wuv_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","I nopoilao, rona noduginaa a'ana watauda na wadu'aa ro'ou pigea ma ina fawala'anaa ei spiriti a'a ei wareana ma fapedugaa minaa ei funuaa ro'ou. ");
INSERT INTO wuv_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Ei bigi'ana ei, na fafa'uainaa tamanu nadii wareia mei mamama'a Isaiah: “Ina harenaa ei hafelo'a unuu o'ou ma tonaa ei funuaa o'ou.” ");
INSERT INTO wuv_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","I fanunupa'aa ei gupuu rama'a papana, ina warenaa a'a ei maroana ba hia ma ro'ou, ronei dinaa pepei adii fei ranu. ");
INSERT INTO wuv_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Ma hemea feroiaa law na nomai a'ana ma na ware, “Mena feroia, ona dinaa hitani, a nenegio.” ");
INSERT INTO wuv_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Jesus na ware, “Ei ponotoo podu, rona pa'i waduu ro'ou ma ei manufifidau rona pa'i hofaa ro'ou, ma'uaa mei Na'uu Rama'a, lomi nopana ba i haino.” ");
INSERT INTO wuv_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Hemeadiai ei otalai nenerana na warenaa a'ana, “Mena Fasu, yau ba ado'o aunu ma agifinaa mei amau.” ");
INSERT INTO wuv_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Ma'uaa Jesus na warenaa a'ana, “Nenerau. Ei ma'ea ronei i'ifinaa ana ro'ou.” ");
INSERT INTO wuv_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","I dii, na hugi pafoo fei wa ma ei otalai nenerana, rona nenegia. ");
INSERT INTO wuv_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Lomi rona fanunupa'ia ma'uaa, na asi'aa fei baua lalarena ma ina towetafafelo fei agi ma na fuama'i'inaa laloo fei wa. Ma'uaa Jesus na ma'igu. ");
INSERT INTO wuv_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Ei otalai nenerana, ronaree funifunia ma ware, “Mena Fasu, fatela'anaa o'ou! O'aa wawau'u!” ");
INSERT INTO wuv_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Ina ware, “Hamu'ou ena lomi namina we'i naranaraa hamu'ou, tani hamomina ma'au ale'ei?” I dii, ina asi'aa ma na warefamadinoaa fei lalarena ma fei lama. Ma namina madino fei lama. ");
INSERT INTO wuv_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Ei rama'a, namina nanawala pudaa ro'ou ma rona i'igai, “Rama'a bata meni rama'a meni? Te fei lalarena ma fei lama, ana laguna guaipa'aa wareana!” ");
INSERT INTO wuv_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","I'a nopa'aloo fawelei i pepei Gadara, na nobapa'amii helagui rama'a, noramiaa lagua a'a ei huapu ma rona wadu'aa lagua ei pigea. Si'ei ba laguna'aida panarofo'aa ei rama'a, lomi ba hemea i talailao fawelei. ");
INSERT INTO wuv_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Laguna iwa ba, “Tamanu ei nunumiamu a'a haigua, mena Na'uu mei Haidaa? Atawe pa'aa fei au haigua ma ba o'amii haperararaiaa haigua?” ");
INSERT INTO wuv_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Raualao ma'ida na pa'i hefaa baua gupuu ei moimoi ro'ei hanana. ");
INSERT INTO wuv_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Ei pigea, rona i'igaifawe'i a'a Jesus, “Nabaa o'aa fawala'anaa hai'ou, alonaa hai'ou a'a ei moimoi ba hai'ou'aa wadu'aa ro'ou.” ");
INSERT INTO wuv_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Ina warenaa a'a ro'ou, “Nowau!” Si'ei, rona wala'aa ma wadu'aa ei moimoi ma minaa fei gupuu ro'ou, rona poni'upunaa fei adii fei ranu fawelei namina faro'ai ma pasima'e lalona. ");
INSERT INTO wuv_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Ei oma'ama'aa ei moimoi, rona ponibaguanaa fei baua gufu ma u'ugaa minaa ei manumanu ei fininaa tamanu ina bigi'ia a'a laguei na wadu'aa lagua pigea. ");
INSERT INTO wuv_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Si'ei, minaa ei rama'a fei baua gufu, rona aunu ba ro'aa ma'a Jesus. Ma ro'aa ma'apa'ia, rona i'igifawe'i a'ana ba nei di'ininaa malalaa gufuu ro'ou. ");
INSERT INTO wuv_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Jesus na hugi pafoo hepalo wa, dinaa pepei ma suafatetenaa yei piye gufuna. ");
INSERT INTO wuv_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Hefi'a rama'a, rona notabeamii a'ana hemea na ma'e ununa, na haino pafoo fei hafenaa ununa. I'a fanunupa'aa fei we'iaa naranaraa ro'ou Jesus, na warenaa a'a mei na ma'e ununa, “Guta farawani mena na'uu; ena hafelo'amu una futoia.” ");
INSERT INTO wuv_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","A'a fei, hefi'a ei feroiaa law rona'u fiwarewarei, “Mei rama'a mei, ina warefafeloaa mei Haidaa!” ");
INSERT INTO wuv_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Jesus na aidadii ei naranaraa ro'ou ma na ware, “Tani hamu'ou narafafelo? ");
INSERT INTO wuv_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Afaia na maduta: fei ba una ware, ‘Na futo ei hafelo'amu,’ o, fei ba, ‘Asi'aa ma talai’? ");
INSERT INTO wuv_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Ma'uaa, si'ei ba hamonei aida ba mei Na'uu Rama'a na pa'i faufauna yeni malagufu ba i futoaa ei hafelo'a. . . .” ina warenaa a'a mei na ma'e ununa ba, “Asi'aa, tonaa fei hafenaa unumu ma dinaa humumu.” ");
INSERT INTO wuv_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Ma mei rama'a na asi'aa ma aununaa humuna. ");
INSERT INTO wuv_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Fei gupuu rama'a, ro'aa fanunupa'aa fei, ronamina hawainaa poaa ro'ou ma rona uduginaa mei Haidaa, mei i fani faufau a'a ei rama'a ale'ei. ");
INSERT INTO wuv_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Ei i talaidi'ininaa yei, ina ma'apa'aa hemea rama'a, harana Matthew, hemea otonaa mugoo po'ii gavaman na guta wagii fei palee fei bigi'ana. Ina warenaa a'ana, “Nenerau,” ma Matthew na asi'aa ma nenegia. ");
INSERT INTO wuv_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Ei fi hanana i humuu Matthew Jesus, watauda otonaa mugoo po'ii gavaman mawe ei “rama'a hafelo”, rona nomai ma hananafipui a'ana ma ei otalai nenerana. ");
INSERT INTO wuv_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Ro'aa fanunupa'aa fei ei Pharisee, rona i'iginaa ei otalai nenerana, “Tani i hananafipui a'a ei otonaa mugoo po'ii gavaman mawe ei ‘hafelo'a rama'a’ mei feroiaa hamu'ou?” ");
INSERT INTO wuv_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","I'a guainaa fei Jesus, ina ware, “A'a ba ei rona rawani ei rona nunuminaa hemea lo'otaa uaa ei rona funu. ");
INSERT INTO wuv_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Ma'uaa nowau ma labarainia ba tamanu hanuu feni: ‘Una nunuminaa faloloa'ia laraa ei fana.’ Uaa eni a nomai, a'a ba u'amii dugaa ei wanewanea rama'a, ma'uaa ei rama'a hafelo.” ");
INSERT INTO wuv_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Si'ei, ei otalai neneraa John, rona nomai ma i'iginia, “Tani ipo'o biyei ba hai'ou mawe ei Pharisee, hai'ouna fabao ma ei otalai neneramu, lomi rona'o fabao?” ");
INSERT INTO wuv_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Na ware Jesus, “Batanai ba ei maroaa mei wawane lalaia, ro'aa faloloa'i ei ifi gutafipui a'a ro'ou? Iwe nomai fei au ba mei lalaia, hefi'a, rowe dugipa'ainia a'a ei maroana; ma a'a fei au fei, ro'awe fabao. ");
INSERT INTO wuv_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","“Lomi hemea i tawi'aa hepalo maninii manufau lawalawa a'a hepalo watanai lawalawa, uaa fei manufau maninii lawalawa i rapudigeaa fei lawalawa ma fawara'a'apoidinia. ");
INSERT INTO wuv_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Ana lomi ba ei rama'a, ro'aa igiaa ei manufau wine a'a ei watanai pe'ii wine. Nabaa ro'aa bigi'ia ale'ei, ei pe'ii wine ei bigi'aa ro'ou hudii manulelele i ba'awara'a, ei wine i wigibeu ma ei pe'ina ana i hafelo. Agia, rona'o igiaa ei manufau wine a'a ei manufau pe'ii wine ma minaa lagua, lagu'aa udefarawani.” ");
INSERT INTO wuv_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Ei ifi wareaa fei, hemea bauaniaa ei Jew na nomai ma fa'unaa du'una i ma'ana ma na ware, “Mei na'uu, baduu pifine, ma'eana e'eni ua. Ma'uaa mi augaa panimu pafona ma i fawenaidiai.” ");
INSERT INTO wuv_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Jesus mawe ei otalai nenerana, rona asi'aa ma nenegia. ");
INSERT INTO wuv_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Ana ei ua, hemea pifine, mei na udewigiwigii namona ale'ena hefua ma guai igisimasi na nomai nenena ma idoaa fei supuu fei hawaa uguna. ");
INSERT INTO wuv_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Ma ina nara ale'ei ba, “Nabaa a ido'uaiaa fei hawaa uguna, a rawani.” ");
INSERT INTO wuv_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Na diarai Jesus, na ma'apa'ia ma na ware, “Gutafarawani, mena na'uu. Fei we'iaa naranaramu na farawaninio.” Ma ana ei ua, ina rawani mei pifine. ");
INSERT INTO wuv_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","I'a wadu'ailao laloo fei humuu mei bauana Jesus ma ma'apa'aa ei rona hugufaa ei flute ma ba fei gupuu rama'a, rona wawaigi, ");
INSERT INTO wuv_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","ina ware, “Hamu'ou aunu. Lomi na ma'e mei baduu pifine. Na ma'igu ua.” Ma'uaa rona fadinia. ");
INSERT INTO wuv_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Ei ro'aa aunudiginaa ano fei gupuu rama'a, ina wadu'ai, tauaa panii mei baduu pifine ma ina asi'aa. ");
INSERT INTO wuv_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Fei u'uga fei na talepedunaa minaa ei gufu fawelei. ");
INSERT INTO wuv_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Ei i talaidi'ininaa yei, helagui pudawerai, laguna nenegia ma laguna haroharo, “Faloloa'inaa haigua, mena Na'uu David!” ");
INSERT INTO wuv_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Ei i wadu'ailao laloo humu, laguei pudawerai, laguna nomai a'ana ma ina i'iginaa lagua, “Hamunapa'aa nara ba a bigipa'ia?” Laguna ware, “Hi'i, mena Fasu.” ");
INSERT INTO wuv_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Ina idoaa pudaa lagua ma na ware, “Ana ale'ei fei we'iaa naranaraa hamugua, yau a bigi'ia” ");
INSERT INTO wuv_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","ma laguna fanunupa'i. Ma Jesus na warefawe'i a'a lagua, “Apuna u'u a'a nemea.” ");
INSERT INTO wuv_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Ma'uaa laguna aunu ma fatalainaa fei u'ugana i malalaa fei gufu fei. ");
INSERT INTO wuv_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Ei roi asi'alao, hefi'a, rona duginamii a'a Jesus hemea na wadu'ia pigea ma ana umuloo. ");
INSERT INTO wuv_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","I'a fawala'adigaa fei pigea a'ana, nawe wareware mei umuloo. Namina nanawala pudaa fei gupuu rama'a ma rona ware, “Pa'aa lomi ba ona fanunupa'aa he'a manumanu ale'eni yeni Israel.” ");
INSERT INTO wuv_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Ma'uaa rona ware ei Pharisee ba, “A'a fei faufau mei haparaa ei pigea, ina fawala'anaa ei pigea.” ");
INSERT INTO wuv_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Jesus na aunulao a'a minaa ei bauanai ma pusu'o gufu ma feferoi laloo ei synagogue ro'ou, wareaa fei rawani'a wareaa fei haparaia ma na fapedugaa minaa ei hafelo'aa unuu ei rama'a ma minaa ei funua. ");
INSERT INTO wuv_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","I'a fanunupa'aa ei gupuu rama'a, ina faloloa'inaa ro'ou, uaa hefi'a, rona fagutafafeloaa ro'ou ma lomi na pa'i haduma a'a ro'ou, ale'ei ei sipsipi lomi oma'ama'aa ro'ou. ");
INSERT INTO wuv_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","I dii, na warenaa a'a ei otalai nenerana ba, “Na we'idii ei du'ua laloo fei pe'ihape ma'uaa, ma'ida ua ei rama'aa hufu'a. ");
INSERT INTO wuv_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","I'iginaa mei Fasuu fei pe'ihape ba inei aloaa ei rama'aa bigi'a i pe'ihapena.” ");
INSERT INTO wuv_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Jesus na haronaa a'ana ei hefua ma helagui otalai nenerana ma na fanaa ro'ou fei forafora ba ronei fawala'anaa ei spiriti hafelo ma farawaninaa minaa ei hafelo'aa unu ma minaa ei funua. ");
INSERT INTO wuv_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Si'eni, eni haraa ei hefua ma helagui apostle: rawarawa, Simon (rona roroinia Peter) ma mei lofuna, Andrew; James, mei na'uu Zebedee ma mei lofuna John; ");
INSERT INTO wuv_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Philip ma Bartholomew; Thomas ma Matthew, mei otonaa mugoo po'ii gavaman; James, mei na'uu Alphaeus ma Thaddaeus; ");
INSERT INTO wuv_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Simon mei Zealot ma Judas Iscariot, mei ba i aloia. ");
INSERT INTO wuv_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Eni hefua ma helagui eni, Jesus na aloaa ro'ou ma fanaa eni warea eni: “Apuna aununaa a'a ei Gentile, o dinaa hepalo gufu yei Samaria. ");
INSERT INTO wuv_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Ma'uaa hamonei dinaa a'a ei madidiaa sipsipii Israel. ");
INSERT INTO wuv_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Ena hamona nowau, u'ugaa feni u'uga feni: ‘Fei haparaia pafea na rafi'i.’ ");
INSERT INTO wuv_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Farawaninaa ei funua, fa'asi'anaa ei ma'ea, farawaninaa ei watawatai, fawala'anaa ei pigea. Hamona to ua, te, hamonei fani ua. ");
INSERT INTO wuv_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Apuna notoo gold, o silver, o copper i a'a ena adii hamu'ou. ");
INSERT INTO wuv_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Hamonei'aa notoo raba a'a fei tatalaia fei, o pafuaa lawalawa, o hafenaa pinai, o hepalo o, uaa ei rama'a, ronei fani gutanaa mei bigi'a. ");
INSERT INTO wuv_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","“Tamanu ena bauana o pusu'o gufu hamona dinaa lalona, labaginaa nemea rama'a na honua yena ma guta i humuna hawina hamona aunu. ");
INSERT INTO wuv_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Ena hamona wadu'inaa fei humuna, hamonei haweginia. ");
INSERT INTO wuv_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Nabaa na rawani ua fei humuna, fei rawani'aa hamu'ou nei ude lalona ma nabaa lomi, hamonei tohadiwe'inia. ");
INSERT INTO wuv_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Nabaa nemea, lomi i taufagutanaa hamu'ou, o guainaa ei wareaa hamu'ou, difoifoinaa ei piyee pinee hamu'ou ena hamona di'ininaa fena gufu fena. ");
INSERT INTO wuv_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","A warefa'uai a'a hamu'ou ba a'a fei arewaa dududua, na bauanaidiai fagianaa fena gufu fena laraa Sodom ma Gomorrah. ");
INSERT INTO wuv_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","“A aloaa hamu'ou ale'ei sipsipi dupuaa ei ponotoo podu. Si'ei, hamonei ano'anoi ale'ei wa'a ma inei rawani maumau hamu'ou ale'ei ei padu. ");
INSERT INTO wuv_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","“Oma'ama'aa hamu'ou a'a ena rama'a; ro'aa aunaa hamu'ou panii ei bauaniaa gufu ma hafugaa hamu'ou laloo ei synagogue ro'ou. ");
INSERT INTO wuv_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","I a'au, rowe fa'ufalarainaa hamu'ou i ma'aa ei bauaniaa gavaman mawe ei hapara ba ale'ei umuu a'a ro'ou mawe ei Gentile. ");
INSERT INTO wuv_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Ma'uaa ena rona panaroro'inaa hamu'ou, apuna naranara watauda ba hamu'ou wareaa tamanu, o batanai hamona ware. A'a fena au fena, hamowe narapa'aa tamanu ba hamo'aa wareia ");
INSERT INTO wuv_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","uaa abaa hamu'ou ena hamu'ou fi wareware, ma'uaa hamu'ou fi umuinaa fei Spiritii mei Amaa hamu'ou. ");
INSERT INTO wuv_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","“Ei filofui, ana ro'aa aloaa ei lofuu ro'ou ma'ea ma nemea ama, ana i aloaa mei na'una; ei baduu, ro'aa barafeaa wareaa ei ama ma inaa ro'ou ma alonaa ro'ou ma'ea. ");
INSERT INTO wuv_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Minaa ei rama'a ro'aa fabidibidinaa unuu ro'ou hamu'ou uaa yau ma'uaa, hini i ofafaufau nopa'aloo fei pedupeduna, i tela. ");
INSERT INTO wuv_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Ena rona haperararaiaa hamu'ou i a'a hepalo gufu, poninaa a'a hepalodiai. A warefa'uai a'a hamu'ou, atawe pedu fei tatalaiaa hamu'ou a'a ei baua gufuu Israel ma i nomai mei Na'uu Rama'a. ");
INSERT INTO wuv_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","“Hemei baduu feferoi, lomi i muainaa mei feroiana ma hemei nafi lomi i muainaa mei fasuna. ");
INSERT INTO wuv_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Na rawanidii nabaa mei baduu ale'ei mei feroiana ma mei nafi ale'ei mei fasuna. Nabaa hefi'a, rona ware ba mei bauaniaa fei humu, hia, Beelzebub, ei maroaa humuna anaa! ");
INSERT INTO wuv_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","“Si'ei, apuna ma'auaa ro'ou. Tamanu na ude'opa'ai, rowe u'ugia nefarani ma tamanu na opa'ai iwe ude'are'are ua. ");
INSERT INTO wuv_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Tamanu una wareia a'a hamu'ou poi, hamonei wareia na asi'aa fei halo; tamanu ro'aa warefagigii adiaa hamu'ou, hamonei warefagipeia i pupuaa ei humu. ");
INSERT INTO wuv_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Apuna ma'au a'a ei rona fo'afama'eaa fei unu ma lomi ba ro'aa fo'afama'epa'aa ei na ude laloo ei naranara. Ma'uaa hamonei ma'auaa Mei ba i fo'afama'epa'aa minaa lagua yei wagii fei gufu hafelo. ");
INSERT INTO wuv_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Haa, abaa pono'aa guapaloei pusu'o manufifidau ale'ei hepalo pusu'o mugoo po'i? Ma'uaa lomi hepalo i pasinaa pu nabaa lomi i ugainia mei Amaa hamu'ou. ");
INSERT INTO wuv_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Ma ana, hepapalo hugoo tabaa hamu'ou, ina wareidigia. ");
INSERT INTO wuv_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Si'ei, apuna ma'au, uaa na awatana hamu'ou laraa watauda pusu'o manufifidau. ");
INSERT INTO wuv_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","“Hini i ware ba ina apa'au i pudaa rama'a, ana a ware ba una apa'ia i pudaa mei Amau i pafea. ");
INSERT INTO wuv_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Ma'uaa hini i ofadugau i pudaa rama'a, ana a ofadugia i pudaa mei Amau i pafea. ");
INSERT INTO wuv_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","“Hamonei'aa nara ba ena a nomai ba a fagutafarawaninaa ei rama'a yeni malagufu. Ena a nomai, a'a ba a fagutafarawaninaa ei rama'a, uaa una notomai fei wadu. ");
INSERT INTO wuv_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Uaa ei a nomai ba u'a fafisibainaa “‘nemea rama'a a'a mei amana, nemea baduu pifine a'a mei inana, nemea pifine a'a mei inaa mei harona— ");
INSERT INTO wuv_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","ana ei maroaa hemei i humuaa fei humu, i bidibidi unuu ro'ou a'ana.’ ");
INSERT INTO wuv_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","“Hini na mua fei haguana amana ma inana laraa fei haguana yau, lomi i raraba a'au; hini na mua fei haguana mei na'una baduu wawane o pifine laraa fei haguana yau, lomi i raraba a'au; ");
INSERT INTO wuv_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","ma hini lomi na harenaa fei hawafolona ma nenerau, lomi i raraba a'au. ");
INSERT INTO wuv_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Hini ba i urofaa fei harenuana, iwe pa'ai a'ana ma hini ba i fapa'ainaa fei harenuana a'au, iwe tohadiwe'idinia. ");
INSERT INTO wuv_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","“Hini i fagutanaa hamu'ou, ina fagutanau ma hini i fagutanau, na fagutanaa mei i aloamiau. ");
INSERT INTO wuv_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Hini i fagutanaa nemea mamama'a uaa hia mamama'a, iwe tonaa fei pono'aa mei mamama'a ma hini i fagutanaa nemea wanewanea uaa ina wanewane, iwe tonaa fei pono'aa mei wanewanea. ");
INSERT INTO wuv_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Ma nabaa nemea i fani hefaa baraa ranu a'a nemea eni pusu'o otalai nenerau, u'ei warefa'uai a'a hamu'ou ba lomi i pa'ai ei pono'ana.” ");
INSERT INTO wuv_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","I'a feroidigaa ei hefua ma helagui otalai nenerana Jesus, ina di'ininaa fawelei ma aunulao ba i feroi ma u'u a'a ei gufu yei Galilee. ");
INSERT INTO wuv_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","John, i laloo humuu bobo'aia ma i'a guainaa tamanu ei bigi'aa Christ, ina alonaa ei otalai nenerana a'ana ");
INSERT INTO wuv_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","ba roneiree i'iginia, “Haa, yoi mei ba i nomai, o hai'ou oma'aa hemeadiai?” ");
INSERT INTO wuv_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Jesus na ware, “Nowau ma u'ufanaa John tamanu hamona guainia ma fanunuia: ");
INSERT INTO wuv_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","ei pudawerai, rona fanunudiai, ei afetoo, rona talaidiai, ei watawatai, rona rawanidiai, ei lotoo adia, rona guaidiai, ei ma'ea, rona asi'aa ma ina u'ugaa fei rawani'a warea a'a ei lomi manumanu. ");
INSERT INTO wuv_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Ina pa'i hawegiana mei lomi na pasi uaa yau.” ");
INSERT INTO wuv_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Ro'aa asi'aa ba ro aunu ei otalai neneraa John, Jesus nawe warefanaa fei gupuu rama'a fei u'ugaa John, “Tamanu fei ba hamo'aa fanunuia fawelei abaa wawawau rama'a? Ba hamo'aa fanunuaa fei tarea guana na gufifababaia fei lalarena? ");
INSERT INTO wuv_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Nabaa lomi, tamanu fei hamoree fanunuia? Hemea na susuinaa ei rawani'a susu? Lo'e, ei rona rafeaa ei rawani'a susu, rona guta i laloo ei humuu ei hapara. ");
INSERT INTO wuv_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Pa'aa tamanu fei hamo'aree fanunuia? Hemea mamama'a? U'ei warefanaa hamu'ou ba hi'i. Ma'uaa hia, abaa mamama'a ua. ");
INSERT INTO wuv_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Simei, mei ro'adii ne'i'u'ugia: “‘Awe aloaa mei talaitonaa wareau i ma'amu, mei ba i pagipagi'augaa fei tala i ma'amu.’ ");
INSERT INTO wuv_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","A warefa'uai a'a hamu'ou ba: a'a minaa ei waniniaa ei pifine, lomi hemea na muainaa John, mei pudugufaia; ma'uaa, mei hia abaa mau rama'a ma na oa laloo fei haparaia pafea, ina muainaa John. ");
INSERT INTO wuv_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","A'a fei au John, mei Pudugufaia, nopa'amii wagieni, fei haparaia pafea, ifimina fagipelao, lomi hepalo manumanu i lawagia ma ei didigii rama'a, rona urofia. ");
INSERT INTO wuv_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Uaa minaa ei mamama'a ma fei Law, nadii ware'augia, nopa'amii fei au John. ");
INSERT INTO wuv_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Ma nabaa na rawani a'a ei naranaraa hamu'ou, a warefanaa hamu'ou ba hia, Elijah, mei ba i nomai. ");
INSERT INTO wuv_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Hini na pa'i adiana, inei guai. ");
INSERT INTO wuv_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","“U'a hawawaginaa hamu'ou taweni a'a tamanu? Ro'ou, ale'ei ei baduu rona guta i fawelei rona alo'alo ma rona haroharonaa a'a hefi'a ba, ");
INSERT INTO wuv_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","“‘Hai'ouna hugufaa fei flute ma hamu'ou, lomi hamona palapala; hai'ouna laugaa hepalo laugaa faloloa'ia ma lomi hamona faloloa'i.’ ");
INSERT INTO wuv_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Uaa John na nomai ma lomi na hanana o hunu ma rona ware ba, ‘Ina tauia pigea.’ ");
INSERT INTO wuv_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Ina nohunumai ma hananamai mei Na'uu Rama'a ma rona ware ba, ‘Ina puguai ma hunupoapoai ma hia, tafii ei otonaa mugoo po'ii gavaman mawe ei “rama'a hafelo.” ’ Ma'uaa fei apa'a, ana na fama'aiaa o'ou tamanu na wanewane wagii fei bigi'ana.” ");
INSERT INTO wuv_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","I dii, si'ei ba lomi rona filoginaa naranaraa ro'ou, Jesus fipowe wareaa ei tataa ei baua gufu, ei gufu ina bigi'aa watauda foigia a'a ro'ou laraa hefi'adiai gufu. ");
INSERT INTO wuv_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","“Ona fagiana yoi, Korazin! Ona fagiana yoi, Bethsaida! Ei foigia una bigidigia a'a hamugua, nabaa una bigi'ia yei Tyre ma Sidon, laguna filogidigaa minaa ei naranaraa lagua a'a ei madigee lawalawa ma ei maduhafi. ");
INSERT INTO wuv_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Ma'uaa u'ei warefanaa hamugua ba a'a fei arewaa dududua, na bauanadiai fei aree hamugua laraa Tyre ma Sidon. ");
INSERT INTO wuv_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Ma yoi, Capernaum, i poronaa yoi pafea? Lo'e, yoi o momogunaa fei walaloa. Ei foigia una bigidigia a'amu, nabaa una bigi'ia a'a Sodom, ana ifi udemai wagieni. ");
INSERT INTO wuv_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Ma'uaa u'ei warefanio ba a'a fei arewaa dududua, na bauanadiai fei lagimu laraa Sodom.” ");
INSERT INTO wuv_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","A'a fei au fei, Jesus na ware, “Una uduginio, O'ama, mena Fasuu fena pafea ma feni malagufu, uaa ona opa'ainaa ei manumanu ei a'a ei ano'ano mawe ei rona tonaa baua feroia ma'uaa, ona fa'arewaia a'a ei pusu'o baduu. ");
INSERT INTO wuv_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Hi'i, O'ama, onapa'aa nunuminia ba inei ale'ei. ");
INSERT INTO wuv_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","“Minaa ei manumanu ei, inadii aunaa paniu mei Amau. Lomi hemea na apa'aa mei Na'u, ana unaa mei Ama; ma lomi hemea na apa'aa mei Ama, ana unaa mei Na'u mawe ei ina nunuminia mei Na'u ba i fa'arewaia a'a ro'ou. ");
INSERT INTO wuv_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","“Nomai a'au minaa hamu'ou, ena hamona temu ma na pa'i rarabaa hamu'ou ma a fagutafawenainaa hamu'ou. ");
INSERT INTO wuv_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Hupu'aifipui a'au ma to apa'aa hamu'ou a'au uaa fei maumauu namina rawani ua ma lomi una mamagugu ma hamu'ou, hamowe gutafawenainaa ena naranaraa hamu'ou. ");
INSERT INTO wuv_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Uaa, nabaa hamo'aa hupu'aifipui a'au, lomi ba hamo'aa temu ma lomi hamo'aa harenaa hefi'a awataa manumanu a'au.” ");
INSERT INTO wuv_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","A'a fei au fei, Jesus na tatalai dupuaa ei pe'ihape hefaa Sabbath. Ei otalai nenerana, rona bao ma rona hufu'aa hefi'a lau wheat ma hanaia. ");
INSERT INTO wuv_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Ro'aa fanunuia ale'ei ei Pharisee, rona warenaa a'ana ba, “Ma'a! Ei otalai neneramu, wagii fei law rona bigi'aa tamanu na hafelo a'a fei Sabbath.” ");
INSERT INTO wuv_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Ina warenaa a'a ro'ou, “Haa, lomi hamona igoaa tamanu David mawe ei maroana rona bigi'ia ei ro'aa bao? ");
INSERT INTO wuv_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Ina wadu'ainaa fei humuu mei Haidaa ma fipui a'a ei maroana, rona hanaiaa fei faraa pidaua na apunai, fei au'u'ugaiaa ro'ou, fei ba wagii fei law ronei'aa hanaia, ma'uaa, unaa ei bauaniaa humuu mei Haidaa ronei hanaia. ");
INSERT INTO wuv_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Ma ana lomi hamona igoia laloo fei Law ba a'a fei Sabbath, ei bauania laloo fei humuu mei Haidaa, rona'aida bigi ma si'ei rona fafeloaa fei arewaa ma'uaa, ana lomi rona tata. ");
INSERT INTO wuv_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","U'ei warefanaa hamu'ou ba mei na muainaa fei humuu mei Haidaa, hia yeni. ");
INSERT INTO wuv_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Lomi ba hamo'aa ware ba rona bigifatata ei rawani'a rama'a nabaa hamona aidadii hanuu feni warea feni, ‘Una nunuminaa faloloa'ia, abaa ei fana.’ ");
INSERT INTO wuv_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Uaa mei Na'uu Rama'a, Fasuu fei Sabbath.” ");
INSERT INTO wuv_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","I'a di'ininaa fei gufu fei, na wadu'ainaa laloo fei synagogue ro'ou ");
INSERT INTO wuv_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","ma hemea rama'a na ma'e hepapa panina, ana hia yei. Si'ei ba ro'aa labarai talawareaa ro'ou ba na tata Jesus, rona i'igainia, “Ina rawani a'a fei law ba o'aa farawaninaa ei funua a'a fei Sabbath?” ");
INSERT INTO wuv_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Ina warenaa a'a ro'ou, “Nabaa nemea hamu'ou na pa'i hapena sipsipi ma ina pasinaa hepalo huapu a'a fei Sabbath, lomi o'aa taufa'asi'ania? ");
INSERT INTO wuv_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Hemea rama'a na awatadiai laraa hepalo sipsipi! Si'ei, ina rawani a'a fei law ba o'aa bigi'aa ei rawani'a manumanu a'a fei Sabbath.” ");
INSERT INTO wuv_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Si'ei, ina warenaa a'a mei i ma'e hepapa panina, “Roainalao fei panimu.” Hee, ina roainia ma namina rawanidiai, ana ale'ei raudei i rawani. ");
INSERT INTO wuv_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Ma'uaa ei Pharisee, rona aunu ma fiwarewarei ba batanai ro'aa fo'afama'eaa Jesus. ");
INSERT INTO wuv_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Jesus na aida fei ma na di'ininaa fei gufu fei. Watauda, rona nenegia ma ina farawaninaa minaa ei funuaa ro'ou ");
INSERT INTO wuv_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","ma na warefawe'i a'a ro'ou ba ronei'aa u'u ba hia hini. ");
INSERT INTO wuv_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Hefei, ba i fafa'uainaa tamanu nadii wareia Isaiah, mei mamama'a: ");
INSERT INTO wuv_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“Simeni, meni nafiu, meni unadii rafeinia, mei una haguia, mei una ni'eni'e a'ana; u'a fania fei Spiritiu, ma iwe wareaa tamanu na wanewane a'a ei baua gufu. ");
INSERT INTO wuv_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Lomi ba i fiharei a'a nemea o i haropararai; lomi nemea ba i guaipa'aa fei laona i ma'aa tala. ");
INSERT INTO wuv_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Lomi ba i winisuminaa fei pa'apa'aa sipawa, fei na malou ua ma lomi na adige, ma lomi ba i pereaa fei ramai, fei anaa ba i pere, nopa'aloo fei ba ina mua fei fawanewaneana. ");
INSERT INTO wuv_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Ei baua gufu, rona pa'i o'onaia unuu ro'ou wagii fei harana.” ");
INSERT INTO wuv_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","I dii, rona noduginamii a'ana hemea rama'a na wadu'ia pigea, mei na pudawerai ma umuloo ma Jesus na fawanewaneia ale'ei ba inei warepa'i ma fanunupa'i. ");
INSERT INTO wuv_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Minaa ei rama'a, ronamina ba'arofo ma rona ware, “Haa, simeni, meni Na'uu David?” ");
INSERT INTO wuv_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Ma'uaa ro'aa guainia ei Pharisee, rona ware, “A'a fei faufau Beelzebub, mei haparaa ei pigea, meni rama'a meni, na fawala'anaa ei pigea.” ");
INSERT INTO wuv_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Jesus na apa'aa ei naranaraa ro'ou ma na ware, “Minaa ei gufuu ei hapara, nabaa ro'aa fifalagii, ro'aa borosi ma minaa ei baua gufu, o humu, nabaa ro'aa fifalagii, lomi ro'aa ufalarai. ");
INSERT INTO wuv_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Nabaa Satan na fawala'anaa ana Satan, ina fifalagii anaia. Ma batanai ba fei haparaiana i ufalarai? ");
INSERT INTO wuv_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Ma nabaa fa'ua ba una fawala'anaa ei pigea a'a fei faufau Beelzebub, ei rama'a gufuu hamu'ou, ro'aa fawala'anaa ei pigea a'a fei faufau hini? Si'ei, ana ro'ou ua, ro'aa ware ba ei wareaa hamu'ou na tata. ");
INSERT INTO wuv_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Ma'uaa, nabaa una fawala'anaa ei pigea a'a fei Spiritii mei Haidaa, te, fei haparaiaa mei Haidaa na nodigimai a'a hamu'ou. ");
INSERT INTO wuv_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","“Ma hepalodiai, batanai ba hemea i wadu'aiporopa'ainaa ei manumanu humuu hemea faufau rama'a nabaa lomi nado'o roro'ai mei faufaua? Ma'uaa, nabaa i roro'inia, ipowe topa'ainaa ei manumanuu humuna. ");
INSERT INTO wuv_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","“Hini lomi na oa a'au, ana lomi na nunuminau ma hini lomi na haufipui a'au, ina larosumai. ");
INSERT INTO wuv_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Si'ei, u'ei warefanaa hamu'ou ba minaa ei hafelo'a ma ei rona warefafeloaa mei Haidaa, mei Haidaa i futoia ma'uaa, lomi ba i futoia nabaa rona warefafeloaa fei Spiriti. ");
INSERT INTO wuv_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Hini i warefafeloaa mei Na'uu Rama'a, mei Haidaa, i futoia, ma'uaa hini i warefafeloaa fei Spiriti Apuna, lomi ba i futoia a'a feni au feni, o fena au ataa nomai. ");
INSERT INTO wuv_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","“Farawaninaa fei haihai ma ei fuana i rawani, o fafeloaa fei haihai ma ei fuana i hafelo, uaa o'aa fanunu'apa'aa fei haihai a'a ei fuana. ");
INSERT INTO wuv_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Hamu'ou ena na'uu wa'a hafelo, batanai ba hamu'ou ena hafelo'a, hamo'aa wareaa ei rawani'a warea? Uaa, tamanu na pepesu laloo ei naranara, fei poa i wareia. ");
INSERT INTO wuv_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Mei rawani'a rama'a i wareaa ei rawani'a, ei na ude laloo naranarana ma mei hafelo'a i wareaa ei hafelo'a, ei na ude i laloo naranarana. ");
INSERT INTO wuv_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Ma'uaa u'ei warefanaa hamu'ou ba a'a fei arewaa dududua, ei rama'a, ro'aa to aree ro'ou a'a minaa ei warefalaraa ro'ou. ");
INSERT INTO wuv_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Uaa wagii ei paolaa wareaa hamu'ou, hamo'aa to aree hamu'ou, o lo'e.” ");
INSERT INTO wuv_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","I dii, hefi'a ei Pharisee mawe ei feroiaa law, rona warenaa a'ana, “Feroia, hai'ouna nunuminia ba onei bigi'aa hepalo hilalaa foigia i pudaa hai'ou.” ");
INSERT INTO wuv_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Ina ware, “Hamu'ou ena rama'a hafelo, ena lomi na oafagugu a'a feni au feni, hamona i'iginau ba unei bigi'aa hepalo hilalaa foigia! Lomi ba a fama'aia, ma'uaa, sifeni ua ba a fama'aia, fei hilalaa mei mamama'a Jonah. ");
INSERT INTO wuv_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Uaa ana ale'ei ba Jonah na oa odu'ai arewaa ma odu'ai poi i laloo iaa fei baua nia ma ana ale'ei, mei Na'uu Rama'a, iwe oa odu'ai arewaa ma odu'ai poi i laloo feni malagufu. ");
INSERT INTO wuv_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","A'a fei arewaa dududua, ei Nineveh, ro'awe ufipui a'a taweni ma ro'aa dududuaa ro'ou; uaa rona filoginaa naranaraa ro'ou a'a ei u'ugaa Jonah ma e'eni na pa'i hemea yeni na muainaa Jonah. ");
INSERT INTO wuv_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","A'a fei arewaa dududua, mei Pifine Hapara noramiana Hara'uu, i asi'afipui a'a taweni ma dududuaa ro'ou; uaa noranamai susuwe'ii gufu ba i guainaa fei apa'aa Solomon ma e'eni ina pa'i hemea yeni na muainaa Solomon. ");
INSERT INTO wuv_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","“Nabaa hepalo spiriti hafelo i wala'aa a'a nemea rama'a, i dinaa a'a ei gufu na hapera ba i labarainaa gutafawenaiana, lomi na labagipa'i. ");
INSERT INTO wuv_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","I dii, ipowe ware, ‘Yau, a hadiwe'inaa a'a fei humu una di'ininia.’ I'a hadiwe'imai, na fanunupa'ia ba lomi hemea na guta lalona ma na apagidii fei humu ma minaa ei manumanu lalona na udelafui. ");
INSERT INTO wuv_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","I dii, ina dugamai olorompalodiai spiriti rona hafelodiai lara hia ma rona wadu'aiguta yei. Ma fei gutanaa mei rama'a mei, namina hafelo'apoi laraa fei gutanana fama'a. Ana ale'ei hinene a'a feni hafelo'a taweni.” ");
INSERT INTO wuv_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Ei ifi warewarelao a'a fei gupuu rama'a Jesus, mei inana mawe ei lofuna, rona u ano ba ro'aa wareware a'ana. ");
INSERT INTO wuv_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Hemea na warefania, “Mei inamu mawe ei lofumu, rona u ano ba ro'aa wareware a'amu.” ");
INSERT INTO wuv_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Ina warefania, “Hini mei inau ma ei lofuu?” ");
INSERT INTO wuv_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Ina uninaa fei panina a'a ei otalai nenerana ma na ware, “Si'eni, eni inau mawe eni lofuu. ");
INSERT INTO wuv_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Uaa hini i bigi'aa ei nunumiaa mei Amau pafea, hia, lofuu, agiu ma inau.” ");
INSERT INTO wuv_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Ana fei arewaa fei, Jesus na asi'aa a'a fei humu ma naree guta yei piye. ");
INSERT INTO wuv_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Abaa po'o gupuu rama'a rona hoaninia ma si'ei, ina hugi pafoo hepalo wa ma guta lalona ma ei rama'a, rona u yei piye. ");
INSERT INTO wuv_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Ma ina warehanunuinaa watauda manumanu a'a ro'ou, ale'eni, “Hemea faroa na dinaa pe'ihapena ba i faroaa ei lau. ");
INSERT INTO wuv_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Ei ifi larofinaa ei lau, hefi'a rona pasi i ma'aa tala ma rona fidumai ei manufifidau ma rona hanaia. ");
INSERT INTO wuv_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Hefi'a, rona pasi pafoo ei na'ana'a, yei lomi na pi'odua ei piye. Na nusu batafa a'a ei piye lomi na pi'odua. ");
INSERT INTO wuv_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Ma'uaa i'a asi'arai fei halo, na sidefaholeaa nusuu ei lau, uaa ataa gugu waraa ro'ou. ");
INSERT INTO wuv_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Hefi'adiai lau, rona pasi i dupuaa ei wowo'ii na hogia ma ei wowo'ii, rona fifigaa nusuu ei lau. ");
INSERT INTO wuv_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Ma hefi'adiai lau, rona pasi pafoo ei rawani'a piye ma rona fuaa ale'ei hefa pu'u, o oloroa pa'ania, o odufua pa'aniadiai a'a figa ei ina faroia. ");
INSERT INTO wuv_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Hini na pa'i adiana nei guainia.” ");
INSERT INTO wuv_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Ei otalai nenerana, rona nomai a'ana ma i'igai, “Tani o warehanunui a'a ei rama'a?” ");
INSERT INTO wuv_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Ina ware, “Fei apa'a a'a ei maumau opa'aiaa fei haparaia pafea, hamona todigia, ma'uaa a'a ro'ou, lomi. ");
INSERT INTO wuv_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Hini na pa'i iwe todiai ma iwe pa'i watauda. Hini lomi na pa'i, tamanu ma'ida ina pa'i, iwe pa'ai a'ana. ");
INSERT INTO wuv_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Sifeni, feni pa'afina a warehanunui a'a ro'ou: “Rona fanunu, ma'uaa lomi rona fanunupa'i; rona guai, ma'uaa lomi rona guaipa'i, o apa'ia. ");
INSERT INTO wuv_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Tamanu nadii wareia mei mamama'a Isaiah, inawe fa'uai a'a ro'ou: “‘Ranimai hamo'aa guai ua, ma'uaa lomi hamo'aa apa'ia; hamo'aa fanunu ua, ma'uaa lomi hamo'aa fanunupa'i. ");
INSERT INTO wuv_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Uaa ei naranaraa eni rama'a eni, nawe waiwai; lomi rona guaifarawani a'a ei adiaa ro'ou, ma rona ma'igunaa ei pudaa ro'ou. Nabaa lomi, woro ro'aa fanunupa'i a'a ei pudaa ro'ou, guaipa'i a'a ei adiaa ro'ou, ma i pa'i apa'aa ei naranaraa ro'ou ma ro'awe filogii ma a farawaninaa ro'ou.’ ");
INSERT INTO wuv_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Ma'uaa na pa'i hawegiana ei pudaa hamu'ou, uaa rona fanunupa'i mawe ei adiaa hamu'ou, uaa rona guaipa'i. ");
INSERT INTO wuv_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Uaa, a warefa'uai a'a hamu'ou ba watauda mamama'a ma wanewaneaa rama'a, rona nunuminia ba ro'aa fanunuaa tamanu hamona fanunuia, ma'uaa lomi; ma rona nunuminia ba ro'aa guainaa tamanu hamona guainia, ma'uaa lomi. ");
INSERT INTO wuv_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","“Hamonei guainaa fei hanuu fei warea hanunuu mei faroa: ");
INSERT INTO wuv_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Nabaa nemea i guainaa fei u'ugaa fei haparaia ma lomi na apa'ia, mei hafelo'a, i nomai ma tarafaa tamanu mei faroa na faroia i naranarana. Ma fei, ale'ei ei lau rona pasi i ma'aa tala. ");
INSERT INTO wuv_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Ei lau rona pasi pafoo ei na'ana'a, tawi'ana ale'ei mei na guainaa fei warea ma nado'o ni'eni'e. ");
INSERT INTO wuv_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Ma'uaa, si'ei ba lomi na gugu warana, lomi na madii fei habeana. I'a nomai ei hafelo'a o ei haperararaia uaa fei rawani'a warea, ina pasi batafa ua. ");
INSERT INTO wuv_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Ei lau rona pasi dupuaa ei wowo'ii na hogia, tawi'ana ale'ei mei na guainaa fei warea, ma'uaa na fifigaa naranarana a'a watauda manumanuu feni ano ma ei sifisifii ei mugoo po'i ma lomi na pa'i fuana. ");
INSERT INTO wuv_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Ma'uaa ei lau rona pasi pafoo ei rawani'a piye, tawi'ana ale'ei mei na guainaa fei warea ma na apa'ia. Ina fuaa ma ei fuana ale'ena hefa pu'u, o oloroa pa'ania, o odufua pa'aniadiai a'a figa ei ina faroia.” ");
INSERT INTO wuv_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Jesus na warefanaa ro'ou hepalodiai warea hanunu: “Fei haparaia pafea, tawi'ana ale'ei mei na faroaa ei rawani'a lau i pe'ihapena. ");
INSERT INTO wuv_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Ma'uaa ro'aa ma'igu minaa ei rama'a, mei bidibidii unu na nomai ma faroaa ei guana maumauna ana i dinaa maumau fei wheat dupuaa ei wheat ma ina aunupa'ai. ");
INSERT INTO wuv_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Laguna nusufipui fei wheat ma fei guana ma laguna pa'i obaa lagua. ");
INSERT INTO wuv_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","“Ei nafii mei amaa fei pe'ihape rona dinaa a'ana ma ware, ‘Hagu'u, a'a ba ona faroaa ei rawani'a lau i pe'ihapemu? Ma noramiaa ro'ou hitani ei guana?’ ");
INSERT INTO wuv_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","“Ina ware, ‘Bigi'aa hemea na bidibidi ununa a'au.’ “Rona i'iginia ei nafina ba, ‘Ona nunuminia ba hai'ouree fufusiminaa ei guana?’ ");
INSERT INTO wuv_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","“Ina ware ba, ‘Lomi, uaa ena hamona fufu'aa ei guana ana hamo'aa fufufininaa ei wheat. ");
INSERT INTO wuv_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Lagunei habefipui nopa'aloo fena au hufu'a. A'a fena au fena, a ware a'a ei hufu'a: Hamoneido'o hiteporaa ei guana ma faroro'inaa ro'ou ma fagu'aia; nenee fei, hamonei hiteporaa ei wheat ma re augia i laloo fei paleu.’” ");
INSERT INTO wuv_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Ina warefanaa ro'ou hepalodiai warea hanunu: “Fei haparaia pafea, tawi'ana ale'ei fei lau mustard na tonia hemea ma faroia laloo pe'ihapena. ");
INSERT INTO wuv_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Fa'ua ba namina pusu'oroi a'a minaa ei lau, ma'uaa ei i habe, namina bauanaidi'ininaa minaa ei manumanu i pe'ihape ma na gipenaa haihai ma ei manufifidau i haroo pafea, ronamii guta a'a ei rarana.” ");
INSERT INTO wuv_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Ina warefanaa ro'ou hepalodiai warea hanunu: “Fei haparaia pafea, tawi'ana ale'ei ei fafuafua na tonia hemea pifine ma fihafuinia a'a watauda palaua hawina na fihafuipedugia ma na fua.” ");
INSERT INTO wuv_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Jesus na warehanunuinaa minaa ei manumanu ei a'a ei gupuu rama'a; lomi na wareaa hepalo abaa warea hanunu. ");
INSERT INTO wuv_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Si'ei, nawe fa'uai tamanu nadii wareia mei mamama'a: “U'a gigiaa fei umuu ma wareaa ei warea hanunu, a wareaa ei manumanu na ude'opa'ai ei i mamara feni ano nopa'amii wagieni.” ");
INSERT INTO wuv_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","I dii, inawe di'ininaa fei gupuu rama'a ma wadu'inaa fei humu. Ei otalai nenerana, rona nomai a'ana ma ware, “Warefa'arewaia a'a hai'ou fei hanuu fei warea hanunuu ei guana i pe'ihape.” ");
INSERT INTO wuv_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Ina ware, “Mei na larofinaa ei rawani'a lau, hia mei Na'uu Rama'a. ");
INSERT INTO wuv_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Fei pe'ihape, ale'eni feni ano ma ei rawani'a lau, ale'ei ei na'uu fei haparaia. Ei guana, ale'ei ei na'uu mei hafelo'a ");
INSERT INTO wuv_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","ma mei bidibidii unu, mei na faroaa ro'ou, hia, mei hani'u. Fei au hufu'a, fei au pedugaa feni ano ma ei hufu'a, ei alo'aloo mei Fasu. ");
INSERT INTO wuv_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","“Hanuu fei fufu'aa ro'ou ei guana ma fagu'aia a'a fei hafi, ana ale'ei fei au pedugaa feni ano. ");
INSERT INTO wuv_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Mei Na'uu Rama'a i aloaa ei alo'alona ma ale'ei ei guana laloo fei haparaiana, rowe fufusiminaa minaa ei manumanu na fafeloaa ei rama'a mawe ei rona bigi'aa ei hafelo'a. ");
INSERT INTO wuv_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Rowe siminaa ro'ou hafi, fei na pa'i ai'aiga ma fi'u'uiaa difo. ");
INSERT INTO wuv_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Si'ei, ei wanewanea, ro'awe we'a ale'ei fei halo i laloo fei haparaiaa mei Amaa ro'ou. Mei na pa'i adiana nei guai. ");
INSERT INTO wuv_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","“Fei haparaia pafea, tawi'ana ale'ei ei gold rona opa'ainia i podu. I'a pa'ia hemea, ina opa'aidinia ma wagii fei ni'eni'eana na aunu ma re aloaa minaa ei manumanuna ma na pono'aa fei podu fei. ");
INSERT INTO wuv_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","“Ma hepalodiai, fei haparaia pafea, tawi'ana ale'ei hemea alo'aloa fi labaginaa ei rawani'a pearl. ");
INSERT INTO wuv_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","I'a labagipa'aa hepalo na bauanai pono'ana, ina aunu ma re aloaa minaa ei manumanuna ma na pono'ia. ");
INSERT INTO wuv_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","“Hepalodiai, fei haparaia pafea, tawi'ana ale'ei hepalo lepo rona pudinaa agi ma tonaa watauda mau nia. ");
INSERT INTO wuv_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","I'a pepesu ei udiaa ro'ou nia, rona forafa'aununaa piye. Ma rona guta ma to'augaa ei rawani'a nia laloo ei pa ma ei hafelo'a, rona siminia. ");
INSERT INTO wuv_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Ana ale'ei a'a fei au pedugaa feni ano. Ei alo'aloo mei Fasu, rowe nomai ma fi'alaginaa ei hafelo'a a'a ei wanewanea ");
INSERT INTO wuv_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","ma ei hafelo'a, ro siminaa hafi, fei na pa'i ai'aiga ma fi'u'uiaa difo.” ");
INSERT INTO wuv_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Jesus na i'igai, “Hamona apa'aa minaa ei manumanu ei?” Rona ware ba, “Hi'i.” ");
INSERT INTO wuv_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Ina warenaa a'a ro'ou, “Si'ei, nabaa hemea na fa'arewaiaa fei haparaia pafea a'a hemea feroiaa law, mei feroiaa law, hia ale'ei mei amaa hepalo humu, mei na fa'asi'anamai ei manufau mawe ei watanai rawani'a manumanu a'a fei leana.” ");
INSERT INTO wuv_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","I'a warepedugaa ei warea hanunu Jesus, ina di'ininaa fei gufu fei. ");
INSERT INTO wuv_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","I'a dinamii a'a fei pa'aa gufuna ma na'aa feroinaa ei rama'a i laloo fei synagogue ro'ou ma ronamina malefa. Rona i'igai, “Tonana hitani meni rama'a meni, fei apa'a ma fei faufau ba i bigi'aa ei foigia? ");
INSERT INTO wuv_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Haa, simeni, meni na'uu mei fadufadua? Haa, mei inana Mary ma ei lofuna James, Joseph, Simon ma Judas? ");
INSERT INTO wuv_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","A'a ba minaa ei agina a'a o'ou yeni? Nabaa ale'ei, tonana hitani minaa ei manumanu ei, meni rama'a meni?” ");
INSERT INTO wuv_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Ma rona faraa a'ana. Ma'uaa Jesus na warenaa a'a ro'ou, “Ana uniaa a'a fei pa'aa gufuna ma fei pa'aa humuna, hemea mamama'a lomi i honua.” ");
INSERT INTO wuv_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Ma lomi ina bigi'aa watauda foigia yei, uaa lomi na we'i naranaraa ro'ou. ");
INSERT INTO wuv_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","A'a fei au fei, Herod, mei haparaa obao gufu na guainaa ei u'ugaa Jesus ");
INSERT INTO wuv_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","ma na warenaa a'a ei paniaa panina, “Hia John, mei Pudugufaia. Na ma'elele'aa! Si'ei i pa'i faufauna ba i bigi'aa ei foigia.” ");
INSERT INTO wuv_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Herod na panarofaa John ma bobo'inia, uaa ba ina ware watauda a'a fei bigi'aa lagua Herodias, mei haroo mei lofuna Philip. ");
INSERT INTO wuv_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Hamatee John na'aida warefanaa Herod ba, “Lomi na rawani a'a fei law ba yoi, o haroinia.” ");
INSERT INTO wuv_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Herod, ba i fo'afama'eaa John, ma'uaa ina ma'au a'a ei rama'a, uaa rona nara ba hia hemea mamama'a. ");
INSERT INTO wuv_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","A'a fei arewaa waniniaa Herod, mei na'uu Herodias na ufa'ufa i pudaa ro'ou ma si'ei ba namina fani'eni'eaa Herod, ");
INSERT INTO wuv_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Herod na fa'unai a'ana ba tamanu nunumiana, inei i'iginia ma i fania. ");
INSERT INTO wuv_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Si'ei ba ina u'ugainia mei inana, ina ware, “Fanau yeni i pafoo hefaa tabetabe fei tabaa John, mei Pudugufaia.” ");
INSERT INTO wuv_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Mei hapara na naranara watauda, ma'uaa si'ei ba na fa'unai pudaa ei rama'a, ei ro'ei guta hananafipui a'ana, ina ware ba fei i'igiana, ronei bigi'ia. ");
INSERT INTO wuv_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Ma rona moro'aa huaa John yei humuu bobo'aia. ");
INSERT INTO wuv_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Rona tabeamii fei tabana pafoo fei tabetabe ma fanaa mei nanao ma ina notabenaa a'a mei inana. ");
INSERT INTO wuv_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Ei otalai neneraa John, rona nomai ma tonaa fei ununa ma agifinia ma ronaree warefanaa Jesus. ");
INSERT INTO wuv_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","I'a guainia Jesus, na hugi pafoo wa ma aununaa fawelei lomi rama'a. Ro'aa guainaa fei, ei gupuu rama'a, noramiaa ro'ou a'a ei gufu, rona talai'uanaa pinee ro'ou ma nenegia. ");
INSERT INTO wuv_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","I'a nofatetelao Jesus, na fanunuaa hepalo baua gupuu rama'a ma na faloloa'inaa ro'ou ma na farawaninaa ei funuaa ro'ou. ");
INSERT INTO wuv_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","I nofafilao, ei otalai nenerana, rona nomai a'ana ma ware, “Ina raua faweleni ma na fafidii. Aloaa ei gupuu rama'a ba ronei aununaa ei gufu ma pono hanaa ro'ou.” ");
INSERT INTO wuv_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Jesus na ware, “Lomi na rawani ba ronei aunu. Hamu'ou fani hanaa ro'ou.” ");
INSERT INTO wuv_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Rona ware, “Hai'ouna pa'i haipani ua faraa pidaua ma guapalo nia.” ");
INSERT INTO wuv_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Ina ware, “Tonamai a'au.” ");
INSERT INTO wuv_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Ma ina warenaa a'a ei rama'a ba ronei guta pafoo ei guana. Ina tonaa haipaniei faraa pidaua ma guapaloei nia, na aranaa pafea, na ware ‘ta’ ma na digeaa ei faraa pidaua. Na fanaa ei otalai nenerana ba ronei fanaa ei rama'a. ");
INSERT INTO wuv_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Minaa ro'ou, ronamina hanana magu ma ei otalai nenerana, rona paiaa hefua ma guapalo pa masii du'ua. ");
INSERT INTO wuv_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Puduu ei rona hanana, haipani pufaba'a wawane ma na pa'idiai pifine ma baduu. ");
INSERT INTO wuv_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Ana ei ua, Jesus na fahuginaa ei otalai nenerana pafoo fei wa ma alonaa ro'ou ma'ana ba ronei dinaa pepei ma hia, i do'o aloaa fei gupuu rama'a. ");
INSERT INTO wuv_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","I alodigaa ro'ou, na faneaa hepalo maugeni, ana unaia ba i lafulafu. I nopoilao, ana unaia yei, ");
INSERT INTO wuv_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","ma'uaa fei wa na rauadii piye ma na hasuroforofo ua, uaa fei lalarena na agisuafia. ");
INSERT INTO wuv_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Mafufuo badu, Jesus na talainaa a'a ro'ou pafoo agi. ");
INSERT INTO wuv_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Ro'aa fanunupa'ia ei otalai nenerana fi talaimai pafoo agi, ronamina ma'aufafelo. Rona ware ba, “Hani'u, mena!” ma rona ma'au'iwa'iwa. ");
INSERT INTO wuv_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Ma'uaa Jesus na warebatafalao a'a ro'ou, “Guta farawani! Yau meni. Apuna ma'au.” ");
INSERT INTO wuv_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Peter na ware, “Mena Fasu, nabaa pa'aa yoi, waremai a'au ba unei talaiwau a'amu pafoo agi.” ");
INSERT INTO wuv_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Ina ware, “Nomai.” Si'ei, Peter na upu pafoo fei wa ma talainaa a'a Jesus pafoo agi. ");
INSERT INTO wuv_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Ma'uaa i fanunupa'aa fei lalarena, na ma'aumomogu ma ina haroharo, “Mena Fasu, hadumau!” ");
INSERT INTO wuv_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Ana ei ua, Jesus na roainaa panina ma panarofia. Ina ware, “Yoi mena pusu'o we'iaa naranaramu, tani omina hamamagua?” ");
INSERT INTO wuv_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Ma lagu'aa hugi pafoo fei wa, fei lalarena na rere. ");
INSERT INTO wuv_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Ma ei ro'ou laloo fei wa, rona losuinia ma ware ba, “Pa'aa fa'ua ba yoi, Na'uu mei Haidaa.” ");
INSERT INTO wuv_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Ro'aa dinaa pepei, rona fatetenaa Gennesaret. ");
INSERT INTO wuv_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Ma ei rama'aa fei gufu fei, ro'aa fanunu'apa'aa Jesus, rona alo warea a'a minaa ei gufu fawelei. Ma ei rama'a, rona duginamii a'a Jesus minaa ei funuaa gufuu ro'ou. ");
INSERT INTO wuv_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Ma rona i'igifawe'i a'ana ba nei ugainaa ei funua ba ronei idoa'uaiaa fei supuu hawaa uguna ma minaa ei rona idoia, ronawe rawani. ");
INSERT INTO wuv_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","I dii, hefi'a ei Pharisee mawe ei feroiaa law rona dinaa a'a Jesus, noramiaa ro'ou, Jerusalem ma rona i'igai, ");
INSERT INTO wuv_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“Tani ro'aa barafeaa ei maumau ei upuu o'ou ei otalai neneramu? Lomi ronado'o huwe panii ro'ou nabaa ro'aa hanana!” ");
INSERT INTO wuv_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Jesus na ware, “Hamatani hamu'ou barafeaa ei wareaa mei Haidaa uaa ei maumau ei upuu hamu'ou? ");
INSERT INTO wuv_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Uaa mei Haidaa na ware, ‘Ma'auaa mei amamu ma inamu’ ma ‘Hini i umuaa mei amana o inana, ronei fo'afama'eia.’ ");
INSERT INTO wuv_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Ma'uaa hamona ware ba nabaa nemea na warenaa a'a mei amana o inana ba, ‘Fei ba a fanio, a fanaa mei Haidaa.’ ");
INSERT INTO wuv_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Si'ei, lomi ina ma'auaa amana a'a fei fanana. Si'ei, hamu'ou barafeaa fei wareaa mei Haidaa uaa fei maumau hamu'ou. ");
INSERT INTO wuv_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Hamu'ou ena ware'oni! Pa'aa fa'ua ei wareaa Isaiah: ");
INSERT INTO wuv_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","“‘Eni rama'a eni, rona ma'auau a'a ei haba'umuu ro'ou, ma'uaa ei naranaraa ro'ou, na raua a'au. ");
INSERT INTO wuv_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Lomi hanuu ei losuiaa ro'ou yau; ei feroiaa ro'ou, naranaraa rama'a ua.’” ");
INSERT INTO wuv_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Jesus na haronamii a'ana fei gupuu rama'a ma na ware, “Guainia ma apa'ia. ");
INSERT INTO wuv_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Tamanu ina wadu'aa poaa hemea rama'a, lomi i ‘faloloaia’, ma'uaa tamanu na lele'aa i poana, sifei, fei na ‘faloloaia’ pudaa mei Haidaa.” ");
INSERT INTO wuv_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","I dii, ei otalai nenerana rona nomai a'ana ma i'igainia, “Ona aida ba ei Pharisee, rona ra ei ro'aa guainaa fei?” ");
INSERT INTO wuv_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Ina ware, “Minaa ei fudaa, ei abaa faroaa mei Amau pafea, iwe fufufininaa ei waraa ro'ou. ");
INSERT INTO wuv_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Di'ininaa ro'ou, uaa rona pudawerai ma rona'aida talaidugaa ei rama'a. Nabaa hemea pudawerai na talaidugaa hemeadiai pudawerai, lagu'amina pasifipuinaa laloo fei huapu.” ");
INSERT INTO wuv_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Peter na ware, “Italalafuifanaa hai'ou fei warea hanunu.” ");
INSERT INTO wuv_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Jesus na i'iginaa ro'ou, “Haa, ana fi waiwai tabaa hamu'ou? ");
INSERT INTO wuv_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Lomi hamona aida ba tamanu na wadu'ainaa fei haba'umu, i dinaa pahanana ma i lele'alao? ");
INSERT INTO wuv_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Ma'uaa tamanu na lele'aa a'a fei haba'umu, norai a'a ei naranara ma na ‘faloloaa’ mei rama'a. ");
INSERT INTO wuv_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Uaa laloo fei naranara, ina nomai ei hafelo'a naranara, fo'afama'ea, fiharoharoipa'aia, fitatafipa'aia, fafanaoa, warefasifi ma ei wiwitoia. ");
INSERT INTO wuv_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Si'ei, ei na ‘faloloaa’ hemea rama'a; ma'uaa, nabaa nemea lomi na huwenaa panina ma hanana, abaa na ‘faloloaia’.” ");
INSERT INTO wuv_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","I'a di'ininaa fei gufu fei, Jesus na dinaa fawelei Tyre ma Sidon. ");
INSERT INTO wuv_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Hemea pifinee Canaan, humuna na rafi'inaa Tyre ma Sidon, ina nomai a'ana ma na haroharonaa a'ana, “Mena Fasu, mena Na'uu David, faloloa'inau! Mei na'uu, baduu pifine namina nanamuinia uaa na wadu'ia pigea.” ");
INSERT INTO wuv_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Lomi na wareaa hepalo warea Jesus. Si'ei, ei otalai nenerana rona nomai a'ana ma na i'igifawe'i a'ana, “Aloia, uaa ifimina aiharoharomai a'a o'ou.” ");
INSERT INTO wuv_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Ina ware, “Ina aloamiau a'a ei pa'aiaa sipsipi Israel ua.” ");
INSERT INTO wuv_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Mei pifine na nomai ma fa'unaa du'una i ma'ana ma ware, “Mena Fasu, hadumau!” ");
INSERT INTO wuv_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Ina ware, “Lomi na wanewane ba a tonaa ei faraa pidaua, ei hanaa ei baduu ma faguaa ei hapee ro'ou, ponoto.” ");
INSERT INTO wuv_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Ina ware ba, “Fa'ua, mena Fasu, ma'uaa ei ponoto ana rona hanaiaa ei memee faraa pidaua, ei na pasinaa haroo tawaa ei fasuu ro'ou.” ");
INSERT INTO wuv_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Si'ei, na ware Jesus, “Mena pifine, namina we'i naranaramu! Una bigidigia fei i'igiamu.” Ma mei na'una na rawani ana a'a fei au fei. ");
INSERT INTO wuv_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Jesus na di'ininaa fei gufu fei ma tatalai i papaa fei Agii Galilee. I dii, ina fanenaa fei maugeni ma na guta. ");
INSERT INTO wuv_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Hefi'a baua gupuu rama'a, rona nomai a'ana, nodugamii ei afetoo, ei pudawerai, ei iba'iba, ei umuloo mawe wataudadiai ma rona fahainopaa ro'ou i pinena; ma ina fawanewaneaa ro'ou. ");
INSERT INTO wuv_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Ei rama'a, ronamina ba'arofo ei ro'aa fanunuia ba ei umuloo, rona warepa'i, ei iba'iba, rona rawani, ei afetoo, rona talaipa'i ma ei pudawerai, rona fanunupa'i. Ma rona uduginaa mei Haidaniaa ei Israel. ");
INSERT INTO wuv_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Jesus na harofamai ei otalai nenerana ma na ware, “Una faloloa'inaa eni rama'a eni, uaa rona gutafipui a'au ale'ei oduai arewaa ma lomi rona pa'i hanaa ro'ou. Lomi na rawani a'au ba rona bao ma u'a aloaa ro'ou, uaa ro'aa pasi ma'aa tala.” ");
INSERT INTO wuv_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Ei otalai nenerana, rona ware, “O to hitani faraa pidaua a'a feni raua gufu ale'eni ba na hawia ba o'aa faguaa feni baua gupuu rama'a ale'eni?” ");
INSERT INTO wuv_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Jesus na i'igai, “Hamona pa'i figa faraa pidaua?” Rona ware ba, “Olorompalo ma hefi'a pusu'o nia.” ");
INSERT INTO wuv_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Ina warenaa a'a fei gupuu rama'a ba ronei guta malagufu. ");
INSERT INTO wuv_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Ma ina tonaa olorompaloei faraa pidaua ma ei nia ma i'a waredii ba ‘ta’, na digedigeaa ro'ou ma fanaa ei otalai nenerana ma rona fanaa ei rama'a. ");
INSERT INTO wuv_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Minaa ro'ou, rona hanana ma ronamina magu. Nenee fei, ei otalai nenerana, rona paifapepesuaa olorompalo pa masii du'ua. ");
INSERT INTO wuv_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Puduu ei rona hanana, gunaroa pufaba'a wawane ma na pa'idiai pifine ma baduu. ");
INSERT INTO wuv_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","I'a alodigaa fei gupuu rama'a Jesus, na hugi pafoo wa ma aununaa malalaa Magadan. ");
INSERT INTO wuv_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Ei Pharisee mawe ei Sadducee, rona nomai a'a Jesus ma rona mania ale'ei ba nei fama'aiaa ro'ou hepalo hilala noranarai pafea. ");
INSERT INTO wuv_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Ina ware, “I'a fafilao, hamona ware ba, ‘Iwe rawani ua narani hamatee na ro fei haroo pumanugawe’, ");
INSERT INTO wuv_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","ma na mafufuo hamo'aa ware ba, ‘Wagieni i pa'i lalarena ma maunu, uaa na ro fei haroo pumanugawe ma ana na giogio.’ Hamona fanunu'apa'aa ei hilala haroo pumanugawe ma'uaa, lomi hamona fanunu'apa'aa ei hilalaa feni au feni. ");
INSERT INTO wuv_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","A'a feni au feni, ei hafelo'a, ei lomi rona oafagugu, rona labaginaa hepalo foigia hilala, ma'uaa lomi. Ro'aa fanunuaa hepalo ua, fei hilalaa Jonah.” Ma Jesus na di'ininaa ro'ou ma aunu. ");
INSERT INTO wuv_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Rona aunudiginaa pepei adii fei agi ma ei otalai nenerana, rona madi'inia ba ro notomai faraa pidaua. ");
INSERT INTO wuv_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Jesus na warenaa a'a ro'ou, “Hamonei oma'aa hamu'ou a'a ei fafuafuaa ei Pharisee ma Sadducee.” ");
INSERT INTO wuv_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Rona fiwarewareinia dupuaa ro'ou ma ware, “Haa woro si'ei ba lomi ona notomai faraa pidaua.” ");
INSERT INTO wuv_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Jesus na apa'adigaa ei fiwarewareiaa ro'ou ma na i'igai, “Hamu'ou ena pusu'oro we'iaa naranara, tani hamo'aa fiwarewarei dupuaa hamu'ou ba lomi hamona pa'i faraa pidaua? ");
INSERT INTO wuv_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Haa, hamotawe apa'ia? Lomi hamona nonominaa haipaniei faraa pidaua a'a ei haipani pufaba'a ma hefiga pa masii du'ua hamona paia? ");
INSERT INTO wuv_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Ma olorompaloei faraa pidaua a'a ei gunaroa pufaba'a—hefiga pa masii du'ua hamona paia? ");
INSERT INTO wuv_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Batanai ei ba lomi hamona apa'ia ba yau a'a ba fi wareaa ei faraa pidaua a'a hamu'ou? Ma'uaa, hamonei oma'aa hamu'ou a'a ei fafuafuaa ei Pharisee ma Sadducee.” ");
INSERT INTO wuv_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Ma ronawe apa'ia ba, hia, a'a ba ifi warewareaa fei fafuafua faraa pidaua ma'uaa, fei mau feroiaa ei Pharisee ma Sadducee. ");
INSERT INTO wuv_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","I nopa'amii malalaa Caesarea Philippi Jesus na i'igainaa ei otalai nenerana, “Ei rama'a, rona ware ba mei Na'uu Rama'a, hia, hini?” ");
INSERT INTO wuv_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Rona ware, “Hefi'a, rona ware ba John, mei Pudugufaia; hefi'a ba Elijah; ma hefi'adiai ba Jeremiah, o hemea ei mamama'a.” ");
INSERT INTO wuv_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Ina i'igai ba, “Ma hamu'ou, hamona ware ba yau, hini?” ");
INSERT INTO wuv_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Simon Peter na ware, “Yoi mei Christ, mei Na'uu mei Haidaa, mei i oalao.” ");
INSERT INTO wuv_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Jesus na ware, “Ona pa'i hawegiamu, Simon mena na'uu Jonah uaa, a'a ba fa'arewaa hemea rama'a a'amu ma'uaa, fa'arewaa mei Amau pafea. ");
INSERT INTO wuv_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Ma u'ei warefanio ba yoi Peter ma pafoo feni na'a feni a fa'ugaa fei losuu ma ei gigei Hades, lomi ba ro'aa muaipa'ia. ");
INSERT INTO wuv_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","A fanio ei gigigii fei haparaia pafea; ma tamanu ona faroro'inia yeni malagufu, ana i roro'ai pafea ma tamanu ona alagia yeni malagufu, ana i ala pafea.” ");
INSERT INTO wuv_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Ma ina warefawe'i a'a ei otalai nenerana ba ronei'aa warefanaa nemea ba hia, mei Christ. ");
INSERT INTO wuv_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","A'a fei au fei ma nolao, Jesus na warefa'arewaia a'a ei otalai nenerana ba hia, i dinaa Jerusalem ma tonaa fi'ina a'a watauda manumanu i panii ei bauaniaa gufu, ei famamoaa humuu mei Haidaa mawe ei feroiaa law. Ma hefi'a, ro'aa fo'afama'eia ma a'a fei fa'odu'aiaa arewaa i asi'adiai. ");
INSERT INTO wuv_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Peter na dugitata'ainia ba i warefawanewaneinia, “Pa'aa lomi, mena Fasu! Hefeni, pa'aa lomi ba i nomai a'amu!” ");
INSERT INTO wuv_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Jesus na momo'ilao ma warenaa a'a Peter, “Dinaa mugiu, mena Satan! Yoi ale'ena hepalo alabe'a a'au; lomi ona pa'i naranaramu a'a ei manumanuu mei Haidaa ma'uaa, a'a ei manumanuu rama'a.” ");
INSERT INTO wuv_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Ma Jesus na warenaa a'a ei otalai nenerana ba, “Hini ba i nenerau nei aunaa ei naranarana i pu ma harenaa fei hawafolona ma nenerau. ");
INSERT INTO wuv_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Uaa hini ba i urofaa fei harenuana iwe pa'ai a'ana, ma'uaa hini i fapa'ainaa fei harenuana a'au iwe tonia. ");
INSERT INTO wuv_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Tamanu fei rawani'ana nabaa nemea i topedugaa feni malagufu ma'uaa fei harenuana i pa'ai? O, nemea i filoginaa fei harenuana a'a tamanu? ");
INSERT INTO wuv_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Uaa mei Na'uu Rama'a, iwe nomai a'a fei haweraa mei Amana fipuinaa ei alo'alona ma i fani pono'aa hememea ana ale'ei tamanu ina bigi'ia. ");
INSERT INTO wuv_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","A warefa'uai a'a hamu'ou ba hefi'a eni rona u yeni, ro'ado'o fanunuaa mei Na'uu Rama'a na nomai ale'ei hemea hapara ei ana roifi werawera.” ");
INSERT INTO wuv_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Nenee oloroa arewaa, Jesus na nodugaa Peter ma laguei filofui James ma John pafoo fei tarea maugeni, uniaa ro'ou. ");
INSERT INTO wuv_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Ma na filogii fei maumauna yei i pudaa ro'ou. Fei pudana na we'a ale'ei fei halo ma ei lawalawana namina po'i ale'ei we'ai. ");
INSERT INTO wuv_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Ana ei ua, laguna fa'arewamai Moses ma Elijah ma laguna fiwarewarei a'a Jesus. ");
INSERT INTO wuv_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Peter na warenaa a'a Jesus, “Mena Fasu, ina rawani ba o'ou yeni. Nabaa ona nunuminia, a fa'ugaa odumanu pale, hepalo yoi, hepalo Moses ma hepalo Elijah.” ");
INSERT INTO wuv_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Ei fi warewarelao, hepalo agimee papalei na hawainaa ro'ou ma hepalo lao noranarai a'a fei papalei na ware, “Simeni, meni Na'uu, meni una haguia; ma unamina ni'eni'e a'ana. Guainaa wareana!” ");
INSERT INTO wuv_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Ro'aa guainia ei otalai nenerana, rona fapasipoponainaa pu ma rona ma'aufunurere. ");
INSERT INTO wuv_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Ma'uaa Jesus na nomai ma idoaa ro'ou. Ina ware ba, “Asi'aa. Apuna ma'au.” ");
INSERT INTO wuv_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Ro'aa aranaa pafea, lomi rona fanunupa'aa hemeadiai, ana unaa Jesus. ");
INSERT INTO wuv_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Ei roi upugio a'a fei maugeni, Jesus na warefa'aiaa ro'ou, “Apuna warefanaa nemea tamanu hamona fanunuia nopa'aloo fei ba mei Na'uu Rama'a na asi'aa a'a fei ma'ea.” ");
INSERT INTO wuv_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Ei otalai nenerana, rona i'iginia, “Tani ro'aa ware ei feroiaa law ba Elijah neido'o nomai?” ");
INSERT INTO wuv_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Jesus na ware, “Fa'ua, Elijah ba i nomai ma mi aufarawaninaa minaa ei manumanu. ");
INSERT INTO wuv_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Ma'uaa a warefanaa hamu'ou ba Elijah na nodigimai ma lomi rona fanunu'apa'ia; ma'uaa, rona bigi'aa tamanu rona nunuminia a'ana. Ma mei Na'uu Rama'a ana i tonaa fi'ina i panii ro'ou.” ");
INSERT INTO wuv_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Ma ei otalai nenerana, ronawe apa'ia ba hia fi u'ugaa John, mei Pudugufaia. ");
INSERT INTO wuv_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Ro'aa nobapa'aloo fei gupuu rama'a, hemea na nomai ma na o'o'ui i ma'aa Jesus. ");
INSERT INTO wuv_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","Ina ware, “Mena Fasu, faloloa'inaa mei na'uu, baduu wawane. Ina'o memeroi ma namina nanamuinia. Ina'o pasinaa laloo fei hafi, o laloo fei ranu. ");
INSERT INTO wuv_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Una noduginaa hia a'a ei otalai neneramu ma'uaa, lomi ba rona farawanipa'ia.” ");
INSERT INTO wuv_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Jesus na ware, “Hamu'ou ena rama'aa feni au feni, lomi na we'i ma ana lomi na wanewane ei naranaraa hamu'ou. Yau na tamafoidii a'a fei gutanau a'a hamu'ou. Ana una tamafoi a'a fei maumau hamu'ou. Dugamii mei baduu wawane a'au.” ");
INSERT INTO wuv_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Jesus na warefawe'i a'a mei pigea ma na wala'aa a'ana ma ana ei ua na rawani mei baduu. ");
INSERT INTO wuv_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Si'ei, ei otalai nenerana uniaa ro'ou, rona nofagigimai a'a Jesus ma i'iginia, “Tani lomi hai'ouna fawala'apa'ia?” ");
INSERT INTO wuv_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Ina ware, “Hamatee namina pusu'oroi fei we'iaa naranaraa hamu'ou. A warefa'uai a'a hamu'ou ba nabaa na we'i ma'ida ua ei naranaraa hamu'ou ale'ei fei pusu'o lau mustard, hamo'aa ware a'a fei maugeni ba, ‘Asi'aa faweleni ma dinaa yei’ ma i asi'a'aunu. Lomi hepalo manumanu ba lomi i ma'atalaa a'a hamu'ou.” ");
INSERT INTO wuv_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Ro'aa nofipuimai i Galilee, ina warenaa a'a ro'ou ba, “Mei Na'uu Rama'a, ro'aa aloia panii ei rama'a. ");
INSERT INTO wuv_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Ro'aa fo'afama'eia ma a'a fei fa'oduaiaa arewaa, i asi'aa ma fawenaidiai.” Ma ei otalai nenerana, ronamina faloloa'i. ");
INSERT INTO wuv_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Nenee fei noramiaa Jesus ma ei otalai nenerana yei Capernaum, ei otonaa guapalo pusu'o mugoo po'ii fei humuu mei Haidaa, rona nomai a'a Peter ma i'igai “Ana i au mugoo po'ii fei humuu mei Haidaa mei feroiamu?” ");
INSERT INTO wuv_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Peter na ware, “Hi'i, i au.” I wadu'imai laloo fei humuu Peter, Jesus nado'o ba ware ba, “Tamanu ei naranaramu, Simon? Ei haparaa feni malagufu rona'o to mugoo po'i a'a hini—a'a ei na'uu ro'ou o a'a hefi'adiai?” ");
INSERT INTO wuv_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Peter na ware, “A'a hefi'a.” Jesus na ware a'ana, “Si'ei ba ei na'uu ro'ou, lomi ro'aa au. ");
INSERT INTO wuv_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Ma'uaa, si'ei ba lomi agu'aa faranaa ro'ou, dinaa agi ma suminaa fei waomu. Tonaa fei rawarawa gu'amu nia; fahawainaa fei poana ma o ma'apa'aa hepalo obao drachma mugoo po'i. Tonia ma fanaa ro'odu fena augaa agua.” ");
INSERT INTO wuv_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","A'a fei au fei, ei otalai nenerana, rona nomai a'a Jesus ma i'igai, “Hini na pafeai laloo fei haparaia pafea?” ");
INSERT INTO wuv_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Ina harofaa hemea pusu'o baduu ma fa'ufalarainia dupuaa ro'ou. ");
INSERT INTO wuv_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","Ma ina ware, “A warefa'uai a'a hamu'ou, nabaa lomi hamo'aa filoginaa maumau hamu'ou ale'ei ei pusu'o baduu, pa'aa lomi ba hamo'aa wadu'inaa laloo fei haparaia pafea. ");
INSERT INTO wuv_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Si'ei hini i fafafaunaa anaia pu ale'eni meni baduu meni, hia i pafeai laloo fei haparaia pafea. ");
INSERT INTO wuv_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","“Ma a'a fei harau, hini i taufagutanaa nemea pusu'o baduu ale'eni meni, ina taufagutanau. ");
INSERT INTO wuv_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","“Ma'uaa, nabaa nemea i fapasiaa nemea eni pusu'o baduu, eni na we'i naranaraa ro'ou a'au, na rawani ba mei rama'a mei, hepalo baua mugoo nei habe huana ma re famomogu lama roroma. ");
INSERT INTO wuv_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","“Na fagiana feni ano uaa na fafeloaa ei rama'a. Ei manumanu ale'ei, i nomai, ma'uaa na fagiana mei i nomai a'ana! ");
INSERT INTO wuv_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Nabaa fei panimu o pinemu na fafeloio, balaisiminia. Ina rawani ba o wadu'aitonaa harenuamu fininaa latoaa panimu o pinemu laraa fei ba ona pa'i guapalo pani ma pine ma i siminio laloo fei hafi lomi i peretoo. ");
INSERT INTO wuv_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Ma nabaa fei pudamu na fafeloio, walesiminia. Ina rawani ba o wadu'aitonaa harenuamu a'a hepalo ua puda laraa fei ba ona pa'i guapalo puda ma i siminaa yoi fei hafii gufu hafelo. ");
INSERT INTO wuv_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","“Oma'ama'aa hamu'ou ba lomi hamona fanunufafelo a'a nemea eni pusu'o baduu eni. Uaa u'ei warefanaa hamu'ou ba ranimai, ei alo'alo pafea, ei oma'aa ro'ou, rona fanunuaa fei pudaa mei Amau i pafea. ");
INSERT INTO wuv_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","“Tamanu naraa hamu'ou? Nabaa nemea na pa'i hefa pu'u sipsipi ma hepalo na lelepa'ai, haa, lomi i di'ininaa ei faimfua pa'ania ma faimpalo pafoo maugeni ma re labaginaa fei na lelepa'ai? ");
INSERT INTO wuv_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Ma nabaa i labagipa'ia, a warefa'uai a'a hamu'ou ba imina ni'eni'e a'a fei laraa ei faimfua pa'ania ma faimpalo lomi rona lelepa'ai. ");
INSERT INTO wuv_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Ana ale'ei, mei Amaa hamu'ou i pafea, lomi na nunumiai ba nemea eni pusu'o baduu eni i pa'ai. ");
INSERT INTO wuv_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","“Nabaa mei lofumu i bigifatata a'amu, dinaa a'ana ma fama'aiaa fei tatana, uniaa hamugua ua. Nabaa i guainio, te, lomi watolaa hamugua. ");
INSERT INTO wuv_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Ma'uaa, nabaa lomi i guainio, dugaa helaguidiai a'amu ba ‘i pa'i helagui o o'odui gutaguaiaa minaa ei awataa.’ ");
INSERT INTO wuv_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Nabaa lomi ina guainaa ro'ou, warefanaa ei losuia; ma nabaa lomi ina guainaa ro'ou, bigi'ia a'ana ale'ei ona bigi'ia a'a nemea roromaa, o nemea otonaa mugoo po'ii gavaman. ");
INSERT INTO wuv_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","“A warefa'uai a'a hamu'ou ba tamanu hamona faroro'inia yeni malagufu, ana i roro'ai i pafea ma tamanu hamona alagia yeni malagufu, ana i ala i pafea.” ");
INSERT INTO wuv_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","“Hepalodiai, a warefanaa hamu'ou ba nabaa helagui hamu'ou yeni malagufu, hamuna fi'ugai ba hamu'aa i'igainaa hepalo manumanu, mei Amau i pafea, i bigi'ia a'a hamugua. ");
INSERT INTO wuv_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Uaa hitani helagui, o o'odui, ro'amii gutafipui wagii fei harau, yau ana a'a ro'ou.” ");
INSERT INTO wuv_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","I dii, Peter na nomai a'a Jesus ma i'iginia, “Mena Fasu, figa au a futoaa ei hafelo'a na bigi'ia a'au mei lofuu? Inei ale'ena olorompalopoa?” ");
INSERT INTO wuv_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Jesus na ware, “A warefanio, a'a ba olorompalopoa ma'uaa, oloromfua pa'ania ma olorompalopoa. ");
INSERT INTO wuv_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","“Si'ei, fei haparaia pafea, tawi'ana ale'ei hemea hapara, mei ba i fawanewaneaa ei pono'aa ei nafina. ");
INSERT INTO wuv_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Ei ba i fawanewaneaa ei mugoo po'i, hefi'a, rona duginaa a'ana hemea nado'o tonaa hefua pa'ania pufaba'a mugoo po'i a'ana. ");
INSERT INTO wuv_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Si'ei ba lomi na pa'i mugoo po'i, mei hapara na warefawe'i ba hia, mei harona, ei na'una mawe minaa ei manumanuna, ronei aloaa ro'ou ba hodi'aa ei mugoo po'ina. ");
INSERT INTO wuv_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","“Mei nafi na fapasinaa du'una i ma'ana. Ina i'igifawe'i a'ana, ‘Do'o fawiwi'ainau ma awe hodipedugaa minaa ei mugoo po'i.’ ");
INSERT INTO wuv_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Mei fasuu mei nafi na faloloa'inia ma na fama'e'uaiaa minaa ei tonana ma alofatalainia. ");
INSERT INTO wuv_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","“Ma'uaa ei fi asi'alao mei nafi, ina nobapa'alao hemeadiai nafi na bigifipui a'ana, hemea nado'o tonaa hefa pu'u denarius a'ana. Ina panarofia ma guafaa gimona ma warefawe'i a'ana, ‘Hodi'aa tamanu ona tonia a'au!’ ");
INSERT INTO wuv_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","“Mei nafi, mei na bigifipui a'ana na fapasinaa du'una ma na i'igifawe'i a'ana, ‘Do'o fawiwi'ainau ma awe hodi'aa minaa ei mugoo po'imu.’ ");
INSERT INTO wuv_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","“Ma'uaa ina ware ba lomi. Ma idii, inaree aunaa hia humuu bobo'aia hawina ba na hodipedugaa ei mugoo po'i. ");
INSERT INTO wuv_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Ro'aa fanunuia ale'ei hefi'adiai nafi, ronamina naranara watauda ma ronaree warefanaa mei fasuu ro'ou minaa ei rona fanunuia. ");
INSERT INTO wuv_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","“Si'ei, mei fasu na lala'aa mei nafi ma ware, ‘Yoi, hemea pa'aa hafelo'a nafi. Unamina fama'e'uaiaa minaa ei onado'o tonia a'au, uaa onamina i'igaifawe'i a'au. ");
INSERT INTO wuv_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Haa, lomi ba o'aa faloloa'inaa mei hamugua ale'ei a bigi'ia a'amu?’ ");
INSERT INTO wuv_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Mei fasuna namina siba ma fifaninaa hia panii ei oma'ama'aa humuu bobo'aia ba ronei fanima'aia hawina na hodipedugaa ei mugoo po'i. ");
INSERT INTO wuv_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","“Mei Amau pafea iwe bigi'ia ale'ei a'a hememea hamu'ou nabaa lomi hamona futoaa ei hafelo'aa ei lofuu hamu'ou laloo naranaraa hamu'ou.” ");
INSERT INTO wuv_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","I'a waredigaa ei manumanu ei Jesus, ina asi'adi'ininaa Galilee ma aununaa malalaa Judea, fipepei Jordan. ");
INSERT INTO wuv_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Hefi'a baua gupuu rama'a, rona nenegia ma na farawaninaa ei funuaa ro'ou yei. ");
INSERT INTO wuv_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Hefi'a Pharisee, rona nomai a'ana ba ro'aa mania. Rona i'igai, “Na wanewane a'a fei law ba nemea wawane i fi'alagii a'a mei harona ma lomi rawani'aa pa'afina?” ");
INSERT INTO wuv_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Ina ware, “Haa, lomi hamona igoia ba fama'a, mei Famamaraia na bigi'aa lagua ‘wawane ma pifine,’ ");
INSERT INTO wuv_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","ma ware ba, ‘Sifei, fei pa'afina ba nemea wawane nei di'ininaa amana ma inana ma gutafipui a'a mei harona ma laguwe pigioinaa hepalo’? ");
INSERT INTO wuv_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Si'ei, a'a ba lagua fai helagui, uaa hemea. Si'ei, tamanu na fihupu'inia mei Haidaa, nemea nei'aa alagia.” ");
INSERT INTO wuv_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Rona i'igai, “Nabaa fa'ua, tani i ware Moses ba nemea nei fani hepalo ne'iaa fi'alagia ma alofatalainia?” ");
INSERT INTO wuv_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Jesus na ware, “Moses na ugainia ba hamo'aa di'ininaa ei haroo hamu'ou hamatee namina waiwai tabaa hamu'ou. Ma'uaa do'ofama'a abaa ale'ei. ");
INSERT INTO wuv_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","A warefanaa hamu'ou ba hini i di'ininaa mei harona ba i lalaidiai ma mei harona lomi na fiharoharoipa'ai, mei rama'a mei, na bigi'aa fei fiharoharoipa'aia. ");
INSERT INTO wuv_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Ei otalai nenerana, rona ware, “Nabaa ale'ei a'a hemea wawane ma mei harona, ina rawani ba lomi lalalaia.” ");
INSERT INTO wuv_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Jesus na ware, “Abaa minaa ei rama'a, ro'aa tonaa fei warea fei, uniaa ei una fanaa ro'ou. ");
INSERT INTO wuv_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Uaa hefi'a, lomi ba ro'aa lalai, uaa rona waninimai ale'ei ma hefi'adiai, ei rama'a na morosiminaa wawanei ro'ou ba ale'ei ma hefi'adiai, rona ware ua ba lomi ro'aa lalai uaa rona naranara'uaiaa fei haparaia pafea. Mei ba na rawani a'ana, inei tonia.” ");
INSERT INTO wuv_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","I dii, rona duginamii a'a Jesus ei pusu'o baduu ba nei augaa panina pafoo ro'odu ma lafulafunaa ro'ou. Ma'uaa ei otalai nenerana, rona pauninaa ei rona dugamii ro'ou. ");
INSERT INTO wuv_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Jesus na ware, “Fanoramiaa ei baduu pusu'o i a'au ma apuna lawaraa ro'ou, uaa fei haparaia pafea, manumanuu ei ale'eni eni.” ");
INSERT INTO wuv_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","I'a audigaa guei panina pafoo ro'ou, ina di'ininaa fei gufu fei. ");
INSERT INTO wuv_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Ma hemea na nomai a'a Jesus ma na i'igai, “Feroia, a bigi'aa tamanu rawani'a manumanu ba a tonaa fei harenua lomi i pedutoo?” ");
INSERT INTO wuv_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Na ware Jesus, “Tani o i'iginau ba tamanu na rawani? Unaa Hemea ua na rawani. Nabaa o nunumiai ba o'aa wadu'aitonaa harenuamu, onei neneraa ei law mei Haidaa.” ");
INSERT INTO wuv_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Ina i'igai, “Tamanu ei?” Jesus na ware, “‘Apuna fo'afama'e, apuna fiharoharoipa'ai, apuna fafanao, apuna warefasifi, ");
INSERT INTO wuv_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","ma'auaa amamu ma inamu,’ ma ‘haguaa mei gufumu ale'ei ona'o haguio.’” ");
INSERT INTO wuv_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Mei baubara na ware, “Minaa ena, unamina nenegidigia. Tamanudiai fei lomi una bigi'ia?” ");
INSERT INTO wuv_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Jesus na ware, “Nabaa ona nunuminia ba o'aminaa fafa'arai, wi aloaa ena manumanumu ma fanaa ei lomi manumanuu ro'ou ma owe pa'i manumanumu i pafea. Nenee fei, mi nenerau.” ");
INSERT INTO wuv_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","I'a guainaa fei mei baubara, ina aunufaloloa'ilao, uaa na pa'i watauda manumanuna. ");
INSERT INTO wuv_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","I dii, Jesus na warenaa a'a ei otalai nenerana, “A warefa'uai a'a hamu'ou ba namina waiwai ba nemea na pa'i watauda mugoo po'ina i wadu'ainaa fei haparaia pafea. ");
INSERT INTO wuv_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","A warediai ba na madutainaa fei camel ba i wadu'ainaa fei ma'ahi'u laraa fei ba nemea na pa'i watauda mugoo po'ina i wadu'ainaa fei haparaiaa mei Haidaa.” ");
INSERT INTO wuv_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Ro'aa guainaa fei ei otalai nenerana, ronamina hawainaa poaa ro'ou ma i'igai, “Nabaa ale'ei, hini ba i tela?” ");
INSERT INTO wuv_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Jesus na fanunulao a'a ro'ou ma ware, “A'a rama'a lomi na ma'atalaa, ma'uaa a'a mei Haidaa minaa ei manumanu na ma'atalaa.” ");
INSERT INTO wuv_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Peter na warenaa a'ana, “Hai'ouna di'ininaa minaa ei manumanuu hai'ou ba hai'ou nenegio! Si'ei, hai'ou'aa tonaa tamanu?” ");
INSERT INTO wuv_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Jesus na warenaa a'a ro'ou, “A warefa'uai a'a hamu'ou ba a'a fei au ba i manufaudiai minaa ei manumanu, ena na guta fininaa ei hawerana mei Na'uu Rama'a pafoo gutanaa mei hapara, hamu'ou ena hamona nenerau, ana hamowe guta pafoo ei hefua ma guapalo gutanaa ei hapara ma dududuaa ei hefua ma guapalo pai Israel. ");
INSERT INTO wuv_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Ma hini ei rona di'ininaa ei humu, o lofu, o agi, o ama ma ina, o na'u, o pe'ihape uaa yau, rowe to ale'ei hefa pu'udiai ma ropowe tonaa fei harenua lomi i pedutoo. ");
INSERT INTO wuv_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Ma'uaa watauda ei rona nomai nene, rowe dinaa ma'a ma ei ro nomai ma'a ro dinaa nene. ");
INSERT INTO wuv_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","“Fei haparaia pafea, tawi'ana ale'ei mei amaa fei pe'ihape, mei na asi'aa mafufuo ba i pono rama'a ba ronei bigi wagii fei pe'ihapena wine. ");
INSERT INTO wuv_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Ina ware ba pono'aa ro'ou a'a heai arewaa, hepalo denarius ma alonaa ro'ou pe'ihapena. ");
INSERT INTO wuv_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","“Nopa'aloo faimpalo ido'o, ina aunu ma fanunupa'aa hefi'adiai rona u i humuu alo'alo, lomi bigi'aa ro'ou. ");
INSERT INTO wuv_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Ina warenaa a'a ro'ou, ‘Ana hamoneiree bigi wagii fei pe'ihapeu ma awe fawanewaneaa ei pono'aa hamu'ou.’ ");
INSERT INTO wuv_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Si'ei, rona dii. “Ina aunudiai haloaina ma fei fa'oduaiaa ido'o ma bigi'ia ana ale'ei. ");
INSERT INTO wuv_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","I nopa'aloo haipani ido'o, na aunu ma fanunupa'aa hefi'adiai, ana ro'ei ufalarai ua. Ina i'iginaa ro'ou, ‘Tani hamu'ou ufalarai ua yeni minaa feni arewaa feni ma lomi hamona bigi'aa hepalo manumanu?’ ");
INSERT INTO wuv_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","“Rona ware, ‘Hamatee lomi hemea na pono'aa hai'ou.’ “Ina warenaa a'a ro'ou, ‘Ana hamoneiree bigi wagii fei pe'ihapeu.’ ");
INSERT INTO wuv_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","“I nororolao, mei amaa fei pe'ihape na warenaa a'a mei paniaa panina, ‘Apainamii ena bigibigi'a ma fani pono'aa ro'ou. Do'o pono'aa ei we noramiaa ro'ou ma nene, ei rawarawa.’ ");
INSERT INTO wuv_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","“Ei bigibigi'a rona'aa bigi a'a fei haipani ido'o, hememea ro'ou na tonaa hepalo denarius. ");
INSERT INTO wuv_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Si'ei, ei rawarawa bigi'a, rona nara ba i bauanadiai pono'aa ro'ou. Ma'uaa hememea ro'ou, ana na tonaa hepalo ua denarius. ");
INSERT INTO wuv_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Ro'aa todigia, rona bababau'u a'a mei amaa fei pe'ihape. ");
INSERT INTO wuv_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","Rona ware, “E'ei rama'a we fabigi'uamu nene, lomi rona bigifamadii ma pono'aa ro'ou, fimina'ei ale'ei hai'ou ma hai'ounamina bigifatemu haroo fei baua halo.’ ");
INSERT INTO wuv_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","“Ma'uaa ina warefanaa hemea ro'ou ba, ‘Otafi, lomi una bigifatata a'amu. Haa, lomi ba onado'o uga ba pono'amu, hepalo denarius? ");
INSERT INTO wuv_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Tonaa fei pono'amu ma aunu. Una nunuminia ba pono'aa mei a'apoo dugamiau, i fimina'ei a'a fei pono'amu. ");
INSERT INTO wuv_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Haa, lomi na wanewane ba una bigi'aa tamanu nunumiau a'a ei mugoo po'iu? O, yoi, ona punepune hamatee yau, una baubaurawani?’ ");
INSERT INTO wuv_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","“Si'ei ba mei i nomai nene, iwe dinaa ma'a ma mei i nomai ma'a i dinaa nene.” ");
INSERT INTO wuv_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Ei fitalaidinaa Jerusalem, Jesus na dugitata'ainaa ei hefua ma helagui otalai nenerana ma warenaa a'a ro'ou, ");
INSERT INTO wuv_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“O'ou, oa dinaa Jerusalem ma mei Na'uu Rama'a, ro'aa aloia panii ei famamoaa humuu mei Haidaa mawe ei feroiaa law. Rowe ware ba inei ma'e ");
INSERT INTO wuv_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","ma rowe fifaninia panii ei Gentile ba ro'aa hapepeinia, babuinia ma fatawaia. Ma wagii fei fa'oduaiaa arewaa iwe asi'atodiai harenuana!” ");
INSERT INTO wuv_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","I dii, mei inaa laguei na'uu Zebedee na nofipuimai a'a ei na'una, dinamii a'a Jesus, fa'unaa du'una ma i'iginia hepalo nunumiana. ");
INSERT INTO wuv_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Ma Jesus na i'iginia, “Tamanu fei nunumiamu?” Ina ware, “Uga ba hemea lagueni na'uu i guta pepei ma'aumu ma hemea mauwimu wagii fei haparaiamu.” ");
INSERT INTO wuv_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Jesus na warefanaa ro'ou, “Lomi hamona aida ba tamanu hamo'ei i'iginia. Hamo'aa hunupa'i a'a fei bara ba a hunumia?” Rona ware ba, “Hai'ou hunupa'i.” ");
INSERT INTO wuv_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Jesus na warenaa a'a ro'ou, “Pa'aa fa'ua ba hamo'aa hunu a'a fei barau ma'uaa, fei ba hini ba i guta i pepei ma'auu, o mauwiu, abaa yau mei ba a ugainia. Ei gutana ei, pagi'augaa mei Amau, gutanaa ei di rafeiana.” ");
INSERT INTO wuv_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Ro'aa guainaa fei ei hefua, ronamina siba a'a laguei filofui. ");
INSERT INTO wuv_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Jesus na harofipuinaa ro'ou ma ware, “Hamona aida ba ei bauaniaa ei Gentile, rona fasuinaa ana ro'ou mawe ei paniaa panii ro'ou, rona pa'i foraforaa ro'ou a'a ei rama'a. ");
INSERT INTO wuv_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Abaa ale'ei a'a hamu'ou. Agia, hini ba hia bauana a'a hamu'ou, nei ale'ei nafii hamu'ou ");
INSERT INTO wuv_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","ma hini ba i rawarawa nei ale'ei humuwaa hamu'ou— ");
INSERT INTO wuv_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","ana ale'ei ba mei Na'uu Rama'a, abaa ei i nomai ba ei rama'a, ronei nafii a'ana ma'uaa, ba i nafii a'a ro'ou ma ba i fanaa fei harenuana ale'ei pono'aa watauda.” ");
INSERT INTO wuv_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Jesus ma ei otalai nenerana, ba ro'aa di'ininaa Jericho, hefaa baua gupuu rama'a, rona nenegia. ");
INSERT INTO wuv_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Helagui pudawerai, laguna guta i papaa fei tala ma lagu'aa guainia ba Jesus fi falogilao nana'aa lagua, laguna haroharo, “Mena Fasu, mena Na'uu David, faloloa'inaa haigua!” ");
INSERT INTO wuv_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Fei gupuu rama'a na warefasiba a'a lagua ba lagunei babanini ma'uaa, laguna haropararai apoidiai, “Mena Fasu, mena Na'uu David, faloloa'inaa haigua!” ");
INSERT INTO wuv_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Jesus na u ma na haro'i'iginaa lagua, “Tamanu nunumiaa hamugua ba a bigi'ia a'a hamugua?” ");
INSERT INTO wuv_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Laguna ware, “Mena Fasu, ba haigu'aa fanunupa'i.” ");
INSERT INTO wuv_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Jesus na faloloa'inaa lagua ma na idoaa pudaa lagua. Ana ei ua, laguna fanunupa'i ma nenegia. ");
INSERT INTO wuv_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Ro'aa nofarafi'imai Jerusalem ma nopa'amii Bethphage pafoo Maugeni Olive, Jesus na aloaa helagui ei otalai nenerana ");
INSERT INTO wuv_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","ma inado'o warefanaa lagua, “Dinaa a'a fei gufu i ma'aa hamugua ma hamuwe fanunupa'aa hepalo donkey na roro'ai yena ma fena na'una, papana. Alaforamiaa lagua a'au. ");
INSERT INTO wuv_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Nabaa nemea i wareaa hepalo manumanu a'a hamugua, warefania ba mei Fasu na nunuminaa gueini donkey ma iwe alodinamai.” ");
INSERT INTO wuv_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Fei manumanu fei, fi fafa'uainaa tamanu nadii wareia mei mamama'a: ");
INSERT INTO wuv_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Warenaa a'a mei Na'uu Zion, Baduu Pifine, ‘Fanunu, mei haparamu fi nomai a'amu, ina nowiwidimai pafoo hepalo donkey, pafoo hepalo na'uu manulelele, hepalo na'uu donkey.’” ");
INSERT INTO wuv_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Laguna aunu laguei otalai nenerana ma bigi'ia ale'ei na wareia a'a lagua Jesus. ");
INSERT INTO wuv_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Laguna foramii fei donkey ma fei na'una, augaa ei hawaa uguu lagua pafoo guapaloei ma Jesus na guta pafoo guapaloei. ");
INSERT INTO wuv_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Hepalo baua gupuu rama'a na hafeninaa ei hawaa uguu ro'ou i ma'aa tala ma hefi'a, rona balainaa ei raraa haihai ma hafeninia i ma'aa tala. ");
INSERT INTO wuv_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Ei gupuu rama'a, ei rona nolao i ma'ana ma ei rona talailao nene, rona haroharo, “Hosanna a'a mei Na'uu David!” “Ina pa'i hawegiana mei na nomai a'a fei haraa mei Fasu!” “Hosanna i dinaa pafea!” ");
INSERT INTO wuv_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","I'a wadu'ainaa Jerusalem Jesus, minaa ei rama'aa gufu, rona asi'aa ma i'igai ba, “Hini meni?” ");
INSERT INTO wuv_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Ei gupuu rama'a, rona ware ba, “Meni rama'a meni, Jesus, mei mamama'a, noramiana Nazareth yei Galilee.” ");
INSERT INTO wuv_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Jesus na wadu'ainaa malalaa fei humuu mei Haidaa ma na tetefa'asi'anaa minaa ei ro'ei ponopono ma alo'alo yei. Ina haupeduaa ei tawaa ei ro'ei filoginaa ei mugoo po'i mawe ei gutanaa ei ro'ei aloaa ei pune. ");
INSERT INTO wuv_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Ina ware, “Rona ne'inia ba, ‘Rowe ware ba fei humuu, hepalo humuu lafulafu,’ ma'uaa, hamona bigi'ia ale'ei humuu fafanao.’” ");
INSERT INTO wuv_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Ei pudawerai mawe ei afetoo, rona nomai a'ana i humuu mei Haidaa ma ina farawaninaa ro'ou. ");
INSERT INTO wuv_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Ma'uaa, rona siba ei famamoaa humuu mei Haidaa mawe ei feroiaa law ei ro'aa fanunupa'aa ei rawani'a bigi'ana ma ale'ei ba ei baduu, rona haroharo laloo fei humuu mei Haidaa ba, “Hosanna i dinaa a'a mei Na'uu David.” ");
INSERT INTO wuv_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Rona i'iginia, “Ona guaipa'ia ba tamanu ei wareaa ei baduu?” Jesus na ware ba, “Hi'i. Haa, lomi hamona igoia, “‘A'a fei haba'umuu ei baua baduu mawe ei pusu'o baduu, ona nunuminia ba ronei uduginio’?” ");
INSERT INTO wuv_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Ma ina asi'aa a'a ro'ou ma di'ininaa fei gufu fei ma aununaa Bethany ma na ma'igu yei. ");
INSERT INTO wuv_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","I nomafufuoilao, fi hadiwe'inaa fei baua gufu ma na bao. ");
INSERT INTO wuv_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Ina fanunupa'aa hepalo haihai figi i papaa fei tala ma na nolao wagina ma lomi na fanunupa'aa hepalo fuana unaa ei rauna. Ma na warenaa a'ana, “Fai lomi ba o fuadiai!” Ana ei ua, fei haihai na hole. ");
INSERT INTO wuv_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Ro'aa fanunuaa fei ei otalai nenerana, ronamina ba'arofo ma i'igai, “Tani ei ba fei haihai figi namina holebatafa?” ");
INSERT INTO wuv_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Jesus na ware, “A warefa'uai a'a hamu'ou ba nabaa na we'i naranaraa hamu'ou ma lomi hamona hamamagua, a'a ba una fei ba hamo'aa bigi'ia a'a fei haihai figi, ma'uaa ana hamowe warenaa a'a feni maugeni ba, ‘Wi siminio agi,’ ma iwe guainaa hamu'ou. ");
INSERT INTO wuv_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Nabaa na we'i naranaraa hamu'ou, hamowe tonaa tamanu hamona i'iginia a'a ei lafulafuaa hamu'ou.” ");
INSERT INTO wuv_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Jesus na wadu'ainaa malalaa fei humuu mei Haidaa ma fi feroi, ei famamoaa humuu mei Haidaa mawe ei bauaniaa gufu, rona nomai a'ana. Rona i'igai, “Tonamu hitani fei forafora ba o'aa bigi'aa eni manumanu eni? Ma hini na ugainio?” ");
INSERT INTO wuv_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Jesus na ware, “Yau ana a i'iginaa hamu'ou hepalo i'igaia. Na'aa hamo'aa warefanau, a warefanaa hamu'ou ba tonau hitani fei forafora ba a bigi'aa eni manumanu eni. ");
INSERT INTO wuv_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Fei pudugufaiaa John—noramiana hitani? Noramiana pafea, o a'a rama'a?” Rona fiwarewareinia dupuaa ro'ou ma ware, “Nabaa o ware ba, ‘Noramiana pafea,’ iwe i'igai, ‘Nabaa ale'ei, tani lomi hamona nara ba fa'ua wareana?’ ");
INSERT INTO wuv_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Ma'uaa, nabaa o ware ba, ‘Noramiana a'a rama'a’—o'ouna ma'auaa ei rama'a, uaa minaa ro'ou, rona nara ba John, hemea mamama'a.” ");
INSERT INTO wuv_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Si'ei, rona warenaa a'a Jesus, “Lomi hai'ouna aida.” Ma ina ware, “Ana lomi ba a warefanaa hamu'ou ba tonau hitani fei forafora ba a bigi'aa eni manumanu eni.” ");
INSERT INTO wuv_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","“Tamanu naraa hamu'ou? Na pa'i hemea rama'a na pa'i helagui na'una. Ina dinaa a'a mei uma'ua ma na ware, ‘Ona'uu, re bigi i pe'ihape wagieni.’ ");
INSERT INTO wuv_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","“Ina ware, ‘Lomi ba a bigi,’ ma'uaa nenee fei, na filoginaa naranarana ma na aunu. ");
INSERT INTO wuv_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","“I dii, mei ama na dinaa a'a mei umugi ma ana ale'ei wareana a'ana. Ina ware, ‘Awe dii,’ ma'uaa lomi na dii. ");
INSERT INTO wuv_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","“Amaia lagua na bigi'aa nunumiaa amana?” Rona ware ba, “Mei uma'ua.” Jesus na warenaa a'a ro'ou, “A warefa'uai a'a hamu'ou ba ei otonaa mugoo po'ii gavaman mawe ei pifinee tala, ro'ei wadu'ainaa fei haparaiaa mei Haidaa, i ma'aa hamu'ou. ");
INSERT INTO wuv_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Uaa John na nomai a'a hamu'ou ba i fama'aa hamu'ou fei talaa wanewanea ma lomi hamona guainaa wareana ma'uaa, ei otonaa mugoo po'ii gavaman mawe ei pifinee tala, rona guainia. Ma hamo'aa fanunudigaa fei, ana lomi hamona filoginaa ei naranaraa hamu'ou ma guainia. ");
INSERT INTO wuv_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","“Guaidiai hepalo warea hanunu: Na pa'i hemea na faroaa ei wine laloo pe'ihapena. Ina nonoinia, agifaa fei huapuu wine ma na fa'ugaa fei palee ei guta'oma'aa fei pe'ihapena. Si'ei, nadii fanaa hefi'a ba ronei oma'aa fei pe'ihapena ma na aunu ba i tatalai gufu raua. ");
INSERT INTO wuv_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","I'a norafi'inaloo fei au hufu'a, ina aloaa ei nafina ba ronei dinaa a'a ei ro'aa oma'aa fei pe'ihape ma re tomai ei alagi'augaa ro'ou hanana fua. ");
INSERT INTO wuv_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","“Ei oma'ama'aa fei pe'ihapena rona panarofaa ei nafina; babuinaa hemea, fo'afama'eaa hemea ma nafa'aa mei fa'o'oduaiaa ro'ou a'a ei mugoo. ");
INSERT INTO wuv_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Si'ei, na alodinaa hefi'adiai nafina a'a ro'ou, rona wataudadiai a'a ei rawarawa ma ei oma'ama'aa fei pe'ihapena rona bigi'ia a'a ro'ou ana ale'ei bigi'aa ro'ou fama'a. ");
INSERT INTO wuv_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Nenee minaa ei, nawe aloaloo mei na'una a'a ro'ou. Ma ina ware, ‘Ro'awe ma'auaa mei na'uu.’ ");
INSERT INTO wuv_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","“Ma'uaa, ei ro'aa fanunupa'aa mei na'una ei oma'ama'a, rona fiwarewarei ana ro'ou, ‘Simeni, meni ba i tonaa feni pe'ihapee amana. O dii, o fo'afama'eia ma tonaa fei pe'ihapena.’ ");
INSERT INTO wuv_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","I dii, rona panarofia, fa'asi'ania a'a fei pe'ihape ma fo'afama'eia. ");
INSERT INTO wuv_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","“Nabaa i nomai mei amaa fei pe'ihape, i bigi'aa tamanu a'a ei oma'ama'aa fei pe'ihapena?” ");
INSERT INTO wuv_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Rona ware, “I pa'aa fanima'aa ei wawa'ai poa, tonaa fei pe'ihapena ma fanaa hefi'adiai oma'ama'aa, ena rowe fania hefi'a ei fuaa fei pe'ihapena a'a fei au hufu'a.” ");
INSERT INTO wuv_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Na ware a'a ro'ou Jesus, “Haa, lomi hamona igoia laloo fei Bu'u Apuna: “‘Fei mugoo, fei lomi rona nunuminia ei fadufadua, i powe oanaa fasu'ufufugoi. Mei Fasu na bigi'aa feni, ma namina fafanunufarawani pudaa o'ou’? ");
INSERT INTO wuv_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","“A warefanaa hamu'ou ba fei haparaiaa mei Haidaa i tonia a'a hamu'ou ma fanaa ei rama'a, ei rowe fafuafarawaninia. ");
INSERT INTO wuv_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Hini i pasinaa pafoo feni mugoo i matala, ma'uaa hini i pasi'onia fei mugoo i marafita.” ");
INSERT INTO wuv_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Ro'aa guainaa ei warehanunuiaa Jesus ei famamoaa humuu mei Haidaa ma ei Pharisee, rona apa'ia ba ifi warewareaa ro'ou. ");
INSERT INTO wuv_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Ro'ei labarainaa hepalo tala ba ro'aa panarobobo'inia, ma'uaa rona ma'au a'a fei gupuu rama'a, uaa ei rama'a rona nara ba hia mamama'a. ");
INSERT INTO wuv_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Jesus na warehanunuidiai a'a ro'ou: ");
INSERT INTO wuv_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“Fei haparaia pafea, tawi'ana ale'ei hemea hapara, mei na pagipagiaa fei hananaa lalaiaa mei na'una, baduu wawane. ");
INSERT INTO wuv_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Ina aloaa ei nafina ba ronei dinaa a'a ei rama'a, ei na ware'audii a'a ro'ou ba ronei nomai a'a fei hananaa, ma'uaa rona ware ba lomi ro nomai. ");
INSERT INTO wuv_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","“I dii, ina alodinaa hefi'a ei nafina ma ware, ‘Ware a'a ei una ware'audii a'a ro'ou ba una pagi'audigaa fei finei fafi: ei hapeu manulelele ma ei hapeu bauana buduma'ao, una hawidigaa ro'ou ma minaa ei manumanu namina udedii. Nomai a'a fei hananaa.’ ");
INSERT INTO wuv_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","“Ma'uaa lomi rona falanaa huoo ro'ou ma rona aunu ua—hemea na dinaa pe'ihapena, hemeadiai a'a fei bigi'aa mugoo po'ina. ");
INSERT INTO wuv_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Ma ei dufu, rona patarofaa ei nafii mei hapara ma haperararaiaa ro'ou ma fo'afama'eaa ro'ou. ");
INSERT INTO wuv_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Ma mei hapara na sibafafelo. Ina aloaa ei rama'aa fo'aa ma ronaree fo'afama'epedugaa ei rama'a, ei ro'aa fo'afama'eaa ei nafina ma fagu'aa ei gufuu ro'ou. ");
INSERT INTO wuv_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","“Si'ei na ware a'a ei nafina, ‘Fei hananaa lalaia na udedii ma'uaa, ei una waredii a'a ro'ou ba ronei nomai, lomi na rawani ba ro'aa nomai. ");
INSERT INTO wuv_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Aununaa ma'aa tala ma ware a'a hini e'ena hamona bapa'aa ro'ou ba ronei nomai a'a feni hananaa.’ ");
INSERT INTO wuv_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Si'ei, ei nafi, rona aununaa ma'aa tala ma dugamiaa minaa ei bapa'aa ro'ou, ei rawani'a mawe ei hafelo'a ma fei humuu hananaa namina horo. ");
INSERT INTO wuv_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","“Ma'uaa i'a wadu'aimai mei hapara ba imii ma'a ei rama'aa hananaa, na fanunupa'aa hemea lomi na rafeaa fei susuu lalai. ");
INSERT INTO wuv_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Ina i'igai, ‘Otafi, ona wadu'aibatanaimai yeni ma lomi susumu susuu lalaia?’ Lomi na wareware mei rama'a. ");
INSERT INTO wuv_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","“Si'ei mei hapara na ware a'a ei paniaa panina, ‘Faroro'inaa panina ma pinena ma suminia ano laloo fei roromaa, fei na pa'i ai'aiga ma fi'u'uiaa difo.’ ");
INSERT INTO wuv_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","“Una lala'aa watauda ma'uaa, ma'ida ua rafeiau.” ");
INSERT INTO wuv_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Ma ei Pharisee, rona aununaranara ba batanai rona sifi'ia ba inei warefatata. ");
INSERT INTO wuv_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Rona alonaa i a'ana ei otalai neneraa ro'ou mawe ei maroaa Herod. Ma rona ware, “Mena feroia, hai'ouna aida ba yoi hemea wanewanea rama'a ma ona'o feroinaa fei maumau mei Haidaa, fei na neneraa tamanu na wanewane. Lomi ona falanaa huomu ei wareaa rama'a, uaa lomi ona nara ba ro'ou hini. ");
INSERT INTO wuv_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Si'ei ba onei warefanaa hai'ou fei naranaramu. Ina wanewane ba o fani mugoo po'i a'a Caesar, o lomi?” ");
INSERT INTO wuv_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Ma'uaa Jesus na aidadii fei hafelo'a ba ro'aa bigi'ia ma na ware, “Hamu'ou ena ware'oni, tamanu pa'afina ba hamo'aa sifi'au ba unei warefatata? ");
INSERT INTO wuv_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Fama'au fei mugoo po'i, fei rona'o fanaa gavaman.” Rona tonamai a'ana hepalo denarius, ");
INSERT INTO wuv_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","ma ina i'iginaa ro'ou, “Hanunuu hini feni? Ma ne'iaa hini?” ");
INSERT INTO wuv_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Rona ware ba, “Caesar.” Ma na warefanaa ro'ou, “Fanaa Caesar tamanu ei manumanuu Caesar ma fanaa mei Haidaa tamanu ei manumanuu mei Haidaa.” ");
INSERT INTO wuv_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Ro'aa guainaa fei, ronamina ba'arofo. Si'ei, rona di'ininia ma aunu. ");
INSERT INTO wuv_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Ana fei arewaa fei, ei Sadducee, ei rona ware ba lomi asi'ana, rona nomai a'ana a'a hepalo i'igaia. ");
INSERT INTO wuv_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","Rona ware, “Mena feroia, Moses nadii warefanaa o'ou ba nabaa nemea wawane na ma'e ma lomi na'una, mei lofuna nei lalainaa mei harona ba nei pa'i na'uu mei lofuna, mei na ma'e. ");
INSERT INTO wuv_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Ma nabaa na pa'i oloromeai filofui a'a o'ou ma mei uma'ua na lalai ma na ma'e ma si'ei ba lomi na'una, mei harona na lalainaa mei umugina. ");
INSERT INTO wuv_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Ana ale'ei a'a mei umugina ma mei umugii mei umugina, mina ale'ei nopa'aloo mei fa'oloromeiaiaa ro'ou. ");
INSERT INTO wuv_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","I dii, nawe ma'e mei pifine. ");
INSERT INTO wuv_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Si'ei, wagii fei au asi'ana, haroo hini, mei pifine mei, uaa minaa ro'ou, rona lalainia?” ");
INSERT INTO wuv_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Jesus na ware, “Hamona tata, uaa lomi hamona aida fei Bu'u Apuna, o fei faufau mei Haidaa. ");
INSERT INTO wuv_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Wagii fei au asi'anaa ei ma'ea, lomi lalaia, o falalaia; ei rama'a, ro ale'ei ei alo'alo pafea. ");
INSERT INTO wuv_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Ma'uaa wagii fei asi'anaa ei ma'ea, lomi hamona igoaa tamanu mei Haidaa na wareia a'a hamu'ou ba, ");
INSERT INTO wuv_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","‘Yau, mei Haidaniaa Abraham, mei Haidaniaa Isaac ma mei Haidaniaa Jacob’? Hia, abaa Haidaniaa ei ma'ea, uaa Haidaniaa ei rona pa'i fawewenii ro'ou.” ");
INSERT INTO wuv_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Ro'aa guainaa fei ei gupuu rama'a, ronamina maduofo a'a ei feroiana. ");
INSERT INTO wuv_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Ro'aa guainia ba Jesus na fababaniniaa ei Sadducee, ei Pharisee, rona figupui. ");
INSERT INTO wuv_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Hemea ro'ou, hemea napa'aa apa'aa fei law na mania a'a feni i'igaia feni: ");
INSERT INTO wuv_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","“Mena feroia, tamanu fei wareaa mei Haidaa laloo fei Law namina mua?” ");
INSERT INTO wuv_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Jesus na ware, “‘Haguaa mei Fasu, mei Haidaniamu fininaa minaa ei naranaramu ma minaa ei faufaumu ma minaa ei apa'amu.’ ");
INSERT INTO wuv_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Sifei, fei rawarawa wareaa mei Haidaa, fei namina mua. ");
INSERT INTO wuv_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Ma fei faguapaloana, ana ale'ei: ‘Haguaa mei gufumu ana ale'ei ona haguio.’ ");
INSERT INTO wuv_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Minaa ei Law ma ei Mamama'a, rona urofaa guapaloei wareaa mei Haidaa.” ");
INSERT INTO wuv_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Ro'aa gutafipui ei Pharisee, Jesus na i'iginaa ro'ou, ");
INSERT INTO wuv_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“Tamanu ei naraa hamu'ou a'a mei Christ? Hia, na'uu hini?” Rona ware ba, “Hia na'uu David.” ");
INSERT INTO wuv_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Ina warefanaa ro'ou, “Nabaa ale'ei, tani ei ba David, wagii fei faufau fei Spiriti na roroinia ‘Fasu’? Uaa ina ware, ");
INSERT INTO wuv_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","“‘Mei Fasu na warenaa a'a mei Fasuu: “Guta i pepei ma'auu nopa'aloo fei una aunaa ei bidibidii unumu haroo pinemu.” ’ ");
INSERT INTO wuv_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Nabaa David na ware ba hia, ‘Fasu,’ batanai ei ba hia na'una?” ");
INSERT INTO wuv_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Lomi hemea na wareaa hepalo manumanu wagii fei ma a'a fei arewaa fei ma nolao, lomi hemea ba na i'igidinia hepalodiai i'igaia. ");
INSERT INTO wuv_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","I dii, Jesus na warefanaa ei gupuu rama'a mawe ei otalai nenerana: ");
INSERT INTO wuv_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","“Ei feroiaa law ma ei Pharisee, rona guta a'a fei gutanaa Moses. ");
INSERT INTO wuv_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Si'ei, hamonei guainaa ro'ou ma bigi'aa ei rona ware ba hamonei bigi'ia. Ma'uaa hamonei'aa bigi'aa tamanu rona bigi'ia, uaa lomi rona neneraa ei rona u'ugia. ");
INSERT INTO wuv_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Rona roro'inaa ei awataa manumanu ma augia foreforee ei rama'a ma'uaa, lomi ba rona fani pani ba ro'aa poro'ia. ");
INSERT INTO wuv_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","“Minaa ei manumanu rona bigi'ia ba ronei ma'aia ei rama'a: Rona fadufabauaninaa ei bao ei ne'iaa Bu'u Apuna ro'ou ma famalaiaa ei wao supuu lawalawaa ro'ou; ");
INSERT INTO wuv_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","ronamina nunuminaa ei gutanaa ei baua rama'a a'a ei hananaa ma ei pa'aa rawani'a gutana i laloo ei synagogue; ");
INSERT INTO wuv_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","ronamina nunuminia ba ei rama'a, ronei famafufuoinaa ro'ou malalaa ei humuu alo'alo ma ba ei rama'a nei harofaa ro'ou, ‘Rabbi.’ ");
INSERT INTO wuv_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","“Ma'uaa abawe haronaa hamu'ou ‘Rabbi,’ uaa hamona pa'i hemea ua Fasu ma minaa hamu'ou, filofui. ");
INSERT INTO wuv_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Ma apuna harofaa nemea yeni malagufu ‘Ama’, uaa hamona pa'i hemea ua Ama ma hia, i pafea. ");
INSERT INTO wuv_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Ana abaa haronaa hamu'ou ‘feroia,’ uaa hamona pa'i hemea ua ‘Feroia’, mei Christ. ");
INSERT INTO wuv_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Mei na pafeai a'a hamu'ou, hia i ale'ei nafii hamu'ou. ");
INSERT INTO wuv_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Uaa hini na poronaa hia pafea, i oanaa pu ma hini i fafafaunaa hia pu, iwe pafeai. ");
INSERT INTO wuv_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","“Hamona fagiana, hamu'ou ena feroiaa law mawe hamu'ou ena Pharisee, gueina ware'oni! Hamona'u fare'aa fei gigei fei haparaia pafea i pudaa ei rama'a. Lomi ba hamo'aa wadu'ai ma ana hamona lawaraa fei gigei a'a ei ba ro'aa wadu'ai. ");
INSERT INTO wuv_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","“Hamona fagiana, hamu'ou ena feroiaa law mawe hamu'ou ena Pharisee, gueina ware'oni! Hamona tatalai yeni malagufu ma pafoo agi ba hamo'aa falosuinaa nemea ma i'a neneraa hamu'ou, hamona fahafelodinia ale'ei na'uu fei gufu hafelo ma imina hafelo'apoidiai laraa hamu'ou. ");
INSERT INTO wuv_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","“Hamona fagiana, hamu'ou ena pudawerai talaiduga! Hamona'u ware ba, ‘Nabaa nemea i fa'unainaa fei humuu mei Haidaa, lomi hanuna; ma'uaa hini na fa'unainaa fei mugoo po'ii humuu mei Haidaa na roro'ai wagii fei fa'unaiana.’ ");
INSERT INTO wuv_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Hamu'ou ena poapoa pudawerai! Afaia guapaloeni na pa'i hanuna, fei mugoo po'ii laloo humuu mei Haidaa, o fei humuna, fei na fa'apunainaa fei mugoo po'i lalona? ");
INSERT INTO wuv_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Ana hamona'u ware ba, ‘Nabaa nemea i fa'unainaa fei tawahafi na apunai laloo fei humuu mei Haidaa, lomi hanuna; ma'uaa, hini i fa'unainaa fei fanaa na ude pafona, ina roro'ai wagii fei fa'unaiana.’ ");
INSERT INTO wuv_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Hamu'ou ena pudawerai! Afaia guapaloeni na pa'i hanuna, fei fana, o fei tawahafi na apunai, fei na fa'apunainaa fei fana pafona? ");
INSERT INTO wuv_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Si'ei, hini i fa'unainaa fei tawahafi na apunai, ana na fa'unainaa minaa ei pafona. ");
INSERT INTO wuv_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Ma hini i fa'unainaa fei humuu mei Haidaa ana na fa'unainaa mei na oa lalona. ");
INSERT INTO wuv_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Ma hini i fa'unainaa fei gufuu pafea na fa'unainaa fei gutanaa mei Haidaa mawe mei na guta pafona. ");
INSERT INTO wuv_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","“Hamona fagiana, hamu'ou ena feroiaa law mawe hamu'ou ena Pharisee, gueina ware'oni! Hamona fani hepalo a'a hefua e'ei dufaa du'ua—mint, dill ma cummin. Ma'uaa hamona fanunu'au'uaiaa ei rarabaa manumanu laloo fei law—ale'ei tamanu na wanewane, ei faloloa'ia ma fei mau oafagugua. Ina rawani nabaa hamona bigidigamai e'ei ma lomi hamona madi'inaa fei hepalo a'a hefua. ");
INSERT INTO wuv_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Hamu'ou ena pudawerai talaiduga, hamona nueisiminaa hepalo pugo'a, ma'uaa hamona onomaa hepalo camel. ");
INSERT INTO wuv_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","“Hamona fagiana, hamu'ou ena feroiaa law mawe hamu'ou ena Pharisee, gueina ware'oni! Hamona'u fesuaa fei auguu ei bara ma ei apia, ma'uaa lalona na pepesu ei wawa'ai poa ma fei nara'uaiaa ana hamu'ou. ");
INSERT INTO wuv_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Hamu'ou ena pudawerai Pharisee! Do'o fesuaa laloo ei bara ma apia ma fei augu ipowe fafa'arai anaa. ");
INSERT INTO wuv_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","“Hamona fagiana, hamu'ou ena feroiaa law mawe hamu'ou ena Pharisee, gueina ware'oni! Hamu'ou ale'ei ei humuu ma'ea na pomaifapo'i fei auguna, fei na fananamai, ma'uaa, i lalona na pepesu a'a ei guii ma'ea ma minaa ei loloaa. ");
INSERT INTO wuv_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Ana ale'ei, i pudaa rama'a ba hamona wanewane, ma'uaa laloo iaa hamu'ou na pepesu a'a ei ware'onia ma ei naranaraa hafelo'a. ");
INSERT INTO wuv_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","“Hamona fagiana, hamu'ou ena feroiaa law mawe hamu'ou ena Pharisee, gueina ware'oni! Hamona'u wadufani humuu ma'eaa ei mamama'a ma haweginaa ei huapuu ei wanewanea. ");
INSERT INTO wuv_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Ma hamona'u ware ba, ‘Nabaa hai'ouna oa a'a fei au ei amaa hai'ou mina, lomi ba hai'ou rarafiaa ro'ou ei ro fawiginaa fei namoo ei mamama'a.’ ");
INSERT INTO wuv_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Ma wagii fei, hamona uniaa ana hamu'ou, uaa hamu'ou pai ei rona fo'afama'eaa ei mamama'a. ");
INSERT INTO wuv_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","E'eni hamopowe bigifa'apoinaa ei hafelo'a, ei di fa'asi'anaa ei amaa hamu'ou mina! ");
INSERT INTO wuv_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","“Hamu'ou ena wa'a! Hamu'ou ena na'uu ei wa'a hafelo! Hamu'ou ponipa'ai batanai a'a fei waduhero? ");
INSERT INTO wuv_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Si'ei, yau ba a aloawii ei mamama'a, ei ano'ano mawe ei feroia a'a hamu'ou. Hamo'aa fo'afama'eaa hefi'a ro'ou ma fatawaa ro'ou a'a ei hawafolo ma hefi'adiai, hamo'aa babuinaa ro'ou i laloo ei synagogue hamu'ou ma tetenaa ro'ou a'a hepapalo gufu. ");
INSERT INTO wuv_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Ma si'ei, i pafoo hamu'ou iwe wigimai fei raraa minaa ei wanewanea, ei rona ma'e yeni malagufu a'a fei au wigiaa raraa Abel nopa'aloo fei au wigiaa raraa Zechariah, mei na'uu Berekiah, mei hamona fo'afama'eia watolaa fei humuu mei Haidaa ma fei tawahafi na apunai. ");
INSERT INTO wuv_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","A warefa'uai a'a hamu'ou ba minaa ei, iwe pasi pafoo taweni. ");
INSERT INTO wuv_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","“O, Jerusalem, Jerusalem, mena, ona fo'afama'eaa ei mamama'a ma nafafama'enaa mugoo ena aloawiau a'amu, una'aida nunuminia ba a fafigupuinaa ei na'umu ale'ei hepalo inaa a'aroo na fafigupuinaa ei na'una haroo pauna ma'uaa, lomi ona nunumiai. ");
INSERT INTO wuv_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Ma'a, na fawawadua fei humumu, fei na udenaa a'amu. ");
INSERT INTO wuv_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Uaa a warefanaa hamu'ou ba lomi hamo'aa fanunupa'idinau hawina hamona ware ba, ‘Na pa'i hawegiana mei fi nomai a'a fei haraa mei Fasu.’” ");
INSERT INTO wuv_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Jesus na di'ininaa fei humuu mei Haidaa ma i'a talailao, rona nomai a'ana ei otalai nenerana ba ro'aa fama'aiaa ei humu yei. ");
INSERT INTO wuv_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Ina i'igai, “Oo, hamona fanunuia minaa ena manumanu ena? Apa'aa warefa'uai a'a hamu'ou ba lomi hepalo mugoo wagina ba i ude pafoo hepalodiai; minaa ei, ro'aa sumipedunaa pu.” ");
INSERT INTO wuv_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","I'a guta pafoo Maugeni Olive Jesus, ei otalai nenerana, rona nofagigimai a'ana ma ware, “Warefanaa hai'ou ba nahaiga i nomai fei manumanu fei ma tamanu fei hilala i unifanaa hai'ou ba opowe nomai ma ipowe pedu fei au.” ");
INSERT INTO wuv_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Jesus na ware, “Oma'ama'a ba lomi nemea i sifi'aa hamu'ou. ");
INSERT INTO wuv_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Uaa watauda, rowe nomai a'a fei harau ma ware ba, ‘Yau, mei Christ,’ ma ro'aa sifi'aa watauda. ");
INSERT INTO wuv_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Hamowe guainia ba ei gufu, rona fifo'ai ma hamowe guainia ba na pa'i fifo'aia, ma'uaa hamonei'aa naranara watauda wagii ei. Ei manumanu ei, ro'apowe nomai, ma'uaa atawe pedu fei au. ");
INSERT INTO wuv_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Hefi'a baua gufu, rowe asi'aa fasibanaa a'a hefi'adiai baua gufu ma ei hapara, rowe asi'aa fasibanaa a'a hefi'adiai hapara. Iwe moubiabia ma rerere hefi'a gufu yeni malagufu. ");
INSERT INTO wuv_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Minaa ei manumanu ei, neido'o nomai ale'ei nemea pifine ba i do'o tonaa fi'ina ma hinene i wanini. ");
INSERT INTO wuv_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","“Ma nenee fei, hefi'a, ro'aa fifaninaa hamu'ou panii hefi'adiai ba ro'aa haperararaiaa hamu'ou ma fo'afama'eaa hamu'ou ma minaa ei gufu i bidibidi unuu ro'ou a'a hamu'ou uaa yau. ");
INSERT INTO wuv_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","A'a fei au fei, watauda i asisi ei naranaraa ro'ou a'au ma ro'aa fi'ufadugii ma fibidibidii unuu ro'ou. ");
INSERT INTO wuv_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Rowe nomai watauda mamama'a sifisifi ma sifi'aa watauda. ");
INSERT INTO wuv_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Si'ei ba namina rata ei hafelo'a, fei haguaa watauda i pa'ai, ");
INSERT INTO wuv_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","ma'uaa hini i ofafaufau nopa'aloo fei pedupeduu fei au, i tela. ");
INSERT INTO wuv_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Ma feni rawani'a wareaa fei haparaia, iwe talepedunaa minaa ei gufu tadiwe'aia ba minaa ei, ronei guainia ma ipowe nomai fei pedupeduu fei au. ");
INSERT INTO wuv_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","“Si'ei, ena hamona fanunupa'aa ‘mei hafelo'a, mei ba i fafeloaa fei humuu mei Haidaa’ ba na ufalarai fawelei na apunai, mei nadii u'ugia mei mamama'a Daniel—mei igoa nei apa'ia— ");
INSERT INTO wuv_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","ma ei ro'ou yei Judea, ronei ponipa'ainaa a'a ei maugeni. ");
INSERT INTO wuv_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Nemea pafoo pupuaa humuna nei'aa upu ba i to ne'aa manumanu laloo humuna. ");
INSERT INTO wuv_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Nemea pifine i pe'ihape nei'aa bagua ba i to hawaa uguna. ");
INSERT INTO wuv_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","A'a ei arewaa ei, iwemina hafeloinaa ei wareu mawe ei roi fasususuu baduu. ");
INSERT INTO wuv_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Lafulafu ba fei ponipa'aiaa hamu'ou nei'aa nomai a'a fei au lalare ma maunu, o laloo fei Sabbath. ");
INSERT INTO wuv_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Uaa iwe nomai fei pa'aa baua au hafelo, fei lomi na hawawagia hepalo hafelo'a wagii fei mamaraiamii feni ano nopa'amii wagieni ma nefarani, ana lomi ba i pa'i hepalo au hafelo'a ale'ei fei. ");
INSERT INTO wuv_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Nabaa lomi i pedu ei arewaa ei, lomi nemea i tela ma'uaa, si'ei ba ei rafeiana ana rona guta wagina, i faweleguinaa ei arewaa ei. ");
INSERT INTO wuv_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","A'a fei au fei, nabaa nemea i ware a'amu ba, ‘Fanunu, simeni meni Christ!’ o, ‘Simei, hia yei!’ apuna guaiana. ");
INSERT INTO wuv_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Uaa, rowe nomai ei sifisifi Christ ma ei sifisifi mamama'a ma ro bigi'aa ei rawani'a hilala ma ei foigia ba ro'aa sifi'aa ei rafeiaa mei Fasu. Ma'uaa lomi ba ro'aa sifipa'aa ro'ou. ");
INSERT INTO wuv_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Ma'aia, unadii warefa'aidigaa hamu'ou. ");
INSERT INTO wuv_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","“Si'ei, nabaa nemea i warefanaa hamu'ou ba, ‘Simei, hia yei, fawelei lomi guana ma haihai,’ apuna nolao; o, ‘Simeni, yeni, laloo eni humu,’ apuna guaiana. ");
INSERT INTO wuv_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Uaa minaa ei, rowe aida ba fi nomai mei Na'uu Rama'a, ana ale'ei ba nabaa fei usida na gime'aimai pepei anaa halo dinaloo loloaa halo, minaa ei ro'aa fanunupa'ia. ");
INSERT INTO wuv_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Ma nabaa rona fanunuaa ei ro'udo rona fidulao hitani, minaa ei, rona aida ba na pa'i wafuu ma'ea yei. ");
INSERT INTO wuv_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","“Ina'aa pedulao ei hafelo'a wagii ei arewaa ei “‘fei halo i roroma, ma fei puda, lomi i fanaa fei we'aina; ei pi'u, ro'aa pasirai haroo pumanugawe ma ei manumanu haroo pafea, rowe rerere.’ ");
INSERT INTO wuv_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","“A'a fei au fei, fei hilalaa mei Na'uu Rama'a i fa'arewamai i haroo pumanugawe ma minaa ei gufupedu yeni malagufu, ro'aa faloloa'i. Rowe fanunupa'aa mei Na'uu Rama'a fi nomai pafoo ei papalei pafea nofininamii ei faufauna ma hawerana. ");
INSERT INTO wuv_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Ma iwe aloaa ei alo'alona fininaa aigaa fei maniwa ma rowe figupuinaa ei rafeiana, noramiaa ro'ou laloo minaa ei gufu tadiwe'aiaa feni malagufu ma i pafea. ");
INSERT INTO wuv_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","“Hamonei to apa'aa hamu'ou wagii fei haihai figi: ena hamona fanunupa'ia ba ei rau mamarawii na sunaimai, hamona aida ba fei au rawani ipowe nomai. ");
INSERT INTO wuv_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Ana ale'ei, ena hamona fanunupa'aa ei manumanu ei, hamonei aida ba ina rafi'i, i poaa fei gigei. ");
INSERT INTO wuv_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","A warefa'uai a'a hamu'ou ba ei rama'aa feni taweni, pa'aa lomi ba ro'aa pa'ai hawina na nomai minaa ei manumanu ei. ");
INSERT INTO wuv_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Fei haroo pumanugawe ma feni ano, laguwe apa'ai, ma'uaa ei wareau lomi rowe apa'aitoo. ");
INSERT INTO wuv_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","“Lomi nemea na aida ba pa'aa nahaiga fei arewaa o fei au, ana lomi rona aida ei alo'alo pafea o mei Na'u, ma'uaa uniaa mei Ama. ");
INSERT INTO wuv_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","A'a ei arewaa Noah, ana ale'ei fei au noramiaa mei Na'uu Rama'a. ");
INSERT INTO wuv_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Uaa a'a ei arewaa itawe nomai fei lamalamana, ei rama'a, rona hanana ma hunu, lalai ma falalai nopa'aloo fei arewaa ba Noah na wadu'ainaa laloo fei baua wa. ");
INSERT INTO wuv_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Ma lomi rona aida ba tamanu i nomai nopa'aloo fei ba na nomai fei lamalamana ma na lafenotonaa minaa ro'ou. Ana ale'ei a'a fei au noramiaa mei Na'uu Rama'a. ");
INSERT INTO wuv_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Helagui wawane, lagua i pe'ihape; hemea i apa'ai ma hemea, lomi. ");
INSERT INTO wuv_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Helagui pifine, lagu'ei harara du'ua; hemea i apa'ai ma hemea, lomi. ");
INSERT INTO wuv_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","“Si'ei, hamonei oma'ama'a, uaa lomi hamona aida fei arewaa na nomai mei Fasuu hamu'ou. ");
INSERT INTO wuv_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Ma'uaa hamonei apa'ima'aiaa feni: Nabaa mei amaa fei humu na aidadii ba pa'aa nahaiga laloo fei poi i nomai mei fafanao, i oma'a ma lomi i wadu'aipa'i mei. ");
INSERT INTO wuv_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Si'ei, ana ale'ei, hamonei ofafaufau, uaa mei Na'uu Rama'a i nomai a'a fei au lomi hamona nara ba i nomai. ");
INSERT INTO wuv_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","“Mei fasu i aunaa hini nafi na oafagugu ma na pa'i apa'ana ba nei oma'aa ei hefi'adiai nafi laloo humuna ma fani hanaa ro'ou a'a fei au hananaa? ");
INSERT INTO wuv_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Na rawaninaa mei nafi nabaa i hadiwe'imai mei fasuna ma fanunupa'ia ba mei nafi mei, na bigi'aa ei nunumiana. ");
INSERT INTO wuv_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","A warefa'uai a'a hamu'ou ba iwe aunaa hia oma'ama'aa minaa ei manumanuna. ");
INSERT INTO wuv_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Ma'uaa, nabaa mei nafi na hafelo ma na nara ba, ‘Mei fasuu, namina madii gutanana hefawala,’ ");
INSERT INTO wuv_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","ma na fo'aa ei nafi, ei rafirafina ma hanana ma hunufapoapoai, ");
INSERT INTO wuv_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","mei fasuna, ipowe nomai wagii hepalo arewaa ma au lomi na nara mei nafi ba i nomai mei fasuna. ");
INSERT INTO wuv_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Iwe walawalainia ma augia i a'a ei ware'oni, yei fawelei na pa'i ai'aiga ma fi'u'uiaa difo. ");
INSERT INTO wuv_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","“A'a fei au fei, fei haparaia pafea, tawi'ana ale'ei hefua nanao rona tonaloo ei ramai ro'ou ma aunu ba ro'aa ma'a mei wawane lalaia. ");
INSERT INTO wuv_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Haipaniei poapoa ma haipaniei ano'ano nanao. ");
INSERT INTO wuv_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Ei poapoa, rona notonaa ei ramai ro'ou, ma'uaa lomi rona notoo pao. ");
INSERT INTO wuv_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Ma'uaa ei ano'ano, rona notolao ramai ma pao fininaa ei pe'i. ");
INSERT INTO wuv_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Ma na madii ma'ida fei noramiaa mei wawane lalaia ma na pasiholehole pudaa minaa ro'ou ma rona ma'igu. ");
INSERT INTO wuv_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","“Poidifa'u'u hemea rama'a na haroharo: ‘Simeni, meni wawane lalaia! Asi'amai ma mi ma'aia!’ ");
INSERT INTO wuv_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","“Ma minaa ei nanao, rona wera ma fawe'afarawaninaa ei ramai ro'ou. ");
INSERT INTO wuv_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Ei poapoa, rona warenaa a'a ei ano'ano ba, ‘Igifani pao eni ramai hai'ou; fi pere eni ramai hai'ou.’ ");
INSERT INTO wuv_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","“Rona ware ba, ‘Lomi na hawia hai'ou ma hamu'ou. Ma'uaa aununaa a'a ei rona'o alo pao ma pono pao hamu'ou.’ ");
INSERT INTO wuv_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","“Ma'uaa ei roifi nolao ba ro'aa pono pao, mei wawane lalaia na nomai. Ei nanao ei rona oma'a, rona wadu'ai ma hananafipui a'ana fei hananaa lalaia. Ma fei gigei na fare'i. ");
INSERT INTO wuv_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","“Nene, ei haipanidiai, rona nomai. Rona ware, ‘Mena lalaia! Mena lalaia! Gigifanaa hai'ou fei gigei!’ ");
INSERT INTO wuv_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","“Ma'uaa ina ware, ‘Apa'aa warefa'uai ba lomi una apa'aa hamu'ou.’ ");
INSERT INTO wuv_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","“Si'ei, hamonei oma'a, uaa lomi hamona aida fei arewaa, o fei au. ");
INSERT INTO wuv_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","“Ma ana ale'ei hemea ba i tatalai gufu raua, mei na harofaa ei nafina ma fanaa ei manumanuna a'a ro'ou ba ronei oma'aia. ");
INSERT INTO wuv_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","A'a hemea ina fanaa haipani mugoo po'i. A'a hemeadiai, na fanaa guapalo ma a'a hemeadiai, hepalo; ina fanaa hememea ana ale'ei na puduaa apa'ana. Ma ina aunulao a'a fei tatalaiana. ");
INSERT INTO wuv_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Mei na tonaa haipani na aunubatafa ma bigi a'a ei mugoo po'ina ma na to haipanidiai. ");
INSERT INTO wuv_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Ana ale'ei, hemei na tonaa guapalo, ina to guapalodiai. ");
INSERT INTO wuv_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Ma'uaa mei na tonaa hepalo na aunu ma agi'opa'ainaa fei mugoo po'ii mei fasuna. ");
INSERT INTO wuv_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","“I madilao, na nomai mei fasuu ei nafi ba i fawanewaneaa ei mugoo po'i a'a ro'ou. ");
INSERT INTO wuv_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Mei tonana haipani na todimai haipani. Ina ware, ‘Mena fasu, onadii faninaa paniu haipani. Ma'a, una pafoinaa haipanidiai.’ ");
INSERT INTO wuv_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","“Mei fasuna na ware, ‘Ona bigifarawani mena rawani'a nafiu, ona narapa'au! Si'ei ba ona oma'afarawaninaa ma'ida manumanu; a aunaa yoi oma'aa watauda manumanu. Mi ni'eni'efipui a'au!’ ");
INSERT INTO wuv_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","“Mei tonana guapalo ana na nomai. Ina ware, ‘Mena fasu, onadii faninaa paniu guapalo. Ma'a, una pafoinaa guapalodiai.’ ");
INSERT INTO wuv_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","“Mei fasuna na ware, ‘Ona bigifarawani mena rawani'a nafiu, ona narapa'au! Si'ei ba ona oma'afarawaninaa ma'ida manumanu; a aunaa yoi oma'aa watauda manumanu. Mi ni'eni'efipui a'au!’ ");
INSERT INTO wuv_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","“I dii, inawe nomai mei tonana hepalo ma ware, ‘Mena fasu, una aidadii ba yoi, hemea ona'o nunuminia ba ei rama'a, ronei bigifawe'i a'amu, ona'o hufu fawelei abaa faroamu ma ona'o hau fawelei lomi ona sumai lau. ");
INSERT INTO wuv_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Si'ei, una ma'au ma na aunu'agifipa'ainaa fei mugoo po'imu. Ma'a, ana sifeni, feni mugoo po'imu.’ ");
INSERT INTO wuv_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","“Ina ware mei fasuna, ‘Yoi, pa'aa tamafo ma hafelo'a nafi! Haa, ona aidadii ba una'o hufu fawelei abaa faroau ma una'o hau fawelei lomi una sumai lau? ");
INSERT INTO wuv_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Ona aida ba yau ale'ei, na? Nabaa onadii augaa fei mugoo po'iu laloo fei humuu mugoo po'i, una hadiwe'imai a todiai ma'ida mugoo po'i pafona. ");
INSERT INTO wuv_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","“‘Tonaa fei mugoo po'i a'ana ma fanaa mei na pa'i hefua. ");
INSERT INTO wuv_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Uaa hini na pa'i, i todiai ma iwe pa'i watauda. Hini lomi na pa'i, tamanu ma'idei hodihodiana, nemea i tohadiwe'inia a'ana. ");
INSERT INTO wuv_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Fa'asi'anaa i ano mei hafelo'a nafi wagii fei roromaa, fei na pa'i ai'aiga ma fi'u'uiaa difo.’ ");
INSERT INTO wuv_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","“Ena na nomai mei Na'uu Rama'a nofininamii ei hawerana fipuinaa minaa ei alo'alona, iwe guta pafoo fei gutanaa hapara wagii fei haweraa fei gufu pafea. ");
INSERT INTO wuv_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Minaa ei gufu tadiwe'ai, ro'aa figupuimai i ma'ana ma iwe fi'alaginaa ei rama'a ana ale'ei hemei oma'ama'aa ei sipsipi na fi'alaginaa ei sipsipi ma ei memee. ");
INSERT INTO wuv_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Iwe aunaa ei sipsipi raudei ma'auna ma ei memee raudei mauwina. ");
INSERT INTO wuv_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","“I dii, mei Hapara, i warenaa a'a ei pepei ma'auna, ‘Nomai, hamu'ou ena na haweginaa hamu'ou mei Amau; tonaa ei pono'aa hamu'ou, ei na pagidigia mina, wagii fei au i famamaraiaa feni malagufu. ");
INSERT INTO wuv_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Uaa una bao ma hamona faguau, una sigigi ma hamona fani numau, lomi gufuu ma hamona taufa'ugau, ");
INSERT INTO wuv_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","lomi lawalawau ma hamona falalawainau, una funu ma hamona roinau, yau humuu bobo'aia ma hamonamii ma'a yau.’ ");
INSERT INTO wuv_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","“Ma ei wanewanea, ro'awe warenaa a'ana ba, ‘Mena fasu, haiga ei hai'ouna ma'apa'io ba ona bao ma hai'ouna faguio, o ona sigigi ma hai'ouna fani numamu? ");
INSERT INTO wuv_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Haiga ei hai'ouna ma'apa'io ba lomi gufumu ma hai'ouna taufa'ugio, o lomi lawalawamu ma hai'ouna falalawainio? ");
INSERT INTO wuv_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Haiga ei hai'ouna ma'apa'io ba ona funu, o yoi humuu bobo'aia ma hai'ounaree ma'a yoi?’ ");
INSERT INTO wuv_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","“Mei Hapara, iwe ware ba, ‘U'eipa'aa ware a'a hamu'ou ba ei hamona bigi'aa e'ei a'a hemea lofuu, hemea lomi baua harana, ana ale'ei hamona bigi'ia a'au.’ ");
INSERT INTO wuv_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","“Ma iwe warenaa a'a ei i pepei mauwina ba, ‘Hamu'ou ena una umuaa hamu'ou, difaraua a'au ma dinaa i a'a fei hafi lomi i peretoo, fei di pagi'augau ba hafii mei hani'u ma ei alo'alona. ");
INSERT INTO wuv_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Uaa, una bao ma lomi hamona faguau, una sigigi ma lomi hamona fani numau, ");
INSERT INTO wuv_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","lomi gufuu ma lomi hamona taufa'ugau, lomi lawalawau ma lomi hamona falalawainau, una funu ma yau humuu bobo'aia ma lomi hamona roinau.’ ");
INSERT INTO wuv_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","“Ana ro'awe ware ba, ‘Mena fasu, haiga ei hai'ouna ma'apa'io ba ona bao, o ona sigigi, o lomi gufumu, o lomi lawalawamu, o ona funu, o yoi humuu bobo'aia ma lomi hai'ouna hadumio?’ ");
INSERT INTO wuv_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","“Iwe ware, ‘U'eipa'aa warefa'uai a'a hamu'ou ba tamanu lomi hamona bigi'ia a'a hemea lomi na bauana harana, ana lomi hamona bigi'ia a'au.’ ");
INSERT INTO wuv_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","“Ma ro'awe tonaa fei fagianaa lomi i pedutoo, ma'uaa ei wanewanea, ro'awe tonaa fei harenua lomi i pedutoo.” ");
INSERT INTO wuv_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","I'a warepedugaa ei manumanu ei Jesus, ina warenaa a'a ei otalai nenerana, ");
INSERT INTO wuv_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Hamona aida ba i nomai fei Talai Falogia namafuo ma mei Na'uu Rama'a ro'aa fifaninia panii hefi'a ba ro'aa fatawaia.” ");
INSERT INTO wuv_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","I dii, ei famamoaa humuu mei Haidaa ma ei bauaniaa gufu, rona figupui laloo humuu Caiaphas, mei pa'aa bauaniaa humuu mei Haidaa ");
INSERT INTO wuv_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","ma rona fiwareinaa hefi'a manitoai hafelo'a ba ro'aa panarofaa Jesus ma fo'afama'eia. ");
INSERT INTO wuv_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Rona ware ale'ei ba, “Ma'uaa a'a ba wagii fei au Hananaa, o ei rama'a rowemina fisibai.” ");
INSERT INTO wuv_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","I guta yei Bethany Jesus laloo humuu hemea rama'a, mei rona roroinia Simon mei Watawatai, ");
INSERT INTO wuv_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","na nomai a'ana hemea pifine na pa'i hepalo alabaster pe'i pao na dufa ma namina bauana pono'ana ma na iginaa tabana ei fi gutafapalagi ditataa fei tawa. ");
INSERT INTO wuv_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Ro'aa fanunuaa fei ei otalai nenerana, ronamina siba ma i'igai, “Tani o igisimi'uaia ale'ei? ");
INSERT INTO wuv_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Fei dufaa pao, ina rawani nabaa ona alonaa baua mugoo po'i ma fanaa ei mugoo po'i a'a e'ei lomi manumanuu ro'ou.” ");
INSERT INTO wuv_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Jesus na aida ba rona ware ale'ei ma na warenaa a'a ro'ou, “Tani hamo'aa fahauaa unuu mei pifine? Ina bigi'aa hepalo pa'aa rawani'a manumanu a'au. ");
INSERT INTO wuv_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Ranimai, ei lomi manumanuu ro'ou, rona guta inamoaa hamu'ou ma'uaa, abaa ranimai yau a gutafipui a'a hamu'ou. ");
INSERT INTO wuv_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Ina igiaa feni dufaa pao unuu ba i hapigi'augau a'a fei huapu. ");
INSERT INTO wuv_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","A warefa'uai a'a hamu'ou ba hitani yeni malagufu ro'aa u'ugaa fei rawani'a warea, ana rowe guainaa tamanu ina bigi'ia a'au mei pifine ba ronei nonominia.” ");
INSERT INTO wuv_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","I dii, hemea ei Hefua ma Helagui—mei rona roroinia Judas Iscariot—na aununaa a'a ei famamoaa humuu mei Haidaa ");
INSERT INTO wuv_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","ma na i'igai, “Hamo'aa fanau tamanu nabaa a fifaninia panii hamu'ou?” Si'ei, rona wareifania odufua pa'ania mugoo po'i silver. ");
INSERT INTO wuv_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","A'a fei ma nolao, Judas na oma'aiaa hepalo rawani'a au ba i fifaninia panii ro'ou. ");
INSERT INTO wuv_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","A'a fei rawarawa arewaa laloo fei Hananaa ei Faraa Pidaua Lomi Fafuafua, ei otalai nenerana, rona nomai a'a Jesus ma i'igai, “Nunumiamu ba hai'ou'aa pagia hitani fei gutanaa o'ou ba o'aa hanana a'a fei Talai Falogia?” ");
INSERT INTO wuv_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Ina ware, “Wi wadu'ainaa fei baua gufu a'a hemei rama'a ma warefania ba, ‘Mei Feroia na ware ba: Fei auu na rafi'i. Hai'ou ei otalai nenerau, hai'ou gutafipui wagii fei Hananaa fei Talai Falogia i humumu.’” ");
INSERT INTO wuv_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Si'ei, ei otalai nenerana, rona bigi'aa ei warenaa a'a ro'ou ma pagi'augaa ei manumanuu fei Talai Falogia. ");
INSERT INTO wuv_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","I nopoilao, Jesus na gutafapalagi a'a fei tawa fipui a'a ei Hefua ma Helagui. ");
INSERT INTO wuv_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Ma ei roi hanana, ina ware, “A warefa'uai ba hemea hamu'ou, i aloau.” ");
INSERT INTO wuv_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Ronamina faloloa'i ma hememea ro'ou na warenaa a'ana ba, “A'a ba yau, mena Fasu?” ");
INSERT INTO wuv_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Jesus na ware, “Mei i pudifipuinaa panina a'au laloo fei hagi, hia, i aloau. ");
INSERT INTO wuv_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Mei Na'uu Rama'a, iwe aunu ana ale'ei ronadii ne'inia. Ma'uaa ina fagiana mei na aloaa mei Na'uu Rama'a! Ina rawani nabaa lomi ina waninimai.” ");
INSERT INTO wuv_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","I dii, Judas, mei ba i aloaa Jesus nawe ware a'ana ba, “A'a ba yau, Rabbi?” Jesus na ware, “Hi'i, pa'aa yoi.” ");
INSERT INTO wuv_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Ei roi hanana, Jesus na tonaa fei faraa pidaua, na ware ‘ta’, bidigedigeia ma fanaa ei otalai nenerana ma na ware, “Tonia ma hanaia; feni, pigiou.” ");
INSERT INTO wuv_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Ma na tonaa fei bara, ware ‘ta’, fanaa ro'ou ma ware, “Hunu a'a feni, minaa hamu'ou. ");
INSERT INTO wuv_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Feni, rarau a'a fei fi'ugaia, fei na wigii a'a watauda ba mei Fasu i futoaa ei hafelo'aa ro'ou. ");
INSERT INTO wuv_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","A warefanaa hamu'ou ba lomi ba a hunudinaa ei ranuu grape nopa'aloo fei arewaa na hunufipuidiai a'a hamu'ou laloo fei haparaiaa mei Amau.” ");
INSERT INTO wuv_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Ro'aa laugidigaa hepalo laugaa mei Haidaa, rona aununaa yei Maugeni Olive. ");
INSERT INTO wuv_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","I dii, Jesus na warenaa a'a ro'ou, “A'a feni poi feni, minaa hamu'ou, hamo'aa pasi, uaa yau. Uaa ronadii ne'inia ba: “‘Yau, ba a hafugaa mei oma'ama'aa ei sipsipi, ma ei sipsipi, rowe ponitalanenei.’ ");
INSERT INTO wuv_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Ma'uaa ena na asi'aa, awe aunulao i ma'aa hamu'ou, dinaa Galilee.” ");
INSERT INTO wuv_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Na ware Peter, “Nabaa minaa ro'ou, rona pasi uaa yoi, yau, pa'aa lomi.” ");
INSERT INTO wuv_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Jesus na ware, “A warefa'uai a'amu ba a'a feni poi feni, atawe ai fei a'aroo, yoi, o'aa ware ba lomi ona apa'au.” ");
INSERT INTO wuv_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Ma'uaa Peter na ware, “Nabaa unei ma'efipui a'amu, ana lomi a ware ba lomi na apa'a'io.” Ma minaa ei otalai nenerana, ana rona ware ale'ei. ");
INSERT INTO wuv_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","I dii, Jesus na dinaa Gethsemane fipui a'a ei otalai nenerana ma warenaa a'a ro'ou, “Guta yeni ena na dinaa yei ma lafulafu.” ");
INSERT INTO wuv_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Ina dugaa Peter mawe laguei na'uu Zebedee fipui a'ana ma nawemina faloloa'i ma awata naranarana. ");
INSERT INTO wuv_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Ma ina warenaa a'a ro'ou, “Fei naranarau namina pepesu a'a ei faloloa'ia ba apo'o bima'e ua. Guta yeni ma oma'oma'afipui a'au.” ");
INSERT INTO wuv_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","I'a nolao ma'idadiai, na fapasinaa pudana i malagufu ma lafulafu, “Mena Amau, nabaa na rawani a'amu, tonaa fei bara a'au. Ma'uaa onei'aa bigi'aa ei nunumiau, uaa ei nunumiamu.” ");
INSERT INTO wuv_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Ma inawe hadiwe'idinaa a'a ei otalai nenerana ma re bapa'aa ro'ou, rona ma'igu ua. Ina i'iginaa Peter, “Haa, lomi ba hamo'aa guta'oma'afipui a'au ale'ei heai hour ua? ");
INSERT INTO wuv_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Hamonei oma'a ma lafulafu ba hamonei'aa pasi a'a ei hafelo'a. Fei spiriti, na mamalawia, ma'uaa, fei unu na rafilele.” ");
INSERT INTO wuv_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Ina aunudiai fei faguapoana ma na lafulafu, “Mena Amau, nabaa unei hunumaa fei bara ma lomi ba o tonia, te, a bigi'aa nunumiamu.” ");
INSERT INTO wuv_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","I'a hadiwe'imai, na fanunupa'idinaa ro'ou ba rona ma'igu, uaa namina pasiholehole pudaa ro'ou. ");
INSERT INTO wuv_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Si'ei, ina di'ininaa ro'ou ma aunudiai ma fei fa'odupoaa lafulafuana ana ale'ei ei wareana fama'a. ");
INSERT INTO wuv_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","I'a hadiwe'idimai a'a ei otalai nenerana, ina warenaa a'a ro'ou, “Haa, ana hamo'ei ma'igu ma fawenai? Ma'aia, fei au na rafi'i ma mei Na'uu Rama'a, na udediginaa panii ei hafelo'a. ");
INSERT INTO wuv_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Asi'aa. O dii! Ifi nomai mena i aloau!” ");
INSERT INTO wuv_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Ana fi wareware ua, na nomai Judas, hemea ei Hefua ma Helagui. I a'ana na pa'i hepalo baua gupuu rama'a ma rona pa'i wadu ma hafuhafu, aloamiaa ei famamoaa humuu mei Haidaa mawe ei bauaniaa gufu. ");
INSERT INTO wuv_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Mei aloa nadii pagi'augaa fei lala a'a ro'ou ale'ei ba, “Mei una hatofaa manufina, simei; hamonei panarofia.” ");
INSERT INTO wuv_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Judas na nofawanewanelao a'a Jesus ma na ware, “Poi, mena Rabbi!” ma ina hatofaa manufina. ");
INSERT INTO wuv_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Jesus na ware, “Otafi, bigi'aa fena ba o'aa bigi'ia.” Ma ei rama'a, rona'aa ulao, panarofaa Jesus ba ro'aa nodugia. ");
INSERT INTO wuv_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Ma hemea ei maroaa Jesus na rapuwenu'aa fei waduna ma lafigifamosuaa fei adiaa mei nafii mei pa'aa bauaniaa humuu mei Haidaa. ");
INSERT INTO wuv_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Jesus na warefania, “Auhadiwe'inia a'a fei udeana fei wadumu, uaa hini i rapuwenu'aa waduna ana i ma'e a'a fei wadu. ");
INSERT INTO wuv_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Lomi hamona aida ba nabaa a harofaa mei Amau, i alofanamiau ale'ena oloromfua pa'ania pufaba'a alo'alo? ");
INSERT INTO wuv_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Ma'uaa, nabaa ale'ei, batanai ba i fa'uai ei ne'ia laloo fei Bu'u Apuna ba nei ale'ei e'eni?” ");
INSERT INTO wuv_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","A'a fei au fei, Jesus na warenaa a'a fei gupuu rama'a, “Haa, una fasibaiaa ei rama'a a'a fei gavaman ma si'ei hamona notonamiaa ei wadu ma ei hafuhafu ba hamomii panarofau? Minaa ei arewaa na guta i malalaa fei humuu mei Haidaa ma feferoi ma lomi hamona panarofau. ");
INSERT INTO wuv_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Ma'uaa minaa ei manumanu ei, ina nomai ba nei fafa'uainaa ei ne'iaa ei mamama'a.” Ma minaa ei otalai nenerana, rona ponidi'ininia. ");
INSERT INTO wuv_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Ei rama'a rona panarofaa Jesus, rona noduginaa hia a'a Caiaphas, mei pa'aa bauaniaa humuu mei Haidaa, yei fawelei rona figupui ei feroiaa fei law mawe ei bauaniaa gufu. ");
INSERT INTO wuv_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Ma'uaa Peter na nenegifarauamai ma'ida a'ana, nopa'aloo fei malalaa fei humuu mei pa'aa bauaniaa humuu mei Haidaa. Ina wadu'ai ma gutafipui a'a ei oanananaa ba i fanunu ba ro'aa bigi'aa tamanu. ");
INSERT INTO wuv_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Ei famamoaa humuu mei Haidaa mawe minaa ei Sanhedrin, rona lalabaginaa ei sifisifi warea a'a ei rama'a ba Jesus na bigifatata ma ro'aa fo'afama'eia. ");
INSERT INTO wuv_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Watauda rama'aa sifisifi, rona nomai ma'uaa, lomi rona labagipa'aa hepalo tatana. I dii, lagunawe nomai helagui rama'a ");
INSERT INTO wuv_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","ma laguna ware ba, “Meni rama'a meni, ina ware ba ‘A birosiaa fei humuu mei Haidaa ma fadudinia laloo oduai arewaa.’” ");
INSERT INTO wuv_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Nawe ufalarai mei pa'aa bauaniaa humuu mei Haidaa ma warenaa a'a Jesus, “Haa, lomi o'aa ware? Tamanu fei u'uga laguna wareia ba ona bigi'ia?” ");
INSERT INTO wuv_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Ma'uaa Jesus na ufamadumu. Mei pa'aa bauaniaa humuu mei Haidaa na warenaa a'ana, “A warenaa a'amu ba onei warefa'uai i pudaa mei Haidaa, mei fi oalao: Nabaa yoi, mei Christ, mei Na'uu mei Haidaa, te, warefanaa hai'ou.” ");
INSERT INTO wuv_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Jesus na ware, “Hi'i. Ana ale'ei ona wareia. Ma'uaa a warefanaa minaa hamu'ou ba nefarani, hamopowe ma'apa'aa mei Na'uu Rama'a i guta i ma'au Hemei Faufaua na nomai i pafoo ei papalei pafea.” ");
INSERT INTO wuv_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Ma mei pa'aa bauaniaa humuu mei Haidaa na rapunini'aa ei lawalawaa anaia ma ware, “Ina warefafeloaa mei Haidaa! Tani o labagidinaa nemea ba i u'ugia? Ma'aia, hamona guaidigia ba ina warefafeloaa mei Haidaa. ");
INSERT INTO wuv_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Tamanu naraa hamu'ou?” Rona ware ba, “Pono'ana ba inei ma'e.” ");
INSERT INTO wuv_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Si'ei, rona huwiaa pudana ma la'ugia. Hefi'adiai, rona lapagia ");
INSERT INTO wuv_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","ma ware, “Di warefa'aiaa hai'ou, mena Christ. La'ugaa hini yoi?” ");
INSERT INTO wuv_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Peter na guta i malalaa fei ro'ei fadududu ma hemea nafi nanao na nomai a'ana. Ina ware, “Yoi, ana hemea maroaa Jesus, mei Galilee.” ");
INSERT INTO wuv_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Ma'uaa ina ware ba lomi. Ina ware, “Lomi una aida ba oi wareaa tamanu.” ");
INSERT INTO wuv_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Ma ina aunulao a'a fei baua gigei fei gufu ma hemeadiai nanao na ma'apa'ia ma warenaa a'a ei rama'a yei, “Mena rama'a mena, ina gutafipui a'a Jesus, mei Nazareth.” ");
INSERT INTO wuv_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Ina warediai ba lomi ma na fa'unai ba, “Lomi una apa'aa mei rama'a mei!” ");
INSERT INTO wuv_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Lomi namina madii ma ei ro'aa ufalarai yei, rona nolao a'a Peter ma ware, “Pa'aa fa'ua ba yoi hemea ro'ou, uaa hai'ouna guai'apa'aa paolaa wareamu.” ");
INSERT INTO wuv_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Ma inawe umuaa anaia ma fa'unai a'a ro'ou, “Pa'aa lomi una apa'aa mei rama'a mei!” Ana ei ua, hepalo a'aroo na ai. ");
INSERT INTO wuv_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Ma Peter nawe nonomipa'aa ei wareaa Jesus: “Nene iwe ai fei a'aroo, o'aa wareaa fei fa'odupoaa wareamu ba lomi ona apa'au.” Ma ina dinaa ano ma namina aifafelo. ");
INSERT INTO wuv_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Mafufuo badu minaa ei famamoaa humuu mei Haidaa mawe ei bauaniaa gufu ronawe ware ba ronei aunaa Jesus ma'ea. ");
INSERT INTO wuv_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Rona faroro'inia, taudugia ma aunaa hia panii Pilate, mei gavanaa. ");
INSERT INTO wuv_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","I'a fanunupa'ia Judas, mei na aloia, ba rona ware ba nei ma'e Jesus, inamina faloloa'i ma na auhadiwe'inaa ei odufua pa'ania mugoo po'i silver a'a ei famamoaa humuu mei Haidaa mawe ei bauaniaa gufu. ");
INSERT INTO wuv_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Ina ware ba, “Yau, una bigifafelo, uaa una aloaa hemea ma'ea ma lomi hafelo'ana.” Rona ware, “Abaa manumanuu hai'odu! Uaa manumanumu.” ");
INSERT INTO wuv_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Si'ei, Judas na siminaa ei mugoo po'i laloo fei humuu mei Haidaa ma aunu. I dii, ina nolao ma re fahabe. ");
INSERT INTO wuv_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Ei famamoaa humuu mei Haidaa, rona hau'aa ei mugoo po'i ma ware, “Lomi na rawani a'a fei law nabaa o'aa augia laloo fei ude'udee ei mugoo po'i, uaa na udia raraa mei ma'ea.” ");
INSERT INTO wuv_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Si'ei, ronawe ware ba ei mugoo po'i ei nei pono'aa hepalo malagufu fawelei rona'o bigi'aa ei babagii ma ipowe oanaa huapuu ei rama'aa hepapa gufu. ");
INSERT INTO wuv_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Sifei, fei pa'afina ba nopa'amii wagieni rona'o ware ba Malagufu Raraa. ");
INSERT INTO wuv_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Ma fei diwareaa Jeremiah, mei mamama'a nawe fa'uai: “Rona tonaa ei odufua pa'ania mugoo po'i silver, ei rona augia ei Israel ba pono'ana ");
INSERT INTO wuv_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","ma a'a fei, rona pono'aa fei malagufu, fawelei rona'o bigi'aa ei babagii, ana ale'ei tamanu mei Fasu na ware ba unei bigi'ia.” ");
INSERT INTO wuv_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Ma ei, Jesus na u i ma'aa mei gavanaa ma mei gavanaa na i'igainia, “Haa, yoi, mei haparaa ei Jew?” Jesus na ware, “Hi'i, ana ale'ei ona wareia.” ");
INSERT INTO wuv_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Ro'aa ware ei famamoaa humuu mei Haidaa mawe ei bauaniaa gufu ba ina bigifata, lomi ina wareware. ");
INSERT INTO wuv_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Ma Pilate na i'iginia, “Ona guainia ei u'ufafeloaa ro'ou yoi?” ");
INSERT INTO wuv_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Ma'uaa Jesus lomi na wareware, pa'aa lomi na ware a'a hepalo hafelo'a wareaa ro'ou—ma namina maduofo wagina mei gavanaa. ");
INSERT INTO wuv_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Ma wagii fei au Hananaa, fei maumau mei gavanaa ba i alafalele'anaa nemea i laloo humuu bobo'aia, nemea rona nunuminia ei gupuu rama'a. ");
INSERT INTO wuv_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","A'a fei au fei, rona pa'i hemea pa'aa hafelo'a i laloo humuu bobo'aia, harana Barabbas. ");
INSERT INTO wuv_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Si'ei, ro'aa figupuidigimai ei rama'a, Pilate na i'iginaa ro'ou, “Hini lagua ba a alafalele'ania a'a hamu'ou: Barabbas, o Jesus, mei rona roroinia ba Christ?” ");
INSERT INTO wuv_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Uaa ina aidadii ba ei ro'aa fifaninaa Jesus panina, si'ei ba rona punepune. ");
INSERT INTO wuv_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Ei i guta pafoo fei gutanaa mei fadududua Pilate, mei harona na alonaa a'ana feni ne'ia feni: “Apuna bigi'aa hepalo manumanu a'a mei wanewanea, uaa laloo fei mefiu wagieni, namina fi'i tabau uaa hia.” ");
INSERT INTO wuv_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Ma'uaa ei famamoaa humuu mei Haidaa mawe ei bauaniaa gufu, rona u'ugainaa ei gupuu rama'a ba Barabbas nei lele'aa ma Jesus nei ma'e. ");
INSERT INTO wuv_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Na i'igai mei gavanaa, “Hini lagua hamona nunuminia ba a alafalele'afanaa hamu'ou?” Rona ware, “Barabbas.” ");
INSERT INTO wuv_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Pilate na i'igai, “Ma a bigi'aa tamanu a'a Jesus, mei rona roroinia ba Christ?” Minaa ro'ou, rona ware ba, “Fatawaia!” ");
INSERT INTO wuv_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Pilate na i'igai, “Hamatani? Tamanu fei bigifatatana?” Ma'uaa, rona haropararai'apoi, “Fatawaia!” ");
INSERT INTO wuv_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","I'a fanunupa'ia Pilate ba lomidiai ma'atalana ma fei gupuu rama'a fipowe asi'aa fei sibaa ro'ou, ina tonaa fei ranu ma na fesuaa panina i pudaa ro'ou. Ma na ware, “Lomi na pa'i tatau a'a ei raraa meni wanewanea. Manumanuu hamu'ou!” ");
INSERT INTO wuv_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Minaa ei rama'a, rona ware, “Ei rarana, na udenaa pafoo hai'ou mawe ei na'uu hai'ou!” ");
INSERT INTO wuv_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Ma ina alafalele'anaa Barabbas a'a ro'ou. Ma'uaa ina ware ba ei maroana, ronei babuinaa Jesus ma ina fifaninaa panii ro'ou ba ronei fatawaia. ");
INSERT INTO wuv_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Ma ei rama'aa fo'aa mei gavanaa, rona tauduginaa Jesus i laloo fei Praetorium ma minaa ei rama'aa fo'aa, rona ufaweloinia. ");
INSERT INTO wuv_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Rona dudufa'ala'alaia ma hawainia a'a hepalo hawaa ugu ina ro ");
INSERT INTO wuv_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","ma rona fifigifipuinaa ei wowo'ii na hogia ale'ei tao hapara ma rona aunaa tabana. Rona augaa hepalo o i panina pepei ma'au, fa'unaa du'uu ro'ou ma'ana ma hararasinia. Rona ware, “Hagu'u, mena haparaa ei Jew!” ");
INSERT INTO wuv_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Rona huwia, tonaa fei o ma hafuhafugaa tabana. ");
INSERT INTO wuv_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Ro'aa hararasidigia, rona dudumaa fei hawaa ugu ma farafehadiwe'inaa hia ana ei susuna. Ma rona aunudugia ba ro'aa fatawaia. ");
INSERT INTO wuv_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Ei ro'ei asi'alao, rona nobapa'aloo hemea Cyrene, harana Simon ma rona augaa fei hawafolo foreforena ba nei harenia. ");
INSERT INTO wuv_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Rona nomai fawelei, Golgotha (hanuna ba Na'ana'a Guitaba). ");
INSERT INTO wuv_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Fawelei, ba ro'aa fahunumaa Jesus fei wine, fei rona fihafuinia a'a fei ranuu ei para'aa fua; ma'uaa, i'a hunuma'aia, lomi na nunuminia. ");
INSERT INTO wuv_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Ro'aa fatawadigia, rona fi'alaginaa ei susuna a'a hepalo uni'uni fifigaia. ");
INSERT INTO wuv_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Rona guta'oma'aia yei. ");
INSERT INTO wuv_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","I palalaa fei tabana rona ne'i'augaa feni ba tatana: ");
INSERT INTO wuv_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Laguei fafanao, laguna fatawafipui a'ana, hemea i ma'auna ma hemea mauwina. ");
INSERT INTO wuv_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Ei rama'a, ei rona talailao nana'ana, rona warefafeloia, bi'oreinaa tabaa ro'ou ");
INSERT INTO wuv_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","ma ware, “Yoi, mena ba o birosiaa fei humuu mei Haidaa ma fadudinia laloo oduai arewaa, onei fatela'anio! Upumai a'a fena hawafolo nabaa yoi mena Na'uu mei Haidaa!” ");
INSERT INTO wuv_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Ana ale'ei, ei famamoaa humuu mei Haidaa, ei feroiaa law mawe ei bauaniaa gufu, rona hararasinia. ");
INSERT INTO wuv_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","Rona ware, “Ina fatela'anaa hefi'a, ma'uaa, lomi ba i fatelapa'aa anaia! Hia Haparaa Israel! Inei upumai a'a fei hawafolo ma o'awe nara ba fa'ua wareana. ");
INSERT INTO wuv_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Ina narafawe'i a'a mei Haidaa. Na rawani ba mei Haidaa nei fatela'ania e'eni nabaa ina nunuminia, uaa ina ware, ‘Yau Na'uu mei Haidaa.’” ");
INSERT INTO wuv_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Ana ale'ei, laguei fafanao, laguei laguna fatawafipui a'ana, laguna warefafeloia. ");
INSERT INTO wuv_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Haloaina nopa'aloo fei fa'oduaiaa ido'o, minaa ei gufu tadiwe'ai na roroma. ");
INSERT INTO wuv_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Ale'ena fei fa'oduaiaa ido'o, Jesus na aipararai, “Eloi, Eloi, lama sabachthani?”—hanuna ba, “Mena Haidaniau, mena Haidaniau, tani o ofadugau?” ");
INSERT INTO wuv_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Hefi'a ei ro'aa ufalarai yei, ro'aa guainaa fei, rona ware, “Ifi harofaa Elijah.” ");
INSERT INTO wuv_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Ana ei ua, hemea na ponilao ba i tonaa fei fahununu, fei i fahununaa fei wine a'a fei ranuu ei para'aa fua, na fasuia a'a hepalo haihai ma roainalao a'a Jesus ba nei hunumia. ");
INSERT INTO wuv_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Ma ei ro'ou, rona ware, “Di'ininia ma o fanunu ba i nomai Elijah mi hadumana.” ");
INSERT INTO wuv_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Ma i'a aiparararaidiai Jesus, ina fanaa fei spiritina. ");
INSERT INTO wuv_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Ana a'a fei au fei, fei rapirapi i laloo fei humuu mei Haidaa na aninirai pafea ma dinaa pu. Fei malagufu na rere ma ei mugoo, rona afala. ");
INSERT INTO wuv_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Ei nopaa ei ma'ea na ba'agigi ma ei unuu watauda ma'ea, ei rona apunai, rona asi'atodiai harenuaa ro'ou. ");
INSERT INTO wuv_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Rona asi'amai a'a ei nopaa ei ma'ea ma nenee fei asi'anaa Jesus, rona aununaa a'a fei gufu na apunai ma ina fa'arewa a'a watauda rama'a. ");
INSERT INTO wuv_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Mei centurion mawe ei ro'ei oma'afipuinaa Jesus a'ana, ro'aa fanunuaa fei rereaa malagufu mawe minaa ei manumanu, ronamina ma'au ma rona ware, “Pa'aa fa'ua ba hia, Na'uu mei Haidaa!” ");
INSERT INTO wuv_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Watauda pifine yei, ro'ei fanunumai raua ma'ida. Rona neneraa Jesus ei i norai Galilee ba ro'aa hadumia a'a ei nunumiana. ");
INSERT INTO wuv_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Dupuaa ro'ou, Mary Magdalene, Mary mei inaa James ma Joses ma mei inaa ei na'uu Zebedee. ");
INSERT INTO wuv_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","I nopoilao, ina nomai hemea rama'a watauda mugoo po'ina, gufuna Arimathea, harana Joseph, mei ana hia, nawe neneraa Jesus e'eni. ");
INSERT INTO wuv_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Ina aunu ma i'iginaa Pilate ba nei fania fei unuu Jesus ma Pilate na ware ba ei maroana, ronei fania. ");
INSERT INTO wuv_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Joseph na tonaa fei unu, fahawainia a'a hepalo lawalawa linen lomi na loloa ");
INSERT INTO wuv_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","ma naree fahainopia laloo fei manufau nopaa ma'ea fei bigi'augana a'a ei na'ana'a. Ina pigu'augaa hepalo baua mugoo i ma'aa fei wawadu'ii fei nopaa na'ana'a ma ina aunu. ");
INSERT INTO wuv_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Mary Magdalene mawe hemeadiai Mary, laguna guta oma'anaa fei nopaa ma'ea. ");
INSERT INTO wuv_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","I'a nofidunaranilao, hefei arewaa nenee fei Sabbath, ei famamoaa humuu mei Haidaa mawe ei Pharisee, rona aunu ba ro'aa ma'a Pilate. ");
INSERT INTO wuv_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Rona ware, “Hagu'u, hai'ouna nonominia ba ei fi guta mei rama'aa sifisifi, ina ware ba, ‘Nenee oduai arewaa, awe asi'adiai.’ ");
INSERT INTO wuv_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Hee, onei warefanaa ei maroamu ba ronei oma'afarawaninaa fei nopaa ma'ea hawina fei fa'oduaiaa arewaa. Nabaa lomi, woro naraa hai'ou ba ei otalai nenerana, rowe nomai ma topa'ainaa fei ununa ma warefanaa ei rama'a ba na ma'elele'aa a'a ei ma'ea. Ma ei sifisifii ro'ou, ipowemina apoidiai laraa ei sifisifii ro'ou fama'a.” ");
INSERT INTO wuv_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Pilate na ware, “Dugaa hefi'a oanananaa. Wi lawagifarawaninaa fei nopaa ma'ea ale'ei apa'aa hamu'ou.” ");
INSERT INTO wuv_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Si'ei, ronaree lawaraa fei nopaa ma'ea a'a hepalo tamatama pafoo fei mugoo ma fa'ugaa ei oanananaa. ");
INSERT INTO wuv_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Nenee fei Sabbath, i ba'apanii fei rawarawa arewaa wagii fei hefapagipagia, Mary Magdalene mawe mei ana hemeadiai Mary, laguna aunu ba lagu'aree ma'a fei nopaa ma'ea. ");
INSERT INTO wuv_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Inamina rerere fei malagufu, uaa hemea alo'aloo mei Fasu na upugio i pafea, na dinaa a'a fei nopaa ma'ea, piguaa fei mugoo ma guta pafona. ");
INSERT INTO wuv_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Fei maumauna ale'ei usida ma ei susuna namina po'imalewa. ");
INSERT INTO wuv_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Ei oanananaa, ronamina ma'aufunurere a'ana ma ro'ou ale'ei ma'ea rama'a. ");
INSERT INTO wuv_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Mei alo'alo na warenaa a'a laguei pifine, “Apuna ma'au, uaa una aida ba hamu'ei labaginaa Jesus, mei rona fatawaia. ");
INSERT INTO wuv_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Hia, lomi yeni; ina asi'adii, ana ale'ei ei wareana. Mido'o ma'a feni nopana. ");
INSERT INTO wuv_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Ma aunubatafa ma re warefanaa ei otalai nenerana ba: ‘Ina asi'adii a'a fei ma'ea ma fi aunulao i ma'aa hamu'ou yei Galilee. Hamowe ma'aia yena.’ Te, una warefanidigaa hamugua.” ");
INSERT INTO wuv_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Si'ei, laguei pifine, laguna di'inibatafainaa fei nopaa ma'ea; laguna ma'au, ma'uaa, ana lagunamina ni'eni'e ma poni ba lagu'aa warefanaa ei otalai nenerana. ");
INSERT INTO wuv_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Ana ei ua, Jesus na bapa'aa lagua. Ina ware, “Mafufuo.” Laguna nomai a'ana, panarofaa pinena ma laguna losuinia. ");
INSERT INTO wuv_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Ma Jesus na warenaa a'a lagua, “Apuna ma'au. Wi warefanaa ena lofuu ba ronei dinaa Galilee; rowe fanunuau yena. ");
INSERT INTO wuv_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Ei lagu'ei tatalailao laguei pifine, hefi'a ei oanananaa, rona wadu'ainaa fei baua gufu ma u'ufanaa ei famamoaa humuu mei Haidaa minaa ei manumanu rona fanunuia. ");
INSERT INTO wuv_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Ro'aa fiwarewareidii ei bauaniaa gufu ma ei famamoaa humuu mei Haidaa, rona pa'apa'ainaa hepalo naranara ma fanaa ei fo'aa watauda mugoo po'i. ");
INSERT INTO wuv_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","Ma rona warefanaa ro'ou, “Hamonei ware ba, ‘Ei otalai nenerana, rona nomai poi ei hamo'ei ma'igu ma poropa'ainia.’ ");
INSERT INTO wuv_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Nabaa i guainaa fei u'ugaa fei mei gavanaa, ipowe rawani a'ana ma lomi ba hamo'aa tonaa dududua wagina.” ");
INSERT INTO wuv_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Si'ei, ei rama'aa fo'aa, rona tonaa ei mugoo po'i ma bigi'ia ale'ei rona guainia. Ma fei u'uga fei, na talenaa a'a watauda gufu dupuaa ei Jew a'a fei au fei nopa'amii wagieni. ");
INSERT INTO wuv_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Ma ei hefua ma hemea otalai nenerana, rona aununaa Galilee a'a fei maugeni, fei na ware Jesus ba ronei dinaa wagina. ");
INSERT INTO wuv_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Ro'aa ma'apa'ia, rona losuinia; ma'uaa, hefi'a, rona hamamagua. ");
INSERT INTO wuv_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Ma Jesus na nomai a'a ro'ou ma ware, “Minaa ei faufau i pafea ma yeni malagufu ina fanidigau. ");
INSERT INTO wuv_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Si'ei, hamonei aununaa a'a minaa ei gufu ma feroinaa ei rama'a ba ronei nenerau ma hamonei pudugufinaa ro'ou a'a fei haraa mei Ama ma mei Na'u ma fei Spiriti Apuna ");
INSERT INTO wuv_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","ma feroinaa ro'ou ba ronei neneraa minaa ei warefanau hamu'ou. Ma apowe oafipui a'a hamu'ou ranimai, nopa'aloo fei pedupeduu feni ano.” ");
INSERT INTO wuv_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Feni, fafasuii feni rawani'a wareaa Jesus Christ, mei Na'uu mei Haidaa. ");
INSERT INTO wuv_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Ale'ei i ne'inia mei mamama'a Isaiah: “A aloaa mena otalai tonaa wareau i ma'amu ma i ra'a'augaa fena talamu”— ");
INSERT INTO wuv_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","“Na haroharo fei lao i podu. ‘Ra'a'augaa fena talaa mena Fasu, ma fawanewane'augaa fena talana.’” ");
INSERT INTO wuv_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Si'ei, John na nomai ma pudugufinaa ei rama'a i podu. Ina warefanaa ei rama'a ba ronei filoginaa naranaraa ro'ou ma pudugufai ma i futoaa ei hafelo'aa ro'ou, mei Fasu. ");
INSERT INTO wuv_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Minaa ei rama'a tadiwe'aiaa Judea ma Jerusalem, rona dinaa a'a John. Ei rona warefania ei hafelo'aa ro'ou, John na pudugufinaa ro'ou i laloo fei Ranu Jordan. ");
INSERT INTO wuv_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","John na susuinaa fei susu, bigi'aa ro'odu hugo camel ma fei adina, hudii manulelele. Ma hanana, ena teraupu ma musilao podu. ");
INSERT INTO wuv_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Ma sifeni, feni wareana: “I pa'i hemea rama'a i nomai neneu, na faufaudiai ma na muainau. Yau ana lomi na rawani ba a fabalou ma alaraa fei hafenaa pinena. ");
INSERT INTO wuv_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Yau na pudugufinaa hamu'ou ranu ma hia, i pudugufinaa hamu'ou fei Spiriti Apuna.” ");
INSERT INTO wuv_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Ma fei au fei, Jesus noranamai Nazareth, yei Galilee. Ma John na pudugufinia laloo fei Ranu Jordan. ");
INSERT INTO wuv_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Ei fi asi'aa laloo fei ranu Jesus, na fanunuaa fei gufu pafea na ba'agigi ma fei Spiriti fi falorogio pafona maumauna ale'ei pune. ");
INSERT INTO wuv_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Ma fei haroharofa norai yei gufu pafea, na ware ale'ei: “Yoi, mena na'uu, mena una haguio ma namina ni'eni'e a'amu.” ");
INSERT INTO wuv_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Si'ei, fei Spiriti na alonaa Jesus i tau podu. ");
INSERT INTO wuv_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Jesus na guta laloo podu gunaroa pa'ania arewaa ma Satan ana fi manimania yei laloo podu. Jesus na guta hugiaa ei manulelele laloo podu ma ei alo'alo, rona oma'ama'aia yei. ");
INSERT INTO wuv_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Nenee fei ro aunaa John humuu bobo'aia, Jesus na dinaa Galilee, wareaa fei rawani'a warea noranarai a'a mei Haidaa. ");
INSERT INTO wuv_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Ina ware ba “Pa'aa feni auna feni. Fei haparaiaa mei Haidaa na rafi'i. Filoginaa naranaraa hamu'odu ma neneraa eni rawani'a warea!” ");
INSERT INTO wuv_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Ei fi tatalai adii fei Agii Galilee Jesus, ina fanunupa'aa Simon ma mei lofuna, Andrew. Lagu'ei sumai lepo agi, uaa lagua dia'agi. ");
INSERT INTO wuv_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Jesus na warenaa a'a lagua, “Nomai ma nenerau. Ma a feroinaa hamugua tonaa rama'a ale'ena hamuna'o to nia.” ");
INSERT INTO wuv_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Ana ei ua, laguna di'augaa ei lepoo lagua ma neneraa Jesus. ");
INSERT INTO wuv_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Ei fi tatalaidilao ma'idadiai adii fei Agii Galilee, na fanunupa'aa laguei filofui James ma John, laguei na'uu Zebedee. Lagu'ei hinu'aa ei lepoo lagua laloo fei wa. ");
INSERT INTO wuv_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Si'ei, na haro fawanewaneinaa lagua. Ma laguna di'ininaa mei amaa lagua, Zebedee mawe ei tameloi ro'ou laloo fei wa ma laguna nenegia. ");
INSERT INTO wuv_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Rona aununaa Capernaum ma i nomai fei Sabbath, Jesus na dinaa laloo fei synagogue ma feroinaa ro'odu. ");
INSERT INTO wuv_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Ei rama'a, ronamina ba'arofo a'a ei feroiana, uaa na feroi ale'ei hemea na pa'i faufauna, abaa ale'ei ei feroiaa Law. ");
INSERT INTO wuv_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Ana ei ua, hemea rama'a laloo fei synagogue, mei na wadu'ia spiriti hafelo, na mewaiware, ");
INSERT INTO wuv_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","“Tamanu ei nunumiamu a'a hai'odu, Jesus, mena Nazareth? Ei o nomai ba o fo'afama'eaa hai'odu? Una apa'ia ba yoi hini. Yoi, mena Apunaiaa mei Haidaa!” ");
INSERT INTO wuv_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Jesus na ware, “Babanini ma wala'amai a'ana!” ");
INSERT INTO wuv_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Fei hafelo'a spiriti na nuenueinia ma memewai ma wala'aa a'ana. ");
INSERT INTO wuv_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Ei rama'a, ronamina naranara watauda ma fi'i'igai, “Tamanu feni? Hefeni manufau feroia na pa'i faufauna ma ei hafelo'a spiriti ana ronamina guaipa'aa wareana!” ");
INSERT INTO wuv_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Fei u'ugana namina talemaduarenaa ei gufu pedu yei Galilee. ");
INSERT INTO wuv_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Ei ro'aa di'ininaa fei synagogue, rona aunuhugiaa James ma John ma dinaa a'a fei gufuu Simon ma Andrew. ");
INSERT INTO wuv_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Mei inaa mei haroo Simon na funuhaino pafoo tawa. Ei rama'a yei, rona warefanaa Jesus ba na babai unuu mei rama'aa Simon. ");
INSERT INTO wuv_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Si'ei, Jesus na dinaa a'ana, tauaa panina ma fa'asi'ania. Fei funuana na pedu ma i dii, ina hasumaa ei hanaa ro'odu. ");
INSERT INTO wuv_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Fei fafi fei, i lolo fei halo, ei rama'a rona duginamii a'a Jesus ei rama'a rona pa'i funuaa ro'ou fipui a'a ei na wadu'aa ro'odu pigea. ");
INSERT INTO wuv_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Minaa ei rama'a yei, ronamina oma'a ua papaa fei gigei. ");
INSERT INTO wuv_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Jesus na farawaninaa funuaa watauda ma alofatatalainaa watauda pigea, ei rona wadu'aa ei rama'a. Ma ina apunainaa ei pigea ba ronei'aa wareware; uatani, rona aida ba hia hini. ");
INSERT INTO wuv_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Mafufuo badu, atawe arewafarawani, Jesus na asi'a'aununaa fawelei lomi rama'a ba i lafulafu. ");
INSERT INTO wuv_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Simon ma ei ro'ei tatalaifipui a'ana, rona aunu ma labaginia. ");
INSERT INTO wuv_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Ma ro'aa nobapa'alao, rona ware a'ana ba, “Minaa ei rama'a, roi lalabaginio!” ");
INSERT INTO wuv_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Jesus na ware a'a ro'odu, “O dii. O aununaa ena gufu opa'anawau ma ana a u'u yena. Si'ena, ena a nogio.” ");
INSERT INTO wuv_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Ma namina tatalai yei Galilee. Ina u'u laloo ei synagogue ro'ou ma alofatalainaa ei pigea. ");
INSERT INTO wuv_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Hemea watawatai na nomai a'ana, fa'unaa du'una ma i'iginia, “Na'aa inapo'o rawani a'amu, farawaninau.” ");
INSERT INTO wuv_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Namina bauanai fei faloloa'iaa Jesus. Si'ei, na roainaa panina, idoaa ununa ma ware, “Na rawani a'au. Ena unumu, i fafa'arai.” ");
INSERT INTO wuv_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Ana ei ua, na pedu ei watawatana ma na fafa'arai ei ununa. ");
INSERT INTO wuv_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Jesus na alofawanewaneinia ma warefawe'i a'ana, ");
INSERT INTO wuv_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","“Ma'aia. Apuna warefanaa nemea ma'uaa onei dinaa a'a mena bauaniaa humuu mei Haidaa ma fanaa ena fanamu wagina ale'ei i warefanio Moses, ale'ei uni'unina a'a ro'ou ba ona fafa'araidii.” ");
INSERT INTO wuv_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Agia, i nolao, fimina u'u'u ma fatalainaa fei rawani'aa Jesus a'ana. Si'ei ba ina u'u'u, fai lo'e ba Jesus i wadu'aifalelefo a'a hepalo gufu ma na guta u'ugai ua fawelei lo'e rama'a. Ma'uaa ei rama'aa ena tadiwe'aiaa gufu, ana roimina'u no'ualao a'ana. ");
INSERT INTO wuv_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Nenee hefi'adiai arewaa, ei i hadiwe'idinaa Capernaum Jesus, ei rama'a, rona guainia ba Jesus na nodigimai gufu. ");
INSERT INTO wuv_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Watauda, rona papa'ifigupuimai ma pa'aa lomi na hawiaa ro'odu fei laloo humu; namina pepesu. Auguu fei gigei, ana ronamina fihoroi. Ma ifi warefanaa ro'odu fei rawani'a warea. ");
INSERT INTO wuv_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Hefi'a, rona dugamii hemea rama'a na ma'e ununa. Gunaroa rama'a, rona notabeiamai. ");
INSERT INTO wuv_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Si'ei ba ronamina fihoroi, lomi rona noporopa'aloo mei rama'a a'a Jesus. Ro'adii, rona bigigiaa fei ha'oo fei humu, fawelei nana'aa Jesus. Mei rama'a i ma'e ununa, na haino pafoo fei hafenaa ununa ma rona fataularaiarai a'a Jesus. ");
INSERT INTO wuv_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","I ma'aia Jesus ba napa'aa we'i naranaraa ro'odu, na warenaa a'a mei i ma'e ununa, “Mena na'uu, ena hafelo'amu, una futoia.” ");
INSERT INTO wuv_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Fei au fei, hefi'a ei feroiaa law, ana rona guta hugiaa ro'odu. Ronamina naranara watauda. ");
INSERT INTO wuv_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Tani i ware ale'ei mei rama'a mei? Ina warefafeloaa mei Haidaa. Lomi hemea i futoaa ei hafelo'a. Ana unaa mei Haidaa.” ");
INSERT INTO wuv_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Ana ei ua, Jesus na aidadii ei naranaraa ro'odu. Ma ina warenaa a'a ro'odu, “Tani hamomina naranara ale'ei? ");
INSERT INTO wuv_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Afaia na maduta—fei una warenaa a'a mei i ma'e ununa ba, ‘Ei hafelo'amu na futoia,’ o fei una ware ba, ‘Asi'aa, tonaa fei hafenaa unumu ma talai’? ");
INSERT INTO wuv_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Ma'uaa si'ei ba hamonei aida ba mei Na'uu Rama'a, na pa'i faufauna yeni malagufu ba i futoaa ena hafelo'a . . .” Ina warenaa a'a mei i ma'e ununa, ");
INSERT INTO wuv_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“A ware a'amu, asi'aa, tonaa fei hafenaa unumu ma dinaa gufumu.” ");
INSERT INTO wuv_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Na asi'aa, tonaa fei hafenaa ununa ma talai i pudaa ro'ou ma di'ininaa ro'odu. Namina nanawala pudaa minaa ei rama'a ma rona uduginaa mei Haidaa. Rona ware ba, “Lomi ona ona'u fanunupa'i he'a manumanu ale'eni feni!” ");
INSERT INTO wuv_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Jesus na aunudinaa piye. Hefaa baua gupuu rama'a, rona nomai a'ana ma ina feroinaa ro'odu. ");
INSERT INTO wuv_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Ei fi talailao, na fanunupa'aa Levi, mei na'uu Alphaeus na guta a'a fei palee ei otonaa mugoo po'ii gavaman. Jesus na warenaa a'ana, “Nenerau.” Levi na asi'aa ma nenegia. ");
INSERT INTO wuv_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Ifi hanana gufuu Levi Jesus, wataudadiai ei otonaa mugoo po'ii gavaman ma ei hafelo'a rama'a, rona hananafipui a'ana mawe ei otalai nenerana, uaa watauda na nenegia. ");
INSERT INTO wuv_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Ro'aa fanunuia ale'ei ei feroiaa law, ei ro'ou Pharisee, rona i'igainaa ei otalai nenerana ba, “Tani i hananafipui a'a ei otonaa mugoo po'ii gavaman ma ei rama'a hafelo?” ");
INSERT INTO wuv_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","I'a guainaa fei, Jesus na warefanaa ro'odu ale'ei, “Abaa ena rona rawani ena ronei pa'i hemea lo'otaa, uaa ena rona pa'i funua. Eni a norai, abaa ei re labaginaa ena wanewanea, uaa ena hafelo'a rama'a.” ");
INSERT INTO wuv_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Ei otalai neneraa John ma ei Pharisee, rona fabao. Hefi'a rama'a, rona nomai ma i'iginaa Jesus ba, “Tani ipo'o biyei ba, ei otalai neneraa John ma ei otalai neneraa ei Pharisee, rona fabao ma'uaa ei otalai neneramu, lomi.” ");
INSERT INTO wuv_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Jesus na ware, “Nabaa hemea ba i lalai ma i bigi'aa hefaa hananaa, batanai ba ro'aa fabao ei i guta a'a ro'ou? ");
INSERT INTO wuv_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Ma'uaa iwe nomai fei au ba mei lalaia, lomi i guta a'a ro'ou, uaa hefi'adiai, rowe dugia. Ma a'a fena arewaa fena, rowe fabao. ");
INSERT INTO wuv_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","“Lo'e hemea ba i tawi'aa ei maninii ena manufau lawalawa ma waro'aa ei wara'aa watanai lawalawa. Nabaa i bigi'ia ale'ei, fei manufau maninii lawalawa, i rapudigeaa fei watanai lawalawa ma imina forafawara'a'apoidinia. ");
INSERT INTO wuv_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Ana lomi hemea rama'a i igiaa ei manufau wine a'a ei watanai pe'ii wine. Nabaa i bigi'ia ale'ei, fei manufau wine i fawara'aa fei pe'ii wine ma fei wine ma fei pe'ina, lagu'amina fai hafelo. Si'ei ba fei manufau wine, ana ronei iginaa laloo ei manufau pe'ii wine.” ");
INSERT INTO wuv_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Jesus ma ei otalai nenerana, ro'ei tatalai dupuaa fei pe'ii corn hefaa Sabbath ma rona hufu'aa ei corn. ");
INSERT INTO wuv_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Rona warenaa a'a Jesus ei Pharisee, “Ma'aia, ei otalai neneramu, rona barafeaa fei law laloo fei Sabbath.” ");
INSERT INTO wuv_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Ina warefanaa ro'odu, “Haa, lomi hamona igoaa tamanu David na bigi'ia ei hia ma ei maroana ro'aa bao ma rona pa'i nunumiaa ro'ou? ");
INSERT INTO wuv_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","A'a fei au Abiathar, mei pa'aa bauaniaa humuu mei Haidaa, David na wadu'ainaa fei humuu mei Haidaa ma na hanaiaa ei faraa pidaua, ei rona apunainaa a'a mei Haidaa ma lomi na rawani a'a fei law ba nemeadiai i tonia. Ma ana ina fanaa ei faraa pidaua a'a ei maroana. ");
INSERT INTO wuv_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Ma na ware Jesus, “Fei Sabbath, bigi'aa mei Fasu ba fararawanii rama'a ma a'a ba rama'a manumanuu fei Sabbath. ");
INSERT INTO wuv_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Uaa, mei Na'uu Rama'a, hia Fasu, ana Fasuu fei Sabbath.” ");
INSERT INTO wuv_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Hefaranidiai Jesus na wadu'ainaa fei synagogue ma na pa'i hemea na ma'e hepapa panina. ");
INSERT INTO wuv_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Hefi'a ei ro'eifane lalabaginaa ei tataa Jesus, ro'ou yei. Ronamina pupudainaa Jesus, ba i farawaninia laloo fei Sabbath, o? ");
INSERT INTO wuv_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Jesus na warenaa a'a mei rama'a, “Mi ufalarai i ma'aa ro'ou.” ");
INSERT INTO wuv_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Ma na i'iginaa ei rama'a Jesus ba, “Fei law na ware ba tamanu na rawani a'a fei Sabbath? Fei ba o bigi'aa ei rawani'a, o ei hafelo'a? Ba o hadumaa rama'a, o fafeloaa rama'a?” Ma'uaa lomi rona'u ware. ");
INSERT INTO wuv_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","I fanunuaa ei maumau ro'ou ale'ei Jesus, namina sibafafelo ma'uaa ana namina faloloa'inaa ro'odu, uatani, namina waiwai tabaa ro'odu ma ana ronamina tata. Si'ei na warenaa a'a mei rama'a, “Roainamai panimu.” Na roainaa panina mei rama'a ma fei panina na rawanidiai. ");
INSERT INTO wuv_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","I dii, ei Pharisee, rona asi'aa a'a fei synagogue ma re gutafipui a'a ei maroaa Herod ma pagipagiaa hefi'a tala ba ro'aa fo'afama'eaa Jesus. ");
INSERT INTO wuv_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Jesus ma ei otalai nenerana, rona aununaa agi. Ma hefaa baua gupuu rama'a, noramiaa ro'ou Galilee, rona talaineneraa Jesus. ");
INSERT INTO wuv_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Ro'aa guainaa minaa ei bigi'aa Jesus, rona nomai a'ana. Gufuu hefi'a, Judea, Jerusalem ma Idumea; ma gufuu hefi'a, yei pepei anaa halo i Jordan ma hefi'a, fawelei Tyre ma Sidon. Minaa eni rama'a eni, rona nomai a'a Jesus, uatani ronamina guainaa tamanu ina bigi'ia. ");
INSERT INTO wuv_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Ei rama'a, ronamina watauda. Si'ei ba namina rata fei gupuu rama'a, ina ware a'a ei otalai nenerana ba ronei rapu'augamiaa hepalo wa, ba ronei'aa puroroinia ei rama'a. ");
INSERT INTO wuv_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Uaa namina farawanidigaa watauda rama'a a'a ei funuaa ro'odu. Ei funua, ro'ei nigo talaa ro'odu ba ro'aa dinaa a'a Jesus ma idoia. ");
INSERT INTO wuv_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Ei rona'o fanunupa'aa Jesus ei spiriti hafelo, rona'o fapasinaa pu i ma'ana ma aiharoharo, “Yoi, mena Na'uu mei Haidaa.” ");
INSERT INTO wuv_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Ma'uaa Jesus na warefawe'i a'a ei spiriti hafelo ba apuna warefanaa nemea ba hia hini. ");
INSERT INTO wuv_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Jesus na dinaa papaa hepalo maugeni ma harofaa ei nunumiana ma rona dinaa a'ana. ");
INSERT INTO wuv_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Ina rafeinaa hefua ma helagui—ma roroinaa ro'odu apostle — ba ronei oafipui a'ana. Ma ba i aloaa ro'odu ba ronei wareaa fei rawani'a warea ");
INSERT INTO wuv_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","ma ro'aa pa'i faufau ba ro'aa fa'asi'anaa ei pigea. ");
INSERT INTO wuv_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Si'eni, eni rafeiaa Jesus: Simon (Jesus na roroinia Peter); ");
INSERT INTO wuv_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","James ma mei lofuna John, laguei na'uu Zebedee (Jesus na roroinaa lagua Boanerges, hanuna ba laguei Na'uu Parara); ");
INSERT INTO wuv_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Andrew, Philip, Bartholomew, Matthew, Thomas, James mei na'uu Alphaeus, Thaddaeus, Simon mei Zealot (hanuna ba na haguaa gufuna), ");
INSERT INTO wuv_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","ma Judas Iscariot, mei i aloaa Jesus. ");
INSERT INTO wuv_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","I dii, Jesus na wadu'ainaa hepalo humu ma wataudadiai, rona figupui yei. Si'ei Jesus ma ei otalai nenerana, lo'e rona hawia ba ro'aa hanana. ");
INSERT INTO wuv_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Ro'aa guainia ei maroana, rona aunu ba ro'aa dugia, uaa rona ware ba, “Ina poapoai tabana.” ");
INSERT INTO wuv_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Ma ei feroiaa law, ei noramiaa ro'odu Jerusalem, rona ware ba, “Ina wadu'ia Beelzebub. A'a fei faufau mei fafasui ei pigea, inafane fa'asi'anaa ei pigea.” ");
INSERT INTO wuv_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Si'ei na harofaa ro'odu Jesus ma warehanunuinia ba, “Batanai Satan i fa'asi'anaa Satan? ");
INSERT INTO wuv_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Nabaa hepalo gufu i fifalagii, fei gufu fei, lo'e i ufalarai. ");
INSERT INTO wuv_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Nabaa hepalo humu i fifalagii, fei humu fei, lo'e i ufalarai. ");
INSERT INTO wuv_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Nabaa Satan na ofadugaa anaia ma hia i fifalagii, lomi i ufalarai ma fei auna na pedudii. ");
INSERT INTO wuv_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Pa'aa fa'ua, lomi hemea i wadu'inaa humuu hemea faufau rama'a ma topa'ainaa ei manumanuna. Ineido'o roro'inaa mei faufaua ma hinene iwe topa'ainaa ei manumanu humuna. ");
INSERT INTO wuv_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Apa'aa warefa'uai a'a hamu'odu ba minaa ena hafelo'a ma ei rona warefafeloaa mei Haidaa, hia, i futoia. ");
INSERT INTO wuv_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Ma'uaa hini i warefafeloaa fei Spiriti Apuna, fei hafelo'ana lomi i futo. Ina bigi'aa hefaa hafelo'a lomi i pedutoo.” ");
INSERT INTO wuv_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Ina wareaa feni, uaa roimina wareware ba, “Ina taoia hefaa hafelo'a spiriti.” ");
INSERT INTO wuv_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Si'ei rona nomai, mei inaa Jesus ma ei lofuna. Rona u yei ano ma aloaa hemea ba neiree dugamii Jesus. ");
INSERT INTO wuv_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Watauda ronamina guta hoaninaa Jesus ma warefania ba, “Mei inamu ma ei lofumu, ro'ou i ano ma roi lalabaginio.” ");
INSERT INTO wuv_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Na i'igai Jesus ba, “Hini mei inau ma ei lofuu?” ");
INSERT INTO wuv_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","I dii, ina fanunuaa ei rama'a, ei rona guta hoaninia ma na ware, “Si'eni, eni inau ma lofuu! ");
INSERT INTO wuv_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Hini ena rona bigi'aa ei nunumiaa mei Haidaa, si'ena, ena lofuu, agiu ma inau.” ");
INSERT INTO wuv_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Jesus fi feroidinaa ei rama'a yei piye ma abaa po'o ma'ida ei rama'a. Si'ei, Jesus na hugi pafoo wa ma na guta pafona laloo agi. Ma ei rama'a, rona guta piye. ");
INSERT INTO wuv_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Jesus na warehanunuinaa watauda manumanu ei fi feroinaa ro'odu. ");
INSERT INTO wuv_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Hamu'ou guai! Na pa'i hemea rama'a ba i sumai lau i pe'ihape. ");
INSERT INTO wuv_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Ma ei fi suminaa ei lau, hefi'a rona pasi papaa tala ma rona fidumai ei manufidufidu ma rafahanaia. ");
INSERT INTO wuv_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Ma hefi'a na pasi pafoo fawelei na pa'i na'ana'a ma lo'e namina pi'odua fei piye, si'ei ronamina habe maduare ei lau. ");
INSERT INTO wuv_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Ma i notautarerai fei halo, na babai ma na faholeaa ro'odu ma rona ma'e, uatani lo'e na pa'i waraa ro'odu. ");
INSERT INTO wuv_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Ma hefi'a lau, rona pasi dupuaa ei wowo'ii, ei rona hogia ma ei wowo'ii na fifigaa ro'odu ma si'ei, lomi rona fuaa. ");
INSERT INTO wuv_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Ma hefi'adiai lau na pasi fawelei na pa'i farawani piye ma ronamina habe mamaugi ma ronamina fuaa farawani. Hefi'a, fuaa ro'odu, odufua pa'ania; hefi'a, fuaa ro'odu oloroa pa'ania; ma hefi'a, hefa pu'u.” ");
INSERT INTO wuv_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Na warefanaa ro'odu Jesus, “Hini na pa'i adiana nei guainia.” ");
INSERT INTO wuv_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Ma ei do'o uniaa Jesus, ei Hefua ma Helagui mawe hefi'adiai, rona i'igainaa Jesus hanuu fei warehanunuiana. ");
INSERT INTO wuv_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Jesus na warefanaa ro'odu, “Na unifanidigaa hamu'ou ei manumanu na ude'opa'ai a'a fei haparaiaa mei Haidaa. Ma minaa ei abaa maroaa o'odu, rona guai'uaia ale'ena warea hanunu. ");
INSERT INTO wuv_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Si'ei ba i ale'ei, “‘Ro fanunu ma fanunu ma'uaa, lomi ro'aa fanunupa'i, ma ro guguai ma'uaa lo'e ro'aa apa'ia. Ma nabaa rona aida, ro'aa filoginaa ei naranaraa ro'odu ma hadiwe'inaa a'a mei Haidaa ma mei Haidaa, i futoaa ei hafelo'aa ro'odu.’” ");
INSERT INTO wuv_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","I dii, Jesus na warenaa a'a ro'odu, “Haa, lomi hamona aida fei warea hanunu? Batanai ba hamo'aa apa'aa hefi'adiai warea hanunu? ");
INSERT INTO wuv_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Mei faroa na fafufugu'aa fei warea. ");
INSERT INTO wuv_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Hefi'a rama'a, ale'ena ei lau na pasi ma'aa tala, fawelei na faro fei warea. Ana ei ro'aa guainia na nomai Satan ma tosiminaa ei rawani'a warea laloo iaa ro'odu. ");
INSERT INTO wuv_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Hefi'a ale'ena ei lau na pasi pafoo ei na'ana'a. Rona tonaa fei rawani'a warea ma ronamina ni'eni'e. ");
INSERT INTO wuv_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Ma'uaa si'ei ba lomi na gugu waraa ro'odu, lo'e na madii ma i bapa'aa ro'odu ei hafelo'a o ei haperararaia wagii fei wareaa mei Haidaa, rona rawa'a'afai batafa. ");
INSERT INTO wuv_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Hefi'adiai, ale'ena ei lau na pasi dupuaa ei wowo'ii, ei rona hogia. Rona guainaa fei warea, ");
INSERT INTO wuv_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","ma'uaa ronamina naranara watauanaa fei gutanaa ro'odu ma naranara watauda ba ronei pa'i watauda manumanu ma nanamainaa watauda manumanu ma ei manumanu ei, na hawai'onaa fei rawani'a warea ma lomi rona fuapa'i. ");
INSERT INTO wuv_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Ma'uaa hefi'a rama'a, ale'ena ei lau, ei ro'aa pasi pafoo fei rawani'a piye. Rona guainaa fei warea ma rona tonia. Rona habe ma fuaa. Hefi'a, fuaa ro'odu, odufua pa'ania; hefi'a, oloroa pa'ania; hefi'a, hefa pu'u—ei fuaa ro'odu.” ");
INSERT INTO wuv_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Na warenaa a'a ro'odu Jesus, “Ei hamona'o tonaa fei we'ai, hamona augia haroo hepalo hagi, o haroo tawa? Lo'e, hamona'o augia pafoo tawa. ");
INSERT INTO wuv_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Ma'uaa, tamanu manumanu na opa'ai, hinene iwe udelelefo. Minaa ena manumanu rona aupa'ainia ena rama'a, iwe ude'arewa'ua. ");
INSERT INTO wuv_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Hini na pa'i adiana nei guania.” ");
INSERT INTO wuv_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Na waredilao Jesus, “Narama'aiaa tamanu ei guaiaa hamu'odu. Hefiga ei fanamu, ana ale'ena ona tonia ma wataudadiai. ");
INSERT INTO wuv_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Hini i pa'i manumanuna, iwe to hefi'adiai. Ma mei lomi manumanuna, tamanu ma'idei na pa'i, mei Haidaa iwe tonia a'ana.” ");
INSERT INTO wuv_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Ma ana ina ware, “Ale'eni maumau fei haparaiaa mei Haidaa. Hemea rama'a fi sumaitalaneneneinaa ei lau i pe'ihapena. ");
INSERT INTO wuv_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Minaa ei poi ma arewaa, na'aa ina ma'igu o lo'e, ei lau, rona nusu ma habe ana ro'ou; ma mei rama'a mei, lomi na aida batanai ro'ei nusu. ");
INSERT INTO wuv_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Fei piye ua, fei i fahabeia—rawarawa fei pa'apa'a na sunai; nene, fei obana; ma laloo fei oba, ei launa. ");
INSERT INTO wuv_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Ma i we'idii ei fuana, mei rama'a na balainia ma hufu'aa ei fuana, uaa napa'aa fei au hufu'a.” ");
INSERT INTO wuv_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Jesus na warediai, “O ware ba tawi'aa fei haparaiaa mei Haidaa ale'ei tamanu? O hanunuinia a'a tamanu? ");
INSERT INTO wuv_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Tawi'ana ale'ena fei lau mustard, fei na pa'aa pusu'oroi laraa ei lau yeni malagufu. ");
INSERT INTO wuv_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Ma'uaa, ei ro'aa faroia, na habe bauanai. Namina bauanaidi'ininaa minaa ei haihai laloo pe'ihape. Ei rarana namina bauanai. Si'ei, ei manufidufidu na'aida guta a'a fei giogiona.” ");
INSERT INTO wuv_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Watauda ei mau warea hanunu Jesus nafane hawawagifanaa ei rama'a, ei na hawia ba ro'aa apa'ia. ");
INSERT INTO wuv_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Ma lo'e ina wareaa hepalo manumanu a'a ro'odu ba lo'e na hanunuinia. Ei unaa ro'ou ei otalai nenerana, Jesus na ware'italalafuinaa minaa ei manumanu. ");
INSERT INTO wuv_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Fei arewaa fei, i nofafilao, na ware a'a ei otalai nenerana ba, “O dii, o dinaa pepei.” ");
INSERT INTO wuv_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Rona di'ininaa ei watauda rama'a ma fatalenodugaa Jesus pafoo fei wa, fei na hugidii pafona ma aunu. Ma ana na pa'i hefi'adiai wa rona aunufipui a'ana. ");
INSERT INTO wuv_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Ma ina una'aa fei baua lalarena ma fei agi na fuama'i'i ma na rata fei lama ma na fuama'i'inaa laloo fei wa ma anaa i lolo. ");
INSERT INTO wuv_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Jesus na ma'igu i mugi pafoo hepalo duduna. Ma rona funifunia ei otalai nenerana. “Feroia, lomi ona narapa'aa o'odu ba o'aa wawau'u?” ");
INSERT INTO wuv_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Na asi'aa ma warenaa a'a fei lalarena ma fei lama ba “O famadumu.” Fei lalarena na rere ma fei lama namina madino. ");
INSERT INTO wuv_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Si'ei na warenaa a'a ei otalai nenerana ba, “Tani hamo'amina ma'au ale'ei? Haa, atapo'o we'i naranaraa hamu'odu?” ");
INSERT INTO wuv_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Ronamina ma'au ma fi'i'igai ba, “Rama'a bata meni ba fei lalarena ma fei lama, ana na guaipa'aa wareana?” ");
INSERT INTO wuv_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Rona fatete pepei a'a fei gufu Gadara. ");
INSERT INTO wuv_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Ma i'a upudi'ininaa fei wa Jesus, na dinamii a'ana hemea rama'a na wadu'ia hefaa spiriti hafelo, noranamai a'a ei huapu. ");
INSERT INTO wuv_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Ma inafane guta i a'a ei huapu. Lomi na hawia ba hemea i roro'ipa'ia. Ana lomi na hawia ei alatai pidaua. ");
INSERT INTO wuv_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Ronamina bobo'inaa pinena ma panina wataua au ma'uaa namina ba'amoro'aa ei alatai pidaua ma ei wao. Pa'aa lomi hemea rama'a ba i panarofitanipa'ia. ");
INSERT INTO wuv_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Poi ma arewaa, i dupuaa ei huapu ma ei maugeni, imina aiharoharo ma hawihawi'aa ununa a'a ei mugoo. ");
INSERT INTO wuv_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","I fanunupa'aa Jesus rauaa, na ponifa'unaa du'una i ma'ana. ");
INSERT INTO wuv_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","Namina aiharoharopararai ba, “Tamanu ei nunumiamu a'au, Jesus, mena Na'uu mei Haidaa, mei napa'aa Pafeai? A'a fei haraa mei Haidaa oneipa'aa warefa'uai ba lomi o fagianainau!” ");
INSERT INTO wuv_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Uatani, Jesus na waredii a'ana ba, “Wala'amai a'a mena rama'a mena, yoi, fena spiriti hafelo!” ");
INSERT INTO wuv_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Si'ei, na i'iginia Jesus ba, “Hini haramu?” Na ware ba, “Harau, Watauda, uaa hai'odu watauda.” ");
INSERT INTO wuv_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Ma na i'igai watauda a'a Jesus ba apuna alofatatalainaa ro'odu fawelei. ");
INSERT INTO wuv_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Abaa po'o ma'ida moimoi ro'ei hanana papaa fei maugeni. ");
INSERT INTO wuv_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Ma ei spiriti hafelo, rona i'iginaa Jesus, “Onei alonaa hai'odu dupuaa ei moimoi; uga ba hai'ou wadu'aa ro'ou.” ");
INSERT INTO wuv_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Si'ei, Jesus na ugainaa ei hafelo'a spiriti ma rona asi'adi'ininaa mei rama'a ma wadu'inaa ei moimoi. Puduu ei moimoi, ale'ena heguai pufaba'a. Rona poni'u'upu papaa fei maugeni, pepei imina faro'ai ma pasinaa laloo fei ranu ma wawau'uma'e. ");
INSERT INTO wuv_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Ei oma'ama'aa ei moimoi, rona ponibagua ma warefanaa ei rama'aa gufu ma ei gufu sugatata'aia ma ei rama'a, rona aunu ba ro'aa ma'a. ");
INSERT INTO wuv_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Ro'aa nomai a'a Jesus, rona fanunupa'aa mei na wadu'ia watauda pigea na guta lalawai ma namina rawanidiai; ma ronamina ma'au. ");
INSERT INTO wuv_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Ei rona fanunuia, rona u'ufanaa ei rama'a tamanu bigi'aa Jesus a'a mei i wadu'ia pigea ma ana rona u'ufanaa ro'odu tamanu na pa'aa ei moimoi. ");
INSERT INTO wuv_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Si'ei, ei rama'a rona i'igaifawe'i a'a Jesus ba inei di'ininaa fei gufuu ro'odu. ");
INSERT INTO wuv_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Ma ei ba i hugi pafoo fei wa Jesus, mei rama'a, mei ro'aa wadu'ia ei pigea, na i'iginaa Jesus ba ana i aunuhugia. ");
INSERT INTO wuv_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Lomi na ugainia Jesus, ma'uaa na ware ba, “Baguanaa gufu ma warefanaa ena gufumu ena bigi'aa mei Fasu a'amu ma fei faloloa'iana yoi.” ");
INSERT INTO wuv_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Si'ei, mei rama'a mei, na aunu ma u'u yei Decapolis tamanu na bigi'ia a'ana Jesus. Ma minaa ei rama'a, rona ba'arofo. ");
INSERT INTO wuv_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","I hugidiai pafoo wa Jesus ma fatetediai pepei, abaa po'o ma'ida ei rona hoaninia piye. ");
INSERT INTO wuv_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Hemea ei bauaniaa fei synagogue, harana Jairus na nomai yei, fanunupa'aa Jesus ma fapasi o'igoana. ");
INSERT INTO wuv_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","Ina i'igifininaa minaa ei naranarana a'a Jesus ba, “Mei na'uu, baduu pifine, anaa i ma'e. Oneipo'o nomai ma augaa fei panimu pafona ba nei pedu fei funuana ma i gutadiai.” ");
INSERT INTO wuv_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Si'ei, na aunuhugia Jesus. Abaa po'o rama'a, ei ro'aa nenegia ma puroroinia. ");
INSERT INTO wuv_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Ma hemea pifine yei nafane'o wigiwigii namona, ale'ena hefua ma heguai igisimasi. ");
INSERT INTO wuv_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Watauda lo'otaa, rona roinia ma'uaa, ei fi'ina na ude'ualao. Namina pedu ei mugoo po'ina, ma'uaa fei funuana lomi na u pedu. Namina apoi ua. ");
INSERT INTO wuv_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","I guainaa ei u'ugaa Jesus a'a hefi'a, na talaimai nenee Jesus dupuaa ei watauda rama'a ma na idoaa fei hawaa uguu Jesus. ");
INSERT INTO wuv_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Uatani na nara ale'ei ba, “Nabaa a ido'uaiaa fei hawaa uguna, awe rawani.” ");
INSERT INTO wuv_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Ana ei ua, lomi na fai wigiwigidiai fei namona ma na nanamuinia ba nawe pedu fi'ina. ");
INSERT INTO wuv_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Ana ei ma na nanamuinia Jesus ba ma'ida faufauna na di'ininia ma na momo'ai dupuaa ei rama'a ma i'igai ba, “Hini na idoaa fei hawaa uguu?” ");
INSERT INTO wuv_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Rona ware ei otalai nenerana, “Ona fanunuia eni watauda rama'a, rona puroroinio. Batanai ei o i'igai ba, ‘Hini na idoau?’” ");
INSERT INTO wuv_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Ma'uaa Jesus fimina fanunula-barainia ba hini na bigi'aa fei. ");
INSERT INTO wuv_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Si'ei, mei pifine na aida ba na hoto fei namo, na nomai ma fapasi i fasuu hunana ma namina ma'aufunurere ma warefa'uai a'ana. ");
INSERT INTO wuv_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Ina warenaa a'ana ba, “Mena na'uu, fei we'iaa naranaramu na farawaninio. Aunufarawani ua. Ona ala a'a fena fi'iamu.” ");
INSERT INTO wuv_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Ana fi wareware ua Jesus, hefi'a noramiaa ro'ou humuu Jairus, mei famamoaa fei synagogue, rona warenaa a'a Jairus ba, “Mei na'umu baduu pifine na ma'edii. Tani o fa'udeguguaa unuu mei feroia?” ");
INSERT INTO wuv_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Na guai'au'uaialao ei wareaa ro'odu Jesus ma na ware a'a mei famamoaa fei synagogue, “Apuna ma'au; onei narafawe'i ua.” ");
INSERT INTO wuv_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Lomi na ugainaa hemea ba i nenegia; uniaa Peter ma laguei filofui, James ma John. ");
INSERT INTO wuv_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Ma ei ro'aa nosufudailao humuu Jairus, mei bauaniaa fei synagogue, Jesus na guaipa'aa ei rama'a, ronamina waigi ma aimemewai. ");
INSERT INTO wuv_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Na wadu'ai ma i'igainaa ro'odu ba, “Tani hamomina waigi ma aimemewai? Mei baduu, lomi na ma'e. Na ma'igu ua.” ");
INSERT INTO wuv_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Ma'uaa rona fadinia. I fa'asi'adigaa ei rama'a, na dugaa mei ama ma inaa mei baduu ma ei otalai nenerana, ei ro'ou a'ana ma rona wadu'ainaa laloo humu a'a mei baduu. ");
INSERT INTO wuv_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Na tauaa panina ma na warenaa a'ana, “Talitha koum!” (hanuna ba, “Mena baduu pifine, a warenaa a'amu, asi'aa!”). ");
INSERT INTO wuv_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Ana ei ua, mei baduu na ufalarai ma tatalai (igisimasina, hefua ma heguai). A'a fei, ronamina ba'arofo. ");
INSERT INTO wuv_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Ina warefawe'i a'a ro'odu ba ronei'aa warewareaa feni a'a nemea ma ronei fani hanaa mei baduu. ");
INSERT INTO wuv_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Jesus na di'ininaa yei ma hadiwe'inaa gufuna, ro'ou ei otalai nenerana. ");
INSERT INTO wuv_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","I nopa'aloo fei Sabbath, na una'aa ma feroinaa ei rama'a laloo fei synagogue. Ma watauda ei rona guainia, namina nanawala pudaa ro'ou. Ma rona i'igai “Po'o tonana hitani eni manumanu eni, meni rama'a meni? Tamanu fei apa'a, ina tonia ba ana imina bigi'aa ei foigia! ");
INSERT INTO wuv_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Haa hemeni, fadufadua ua! Ana meni na'uu Mary ua, mei lofuu James, Joseph, Judas ma Simon! Ma eni agina ana a'a o'odu yeni!” Ma namina mamanunu unuu ro'odu a'ana. ");
INSERT INTO wuv_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Jesus na warenaa a'a ro'odu, “Ana a'a fei gufu'uana, dupuaa ei gufuna ma laloo fei humuna, hemea mamama'a, lomi ro'aa ma'auia.” ");
INSERT INTO wuv_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Lo'e na hawia ba i bigi'aa ne'aa foigia yei ma'uaa na augaa panina pafoo hefi'a ei funua ma farawaninaa ro'odu. ");
INSERT INTO wuv_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Ma na ba'arofo a'a ro'odu ba lo'e na we'i naranaraa ro'odu. Jesus na tatalai ma feroinaa ei rama'a a'a hepapalo gufu. ");
INSERT INTO wuv_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Na haronaa a'ana ei Hefua ma Helagui ma alofahelalaguinaa ro'odu ma fani forafora a'a ro'ou ba ronei muainaa ei spiriti hafelo. ");
INSERT INTO wuv_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Si'eni, eni wareana: “Apuna notonaa hefi'a manumanu a'a fena tatalaiaa hamu'odu—lomi du'ua, raba o mugoo po'i laloo ena adii hamu'ou—ma'uaa, heina o ua. ");
INSERT INTO wuv_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Hamonei rafe supinai, ma'uaa lomi pafuaa susu. ");
INSERT INTO wuv_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Ma ena hamona wadu'ainaa hepalo humu, hamonei guta yena, nopa'awii fena ba hamo'aa di'ininaa fena gufu fena. ");
INSERT INTO wuv_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Ma na'aa hefi'a gufu, lo'e ro'aa fagutanaa hamu'ou o guaipa'aa wareaa hamu'ou, foifoiaa piyee pinee hamu'ou, ale'ena fama'ama'aa ro'ou ba rona tata.” ");
INSERT INTO wuv_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Rona aunu ma u'ufanaa ei rama'a ba ronei filoginaa naranaraa ro'odu. ");
INSERT INTO wuv_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Rona fawala'anaa watauda pigea, igi pao pafoo watauda ei rona funu ma farawaninaa ro'odu. ");
INSERT INTO wuv_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Mei Hapara Herod na guainaa fei, uaa fei haraa Jesus, nawemina bauanai. Hefi'a, rona ware ba, “John, mei Pudugufaia na ma'elele'aa ma si'ei na pa'i faufauna ba i bigi'aa ei foigia.” ");
INSERT INTO wuv_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Hefi'a, rona ware ba, “Hia Elijah.” Ma hefi'adiai, rona ware ba, “Hia hemea mamama'a, ale'ei hemea mina mina.” ");
INSERT INTO wuv_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Ma'uaa mei Hapara Herod, i guainaa fei, na ware “John, mei una moro'aa huana, na ma'elele'aa!” ");
INSERT INTO wuv_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Uaa Herod na ware ba ronei panarofaa John ma roro'inia ma aunaa hia bobo'aia. Ina bigi'aa fei, uaa mei haroo mei lofuna Philip, harana Herodias, na lalainia. ");
INSERT INTO wuv_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Hamatee John nafane wareware a'a Herod ba, “Lomi na wanewane ba o tonaa mei haroo mei lofumu.” ");
INSERT INTO wuv_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Si'ei, namina bidi unuu Herodias a'a John ma ba i fo'afama'eia, ma'uaa lomi na hawia, ");
INSERT INTO wuv_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","uatani Herod na ma'auaa John ma na'o lawagia, uaa ina aida ba John napa'aa wanewane ma na apunai. Herod, ei ina'aida guta a'a John ma guainaa ei u'ugana, namina hamamagua, ma'uaa na pa'i nunumiana ba i guainaa ei u'ugana. ");
INSERT INTO wuv_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Inawe pa'aa fei rawani'a au. A'a fei arewaa waniniana, Herod na bigi'aa fei baua hananaa a'a ei bauaniaa gufu, ei bauaniaa ei fo'aa mawe ei bauaniaa Galilee. ");
INSERT INTO wuv_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","I wadu'aimai mei baduu pifine na'uu Herodias, na ufa'ufa. Namina fani'eni'eaa Herod mawe ei ro guta hananafipui a'ana. Mei hapara na warenaa a'a mei baduu pifine: “I'iginau tamanu nunumiamu ma a fanio.” ");
INSERT INTO wuv_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Ma ina fa'unai a'a mei baduu pifine ba “Tamanu o i'iginia, a pa'aa fanio nopa'awii hesuwi feni haparaiau.” ");
INSERT INTO wuv_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Ina asi'aa ma warenaa a'a mei inana, “Yau a i'iginaa tamanu?” Na ware mei inana, “Fena tabaa John, mei Pudugufaia.” ");
INSERT INTO wuv_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Ana ei, mei baduu pifine na wadu'aifanaa fei i'igaia a'a Herod: “Na nunuminio ba onei fanau e'eni ua fena tabaa John, mei Pudugufaia pafoo hepalo tabetabe.” ");
INSERT INTO wuv_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Mei hapara, namina bauana fei faloloa'iana, ma'uaa si'ei ba inapo'o fa'unaidii ma lomi na nunuminia ba i mamafa pudaa ei roifi guta hanana a'ana, lomi ba i filoginaa wareana a'a mei baduu pifine. ");
INSERT INTO wuv_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Si'ei, na alomaduareinaa hemea moro'aa hua ba neiree morotonamii fei tabaa John. Na aunu mei, dinaa humuu bobo'aia ma lafigifamosuaa fei huaa John ");
INSERT INTO wuv_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","ma na notabeamai fei tabana pafoo fei tabetabe. Ina fanaa mei baduu pifine ma hia, na fanaa mei inana. ");
INSERT INTO wuv_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Ro'aa guainia ei otalai neneraa John, rona nomai, tonaa fei hudi ununa ma augia laloo huapu. ");
INSERT INTO wuv_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Ei apostle, rona figupuimai a'a Jesus ma warefania minaa ei bigi'a ma feroiaa ro'odu. ");
INSERT INTO wuv_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Si'ei ba abaa po'o ma'ida ei ro'ei'u nomai ma nolao, pa'aa lomi na pa'i au ro'odu ba ro'aa hanana. Na warenaa a'a ro'odu Jesus ba, “Uniaa hamu'odu, hamonei nomai a'au ma o dinaa hefawala lomi wawaigia ba hamo'aa gutafawenai.” ");
INSERT INTO wuv_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Si'ei, rona aunu uniaa ro'odu pafoo wa ma aununaa fawelei lomi rama'a. ");
INSERT INTO wuv_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Ma'uaa wataudaa, rona fanunu'apa'aa ro'odu ma ei rama'a gufu pedu, rona poni'uanaa pinee ro'odu. Ronare'o susufudai ma nene, Jesus ma ei otalai nenerana. ");
INSERT INTO wuv_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","I fatete Jesus, na fanunuia ba abaa po'o rama'a rona oma'adii. Namina faloloa'inaa ro'odu, uatani ro'ou ale'ei ei sipsipi lo'e oma'ama'aa ro'odu. Si'ei, na feroinaa ro'odu watauda manumanu. ");
INSERT INTO wuv_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Ma eni, anaa i lolo fei halo. Si'ei, rona dinaa a'ana ei otalai nenerana ma ware ba “Namina raua faweleni ma namina fafidii. ");
INSERT INTO wuv_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Aloaa eni rama'a ba ronei aunulalabarai hanaa ro'ou a'a hefi'a ena gufu ma pono hanaa ro'odu.” ");
INSERT INTO wuv_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Ma'uaa ina ware, “Hamonei fani hanaa ro'odu.” Rona warenaa a'ana, “Nabaa ale'ei, i tonaa pono'aa hemea bigi'a ale'ena fainaroa puda! Pa'aa wareamu ba hai'ou'aa suminaa mugoo po'i ale'ei ma pono faraa pidaua ma fani hanaa ro'ou?” ");
INSERT INTO wuv_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Ina i'igai, “Hefiga faraa pidaua hamona pa'i? Wi ma'a.” Ro'aa apa'idigia, rona ware ba, “Haipani faraa pidaua ma guapalo nia.” ");
INSERT INTO wuv_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Si'ei, Jesus na warenaa a'a ro'ou ba ronei fagutanaa ei rama'a ma figupuinaa ro'ou pafoo ei guana mamarawii. ");
INSERT INTO wuv_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Si'ei, rona guta. Hefi'a gupu, hefa pu'u ma hefi'a gupu, haipani pa'ania. ");
INSERT INTO wuv_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Na tonaa haipaniei faraa pidaua ma guapaloei nia, aranaa pafea, ware ‘ta’, digedigeaa ei faraa pidaua ma fanaa ei otalai nenerana ba ronei fanaa ei rama'a. Ana na alaginaa guapaloei nia a'a minaa ei rama'a. ");
INSERT INTO wuv_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Minaa ro'ou, rona hananamagu ");
INSERT INTO wuv_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","ma ei otalai nenerana, rona tonaa hefua ma guapalo pa. Ma ei pa, ronamina pepesu a'a ei masii faraa pidaua ma nia. ");
INSERT INTO wuv_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Puduu ei wawane rona hanana, haipani pufaba'a. ");
INSERT INTO wuv_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Ana ei, Jesus na ware a'a ei otalai nenerana ba ronei hugi a'a fei wa ma ronei'o a'aunudinaa Bethsaida. Ma hia, fido'odii aloaa fei gupuu rama'a. ");
INSERT INTO wuv_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","I di'inidigaa ro'ou, na aununaa papaa hepalo maugeni ba i lafulafu. ");
INSERT INTO wuv_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","I nofafilao, fei wa na pa'idigaa memewaa fei agi ma unaiana piye. ");
INSERT INTO wuv_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Na fanunuaa ei otalai nenerana ro'eimina poreifawe'i, uaa fei lalarena na agisuafaa ro'odu. Ale'ena watolaa oduai ma oloroa ido'o mafufuo, Jesus nawe aununaa a'a ro'odu. Na tatalai ua pafoo agi ba i falogiaa ro'ou. ");
INSERT INTO wuv_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Ma'uaa, ei ro'aa fanunupa'ia fi tatalai pafoo agi, ronamina aimemewai, uaa ei naraa ro'odu ba hia, hani'u. ");
INSERT INTO wuv_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Si'ei ba minaa ro'ou pedu na fanunupa'ia ronamina ma'au. Ana ei ua, ina warenaa a'a ro'odu ba, “Gutafarawani ua! Yau meni. Apuna ma'au.” ");
INSERT INTO wuv_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Ma na hugilao a'a ro'ou pafoo wa ma fei lalarena na rere. Ronamina ba'arofo, ");
INSERT INTO wuv_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","uaa lomi rona'u apa'ima'aiaa ei bigi'aa Jesus a'a fei faraa pidaua; namina waiwai tabaa ro'odu. ");
INSERT INTO wuv_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Ro'aa sualao, rona fatete yei Gennesaret ma pe'i yei. ");
INSERT INTO wuv_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Ana ei ro'aa rofo'upu pafoo fei wa, ei rama'a, rona fanunu'apa'aa Jesus. ");
INSERT INTO wuv_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Ei rama'a ei, ronamina poni ua yei tadiwe'aia ma noporoporo'aa ei funua pafoo ei hafenaa unuu ro'ou aununaa hitani rona guainia ba Jesus yei. ");
INSERT INTO wuv_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Ma nabaa i aununaa hitani—a'a ei pusu'o gufu, baua gufu, o sugatata'aia, rona fahainopaa ei funua papaa ei humuu alo'alo. Ma ronamina i'igifawe'i a'ana ba nei ugainaa ro'odu ba ro'aa idoaa fei supuu susuna. Ma minaa ei rona idoia, na pedu ei funuaa ro'odu. ");
INSERT INTO wuv_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Ei Pharisee mawe hefi'a feroiaa law, ei noramiaa ro'odu Jerusalem, rona figupui a'a Jesus ma ");
INSERT INTO wuv_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","fanunupa'aa hefi'a ei otalai nenerana, ro'ei hanana ma na loloa panii ro'odu. Lomi ronado'o huwe panii ro'odu. ");
INSERT INTO wuv_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","(Ei Pharisee ma minaa ei Jew, lomi ro'aa hanana na'aa lomi ronado'o huwe panii ro'odu ale'ei maumau ei upuu ro'odu. ");
INSERT INTO wuv_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Ma ena rona hadiwe'imai a'a ena humuu alo'alo, lomi ro'aa hanana nabaa rotawe huwe. Ronamina neneraa watauda maumau ei upuu ro'odu. Ale'ena fesuaa ena bara, ena pe'i ranu ma ena babagii.) ");
INSERT INTO wuv_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Si'ei, ei Pharisee ma ei feroiaa law, rona i'igainaa Jesus ba, “Tani ei otalai neneramu, lomi rona neneraa maumau ei upuu o'odu ma rona hanafininaa lolo panii ro'odu?” ");
INSERT INTO wuv_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Ina ware ba, “Naminapa'aa balawia ei wareaa mamama'a Isaiah ei idii wareaa hamu'ou ena ware'oni, ale'ei fei ne'ia ba: “‘Eni rama'a eni, pa'aa ware ua umuu ro'odu ba rona ma'auau, ma'uaa ei naranaraa ro'odu namina raua a'au. ");
INSERT INTO wuv_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Lomi hanuu losuiaa ro'ou yau; ena mau feroiaa ro'odu, rona feroinaa ena law ena pagipagiaa rama'a.’ ");
INSERT INTO wuv_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Hamonadii rawa'a'afinaa ei wareaa mei Haidaa ma panaro'uaiaa maumau ei upuu hamu'odu.” ");
INSERT INTO wuv_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Ma na warenaa a'a ro'ou: “Rafee hamu'ou autadidiaa ei wareaa mei Haidaa ba hamo'aa neneraa maumau ei upuu hamu'odu! ");
INSERT INTO wuv_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Moses na ware ba, ‘Ma'auaa amamu ma inamu,’ ma ‘Hini i warefafeloaa amana o inana, ronei fo'afama'eia.’ ");
INSERT INTO wuv_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Ma'uaa hamona ware ba nabaa hemea na warenaa a'a mei amana o inana: ‘Tamanu ei manumanu ba o tonia a'au, Corban’, (hanuna ba lomi i fani a'a amana ma inana, uaa manumanuu mei Haidaa) ");
INSERT INTO wuv_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","ma hamona apunainia ba inei'aa fai bigi'aa ne'a manumanuu amana o inana. ");
INSERT INTO wuv_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Si'ei, hamona suminaa ei wareaa mei Haidaa a'a ena maumau ena upuu hamu'ou, ena hamonamina'o totonamai. Hamonamina bigi'aa watauda manumanu ale'ena.” ");
INSERT INTO wuv_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Jesus na harodinaa a'ana fei gupuu rama'a ma ware, “Guainau minaa hamu'odu. Hamonei apa'aa feni. ");
INSERT INTO wuv_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Lomi hepalo manumanu i aunaa poana hemea ba i faloloaia ma'uaa, fei i norai laloo iana i ‘faloloaia.’” ");
INSERT INTO wuv_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","I di'inidigaa fei gupuu rama'a ma i wadu'ainaa fei humu, rona i'iginia ei otalai nenerana fei warea hanunu. ");
INSERT INTO wuv_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Na i'igai, “Haa, namina loto adiaa hamu'ou? Lomi hamona aida ba na'aa hepalo manumanu na wadu'ainaa laloo hemea, noranalao augu, lomi i faloloaia? ");
INSERT INTO wuv_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Uaa lomi na dinaa laloo fei naranarana ma'uaa, na dinaa laloo fei pahanana ma hinene, na lele'aa.” (Ei i wareaa fei, Jesus na ufugia ba minaa ei du'ua, na rawani.) ");
INSERT INTO wuv_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Ma ina warelao ba, “Ena na lele'amai laloo iaa hemea, si'ena, ena na faloloaia, ");
INSERT INTO wuv_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","uaa, i lalona, na lele'amai ena hafelo'a naranara, ena fitatafipa'aia, fafanaoa, fo'afama'e, fiharoharoipa'aia, ");
INSERT INTO wuv_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","wawa'ai poa, fafeloaa rama'a, sifisifi'a, unara'uaiaa ei hafelo'a, nanamaia, ena sifisifi warea ba i fafeloaa nemea, mamagugua ma ena bigi'aa a'afoloia. ");
INSERT INTO wuv_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Minaa eni hafelo'a eni, noranamai laloo iaa hemea ma na faloloaia.” ");
INSERT INTO wuv_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Jesus na di'ininaa fei gufu fei ma aununaa fawelei na rafi'inaa Tyre. Na wadu'ainaa hepalo humu. Lomi na nunuminia ba nemea i aida ma'uaa, pa'aa lomi na opa'aipa'ia ba hia yei. ");
INSERT INTO wuv_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Ina pa'i hemea pifine yei ma mei pifine mei, na pa'i na'una, pusu'o baduu pifine, mei na wadu'ia hefaa spiriti hafelo. Mei pifine mei, ana ei i guainia ba Jesus yei, ina nomai ma fapasi fasuu hunaa Jesus. ");
INSERT INTO wuv_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Mei pifine, hia Greece. Waniniana Syrian Phoenicia. Namina i'igifawe'i a'a Jesus ba neipo'o fawala'anaa fei pigea a'a mei na'una. ");
INSERT INTO wuv_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Na warefania, “Ei pa'aa baduu (ale'ei, ei na'uu Israel), roneido'omina hanaiaa ei rona nunuminia, uaa lomi na wanewane ba o'aa tonaa ei hanaa ei pa'aa baduu ma fanaa ei hapee ro'odu ponoto.” ");
INSERT INTO wuv_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Ina ware ba, “Pa'aa fa'ua, mena Fasu ma'uaa ei ponoto haroo tawa, rona hanaiaa ei masii du'ua, ei lomi rona hanaia ei baduu.” ");
INSERT INTO wuv_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Ma ina warenaa a'ana ba, “Hamatee ona ware ale'ena, te, onei nowau. Fena pigea na di'inidigaa mena na'umu.” ");
INSERT INTO wuv_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Ina aununaa gufuna ma fanunupa'aa mei na'una na haino pafoo tawa ma fei pigea na di'inidigia. ");
INSERT INTO wuv_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Jesus na di'ininaa malalaa Tyre, aunu'ailao Sidon, upu'ailao a'a fei Agii Galilee ma aununaa fawelei Decapolis. ");
INSERT INTO wuv_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Yei, hefi'a rona duginamii a'a Jesus hemea na loto adiana ma pa'aa lomi na warewarepa'i. Ma ronamina warefawe'i a'ana ba ineipo'o augaa fei panina pafoo mei. ");
INSERT INTO wuv_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Nenee fei, ina dugi'u'uginia ma laguna raua a'a fei gupuu rama'a, Jesus na augaa ei ana'anana laloo adiaa mei rama'a. Ma ina huwi ma idoaa fei rawerawee mei rama'a. ");
INSERT INTO wuv_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Na aranaa pafea, fawenaifatemu ma warenaa a'ana, “Ephphatha!” (hanuna ba “Ma'awawa”). ");
INSERT INTO wuv_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","A'a fei, guapaloei adiana nawe ma'awawa ma fei rawerawena nawe tatawei ma warewarepa'i. ");
INSERT INTO wuv_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Jesus na warefawe'i a'a ro'odu ba ronei'awe warefanaa nemea, ma'uaa ena na'aida ware ale'ei, ana ro'eimina'u fiwarei'uaia. ");
INSERT INTO wuv_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Ei rama'a, ronamina ba'arofo. Rona ware, “Namina bigifarawaninaa minaa ei manumanu. Ana na farawaninaa ei lotoo adia ma ei lomi rona warewarepa'i.” ");
INSERT INTO wuv_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","A'a ei arewaa ei, hepalodiai baua gupuu rama'a, rona figupui. Si'ei ba pa'aa lomi hanaa ro'ou, Jesus na haronaa a'a ei otalai nenerana ma ware, ");
INSERT INTO wuv_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“Na pa'i faloloa'iau a'a eni rama'a rona oafipuidii a'au oduai arewaa ma lomi du'ua ba ro'aa hanana. ");
INSERT INTO wuv_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Nabaa a alonaa ro'odu gufuu ro'ou ma ro'aa notonaa baoaa ro'odu, ro'aa nomaralelelao tala, uaa gufuu hefi'a ro'odu, rauaa.” ");
INSERT INTO wuv_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Rona ware ei otalai nenerana, “Feni rauaa gufu ale'eni, i to hitani faraa pidaua hemea ba i faguaa ro'odu?” ");
INSERT INTO wuv_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Na i'igai Jesus, “Hamona pa'i hefiga faraa pidaua?” Rona ware, “Olorompalo.” ");
INSERT INTO wuv_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Ina ware a'a ei rama'a ba ronei guta pafoo malagufu. I todigaa ei olorompalo faraa pidaua ma waredii ba ‘ta’, na bidigedigeia ma fanaa ei otalai nenerana ba ronei augia i ma'aa ei rama'a ma rona bigi'ia ale'ei. ");
INSERT INTO wuv_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Ana rona pa'i ma'ida pusu'o nia; ma ana ina ware ba ‘ta’ ma warenaa a'a ei otalai nenerana ba ronei alaginia. ");
INSERT INTO wuv_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Ei rama'a, rona hanana ma ronamina magu. Hinene, ei otalai nenerana, rona paiaa olorompalo pa, na pepesu ei dufuu du'ua. ");
INSERT INTO wuv_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Ina pa'i ale'ei gunaroa pufaba'a wawane yei. I alodigaa ro'ou, ");
INSERT INTO wuv_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","na hugi pafoo wa a'a ei otalai nenerana ma dinaa fawelei Dalmanutha. ");
INSERT INTO wuv_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Ei Pharisee, rona nomai ma rona'aa fiharei a'a Jesus. Si'ei ba ro'aa mania, rona i'igainia ba nei fama'aa ro'odu hepalo foigia i norai pafea. ");
INSERT INTO wuv_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Inamina fawenaitemu ma ware, “Tani taweni ro i'igainaa hepalo hilalaa foigia ba unei fama'aa ro'ou? A warefa'uai a'a hamu'ou, lomi ba awe fama'aa ro'ou.” ");
INSERT INTO wuv_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Na di'ininaa ro'ou, na hugidiai pafoo wa ma aununaa pepei. ");
INSERT INTO wuv_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Ei otalai nenerana, rona madi'inia ba ro'aa notoo faraa pidaua ma'uaa, rona pa'i hepalo faraa pidaua a'a ro'ou pafoo wa. ");
INSERT INTO wuv_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Jesus na aweinaa ro'ou, “Oma'ama'a. Hamonei oma'ama'aa hamu'ou a'a fei fafuafuaa ei Pharisee ma Herod.” ");
INSERT INTO wuv_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Rona fiwareinaa fei ma ware, “Woro ei i ware ale'ei uaa ba lomi ona pa'i faraa pidaua.” ");
INSERT INTO wuv_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Na apa'idigaa ei fiwareiaa ro'ou, na i'igainaa ro'ou Jesus, “Tani hamu'ou fiwarei ba lomi hamona pa'i faraa pidaua? Ana hamotapo'o fanunu'apa'ia? Na waiwai tabaa hamu'ou? ");
INSERT INTO wuv_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Hamona pa'i pudaa hamu'ou ma ana lomi hamona'u fanunupa'i ma na pa'i adiaa hamu'ou ma ana lomi hamona'u guaipa'i? Ma ana lomi hamona'u nonominia? ");
INSERT INTO wuv_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Ei a bidigedigeaa haipaniei faraa pidaua a'a ei haipani pufaba'a, hefiga pa na pepesu a'a ei masii faraa pidaua hamona tonia?” Rona ware, “Hefua ma guapalo.” ");
INSERT INTO wuv_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","“Ma ei a bidigedigeaa ei olorompalo faraa pidaua a'a ei gunaroa pufaba'a, hefiga pa na pepesu a'a ei masii faraa pidaua hamona tonia?” Rona ware ba, “Olorompalo.” ");
INSERT INTO wuv_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Ina warenaa a'a ro'odu ba, “Ana hamotapo'o apa'ia?” ");
INSERT INTO wuv_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Rona sufudai Bethsaida ma hefi'a rama'a, rona dugamii hemea pudawerai a'a Jesus ma i'igifawe'i a'ana ba inei idoia. ");
INSERT INTO wuv_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Na tauaa panii mei pudawerai ma noduginaa hia auguu fei gufu. I huwidigaa pudaa mei rama'a ma audigaa panina pafona, Jesus na i'igai, “Ona fanunupa'i hepalo manumanu?” ");
INSERT INTO wuv_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Na aranaa pa'udu ma ware, “Na fanunupa'i rama'a; rona fafanunu ale'ei haihai, rona tatalai.” ");
INSERT INTO wuv_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Jesus na augaa panina hepoadiai pudaa mei rama'a. Si'ei, fei pudana na wera ma na fanunupa'i ma fanunufarawanipa'aa minaa ei manumanu. ");
INSERT INTO wuv_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Ba i alohadiwe'idinia humuna, Jesus na ware, “Apuna famaua gufu.” ");
INSERT INTO wuv_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Jesus ma ei otalai nenerana, rona aununaa ei gufu papaa Caesarea Philippi. I ma'aa tala, ina i'iginaa ro'odu, “Ei rama'a, rona ware ba yau hini?” ");
INSERT INTO wuv_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Rona ware, “Hefi'a, rona ware ba yoi John, mei Pudugufaia; hefi'a ba Elijah; ma hefi'adiai ba hemea ei mamama'a.” ");
INSERT INTO wuv_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Ina i'igai, “Ma hamu'ou? Hamona ware ba yau hini?” Na ware Peter ba, “Yoi, mei Christ.” ");
INSERT INTO wuv_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Jesus na aweinaa ro'odu ba ronei'aa warefanaa nemea ba hia hini. ");
INSERT INTO wuv_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","I dii, na feroinaa ro'odu ba mei Na'uu Rama'a, neipa'aa tonaa fi'ina a'a watauda manumanu ma ro'aa ofadugia ei bauaniaa gufu, ei famamoaa humuu mei Haidaa mawe ei feroiaa law. Ma hefi'a, rowe fo'afama'eia ma nenee oduai arewaa, i asi'adiai. ");
INSERT INTO wuv_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Ina fa'arewaiaa feni ma Peter na dugitata'ainia ma warehota'ia. ");
INSERT INTO wuv_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Ma'uaa i momo'ai ma fanununaa ei otalai nenerana, na hota'aa Peter, “Dinaa neneu, Satan! Lomi ona pa'i naranaramu a'a ei manumanuu mei Haidaa, ma'uaa ei manumanuu rama'a.” ");
INSERT INTO wuv_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Ma ina haronaa a'ana fei gupuu rama'a mawe ei otalai nenerana ma ware ba, “Hini ba i nenerau, inei rawa'a'afai a'a ei nunumiana, tonaa fei hawafolona ma nenerau. ");
INSERT INTO wuv_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Uaa hini ba i panarofaa fei harenuana, iwe pa'ai ma'uaa, hini i fapa'ainaa fei harenuana a'au ma a'a fei rawani'a warea, i tela. ");
INSERT INTO wuv_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Tamanu rawani'ana nabaa hemea i tonaa minaa feni malagufu ma'uaa na fapa'ainaa fei harenuana? ");
INSERT INTO wuv_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","O, tamanu i fania hemea ba i filoginia a'a fei harenuana? ");
INSERT INTO wuv_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Nabaa nemea na mamafa a'au ma ei wareau laloo feni au taweni, feni rona fiharoharoipa'ai ma pepesu a'a ei maumau hafelo, te, ana iwe mamafa a'ana mei Na'uu Rama'a ena na nomai wagii fei haweraa mei Amana fipui a'a ei apunaia alo'alo.” ");
INSERT INTO wuv_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Ma ina warenaa a'a ro'ou ale'ei ba, “A warefa'uai a'a hamu'ou. Hefi'a eni ro ufalarai yeni, ro'ado'o fanunuaa fei haparaiaa mei Haidaa na nofininaree fei faufau, nene rowe ma'e.” ");
INSERT INTO wuv_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Nenee oloroa arewaa Jesus na nodugaa Peter, James ma John. Ma uniaa ro'ou, rona faneaa hepalo tarea maugeni. Yei, i ma'aa ro'odu, na filogii fei maumauna. ");
INSERT INTO wuv_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Fei lawalawana namina po'i agime. Fei po'iana, lomi na fipupuduinaa eni fesuaa hemea yeni malagufu. ");
INSERT INTO wuv_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Laguna fa'arewa pudaa ro'odu Elijah ma Moses ma laguna fiwarewarei a'a Jesus. ");
INSERT INTO wuv_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Peter na warenaa a'a Jesus, “Rabbi, na rawani ba o'ou yeni. Ina rawani ba hai'odu bigi'aa odumanu pale. Hepalo yoi, hepalo Moses ma hepalo Elijah.” ");
INSERT INTO wuv_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","(Lomi ina aida ba i wareaa tamanu. Ronamina ma'aufafelo). ");
INSERT INTO wuv_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Ma, hepalo papalei na sufudaimai ma hawaipa'ainaa ro'odu ma hepalo lao na warerai a'a fei papalei: “Simeni, meni Na'uu, meni yau na haguia. Guainia!” ");
INSERT INTO wuv_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Ana ei ua ma ro'aa fifanunui, lomi hemeadiai rama'a a'a ro'ou, uniaa Jesus. ");
INSERT INTO wuv_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Ei roi upugio a'a fei maugeni, Jesus na warefawe'i a'a ro'odu ba ronei'aa warefanaa nemea ei rona fanunuia hawina na asi'adii a'a fei ma'ea mei Na'uu Rama'a. ");
INSERT INTO wuv_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Rona'o to'uaia a'a ro'odu ma fiwarewarei ba tamanu hanuu fei asi'ana a'a fei ma'ea. ");
INSERT INTO wuv_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Ma rona i'iginia ba, “Tani ei feroiaa Law, ro'aa ware ba rawarawa nei nomai, Elijah?” ");
INSERT INTO wuv_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Jesus na ware, “Pa'aa fa'ua ba neido'o nomai Elijah ma pagihadiwe'inaa minaa ei manumanu. Tani ro'aa ne'inia ba mei Na'uu Rama'a neimina tonaa fi'ina ma hararasia? ");
INSERT INTO wuv_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Ma'uaa a warefanaa hamu'ou ba na nodigimai Elijah ma rona bigi'ia a'ana minaa ei manumanu ale'ei nunumiaa ro'ou, ana ale'ei ro ne'inia.” ");
INSERT INTO wuv_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Ro'aa nomai, rona fanunupa'aa ei feroiaa Law, roi fiharenii a'a hefi'adiai otalai nenera ma hefa baua gupuu rama'a. ");
INSERT INTO wuv_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Ana ei ro'aa fanunupa'aa Jesus minaa ei rama'a, rona ba'arofofafelo ma ponisuafinia. ");
INSERT INTO wuv_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Ina i'igai, “Tamanu ei fihareniaa hamu'ou a'a ro'ou?” ");
INSERT INTO wuv_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Na ware hemea dupuaa ro'odu, “Mena feroia, una dugamii meni na'uu, baduu wawane, meni na wadu'ia pigea. Ma fei pigea, na fafanaonaa laona ma lomi na wareware. ");
INSERT INTO wuv_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Ena inafane'o guafia, na bainafa'inia malagufu. Ina pugapugaa poana, fi'u'uinaa difona ma na waiwai ununa. Una i'igainaa ei otalai neneramu ba ronei fawala'ania ma'uaa lomi rona hawia.” ");
INSERT INTO wuv_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Jesus na ware, “Hamu'ou ena rama'aa taweni, lomi na we'i naranaraa hamu'ou. Ipo'o pedu nahaiga fena maumau hamu'ou ale'ena? Dugifanamiau mena baduu.” ");
INSERT INTO wuv_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Si'ei, rona dugialao ma i fanunupa'aa Jesus fei pigea, maduare ua na fa'a'erapurapuaa unuu mei baduu. Ina pasinaa malagufu, weloweloi ma na pugapugaa poana. ");
INSERT INTO wuv_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Jesus na i'igainaa mei amaa mei baduu, “Figa malaa gutanana ale'eni?” Ina ware, “Ena ifi badui ");
INSERT INTO wuv_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","nopa'amii wagieni, ina'o suminia hafi o ranu ba i fo'afama'eia. Ma'uaa nabaa ona hawia ba o bigi'aa he'a manumanu, te, faloloa'inaa hai'ou ma hadumaa hai'ou.” ");
INSERT INTO wuv_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Jesus na ware, “Ei wareamu ba, ‘Nabaa una hawia’? Minaa ena manumanu na ma'atalaa a'a hini na we'i naranarana.” ");
INSERT INTO wuv_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Ana ei ua, mei amaa mei baduu na haroharo ba, “Na we'i naranarau. Hadumau a'a feni naranarau, fena lomi na we'i!” ");
INSERT INTO wuv_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Ma i fanunuia Jesus ba roi ponimai fawelei a'ana, ei watauda rama'a, na warehota'aa fei spiriti hafelo, “Mena pigea, mena lotoo adia ma umuloo, a warefanio, wala'amai a'ana ma onei'awe wadu'aidinia.” ");
INSERT INTO wuv_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Fei pigea na aimemewai, na fa'a'erapurapuaa ununa ma wala'aa. Mei baduu na fafanunu ale'ena hemea ma'ea. Si'ei, watauda, rona ware ba, “Ina ma'e.” ");
INSERT INTO wuv_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Ma'uaa Jesus na tauaa panina, fa'ufalaginia ma ina ufalarai. ");
INSERT INTO wuv_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","I wadu'aidiginaa fei humu Jesus, ei otalai nenerana, rona i'iginia ei uniaa ro'odu, “Tani lomi hai'ouna fawala'apa'ia?” ");
INSERT INTO wuv_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Ina ware, “Fena maumau ale'ena, i no'uamai a'a fei lafulafua.” ");
INSERT INTO wuv_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Rona di'ininaa fawelei ma talaifaloginaa Galilee. Jesus lomi na nunuminaa nemea ba nei aida ba ro'ou hitani, ");
INSERT INTO wuv_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","uaa fi feroinaa ei otalai nenerana. Na warenaa a'a ro'odu, “Mei Na'uu Rama'a, rowe aloia a'a rama'a. Rowe fo'afama'eia ma nenee oduai arewaa iwe asi'aa.” ");
INSERT INTO wuv_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Ma'uaa lomi na arewa a'a ro'odu ei hanuiana ma rona ma'au ba ro'aa i'iginia hefei. ");
INSERT INTO wuv_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Rona dinamii Capernaum ma laloo fei humu, ina i'iginaa ro'odu, “Tamanu fei fihareniaa hamu'odu i ma'aa tala?” ");
INSERT INTO wuv_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Ma'uaa ronamina babanini. Uatani, yei ma'aa tala rona fiharenii ba hini i bauanai. ");
INSERT INTO wuv_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Jesus na guta ma harofaa ei hefua ma helagui ma na ware ba, “Hini i nunuminia ba hia rawarawa, neipa'aa oanaa mugi ma nafii a'a minaa ei rama'a.” ");
INSERT INTO wuv_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Ina dugaa hemea baduu pusu'o ma fa'ufalaginia dupuaa ro'ou. Ma a'a guapaloei panina na poro'aa mei baduu ma warenaa a'a ro'ou, ");
INSERT INTO wuv_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“A'a fei harau, hini i taufagutanaa hemea baduu pusu'o ale'eni meni, ina taufagutanau. Ma hini i taufagutanau, abaa fi taufagutanau, ma'uaa mei na aloagiau.” ");
INSERT INTO wuv_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Na ware John, “Feroia, hai'ouna fanunupa'aa hemea na fawala'anaa ei pigea wagii fei haramu ma hai'ouna ware a'ana ba nei pedu, uaa hia, abaa hemea o'odu.” ");
INSERT INTO wuv_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Na ware Jesus, “Apuna pauniana. Lomi hemea i bigi'aa hepalo foigia a'a fei harau ma hinene, i warefafeloau a'a hepalo manumanu. ");
INSERT INTO wuv_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Uaa hini lo'e na fadugeaa o'odu, hia a'a o'ou. ");
INSERT INTO wuv_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","A warefa'uai a'a hamu'odu ba hini i fanio hepalo baraa ranu wagii fei harau, uaa yoi a'a Christ, pa'aa lomi ba iwe pa'ai fei pono'ana. ");
INSERT INTO wuv_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","“Hini i susuaninaa nemea eni baduu pusu'o, nemea na we'i naranarana a'au, na rawani ba ro'aa habe'aa huaa mei rama'a mei a'a hepalo baua mugoo ma famomoguia agi. ");
INSERT INTO wuv_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Na'aa fei panimu i fafeloio, lafigifamosuia. Na rawaninio ba onei pa'i hepalo ua pani ma pa'i harenuamu laraa fei ba o pa'i guapalo pani ma dinaa a'a fei hafi lomi i peretoo. ");
INSERT INTO wuv_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Ma na'aa fei pinemu na fafeloio, lafigifamosuia. Na rawaninio ba o wadu'aitonaa fei harenua lomi i pedutoo fininaa afetoaa pinemu a'a fei gufu pafea laraa fei ba o pa'i guapalo pinai ma i gu'aio fei hafi lomi i peretoo. ");
INSERT INTO wuv_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Ma na'aa fei pudamu na fafeloio, wenu'ia. Na rawaninio ba o wadu'ainaa fei haparaiaa mei Haidaa a'a hepalo ua puda laraa fei ba ona pa'i guapalo puda ma dinaa fei hafi lomi i peretoo. ");
INSERT INTO wuv_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Yei, “‘ei wa'awa'aa ro'odu, lomi ro'aa ma'etoo, ma fei hafi, lomi i peretoo.’ ");
INSERT INTO wuv_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Minaa ei rama'a, ro'aa agi'agia a'a fei hafi. ");
INSERT INTO wuv_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","“Fei agi na rawani ma'uaa, nabaa i pa'ai fei agi'agiana, o fa'agi'agi batanaidinia? Nei pa'i agi laloo iaa hamu'ou ma hamonei gutafirawanii ua.” ");
INSERT INTO wuv_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Jesus na di'ininaa fei gufu fei ma na dinaa fawelei malalaa Judea talawa'aa fei Jordan. Ma rona nodimai a'ana hefi'a gupuu rama'a ma ale'ei maumauna ranimai, na feroinaa ro'odu. ");
INSERT INTO wuv_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Ro'aa nomai hefi'a Pharisee ba ro'aa mania, rona i'igai, “Na rawani a'a fei law ba nemea wawane i disuminaa mei harona?” ");
INSERT INTO wuv_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Ina ware, “Tamanu ei di warefawe'iaa Moses a'a hamu'odu?” ");
INSERT INTO wuv_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Rona ware, “Moses na ugainia ba nemea i ne'inaa hepalo ne'ia ma alofatatalainaa mei harona.” ");
INSERT INTO wuv_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Jesus na ware, “Si'ei ba na waiwai tabaa hamu'ou, Moses na ne'ifanaa hamu'ou feni law feni. ");
INSERT INTO wuv_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Ma'uaa eni i mamara feni malagufu, mei Haidaa ‘na bigi'aa lagua—wawane ma pifine.’ ");
INSERT INTO wuv_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Si'eni pa'afina ba hemea wawane, i di'ininaa amana ma inana ma fihupu'ai a'a harona ");
INSERT INTO wuv_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","ma lagu'awe pigioinaa hepalo. Si'ei, fai lomi ba lagua helagui ma'uaa hemea. ");
INSERT INTO wuv_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Hee, tamanu mei Haidaa na fihupu'inia, nemea nei'aa alagia.” ");
INSERT INTO wuv_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Ma ro'aa gutadiai laloo humu, ei otalai nenerana, rona i'igainaa Jesus a'a fei. ");
INSERT INTO wuv_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Ina ware, “Na'aa hemea wawane i suminaa harona ma lalainaa nemeadiai pifine, ina fiharoharoipa'ai a'ana. ");
INSERT INTO wuv_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Ma nabaa mei pifine i disuminaa mei harona ma lalaidinaa nemea wawane, ina fiharoharoipa'ai.” ");
INSERT INTO wuv_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Ei rama'a, roi dugalao ei baduu a'a Jesus ba nei idoaa ro'odu, ma'uaa ei otalai nenerana, rona pauninaa ro'odu. ");
INSERT INTO wuv_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","I fanunuia ale'ei Jesus, lomi napo'o ni'eni'e. Na warenaa a'a ro'odu, “Fanoramii ro'odu a'au ma apuna pauninaa ro'odu, uaa fei haparaiaa mei Haidaa, gufuu ena mau rama'a ale'eni eni baduu. ");
INSERT INTO wuv_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","A warefa'uainia a'a hamu'odu ba hini lomi i tonaa fei haparaiaa mei Haidaa ale'ei hemea pusu'o baduu, lomi ba iwe wadu'ai.” ");
INSERT INTO wuv_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Ma ina poro'aa ei baduu, augaa panina pafoo ro'odu ma haweginaa ro'odu. ");
INSERT INTO wuv_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Ma ba i aunu Jesus, na ponimai a'ana hemea, na fapasi'unaa du'una i ma'ana ma i'igai, “Mena rawani'a feroia, apa'aa bigi'aa tamanu ba a tonaa fei harenua lomi i pedutoo?” ");
INSERT INTO wuv_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Na ware Jesus, “Tani o ware ba yau rawani'a? Lomi hemea rawani'a, uniaa mei Haidaa. ");
INSERT INTO wuv_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Ona aida fei Law: Apuna fo'afama'e, apuna fiharoharoipa'ai, apuna fafanao, apuna u'usifi, apuna susuani ma onei guainaa wareaa amamu ma inamu.” ");
INSERT INTO wuv_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Ina ware, “Mena feroia, minaa ena, namina fanima'aia ena ui badui nopa'amii wagieni.” ");
INSERT INTO wuv_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Jesus na fanununaa a'ana ma na haguia. Ina ware, “Hepalo manumanu otaa pa'i. Nowau, aloaa minaa ena manumanu ona pa'i ma fanaa ena lomi rona pa'i ma owe pa'i fananamaiaa manumanu i gufu pafea. Ma ona bigidigia, nomai ma nenerau.” ");
INSERT INTO wuv_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","A'a ei, na nafa'aa paruna. Na aunutonaa faloloa'iana uaa na pa'i watauda manumanuna. ");
INSERT INTO wuv_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Jesus na diarai ma warenaa a'a ei otalai nenerana, “Na pa'aa waiwai a'a ei rona pa'i watauda manumanu ba ro'aa wadu'ai a'a fei haparaiaa mei Haidaa!” ");
INSERT INTO wuv_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Ei otalai nenerana, rona ba'arofo a'a ei wareana. Ma'uaa Jesus na warediai, “Ena na'uu, a warefanaa hamu'odu ba napa'aa waiwai wadu'aiaa fei haparaiaa mei Haidaa! ");
INSERT INTO wuv_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Na maduta a'a fei camel ba i wadu'aipa'i laloo fei ma'ahi'u laraa mei i pa'i watauda manumanu ba i wadu'ainaa fei haparaiaa mei Haidaa.” ");
INSERT INTO wuv_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Ei otalai nenerana, rona ba'arofo'apoidiai ma fiwarewarei, “Na'aa ale'ei, hini i tela?” ");
INSERT INTO wuv_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Jesus na fanununaa a'a ro'ou ma ware, “A'a rama'a, lomi na ma'atalaa ma'uaa, abaa ale'ei a'a mei Haidaa, uaa minaa ena manumanu, rona ma'atalaa a'ana.” ");
INSERT INTO wuv_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Peter na warenaa a'ana, “Hai'ounamina rawa'a'afinaa minaa ei manumanu ba hai'ou nenegio.” ");
INSERT INTO wuv_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Jesus na ware, “A warefa'uai a'a hamu'odu, hini i di'ininaa humuna, o lofuna, o agina, o inana, o amana, o na'una, o ei poduna, uaa ba i nenerau ma fei rawani'a warea, ");
INSERT INTO wuv_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","i tonaa ale'ena hefa pu'udiai a'a feni au feni (ei humu, lofu, agi, ina, na'u ma podu-ma'uaa ei haperararaia ro nofinimai a'a e'ei) ma wagii fei au i nomai ro'aa tonaa fei harenua lomi i pedutoo. ");
INSERT INTO wuv_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Ma'uaa watauda, ena ro'ou rawarawa, ro'awe dinaa nene ma ena mugi, ro'awe oanaa ma'a.” ");
INSERT INTO wuv_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Ro'ei talainaa Jerusalem, Jesus na aima'a ma ei otalai nenerana, rona maduofo ma'uaa ei rama'a, ei ro'aa nenegia, rona ma'au. Na dugi'u'uginaa ei hefua ma helagui ma na warefanaa ro'odu tamanu rowe bigi'ia a'ana. ");
INSERT INTO wuv_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Ina ware, “O'aa dinaa Jerusalem ma mei Na'uu Rama'a, rowe fifaninia panii ei famamoaa humuu mei Haidaa ma ei feroiaa law. Rowe dududuia ba nei ma'e ma fifaninia a'a ei Gentile ");
INSERT INTO wuv_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","ma rowe hararasinia, huwia, hafugia ma fo'afama'eia. Nenee odu'ai arewaa iwe asi'aa.” ");
INSERT INTO wuv_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Si'ei James ma John, laguei na'uu Zebedee, laguna dinamii a'ana. Laguna ware, “Mena feroia, haiguna nunuminio ba onei bigi'ia a'a haigua fei i'igaiaa haigua yoi.” ");
INSERT INTO wuv_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Ina i'igai, “Tamanu fei ba a bigi'ia a'a hamugua?” ");
INSERT INTO wuv_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Laguna ware, “Onei fagutanaa hemea haigua i pepei ma'aumu ma hemea, i pepei mauwimu a'a fei haweramu.” ");
INSERT INTO wuv_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Na ware Jesus, “Lomi hamuna apa'aa tamanu ena hamu'ei i'igainia. Haa, hamu'aa hunupa'ia fei bara, fei una hunumia ma hamu'aa pudugufaipa'i a'a fei pudugufaiaa fi'ia, fei una pudugufai wagina?” ");
INSERT INTO wuv_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Laguna ware, “Haiguna hawia.” Na ware Jesus, “Hamu'aa hunupa'ia fei bara, fei ba a hunumia ma pudugufaipa'i wagii fei pudugufaia yau na pudugufai wagina, ");
INSERT INTO wuv_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","ma'uaa fei ba hamu'aa guta pepei ma'au o mauwiu, abaa manumanuu ba a ugainia. Ei gutana ei, na udediginaa gutaa ei rama'a ei rowe tonia.” ");
INSERT INTO wuv_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Ro'aa guainia ei hefua, rona siba a'a James ma John. ");
INSERT INTO wuv_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Na harofipuinaa ro'ou Jesus ma ware, “Hamona aida ba ei pa'aa famamoaa ei Gentile, rona fasuinaa ei maroaa ro'ou ma ei paniaa panii ro'ou, ana rona fasuinaa ro'ou. ");
INSERT INTO wuv_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Abaa ale'ei a'a hamu'odu ma'uaa, hini ba i bauanai a'a hamu'ou, inei nafii a'a hamu'ou ");
INSERT INTO wuv_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","ma hini ba i rawarawai, inei humuwai minaa ei rama'a. ");
INSERT INTO wuv_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Uaa ena i nomai mei Na'uu Rama'a, ana abaa ronei nafii a'ana ma'uaa ba hia, nafi ma ba i fanaa fei harenuana ale'ena ponoponoo watauda.” ");
INSERT INTO wuv_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Rona dinamii Jericho ma ba ro'aa di'ininaa fei gufu Jesus ma ei otalai nenerana fipuinaa fei baua gupuu rama'a, hemea pudawerai, harana Bartimaeus (mei na'uu Timaeus, baduu wawane) na gutanoinoi papaa fei tala. ");
INSERT INTO wuv_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Ma i guainia ba fi nomai Jesus, mei Nazareth, na una'aa ma haroharo, “Jesus, mena Na'uu David, faloloa'inau!” ");
INSERT INTO wuv_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Watauda na hota'ia ma ware ba nei babanini ma'uaa na haroharo'a-poidiai, “Mena Na'uu David, faloloa'inau!” ");
INSERT INTO wuv_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Jesus na u ma ware, “Harofia.” Si'ei, rona haronaa a'a mei pudawerai ba, “Onei ni'eni'e! Ufalarai! Ifi harofio!” ");
INSERT INTO wuv_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Na suminaa fei hawana, na pala'arofonaa pinena ma dinamii a'a Jesus. ");
INSERT INTO wuv_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Na i'iginia Jesus, “Tamanu nunumiamu ba a bigi'ia a'amu?” Mei pudawerai na ware, “Rabbi, nunumiau ba a fanunupa'i.” ");
INSERT INTO wuv_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Na ware Jesus, “Nowau. Fena we'iaa naranaramu na farawaninio.” Ana ei ua, na fafanunupa'i ma na talaineneraa Jesus wagii fei tala. ");
INSERT INTO wuv_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Ro'aa rafi'inaa Jerusalem ma dinamii Bethphage ma Bethany yei Maugeni Olive, Jesus na aloaa helagui otalai nenerana ");
INSERT INTO wuv_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","ma na ware a'a lagua, “Dinawii a'a fena gufu i ma'aa hamugua ma ena hamuna wadu'ai, hamu'awe fanunupa'aa hepalo baubara donkey, rona habe'ia yena, fei lomi hemea na u poni pafona. Alagia ma foraiamai yeni. ");
INSERT INTO wuv_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Ma na'aa nemea i i'igainaa hamugua ba, ‘Tani hamu'aa bigi'aa feni?’, warefania, ‘Mei Fasu na nunuminia ma lomi i madii iwe alohadiwe'inamai.’” ");
INSERT INTO wuv_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Laguna aunu ma laguna pa'aa fei baubara donkey yei ano, i ma'aa tala, rona habe'ia a'a fei talaa wawadu'i. Lagu'aa alagia, ");
INSERT INTO wuv_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","hefi'a rona ufalarai yei, rona i'igai, “Tani hamu'aa alaraa fena baubara donkey?” ");
INSERT INTO wuv_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Laguna ware ana ale'ei ei wareaa Jesus a'a lagua. Ma lomi rona papa'aa lagua. ");
INSERT INTO wuv_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Ma lagu'aa foraialoo fei baubara donkey a'a Jesus ma suminaa ei hawaa lagua pafona, ina guta pafona. ");
INSERT INTO wuv_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Watauda, rona hafeninaa ei hawaa ro'odu i tala ma hefi'a, rona hafeninaa ei raraa haihai, ei balaiaa ro'ou podu. ");
INSERT INTO wuv_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Ei rona aima'a ma ei rona nenegia, rona haroharo, “Hosanna!” “Haweginaa mei i nomai a'a fei haraa Mei Fasu!” ");
INSERT INTO wuv_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","“Haweginaa fei haparaiaa mei amaa o'ou David, fei fi nomai!” “Hosanna i pafea!” ");
INSERT INTO wuv_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Jesus na wadu'ainaa Jerusalem, dinaa a'a fei humuu mei Haidaa ma didiarainaa minaa ei manumanu. Ma si'ei ba namina fafidii, na asi'aa ma aunufipui a'a ei hefua ma helagui, dinaa Bethany. ");
INSERT INTO wuv_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Fei arewaa augu ei roi di'ininaa Bethany, na bao Jesus. ");
INSERT INTO wuv_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Ina fanunupa'aa hepalo haihai figi, na raua ma'ida, namina habe mamaugi. Si'ei, na aunu ba i ma'a ba na pa'i fuana, o lomi. I nopa'alao, na ma'apa'ia ba lomi fuana, uaa abaa au fuaiaa ei figi. ");
INSERT INTO wuv_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Si'ei, ina warenaa a'a fei haihai, “Lomi nemea ba i hananadinaa fuamu.” Ma ei otalai nenerana, rona guainia ei fi ware. ");
INSERT INTO wuv_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Ro'aa pa'aa Jerusalem, Jesus na wadu'ainaa malalaa fei humuu mei Haidaa. Ma na una'ateteaa ei ponopono'a ma ei alo'aloa yei. Ina hadupoponainaa ei tawaa ei filogia mugoo po'i ma ei gutanaa ei roi alo pune, ");
INSERT INTO wuv_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","ma na apunainia ba nemeadiai nei'aa talai'ailao i malalaa fei humuu mei Haidaa ma notonaa ei manumanuu aloa. ");
INSERT INTO wuv_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Ma ei fi feroinaa ro'ou, ina ware, “Haa, lomi rona ne'inia ba: “‘Fei humuu, ro'awe roroinia ba hepalo humuu lafulafua a'a minaa ei gufu pedu’? Ma'uaa hamu'ou, hamona fafaia ale'ena ‘o'opa'ai ena fafanao.’” ");
INSERT INTO wuv_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Ei famamoaa humuu mei Haidaa ma ei feroiaa law, rona guainaa fei ma una'aa ma labaginaa hepalo tala ba ro'aa fo'afama'eia, uaa rona mama'au a'ana, hamatee minaa fei gupuu rama'a, ronamina malefa a'a ei feroiana. ");
INSERT INTO wuv_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","I nofafilao, rona asi'aa a'a fei baua gufu. ");
INSERT INTO wuv_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Mafufuo, ei roi talailao, rona fanunupa'aa fei haihai figi namina ma'epa'ai, ei warana ama'anaa no'una. ");
INSERT INTO wuv_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Na nonominia Peter ma na warenaa a'a Jesus, “Rabbi, ma'aia! Fei haihai figi, fei ona umuia, na ma'e!” ");
INSERT INTO wuv_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Jesus na ware, “Narafawe'i a'a mei Haidaa. ");
INSERT INTO wuv_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","A warefa'uai a'a hamu'ou, nabaa nemea i warenaa a'a fei maugeni ale'ei ba, ‘Aunu, wi siminaa ana yoi agi,’ ma lomi na hamamagua fei naranarana ma'uaa napa'aa we'i naranarana ba fei wareana i bigipa'i, iwe bigipa'i a'ana. ");
INSERT INTO wuv_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Si'ei, a warefanaa hamu'ou ba tamanu i'igiaa hamu'ou wagii fei lafulafua, narafawe'i ua ba hamona todigia ma iwe oanaa manumanuu hamu'ou. ");
INSERT INTO wuv_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Ena hamona ulafulafu ma na'aa hamona pa'i pidawaiaa hamu'ou a'a nemeadiai, futoaa hafelo'ana ba mei Amaa hamu'ou pafea ana i futoaa ei hafelo'aa hamu'ou.” ");
INSERT INTO wuv_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Rona hadiwe'idimai Jerusalem ma ei fi tatalai Jesus i malalaa fei humuu mei Haidaa, ei famamoaa humuu mei Haidaa, ei feroiaa law ma ei bauaniaa gufu, rona nomai a'ana. ");
INSERT INTO wuv_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Rona i'igai, “A'a tamanu forafora ba o bigi'aa eni manumanu eni? Ma fanaa hini yoi feni forafora ba o'aa bigi'ia?” ");
INSERT INTO wuv_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Jesus na ware, “Ana a i'igainaa hamu'ou hepalo i'igaia. Do'o warefanau ma awe warefanaa hamu'ou ba a'a tamanu forafora ba a bigi'aa eni manumanu. ");
INSERT INTO wuv_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Fei pudugufaiaa John—norai pafea, o nomai a'a rama'a? Ware fanau!” ");
INSERT INTO wuv_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Rona fiwareinia dupuaa ro'odu ale'ei ba, “Nabaa o ware ba, ‘Norai pafea,’ iwe i'igai, ‘Ma tani lomi hamona nara ba fa'ua ei wareana?’ ");
INSERT INTO wuv_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Ma'uaa nabaa o ware ba, ‘Nomai a'a rama'a’....” (Rona ma'auaa ei rama'a, uaa minaa ei rama'a, rona nara ba John, pa'aa mamama'a.) ");
INSERT INTO wuv_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Si'ei, rona warefanaa Jesus, “Lomi hai'ouna aida.” Na ware Jesus, “Ana lomi a warefanaa hamu'ou ba foraforaa hini fei a biginaa eni manumanu eni.” ");
INSERT INTO wuv_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Si'ei, na warehanunuinaa ei wareana a'a ro'odu: “Hemea na faroaa hefaa pe'ihape. Na nonoifaweloinia ma agifaa hepalo huapu ba i hapi'inaa ei wine ma faduaa hepalo tarea humuu fafanunu. Si'ei, na fifaninaa a'a hefi'a ba ro'awe pono'ia ma na aununaa a'a hepalo tatalaia. ");
INSERT INTO wuv_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","I pa'aa fei au hufu'a, na aloaa hemea nafi a'a ei oma'ama'aa fei pe'ihape ba neiree to hefi'a fuaa pe'ihape a'a ro'odu. ");
INSERT INTO wuv_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Ma'uaa rona panarofia, hafugia ma alo'uaia pani ua. ");
INSERT INTO wuv_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Si'ei, na alodinaa hemeadiai nafi a'a ro'odu; ma mei rama'a mei, rona hafugaa tabana ma fafeloia. ");
INSERT INTO wuv_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Ina alodinaa hemeadiai ma mei rama'a mei, rona fo'afama'eia. Ina aloaa wataudadiai; hefi'a ro'odu, rona hafugaa ro'ou ma hefi'a, rona fo'afama'eaa ro'ou. ");
INSERT INTO wuv_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","“Na pa'i hemea dufu ba i aloia, hemei na'una, baduu wawane; mei pa'aa haguna. Na aloia nenee minaa ro'odu. Na ware ale'ei ba, ‘Ro'awe ma'auaa mei na'uu.’ ");
INSERT INTO wuv_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","“Ma'uaa rona fiwarewarei ei oma'ama'aa fei pe'ihape ba, ‘Simeni, meni i tonaa feni pe'ihapee amana nabaa i ma'e mei amana. O dii, o fo'afama'eia ma fei pe'ihape, i udenaa pe'ihapee o'odu.’ ");
INSERT INTO wuv_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Si'ei, rona panarofia, fo'afama'eia ma suminia auguu fei pe'ihape. ");
INSERT INTO wuv_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","“Tamanu naraa hamu'odu ba i bigi'ia mei amaa fei pe'ihape? I nomai ma fo'afama'eaa ei oma'ama'aa fei pe'ihape ma i fanaa fei pe'ihape a'a hefi'adiai. ");
INSERT INTO wuv_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Haa, lo'e hamona igoaa feni ne'ia laloo fei Bu'u Apuna ba: “‘Fei mugoo, fei rona suminia ei fadufadua, ana sifei, i oanaa fasu'ufufugoi. ");
INSERT INTO wuv_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Mei Fasu na bigidigaa feni, ma namina fafanunufarawani pudaa o'odu’?” ");
INSERT INTO wuv_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Si'ei, rona lalabaginaa hepalo tala ba ro'aa panarobobo'inia, uaa rona aida ba ifi warehanunuinaa ro'odu, ma'uaa rona mama'au a'a fei gupuu rama'a. Si'ei, rona di'ininia ma aunu. ");
INSERT INTO wuv_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Hinene, rona aloaa hefi'a Pharisee ma ei maroaa Herod a'a Jesus ba ronei labaginaa tataa wareana. ");
INSERT INTO wuv_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Rona dinamii a'ana ma ware, “Mena feroia, hai'ouna aida ba yoi hemea wanewanea. Lomi ona fafefenaa wareaa ei rama'a, uatani, lomi ona nara ba ro'ou, rama'a bata; ma'uaa ona feroinaa fei talaa mei Haidaa a'a tamanu na fa'uai. Na rawani ba o fani mugoo po'ii gavaman a'a Caesar, o lomi? ");
INSERT INTO wuv_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","O fani, o, onei'aa fani?” Ma'uaa Jesus na apa'idigaa ei ware'oniaa ro'odu. Ina i'igai, “Tani hamu'ou mania ba hamo'aa fa'alabe'au? Tofanamiau hepalo denarius ma a ma'aia.” ");
INSERT INTO wuv_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Rona tonamai fei mugoo po'i ma na i'igainaa ro'odu, “Hanunuu hini feni? Ma feni ne'ia, haraa hini?” Rona ware, “Caesar.” ");
INSERT INTO wuv_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Si'ei, Jesus na warenaa a'a ro'odu, “Fanaa Caesar ei manumanuna ma fanaa mei Haidaa ei manumanuna.” Ma rona madu'ofo a'ana. ");
INSERT INTO wuv_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Si'ei, ei Sadducee, ei rona ware ba lomi ro'aa asi'aa ei ma'ea, rona nomai ma i'igainia hepalo i'igaia. ");
INSERT INTO wuv_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","Rona ware, “Mena feroia, Moses na ne'ifanaa o'odu ba nabaa nemea lofuu hemea i ma'edi'ininaa mei harona ma'uaa lomi na'una, mei lofuu mei ma'ea nei lalainaa mei haroo mei ma'ea ma nei fuaifani na'uu mei lofuna. ");
INSERT INTO wuv_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Te, na pa'i oloromea filofui. Mei uma'ua na lalai ma na ma'e ma lomi na'una. ");
INSERT INTO wuv_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Mei umugina na lalainaa mei pifine, mei ma'esuabea ma mei umugina, ana na ma'e, lomi na'una. Ana ale'ei a'a mei fa'o'oduiaa ro'odu. ");
INSERT INTO wuv_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Minaa ei oloromea, rona ma'e ma lomi rona difuai baduu ma nene, ana nawe ma'e mei pifine. ");
INSERT INTO wuv_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","A'a fei au asi'anab haroo hini ro'odu mei pifine? Te, minaa ei oloromea, rona lalainia?” ");
INSERT INTO wuv_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Jesus na ware, “Tani, hamo'aa poapoai? Haa, lomi hamona apa'aa fei Bu'u Apuna, o fei faufau mei Haidaa? ");
INSERT INTO wuv_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Ena rona asi'aa ei ma'ea, lomi ro'aa lalai o falalai; rowe ale'ena ei alo'alo pafea. ");
INSERT INTO wuv_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Ma a'a fei ba ro'aa asi'aa ei ma'ea—haa, lomi hamona igoia a'a fei Bu'uu Moses, ei i gu'agu'a fei haihai, na warefania mei Haidaa, ‘Yau, mei Haidaniaa Abraham, mei Haidaniaa Isaac ma mei Haidaniaa Jacob’? ");
INSERT INTO wuv_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Abaa hia Haidaniaa ei ma'ea, uaa Haidaniaa ei rona werawera. Hamonamina tatafafelo!” ");
INSERT INTO wuv_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Na nomai hemea feroiaa law ma na guainaa ro'odu, roi fiharenii. Na fanunupa'ia ba Jesus na fanifarawani warea a'a ei i'igaiaa ro'odu ma i'igainia, “A'a minaa ei law, afaia na pafeainaa ro'ou?” ");
INSERT INTO wuv_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Na ware Jesus, “Fei namina pafeai, sifeni: ‘Ena Israel, hamonei guainia, mei Fasu, mei Haidaniaa o'odu, hia hemea ua. ");
INSERT INTO wuv_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Haguaa mei Fasu, mei Haidaniamu a'a minaa ei naranaramu ma a'a minaa ei fawewenimu ma a'a minaa ei apa'amu ma a'a minaa ei faufaumu.’ ");
INSERT INTO wuv_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Fei faguapaloana, sifeni: ‘Haguaa mei gufumu ana ale'ei ona haguio.’ Lomi hepalodiai law na muainaa guapaloeni.” ");
INSERT INTO wuv_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Na ware mei rama'a mei, “Mena feroia, ona warepa'ia. Na wanewane ei wareamu ba hemea ua Haidaa ma lomi hemeadiai ma'uaa hia ua. ");
INSERT INTO wuv_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Fei ba onei haguia a'a minaa ei naranaramu ma minaa ei apa'amu ma minaa ei faufaumu ma fei ba onei haguaa mei gufumu ana ale'ei ona haguio na mua laraa fei fagu'amu minaa ei manulelele ma minaa ei fana a'a Mei Haidaa.” ");
INSERT INTO wuv_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","I fanunuia Jesus ba mei rama'a mei, na warepa'ia ale'ei ei i'igaiana, ina ware a'ana, “Lomi ona raua a'a fei haparaiaa mei Haidaa.” Ma nenee fei, lomi nemea na laugu'ai ba i i'iginia hefi'adiai i'igaia. ");
INSERT INTO wuv_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Ei fi wareware Jesus yei malalaa fei humuu mei Haidaa, na i'igainaa ro'ou ba, “Tani ro'aa ware ei feroiaa law ba Christ, na'uu David? ");
INSERT INTO wuv_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","David, a'a fei faufau fei Spiriti Apuna, ana na ware: “‘Mei Fasu na ware a'a mei Fasuu: “Guta pepei ma'auu hawina una aunaa ena bidibidii unumu haroo pinemu.” ’ ");
INSERT INTO wuv_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","David, ana na ware ba mei rama'a mei, hia ‘Fasu.’ Tani ei ba hia na'uu David?” Fei baua gupuu rama'a, rona guainia ma rona ni'eni'e. ");
INSERT INTO wuv_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Ei fi feroinaa ro'odu Jesus na ware ba “Oma'aa hamu'odu a'a ena feroiaa law. Ronafane'aida fareaa ena maleaa susu ma tatalai fawelei rona'o alo'alo manumanu ba ronei fafanununaa ro'ou ei rama'a. ");
INSERT INTO wuv_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Ma tonaa ena gutaa ena bauana laloo ei synagogue ma a'a ena baua hananaa rona'o guta a'a ei gutaa ena baua rama'a. ");
INSERT INTO wuv_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Rona fa'amoaa humuu ei pifine ma'esuabea ma ronamina lafulafu famalaa ba ei rama'a, ronei fanunuaa ro'odu. Ei rama'a ale'ei, ro'awemina pa'i fagianaa ro'odu.” ");
INSERT INTO wuv_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Jesus na guta'oma'alao a'a fei bao mugoo po'i, fei rona'o augaa ei fana lalona ma ina'o pupudainaa ei ro'ei au mugoo po'i a'a fei bao mugoo po'i i humuu mei Haidaa. Watauda, ei rona pa'i watauda mugoo po'i, rona aufawatauda. ");
INSERT INTO wuv_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Ma hemea pifine ma'esuabea na nomai, lomi na pa'i watauda mugoo po'ina. Ina nomai ma augaa guapalo pusu'oro mugoo po'i, puduna ale'ena guapalo toea. ");
INSERT INTO wuv_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Jesus na harofamii ei otalai nenerana ma ware ba, “A warefa'uai a'a hamu'odu ba mei pifine mei, na watauda ei augana laraa ei augaa minaa ei rama'a. ");
INSERT INTO wuv_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Minaa ei rama'a ei, rona fani a'a ei watauda manumanu rona pa'i. Ma hia na aupedugaa ma'idei hodihodiana.” ");
INSERT INTO wuv_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Ei i asi'adi'ininaa fei humuu mei Haidaa Jesus, hemea ei otalai nenerana na warenaa a'ana, “Mena feroia, fanunulao! Po'o baua mugoo bata ei! Ana ronamina fananamai ei humu!” ");
INSERT INTO wuv_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Jesus na ware, “Ma'a, ena baua humu ena, pa'aa lomi i ufalarai hepalo mugoo pafoo hepalodiai. Minaa ena mugoo ena, hefi'a rama'a, ro'awe fawata'o'onaa ro'ou pu.” ");
INSERT INTO wuv_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Ma i guta pafoo fei Maugeni Olive Jesus, i oma'analoo fei humuu mei Haidaa, Peter, James, John ma Andrew, rona i'igifagiginia, ");
INSERT INTO wuv_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","“Warefanaa hai'odu ba i nomai nahaiga ei manumanu ei ma tamanu lalana ba na rafi'i fei au ba ei manumanu ei, ana i sufudaimai.” ");
INSERT INTO wuv_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Jesus na warenaa a'a ro'odu, “Oma'ama'a ba lomi nemea i sifi'aa hamu'ou. ");
INSERT INTO wuv_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Watauda, ro'aa nomai a'a fei harau ma ware ba, ‘Yau hia,’ ma ro'aa sifi'aa watauda. ");
INSERT INTO wuv_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Ena hamona guainia ba i pa'i fifo'aia ma ena u'uga ba ro'ei fifo'ai, apuna ma'aua. Ei manumanu ale'ei nei pa'aa nomai, ma'uaa fei ia'iana ataa nomai. ");
INSERT INTO wuv_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Ei baua gufu ro'aa fifadugei ma hefi'a hapara anaa. I rerere feni malagufu ma i pa'i mouabiabia a'a watauda gufu. Ena manumanu ena, ale'ei ei rawarawa fi'iaa waninia. ");
INSERT INTO wuv_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","“Hamonei ofawe'i. Ro'awe fifaninaa hamu'ou a'a ei bauaniaa gufu ma ro'aa hafugaa hamu'ou laloo ei synagogue. Si'ei ba hamona nenerau, hamowe ufalarai pudaa ena bauana ma ena hapara ale'ena u'ugaa hamu'ou a'a ro'odu. ");
INSERT INTO wuv_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Fei rawani'a warea ido'omina dipedunaa ena gufu. ");
INSERT INTO wuv_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Ma ena rona panarofaa hamu'odu ma notonaa hamu'odu dududua, apuna naranara watauda ba hamo'aa wareaa tamanu. Ware'uaiaa tamanu na nomai naranaraa hamu'odu a'a fena au fena. Uaa, abaa hamu'odu ena hamona wareware, uaa fena Spiriti Apuna. ");
INSERT INTO wuv_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","“Hemea i aloaa mei lofuna a'a hefi'a ba ronei fo'afama'eia. Mei ama ana i bigi'ia ale'ei a'a mei na'una. Ei baduu, ro'aa una'aa ma fadugeaa ei ama ma inaa ro'odu ma aunaa ro'ou ma'ea. ");
INSERT INTO wuv_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Minaa ei rama'a, i bidibidi unuu ro'odu a'a hamu'odu uaa yau ma hini i narafawe'i a'au nopa'aloo fei ia'iana, i tela. ");
INSERT INTO wuv_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","“Ma ena hamona fanunupa'aa mei ‘hafelo'a, mei ba i fafeloaa fei humuu mei Haidaa’ ba na oa laloo fei humu apuna—mei igoa nei apa'ia—ena ro'ou yena Judea, ronei ponipa'ainaa a'a ei maugeni. ");
INSERT INTO wuv_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Nabaa nemea i pafoo humuna, inei'aa u'upuwadu'ai ba i to manumanu. ");
INSERT INTO wuv_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Na'aa nemea yei laloo pe'ihape, inei'awe bagua ba i tonaa fei hawaa uguna. ");
INSERT INTO wuv_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","A'a ena arewaa ena, pa'aa famama'au a'a ena wareu ma ena roi fasusu baduu! ");
INSERT INTO wuv_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Lafulafu ba fei au ponipa'aia nei'awe nomai laloo fei au baua maunu o lalarena, ");
INSERT INTO wuv_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","uaa laloo ena arewaa ena, i pa'i baua hafelo'a. Ena baua hafelo'a ena, lomi na u pa'i ei i famamaraa feni malagufu mei Haidaa nopa'amii wagieni ma lo'e i fai pa'idiai. ");
INSERT INTO wuv_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Nabaa lomi i faweleguinaa ei arewaa ei mei Fasu, lomi nemea i tela ma'uaa, si'ei ba rona guta ei rafeiana, mei Fasu i faweleguinaa ei arewaa. ");
INSERT INTO wuv_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","A'a fena au fena, nabaa i nomai nemea ma i ware a'amu ba, ‘Ma'a, Christ, hia yeni,’ o ‘Hia simei’ apuna guainia. ");
INSERT INTO wuv_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Uaa ena sifisifi Christ ma sifisifi mamama'a, ro'awe nomai ma bigi'aa ei hilala ma foigia ba ro'aa sifi'aa ei apunaia na'aa na ma'atalaa. ");
INSERT INTO wuv_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Hamonei ofafaufau, uaa na warefanidigaa hamu'odu ei manumanu rotawe nomai. ");
INSERT INTO wuv_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","“Nenee fei hafelo'a a'a ena arewaa ena, “‘fei halo i roroma, fei puda, lomi i fanaa fei we'aina; ");
INSERT INTO wuv_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","ei pi'u, ro'aa pasigai pumanugawe, ei manumanuu haroo pafea, ro'aa rerere.’ ");
INSERT INTO wuv_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","“A'a fena au fena, ei rama'a, ro'awe fanunupa'aa mei Na'uu Rama'a i norai pafoo ei papalei fininaa baua faufau ma hawera. ");
INSERT INTO wuv_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Ma iwe aloaa ei alo'alona ma ro'awe dugifipuipuinaa ena rafeiana a'a feni tadiwe'aiaa feni malagufu, Rai, Hafaa, Oala ma Hara'uu a'a fena ia'iaa feni malagufu ma ena haroo pafea. ");
INSERT INTO wuv_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","“Hamonei to feroia a'a fei maumau fei haihai figi: ena na sunaimai ei nusuna ma na pa'i rauna hamona aidadii ba fei rai na rafi'i. ");
INSERT INTO wuv_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Ana ale'ena, hamona fanunupa'aa ena manumanu ena na sufudai, hamonei aida ba, na rafi'i, ana pa'aa papaa fei gigei. ");
INSERT INTO wuv_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","A warefa'uai a'a hamu'ou ba eni rama'aa taweni pa'aa lomi ro'aa ma'epedu, ro'aa ma'a minaa eni manumanu eni rona sufudai. ");
INSERT INTO wuv_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Fei haroo pafea ma feni malagufu, lagu'awe pa'ai, ma'uaa fei wareau, pa'aa lomi iwe pa'aitoo. ");
INSERT INTO wuv_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","“Lomi hemea na apa'aa fei arewaa ma fei au. Ei alo'alo yei pafea ma mei Na'u, ana lomi rona aida, ma'uaa uniaa mei Ama. ");
INSERT INTO wuv_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Ofafaufau ma oma'ama'a. Lomi hamona aida ba fei au fei, i nomai nahaiga. ");
INSERT INTO wuv_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Ale'ei hemea ba i tatalai rauaa. Na augaa ei nafina oma'ama'aa fei humuna. Na fani bigi'aa hememea ei nafina. Na warenaa a'a mei oma'aa fei gigei ba nei ofafaufau. ");
INSERT INTO wuv_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","“Si'ei ba hamonei oma'ama'a, uaa lomi hamona aida ba nahaiga na hadiwe'imai mei amaa fei humu, i nomai na fafi, o difa'u'u, na a'aroi fena a'aroo, o ba'apanii arewaa. ");
INSERT INTO wuv_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Nabaa i no'amai, lomi na rawani ba i nopoponinamii hamu'ou fi ma'igu. ");
INSERT INTO wuv_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Tamanu ena na wareia a'a hamu'odu, ana fi warenaa a'a ro'odu: ‘Ofafaufau!’” ");
INSERT INTO wuv_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Eni, dufu guai arewaa ba i nomai fei Talai Falogia ma fei Hananaa fei Faraa Pidaua Lomi Fafuafua. Ma ei famamoaa humuu mei Haidaa ma ei feroiaa law, rona lalabaginaa hefi'a manitoai ba ro'aa panarofaa Jesus ma fo'afama'eia. ");
INSERT INTO wuv_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Rona ware, “Ma'uaa, onei'aa bigi'ia wagii fei au Hananaa, uaa ei rama'a, ro'amina fisisibai.” ");
INSERT INTO wuv_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Ma yei Bethany, ei i gutafapalagi a'a fei tawa laloo fei humuu hemea, harana Simon mei Watawatai, ina nomai hemea pifine na notonamii hepalo pe'ii fei pa'aa pao dufa, bauana pono'ana ma fei pao fei, hepalo pa'aa guana pe'ihape. Ina bagu'uia ma na iginaa fei pao dufa tabaa Jesus. ");
INSERT INTO wuv_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Hefi'a yei, rona siba ma fiwarewarei ba, “Tani i pedu'uaiaa feni pao dufa? ");
INSERT INTO wuv_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Nabaa o aloia, pono'ana i puduaa pono'aa hemea laloo he'ai igisimasi ma ei mugoo po'i, i dinaa a'a ei lomi manumanuu ro'ou.” Ma rona sibahota'ia. ");
INSERT INTO wuv_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Na ware Jesus, “Apuna papa'ana. Tani hamo'aa fa'uduguguaa ununa? Ina bigi'aa hepalo pa'aa rawani'a manumanu a'au. ");
INSERT INTO wuv_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Ena lomi manumanuu ro'ou, hamo'aa oa a'a ro'odu ranimai ma hamo'aa hadumaa ro'ou a'a tamanu au hamona nunuminia ma'uaa yau, lomi a oa a'a hamu'ou ranimai. ");
INSERT INTO wuv_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Mei pifine na bigi'aa tamanu na hawia. Na igiaa fei pao dufa unuu ba i pagipagi'augau a'a fei i'ifaia. ");
INSERT INTO wuv_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","A warefa'uai a'a hamu'odu ba ro'amina wareaa fei rawani'a warea hitani tadiwe'aiaa malagufu, tamanu na bigi'ia, ana rowe u'ugia ale'ei hanununa.” ");
INSERT INTO wuv_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Judas Iscariot, hemea ei hefua ma helagui na dinaa a'a ei famamoaa humuu mei Haidaa ba i aloaa Jesus a'a ro'odu. ");
INSERT INTO wuv_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Ronamina ni'eni'e ei ro'aa guainia ma rona fa'unai a'ana ba ro'aa fani mugoo po'i a'ana. Si'ei, ifi farerefai rawani'a au ba i fifaninia panii ro'ou. ");
INSERT INTO wuv_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","A'a fei rawarawa arewaa fei Hananaa fei Faraa Pidaua Lomi Fafuafua, fei maumau ro'ou ba ro'aa apamoro'aa fei sipsipii fei Talai Falogia. Ma a'a fei arewaa fei, rona i'iginaa Jesus ei otalai nenerana, “Nunumiamu ba hai'ou re pagi'augaa gutanamu hitani ba o'aa hanana a'a fei Hananaa fei Talai Falogia?” ");
INSERT INTO wuv_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Si'ei na aloaa helagui otalai nenerana ma na ware, “Wadu'ainaa a'a fena gufu ma hemea na poroporo'aa hepalo baraa ranu, iwe suafinaa hamugua. Nenegia. ");
INSERT INTO wuv_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Ware a'a mena amaa fena humu, fena hia i wadu'ia ba, ‘Mei Feroia na i'igai, “Hitani fei gutanau ba a hanana hugiaa ei otalai nenerau wagii fei Hananaa fei Talai Falogia?” ’ ");
INSERT INTO wuv_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Iwe fama'aa hamugua hepalo baua humu tare, na ude'audii ena manumanu. Pagi'au gutanaa o'ou yena.” ");
INSERT INTO wuv_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Laguei otalai nenera na aunu, wadu'ainaa fei gufu ma fanunupa'aa ei manumanu ana ale'ei wareaa Jesus a'a lagua. Si'ei, laguna pagiaa minaa ei manumanuu fei Hananaa fei Talai Falogia. ");
INSERT INTO wuv_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","I fafilao, Jesus na sufudaifipuimai a'a ei hefua ma helagui. ");
INSERT INTO wuv_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Ro'aa gutafapalagi a'a fei tawa, ina ware, “A warefa'uai a'a hamu'odu ba hemea hamu'ou i aloau, hemea fi hanana a'au.” ");
INSERT INTO wuv_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Ronamina faloloa'i ma hememea na ware a'ana, “A'a ba yau?” ");
INSERT INTO wuv_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Ina ware, “Hia, hemea ei hefua ma helagui. Hemeni i pudigaa feni faraa pidaua laloo feni lopi i a'au. ");
INSERT INTO wuv_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Mei Na'uu Rama'a i aunu ana ale'ei rona ne'inaa u'ugana ma'uaa, napa'aa fagiana mena i aloaa mei Na'uu Rama'a! Na rawaninia nabaa lomi na wanini.” ");
INSERT INTO wuv_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Ro'ei hanana, Jesus na tonaa fei faraa pidaua, ware ‘ta’, bidigeia, fanaa ei otalai nenerana ma ware, “Tonia; feni, hudi unuu.” ");
INSERT INTO wuv_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Ma na tonaa fei bara, ware ‘ta’, fanaa ro'odu ma minaa ro'ou, rona hunu wagina. ");
INSERT INTO wuv_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Na warenaa a'a ro'odu, “Feni, namou, feni i hupu'inaa feni fi'ugaia, feni i wigii a'a watauda. ");
INSERT INTO wuv_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","A warefa'uai a'a hamu'odu ba lomi a hunudinaa fei ranuu grape hawina fena arewaa na hunumanufaudinia wagii fei haparaiaa mei Haidaa.” ");
INSERT INTO wuv_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Ro'aa laugidigaa hepalo lauga, rona asi'aa ma aununaa fei Maugeni Olive. ");
INSERT INTO wuv_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Jesus na warefanaa ro'ou, “Minaa hamu'ou, hamo'aa ofadugau, uaa na ne'idii ba: “‘U'a fo'afama'eaa mei oma'ama'aa sipsipi, ma ei sipsipi, ro'aa talanenei.’ ");
INSERT INTO wuv_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Ma'uaa nenee fei una asi'adii, awe o'a'aununaa ma'aa hamu'odu dinaa Galilee.” ");
INSERT INTO wuv_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Peter na ware, “Na'aa minaa ei ro'aa ofadugio, yau, pa'aa lomi.” ");
INSERT INTO wuv_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Jesus na ware, “A warefa'uai a'amu ba wagieni, hi'i, poi wagieni, atawe faguapoai aigaa fei a'aroo, ido'o odupoai waresuabaduamu yau a'a hefi'a.” ");
INSERT INTO wuv_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Ma'uaa Peter namina warefawe'i ba, “Nabaa ana a ma'efipui a'amu, pa'aa lomi awe ofadugio.” Ma ana ale'ei wareaa minaa ro'ou. ");
INSERT INTO wuv_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Rona dinaa a'a hepalo pe'ihape, harana Gethsemane ma Jesus na warenaa a'a ei otalai nenerana, “Guta yeni ena na lafulafu.” ");
INSERT INTO wuv_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Ina dugi'uaiaa Peter, James ma John ma nawemina awata ununa. ");
INSERT INTO wuv_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Ma na warenaa a'a ro'ou, “Namina muainau fei faloloa'iau ma ba apo'o bima'e ua. Oa yeni ma oma'ama'a.” ");
INSERT INTO wuv_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","I nofaraualao ma'ida, na fapasinaa malagufu ma lafulafu ba na'aa na hawia, fei au neipo'o falogii a'ana. ");
INSERT INTO wuv_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Ina ware, “Abba, O'ama. Minaa ei manumanu na ma'atalaa a'amu. Tonaa feni bara a'au ma'uaa onei'aa bigi'aa nunumiau, uaa nunumiamu.” ");
INSERT INTO wuv_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Na hadiwe'inamii a'a ei otalai nenerana ma bapa'aa ro'odu, rona ma'igu. Na warenaa a'a Peter, “Simon. Haa, ona ma'igu? Ana lomi ba opo'o oma'ama'a ale'ena heai hour? ");
INSERT INTO wuv_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Oma'ama'a ma lafulafu ba lomi o'aa pasinaa laloo ei manimania. Fei spiriti na nunuminia ma'uaa fei hudi unu na rafilele.” ");
INSERT INTO wuv_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Na aunudiai ma lafulafunaa ana fei. ");
INSERT INTO wuv_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","I hadiwe'idimai, na bapa'idinaa ro'ou, rona ma'igu, uaa ei pudaa ro'ou na awata. Lomi rona aida ba ro'aa wareaa tamanu a'ana. ");
INSERT INTO wuv_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","I hadiwe'idimai fei fa'odupoana, na warenaa a'a ro'odu, “Ana hamo'ei ma'igu ma fawenai ua? Na ha'iai! Fei auu nawe nomai. Ma'a, mei Na'uu Rama'a, rona alodigia panii ei hafelo'a. ");
INSERT INTO wuv_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Asi'aa! Odii! Simena fi nomai mena i aloau!” ");
INSERT INTO wuv_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Ana fi wareware, Judas, hemea ei hefua ma helagui na sufudaimai. Rona nofipuimai a'ana hefaa baua gupuu rama'a, notonamii ei wadu ma ei hafuhafu. E'ei, aloamii ei famamoaa humuu mei Haidaa, ei feroiaa law ma ei bauaniaa gufu. ");
INSERT INTO wuv_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Ma mei i aloia nadii ware a'a ro'odu ba ale'ei uni'unina, “Mena una hatofaa pudana, simena; patarofia, nodugia ma oma'afarawaninia.” ");
INSERT INTO wuv_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Ana ei i nolao a'a Jesus, Judas na ware, “Rabbi!” ma na hatofaa pudana. ");
INSERT INTO wuv_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Ei rama'a, rona patarofaa Jesus ma panarofia. ");
INSERT INTO wuv_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Ma hemea a'a ei rona ufalarai na rapu'aa waduna ma lafigifamosu'aa adiaa mei nafii mei pa'aa bauaniaa humuu mei Haidaa. ");
INSERT INTO wuv_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Na ware Jesus, “Haa, una famamoaa ei hafelo'a rama'a, te hamo'aa notomai wadu ma hafuhafu ba hamo'amii panarofau? ");
INSERT INTO wuv_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Minaa ei arewaa, yau i a'a hamu'odu, feferoi malalaa fei humuu mei Haidaa ma lomi hamona panarofau ma'uaa fei Bu'u Apuna neipa'aa fa'uai.” ");
INSERT INTO wuv_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Ma minaa ei a'ana, rona ponipa'aidi'ininia. ");
INSERT INTO wuv_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Ma'uaa hemea baubara na papai ua lawalawa, na neneraa Jesus. Ro'aa patarofia, ");
INSERT INTO wuv_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","na poni'alawata ua, na ponidi'ininaa fei lawalawana. ");
INSERT INTO wuv_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Rona nodugaa Jesus i ma'aa mei pa'aa bauaniaa humuu mei Haidaa. Ma minaa ei famamoaa humuu mei Haidaa ma ei bauaniaa gufu mawe ei feroiaa law, rona figupuimai. ");
INSERT INTO wuv_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Peter na nenegia, ma'uaa na raua ma'ida a'ana. Namina wadu'ai'aunulao malalaa fei humuu mei pa'aa bauaniaa humuu mei Haidaa. Na guta yei a'a ei oma'ama'aa ma fi fana'a a'a fei hafi. ");
INSERT INTO wuv_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Ei famamoaa humuu mei Haidaa ma minaa ei bauaniaa ei Jew, ro'ei lalabarainaa ei tataa Jesus ba ro'aa fo'afama'eia ma'uaa, lomi rona labagipa'aa hepalo. ");
INSERT INTO wuv_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Watauda na u'ufasifi ba hia ale'ei, ma'uaa ei u'ugaa ro'ou lomi na fibo'ii. ");
INSERT INTO wuv_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Ma hefi'a, rona ufalarai ma fanaa eni sifisifi u'ugaa ro'ou hia: ");
INSERT INTO wuv_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“Hai'ouna guainaa wareana ba, ‘Awe fawata'o'oaa feni humuu mei Haidaa feni faduaa rama'a ma laloo oduai arewaa a faduaa hepalodiai, abaa faduaa rama'a.’” ");
INSERT INTO wuv_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Ma'uaa, ana lomi na fibo'ii ei u'ugaa ro'odu. ");
INSERT INTO wuv_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Si'ei, mei pa'aa bauaniaa humuu mei Haidaa na ufalarai ma'aa ro'odu ma na i'iginaa Jesus, “Haa, lomi ba o wareware? Tamanu feni u'ugaa eni rama'a eni, rona u'ugio?” ");
INSERT INTO wuv_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Ma'uaa Jesus na ufamadumu ua, lomi na wareware. Na i'igaidinia mei pa'aa bauaniaa humuu mei Haidaa, “Haa, yoi mei Christ, mei Na'uu mei Hawegia?” ");
INSERT INTO wuv_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Na ware Jesus, “Yau ua. Ma owe fanunuaa mena Na'uu Rama'a na guta pepei ma'au Mei Faufaua, ena na nogio pafoo ei papalei pafea.” ");
INSERT INTO wuv_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Mei pa'aa bauaniaa humuu mei Haidaa na foradigeaa ana fei susuna ma ware, “Tani o nunumidinaa hemeadiai i u'u? ");
INSERT INTO wuv_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Hamona guaidigia ba na warefafeloaa mei Haidaa. Tamanu naraa hamu'odu?” Minaa ro'ou na ware ba na rawani ba inei ma'e. ");
INSERT INTO wuv_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Ma hefi'a, rona una'aa ma huwia; rona sumaa pudana, du'umaa panii ro'odu, fo'aia ma ware ba, “Ware unia!” Ma ei oma'ama'aa na dugia ma lapagia. ");
INSERT INTO wuv_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Peter yei fawelei pu ma hemea ei nanao nafii mei pa'aa bauaniaa humuu mei Haidaa na nomai. ");
INSERT INTO wuv_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","I fanunupa'aa Peter fi fana'ana'aiaa ununa, na fanunufa'u'uia. Ina ware, “Yoi ana a'a Jesus, mei Nazareth.” ");
INSERT INTO wuv_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Ma'uaa ina waresuabadunia ba, “Lomi na apa'aa ena oi wareia,” ma na dinaa poaa humu. ");
INSERT INTO wuv_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","I fanunupa'ia yei mei nanao nafi, na warediai a'a ei ro'aa ufalarai yei, “Hia, hemea ro'odu.” ");
INSERT INTO wuv_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Na suabadui-diai. Madilao ma'ida, ei ro'aa ufalarai papaa Peter, rona ware, “Pa'aa fa'ua. Yoi hemea ro'odu, uaa yoi hemea Galilee.” ");
INSERT INTO wuv_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Inawe umuaa anaia ma warefa'unai a'a ro'odu ba, “Lomi na apa'aa mena hamo'ei warewareia.” ");
INSERT INTO wuv_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Ana ei, fei a'aroo na a'aroi faguapoai. Si'ei, Peter na nonominaa fei wareaa Jesus a'ana: “Nenee fei fa'odupoaa ofadugamu yau, i guapoai a'aroiaa fei a'aroo.” Ina narahadiwe'inia ma na ai. ");
INSERT INTO wuv_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Mafufuo badu ei famamoaa humuu mei Haidaa fipuinaa ei bauaniaa gufu, ei feroiaa law mawe minaa ei bauaniaa ei Jew, ronawe pa'apa'ainaa hepalo naranara. Rona fauroro'inaa Jesus, nodugia ma fifaninia a'a Pilate. ");
INSERT INTO wuv_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Na i'igai Pilate, “Haa, yoi mei haparaa ei Jew?” Na ware Jesus, “Hi'i. Ana ale'ena wareamu.” ");
INSERT INTO wuv_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Ei famamoaa humuu mei Haidaa, rona uni'unia a'a watauda manumanu. ");
INSERT INTO wuv_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Si'ei, na i'igidinia Pilate, “Lomi o wareware? Ma'aia. Rona ware ba ona bigifatataiaa watauda manumanu.” ");
INSERT INTO wuv_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Ma'uaa lomi na wareware Jesus ma Pilate na hawai'uaiaa poana. ");
INSERT INTO wuv_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Hepalo maumau wagii fei Hananaa ba i ala hemea bobo'aia, mei rona nunuminia ei rama'a. ");
INSERT INTO wuv_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Hemea, harana Barabbas, hia laloo humuu bobo'aia. Hia hemea na fo'afama'e a'a fei au hefi'a na fadugedugeaa ei bauaniaa gufu. ");
INSERT INTO wuv_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Ei rama'a, rona nomai a'a Pilate ma i'iginia ba nei bigi'ia a'a ro'odu ale'ei ina'o bigi'ia. ");
INSERT INTO wuv_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Na i'igai Pilate, “Hamona nunuminau ba a alafanaa hamu'odu mei haparaa ei Jew?” ");
INSERT INTO wuv_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Na aidadii ba ei famamoaa humuu mei Haidaa, rona fifaninaa Jesus a'ana uaa fei punepuneaa ro'odu. ");
INSERT INTO wuv_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Ma'uaa ei famamoaa humuu mei Haidaa, rona fa'una'anaa ei rama'a ba Pilate nei alafanaa ro'odu Barabbas. ");
INSERT INTO wuv_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Pilate na i'iginaa ro'odu, “A bigi'aa tamanu a'a mei hamona ware ba haparaa ei Jew?” ");
INSERT INTO wuv_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Rona memewai, “Fatawaia!” ");
INSERT INTO wuv_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Na i'igai Pilate, “Hamatani? Tamanu ei bigifatatana?” Ma ronamina memewai'apoidiai, “Fatawaia!” ");
INSERT INTO wuv_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Si'ei ba i fawaneneaa ei rama'a, Pilate na alafanaa ro'odu Barabbas. Na uga ba Jesus nei to hafuhafu ma fifaninia ba nei fatawa. ");
INSERT INTO wuv_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Ei fo'aa, rona noduginaa Jesus laloo fei baua humuu mei bauaniaa fo'aa (harana ‘Praetorium’) ma harofipuinaa minaa ei fo'aa. ");
INSERT INTO wuv_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Rona farafenaa hia fei susu, pomana watolaa marawi ma roa ma rona fifigaa hepalo hogiaa tao ma fataonaa tabana. ");
INSERT INTO wuv_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Ma ronawe haronaa a'ana, “Uu, mena haparaa ei Jew!” ");
INSERT INTO wuv_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Rona hafuhafugaa tabana a'a hepalo o ma huwia. Rona fa'unaa du'uu ro'ou ma losuinia. ");
INSERT INTO wuv_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Ei ro'aa hapehapeidigia, rona dudumaa fei susu ma farafedinaa hia ana fei susuna. Si'ei, rona nodugia ba ro'aa fatawaia. ");
INSERT INTO wuv_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Hemea Cyrene, harana Simon, mei amaa Alexander ma Rufus, hia noranarai sugutata'aia ma fi talaifaloginaa ro'odu ma rona ware ba inei harenaa fei hawafolo. ");
INSERT INTO wuv_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Rona nodugaa Jesus fawelei rona ware ba Golgotha (hanuna Fawelei Guitaba). ");
INSERT INTO wuv_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Si'ei, rona fani numana wine na fihafuinaa myrrh ma'uaa lomi na hunumia. ");
INSERT INTO wuv_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Rona fatawaia ma alaginaa ei susuna. Ma hememea ro'ou na tonaa ei susuna a'a fei uni'uni fifigaia. ");
INSERT INTO wuv_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","A'a fei oduai hour (ale'ei 9 ido'o mafufuo), rona fatawaia. ");
INSERT INTO wuv_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Fei ne'ia ba fei tatana ale'ei: ");
INSERT INTO wuv_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Rona fatawaiaa laguei fafanao a'ana. Hemea, ma'auna ma hemea mauwina. ");
INSERT INTO wuv_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Ei rona talaifalogilao, rona hararasinia. Rona oro'oreinaa tabaa ro'odu ma ware ba, “Yoi, mena ba o fawata'o'oaa fei humuu mei Haidaa ma faduia laloo odu'ai arewaa, ");
INSERT INTO wuv_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","nadii, upugio a'a fena hawafolo ma hadumaa ana yoi!” ");
INSERT INTO wuv_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Ana ale'ei, ei famamoaa humuu mei Haidaa ma ei feroiaa law, rona hararasinia dupuaa ro'odu. Rona ware ba, “Na hadumaa hefi'a, ma'uaa lomi i hadupa'aa anaia! ");
INSERT INTO wuv_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Mena Christ, mena haparaa Israel, upugio eni a'a fena hawafolo ma hai'ou fanunuia ma nara ba fa'ua.” Laguei, lagu'aa fatawa a'ana, ana lagunamina hararasinia. ");
INSERT INTO wuv_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","A'a fei fa'oloroaa hour fei roromaa na hawa'onaa minaa feni malagufu nopa'aloo fei fafaimpaloaa hour. ");
INSERT INTO wuv_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Ma a'a fei fafaimpaloaa hour, Jesus na aimemewai, “Eloi, Eloi, lama sabachthani?”—hanuna ba, “Mena Haidaniau, Mena Haidaniau, tani o ofadugau?” ");
INSERT INTO wuv_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Hefi'a ei ro'aa ufalaraifarafi'i, rona guainia ma ware, “Guainia, ifi harofaa Elijah.” ");
INSERT INTO wuv_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Hemea na poni ma fahinumaa fei waraguaa wine a'a fei hinu ma augia a'a hepalo raramanu ma fanaa Jesus ba nei hunumia ma na ware, “Apuna papa'ana. Odo'o ma'a ba i nomai Elijah ma fa'u'upuia.” ");
INSERT INTO wuv_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Jesus nawemina aimemewai ei fidii fawenai'apoi. ");
INSERT INTO wuv_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Fei rapirapii fei humuu mei Haidaa na ba'a'anininaa guapapa, fa'ugio pa'udu ma aununaa pu. ");
INSERT INTO wuv_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Ma na ufalarai ma'aa Jesus hemea centurion. I guainaa fei aigana ma fanunuia batanai fi ma'e, na ware, “Pa'aa fa'ua ba meni rama'a meni, pa'aa Na'uu mei Haidaa!” ");
INSERT INTO wuv_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Hefi'a pifine, rona ufanunumai rauaa. Dupuaa ro'odu, Mary Magdalene, Salome, Mary, mei inaa James mei baubara ma ana inaa Joses. ");
INSERT INTO wuv_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Yei Galilee eni pifine eni, ronafane nenegia ma hadumia a'a ei nunumiana. Wataudadiai pifine, ei rona nofipuimai a'ana dinaa Jerusalem, ro'ou yei anaa. ");
INSERT INTO wuv_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Ma fei, arewaa Pagipagia (hanuna ba, nenee fei arewaa fei, Sabbath). Ma fi fafimai, ");
INSERT INTO wuv_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Joseph, mei Arimathea, hemea bauaniaa ei Jew, hemea rona ma'auia, mei ana fi guta'oma'aa fei haparaiaa mei Haidaa, na aunufarawaninaa a'a Pilate ma i'igainaa fei hudi unuu Jesus. ");
INSERT INTO wuv_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Pilate na ba'arofo ei i guainia ba na ma'edii. Na harofaa mei centurion ma i'iginia ba napa'aa ma'edii Jesus. ");
INSERT INTO wuv_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","I guaidigia a'a mei centurion ba pa'aa fa'ua, na fanaa Joseph fei hudi ununa. ");
INSERT INTO wuv_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Si'ei Joseph na pono'aa hepalo hawa linen, na fa'upuaa fei hudi unu, guasumia a'a fei linen ma augia laloo hepalo huapu, ei waduaa ro'odu a'a ei na'a. Ma na piguaa hepalo mugoo poaa fei wawadu'ii fei huapu. ");
INSERT INTO wuv_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Mary Magdalene ma Mary mei inaa Joses, laguna fanunu'u'umaa fawelei rona fahainopia. ");
INSERT INTO wuv_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","I pedu fei Sabbath, Mary Magdalene, Mary mei inaa James mawe Salome, rona pono'aa ei pao dufa ba ro'aa hapigaa fei unuu Jesus. ");
INSERT INTO wuv_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Pa'aa mafufuo a'a fei rawarawa arewaa fei hefapagipagia, nene ua fei anaa halo, ro'ei talai'ama'anaa fei huapu ");
INSERT INTO wuv_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","ma rona fi'i'igai, “Hini i piguaa fei mugoo a'a fei wawadu'ii fei huapu?” ");
INSERT INTO wuv_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Ma'uaa ro'aa aralao, rona fanunupa'aa fei baua mugoo na pigudii. ");
INSERT INTO wuv_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Ro'ei wadu'ailao a'a fei huapu, rona fanunupa'aa hemea baubara, susuna po'ia, na guta i pepei ma'au ma rona ma'au. ");
INSERT INTO wuv_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Ina ware, “Apuna ma'au. Hamo'ei lalabaginaa Jesus mei Nazareth, mei na fatawa. Ina asi'adii! Hia lomi yeni. Ma'a, fawelei ro'aa fudigia yei. ");
INSERT INTO wuv_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Ma'uaa aunu ma warefanaa ena otalai nenerana mawe Peter ba ina aunudiginaa Galilee i ma'aa hamu'odu. Yena hamo'aa fanunupa'ia, ana ale'ei idii wareia Jesus a'a hamu'odu.” ");
INSERT INTO wuv_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Ei pifine, rona ma'aufunurere ma poni'asi'aa a'a fei huapu. Lomi rona wareaa hepalo manumanu a'a hemea, uaa ronamina ma'au. ");
INSERT INTO wuv_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Jesus, i asi'aa foi a'a fei rawarawa arewaa fei hefapagipagia nado'o fa'arewa a'a Mary Magdalene, mei hia na fawala'anaa olorompalo pigea a'ana. ");
INSERT INTO wuv_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Ina aunu ma warefanaa ei rona oa a'a Jesus fama'a, ei roi faloloa'i ma ai'ai. ");
INSERT INTO wuv_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Ro'aa guainia ba Jesus na mama'adii ma Mary na fanunupa'ia, lomi ronapo'o nara ba fa'ua. ");
INSERT INTO wuv_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Hinene, na u'ugaidiai fei maumau Jesus, ei i fa'arewa a'a helagui ro'ou, ei lagu'ei tatalai yei sugatata'aia. ");
INSERT INTO wuv_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Laguna hadiwe'ai ma warefanaa ro'odu; ma'uaa ana lomi ronapo'o nara ba fa'ua. ");
INSERT INTO wuv_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Hinene, ei roi hanana, Jesus na fa'arewa a'a ei hefua ma hemea ma na hota'aa ro'odu, uaa lomi na we'i naranaraa ro'odu ma na waiwai tabaa ro'odu ma lomi ronapo'o nara ba fa'ua ei wareaa ei rona fanunuia nenee fei asi'anana. ");
INSERT INTO wuv_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Na ware a'a ro'odu, “Hamonei aununaa a'a minaa ena gufuu feni ano ma wareaa fei rawani'a warea a'a minaa ena rama'a. ");
INSERT INTO wuv_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Hini na we'i naranarana ma i pudugufai, iwe tela; ma'uaa hini lomi na we'i naranarana, iwe to lagina. ");
INSERT INTO wuv_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Ma a'a ena rona narafawe'i wagii fei harau, i bigipa'i eni hilala eni: ro'awe fawala'anaa ena pigea, wareaa manufau wareagufu, ");
INSERT INTO wuv_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","panarofaa ei wa'a hafelo ma ena rona hunumaa ei numa, ei na pa'i siafa wagina, lomi i fagianapa'aa ro'odu; ro'aa augaa panii ro'ou pafoo ei funua ma farawaninaa ro'ou.” ");
INSERT INTO wuv_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","I warewaredii a'a ro'odu mei Fasu Jesus, mei Haidaa na duginaa hia pafea ma fagutania pepei ma'auna. ");
INSERT INTO wuv_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Ei otalai nenerana, rona aunu ma wareaa fei rawani'a warea a'a minaa ei gufu tadiwe'aia. Ma mei Fasu na bigifipui a'a ro'odu ma fa'arewaiaa ei wareana wagii ei hilala. ");
INSERT INTO wuv_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Watauda, rona u'ulafuinaa tamanu ei bigi'a na oadii a'a o'ou ");
INSERT INTO wuv_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","ana ale'ei ro fifaninamai a'a o'odu ei rawarawa fanunuana, ei ro'ou nafii fei warea. ");
INSERT INTO wuv_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Ma yau ana hemea. Uaa, una labaginaa minaa ei manumanu fama'a nopa'amii wagieni ma una nara ba unei ne'ifarawaninaa hepalo u'uga, hepalo na arewa ma ponifarawani a'amu mena rawani'a Theophilus ");
INSERT INTO wuv_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","ba onei aida ba naminapa'aa fa'ua tamanu rona feroinio. ");
INSERT INTO wuv_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","I a'a fei au Herod, mei haparaa Judea, na pa'i hemea bauaniaa humuu mei Haidaa, harana, Zechariah, hemea maroaa Abijah. Ma harona, Elizabeth, ana hia hemea upuu Aaron. ");
INSERT INTO wuv_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Minaa lagua, laguna rawani i pudaa mei Haidaa. Ma lomi hepalo tataa lagua a'a minaa ei warea laloo fei law mei Fasu. ");
INSERT INTO wuv_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Ma'uaa lomi laguna pa'i na'uu lagua, uaa Elizabeth, hia pa'abeu ma laguna sisigidiginaa raudei. ");
INSERT INTO wuv_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Hefarani, i pa'aa fei au Zechariah ma ei maroana ba ro'aa bigi ale'ei mei bauaniaa humuu mei Haidaa i inamoana, ");
INSERT INTO wuv_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","hia na unia fei uni'unii fifigaia ba nei wadu'ainaa fei humuu mei Haidaa ma fagu'aa fei dufaa hagu ale'ei maumau ei bauaniaa humuu mei Haidaa. ");
INSERT INTO wuv_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","I nopa'amii fei au fagu'aa fei dufaa hagu, rona figupui ano ei losuia ma lafulafu. ");
INSERT INTO wuv_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Ma hemea alo'aloo mei Fasu na ufalarai pepei ma'au fei tawaa dufaa hagu ma fa'arewa a'ana. ");
INSERT INTO wuv_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","I fanunupa'ia Zechariah, na ba'arofo ma namina ma'aufafelo. ");
INSERT INTO wuv_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Ma'uaa na ware a'ana mei alo'alo, “Apuna ma'au, Zechariah. Fei i'igiamu, ina guaidigia. Mei haromu Elizabeth i waninifani na'umu, baduu wawane ma onei roroinia John. ");
INSERT INTO wuv_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Owe ni'eni'e a'ana ma i fa'unuwenuweo ma watauda, rowe ni'eni'e a'a fei waniniana, ");
INSERT INTO wuv_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","uaa iwe oa ale'ei hemea bauanai rama'a i pudaa mei Fasu. Inei'awe hunu wine o hefi'a numa na waragu ba i fapoapoainia ma fei Spiriti Apuna iwemina didifaa laloo iana a'a fei waniniana ma nolao. ");
INSERT INTO wuv_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Iwe fahadiwe'idinamii watauda Israel a'a mei Fasu, mei Haidaniaa ro'odu. ");
INSERT INTO wuv_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Ma iwe aununaa ma'aa mei Fasu fininaa fei spiriti ma fei faufau Elijah ba i fahadiwe'inaa naranaraa ei ama a'a ei na'uu ro'ou ma ei barafea a'a fei apa'aa ei wanewanea rama'a—ba i ra'a'augaa ei rama'a ba ronei oma'aa mei Fasu.” ");
INSERT INTO wuv_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Zechariah na i'iginaa mei alo'alo, “Batanai a apa'ia ba fa'ua fei? Yau hemea bau ma mei harou na sisigidiginaa raudei.” ");
INSERT INTO wuv_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Na ware mei alo'alo, “Yau Gabriel. Una'aida u inamoaa mei Haidaa ma na aloamiau ba nei warefanio fei rawani'a warea. ");
INSERT INTO wuv_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Ma'aia! Eni owe famadumu ma lomi owe warewarepa'i hawina na nomai fei arewaa fei manumanu fei, uaa lomi ona nara ba fa'ua ei wareau ba i we fa'uai a'a fei pa'aa auna.” ");
INSERT INTO wuv_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Ma fei au fei, ei rama'a roi oma'aa Zechariah ma naranara ba tani imina madii laloo fei humuu mei Haidaa. ");
INSERT INTO wuv_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","I asi'amai, lomi na warepa'i a'a ro'odu. Ronawe apa'ia ba na tonaa hefaa fanunua laloo fei humuu mei Haidaa, uaa ina biginaa panina a'a ro'odu, ma'uaa lomi na wareware. ");
INSERT INTO wuv_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","I pedulao fei au bigi'ana na hadiwe'inaa humuna. ");
INSERT INTO wuv_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Nenee fei, mei harona Elizabeth na wareu ma laloo haipani puda na guta ua humuna. ");
INSERT INTO wuv_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Ina ware, “Mei Fasu na bigi'aa feni a'au. A'a eni arewaa eni, ina farawaninau ma fapedugaa fei mamafau i pudaa rama'a.” ");
INSERT INTO wuv_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","A'a fei fa'oloroaa pudaa Elizabeth, mei Haidaa na aloaa mei alo'alo Gabriel dinaa Nazareth laloo fei baua gufu Galilee. ");
INSERT INTO wuv_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Na dinaa a'a hemea nanao a'u'uana, hemea ba i lalainaa hemea wawane, harana Joseph, hemea upuu David. Mei pifine mei, harana Mary. ");
INSERT INTO wuv_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Mei alo'alo na dinaa a'ana ma na ware, “Hagu'u, yoi mena o tonaa fei baua rawani'ana. Mei Fasu na oa i a'amu.” ");
INSERT INTO wuv_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Mary namina naranara watauda a'a ei wareana ma nara ba warea batanai fei. ");
INSERT INTO wuv_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Ma'uaa mei alo'alo na warenaa a'ana, “Apuna ma'au, Mary, mei Haidaa na farawaninio. ");
INSERT INTO wuv_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Guainau! Owe pa'i iamu ma o wanininaa hemea baduu wawane ma onei roroinia Jesus. ");
INSERT INTO wuv_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Hia bauana ma hepalo harana Na'uu mei Pafeai. Mei Fasu, mei hia Haidaa, i fania fei haparaiaa mei upuna, David. ");
INSERT INTO wuv_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Ma hia, i haparainaa fei maroaa Jacob ranimai. Lomi i pedutoo fei haparaiana.” ");
INSERT INTO wuv_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Mary na i'iginaa mei alo'alo, “Ma i batanai fei, te, lomi una hainofipui a'a hemea wawane?” ");
INSERT INTO wuv_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Na ware mei alo'alo, “Fei Spiriti Apuna i nomai a'amu ma fei faufau mei Pafeai i hawainio. Si'ei, mei na apunai, mei ba i waninimai, hepalo harana, Na'uu mei Haidaa. ");
INSERT INTO wuv_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Elizabeth, mei tafimu, fa'ua ba hia hopi ma'uaa, ana na pa'i iana. Mei rona ware ba pa'abeu, fa'oloroaa pudana eni. ");
INSERT INTO wuv_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Uaa lomi hepalo manumanu na waiwai a'a mei Haidaa.” ");
INSERT INTO wuv_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Mary na ware, “Yau nafii mei Fasu. Fena wareamu na rawani ua a'au.” Ma mei alo'alo nawe di'ininia. ");
INSERT INTO wuv_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","A'a fei au fei, Mary na aunubatafanaa a'a hepalo gufu papaa ei maugeni yei Judea. ");
INSERT INTO wuv_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Ma na wadu'ainaa fei humuu Zechariah ma famafufuoinaa Elizabeth. ");
INSERT INTO wuv_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","I guainaa fei wareaa Mary, Elizabeth, mei baduu laloo iana na tawei ma fei Spiriti Apuna namina didifaa Elizabeth. ");
INSERT INTO wuv_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Ma Elizabeth na warefabauana a'ana, “I tapuu ei pifine, fei hawegia na oa i a'amu ma ana na pa'i hawegiana mena baduu ona waninia!” ");
INSERT INTO wuv_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Ma'uaa tamanu fei rawani'au ba na nomai a'au, mei inaa mei Fasuu? ");
INSERT INTO wuv_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Ana ei a guainaa fei laomu, meni baduu laloo iau na tatawei fininaa ni'eni'ea. ");
INSERT INTO wuv_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Ona pa'i hawegiamu, uaa ona nara ba ipa'aa nomai fei na wareia mei Fasu i a'amu. ");
INSERT INTO wuv_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Ma na ware Mary: “Unamina uduginaa mei Fasu laloo fei naranarau ");
INSERT INTO wuv_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","ma fei spiritiu namina ni'eni'e a'a mei Haidaa, mei na fatela'anau, ");
INSERT INTO wuv_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","uaa ina narapa'au, ma yau hemea nafi ua. E'eni ma nolao, minaa ei ro'aa fafoforaimai, rowe ware ba na pa'i hawegiau, ");
INSERT INTO wuv_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","uaa mei Faufaua na bigi'aa hefi'a baua manumanu a'au— fei harana na apunai. ");
INSERT INTO wuv_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Fei faloloa'iana na pasinaa pafoo ei rona ma'auia, a'a ei rama'aa mina ma ei ro'aa fafoforaimai. ");
INSERT INTO wuv_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Ina bigi'aa hefi'a baua manumanu a'a fei panina; ina faba'autorainaa ei na mamagugu laloo naranaraa ro'ou. ");
INSERT INTO wuv_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Ina hafududumaa ei hapara a'a ei gutanaa ro'ou ma poronaa pafea ei rona fafafaunaa pu. ");
INSERT INTO wuv_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Ina faguaa ei rona bao a'a ei rawani'a du'ua, ma'uaa ei rona pa'i watauda mugoo po'i na alofatatalainaa ro'ou, pani ua. ");
INSERT INTO wuv_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Ina hadumaa mei nafina Israel, ma lomi na madi'inia ba i faloloa'inaa ");
INSERT INTO wuv_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Abraham ma ei upuna ranimai ranimai, ana ale'ei i ware a'a ei amaa o'odu.” ");
INSERT INTO wuv_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Mary, i gutafipuidii a'a Elizabeth ale'ei oduai puda, nawe hadiwe'ainaa gufuna. ");
INSERT INTO wuv_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","I nodigimai fei au Elizabeth ba i wanini, na wanininaa hemei na'una, baduu wawane. ");
INSERT INTO wuv_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Ei gufuna ma ei maroana, rona guainia ba mei Fasu namina faloloa'inia ma rona ni'eni'efipui a'ana. ");
INSERT INTO wuv_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","A'a fei fafainaroaa aweraa rona nomai ba ro'aa moro'aa hudii wawanei mei baduu ma roroinia udiaa mei amana Zechariah, ");
INSERT INTO wuv_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","ma'uaa mei inana na ware, “Lomi! Harana John.” ");
INSERT INTO wuv_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Rona warenaa a'ana, “Lomi hemea maroamu na pa'i fena hara fena.” ");
INSERT INTO wuv_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Ma ronawe pi'inaa panii ro'ou a'a mei amana ba ro'aa apa'ima'aia ba i roroinaa hini mei baduu. ");
INSERT INTO wuv_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Ina uninaa panina ba ronei tomai nene'i ma na famaduofoinaa minaa ei rama'a, uaa na ne'i ba, “Harana, John.” ");
INSERT INTO wuv_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Ana ei ua fei poana na hawai, fei rawerawena na tatawei, na warewarediai ma uduginaa mei Haidaa. ");
INSERT INTO wuv_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Ei gufuna ma minaa ro'ou, ronamina ma'au ma minaa ei rama'a fawelei papaa ei maugeni Judea, ronamina fiwarewareinaa minaa ei manumanu ei. ");
INSERT INTO wuv_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Minaa ei rona guainia, rona naranara ma fi'i'igai, “I gipenaa hini meni baduu meni?” Uaa fei panii mei Fasu na oa a'ana. ");
INSERT INTO wuv_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Mei amana Zechariah namina didifia fei Spiriti Apuna ma nadii ware'augia: ");
INSERT INTO wuv_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Uduginaa mei Fasu, mei Haidaniaa Israel, uaa na nomai ma ponohadiwe'inaa ei gufuna. ");
INSERT INTO wuv_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Ina fa'asi'anaa hemea faufau fatela'anaa o'ou wagii fei gufuu mei nafina David ");
INSERT INTO wuv_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","(ale'ei i wareia a'a ei apunai mamama'a mina mina), ");
INSERT INTO wuv_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","i fatelaiaa o'odu a'a ei ba ro'aa fo'afama'eaa o'ou ma a'a ei na bidibidi unuu ro'odu a'a o'ou— ");
INSERT INTO wuv_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","ba i fama'aiaa ei amaa o'ou fei faloloa'iana ma ba i nonominaa fei fi'ugaiana, fei na apunai, ");
INSERT INTO wuv_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","fei warefa'uaiana a'a mei amaa o'ou Abraham: ");
INSERT INTO wuv_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","ba i fa'asi'anaa o'ou panii e'ei ba ro'aa fo'afama'eaa o'ou ba i hadumaa o'ou ba o bigi'aa fei bigi'ana ma onei'awe ma'au, ");
INSERT INTO wuv_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","ma onei fafa'arai ma wanewane i pudana wagii minaa ei arewaa gutanaa o'ou. ");
INSERT INTO wuv_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Ma yoi, mena na'uu, ro'aa ware ba yoi hemea mamama'aa mei Pafeai; uaa owe aununaa ma'aa mei Fasu ba o'aa ra'afanaa fei talana ");
INSERT INTO wuv_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","ba i fanaa ei gufuna fei apa'a ba ro'aa tela wagii fei futoaa ei hafelo'aa ro'ou, ");
INSERT INTO wuv_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","hamatee fei faloloa'iaa mei Haidaniaa o'ou. Ma iwe aloamii hemei i nogio pafea ba i we'ainaa o'ou ana ale'ei fei anaa halo, ");
INSERT INTO wuv_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","ma ba i we'ainaa ei rona oa a'a fei roromaa, ma haroo fei hanunuu fei ma'ea, ba i taunoduginaa o'ou wagii fei talaa gutafarawania.” ");
INSERT INTO wuv_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Ma nawe gipelao mei baduu ma na nofaufaulao fei spiritina ma na guta yei fawelei lomi haihai o guana nopa'aloo fei ba na talaifalelefo a'a ei Israel. ");
INSERT INTO wuv_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","I a'a ei arewaa ei, Caesar Augustus na fatalainaa fei wareana ba ronei wareinaa puduu ei rama'aa minaa ei gufu i Rome. ");
INSERT INTO wuv_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","(Fei, fei rawarawa wawarei rama'a rona utonia a'a fei au Quirinius mei gavanaa yei Syria.) ");
INSERT INTO wuv_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Ma hememea na hadiwe'idinaa gufuna ba i augaa fei harana. ");
INSERT INTO wuv_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Ma Joseph na di'ininaa Nazareth i Galilee ma dinaa Bethlehem, fei gufuu David i Judea, uaa hia noranamai a'a fei gufuu David ma hia hemea upuna. ");
INSERT INTO wuv_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Ina dinaa yei ba i au haraa lagua Mary, mei na ugainia ba i lalainia ma na pa'i iana. ");
INSERT INTO wuv_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Ei lagua yei, na fi'i uguna ");
INSERT INTO wuv_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","ma na wanininaa mei uma'ua na'una, baduu wawane. Na fahawainia a'a ei lawalawa ma fudugia laloo hepalo ude'udee hanaa ei manulelele uaa fei humuu ma'igua na pepesu. ");
INSERT INTO wuv_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Ma na pa'i hefi'a oma'ama'aa sipsipi i podu bamai, roi oma'ama'aa ei hapee ro'ou poi. ");
INSERT INTO wuv_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Hemea alo'aloo mei Fasu na fa'arewa a'a ro'ou ma fei haweraa mei Fasu namina we'ainaa ro'ou ma ronamina ma'aufafelo. ");
INSERT INTO wuv_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Ma'uaa na ware mei alo'alo, “Apuna ma'au. Guainau! Yau na notonamii fei rawani'a warea, fei i fani baua ni'eni'ea a'a minaa ei rama'a. ");
INSERT INTO wuv_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Wagieni i a'a fei gufuu David, hemei Fatela'ana na wanini a'a hamu'odu; hia Christ, mei Fasu. ");
INSERT INTO wuv_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Sifei, fei lalana a'a hamu'ou: hamowe bapa'aa hemea baduu na hawai a'a hefi'a lawalawa ma na haino a'a fei ude'udee hanaa ei manulelele.” ");
INSERT INTO wuv_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Ana ei ua fei baua gupuu alo'alo pafea, rona fa'arewafipuimai a'a mei alo'alo ma rona uduginaa mei Haidaa. Rona ware, ");
INSERT INTO wuv_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“Uduginaa mei Haidaa, mei na pafeai, ma yeni malagufu i fani gutafarawania a'a ei rama'a, ei ina ni'eni'e a'a ro'ou.” ");
INSERT INTO wuv_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Ro'aa di'ininaa ro'ou ei alo'alo ma dinaa pafea, ei oma'ama'aa, rona fiwarewarei, “O dii. O dinaa Bethlehem ma re ma'a fei manumanu fei, fei na warefanaa o'ou mei Fasu.” ");
INSERT INTO wuv_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Si'ei rona aunubatafalao ma ma'apa'aa Mary, Joseph ma mei baduu, mei i haino a'a fei ude'udee hanaa manulelele. ");
INSERT INTO wuv_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Ro'aa ma'adigia, rona fatalainaa fei u'ugaa mei baduu, fei rona guainia a'a ei alo'alo. ");
INSERT INTO wuv_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Ma minaa ei rona guainia, namina nanawala pudaa ro'ou a'a ei u'ugaa ei oma'ama'aa ei sipsipi. ");
INSERT INTO wuv_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Ma'uaa Mary na aunaa naranarana ei manumanu ei ma gutafiloginia iana. ");
INSERT INTO wuv_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Ei oma'ama'aa, rona hadiwe'ai ma laugi'uduginaa mei Haidaa uaa minaa ei manumanu rona guainia ma fanunuia, ana ale'ei ro'aa warefanaa ro'ou. ");
INSERT INTO wuv_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","A'a fei fafainaroaa arewaa, a'a fei au ba ro'aa moro'aa fei hudii wawaneina, rona roroinia Jesus, fei hara mei alo'alo na fania ei atawe toro. ");
INSERT INTO wuv_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","I pedu fei nunufa'araiaa ro'ou ale'ei fei wareaa fei Law Moses, Joseph ma Mary, laguna noduginaa hia Jerusalem ba lagu'aa fania panii mei Fasu ");
INSERT INTO wuv_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","(ale'ei fei ne'iaa fei Law mei Fasu, “Minaa ei uma'ua wawane hamonei apunainaa ro'ou a'a mei Fasu”), ");
INSERT INTO wuv_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","ma ana laguna dii ba lagu'aa fani fanaa lagua ba i neneraa fei Law mei Fasu ba lagunei fani: “guapalo pune, o guapalo na'uu padu.” ");
INSERT INTO wuv_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Ma na pa'i hemea yei Jerusalem, harana Simeon. Na wanewane fei maumauna ma na ma'auaa mei Haidaa. Ifi guta'oma'aa fei au ba i pedu fei faloloa'iaa Israel. Ma fei Spiriti Apuna na oa i pafona. ");
INSERT INTO wuv_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Hefei Spiriti Apuna nadii fa'arewaia a'ana ba lo'e i ma'e hawina na fanunuaa mei Christ, mei apunaiaa mei Fasu. ");
INSERT INTO wuv_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Na fani naranarana fei Spiriti ma ina dinaa malalaa fei humuu mei Haidaa. Amana ma inana, lagu'aa poro'amii mei baduu Jesus ba lagu'aa bigi'aa tamanu na wareia fei Law, ");
INSERT INTO wuv_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Simeon na poro'ia ma uduginaa mei Haidaa ma ware: ");
INSERT INTO wuv_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“Mena Bauana, mena Fasu, ana ale'ei onadii fa'unainia, oneipowe alofatatalainaa mei nafimu uaa nawe rawani fei naranarau. ");
INSERT INTO wuv_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Uaa gueini pudau na fanunudigaa fei talaa tela'ana, ");
INSERT INTO wuv_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","fei ona ra'a'augia i pudaa minaa ei rama'a, ");
INSERT INTO wuv_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","hepalo we'ai ba i fa'arewainaa fei naranaraa ei Gentile ma i fani hawera a'a ei gufumu Israel.” ");
INSERT INTO wuv_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Laguei amana ma inana, laguna maduofo a'a ei warewareana hia. ");
INSERT INTO wuv_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Ma Simeon na haweginaa ro'ou ma warenaa a'a Mary, mei inana, “Meni baduu meni, ipowe fapasiaa watauda ma fa'asi'anaa watauda yeni Israel ma iwe ale'ei hepalo lala a'a ro'ou ma rowe warefafeloia ");
INSERT INTO wuv_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","ba ei naranaraa watauda ipowe arewa. Ma hepalo wadu iwe paugaa fei naranaramu anaa.” ");
INSERT INTO wuv_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Ana na pa'i hemea pifine mamama'a, harana Anna, mei na'uu Phanuel a'a fei maroaa Asher. Hia pa'aa hopi; fama'a na gutafipui a'a mei harona oloromeai igisimasi nenee fei lalaiana ");
INSERT INTO wuv_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","ma na guta unaia nopa'aloo fei ba na pa'i fainaroa pa'ania ma obao igisimasina. Lomi ba ina u di'ininaa fei humuu mei Haidaa, ma'uaa na'aida lolosui arewaa ma poi, na'o fabao ma lafulafu. ");
INSERT INTO wuv_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Ma i no'ulao a'a ro'ou, na ware ‘ta’ a'a mei Haidaa ma u'ugaa mei baduu a'a minaa ei roi guta'oma'oma'aiaa fei ponohadiwe'aiaa Jerusalem. ");
INSERT INTO wuv_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Joseph ma Mary, lagu'aa bigidigaa minaa ei wareaa fei Law mei Fasu, laguna hadiwe'inaa Galilee, dinaa gufuu lagua Nazareth. ");
INSERT INTO wuv_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Ma mei baduu fi gipelao, na noma'ualao raraa ununa. Namina bauana apa'ana ma fei rawani'aa mei Haidaa na oa i a'ana. ");
INSERT INTO wuv_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Minaa ei igisimasi laguei amana ma inana, laguna'aida dinaa Jerusalem a'a fei Hananaa fei Talai Falogia. ");
INSERT INTO wuv_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","I nopa'aloo hefua ma guai igisimasina, rona tafanelao a'a fei Hananaa, ale'ei fei maumau ro'ou. ");
INSERT INTO wuv_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","I pedu fei hananaa, lagu'ei hadiwe'inaa gufu amana ma inana, mei baubara Jesus na guta ua yei Jerusalem, ma'uaa lo'e laguna aida. ");
INSERT INTO wuv_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Laguna nara ba hia a'a lagua ma laguna talailao ale'ei heai arewaa. Ma lagunawe labaginia dupuaa ei maroa ma tafii lagua. ");
INSERT INTO wuv_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Lo'e laguna labagipa'ia, laguna hadiwe'inaa Jerusalem ba lagu'aa labaginia. ");
INSERT INTO wuv_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Nenee odu'ai arewaa laguna pa'ia malalaa fei humuu mei Haidaa. Ina guta dupuaa ei feroia. Ina guguainaa ro'ou ma i'iginaa ei i'igiana. ");
INSERT INTO wuv_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Ma minaa ei rona guainia, namina nanawala pudaa ro'odu a'a fei apa'ana ma ei wareana. ");
INSERT INTO wuv_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Amana ma inana, lagu'aa ma'apa'ia, laguna ba'arofo. Mei inana na warenaa a'ana, “Ona'uu, tani o bigi'ia ale'ei a'a haigua? Haigua mei amamu, haiguna narafatemu ei haigua labaginio.” ");
INSERT INTO wuv_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Ina i'igai, “Tani hamugua lalabaginau? Lomi hamuna aida ba yau nei guta i humuu mei Amau?” ");
INSERT INTO wuv_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Ma'uaa lomi laguna apa'ia tamanu fi wareia a'a lagua. ");
INSERT INTO wuv_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Ma nawe upunogiaa lagua dinaa Nazareth ma na'aida guainaa wareaa lagua. Ma'uaa mei inana na aunaa naranarana minaa ei manumanu ei. ");
INSERT INTO wuv_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Ma Jesus na gipe fininaa apa'ana ma nawe a'u ma rona fafanunufarawani a'ana mei Haidaa mawe ei rama'a. ");
INSERT INTO wuv_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","I laloo fei hefua ma fahaipaniaa igisimasi haparaiaa Tiberius Caesar—a'a fei au Pontius Pilate mei gavanaa Judea, Herod, hia haparaa obao gufu yei Galilee ma mei lofuna Philip, hia haparaa obao gufu fawelei Iturea ma Traconitis. Ma Lysanias, hia haparaa obao gufu yei Abilene. ");
INSERT INTO wuv_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","A'a fei au laguei pa'aa bauaniaa humuu mei Haidaa, Annas ma Caiaphas, fei wareaa mei Haidaa na nomai a'a John mei na'uu Zechariah, yei fawelei lomi haihai o guana. ");
INSERT INTO wuv_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Ina aunupedunaa a'a minaa ei gufu yei Jordan ma u'u ba ronei filoginaa naranaraa ro'ou ma pudugufai ba i futo ei hafelo'aa ro'ou. ");
INSERT INTO wuv_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Ana ale'ei fei ne'iaa mei mamama'a Isaiah laloo fei bu'u: “Fei lao hemea na haroharo yei fawelei lo'e haihai o guana, ‘Ra'afanaa fei talaa mei Fasu, fawanewaneaa ei talana. ");
INSERT INTO wuv_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Minaa ei walefoa hamonei raupaduia, minaa ei maugeni hamonei agifamatalaia. Ei tala na wawadi hamonei fawanewaneia, ei tala na era'eraa, hamonei famare'aia. ");
INSERT INTO wuv_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Ma minaa ei rama'aa ano rowe fanunuaa fei talaa tela'anaa mei Haidaa.’” ");
INSERT INTO wuv_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","John na warenaa a'a fei gupuu rama'a rona nomai a'ana ba ro'aa pudugufai, “Hamu'ou ena na'uu wa'a hafelo! Hini na fa'aiaa hamu'ou ba hamonei ponipa'ai a'a fei sibana, fei fi nomai? ");
INSERT INTO wuv_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Ei maumau hamu'ou nei fama'aia ba na filogidii ei naranaraa hamu'ou. Hamonei'awe nara ba, ‘Hamatee hai'ouna pa'aa Abraham, amaa hai'ou. Uaa a warefanaa hamu'odu ba nabaa i nunumiai mei Haidaa, i fa'asi'anaa eni mugoo ba na'uu Abraham. ");
INSERT INTO wuv_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Fei poa na udedii a'a ei waraa ei haihai ma hepapalo haihai lomi na pa'i rawani'a fuana, i rereia ma siminaa hafi.” ");
INSERT INTO wuv_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Fei gupuu rama'a, rona i'igai, “Nabaa ale'ei, hai'ou bigi'aa tamanu?” ");
INSERT INTO wuv_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","John na ware, “Mei na pa'i guapalo susuna nei alaginia a'a mei lomi na pa'i ma mei na pa'i du'ua ana nei bigi'ia ale'ei.” ");
INSERT INTO wuv_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Ei otonaa mugoo po'ii gavaman, ana rona nomai ba ro'aa pudugufai. Rona i'igai, “Feroia, hai'odu batanai?” ");
INSERT INTO wuv_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","“Hamonei'awe to hefi'adiai mugoo po'i na muainaa puduu fei ba hamo'aa tonia.” ");
INSERT INTO wuv_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Ma hefi'a fo'aa, rona i'iginia, “Ma hai'odu batanai?” “Apuna fo'aa rama'a ba hamo'aa tonaa mugoo po'ii ro'ou ma apuna warefasifi ba mei na tata ma hamonei wawanene ua a'a ei pono'aa hamu'ou.” ");
INSERT INTO wuv_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Ei rama'a, rona u oma'a ua ma naranara laloo iaa ro'ou ba woro John mei Christ. ");
INSERT INTO wuv_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","John na warefanaa ro'odu, “Yau na pudugufainaa hamu'ou ranu. Ma'uaa hemea na faufaudiai a'au iwe nomai, hemea yau lomi na rawani ba a fabalou'alaraa wao hafena pinena. Iwe pudugufainaa hamu'ou wagii fei Spiriti Apuna ma fei hafi. ");
INSERT INTO wuv_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Ina pa'i waduu panina ba i nueitonaa ei rawani'a wheat a'a ei meme. Iwe augaa ei wheat laloo palena, ma'uaa ei meme, i siminaa fei hafi lomi i peretoo.” ");
INSERT INTO wuv_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","A'a wataudadiai warea, John na warefawe'i a'a ei rama'a ma u'ugaa fei rawani'a warea a'a ro'odu. ");
INSERT INTO wuv_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Ma'uaa, John na hota'aa Herod mei haparaa obao gufu, uaa na tafitafiaa Herodias, mei haroo lofuna ma na pa'idiai watauda hafelo'a bigi'ana. ");
INSERT INTO wuv_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Si'ei, Herod na fahonodiai hepalo hafelo'ana: Ina fawi'aa John humuu bobo'aia. ");
INSERT INTO wuv_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Ei roi pudugufai minaa ei rama'a, Jesus ana na pudugufai. Ma ei fi lafulafu, na gigi fei gufu pafea ");
INSERT INTO wuv_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","ma fei Spiriti Apuna, maumauna ale'ei pune, na pasigio pafona. Ma hepalo lao na warerai gufu pafea: “Yoi mena Na'uu, mena una haguio; Unamina ni'eni'e a'amu.” ");
INSERT INTO wuv_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Ma Jesus na pa'i ale'ei odufua pa'ania igisimasina ei i fa'asi'anaa fei bigi'ana. Ei rama'a na nara ba hia mei na'uu Joseph, mei na'uu Heli, ");
INSERT INTO wuv_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","mei na'uu Matthat, mei na'uu Levi, mei na'uu Melki, mei na'uu Jannai, mei na'uu Joseph, ");
INSERT INTO wuv_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","mei na'uu Mattathias, mei na'uu Amos, mei na'uu Nahum, mei na'uu Esli, mei na'uu Naggai, ");
INSERT INTO wuv_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","mei na'uu Maath, mei na'uu Mattathias, mei na'uu Semein, mei na'uu Josech, mei na'uu Joda, ");
INSERT INTO wuv_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","mei na'uu Joanan, mei na'uu Rhesa, mei na'uu Zerubbabel, mei na'uu Shealtiel, mei na'uu Neri, ");
INSERT INTO wuv_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","mei na'uu Melki, mei na'uu Addi, mei na'uu Cosam, mei na'uu Elmadam, mei na'uu Er, ");
INSERT INTO wuv_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","mei na'uu Joshua, mei na'uu Eliezer, mei na'uu Jorim, mei na'uu Matthat, mei na'uu Levi, ");
INSERT INTO wuv_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","mei na'uu Simeon, mei na'uu Judah, mei na'uu Joseph, mei na'uu Jonam, mei na'uu Eliakim, ");
INSERT INTO wuv_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","mei na'uu Melea, mei na'uu Menna, mei na'uu Mattatha, mei na'uu Nathan, mei na'uu David, ");
INSERT INTO wuv_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","mei na'uu Jesse, mei na'uu Obed, mei na'uu Boaz, mei na'uu Salmon, mei na'uu Nahshon, ");
INSERT INTO wuv_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","mei na'uu Amminadab, mei na'uu Ram, mei na'uu Hezron, mei na'uu Perez, mei na'uu Judah, ");
INSERT INTO wuv_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","mei na'uu Jacob, mei na'uu Isaac, mei na'uu Abraham, mei na'uu Terah, mei na'uu Nahor, ");
INSERT INTO wuv_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","mei na'uu Serug, mei na'uu Reu, mei na'uu Peleg, mei na'uu Eber, mei na'uu Shelah, ");
INSERT INTO wuv_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","mei na'uu Cainan, mei na'uu Arphaxad, mei na'uu Shem, mei na'uu Noah, mei na'uu Lamech, ");
INSERT INTO wuv_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","mei na'uu Methuselah, mei na'uu Enoch, mei na'uu Jared, mei na'uu Mahalalel, mei na'uu Kenan, ");
INSERT INTO wuv_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","mei na'uu Enosh, mei na'uu Seth, mei na'uu Adam, mei na'uu mei Haidaa. ");
INSERT INTO wuv_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Fei Spiriti Apuna na didifaa Jesus ma ina hadiwe'imai yei Jordan. Ma fei Spiriti na noduginaa hia fawelei lomi haihai o guana ");
INSERT INTO wuv_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","ma laloo gunaroa pa'ania arewaa mei hani'u na manimania. A'a ei arewaa ei, lomi na hanana ma i nopa'aloo a'apoo ei, ina bao. ");
INSERT INTO wuv_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Mei hani'u na warenaa a'ana, “Nabaa yoi Na'uu mei Haidaa, warenaa a'a feni mugoo feni ba nei filoginaa faraa pidaua.” ");
INSERT INTO wuv_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Jesus na ware, “Na udedii fei ne'ia ba: ‘Ei rama'a lomi ba ro'aa gutalao a'a fei faraa pidaua ua.’” ");
INSERT INTO wuv_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Mei hani'u na noduginaa hia fawelei na tare ma ana ei ua, na fama'aia minaa ei gufuu ei haparaa feni ano. ");
INSERT INTO wuv_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Ma ina warenaa a'ana, “A fanio minaa ei forafora ma ei hawera wagina, uaa una tonia ba manumanuu ma a fanaa hini a nunuminia. ");
INSERT INTO wuv_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Si'ei, nabaa o losuinau, a fanio ba manumanumu.” ");
INSERT INTO wuv_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Jesus na ware, “Na udedii fei ne'ia ba: ‘Losuinaa mei Fasu, mei Haidaniaa hamu'ou ma hia ua hamonei nenegia.’” ");
INSERT INTO wuv_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Mei hani'u na noduginaa hia Jerusalem ma fa'ufalarainia pafoo fei sidesidee fei humuu mei Haidaa. Ma na ware, “Nabaa yoi Na'uu mei Haidaa, fapasilao yeni, ");
INSERT INTO wuv_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","uaa na udedii fei ne'ia: “‘Iwe warenaa a'a ei alo'alona ba yoi, roneimina oma'afarawaninio; ");
INSERT INTO wuv_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","ma rowe usumaio, ba lomi o'aa bi'a'ainaa pinemu a'a ei mugoo.’” ");
INSERT INTO wuv_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Jesus na ware, “Na ne'idii: ‘Apuna maniaa mei Fasu, mei Haidaniaa hamu'odu.’” ");
INSERT INTO wuv_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Mei hani'u, i pedudigaa ei maniana, na di'ininia ba i opanidinaa nefarani. ");
INSERT INTO wuv_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Jesus na hadiwe'inaa Galilee a'a fei faufau fei Spiriti ma fei u'ugana namina talaipedunaa minaa fei gufu. ");
INSERT INTO wuv_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Ina feferoi i laloo ei synagogue ro'ou ma minaa ro'ou, rona uduginia. ");
INSERT INTO wuv_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Ina dinaa Nazareth, fawelei i giperai wagina ma laloo fei Sabbath na wadu'ainaa fei synagogue, ale'ei maumauna ma na ufalarai ba i igo'igo. ");
INSERT INTO wuv_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Hemea na fania fei ne'iaa mei mamama'a Isaiah ale'ei maumau fei holobenaa ma na fama'alaia ma labagipa'aa feni ne'ia feni: ");
INSERT INTO wuv_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“Fei Spiritii mei Fasu na oa pafou, uaa ina ipia i pafoo tabau ba unei u'ugaa fei rawani'a warea a'a ei lomi rona pa'i. Ina aloamiau ba nei wareia ba ei bobo'aia, ronei ala, ei pudawerai, ronei fanunupa'i, ei rona gutafafelo, ronei asi'aa ");
INSERT INTO wuv_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","ma unei wareia ba fei au ba mei Fasu i farawaninaa ei rama'a.” ");
INSERT INTO wuv_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","I weloidinaa fei ale'ei holobenaa, na fanihadiwe'inia a'a mei bigibigi'a ma guta. Minaa ei rama'a laloo fei synagogue, rona fanunufa'u'uia ");
INSERT INTO wuv_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","ma ina'aa warenaa a'a ro'odu, “Wagieni fei ne'ia na pa'aa nomai eni hamo'ei guainau fi igoia.” ");
INSERT INTO wuv_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Minaa ro'ou, rona u'ufarawaninia ma hawainaa poaa ro'ou a'a ei rawani'a wareana. Rona i'igai, “Anaa simeni, meni na'uu Joseph?” ");
INSERT INTO wuv_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Jesus na warefanaa ro'ou, “Una aidadii ba hamowe wareaa feni proverb a'au: ‘Mena lo'otaa, farawaninaa ana yoi! Bigi'ia yeni gufumu ei guaiaa hai'ou ba ona bigi'ia yei Capernaum.’” ");
INSERT INTO wuv_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Ina warelao, “A warefa'uai a'a hamu'ou ba lomi ro'aa taufa'ugaa hemea mamama'a ana a'a fei gufuna. ");
INSERT INTO wuv_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Apa'aa warefanaa hamu'ou ba na pa'i watauda pifine ma'esuabea yeni Israel a'a fei au Elijah, fei lomi na pa'i maunu laloo oduai ma hesuwi igisimasi ma namina moubiabia laloo minaa ei gufu. ");
INSERT INTO wuv_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Ma lomi na alonaa Elijah a'a ro'ou, ma'uaa hemea pifine ma'esuabea yei Zarephath fawelei Sidon. ");
INSERT INTO wuv_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Ma na pa'i watauda na watawatai unuu ro'odu yei Israel a'a fei au Elisha mei mamama'a, ma'uaa lomi hemea ro'ou na fafa'arai ununa—unaiaa Naaman mei Syria.” ");
INSERT INTO wuv_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Minaa ei rama'a laloo fei synagogue, ronamina siba ei ro'aa guainaa fei. ");
INSERT INTO wuv_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Rona asi'aa ma tetefa'asi'ania a'a fei gufu fei ba ro'aa siminia pu, rona nodugia dinaa pafoo fei maugeni, fei na pa'idii humu pafona. ");
INSERT INTO wuv_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Ma'uaa ina talai'ualao tapuu ro'ou ma aunu. ");
INSERT INTO wuv_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Ina upu'aunulao yei Capernaum, hepalo gufu yei Galilee ma laloo fei Sabbath fipowe feroinaa ei rama'a. ");
INSERT INTO wuv_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Ma rona hawainaa poaa ro'ou a'a fei feferoiana, uaa fei u'ugana na pa'i faufauna. ");
INSERT INTO wuv_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Laloo fei synagogue na pa'i hemea na wadu'ia pigea, hepalo spiriti hafelo. Namina aimemewai, ");
INSERT INTO wuv_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“Haa! Tamanu nunumiamu a'a hai'ou, Jesus, mena Nazareth? Eni o nomai ba o fo'afama'eaa hai'odu? Una aida ba yoi mei Apunaiaa mei Haidaa!” ");
INSERT INTO wuv_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Jesus na warefawe'i, “Babanini! Wala'amai a'ana!” Ma fei pigea na hubifapasia i ma'aa minaa ro'ou ma wala'amai a'ana ma lomi na fafeloaa ununa. ");
INSERT INTO wuv_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Minaa ei rama'a, ronamina hawainaa poaa ro'ou ma fiwarewarei, “Tamanu eni feferoi eni? Fininaa forafora ma faufau ina warenaa a'a ei spiriti hafelo ma rona wala'amai!” ");
INSERT INTO wuv_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Ma fei u'ugana namina talaipedunaa ei gufu yei. ");
INSERT INTO wuv_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Jesus na di'ininaa fei synagogue ma dinaa humuu Simon. Ma mei inaa haroo Simon namina babaifafelo ununa ma rona i'iginaa Jesus ba nei hadumia. ");
INSERT INTO wuv_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Si'ei, ina fabalonaa a'ana ma warefawe'i a'a fei funua ma na pedu funuana. Ina asi'aa ma hasufani hanaa ro'ou. ");
INSERT INTO wuv_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Fi lolo fei halo, minaa ei na pa'i watauda mau funua, hefi'a rona dugamiaa ro'ou a'a Jesus ma ina augaa panina pafoo hememea ro'ou ma fapedugaa funuaa ro'odu. ");
INSERT INTO wuv_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Ma ei pigea, rona wala'aa a'a watauda ma memewai ba, “Yoi, Na'uu mei Haidaa!” Ma'uaa ina hota'aa ro'ou ma apunainaa ro'ou ba ronei'aa wareware, uaa rona aida ba hia, mei Christ. ");
INSERT INTO wuv_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","I ba'a fei panii fei arewaa Jesus na dinaa fawelei abaa wawawau rama'a. Ei rama'a roimina lalabaginia ma ro'aa bapa'ia, rona ware ba inei'aa di'ininaa ro'ou. ");
INSERT INTO wuv_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Ma'uaa ina ware, “A'a hefi'adiai gufu unei u'ugaa fei rawani'a wareaa fei haparaiaa mei Haidaa, uaa sifeni feni pa'afina i aloagiau.” ");
INSERT INTO wuv_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Ma ina u'u'u laloo ei synagogue Judea. ");
INSERT INTO wuv_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Heai arewaa, na u adii fei ranuu Gennesaret ma ronamina hoaninia ei rama'a ba ro'aa guainaa ei wareaa mei Haidaa. ");
INSERT INTO wuv_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Ina fanunupa'aa guapaloei wa didipisii dii augaa ei dia'agi, ei roi fesuaa ei lepoo ro'ou. ");
INSERT INTO wuv_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Ina hugi a'a hepalo wa, fei waa Simon ma i'iginia ba nei faraualao ma'ida a'a fei didipisii. Ma na gutaferoimai pafoo wa a'a ei rama'a. ");
INSERT INTO wuv_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","I pedudii wareana, na warenaa a'a Simon, “Suanaa fawelei na walalo ma siminaa ei lepoo hamu'ou ba o'aa udii nia.” ");
INSERT INTO wuv_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Simon na ware, “Mena Fasu, hai'ounamina bigifawe'i fei poi ma lomi hepalo, ma'uaa, hamatee ona ware ale'ei, nadii, a siminaa ei lepo.” ");
INSERT INTO wuv_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Ro'aa bigi'ia ale'ei, rona udiaa watauda nia ma na'aa i wara'a ei lepoo ro'ou. ");
INSERT INTO wuv_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Ma rona alofamai ei tafii ro'ou a'a hepalodiai wa ba ronei nomai mi hadumaa ro'odu ma rona nomai ma guapaloei wa namina pepesufafelo, anaa ro'aa lolo. ");
INSERT INTO wuv_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","I fanunuaa fei, Simon Peter na fapasi i ma'aa Jesus. Ma na ware, “Aunufaraua a'au mena Fasu; yau pa'aa hafelo'a rama'a!” ");
INSERT INTO wuv_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Uaa hia mawe ei maroana na nanawala pudaa ro'ou a'a ei udiaa ro'ou nia. ");
INSERT INTO wuv_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Ma ana na nanawala pudaa James ma John, laguei na'uu Zebedee, laguei rarafii Simon. Ma Jesus na warenaa a'a Simon, “Apuna ma'au. E'eni opowe udilao rama'a.” ");
INSERT INTO wuv_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Si'ei, rona rapi'aunaa piye ei waa ro'ou, di'ininaa minaa ei manumanuu ro'ou ma nenegia. ");
INSERT INTO wuv_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","I guta a'a hepalo gufu Jesus, hemea watawatai na nomai. I fanunupa'aa Jesus, na fapasi'o'o'uinaa pu ma ware, “Mena Fasu nabaa o nunuminia, fafafa'arainau.” ");
INSERT INTO wuv_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Jesus na roainaa panina ma idoia. Ina ware, “Una nunuminia. Fafa'arai!” Ana ei, na mafo ei watawatana. ");
INSERT INTO wuv_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Ma Jesus na warefawe'i a'ana, “Onei'aa warefanaa nemea, ma'uaa wi famaua a'a mei bauaniaa humuu mei Haidaa ma fanaa tamanu Moses na ware ba onei fani nabaa na mafo unumu, ale'ei fama'ama'amu a'a ro'ou ba ona rawani.” ");
INSERT INTO wuv_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Ma'uaa fei u'ugana namina talaidiai. Si'ei, ei gupuu rama'a, rona nomai ba ro'aa guainia ma ba nei fapedugaa funuaa ro'ou. ");
INSERT INTO wuv_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Ma'uaa ina'o aununaa yei fawelei lomi rama'a ba i lafulafu. ");
INSERT INTO wuv_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Heai arewaa ei fi feferoi, rona gutaguainia ei Pharisee ma ei feroiaa law, ei noramiaa ro'ou a'a minaa ei gufu i Galilee ma hefi'a noramiaa ro'ou, Judea ma Jerusalem. Ma fei faufau mei Fasu na ude i a'ana ba i fapedugaa ei funua. ");
INSERT INTO wuv_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Na pa'i hemea na ma'e ununa. Hefi'a wawane, rona notabeiamai pafoo fei hafenaa ununa ba ro'aa wadu'ainaa fei humu ma fahainopia i ma'aa Jesus. ");
INSERT INTO wuv_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Si'ei ba namina watauda ei rama'a, lomi rona labagipa'i talaa ro'ou. Rona tafane'uanaa pupuaa fei humu ma fa'asisiarai pu pafoo fei hafena ununa i dupuaa ei rama'a, i ma'aa Jesus. ");
INSERT INTO wuv_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Jesus, i fanunupa'ia ba rona narafawe'i, na ware ba, “Otafi, ena hafelo'amu na futo.” ");
INSERT INTO wuv_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Ei Pharisee ma ei feroiaa law, rona naranara ale'ei ba, “Hia hini ba i warefafeloaa mei Haidaa? Hinidiai ba i futoaa ei hafelo'a? Mei Haidaa ua.” ");
INSERT INTO wuv_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Jesus na apa'idigaa ei naranaraa ro'ou ma na i'igai, “Tani hamu'ou nara ale'ei laloo iaa hamu'odu? ");
INSERT INTO wuv_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Tamanu na maduta—fei wareau ba: ‘Ena hafelo'amu na futo,’ o ‘Asi'aa ma talai’? ");
INSERT INTO wuv_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Ma'uaa ba hamonei aida ba mei Na'uu Rama'a na pa'i forafora yeni malagufu ba i futoaa ei hafelo'a. . .” Ina ware a'a mei na ma'e ununa, “A warenawii a'amu, asi'aa, tonaa fei hafena unumu ma dinaa gufumu.” ");
INSERT INTO wuv_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Ana ei ua, ina ufalarai i ma'aa ro'ou, tonaa fei hafena ununa, fei na hainona ma dinaa gufuna ma uduginaa mei Haidaa. ");
INSERT INTO wuv_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Namina nanawala pudaa minaa ei rama'a ma rona uduginaa mei Haidaa. Minaa ro'ou na ma'aiaa fei ma fiwarewarei, “O'ouna fanunuaa hefi'a manumanu na fananawalaiaa pudaa o'ou wagieni.” ");
INSERT INTO wuv_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Nenee fei, Jesus na asi'anaa ano ma fanunupa'aa hemea otonaa mugoo po'ii gavaman, harana Levi, na guta a'a fei palena toto mugoo po'i. Jesus na warenaa a'ana, “Nenerau.” ");
INSERT INTO wuv_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Levi na asi'adi'ininaa minaa ei manumanu ma nenegia. ");
INSERT INTO wuv_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","I a'a fei humuna, Levi na bigi'aa hepalo baua hananaa a'a Jesus ma hepalo baua gupuu otonaa mugoo po'ii gavaman ma hefi'adiai, rona hananafipui a'a lagua. ");
INSERT INTO wuv_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Ma'uaa ei Pharisee mawe ei feroiaa law, ei ana maroaa ei Pharisee, rona ware watauda a'a ei otalai nenerana, “Tani hamu'ou hanana ma hunufipui a'a ei otonaa mugoo po'ii gavaman ma ei hafelo'a rama'a?” ");
INSERT INTO wuv_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Jesus na warefanaa ro'ou, “Abaa ei rona rawani ba ronei pa'i hemea lo'otaa, ma'uaa ei rona funu. ");
INSERT INTO wuv_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Pa'afii fei noramiau, abaa a lala'aa ei rona wanewane, ma'uaa ei hafelo'a ba ronei filoginaa naranaraa ro'ou.” ");
INSERT INTO wuv_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Rona warenaa a'ana, “Ei otalai neneraa John, rona'aida fabao ma lafulafu ma ei otalai neneraa ei Pharisee anaa, ma'uaa ei maroamu rona hanana ma hunu ua. ");
INSERT INTO wuv_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Jesus na ware, “Hamona nunuminia ba ei tafii mei wawane lalaia, ronei fabao ei roi gutafipui a'ana? ");
INSERT INTO wuv_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Ma'uaa iwe nomai fei au ba mei wawane lalaia, rowe rapunodugia a'a ro'ou ma laloo ei arewaa ei, rowe fabao.” ");
INSERT INTO wuv_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Ina u'ufanaa ro'odu feni warea hanunu: “Lomi nemea ba i tonaa fei maninii manufau lawalawa ma tawi'ia a'a fei watanai lawalawa. Nabaa i bigi'ia ale'ei, i fawara'a'apoinaa fei manufau lawalawa ma fei manufau maninii lawalawa lomi i fipupuduinaa fei watanai. ");
INSERT INTO wuv_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Ma lomi nemea i ipiaa fei manufau wine laloo fei watanai pe'ii wine, fei bigi'aa ro'ou hudii manulelele. Nabaa i bigi'ia ale'ei, fei manufau wine, i fawara'aiaa fei pe'i ma fei wine i wigii ma fei watanai pe'ii wine i hafelo. ");
INSERT INTO wuv_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Agia, ei manufau wine, ronei ipinaa fei manufau pe'i. ");
INSERT INTO wuv_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Ma lomi hemea na hunudigaa fei watanai wine i nunuminaa fei manufau wine, uaa na ware ale'ei, ‘Fei watanai na muainaa fei manufau.’” ");
INSERT INTO wuv_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Heai Sabbath Jesus fi talailao pe'ii ei lau guana ma ei otalai nenerana, rona hufu'aa hefi'a holoo guana ma fudosinia panii ro'ou ma hanaiaa ei lau. ");
INSERT INTO wuv_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Hefi'a Pharisee, rona i'igai, “Tani hamu'ou bigi'aa fei na barafeaa fei law laloo fei Sabbath?” ");
INSERT INTO wuv_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Jesus na warenaa a'a ro'ou, “Ana hamona'u igoia tamanu na bigi'ia David ma ei tafina, ei ro'aa bao? ");
INSERT INTO wuv_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Ina wadu'ainaa fei humuu mei Haidaa, tonaa fei faraa pidaua na apunai ma hanaia. Ma'uaa fei law na ware ba unaiaa mei bauaniaa humuu mei Haidaa, i hanaia. Ma ana na fanaa hefi'a a'a ei tafina.” ");
INSERT INTO wuv_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Ma Jesus na warenaa a'a ro'ou, “Mei Na'uu Rama'a, hia Fasuu fei Sabbath.” ");
INSERT INTO wuv_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Ma a'a hepalodiai Sabbath, ina wadu'ainaa fei synagogue ma fi feroi ma hemea yei, fei panina ma'au na ma'e. ");
INSERT INTO wuv_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Ei Pharisee mawe ei feroiaa law, ro'ei labarai tala ba ro ware ba Jesus na bigifatata. Si'ei, rona pupudainia ba i farawaninia laloo fei Sabbath. ");
INSERT INTO wuv_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Ma'uaa Jesus na apa'idigaa ei naranaraa ro'ou ma na warenaa a'a mei na ma'e panina, “Asi'aa ma mi ufalarai i ma'aa ro'odu.” Si'ei, ina asi'aa ma na ufalarai yei. ");
INSERT INTO wuv_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Ma Jesus na warenaa a'a ro'ou, “A i'iginaa hamu'ou, afaia na neneraa fei law laloo fei Sabbath: fei ba onei bigifarawani, o ba onei bigifafelo, fei ba onei fani harenua, o ba onei fo'afama'e?” ");
INSERT INTO wuv_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Ina fanununaa a'a minaa ro'odu ma warenaa a'a mei rama'a mei, “Roainalao fei panimu.” Ina bigi'ia ma fei panina namina rawani. ");
INSERT INTO wuv_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Ma'uaa ronamina sibafafelo ma fiwarewarei ba ro'aa bigi'aa tamanu a'a Jesus. ");
INSERT INTO wuv_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Wagii ei arewaa ei, Jesus na aununaa papaa hepalo maugeni ba i lafulafu ma na guta yei fei poi fi lafulafunaa a'a mei Haidaa. ");
INSERT INTO wuv_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","I ba'amai fei arewaa, na harofamii ei otalai nenerana ma rafeinaa hefua ma helagui ba apostle: ");
INSERT INTO wuv_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Simon (mei ina roronia ba Peter), mei lofuna Andrew, James, John, Philip, Bartholomew, ");
INSERT INTO wuv_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Matthew, Thomas, James mei na'uu Alphaeus, Simon mei rona roroinia ba mei Zealot (mei na haguaa gufuna), ");
INSERT INTO wuv_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Judas mei na'uu James mawe Judas Iscariot—mei na aloia. ");
INSERT INTO wuv_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Ina upunogiaa ro'ou ma ufalarai pafoo fei mare'aa malagufu. Hepalo baua gupuu otalai nenerana, ro'ou yei mawe watauda pa'aniaa rama'a, noramiaa ro'ou, Judea, Jerusalem ma ei gufu piye na rafi'inaa Tyre ma Sidon. ");
INSERT INTO wuv_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Rona nomai ba ro'aa guainia ma ba inei fapedugaa funuaa ro'ou. Ma ina fawanewaneaa ei na wadu'aa ro'ou ei spiriti hafelo ");
INSERT INTO wuv_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","ma minaa ei rama'a ba ro'aa idoia, uaa na pa'i faufau i a'ana. Ma ina fapedugaa funuaa minaa ro'ou. ");
INSERT INTO wuv_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","I fanununaa a'a ei otalai nenerana, na ware: “I pa'i hawegiaa hamu'ou ena lomi mugoo po'i, uaa hamowe oa wagii fei haparaiaa mei Haidaa. ");
INSERT INTO wuv_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","I pa'i hawegiaa hamu'ou ena hamona bao e'eni, uaa hamowe magu. I pa'i hawegiaa hamu'ou ena hamona ai'ai e'eni, uaa hamowe fafadi. ");
INSERT INTO wuv_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","I pa'i hawegiaa hamu'ou ena rona bidi unuu ro'ou a'a hamu'ou, ofadugaa hamu'ou, warefafeloaa hamu'ou ma fafeloaa haraa hamu'ou ba hamona hafelo uaa mei Na'uu Rama'a. ");
INSERT INTO wuv_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","“A'a fei arewaa fei, hamoneimina ni'eni'e ma palapala uaa na bauana fei pono'aa hamu'ou yei gufu pafea. Hamatee ana ale'ei bigi'aa ei amaa ro'ou a'a ei mamama'a. ");
INSERT INTO wuv_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","“Ma'uaa hamo'aa pa'aa fagiana hamu'ou ena na pa'i mugoo po'i, uaa hamona todigaa fei rawani'a gutanaa hamu'odu. ");
INSERT INTO wuv_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Hamo'aa pa'aa fagiana hamu'ou ena na magu e'eni, uaa hamowe bao. Hamo'aa pa'aa fagiana hamu'ou ena na fafadi e'eni, uaa hamowe gutafaloloa'i ma ai'ai. ");
INSERT INTO wuv_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Hamo'aa pa'aa fagiana hamu'ou ena na warefarawaninaa hamu'ou minaa ei rama'a, uaa ana ale'ei bigi'aa ei amaa ro'ou a'a ei mamama'a sifisifi. ");
INSERT INTO wuv_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","“Ma'uaa a warefanaa hamu'ou ena hamofi guainau: Haguaa ena na bidibidi unuu ro'ou a'a hamu'ou, farawani a'a ena rona siba a'a hamu'ou, ");
INSERT INTO wuv_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","haweginaa ena rona umuaa hamu'ou ma lafulafunaa ena rona fafeloaa hamu'ou. ");
INSERT INTO wuv_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Nabaa nemea na laparaa afuu hamu'ou, fania pepei anaa. Nabaa nemea na topa'ainaa hawaa uguu hamu'ou, fania fei susu anaa. ");
INSERT INTO wuv_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Fani a'a minaa ei rona i'iginaa hamu'ou ma hini i tonaa manumanuu hamu'ou, apuna i'igihadiwe'inia. ");
INSERT INTO wuv_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Tamanu nunumiaa hamu'ou ba ronei bigi'ia a'a hamu'ou, bigi'ia ana ale'ei a'a ro'ou. ");
INSERT INTO wuv_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","“Nabaa hamo'aa haguaa ei rona haguaa hamu'ou, tamanu rawani'ana fei a'a hamu'ou? Ena hafelo'a ana rona haguaa ei rona haguaa ro'ou. ");
INSERT INTO wuv_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Ma nabaa hamo'aa farawani a'a ei rona farawani a'a hamu'ou, tamanu rawani'ana fei a'a hamu'ou? Ei hafelo'a ana rona bigi'ia ale'ei. ");
INSERT INTO wuv_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Ma nabaa hamo'aa fani a'a hefi'a, ei hamona nara ba ronei hodi'ia, tamanu rawani'ana fei a'a hamu'ou? Ei hafelo'a ana rona fani a'a hefi'adiai hafelo'a ma rona nara ba hefi'adiai, ronei hodipedugia. ");
INSERT INTO wuv_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Ma'uaa hamonei haguaa ena na bidibidi unuu ro'ou a'a hamu'ou, hamonei farawani ma fani a'a ro'ou ma ronei'aa hodi'ia. Ma nabaa ale'ei, fei pono'aa hamu'ou imina bauanai ma hamowe oanaa na'uu mei Pafeai, uaa ina farawani a'a ei rona hafelo mawe ei lomi na ware ‘ta’ wagii fei rawani'ana. ");
INSERT INTO wuv_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Hamonei faloloa'inaa ro'ou, ana ale'ei na faloloa'inaa hamu'ou mei Amaa hamu'ou. ");
INSERT INTO wuv_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","“Apuna nara ba na tata nemea. Ma nabaa hamona nara ale'ei, ro'aa nara ba hamona tata. Apuna ware ba nemeadiai na tata ma nei to fagianaa. Ma nabaa ale'ei, ana hamo'aa to fagianaa wagii ei tataa hamu'ou. Futoaa ei tataa nemeadiai; nabaa ale'ei, ana i futoaa ei tataa hamu'ou mei Haidaa. ");
INSERT INTO wuv_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Fani ma hamowe pa'idiai. Hamo'aa todiai manumanu i pafoinaa fei fanaa hamu'ou. Hamowe to ana ale'ei puduu fanaa hamu'ou.” ");
INSERT INTO wuv_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Ma ana ina u'ufanaa ro'ou feni warea hanunu: “Hemei pudawerai, ana i taupa'aa hemeadiai pudawerai? Naraa hamu'ou ba lomi lagu'aa pasinaa laloo huapu? ");
INSERT INTO wuv_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Mei i to feferoiana, lomi i muainaa mei feroiana, ma'uaa, nabaa i fapedugaa fei feferoiana, hia ale'ei mei feroiana. ");
INSERT INTO wuv_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","“Tani omina labaginaa memee pudaa mei lofumu ma lomi ona apa'ia ba na pa'i hewagu haihai pudamu? ");
INSERT INTO wuv_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Tani o ware a'a mei lofumu ba, ‘Olofu, ya a do'o siminaa fei memee pudamu,’ ma lomi ona fanunupa'aa fei hewagu haihai pudamu? Yoi pa'aa ware'oni. Oneido'o siminaa fei hewagu haihai pudamu. Ma opowe fanunufarawani ba o'aa siminaa fei memee pudaa mei lofumu. ");
INSERT INTO wuv_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","“Lomi hepalo rawani'a haihai ba i hafelo fuana ma ana lomi hepalo hafelo'a haihai ba i rawani fuana. ");
INSERT INTO wuv_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Hepapalo haihai, o'ou apa'ia a'a ei fuana. Ei rama'a, lomi ro'aa hufu'aa ei fuaa ha'oloo a'a fei haihai na hogia, o ei fuaa nasi a'a fei haihai na hogia. ");
INSERT INTO wuv_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Mei rawani'a i falele'anamii ei rawani'a bigi'ana a'a fei rawani'a naranarana. Ma mei hafelo'a i falele'anamii ei hafelo'a bigi'ana a'a fei hafelo'a naranarana. Uaa tamanu noranamai laloo iana, i lele'aa umuna. ");
INSERT INTO wuv_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","“Tani o harofau ba ‘Mena Fasu, mena Fasu,’ ma lomi ona bigi'aa ei wareau? ");
INSERT INTO wuv_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","A ware fama'aio batanai maumau mei na nomai a'au ma guainaa wareau ma bigi'ia. ");
INSERT INTO wuv_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Hia ale'ei hemea fadufaduaa humu, hemea na agifawalalonaa pu ei u pafoo na'a. Ma nawe nomai fei baua mamaua ma hapunai'onaa fei humuna, ma'uaa lomi na nueipa'ia, uaa na fadufawe'ia. ");
INSERT INTO wuv_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Ma'uaa mei na guainaa wareau ma lomi na bigi'ia, hia ale'ei mei na fa'ugaa ei u humuna pafoo piye, lomi na'a harona. I nomai fei baua mamaua, na nueinaa fei humuna ma na pasi wata'o'o.” ");
INSERT INTO wuv_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","I pedu minaa ei u'ugaa Jesus a'a ei rama'a, na wadu'ainaa Capernaum. ");
INSERT INTO wuv_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Na pa'i hemea na funu ma anaa i ma'e. Hia nafii mei centurion, hemea na ha'einia mei pidauana. ");
INSERT INTO wuv_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Mei centurion na guainaa fei u'ugaa Jesus ma na aloaa hefi'a bauaniaa ei Jew a'ana ba ronei i'iginia ba nei nomai ma fapedugaa funuaa mei nafina. ");
INSERT INTO wuv_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Ro'aa dinaa a'a Jesus, rona warefa'ai'ai a'ana. “Na rawani ba o bigi'ia a'a meni rama'a meni, ");
INSERT INTO wuv_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","uaa ina haguaa gufuu o'odu ma fa'ufalarainaa fei synagogue o'ou.” ");
INSERT INTO wuv_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Si'ei, Jesus na aunuhugiaa ro'ou. I rafi'idiginaa fei humu, mei centurion na aloaa hefi'a tafina a'ana ma rona wareaa ei wareana ba: “Mena Fasu, apuna naranara watauda ba o wadu'ainaa humuu, uaa yau hafelo'a rama'a. ");
INSERT INTO wuv_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Sifei, fei pa'afina ba lomi na nunumai ba a nomai a'amu. Ma'uaa ware ua ma i pedu funuaa mei nafiu. ");
INSERT INTO wuv_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Uaa yau hemea na bigi haroo hemea na bauanadiai ma ana na pa'i hefi'a fo'aa rona bigi harou. A warenaa a'a mei, ‘Aunu,’ ma i aunu ma hemeadiai ba, ‘Nomai,’ ma i nomai. A warenaa a'a hemea nafiu, ‘Bigi'aa feni,’ ma i bigi'ia.” ");
INSERT INTO wuv_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","I guainaa fei Jesus, na ba'arofo a'ana ma momo'inaa a'a ei rona nenegia ma ware, “Apa'aa warefanaa hamu'ou ba lomi na fanunupa'aa hemea na pa'i narafawe'iana ale'ei ma ana lomi na fanunupa'ia ale'ei a'a ei Israel.” ");
INSERT INTO wuv_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Ma ei talaitonaa warea, ronawe hadiwe'idinaa fei humu ma fanunupa'ia ba na pedu funuaa mei nafi. ");
INSERT INTO wuv_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Nenee ei ma ataa madii, Jesus fipui a'a ei otalai nenerana ma fei baua gupuu rama'a, rona dinaa hepalo gufu, harana Nain. ");
INSERT INTO wuv_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Anaa i rafi'inaa fei poaa fanefanee fei gufu, hefi'a rona tabenaa ano hemea baduu wawane ma'ea, na'uu hemea pifine ma'esuabea. Ma fei baua gupuu rama'aa fei gufu, ana ro'ou i a'a mei pifine. ");
INSERT INTO wuv_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","I fanunupa'ia mei Fasu, na faloloa'inia ma warenaa a'ana, “Apuna ai'ai.” ");
INSERT INTO wuv_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Ina aunulao ma idoaa fei bao ma'ea. Ma ei ro'aa poro'ia, rona ufamadumu. Ina ware, “Mena baubara, a warenaa a'amu, asi'aa!” ");
INSERT INTO wuv_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Mei ma'ea na asi'aguta ma wareware. Ma Jesus na duginaa hia a'a inana. ");
INSERT INTO wuv_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Minaa ro'ou, ronamina ma'au ma uduginaa mei Haidaa ma ware, “Hemea baua mamama'a na fa'arewa a'a o'odu. Mei Haidaa na nomai ba i hadumaa ei gufuna.” ");
INSERT INTO wuv_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Fei u'ugaa Jesus fei, namina talaipedunaa ei gufu i Judea mawe minaa ei gufu i sugatata'aia. ");
INSERT INTO wuv_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Ei otalai neneraa John, rona u'ufania eni manumanu eni. Ina harofamiaa helagui ");
INSERT INTO wuv_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","ma alonaa lagua a'a mei Fasu ba lagunei i'iginia ale'ei, “Yoi hemei ba i nomai, o hai'ounei do'o oma'aa nemeadiai?” ");
INSERT INTO wuv_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Lagu'aa dinaloo a'a Jesus, laguna ware, “John, mei pudugufaia na aloamiaa haigua ba haigunei i'iginio, ‘Yoi hemei ba i nomai, o hai'ounei do'o oma'aa nemeadiai?’” ");
INSERT INTO wuv_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","A'a fei au fei, Jesus na farawaninaa watauda na mala'u'u unuu ro'ou, ei funuaa, ei na wadu'aa ro'ou spiriti hafelo ma ei pudawerai. ");
INSERT INTO wuv_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Si'ei, ina warenaa a'a laguei talaitonaa warea, “Hadiwe'ai ma u'ufanaa John ei fanunuguaiaa hamugua: ba ei pudawerai nawe fafanunu, ei afetoo nawe talai, ei watawatai nawe mafo, ei lotoo adia nawe guaipa'i, ei ma'ea na asi'aa ma ei lo'e mugoo po'i, rona guainaa fei rawani'a warea. ");
INSERT INTO wuv_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Baua ni'eni'ea a'a mei lomi na pasipa'ai uaa yau.” ");
INSERT INTO wuv_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Lagu'aa didii laguei talaitonaa wareaa John, Jesus nawe u'ugaa John a'a fei gupuu rama'a: “Ei hamona dinaa fawelei lomi haihai o guana, ba hamoree ma'a fei guana, fei na gugufainia fei lalarena? ");
INSERT INTO wuv_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Nabaa abaa sifei, pa'aa tamanu fei hamo'aree ma'aia—hemea na maurawani hawerana? Lomi. Ena rama'a na maurawani haweraa ro'ou, ei na pa'ipedu manumanu, rona guta laloo ei baua humuu hapara. ");
INSERT INTO wuv_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Ma'uaa hamona aunu ba hamo'aa ma'a tamanu? Hemea mamama'a? Hi'i, ma'uaa a warefanaa hamu'ou ba hia, abaa mamama'a ua. ");
INSERT INTO wuv_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Simei, mei rona u'ugia laloo ei ne'ia: “‘Guainau! A we aloamai mei talaitonaa wareau ma'amu, mei i ra'afanaa fei talamu.’ ");
INSERT INTO wuv_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","A warefanaa hamu'odu ba lomi hemea dupuaa ei waniniaa ei pifine i muainaa John; ma'uaa mei pa'aa lomi harana haroo fei haparaiaa mei Haidaa i muainia.” ");
INSERT INTO wuv_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","(Minaa ei rama'a ma ei otonaa mugoo po'ii gavaman anaa, ro'aa guainaa ei wareaa Jesus, ronawe ware ba fei talaa mei Haidaa na wanewane, uaa rona pudugufai a'a John. ");
INSERT INTO wuv_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Ma'uaa ei Pharisee ma ei rona pa'i apa'aa ro'ou a'a fei law, rona ofadugaa fei bigi'a, fei na fanaa ro'odu mei Haidaa, uaa lomi rona pudugufai a'a John.) ");
INSERT INTO wuv_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","“Yau, a hawawaginaa eni rama'aa feni au feni a'a tamanu? Batanai maumau ro'ou? ");
INSERT INTO wuv_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Ro'ou ale'ei ei baduu na guta yei humuu alo'alo ma fiharoharofii: “‘Hai'ouna hafugaa fei ha'ifa ma lomi hamona palapala; hai'ouna laugaa hepalo laugaa ma'ea, ma'uaa lomi hamona ai'ai.’ ");
INSERT INTO wuv_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Uaa, John, mei pudugufaia lomi na nohanamai faraa pidaua ma hunu wine ma hamona ware, ‘Na wadu'ia pigea.’ ");
INSERT INTO wuv_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Ma Mei Na'uu Rama'a na nohanamai ma hunu ma hamona ware, ‘Hia pugua ma na hunu poapoai; hia tafii ei otonaa mugoo po'ii gavaman mawe “ei hafelo'a”.’ ");
INSERT INTO wuv_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Ma'uaa ei rona biginaa fei apa'aa mei Haidaa, rona fa'arewaia ba na wanewane.” ");
INSERT INTO wuv_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Ma hemea Pharisee na i'iginaa Jesus ba nei hananafipui a'ana. Si'ei, na dinaa humuu mei Pharisee ma gutafapalagi ditataa fei tawa. ");
INSERT INTO wuv_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Na pa'i hemea pifine na hafelo bigi'ana a'a fei gufu fei. Ma i guainia ba Jesus i hanana humuu mei Pharisee, ina tonamai hepalo pusu'oro pe'i dufaa pao ");
INSERT INTO wuv_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","ma ei fi uwawasusu mugina na farorofanaa pinena fei ranuu pudana. Ma nawe huguaa pinena a'a fei loaa tabana. Na hatofaa pinena ma ipiaa fei dufaa pao pafoo pinena. ");
INSERT INTO wuv_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","I fanunuia mei Pharisee, mei na fagutanaa Jesus, na bababau'u naranarana, “Nabaa meni rama'a meni, hia mamama'a, i apa'idigia hini i idoia ma hia pifine bata—ba hafelo'a pifine.” ");
INSERT INTO wuv_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Jesus na warenaa a'ana, “Simon, na pa'i wareau a'amu.” Ma na ware, “Nadii, warefanau, mena feroia.” ");
INSERT INTO wuv_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","“Helagui rama'a, laguna to mugoo po'i a'a hemea na'o fani mugoo po'i. Hemea lagua na tonaa haipani pu'u denarius a'ana ma hemea lagua na tonaa haipani pa'ania. ");
INSERT INTO wuv_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Minaa lagua, lomi na hodipa'ia, si'ei na fama'e'uaiaa ei tonaa lagua. Amaia lagua na bauana haguana a'a mei i fani mugoo po'i?” ");
INSERT INTO wuv_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Simon na ware, “Narau ba mei i to watauda mugoo po'i ma na fama'e'uaiaa ei tonana mei na fani.” Jesus na ware, “Ona narapa'ia.” ");
INSERT INTO wuv_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Si'ei, na momo'inaa a'a mei pifine ma warenaa a'a Simon, “Ona ma'aia meni pifine meni? Una wadu'aimai humumu ma lomi ona gufifani fesufesuu pineu, ma'uaa ina fesunaa pineu ranuu pudana ma hugunaa loaa tabana. ");
INSERT INTO wuv_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Lomi ona hatofaa pudau, ma'uaa, meni pifine meni, ana fi wadu'ai'uamai lomi na fafaa hatofaa pineu. ");
INSERT INTO wuv_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Lomi ona ipi pao tabau, ma'uaa, hia na ipinaa tabau fei dufaa pao. ");
INSERT INTO wuv_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Si'ei a warefanio, ena watauda hafelo'ana na futo, uaa na bauana fei haguana. Ma'uaa hini na futo ma'ida ua hafelo'ana, ana ma'ida ua haguana.” ");
INSERT INTO wuv_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Si'ei, Jesus na warenaa a'ana, “Ei hafelo'amu, na futo.” ");
INSERT INTO wuv_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Hefi'adiai rona guta yei, rona fiwarewarei, “Hia hini ba i futoaa ei hafelo'aa ei rama'a?” ");
INSERT INTO wuv_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Jesus na warenaa a'a mei pifine, “Fei narafawe'iamu na fatelaio; aunufa'a'a ua.” ");
INSERT INTO wuv_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Nenee fei, Jesus na tatalai a'a hepapalo gufu ma u'ugaa fei rawani'a wareaa fei haparaiaa mei Haidaa. Ei hefua ma helagui, ro'ou a'ana ");
INSERT INTO wuv_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","ma hefi'a pifine anaa, ei ina fawala'anaa ei spiriti hafelo a'a ro'ou ma fapedugaa funuaa ro'ou: Mary (hepalo harana Magdalene), mei na wala'aa oloromeai pigea a'ana; ");
INSERT INTO wuv_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Joanna mei haroo Cuza mei oma'ama'aa humuu Herod; Susanna; ma wataudadiai. Eni pifine eni, rona hadumaa ro'ou ana a'a ei pa'aa manumanuu ro'ou. ");
INSERT INTO wuv_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Ro'aa figupuimai a'a Jesus ei rama'a noramiaa ro'ou a'a hepapalo gufu, ina u'ufanaa ro'ou feni warea hanunu: ");
INSERT INTO wuv_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“Hemea diapodu na aunu ba i faroaa ei lau. I larosiminaa ei lau, hefi'a na pasi papaa tala ma rona talai'apuninia ma ei manufidufidu pafea, rona hanaia. ");
INSERT INTO wuv_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Hefi'a na pasi pafoo ei mugoo ma i nusu, rona hole ua, uaa lomi ranu. ");
INSERT INTO wuv_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Hefi'a lau na pasi dupuaa ei wowo'ii na hogia, rona nusufipui a'a ei wowo'ii, ei na fifigifama'eaa ro'ou. ");
INSERT INTO wuv_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Ma'uaa hefi'a na pasi a'a fei rawani'a piye. Ma namina habefarawani ma ei fuaa ro'ou na ona'onaidiai ale'ei hefa pu'udiai a'a ei faroana lau.” I waredigaa fei, na warefabauana, “Hini na pa'i adiana, nei guainia.” ");
INSERT INTO wuv_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Ei otalai nenerana na i'iginia fei hanuu fei warea hanunu. ");
INSERT INTO wuv_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Ina ware, “Fei apa'a wagii ei manumanu i ude'opa'ai a'a fei haparaiaa mei Haidaa, hamona todigia, ma'uaa, a'a hefi'a una warehanunuinia, ba, “‘Rona fafanunu ma lomi ro'aa fanunupa'i; rona guguai ma lomi ro'aa apa'ia.’ ");
INSERT INTO wuv_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","“Sifeni, feni hanuu feni warea hanunu: ei lau, ale'ei fei wareaa mei Haidaa. ");
INSERT INTO wuv_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Ei lau na pasi papaa tala, ale'ei ei rona guguai ma mei hani'u na nomai ma fufusiminaa fei wareaa mei Haidaa a'a ei naranaraa ro'ou ba ronei'aa narafawe'i ma lomi ro'aa tela. ");
INSERT INTO wuv_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Ei lau na pasi pafoo mugoo, ale'ei ei ronado'o ni'eni'e ei ro'aa guainia, ma'uaa, lomi na gugu waraa ro'ou. Ronado'o narafawe'i ma'ida, ma'uaa, i nomai fei au nueia, rona wata'adudu. ");
INSERT INTO wuv_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Ei lau na pasi dupuaa ei wowo'ii na hogia, ale'ei ei ronado'o guguai, ma'uaa, na fifigifatemuaa fei naranaraa ro'ou wagii eni manumanuu feni ano, ei mugoo po'i ma ei ro'oo feni ano, si'ei lomi rona habepa'i. ");
INSERT INTO wuv_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Ma'uaa ei lau na pasi a'a fei rawani'a piye ale'ei ei na pa'i rawani'a maumau ro'ou, ei rona guainaa fei warea, panarofia ma ufawe'i, si'ei rona fuaa. ");
INSERT INTO wuv_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","“Lomi hemea ba i fagu'aa fei we'ai ma opa'ainia haroo hepalo hagi, o augia haroo tawa, ma'uaa, i augia pafoo fei ude'udena ba ei rona wadu'ai, ronei fanunupa'i a'a fei we'ai. ");
INSERT INTO wuv_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Uaa lomi hepalo manumanu na ude'opa'ai ba i opa'ai'ualao. Ma ei manumanu rona opa'ainia iwe lelefo ma ude'are'are. ");
INSERT INTO wuv_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Si'ei, onei narama'aia ba batanai fei mau guguaiamu. Uaa hini na pa'i, iwe pa'i hefi'adiai; hini lomi na pa'i, tamanu fei ina nara ba na pa'i, iwe pa'ai a'ana.” ");
INSERT INTO wuv_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Ei lofu ma mei inaa Jesus, rona nomai ba ro'aa ma'aia, ma'uaa lomi rona nitopa'ilao a'ana uaa fei gupuu rama'a. ");
INSERT INTO wuv_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Hemea na warefania, “Mei inamu ma ei lofumu, rona ufalarai ano ba ro'aa ma'a yoi.” ");
INSERT INTO wuv_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Ina ware, “Si'eni eni inau ma eni lofuu, eni rona guainaa fei wareaa mei Haidaa ma bigi'ia.” ");
INSERT INTO wuv_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Heai arewaa, Jesus na warenaa a'a ei otalai nenerana, “O dii. O'adinaa fipepei adii fei ranu.” Si'ei, rona hugi a'a fei wa ma sua. ");
INSERT INTO wuv_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Ro'aa sualao, na ma'igu Jesus. Fei lalarena na asi'aa ma fei lama na tomesunaa laloo fei wa ma ronawemina fagiana. ");
INSERT INTO wuv_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Ei otalai nenerana, rona nolao ma funia. Rona ware, “Mena Fasu, mena Fasu. O'apa'aa wawau'u!” Ina asi'aa ma warefawe'i a'a fei lalare ma fei agi; ina pedu towetana ma namina madino. ");
INSERT INTO wuv_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Ina i'iginaa ei otalai nenerana, “Hitani fei we'iaa naranaraa hamu'ou?” A'a fei ma'auaa ro'ou ma fei nanawalaa pudaa ro'ou, rona fi'i'igii, “Rama'a bata meni? Te, namina warefawe'i a'a fei lalarena ma fei lama ma lagunamina guainaa wareana.” ");
INSERT INTO wuv_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Rona tamanaa suwidei i Gerasene, opa'aloo fei ranu Galilee. ");
INSERT INTO wuv_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","I wanomai Jesus, na nomai a'ana hemea rama'aa fei gufu, mei na wadu'ia pigea. Namina madimai fei guta'ala'alana ma lomi na u guta laloo humu, ma'uaa na guta a'a ei huapuu ei ma'ea. ");
INSERT INTO wuv_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","I fanunupa'aa Jesus, ina aimemewai ma fapasi igoaa Jesus ma harofabauana, “Tamanu nunumiamu a'au Jesus mena Na'uu mei Haidaa, mei na Pafeai? U'amina i'iginio, onei'aa haperaraiau!” ");
INSERT INTO wuv_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Uaa Jesus na warefawe'i ba fei hafelo'a spiriti nei wala'aa a'a mei. Uaa, ina'aida panarofia. Ma rona'aida roro'inaa panina ma pinena a'a ei alatai ma hefi'a, rona oma'ama'aia, ma'uaa, inafane bimoro'aa ei alatai ma ei pigea na faponinaa hia fawelei lomi rama'a. ");
INSERT INTO wuv_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Jesus na i'iginia, “Hini haramu?” Ina ware, “Legion,” uaa watauda pigea na wadu'ia. ");
INSERT INTO wuv_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Ma rona i'igai ma i'igaidiai ba nei'aa aloaa ro'ou a'a fei walaloa lomi ia'iana. ");
INSERT INTO wuv_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Hepalo baua gupuu moimoi roi hanana papaa fei maugeni. Ei pigea na i'igifawe'i a'a Jesus ba nei uga ba ro'aa wadu'aa ei moimoi ma ina ugainaa ro'ou. ");
INSERT INTO wuv_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Ro wala'amai a'a mei rama'a ei pigea, rona wadu'aa ei moimoi ma poni'upulao pepei na faro'ai adii fei ranu, rofonaa lalona ma wawa'uma'e. ");
INSERT INTO wuv_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Ro fanunuia ale'ei ei oma'ama'aa ei moimoi, rona ponibagua ma u'ugia yei a'a fei baua gufu mawe ei gufu sugatata'aia. ");
INSERT INTO wuv_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Ma ei rama'a na nolao ba ro'aa ma'a tamanu ina bigi'ia. Ro'aa nopa'aloo Jesus, rona fanunupa'aa mei na wala'aa ei pigea a'ana, na guta igoaa Jesus, na pa'i lawalawana ma fei naranarana na rawani ma rona ma'au. ");
INSERT INTO wuv_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Ei rona fanunupa'ia, rona u'ufanaa ei rama'aa gufu batanai i rawanidiai mei na wadu'ia pigea. ");
INSERT INTO wuv_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Ma minaa ei rama'a fawelei Gadara na i'iginaa Jesus ba nei fa'adi'ininaa ro'ou, uaa ronamina ma'aufafelo. Si'ei, ina hugi a'a fei wa ma sua'aunu. ");
INSERT INTO wuv_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Mei rama'a, mei na wala'aa ei pigea a'ana na i'iginia ba i nogia, ma'uaa Jesus na aloia ma ware, ");
INSERT INTO wuv_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“Hadiwe'inaa gufumu ma u'ugaa fei baua bigi'aa mei Haidaa a'amu.” Si'ei, na hadiwe'ai ma u'ufanaa minaa ei rama'aa gufu ei baua bigi'aa Jesus a'ana. ");
INSERT INTO wuv_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","I hadiwe'imai Jesus, fei gupuu rama'a na taufa'ugia, uaa rona aida ba i nomai. ");
INSERT INTO wuv_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Ma hemea, harana Jairus, hemea bauaniaa fei synagogue na nomai ma fapasi igoaa Jesus ma i'igifawe'i a'ana ba nei nomai a'a fei humuna ");
INSERT INTO wuv_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","uaa mei na'una, baduu pifine, ale'ei hefua ma heguai igisimasina, ifi ma'e. Fi talailao Jesus, ei rama'a na fihoroi a'ana. ");
INSERT INTO wuv_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Ma na pa'i hemea pifine yei na tomesumesu namoo ununa ale'ei hefua ma heguai igisimasi, ma'uaa lomi hemea ba i fapedupa'aa funuana. ");
INSERT INTO wuv_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Na aunumai mugina ma idoaa supuu fei hawaa uguna. Ma ana ei, na pedu fei tomesuaa fei namo. ");
INSERT INTO wuv_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Jesus na i'igai, “Hini na idoau?” Minaa ro'ou, rona ware ba lomi ma nawe ware Peter, “Mena Fasu, ei rama'a rona fihoroi a'amu.” ");
INSERT INTO wuv_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Ma'uaa Jesus na ware, “Na pa'i hemea na idoau. Una aida ba na tonaa ma'ida faufau.” ");
INSERT INTO wuv_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Ma mei pifine nawe aida ba ro'aa apa'ia ba hia, si'ei na noma'aumai ma fapasi igoana. I pudaa minaa ei rama'a, na warefanaa ro'ou ba na pedu funuana ana ei i idoia. ");
INSERT INTO wuv_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Ma ina warenaa a'ana, “Mena na'uu, fei we'iaa naranaramu na farawaninio. Aunufa'a'a ua.” ");
INSERT INTO wuv_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Ana fi wareware ua Jesus, na nomai hemea noramiana humuu Jairus, mei bauaniaa fei synagogue. Ma na ware, “Mei na'umu na ma'e. Onei'aa fahaudinaa unuu mei feroia.” ");
INSERT INTO wuv_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","I guainaa fei Jesus, na warenaa a'a Jairus, “Onei'aa ma'au, narafawe'i ua ma iwe mama'a.” ");
INSERT INTO wuv_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","I nopa'aloo fei humuu Jairus, na ware ba lomi hemea i wadu'ai uniaa ro'ou Peter, John, James mawe laguei ama ma inaa mei baduu. ");
INSERT INTO wuv_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Ma a'a fei, minaa ei rama'a rona ai'ai ma wawasusu a'ana. Jesus na ware, “Hamonei'aa ai'ai. Lomi na ma'e. Na ma'igu ua.” ");
INSERT INTO wuv_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Rona fadinia uaa rona aida ba ina ma'e. ");
INSERT INTO wuv_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Ma'uaa ina tauaa panina ma ware, “Mena na'uu, asi'aa!” ");
INSERT INTO wuv_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Fei spiritina na hadiwe'imai ma ana ei, ina ufalarai. Ma Jesus na warenaa a'a ro'ou ba ronei fani hanaa mei baduu. ");
INSERT INTO wuv_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Ma mei amana ma inana namina nanawala pudaa lagua, ma'uaa ina warefawe'i a'a ro'ou ba ronei'aa u'ufanaa nemea tamanu na bigi'ia. ");
INSERT INTO wuv_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","I harofamiaa ei Hefua ma helagui Jesus, na fani faufau a'a ro'ou ma forafora ba ronei fawala'anaa ei pigea ma fapedugaa ei funua ");
INSERT INTO wuv_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","ma na aloaa ro'ou ba ronei u'ugaa fei haparaiaa mei Haidaa ma fapedugaa funuaa ei rama'a. ");
INSERT INTO wuv_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Ina warenaa a'a ro'ou: “Hamonei'aa notoo manumanuu fei tatalaia—lo'e o, raba, du'ua, mugoo po'i, o pafua susu. ");
INSERT INTO wuv_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Tamanu humu hamona wadu'ia, hamonei guta yena nopa'aloo fei ba hamona di'ininaa fei gufu. ");
INSERT INTO wuv_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Nabaa lomi rona taufa'ugaa hamu'ou, hamonei foifoiaa piyee pinee hamu'ou ena hamona di'ininaa fena gufu fena, ale'ena hepalo manumanu i fama'aa ro'ou ba rowe tonaa aree ro'ou wagii fei dududua.” ");
INSERT INTO wuv_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Si'ei, rona aunu ma dinaa hepapalo gufu ma u'ugaa fei rawani'a warea ma fapedugaa funuaa ei rama'a a'a ei gufu tadiwe'aia. ");
INSERT INTO wuv_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Herod, mei haparaa obao gufu na guainaa minaa ei manumanu rona bigi'ia. Ma namina naranara watauda uaa hefi'a na ware ba John na asi'aa a'a fei ma'ea ");
INSERT INTO wuv_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","ma hefi'a na ware ba Elijah na fa'arewamai ma hefi'adiai na ware ba hemea ei mamama'a mina mina na asi'adiai. ");
INSERT INTO wuv_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Ma'uaa Herod na ware, “Una morodigaa huaa John. Si'ei, pa'aa hini mei a guguainaa u'ugana?” Ma ba iree ma'aia. ");
INSERT INTO wuv_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Ro'aa hadiwe'imai ei apostle, rona warefanaa Jesus tamanu rona bigi'ia. Si'ei na nodugaa ro'ou ma uniaa ro'ou, rona dinaa a'a fei gufu, harana Bethsaida. ");
INSERT INTO wuv_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Ma'uaa ro'aa no'apa'alao fei gupuu rama'a, rona nenegia. Ina taufa'ugaa ro'ou ma u'ufanaa ro'ou fei haparaiaa mei Haidaa ma fawanewaneaa ei funua. ");
INSERT INTO wuv_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","I nofafilao, ei hefua ma helagui rona nomai ma ware a'ana, “Aloaa fei gupuu rama'a ba ronei aununaa a'a ei gufu rafi'ii ma labarai hana ma nopaa ro'ou, uaa faweleni ona guta, namina raua.” ");
INSERT INTO wuv_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Ina ware, “Hamonei fani hanaa ro'ou.” Rona ware, “Ona pa'i haipani ua faraa pidaua ma guapalo nia—nabaa lomi, ona aunuponofani du'ua a'a fei gupuu rama'a.” ");
INSERT INTO wuv_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","(Puduu ei wawane yei, ale'ei haipani pufaba'a.) Ma'uaa ina warenaa a'a ei otalai nenerana, “Fafigupuinaa ro'odu ale'ei haipani pa'ania laloo hepapalo gupu.” ");
INSERT INTO wuv_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Ei otalai nenera, rona bigi'ia ma minaa ei rama'a na guta. ");
INSERT INTO wuv_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Ina tonaa haipaniei faraa pidaua ma guapaloei nia, aranaa pafea, ware ‘ta’ ma itafia. Ma na fanaa ei otalai nenera ba ronei alaginia a'a ei rama'a. ");
INSERT INTO wuv_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Minaa ro'ou, rona hananamagu ma ei otalai nenera, rona paiaa ei masii du'ua ma na pepesu hefua ma guapalo pa. ");
INSERT INTO wuv_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Hefarani, fi lafulafu Jesus, uniaa ei otalai nenera i a'ana ma na i'iginaa ro'ou, “Ei gupuu rama'a, rona ware ba yau hini?” ");
INSERT INTO wuv_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Rona ware, “Hefi'a na ware ba John mei pudugufaia; hefi'a ba Elijah ma; hefi'adiai ba hemea mamama'a mina mina na asi'amai a'a fei ma'ea.” ");
INSERT INTO wuv_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Ina i'igai, “Ma'uaa hamu'ou? Hamona ware ba yau hini?” Peter na ware, “Mei Christ, mei aloagiaa mei Haidaa.” ");
INSERT INTO wuv_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Jesus na apunainaa ro'ou ba ronei'aa warefanaa nemeadiai. ");
INSERT INTO wuv_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Ma na ware, “Mei Na'uu Rama'a nei to fi'ina a'a watauda manumanu ma ei bauaniaa gufu, ei famamoaa humuu mei Haidaa ma ei feroiaa law, ro'aa ofadugia, fo'afama'eia ma a'a fei fa'oduaiaa arewaa iwe asi'aa a'a fei ma'ea.” ");
INSERT INTO wuv_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Ma ina warenaa a'a minaa ro'ou, “Hini i nenerau nei madi'inaa ei nunumiana ma a'a hepapalo arewaa nei poro'aa fei hawafolona ma nenerau. ");
INSERT INTO wuv_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Uaa hini ba i fatelaiaa fei fawewenina i pa'ai a'ana, ma'uaa hini ba i fapa'ainaa fei fawewenina a'au, i tohadiwe'idinia. ");
INSERT INTO wuv_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Tamanu rawani'ana nabaa nemea na tonaa minaa ei manumanuu feni ano ma fapa'ainaa fei fawewenina? ");
INSERT INTO wuv_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Ma hini i mamafa a'au ma ei wareau, mei Na'uu Rama'a ana i mamafa a'ana ena na nomai fininaa fei hawerana ma fei haweraa mei Ama mawe ei apunai alo'alo. ");
INSERT INTO wuv_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","A pa'aa warefa'uai a'a hamu'ou ba hamu'ou hefi'a na ufalarai yeni, hamodo'o fanunuaa fei haparaiaa mei Haidaa ma nene hamowe ma'e.” ");
INSERT INTO wuv_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Ale'ei fainaroa arewaa nenee i wareaa fei Jesus, ina dugaa Peter, John mawe James ma rona tafanenaa pafoo maugeni ba ro'aa lafulafu. ");
INSERT INTO wuv_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Ifi lafulafulao, fei maumauna na filogii ma fei susuna namina we'a ale'ei we'aa usida. ");
INSERT INTO wuv_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Helagui rama'a, Moses ma Elijah, laguna fiwarewarei a'ana. ");
INSERT INTO wuv_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Laguna fa'arewamai a'a ei mau rawani'a haweraa lagua ma fiwarewareinaa fei aunuana, fei lomi i madii ba i bigi'ia yei Jerusalem. ");
INSERT INTO wuv_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Namina mama'igu pudaa Peter ma ei tafina, ma'uaa ro'awe werafarawani, rona fanunupa'aa fei hawerana ma helagui rama'a na ufipui a'ana. ");
INSERT INTO wuv_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Ba lagu'aa aunudi'ininaa Jesus, na warenaa a'ana Peter, “Mena fasu, na rawani ba o'ou yeni. O'ounei faduaa odumanu pale—hepalo yoi, hepalo Moses ma hepalo Elijah.” (Lomi ina aida ba i wareaa tamanu.) ");
INSERT INTO wuv_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Ifi warewarelao, hepalo papalei na nomai mi hawaipa'ainaa ro'odu ma rona ma'au ei ro'aa wadu'ainaa tapuu fei papalei. ");
INSERT INTO wuv_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Hepalo lao na waregio a'a fei papalei, “Hemeni, meni Na'uu, meni una rafeinia; guainaa wareana.” ");
INSERT INTO wuv_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","I waredii fei lao, rona fanunuia ba uniaa Jesus. Ei otalai nenera, rona au'uaia a'a ro'ou. Lomi rona warefanaa hemea tamanu rona fanunuia a'a fei au fei. ");
INSERT INTO wuv_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Iree arewadiai, ei ro'aa upudi'ininaa fei maugeni, hepalo gupuu rama'a na nomai a'ana. ");
INSERT INTO wuv_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Hemea ro'ou na harofia, “Mena feroia, ba a i'iginio ba onei ma'a mei na'uu baduu wawane, uaa hia ua na'uu. ");
INSERT INTO wuv_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Hepalo spiriti na'aida panarofia ma mei baduu na iwa'iwa; ina'aida famemeroinia, na'aida nomai pugapugaa poana. Lomi na u fafaa a'ana ma nawemina fafeloia. ");
INSERT INTO wuv_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Una i'igifawe'i a'a ei otalai neneramu ba ronei fawala'ania, ma'uaa, lomi rona fawala'apa'ia.” ");
INSERT INTO wuv_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Jesus na ware, “Haa, hamu'ou eni rama'a wagii feni au feni, eni lomi na narafawe'i ma suauga a'a ei hafelo'a. Amina gutabatanaidilao a'a hamu'ou? Yau na tamafoidii. Dugamai mei na'umu.” ");
INSERT INTO wuv_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Ei fi nomai mei baduu, fei pigea na fapasimemeroinia. Ma'uaa Jesus na warefawe'i a'a fei hafelo'a spiriti, na farawaninaa mei baduu ma dugifanaa mei amana. ");
INSERT INTO wuv_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Ma namina nanawala pudaa ro'odu a'a fei baua faufau mei Haidaa. Ro'ei malefalao a'a ei bigi'aa Jesus, ina warenaa a'a ei otalai nenerana, ");
INSERT INTO wuv_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“Guaifarawaninaa tamanu a warefanaa hamu'ou: Mei Na'uu Rama'a, rowe aloia i panii rama'a.” ");
INSERT INTO wuv_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Ma'uaa lomi rona aida hanuna. Ina ude'opa'ai a'a ro'ou, si'ei, lomi rona apa'aa hanuna ma rona ma'au i'igiana wagina. ");
INSERT INTO wuv_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Rona fiharei ei otalai nenera ba hini ro'ou i pafeai hinene. ");
INSERT INTO wuv_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Jesus na apa'idigaa ei naranaraa ro'ou ma na dugaa hemea baduu ma fa'ugia papana. ");
INSERT INTO wuv_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","I dii, na warenaa a'a ro'ou, “Hini i taufa'ugaa meni baduu meni a'a fei harau, na taufa'ugau; ma hini i taufa'ugau, ana na taufa'ugaa mei i aloagiau. Uaa hini lomi na awata dupuaa hamu'ou na pafeai.” ");
INSERT INTO wuv_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Na ware John, “Mena Fasu, hai'ouna fanunupa'aa hemea fi fawala'anaa ei pigea a'a fei haramu ma hai'ouna apunainia ba inei'aa bigi'ia uaa hia abaa hemea hai'ou.” ");
INSERT INTO wuv_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Jesus na ware, “Hamonei'aa apunainia a'a fei, uaa hini lomi na ofadugaa hamu'ou, hia hemea hamu'odu.” ");
INSERT INTO wuv_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","I rarafi'imai fei auna ba i dinaa gufu pafea, Jesus namina nara ba i pa'aa dinaa Jerusalem. ");
INSERT INTO wuv_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Ma na aloaa hefi'a talaitonaa wareana ba roneido'o nonoo ma wadu'ainaa hepalo gufu i Samaria ma pagi'aufania ei manumanu; ");
INSERT INTO wuv_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","ma'uaa ei rama'a yei, lomi rona taufa'ugia, uaa ifi aununaa Jerusalem. ");
INSERT INTO wuv_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Lagu'aa fanununaa fei laguei otalai nenerana, James ma John, laguna i'igai, “Mena fasu, ona nunuminia ba haigunei ware ba fei hafi nei pasigio pafea ma gu'aiaa ro'odu”? ");
INSERT INTO wuv_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Ma'uaa Jesus na momo'ilao ma hota'aa lagua ");
INSERT INTO wuv_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","ma rona dinaa a'a hepalodiai gufu. ");
INSERT INTO wuv_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Ei roi tatalailao tala, hemea na warenaa a'ana, “Omina dinaa hitani, yau a nenegio.” ");
INSERT INTO wuv_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Jesus na ware, “Ei manulelele na pa'i waduu ro'ou ma ei manufidufiduu pafea na pa'i hofaa ro'ou, ma'uaa, mei Na'uu Rama'a, lomi hefawala ba i haino wagina.” ");
INSERT INTO wuv_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Ina warenaa a'a hemeadiai, “Nenerau.” Ma'uaa na ware mei rama'a, “Mena Fasu, ado'o i'ifinaa amau.” ");
INSERT INTO wuv_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Jesus na warenaa a'ana, “Ei ma'ea, ana ronei fi'i'ifii ana ro'ou, ma'uaa, yoi nei aunu ma warefanaa ro'ou fei u'ugaa fei haparaiaa mei Haidaa.” ");
INSERT INTO wuv_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Ma hemeadiai na ware, “A nenegio mena Fasu; ma'uaa, ado'o dinaa gufuu ma rapu paniu a'a ei maroau.” ");
INSERT INTO wuv_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Jesus na ware, “Lomi nemea i panarofaa fei agi'agii pe'ihape ma diarainaa nene ba iwe bigipa'i wagii fei bigi'aa fei haparaiaa mei Haidaa.” ");
INSERT INTO wuv_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Nenee fei, mei Fasu na rafeinaa oloromfua ma helaguidiai ma alofahelalaguinaa ro'ou ba roneido'o nonoo dinaa a'a minaa ei gufu ba i wadu'ai. ");
INSERT INTO wuv_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Ina warefanaa ro'ou, “Namina watauda ei fua, ma'uaa, ma'ida ua hufu'a. Si'ei, hamonei i'iginaa mei Fasuu ei hufu'a ba nei alo bigibigi'a a'a fei pe'ihapena. ");
INSERT INTO wuv_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Aunu! A aloaa hamu'ou ale'ei na'uu sipsipi dupuaa ena ponotoo podu. ");
INSERT INTO wuv_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Hamonei'aa notoo mugoo po'i, raba, hafena pine o warewarenaa a'a nemea i tala. ");
INSERT INTO wuv_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","“Ena hamona wadu'aa hepalo humu, hamoneido'o ware, ‘Fei gutafarawania a'a hamu'ou ena laloo feni humu feni.’ ");
INSERT INTO wuv_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Nabaa nemea rawani'a rama'a yei, fei rawani'aa hamu'ou i pasinaa pafona; nabaa lomi, i hadiwe'inaa a'a hamu'ou. ");
INSERT INTO wuv_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Guta laloo fei humu fei. Hanana ma hunumaa tamanu rona fanaa hamu'ou uaa na rawani ba mei bigibigi'a i to pono'ana. Apuna guta a'a watauda humu. ");
INSERT INTO wuv_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","“Ena hamona dinaa a'a hepalo gufu ma rona taufa'ugaa hamu'ou, hamonei hanaiaa tamanu rona fanaa hamu'ou. ");
INSERT INTO wuv_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Fapedugaa funuaa ei rama'a yei ma warefanaa ro'ou, ‘Fei haparaiaa mei Haidaa na rafi'inaa hamu'ou.’ ");
INSERT INTO wuv_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Ma'uaa ena hamona dinaa hepalo gufu ma lomi rona taufa'ugaa hamu'ou, dinaa a'a ei talaa ro'ou ma ware, ");
INSERT INTO wuv_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘Hai'ouna foifoiaa ei piyee gufuu hamu'ou a'a ei pinee hai'ou uaa hamona bigifatata. Ma hamonei aida ba fei haparaiaa mei Haidaa na rafi'i.’ ");
INSERT INTO wuv_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","A warefanaa hamu'ou ba na siagigii fagianaa Sodom laraa fei gufu fei. ");
INSERT INTO wuv_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","“Hamona fagiana hamu'ou ena Korazin! Hamona fagiana hamu'ou ena Bethsaida! Uaa, nabaa Tyre ma Sidon na ma'a ei foigia mina, ei foigia hamona ma'aia e'eni, ei rama'aa guapaloei gufu guapaloei, ro'aa filogidigaa naranaraa ro'ou ma gutarafeaa ei madigedigeaa lawalawa ma haguguinaa tabaa ro'ou maduhafi. ");
INSERT INTO wuv_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Ma'uaa a'a fei dududua na siagigii fagianaa Tyre ma Sidon laraa hamu'ou. ");
INSERT INTO wuv_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Ma hamu'ou ena Capernaum, naraa hamu'ou ba hamo'aa di'uanaa gufu pafea? Pa'aa lomi. Hamowe di'uanawii fena walaloa. ");
INSERT INTO wuv_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","“Hini i guainaa hamu'ou na guainau; hini i ofadugaa hamu'ou na ofadugau; ma'uaa, hini i ofadugau na ofadugaa mei i aloagiau.” ");
INSERT INTO wuv_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Ei oloromfua ma helagui, ronawe hadiwe'aimai ma wareni'eni'e, “Mena Fasu, ei pigea ana na neneraa wareaa hai'ou a'a fei haramu.” ");
INSERT INTO wuv_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Ina ware, “Una fanunupa'aa Satan na pasirai yei pafea ale'ei usida. ");
INSERT INTO wuv_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Una fanidii faufau hamu'ou ba hamonei hapuninaa ei hafelo'a wa'a, ei difowai ma muainaa minaa ei faufau mei ba i fo'afama'eaa hamu'ou. ");
INSERT INTO wuv_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Hamonei'aa ni'eni'e ba rona neneraa wareaa hamu'odu ei spiriti hafelo. Ma'uaa hamonei ni'eni'e a'a fei ba ei haraa hamu'ou na pana i gufu pafea.” ");
INSERT INTO wuv_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","A'a fei au fei, si'ei ba fei Spiriti Apuna namina fani'eni'eaa ununa, Jesus na ware, “Una uduginio, O'ama, mena Fasu, mena ona pafeainaa fei haroo pafea ma feni ano, uaa ona opa'ainaa eni manumanu eni a'a ena rona pa'i apa'a ma feroiaa ro'ou ma ona fa'arewaia a'a ei baduu pusu'o. Hi'i, O'ama, uaa ona ni'eni'e ba na ale'ei. ");
INSERT INTO wuv_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","“Minaa ei manumanu nadii fifaninaa paniu mei Amau. Lomi hemea na aida ba mei Na'u, hia hini, ma'uaa, uniaa mei Ama. Ma lomi hemea na aida ba mei Ama, hia hini, ma'uaa, uniaa mei Na'u mawe ei hia na nunumiai ba i fama'aia a'a ro'ou.” ");
INSERT INTO wuv_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Si'ei, ina momo'inaa a'a ei otalai nenerana ma na warefagigii a'a ro'ou, “Na pa'i hawegia a'a ena puda na fanunuaa tamanu hamona fanunuia. ");
INSERT INTO wuv_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Uaa a warefanaa hamu'ou ba watauda mamama'a ma hapara, nunumiaa ro'ou ba ro'aa fanunuaa tamanu hamona fanunuia, ma'uaa lomi rona fanunupa'ia ma ba ro'aa guainaa tamanu hamona guainia, ma'uaa lomi rona guaipa'ia. ");
INSERT INTO wuv_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Heai arewaa hemea na apa'ifarawaninaa fei law, na ufalarai ba i maniaa Jesus. Ina i'igai, “Feroia, a bigi'aa tamanu ba a to harenua lomi i pedutoo?” ");
INSERT INTO wuv_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Ina ware, “Tamanu ne'ia wagii fei Law? Ma ona igobatanainia?” ");
INSERT INTO wuv_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Ina ware: “‘Haguaa mei Haidaa, mei Fasumu a'a minaa fei ha'emu ma minaa fei fawewenimu ma minaa fei faufaumu ma minaa ei naranaramu’; ma ‘Haguaa mei gufumu ana ale'ei ona haguio.’” ");
INSERT INTO wuv_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Jesus na ware, “Ona warepa'ia. Bigi'ia ma o'aa gutalao.” ");
INSERT INTO wuv_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Ma'uaa ba i fawanewaneaa anaia, na i'igai ale'ei, “Ma, hini mei gufuu?” ");
INSERT INTO wuv_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Jesus na ware: “Hemea fi talailao di'ininaa Jerusalem ba i dinaa Jericho ma rona panarofia ei fafanao. Rona forabainini'aa susuna, fo'aia ma anaa i ma'e ma rona di'ininia. ");
INSERT INTO wuv_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Hemea bauaniaa humuu mei Haidaa ana fi aunulao a'a fei tala fei ma na fanunupa'aa mei rama'a mei, na farapa ma aunudi'ininia. ");
INSERT INTO wuv_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Hemea Levi ana ale'ei, i nopa'amii fawelei ma fanunupa'ia, na talai fipepei ma aunudi'ininia. ");
INSERT INTO wuv_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Ma'uaa hemea Samaria fi tatalailao na nopa'amii fawelei na haino mei. I fanunupa'ia, na faloloa'inia. ");
INSERT INTO wuv_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Ina nolao a'ana ma bobo'inaa ei loralorana. Na ipinaa ununa pao ma wine. Ma fahuginia pafoo fei hapena donkey ma noduginaa hia a'a hepalo humuu ma'igua ma roiroinia. ");
INSERT INTO wuv_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Iree arewadiai, ina fanaa mei oma'ama'aa fei humuu ma'igua guapalo mugoo po'i ma warenaa a'ana, ‘Roinia ma ena una hadiwe'aimai, awe pono'aa tamanudiai ona bigi'ia a'ana.’ ");
INSERT INTO wuv_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","“A'a o'oduei, hini ale'ei gufuu mei rona fo'aia ei fafanao?” ");
INSERT INTO wuv_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Mei na pa'i baua apa'ana a'a fei law na ware, “Mei na faloloa'inia.” Jesus na warenaa a'ana, “Onei aunu ma bigi ana ale'ena.” ");
INSERT INTO wuv_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Ei roi tatalailao Jesus ma ei otalai nenerana, ina nopa'amiaa hepalo gufu i guta wagina hemea pifine harana Martha, mei na fagutania humuna. ");
INSERT INTO wuv_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Na pa'i hemea tafina, harana Mary, ma na guta igoaa mei Fasu ma guainaa u'ugana. ");
INSERT INTO wuv_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Ma'uaa Martha, namina nifi rawana uaa ifi bigi'aa ei du'ua. Ina nomai a'ana ma i'igai, “Mena Fasu, haa, lomi ona fanunupa'ia ba unaa yau fimina bigi'aa ei bigi'a ma mei tafiu, na aida ma fi guta ua? Ware a'ana ba inei hadumau!” ");
INSERT INTO wuv_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Mei Fasu na ware, “Martha, Martha, yoi, omina fafi'i'uanaa tabamu a'a watauda manumanu, ");
INSERT INTO wuv_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","ma'uaa hepalo ua manumanu onei bigi'ia. Mary na bigi'aa fei i pa'i hanuna ma lomi hemea i tarafia a'ana.” ");
INSERT INTO wuv_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Heai arewaa, Jesus fi lafulafu hefawala. I lafulafudii, hemea otalai nenerana na warenaa a'ana, “Mena Fasu, feroinaa hai'odu lafulafua ana ale'ei John na feroinaa ei otalai nenerana.” ");
INSERT INTO wuv_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Ina warenaa a'a ro'ou, “Ena hamona lafulafu, hamonei ware ale'ei: “‘O'ama, fei haramu na apunai ma fei haparaiamu nei nomai. ");
INSERT INTO wuv_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Fani hanaa hai'ou a'a hepapalo arewaa. ");
INSERT INTO wuv_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Futoaa ei hafelo'aa hai'ou, uaa hai'ouna futoaa hafelo'aa ei rona fafeloaa hai'ou. Ma onei'aa fa'aunuaa hai'ou a'a ei manimania.’” ");
INSERT INTO wuv_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Ma ina warenaa a'a ro'ou, “Nabaa nemea hamu'ou na pa'i tafina ma ona dinaa a'ana poi difa'u'u ma warenaa a'ana, ‘Otafi, fanau odumanu faraa pidaua, ");
INSERT INTO wuv_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","uaa hemea tafiu noramiana rauaa ma na nomai a'au ma'uaa, lomi na pa'i du'ua ba a fania.’ ");
INSERT INTO wuv_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","“Ma mei laloo humuna i ware, ‘Apuna funiau hamatee na fawidii fei gigei. Ma rona ma'igudii a'au ei na'uu. Lomi a asi'adiai ba a fanio hepalo manumanu.’ ");
INSERT INTO wuv_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","A warefanaa hamu'ou ba fa'ua hia pa'aa tafina, ma'uaa abaa ei i fani hanana uaa ba hia tafina, hamatee si'ei ba lomi ina noma'aulao i'igiana, ipowe asi'afania tamanu nunumiana. ");
INSERT INTO wuv_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","“Si'ena, a warefanaa hamu'ou: I'igai ma o'aa tonia; labarai ma o'aa pa'ia; faba'aba'a ma fei gigei i gigi. ");
INSERT INTO wuv_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Uaa hini i i'igai, i tonia; hini i labarai, i pa'ia; hini i faba'aba'a, i gigi fei gigei a'ana. ");
INSERT INTO wuv_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","“Ena ama, hini hamu'ou, nabaa mei na'umu i i'iginio ba fani hanana nia, o fania hepalo wa'a? ");
INSERT INTO wuv_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","O, nabaa i i'igai ba hanana ha'odu, o fani ua hanana difowai? ");
INSERT INTO wuv_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Fa'ua ba hamu'ou hafelo'a, ma'uaa, ana hamona'aida fani rawani'a manumanu a'a ei na'uu hamu'ou. Ma nabaa ale'ei, hamonei aida ba mei Amaa hamu'ou pafea, iwe aloarai fei Spiriti Apuna a'a ei rona i'iginia!” ");
INSERT INTO wuv_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Jesus na fawala'anaa hepalo pigea umuloo. Ei i wala'aa fei pigea, mei umuloo na wareware ma namina nanawala pudaa fei gupuu rama'a. ");
INSERT INTO wuv_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Ma'uaa hefi'a ro'ou, rona ware, “A'a fei faufau Beelzebub, mei haparaa ei pigea na fawala'anaa ei pigea.” ");
INSERT INTO wuv_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Hefi'adiai, ba ro manimania, rona i'iginia ba nei fama'aiaa ro'ou hepalo hilala i norai pafea. ");
INSERT INTO wuv_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Jesus na apa'idigaa ei naranaraa ro'ou ma na warenaa a'a ro'ou, “Nabaa ei rama'a wagii hefaa baua gufuu hapara ro fifalagii, fei gufu fei i fagiana. Ma ei rama'aa hepalo humu, nabaa lomi rona firawanii, fei humu fei, i pasilogu. ");
INSERT INTO wuv_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Nabaa Satan na figitataa anaia, batanai ba fei haparaiana i udemai? Una ware ale'ei uaa hamona ware ba una fawala'anaa ei pigea a'a fei faufau Beelzebub. ");
INSERT INTO wuv_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Nabaa fa'ua ba una fawala'anaa ei pigea a'a fei faufau Belzebub, ei rona neneraa hamu'ou, rona fawala'anaa ei a'a fei faufau hini? Ma si'ei ana ei neneraa hamu'ou, ro'awe wareia ba afaia fa'ua. ");
INSERT INTO wuv_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Ma'uaa nabaa una fawala'anaa ei pigea a'a fei faufau mei Haidaa, fei haparaiaa mei Haidaa na nodigimai a'a hamu'ou. ");
INSERT INTO wuv_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","“Nabaa mei faufau rama'a, mei na oma'aa fei humuna na pa'ipedu waduna, ei manumanu laloo humuna i udefarawani ua. ");
INSERT INTO wuv_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Ma'uaa nabaa hemea na faufaudiai a'ana, i panarofaa mei amaa fei humu, fugoinia ma tarafaa ei wadu, ei na nara mei amaa fei humu ba i hadupa'ia, te, hemei na faufaudiai, i fi'alaginaa ei manumanu a'a ei tafina. ");
INSERT INTO wuv_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","“Mei lomi na oa a'au na ofadugau ma hini lomi na hadumau fawadu'ainaa ei sipsipi, ina faba'autorainaa ro'ou. ");
INSERT INTO wuv_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","“Ei na wala'aa a'a hemea hepalo hafelo'a spiriti, i talainaa fawelei lomi rama'a ma labarai gutafaweniana, ma'uaa lomi iwe labagipa'ia. Hee, i powe naranara, ‘Unei hadiwe'ainaa fei humu una fa'aa wagina.’ ");
INSERT INTO wuv_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Ma i hadiwe'ailao, na fanunupa'aa fei humu ba na rodii ma ei manumanu na udelafui. ");
INSERT INTO wuv_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Ma si'ei na dugamii olorompalodiai hafelo'a spiriti, hafelo'aa ro'ou na muainia ma rona wadu'aiguta yei. Ma laloo iaa mei, nawemina hafelo apoidiai.” ");
INSERT INTO wuv_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Ei fi warewareaa fei Jesus, hemea pifine dupuaa ei rama'a, na haroharo, “Hawegia a'a mei pifine, mei i waninio ma fagipeio.” ");
INSERT INTO wuv_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Ina ware, “Hi'i, ma'uaa bauanadiai fei hawegia a'a ei rona guainaa fei wareaa mei Haidaa ma nenegia.” ");
INSERT INTO wuv_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Ei fimina wataudalao fei gupuu rama'a, Jesus na ware, “Ei rama'a a'a feni au feni, ronamina hafelo. Rona i'igai ba unei fama'aa ro'ou hepalo hilalaa foigia noranarai pafea ma'uaa, lomi a fama'aa hepalo, ana fei hilalaa Jonah ua. ");
INSERT INTO wuv_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Jonah, hia ale'ei hilala a'a ei Nineveh. Ana ale'ei ba mei Na'uu Rama'a, hia hilala a'a feni tawe feni. ");
INSERT INTO wuv_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","A'a fei au dududua, mei Hapara Pifine, mei noramiana hara'uu, iwe asi'afipui a'a ei rama'aa feni au feni ma ware ba rona tata, uaa namina di'ininaa gufuna i susuwe'i ba i guainaa fei apa'aa Solomon ma'uaa hemea na muainaa Solomon, hia yeni eni. ");
INSERT INTO wuv_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","A'a fei au dududua, ei Nineveh rowe asi'afipui a'a ei rama'aa feni au e'eni ma ware ba rona tata. Uaa rona filoginaa naranaraa ro'ou a'a fei u'ugaa Jonah, ma'uaa hemea na muainaa Jonah, hia yeni eni. ");
INSERT INTO wuv_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","“Lomi hemea i fagu'aa fei we'ai ba i au'opa'ainia haroo hepalo hagi. Ma'uaa i augia a'a fei ude'udena ba ei rona nomai ro'aa fanunupa'aa fei we'ai. ");
INSERT INTO wuv_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Fei pudamu ale'ei we'ai unumu. Nabaa na rawani pudamu, minaa fei unumu, ana i we'apedu. Ma'uaa, nabaa na hafelo pudamu, ana i rorobadubadu unumu. ");
INSERT INTO wuv_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Oma'ama'a ba fei we'ai laloo iamu lomi na roromapa'ai. ");
INSERT INTO wuv_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Si'ei, nabaa minaa fei unumu na we'apedu ma lomi ma'ida dufuu roromaa, imina we'afa'arai, ana ale'ei we'aa fei ramai na we'ainio.” ");
INSERT INTO wuv_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","I waredii Jesus, hemea Pharisee na ware a'ana ba lagu'aa hananafipui; si'ei, ina wadu'ai ma fapalagi ditataa fei tawa. ");
INSERT INTO wuv_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Ma'uaa mei Pharisee na ba'arofo i fanunuia ba Jesus, lomi nado'o huwe ma na hanana ua. ");
INSERT INTO wuv_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Ma mei Fasu na warenaa a'ana, “Hamu'ou ena Pharisee, hamona fesu'uaiaa auguu fei bara ma fei lopi, ma'uaa laloo iaa hamu'ou, namina pepesu ei bagito ma hafelo'a. ");
INSERT INTO wuv_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Hamu'ou poapoa rama'a! Haa! Abaa mei i bigi'aa fei augu ana mei i bigi'aa fei lalona? ");
INSERT INTO wuv_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Ma'uaa hamonei fanaa ei lomi rona pa'i tamanu na ude laloo fei lopi, ma minaa ei manumanu i fafa'arai a'amu. ");
INSERT INTO wuv_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","“Hamona fagiana hamu'ou ena Pharisee, uaa hamona fanaa mei Haidaa hepalo a'a hefua mint, rue ma minaa ei mau manumanu pe'ihapee hamu'ou, ma'uaa hamona madi'inaa fei na wanewane ma fei haguaa mei Haidaa. Hamonei bigi'aa guapaloeni ma ana hamonei fani fanaa hamu'ou. ");
INSERT INTO wuv_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","“Hamona fagiana hamu'ou ena Pharisee, uaa hamona nunuminaa ei gutanaa ei baua rama'a laloo fei synagogue ma ba ronei famafufuoi ma fanunu'apa'aa hamu'ou yei fawelei rona'o alo manumanu ei rama'a. ");
INSERT INTO wuv_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","“Hamona fagiana hamu'ou, uaa tawi'aa hamu'ou ale'ei fei huapu lo'e lalana, fei lomi rona apa'ia rama'a ma rona tatalai pafona.” ");
INSERT INTO wuv_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Hemea na pa'i baua apa'ana a'a fei law na warenaa a'ana, “Feroia, ena ona wareaa ena manumanu ena, ana oi warefafeloaa hai'ou.” ");
INSERT INTO wuv_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Jesus na ware, “Ma hamu'ou ena na pa'i baua apa'a a'a fei law, hamona fagiana anaa, uaa hamona fani rarabaa ei rama'a, ei namina rataiaa ro'ou ma ana lomi hamona fani ma'ida pani a'a ro'odu. ");
INSERT INTO wuv_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","“Hamona fagiana, uaa hamona fadufani humuu ma'eaa ei mamama'a, ma'uaa ana ena upuu hamu'ou, ena rona fo'afama'eaa ro'odu. ");
INSERT INTO wuv_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Ma hamona ware ba na rawani fei bigi'aa ei upuu hamu'ou; fei fo'afama'eaa ro'ou ei mamama'a ma hamona faduaa ei humuu ro'ou, humuu ma'ea. ");
INSERT INTO wuv_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","A'a fei, mei Haidaa wagii fei apa'ana na ware, ‘A aloawii ei mamama'a ma apostle a'a ro'ou. Hefi'a ro'aa fo'afama'eaa ro'ou ma hefi'adiai ro'aa haperararaiaa ro'ou.’ ");
INSERT INTO wuv_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Si'ei, i udenaa a'a eni rama'aa feni au feni fei namoo minaa ei mamama'a, fei wigianamai a'a fei mamaraiamii feni ano nopa'amii wagieni. ");
INSERT INTO wuv_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","I a'a fei namoo Abel dinamii a'a fei namoo Zechariah, mei rona fo'afama'eia watolaa fei tawahafi na apunai ma fei humuu mei Haidaa. Hi'i, a warefanaa hamu'odu ba ei rama'aa feni au feni ro'aa tonaa fagianaa wagii minaa e'ei. ");
INSERT INTO wuv_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","“Hamona fagiana, ena hamona pa'i baua apa'a a'a fei law, uaa hamona opa'ainaa fei gigigii fei apa'a. Lomi hamona wadu'ai ma hamona lawaraa ei ba ro'aa wadu'ai anaa.” ");
INSERT INTO wuv_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","I di'ininaa fawelei Jesus, ei Pharisee mawe ei feroiaa law, ronamina fiharenii a'ana ma i'igai watauda ");
INSERT INTO wuv_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","ba ro'aa fa'alabe'ia ma panarofia na'aa i warefatata. ");
INSERT INTO wuv_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Ma a'a fei au fei, rona figupuimai watauda pufaba'a rama'a ma finitonitoi, Jesus nado'o warenaa a'a ei otalai nenerana, “Oma'aa hamu'odu a'a fena fafuafuaa ena Pharisee. Uaa fei fafuafua, pa'aa ware'oni. ");
INSERT INTO wuv_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Lomi hepalo manumanu opa'aia ba lomi i lelefo, o hepalo manumanu na ude'opa'ai ba lomi ro'aa apa'ia. ");
INSERT INTO wuv_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Tamanu ona wareia a'a fei roromaa, o'aa guainia na arewaa. Ma tamanu ona baba'ufagiginia adiaa hemea laloo humu, fei manumanu fei, ro'aa mewainia pupuaa humu. ");
INSERT INTO wuv_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","“A pa'aa warefanaa hamu'ou ena tafiu, apuna ma'auaa ena rona fo'afama'epa'aa fei hudi unu ma nene, lomi ro'aa bigidinaa hepalo manumanu. ");
INSERT INTO wuv_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Ma'uaa a fa'aiaa hamu'ou mei ba hamonei ma'auia. Ma'auaa mei nabaa i fo'afama'edigaa fei hudi unu, na pa'i faufauna ba i siminaa hamu'ou wagii fei hafi lomi i peretoo. Hi'i, a warefanaa hamu'ou ba hamonei ma'auia. ");
INSERT INTO wuv_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Hamona aidadii ba haipani sumara, rona alonaa guai pusu'o mugoo po'i. Ma'uaa lomi hepalo ro'odu ba mei Haidaa na madi'inia. ");
INSERT INTO wuv_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Hamonei aida ba ei hugoo tabaa hamu'ou, na aidadii puduna. Apuna ma'au; na awatanaa hamu'ou laraa ei watauda sumara. ");
INSERT INTO wuv_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","“A warefanaa hamu'ou ba hini i u a'au i pudaa rama'a, mei Na'uu Rama'a ana i u a'ana i pudaa ei alo'aloo mei Haidaa. ");
INSERT INTO wuv_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Ma'uaa hini i ofadugau i pudaa rama'a, ana a ofadugia i pudaa ei alo'aloo mei Haidaa. ");
INSERT INTO wuv_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Ma hini i warefafeloaa mei Na'uu Rama'a, mei Haidaa i futoia, ma'uaa hini i warefafeloaa fei Spiriti Apuna, mei Haidaa lomi ba iwe futoia. ");
INSERT INTO wuv_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","“Ma ena rona fa'ugaa hamu'ou a'a ei synagogue ma pudaa ei bauana ma ei forafora, apuna naranara watauda ba batanai hamona wareaa fipepei a'a hamu'ou ma hamu'ou ware bata, ");
INSERT INTO wuv_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","uaa fei Spiriti Apuna, iwe feroinaa hamu'ou tamanu hamo'aa wareia a'a fei au fei.” ");
INSERT INTO wuv_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Hemea i dupuaa ei rama'a na warenaa a'ana, “Feroia, warenaa a'a mei lofuu ba nei alaginaa ei manumanu haiguna tonia a'a mei amaa haigua.” ");
INSERT INTO wuv_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Jesus na ware, “Otafi, hini na rafeinau ba fawanewaneaa hamugua?” ");
INSERT INTO wuv_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Ma ina warenaa a'a ro'ou, “Wagi'inaa hamu'ou! Oma'aa hamu'ou a'a fei maumau bagito; fei fawewenii hemea abaa i nomai a'a ei watauda manumanuna.” ");
INSERT INTO wuv_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Ma na u'ufanaa ro'ou feni warea hanunu: “Fei pe'ihapee hemea watauda mugoo po'ina, na pa'i watauda du'ua. ");
INSERT INTO wuv_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Ma ina naranara, ‘A bigi'aa tamanu? Lomi baua pale ba a augaa ei du'ua.’ ");
INSERT INTO wuv_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Ma nawe ware, ‘Sifeni feni unei bigi'ia. Unei rosiaa ei pusu'o pale ma bigi'aa hefi'adiai baua pale ma a aufarawaninaa ei du'ua ma ei manumanuu. ");
INSERT INTO wuv_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Ma apowe warenaa ana a'au, “Yoi na pa'i watauda manumanu i udelao watauda igisimasi. Gutafamamadi'ai ua; hananafarawani, hunufarawani ma gutani'eni'elao.” ’ ");
INSERT INTO wuv_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","“Ma'uaa mei Haidaa na warenaa a'ana, ‘Yoi pa'aa poapoa! Feni poi feni, fena fawewenimu a tonia a'amu. Ma hini ba i tonaa ei manumanu, ei ona to'augia ba manumanumu?’ ");
INSERT INTO wuv_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","“Ana ale'ei a'a hini na to'au manumanu ba manumanuna, ma'uaa lomi na bigi'aa hefi'a manumanu a'a mei Haidaa.” ");
INSERT INTO wuv_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Ma Jesus na warenaa a'a ei otalai nenerana, “Apa'aa warefanaa hamu'ou, apuna naranara watauda a'a fei gutanaa hamu'ou ba hamo'aa hanaiaa tamanu, o fei hudi unuu hamu'ou ba hamo'aa lawainaa tamanu. ");
INSERT INTO wuv_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Wagii fei gutanaa hamu'ou na pa'i hefi'a manumanu na muainaa ei du'ua ma fei hudi unu na muainaa ei lawalawa. ");
INSERT INTO wuv_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Fanunuma'aiaa fei maumau ei sigo. Lomi rona faro ma hufu. Ana lomi rona pa'i pale ude'udee manumanu ma'uaa, mei Haidaa na faguaa ro'ou. Ma hamu'ouna rarabadiai laraa ei manufidufidu! ");
INSERT INTO wuv_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Hini hamu'ou nabaa i naranara watauda ba i famaladinaa fei gutanana? ");
INSERT INTO wuv_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Nabaa lomi hamo'aa bigipa'aa fei pusu'o manumanu fei, tani hamo'aa naranara watauda a'a hefi'adiai manumanu? ");
INSERT INTO wuv_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","“Fanunuma'aiaa fei mau habeaa ei lily. Lomi rona bigimaguhagu ma tawitawi. Ma'uaa a warefanaa hamu'ou ba Solomon wagii ei watauda hawerana lomi na hawawaraa ei fota ei. ");
INSERT INTO wuv_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Si'ei ba mei Haidaa na haweginaa ei guanaa fei pe'ihape, ei yeni wagieni ma narani i simainaa hafi, po'o batanai fei hawegiana, hamu'ou ena lomi namina we'i naranara hamu'ou! ");
INSERT INTO wuv_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Ma apuna naranara watauda a'a tamanu hamo'aa hanaia ma hunumia. ");
INSERT INTO wuv_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Uaa, ei rama'aa roromaa feni ano, rona ponineneraa ei manumanu ei ma mei Amaa hamu'ou na apa'idigia ba hamu'ounapa'aa nunuminia. ");
INSERT INTO wuv_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Ma'uaa labaginaa fei haparaiana ma ei manumanu ei, ana i fanaa hamu'ou. ");
INSERT INTO wuv_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","“Apuna ma'au, hamu'ou ena na'uu sipsipi, uaa mei Amaa hamu'ou na ni'eni'e ba i fanaa hamu'ou fei haparaia pafea. ");
INSERT INTO wuv_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Aloaa ena manumanuu hamu'ou ma fanaa ei lomi rona pa'i. Hamonei tonaa ei raba, ei lomi i wara'atoo ma augaa ei rawani'a manumanu i pafea, ei lomi i pedutoo, fawelei lomi na pa'i fafanao ma pugo'a. ");
INSERT INTO wuv_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Uaa hitani na ude ei rawani'a manumanuu hamu'ou, fei naranaraa hamu'ou ana yei. ");
INSERT INTO wuv_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","“Hamonei hawegi ma ofafaufau a'a fei bigi'a ma fa'udewe'a'uaiaa fei we'ai hamu'ou ");
INSERT INTO wuv_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","ale'ei ei rona oma'aa fei hadiwe'iamii mei fasuu ro'ou a'a fei hananaa fei lalaia, uaa ena na nomai ma faba'aba'a, ro'aa ponigigifania fei gigei. ");
INSERT INTO wuv_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Na rawaninaa ei nafi, nabaa i nopa'amii ro'ou mei fasu roi oma'afafaufau. A warefa'uai a'a hamu'ou ba ana hia i hawegi ale'ei hemea nafi ma ware a'a ro'ou ba ronei gutafapalagi ditataa fei tawa ma i hasufani hanaa ro'ou. ");
INSERT INTO wuv_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Ina rawaninaa ei nafi nabaa mei fasu i nopa'amiaa ro'ou, roi oma'afafaufau laloo poi difa'u'u nopa'aloo mafufuo badu. ");
INSERT INTO wuv_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Ma'uaa hamonei apa'ifarawaninia feni: nabaa mei amaa fei humu nadii aida ba nahaiga i nomai mei fafanao, lomi ba i gutamamadi'ai ua ba i wadu'aimai mei fafanao. ");
INSERT INTO wuv_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Ma hamu'ou, ana hamonei ofafaufau, uaa mei Na'uu Rama'a i nomai a'a fei au lomi hamona nara ba i nomai.” ");
INSERT INTO wuv_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Peter na i'igai, “Mena Fasu, ena o u'ugaa feni warea hanunu, oi u'ufanaa hai'odu, o minaa ei rama'a?” ");
INSERT INTO wuv_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Na ware mei Fasu, “Ale'ei ba hini i oafagugu ma na pa'i apa'ana ba mei fasu i faninaa panina oma'aa ei tameloina ma fani pono'aa hanaa ro'ou a'a fei pa'aa au? ");
INSERT INTO wuv_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Na rawaninaa mei nafi nabaa i hadiwe'ipa'amai mei fasu fi bigi'aa e'ei. ");
INSERT INTO wuv_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","A warefa'uai a'a hamu'odu, mei fasuna i faninaa panina oma'aa minaa ei manumanuna. ");
INSERT INTO wuv_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Ma'uaa nabaa mei nafina na naranara, ‘Haa, mei fasuu, namina madii noranamai’ ma si'ei, ina babuinaa ei nafi wawane ma pifine ma hanana ma hunu ma hunufapoapoai. ");
INSERT INTO wuv_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Mei fasuu mei nafi, iwe nomai a'a fei arewaa ma fei au lomi na nara ba mei fasuna i nomai. Iwe walawalainia ma ware ba nei oafipui a'a ei abaa narafawe'ia. ");
INSERT INTO wuv_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","“Mei nafi, mei na apa'aa ei nunumiaa mei fasuna, ma'uaa lomi na ofafaufau, o bigi'aa ei nunumiana iwe tonaa watauda babu. ");
INSERT INTO wuv_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Ma'uaa mei lomi na aida ma na bigifatata ba inei to babu, iwe to ma'ida babu. Uaa minaa ei rona to watauda, ana ronei bigi'aa watauda; ma a'a mei na udenaa panina watauda, mei fasuna ana i nara ba inei bigi'aa watauda. ");
INSERT INTO wuv_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","“Ena a nomai ba a fagu'anaa hafi feni malagufu ma nunumiau ba gu'adigana mina! ");
INSERT INTO wuv_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Ma'uaa na pa'i hepalo ale'ei pudugufaia ba unei pudugufai wagina ma na fafi'iaa niniwaiu hawina na nopa'aloo fei pedugana. ");
INSERT INTO wuv_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Ei naraa hamu'ou ba eni a nomai ba a fagutafarawaninaa ei rama'a yeni pu? A warefanaa hamu'ou ba pa'aa lomi, uaa a fafi'alaginaa ei rama'a. ");
INSERT INTO wuv_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","E'eni ma nolao iwe pa'i ale'ei haipani rama'a laloo hepalo humu ma ro'aa fi'alagii, o'odui hepapa ma helagui hepapa, o helagui hepapa ma o'odui hepapa. ");
INSERT INTO wuv_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Rowe fi'alagii. Mei ama i fadugeaa mei na'una baduu wawane, o mei na'u baduu wawane i fadugeaa mei amana, mei ina i fadugeaa mei na'una baduu pifine, o mei na'u baduu pifine i fadugeaa mei inana, mei inaa baduu i fadugeaa mei haroo mei na'una wawane, o mei haroo na'una wawane i fadugeaa mei rama'ana.” ");
INSERT INTO wuv_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Ina warenaa a'a fei gupuu rama'a, “Nabaa hamona fanunupa'aa ei papalei na asi'amai Hafaa, hamona poniware ba, ‘Ooo, i pa'i maunu,’ ma napa'aa ropa. ");
INSERT INTO wuv_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Ma nabaa i agimai fei lalarena Rai, hamona ware ba, ‘Pa'aa baua halo wagieni,’ ma pa'aa fa'ua. ");
INSERT INTO wuv_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Hamu'ou ena ware'oni! Hamona fanunu'apa'aa ei manumanu wagii feni malagufu ma fei pumanugawe. Ma tani lomi hamona fanunu'apa'aa ei manumanu a'a feni au feni? ");
INSERT INTO wuv_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","“Tani lomi hamona nara'apa'ia ba afaia na wanewane? ");
INSERT INTO wuv_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Ena ona aunufipui a'a mei ba i dududuio a'a mei fadududua, oneimina fawanewaneia a'ana. Nabaa lomi, i duginaa yoi a'a mei fadududua ma i fifaninio panii mei bobo'aia ma i augio bobo'aia. ");
INSERT INTO wuv_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","A warefanio, pa'aa lomi o lele'aa hawina ona hodipedugaa fei dududuamu.” ");
INSERT INTO wuv_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","A'a fei au fei, na pa'i hefi'a yei rona u'ufanaa Jesus ba Pilate na fo'afama'eaa ei Galilee ei ro'ei moro'aa huaa ei manulelele wagii fei losuu ro'ou. ");
INSERT INTO wuv_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Jesus na ware, “Ei naraa hamu'ou ba ei Galilee ei, ronapa'aa hafelo laraa hefi'adiai Galilee uaa rona tonaa hafelo'aa ro'odu ale'ei? ");
INSERT INTO wuv_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","A warefanaa hamu'odu ba pa'aa lomi! Ma'uaa nabaa lomi hamona filoginaa naranaraa hamu'ou, minaa hamu'ou anaa, hamo'aa fagiana. ");
INSERT INTO wuv_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","O, ei naraa hamu'ou ba ei hefua ma fainaroa rama'a, ei rona ma'e ei i pasi'onaa ro'ou fei pa'aa tarea humu yei Siloam, ba ronapa'aa tata laraa ei hefi'adiai yei Jerusalem? ");
INSERT INTO wuv_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","A warefanaa hamu'odu ba pa'aa lomi! Ma'uaa nabaa lomi hamona filoginaa naranaraa hamu'ou, minaa hamu'ou anaa, hamo'aa fagiana.” ");
INSERT INTO wuv_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Si'ei, na u'ufanaa ro'ou feni warea hanunu: “Hemea rama'a na faroaa hepalo hapena haihai figi i pe'ihapena. Ma na aunu ba i hufu fuana, ma'uaa lomi na pa'i. ");
INSERT INTO wuv_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Si'ei, na warenaa a'a mei oma'aa fei pe'ihapena, ‘Laloo oduai igisimasi una'aida nomai ba a hufu'aa fuaa feni figi ma lomi na pa'i. Rerefapasia! Lomi hanuna ba i udemai!’ ");
INSERT INTO wuv_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","“Mei oma'ama'aa na ware, ‘Mena bauana, fido'o augalao heaidiai igisimasi ma awe agifaweloinaa fasuna ma penuia. ");
INSERT INTO wuv_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Nabaa na fuaa fena igisimasi i nomai, te, na rawani! Nabaa lomi, te, rereia.’” ");
INSERT INTO wuv_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Heai Sabbath Jesus fi feroi laloo hepalo synagogue, ");
INSERT INTO wuv_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","hemea pifine yei na fabauwiaa uguna hepalo spiriti laloo hefua ma fainaroa igisimasi. Namina bauwi ma pa'aa lomi i fawanewanepa'i. ");
INSERT INTO wuv_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","I fanunupa'ia Jesus, na harofamai ma warenaa a'ana, “Mena pifine, onawe ma'ala a'a fei funuamu.” ");
INSERT INTO wuv_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Ma na augaa guapaloei panina pafona ma ana ei ua na ha'uifawanewane ma na uduginaa mei Haidaa. ");
INSERT INTO wuv_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Si'ei ba Jesus na fawanewaneia laloo Sabbath, mei bauaniaa fei synagogue na siba ma warenaa a'a ei rama'a, “Na pa'i oloroa arewaa bigi'a. Si'ei, hamonei nomai ma fapedugaa ei funuaa hamu'ou a'a ei arewaa ei, abaa laloo fei Sabbath.” ");
INSERT INTO wuv_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Mei Fasu na warenaa a'ana, “Hamu'ou pa'aa ware'oni! Haa, laloo fei Sabbath lomi ba hememea hamu'ou na alaraa fei hapena manulelele a'a fei palena, foranaa ano ma fani numana ranu? ");
INSERT INTO wuv_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Ma meni pifine meni, meni na'uu Abraham, meni na panarofia laloo hefua ma fainaroa igisimasi Satan, lomi ba laloo fei Sabbath i ma'ala a'a ei na panarofia?” ");
INSERT INTO wuv_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","I wareaa fei, minaa ei na bidibidi unuu ro'ou a'ana, ronamina mafafafelo, ma'uaa, ei rama'a, ronamina ni'eni'e a'a minaa ei rawani'a bigi'ana. ");
INSERT INTO wuv_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Jesus na i'igai, “Batanai maumau fei haparaiaa mei Haidaa? A fihawawaginia a'a tamanu? ");
INSERT INTO wuv_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Ina ale'ei fei lau mustard hemea na faroia i pe'ihapena. Na habenaa haihai ma ei manufidufidu, rona guta a'a ei rarana.” ");
INSERT INTO wuv_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Ina i'igidiai, “A fihawawaginaa fei haparaiaa mei Haidaa a'a tamanu? ");
INSERT INTO wuv_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Ina ale'ei fei fafuafuaa hemea pifine na tonia ma fihafuinia a'a watauda palaua, bigi'alao nopa'aloo fei ba namina fafuapedugaa minaa ei palaua.” ");
INSERT INTO wuv_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Jesus na aunupedunaa ei pusu'o ma baua gufu nofeferoilao dinaa Jerusalem. ");
INSERT INTO wuv_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Hemea na i'iginia, “Mena Fasu, pa'aa hefi'a ua rama'a ro'aa tela?” Ina warenaa a'a ro'ou, ");
INSERT INTO wuv_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","“Hamoneimina nigofawe'i wagii fei migigia gigei, uaa a warefanaa hamu'ou ba watauda ro'aa wadu'ai, ma'uaa lomi ro'aa wadu'aipa'i. ");
INSERT INTO wuv_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Ma ena na fare'idigaa fei gigei mei amaa fei humu, hamowe ufaba'aba'a ua ano ma ware'ai'ai ba, ‘Mena bauana, gigifanaa hai'odu fei gigei.’ “Ma'uaa i ware, ‘Lomi na apa'aa hamu'ou ma ana lomi na aida ba noramiaa hamu'odu hitani.’ ");
INSERT INTO wuv_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","“Ma hamopowe ware, ‘Hai'ouna hanana ma hunufipui a'amu ma ona feferoi i malalaa gufuu hai'ou.’ ");
INSERT INTO wuv_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","“Ma'uaa i ware ua, ‘Lomi una apa'aa hamu'ou ma ana lomi una aida ba noramiaa hamu'odu hitani. Faraua a'au, hamu'ou ena rama'a hafelo!’ ");
INSERT INTO wuv_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","“Ma yei, iwe pa'i ai'aiga ma roiroiaa difo ena hamona fanunupa'aa Abraham, Isaac, Jacob mawe ei mamama'a yei a'a fei haparaiaa mei Haidaa, ma'uaa ro'aa poronafa'ainaa hamu'ou ano. ");
INSERT INTO wuv_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Ei rama'a rowe norai yei rai ma hafaa ma oala ma hara'uu ma tonaa ei gutanaa ro'ou a'a fei baua hananaa wagii fei haparaiaa mei Haidaa. ");
INSERT INTO wuv_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Hi'i, pa'aa fa'ua ba na pa'i rama'a, ei mugi, ro'aa oanaa ma'a ma ei ma'a, ro'aa oanaa mugi.” ");
INSERT INTO wuv_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","A'a fei au fei, hefi'a Pharisee, rona nomai a'a Jesus ma warenaa a'ana, “Di'ininaa feni gufu feni ma aununaa hefawala. Ba i fo'afama'eio Herod.” ");
INSERT INTO wuv_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Ina ware, “Wi warefanaa fena ponoto fena, ‘A fawala'anaa ei pigea ma farawaninaa ei funua wagieni ma narani ma a'a fei fa'oduaiaa arewaa, awe fapedugaa fei bigi'au’— ");
INSERT INTO wuv_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","uaa pa'aa lomi ba hemea mamama'a i ma'e auguu Jerusalem! ");
INSERT INTO wuv_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","“Oo Jerusalem, Jerusalem, yoi mena, ona fo'afama'eaa ei mamama'a ma nafanaa mugoo ena aloamiana a'amu. Pa'aa nunumiau ba a gumi'ifigupuinaa ena na'umu ale'ei fei inaa a'aroo na hawainaa ei na'una haroo pauna, ma'uaa lomi ona nunumiai! ");
INSERT INTO wuv_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Ma'aia, fei humumu na halohaloa. A warefanaa hamu'ou, lomi o fanunudinaa pudau nopa'aloo fei ba opowe ware, ‘Na pa'i hawegiana mei na nomai wagii fei haraa mei Fasu.’” ");
INSERT INTO wuv_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Hepalo Sabbath, ei i aunu Jesus ba i hanana humuu hemea bauana, mei ana Pharisee, ronamina pupudainia. ");
INSERT INTO wuv_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Na pa'i hemea i ma'ana, mei namina popopola ununa. ");
INSERT INTO wuv_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Jesus na i'iginaa ei Pharisee ma ei rona pa'i baua apa'a wagii fei law, “Na rawani a'a fei law ba o'ou farawaninaa ei funua a'a fei Sabbath, o lo'e?” ");
INSERT INTO wuv_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Ma'uaa rona babanini ua. Si'ei, na tauaa mei rama'a, na fapedugaa funuana ma aloia. ");
INSERT INTO wuv_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Ma na i'iginaa ro'odu, “Nabaa hemea hamu'ou na pa'i na'una, o hapena manulelele ma a'a fei Sabbath na pasi laloo fei ranu agi'agi, fei namina walalo, lomi ba o batafa rafefa'asi'anana?” ");
INSERT INTO wuv_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Ma lomi rona pa'i warewareaa ro'ou. ");
INSERT INTO wuv_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","I fanunuaa ei rama'a, ei rona nomai a'a fei hananaa ba batanai rona tonaa ei gutaa ei baua rama'a a'a fei tawa, ina u'ufanaa ro'ou feni warea hanunu: ");
INSERT INTO wuv_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“Nabaa hemea i lala'io ba onei nomai a'a fei hananaa lalaia, onei'aa tonaa ei gutaa ei baua rama'a, uaa woro i nomai hemea na bauanaidiai a'amu. ");
INSERT INTO wuv_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Nabaa ale'ei, mei i lala'aa hamugua i nomai ma ware a'amu, ‘Fanaa meni feni gutanamu.’ Yoi opowe mamafa ma oree guta a'a ei lomi haraa ro'ou. ");
INSERT INTO wuv_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Ma'uaa ena rona lala'io, tonaa fei gutaa ei lomi na pa'i haraa ro'ou, uaa na nomai mei i lala'io i ware a'amu, ‘Otafi, guta a'a ei baua rama'a.’ Ma nabaa ale'ei, omina raraba i pudaa minaa ei rona nomai a'a fei hananaa. ");
INSERT INTO wuv_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Uaa hini i poronaa hia pafea, i oanaa pu ma hini i fafafaunaa pu, i oanaa pafea.” ");
INSERT INTO wuv_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Ma nawe warenaa a'a mei i lala'ia, “Nabaa o bigi'aa hepalo hananaa, onei'aa lala'aa ena tafimu, lofumu, gufumu o ena na pa'i watauda mugoo po'i. Nabaa o bigi'ia ale'ei, ana ro'aa lala'io ma owe tohadiwe'idinaa ei fanamu. ");
INSERT INTO wuv_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Ma'uaa nabaa o panarofaa hefaa baua hananaa, onei lala'aa ei lomi mugoo po'ii ro'ou, ei hawii ugu, ei afetoo ma ei pudawerai ");
INSERT INTO wuv_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","ma o to hawegiamu. Fa'ua ba lomi ro'aa fanihadiwe'inaa ei fanamu, ma'uaa owe tohadiwe'inaa ei fanamu a'a fei au asi'anaa ei wanewanea.” ");
INSERT INTO wuv_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","I guainaa fei hemea papana a'a fei tawa, na warenaa a'a Jesus, “Baua ni'eni'ea a'a mei i hanana a'a fei baua hananaa wagii fei haparaiaa mei Haidaa.” ");
INSERT INTO wuv_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Jesus na ware, “Hemea na bigi'aa hepalo baua hananaa ma lala'aa watauda. ");
INSERT INTO wuv_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","I nopa'aloo fei baua hananaa, na aloaa mei nafina ba nei warefa'aiaa ei na lala'aa ro'ou, ‘Nomai, uaa minaa ei manumanu na udedii.’ ");
INSERT INTO wuv_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","“Ma'uaa minaa ro'ou, rona ware ba lomi ro'aa nomai uaa na pa'i bigi'aa ro'ou. Mei rawarawa na ware, ‘Ana eni ua na pono'aa fei pe'ihape ma aree ma'aia. Pa'aa hagu'u.’ ");
INSERT INTO wuv_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","“Hemeadiai na ware, ‘Ana eni ua na pono'aa reia buduma'ao ma ado'oree maniaa ro'ou. Pa'aa hagu'u.’ ");
INSERT INTO wuv_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","“Hemeadiai na ware, ‘We lalai'uau eni ma lomi ba a nomai.’ ");
INSERT INTO wuv_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","“Na hadiwe'imai mei nafi ma na warefanaa mei fasuna. Si'ei, na siba mei amaa fei humu ma na warefawe'i a'a mei nafina, ‘Aunubatafanaa ei tala ma ei iaraa fei baua gufu ma dugamii e'ei lomi rona pa'i, ei hawii ugu, ei pudawerai mawe ei afetoo.’ ");
INSERT INTO wuv_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","“Na ware mei nafi a'ana, ‘Mena bauana, tamanu wareamu na bigidigia, ma'uaa atawe pepesu fei humu.’ ");
INSERT INTO wuv_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","“Si'ei, mei fasu na warenaa a'a mei nafina, ‘Aununaa a'a minaa ena tala ma ena gufu tadiwe'ai ma ware a'a ro'ou ba ronei nomai ba nei pa'aa pepesu feni humuu. ");
INSERT INTO wuv_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Apa'aa warefanio ba lomi hemea ena una lala'aa ro'ou iwe hanana a'a feni bigi'au baua hananaa.’” ");
INSERT INTO wuv_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Hefi'a baua gupuu rama'a, na aunuhugiaa Jesus ma i momo'inaa a'a ro'ou na ware, ");
INSERT INTO wuv_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“Nabaa hemea hamu'ou i nomai a'au ma lomi na fabidinaa ununa amana ma inana, mei harona ma ei na'una, ei lofuna ma agina o ana fei fawewenina, lomi iwe oanaa otalai nenerau. ");
INSERT INTO wuv_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Ma hini lomi i harenaa fei hawafolona ma nenerau, hia ana abaa otalai nenerau. ");
INSERT INTO wuv_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","“Nabaa hemea hamu'ou i faduaa hepalo humu tare, haa lomi ido'o gutawareinaa puduu pono'aa ei finefine ma fanunuia ba na pa'aa hawiaa ei mugoo po'ina fapedugana? ");
INSERT INTO wuv_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Uaa, nabaa i fa'u'uaiaa ei u ma lomi na fapedupa'ia, ro'amina fafadinia ei rama'a. ");
INSERT INTO wuv_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","Ma ro'aa ware, ‘Meni rama'a meni ba i fadu; na fa'ugaa ei u ma lomi na fapedupa'ia.’ ");
INSERT INTO wuv_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","“O, nabaa hemea hapara, ba i fifo'ai a'a hemeadiai hapara, haa lo'e ido'o gutanarama'aia ba hia ma ei maroana puduu ro'ou hefua pa'ania pufaba'a, rona hawia ba ro'aa muainaa mei hapara mei na pa'i maroana puduu ro'ou enu pa'ania pufaba'a? ");
INSERT INTO wuv_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Ma nabaa lo'e na hawia, te i aloaa hefi'a maroana ba ronei nolao ma i'iginaa ro'ou ba ro'aa fafiwanewanei, ei ana roi fi nomai rauaa. ");
INSERT INTO wuv_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Ana ale'ei hamu'ou, hini lomi i fanaa minaa ei hia na pa'i, lomi i oanaa otalai nenerau. ");
INSERT INTO wuv_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","“Ina rawani fei agi, ma'uaa nabaa na pa'ai fei agi'agiana, batanai ba i fa'agi'agidinia? ");
INSERT INTO wuv_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Ana lomi na rawaninaa fei malagufu, o fei dupudupuu meme, ro'aa simi'uaia. “Hini na pa'i adiana nei guai.” ");
INSERT INTO wuv_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Ei otonaa mugoo po'ii gavaman mawe ei “hafelo'a rama'a”, ronamina hoaninia ba ro'aa guai wareana. ");
INSERT INTO wuv_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Ma'uaa ei Pharisee ma ei feroiaa law, rona bababau'u, “Meni rama'a meni, na taufa'ugaa ei hafelo'a ma hananafipui a'a ro'ou.” ");
INSERT INTO wuv_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Si'ei, Jesus na u'ufanaa ro'ou feni warea hanunu: ");
INSERT INTO wuv_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“Nabaa hemea hamu'ou, na pa'i hapena sipsipi, puduu ro'ou ale'ena hefa pu'u ma na pa'ai hepalo, haa lomi i di'ininaa ei faimfua pa'ania ma faimpalo fawelei na mama'a ma re labaginaa fei pa'aiaa sipsipi hawina na pa'ia? ");
INSERT INTO wuv_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Ma i nopa'alao, na ni'efuharenia ");
INSERT INTO wuv_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","ma baguanaa gufu. Ma nawe harofamai ei tafina mawe ei gufuna ma ware, ‘Hamonei ni'eni'efipui a'au, uaa na pa'idigia fei pa'aiaa hapeu sipsipi.’ ");
INSERT INTO wuv_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","A warefanaa hamu'ou ba ana ale'ei, i pa'i baua ni'eni'ea yei gufu pafea a'a hemea hafelo'a na filoginaa naranarana laraa ei faimfua pa'ania ma faimpalo, ei ba rona wanewane ma ba lomi ro'aa filoginaa naranaraa ro'ou. ");
INSERT INTO wuv_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","“O, nabaa hemea pifine na pa'i hefua mugoo po'i ma ina fapa'ainaa hepalo, haa lomi ido'o ha'inaa fei we'ai, rofaa fei humu ma lalabagifarawaninia hawina na pa'ia? ");
INSERT INTO wuv_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Ma ena na pa'ia, i harofamai ei tafina mawe ei gufuna ma ware, ‘Me'o, ni'eni'efipui a'au. Uaa, na pa'idigia fei pa'aiaa mugoo po'iu.’ ");
INSERT INTO wuv_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Ana ale'ei, a warefanaa hamu'ou, i pa'i baua ni'eni'ea inamoaa ei alo'aloo mei Haidaa a'a hemea hafelo'a na filoginaa naranarana.” ");
INSERT INTO wuv_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Jesus na waredilao: “Hemea rama'a na pa'i helagui na'una baduu wawane. ");
INSERT INTO wuv_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Mei umugi na warenaa a'a mei amana, ‘O'ama, fanau ei manumanu ba a tonia a'amu.’ Si'ei, mei ama na alaginaa ei manumanuna a'a laguei na'una. ");
INSERT INTO wuv_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","“Ataa madii ma mei umugi, na paiaa minaa ei manumanuna ma aununaa gufu raua ma yei ina neneneinaa ei manumanuna a'a ei maumau hafelo'a. ");
INSERT INTO wuv_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","I'a neneneipedugaa ei manumanuna na moubiabia a'a fei tadiwe'aiaa fei gufu fei ma nawe nanamuinia. ");
INSERT INTO wuv_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Si'ei, na aunulabarai bigi'ana a'a hemea rama'aa fei gufu fei, mei ina alonaa hia pe'ihapena ba nei faguaa ei hapena moimoi. ");
INSERT INTO wuv_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Ina naranara ba i famagunaa iana ei hudii bean, ei roi hanaia ei moimoi ma'uaa, lomi hemea na fani manumanu a'ana. ");
INSERT INTO wuv_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","“Ipowe gutanarapa'ia, ina ware, ‘Figa tameloi mei amau rona pa'i dufu du'ua ma yau yeni, namina baofafelo! ");
INSERT INTO wuv_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Unei hadiwe'ai ma dinaa a'a mei amau ma ware a'ana: O'ama, unamina hafelo i pudaa fei gufu pafea ma i pudamu. ");
INSERT INTO wuv_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Lomi una rawani ba o ware ba yau na'umu; augau ale'ei hemea tameloimu.’ ");
INSERT INTO wuv_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Si'ei, na asi'aa ma aununaa a'a mei amana. “Ma'uaa ei fi nomai rauaa, mei amana na fanunupa'ia ma namina faloloa'inia. Ina ponilao a'a mei na'una, hapiroro'ia ma hatofaa pudana. ");
INSERT INTO wuv_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","“Ma mei na'u na warenaa a'ana, ‘O'ama, namina hafelo i pudaa fei gufu pafea ma i pudamu. Lomi na rawani ba o ware ba yau na'umu.’ ");
INSERT INTO wuv_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","“Ma'uaa mei ama na warenaa a'a ei nafina, ‘Batafa! Tonamai fei pa'aa rawani'a lawalawa ma falawainia. Augaa hepalo alatai ana'anana ma farafefani supinena. ");
INSERT INTO wuv_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Foraiamii fei baua na'uu buduma'ao ma fo'afama'eia. O'aa bigi'aa hefaa baua du'ua ma hanana wiwiwidi. ");
INSERT INTO wuv_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Uaa meni na'uu na ma'edii ma na mama'adiai; ina pa'aidii ma ona pa'idinia.’ Si'ei, ronawe hanana wiwiwidi. ");
INSERT INTO wuv_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","“Ma ei, mei uma'ua, hia laloo pe'ihape. I'a nofarafi'imai a'a fei humu, ina guainaa ei lauga ma ei roi palapala. ");
INSERT INTO wuv_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Si'ei, ina harofaa hemea nafi ma i'iginia ba roi fetanai ei. ");
INSERT INTO wuv_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Ina ware, ‘Mei lofumu na nodigimai ma mei amamu na fo'afama'eaa fei na'uu buduma'ao, uaa na hadiwe'imai ma lomi manumanu na fafeloia.’ ");
INSERT INTO wuv_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","“Mei uma'ua namina sibafafelo ma lomi na wadu'ai. Si'ei, mei amana na asi'alao ma ware'ai'ai a'ana. ");
INSERT INTO wuv_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Ma'uaa na warefanaa mei amana, ‘Ma'aia! Minaa ei igisimasi yau na bigi ale'ei nafimu ma lomi na barafeaa wareamu. Ma'uaa ana pa'aa lomi hepalo fanamu na'uu memee ba a hanana wiwiwidifipui a'a ei tafiu. ");
INSERT INTO wuv_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","I'a nomai meni na'umu, meni na neneneinaa ei manumanumu a'a ei pifinee tala, ona fo'afama'eaa fei baua na'uu buduma'ao a'ana!’ ");
INSERT INTO wuv_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","“Na ware amana, ‘Mena na'uu, yoi mina a'au ranimai ma minaa eni manumanuu, manumanumu. ");
INSERT INTO wuv_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Ma'uaa agunei wiwiwidi ma ni'eni'e, uaa mei lofumu na ma'edii ma na mama'adiai. Na pa'aidii ma o'ouna pa'idinia.’” ");
INSERT INTO wuv_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Jesus na warenaa a'a ei otalai nenerana, “Na pa'i hemea rama'a na watauda mugoo po'ina ma na pa'i hemea oma'ama'aa ei manumanuna ma hefi'a, rona ware ba mei oma'ama'aa na babibiyeinaa ei manumanuu mei fasuna. ");
INSERT INTO wuv_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Si'ei, na harofamai ma i'iginia, ‘Tamanu eni guguaiau wagii fei oma'ama'amu? Onei warefarawaninaa fei bigi'amu, uaa lomi ba o bigidiai.’ ");
INSERT INTO wuv_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","“Mei oma'ama'aa na naranara, ‘A bigi'aa tamanu eni? Mei fasuu ba i fapedugaa bigi'au. Lomi na pa'i faufau ba a agi ma una mamafa noinoia. ");
INSERT INTO wuv_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Haa, una aida ba a bigi'aa tamanu, uaa nabaa i pedu bigi'au yeni, ei rama'a ro'aa taufagutanau humuu ro'ou.’ ");
INSERT INTO wuv_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","“Si'ei, na harofahememeanaa ei rona to mugoo po'i mina a'a mei fasuna ma rotawe hodi'ia. Na i'iginaa mei rawarawa, ‘Hefiga puduu ei ba onei hodi'ia a'a mei fasuu?’ ");
INSERT INTO wuv_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","“Ina ware, ‘Odufua pufaba'a litre pao olive.’ “Mei oma'ama'aa na warenaa a'ana, ‘Tonaa fei ne'ia, gutabatafa ma filoginaa fei puduna, ale'ei hefa pufaba'a ma haipani pu'u.’ ");
INSERT INTO wuv_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","“Ma na i'iginaa mei fahelaguiana, ‘Ma yoi nei hodi'aa hefiga?’ “Ina ware, ‘Hefa pufaba'a ba'ale wheat.’ “Ina warenaa a'ana, ‘Tonaa fei ne'ia ma filoginaa puduna ale'ei fainaroa pu'u.’ ");
INSERT INTO wuv_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","“Si'ei ba mei oma'ama'aa na bigi'ia ale'ei, na wareaa fei sifisifina mei fasuna. Hamatee ei rama'a feni ano, rona pa'i baua apa'aa ro'ou ba ro'aa bigi'aa tamanu a'a ei na fimina'ei maumau ro'ou laraa ei rama'a a'a fei we'ai. ");
INSERT INTO wuv_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","A warefanaa hamu'ou, talainaa eni watauda manumanu feni ano ba hamonei pa'i tafii hamu'ou ma ena na pedu i pa'i rama'a taufagutanaa hamu'ou a'a fei gufu lomi i pedutoo. ");
INSERT INTO wuv_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","“Mei i oma'afarawaninaa ma'ida ua, ana i oma'afarawaninaa watauda manumanu ma mei lo'e i oma'apa'aa ma'ida ua, ana lomi i oma'apa'aa watauda manumanu. ");
INSERT INTO wuv_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Si'ei, nabaa lomi hamona oma'afarawaninaa ei mugoo po'i wagii feni ano, hini ba i fifaninaa panii hamu'ou oma'aa tamanu napa'aa pa'i rarabana? ");
INSERT INTO wuv_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Ma nabaa lomi hamona oma'afarawaninaa manumanuu hemea, hini ba i fani manumanu a'a hamu'ou? ");
INSERT INTO wuv_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","“Lomi hemea nafi i bigi a'a helagui fasu. Uaa i bidi ununa a'a mei ma i haguaa mei. O, imina oafagugu a'a mei ma narafafelo a'a mei. Lomi na hawia ba hamu'ou nafii a'a mei Haidaa ma a'a fei mugoo po'i anaa.” ");
INSERT INTO wuv_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Ei Pharisee, ei rona haguaa mugoo po'i, ro'aa guainaa fei, rona falalasiaa Jesus. ");
INSERT INTO wuv_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Ina warenaa a'a ro'ou, “Hamona fa'upe'upei ba hamona rawani i pudaa rama'a, ma'uaa mei Haidaa na apa'idigaa ei naranaraa hamu'ou. Tamanu fei ei rama'a rona nara ba na rawani, na hafelo i pudaa mei Haidaa. ");
INSERT INTO wuv_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","“Ei ne'ia wagii fei Law ma ei mamama'a, ronamina u'ugamai nopa'amii fei au John. Nenee fei au fei, fei rawani'a wareaa fei haparaiaa mei Haidaa, rona u'ugamai. Ma minaa ei rama'a ronamina nigo ba ro'aa wadu'ai wagina. ");
INSERT INTO wuv_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Na maduta ua pa'aiaa fei pumanugawe ma feni malagufu laraa fei ba ma'ida ne'ia wagii fei Law i pa'ai. ");
INSERT INTO wuv_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","“Hini wawane i fi'alagii a'a mei harona ma lalainaa hemeadiai pifine, ina bigi'aa fei fiharoharoipa'aia. Ma mei wawane i lalainaa mei pifine na fi'alagii a'a harona ana na bigi'aa fei fiharoharoipa'aia. ");
INSERT INTO wuv_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","“Na pa'i hemea na watauda mugoo po'ina, mei na hawegi a'a ei manumanu namina rata pono'ana ma na'aida guta hanana ma'igufarawani ua. ");
INSERT INTO wuv_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Yei poaa fei gigeina, rona fahainopaa hemea noinoi, harana Lazarus. Ei ununa, namina loralorai ");
INSERT INTO wuv_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","ma napa'aa nunumiai ba i hana tamanu na pasimai a'a fei tawaa mei watauda mugoo po'ina. Ma ei ponoto, ana rona nomai mi rawe'aa ei loralorana. ");
INSERT INTO wuv_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","“Nawe nomai fei arewaa ba na ma'e mei noinoi ma ei alo'alo, rona noporonaa hia a'a Abraham. Mei watauda mugoo po'i, ana na ma'e ma rona i'ifinia. ");
INSERT INTO wuv_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Hia na tonaa fi'ina i a'a ei ma'ea, ma'uaa na fanunupa'aa Abraham rauaa ma i papana, Lazarus. ");
INSERT INTO wuv_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Si'ei, na haroharonaa a'ana, ‘O'ama Abraham, faloloa'inau ma aloamii Lazarus ba nei pudinaa ranu umuu ana'anana ma mi falolomaa raweraweu uaa yau eni na tonaa fi'iu a'a feni hafi. ");
INSERT INTO wuv_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","“Ma na ware Abraham, ‘Ona'uu, nonominia ba ei odo'o guta ona tonaa ei rawani'a manumanu, ma'uaa Lazarus namina hafelo gutana. Ma e'eni, ina gutafarawani yeni ma yoi na tonaa fi'imu. ");
INSERT INTO wuv_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Ma hepalodiai, na mina walalo wara'afalaa watolaa haigua ma yoi ma hini i di'ininaa yeni ma dinaa a'amu, pa'aa lomi talana ma ana lomi ba hemea a'amu i nopa'imai a'a haigua.’ ");
INSERT INTO wuv_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","“Ina ware, ‘Na ale'ena o'ama, aloaa Lazarus ba nei dinaa humuu amau ");
INSERT INTO wuv_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","uaa na pa'i hapaini lofuu. Ware a'ana ba neidii warefa'aiaa ro'ou ba ronei'aa nomai a'a feni gufuu fi'ia.’ ");
INSERT INTO wuv_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","“Abraham na ware, ‘Moses ma ei mamama'a, ro'ou yei a'a ro'ou ma ei lofumu ronei guainaa ro'ou.’ ");
INSERT INTO wuv_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","“Ina ware, ‘Lomi, o'ama Abraham, ma'uaa, nabaa hemea a'a ei ma'ea i dinaa a'a ro'ou, rowe filoginaa naranaraa ro'ou.’ ");
INSERT INTO wuv_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","“Ina warenaa a'ana, ‘Nabaa lomi rona guainaa Moses ma ei mamama'a, ana lomi ba ro'aa nara ba pa'aa fa'ua nabaa hemea i asi'aa a'a ei ma'ea.’” ");
INSERT INTO wuv_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Jesus na warenaa a'a ei otalai nenerana, “Iwe nomai ei manumanu ba i fapasiaa ei rama'a, ma'uaa ipa'aa fagiana mei na fapasiaa hemeadiai. ");
INSERT INTO wuv_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Na rawani ba ro'aa faunaa huana hepalo baua mugoo ma famomogia agi laraa fei ba i fapasiaa hemea e'eni pusu'o baduu a'a fei hafelo'a. ");
INSERT INTO wuv_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Si'ei, oma'aa hamu'ou. “Nabaa na pasi a'a ei hafelo'a mei lofumu, warefawe'i a'ana ma nabaa i filoginaa naranara, onei futoaa ei hafelo'ana.” ");
INSERT INTO wuv_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Nabaa i bigi'aa olorompalo tata a'amu laloo heai arewaa ma na hadiwe'imai olorompalopoa a'amu ma ware, ‘Na filoginaa naranarau,’ onei futoaa ei hafelo'ana.” ");
INSERT INTO wuv_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Ei apostle, rona warenaa a'a mei Fasu, “Fagipeaa fei we'iaa naranaraa hai'ou!” ");
INSERT INTO wuv_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Ina ware, “Nabaa namina pusu'o ale'ei lau mustard ei we'iaa naranaraa hamu'ou, hamo'aa warenaa a'a feni baua haihai mulberry, ‘Onei afue ma wi pasi agi,’ ma i guainaa hamu'ou. ");
INSERT INTO wuv_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","“Nabaa hemea hamu'ou na pa'i nafina, mei fi bigi pe'ihape, o oma'aa ei sipsipi, ana i ware a'a mei nafi ei na baguamai podu ba, ‘Nomai, mi gutahanana’. ");
INSERT INTO wuv_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","O i ware a'ana ba, ‘Babagifani hanau, wi nunuu, mi hasufani hanau ma tofanimai numau ma nenee fei, wi hanana ma hunu’. ");
INSERT INTO wuv_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Ana lomi i ware ‘ta’ a'a mei nafi uaa ina bigi'aa tamanu wareana ba nei bigi'ia. ");
INSERT INTO wuv_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Ma hamu'ou ana ale'ei. Ena hamona bigi'aa minaa ei manumanu, ei hamona guainia ba hamonei bigi'ia, hamonei ware, ‘Hai'ou, nafi ua. Hai'ou bigi'uaiaa ei bigi'aa hai'ou.’” ");
INSERT INTO wuv_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Ifi tatalailao dinaa Jerusalem, Jesus na neneraa fei tala watolaa Samaria ma Galilee. ");
INSERT INTO wuv_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Ifi aunulao a'a hepalo gufu, hefua watawatai na u'oma'aia. Rona ufaraua ");
INSERT INTO wuv_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","ma harofabauanamai, “Jesus, mena Fasu, faloloa'inaa hai'ou!” ");
INSERT INTO wuv_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","I fanunupa'aa ro'ou na ware, “Nowau, wi famaua a'a ena bauaniaa humuu mei Haidaa.” Ma ei roi talailao nawe fafa'arai hudi unuu ro'ou. ");
INSERT INTO wuv_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Hemea ro'ou, i fanunuia ba fei hudi ununa na fafa'arai, na hadiwe'ilao ma warefabauana ma uduginaa mei Haidaa. ");
INSERT INTO wuv_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Ina fapasi igoaa Jesus ma ware ‘ta’ ma hia, hemea Samaria. ");
INSERT INTO wuv_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Jesus na i'igai, “Abaa ro'ou hefua namina fafa'arai? Ma ro'ou hitani, ei faimemea? ");
INSERT INTO wuv_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Lomi hemea ro'ou i hadiwe'imai ma uduginaa mei Haidaa? Ana simeni ua, meni hepapa gufu?” ");
INSERT INTO wuv_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Si'ei, na warenaa a'ana, “Asi'a'aunu; fena we'iaa naranaramu na farawaninio.” ");
INSERT INTO wuv_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Hefarani, ei Pharisee na i'iginia ba nahaiga i nomai fei haparaiaa mei Haidaa. Jesus na ware, “Fei haparaiaa mei Haidaa, lo'e ba hamu'ou fanunupa'ia ba na nodigimai ");
INSERT INTO wuv_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","ma ana lomi ro ware ei rama'a ba ‘Oo sifeni, na ude yeni,’ o ‘Sifei yei,’ uaa fei haparaiaa mei Haidaa na ude i laloo iaa hamu'ou.” ");
INSERT INTO wuv_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Ma na warenaa a'a ei otalai nenerana, “I nomai fei au ba hamowe nunuminaa hepalo ei arewaa mei Na'uu Rama'a, ma'uaa lomi hamowe fanunupa'ia. ");
INSERT INTO wuv_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Ro'aa warefanaa hamu'odu ei rama'a ba ‘Simei. Hia, yei!’ o ‘Simeni. Hia, yeni!’ Apuna ponineneraa ro'ou. ");
INSERT INTO wuv_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Uaa mei Na'uu Rama'a a'a fei arewana, hia ale'ei fei usida, fei na usidai ma fawe'ainaa fei pumanugawe fipepei ama'anaa fipepei. ");
INSERT INTO wuv_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Ma'uaa neido'o tonaa watauda fi'ina ma ei rama'aa feni au feni ro ofadugia. ");
INSERT INTO wuv_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","“Fei au Noah ana ale'ei fei au mei Na'uu Rama'a. ");
INSERT INTO wuv_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Ei rama'a, rona hanana, hununu, lalai ma falalai nopa'aloo fei arewaa ba Noah na wadu'ainaa fei baua wa. Ma fei mamaua suwela nawe nomai ma fawawau'uma'eaa minaa ro'odu. ");
INSERT INTO wuv_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","“Ana ale'ei a'a fei au Lot. Ei rama'a, rona hanana, hununu, ponopono, alo'alo, farofaro du'ua ma fadufadu. ");
INSERT INTO wuv_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Ma'uaa fei arewaa i di'ininaa Sodom Lot, fei hafi ma ei babaiaa mugoo na pasirai pumanugawe ma sidafama'eaa minaa ro'odu. ");
INSERT INTO wuv_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","“Ana i ale'ei a'a fei arewaa na fa'arewa mei Na'uu Rama'a. ");
INSERT INTO wuv_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","A'a fei arewaa fei, nabaa nemea i pafoo humuna, inei'aa upu ba i wadu'ainaa humuna ba i to manumanuna. Ana ale'ei, nabaa nemea yei pe'ihapena, inei'aa bagua ba i to hepalo manumanu. ");
INSERT INTO wuv_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Hamonei nonominaa mei haroo Lot! ");
INSERT INTO wuv_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Uaa hini ba i fatelaiaa fei fawewenina, i pa'ai a'ana, ma'uaa hini i fapa'ainaa fei fawewenina a'au, i tohadiwe'idinia. ");
INSERT INTO wuv_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","A warefanaa hamu'odu ba i a'a fei poi fei, helagui rama'a, lagu'awe haino pafoo tawa. Hemea i apa'ai ma hemea ana yei. ");
INSERT INTO wuv_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Helagui pifine, lagu'aa u'ufipui grain; hemea i apa'ai ma hemea ana yei.” ");
INSERT INTO wuv_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Rona i'igai, “Yei hitani, mena Fasu?” Ina ware, “Hitani na pa'i ma'ea, yei ei ro'udo, ro'aa hoania.” ");
INSERT INTO wuv_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Ma Jesus na u'ufanaa ei otalai nenerana hepalo warea hanunu i fama'aiaa ro'ou ba ranimai ronei lafulafu ma ronei'aa rawa'a'afai. ");
INSERT INTO wuv_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Ina ware: “I a'a hepalo gufu na pa'i hemea fadududua lomi na ma'auaa mei Haidaa o rama'a. ");
INSERT INTO wuv_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Ma na pa'i hemea pifine ma'esuabea, mei na u no'ualao ma ware'ai'ai a'a mei fadududua ba, ‘Fawanewaneaa pafoo haigua mei na bidibidi ununa a'au.’ ");
INSERT INTO wuv_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","“Mina figa i'igiana ma lomi na ugainia. Ma'uaa inawe nara, ‘Fa'ua ba lomi una ma'auaa mei Haidaa o ei rama'a, ");
INSERT INTO wuv_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","ma'uaa si'ei ba meni pifine meni, namina fahauaa unuu, hee, unei pa'aa fawanewaneia ma lomi i fai famatapuaa unuu!’” ");
INSERT INTO wuv_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Ma na ware mei Fasu ba, “Hamonei guainaraiaa ei wareaa mei fadududua, mei lomi na wanewane. ");
INSERT INTO wuv_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Ma nabaa ale'ei, naraa hamu'ou ba lomi i fawanewaneaa ei manumanu wagii e'ei rafeiana mei Haidaa, e'ei rona ai'ainaa a'ana arewaa ma poi? Ana hamona nara ba i ofadugi'uaiaa ro'ou? ");
INSERT INTO wuv_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","A warefanaa hamu'ou, iwe fawanewane batafainaa ei pidawaiaa ro'ou. Ma'uaa ena na nomai mei Na'uu Rama'a, ana i ma'apa'i rama'a na narafawe'i yeni malagufu?” ");
INSERT INTO wuv_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Ma a'a feni warea hanunu feni, Jesus na u'ugaa hefi'a rona o'ugaa fei wanewaneaa ana ro'ou ma ba hefi'adiai, rona hafelo: ");
INSERT INTO wuv_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","“Helagui rama'a, laguna tafanewadu'ainaa humuu mei Haidaa ba lagu'aa lafulafu. Hemea lagua, hia Pharisee ma hemea, otonaa mugoo po'ii gavaman. ");
INSERT INTO wuv_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Mei Pharisee na ufalarai ma lafulafu ba hia batanai, ‘Mena Haidaa, a ware ‘ta’ a'amu ba yau, abaa ale'ei hefi'a rama'a—ei fafanao, ei na bigi'aa ei hafelo'a, ei fiharoharoipa'aia, o ale'eni meni otonaa mugoo po'ii gavaman. ");
INSERT INTO wuv_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Una'o fabao ale'ei guapoa laloo heai hafapagipagia ma na'aida au hepalo a'a hefua wagii minaa ei finefineu.’ ");
INSERT INTO wuv_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","“Ma'uaa mei otonaa mugoo po'ii gavaman na ufaraua. Ana lomi na aranaa pafea, ma'uaa na warehafugaa niniwaina, ‘Mena Haidaa, faloloa'inau, yau meni hafelo'a.’ ");
INSERT INTO wuv_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","“A warefanaa hamu'odu ba mei rama'a mei, na hadiwe'inaa humuna ma na wanewane i pudaa mei Haidaa laraa mei Pharisee. Uaa hini i poronaa hia pafea, i oanaa pu ma hini i fafafaunaa hia pu, i oanaa pafea.” ");
INSERT INTO wuv_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Ei rama'a roi dugaloo ei pusu'o baduu a'a Jesus ba nei idoaa ro'ou. Ro'aa fanunuia ei otalai nenera, rona hota'aa ro'ou. ");
INSERT INTO wuv_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Ma'uaa Jesus na harofamii ei baduu a'ana ma ware, “Fa'aunuamii ena baduu a'au ma apuna pauniaa ro'ou, uaa fei haparaiaa mei Haidaa, pa'aa manumanuu eni baduu ale'eni. ");
INSERT INTO wuv_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","A warefa'uai a'a hamu'odu ba hini lomi i tonaa fei haparaiaa mei Haidaa ale'ei ei baduu, pa'aa lomi iwe wadu'ai lalona.” ");
INSERT INTO wuv_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Na pa'i hemea bauana na i'iginia, “Mena rawani'a feroia, a bigi'aa tamanu ba a to harenua lomi i pedutoo?” ");
INSERT INTO wuv_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Jesus na ware, “Tani o ware ba yau rawani'a? Lomi hemea na rawani. Pa'aa unaiaa mei Haidaa ua. ");
INSERT INTO wuv_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Yoi na apa'idigaa fei law: ‘Onei'aa fiharoharoipa'ai, fo'afama'e, fafanao, fanaa fei sifisifi u'uga a'a nemea ma onei ma'auaa amamu ma inamu.’” ");
INSERT INTO wuv_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Ina ware, “Minaa ena na fanima'aia ei ui badui nopa'amii wagieni.” ");
INSERT INTO wuv_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","I guainaa fei Jesus, na warenaa a'ana, “Dufudiamu hepalo manumanu. Aloaa minaa ena ona pa'i ma fanaa ei lomi rona pa'i. Ma owe pa'i manumanumu i pafea. Nenee fei, mi nenerau.” ");
INSERT INTO wuv_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","I guainaa fei, namina faloloa'i, uaa na watauda manumanuna. ");
INSERT INTO wuv_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Jesus na fanununaa a'ana ma ware, “Na mina waiwai a'a ei na pa'i watauda manumanu ba ro'aa wadu'ainaa fei haparaiaa mei Haidaa! ");
INSERT INTO wuv_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Hi'i, na madutainaa fei camel ba i wadu'ainaa fei walawalaa fei tawi laraa mei na pa'i watauda manumanu ba i wadu'ainaa fei haparaiaa mei Haidaa.” ");
INSERT INTO wuv_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","E'ei ro'aa guainaa fei, rona i'igai, “Hama pa'aa hini i tela?” ");
INSERT INTO wuv_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Jesus na ware, “Tamanu lomi na ma'atalaa a'a rama'a na ma'atalaa a'a mei Haidaa.” ");
INSERT INTO wuv_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Peter na warenaa a'ana, “Hai'ouna di'ininaa minaa ei hai'ouna pa'i ba hai'ou nenegio!” ");
INSERT INTO wuv_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Jesus na warenaa a'a ro'odu, “Apa'aa warefa'uai a'a hamu'odu. Hini i di'ininaa gufuna, o harona, o lofuna, o amana ma inana, o na'una uaa fei haparaiaa mei Haidaa, ");
INSERT INTO wuv_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","i tonaa wataudadiai wagii feni au feni ma wagii fei au i nomai, i tonaa fei harenua lomi i pedutoo.” ");
INSERT INTO wuv_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Jesus na dugitata'ainaa ei hefua ma helagui ma warefanaa ro'ou, “O'ou, o aununawii Jerusalem ma minaa ei ne'iaa ei mamama'a mei Na'uu Rama'a, ipowe fa'uai. ");
INSERT INTO wuv_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Ro'aa fifaninia panii ei Gentile. Ma ro'aa warefafeifeinia, warefafeloia, huwia, babuinia ma fo'afama'eia. ");
INSERT INTO wuv_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Ma a'a fei fa'oduiaa arewaa, iwe asi'adiai.” ");
INSERT INTO wuv_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Ei otalai nenera, lomi rona apa'ifarawaninaa fei. Fei hanuna na ude'opa'ai a'a ro'odu. Ma lomi rona apa'aa tamanu fi wareia. ");
INSERT INTO wuv_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","I nofarafi'inaa Jericho Jesus, hemea pudawerai na guta noinoi papaa tala. ");
INSERT INTO wuv_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","I guainaa fei gupuu rama'a roi nolao, na i'igai ba tamanu fei. ");
INSERT INTO wuv_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Rona warefania, “Jesus, mei Nazareth fi nolao.” ");
INSERT INTO wuv_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Ina haroharo, “Jesus, mena Na'uu David, po'o faloloa'inau!” ");
INSERT INTO wuv_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Ei rona talailao ma'a, rona hota'ia ma ware a'ana ba nei babanini. Ma'uaa, namina haropararai ua, “Mena Na'uu David, po'o faloloa'inau!” ");
INSERT INTO wuv_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Jesus na u ma ware ba ronei dugiamai a'ana. I nofarafi'imai, Jesus na i'iginia, ");
INSERT INTO wuv_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“Tamanu nunumiamu ba a bigi'ia a'amu?” Ina ware, “Mena Fasu, nunumiau ba a fanunupa'i.” ");
INSERT INTO wuv_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Jesus na warenaa a'ana, “Onei fanunupa'i! Fei narafawe'iamu na farawaninio.” ");
INSERT INTO wuv_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Ana ei na fanunupa'i ma neneraa Jesus ma na uduginaa mei Haidaa. Ro'aa fanunuia minaa ei rama'a, ana rona uduginaa mei Haidaa. ");
INSERT INTO wuv_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Jesus na dinaa Jericho ma talailao. ");
INSERT INTO wuv_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Na pa'i hemea yei, harana Zacchaeus, hia famomoaa ei otonaa mugoo po'ii gavaman ma na pa'i watauda mugoo po'ina. ");
INSERT INTO wuv_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Hia ba i fanunu ba Jesus rama'a bata, ma'uaa si'ei ba namina welegui, lo'e na fanunupa'i uaa fei gupuu rama'a. ");
INSERT INTO wuv_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Si'ei, na poninaa ma'a ma faneaa hepalo figi sycamore ba i fanunuia, uaa Jesus fi talailao yei. ");
INSERT INTO wuv_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","I nopa'aloo fawelei Jesus, na arenaa pafea ma warenaa a'ana, “Zacchaeus, upubatafagio. A guta humumu wagieni.” ");
INSERT INTO wuv_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Si'ei, na poni'upu ma taufa'ugia. ");
INSERT INTO wuv_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Minaa ei rama'a, rona fanunuaa fei ma bababau'u, “Hia, ba iree gutafipui a'a hemea ‘hafelo'a.’” ");
INSERT INTO wuv_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Ma'uaa, Zacchaeus na ufalarai ma warenaa a'a mei Fasu, “Mena Fasu, fanunu! Yeni ma e'eni a fani hesuwi wagii minaa ei manumanuu a'a ei lomi rona pa'i. Ma nabaa una fafanaonaa hemea a'a hepalo manumanu, te, a hodi'ia ma pafoinaa obaodiai.” ");
INSERT INTO wuv_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Jesus na warenaa a'ana, “Wagieni, fei talaa tela'ana na nomai a'a feni humu feni, uaa meni rama'a meni, ana hemea na'uu Abraham. ");
INSERT INTO wuv_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Uaa mei Na'uu Rama'a na nomai ba i labaginaa ei rona pa'ai ma fatela'anaa ro'ou.” ");
INSERT INTO wuv_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Ei roi guguainaa fei, ina waredilao ma u'ufanaa ro'odu hepalo warea hanunu, uaa hia, na rafi'inaa Jerusalem ma ei rama'a, rona naranara ba fei haparaiaa mei Haidaa ipa'aa sufudai e'eni. ");
INSERT INTO wuv_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Ina ware: “Na pa'i hemea rama'a, waninianamai a'a fei maroaa ei hapara. Ma na aununaa a'a hepalo gufu rauaa ba ro'aa fania fei hapara ma nene, iwe hadiwe'imai. ");
INSERT INTO wuv_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Si'ei, ina lala'aa hefua ei tameloina ma fanaa ro'ou hefua mugoo po'i. Ina ware, ‘Hamonei bigifani fahononoo eni mugoo po'i hawina una hadiwe'imai.’ ");
INSERT INTO wuv_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","“Ma'uaa ei paniaa panina na bidi unuu ro'ou a'ana ma rona aloaa hefi'a nenena ba ronei ware, ‘Lomi hai'ouna nunuminaa meni rama'a meni ba haparaa hai'odu.’ ");
INSERT INTO wuv_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","“Ma'uaa inawe tonaa fei hapara ma hadiwe'inaa gufuna. Ma na lala'amii ei tameloina, ei i fani mugoo po'i a'a ro'ou ba i pa'aa apa'ia ba rona bigifani fahononona. ");
INSERT INTO wuv_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","“Mei rawarawa na nomai ma ware ba, ‘Mena bauana, una bigipa'aa hefuadiai a'a fei mugoo po'imu.’ ");
INSERT INTO wuv_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","“Mei fasuna na ware, ‘Na rawani bigi'amu mena rawani'a tameloiu! Ma si'ei ba ona bigifarawani a'a ei pusu'o manumanu, o'aa oma'aa hefua baua gufu.’ ");
INSERT INTO wuv_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","“Na nomai mei fahelaguiaa tameloina ma ware, ‘Mena bauana, una bigipa'aa haipanidiai a'a fei mugoo po'imu.’ ");
INSERT INTO wuv_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","“Mei fasuna na ware, ‘Yoi oma'aa haipani baua gufu.’ ");
INSERT INTO wuv_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","“Ma i dii, na nomai hemeadiai tameloina ma ware, ‘Mena bauana, sifeni, feni mugoo po'imu; una sumia laloo hepalo pusu'o lawalawa. ");
INSERT INTO wuv_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Una mama'auio, uaa yoi, hemea sibasiba rama'a. Ona tonaa ei abaa augamu ma hufu'aa ei abaa faroamu.’ ");
INSERT INTO wuv_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","“Mei fasuna na ware, ‘A dududunaa yoi a'a ei wareamu, mena hafelo'a tameloiu! Yoi na aida ba yau hemea sibasiba rama'a ba una tonaa ei abaa augau ma hufu'aa ei abaa faroau, na? ");
INSERT INTO wuv_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Nabaa ona aida, tani lomi ona aunaa humuu mugoo po'i ma una hadiwe'imai i pa'i fahononona?’ ");
INSERT INTO wuv_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","“Ma ina warenaa a'a ei rona ufalarai yei, ‘Tonaa fei mugoo po'ina ma fanaa mei na pa'i hefua mugoo po'i.’ ");
INSERT INTO wuv_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","“Rona ware, ‘Mena bauana, na pa'idii hefua a'ana!’ ");
INSERT INTO wuv_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","“Ina ware, ‘A warefanaa hamu'odu ba hini na pa'i, mei fasuna i fani hefi'adiai a'ana, ma'uaa hemei lomi na pa'i, tamanu ma'idei hodihodiana, mei fasuna i tohadiwe'inia a'ana. ");
INSERT INTO wuv_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Ma'uaa ei rama'a na bidi unuu ro'ou a'au, ei lomi rona nunumiai ba unei haparainaa ro'ou—dugamii ro'ou yeni ma fo'afama'eaa ro'ou i pudau.’” ");
INSERT INTO wuv_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","I waredigaa fei Jesus, nado'o nono'aununaa pafea, yei Jerusalem. ");
INSERT INTO wuv_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Ei fi nofarafi'inaa Bethphage ma Bethany a'a fei maugeni, harana Maugeni Olive, na aloaa helagui otalai nenerana ma warenaa a'a lagua, ");
INSERT INTO wuv_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","“Aununaa a'a fei gufu i ma'aa hamugua ma ena hamuna nowau, hamu'aa fanunupa'aa hepalo baubara hosi na fau yena, fena rotawe hugi pafona. Alagia ma foraiamai yeni. ");
INSERT INTO wuv_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Nabaa nemea na i'iginaa hamugua, ‘Tani hamu'aa alagia?’ warefania, ‘Mei Fasu na nunuminia.’” ");
INSERT INTO wuv_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Laguei, lagu'ado'o nolao ma'a, laguna pa'ia ana ale'ei i wareia a'a lagua. ");
INSERT INTO wuv_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Lagu'aa alaraa fei hosi, ei amaa fei, rona i'iginaa lagua, “Tani hamu'aa alaraa fei hosi?” ");
INSERT INTO wuv_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Laguna ware, “Mei Fasu na nunuminia.” ");
INSERT INTO wuv_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Laguna foranaa a'a Jesus ma augaa ei hawaa uguu lagua pafoo fei hosi ma fahuginaa Jesus pafona. ");
INSERT INTO wuv_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Ei fi ponilao, ei rama'a, rona hafeninaa fei tala a'a ei hawaa uguu ro'odu. ");
INSERT INTO wuv_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","I nofarafi'imai a'a fei tala i upunaa fei Maugeni Olive, minaa fei gupuu ei otalai nenerana, namina ni'eni'e ma laugifabauana uduginaa mei Haidaa a'a tamanu foigia rona fanunuia: ");
INSERT INTO wuv_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","“Hawegia a'a mei hapara, mei i nomai wagii fei haraa mei Fasu!” “Fei gutafarawania i pafea ma fei hawera a'a mei na Pafeai!” ");
INSERT INTO wuv_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Hefi'a ei Pharisee a'a fei gupuu rama'a na warenaa a'a Jesus, “Feroia, sibaiaa ei otalai neneramu!” ");
INSERT INTO wuv_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Ina ware, “A warefanaa hamu'ou, nabaa rona babanini, ei mugoo, ro'aa lalaugi.” ");
INSERT INTO wuv_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","I nofarafi'inaa Jerusalem ma fanunupa'aa fei gufu, na pasi u'ugu ranuu pudana wagina ");
INSERT INTO wuv_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","ma na ware, “Nunumiau ba hamonei aida tamanu i fagutafarawaninaa hamu'ou wagieni—ma'uaa eni, na opa'ai pudaa hamu'ou. ");
INSERT INTO wuv_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","I nomai ei arewaa ba ena na bidi unuu ro'ou a'a hamu'ou, ro'aa ufaweloinaa gufuu hamu'ou ma afi e'ee pinee ro'ou ba ro tafanewadu'ainaa gufuu hamu'ou ma fifo'ai a'a hamu'ou. ");
INSERT INTO wuv_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Ro'aa fo'afapasinaa hamu'ou pu, hamu'ou ma ena na'uu hamu'ou a'a ei humuu hamu'ou. Lomi rowedii augaa ne'aa mugoo pafoo hepalodiai, uaa lomi hamona fanunu'apa'aa fei noramiaa mei Haidaa a'a hamu'ou.” ");
INSERT INTO wuv_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","I dii, na dinaa malalaa fei humuu mei Haidaa ma teteaa ei roi alo'alo. ");
INSERT INTO wuv_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Ina warenaa a'a ro'odu, “Na udedii fei ne'ia ‘Fei humuu, humuu lafulafua’; ma'uaa hamona fafaia ale'ei ‘waduu ei fafanao.’” ");
INSERT INTO wuv_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Minaa ei arewaa na feferoi laloo fei humuu mei Haidaa. Ma'uaa ei famamoaa humuu mei Haidaa, ei feroiaa law ma ei bauaniaa gufu ba ro'aa fo'afama'eia. ");
INSERT INTO wuv_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Ma'uaa lomi rona labagipa'i tala ba ro'aa batanainia, uaa minaa ei rama'a namina guaimalefa a'a ei wareana. ");
INSERT INTO wuv_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Heai arewaa, ei fi feroinaa ei rama'a i malalaa fei humuu mei Haidaa ma u'ugaa fei rawani'a warea, ei famamoaa humuu mei Haidaa, ei feroiaa law mawe ei bauaniaa gufu, rona nomai a'ana. ");
INSERT INTO wuv_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Rona i'igai, “Warefanaa hai'ou, foraforaa hini feni o bigi'aa eni manumanu eni. Ma hini na fanio fei forafora?” ");
INSERT INTO wuv_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Ina ware, “Ana na pa'i i'igiau. Warefanau, ");
INSERT INTO wuv_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Hefei pudugufaiaa John—noranamai gufuu pafea, o a'a rama'a?” ");
INSERT INTO wuv_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Rona fiwarewarei wagina ma ware, “Nabaa ona ware ba, ‘Noramiana pafea,’ i i'igai, ‘Hamatani lo'e hamona nara ba fa'ua ei wareana?’ ");
INSERT INTO wuv_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Ma'uaa nabaa o ware ba, ‘A'a rama'a,’ minaa ei rama'a ro'aa nafanaa o'ou mugoo, uaa rona nara ba John, hemea mamama'a.” ");
INSERT INTO wuv_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Si'ei, rona ware, “Lomi hai'ouna aida ba fei pudugufaiana noramiana hitani.” ");
INSERT INTO wuv_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Jesus na ware, “Ana lo'e a warefanaa hamu'ou ba hini na fanau fei forafora, fei na biginaa eni manumanu eni.” ");
INSERT INTO wuv_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Ina u'ulao ma na u'ufanaa ei rama'a feni warea hanunu feni: “Hemea rama'a na bigi'aa hepalo pe'ihape fuaa wine ma hefi'a faroa, rona fania ma'ida mugoo po'i ba rodo'o bigibigi wagina. Ma mei amaa fei pe'ihape na aununaa gufu rauaa ma guta famadii ma'ida. ");
INSERT INTO wuv_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","I nopa'aloo fei au hufu'a, ina aloaa hemea nafina a'a ei faroa ba ronei fania ma'ida fua a'a fei pe'ihape. Ma'uaa ei faroa, rona babuinia ma alofatatalainia, pani ua. ");
INSERT INTO wuv_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Ina aloaa hemeadiai nafi, ma'uaa ana ale'ei, rona babuinia, famamafaia ma rona alofatatalainia, pani ua. ");
INSERT INTO wuv_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Ina alodinaa mei fa'o'oduiaa ro'ou ma rona hafufararaiaa ununa ma bainafa'ainia ano. ");
INSERT INTO wuv_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","“Idii, mei amaa fei pe'ihape nawe ware, ‘A fetanainia feni? Unei aloaa mei na'uu, baduu wawane, mei una haguia; woro ro'aa ma'auia.’ ");
INSERT INTO wuv_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","“Ma'uaa ro'aa fanunupa'ia e'ei faroa, rona fiwarewarei, ‘Simeni, meni ipowe amainaa feni pe'ihape. O dii, o'aa fo'afama'eia ma fei pe'ihape, o'aa tonia.’ ");
INSERT INTO wuv_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Si'ei, rona bainafa'ainia auguu fei pe'ihape ma fo'afama'eia. “Ei naraa hamu'ou ba mei amaa fei pe'ihape i fetanainaa ro'odu? ");
INSERT INTO wuv_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","I nomai, fo'afama'eaa ei faroa ma fanaa fei pe'ihape a'a hefi'adiai.” Ro'aa guainaa fei ei rama'a, rona ware, “Pa'aa lomi na rawani ba fei nei nomai!” ");
INSERT INTO wuv_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Jesus na fanunufa'u'uaa ro'odu ma na i'igai, “Ana? Hama tamanu feni ne'ia: “‘Fei mugoo, fei rona suminia ei fadufadua, i oanaa fafasuii fei humu’? ");
INSERT INTO wuv_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Minaa ei rona pasi pafoo fei mugoo, ro'amina matalatala, ma'uaa, hini i pasi'onia fei mugoo imina marafita.” ");
INSERT INTO wuv_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Ei feroiaa law ma ei famamoaa humuu mei Haidaa, roi labaginaa hefaa tala ba ro'aa panarofia e'eni ua, uaa rona apa'ia ba ifi hanunuinaa ro'ou. Ma'uaa rona ma'auaa ei rama'a. ");
INSERT INTO wuv_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Rona opapaninia ma aloaa hefi'a farerefaia ba ronei nosifilao ma susuaninia ba inei warefatata ma ba ro'aa fifaninia panii ei forafora, ei rona pa'i faufau ro'ou a'a mei gavanaa. ");
INSERT INTO wuv_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Si'ei, ei farerefaia, rona i'iginia, “Mena feroia, Hai'ouna aida ba ona ware ma feroinaa ei na wanewane ma lomi omina fafefenaa hemea, ma'uaa ona feroinaa fei talaa mei Haidaa wagii fei na fa'uai. ");
INSERT INTO wuv_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Ina wanewane nabaa o'ou fani mugoo po'i a'a Caesar, o lo'e?” ");
INSERT INTO wuv_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Ina fanunu'apa'idigaa fei waresuabaduiaa ro'ou ma warenaa a'a ro'ou, ");
INSERT INTO wuv_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","“Fama'aiau hepalo denarius. Hanunuu hini ma ne'iaa hini wagina?” ");
INSERT INTO wuv_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Rona ware, “Caesar.” Ina warenaa a'a ro'ou, “Nadii, fanaa Caesar ei manumanuna ma fanaa mei Haidaa ei manumanuna.” ");
INSERT INTO wuv_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Lomi rona guainaa ma'ida tataa ei wareana i pudaa rama'a. Ma rona maduofo a'a ei wareana, si'ei, rona babanini ua. ");
INSERT INTO wuv_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Hefi'a ei Sadducee, ei rona ware ba lomi asi'ana, rona nomai a'a Jesus a'a hepalo i'igaia. ");
INSERT INTO wuv_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","Rona ware, “Mena Feroia, Moses na ne'ifanaa o'ou ba nabaa hemea wawane haro lalai na pa'i lofuna ma na ma'edi'ininaa harona ma lomi na'uu lagua, mei lofuna nei lalainaa mei pifine ma fuaifani na'uu mei lofuna. ");
INSERT INTO wuv_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Ma na pa'i oloromeai filofui. Mei uma'ua na lalainaa hemea pifine ma na ma'e, lomi na'una. ");
INSERT INTO wuv_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Mei umugina na lalainia. ");
INSERT INTO wuv_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","I ma'edii mei umugina, na lalainia mei umugidiai. Ana ale'ei a'a ei oloromeai. Rona ma'e ma lomi fuaa ro'ou. ");
INSERT INTO wuv_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Ma ana nawe ma'e mei pifine. ");
INSERT INTO wuv_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Si'ei, wagii fei asi'ana, pa'aa haroo hini mei pifine, uaa ei oloromeai filofui rona lalainia?” ");
INSERT INTO wuv_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Jesus na ware, “Eni rama'a a'a feni au feni, ronafane lalai ma falalai. ");
INSERT INTO wuv_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Ma'uaa ei rona pa'i haraa ro'ou ba ro'aa guta wagii fei au na nomai ma a'a fei asi'anaa ei ma'ea, lomi ba ro'aa lalai o falalai ");
INSERT INTO wuv_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","ma lomi ba ro'aa ma'ediai, uaa ro'ou ale'ei ei alo'alo. Ro'ou, na'uu mei Haidaa, uaa rona asi'aa a'a fei ma'ea. ");
INSERT INTO wuv_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Ma'uaa ale'ei fei u'ugaa fei haihai, fei lomi na gu'a wagii fei hafi, Moses na fama'aia ba ei ma'ea, rona asi'aa, uaa ina harofaa mei Fasu ba, ‘Haidaniaa Abraham ma Haidaniaa Isaac ma Haidaniaa Jacob.’ ");
INSERT INTO wuv_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Abaa hia Haidaniaa ei ma'ea, uaa ei rona gutaguta, uaa i a'ana minaa ei, rona gutaguta.” ");
INSERT INTO wuv_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Hefi'a feroiaa law, rona ware, “Ona warefarawaninia, mena feroia!” ");
INSERT INTO wuv_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Ma lomi hemea na i'igidinia hefi'a i'igaia. ");
INSERT INTO wuv_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","I dii, Jesus na warenaa a'a ro'ou, “Tani ro'aa ware ba mei Christ, hia na'uu David? ");
INSERT INTO wuv_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Te, David anaia na ware a'a fei Bu'uu Lauga: “‘Mei Fasu na warenaa a'a mei Fasuu: “Guta raudei ma'au ");
INSERT INTO wuv_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","nopa'aloo fei ba una augaa ei bidibidii unumu labenaa pinemu.” ’ ");
INSERT INTO wuv_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","David na harofia ‘Fasu.’ Batanai ba hia, na'una?” ");
INSERT INTO wuv_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Ei roi guguailao ei rama'a, Jesus na warenaa a'a ei otalai nenerana, ");
INSERT INTO wuv_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“Oma'aiaa hamu'ou a'a ena feroiaa law. Nunumiaa ro'ou ba ro'aa tatalai fininaa ei maleaa hawaa uguu ro'ou ma ba ei rama'a, ronei fanunu'apa'aa ro'odu fawelei rona alo'alo manumanu ma tonaa ei gutanaa ei baua rama'a laloo ei synagogue ma a'a ei baua hananaa. ");
INSERT INTO wuv_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Rona fa'amoaa ei humuu ei pifine ma'esuabea ma lafulafu famalaa i pudaa rama'a. Ma ei rama'a ale'ei, ro'aa pa'aa fagiana.” ");
INSERT INTO wuv_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","I aranaa pafea, Jesus na fanunupa'aa ei rona pa'i watauda mugoo po'i, roi augaa ei fanaa ro'ou laloo fei bao mugoo po'ii humuu mei Haidaa. ");
INSERT INTO wuv_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Ana na fanunupa'aa hemea pifine ma'esuabea, mei lomi na pa'i mugoo po'ina na augaa guapaloei pa'aa pusu'o mugoo po'i. ");
INSERT INTO wuv_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Ina ware, “A warefa'uai a'a hamu'ou, fei fanaa mei pifine mei, na muainaa ei fanaa minaa ei rama'a. ");
INSERT INTO wuv_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Minaa eni rama'a eni, rona fani a'a ei watauda manumanuu ro'ou, ma'uaa hia na fani a'a ma'idei hia na pa'i a'a fei gutana.” ");
INSERT INTO wuv_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Hefi'a ei otalai nenerana na fiwarewareinaa ei fananamaiaa mugoo haweraa fei humuu mei Haidaa ma ei fana a'a mei Haidaa. Ma'uaa Jesus na ware, ");
INSERT INTO wuv_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","“Tamanu eni fanunupa'aa hamu'ou yeni, iwe nomai fei au ba lomi nepalo mugoo i ude pafoo hepalodiai. Minaa ro'ou i wata'o'onaa pu.” ");
INSERT INTO wuv_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Rona i'igai, “Feroia, nahaiga ro'aa nomai ei manumanu ei? Ma tamanu lalana ba ro'aa nomai?” ");
INSERT INTO wuv_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Ina ware, “Oma'aa hamu'ou ba lomi ro'aa sifi'aa hamu'ou. Uaa watauda ro'aa nomai a'a fei harau ma ware, ‘Yau, hia,’ ma ‘Na rafi'i fei au.’ Hamonei'awe neneraa ro'ou. ");
INSERT INTO wuv_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Ena hamona guainia ba na pa'i baua fifo'aia ma hefi'a gufu na pa'i ei hafelo'a na fo'afipui a'a ei bauaniaa gufu, hamonei'aa ma'au. Ei manumanu ei, ido'o nomai ma'uaa, fei a'apoo arewaa lo'e i nobatafamai.” ");
INSERT INTO wuv_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","I dii, ina warenaa a'a ro'ou: “Hefaa baua gufu i fifo'ai a'a hepalodiai baua gufu ma hefi'a hapara ro'aa fifo'ai a'a hefi'adiai hapara. ");
INSERT INTO wuv_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","I pa'i baua rererea a'a feni malagufu, mouabiabia ma hafelo'a funua a'a hefi'a gufu ma hefi'a manumanu na famama'au ma hefi'a baua hilala i haroo pumanugawe. ");
INSERT INTO wuv_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","“Ma'uaa atawe nomai ei manumanu ei ma ro'ado'o panarofaa hamu'ou ma haperaraiaa hamu'ou. Ro'aa noduginaa hamu'ou a'a ei synagogue ma humuu bobo'aia, ana ro'aa fa'ugaa hamu'ou pudaa ei hapara ma gavaman, uaa fei harau. ");
INSERT INTO wuv_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Ma wagii ei manumanu ei, hamo'aa u'ufanaa ro'ou. ");
INSERT INTO wuv_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Ma'uaa hamoneido'o narafarawani ba lomi hamo'aa naranara watauda ba batanai hamona wareaa pepei a'a hamu'ou. ");
INSERT INTO wuv_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Uaa awe fani warea ma apa'aa hamu'ou ba lomi ro'aa fadugeia, o fapidawainia. ");
INSERT INTO wuv_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Ana pa'aa ena ama ma ina ma lofu ma maroa mawe ena tafii hamu'odu, ena rowe aloaa hamu'ou panii ei fadududua ma ro'aa fo'afama'eaa hefi'a hamu'odu. ");
INSERT INTO wuv_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","I bidi unuu minaa ei rama'a a'a hamu'ou, uaa yau. ");
INSERT INTO wuv_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Ma'uaa lo'e hepalo loaa tabaa hamu'odu i pa'ai. ");
INSERT INTO wuv_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Nabaa hamona ofawe'i hamo'aa to faweweni. ");
INSERT INTO wuv_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","“Ena hamona fanununaa Jerusalem ba rona faweloinia ei fo'aa, hamowe aida ba na rafi'i fei ude halohaloana. ");
INSERT INTO wuv_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","A'a fei au fei, ei yei Judea, ronei ponipa'ainaa a'a ei maugeni ma ei a'a ei baua gufu, ronei wala'aa ma ei yei sugatata'aia ronei'aa dinaa a'a fei baua gufu. ");
INSERT INTO wuv_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Uaa sifei fei au ba i fani lagii ei hafelo'a ba nei pa'aa fa'uai minaa ei ronadii ne'inia. ");
INSERT INTO wuv_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Ma a'a fei au fei, napa'aa famama'au a'a ei wareu ma ei roi fasususuu baduu! Iwemina pa'i baua awataa a'a fei gufu ma fei baua sibana i dinaa a'a ei rama'a wagina. ");
INSERT INTO wuv_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Ro'aa ma'e a'a ei wadu ma hefi'a ro bobo'ainaa ro'ou a'a minaa ei baua gufu. Ei Gentile, ro'aa hapuni'onaa Jerusalem nopa'aloo fei au na fapedugaa ro'ou mei Haidaa. ");
INSERT INTO wuv_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","“I pa'i lala a'a fei halo, puda mawe ei pi'u. Yeni ano, ei baua gufu ro'aa fatemu ma hamamagua wagii fei waniwanina ma meme'ii unuu fei agi. ");
INSERT INTO wuv_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Ei rama'a ro'aa ma'aumemeroi ma naranara watauda a'a tamanu fi nomai a'a feni ano, uaa ei manumanuu haroo pafea, i taletatata. ");
INSERT INTO wuv_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","A'a fei au fei, ropowe fanunupa'aa mei Na'uu Rama'a fi nomai memewaa hepalo papalei fininaa faufau ma baua hawera. ");
INSERT INTO wuv_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Ena na nomai ei manumanu ei, ufalarai ma aranaa pafea, uaa fei ponohadiwe'iaa hamu'ou na rafi'i.” ");
INSERT INTO wuv_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Ina u'ufanaa ro'ou feni warea hanunu feni: “Fanununaa fei haihai figi ma hefi'adiai haihai. ");
INSERT INTO wuv_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Ena na sunaimai rau ro'ou, hamona fanunu'apa'ia ba fei augai na rafi'i. ");
INSERT INTO wuv_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Ana ale'ei, ena hamona fanunupa'aa ei manumanu ei, hamonei aida ba fei au haparaiaa mei Haidaa na rafi'i. ");
INSERT INTO wuv_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","“A warefa'uai a'a hamu'ou ba ei rama'aa feni au feni, pa'aa lomi ba ro'aa ma'e hawina ba minaa ei manumanu ei na nodigimai. ");
INSERT INTO wuv_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Fei haroo pafea ma feni malagufu i pa'ai, ma'uaa ei wareau lomi i we pa'ai. ");
INSERT INTO wuv_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","“Oma'afarawaninaa hamu'ou. Nabaa lo'e, ei naranaraa hamu'ou i fa'awataia, ei babareia, hunu poapoai ma naranara watauda a'a ei manumanuu feni ano ma fei arewaa i nopoponamiaa hamu'ou. ");
INSERT INTO wuv_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Uaa, i nomai a'a ei rona guta a'a minaa ei gufu tadiwe'aia. ");
INSERT INTO wuv_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Ranimai hamonei oma'ama'a ma lafulafu ba hamo'aa telapa'i a'a tamanu i nomai, ba hamo'aa upa'i i pudaa mei Na'uu Rama'a.” ");
INSERT INTO wuv_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Minaa ei arewaa Jesus na feferoi yei humuu mei Haidaa ma minaa ei fafi na aunu ba i gutafa'arewaia i pafoo fei maugeni, harana Maugeni Olive, ");
INSERT INTO wuv_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","ma minaa ei rama'a, rona o nofoimai na mafufuo ba ro'aa guainaa u'ugana i humuu mei Haidaa. ");
INSERT INTO wuv_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Hefei baua Hananaa fei Faraa Pidaua Lomi Fafuafua, harana fei Talai Falogia, fi norafi'imai ");
INSERT INTO wuv_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","ma ei famamoaa humuu mei Haidaa mawe ei feroiaa law, roi labarai tala ba ro'aa fapa'ainaa Jesus, uaa rona ma'au a'a ei rama'a. ");
INSERT INTO wuv_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Ma Satan na wadu'aa Judas, hepalo harana Iscariot, hemea ei Hefua ma Helagui. ");
INSERT INTO wuv_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Judas na dinaa a'a ei famamoaa humuu mei Haidaa mawe ei bauaniaa ei oanananaa fei humuu mei Haidaa ma wareware a'a ro'ou ba batanai i aloaa Jesus. ");
INSERT INTO wuv_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Ronamina ni'eni'e ma uga ba ro'aa fani mugoo po'i a'ana. ");
INSERT INTO wuv_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Ina ugainaa ro'ou ma opaninaa hefaa au ba i fifaninaa Jesus panii ro'ou nabaa lomi watauda rama'a. ");
INSERT INTO wuv_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Inawe nomai fei arewaa fei Faraa Pidaua Lomi Fafuafua, fei arewaa ro'aa moro'aa huaa fei sipsipii fei Talai Falogia ba fana a'a mei Haidaa. ");
INSERT INTO wuv_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Jesus na aloaa Peter ma John ma ware, “Hamunei pagi'augaa ena ba o hanaia a'a fei Talai Falogia.” ");
INSERT INTO wuv_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Laguna i'igai, “Ma haigua pagi'augia hitani.” ");
INSERT INTO wuv_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Ina ware, “Ena hamuna nowau a'a fena gufu, hamu'aa bapa'aa hemea fi talaiporo'aa fena baraa ranu. Nenerawau a'a fena humu i dinaa wagina ");
INSERT INTO wuv_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","ma warefanaa mei amaa fei humu, ‘Mei Feroia na i'igai: hitani fei nopaa ei gufu raua ona'o fanaa ro'ou, fei ba a hananafipui a'a ei otalai nenerau wagii fei Talai Falogia?’ ");
INSERT INTO wuv_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Iwe fama'aa hamugua hefaa baua nopa pafea na ude'audii. Pagiaa ei manumanu yena.” ");
INSERT INTO wuv_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Laguna dii ma fanunupa'aa ei manumanu ana ale'ei i warefanaa lagua Jesus. Si'ei, laguna pagi'augaa ei manumanuu fei Hananaa fei Talai Falogia. ");
INSERT INTO wuv_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","I nopa'aloo fei au, Jesus mawe ei apostle, rona gutafapalagi ditataa fei tawa. ");
INSERT INTO wuv_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Ma na warenaa a'a ro'ou, “Pa'aa nunumiau ba a hananafipui a'a hamu'ou feni Hananaa fei Talai Falogia ma hinene a tonaa fi'iu. ");
INSERT INTO wuv_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Uaa, a warefanaa hamu'ou, lomi a hananadinia nopa'aloo fei ba na arewa fei hanuna wagii fei haparaiaa mei Haidaa.” ");
INSERT INTO wuv_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","I todigaa fei bara, na ware ‘ta’ ma warenaa a'a ro'ou, “Tonaa feni ma hunufima'ainia. ");
INSERT INTO wuv_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Uaa, a warefanaa hamu'ou ba lomi a hunudinaa fei ranuu grape nopa'aloo fei noramiaa fei au haparaiaa mei Haidaa.” ");
INSERT INTO wuv_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Ma ina tonaa fei faraa pidaua, ware ‘ta’, itafia, fanaa ro'ou ma ware, “Feni, pigiou, fanau a'a hamu'ou; bigi'ia ale'ei ba fanonomii hamu'ou yau.” ");
INSERT INTO wuv_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Ana ale'ei, ro'aa hananadii, na tonaa fei bara ma ware, “Sifeni feni baraa fei manufau fi'ugaia wagii fei namou, fei i wigii a'a hamu'ou. ");
INSERT INTO wuv_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Ma'uaa fei panii mei ba i aloau, yeni pafoo tawa a'au. ");
INSERT INTO wuv_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Mei Na'uu Rama'a i aunu ana ale'ei fei ne'ia, ma'uaa, ipa'aa fagiana mei ba i aloia. ");
INSERT INTO wuv_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Ma ronawe fi'i'igai ba hini ro'ou na bigi'aa fei. ");
INSERT INTO wuv_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Ana na pa'i fihareia dupuaa ro'ou ba hini i pafeai. ");
INSERT INTO wuv_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Jesus na warenaa a'a ro'ou, “Ei haparaa Gentile rona fasuinaa ei rama'a ma ei paniaa panii ro'ou, rona ware ba ro'ou ana Haduma. ");
INSERT INTO wuv_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Ma'uaa maumau hamu'ou, nei'aa ale'ei. Agia, mei pa'aa bauana dupuaa hamu'ou nei ale'ei hemea baduu ma mei na tonaa fei hapara nei ale'ei hemea nafi. ");
INSERT INTO wuv_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Uaa amaia na pafeai, mei i guta tawa, o mei hasumaa du'ua? A'a ba mei i guta tawa? Ma'uaa yau ale'ei hemea nafi i dupuaa hamu'ou. ");
INSERT INTO wuv_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Hamu'ou, ena hamona palarau wagii ei manimaniau. ");
INSERT INTO wuv_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Ma a fanaa hamu'ou hefaa gufuu hapara, ana ale'ei mei Amau na fanau hepalo ");
INSERT INTO wuv_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","ba hamo'aa hana ma hunu a'a fei tawau wagii fei haparaiau ma guta pafoo ei gutanaa hapara ma dududuaa ei hefua ma guapaloei pai Israel. ");
INSERT INTO wuv_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","“Simon, Simon, Satan na i'igai ba i nuenueinaa hamu'ou ale'ei baranafi. ");
INSERT INTO wuv_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Ma'uaa una lafulafunio, Simon, ba fei we'iaa naranaramu nei'aa wata'adudu. Ma ena ona momo'aimai, onei fawe'iaa naranaraa ei lofumu.” ");
INSERT INTO wuv_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Ma'uaa ina ware, “Mena Fasu, yau a aunuhugio a'a fei bobo'aia ma fei ma'ea.” ");
INSERT INTO wuv_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Jesus na ware, “A warefanio, Peter, hinene i ai fei a'aroo na wagieni i odupoai wareamu ba lomi ona apa'au.” ");
INSERT INTO wuv_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Jesus na i'iginaa ro'ou, “Ei a aloaa hamu'ou pani ua, lomi mugoo po'i, raba, o supinai, hamona nunuminaa hefi'adiai?” Rona ware, “Lomi.” ");
INSERT INTO wuv_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Na warenaa a'a ro'ou, “Ma'uaa e'eni, nabaa na pa'i mugoo po'i, tonia ma hepalo raba anaa. Ma nabaa lomi hamona pa'i wadu, aloaa ei hawaa uguu hamu'ou ma pono'aa hepalo. ");
INSERT INTO wuv_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Na udedii feni ne'ia: ‘Hia, i wareifini a'a ei barafeaa law’; ma u'ei warefanaa hamu'ou ba feni, neipa'aa fa'uai a'au. Fa'ua, tamanu rona ne'inaa a'au, fi nopa'amii fei fafa'uaiana eni.” ");
INSERT INTO wuv_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Ei otalai nenera, rona ware, “Ma'aia, mena Fasu, siguapaloeni, guapaloeni wadu.” Na ware, “Na hawidigia.” ");
INSERT INTO wuv_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Ana ale'ei maumauna, Jesus na dinaa fei Maugeni Olive ma ei otalai nenerana, rona nenegia. ");
INSERT INTO wuv_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Ro'aa nopa'aloo yei, na warenaa a'a ro'ou, “Hamonei lafulafu ba lomi hamo'aa pasi wagii ei manimania.” ");
INSERT INTO wuv_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Ina di'ininaa ro'ou, rauana ale'ei pasiaa nafa'aa ro'ou hefaa mugoo, fa'unaa du'una ma lafulafu, ");
INSERT INTO wuv_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","“O'ama, nabaa ona nunumiai, tonaa feni bara a'au, ma'uaa bigi'aa fei nunumiamu, abaa fei nununumiau.” ");
INSERT INTO wuv_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Hemea alo'alo i pafea na fa'arewa a'ana ma na fawe'ia. ");
INSERT INTO wuv_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Namina awata naranarana ma namina lafulafu fawe'i ma fei mapuna ale'ei namo na pasi'u'ugunaa pu. ");
INSERT INTO wuv_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","I asi'aa a'a fei lafulafuana ma hadiwe'inaa a'a ei otalai nenera, na fanunupa'aa ro'ou rona ma'igu, na madugu unuu ro'ou uaa na fua'onaa ro'ou fei faloloa'ia. ");
INSERT INTO wuv_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Na i'iginaa ro'ou, “Tani hamu'ou ma'igu? Asi'aa ma lafulafu ba lomi hamo'aa pasi wagii ei manimania.” ");
INSERT INTO wuv_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Ana fi wareware ua, hefaa gupuu rama'a na nomai ma mei harana Judas, hemea ei Hefua ma Helagui, na talaidugamii ro'ou. Na nolao a'a Jesus ba i hatofaa pudana, ");
INSERT INTO wuv_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","ma'uaa Jesus na i'iginia, “Judas, yoi ba o'aa aloaa mei Na'uu Rama'a a'a fei hatofaa puda?” ");
INSERT INTO wuv_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Ro'aa fanunuia ba tamanu fi nomai ei ro'aa neneraa Jesus, rona ware, “Mena Fasu, hai'ou fo'anaa eni waduu hai'ou?” ");
INSERT INTO wuv_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Hemea ro'ou na lafigipa'aa adiaa mei nafii mei pa'aa bauaniaa humuu mei Haidaa, raudei ma'au. ");
INSERT INTO wuv_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Ma'uaa Jesus na ware, “Nei pedu feni!” Ma na idoaa adiaa mei rama'a mei ma farawaninia. ");
INSERT INTO wuv_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Jesus na warenaa a'a ei famamoaa humuu mei Haidaa, ei bauaniaa ei oanananaa fei humuu mei Haidaa mawe ei bauaniaa gufu, ei ba ro'aa panarofia, “Tani hamu'ou notomai wadu ma babu—ei naraa hamu'ou ba a fo'afiloginaa ei bauaniaa gufu? ");
INSERT INTO wuv_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Minaa ei arewaa yau a'a hamu'ou i malalaa humuu mei Haidaa ma lomi hamona panarofau. Ma'uaa feni, au hamu'ou, au haparaiaa fei roromaa.” ");
INSERT INTO wuv_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Si'ei, rona panarofo'aia ma noduginaa hia humuu mei pa'aa bauaniaa humuu mei Haidaa. Peter na talaifa'ude'udemai nene. ");
INSERT INTO wuv_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Ma'uaa ro'aa pa'aiaa fei hafi i memewaa fei malalaa humu ma gutafipui, Peter na guta hugiaa ro'ou. ");
INSERT INTO wuv_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Hemea nafi nanao na fanunupa'ia na guta yei a'a fei we'aa fei hafi. Ina fanunufa'u'uia ma ware, “Meni rama'a meni, hia hemea a'ana.” ");
INSERT INTO wuv_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Ma'uaa na ware'opa'ainia, “Mena pifine, lomi una apa'ia.” ");
INSERT INTO wuv_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Lomi namina madii ma hemeadiai na fanunupa'ia ma na ware, “Yoi ana hemea ro'ou.” Na ware Peter, “Otafi, abaa yau!” ");
INSERT INTO wuv_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","I didii ale'ei heai hour, hemeadiai na ware, “Meni rama'a meni napa'aa guta a'ana uaa hia hemea Galilee.” ");
INSERT INTO wuv_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Peter na ware, “Otafi, lomi na apa'aa ena mau wareamu!” Ana fi wareware ua, na ai fei a'aroo. ");
INSERT INTO wuv_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Mei Fasu na diarai ma fanunufa'u'uaa Peter. Ma Peter nawe naraiaa tamanu na warefania mei Fasu: “Hinene i ai fei a'aroo, i odupoai wareamu ba lomi ona apa'au.” ");
INSERT INTO wuv_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Ma ina asi'anaa ano ma namina aimatogutogu. ");
INSERT INTO wuv_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Ei rona oma'aa Jesus, rona warefalalasia ma hafugia. ");
INSERT INTO wuv_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Rona sumaa pudana ma warefawe'i a'ana, “Dii unifanaa hai'ou ba hini fi hafugio?” ");
INSERT INTO wuv_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Ma ronamina wareaa watauda hafelo'a a'ana. ");
INSERT INTO wuv_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","I ba'amai fei panii arewaa, ei bauaniaa gufu—ei famamoaa humuu mei Haidaa mawe ei feroiaa law, rona gutafipui ma hefi'a na nodugaloo Jesus i a'a ro'ou. ");
INSERT INTO wuv_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Rona ware, “Nabaa yoi mei Christ, warefanaa hai'ou.” Jesus na ware, “Nabaa na warefanaa hamu'ou, hamo'aa nara ba abaa fa'ua ");
INSERT INTO wuv_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","ma nabaa a i'iginaa hamu'ou, lomi ba hamo'aa ware. ");
INSERT INTO wuv_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Ma'uaa e'eni ma nolao, mei Na'uu Rama'a i guta raudei ma'au mei Haidaa, mei na faufau.” ");
INSERT INTO wuv_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Minaa ro'ou na i'igai, “Hama yoi Na'uu mei Haidaa?” Na ware, “Na wanewane ena wareaa hamu'ou ba yau hia.” ");
INSERT INTO wuv_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Ma rona ware, “Tamanu hanuna ba o'aa todiai u'uga a'a feni dududua? Ona guaidigaa ei warea lele'amiana ana a'a fei haba'umuna.” ");
INSERT INTO wuv_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Minaa ei a'a fei gupu na asi'aa ma noduginaa hia a'a Pilate. ");
INSERT INTO wuv_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Ma rona ware ba ina bigifatata, “Hai'ouna aida ba meni rama'a meni, na fafeloaa feni gufuu hai'ou. Lomi na nunuminia ba ei rama'a ronei fani mugoo po'i a'a Caesar ma ware ba hia Christ, hemea hapara.” ");
INSERT INTO wuv_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Si'ei, Pilate na i'iginaa Jesus, “Haa, yoi mei haparaa ei Jew?” Jesus na ware, “Hi'i, ana ale'ena wareamu.” ");
INSERT INTO wuv_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","I dii, Pilate na warenaa a'a ei famamoaa humuu mei Haidaa ma fei gupuu rama'a, “Lomi una labagipa'i tataa meni rama'a meni.” ");
INSERT INTO wuv_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Ma'uaa ronamina'u ware'ualao, “Ina fa'una'anaa ei rama'a tadiwe'aiaa Judea a'a ei feroiana. Rawarawa na bigi'ia Galilee ma nawe nopa'amii yeni.” ");
INSERT INTO wuv_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","I guainaa fei, Pilate na i'igai ba hia Galilee. ");
INSERT INTO wuv_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","I apa'alao ba Jesus na guta wagii fei haparaiaa Herod, ina alonaa hia a'a Herod, mei ana hia yei Jerusalem a'a fei au fei. ");
INSERT INTO wuv_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","I fanunupa'aa Jesus Herod, namina ni'efafelo uaa minaa nunumianamai mina ba i fanunuia. Ma wagii ei guaiana u'ugana na nara ba i fanunu na bigi'aa hefi'adiai foigia. ");
INSERT INTO wuv_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Ina i'igainia watauda i'igaia, ma'uaa Jesus, lomi na u wareware a'ana. ");
INSERT INTO wuv_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Ei famamoaa humuu mei Haidaa mawe ei feroiaa law, rona ufalarai yei ma warefi'u'uinaa difoo ro'ou ba hia napa'aa tata. ");
INSERT INTO wuv_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Ma Herod mawe ei maroana fo'aa, rona hapehapeia ma warefafeifeinia. Rona farafenaa hia fei maurawani hawaa ugu ma alohadiwe'inia a'a Pilate. ");
INSERT INTO wuv_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","A'a fei arewaa fei, Herod ma Pilate, lagunawe fitafii—do'o fama'a na pa'i watolaa lagua. ");
INSERT INTO wuv_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Pilate na harofipuinamii ei famamoaa humuu mei Haidaa ma ei bauaniaa gufu mawe ei rama'a ");
INSERT INTO wuv_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","ma warenaa a'a ro'ou, “Hamona dugamii meni ba hia mei i fa'una'anaa ei rama'a ba ronei fo'afipui a'a fei gavaman. Una i'iginia i pudaa hamu'ou ma lomi na labagipa'i pa'afii fei tatana, fei hamona ware ba ina bigi'ia. ");
INSERT INTO wuv_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Ma Herod, ana lomi na labagipa'aa tatana, uaa ina alohadiwe'inamai a'a o'ou ma hamona fanunupa'idigia ba hia, lomi na bigi'aa hepalo manumanu ba nei ma'e. ");
INSERT INTO wuv_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Si'ei, ado'o babuinia ma awe alagia.” ");
INSERT INTO wuv_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Ma ronamina fai harofa, “Dugifarauaninia mena rama'a mena. Ma alafanamiaa hai'ou Barabbas!” ");
INSERT INTO wuv_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","(Rona bobo'ainaa Barabbas uaa ina ba'ananarai a'a fei gufu ma ana na fo'afama'e rama'a). ");
INSERT INTO wuv_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Si'ei ba Pilate na naranara ba i alaraa Jesus, na i'igidinaa ro'ou, ");
INSERT INTO wuv_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","ma'uaa rona haroharo memewai ua, “Fatawaia! Fatawaia!” ");
INSERT INTO wuv_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Ina warefa'odupoai a'a ro'ou, “Tani ei? Tamanu bigifatatana? Lomi una labagipa'aa hepalo tatana ba nei ma'e. Si'ei, ado'o babuinia ma awe alagia.” ");
INSERT INTO wuv_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Ma'uaa ronamina harofawe'i ba i nei fatawa ma fei harofaa ro'ou nawe nopa'ilao. ");
INSERT INTO wuv_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Si'ei, Pilate nawe nara ba ipowe ugainaa fei i'igaiaa ro'ou. ");
INSERT INTO wuv_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Ina alaraa mei bobo'aia wagii fei ba'ananaraiana ma fo'afama'eana rama'a, mei rona nunuminia ma na rawanaa panii ro'ou Jesus. ");
INSERT INTO wuv_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Roi nodugalao, rona panarofaa Simon, mei Cyrene fi baguamai sugatata'aia ma rona fafuharenaa hia fei hawafolo ba nei talaifuharenalao nenee Jesus. ");
INSERT INTO wuv_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Abaa po'o rama'a, ei ro'ei nenegia; hefi'a ro'ou, ei pifine, ei rona aimemewai ma ai'aigia. ");
INSERT INTO wuv_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Jesus na oma'anaa a'a ro'ou ma ware, “Ena pifine, na'uu Jerusalem, apuna aigau; hamonei aigaa ana hamu'ou ma ena na'uu hamu'ou. ");
INSERT INTO wuv_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Uaa iwe nomai fei arewaa hamopowe ware, ‘Rona pa'i hawegiaa ro'ou ei pa'abeu pifine, ei watau lomi na wanini baduu ma ei susu lomi na fasusu baduu!’ ");
INSERT INTO wuv_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Ma “‘ropowe ware a'a ei baua maugeni, “pasi'onaa hai'ou!” Ma a'a ei pusu'o maugeni, “Hawainaa hai'ou!” ’ ");
INSERT INTO wuv_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Uaa nabaa rona bigi'ia a'a fei mamarawii haihai, po'o batanaidiai a'a fei na manunu?” ");
INSERT INTO wuv_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Helaguidiai, rama'a hafelo, ana rona nodugifipuinaloo lagua a'ana ba ro'aa fatawaa lagua. ");
INSERT INTO wuv_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Ro'aa nopa'amii fawelei harana Guitaba, rona fatawaia yei watolaa lagua, hemea ma'auna ma hemea mauwina. ");
INSERT INTO wuv_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Jesus na ware, “O'ama, futoaa ei hafelo'aa ro'ou, uaa lomi rona apa'aa tamanu roi bigi'ia.” Ma ei susuna rona fi'alaginia wagii fei uni'uni fifigaiaa ro'ou. ");
INSERT INTO wuv_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Ei rama'a, roi ufanunu ma ei bauaniaa ei Jew na faba'efoinia. Rona ware, “Ina fatelaiaa hefi'a ma e'eni nei fatelaiaa anaia nabaa hia mei Christ, Hemei Rafeiana, mei aloagii mei Haidaa.” ");
INSERT INTO wuv_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Ei fo'aa, ana rona nomai a'ana ma warefafeifeinia. Rona fani numana, fei para'aa wine ");
INSERT INTO wuv_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","ma ware, “Nabaa yoi haparaa ei Jew, onei fatelaio.” ");
INSERT INTO wuv_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Ina pa'i hefaa ne'ia palalana ba, “SIMENI, MENI HAPARAA EI JEW.” ");
INSERT INTO wuv_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Hemea laguei hafelo'a, laguei lagu'aa fatawa yei na warefafeloia: “Abaa yoi mei Christ? Fatelaio ma haigua!” ");
INSERT INTO wuv_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Ma'uaa hemea lagua na hota'ia. Ina ware, “Lomi ona ma'auaa mei Haidaa? Abaa yoi ana o ma'e ale'ei hia? ");
INSERT INTO wuv_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Ina wanewane ba agu'aa ma'e uaa lagii ei hafelo'aa agua. Ma'uaa meni rama'a meni, lomi na bigi'aa hepalo tata.” ");
INSERT INTO wuv_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Ma ina ware, “Jesus, nonominau ena ona panarofaa fena haparaiamu.” ");
INSERT INTO wuv_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Jesus na warefania, “A warefa'uai a'amu ba wagieni, yoi o oafipui a'au wagii fei fananamaiaa gufu.” ");
INSERT INTO wuv_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Inawe nopa'amii fei fa'oloroaiaa hour ma fei roromaa namina hawainaa minaa fei gufu nopa'aloo fei fafaimeiaiaa hour, ");
INSERT INTO wuv_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","uaa fei halo lomi na we'a. Ma fei lawalawaa fei rapirapii fei humuu mei Haidaa na anininaa guapapa. ");
INSERT INTO wuv_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Jesus namina harofabauana, “O'ama, fei spiritiu, i panimu.” I waredigaa fei, na fawenai apoinaa fei fawewenina. ");
INSERT INTO wuv_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","I fanununaa fei mei centurion, na uduginaa mei Haidaa ma ware, “Pa'aa fa'ua ba meni, pa'aa wanewanea. ");
INSERT INTO wuv_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Ro'aa nofipuimai ei rama'a ba ro'aa fanunu fei, rona fanunuia ma aunuhafuhafugaa niniwai ro'ou. ");
INSERT INTO wuv_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Ma'uaa minaa ei rona apa'ia mawe ei pifine ro'aa nenegia ei i norai Galilee, rona ufaraua ma fafanununaa ei manumanu ei. ");
INSERT INTO wuv_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Ina pa'i hemea rama'a, harana Joseph, hemea bauaniaa ei Sanhedrin ma hia hemea rawani'a rama'a ma fei maumauna na wanewane, ");
INSERT INTO wuv_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","mei lomi na ugainaa fei naranara ma bigi'aa ro'ou. Hia hemea Judea noramiana Arimathea ma ifi oma'oma'aiaa fei haparaiaa mei Haidaa, fei ba i nomai. ");
INSERT INTO wuv_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Ina dinaa a'a Pilate ma i'iginaa fei hudi unuu Jesus. ");
INSERT INTO wuv_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Ma na porofa'u'upuia, hawainia a'a hefaa lawalawa linen ma fahainopia laloo huapu, fei waduaa ro'ou wagii ei na'a, fei atawe pa'i ma'ea na hainopia. ");
INSERT INTO wuv_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Feni, Arewaa Pagipagia ma fei Sabbath anaa i nomai. ");
INSERT INTO wuv_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Ei pifine, ei ro nofipuimai a'a Jesus i Galilee, rona neneraa Joseph ma fanunuaa fei huapu ma batanai hainopaa fei hudi ununa. ");
INSERT INTO wuv_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Rona dinaa gufu ma pagiaa ei manumanu dufaa. Ma'uaa rona gutafawenai a'a fei Sabbath ba ro'aa neneraa fei law. ");
INSERT INTO wuv_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","A'a fei rawarawa arewaa fei hefapagipagia, ale'ena mafufuo badu, ei pifine rona notonaa ei pagiaa ro'ou manumanu dufaa ma dinaa a'a fei huapu. ");
INSERT INTO wuv_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Rona fanunupa'ia ba fei baua mugoo gigei fei na'a, na pigudii a'a fei huapu, ");
INSERT INTO wuv_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","ma'uaa, ro'aa wadu'ai, lomi rona fanunupa'aa fei hudi unuu mei Fasu, Jesus. ");
INSERT INTO wuv_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Ro'ei naranara wagina ma helaguei wawane, lawalawaa lagua namina we'a ale'ei usida, laguna u papaa ro'ou. ");
INSERT INTO wuv_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Uaa fei ma'auaa ro'ou, ei pifine, rona fapasi'o'o'uinaa pu, ma'uaa laguei wawane, laguna warenaa a'a ro'ou, “Tani hamu'ou lalabarainaa mei fi gutaguta dupuaa ei ma'ea? ");
INSERT INTO wuv_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Hia lomi yeni. Na asi'adii! Hamonei nonominaa ei warefanana hamu'ou ei i oafipui a'a hamu'ou i Galilee: ");
INSERT INTO wuv_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","‘Mei Na'uu Rama'a ro'aa fifaninia panii ei hafelo'a ba ronei fatawaia ma a'a fei fa'oduaiaa arewaa i asi'adiai.’” ");
INSERT INTO wuv_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Ma ronawe nonominaa ei wareana. ");
INSERT INTO wuv_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Ro'aa nodigimai a'a fei huapu, rona u'ugaa minaa e'ei a'a ei Hefua ma Hemea mawe hefi'adiai. ");
INSERT INTO wuv_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Mary Magdalene, Joanna, Mary mei inaa James mawe hefi'a a'a ro'ou, rona u'ugaa e'ei a'a ei apostle. ");
INSERT INTO wuv_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Ma'uaa rona nara ba abaa fa'ua fei u'ugaa ei pifine, uaa ei wareaa ro'ou ale'ei mau wareaa poapoa. ");
INSERT INTO wuv_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Ma'uaa Peter na asi'aponinaa a'a fei huapu. Ina fabalou ma fanunupa'aa ei mininii linen na ude u'ugai ma na aunulao ma naranara ba tani ipo'o biyei. ");
INSERT INTO wuv_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Ana a'a fei arewaa fei, helagui ro'ou, laguna dinaa a'a fei gufu, harana Emmaus ale'ei hefua ma heai kilometre, rauana a'a Jerusalem. ");
INSERT INTO wuv_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Lagu'ei fiwarewareinaa minaa ei manumanu na nodigimai. ");
INSERT INTO wuv_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Lagu'aa fiwarewareinaa ei manumanu ei, Jesus na nomai ma talaihugiaa lagua; ");
INSERT INTO wuv_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Ma'uaa lomi na fa'arewa ba lagu'aa fanunu'apa'ia. ");
INSERT INTO wuv_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Ina i'iginaa lagua, “Tamanu ei talaifiwarewareiaa hamugua?” Laguna u'o'o'uinaa pu. ");
INSERT INTO wuv_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Hemea lagua, harana Cleopas na i'iginia, “Yoi hemea tatalaia ua i Jerusalem ma lomi ona aida ei manumanu na nodigimai a'a eni arewaa eni?” ");
INSERT INTO wuv_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Ina i'igai, “Manumanu bata?” Laguna ware, “Ei na nomai a'a Jesus mei Nazareth. Hia hemea mamama'a. Na faufau ei wareana ma bigi'ana i pudaa mei Haidaa ma minaa ei rama'a. ");
INSERT INTO wuv_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Ei famamoaa humuu mei Haidaa ma ei bauaniaa hai'ou, rona fifaninia panii hefi'a ba ronei fo'afama'eia ma rona fatawaia; ");
INSERT INTO wuv_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","ma'uaa, na o'onai unuu hai'ou ba hia mei ba i ponohadiwe'inaa Israel. Ma hepalodiai, wagieni, fa'oduaiaa arewaa ei i nomai ei manumanu ei. ");
INSERT INTO wuv_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Ma hepalodiai, hefi'a pifinee hai'odu, rona famaduofoaa hai'odu. Rona dinaa a'a fei huapu mafufuo badu wagieni ");
INSERT INTO wuv_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","ma'uaa lomi rona fanunupa'aa fei hudi ununa. Rona nomai ma warefanaa hai'ou ba rona fanunupa'aa laguei ale'ei alo'alo, laguna ware ba ina mama'a. ");
INSERT INTO wuv_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Ma hefi'a tafii haigua, rona dinaa a'a fei huapu ma fanunuia ana ale'ei ei wareaa ei pifine. Ma'uaa lomi rona ma'apa'ia. ");
INSERT INTO wuv_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Ma ina warenaa a'a lagua, “Hamunapa'aa poapoai ma na polai tabaa hamugua ma lomi hamuna nara ba fa'ua minaa ei ronadii wareia ei mamama'a! ");
INSERT INTO wuv_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Haa, lomi ba mei Christ neido'o tonaa fi'ina wagii ei manumanu ei ma nene i tonaa fei hawerana?” ");
INSERT INTO wuv_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Ma ina ware itailalafuifanaa lagua minaa ei u'ugaa fei Bu'u Apuna, fei na u'ugia i a'a fei ne'iaa Moses ama'anaa ei ne'iaa minaa ei mamama'a. ");
INSERT INTO wuv_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Ro nofarafi'inaa fei gufu ba ro'aa dinaa wagina, Jesus ba i talaidilao. ");
INSERT INTO wuv_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Ma'uaa laguna warefawe'i a'ana, “Gutafipui a'a haigua, uaa anaa i roro; fei arewaa anaa i pedu.” Si'ei, ina wadu'ai ba i gutafipui a'a lagua. ");
INSERT INTO wuv_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Ro'aa guta wagii fei tawa, ina tonaa fei faraa pidaua, ware ‘ta’, itafia ma fanaa lagua. ");
INSERT INTO wuv_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Ma ei pudaa lagua, nawe arewa ma lagunawe fanunu'apa'ia ma ina fa'apa'ai pudaa lagua. ");
INSERT INTO wuv_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Ma laguna fi'i'igai, “Haa, lomi bibiyeiaa naranaraa agua ei i fiwarewarei a'a agua i tala ma fa'arewainaa fei Bu'u Apuna a'a agua?” ");
INSERT INTO wuv_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Laguna asi'aa ma hadiwe'ibatafanaa Jerusalem. Ma yei, laguna bapa'aa ei Hefua ma Hemea mawe hefi'adiai a'a ro'ou, rona oafipui ");
INSERT INTO wuv_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","ma laguna ware, “Pa'aa fa'ua! Mei Fasu na asi'aa ma fa'arewa a'a Simon.” ");
INSERT INTO wuv_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Ma laguna u'ufanaa ro'ou tamanu na nomai a'a lagua i tala ma batanai lagua fanunu'apa'aa Jesus ei fi itafaa fei faraa pidaua. ");
INSERT INTO wuv_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Roi fiwarewareinaa fei, Jesus na fa'arewa dupuaa ro'ou ma warenaa a'a ro'ou, “Me'o, gutafarawani ua.” ");
INSERT INTO wuv_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Rona ba'arofo ma ma'au. Ei naraa ro'ou ba rona fanunupa'i hani'u. ");
INSERT INTO wuv_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Ina warenaa a'a ro'ou, “Tani hamo'aa naranara watauda ma hamamagua? ");
INSERT INTO wuv_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Fanunuamii paniu ma pineu. Ana yau ua! Panarofau ma fanunu; hani'u lomi pigiona ma guina, ale'ei hamona fanunupa'ia ba yau una pa'i.” ");
INSERT INTO wuv_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","I waredigaa fei, na fama'aa ro'ou guei panina ma pinena. ");
INSERT INTO wuv_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Ma'uaa lomi rona nara ba fa'ua uaa rona ni'eni'e fininaa nanawala pudaa ro'ou ma ina i'iginaa ro'ou, “Hamona pa'i du'ua yeni ba a hanana?” ");
INSERT INTO wuv_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Rona fania hepalo unumaa ro'ou nia ");
INSERT INTO wuv_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","ma ina tonia ma hanaia i pudaa ro'ou. ");
INSERT INTO wuv_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Ina warenaa a'a ro'ou, “Sifeni, feni adii warefanaa hamu'ou ei ado'o guta a'a hamu'ou: Minaa ei ne'ia na u'ugau a'a fei Law Moses, ei Mamama'a mawe fei Bu'uu Lauga, roneipa'aa nomai.” ");
INSERT INTO wuv_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Ma inawe fa'arewainaa tabaa ro'ou ba ronei apa'ifarawaninaa fei Bu'u Apuna. ");
INSERT INTO wuv_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Ina warefanaa ro'ou, “Sifeni feni ne'ia: Mei Christ nei tonaa fi'ina ma asi'aa wagii fei ma'ea a'a fei fa'oduaiaa arewaa ");
INSERT INTO wuv_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","ma wagii fei harana, do'o fama'a i Jerusalem, rowe u'ufanaa minaa ei gufu ba ei rama'a, ronei filoginaa naranaraa ro'odu ma iwe futoaa ei hafelo'aa ro'ou. ");
INSERT INTO wuv_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Hamona fanunudigaa ei manumanu ei. ");
INSERT INTO wuv_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Yau, a alofanamiaa hamu'ou fei fa'unaiaa mei Amau; ma'uaa hamoneido'o guta a'a feni gufu feni hawina hamona tonaa fei faufau noranarai pafea.” ");
INSERT INTO wuv_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","I noduginaa ro'ou malalaa Bethany, na roainaa panina ma haweginaa ro'ou. ");
INSERT INTO wuv_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Ei fi haweginaa ro'ou, na duginaa hia pafea mei Haidaa. ");
INSERT INTO wuv_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Ma rona losuinia ma hadiwe'inaa Jerusalem fininaa ni'eni'ea. ");
INSERT INTO wuv_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Ma ronamina gutalao a'a fei humuu mei Haidaa ma uduginaa mei Haidaa. ");
INSERT INTO wuv_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Pa'aa rawarawa na ude fei Warea ma fei Warea na oafipui a'a mei Haidaa. Ma fei Warea, ana mei Haidaa. ");
INSERT INTO wuv_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Ina oafipui a'a mei Haidaa fama'a. ");
INSERT INTO wuv_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","I a'ana minaa ei manumanu na mamaramai. Lomi hepalo manumanu na mamaramai ba abaa famamarana. ");
INSERT INTO wuv_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","I a'ana na pa'i harenua ma fei harenua fei, we'ai rama'a. ");
INSERT INTO wuv_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Fei we'ai na we'a laloo fei roromaa, ma'uaa fei roromaa lomi na apa'ia. ");
INSERT INTO wuv_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Ina nomai hemea rama'a, aloamiaa mei Haidaa; harana, John. ");
INSERT INTO wuv_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Fei pa'afina ba i nomai, sifei ba i u'ugaa fei we'ai ba minaa ei rama'a, ronei narafawe'i. ");
INSERT INTO wuv_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Ana hia, abaa fei we'ai; na no'uamai ba i u'ugaa fei we'ai. ");
INSERT INTO wuv_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Fei pa'aa we'ai, fei ba i we'ainaa minaa ei rama'a fi nomai yeni malagufu. ");
INSERT INTO wuv_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Ina guta i malagufu ma ana hia na famamaraiaa feni malagufu ma'uaa, feni malagufu, lomi na fanunu'apa'ia. ");
INSERT INTO wuv_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Ina dinamii a'a ei gufuna ma'uaa, lomi rona taufagutania. ");
INSERT INTO wuv_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Ma'uaa minaa ei rona taufagutania, ei rona narafawe'i a'a fei harana, ina uga ba ro'ou, na'uu mei Haidaa— ");
INSERT INTO wuv_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","ma'uaa abaa na'u ale'ei pai rama'a, o nunumiaa helagui fiharoi, uaa waniniaa mei Haidaa. ");
INSERT INTO wuv_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Fei Warea nawe pigioa ma na pagi gutanana i dupuaa o'ou. Ona ma'adigaa fei hawerana, fei haweraa mei Hemea Ua, mei noramiana a'a mei Ama, nofininamii fei rawani'a ma fei fa'uaia. ");
INSERT INTO wuv_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","John fi u'ugia. Ina haroharo ma ware, “Simeni, meni unadii u'ugia ba, ‘Mei i nomai neneu na muainau, uaa hia, rawarawaa haigua.’” ");
INSERT INTO wuv_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","A'a fei baua rawani'ana, minaa o'ou na todigaa watauda hawegia. ");
INSERT INTO wuv_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Uaa, ina fanamiaa Moses fei law. Fei rawani'a ma fei fa'uaia noranamai a'a Jesus Christ. ");
INSERT INTO wuv_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Lomi hemea na fanunupa'aa mei Haidaa ma'uaa, mei Na'uu mei Haidaa, mei Hemea Ua, mei na oafipui a'a mei Ama, hia na fama'aia. ");
INSERT INTO wuv_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Ei Jew, rona aloaa ei bauaniaa humuu mei Haidaa ma ei Levi ba ronei i'iginaa John ba hia hini. Sifeni, feni u'ugana a'a ro'ou yei Jerusalem. ");
INSERT INTO wuv_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Lomi na ufamadumu ua, ma'uaa namina u'u ua ba, “Yau, abaa Christ.” ");
INSERT INTO wuv_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Rona i'iginia, “Haa, ma yoi hini? Yoi Elijah?” Ina ware, “Abaa yau.” “Yoi mei Mamama'a?” Ina ware, “Lomi.” ");
INSERT INTO wuv_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Ronawe ware, “Yoi hini? Onei warefanaa hai'ou ma hai'ou'aree warefanaa ei rona aloamii hai'ou. O ware ba yoi hini ma rama'a bata?” ");
INSERT INTO wuv_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","John na wareaa ei wareaa Isaiah, mei mamama'a, “Yau fei lao na haroharo fawelei lomi haihai o guana, ‘Ra'a'augaa fei talaa mei Fasu.’” ");
INSERT INTO wuv_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Ma hefi'a ei aloamii ro'ou, Pharisee, ");
INSERT INTO wuv_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","rona i'iginia, “Nabaa fa'ua, hamatani o pudugufinaa ei rama'a nabaa yoi abaa mei Christ, o Elijah, o mei Mamama'a?” ");
INSERT INTO wuv_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","John na ware, “Una pudugufinaa rama'a ranu ma'uaa hemea na u dupuaa hamu'ou, hemea lomi hamona apa'ia. ");
INSERT INTO wuv_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Hia mena i nomai neneu, mena lomi na rawani ba a alaraa fei supinena.” ");
INSERT INTO wuv_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Ei manumanu ei, rona bigi'ia yei Bethany pepei adii fei Ranu Jordan, fawelei fi pudugufai wagina John. ");
INSERT INTO wuv_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","I no'arewadilao, John na fanunupa'aa Jesus fi nomai a'ana ma na ware, “Ma'alao, fei Na'uu Sipsipii mei Haidaa, fei na tonaa ei hafelo'aa feni malagufu! ");
INSERT INTO wuv_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Simeni, meni una u'ugia ba, ‘Mei i nomai neneu, na muainau, uaa hia rawarawaa haigua.’ ");
INSERT INTO wuv_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Yau ana lomi na apa'ia, ma'uaa ena a nomai ma pudugufinaa rama'a ranu, sifei ba inei arewa a'a ei Israel.” ");
INSERT INTO wuv_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","John na u'u ba, “Una fanunupa'aa fei Spiriti na falorogio pafea. Fei maumauna ale'ei pune ma na faloro pafona. ");
INSERT INTO wuv_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Lomi ba a apa'ia ma'uaa, mei na aloau ba nei pudugufinaa rama'a ranu, na warefanau ba, ‘Mei ona fanunupa'ia ba na faloronaa pafona fei Spiriti, simena, mena i pudugufinaa rama'a Spiriti Apuna.’ ");
INSERT INTO wuv_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Una fanunudigia ma u'ufanaa hamu'ou ba hia, Na'uu mei Haidaa.” ");
INSERT INTO wuv_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","I no'arewadilao, John na gutadiai a'a helagui otalai nenerana. ");
INSERT INTO wuv_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","I fanunupa'aa Jesus fi talailao, ina ware, “Ma'alao, fei Na'uu Sipsipii mei Haidaa!” ");
INSERT INTO wuv_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Lagu'aa guainaa fei wareana fei laguei otalai nenerana, laguna neneraa Jesus. ");
INSERT INTO wuv_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Jesus na diarai, ma'apa'aa lagua ma na i'iginaa lagua, “Tamanu nunumiaa hamugua?” Laguna ware, “Rabbi” (hanuna ba Feroia), “Ona ma'igu hitani?” ");
INSERT INTO wuv_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Ina ware, “Nomai ma hamuwe aida.” Si'ei, lagunaree ma'a fei nopana ma laguna gutafipui a'ana fei arewaa fei. Fei au fei, obao ido'o fafi. ");
INSERT INTO wuv_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Andrew, mei lofuu Simon Peter, hia hemea laguei na guainaa ei wareaa John ma na neneraa Jesus. ");
INSERT INTO wuv_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Fei rawarawa bigi'aa Andrew, sifei ba nado'o labaginaa mei lofuna Simon ma warefania, “Hai'ouna bapa'aa mei Messiah” (hanuna ba mei Christ). ");
INSERT INTO wuv_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Ma ina duginaa hia a'a Jesus. Jesus na fanununaa a'ana ma ware, “Yoi Simon, mei na'uu John. Rowe roroinio Cephas” (hanuu fei ba Peter). ");
INSERT INTO wuv_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","I no'arewadilao, Jesus na nara ba i dinaa Galilee. I bapa'aa Philip, na warenaa a'ana, “Nenerau.” ");
INSERT INTO wuv_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Philip, ana ale'ei Andrew ma Peter; gufuna Bethsaida. ");
INSERT INTO wuv_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Philip na bapa'aa Nathanael ma na warefania, “Hai'ouna bapa'aa mei na ne'inia Moses a'a fei Law, mei ana rona ne'inia ei mamama'a—Jesus, mei Nazareth, mei na'uu Joseph.” ");
INSERT INTO wuv_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Nathanael na i'igai, “Nazareth! Ana i pa'i hepalo rawani'a manumanu i norai yei?” Philip na ware, “Mi ma'aia.” ");
INSERT INTO wuv_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","I fanunupa'aa Nathanael fi nomai, Jesus na wareia, “Simeni, hemea pa'aa Israel, lomi hepalo sifi'a a'ana.” ");
INSERT INTO wuv_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Nathanael na i'igai, “Tani o apa'au?” Jesus na ware, “Una ma'apa'io oifi guta haroo fei haihai figi ma nenee fei, na harofio Philip.” ");
INSERT INTO wuv_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Nawe ware Nathanael ba, “Rabbi, yoi Na'uu mei Haidaa; yoi mei Haparaa Israel.” ");
INSERT INTO wuv_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Jesus na ware, “Ona nara ale'ei uaa una warefanio ba na ma'apa'io oifi guta haroo fei haihai figi. Owe fanunuaa hefi'adiai manumanu i muainaa fei.” ");
INSERT INTO wuv_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Ma na waredilao, “A warefa'uai a'amu ba owe fanunuaa fei gigei pafea iwe gigi ma ei alo'aloo mei Haidaa, roifi nogio a'a mei Na'uu Rama'a ma hadiwe'idinaa pafea, minaa ale'ei bigi'aa ro'ou.” ");
INSERT INTO wuv_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Laloo fei fa'oduaiaa arewaa na pa'i hepalo lalaia yei Cana i Galilee. Ma mei inaa Jesus, hia yei. ");
INSERT INTO wuv_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Ma rona lala'aa Jesus mawe ei otalai nenerana ba nei nomai a'a fei lalaia. ");
INSERT INTO wuv_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","I beu ei wine, mei inaa Jesus na warefania, “Nawe beu ei numaa ro'ou wine.” ");
INSERT INTO wuv_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Jesus na ware, “Mena rawani'a pifine, tani o fihupu'inau a'a feni? Atawe nomai fei auu.” ");
INSERT INTO wuv_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Mei inana na warenaa a'a ei nafi, “Bigi'aa tamanu i wareia a'a hamu'ou.” ");
INSERT INTO wuv_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Na ude farafi'i oloroa pe'ii ranu, bigi'aa ro'ou mugoo. Ma wagii fei mau losuia ro'ou, rona'o fesufesu a'a e'ei ei Jew. Hepapalo pe'i na hawia ale'ei watolaa fainaroa pa'ania ama'anaa hefa pu'u ma enu pa'ania litre. ");
INSERT INTO wuv_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Jesus na warefanaa ei nafi, “Igi ranu laloo ei pe'ii ranu”; si'ei, rona igifamereaa ro'ou. ");
INSERT INTO wuv_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Ma na warenaa a'a ro'ou, “Nadii, gufi ma'ida ma re fanaa mei bauaniaa feni hananaa.” Rona bigi'ia ");
INSERT INTO wuv_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","ma mei bauaniaa fei hananaa na hunuma'aiaa fei ranu, fei na filoginaa wine. Lomi ina aida ba noramiana hitani ma'uaa, ei nafi, ei ro'aa gufinamai, rona aida. Ma ina haro'u'ugainaa mei wawanee lalaia ");
INSERT INTO wuv_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","ma ware, “Ei rama'a, rona'aida augaa ei rawani'a wine fama'a ma ro'aa hunudigaa watauda ei, ronawe augaa ei lomi namina rawani; ma'uaa, yoi onadii auma'aiaa ei rawani'a.” ");
INSERT INTO wuv_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Hefei, fei rawarawa hilalaa foigia bigi'aa Jesus yei Cana i Galilee. A'a fei, ina fama'aiaa fei hawerana ma ei otalai nenerana na narafawe'i a'ana. ");
INSERT INTO wuv_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Nenee fei, ina upunaloo Capernaum fipuinaa mei inana ma ei lofuna mawe ei otalai nenerana. Ma rona guta yei hefi'a arewaa. ");
INSERT INTO wuv_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Ei ana i pa'aa fei au fei Talai Falogiaa ei Jew, Jesus na fanenaloo Jerusalem. ");
INSERT INTO wuv_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","I malalaa fei humuu mei Haidaa na ma'apa'aa ei rama'a roi aloaa ei buduma'ao, sipsipi mawe ei pune ma hefi'a, rona guta a'a ei tawa, roi filoginaa ei mugoo po'i. ");
INSERT INTO wuv_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Si'ei, na fifigaa ei wao ba babu ma na teteaa minaa ro'ou fipuinaa ei sipsipi ma buduma'ao ba ronei di'ininaa malalaa fei humuu mei Haidaa. Ina bailarofinaa ei mugoo po'i, ei rona filoginia ma hadupeduaa ei tawaa ro'ou. ");
INSERT INTO wuv_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","A'a ei roi alo pune, ina ware, “Tofa'asi'anaa ano e'eni! Tani hamo'aa filoginaa humuu mei Amau ba humuu alo'aloo manumanu?” ");
INSERT INTO wuv_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Ei otalai nenerana, rona nonominaa fei ne'ia ba: “Namina fua'onau fei ni'eni'eau a'a fei humumu.” ");
INSERT INTO wuv_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","I dii, ei Jew rona ware, “O bigi'aa tamanu hilalaa foigia i pudaa hai'ou ale'ei fama'ama'aa hai'ou ba na pa'i foraforamu ba o bigi'aa e'ei?” ");
INSERT INTO wuv_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Jesus na warenaa a'a ro'ou, “Birosiaa feni humuu mei Haidaa ma awe fa'ufalaraidinia laloo oduai arewaa.” ");
INSERT INTO wuv_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Ei Jew, rona ware, “Feni humuu mei Haidaa feni, faduaa ro'ou laloo gunaroa pa'ania ma oloroa igisimasi. Ma yoi, ba o fadudinia laloo oduai arewaa?” ");
INSERT INTO wuv_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Ma'uaa fei humuu mei Haidaa, fei hia fi warewareia, ana fei hudi ununa. ");
INSERT INTO wuv_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Nenee fei asi'anana a'a ei ma'ea, ei otalai nenerana na nonominaa tamanu inadii wareia. Ma ronawe aida ba pa'aa fa'ua ei wareaa fei Bu'u Apuna ma Jesus. ");
INSERT INTO wuv_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Ifi guta yei Jerusalem a'a fei Hananaa fei Talai Falogia, watauda na fanunuaa ei hilalaa foigia na bigi'ia ma narafawe'i a'a fei harana. ");
INSERT INTO wuv_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Ma'uaa Jesus, lomi ba i fa'arewafarawani a'a ro'ou, uaa ina apa'aa minaa ei rama'a. ");
INSERT INTO wuv_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Lomi na nunuminia ba hemea i u'ugaa hemeadiai, uaa na aida ei naranaraa rama'a. ");
INSERT INTO wuv_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Na pa'i hemea Pharisee harana Nicodemus, hemea maroaa ei bauaniaa ei Jew. ");
INSERT INTO wuv_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Ina nomai a'a Jesus hefaa poi ma ware, “Rabbi, hai'ouna aida ba yoi hemea feroia, noramiamu a'a mei Haidaa. Uaa, lomi nemea i bigi'aa e'ei hilalaa foigia, e'ei oi bigi'ia nabaa mei Haidaa lomi a'ana.” ");
INSERT INTO wuv_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Jesus na warenaa a'ana, “A warefa'uai a'amu ba lomi nemea i ma'a fei haparaiaa mei Haidaa nabaa lomi i waninidiai. ");
INSERT INTO wuv_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Nicodemus na i'igai, “Batanai ba i waninidiai nemea nabaa na wawaneidii? Pa'aa lomi ba i hadiwe'idinaa laloo iaa inana ba i waninidiai!” ");
INSERT INTO wuv_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Jesus na ware, “A warefa'uai a'amu, lomi nemea ba i wadu'ainaa fei haparaiaa mei Haidaa nabaa lomi i waninidiai a'a fei ranu ma fei Spiriti. ");
INSERT INTO wuv_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Waniniaa fei pigio, i nomai a'a fei pigio. Waniniaa fei spiriti, i nomai a'a fei Spiriti. ");
INSERT INTO wuv_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Apuna ba'arofoa a'a fei wareau ba, ‘Onei waninidiai.’ ");
INSERT INTO wuv_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Fei lalarena na aginaa fawelei nunumiana. Ona guainia ma'uaa, lomi ona aida ba noramiana hitani o i dinaia. Ana ale'ei a'a minaa ei rona wanini a'a fei Spiriti.” ");
INSERT INTO wuv_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Nicodemus na i'igai, “I batanai fei?” ");
INSERT INTO wuv_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Jesus na ware, “Haa, yoi hemea feroiaa Israel ma lomi ona aida ei manumanu ei? ");
INSERT INTO wuv_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","A warefa'uai a'amu, hai'ouna wareaa tamanu hai'ouna aida ma u'ugaa tamanu hai'ouna fanunuia ma'uaa, ana lomi hamona tonaa ei u'ugaa hai'ou. ");
INSERT INTO wuv_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Una u'ufanio ei manumanuu malagufu ma lomi ona nara ba fa'ua; batanai o nara ba fa'ua nabaa a u'ufanio ei manumanuu fei gufu pafea? ");
INSERT INTO wuv_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Lomi nemea na aunudiginaa pafea ma'uaa, ana unaiaa mei na norai gufu pafea—mei Na'uu Rama'a. ");
INSERT INTO wuv_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Ana ale'ei Moses na uduginaa fei wa'a a'a fei hawafolo fawelei lomi haihai o guana, mei Na'uu Rama'a, ana ronei uduginia pafea ");
INSERT INTO wuv_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","ba hini i narafawe'i a'ana i tonaa fei harenua lomi i pedutoo. ");
INSERT INTO wuv_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","“Uaa, hamatee mei Haidaa namina haguaa feni malagufu, ina aloagii mei hodihodiaa Na'una baduu wawane ba hini i narafawe'i a'ana, lomi i ma'e ma'uaa, iwe pa'i fei harenua lomi i pedutoo. ");
INSERT INTO wuv_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Uaa, fei pa'afina ba mei Haidaa na aloagii mei Na'una yeni malagufu, a'a ba inei dududuaa feni malagufu, ma'uaa ba nei fatela'anaa feni malagufu. ");
INSERT INTO wuv_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Hini i narafawe'i a'ana, lomi i tonaa fei dududuana, ma'uaa mei lomi na narafawe'i, na todigaa dududuana, uaa lomi ina narafawe'i a'a fei haraa mei hodihodiaa Na'uu mei Haidaa. ");
INSERT INTO wuv_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Sifeni, feni pa'aa warea: fei We'ai na nodigimai yeni malagufu ma'uaa, ei rama'a, rona nunuminaa fei roromaa laraa fei we'ai, uaa ei bigi'aa ro'ou na hafelo. ");
INSERT INTO wuv_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Hini i bigi'aa ei hafelo'a, na bidibidi ununa a'a fei we'ai ma lomi ba i wadu'ainaa fei we'ai, uaa ina ma'au ba ei bigi'ana iwe arewa. ");
INSERT INTO wuv_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Ma'uaa hini na bigifipui a'a fei fa'uaia, i wadu'ainaa fei we'ai ba i fa'arewaia ba ei bigi'ana, bigi'aa mei Haidaa.” ");
INSERT INTO wuv_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Nenee fei, Jesus mawe ei otalai nenerana, rona aununaa sugatata'aiaa Judea ma ina gutafipui a'a ro'ou yei ma pudugufinaa ei rama'a. ");
INSERT INTO wuv_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","John ana na pudugufinaa ei rama'a yei Aenon rafi'inaa Salim, uaa na pa'i watauda ranu ma ei rama'a, rona'u no'uamai a'ana ba nei pudugufinaa ro'ou. ");
INSERT INTO wuv_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","(Ei, rotawe bobo'ainaa John.) ");
INSERT INTO wuv_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Hefi'a ei otalai neneraa John, rona fiharenii a'a hemea Jew wagii fei maumau fesufesu wagii fei losuu ro'ou. ");
INSERT INTO wuv_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Rona nopa'amii John ma warenaa a'ana, “Rabbi, mei rama'a a'amu yei pepei adii fei Ranu Jordan—mei ona u'ugia—hia fi pudugufai ma minaa ei rama'a, roi dinaa a'ana.” ");
INSERT INTO wuv_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","A'a fei, John na ware, “Lomi hemea ba i tonaa hepalo manumanu nabaa abaa noranarai pafea. ");
INSERT INTO wuv_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Ana uniaa hamu'ou na aida ba una waredii ba, ‘Yau, abaa mei Christ, ma'uaa yau mei neido'o nomai ma'ana.’ ");
INSERT INTO wuv_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Mei pifinee lalaia, manumanuu mei wawane lalaia. Mei tafii mei wawanee lalaia, i gutaguai'oma'aia ma imina ni'eni'e na guainaa fei laona. Fei ni'eni'ea fei, manumanuu ma unawe todigia. ");
INSERT INTO wuv_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Fei harana nei nobauanailao ma fei harau nei pusu'oroilao. ");
INSERT INTO wuv_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","“Mei i norai pafea na pafeainaa minaa ei; mei noramiana malagufu, rama'aa malagufu ua ma ei wareana ale'ei ei wareaa feni malagufu. Mei noramiana pafea, na pafeainaa minaa ei. ");
INSERT INTO wuv_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","I u'ugaa ei fanunuana ma guaiana ma'uaa, lomi nemea i guaitonaa ei u'ugana. ");
INSERT INTO wuv_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Mei i guaitodigia na fama'aia ba mei Haidaa napa'aa fa'uai. ");
INSERT INTO wuv_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Uaa mei aloamii mei Haidaa, i wareaa ei wareaa mei Haidaa, uaa lomi pedupeduu fei fanaa mei Haidaa ei i fanaa fei Spiriti. ");
INSERT INTO wuv_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Mei Ama na haguaa mei Na'u ma na fifanidigaa minaa ei manumanu panina. ");
INSERT INTO wuv_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Hini i narafawe'i a'a mei Na'u, i pa'i harenua lomi i pedutoo, ma'uaa hini i fadugeaa mei Na'u, lomi ba i fanunuaa fei harenua, uaa fei sibaa mei Haidaa na oa a'ana.” ");
INSERT INTO wuv_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Ei Pharisee, rona guainia ba i fimina watauda ua ei otalai neneraa Jesus ma ei pudugufaiana laraa John, ");
INSERT INTO wuv_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","ma'uaa abaa Jesus mei na pudugufai, uaa ei otalai nenerana. ");
INSERT INTO wuv_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","I guainaa fei mei Fasu, na di'ininaa Judea ma hadiwe'idinaa Galilee. ");
INSERT INTO wuv_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Ma ina talai'ailao Samaria. ");
INSERT INTO wuv_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Si'ei, ina wadu'ainaa hepalo gufu laloo Samaria, harana Sychar na rafi'inaa fei malagufuu Jacob, fei na fanaa mei na'una Joseph. ");
INSERT INTO wuv_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Fei agifaa Jacob ranu yei ma na madugu unuu Jesus uaa fei tatalaiana, si'ei, na guta adii fei ranu. Ei, ale'ei haloaina. ");
INSERT INTO wuv_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","I nomai hemea pifinee Samaria ba i bai ranu, Jesus na warenaa a'ana, “Na rawani ba odo'o fani numau?” ");
INSERT INTO wuv_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","(Ei otalai nenerana, rona aunudiginaa a'a fei gufu ba ro pono du'ua.) ");
INSERT INTO wuv_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Mei pifinee Samaria na warefania, “Yoi Jew ma yau Samaria. Tani o i'iginau ba nei fani numamu?” (Uaa ei Jew, lomi rona'o fiwarewarei a'a ei Samaria.) ");
INSERT INTO wuv_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Jesus na warenaa a'ana, “Nabaa ona aida fei fanaa mei Haidaa ma hini fi i'iginio ba fani numana, woro o i'iginia ma i fanio fei ranuu loloma.” ");
INSERT INTO wuv_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Mei pifine na ware, “Hagu'u. Lomi ona pa'i iba ma fei ranu na walalo. O to hitani fei ranuu loloma? ");
INSERT INTO wuv_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Haa, ona muainaa mei Amaa o'ou Jacob, mei na fanaa o'ou feni agifana ranu, mei ana hia ma ei na'una mawe ei hapena manulelele, rona hunu wagina?” ");
INSERT INTO wuv_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Jesus na ware, “Hini i hunumaa feni ranu feni, iwe sigigidiai ");
INSERT INTO wuv_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","ma'uaa hini i hunumaa fei ranu fanau, lomi ifai sigigidiai. Hi'i, fei ranu a fania iwe ale'ei ranuu wediwedi fei i fani harenua lomi i pedutoo.” ");
INSERT INTO wuv_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Mei pifine na warefania, “Mena bauana, fanau fei ranu fei lomi a fai sigigi ba a u hadiwe'idimai mi bai ranu.” ");
INSERT INTO wuv_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Ina warefania, “Wi dugamii mei haromu ma hadiwe'imai.” ");
INSERT INTO wuv_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Ina ware, “Lomi harou.” Jesus na warenaa a'ana, “Pa'aa fa'ua wareamu ba lomi haromu. ");
INSERT INTO wuv_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Ma'uaa, ana pa'aa fa'ua ba onado'o pa'i haipani haromu ma mei wawane a'amu e'eni, abaa haromu. Pa'aa fa'ua fei do'o wareamu.” ");
INSERT INTO wuv_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Mei pifine na ware, “Mena bauana, una fanunu'apa'ia ba yoi hemea mamama'a. ");
INSERT INTO wuv_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Ei amaa hai'ou, rona losui pafoo feni maugeni, ma'uaa hamu'ou Jew na ware ba o'ounei losui yei Jerusalem.” ");
INSERT INTO wuv_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Jesus na ware, “Mena pifine, onei guainau. Fi nomai fei au ba lomi o losuinaa mei Ama i pafoo feni maugeni, o yei Jerusalem. ");
INSERT INTO wuv_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Hamu'ou ena Samaria na losuinaa tamanu lomi hamona aida; hai'ouna losuinaa tamanu hai'ouna aida, uaa fei talaa tela'ana, noramiana a'a ei Jew. ");
INSERT INTO wuv_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Ma'uaa fi nomai ma na nodigimai fei au ba ei pa'aa losuia, rowe losuinaa mei Ama wagii fei spiriti ma fei fa'uaia, uaa mei Ama na nunuminaa ei mau losuia ale'ei. ");
INSERT INTO wuv_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Mei Haidaa, hia spiriti ma ei ba ro'aa losuinia, ronei losuinia wagii fei spiriti ma fei fa'uaia.” ");
INSERT INTO wuv_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Mei pifine na ware, “Una aida ba mei Messiah” (mei rona ware ba Christ) “fi nomai ma ena na nomai, iwe warefa'arewaiaa minaa ei manumanu a'a o'ou.” ");
INSERT INTO wuv_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Jesus na ware, “Yau, meni u'ei wareware a'amu, ana simena.” ");
INSERT INTO wuv_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Ana ei ua, ei otalai nenerana, rona hadiwe'imai ma ba'arofo ba na fiwarewarei a'a hemea pifine. Ma'uaa lomi hemea na i'iginia ba, “Tamanu nunumiamu?”, o “Tani o fiwarewarei a'a mei pifine mei.” ");
INSERT INTO wuv_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","I dii, mei pifine mei, na au'uaiaa fei ibaa ranu, hadiwe'inaa gufuna ma warefanaa ei rama'a, ");
INSERT INTO wuv_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","“Mi ma'a mei na u'ufanau minaa ei una bigi'ia. Woro simei, mei Christ?” ");
INSERT INTO wuv_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Rona asi'aa a'a fei gufu ma talainaloo a'ana. ");
INSERT INTO wuv_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Ma ei, ei otalai nenerana, roi warenaa a'ana ba, “Rabbi, onei hanana.” ");
INSERT INTO wuv_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Ma'uaa ina warenaa a'a ro'ou, “Na pa'idii du'ua ba a hanaia, fei lomi hamona aida.” ");
INSERT INTO wuv_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Ma ei otalai nenerana na fiwarewarei ba, “Haa, na pa'i rama'a naree fani hanana?” ");
INSERT INTO wuv_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Na ware Jesus, “Fei hanau, sifei ba unei bigi'aa ei nunumiaa mei na aloagiau ma fapedugaa fei bigi'ana. ");
INSERT INTO wuv_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Haa, lomi hamona'o ware ba, ‘Obaodiai puda ma i nomai fei au hufu'a’? A ware ba hamonei werainaa pudaa hamu'ou ma ma'aiaa ei pe'ihape! Ina we'idii ei du'ua ba o hufu'ia. ");
INSERT INTO wuv_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Ana e'eni ua mei hufu'a fi tonaa fei pono'ana. Ana e'eni ua ifi hufu'aa ei fuaa fei harenua lomi i pedutoo ba mei faroa ma mei hufu'a, lagunei ni'eni'efipui. ");
INSERT INTO wuv_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Ma si'ei, fei warea ba ‘Hemea i faro ma hemea i hufu’, napa'aa fa'uai. ");
INSERT INTO wuv_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Una aloaa hamu'ou ba hamonei hufu'aa tamanu lomi hamona bigi wagina. Hefi'adiai, rona bigifawe'i ma hamonaree to'uaiaa ei rawani'a wagii ei bigi'aa ro'ou.” ");
INSERT INTO wuv_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Watauda Samaria a'a fei gufu fei, rona narafawe'i a'ana uaa na u'u mei pifine ba, “Ina u'ufanau minaa ei bigi'au.” ");
INSERT INTO wuv_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Si'ei, ro'aa nomai a'ana ei Samaria ma i'iginia ba nei gutafipui a'a ro'ou, ina guta heguai arewaa. ");
INSERT INTO wuv_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Ma si'ei ba ei wareana, wataudadiai nawe narafawe'i. ");
INSERT INTO wuv_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Rona warenaa a'a mei pifine ba, “Abaa wagii ei u'uga'uamu ba hai'ouna narafawe'i. Ma'uaa hai'ounawe guai'araia ma hai'ounawe aida ba pa'aa fa'ua ba meni rama'a meni, pa'aa mei ba i fatela'anaa feni malagufu.” ");
INSERT INTO wuv_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Nenee guai arewaa ina asi'aa ba i dinaa Galilee. ");
INSERT INTO wuv_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","(Ana Jesus nadii wareia ba hemea mamama'a, lomi ro'aa ma'auia ei gufuna.) ");
INSERT INTO wuv_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","I no'umai i Galilee, ei rama'a yei, rona taufagutania. Rona ma'adigaa minaa ei bigi'ana yei Jerusalem a'a fei Hananaa fei Talai Falogia uaa ro'ou, ana yei. ");
INSERT INTO wuv_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","I didiai, na hadiwe'inaa Cana i Galilee, fei gufu ina filoginaa wine fei ranu. Ma na pa'i hemea bauana yei ma mei na'una na funuhaino i Capernaum. ");
INSERT INTO wuv_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","I guainia mei rama'a mei ba Jesus na gutadii Galilee, noramiana Judea, ina dinaa a'ana ma i'igifawe'i a'ana ba neimii fapedugaa funuaa na'una, mei anaa i ma'e. ");
INSERT INTO wuv_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Jesus na warenaa a'ana, “Nabaa lomi hamona fanunuaa hefi'a hilalaa foigia ma fananawalaa puda, pa'aa lomi hamo'aa narafawe'i.” ");
INSERT INTO wuv_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Mei bauana na ware, “Hagu'u. Upumai ba nei'aa ma'e mei na'uu.” ");
INSERT INTO wuv_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Jesus na ware, “Nowau. Lomi ba i ma'e mei na'umu.” Mei rama'a na nara ba fa'ua ei wareaa Jesus ma na asi'aa. ");
INSERT INTO wuv_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Ei fi talailao, ei nafina, ronamii bapa'ia ma u'ufania ba na rawanidii mei na'una. ");
INSERT INTO wuv_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","I i'igai ba rawani'ana haiga mei na'una, rona warefania, “Na asisi babaiaa ununa minoa ale'ei heai ido'o.” ");
INSERT INTO wuv_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","A'a fei, mei ama nawe narapa'ia ba sifei fei pa'aa au Jesus na warefania ba, “Mei na'umu, lomi ba i ma'e.” Si'ei, hia ma minaa ei maroana, rona narafawe'i. ");
INSERT INTO wuv_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Sifei fei faguaiaa hilalaa foigia bigi'aa Jesus ei i di'ininaa Judea ma ama'anaa Galilee. ");
INSERT INTO wuv_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Nenee e'ei, Jesus na fanedinaa Jerusalem ba i dinaa hepalo hananaa ei Jew. ");
INSERT INTO wuv_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Ma yei Jerusalem papaa fei Gigei ei Sipsipi, na pa'i hepalo ranu, harana warea Aramea, Bethesdaa ma na pa'i haipani pale yei. ");
INSERT INTO wuv_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Watauda hafelo'a unu na haino yei—ei pudawerai, ei afetoo mawe ei na ma'e hepapa unuu ro'ou. ");
INSERT INTO wuv_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Hemea yei, lomi na tatalai laloo odufua pa'ania ma fainaroa igisimasi. ");
INSERT INTO wuv_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","I fanunuia Jesus ba na haino yei ma guainia ba fei gutanana ale'ei namina madii, ina i'iginia, “Nunumiamu ba o rawani?” ");
INSERT INTO wuv_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Mei lomi na talaipa'i na ware, “Mena bauana, lomi hemea ba i pudigau laloo fei ranu nabaa i tatawei. Nabaa a upunaa lalona, na upudii hemea.” ");
INSERT INTO wuv_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Ma Jesus na warenaa a'ana, “Asi'aa! Tonaa fei hafenaa unumu ma talai.” ");
INSERT INTO wuv_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Ana ei ua, ina rawani ma na tonaa fei hafenaa ununa ma talai. Fei arewaa i bigi'aa fei, Sabbath ");
INSERT INTO wuv_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","ma si'ei, ei Jew, rona warenaa a'a mei na pedu fei iba'ibana ba, “Sabbath wagieni; fei law na ware ba onei'aa poro'aa hafenaa unumu.” ");
INSERT INTO wuv_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Ma'uaa ina ware, “Mei i farawaninau na ware ba, ‘Tonaa fei hafenaa unumu ma talai.’” ");
INSERT INTO wuv_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Si'ei rona i'iginia, “Hini mei na warefanio ba onei tonaa fei hafenaa unumu ma talai?” ");
INSERT INTO wuv_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Mei na pedu iba'ibana, pa'aa lomi na aida ba hini, uaa Jesus na fahela dupuaa fei gupuu rama'a yei. ");
INSERT INTO wuv_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Hinene, Jesus na bapa'ia a'a fei humuu mei Haidaa ma warefania, “Ma'aia, na rawani unumu. Apuna bigidinaa ei hafelo'a o iwe tonio manumanu na hafelodiai.” ");
INSERT INTO wuv_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Mei rama'a na aunu ma warefanaa ei Jew ba Jesus mei i farawaninia. ");
INSERT INTO wuv_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Hamatee si'ei ba Jesus na bigi'aa e'ei laloo fei Sabbath, ei Jew, rona haperararaia. ");
INSERT INTO wuv_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Jesus na warenaa a'a ro'ou, “Mei Amau, ranimai imina bigibigi nopa'amii wagieni ma yau ana fi bigi e'eni.” ");
INSERT INTO wuv_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","A'a fei, ei Jew roimina labarai tala ba ro'aa fo'afama'eia uaa ina barafeaa fei Sabbath ma ana na ware ba mei Haidaa, Amana. Hanuna ba hia na fimina'ei a'a mei Haidaa. ");
INSERT INTO wuv_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Jesus na warenaa a'a ro'ou ba: “A warefa'uai a'a hamu'ou ba mei Na'u, lomi i bigi'aa hepalo manumanu unaia; i bigi'uaiaa tamanu na fanunuia ba mei Amana na bigi'ia; uaa tamanu na bigi'ia mei Ama, mei Na'u ana i bigi'ia. ");
INSERT INTO wuv_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Uaa mei Ama na haguaa mei Na'u ma na'aida fama'aiaa tamanu ina bigi'ia. Hi'i, hamo'aa ba'arofo ma'uaa, iwe fama'aia hefi'adiai manumanu na muainaa e'ei. ");
INSERT INTO wuv_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Uaa ale'ei ba mei Ama, i famama'aiaa ei ma'ea ma fani harenuaa ro'ou ana ale'ei mei Na'u i fani harenua a'a mei nunumiana. ");
INSERT INTO wuv_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Ma hepalodiai, mei Ama, lomi i dududuaa nemea, ma'uaa na fanidigaa fei dududua i panii mei Na'u ");
INSERT INTO wuv_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","ba minaa ei rama'a, ronei ma'auaa mei Na'u ana ale'ei rona ma'auaa mei Ama. Mei lomi na ma'auaa mei Na'u, lomi na ma'auaa mei Ama, mei i aloiarai. ");
INSERT INTO wuv_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","“A warefa'uai a'a hamu'ou ba hini i guainaa ei wareau ma narafawe'i a'a mei na aloagiau, i pa'i harenua lomi i pedutoo ma lomi ba i tonaa fei dududua; ina talawa'ainaa fei ma'ea ma na nodigimai a'a fei harenua. ");
INSERT INTO wuv_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","A warefa'uai a'a hamu'ou ba fei au iwe nomai ba ei ma'ea rowe guainaa fei lao mei Na'uu mei Haidaa ma ei rona guainia, ro'aa mama'a. ");
INSERT INTO wuv_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Uaa, si'ei ba mei Ama na pa'i harenua i a'ana, ana na ugainaa mei Na'u ba nei pa'i harenua a'ana. ");
INSERT INTO wuv_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Ma na fania fei forafora ba nei fadududu, uaa hia mei Na'uu Rama'a. ");
INSERT INTO wuv_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","“Hamonei'aa ba'arofo a'a fei, uaa fi nomai fei au ba minaa ei laloo huapu, rowe guainaa fei laona ");
INSERT INTO wuv_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","ma mama'adiai—ei rona bigi'aa ei rawani'a, ro'aa asi'aa ma to harenua ma ei rona bigi'aa ei hafelo'a, ro'aa asi'aa ma to dududua. ");
INSERT INTO wuv_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Ana unaiau, lomi a bigi'aa hepalo manumanu; una dududu'uaiaa tamanu una guainia ma fei dududuau na wanewane, uaa abaa una bigi'aa fei nunumiau ma'uaa nunumiaa mei na aloagiau. ");
INSERT INTO wuv_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","“Nabaa una u'ugaa ana yau, fei u'ugau lomi i awata. ");
INSERT INTO wuv_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Na pa'i hemea na u'ugau ma una aida ba fei u'ugana yau, na awata. ");
INSERT INTO wuv_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","“Hamona alodigaa hefi'a a'a John ma ina u'ufanidigaa hamu'ou fei fa'uaia. ");
INSERT INTO wuv_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","A'a ba una tonaa ei u'ugaa rama'a; ma'uaa una wareaa fei ba hamo'aa tela. ");
INSERT INTO wuv_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","John ale'ei fei ramai na gu'afani we'ai ma do'ofama'a hamona ni'eni'e a'ana. ");
INSERT INTO wuv_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","“Una pa'i hefaa u'uga na awatadiai laraa fei u'ugaa John. Uaa fei bigi'a na fanau mei Ama ba unei fapedugia, fei u'ei bigi'ia eni, ana na fa'arewaia ba yau, aloagii mei Ama. ");
INSERT INTO wuv_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Ma mei Ama, mei na aloagiau, ana hia na u'ugau. Hamotawe guai laona o fanunu maumauna. ");
INSERT INTO wuv_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Ma ana lomi na oa laloo iaa hamu'ou fei wareana, uaa lomi hamona narafawe'i a'a mei aloanarai. ");
INSERT INTO wuv_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Hamona'aida igo'igofawe'i wagii fei Bu'u Apuna, uaa hamona nara ba wagii fei, hamo'aa pa'i harenua lomi i pedutoo. Ma fei Bu'u Apuna na u'ugau, ");
INSERT INTO wuv_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","ma'uaa pa'aa lomi hamona nomai a'au ba hamo'aa to harenua. ");
INSERT INTO wuv_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","“Lomi una nunuminaa ei udugiaa rama'a, ");
INSERT INTO wuv_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","ma'uaa una apa'aa hamu'ou. Una aida ba fei haguaa mei Haidaa, lomi laloo iaa hamu'ou. ");
INSERT INTO wuv_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Una nomai a'a fei haraa mei Amau ma lomi hamona nunuminau; ma'uaa, nabaa nemeadiai i nomai ana a'a fei harana, hamo'aa tonaa mei rama'a mei. ");
INSERT INTO wuv_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Hamo'aa narafawe'i batanai nabaa nunumiaa hamu'ou ba hamo'aa uduginaa ana hamu'ou, ma'uaa lomi hamona nunuminaa fei udugia noranamai a'a mei hemea ua Haidaa? ");
INSERT INTO wuv_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","“Ma'uaa apuna nara ba yau a uni'uniaa hamu'ou i pudaa mei Ama. Moses, mei na o'onai unuu hamu'ou a'ana, hia mei i uniaa hamu'ou. ");
INSERT INTO wuv_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Nabaa hamona nara ba fa'ua ei wareaa Moses, ana hamo'aa nara ba fa'ua ei wareau. ");
INSERT INTO wuv_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Ma'uaa, si'ei ba lomi hamona nara ba fa'ua ei ne'iana, batanai ba hamo'aa nara ba fa'ua ei wareau?” ");
INSERT INTO wuv_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Nenee fei, Jesus na suafatetenaa piye na raua yei Agii Galilee (ana harana Agii Tiberias) ");
INSERT INTO wuv_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","ma hepalo baua gupuu rama'a na nenegia, uaa rona ma'adigaa ei hilalaa foigia, ei bigi'ana a'a ei rona funu. ");
INSERT INTO wuv_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Jesus na faneaa hepalo maugeni ma gutafipui a'a ei otalai nenerana. ");
INSERT INTO wuv_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Fei Hananaa fei Talai Falogiaa ei Jew fi rafi'imai. ");
INSERT INTO wuv_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","I fanunupa'ia ba fi nomai fei baua gupuu rama'a Jesus, na warenaa a'a Philip, “O pono hitani faraa pidaua hanaa eni rama'a eni?” ");
INSERT INTO wuv_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Na i'iginaa fei ba i mani'uaia, hamatee nadii aida ba i bigi'aa tamanu. ");
INSERT INTO wuv_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Philip na warenaa a'ana, “Pono'aa hemea bigi'a laloo fainaroa puda, lomi i hawiaa pono'aa faraa pidaua ba hememea i hanana!” ");
INSERT INTO wuv_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Hemeadiai ei otalai nenerana, Andrew, mei lofuu Simon Peter na ware, ");
INSERT INTO wuv_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","“Meni baduu wawane meni na pa'i haipani pusu'o faraa pidaua barley ma guapalo pusu'o nia ma'uaa, ana ipo'o hawiaa eni watauda rama'a eni?” ");
INSERT INTO wuv_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Jesus na ware, “Fagutanaa ena rama'a.” Na pa'i watauda guana yei ma ale'ei haipani pufaba'a wawane, rona guta. ");
INSERT INTO wuv_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Jesus na tonaa ei faraa pidaua, na ware ‘ta’ ma alaginia a'a ei rona guta ale'ei nunumiaa ro'ou. Ana na bigi'ia ale'ei a'a gupaloei nia. ");
INSERT INTO wuv_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Ro'aa hananamagudii, ina warenaa a'a ei otalai nenerana, “Paiaa ei masii du'ua. Lomi ba o simi'uaiaa ma'ida.” ");
INSERT INTO wuv_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Si'ei, rona paifapepesuaa hefua ma guapalo pa a'a ei masii ei haipani faraa pidaua barley, ei magu'arawaa ei rama'a. ");
INSERT INTO wuv_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Ro'aa fanunudigaa fei hilalaa foigia bigi'aa Jesus, ronawe ware, “Pa'aa fa'ua ba hia mei Mamama'a, mei ba i nomai yeni malagufu.” ");
INSERT INTO wuv_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Jesus na aidadii ba ropowe panarofagutania ba hia hapara ma si'ei, ina di'ininaa ro'ou ma fanedinaa hepalo maugeni ana unaia. ");
INSERT INTO wuv_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","I nopoilao, ei otalai nenerana, rona upunaloo agi ");
INSERT INTO wuv_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","ma hugi pafoo wa ma suanaloo Capernaum. Ina roromadii ma Jesus atawe nomai a'a ro'ou. ");
INSERT INTO wuv_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Fei lalarena na agifawe'i ma namina weta fei agi. ");
INSERT INTO wuv_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Ro'aa suadii ale'ei haipani o oloroa kilometre, ronawe fanunupa'aa Jesus fi nofarafi'imai a'a fei wa ma talai pafoo agi ma ronamina ma'au. ");
INSERT INTO wuv_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Ma'uaa na warenaa a'a ro'ou, “Ana yau ua, apuna ma'au.” ");
INSERT INTO wuv_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Ma nawe rawani naranaraa ro'ou ba ro'aa fahuginia ma ana ei ua, fei wa na fatetenaa piyee fawelei ba ro dinaa wagina. ");
INSERT INTO wuv_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","I no'arewadilao, fei gupuu rama'a, fei rona guta pafoo piye oma'analoo fipepei, rona fanunupa'ia ba hepalo ua wa nado'o pe'i yei ma ba Jesus, lomi na hugi pafona, uniaa ei otalai nenerana na sua'aunu. ");
INSERT INTO wuv_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","I dii, hefi'a wa, noramiaa ro'ou Tiberias na fatete papaa fawelei ro'aa hanaiaa ei faraa pidaua nenee i ware ‘ta’ mei Fasu. ");
INSERT INTO wuv_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Ro'awe apa'ia fei gupuu rama'a ba Jesus ma ei otalai nenerana lomi yei, rona hugi pafoo ei wa ma suanaa Capernaum ba ro'aa labaginaa Jesus. ");
INSERT INTO wuv_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Ro'aa nobapa'alao fipepei oma'aloo ro'ou, rona i'iginia, “Rabbi, fateteamu haiga yeni?” ");
INSERT INTO wuv_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Jesus na ware, “A warefa'uai a'a hamu'ou ba fei pa'afii labagiaa hamu'ou yau a'a ba fei fanunuaa hamu'ou ei hilalaa foigia ma'uaa, ba hamona hanafamagu a'a ei faraa pidaua. ");
INSERT INTO wuv_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Apuna bigibigi ba o tonaa ei du'ua, ei i waragu ua, ma'uaa ei du'ua i ude nopa'aloo fei harenua lomi i pedutoo, fei ba i fanaa hamu'ou mei Na'uu Rama'a. Mei Haidaa, mei Ama na ugainia ma audigaa fei lalana a'ana.” ");
INSERT INTO wuv_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Ma rona i'iginia, “Batanai ba hai'ou'aa bigi'aa ei bigi'aa mei Haidaa?” ");
INSERT INTO wuv_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Jesus na ware, “Fei bigi'aa mei Haidaa, sifei ba hamonei narafawe'i a'a mei aloamiana.” ");
INSERT INTO wuv_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Si'ei, rona i'iginia, “O bigi'aa tamanu hilalaa foigia ba hai'ou ma'aia ma narafawe'i a'amu? O bigi'aa tamanu? ");
INSERT INTO wuv_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Ei upuu hai'ou, rona hanaiaa ei manna fawelei lomi haihai o guana; ana ale'ei fei ne'ia: ‘Ina fani hanaa ro'ou faraa pidaua noramiana pafea.’” ");
INSERT INTO wuv_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Jesus na warenaa a'a ro'ou, “A warefa'uai ba abaa Moses mei i fani hanaa hamu'ou faraa pidaua noramiana pafea, ma'uaa mei Amau, mei i fanaa hamu'ou fei pa'aa faraa pidaua noramiana pafea. ");
INSERT INTO wuv_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Uaa fei faraa pidauaa mei Haidaa, ana simei, mei na nogio pafea ma fani harenua yeni malagufu.” ");
INSERT INTO wuv_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Rona ware, “Mena bauana, e'eni ma nolao, fanaa hai'ou fei faraa pidaua fei.” ");
INSERT INTO wuv_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Jesus na ware, “Yau, fei faraa pidaua i fani harenua. Hini i nomai a'au, lomi iwe baodiai ma mei i narafawe'i a'au, lomi iwe sigigidiai. ");
INSERT INTO wuv_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Ma'uaa ana ale'ei adii wareia ba hamona fanunudigau ma lomi hamona narafawe'i. ");
INSERT INTO wuv_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Minaa ei na fanau mei Ama, rowe nomai a'au ma hini i nomai a'au, pa'aa lomi ba a alofatatalainia. ");
INSERT INTO wuv_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Uaa ei a nogio pafea, a'a ba a bigi'aa ei nunumiau, ma'uaa ei nunumiaa mei na aloagiau. ");
INSERT INTO wuv_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Ma fei nunumiaa mei na aloagiau sifei ba unei'aa fapa'ainaa minaa ei fanana yau ma'uaa, nei fa'asi'anaa ro'ou wagii fei a'apoo arewaa. ");
INSERT INTO wuv_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Uaa fei nunumiaa mei Amau sifei ba hini i fanununaa a'a mei Na'u ma narafawe'i a'ana, iwe pa'i harenua lomi i pedutoo ma awe fa'asi'ania wagii fei a'apoo arewaa.” ");
INSERT INTO wuv_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","A'a fei, ei Jew, rona bababau'unia uaa ina ware, “Yau, fei faraa pidaua noramiana pafea.” ");
INSERT INTO wuv_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Rona ware ba, “Haa, abaa hia Jesus, mei na'uu Joseph, mei ona apa'aa amana ma inana? Batanai i ware ba ‘Noramiau pafea’?” ");
INSERT INTO wuv_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Jesus na ware, “Apuna bababau'u dupuaa hamu'ou. ");
INSERT INTO wuv_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Lomi nemea i nomai a'au nabaa lomi i taudugia mei Ama, mei na aloagiau ma a fa'asi'ania a'a fei a'apoo arewaa. ");
INSERT INTO wuv_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Na ude a'a ei ne'iaa ei Mamama'a ba: ‘Mei Haidaa, iwe feroinaa minaa ro'ou.’ Hini i guainaa mei Ama ma tonaa ei feroiana, iwe nomai a'au. ");
INSERT INTO wuv_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Lomi hemea na ma'a mei Ama ma'uaa, mei noramiana a'a mei Haidaa; ana unaia na ma'a mei Ama. ");
INSERT INTO wuv_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","A warefa'uai a'a hamu'ou ba hini i narafawe'i, i pa'i harenua lomi i pedutoo. ");
INSERT INTO wuv_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Yau, fei faraa pidaua i fani harenua. ");
INSERT INTO wuv_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Ei upuu hamu'ou, rona hanaiaa ei manna yei fawelei lomi haihai o guana ma'uaa, rona ma'e. ");
INSERT INTO wuv_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Ma'uaa yeni, na pa'i fei faraa pidaua noranarai pafea, fei nabaa nemea i hanaia lomi ba i ma'e. ");
INSERT INTO wuv_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Yau, fei faraa pidaua na pa'i harenua, fei noramiana pafea. Nabaa nemea i hanaiaa feni faraa pidaua, iwe guta ranimai ranimai. Feni faraa pidaua feni, feni pigiou, feni ba a fani ba harenuaa feni malagufu.” ");
INSERT INTO wuv_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Ma ei Jew, rona'aa fiharenii ana ro'ou ba, “Batanai ba mei rama'a mei i fanaa o'ou fei pigiona ba o hanaia?” ");
INSERT INTO wuv_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Jesus na warenaa a'a ro'ou, “A warefa'uai a'a hamu'ou ba nabaa lomi hamo'aa hanaiaa fei pigioo mei Na'uu Rama'a ma hunumaa fei rarana, lomi hamo'aa pa'i harenua. ");
INSERT INTO wuv_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Hini i hanaiaa fei pigiou ma hunumaa fei rarau, i pa'i harenua lomi i pedutoo ma awe fa'asi'ania a'a fei a'apoo arewaa. ");
INSERT INTO wuv_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Uaa, fei pigiou, pa'aa du'ua ma fei rarau, pa'aa hunuma. ");
INSERT INTO wuv_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Hini i hanaiaa fei pigiou ma hunumaa fei rarau, i oafipui a'au ma yau a'ana. ");
INSERT INTO wuv_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Mei Ama, mei i oalao na aloamiau ma una pa'i harenuau uaa hia. Ma ana ale'ei, hini i hanaiau, iwe pa'i harenuana uaa yau. ");
INSERT INTO wuv_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Sifei, fei faraa pidaua noramiana pafea. Ei upuu hamu'ou, rona hanana manna ma rona ma'e ma'uaa, hini i hanaiaa feni faraa pidaua feni, iwe guta ranimai ranimai.” ");
INSERT INTO wuv_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Ina wareaa fei ei fi feroi laloo fei synagogue yei Capernaum. ");
INSERT INTO wuv_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Ro'aa guainaa fei, watauda ei otalai nenerana na ware, “Fei feroia fei, namina hafafala'ai. Hini ba i tonia?” ");
INSERT INTO wuv_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Jesus na aida ba ei otalai nenerana, rona bababau'u wagina ma na warenaa a'a ro'ou, “Na fafeloaa naranaraa hamu'ou fei? ");
INSERT INTO wuv_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Tamanu naraa hamu'ou nabaa hamo'aa fanunuaa mei Na'uu Rama'a i hadiwe'inaa pafea a'a fei gutanana mina? ");
INSERT INTO wuv_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Fei Spiriti i fani harenua; fei pigioo rama'a, lomi hanuna. Ei wareau a'a hamu'ou ale'ei spiriti ma na pa'i harenua. ");
INSERT INTO wuv_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Ma'uaa hefi'a hamu'ou lomi na narafawe'i.” Hamatee Jesus na aidadii ba hini ro'ou lomi na we'i naranarana ma hini i aloia panii hefi'a. ");
INSERT INTO wuv_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Ina waredilao ba, “Sifei fei pa'afina a warenaa a'a hamu'ou ba lomi nemea i nomai a'au nabaa lomi i hadumia mei Ama.” ");
INSERT INTO wuv_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","A'a fei au fei, watauda ei otalai nenerana, rona ofadugia ma lomi rona nenegidinia. ");
INSERT INTO wuv_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Jesus na i'iginaa ei Hefua ma Helagui, “Haa, ana ba hamo'aa di'ininau?” ");
INSERT INTO wuv_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Simon Peter na warenaa a'ana, “Mena Fasu, hai'ou dinaa a'a hini? Ei wareamu na pa'i harenua lomi i pedutoo. ");
INSERT INTO wuv_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Ina we'i ei naranaraa hai'ou ma hai'ouna aida ba yoi, mei Apunaiaa mei Haidaa.” ");
INSERT INTO wuv_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Ma Jesus na ware, “Abaa una rafeidigaa hamu'ou ena Hefua ma Helagui? Ma'uaa hemea hamu'ou, hia hani'u!” ");
INSERT INTO wuv_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","(Ifi hanuinaa Judas, mei na'uu Simon Iscariot, hemea ei Hefua ma Helagui, mei ba i aloia.) ");
INSERT INTO wuv_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Nenee fei, Jesus na tatalai yei Galilee ma na nara ba lomi i dinaa Judea uaa ei Jew yei ba ro'aa fo'afama'eia. ");
INSERT INTO wuv_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Ma'uaa i norafi'imai fei hananaa ei Jew, fei Hananaa ei Pale, ");
INSERT INTO wuv_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","ei lofuu Jesus, rona ware a'ana ba, “Onei aunu yeni ma dinaa Judea ba ei otalai neneramu, ronei ma'aiaa ei foigia ona'aida bigi'ia. ");
INSERT INTO wuv_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Nabaa nemea na nunuminia ba hia bauana, lomi ba i opa'ainaa ei bigi'ana. Si'ei ba yoi, oi bigi'aa ei manumanu ei, onei fama'aio a'a feni ano.” ");
INSERT INTO wuv_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Uaa ei lofuna, ana lomi rona narafawe'i a'ana. ");
INSERT INTO wuv_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Si'ei, Jesus na warenaa a'a ro'ou, “Atawe nomai fei pa'aa auu. ");
INSERT INTO wuv_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Feni ano, lomi ba i bidibidi ununa a'a hamu'ou, ma'uaa na bidibidi ununa a'au uaa una'o u'ugia ba ei bigi'ana na hafelo. ");
INSERT INTO wuv_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Hamonei dinaa a'a fei Hananaa. Lomi ado'o dinaa a'a fei Hananaa, uaa atawe nomai fei pa'aa auu.” ");
INSERT INTO wuv_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","I waredigaa fei, na gutadiai i Galilee. ");
INSERT INTO wuv_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Ma'uaa ro'aa aunudiginaa fei Hananaa ei lofuna, ana ina aunupa'ailao. ");
INSERT INTO wuv_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Ma yei a'a fei Hananaa ei Jew, rona lalabaginia ma i'igai ba, “Amaia mei rama'a mei?” ");
INSERT INTO wuv_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","I dupuaa ei gupuu rama'a rona fileleleinia. Hefi'a na ware, “Hia, rawani'a rama'a.” Hefi'adiai na ware, “Lo'e, ina sifi'aa ei rama'a.” ");
INSERT INTO wuv_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Ma'uaa lomi hemea na ware i pudaa rama'a, uaa rona ma'auaa ei Jew. ");
INSERT INTO wuv_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","I nohesuwilao fei Hananaa, Jesus na dinaa malalaa fei humuu mei Haidaa ma na'aa feroi. ");
INSERT INTO wuv_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Ei Jew na ba'arofo ma i'igai, “Ina tobatanainia ei apa'ana ma lomi na to feroiana wagina?” ");
INSERT INTO wuv_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Jesus na ware, “Fei feroiau abaa manumanuu. Noramiana a'a mei i aloagiau. ");
INSERT INTO wuv_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Hini ba i bigi'aa ei nunumiaa mei Haidaa neido'o narama'aiaa fei feroiau ba noramiana a'a mei Haidaa, o u'u'uau. ");
INSERT INTO wuv_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Mei i u'ugaa anaia, fi bigi'ia ba i pa'i rawani'a harana ma'uaa, mei i bigi ba i farawaninaa fei haraa mei na aloia, hia hemea na fa'uai; lomi hepalo sifi'ana. ");
INSERT INTO wuv_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Haa, abaa na fanaa hamu'ou fei Law Moses? Ma'uaa lomi hemea hamu'ou na nenegia. Tani ei ba hamo'aa fo'afama'eau?” ");
INSERT INTO wuv_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Fei gupuu rama'a na ware, “Woroo na wadu'io pigea. Hini ba i fo'afama'eio?” ");
INSERT INTO wuv_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Jesus na warenaa a'a ro'ou, “Una bigi'aa hepalo foigia ma hamona ba'arofo. ");
INSERT INTO wuv_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Ma'uaa, si'ei ba na fanaa hamu'ou fei mau moro'aa hudii wawanei (ma'uaa abaa pa'aa noramiana a'a Moses, uaa ei ama mina), hamona'o moro'aa hudii wawanei ei baduu laloo fei Sabbath. ");
INSERT INTO wuv_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Ma nabaa na rawani a'a hamu'ou ba nemea baduu i moro laloo fei Sabbath ba lomi hamo'aa barafeaa fei law Moses, tani hamo'aa siba a'au ba na farawaninaa minaa ei unuu hemea rama'a wagii fei Sabbath? ");
INSERT INTO wuv_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Apuna fafi'i'uanaa naranaraa hamu'ou a'a tamanu hamona fanunuia. Hamonei narama'aia.” ");
INSERT INTO wuv_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","A'a fei, hefi'a ei rama'aa Jerusalem, rona i'igai, “Haa, simeni, meni ba ro'aa fo'afama'eia? ");
INSERT INTO wuv_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Hia simeni fi wareware i pudaa ei rama'a ma lomi rona wareaa hepalo warea a'ana. Haa, ei bauana, ronapa'aa nara ba hia Christ? ");
INSERT INTO wuv_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Ma'uaa, o'ouna aida ba gufuna hitani; nabaa i nomai mei Christ, lomi nemea i aida ba gufuna hitani.” ");
INSERT INTO wuv_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Jesus ana fi feroi i malalaa fei humuu mei Haidaa, ei i warefabauana ba, “Hi'i, hamona apa'au ma aida ba hitani gufuu. Abaa no'uamiau ma'uaa, mei na aloagiau napa'aa fa'uai. Lomi hamona apa'ia, ");
INSERT INTO wuv_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","ma'uaa una apa'ia, uaa noramiau i a'ana ma ina aloagiau.” ");
INSERT INTO wuv_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","A'a fei, ba ro'aa panarofia, ma'uaa lomi hemea na panarofia, uaa atawe nomai fei auna. ");
INSERT INTO wuv_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Ma'uaa watauda i dupuaa ei rama'a, rona narafawe'i a'ana. Rona ware ba, “Nabaa i nomai mei Christ, ana i bigi'aa wataudadiai hilalaa foigia laraa meni?” ");
INSERT INTO wuv_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Ei Pharisee na guainaa fei gupuu rama'a ba rona fiwareifagiginia ale'ei. Ma ei famamoaa humuu mei Haidaa mawe ei Pharisee, rona aloaa ei oanananaa fei humuu mei Haidaa ba ronei panarofia. ");
INSERT INTO wuv_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Jesus na ware, “Lomi i madii gutanau a'a hamu'ou ma a dinaa a'a mei i aloagiau. ");
INSERT INTO wuv_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Hamo'aa lalabaginau, ma'uaa lomi ba hamowe labagipa'au; ma yei una dinaa wagina, lomi ba hamo'aa nopa'ilao.” ");
INSERT INTO wuv_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Ei Jew, rona fiwarewarei, “Mei rama'a mei ba i dinaia, te ba lomi o labagipa'ia? Ba i dinaa fawelei ma feroinaa ei Greece ma guta a'a ei gufuu o'ou, ei rona fawawadidi dupuaa ei rama'a yei. ");
INSERT INTO wuv_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Tamanu hanuu ei wareana ba, ‘Hamo'aa lalabaginau ma'uaa, lomi hamowe labagipa'au ma hitani a dinaa wagina, lomi hamowe nopa'ilao’?” ");
INSERT INTO wuv_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","A'a fei a'apoo arewaa fei Hananaa fei na bauanaidiai laraa ei arewaa fama'a, Jesus na ufalarai ma warefabauana, “Hini na sigigi neimii hunu a'au. ");
INSERT INTO wuv_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Hini na narafawe'i a'au, ale'ei fei wareaa fei Bu'u Apuna, iwe pa'i ale'ei ranuu loloma laloo iana.” ");
INSERT INTO wuv_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","A'a fei, fi hanuinaa fei Spiriti, fei rowe tonia ei rona narafawe'i a'ana. Nopa'aloo fei au fei, itawe fanaa ro'ou fei Spiriti, uaa atawe tonaa fei hawerana Jesus. ");
INSERT INTO wuv_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Ro'aa guainaa fei, hefi'a na ware, “Pa'aa fa'ua ba mei rama'a mei, hia mei Mamama'a.” ");
INSERT INTO wuv_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Hefi'a na ware, “Hia mei Christ.” Ma hefi'adiai na i'igai, “Haa, mei Christ, ba i nomai Galilee?” ");
INSERT INTO wuv_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Haa, lomi na ware fei Bu'u Apuna ba mei Christ, hia a'a fei pai David ma ba i nomai Bethlehem, fei gufu na guta wagina mina David?” ");
INSERT INTO wuv_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Si'ei, namina hamamaguaa naranaraa ei rama'a a'a Jesus. ");
INSERT INTO wuv_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Hefi'a, ba ro'aa panarofia; ma'uaa lomi hemea na aunaa panina a'ana. ");
INSERT INTO wuv_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Ei famamoaa humuu mei Haidaa ma ei Pharisee, rona i'igainaa ei oanananaa fei humuu mei Haidaa, ei ro'aa hadiwe'imai a'a ro'ou ba, “Tani lomi hamona nodugamai?” ");
INSERT INTO wuv_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Ei oanananaa na ware, “Lomi nemea i wareware ale'ei ei mau wareaa mei.” ");
INSERT INTO wuv_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Ei Pharisee na ware, “Ei hanuiaa hamu'ou ba ana ina sifipa'aa hamu'ou? ");
INSERT INTO wuv_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Na pa'i hemea bauana o Pharisee na narafawe'i a'ana? ");
INSERT INTO wuv_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Pa'aa lomi! Ma'uaa fei gupuu rama'a, lomi rona apa'aa hepalo manumanu a'a fei law—ronei tonaa umua.” ");
INSERT INTO wuv_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Nicodemus, mei nado'o dinaa a'a Jesus, mei ana hemea ro'ou na i'igai, ");
INSERT INTO wuv_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","“Haa, fei law o'ou, i rataware ua ba na tata hemea ma lomi i do'o guainia ba tamanu ei bigi'ana?” ");
INSERT INTO wuv_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Rona ware, “Haa, ana gufumu Galilee? Fanunufarawaninia uaa lomi ba hemea mamama'a, noramiana Galilee.” ");
INSERT INTO wuv_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Si'ei, hememea na dinaa humuna. ");
INSERT INTO wuv_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Ma'uaa Jesus na dinaa a'a fei Maugeni Olive. ");
INSERT INTO wuv_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Mafufuo badu, na udiai i malalaa fei humuu mei Haidaa ma minaa ei rama'a, rona puroroinia ma na guta ba i feroinaa ro'ou. ");
INSERT INTO wuv_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Ei feroiaa law mawe ei Pharisee, rona duginamii a'ana hemea pifine rona ma'apa'ia ei i fiharoharoipa'ai. Rona fa'ufalarainia i pudaa rama'a ");
INSERT INTO wuv_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","ma warenaa a'a Jesus, “Mena feroia, meni pifine meni, hai'ouna panarofia ei i fiharoharoipa'ai. ");
INSERT INTO wuv_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Fei Law Moses na ware ba onei nafanaa mugoo ei mau pifine ale'ei. Si'ei, o ware batanai wagina?” ");
INSERT INTO wuv_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Rona i'iginia ba ro fa'alabe'ia ma ro ware ba ina warefatata. Ma'uaa Jesus na fabalonaa pu ma ne'inaa ana'anana malagufu. ");
INSERT INTO wuv_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Rona mina'u i'igi'uaia, hee inawe ufalarai ma warenaa a'a ro'ou, “Hini hamu'ou lomi hafelo'ana, te, hia do'o rawarawa nafa'a.” ");
INSERT INTO wuv_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Ina fabalodiai ma ne'ine'i pafoo malagufu. ");
INSERT INTO wuv_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Hememea ei rona guainia, ronawe fididi'inii, do'ofama'a ei rona siginaa raudei. La'o uniaa mei pifine a'a Jesus. ");
INSERT INTO wuv_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Jesus na ufalarai ma i'iginia, “Mena pifine, ro'ou hitani? Lomi hemea na wareio ba ona tata?” ");
INSERT INTO wuv_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Ina ware, “Lomi hemea, mena bauana.” Jesus na ware, “Hi'ei, ana lomi a wareio ba ona tata. Nowau ma onei'aa fai bigidinaa ena hafelo'a.” ");
INSERT INTO wuv_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Jesus na warediai a'a ei rama'a ba, “Yau, we'ai feni ano. Hini i nenerau, lomi ba iwe talai laloo fei roromaa, ma'uaa i pa'i fei we'ai, fei i fani harenua.” ");
INSERT INTO wuv_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Ei Pharisee, rona mania, “E'eni, ona u'ugio; si'ei ba oi u'ugaa anaio, lomi na wanewane ei u'ugamu.” ");
INSERT INTO wuv_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Jesus na ware, “Nabaa na u'ugaa ana yau, fei u'ugau na wanewane, uaa una aida ba noramiau hitani ma a dinaia. Ma'uaa pa'aa lomi hamona aida ba noramiau hitani o a dinaia. ");
INSERT INTO wuv_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Hamona'u nara'uaiaa ei manumanu ale'ei mau naranaraa rama'a; yau lomi na narafani maumau hemea. ");
INSERT INTO wuv_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Ma'uaa nabaa una nara ale'ei, fei naranarau na wanewane, uaa abaa unaa yau. Una ufipui a'a mei Ama, mei na aloagiau. ");
INSERT INTO wuv_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Laloo fei Law hamu'ou na ude fei ne'ia ba nabaa i fibo'ii u'ugaa helagui, ina wanewane. ");
INSERT INTO wuv_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Yau, hemea ana fi u'ugau; ma hemeadiai ana na u'ugau, mei Ama, mei na aloagiau.” ");
INSERT INTO wuv_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Ma i dii, rona i'iginia, “Amaia mei amamu?” Jesus na ware, “Lomi hamona apa'au, o mei Amau. Nabaa hamona apa'au, ana hamo'aa apa'aa mei Amau.” ");
INSERT INTO wuv_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Ina wareaa fei ei fi feroi i malalaa fei humuu mei Haidaa papaa fei bao fana mugoo po'i. Ma'uaa lomi hemea na panarofia, uaa atapa'aa fei auna. ");
INSERT INTO wuv_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Jesus na warediai a'a ro'ou ba, “Yau, a dii ma hamo'aa labaginau, ma'uaa hamo'aa ma'ehugiaa ei hafelo'aa hamu'ou. Fawelei ba a dinaa wagina, lomi ba hamowe nopa'ilao. ");
INSERT INTO wuv_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","A'a fei, ei Jew, rona i'igai, “Haa, ba ana i fo'afama'eaa anaia? Sifei, fei hanuu wareana ba, “Fawelei ba a dinaa wagina, lomi hamowe nopa'ilao”? ");
INSERT INTO wuv_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Ma'uaa ina warelao, “Noramiaa hamu'ou pu, ma'uaa noramiau pafea. Hamu'ou, rama'aa feni ano. Yau abaa rama'aa feni ano. ");
INSERT INTO wuv_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Una warefanidigaa hamu'ou ba hamo'aa ma'ehugiaa ei hafelo'aa hamu'ou; nabaa lomi hamona nara ba fa'ua fei wareau ba yau hini, hamowepa'aa ma'ehugiaa ei hafelo'aa hamu'ou.” ");
INSERT INTO wuv_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Rona i'igai, “Yoi hini?” Jesus na ware, “Ana ale'ei una waredigamai. ");
INSERT INTO wuv_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Na pa'i watauda wareau ba hamu'ou rama'a bata wagii ei maumau hamu'ou. Ma'uaa, mei na aloagiau, hia napa'aa fa'uai ma tamanu una guainia a'ana, una u'ugia yeni malagufu.” ");
INSERT INTO wuv_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Lomi rona apa'ia ba fi u'ugaa mei Amana a'a ro'ou. ");
INSERT INTO wuv_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Si'ei, Jesus na ware, “Ena hamona fatawadigaa mei Na'uu Rama'a, hamowe aida ba fa'ua fei warau ba yau hini ma lomi ba una bigi'aa hepalo manumanu unaa yau, ma'uaa una wareaa tamanu na feroinau mei Ama. ");
INSERT INTO wuv_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Mei na aloagiau, hia a'au; lomi ba i di'ininau uaa, una'aida bigi'aa ei nunumiana.” ");
INSERT INTO wuv_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Ei fi u'u, watauda, rona narafawe'i a'ana. ");
INSERT INTO wuv_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","A'a ei Jew rona narafawe'i a'ana, Jesus na ware, “Nabaa hamo'aa urofaa ei feroiau, hamu'ou pa'aa otalai nenerau. ");
INSERT INTO wuv_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Ma hamowe aida fei fa'uaia ma fei fa'uaia i alafatalainaa hamu'ou.” ");
INSERT INTO wuv_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Rona warefania, “Hai'ou, na'uu Abraham ma nopa'amii wagieni, lomi hemea na humuwainaa hai'ou. Tani o ware ba hepalo manumanu i alafatalainaa hai'ou?” ");
INSERT INTO wuv_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Jesus na ware, “A warefa'uai a'a hamu'ou ba hini na bigi'aa ei hafelo'a, hia humuwa a'a ei hafelo'a. ");
INSERT INTO wuv_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Mei humuwa, abaa hia pa'aa pai hepalo maroa ma'uaa, mei na'u, hia pai fei maroana ranimai ranimai. ");
INSERT INTO wuv_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Si'ei, nabaa mei Na'u na alafatalainaa hamu'ou, hamopowe talaifa'a'a. ");
INSERT INTO wuv_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Una aida ba hamu'ou na'uu Abraham. Ma'uaa hamo'ei oma'a ua ba hamo'aa fo'afama'eau, uaa pa'aa lomi pe'i ei wareau a'a hamu'ou. ");
INSERT INTO wuv_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","A warefanaa hamu'ou tamanu na ma'apa'ia inamoaa mei Amau ma hamu'oufi bigi'aa tamanu hamona guainia a'a ei amaa hamu'ou.” ");
INSERT INTO wuv_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Rona ware, “Abraham, amaa hai'ou.” Jesus na ware, “Nabaa hamu'ou na'uu Abraham, te, hamo'aa bigi'aa tamanu Abraham na'o bigi'ia. ");
INSERT INTO wuv_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Ma'uaa hamu'ou, ba hamo'aa fo'afama'eau, yau meni na warefanaa hamu'ou fei fa'uaia, fei na guainia a'a mei Haidaa. Abraham, lomi na bigi'aa ei manumanu ale'ei. ");
INSERT INTO wuv_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Hamona'o bigi'aa ei na bigi'ia mei amaa hamu'ou.” Rona fiharei a'ana ba, “Abaa hai'ou na'uu tala. Hai'ouna pa'i hemea ua ama, ana unaa mei Haidaa.” ");
INSERT INTO wuv_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Jesus na warenaa a'a ro'ou, “Nabaa mei Haidaa Amaa hamu'ou, hamo'aa haguau, uaa noramiau a'a mei Haidaa ma e'eni yau yeni. Abaa no'uamiau; ma'uaa aloagiana. ");
INSERT INTO wuv_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Tani lomi na arewa a'a hamu'ou ei wareau? Hamatee, na loto adiaa hamu'ou. ");
INSERT INTO wuv_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Hamu'ou, na'uu mei amaa hamu'ou, mei hani'u ma ba hamo'aa bigi'aa ei nunumiaa mei amaa hamu'ou. A'a fei rawarawa ma nolao hia rama'aa fo'afama'ea. Lomi na urofaa fei fa'uaia uaa, pa'aa lomi ma'ida fa'uaia a'ana. Ena na warefasifi, fipa'aa wareaa fei wareagufuna, uaa hia sifisifi ma amaa ei sifisifi. ");
INSERT INTO wuv_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Ma'uaa si'ei ba una warefa'uai a'a hamu'ou, lomi hamona nara ba fa'ua ei wareau! ");
INSERT INTO wuv_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Na pa'i hemea hamu'ou ba ipa'aa ware'uniaa fei hafelo'au? Nabaa na warefa'uai, tani hamo'aa nara ba abaa fa'ua ei wareau? ");
INSERT INTO wuv_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Hini i oafipui a'a mei Haidaa, i guainaa tamanu na wareia mei Haidaa. Fei pa'afina ba lomi hamo'aa guai, sifei ba lomi hamona oafipui a'a mei Haidaa.” ");
INSERT INTO wuv_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Ei Jew, rona warenaa a'ana, “Haa, lomi na wanewane ei wareaa hai'ou ba yoi hemea Samaria ma na wadu'io pigea?” ");
INSERT INTO wuv_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Jesus na ware, “Lomi na wadu'au pigea, ma'uaa una fani honua a'a mei Amau ma lomi hamona fani honua a'au. ");
INSERT INTO wuv_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Abaa a labarai haweraa ana yau; ma'uaa na pa'i hemea ba i lalabaginia ma hia mei fadududua. ");
INSERT INTO wuv_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","A warefa'uai a'a hamu'ou ba hini i aunaa naranarana ei wareau, lomi ba iwe ma'a fei ma'ea.” ");
INSERT INTO wuv_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","A'a fei, ei Jew, rona ware, “Hai'ounawe aida ba napa'aa wadu'io pigea! Abraham na ma'e ma ei mamama'a anaa, ma'uaa ona ware ba nabaa nemea i aunaa naranarana ei wareamu, lomi ba i nanamuinaa fei ma'ea. ");
INSERT INTO wuv_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Haa, ona muainaa mei amaa hai'ou Abraham? Ina ma'e ma ei mamama'a anaa. Ei naramu ba yoi hini?” ");
INSERT INTO wuv_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Jesus na ware, “Nabaa una uduginaa ana yau, lomi hanuu fei udugiau. Mei Amau, mei hamona ware ba Haidaniaa hamu'ou, ana simei na fani hawerau. ");
INSERT INTO wuv_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Lomi hamona apa'ia ma'uaa, una apa'ia. Nabaa una ware ba lomi na apa'ia, una warefasifi ale'ei hamu'ou ma'uaa, unapa'aa apa'ia ma neneraa ei wareana. ");
INSERT INTO wuv_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Mei amaa hamu'ou Abraham, fei naranarana na refu ba i ma'a fei au noramiau; ina ma'adigia ma na ni'eni'e.” ");
INSERT INTO wuv_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Ei Jew, rona warenaa a'ana, “Otawe pa'i haipani pa'ania igisimasi—haa, ona ma'apa'aa Abraham!” ");
INSERT INTO wuv_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Jesus na ware, “A warefa'uai a'a hamu'ou ba itawe wanini Abraham, na Oa Yau!” ");
INSERT INTO wuv_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","A'a fei, rona hau'aa ei mugoo ba ro'aa nafa'ia ma'uaa, Jesus na fa'opa'ai ma lele'apa'aidi'ininaa malalaa fei humuu mei Haidaa. ");
INSERT INTO wuv_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Ei fi talailao na ma'apa'aa hemea na wanini pudawerai. ");
INSERT INTO wuv_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Ei otalai nenerana na i'iginia, “Rabbi, hini na bigifafelo, meni rama'a meni, o amana ma inana ma si'ei i wanini pudawerai?” ");
INSERT INTO wuv_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Jesus na ware, “Abaa hia o amana ma inana, rona bigifafelo ma'uaa, na nomai fei ba fei bigi'aa mei Haidaa nei ale'ei fama'ama'a wagii fei gutanana. ");
INSERT INTO wuv_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Eni fi arewa, onei bigi'aa ei bigi'aa mei na aloagiau. I mai fei poi ba lomi nemea i bigi. ");
INSERT INTO wuv_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Ena una guta yeni malagufu, yau meni we'ai feni malagufu.” ");
INSERT INTO wuv_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","I waredigaa fei, na huwiaa fei malagufu, faheduia ma augia i pudaa mei rama'a mei. ");
INSERT INTO wuv_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Ina warenaa a'ana, “Nowau. Nunuu a'a fei Pe'i Ranu Siloam” (hanuu fei hara ba na alodigia). Si'ei, naree nunuu ma na nofafanunulao dinaa humuna. ");
INSERT INTO wuv_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Ei gufuna mawe ei ronado'o fanunuia ba hia na'o gutanoinoi ma'aa tala, rona i'igai, “Haa, ana simei mei na'o gutanoinoi?” ");
INSERT INTO wuv_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Hefi'a, rona ware ba hi'i, ma'uaa hefi'a ba, “Lo'e, sifei ua ba na fimina'ei fafanunuaa lagua.” Ma'uaa mei rama'a na ware, “Ana yau simeni.” ");
INSERT INTO wuv_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Ma rona i'igifawe'i a'ana, “Hamatani o fanunupa'i?” ");
INSERT INTO wuv_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Ina ware, “Mei rona roroinia Jesus na faheduaa fei malagufu ma augia pudau. Ina warefanau ba nei dinaa Siloam ma nunuu. Si'ei, naree nunuu ma nawe fanunupa'i.” ");
INSERT INTO wuv_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Rona i'iginia, “Amaia mei rama'a mei?” Ina ware, “Lomi una aida.” ");
INSERT INTO wuv_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Rona duginaa a'a ei Pharisee mei na wanini pudawerai. ");
INSERT INTO wuv_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Ma fei arewaa, fei i faheduaa fei malagufu ma fawanewaneaa mei pudawerai Jesus, Sabbath. ");
INSERT INTO wuv_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Si'ei, ei Pharisee, ana rona i'iginia ba tani i fafanunupa'i. Ina ware, “Ina au hedu i pudau, una nunuu ma eni na fanunupa'i.” ");
INSERT INTO wuv_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Hefi'a ei Pharisee, rona ware, “Mei rama'a mei, abaa noramiana a'a mei Haidaa, uaa lomi na neneraa fei Sabbath.” Ma'uaa, hefi'adiai rona i'igai, “Batanai ba hemea hafelo'a i bigi'aa ei hilalaa foigia ale'ei?” Si'ei, rona fifalagii. ");
INSERT INTO wuv_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Ma ronawe momo'idinaa a'a mei pudawerai, “O ware bata a'a mei rama'a mei? Hamatee hia na fawanewaneaa pudamu.” Mei rama'a na ware ba, “Hia hemea mamama'a.” ");
INSERT INTO wuv_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Ei Jew, rona falala'aa amana ma inana uaa, ana lomi rona nara ba inado'o pudawerai ma nawe fanunupa'i. ");
INSERT INTO wuv_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Rona i'igai, “Na'uu hamugua meni? Simeni, meni hamu'aa ware ba ina wanini pudawerai? Tani i fanunupa'i eni?” ");
INSERT INTO wuv_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Amana ma inana, laguna ware, “Haiguna aida ba na'uu haigua ma haiguna aida ba na wanini pudawerai. ");
INSERT INTO wuv_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Ma'uaa, tani i fanunupa'i eni o hini na fawanewaneia, lomi haiguna aida. I'iginia. Ina wawaneidii; ana hia i u'u.” ");
INSERT INTO wuv_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Amana ma inana, laguna ware ale'ei uaa, laguna ma'au a'a ei Jew hamatee rona waredii ba hini i ware ba Jesus, hia Christ, ro'aa fa'asi'ania a'a fei synagogue. ");
INSERT INTO wuv_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Sifei fei pa'afina lagu'aa ware amana ma inana ba, “Ina wawaneidii; i'iginia.” ");
INSERT INTO wuv_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Rona lala'idinaa mei na wanini pudawerai. Rona ware, “Uduginaa mei Haidaa. Hai'ouna aida ba mei rama'a mei, hia hafelo'a.” ");
INSERT INTO wuv_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Ina ware, “Lomi una aida ba hia hafelo'a, o lo'e. Hepalo ua manumanu una aida, ba unado'o pudawerai ma nawe fanunupa'i eni!” ");
INSERT INTO wuv_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Ma rona i'iginia, “Ina bigi'aa tamanu a'amu? Ina fawanewane batanainia fei pudamu?” ");
INSERT INTO wuv_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Ina ware, “Hei, una warefanidigaa hamu'ou ma lomi hamona guai. Tani ei ba hamo'aa guaidinia? Ba ana hamo'aa talainenegia?” ");
INSERT INTO wuv_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Ma rona warefafeloia ma ware, “Yoi hemea otalai nenerana! Hai'ou, otalai neneraa Moses! ");
INSERT INTO wuv_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Hai'ouna aida ba mei Haidaa na wareware a'a Moses ma'uaa, mei rama'a mei, ana lomi hai'ouna aida ba noramiana hitani.” ");
INSERT INTO wuv_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Mei rama'a na ware, “Fei, pa'aa poapoa manumanu! Lomi hamona aida ba noramiana hitani ma'uaa, ina fawanewaneaa pudau. ");
INSERT INTO wuv_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","O'ouna aida ba mei Haidaa, lomi i guainaa wareaa ei hafelo'a. I guai'uaiaa ei maroana, ei rona bigi'aa nunumiana. ");
INSERT INTO wuv_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Lomi hemea na u guainia ba na pa'i rama'a na fawanewaneaa hemea na wanini pudawerai. ");
INSERT INTO wuv_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Nabaa mei rama'a mei, abaa noramiana a'a mei Haidaa, lomi ba i bigipa'aa hepalo manumanu.” ");
INSERT INTO wuv_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","A'a fei, rona ware, “Yoi, ona pepesudii a'a ei hafelo'a ei oi wanini; yoi hini ba o feroinaa hai'ou!” Ma rona porosiminia ano. ");
INSERT INTO wuv_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Jesus na guainia ba rona porosiminia ano ma i nobapa'alao, ina ware, “Ona narafawe'i a'a mei Na'uu Rama'a?” ");
INSERT INTO wuv_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Mei rama'a na i'igai, “Hia hini? Warefanau ba a narafawe'i a'ana.” ");
INSERT INTO wuv_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Jesus na ware, “Ona ma'adigia ma ana meni fi warewarefipui a'amu.” ");
INSERT INTO wuv_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Mei rama'a na ware, “Mena Fasu, na we'i fei naranarau.” Ma na losuinia. ");
INSERT INTO wuv_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Jesus na ware, “Pa'afii fei noramiau yeni malagufu ba yau ale'ei fadududua, ba ei pudawerai, ronei fanunupa'i ma ei rona fanunupa'i, rowe pudawerai.” ");
INSERT INTO wuv_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Hefi'a Pharisee i a'ana, rona guainaa fei wareana fei ma i'igai, “Tamanu? Ana hai'ouna pudawerai?” ");
INSERT INTO wuv_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Jesus na ware, “Nabaa hamona pudawerai lomi ba i marapu unuu hamu'ou a'a ei hafelo'a; ma'uaa, hamatee hamona ware ba hamona fanunupa'i, ana fi marapu unuu hamu'ou. ");
INSERT INTO wuv_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","“A warefa'uai a'a hamu'ou. Mei lomi na wadu'ai wagii fei gigei, fei papa'ii ei sipsipi ma fanewadu'ai wagii hepalodiai tala, hia fafanao ma rama'aa topa'aia. ");
INSERT INTO wuv_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Mei na wadu'ai wagii fei gigei, hia oma'ama'aa ei hapena sipsipi. ");
INSERT INTO wuv_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Mei oanananaa i gigiaa fei gigei a'ana ma ei sipsipi, rona guaipa'aa laona. I harofaa haraa ei hapena ma talaiduginaa ro'ou ano. ");
INSERT INTO wuv_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Ina'aa talaiduginaa minaa ei hapena i ano, i talailao i ma'aa ro'ou ma ei hapena sipsipi, ro'aa nenegia uaa rona guai'apa'aa fei laona. ");
INSERT INTO wuv_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Ma'uaa, pa'aa lomi ba ro'aa neneraa mei lomi rona apa'ia; hi'i, ro'aa ponipa'ai a'ana uaa lomi rona guai'apa'aa fei u'ugai lao ale'ei.” ");
INSERT INTO wuv_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Jesus na warehanunuinia ale'ei ma'uaa, lomi rona tonaa fei hanuu ei wareana. ");
INSERT INTO wuv_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Si'ei, na waredilao ba, “A warefa'uai a'a hamu'ou ba yau ale'ei fei gigei wagii ei sipsipi. ");
INSERT INTO wuv_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Minaa ei ronado'o nomai i ma'au, ro'ou fafanao ma rama'aa topa'aia, ma'uaa, ei sipsipi, lomi ro'aa guainaa ro'ou. ");
INSERT INTO wuv_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Yau, ale'ei fei gigei; hini i wadu'aimai a'au, i tela. I wadu'ai ma asi'aa ma iwe labagipa'i guana. ");
INSERT INTO wuv_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Mei fafanao, i nomai ba i topa'ai ma fo'afama'e ma bigosigosiaa ei manumanu; yau, a nomai ba ei sipsipi nei pa'i harenua ma neimina rawani ua harenuaa ro'ou. ");
INSERT INTO wuv_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","“Yau mei rawani'a oma'ama'aa ei sipsipi. Mei rawani'a oma'ama'aa ei sipsipi i fanaa fei harenuana a'a ei sipsipi. ");
INSERT INTO wuv_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Mei tamelo, mei i bigitoo pono'ana, abaa oma'ama'aa ma abaa pa'aa hapena ei sipsipi. Si'ei, i ma'apa'aa fei ponotoo podu ba fi nomai i ponidi'ininaa ei sipsipi. Ma fei ponotoo podu na tetetaduaa ei sipsipi ma rona poniba'autorai. ");
INSERT INTO wuv_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Mei rama'a mei, na poni ua hamatee rona pono'uaia ma lomi na narapa'aa ei sipsipi. ");
INSERT INTO wuv_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","“Yau mei rawani'a oma'ama'aa ei sipsipi; una apa'aa ei hapeu ma ana rona apa'au— ");
INSERT INTO wuv_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","ana ale'ei ba mei Ama na apa'au ma una apa'aia—ma una fanaa fei harenuau a'a ei sipsipi. ");
INSERT INTO wuv_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Una pa'idiai hefi'a sipsipi abaa laloo feni papa'ii eni sipsipi. Unei dugamii ro'ou anaa. Ana rowe guainaa fei laou ma iwe pa'i hepalo ua gupuu ei sipsipi ma hemea ua oma'ama'aa. ");
INSERT INTO wuv_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","Pa'afii fei ba mei Amau na haguau sifei ba awe fanaa fei harenuau—ma ana awe tohadiwe'idinia. ");
INSERT INTO wuv_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Lomi nemea i tonia a'au, ana unaa yau a fania. Una pa'i forafora ba a fania ma tohadiwe'idinia. Fei warea fei, na tonia a'a mei Ama.” ");
INSERT INTO wuv_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Wagii e'ei warea e'ei, ei Jew, rona fifalagidiai. ");
INSERT INTO wuv_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Watauda ro'ou na ware, “Ina wadu'ia pigea ma namina poapoai. Tani o guainia?” ");
INSERT INTO wuv_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Ma'uaa, hefi'adiai, rona ware, “Ei warea ale'ei, abaa wareaa hemea na wadu'ia pigea. Haa, fei pigea ana i fawanewanepa'aa hemea pudawerai?” ");
INSERT INTO wuv_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Yei Jerusalem inawe nopa'aloo fei au Hananaa wagii fei humuu mei Haidaa. Fei au fei, au waiwana ma lalarena ");
INSERT INTO wuv_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","ma Jesus yei malalaa fei humuu mei Haidaa fi tatalai papaa ei Palee Solomon. ");
INSERT INTO wuv_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Ei Jew, rona hoaninia ma ware, “Namina madii fei fawansufaiamu naranaraa hai'ou? Nabaa yoi mei Christ, fa'arewaia a'a hai'ou.” ");
INSERT INTO wuv_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Jesus na ware, “Una warefanadigaa hamu'ou ma'uaa, lomi hamona nara ba fa'ua. Ei foigia una bigi'ia a'a fei haraa mei Amau, na u'ufanaa hamu'ou ba yau hini ");
INSERT INTO wuv_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","ma'uaa, lomi hamona narafawe'i uaa, hamu'ou, abaa hapeu sipsipi. ");
INSERT INTO wuv_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Ei hapeu sipsipi, rona guainaa fei laou; una apa'aa ro'ou ma rona nenerau. ");
INSERT INTO wuv_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","A'a ro'ou, una fani harenua lomi i pedutoo ma pa'aa lomi ro'aa pa'ai; lomi nemea i raputarapa'aa ro'ou i paniu. ");
INSERT INTO wuv_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Mei Amau, mei na fanaa ro'ou a'au, na muainaa minaa ei manumanu, lomi nemea i raputarapa'aa ro'ou i panii mei Amau. ");
INSERT INTO wuv_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Yau ma mei Ama, haigua hemea ua.” ");
INSERT INTO wuv_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Ei Jew, rona'aa haudinaa ei mugoo ba ro'aa nafa'ia ");
INSERT INTO wuv_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","ma'uaa, Jesus na warefanaa ro'ou, “Una bigidigaa watauda rawani'a foigia noramiaa ro'ou a'a mei Ama. Afaia a'a ei foigia ba hamo'aa nafa'au wagina?” ");
INSERT INTO wuv_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Rona ware ei Jew ba, “Lomi hai'ou'aa nafa'io wagii hepalo ei, ma'uaa, si'ei ba ona warefafeloaa mei Haidaa. Uaa yoi, rama'a ua ma'uaa, ona ware ba yoi mei Haidaa.” ");
INSERT INTO wuv_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Jesus na warefanaa ro'ou, “Rona ne'inia laloo fei Law hamu'ou ba mei Haidaa na ware ale'ei ba, ‘Una ware ba hamu'ou haidaa’. ");
INSERT INTO wuv_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Hamona aida ba lomi hepalo tata laloo fei Bu'u Apuna. Ma nabaa ei rona tonaa fei Bu'u Apuna, ina ware ba ro'ou ale'ei ‘haidaa’, ");
INSERT INTO wuv_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","lo'e manumanu nabaa mei Ama na ware ale'ei a'a mei au'u'ugaiana ba pa'aa manumanuna, mei aloagiana yeni malagufu. Si'ei, tani hamu'ou ware ba una warefafeloaa mei Haidaa si'ei ba una ware ba, ‘Yau Na'uu mei Haidaa’? ");
INSERT INTO wuv_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Apuna nara ba fa'ua ei wareau nabaa lomi una bigi'aa tamanu ana na bigi'ia mei Amau. ");
INSERT INTO wuv_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Una bigi'aa e'ei ma lomi hamona narafawe'i a'au. Ma'uaa, ei bigi'au foigia uni'unina ba hamonei aida ma apa'ia ba mei Ama, hia laloo iau ma yau a'ana.” ");
INSERT INTO wuv_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Rona manidinia ba ro'aa panarofia, ma'uaa ina bi'a'afaa ro'ou ma ponidi'ininaa ro'ou. ");
INSERT INTO wuv_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Ma i dii, Jesus na hadiwe'idinaa pepei Jordan fawelei i pudugufinaa ei rama'a wagina mina John. Ma ina guta yei ");
INSERT INTO wuv_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","ma watauda rama'a, rona nomai a'ana. Rona ware, “John, lomi na bigi'aa hepalo hilalaa foigia, ma'uaa minaa ei u'ugana meni rama'a meni, pa'aa fa'ua.” ");
INSERT INTO wuv_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Ma yei fawelei, watauda, rona narafawe'i a'a Jesus. ");
INSERT INTO wuv_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Ma hemea rama'a na funu, harana Lazarus. Gufuna, Bethany, fei gufuu Mary ma mei tafina, Martha. ");
INSERT INTO wuv_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Mei agii Lazarus, mei na funuhaino, harana Mary. Ana mei i igiaa fei dufaa pao tabaa mei Fasu ma hugunaa pinena a'a ei loaa tabana. ");
INSERT INTO wuv_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Si'ei, laguei fitafii, laguna alo wareaa lagua a'a Jesus, “Mena Fasu, mei ona haguia na funu.” ");
INSERT INTO wuv_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","I guainaa fei, Jesus na ware, “Fei funua fei, lomi ba i fama'eia. Agia, fei pa'afina, sifei ba i tonaa hawerana mei Haidaa ba mei Na'uu mei Haidaa, ana nei tonaa hawerana wagina.” ");
INSERT INTO wuv_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Jesus na haguaa Martha ma mei tafina mawe Lazarus. ");
INSERT INTO wuv_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Ma'uaa, i guainia ba Lazarus na funu, na guta ua guaidiai arewaa yei. ");
INSERT INTO wuv_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","I dii, inawe warenaa a'a ei otalai nenerana, “O dii, o hadiwe'inaa Judea.” ");
INSERT INTO wuv_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Rona ware, “Rabbi, haiga ua ei ba ro'aa nafanaa yoi mugoo yei ei Jew. Ma ba o hadiwe'idilao?” ");
INSERT INTO wuv_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Jesus na ware, “Haa, a'a ba na we'a ale'ei hefua ma guai hour laloo hepalo arewaa? Mei na talai laloo fei arewaa, lomi ba i tetei'alabe, uaa ina fafanunupa'i a'a fei we'ai feni malagufu. ");
INSERT INTO wuv_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Nabaa i talai na poi, iwe tetei'alabe, uaa lomi we'aina.” ");
INSERT INTO wuv_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","I waredigaa fei, ina waredilao a'a ro'ou, “Mei tafii o'ou Lazarus, na ma'igu, ma'uaa yau ba a dinaa a'ana ma funifunia.” ");
INSERT INTO wuv_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Ei otalai nenerana na ware, “Mena Fasu, nabaa ina ma'igu iwe rawanidiai.” ");
INSERT INTO wuv_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Jesus na hanuinaa fei ma'eana, ma'uaa ei otalai nenerana, rona nara ba fi ware ba inapa'aa ma'igu. ");
INSERT INTO wuv_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Si'ei, inawe fa'arewaia a'a ro'ou, “Lazarus na ma'e. ");
INSERT INTO wuv_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Ma una ni'e ba yau lomi yei ba hamonei narafawe'i. Ma'uaa, o'aa dinaa a'ana.” ");
INSERT INTO wuv_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Ma Thomas (ana harana Didymus) na warenaa a'a ei otalai nenera, “Ana o'aa di ma ma'efipui a'ana.” ");
INSERT INTO wuv_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","I nopa'aloo yei, Jesus nawe apa'ia ba Lazarus na hainodii laloo huapu ale'ei obao arewaa. ");
INSERT INTO wuv_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Hafalaree Bethany a'a Jerusalem ale'ei oduai kilometre. ");
INSERT INTO wuv_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Ma watauda Jew, rona dinaa a'a Martha ma Mary ba ro'aa faloloa'ifipui a'a lagua wagii fei pa'aiaa mei agii lagua. ");
INSERT INTO wuv_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","I guainia Martha ba fi nomai Jesus, ina asi'alao ba iree ma'aia, ma'uaa Mary na guta ua humu. ");
INSERT INTO wuv_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Martha na warenaa a'a Jesus ba, “Mena Fasu, nabaa yoi yeni, lomi i ma'e mei agiu. ");
INSERT INTO wuv_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Ma'uaa, una aida ba ana e'eni, mei Haidaa i fanio tamanu o i'iginia.” ");
INSERT INTO wuv_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Jesus na warenaa a'ana, “Mei agimu iwe mama'adiai.” ");
INSERT INTO wuv_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Martha na ware, “Una aida ba iwe mama'adiai a'a fei au asi'ana wagii fei a'apoo arewaa.” ");
INSERT INTO wuv_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Jesus na warenaa a'ana, “Yau ana fei asi'ana ma fei harenua. Hini i narafawe'i a'au, iwe pa'i harenuana nabaa i ma'e; ");
INSERT INTO wuv_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","ma hini i guta ma narafawe'i a'au lomi iwe ma'e. Naramu ba fa'ua fei?” ");
INSERT INTO wuv_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Ina warefania ba, “Hi'i, mena Fasu. Una nara ba yoi mei Christ, mei Na'uu mei Haidaa, mei ba na nomai a'a feni malagufu.” ");
INSERT INTO wuv_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","I waredigaa fei, na hadiwe'ai ma dugi'u'uginaa mei tafina Mary. Ma na ware, “Mei Feroia, hia yeni ma fi i'iginio.” ");
INSERT INTO wuv_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","I guainaa fei Mary, na asi'abatafa ma dinaa a'ana. ");
INSERT INTO wuv_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Ma Jesus, atawe wadu'ainaa fei gufu, ma'uaa hia ana fawelei i di'ininia Martha. ");
INSERT INTO wuv_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Ei Jew, ei rona gutafaloloa'ifipui a'a Mary laloo fei humu, ro'aa fanunupa'ia ba na asi'abatafa ma dinaa ano, rona nenegia, uaa rona nara ba i dinaa a'a fei huapu ma ai'ai yei. ");
INSERT INTO wuv_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Mary, i nopa'aloo fawelei wagina Jesus ma ma'apa'ia, na fapasi pinena ma ware, “Mena Fasu, nabaa yoi yeni, lomi i ma'e mei agiu.” ");
INSERT INTO wuv_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","I ma'apa'ia Jesus ba na ai'ai ma ei Jew, ei ro'aa nofipuimai a'ana, ana rona ai'ai, namina fi'i naranarana ma naranara watauda. ");
INSERT INTO wuv_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Ina i'igai, “Hamona fahainopia hitani?” Rona ware, “Mi ma'a, mena Fasu.” ");
INSERT INTO wuv_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Jesus na ai. ");
INSERT INTO wuv_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Ma ei Jew, rona ware, “Ma'aia, te inapa'aa haguia!” ");
INSERT INTO wuv_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Ma'uaa, hefi'a ro'ou, rona ware, “Mei i fawanewaneaa mei pudawerai, tani lomi i bigi'ia ale'ei ba mei rama'a mei nei'aa ma'e?” ");
INSERT INTO wuv_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Jesus namina faloloa'idiai ma nomai a'a fei huapu. Fei huapu ale'ei walawala a'a fei na'a ma na pa'i mugoo i poaa wawadu'ina. ");
INSERT INTO wuv_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Ina ware, “Pigusiminaa fei mugoo.” Martha, mei agii mei ma'ea na ware, “Ma'uaa, mena Fasu, e'eni namina wafuu, uaa ina hainodii yei obao arewaa.” ");
INSERT INTO wuv_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Ma Jesus na ware, “Haa, lomi una warefanio ba nabaa ona narafawe'i, owe ma'a fei haweraa mei Haidaa?” ");
INSERT INTO wuv_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Si'ei, rona pigusiminaa fei mugoo. Ma Jesus na aranaa pafea ma ware, “O'ama, a ware ‘ta’ a'amu uaa ona guaidigau. ");
INSERT INTO wuv_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Una aidadii ba ona'o guainau, ma'uaa una wareaa fei ba i hadumaa ei rona ufalarai yeni ba ronei aida ba onapa'aa aloagiau.” ");
INSERT INTO wuv_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","I waredigaa fei, Jesus na warefabauanai, “Lazarus, lele'amai!” ");
INSERT INTO wuv_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Mei ma'ea na lele'amai. Panina ma pinena, rona sumia a'a ei lawalawa ma na pa'i lawalawa pudana. Jesus na warenaa a'a ro'ou, “Alaraa ei lawalawaa ma'ea ma fatalainia.” ");
INSERT INTO wuv_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Si'ei, watauda ei Jew, ei rona nomai a'a Mary ma ma'apa'aa tamanu na bigi'ia Jesus, rona narafawe'i a'ana. ");
INSERT INTO wuv_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Ma'uaa, hefi'a ro'ou na dinaa a'a ei Pharisee ma u'ufanaa ro'ou tamanu na bigi'ia Jesus. ");
INSERT INTO wuv_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Ma ei famamoaa humuu mei Haidaa mawe ei Pharisee, rona harofaa hepalo gutafiwareiaa ei Sanhedrin. Rona i'igai, “Otawe bigi'aa hepalo manumanu a'ana. Mei rama'a mei na bigi'aa watauda hilalaa foigia. ");
INSERT INTO wuv_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Nabaa o ma'a'au'uaia ale'ei, minaa ei rama'a ro narafawe'i a'ana ma ei rama'aa Rome, ro'aa nomai ma tonaa ei bigi'aa o'ou ma fei gufuu o'ou.” ");
INSERT INTO wuv_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Ma hemea ro'ou, harana Caiaphas, hia mei pa'aa bauaniaa humuu mei Haidaa laloo fei igisimasi fei ma na ware, “Lomi hamona apa'aa hepalo manumanu! ");
INSERT INTO wuv_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Lomi hamona aida ba i rawaninaa hamu'ou nabaa hemea ua i ma'e laraa fei ba minaa ei rama'aa gufu, ro'aa ma'e?” ");
INSERT INTO wuv_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Fei warea fei, abaa pa'aa wareana, hamatee hia mei pa'aa bauaniaa humuu mei Haidaa fei igisimasi fei ma si'ei nadii wareia ba Jesus, iwe ma'e uaa fei gufuu ei Jew. ");
INSERT INTO wuv_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Ma abaa unaa fei gufu fei, ma'uaa a'a ei na'uu mei Haidaa, ana ei rona guta wagii hepapalo gufu ba i papa'ifipuinaa ro'ou ale'ei hepalo. ");
INSERT INTO wuv_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","A'a fei arewaa fei ma nolao, rona fiwarei ba ro'aa fo'afama'eia. ");
INSERT INTO wuv_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Si'ei, Jesus, lomidiai ba i tatalai i pudaa ei Jew. Ma'uaa ina di'ininaa ro'ou ma dinaa fei gufu harana Ephraim, fawelei lomi haihai o guana. Ma na gutafipui a'a ei otalai nenerana yei. ");
INSERT INTO wuv_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","I norafi'imai fei Hananaa fei Talai Falogiaa ei Jew, watauda noramiaa ro'ou rauaa, rona dinaa Jerusalem ba rodo'o fesufa'arainaa unuu ro'ou ale'ei fei mau losuiaa ro'ou ma hinene, fei Talai Falogia. ");
INSERT INTO wuv_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Ana ro'ei lalabaginaa Jesus ma ei ro'ei u i malalaa fei humuu mei Haidaa, rona fi'i'igai ba, “Tamanu naramu? Haa, pa'aa lomi i nomai a'a fei Hananaa?” ");
INSERT INTO wuv_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Ma'uaa ei famamoaa humuu mei Haidaa mawe ei Pharisee, ronadii wareia ba nabaa nemea i labagipa'aa Jesus, inei warefa'aiaa ro'ou ba ro'aa panarofia. ");
INSERT INTO wuv_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Oloroa arewaa dufu ba i pa'aa fei Talai Falogia ma Jesus na dinamii Bethany, fei gufuu Lazarus, mei na famama'aia wagii fei ma'ea Jesus. ");
INSERT INTO wuv_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Ma rona bigi'aa hepalo hananaa ba ro'aa farawaninaa Jesus. Martha na hasumaa ei du'ua ma Lazarus, hia hemea ei na gutafapalagi a'a fei tawaa du'ua. ");
INSERT INTO wuv_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Ma Mary na tonaa ale'ei hesuwi litre nard, hepalo pa'aa dufaa pao, fei na rata pono'ana ma na igia pinee Jesus ma huguaa pinena a'a ei loaa tabana. Ma namina malelefarawani fei humu wagii fei dufaa pao. ");
INSERT INTO wuv_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Ma'uaa hemea ei otalai nenerana, Judas Iscariot, mei ba i aloia, na siba ba, ");
INSERT INTO wuv_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","“Tani lomi ona aloaa fei pao dufa ma ei mugoo po'ina o fanaa ei lomi manumanu? Pono'ana, ale'ei pono'aa hemea laloo heai igisimasi.” ");
INSERT INTO wuv_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Fei wareana fei, abaa na narapa'aa ei lomi manumanu, hamatee hia, fafanao; ina'aida oma'aiaa fei ude'udee mugoo po'i ma na'o toto'uaia. ");
INSERT INTO wuv_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Jesus na ware, “Apuna papa'aa mei pifine mei. Fei pao dufa i utofa'ainau nopa'aloo fei i'ifaiau. ");
INSERT INTO wuv_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Ranimai, ei lomi manumanu, ro'ou a'a hamu'ou, ma'uaa lomi ba a oa a'a hamu'ou ranimai. ");
INSERT INTO wuv_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","I dii, hepalo baua gupuu ei Jew, ronawe guainia ba Jesus, hia yei ma rona nomai ba ro'aa ma'aia ma ana ba ro'aa ma'a Lazarus, mei ina fa'asi'ania a'a fei ma'ea. ");
INSERT INTO wuv_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Si'ei, ei famamoaa humuu mei Haidaa, ronawe nara ba ana ro'aa fo'afama'eaa Lazarus, ");
INSERT INTO wuv_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","uaa hamatee hia, watauda ei Jew rona dinaa a'a Jesus ma narafawe'i a'ana. ");
INSERT INTO wuv_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","I no'arewadilao, fei baua gupuu rama'a na nomai a'a fei Hananaa ma guainia ba Jesus fi dinaa Jerusalem. ");
INSERT INTO wuv_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Rona tonaa ei ale'ei rau niu ma dinaa a'ana ma harofabauanai, “Hosanna!” “Na pa'i hawegiana mei i nomai a'a fei haraa mei Fasu!” “Na pa'i hawegiana mei Haparaa ei Israel!” ");
INSERT INTO wuv_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Jesus na bapa'aa hepalo baubara donkey ma na hugi pafona, ale'ei ronadii ne'inia, ");
INSERT INTO wuv_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","“Apuna ma'au, ena baduu pifine Zion; ma'aia, mei haparaa hamu'ou na guta ma ponimai, pafoo hepalo baubara donkey.” ");
INSERT INTO wuv_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Do'o fama'a ei otalai nenerana, lomi rona aida hanuu e'ei. Nenee fei i todigaa fei hawerana Jesus, ronawe aida ba na udedii fei ne'ia wagii ei bigi'aa ro'ou a'ana. ");
INSERT INTO wuv_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Ma fei gupuu rama'a i a'ana ei i fa'asi'anaa Lazarus a'a fei huapu, rona'u u'ugia. ");
INSERT INTO wuv_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Watauda na dinaa a'ana, uaa rona guainia ba na bigi'aa fei hilalaa foigia fei. ");
INSERT INTO wuv_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Si'ei, ei Pharisee na fiwarewarei ba, “Do'o naraia. A'a fei, minaa ei rama'aa feni ano, rona aununaa a'ana!” ");
INSERT INTO wuv_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Ma na pa'i hefi'a Greece dupuaa ei ba ro'aa losui wagii fei Hananaa. ");
INSERT INTO wuv_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Rona bapa'aa Philip, mei gufuna Bethsaida yei Galilee ma na pa'i i'igaiaa ro'ou a'ana. Rona ware, “Hagu'u, ba hai'ou ma'a Jesus.” ");
INSERT INTO wuv_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Philip naree warefanaa Andrew; Andrew mawe Philip, lagunaree warefanaa Jesus. ");
INSERT INTO wuv_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Jesus na ware, “Ina nodigimai fei pa'aa au ba i to hawerana mei Na'uu Rama'a. ");
INSERT INTO wuv_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","A warefa'uai a'a hamu'ou ba hepalo lau wheat, nabaa lomi i do'o pasinaa malagufu ma ma'e, i ude'ualao ale'ei hepalo lau ua. Ma'uaa, nabaa ido'o ma'e, iwe pa'i wataudadiai lau. ");
INSERT INTO wuv_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Mei rama'a, mei i pa'aa haguaa fei harenuana, iwe pa'ai a'ana, ma'uaa mei i fabidinaa ununa fei harenuana yeni ano, iwe pa'ia a'a fei harenua lomi i pedutoo. ");
INSERT INTO wuv_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Hini ba i nafii a'au, inei nenerau; ma na'aa yau hitani, mei nafiu ana hia yei. Hini mei i nafii a'au, mei Amau iwe fani honua a'ana. ");
INSERT INTO wuv_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","“E'eni unamina naranara watauda ma ba a ware batanai? Ale'ei ba ‘Mena Amau, hadumau a'a feni au feni’? Lo'e, sifei fei pa'afina ba na nopa'amii feni au feni. ");
INSERT INTO wuv_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","O'ama, uduginaa fei haramu!” Hepalo lao na norai pafea, “Una udugidigia ma awe udugidinia.” ");
INSERT INTO wuv_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Fei gupuu rama'a yei na guainia ba ale'ei ba'aa parara; hefi'adiai, rona ware ba hemea alo'alo na wareware a'ana. ");
INSERT INTO wuv_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Jesus na ware, “Fei lao fei, fararawanii hamu'ou, a'a ba fararawaniu. ");
INSERT INTO wuv_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","E'eni, au dududuaa feni ano; e'eni a tetefa'asi'anaa mei haparaa feni ano. ");
INSERT INTO wuv_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Ma'uaa ena una fatawa yeni malagufu, awe foraiamii minaa ei rama'a a'au.” ");
INSERT INTO wuv_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Na wareaa fei ba i fa'arewaia batanai fei mau ma'eana. ");
INSERT INTO wuv_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Fei gupuu rama'a, rona ware, “Hai'ouna guainia a'a fei Law ba mei Christ, iwe oamai ranimai ranimai ma si'ei, tani o ware ba ‘Mei Na'uu Rama'a nei fatawa’? Hini mei ‘Na'uu Rama'a’ mei?” ");
INSERT INTO wuv_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Ma Jesus na warefanaa ro'ou, “Lomi i madii ma fena we'ai a'a hamu'ou i aunu. Hamoneido'o tatalai ena ana hamofi pa'i we'ai, ena ataa nomai fei roromaa. Mei na tatalai wagii fei roromaa, lomi na aida ba i dinaia. ");
INSERT INTO wuv_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Augaa ei naranaraa hamu'ou a'a fei we'ai ei fido'o ude i a'a hamu'ou ba hamo'aa oanaa na'uu fei we'ai.” I waredigaa e'ei Jesus, ina aunu ma opa'ai a'a ro'ou. ");
INSERT INTO wuv_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Jesus na bigi'aa ei hilalaa foigia i pudaa ro'ou, ma'uaa ana lomi rona narafawe'i a'ana. ");
INSERT INTO wuv_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Ina ale'ei, ba ei wareaa mei mamama'a Isaiah nei pa'aa fa'uai: “Mena Fasu, hini na nara ba fa'ua ei wareaa hai'ou? Ma a'a hini na fama'aiaa fei panina mei Fasu?” ");
INSERT INTO wuv_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","A'a fei, lomi rona narafawe'i, uaa ana ale'ei ei wareaa Isaiah hefawala ba: ");
INSERT INTO wuv_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","“Ina fapudawerainaa ro'ou ma fama'eaa ei naranaraa ro'ou ba ronei'aa fanunupa'i, o narapa'i, o momo'ai ba a fawanewaneaa ro'ou.” ");
INSERT INTO wuv_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Isaiah na ware ale'ei hamatee ina fanunudii fei haweraa Jesus ma na u'ugia. ");
INSERT INTO wuv_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Ma'uaa a'a fei au fei, watauda rona narafawe'i a'ana, ana dupuaa ei bauana. Ma'uaa lomi rona ware ba rona narafawe'i, hamatee rona mama'au ba ei Pharisee, ro'aa fa'asi'anaa ro'ou a'a fei synagogue; ");
INSERT INTO wuv_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","uaa ronamina nunuminaa fei udugiaa ei rama'a laraa fei udugiaa mei Haidaa. ");
INSERT INTO wuv_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","I dii, Jesus na harofabauana, “Nabaa nemea i narafawe'i a'au, abaa ina narafawe'i ua i a'au, ma'uaa a'a mei na aloagiau anaa. ");
INSERT INTO wuv_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Ena na fanunuau, ina fanunupa'aa mei na aloagiau. ");
INSERT INTO wuv_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Una nomai a'a feni ano ale'ei we'ai ba hini i narafawe'i a'au, lomi ba i oa a'a fei roromaa. ");
INSERT INTO wuv_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","“Mei i guainaa ei wareau ma lomi i nenegia, lomi a dududuia. Uaa fei noramiau, a'a ba a dududuaa feni ano, ma'uaa ba a fatela'ania. ");
INSERT INTO wuv_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Na pa'i hemea ba i dududuaa mei i ofadugau ma lomi na guainaa wareau; ei unadii wareia, ana si'ei iwe dududuia a'a fei a'apoo arewaa. ");
INSERT INTO wuv_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Uaa abaa fi wareaa ana yau, ma'uaa mei Ama, mei na aloagiau, nadii warefanau tamanu nei wareia ma batanai na wareia. ");
INSERT INTO wuv_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Una aida ba ei wareana i fani harenua lomi i pedutoo. Si'ei, tamanu na wareia, ana fi wareaa ei warefanaa mei Ama yau.” ");
INSERT INTO wuv_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","E'eni, anaa i pa'aa fei Hananaa fei Talai Falogia. Jesus na aida ba na nodigimai fei au ba i di'ininaa feni malagufu ma dinaa a'a mei Ama. Ina haguaa ei maroana yeni malagufu ma e'eni i fama'aiaa ro'ou ba namina bauana fei haguana ro'ou. ");
INSERT INTO wuv_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Roi hasumaa ei finei fei fafi ma mei hani'u na fanidii naranaraa Judas Iscariot mei na'uu Simon ba nei aloaa Jesus. ");
INSERT INTO wuv_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Jesus na aidadii ba mei Ama na audigaa minaa ei manumanu haroo fei faufauna ma ba hia, noramiana a'a mei Haidaa ma ba iwe hadiwe'inaa a'a mei Haidaa; ");
INSERT INTO wuv_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","si'ei ina asi'aa a'a fei hananaa, dudumaa fei hawaa uguna ma mo'inaa fei huguu unu walana. ");
INSERT INTO wuv_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Nenee fei, ina igi ranu laloo hepalo pe'ii ranu, na fesuaa pinee ei otalai nenerana ma huguaa pinee ro'ou wagii fei mo'iana huguu unu. ");
INSERT INTO wuv_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Ina dinaa a'a Simon Peter ma Peter na ware a'ana ba, “Mena Fasu, ba o fesuaa pineu?” ");
INSERT INTO wuv_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Jesus na ware, “Lomi ona aida ba a bigi'aa tamanu, ma'uaa hinene owe aida.” ");
INSERT INTO wuv_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Na ware Peter, “Lo'e. Pa'aa lomi ba owe fesuaa pineu.” Jesus na ware, “Nabaa lomi a fesuaa pinemu, ana lomi yoi a'au.” ");
INSERT INTO wuv_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Simon Peter na ware, “Nadii, mena Fasu, abaa unaa fei pineu, ma'uaa paniu ma tabau anaa.” ");
INSERT INTO wuv_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Jesus na ware, “Nabaa nemea na nunudii, inei fesu ua pinena; minaa ei ununa na fafa'araidii. Hamona fafa'arai, ma'uaa a'a ba minaa hamu'ou.” ");
INSERT INTO wuv_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Uaa, ina aida ba hini iwe aloia ma si'ei i ware ale'ei ba a'a ba minaa ro'ou na fafa'arai. ");
INSERT INTO wuv_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","I fesudigaa pinee ro'ou, na rafeaa fei hawaa uguna ma hadiwe'idinaa fei gutanana. Ina i'iginaa ro'ou, “Hamona aida ba tamanu fei a bigi'ia a'a hamu'ou? ");
INSERT INTO wuv_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Hamona harofau ba, ‘Feroia’ ma ‘Fasu’ ma na wanewane fei, uaa yau ale'ei. ");
INSERT INTO wuv_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Si'ei ba yau Fasu ma Feroiaa hamu'ou, una fesuaa pinee hamu'ou. Ma hamonei fesuaa pinee ana hamu'ou. ");
INSERT INTO wuv_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Una bigi'aa fei i pudaa hamu'ou ba hamonei bigi'ia a'a ana hamu'ou ana ale'ei a bigi'ia a'a hamu'ou. ");
INSERT INTO wuv_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","A warefa'uai a'a hamu'ou ba mei tamelo, lomi i muainaa mei fasuna ma mei talaitonaa warea, lomi i muainaa mei na aloia. ");
INSERT INTO wuv_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","E'eni hamona aidadii e'ei ma hamowe to hawegia nabaa hamo'aa bigi'ia. ");
INSERT INTO wuv_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","“A'a ba u'eimina warenaa minaa hamu'ou; una aida ba hini ei rafeiau. Ma'uaa hefeni ba i fafa'uainaa fei Bu'u Apuna: ‘Mei i hananafipui a'a fei hanau faraa pidaua na fadugeau.’ ");
INSERT INTO wuv_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","“A warefani'augaa hamu'ou eni atawe migimigii uaa ena nawe sufudai, hamowe apa'ia ba yau Mei. ");
INSERT INTO wuv_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","A warefa'uai a'a hamu'ou ba hini i ugainaa mei i aloagiau, ana na ugainau ma hini i ugainau, ana na ugainaa mei i aloagiau.” ");
INSERT INTO wuv_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","I waredigaa fei Jesus, namina fi'i laloo spiritina ma na ware ba, “A warefa'uai a'a hamu'ou ba hemea hamu'ou i fifaninau panii hefi'a.” ");
INSERT INTO wuv_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Ei otalai nenerana, rona fifanunui ma pa'aa lomi rona aida ba fi wareaa hini ro'ou. ");
INSERT INTO wuv_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Hemea ro'ou, mei na haguia Jesus, ina gutafapalagi papana. ");
INSERT INTO wuv_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Simon Peter na fabiyeinaa tabana a'a mei ma ware, “I'iginia ba hini.” ");
INSERT INTO wuv_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Ina farafi'idilao a'a Jesus ma i'iginia, “Mena Fasu, hini mei?” ");
INSERT INTO wuv_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Jesus na ware, “Mena una fania feni faraa pidaua ena na pudigia laloo fei pe'i.” Ma i pudidigaa fei faraa pidaua, na fanaa Judas Iscariot, mei na'uu Simon. ");
INSERT INTO wuv_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Ana ei i tonaa fei faraa pidaua Judas, na wadu'ia Satan. Jesus na warefania, “Fei ba o bigi'ia, bigibatafainia.” ");
INSERT INTO wuv_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Ma'uaa lomi hemea a'a fei hananaa na aida ba tani i ware ale'ei a'ana Jesus. ");
INSERT INTO wuv_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Si'ei ba Judas na'o oma'aiaa ei mugoo po'i, rona nara hefi'a ba Jesus fi warefania tamanu nei pono'ia wagii fei Hananaa, o ba nei fani manumanu a'a ei lomi rona pa'i. ");
INSERT INTO wuv_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","I todigaa fei faraa pidaua, na asi'anaa ano. Ma poi ei. ");
INSERT INTO wuv_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","I aunudii, Jesus na ware, “E'eni mei Na'uu Rama'a i tonaa fei hawera ma mei Haidaa ana i to hawera a'ana. ");
INSERT INTO wuv_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Nabaa mei Haidaa na to hawerana uaa hia, ana iwe haweginaa mei Na'u ma i haweginia e'eni ua. ");
INSERT INTO wuv_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","“Ena na'uu, lomi i madii gutanau a'a hamu'ou. Hamowe lalabaginau ma ana ale'ei ei wareau a'a ei Jew, eni a warefanaa hamu'ou: Fei ba a dinaa wagina, lomi hamowe nopa'ilao. ");
INSERT INTO wuv_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","“Hepalo manufau warea a fanaa hamu'ou: Hamonei fihagui. Ana ale'ei una haguaa hamu'ou, hamonei fihagui. ");
INSERT INTO wuv_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","A'a fei, minaa ei rama'a, rowe aida ba hamu'ou otalai nenerau; nabaa hamona fihagui.” ");
INSERT INTO wuv_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Simon Peter na i'iginia, “Mena Fasu, o dinaia?” Jesus na ware, “Fei ba a dinaa wagina, lomi hamo'aa nenerau e'eni, ma'uaa hamowe nomai hinene.” ");
INSERT INTO wuv_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Peter na i'igai, “Mena Fasu, tani lomi a nenegio eni? Lo'e manumanu nabaa a ma'e uaa yoi.” ");
INSERT INTO wuv_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Jesus nawe ware, “Haa, pa'aa fa'ua ba o'aa ma'e uaa yau? A warefa'uai a'amu ba i odupoai wareamu ba lomi ona apa'au ma hinene i ai fei a'aroo! ");
INSERT INTO wuv_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","“Apuna naranara watauda. Narafawe'i a'a mei Haidaa; ana narafawe'i a'au. ");
INSERT INTO wuv_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Laloo fei humuu mei Amau na pa'i watauda nopa; nabaa abaa ale'ei, una warefa'aidigaa hamu'ou. Yau ba a dinaa yei ma pagi'aufani gutanaa hamu'ou. ");
INSERT INTO wuv_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Ma nabaa a aunu ma pagi'aufanidii gutanaa hamu'ou, awe hadiwe'idimai mi dugaa hamu'ou ba hamonei oafipui a'au. ");
INSERT INTO wuv_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Hamona aidadii fei tala i dinaa fawelei ba a dinaa wagina.” ");
INSERT INTO wuv_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Thomas na warenaa a'ana, “Mena Fasu, lomi hai'ouna aida ba o dinaia ma si'ei, hai'ou apa'ibatanainia fei tala?” ");
INSERT INTO wuv_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Jesus na ware, “Yau ana fei tala, fei fa'uaia ma fei harenua. Lomi nemea i talawa'au ma dinaa a'a mei Ama. ");
INSERT INTO wuv_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Nabaa hamona apa'ifarawaninau, ana hamo'aa apa'aa mei Amau. E'eni ma nolao, hamona apa'ia ma hamona fanunudigia.” ");
INSERT INTO wuv_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Philip na ware, “Mena Fasu, fama'aiaa hai'ou mei Ama ma sifei ua i hawiaa hai'ou.” ");
INSERT INTO wuv_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Jesus na ware, “Haa, minaa fei madii gutanau a'a hamu'ou ma ana otaa apa'au, Philip? Hini na fanunudigau, ana na fanunudigaa mei Ama. Tani o ware ba, ‘Fama'aiaa hai'ou mei Ama’? ");
INSERT INTO wuv_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Lomi hamona nara ba yau na oafipui a'a mei Ama ma hia i laloo iau? Ei wareau a'a hamu'ou, abaa warea unaa yau ua. Agia, mei Ama, mei na oafipui a'au, hia mei fi bigi'aa fei bigi'ana. ");
INSERT INTO wuv_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Hamonei nara ba fa'ua ei wareau ba una oafipui a'a mei Ama ma hia laloo iau ma nabaa lomi hamona narapa'aa fei, hamonei nara ba fa'ua hamatee na unifanaa hamu'ou ei foigia. ");
INSERT INTO wuv_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","A warefa'uai a'a hamu'ou ba hini i narafawe'i a'au, ana iwe bigi'aa tamanu una bigi'ia. Ma iwe bigi'aa hefi'a manumanu i muainaa e'ei, uaa yau, a dinaa a'a mei Ama. ");
INSERT INTO wuv_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Ma awe bigi'aa tamanu ona i'igainia a'a fei harau ba mei Na'u nei fani hawera a'a mei Ama. ");
INSERT INTO wuv_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Na rawani ba hamo'aa i'igainaa tamanu a'a fei harau ma a bigi'ia. ");
INSERT INTO wuv_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","“Nabaa hamona haguau, bigi'aa tamanu una wareia. ");
INSERT INTO wuv_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Ma awe i'iginaa mei Ama ma iwe fanaa hamu'ou hemeadiai Aweia ba i oafipui a'a hamu'ou minaa ena ranimai— ");
INSERT INTO wuv_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","fei Spiritii fa'uaia. Feni ano, pa'aa lomi i tonia, uaa lomi na fanunupa'ia ma ana lomi na apa'ia. Ma'uaa hamu'ou, hamona apa'ia uaa ina oafipui a'a hamu'ou ma ipowe oa laloo iaa hamu'ou. ");
INSERT INTO wuv_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Lomi a di'ininaa hamu'ou ale'ei ei baduu lomi ama ma inaa ro'ou; awe nomai a'a hamu'ou. ");
INSERT INTO wuv_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Lomi i madii ma feni ano i ma'aguguminau, ma'uaa hamu'ou, hamo'aa fanunupa'au. Si'ei ba una gutaguta, ana hamo'aa gutaguta. ");
INSERT INTO wuv_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","A'a fei arewaa fei, hamopowe aida ba una oafipui a'a mei Ama ma hamu'ou a'au ma Yau, i laloo iaa hamu'ou. ");
INSERT INTO wuv_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Hini i tonaa ei wareau ma nenegia, simei, mei na haguau. Mei na haguau ana i haguia mei Amau ma Yau ana a haguia ma fa'arewaiau a'ana.” ");
INSERT INTO wuv_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","I dii, Judas (abaa Judas Iscariot), na ware, “Ma'uaa, Mena Fasu, tani o fa'arewaio a'a hai'ou ma a'a feni ano lomi?” ");
INSERT INTO wuv_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Jesus na ware, “Hini i haguau, nei neneraa ei feroiau. Mei Amau, iwe haguia ma haigu'aa nomai a'ana ma oafipui a'ana. ");
INSERT INTO wuv_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Hini lomi na haguau, ana lomi ba i neneraa ei feroiau. Eni warea hamo'ei guainia, abaa wareau; uaa wareaa mei Ama, mei na aloagiau. ");
INSERT INTO wuv_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","“Minaa eni, una wareia ei ado'o guta a'a hamu'ou. ");
INSERT INTO wuv_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Ma'uaa mei Aweia, fei Spiriti Apuna, fei iwe aloiamai a'a fei harau mei Ama, iwe feroinaa hamu'ou minaa ei manumanu ma fanonominaa hamu'ou minaa ei manumanu, ei unadii warefanidigaa hamu'ou. ");
INSERT INTO wuv_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","Fei gutafarawania, una augia a'a hamu'ou; fei gutafarawaniau una fanaa hamu'ou. Lomi una fani ale'ei fei mau fanaa feni ano. Apuna naranara watauda ma apuna ma'au. ");
INSERT INTO wuv_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","“Hamona guaidigau ba, ‘A aunu ma awe hadiwe'idinamii a'a hamu'ou.’ Nabaa hamona haguau, hamonei ni'eni'e ba a aununaa a'a mei Ama, uaa mei Ama na muainau. ");
INSERT INTO wuv_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Ataa nomai fei, ma'uaa ado'o warefa'aiaa hamu'ou ba ena ina nomai, hamonei narafawe'i. ");
INSERT INTO wuv_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Lo'e i madii fiwarewareiaa o'ou uaa mei haparaa feni ano fi nomai. Pa'aa lomi i panarofau, ");
INSERT INTO wuv_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","ma'uaa feni ano nei apa'ia ba una haguaa mei Ama ma nei bigi'aa ana ei ina warefanau. “Nomai; o aunu. ");
INSERT INTO wuv_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","“Yau fei pa'aa pa'apa'a ma mei Amau, hia mei bigi'aa pe'ihape. ");
INSERT INTO wuv_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Ma minaa ei rara lomi fuana, ina'o morosiminaa ro'ou. Ma a'a ei rona fuaa, na famama'aia ba nei fuafarawani. ");
INSERT INTO wuv_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Hamona fafa'araidii, uaa una warefanidigaa hamu'ou fei warea. ");
INSERT INTO wuv_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Hamonei oa laloo iau ma awe oa laloo iaa hamu'ou. Lomi hepalo rara ba i fuaa anaia; inei pana a'a fei pa'apa'a. Ana lomi ba hamo'aa fuapa'i nabaa lomi hamona oa laloo iau. ");
INSERT INTO wuv_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","“Yau, fei pa'apa'a; hamu'ou, ei rara. Nabaa nemea i oa laloo iau ma yau i laloo iana, iwe pa'i watauda fuana; nabaa lomi na oa a'au, lomi i bigipa'aa hepalo manumanu. ");
INSERT INTO wuv_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Hini lomi na oa laloo iau, hia, ale'ei fei rara rona siminia ma na ma'e; ei rara ale'ei, rona'aida pogisiminaa hafi ma rona gu'a. ");
INSERT INTO wuv_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Nabaa hamo'aa oa i laloo iau ma ei wareau i oa laloo iaa hamu'ou, i'iginaa tamanu nunumiaa hamu'ou ma awe fanaa hamu'ou. ");
INSERT INTO wuv_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Sifei fei haweraa mei Amau, ba hamonei fuaa watauda ma a'a fei, i fama'aia ba hamu'ou, otalai nenerau. ");
INSERT INTO wuv_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","“Mei Ama na haguau, si'ei, una haguaa hamu'ou. Ma e'eni hamonei oa a'a fei haguau. ");
INSERT INTO wuv_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Nabaa hamo'aa neneraa ei wareau, hamowe oa a'a fei haguau, ana ale'ei yau na neneraa ei wareaa mei Amau ma oa i a'a fei haguana. ");
INSERT INTO wuv_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","Una warefanaa hamu'ou fei ba fei ni'eni'eau nei oa i a'a hamu'ou ma fei ni'eni'eaa hamu'ou ipowe bauanai. ");
INSERT INTO wuv_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Sifei fei wareau a'a hamu'ou: Hamonei fihagui ana ale'ei una haguaa hamu'ou. ");
INSERT INTO wuv_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Lomi hepalodiai mau hagua na muainaa fei ba nemea i ma'e, uaa ei tafina. ");
INSERT INTO wuv_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Hamu'ou tafiu nabaa hamo'aa bigi'aa tamanu una wareia. ");
INSERT INTO wuv_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Lomidiai a ware ba hamu'ou nafi, uaa mei nafi, lomi na aida ei pelee naraa mei fasuna. Agia. Una ware ba hamu'ou tafiu, uaa minaa ei una guainia a'a mei Amau, na fa'aiaa hamu'ou. ");
INSERT INTO wuv_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","A'a ba hamona rafeinau, uaa yau na rafeinaa hamu'ou ma fanaa hamu'ou fei bigi'a ba hamoneiwii fuaa fawatauda—ei fua i udefamadii. Ma mei Ama i fanaa hamu'ou tamanu hamona i'iginia a'a fei harau. ");
INSERT INTO wuv_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Sifei fei wareau a'a hamu'ou: Hamonei fihagui. ");
INSERT INTO wuv_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","“Nabaa i bidibidi unuu feni ano a'a hamu'ou, hamonei aida ba nado'o bidibidi ununa a'au. ");
INSERT INTO wuv_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Nabaa hamu'ou neneraa maumau feni ano, feni ano i haguaa hamu'ou ale'ei manumanuna. Ma'uaa a'a ba hamu'ou a'a feni ano, uaa una rafeifa'asi'anaa hamu'ou wagina. Si'ei, i bidibidi unuu feni ano a'a hamu'ou. ");
INSERT INTO wuv_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Nonominaa ei wareau a'a hamu'ou: ‘Lomi hemea nafi i muainaa mei fasuna.’ Nabaa rona haperararaiau, ana ro'aa haperararaiaa hamu'ou. Nabaa rona neneraa ei feroiau, ana ro'aa neneraa ei feroiaa hamu'ou. ");
INSERT INTO wuv_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Ro'aa bigi'ia ale'ei a'a hamu'ou uaa fei harau, hamatee lomi rona apa'aa Mei na aloagiau. ");
INSERT INTO wuv_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Nabaa lomi una nomai ma waredii a'a ro'ou, ana lomi ro nanamuinia ba rona bigi'aa ei hafelo'a. Ma'uaa e'eni, lomi ro'aa pa'i talaa wareaa ro'ou a'a ei hafelo'a rona bigi'ia. ");
INSERT INTO wuv_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Hini na bidibidi ununa a'au ana na bidibidi ununa a'a mei Amau. ");
INSERT INTO wuv_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Ei bigi'au i pudaa ro'ou, pa'aa lomi na bigi'ia hemeadiai. Ma'uaa, si'ei ba una bigi'aa e'ei i dupuaa ro'ou, lomi na pa'i talaa wareaa ro'ou wagii ei hafelo'aa ro'ou. Rona fanunudigaa ei foigia ma ana roifi bidibidi unuu ro'ou a'au ma mei Amau. ");
INSERT INTO wuv_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Ma'uaa ina ale'ei ba i fafa'uainaa ei ne'ia laloo fei Law ro'ou: ‘Na bidibidi unuu ro'ou a'au ma lomi pa'afina.’ ");
INSERT INTO wuv_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","“Iwe nomai mei Aweia, mei awe alofanagiaa hamu'ou. Noramiana a'a mei Ama ma hia fei Spiritii fa'uaia, ana fei noramiana a'a mei Ama ma iwe u'ugau. ");
INSERT INTO wuv_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Ma ana hamonei u'u, uaa wagii fei rawarawaa bigi'au nopa'amii eni, hamu'ou a'au. ");
INSERT INTO wuv_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","“Unadii warefanaa hamu'ou minaa e'ei ba hamonei'aa talaifatata. ");
INSERT INTO wuv_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Rowe fa'asi'anaa hamu'ou a'a fei synagogue ma ana ipowe nomai fei au ba nabaa ro'aa fo'ama'eaa hamu'ou, ro'aa nara ba na rawani ua ei bigi'aa ro'ou pudaa mei Haidaa. ");
INSERT INTO wuv_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Ro'aa bigi'ia ale'ei uaa lomi rona apa'aa mei Ama ma yau. ");
INSERT INTO wuv_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Unadii wareaa e'ei ba ena na nomai fena au hamowe nonominia ba unadii warefa'aiaa hamu'ou. Lomi unado'o warefanaa hamu'ou fama'a, uaa Yau i a'a hamu'ou. ");
INSERT INTO wuv_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","“E'eni a aununaa a'a mei na aloagiau, ma'uaa lomi hemea hamu'ou na i'igainau ba, ‘O dinaia?’ ");
INSERT INTO wuv_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Hamonamina faloloa'i ba una wareaa e'ei. ");
INSERT INTO wuv_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Ma'uaa a warefa'uai a'a hamu'ou: fei aunuau i farawaninaa hamu'ou. Nabaa lomi na aunu, ana lomi i nomai mei Aweia; ma'uaa, nabaa a aunu, awe aloiagio a'a hamu'ou. ");
INSERT INTO wuv_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Ena na nomai, i famarapuaa unuu ei rama'aa feni ano wagii ei hafelo'a, o wanewanea, o fei dududua: ");
INSERT INTO wuv_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","uaa wagii ei hafelo'a, lomi ro'aa narafawe'i a'au; ");
INSERT INTO wuv_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","wagii fei wanewanea, a dinaa a'a mei Ama, yei lomi ba hamo'aa fanunudinau; ");
INSERT INTO wuv_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","ma wagii fei dududua, ipowe to fagianana mei haparaa feni malagufu, uaa na udedii fei warea ba i ale'ei. ");
INSERT INTO wuv_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","“Watauda ei ba a wareia a'a hamu'ou, ma'uaa, e'eni, hamatee ina watauda, na rataiaa hamu'ou. ");
INSERT INTO wuv_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Ma'uaa ena na nomai fei Spiritii fa'uaia, iwe famamonaa hamu'ou a'a minaa ei fa'uaia. Lomi i wareaa anaia; i wareaa tamanu na guainia ma warefanaa hamu'ou tamanu itawe nomai. ");
INSERT INTO wuv_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Iwe fani hawera a'au, uaa i to a'au ma fa'aiaa hamu'ou. ");
INSERT INTO wuv_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Minaa ei manumanuu mei Ama, manumanuu. Si'ei, a ware ba fei Spiriti i to a'au ma fa'aiaa hamu'ou. ");
INSERT INTO wuv_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","“Lomi i madii ma hamo'aa ma'a'afoau ma nene ma'ida, hamowe fanunuau.” ");
INSERT INTO wuv_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Hefi'aa ei otalai nenerana, rona fiwarei ba, “Tamanu hanuu ei wareana ba, ‘Lomi i madii ma hamo'aa ma'a'afoau ma nene ma'ida, hamowe fanunuau.’ ma ‘Hamatee a dinaa a'a mei Ama’?” ");
INSERT INTO wuv_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Rona'u i'igai ua, “Tamanu hanuu fei, ‘Lomi i madii’? Lomi ona apa'ia ba ifi wareaa tamanu.” ");
INSERT INTO wuv_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Jesus na aida ba ro'aa i'iginia a'a fei, si'ei, na warenaa a'a ro'ou, “Hamo'ei fi'i'igii ba tamanu hanuu ei wareau ba, ‘Lomi i madii ma hamo'aa ma'a'afoau ma nene ma'ida, hamowe fanunuau’? ");
INSERT INTO wuv_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","A warefa'uai a'a hamu'ou ba hamo'aa ai'ai ma faloloa'i ena na ni'eni'e feni ano. Hamowe faloloa'i, ma'uaa fei faloloa'iaa hamu'ou, i filoginaa ni'eni'ea. ");
INSERT INTO wuv_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Hemea pifine ba i waniniaa hemea baduu, imina tonaa fi'ina, uaa nawe nomai fei auna; ma'uaa ena na waninidigaa mei na'una mei pifine, i madi'inaa ei fi'iana uaa na ni'eni'e ba mei na'una na waninimai a'a feni malagufu. ");
INSERT INTO wuv_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Ana ale'ei a'a hamu'ou: E'eni, au faloloa'iaa hamu'ou, ma'uaa awe fanunudinaa hamu'ou ma hamopowe ni'eni'e ma lomi nemea i topa'ainaa fei ni'eni'eaa hamu'ou. ");
INSERT INTO wuv_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","A'a fei arewaa fei, lomi hamo'aa i'igidinau hepalo manumanu. A warefa'uai a'a hamu'ou ba mei Amau, iwe fanaa hamu'ou tamanu ei i'igaiaa hamu'ou a'a fei harau. ");
INSERT INTO wuv_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Nopa'amii e'eni, hamotawe i'iginaa hepalo manumanu a'a fei harau. I'igai ma hamowe to ma fei ni'eni'eaa hamu'ou, ipowe bauanai. ");
INSERT INTO wuv_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","“Unadii warehanunuinaa ei manumanu, ma'uaa iwe nomai fei au ba lomi a fai wareware ale'ei, ma'uaa awe fa'arewaiaa mei Amau a'a hamu'ou. ");
INSERT INTO wuv_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","A'a fei arewaa fei, hamowe i'igai a'a fei harau. Lomi una ware ba awe i'igaifani i'igaiaa hamu'ou a'a mei Ama. ");
INSERT INTO wuv_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Agia, mei Ama ana na haguaa hamu'ou, uaa hamona haguau ma nara ba pa'aa fa'ua ba noramiau a'a mei Haidaa. ");
INSERT INTO wuv_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Noramiau a'a mei Ama ma una nogio yeni malagufu; e'eni ba a di'ininaa feni malagufu ma hadiwe'inaa a'a mei Ama.” ");
INSERT INTO wuv_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Ma ei otalai neneraa Jesus, rona ware, “E'eni oi warefa'arewai ua, lomi ona warehanunui. ");
INSERT INTO wuv_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","E'eni hai'ounawe fanunu'apa'ia ba ona aida minaa ei manumanu ma lomi pa'afina ba nemea i i'igidinio hepalo i'igaia. A'a fei, hai'ounawe nara ba pa'aa fa'ua ba noramiamu a'a mei Haidaa.” ");
INSERT INTO wuv_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Jesus na ware, “Hamonawe aida ba fa'ua! ");
INSERT INTO wuv_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Ma'uaa fi nomai fei au ma ina nodigimai ba hamowe talanenei, hememea a'a fei humuna. Hamowe farapa di'ininau. Ma'uaa abaa unaa yau, uaa mei Amau, hia a'au. ");
INSERT INTO wuv_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","“Una warefanidigaa hamu'ou ba i a'au hamo'aa tonaa fei gutafarawania. Yeni malagufu, hamowe tonaa ei hafelo'a. Ma'uaa ofafaufau! Una muaidigaa feni malagufu.” ");
INSERT INTO wuv_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","I waredigaa fei Jesus, na aranaa pafea ma lafulafu: “O'ama, ina nodigimai fei au. Haweginaa mei Na'umu ba mei Na'umu i fani hawera a'amu. ");
INSERT INTO wuv_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Uaa, ona fanidigia fei forafora a'a minaa ei rama'a ba nei fanaa fei harenua lomi i pedutoo a'a minaa ei fanamu hia. ");
INSERT INTO wuv_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Sifei fei harenua lomi i pedutoo: ba ronei apa'io, mena yoi hemea ua Haidaa, mena unaio na fa'uai mawe Jesus Christ, mei ona aloiagio. ");
INSERT INTO wuv_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Yeni malagufu, una fani hawera a'amu uaa una bigidigaa ei ona fanau ba unei bigi'ia. ");
INSERT INTO wuv_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Ma e'eni, O'ama, haweginau inamoamu wagii fei hawera unado'o pa'i i a'amu ei atawe mamara feni malagufu. ");
INSERT INTO wuv_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","“Una fa'arewaio a'a ei rama'a ona fanau wagii feni malagufu. Ro'ou, maroamu; ona fanaa ro'ou a'au ma rona neneraa fei wareamu. ");
INSERT INTO wuv_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Ronawe aida ba minaa ei fanamu yau, noramiana a'amu. ");
INSERT INTO wuv_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Uaa una fanaa ro'ou ei warea ona fanau ma rona tonia. Ronapa'aa aida ba noramiau i a'amu ma nara ba pa'aa fa'ua ba aloamiamu yau. ");
INSERT INTO wuv_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","Una lafulafunaa ro'ou. A'a ba una lafulafunaa feni malagufu ma'uaa, na lafulafunaa ei ona fanau, uaa ro'ou, manumanumu. ");
INSERT INTO wuv_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Minaa ei manumanuu, manumanumu ma minaa ei manumanumu, manumanuu. Ma una to hawerau a'a ro'ou. ");
INSERT INTO wuv_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Lomi ba a gutadiai yeni malagufu, ma'uaa ro'ou ana yeni malagufu ma yau, a nomai a'amu. Mena Amau, mena ona apunai, wagi'inaa ro'ou a'a fei faufau wagii fei haramu—fei hara ona fanau—ba ronei hemeai ua ana ale'ei agua ba hemea ua. ");
INSERT INTO wuv_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Ei a gutafipui a'a ro'ou, una wagi'inaa ro'ou a'a fei hara ona fanau ba nei'aa tonaa ro'ou ei hafelo'a. Lomi hemea ro'ou na pa'ai, ana uniaa mei na udedii fei harana ba i pa'ai uaa ba fei ne'ia nei fa'uai. ");
INSERT INTO wuv_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","“Yau fi nomai a'amu e'eni, ma'uaa una wareaa e'ei eni fido'o guta yeni malagufu ba laloo iaa ro'ou nei pa'i fei baua ni'eni'eau. ");
INSERT INTO wuv_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Una fanidigaa fei wareamu a'a ro'ou ma na bidibidi unuu feni ano a'a ro'ou, uaa ro'ou abaa rama'aa feni ano, ana ale'ei ba yau abaa rama'aa feni ano. ");
INSERT INTO wuv_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Fei lafulafuau, abaa onei fa'asi'anaa ro'ou a'a feni ano, ma'uaa, onei wagi'inaa ro'ou uaa mei hafelo'a. ");
INSERT INTO wuv_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Ro'ou, abaa rama'aa feni ano, ana ale'ei ba yau, abaa rama'aa feni ano. ");
INSERT INTO wuv_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Papaditainaa ro'ou wagii fei fa'uaia; fei wareamu na fa'uai. ");
INSERT INTO wuv_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Ana ale'ei ona aloagiau yeni ano, ana a alonaa ro'ou a'a feni ano. ");
INSERT INTO wuv_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Na papaditainaa ana yau uaa ro'ou ba ana roneipa'aa papaditai. ");
INSERT INTO wuv_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","“Abaa a lafulafunaa ro'ou ua. Ana a lafulafunaa ei rowe narafawe'i a'au uaa fei u'ugaa ro'ou ");
INSERT INTO wuv_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","ba minaa ro'ou, ronei hemeai ua, O'ama, ana ale'ei yoi i laloo iau ma yau i laloo iamu. Ina rawani ba ro'ou i laloo iaa agua ba feni ano nei aida ba ona aloagiau. ");
INSERT INTO wuv_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Una fanaa ro'ou fei hawera ona fanau ba ronei hemeai ua ana ale'ei agua ba hemea ua: ");
INSERT INTO wuv_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Yau i laloo iaa ro'ou ma yoi i laloo iau. Ina rawani ba ronei pa'apa'ainaa hepalo ua ba feni ano nei aida ba ona aloagiau ma haguaa ro'ou ana ale'ei ona haguau. ");
INSERT INTO wuv_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","“O'ama, nunimiau ba na dinaa hitani, ei rama'a fanamu yau, ronei oafipui a'au ma fanunuaa fei hawerau, fei ona fanau si'ei ba ona haguau ei atawe mamaramai feni malagufu. ");
INSERT INTO wuv_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","“Mena wanewanea Ama, feni ano, lomi na apa'io, ma'uaa una apa'io ma rona aida ba aloagiamu yau. ");
INSERT INTO wuv_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Una fama'aio a'a ro'ou. Ma amina u fama'a'uaio a'a ro'ou ba fei haguamu yau nei oa i laloo iaa ro'ou ma yau ana a oa i laloo iaa ro'ou.” ");
INSERT INTO wuv_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","I lafulafudii Jesus, na aunufipui a'a ei otalai nenerana ma na dinaa yei fawelei a'a fei baua baroaa Kidron. Yei pepei na pa'i hefawala na hala'ai ei olive ma rona dinaa wagina. ");
INSERT INTO wuv_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Ma Judas, mei i aloia, na apa'aa fawelei, uaa Jesus na'aida gutafipui a'a ei otalai nenerana yei. ");
INSERT INTO wuv_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Si'ei, Judas na nomai fawelei ma nodugamii hefaa gupuu rama'aa fo'aa mawe hefi'a bauana maroaa ei famamoaa humuu mei Haidaa mawe ei Pharisee. Rona notonamiaa ei ramai, ei we'ai ma ei hioo ro'ou. ");
INSERT INTO wuv_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Jesus na aidadii minaa ei manumanu ba ro'aa bigi'ia a'ana ma na asi'alao ma i'iginaa ro'ou, “Hini nunumiaa hamu'ou?” ");
INSERT INTO wuv_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Rona ware, “Jesus, mei Nazareth.” Jesus na ware, “Yau, hia.” (Ma Judas, mei i aloia, na ufipui a'a ro'ou yei.) ");
INSERT INTO wuv_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","I ware Jesus ba, “Yau, hia,” rona ugusue ma pasinaa malagufu. ");
INSERT INTO wuv_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Ina i'igidinaa ro'ou, “Hini nunumiaa hamu'ou?” Ma rona ware, “Jesus, mei Nazareth.” ");
INSERT INTO wuv_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Jesus na ware, “Na warefanidigaa hamu'ou ba Yau, hia. Nabaa hamo'ei labaginau, te, fatalainaa eni rama'a eni.” ");
INSERT INTO wuv_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Fei pa'afina i wareaa fei, sifei ba nei fa'uai ei diwareana ba: “Lomi una fapa'ainaa hemea eni ona fanau.” ");
INSERT INTO wuv_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Simon Peter na pa'i waduna ma na rapu'ia ma lafigaa pepei ma'au adiaa mei nafii mei pa'aa bauaniaa humuu mei Haidaa. (Fei haraa mei nafi, Malchus.) ");
INSERT INTO wuv_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Jesus na warefawe'i a'a Peter, “Auhadiwe'inaa fei wadumu! Haa, lomi ba a hunu a'a fei bara na fanau mei Ama?” ");
INSERT INTO wuv_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Fei gupuu rama'aa fo'aa, mei bauaniaa ro'ou ma ei bauaniaa ei Jew, rona panarofaa Jesus. Rona fauroro'inia ");
INSERT INTO wuv_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","ma do'o noduginaa hia a'a Annas, mei amaa haroo Caiaphas, mei pa'aa bauaniaa humuu mei Haidaa wagii fei igisimasi fei. ");
INSERT INTO wuv_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Caiaphas, hia, mei nadii warefa'aiaa ei Jew ba na rawani hemea ua ma'ea laraa watauda. ");
INSERT INTO wuv_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Simon Peter ma hemeadiai otalai nenera, laguna neneraa Jesus. Hamatee mei otalai nenera mei, na apa'ia mei pa'aa bauaniaa humuu mei Haidaa, ina wadu'aihugiaa Jesus i malalaa fei gutanaa mei pa'aa bauaniaa humuu mei Haidaa, ");
INSERT INTO wuv_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","ma'uaa Peter nado'o oma'a poaa humu. Mei hemeadiai otalai nenera, mei na apa'ia mei pa'aa bauaniaa humuu mei Haidaa na hadiwe'imai ma wareware a'a mei pifine, mei fi bigibigi yei ma dugifawadu'ainaa Peter. ");
INSERT INTO wuv_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Mei pifine i poaa humu na i'iginaa Peter, “Haa, abaa yoi hemea otalai nenerana?” Ina ware ba, “Lomi, abaa yau.” ");
INSERT INTO wuv_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Na fane fei hau ma ei nafi mawe ei bauana, rona ufarafi'i a'a fei hafi pa'aa ro'ou ba fana'aa ro'ou. Peter ana na ufipui a'a ro'ou ba i fana'a. ");
INSERT INTO wuv_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Mei pa'aa bauaniaa humuu mei Haidaa fi i'iginaa Jesus ei otalai nenerana ma ei feroiana. ");
INSERT INTO wuv_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Jesus na ware, “Una wareware i pudaa minaa ei rama'a. Una'o feroi laloo ei synagogue ma i humuu mei Haidaa, fawelei rona'o figupui minaa ei Jew. Lomi na opa'ainaa hepalo wareau. ");
INSERT INTO wuv_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Tani o i'iginau? I'iginaa ei rona guainau. Ronapa'aa aida tamanu ei wareau.” ");
INSERT INTO wuv_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","I wareaa fei Jesus, hemea ei bauana, mei na rafi'i na laparaa pudana. Ina warefasiba a'ana, “Haa, ale'ei mau wareamu a'a mei pa'aa bauaniaa humuu mei Haidaa?” ");
INSERT INTO wuv_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Jesus na ware, “Nabaa una wareaa hepalo na tata, ware'unia. Ma'uaa nabaa una warefafa'uai, tani o laparau?” ");
INSERT INTO wuv_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Ana yei ei bobo'ii panina ma Annas nawe alonaa hia a'a Caiaphas, mei pa'aa bauaniaa humuu mei Haidaa. ");
INSERT INTO wuv_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Ei fi fana'ana'aiaa ununa Simon Peter, hemea na i'iginia, “Haa, abaa yoi hemea otalai nenerana?” Ina warefasuabadui ba, “Lomi, abaa yau.” ");
INSERT INTO wuv_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Mei i lafigaa adiana Peter, gufuu hemea ei nafii mei pa'aa bauaniaa humuu mei Haidaa, mei na naroaa Peter, “Haa, abaa una fanunupa'io a'ana yei fasuu ei haihai olive?” ");
INSERT INTO wuv_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Peter na warefasuabaduidiai ma ana ei, na ai fei a'aroo. ");
INSERT INTO wuv_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","I dii, ei Jew rona talaiduginaa Jesus, di'ininaa Caiaphas ma dinaa a'a fei baua humuu mei gavanaa Rome. Na mafufuoidii eni ma si'ei ba ei Jew, lomi rona nunumiai ba ro'aa loloa wagii ei mau losuiaa ro'ou, lomi rona wadu'ainaa fei humuu hapara uaa ba ro'aa guta wagii fei hananaa fei Talai Falogia. ");
INSERT INTO wuv_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Si'ei, Pilate na asi'anamii a'a ro'ou ma i'igai, “Tamanu ei tataa mei rama'a mei?” ");
INSERT INTO wuv_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Rona ware, “Nabaa abaa hia hafelo'a, ana lomi hai'ou fifaninia a'amu.” ");
INSERT INTO wuv_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Pilate na ware, “Anaa hamu'ou nei dugia ma dududuia wagii fei law hamu'ou.” Ei Jew, rona ware, “Ma'uaa lomi na rawani ba hai'ou fadududu ma fo'afama'eaa hemea.” ");
INSERT INTO wuv_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Rona bigi'aa fei ba ei diwareaa Jesus ba batanai fei ma'eana nei fa'uai. ");
INSERT INTO wuv_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Pilate na wadu'aidinaa fei baua humu, na lala'aa Jesus ma i'iginia, “Haa, yoi mei haparaa ei Jew?” ");
INSERT INTO wuv_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Na i'igai Jesus, “Pa'aa naranaramu, o hefi'adiai na u'ugau a'amu?” ");
INSERT INTO wuv_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Pilate na ware, “Haa, yau hemea Jew? Ei gufumu mawe ei famamoaa humuu mei Haidaniaa hamu'ou, ana ro'ou, ei ro'aa fifaninio paniu. Tamanu ei bigi'amu?” ");
INSERT INTO wuv_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Jesus na ware, “Fei haparaiau, abaa manumanuu feni malagufu. Nabaa ale'ei, ei nafiu, ro'aa fo'a ma lomi ro'aa panaropa'au ei Jew. Ma'uaa, e'eni, fei haparaiau, na ude hefawala.” ");
INSERT INTO wuv_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Pilate na ware, “Si'ei ba yoi hapara, na?” Jesus na ware, “Na wanewane fei wareamu ba yau hapara. Sifei fei pa'afina a waninimai yeni malagufu ba unei u'ugaa fei fa'uaia. Mei na oa wagii fei fa'uaia na guainau.” ");
INSERT INTO wuv_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Pilate na i'igai, “Tamanu fei fa'uaia?” Nenee fei, ina asi'adinaa ano a'a ei Jew ma ware, “Lomi na labagipa'i pa'afina ba o ware ba hia na bigifata. ");
INSERT INTO wuv_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Ma'uaa wagii fei maumau hamu'ou, unei alaraa hemea bobo'aia a'a fei au Talai Falogia. Nunumiaa hamu'ou ba a alaraa ‘mei haparaa ei Jew’?” ");
INSERT INTO wuv_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Rona parararailao, “Lomi. Abaa hia! Fanaa hai'ou Barabbas!” Barabbas, hemei nado'o fa'asi'anaa fei fisibaia a'a fei gavaman. ");
INSERT INTO wuv_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","I dii, Pilate na dugaa Jesus ba ronei babuinia. ");
INSERT INTO wuv_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Ei rama'aa fo'aa, rona fifigaa fei wowo'ii na hogia ba taona ma fahawaiaa tabana. Rona farafenaa hia fei hawaa ugu, pomana purple ");
INSERT INTO wuv_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","ma rona'u no'ualao a'ana ma ware, “Hai'ou uduginio, mena haparaa ena Jew!” Ma rona lapagia. ");
INSERT INTO wuv_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Pilate na asi'adimai ma ware a'a ei Jew ba, “Ma'aia, a noduginamii hia a'a hamu'ou ba a warefa'aiaa hamu'ou ba lomi una labagipa'i pa'afina ba a ware ba ina bigifata.” ");
INSERT INTO wuv_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","I asi'ataonamii fei tao na hogia ma fei baua purple hawaa ugu Jesus, Pilate na warenaa a'a ro'ou, “Simeni, meni rama'a.” ");
INSERT INTO wuv_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Ana ei ro'aa fanunupa'ia ei famamoaa humuu mei Haidaa mawe ei bauaniaa ro'ou, rona harofawe'i ba, “Fatawaia, fatawaia!” Ma'uaa Pilate na ware, “Dugia ma fatawaia. Hamatee yau, lomi na labagipa'i pa'afina ba o ware ba ina bigifata.” ");
INSERT INTO wuv_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Ei Jew na warefawe'i ba, “Hai'ouna na pa'i law hai'ou ma a'a fei law fei, inei ma'e, uaa ina ware ba hia, Na'uu mei Haidaa.” ");
INSERT INTO wuv_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","I guainaa fei Pilate, na ma'au'apoidiai ");
INSERT INTO wuv_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","ma na wadu'aidinaa fei baua humu. Ma na i'igainaa Jesus, “Noramiamu hitani?”, ma'uaa lomi na wareaa hepalo manumanu Jesus. ");
INSERT INTO wuv_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Pilate na ware, “Haa, lomi o wareware a'au? Lomi ona aida ba na pa'i faufau ba a alagio, o fatawaio?” ");
INSERT INTO wuv_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Jesus na ware, “Lomi na pa'i faufaumu ba o bigi'aa hepalo manumanu a'au nabaa abaa noranarai pafea. Si'ei, mei na fifaninau panimu, fei hafelo'ana na rata laraa fei hafelo'amu.” ");
INSERT INTO wuv_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","A'a fei ma nolao, Pilate ba ifane alaraa Jesus, ma'uaa ei Jew, rona'u haroharo ua, “Nabaa o alaraa mei rama'a mei, abaa yoi tafii Caesar. Mei i ware ba hia hapara na warefafeloaa Caesar.” ");
INSERT INTO wuv_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","I guainaa fei Pilate, na fa'asi'anaa Jesus ano ma hia na guta wagii fei gutanaa mei fadududua, fei Talaa Mugoo (harana warea Aramea, Gabbatha). ");
INSERT INTO wuv_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Fei au fei, arewaa Pagipagiaa fei Hefapagipagiaa fei Talai Falogia ma ale'ei haloaina. Pilate na warenaa a'a ei Jew, “Simeni, meni haparaa hamu'ou.” ");
INSERT INTO wuv_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Ma'uaa rona haropararai, “Nodugawau! Nodugawau! Fatawaia!” Pilate na i'igai, “Haa, a fatawaia, mei haparaa hamu'ou?” Ei famamoaa humuu mei Haidaa na ware, “Hemea ua haparaa hai'ou. Caesar.” ");
INSERT INTO wuv_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Pilate nawe fifaninia panii ro'ou ba ronei fatawaia. Si'ei, Jesus nawe udenaa panii ei fo'aa. ");
INSERT INTO wuv_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Ina fuharenaa fei hawafolona ma aununaa fawelei, harana Guitaba (harana warea Aramea, Golgotha). ");
INSERT INTO wuv_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Ma rona fatawaia yei a'a helaguidiai—hemea pepei ma hemea pepei ma Jesus watolaa lagua. ");
INSERT INTO wuv_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Pilate na fabiginaa ro'ou hepalo ne'ia ma rona faugia a'a fei hawafolo. Ma fei ne'ia ale'ei: JESUS, MEI NAZARETH, MEI HAPARAA EI JEW. ");
INSERT INTO wuv_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Wataudaa ei Jew na igoaa fei ne'ia, uaa fawelei i fatawa Jesus na rafi'inaa fei baua gufu ma fei ne'ia, warea Aramea, Latin ma Greek. ");
INSERT INTO wuv_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Lomi na rawani a'a ei famamoaa humuu mei Haidaniaa ei Jew ma rona warenaa a'a Pilate, “Apuna ne'inia ba, ‘Mei Haparaa ei Jew,’ ma'uaa onei ne'i ba ina ware ua ba hia mei haparaa ei Jew.” ");
INSERT INTO wuv_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Pilate na ware, “Tamanu una ne'inia nei ude.” ");
INSERT INTO wuv_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Ro'aa fatawadigaa Jesus ei fo'aa, rona tonaa ei susuna ma alaginia a'a hememea ei gunaroa rama'a, ma'uaa dufuna fei na'uu susuna. Fei susu fei, lomi u'ugina, rona tawinaa ale'ei hepalo ua, pa'uduna ma dinaa supuna. ");
INSERT INTO wuv_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Rona fiwarei ba, “Onei'aa foranini'ia. O bigi'aa hepalo uni'uni fifigaia ba hemea ua i muaitonia.” Fei, na nomai ba i fafa'uainaa fei ne'ia ba, “Rona fi'alaginaa ei susuu dupuaa ro'ou ma bigi'aa hepalo fifigaia ba hemea i muaitonaa fei susuu.” Si'ei, ro'aa bigi'ia ale'ei ei fo'aa. ");
INSERT INTO wuv_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Ei rona ufalarai nana'aa fei hawafoloo Jesus, mei inana, mei tafii inana, Mary mei haroo Clopas mawe Mary Magdalene. ");
INSERT INTO wuv_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Jesus, i fanunupa'aa mei inana mawe mei otalai nenerana, mei hia na haguia na ufarafi'i, na warenaa a'a mei inana, “Mena pifine, simena, mena na'umu,” ");
INSERT INTO wuv_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","ma a'a mei otalai nenerana, na ware ba, “Simena, mena inamu.” A'a fei au fei ma nolao, mei otalai nenera, mei na fagutania i humuna. ");
INSERT INTO wuv_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Nene ma'ida, si'ei ba ina aida ba minaa ei manumanu na nodigimai ma fei Bu'u Apuna ipowe fa'uai, Jesus na ware, “Una sigigi.” ");
INSERT INTO wuv_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Na ude hepalo pe'ii vinegar wine yei; si'ei, rona pudigaa fei fahununu lalona ma fasuia wagii fei haihai hyssop ma roainalao umuu Jesus. ");
INSERT INTO wuv_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","I todigaa fei numa Jesus, na ware, “Inawe baibaisio.” A'a fei, ina faba'oduinaa tabana ma rawa'a'afainaa fei spiritina. ");
INSERT INTO wuv_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Fei arewaa fei, arewaa pagipagia, uaa ale'ei narani, hepalo baua u'ugai Sabbath. Si'ei ba ei Jew, lomi na nunuminia ba ei unuu rama'a nei fatawa ua pafoo ei hawafolo wagii fei Sabbath, rona i'iginaa Pilate ba nei mero'aa gui pinee ro'ou ma fa'upuaa ro'ou. ");
INSERT INTO wuv_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Si'ei, ei fo'aa, ronamii mero'aa gui pinee mei rawarawaa fatawafipuiaa ro'ou a'a Jesus ma ei pinee mei lagua. ");
INSERT INTO wuv_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Ma'uaa ro'aa nomai a'a Jesus ma fanunupa'ia ba na ma'edii, lomi rona mero'aa gui pinena. ");
INSERT INTO wuv_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Ma'uaa hemea ei fo'aa na moto'aa huwaa Jesus a'a hepalo hio ma na wigi'uamai raraa ma ranu. ");
INSERT INTO wuv_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Hemea na fanunuaa fei na u'udigia ma pa'aa fa'ua fei u'ugana. Ina aida ba ei u'ugana pa'aa fa'ua ma na u'ufanaa hamu'ou ba ana hamonei narafawe'i wagina. ");
INSERT INTO wuv_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Ei manumanu ei na nomai ba fei Bu'u Apuna nei fa'uai: “Lomi hepalo guina i amero,” ");
INSERT INTO wuv_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","ma ana ale'ei hepalodiai ne'ia ba, “Rowe fanunuaa mei rona moto'ia.” ");
INSERT INTO wuv_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Hinene, Joseph, mei Arimathea na i'iginaa Pilate ba i tonaa fei unuu Jesus. Joseph, hia hemea otalai neneraa Jesus, ma'uaa ina o'opa'ai uaa na mama'au a'a ei Jew. Si'ei ba na ugainia Pilate, ina nomai ba i tonaa fei hudi unu. ");
INSERT INTO wuv_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Ina nohugiamai Nicodemus, mei nado'o nomai a'a Jesus hefaa poi. Nicodemus na notonamii ei fihafuiaa ro'ou myrrh ma aloe, awatana ale'ei odufua pa'ania ma obao kilogram. ");
INSERT INTO wuv_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Laguna tonaa fei unuu Jesus ma sumia a'a ei maninii lawalawa fininaa ei hapipigi. Fei ale'ei ba i neneraa ei maumau ei Jew, ei rona'o agifai ma'ea. ");
INSERT INTO wuv_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Fawelei ro'aa fatawaiaa Jesus na pa'i hepalo pe'ihape ma lalona na pa'i hepalo manufau huapu waduaa ro'ou na'ana'a, hepalo rotawe fahainopaa hemea ma'ea lalona. ");
INSERT INTO wuv_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Si'ei ba fei arewaa fei, arewaa ei Jew ba ro'aa Pagi'augaa ei Manumanu ma fei huapu ana na rafi'i ua, rona fahainopaa Jesus yei. ");
INSERT INTO wuv_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Pa'aa mafufuo badu a'a fei rawarawa arewaa fei hefapagipagia, atawe arewafarawani, Mary Magdalene na aununaa a'a fei huapu ma fanunupa'ia ba hefi'a, rona pigudigaa fei baua mugoo i poaa wawadu'i. ");
INSERT INTO wuv_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Si'ei, ina poninaa a'a Simon Peter ma hemeadiai otalai nenera, mei na haguia Jesus ma na ware, “Rona fa'asi'anaa mei Fasu a'a fei huapu ma lomi ona aida ba rona fahainopia hitani!” ");
INSERT INTO wuv_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Si'ei, Peter mawe mei ana hemea otalai nenera, laguna una'anaa a'a fei huapu. ");
INSERT INTO wuv_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Minaa lagua, laguna poni, ma'uaa mei hemeadiai otalai nenera na muainaa Peter ma nado'oree pa'aa fei huapu. ");
INSERT INTO wuv_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Ina fabalou ma farerefilao ma unaa ei maninii lawalawa lalona, ma'uaa, lomi na wadu'ai. ");
INSERT INTO wuv_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","I dii, Simon Peter, mei i nomai mugina nawe nopa'amai ma wadu'ainaa laloo huapu. Ina fanunupa'ia ba ei maninii lawalawa ua yei ");
INSERT INTO wuv_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","ma fei lawalawaa agifaia, fei rona hawainaa tabaa Jesus. Fei lawalawa fei, na du'u ma ude u'ugai a'a ei maninii lawalawa. ");
INSERT INTO wuv_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","I dii, mei otalai nenera, mei nado'oree pa'aa fei huapu, ana na wadu'ai. Ina fanunuia ma na narafawe'i. ");
INSERT INTO wuv_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","(Lagutawe narapa'ia ei wareaa fei Bu'u Apuna ba Jesus, iwe asi'aa a'a ei ma'ea.) ");
INSERT INTO wuv_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Ma laguei otalai nenera, lagunawe hadiwe'inaa humuu lagua. ");
INSERT INTO wuv_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Ma'uaa Mary na u i poaa fei huapu ma ai'ai. Ei fi ai'ai, na fabalou ma fanununaa laloo fei huapu ");
INSERT INTO wuv_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","ma na fanunupa'aa helagui alo'alo. Po'iaa susuu lagua ma laguna guta fawelei nado'o haino fei unuu Jesus, hemea yei tabana ma hemea yei balofena. ");
INSERT INTO wuv_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Laguna i'iginia, “Mena pifine, tani o ai'ai?” Ina ware, “Rona topa'ainaa mei Fasuu ma lomi na aida ba rona augia hitani.” ");
INSERT INTO wuv_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","A'a fei, ina momo'ai ma fanunupa'aa Jesus na ufalarai yei, ma'uaa, lomi na aida ba Jesus. ");
INSERT INTO wuv_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Ina ware, “Mena pifine, tani o ai'ai? Oi labaginaa hini?” Ina nara ba hia, mei oma'aa fei pe'ihape ma na ware, “Hagu'u, nabaa poro'amu, warefanau ba ona augia hitani ma awe tonia.” ");
INSERT INTO wuv_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Jesus na warenaa a'ana, “Mary.” Ina diarailao a'ana ma warefawe'i a'ana, warea Aramea ba, “Rabboni!” (hanuna ba Feroia). ");
INSERT INTO wuv_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Jesus na ware, “Onei'aa panarofau, uaa atawe hadiwe'inaa a'a mei Ama. Ma'uaa dinaa a'a ei lofuu ma warefanaa ro'ou ba, ‘A hadiwe'inaa a'a mei Amau, mei ana amaa hamu'ou, mei Haidaniau, mei ana Haidaniaa hamu'ou.’” ");
INSERT INTO wuv_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Mary Magdalene na dinaa a'a ei otalai nenera ma u'u ba, “Una fanunudigaa mei Fasu!” Ma na warefanaa ro'ou ba hia na wareaa ei manumanu ei a'ana. ");
INSERT INTO wuv_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","I nofafilao fei rawarawa arewaa fei hafapagipagia, rona gutafipui ei otalai nenera ma ei gigei na ude fawi, uaa rona ma'au a'a ei Jew, Jesus namii u dupuaa ro'ou ma ware, “Inei rawani ua ei naranaraa hamu'ou!” ");
INSERT INTO wuv_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","I waredigaa fei, na fama'aa ro'ou guei panina ma huwana. Ro'aa fanunuaa mei fasu, ronamina ni'eni'e ei otalai nenera. ");
INSERT INTO wuv_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Ina warediai Jesus ba, “Inei rawani ua ei naranaraa hamu'ou! Ana ale'ei ba na aloagiau mei Ama, a aloaa hamu'ou.” ");
INSERT INTO wuv_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Ma a'a fei, ina fawenailao a'a ro'ou ma na ware, “Tonaa fei Spiriti Apuna. ");
INSERT INTO wuv_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Nabaa hamo'aa futoaa ei hafelo'aa nemea, i pa'ai ei hafelo'ana; nabaa lomi hamo'aa futoaa ei hafelo'ana, ana lomi i pa'ai.” ");
INSERT INTO wuv_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Ma Thomas (ana harana Didymus), hemea ei Hefua ma Helagui, hia, lomi a'a ei otalai nenera ei i nomai Jesus. ");
INSERT INTO wuv_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Si'ei, rona warefania, “Hai'ouna fanunudigaa mei Fasu!” Ma'uaa ina warenaa a'a ro'ou, “Nabaa lomi na fanunupa'aa ei dibaa fadua i panina ma didifinaa fei ana'anau wagina ma didifinaa paniu huwana, ana lomi a nara ba fa'ua.” ");
INSERT INTO wuv_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Nenee heai hafapagipagia, ei otalai nenerana na gutadiai laloo fei humu ma Thomas a'a ro'ou. Na fawidii ei gigei, ma'uaa Jesus namii u dupuaa ro'ou ma ware, “Inei rawani ua ei naranaraa hamu'ou!” ");
INSERT INTO wuv_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","I dii, ina warenaa a'a Thomas, “Didifinaa fei ana'anamu yeni; ma'aiaa gueni paniu. Roainamii fei panimu ma didifinia huwau. Fapedugaa ei hamamaguamu ma narafawe'i.” ");
INSERT INTO wuv_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Thomas na warenaa a'ana, “Mena Fasuu, mena Haidaniau!” ");
INSERT INTO wuv_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Ma Jesus na warenaa a'ana, “Si'ei ba ona fanunupa'au, ona narafawe'i; rona pa'i hawegiaa ro'ou—ei rona narafawe'i ma'uaa, lomi rona fanunuau.” ");
INSERT INTO wuv_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Jesus na bigi'aa wataudadiai hilalaa foigia i pudaa ei otalai nenerana ma lomi na ude laloo feni bu'u feni. ");
INSERT INTO wuv_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Ma'uaa eni ne'ia eni, pa'afina ba hamonei nara ba Jesus, hia Christ, Na'uu mei Haidaa ma wagii fei narafawe'iaa hamu'ou, hamowe pa'i harenua a'a fei harana. ");
INSERT INTO wuv_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Nenee e'ei, Jesus na fa'arewadiai a'a ei otalai nenerana papaa fei Agii Tiberias. Fei fa'arewana ale'ei ba: ");
INSERT INTO wuv_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Simon Peter, Thomas (ana harana Didymus), Nathanael, mei na norai Cana i Galilee, laguei na'uu Zebedee mawe helaguidiai otalai nenera, rona gutafipui. ");
INSERT INTO wuv_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Simon Peter na warefanaa ro'ou, “Yau a dinaa agi.” Ma rona ware, “Hai'ou'aa aunufipui a'amu.” Si'ei, rona asi'aa ma hugi pafoo wa, ma'uaa a'a fei poi fei, lomi rona topa'aa hepalo. ");
INSERT INTO wuv_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Mafufuo badu, Jesus na ufalarai piye, ma'uaa ei otalai nenera, lomi rona aida ba Jesus. ");
INSERT INTO wuv_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Ina haroharonaa a'a ro'ou ba, “Ena tafiu, lomi hamona topa'aa hepalo?” Rona ware ba, “Lomi.” ");
INSERT INTO wuv_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Ina ware, “Pudigaa ei lepoo hamu'ou pepei haro'aa ma hamo'aa topa'i.” Ro'aa bigi'ia ale'ei, lomi rona forapa'aa fei lepoo uaa namina watauda ei nia. ");
INSERT INTO wuv_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Ma mei otalai nenera, mei na haguia Jesus, na warefanaa Peter ba, “Ana mei Fasu!” I'a guainaa fei Simon Peter ba, “Ana mei Fasu!” na papainaa fei hawaa uguna (uaa nado'o dudumia) ma na siginaa laloo agi. ");
INSERT INTO wuv_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Mei hemeadiai otalai nenera na suanenegia pafoo wa. Ina suaforaiaa fei lepo, fei na pepesu ei nia, uaa lomi rona raua piye, ale'ei faimfua pa'ania metre. ");
INSERT INTO wuv_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Ro'aa wanonaa piye, rona fanunupa'aa fei bafuroo hafi na pa'i nia pafona ma ana na pa'i ma'ida faraa pidaua. ");
INSERT INTO wuv_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Jesus na warenaa a'a ro'ou, “Tomai hefi'a nia, ena tonaa hamu'ou e'eni ua.” ");
INSERT INTO wuv_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Simon Peter na hugi ma adiamii fei lepo piye. Ina pepesu ei baua nia, hefa pu'u ma haipani pa'ania ma odumanu, ma'uaa, lomi na wara'a fei lepo a'a ei watauda nia. ");
INSERT INTO wuv_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Jesus na warenaa a'a ro'ou, “Mi hananafipui a'au.” Minaa ei otalai nenera na ma'au ba ro'aa i'iginia ba, “Yoi hini?” Rona aida ba hia mei Fasu. ");
INSERT INTO wuv_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Jesus namii tonaa fei faraa pidaua, fanaa ro'ou ma ana ale'ei a'a ei nia. ");
INSERT INTO wuv_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Hefei, fa'odupoaa fa'arewaa Jesus a'a ei otalai nenerana nenee fei asi'anana a'a ei ma'ea. ");
INSERT INTO wuv_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Ro'aa hananadii, Jesus na warenaa a'a Simon Peter, “Simon, mena na'uu John, pa'aa fa'ua ba fei haguamu yau na rata laraa fei haguamu ro'ou?” Ina ware, “Hi'i mena Fasu. Ona aida ba una haguio.” Jesus na ware, “Faguaa ei hapeu na'uu sipsipi.” ");
INSERT INTO wuv_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Jesus na warediai ba, “Simon, mena na'uu John, pa'aa fa'ua ba ona haguau?” Na ware, “Hi'i mena Fasu, ona aida ba una haguio.” Jesus na ware, “Oma'aiaa ei hapeu sipsipi.” ");
INSERT INTO wuv_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Ina warefa'odupoai ba, “Simon, mena na'uu John, ona haguau?” Na fi'i naranaraa Peter uaa Jesus na i'igai fa'odupoai a'ana ba, “Ona haguau?” Ina ware, “Mena Fasu, ona apa'aa minaa ei manumanu; ona aida ba una haguio.” Jesus na ware, “Faguaa ei hapeu sipsipi. ");
INSERT INTO wuv_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","A warefa'uai a'amu ba ei oi baubarai, ana yoi rafeaa susumu ma rararapa hitani nunumiamu; ma'uaa onawe bau, opowe roainaa guei panimu ma hemeadiai i falawalawainio ma talaidugio fawelei lomi ona nunuminia.” ");
INSERT INTO wuv_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Jesus na wareaa fei ba i fama'aiaa fei mau ma'ea i tonia Peter, fei ba i fani hawera a'a mei Haidaa wagina. Ma ina warefania, “Nenerau!” ");
INSERT INTO wuv_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Peter na diarai ma fanunupa'aa mei otalai nenera, mei na haguia Jesus ba na neneraa lagua. (Simei, mei na fapalaginaa a'a Jesus wagii fei hananaa, mei na ware ba, “Mena Fasu, hini ba i aloio?”) ");
INSERT INTO wuv_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","I fanunupa'ia Peter, na i'igai, “Mena Fasu, hia, batanai?” ");
INSERT INTO wuv_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Jesus na ware, “Nabaa a nunuminia ba inei guta nopa'aloo fei noramiau, abaa manumanumu. Onei nenegi'uaiau.” ");
INSERT INTO wuv_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","A'a fei, rona fileleleinia ei filofui ba mei otalai nenera mei, lomi i ma'e. Ma'uaa Jesus, abaa na ware ba lomi i ma'e; ina ware ua ba, “Nabaa a nunuminia ba inei guta nopa'aloo fei noramiau, abaa manumanumu.” ");
INSERT INTO wuv_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Simei, mei otalai nenera, mei fi u'ugaa eni manumanu eni ma ne'ifapana'ia. Ona aida ba ei u'ugana, pa'aa fa'ua. ");
INSERT INTO wuv_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Jesus, ana na bigi'aa wataudadiai manumanu. Nabaa ro ne'inaa bu'u minaa ei bigi'ana, woro feni malagufu, lomi i hawiaa ude'udee ei bu'u, ei ne'iaa ro'ou. ");
INSERT INTO wuv_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Mena Theophilus, a'a fei do'o ne'iau bu'u una ne'inaa minaa ei bigi'aa Jesus ma ei feroiana ");
INSERT INTO wuv_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","nopa'aloo fei ba ina warenaa a'a ei apostle, ei rafeiana wagii fei Spiriti Apuna ma nawe duginaa hia pafea mei Haidaa. ");
INSERT INTO wuv_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Nenee fei fi'iana, ina fa'arewa a'a eni rama'a eni ma na fama'aa ro'ou ba hia napa'aa mama'a. Ina fa'arewa a'a ro'ou laloo gunaroa pa'ania arewaa ma u'ufanaa ro'ou fei haparaiaa mei Haidaa. ");
INSERT INTO wuv_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Hefarani, ei fi hananafipui a'a ro'ou, na warefawe'i a'a ro'ou ba: “Apuna di'ininaa Jerusalem, ma'uaa oma'aa fei fana, fei fa'unaiaa mei Amau, fei diwareana a'a hamu'ou. ");
INSERT INTO wuv_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Uaa, John na pudugufinaa hamu'ou ranu, ma'uaa, ale'ena figa ua arewaa, hamowe pudugufai a'a fei Spiriti Apuna.” ");
INSERT INTO wuv_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Hee, ropowe figupui, rona i'iginia, “Mena Fasu, a'a feni au e'eni ba o fa'asi'adinaa fei haparaia a'a ei Israel?” ");
INSERT INTO wuv_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Ina warenaa a'a ro'ou: “Abaa manumanuu hamu'ou ba hamu'ou aida ena au o ena arewaa, ena nadii augia a'a fei foraforana, mei Ama. ");
INSERT INTO wuv_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Ma'uaa, hamowe to faufau ena na pasi pafoo hamu'ou fei Spiriti Apuna ma u'ugaa tamanu hamona fanunuia a'au yeni Jerusalem ma laloo minaa ei Judea ma Samaria ma minaa ei gufu a'a feni ano.” ");
INSERT INTO wuv_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","I waredigaa feni, mei Haidaa na duginaa hia pafea i pudaa ro'ou ma hepalo papalei na tapu'aa pudaa ro'ou. ");
INSERT INTO wuv_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Ifi aunulao pafea, ro'eimina araiaa nenena ma ana ei ua, helagui wawane, susuu lagua po'iaa, laguna u papaa ro'ou. ");
INSERT INTO wuv_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Laguna ware, “Ena Galilee, tani hamu'ou ufalarai yeni ma aranaa pafea? Ana mena Jesus mena, mena na duginaa hia pafea mei Haidaa, iwe hadiwe'imai ana ale'ei hamo'aa fanunuia fi dinaa pafea.” ");
INSERT INTO wuv_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Si'ei, rona hadiwe'inaa Jerusalem noramiaa ro'ou a'a fei maugeni, fei rona roroinia Maugeni Olive. Fei rauana a'a Jerusalem ale'ei ona talai laloo heai Sabbath. ");
INSERT INTO wuv_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Ro'aa sufudaimai, rona tafanenaa pafea ma wadu'ainaa fei humu rona guta wagina. Ei ro'ou yei, Peter, John, James, Andrew; Philip ma Thomas, Bartholomew ma Matthew; James mei na'uu Alphaeus ma Simon mei Zealot (mei na haguaa gufuna) mawe Judas, mei na'uu James. ");
INSERT INTO wuv_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Rona'aida lafulafufipui a'a ei pifine ma Mary, mei inaa Jesus mawe ei lofuna. ");
INSERT INTO wuv_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","A'a ei arewaa ei, Peter na ufalarai dupuaa ei narafawe'ia (hefaa gupuu rama'a puduu ro'ou, hefa pu'u ma enu pa'ania) ");
INSERT INTO wuv_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","ma ware, “Ena lofuu, fei Bu'u Apuna neipa'aa fa'uai, fei ba mina mina na umuinaa David fei Spiriti Apuna ba batanai Judas, mei famamoaa ei rona panarofaa Jesus— ");
INSERT INTO wuv_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","hia hemea maroaa o'ou ma ana na bigi a'a feni bigi'aa mei Haidaa.” ");
INSERT INTO wuv_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","(A'a fei pono'aa fei hafelo'ana, na pono'aa hefaa ano ma na pasifaro, fei hudi ununa na ba'atawara ma ei pepeana na lele'aa. ");
INSERT INTO wuv_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Minaa ei yei Jerusalem, rona guainaa fei, si'ei a'a fei wareagufuu ro'ou, rona roroinaa fei ano fei, Akeldama, hanuna ba fei Anoo Raraa.) ");
INSERT INTO wuv_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Peter na ware, “Hamatee, na ne'idii laloo fei Bu'uu Lauga, “‘Fei humuna neimina namonamoa; nemeadiai nei'aa guta wagina.’ ma, “‘Ma fei bigi'ana ba hia hemea famamoa, nemea nei tonia.’ ");
INSERT INTO wuv_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","Si'ei, na rawani ba onei rafeinaa hemea na tatalaifipui a'a o'ou ranimai ei fido'o oafipui a'a o'ou Jesus, ");
INSERT INTO wuv_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","hemea a'a o'ou wagii fei pudugufaiaa John, nopa'aloo fei au na duginaa Jesus pafea mei Haidaa. Uaa mei, inei rarafiaa o'ou u'ugaa fei asi'anana.” ");
INSERT INTO wuv_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Si'ei, rona uniaa helagui: Joseph, mei rona roroinia Barsabbas (ana harana Justus) mawe Matthias. ");
INSERT INTO wuv_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Ma rona lafulafu ba: “Mena Fasu, fa'arewaia a'a hai'ou ba hini lagua ona rafeidigia ");
INSERT INTO wuv_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","ba nei tonaa feni bigi'aa apostle, fei na rawaia Judas ba i retonaa fei arena.” ");
INSERT INTO wuv_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Si'ei, fei mau fifigaiaa ro'ou na uniaa Matthias ba nei rarafiaa e'ei hefua ma hemea apostle. ");
INSERT INTO wuv_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","I nodigimai fei arewaa Pentecost, rona oafipui hefawala. ");
INSERT INTO wuv_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Ana ei ua, na meme'ai fei ale'ei hefaa baua lalarena noranarai pafea ma namina fapepesuaa fei humu rona guta wagina. ");
INSERT INTO wuv_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Rona ma'apa'aa fei ale'ei mau ale'aleaa hafi na tafola ma faloro pafoo hememea ro'ou. ");
INSERT INTO wuv_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Fei Spiriti Apuna namina didifaa minaa ro'ou ma rona wareaa hefi'adiai wareagufu ale'ei i fawareaa ro'ou fei Spiriti Apuna. ");
INSERT INTO wuv_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Ma a'a fei au fei, yei Jerusalem na pa'i hefi'a Jew rona ma'auaa mei Haidaa; noramiaa ro'ou a'a minaa ei gufu a'a feni ano. ");
INSERT INTO wuv_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Ro'aa guainaa fei meme'aiaa fei, rona nofigupuimai fininaa tano'uawalai ro'ou, uaa hememea na guainia ba rona warenaa wareagufuna. ");
INSERT INTO wuv_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Ronamina maduofo ma i'igai: “Haa, eni rama'a roi wareware eni, abaa ro'ou Galilee? ");
INSERT INTO wuv_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Na'aa ale'ei, tani hememea o'ou na guaipa'aa ro'ou ale'ei wareagufuu o'ou? ");
INSERT INTO wuv_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Ale'ei wareaa ei Parthia, Media ma Elam; ei ro guta Mesopotamia, Judea ma Cappadocia, Pontus ma Asia, ");
INSERT INTO wuv_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","Phrygia ma Pamphylia, Egypt ma ei gufu i Libya na rafi'inaa Cyrene; ei noramiaa ro'ou Rome ");
INSERT INTO wuv_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","(minaa eni—ei Jew mawe ei rona filoginaa losuiaa ro'ou ba ro'ou Jew); ei Crete ma ei Arab—ona guainia ba ro'ei u'ugaa ei fananawalaa puda bigi'aa mei Haidaa a'a ei wareagufuu o'ou!” ");
INSERT INTO wuv_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Rona maduofo ma poapoai wagina ma fi'i'igai: “Tamanu hanuna fei?” ");
INSERT INTO wuv_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Ma'uaa hefi'a, rona fadinaa ro'ou ba: “Namina rata hunumaa ro'ou, wine.” ");
INSERT INTO wuv_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Si'ei Peter na ufalaraifipui a'a ei hefua ma hemea ma warefabauanai a'a fei gupuu rama'a: “Hamu'ou ena maroau Jew mawe hamu'ou ena hamona guta Jerusalem, yau ba a u'ugaa feni a'a hamu'ou; guaifarawaninaa tamanu a wareia. ");
INSERT INTO wuv_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Eni rama'a eni, lomi rona hunu poapoai ale'ei naraa hamu'ou. Faimeiai ido'o mafufuo ua eni! ");
INSERT INTO wuv_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Agia. Feni, fei nadii wareia mei mamama'a Joel: ");
INSERT INTO wuv_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","“‘A'a ei a'apoo arewaa, mei Haidaa na ware, yau, a aloarai fei Spiritiu pafoo minaa ei rama'a. Ena na'uu hamu'ou pifine ma wawane, ro'adii wareaa tamanu ba i nomai, ei baubaraa hamu'ou, ro'aa fanunuaa hefi'a manumanu laloo naranaraa ro'ou ale'ei mau foigia ma ei bau gufuu hamu'ou, ro'aa mefinaa hefi'a manumanu ale'ei mau foigia. ");
INSERT INTO wuv_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Ma a'a ei paniaa paniu anaa, pafoo minaa lagua, ei wawane ma pifine, awe ipiaa fei Spiritiu a'a ena arewaa ena, ma rowedii wareaa tamanu ba i nomai. ");
INSERT INTO wuv_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Awe au fananawalaa puda i pumanugawe ma hilala yeni malagufu ale'ei raraa, hafi ma hagu. ");
INSERT INTO wuv_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Fei halo, iwe filoginaa roromaa ma fei puda, iwe filogii ale'ei raraa hinene iwe nomai fei baua arewaa fininaa fei haweraa mei Fasu. ");
INSERT INTO wuv_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Ma hini ei rona lala'aa fei haraa mei Fasu, ro'aa tela.’ ");
INSERT INTO wuv_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","“Ena Israel, guainaa feni: mei Haidaa na fa'arewaiaa Jesus, mei Nazareth a'a hamu'ou wagii ei foigia, fananawalaa puda ma hilala, ei na biginaa hia a'a hamu'ou mei Haidaa, ei hamona apa'idigia. ");
INSERT INTO wuv_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Mei rama'a mei, rona aloia a'a hamu'ou ma mei Haidaa na aida ba i ale'ei ma nado'o naradigia; ma ei hafelo'a rama'a rona bigi'aa fei nunumiaa hamu'ou ma hamona fo'afama'eia ei hamo'aa fatawaia pafoo fei hawafolo. ");
INSERT INTO wuv_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Ma'uaa, mei Haidaa na fa'asi'ania a'a fei ma'ea ma alagia a'a fei fi'iaa fei ma'ea, uaa pa'aa lomi na hawia ba fei ma'ea i panarofia. ");
INSERT INTO wuv_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","David na warewareia ba: “‘Ranimai una fanunupa'aa mei Fasu i ma'au. Si'ei ba hia i pepei ma'auu, lomi ba a fa'asisi. ");
INSERT INTO wuv_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Si'ei, na ni'eni'e fei naranarau ma fei raweraweu na lalaugi; fei hudi unuu, ana i ude o'onai ");
INSERT INTO wuv_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","uaa, lomi o rawanaa yau a'a fei huapu, ma ana lomi ba o uga ba nei raia fei hudi unuu mei Apunaiamu. ");
INSERT INTO wuv_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Ona fama'aiau fei talaa faweweni; owemina fani'eni'eau inamoamu.’ ");
INSERT INTO wuv_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","“Ena lofu, apa'aa warefa'uai a'a hamu'ou ba mei amaa o'ou David na ma'e ma na i'ifai ma fei huapuna ana yeni nopa'amii wagieni. ");
INSERT INTO wuv_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Ma'uaa, hia hemea mamama'a ma na aida ba mei Haidaa na fa'unai a'ana ba i fagutanaa nemea upuna a'a fei gutanana, guta hapara. ");
INSERT INTO wuv_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Na apa'idigia ba tamanu i nomai ma'a na warewareaa fei asi'anaa mei Christ ba mei Haidaa, lomi i rawafanaa fei huapu ma ana lomi i wafuu fei hudi ununa. ");
INSERT INTO wuv_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Mei Haidaa na famama'aa meni Jesus. Ma minaa o'ou na fanunupa'ia ba pa'aa fa'ua fei. ");
INSERT INTO wuv_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Mei Haidaa na poro'aunaa hia i pepei ma'auna ma mei Ama na fania fei Spiriti Apuna, fei ina fa'unainia ma ipia ale'eni hamona fanunuia ma guainia e'eni. ");
INSERT INTO wuv_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Uaa, David lomi na dinaa pafea, ma'uaa ana na ware, “‘Mei Fasu na warenaa a'a mei Fasuu: “Guta i pepei ma'auu ");
INSERT INTO wuv_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","nopa'aloo fei ba unawe aunaa ei bidibidii unumu lalabenii pinemu.” ’ ");
INSERT INTO wuv_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","“Si'ei, minaa ei Israel, roneipa'aa aida feni, ba: mei Haidaa na fa'oanaa meni Jesus meni, meni hamona fatawaia ba hia Fasu ma Christ.” ");
INSERT INTO wuv_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Ro'aa guainaa fei ei rama'a, namina nafa'aa paruu ro'ou ma rona warenaa a'a Peter ma hefi'adiai apostle, “Ena lofu, o'aa bigi'aa tamanu wagii fei?” ");
INSERT INTO wuv_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Na ware Peter, “Minaa hamu'ou nei filoginaa naranaraa hamu'ou ma pudugufai a'a fei haraa Jesus Christ ba i futo ei hafelo'aa hamu'ou. Ma hamo'aa tonaa fei Spiriti Apuna. ");
INSERT INTO wuv_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Fei fa'unaia, manumanuu hamu'ou ma ei na'uu hamu'ou mawe minaa ei rona raua—a'a minaa ei na lala'aa ro'ou mei Fasu, mei Haidaniaa o'ou.” ");
INSERT INTO wuv_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","A'a wataudadiai warea, na aweinaa ro'ou ma i'igifawe'i a'a ro'ou ba, “Hamonei fawala'anaa hamu'ou a'a eni mau hafelo'aa feni tawe feni.” ");
INSERT INTO wuv_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Ei ro'aa guaitonaa u'ugana, rona pudugufai ma ale'ei odufua pufaba'a na rarafiaa fei puduu ro'ou fei arewaa fei. ");
INSERT INTO wuv_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Rona fafefenaa ro'ou a'a ei feroiaa ei apostle, fei gutafipuia, fei hananafipuia ma lafulafua. ");
INSERT INTO wuv_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Minaa ro'ou na fani ma'aua uaa ei watauda fananawalaa puda ma ei hilalaa foigia bigi'aa ei apostle. ");
INSERT INTO wuv_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Minaa ei narafawe'ia na gutafipui ma tamanu hememea na pa'i, manumanuu minaa ro'ou. ");
INSERT INTO wuv_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Rona aloaa ei hape ma ei finefinee ro'ou ma fanaa hini lomi na pa'i manumanuna. ");
INSERT INTO wuv_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Minaa ei arewaa rona'aida figupui i malalaa fei humuu mei Haidaa. Rona hananafipui faraa pidaua laloo humuu ro'ou ma wagii hepalo ua ni'eni'eaa naranara, ");
INSERT INTO wuv_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","rona uduginaa mei Haidaa. Ma minaa ei rama'a, rona ni'eni'e a'a ro'ou. Ma a'a ei rona tela, mei Fasu na fahono'aa puduu ro'ou laloo hepapalo arewaa. ");
INSERT INTO wuv_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Heai arewaa Peter ma John, lagu'ei dinaa humuu mei Haidaa a'a fei au lafulafua ale'ei oduai ido'o fafi. ");
INSERT INTO wuv_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Ma hemea rama'a, hemea na torotonamii fei iba'ibana, rona poronaa hia poaa fanefanee fei humuu mei Haidaa, fei rona roroinia Fananamai, fawelei rona fagutania hepapalo arewaa ba i noinoi a'a ei rona wadu'ainaa malalaa fei humuu mei Haidaa. ");
INSERT INTO wuv_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","I fanunupa'aa Peter ma John ba ana lagu'aa wadu'ai, ina i'iginaa lagua ba fani mugoo po'ina. ");
INSERT INTO wuv_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Peter ma John, laguna fanunufawanewanenaa a'ana. Ma na ware Peter ba, “Fanununamii a'a haigua!” ");
INSERT INTO wuv_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Si'ei, ina fanununaa a'a lagua hamatee na nara ba lagu'aa fani manumanuna. ");
INSERT INTO wuv_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Ma na ware Peter ba, “Silver o gold lomi una pa'i, ma'uaa tamanu na pa'i a fanio. Wagii fei haraa Jesus Christ mei Nazareth, talai.” ");
INSERT INTO wuv_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Ina tauaa fei panina pepei ma'au, fa'asi'ania ma ana ei ua, ei pinena na aloeloe ma nawe pa'i faufauna. ");
INSERT INTO wuv_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Ina'aa ufalarainaa pinena ma talai. Ma na nogiaa lagua dinaa i malalaa fei humuu mei Haidaa. Na tatalai, palapala ma uduginaa mei Haidaa. ");
INSERT INTO wuv_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Ro'aa fanunupa'ia ei rama'a ba na tatalai ma uduginaa mei Haidaa, ");
INSERT INTO wuv_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","rona fanunu'apa'ia ba ana mei na'aida guta noinoi i poaa fanefanee fei humuu mei Haidaa, fei rona roroinia Fananamai. Ma ronamina naranara watauda ma maduofo a'a fei rawani'ana. ");
INSERT INTO wuv_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Ei fi panarofaa Peter ma John mei noinoi, minaa ei, ronamina ba'arofo ma ponimai a'a ro'ou fawelei rona roroinia ba Palee Solomon. ");
INSERT INTO wuv_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","I fanunupa'aa fei Peter, na warenaa a'a ro'ou ba: “Ena Israel, tani i faba'arofoaa hamu'ou feni? Tani hamo'aa fanunufa'u'uaa haigua bana'aa ale'ei ei faufau haigua o fei nenegifarawaniaa haigua mei Fasu na fatalainaa meni rama'a meni? ");
INSERT INTO wuv_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Mei Haidaniaa Abraham, Isaac mawe Jacob, mei Haidaniaa ei amaa o'ou, hia na fani hawera a'a mei nafina Jesus. Hamona fifaninia panii hefi'a ba ronei fo'afama'eia ma ware ba lomi hamona nunuminia i pudaa Pilate, ei i nara ba i alagia. ");
INSERT INTO wuv_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Lomi hamona nunuminaa mei Apunaia, mei Wanewanea ma hamona i'igai ba ronei alafanaa hamu'ou mei na fo'afama'e rama'a. ");
INSERT INTO wuv_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Hamona fo'afama'eaa mei fafasui fei faweweni, ma'uaa, mei Haidaa na fa'asi'ania a'a fei ma'ea. Ona fanunudigaa fei manumanu fei. ");
INSERT INTO wuv_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","A'a fei narafawe'ia wagii fei haraa Jesus, meni hamona fanunuia ma apa'ia, hia na to faufau. A'a fei narafawe'ia wagii fei haraa Jesus, meni rama'a meni namina rawani'apoi ma minaa hamu'ou na fanunuaa fei. ");
INSERT INTO wuv_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","Si'ei, ena lofuu, una aida ba lomi hamona apa'aa tamanu hamona bigi'ia, ana ale'ei ei bauaniaa hamu'ou. ");
INSERT INTO wuv_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Ma'uaa, sifei fei tala ba i bigi'aa tamanu nadii wareia a'a ei mamama'a mei Haidaa ei i ware ba mei Christ i to fi'ia. ");
INSERT INTO wuv_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Si'ei, filoginaa naranaraa hamu'ou ma momo'inaa a'a mei Haidaa ba ei hafelo'aa hamu'ou i futo ma fei au gutafawenaia nei norai a'a mei Fasu ");
INSERT INTO wuv_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","ma ba i aloaa Jesus mei Christ, mei na rafeinia uaa hamu'ou. ");
INSERT INTO wuv_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Inei guta pafea nopa'aloo fei au ba mei Haidaa i auhadiwe'inaa minaa ei manumanu ale'ei fei fa'unaiana mina a'a ei apunai mamama'a. ");
INSERT INTO wuv_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Uaa, Moses na ware ba: ‘Mei Fasu, mei Haidaniaa hamu'ou i fa'asi'anaa nemea mamama'a ale'ei yau noramiana a'a fei maroaa hamu'ou; hamonei guainaa minaa ei warefanana hamu'ou. ");
INSERT INTO wuv_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Hini lomi i guainaa wareana ipowemina fi'alagii a'a ei maroana.’ ");
INSERT INTO wuv_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","“Hi'i. Minaa ei mamama'a a'a fei au Samuel ma nolao, hini ro'ou na wareware, ronadii wareaa eni arewaa eni. ");
INSERT INTO wuv_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Ma hamu'ou pai ei mamama'a ma wagii fei fi'ugaia watolaa mei Haidaa mawe ei amaa hamu'ou. Ina warenaa a'a Abraham, ‘A'a fei paimu, minaa ei rama'aa feni malagufu, ro'aa to hawegia.’ ");
INSERT INTO wuv_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Mei Haidaa na fa'asi'anaa mei nafina ma nado'o aloiamai a'a hamu'ou ba i haweginaa hamu'ou wagii fei ba i famomo'ainaa hememea a'a ei hafelo'ana.” ");
INSERT INTO wuv_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Ei bauaniaa humuu mei Haidaa ma mei bauaniaa ei oanananaa fei humuu mei Haidaa mawe ei Sadducee, rona dinaa a'a Peter ma John ei lagu'ei warewarenaa a'a ei rama'a. ");
INSERT INTO wuv_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Ronamina narafafelo hamatee ei apostle, ro'ei feroinaa ei rama'a ma u'u ba ei ma'ea, ro'aa asi'adiai uaa Jesus. ");
INSERT INTO wuv_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Rona panarofaa Peter ma John ma si'ei ba na fafidii, rona au'uaa lagua humuu bobo'aia nopa'aloo mafufuo. ");
INSERT INTO wuv_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Ma'uaa, watauda ei rona guainaa fei u'uga nawe narafawe'i wagina ma puduu ei naweree ale'ei haipani pufaba'a. ");
INSERT INTO wuv_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","I no'arewalao, ei hapara, ei bauaniaa gufu mawe ei feroiaa law, rona figupui i Jerusalem. ");
INSERT INTO wuv_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Annas, mei pa'aa bauaniaa humuu mei Haidaa, hia yei ma ana Caiaphas, John, Alexander mawe ei wawane, maroaa mei pa'aa bauaniaa humuu mei Haidaa. ");
INSERT INTO wuv_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Rona fa'ugaa Peter ma John i ma'aa ro'ou ma i'iginaa lagua ba: “A'a tamanu faufau o hara hamuna bigi'aa feni?” ");
INSERT INTO wuv_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","I dii, fei Spiriti Apuna na didifaa Peter ma ina warenaa a'a ro'ou: “Hamu'ou ena hapara ma bauaniaa ei rama'a! ");
INSERT INTO wuv_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","Nabaa hamo'aa labaginaa fei pa'afii fei rawani'a bigi'a a'a mei iba'iba ba batanai i rawanidiai, ");
INSERT INTO wuv_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","te, hamu'ou mawe minaa ei Israel, hamonei apa'aa feni: Meni i ufalarai i ma'aa hamu'ou ina rawani uaa fei haraa Jesus Christ, mei Nazareth, mei hamona fatawaia ma na fa'asi'ania a'a fei ma'ea mei Haidaa. ");
INSERT INTO wuv_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Hia fei “‘mugoo, fei rona siminia ei fadufadua ma nawe oanaa fafasui fei humu.’ ");
INSERT INTO wuv_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Fei tele'ana lomi a'a nemeadiai, uaa lomidiai hepalo hara yeni haroo pafea ba o'aa tela wagina.” ");
INSERT INTO wuv_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Ro'aa fanunupa'aa fei laugu'aa Peter ma John ma apa'ia ba lomi laguna dinaa feferoia ma lagua ale'ei rama'a ua, rona maduofo ma narapa'ia ba laguna tatalaifipui a'a Jesus mina. ");
INSERT INTO wuv_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Ma'uaa, si'ei ba rona fanunupa'ia ba na ufalaraifipui a'a lagua mei na pedu iba'ibana, lomi ba rona wareaa hepalo warea. ");
INSERT INTO wuv_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Si'ei, rona ware ba laguneido'o di'ininaa ei Sanhedrin ba ro'aa fiwarewarei. ");
INSERT INTO wuv_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","Rona fi'i'igai: “O bigi'aa tamanu a'a lagua? Minaa ei rama'a Jerusalem, rona aida ba lagunamina bigi'aa hepalo baua foigia ma lomi owe opa'aipa'aa fei. ");
INSERT INTO wuv_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Ma'uaa, fapapaunii feni manumanu feni ba nei'aa talaidiai a'a ei rama'a, o warefawe'i a'a lagua ba lagunei'aa waredinaa feni hara feni a'a nemea.” ");
INSERT INTO wuv_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Ma rona lala'idinamii lagua ma warefawe'i a'a lagua ba lagunei'aa fai u'u o feroinaa fei haraa Jesus. ");
INSERT INTO wuv_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Ma'uaa laguna ware Peter ma John ba, “Hamonei narama'aia. I rawani i pudaa mei Haidaa ba haigu'aa guainaa hamu'ou laraa hia? ");
INSERT INTO wuv_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Uaa, lomi ba haiguwe u'u'aupa'ainaa tamanu haiguna fanunuia ma guainia.” ");
INSERT INTO wuv_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Ro'aa warefamama'audigaa lagua, ronawe rawaiaa lagua. Lomi rona narapa'i ba batanai ro'aa fanima'aiaa lagua, uaa, minaa ei rama'a, rona uduginaa mei Haidaa a'a fei bigi'aa lagua. ");
INSERT INTO wuv_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Uaa, mei na pedu iba'ibana a'a fei foigia na muainaa gunaroa pa'ania igisimasi. ");
INSERT INTO wuv_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Lagu'aa aladii Peter ma John, laguna hadiwe'inaa a'a ei maroaa lagua ma u'ugaa minaa ei rona wareia a'a lagua ei famamoaa humuu mei Haidaa mawe ei bauaniaa gufu. ");
INSERT INTO wuv_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Ro'aa guainaa fei, a'a hepalo ua naranara, rona lafulafunaa a'a mei Haidaa. Rona ware ba, “Mena Fasu, mena ona bigi'aa tamanu nunumiamu, ona famamaraa fei pafea, feni malagufu ma fei agi ma minaa ei manumanu wagii ro'ou. ");
INSERT INTO wuv_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Wagii fei Spiriti Apuna, mei nafimu David, mei amaa hai'ou, na wareaa ei wareamu ba: “‘Tani ei baua gufu, ro'aa siba ma ei rama'a, rona naranara ba ro'aa bigi'aa hefi'a hafelo'a manumanu? ");
INSERT INTO wuv_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Ei haparaa feni ano, rona ufawe'i ma ei bauana, rona papa'ifipui ba ro'aa fadugeaa mei Fasu mawe mei Papaditaiana.’ ");
INSERT INTO wuv_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","Herod ma Pontius Pilate, laguna ma'adii ei Gentile mawe ei Israel yeni a'a feni baua gufu ma fiwarei ba batanai ro'aa fadugeaa Jesus, mei apunai nafimu, mei papaditaiamu.’ ");
INSERT INTO wuv_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Rona bigi'uaiaa tamanu onadii naraia ba ronei bigi'ia uaa fei faufaumu ma nunumiamu. ");
INSERT INTO wuv_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Si'ei, mena Fasu, narama'aiaa ei warefama'auaa ro'ou hai'ou ma hadumaa eni nafimu ba hai'ounei wareaa ei wareamu fininaa baua laugu'a. ");
INSERT INTO wuv_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Roainaa panimu, farawaninaa ei funua, bigi'aa ei hilalaa foigia ma fananawalaa puda a'a fei haraa mei nafimu Jesus, mei na apunai.” ");
INSERT INTO wuv_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Ro'aa lafulafudii, na rerere fawelei ro'aa figupui wagina. Ma fei Spiriti Apuna na didifaa minaa ro'ou ma rona u'ugaa fei wareaa mei Haidaa fininaa laugu'a. ");
INSERT INTO wuv_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Minaa ei narafawe'ia, rona pa'i hepalo ua pa'afi ma naranaraa ro'ou. Lomi hemea na ware ba ei manumanuna ana pa'aa manumanuna, ma'uaa, rona fifaninaa ei manumanuu ro'ou. ");
INSERT INTO wuv_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","A'a fei baua faufau, ei apostle rona'aida u'ugaa fei asi'anaa mei Fasu Jesus ma fei baua rawani'aa mei Haidaa na ude pafoo ro'ou. ");
INSERT INTO wuv_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Lomi hemea dupuaa ro'ou ba lomi manumanuna. Uaa, o nefarani, ei rona pa'i ano ma humuu ro'ou, rona aloaa e'ei, tonamai fei mugoo po'i wagina ");
INSERT INTO wuv_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","ma augia i igoaa ei apostle ma rona fi'alaginia a'a ei lomi rona pa'i. ");
INSERT INTO wuv_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Joseph, mei Levi, noramiana Cyprus, mei rona roroinia ei apostle ba Barnabas (hanuna ba Fararawanii Naranara), ");
INSERT INTO wuv_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","hia, na aloaa hefaa hapena ano ma tonamai fei mugoo po'i ma augia i igoaa ei apostle. ");
INSERT INTO wuv_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Hemea rama'a, harana Ananias fipuinaa mei harona, Sapphira, ana laguna aloaa hepalo anoo lagua. ");
INSERT INTO wuv_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Mei wawane na utofe'inaa ma'ida mugoo po'i ma mi augaa ei dufuna igoaa ei apostle ma mei harona na aida fei. ");
INSERT INTO wuv_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Ma na ware Peter ba, “Ananias, tani i forapa'aa naranaramu Satan ma ona warefasifi a'a fei Spiriti Apuna ma ona utofe'inaa ma'ida mugoo po'i a'a fei aloamu anomu? ");
INSERT INTO wuv_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Haa, a'a ba manumanumu ei ana otawe aloia? Ma o alodigia, a'a ba mugoo po'imu? Tamanu na foraa naranaramu ba o bigi'ia ale'ei? Abaa oi sifi'aa ei rama'a, ma'uaa, mei Haidaa.” ");
INSERT INTO wuv_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","I guainaa fei Ananias, na pasima'e. Ma minaa ei rona guainaa fei, ronamina ma'aufafelo. ");
INSERT INTO wuv_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Ma si'ei, ei baubara, rona nomai, sumaa fei hudi ununa ma poronaa hia ano ma i'ifinia. ");
INSERT INTO wuv_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Nenee ale'ei oduai hour, mei harona na wadu'aimai ma lomi na aida ba tamanu napa'aa mei harona. ");
INSERT INTO wuv_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Na i'iginia Peter, “Warefanau, sifeni feni pono'aa feni ano hamugua Ananias na tonia?” Ina ware ba, “Hi'i. Sifena fena pono'ana.” ");
INSERT INTO wuv_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Peter na warenaa a'ana, “Tani hamu'aa fi'u'ugai ba hamu'aa maniaa fei Spiritii mei Fasu? Ma'aia! Ei pinee ei ro'aa i'ifinaa mei haromu na nofarafi'idigimai papaa fei gigei. Ma ana ro'aa notabeio ale'ei.” ");
INSERT INTO wuv_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Ana ei ua, ina pasima'e i igoana. Si'ei, ro'aa wadu'aimai ei baubara ma fanunupa'ia ba ina ma'e, rona tabenaa hia ano ma i'ifinia papaa mei harona. ");
INSERT INTO wuv_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Minaa ei losuia mawe ei rona guainaa fei, ronamina ma'au. ");
INSERT INTO wuv_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Ei apostle, rona bigi'aa watauda ei hilalaa foigia ma fananawalaa puda dupuaa ei rama'a. Ma wagii hepalo ua naranara, minaa ei, rona'aida figupui i Palee Solomon. ");
INSERT INTO wuv_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Fa'ua ba ei rama'a yei na nara ba ei apostle ma ei narafawe'ia, rona raraba, ma'uaa, lomi hemeadiai na nomai a'a ro'ou. ");
INSERT INTO wuv_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Ma'uaa, wataudadiai wawane ma pifine, rona narafawe'i a'a mei Fasu ma pafoinaa fei puduu ro'ou. ");
INSERT INTO wuv_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Si'ei, ei rama'a, rona dugamii ei funua i ma'aa tala ma fudigaa ro'ou pafoo tawa ma hafenaa unu ba fei hanunuu Peter nei pasi pafoo ro'ou ena na talaifalogilao. ");
INSERT INTO wuv_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Rona figupuirai ei gupuu rama'a laloo ei pusu'o gufu na rafi'inaa Jerusalem ma nodugaree ei funua mawe ei na wadu'aa ro'ou ei spiriti hafelo ma minaa ro'ou, na rawani. ");
INSERT INTO wuv_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Ma mei pa'aa bauaniaa humuu mei Haidaa mawe minaa ei paniaa panina, ei ro'ou maroaa ei Sadducee, ronamina punepune. ");
INSERT INTO wuv_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Rona panarofaa ei apostle ma augaa ro'ou laloo humuu bobo'aiaa fei gufu. ");
INSERT INTO wuv_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Ma'uaa laloo fei poi, hemea alo'aloo mei Fasu na gigiaa ei gigei fei bobo'aia ma duginaa ro'ou i ano. ");
INSERT INTO wuv_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","Ina ware, “Hamowii ufalarai i malalaa fei humuu mei Haidaa ma u'ufanaa ei rama'a minaa fei u'uga wagii feni manufau harenua.” ");
INSERT INTO wuv_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","I ba'amai panii fei arewaa, rona wadu'ainaa malalaa fei humuu mei Haidaa ana ale'ei guaiaa ro'ou ma feroinaa ei rama'a. I nodigimai mei pa'aa bauaniaa humuu mei Haidaa mawe ei paniaa panina, rona lala'ifipuinamii ei Sanhedrin—minaa ei bauaniaa gufuu Israel—ma aloaa hefi'a ba ronei dugamii ei apostle yei bobo'aia. ");
INSERT INTO wuv_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Ma'uaa ro'aa nosufudailao i bobo'aia, lomi rona labagipa'aa ro'ou yei ei oma'ama'aa. Si'ei, rona hadiwe'ai ma u'u ba, ");
INSERT INTO wuv_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","“Hai'ouna fanunupa'ia ba ei gigei fei bobo'aia napa'aa fawi ma rona ufalarai a'a ei gigei ei oma'ama'aa; ma'uaa hai'ou'aa gigiaa ei gigei yei, lomi hemea lalona.” ");
INSERT INTO wuv_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Mei bauaniaa ei oanananaa fei humu mawe ei famamoaa humuu mei Haidaa, ro'aa guainaa fei u'uga, ronamina poapoai wagina ma naranara ba tamanudiai ba i nomai a'a feni. ");
INSERT INTO wuv_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Si'ei, na nomai hemea ma ware, “Me'o! Ei hamona aunaa ro'ou bobo'aia, ro'ou yei malalaa humuu mei Haidaa ma roi ufeferoinaa ei rama'a.” ");
INSERT INTO wuv_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","A'a fei, mei bauana fipuinaa ei bauaniaa ei paniaa panina, rona dugamii ei apostle. Lomi rona foraneneinaa ro'ou, uaa rona ma'au ba ro nafa'aa ro'ou ei rama'a. ");
INSERT INTO wuv_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Ro'aa dugidigamii ei apostle, rona fa'ufalarainaa ro'ou i ma'aa ei Sanhedrin ba mei pa'aa bauaniaa humuu mei Haidaa i i'igainaa ro'ou hefi'a i'igaia. ");
INSERT INTO wuv_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","Ina ware ba, “Hai'ouna apunainaa hamu'ou ba hamonei'aa feroi a'a fei hara fei. Ma'uaa hamona fatalainaa fei feroiaa hamu'ou yeni Jerusalem ba hamo'aa guguinaa unuu hai'ou fei raraa mei rama'a mei.” ");
INSERT INTO wuv_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Peter mawe ei apostle, rona ware, “Hai'ounei guainaa wareaa mei Haidaa laraa ei rama'a! ");
INSERT INTO wuv_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Mei Haidaniaa ei amaa o'ou na fa'asi'anaa Jesus wagii fei ma'ea, mei hamona fo'afama'eia ei hamo'aa fatawaia a'a fei haihai. ");
INSERT INTO wuv_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Mei Haidaa na poro'aunaa hia i pepei ma'auna ba hia Hapara ma Fatela'ana ba i fani filogiaa naranara ma futoaa ei hafelo'aa ei Israel. ");
INSERT INTO wuv_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","O'ou, ona fanunuaa e'ei manumanu e'ei ma fei Spiriti Apuna ana na fa'arewaia ba fa'ua. Ma ei rona neneraa mei Haidaa, hia na fanaa fei Spiriti a'a ro'ou.” ");
INSERT INTO wuv_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Ro'aa guainaa fei, namina fifi'i unuu ro'ou ma na'aa ro fo'afama'eaa ro'ou. ");
INSERT INTO wuv_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Ma'uaa, hemea Pharisee, harana Gamaliel, hemea feroiaa law, mei rona ma'auia minaa ei rama'a, hia dupuaa ei Sanhedrin, ina ufalarai ma ware ba roneido'o fa'asi'anaa ei apostle ano. ");
INSERT INTO wuv_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Ma na warenaa a'a ro'ou: “Ena Israel, narama'aia tamanu hamo'aa bigi'ia a'a ro'ou. ");
INSERT INTO wuv_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Mina, Theudas na nomai ma ware ba hia hemea baua rama'a ma ale'ei gunaroa pu'u rama'a na nenegia. Rona fo'afama'eia ma ei nenerana na matala ma lomidiai manumanu wagina. ");
INSERT INTO wuv_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Nenena, Judas, mei Galilee na nomai a'a fei au wareiaa rama'a ma famamotonaa hefi'a ma fa'asi'anaa sibaa. Hia anaa, rona fo'afama'eia ma minaa ei nenerana na ba'autorai. ");
INSERT INTO wuv_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Si'ei, a'a fei manumanu e'eni, a warefanaa hamu'ou ba: Apuna papa'aa ro'ou! Fa'aunuaa ro'ou! Uaa, nabaa fei bigi'aa ro'ou, bigi'aa rama'a ua, i pa'ai ua. ");
INSERT INTO wuv_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Ma'uaa, nabaa noranarai a'a mei Haidaa, lomi ba hamowe paunaipa'aa ro'ou; hamowe nanamui'uaia ba ale'ei hamona fifo'ai a'a mei Haidaa.” Na hafududumaa ro'ou ei warewareana. ");
INSERT INTO wuv_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Rona guainaa wareana ma fawadu'ainamii ei apostle ma babuinaa ro'ou. Rona apunainaa ro'ou ba ronei'aa u'u a'a fei haraa Jesus ma fa'aunuaa ro'ou. ");
INSERT INTO wuv_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Ei apostle, rona di'ininaa ei Sanhedrin fininaa ni'eni'ea uaa rona nara ba rona rawani ma'ida hamatee rona tonaa fi'ia ma mamafaa a'a fei hara. ");
INSERT INTO wuv_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Minaa ei arewaa, i malalaa fei humuu mei Haidaa ma a'a hepapalo humu, lomi rona fafaa feferoi o u'ugaa fei rawani'a warea ba Jesus, hia mei Christ. ");
INSERT INTO wuv_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","A'a ei arewaa ei, ei ipowe gipelao fei puduu ei otalai nenera, ei Greece Jew dupuaa ro'ou, rona bababau'unaa ei Hebrew Jew, uaa, lomi rona oma'afarawaninaa ei pifine ma'esuabea a'a ro'ou. Lomi rona fafanunuaa ro'ou wagii fei alagiaa du'ua hepapalo arewaa. ");
INSERT INTO wuv_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Si'ei, ei Hefua ma Helagui, rona apaifigupuinaa ei otalai nenera ma ware, “Lomi na rawaninaa o'ou ba o'aa ba'ofaa fei bigi'aa fei u'ugaa fei wareaa mei Haidaa wagii fei alagiaa du'ua. ");
INSERT INTO wuv_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Ena lofuu, hamonei rafeinaa oloromeai i dupuaa hamu'ou, ena rona pepesu a'a fei Spiriti ma fei apa'a. Ma o'aa fifaninaa feni bigi'a a'a ro'ou ");
INSERT INTO wuv_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","ma o'ou, o lafulafu ma u'ugaa fei warea. ");
INSERT INTO wuv_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Fei naranara fei, na rawani ua a'a minaa fei gupuu ro'ou. Rona rafeinaa Stephen, hemea namina we'i naranarana ma pepesu a'a fei Spiriti Apuna; ma Philip, Procorus, Nicanor, Timon, Parmenas ma Nicolas, mei Antioch, hemea na filoginaa losuna ba hia Jew. ");
INSERT INTO wuv_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Rona fa'ugaa ei rama'a i a'a ei apostle. Ma ei apostle, rona augaa panii ro'ou pafoo ei oloromeai ma lafulafu. ");
INSERT INTO wuv_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Ma fei wareaa mei Haidaa na tale. Ma na apoidiai fei puduu ei otalai nenera yei Jerusalem ma watauda ei bauaniaa humuu mei Haidaa nawe neneraa fei mau we'iaa naranara. ");
INSERT INTO wuv_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Stephen, hia hemea na pepesu a'a fei rawani'a ma faufau mei Haidaa ma na bigi'aa hefi'a baua fananawalaa puda ma hilalaa fogia i pudaa rama'a. ");
INSERT INTO wuv_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Ma'uaa, rona fiharei a'ana ei maroaa fei Synagogue ei Rona Ala (hara fei). Fei maroa fei, ro'ou Jew Cyrene ma Alexandria fipuinaa ei Jew yei laloo guei baua gufu fawelei Cilicia ma Asia. Rona fiharei a'a Stephen, ");
INSERT INTO wuv_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","ma'uaa, lomi rona hawiaa fei apa'ana o fei Spiriti, fei na umuinaa hia. ");
INSERT INTO wuv_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Ma rona fiwarei'opa'ai ma u'ugainaa hefi'a ba ronei ware ale'ei ba, “Hai'ouna guainaa Stephen na warefafeloaa Moses ma mei Haidaa.” ");
INSERT INTO wuv_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Si'ei, rona fababainaa iaa ei rama'a ma ei bauaniaa gufu mawe ei feroiaa law. Rona panarofaa Stephen ma fa'ugia pudaa ei Sanhedrin. ");
INSERT INTO wuv_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Rona dugamii hefi'a rona u'ufasifi ale'ei ba, “Meni rama'a meni, lomi na fafaa warefafeloaa feni apunaia humu ma fei law. ");
INSERT INTO wuv_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Uaa, hai'ouna guainia na ware ba Jesus, mei Nazareth i fawata'o'oaa feni humu feni ma filoginaa ei maumau, ei na fanaa o'ou Moses.” ");
INSERT INTO wuv_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Minaa ei rona guta a'a ei Sanhedrin, rona fanunufa'u'uaa Stephen ma fanunupa'aa fei mau pudana ba ale'ei pudaa hemea alo'alo. ");
INSERT INTO wuv_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Si'ei, mei pa'aa bauaniaa humuu mei Haidaa na i'iginia, “Fa'ua, e'ei warea e'ei?” ");
INSERT INTO wuv_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","A'a fei ina ware, “Ena lofu ma ena ama, guainau! Mei Haidaniaa fei hawera na fa'arewa a'a mei amaa o'ou Abraham ei hia yei Mesopotamia ma atawe guta Haran. ");
INSERT INTO wuv_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","Mei Haidaa na ware, ‘Di'ininaa gufumu ma ei rama'aa gufumu ma dinaa a'a fei gufu yau a fama'aio.’ ");
INSERT INTO wuv_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","“Si'ei, ina di'ininaa fei gufuu ei Chaldea ma naree guta i Haran. I ma'edii amana, mei Haidaa na alonaa hia a'a feni gufu hamo'ei guta wagina. ");
INSERT INTO wuv_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Lomi na fania hepalo manumanu yei ana pa'aa lomi ma'ida malagufu. Ma'uaa, mei Haidaa na fa'unai ba hia mawe ei paina nefarani, ropowe tonaa fei malagufu, ma'uaa, a'a fei au fa'unaia atawe pa'i na'una Abraham. ");
INSERT INTO wuv_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Mei Haidaa na warenaa a'ana ale'ei: ‘Ena paimu, ro'aa ale'ei rama'a rauaa laloo hefaa gufu abaa gufuu ro'ou ma oa ale'ei humuwa ma tonaa haperaraiaa ro'ou laloo gunaroa pu'u igisimasi. ");
INSERT INTO wuv_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Ma'uaa, a fanima'aiaa fena baua gufu, fena ro'aa humuwai wagina. Ma hinene, ro'aa wala'amai wagina ma losuinau faweleni.’ ");
INSERT INTO wuv_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Ma ina fanaa Abraham fei fi'ugaiaa fei moro'aa hudii wawanei. Ma Abraham nawe oanaa amaa Isaac ma moro'aa hudii wawaneina laloo fei fafainaroaa arewaa nenee fei waniniana. Hinene, Isaac nawe oanaa amaa Jacob ma Jacob na oanaa amaa ei hefua ma helagui ama mina. ");
INSERT INTO wuv_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","“Si'ei ba ei ama mina, rona punepune a'a Joseph, rona alonaa hia Egypt ale'ei humuwa. Ma'uaa, mei Haidaa na oafipui a'ana ");
INSERT INTO wuv_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","ma hadumia a'a minaa ei hafelo'ana. Ina fani apa'aa Joseph ma farawaninia i pudaa Pharaoh, mei haparaa Egypt; si'ei, ina fagutania ba hia haparaa Egypt ma fei humuna, humuu hapara. ");
INSERT INTO wuv_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","“I dii, na nomai fei au mouabiabia wagii minaa ei gufu laloo Egypt ma Canaan, nofininamii baua fi'ia ma ei amaa o'ou, lomi rona pa'i du'ua. ");
INSERT INTO wuv_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","I guainia Jacob ba na pa'i lau guana i Egypt, na aloaa ei amaa o'ou a'a fei rawarawa aunuaa ro'ou. ");
INSERT INTO wuv_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","A'a fei faguapoaa aunuaa ro'ou, Joseph na warefanaa ei lofuna ba hia hini ma Pharaoh nawe apa'aa ei maroaa Joseph. ");
INSERT INTO wuv_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Nenee fei, Joseph na apainamii amana Jacob mawe minaa ei maroana; puduu ro'ou, oloromfua ma haipani. ");
INSERT INTO wuv_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Si'ei, Jacob na dinaa Egypt ma hia mawe ei amaa o'ou, rona ma'e yei. ");
INSERT INTO wuv_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Ei hudi unuu ro'ou, rona porohadiwe'idinaa Shechem ma na fahainopaa ro'ou laloo fei huapu na'ana'a, fei i pononaa hefi'a mugoo po'ii Abraham a'a ei na'uu Hamor yei Shechem. ");
INSERT INTO wuv_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","“I nofarafi'imai fei au mei Haidaa ba i bigi'aa fei fa'unaiana a'a Abraham, fei puduu ei gufuu o'ou yei Egypt nawemina rata. ");
INSERT INTO wuv_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Ma hemeadiai na tonaa fei hapara yei Egypt, hemea lomi na apa'aa Joseph. ");
INSERT INTO wuv_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Ina haperararaiaa ei maroaa o'ou ma humuwainaa ei upuu o'ou ba ronei siminaa ei baduu we wanini'uaa ba ronei ma'e. ");
INSERT INTO wuv_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","“Ma fei au fei, na wanini Moses ma abaa hia baduu ua. Laloo oduai puda rona oma'aia yei humuu mei amana. ");
INSERT INTO wuv_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Ei ropowe poro'aunaa hia ano ma di'ininia, mei pifine, na'uu Pharaoh, na poro'ia ma oma'aia ba hia pa'aa na'una. ");
INSERT INTO wuv_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Rona feroinaa Moses a'a minaa ei apa'aa Egypt. Ei wareana ma bigi'ana namina honua. ");
INSERT INTO wuv_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","“Moses na pa'i gunaroa pa'ania igisimasina ei i nara ba ido'o ma'a ei gufuna Israel. ");
INSERT INTO wuv_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Ina fanunupa'aa hemea Egypt na fafeloaa hemea gufuna. Si'ei, na nolao ba i hadumia ma fo'afama'eaa mei Egypt. ");
INSERT INTO wuv_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Naranaraa Moses ba ei gufuna, ro'aa fanunu'apa'ia ba mei Haidaa na rafeinia ba hia i alaraa ro'ou, ma'uaa, lomi rona fanunu'apa'ia. ");
INSERT INTO wuv_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Ma iree arewadiai, Moses na nobapa'amii helagui Israel, lagu'ei fifo'ai. Ba i fawanewaneaa lagua ina ware ale'ei, ‘Megu, hamugua filofui. Tani hamu'aa itainaa raraa unuu hamugua?’ ");
INSERT INTO wuv_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","“Ma'uaa, mei i fo'a, na susuninaa Moses ma ware ba, ‘Hini na augio ba bauana ma fawanewaneaa haigua? ");
INSERT INTO wuv_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Haa, ana ba o fo'afama'eau ale'ei o fo'afama'eaa mei Egypt minoa?’ ");
INSERT INTO wuv_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","I guainaa fei Moses, na ma'au ponipa'ainaa Midian ma naree guta yei ale'ei rama'aa gufu raua ma na pa'i helagui na'una, baduu wawane. ");
INSERT INTO wuv_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","“I nodigilao gunaroa pa'ania igisimasi, hemea alo'alo na fa'arewa a'a Moses laloo fei haihai na gu'a fawelei lomi guana o hepalodiai manumanu papaa Maugeni Sinai. ");
INSERT INTO wuv_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","I fanunupa'aa fei, na maduofo wagina. I nolao ba i fanunu, na guainaa fei lao mei Fasu: ");
INSERT INTO wuv_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","‘Yau mei Haidaniaa ena amamu. Mei Haidaniaa Abraham, Isaac ma Jacob.’ Namina ma'aufunurere Moses ma ba lomi ipo'o fanunu. ");
INSERT INTO wuv_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","“Ma mei Fasu na warenaa a'ana, ‘Dudumaa ei hafenaa pinemu, uaa fawelena o u wagina na apunai. ");
INSERT INTO wuv_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Unapa'aa fanunupa'aa fei gutafafeloaa ei rama'aa gufuu yei Egypt. Na guaidigaa ei ai'aigaa ro'ou ma na nogio ba a alaraa ro'ou. Nadii, nomai. Yau a alohadiwe'inio Egypt.’ ");
INSERT INTO wuv_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","“Ana mei Moses mei, mei lagu'aa fadugeia ma ware ba, ‘Hini na augio bauana ma fawanewaneaa haigua?’ Ana simei na fa'arewa a'ana mei Haidaa wagii fei haihai ale'ei alo'alo ma na aloia ba hia bauaniaa ro'ou ma alaraa ro'ou. ");
INSERT INTO wuv_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Na dugamii ro'ou yei Egypt ma bigi'aa manumanuu fananawalaa puda ma ei hilalaa foigia yei Egypt a'a fei Roa Agi ma ana laloo gunaroa pa'ania igisimasi yei lomi guana ma haihai. ");
INSERT INTO wuv_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","“Ana mei Moses, mei i ware a'a ei Israel ba, ‘Mei Haidaa, iwe aloaa hemea mamama'a ale'ena yau i tapuu ena rama'aa gufuu hamu'ou.’ ");
INSERT INTO wuv_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Hia hemea dupuaa fei gupuu ei rama'a fawelei lomi haihai ma guana a'a mei alo'alo, mei i wareware a'ana pafoo Maugeni Sinai ma a'a ei amaa o'ou. Ma na tonaa ei warea na udelao ba i fifaninamai a'a o'ou. ");
INSERT INTO wuv_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","“Ma'uaa, ei amaa o'ou, rona barafeia. Rona ofadugia ma ei naranaraa ro'ou na hadiwe'idinaa Egypt. ");
INSERT INTO wuv_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Rona ware a'a Aaron, ‘Bigifani haidaniaa hai'ou ba nei famamoaa hai'ou. Uaa, meni Moses, meni i dugifalele'anaa hai'ou yei Egypt, lomi hai'ouna aida ba hia batanai!’ ");
INSERT INTO wuv_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Ana fei au fei, rona bigi'aa fei haidaniaa ro'ou, maumauna ale'ei na'uu buduma'ao. Rona fani fanaa ro'ou a'ana ma hamamani ma bigi baua du'ua hamatee ba ro teninaa fei bigi'aa panii ro'ou. ");
INSERT INTO wuv_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Ma'uaa, mei Haidaa na ofadugaa ro'ou ma rawaiaa panina a'a ro'ou ba ro'aa losuinaa ei manumanu haroo pumanugawe. Hefeni ana ale'ei fei ne'ia laloo fei bu'uu ei mamama'a: “‘Haa, hamona fani fanaa hamu'ou a'au ma mi au manumanu a'au i a'a fei talaiaa hamu'ou laloo gunaroa pa'ania igisimasi yei lomi haihai o guana, hamu'ou ena Israel? ");
INSERT INTO wuv_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Hamona poro'aa fei palee Molech ma fei pi'uu mei haidaniaa hamu'ou, Rephan, ma ei bigi'aa hamu'ou ba hamo'aa losuinia. Si'ei, a alonaa hamu'ou suwidenaa Babylon ale'ena rama'a, lomi gufuu ro'ou.’ ");
INSERT INTO wuv_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","“Yei lomi haihai o guana, ei amaa o'ou mina, rona pa'i fei humuu mei Haidaa poroporo, fei na pa'i bao fei law lalona. Rona bigi'ia ale'ei tamanu inado'o fanunuia Moses ei i warefania mei Haidaa. ");
INSERT INTO wuv_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Ro'aa todigaa fei humuu mei Haidaa poroporo ei amaa o'ou a'a fei famamoaa Joshua, rona notofininia a'a ro'ou ei ro'aa tonaa fei malalagufu a'a ei rama'aa fei baua gufu, ei na teteaa ro'ou mei Haidaa. Fei humu fei, na oa a'a ro'ou nopa'aloo fei au David, ");
INSERT INTO wuv_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","mei na ni'eni'e a'ana mei Haidaa, mei i i'igai ba i bigifani humuu mei Haidaniaa Jacob. ");
INSERT INTO wuv_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Ma'uaa, Solomon, hia mei i fadufani humuna. ");
INSERT INTO wuv_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","“Ma'uaa, mei na Pa'aa Pafeai, lomi i guta laloo ei humu faduaa rama'a. Ale'ei i wareia mei mamama'a: ");
INSERT INTO wuv_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","“‘Na ware mei Fasu, fei gufu pafea, gutanau ma feni malagufu, lalabenii pineu. Humu bata fei ba o'aa bigifanau? O i fawelei hitani ba a gutafawenai? ");
INSERT INTO wuv_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Haa, a'a ba eni manumanu eni, bigi'aa paniu?’ ");
INSERT INTO wuv_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","“Na pa'aa waiwai tabaa hamu'ou. Ei naranara ma adiaa hamu'ou, tawi'ana ale'ei ei lomi na moro hudii wawanei! Hamu'ou pa'aa ale'ena ena amaa hamu'ou: Ranimai hamona'aida fadugeaa fei Spiriti Apuna! ");
INSERT INTO wuv_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Ina pa'i hemea mamama'a mina ba lomi rona haperararaia ei amaa hamu'ou? Ana ronamina fo'afama'eaa ei ronadii wareaa fei noramiaa mei Wanewanea. Ma eni, hamona aloia ma fo'afama'eia— ");
INSERT INTO wuv_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","hamu'ou ena na todigaa fei law, fei rona wareia ei alo'alo, ma'uaa, lomi hamona nenegia.” ");
INSERT INTO wuv_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Ro'aa guainaa fei, rona sibafafelo ma fi'u'uinaa difoo ro'ou a'ana. ");
INSERT INTO wuv_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Ma'uaa fei Spiriti Apuna na didifaa Stephen ma ina aranaa gufu pafea, fanunupa'aa fei haweraa mei Haidaa ma Jesus na ufalarai i pepei ma'au mei Haidaa. ");
INSERT INTO wuv_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Ina ware, “Fanunu. Una fanunupa'aa fei gufu pafea na ba'agigi ma mei Na'uu Rama'a fi ufalarai i pepei ma'au mei Haidaa.” ");
INSERT INTO wuv_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","A'a fei, rona lotomaa adiaa ro'ou ma tomewai ma minaa ro'ou na ponifafifi'inaa a'ana, ");
INSERT INTO wuv_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","foraneneneinia, notonaa hia auguu fei gufu ma nafanaa hia mugoo. Ma ei rama'a, ei ro'aa haperararaia, rona augaa ei susuu ro'ou pinee hemea wawane harana Saul. ");
INSERT INTO wuv_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Ei roi nafa'ia, Stephen na lafulafu, “Mena Fasu Jesus, tonaa fei spiritiu.” ");
INSERT INTO wuv_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Ma na pasi unaa du'una ma haroharo, “Mena Fasu, futoaa eni hafelo'aa ro'ou.” I'a wareia fei, nawe ma'igu. ");
INSERT INTO wuv_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Ma Saul, hia yei ma na ugainaa fei ma'eana. Ma a'a fei arewaa fei, na pa'i hefaa baua haperararaia a'a ei losuia yei Jerusalem ma minaa ro'ou, ronamina ba'autorainaa yei Judea ma Samaria ma ei apostle, lomi. ");
INSERT INTO wuv_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Ei ronapa'aa neneraa mei Haidaa, rona i'ifinaa Stephen ma ronamina faloloa'inia. ");
INSERT INTO wuv_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Ma'uaa, Saul fipowe fafeloaa fei gutanaa ei losuia. Ina wadu'ainaa hepapalo humu ma foraneneneinaa ei wawane ma pifine ma aunaa ro'ou bobo'aia. ");
INSERT INTO wuv_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Ei rama'a rona ba'autorai, rona u'ugaa fei rawani'a warea a'a ei gufu rona dinaa wagina. ");
INSERT INTO wuv_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Philip na dinaa hepalo gufu yei Samaria ma u'ugaa mei Christ yei. ");
INSERT INTO wuv_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Ro'aa guainaa Philip ei gupuu rama'a ma fanunupa'aa ei hilalaa foigia ina bigi'ia, minaa ro'ou, rona guaifarawaninaa tamanu ei wareana. ");
INSERT INTO wuv_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Ei spiriti hafelo, rona iwa ma wala'amai a'a watauda rama'a ma watauda ma'eaa unu mawe ei iba'iba, hia na farawaninaa ro'ou. ");
INSERT INTO wuv_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Si'ei, na bauana fei ni'eni'ea laloo fei baua gufu fei. ");
INSERT INTO wuv_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Na pa'i hemea rama'a harana Simon nafane bigi'aa fifinesi laloo fei gufu ma famalefaiaa minaa ei rama'aa Samaria. Ina warefa'agu'agu ba hia baua rama'a ");
INSERT INTO wuv_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","ma minaa ei rama'a, ei bauana mawe ei rama'a ua, rona guainia ma ware ba, “Meni rama'a meni na pa'i faufau mei Haidaa, fei rona wareia ba fei Baua Faufau.” ");
INSERT INTO wuv_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Rona nenegia uatani, ranimai na famadi'aa pudaa ro'ou a'a fei fifinesina. ");
INSERT INTO wuv_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Ma'uaa ei pifine ma wawane, ei ro nara ba fa'ua fei u'ugaa Philip, rona pudugufai ei i u'ugaa fei rawani'a wareaa fei haparaiaa mei Haidaa ma fei haraa Jesus Christ. ");
INSERT INTO wuv_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Simon, ana na nara ba fa'ua fei ma na pudugufai. Ma ina talai neneraa Philip na dinaa hitani. Ma na malefa a'a ei baua hilala ma foigia ina fanunuia. ");
INSERT INTO wuv_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Ro'aa guainia ei apostle yei Jerusalem ba ei Samaria rona tonaa fei wareaa mei Haidaa, rona aloaa Peter ma John a'a ro'ou. ");
INSERT INTO wuv_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Lagu'aa nodigimai, laguna lafulafunaa ro'ou ba ronei tonaa fei Spiriti Apuna ");
INSERT INTO wuv_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","uaa, fei Spiriti Apuna atawe pasiaa hemea ro'ou; rona pudugufai ua a'a fei haraa mei Fasu Jesus. ");
INSERT INTO wuv_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Si'ei, Peter ma John, laguna au panii lagua pafoo ro'ou ma ronawe tonaa fei Spiriti Apuna. ");
INSERT INTO wuv_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Simon, i fanunuia ba laguei apostle na augaa panii lagua, hefi'adiai na tonaa fei Spiriti. Ma ba i fani mugoo po'i a'a lagua ");
INSERT INTO wuv_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","na ware, “Fanau fena faufau fena, uaa ba minaa ei a augaa paniu pafoo ro'ou, ronei tonaa fei Spiriti Apuna.” ");
INSERT INTO wuv_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Peter na ware, “Fei mugoo po'imu nei madigefipui a'amu, uaa yoi ona nara ba o pono'aa fei fanaa mei Haidaa a'a mugoo po'i! ");
INSERT INTO wuv_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Lomi ona pa'i ma'ida bigi'amu a'a feni bigi'a, uaa fena naranaramu, lomi na rawani i pudaa mei Haidaa. ");
INSERT INTO wuv_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Filoginaa fena hafelo'a naranaramu ma lafulafunaa a'a mei Fasu. Woro i futoaa ena hafelo'a naranaramu. ");
INSERT INTO wuv_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Uaa una fanunu'apa'ia ba na para'a naranaramu ma na bobo'ainio fei hafelo'a.” ");
INSERT INTO wuv_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Ma Simon na ware, “I'iginaa mei Fasu ba inei'aa pa'au tamanu ona wareia.” ");
INSERT INTO wuv_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Lagu'aa u'udii ma waredigaa fei wareaa mei Fasu, Peter ma John, laguna hadiwe'inaa Jerusalem, no'u'ugaloo fei rawani'a warea a'a watauda ei gufu Samaria. ");
INSERT INTO wuv_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Ma hemea alo'aloo mei Fasu na warenaa a'a Philip, “Aununaa hara'uu a'a fei tala lomi guana o haihai, fei na upunaloo Jerusalem aununaa Gaza.” ");
INSERT INTO wuv_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Si'ei, ina aunu ma ei fi nolao na nobapa'aloo hemea Ethiopia, lomi wawaneina, hemea nafii mei hapara pifine, mei oma'aa ei mugoo po'ii Candace. Mei rama'a mei na aununaa Jerusalem ba i losui. ");
INSERT INTO wuv_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","Ma ifi hadiwe'inaa gufuna pafoo fei wana, igo'igoaa fei bu'uu mei mamama'a Isaiah. ");
INSERT INTO wuv_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Fei Spiriti na warenaa a'a Philip, “Dinaa a'a fena wa ma oafarafi'i papana.” ");
INSERT INTO wuv_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Si'ei, Philip na poni nopa'aloo fei wa ma guainaa mei rama'a mei fi igo'igoaa fei Bu'uu Isaiah, mei mamama'a. Na i'igai Philip, “Ana ona apa'ia hanuu fena igoamu?” ");
INSERT INTO wuv_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Ma ina ware, “A apa'ibatanainia rabaa na pa'i rama'a ba i warefa'arewaia a'au?” Si'ei, na i'iginaa Philip ba nei fanegutafipui a'ana. ");
INSERT INTO wuv_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Mei nafii mei hapara pifine fi igoaa feni paolaa wareaa fei Bu'u Apuna: “Rona talaidugia ale'ei sipsipi ba i dinaa fei ma'ea ma ale'ei na'uu sipsipi lomi waigiana ei ro'aa fapi'aa hugoo ununa, ana lomi na gigiaa umuna. ");
INSERT INTO wuv_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Rona famamafaia ma lomi rona fania fei rawani'a dududua. Hini mei ba i u'ufanaa ei paina? Uaa, rona fapedugia yeni malagufu.” ");
INSERT INTO wuv_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Mei nafi mei na i'igainaa Philip, “Warefanau ba fi warewareaa hini mei mamama'a, hia o hemeadiai?” ");
INSERT INTO wuv_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Si'ei, Philip na igoaa fei ne'iaa fei Bu'u Apuna ma u'ufania fei rawani'a wareaa Jesus. ");
INSERT INTO wuv_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Ei lagu'ei nolao a'a fei tala, laguna nopa'aloo fei ranu, na ware mei nafi, “Fanunu, na pa'i ranu yeni. Na rawani ba a pudugufai?” ");
INSERT INTO wuv_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Ma ina warenaa a'a ro'ou ba ronei fa'ugaa fei wa. Philip ma mei nafi, laguna u'upunaa fei ranu ma Philip na pudugufainia. ");
INSERT INTO wuv_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Lagu'aa asi'arai a'a fei ranu, fei Spiritii mei Fasu na notonaa Philip ma mei nafi, fai lomi na fanunupa'idinia ma na aununi'eni'enaa gufuna. ");
INSERT INTO wuv_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Ma'uaa, Philip na maua yei Azotus ma tatalai yei ma wareaa fei rawani'a warea a'a minaa ei gufu nopa'aloo Caesarea. ");
INSERT INTO wuv_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Ma'uaa Saul, ana fi fifi'i ununa ba i fo'afama'eaa ei otalai neneraa mei Fasu. Na dinaa a'a mei pa'aa bauaniaa humuu mei Haidaa ");
INSERT INTO wuv_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","ma i'iginia ba nei ne'inaa a'a ei synagogue yei Damascus ba nabaa i labagipa'aa hini maroaa fei Tala—pifine o wawane—nei panarofaa ro'ou ma bobo'ainaa ro'ou Jerusalem. ");
INSERT INTO wuv_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","I norafi'inaloo Damascus a'a fei tatalaiana, ana ei ua, hepalo we'ai noramiana pafea na we'afaweloinia. ");
INSERT INTO wuv_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Ina pasinaa malagufu ma guainaa hepalo lao na warenaa a'ana ba, “Saul, Saul, tani o haperararaiau?” ");
INSERT INTO wuv_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Saul na i'igai, “Yoi hini, mena Fasu?” Ina ware, “Yau Jesus, mei o haperararaia. ");
INSERT INTO wuv_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Nadii. Asi'aa ma aununaa a'a fei baua gufu ma we guainaa tamanu ba nei bigi'ia.” ");
INSERT INTO wuv_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Ei ro talaihugiaa Saul rona u hawainaa poaa ro'ou; rona guainaa fei lao, ma'uaa, lomi na fanunupa'aa hemea rama'a. ");
INSERT INTO wuv_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Saul na asi'aa a'a fei malagufu, ma'uaa, ba i werainaa pudana, lomi na fanunupa'i. Si'ei, rona tauaa panina ma duginaa hia Damascus. ");
INSERT INTO wuv_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Laloo oduai arewaa ina wera pudana ma lomi na hanana o hunu. ");
INSERT INTO wuv_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Yei Damascus na pa'i hemea otalai nenera, harana Ananias. Mei Fasu na harofia a'a fei mefina, “Ananias!” Ina ware, “Tani, mena Fasu?” ");
INSERT INTO wuv_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Mei Fasu na warenaa a'ana, “Dinaa a'a fei humuu Judas yei Tala Wanewane ma labaginaa hemea Tarsus harana Saul, uaa, ifi lafulafu eni. ");
INSERT INTO wuv_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","I a'a fei mefina na fanunupa'aa hemea rama'a, harana Ananias na nomai augaa panina pafona ma faweradinaa pudana.” ");
INSERT INTO wuv_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Na ware Ananias, “Mena Fasu, yau na guainaa watauda u'ugaa mei rama'a mei ma minaa ei hafelo'a bigi'ana a'a ei apunaiaa mei Haidaa yei Jerusalem. ");
INSERT INTO wuv_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Ina nomai yeni uaa ei famamoaa humuu mei Haidaa rona faninaa panina ba nei panarofaa hini i lala'aa haramu.” ");
INSERT INTO wuv_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Ma'uaa, mei Fasu na warenaa a'a Ananias, “Aunu ua! Mei rama'a mei, una rafeinia ba waduu paniu talaitonaa harau i a'a ei Gentile ma ei haparaa ro'ou mawe ei Israel. ");
INSERT INTO wuv_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Ba a fama'aia batanai fi'ia i tonia a'a fei harau.” ");
INSERT INTO wuv_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Si'ei, Ananias na dinaa a'a fei humu ma wadu'ai. Na augaa panina pafoo Saul ma ware, “Mena lofuu Saul, mei Fasu—Jesus, mei i fa'arewa a'amu i ma'aa tala ei oi fi nomai yeni—na aloamiau ba onei fafanunudiai ma fei Spiriti Apuna neimina didifio.” ");
INSERT INTO wuv_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Ana ei ua, hefi'a manumanu ale'ei huna na pasilele'aa pudaa Saul ma na fanunupa'idiai. Ina asi'aa ma rona pudugufainia ");
INSERT INTO wuv_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","ma i hananadii, na faufaudiai. Saul na gutafipui a'a ei otalai nenera yei Damascus ale'ei hefi'a arewaa. ");
INSERT INTO wuv_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Ana ei ma na u'u laloo ei synagogue ba Jesus, hia Na'uu mei Haidaa. ");
INSERT INTO wuv_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Minaa ei rona guainia na ba'arofo ma i'igai, “Haa, ana simeni, meni i fa'agu'agu ma fo'aiaa ei ro'aa lala'aa fei hara yei Jerusalem? Ma abaa eni i nomai yeni ba i patarobobo'inaa ro'ou ma duginaa ro'ou a'a ei famamoaa humuu mei Haidaa?” ");
INSERT INTO wuv_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Ma'uaa, Saul na to'apoidiai faufauna ma fapoapoainaa ei Jew ro'aa guta yei Damascus, uaa, na fa'arewaia ba Jesus, hia mei Christ. ");
INSERT INTO wuv_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","I nodigilao ale'ena hefiga arewaa, ei Jew na fiwarewareipa'ai ba ro'aa fo'afama'eia. ");
INSERT INTO wuv_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Ma'uaa Saul na guainia ba ale'ei warewareaa ro'ou. Arewaa ma poi, ronamina pupudainaa ei poaa fanefanee fei gufu ba ro'aa fo'afama'eia. ");
INSERT INTO wuv_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Ma'uaa, ei neneraa Saul na dugia poi ma fa'u'upuia laloo hepalo pa a'a fei walawalaa fei nono. ");
INSERT INTO wuv_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","I nodigimai Jerusalem ba i bigifipui a'a ei otalai nenera, ma'uaa, minaa ro'ou na ma'auia ma nara ba hia abaa pa'aa otalai nenera. ");
INSERT INTO wuv_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Ma'uaa, Barnabas na duginaa hia a'a ei apostle. Ina warefanaa ro'ou batanai Saul ei i talaimai ma'aa tala na fanunupa'aa mei Fasu ma mei Fasu na warenaa a'ana ma batanai ba yei Damascus ina laugu'ua ei i wareaa fei haraa Jesus. ");
INSERT INTO wuv_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Si'ei, Saul na gutafipui a'a ro'ou ma tatalai yei Jerusalem ma u'ulaugu'uai a'a fei haraa mei Fasu. ");
INSERT INTO wuv_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Ina fiwarewarei ma fiharei a'a ei Jew Greece, ma'uaa, ba ro'aa fo'afama'eia. ");
INSERT INTO wuv_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Ro'aa guainaa fei ei lofu, rona duginaa hia Caesarea ma alonaa hia Tarsus. ");
INSERT INTO wuv_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Ma ei losuia yei Judea, Galilee ma Samaria, ronawe gutafarawani. Fei Spiriti Apuna na fawe'ia ma fa'unuwenuweaa naranaraa ro'ou ma na apoidiai puduu ro'ou ma rona gutama'auaa mei Fasu. ");
INSERT INTO wuv_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Fi talai a'a ei gufu sugutata'aia Peter, na dinaa Lydda ba i ma'a ei apunaiaa mei Haidaa yei. ");
INSERT INTO wuv_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Yei ina bapa'aa hemea harana Aeneas, mei na ma'e raraa ununa na haino pafoo tawa ale'ei fainaroa igisimasi. ");
INSERT INTO wuv_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Peter na warenaa a'ana, “Aeneas, Jesus Christ, i fapedugaa funuamu. Asi'atonaa fei hafenaa nopamu.” Ana ei, na asi'aa Aeneas. ");
INSERT INTO wuv_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Minaa ei Lydda ma Sharon na fanunupa'aa mei ma neneraa mei Fasu. ");
INSERT INTO wuv_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Yei Joppa na pa'i hemea pifine otalai nenera, harana Tabitha (fei, ana fei hara Dorcas). Ma hia nafane bigi'aa ei rawani'a bigi'a ma hadumaa ei rama'a lomi na pa'i manumanu. ");
INSERT INTO wuv_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","A'a fei au fei, hia na funuma'e ma rona nunufia ma fahainopia a'a hepalo tarea humu. ");
INSERT INTO wuv_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Lydda na rafi'inaa Joppa; si'ei, ro'aa guainia ei otalai nenera ba Peter yei Lydda, rona aloaa helagui a'ana ma laguna roroninia ba, “Nobatafamai e'eni!” ");
INSERT INTO wuv_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Na aunuhugiaa lagua Peter ma ro'aa nodigilao, rona duginaa hia a'a fei tarea humu. Minaa ei pifine ma'esuabea, rona u i a'ana. Rona ai'ai ma fama'aia ei hawaa ugu ma ei susu, ei tawi'aa Dorcas ei fido'o guta a'a ro'ou. ");
INSERT INTO wuv_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Peter na fa'asi'anaa minaa ro'ou i ano ma na fa'unaa du'una ma lafulafu. Oma'anaa a'a mei pifine ma'ea ma ware, “Tabitha, asi'aa!” Ina werainaa pudana ma i fanunupa'aa Peter, na asi'aguta. ");
INSERT INTO wuv_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Ina tauaa panina ma fa'ufalarainia. I dii, na lala'amii ei apunaia mawe ei ma'esuabea ma fa'ugia fininaa harenuana i pudaa ro'ou. ");
INSERT INTO wuv_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Minaa ei Joppa, rona guainaa fei ma watauda na narafawe'i a'a mei Fasu. ");
INSERT INTO wuv_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Peter na guta yei Joppa ale'ei hefiga arewaa a'a hemea na'aida naraiaa ei hudii manulelele, harana Simon. ");
INSERT INTO wuv_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Yei Caesarea na pa'i hemea rama'a, harana Cornelius, hemea centurion yei Italy. ");
INSERT INTO wuv_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Hia mawe ei e'ei laloo humuna, romina neneraa mei Haidaa ma ma'auia. Ma ina pani'arerei a'a ei rona pa'i nunumiaa ro'ou ma fane lafulafu a'a mei Haidaa. ");
INSERT INTO wuv_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Heai arewaa, fafi, ale'ei oduai ido'o, ina to fanunua ale'ei mefi. Ina fanunupa'aa hemea alo'aloo mei Haidaa na nomai a'ana ma mei alo'alo na ware, “Cornelius!” ");
INSERT INTO wuv_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Cornelius na fanunufa'u'uia ma na ma'au. Ina i'igai, “Tani mena Fasu?” Na ware mei alo'alo, “Ei lafulafuamu ma ei fanamu a'a ei lomi manumanuu ro'ou na aununaa a'a mei Haidaa pafea ma ina narapa'io. ");
INSERT INTO wuv_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Ma e'eni, aloaa hefi'a dinaa Joppa ba ronei dugamai mei harana Simon, mei ana harana Peter. ");
INSERT INTO wuv_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Hia na guta humuu Simon, mei na'aida naraiaa hudii manulelele ma fei humuna, i papaa agi.” ");
INSERT INTO wuv_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","I aunudii mei alo'alo, mei i wareware a'ana, Cornelius na harofaa helagui tameloina ma hemeadiai tameloina, hemea rama'aa fo'aa, hemei na ma'auaa mei Fasu. ");
INSERT INTO wuv_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Ina warefanaa ro'ou minaa ei manumanu na fanunuia ma na alonaa ro'odu Joppa. ");
INSERT INTO wuv_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Hepalodiai arewaa nenee fei ma i nohaloainalao, ro'ei talaifarafi'inaa fei gufu, Peter na fanenaa pupuaa fei humu ba i lafulafu a'a mei Fasu. ");
INSERT INTO wuv_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Ina bao ma ba i hanana. Fi babagii ei du'ua, hia na mefi. ");
INSERT INTO wuv_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","Ma laloo fei mefina na fanunupa'aa fei pumanugawe na gigi ma hefaa manumanu ale'ei baua lawalawa na tausisigaigio malagufu a'a obaoei supuna. ");
INSERT INTO wuv_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Ma lalona na pa'i watauda ei maumau manulelele, ei rona pa'i obao pine mawe ei mau manulelele ro ata'ata i malagufu ale'ei wa'a mawe wa'i ma ei manufidufidu haroo pafea. ");
INSERT INTO wuv_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Ma na ware hefaa lao a'ana, “Asi'aa Peter. Fo'afama'eia ma hanana.” ");
INSERT INTO wuv_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Na ware Peter ba, “Pa'aa lomi, mena Fasu! Atawepo'o hana ena abaa du'ua, ena na loloa.” ");
INSERT INTO wuv_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Fei lao na ware faguapoaidiai a'ana, “Nabaa hefaa manumanu ma mei Haidaa na waredii ba na rawani, onei'aa ware ba na loloa.” ");
INSERT INTO wuv_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Feni lao guaiana na fa'odupoai ma ana ei ua, fei lawalawa na hadiwe'ainaa pafea. ");
INSERT INTO wuv_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Fi naranara watauda Peter ba tamanu hanuu fei fanunuana, ei rama'a aloaa Cornelius, ana rona bapa'aa fei humuu Simon ma u i papaa fei gigei. ");
INSERT INTO wuv_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Rona haro'i'igai ba, “Simon, mei ana harana Peter, hia, yena?” ");
INSERT INTO wuv_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Fi naranara Peter ba tamanu hanuu fei fanunua, fei Spiriti na warenaa a'ana, “Simon, o'odui rama'a, roi labaginio. ");
INSERT INTO wuv_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Hee, asi'aa ma upunaa pu. Apuna nara ba o'adii o lomi, uaa, yau meni a aloawii ro'ou.” ");
INSERT INTO wuv_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Peter na upulao ma warenaa a'a ei rama'a, “Yau meni hamo'ei labaginia. Tani hamu'ou nomai?” ");
INSERT INTO wuv_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Ei rama'a na ware, “Noramiaa hai'odu a'a Cornelius, centurion. Hia hemea na wanewane ma na ma'auaa mei Haidaa. Ma minaa ei Jew, rona ma'auaa mei rama'a mei. Hemea alo'alo, mei na apunai, na warefania ba yoi onei dinaa humuna ba i guainaa tamanu o wareia.” ");
INSERT INTO wuv_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Si'ei, Peter na ware ba ronei wadu'ainaa humu ma guta a'ana. Heai arewadiai, Peter na aunuhugiaa ro'odu ma hefi'a rama'aa Joppa, hefi'a narafawe'ia, ana rona aunu. ");
INSERT INTO wuv_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Heai arewadiai, ina sufudai i Caesarea. Cornelius na apa'ia ba i nomai ma ina harofamii ei gufuna mawe ei tafina. ");
INSERT INTO wuv_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","I wadu'ainaa fei humu Peter, Cornelius na nomai i ma'ana ma o'o'ui i pinee Peter. ");
INSERT INTO wuv_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Ma'uaa, Peter na fa'asi'ania. Ina ware, “Ufalarai. Yau ana rama'a ua.” ");
INSERT INTO wuv_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Laguna fiwarewarei ma Peter na wadu'ai ma fanunupa'aa hefaa baua gupuu rama'a. ");
INSERT INTO wuv_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Ina warenaa a'a ro'ou, “Hamona apa'ifarawaninia ba na apunainaa fei law hai'odu ba hemea Jew i guta o oafipui a'a hemea Gentile. Ma'uaa mei Haidaa na fama'au ba nei'aa ware ba nemea na hafelo o na loloa. ");
INSERT INTO wuv_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Si'ei, ro'aa la'au, una no'uamai lomi na pa'i naranarau. Na rawani ba a i'iginaa hamu'ou ba tani hamu'ou lala'au?” ");
INSERT INTO wuv_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Cornelius na ware, “Obao arewaa ididii, yau laloo humuu ma lafulafu ana ale'eni feni au feni, ale'eni odu'ai ido'o fafi. Ma a'a fei au fei, una maduofo hamatee hemea rama'a, hemea na agime lawalawana na u i ma'au ");
INSERT INTO wuv_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","ma na ware ‘Cornelius, mei Haidaa na guainaa ei lafulafuamu ma fanunupa'aa ei fanamu a'a ei rama'a lomi manumanuu ro'ou. ");
INSERT INTO wuv_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Alo alo'alomu dinaa Joppa ba ronei dugamii Simon, mei harana Peter. Hia na guta humuu hemeadiai Simon, mei na'aida naraiaa hudii manulele, mei fei humuna i papaa agi.’ ");
INSERT INTO wuv_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Si'ei, una ponila'amii yoi ma na rawani ba ona nomai. Ma e'eni, minaa hai'ou yeni inamoaa mei Haidaa ba hai'ou'aa guainaa minaa ei manumanu mei Fasu na warefanio ba onei warefanaa hai'odu.” ");
INSERT INTO wuv_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Ma si'ei, Peter na'aa ware, “Yau eni, nawe fanunu'apa'ia ba pa'aa fa'ua ba mei Haidaa, lomi na pa'i papa'aa ununa, ");
INSERT INTO wuv_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","ma'uaa na dugi'uaiaa ei rama'a a'a minaa ei gufu, ei rona ma'auia ma neneraa tamanu ei na rawani. ");
INSERT INTO wuv_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Hamona aida fei rawani'a warea, fei mei Haidaa na alonaa a'a ei Israel, warefanaa ro'ou fei rawani'a wareaa fei gutafarawania, uaa Jesus Christ, mei Fasuu minaa ei manumanu. ");
INSERT INTO wuv_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Hamona aida tamanu ei na asi'aa yei Judea, tamanu ei nado'o asi'aa farawarawa yei Galilee, nenee fei pudugufaia, fei John na u'ugia. ");
INSERT INTO wuv_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Hamona aida ba mei Haidaa na papaditainaa Jesus mei Nazareth a'a fei Spiriti Apuna ma wagii fei faufau na talaibigifarawani, farawaninaa ei rona oa wagii fei faufau mei hani'u, uaa mei Haidaa a'ana. ");
INSERT INTO wuv_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","“Ona ma'adigaa minaa ei bigi'ana yei gufuu ei Jew ma yei Jerusalem. Rona fatawaia a'a fei haihai ma na ma'e, ");
INSERT INTO wuv_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","ma'uaa mei Haidaa na fa'asi'ania a'a fei ma'ea laloo fei fa'oduaiaa arewaa ma ina fa'arewaia a'a ei rama'a. ");
INSERT INTO wuv_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","Abaa minaa ei rama'a rona fanunuia. Ma'uaa, mei Haidaa nado'o uniaa hini ei rowe fanunuia, ale'ena hai'odu, hai'ouna hanana ma hunufipui a'ana nenee fei i asi'aa a'a ei ma'ea. ");
INSERT INTO wuv_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Ina ware ba hai'ounei u'ufanaa ei rama'a ma warefa'uai ba unaiaa mei na rafeinia mei Haidaa ba nei dududuaa ei rona guta ma ei rona ma'e. ");
INSERT INTO wuv_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Minaa ei mamama'a, rona warefa'uai wagina ba hini i narafawe'i a'ana, a'a fei harana, mei Fasu i futoaa ei hafelo'ana.” ");
INSERT INTO wuv_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Fi wareware Peter, fei Spiriti Apuna fi pasigio pafoo minaa ei rona guainaa fei warea. ");
INSERT INTO wuv_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Ei rona narafawe'i ma moro hudii wawanei, rona nohugiamii Peter. Rona ba'arofo ba fei fanaa mei Haidaa fei Spiriti Apuna na pasinaa pafoo ei Gentile anaa. ");
INSERT INTO wuv_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","Uaa, ei ro nohugiamiaa Peter rona guainaa e'ei rama'a e'ei, rona warenaa wareaa hepapa gufu ma uduginaa mei Haidaa. Ma na ware Peter, ");
INSERT INTO wuv_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","“Na pa'i nemea i nara ba eni rama'a eni, ronei'aa pudugufai a'a fei ranu? Na rawani ba ro'aa pudugufai, hamatee rona todigaa fei Spiriti Apuna ana ale'ei o'odu.” ");
INSERT INTO wuv_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Si'ei, ina ware ba ronei pudugufai a'a fei haraa Jesus Christ. Ma rona warefanaa Peter ba nei gutafipui a'a ro'odu hefi'adiai arewaa. ");
INSERT INTO wuv_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Ei apostle ma ei lofu tadiwe'aiaa Judea, rona guainia ba ei Gentile ana rona tonaa fei wareaa mei Haidaa. ");
INSERT INTO wuv_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Hee, ei i dinaa Jerusalem Peter, ei narafawe'ia, ei na moro hudii wawanei, rona warefania ba ina tata ");
INSERT INTO wuv_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","ma rona ware, “Yoi, ona wadu'ainaa ei humuu ei lomi na moro hudii wawanei ma ona hananafipui a'a ro'odu.” ");
INSERT INTO wuv_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Peter na asi'aa ma warefanaa ro'odu minaa ei manumanu: ");
INSERT INTO wuv_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","“Yau yei laloo fei baua gufu Joppa, fi lafulafu ma na mefi. Una fanunupa'aa hefaa manumanu ale'ei baua lawalawa na taularagio pafea a'a obao ei supuna fi aunugio i a'au. ");
INSERT INTO wuv_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Una fanununaa lalona ma na fanunupa'aa ei manulelele, ei rona talai i malagufu a'a obao pine, ei manulelelee podu ma ei mau manulelele ale'ei wa'a ma wa'i mawe ei manufidufidu haroo pafea. ");
INSERT INTO wuv_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Ma una guainaa hefaa lao na warenaa a'au, ‘Asi'aa, Peter. Fo'afama'eia ma hanana.’ ");
INSERT INTO wuv_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","“Una ware, ‘Pa'aa lomi, mena Fasu! Atawe fawadu'ainaa poau hepalo manumanu na loloa o lomi na fafa'arai.’ ");
INSERT INTO wuv_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","“Fei lao noranarai pafea na faguapoaidiai, ‘Onei'aa ware ba na loloa hepalo manumanu nabaa mei Haidaa na fafafa'arainia.’ ");
INSERT INTO wuv_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Feni na nomai a'au odupoa ma minaa ei manumanu ei, na hadiwe'aidinaa pafea. ");
INSERT INTO wuv_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","“Ana ei ua ma o'oduei rama'a, ei aloamiaa ro'ou yei Caesarea, rona nomai a'a fei humu yau na guta wagina. ");
INSERT INTO wuv_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Fei Spiriti na warefanau ba unei'aa oa'oai aunuhugiaa ro'odu. Eni oloroa lofu eni, ana rona aunuhugiau ma hai'ouna wadu'ainaa fei humuu mei rama'a. ");
INSERT INTO wuv_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Ina warefanaa hai'odu ba hemea alo'alo na fa'arewa a'ana laloo humuna ma mei alo'alo na ware, ‘Alo alo'alomu dinaa Joppa ba ronei dugamii Simon, mei harana Peter. ");
INSERT INTO wuv_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","I we warefanio ena warea, ena ba i fatela'anio ma ena maroamu.’ ");
INSERT INTO wuv_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","“Ana fi wareware ua, fei Spiriti Apuna na pasinaa pafoo ro'ou ana ale'ei i upugio pafoo o'ou farawarawa. ");
INSERT INTO wuv_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Ma una nonominaa ei wareaa mei Fasu ba: ‘John na pudugufainaa ranu, ma'uaa hamowe pudugufai a'a fei Spiriti Apuna.’ ");
INSERT INTO wuv_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Ma nabaa mei Haidaa na fanaa ro'ou fei fana, fei na fanaa o'ou, o'ou ena na narafawe'i a'a mei Fasu Jesus Christ, nabaa ale'ei, yau hini ba a barafeaa mei Haidaa?” ");
INSERT INTO wuv_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Ro'aa guainaa fei, lomi rona fai wareware ma rona uduginaa mei Haidaa ma ware, “Ma'aia, mei Haidaa na fanaa ei Gentile fei ba ro filoginaa naranara ro'odu ma tonaa fei harenua lomi i pedutoo.” ");
INSERT INTO wuv_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Ma e'ei rama'a, e'ei rona ba'autorai a'a fei au hafelo, fei rona haperaraiaa Stephen wagina, e'ei rama'a e'ei, ana ronamina aununaa Phoenicia, Cyprus ma Antioch ma warefanaa ei Jew ua fei u'uga. ");
INSERT INTO wuv_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Ma'uaa, hefi'a ro'odu, ei noramiaa ro'ou Cyprus ma Cyrene, rona aununaa Antioch ma wareware a'a ei Greece anaa; rona u'ugaa fei rawani'a wareaa mei Fasu Jesus. ");
INSERT INTO wuv_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Fei panii mei Fasu na oafipui a'a ro'odu ma watauda, rona narafawe'i ma momo'ainaa a'a mei Fasu. ");
INSERT INTO wuv_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Ei losuia yei Jerusalem, rona guainaa fei u'uga fei ma rona aloaa Barnabas dinaa Antioch. ");
INSERT INTO wuv_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","I nolao yei ma fanunupa'aa fei rawani'aa mei Haidaa, ina ni'eni'e ma warehadumaa ro'ou ba a'a minaa ei faufau ro'odu, roneimina ofawe'i a'a mei Fasu. ");
INSERT INTO wuv_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Hia hemea rawani'a rama'a ma fei Spiriti Apuna na didifia ma namina we'i fei naranarana ma watauda, rona nomai a'a mei Fasu. ");
INSERT INTO wuv_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","I dii, Barnabas na aununaa Tarsus ba iree labaginaa Saul ");
INSERT INTO wuv_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","ma i nopa'alao, na duginaa hia Antioch. Ma laloo heai igisimasi, Barnabas ma Saul, laguna gutafipui a'a ei losuia ma laguna feroinaa watauda rama'a. Yei Antioch rona roroinaa ei otalai nenera ba ro'odu Christian. Sifei fei rawarawa rororoia ale'ei. ");
INSERT INTO wuv_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","A'a fei au fei, hefi'a mamama'a noramiaa ro'ou Jerusalem, rona dinaa Antioch. ");
INSERT INTO wuv_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Hemea ro'odu, harana Agabus na ufalarai ma i a'a fei Spiriti na ware ba neai arewaa fei baua mouabiabia i dinaa tadiwe'aiaa minaa ei gufuu Rome. (Hefei au mouabiabia na nomai a'a fei au i utonaa fei hapara Claudius.) ");
INSERT INTO wuv_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Ei otalai nenera, a'a ei apa'aa hememea ro'ou, rona narapa'ia ba ronei hadumaa ei lofu yei Judea. ");
INSERT INTO wuv_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Fei tala rona bigi'ia, sifei ba rona alofanaa ei bauaniaa losuu ei fanaa ro'odu a'a Barnabas ma Saul. ");
INSERT INTO wuv_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","I a'a feni au feni, mei hapara Herod na panarofaa hefi'a losuia ba i haperaraiaa ro'ou. ");
INSERT INTO wuv_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Ei maroana, rona fo'afama'eaa James, mei lofuu John a'a hepalo wadu. ");
INSERT INTO wuv_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","I'a fanunupa'ia ba fei na fani'eaa ei Jew, inaree panarofaa Peter anaa. Ina bigi'aa fei a'a fei au Hananaa fei Faraa Pidaua Lomi Fafuafua. ");
INSERT INTO wuv_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","I panarodigia, ina aunaa hia i laloo humuu bobo'aia di aunaa panii ei oma'ama'aa. E'ei oma'ama'aa e'ei, gunaroa gupu ma hepapalo gupu na pa'i gunaroa rama'a. Herod na nunuminia ba i dududuia i pudaa minaa ei rama'a nenee fei Talai Falogia. ");
INSERT INTO wuv_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Hee, Peter rona faroro'inia i laloo humuu bobo'ai, ma'uaa ei losuia, ronamina lafulafunia a'a mei Haidaa. ");
INSERT INTO wuv_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Fei poi ana i pa'aa fei arewaa ba Herod i aunaa hia dududua, Peter na ma'igu watolaa helagui fo'aa, rona faroro'ainia a'a guapalo alatai ma ei oma'ama'aa rona u i poaa fanefanee humu. ");
INSERT INTO wuv_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Ana ei ua, hemea alo'aloo mei Fasu na fa'arewa ma fei we'ai na we'apapa'arai i lalona. Ina pa'igueinaa haparanonoo Peter ma funia. Ina ware, “Batafa! Asi'aa!” Ma ei alatai na ma'ala i panii Peter. ");
INSERT INTO wuv_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Mei alo'alo na warenaa a'ana, “Fareaa fena lawalawamu ma ena hafena pinemu.” Ma Peter na bigi'ia. Mei alo'alo na ware, “Fareaa fena hawaa ugumu ma nenerau.” ");
INSERT INTO wuv_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Peter na nenegia ma laguna wala'aa a'a fei humuu bobo'aia. Ma'uaa, lomi ina aida ba mei alo'alo napa'aa bigi'ia; ina nara ale'ei ba mefina. ");
INSERT INTO wuv_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Laguna talaidi'ininaa ei rawarawa ma ei faguaiaa oma'aa ma laguna nomai a'a fei gigei iron, u'unii fei baua gufu. Fei gigei na gigi'ualao ma laguna asi'alao wagina. Ei lagu'aa talaifamalalao ma'ida a'a fei tala, mei alo'alo na di'ininia. ");
INSERT INTO wuv_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Peter nawe aida ma na ware, “E'eni unaminapa'aa aida ba mei Fasu na aloamii mei alo'alona ma na fatelaiau panii Herod mawe minaa ei manumanu ei Jew rona nunuminia.” ");
INSERT INTO wuv_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Ipowe arewa a'ana, ina aununaa fei humuu Mary, mei inaa John, mei ana harana Mark, i fawelei rona figupui watauda rama'a ma roi lafulafu a'a mei Fasu. ");
INSERT INTO wuv_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Peter na faba'aba'a a'a fei gigei ano ma hemea nafi pifine, harana Rhoda na nomai ba i gigiaa fei gigei. ");
INSERT INTO wuv_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","I guaipa'aa fei lao Peter, namina ni'eni'e ma lomi na gigiaa fei gigei. Na ponihadiwe'ai ma na warefatemutemu, “Peter, hia a'a fei gigei!” ");
INSERT INTO wuv_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Rona warenaa a'ana, “Onapa'aa poapoai.” Ma'uaa, lomi na babanini; namina'u wareware ua ma ronawe ware ba, “Woro mena alo'alona.” ");
INSERT INTO wuv_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Ma'uaa Peter na u faba'a ua a'a fei gigei ano ma ro'aa gigiaa fei gigei ma ro'aa fanunupa'ia, namina nanawala pudaa ro'odu. ");
INSERT INTO wuv_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Peter na pi'inaa panina ba ronei babanini ma na u'ufanaa ro'ou batanai mei Fasu i fatela'ania humuu bobo'aia. Ina ware, “Warefanaa James ma ei lofu feni manumanu feni.” Ma na di'ininaa ro'odu dinaa a'a hepalodiai gufu. ");
INSERT INTO wuv_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","I nomafufuoilao, ei fo'aa, ronamina hautata a'a fei ba na ba'uanaa hitani Peter. ");
INSERT INTO wuv_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Herod namina lalabaginia ma'uaa, lomi na labagipa'ia. Ma si'ei, namina i'iginaa watauda i'igaia a'a ei oma'ama'aa ma nawe ware ba hefi'adiai fo'aa nei fo'afama'eaa ro'odu. I dii, Herod na di'ininaa Judea dinaa Caesarea ma na guta famadii ma'ida yei. ");
INSERT INTO wuv_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Fama'a ina fiharenii a'a ei Tyre ma Sidon. E'eni, ei rama'aa guapaloei gufu, rona fihupu'ii ba ro'aa ma'a hia. Ma hemea rama'a, harana Blastus na waredii ba iwe hadumaa ro'odu. Blastus, hia hemea rawani'a nafii mei hapara ma mei hapara na apa'ifarawaninia. Rona i'igai ba mei hapara nei fapedugaa fei fisisibaia watolaa ro'odu, uaa rona'aida to du'ua a'a fei gufuu mei hapara. ");
INSERT INTO wuv_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","A'a fei arewaa ba ro'aa figupui, Herod na fareaa ei lawalawaa hapara ma guta pafoo fei gutanaa hapara ma wareaa hepalo wareana a'a ei rama'a. ");
INSERT INTO wuv_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Rona haromemewai ba, “Pa'a sifeni fei lao hemea haidaa, abaa lao rama'a.” ");
INSERT INTO wuv_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Ana ei ua, hamatee Herod lomi na uduginaa mei Haidaa, hemea alo'aloo mei Fasu na fo'aia ma na pasinaa pu. Ma ei wa'awa'a na hanaia ma na ma'e. ");
INSERT INTO wuv_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Ma'uaa fei wareaa mei Haidaa fimina gipelao ma aununaa watauda gufu. ");
INSERT INTO wuv_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Barnabas ma Saul, lagu'aa fapedugaa ei bigi'aa lagua, laguna nodugamii John, ana harana Mark. Noramiaa ro'odu, Jerusalem. ");
INSERT INTO wuv_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","A'a fei losuu yei Antioch, na pa'i hefi'a mamama'a ma feroia: Barnabas, Simeon ana harana Niger, Lucius mei Cyrene, Manaen (mei ana roroo Herod mei hapara) ma Saul. ");
INSERT INTO wuv_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Rona uduginaa mei Fasu ma fabao ma fei Spiriti Apuna na ware, “Au'u'uginaa Barnabas ma Saul ba lagunei bigi'aa fei bigi'a u'a fanaa lagua.” ");
INSERT INTO wuv_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Ro'aa fabaodii ma lafulafudii, rona augaa panii ro'ou pafoo lagua ma aloaa lagua. ");
INSERT INTO wuv_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Fei Spiriti Apuna na aloaa lagua ma lagunado'o dinaa Seleucia ma laguna tamadinaa Cyprus. ");
INSERT INTO wuv_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Lagu'aa fatetedii Salamis, laguna u'ugaa ei wareaa mei Haidaa laloo ei synagogue ei Jew. John i a'a lagua ba i hadumaa lagua. ");
INSERT INTO wuv_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Rona talaifaweloipedugaa fei gufu ma nopa'aloo Paphos. Yei rona bapa'aa hemea pualaa ei Jew, hemea mamama'a sifisifi, harana Bar-Jesus. ");
INSERT INTO wuv_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Hia hemea na o oa a'a mei gavanaa, mei harana Sergius Paulus. Mei gavanaa na bauanai fei apa'ana. Ma na lala'aa Barnabas ma Saul uaa na nunumiai ba i guainaa fei wareaa mei Haidaa. ");
INSERT INTO wuv_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Ma'uaa, Elymas, mei puala (hamatee fei hanuu Elymas, puala), na fadugeaa ro'odu ba i famomo'inaa fei naranaraa mei gavanaa a'a fei narafawe'ia. ");
INSERT INTO wuv_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Si'ei, fei Spiriti Apuna na didifaa Saul, ana harana Paul ma na fanunufa'u'uaa Elymas ma ware, ");
INSERT INTO wuv_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","“Yoi hemea na'uu hani'u ma ona fadugeaa minaa ei wanewanea manumanu! Yoi ona pepesu a'a watauda ei mau sifisifi ma ei maumau hafelo. Tani, lomi ba o fapedugaa fei barafeamu a'a fei rawani'aa maumau mei Fasu? ");
INSERT INTO wuv_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Si'ei, fei panii mei Fasu na fadugeio. Yoi, owe pudawerai ma iwe pa'i fei au lomi ba owe fanunupa'aa fei we'aa fei halo.” Ana ei ua, fei tapu ma fei roromaa na weloinia ma itaitatalabaginaa hemea ba nei tauaa panina ma i nenegia. ");
INSERT INTO wuv_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","I fanunuia ale'ei mei gavanaa, na narafawe'i uaa na madu'ofo a'a fei feroiaa mei Fasu. ");
INSERT INTO wuv_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Paul ma ei maroana, rona di'ininaa Paphos ma tamanaa Perga, yei Pamphylia. Ma yei, na di'ininaa ro'ou John ma hadiwe'inaa Jerusalem. ");
INSERT INTO wuv_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Rona asi'aa Perga dinaa Pisidia i Antioch. A'a fei Sabbath rona wadu'ainaa fei synagogue ma guta. ");
INSERT INTO wuv_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Ro'aa igodigaa fei Bu'uu Law ma ei Mamama'a, ei bauaniaa fei synagogue, rona warenaa a'a ro'ou, “Ena lofu, nabaa hamona pa'i hefaa warea ba i hadumaa ei rama'a, te hamonei ware.” ");
INSERT INTO wuv_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Paul na ufalarai ma pi'inaa panina ma ware, “Hamu'ou ena Israel ma ena Gentile, ena hamona ma'auaa mei Haidaa, hamonei guainau! ");
INSERT INTO wuv_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Mei Haidaniaa ei Israel, hia na rafeinaa ei amaa hai'ou. Ina fagipeaa minaa ei manumanuu panii ro'odu ei ro'ou guta yei Egypt. A'a fei bauanai faufauna na fa'u'unainaa ro'ou di'ininaa fei gufu. ");
INSERT INTO wuv_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","Ina utonaa fi'iaa naranarana a'a ro'odu ale'ei gunaroa pa'ania igisimasi yei fawelei lomi haihai o guana. ");
INSERT INTO wuv_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Ina fo'afapasiaa oloromeai gufu yei fawelei Canaan ma fanaa ei gufuu ro'ou a'a ei rama'aa gufuna ale'ei hemea ama i fani hapee na'una. ");
INSERT INTO wuv_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Minaa ei manumanu ei, ina bigi'ia laloo gunaroa pu'u ma haipani pa'ania igisimasi. “Nenee fei, mei Haidaa na fani rama'a fadududua a'a ro'odu nopa'aloo fei au Samuel, mei mamama'a. ");
INSERT INTO wuv_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Nenee fei, ei rama'a na i'iginia ba ronei pa'i hemea hapara ma ina augaa Saul, mei na'uu Kish noranamai a'a fei pai Benjamin ma na utonaa fei hapara gunaroa pa'ania igisimasi. ");
INSERT INTO wuv_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","I fapedugaa Saul, na augaa David ba haparaa ro'odu. Ina warewareia, ‘Una fanunupa'ia ba David, mei na'uu Jesse, imina neneraa fei naranarau. Iwe bigi'aa minaa ei manumanu una nunuminia ba inei bigi'ia.’ ");
INSERT INTO wuv_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","“A'a fei pai mei rama'a mei, mei Haidaa na aloaa mei Fatela'ana Jesus yei Israel, ana ale'ei ena warefa'uaiana mina. ");
INSERT INTO wuv_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Ei atawe nomai Jesus, John na u'u a'a minaa ei Israel ba ronei filoginaa naranaraa ro'odu ma pudugufai. ");
INSERT INTO wuv_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Ei i fapedugaa ei bigi'ana John, ina ware, ‘Hamona nara ba yau hini? Abaa yau mena. Agia. Ma'uaa iwe nomai neneu ma lomi na rawani ba a alaraa wao hafenaa pinena.’ ");
INSERT INTO wuv_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","“Ena lofuu, ena na'uu Abraham ma hamu'ou ena Gentile, ena hamona ma'auaa mei Haidaa, fei u'ugaa tela'ana na nodigimai. ");
INSERT INTO wuv_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Ei rama'aa Jerusalem ma ei bauaniaa ro'odu, lomi rona fanunu'apa'aa Jesus, ma'uaa, ei ro'aa ware ba ro'aa fo'afama'eia, ronapa'aa bigi'aa tamanu rona wareia ei mamama'a mina, ei warea o'ouna'aida igoia minaa ei Sabbath. ");
INSERT INTO wuv_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Fa'ua ba lomi rona labagipa'aa hepalo tatana, ma'uaa rona i'igainaa Pilate ba nei fo'afama'eia. ");
INSERT INTO wuv_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Ro'aa bigidigaa minaa ei ronadii ne'inia ei mamama'a, rona porofa'upuiamai a'a fei haihai ma fahainopia laloo huapu a'a fei na'a. ");
INSERT INTO wuv_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Ma'uaa mei Haidaa na fa'asi'ania a'a fei ma'ea ");
INSERT INTO wuv_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","ma rona fanunupa'ia laloo watauda arewaa, ei rona tatalaifipui a'ana yei Galilee dinaa Jerusalem. Rona fanunupa'ia ma e'eni rona warefanaa ei rama'a gufuu o'ou. ");
INSERT INTO wuv_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","“Hai'ou warefanaa hamu'ou fei rawani'a warea: Tamanu nadii fa'unai a'a ei amaa hai'ou mei Haidaa, ");
INSERT INTO wuv_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","ina bigidigia a'a hai'odu eni na'uu ro'odu, uaa ina fa'asi'anaa Jesus. Ana ale'ei fei ne'iaa fei faguaiaa lauga laloo fei Bu'uu Lauga: “‘Yoi mena na'uu; wagieni yau nawe oanaa Amamu.’ ");
INSERT INTO wuv_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","Fei fa'ua warea ba mei Haidaa na fa'asi'ania a'a fei ma'ea ma lomi ba iwe raia, na ude a'a eni paolaa warea eni: “‘Awe fanaa hamu'ou ei hawegia, ei na apunai. Apowe fanaa hamu'ou eni hawegia, eni una fa'unainia a'a David.’ ");
INSERT INTO wuv_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Ma ana na udedii ei ne'ia: “‘Lomi owe uga ba mei Apunaiamu i raia.’ ");
INSERT INTO wuv_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","“David, i'a bigidigaa ei nunumiaa mei Haidaa a'a fei au gutanana, ina ma'igu; rona i'ifinia a'a ei amana ma fei ununa na raia. ");
INSERT INTO wuv_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Ma'uaa mei i fa'asi'ania mei Haidaa, lomi na raia. ");
INSERT INTO wuv_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","“Si'ei, ena lofuu, nunumiau ba hamonei aida ba i a'a Jesus ei hafelo'aa hamu'ou, ipowe futo ale'ei yau fi warefa'aiawii hamu'ou. ");
INSERT INTO wuv_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","I a'ana hini i narafawe'i, iwe wanewane wagii ei hafelo'ana, ei lomi ba fei law Moses na hawia ba i fawanewaneia. ");
INSERT INTO wuv_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Hamonei oma'aa hamu'odu ba tamanu ei ronadii wareia ei mamama'a, lomi i tonaa hamu'odu: ");
INSERT INTO wuv_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","“‘Ma'a, hamu'ou ena hamona falalasi. Hamonei naranara watauda ma ma'e, uaa awe bigi'aa hefaa manumanu a'a fena au hamu'odu ma nabaa nemea nadii warefa'aiaa hamu'odu ba iwe pa'i fei manumanu fei, lomi ba hamu'ou nara ba fa'ua.’” ");
INSERT INTO wuv_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Paul ma Barnabas, lagu'ei di'ininaa fei synagogue, ei rama'a rona i'iginaa lagua ba lagunei u'udinaa ei manumanu ei laloo fei Sabbath na nomai. ");
INSERT INTO wuv_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Ro'aa asi'aa a'a fei synagogue ei rama'a, watauda ei Jew mawe ei rama'a ro filogitonaa fei losuu ei Jew, rona neneraa Paul ma Barnabas. Ma laguna warewarefipui a'a ro'ou ma warefanaa ro'odu ba ronei oa ua a'a fei rawani'aa mei Haidaa. ");
INSERT INTO wuv_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Hepalodiai Sabbath ma ale'ei minaa fei rama'a gufu, rona nomai ba ro'aa guai fei wareaa mei Fasu. ");
INSERT INTO wuv_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Ro'aa ma'apa'aa ei gupuu rama'a ei Jew, ronamina punepune ma warefafeloaa tamanu na u'ugia Paul. ");
INSERT INTO wuv_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Si'ei, Paul ma Barnabas laguna warefalaugu'ai: “Fama'a, fei baua manumanu ba haiguneido'o warefanaa hamu'odu, fei wareaa mei Haidaa. Ma'uaa hamona ofadugia ma lomi hamona nara ba hamo'aa tonaa fei harenua lomi i pedutoo. Si'ei, e'eni, haiguna oma'anaa a'a ei Gentile. ");
INSERT INTO wuv_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Uaa mei Fasu na ware ba haigunei bigi'aa feni wareana: “‘Yau na aunaa hamu'ou we'ai a'a ei Gentile ma ana fatela'anaa ei rama'a minaa feni malagufu.’” ");
INSERT INTO wuv_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Ei Gentile, ro'aa guainaa fei, rona ni'eni'e ma fahonuaa fei wareaa mei Fasu. Ma minaa ei nadii unidigaa ro'odu mei Fasu ba rowe pa'i harenua lomi i pedutoo, rona narafawe'i. ");
INSERT INTO wuv_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Fei wareaa mei Fasu na talepedunaa feni baua gufu. ");
INSERT INTO wuv_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Ma'uaa ei Jew, rona fani tabaa ei pifine, ei rona ma'auaa mei Haidaa. Ma ana ei pifine ei, rona pa'i baua haraa ro'odu mawe ei wawane, ei ro'ou bauaniaa fei gufu. Ma minaa ro'ou, rona fa'asi'anaa fei naranaraa ei rama'a ba ro'aa haperaraiaa Paul ma Barnabas ma rona teteaa lagua a'a fei gufuu ro'odu. ");
INSERT INTO wuv_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Si'ei, lagunadii foifoiaa poraporaa pinee lagua, hanuna ba lomi rona farawaninaa lagua. Ma laguna dinaa Iconium. ");
INSERT INTO wuv_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Ma ei otalai nenera namina ni'eni'e ma fei Spiriti Apuna na didifaa ro'ou. ");
INSERT INTO wuv_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Yei Iconium, Paul ma Barnabas, laguna wadu'ainaa fei synagogue ei Jew, minaa ale'ei bigi'aa lagua. Yei, laguna u'u ma naminaa nafa'aa watauda ei Jew ma Gentile ma rona narafawe'i. ");
INSERT INTO wuv_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Ma'uaa ei Jew, ei rona barafeaa fei rawani'a warea, rona fani tabaa ei Gentile ba ronei narafafelo a'a ei lofu. ");
INSERT INTO wuv_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Si'ei, Paul ma Barnabas, laguna guta famadii ma'ida yei ma u'ufalaugu'ai a'a fei wareaa mei Fasu, mei na fa'arewaiaa fei u'ugaa fei rawani'ana wagii ei bigi'aa lagua ei hilalaa foigia ma fananawalaa puda. ");
INSERT INTO wuv_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Ei rama'aa fei gufu fei, rona fifalagii. Hefi'a, rona oa pepei a'a ei Jew ma hefi'a a'a ei apostle. ");
INSERT INTO wuv_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Na pa'i fiwarewareipa'aia watolaa ei Jew ma Gentile fipuinaa ei bauaniaa ro'ou ba ro'aa haperaraiaa lagua ma nafanaa lagua mugoo. ");
INSERT INTO wuv_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","Ma'uaa, laguna guaipa'ia ma ponipa'ainaa Lystra ma Derbe—guapaloei gufu yei Lycaonia mawe hefi'adiai gufu yei fawelei. ");
INSERT INTO wuv_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","Ma yei, laguna u'ugaa fei rawani'a warea ale'ei laguna'o bigi'ia. ");
INSERT INTO wuv_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Yei Lystra na pa'i hemea afetoo. Ana torotonamiana baduina ma pa'aa lomi na u talai. ");
INSERT INTO wuv_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","Fi wareware Paul, mei rama'a mei, na guainia. Paul na fanunufawanewanenaa a'ana ma na aida ba na we'i naranaraa mei afetoo ba i pedu funuana ");
INSERT INTO wuv_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","ma na harolao, “Ufalarai a'a guapaloena pinemu!” Ana ei ua, ina una'asi'aa ma talai. ");
INSERT INTO wuv_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Ei watauda rama'a, ro'aa fanunupa'aa fei bigi'aa Paul ale'ei, rona haroharonaa warea Lycaonia, “Ei haidaa, rona nogio a'a o'ou ale'ei rama'a!” ");
INSERT INTO wuv_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Rona roroinaa Barnabas, Zeus. Ma Paul, rona roroinaa Hermes, uaa hia mei i wareware. ");
INSERT INTO wuv_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Mei bauaniaa fei humuu mei haidaa Zeus, mei na pa'i humuu mei haidaniana auguu fei baua gufu, na notonamiaa ei buduma'ao ma ei pataa ro'ou fota wagii fei gigei fei baua gufu uaa ba hia ma fei gupuu rama'a, ro'aa fani fanaa ro'ou a'a lagua. ");
INSERT INTO wuv_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Ma'uaa, laguei apostle Barnabas ma Paul, lagu'aa guainia ale'ei, laguna baira'aa ei susuu lagua ma ponilao a'a fei gupuu rama'a ma haroharo: ");
INSERT INTO wuv_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","“Me'o, tani hamo'aa bigi'aa feni? Haigua ana rama'a ua, ale'ena hamu'ou. Haigua fi u'ufanaa hamu'ou fei rawani'a warea ale'ei warefa'aia ba hamonei ofadugaa eni manumanu lomi hanuna ma dinaa a'a mei Haidaa, mei na pa'i harenuana, mei na bigi'aa fei pumanugawe ma feni malagufu ma fei agi mawe minaa ei manumanu wagii ro'ou. ");
INSERT INTO wuv_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Mina, mei Fasu na rawa'a'afainaa hepapalo gufu ba ronei dinaa pelee naranaraa ro'odu. ");
INSERT INTO wuv_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","Ma'uaa wagii fei bigi'ana fi fa'aiaa ei rama'a: ina fama'aiaa fei rawani'ana wagii fei fanana fei maunu ma ei du'ua wagii fei au ro'odu. Ina fani watauda du'ua a'a hamu'ou ma namina fani ni'eni'ea a'a ei naranaraa hamu'odu.” ");
INSERT INTO wuv_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Laguna ware ale'ei, ma'uaa na we'i fei naranaraa ei rama'a ba ro'aa uduginaa lagua a'a fei lafigifama'eaa ei buduma'ao. ");
INSERT INTO wuv_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Ma idii, hefi'a Jew, noramiaa ro'odu Antioch ma Iconium, rona u'ugainaa fei gupuu rama'a ma nafanaa Paul mugoo ma foraneneneinia auguu fei gufu uaa rona nara ba ina ma'e. ");
INSERT INTO wuv_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Ma'uaa, ro'aa faweloinia ei otalai nenera, ina asi'aa ma wadu'ai hadiwe'idinaa fei gufu. I arewadiai, hia ma Barnabas, laguna aununaa Derbe. ");
INSERT INTO wuv_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Laguna u'ugaa fei rawani'a warea a'a fei gufu fei ma watauda na filoginaa naranaraa ro'odu ba ro'ou, otalai nenera. Ma laguna hadiwe'inaa Lystra, Iconium ma Antioch ");
INSERT INTO wuv_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","ma laguna fawe'inaa ei otalai nenera ma warehadumaa ro'ou ba ronei oafawe'i a'a fei narafawe'ia. Laguna ware, “O'amina nanamuinaa watauda fi'ia ba o'aa wadu'ainaa fei haparaiaa mei Haidaa.” ");
INSERT INTO wuv_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Paul ma Barnabas, laguna uniaa hefi'a bauaniaa losuu, ale'ei bauaniaa hepapalo losuu ma fininaa fei mau fabaoa ma lafulafua, laguna apunainaa ro'odu a'a mei Fasu, mei rona narafawe'i a'ana. ");
INSERT INTO wuv_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Lagu'aa tatalaidii yei Pisidia, laguna dinaa Pamphylia ");
INSERT INTO wuv_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","ma lagu'aa u'udigaa fei warea yei Perga, laguna aununaa Attalia. ");
INSERT INTO wuv_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","Idii, laguna di'ininaa Attalia, tamahadiwe'inaa Antioch, fei gufuu ei rama'a ronadii haweginaa lagua wagii fei rawani'aa mei Haidaa ba lagu'aa bigi'aa fei bigi'a, fei laguna fapedugia e'eni. ");
INSERT INTO wuv_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Lagu'aa fatete, laguna apainamii ei losuia ma warefanaa ro'ou minaa ei bigi'aa mei Haidaa i panii lagua ma batanai i gigiaa fei gigei fei narafawe'ia a'a ei Gentile. ");
INSERT INTO wuv_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Ma lagunamina guta famadii yei a'a ei otalai nenera. ");
INSERT INTO wuv_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Hefi'a wawane, noramiaa ro'ou Judea na dinaa Antioch ma feroinaa ei lofu: “Nabaa lomi hamona moro'aa hudii wawanei ale'ei fei mau feroiaa Moses, lomi hamo'aa tela.” ");
INSERT INTO wuv_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","A'a fei, Paul ma Barnabas, laguna fiharenii a'a ro'ou. Si'ei, rona uniaa Paul ma Barnabas mawe hefi'a ei narafawe'ia ba ronei dinaa Jerusalem ma re ma'a ei apostle ma ei bauaniaa losuu wagii fei manumanu fei. ");
INSERT INTO wuv_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Ei losuia, rona aloaa ro'ou ma ei roi talailao yei Phoenicia ma Samaria, rona u'ufanaa ro'ou ba ei Gentile, rona filogii naranaraa ro'odu ma narafawe'i. Minaa ei lofu, ronamina ni'eni'e a'a feni u'uga feni. ");
INSERT INTO wuv_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Ro'aa nopa'aloo Jerusalem, ei losuia ma ei apostle mawe ei bauaniaa losuu, rona taufagutanaa ro'ou. Ma ei noramiaa ro'ou Judea, rona u'ufanaa ro'ou minaa ei na biginaa ro'ou mei Haidaa. ");
INSERT INTO wuv_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Ma hefi'a ei narafawe'ia, hefi'a maroaa ei Pharisee, rona ufalarai ma ware, “Ei Gentile, ronei moro'aa hudii wawanei ma neneraa fei law Moses.” ");
INSERT INTO wuv_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Ei apostle mawe ei bauaniaa losuu, rona gutafipui ba ro'aa fiwarewareinaa feni. ");
INSERT INTO wuv_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Ro'aa fiwarewareidii, Peter na asi'aa ma ware, “Ena lofuu, hamona aida ba ale'ei figa arewaa na didii, mei Haidaa na rafeinaa hemea dupuaa hamu'ou ba ei Gentile, ronei guainaa fei rawani'a warea a'a feni haba'umuu ma ronei narafawe'i. ");
INSERT INTO wuv_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","Ma a'a ro'ou, mei Haidaa, mei na fanunu'apa'aa ei naranaraa rama'a na fama'aia ba rona rawani. Ma na fanaa ro'ou fei Spiriti Apuna ana ale'ei i fanaa o'ou. ");
INSERT INTO wuv_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","Lomi ina nara ba rona u'ugai ma o'ou u'ugai, uaa ina fafafa'arainaa fei naranaraa ro'odu a'a fei narafawe'ia. ");
INSERT INTO wuv_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","Si'ei, tani hamo'aa maniaa mei Haidaa ba hamo'aa fani rarabaa a'a ei Gentile, ei otalai nenera ba ronei harenaa fei manumanu, fei o'ou ma ei amaa o'ou lomi owe harepa'ia? ");
INSERT INTO wuv_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Agia! Ona aida ba a'a fei rawani'aa mei Fasuu o'ou Jesus, ona tela, ana ale'ei ro'odu.” ");
INSERT INTO wuv_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Minaa ei rama'a ronamina babanini ei ro'aa guainaa Barnabas ma Paul, lagu'ei u'ufanaa ro'odu ei fananawalaa puda ma hilalaa foigia laguna bigi'ia wagii fei faufau mei Haidaa i a'a ei Gentile. ");
INSERT INTO wuv_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Lagu'aa pedu, James, na ware, “Ena lofuu, hamonei guainau. ");
INSERT INTO wuv_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Simeon na u'ufanidigaa o'ou ba mei Haidaa nadii fama'aa o'odu ba hia na pa'i naranarana a'a ei Gentile uaa ina uniaa hefi'a ei Gentile ba rama'aa gufuna. ");
INSERT INTO wuv_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","Ei ne'iaa ei mamama'a na fimina'ei a'a fei, uaa rona ne'inia ale'ei: ");
INSERT INTO wuv_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","“‘Nenee fei, awe hadiwe'imai ma fadudinaa fei humuu David, fei na worosi. Ei memena awe fadudinia ma auhadiwe'idinia ");
INSERT INTO wuv_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","ba ei dufudufu rama'a ma minaa ei Gentile, ei rona pa'i fei harau, roneimina labaginaa mei Fasu, ale'ei wareaa mei Fasu, mei i bigi'aa ei manumanu ei,’ ");
INSERT INTO wuv_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","ei rona guainamai mina. ");
INSERT INTO wuv_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","“Ale'ei fanunuau ba onei'amina fatemuaa ei Gentile, ei rona momo'ainaa a'a mei Haidaa. ");
INSERT INTO wuv_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","Ma'uaa onei ne'ifanaa ro'odu ba ronei'aa hanaiaa ei dufuu du'ua, ei rona hamamaninaa a'a ei haidaa sifisifi, o fitatafipa'ai, o hanaiaa pigio ei manulelele rona fifigia, o hunu namo. ");
INSERT INTO wuv_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Uaa mina, nopa'amii e'eni rona u'ugaa ei wareaa Moses a'a minaa ei gufu laloo minaa ei synagogue, minaa ei Sabbath.” ");
INSERT INTO wuv_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Idii, ei apostle ma ei bauaniaa losuu ma minaa ei losuia, rona fiwarei ba ro'aa alofipuinaa a'a Paul ma Barnabas yei Antioch hefi'a maroaa ro'odu. Rona rafeinaa Judas (ana harana Barsabbas) ma Silas, laguei bauaniaa ei lofu ba lagunei aunu. ");
INSERT INTO wuv_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","Laguna notonalao fei ne'iaa ro'ou ma fei ne'ia na ware ba: Hai'ou apostle ma bauaniaa losuu, hai'ou ena lofuu hamu'ou, hai'ou'ei aloawii feni a'a ei Gentile narafawe'ia yei Antioch, Syria ma Cilicia: Hamu'ou batanai? ");
INSERT INTO wuv_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","Hai'ouna guainia ba hefi'a hai'ou na dinaa a'a hamu'odu, ma'uaa lomi hai'ouna uga a'a ro'odu ba na rawani ma rona fani awataa hamu'odu a'a ei wareaa ro'odu. ");
INSERT INTO wuv_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","Si'ei, minaa hai'ouna fiwarei ba hai'ou aloawii hini ei rama'a fipui a'a lagueni pa'aa tafii o'ou, Barnabas ma Paul, ");
INSERT INTO wuv_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","laguei rama'a, laguna nigoaa ei manumanu na pa'i ma'ea wagina uaa fei haraa mei Fasuu o'odu, Jesus Christ. ");
INSERT INTO wuv_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","Si'ei, hai'ou aloawii Judas ma Silas ba lagunei warefanaa hamu'odu ba feni ne'iaa hai'odu pa'aa fa'ua. ");
INSERT INTO wuv_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","Ale'ei fanunuaa hai'odu ba wagii fei Spiriti Apuna hai'ounei'aa fatemuaa hamu'ou a'a hefi'adiai ei maumau hai'ou Jew, ma'uaa si'eni ua: ");
INSERT INTO wuv_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","Hamonei'aa hanaiaa ei du'ua hefi'a rona fania a'a ei haidaa sifisifi, o hunu namo, o hanaiaa pigioo ei manulelele rona guafifigia, o fitatafipa'ai. Napa'aa rawani nabaa hamo'aa faraua a'a ei manumanu ei. Ma'adinaa hamu'odu. ");
INSERT INTO wuv_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Rona aloaa ei rama'a ei ma ei aloaa ro'ou, rona aununaa pu dinaa Antioch ma lala'amii ei losuia ba ro'aa fanaa fei ne'ia a'a ro'ou. ");
INSERT INTO wuv_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","Ei rama'a rona igoia ma na ni'eni'e a'a fei ne'ia fei, uaa na farawaninaa naranaraa ro'ou. ");
INSERT INTO wuv_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Judas ma Silas, lagua mamama'a. Ma a'a watauda ei warea, laguna warefarawaninaa naranaraa ei lofu ma fawe'inaa ro'ou. ");
INSERT INTO wuv_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","Lagu'aa gutafamadii ma'ida, ei lofu yei, rona aloaa lagua wagii fei hawegiaa fei gutafarawania ba lagunei hadiwe'idinaa a'a ei ro aloamiaa lagua. ");
INSERT INTO wuv_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","Ma'uaa Paul ma Barnabas, laguna guta yei Antioch fipui a'a wataudadiai ma rona feferoi ma u'ugaa fei wareaa mei Fasu. ");
INSERT INTO wuv_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Nenee hefi'adiai arewaa, Paul na warenaa a'a Barnabas, “Na rawani ba agu'aa hadiwe'inaa minaa ei gufu, ei agunadii u'ugaa fei wareaa mei Fasu ba agua gutafipui a'a ei lofu ma ma'aia ba rona rawani, o lo'e.” ");
INSERT INTO wuv_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","Barnabas na nunuminia ba i nodugaa John, mei ana harana Mark ba nei aunuhugiaa lagua, ");
INSERT INTO wuv_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","ma'uaa Paul na nara ba lomi na rawani ba lagu'aa dugia, uaa na di'ininaa ro'odu yei Pamphylia ma lomi na bigifipui wagii fei bigi'aa ro'odu. ");
INSERT INTO wuv_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Lagunamina fiharenii, si'ei laguna fidi'ininii. Barnabas na nodugaa Mark ma laguna tamanaa Cyprus, ");
INSERT INTO wuv_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","ma'uaa Paul na nodugaa Silas ma aunu ma ei lofu, rona haweginaa lagua a'a fei rawani'aa mei Fasu. ");
INSERT INTO wuv_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","Ina tatalainaa Syria ma Cilicia ma fawe'inaa ei losuia. ");
INSERT INTO wuv_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Ina aununaa Derbe. Ma nene na aununaa Lystra ma hemea otalai nenera na guta yei, harana Timothy. Mei inana, Jew, hemea narafawe'ia, ma'uaa mei amana, Greece. ");
INSERT INTO wuv_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","Ei lofu yei Lystra ma Iconium, rona ware ba hia, rawani'a rama'a. ");
INSERT INTO wuv_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","Paul na nunuminia ba i nodugia wagii fei tatalaiana, si'ei na moro'aa hudii wawaneina uaa ei Jew yei, ronamina aida ba mei amana, Greece. ");
INSERT INTO wuv_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Lagu'aa tatalailao a'a hepapalo gufu, laguna warefa'aiaa ro'odu fei naranaraa ei apostle ma ei bauaniaa losuu yei Jerusalem ba ei rama'a, ronei guaipa'aa wareana. ");
INSERT INTO wuv_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Ma i nogipelao fei narafawe'iaa ei losuia ma fei puduu ro'ou ana fimina wataualao minaa ei arewaa. ");
INSERT INTO wuv_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","Paul ma ei maroana, rona tatalai yei malalaa Phrygia ma Galatia, uaa fei Spiriti Apuna na lawaraa ro'ou ba ronei'aa u'u a'a ei gufu malalaa Asia. ");
INSERT INTO wuv_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","Ro'aa nofarafi'inamii Mysia ma ba ro'aa wadu'ainaa Bithynia, ma'uaa fei Spiritii Jesus, lomi na ugainaa ro'odu. ");
INSERT INTO wuv_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","Si'ei, rona farapa Mysia ma aunulao Troas. ");
INSERT INTO wuv_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","Ma a'a fei poi, Paul na fanunuaa fei ale'ei mefi ba hemea Macedonia na ufalarai ma i'igifawe'inia, “Nomai yeni Macedonia ma hadumaa hai'odu.” ");
INSERT INTO wuv_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Paul, i'a fanunudigaa fei, ana ei ua hai'ouna asi'aa ba hai'ou'aa aununaa Macedonia, uaa hai'ouna nara ba mei Haidaa na lala'aa hai'ou ba hai'ounei u'ufanaa ro'ou fei rawani'a warea. ");
INSERT INTO wuv_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Yei Troas, hai'ouna ala ma tamafawanewanenaa Samothrace ma i arewadiai, hai'ouna dinaa Neapolis. ");
INSERT INTO wuv_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","Hai'ouna ala yei, tamanaa Philippi, hepalo gufu Rome, fei baua gufu yei laloo Macedonia. Ma hai'ouna guta yei hefi'a arewaa. ");
INSERT INTO wuv_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","Hefaa Sabbath, hai'ouna dinaa ano a'a fei gigei fei gufu, dinaa adii fei ranu ba hai'ou'aa labaginaa fawelei rona'aida lafulafu wagina. Hai'ouna guta ma wareware a'a ei pifine, ei rona figupui yei. ");
INSERT INTO wuv_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Hemea tapuu ro'ou fi gutaguguai, harana Lydia. Hia na'aida alo lawalawa, pomana purple na rata pono'ana. Gufuna Thyatira ma hia na'aida losuinaa mei Haidaa. Ma mei Fasu na gigiaa fei naranarana ba nei tonaa fei wareaa Paul. ");
INSERT INTO wuv_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","Hia ma ei rama'aa humuna, ro'aa pudugufaidii, ina warenaa a'a hai'odu ba hai'ounei dinaa humuna. Ina ware, “Nabaa hamona nara ba yau hemea narafawe'ia a'a mei Fasu, te hamoneimii guta yeni humuu.” Ma ina warefawe'i a'a hai'odu. ");
INSERT INTO wuv_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Heai arewaa, hai'ou'aa dinaa a'a fei hai'ouna'o lafulafu, na nomai a'a hai'ou hemea nanao humuwa, hemea na wadu'ia fei mau pigea ba hia ale'ei mamama'a ba idii wareaa tamanu iwe nomai hinene. Ei fasuna rona'aida to watauda mugoo po'i a'a ei warewareaa mei nanao mei. ");
INSERT INTO wuv_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","Mei nanao mei, na neneraa Paul mawe hai'ou ma memewai, “Eni rama'a eni, nafii mei Haidaa, mei na Pa'aa Pafeai ma ro'ei warefanaa hamu'odu fei tala ba hamowe tela.” ");
INSERT INTO wuv_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","Ina bigi'ia ale'ei laloo watauda arewaa. Paul nawe nifi rawana, foisinaa a'ana ma warenaa a'a fei pigea, “I a'a fei haraa Jesus Christ a warefanio, wala'amai a'ana!” Ana ei ua fei pigea na di'ininia. ");
INSERT INTO wuv_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Ro'aa fanunu'apa'ia ei fasuu mei nanao humuwa ba fei talaa totoo mugoo po'ii ro'ou na pedu, rona panarofaa Paul ma Silas ma foraneneneinaa lagua fawelei rona aida alo'alo manumanu ba lagunei u i ma'aa ei bauana. ");
INSERT INTO wuv_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","Rona duginamii lagua i ma'aa ei fadududua ma ware, “Lagueni rama'a lagueni, lagua Jew ma laguna fafeloaa feni gufuu o'odu uaa ");
INSERT INTO wuv_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","laguna ware ba onei neneraa ei maumau ro'odu ma'uaa nabaa o'aa ugainia o nenegia, ona barafeaa ei law Rome.” ");
INSERT INTO wuv_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","Fei gupuu rama'a ana rona haperaraiaa Paul ma Silas ma ei fadududua rona warefawe'i ba ronei alaraa lalawaa lagua ma hafugaa lagua. ");
INSERT INTO wuv_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","Ro'aa hafufanima'adigaa lagua, rona siminaa lagua bobo'aia ma warefawe'i a'a mei oma'ama'aa ba nei oma'afarawaninaa lagua. ");
INSERT INTO wuv_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","I guainia ale'ei, ina augaa lagua laloo fei pa'aa lalona ma faunaa pinee lagua alatai. ");
INSERT INTO wuv_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","Ale'ei poi difa'u'u Paul ma Silas, lagu'ei lafulafunaa a'a mei Haidaa ma laugi'uduginia ma ei rama'a bobo'aia, rona guguainaa lagua. ");
INSERT INTO wuv_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","Hai'ouna madu'ofo uaa namina rerefafelo fei malagufu ma fei e'eaa fei humuu bobo'aia anaa. Ana ei ua minaa ei gigei fei bobo'aia na gigi ma minaa ei alatai na ma'ala. ");
INSERT INTO wuv_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","Mei oma'ama'aa na wera ma i fanunuia ba na gigi ei gigei, na tonaa fei waduna ba i fo'afama'eaa anaia, uaa ina nara ba rona ponipa'ai ei bobo'aia. ");
INSERT INTO wuv_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Ma'uaa na haroharo Paul, “Apuna apuguio! Minaa hai'ou yeni!” ");
INSERT INTO wuv_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","Mei oma'ama'aa na haroharo ba ei maroana, ronei tonamai fei we'ai ma na poniwadu'ainaa fei pusu'o humuu Paul ma Silas, fei laguna bobo'ai lalona. Ina pasi i ma'aa lagua ma na funurerere. ");
INSERT INTO wuv_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","Ma ina noduginaa lagua ano ma i'igai, “Megu, yau a bigi'aa tamanu ba a tela?” ");
INSERT INTO wuv_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","Laguna ware, “Narafawe'i a'a mei Fasu Jesus ma o'aa tela—yoi ma ena maroamu i humumu.” ");
INSERT INTO wuv_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","Ma laguna u'ufanaa fei u'ugaa mei Fasu a'ana ma a'a minaa ei rama'a laloo fei humuna. ");
INSERT INTO wuv_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","I a'a fei poi fei, mei oma'ama'aa na dugaa lagua, fesuaa ei loraloraa lagua; ana ei ua, hia ma minaa ei gufuna i humuna, rona pudugufai. ");
INSERT INTO wuv_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","Mei oma'ama'aa na dugamii lagua laloo humuna ma hasufani hanaa lagua; hia, namina ni'eni'e uaa hia ma minaa ei maroana i humuna, ronawe narafawe'i a'a mei Haidaa. ");
INSERT INTO wuv_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","Heai arewadiai, ei fadududua, rona aloaa ei wareaa ro'ou a'a ei paniaa panii ro'ou dinaa a'a mei oma'ama'aa ale'ei, “Hamonei alaraa lagua.” ");
INSERT INTO wuv_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","Mei oma'ama'aa na warenaa a'a Paul ba, “Ei fadududua na ware ba hai'ounei alaraa hamugua Silas. E'eni, hamunei dii. Aunufa'a'a ua.” ");
INSERT INTO wuv_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","Ma'uaa Paul na warenaa a'a ei paniaa pani: “Rona hafugaa haigua pudaa rama'a, ma'uaa haigua rama'aa Rome. Lomi rona aunaa haigua dududua ma'uaa rona bobo'ainaa haigua. E'eni rona nunuminia ba ro'aa fa'asi'afagiginaa haigua ba haigunei babanini. Pa'aa lomi! Ana ro'ou, roneimii fa'asi'anaa haigua bobo'aia.” ");
INSERT INTO wuv_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","Ei paniaa panii ro'odu, rona warefanaa fei a'a ei fadududua ma ro'aa guainia ba Paul ma Silas, lagua rama'aa Rome, rona ma'au. ");
INSERT INTO wuv_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","Rona nomai ba ro'aa farawaninaa naranaraa lagua ma fa'asi'anaa lagua bobo'aia, talaifipui a'a lagua ma i'iginaa lagua ba lagunei di'ininaa fei gufu. ");
INSERT INTO wuv_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","Paul ma Silas, lagu'aa asi'adii humuu bobo'ai, laguna dinaa humuu Lydia ma yei, laguna gutafipui a'a ei lofu ma warefawe'inaa naranaraa ro'ou ma lagunawe dii. ");
INSERT INTO wuv_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","Lagu'aa farapadi'ininaa Amphipolis ma Apollonia, laguna aununamii Thessalonica. Na pa'i hepalo synagogue Jew yei. ");
INSERT INTO wuv_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","Ale'ei fei maumauna, Paul na wadu'ainaa fei synagogue ma laloo oduai Sabbath na fiwarewarei a'a ro'ou wagii tamanu na ude i laloo fei Bu'u Apuna ");
INSERT INTO wuv_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","ma na fa'arewaia ba Christ nei tonaa fi'ina ma asi'aa a'a fei ma'ea. Ina ware, “Meni Jesus, meni u'ei u'ugia a'a hamu'odu, hia mei Christ.” ");
INSERT INTO wuv_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","Hefi'a ei Jew, rona nara ba fa'ua ma rona oafipui a'a Paul ma Silas ana ale'ei watauda ei Greece, ei rona ma'auaa mei Haidaa mawe ei pifine, ei rona pa'i baua haraa ro'odu. ");
INSERT INTO wuv_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","Ma'uaa ei Jew, rona punepune; si'ei, rona dugamii hefi'a hafelo'a rama'a yei fawelei rona alo'alo manumanu. Rona nofipuimai ma fa'asi'anaa hefaa baua fisibaia yei a'a fei baua gufu. Rona poninaa humuu Jason ba ro'aa labaginaa Paul ma Silas ba ro'aa foranaa lagua a'a fei gupuu rama'a. ");
INSERT INTO wuv_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","Ma'uaa lomi rona labigipa'aa lagua, si'ei rona foraiaa Jason ma hefi'adiai lofu dinaa a'a ei bauaniaa gufu ma haroharo, “Eni rama'a eni, rona bigifafelo i gufu tadiwe'ai ma e'eni rona nomai yeni. ");
INSERT INTO wuv_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","Ma Jason na noduginaa ro'ou humuna. Minaa ro'ou, ronamina barafeaa ei wareaa Caesar. Rona ware ba na pa'i hemeadiai hapara, harana Jesus.” ");
INSERT INTO wuv_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","Ro'aa guainia, fei gupuu rama'a mawe ei bauaniaa gufu, rona poapoai ma rona ra wagina. ");
INSERT INTO wuv_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","Ma rona fapono'aa Jason ma ro'ou a'a ei hafelo'aa ro'odu ma alaraa ro'ou. ");
INSERT INTO wuv_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","I poilao, ei lofu, rona fatalainaa Paul ma Silas dinaa Berea. Lagu'aa nolao yei, laguna dinaa fei synagogue ei Jew. ");
INSERT INTO wuv_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","Ma ei Jew Berea, fei maumau ro'odu na muainaa fei maumau ei Thessalonica, uaa ronamina refuguainaa fei warea ma minaa ei arewaa rona igofarawaninaa fei Bu'u Apuna ma labaginia ba fa'ua wareaa Paul o lomi? ");
INSERT INTO wuv_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","Watauda Jew, watauda pifinee Greece, ei rona pa'i baua haraa ro'ou mawe watauda wawanee Greece, rona narafawe'i. ");
INSERT INTO wuv_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","Ro'aa guainia ei Jew yei Thessalonica ba Paul fi u'ugaa fei wareaa mei Haidaa yei Berea, ana rona aunulao, fani tabaa ei rama'a ma fawesuwesuaa iaa ro'odu. ");
INSERT INTO wuv_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","Ana ei ua, ei lofu, rona aloaa Paul dinaa ei gufu i papaa agi, ma'uaa Silas ma Timothy, laguna guta yei Berea. ");
INSERT INTO wuv_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","Ei ro'aa nodugaa Paul, rona duginaa hia Athens ma aununotonaa fei i'igiana ba Silas ma Timothy, lagunei'aa gutafamadii, uaa lagunei nobatafamai a'ana. ");
INSERT INTO wuv_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","Yei Athens Paul, ei fi guta'oma'oma'aa lagua, namina faloloa'i uaa na fanunupa'ia ba fei gufu i guta wagina na pepesu a'a ei haidaa sifisifi. ");
INSERT INTO wuv_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","Si'ei na fiwarewarei a'a ei Jew mawe ei Greece, ei rona ma'auaa mei Haidaa i laloo fei synagogue ma a'a hini ei ro'ou yei fawelei rona alo'alo manumanu minaa ei arewaa anaa. ");
INSERT INTO wuv_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","Hefaa maroa, rona pa'i baua apa'aa ro'ou (haraa hefi'a ro'ou maroaa Epicurus ma haraa hefi'adiai Stoic), rona fiharenii a'ana. Hefi'a, rona i'igai, “Tamanu eni wareana, meni ba'aba'a umu?” Hefi'adiai, rona ware, “Narau ba ifi u'ugaa ei haidaniaa hepapa gufu.” Rona ware ale'ei uaa Paul na u'ugaa fei rawani'a warea, fei u'ugaa Jesus mawe fei asi'ana. ");
INSERT INTO wuv_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","Rona panarofia ma noduginaa hia a'a fei gupuu ei maroaa Areopagus ma warenaa a'ana, “Warefanaa hai'odu. Tamanu fei manufau feroia oi feroinia? ");
INSERT INTO wuv_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","Hai'ouna guainaa hefi'a manufau manumanu ma ba hai'ou'aa apa'ia ba tamanu hanuna.” ");
INSERT INTO wuv_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","(Minaa ei Athens mawe ei rama'aa hepapa gufu, ei rona guta yei, lomi rona u bigi'aa hepalodiai manumanu—rona'o gutaguainaa ei manufau naranara ma fiwarewarei wagina.) ");
INSERT INTO wuv_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","Paul nawe ufalarai a'a fei gupuu ei Areopagus ma ware: “Hamu'ou ena Athens! Una fanunu'apa'ia ba hamu'ou pa'aa losuia. ");
INSERT INTO wuv_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","Uaa a tatalai fanunufarawaninaa ei pusu'o manumanu losuu hamu'odu, ana una ma'apa'aa hepalo tawahafi na apunai ma na pa'i feni ne'ia feni: FENI I DINAA A'A HEMEA HAIDAA, LOMI HAI'OUNA APA'IA. E'eni a warefa'aiaa hamu'odu tamanu hamona'aida losuinia ma'uaa lomi hamona apa'ia. ");
INSERT INTO wuv_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","“Mei Haidaa, mei na bigi'aa feni ano ma minaa ei manumanu wagina, hia mei Fasu i pumanugawe ma i malagufu ma lomi ba i oa i laloo ei humuu ei haidaa, ei faduaa rama'a. ");
INSERT INTO wuv_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","Ma ei panii rama'a lomi ba i hadumia, raba na nunuminaa hepalodiai manumanu, uaa ana hia ua mei na fani harenua a'a minaa ei rama'a ba ronei fawewenai ma ana na fanaa minaa ei manumanu ro'ou. ");
INSERT INTO wuv_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","A'a hemea ua, ina bigi'aa ei rama'aa minaa ei gufu ba ronei guta tadiwe'ai feni ano ma atado'o bigi'aa ro'ou, nadii nara'augia ba ro guta hitani ma wanini nahaiga. ");
INSERT INTO wuv_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","Mei Haidaa na bigi'ia ale'ei ba ei rama'a ronei labaginia ma labagipa'ia. Ma hia, abaa ale'ei ba ina raua a'a hememea o'odu. ");
INSERT INTO wuv_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","Uaa i a'ana ona fawewenai ma tatawei ma rama'ai. Ana ale'ei fei ne'iaa hefi'a gufuu hamu'ou, ‘Hai'oudu ana na'una.’ ");
INSERT INTO wuv_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","“Si'ei ba o'ou na'uu mei Haidaa, hai'ounei'aa nara ba mei Haidaa, hia ale'ei gold, silver, na'a, o hepalo bigi'aa hemea ano'ano, o tafi'aa hemea na pa'i apa'ana. ");
INSERT INTO wuv_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","Mina, ei rama'a, lomi rona pa'i apa'aa ro'ou ma mei Haidaa na fanunuaa fei ma na nara ba lomi iwe dududuaa ro'ou a'a fei. Ma'uaa e'eni ina ware ba minaa ei rama'a i tadiwe'aia, ronei filoginaa naranaraa ro'odu. ");
INSERT INTO wuv_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","Uaa inadii augaa neai arewaa, neai ba i dududuaa feni ano a'a mei inadii apunaidigia ma fei dududuana na wanewane. Mei Haidaa na fa'arewadigia a'a minaa ei rama'a ei i fa'asi'ania a'a fei ma'ea.” ");
INSERT INTO wuv_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","Ro'aa guainaa fei asi'ana a'a fei ma'ea, hefi'a ro'ou, rona fatofeaa nugee ro'ou, ma'uaa hefi'adiai, rona ware, “Hai'ouna nunuminia ba onei u'udinia fei.” ");
INSERT INTO wuv_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","Ma Paul na asi'adi'ininaa fei maroa fei. ");
INSERT INTO wuv_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","Hefi'a ua, rona neneraa ei feroiaa Paul ma narafawe'i. Hemea ro'ou, Dionysius, hemea Areopagus ma hemea pifine harana Damaris mawe hefi'adiai. ");
INSERT INTO wuv_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","Nenee fei, Paul na di'ininaa Athens dinaa Corinth. ");
INSERT INTO wuv_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","Yei, ina bapa'aa hemea Jew harana Aquila, gufuna Pontus. Mei we no'uanamai Italy lagua mei harona Priscilla, uaa Claudius na ware ba minaa ei Jew, ronei di'ininaa Rome. Paul na aunu ba iree ma'a lagua. ");
INSERT INTO wuv_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","Si'ei ba hia na'aida bigi'aa ei pale poroporo ana ale'ei lagua, ina guta ma bigifipui a'a lagua. ");
INSERT INTO wuv_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","Minaa ei Sabbath na wadu'ainaa fei synagogue ma fiwarewarei a'a ei Jew ma ei Greece ba ronei nara ba fa'ua wareana. ");
INSERT INTO wuv_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","Silas ma Timothy, lagu'aa nodigimai yei Macedonia, Paul na u'u ua, namina u'ufa'arewainia a'a ei Jew ba Jesus, hia Christ. ");
INSERT INTO wuv_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","Ma'uaa ei Jew, ro'aa warefawe'i ma harea ba abaa ale'ei, ina foifoiaa piye susuna, uaa lomi na nunuminaa fei ma na warenaa a'a ro'ou, “Fei dududuaa mei Fasu na ude i a'a hamu'odu! Una bigidigaa fei bigi'au a'a hamu'odu. E'eni apowe dinaa a'a ei Gentile.” ");
INSERT INTO wuv_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","Ma Paul na asi'adi'ininaa fei synagogue ma dinaa fei humu papana, fei humuu Titius Justus, hemea na losuinaa mei Haidaa. ");
INSERT INTO wuv_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","Crispus, mei bauaniaa fei synagogue ma minaa ei maroana laloo humuna, rona narafawe'i a'a mei Fasu. Ma watauda ei Corinth ro'aa guainia, rona narafawe'i ma pudugufai. ");
INSERT INTO wuv_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","Heai poi, mei Fasu na warenaa a'a Paul wagii fei fanunuana ale'ei mefi, “Apuna ma'au; onei u'u'uawau, apuna babanini. ");
INSERT INTO wuv_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","Uaa yau i a'amu ma lomi nemea ba i farararaoio uaa una pa'i watauda rama'a yeni, i a'a feni gufu feni.” ");
INSERT INTO wuv_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","Si'ei, Paul na guta yei heai ma hesuwi igisimasi ma na feroinaa ro'odu fei wareaa mei Haidaa. ");
INSERT INTO wuv_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","Wagii fei au ba Gallio hia gavanaa Achaia, ei Jew na nofipuimai ma fadugeaa Paul ma noduginaa hia dududua. ");
INSERT INTO wuv_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","Rona ware, “Meni rama'a meni, fi feroinaa ei rama'a ba ronei losuinaa mei Haidaa, ma'uaa fei mau losuia fei, ina barafeaa fei law.” ");
INSERT INTO wuv_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","Ma ba i ware Paul, Gallio na warefanaa ei Jew, “Nabaa hamu'ou Jew hamo'aa ware ba ina barafeaa hefei pa'aa law, hefei pusu'o, o baua law, te, a guainaa hamu'oudu. ");
INSERT INTO wuv_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","Ma'uaa, si'ei ba hamona fawo'aa ei warea, hara ma law hamu'ou Jew—hamonei fawanewaneaa ana hamu'ou. Lomi a dududuaa eni mau manumanu ale'eni.” ");
INSERT INTO wuv_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","Si'ei, ina teteaa ro'odu a'a fei humuu dududua. ");
INSERT INTO wuv_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","Ma rona'aa guafaa Sosthenes, mei bauaniaa synagogue ma rona hafugia i poaa fei humuu dududua. Ma'uaa Gallio, lomi ba na falanaa huona fei. ");
INSERT INTO wuv_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","Paul na guta famadii ma'ida yei Corinth. Ma nawe di'ininaa ei lofu ma tamanaa Syria. Priscilla ma Aquila, laguna aunuhugia. Ma ei atawe tama, na fapi'aa hugo tabana yei Cenchrea, uaa fei fa'unaiana a'a mei Fasu. ");
INSERT INTO wuv_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","Rona pe'i yei Ephesus ma Paul na di'ininaa Priscilla ma Aquila yei. Ma hia na wadu'ainaa fei synagogue ma fiwarewarei a'a ei Jew. ");
INSERT INTO wuv_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","Rona i'igainia ba neido'o gutadiai a'a ro'ou ma ina ware ba lomi. ");
INSERT INTO wuv_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","Ma'uaa, ei ifi nolao nadii fa'unai, “Awe hadiwe'imai nabaa i nunuminia mei Haidaa.” Idii, nawe tamadi'ininaa Ephesus. ");
INSERT INTO wuv_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","Iree pe'i yei Caesarea, na wanolao ma na bapa'aa ei losuia ma nenee fei na upu'aunulao Antioch. ");
INSERT INTO wuv_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","I gutafamadidii yei Antioch, Paul na asi'aa yei ma na tatalai a'a hepapalo gufu yei malalaa Galatia ma Phrygia ma ina fawe'iaa naranaraa minaa ei otalai nenera. ");
INSERT INTO wuv_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","I bigi'aa ei manumanu ei, hemea Jew harana Apollos, gufuna Alexandria na aununaa Ephesus. Ina todigaa watauda feroia ma si'ei napa'aa bauana apa'ana a'a fei Bu'u Apuna. ");
INSERT INTO wuv_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","Ina to feroiana wagii fei talaa mei Fasu ma waretofininaa refuaa ununa ma u'ufarawaninaa fei u'ugaa Jesus. Ma'uaa apa'i'uana fei pudugufaiaa John. ");
INSERT INTO wuv_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","Idii, inawe warefawe'i i laloo fei synagogue. Lagu'aa guainia Priscilla ma Aquila, laguna duginaa hia humuu lagua ma fa'arewa'apoinaa fei talaa mei Haidaa a'ana. ");
INSERT INTO wuv_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","Ba i aununaa Achaia Apollos, ei lofu na warefarefuia ma ne'inaa a'a ei otalai nenera yei ba ronei taufagutania. I nodigimai, namina haweninaa ei rona narafawe'i wagii fei rawani'aa mei Haidaa. ");
INSERT INTO wuv_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","Uaa ina warehota'aa ei Jew pudaa ei rama'a ma fa'arewaia a'a fei Bu'u Apuna ba pa'aa fa'ua ba Jesus, hia mei Christ. ");
INSERT INTO wuv_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","I guta yei Corinth Apollos, Paul na talai a'a fei talaa podu ma naree sufudai yei Ephesus. Ma yei, ina bapa'aa hefi'a otalai nenera ");
INSERT INTO wuv_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","ma na i'iginaa ro'odu, “Ana hamona to fei Spiriti Apuna ei hamo'aa narafawe'i?” Rona ware, “Lomi. Ana lomi hai'ouna guai ba na pa'i hepalo Spiriti Apuna.” ");
INSERT INTO wuv_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","Si'ei, Paul na ware, “Hama tamanu pudugufaia hamona tonia?” Rona ware, “Fei pudugufaiaa John.” ");
INSERT INTO wuv_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","Paul na ware, “Fei pa'afii fena pudugufaiaa John, sifei ba ei rama'a nei filoginaa naranaraa ro'odu. John na warefanaa ei rama'a ba ronei narafawe'i a'a mei iwe nomai nenena, Jesus.” ");
INSERT INTO wuv_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","Ro'aa guainaa fei, ronawe pudugufai a'a fei haraa mei Fasu Jesus. ");
INSERT INTO wuv_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","Paul, i augaa guei panina pafoo ro'ou, fei Spiriti Apuna na pasi pafoo ro'ou ma rona warenaa wareagufuu hefi'a gufu ma dii wareaa tamanu i nomai nene. ");
INSERT INTO wuv_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","Puduu ei rama'a, ale'ena hefua ma helagui. ");
INSERT INTO wuv_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","Paul na wadu'ainaa fei synagogue ma warefawe'i yei laloo oduai puda. Ma fi warewareaa fei haparaiaa mei Haidaa a'a ro'ou. ");
INSERT INTO wuv_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","Ma'uaa namina waiwai tabaa hefi'a ro'odu; lomi rona uga ba fa'ua fei ma rona warefafeloaa fei Tala i pudaa rama'a. Si'ei, Paul na di'ininaa ro'odu. Ina nodugaa ei otalai nenera ma minaa ei arewaa na fiwarewarei a'a ei rama'a yei laloo fei baua humuu feferoi Tyrannus. ");
INSERT INTO wuv_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","Ale'ei fei mau bigi'ana laloo heguai igisimasi. Ma si'ei, minaa ei Jew ma Greece, ei ro'aa guta yei fawelei Asia, rona guainaa fei wareaa mei Fasu. ");
INSERT INTO wuv_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","Mei Haidaa na bigi'aa hefi'a baua foigia a'a Paul ");
INSERT INTO wuv_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","ale'ei ba nabaa hepalo huguu nuge o lawalawa na idoaa Paul ma rona tonalao a'a ei rona funu, ei funuaa ro'ou na pedu ma ei hafelo'a spiriti na di'ininaa ro'ou. ");
INSERT INTO wuv_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","Hefi'a Jew na tatalai ma fawala'anaa ei hafelo'a spiriti a'a ei na wadu'aa ro'ou pigea. Rona lala'aa fei haraa mei Fasu Jesus a'a ei na wadu'aa ro'ou pigea. Rona ware ale'ei, “A'a fei haraa Jesus, mei na u'ugia Paul, a warefanio asi'amai.” ");
INSERT INTO wuv_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","Hemea rama'a, harana Sceva, hia hemea famamoaa humuu mei Haidaniaa ei Jew. Ma na pa'i oloromea na'una, baduu wawane. Ma ei na'una ei, rona'aida bigi'ia ale'ei. ");
INSERT INTO wuv_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","Heai arewaa hepalo hafelo'a spiriti na warenaa a'a ro'odu, “Jesus, una apa'ia. Ma una aida tamanu na bigi'ia Paul, ma'uaa hamu'ou hini?” ");
INSERT INTO wuv_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","Ma mei na wadu'ia hefaa hafelo'a spiriti, ina rofonaa a'a ro'ou ma fugoinaa minaa ro'ou. Namina hafufanima'aa ro'ou ma si'ei rona poni'ala'ala'asi'aa a'a fei humu fininaa raraa unuu ro'ou. ");
INSERT INTO wuv_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","Ro guainia ei Jew ma ei Greece yei Ephesus, ronamina ma'aufafelo ma fei haraa mei Fasu Jesus na dinaa pafea fininaa honua. ");
INSERT INTO wuv_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","Watauda ei narafawe'ia, ronawe nofalelefomai ba ro wareaa tamanu ei bigifafeloaa ro'odu. ");
INSERT INTO wuv_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","Hefi'a, rona'aida bigi'aa ei siafa, rona tonamai ei bu'uu siafaa ro'odu ma fagu'aa ro'ou i pudaa rama'a. Ma puduu pono'aa ei bu'uu siafa ale'ei haipani pa'ania pufaba'a drachma. ");
INSERT INTO wuv_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","Si'ei ba rona fanunuaa ei manumanu ei, fei wareaa mei Fasu namina talainaa watauda gufu ma gipe fininaa fei faufaua. ");
INSERT INTO wuv_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","Nenee minaa e'ei, Paul na nara ba i dinaa Jerusalem ma na aunulao yei Macedonia ma Achaia. Ina ware, “Nenee fei gutanau yei, unei aunu'ailao Rome anaa.” ");
INSERT INTO wuv_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","Ina aloaa helaguei hadumana, Timothy ma Erastus, dinaa Macedonia ma hia, nado'o gutadilao yei laloo fei baua gufu Asia. ");
INSERT INTO wuv_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","A'a fei au fei, na pa'i hefaa baua fisibaia a'a fei Tala. ");
INSERT INTO wuv_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","Hemea na'aida bigi'aa silver, harana Demetrius. Hia na'aida bigi'aa ei pa'aa pusu'o humuu losuu Artemis. Ma a'a fei bigi'aa mei rama'a mei, hefi'adiai ano'ano, rona'aida to watauda mugoo po'i. ");
INSERT INTO wuv_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","Ma ina harofamii ro'ou mawe hefi'a rona pa'i apa'aa ro'ou a'a fei bigi'a fei ma na warenaa a'a ro'ou, “Me'o, hamona'aidadii ba ona'aida to watauda mugoo po'i a'a feni bigi'a feni. ");
INSERT INTO wuv_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","Ma e'eni hamona fanunuia ma guainia ba hemeni Paul na u'ufadiaginaa watauda rama'a yeni Ephesus ma minaa ei rama'a yeni faweleni Asia. Ina ware ba ei haidaniaa ro'ou, ei bigi'aa rama'a, abaa pa'aa haidaa. ");
INSERT INTO wuv_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","Hepalo hafelo'a wagina sifei ba i fafeloaa fei haraa fei bigi'aa o'ou, fei ba o to mugoo po'i wagina ma hepalodiai, fei humuu losuu Artemis, hemei pifine haidaa, ana ropowe nara ba na hafelo ma mei pifine haidaa, mei rona'aida losuinia faweleni Asia ma feni ano, ana iwe pasi fei baua harana, fei ba hia pa'aa rawani'a haidaa.” ");
INSERT INTO wuv_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","Ro'aa guainia, ronamina siba ma haroharo, “Pa'aa bauana Artemis, mei haidaniaa ei Ephesus!” ");
INSERT INTO wuv_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","Ataa madii ma minaa ei rama'aa fei gufu rona siba. Rona panarofaa Gaius ma Aristarchus, laguei lagu'aa noneneramii Paul yei Macedonia ma ponifipui ale'ei hemea rama'a ma duginaa lagua a'a fei rona'aida figupui wagina. ");
INSERT INTO wuv_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","Paul ba i ufalarai i ma'aa ei rama'a ma'uaa ei otalai nenera, rona lawagia. ");
INSERT INTO wuv_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","Ma hefi'a bauaniaa fei gufu, hefi'a tafii Paul, ana rona i'igifawe'i a'ana ba inei'aa dinaa a'a fei rona'aida figupui. ");
INSERT INTO wuv_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","Fei gupuu rama'a na hamamagua: Hefi'a rona mewainaa hepalo manumanu ma hefi'a rona mewainaa hepalodiai manumanu. Ma watauda ana lo'e rona aida ba tani ro'aa nolao yei. ");
INSERT INTO wuv_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","Ei Jew na susuninaa Alexander i ma'a ma hefi'a na harofani wareana. Ina pi'inaa panina ba ronei babanini ba i warefa'aiaa ei rama'a tamanu na fa'ua. ");
INSERT INTO wuv_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","Ma'uaa ro'aa fanunu'apa'ia ba hia Jew, rona iwamemewaifipui, laloo ale'ei guai hour, “Pa'aa bauana Artemis, mei haidaniaa ei Ephesus!” ");
INSERT INTO wuv_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","Mei paniaa panii mei bauaniaa gufu na fababaninaa ei rama'a ma ware, “Hamu'ou ena Ephesus, ei naraa hamu'ou ba minaa ei a'a feni ano lomi rona apa'ia ba feni gufu Ephesus na oma'aa feni humuu losuu Artemis ma fei bigi'aa rama'a fei haduona, fei pasianagio pafea? ");
INSERT INTO wuv_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","Si'ei ba lomi hemea i nara ba na tata fei, hee hamonei babanini. Apuna bigire'ere'einaa hepalo manumanu. ");
INSERT INTO wuv_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","Hamona duginamii yeni eni rama'a eni, ma'uaa lomi rona topa'ainaa manumanuu humuu ei haidaa ma ana lomi rona warefafeloaa mei pifine haidaniaa o'ou. ");
INSERT INTO wuv_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","Si'ei, nabaa Demetrius ma ei ano'ano ro bigi a'ana na pa'i bidi'aa unuu ro'ou a'a hini ro'ou, te na pa'i humuu dududua ma fadududua ma ronei dududuaa ro'ou. ");
INSERT INTO wuv_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","Nabaa hamona pa'i hepalodiai manumanu ba hamona nara ba ina tata, hamonei fawanewaneia a'a fei dududua. ");
INSERT INTO wuv_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","E'eni, na fafanunu ba nabaa ro'aa dududuaa o'ou ei famamoaa fei baua gufu a'a feni fisibaia ma tamanu ona bigi'ia wagieni, pa'aa lo'e ugaa pinee o'ou.” ");
INSERT INTO wuv_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","I waredigaa fei, ina famatalaiaa ei rama'a. ");
INSERT INTO wuv_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","I pedu fei fisibaia, Paul na lala'amii ei otalai nenera. I warehadudigaa ro'ou, na ware ba ma'adinaa hamu'ou ma na di'ininaa ro'ou ba i dinaa Macedonia. ");
INSERT INTO wuv_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","Ina tatalai yei ma wareaa watauda warea, ina nohadumaloo ei rama'a ma nawe nopa'aloo Greece ");
INSERT INTO wuv_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","ma guta yei oduai puda. Paul ba i tale'aununaa Syria, ma'uaa si'ei ba ei Jew rona fiwarewarei ba ro'aa fafeloia, ina nara ba i hadiwe'ainaloo Macedonia. ");
INSERT INTO wuv_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","Rona aunuhugiaa Sopater, hia na'uu Pyrrhus, baduu wawane, mei Berea ma Aristarchus ma Secundus noramiaa lagua Thessalonica ma Gaius, gufuna Derbe ma Timothy mawe Tychicus ma Trophimus noramiaa lagua fawelei Asia. ");
INSERT INTO wuv_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","Ei rama'a ei, ronado'o nonoo ma oma'aa hai'odu yei Troas. ");
INSERT INTO wuv_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","Ma'uaa hai'ouna aladi'ininaa Philippi nenee fei Hananaa fei Faraa Pidaua lo'e Fafuafua. Ma nenee haipanidiai arewaa, hai'ouna bapa'aa ro'odu yei Troas ma guta yei ale'ei oloromeai arewaa. ");
INSERT INTO wuv_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","A'a fei rawarawa arewaa fei hefapagipagia hai'ouna nofipuimai ba hai'ou'aa hana faraa pidaua. Paul na wareware a'a ei rama'a ma ba i aunu narani, si'ei ina wareware nopa'aloo poidifa'u'u. ");
INSERT INTO wuv_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","Ina watauda ei we'ai laloo fei tarea humu, fei hai'ou'ei gutafiwarewarei lalona. ");
INSERT INTO wuv_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","Hemea baubara harana Eutychus na guta i laloo fei pusu'o ale'ei gigei lalarena ma na mama'igu pudana ba ipowe sinoro ei fi warewarelao Paul. I ma'igusinorolao, ina pasinaloo pu a'a fei fa'oduaiaa e'eaa fei tarea humu ma ro'aa poniporo'ia, na ma'edii. ");
INSERT INTO wuv_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","Paul na upulao ma fapasihaino pafoo mei baubara, hapiroro'ia ma ware, “Hamonei'aa ba'arofo. Ina fawenai!” ");
INSERT INTO wuv_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","Ma na tafanedinaa pafea ma na hana faraa pidaua. I wareware nopa'aloo asi'anaa fei halo, na aunu. ");
INSERT INTO wuv_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","Ei rama'a rona noduginaa mei baubara humu, ina fawewenai ma namina rawani naranaraa ro'ou. ");
INSERT INTO wuv_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","Hai'ounado'o nonolao a'a fei baua wa ma tamanaa Assos ba hai'ou fahuginaa Paul. Ina bigi'ia ale'ei ba i talai'uanaa pinena dinaa yei. ");
INSERT INTO wuv_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","I bapa'aa hai'odu yei Assos, hai'ouna fahuginia ma tamanaa Mitylene. ");
INSERT INTO wuv_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","I arewadiai, hai'ouna ala yei ma re pe'i yei Kios. I arewadiai hai'ouna dinaa Samos ma i arewadiai hai'ouna nope'ilao yei Miletus. ");
INSERT INTO wuv_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","Paul na nara ba i farapadi'ininaa Ephesus ba lomi i guta yei Asia, uaa ba i aunubatafanaa Jerusalem nabaa i hawia ba i guta a'a fei rawarawa arewaa Pentecost. ");
INSERT INTO wuv_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","Yei Miletus, Paul na lala'amiaa ei bauaniaa fei losuu yei Ephesus. ");
INSERT INTO wuv_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","Ro'amii maua, ina warenaa a'a ro'ou, “Hamona aidadii fei mau gutanau ranimai a'a hamu'ou, a'a fei rawarawa arewaa a guta fawelei Asia nopa'amii wagieni. ");
INSERT INTO wuv_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","Fa'ua ba ei Jew, ronamina maniau ba ro'aa fafeloau, ma'uaa una fafafaunau pu ma pasi ranu pudau ma na bigi'uaiaa fei bigi'aa mei Fasu. ");
INSERT INTO wuv_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","Hamona aida ba lomi una fa'oa'oai u'ugaa tamanu i hadumaa hamu'ou, uaa una feroinaa hamu'odu i pudaa rama'a ma i a'a hepapalo humu. ");
INSERT INTO wuv_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","Una warefawe'i a'a ei Jew ma ei Greece ba ronei filoginaa naranaraa ro'ou ma foisinaa a'a mei Haidaa ma narafawe'i a'a mei Fasuu o'ou, Jesus. ");
INSERT INTO wuv_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","“Ma e'eni fei Spiriti Apuna na nunuminia ba unei dinaa Jerusalem, ma'uaa lomi una aida ba ro'aa bigi'aa tamanu a'au yei. ");
INSERT INTO wuv_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","Fei apa'au, fei ba a'a minaa ei gufu, fei Spiriti Apuna na warefa'aiau ba fei bobo'aia ma ei hafelo'a na oa ma'au. ");
INSERT INTO wuv_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","Ma'uaa fei harenuau, lomi rarabana a'au nabaa una fapedupa'aa fei fiwaleia ma fei bigi'a, fei na fanau mei Fasu Jesus, fei ba unei warefa'uainaa fei rawani'a wareaa mei Haidaa, fei na fa'arewainaa fei rawani'ana. ");
INSERT INTO wuv_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","“Ma e'eni una apa'ia ba hamu'ou ena hamona guainau eni a u'ugaa fei haparaia, lomi hemea dupuaa hamu'ou i fanunudinau. ");
INSERT INTO wuv_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","26","Si'ei, wagieni a warefawe'i a'a hamu'odu ba lomi a tonaa dududuau nabaa nemea i pa'ai. ");
INSERT INTO wuv_vpl VALUES ("AC20_27","074_20_27","ACT","20","27","27","Uaa, lomi una tamafoi ei a warefawe'iaa minaa ei nunumiaa mei Haidaa. ");
INSERT INTO wuv_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","Oma'aiaa hamu'odu ma minaa ei sipsipi, ei na rafeinaa hamu'ou fei Spiriti Apuna ba oma'ama'aa ro'ou. Hamonei ale'ei oma'aa sipsipii ei losuu mei Haidaa, ei ina pononaa fei namona. ");
INSERT INTO wuv_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","Una'aida ba nenee afadugau ena ponotoo podu rowe nomai i tapuu hamu'ou ma lomi rowe augaa ne'a sipsipi. ");
INSERT INTO wuv_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","A'a hamu'ou anaa, hefi'a rowe asi'aa ma fapidawainaa fei fa'uaia ba ro'aa fahumanaa hefi'a otalai nenera a'a ro'ou. ");
INSERT INTO wuv_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","Si'ei, hamonei ofafaufau! Hamonei nonominia ba laloo oduai igisimasi minaa ei poi ma arewaa, lomi fafau warewagi'inaa hememea hamu'ou ma na pasi ranuu pudau. ");
INSERT INTO wuv_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","“E'eni una aunaa hamu'odu panii mei Haidaa ma fei wareaa fei rawani'ana, fei i fagipepa'aa hamu'ou ma fanaa ei manumanu ana ale'ei i fani a'a ei rona papaditai. ");
INSERT INTO wuv_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","Lomi una nanamainaa ei silver, o gold, o lawalawaa hemea. ");
INSERT INTO wuv_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","Ana hamona aida ba gueni paniu na bigifanaa tamanu yau ma ei tafiu na nunuminia. ");
INSERT INTO wuv_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","A'a minaa ei bigi'au una fama'aa hamu'ou ba fei mau bigifawe'ia ale'ei onei bigifawe'i ba o'aa hadumaa ei lomi rona faufau ma nonominaa ei wareaa mei Fasu Jesus: ‘Fei ba o fani i muainaa fei ba o to.’” ");
INSERT INTO wuv_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","I waredigaa fei, na fa'unaa du'una fipui a'a minaa ro'ou ma lafulafu. ");
INSERT INTO wuv_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","37","Ronamina ai ei ro'ei hapiroro'ia ma hatofaa manufina. ");
INSERT INTO wuv_vpl VALUES ("AC20_38","074_20_38","ACT","20","38","38","Fei namina fafaloloa'inaa ro'odu, sifei wareana ba pa'aa lomi rowe fanunudinaa pudana. Ma rona talaisusuninia a'a fei baua wa. ");
INSERT INTO wuv_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","Hai'ou'aa di'inidigaa ro'ou, hai'ouna ala ma tamafawanewanenaloo Cos. I arewadiai, hai'ouna aununaa Rhodes ma yei hai'ouna aununaa Patara. ");
INSERT INTO wuv_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","Hai'ouna labagipa'i hepalo baua wa ba i dinaa Phoenicia. Hai'ouna hugi ma tama'aunu. ");
INSERT INTO wuv_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","Hai'ou'aa fanunupa'aa Cyprus, fataledi'ininaloo fipepei ama'analoo puna ma hai'ouna tamanaloo Syria. Hai'ouna pe'i yei Tyre ba hai'ouree fa'asi'anaa ei manumanu pafona. ");
INSERT INTO wuv_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","Hai'ou'aa labagipa'aa ei otalai nenera yei, hai'ouna gutafipui a'a ro'ou oloromeai arewaa. Fei Spiriti na bigi naranaraa ro'ou ma rona ware a'a Paul ba nei'aa dinaa Jerusalem. ");
INSERT INTO wuv_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","Ma'uaa i nopa'aloo fei au ba hai'ou aunu, hai'ouna aunu ba hai'ou tamadilao. Minaa ei otalai nenera ma ei haroo ro'ou mawe ei na'uu ro'odu, rona talaisusuninaa hai'ou di'ininaa fei baua gufu ma yei piye, hai'ouna unaa du'uu hai'ou ma lafulafu. ");
INSERT INTO wuv_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","Hai'ou'aa rapudigaa panii ro'ou, hai'ouna hugi a'a fei baua wa ma ro'ou, rona wanonaa gufuu ro'ou. ");
INSERT INTO wuv_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","Hai'ouna tamadi'ininaa Tyre ma re pe'i yei Ptolemais. Ma hai'ouna bapa'aa ei lofu ma gutafipui a'a ro'ou heai arewaa. ");
INSERT INTO wuv_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","I arewadiai, hai'ouna dinaa Caesarea ma guta humuu Philip, mei ina'o wareaa fei rawani'a wareaa mei Fasu ma hia hemea ei Oloromea. ");
INSERT INTO wuv_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","Ina pa'i gunaroa na'una pifine rotaa haroa ma rona'aida diware'augaa ei ba i nomai nene. ");
INSERT INTO wuv_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","Hai'ou'aa gutadii hefi'adiai arewaa, hemea mamama'a, harana Agabus, noranamai Judea. ");
INSERT INTO wuv_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","I'a nomai a'a hai'ou, na faugaa panina ma pinena a'a fei adii Paul ma ware, “Fei Spiriti Apuna na ware, ‘Ana ale'eni, ei Jew yei Jerusalem, rowe faugaa mei amaa feni adi ma rowe fifaninaa hia panii ei Gentile.’” ");
INSERT INTO wuv_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","Hai'ou'aa guainia, hai'ou ma ei rama'a yei, hai'ouna ware'ai'ai a'a Paul ba inei'aa dinaa Jerusalem. ");
INSERT INTO wuv_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","Ma Paul na ware, “Tani hamu'ou ai'ai ma fawagu'uaa ha'eu? Lomi manumanu a'au nabaa ro'aa faugau ma ana na rawani a'au nabaa a ma'e yei Jerusalem uaa fei haraa mei Fasu Jesus.” ");
INSERT INTO wuv_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","Lomi hai'ouna filogipa'aa fei naranarana ma si'ei hai'ouna ware, “Inei nomai fei nunumiaa mei Fasu.” ");
INSERT INTO wuv_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","Nenee fei, hai'ouna paiaa ei manumanuu hai'ou ma aununaa Jerusalem. ");
INSERT INTO wuv_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","Hefi'a ei otalai nenera yei Caesarea, rona nohugiaa hai'ou ma noduginaa hai'ou humuu Mnason ma hai'ouna guta a'ana. Noramiana Cyprus ma hia hemea rawarawa otalai nenera. ");
INSERT INTO wuv_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","Hai'ou'aa maua yei Jerusalem, ei lofu, rona taufagutanaa hai'ou. ");
INSERT INTO wuv_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","Heaidiai arewaa Paul ma minaa hai'ou, hai'ouna aunu ba hai'ouree ma'a James. Ma minaa ei bauaniaa losuu, ro'ou, yei. ");
INSERT INTO wuv_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","Paul na famafufuoinaa ro'ou ma warefa'aiaa ro'ou minaa ei manumanu na bigi'ia a'a ei Gentile mei Haidaa wagii fei bigi'ana. ");
INSERT INTO wuv_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","Ro'aa guainia, rona uduginaa mei Haidaa. Ma rona warenaa a'a Paul, “Mena lofuu hai'ou, ma'aia watauda pufaba'a Jew rona narafawe'i ma refu unuu minaa ro'ou a'a fei law. ");
INSERT INTO wuv_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","Rona guainia ba yoi, ona feroinaa ei Jew, ei rona guta inamoaa ei Gentile ba ronei ofadugaa Moses ma ronei'aa moro'aa hudii wawanei ei na'uu ro'odu, o neneraa ei maumau o'odu. ");
INSERT INTO wuv_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","O bigi'aa tamanu? Te, ana rowepa'aa guainia ba yoi na nodigimai. ");
INSERT INTO wuv_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","23","Si'ei, bigi'aa tamanu hai'ouna warefanio. Na pa'i gunaroa wawane a'a hai'ou, ei ronadii fa'unai a'a mei Fasu ba ropa'aa bigi'aa hepalo manumanu. ");
INSERT INTO wuv_vpl VALUES ("AC21_24","074_21_24","ACT","21","24","24","Dugaa eni rama'a eni ma a'a ro'ou, onei bigi'aa fei maumau ro'ou, fei ba ro'aa fafafa'arai i pudaa mei Fasu ma onei fani pono'aa ro'ou ba ro'aa sisigaa hugoo tabaa ro'ou. Ma minaa ei rama'a, rowe aida ba na tata fei u'uga, fei ro'aa u'ugio ma rowe aida ba yoi na neneraa fei law. ");
INSERT INTO wuv_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","Ma hai'ouna ne'idii a'a ei Gentile narafawe'ia ba ronei'aa hana du'ua hefi'a rona faninaa a'a ei haidaa sifisifi, o hunu namo, o hanaiaa pigio ei manulelele, ei rona guafifigia, o fitatafipa'ai.” ");
INSERT INTO wuv_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","Heaidiai arewaa, Paul na dugaa ei rama'a ma fafafa'arainaa anaia mawe ro'ou, ale'ei mau losuu ro'ou. Ma ina wadu'ainaa fei humuu mei Haidaa ba i warefa'aiaa ro'ou tamanu arewaa iwe pedu ei arewaa fafa'araia ma nahaiga ro'aa fani fanaa hememea ro'ou. ");
INSERT INTO wuv_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","27","Ba anaa i pedu ei oloromeai arewaa, hefi'a ei Jew noramiaa ro'ou i laloo Asia, rona fanunupa'aa Paul yei a'a fei humuu mei Haidaa. Rona fawesuaa iaa minaa ei rama'a ma rona panarofia. ");
INSERT INTO wuv_vpl VALUES ("AC21_28","074_21_28","ACT","21","28","28","Rona pararai, “Ena Israel hamonei hadumaa hai'odu! Meni rama'a meni, hia mei na feroinaa minaa ei rama'a i tadiwe'aia ma faweleni ba ronei fadugeaa o'odu, fei law o'ou. Ma ana, ina dugifawadu'ainamii ei Greece malalaa fei humuu mei Haidaa ma rona faloloaa faweleni na apunai.” ");
INSERT INTO wuv_vpl VALUES ("AC21_29","074_21_29","ACT","21","29","29","(Ronado'o fanunupa'aa Trophimus, mei Ephesus, a'a Paul i a'a fei baua gufu ma rona nara ba Paul na nodugia ma wadu'ainaa malalaa fei humuu Haidaa.) ");
INSERT INTO wuv_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","Minaa ei rama'aa fei gufu, rona siba'asi'aa ma ponimai a'a minaa ei tala. Rona panarofaa Paul ma foraneneneinia auguu fei humuu mei Haidaa. Ma ana ei ua rona fare'aa ei baua gigei. ");
INSERT INTO wuv_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","31","Ei ro'ei panarofia ma nananara ba ro'aa fama'eia, mei bauaniaa ei fo'aa Rome na guainia ba minaa ei rama'aa Jerusalem, namina bibiyei tabaa ro'ou. ");
INSERT INTO wuv_vpl VALUES ("AC21_32","074_21_32","ACT","21","32","32","Ina dugibatafainaa hefi'a fo'aa ma hefi'a bauaniaa ro'ou ma rona poninaa a'a ei rama'a. Ro'aa fanunupa'aa ei fo'aa mawe mei bauaniaa ro'ou, ei rama'a na fapedugaa fei hafugaa ro'ou Paul. ");
INSERT INTO wuv_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","Mei bauaniaa fo'aa na nomai, panarofia ma warenaa a'a ro'ou ba ronei faugia a'a guapalo alatai. Ma ina i'iginaa ro'ou ba hia hini ma na bigi'aa tamanu. ");
INSERT INTO wuv_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","Hefi'a ei, rona haroharo ba ale'ei ma hefi'a ba ale'ei. Ma mei bauana, lomi na topa'aa fafasui fei, uaa ronamina waigi. Ma si'ei, ina ware ba ronei duginaa hia humuu ei fo'aa. ");
INSERT INTO wuv_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","35","Paul, i nopa'aloo fei e'ea, fei gupuu rama'a ronamina sibafafelo ma ronawe poro'uaia ei fo'aa. ");
INSERT INTO wuv_vpl VALUES ("AC21_36","074_21_36","ACT","21","36","36","Fei gupuu rama'a, rona nenegia ma memewai, “Fo'afama'eia!” ");
INSERT INTO wuv_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","37","Ei fo'aa ba ana ro'aa wadu'ainoduginaa Paul a'a fei humu fo'aa, ina i'iginaa mei bauaniaa fo'aa, “Na rawani ba a i'iginio hepalo manumanu?” Ina ware, “Ona'aida warea Greece? ");
INSERT INTO wuv_vpl VALUES ("AC21_38","074_21_38","ACT","21","38","38","Woro ba yoi mei Egypt, mei mina ma'ida na fa'asi'anaa fei fisibaia ma augaa poree gunaroa pufaba'a rama'a hafelo ma dinaa yei fawelei lomi haihai ma guana.” ");
INSERT INTO wuv_vpl VALUES ("AC21_39","074_21_39","ACT","21","39","39","Ina ware Paul, “Yau hemea Jew noramiau Tarsus yei Cilicia. Yau hemea rama'aa hepalo baua rawani'a gufu. Na rawani ba a warenaa a'a ei rama'a?” ");
INSERT INTO wuv_vpl VALUES ("AC21_40","074_21_40","ACT","21","40","40","I ugadii mei bauaniaa fo'aa, Paul na ufalarai pafoo fei e'ea ma pi'inaa panina a'a ei rama'a. Ro'aa babanini, ina warenaa warea Aramea a'a ro'ou: ");
INSERT INTO wuv_vpl VALUES ("AC22_1","074_22_1","ACT","22","1","1","“Ena lofuu ma ena amau, hamonei guainaa fei wareau ba a alarau.” ");
INSERT INTO wuv_vpl VALUES ("AC22_2","074_22_2","ACT","22","2","2","Ro'aa guainia ba ina warenaa warea Aramea a'a ro'ou, ronamina babanini. Ma na ware Paul, ");
INSERT INTO wuv_vpl VALUES ("AC22_3","074_22_3","ACT","22","3","3","“Yau hemea Jew, waniniau Tarsus yei Cilicia, ma'uaa gipeau yeni a'a feni baua gufu feni. Gamaliel na feroifarawaninau a'a fei law ei amaa o'ou ma na pasirefurefu unuu a'a mei Haidaa ana ale'ei minaa hamu'ou wagieni. ");
INSERT INTO wuv_vpl VALUES ("AC22_4","074_22_4","ACT","22","4","4","Una fo'afama'e ma haperaraiaa ei rona neneraa fei Tala. Na panarofaa ei wawane ma pifine ma bobo'ainaa ro'ou ");
INSERT INTO wuv_vpl VALUES ("AC22_5","074_22_5","ACT","22","5","5","ma mei pa'aa bauaniaa humuu mei Haidaa ma minaa ei bauaniaa gufu ro'aa warefanaa hamu'ou ba pa'aa fa'ua fei. Ma una tonaa ne'iaa ro'odu ba a fanaa ei lofuu ro'odu yei Damascus ma aununaa yei ba a panarofaa ei rama'a ma duginamii ro'ou yeni Jerusalem ba hai'ou'aa fanima'aa ro'ou. ");
INSERT INTO wuv_vpl VALUES ("AC22_6","074_22_6","ACT","22","6","6","“Ale'ei haloaina una nofarafi'ilao Damascus, ana ei ua, hepalo we'aia noranarai pafea namina we'afaweloinau. ");
INSERT INTO wuv_vpl VALUES ("AC22_7","074_22_7","ACT","22","7","7","Una pasinaa pu ma guainaa fei lao na warenaa a'au, ‘Saul! Saul! Tani o haperaraiau?’ ");
INSERT INTO wuv_vpl VALUES ("AC22_8","074_22_8","ACT","22","8","8","“Ma una i'igai, ‘Yoi hini, mena Fasu?’ “Ina ware, ‘Yau Jesus, mei Nazareth, mei ona haperaraia.’ ");
INSERT INTO wuv_vpl VALUES ("AC22_9","074_22_9","ACT","22","9","9","Ei ro'ou a'au, rona fanunupa'aa fei we'ai, ma'uaa lomi rona guai'apa'aa fei lao mei na warenaa a'au. ");
INSERT INTO wuv_vpl VALUES ("AC22_10","074_22_10","ACT","22","10","10","“Una i'igai, ‘Una fetanai e'eni, mena Fasu?’ “Ma ina ware, ‘Asi'aa ma dinaa Damascus. Hefi'a yei, rowe warefanio minaa ei i fanio mei Haidaa ba onei bigi'ia.’ ");
INSERT INTO wuv_vpl VALUES ("AC22_11","074_22_11","ACT","22","11","11","Ei tafiu, rona tauaa paniu ma noduginaa yau Damascus uaa una pudawerai a'a fei we'ai. ");
INSERT INTO wuv_vpl VALUES ("AC22_12","074_22_12","ACT","22","12","12","“Hemea rama'a harana Ananias na nomai a'au. Hia, namina neneraa fei law ma na rawani i pudaa minaa ei Jew rona guta yei. ");
INSERT INTO wuv_vpl VALUES ("AC22_13","074_22_13","ACT","22","13","13","Inamii u papau ma ware, ‘Mena lofuu Saul, onei fanunudiai!’ Ana ei ma una fanunupa'ia. ");
INSERT INTO wuv_vpl VALUES ("AC22_14","074_22_14","ACT","22","14","14","“Ma ina ware: ‘Mei Haidaniaa ei amaa o'ou nadii rafeinio ba onei aida ei nunumiana ma fanunu'apa'aa mei Wanewanea ba onei guainaa ei wareaa umuna. ");
INSERT INTO wuv_vpl VALUES ("AC22_15","074_22_15","ACT","22","15","15","Yoi o u'ufa'uainaa tamanu ona fanunuia ma guainia a'a minaa ei rama'a. ");
INSERT INTO wuv_vpl VALUES ("AC22_16","074_22_16","ACT","22","16","16","Ma oi oma'aa tamanu eni? Asi'aa. Lala'aa fei harana; pudugufai ma fesuaa ei hafelo'amu.’ ");
INSERT INTO wuv_vpl VALUES ("AC22_17","074_22_17","ACT","22","17","17","“A hadiwe'inaa Jerusalem ma lafulafu i laloo humuu mei Haidaa ma ale'ei una mefi ");
INSERT INTO wuv_vpl VALUES ("AC22_18","074_22_18","ACT","22","18","18","ma fanunupa'aa mei Fasu na ware ba, ‘Batafa! Di'ininaa Jerusalem e'eni, uaa lomi ba ro'aa nunuminaa fei u'ugau, fei ba o u'ufanaa ro'ou.’ ");
INSERT INTO wuv_vpl VALUES ("AC22_19","074_22_19","ACT","22","19","19","“Una ware, ‘Mena Fasu, eni rama'a eni, rona aida ba yau, na dinaa a'a hepapalo synagogue ba a bobo'ai ma hafugaa hini ei rona narafawe'i a'amu. ");
INSERT INTO wuv_vpl VALUES ("AC22_20","074_22_20","ACT","22","20","20","Ma ei i wigii namoo Stephen, mei na ma'e a'a fei haramu, yau yei ma ana na ugainia ma na oma'aa ei susuu ei rona fo'afama'eia.’ ");
INSERT INTO wuv_vpl VALUES ("AC22_21","074_22_21","ACT","22","21","21","“Ma mei Fasu na warenaa a'au, ‘Nowau; Yau a alofarauaninio i a'a ei Gentile.’” ");
INSERT INTO wuv_vpl VALUES ("AC22_22","074_22_22","ACT","22","22","22","Ei rama'a rona guainaa fei u'ugaa Paul ma'uaa ei i wareaa fei, rona haropararai, “Farauaninia a'a feni ano! Inei'aa gutadimai!” ");
INSERT INTO wuv_vpl VALUES ("AC22_23","074_22_23","ACT","22","23","23","Ro'ei memewai ma siminaa lawalawaa ro'ou ma fapepe'aiaa ei pora ");
INSERT INTO wuv_vpl VALUES ("AC22_24","074_22_24","ACT","22","24","24","ma mei bauaniaa fo'aa na ware ba ronei noduginaa Paul yei laloo humuu ei fo'aa. Ina ware ba ronei babuinia ma i'iginia ba tani ro'aa sibamemewai a'ana ei rama'a. ");
INSERT INTO wuv_vpl VALUES ("AC22_25","074_22_25","ACT","22","25","25","Ro'aa fahainofolaginia ba ro'aa babuinia, Paul na i'iginaa mei centurion ba, “Na rawani a'a fei law nabaa o babuinaa hemea rama'aa Rome, hemea rotaa dududuia?” ");
INSERT INTO wuv_vpl VALUES ("AC22_26","074_22_26","ACT","22","26","26","I guainaa fei mei centurion, na dinaa a'a mei bauaniaa ei fo'aa ma na warefania, “O bigi'aa tamanu a'a feni. Uaa mei rama'a mei, hia rama'aa Rome.” ");
INSERT INTO wuv_vpl VALUES ("AC22_27","074_22_27","ACT","22","27","27","Mei bauaniaa fo'aa na dinaa a'a Paul ma i'iginia, “Ware fanau, yoi pa'aa rama'aa Rome?” Ina ware, “Hi'i. Fa'ua.” ");
INSERT INTO wuv_vpl VALUES ("AC22_28","074_22_28","ACT","22","28","28","Ma mei bauaniaa fo'aa na ware, “Yau, una siminaa watauda mugoo po'i ba yau hemea rama'aa Rome.” Paul na ware, “Ma'uaa yau, waniniau Rome.” ");
INSERT INTO wuv_vpl VALUES ("AC22_29","074_22_29","ACT","22","29","29","Ma ei ba ro'aa i'iginia ronawe u'ua. Ma mei bauaniaa fo'aa ana na ma'au uaa na aida ba ina faugaa Paul a'a ei alatai, hemea rama'aa Rome. ");
INSERT INTO wuv_vpl VALUES ("AC22_30","074_22_30","ACT","22","30","30","I arewadiai, si'ei ba mei bauaniaa fo'aa ba ipa'aa labaginia ba tani ro'aa ware ei Jew ba na tata Paul. Ina alagia ma ware a'a ei famamoaa humuu mei Haidaa mawe ei bauaniaa gufu ba ronei papa'ifipuimai. Ma ina dugamii Paul ma fa'ufalarainia pudaa ro'ou. ");
INSERT INTO wuv_vpl VALUES ("AC23_1","074_23_1","ACT","23","1","1","Paul na fanunufawanewanenaa a'a ei bauaniaa gufu ma ware, “Ena lofuu, una bigifarawani ua i pudaa mei Haidaa ma na nanamuinia ba lomi tatau nopa'amii wagieni.” ");
INSERT INTO wuv_vpl VALUES ("AC23_2","074_23_2","ACT","23","2","2","A'a fei wareana fei, mei pa'aa bauaniaa humuu mei Haidaa, Ananias na warenaa a'a ei rona u papaa Paul ba ronei hafugaa umuna. ");
INSERT INTO wuv_vpl VALUES ("AC23_3","074_23_3","ACT","23","3","3","Ma Paul na warenaa a'ana, “Mei Haidaa iwe hafugio, yoi mena ware'oni! Ona guta yena ba o dududuau a'a fei law, ma'uaa ana yoi na barafeaa fei law uaa ona ware ba ronei hafugau!” ");
INSERT INTO wuv_vpl VALUES ("AC23_4","074_23_4","ACT","23","4","4","Ei ro'aa u papaa Paul, rona ware, “Haa? Ba o warefafeloaa mei pa'aa bauaniaa humuu mei Haidaa, mei na rafeinia mei Haidaa?” ");
INSERT INTO wuv_vpl VALUES ("AC23_5","074_23_5","ACT","23","5","5","Paul na ware, “Ena lofuu, lomi una aida ba hia, mei pa'aa bauaniaa humuu mei Haidaa, uaa na ude fei ne'ia ba, ‘Apuna warefafeloaa hemea bauaniaa gufuu hamu'odu.’” ");
INSERT INTO wuv_vpl VALUES ("AC23_6","074_23_6","ACT","23","6","6","Ma Paul na aida ba hefi'a ro'ou, maroaa ei Sadducee ma hefi'a ro'ou, maroaa ei Pharisee ma na haronaloo a'a ei bauaniaa gufu, “Ena lofuu, yau hemea Pharisee, ana yau na'uu ei Pharisee. Ma pa'afii fei ba una ufalarai a'a feni dududua, sifei ba na o'onai unuu ba ei ma'ea, rowe asi'aa.” ");
INSERT INTO wuv_vpl VALUES ("AC23_7","074_23_7","ACT","23","7","7","I wareaa fei, ei Pharisee ma ei Sadducee, rona fiharenii ma na guapaloi naranaraa ro'ou. ");
INSERT INTO wuv_vpl VALUES ("AC23_8","074_23_8","ACT","23","8","8","(Ei Sadducee rona ware ba ei ma'ea lo'e ba ro'aa asi'aa ma ba ana lomi na pa'i alo'alo o spiriti, ma'uaa ei Pharisee rona ware ba na pa'i e'ei manumanu e'ei.) ");
INSERT INTO wuv_vpl VALUES ("AC23_9","074_23_9","ACT","23","9","9","Inawemina bauana fei fisibaiaa ro'ou. Ma hefi'a ei feroiaa law, hefi'a Pharisee, rona ufalarai ma warefawe'i, “Lomi ba hai'ouna labagipa'aa hepalo tataa meni rama'a meni. Tani na'aa po'o hefaa spiriti o alo'alo na warenaa a'ana?” ");
INSERT INTO wuv_vpl VALUES ("AC23_10","074_23_10","ACT","23","10","10","Fei fiwareiaa ro'ou nawemina babaifafelo ma mei bauaniaa fo'aa na naranara ba ropowemina fagianainaa Paul. Ina warenaa a'a ei fo'aa ba ronei upulao ma rapuforaiamii Paul ma wadu'ainodugia laloo fei humuu ei fo'aa. ");
INSERT INTO wuv_vpl VALUES ("AC23_11","074_23_11","ACT","23","11","11","Iree poidiai, mei Fasu na ufalarai papaa Paul ma ware, “Onei laugu'ai! Ana ale'ei o u'ugau yei Jerusalem, ana onei u'ugau yeni Rome.” ");
INSERT INTO wuv_vpl VALUES ("AC23_12","074_23_12","ACT","23","12","12","I mafufuoilao, ei Jew rona fiwarei ma fa'unai ba pa'aa lomi ba rowe hanana o hunu hawina rona fo'afama'eaa Paul. ");
INSERT INTO wuv_vpl VALUES ("AC23_13","074_23_13","ACT","23","13","13","Puduu ei rama'a ei, na muainaa gunaroa pa'ania. ");
INSERT INTO wuv_vpl VALUES ("AC23_14","074_23_14","ACT","23","14","14","Rona dinaa a'a ei famamoaa humuu mei Haidaa ma ei bauaniaa gufu ma ware, “Hai'ouna fa'unaidii ba pa'aa lomi ba hai'ou'aa hanaiaa hepalo manumanu hawina hai'ouna fo'afama'eaa Paul. ");
INSERT INTO wuv_vpl VALUES ("AC23_15","074_23_15","ACT","23","15","15","Si'ei, hamu'ou ma ei bauaniaa gufu, hamonei i'igifasifi a'a mei bauaniaa fo'aa ba ronei dugiamai a'a hamu'ou ba hamo'aa tofarawani fafasuii feni dududuana. Ma hai'ouna ofafaufaudii ba hai'ou'aa fo'afama'eia ena rona nomai.” ");
INSERT INTO wuv_vpl VALUES ("AC23_16","074_23_16","ACT","23","16","16","Ma'uaa i guainia mei na'uu mei agii Paul, ina wadu'ainaa fei humuu ei fo'aa ma warefanaa Paul. ");
INSERT INTO wuv_vpl VALUES ("AC23_17","074_23_17","ACT","23","17","17","Ma Paul na harofaa mei centurion ma ware, “Dugawii meni baubara a'a mei bauaniaa fo'aa. Na pa'i hepalo manumanu ba i warefania.” ");
INSERT INTO wuv_vpl VALUES ("AC23_18","074_23_18","ACT","23","18","18","Si'ei, ina nodugia dinaa a'a mei bauaniaa fo'aa. Mei fo'aa na ware, “Paul, mei bobo'aia, na lala'au ma ware a'au ba unei dugamii meni baubara a'amu, uaa ina pa'i manumanu ba u'ufanio.” ");
INSERT INTO wuv_vpl VALUES ("AC23_19","074_23_19","ACT","23","19","19","Mei bauaniaa fo'aa na tauaa panii mei baubara, dugia ma i'iginia, “Tamanu fei ba o warefanau?” ");
INSERT INTO wuv_vpl VALUES ("AC23_20","074_23_20","ACT","23","20","20","Ina ware: “Ei Jew na fiwarewarei ba ro'aa sifi'io ma i'iginio ba onei dugaloo Paul i pudaa ei bauaniaa gufu narani ba ro'aa tofarawani fafasuii fei dududuana. ");
INSERT INTO wuv_vpl VALUES ("AC23_21","074_23_21","ACT","23","21","21","Onei'aa ugainaa ro'ou, uaa puduu ro'ou na muainaa gunaroa pa'ania ma ro'ei opa'ai eni ba ro'aa panarofia. Rona fa'unaidii ba pa'aa lomi ba ro hanana o hunu hawina rona fo'afama'eia. Rona ofafaufaudii ma roi oma'aa fei ba o'aa ugainaa fei i'igaiaa ro'ou.” ");
INSERT INTO wuv_vpl VALUES ("AC23_22","074_23_22","ACT","23","22","22","Mei bauaniaa fo'aa na aloaa mei baubara ma warefawe'i a'ana, “Apuna warefanaa nemea ba ona warefanau feni.” ");
INSERT INTO wuv_vpl VALUES ("AC23_23","074_23_23","ACT","23","23","23","Ma ina lala'aa helagui centurion ma ware a'a lagua, “Harofaa enu pu'u fo'aa rona talainaa pinee ro'ou ma oloromfua pa'aniadiai pafoo manulelele ma enu pu'udiai panarofaa hio ba ronei dinaa Caesarea poi wagieni ale'ei faimheai ido'o. ");
INSERT INTO wuv_vpl VALUES ("AC23_24","074_23_24","ACT","23","24","24","Fani tawaa Paul manulelele ma oma'afarawaninia dinaa a'a Gavanaa Felix.” ");
INSERT INTO wuv_vpl VALUES ("AC23_25","074_23_25","ACT","23","25","25","Ma ina ne'i'aloaa feni: ");
INSERT INTO wuv_vpl VALUES ("AC23_26","074_23_26","ACT","23","26","26","Yau Claudius Lysias. Ma una ne'inaa feni a'a mei Rawani'a, Gavanaa Felix: Hagu'u. ");
INSERT INTO wuv_vpl VALUES ("AC23_27","074_23_27","ACT","23","27","27","Meni rama'a meni, ei Jew, rona panarofia ma ana ba ro'aa fo'afama'eia, ma'uaa una nofipuimai a'a ei maroau fo'aa ma hai'ouna alagia, uaa una guainia ba hia rama'aa Rome. ");
INSERT INTO wuv_vpl VALUES ("AC23_28","074_23_28","ACT","23","28","28","Una nara ba unei tofarawaninaa fafasuina ba tani ro'aa ware ba ina bigifatata, si'ei una nodugalao a'a ei bauaniaa gufu. ");
INSERT INTO wuv_vpl VALUES ("AC23_29","074_23_29","ACT","23","29","29","Unawe fanunu'apa'ia ba fei wareaa ro'ou ba ina bigifatata, manumanu a'a fei law ro'odu. Ma'uaa lomi ba na bigi'aa hepalo tata ba nei ma'e, o unei bobo'ainia. ");
INSERT INTO wuv_vpl VALUES ("AC23_30","074_23_30","ACT","23","30","30","Ma a guainia ba rona ware'opa'ai ba ro'aa fo'afama'eia, una alobatafanamai a'amu. Ma ana na warefanaa ei rona ware ba hia na tata, ba ronei u'ufanio tamanu ei tatana. ");
INSERT INTO wuv_vpl VALUES ("AC23_31","074_23_31","ACT","23","31","31","Si'ei, ei fo'aa, rona bigi'aa fei wareaa mei bauaniaa ro'ou ma nodugaa Paul poi ma aunu nopa'aloo Antipatris. ");
INSERT INTO wuv_vpl VALUES ("AC23_32","074_23_32","ACT","23","32","32","Heaidiai arewaa rona aloia a'a ei fo'aa pafoo manulelele ma ro'ou, rona hadiwe'idinaa fei humuu fo'aa. ");
INSERT INTO wuv_vpl VALUES ("AC23_33","074_23_33","ACT","23","33","33","Ro'aa nopa'aloo Caesarea ei fo'aa pafoo manulelele, rona fanaa fei ne'ia a'a mei Gavanaa ma fifaninia panina. ");
INSERT INTO wuv_vpl VALUES ("AC23_34","074_23_34","ACT","23","34","34","Mei Gavanaa na igoaa fei ne'ia ma i'igai ba noranamai hitani gufu. I guainia ba noranamai Cilicia, ina ware, ");
INSERT INTO wuv_vpl VALUES ("AC23_35","074_23_35","ACT","23","35","35","“Awe guainaa fena dududuamu rona nomai yeni ena ro'aa dududuio.” Ma ina ware ba ronei augaa Paul laloo fei humuu Herod, fei humuu hapara ma oma'afarawaninia. ");
INSERT INTO wuv_vpl VALUES ("AC24_1","074_24_1","ACT","24","1","1","Haipanidiai arewaa mei pa'aa bauaniaa humuu mei Haidaa, Ananias na dinaa Caesarea fipui a'a hefi'a bauaniaa fei gufu ma hemea rama'aa law harana Tertullus ma rona dududuaa Paul i pudaa mei gavanaa. ");
INSERT INTO wuv_vpl VALUES ("AC24_2","074_24_2","ACT","24","2","2","Rona lala'aa Paul ba nei wadu'aimai ma Tertullus na dududuia a'a Felix: “Hai'ouna gutafamalaa ma gutafarawani ua i haroo iamu. Ma fei apa'amu na fawanewaneaa watauda manumanu i laloo feni baua gufu feni. ");
INSERT INTO wuv_vpl VALUES ("AC24_3","074_24_3","ACT","24","3","3","Naranaraa hai'ou ma minaa ei gufu tadiwe'ai, hepalo ua ba yoi hemea pa'aa rawani'a rama'a Felix ma hai'ounamina ni'eni'e a'amu. ");
INSERT INTO wuv_vpl VALUES ("AC24_4","074_24_4","ACT","24","4","4","Ma'uaa lo'e ba hai'oumina fatarereio, si'ei hai'ou'aa i'iginio ba na rawani ba odo'o guainaa ma'ida wareaa hai'odu wagii tamanu ei tataa Paul? ");
INSERT INTO wuv_vpl VALUES ("AC24_5","074_24_5","ACT","24","5","5","“Hai'ouna fanunupa'ia ba meni rama'a meni na fa'asi'anaa hefi'a hafelo'a ma na fawesuaa iaa ei Jew tadiwe'aiaa minaa feni ano. Hia mei bauaniaa fei maroaa fei losuu ei Nazarene ");
INSERT INTO wuv_vpl VALUES ("AC24_6","074_24_6","ACT","24","6","6","ma ana na mania ba i faloloaa fei humuu mei Haidaa. Si'ei, hai'ouna panarofia. ");
INSERT INTO wuv_vpl VALUES ("AC24_8","074_24_8","ACT","24","8","8","Nabaa ana yoi, o'aa i'iginia, o'aa labagipa'aa fei fafasuii ei warea hai'ouna dududuia wagina.” ");
INSERT INTO wuv_vpl VALUES ("AC24_9","074_24_9","ACT","24","9","9","Ei Jew ana rona ware ba ina bigifatata ma ware ba fa'ua ei manumanu ei. ");
INSERT INTO wuv_vpl VALUES ("AC24_10","074_24_10","ACT","24","10","10","I pi'inaa panina mei gavanaa ba nei ware, na ware Paul, “Una aida ba laloo watauda igisimasi, yoi hemea fadududua a'a feni gufu feni. Si'ei, una ni'eni'e ba a wareaa pepei a'au. ");
INSERT INTO wuv_vpl VALUES ("AC24_11","074_24_11","ACT","24","11","11","Na maduta ua nabaa o labaginia ba na fa'ua fei wareau, fei ba laloo hefua ma guai arewaa ididii, una dinaa Jerusalem ba a losui. ");
INSERT INTO wuv_vpl VALUES ("AC24_12","074_24_12","ACT","24","12","12","E'ei rona ware ba una bigifatata, lomi rona guainau una fiharenii a'a hemea i humuu mei Haidaa, o fawesuaa iaa rama'a laloo ei synagogue, o hitani laloo fei baua gufu yei. ");
INSERT INTO wuv_vpl VALUES ("AC24_13","074_24_13","ACT","24","13","13","Ma lomi rona fa'arewapa'ia a'amu ba una tata. ");
INSERT INTO wuv_vpl VALUES ("AC24_14","074_24_14","ACT","24","14","14","Ma'uaa fa'ua ba una'aida losuinaa mei Haidaniaa ei amaa hai'ou, uaa una neneraa fei maroaa fei Tala, fei rona wareia ba na tata. Ma una neneraa minaa ei manumanu laloo fei Law ma tamanu rona ne'inia ei mamama'a. ");
INSERT INTO wuv_vpl VALUES ("AC24_15","074_24_15","ACT","24","15","15","Ma ana na pa'i o'onaia unuu a'a mei Haidaa ana ale'ei eni rama'a eni ba iwe fa'asi'anaa ei ma'ea, ei rona wanewane ma ei rona hafelo. ");
INSERT INTO wuv_vpl VALUES ("AC24_16","074_24_16","ACT","24","16","16","Si'ei, ranimai una'o fanima'aia ba i pudaa mei Haidaa mawe ei rama'a, pa'aa lomi i marapu ei naranarau. ");
INSERT INTO wuv_vpl VALUES ("AC24_17","074_24_17","ACT","24","17","17","“Nene ale'ei hefiga igisimasi, lomi una guta yei Jerusalem, unawe nomai ba a fani fana a'a ei gufuu ba ronei fanaa ei lomi rona pa'i ma ba a fani fanau a'a mei Fasu. ");
INSERT INTO wuv_vpl VALUES ("AC24_18","074_24_18","ACT","24","18","18","A bigi'aa fei ma ro'aa fanunupa'au i malalaa fei humuu mei Haidaa, a'a ba una loloa a'a fei maumau ba hai'ounei fafa'arai. Lomi ba na pa'i watauda rama'a a'au ma ana lomi ba una bigi'aa manumanu na fafeloaa ei rama'a. ");
INSERT INTO wuv_vpl VALUES ("AC24_19","074_24_19","ACT","24","19","19","Ma'uaa na pa'i hefi'a Jew noramiaa ro'ou Asia ma na rawani ba ronei nomai yeni i ma'amu ma nabaa una bigifatata, te, ronei wareia. ");
INSERT INTO wuv_vpl VALUES ("AC24_20","074_24_20","ACT","24","20","20","O eni, ro'ou yeni, ronei wareaa tamanu fei tatau rona labagipa'ia ei a u i ma'aa ei bauaniaa gufu. ");
INSERT INTO wuv_vpl VALUES ("AC24_21","074_24_21","ACT","24","21","21","Narau ba sifeni. Ei a ufalarai i ma'aa ro'ou, una haroharo ba: ‘Fei fafasui fei ba hamo'aa dududuau wagieni, sifei ba una nara ba i pa'i asi'ana a'a fei ma'ea.’” ");
INSERT INTO wuv_vpl VALUES ("AC24_22","074_24_22","ACT","24","22","22","Ma Felix, hemei na apa'ifarawaninaa fei Tala, na do'o ba'ofaa fei dududua. Ma na ware, “Ena na nomai Lysias, mei bauaniaa fo'aa, u'apowe dududuio.” ");
INSERT INTO wuv_vpl VALUES ("AC24_23","074_24_23","ACT","24","23","23","Ina ware a'a hemea centurion ba nei oma'afarawaninaa Paul, ma'uaa inei fatalainia ma'ida ma nei'o fanoramiaa ei tafina mi roiana. ");
INSERT INTO wuv_vpl VALUES ("AC24_24","074_24_24","ACT","24","24","24","Hefi'a arewaa ididii Felix na nofipuimai a'a mei harona Drusilla, hemea Jew. Ina lala'amii Paul ma na gutaguainia fi u'ugaa fei we'iaa naranara a'a Christ Jesus. ");
INSERT INTO wuv_vpl VALUES ("AC24_25","074_24_25","ACT","24","25","25","I no'u'upa'aloo tamanu na wanewane, batanai onei apitai ma batanai fei dududua iwe nomai, Felix na ma'au ma ware, “Do'o hi'ei e'eni! Nowau. Nabaa na pa'idiai rawani'a au, te awe lala'idinio.” ");
INSERT INTO wuv_vpl VALUES ("AC24_26","074_24_26","ACT","24","26","26","Ma ana ina nunuminia ba Paul nei fanipa'ai mugoo po'i a'ana, si'ei ina lala'i'uaiamai ranimai ma fiwarewarei a'ana. ");
INSERT INTO wuv_vpl VALUES ("AC24_27","074_24_27","ACT","24","27","27","I didii heguai igisimasi, na tonaa bigi'aa Felix meni Porcius Festus, ma'uaa Felix na nara ba ido'o farawaninaa ei Jew ma si'ei, lomi na alaraa Paul humuu bobo'aia. ");
INSERT INTO wuv_vpl VALUES ("AC25_1","074_25_1","ACT","25","1","1","I wadu'ainaa fei baua gufu Festus ma gutadii oduai arewaa, ina di'ininaa Caesarea ma na dinaa Jerusalem. ");
INSERT INTO wuv_vpl VALUES ("AC25_2","074_25_2","ACT","25","2","2","Ma yei, ei famamoaa humuu mei Haidaa mawe ei bauaniaa ei Jew, rona u i ma'ana ma wareaa ei tataa Paul. ");
INSERT INTO wuv_vpl VALUES ("AC25_3","074_25_3","ACT","25","3","3","Ronamina roroninaa Festus ba nei farawaninaa ro'ou ma alonaa Paul Jerusalem, uaa ronadii fiwarewarei ba ro'aa opa'ai ma fo'afama'eia i tala. ");
INSERT INTO wuv_vpl VALUES ("AC25_4","074_25_4","ACT","25","4","4","Festus na ware, “Paul yei humuu bobo'aia Caesarea. Ma lomi i madii ma a dinaa yei. ");
INSERT INTO wuv_vpl VALUES ("AC25_5","074_25_5","ACT","25","5","5","Aloaa hefi'a bauaniaa hamu'ou ba ronei aunufipuimai a'au ma dududuaa mei rama'a mei yei nabaa hia na bigifatataiaa hepalo manumanu.” ");
INSERT INTO wuv_vpl VALUES ("AC25_6","074_25_6","ACT","25","6","6","I gutadii a'a ro'ou ale'ei fainaroa o hefua arewaa, ina upu'aunulao yei Caesarea. Ma heaidiai arewaa na fa'asi'adinaa fei dududua ma warenaa a'a ro'ou ba ronei fa'ugaa Paul i ma'ana. ");
INSERT INTO wuv_vpl VALUES ("AC25_7","074_25_7","ACT","25","7","7","I nodigimai Paul, ei Jew, noramiaa ro'ou Jerusalem, rona ufaweloinia ma wareaa watauda manumanu namina raraba ba hia na bigifatata wagina. Ma lomi na pa'i ugaa pinee ro'ou. ");
INSERT INTO wuv_vpl VALUES ("AC25_8","074_25_8","ACT","25","8","8","Si'ei, Paul na ufalarai ma wareaa fipepei a'ana, “Lomi una bigi'aa he'a tata wagii fei law ei Jew, o a'a fei humuu mei Haidaa, o a'a Caesar.” ");
INSERT INTO wuv_vpl VALUES ("AC25_9","074_25_9","ACT","25","9","9","Nunumiaa Festus ba i farawaninaa ei Jew, si'ei, na i'iginaa Paul, “Na rawani a'amu ba o'aa dinaa pafea yei Jerusalem ma ufalarai ba unei dududuio yei wagii e'ei wareaa ro'ou?” ");
INSERT INTO wuv_vpl VALUES ("AC25_10","074_25_10","ACT","25","10","10","Na ware Paul, “E'eni ufi u a'a hepalo humuu dududuaa Caesar. Ma pa'aa sifeni feni humuu dududua ba hamo'aa dududuau. Yoi, ona aidadii ba lomi una bigi'aa hepalo tata a'a ei Jew. ");
INSERT INTO wuv_vpl VALUES ("AC25_11","074_25_11","ACT","25","11","11","Ma'uaa nabaa hamona labagipa'aa hepalo baua tatau ba fei pono'ana ma'ea, te, hamonei fo'afama'eau. Ma'uaa nabaa lomi na fa'ua ei wareaa ei Jew a'au, pa'aa lomi na wanewane ba hemea i fifaninau a'a ro'ou. Yau na ainaa a'a Caesar!” ");
INSERT INTO wuv_vpl VALUES ("AC25_12","074_25_12","ACT","25","12","12","I warewarefipuidii a'a ei maroana Festus, na ware, “Yoi, ona ainaa a'a Caesar, te owe aununaa a'a Caesar!” ");
INSERT INTO wuv_vpl VALUES ("AC25_13","074_25_13","ACT","25","13","13","Hefi'adiai arewaa i didii, mei Hapara Agrippa ma Bernice, laguna sufudai yei Caesarea ba lagu'aa taufagutanaa Festus. ");
INSERT INTO wuv_vpl VALUES ("AC25_14","074_25_14","ACT","25","14","14","Si'ei ba laguna guta famadii ma'ida yei, Festus na warewareaa fei dududuaa Paul a'a mei hapara. Ina ware, “Na pa'i hemea rama'a yeni, hemea na bobo'ai uaa Felix. ");
INSERT INTO wuv_vpl VALUES ("AC25_15","074_25_15","ACT","25","15","15","Ei a dinaa Jerusalem, ei famamoaa humuu mei Haidaa ma ei bauaniaa ei Jew, rona ware ba ina pa'i tatana ma rona i'igainau ba unei ware ba na pa'aa tata ma unei fanima'aia. ");
INSERT INTO wuv_vpl VALUES ("AC25_16","074_25_16","ACT","25","16","16","“Una warefanaa ro'ou ba abaa ale'ei maumau Rome ba hai'ou fifaninaa mei rona ware ba na tata nabaa lo'e nado'o uwareaa fipepei a'ana, a'a ei rona ware ba hia na bigifatata. ");
INSERT INTO wuv_vpl VALUES ("AC25_17","074_25_17","ACT","25","17","17","Ei ro'aa nomai a'au, lomi ba una famadinaa fei dududua. Heaidiai arewaa ma una fa'asi'anaa fei dududua ma warenaa a'a ro'ou ba ronei dugamai mei. ");
INSERT INTO wuv_vpl VALUES ("AC25_18","074_25_18","ACT","25","18","18","Ro'aa ufalarai, ei ro'aa ware ba ina bigifatata, lomi rona wareaa tamanu bigifatatana yau una naraia. ");
INSERT INTO wuv_vpl VALUES ("AC25_19","074_25_19","ACT","25","19","19","Ma'uaa, ro'ou ma hia, rona fiharenii wagii fei mau losuu ro'ou ma hemea ma'ea harana Jesus, hemea na ware Paul ba ina werawera e'eni. ");
INSERT INTO wuv_vpl VALUES ("AC25_20","074_25_20","ACT","25","20","20","Nawe puloto tabau ma una nara ba, ‘Haa, a fadududubatanainia eni manumanu ale'eni feni.’ Si'ei una i'iginia ba na rawani a'ana ba i dinaa Jerusalem ma ufalarai a'a fei dududua yei a'a e'ei wareaa ro'ou.” ");
INSERT INTO wuv_vpl VALUES ("AC25_21","074_25_21","ACT","25","21","21","I'a ware ba fei dududuana nei fifaninaa panii Augustus, una ware ba roneido'o panarofia hawina na alonaa hia a'a Caesar.” ");
INSERT INTO wuv_vpl VALUES ("AC25_22","074_25_22","ACT","25","22","22","Si'ei, na ware Agrippa a'a Festus ba, “Ba ado'o guai wareaa mei rama'a mei yau.” Ina ware, “Nadii, owe guainia.” ");
INSERT INTO wuv_vpl VALUES ("AC25_23","074_25_23","ACT","25","23","23","Heaidiai arewaa, Agrippa ma Bernice, laguna nofipuimai a'a ei bauaniaa fo'aa mawe ei bauaniaa gufu ma ei rama'a rona taufagutanaa lagua. I'a ware Festus, rona dugamii Paul. ");
INSERT INTO wuv_vpl VALUES ("AC25_24","074_25_24","ACT","25","24","24","Festus na ware, “Mena Hapara Agrippa ma minaa hamu'ou eni yeni wagieni, hamu'ou fanunuia meni rama'a meni! Minaa ei Jew, ronamina i'iginau a'ana yei Jerusalem ma yeni Caesarea ma harofafifi'i ba hia nei ma'e. ");
INSERT INTO wuv_vpl VALUES ("AC25_25","074_25_25","ACT","25","25","25","Lomi una labagipa'aa hepalo tatana ba pono'ana ma'ea. Ma'uaa, hamatee ina ainaa a'a Augustus una waredii ba a alonaa hia Rome. ");
INSERT INTO wuv_vpl VALUES ("AC25_26","074_25_26","ACT","25","26","26","Ma'uaa lomi na aida ba a ne'inaa tamanu a'a Caesar wagina. Si'ei, una fa'ufalarainia yeni pudaa hamu'ou ma ana napa'aa rawani ba yoi yeni, mena Hapara Agrippa, ba wagii feni fiwarewareia, ipowe pa'i paolaa ne'iau a'a Caesar. ");
INSERT INTO wuv_vpl VALUES ("AC25_27","074_25_27","ACT","25","27","27","Uaa lomi na rawani a'au nabaa o aloaa nemea bobo'aia ma lomi odo'o warefa'arewainaa fei tatana.” ");
INSERT INTO wuv_vpl VALUES ("AC26_1","074_26_1","ACT","26","1","1","Ma Agrippa na warenaa a'a Paul, “Nadii. Onei wareaa pepei a'amu.” Si'ei, Paul na pi'inaa panina ma wareaa pepei a'ana: ");
INSERT INTO wuv_vpl VALUES ("AC26_2","074_26_2","ACT","26","2","2","“Mena Hapara Agrippa, unamina ni'e wagieni ba una u i pudamu ma wareaa pepei a'au wagii minaa ei tata ei Jew rona ware ba una bigi'ia. ");
INSERT INTO wuv_vpl VALUES ("AC26_3","074_26_3","ACT","26","3","3","Ma una ni'ediai uaa yoi, ona apa'ifarawaninaa minaa ei maumau ei Jew ma tamanu rona fiharenii wagina. Si'ei, amina i'iginio ba onei guaifarawaninau. ");
INSERT INTO wuv_vpl VALUES ("AC26_4","074_26_4","ACT","26","4","4","“Minaa ei Jew, ronamina apa'ifarawaninaa fei maumau ui badui nopa'amii wagieni, fei rawarawa maumau yei gufuu mawe yei Jerusalem anaa. ");
INSERT INTO wuv_vpl VALUES ("AC26_5","074_26_5","ACT","26","5","5","Apa'aa ro'ou yau ana fiwanini'uamai nopa'amii wagieni ma nabaa ro nunuminia, ro'aa warefa'uai ba na pa'i hepalo maroa laloo fei losuu hai'ou namina waiwai nenerana ma yau hemea Pharisee wagina. ");
INSERT INTO wuv_vpl VALUES ("AC26_6","074_26_6","ACT","26","6","6","Na o'onai unuu a'a tamanu mei Haidaa nadii fa'unainia a'a ei amaa hai'odu. Ma si'eni a u ma'aa feni dududua wagieni. ");
INSERT INTO wuv_vpl VALUES ("AC26_7","074_26_7","ACT","26","7","7","Ma fei nadii fa'unainia mei Haidaa a'a ei hefua ma guapaloei pai Israel, ronamina neneraa mei Haidaa arewaa ma poi ba ro'aa fanunuaa tamanu mei Haidaa nadii fa'unainia ba i bigi'ia. Mena hapara, wagii feni o'onaia unuu, ei Jew rona ware ba una bigifatata. ");
INSERT INTO wuv_vpl VALUES ("AC26_8","074_26_8","ACT","26","8","8","Tani hamo'aa hamamagua wagii fei ba mei Haidaa i fa'asi'anaa ei ma'ea? ");
INSERT INTO wuv_vpl VALUES ("AC26_9","074_26_9","ACT","26","9","9","“Yau ana na nara ba uneimina bigi'aa tamanu ba i fadugeaa fei haraa Jesus, mei Nazareth. ");
INSERT INTO wuv_vpl VALUES ("AC26_10","074_26_10","ACT","26","10","10","Ma sifei fei bigi'au yei Jerusalem. Ei famamoaa humuu mei Haidaa na ugainau ma una bobo'ainaa watauda ei apunaiaa mei Haidaa ma ana una uga ba ronei ma'e. ");
INSERT INTO wuv_vpl VALUES ("AC26_11","074_26_11","ACT","26","11","11","Watauda arewaa una dinaa a'a hepapalo synagogue ba a panarofaa ro'ou ma maniaa ro'ou ba ronei warefafeloaa mei Haidaa. Fei fifi'ii unu'uau a'a ro'ou ma ana una aununaa hefi'a gufu raua ba a haperaraiaa ro'ou. ");
INSERT INTO wuv_vpl VALUES ("AC26_12","074_26_12","ACT","26","12","12","“I a'a hepalo tatalaia ale'ei, ei famamoaa humuu mei Haidaa, rona fani forafora a'au ma aloau ba nei dinaa Damascus. ");
INSERT INTO wuv_vpl VALUES ("AC26_13","074_26_13","ACT","26","13","13","Mena hapara, ale'ei haloaina, ei fi talailao tala, una fanunupa'aa hepalo we'ai i pafea na muainaa we'aa fei halo, namina we'afaweloinau ma ei tafiu. ");
INSERT INTO wuv_vpl VALUES ("AC26_14","074_26_14","ACT","26","14","14","Hai'ounamina pasinaa pu ma una guainaa hepalo lao na warenaa a'au warea Aramea, ‘Saul, Saul, tani o haperaraiau? Napa'aa waiwai a'amu ba o'aa putotoraa ei nunumiau.’ ");
INSERT INTO wuv_vpl VALUES ("AC26_15","074_26_15","ACT","26","15","15","“Unawe i'igai, ‘Yoi hini, mena Fasu?’ “Na ware mei Fasu, ‘Yau Jesus, mei ona haperaraia. ");
INSERT INTO wuv_vpl VALUES ("AC26_16","074_26_16","ACT","26","16","16","Nadii, asi'a'ufalarai. Una fa'arewa a'amu ba a rafeinio ale'ei nafi ba onei u'ugaa ei fanunuamu a'au ma tamanu awe fama'aio. ");
INSERT INTO wuv_vpl VALUES ("AC26_17","074_26_17","ACT","26","17","17","U'a fatelaio a'a ena gufumu mawe ena Gentile. A alonaa yoi a'a ro'ou ");
INSERT INTO wuv_vpl VALUES ("AC26_18","074_26_18","ACT","26","18","18","ba onei fa'arewaiaa pudaa ro'ou ma famomo'ainaa ro'ou a'a fei roromaa, foisinamii ro'ou a'a fei we'ai ma famomo'ainaa ro'ou i a'a fei faufau Satan, foisinamii ro'ou a'a mei Haidaa ba i futoaa ei hafelo'aa ro'ou ma ropowe oafipui a'a ei una papaditainaa ro'ou uaa rona narafawe'i a'au.’ ");
INSERT INTO wuv_vpl VALUES ("AC26_19","074_26_19","ACT","26","19","19","“Ma si'ei, mena Hapara Agrippa, lomi una barafeaa fei fanunuau noranamai pafea. ");
INSERT INTO wuv_vpl VALUES ("AC26_20","074_26_20","ACT","26","20","20","Fama'a nado'o u'u a'a ei yei Damascus, nenee fei, yei Jerusalem ma tadiwe'aiaa Judea mawe ei Gentile anaa. Una u'u ba ronei filoginaa naranaraa ro'ou ma foisinaa a'a mei Haidaa ma fama'aia ba ronapa'aa filoginaa naranaraa ro'ou a'a ei bigi'aa ro'ou. ");
INSERT INTO wuv_vpl VALUES ("AC26_21","074_26_21","ACT","26","21","21","Sifei fei pa'afina ba ei Jew, rona panarofau yei malalaa fei humuu mei Haidaa ba ro'aa fo'afama'eau. ");
INSERT INTO wuv_vpl VALUES ("AC26_22","074_26_22","ACT","26","22","22","Ma'uaa fei hadumaa mei Haidaa na oa i a'au nopa'amii wagieni ma si'ei, una u yeni ba a u'ufanaa ei lomi haraa ro'ou mawe ei baua rama'a. Ei wareau, lomi na pafoinaa ei wareaa ei mamama'a ma Moses ba iwe nomai ");
INSERT INTO wuv_vpl VALUES ("AC26_23","074_26_23","ACT","26","23","23","mei Christ ma tonaa fi'ina ma hia, mei rawarawa asi'ana a'a fei ma'ea ba i u'ugaa fei we'ai a'a ei gufuna mawe ei Gentile.” ");
INSERT INTO wuv_vpl VALUES ("AC26_24","074_26_24","ACT","26","24","24","A'a fei, Festus na ba'ofaa wareaa Paul. Ina pararai, “Paul, yoi, ona poapoai. Fena baua apa'amu na fapoapoainio.” ");
INSERT INTO wuv_vpl VALUES ("AC26_25","074_26_25","ACT","26","25","25","Paul na ware, “Lomi una poapoai, mena rawani'a Festus. Tamanu eni wareau, pa'aa fa'ua ma na wanewane. ");
INSERT INTO wuv_vpl VALUES ("AC26_26","074_26_26","ACT","26","26","26","Mei hapara na apa'idigaa ena manumanu ena ma a warefa'a'a'ua i a'ana. Unapa'aa aida ba tamanu ei una wareia, hia na aidadii uaa abaa manumanu opa'aia. ");
INSERT INTO wuv_vpl VALUES ("AC26_27","074_26_27","ACT","26","27","27","Mena hapara Agrippa, ona nara ba fa'ua ei wareaa ei mamama'a? Una aidadii ba ona nara ba fa'ua.” ");
INSERT INTO wuv_vpl VALUES ("AC26_28","074_26_28","ACT","26","28","28","Si'ei, Agrippa na warenaa a'a Paul, “Naramu ba ma'ideni au ale'eni o foranotonaa naranarau ba yau hemea Christian?” ");
INSERT INTO wuv_vpl VALUES ("AC26_29","074_26_29","ACT","26","29","29","Paul na ware, “Na madii, o lo'e, a i'iginaa mei Haidaa ba yoi ma minaa ei rona guainaa ei warea, ronei ale'ei yau, ma'uaa hamonei'aa pa'i eni alatai.” ");
INSERT INTO wuv_vpl VALUES ("AC26_30","074_26_30","ACT","26","30","30","Mei hapara na asi'aa ma mei gavanaa ma Bernice mawe ei rona gutafipui a'a ro'odu. ");
INSERT INTO wuv_vpl VALUES ("AC26_31","074_26_31","ACT","26","31","31","Rona asi'adi'ininaa fei laloo humu ma ro'ei fiwarewareilao, rona ware, “Meni rama'a meni, lomi na bigi'aa hepalo manumanu ba pono'ana ma'ea o bobo'aia.” ");
INSERT INTO wuv_vpl VALUES ("AC26_32","074_26_32","ACT","26","32","32","Agrippa na warenaa a'a Festus, “Meni rama'a meni, ana ipa'aa ala nabaa lomi na ainaa a'a Caesar.” ");
INSERT INTO wuv_vpl VALUES ("AC27_1","074_27_1","ACT","27","1","1","Ro'aa ware ba hai'oupowe tamanaa Italy, Paul ma hefi'adiai bobo'aia, rona aunaa panii hemea centurion harana Julius, hia hemea maroaa ei fo'aa Rome. ");
INSERT INTO wuv_vpl VALUES ("AC27_2","074_27_2","ACT","27","2","2","Hai'ouna hugi pafoo hepalo baua wa yei Adramyttium, hepalo ba i talelao a'a hefi'a gufu yei Asia ma hai'ouna ala. Aristarchus, hemea Macedonia gufuna Thessalonica ana a'a hai'ou. ");
INSERT INTO wuv_vpl VALUES ("AC27_3","074_27_3","ACT","27","3","3","Heaidiai arewaa, hai'ouna pe'i yei Sidon. Ma Julius ba i farawaninaa Paul, na ugainia ba neido'o aunu ma tatalai a'a ei tafina ba ro'aa hadumia a'a tamanu nunumiana. ");
INSERT INTO wuv_vpl VALUES ("AC27_4","074_27_4","ACT","27","4","4","Ma yei, hai'ouna aladiai ma talenaa Cyprus fipepei lomi lalarena uaa fei lalarena na agisuafaa hai'ou. ");
INSERT INTO wuv_vpl VALUES ("AC27_5","074_27_5","ACT","27","5","5","Hai'ou'aa fatalelao i lama papaa fei rau Cilicia ma Pamphylia, hai'ouna pe'i Myra yei Lycia. ");
INSERT INTO wuv_vpl VALUES ("AC27_6","074_27_6","ACT","27","6","6","Yei, mei centurion na labagipa'aa hepalo wa Alexandria ba i dinaa Italy ma na fahuginaa hai'ou pafona. ");
INSERT INTO wuv_vpl VALUES ("AC27_7","074_27_7","ACT","27","7","7","Hai'ouna talefagigilao watauda arewaa ma na waiwai ba hai'ou pe'i yei Cnidus. Namina rata fei lalarena ma si'ei lomi hai'ouna talefawanewane. Hai'ouna talenaa fipepei lomi lalarena yei Crete, papaa Salmone. ");
INSERT INTO wuv_vpl VALUES ("AC27_8","074_27_8","ACT","27","8","8","Hai'ounamina oteifagigilao nopa'amii hefawala harana Fair Havens na rafi'inaa fei gufu Lasea. ");
INSERT INTO wuv_vpl VALUES ("AC27_9","074_27_9","ACT","27","9","9","Hefi'a au namina aunudigilao ma napa'aa fei au hafeloaa fei lama uaa rona pa'idigaa fei Au Fabaoa. Si'ei, na warefa'aiaa ro'ou Paul, ");
INSERT INTO wuv_vpl VALUES ("AC27_10","074_27_10","ACT","27","10","10","“Me'o, na fanunupa'ia ba feni taleaa o'ou, i pa'aa o'ou hafelo'a ma i pa'ai feni baua wa ma ei manumanu pafona mawe o'odu.” ");
INSERT INTO wuv_vpl VALUES ("AC27_11","074_27_11","ACT","27","11","11","Ma'uaa, mei centurion, lomi na guainaa wareaa Paul. Ina neneraa wareaa mei rapi'a ma mei amaa fei wa. ");
INSERT INTO wuv_vpl VALUES ("AC27_12","074_27_12","ACT","27","12","12","Fei pe'iaa wa yei lomi na rawani ba hai'ou'aa pe'i famadii ale'ei figa puda. Ma watauda hai'ouna ware ba hai'ounei fatale'ualao ba hai'ou'aa dinaa Phoenix ma pe'i farereaa fei lalarena yei. Fei, hepalo pe'iaa wa yei Crete, oma'analoo hafa'ialama ma punenegufu. Ma ba hai'ou'aa pe'i famadii, ale'ei figa puda yei. ");
INSERT INTO wuv_vpl VALUES ("AC27_13","074_27_13","ACT","27","13","13","I nimanimaimai ma'ida fei lalarena, rona nara ba sifei fei talaa ro'ou. Si'ei rona fafaneaa fei hipo ma fatale'aunulao Crete. ");
INSERT INTO wuv_vpl VALUES ("AC27_14","074_27_14","ACT","27","14","14","Ataa madii, namina asi'aa fei baua lalarena. Haraa feni lalarena raihara'uu noranamai i a'a fei gufu. ");
INSERT INTO wuv_vpl VALUES ("AC27_15","074_27_15","ACT","27","15","15","Fei lalarena na fitaninaa ma'aa fei wa ma lomi na talepa'i ma si'ei, hai'ounawe talenenegi'uaia. ");
INSERT INTO wuv_vpl VALUES ("AC27_16","074_27_16","ACT","27","16","16","Hai'ouna lafelao rafi'inaa hepalo pusu'o gufu harana Cauda ma na waiwai ba hai'ou'aa faufarawaninaa hepalo pusu'o wa, fei rona taleforaia a'a fei wa bauana. ");
INSERT INTO wuv_vpl VALUES ("AC27_17","074_27_17","ACT","27","17","17","Ro'aa poro'aupa'idigaa fei pusu'o wa, rona tonaa hefi'a wao ma faufaweloinaa puguu fei baua wa ba ro'aa faufawe'ia. Si'ei ba rona ma'au ba fei lalarena i nafa'isiminaa ro'ou i piyee Syrtis, rona fapasiaa fei hipo ba nei falaporaa fei wa. ");
INSERT INTO wuv_vpl VALUES ("AC27_18","074_27_18","ACT","27","18","18","Fei agi namina fanima'aiaa hai'ou ma si'ei, iree arewa, rona siminaa agi ei manumanu pafoo fei wa. ");
INSERT INTO wuv_vpl VALUES ("AC27_19","074_27_19","ACT","27","19","19","A'a fei fa'oduaiaa arewaa, ronawe tonaa ei manumanu unuu fei wa ma porosiminia. ");
INSERT INTO wuv_vpl VALUES ("AC27_20","074_27_20","ACT","27","20","20","Ale'ei figa arewaa i didii lomi hai'ouna fanunupa'aa fei halo o ei pi'u ma fei agi namina weta ua. Nawe asisi naranaraa hai'ou ba lomi hai'ou'aa tela. ");
INSERT INTO wuv_vpl VALUES ("AC27_21","074_27_21","ACT","27","21","21","Figa arewaa na didii ma lomi rona hanana ei rama'a. Idii, Paul nawe u i pudaa ro'ou ma ware, “Ma'aia me'o? Nabaa hamona guainaa wareau ba onei'aa di'ininaa Crete, lomi hamo'aa pa'aa aree hamu'ou ale'eni ma ei manumanuu hamu'ou, lomi ba i pa'ai ale'eni. ");
INSERT INTO wuv_vpl VALUES ("AC27_22","074_27_22","ACT","27","22","22","Ma'uaa a warefanaa hamu'ou ba apuna fa'asisiaa naranaraa hamu'ou, uaa lomi nemea hamu'ou ba i pa'ai; uniaa feni wa. ");
INSERT INTO wuv_vpl VALUES ("AC27_23","074_27_23","ACT","27","23","23","Poi minoa hemea alo'alo na u papau. Mei alo'alo mei, hemea alo'aloo mei Haidaa, mei una bigi'aa bigi'ana. ");
INSERT INTO wuv_vpl VALUES ("AC27_24","074_27_24","ACT","27","24","24","Mei alo'alo na ware, ‘Apuna ma'au Paul. Yoi, o u i ma'aa Caesar ma mei Haidaa, i fani'uaio fei harenuaa ei ro'aa tamafipui a'amu.’ ");
INSERT INTO wuv_vpl VALUES ("AC27_25","074_27_25","ACT","27","25","25","Si'ei, hamonei fa'o'onainaa unuu hamu'ou me'o, uaa yau na pa'i narafawe'iau a'a mei Haidaa ba tamanu ei wareana a'au i pa'aa bigi'ia. ");
INSERT INTO wuv_vpl VALUES ("AC27_26","074_27_26","ACT","27","26","26","Ma'uaa o'ou, o'aa tafe a'a hepalo gufu.” ");
INSERT INTO wuv_vpl VALUES ("AC27_27","074_27_27","ACT","27","27","27","A'a fei fahefua ma gunaroaa poi, fei lalarena ana fi susuni'uamiaa hai'ou aunulao yei Agii Adriatic. Ma ale'ei poidifa'u'u, ei bigibigi'a pafoo wa, rona nanamuinia ba roi fararafi'inaa fei gufu. ");
INSERT INTO wuv_vpl VALUES ("AC27_28","074_27_28","ACT","27","28","28","Rona fa'aunuaa fei wao ma fanunupa'ia ba walalona ale'ei odufua pa'ania ma oloromeai metre. Madilao ma'ida, rona fa'aunudinia ma fanunupa'ia ba walalona ale'ei enu pa'ania ma oloromeai metre. ");
INSERT INTO wuv_vpl VALUES ("AC27_29","074_27_29","ACT","27","29","29","Rona ma'au ba fei mamaua i nafa'isiminaa hai'ou pafoo na'a. Si'ei, rona fapasidinaa obao hipo i mugii fei baua wa ma gutaroni ba nei arewa batafa. ");
INSERT INTO wuv_vpl VALUES ("AC27_30","074_27_30","ACT","27","30","30","Ba ro'aa di'ininaa fei baua wa, hefi'a bigibigi'a na alafapasiaa fei pusu'o wa. Ma ba ro'aa sifi'aa ei rama'a, rona fapasiaa hefi'adiai hipo i ma'aa fei baua wa. ");
INSERT INTO wuv_vpl VALUES ("AC27_31","074_27_31","ACT","27","31","31","Ma Paul na warenaa a'a mei centurion mawe ei fo'aa ba, “Nabaa lomi ro'aa gutapanarofaa feni baua wa, lomi hamo'aa tela.” ");
INSERT INTO wuv_vpl VALUES ("AC27_32","074_27_32","ACT","27","32","32","Si'ei, ei fo'aa na moro'aa ei wao, ei na panarofaa fei wa pusu'o ma fapasialao. ");
INSERT INTO wuv_vpl VALUES ("AC27_33","074_27_33","ACT","27","33","33","Anaa i arewa, na ware a'a ro'odu Paul ba ronei hanana. Ina ware, “Laloo ei hefua ma gunaroa arewaa i didii hamona gutanara watauda ma lomi hamona hanana. Lomi hamona hanaiaa hepalo manumanu. ");
INSERT INTO wuv_vpl VALUES ("AC27_34","074_27_34","ACT","27","34","34","E'eni a ware ba hamonei hanana ba lomi hamo'aa ma'e. Lomi ba i adudu hepalo hugo tabaa hemea hamu'ou.” ");
INSERT INTO wuv_vpl VALUES ("AC27_35","074_27_35","ACT","27","35","35","I waredii ale'ei, na tonaa hefi'a faraa pidaua ma i pudaa minaa ro'ou na ware ‘ta’ a'a mei Haidaa. Ma na itafia ma hanaia. ");
INSERT INTO wuv_vpl VALUES ("AC27_36","074_27_36","ACT","27","36","36","Namina fawe'idinaa naranaraa minaa ro'ou ma ana rona hanaiaa hefi'a du'ua. ");
INSERT INTO wuv_vpl VALUES ("AC27_37","074_27_37","ACT","27","37","37","Puduu hai'ou pafoo wa ale'ei enu pu'u ma oloromfua ma oloroa. ");
INSERT INTO wuv_vpl VALUES ("AC27_38","074_27_38","ACT","27","38","38","Ro'aa hananafamagudii, ba ro'aa fapapaiaa fei wa, rona siminaa agi ei du'ua. ");
INSERT INTO wuv_vpl VALUES ("AC27_39","074_27_39","ACT","27","39","39","I no'arewalao, lomi rona fanunu'apa'aa fei gufu ba tamanu, ma'uaa rona fanunupa'aa hefaa malouna ma na pa'i piye ma rona nara ale'ei ba ro'aa manima'a ba ro'aa fatafe yei. ");
INSERT INTO wuv_vpl VALUES ("AC27_40","074_27_40","ACT","27","40","40","Rona moro'aa ei hipo, famomogunaa agi ma alaraa ei wao, ei na faugaa ei poree rapirapi. Ma rona sugainaa pafea fei lawalawa a'a fei tala lalarena ma fatalenaa piye. ");
INSERT INTO wuv_vpl VALUES ("AC27_41","074_27_41","ACT","27","41","41","Ma'uaa fei wa na tafe a'a fei piye fawelei na parepare. Fei ma'aa wa na tafe. Lo'ediai ma'atalana ma fei mugii wa na aninimatala a'a fei mamaua. ");
INSERT INTO wuv_vpl VALUES ("AC27_42","074_27_42","ACT","27","42","42","Ei fo'aa, rona fiwarei ba ro'aa fo'afama'eaa ei bobo'aia uaa ba ronei'aa pai'aunu ma ponipa'ai. ");
INSERT INTO wuv_vpl VALUES ("AC27_43","074_27_43","ACT","27","43","43","Ma'uaa mei centurion lomi na nunumiai ba Paul i ma'e si'ei ina lawaraa ro'ou a'a fei naranaraa ro'ou. Ina ware a'a ei rona aida paia ba roneido'o rofo ma painaa piye. ");
INSERT INTO wuv_vpl VALUES ("AC27_44","074_27_44","ACT","27","44","44","Ma ei dufudufu ronei falafe pafoo ei memee haihai fei wa. Rona bigi'ia ale'ei ma si'ei, minaa ro'ou, rona pa'aa piye. ");
INSERT INTO wuv_vpl VALUES ("AC28_1","074_28_1","ACT","28","1","1","Hai'ou'aree pa'aa piye, hai'ouna no'apa'alao ba fei gufu, harana Malta. ");
INSERT INTO wuv_vpl VALUES ("AC28_2","074_28_2","ACT","28","2","2","Ei rama'aa fei gufu fei, ronamina farawaninaa hai'ou. Rona pa'aiaa fei hafi ma taufa'ugaa minaa hai'ou uaa na roparopa fei maunu ma hai'ouna waiwa. ");
INSERT INTO wuv_vpl VALUES ("AC28_3","074_28_3","ACT","28","3","3","Paul na poro'amai hefi'a taloa, puguminalao a'a fei hafi ma hepalo wa'a hafelo na teteiamai fei babaia, na taduaa panina ma lomi na rawa. ");
INSERT INTO wuv_vpl VALUES ("AC28_4","074_28_4","ACT","28","4","4","Ro'aa fanunupa'aa fei wa'a ba na tausisigai panina rona fiwarewarei ba, “Meni rama'a meni, woro hia rama'aa fo'afama'ea. Fa'ua ba ina tela a'a fei agi ma'uaa fei dududuana ipowe fama'eia.” ");
INSERT INTO wuv_vpl VALUES ("AC28_5","074_28_5","ACT","28","5","5","Ma'uaa Paul na hubisiminaa fei wa'a a'a fei hafi ma lomi na to hafelo'ana wagina. ");
INSERT INTO wuv_vpl VALUES ("AC28_6","074_28_6","ACT","28","6","6","Ei rama'a, rona nara ba i popola, o ba i pasima'e, ma'uaa ro'aa guta'oma'oma'a ma lomi rona fanunupa'aa bibiyeiana, ronawe nara ba woro hia hemea haidaa. ");
INSERT INTO wuv_vpl VALUES ("AC28_7","074_28_7","ACT","28","7","7","Na pa'i hefaa baua humu na rafi'i, humuu Publius, mei bauaniaa fei gufu fei. Ina taufagutanaa hai'ou i humuna ma laloo oduai arewaa namina farawaninaa hai'odu. ");
INSERT INTO wuv_vpl VALUES ("AC28_8","074_28_8","ACT","28","8","8","Mei amana na funuhaino pafoo tawa. Na babai ununa ma na pepeaa raraa. Paul na wadu'ai ba i ma'a hia. I lafulafudii, na augaa panina pafona ma fapedugaa funuana. ");
INSERT INTO wuv_vpl VALUES ("AC28_9","074_28_9","ACT","28","9","9","Ro fanunuia ale'ei, minaa ei funua a'a fei gufu fei, rona nomai ma ina fapedugaa funuaa ro'ou. ");
INSERT INTO wuv_vpl VALUES ("AC28_10","074_28_10","ACT","28","10","10","Rona farawaninaa hai'ou a'a watauda manumanu. Ma ei ba ana hai'ou ala, rona fanaa hai'ou ei manumanu hai'ouna nunuminia. ");
INSERT INTO wuv_vpl VALUES ("AC28_11","074_28_11","ACT","28","11","11","Nenee oduai puda, hai'ouna hugi a'a hepalo wa, hepalo na pe'i opa'ai yei a'a fei au hafelo. Fei wa fei, wa Alexandria ma i ma'aa fei wa na pa'i baua hanunuu laguei wata haidaa sifisifi Castor ma Pollux. ");
INSERT INTO wuv_vpl VALUES ("AC28_12","074_28_12","ACT","28","12","12","Hai'ouna pe'i Syracuse ma guta yei oduai arewaa. ");
INSERT INTO wuv_vpl VALUES ("AC28_13","074_28_13","ACT","28","13","13","Ma yei hai'ouna ala ma pe'i yei Rhegium. Heaidiai arewaa, na asi'aa fei lalarena, noramiana ale'ena hara'uu ma heaidiai arewaa, hai'ounaree pe'i yei Puteoli. ");
INSERT INTO wuv_vpl VALUES ("AC28_14","074_28_14","ACT","28","14","14","Ma yei hai'ouna bapa'aa hefi'a lofu ma rona dugaa hai'ou ba hai'ounei gutafipui a'a ro'ou ale'ei heai hefapagipagia. Ma nenee fei ba hai'ouna dinaa Rome, ");
INSERT INTO wuv_vpl VALUES ("AC28_15","074_28_15","ACT","28","15","15","ei lofu yei fawelei, rona guainia ba hai'oufi talailao, rona nofarauamai ba ro'aa oma'aa hai'ou yei Forum Appius ma yei Odumanu Tavern. I fanunupa'aa ei rama'a ei, Paul na ware ‘ta’ a'a mei Haidaa ma na refurefu ununa. ");
INSERT INTO wuv_vpl VALUES ("AC28_16","074_28_16","ACT","28","16","16","Hai'ou'aa nopa'aloo Rome, rona uga ba Paul nei guta'u'ugai unaiana, ma'uaa nei pa'i hemea fo'aa oma'ana. ");
INSERT INTO wuv_vpl VALUES ("AC28_17","074_28_17","ACT","28","17","17","Nenee oduai arewaa ina lala'aa ei bauaniaa ei Jew. Ro'aa nofipuidigimai, na ware Paul a'a ro'ou, “Ena lofuu, yau lomi na bigi'aa hepalo tata a'a ei gufuu o'ou, o a'a ei maumau ei upuu o'ou, ma'uaa, rona panarofau yei Jerusalem ma fifaninau a'a ei Rome. ");
INSERT INTO wuv_vpl VALUES ("AC28_18","074_28_18","ACT","28","18","18","Rona dududuau ma ba ro'aa alarau uaa lomi rona labagipa'i tatau ba pono'ana ma'ea. ");
INSERT INTO wuv_vpl VALUES ("AC28_19","074_28_19","ACT","28","19","19","Ma'uaa ei Jew, rona siba wagina, si'ei, una ainaa a'a Caesar. Ma'uaa lomi ba a dududuaa ei gufuu o'odu. ");
INSERT INTO wuv_vpl VALUES ("AC28_20","074_28_20","ACT","28","20","20","Sifei fei fafasuina a lala'aa hamu'ou ba o'aa fiwarewarei. Fei fafasui fei ba na bobo'ai, sifei ba na pa'i o'onai unuu o'ou Israel.” ");
INSERT INTO wuv_vpl VALUES ("AC28_21","074_28_21","ACT","28","21","21","Rona ware, “Lomi hai'ouna to ne'ia fi warewareio noramiana Judea ma lomi hemea lofu na nomai yei na u'u o wareaa hepalo hafelo'amu a'a hai'odu. ");
INSERT INTO wuv_vpl VALUES ("AC28_22","074_28_22","ACT","28","22","22","Ma'uaa ba hai'ou'aa guai tamanu naranaramu, uaa hai'ouna aida ba watauda rama'a, rona warefafeloaa feni maroaa losuu.” ");
INSERT INTO wuv_vpl VALUES ("AC28_23","074_28_23","ACT","28","23","23","Rona fiwarewarei ba ro'aa ma'a Paul a'a fei arewaa fei ma nenee fei, wataudadiai rona nomai a'a fei humu ina guta wagina. Mafufuo ma ama'analoo poi ina u'ufanaa ro'ou fei haparaiaa mei Haidaa ba i fawe'iaa naranaraa ro'ou a'a Jesus wagii tamanu na wareia fei Law Moses ma ei Mamama'a. ");
INSERT INTO wuv_vpl VALUES ("AC28_24","074_28_24","ACT","28","24","24","Hefi'a ro'ou, rona nara ba fa'ua ma hefi'a, lomi. ");
INSERT INTO wuv_vpl VALUES ("AC28_25","074_28_25","ACT","28","25","25","Rona fiharenii ma aunu nenee i wareaa feni Paul ba, “Fei Spiriti Apuna warefa'uai a'a ei upuu hamu'ou ei i umuinia mei mamama'a Isaiah: ");
INSERT INTO wuv_vpl VALUES ("AC28_26","074_28_26","ACT","28","26","26","“‘Aununaa a'a eni rama'a eni ma ware, “Hamomina guguai, ma'uaa lomi hamo'aa apa'aa hanuna; hamomina fafanunu, ma'uaa lomi hamo'aa fanunupa'i.” ");
INSERT INTO wuv_vpl VALUES ("AC28_27","074_28_27","ACT","28","27","27","Uaa, fei naranaraa eni rama'a eni, namina waiwai. Lomi rona guaipa'inaa adiaa ro'ou ma rona ma'igunaa pudaa ro'ou. Nabaa abaa ale'ei, ro'aa fanunupa'inaa pudaa ro'ou ma ro'aa guaipa'inaa adiaa ro'ou, narapa'i ma foisimai ma yau a fapedugaa funuaa ro'ou.’ ");
INSERT INTO wuv_vpl VALUES ("AC28_28","074_28_28","ACT","28","28","28","“Si'ei, nunumiau ba hamonei aida ba fei tela'ana, mei Haidaa na alodigia a'a ei Gentile ma ropowe guguai!” ");
INSERT INTO wuv_vpl VALUES ("AC28_30","074_28_30","ACT","28","30","30","Laloo heguai igisimasi, Paul na guta laloo fei humuna, fei ina'o pono'ia ma taufagutanaa hini ei ronamii ma'a hia. ");
INSERT INTO wuv_vpl VALUES ("AC28_31","074_28_31","ACT","28","31","31","Lomi na warefamamafa ma lomi hepalo manumanu na lawagia ei i u'ugaa fei haparaiaa mei Haidaa ma feroifanaa ro'ou mei Fasu Jesus Christ. ");
INSERT INTO wuv_vpl VALUES ("RM1_1","075_1_1","ROM","1","1","1","Yau Paul, hemea nafii Christ Jesus, na rafeinau mei Fasu ba yau, apostle ma na au'u'ugainau ba nei bigi'aa fei rawani'a wareaa mei Haidaa— ");
INSERT INTO wuv_vpl VALUES ("RM1_2","075_1_2","ROM","1","2","2","fei rawani'a warea, fei nado'o fa'unainia a'a ei mamama'a i laloo fei Bu'u Apuna— ");
INSERT INTO wuv_vpl VALUES ("RM1_3","075_1_3","ROM","1","3","3","fei na u'ufanaa o'ou fei u'ugaa mei Na'una, mei na tonaa fei maumau rama'a noranamai a'a fei pai David ");
INSERT INTO wuv_vpl VALUES ("RM1_4","075_1_4","ROM","1","4","4","ma wagii fei Spiriti, fei na apunai, ina tonaa fei faufau mei Haidaa ba i fama'aia ba hia Na'uu mei Haidaa wagii fei asi'anana a'a fei ma'ea, Jesus Christ, mei Fasuu o'ou. ");
INSERT INTO wuv_vpl VALUES ("RM1_5","075_1_5","ROM","1","5","5","I a'ana ma wagii fei ba i farawaninaa fei harana, hai'ouna tofa'a'a'uaiaa fei rawani'a ma fei bigi'aa apostle ba hai'ou lala'aa minaa ei rama'a dupuaa ei Gentile ba ronei neneraa tamanu i nomai a'a fei we'iaa naranara. ");
INSERT INTO wuv_vpl VALUES ("RM1_6","075_1_6","ROM","1","6","6","Ma hamu'ou, ana i dupuaa ei rona rafei ba maroaa Jesus Christ. ");
INSERT INTO wuv_vpl VALUES ("RM1_7","075_1_7","ROM","1","7","7","Feni i dinaa a'a minaa hamu'ou ena yena Rome, hamu'ou ena na rafei ma haguaa hamu'ou mei Haidaa ba hamonei apunai a'ana. Fei rawani'a ma fei gutafarawania i dinaa a'a hamu'ou noranamai a'a mei Haidaa, mei Amaa o'ou ma mei Fasuu o'ou Jesus Christ. ");
INSERT INTO wuv_vpl VALUES ("RM1_8","075_1_8","ROM","1","8","8","I a'a Jesus Christ, ado'o ware ‘ta’ a'a mei Haidaniau uaa minaa hamu'ou, hamatee fei we'iaa naranaraa hamu'ou, ronamina u'ugia tadiwe'aiaa malagufu. ");
INSERT INTO wuv_vpl VALUES ("RM1_9","075_1_9","ROM","1","9","9","Una bigifawe'i a'a mei Haidaa fininaa minaa ei faufau ei una u'ugaa fei rawani'a wareaa mei Na'una. Ma mei Haidaa, hia ugaa neneu ba yau nafane nonominaa hamu'ou ");
INSERT INTO wuv_vpl VALUES ("RM1_10","075_1_10","ROM","1","10","10","laloo ei lafulafuau ranimai ma ufi lafulafu ba a'a fei nunumiaa mei Haidaa ba fei talau nei gigi ba awe nowau a'a hamu'ou. ");
INSERT INTO wuv_vpl VALUES ("RM1_11","075_1_11","ROM","1","11","11","Ba apa'aa ma'a hamu'ou, ba a fanaa hamu'ou ei na fanau fei spiriti ba nei pa'i faufau hamu'odu ");
INSERT INTO wuv_vpl VALUES ("RM1_12","075_1_12","ROM","1","12","12","ba hamu'ou ma yau nei fihaduminaa ei we'iaa naranaraa o'odu. ");
INSERT INTO wuv_vpl VALUES ("RM1_13","075_1_13","ROM","1","13","13","Nunumiau, ena lofuu, ba hamonei aida ba unafane naranara ba amii ma'a hamu'ou (ma'uaa nafane lawagi talau nopa'amii e'eni) ba a hufu fua i dupuaa hamu'ou, ana ale'ei na bigidigia a'a hefi'adiai ei Gentile. ");
INSERT INTO wuv_vpl VALUES ("RM1_14","075_1_14","ROM","1","14","14","Uneipa'aa bigifipui a'a ei Greece mawe ei abaa Greece ma a'a e'ei rona pa'i apa'aa ro'ou mawe ei rona poapoai. ");
INSERT INTO wuv_vpl VALUES ("RM1_15","075_1_15","ROM","1","15","15","Si'ei unamina refurefu ba a u'ugaa fei rawani'a warea a'a hamu'ou ena yena Rome. ");
INSERT INTO wuv_vpl VALUES ("RM1_16","075_1_16","ROM","1","16","16","Lomi una mamafa a'a fei rawani'a warea, uaa sifei, fei faufau mei Haidaa ba i fatela'anaa minaa ei rama'a na we'i naranaraa ro'ou, do'o rawarawa ei Jew ma hinene ei Gentile. ");
INSERT INTO wuv_vpl VALUES ("RM1_17","075_1_17","ROM","1","17","17","Uaa laloo fei rawani'a warea, mei Haidaa na fama'aa fei talaa wanewanea, fei noranamai a'a fei we'iaa naranara, farawarawa ama'analoo pedupeduna, ana ale'ei rona ne'inia ba: “Ei wanewanea, rona'aida bigifininaa fei we'iaa naranara.” ");
INSERT INTO wuv_vpl VALUES ("RM1_18","075_1_18","ROM","1","18","18","Mei Haidaa fi fama'aa fei dududua fipuinaa fei sibana i norai pafea dinaa a'a minaa ena hafelo'a ma ei hafelo'a bigi'aa ei rama'a, ei rona hafududumaa fei fa'ua warea a'a ei hafelo'a bigi'aa ro'ou, ");
INSERT INTO wuv_vpl VALUES ("RM1_19","075_1_19","ROM","1","19","19","uaa ei maumau mei Haidaa na arewadii a'a ro'ou, hamatee mei Haidaa na fa'arewadigia a'a ro'odu. ");
INSERT INTO wuv_vpl VALUES ("RM1_20","075_1_20","ROM","1","20","20","Uaa a'a fei mamaraiamii feni malagufu nopa'amii e'eni, ei maumau mei Haidaa, ei lomi ona ma'apa'ia, ale'ena fei faufauna, fei na ude ranimai ma fei maumauna ba hia, mei Haidaniaa ei maumau ei, ona fanunufarawaninia ma apa'ifarawaninia a'a tamanu ina bigidigia ma si'ei, ei rama'a, pa'aa lo'e ba ro'aa warefasifipa'i ba lomi rona aida. ");
INSERT INTO wuv_vpl VALUES ("RM1_21","075_1_21","ROM","1","21","21","Fa'ua ba rona apa'aa mei Haidaa ma'uaa, lomi rona uduginia ba hia mei Haidaa ma ana lomi rona ware ‘ta’ a'ana, lomi rona narafarawani ma fei poapoa naranaraa ro'ou, namina roroma. ");
INSERT INTO wuv_vpl VALUES ("RM1_22","075_1_22","ROM","1","22","22","Rona ware ba rona pa'i apa'aa ro'ou ma'uaa, ronapa'aa poapoai ");
INSERT INTO wuv_vpl VALUES ("RM1_23","075_1_23","ROM","1","23","23","ma mei Haidaa, mei lomi i ma'etoo, rona filoginaa fei hawerana a'a ei manumanu rona bigi'ia ba fafanunuana ale'ena maumau ei rama'a (ei foraimanunu) mawe ale'ena ei manufidufidu ma ei manulelele ma ei rona o'ata'ata. ");
INSERT INTO wuv_vpl VALUES ("RM1_24","075_1_24","ROM","1","24","24","Si'ei, mei Haidaa na rawa'a'afinaa ro'ou a'a ei hafelo'a nunumiaa ei naranaraa ro'ou ba ro'aa fafeloaa ana unuu ro'ou a'a ei fitatafipa'aia. ");
INSERT INTO wuv_vpl VALUES ("RM1_25","075_1_25","ROM","1","25","25","Rona filoginaa fei fa'uai wareaa mei Haidaa a'a ei sifisifi ma losui ma uduginaa ei bigi'aa mei Haidaa ma a'a ba mei i bigi'aa ei manumanu, mei onei uduginia ranimai. Amen. ");
INSERT INTO wuv_vpl VALUES ("RM1_26","075_1_26","ROM","1","26","26","A'a fei, mei Haidaa na rawa'afinaa ro'odu a'a ei mamafaa nunumiaa unuu ro'ou. Ma ei pifinee ro'ou, ana rona filoginaa tamanu na wanewane a'a ei lomi na wanewane. ");
INSERT INTO wuv_vpl VALUES ("RM1_27","075_1_27","ROM","1","27","27","Ana ale'ei, ei wawane, lomi rona fiharoi a'a ei pifine, uaa namina bauanai fei ba ro'aa fiharoi ana ro'ou ei wawane. Ei wawane na bigi'aa tamanu lomi na rawani a'a ana ro'odu. Ma ana ro'ou, rona tonaa fei aree ro'ou a'a ei hafelo'a bigi'aa ro'ou. ");
INSERT INTO wuv_vpl VALUES ("RM1_28","075_1_28","ROM","1","28","28","Ma hepalodiai, si'ei ba rona nara ba lo'e manumanu nabaa ro'aa siminaa fei apa'aa mei Haidaa, te, ina rawa'afainaa ro'ou a'a fei poapoa naranaraa ro'ou ba ro'aa bigi'aa tamanu ronei'aa bigi'ia. ");
INSERT INTO wuv_vpl VALUES ("RM1_29","075_1_29","ROM","1","29","29","Namina pepesu a'a ro'odu minaa ei maumau hafelo'a, wawa'ai poa, fai lomi naranaraa rawani. Ronamina pepesu a'a fei nanamaia, fo'afama'ea, fiharenia, sifisifi'a ma fei bidibidii unu. Rona bababau'u, ");
INSERT INTO wuv_vpl VALUES ("RM1_30","075_1_30","ROM","1","30","30","rona warefafeloaa hefi'adiai, na bidi unuu ro'ou a'a mei Haidaa, warefani, agu'agui, mamagugui; rona pagipagiaa hefi'a tala ba ro'aa bigi'aa ei hafelo'a; rona barafeaa ei ama ma inaa ro'ou; ");
INSERT INTO wuv_vpl VALUES ("RM1_31","075_1_31","ROM","1","31","31","na waiwai tabaa ro'ou ma lomi we'iaa naranara, lomi faloloa'ia ma lomi rona haguaa hefi'adiai. ");
INSERT INTO wuv_vpl VALUES ("RM1_32","075_1_32","ROM","1","32","32","Fa'ua ba rona apa'aa fei wanewane wareaa mei Haidaa, fei ba ei rona bigi'aa ei manumanu ei, aree ro'ou, ma'ea, ma'uaa rona bigi'uaiaa ei manumanu ei ma ana rona uga ua a'a ei rona bigi'ia. ");
INSERT INTO wuv_vpl VALUES ("RM2_1","075_2_1","ROM","2","1","1","Si'ei, nabaa ona nara ba hefi'a na hafelo, lomi i pa'i tala ba o ware ba ona rawani, uaa a'a tamanu ona nara ba rona bigifafelo wagina, ana ona fafeloaa anaio, uaa ei manumanu ei, ana ona bigi'ia. ");
INSERT INTO wuv_vpl VALUES ("RM2_2","075_2_2","ROM","2","2","2","Ma ona aida ba fei pa'afii fei dududuaa mei Haidaa a'a ei rona bigi'aa ei manumanu ei, na neneraa tamanu na wanewane. ");
INSERT INTO wuv_vpl VALUES ("RM2_3","075_2_3","ROM","2","3","3","Yoi rama'a ua. Tani o nara ba rona bigifafelo, ma'uaa ei manumanu ei, ana ona bigi'ia—haa, ei naramu ba o ponipa'ainaa fei dududuaa mei Haidaa? ");
INSERT INTO wuv_vpl VALUES ("RM2_4","075_2_4","ROM","2","4","4","O, ona nara ba aba baua manumanu ei rawani'ana, o fei walaloaa sibana, o fei ofasi'ana ma lomi ona apa'ia ba fei rawani'aa mei Haidaa fi nodugio a'a fei filogiaa naranara? ");
INSERT INTO wuv_vpl VALUES ("RM2_5","075_2_5","ROM","2","5","5","Ma'uaa, si'ei ba namina waiwai tabamu ma lomi ona filoginaa ei naranaramu, oi fa'apoi'uaiaa fei fagianamu a'a fei arewaa sibaa mei Haidaa ena na arewamai fama'aiaa fei wanewane dududuana. ");
INSERT INTO wuv_vpl VALUES ("RM2_6","075_2_6","ROM","2","6","6","Mei Haidaa, “iwe fanaa hememea ana ale'ei tamanu ina bigi'ia.” ");
INSERT INTO wuv_vpl VALUES ("RM2_7","075_2_7","ROM","2","7","7","A'a ei rona'aida nunumai ba ro'aa labaginaa fei hawera, fei honua ma fei ba lomi ro ma'etoo, mei Haidaa ipowe fanaa ro'ou fei harenua lomi i pedutoo. ");
INSERT INTO wuv_vpl VALUES ("RM2_8","075_2_8","ROM","2","8","8","Ma'uaa a'a ei rona nara'uaiaa ana ro'ou ma ofadugaa fei fa'uaia ma neneraa ei hafelo, rowe tonaa fei dududuana ma fei sibana. ");
INSERT INTO wuv_vpl VALUES ("RM2_9","075_2_9","ROM","2","9","9","I pa'i gutafafeloa ma fi'ia naranara a'a hememea rama'a na bigi'aa ei hafelo'a; do'o rawarawa a'a ei Jew ma hinene, ei Gentile; ");
INSERT INTO wuv_vpl VALUES ("RM2_10","075_2_10","ROM","2","10","10","ma'uaa hini i bigi'aa ei rawani'a, iwe tonaa fei hawerana, honua ma gutafarawania; do'o rawarawa a'a ei Jew ma hinene, ei Gentile. ");
INSERT INTO wuv_vpl VALUES ("RM2_11","075_2_11","ROM","2","11","11","Uaa mei Haidaa, lo'e na pa'i papa'aa ununa. ");
INSERT INTO wuv_vpl VALUES ("RM2_12","075_2_12","ROM","2","12","12","Minaa ei rona bigi'aa ei hafelo'a ma lomi rona pa'i fei law, fa'ua lomi rona pa'i fei law, ma'uaa ana rowe ma'e. Ma minaa ei rona pa'i fei law, ana iwe dududuaa ro'ou fei law. ");
INSERT INTO wuv_vpl VALUES ("RM2_13","075_2_13","ROM","2","13","13","Uaa abaa ena rona guainaa fei law, ena rona wanewane pudaa mei Haidaa, ma'uaa ena rona neneraa fei law, iwe ware ba rona wanewane. ");
INSERT INTO wuv_vpl VALUES ("RM2_14","075_2_14","ROM","2","14","14","(Hi'i, ei Gentile lomi rona pa'i fei law, ma'uaa nabaa rona bigi'uanaa ei naranaraa ro'ou ma ei bigi'aa ro'ou na neneraa fei law, fa'ua ba lomi rona pa'i fei law, ma'uaa rona fanunupa'aa tamanu na rawani ba ro'aa bigi'ia, ");
INSERT INTO wuv_vpl VALUES ("RM2_15","075_2_15","ROM","2","15","15","uaa rona fama'aia ba tamanu fei i neneraa fei law na ne'idii laloo iaa ro'ou ma ei naranaraa ro'ou, ina fama'aiaa ro'ou ma warefanaa ro'ou ba ei bigi'aa ro'ou, na tata, o na wanewane.) ");
INSERT INTO wuv_vpl VALUES ("RM2_16","075_2_16","ROM","2","16","16","Ma ei manumanu ei, iwe nomai a'a fei arewaa i umuinaa mei Haidaa Jesus Christ ei na dududuaa ei opa'aiaa naranaraa ei rama'a. Ma fei, iwe bigi'ia ana ale'ei fei nafane wareia laloo fei rawani'a wareau. ");
INSERT INTO wuv_vpl VALUES ("RM2_17","075_2_17","ROM","2","17","17","Ma yoi, nabaa ona ware ba yoi hemea Jew ma nara ba o neneraa fei law ma ona mamagugu ba ona rawani pudaa mei Haidaa ");
INSERT INTO wuv_vpl VALUES ("RM2_18","075_2_18","ROM","2","18","18","ma nabaa ona apa'aa fei nunumiana ma aida ba tamanu na wanewane, uaa ina feroinio fei law ");
INSERT INTO wuv_vpl VALUES ("RM2_19","075_2_19","ROM","2","19","19","ma nabaa ona nara ba yoi hemea talaidugaa ei pudawerai, ale'ena ramai ena ro'ou dupuaa fei roromaa, ");
INSERT INTO wuv_vpl VALUES ("RM2_20","075_2_20","ROM","2","20","20","ba yoi hemea feroiaa ei poapoa, hemea feroiaa ei baduu pusu'o ua, hamatee ona pa'i fei law ma lalona na pa'i apa'a ma fa'uaia ");
INSERT INTO wuv_vpl VALUES ("RM2_21","075_2_21","ROM","2","21","21","ma yoi, mena ona feroinaa hefi'a—haa, lomi ona feroinaa ana yoi? Ma yoi mena, ona u'u ba hefi'adiai, ronei'aa fafanao—haa, lomi ona fafanao? ");
INSERT INTO wuv_vpl VALUES ("RM2_22","075_2_22","ROM","2","22","22","Yoi, mena ona ware ba ei rama'a, ronei'aa fiharoharoipa'ai—haa, lomi ona bigi'ia? Ma yoi, mena ona bidibidi unumu a'a ei haidaa sifisifi—haa, lomi ona losuinaa hefi'a haidaa sifisifi? ");
INSERT INTO wuv_vpl VALUES ("RM2_23","075_2_23","ROM","2","23","23","Yoi, mena ona mamagugu a'a fei law—haa, lomi ona bigifafelo i pudaa mei Haidaa ei ona barafeaa fei law? ");
INSERT INTO wuv_vpl VALUES ("RM2_24","075_2_24","ROM","2","24","24","Ale'ei ei ne'aia: “Ei Gentile, rona fafeloaa fei haraa mei Haidaa, uaa fafaiaa hamu'odu.” ");
INSERT INTO wuv_vpl VALUES ("RM2_25","075_2_25","ROM","2","25","25","Fei moro'aa hudii wawanei na pa'i hanuna nabaa ona neneraa fei law, ma'uaa nabaa ona barafeaa fei law, yoi, ale'ena lomi ona moro'aa hudii wawaneimu. ");
INSERT INTO wuv_vpl VALUES ("RM2_26","075_2_26","ROM","2","26","26","Nabaa ena lomi rona moro'aa hudii wawanei ma rona neneraa fei law, tawi'aa ro'ou ale'ena ena rona moro'aa hudii wawanei? ");
INSERT INTO wuv_vpl VALUES ("RM2_27","075_2_27","ROM","2","27","27","Mei lomi napa'aa moro'aa hudii wawaneina, ma'uaa na neneraa fei law, fei maumauna na fama'aia ba ona tata. Yoi na pa'i fei ne'aia ma moro'aa hudii wawanei, ma'uaa ona hafelo uaa ona barafeaa fei law. ");
INSERT INTO wuv_vpl VALUES ("RM2_28","075_2_28","ROM","2","28","28","Nabaa nemea na moro'aa hudii wawaneina, a'a ba hanuna ba hia Jew. Ma fei pa'aa moro'aa hudii wawanei, abaa manumanuu augu, hamatee manumanuu laloo ia. ");
INSERT INTO wuv_vpl VALUES ("RM2_29","075_2_29","ROM","2","29","29","Agia, hemea rama'a, hia Jew i laloo iana; ma fei moro'aa hudii wawanei, manumanuu laloo iana, bigi'aa fei Spiriti, a'a ba manumanuu fei ne'aia. Ei rama'a ale'ei, mei Haidaa, i uduginaa ro'ou ma abaa udugiaa rama'a. ");
INSERT INTO wuv_vpl VALUES ("RM3_1","075_3_1","ROM","3","1","1","I pa'i tamanu rawani'ana nabaa hemea, hia Jew, o nabaa hemea na moro'aa hudii wawaneina? ");
INSERT INTO wuv_vpl VALUES ("RM3_2","075_3_2","ROM","3","2","2","Hi'i, na pa'i baua rawani'ana! Fei rawani'ana sifei ba mei Haidaa na faninaa panii ro'ou ei wareana. ");
INSERT INTO wuv_vpl VALUES ("RM3_3","075_3_3","ROM","3","3","3","Ma nabaa hefi'a lomi na we'i naranaraa ro'ou—fei ba lomi na we'i naranaraa ro'ou, hanuna ba mei Haidaa, lomi na oafagugu? ");
INSERT INTO wuv_vpl VALUES ("RM3_4","075_3_4","ROM","3","4","4","Pa'aa lomi! Mei Haidaa, hia fa'ua ma ei rama'a, ro'ou, sifisifi. Ale'ei ei ne'aia: Ba ro'aa ma'aia ba tamanu ona wareia, ina fa'uai ma ona mua ei ona fadududu.” ");
INSERT INTO wuv_vpl VALUES ("RM3_5","075_3_5","ROM","3","5","5","Ma'uaa, nabaa fei maumau o'ou, fei lomi na wanewane i fa'arewaia ba fei maumau mei Haidaa na rawani ua, o'aa ware ba lomi na wanewane ba fei sibana na dinaa a'a o'ou? (U'ei wareaa ei mau naranaraa ei rama'a e'eni.) ");
INSERT INTO wuv_vpl VALUES ("RM3_6","075_3_6","ROM","3","6","6","Pa'aa lomi! Nabaa ale'ei, batanai ba mei Haidaa i dududuaa feni malagufu? ");
INSERT INTO wuv_vpl VALUES ("RM3_7","075_3_7","ROM","3","7","7","Woro hemea i ware ba, “Nabaa fei mau sifisifiu na fama'aia ba fei maumau mei Haidaa napa'aa fa'uai ma si'ei na fagipeaa fei harana, tani ei ba ana fi hafelo yau?” ");
INSERT INTO wuv_vpl VALUES ("RM3_8","075_3_8","ROM","3","8","8","Hefi'adiai, rona u'ufafeloaa hai'ou ba hai'ounadii wareia ba, “Onei bigi'aa ei hafelo'a ba nei pa'i rawani'a wagina”. Ro'aa pa'aa aree ro'ou. ");
INSERT INTO wuv_vpl VALUES ("RM3_9","075_3_9","ROM","3","9","9","O fapo'ai batanainia fei? Fei maumau o'ou na rawanidiai a'a fei maumau ro'ou? Pa'aa lomi! Ona waredii ba ei Jew ma ei Gentile, rona fimina'ei, uaa minaa ro'ou, rona pa'i hafelo'a. ");
INSERT INTO wuv_vpl VALUES ("RM3_10","075_3_10","ROM","3","10","10","Ale'ei fei ne'aia: Lomi hemea na wanewane, pa'aa lomi hemea; ");
INSERT INTO wuv_vpl VALUES ("RM3_11","075_3_11","ROM","3","11","11","“lomi hemea na apa'ia, lomi hemea i labaginaa mei Haidaa. ");
INSERT INTO wuv_vpl VALUES ("RM3_12","075_3_12","ROM","3","12","12","Minaa ei, rona ofadugia, minaa ro'ou peduga, lomi haraa ro'ou; lomi hemea i bigifarawani, pa'aa lomi hemea.” ");
INSERT INTO wuv_vpl VALUES ("RM3_13","075_3_13","ROM","3","13","13","“Ei ono'onoo ro'ou, ale'ena huapu; rafee ei rawerawee ro'ou, ware sifisifi.” Fei siafaa ei wa'a na ude i bigibigii umuu ro'ou.” ");
INSERT INTO wuv_vpl VALUES ("RM3_14","075_3_14","ROM","3","14","14","“Ei umuu ro'ou, namina pepesu a'a fei umua ma ei para'aa.” ");
INSERT INTO wuv_vpl VALUES ("RM3_15","075_3_15","ROM","3","15","15","“Ei pinee ro'ou na maduare ba ro'aa fo'afawigii namo; ");
INSERT INTO wuv_vpl VALUES ("RM3_16","075_3_16","ROM","3","16","16","“rona fafeloaa ei rama'a ma fani fi'iaa ro'ou ");
INSERT INTO wuv_vpl VALUES ("RM3_17","075_3_17","ROM","3","17","17","ma fei talaa gutafarawania, lomi rona aida.” ");
INSERT INTO wuv_vpl VALUES ("RM3_18","075_3_18","ROM","3","18","18","“Lomi rona ma'auaa mei Haidaa.” ");
INSERT INTO wuv_vpl VALUES ("RM3_19","075_3_19","ROM","3","19","19","Ma ona aida ba tamanu na wareia fei law, fi wareia a'a ei rona neneraa fei law ba minaa ei rama'a, ro'aa famadumu ma minaa ei tadiwe'ai, ro'aa ufalarai a'a fei dududuaa mei Haidaa. ");
INSERT INTO wuv_vpl VALUES ("RM3_20","075_3_20","ROM","3","20","20","Si'ei, i pudana, lomi hemea ba i wanewane hamatee ina neneraa fei law; ma'uaa a'a fei law, ona aida ba o'ou, hafelo'a. ");
INSERT INTO wuv_vpl VALUES ("RM3_21","075_3_21","ROM","3","21","21","Ma'uaa e'eni nawe arewa fei wanewanea noranarai a'a mei Haidaa ma abaa a'a fei law, fei rona u'ugia ei mamama'a mawe fei law. ");
INSERT INTO wuv_vpl VALUES ("RM3_22","075_3_22","ROM","3","22","22","Feni wanewanea noranarai a'a mei Haidaa, i nomai a'a fei narafawe'ia ma i dinaa a'a minaa ei rona narafawe'i a'a Jesus Christ. Lomi hemea na u'ugai, ");
INSERT INTO wuv_vpl VALUES ("RM3_23","075_3_23","ROM","3","23","23","uaa minaa o'ou, hafelo'a ma ona tauhafo a'a fei haweraa mei Haidaa, ");
INSERT INTO wuv_vpl VALUES ("RM3_24","075_3_24","ROM","3","24","24","ma'uaa ona to'uaiaa fei wanewanea wagii fei rawani'ana fininaa fei ponohadiwe'ia, fei nomai a'a Christ Jesus. ");
INSERT INTO wuv_vpl VALUES ("RM3_25","075_3_25","ROM","3","25","25","Mei Haidaa na fania ale'ena ba a'a fei ma'eana, lomi manumanu watolaa o'ou ma mei Haidaa uaa fei we'iaa naranara wagii fei namona. Ina bigi'aa fei ba i fama'aa ei na wanewane a'ana, uaa a'a fei ofasi'ana, itawe dududuaa ei hafelo'a ona bigi'ia mina— ");
INSERT INTO wuv_vpl VALUES ("RM3_26","075_3_26","ROM","3","26","26","ina bigi'ia ba i fama'aa ei na wanewane a'ana e'eni, uaa hia na wanewane ma ana mei i fawanewaneaa ei na we'i naranaraa ro'ou a'a Jesus. ");
INSERT INTO wuv_vpl VALUES ("RM3_27","075_3_27","ROM","3","27","27","Pa'aa lomi pa'afii fei mamaguguaa o'ou. Uatani? Lomi na hawia ba o'aa wanewane nabaa o'aa neneraa fei law, ma'uaa nabaa i we'i fei naranara, ina hawia. ");
INSERT INTO wuv_vpl VALUES ("RM3_28","075_3_28","ROM","3","28","28","Uaa, ona ware ba hemea rama'a na wanewane a'a fei we'iaa naranarana ma a'a ba i neneraa fei law. ");
INSERT INTO wuv_vpl VALUES ("RM3_29","075_3_29","ROM","3","29","29","Mei Haidaa, hia Haidaniaa ei Jew ua? Haa—abaa hia ana Haidaniaa ei Gentile? Hi'i, ei Gentile anaa, ");
INSERT INTO wuv_vpl VALUES ("RM3_30","075_3_30","ROM","3","30","30","uaa na pa'i hemea ua Haidaa, mei i fawanewaneaa ei rona moro'aa hudii wawanei wagii fei narafawe'ia mawe ei lomi rona moro, wagii ana fei narafawe'ia. ");
INSERT INTO wuv_vpl VALUES ("RM3_31","075_3_31","ROM","3","31","31","Fei warea fei, pa'afina ba lomi hanuna fei law, hamatee fei we'iaa naranara? Pa'aa lomi! Ma'uaa agia, oi neneraa fei law. ");
INSERT INTO wuv_vpl VALUES ("RM4_1","075_4_1","ROM","4","1","1","A'a fei manumanu fei, o'aa ware batanai a'a Abraham, mei upuu o'ou? ");
INSERT INTO wuv_vpl VALUES ("RM4_2","075_4_2","ROM","4","2","2","Nabaa fa'ua ba Abraham na wanewane a'a ei bigi'ana, ina pa'i pa'afina ba i mamagugu, ma'uaa a'a ba i pudaa mei Haidaa. ");
INSERT INTO wuv_vpl VALUES ("RM4_3","075_4_3","ROM","4","3","3","Fei Bu'u Apuna na ware batanai? “Abraham na narafawe'i a'a mei Haidaa ma a'a fei, ina wanewane.” ");
INSERT INTO wuv_vpl VALUES ("RM4_4","075_4_4","ROM","4","4","4","Ma nabaa nemea i bigibigi, fei pono'ana abaa ale'ei fana, uaa nei pa'i pono'ana. ");
INSERT INTO wuv_vpl VALUES ("RM4_5","075_4_5","ROM","4","5","5","Ma'uaa a'a mei lomi na bigi, ma na narafawe'i a'a mei Haidaa, mei fawanewanea uaa fei we'iaa naranarana, mei Haidaa na tenia ba hia, na wanewane. ");
INSERT INTO wuv_vpl VALUES ("RM4_6","075_4_6","ROM","4","6","6","Ana ale'ei ei wareaa David ei i u'ugaa fei hawegiaa ei rama'a lomi rona bigibigi ma'uaa mei Haidaa na fawanewane'uaiaa ro'ou: ");
INSERT INTO wuv_vpl VALUES ("RM4_7","075_4_7","ROM","4","7","7","“Ni'eni'ea a'a ena ina futoaa ei hafelo'aa ro'ou, ena na hawaipa'ai ei hafelo'aa ro'ou. ");
INSERT INTO wuv_vpl VALUES ("RM4_8","075_4_8","ROM","4","8","8","Ni'eni'ea a'a mei lomi iwe nonominaa ei hafelo'ana mei Fasu.” ");
INSERT INTO wuv_vpl VALUES ("RM4_9","075_4_9","ROM","4","9","9","Fei hawegia fei, na ude a'a ei rona moro'aa hudii wawanei ua, o ei lomi rona moro anaa? Ona ware ba fei we'iaa naranaraa Abraham, sifei fei na fawanewaneia. ");
INSERT INTO wuv_vpl VALUES ("RM4_10","075_4_10","ROM","4","10","10","Batanai ba hia na wanewane ale'ei? Ina wanewane nenee fei i moro'aa hudii wawaneina, o ei atawe moro'ia? A'a ba ina wanewane nenee fei, uaa do'o rawarawa. ");
INSERT INTO wuv_vpl VALUES ("RM4_11","075_4_11","ROM","4","11","11","Ma ina tonaa fei hilalaa moro'a ba i fama'aia ba ina wanewanedii a'a fei we'iaa naranarana ma nawe moro'aa hudii wawaneina. Si'ei, hia amaa minaa ei rona narafawe'i ma'uaa lomi rona moro'aa hudii wawanei ba ronei tonaa fei wanewanea. ");
INSERT INTO wuv_vpl VALUES ("RM4_12","075_4_12","ROM","4","12","12","Ma hia ana amaa ei rona moro'aa hudii wawanei ma'uaa, ei rama'a ei, lomi rona moro ua, ana rona narafawe'i ana ale'ei mei amaa o'ou Abraham ei i narafawe'i ma atawe moro. ");
INSERT INTO wuv_vpl VALUES ("RM4_13","075_4_13","ROM","4","13","13","Abaa wagii fei law ba Abraham ma ei paina, rona tonaa fei fa'unaia ba hinene, hia, i tonaa feni malagufu, ma'uaa na tonia a'a fei wanewanea, fei i nofininamii fei we'iaa naranara. ");
INSERT INTO wuv_vpl VALUES ("RM4_14","075_4_14","ROM","4","14","14","Uaa, nabaa ei rona neneraa fei law, ro'aa tonaa feni malagufu, fei we'iaa naranara, lo'e hanuna ma fei fa'unaia, ana lomi awatana, ");
INSERT INTO wuv_vpl VALUES ("RM4_15","075_4_15","ROM","4","15","15","uaa a'a fei law, i nofininamii fei sibana. Ma nabaa lo'e law, ana lomi barafea. ");
INSERT INTO wuv_vpl VALUES ("RM4_16","075_4_16","ROM","4","16","16","Si'ei, fei fa'unaia i nofininamii fei we'iaa naranara ba i nomai a'a fei rawani'a fanaa mei Haidaa ma na hawia ba ro'aa tonia minaa ei pai Abraham abaa a'a unaa ei rona neneraa fei law, ma'uaa a'a ei rona pa'i fei we'iaa naranara ale'ei Abraham anaa. Hia mei amaa minaa o'ou. ");
INSERT INTO wuv_vpl VALUES ("RM4_17","075_4_17","ROM","4","17","17","Ana ale'ei fei ne'aia: “Una augio ale'ei amaa watauda baua gufu.” Hia amaa o'ou i pudaa mei Haidaa, mei hia na narafawe'i, ana mei na fani harenua a'a ei ma'ea, mei i augaa ei manumanu lomi inado'o ude mina. ");
INSERT INTO wuv_vpl VALUES ("RM4_18","075_4_18","ROM","4","18","18","Lomi pa'afina ba i fa'o'oninaa ununa, ma'uaa Abraham na o'onai ununa ma narafawe'i ma idii, pawe hia amaa watauda baua gufu ana ale'ei i fa'unai a'ana ba, “Ana ale'ei, owe pa'i watauda na'umu.” ");
INSERT INTO wuv_vpl VALUES ("RM4_19","075_4_19","ROM","4","19","19","Ina fanunupa'ia ba fei ununa ale'ei unuu ma'ea, uaa ina pa'i hefa pu'u igisimasina, ma'uaa lomi na adudu fei we'iaa naranarana. Ma ana ina aida ba fei watau Sarah ana ale'ei ma'ea. ");
INSERT INTO wuv_vpl VALUES ("RM4_20","075_4_20","ROM","4","20","20","Lomi na adudu fei we'iaa naranarana a'a fei fa'unaiaa mei Haidaa, ma'uaa ina fawe'iaa fei naranarana ma uduginaa mei Haidaa ");
INSERT INTO wuv_vpl VALUES ("RM4_21","075_4_21","ROM","4","21","21","ma namina narafawe'i ba mei Haidaa na pa'i faufauna ba i bigi'aa tamanu na fa'unainia. ");
INSERT INTO wuv_vpl VALUES ("RM4_22","075_4_22","ROM","4","22","22","Sifei, fei pa'afina ba hia na wanewane. ");
INSERT INTO wuv_vpl VALUES ("RM4_23","075_4_23","ROM","4","23","23","Fei warea ba “hia na wanewane” a'a ba warea a'ana ua, ");
INSERT INTO wuv_vpl VALUES ("RM4_24","075_4_24","ROM","4","24","24","ma'uaa a'a o'ou anaa, mei Haidaa iwe fawanewaneaa hini o'ou na narafawe'i a'a mei na fa'asi'anaa mei Fasuu o'ou Jesus a'a fei ma'ea. ");
INSERT INTO wuv_vpl VALUES ("RM4_25","075_4_25","ROM","4","25","25","Ina fifaninia wagii fei ma'ea, uaa ei hafelo'aa o'ou ma fa'asi'ania ba o'aa wanewane. ");
INSERT INTO wuv_vpl VALUES ("RM5_1","075_5_1","ROM","5","1","1","Si'ei ba ona wanewanedii wagii fei we'iaa naranara, ona gutafarawani a'a mei Haidaa uaa mei Fasuu o'ou Jesus Christ, ");
INSERT INTO wuv_vpl VALUES ("RM5_2","075_5_2","ROM","5","2","2","mei na ugainaa o'ou a'a fei we'iaa naranara ba onei wadu'ainaa a'a fei rawani'a, fei ona oa i wagina eni. Ma ona ni'eni'e a'a fei o'onaia unu ba o'aa oafipui a'a fei haweraa mei Haidaa. ");
INSERT INTO wuv_vpl VALUES ("RM5_3","075_5_3","ROM","5","3","3","Ma'uaa ana ona ni'eni'e a'a ei fi'iaa o'ou, uaa ona aida ba ei fi'ia, ipowe fanoramii fei ba onei utauai ");
INSERT INTO wuv_vpl VALUES ("RM5_4","075_5_4","ROM","5","4","4","ma fei ba o utauai, i bigi'aa fei rawani'a maumau ma fei rawani'a maumau, i bigi'aa fei o'onaia unu. ");
INSERT INTO wuv_vpl VALUES ("RM5_5","075_5_5","ROM","5","5","5","Ma fei o'onaia unu, lomi ba o fa'adudu wagina, uaa namina bauana fei haguaa mei Haidaa, fei na augia i laloo iaa o'ou fei Spiriti Apuna, fei ina fanaa o'ou. ");
INSERT INTO wuv_vpl VALUES ("RM5_6","075_5_6","ROM","5","6","6","Uaa a'a fei pa'aa au, a'a fei au lomi faufau o'ou, Christ na ma'e ba i tohadiwe'inaa o'ou, uaa ona hafelo. ");
INSERT INTO wuv_vpl VALUES ("RM5_7","075_5_7","ROM","5","7","7","Pa'aa lomi hememea ba iwe ma'e ba i hadumaa hemea wanewanea rama'a, ma'uaa woro hemea i ma'e ba i hadumaa hemea rawani'a. ");
INSERT INTO wuv_vpl VALUES ("RM5_8","075_5_8","ROM","5","8","8","Ma'uaa mei Haidaa na fama'aa o'ou fei haguana a'a feni: ei ana oi oa laloo ei hafelo'a, Christ na todigaa o'ou a'a fei ma'eana. ");
INSERT INTO wuv_vpl VALUES ("RM5_9","075_5_9","ROM","5","9","9","Si'ei ba ona wanewanedii a'a fei namona, ana i a'ana napa'aa fa'ua ba ona tela a'a fei sibaa mei Haidaa! ");
INSERT INTO wuv_vpl VALUES ("RM5_10","075_5_10","ROM","5","10","10","Uaa, hamatee ina fa'ua ba ei i pa'i watolaa o'ou ma mei Haidaa, mei na'una, wagii fei ma'eana na fawanewaneaa o'ou a'a mei Amana. Ma si'ei ba lomi watolaa o'ou ma mei Haidaa napa'aa fa'ua ba ona tela uaa fei harenuaa mei na'una! ");
INSERT INTO wuv_vpl VALUES ("RM5_11","075_5_11","ROM","5","11","11","Ma hepalodiai, a'a mei Fasuu o'ou Jesus Christ, mei na fawanewaneaa watolaa o'ou ma mei Haidaa, i a'ana, ona ni'eni'e a'a mei Haidaa. ");
INSERT INTO wuv_vpl VALUES ("RM5_12","075_5_12","ROM","5","12","12","Si'ei, ei hafelo'a na nomai i malagufu a'a hemea rama'a ma fei ma'ea na nomai wagii ei hafelo'a ma ana ale'ei, fei ma'ea na nomai a'a minaa ei rama'a, uaa minaa ei, rona bigi'aa ei hafelo'a— ");
INSERT INTO wuv_vpl VALUES ("RM5_13","075_5_13","ROM","5","13","13","uaa, ei atawe pa'i fei law, na udedii ei hafelo'a yeni malagufu. Ma'uaa ei hafelo'a, lomi na pa'i dududuana nabaa lomi na pa'i law. ");
INSERT INTO wuv_vpl VALUES ("RM5_14","075_5_14","ROM","5","14","14","Ma'uaa fei ma'ea, hepalo baua manumanu a'a fei au Adam ama'anaa fei au Moses, ana a'a ei lomi rona barafeaa hepalo warea, ale'ei fei bigi'aa Adam, mei hia, haduoo mei ba i nomai. ");
INSERT INTO wuv_vpl VALUES ("RM5_15","075_5_15","ROM","5","15","15","Ma'uaa fei fana abaa ale'ei fei barafea. Uaa, si'ei ba watauda, rona ma'e a'a fei barafeaa hemea ua rama'a, ana napa'aa fa'ua ba fei rawani'aa mei Haidaa ma fei fana, fei na nomai a'a hemea ua rama'a, Jesus Christ, na hawainaa watauda! ");
INSERT INTO wuv_vpl VALUES ("RM5_16","075_5_16","ROM","5","16","16","A warediai ba fei fanaa mei Haidaa abaa ale'ei fei aree ei hafelo'aa mei rama'a mei: Fei dududua na neneraa hepalo hafelo'a ma na notomai fagianaa, ma'uaa fei fana na neneraa watauda barafea ma na notomai wanewanea. ");
INSERT INTO wuv_vpl VALUES ("RM5_17","075_5_17","ROM","5","17","17","Uaa a'a fei barafeaa hemea ua rama'a, fei ma'ea na nogipelao a'a mei rama'a mei ma si'ei, ana napa'aa fa'ua ba a'a ena rona tonaa fei baua rawani'aa mei Haidaa ma fei fana ba ro'aa wanewane a'a mei Haidaa, rowe pa'i harenua a'a hemea ua rama'a, Jesus Christ. ");
INSERT INTO wuv_vpl VALUES ("RM5_18","075_5_18","ROM","5","18","18","Si'ei ba hepalo ua barafea na notonamii fei fagianaa minaa ei rama'a, ana ale'ei, hepalo ua rawani'a bigi'a, fei fawanewanea, na fani harenua a'a minaa ei rama'a. ");
INSERT INTO wuv_vpl VALUES ("RM5_19","075_5_19","ROM","5","19","19","Uaa a'a fei barafeaa hemea ua rama'a, watauda rama'a rona hafelo, ana ale'ei, a'a fei rawani'a bigi'aa hemea ua rama'a, watauda, ro'aa wanewane. ");
INSERT INTO wuv_vpl VALUES ("RM5_20","075_5_20","ROM","5","20","20","Fei law na nomai ba ei barafea nei nogipelao. Ma'uaa i nogipelao ei barafea, fei rawani'aa mei Haidaa, ana fi gipedilao ");
INSERT INTO wuv_vpl VALUES ("RM5_21","075_5_21","ROM","5","21","21","ma ana ale'ei ba ei hafelo'a na nogipelao fininaa fei ma'ea, ana ale'ei, fei rawani'a fanaa mei Haidaa nei nogipedilao a'a fei wanewanea ba nei fani fei harenua lomi i pedutoo, fei i nomai a'a Jesus Christ mei Fasuu o'ou. ");
INSERT INTO wuv_vpl VALUES ("RM6_1","075_6_1","ROM","6","1","1","O ware batanai—o bigi'uaialao ei hafelo'a ba fei rawani'a nei bauanaidiai? ");
INSERT INTO wuv_vpl VALUES ("RM6_2","075_6_2","ROM","6","2","2","Pa'aa lo'e! Ona ma'edii a'a ei hafelo'a; hee, o'aa gutabatanaidilao wagina? ");
INSERT INTO wuv_vpl VALUES ("RM6_3","075_6_3","ROM","6","3","3","Haa, lomi hamona aida ba minaa o'ou eni ona pudugufai a'a Christ Jesus, ona pudugufaifipui a'a fei ma'eana? ");
INSERT INTO wuv_vpl VALUES ("RM6_4","075_6_4","ROM","6","4","4","Si'ei, ona ma'e ma i'ifaifipui a'ana wagii fei pudugufaia ba ana ale'ei Christ na asi'aa a'a fei ma'ea fininaa fei haweraa mei Ama ma o'ou anaa, o'aa guta a'a fei manufau harenua. ");
INSERT INTO wuv_vpl VALUES ("RM6_5","075_6_5","ROM","6","5","5","Ma nabaa ona panafipui a'ana a'a fei ma'eana, napa'aa fa'ua ba o'aa panafipui a'ana wagii fei asi'anana. ");
INSERT INTO wuv_vpl VALUES ("RM6_6","075_6_6","ROM","6","6","6","Uaa, ona aida ba fei maumau o'ou mina na fatawafipui a'ana ba ei hafelo'aa hudi unu nei pa'ai wagina ba lomidiai o'aa humuwai a'a ei hafelo— ");
INSERT INTO wuv_vpl VALUES ("RM6_7","075_6_7","ROM","6","7","7","uaa hini na ma'e na ala a'a ei hafelo'a. ");
INSERT INTO wuv_vpl VALUES ("RM6_8","075_6_8","ROM","6","8","8","Ma nabaa ona ma'efipui a'a Christ, ona aida ba opowe oafipui a'ana. ");
INSERT INTO wuv_vpl VALUES ("RM6_9","075_6_9","ROM","6","9","9","Uaa ona aida ba hamatee Christ na asi'aa a'a fei ma'ea, lomi ba i ma'ediai. Fei ma'ea, lomi na fai famamoia. ");
INSERT INTO wuv_vpl VALUES ("RM6_10","075_6_10","ROM","6","10","10","Fei ma'ea, fei ina ma'e wagina, ina ma'e ba i fapedugaa ei hafelo'a hepoa ua ma lomidiai; ma'uaa fei harenua, fei hia na pa'i, na oafipui a'a mei Haidaa. ");
INSERT INTO wuv_vpl VALUES ("RM6_11","075_6_11","ROM","6","11","11","Ana ale'ei, hamonei nara ba hamona ma'edii a'a ei hafelo'a, ma'uaa hamona pa'i harenua a'a mei Haidaa uaa Christ Jesus. ");
INSERT INTO wuv_vpl VALUES ("RM6_12","075_6_12","ROM","6","12","12","Si'ei, a'a ei hafelo'a, apuna fafeloaa ei unuu hamu'ou, ei hudi unuu ma'ea ba hamo'aa neneraa ei hafelo'a nunumiaa ei unuu hamu'ou. ");
INSERT INTO wuv_vpl VALUES ("RM6_13","075_6_13","ROM","6","13","13","Apuna fanaa ei hudi unuu hamu'ou a'a ei hafelo'a ba o biginaa ei hafelo'a wagina, ma'uaa hamonei fanaa ana hamu'ou a'a mei Haidaa, ale'ena ei rona wala'aa a'a fei ma'ea ma oa a'a ei rona werawera; ma hamonei fanaa ei unuu hamu'ou a'ana ba i biginaa ei wanewanea. ");
INSERT INTO wuv_vpl VALUES ("RM6_14","075_6_14","ROM","6","14","14","Uaa ei hafelo'a, lomi i famamoaa hamu'ou uaa abaa hamu'ou panii fei law, uaa hamu'ou panii fei rawani'a. ");
INSERT INTO wuv_vpl VALUES ("RM6_15","075_6_15","ROM","6","15","15","Tamanu naranaraa hamu'ou? O bigi'aa ei hafelo'a uaa abaa o'ou panii fei law, ma'uaa o'ou panii fei rawani'a? Pa'aa lomi! ");
INSERT INTO wuv_vpl VALUES ("RM6_16","075_6_16","ROM","6","16","16","Haa, lomi hamona apa'ia ba nabaa hamona ugainaa hemea ba hamu'ou humuwana, hamu'ou humuwaa mena hamona guainia? Nabaa hamu'ou humuwaa ei hafelo'a, i notonaa hamu'ou a'a fei ma'ea. Nabaa hamu'ou humuwaa fei guaiawarea, i fani harenua a'a hamu'ou. ");
INSERT INTO wuv_vpl VALUES ("RM6_17","075_6_17","ROM","6","17","17","Ma'uaa pa'aa ware ‘ta’ a'a mei Haidaa ba hamonado'o humuwai a'a ei hafelo'a, ma'uaa hamonawemina guaipa'aa fei mau feferoi, fei na ude panii hamu'ou. ");
INSERT INTO wuv_vpl VALUES ("RM6_18","075_6_18","ROM","6","18","18","Hamona ala a'a ei hafelo'a ma humuwai a'a fei wanewanea. ");
INSERT INTO wuv_vpl VALUES ("RM6_19","075_6_19","ROM","6","19","19","A ware ale'ei mau wareaa rama'a, uaa hamona rafilele a'a ei unuu hamu'ou, ana ale'ei mina, ei hamona'aida fanaa ei unuu hamu'ou a'a ei lomi na fafa'arai ba ei hafelo'a i nogipelao, ale'ei ba hamu'ou humuwai wagina. Si'ei, e'eni hamonei fanaa ei unuu hamu'ou a'a fei wanewanea, fei i notonaa hamu'ou a'a tamanu ina fafa'arai ba hamu'ou humuwai wagina. ");
INSERT INTO wuv_vpl VALUES ("RM6_20","075_6_20","ROM","6","20","20","Ei hamu'ou humuwai a'a ei hafelo'a, hamona ala a'a fei famamoaa fei wanewanea. ");
INSERT INTO wuv_vpl VALUES ("RM6_21","075_6_21","ROM","6","21","21","Tamanu rawani'ana hamo'aa tonia e'eni wagii ei bigi'aa hamu'ou na famamafa mina? Ei manumanu ei, pono'ana, ma'ea. ");
INSERT INTO wuv_vpl VALUES ("RM6_22","075_6_22","ROM","6","22","22","Ma'uaa, si'ei ba hamona ala a'a ei hafelo'a e'eni ma hamonawe humuwai a'a mei Haidaa, fei fua wagina, fafa'araia ma i dinaa a'a fei harenua lomi i pedutoo. ");
INSERT INTO wuv_vpl VALUES ("RM6_23","075_6_23","ROM","6","23","23","Uaa pono'aa ei hafelo'a, ma'ea. Ma'uaa fei fanaa mei Haidaa, harenua lomi i pedutoo, fei i norai a'a Christ Jesus, mei Fasuu o'ou. ");
INSERT INTO wuv_vpl VALUES ("RM7_1","075_7_1","ROM","7","1","1","Ena lofuu, haa—lomi hamona aida ba fei law i famamoaa hemea nopa'aloo fei ma'eana (uaa, u'ei warenaa a'a ena rona apa'aa fei law)? ");
INSERT INTO wuv_vpl VALUES ("RM7_2","075_7_2","ROM","7","2","2","A fa'arewaia ale'ei ba wagii fei law, nabaa hemea pifine na pa'i harona, inei gutafipui a'a mei harona nopa'aloo fei ma'eana, ma'uaa nabaa mei haroo mei pifine na ma'e, ina ala a'a fei law lalaia. ");
INSERT INTO wuv_vpl VALUES ("RM7_3","075_7_3","ROM","7","3","3","Si'ei, nabaa ina lalainaa hemeadiai wawane, ei ana fi werawera harona, rona ware ba hia, na fiharoharoipa'ai. Ma'uaa nabaa ina ma'e mei harona, hia na ala a'a fei law lalaia ma a'a ba ina fiharoharoipa'ai nabaa ina lalainaa hemeadiai wawane. ");
INSERT INTO wuv_vpl VALUES ("RM7_4","075_7_4","ROM","7","4","4","Si'ei, ena lofuu, ana hamona ma'edii a'a fei law uaa fei hudi unuu Christ ba hamonei oafipui a'a hemeadiai—mei na asi'aa a'a fei ma'ea ba onei fuaa a'a mei Haidaa. ");
INSERT INTO wuv_vpl VALUES ("RM7_5","075_7_5","ROM","7","5","5","Uaa ei i famamoaa o'ou fei maumau hafelo'a, fei law na fa'asi'anaa fei hafelo'a maumau o'ou, hee, ona tonaa fei fuaa fei ma'ea. ");
INSERT INTO wuv_vpl VALUES ("RM7_6","075_7_6","ROM","7","6","6","Ma'uaa e'eni, nabaa o ma'e a'a ei na o panarofaa o'ou mina, ona ala a'a fei law ba o neneraa fei manufau talaa fei Spiriti ma a'a ba ale'ei fei watanai talaa fei law. ");
INSERT INTO wuv_vpl VALUES ("RM7_7","075_7_7","ROM","7","7","7","O ware batanai? Hafelo'a fei law? Pa'aa lomi! Nabaa lomi fei law, lomi a apa'ia tamanu na hafelo. Uaa lomi ba a apa'aa hanuu fei nanamaia nabaa lomi na ware fei law ba, “Apuna nanamai.” ");
INSERT INTO wuv_vpl VALUES ("RM7_8","075_7_8","ROM","7","8","8","Ma'uaa a'a fei law, ei hafelo'a na fani tala ba i fanoramiaa watauda mau nanamaia a'au. Uaa, nabaa lomi law, na ma'e ei hafelo'a. ");
INSERT INTO wuv_vpl VALUES ("RM7_9","075_7_9","ROM","7","9","9","Mina, ei lomi law bana'aa po'o sifei, ma'uaa ipowe nomai fei law, ei hafelo'a na asi'aa ma yau na ma'e. ");
INSERT INTO wuv_vpl VALUES ("RM7_10","075_7_10","ROM","7","10","10","Una fanunupa'ia ba ana fei law ua, fei ba i fani harenua, pa'aa sifei fei i fanoramiaa fei ma'ea. ");
INSERT INTO wuv_vpl VALUES ("RM7_11","075_7_11","ROM","7","11","11","Uaa a'a fei law, ei hafelo'a na fani tala ba i sifi'au ma ana fei law na fama'eau. ");
INSERT INTO wuv_vpl VALUES ("RM7_12","075_7_12","ROM","7","12","12","Si'ei, fei law na apunai ma ei warea wagina. Ina wanewane ma rawani. ");
INSERT INTO wuv_vpl VALUES ("RM7_13","075_7_13","ROM","7","13","13","Nabaa ale'ei, hanuna ba fei na rawani i fani ma'ea a'au? Pa'aa lomi! Ma'uaa ba unei fanunu'apa'aa ei na hafelo, una to ma'ea wagii fei law, fei na rawani ba wagina, o aida ba ei hafelo'a napa'aa hafelo. ");
INSERT INTO wuv_vpl VALUES ("RM7_14","075_7_14","ROM","7","14","14","Ona aida ba fei law, manumanuu spiriti; ma'uaa yau, lomi na pa'i fei maumau spiriti. Yau na oa ua ale'ei humuwa a'a ei hafelo'a. ");
INSERT INTO wuv_vpl VALUES ("RM7_15","075_7_15","ROM","7","15","15","Ei unei'aa bigi'ia, lomi na aida ba tani afane bigi'uaia. Uaa, tamanu a nunuminia ba a bigi'ia, lomi na bigi'ia. Ma'uaa ei lomi na nunuminia ba a bigi'ia, una bigi'ia. ");
INSERT INTO wuv_vpl VALUES ("RM7_16","075_7_16","ROM","7","16","16","Ma nabaa a bigi'aa tamanu lomi na nunuminia, una uga ba fei law, ina rawani. ");
INSERT INTO wuv_vpl VALUES ("RM7_17","075_7_17","ROM","7","17","17","Hee, abaa yau una bigi'ia, ma'uaa ei hafelo'a, ei na oa laloo iau. ");
INSERT INTO wuv_vpl VALUES ("RM7_18","075_7_18","ROM","7","18","18","Una aida ba lomi hepalo rawani'a manumanu na oa laloo fei hafelo'a naranarau. Uaa, nunumiau ba a bigi'aa ei rawani'a, ma'uaa lomi na bigi'ia. ");
INSERT INTO wuv_vpl VALUES ("RM7_19","075_7_19","ROM","7","19","19","Uaa, fei bigi'au, abaa fei rawani'a ale'ei nunumiau; agia, ei hafelo'a, ei lomi na nunuminia—una'aida bigi'uaia. ");
INSERT INTO wuv_vpl VALUES ("RM7_20","075_7_20","ROM","7","20","20","Ma nabaa a bigi'aa ei lomi na nunuminia, a'a ba yau na bigi'ia, uaa, bigi'aa ei hafelo'a laloo iau. ");
INSERT INTO wuv_vpl VALUES ("RM7_21","075_7_21","ROM","7","21","21","Si'ei, una fanunupa'ia ba fei maumau bigi'a i ale'ei: Ei una nunuminia ba a bigi'aa ei rawani'a, ei hafelo'a ana na oafipui a'au. ");
INSERT INTO wuv_vpl VALUES ("RM7_22","075_7_22","ROM","7","22","22","Uaa laloo iau, na ni'eni'e a'a fei law mei Haidaa; ");
INSERT INTO wuv_vpl VALUES ("RM7_23","075_7_23","ROM","7","23","23","ma'uaa una fanunupa'aa hefaa maumaudiai fi bigi unuu ma fiforainaa fei naranarau ma fafaiau ba una bobo'ai a'a fei maumau ei hafelo'a, ei na biginaa unuu. ");
INSERT INTO wuv_vpl VALUES ("RM7_24","075_7_24","ROM","7","24","24","Yau, namina faloloa'i! Hini i hadumau a'a feni hudi unuu ma'ea? ");
INSERT INTO wuv_vpl VALUES ("RM7_25","075_7_25","ROM","7","25","25","A ware ‘ta’ a'a mei Haidaa—uaa Jesus Christ, mei Fasuu o'ou! Si'ei, a'a fei naranarau, yau hemea humuwa a'a fei law mei Haidaa, ma'uaa a'a fei hafelo'a maumau, yau humuwa a'a fei law ei hafelo'a. ");
INSERT INTO wuv_vpl VALUES ("RM8_1","075_8_1","ROM","8","1","1","Si'ei, e'eni, lomi i pa'i fagianaa a'a ei rona oafipui a'a Christ Jesus. ");
INSERT INTO wuv_vpl VALUES ("RM8_2","075_8_2","ROM","8","2","2","Uaa, a'a Christ Jesus, fei maumau fei Spiriti, fei i fani harenua, na alarau a'a fei maumau ei hafelo'a ma fei ma'ea. ");
INSERT INTO wuv_vpl VALUES ("RM8_3","075_8_3","ROM","8","3","3","Uaa, tamanu lomi na hawia ba i bigi'ia fei law hamatee na fafafauia fei maumau ei hafelo'a, mei Haidaa na bigi'ia a'a fei aloanarai mei Na'una fininaa hudi unu, ana ale'ei ei hafelo'a rama'a, ei rona pa'i hudi unuu ro'ou. Ma hia, ale'ei hepalo fana ba i siminaa ei hafelo'a. Ma si'ei, i dududuaa ei hafelo'a, ei na oa tapuu ei hafelo'a rama'a ");
INSERT INTO wuv_vpl VALUES ("RM8_4","075_8_4","ROM","8","4","4","ba i fawanewaneia a'a o'ou tamanu na ware fei law ba onei pono'ia. Ina bigi'ia a'a ei lomi rona neneraa ei maumau hafelo'a, ma'uaa rona neneraa fei Spiriti. ");
INSERT INTO wuv_vpl VALUES ("RM8_5","075_8_5","ROM","8","5","5","Ei rona neneraa fei maumau hafelo'a, rona augaa ei naranaraa ro'ou a'a tamanu na nunuminia fei maumau hafelo'a; ma'uaa ei rona neneraa fei Spiriti, rona augaa ei naranaraa ro'ou a'a tamanu na nunuminia fei Spiriti. ");
INSERT INTO wuv_vpl VALUES ("RM8_6","075_8_6","ROM","8","6","6","Fei naranaraa ei hafelo'a rama'a, ma'ea, ma'uaa fei naranara i famamoia fei Spiriti na pa'i harenua ma gutafarawania; ");
INSERT INTO wuv_vpl VALUES ("RM8_7","075_8_7","ROM","8","7","7","fei hafelo'a naranara na siba a'a mei Haidaa. Lomi i guaipa'aa fei law mei Haidaa ma ana lomi i hawia ba i guaipa'ia. ");
INSERT INTO wuv_vpl VALUES ("RM8_8","075_8_8","ROM","8","8","8","Ei na famamoaa ro'ou fei maumau hafelo, lomi ro'aa fani'eni'eaa mei Haidaa. ");
INSERT INTO wuv_vpl VALUES ("RM8_9","075_8_9","ROM","8","9","9","Ma'uaa abaa na famamoaa hamu'ou fei maumau hafelo'a, uaa hefei Spiriti—nabaa fei Spiritii mei Haidaa na oa laloo iaa hamu'odu. Ma mei lomi na pa'i fei Spiritii Christ, abaa hia maroaa Christ. ");
INSERT INTO wuv_vpl VALUES ("RM8_10","075_8_10","ROM","8","10","10","Ma'uaa nabaa Christ, i laloo iaa hamu'ou, fei hudi unuu hamu'ou na ma'e wagii ei hafelo'a, ma'uaa ei spiritii hamu'ou na pa'i harenua wagii fei wanewanea. ");
INSERT INTO wuv_vpl VALUES ("RM8_11","075_8_11","ROM","8","11","11","Ma nabaa fei Spiritii mei i fa'asi'anaa Jesus a'a fei ma'ea na oa laloo iaa hamu'ou, mei i fa'asi'anaa Christ wagii fei ma'ea ana i fani harenua a'a fei hudi unuu hamu'ou uaa fei Spiritina, fei na oafipui a'a hamu'ou. ");
INSERT INTO wuv_vpl VALUES ("RM8_12","075_8_12","ROM","8","12","12","Si'ei, ena lofuu, ona pa'i hepalo bigi'a ba onei bigi'ia, ma'uaa a'a ba bigi'a wagii fei maumau hafelo'a ba onei nenegia. ");
INSERT INTO wuv_vpl VALUES ("RM8_13","075_8_13","ROM","8","13","13","Uaa, nabaa hamo'aa neneraa fei maumau hafelo'a, hamopa'aa ma'e; ma'uaa nabaa a'a fei Spiriti, hamo'aa fama'eaa ei hafelo'a bigi'aa fei hudi unu, hamowe pa'i harenua, ");
INSERT INTO wuv_vpl VALUES ("RM8_14","075_8_14","ROM","8","14","14","uaa ena rona neneraa fei Spiritii mei Haidaa, ro'ou, na'una. ");
INSERT INTO wuv_vpl VALUES ("RM8_15","075_8_15","ROM","8","15","15","Uaa fei Spiriti tonaa hamu'ou abaa na fahumuwaidinaa hamu'ou wagii fei mama'aua, ma'uaa fei spiriti ba hamu'ou na'una. Ma i a'ana, ona harofia ba “Abba, O'ama.” ");
INSERT INTO wuv_vpl VALUES ("RM8_16","075_8_16","ROM","8","16","16","Fei Spiriti ana unaia na u'ufanaa fei spiritii o'ou ba o'ou, na'uu mei Haidaa. ");
INSERT INTO wuv_vpl VALUES ("RM8_17","075_8_17","ROM","8","17","17","Ma nabaa o'ou na'u, te, opowe tonaa manumanu ro tonia ei na'uu mei Haidaa, ana ale'ei fei na tonia Christ ba nabaa o'aa tonaa ei fi'ina, ana o to fei hawerana. ");
INSERT INTO wuv_vpl VALUES ("RM8_18","075_8_18","ROM","8","18","18","Yau na nara ba ei fi'iaa o'ou e'eni, lomi o hawawagipa'ia a'a fei hawera iwe fama'aiaa o'ou. ");
INSERT INTO wuv_vpl VALUES ("RM8_19","075_8_19","ROM","8","19","19","Minaa ei famamarana, rona oma'a fininaa o'onaia unu nopa'aloo fei ba i uniaa ei na'uu mei Haidaa. ");
INSERT INTO wuv_vpl VALUES ("RM8_20","075_8_20","ROM","8","20","20","Uaa minaa ei bigi'aa panina, na nanamuinia ba lomi hanuu ro'ou. Ma a'a ba nunumiaa ro'ou ale'ei, ma'uaa nunumiaa mei i augia ba i fa'o'onainaa unuu ro'ou ");
INSERT INTO wuv_vpl VALUES ("RM8_21","075_8_21","ROM","8","21","21","ba ro'aa ala a'a fei maroroa ma tonaa fei rawani'a gutanaa ei na'uu mei Haidaa. ");
INSERT INTO wuv_vpl VALUES ("RM8_22","075_8_22","ROM","8","22","22","Ona aida ba minaa ei bigi'aa panina, rona ai'ai nopa'amii e'eni ana ale'ei fei fi'iaa hemea pifine ba i wanini. ");
INSERT INTO wuv_vpl VALUES ("RM8_23","075_8_23","ROM","8","23","23","Ma abaa si'ei ua, hamatee ana o'ou, o'ou ena na tonaa fei rawarawa fuaa fei Spiriti, ana ona ai'ai laloo iaa o'ou, eni oi oma'aia ba i taweaa o'ou ale'ena na'una a'a fei ponohadiwe'ia ei hudi unuu o'ou. ");
INSERT INTO wuv_vpl VALUES ("RM8_24","075_8_24","ROM","8","24","24","Uaa, wagii feni o'onaia unu ona tela. Ma'uaa fei o'onaia unu ona fanunupa'ia, abaa pa'aa o'onaia unu. Hini i o'onai ununa a'a tamanu na pa'idii? ");
INSERT INTO wuv_vpl VALUES ("RM8_25","075_8_25","ROM","8","25","25","Ma'uaa nabaa na o'onai unuu o'ou a'a tamanu otawe pa'i, te, onei oma'a fininaa ofasi'ia. ");
INSERT INTO wuv_vpl VALUES ("RM8_26","075_8_26","ROM","8","26","26","Ana ale'ei, fei Spiriti na hadumaa o'ou a'a ei rafileleaa o'ou. Lomi ona aida ba o'aa lafulafunaa tamanu, ma'uaa ba i hadumaa o'ou fei Spiriti, ana unaia na umuinaa o'ou fininaa ai'aiga, uaa lomi paolaa warea ba o warepa'ia. ");
INSERT INTO wuv_vpl VALUES ("RM8_27","075_8_27","ROM","8","27","27","Ma mei na aida ei naranaraa o'ou, na apa'aa fei naranaraa fei Spiriti, uaa ba i hadumaa o'ou, fei Spiriti na umuinaa ei apunai rama'a ale'ei nunumiaa mei Haidaa. ");
INSERT INTO wuv_vpl VALUES ("RM8_28","075_8_28","ROM","8","28","28","Ma ona aida ba a'a minaa ei manumanu, mei Haidaa i bigi'aa ei rawani'a a'a ei rona haguia, ei ina lala'aa ro'ou a'a ei nunumiana. ");
INSERT INTO wuv_vpl VALUES ("RM8_29","075_8_29","ROM","8","29","29","Uaa ei rama'a, ei inadii apa'idigaa ro'ou, ana a'a ro'ou inadii augia ba ronei neneraa fei maumau mei Na'una ba hia, ale'ei uma'ua dupuaa watauda filofui. ");
INSERT INTO wuv_vpl VALUES ("RM8_30","075_8_30","ROM","8","30","30","Ma a'a e'ei, inadii bigi'ia ba ro'aa batanai ma ana na lala'aa ro'ou. Ei ina lala'aa ro'ou, ana ina fawanewaneaa ro'ou; ei ina fawanewaneaa ro'ou, ana ina fanaa fei hawerana a'a ro'ou. ");
INSERT INTO wuv_vpl VALUES ("RM8_31","075_8_31","ROM","8","31","31","Ma si'ei, o'aa ware batanai a'a fei? Nabaa mei Haidaa, hia a'a o'ou, hini ba i papa'aa o'ou? ");
INSERT INTO wuv_vpl VALUES ("RM8_32","075_8_32","ROM","8","32","32","Mei lomi na utofe'ainaa mei Na'una, ana simei mei i fani'uaia a'a minaa o'ou—ana iwepa'aa fanaa o'ou minaa ei manumanu a'ana, lomi pono'ana. ");
INSERT INTO wuv_vpl VALUES ("RM8_33","075_8_33","ROM","8","33","33","Hini i ware ba rona tata ei rafeiaa mei Haidaa? Mei Haidaa, ana hia fawanewanea. ");
INSERT INTO wuv_vpl VALUES ("RM8_34","075_8_34","ROM","8","34","34","Hini ba i dududuaa o'ou? Christ Jesus, mei na ma'e ma asi'aa, ifi guta pepei ma'au mei Haidaa ma ana fi umuinaa o'ou. ");
INSERT INTO wuv_vpl VALUES ("RM8_35","075_8_35","ROM","8","35","35","Hini ba i bitaweaa o'ou a'a fei haguaa Christ? Tamanu i bitaweaa o'ou? Ei hafelo'a? Ei awataa? Ei haperaraia? Fei mouabiabia? Fei ba lomi lawalawa? Ei manumanu hafelo? Fei wadu? ");
INSERT INTO wuv_vpl VALUES ("RM8_36","075_8_36","ROM","8","36","36","Ana ale'ei fei ne'aia: Hamatee yoi, hai'ouna oa i ma'aa fei ma'ea minaa ei arewaa; hai'ou ale'ei ei sipsipi, ei ba ro'aa fo'afama'eaa ro'ou.” ");
INSERT INTO wuv_vpl VALUES ("RM8_37","075_8_37","ROM","8","37","37","Lomi. A'a minaa ei manumanu ei, onapa'aa muadiai uaa mei na haguaa o'ou. ");
INSERT INTO wuv_vpl VALUES ("RM8_38","075_8_38","ROM","8","38","38","Uaa unaminapa'aa aida ba eni manumanu ale'eni ma'ea, harenua, ei alo'alo, ei pigea, ei manumanu e'eni, o hinene, o hepalo manumanu na pa'i forafora, ");
INSERT INTO wuv_vpl VALUES ("RM8_39","075_8_39","ROM","8","39","39","ei tarea manumanu o walaloaa manumanu, o hepalodiai manumanu a'a minaa ei bigi'aa panina, lomi na hawia ba i bitaweaa o'ou a'a fei haguaa mei Haidaa, fei a'a Christ Jesus, mei Fasuu o'ou. ");
INSERT INTO wuv_vpl VALUES ("RM9_1","075_9_1","ROM","9","1","1","Yau na oafipui a'a Christ ma a warefa'uai—lomi ba a warefasifi ma laloo fei naranarau fipuinaa fei Spiriti Apuna, ana na uga ba fa'ua— ");
INSERT INTO wuv_vpl VALUES ("RM9_2","075_9_2","ROM","9","2","2","namina faloloa'i ma na fi'i naranarau. ");
INSERT INTO wuv_vpl VALUES ("RM9_3","075_9_3","ROM","9","3","3","Uaa nunumiau ba yau ma ei lofuu, hai'ou'aa filoginaa ei gutanaa hai'ou ale'ei ba yau, na hafelo i pudaa mei Haidaa ma lomi na pa'i Christ ma ei pa'aa gufuu, ronei pa'i Christ, ");
INSERT INTO wuv_vpl VALUES ("RM9_4","075_9_4","ROM","9","4","4","ei Israel. Uaa ei rama'a ei, ba ro'ou na'uu mei Haidaa, ba ro tonaa fei haweraa mei Haidaa, ei fi'ugaia, fei law, fei losuia ma ei difa'unaia. ");
INSERT INTO wuv_vpl VALUES ("RM9_5","075_9_5","ROM","9","5","5","Noramiaa ro'ou a'a ei ama mina ma Christ hia pai ro'ou ma ana hia Haidaniaa minaa ei manumanu ma o'aa uduginia ranimai ranimai! Amen. ");
INSERT INTO wuv_vpl VALUES ("RM9_6","075_9_6","ROM","9","6","6","Abaa ale'ei ba fei wareaa mei Haidaa na pasi. Uaa minaa ei pai Israel, a'a ba minaa ro'ou Israel. ");
INSERT INTO wuv_vpl VALUES ("RM9_7","075_9_7","ROM","9","7","7","Ma nabaa ro'ou paina, a'a ba minaa ro'ou, pa'aa na'uu Abraham. Agia, hamatee na udedii fei ne'ia ba, “A'a Isaac, owe pa'i paimu.” ");
INSERT INTO wuv_vpl VALUES ("RM9_8","075_9_8","ROM","9","8","8","Si'ei, a'a ba ei na'u waniniaa rama'a, ro'ou pa'aa na'uu mei Haidaa, ma'uaa ei na'uu fei difa'unaiaa mei Haidaa, ro'ou, pai Abraham. ");
INSERT INTO wuv_vpl VALUES ("RM9_9","075_9_9","ROM","9","9","9","Uaa inadii warefa'unai ale'ei: “A'a fei pa'aa au, a hadiwe'imai ma Sarah, iwe pa'i hemea baduu wawane.” ");
INSERT INTO wuv_vpl VALUES ("RM9_10","075_9_10","ROM","9","10","10","Ma hepalodiai, laguei na'uu Rebekah, mei amaa lagua, hemea ua, Isaac, mei ana amaa o'ou. ");
INSERT INTO wuv_vpl VALUES ("RM9_11","075_9_11","ROM","9","11","11","Ma'uaa laguei wataa, ei lagutaa wanini, o bigi'aa hepalo rawani'a o hafelo'a manumanu—si'ei ba mei Haidaa i bigi'aa ei nunumiana ");
INSERT INTO wuv_vpl VALUES ("RM9_12","075_9_12","ROM","9","12","12","ma a'a ba i nofipuimai a'a ei bigi'aa ei rama'a, uaa hia mei rafeia—ina warenaa a'a mei pifine ba, “Mei uma'ua, hia, nafii mei umugina.” ");
INSERT INTO wuv_vpl VALUES ("RM9_13","075_9_13","ROM","9","13","13","Ana ale'ei fei ne'aia: “Jacob, una haguia, ma'uaa Esau, na bidibidi unuu a'ana.” ");
INSERT INTO wuv_vpl VALUES ("RM9_14","075_9_14","ROM","9","14","14","Si'ei, o ware batanai wagina? Ba mei Haidaa, lomi na wanewane? Pa'aa lomi! ");
INSERT INTO wuv_vpl VALUES ("RM9_15","075_9_15","ROM","9","15","15","Uaa ina warenaa a'a Moses ba, “Yau, a faloloa'inaa hini una nunuminia ma farawaninaa hini una nunuminia.” ");
INSERT INTO wuv_vpl VALUES ("RM9_16","075_9_16","ROM","9","16","16","Si'ei, mei Haidaa na rafeinaa hemea rama'a uaa fei faloloa'iana ma a'a ba i rafeinia uaa fei nunumia o bigi'aa mei rama'a mei. ");
INSERT INTO wuv_vpl VALUES ("RM9_17","075_9_17","ROM","9","17","17","Uaa fei Bu'u Apuna na warenaa a'a Pharaoh: “Una fa'ufalarainio a'a fei bigi'a ba a fama'aiaa fei faufauu a'amu ba fei harau nei ba'a i tadiwe'aiaa feni malagufu.” ");
INSERT INTO wuv_vpl VALUES ("RM9_18","075_9_18","ROM","9","18","18","Si'ei, mei Haidaa i faloloa'inaa mei nunumiana ma i fawaiwainaa tabaa mei abaa nunu