﻿USE sofia;
DROP TABLE IF EXISTS sofia.wsk_vpl;
CREATE TABLE wsk_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES wsk_vpl WRITE;
INSERT INTO wsk_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","1","Duap te nunguningkiri Kaem taiti se ali beteram. ");
INSERT INTO wsk_vpl VALUES ("GN1_2","002_1_2","GEN","1","2","2","Sor ko ariga mu lilim biya, ulal biya, se ipi anikaso. Yu la sor ira saparam, se sor mu tiromorom biya anikaso, se Kaem ko Bur yu awote nama taiwakaso. ");
INSERT INTO wsk_vpl VALUES ("GN1_3","002_1_3","GEN","1","3","3","Se Kaem balam, “Nikim aratukko,” mam. Se nikim aratam. ");
INSERT INTO wsk_vpl VALUES ("GN1_4","002_1_4","GEN","1","4","4","Se Kaem nikim aratam mu arigam yawarakala. Aking balam se nikim kigilik nama sanamaram, se tiromorom kigilik nama sanamaram. ");
INSERT INTO wsk_vpl VALUES ("GN1_5","002_1_5","GEN","1","5","5","Se nikim mu nup beteram “woremkalal” mam, ale tiromorom mu nup beteram “tirom” mam. Se sor awuru iluwam nama nikim pagam ale baingam mu day l. ");
INSERT INTO wsk_vpl VALUES ("GN1_6","002_1_6","GEN","1","6","6","Se Kaem balam, “Yu paga ilagala arukko,” mam, “bo kualala, se bo aliti, se kusumuri mu kuwim yam bo anirukko.” ");
INSERT INTO wsk_vpl VALUES ("GN1_7","002_1_7","GEN","1","7","7","Se balam mu uwutata aratam. ");
INSERT INTO wsk_vpl VALUES ("GN1_8","002_1_8","GEN","1","8","8","Se kuwim yam kusumuri mu nup beteram “taiti” mam. Se sor awuru iluwam nama nikim pagam ale baingam mu day 2. ");
INSERT INTO wsk_vpl VALUES ("GN1_9","002_1_9","GEN","1","9","9","Se Kaem balam, “Yu taiti bowa ningi aliti aniso imi nama kuwim suanta bolala aruk, se sor marakuk ale ali ko aratukko.” Se balam mu uwutata aratam. ");
INSERT INTO wsk_vpl VALUES ("GN1_10","002_1_10","GEN","1","10","10","Se sor marakam ale ali aratam mu Kaem nup beteram “ali” mam, se yu nama kuwim suanta bolala aram mu nup beteram “gagi” mam. Ale Kaem mel aratam mu arigam yawarakala. ");
INSERT INTO wsk_vpl VALUES ("GN1_11","002_1_11","GEN","1","11","11","Se Kaem balam, “Ali lilim la awote sirsir duap duap, mayang duap duap, se tam duap duap nunguning kapa se sor irokko mu aratamonko,” mam. Se balam mu uwutata aratam. ");
INSERT INTO wsk_vpl VALUES ("GN1_12","002_1_12","GEN","1","12","12","Ali awote tammanga nunguning sisik warukko mu ali lilimaram. Se Kaem mel aratam mu arigam yawarakala. ");
INSERT INTO wsk_vpl VALUES ("GN1_13","002_1_13","GEN","1","13","13","Se sor awuru iluwam nama nikim pagam ale baingam mu day 3. ");
INSERT INTO wsk_vpl VALUES ("GN1_14","002_1_14","GEN","1","14","14","Se Kaem balam, “Nikim duap duap taiti gomang te aratamon ale tirom nikim tumon ale woremkalal nikim tui se, day suan suan, se sige yia suan suan mu ningi ko tom duap duap mu wetang sapamonko. ");
INSERT INTO wsk_vpl VALUES ("GN1_15","002_1_15","GEN","1","15","15","Ale nononga nikinang ali lilim la tumonko.” Se balam mu uwutata aratam. ");
INSERT INTO wsk_vpl VALUES ("GN1_16","002_1_16","GEN","1","16","16","Kaem nikim bibiya ilagala balam se arataman: biya nunguningkiri mu worem, mu arkalal nikim tuokko, se ko gotek nuam sige mu tirom nikim tuokko. Ale balam se baras agotala arataman. ");
INSERT INTO wsk_vpl VALUES ("GN1_17","002_1_17","GEN","1","17","17","Kaem mel imi taiti ningi nunga awuram, mu ali nikim tumonko. ");
INSERT INTO wsk_vpl VALUES ("GN1_18","002_1_18","GEN","1","18","18","Ale arkalal tirom nikim kapa se, tirom kigilik bita se woremkalal kigilik betemonko. Se Kaem mel aratam mu arigam yawarakala. ");
INSERT INTO wsk_vpl VALUES ("GN1_19","002_1_19","GEN","1","19","19","Se sor awuru iluwam nama nikim pagam ale baingam mu day 4. ");
INSERT INTO wsk_vpl VALUES ("GN1_20","002_1_20","GEN","1","20","20","Se Kaem balam, “Yu gagi ningi mu melmasak duap duap aratamon ale yu gagi karogo terong maukko. Se yalek inangnang suen la aratamon ale bengemon geragamonko.” ");
INSERT INTO wsk_vpl VALUES ("GN1_21","002_1_21","GEN","1","21","21","Buta se Kaem gagi se yu ningi wal bibiya se wal gotektek se anapeya mel duap duap yu ningi karangasan mu nunga beteram. Ale ali awote inangnang duap duap ago nunga beteram. Ale nu mel aratam mu arigam yawarakala. ");
INSERT INTO wsk_vpl VALUES ("GN1_22","002_1_22","GEN","1","22","22","Se marak nungaru se balam, “Gagi ningi ko mel duap duap gue pagamon ale gagi terong maukko. Se ali awote inangnang suen biya tala pagamonko.” ");
INSERT INTO wsk_vpl VALUES ("GN1_23","002_1_23","GEN","1","23","23","Se sor awuru iluwam nama nikim pagam ale baingam mu day 5. ");
INSERT INTO wsk_vpl VALUES ("GN1_24","002_1_24","GEN","1","24","24","Se Kaem balam, “Ali ko mel duap duap aratamonko, wonong ko mel lila mu ta se giarum ko mel diwang dugu karo geragasan mu aratu namamonko.” Se butata aratam. ");
INSERT INTO wsk_vpl VALUES ("GN1_25","002_1_25","GEN","1","25","25","Se Kaem mel suen biya imi nunga beteram mu arigam yawarakala. ");
INSERT INTO wsk_vpl VALUES ("GN1_26","002_1_26","GEN","1","26","26","Se Kaem balam, “Ana nangata nanga nanimi nadera te kariimet nunga nungurnakko. Nuna yu gagi ko mel suen la se, anapeya luman karogo kualala bengesan geragasan mu se, anapeya mel ali awote aolak ilu geragasan, mu suen la nunga bitarmonko.” ");
INSERT INTO wsk_vpl VALUES ("GN1_27","002_1_27","GEN","1","27","27","Se Kaem kariimet nunga nungam, kota ko numi dora te nunga nungam. Nu kari nungam, imet nungam. ");
INSERT INTO wsk_vpl VALUES ("GN1_28","002_1_28","GEN","1","28","28","Ale marak nungaru se balam, “Nina kuriang iluwal, se gue kaparuk sor magaruk, ale sor suen biya te dagi namamon ale mel suen biya mu bitarmonko. Nina yu gagi ko mel suen la se, anapeya luman karogo kualala bengesan geragasan mu se, anapeya mel ali awote aolak ilu geragasan, mu suen la nunga bitualko.” ");
INSERT INTO wsk_vpl VALUES ("GN1_29","002_1_29","GEN","1","29","29","Nu iwita nunga maonam, “Ikialko. Ani ali imi te tam muguri sisik karogo mu se, tam nunguning kaposo mu suen biya nenenga na ko nalko ningarsam. ");
INSERT INTO wsk_vpl VALUES ("GN1_30","002_1_30","GEN","1","30","30","Ale melmasak suen biya marak bagasan, mel bibiya se gotektek ali awote aolak ilu geragasan mu se, inangnang mel kualala bengesan, mu tam gawa sirsir mel mu nunga inang ko nungarsam.” Se butata aratam. ");
INSERT INTO wsk_vpl VALUES ("GN1_31","002_1_31","GEN","1","31","31","Se Kaem mel suen la balam se aratu aratu namaram mu arigam, mu am yawarakala nunguningkiri se karogo amilmilaram. Se sor awuru iluwam nama nikim pagam ale baingam mu day 6. ");
INSERT INTO wsk_vpl VALUES ("GN2_1","002_2_1","GEN","2","1","1","Butatala Kaem taiti, ali, se ko mel duap duap koma koma suen la bita saparam. ");
INSERT INTO wsk_vpl VALUES ("GN2_2","002_2_2","GEN","2","2","2","Nu day 7 ningi ura bo me beteram, nu ura nukum kaolam ale noman saparam. ");
INSERT INTO wsk_vpl VALUES ("GN2_3","002_2_3","GEN","2","3","3","Ale nu day 7 mu marak tuam, ale balam day imi laili mam. Mu awuk, nu mel suen biya bita saparam ale kam mu te noman saparam. ");
INSERT INTO wsk_vpl VALUES ("GN2_4","002_2_4","GEN","2","4","4","Imi ali se taiti Kaem Yawe aguwaya kiwolaram wore ko dugu duap. Tom iru la nu taiti se ali nungam mu, ");
INSERT INTO wsk_vpl VALUES ("GN2_5","002_2_5","GEN","2","5","5","tuwik kaparukko me balukaso, aitak, se tam agi sirsir mel bo awote me aragakaso. Se kariimet bo awote ura iluwokko mu mena tala. ");
INSERT INTO wsk_vpl VALUES ("GN2_6","002_2_6","GEN","2","6","6","Bare baras nuwi kusat, lawung ko biyala kapakaso ale ali yu tuikaso. ");
INSERT INTO wsk_vpl VALUES ("GN2_7","002_2_7","GEN","2","7","7","Se Kaem Yawe ali gege giam, ale kari te nungam, ale noko marir marak karogo mu kuamuru ningi itugumam se kari marak barasu sanamaram. ");
INSERT INTO wsk_vpl VALUES ("GN2_8","002_2_8","GEN","2","8","8","Kaem Yawe ningam bo koma worem bausa mu te Eden beteram, umu te kari nungam mu ningi beteram. ");
INSERT INTO wsk_vpl VALUES ("GN2_9","002_2_9","GEN","2","9","9","Ale balam se tam duap duap yawara yawara, namotam barasa karogo se inang ningo karogo, mu ningam ningi barasaman. Ningam mu ko kusumuri tam ilagala bangawakasan. Bo mu no ale marak ningo toko. Se bo mu no ale ikia sinararuk se munan ningo se memek mu ko ikiko. ");
INSERT INTO wsk_vpl VALUES ("GN2_10","002_2_10","GEN","2","10","10","Se Eden ningi la yu bo aratukaso ale ningam umu yu tuikaso. Se yu umu pagam ale suring ilagala ilagala aratam. ");
INSERT INTO wsk_vpl VALUES ("GN2_11","002_2_11","GEN","2","11","11","Se yu suring bo gira mu Pishon masan; mu ko luan sor nup Havilah mu ningi geragam dalelaram. ");
INSERT INTO wsk_vpl VALUES ("GN2_12","002_2_12","GEN","2","12","12","Sor mu gold yawara karogo. Se ko tam bo karogotala, mu ko liliki siring yawara, nup bdellium. Se ko manga bo agotala, nup onyx, se ko ariga nikinang garagar. ");
INSERT INTO wsk_vpl VALUES ("GN2_13","002_2_13","GEN","2","13","13","Se yu suring bo mu Gihon masan; mu ko luan sor Cush ningi geragam dalelaram. ");
INSERT INTO wsk_vpl VALUES ("GN2_14","002_2_14","GEN","2","14","14","Se yu suring bo tala mu Tigris masan; mu ko luan Assyria ko koma worem bausa te mu ningi geragam dalelaram. Se yu suring bo mu Euphrates masan. ");
INSERT INTO wsk_vpl VALUES ("GN2_15","002_2_15","GEN","2","15","15","Buta se Kaem Yawe nu kari mu tam ale ningam Eden ningi beteram, nu te ura to se ko sinar taukko. ");
INSERT INTO wsk_vpl VALUES ("GN2_16","002_2_16","GEN","2","16","16","Ale kari mu maonam, “Ni tam nunguning suen la ningam imi ningi am noko. ");
INSERT INTO wsk_vpl VALUES ("GN2_17","002_2_17","GEN","2","17","17","Bare tam bo sanamiwoso, ko nunguning nasan ale ikia sinarso se ningo memek ko ikisan, umutang ko nunguning me ta noko. Ni no mu ni kuarko, nunguning.” ");
INSERT INTO wsk_vpl VALUES ("GN2_18","002_2_18","GEN","2","18","18","Asele Kaem Yawe balam, “Kari kota mu me terong. Ani ko bo, nu turantala, bitirik se ilak wete baga se sangukko.” ");
INSERT INTO wsk_vpl VALUES ("GN2_19","002_2_19","GEN","2","19","19","Kaem Yawe ali gege giam ale melmasak ali awote aolak ilusan mu se, inangnang kualala bengesan mu suen biya nunga nungam. Ale nongorak kari kote nunup nungarukko namaram. Se kari aguwaya nunga nunup balam mu nononga nunup aram. ");
INSERT INTO wsk_vpl VALUES ("GN2_20","002_2_20","GEN","2","20","20","Nu wonong ko anapeya bibiya lila mu se, inangnang kualala bengesan mu se, giarum ko mel diwang suen la nunup nungaram. Bare Adam mu kumik ko bo nu turantala ilak bagarukko mu mena. ");
INSERT INTO wsk_vpl VALUES ("GN2_21","002_2_21","GEN","2","21","21","Buta se Kaem Yawe negeram se kari mu aniram kueram. Aniwaram se ko worogorak sokel bo kutuwuram, ale aking ko kuwim mu nungam se sisiram. ");
INSERT INTO wsk_vpl VALUES ("GN2_22","002_2_22","GEN","2","22","22","Asele nu kari mu ko worogorak tam mu te imet nungam. Ale ilak nama kari mu tuam. ");
INSERT INTO wsk_vpl VALUES ("GN2_23","002_2_23","GEN","2","23","23","Se kari mu balam, “Ese! Aitak imi asele aninga angimik sokel te aratam, ale aninga angimik nunguning te aratam; buta se ani aurik ‘imet’ maikko, mu awuk, nu aninga angimik sokel te aratam,” mam. ");
INSERT INTO wsk_vpl VALUES ("GN2_24","002_2_24","GEN","2","24","24","Duap bore te se, kari nuamnuet bitiruk ale imet ilak wete bagara suanta bagamonko. ");
INSERT INTO wsk_vpl VALUES ("GN2_25","002_2_25","GEN","2","25","25","Se imet kari ilagala mu guang mel nungumik te mena, bare dolara me ikikasan. ");
INSERT INTO wsk_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","1","Kaem Yawe melmasak giarum ningi aolak ilu geragasan mu suen biya nunga beteram, bare mot mu ko ikia kawel te suen la nunga kiaram. Se mot mu imet isuam, “Nunguningta Kaem iwita balam, nina tam suen la ningam ningi mu ko nunguning me nalko mam e?” ");
INSERT INTO wsk_vpl VALUES ("GN3_2","002_3_2","GEN","3","2","2","Se imet mot maonam, “Ana tam suen biya ningam ningi anisan mu ko nunguning am nanakko. ");
INSERT INTO wsk_vpl VALUES ("GN3_3","002_3_3","GEN","3","3","3","Bare tam suanta kusumuri sanamiwoso mu Kaem balam ana ko nunguning me nanakko mam. Nu balam ana tam mu ko nunguning nanak agi ilu tanak, mu ana kuenakko mam.” ");
INSERT INTO wsk_vpl VALUES ("GN3_4","002_3_4","GEN","3","4","4","Se mot aking imet maonam, “Mena, nina me kueralko. ");
INSERT INTO wsk_vpl VALUES ("GN3_5","002_3_5","GEN","3","5","5","Kaem ko ikiam, nina nal mu ninga ikia sinararuk se munan ningo se munan memek mu ko ikial ale nu turantala bagaralko. Duap owore te se nigiring kaolam.” ");
INSERT INTO wsk_vpl VALUES ("GN3_6","002_3_6","GEN","3","6","6","Se imet tam nunguning mu arigam, mu nana ko yawara, se ko ariga mu namotam barasa karogo, se ikia sinar ningo te ta ko yawara tala. Se nu tam mu ko nunguning bo tam ale nam. Ale sang kuari ilak bagaram mu tuam se nu agotala nam. ");
INSERT INTO wsk_vpl VALUES ("GN3_7","002_3_7","GEN","3","7","7","Asele nunga ikia nama sinararam, se nunumi arigiman mu nuna nunguning la bagasan, buta se tam fig ko gawa giman ale nunumi te ereman. ");
INSERT INTO wsk_vpl VALUES ("GN3_8","002_3_8","GEN","3","8","8","Sor baingam ale ipiram, se kari ko imet ilak Kaem Yawe ningam ningi aolak iluwam taikaso mu ko kumik nirung ikiman, ale nama tam duap ningi yumuman. ");
INSERT INTO wsk_vpl VALUES ("GN3_9","002_3_9","GEN","3","9","9","Bare Kaem Yawe kari mu auram, “Ni apalak bagasam a?” mam. ");
INSERT INTO wsk_vpl VALUES ("GN3_10","002_3_10","GEN","3","10","10","Se kari koma balam, “Ani ni ningam ningi aolak iluwem se kimik nirung ikiem, ale ani nunguning la, se nguangerem ale yumuwasam,” mam. ");
INSERT INTO wsk_vpl VALUES ("GN3_11","002_3_11","GEN","3","11","11","Se Yawe isuam, “Ni awuk ko ikiem ni nunguning la bagasam? Agi ni tam nunguning ani me noko balem wore ni naem agila?” mam. ");
INSERT INTO wsk_vpl VALUES ("GN3_12","002_3_12","GEN","3","12","12","Se kari balam, “Imet ni keta ani aisem ewere, nu ani tam nunguning aisam se naem.” ");
INSERT INTO wsk_vpl VALUES ("GN3_13","002_3_13","GEN","3","13","13","Se Yawe imet isuam, “Ni anape ko munan sowore beterem?” Se imet balam, “Mot aninga kulam se naem.” ");
INSERT INTO wsk_vpl VALUES ("GN3_14","002_3_14","GEN","3","14","14","Se Kaem Yawe mot iwita maonam, “Ni munan memek beterem; buta se giarum ningi melmasak suen la geragawasan mu nunga ningi ni ikup memek giko. Ni tom suen biya tagu luan te geraga se, kupkup no se lagerko. ");
INSERT INTO wsk_vpl VALUES ("GN3_15","002_3_15","GEN","3","15","15","Ni se imet mu ilak ninga kusumuri nengemang motam suanta me ta anirukko; nika gue te, se imet ko tuagu te, mu uwutata lagaralko. Imet ko tuagu te mu nu nika sipiling ita parusuwurokko, se ni noko suwik durum usirko.” ");
INSERT INTO wsk_vpl VALUES ("GN3_16","002_3_16","GEN","3","16","16","Yawe aking imet iwita maonam, “Tom ni tagu ago se kuriang ilupko mu ni ikup yaman biyala toko. Bare ka kari mu ninguru ko kua lagerko; se nu nika pulawura iwita baga se ka bituokko.” ");
INSERT INTO wsk_vpl VALUES ("GN3_17","002_3_17","GEN","3","17","17","Se aking Yawe Adam iwita maonam, “Ni ka niwus ko kuring karem ale tam nunguning ani me noko balem wore ni naem. Buta se, ali imi na inang ninguru me te kaparukko; ni ura kowar bita se kimik sail yaman ikiok asele na aratuk se no se lagerko. ");
INSERT INTO wsk_vpl VALUES ("GN3_18","002_3_18","GEN","3","18","18","Tam kore ago mu se, sum sirsir memek mu barasuk ka ningam irok, se ni giarum ningi tam gawa gurek mu no se lagerko. ");
INSERT INTO wsk_vpl VALUES ("GN3_19","002_3_19","GEN","3","19","19","Nika ura kowar te inang aratuk se to noko, se ura kowar la bita laga ali ningi namarko. Ani ali gege te nika nungem; buta se ni piler ali ningi namarko.” ");
INSERT INTO wsk_vpl VALUES ("GN3_20","002_3_20","GEN","3","20","20","Adam ko nuwus nup beteram Eve mam, mu awuk, nu kariimet suen la nunga nunam gira nunguningkiri bagarukko. ");
INSERT INTO wsk_vpl VALUES ("GN3_21","002_3_21","GEN","3","21","21","Se Kaem Yawe sipsip mel saki nunga guang te guang sang nungam, ale Adam Eve ilak mu nungaram se kataman. ");
INSERT INTO wsk_vpl VALUES ("GN3_22","002_3_22","GEN","3","22","22","Asele balam, “Aitak kari ko ikia sinararam se ningo memek mu ko ikiam, ale ana iwitatala aratam. Buta se nu tam ko nunguning nasan ale marak pempem bagasan mu me tauk ale naukko,” mam. ");
INSERT INTO wsk_vpl VALUES ("GN3_23","002_3_23","GEN","3","23","23","Ale Yawe kariimet ilagala ningam Eden ningi bagaman mu nunga kaoram se arataman. Yawe ali gege te kari nungam, ale aitak kari kaoram se ali mu te ura to naukko namaram. ");
INSERT INTO wsk_vpl VALUES ("GN3_24","002_3_24","GEN","3","24","24","Tom kaoram se aratam mu engel cherubim mu ningam Eden mu ko koma worem bausa mu te nunga awuram se bagakasan. Ale kariimet bo marak nungara ko tam wore duap ningi namaruk bore ko, baenat bo, tama kuamili ago, koma mu te karogo beteram se nama pilawakaso. ");
INSERT INTO wsk_vpl VALUES ("GN4_1","002_4_1","GEN","4","1","1","Adam nuwus Eve ilak bagaram se tuagu aratam se kuriang Cain iluwam. Ale balam, “Yawe aninga saongam se kuriang kari iluwem,” mam. ");
INSERT INTO wsk_vpl VALUES ("GN4_2","002_4_2","GEN","4","2","2","Udagi te kuriang bo tala iluwam, Abel. Udagi Abel mu nu sipsip nunga bitarukaso, se Cain mu nu ningam ura ilukaso ale na inang asurukaso. ");
INSERT INTO wsk_vpl VALUES ("GN4_3","002_4_3","GEN","4","3","3","Tom bo Cain na inang sang giam ale ago nama nup sapa Yawe tuam. ");
INSERT INTO wsk_vpl VALUES ("GN4_4","002_4_4","GEN","4","4","4","Se Abel betela mu sipsip gotek gira bilangara mu sikina nunga giam ale nunga moram se kueman, se nunguning welang ago mu la giam ale ago nama nup sapa Yawe tuam. Se Yawe Abel ko amilmilaram, ale ko munan beteram mu ago ko amilmilaram. ");
INSERT INTO wsk_vpl VALUES ("GN4_5","002_4_5","GEN","4","5","5","Bare nu Cain ko me amilmilaram, ale ko munan beteram mu ko me amilmilaram tala. Se Cain ninguru gomang motam magaram se koma motam tiromorom kelagam. ");
INSERT INTO wsk_vpl VALUES ("GN4_6","002_4_6","GEN","4","6","6","Se Yawe Cain isuam, “Ni anape ko gemang magoso se kema magaram? ");
INSERT INTO wsk_vpl VALUES ("GN4_7","002_4_7","GEN","4","7","7","Ni ningo bitar, mu ani ni ko ko amilmilarik se ni karogo amilmilerko. Bare ni memek bitar bore ko la sinar toko, mu awuk, memek mu barasam ale nika maguwurokko negawoso, se ni ko sokel ira se kaparuk se nu kierko,” mam. ");
INSERT INTO wsk_vpl VALUES ("GN4_8","002_4_8","GEN","4","8","8","Udagi te Cain ko uria Abel maonam, “Tair se namanak geraganakko,” mam. Se nuna ilagala namaman geragawa, Cain barasam ko uria moram se kueram. ");
INSERT INTO wsk_vpl VALUES ("GN4_9","002_4_9","GEN","4","9","9","Kam me maiyam se Yawe Cain isuam, “Nika uria Abel apoko ya?” mam. Se Cain balam, “Ani me ko ikisam,” mam. “Awuk, ani aga uria ko bitua kari e?” ");
INSERT INTO wsk_vpl VALUES ("GN4_10","002_4_10","GEN","4","10","10","Se Yawe balam, “Ni anape mel beterem? Nika uria ko kumik gue ali awote kaparam ale aningate niawoso, owore ikiko! ");
INSERT INTO wsk_vpl VALUES ("GN4_11","002_4_11","GEN","4","11","11","Ni keta ka kiting te ka uria morem se kueram se kumik gue ali ningi kaparam. Buta se aitak ani ni memek te ka bitirikko den aora biya balsam. Ni ali imi bitar ale tagi toko. ");
INSERT INTO wsk_vpl VALUES ("GN4_12","002_4_12","GEN","4","12","12","Ni ningam ura ilup ale na inang asuru, bare nunguning me kaparukko. Ale keta ka kiwim nunguning bo mena, se am ngual ngual geraga se lagerko,” mam. ");
INSERT INTO wsk_vpl VALUES ("GN4_13","002_4_13","GEN","4","13","13","Se Cain Yawe maonam, “Ikup ni ani aisem mu aromemek nunguningkiri, ani giekko me terong. ");
INSERT INTO wsk_vpl VALUES ("GN4_14","002_4_14","GEN","4","14","14","Ni ani ali imi te aga karosam, ka kema te agotala aga karosam. Se ani agiwim mena se am ngual ngual geraga se lagarikko. Se kari bo agarkuk, mu aga moruk se kuerikko.” ");
INSERT INTO wsk_vpl VALUES ("GN4_15","002_4_15","GEN","4","15","15","Bare Yawe iwita nu maonam, “Mena. Kari bo ka moruk se kuar, mu ani koma biyala nu tuekko.” Ale nu Cain kumik te kawilis bo beteram, se kari awiriya Cain arigimon, bare kawilis mu arigimon ale me momonko. ");
INSERT INTO wsk_vpl VALUES ("GN4_16","002_4_16","GEN","4","16","16","Se Cain Yawe koma motam ko numi kaluwu namaram, ale sor nup Nod wore te bagakaso. Sor mu ningam Eden ko koma worem bausa mu te anikaso. ");
INSERT INTO wsk_vpl VALUES ("GN4_17","002_4_17","GEN","4","17","17","Cain ko nuwus ilak bagaram se tuagu aratam se kuriang Enoch iluwam. Tom mu te Cain wonong bo nunguruwakaso, se wonong mu ko namar nup te beteram Enoch mam. ");
INSERT INTO wsk_vpl VALUES ("GN4_18","002_4_18","GEN","4","18","18","Udagi Enoch tuagu te mu Irad aratam. Se Irad tuagu te mu Mehujael. Se Mehujael tuagu te mu Methushael. Se Methushael tuagu te mu Lamech aratam. ");
INSERT INTO wsk_vpl VALUES ("GN4_19","002_4_19","GEN","4","19","19","Lamech imet ilagala nunga giam, bo Adah, se bo Zillah. ");
INSERT INTO wsk_vpl VALUES ("GN4_20","002_4_20","GEN","4","20","20","Se nuwus Adah tuagu te mu Jabal aratam. Jabal mu kariimet sel sapara ale ningi baga se bulmakau nunga bitua ko kariimet nunga girigir. ");
INSERT INTO wsk_vpl VALUES ("GN4_21","002_4_21","GEN","4","21","21","Jabal ko uria mu Jubal. Jubal mu kariimet gita elesan ale birak ituwusan wore nunga girigir. ");
INSERT INTO wsk_vpl VALUES ("GN4_22","002_4_22","GEN","4","22","22","Se nuwus Zillah tuagu te mu Tubal-Cain aratam. Tubal-Cain mu ain brass te melmasak nunga ko kari. Se ko koras mu ko nup Naamah. ");
INSERT INTO wsk_vpl VALUES ("GN4_23","002_4_23","GEN","4","23","23","Lamech ko nuwusari ilagala iwita nunga maonam, “Adah se Zillah, agiring ikialko; nina Lamech ko nuwusari, den balik ewere ikialko. Ani kari bo morem se kueram, kari kulak bo lot aisam se morem se kueram. ");
INSERT INTO wsk_vpl VALUES ("GN4_24","002_4_24","GEN","4","24","24","Ikialko. Kari bo Cain moruk se kueruk, mu memek biyala taukko; bare kari bo aninga kau tauk mu memek am biyala nunguningkiri taukko!” ");
INSERT INTO wsk_vpl VALUES ("GN4_25","002_4_25","GEN","4","25","25","Udagi te Adam ko nuwus ilak bagaram se kuriang kari bo tala iluwam ale nup beteram Seth i mam. Ale balam, “Kaem ani kuriang bo, Abel, Cain moram se kueram, wore ko kuwim te aking aisam,” mam. ");
INSERT INTO wsk_vpl VALUES ("GN4_26","002_4_26","GEN","4","26","26","Udagi te Seth tuagu te kuriang kari bo aratam se nup beteram Enosh mam. Tom umutang te kariimet Kaem ko nup nunguning Yawe mu te nup patawura duap beteman. ");
INSERT INTO wsk_vpl VALUES ("GN5_1","002_5_1","GEN","5","1","1","Imi kariimet Adam ko gue te kapaman. Tom Kaem kari nungam mu nu kota numi dora te nungam. ");
INSERT INTO wsk_vpl VALUES ("GN5_2","002_5_2","GEN","5","2","2","Nu kari nungam, imet nungam, ale marak nungaram. Ale nunga balam “kariimet” mam. ");
INSERT INTO wsk_vpl VALUES ("GN5_3","002_5_3","GEN","5","3","3","Adam ko yia tom 130 asele noko kuriang bo noko turantala aratam. Se nu nup beteram Seth i mam. ");
INSERT INTO wsk_vpl VALUES ("GN5_4","002_5_4","GEN","5","4","4","Adam 800 yia tala bagaram. Se yia luan umu ningi mu noko kuriang sang kari se imet mu agotala bilangaman. ");
INSERT INTO wsk_vpl VALUES ("GN5_5","002_5_5","GEN","5","5","5","Adam ko yia tom ali imi te bagaram mu 930. ");
INSERT INTO wsk_vpl VALUES ("GN5_6","002_5_6","GEN","5","6","6","Seth ko yia tom 105 asele noko kuriang kari gira aratam, mu Enosh. ");
INSERT INTO wsk_vpl VALUES ("GN5_7","002_5_7","GEN","5","7","7","Seth udagi 807 yia tala bagaram. Se yia luan umu ningi noko kuriang sang kari se imet mu agotala bilangaman. ");
INSERT INTO wsk_vpl VALUES ("GN5_8","002_5_8","GEN","5","8","8","Seth ko yia tom ali imi te bagaram mu 912. ");
INSERT INTO wsk_vpl VALUES ("GN5_9","002_5_9","GEN","5","9","9","Enosh ko yia tom 90 asele noko kuriang kari gira aratam, mu Kenan. ");
INSERT INTO wsk_vpl VALUES ("GN5_10","002_5_10","GEN","5","10","10","Enosh udagi 815 yia tala bagaram. Se yia luan umu ningi noko kuriang sang kari se imet agotala bilangaman. ");
INSERT INTO wsk_vpl VALUES ("GN5_11","002_5_11","GEN","5","11","11","Enosh ko yia tom ali imi te bagaram mu 905. ");
INSERT INTO wsk_vpl VALUES ("GN5_12","002_5_12","GEN","5","12","12","Kenan ko yia tom 70 asele ko kuriang kari gira aratam, mu Mahalalel. ");
INSERT INTO wsk_vpl VALUES ("GN5_13","002_5_13","GEN","5","13","13","Kenan udagi 840 yia tala bagaram. Se yia luan umu ningi noko kuriang sang kari se imet agotala bilangaman. ");
INSERT INTO wsk_vpl VALUES ("GN5_14","002_5_14","GEN","5","14","14","Kenan ko yia tom ali imi te bagaram mu 910. ");
INSERT INTO wsk_vpl VALUES ("GN5_15","002_5_15","GEN","5","15","15","Mahalalel ko yia tom 65 asele ko kuriang kari gira aratam, mu Jared. ");
INSERT INTO wsk_vpl VALUES ("GN5_16","002_5_16","GEN","5","16","16","Mahalalel udagi 830 yia tala bagaram. Se yia luan umu ningi noko kuriang sang kari se imet agotala bilangaman. ");
INSERT INTO wsk_vpl VALUES ("GN5_17","002_5_17","GEN","5","17","17","Mahalalel ko yia tom ali imi te bagaram mu 895. ");
INSERT INTO wsk_vpl VALUES ("GN5_18","002_5_18","GEN","5","18","18","Jared ko yia tom 162 asele ko kuriang kari gira aratam, mu Enoch. ");
INSERT INTO wsk_vpl VALUES ("GN5_19","002_5_19","GEN","5","19","19","Jared udagi 800 yia tala bagaram. Se yia luan umu ningi noko kuriang sang kari se imet agotala bilangaman. ");
INSERT INTO wsk_vpl VALUES ("GN5_20","002_5_20","GEN","5","20","20","Jared ko yia tom ali imi te bagaram mu 962. ");
INSERT INTO wsk_vpl VALUES ("GN5_21","002_5_21","GEN","5","21","21","Enoch ko yia tom 65 asele ko kuriang kari gira aratam, mu Methuselah. ");
INSERT INTO wsk_vpl VALUES ("GN5_22","002_5_22","GEN","5","22","22","Enoch Kaem ilak kapetaram ale 300 yia tala bagaram. Se yia luan umu ningi noko kuriang sang kari se imet agotala bilangaman. ");
INSERT INTO wsk_vpl VALUES ("GN5_23","002_5_23","GEN","5","23","23","Enoch ko yia tom ali imi te bagaram mu 365. ");
INSERT INTO wsk_vpl VALUES ("GN5_24","002_5_24","GEN","5","24","24","Nu Kaem ilak kapetara la baga yumu namaram, mu awuk, Kaem kumik guang karogo lilim tam. ");
INSERT INTO wsk_vpl VALUES ("GN5_25","002_5_25","GEN","5","25","25","Methuselah ko yia tom 187 asele ko kuriang kari gira aratam, mu Lamech. ");
INSERT INTO wsk_vpl VALUES ("GN5_26","002_5_26","GEN","5","26","26","Methuselah udagi 782 yia tala bagaram. Se yia luan umu ningi noko kuriang sang kari se imet agotala bilangaman. ");
INSERT INTO wsk_vpl VALUES ("GN5_27","002_5_27","GEN","5","27","27","Methuselah ko yia tom ali imi te bagaram mu 969. ");
INSERT INTO wsk_vpl VALUES ("GN5_28","002_5_28","GEN","5","28","28","Lamech ko yia tom 182 asele ko kuriang kari gira aratam. ");
INSERT INTO wsk_vpl VALUES ("GN5_29","002_5_29","GEN","5","29","29","Se nu nup beteram Noah i mam, ale balam, “Yawe ali imi ko den aora biya balam se ana te ura to turutuwu lagasan. Bare kuriang imi aratam mu ana yaman ikup giwasan imi ningi wore nanga sanguk se naneman sapanakko,” mam. ");
INSERT INTO wsk_vpl VALUES ("GN5_30","002_5_30","GEN","5","30","30","Se Noah bilangaram buring ko mu Lamech 595 yia tala bagaram. Se yia luan umu ningi noko kuriang sang imet se kari agotala bilangaman. ");
INSERT INTO wsk_vpl VALUES ("GN5_31","002_5_31","GEN","5","31","31","Lamech ko yia tom ali imi te bagaram mu 777. ");
INSERT INTO wsk_vpl VALUES ("GN5_32","002_5_32","GEN","5","32","32","Noah 500 yia bagaram asele ko kuriang kari Shem, Ham, se Japheth bilangaman. ");
INSERT INTO wsk_vpl VALUES ("GN6_1","002_6_1","GEN","6","1","1","Udagi te kari gue pagam ali iram, ale kuriang imet karogotala bilangaman. ");
INSERT INTO wsk_vpl VALUES ("GN6_2","002_6_2","GEN","6","2","2","Se kari nunup bibiya imet itiwik mu nungarkaman ale nomotam barasam, se nunga nongomang te nongoma nongoma nunuwus ko nunga gikasan. ");
INSERT INTO wsk_vpl VALUES ("GN6_3","002_6_3","GEN","6","3","3","Se Yawe balam, “Ani ali kariimet ko angimik gagoraram. Ani bo karogo me yaman kua se lagarikko. Nuna ali ko kariimet, kua namamonko. Buta se ani nunga marak bagara ko tom mu batagem se kapa ko tom 120 yia iwita.” ");
INSERT INTO wsk_vpl VALUES ("GN6_4","002_6_4","GEN","6","4","4","Tom mu te Nephilim karogotala ali imi te bagakasan. Se udagi betelatala. Nuna kari nunup bibiya itiwik nunga giman mu nunga nutagu te arataman. Nuna kager ko kari sokel karogo bibiya, nunup ago. ");
INSERT INTO wsk_vpl VALUES ("GN6_5","002_6_5","GEN","6","5","5","Yawe sor suen biya te kariimet nunga betera kaora arigam mu memek nunguningkiri. Nuna tom suen biya kilek memek ko la ikia tokasan. ");
INSERT INTO wsk_vpl VALUES ("GN6_6","002_6_6","GEN","6","6","6","Se nu nungarkam ale gomang motam yaman iram. Ale nu kariimet ali imi te nunga beteram mu ko, kota numi ko me amilmilakaso. ");
INSERT INTO wsk_vpl VALUES ("GN6_7","002_6_7","GEN","6","7","7","Buta se Yawe balam, “Ani kariimet ali imi te nunga nungem mu suen la nunga menawurikko, kariimet ta, se melmasak bibiya gotektek ta ali imi te aolak ilusan ale karanga geragawasan, se inangnang kualala bengesan mu suen la nunga menawurikko. Ani mel to ya ko nunga nungem!” ");
INSERT INTO wsk_vpl VALUES ("GN6_8","002_6_8","GEN","6","8","8","Bare Yawe mu Noah kota suanta gomang tuikaso. ");
INSERT INTO wsk_vpl VALUES ("GN6_9","002_6_9","GEN","6","9","9","Noah se ko gue te mu nunga dugu duap. Noah mu nu kari diram nunguningkiri. Tom mu te ko kariimet nunga ningi nu kota suanta ko bagara aolak mu diram. Nu Kaem ilak kapetaram ale bagakaso. ");
INSERT INTO wsk_vpl VALUES ("GN6_10","002_6_10","GEN","6","10","10","Noah ko kuriang ilagala suan: Shem, Ham, se Japheth. ");
INSERT INTO wsk_vpl VALUES ("GN6_11","002_6_11","GEN","6","11","11","Bare kariimet suen biya Kaem koma te nunga bagara am memek. Kilek memek, kager daong karogo mu ali sor suen biya te pagam sor iram. ");
INSERT INTO wsk_vpl VALUES ("GN6_12","002_6_12","GEN","6","12","12","Se Kaem ali sor lilim la te loagaram mu munan memek ningi ninguru kapa sapaman. ");
INSERT INTO wsk_vpl VALUES ("GN6_13","002_6_13","GEN","6","13","13","Se Kaem Noah maonam, “Ani kariimet suen la nunga menawurikko. Mu awuk, nuna te se ali kager daong karogo terong mam. Buta se ani kariimet ta se ali karogo la menawurikko,” mam. ");
INSERT INTO wsk_vpl VALUES ("GN6_14","002_6_14","GEN","6","14","14","“Buta se ni tam ningo se aora mu gi ale dal biya bo kaloko. Ale ningi galung gotektek awu awu karogo namarko. Ale tam kiri gi ale te ningi mu palunguru nunguru karogo namar ale matangi mu gogong te bagu bagu karogo namarko. ");
INSERT INTO wsk_vpl VALUES ("GN6_15","002_6_15","GEN","6","15","15","“Ni dal mu iwita kaloko: ko maiya mu 133 metre, ko ulal mu 22 metre, se ko kalel mu 13 metre. ");
INSERT INTO wsk_vpl VALUES ("GN6_16","002_6_16","GEN","6","16","16","Ni dal ko gul kalo, bare ko komal mu kaparuk dal norogen me kau tauk, am awar nuam 44 centimetre iwita bagarukko. Ni dal naung lilim la ningi barim bibiya ilagala suan kaloko, bo aliti, bo ko awote, se bo tala ko awote. Ale dal ko kuring biya suanta nunguruko. ");
INSERT INTO wsk_vpl VALUES ("GN6_17","002_6_17","GEN","6","17","17","Ani balik se lom biyala ali imi te aratuk ale mel suen la marak anisan mu nunga maguwu saparukko. Mel suen biya ali te mu am kua sapamonko. ");
INSERT INTO wsk_vpl VALUES ("GN6_18","002_6_18","GEN","6","18","18","“Bare aninga den nunguning kerak kalosam. Se ni ka imet kuriang se iton karogo mu dal ningi nama naguralko. ");
INSERT INTO wsk_vpl VALUES ("GN6_19","002_6_19","GEN","6","19","19","Ale iwita bitarko. Ni melmasak marak bagasan mu koma koma te, imet kari imet kari nunga gi nongorak nama dal ningi nunga awur se ni kerak ningo la bagamonko. ");
INSERT INTO wsk_vpl VALUES ("GN6_20","002_6_20","GEN","6","20","20","Buruk kausik inangnang se mel suen biya karanga sipawasan mu kete taimon se koma koma te, imet kari imet kari dal ningi nunga awur se ningo la bagamonko. ");
INSERT INTO wsk_vpl VALUES ("GN6_21","002_6_21","GEN","6","21","21","Ale na inang duap duap, nenenga mu se, buruk kausik inangnang nunga, mu karogotala gi ale ilu biguwur ale galung bo ningi tugumko.” ");
INSERT INTO wsk_vpl VALUES ("GN6_22","002_6_22","GEN","6","22","22","Buta se Noah mel suen biya Kaem balam butata bita saparam. ");
INSERT INTO wsk_vpl VALUES ("GN7_1","002_7_1","GEN","7","1","1","Se udagi te Yawe iwita Noah maonam, “Ani ni karkem mu ni keta kariimet ningi ka bagara aolak diram. Buta se ni ka imet kuriang se iton karogo dal ningi nama naguralko. ");
INSERT INTO wsk_vpl VALUES ("GN7_2","002_7_2","GEN","7","2","2","Ni melmasak aolak ilu geragawasan se Kaem koma te ningo, mu suen la nunga ningi kari 7 ta se imet 7 tala nunga gi gi ago namarko. Se mel saki Kaem gomang motam te me anira, mu nunga ningi imet suan la, kari suan la nunga gi gi ago namarko. ");
INSERT INTO wsk_vpl VALUES ("GN7_3","002_7_3","GEN","7","3","3","Ale inangnang suen la nunga ningi kari 7 ta se imet 7 tala nunga gi gi ago namarko. Ni suwuta bitar mu me mena namamonko, udagi te nononga gue paguk ale ali imi te sor terong maukko. ");
INSERT INTO wsk_vpl VALUES ("GN7_4","002_7_4","GEN","7","4","4","Se ubou suanta buring ko mu ani balik se ali imi te tuwik biyala kaparukko, woremkalal 40 ko se tirom 40 ko, se mel suen biya nunga nungem marak bagasan mu nunga menawu saparikko.” ");
INSERT INTO wsk_vpl VALUES ("GN7_5","002_7_5","GEN","7","5","5","Se Noah mel suen biya Yawe balam uwutata beteram. ");
INSERT INTO wsk_vpl VALUES ("GN7_6","002_7_6","GEN","7","6","6","Tom lom biya ali imi te kaparam mu Noah ko yia 600 bagaram se lom kaparam. ");
INSERT INTO wsk_vpl VALUES ("GN7_7","002_7_7","GEN","7","7","7","Se nu ko imet, ko kuriang kari, se nunga imet karogo dal biya mu aragaman se lom biya me nunga maguwuram. ");
INSERT INTO wsk_vpl VALUES ("GN7_8","002_7_8","GEN","7","8","8","Melmasak aolak ilu geragawara, Yawe koma te ningo ta memek ta, se ali awote karangawara, se inangnang mel suen la ilagala ilagala, ");
INSERT INTO wsk_vpl VALUES ("GN7_9","002_7_9","GEN","7","9","9","imet kari, imet kari, Noah kote taiman ale dal aragaman, Kaem Noah maonam butata. ");
INSERT INTO wsk_vpl VALUES ("GN7_10","002_7_10","GEN","7","10","10","Se ubou suanta namaram asele lom biya aratam ale ali iramuram. ");
INSERT INTO wsk_vpl VALUES ("GN7_11","002_7_11","GEN","7","11","11","Noah ko yia 600 mu ko sige 2 se ko day 17 mu te, yu bibiya ali ningi mu barewareng mam ale basukaso. Se kualala taiti kuring pagam se ");
INSERT INTO wsk_vpl VALUES ("GN7_12","002_7_12","GEN","7","12","12","tuwik biyala kapakaso, woremkalal 40 ko, se tirom 40 tala ko. ");
INSERT INTO wsk_vpl VALUES ("GN7_13","002_7_13","GEN","7","13","13","Se tom suanta mu te la Noah, ko imet, ko kuriang ilagala suan, Shem, Ham, Japheth, se nunga imet karogo, mu dal biya mu ningi kasu naguman. ");
INSERT INTO wsk_vpl VALUES ("GN7_14","002_7_14","GEN","7","14","14","Se mel bibiya giarum ningi mu se, mel anapeya lila mu se, mel anapeya karanga geragasan mu se, inangnang se anapeya luman karogo bengesan, mu koma koma agotala dal ningi kapa sapaman. ");
INSERT INTO wsk_vpl VALUES ("GN7_15","002_7_15","GEN","7","15","15","Anapeya mel bibiya gotektek marak bagasan mu Noah kote taiman ale dal ningi kapaman. ");
INSERT INTO wsk_vpl VALUES ("GN7_16","002_7_16","GEN","7","16","16","Se mel suen la marak bagasan mu imet kari, imet kari, dal ningi kapakasan, Kaem Noah maonam butata. Asele Yawe kota dal kuring baguram. ");
INSERT INTO wsk_vpl VALUES ("GN7_17","002_7_17","GEN","7","17","17","Lom biya am kaparam nama day 40 tam, se yu lom ali kiaram kalel biya bausam se dal biya mu pataram. ");
INSERT INTO wsk_vpl VALUES ("GN7_18","002_7_18","GEN","7","18","18","Yu am kalel biya tarigiwakaso, se dal biya mu yu gomang te betela pataram tarigikaso. ");
INSERT INTO wsk_vpl VALUES ("GN7_19","002_7_19","GEN","7","19","19","Se yu biyala nunguningkiri tarigiram, duruk bibiya suen la ira kaluwuram namakaso. ");
INSERT INTO wsk_vpl VALUES ("GN7_20","002_7_20","GEN","7","20","20","Yu tarigiram duruk kalel bibiya nunga kiaram am tarigiram nama 7 metre tam. ");
INSERT INTO wsk_vpl VALUES ("GN7_21","002_7_21","GEN","7","21","21","Se ali awote mel suen biya marak bagara mu kua sapaman: inangnang, wonong ko mel bibiya, giarum ko mel diwang suen la, se mel anapeya ali awote karanga geragasan, se kariimet, am lilim paranga sapaman. ");
INSERT INTO wsk_vpl VALUES ("GN7_22","002_7_22","GEN","7","22","22","Ali te mel suen la marak bagara mu kua muruwuman. ");
INSERT INTO wsk_vpl VALUES ("GN7_23","002_7_23","GEN","7","23","23","Kaem ali ko mel marak bagara suen la nunga menawu saparam; kariimet ta, mel bibiya gotektek ta, ali awote karanga geragasan, se inangnang mu nunga menawu saparam. Noah kota suanta marak bagaram, se awilaya gotek nu ilak dal ningi bagaman mu marak bagaman. ");
INSERT INTO wsk_vpl VALUES ("GN7_24","002_7_24","GEN","7","24","24","Se lom ali lilim kaluwuram nama day 150 tam. ");
INSERT INTO wsk_vpl VALUES ("GN8_1","002_8_1","GEN","8","1","1","Bare Kaem Noah se giarum ko mel diwang se wonong ko mel lila suen biya dal te ilak bagakasan mu me nunga kuamili saparam, am nunga sinar towakaso. Se nu balam se daula barasam se yu marakam kapakaso. ");
INSERT INTO wsk_vpl VALUES ("GN8_2","002_8_2","GEN","8","2","2","Aliti yu kuring kaolam, ale kualala tuwik kuring kaolam, tuwik me kaparukko balam. ");
INSERT INTO wsk_vpl VALUES ("GN8_3","002_8_3","GEN","8","3","3","Day 150 mu ningi, yu lom kumik kueram pila pila kapakaso, ");
INSERT INTO wsk_vpl VALUES ("GN8_4","002_8_4","GEN","8","4","4","se sige 7 ko day 17 mu te dal nama duruk bibiya Ararat mu te soraram ale sanamaram. ");
INSERT INTO wsk_vpl VALUES ("GN8_5","002_8_5","GEN","8","5","5","Se yu marakam am kapawakaso nama sige 10 mu ko day 1 mu te duruk motongar kuting aratu aratu namaman. ");
INSERT INTO wsk_vpl VALUES ("GN8_6","002_8_6","GEN","8","6","6","Udagi te day 40 tala namaram, se Noah ko dal ko kuring gotek, te tatagara ko, mu kaogam. ");
INSERT INTO wsk_vpl VALUES ("GN8_7","002_8_7","GEN","8","7","7","Ale inangnang sengkasik bo beteram se aratam namaram. Bare yu me marakakaso se am binga lagakaso, me peleram tairam. ");
INSERT INTO wsk_vpl VALUES ("GN8_8","002_8_8","GEN","8","8","8","Noah yu marakam agi wore te ikiokko akingtala inangnang biton beteram se bingam namaram. ");
INSERT INTO wsk_vpl VALUES ("GN8_9","002_8_9","GEN","8","9","9","Bare yu am kalel biya anikaso, se biton namaram sor arigam, mu nu kuwim bo te daigokko wore mena, se peleram dal te tairam. Se Noah kuting garukam se te daigam, se to ningi beteram. ");
INSERT INTO wsk_vpl VALUES ("GN8_10","002_8_10","GEN","8","10","10","Noah day 7 tala baga, akingtala biton mu beteram se namaram. ");
INSERT INTO wsk_vpl VALUES ("GN8_11","002_8_11","GEN","8","11","11","Biton mu bainga ningi peleram tairam mu olive gawa gurek bo usiram ale karogo tairam. Mu te Noah ikiam yu katir marakam kaparam. ");
INSERT INTO wsk_vpl VALUES ("GN8_12","002_8_12","GEN","8","12","12","Se nu ubou suanta karogo kimi beteram ale biton mu beteram se aking namaram, bare biton mu me peleram tairam. ");
INSERT INTO wsk_vpl VALUES ("GN8_13","002_8_13","GEN","8","13","13","Noah ko yia tom 601, se yia mu te sige 1 ko day 1 mu te sor marakam. Noah dal gul gogong bo beteram ale sor marakam mu arigam. ");
INSERT INTO wsk_vpl VALUES ("GN8_14","002_8_14","GEN","8","14","14","Se sige 2 mu ko day 27 mu te ali maraka saparam. ");
INSERT INTO wsk_vpl VALUES ("GN8_15","002_8_15","GEN","8","15","15","Asele Kaem Noah maonam, ");
INSERT INTO wsk_vpl VALUES ("GN8_16","002_8_16","GEN","8","16","16","“Ni dal bitar ale ka kuriang imet iton karogo ali te kaparalko. ");
INSERT INTO wsk_vpl VALUES ("GN8_17","002_8_17","GEN","8","17","17","Melmasak suen la arungak kaparko: inangnang, se melmasak bibiya gotektek, se mel ali te karanga namasan, mu suen la nongorak kapar se gue pagamon ale ali lilim ira sapamonko,” mam. ");
INSERT INTO wsk_vpl VALUES ("GN8_18","002_8_18","GEN","8","18","18","Buta se Noah dal beteram, ale ko imet kuriang iton karogo kapaman. ");
INSERT INTO wsk_vpl VALUES ("GN8_19","002_8_19","GEN","8","19","19","Se melmasak suen la dal ningi mu nunga paoga paoga te ali te kapakasan. ");
INSERT INTO wsk_vpl VALUES ("GN8_20","002_8_20","GEN","8","20","20","Asele Noah tama bita Yawe tua ko kuwim nungam, ale melmasak sang se inangnang sang Yawe motam te ningo mu suan suan nunga giam, ale tama bita Yawe tuam. ");
INSERT INTO wsk_vpl VALUES ("GN8_21","002_8_21","GEN","8","21","21","Se Yawe Noah ko tama mu ko amilmilaram, ale gomang motam ningi balam, “Ani ikisam, ali kariimet mu ikia memek mu gotektek la karogo lagasan nama kariimet asan. Owore te se, ani udagi kariimet nunga kilek memek umu ko ali sor me maguwurikko. Ani melmasak suen la marak bagasan mu nunga menawurem iwita mu udagi me bitirikko. ");
INSERT INTO wsk_vpl VALUES ("GN8_22","002_8_22","GEN","8","22","22","“Tom ali imi me menaso, ale am aniso ko tom imi te mu, inang aguwa ko tom se inang gia ko tom mu anirukko; sor ipi ko tom se sor kowar, se worem tom se tuwik tom, se woremkalal se tirom ko tom mu butata anirukko,” mam. ");
INSERT INTO wsk_vpl VALUES ("GN9_1","002_9_1","GEN","9","1","1","Kaem Noah ko namarari ago marak nungaram ale balam, “Nina te ninga kuriang gue kaparuk ale ali sor imi karogo terong ma saparukko. ");
INSERT INTO wsk_vpl VALUES ("GN9_2","002_9_2","GEN","9","2","2","Melmasak suen biya, bibiya ta, gotektek ta, ali te se kualala bengesan se gagi ningi mu nenenga ko biring biring mamon, se nina nunga bitualko. ");
INSERT INTO wsk_vpl VALUES ("GN9_3","002_9_3","GEN","9","3","3","Nina melmasak suen la marak baga se nama taiwasan mu inang ko am nalko. Ani sume galuk nina nalko ningarem iwitatala, aitak ani mel suen biya ningarsam, mu nina am nalko. ");
INSERT INTO wsk_vpl VALUES ("GN9_4","002_9_4","GEN","9","4","4","“Bare anapeya mel, ko nunguning marak gue ago, mu me nalko. ");
INSERT INTO wsk_vpl VALUES ("GN9_5","002_9_5","GEN","9","5","5","Awiriya, bo moruk se kueruk ale kumik gue kaparuk, mu koma ikup taukko. Se anapeya mel diwang bo kariimet bo moruk se kueruk ale kumik gue kaparuk, mu koma memek tualko. ");
INSERT INTO wsk_vpl VALUES ("GN9_6","002_9_6","GEN","9","6","6","“Ani Kaem, se agata aga aimi adera ari se kariimet nungem; buta se awiriya kari bo moruk se kueruk mu nu betelatala kari kuting te kuerukko. ");
INSERT INTO wsk_vpl VALUES ("GN9_7","002_9_7","GEN","9","7","7","Bare nina mu, nina te gue paguk ale ali sor karogo terong ma saparukko.” ");
INSERT INTO wsk_vpl VALUES ("GN9_8","002_9_8","GEN","9","8","8","Se Kaem Noah ko namarari nongorak nunga maonam, ");
INSERT INTO wsk_vpl VALUES ("GN9_9","002_9_9","GEN","9","9","9","“Aitak ani ni se ka kuriang imas taleng girigir alo mu nengerak den imi kalosam, ");
INSERT INTO wsk_vpl VALUES ("GN9_10","002_9_10","GEN","9","10","10","ale mel suen biya marak karogo, inangnang se melmasak lila wonong ko se diwang giarum ko, dal ningi baga nengerak ali te kapaman, wore nongorak den imi koma suanta tala kalosam. ");
INSERT INTO wsk_vpl VALUES ("GN9_11","002_9_11","GEN","9","11","11","Den nengerak kalosam mu iwita: mel marak anisan mu udagi tuwik lom biya me ta nunga maguwurokko. Aking udagi lom biya sor me maguwurokko tala.” ");
INSERT INTO wsk_vpl VALUES ("GN9_12","002_9_12","GEN","9","12","12","Ale Kaem balam, “Ikialko. Ani den nengerak kalosam imi ko kausa bo betesam, kausa imi arigal mu den ani nina nengerak kalem, kumik menara mena, mu ko ningamin ares maukko. ");
INSERT INTO wsk_vpl VALUES ("GN9_13","002_9_13","GEN","9","13","13","Se ani kausa mu magulep taiti nuwi ningi betesam, mu aninga den ali lilim la ilak kalem mu ko kausa anirukko. ");
INSERT INTO wsk_vpl VALUES ("GN9_14","002_9_14","GEN","9","14","14","Tom ani taiti nuwi bitirik se aratuk, se magulep karogo aratuk se arigek, ");
INSERT INTO wsk_vpl VALUES ("GN9_15","002_9_15","GEN","9","15","15","mu ani den nengerak kalem mu ko angamin ares maukko, ani udagi yu lom biya te ali lilim me maguwurikko. ");
INSERT INTO wsk_vpl VALUES ("GN9_16","002_9_16","GEN","9","16","16","Tom ani magulep taiti nuwi ningi aratuk se arigek, mu ani nina kariimet se melmasak suen la marak bagasan mu nengerak aga den pempem la anirukko kalem mu ko angamin ares maukko.” ");
INSERT INTO wsk_vpl VALUES ("GN9_17","002_9_17","GEN","9","17","17","Kaem udagi tala Noah maonam, “Aninga den nina se mel suen biyala marak bagasan nengerak kalem mu magulep te la ko ikialko,” mam. ");
INSERT INTO wsk_vpl VALUES ("GN9_18","002_9_18","GEN","9","18","18","Noah ko kuriang dal beteman ale arataman mu Shem, Ham, se Japheth. Se Ham mu Canaan ko nuet. ");
INSERT INTO wsk_vpl VALUES ("GN9_19","002_9_19","GEN","9","19","19","Noah ko namarari ilagala suan umu te kariimet gue pagam ali lilim iramuram. ");
INSERT INTO wsk_vpl VALUES ("GN9_20","002_9_20","GEN","9","20","20","Noah kuting gege nagura ko kari. Se nu waen ningam bo aguwam. ");
INSERT INTO wsk_vpl VALUES ("GN9_21","002_9_21","GEN","9","21","21","Udagi nu waen sang nam ale ngualaram, ale ko guang kutuwu waram ale nunguning la ko kawam sel ningi aniwakaso. ");
INSERT INTO wsk_vpl VALUES ("GN9_22","002_9_22","GEN","9","22","22","Se Ham, Canaan ko nuet, mu tairam, ko nuet nunguning la aniwaram se arigam, ale peleram namaram ko launuria ilagala mu nunga maonam. ");
INSERT INTO wsk_vpl VALUES ("GN9_23","002_9_23","GEN","9","23","23","Se Shem Japheth ilak guang bo taman, ale nubiwinang te beteman, ale nubiring ko aolak iluman nama kawam sel ningi kasu naguman, ale nonet nunguning la aniwakaso wore kumik arigimon bore ko, nomotam kaluwu se guang taman nonet te ereman. ");
INSERT INTO wsk_vpl VALUES ("GN9_24","002_9_24","GEN","9","24","24","Se udagi te Noah ko ikia dirmam, se ko kuriang Ham nu kumik te munan beteram mu ko den ikiam. ");
INSERT INTO wsk_vpl VALUES ("GN9_25","002_9_25","GEN","9","25","25","Ale nu kuriang umu ko den iwita balam: “Canaan mu ikup biya nunguningkiri irokko! Nu noko launuria nunga dungan kari ko bagarukko.” ");
INSERT INTO wsk_vpl VALUES ("GN9_26","002_9_26","GEN","9","26","26","Ale aking balam, “Yawe nup biya, Shem ko Kaem! Canaan nu Shem ko ura dungan kari ko bagarukko. ");
INSERT INTO wsk_vpl VALUES ("GN9_27","002_9_27","GEN","9","27","27","Aninga angamang mu Kaem baluk se Japheth ko gue paguk ulalaruk, ale nuna Shem ko gue te mu nongorak nongorak bagamonko; se Canaan noko ura dungan kari bagarukko,” mam. ");
INSERT INTO wsk_vpl VALUES ("GN9_28","002_9_28","GEN","9","28","28","Tom yu lom duap beteram mu Noah ko yia tom mu 600. Ale yu lom buring ko mu 350 yia tala iwita bagaram. ");
INSERT INTO wsk_vpl VALUES ("GN9_29","002_9_29","GEN","9","29","29","Noko marak bagara tom lilim la mu 950 yia baga asele kueram. ");
INSERT INTO wsk_vpl VALUES ("GN10_1","002_10_1","GEN","10","1","1","Imi lom biya mu buring ko Noah ko kuriang Shem, Ham, se Japheth gue kaparam namaram wore nunga nunup. ");
INSERT INTO wsk_vpl VALUES ("GN10_2","002_10_2","GEN","10","2","2","Noah ko namar Japheth ko kuriang kari mu Gomer, Magog, Madai, Javan, Tubal, Meshek, se Tiras. ");
INSERT INTO wsk_vpl VALUES ("GN10_3","002_10_3","GEN","10","3","3","Se Gomer tuagu te mu Ashkenaz, Riphath, se Togarmah. ");
INSERT INTO wsk_vpl VALUES ("GN10_4","002_10_4","GEN","10","4","4","Se Javan tuagu te mu Elishah, Tarshish, se ali sor Cyprus se Rhodes kariimet alo. ");
INSERT INTO wsk_vpl VALUES ("GN10_5","002_10_5","GEN","10","5","5","Se Japheth ko gue te ko kariimet imi parasaman lang karoman, tual gotektek se sor nuwi bibiya te dagi dagi namaman, ale nunga den ago kirker. ");
INSERT INTO wsk_vpl VALUES ("GN10_6","002_10_6","GEN","10","6","6","Noah ko namar Ham ko kuriang kari mu Cush, Egypt, Put, se Canaan. ");
INSERT INTO wsk_vpl VALUES ("GN10_7","002_10_7","GEN","10","7","7","Se Cush tuagu te mu Seba, Havilah, Sabtah, Raamah, se Sabteca. Se Raamah tuagu te mu Sheba se Dedan. ");
INSERT INTO wsk_vpl VALUES ("GN10_8","002_10_8","GEN","10","8","8","Cush ko kuriang bo ko nup Nimrod. Nimrod ali imi te giram ale kari supuling sokel ago se kari ngarangarak bagakaso. ");
INSERT INTO wsk_vpl VALUES ("GN10_9","002_10_9","GEN","10","9","9","Yawe motam te mu nu bulamara kari tamatama bo iwita bagakaso. Owore te se, nuna tom sikina kari bo ko balsan, “Nu Nimrod iwita, Yawe motam te bulamara kari tamatama,” ma balsan. ");
INSERT INTO wsk_vpl VALUES ("GN10_10","002_10_10","GEN","10","10","10","Nimrod giram ali sor Shinar (Babylonia) bitarukaso, se ko wonong bibiya mu Babylon, Uruk, Akkad se Kalneh. ");
INSERT INTO wsk_vpl VALUES ("GN10_11","002_10_11","GEN","10","11","11","Nu Shinar bitaruwa se udagi Assyria agotala bitarukaso. Ale mu te ko wonong bibiya, Nineveh, Rehoboth-Ir, Calah, ");
INSERT INTO wsk_vpl VALUES ("GN10_12","002_10_12","GEN","10","12","12","se Resen umutang kaolam. Resen mu Nineveh se Calah wonong bibiya mu nunga kusumuri anikaso. ");
INSERT INTO wsk_vpl VALUES ("GN10_13","002_10_13","GEN","10","13","13","Ham tuagu te Egypt ko gue te ko kariimet mu Lydia, Anam, Lehab, Naphtuh, ");
INSERT INTO wsk_vpl VALUES ("GN10_14","002_10_14","GEN","10","14","14","Pathrus, Casluh, se Caphtor kariimet alo. Se Casluh tuagu te mu Philistia kariimet. ");
INSERT INTO wsk_vpl VALUES ("GN10_15","002_10_15","GEN","10","15","15","Ham tuagu te Canaan ko kuriang laun mu Sidon. Canaan ko gue te ko kariimet mu Heth alo, ");
INSERT INTO wsk_vpl VALUES ("GN10_16","002_10_16","GEN","10","16","16","se Jebua alo, se Amor, Girgash, ");
INSERT INTO wsk_vpl VALUES ("GN10_17","002_10_17","GEN","10","17","17","Hivi, Arki, Sini, ");
INSERT INTO wsk_vpl VALUES ("GN10_18","002_10_18","GEN","10","18","18","Arvad, Zemar, se Hamath alo. Udagi te Canaan ko gue te ko kariimet mu parasaman. ");
INSERT INTO wsk_vpl VALUES ("GN10_19","002_10_19","GEN","10","19","19","Nunga ali te dagiman bagakasan mu ko tom Sidon duap beteram nama wonong Gerar, Gaza duap te; se koma worem bausa te nama Sodom, Gomorrah, Admah, se Zeboiim, Lasha duap te. ");
INSERT INTO wsk_vpl VALUES ("GN10_20","002_10_20","GEN","10","20","20","Se kariimet gue imi lilim la mu Noah namar Ham ko tuagu te ko kariimet. Suan suan nongota nunga sor te dagi namaman, ale suan suan nunga den ago kirker. ");
INSERT INTO wsk_vpl VALUES ("GN10_21","002_10_21","GEN","10","21","21","Noah ko namar Shem tuagu te mu ko kuriang kari agotala. Shem ko laun mu Japheth. Nu Eber tuagu te kapaman mu nunga girigir bagoso. ");
INSERT INTO wsk_vpl VALUES ("GN10_22","002_10_22","GEN","10","22","22","Shem ko kuriang kari mu Elam, Asshur, Arphaxad, Lud, se Aram. ");
INSERT INTO wsk_vpl VALUES ("GN10_23","002_10_23","GEN","10","23","23","Se Aram tuagu te mu Uz, Hul, Gether, se Meshek. ");
INSERT INTO wsk_vpl VALUES ("GN10_24","002_10_24","GEN","10","24","24","Se Arphaxad tuagu te mu Shelah, se Shelah tuagu te mu Eber. ");
INSERT INTO wsk_vpl VALUES ("GN10_25","002_10_25","GEN","10","25","25","Eber ko kuriang kari ilagala, bo ko nup Peleg. Peleg ko tom te ali ko kariimet nunumi pagaru gilingiman, ale motam kirker bagakasan. Se Peleg ko uria ko nup Joktan. ");
INSERT INTO wsk_vpl VALUES ("GN10_26","002_10_26","GEN","10","26","26","Joktan tuagu te mu Almodad, Sheleph, Hazarmaveth, Jerah, ");
INSERT INTO wsk_vpl VALUES ("GN10_27","002_10_27","GEN","10","27","27","Hadoram, Uzal, Diklah, ");
INSERT INTO wsk_vpl VALUES ("GN10_28","002_10_28","GEN","10","28","28","Obal, Abimael, Sheba, ");
INSERT INTO wsk_vpl VALUES ("GN10_29","002_10_29","GEN","10","29","29","Ophir, Havilah, se Jobab. Se imi suen la Joktan ko namarari wore nunga nunup. ");
INSERT INTO wsk_vpl VALUES ("GN10_30","002_10_30","GEN","10","30","30","Se sor kariari mu te bagakasan mu Mesha duap beteram nama wonong Sephar, sor duruk ago koma worem bausa mu te aratam. ");
INSERT INTO wsk_vpl VALUES ("GN10_31","002_10_31","GEN","10","31","31","Se kariimet gue imi lilim la mu Noah namar Shem ko tuagu te ko kariimet. Suan suan nongota nunga sor te dagi namaman, ale suan suan nunga den ago kirker. ");
INSERT INTO wsk_vpl VALUES ("GN10_32","002_10_32","GEN","10","32","32","Se nunup imi kariimet Noah ko kuriang nutagu te arataman wore nunga nunup, se nunga wonong sor nunga nunup. Yu lom biya menaram se ko buring ko mu, kariimet gue pagam sor iram; kariimet mu suen la Noah ko kuriang nutagu te la aratu sapaman. ");
INSERT INTO wsk_vpl VALUES ("GN11_1","002_11_1","GEN","11","1","1","Tom mu te mu ali lilim la ko kariimet mu den suanta te munakakasan. ");
INSERT INTO wsk_vpl VALUES ("GN11_2","002_11_2","GEN","11","2","2","Nuna koma worem bausa mu te nama, kuwim wolong bo sor Shinar mu te arigiman ale te dagiman. ");
INSERT INTO wsk_vpl VALUES ("GN11_3","002_11_3","GEN","11","3","3","Nuna nunumi manorman, “Ario, ana ali gege monak ale kainak se brick ko arukko.” Nuna kawam biya te kaola ko manga mena. Bare nuna brick te kawam kalomonko mu nungurman. Ale nunga mel bo, ko kiri aora biya, brick te palungurmon se numi ilukuawurukko, mu karogotala. ");
INSERT INTO wsk_vpl VALUES ("GN11_4","002_11_4","GEN","11","4","4","Asele balman, “Aitak ana nangata nanga wonong biya kalonak, ale ningi kawam bo aromemek se kalel biya, taiti gomang kautaukoyam kalonakko. Se kariimet arigimon ale anananga nanip patawumonko. Mena mu, kariimet sang taimon nanga parusuwumon se kirker namanak bore ko.” ");
INSERT INTO wsk_vpl VALUES ("GN11_5","002_11_5","GEN","11","5","5","Bare Yawe nunga wonong se kawam kalel aromemek kaloman mu arigokko tai kaparam, ");
INSERT INTO wsk_vpl VALUES ("GN11_6","002_11_6","GEN","11","6","6","ale balam, “Kariimet imi nunga bagara suanta, se den suanta te munakawasan. Nuna duap beteman mel imi betesan se udagi munan duap duap mu nunga ikia te betemonko terong mamonko. ");
INSERT INTO wsk_vpl VALUES ("GN11_7","002_11_7","GEN","11","7","7","Buta se ana nama kapanak, nunga den ngualawunak, se udagi nunumi nuguring me ikimonko,” mam. ");
INSERT INTO wsk_vpl VALUES ("GN11_8","002_11_8","GEN","11","8","8","Ale Yawe nunga parusuwuram se ngual ngual namaman, ali sor suen biya te bagakasan, ale nuna udagi nunga wonong umutang me kaloman. ");
INSERT INTO wsk_vpl VALUES ("GN11_9","002_11_9","GEN","11","9","9","Se wonong mu nup Babel maman, mu awuk, Yawe wonong oworta te ali lilim la nunga den ngualawuram ale nunga parusuwuram, se ali sor suen biya te namaman ale bagakasan. ");
INSERT INTO wsk_vpl VALUES ("GN11_10","002_11_10","GEN","11","10","10","Imi Shem ko kuriang alo. Yu lom mu buring ko, yia ilagala namaram se Shem ko namar gira Arphaxad aratam. Tom mu te mu Shem ko yia tom mu 100. ");
INSERT INTO wsk_vpl VALUES ("GN11_11","002_11_11","GEN","11","11","11","Namar Arphaxad buring ko mu Shem 500 yia tala bagaram. Se yia luan umu ningi noko kuriang sang kari se imet agotala bilangaman. ");
INSERT INTO wsk_vpl VALUES ("GN11_12","002_11_12","GEN","11","12","12","Arphaxad ko yia tom 35 asele ko kuriang kari gira aratam, mu Shelah. ");
INSERT INTO wsk_vpl VALUES ("GN11_13","002_11_13","GEN","11","13","13","Arphaxad udagi 403 yia tala bagaram. Se yia luan umu ningi noko kuriang sang kari se imet agotala bilangaman. ");
INSERT INTO wsk_vpl VALUES ("GN11_14","002_11_14","GEN","11","14","14","Shelah ko yia tom 30 asele ko kuriang kari gira aratam, mu Eber. ");
INSERT INTO wsk_vpl VALUES ("GN11_15","002_11_15","GEN","11","15","15","Shelah udagi 403 yia tala bagaram. Se yia luan umu ningi noko kuriang sang kari se imet agotala bilangaman. ");
INSERT INTO wsk_vpl VALUES ("GN11_16","002_11_16","GEN","11","16","16","Eber ko yia tom 34 asele ko kuriang kari gira aratam, mu Peleg. ");
INSERT INTO wsk_vpl VALUES ("GN11_17","002_11_17","GEN","11","17","17","Eber udagi 430 yia tala bagaram. Se yia luan umu ningi noko kuriang sang kari se imet agotala bilangaman. ");
INSERT INTO wsk_vpl VALUES ("GN11_18","002_11_18","GEN","11","18","18","Peleg ko yia tom 30 asele ko kuriang kari gira aratam, mu Reu. ");
INSERT INTO wsk_vpl VALUES ("GN11_19","002_11_19","GEN","11","19","19","Peleg udagi 209 yia tala bagaram. Se yia luan umu ningi noko kuriang sang kari se imet agotala bilangaman. ");
INSERT INTO wsk_vpl VALUES ("GN11_20","002_11_20","GEN","11","20","20","Reu ko yia tom 32 asele ko kuriang kari gira aratam, mu Serug. ");
INSERT INTO wsk_vpl VALUES ("GN11_21","002_11_21","GEN","11","21","21","Reu udagi 207 yia tala bagaram. Se yia luan umu ningi noko kuriang sang kari se imet agotala bilangaman. ");
INSERT INTO wsk_vpl VALUES ("GN11_22","002_11_22","GEN","11","22","22","Serug ko yia tom 30 asele ko kuriang kari gira aratam, mu Nahor. ");
INSERT INTO wsk_vpl VALUES ("GN11_23","002_11_23","GEN","11","23","23","Serug udagi 200 yia tala bagaram. Se yia luan umu ningi noko kuriang sang kari se imet agotala bilangaman. ");
INSERT INTO wsk_vpl VALUES ("GN11_24","002_11_24","GEN","11","24","24","Nahor ko yia tom 29 asele ko kuriang kari gira aratam, mu Terah. ");
INSERT INTO wsk_vpl VALUES ("GN11_25","002_11_25","GEN","11","25","25","Nahor udagi 119 yia tala bagaram. Se yia luan umu ningi noko kuriang sang kari se imet agotala bilangaman. ");
INSERT INTO wsk_vpl VALUES ("GN11_26","002_11_26","GEN","11","26","26","Terah ko yia tom 70 baga asele namar Abraham bilangaram. Asele buring ko mu Nahor se Haran bilangaman. ");
INSERT INTO wsk_vpl VALUES ("GN11_27","002_11_27","GEN","11","27","27","Imi Terah ko kuriang alo: Terah ko kuriang mu Abram, Nahor, se Haran. Haran tuagu te mu Lot bilangaram. Asele koras Milcah, se uria Iscah bilangaman. ");
INSERT INTO wsk_vpl VALUES ("GN11_28","002_11_28","GEN","11","28","28","Terah am marak bagaram se namar Haran giram kueram, Chaldea ko wonong Ur nu te bilangaram wore te aking kueram. ");
INSERT INTO wsk_vpl VALUES ("GN11_29","002_11_29","GEN","11","29","29","Abram imet tam, ko nuwus mu Sarai. Uria Nahor betela imet tam, ko nuwus mu Milcah, Haran ko nanawus. ");
INSERT INTO wsk_vpl VALUES ("GN11_30","002_11_30","GEN","11","30","30","Se Sarai mu kumik kuriang mena, mu awuk, nu kuin sisira. ");
INSERT INTO wsk_vpl VALUES ("GN11_31","002_11_31","GEN","11","31","31","Udagi te Terah namar Abram se numas Lot, se noton Sarai, Abram ko nuwus, nunga giam ale Chaldea wonong Ur beteman ale Canaan namakasan. Bare nama Harran wonong te arataman mu aking umu te dagi gilingiman. ");
INSERT INTO wsk_vpl VALUES ("GN11_32","002_11_32","GEN","11","32","32","Terah umu te baga kueram. Noko yia tom mu 205. ");
INSERT INTO wsk_vpl VALUES ("GN12_1","002_12_1","GEN","12","1","1","Yawe Abram maonam, “Ka wonong sor, ka kariimet, ka gue suan nunga bitar ale sor ani ka kausekko mu te namarko. ");
INSERT INTO wsk_vpl VALUES ("GN12_2","002_12_2","GEN","12","2","2","“Ani marak sokel kisek ale ni te kariimet motam biya bo ilu biguwurekko; ani nup biya ni kisek, se ni te kariimet mel ningo ningo arigimonko. ");
INSERT INTO wsk_vpl VALUES ("GN12_3","002_12_3","GEN","12","3","3","Awiriya munan ningo kete bitiruk, mu ani munan ningo kote bitirikko; bare awiriya nika bita maguwurok, mu ani nu bita maguwurikko; se ni te kariimet suen la ali imi te mu daiga bagara ningo arigimonko,” mam. ");
INSERT INTO wsk_vpl VALUES ("GN12_4","002_12_4","GEN","12","4","4","Se Abram Yawe kuring karo tuam ale barasam sor umu beteram. Se Lot nu ilak namaram. Abram ko yia tom 75 tom nu wonong Harran mu beteram. ");
INSERT INTO wsk_vpl VALUES ("GN12_5","002_12_5","GEN","12","5","5","Nu ko imet Sarai tam, ale ko uria ko namar Lot tam, ale arungak namakaso. Nuna nongota nunga melmasak se nunga ura kariimet se melmasak suen la Harran baga se giman mu gi sapaman, ale karogo Canaan nama laga nama arataman. ");
INSERT INTO wsk_vpl VALUES ("GN12_6","002_12_6","GEN","12","6","6","Se Abram ko kariimet ago nama Shechem wonong mu te, tam biya bo te sanamiwoso, nup beteman Moreh maman, mu te arataman. Tom mu te Canaan kariimet sor mu te am bagakasan. ");
INSERT INTO wsk_vpl VALUES ("GN12_7","002_12_7","GEN","12","7","7","Se Yawe Abram kote aratam ale maonam, “Ali ewerta ani nika nimasari ka taleng girigir ago ningarikko,” mam. Se Abram kuwim Yawe nukote aratam mu te manga te altar kaolam ale Yawe nup patawuram. ");
INSERT INTO wsk_vpl VALUES ("GN12_8","002_12_8","GEN","12","8","8","Udagi nu ko kariimet arungu sor mu beteman ale aolak iluman nama sor duruk ago, Bethel wonong ko koma worem bausa mu te arataman ale kuwim taman. Se Bethel mu koma worem kapara mu te anikaso, se Ai wonong mu koma worem bausa mu te anikaso. Sor mu te Abram akingtala altar kaolam ale Yawe nup patawuram. ");
INSERT INTO wsk_vpl VALUES ("GN12_9","002_12_9","GEN","12","9","9","Udagi nu aking ko kariimet arungu barasaman ale Canaan ko koma south mu te, sor nup Negev masan, wore te namakasan. ");
INSERT INTO wsk_vpl VALUES ("GN12_10","002_12_10","GEN","12","10","10","Udagi te karak biya kaparam se sor mu te na inang menaram. Se Abram tom tukunangta ko Egypt bagarukko nama kaparam. ");
INSERT INTO wsk_vpl VALUES ("GN12_11","002_12_11","GEN","12","11","11","Se tom nu Egypt wonong te nama kasu nagurokko pipingi aram, mu nu ko nuwus Sarai iwita maonam, “Ikiko. Ni imet kema motam balayam. ");
INSERT INTO wsk_vpl VALUES ("GN12_12","002_12_12","GEN","12","12","12","Se ani ikisam, Egypt kari ni karkamon ale balmon, ni aninga aiwus mamon, ale aninga momon ale nika tamonko. ");
INSERT INTO wsk_vpl VALUES ("GN12_13","002_12_13","GEN","12","13","13","Buta se ni iwita nunga manaruko, ni aninga agoras ma baluko. Se nuna ni te ani ninguru aga sinar tamonko, me aga momonko,” mam. ");
INSERT INTO wsk_vpl VALUES ("GN12_14","002_12_14","GEN","12","14","14","Se Abram Egypt tai aratam se diram tala, Egypt kari alo noko imet koma balayam arigiman. ");
INSERT INTO wsk_vpl VALUES ("GN12_15","002_12_15","GEN","12","15","15","Se Pharaoh ko kari bibiya Sarai ago arigiman ale Pharaoh manorman, “Imet imi imet yawara pa!” maman. Ale namaman taman ale ilak Pharaoh ko kawam te namaman. ");
INSERT INTO wsk_vpl VALUES ("GN12_16","002_12_16","GEN","12","16","16","Se Pharaoh Sarai ko ninguru kuakaso, ale kilek ningo la Abram kumik te bitakaso. Ale sipsip, goat, bulmakau, donkey, camel, se ura dungan kariimet suen biya Abram tuam. ");
INSERT INTO wsk_vpl VALUES ("GN12_17","002_12_17","GEN","12","17","17","Bare Pharaoh Abram ko nuwus Sarai noko imet ko tam bore ko, Yawe kuera memek duap duap Pharaoh se ko kariimet mu nungarukaso. ");
INSERT INTO wsk_vpl VALUES ("GN12_18","002_12_18","GEN","12","18","18","Se Pharaoh Abram ko den beteram se nu tairam se isuam, “Ni awuk se munan ewere ani angimik te beterem? Sarai mu nika niwus, bare ni awuk se wetang te me aga manem? ");
INSERT INTO wsk_vpl VALUES ("GN12_19","002_12_19","GEN","12","19","19","Ni awuk se nika koras ma balem se ani nu aga imet ko taem? Buta se ka niwus iwo to ale ilak tagi talko!” ");
INSERT INTO wsk_vpl VALUES ("GN12_20","002_12_20","GEN","12","20","20","Ale Pharaoh ko kari nunga maonam se Abram, ko nuwus, ko ura kariimet, se nunga mel suen la karogo nunga karoman, se Egypt wonong beteman ale namakasan. ");
INSERT INTO wsk_vpl VALUES ("GN13_1","002_13_1","GEN","13","1","1","Abram Egypt beteram ale Canaan ko koma south mu te Negev namaram, ko imet se ko melmasak suen la ago namaram. Se Lot arungak namaram. ");
INSERT INTO wsk_vpl VALUES ("GN13_2","002_13_2","GEN","13","2","2","Abram ko mel suen biya, noko sipsip, goat, bulmakau suen biya, se ko manga silver, se ko gold mu biya tala. ");
INSERT INTO wsk_vpl VALUES ("GN13_3","002_13_3","GEN","13","3","3","Nu sor Negev mu te baga beteram ale barasam, ale lage luan te ani barasu barasu Bethel peleram namakaso. Nu kuwim Bethel se Ai ko kusumuri, te baga beteram, mu te tai aratam. ");
INSERT INTO wsk_vpl VALUES ("GN13_4","002_13_4","GEN","13","4","4","Kuwim umu nu motam motam Kaem ko altar te kaolam. Umu te tai aratam ale Yawe nup patawuram. ");
INSERT INTO wsk_vpl VALUES ("GN13_5","002_13_5","GEN","13","5","5","Se Lot Abram me bitakaso. Nu ko sipsip, goat, bulmakau, se ko kuriang imet, se ko ura kariimet se ko kawam sel lilim ago Abram kowom karo geragakaso. ");
INSERT INTO wsk_vpl VALUES ("GN13_6","002_13_6","GEN","13","6","6","Nuna wete nunga melmasak singir biya, se kuwim te dagiman mu kirikirikaram se nunumi te sapamonko me terong. ");
INSERT INTO wsk_vpl VALUES ("GN13_7","002_13_7","GEN","13","7","7","Se nunga bulmakau sipsip bitua kari nunumi karogo kaeyakasan. Nuna la umu te me bagakasan. Bare Canaan sang se Perez sang sor mu te ago bagakasan. ");
INSERT INTO wsk_vpl VALUES ("GN13_8","002_13_8","GEN","13","8","8","Se Abram Lot maonam, “Ikup imi ni analak nanga kusumuri me anirukko. Nika ura kari se aninga ura kari kiwem imi me betemonko, mu awuk, ni analak gue suan. ");
INSERT INTO wsk_vpl VALUES ("GN13_9","002_13_9","GEN","13","9","9","Ni arikko, ali ulal biya aniso. Se nanimi betenak ale awar awar baganakko. Ni ali sengam ko mu gemang tui, mu ani ali ngas ko mu te namarikko. Agi ni ngas ko mu gemang tui, mu ani sengam ko namarikko.” ");
INSERT INTO wsk_vpl VALUES ("GN13_10","002_13_10","GEN","13","10","10","Se Lot loagaram ale Jordan ko sor wolong koma Zoar namaram mu arigam, sor mu yu suen biya, Yawe ko ningam Eden iwita, se Egypt sor iwitatala. Tom mu Yawe Sodom Gomorrah me maguwukaso, aitak. ");
INSERT INTO wsk_vpl VALUES ("GN13_11","002_13_11","GEN","13","11","11","Buta se Lot Jordan ko sor wolong koma worem bausa mu te mu lilim la gomang tuam, ale umu te nunumi beteman ale Lot barasam namakaso. ");
INSERT INTO wsk_vpl VALUES ("GN13_12","002_13_12","GEN","13","12","12","Abram ali Canaan mu te bagakaso. Se Lot mu namaram Jordan ko sor wolong mu ko wonong gotektek ningi ningi nama Sodom duap te daigam. ");
INSERT INTO wsk_vpl VALUES ("GN13_13","002_13_13","GEN","13","13","13","Sodom kariimet mu kariimet memek. Nuna Yawe koma te kilek memek memek nunguningkiri bitakasan. ");
INSERT INTO wsk_vpl VALUES ("GN13_14","002_13_14","GEN","13","14","14","Lot namaram, se udagi Yawe Abram maonam, “Ni te sanamiwasam mu te baga se loager ale ali sor imi ari gurugu saparko. ");
INSERT INTO wsk_vpl VALUES ("GN13_15","002_13_15","GEN","13","15","15","Ali sor lilim la ni arigisam imi ani ni, se ka kuriang gue lilim la ningaru saparikko. Se ali mu eng tom suen biya nenenga. ");
INSERT INTO wsk_vpl VALUES ("GN13_16","002_13_16","GEN","13","16","16","Ani nika gue te kariimet bitirik se paguk ale saun, kaura ko koma mena iwita aratamonko. ");
INSERT INTO wsk_vpl VALUES ("GN13_17","002_13_17","GEN","13","17","17","Ario, ni bares ale ali ani kisisam imi te dugu karo gerage ale ko maiya ko ulal arikko. Ani ali imi lilim la ni kisisam.” ");
INSERT INTO wsk_vpl VALUES ("GN13_18","002_13_18","GEN","13","18","18","Se Abram barasam ko kuwim sor moa giam ale Hebron namaram, ale Mamre ko tam bibiya mu duap te kuwim tam ale bagakaso. Nu mu te altar bo kaolam ale Yawe nup patawuram. ");
INSERT INTO wsk_vpl VALUES ("GN14_1","002_14_1","GEN","14","1","1","Tom mu te sor Shinar ko king Amraphel, se sor Ellasar ko king Arioch, se sor Goiim ko king Tidal, se sor Elam ko king Kedorlaomer ");
INSERT INTO wsk_vpl VALUES ("GN14_2","002_14_2","GEN","14","2","2","mu nunumi nuguting iluman ale kager ko namaman. Nuna Sodom ko king Bera, se Gomorrah ko king Birsha, se Admah ko king Shinab, se Zeboiim ko king Shemeber, se Bela ko king, nup Bela tala, mu arungu kagermonko namaman. Bela wonong ko nup bo Zoar. ");
INSERT INTO wsk_vpl VALUES ("GN14_3","002_14_3","GEN","14","3","3","King alo 5 imi mu Siddim ko sor wolong mu te kager ko tai ilu biguwuman. Sor wolong mu aitak Dead Sea masan. ");
INSERT INTO wsk_vpl VALUES ("GN14_4","002_14_4","GEN","14","4","4","Nuna giringila yia 12 ko Elam ko king Kedorlaomer ko bowa ningi bagakasan. Bare yia mu buring ko mu nuna Kedorlaomer beteman ale nuna nongota sanamaman. ");
INSERT INTO wsk_vpl VALUES ("GN14_5","002_14_5","GEN","14","5","5","Bare ko yia buring ko mu te, Kedorlaomer, ko king ilagala suan karogo numi kuting iluwam mu arungu namaman ale Ashteroth Karnaim sor mu te, Rephaim alo nongorak kagerman ale nunga menawuman. Ale nama sor Ham mu te Zuzim alo mu agotala nunga menawuman. Ale nama Shaveth Kiriathaim mu te Emim alo betelatala nunga menawuman. ");
INSERT INTO wsk_vpl VALUES ("GN14_6","002_14_6","GEN","14","6","6","Ale namaman sor duruk ago Seir umu te, Hor alo nunga parusuwuman nongorak nama El Paran, sor garagarayam mu duap te nunga awuman. ");
INSERT INTO wsk_vpl VALUES ("GN14_7","002_14_7","GEN","14","7","7","Asele nuna peleman En-Mishpat (Kadesh) namaman, ale Amalek alo nongorak kagerman, ale nunga sor lilim la bataguru nobowa tuguman. Ale Amor alo Hazezon Tamar bagakasan mu betela nunga nobowa tuguman. ");
INSERT INTO wsk_vpl VALUES ("GN14_8","002_14_8","GEN","14","8","8","Bare king 5, Sodom, Gomorrah, Admah, Zeboiim, se Bela (Zoar), mu Siddim ko sor wolong mu te kager ko sanami muruwuman. ");
INSERT INTO wsk_vpl VALUES ("GN14_9","002_14_9","GEN","14","9","9","Se king Kedorlaomer ko king ilagala suan arungu taiman, ale king 5 mu arungak kagerman, ale ninguru nunga maguwuman. ");
INSERT INTO wsk_vpl VALUES ("GN14_10","002_14_10","GEN","14","10","10","Siddim ko sor wolong umu te mu mutim kolta ago mu suen biya anikaso. Se Sodom Gomorrah nunga king mu nagu parasaman se nunga kari sang mutim mu ningi dagulaman ale kueman. Se saki la naguman duruk te nama tarigiman. ");
INSERT INTO wsk_vpl VALUES ("GN14_11","002_14_11","GEN","14","11","11","Se Kedorlaomer ko king ilagala suan arungu mu Sodom Gomorrah ningi na inang mel ningo ningo gi ago namaman. ");
INSERT INTO wsk_vpl VALUES ("GN14_12","002_14_12","GEN","14","12","12","Ale Abram uria ko namar Lot mu Sodom bagara ewere se, nu agotala se ko melmasak suen la karogo gi ilak namaman. ");
INSERT INTO wsk_vpl VALUES ("GN14_13","002_14_13","GEN","14","13","13","Bare kari bo kager ko naguram ale Hebrew kari Abram kote namaram ale maonam, “Nuna Lot agotala taman ale ilak namaman,” mam. Tom mu te Abram mu Mamre ko tam bibiya wore duap ningi bagakaso. Mamre mu digo Amor ko kari bo, se ko uriamitak ilagala, Eschol se Aner. Kari ilagala suan imi Abram ilak tiran gar ningo, nunumi nongomang suanta bagakasan. ");
INSERT INTO wsk_vpl VALUES ("GN14_14","002_14_14","GEN","14","14","14","Se Abram ko uria ko gue Lot gi ilak namaman mu ko den ikiam, mu nu ko kari sokel ago, kager ko terong, mu nunga auram se taiman. Kari mu nunga tom 318; nuna noko kawam ningi bilangaman ale laga gilingiman. Nu nunga giam ale Kedorlaomer se ko king ilagala suan arungu mu nunga karoman, arungak nama sor Dan mu te arataman. ");
INSERT INTO wsk_vpl VALUES ("GN14_15","002_14_15","GEN","14","15","15","Tirom Abram ko kari nunga paogam se nongorak kagerman nongorak nama Hobah, Damascus koma north mu te arataman. ");
INSERT INTO wsk_vpl VALUES ("GN14_16","002_14_16","GEN","14","16","16","Kager mu ningi Abram Kedorlaomer ko king ago melmasak tere giman mu nongote gi saparam, ale ko gue kuagi Lot ko melmasak lilim karogo nuguting te bataguru tam, imet kuriang ko kariimet lilim la karogo nunga giam, bo me maga namaram. ");
INSERT INTO wsk_vpl VALUES ("GN14_17","002_14_17","GEN","14","17","17","Abram Kedorlaomer se ko king ilagala suan arungak numi kuting iluwam mu, kager te nunga menawuram ale peleram taikaso. Se Sodom ko king Abram amilmil tuokko sor wolong Shaveh mu te nama aratam ale arigam. Sor wolong Shaveh mu tom sikina balsan “King ko sor wolong” masan. ");
INSERT INTO wsk_vpl VALUES ("GN14_18","002_14_18","GEN","14","18","18","Bare king bo tala, Melchizedek, Salem ko king, mu bread se waen giam ago tairam. Nu Kaem Kalel Biya ko priest, ");
INSERT INTO wsk_vpl VALUES ("GN14_19","002_14_19","GEN","14","19","19","se Abram marak tui se maonam, “Kaem Kalel Biya, taiti se ali beteram, mu ni Abram marak kisokko. ");
INSERT INTO wsk_vpl VALUES ("GN14_20","002_14_20","GEN","14","20","20","Kaem Kalel Biya nu nup biya! Nu ka saongam se ka kager kari memek nunga menawurem.” Se Abram mel suen biya giam mu pakakumuram ale motam 10 ko kaparam, ale motam gira suanta mu Melchizedek tuam. ");
INSERT INTO wsk_vpl VALUES ("GN14_21","002_14_21","GEN","14","21","21","Bare Sodom ko king Bera mu Abram maonam, “Mel suen biya ni kager te giem mu nika. Bare aga kariimet nunga bataguru giem mu nunga bita aisuko,” mam. ");
INSERT INTO wsk_vpl VALUES ("GN14_22","002_14_22","GEN","14","22","22","Bare Abram iwita balam, “Yawe, Kaem Kalel Biya, taiti se ali beteram, mu ko koma te ani nunguningta nunguning ka manorsam, ");
INSERT INTO wsk_vpl VALUES ("GN14_23","002_14_23","GEN","14","23","23","ani nika mel buna bo ta me ta taikkowo! Mena. Mu awuk, ni maingte balu, ‘Ani te se Abram kumik mel suen biya ago,’ me wore ko. ");
INSERT INTO wsk_vpl VALUES ("GN14_24","002_14_24","GEN","14","24","24","Ani mel bo agata angimik ko me giekko. Mel aninga kari maingkala naman borta la ani giem. Se aga saonga ilagala suan, Aner, se Eschol se Mamre, mu asele nunga mel saki am gimonko.” ");
INSERT INTO wsk_vpl VALUES ("GN15_1","002_15_1","GEN","15","1","1","Udagi te Yawe kausa bo ningi Abram iwita maonam, “Abram, ni me nguangerko. Ani nika karem; ani mel ningo nunguningkiri kisekko,” mam. ");
INSERT INTO wsk_vpl VALUES ("GN15_2","002_15_2","GEN","15","2","2","Bare Abram balam, “Yawe, ni keta suanta aninga Biya, ni anape ko mel ningo ani aisuko? Ani angimik kuriang mena. Se awiri ani agiwim te aninga mel ningo mu giokko? Agi aninga ura kari Eliezer, Damascus kari, mu aninga mel suen biya giokko e? ");
INSERT INTO wsk_vpl VALUES ("GN15_3","002_15_3","GEN","15","3","3","Ni kuriang bo ani me aisem, se aninga ura kari ani agiwim tauk ale aninga melmasak suen la nu giokko.” ");
INSERT INTO wsk_vpl VALUES ("GN15_4","002_15_4","GEN","15","4","4","Bare Yawe Abram maonam, “Nika ura kari sumu ni kiwim te ka melmasak me giokko. Kuriang kari bo ni keta ka gue nunguningkiri umutang ni kiwim taukko.” ");
INSERT INTO wsk_vpl VALUES ("GN15_5","002_15_5","GEN","15","5","5","Ale Yawe Abram tam ilak watingi aratam ale maonam, “Kualala taiti gomang te loager ale baras suen la mu kau saparko terong agi mu arikko.” Ale mam, “Nika gue te mu baras umu uwutata sor magamonko,” mam. ");
INSERT INTO wsk_vpl VALUES ("GN15_6","002_15_6","GEN","15","6","6","Yawe kausa beteram ale den balam mu Abram ko gomang ningi nunguning aram, owore te se Yawe nu kari ningo diram ko ma balam. ");
INSERT INTO wsk_vpl VALUES ("GN15_7","002_15_7","GEN","15","7","7","Ale maonam, “Ani Yawe, anigita ali ewere kisek se nika arukko kerak Chaldea ko wonong Ur beterem ale kerak tairem,” mam. ");
INSERT INTO wsk_vpl VALUES ("GN15_8","002_15_8","GEN","15","8","8","Bare Abram mam, “O Yawe, aninga Biya, ani awuk ta ko ikiek nunguningta ali imi aninga ali ko maikko?” ");
INSERT INTO wsk_vpl VALUES ("GN15_9","002_15_9","GEN","15","9","9","Se Yawe den koma maonam, “Bulmakau pagar gotek bo, se goat pagar bo, se sipsip anumang bo, nunga yia ilagala suan mu se, biton gotek se arum gotek nunga gi ale karogo tairko,” mam. ");
INSERT INTO wsk_vpl VALUES ("GN15_10","002_15_10","GEN","15","10","10","Se Yawe mel suen la balam mu Abram giam ago kote tairam, ale bulmakau se goat se sipsip mu kusumuri nunga pakaku koma sing sang nunga awuram. Bare nu inangnang ilagala me nunga pagaru kirker nunga awuram. ");
INSERT INTO wsk_vpl VALUES ("GN15_11","002_15_11","GEN","15","11","11","Se taraga saki taiman Abram mel awuram mu namonko karogo kaeyakasan, bare Abram nunga karokaso. ");
INSERT INTO wsk_vpl VALUES ("GN15_12","002_15_12","GEN","15","12","12","Worem kapa nagukaso se sor awuru iluwam taikaso, se Abram ninguru aniram kueram. Se tiromorom biya bo, nguangara karogo mu tairam iramuram. ");
INSERT INTO wsk_vpl VALUES ("GN15_13","002_15_13","GEN","15","13","13","Se Yawe nu iwita maonam, “Ninguru ikiko. Nika taleng girigir sor bo nononga sor mena mu te 400 yia iwita bagamon, se sor mu ko kari dungan ura te nunga bita maguwumonko. ");
INSERT INTO wsk_vpl VALUES ("GN15_14","002_15_14","GEN","15","14","14","Bare ani sor wonong nuna nunga bita maguwumon mu ikup nungarikko. Se tom nuna wonong mu betemon, mu nuna nunga melmasak lilim la karogo aratamonko. ");
INSERT INTO wsk_vpl VALUES ("GN15_15","002_15_15","GEN","15","15","15","Bare ni mu yawarakala baga laga ninguru garuker ale gemang lila karogo kuar se ka mutim tugumonko. ");
INSERT INTO wsk_vpl VALUES ("GN15_16","002_15_16","GEN","15","16","16","Nika gue te ka kariimet mu sor iwareng te baga laga nunga taleng girigir aratamon, bare tairate me pelemon taimonko. Mu awuk, Amor kariimet nunga ali te dagiwasan mu nunga memek mu ko sokel te ikup arigimonko mu ko tom te me tai aragoso. Tom mu te tai aratuk mu nuna pelemon taimonko.” ");
INSERT INTO wsk_vpl VALUES ("GN15_17","002_15_17","GEN","15","17","17","Worem nama kaparam se sor tirom batagam, se kani bo, tama bur ningi barasuwara mu se, galep kaniwara mu bulmakau goat sipsip pagaru koma sing sang awuram mu nunga kusumuri namaman. ");
INSERT INTO wsk_vpl VALUES ("GN15_18","002_15_18","GEN","15","18","18","Tom umutang te Yawe Abram ilak den kalo se balam, “Ani ali imi ni se ka gue te lilim la ningarsam. Se ali ko tom mu Egypt ko Wadi mu te se nama yu biya Euphrates. ");
INSERT INTO wsk_vpl VALUES ("GN15_19","002_15_19","GEN","15","19","19","Ani Ken kariimet alo, se Keniz, Kadmon, ");
INSERT INTO wsk_vpl VALUES ("GN15_20","002_15_20","GEN","15","20","20","Heth, Perez, Rephaim, Amor, ");
INSERT INTO wsk_vpl VALUES ("GN15_21","002_15_21","GEN","15","21","21","Canaan, Girgash, se Jebus kariimet alo nunga ali mu bataguru taik ale ningarikko,” mam. ");
INSERT INTO wsk_vpl VALUES ("GN16_1","002_16_1","GEN","16","1","1","Abram ko nuwus Sarai kuriang bo me ilu tuikaso. Bare ko ura dungan imet bo, Egypt ko, mu arungak bagakaso, ko nup Hagar. ");
INSERT INTO wsk_vpl VALUES ("GN16_2","002_16_2","GEN","16","2","2","Se Sarai Abram maonam, “Yawe ani atagu kaolam se ani kuriang bo me iluwem. Ni namar aninga ura dungan imet wore ilak anir se nu kuriang bo iluwok agi mu aninga.” Se Abram Sarai kuring iluwam. ");
INSERT INTO wsk_vpl VALUES ("GN16_3","002_16_3","GEN","16","3","3","Se Sarai ko ura dungan imet Hagar mu Abram ko nuwus bo iwita balu tuam. Nuna yia 10 ko Canaan baga munan imi nungumik te aratam. ");
INSERT INTO wsk_vpl VALUES ("GN16_4","002_16_4","GEN","16","4","4","Se Abram Hagar ilak bagaram se tuagu aratam. Se tom Hagar numi ikiam nu tuagu ago, mu nu Sarai mel yam ko bitakaso. ");
INSERT INTO wsk_vpl VALUES ("GN16_5","002_16_5","GEN","16","5","5","Se Sarai Abram maonam, “Ni ikup ani giwasam imi ko kotam! Aninga ura dungan imet ni kiting te beterem, se nu aitak tuagu ago, se ani mel yam ko aga beteso. Yawe kota ni analak nanga tuterukko!” ");
INSERT INTO wsk_vpl VALUES ("GN16_6","002_16_6","GEN","16","6","6","Se Abram den koma balam, “Ikiko! Hagar mu nika ura dungan imet. Mu ni nu bitarsam. Nika gemang te ni nu kumik te aguwaya bitarko mu uwutata bitarko.” Se Sarai Hagar bita maguwukaso ale yaman ikup ninguru tuikaso. Se nu nunga beteram ale namakaso. ");
INSERT INTO wsk_vpl VALUES ("GN16_7","002_16_7","GEN","16","7","7","Hagar nama laga sor merang te yu bo bulowolok basuwara mu duap te daigam; yu mu lage Shur namara mu norogen ko aniso. Se Yawe ko engel arigam ale kote tairam, ");
INSERT INTO wsk_vpl VALUES ("GN16_8","002_16_8","GEN","16","8","8","ale isuam, “Hagar, Sarai ko ura dungan imet, ni aparete wore tairem, ale apalak namarko?” Se Hagar mam, “Aninga imet biya Sarai ko nguangerem ale naguwasam.” ");
INSERT INTO wsk_vpl VALUES ("GN16_9","002_16_9","GEN","16","9","9","Se Yawe ko engel maonam, “Ni piler kote namar ale nu la iki karo tuiko.” ");
INSERT INTO wsk_vpl VALUES ("GN16_10","002_16_10","GEN","16","10","10","Akingtala maonam, “Ani nika tagu te kuriang gue nungek se gue paguk ninguru sor magaruk, se kariimet bo kaurokko me terong.” ");
INSERT INTO wsk_vpl VALUES ("GN16_11","002_16_11","GEN","16","11","11","Yawe ko engel akingtala maonam, “Ni aitak tagu karogo, se ni kuriang kari ilup, ale ko nup mu Ishmael meko, mu awuk, Yawe nika gemang niara mu arigam. ");
INSERT INTO wsk_vpl VALUES ("GN16_12","002_16_12","GEN","16","12","12","Bare nika kuriang mu kumik lila mena, donkey diwang iwita bagarukko; nu kariimet ngual ngual nongorak kaerukko, se kariimet mu betela nu ilak dun kopa ilumonko. Nu ko gue suan arungu ningo me bagarukko,” mam. ");
INSERT INTO wsk_vpl VALUES ("GN16_13","002_16_13","GEN","16","13","13","Se Hagar Yawe ko iwita balam, “Aitak ani Kakirip motam te pempem lagasam mu amotam te arigem. Buta se ani nup betesam, El Roi, mu awuk, nu Kaem, ani nu motam te lagasam.” ");
INSERT INTO wsk_vpl VALUES ("GN16_14","002_16_14","GEN","16","14","14","Buta se Hebrew den te yu mutim umutang mu nup balsan Beer Lahai Roi. Se yu mutim mu aitak wonong Kadesh se Bered nunga kusumuri am aniso. ");
INSERT INTO wsk_vpl VALUES ("GN16_15","002_16_15","GEN","16","15","15","Se Hagar Abram ko kuriang kari iluwam se nup beteram Ishmael mam. ");
INSERT INTO wsk_vpl VALUES ("GN16_16","002_16_16","GEN","16","16","16","Abram ko yia tom 86 bagaram se kuriang mu bilangaram. ");
INSERT INTO wsk_vpl VALUES ("GN17_1","002_17_1","GEN","17","1","1","Abram ko yia tom 99 se Yawe kote aratam ale iwita maonam, “Ani Kaem Sokel Ago. Aninga agiring tom suen biya karo ale munan diram la bitarko. ");
INSERT INTO wsk_vpl VALUES ("GN17_2","002_17_2","GEN","17","2","2","Se ani ni kerak den kalem mu ko iki se balik se ka taleng girigir suen biya aratamonko.” ");
INSERT INTO wsk_vpl VALUES ("GN17_3","002_17_3","GEN","17","3","3","Se Abram bugura kulukam ale koma ali ningi kaparam. Se Kaem nu maonam, ");
INSERT INTO wsk_vpl VALUES ("GN17_4","002_17_4","GEN","17","4","4","“Ani ni kerak den iwita kalosam: ni kariimet motam suen biya nunga girigir aratuko. ");
INSERT INTO wsk_vpl VALUES ("GN17_5","002_17_5","GEN","17","5","5","Se ka nip Abram mu ani menawusam. Aitak nika nip mu Abraham, mu awuk, ani aitak ni kariimet motam suen biya nunga nonet gira ko ka betesam. ");
INSERT INTO wsk_vpl VALUES ("GN17_6","002_17_6","GEN","17","6","6","Ani balik se nika taleng girigir suen biya aratamon ale ni te sor nuwi bibiya aratamonko. Ale ni te king arika aratamonko tala. ");
INSERT INTO wsk_vpl VALUES ("GN17_7","002_17_7","GEN","17","7","7","“Ani ni kerak den kalosam imi butata pempem anirukko, ni analak nanga kusumuri se nika gue luan udagi taiwasan mu nongorak butata anirukko. Ani nika Kaem, se nika gue luan udagi mu nunga Kaem baga se lagarikko. ");
INSERT INTO wsk_vpl VALUES ("GN17_8","002_17_8","GEN","17","8","8","Se Canaan ali lilim la imi, aitak ni kari iwareng iwita te bagasam, mu ni se nika gue luan maiya taiwoso mu ningarikko, se ali mu eng am nenenga arukko. Ale ani nenenga Kaem bagarikko.” ");
INSERT INTO wsk_vpl VALUES ("GN17_9","002_17_9","GEN","17","9","9","Kaem Abraham aking maonam, “Bare ni se ka taleng girigir udagi aratamonko mu karogo, nenenga ura mu aninga den kalem mu karo tui se lagaralko. ");
INSERT INTO wsk_vpl VALUES ("GN17_10","002_17_10","GEN","17","10","10","Aninga den kalem umu ko kausa mu kari suen la ningimik guang batoga ko munan te nama saparalko. Ale munan imi butata karo tui se lagaralko. ");
INSERT INTO wsk_vpl VALUES ("GN17_11","002_17_11","GEN","17","11","12","Nina ningimik guang batoga te nama saparalko: ninga kuriang kari iru bilangamon mu day 8 mu te nungumik guang batoga te namamonko; se ninga ura imet nunga kuriang kari ilusan mu se, ura dungan kari nina gue iwareng nongote nunga diaman mu karogotala nungumik guang batoga te nama sapamonko. Se munan imi mu den ani nina nengerak kalem umu ko kausa iwita anirukko. ");
INSERT INTO wsk_vpl VALUES ("GN17_13","002_17_13","GEN","17","13","13","Nengeta ninga kuriang, se ninga bagara suan nunga kuriang, se ura kari nongote nunga diasan mu suen la nungumik guang batoga te nama sapamonko. Ikialko. Ningimik guang batoga ko munan imi pempem butata anirukko. ");
INSERT INTO wsk_vpl VALUES ("GN17_14","002_17_14","GEN","17","14","14","Bare kari bo agi kuriang kari bo munan imi kumik te me beteral, mu nenenga ningi me bagarukko. Mu awuk, nu aninga den nengerak kalem umu me karo tuam. Buta se kaoral se tagi taukko.” ");
INSERT INTO wsk_vpl VALUES ("GN17_15","002_17_15","GEN","17","15","15","Kaem akingtala Abraham maonam, “Bare nika niwus Sarai mu nup Sarah mu te aruko. Nup Sarai mu ani menawusam. ");
INSERT INTO wsk_vpl VALUES ("GN17_16","002_17_16","GEN","17","16","16","Ani marak tuek se nu ka kuriang kari ilu kisokko. Ani marak tuek se nu kariimet motam suen biya nunga nunam gira bagarukko. Ale nu te king arika aratamonko.” ");
INSERT INTO wsk_vpl VALUES ("GN17_17","002_17_17","GEN","17","17","17","Se Abraham bugura kulukam ale moke ali ningi kaparam, se gusi laga gomang ningi la mam, “Agi kari aora bo ko yia tom 100 mu kuriang gue bo bitirukko terong e? Se aga imet aora Sarah mu ko yia tom 90, mu nu kuriang iluwokko terong e?” ");
INSERT INTO wsk_vpl VALUES ("GN17_18","002_17_18","GEN","17","18","18","Uwuta balam ale Kaem maonam, “Aguwa mu Ishmael la marak tui se aninga agiwim taukko,” mam. ");
INSERT INTO wsk_vpl VALUES ("GN17_19","002_17_19","GEN","17","19","19","Bare Kaem “Mena,” mam. “Nika niwus Sarah kuriang kari ilu kisok se ni nup bitar Isaac meko,” mam. “Ani den ni kerak kalem mu koma suanta nu se ko gue te mu nongorak pempem anirukko. ");
INSERT INTO wsk_vpl VALUES ("GN17_20","002_17_20","GEN","17","20","20","Bare Ishmael mu ni balem butata ani marak tuekko. Nu te kariimet gue suen biya paga tuokko. Nu kari supuling bibiya 12 mu nunga nonet gira bagarukko, se ko taleng girigir kasik biya nunguningkiri aratamonko. ");
INSERT INTO wsk_vpl VALUES ("GN17_21","002_17_21","GEN","17","21","21","Bare aninga den ni kerak kalem mu koma suanta tala Isaac kote anirukko. Tom iwitatala yia namake ko taiwoso mu te, Sarah kuriang mu ilu kisokko.” ");
INSERT INTO wsk_vpl VALUES ("GN17_22","002_17_22","GEN","17","22","22","Kaem den mu Abraham ilak balu saparam, mu eng am Abraham beteram ale namaram. ");
INSERT INTO wsk_vpl VALUES ("GN17_23","002_17_23","GEN","17","23","23","Se kowarkalal suanta mu te la, Abraham Kaem kuring kaoram ale ko namar Ishmael se, kari noko kawam te bilangaman mu se, kari sor iwareng te nunga diaram se taiman bagakasan, mu nungumik guang batoga te nunga beteram. ");
INSERT INTO wsk_vpl VALUES ("GN17_24","002_17_24","GEN","17","24","24","Abraham ko yia tom 99 se kumik guang batoga te namaram. ");
INSERT INTO wsk_vpl VALUES ("GN17_25","002_17_25","GEN","17","25","25","Se ko namar Ishmael mu ko yia tom 13 mu te kumik guang batagorman. ");
INSERT INTO wsk_vpl VALUES ("GN17_26","002_17_26","GEN","17","26","27","Abraham namar Ishmael ilak se, ura kari alo nu ilak bagara, mu suen la kowarkalal suanta mu te la nungumik guang batoga te nama sapaman. ");
INSERT INTO wsk_vpl VALUES ("GN18_1","002_18_1","GEN","18","1","1","Udagi worem kowar biya se Abraham tam Mamre bibiya mu duap ningi, ko kawam sel kuringi dagiwaram se Yawe kote aratam. ");
INSERT INTO wsk_vpl VALUES ("GN18_2","002_18_2","GEN","18","2","2","Abraham dagiwa loagaram mu kari ilagala suan ko sel koma ko sanamiwaman se nungarkam, ale naguram amilmil nungarukko nongote namaram ale bugura kulukam ale koma ali ningi kaparam. ");
INSERT INTO wsk_vpl VALUES ("GN18_3","002_18_3","GEN","18","3","3","Ale bo gira sanamaram mu maonam, “Aga Biya,” mam, “ani ningo nuam ko agarkal agi mu ani nenenga ura kari aga kawam me kiaralko, ani ninga sangikko. ");
INSERT INTO wsk_vpl VALUES ("GN18_4","002_18_4","GEN","18","4","4","Ani balik se yu ago taimon se nisiwik te anuwal ale aga tamarum te neneman saparalko. ");
INSERT INTO wsk_vpl VALUES ("GN18_5","002_18_5","GEN","18","5","5","Nina aninga kawam te taiman, se ani na sang ningarik se nal sokel tal, ale asele barasal aolak iluwalko.” Se nuna balman, “Mu terong. Balsam butata bitarko,” maman. ");
INSERT INTO wsk_vpl VALUES ("GN18_6","002_18_6","GEN","18","6","6","Se Abraham ko kawam sel ningi biririka namaram ale Sarah maonam, “Tairate plaua ningo nunguningkiri singir ilagala suan gi ale gurugu ale bread ko kaiko,” mam. ");
INSERT INTO wsk_vpl VALUES ("GN18_7","002_18_7","GEN","18","7","7","Aking pasak ala bulmakau te bagaman mu te namaram ale bo kumik titiyam kulak mu iluwam, ale ko ura kari tuam se tairate la kaiyam ale nungam burangaram. ");
INSERT INTO wsk_vpl VALUES ("GN18_8","002_18_8","GEN","18","8","8","Asele Abraham bulmakau nunguning kaniram mu giam, ale goat ko amin kiri mu giam, ale kiri sang pakongaram, bread te ilu nasan, mu giam ale karogo nama nongoma te awuram. Se nuna na nowakasan mu nu nungumik duap te tam bowa ningi sanamiwakaso. ");
INSERT INTO wsk_vpl VALUES ("GN18_9","002_18_9","GEN","18","9","9","Nuna na no kutuwuman ale Abraham isarman, “Nika niwus Sarah apoko ya?” maman. Se Abraham balam, “Uwa, kawam sel ningi bagoso,” mam. ");
INSERT INTO wsk_vpl VALUES ("GN18_10","002_18_10","GEN","18","10","10","Asele Yawe iwita Abraham maonam, “Nunguningta, tom iwitatala yia nangama ko taiwoso mu te, Sarah nika niwus kuriang kari iluwok ilak bagaruk se ani tairik arigekko,” mam. Se Sarah nuna nubiring ko, kawam sel kuringi baga se den umu ikiwakaso. ");
INSERT INTO wsk_vpl VALUES ("GN18_11","002_18_11","GEN","18","11","11","Abraham Sarah ilak garukaman nunguningkiri, ale Sarah kuriang iluwokko tom kiaram. ");
INSERT INTO wsk_vpl VALUES ("GN18_12","002_18_12","GEN","18","12","12","Se Sarah gusi se gomang ningi la balam, “Ani angimik garuk nunguningkiri, se aninga kari biya mu betela garuk nunguningkiri. Se kuriang gi patawura ko amilmil mu awuk ta nangate pelerukko?” ");
INSERT INTO wsk_vpl VALUES ("GN18_13","002_18_13","GEN","18","13","13","Se Yawe Abraham isuam, “Awuk se Sarah gusiram ale mam, ‘Ani garukerem ale awuk ta kuriang iluwekko ya?’ mam. ");
INSERT INTO wsk_vpl VALUES ("GN18_14","002_18_14","GEN","18","14","14","Ani Yawe. Ani anapeya bitirikko mu aningate ikup iwita mena. Tom iwitatala yia nangama ko taiwoso mu te, Sarah kuriang kari iluwok ilak bagaruk se ani nengete tairik arigekko.” ");
INSERT INTO wsk_vpl VALUES ("GN18_15","002_18_15","GEN","18","15","15","Se Sarah nguangaram, ale kawelaram, “Ani me gusirem,” mam. Bare Yawe balam, “Mena. Ni gusirem.” ");
INSERT INTO wsk_vpl VALUES ("GN18_16","002_18_16","GEN","18","16","16","Kari ilagala suan mu namamonko barasaman ale nomotam kaparam se Sodom wonong arikasan. Se Abraham arungak nama lage te nunga awurokko arungu namakaso. ");
INSERT INTO wsk_vpl VALUES ("GN18_17","002_18_17","GEN","18","17","17","Ale Yawe kota numi isuam, “Ani anapeya mel bitirikko ko negawasam mu anape ko Abraham koma te kaluwurekko? Mena. ");
INSERT INTO wsk_vpl VALUES ("GN18_18","002_18_18","GEN","18","18","18","Mu awuk, Abraham te sor bo aromemek se sokel ago aratukko, se sor saki ali imi te mu nu te marak tamonko. ");
INSERT INTO wsk_vpl VALUES ("GN18_19","002_18_19","GEN","18","19","19","Ani nu atumukirem, nu ko kuriang, ko taleng girigir nunga kiti gurugok se, ani Yawe aga den karo tumon ale munan ningo diram la betemon se, mel suen biya ani nu kumik te bitirikko balem mu bita saparikko.” ");
INSERT INTO wsk_vpl VALUES ("GN18_20","002_18_20","GEN","18","20","20","Buta se Yawe Abraham maonam, “Sodom Gomorrah ningi munan duap duap memek nunguningkiri wore arataso, se ko den suen biya arataso. ");
INSERT INTO wsk_vpl VALUES ("GN18_21","002_18_21","GEN","18","21","21","Se ani nama kaparik arigek ale den ikiem mu uwutata agi mu ko arigek ikiekko.” ");
INSERT INTO wsk_vpl VALUES ("GN18_22","002_18_22","GEN","18","22","22","Se kari ilagala mu nongoma guruguman ale Sodom namakasan. Bare Abraham Yawe ilak am sanamiwakaso. ");
INSERT INTO wsk_vpl VALUES ("GN18_23","002_18_23","GEN","18","23","23","Asele Abraham Yawe kote pingi nuam kasu namaram ale isuam, “Kari Biya,” mam, “awuk, ni kariimet ningo diram mu kariimet memek mu arungu lilim nunga menawurko e? ");
INSERT INTO wsk_vpl VALUES ("GN18_24","002_18_24","GEN","18","24","24","Bare awuk? Kariimet ningo diram 50, sor mu te bagamon, mu wonong mu am menawu sapar agi, nunga ningo ko to ilupko e? ");
INSERT INTO wsk_vpl VALUES ("GN18_25","002_18_25","GEN","18","25","25","Ani ikisam, ni uwuta me bitarko. Ni uwuta bitar mu kariimet ningo ta, kariimet memek ta, memek koma suanta arigimonko. Buta se ani ikisam, ni uwuta me bitarko. Ni ali lilim ko Tutera Kari se ningo diram la bitarko.” ");
INSERT INTO wsk_vpl VALUES ("GN18_26","002_18_26","GEN","18","26","26","Se Yawe den koma iwita balam, “Ani Sodom ningi kariimet ningo diram 50 ko nungarkik, mu nononga ningo ko se sor lilim la me maguwurikko.” ");
INSERT INTO wsk_vpl VALUES ("GN18_27","002_18_27","GEN","18","27","27","Se aking Abraham mam, “Ani ni Kari Biya kerak iwita me den tagirekko, mu awuk, ani ali kari, kupkup te aga nungem. ");
INSERT INTO wsk_vpl VALUES ("GN18_28","002_18_28","GEN","18","28","28","Bare aking awuk? Kariimet pila kam 45 mu ningo diram, mu ni awuk bitarko? Sor mu lilim maguwur i?” Se Yawe balam, “Ani kariimet ningo 45 ko nungarkik, mu ani nunga ningo ko se sor me maguwurikko,” mam. ");
INSERT INTO wsk_vpl VALUES ("GN18_29","002_18_29","GEN","18","29","29","Se Abraham aking isuam, “Bare kariimet ningo diram 40 iwita nungarki, mu ni awuk me?” Se nu balam, “Ani kariimet ningo 40 ko nungarkik, mu umu nunga ningo ko sor wonong me maguwurikko,” mam. ");
INSERT INTO wsk_vpl VALUES ("GN18_30","002_18_30","GEN","18","30","30","Se aking Abraham wosenga se balam, “Kari Biya, ani aking den bo balikko mu ni me ko gemang magarukko. Se kariimet ningo 30 bagamon mu awuk bitarko?” Se nu balam, “Ani kariimet ningo diram 30 ko nungarkik, mu ani sor lilim me maguwurikko.” ");
INSERT INTO wsk_vpl VALUES ("GN18_31","002_18_31","GEN","18","31","31","Se Abraham aking balam, “Kari Biya, ani iwita me bitirikko agila wore akingtala ka isarsam, kariimet ningo nuam 20 iwita bagamon, mu awuk bitarko?” Se nu balam, “Kariimet ningo 20 mu nunga ningo ko ani sor mu lilim me maguwurikko.” ");
INSERT INTO wsk_vpl VALUES ("GN18_32","002_18_32","GEN","18","32","32","Se Abraham aking balam, “O Kari Biya, ago ko gemang me magarukko, bare aga isa nukum ewere ka isuekko. Kariimet ningo mu 10 iwita, mu awuk bitar?” Se nu balam, “Ani kariimet ningo 10 bagamon se nungarkik, mu ani wonong lilim me maguwurikko,” mam. ");
INSERT INTO wsk_vpl VALUES ("GN18_33","002_18_33","GEN","18","33","33","Yawe Abraham ilak munaka kutuwuram ale Abraham beteram. Se Abraham peleram ko kawam sel ningi namaram. ");
INSERT INTO wsk_vpl VALUES ("GN19_1","002_19_1","GEN","19","1","1","Engel ilagala bainga ningi Sodom wonong te tai arataman. Se Lot lage kuringi dagiwa nungarkam, ale barasam nongote namaram ale bugura kulukam ale koma ali ningi kaparam, ");
INSERT INTO wsk_vpl VALUES ("GN19_2","002_19_2","GEN","19","2","2","se mam, “Aga kari bibiya, ani ninga ura kari, aga kawam te tairalko. Tairal ale nisiwik anuwal ale, tirom agarak aga kawam te aniralko. Se tumong biyala asele nina aolak ilu namaralko.” Bare nuna balman, “Mena. Ana tirom imi wonong tuagu te aninakko.” ");
INSERT INTO wsk_vpl VALUES ("GN19_3","002_19_3","GEN","19","3","3","Bare Lot am sail tagi lagaram, se nuna ilak ko kawam te namaman. Asele Lot bread yeast mena mu kaiyam ale na yawara bo nungam ale nungaram se no gilingiman. ");
INSERT INTO wsk_vpl VALUES ("GN19_4","002_19_4","GEN","19","4","4","Nuna animonko negawaman se Sodom wonong lilim ko kari, kulak te, garuk te taiman, Lot ko kawam laturu guruguman, ");
INSERT INTO wsk_vpl VALUES ("GN19_5","002_19_5","GEN","19","5","5","ale Lot aruman ale isarukasan, “Kari ilagala tirom kerak bagamonko taiman mu apoko ya? Nongorak aratu se ana nongorak aninakko.” ");
INSERT INTO wsk_vpl VALUES ("GN19_6","002_19_6","GEN","19","6","6","Se Lot nungarkukko aratam, ale songkuring buring ko baguram, ");
INSERT INTO wsk_vpl VALUES ("GN19_7","002_19_7","GEN","19","7","7","ale balam, “O aga sikisaki, nina munan memek imi me beteralko. ");
INSERT INTO wsk_vpl VALUES ("GN19_8","002_19_8","GEN","19","8","8","Ikialko. Aninga kuriang imet ilagala mu kari arungu katir me animan, mena. Umutang arungak aratik se nina aguwaya arungak beteralko mu beteralko. Bare nina kari imi nungumik te kilek memek bo me beteralko. Nuna aninga daup, se ani ninguru nunga bituekko.” ");
INSERT INTO wsk_vpl VALUES ("GN19_9","002_19_9","GEN","19","9","9","Bare nuna balman, “Lage bitar ale tagi toko!” maman. Nuna Lot ko balukasan, “Kari imi kari iwareng, bare aking tutera kari ko aratukko kaeso e?” Ale balukasan, “Ni me tagi to, mu ana kari mu nungumik te memek luan nuam bita se, ni mu eng am memek biyala to bore ko,” maman. Ale Lot am guguna tuikasan, ale songkuring batagarmonko Lot kokosa te ita diruwuman. ");
INSERT INTO wsk_vpl VALUES ("GN19_10","002_19_10","GEN","19","10","10","Bare kari ilagala kawam ningi mu nuguting garukuman ale Lot tagiman se kawam ningi kasu naguram se songkuring baguman. ");
INSERT INTO wsk_vpl VALUES ("GN19_11","002_19_11","GEN","19","11","11","Ale kari kulak te, garuk te, songkuring karogo sanamiwaman mu nomotam maguwuman se posaman ale kawam songkuring arigimonko me terong. ");
INSERT INTO wsk_vpl VALUES ("GN19_12","002_19_12","GEN","19","12","12","Se engel ilagala mu Lot manorman, “Nika gue suan agi ewela ago, ka iton, ka kuriang kari se imet, se awiriya bo wonong imi te ni karogo ko ikiwasam, mu suen la nunga gi ale wonong imi bitarko. ");
INSERT INTO wsk_vpl VALUES ("GN19_13","002_19_13","GEN","19","13","13","Mu awuk, ana wonong imi menawunakko taiman. Yawe wonong ewere ko bagara memek arigam ikiam ale menawunakko balam se ana taiman.” ");
INSERT INTO wsk_vpl VALUES ("GN19_14","002_19_14","GEN","19","14","14","Se Lot nu Sodom kari ilagala noko nanawusari nongorak namonko nunga luan iluwam mu nongote namaram ale nunga maonam, “Nina pasak barasal ale wonong imi beteralko. Yawe wonong imi maguwurokko pingi aram,” mam. Bare nuna ilagala den mu ikiman mu den kolara ko balman. ");
INSERT INTO wsk_vpl VALUES ("GN19_15","002_19_15","GEN","19","15","15","Se ukira ago engel ilagala mu Lot guguna tuman, “Bares ale ka imet, ka nanawusari ilagala mu nunga gi ale sor imi beteral ale tagi talko! Wonong ewere nunga memek koma tamonko, bare nina karogo memek tal bore ko!” ");
INSERT INTO wsk_vpl VALUES ("GN19_16","002_19_16","GEN","19","16","16","Bare Lot am ikup biya, se engel ilagala kuting te taman, ko kuriang imet ago nuguting te iluman, ale arungak wonong mu ko buring ko arataman. Yawe uwutata gomang nungaram ale nunga saongam. ");
INSERT INTO wsk_vpl VALUES ("GN19_17","002_19_17","GEN","19","17","17","Nongorak arataman se engel bo nunga maonam, “Kueral bore ko, naguralko! Nibiring ko me loagaralko, ale sor wolong te me sanamaralko. Nagural duruk te tarigiralko. Mena mu, memek taiso mu ninga sarumu warukko!” ");
INSERT INTO wsk_vpl VALUES ("GN19_18","002_19_18","GEN","19","18","18","Bare Lot balam, “Aga kari bibiya, suwuta mena ko! ");
INSERT INTO wsk_vpl VALUES ("GN19_19","002_19_19","GEN","19","19","19","Nina nengemang aisiman ale yawarakala aninga sangorman. Bare duruk mu awar biya, se ani tairate me te namarik se ikup mu lage luan te aga iluwok se ani kuerikko. ");
INSERT INTO wsk_vpl VALUES ("GN19_20","002_19_20","GEN","19","20","20","Arigalko. Wonong gotek bo pingi nuam aniso, mu asele ani te tairate nagu namarikko terong mam. Mu wonong gotektir, se aguwaya balal mu ani te nagu namarik ale aimi kaluwurekko.” ");
INSERT INTO wsk_vpl VALUES ("GN19_21","002_19_21","GEN","19","21","21","Se engel nu maonam, “Mu terong. Wonong gotek mu ani betela me maguwurikko. ");
INSERT INTO wsk_vpl VALUES ("GN19_22","002_19_22","GEN","19","22","22","Ario! Tairate wonong mu te nagural namaralko! Nina nama aratal bare asele ani sor maguwurikko.” Lot wonong mu ko balam wonong gotektir ma balam, se nuna wonong mu nup beteman Zoar maman. ");
INSERT INTO wsk_vpl VALUES ("GN19_23","002_19_23","GEN","19","23","23","Worem basu aratuwaram se Lot nama Zoar aratam. ");
INSERT INTO wsk_vpl VALUES ("GN19_24","002_19_24","GEN","19","24","24","Se Yawe tama sulphur karogo kaniwara mu taiti gomang te waram se tuwik iwita Sodom Gomorrah wonong te kaparam se wonong am lilim malilaram. ");
INSERT INTO wsk_vpl VALUES ("GN19_25","002_19_25","GEN","19","25","25","Yawe uwutata wonong ilagala mu se, ko sor wolong se ko kariimet se tam anapeya suen la nunga menawu saparam. ");
INSERT INTO wsk_vpl VALUES ("GN19_26","002_19_26","GEN","19","26","26","Bare Lot ko nuwus giris palagam buring ko loagaram ale nu agotala kani malilaram, ale geragam manga bangawakoyam bangawoso. ");
INSERT INTO wsk_vpl VALUES ("GN19_27","002_19_27","GEN","19","27","27","Sor ukiram tumong biyala Abraham kuwim nu Yawe ilak te munakaram mu te peleram nama sanamaram. ");
INSERT INTO wsk_vpl VALUES ("GN19_28","002_19_28","GEN","19","28","28","Ale motam loagaram se Sodom Gomorrah wonong te animan mu te nama kaparam, se ko sor wolong lilim la tama bur kaetkiriyam barasuwakaso se arigam. ");
INSERT INTO wsk_vpl VALUES ("GN19_29","002_19_29","GEN","19","29","29","Tom Kaem sor wolong mu ko wonong ilagala mu nunga kai maliluwurokko, mu nu Abraham ko wosenga ko ikiam, ale Lot sangaru towa se sor nu te bagaram mu menawuram. ");
INSERT INTO wsk_vpl VALUES ("GN19_30","002_19_30","GEN","19","30","30","Lot Zoar wonong te bagarukko nguangaram. Ale ko nanawusari ilagala nunga giam ale arungak duruk te nama tarigiman ale manga gogong ningi bagakasan. ");
INSERT INTO wsk_vpl VALUES ("GN19_31","002_19_31","GEN","19","31","31","Se tom bo ko nanawus biya mu ko uria maonam, “Anananga ba garukaram,” mam. “Ana ko munan nunguning te kari ginakko, bare kari ito imi te ana arungak nanakko mena. ");
INSERT INTO wsk_vpl VALUES ("GN19_32","002_19_32","GEN","19","32","32","Buta se nanga ba yu tunak se nauk ale ninguru ngualaruk se ilak aninak ale kuriang ilunak se nanga nainet ko nup me menarukko,” mam. ");
INSERT INTO wsk_vpl VALUES ("GN19_33","002_19_33","GEN","19","33","33","Se tirom nuna ilagala nunga nonet waen tuman se nam ale ninguru ngualaram. Se ko nanawus biya tairam nuet ilak aniram. Bare nunga nonet waen ninguru ngualawuram se ko nanawus kiwem nu ilak beteram mu nu me ko ikiam. ");
INSERT INTO wsk_vpl VALUES ("GN19_34","002_19_34","GEN","19","34","34","Aking ukiram se ko nanawus biya mu ko uria gotek mu maonam, “Ekalako ani ba ilak anirem. Se aitak tirom imi mu aking waen tunak se nauk ngualaruk se ni ani beterem turan ilak anirko. Se nu te nanga nainet ko nup me menarukko.” ");
INSERT INTO wsk_vpl VALUES ("GN19_35","002_19_35","GEN","19","35","35","Se tirom aking waen tuman se nam ngualaram, se ko nanawus gotek mu ilak aniram. Nu ninguru ngualaram, ale nu akingtala nanawus gotek mu kiwem nu ilak beteram mu nu me ko ikiam. ");
INSERT INTO wsk_vpl VALUES ("GN19_36","002_19_36","GEN","19","36","36","Buta se kuriang itiwik ilagala mu nongota nunga nonet Lot kumik te nutagu aratam. ");
INSERT INTO wsk_vpl VALUES ("GN19_37","002_19_37","GEN","19","37","37","Se biya mu kuriang kari iluwam ale ko nup Moab mam, mu nu Moab kariimet nunga girigir. ");
INSERT INTO wsk_vpl VALUES ("GN19_38","002_19_38","GEN","19","38","38","Se ko nanawus gotek mu kuriang kari iluwam tala, ale ko nup Bet-Ami mam. Bet-Ami mu Amon kariimet aitak am anisan wore nunga girigir. ");
INSERT INTO wsk_vpl VALUES ("GN20_1","002_20_1","GEN","20","1","1","Abraham Mamre sor beteram ale Negev namaram, ale wonong ilagala Kadesh se Shur ko kusumuri bagakaso. Ale tom nu Gerar sor te baga se mu, ");
INSERT INTO wsk_vpl VALUES ("GN20_2","002_20_2","GEN","20","2","2","noko nuwus Sarah mu noko koras ko ma balam. Se Gerar ko king Abimelech Sarah ko balam, se ilak kote taiman. ");
INSERT INTO wsk_vpl VALUES ("GN20_3","002_20_3","GEN","20","3","3","Bare tirom bo te Kaem ipingira te Abimelech kote tairam ale maonam, “Ni mu am kua namarko wore marak bagasam, mu awuk, ni imet sumu ko kari karogo bare ni taem.” ");
INSERT INTO wsk_vpl VALUES ("GN20_4","002_20_4","GEN","20","4","4","Bare Abimelech Sarah ilak me katir aniram. Se nu balam, “Kari Biya, ani memek bo me beterem. Bare ni aninga kariimet ago aga bita maguwurko e? ");
INSERT INTO wsk_vpl VALUES ("GN20_5","002_20_5","GEN","20","5","5","Ikiko. Abraham kota Sarah noko koras ma balam. Se Sarah betela Abraham mu noko koras mam. Se aninga ikia te nu nunguningta balam makasam, ale memek bo betesam iwita me ko ikikasam. Buta se ani memek bo me beterem.” ");
INSERT INTO wsk_vpl VALUES ("GN20_6","002_20_6","GEN","20","6","6","Se Kaem ipingira mu ningi nu maonam, “Nunguningta, mu ani ikiem, ni me ikia se uwuta beterem. Buta se ani nika ikia kalem, ni amakete kilek memek bitar bore ko, se ni nu ilak me taga anirem. ");
INSERT INTO wsk_vpl VALUES ("GN20_7","002_20_7","GEN","20","7","7","Se aitak kari mu ko nuwus sumu tuiko! Nu prophet bo, se ni ko ko ngatangaruk se me kuarko. Bare ni me tui, mu ni ko ikiko, ni ka kariimet suen la ago kueralko.” ");
INSERT INTO wsk_vpl VALUES ("GN20_8","002_20_8","GEN","20","8","8","Se ukiram se tumong biyala Abimelech ko kari supuling nunga auram se taiman, se mel aratam mu ko nunga maonam. Se nuna ninguru nguangakasan. ");
INSERT INTO wsk_vpl VALUES ("GN20_9","002_20_9","GEN","20","9","9","Asele Abimelech Abraham auram se kote tairam se isuam, “Ni awuk se ana nogo ko kilek suwutata beterem a? Ani anape memek nikate beterem se ni ani aga kariimet ago ikup memek ewere nangarem? Ni kiwem bo ani angimik te me bitarko wore beterem. ");
INSERT INTO wsk_vpl VALUES ("GN20_10","002_20_10","GEN","20","10","10","Ni anape duap ko suwutata beterem?” ");
INSERT INTO wsk_vpl VALUES ("GN20_11","002_20_11","GEN","20","11","11","Se Abraham den koma balam, “Ani iki paguwurem, sor ewere ko kariimet Kaem ko me nguangasan iwita ikiem, ale Sarah ko aninga momon se kuerikko iwita ikiem ale ani uwutata beterem. ");
INSERT INTO wsk_vpl VALUES ("GN20_12","002_20_12","GEN","20","12","12","Bare mel bo tala mu nunguningta Sarah mu aninga agoras. Anananga nainet duap suanta, bare nainam mu kirker. Se ani nu aga imet ko taem. ");
INSERT INTO wsk_vpl VALUES ("GN20_13","002_20_13","GEN","20","13","13","Se ulengkala Kaem aninga ait ko duap yager bitirikko balam. Se ani barasikko se Sarah iwita manem, ‘Ana sor saki te geraga se mu, ni aninga angamang motam balik mu karo tui mu asele nunguningta ni aninga kuesam maikko. Aninga angamang mu ana apareyate namanak, mu ni aninga agoras ko nimi baluko,’ maem.” ");
INSERT INTO wsk_vpl VALUES ("GN20_14","002_20_14","GEN","20","14","14","Se Abimelech sipsip se bulmakau se ura dungan kariimet sang ago Abraham tuam. Ale Sarah karogo tuam. ");
INSERT INTO wsk_vpl VALUES ("GN20_15","002_20_15","GEN","20","15","15","Ale maonam, “Arikko, ali imi lilim la mu aninga. Bare ni koma aguwaya mu te dagiko, mu am te dagiko.” ");
INSERT INTO wsk_vpl VALUES ("GN20_16","002_20_16","GEN","20","16","16","Ale Sarah maonam, “Ani nika kariimet nomokete manga silver 1000 imi ka koras tusam, mu aninga dolara nikate mu diasam. Ni memek bo me beterem.” ");
INSERT INTO wsk_vpl VALUES ("GN20_17","002_20_17","GEN","20","17","18","Sarah kumik te, Yawe Abimelech ko nuwus se ko ura dungan imet suen la nutagu kaolam se kuriang me ilukasan. Se Abraham Kaem kote wosengam, se Kaem Abimelech saongam, ale ko nuwus se ko ura dungan imet nunga nutagu kaogam, se aking kuriang ilukasan. ");
INSERT INTO wsk_vpl VALUES ("GN21_1","002_21_1","GEN","21","1","1","Yawe maingkala balu beteram uwutata, ko nunguning Sarah kumik te beteram. ");
INSERT INTO wsk_vpl VALUES ("GN21_2","002_21_2","GEN","21","2","2","Abraham garukaram nunguningkiri, bare Sarah tuagu aratam se tom Kaem maingkala balu beteram mu te kuriang kari iluwam. ");
INSERT INTO wsk_vpl VALUES ("GN21_3","002_21_3","GEN","21","3","3","Se Abraham kuriang nup beteram Isaac mam. ");
INSERT INTO wsk_vpl VALUES ("GN21_4","002_21_4","GEN","21","4","4","Udagi day 8 namaram se Abraham Kaem balam butata ko kuriang Isaac kumik guang batogam. ");
INSERT INTO wsk_vpl VALUES ("GN21_5","002_21_5","GEN","21","5","5","Abraham ko yia tom 100 bagaram se Sarah kuriang Isaac iluwam. ");
INSERT INTO wsk_vpl VALUES ("GN21_6","002_21_6","GEN","21","6","6","Se Sarah iwita balam, “Kaem ani gusira amilmil aisam. Se awiriya ani ago ko den ikiok, mu ani agarak karogo gusirok amilmilarukko.” ");
INSERT INTO wsk_vpl VALUES ("GN21_7","002_21_7","GEN","21","7","7","Akingtala balam, “Kariimet bo mel bo iwita Abraham kumik te aratukko me ko ikiwaram, bare aitak nu garuk ningi ta ani ko namar ilu tuem.” ");
INSERT INTO wsk_vpl VALUES ("GN21_8","002_21_8","GEN","21","8","8","Se kuriang Isaac lagaram ale amin beteram, se Abraham ko na biya bo beteram. ");
INSERT INTO wsk_vpl VALUES ("GN21_9","002_21_9","GEN","21","9","9","Se Abraham ko kuriang Egypt imet Hagar tuagu te mu Isaac ilak kola se beta te atumu tokaso, se Sarah arigam, ");
INSERT INTO wsk_vpl VALUES ("GN21_10","002_21_10","GEN","21","10","10","ale Abraham maonam, “Ura dungan imet ko kuriang ilak nunga karoko!” mam. “Imet sumu ko kuriang nika mel sang me giokko. Mel suen biya imi mu aninga kuriang Isaac ko la,” mam. ");
INSERT INTO wsk_vpl VALUES ("GN21_11","002_21_11","GEN","21","11","11","Se Sarah den balam mu Abraham gomang motam ninguru batagam, mu awuk, Ishmael mu noko kuriang tala. ");
INSERT INTO wsk_vpl VALUES ("GN21_12","002_21_12","GEN","21","12","12","Bare Kaem nu maonam, “Ni ura dungan imet mu ko kuriang ilak me nunga gemang batagukko. Ni Sarah den balso mu karo tuiko, mu awuk, noko kuriang Isaac ko tuagu te ani kariimet gue nunga balem mu aratamonko. ");
INSERT INTO wsk_vpl VALUES ("GN21_13","002_21_13","GEN","21","13","13","Bare ani balik se nika ura dungan imet ko kuriang umu ko kuriang imas, ko taleng girigir suen biya tala aratamonko, mu awuk, nu nika kuriang tala.” ");
INSERT INTO wsk_vpl VALUES ("GN21_14","002_21_14","GEN","21","14","14","Ukiram se tumong biyala Abraham na se, goat kumik guang te yu kuting nungurman mu giam, ale ago nama Hagar biwinang te awuram, ale ko kuriang ilak nunga awuram se namakasan. Nuna nama sor merang Beersheba koma mu te geraga dalela se bagakasan. ");
INSERT INTO wsk_vpl VALUES ("GN21_15","002_21_15","GEN","21","15","15","Tom nunga yu giman mu menaram, mu Hagar ko kuriang ilak nama tam gotek bo bowa ningi beteram se bagakaso. ");
INSERT INTO wsk_vpl VALUES ("GN21_16","002_21_16","GEN","21","16","16","Se nu nama awar nuam daigam ale ikia moakaso, se kuamin tugukaso, “Ani kuriang ari sagarik se kuerukko me ko kuesam,” makaso. Ale nu daigam baga kuriang niakaso se nu ago niakaso. ");
INSERT INTO wsk_vpl VALUES ("GN21_17","002_21_17","GEN","21","17","17","Se Kaem kuriang mu ko niara ikiam. Se ko engel duruk te baga se Hagar auram ale maonam, “Hagar, ni anape ko ikia ka moa lagoso ya? Me nguangerko! Kaem kuriang niakaso mu ikiam. ");
INSERT INTO wsk_vpl VALUES ("GN21_18","002_21_18","GEN","21","18","18","Nama kuting te patawur se barasuk se noman taukko, mu awuk, noko gue te ani kariimet motam biya bo bitirik se aratukko,” mam. ");
INSERT INTO wsk_vpl VALUES ("GN21_19","002_21_19","GEN","21","19","19","Ale Kaem Hagar motam sinar awuram se yu mutim bo arigam, ale te namaram yu utuam, ale sang karogo nama kuriang tuam se nam. ");
INSERT INTO wsk_vpl VALUES ("GN21_20","002_21_20","GEN","21","20","20","Kaem kuriang mu bitaruwaram se lagaram kari aram. Nu sor merang Paran mu te bagakaso, ale nu bulamu nana ko kari terong bagakaso. ");
INSERT INTO wsk_vpl VALUES ("GN21_21","002_21_21","GEN","21","21","21","Se nu sor merang mu te bagaram se ko nuam Egypt imet bo to tuam. ");
INSERT INTO wsk_vpl VALUES ("GN21_22","002_21_22","GEN","21","22","22","Tom mu te King Abimelech ko kager kari supuling Phicol ilak Abraham kote taiman ale iwita ilak munakaman, “Kaem ni kerak bagoso se mel suen biya betesam mu ningo la arataso. ");
INSERT INTO wsk_vpl VALUES ("GN21_23","002_21_23","GEN","21","23","23","Buta se ni Kaem koma te den ningo bo aga manaruko, ni pempem la ani agarak, agi aga kuriang alo aga taleng girigir nangarak, ningo la bita se lagerko. Ni taira kari bo iwita ali imi te dagiwasam. Buta se ani ningo kerak bitakasam iwita, ni ani agarak se aga sor lilim la nangarak nika ningo mu bitarko.” ");
INSERT INTO wsk_vpl VALUES ("GN21_24","002_21_24","GEN","21","24","24","Se Abraham balam, “Ani butata bitirikko Kaem aninga den ikiwoso,” mam. ");
INSERT INTO wsk_vpl VALUES ("GN21_25","002_21_25","GEN","21","25","25","Asele Abraham ko yu mutim Abimelech ko kari bataguru taman ale guramaman mu ko Abimelech ilak balam. ");
INSERT INTO wsk_vpl VALUES ("GN21_26","002_21_26","GEN","21","26","26","Se Abimelech mam, “Arikaya kiwem sumu beteman mu ani me ko ikisam. Ni awuk se ulengkala ani me aga manem se ani aitakta diram ikiem?” ");
INSERT INTO wsk_vpl VALUES ("GN21_27","002_21_27","GEN","21","27","27","Se Abraham sipsip sang se bulmakau sang ago Abimelech tuam se nuna ilagala den kaloman. ");
INSERT INTO wsk_vpl VALUES ("GN21_28","002_21_28","GEN","21","28","28","Abraham ko sipsip ningi sipsip gotek pagar 7 mu nunga giam ale kilimik nunga awuram. ");
INSERT INTO wsk_vpl VALUES ("GN21_29","002_21_29","GEN","21","29","29","Se Abimelech nu isuam, “Kiwem sumu ko duap awuk?” ");
INSERT INTO wsk_vpl VALUES ("GN21_30","002_21_30","GEN","21","30","30","Se Abraham koma balam, “Sipsip gotek 7 imi aninga agiting kisisam. Imi kausa, ni te iki se lagerko, mu awuk, yu mutim mu ani agata irem.” ");
INSERT INTO wsk_vpl VALUES ("GN21_31","002_21_31","GEN","21","31","31","Se udagi te kariimet sor mu nup beteman Beersheba maman, mu awuk, Abraham se Abimelech mu te den kaloman. ");
INSERT INTO wsk_vpl VALUES ("GN21_32","002_21_32","GEN","21","32","32","Ale mu te numi gomang suanta beteman, ale Abimelech ko kager kari supuling Phicol ilak peleman Philistia namaman. ");
INSERT INTO wsk_vpl VALUES ("GN21_33","002_21_33","GEN","21","33","33","Se Abraham Beersheba sor te tam tamarisk bo aguwam, ale Yawe, nu Kaem tom suen biya bagoso, wore ko nup patawuram. ");
INSERT INTO wsk_vpl VALUES ("GN21_34","002_21_34","GEN","21","34","34","Ale Abraham taira kari iwita Philistia koma mu te tom maiya biya bagakaso. ");
INSERT INTO wsk_vpl VALUES ("GN22_1","002_22_1","GEN","22","1","1","Udagi Kaem Abraham ira arigam. Nu maonam, “Abraham,” mam. Se Abraham “Ani iweya,” mam. ");
INSERT INTO wsk_vpl VALUES ("GN22_2","002_22_2","GEN","22","2","2","Se Kaem maonam, “Ka kuriang suanta Isaac, ni ninguru ko kuesam, mu to ale ilak Moriah sor te namarko. Ale duruk bo ani ko balik mu te namar ale Isaac te tama bur siring yawara bita aisuko,” mam. ");
INSERT INTO wsk_vpl VALUES ("GN22_3","002_22_3","GEN","22","3","3","Se ukiram tumong biyala Abraham barasam ale melmasak gi donkey awote awuram. Ale ko namar Isaac se ko ura kari ilagala ago nunga giam. Nu tama ko tam sang pakokaram nama terong mam, asele nongorak kuwim Kaem balam mu te aolak iluwam namakaso. ");
INSERT INTO wsk_vpl VALUES ("GN22_4","002_22_4","GEN","22","4","4","Day ilagala aolak iluman nama day 3 mu te Abraham motam patawu duruk Kaem balam mu arigam, bare duruk mu katir awar nuam anikaso. ");
INSERT INTO wsk_vpl VALUES ("GN22_5","002_22_5","GEN","22","5","5","Se nu umu te ko ura kari ilagala mu nunga maonam, “Nina imi te donkey karogo bagaral se, ani kuriang ilak koma owore te namanak ale Kaem nup patawunak, ale asele pelenak nengete tainakko,” mam. ");
INSERT INTO wsk_vpl VALUES ("GN22_6","002_22_6","GEN","22","6","6","Ale Abraham tam siping ago te tama bitirukko mu patawu Isaac tuam se giam. Se nu kota mu tama se batir ago giam. Nuna wete aolak iluman nama se, ");
INSERT INTO wsk_vpl VALUES ("GN22_7","002_22_7","GEN","22","7","7","Isaac nuet Abraham isuam, “Ba,” mam. Se Abraham koma ko mam, “Aga namar, baluko,” mam. Se Isaac mam, “Ana tama se tam mu giman, bare sipsip te tama bita Kaem tunakko mu apoko ya?” mam. ");
INSERT INTO wsk_vpl VALUES ("GN22_8","002_22_8","GEN","22","8","8","Se Abraham balam, “Aga namar,” mam, “Kaem kota sipsip te tama betenakko mu nangarukko,” ma se wete aolak iluman namakasan. ");
INSERT INTO wsk_vpl VALUES ("GN22_9","002_22_9","GEN","22","9","9","Nuna nama kuwim Kaem balam mu te arataman, se Abraham umu te altar bo kaolam ale tam awote muram. Ale ko namar Isaac mayang te taliparam, ale patawu tam muram mu awote beteram. ");
INSERT INTO wsk_vpl VALUES ("GN22_10","002_22_10","GEN","22","10","10","Ale batir tam, ale ko namar te morukko, ");
INSERT INTO wsk_vpl VALUES ("GN22_11","002_22_11","GEN","22","11","11","bare Yawe ko engel duruk wonong te baga se auram, “Abraham! Abraham!” mam. Se Abraham “Ani iweya,” mam. ");
INSERT INTO wsk_vpl VALUES ("GN22_12","002_22_12","GEN","22","12","12","Se Yawe ko engel nu maonam, “Ni kiting kuriang sumu kumik te me ta bitar ale kiwem bo kumik te me bitarko. Aitak asele ani ko ikiem, ni Kaem ko nguanga se kuring karo tusam, mu awuk, nika namar suanta diram, bare ni me ko gemang soraram,” mam. ");
INSERT INTO wsk_vpl VALUES ("GN22_13","002_22_13","GEN","22","13","13","Se Abraham motam patawuram ale sipsip anumang bo, ko kom tam kower kutiram se bagaram mu arigam. Ale namaram iluwam ago tairam ale ko namar kuwim te Kaem tama bita tuam. ");
INSERT INTO wsk_vpl VALUES ("GN22_14","002_22_14","GEN","22","14","14","Ale Abraham sor umu nup beteram, “Yawe nangarukko,” mam, (Jehovah-Jireh). Ale tom mu te se tai aitak kariimet balsan, “Yawe ko duruk te mel nangarukko,” masan. ");
INSERT INTO wsk_vpl VALUES ("GN22_15","002_22_15","GEN","22","15","15","Se Yawe ko engel duruk wonong te baga akingtala Abraham auram, ");
INSERT INTO wsk_vpl VALUES ("GN22_16","002_22_16","GEN","22","16","16","ale maonam, “Yawe iwita balam, ‘Ani agata suanta ani Biya, se ani wetang te ka manorsam, ni kiwem ningo beterem ale ka namar suanta sumu ko gemang me soraram. ");
INSERT INTO wsk_vpl VALUES ("GN22_17","002_22_17","GEN","22","17","17","Buta se ani marak ningo nunguningkiri kisek ale ka kuriang gue mu suen biya se kaura koma mena, baras taiti ningi mu iwita, se saun langi mu iwita. Ale sor saki nengerak barimamon mu nuna la nosowek te nunga eremon ale nunga sor mu nobowa tugumonko. ");
INSERT INTO wsk_vpl VALUES ("GN22_18","002_22_18","GEN","22","18","18","Se nika gue te ali likilim ko kariimet marak nungarikko, mu awuk, ni ani agiring karo tuem.’” ");
INSERT INTO wsk_vpl VALUES ("GN22_19","002_22_19","GEN","22","19","19","Asele Abraham peleram tai ko ura kari ilagala mu nongote aratam, asele nuna suen la peleman Beersheba namaman. Se Abraham sor mu te bagakaso. ");
INSERT INTO wsk_vpl VALUES ("GN22_20","002_22_20","GEN","22","20","20","Tom sang namaram se Abraham ko uria Nahor, nuwus Milcah, se nunga namarari ago nunga den ikiam. ");
INSERT INTO wsk_vpl VALUES ("GN22_21","002_22_21","GEN","22","21","21","Kuriang Uz mu laun, se uria Buz, se Kemuel, nu Aram ko nuet, ");
INSERT INTO wsk_vpl VALUES ("GN22_22","002_22_22","GEN","22","22","22","se Kesed, Hazo, Pildash, Jidlaph, se Bethuel. ");
INSERT INTO wsk_vpl VALUES ("GN22_23","002_22_23","GEN","22","23","23","Se Bethuel tuagu te mu Rebekah. Abraham ko uria Nahor ko nuwus Milcah namarari 8 umutang nunga iluwam. ");
INSERT INTO wsk_vpl VALUES ("GN22_24","002_22_24","GEN","22","24","24","Se Nahor ko nuwus uria mu ko nup Reumah, se ko namarari nunga iluwam mu Tebah, Gaham, Tahash se Maakah. ");
INSERT INTO wsk_vpl VALUES ("GN23_1","002_23_1","GEN","23","1","1","Sarah yia 127 ko baga kueram. ");
INSERT INTO wsk_vpl VALUES ("GN23_2","002_23_2","GEN","23","2","2","Nu Canaan sor te Kiriath Arba (Hebron) baga kueram. Se Abraham kumik duap te daigam ale ko mo nia lagakaso. ");
INSERT INTO wsk_vpl VALUES ("GN23_3","002_23_3","GEN","23","3","3","Ale udagi te Abraham nuwus kueram aniwaram mu beteram, ale barasam ale Heth kariimet nongorak munakaram. Nu iwita balam, ");
INSERT INTO wsk_vpl VALUES ("GN23_4","002_23_4","GEN","23","4","4","“Ani taira kari nina nengerak bagasam ewere te se, ani ali bilik nengete diarik ale aga kariimet kuera wore te nunga mutim tugumekko angamang aniso.” ");
INSERT INTO wsk_vpl VALUES ("GN23_5","002_23_5","GEN","23","5","5","Se Heth kariimet Abraham den koma manorman, ");
INSERT INTO wsk_vpl VALUES ("GN23_6","002_23_6","GEN","23","6","6","“Dom kari, ni anananga den ikiko. Anananga ningi ni kari supuling aromemek. Owore te se ka niwus ko kumik guang mu anananga kuera kariimet nunga mutim ningo nunguningkiri umu bo te am mutim tugumko. Ana nanga ningi bo kuera mutim umu ko gomang me ikuwurokko pa!” ");
INSERT INTO wsk_vpl VALUES ("GN23_7","002_23_7","GEN","23","7","7","Se Abraham barasam ale Heth kariimet, sor mu ko kotam, bugura kulukuru nungaram, ");
INSERT INTO wsk_vpl VALUES ("GN23_8","002_23_8","GEN","23","8","8","ale balam, “Bare nenenga nengemang ani aiwus imi te mutim tugumekko, mu nina ani angama tal ale kari Ephron, Zohar ko namar, ilak munakaralko. ");
INSERT INTO wsk_vpl VALUES ("GN23_9","002_23_9","GEN","23","9","9","Ani manga gogong nup balsan Machpelah masan wore diarikko angamang aniso. Manga gogong mu Ephron ko ali ko dun te aniso. Nina isual se ani ko manga gogong mu ko tom te diram la diarik se nenenga ningi aninga ali motam iwita anirukko.” ");
INSERT INTO wsk_vpl VALUES ("GN23_10","002_23_10","GEN","23","10","10","Heth kariimet suen la wonong ko lage kuringi biguwura kuwim te biguwuman. Se Ephron mu karogo nunga ningi dagiwa barasam, ale kariimet suen la nomokete Abraham ko den koma balu tuam: ");
INSERT INTO wsk_vpl VALUES ("GN23_11","002_23_11","GEN","23","11","11","“Mena, aninga dom, balik ewere ikiko. Ali mu kisisam, ale ko manga gogong mu karogotala kisisam. Aninga kariimet nomokete angamang ningi nunguning te kisisam. Ka niwus te mutim tugumko.” ");
INSERT INTO wsk_vpl VALUES ("GN23_12","002_23_12","GEN","23","12","12","Bare Abraham akingtala Heth kariimet, sor mu ko kotam, bugura kulukuru nungaram, ");
INSERT INTO wsk_vpl VALUES ("GN23_13","002_23_13","GEN","23","13","13","ale Ephron maonam, “Aninga agiring ikiko, se kariimet ago ikimonko. Ani ali bilik imi manga te diarikko. Manga mu yam to se ani aga imet te mutim tugumekko.” ");
INSERT INTO wsk_vpl VALUES ("GN23_14","002_23_14","GEN","23","14","14","Se Ephron aking mam, ");
INSERT INTO wsk_vpl VALUES ("GN23_15","002_23_15","GEN","23","15","15","“Agiring ikiko, aga dom. Ali umu ko diara koma mu silver ko ikup 400 shekel, bare analak mel mu ko me balnakko, mu mel yam. Ka imet am te mutim tugumko.” ");
INSERT INTO wsk_vpl VALUES ("GN23_16","002_23_16","GEN","23","16","16","Bare Abraham manga tom Ephron Heth kariimet nomokete balam mu ikiam, ale Ephron maonam, “Terong!” mam. Ale diara kari betesan turantala, nu ko manga giam ale ko ikup skel te tuteram ikiam, ale silver ko ikup 400 shekel to Ephron tuam. ");
INSERT INTO wsk_vpl VALUES ("GN23_17","002_23_17","GEN","23","17","17","Munan mu te Abraham Ephron ko ali Machpelah mu nu dia tam. Se ali mu sor Mamre duap te. Abraham ali mu se ko manga gogong se ko tam melmasak lilim la dia tam. ");
INSERT INTO wsk_vpl VALUES ("GN23_18","002_23_18","GEN","23","18","18","Se Heth kariimet biguwura te animan mu nuna suen la ikiman, ali umu aitak Abraham ko ali ma balman. ");
INSERT INTO wsk_vpl VALUES ("GN23_19","002_23_19","GEN","23","19","19","Asele Abraham ko nuwus Sarah ko kumik guang sor Machpelah ko manga gogong ningi beteram. Mu Mamre duap te (Hebron), se ali lilim Canaan mu te mutim tugumam. ");
INSERT INTO wsk_vpl VALUES ("GN23_20","002_23_20","GEN","23","20","20","Buta se Heth kariimet nunga ali biling manga gogong karogo mu eng am Abraham ko kariimet nunga ali motam ko aram. ");
INSERT INTO wsk_vpl VALUES ("GN24_1","002_24_1","GEN","24","1","1","Abraham aitak mu ninguru garukaram. Yawe sangarukaso se ko kulak te tai garuk ningi anapeya bitakaso mu ningo la aratukaso. ");
INSERT INTO wsk_vpl VALUES ("GN24_2","002_24_2","GEN","24","2","2","Se nu ko ura kari nunga supuling gira nunguningkiri mu maonam, “Ni kiting agaluwong bowa ningi bitar, ale ");
INSERT INTO wsk_vpl VALUES ("GN24_3","002_24_3","GEN","24","3","3","Yawe, duruk wonong se ali ko Kaem koma te balu, Canaan sor ani te bagasam imi ko imet bo to ale aninga namar me tuiko. ");
INSERT INTO wsk_vpl VALUES ("GN24_4","002_24_4","GEN","24","4","4","Bare piler aninga wonong duap te namar ale aninga gue suan ningi Isaac ko imet toko.” ");
INSERT INTO wsk_vpl VALUES ("GN24_5","002_24_5","GEN","24","5","5","Se ko ura kari balam, “Bare imet umu ko wonong duap bitiruk ale imi te tairukko me amilmilaruk, mu ani nika namar la ilak nika sor duap te pelerik agi awuk?” ");
INSERT INTO wsk_vpl VALUES ("GN24_6","002_24_6","GEN","24","6","6","Bare Abraham koma balam, “Mena!” mam. “Ni aninga kuriang to ale ilak mu te me namarko! ");
INSERT INTO wsk_vpl VALUES ("GN24_7","002_24_7","GEN","24","7","7","Yawe, duruk wonong ko Kaem, aga wonong duap, aga singsang ningi, aga aru tam, ale den balam ale nunguningta nunguning mam, nu ali imi aninga taleng girigir nungarukko balam, mu borta ko engel bitiruk se girok namarukko. Se sor umutang te ni aninga namar ko imet mu arikko. ");
INSERT INTO wsk_vpl VALUES ("GN24_8","002_24_8","GEN","24","8","8","Bare imet ni kerak tairukko me amilmilaruk, mu terong, mu nikate memek bo mena. Bare ni aninga namar to ale ilak aninga wonong duap te me namarko.” ");
INSERT INTO wsk_vpl VALUES ("GN24_9","002_24_9","GEN","24","9","9","Se ura kari ko kuting Abraham kualuwong bowa ningi beteram ale maonam, “Ni balsam butata bitirikkowo!” mam. ");
INSERT INTO wsk_vpl VALUES ("GN24_10","002_24_10","GEN","24","10","10","Ale Abraham ko camel 10, se mel ningo saki ago giam. Ale nu mel suen la nungam, ale Aram Naharaim ko lage kaoram ale Nahor ko wonong te namakaso. ");
INSERT INTO wsk_vpl VALUES ("GN24_11","002_24_11","GEN","24","11","11","Ale nama wonong nung te aratam, bare watingi yu mutim duap te camel nunga awuram se dagiman nonoman sapawakasan. Umu bainga ningi, se imet nunga yu utua ko tom tala. ");
INSERT INTO wsk_vpl VALUES ("GN24_12","002_24_12","GEN","24","12","12","Se nu Yawe auram, “O Yawe, aninga dom Abraham ko Kaem, ni aninga ura guyak awur, ale aninga dom Abraham ko gomang motam nunguruko. ");
INSERT INTO wsk_vpl VALUES ("GN24_13","002_24_13","GEN","24","13","13","Ani yu imi duap te bagasam. Se wonong imi ko imet itiwik yu utumonko taiwasan. ");
INSERT INTO wsk_vpl VALUES ("GN24_14","002_24_14","GEN","24","14","14","Se aninga angamang mu taimon se nunga ningi bo manik, ‘Ka yu kuting te yu sang utu aisu se naikko,’ maik, se nu baluk, ‘Ni no se ani sang ka camel nungarik se namonko,’ ma baluk, umutang te ani ko ikiek, imet borta ni atumukirem se nu nika ura kari Isaac ilak naukko. Se umu te betela ani ko ikiek, ni aninga dom kari ko gomang motam nungem maikko.” ");
INSERT INTO wsk_vpl VALUES ("GN24_15","002_24_15","GEN","24","15","15","Nu guranek menawuwaram mu Rebekah yu kuting biwinang te giam ale taikaso. Rebekah mu nu Bethuel ko nanawus. Se Bethuel mu Abraham uria Nahor nuwus Milcah ilak nutagu te aratam. ");
INSERT INTO wsk_vpl VALUES ("GN24_16","002_24_16","GEN","24","16","16","Se imet itiwik mu koma motam balayam nunguningkiri; nu kari bo ilak tom bo te me aniram. Nu yu mutim te kaparam yu utuam ale karogo bausam. ");
INSERT INTO wsk_vpl VALUES ("GN24_17","002_24_17","GEN","24","17","17","Se ura kari mu biririkaram kote namaram ale mam, “Yu sang ais se naikko,” mam. ");
INSERT INTO wsk_vpl VALUES ("GN24_18","002_24_18","GEN","24","18","18","Se Rebekah balam, “Mu terong,” mam. Ale yu kuting ago mu kutuwuram ale iluwam se ura kari nokaso. ");
INSERT INTO wsk_vpl VALUES ("GN24_19","002_24_19","GEN","24","19","19","Ura kari yu no saparam se itiwik umu maonam, “Ani ka camel agotala yu nungarik se namon ale nungumik terong maukko,” mam. ");
INSERT INTO wsk_vpl VALUES ("GN24_20","002_24_20","GEN","24","20","20","Ale yu kuting ago mu tawir camel te yu nasan mu ningi waram se nokasan. Se aking naguram namaram yu kuting mu aking utuam karogo tai waru nungaram, ale butata tala bitawaram se camel suen la yu naman nungumik karogo terong ma sapaman. ");
INSERT INTO wsk_vpl VALUES ("GN24_21","002_24_21","GEN","24","21","21","Ura kari mu kutek mam, ale itiwik mu kiwem bitakaso mu ari se, Yawe noko aolak mu ko nunguning wetang saparuk agi wore ko motam bitakaso. ");
INSERT INTO wsk_vpl VALUES ("GN24_22","002_24_22","GEN","24","22","22","Tom camel yu no sapaman asele ura kari mu nangamuru ko ring bo, gold te nunga se ko ikup 6 gram iwita mu se, nagiting ko paspas ilagala, gold te nunga se suan suan ko ikup mu 120 gram iwita, mu woyam ale ");
INSERT INTO wsk_vpl VALUES ("GN24_23","002_24_23","GEN","24","23","23","tui se isuam, “Ni awiri ko nanawus a?” mam. “Ni awuk ikisam? Nika niet ko kawam te mu ana kuwim te aninakko karogo agi?” ");
INSERT INTO wsk_vpl VALUES ("GN24_24","002_24_24","GEN","24","24","24","Se itiwik mu balam, “Ani Bethuel ko nanawus. Se aninga ait mu Nahor Milcah nunga namar.” ");
INSERT INTO wsk_vpl VALUES ("GN24_25","002_24_25","GEN","24","25","25","Ale mam, “Ananangate camel nunga kuwim ningo ago, se nunga inang terong la aniso. Se galung nina te aniralko mu karogotala.” ");
INSERT INTO wsk_vpl VALUES ("GN24_26","002_24_26","GEN","24","26","26","Se Abraham ko ura kari mu bugura kulukam, ale Yawe nup patawu se ");
INSERT INTO wsk_vpl VALUES ("GN24_27","002_24_27","GEN","24","27","27","balam, “Yawe, ni nip biya. Ni aninga dom Abraham ko Kaem. Ni noko gomang motam se nika ningo nu ilak beterem mu ko kamili me saposo. Se ani betela, ni Yawe, ani lage aga kausem, se tai aga dom ko gue suan nongote aratem, mu ko amilmil kisisam.” ");
INSERT INTO wsk_vpl VALUES ("GN24_28","002_24_28","GEN","24","28","28","Se imet itiwik mu naguram ko kawam te namaram, ale nuam se suen la kawam te mu mel suen biya nu kumik te aratam mu nunga maonam. ");
INSERT INTO wsk_vpl VALUES ("GN24_29","002_24_29","GEN","24","29","30","Se Rebekah ko koras ko nup mu Laban. Nu karogotala den Rebekah balam mu iki saparam, ale gold ring ko koras Rebekah nung kuamuru te mu arigam, aking gold ring ilagala kuting te mu agotala arigam, ale aratam biririka namaram ale Abraham ko ura kari yu mutim duap te camel nongorak bagaram mu arigam. ");
INSERT INTO wsk_vpl VALUES ("GN24_31","002_24_31","GEN","24","31","31","Ale auram ale balam, “Yawe ni kerak bagoso. Ni tairko. Ni anape ko ewerete sanami lagasam? Namanakko. Ani nika kiwim sor nungem, ale ka camel nunga karogo nungem.” ");
INSERT INTO wsk_vpl VALUES ("GN24_32","002_24_32","GEN","24","32","32","Se Abraham ko ura kari mu kawam te namaram. Se camel nungumik te melmasak mu giman se kaparam, se sua merang te animonko mu se, sirsir inang ko namonko mu karogo tai awuman. Ale yu Abraham ko ura kari, ko ura kari arungu nusuwik te anumonko mu karogo tai nungarman. ");
INSERT INTO wsk_vpl VALUES ("GN24_33","002_24_33","GEN","24","33","33","Asele na nungarman. Bare ura kari mu balam, “Ani anapeya ko tairem mu balik se ikial, asele na naikko,” mam. Se Laban balam, “Buta, balu se ikinakko.” ");
INSERT INTO wsk_vpl VALUES ("GN24_34","002_24_34","GEN","24","34","34","Se ura kari duap beteram, “Ani Abraham ko ura kari. ");
INSERT INTO wsk_vpl VALUES ("GN24_35","002_24_35","GEN","24","35","35","Yawe aninga dom biya mu marak ninguru tuam, se nu kari aromemek, kumik mel ago bagoso. Yawe mel suen biya nu tuam: sipsip se bulmakau, silver se gold, ura kari se ura imet, se camel se donkey ago terong mam. ");
INSERT INTO wsk_vpl VALUES ("GN24_36","002_24_36","GEN","24","36","36","Se noko nuwus Sarah garuk ningi ta kuriang kari iluwam, se aninga dom biya mu ko mel suen la mu ko namar umu tuam. ");
INSERT INTO wsk_vpl VALUES ("GN24_37","002_24_37","GEN","24","37","37","Aninga dom biya aga isuam se aing maem, se den aora biya iwita aga maonam, ‘Ni Canaan sor imi, nunga ali bilik ani te dagiwasam umu ko imet itiwik bo to aninga namar ko nuwus iwita me tuiko. ");
INSERT INTO wsk_vpl VALUES ("GN24_38","002_24_38","GEN","24","38","38","Bare aninga ait ko duap yager te namar ale, aninga gue suan nunga ningi aninga namar ko imet bo arikko,’ mam. ");
INSERT INTO wsk_vpl VALUES ("GN24_39","002_24_39","GEN","24","39","39","“Se aninga dom biya mu aking iwita isuem, ‘Se imet itiwik mu ani agarak tairukko me amilmilaruk agi mu, ani awuk bitirikko?’ ");
INSERT INTO wsk_vpl VALUES ("GN24_40","002_24_40","GEN","24","40","40","“Se nu koma balam, ‘Yawe koma te ani diram la aolak ilu lagasam mu, noko engel bo bitiruk se ni kerak namaruk, se aolak imi ningo la aratuk, se ni aninga ait ko duap yager se aninga gue suan ningi aga namar ko imet bo arikko. ");
INSERT INTO wsk_vpl VALUES ("GN24_41","002_24_41","GEN","24","41","41","Se ni aga gue suan ningi namar se imet itiwik umu guramamon agi mu, ni kimik den mena.’ Nu uwutata aga maonam. ");
INSERT INTO wsk_vpl VALUES ("GN24_42","002_24_42","GEN","24","42","42","“Buta se aitakta kowarkalal ani tai yu mutim duap te aratem mu ani Yawe iwita aru manem: ‘Yawe, aninga dom Abraham ko Kaem, ni aninga sangaru se anapeya bitirik mu ningo la aratukko.’ ");
INSERT INTO wsk_vpl VALUES ("GN24_43","002_24_43","GEN","24","43","43","Ale aking manem, ‘Ani yu mutim duap te bagasam. Se imet itiwik bo yu utuokko tairuk se ani isuek, yu sang utu aisu se naikko maik, ");
INSERT INTO wsk_vpl VALUES ("GN24_44","002_24_44","GEN","24","44","44","se nu baluk, no se ani sang utuek ale ka camel nungarikko mauk, mu te ani ko ikiek, mu imet borta Yawe aninga dom ko namar ko nuwus ko atumukiram maikko.’ ");
INSERT INTO wsk_vpl VALUES ("GN24_45","002_24_45","GEN","24","45","45","“Ani uwutata angamang ningi la baluwerem se Rebekah yu kuting giam ale tairam, ale yu mutim te nama kaparam ale yu utuam. Se ani nu manem, ‘Yu sang aisuko,’ maem. ");
INSERT INTO wsk_vpl VALUES ("GN24_46","002_24_46","GEN","24","46","46","“Se tairatela nu yu aisam ale balam, ‘No se, ani ka camel karogo la yu nungarikko,’ mam. Se ani naem, asele nu camel yu nungaram. ");
INSERT INTO wsk_vpl VALUES ("GN24_47","002_24_47","GEN","24","47","47","“Se ani nu isuem, ‘Ni awiri ko nanawus a?’ maem. Se nu mam, ‘Ani Bethuel ko nanawus. Se Bethuel mu Nahor Milcah nunga namar.’ “Asele ani ring kuamuru te beterem, ale paspas kuting te beterem. ");
INSERT INTO wsk_vpl VALUES ("GN24_48","002_24_48","GEN","24","48","48","Ale ani bugura kulukem ale Yawe amilmil tuem. Nu aninga dom Abraham ko Kaem, se ani nup patawurem. Nu aninga kiti gurugam ale diram nenengate agarak tairam, se aninga dom ko namar ko nuwus mu nenenga ningi arigem. ");
INSERT INTO wsk_vpl VALUES ("GN24_49","002_24_49","GEN","24","49","49","Buta se nina aninga dom biya ko gomang motam nungal agi mena mu aga maonal, se aking aguwaya bitirikko mu ko iki gurugekko.” ");
INSERT INTO wsk_vpl VALUES ("GN24_50","002_24_50","GEN","24","50","50","Se Laban ko nuet Bethuel ilak den koma iwita balman, “Yawe kota lage imi beteram. Se awuk balnakko? ");
INSERT INTO wsk_vpl VALUES ("GN24_51","002_24_51","GEN","24","51","51","Rebekah to ale ilak namar se, Yawe balam butata, nika dom biya ko namar mu ilak naukko.” ");
INSERT INTO wsk_vpl VALUES ("GN24_52","002_24_52","GEN","24","52","52","Se Abraham ko ura kari den umu ikiam ale bugura kulukam ale Yawe amilmil tuam. ");
INSERT INTO wsk_vpl VALUES ("GN24_53","002_24_53","GEN","24","53","53","Asele bala mel silver gold te nungurman, ningo ningo, se guang ningo woya Rebekah tuam. Ale melmasak ningo ningo, ko manga tom kalel biya, mu munan iwita Laban nuam ilak nungaram. ");
INSERT INTO wsk_vpl VALUES ("GN24_54","002_24_54","GEN","24","54","54","Asele nu ko kari arungak na yu naman giman, ale nunga kawam mu te nongorak animan. Tumongola barasaman se nu nunga maonam, “Aga saongal ale aga melmasak nungal burangaral, se aninga kari dom kote pelerik namarikko,” mam. ");
INSERT INTO wsk_vpl VALUES ("GN24_55","002_24_55","GEN","24","55","55","Bare Rebekah ko nuam se ko koras iwita balman, “Ngual am Rebekah beteral se day 10 iwita nangarak bagaruk, asele ilak namaralko,” maman. ");
INSERT INTO wsk_vpl VALUES ("GN24_56","002_24_56","GEN","24","56","56","Bare nu nunga maonam, “Yawe aninga saongam se aninga aolak mu ningo la aratam. Buta se me aga kaolal, aga beteral se aninga kari dom kote pelerik namarikko.” ");
INSERT INTO wsk_vpl VALUES ("GN24_57","002_24_57","GEN","24","57","57","Se nuna balman, “Ana itiwik mu arunak se tairuk se ko gomang ikinakko,” maman. ");
INSERT INTO wsk_vpl VALUES ("GN24_58","002_24_58","GEN","24","58","58","Ale aruman se tairam se isarman, “Ni kari imi ilak namarko agi mena e?” Se nu balam, “Ani nu ilak namarikko,” mam. ");
INSERT INTO wsk_vpl VALUES ("GN24_59","002_24_59","GEN","24","59","59","Se nuna nunga nogoras Rebekah se ko bitua imet mu ilak, Abraham ko ura kari alo nuguting te nunga awu se, ");
INSERT INTO wsk_vpl VALUES ("GN24_60","002_24_60","GEN","24","60","60","marak sangam den iwita nunga nogoras Rebekah manorman, “Nanga nagoras, nika tagu te ka imas bitir kaparuk ale sor magarukko! Ale sor saki nengerak barimamon mu, nuna la nosowek te nunga eremon ale nunga sor mu nobowa tugumonko.” ");
INSERT INTO wsk_vpl VALUES ("GN24_61","002_24_61","GEN","24","61","61","Se Rebekah ko saonga imet itiwik sang ago nunumi nungurman, ale camel te aragaman, ale eng arungak namakasan. Se ura kari uwutata Rebekah tam ale ilak namaram. ");
INSERT INTO wsk_vpl VALUES ("GN24_62","002_24_62","GEN","24","62","62","Tom mu te mu Isaac Beer Lahai Roi beteram ale tairam Negev bagakaso. ");
INSERT INTO wsk_vpl VALUES ("GN24_63","002_24_63","GEN","24","63","63","Ale tom bo bainga ningi, noman sapa aolak ilu geragawa, motam namaram se camel taiwaman mu nungarkam. ");
INSERT INTO wsk_vpl VALUES ("GN24_64","002_24_64","GEN","24","64","64","Se Rebekah betela motam namaram se Isaac arigam. Ale camel awote mu kaparam, ");
INSERT INTO wsk_vpl VALUES ("GN24_65","002_24_65","GEN","24","65","65","ale Abraham ko ura kari isuam, “Kari mu awuk wore aolak iluwam ananangate taiso ya?” mam. Se ura kari balam, “Mu aninga dom taiwoso,” mam. Se Rebekah guang supuling te iram mu ko kopa tam ale kuamuru kuring kaluwuram. ");
INSERT INTO wsk_vpl VALUES ("GN24_66","002_24_66","GEN","24","66","66","Se ura kari mel suen biya beteram mu Isaac maonam. ");
INSERT INTO wsk_vpl VALUES ("GN24_67","002_24_67","GEN","24","67","67","Se Isaac Rebekah tam ale ilak ko nuam Sarah ko kawam sel ningi ilak namaram, ale eng am nunumi giman. Se Rebekah Isaac nuwus aram, se Isaac ninguru ko kuakaso, ale ko nuam Sarah kueram se ko gomang bataga mu menaram. ");
INSERT INTO wsk_vpl VALUES ("GN25_1","002_25_1","GEN","25","1","1","Abraham imet bo tala aking tam, ko nup Keturah. ");
INSERT INTO wsk_vpl VALUES ("GN25_2","002_25_2","GEN","25","2","2","Se Abraham ko gue Keturah tuagu te mu Zimran, Jokshan, Medan, Midian, Ishbak, se Shuah. ");
INSERT INTO wsk_vpl VALUES ("GN25_3","002_25_3","GEN","25","3","3","Abraham namar Jokshan tuagu te mu Sheba se Dedan. Se Asshur, Letush, se Leum kariimet mu Dedan ko gue te ko kariimet. ");
INSERT INTO wsk_vpl VALUES ("GN25_4","002_25_4","GEN","25","4","4","Se Abraham namar Midian ko namarari mu Ephah, Epher, Hanoch, Abida, se Eldaah. Se kariimet imi suen la Keturah tuagu te ko kariimet. ");
INSERT INTO wsk_vpl VALUES ("GN25_5","002_25_5","GEN","25","5","5","Abraham ko melmasak suen la Isaac tuam. ");
INSERT INTO wsk_vpl VALUES ("GN25_6","002_25_6","GEN","25","6","6","Bare tom nu marak baga se, mu ko kuriang sang imet saki nutagu te mu melmasak munan iwita nungaru gurugam, ale nunga beteram se ko namar Isaac kumik duap te mena, ali koma worem bausa mu te namaman bagakasan. ");
INSERT INTO wsk_vpl VALUES ("GN25_7","002_25_7","GEN","25","7","7","Abraham ko bagara tom ilu biguwu sapara mu 175 yia. ");
INSERT INTO wsk_vpl VALUES ("GN25_8","002_25_8","GEN","25","8","8","Nu garukaram nunguningkiri, noko yia suen biya, asele kueram. Nu ko nuet nongotak nogowom karo namaram. ");
INSERT INTO wsk_vpl VALUES ("GN25_9","002_25_9","GEN","25","9","9","Se ko namarari ilagala, Isaac se Ishmael, Machpelah ko manga gogong, Mamre duap te, Heth kari Zohar ko namar Ephron ko ali te, mutim tuguman. ");
INSERT INTO wsk_vpl VALUES ("GN25_10","002_25_10","GEN","25","10","10","Abraham ali mu Heth kariimet nongote dia tam ale ko nuwus Sarah te mutim tugumam wore te nu agotala mutim tuguman. ");
INSERT INTO wsk_vpl VALUES ("GN25_11","002_25_11","GEN","25","11","11","Abraham kueram se Kaem Isaac marak sokel tuam. Tom mu te Isaac Beer Lahai Roi bagakaso. ");
INSERT INTO wsk_vpl VALUES ("GN25_12","002_25_12","GEN","25","12","12","Imi Abraham namar Ishmael ko kuriang gue nunga nunup. Ishmael mu Egypt imet Hagar, Sarah ko ura dungan imet, wore tuagu te bilangaram. ");
INSERT INTO wsk_vpl VALUES ("GN25_13","002_25_13","GEN","25","13","13","Imi Ishmael ko namarari nunga nunup, kari laun te duap beteram ale kaparam. Se kari laun mu Nebaioth, se kowom kaora mu Kedar, asele Adbeel, Mibsam, ");
INSERT INTO wsk_vpl VALUES ("GN25_14","002_25_14","GEN","25","14","14","Mishma, Dumah, Massa, ");
INSERT INTO wsk_vpl VALUES ("GN25_15","002_25_15","GEN","25","15","15","Hadad, Tema, Jetur, Naphish, se Kedemah. ");
INSERT INTO wsk_vpl VALUES ("GN25_16","002_25_16","GEN","25","16","16","Imi Ishmael ko namarari 12. Nuna nunga kariimet koma koma dagi dagi namaman mu nunga supuling bibiya bagakasan. Se nunga kariimet mu nunga kari supuling nunga nunup nunup te nunga arusan. ");
INSERT INTO wsk_vpl VALUES ("GN25_17","002_25_17","GEN","25","17","17","Ishmael ko bagara tom ilu biguwu sapara mu 137 yia, asele kueram, ale ko nuet nongotak nogowom karo namaram. ");
INSERT INTO wsk_vpl VALUES ("GN25_18","002_25_18","GEN","25","18","18","Se Ishmael ko gue te ko taleng girigir alo mu, sor Havilah mu te dagiman nama sor Shur arataman, mu Egypt ko beta ko, lage Asshur namara mu te. Bare nuna nunumi karogo nongomang suanta me bagakasan. ");
INSERT INTO wsk_vpl VALUES ("GN25_19","002_25_19","GEN","25","19","19","Imi Abraham ko namar Isaac ko gue. ");
INSERT INTO wsk_vpl VALUES ("GN25_20","002_25_20","GEN","25","20","20","Isaac Bethuel ko nanawus Rebekah nuwus ko tam. Tom mu te noko yia tom mu 40. Rebekah mu Bethuel ko nanawus, se Laban ko koras. Nuna Aram kariimet, se nunga sor mu Paddan Aram. ");
INSERT INTO wsk_vpl VALUES ("GN25_21","002_25_21","GEN","25","21","21","Bare Rebekah kuriang mena. Se Isaac, Yawe Rebekah sangukko ko aru maonam. Se Yawe Isaac ko kuring iluwam se Rebekah tuagu aratam. ");
INSERT INTO wsk_vpl VALUES ("GN25_22","002_25_22","GEN","25","22","22","Ale kuriang ilagala noko tuagu ningi, se nunumi ita bilakasan. Se Rebekah balam, “Awuk se kilek ewere ani angimik te arataso ya?” Ale nu kilek owore ko duap ko Yawe isuokko namaram. ");
INSERT INTO wsk_vpl VALUES ("GN25_23","002_25_23","GEN","25","23","23","Se Yawe iwita Rebekah maonam, “Kari ilagala ni tagu ningi mu maingte kariimet motam ilagala aratamon ale nunumi pagarmonko; bo kariimet aora biya ko bagaruk, se bo mu mena ko; laun mu uria mu ko kari dungan bagarukko.” ");
INSERT INTO wsk_vpl VALUES ("GN25_24","002_25_24","GEN","25","24","24","Se Rebekah kuriang iluwokko tom tai aratam, se Yawe balam uwutata nu kuriang kari ilagala nunga iluwam. ");
INSERT INTO wsk_vpl VALUES ("GN25_25","002_25_25","GEN","25","25","25","Se kuriang giram bilangaram mu kumik diriyam se kumik mone biya, owore te se nup beteman Esau maman. ");
INSERT INTO wsk_vpl VALUES ("GN25_26","002_25_26","GEN","25","26","26","Se bo udagi bilangaram mu ko kuting ko laun Esau ko suwik durum ilukuawuram ale bilangaram, owore te se nup beteman Jacob maman. Isaac ko yia tom 60 bagaram se Rebekah kuriang ilagala umu nunga iluwam. ");
INSERT INTO wsk_vpl VALUES ("GN25_27","002_25_27","GEN","25","27","27","Se kuriang ilagala mu lagaman. Esau bulamara kari ningo ko aratam. Nu wonong te tawun biya me bagakaso, bare bulamara ko la lagakaso. Se Jacob mu kari kutekam se awar biya me namakaso. ");
INSERT INTO wsk_vpl VALUES ("GN25_28","002_25_28","GEN","25","28","28","Isaac Esau ko bulamara mu naukko kuakaso, ale Esau ko ninguru kuakaso. Bare Rebekah mu Jacob ko kuakaso. ");
INSERT INTO wsk_vpl VALUES ("GN25_29","002_25_29","GEN","25","29","29","Bare tom bo Jacob bin kumin kamiwaram se Esau bulamurokko geraga laga na ko nunguningkiri kueram, ale tairam, ");
INSERT INTO wsk_vpl VALUES ("GN25_30","002_25_30","GEN","25","30","30","ale Jacob maonam, “Ani na ko ninguru kuerem,” mam. “Kumin diriyam beterem sowore sang ais se naikko,” mam. Bore te se nuna Esau arukasan Edom makasan. ");
INSERT INTO wsk_vpl VALUES ("GN25_31","002_25_31","GEN","25","31","31","Bare Jacob balam, “Ani kisekko pa! Bare ni kari laun ka marak ani aisu, asele ani kisekko.” ");
INSERT INTO wsk_vpl VALUES ("GN25_32","002_25_32","GEN","25","32","32","Se Esau balam, “Ikiko! Ani kuerikko pingita, se ani kari laun aga marak mu anape ningo ani aisuokko?” ");
INSERT INTO wsk_vpl VALUES ("GN25_33","002_25_33","GEN","25","33","33","Bare Jacob balam, “Ni Yawe koma te nunguningta aisuko balu mu asele.” Se Esau Yawe koma te nunguningta mam, ale ko kari laun ko marak mu ko uria Jacob tuam. ");
INSERT INTO wsk_vpl VALUES ("GN25_34","002_25_34","GEN","25","34","34","Se Jacob bread se bin kumin sang Esau tuam. Se nu na yu nam ale barasam namaram. Esau kari laun bare numi saparam. ");
INSERT INTO wsk_vpl VALUES ("GN26_1","002_26_1","GEN","26","1","1","Karak tom bo akingtala kaparam, ulengkala Abraham ko tom te kaparam iwitatala. Se Isaac Gerar wonong te Philistia nunga king Abimelech kote namaram. ");
INSERT INTO wsk_vpl VALUES ("GN26_2","002_26_2","GEN","26","2","2","Yawe Isaac kote aratam ale iwita maonam, “Ni Egypt me namarko,” mam, “ni kuwim ani te ka manik mu te la bagerko. ");
INSERT INTO wsk_vpl VALUES ("GN26_3","002_26_3","GEN","26","3","3","Ni ali imi te taira kari iwita dagi ale bager, se ani pempem kerak baga se marak kisekko. Ani ali imi lilim la ni se ka taleng girigir ago ningarikko. Ani nika niet Abraham ilak den kalem uwutata bitirik se aratukko. ");
INSERT INTO wsk_vpl VALUES ("GN26_4","002_26_4","GEN","26","4","4","Ani balik se taiti gomang te baras kaura koma mena iwita nika taleng girigir aratamon se ali imi lilim la nungarikko. Se nika gue te ali lilim ko kariimet marak nungarikko, ");
INSERT INTO wsk_vpl VALUES ("GN26_5","002_26_5","GEN","26","5","5","mu awuk, Abraham aninga den suen la ikiam ale karo tuam.” ");
INSERT INTO wsk_vpl VALUES ("GN26_6","002_26_6","GEN","26","6","6","Buta se Isaac eng am Gerar daigam bagakaso. ");
INSERT INTO wsk_vpl VALUES ("GN26_7","002_26_7","GEN","26","7","7","Se sor mu ko kari alo Rebekah ko nu isarukasan, mu nu balukaso, “Mu aninga agoras,” makaso. Nu baluk “aninga aiwus” ma balukko bare nguangakaso, mu awuk, nu ikikaso, “Rebekah koma balayam, se ani ‘aninga aiwus’ maik, mu nuna aninga momon ale Rebekah tamonko.” ");
INSERT INTO wsk_vpl VALUES ("GN26_8","002_26_8","GEN","26","8","8","Isaac sor mu te kam maiya nuam bagaram, se tom bo Philistia nunga king Abimelech ko kawam te kualala baga se, ko marir te ta ko songkuring gotek te loagaram se kaparam, se Isaac ko nuwus Rebekah yasaram ale ilak kola gusiwaram se arigam. ");
INSERT INTO wsk_vpl VALUES ("GN26_9","002_26_9","GEN","26","9","9","Abimelech Isaac ko den beteram se Isaac kote tairam se nu maonam, “Nunguningta Rebekah mu nika niwus! Bare ni awuk se balem, nu nika koras maem?” Se Isaac koma ko mam, “Kari Rebekah ko nomotam barasa te aninga momon se kuerik se nu tamonko iwita ikiem, ale ani kawelerem.” ");
INSERT INTO wsk_vpl VALUES ("GN26_10","002_26_10","GEN","26","10","10","Se Abimelech Abraham ining tuam, “Ni anape ko kiwem sowore ana nangimik te beterem? Nika kawel mu te aninga kari bo nika niwus ilak aniram le mu, ana ikup giman le.” ");
INSERT INTO wsk_vpl VALUES ("GN26_11","002_26_11","GEN","26","11","11","Buta se Abimelech den aora bo beteram se ko kariimet ningi geragam, “Awiriya kari imi agi ko nuwus imi bita maguwurok, mu nunguningta nu kuerukko.” ");
INSERT INTO wsk_vpl VALUES ("GN26_12","002_26_12","GEN","26","12","12","Isaac yia pempem inang muguri agukaso, se yia tom suanta mu ningi la nunguning suen la kapakaso, mu awuk, Yawe nu ilak baga se sangarukaso. ");
INSERT INTO wsk_vpl VALUES ("GN26_13","002_26_13","GEN","26","13","13","Isaac kari nup biya, kumik mel suen biya karogo ko aratam. Bare noko melmasak mu am gue pagawakaso. ");
INSERT INTO wsk_vpl VALUES ("GN26_14","002_26_14","GEN","26","14","14","Noko sipsip, ko bulmakau, ko ura kariimet mu namaram am suen biya aram, se Philistia alo arigiman ale ko nongomang magakaso. ");
INSERT INTO wsk_vpl VALUES ("GN26_15","002_26_15","GEN","26","15","15","Se yu mutim suen la ko nuet Abraham ko ura kari iman mu saguwu sapaman. ");
INSERT INTO wsk_vpl VALUES ("GN26_16","002_26_16","GEN","26","16","16","Se Abimelech Isaac maonam, “Ni kari aromemek ko aratem, se ana ni kerak me terong. Buta se nanga bitar ale namarko,” mam. ");
INSERT INTO wsk_vpl VALUES ("GN26_17","002_26_17","GEN","26","17","17","Buta se Isaac Gerar sor koma nuna te bagakasan mu nunga beteram, ale nama Gerar sor ko sor wolong mu te kuwim tam daigam. ");
INSERT INTO wsk_vpl VALUES ("GN26_18","002_26_18","GEN","26","18","18","Isaac ko nuet Abraham ko tom te yu mutim iram se Philistia alo saguwu saguwu karogo namaman, mu aking i i karogo namaram, ale nunup koma suanta nuet te balam mu te aking balu balu karogo namaram. ");
INSERT INTO wsk_vpl VALUES ("GN26_19","002_26_19","GEN","26","19","19","Sor mu te Isaac ko ura kari yu ko mutim i ari ari namawa, bo iman se yu ningo bausam se arigiman. ");
INSERT INTO wsk_vpl VALUES ("GN26_20","002_26_20","GEN","26","20","20","Bare sor duap Gerar ko bulmakau sipsip bitua kari alo taiman, Isaac ko bulmakau sipsip bitua kari alo nongorak den tagiman, ale yu mu nononga maman. Se Isaac yu mutim umu nup beteram Esek mam, mu awuk, nuna yu mu ko ilak den tagiman. ");
INSERT INTO wsk_vpl VALUES ("GN26_21","002_26_21","GEN","26","21","21","Se Isaac ko ura kari yu mutim bo tala iman, bare mu ko agotala nongorak den tagiman. Buta se Isaac yu mutim mu nup beteram Sitnah mam. ");
INSERT INTO wsk_vpl VALUES ("GN26_22","002_26_22","GEN","26","22","22","Nu bo karogo kasu namaram ale yu mutim bo tala iram. Bare aitak mu kari bo nu ilak den me tagiram. Se nu yu mutim mu nup Rehoboth tui se balam, “Aitak asele Yawe kuring nangaram, se ana te yawarakala daginakko.” ");
INSERT INTO wsk_vpl VALUES ("GN26_23","002_26_23","GEN","26","23","23","Umu te asele Isaac Beersheba nama tarigiram. ");
INSERT INTO wsk_vpl VALUES ("GN26_24","002_26_24","GEN","26","24","24","Se ko tirom mu, Yawe nukote aratam ale maonam, “Ani nika niet Abraham ko Kaem. Ni me nguangerko, ani ni kerak bagasam. Ani marak kisek, ale aga ura kari Abraham ilak den kalem mu ko ningo ko, nika gue te mu nunga nungek se pagamon sor eremonko.” ");
INSERT INTO wsk_vpl VALUES ("GN26_25","002_26_25","GEN","26","25","25","Isaac umu te altar bo kaolam ale Yawe nup patawuram. Nu mu te kawam sel saparam ale kuwim tam, ale mu te tala ko ura kari yu mutim bo i gilingiman. ");
INSERT INTO wsk_vpl VALUES ("GN26_26","002_26_26","GEN","26","26","26","Se Abimelech ko kiti guruga kari Ahuzzath se ko kager kari supuling Phicol nunga giam, ale Gerar wonong beteman ale Isaac arigimonko taiman. ");
INSERT INTO wsk_vpl VALUES ("GN26_27","002_26_27","GEN","26","27","27","Se Isaac nunga isuam, “Nina anape ko aningate taiman? Nina ani agarak balman ale aga karoman.” ");
INSERT INTO wsk_vpl VALUES ("GN26_28","002_26_28","GEN","26","28","28","Se nuna balman, “Ana wetang te arigiman Yawe ni kerak bagoso. Bore te se ana ni kerak den kalonakko taiman. Gemang motam nangaru se, ana ikia sang ni kerak kalonakko. ");
INSERT INTO wsk_vpl VALUES ("GN26_29","002_26_29","GEN","26","29","29","Se anananga ikia mu iwita: ana ni me ka bita maguwuman, ninguru ka bitarman, ale namotam la karkiwaman se ni nanga beterem. Se aitak Yawe ni kerak bagoso. Buta se ni memek bo ana nangimik te me bitarko.” ");
INSERT INTO wsk_vpl VALUES ("GN26_30","002_26_30","GEN","26","30","30","Se Isaac inang barim bita nungaram. ");
INSERT INTO wsk_vpl VALUES ("GN26_31","002_26_31","GEN","26","31","31","Tumong biyala barasaman, ale bagara suanta bagamonko nunumi nongomang suanta awuman ale ikia kaloman. Asele Isaac nunga beteram se nongomang lila te nunumi beteman. ");
INSERT INTO wsk_vpl VALUES ("GN26_32","002_26_32","GEN","26","32","32","Se kowarkalal suanta mu te, Isaac ko ura kari taiman ale yu mutim bo iman mu ko manorman, ale balman, “Ana yu bo barukuman se lairam bausam!” maman. ");
INSERT INTO wsk_vpl VALUES ("GN26_33","002_26_33","GEN","26","33","33","Se Isaac yu mutim umu nup beteram Shibah mam. Se tom mu te se tai aitak, wonong mu eng ko nup Beersheba masan. ");
INSERT INTO wsk_vpl VALUES ("GN26_34","002_26_34","GEN","26","34","34","Esau ko yia tom 40 baga se Heth kari Beeri ko nanawus Judith, se Heth kari bo tala Elon ko nanawus Basemath nunga giam. ");
INSERT INTO wsk_vpl VALUES ("GN26_35","002_26_35","GEN","26","35","35","Se noko imet ilagala mu ko, Isaac Rebekah ilak nongomang bataga lagakaso. ");
INSERT INTO wsk_vpl VALUES ("GN27_1","002_27_1","GEN","27","1","1","Isaac garukaram ale motam am pila saparam, se mel ninguru arigokko me terong. Se ko namar biya Esau auram ale maonam, “Ba,” mam. Se nu mam, “Baluko,” mam. ");
INSERT INTO wsk_vpl VALUES ("GN27_2","002_27_2","GEN","27","2","2","Se Isaac balam, “Ani garukerem ale kuerikko tom pingi aram. ");
INSERT INTO wsk_vpl VALUES ("GN27_3","002_27_3","GEN","27","3","3","Ario, ka bulamara ko melmasak gi ale namar ale mel bo ani naikko koma mu moarko. ");
INSERT INTO wsk_vpl VALUES ("GN27_4","002_27_4","GEN","27","4","4","Karogo tair ale inang ani ko kuesam umu karogo kamir, ale ago tair, se ani naik ale aga marak ningo kisek, ale asele baga kuerikko.” ");
INSERT INTO wsk_vpl VALUES ("GN27_5","002_27_5","GEN","27","5","5","Rebekah due guruguwa Isaac den Esau manaruwaram mu nu karogo ikiam. Ale tom Esau aratam namawaram mu, ");
INSERT INTO wsk_vpl VALUES ("GN27_6","002_27_6","GEN","27","6","6","Rebekah iwita namar Jacob maonam, “Jacob,” mam, “ani ikiwerem se ka niet ka laun Esau maonam, ");
INSERT INTO wsk_vpl VALUES ("GN27_7","002_27_7","GEN","27","7","7","‘Namar mel bo moar karogo tair, ale inang ani ko kuesam mu karogo kamir, se ani naik ale Yawe koma te aninga marak ningo kisek, ale asele baga kuerikko,’ mam se ikiem. ");
INSERT INTO wsk_vpl VALUES ("GN27_8","002_27_8","GEN","27","8","8","Ario Jacob, den ani balik mu ninguru iki ale karo tuiko. ");
INSERT INTO wsk_vpl VALUES ("GN27_9","002_27_9","GEN","27","9","9","Namar ale goat suguri te ilagala moar ale ago tair, se ba ko inang nana ko koma mu te nungek burangarikko. ");
INSERT INTO wsk_vpl VALUES ("GN27_10","002_27_10","GEN","27","10","10","Se ni gi karogo nama tui se nauk ale, me kueso la noko marak ningo kisokko,” mam. ");
INSERT INTO wsk_vpl VALUES ("GN27_11","002_27_11","GEN","27","11","11","Bare Jacob ko nuam Rebekah maonam, “Bare Esau mu kumik mone gurum, se ani mu angimik palepalengam. ");
INSERT INTO wsk_vpl VALUES ("GN27_12","002_27_12","GEN","27","12","12","Se ba ani angimik kau tauk agi mu, nu ko ikiok, anigita kuluruwasam mauk, ale marak memek angimik kuali balu aisuokko, se ani ningo bo me arigekko.” ");
INSERT INTO wsk_vpl VALUES ("GN27_13","002_27_13","GEN","27","13","13","Bare ko nuam iwita balam, “Ba, mel bo uwuta aratuk mu ani ko ikup giekko! Bare ni ani balsam wore la karoko. Namar ale goat mu nunga giko.” ");
INSERT INTO wsk_vpl VALUES ("GN27_14","002_27_14","GEN","27","14","14","Se Jacob namaram giam ale ago tai nuam tuam. Se nu Jacob ko inang nana ko iki se te nungam burangaram. ");
INSERT INTO wsk_vpl VALUES ("GN27_15","002_27_15","GEN","27","15","15","Ale Esau ko guang ningo nuam kawam te aniram mu giam, ale Jacob tuam se naguram. ");
INSERT INTO wsk_vpl VALUES ("GN27_16","002_27_16","GEN","27","16","16","Ale goat ko kumik guang Jacob ko kuting te ira kaluwuram, ale ko dogotak komang kuting mu karogo la te ira kaluwuram. ");
INSERT INTO wsk_vpl VALUES ("GN27_17","002_27_17","GEN","27","17","17","Asele na nungam mu patawu tuam, ale bread kaiyam mu karogo gi tuam. ");
INSERT INTO wsk_vpl VALUES ("GN27_18","002_27_18","GEN","27","18","18","Se Jacob na giam ago ko nuet kote namaram ale auram, “Ba!” mam. Se nuet “Bare awiri ya?” mam. ");
INSERT INTO wsk_vpl VALUES ("GN27_19","002_27_19","GEN","27","19","19","Se Jacob ko nuet maonam, “Anigita Esau, nika kuriang laun. Ani ni aga manem butata beterem. Se bares ale na inang ani giem ale ago tairem mu no ale ka marak aisuko.” ");
INSERT INTO wsk_vpl VALUES ("GN27_20","002_27_20","GEN","27","20","20","Se Isaac aora balam, “Ba, ni awuk ani mel balem wore tairate taem karogo tairem a?” mam. Se Jacob balam, “Yawe nika Kaem wore aninga saongam se taem.” ");
INSERT INTO wsk_vpl VALUES ("GN27_21","002_27_21","GEN","27","21","21","Se Isaac aora namar Jacob maonam, “Ba,” mam, “pingi utu tair se, ni nunguningta Esau agi wore ko, kimik ilu arigekko.” ");
INSERT INTO wsk_vpl VALUES ("GN27_22","002_27_22","GEN","27","22","22","Se Jacob ko nuet kote kasu namaram, se ilu arigam ale balam, “Ka munak ka degetak mu Jacob ko dogotak iwita. Bare ka kiting mu Esau ko,” mam. ");
INSERT INTO wsk_vpl VALUES ("GN27_23","002_27_23","GEN","27","23","23","Mu nu Jacob i, bare nuet ninguru me ari ko ikiam, mu awuk, noko kuting luan mone ago, Esau ko wore turan. Se nu marak tuokko, ");
INSERT INTO wsk_vpl VALUES ("GN27_24","002_27_24","GEN","27","24","24","se akingtala isuam, “Nunguningta ni aninga namar Esau e?” mam. Se Jacob balam, “Anigita,” mam. ");
INSERT INTO wsk_vpl VALUES ("GN27_25","002_27_25","GEN","27","25","25","Asele Isaac mam, “Aga Ba,” mam, “Na inang nungem mu sang aisu se naik, asele aga marak kisekko,” mam. Se Jacob inang mu patawu tuam, ale waen sang karogo tuam se nam. ");
INSERT INTO wsk_vpl VALUES ("GN27_26","002_27_26","GEN","27","26","26","Asele Isaac Jacob maonam, “Ba, iwita tair ale aga yasirko,” mam. ");
INSERT INTO wsk_vpl VALUES ("GN27_27","002_27_27","GEN","27","27","27","Se Jacob nuet kote namaram ale yasaram. Se Isaac aora Esau ko guang Jacob kumik te mu siring ikiam, ale marak tui se balam, “Ah,” mam, “aninga kuriang ko kumik siring mu ningam bo Yawe marak tuam wore ko siring iwita,” mam. ");
INSERT INTO wsk_vpl VALUES ("GN27_28","002_27_28","GEN","27","28","28","Asele mam, “Kaem ka ningam suen la yu lawung yawara tuok, se inang suen la ningo aratamonko, wheat suen la se yu waen suen la. ");
INSERT INTO wsk_vpl VALUES ("GN27_29","002_27_29","GEN","27","29","29","Se sor saki nika ura dungan betemonko, kariimet nubugura kulukuru kisimonko. Ni ka gue suan nunga kari gira bagerko, se nuna nika bowa ningi pempem bagamonko. Awiriya ka bita maguwurok, mu nu koma memek taukko; se awiriya marak ningo kisok, mu nu marak ningo taukko.” ");
INSERT INTO wsk_vpl VALUES ("GN27_30","002_27_30","GEN","27","30","30","Isaac namar Jacob marak tuam, se Jacob nu beteram ale namaram, tom me maiyam se ko laun Esau bulamu laga tairam. ");
INSERT INTO wsk_vpl VALUES ("GN27_31","002_27_31","GEN","27","31","31","Nu betela na ningo nungam ale giam ago ko nuet kote tairam. Ale auram maonam, “Ba,” mam, “bares ale na ani ago tairem ewere no ale ka marak ani aisuko.” ");
INSERT INTO wsk_vpl VALUES ("GN27_32","002_27_32","GEN","27","32","32","Se nuet Isaac tingam ale “Ni awiri ya?” mam. Se nu mam, “Anigita, ka namar laun Esau,” mam. ");
INSERT INTO wsk_vpl VALUES ("GN27_33","002_27_33","GEN","27","33","33","Se Isaac aora ninguru biririkaram, ale kumik wanara ko kapa se isuam, “Se awiri maingkala bulamaram, ale kamaram, ale ago agate tairam? Ani naem ale aga marak tuem, se nu ta tam! Ale namawoso se ni tairem,” mam. ");
INSERT INTO wsk_vpl VALUES ("GN27_34","002_27_34","GEN","27","34","34","Se Esau nuet ko den mu ikiam ale kuring paogam sail te niaram, ale gomang maga se nuet maonam, “Marak aisuko, aninga Ba! Ani agotala marak aisuko!” ");
INSERT INTO wsk_vpl VALUES ("GN27_35","002_27_35","GEN","27","35","35","Bare nuet mam, “Nika uria kawel ko munan te nika marak tere tam.” ");
INSERT INTO wsk_vpl VALUES ("GN27_36","002_27_36","GEN","27","36","36","Se Esau maonam, “Noko nup Jacob maman mu diram, nu kawel kari! Nu tom ilagala ko aga kulam! Ani kari laun, bare nu ko kawel te kari laun ko aratam. Ale aitak aga marak ningo kawel te tala tere tam. Se Ba, ni marak bo bo mena e? Ani agotala marak aisuko!” ");
INSERT INTO wsk_vpl VALUES ("GN27_37","002_27_37","GEN","27","37","37","Bare Isaac Esau ko den koma iwita maonam, “Ani maingkala noko balem nu nika kari gira bagarukko, se noko launuria suen la nu bowa ningi bagaralko. Ani noko wheat se waen ninguru aratu tuokko manem. Buta se aga namar, awuk ka bitirikko?” ");
INSERT INTO wsk_vpl VALUES ("GN27_38","002_27_38","GEN","27","38","38","Bare Esau nuet am isaru diruwuwakaso, “Nikate marak suanta diram e, Ba? Ani agotala marak aisuko!” Esau uwuta balam ale biyala niakaso. ");
INSERT INTO wsk_vpl VALUES ("GN27_39","002_27_39","GEN","27","39","39","Se Isaac aora nu maonam, “Ni butata ali welang mena, yu bugulik me kau tata mu te baga lagerko. ");
INSERT INTO wsk_vpl VALUES ("GN27_40","002_27_40","GEN","27","40","40","Ni daong kager te to no se, ka uria bowa ningi la baga, kimik alis paguk mu kari tam giturum biwinang te patawu saposo iwita, patawu saparko.” ");
INSERT INTO wsk_vpl VALUES ("GN27_41","002_27_41","GEN","27","41","41","Esau marak tere ta ko munan Jacob beteram mu mel memek bo iwita noko gomang ningi iluwam. Nu kota numi maonam, “Ba ko kuera tom pingi aram. Se kueruk se ko naneman bataga menaruk, mu ani Jacob morik se kuerukko,” mam. ");
INSERT INTO wsk_vpl VALUES ("GN27_42","002_27_42","GEN","27","42","42","Bare tom namar Esau ko den mu Rebekah dogowa te namaram, mu tairate ko namar gotek Jacob ko den beteram, se kote tairam se maonam, “Nika laun Esau ka moruk se kuar asele gomang kutek maukko ikia bitawoso. ");
INSERT INTO wsk_vpl VALUES ("GN27_43","002_27_43","GEN","27","43","43","Ario, Jacob, ani anapeya balik mu ni butata bitarko. Ni aitakta ewerta bares ale aninga agoras Laban, nika nie, Harran bagoso, mu kote namarko. ");
INSERT INTO wsk_vpl VALUES ("GN27_44","002_27_44","GEN","27","44","44","Ni ilak umu te bager, se ka laun ko gomang yaman kua kaparuk asele tairko. ");
INSERT INTO wsk_vpl VALUES ("GN27_45","002_27_45","GEN","27","45","45","Tom nika laun mu ko gomang memek kua kaparuk, se kiwem ni nukote beterem mu kuamili saparuk se ani arigek, mu ani den bitirik se ni tairko. Mu awuk, nina tom suanta te kueral se arigekko me kuesam.” ");
INSERT INTO wsk_vpl VALUES ("GN27_46","002_27_46","GEN","27","46","46","Udagi te Rebekah kuari Isaac aora maonam, “Ani Heth imet ilagala Esau ko nuwusari imi nunga angimik gagoraram. Se Jacob betela sor imi te ko Heth imet bo ko nuwus ko tauk agi mu, ani ngual am, am kua namarikko!” ");
INSERT INTO wsk_vpl VALUES ("GN28_1","002_28_1","GEN","28","1","1","Se Isaac Jacob auram se tairam, se sangam tuam ale maonam, “Ni Canaan imet bo me ta toko. ");
INSERT INTO wsk_vpl VALUES ("GN28_2","002_28_2","GEN","28","2","2","Ni nimi nunguru ale ka niam ko nuet Bethuel ko kariimet ningi Paddan Aram namarko. Ale umu te ka niam ko koras Laban ko nanawus bo ka imet ko toko. ");
INSERT INTO wsk_vpl VALUES ("GN28_3","002_28_3","GEN","28","3","3","Se Kaem Sokel Garagar mu kerak baga se marak kisok, se gue paguk ale sor magaruk ale kariimet motam bibiya ko bagamonko. ");
INSERT INTO wsk_vpl VALUES ("GN28_4","002_28_4","GEN","28","4","4","Kaem Abraham maonam uwutata, ni se ka kuriang gue karogo marak ningaruk, se ali nina aitak taira kari iwita te dagiwasan umu bataguru talko. Ali sumutang Kaem Abraham tuam.” ");
INSERT INTO wsk_vpl VALUES ("GN28_5","002_28_5","GEN","28","5","5","Asele Isaac aora Jacob beteram se Paddan Aram namakaso. Nu nue Laban, Aram kari Bethuel ko namar, se Esau Jacob ilak nunga nunam Rebekah ko koras, wore kote namaram. ");
INSERT INTO wsk_vpl VALUES ("GN28_6","002_28_6","GEN","28","6","6","Mel aratam mu Esau dogowa ningi namaram, se nu ikiam, Isaac aora namar Jacob Canaan imet bo me ta taukko maonam, bare Paddan Aram namaruk ale imet bo mu te taukko maonam, ale nu Jacob sangam tuam, ");
INSERT INTO wsk_vpl VALUES ("GN28_7","002_28_7","GEN","28","7","7","se Jacob nuamnuet nuguring kaoram ale Paddan Aram namaram. ");
INSERT INTO wsk_vpl VALUES ("GN28_8","002_28_8","GEN","28","8","8","Umu te Esau maingkala sinar aram, noko nuwusari Canaan imet umu, noko nuet Isaac me nunga amilmilakaso. ");
INSERT INTO wsk_vpl VALUES ("GN28_9","002_28_9","GEN","28","9","9","Buta se nu Ishmael kote namaram, ale Ishmael ko nanawus Mahalath, Nebaioth ko koras, nuwus ko tam. Ishmael mu Abraham ko namar. Esau ko imet ilagala, se imi bo tala aking tam. ");
INSERT INTO wsk_vpl VALUES ("GN28_10","002_28_10","GEN","28","10","10","Jacob sor Beersheba beteram ale barasam Harran wonong te namakaso. ");
INSERT INTO wsk_vpl VALUES ("GN28_11","002_28_11","GEN","28","11","11","Nu am aolak iluwaram se worem kaparam ale sor tirom batagam se lage luan te umu te aniram. Nu manga bo tam, supuling ko beteram ale taga aniram ale anikaso. ");
INSERT INTO wsk_vpl VALUES ("GN28_12","002_28_12","GEN","28","12","12","Nu aniwa ipingira bo arigam, se ipingira mu ningi titeng bo arigam, ko duap ali te se luan kopa taiti ningi nama tarigiram, se Kaem ko engel alo te tarigi kapawakasan mu arigam. ");
INSERT INTO wsk_vpl VALUES ("GN28_13","002_28_13","GEN","28","13","13","Se Yawe tairam titeng mu ko dun kuali biya mu te sanamaram ale maonam, “Ani Yawe, nika nengetak Abraham ko Kaem, se ka niet Isaac ko Kaem. Se ali ni aitakta te aniwasam imi mu, ani ni se ka kuriang gue ningarikko. ");
INSERT INTO wsk_vpl VALUES ("GN28_14","002_28_14","GEN","28","14","14","Nuna saun, kaura ko koma mena iwitata aratamonko. Ale nuna parasamon, ale koma worem bausa mu te se worem kapara te, koma north se koma south mu te, sor ira sapamonko. Ani ni te, se ka kuriang gue te, ali lilim ko kariimet marak nungarikko. ");
INSERT INTO wsk_vpl VALUES ("GN28_15","002_28_15","GEN","28","15","15","Ani ni kerak bagasam, ale ni apalagaya namar bare ani ka sinar taik, ale kerak ali imi te pelerik tairikko. Ani kerak bagarik la, mel suen biya ani ko balem mu aratu saparukko.” ");
INSERT INTO wsk_vpl VALUES ("GN28_16","002_28_16","GEN","28","16","16","Se Jacob tingam maragaram, ale mam, “Nunguningta, Yawe kuwim imi te bagoso, bare ani me ko ikiem.” ");
INSERT INTO wsk_vpl VALUES ("GN28_17","002_28_17","GEN","28","17","17","Nu nguangaram ale mam, “Kuwim imi kuwim duap bo! Nunguningta, kuwim imi Kaem ko duruk wonong ko kawam ko lage kuring!” ");
INSERT INTO wsk_vpl VALUES ("GN28_18","002_28_18","GEN","28","18","18","Ukiram tumong biyala Jacob barasam ale manga supuling ko beteram mu patawu baongam, ale olive oil awote waram. ");
INSERT INTO wsk_vpl VALUES ("GN28_19","002_28_19","GEN","28","19","19","Ale sor mu nup beteram “Bethel” mam. Ulengkala kariimet balukasan Luz wonong makasan. ");
INSERT INTO wsk_vpl VALUES ("GN28_20","002_28_20","GEN","28","20","20","Ale te Jacob iwita Kaem maonam, “Ni aninga aolak imi te agarak baga se, aga sinar to se inang aisu, ale guang nagurekko mu aisu, ");
INSERT INTO wsk_vpl VALUES ("GN28_21","002_28_21","GEN","28","21","21","se ani ningo la pelerik aga ait ko kawam te tairik, mu asele ni Yawe aninga Kaem ko bagerko. ");
INSERT INTO wsk_vpl VALUES ("GN28_22","002_28_22","GEN","28","22","22","Se manga ani bangem, mu nika kawam koma tata iwita anirukko. Se mel suen biya ni ani aisu, mu ani pagik se motam gotektek 10 ko kaparuk, se suanta gira mu ni kisekko.” ");
INSERT INTO wsk_vpl VALUES ("GN29_1","002_29_1","GEN","29","1","1","Asele Jacob ko aolak mu kunasaram ale namakaso. Nu aolak iluwam nama koma worem bausa ko kariimet nunga sor te aratam. ");
INSERT INTO wsk_vpl VALUES ("GN29_2","002_29_2","GEN","29","2","2","Umu te nu yu mutim bo arigam, se sipsip motam ilagala suan duap te ani barasuwaman mu nungarkam. Se yu mutim mu ko kuring mu manga biya bo te baguman. ");
INSERT INTO wsk_vpl VALUES ("GN29_3","002_29_3","GEN","29","3","3","Tom sipsip motam suen la yu mutim duap te tai bolala awusan, mu nunga bitua kari mu manga yu kuring awote mu silatasan ale sipsip yu utu nungarsan. Se sipsip yu nasan nama terong masan, mu aking bitua kari alo manga te aking yu kuring bagusan. Nuna pempem butata betesan. ");
INSERT INTO wsk_vpl VALUES ("GN29_4","002_29_4","GEN","29","4","4","Se Jacob sipsip bitua kari nunga isuam, “Aga saki alo, nina apalak ko ya?” mam. “Ana Harran ko pa,” maman. ");
INSERT INTO wsk_vpl VALUES ("GN29_5","002_29_5","GEN","29","5","5","Se aking nunga isuam, “Nina Laban, Nahor ko numas, mu ko ikisan e?” “Se, ana ko ikisan,” maman. ");
INSERT INTO wsk_vpl VALUES ("GN29_6","002_29_6","GEN","29","6","6","Se aking Jacob nunga isuam, “Nu terong bagoso e?” mam. “Nu terong bagoso pa,” maman. “Arikko, ko nanawus Rachel ko sipsip arungak o taiwoso owa.” ");
INSERT INTO wsk_vpl VALUES ("GN29_7","002_29_7","GEN","29","7","7","Se Jacob nunga isuam, “Nina awuk se worem kalel biya aniso wore sipsip pasak yu nungara ale nongorak pelera se sirsir bo karogo nana mena iwitata kimi bita lagasan a?” mam. ");
INSERT INTO wsk_vpl VALUES ("GN29_8","002_29_8","GEN","29","8","8","Bare sipsip bitua kari mu balman, “Mena. Ana suwuta me betesan. Ana sipsip suen la tai bolala awusan, umutang asele ana yu mutim kuring kagorsan ale yu nungarsan se nasan.” ");
INSERT INTO wsk_vpl VALUES ("GN29_9","002_29_9","GEN","29","9","9","Se Jacob nongorak munakawaram se Rachel nuet ko sipsip giam arungak tairam, mu awuk, nu sipsip bitua imet. ");
INSERT INTO wsk_vpl VALUES ("GN29_10","002_29_10","GEN","29","10","10","Se Jacob nu arigam, ale ko nue Laban ko sipsip nu giam arungu taiwaram mu arigam, ale nu yu mutim te namaram ale manga mu gurugu beteram ale sipsip yu nungarukaso. ");
INSERT INTO wsk_vpl VALUES ("GN29_11","002_29_11","GEN","29","11","11","Asele nu Rachel kol te musuk mam ale ilak niaram, ");
INSERT INTO wsk_vpl VALUES ("GN29_12","002_29_12","GEN","29","12","12","ale maonam, “Ani nika niet ko koras Rebekah ko namar,” mam. Se Rachel nagu nagu namaram ko nuet maonam. ");
INSERT INTO wsk_vpl VALUES ("GN29_13","002_29_13","GEN","29","13","13","Se Laban ko nugar Jacob tairam wore ko den ikiam, ale naguram kote namaram. Ale iluwam kol te musuk mam, ale ilak ko kawam te namaram. Se Jacob nu mel suen biya nu kumik te aratam mu ko Laban maonam. ");
INSERT INTO wsk_vpl VALUES ("GN29_14","002_29_14","GEN","29","14","14","Se Laban balam, “Mu nunguningta,” mam, “ni aninga gue miri.” Se Jacob Laban ilak sige suanta bagaram, ");
INSERT INTO wsk_vpl VALUES ("GN29_15","002_29_15","GEN","29","15","15","asele Laban isuam, “Ni aninga aigar, se awuk? Ni ani ago ko am ipi ura to lagerko e? Nika ura koma anapeya ko kuar, mu am aga manaruko.” ");
INSERT INTO wsk_vpl VALUES ("GN29_16","002_29_16","GEN","29","16","16","Laban ko nanawus ilagala; biya mu Leah, se gotek mu Rachel. ");
INSERT INTO wsk_vpl VALUES ("GN29_17","002_29_17","GEN","29","17","17","Leah ko motam ariga mu gugum se yawarakala, bare Rachel ko koma motam kumik lilim la mu balayam se yawarakala nunguningkiri. ");
INSERT INTO wsk_vpl VALUES ("GN29_18","002_29_18","GEN","29","18","18","Jacob gomang motam Rachel tuam, ale nu Laban maonam, “Ni ani ka nanawus gotek Rachel aisuko balu, mu asele ani yia tom 7 ko nika ura taikko,” mam. ");
INSERT INTO wsk_vpl VALUES ("GN29_19","002_29_19","GEN","29","19","19","Se Laban balam, “Mu terong. Ani ni kisekko, kari bo kilimik tuekko angamang me aniso. Ni ani agarak bagerko.” ");
INSERT INTO wsk_vpl VALUES ("GN29_20","002_29_20","GEN","29","20","20","Se Jacob Rachel gomang motam ninguru tuam ewere te se, yia tom 7 ningi ura tam mu ko ariga am tom tukunang gotek iwita. ");
INSERT INTO wsk_vpl VALUES ("GN29_21","002_29_21","GEN","29","21","21","Asele Jacob Laban maonam, “Tom aram,” mam. “Ka nanawus aisu se ilak naikko,” mam. ");
INSERT INTO wsk_vpl VALUES ("GN29_22","002_29_22","GEN","29","22","22","Se Laban na inang biya beteram, ale kariimet nunga auram se nukote tai gilingiman. ");
INSERT INTO wsk_vpl VALUES ("GN29_23","002_29_23","GEN","29","23","23","Bare tirom umu te Laban Leah ilak nama Jacob tuam se ilak aniram. ");
INSERT INTO wsk_vpl VALUES ("GN29_24","002_29_24","GEN","29","24","24","Ale Laban ura imet bo, ko nup Zilpah, agotala ko nanawus Leah ko ura imet ko tuam. ");
INSERT INTO wsk_vpl VALUES ("GN29_25","002_29_25","GEN","29","25","25","Se turomola Jacob imet koma arigam mu Leah! Se namaram Laban maonam, “Ni awuk se kiwem ewere ani angimik te beterem? Ani ura beterem mu Rachel ko ani ura taem. Se ni awuk se aninga kulem?” ");
INSERT INTO wsk_vpl VALUES ("GN29_26","002_29_26","GEN","29","26","26","Se Laban balam, “Ana imi te nanga munan mu iwita: kuriang laun mu kari tauk, asele uria mu kari taukko. ");
INSERT INTO wsk_vpl VALUES ("GN29_27","002_29_27","GEN","29","27","27","Ni Leah ilak bager se Leah kari tam ko amilmil ko tom week suanta imi menaruk, asele Rachel agotala kisekko. Bare ni yia tom 7 ko tala Rachel ko ura toko.” ");
INSERT INTO wsk_vpl VALUES ("GN29_28","002_29_28","GEN","29","28","28","Se Jacob butata beteram. Nu Leah ilak bagaram se week umu menaram, asele Laban ko nanawus Rachel agotala ko nuwus ko tuam. ");
INSERT INTO wsk_vpl VALUES ("GN29_29","002_29_29","GEN","29","29","29","Laban ura imet bo, ko nup Bilhah, agotala nanawus Rachel ko ura imet ko tuam. ");
INSERT INTO wsk_vpl VALUES ("GN29_30","002_29_30","GEN","29","30","30","Se Jacob Rachel ilak aniram; ale wete nongorak baga se, wore Rachel ko tawun biya kuakaso. Ale nu yia tom 7 ko tala aking Laban ko ura tam. ");
INSERT INTO wsk_vpl VALUES ("GN29_31","002_29_31","GEN","29","31","31","Jacob Leah me tawun biya ko kua tuikaso mu Yawe arigam, ale Leah saongam se tuagu aratam. Bare Rachel mu kuriang me ilukaso. ");
INSERT INTO wsk_vpl VALUES ("GN29_32","002_29_32","GEN","29","32","32","Leah tuagu aratam se kuriang kari iluwam, ale nup beteram Reuben mam. Mu awuk, “Yawe aninga angamang bataga arigam ale aga saongam. Aitak asele aga agari aga kuerukko,” mam. ");
INSERT INTO wsk_vpl VALUES ("GN29_33","002_29_33","GEN","29","33","33","Aking udagi tala Leah tuagu aratam se aking kuriang kari tala iluwam. Ale balam, “Yawe kuriang bo tala aisam, mu awuk, nu Jacob ani me aga kueso mu ari ikiam.” Buta se kuriang nup beteram Simeon mam. ");
INSERT INTO wsk_vpl VALUES ("GN29_34","002_29_34","GEN","29","34","34","Se Leah akingtala tuagu aratam ale kuriang kari tala iluwam. Ale balam, “Aitak asele aninga agari aga kitirokko, mu awuk, ani noko kuriang kari ilagala suan iluwem,” mam. Ale kuriang nup beteram Levi mam. ");
INSERT INTO wsk_vpl VALUES ("GN29_35","002_29_35","GEN","29","35","35","Se Leah akingtala tuagu aratam ale kuriang kari tala iluwam. Ale balam, “Bare aitak mu ani Yawe nup patawurikko,” mam. Ale kuriang nup beteram Judah mam. Se mu te Leah aking tom maiya nuam kuriang me ilukaso. ");
INSERT INTO wsk_vpl VALUES ("GN30_1","002_30_1","GEN","30","1","1","Rachel Jacob ko kuriang bo me ilukaso, Leah la kuriang ilukaso, owore te se nu Leah ko gomang magakaso. Se nu Jacob maonam, “Ni awuk se kuriang gue bo ani me aisisam? Kuriang aisko! Mena, mu ani kuerikko!” ");
INSERT INTO wsk_vpl VALUES ("GN30_2","002_30_2","GEN","30","2","2","Se Jacob gomang magaram se balam, “Ani Kaem me kiarikko! Nu kota ni tagu kaolam se ni kuriang me ilusam.” ");
INSERT INTO wsk_vpl VALUES ("GN30_3","002_30_3","GEN","30","3","3","Se Rachel mam, “Buta, aninga ura imet Bilhah iwo. To ale ilak anir se kuriang bo ilu ani aisuokko. Se umu te ani kuriang gue agotala bagarikko.” ");
INSERT INTO wsk_vpl VALUES ("GN30_4","002_30_4","GEN","30","4","4","Asele nu ko ura imet Bilhah Jacob ko imet ko tuam. Se nu ilak bagaram, ");
INSERT INTO wsk_vpl VALUES ("GN30_5","002_30_5","GEN","30","5","5","se tuagu aratam, se Jacob ko kuriang kari iluwam. ");
INSERT INTO wsk_vpl VALUES ("GN30_6","002_30_6","GEN","30","6","6","Se Rachel balam, “Kaem aninga niara ikiam ale aga saongam ale kuriang kari aisam.” Bore te se kuriang nup beteram Dan mam. ");
INSERT INTO wsk_vpl VALUES ("GN30_7","002_30_7","GEN","30","7","7","Se Rachel ko ura imet Bilhah akingtala tuagu aratam se Jacob ko kuriang kari bo tala iluwam. ");
INSERT INTO wsk_vpl VALUES ("GN30_8","002_30_8","GEN","30","8","8","Se Rachel balam, “Aninga laun ilak kuriang ko tagi gurungumu lagaman se ani nu kiarem.” Ale kuriang nup beteram Naphtali mam. ");
INSERT INTO wsk_vpl VALUES ("GN30_9","002_30_9","GEN","30","9","9","Se Leah aking kuriang bo karogo me iluwokko i mam, ale ko ura imet Zilpah Jacob ko imet ko tuam. ");
INSERT INTO wsk_vpl VALUES ("GN30_10","002_30_10","GEN","30","10","10","Se Zilpah Jacob ko kuriang kari iluwam. ");
INSERT INTO wsk_vpl VALUES ("GN30_11","002_30_11","GEN","30","11","11","Se Leah balam, “Imi am yawarakala se ko amilmilasam!” Ale kuriang nup beteram Gad mam. ");
INSERT INTO wsk_vpl VALUES ("GN30_12","002_30_12","GEN","30","12","12","Leah ko ura imet Zilpah kuriang kari bo tala iluwam. ");
INSERT INTO wsk_vpl VALUES ("GN30_13","002_30_13","GEN","30","13","13","Se Leah balam, “Aitak ani ninguru amilmilasam! Se imet suen la aga balmon amilmil imet mamonko.” Ale kuriang nup beteram Asher mam. ");
INSERT INTO wsk_vpl VALUES ("GN30_14","002_30_14","GEN","30","14","14","Wheat nunguning gia ko kam te, Reuben geragawa mandrake muguri arigam, ale sang giam karogo tairam ko nuam Leah tuam. Se Rachel Leah maonam, “Ka kuriang mandrake muguri giam wore sang aisuko,” mam. ");
INSERT INTO wsk_vpl VALUES ("GN30_15","002_30_15","GEN","30","15","15","Bare Leah balam, “Ni aninga agari tere taem mu ni mel gotek ko iwita ikisam ale aitak aking aga kuriang mandrake karogo tairam imi sang ko balsam e?” Se Rachel mam, “Mu ani ikisam. Bare aitak iwita betenakko mu awuk, terong e? Nika kuriang mandrake ago tairam mu sang aisu, mu asele aitakta tirom mu ni Jacob ilak anirko,” mam. ");
INSERT INTO wsk_vpl VALUES ("GN30_16","002_30_16","GEN","30","16","16","Se bainga ningi Jacob ningam ningi laga peleram taiwaram se Leah arigokko namaram ale maonam, “Aitak tirom imi ni ani agarak anirko. Ani maingkala mandrake te ka diarem,” mam. Se tirom mu te Jacob ilak aniram. ");
INSERT INTO wsk_vpl VALUES ("GN30_17","002_30_17","GEN","30","17","17","Kaem Leah ko gomang motam se ko niara ari ikiam, bore te se Leah tuagu aratam se kuriang kari bo tala iluwam. Aitak Jacob ko namarari Leah tuagu te mu 5 aram. ");
INSERT INTO wsk_vpl VALUES ("GN30_18","002_30_18","GEN","30","18","18","Se nu mam, “Ani aga ura imet aga agari tuem se Kaem koma yawara aisam.” Ale kuriang nup beteram Issachar mam. ");
INSERT INTO wsk_vpl VALUES ("GN30_19","002_30_19","GEN","30","19","19","Leah akingtala tuagu aratam se kuriang kari bo tala iluwam. Aitak kuriang Leah tuagu te mu 6 aram. ");
INSERT INTO wsk_vpl VALUES ("GN30_20","002_30_20","GEN","30","20","20","Se balam, “Kaem munan ningo ani aisam. Se aitak aninga agari bala ningo ago ko balukko, mu awuk, ani ko kuriang kari 6 nunga iluwem.” Ale kuriang nup beteram Zebulun mam. ");
INSERT INTO wsk_vpl VALUES ("GN30_21","002_30_21","GEN","30","21","21","Se udagi Leah kuriang imet iluwam, ale nup beteram Dinah mam. ");
INSERT INTO wsk_vpl VALUES ("GN30_22","002_30_22","GEN","30","22","22","Asele Kaem ko gomang motam lila te Rachel ko niara iki karo tuam ale tuagu kaogam. ");
INSERT INTO wsk_vpl VALUES ("GN30_23","002_30_23","GEN","30","23","23","Se Rachel tuagu aratam se kuriang kari iluwam, ale balam, “Kaem aninga dolara menawuram,” mam. ");
INSERT INTO wsk_vpl VALUES ("GN30_24","002_30_24","GEN","30","24","24","Ale kuriang nup beteram Joseph ma se wosengam, “Yawe kuriang bo karogotala aisuokko,” mam. ");
INSERT INTO wsk_vpl VALUES ("GN30_25","002_30_25","GEN","30","25","25","Joseph Rachel tuagu te bilangaram, asele Jacob Laban maonam, “Aninga bitar se aga sor wonong te pelerikko. ");
INSERT INTO wsk_vpl VALUES ("GN30_26","002_30_26","GEN","30","26","26","Aninga imet kuriang nunga giekko ko ura ani ninguru beterem. Ale aninga ura kowar ni ko ko mu ni ninguru ko ikisam. Buta se aga imet kuriang karogo nanga awur se namanakko.” ");
INSERT INTO wsk_vpl VALUES ("GN30_27","002_30_27","GEN","30","27","27","Bare Laban nu maonam, “Aninga ikia yumura mu balik se ikiko. Ani ninguru ari kutuwu saperem, ni ani agarak bagasam se ni te Yawe ani karogo la aga saongam. Buta se am agarak baga se, ");
INSERT INTO wsk_vpl VALUES ("GN30_28","002_30_28","GEN","30","28","28","ura i bitar ale ko koma anapeya ko balu, mu ani am kisekko.” ");
INSERT INTO wsk_vpl VALUES ("GN30_29","002_30_29","GEN","30","29","29","Se Jacob nu maonam, “Ni keta ani ura iluwem mu ko ikisam. Ale ni ikisam, ani ka sipsip se mel suen biya ninguru nunga bituem. ");
INSERT INTO wsk_vpl VALUES ("GN30_30","002_30_30","GEN","30","30","30","Ulengkala mu nika sipsip mel suen biya uwuta mena. Bare aitak ani ni kerak bagasam umu te, Yawe ka saongam se suen biya arataman. Se awuk, ani amaru te agata aga kuriang imet se angimik ko ura iluwekko ya?” ");
INSERT INTO wsk_vpl VALUES ("GN30_31","002_30_31","GEN","30","31","31","Se Laban Jacob isuam, “Ani anape te ka diarikko?” mam. Se Jacob balam, “Ani mel bo ko me kuesam. Bare aninga angamang imi balik se ni karo tuiko balu, mu asele ani ka sipsip se ka goat aking nunga bituekko. ");
INSERT INTO wsk_vpl VALUES ("GN30_32","002_30_32","GEN","30","32","32","Aninga angamang mu aitak ani nika sipsip se goat ninguru nungarki gurugek, ale sipsip siraram mu nika, se suan suan ningi kaetam mu ani giekko. Se goat kaetam mu nika, bare suan suan ningi kaetam siraram mu ani nunga giekko. Sipsip kaetam mu se goat kaetam siraram mu aninga ura koma nunga giekko. ");
INSERT INTO wsk_vpl VALUES ("GN30_33","002_30_33","GEN","30","33","33","Se udagi te ni keta arik, ani munan diram beterem agi mu arikko. Mu awuk, tom ni tair ale aninga sipsip se goat nungarki, ale sipsip siraram lilim bo arik agi, goat kaetam lilim bo arik agi, mu nika wore ani giem iwita ko ma baluko.” ");
INSERT INTO wsk_vpl VALUES ("GN30_34","002_30_34","GEN","30","34","34","Se Laban balam, “Mu terong. Ni balem butata betenakko.” ");
INSERT INTO wsk_vpl VALUES ("GN30_35","002_30_35","GEN","30","35","35","Bare tom suanta umutang te la nu kawel bo beteram, ale goat nungumik kaetam siraram mu se sipsip nungumik kaetam Jacob ko balam mu nunga tueteram, ale ko namarari nungaram. ");
INSERT INTO wsk_vpl VALUES ("GN30_36","002_30_36","GEN","30","36","36","Nuna suen la day ilagala suan aolak iluman awar biya namaman ale sor bo te bagakasan. Se Jacob mu Laban ko sipsip siraram likilim se goat kaetam likilim wore la nunga bitaruwakaso. ");
INSERT INTO wsk_vpl VALUES ("GN30_37","002_30_37","GEN","30","37","37","Bare Jacob tam duap duap ko kower marak wore giam, ale guang naung naung maiya la wasaram, se tom siraram se maramarak mu aratu namaman. ");
INSERT INTO wsk_vpl VALUES ("GN30_38","002_30_38","GEN","30","38","38","Ale tam umu kuwim goat se sipsip te yu nokasan mu ko koma ko bangaru bangaru ago namaram. Mu awuk, tom goat se sipsip yu namonko taisan mu, nuna oworete nunumi awote araga kapa gilingisan. Buta se goat se sipsip yu namonko taikasan, ");
INSERT INTO wsk_vpl VALUES ("GN30_39","002_30_39","GEN","30","39","39","ale tam mu ari se nunumi awote araga kapakasan. Ale udagi kuriang kaetam siraram nunga ilukasan agi mu, ");
INSERT INTO wsk_vpl VALUES ("GN30_40","002_30_40","GEN","30","40","40","Jacob nunga gikaso, kuwim kigilik te nunga awukaso, mu noko. Bare sikina mu nunumi awote araga kapara ko tom te mu, nongoma gurugu Laban ko sipsip kaetam se ko goat kaetam siraram wore nongoma tuikasan. Nu munan mu te, kota ko sipsip se goat motam bo ilu biguwuram. Nu Laban ko mu arungu me bolala awuram. ");
INSERT INTO wsk_vpl VALUES ("GN30_41","002_30_41","GEN","30","41","41","Se tom goat se sipsip sokel ago mu nunumi awote araga kapamonko tom, mu Jacob tam kower umu kuwim te yu nana mu duap te bangarukaso, se nuna ari se nunumi awote araga kapakasan. ");
INSERT INTO wsk_vpl VALUES ("GN30_42","002_30_42","GEN","30","42","42","Bare goat se sipsip tilital, mu nu tam kower nunga nomokete me bitakaso, se kuriang ilukasan mu tilital tala. Se munan mu te goat se sipsip tilital mu Laban ko, se goat ningo nuam kaetam siraram se sipsip kaetam sokel ago mu noko gikaso. ");
INSERT INTO wsk_vpl VALUES ("GN30_43","002_30_43","GEN","30","43","43","Se mu te Jacob mel gemarukko negeram mu me karogo kolaram. Noko ura kariimet ta, se sipsip ta, se goat ta, se camel ta, se donkey am koma suanta. ");
INSERT INTO wsk_vpl VALUES ("GN31_1","002_31_1","GEN","31","1","1","Jacob den marir Laban ko namarari nu kumik ko balukasan mu tai due naguram se ikiam, “Jacob anananga ba ko mel suen biya nu giam! Ale nu aitak mel suen biya ago bagoso,” makasan. ");
INSERT INTO wsk_vpl VALUES ("GN31_2","002_31_2","GEN","31","2","2","Se Jacob betela Laban ko kiwem arigam mu pempem uwuta mena, se nu maingkala ko ikiam. ");
INSERT INTO wsk_vpl VALUES ("GN31_3","002_31_3","GEN","31","3","3","Se Yawe Jacob maonam, “Ni piler ale ka ba alo nunga sor te, ka gue suan nongote namarko. Ani ni kerak bagasam.” ");
INSERT INTO wsk_vpl VALUES ("GN31_4","002_31_4","GEN","31","4","4","Se Jacob ko imet ilagala Leah se Rachel nunga den beteram, taimon ale awar kuwim nu te sipsip se goat nunga bitaruwaram wore te arigimonko balam. ");
INSERT INTO wsk_vpl VALUES ("GN31_5","002_31_5","GEN","31","5","5","Se taiman se iwita nunga maonam, “Nenenga ba ko munan pempem aningate bitawara mu geragam se ani arigisam. Bare aninga ait ko Kaem mu ani agarak baga se aga sangarukaso. ");
INSERT INTO wsk_vpl VALUES ("GN31_6","002_31_6","GEN","31","6","6","Nina ilagala ikisan, ani nenenga nenet ko ura aora biya nunguningkiri taem. ");
INSERT INTO wsk_vpl VALUES ("GN31_7","002_31_7","GEN","31","7","7","Bare nu pempem la kawelakaso ale aninga ura koma balukaso iwita te diram me aisukaso. Bare Kaem aninga sinar tokaso se ani memek bo nu kuting te me arikasam. ");
INSERT INTO wsk_vpl VALUES ("GN31_8","002_31_8","GEN","31","8","8","Se tom nu balukaso, ‘Goat nungumik kaetam siraram mu nika,’ makaso, mu goat nuam kuriang nungumik kaetam siraram mu la nunga ilukasan. Se tom nu balukaso, ‘Goat nungumik mone kaetam siraram maiya maiya mu nika,’ makaso, mu goat nuam kuriang uwutata nunga ilukasan. ");
INSERT INTO wsk_vpl VALUES ("GN31_9","002_31_9","GEN","31","9","9","Mu Kaem kota nenenga nenet ko sipsip se ko goat nunga gikaso ale ani aisukaso. ");
INSERT INTO wsk_vpl VALUES ("GN31_10","002_31_10","GEN","31","10","10","“Tom goat nunumi awote aragamon kapamonko tom te, ani ipingira bo arigem, mu goat anumang nungumik kaetam siraram wore la goat pagar mu nunga awote araga kapakasan se arigem. ");
INSERT INTO wsk_vpl VALUES ("GN31_11","002_31_11","GEN","31","11","11","Se Kaem ko engel aga auram, ‘Jacob,’ mam. Se ani ‘Baluko,’ maem. ");
INSERT INTO wsk_vpl VALUES ("GN31_12","002_31_12","GEN","31","12","12","Se nu balam, ‘Arikko, goat anumang nungumik kaetam siraram mu la diram goat pagar mu nunga awote araga kapasan. Mu awuk, munan Laban ni kimik te bitakaso mu ani ari saperem. ");
INSERT INTO wsk_vpl VALUES ("GN31_13","002_31_13","GEN","31","13","13","Ani Kaem ewerta ni Bethel bagerem se kete aratem. Se ni manga bo patawu bangem, ale olive oil awote warem, ale ani agarak den kalem. Ario, bares ale sor imi bitar, ale ka sor te piler ale namarko,’ mam.” ");
INSERT INTO wsk_vpl VALUES ("GN31_14","002_31_14","GEN","31","14","14","Se Leah Rachel ilak Jacob manorman, “Mu terong. Ana ilagala mel bo anananga nainet kote ginakko mena. ");
INSERT INTO wsk_vpl VALUES ("GN31_15","002_31_15","GEN","31","15","15","Nu ana wonong bo ko imet iwita aitak nangarkoso! Ni maingkala anananga diarem, bare ana ni kiting umu katir me arigiman, nu kota maguwu saparam. ");
INSERT INTO wsk_vpl VALUES ("GN31_16","002_31_16","GEN","31","16","16","Nunguningta, Kaem anananga nainet ko melmasak suen biya giam ale ana nanga kuriang ago nangaram. Buta se ni Kaem ka maonam butata bitarko.” ");
INSERT INTO wsk_vpl VALUES ("GN31_17","002_31_17","GEN","31","17","17","Se Jacob barasam ko imet kuriang nunga gi camel awote nunga awuram. ");
INSERT INTO wsk_vpl VALUES ("GN31_18","002_31_18","GEN","31","18","18","Ale ko sipsip se ko goat, se ko mel suen la Paddan Aram giam, mu camel donkey karogo nunga diruwuram se giriman. Nu ko melmasak lilim karogo ko nuet Isaac kote Canaan peleruk ale namarukko. ");
INSERT INTO wsk_vpl VALUES ("GN31_19","002_31_19","GEN","31","19","21","Nu uwuta bitirukko mu Aram kari Laban katir me maonam. Nu am kuluru banuwa, ko mel suen biya giam, ale yu Euphrates batagorman, ale aolak iluman, Gilead sor duruk ago mu te ko lage taman namakasan. Tom mu Laban ko sipsip nunga nomone batagukko namaram, se Rachel ko nuet Laban ko kaem kawel kuar te kisiman se kawam ningi aniram, mu karogotala nunga tere giam ale karogo naguram. ");
INSERT INTO wsk_vpl VALUES ("GN31_22","002_31_22","GEN","31","22","22","Jacob naguram se day ilagala suan namaram asele Laban den ikiam. ");
INSERT INTO wsk_vpl VALUES ("GN31_23","002_31_23","GEN","31","23","23","Nu ko kari sang nunga giam, ale day 7 ko, Jacob kowom karoman ale nama sor Gilead duruk ago umu te Jacob arigiman. ");
INSERT INTO wsk_vpl VALUES ("GN31_24","002_31_24","GEN","31","24","24","Se tirom mu te Kaem ipingira te Laban maonam, “Ni sinar toko. Ni den ikup bo, ningo agi memek ta, wore Jacob me manaruko!” mam. ");
INSERT INTO wsk_vpl VALUES ("GN31_25","002_31_25","GEN","31","25","25","Jacob ko kuwim Gilead sor duruk ago mu te nungam. Se Laban nama arigam, mu nu agotala ko kawam sel sor mu te tala bare awar nuam baongam. ");
INSERT INTO wsk_vpl VALUES ("GN31_26","002_31_26","GEN","31","26","26","Asele Laban Jacob maonam, “Ni awuk se munan sowore beterem? Ni aninga kulem, ale aninga nanawusari talipara kariimet iwita nunga giem. ");
INSERT INTO wsk_vpl VALUES ("GN31_27","002_31_27","GEN","31","27","27","Ni anape ko aga kulem ale yumura la nagurem? Ni awuk se ani me aga manem? Ni aninga manem le mu, ani amilmil te wur bawe te ka beterem se namerem le. ");
INSERT INTO wsk_vpl VALUES ("GN31_28","002_31_28","GEN","31","28","28","Ni tom kulupik bo aisem se ani aga aimasari se aga nanawusari nunga yaserem ale den ningo mu nungaru se me nunga beterem se namaman. Ni ngualara kilek beterem. ");
INSERT INTO wsk_vpl VALUES ("GN31_29","002_31_29","GEN","31","29","29","Aninga sokel te ka maguwurikko mu karogo. Bare nika niet ko Kaem tirom ipingira te aga maonam ale mam, ‘Sinar toko. Ni den ikup bo, ningo agi memek ta, wore Jacob me manaruko,’ mam. Ewere te se, ani kiwem bo nikate me bitirikko. ");
INSERT INTO wsk_vpl VALUES ("GN31_30","002_31_30","GEN","31","30","30","Ani ikisam, ni ka niet ko sor duap te pilerko gemang tawun biya aniso. Bare ni paguwurem. Ni anape ko aninga kawam bitua ko kaem agotala tere giem?” ");
INSERT INTO wsk_vpl VALUES ("GN31_31","002_31_31","GEN","31","31","31","Se Jacob balam, “Ani ni ka nanawusari sail te nunga bataguru gi wore ko nguangerem. ");
INSERT INTO wsk_vpl VALUES ("GN31_32","002_31_32","GEN","31","32","32","Bare aninga kariimet karogo nanga ningi, bo nika kaem mu nunga iluwuruk se arik agi mu, nu marak me bagarukko. Nanga gue suan nomotam te, aninga mel suen la gurugu sapar ale nika mel i bo arik mu toko.” Bare Jacob nuwus Rachel mu ko nuet Laban ko kaem kawel nunga tere giam mu Jacob me ko ikikaso. ");
INSERT INTO wsk_vpl VALUES ("GN31_33","002_31_33","GEN","31","33","33","Se Laban Jacob ko kawam sel ningi kasu naguram ale loagaram. Ale aking Leah ko kawam sel ningi kasu naguram ale loagaram. Asele ura saonga imet ilagala mu nunga kawam sel ningi kasu naguram ale loagaram. Bare nu mel bo me arigam. Ale nukum kitira mu Rachel ko kawam sel ningi kasu naguram. ");
INSERT INTO wsk_vpl VALUES ("GN31_34","002_31_34","GEN","31","34","34","Bare Rachel mungkala ko nuet ko kaem kawel mu nunga giam ale ko camel ko daiga kuwim ningi kaluwuram, ale awote daigam bagakaso. Se Laban mel suen biya kawam sel ningi aniram mu ari gurugu saparam, bare nu ko kaem kawel me nungarkam. ");
INSERT INTO wsk_vpl VALUES ("GN31_35","002_31_35","GEN","31","35","35","Se Rachel nuet maonam, “Aninga Ba, gemang me ikuwurokko. Ani aga sige arigem ale dagiwasam, ni kema te barasu sanamarikko me terong.” Se Laban sor gi kutuwuram, bare ko kaem kawel me nungarkam. ");
INSERT INTO wsk_vpl VALUES ("GN31_36","002_31_36","GEN","31","36","36","Se Jacob gomang ninguru magaram se Laban ilak alisiram, “Ani anape memek beterem se ni iwitata aninga karem agarak tairem? ");
INSERT INTO wsk_vpl VALUES ("GN31_37","002_31_37","GEN","31","37","37","Se aitak ni aninga melmasak suen la ilu gurugu patawu saperem. Se nika mel i bo arigem agi mu, gi karogo tai imi te bitar se suen la, nika ta, aninga ta, arigimonko. Se nuna awiriya diram mu balmon se ikinakko. ");
INSERT INTO wsk_vpl VALUES ("GN31_38","002_31_38","GEN","31","38","38","“Ani yia 20 ko ni kerak bagerem. Se nika sipsip agi goat bo katir kuriang gue me sapa arigam. Agi ani ka sipsip garuk bo, tom bo te ta me morem ale kai naem, mena. ");
INSERT INTO wsk_vpl VALUES ("GN31_39","002_31_39","GEN","31","39","39","Tom mel memek saki ka sipsip nunga moakasan, mu ani me ka kasurukasam, mena. Ani agata sipsip magakaso mu koma bo to kuwim te bitakasam. Woremkalal agi tirom mel tere nokasan, mu ni tom suen biya ani koma kutuwurekko den aora biya aga manarukasam, se ani koma kutuwukasam. ");
INSERT INTO wsk_vpl VALUES ("GN31_40","002_31_40","GEN","31","40","40","Ani tirom kowarkalal uwutata bagakasam. Kowarkalal worem ninguru aga kanikaso. Se tirom mu marir ninguru aga kulukurukaso. Amotam anira me arikaso. ");
INSERT INTO wsk_vpl VALUES ("GN31_41","002_31_41","GEN","31","41","41","Yia 20 ko ani uwutata kerak baga se ka ura ilu lagerem. Ani ka nanawusari nunga giekko mu yia 14 ko ura iluwem, ale udagi yia 6 ko, nika sipsip se goat sang aisuko ko ura taem. Bare ni aninga ura koma balukasam uwutata me bitakasam. ");
INSERT INTO wsk_vpl VALUES ("GN31_42","002_31_42","GEN","31","42","42","Aninga ait Isaac se angatak Abraham nunga Kaem mu agarak me bagaram le mu, aninga ura kowar mu koma mena, ni ipi aga beterem se namerem le. Bare Kaem aninga angamang ikup se aga ura kowar beterem mu arigam, ale ekelako tirom den sail karogo ka maonam.” ");
INSERT INTO wsk_vpl VALUES ("GN31_43","002_31_43","GEN","31","43","43","Se Laban Jacob ko den koma balam, “Imet imi mu aninga nanawusari, se nononga kuriang mu aninga. Se sipsip se goat mu aninga tala. Se mel suen biya ni arigisam mu aninga. Bare ani lage bo te aga nanawusari se nunga kuriang nunga guramarikko me terong. ");
INSERT INTO wsk_vpl VALUES ("GN31_44","002_31_44","GEN","31","44","44","Buta se ni analak den bo kalonakko. Ale kausa bo betenak, ale pempem te nangamin ares maukko.” ");
INSERT INTO wsk_vpl VALUES ("GN31_45","002_31_45","GEN","31","45","45","Se Jacob manga bilik bo maiya wore tam ale patawu baongam. ");
INSERT INTO wsk_vpl VALUES ("GN31_46","002_31_46","GEN","31","46","46","Ale ko gue suan nunga maonam, “Manga sang gial ale nunumi awote awuralko,” mam. Se butata beteman. Se duap te dagiman ale na no gilingiman. ");
INSERT INTO wsk_vpl VALUES ("GN31_47","002_31_47","GEN","31","47","47","Se Aram den te Laban sor mu ko nup beteram Jegar Sahadutha mam. Se Hebrew den te Jacob sor mu ko nup beteram Galeed mam. ");
INSERT INTO wsk_vpl VALUES ("GN31_48","002_31_48","GEN","31","48","48","Se Laban balam, “Manga nunumi awote awuman imi mu kausa iwita, ariginak ale te nangamin ares maukko.” Buta se sor mu nup beteman Galeed maman. ");
INSERT INTO wsk_vpl VALUES ("GN31_49","002_31_49","GEN","31","49","49","Sor mu ko nup bo tala beteman Mizpah maman. Mu awuk, Laban balam, “Aitak ni analak kirker baganakko. Bare Yawe nangarkiwurukko. ");
INSERT INTO wsk_vpl VALUES ("GN31_50","002_31_50","GEN","31","50","50","Ni aninga nanawusari nunga bita maguwur agi, imet iru gi agi, se ani me ko ikiek agi, wore Kaem ni analak nangarkiwoso mu ko me kamili saparukko.” ");
INSERT INTO wsk_vpl VALUES ("GN31_51","002_31_51","GEN","31","51","51","Ale Laban akingtala Jacob maonam, “Manga nunumi awote awuman imi se manga bangorman sumu, mu ni analak nanga kusumuri anirukko. ");
INSERT INTO wsk_vpl VALUES ("GN31_52","002_31_52","GEN","31","52","52","Manga nunumi awote awura mu se manga baonga mu kausa iwita aniruk, se ani kiarik namarik me ka maguwurik, se ni betela, kier ale tair ani me aga maguwurko. ");
INSERT INTO wsk_vpl VALUES ("GN31_53","002_31_53","GEN","31","53","53","Anananga nanangatak Abraham Nahor ilak nunga Kaem mu nanga tutera ko Kaem bagarukko.” Se Jacob den aora biya noko nuet Isaac ko Kaem, ko nguanga se nup patawukaso, wore ko nup te balam. ");
INSERT INTO wsk_vpl VALUES ("GN31_54","002_31_54","GEN","31","54","54","Ale nu goat bo moram ale sor duruk ago mu te Kaem tama bita tuam. Ale ko nunguning sang kaiyam ale inang beteram, se ko gue suan suen la taiman ale naman. Ale sor umu te ani gilingiman. ");
INSERT INTO wsk_vpl VALUES ("GN31_55","002_31_55","GEN","31","55","55","Ukiram se tumong biyala Laban barasam, ko nanawusari se ko numasari nunga iluwam ale den amilmil nungaram, ale nu peleram ko sor te namaram. ");
INSERT INTO wsk_vpl VALUES ("GN32_1","002_32_1","GEN","32","1","1","Jacob betela sor mu beteram ale aolak iluwam namawaram se Kaem ko engel lage te kote arataman. ");
INSERT INTO wsk_vpl VALUES ("GN32_2","002_32_2","GEN","32","2","2","Se nu nungarkam ale balam, “Kuwim imi Kaem ko kager kari nunga nuguwim!” mam. Umutang nu sor mu nup beteram Mahanaim mam. ");
INSERT INTO wsk_vpl VALUES ("GN32_3","002_32_3","GEN","32","3","3","Jacob ko ura kari den nungaram ale nunga giruwuram se ko laun Esau kote, ko ali Seir, sor Edom mu te, girimon namamonko nunga maonam. ");
INSERT INTO wsk_vpl VALUES ("GN32_4","002_32_4","GEN","32","4","4","Nu nunga kiti gurugam ale mam, “Nina aninga agiring imi aga kari laun Esau maonalko, ‘Nika ura kari Jacob iwita balam: Ani Laban ilak baga laga pelerem taiwasam. ");
INSERT INTO wsk_vpl VALUES ("GN32_5","002_32_5","GEN","32","5","5","Aga bulmakau se donkey, sipsip se goat, se aga ura kariimet karogo lilim taiwasam. Ale ani den imi ni aga kari dom kete betesam, mu ni amilmiler mu asele ani tairikko.’” ");
INSERT INTO wsk_vpl VALUES ("GN32_6","002_32_6","GEN","32","6","6","Se Jacob ko ura kari mu Esau ko den koma karogo peleman Jacob kote taiman ale manorman, “Ana nika laun Esau kote nama arataman, se nu ni karkukko taiwoso. Noko kari 400 nunga giam ale taiwoso.” ");
INSERT INTO wsk_vpl VALUES ("GN32_7","002_32_7","GEN","32","7","7","Se Jacob den mu ikiam ale ninguru nguangakaso, ale ikia moakaso. Se nu ko kariimet, ko bulmakau, camel, sipsip, goat, donkey, pagaru motam ilagala awuram. ");
INSERT INTO wsk_vpl VALUES ("GN32_8","002_32_8","GEN","32","8","8","Nu ikikaso, “Esau tairuk motam gira nunga moruk agi mu, motam udagi mu nagumonko terong agila.” ");
INSERT INTO wsk_vpl VALUES ("GN32_9","002_32_9","GEN","32","9","9","Asele Jacob guranek beteram ale mam, “O aninga angatak Abraham ko Kaem, aga ait Isaac ko Kaem, O Yawe, nigita aninga manem, ‘Ni piler ale ka sor te, ka gue suan nongote namar se ani ningo la kete bitirikko,’ balem. ");
INSERT INTO wsk_vpl VALUES ("GN32_10","002_32_10","GEN","32","10","10","Ani kari ningo bo iwita mena, bare ni gemang aisem, ale kilek ningo la ani ka ura kari agate beterem. Tom ani kulak la aga nang ba nunga beterem, mu ani agata suanta aga sikir iluwem ale Jordan kiarem ale namerem. Bare aitak ani pelerem mu aga daup motam bibiya ilagala karogo lilim taiwasam. ");
INSERT INTO wsk_vpl VALUES ("GN32_11","002_32_11","GEN","32","11","11","O Yawe, ani nguangasam. Aga sangaruko. Aga laun Esau tairuk ale aga imet kuriang karogo lilim nanga maguwurok bore ko, aga sangaruko. ");
INSERT INTO wsk_vpl VALUES ("GN32_12","002_32_12","GEN","32","12","12","Bare ni balem, ‘Ani ningo la nikate bitirik se nika gue te kariimet kapamon ale langi ko saun iwita sor tamonko, se kariimet bo kaurokko me terong.’ Ni den mu ko kamin ares maukko.” ");
INSERT INTO wsk_vpl VALUES ("GN32_13","002_32_13","GEN","32","13","13","Se Jacob sor mu te tirom bagaram. Se ukiram se noko melmasak suen la mu ningi, melmasak suan suan gi Esau tuokko ilu biguwuram: ");
INSERT INTO wsk_vpl VALUES ("GN32_14","002_32_14","GEN","32","14","14","goat pagar 200 se goat anumang 20, se sipsip pagar 200 se sipsip anumang 20, ");
INSERT INTO wsk_vpl VALUES ("GN32_15","002_32_15","GEN","32","15","15","se camel gotek ago mu 30, se bulmakau pagar 40 se bulmakau anumang 10, se donkey pagar 20 se donkey anumang 10. ");
INSERT INTO wsk_vpl VALUES ("GN32_16","002_32_16","GEN","32","16","16","Nu uwutata beteram, asele ura kari nunga paogam, ale nunga tuteram mel paogam mu nunga bitarmonko nunga awuram. Ale nu nunga maonam, “Nina giral se ani negowom karikko. Se melmasak mu motam kirker animonko.” ");
INSERT INTO wsk_vpl VALUES ("GN32_17","002_32_17","GEN","32","17","17","Ale ura kari girok namarukko mu maonam, “Tom aninga laun Esau lage te ni karkuk ale ka isuok, ‘Ni awiri ko ura kari ya?’ mauk, ale ‘Aparete namasam a?’ mauk, ale ‘Melmasak imi awiri ko ya?’ mauk, ");
INSERT INTO wsk_vpl VALUES ("GN32_18","002_32_18","GEN","32","18","18","mu ni iwita baluko, ‘Mel suen la imi mu nika ura kari Jacob ko munan noko kari dom nikate beteram se ani ago taiwasam. Se Jacob kota mu udagi taiwoso,’ iwita baluko.” ");
INSERT INTO wsk_vpl VALUES ("GN32_19","002_32_19","GEN","32","19","19","Se Jacob den koma suanta umutang la ko ura kari mel bitarmonko mu nungaru saparam. Ale nunga maonam, “Tom nina lage te Esau arigal, mu den suanta umutang la nu maonalko. ");
INSERT INTO wsk_vpl VALUES ("GN32_20","002_32_20","GEN","32","20","20","Ale den ‘Nika ura kari Jacob udagi taiwoso’ mu maonalko mu ningamili me saparukko,” mam. Mu Jacob iwita kuamin tugukaso, “Ani munan imi te aga laun gomang lila awurekko agila. Se nu ani agarkuk, bare memek ani ulengkala nu kumik te beterem mu ko kuamili saparukko.” ");
INSERT INTO wsk_vpl VALUES ("GN32_21","002_32_21","GEN","32","21","21","Buta se Jacob ko munan laun Esau ko beteram mu balam se giriman ago namakasan, se nu tirom umu te ko kuwim te bagaram mu te am bagakaso. ");
INSERT INTO wsk_vpl VALUES ("GN32_22","002_32_22","GEN","32","22","22","Se tirom suanta mu te la, Jacob barasam ale ko imet ilagala mu se, ko ura saonga imet ilagala mu se, ko namarari 11 mu karogo, yu Jabbok ko luan kuringi mu karoman ale komasang te kasu kapaman. ");
INSERT INTO wsk_vpl VALUES ("GN32_23","002_32_23","GEN","32","23","23","Nu nunga diruwuram se giriman kasu kapaman, asele aking ko ura kari nunga diruwuram se ko melmasak lilim la karogo kasu kapaman. ");
INSERT INTO wsk_vpl VALUES ("GN32_24","002_32_24","GEN","32","24","24","Nuna bita sapaman se nu kota yu komasang ko bagaram. Se kari bo tairam ilak numi sagaru lagaram la sor ukira duap iluwam. ");
INSERT INTO wsk_vpl VALUES ("GN32_25","002_32_25","GEN","32","25","25","Se kari mu numi ko ikiam mu nu Jacob ko sokel karogo kaparukko me terong, se nu Jacob ko bugi duap kau tam se kutugam. ");
INSERT INTO wsk_vpl VALUES ("GN32_26","002_32_26","GEN","32","26","26","Se kari mu Jacob maonam, “Sor ukirokko pingi aram. Aninga bitar se namarikko.” Bare Jacob nu maonam, “Ni ani marak aisu mu asele ani ka bitirik se namarko.” ");
INSERT INTO wsk_vpl VALUES ("GN32_27","002_32_27","GEN","32","27","27","Se kari mu Jacob isuam, “Nika nip awiri ya?” Se Jacob balam, “Aninga aip Jacob i,” mam. ");
INSERT INTO wsk_vpl VALUES ("GN32_28","002_32_28","GEN","32","28","28","Se kari mu balam, “Ni udagi ka nip Jacob me anirukko. Nika nip aitak mu Israel. Mu awuk, ni Kaem ilak nimi sagem, ale ali kari karogo la nongorak barimerem, ale nongorak kaperem.” ");
INSERT INTO wsk_vpl VALUES ("GN32_29","002_32_29","GEN","32","29","29","Se Jacob isuam, “Nika nip aga manaruko,” mam. Bare kari mu mam, “Ni anape ko aninga aip ikiko?” Ale nu eng Jacob marak tuam. ");
INSERT INTO wsk_vpl VALUES ("GN32_30","002_32_30","GEN","32","30","30","Se Jacob sor mu nup beteram Peniel ma se balam, “Ani Kaem ilak pingita nanimi nangama arigiman, bare ani me kuerem,” mam. ");
INSERT INTO wsk_vpl VALUES ("GN32_31","002_32_31","GEN","32","31","31","Worem basuwaram se Jacob sor Peniel mu beteram. Bare nu aolak diram me ilukaso, mu awuk, noko bugi duap kutugam. ");
INSERT INTO wsk_vpl VALUES ("GN32_32","002_32_32","GEN","32","32","32","Buta se tom mu te se tai aitak, Israel alo anapeya mosan ale nasan, mu ko bugi duap ko pisi me nasan. ");
INSERT INTO wsk_vpl VALUES ("GN33_1","002_33_1","GEN","33","1","1","Jacob motam patawu Esau ko kari 400 arungak taiwaram mu nungarkam. Ale noko nuwus ilagala Leah, Rachel, se ko ura saonga imet ilagala mu nunga kuriang nomoke nomoke nungaram se arungu sanami gilingiman. ");
INSERT INTO wsk_vpl VALUES ("GN33_2","002_33_2","GEN","33","2","2","Nu ko ura saonga imet nunga kuriang arungu gira nunga awuram. Ale Leah ko kuriang arungu mu kusumuri nunga awuram, ale Rachel ko namar Joseph ilak mu nukum te nunga awuram. ");
INSERT INTO wsk_vpl VALUES ("GN33_3","002_33_3","GEN","33","3","3","Se Jacob kota mu giram ko laun kote nama se, bugura kulukurukaso koma motam ali ningi kapakaso, se aking barasukaso, nama akingtala uwutatala bitakaso. Nu tom 7 ko uwutata ko laun kote beteram. ");
INSERT INTO wsk_vpl VALUES ("GN33_4","002_33_4","GEN","33","4","4","Bare Esau iluwok ale yasarukko naguram kote tairam, ale iluwam yasaram ale musuk tuam. Ale wete nunumi iluman ale niakasan. ");
INSERT INTO wsk_vpl VALUES ("GN33_5","002_33_5","GEN","33","5","5","Ale Esau loagaram ale imet kuriang nungarkam, ale isam, “Mu arika kariimet ni kerak taiman a?” mam. Se Jacob balam, “Imi kuriang Kaem ko gomang ningo te ani ka ura kari aisam bore,” mam. ");
INSERT INTO wsk_vpl VALUES ("GN33_6","002_33_6","GEN","33","6","6","Asele ura saonga imet nunga kuriang ago taiman Esau ko koma dugu te nubugura kulukurman. ");
INSERT INTO wsk_vpl VALUES ("GN33_7","002_33_7","GEN","33","7","7","Nogowom kaora mu Leah ko kuriang nongorak taiman nubugura kulukurman. Se nukum kitira mu Joseph ko nuam Rachel ilak taiman nubugura kulukurman. ");
INSERT INTO wsk_vpl VALUES ("GN33_8","002_33_8","GEN","33","8","8","Se Esau aking isam, “Se ani sipsip se goat se mel motam bibiya wore lage te nungarki se tairem mu ni awuk bitarko?” Se Jacob mam, “Aga kari dom, melmasak mu kisisam mu, ko amilmiler agi, mena agi, wore mu angamang motam bataga ka kasursam,” mam. ");
INSERT INTO wsk_vpl VALUES ("GN33_9","002_33_9","GEN","33","9","9","Bare Esau balam, “Aga uria, ani betela aga melmasak suen biya se terong. Sumu nika, ilupko.” ");
INSERT INTO wsk_vpl VALUES ("GN33_10","002_33_10","GEN","33","10","10","Bare Jacob nu maonam, “Mena. Ni ani ago ko amilmilasam agi mu, aninga agiting imi toko. Aitak nika gemang motam ningo te gemang aisem, se ani nika kema motam arigisam, mu ani Kaem koma motam ningi loaga kam ikisam. ");
INSERT INTO wsk_vpl VALUES ("GN33_11","002_33_11","GEN","33","11","11","Se ni aninga munan kisem mu giko. Kaem munan ningo beteram ale mel suen biya ani aisam, se aitak ani aga mel terong ma la.” Jacob uwuta balam, ale noko munan Esau tuokko mu ko sail tagiram, se Esau gomang tuam ale giam. ");
INSERT INTO wsk_vpl VALUES ("GN33_12","002_33_12","GEN","33","12","12","Ale mam, “Namanakko. Ani nengerak bolala la namanakko,” mam. ");
INSERT INTO wsk_vpl VALUES ("GN33_13","002_33_13","GEN","33","13","13","Bare Jacob nu maonam, “Aga kari dom, ni ikisam, kuriang nosokel mena. Se betela ani sipsip bulmakau nunga kuriang ago, wore nunga ikia aga moso tala. Ani tom suanta ko arungu aolak iluwekko nunga diruwurek, mu nuna kuemonko. ");
INSERT INTO wsk_vpl VALUES ("GN33_14","002_33_14","GEN","33","14","14","Aga dom, ni gir nama se bager, se ani udagi te kewom karikko. Ani bulmakau sipsip nunga aolak ko sokel ko iki se, aking kuriang nunga aolak mu ko iki se, kewom karik tai Seir karkikko.” ");
INSERT INTO wsk_vpl VALUES ("GN33_15","002_33_15","GEN","33","15","15","Se Esau balam, “Buta mu aninga kari sang awu kisek, se lage ka kasurmon kerak taimonko,” mam. Bare Jacob balam, “Aga kari dom, mena. Ni ani ago ko ningo beterem terong mam.” ");
INSERT INTO wsk_vpl VALUES ("GN33_16","002_33_16","GEN","33","16","16","Se Esau peleram ko sor te Seir namakaso. ");
INSERT INTO wsk_vpl VALUES ("GN33_17","002_33_17","GEN","33","17","17","Bare Jacob mu dalelaram Succoth namaram, ale umu te kuwim tam, ale bulmakau sipsip nunga sasal kalo kalo karogo namaram. Se sor mu nup beteman Succoth maman. ");
INSERT INTO wsk_vpl VALUES ("GN33_18","002_33_18","GEN","33","18","18","Jacob Paddan Aram beteram ale peleram tairam mu nu yawarakala tai Canaan sor te wonong Shechem mu te aratam. Ale ko kuwim Shechem wonong ko duap te nungam. ");
INSERT INTO wsk_vpl VALUES ("GN33_19","002_33_19","GEN","33","19","19","Nu ali mu manga silver 100 te Hamor ko namarari nongote diaram ale te daigam. Shechem mu Hamor ko namar bo. ");
INSERT INTO wsk_vpl VALUES ("GN33_20","002_33_20","GEN","33","20","20","Ale sor mu te altar bo kaolam ale nup beteram El Elohe Israel mam. ");
INSERT INTO wsk_vpl VALUES ("GN34_1","002_34_1","GEN","34","1","1","Dinah mu Jacob Leah nunga nanawus. Se tom bo nu Canaan imet saki nungarkukko namaram. ");
INSERT INTO wsk_vpl VALUES ("GN34_2","002_34_2","GEN","34","2","2","Se Hamor, Hivi kari, mu sor mu ko kari supuling. Se ko namar Shechem Dinah arigam ale gomang barasam, se ko sail te namaram iluwam ale kager te iwita ilak aniram. ");
INSERT INTO wsk_vpl VALUES ("GN34_3","002_34_3","GEN","34","3","3","Nu Jacob ko nanawus Dinah ninguru gomang tuam, ale gomang kuluka ko den welang manarukaso. ");
INSERT INTO wsk_vpl VALUES ("GN34_4","002_34_4","GEN","34","4","4","Ale udagi te namaram ko nuet Hamor maonam, “Ba, imet owore aninga aiwus ko to aisuko,” mam. ");
INSERT INTO wsk_vpl VALUES ("GN34_5","002_34_5","GEN","34","5","5","Udagi te Jacob ko nanawus Dinah kumik te kilek memek dolara karogo beteman mu ikiam, bare am kutek mam, mu awuk, noko namarari bulmakau sipsip mel nunga bitarmonko namaman lagakasan, se taimonko am nunga kimi bitawakaso. ");
INSERT INTO wsk_vpl VALUES ("GN34_6","002_34_6","GEN","34","6","6","Se Shechem ko nuet Hamor Jacob ilak munakarukko namaram. ");
INSERT INTO wsk_vpl VALUES ("GN34_7","002_34_7","GEN","34","7","7","Bare Jacob ko namarari mu Dinah ko nirung mu maingkala ikiman, ale biririkaman, ale ura beteman tai tai arataman. Nuna ninguru tala nongomang magaram, mu awuk, Shechem kilek memek bo dolara karogo wore Israel nunga ningi beteram. Nu kiwem bo uwuta me bitirukko, wore Jacob ko nanawus kumik te beteram ale ilak aniram. ");
INSERT INTO wsk_vpl VALUES ("GN34_8","002_34_8","GEN","34","8","8","Bare Hamor nunga maonam, “Aninga kuriang Shechem nika nanawus gomang ninguru tuam ale balam. Se balu se noko imet ko am taukko. ");
INSERT INTO wsk_vpl VALUES ("GN34_9","002_34_9","GEN","34","9","9","Nanimi karogo nanak ginakko. Nenenga nanawusari ana nangaral, se anananga nanawusari ningarnakko. ");
INSERT INTO wsk_vpl VALUES ("GN34_10","002_34_10","GEN","34","10","10","Asele nina ana nangarak nanga sor imi te am bagaralko. Se nenenga nengemang kuwim aguwaya te bagaralko kueral, mu am te bagaralko. Ale diara guruga ko ura am beteralko, ali sang dia talko mu am dia talko.” ");
INSERT INTO wsk_vpl VALUES ("GN34_11","002_34_11","GEN","34","11","11","Se Shechem Dinah ko nuet se ko korasari iwita nunga maonam, “Nina Dinah aisalko iwita ikial, mu nina anapeya ko kueral balal, mu ani am ningarikko. ");
INSERT INTO wsk_vpl VALUES ("GN34_12","002_34_12","GEN","34","12","12","Imet diara ko manga tom aisal, ale anapeya karogo ko, mu am balalko. Ani am dia saparikko. Bare mel biya mu kuriang itiwik sumu aninga aiwus ko aisalko.” ");
INSERT INTO wsk_vpl VALUES ("GN34_13","002_34_13","GEN","34","13","13","Se Jacob ko kuriang alo Shechem kilek memek nunga nogoras kumik te beteram wore ko nongomang magaram, se Shechem ko nuet Hamor ilak kula den nunga manorman. ");
INSERT INTO wsk_vpl VALUES ("GN34_14","002_34_14","GEN","34","14","14","Ale iwita balman, “Ana kari bo kumik guang me batogam mu nanga nagoras tunak se me ilak naukko. Ana buta betenak, mu ana dolara biya tanakko. ");
INSERT INTO wsk_vpl VALUES ("GN34_15","002_34_15","GEN","34","15","15","Bare nina kiwem suanta imi beteral mu, asele ana aing au manakko. Nina ninga kari suen la karogo ningimik guang batoga te nama saparalko. ");
INSERT INTO wsk_vpl VALUES ("GN34_16","002_34_16","GEN","34","16","16","Nina buta beteral, mu asele nina anananga imet gialko, se aking ana nenenga imet ginakko. Ale nengerak kariimet suan awunak ale baganakko. ");
INSERT INTO wsk_vpl VALUES ("GN34_17","002_34_17","GEN","34","17","17","Bare nina ningimik guang batoga ko munan me ko kueral, mu anananga nagoras tanak ale sor imi betenakko.” ");
INSERT INTO wsk_vpl VALUES ("GN34_18","002_34_18","GEN","34","18","18","Se Hamor ko namar Shechem ilak den mu ikiman ale ko amilmilaman. ");
INSERT INTO wsk_vpl VALUES ("GN34_19","002_34_19","GEN","34","19","19","Shechem tairate den mu karo tuam, mu awuk, nu Jacob ko nanawus ko ninguru kuakaso. Shechem mu ko launuria ningi nu kota gira. ");
INSERT INTO wsk_vpl VALUES ("GN34_20","002_34_20","GEN","34","20","20","Se Hamor ko namar Shechem ilak biguwura kuwim wonong ko songkuring ago mu te namaman, ale den mu nunga wonong suan nunga manarukasan. ");
INSERT INTO wsk_vpl VALUES ("GN34_21","002_34_21","GEN","34","21","21","Ale balman, “Kariari mu nangarak bagara suanta bagamonko balsan. Se anananga ali biya. Se ana balnak se nuna nanga ali te baga se dia gurugu nama tai se bagamonko. Ana nononga nanawusari nunga ginak, se nuna anananga nanawusari nunga gimonko. ");
INSERT INTO wsk_vpl VALUES ("GN34_22","002_34_22","GEN","34","22","22","Bare nuna balsan, anananga kari suen la nangimik guang batoga te nama sapanak ale nuna iwita aratanak, mu asele, nangarak bagara suanta bagamonko. ");
INSERT INTO wsk_vpl VALUES ("GN34_23","002_34_23","GEN","34","23","23","Ninguru ikialko. Ana buta betenak, mu nunga sipsip bulmakau se nunga mel suen biya mu anananga arukko. Se nunga ikia mu karo nungarnak se nangarak bagamonko.” ");
INSERT INTO wsk_vpl VALUES ("GN34_24","002_34_24","GEN","34","24","24","Se wonong mu ko kari suen la Hamor namar Shechem ilak nunga den ikiman ale ko amilmilaman, ale suen la nungumik guang batoga te namaman. ");
INSERT INTO wsk_vpl VALUES ("GN34_25","002_34_25","GEN","34","25","25","Day ilagala suan namaram, se kari lot ko yaman karogo bagaman, se Jacob ko namar ilagala, Simeon se Levi, mu Dinah ko korasari nunam duap suanta, nunga baenat mu giman, ale sor mu ko kari, bagara ngualara bagara ko, kari suen la nunga moman se kueman. ");
INSERT INTO wsk_vpl VALUES ("GN34_26","002_34_26","GEN","34","26","26","Nuna Hamor ko namar Shechem ilak karogotala nunga moman se kueman, se nunga nogoras Dinah Shechem ko kawam te bagaram mu taman ale ilak namaman. ");
INSERT INTO wsk_vpl VALUES ("GN34_27","002_34_27","GEN","34","27","27","Se Jacob ko kuriang sang udagi taiman, kari kueman mu nungarki se melmasak suen la giman ago namaman, mu awuk, nononga nogoras sor owore te ikup arigam. ");
INSERT INTO wsk_vpl VALUES ("GN34_28","002_34_28","GEN","34","28","28","Nuna sipsip se goat, bulmakau se donkey, se mel suen biya wonong te se ningam ningi mu gi sapaman. ");
INSERT INTO wsk_vpl VALUES ("GN34_29","002_34_29","GEN","34","29","29","Nuna nunga manga mel kawam te mu se, nunga imet kuriang suen la, mu nunga nogoras ko koma ko gi sapaman. ");
INSERT INTO wsk_vpl VALUES ("GN34_30","002_34_30","GEN","34","30","30","Bare Jacob ko kuriang Simeon Levi ilak nunga maonam, “Nina kilek memek mu beteman mu aninga aip maguwuman. Se aitak Canaan arika, Perez alo, se awiriya ali imi te, mu nuna ani ago ko nongomang magarukko. Ana kari suen biya mena. Se nunga kari suen la biguwumon ale ani agarak kagermon, mu nuna ana suen la nanga menawumonko.” ");
INSERT INTO wsk_vpl VALUES ("GN34_31","002_34_31","GEN","34","31","31","Bare nuna balman, “Se anananga nagoras lage luan imet iwita beteman mu terong e?” ");
INSERT INTO wsk_vpl VALUES ("GN35_1","002_35_1","GEN","35","1","1","Asele Kaem aking Jacob iwita maonam, “Bares ale nama tarigi Bethel mu te kuwim toko. Kuwim umu, tom ni ka laun Esau ko naguwerem se ani Kaem kete aratem, mu te altar bo kalo aisko.” ");
INSERT INTO wsk_vpl VALUES ("GN35_2","002_35_2","GEN","35","2","2","Se Jacob ko imet kuriang, se ko kariimet ilak bagara, mu suen la nunga maonam, “Nina sor iwareng nunga kaem kawel ago bagasan mu suen la nunga waru saparalko. Ale nengemang motam nungal, ale guang ningo la naguralko. ");
INSERT INTO wsk_vpl VALUES ("GN35_3","002_35_3","GEN","35","3","3","Asele tairal se ana Bethel nama tariginakko. Ani aninga Kaem, aninga ikup ningi agiring ikikaso ale sor suen la te agarak bagakaso, wore ko altar bo kalo tuekko,” mam. ");
INSERT INTO wsk_vpl VALUES ("GN35_4","002_35_4","GEN","35","4","4","Se nuna suen la nunga kaem kawel alo se nodogawa ko ring suen la karogo tai Jacob tuman, se nu Shechem wonong te tam oak duap ningi mutim tugumam. ");
INSERT INTO wsk_vpl VALUES ("GN35_5","002_35_5","GEN","35","5","5","Se tom nuna aolak duap beteman mu Kaem nguangara duap bo wonong wonong pingi pingi nunga laturu bagara mu nungumik te beteram se kaparam, se bo nongorak kagerarukko me terong. ");
INSERT INTO wsk_vpl VALUES ("GN35_6","002_35_6","GEN","35","6","6","Jacob ko kariimet ago Luz wonong te nama arataman. Luz mu ko nup bo Bethel, wonong mu Canaan sor te aniso. ");
INSERT INTO wsk_vpl VALUES ("GN35_7","002_35_7","GEN","35","7","7","Asele Jacob altar bo kaolam, ale kuwim mu nup beteram El-Bethel mam, mu awuk, nu oworete ko laun Esau ko naguwaram se Kaem kote aratam. ");
INSERT INTO wsk_vpl VALUES ("GN35_8","002_35_8","GEN","35","8","8","Se Deborah, Rebekah ko bitua imet aora, mu umu te kueram, se tam oak Bethel ko lete mu te duap ningi mutim tuguman. Ale tam nup beteman Allon Bakuth maman. ");
INSERT INTO wsk_vpl VALUES ("GN35_9","002_35_9","GEN","35","9","9","Tom Jacob Paddan Aram beteram ale peleram taiwaram, mu sor Bethel oworta te Kaem akingtala kote aratam ale marak tuam. ");
INSERT INTO wsk_vpl VALUES ("GN35_10","002_35_10","GEN","35","10","10","Ale maonam, “Nika nip Jacob i,” mam. “Bare udagi ni Jacob ko me ka arumonko. Aitak nika nip Israel.” ");
INSERT INTO wsk_vpl VALUES ("GN35_11","002_35_11","GEN","35","11","11","Aking Kaem maonam, “Ani Kaem Sokel Garagar. Nika tagu te kuriang gue suen biya aratamon ale sor magamonko. Ni te kariimet motam biya bo aratuk, ale kariimet motam biya mu te asele kariimet motam suen biya bare ilu biguwura suanta aratamonko. Ale nika gue te king arika aratu namamonko. ");
INSERT INTO wsk_vpl VALUES ("GN35_12","002_35_12","GEN","35","12","12","Ani ali Abraham Isaac nungarem mu aking ni kisek, ale ka taleng girigir ni biring ko taiwasan mu nungarikko.” ");
INSERT INTO wsk_vpl VALUES ("GN35_13","002_35_13","GEN","35","13","13","Kaem buta maonam ale beteram ale namaram. ");
INSERT INTO wsk_vpl VALUES ("GN35_14","002_35_14","GEN","35","14","14","Se Jacob kuwim Kaem ilak te munakaram mu te manga biling bo patawu baongam, ale waen se olive oil mu awote waram. ");
INSERT INTO wsk_vpl VALUES ("GN35_15","002_35_15","GEN","35","15","15","Ale sor mu nup beteram Bethel mam. ");
INSERT INTO wsk_vpl VALUES ("GN35_16","002_35_16","GEN","35","16","16","Nuna Bethel beteman ale aolak iluman namakasan. Se tom mu Rachel tuagu ago. Se nuna nama Ephrath ko pingi aratu se Rachel kuriang taukko tom iram, bare kuriang taukko ikup biya. ");
INSERT INTO wsk_vpl VALUES ("GN35_17","002_35_17","GEN","35","17","17","Nu yaman ikup biya ningi kuriang tam. Se ko saonga imet mu iwita maonam, “Ni me nguangerko,” mam. “Nika kuriang mu kari,” mam. ");
INSERT INTO wsk_vpl VALUES ("GN35_18","002_35_18","GEN","35","18","18","Se Rachel ikup yaman mu ningi kuriang tam, ale kuerukko nega se, ko namar mu nup beteram Benoni ma se kueram. Bare nuet Jacob nup beteram Benjamin mam. ");
INSERT INTO wsk_vpl VALUES ("GN35_19","002_35_19","GEN","35","19","19","Se Rachel uwutata kueram, se nuna lage luan te, lage Ephrath namara mu te, mutim tuguman. Ephrath ko bala bo Bethlehem. ");
INSERT INTO wsk_vpl VALUES ("GN35_20","002_35_20","GEN","35","20","20","Se Jacob Rachel ko ali motam te manga biling bo bangaru beteram, se manga mu aitak am aniso. ");
INSERT INTO wsk_vpl VALUES ("GN35_21","002_35_21","GEN","35","21","21","Se Israel aolak iluwam nama Migdal Eder mu ko komasang te noko kuwim nungam. ");
INSERT INTO wsk_vpl VALUES ("GN35_22","002_35_22","GEN","35","22","22","Sor mu te baga se Reuben ko nuet Israel ko nuwus Bilhah ilak aniram se ko nuet den mu ikiam. Jacob ko namarari 12. ");
INSERT INTO wsk_vpl VALUES ("GN35_23","002_35_23","GEN","35","23","23","Se ko nuwus Leah tuagu te mu, nunga nunup Reuben, kari laun, asele Simeon, Levi, Judah, Issachar, se Zebulun butata. ");
INSERT INTO wsk_vpl VALUES ("GN35_24","002_35_24","GEN","35","24","24","Se ko nuwus Rachel tuagu te mu, nunga nunup Joseph se Benjamin. ");
INSERT INTO wsk_vpl VALUES ("GN35_25","002_35_25","GEN","35","25","25","Se Rachel ko ura imet Bilhah tuagu te mu Dan se Naphtali. ");
INSERT INTO wsk_vpl VALUES ("GN35_26","002_35_26","GEN","35","26","26","Se Leah ko ura imet Zilpah tuagu te mu Gad se Issachar. Tom Jacob Paddan Aram bagaram mu ko kuriang imitang bilangaman. ");
INSERT INTO wsk_vpl VALUES ("GN35_27","002_35_27","GEN","35","27","27","Jacob ko nuet Isaac kote Mamre, Kiriath Arba (Hebron) duap te, sor Abraham Isaac te bagaman mu te tairam bagakaso. ");
INSERT INTO wsk_vpl VALUES ("GN35_28","002_35_28","GEN","35","28","28","Isaac ko bagara tom ilu biguwu sapara mu l80 yia. ");
INSERT INTO wsk_vpl VALUES ("GN35_29","002_35_29","GEN","35","29","29","Nu garukaram nunguningkiri, noko yia suen biya, asele kueram. Nu ko nuet nongotak nogowom karo namaram. Se ko namar ilagala, Esau Jacob ilak, mutim tuguman. ");
INSERT INTO wsk_vpl VALUES ("GN36_1","002_36_1","GEN","36","1","1","Imi Esau ko kuriang numasari. Esau ko nup bo Edom. ");
INSERT INTO wsk_vpl VALUES ("GN36_2","002_36_2","GEN","36","2","2","Esau Canaan imet ilagala suan nunga giam: bo Adah, Heth kari Elon ko nanawus. Bo Oholibamah, nu Anah ko nanawus se Hivi kari Zibeon ko numas. ");
INSERT INTO wsk_vpl VALUES ("GN36_3","002_36_3","GEN","36","3","3","Se bo Basemath, nu Ishmael ko nanawus, se Nebaioth ko koras. ");
INSERT INTO wsk_vpl VALUES ("GN36_4","002_36_4","GEN","36","4","4","Adah Esau ko kuriang Eliphaz iluwam. Se Basemath Esau ko kuriang Reuel iluwam. ");
INSERT INTO wsk_vpl VALUES ("GN36_5","002_36_5","GEN","36","5","5","Se Oholibamah Esau ko kuriang Jeush se Jalam se Korah nunga iluwam. Esau Canaan bagaram se ko namarari mu bilangaman. ");
INSERT INTO wsk_vpl VALUES ("GN36_6","002_36_6","GEN","36","6","7","Esau Jacob ilak wete Canaan sor te bagaman. Bare nononga sipsip bulmakau mel suen biya nunguningkiri, se kuwim umu kirikirikaram, nuna ilagala te bagamonko me terong. Buta se Esau barasam, ko nuwusari, ko namarari, ko nanawusari, se ko kariimet, se ko bulmakau sipsip mel, se mel suen la nu Canaan sor te giam mu ago ko uria Jacob beteram, ");
INSERT INTO wsk_vpl VALUES ("GN36_8","002_36_8","GEN","36","8","8","ale sor bo duruk ago, ko nup Seir, mu te nama daigam. ");
INSERT INTO wsk_vpl VALUES ("GN36_9","002_36_9","GEN","36","9","9","Imi Esau ko gue te ko kariimet, nunga balsan Edom alo masan. Nuna sor duruk ago Seir mu te bagasan. ");
INSERT INTO wsk_vpl VALUES ("GN36_10","002_36_10","GEN","36","10","10","Imi Esau ko namarari nunga nunup. Esau ko imet Adah tuagu te Eliphaz bilangaram. Se Esau ko imet Basemath tuagu te Reuel bilangaram. ");
INSERT INTO wsk_vpl VALUES ("GN36_11","002_36_11","GEN","36","11","11","Se Eliphaz tuagu te mu Teman, Omar, Zepho, Gatam se Kenaz bilangaman. ");
INSERT INTO wsk_vpl VALUES ("GN36_12","002_36_12","GEN","36","12","12","Se Eliphaz ko ura imet Timna ilak bagaram se ko namar Amalek ilu tuam. Kuriang imas imi mu Esau nuwus Adah tuagu te kapaman. ");
INSERT INTO wsk_vpl VALUES ("GN36_13","002_36_13","GEN","36","13","13","Se Reuel tuagu te mu Nahath, Zerah, Shammah, se Mizzah. Kuriang imas imi mu Esau nuwus Basemath tuagu te kapaman. ");
INSERT INTO wsk_vpl VALUES ("GN36_14","002_36_14","GEN","36","14","14","Esau ko imet Oholibamah tuagu te mu Jeush, Jalam, se Korah bilangaman. Oholibamah mu Anah ko nanawus se Zibeon ko numas. ");
INSERT INTO wsk_vpl VALUES ("GN36_15","002_36_15","GEN","36","15","15","Esau ko kuriang gue te digo supuling alo koma koma mu nunga nunup mu iwita: Esau ko kuriang laun Eliphaz tuagu te mu Teman, Omar, Zepho, Kenaz, ");
INSERT INTO wsk_vpl VALUES ("GN36_16","002_36_16","GEN","36","16","16","Korah, Gatam, se Amalek. Nuna Edom sor te Eliphaz tuagu te ko digo supuling alo, se Esau Adah ilak nunga nunumasari. ");
INSERT INTO wsk_vpl VALUES ("GN36_17","002_36_17","GEN","36","17","17","Esau ko kuriang Reuel tuagu te mu Nahath, Zerah, Shammah, se Mizzah. Nuna Edom sor te Reuel tuagu te ko digo supuling alo, se Esau Basemath ilak nunga nunumasari. ");
INSERT INTO wsk_vpl VALUES ("GN36_18","002_36_18","GEN","36","18","18","Esau nuwus Oholibamah ko tuagu te mu Jeush, Jalam, se Korah. Nuna Esau Oholibamah ilak nutagu te ko digo supuling alo. Oholibamah mu Anah ko nanawus. ");
INSERT INTO wsk_vpl VALUES ("GN36_19","002_36_19","GEN","36","19","19","Imi Edom kariimet Esau ko gue te arataman wore nunga digo supuling nunup. ");
INSERT INTO wsk_vpl VALUES ("GN36_20","002_36_20","GEN","36","20","20","Imi kariimet gue bo kigilik agotala Edom bagakasan, nunga balsan Hor kariimet masan. Nuna Hor kari Seir tuagu te ko kariimet. Imi Hor kari Seir ko kuriang nunga nunup: Lotan, Shobal, Zibeon, Anah, ");
INSERT INTO wsk_vpl VALUES ("GN36_21","002_36_21","GEN","36","21","21","Dishon, Ezer, se Dishan. Nuna suen la mu nunga kariimet nunga digo supuling bagakasan. ");
INSERT INTO wsk_vpl VALUES ("GN36_22","002_36_22","GEN","36","22","22","Lotan ko namarari mu Hori se Homam. Timna mu Lotan ko koras. ");
INSERT INTO wsk_vpl VALUES ("GN36_23","002_36_23","GEN","36","23","23","Shobal ko namarari mu Alvan, Manahath, Ebal, Shepho, se Onam. ");
INSERT INTO wsk_vpl VALUES ("GN36_24","002_36_24","GEN","36","24","24","Zibeon ko namarari mu Aiah, se Anah. Anah ewerta sor garagarayam mu te nuet Zibeon ko donkey nunga bitaruwa, yu kowar bulowolok mawaram mu nu giram arigam. ");
INSERT INTO wsk_vpl VALUES ("GN36_25","002_36_25","GEN","36","25","25","Anah ko kuriang ilagala, namar mu Dishon, se nanawus mu Oholibamah, Esau ko nuwus. ");
INSERT INTO wsk_vpl VALUES ("GN36_26","002_36_26","GEN","36","26","26","Dishon ko namarari mu Hemdan, Eshban, Ithran, se Keran. ");
INSERT INTO wsk_vpl VALUES ("GN36_27","002_36_27","GEN","36","27","27","Ezer ko namarari mu Bilhan, Zaavan, se Akan. ");
INSERT INTO wsk_vpl VALUES ("GN36_28","002_36_28","GEN","36","28","28","Dishan ko namarari mu Uz, se Aran. ");
INSERT INTO wsk_vpl VALUES ("GN36_29","002_36_29","GEN","36","29","29","Nuna suen la mu Hor kariimet nunga digo supuling bagakasan. Nunga nunup iwita: Lotan, Shobal, Zibeon, Anah, ");
INSERT INTO wsk_vpl VALUES ("GN36_30","002_36_30","GEN","36","30","30","Dishon, Ezer, se Dishan. Nuna nonet Seir ko ali te Edom sor te bagakasan. ");
INSERT INTO wsk_vpl VALUES ("GN36_31","002_36_31","GEN","36","31","31","Israel alo nungumik king mena ko tom te, king imi Edom sor bitarukasan: ");
INSERT INTO wsk_vpl VALUES ("GN36_32","002_36_32","GEN","36","32","32","Motam motam Beor namar Bela Edom ko king ko aratam. Noko wonong nup Dinhabah. ");
INSERT INTO wsk_vpl VALUES ("GN36_33","002_36_33","GEN","36","33","33","Tom Bela kueram mu Zerah namar Jobab, Bozrah kari, mu kuwim tam. ");
INSERT INTO wsk_vpl VALUES ("GN36_34","002_36_34","GEN","36","34","34","Tom Jobab kueram mu Teman kari Husham kuwim tam. ");
INSERT INTO wsk_vpl VALUES ("GN36_35","002_36_35","GEN","36","35","35","Tom Husham kueram mu Bedad namar Hadad kuwim tam. Nu sor Moab te Midian alo nunga menawuram. Noko wonong nup Avith. ");
INSERT INTO wsk_vpl VALUES ("GN36_36","002_36_36","GEN","36","36","36","Tom Hadad kueram mu Masrekah kari Samlah kuwim tam. ");
INSERT INTO wsk_vpl VALUES ("GN36_37","002_36_37","GEN","36","37","37","Tom Samlah kueram mu Rehoboth wonong yu Euphrates duap te ko kari Shaul kuwim tam. ");
INSERT INTO wsk_vpl VALUES ("GN36_38","002_36_38","GEN","36","38","38","Tom Shaul kueram mu Acbor namar Baal-Hanan kuwim tam. ");
INSERT INTO wsk_vpl VALUES ("GN36_39","002_36_39","GEN","36","39","39","Tom Acbor namar Baal-Hanan kueram mu Hadad kuwim tam. Noko wonong nup Pau. Noko nuwus nup mu Mehetabel, nu Matred ko nanawus se Me-Zahab ko numas. ");
INSERT INTO wsk_vpl VALUES ("GN36_40","002_36_40","GEN","36","40","40","Imi Esau ko gue te ko digo supuling nunga nunup: Timna, Alvah, Jetheth, ");
INSERT INTO wsk_vpl VALUES ("GN36_41","002_36_41","GEN","36","41","41","Oholibamah, Elah, Pinon, ");
INSERT INTO wsk_vpl VALUES ("GN36_42","002_36_42","GEN","36","42","42","Kenaz, Teman, Mibzar, ");
INSERT INTO wsk_vpl VALUES ("GN36_43","002_36_43","GEN","36","43","43","Magdiel, se Iram. Nuna Esau ko kariimet Edom koma koma dagi dagi namaman wore nunga digo supuling. Esau nu Edom kariimet nunga usir. ");
INSERT INTO wsk_vpl VALUES ("GN37_1","002_37_1","GEN","37","1","1","Jacob Canaan ali te, kuwim nuet te ulengkala bagaram mu te bagakaso. ");
INSERT INTO wsk_vpl VALUES ("GN37_2","002_37_2","GEN","37","2","2","Se imi Jacob ko kuriang arungu nunga dugu duap. Joseph kuriang kulak gotek bagakaso, ko yia tom 17. Nu ko nuet Jacob ko imet Zilpah se Bilhah nutagu te noko launari umu arungu sipsip se goat nunga bitarukasan. Bare ko launari kilek memek bitakasan, se nu ari laga tom bo nuet maonam. ");
INSERT INTO wsk_vpl VALUES ("GN37_3","002_37_3","GEN","37","3","3","Israel (Jacob) ko namarari suen la nunga kuakaso, bare Joseph mu ninguru ko kuakaso, mu awuk, nu garuk ningi bagaram se Joseph bilangaram. Se nu guang bo balayam biriram ale Joseph tuam. ");
INSERT INTO wsk_vpl VALUES ("GN37_4","002_37_4","GEN","37","4","4","Se ko launari nonet Jacob ko kiwem umu arigiman ale Joseph ko nongomang magakaso, se nongomang lila te me ilak munakakasan. ");
INSERT INTO wsk_vpl VALUES ("GN37_5","002_37_5","GEN","37","5","5","Tom bo Joseph ipingiram, ale ko ipingira mu ko launari nomokete balam. Se nuna ikiman ale nongomang eng am ninguru tala maga kaparam. ");
INSERT INTO wsk_vpl VALUES ("GN37_6","002_37_6","GEN","37","6","6","Nu iwita balam, “Aninga ipingira ewere balik se ikialko. ");
INSERT INTO wsk_vpl VALUES ("GN37_7","002_37_7","GEN","37","7","7","Ana suen la ningam te wheat ilu biguwu se sikipiwaman se, ikialko, aninga wheat siping mu barasu diram sanamaram, se nenenga mu aninga mu ko tara bowa naguman.” ");
INSERT INTO wsk_vpl VALUES ("GN37_8","002_37_8","GEN","37","8","8","Se ko launari nongomang memek te manorman, “Awuk? Ni anananga pulawura baga se nanga bitaruko e?” maman, ale ipingira mu ko, Joseph ko nongomang magara eng magara biya magakaso. ");
INSERT INTO wsk_vpl VALUES ("GN37_9","002_37_9","GEN","37","9","9","Se Joseph akingtala ipingiram ale ko ipingira mu ko launari nunga maonam, “Ikialko. Ani aking ipingira bo tala arigem, mu worem se sige se baras 11 mu ani amake dugu te nubugura kulukuru aisiman.” ");
INSERT INTO wsk_vpl VALUES ("GN37_10","002_37_10","GEN","37","10","10","Ale ko ipingira mu ko nuet agotala maonam, se ikiam ale ining tuam, “Sowore anape ipingira ya?” mam. “Awuk, ani se ka niam, se ka launari suen la tainak ale nabugura kulukuru kisinakko e?” ");
INSERT INTO wsk_vpl VALUES ("GN37_11","002_37_11","GEN","37","11","11","Se ko launari mu Joseph ko ninguru nongomang magaram. Bare ko nuet mu ipingira mu am ko iki guruguwakaso. ");
INSERT INTO wsk_vpl VALUES ("GN37_12","002_37_12","GEN","37","12","12","Tom bo Joseph ko launari Shechem wonong duap te nunga nonet ko goat se sipsip nunga bitaruwakasan, ");
INSERT INTO wsk_vpl VALUES ("GN37_13","002_37_13","GEN","37","13","13","se Israel Joseph maonam, “Ni ko ikisam, nika launari mu Shechem wonong duap te goat se sipsip nunga bitaruwasan. Se aninga angamang mu ni nama nungarkiko.” Se Joseph balam, “Mu ani namarikko,” mam. ");
INSERT INTO wsk_vpl VALUES ("GN37_14","002_37_14","GEN","37","14","14","Se nuet balam, “Ka launari se sipsip se goat terong bagasan agi wore nama nungarki ale tai aga manaruko.” Tom mu te Israel Hebron ko sor wolong mu te baga se Joseph Shechem namarukko maonam. Se Joseph nama Shechem aratam, ");
INSERT INTO wsk_vpl VALUES ("GN37_15","002_37_15","GEN","37","15","15","ale ko launari nunga kupu kupu geragawaram se kari bo nu arigam ale isuam, “Ni anape kupusam a?” mam. ");
INSERT INTO wsk_vpl VALUES ("GN37_16","002_37_16","GEN","37","16","16","Se Joseph mam, “Aninga launari nunga loaga guruguwasam. Nuna koma te sipsip se goat nunga bitaruwasan mu ni ko ikisam agi mu, aga manaruko.” ");
INSERT INTO wsk_vpl VALUES ("GN37_17","002_37_17","GEN","37","17","17","Se kari mu balam, “Nuna sor imi maingkala beteman. Ale Dothan namamonko balman se ani ikiem,” mam. Se Joseph barasam ale nogowom kaoram nama Dothan wonong duap te nungarkam. ");
INSERT INTO wsk_vpl VALUES ("GN37_18","002_37_18","GEN","37","18","18","Bare ko launari awar la nu arigiman, ale me tai aratukaso la, nuna momon se kuerukko nunumi manorman. ");
INSERT INTO wsk_vpl VALUES ("GN37_19","002_37_19","GEN","37","19","19","Ale balman, “Ipingira kari o taiwosowo!” maman. ");
INSERT INTO wsk_vpl VALUES ("GN37_20","002_37_20","GEN","37","20","20","“Tairuk se monak se kueruk se mutim imi bo ningi sapanakko. Ale namanak balnak ‘mel diwang bo moram se kueram’ manakko. Ale ko ipingira ko nunguning kapa tuok agi mu ariginakko!” ");
INSERT INTO wsk_vpl VALUES ("GN37_21","002_37_21","GEN","37","21","21","Bare Reuben den umu ikiam mu nu nuguting te Joseph bataguru taukko, se balam, “Ana me monak se kuerukko! ");
INSERT INTO wsk_vpl VALUES ("GN37_22","002_37_22","GEN","37","22","22","Kariimet gue nagiting me magarukko. Sor garagarayam imi ko mutim imi bo ningi saparalko, bare kumik me kau talko!” mam. Reuben nu Joseph sanguk ale ilak nama nonet kote bitirukko iki se uwutata balukaso. ");
INSERT INTO wsk_vpl VALUES ("GN37_23","002_37_23","GEN","37","23","23","Se Joseph ko launari nongote tai aratam se iluman, ale ko guang balayam nung mu kutuwuman, ");
INSERT INTO wsk_vpl VALUES ("GN37_24","002_37_24","GEN","37","24","24","ale ilak nama mutim ningi sapaman. Mutim mu yu ko mutim iman, bare kumik yu mena, yu marakam. ");
INSERT INTO wsk_vpl VALUES ("GN37_25","002_37_25","GEN","37","25","25","Ale na namonko dagiman ale nomotam patawu mu Ishmael gue ko kari alo, koma Gilead namara umu te taiwaman se nungarkaman. Se nunga camel mu melmasak siring yawara yawara, tam ko yu liliki te nunga, mu giman ale ilu arigimonko karogo Egypt namakasan. ");
INSERT INTO wsk_vpl VALUES ("GN37_26","002_37_26","GEN","37","26","26","Se Judah ko launuria iwita nunga maonam, “Ana nanga uria monak se kueruk se kaluwunak, mu anape mel ningo ningi tanakko? Mena. ");
INSERT INTO wsk_vpl VALUES ("GN37_27","002_37_27","GEN","37","27","27","Buta se am ngual Ishmael alo arungu ilu ariginak se diamon se koma tanakko. Ana me monak se kuerukko. Mu awuk, nu anananga uria, se anananga gue suan.” Se ko launuria den balam mu ko amilmilaman. ");
INSERT INTO wsk_vpl VALUES ("GN37_28","002_37_28","GEN","37","28","28","Se Ishmael ko gue te Midian kari alo tai arataman se nuna Joseph mutim ningi bagaram mu patawuman se bausam, se Ishmael ko kari alo manga biling silver 20 ko te nongorak Joseph diaman ale ilak Egypt namaman. ");
INSERT INTO wsk_vpl VALUES ("GN37_29","002_37_29","GEN","37","29","29","Reuben udagi te tairam ale mutim ningi loagaram, bare Joseph me bagaram. Se nu kota ko guang iluwam barukam. ");
INSERT INTO wsk_vpl VALUES ("GN37_30","002_37_30","GEN","37","30","30","Ale ko uriamitak nongote peleram ale balam, “Kuriang umu mutim ningi me bagoso! Se ani awuk maikko?” ");
INSERT INTO wsk_vpl VALUES ("GN37_31","002_37_31","GEN","37","31","31","Se Joseph ko launari goat bo moman ale ko gue Joseph ko guang te iluman. ");
INSERT INTO wsk_vpl VALUES ("GN37_32","002_37_32","GEN","37","32","32","Ale giman ago nunga nonet kote namaman ale manorman, “Ana guang imi arigiman. Gurugu patawu ale arikko. Nika namar ko agi mena agi wore ko arikko.” ");
INSERT INTO wsk_vpl VALUES ("GN37_33","002_37_33","GEN","37","33","33","Se nu arigam ale balam, “Mu borta, aninga namar ko guang!” mam. “Mel diwang bo moa nam. Nunguningta,” mam, “Joseph batuwutuk mam katir katir kaparam.” ");
INSERT INTO wsk_vpl VALUES ("GN37_34","002_37_34","GEN","37","34","34","Ale Jacob guang kumik te mu barukam, ale guang wuli karogo memek umu numi te iram. Ale ko namar ko, tom maiya biya mo nia lagakaso. ");
INSERT INTO wsk_vpl VALUES ("GN37_35","002_37_35","GEN","37","35","35","Ko namarari se ko nanawusari gomang tamonko taikasan, bare nu miakaso. Ale balukaso, “Mena,” makaso. “Ani iwitata mo nia laga, aga namar kowom karo namarikko,” mam. Ko nuet uwutata mo lagakaso. ");
INSERT INTO wsk_vpl VALUES ("GN37_36","002_37_36","GEN","37","36","36","Bare Joseph mu, Midian alo ilak nama Egypt, Potiphar ilak diaman. Potiphar mu Pharaoh ko kawam bitua kari nunga kari gira, se Pharaoh ko kari supuling bo. ");
INSERT INTO wsk_vpl VALUES ("GN38_1","002_38_1","GEN","38","1","1","Tom mu te Judah ko launuria nunga beteram ale Adullam wonong te nama kaparam ale kari Hirah ilak bagakaso. ");
INSERT INTO wsk_vpl VALUES ("GN38_2","002_38_2","GEN","38","2","2","Nu umu te Canaan kari Shua ko nanawus arigam ale gomang tuam ale ko nuwus ko tam. Ale ilak bagaram, ");
INSERT INTO wsk_vpl VALUES ("GN38_3","002_38_3","GEN","38","3","3","se imet mu tuagu aratam se kuriang kari ko nup Er ilu tuam. ");
INSERT INTO wsk_vpl VALUES ("GN38_4","002_38_4","GEN","38","4","4","Imet mu akingtala tuagu aratam se kuriang kari iluwam ale nup beteram Onan mam. ");
INSERT INTO wsk_vpl VALUES ("GN38_5","002_38_5","GEN","38","5","5","Aking udagi kuriang kari tala iluwam, ale nup beteram Shelah mam. Judah Kezib wonong te bagaram se ko kuriang Shelah bilangaram. ");
INSERT INTO wsk_vpl VALUES ("GN38_6","002_38_6","GEN","38","6","6","Se udagi Judah ko namar biya Er ko imet bo to tuam, ko nup Tamar. ");
INSERT INTO wsk_vpl VALUES ("GN38_7","002_38_7","GEN","38","7","7","Bare Er, Judah ko namar biya, mu Yawe motam te ko kilek memek biya, se Yawe balam se nu kueram. ");
INSERT INTO wsk_vpl VALUES ("GN38_8","002_38_8","GEN","38","8","8","Se aking Judah Onan maonam, “Ka laun kueram, bare kumik kuriang mena. Se ni anananga munan karo ale nama ka laun ko nuwus ilak anirko. Se kuriang aratamon, mu ka laun ko nup gimonko.” ");
INSERT INTO wsk_vpl VALUES ("GN38_9","002_38_9","GEN","38","9","9","Bare Onan ikiam kuriang aratamon mu noko nup bowa ningi me bagamonko. Se tom nu imet ilak anikaso, mu noko kumik yu imet mu ko kumik ningi me warukaso, watingi warukaso. Nu uwuta bitakaso mu noko gomang kuriang bo laun nup te me aratukko. ");
INSERT INTO wsk_vpl VALUES ("GN38_10","002_38_10","GEN","38","10","10","Bare Onan munan bitakaso mu Yawe motam te me terong, se balam se Onan betela kueram. ");
INSERT INTO wsk_vpl VALUES ("GN38_11","002_38_11","GEN","38","11","11","Udagi Judah ko noton Tamar iwita maonam, “Ka kari kueram. Buta se ni piler namar ka niet ko kawam te bagerko. Se aga kuriang Shelah lagaruk asele ni ilak noko.” Judah uwuta balam, mu nu nguangakaso, Shelah ko laun ilagala kueman wore turantala kueruk bore ko. Se Tamar peleram ko nuet kote namaram. ");
INSERT INTO wsk_vpl VALUES ("GN38_12","002_38_12","GEN","38","12","12","Se kam maiya nuam namaram se Judah nuwus, Shua nanawus, mu kueram. Se Judah noman bataga te karur karogo laga, guram numi nungam, ale ko bo Hirah, Adullam kari, umu ilak barasaman ale Timnah wonong te nama tarigiman. Nu ko ura kari sipsip mone bataguru se animan wore nungarkamonko namaman. ");
INSERT INTO wsk_vpl VALUES ("GN38_13","002_38_13","GEN","38","13","13","Se Tamar, ko tonger mu sipsip mone batagukko Timnah nama tarigiwoso mu ko den ikiam, ");
INSERT INTO wsk_vpl VALUES ("GN38_14","002_38_14","GEN","38","14","14","ale nu imet gera ko guang kumik te aniram mu kutuwuram, ale guang sang kigilik giam naguram. Ale guang bo supuling koma motam te iram, ale namaram Enaim wonong ko lage kuringi, lage Timnah namara mu te daigam bagakaso. Mu nu iwita ikikaso, Judah ko kuriang Shelah mu kari aram, bare nuna me nu tuikasan. ");
INSERT INTO wsk_vpl VALUES ("GN38_15","002_38_15","GEN","38","15","15","Se Judah Timnah nama se imet mu arigam, ale nu lage luan imet ko balam, mu awuk, nu noko koma kaluwuram. ");
INSERT INTO wsk_vpl VALUES ("GN38_16","002_38_16","GEN","38","16","16","Bare nu imet mu noko noton Tamar iwita me ko ikiam. Se nu kote namaram ale maonam, “Tairko. Ani ni kerak anirekko,” mam. Se imet mu isuam, “Ni ani agarak anir, mu anape aisuko?” ");
INSERT INTO wsk_vpl VALUES ("GN38_17","002_38_17","GEN","38","17","17","Se Judah balam, “Aninga goat gotek bo bitirik se kete tairukko,” mam. Se imet mu aking isuam, “Nika mel bo aisu se ilu sagarik se ni goat bitar se tairuk asele ani aking kisekko.” ");
INSERT INTO wsk_vpl VALUES ("GN38_18","002_38_18","GEN","38","18","18","Se Judah balam, “Ani anape mel kisek se ni ilu sagerko ya?” mam. Se imet mu mam, “Nika kiting dora te betera ko mel degetak te kekawoso mu se, ka sikir kiting te aniso sumu karogo aisuko,” mam. Se Judah uwutata beteram. Asele ilak aniram se tuagu aratam. ");
INSERT INTO wsk_vpl VALUES ("GN38_19","002_38_19","GEN","38","19","19","Se imet mu ko kawam te namaram ale guang mel numi te iram mu kututuwuram, ale imet gera ko guang mu aking naguram. ");
INSERT INTO wsk_vpl VALUES ("GN38_20","002_38_20","GEN","38","20","20","Udagi Judah goat gotek bo tam, ko bo Adullam kari mu tuam, ale maonam, “To ale ago nama imet aninga melmasak iluwoso mu tui ale aninga melmasak gi karogo tairko,” mam. Se namaram kupam, bare imet mu me arigam. ");
INSERT INTO wsk_vpl VALUES ("GN38_21","002_38_21","GEN","38","21","21","Ale nu Enaim kari sang nunga isuam, “Lage luan imet kuwim imi te bagoso mu apoko ya?” Se nuna balman, “Sor imi lage luan imet bo me te bagoso,” maman. ");
INSERT INTO wsk_vpl VALUES ("GN38_22","002_38_22","GEN","38","22","22","Se nu peleram namaram ale Judah maonam, “Ani namerem, bare imet mu me arigem. Se wonong mu ko kari balman, lage luan imet bo sor umu te me bagoso ma balman.” ");
INSERT INTO wsk_vpl VALUES ("GN38_23","002_38_23","GEN","38","23","23","Se Judah balam, “Aninga melmasak mu bo la anirukko. Ana aking pelenak ale ko loaganak mu kariimet nanga ikimon ale nago ko gusimon bore ko. Ni ikisam ani terong beterem. Ani goat gotek imi kote beterem se ni karogo namerem, bare nu me bagaram.” ");
INSERT INTO wsk_vpl VALUES ("GN38_24","002_38_24","GEN","38","24","24","Se sige ilagala suan iwita namaram se kari saki Judah manorman, “Nika neton Tamar lage luan imet ko numi gurugam, ale aitak tuagu ago bagoso.” Se Judah balam, “Iluwal ale tama te kaiyal se kuerukko!” mam. ");
INSERT INTO wsk_vpl VALUES ("GN38_25","002_38_25","GEN","38","25","25","Bare tom nuna namaman iluman mu Tamar iwita balam, “Namaral ale aga atenger maonalko, ‘Ani melmasak e iluwasam ewere ko kotam ani kuriang aisam. Nagiting dora te betera ko mel imi, ko mayang karogo, se sikir imi ninguru arigal, ale awiriya ko mu ko ikialko.’ ” ");
INSERT INTO wsk_vpl VALUES ("GN38_26","002_38_26","GEN","38","26","26","Se Judah melmasak mu arigam mu nu ko ikiam, ale balam, “Imet sumu kumik te den mena. Mu ani ikup ago. Nu aninga kuriang Shelah ilak naukko, bare ani agata uwuta me beterem.” Ale nu udagi imet mu ilak me anikaso. ");
INSERT INTO wsk_vpl VALUES ("GN38_27","002_38_27","GEN","38","27","27","Se Tamar kuriang iluwokko tom tairam se ko tuagu ningi mu kuriang kari singisik. ");
INSERT INTO wsk_vpl VALUES ("GN38_28","002_38_28","GEN","38","28","28","Se kuriang iluwokko tom kaparam mu kuriang bo giram kuting garukam se aratam. Se imet bitaruwaram mu tairate kuriang kuting garukuwaram mu mayang gotek diriyam mu te kaolam ale balam, “Kuriang imi giram aratam,” mam. ");
INSERT INTO wsk_vpl VALUES ("GN38_29","002_38_29","GEN","38","29","29","Bare kuriang umu aking kuting tagiram se peleram, se ko komasang mu giram aratam. Se bitua imet mu balam, “Ni ka sokel te girem aratasam e?” Se nup beteman Perez. ");
INSERT INTO wsk_vpl VALUES ("GN38_30","002_38_30","GEN","38","30","30","Se udagi te ko bo, kuting kopa mayang diriyam ago, mu aratam. Se ko nup beteman Zerah maman. ");
INSERT INTO wsk_vpl VALUES ("GN39_1","002_39_1","GEN","39","1","1","Joseph ilak Egypt namaman, se Potiphar Ishmael ko kari alo ilak namaman mu nongote dia tam. Potiphar mu Egypt kari, nu Pharaoh ko kawam bitua kari nunga kari gira, se Pharaoh ko kari supuling bo. ");
INSERT INTO wsk_vpl VALUES ("GN39_2","002_39_2","GEN","39","2","2","Yawe Joseph ilak bagakaso, se nu ko Egypt kari dom mu ilak baga se melmasak bitakaso mu ningo la aratu sapakaso. ");
INSERT INTO wsk_vpl VALUES ("GN39_3","002_39_3","GEN","39","3","3","Se Potiphar munan Yawe Joseph kote bitakaso mu arikaso, ");
INSERT INTO wsk_vpl VALUES ("GN39_4","002_39_4","GEN","39","4","4","ale nu Joseph ko amilmilakaso, ale noko kawam ningi melmasak suen la se ura suen la mu Joseph bituokko balam. ");
INSERT INTO wsk_vpl VALUES ("GN39_5","002_39_5","GEN","39","5","5","Tom mu te la Joseph kumik te se, Yawe Potiphar ko kawam ningi se watingi lilim la marak tuikaso se ningo la aratukaso. ");
INSERT INTO wsk_vpl VALUES ("GN39_6","002_39_6","GEN","39","6","6","Potiphar mel suen biya Joseph kuting te beteram ale bituokko balam. Ale nu kota ko mel bo me bitarukaso, nu ko na naukko mu la bitarukaso. Joseph kumik ago, se ko koma motam balayam. ");
INSERT INTO wsk_vpl VALUES ("GN39_7","002_39_7","GEN","39","7","7","Se tom me maiyam noko kari dom ko nuwus nu arigam ale motam barasam se maonam, “Tai agarak anirko,” mam. ");
INSERT INTO wsk_vpl VALUES ("GN39_8","002_39_8","GEN","39","8","8","Bare Joseph meram, ale maonam, “Aninga kari dom ko melmasak suen la kawam te mu buring tuam, ale aninga bitua bowa ningi beteram. ");
INSERT INTO wsk_vpl VALUES ("GN39_9","002_39_9","GEN","39","9","9","Kari bo noko kawam imi ningi aninga iwita me beteram. Noko kawam ningi noko mel bo ani ago ko me kaluwuso. Bare ni keta suanta, mu awuk, ni noko nuwus. Se ani awuk ta kiwem memek sumu Kaem motam te bitirikko?” ");
INSERT INTO wsk_vpl VALUES ("GN39_10","002_39_10","GEN","39","10","10","Bare imet mu tom suen biya Joseph ilak anirukko yam isaru lagakaso. Bare Joseph miakaso, ale kumik duap te bagarukko me kuakaso tala. ");
INSERT INTO wsk_vpl VALUES ("GN39_11","002_39_11","GEN","39","11","11","Bare tom bo Joseph kawam ningi ko ura bitirukko kasu naguram. Tom mu ura kariimet sang kawam te me bagaman. ");
INSERT INTO wsk_vpl VALUES ("GN39_12","002_39_12","GEN","39","12","12","Se Potiphar ko nuwus Joseph ko guang te iluwam ale maonam, “Tai agarak anirko,” mam. Bare Joseph numi tagi bataguru tam se ko guang la kutuwu tam, se Joseph naguram watingi aratam. ");
INSERT INTO wsk_vpl VALUES ("GN39_13","002_39_13","GEN","39","13","13","Se imet mu Joseph ko guang ilu se Joseph naguram mu arigam, ");
INSERT INTO wsk_vpl VALUES ("GN39_14","002_39_14","GEN","39","14","14","ale nu ko ura kariimet sang nunga auram se taiman, se nunga maonam, “Arigalko!” mam. “Hebrew kari imi anananga sangukko ilak taiman, bare nu ana dolara nangaram! Nu utu naguram ale ani agarak anirukko aga iluwam, bare ani sail te saonga ko airem, ");
INSERT INTO wsk_vpl VALUES ("GN39_15","002_39_15","GEN","39","15","15","se nu biririkaram ale ko guang saparam ale naguram watingi aratam!” ");
INSERT INTO wsk_vpl VALUES ("GN39_16","002_39_16","GEN","39","16","16","Imet mu Joseph ko guang am karogo bagaram se Joseph ko kari dom mu kawam te tairam. ");
INSERT INTO wsk_vpl VALUES ("GN39_17","002_39_17","GEN","39","17","17","Se nu den imi maonam, “Hebrew ura dungan kari ni diarem ale ilak tairem, mu aningate tairam ale dolara kiwem angimik te bitirukko karogo kaeram. ");
INSERT INTO wsk_vpl VALUES ("GN39_18","002_39_18","GEN","39","18","18","Bare tom ani saonga ko sail te airem, mu nu ko guang saparam ale naguram watingi aratam.” ");
INSERT INTO wsk_vpl VALUES ("GN39_19","002_39_19","GEN","39","19","19","Se Joseph ko kari dom ko nuwus kuring te den umu ikiam ale gomang ninguru tama ko kaniram. ");
INSERT INTO wsk_vpl VALUES ("GN39_20","002_39_20","GEN","39","20","20","Se balam se Joseph talipara kawam ningi sapaman, se Pharaoh ko talipara kari nongorak bagakaso. ");
INSERT INTO wsk_vpl VALUES ("GN39_21","002_39_21","GEN","39","21","21","Bare Yawe Joseph ilak baga se sangaruwakaso, owore te se, talipara kawam ko bitua kari gira mu Joseph ko ninguru amilmilakaso. ");
INSERT INTO wsk_vpl VALUES ("GN39_22","002_39_22","GEN","39","22","22","Ale balam se Joseph talipara kari nunga kari gira iwita baga se, anapeya mel betemonko mu ko girikaso. ");
INSERT INTO wsk_vpl VALUES ("GN39_23","002_39_23","GEN","39","23","23","Se bitua kari gira mu ura aguwaya Joseph kuting te beteram mu ko ikia me tokaso. Mu awuk, Yawe Joseph ilak baga se mel suen la te sangarukaso se ningo la aratukaso. ");
INSERT INTO wsk_vpl VALUES ("GN40_1","002_40_1","GEN","40","1","1","Tom bo Pharaoh ko waen bitua ko kari gira, se ko bread kaiya ko kari gira, kilek memek bo agi beteman se, ");
INSERT INTO wsk_vpl VALUES ("GN40_2","002_40_2","GEN","40","2","2","Pharaoh gomang magaram se ");
INSERT INTO wsk_vpl VALUES ("GN40_3","002_40_3","GEN","40","3","3","talipara ko galung ningi nunga awuram. Se talipara galung umu nunga bitua kari gira ko kawam te anikaso. Se Joseph talipara kawam mu te ago bagakaso. ");
INSERT INTO wsk_vpl VALUES ("GN40_4","002_40_4","GEN","40","4","4","Se nunga bitua kari gira mu Joseph kari ilagala nunga bituokko nunga awuram. Se nuna ilagala tom maiya nuam talipara ko galung ningi baga, ");
INSERT INTO wsk_vpl VALUES ("GN40_5","002_40_5","GEN","40","5","5","tom bo tirom nuna ilagala wete ipingiman, se nunga ipingira ko duap mu kirker. ");
INSERT INTO wsk_vpl VALUES ("GN40_6","002_40_6","GEN","40","6","6","Se ko ukiram tumongola Joseph nongote tairam ale nungarkam, mu nuna nungumik amilmil bo mena bagaman. ");
INSERT INTO wsk_vpl VALUES ("GN40_7","002_40_7","GEN","40","7","7","Se nu nunga isuam, “Nina awuk se nengema motam amilmil mena bagasan a?” mam. ");
INSERT INTO wsk_vpl VALUES ("GN40_8","002_40_8","GEN","40","8","8","Se nuna balman, “Ana wete ipingiman, bare kari bo anananga ipingira duap apurokko wore mena,” maman. Se Joseph nunga maonam, “Kaem kota ipingira ko duap apura ikiso. Nenenga ipingira balal se ikiekko,” mam. ");
INSERT INTO wsk_vpl VALUES ("GN40_9","002_40_9","GEN","40","9","9","Se waen bitua ko kari gira mu noko ipingira mu Joseph koma te balukaso: “Ani ipingirem ale tam waen bo angama dugu te bangawaram se arigem, ");
INSERT INTO wsk_vpl VALUES ("GN40_10","002_40_10","GEN","40","10","10","ko kower ilagala suan. Tom ko gawa butuk diruwuram, mu tairatela nunguning sisik waram, garukaram ale yoparam. ");
INSERT INTO wsk_vpl VALUES ("GN40_11","002_40_11","GEN","40","11","11","Pharaoh ko bagunang ani agiting te anikaso, se ani waen muguri yoparam mu giem, ale ituwem se ko yu bagunang ningi kaparam se Pharaoh tuikasam wore arigem,” mam. ");
INSERT INTO wsk_vpl VALUES ("GN40_12","002_40_12","GEN","40","12","12","Se Joseph maonam, “Nika ipingira ko duap mu iwita: suring ilagala suan mu day ilagala suan ko balso. ");
INSERT INTO wsk_vpl VALUES ("GN40_13","002_40_13","GEN","40","13","13","Day ilagala suan mu buring ko mu, Pharaoh aking nika aru tauk se nika ura te piler ale, ni ulengkala bitakasam butata aking waen bagun te langi Pharaoh tuiko,” mam. ");
INSERT INTO wsk_vpl VALUES ("GN40_14","002_40_14","GEN","40","14","14","“Bare tom nika ningo tom kapa kisok mu, ani ago ko kamin tugum, ale gemang aisu, ale Pharaoh manaru se ani talipara ningi bagasam imi aga sanguk se aratikko. ");
INSERT INTO wsk_vpl VALUES ("GN40_15","002_40_15","GEN","40","15","15","Mu awuk, aninga angamang te mena, nuna nononga sail te ani aga Hebrew sor te wore aga giman ale agarak taiman. Ale aitak imi te mu betela, ani mel bo memek me beterem, bare am ipi ko talipara ningi aga beteman.” ");
INSERT INTO wsk_vpl VALUES ("GN40_16","002_40_16","GEN","40","16","16","Se tom bread kaiya ko kari gira mu Joseph noko bo mu ko ipingira duap apuram mu ningo ikiam, mu nu Joseph maonam, “Ani betela ipingirem,” mam. “Ani korokem ilagala suan bread ago mu asupuling te giem. ");
INSERT INTO wsk_vpl VALUES ("GN40_17","002_40_17","GEN","40","17","17","Se korokem awote nunguning mu ningi mu, Pharaoh ko bread duap duap anikaso, bare inangnang taiman ale nokasan,” mam. ");
INSERT INTO wsk_vpl VALUES ("GN40_18","002_40_18","GEN","40","18","18","Se Joseph maonam, “Nika ipingira mu ko duap mu iwita: korokem ilagala suan mu day ilagala suan ko balam. ");
INSERT INTO wsk_vpl VALUES ("GN40_19","002_40_19","GEN","40","19","19","Day ilagala suan mu buring ko mu, Pharaoh baluk se ni degetak batagarmon ale tam kower te ka ituwumon, se inangnang ka kimik nunguning namonko,” mam. ");
INSERT INTO wsk_vpl VALUES ("GN40_20","002_40_20","GEN","40","20","20","Se day ilagala umu buring ko, day bo umu te mu Pharaoh ko bilangara tom. Se nu ko ura kari supuling suen la nunga inang biya beteram. Ale waen bitua ko kari gira, se bread kaiya ko kari gira mu arungak talipara ningi mu aratam ale biguwura motam te nunga awuram. ");
INSERT INTO wsk_vpl VALUES ("GN40_21","002_40_21","GEN","40","21","21","Ale waen bitua ko kari gira mu maonam se ko ura motam motam iluwaram mu te peleram. ");
INSERT INTO wsk_vpl VALUES ("GN40_22","002_40_22","GEN","40","22","22","Bare bread kaiya ko kari gira mu, Joseph ipingira apu se balam uwutata, tam kower te ituwuman se kueram. ");
INSERT INTO wsk_vpl VALUES ("GN40_23","002_40_23","GEN","40","23","23","Bare waen bitua ko kari gira mu Joseph ko kuamin me tugukaso. Nu Joseph ko kuamili saparam. ");
INSERT INTO wsk_vpl VALUES ("GN41_1","002_41_1","GEN","41","1","1","Yia ilagala namaram se tom bo Pharaoh ipingiram. Ale nu Yu Nile norogen te sanamiwaram se ");
INSERT INTO wsk_vpl VALUES ("GN41_2","002_41_2","GEN","41","2","2","bulmakau 7 nungumik ningo yu ningi basuman ale yu norogen te sirsir nokasan mu nungarkam. ");
INSERT INTO wsk_vpl VALUES ("GN41_3","002_41_3","GEN","41","3","3","Aking udagi mu bulmakau 7 tala, nungumik memek, mu yu ningi basuman, ale bulmakau nungumik ningo mu nungumik duap te sanamaman. ");
INSERT INTO wsk_vpl VALUES ("GN41_4","002_41_4","GEN","41","4","4","Ale bulmakau nungumik memek mu barasaman ale nungumik ningo mu nunga no gilingiman mu arigam. Pharaoh umu arigam ale tingam barasam. ");
INSERT INTO wsk_vpl VALUES ("GN41_5","002_41_5","GEN","41","5","5","Ale aking taga aniram, ale aniwa ipingira bo tala arigam. Mu kon nunguning 7 kapaman, ningo se bibiya, bore kon duap suanta owore te la kapa muruwuman. ");
INSERT INTO wsk_vpl VALUES ("GN41_6","002_41_6","GEN","41","6","6","Se udagi kon nunguning 7 tala kapaman, bare giningin se kituwura, se yar tairam nunga kaiyam se siririmaman. ");
INSERT INTO wsk_vpl VALUES ("GN41_7","002_41_7","GEN","41","7","7","Se kon siririyam mu barasaman ale kon ningo mu nunga no gilingiman mu arigam. Pharaoh akingtala tingam barasam, bare udagi ta ko ikiam, mu nu ipingiram. ");
INSERT INTO wsk_vpl VALUES ("GN41_8","002_41_8","GEN","41","8","8","Bare tumongola mu ipingira mu ko ikia am ninguru moakaso, se nu Egypt ko mang kari se ikia kari suen la nunga den beteram se taiman, se ko ipingira nunga maonam. Bare bo ta noko ipingira duap apurokko me terong. ");
INSERT INTO wsk_vpl VALUES ("GN41_9","002_41_9","GEN","41","9","9","Asele waen bitua ko kari gira mu Pharaoh maonam, “Aitakta asele ani angamin ares mam. Ani mel bo ko balikko wore me balem mu iwita: ");
INSERT INTO wsk_vpl VALUES ("GN41_10","002_41_10","GEN","41","10","10","Tom bo Pharaoh gomang magaram, se ko ura kari ilagala, ani se bread kaiya ko kari gira mu ilak, talipara kari nunga bitua kari gira ko kawam te, talipara ningi nanga awuram. ");
INSERT INTO wsk_vpl VALUES ("GN41_11","002_41_11","GEN","41","11","11","Se tirom bo ana nangama nangama ipingiman. Se ipingira mu ko nunguning kirker. ");
INSERT INTO wsk_vpl VALUES ("GN41_12","002_41_12","GEN","41","12","12","Tom mu Hebrew kuriang kulak bo mu karogotala ana nangarak bagakaso. Nu bitua kari gira ko ura kari. Bare ana ilagala nanga ipingira ko manorman se nu ko nunguning namake namake nanga maonam. ");
INSERT INTO wsk_vpl VALUES ("GN41_13","002_41_13","GEN","41","13","13","Se mel nu balam butata aratu nangaram: ani aga ura girem iluwerem mu te pelerem, se bread kaiya ko kari gira mu ituwuman se kueram.” ");
INSERT INTO wsk_vpl VALUES ("GN41_14","002_41_14","GEN","41","14","14","Se Pharaoh den mu ikiam ale Joseph tairukko balam. Se tairate talipara kawam te namaman ale ilak taiman. Joseph numi nungam, somone turuwuram, ale guang ningo mu tugumam, asele Pharaoh kote kasu naguram. ");
INSERT INTO wsk_vpl VALUES ("GN41_15","002_41_15","GEN","41","15","15","Se Pharaoh nu maonam, “Ani ipingirem, bare kari bo ipingira duap apurok se ikiekko wore mena. Bare kari saki iwita balman se ikiem, ni ipingira aguwaya mu ni ko duap am apurko terong maman.” ");
INSERT INTO wsk_vpl VALUES ("GN41_16","002_41_16","GEN","41","16","16","Bare Joseph balam, “Ani agata me terong. Bare Kaem kota Pharaoh ko ipingira ko nunguning baluk ale gomang motam nungokko terong.” ");
INSERT INTO wsk_vpl VALUES ("GN41_17","002_41_17","GEN","41","17","17","Se Pharaoh nu maonam, “Ani ipingirem ale ani Yu Nile norogen te sanamiwerem se ");
INSERT INTO wsk_vpl VALUES ("GN41_18","002_41_18","GEN","41","18","18","bulmakau nungumik ningo 7 yu ningi basuman ale yu norogen te sirsir nokasan. ");
INSERT INTO wsk_vpl VALUES ("GN41_19","002_41_19","GEN","41","19","19","Se aking udagi mu bulmakau 7 tala yu ningi basuman. Nuna nungumik memek se sokelel ala, se nunga ariga memek biya. Ani Egypt lilim ningi bulmakau bo uwuta katir me nungarki arigem. ");
INSERT INTO wsk_vpl VALUES ("GN41_20","002_41_20","GEN","41","20","20","Se bulmakau nungumik memek mu barasaman ale bulmakau nungumik ningo giriman basuman mu nunga no gilingiman. ");
INSERT INTO wsk_vpl VALUES ("GN41_21","002_41_21","GEN","41","21","21","Nunga naman, bare nunga ariga mu mel bo me nokoyam, nunga ariga am memek biya. Ani ipingira mu arigem ale tingem barasem. ");
INSERT INTO wsk_vpl VALUES ("GN41_22","002_41_22","GEN","41","22","22","“Ale aking pelerem taga anirem ale aking ipingira bo tala arigem. Mu kon nunguning 7 kapaman, ningo se bibiya, bare kon duap suanta owore te la kapa muruwuman. ");
INSERT INTO wsk_vpl VALUES ("GN41_23","002_41_23","GEN","41","23","23","Se udagi kon nunguning 7 tala kapaman, bare giningin se kituwura, se yar tairam nunga kaiyam se siririmaman. ");
INSERT INTO wsk_vpl VALUES ("GN41_24","002_41_24","GEN","41","24","24","Se kon siririyam mu barasaman ale kon ningo mu nunga no gilingiman, mu arigem. Ani mang kari alo aninga ipingira imi nunga manem. Bare bo ta ko duap apurokko me terong.” ");
INSERT INTO wsk_vpl VALUES ("GN41_25","002_41_25","GEN","41","25","25","Se Joseph Pharaoh maonam, “Nika ipingira ilagala sumu ko nunguning koma suanta. Kaem mel bitirukko wore nika kausam se arigem. ");
INSERT INTO wsk_vpl VALUES ("GN41_26","002_41_26","GEN","41","26","26","Bulmakau nungumik ningo 7 mu se, kon ningo 7 mu iwita: mu yia tom 7 ko balso. Mel ilagala umu nunga nunguning koma suanta. ");
INSERT INTO wsk_vpl VALUES ("GN41_27","002_41_27","GEN","41","27","27","Se bulmakau nungumik memek 7 udagi yu ningi basuman, se kon memek 7 tala kapaman bare yar tairam nunga kaiyam se siririmaman mu ko nunguning iwita: yia tom 7 ningi karak biya kaparukkowo. ");
INSERT INTO wsk_vpl VALUES ("GN41_28","002_41_28","GEN","41","28","28","“Ani maingkala ka manem iwitata, Kaem mel bitirukko wore ka kausam se arigem. ");
INSERT INTO wsk_vpl VALUES ("GN41_29","002_41_29","GEN","41","29","29","Yia tom 7 mu ningi, Egypt sor lilim inang ninguru sor magarukko. ");
INSERT INTO wsk_vpl VALUES ("GN41_30","002_41_30","GEN","41","30","30","Bare buring ko, yia tom 7 tala mu ningi, karak biya kaparukko. Se kariimet daiga bagara ningo arigiman mu nungamili saparukko, mu awuk, karak biya mu sor ninguru maguwu saparukko. ");
INSERT INTO wsk_vpl VALUES ("GN41_31","002_41_31","GEN","41","31","31","Nunguningta, nuna yia tom 7 ningi mel terong la bagaman mu ko nungamili saparukko, mu awuk, karak biya mu ali imi iluwok ale ninguru gomang gurugokko. ");
INSERT INTO wsk_vpl VALUES ("GN41_32","002_41_32","GEN","41","32","32","Nika ipingira koma suanta bare tom ilagala arigem mu ko duap mu, Kaem mel imi nunguningta bitirukko wore ka kausam, ale bitirukko tom pingi aram. ");
INSERT INTO wsk_vpl VALUES ("GN41_33","002_41_33","GEN","41","33","33","“Se aitak ni kari bo, ko ikia sinar nunguning wore arik, ale balu se Egypt sor bituokko. ");
INSERT INTO wsk_vpl VALUES ("GN41_34","002_41_34","GEN","41","34","35","Ale kari sang mu ago nunga baluko. Se yia tom 7 na ago mu ningi, kari umutang kariimet suen la nunga na gisan mu pagarmon motam 5 awumon, ale 4 mu kotam nungaru se, motam suanta mu bolala awumon, wonong wonong kawam bibiya ningi awumon ale ko sinar tamonko. ");
INSERT INTO wsk_vpl VALUES ("GN41_36","002_41_36","GEN","41","36","36","Se udagi yia tom 7 tala umu ningi, karak biya Egypt kaparukko tom mu te, Egypt kariimet na bolala awuman se aniso mu la gimon no se bagamonko. Ikia mu te asele kariimet na ko me kuemonkowo,” mam. ");
INSERT INTO wsk_vpl VALUES ("GN41_37","002_41_37","GEN","41","37","37","Pharaoh ko kari supuling arungu den Joseph balam mu ko amilmilaman. ");
INSERT INTO wsk_vpl VALUES ("GN41_38","002_41_38","GEN","41","38","38","Pharaoh nunga isuam, “Ana kari bo nu iwita, kaem wit nunga sokel karogo, mu ariginakko terong e?” mam. ");
INSERT INTO wsk_vpl VALUES ("GN41_39","002_41_39","GEN","41","39","39","Ale Pharaoh Joseph maonam, “Kaem kota mel imi suen la nika kausam, se kari bo ko ikia sinar nunguning nika iwita mena. ");
INSERT INTO wsk_vpl VALUES ("GN41_40","002_41_40","GEN","41","40","40","Buta se ni aninga kariimet nunga gira nunguning ka bitirik se nika kiring la karo tumonko. Kari bo nika kualala me bagarukko, ani agata ani king nika kualala bagarik se ni aninga abowa ningi bagerko,” mam. ");
INSERT INTO wsk_vpl VALUES ("GN41_41","002_41_41","GEN","41","41","41","Asele Pharaoh Joseph maonam, “Aitak ani ni Egypt sor lilim la nika bitua bowa ningi betesam,” mam. ");
INSERT INTO wsk_vpl VALUES ("GN41_42","002_41_42","GEN","41","42","42","Ale king nunga ring noko kuting peperek te aniram mu kutuwuram ale Joseph kuting peperek te tugu tuam. Ale guang ningo nuam mu giam ale Joseph tugu tuam, ale kulolo gold te nunga mu tam ale dogotak tugu tuam. ");
INSERT INTO wsk_vpl VALUES ("GN41_43","002_41_43","GEN","41","43","43","Ale noko karis ilagala se, bo kari nu bowa ningi bagoso mu te geragoso mu tam, ale Joseph awote beteram. Se te ilak geragakasan se bitua kari girikasan ale ai balukasan, “Nebugura kulukalko!” makasan. Pharaoh munan umu te Egypt sor lilim la Joseph ko bitua bowa ningi beteram. ");
INSERT INTO wsk_vpl VALUES ("GN41_44","002_41_44","GEN","41","44","44","Ale Pharaoh nu maonam, “Ani agata king biya, se ani balsam mu butata aratukko. Egypt kari bo ta kota ko ikia te mel bo me bitirukko, mena. Ni aing au awote bitar, bore asele uwutata aratukko,” mam. ");
INSERT INTO wsk_vpl VALUES ("GN41_45","002_41_45","GEN","41","45","45","Ale Pharaoh nup bo iru Joseph tuam, mu Zaphenath-Paneah. Ale imet Asenath agotala tuam. Nu Potiphera, On wonong ko priest bo ko nanawus. Se Joseph Egypt sor lilim la te geraga sapakaso. ");
INSERT INTO wsk_vpl VALUES ("GN41_46","002_41_46","GEN","41","46","46","Joseph ko yia tom 30 baga se nu Egypt ko king Pharaoh bowa ningi ura duap beteram. Nu Pharaoh ilak baga bitakaso mu Egypt sor lilim la karo sapakaso. ");
INSERT INTO wsk_vpl VALUES ("GN41_47","002_41_47","GEN","41","47","47","Se yia tom 7 ko na inang te sor magarukko tom mu te, inang ninguru sor magaram. ");
INSERT INTO wsk_vpl VALUES ("GN41_48","002_41_48","GEN","41","48","48","Se Joseph wonong suan suan te geragakaso ale nunga inang sang gikaso, ale nunga kawam nongoma nongoma umu ningi tugu tugu ago namakaso. ");
INSERT INTO wsk_vpl VALUES ("GN41_49","002_41_49","GEN","41","49","49","Nu wheat muguri ninguru gikaso ale numi awote kawam tugukaso. Se am suen biya, saun iwita. Se nu korokem suan suan kauwa, bare udagi kaurokko me terong, se kaura mu buring tuam. ");
INSERT INTO wsk_vpl VALUES ("GN41_50","002_41_50","GEN","41","50","50","Karak biya mu ko tom me tai aratam la, Joseph ko nuwus Asenath namarari ilagala iluwam. Asenath mu Potiphera, On wonong ko priest, wore ko nanawus. ");
INSERT INTO wsk_vpl VALUES ("GN41_51","002_41_51","GEN","41","51","51","Se Joseph ko namar biya mu nup beteram Manasseh mam. Mu awuk, nu balam, “Kaem aga saongam se aga ikup suen la se aga launari nunga betera memek mu abiring tuem.” ");
INSERT INTO wsk_vpl VALUES ("GN41_52","002_41_52","GEN","41","52","52","Se ko namar gotek mu nup beteram Ephraim mam. Mu awuk, nu balam, “Kaem sor ani te ikup arigem wore te kuriang aisam ale daiga bagara ningo aisam,” mam. ");
INSERT INTO wsk_vpl VALUES ("GN41_53","002_41_53","GEN","41","53","53","Na inang ko yia tom 7 mu menaram. ");
INSERT INTO wsk_vpl VALUES ("GN41_54","002_41_54","GEN","41","54","54","Se karak ko yia tom 7 tala mu Joseph balam uwutatala duap beteram. Se sor saki agotala te karak biya kaparam. Bare Egypt sor lilim mu inang karogo anikaso. ");
INSERT INTO wsk_vpl VALUES ("GN41_55","002_41_55","GEN","41","55","55","Bare kam me maiyam, Egypt kariimet agotala karak ko sokel ko ikiman ale Pharaoh na nungarukko niakasan. Bare Pharaoh nunga maonam, “Joseph kote namaral se anapeya ninga manuk mu karo tualko,” mam. ");
INSERT INTO wsk_vpl VALUES ("GN41_56","002_41_56","GEN","41","56","56","Karak tom memek nunguningkiri Egypt lilim iram, se Joseph kawam bibiya inang ningi tugu awuram mu kaogam, se Egypt kariimet taikasan na diakasan. ");
INSERT INTO wsk_vpl VALUES ("GN41_57","002_41_57","GEN","41","57","57","Karak tom memek umu sor saki karogo la nunga iramuram, se nuna inang diamonko Egypt taikasan ale Joseph kote na diakasan. ");
INSERT INTO wsk_vpl VALUES ("GN42_1","002_42_1","GEN","42","1","1","Tom Jacob Egypt sor ko na inang terong la aniso mu ko den ikiam, mu nu ko namarari nunga maonam, “Nina awuk se yam bagara suwuta ya? ");
INSERT INTO wsk_vpl VALUES ("GN42_2","002_42_2","GEN","42","2","2","Ani Egypt sor te inang aniso se ko den ikiem. Se nina namaral ale na sang diaralko. Mena mu ana baga kuesan pa ya,” mam. ");
INSERT INTO wsk_vpl VALUES ("GN42_3","002_42_3","GEN","42","3","3","Se Joseph ko launari 10 mu barasaman ale na inang diamonko Egypt nama kapaman. ");
INSERT INTO wsk_vpl VALUES ("GN42_4","002_42_4","GEN","42","4","4","Bare Jacob Joseph ko uria nunguning Benjamin mu guramam se arungak me namaram. Mu awuk, nu Benjamin memek bo arigok wore ko nguangaram ale guramam. ");
INSERT INTO wsk_vpl VALUES ("GN42_5","002_42_5","GEN","42","5","5","Se Israel ko namarari mu kari saki na diamonko wore arungak namaman, mu awuk, karak biya mu Canaan sor karogotala iramuram. ");
INSERT INTO wsk_vpl VALUES ("GN42_6","002_42_6","GEN","42","6","6","Se Joseph mu aitak Egypt nunga governor ko bagakaso, se sor mu ko kariimet nukote na inang diakasan. Se tom Joseph ko launari tai arataman, mu nuna nu koma dugu te nubugura kulukurman ale nongoma ali ningi kaparam. ");
INSERT INTO wsk_vpl VALUES ("GN42_7","002_42_7","GEN","42","7","7","Se Joseph ko launari mu nomoke arigam mu nu tairatela nunga ikiam. Bare nu kawelakaso, ale kari kigilik iwita darangara karogo nongorak munakakaso. Ale mam, “Nina apalak ko wore taiman a?” mam. Se nuna balman, “Ana Canaan sor ko wore na dianakko taiman,” maman. ");
INSERT INTO wsk_vpl VALUES ("GN42_8","002_42_8","GEN","42","8","8","Joseph ko launari mu nunga ikiam, bare nuna nu me ko ikikasan. ");
INSERT INTO wsk_vpl VALUES ("GN42_9","002_42_9","GEN","42","9","9","Nu ko ipingira nuna nogo ko mu ko kuamin ares mam se nunga maonam, “Nina sor ariga guruga ko tere kari! Nina taiman ale lage aguwaya te nanga maguwuralko wore ko sor ari guruguwasan,” mam. ");
INSERT INTO wsk_vpl VALUES ("GN42_10","002_42_10","GEN","42","10","10","“Mena, mena, aninga kari dom. Ana nika ura kari. Ana na inang dianakko taiman. ");
INSERT INTO wsk_vpl VALUES ("GN42_11","002_42_11","GEN","42","11","11","Ana suen la mu kari suanta wore ko namarari la. Ana den nunguning la balsan. Ana tere sor ariga guruga ko kari mena.” ");
INSERT INTO wsk_vpl VALUES ("GN42_12","002_42_12","GEN","42","12","12","Bare Joseph “Mena!” mam. “Nina taiman ale lage aguwaya te nanga maguwuralko wore ko sor ari guruguwasan,” mam. ");
INSERT INTO wsk_vpl VALUES ("GN42_13","002_42_13","GEN","42","13","13","Bare nuna balman, “Nanga kari dom, ana launuria 12, se kari suanta ko namarari, se nu Canaan sor te bagoso. Nanga uria gotek mu nanga ba ilak am bagoso tala. Se nanga bo mu kueram.” ");
INSERT INTO wsk_vpl VALUES ("GN42_14","002_42_14","GEN","42","14","14","Bare Joseph akingtala nunga maonam, “Ani maingkala balem uwutata nina tere sor arigalko taiman! ");
INSERT INTO wsk_vpl VALUES ("GN42_15","002_42_15","GEN","42","15","15","Ani iwita ninga bitirik ale arigekko. Pharaoh nup biya bowa ningi ani nunguningta ninga manorsam, nenenga uria gotek balsan mu ewela me tairuk, mu nina peleral ninga sor te me namaralko. ");
INSERT INTO wsk_vpl VALUES ("GN42_16","002_42_16","GEN","42","16","16","Ninga bo namaruk ninga uria ilak tairukko, bare nina sikina mu talipara ningi bagaralko. Se ana udagi nenenga den mu nunguningta agi mena mu ko ikinakko. Bare nina kawelaral, mu Pharaoh nup biya bowa ningi ani balsam, nunguningta nina tere sor arigalko taiman ma balikko.” ");
INSERT INTO wsk_vpl VALUES ("GN42_17","002_42_17","GEN","42","17","17","Joseph uwuta balam, ale talipara ningi nunga awuram se day ilagala suan bagaman. ");
INSERT INTO wsk_vpl VALUES ("GN42_18","002_42_18","GEN","42","18","18","Se day ilagala baga buring ko day suan mu te, Joseph nunga maonam, “Ani Kaem kuring karo tua kari, se nina aninga agiring kaoral mu asele nina yawarakala bagaralko. ");
INSERT INTO wsk_vpl VALUES ("GN42_19","002_42_19","GEN","42","19","19","Nunguningta nina den nunguning bala ko kari agi mu, nenenga bo talipara ningi am bagaruk, se nina sikina mu ninga imet kuriang na ko kuawasan mu nunga na inang diaral ale ago peleral namaralko. ");
INSERT INTO wsk_vpl VALUES ("GN42_20","002_42_20","GEN","42","20","20","Bare nina ninga uria gotek mu am ilak aningate tairalko nunguningkiri. Mu asele ani balik, nina den nunguning balman maik, se nina me kueralko.” Se nuna butata beteman. ");
INSERT INTO wsk_vpl VALUES ("GN42_21","002_42_21","GEN","42","21","21","Nuna nunumi manarukasan, “Nunguningta, ana nanga uria bita maguwuman mu ko koma ana aitak ikup imi ariwasan! Nu niakaso ale sangornakko nangarak wosengakaso, bare ana nade baguman. Buta se ana aitak ikup imi ariwasan.” ");
INSERT INTO wsk_vpl VALUES ("GN42_22","002_42_22","GEN","42","22","22","Se Reuben balam, “Se ani nu uwuta me bita maguwuralko me ninga manem e? Ani balukasam bare nina nede sisiram. Buta se aitak ko gue kaparam mu ko koma ikup am ginakko.” ");
INSERT INTO wsk_vpl VALUES ("GN42_23","002_42_23","GEN","42","23","23","Nuna nunga Hebrew den te nunumi ago munakakasan, se Joseph iki sapawakaso mu nuna me ikikasan. Mu awuk, pempem mu Joseph Egypt den te munakakaso se den guruga kari den gurugukaso. ");
INSERT INTO wsk_vpl VALUES ("GN42_24","002_42_24","GEN","42","24","24","Se Joseph nunga den mu ikiam ale gomang batagam, se buring gurugu nungaram ale mononge kau siwuram, ale aking koma gurugu nungaram ale nongorak munakakaso. Ale balam se nongoma te Simeon kuting kaloman ale ilak talipara ningi namakasan. ");
INSERT INTO wsk_vpl VALUES ("GN42_25","002_42_25","GEN","42","25","25","Joseph ko ura kari nunga maonam, nuna noko launari nunga inang muguri te tuguma ko guang biriman mu, nongoma nongoma na inang te tugu nungarmon, ale nunga manga silver na te diaman mu guang umu ningi karogo la tugu tugu nungarmonko balam. Ale na lage te namonko mu ago nungarmonko balam. Se ko ura kari alo Joseph balam butata beteman. ");
INSERT INTO wsk_vpl VALUES ("GN42_26","002_42_26","GEN","42","26","26","Se ko launari nunga na inang guang ningi tuguman mu patawu nunga donkey awote awuman ale namakasan. ");
INSERT INTO wsk_vpl VALUES ("GN42_27","002_42_27","GEN","42","27","27","Nama lage te tirom batagam, se animon ale ukirok se aking namamonko. Se bo ko donkey na tuok se naukko guang inang te tuguman mu kuring kaogam, ale ko manga silver wore aking am ningi aniram se arigam. ");
INSERT INTO wsk_vpl VALUES ("GN42_28","002_42_28","GEN","42","28","28","Ale ko saki nunga auram ale balam, “Arigalko!” mam. “Silver inang te diarem mu aking inang ko guang ningi e aniso iweya!” Se nuna suen la biririkaman ale ninguru nguangakasan, ale nunumi isarukasan, “Kaem awuk se iwita nanga beteso ya?” makasan. ");
INSERT INTO wsk_vpl VALUES ("GN42_29","002_42_29","GEN","42","29","29","Nuna tai Canaan sor te, nunga nonet Jacob kote arataman, ale mel suen biya nungumik te aratam mu manorman. Nuna balman, ");
INSERT INTO wsk_vpl VALUES ("GN42_30","002_42_30","GEN","42","30","30","“Egypt sor lilim bitaruwara ko kari dom ana den alis ago nanga manarukaso, ale ana tere namotam sor ariga ko kari iwita nanga bitakaso. ");
INSERT INTO wsk_vpl VALUES ("GN42_31","002_42_31","GEN","42","31","31","Bare ana balukasan, ‘Ana den nunguning la balsan. Ana tere sor ariga ko me taiman. ");
INSERT INTO wsk_vpl VALUES ("GN42_32","002_42_32","GEN","42","32","32","Ana launuria 12, kari suanta wore ko namarari. Bare nanga uria bo kueram, se kulak gotek mu nanga ba ilak Canaan bagoso,’ ma balman. ");
INSERT INTO wsk_vpl VALUES ("GN42_33","002_42_33","GEN","42","33","33","“Se kari dom mu iwita nanga maonam, ‘Ani iwita ninga bitirik ale arigekko, nina nunguningta balsan agi mu ko ikiekko. Ninga ningi suanta ani agarak bagaruk, se nina sikina na inang gial ale ninga kuriang imet te nunga saongalko ago namaralko. ");
INSERT INTO wsk_vpl VALUES ("GN42_34","002_42_34","GEN","42","34","34","Bare ninga uria gotek mu am ilak aningate tairalko nunguningkiri,’ ma balam. ‘Mu asele ani balik, nina den nunguning balsan, ale nina tere sor ariga ko kari mena maikko. Asele ani ninga bo ani agarak bagoso mu ningarik se, nina imi te am dia gurugu namaral tairalko,’ mam.” Nuna uwutata nonet manorman. ");
INSERT INTO wsk_vpl VALUES ("GN42_35","002_42_35","GEN","42","35","35","Ale nuna suen la nunga guang na te tuguman mu kuring kagaru muruwuman, ale inang gi awumonko negawa, suen la biririkaman, mu awuk, nunga manga silver mu nomoke nomoke nunga inang ko guang ningi aniram se arigiman. Nunga nonet manga mu karogo arigam. Se nuna suen la ninguru nguangakasan. ");
INSERT INTO wsk_vpl VALUES ("GN42_36","002_42_36","GEN","42","36","36","Se nunga nonet Jacob nunga maonam, “Nina aninga kuriang alo agate nunga gi sapasan pa! Joseph kua namaram. Simeon me peleram tairam. Se aitak Benjamin agate tal ale ilak namaralko balsan. Munan suen la arataso mu am ikup la aisiso pa!” mam. ");
INSERT INTO wsk_vpl VALUES ("GN42_37","002_42_37","GEN","42","37","37","Se Reuben ko nuet maonam, “Ani Benjamin ilak me pelerik tairik, mu aninga namar ilagala la nunga moar se kuemonko. Se Benjamin ani agiting te bitar se ko sinar la ilak namarik ale aking ilak pelerik tairikko.” ");
INSERT INTO wsk_vpl VALUES ("GN42_38","002_42_38","GEN","42","38","38","Bare Jacob balam, “Aninga namar nina nengerak me namarukko. Noko laun kueram, se nu kota suanta bagoso. Se ani garukerem ale amone yak ma kutuwuram tala. Nenenga aolak sumu te nu memek bo arigok, mu nina ikisan, nina ani angamang bataga ago mutim aga tugumalko.” ");
INSERT INTO wsk_vpl VALUES ("GN43_1","002_43_1","GEN","43","1","1","Karak biya ko tom sor lilim iram mu me menayakaso. ");
INSERT INTO wsk_vpl VALUES ("GN43_2","002_43_2","GEN","43","2","2","Se Jacob ko kuriang imas inang Egypt ago taiman mu no kutuwuman, se nu ko namarari nunga maonam, “Peleral Egypt namaral ale inang sang ago diaralko,” mam. ");
INSERT INTO wsk_vpl VALUES ("GN43_3","002_43_3","GEN","43","3","3","Bare Judah nu maonam, “Ba, kari dom mu den aora biya nanga maonam, ‘Nina ninga uria gotek mu ilak me tairal, mu ani nengema me arigekko,’ mam. ");
INSERT INTO wsk_vpl VALUES ("GN43_4","002_43_4","GEN","43","4","4","Bare Ba, ni balu se ana nanga uria ilak namanak, mu asele ana na diara ko lage kuring mu kaigukko. ");
INSERT INTO wsk_vpl VALUES ("GN43_5","002_43_5","GEN","43","5","5","Bare ni me balu, mu ana me namanakko, mu awuk, kari dom mu balam, ana nanga uria ilak me namanak, mu ana nangama motam me arigokko balam.” ");
INSERT INTO wsk_vpl VALUES ("GN43_6","002_43_6","GEN","43","6","6","Bare Israel mam, “Se nina awuk se kari dom mu manorman, nina ninga uria gotek bo bagoso maman, ale ikup imi aisiman?” ");
INSERT INTO wsk_vpl VALUES ("GN43_7","002_43_7","GEN","43","7","7","Se nuna balman, “Bare kari dom mu ana suen la nanga dugu duap ko nanga isaru diruwukaso. Ale nanga ba marak bagoso agi mu ko, se nanga uria bo karogo agi mu ko, karogo la nanga isuam. Se ana noko isa koma mu diram tala manorman. Ale ana awuk ko ikinak, nu ana nanga uria gotek ilak kote namanakko balukko? Mena.” ");
INSERT INTO wsk_vpl VALUES ("GN43_8","002_43_8","GEN","43","8","8","Se Judah ko nuet Israel maonam, “Kuriang sumu bitar se aninga bitua bowa ningi tairuk se ana tairate namanakko, mu asele ni se ana suen la me kuenak, marak baganakko. ");
INSERT INTO wsk_vpl VALUES ("GN43_9","002_43_9","GEN","43","9","9","Ani agata diram ko sinar taikko. Mel i bo kumik te aratuk, mu ani ko ikup giekko. Ani diram la nikate me pelerik tairik, mu ani butata ko ikup gi se lagarikko. ");
INSERT INTO wsk_vpl VALUES ("GN43_10","002_43_10","GEN","43","10","10","Ana ulengkala la uwuta beteman le mu, ana mungkala tom ilagala ko namaman taiman ale aitak terong la bagasan le.” ");
INSERT INTO wsk_vpl VALUES ("GN43_11","002_43_11","GEN","43","11","11","Se nunga nonet Israel nunga maonam, “Suwuta agi mu butata beteralko. Canaan ko mel ningo ningo sang gial, ale nigiriwim tugumal, ale ago nama kari dom mu munan iwita tualko. Mel siring ningo ningo mu se, honey, tam muguri yaman nuam, se mel sang uwuta uwuta mu gialko. ");
INSERT INTO wsk_vpl VALUES ("GN43_12","002_43_12","GEN","43","12","12","Manga silver inang te diaman mu karogo aniram se arigiman umu gial, ale karogo pila kari dom mu tualko. Mu awuk, umu paguwura bo aratam agila. Ale na inang iru diara ko manga silver karogo gialko. ");
INSERT INTO wsk_vpl VALUES ("GN43_13","002_43_13","GEN","43","13","13","Ario, ninga uria tal ale tairate peleral kari dom mu kote namaralko. ");
INSERT INTO wsk_vpl VALUES ("GN43_14","002_43_14","GEN","43","14","14","Se Kaem Sokel Garagar mu ninga sanguk se kari mu gomang ningaruk ale ninga bo Simeon ningaruk, ale ninga uria Benjamin ago ningaruk se nongorak tairalko. Nina suen la agate peleral tairal, mu nina taiman maikko. E me peleral tairal, mu ta mena.” ");
INSERT INTO wsk_vpl VALUES ("GN43_15","002_43_15","GEN","43","15","15","Se nuna munan te betemonko melmasak giman, manga silver karogo pelera ko mu se aking na iru te diara ko mu giman, ale nunga uria Benjamin karogo taman, ale tairate aolak iluman nama Egypt arataman ale nama Joseph arigiman. ");
INSERT INTO wsk_vpl VALUES ("GN43_16","002_43_16","GEN","43","16","16","Joseph Benjamin arungu tairam se arigam, ale ko ura kari ko kawam bitaruwaram mu maonam, “Ni kari imi nunga gi nongorak aninga kawam te namar, ale sipsip bo moar ale na kai kami nunguru sagerko,” mam. “Kari taiman imi woremkalal ani agarak na namonko.” ");
INSERT INTO wsk_vpl VALUES ("GN43_17","002_43_17","GEN","43","17","17","Se Joseph ko ura kari nu balam butata beteram, ale Joseph ko kawam te nongorak namakaso. ");
INSERT INTO wsk_vpl VALUES ("GN43_18","002_43_18","GEN","43","18","18","Se tom nongorak kawam te namakaso mu nuna ninguru nguangakasan, ale nungamin yenakaso, “Imi ana ulengko taiman ale na diaman, bare manga na te diaman mu aking nanga na inang ningi aniram se ana arigiman, ewere ko agi nanga iluman agila. Kari dom mu nanga moruk maguwurok, ale ura dungan kari ko nanga bitiruk ale nanga donkey giokko agi, iwita nanga beteso,” makasan. ");
INSERT INTO wsk_vpl VALUES ("GN43_19","002_43_19","GEN","43","19","19","Ale ilak nama Joseph ko kawam kuringi mu te, ko kawam bitua kari mu manorman, ");
INSERT INTO wsk_vpl VALUES ("GN43_20","002_43_20","GEN","43","20","20","“Mel bo balnak se ikiko. Tom iru la ana na dianakko taiman, ");
INSERT INTO wsk_vpl VALUES ("GN43_21","002_43_21","GEN","43","21","21","ale na diaman ale peleman nama lage luan te aninakko se, nanga na inang ko guang kuring kagorman mu nanga manga silver na te diaman mu butatala aking suan suan nanga na inang ningi aniram se arigiman. Ale aitak ana giman karogo taiman. ");
INSERT INTO wsk_vpl VALUES ("GN43_22","002_43_22","GEN","43","22","22","Bare ana awiriya uwuta beteram mu ana me ko ikisan. Ana nanga manga silver iru aitak na te dianakko mu karogo giman karogo taiman.” ");
INSERT INTO wsk_vpl VALUES ("GN43_23","002_43_23","GEN","43","23","23","Se bitua kari mu balam, “Mu mel bo mena. Nina me nguangaralko. Nenenga Kaem se ninga nenet ko Kaem mu nenenga mel yawara bo iwita ninga inang ko guang ningi awuram. Bare nenenga manga silver inang te diaman mu anigita giem.” Nu uwuta balu se Simeon tam ilak nongote tairam. ");
INSERT INTO wsk_vpl VALUES ("GN43_24","002_43_24","GEN","43","24","24","Ale nu arungak Joseph ko kawam ningi kasu naguram, ale yu nusuwik te anumonko mu nungaru se, nunga donkey karogo la na nungaram. ");
INSERT INTO wsk_vpl VALUES ("GN43_25","002_43_25","GEN","43","25","25","Nuna Joseph woremkalal tairuk arungak na naukko mu ko den ikiman, ale nunga nuguting munan nu tumonko giman mu nunguru burangikasan. ");
INSERT INTO wsk_vpl VALUES ("GN43_26","002_43_26","GEN","43","26","26","Se tom Joseph kawam te tairam mu, nuna nunga nuguting munan umu tui se nubugura kulukuru muruwuman ale nongoma motam ali ningi kaparam. ");
INSERT INTO wsk_vpl VALUES ("GN43_27","002_43_27","GEN","43","27","27","Se nu amilmil den nunga maonam, asele nunga isuam, “Se nenenga nenet aora ko balman se ani ikiem mu awuk? Nu terong se marak bagoso e?” ");
INSERT INTO wsk_vpl VALUES ("GN43_28","002_43_28","GEN","43","28","28","Se nuna balman, “Anananga nainet, nika ura kari, mu marak yawarakala bagoso,” maman. Ale akingtala nubugura kulukurman. ");
INSERT INTO wsk_vpl VALUES ("GN43_29","002_43_29","GEN","43","29","29","Nu nungarki gurugu tai uria Benjamin arigam, noko uria nunguningkiri, ale isam, “Imi ninga uria gotek ko aga manorman bore e?” Ale maonam, “Kuriang kulak yawara, Kaem ko gomang lila kerak bagarukko!” ");
INSERT INTO wsk_vpl VALUES ("GN43_30","002_43_30","GEN","43","30","30","Noko uria arigam ale gomang ninguru batagam se niara dogotak kulukam. Se nu tairate nunga beteram ale ko galung ningi kasu naguram ale niakaso. ");
INSERT INTO wsk_vpl VALUES ("GN43_31","002_43_31","GEN","43","31","31","Nu niaram mam, ale koma motam anuwam asele aratam. Ale niara ninguru maguwukaso bare sail te iluwa se balam, “Na nungaralko,” mam. ");
INSERT INTO wsk_vpl VALUES ("GN43_32","002_43_32","GEN","43","32","32","Se nuna Joseph ko na mu kuwim kigilik te tuman, ale ko launuria nunga na mu kuwim kigilik te nungarman. Se Egypt kari Joseph ilak bagara mu nunga na kuwim kigilik te tala nungarman. Mu awuk, Egypt alo Hebrew nongorak dagisan ale wete na me nasan. Egypt nunga munan te mu kiwem umu memek. ");
INSERT INTO wsk_vpl VALUES ("GN43_33","002_43_33","GEN","43","33","33","Se ura kari alo Joseph ko launuria mu nu koma dugu te kuwim nungarman, ale nunga bilangara tom te iki se, kari laun tai nama mom kopa te nunga awuman se dagi muruwuman. Se nuna munan imi arigiman ale ikia ninguru nunga moakaso. ");
INSERT INTO wsk_vpl VALUES ("GN43_34","002_43_34","GEN","43","34","34","Se tom nuna suen la na nowakasan mu, Joseph noko na sang ko ura kari nungarukaso se ko launari nunga tawir koma koma te awu awu karogo namakasan. Bare uria Benjamin ko mu, na biya nuam beteram se giman karogo nama tuman. Na mu na biya, kari 5 iwita namonko koma. Se kari launuria mu amilmil te Joseph ilak nunumi karogo na no gi gilingiman. ");
INSERT INTO wsk_vpl VALUES ("GN44_1","002_44_1","GEN","44","1","1","Joseph ko kawam ko bitua kari gira mu iwita kiti gurugam: “Kariari mu nunga na gimonko mu, nunga guang na te tuguma mu ningi koma koma tugu sager, se nama gimonko terong mauk, mu te ilupko. Ale nononga manga silver na te diaman mu koma koma nunga inang karogo tugu nungaruko. ");
INSERT INTO wsk_vpl VALUES ("GN44_2","002_44_2","GEN","44","2","2","Asele aninga bagunang silver mu to ale, nunga uria gotek umu ko manga silver mu karogo biguwur, ale ko guang inang ningi tuguma mu ko kuring duap ko awurko.” Se Joseph ko ura kari nu balam butata beteram. ");
INSERT INTO wsk_vpl VALUES ("GN44_3","002_44_3","GEN","44","3","3","Tumong biyala Joseph ko launuria mu nunga melmasak nunguru donkey awote awuman, se nunga beteman se arataman namakasan. ");
INSERT INTO wsk_vpl VALUES ("GN44_4","002_44_4","GEN","44","4","4","Nuna wonong biya mu beteman ale nama nomolak me maiyam la, Joseph ko kawam bitua kari gira maonam, “Ni bares ale tairate kari namasan wore nogowom karoko. Tom nama nongote aratu mu iwita nunga manaruko, ‘Nina awuk se ana kilek ningo ningimik te beteman wore ko koma kilek memek ananangate beteman? ");
INSERT INTO wsk_vpl VALUES ("GN44_5","002_44_5","GEN","44","5","5","Nina anape ko aninga kari dom ko bagunang silver wore tere taman? Kari dom mu nu borta te yu naso, ale mel yumura umu ko ikiso. Nina kilek memek nunguningkiri beteman,’ uwutata nunga manaruko.” ");
INSERT INTO wsk_vpl VALUES ("GN44_6","002_44_6","GEN","44","6","6","Se Joseph ko ura kari nogowom kaoram ale nongote nama aratam ale butata nunga maonam. ");
INSERT INTO wsk_vpl VALUES ("GN44_7","002_44_7","GEN","44","7","7","Bare nuna den koma balman, “Dom, ni mel balem mu ana karogo ngualasan. Ana anape ko munan bo suwutata betenakko? ");
INSERT INTO wsk_vpl VALUES ("GN44_8","002_44_8","GEN","44","8","8","Ni ikisam, ana manga silver inang ko guang ningi aniram karogo Canaan namaman ale arigiman, mu aking giman ago taiman se ni arigem. Se ana awuk ta nika kari dom ko kawam te ko silver agi gold tere nanakko? Mena. ");
INSERT INTO wsk_vpl VALUES ("GN44_9","002_44_9","GEN","44","9","9","Bare anananga ningi bo mel umu iluwuruk se arik agi mu, moar se kueruk se ana suen la mu nika ura dungan kari ko baganakko.” ");
INSERT INTO wsk_vpl VALUES ("GN44_10","002_44_10","GEN","44","10","10","Se ura kari balam, “Mu terong, balman butata. Bare awiriya bagunang tam mu la aninga ura dungan kari ko bagarukko. Se nina sikina mu ningimik den mena, am namaralko.” ");
INSERT INTO wsk_vpl VALUES ("GN44_11","002_44_11","GEN","44","11","11","Se nuna tairatela nunga guang na inang te tuguman umu patatuwu aliti awuman, ale koma koma kuring kagorman. ");
INSERT INTO wsk_vpl VALUES ("GN44_12","002_44_12","GEN","44","12","12","Se ura kari umu nunga guang suan suan ningi loaga loaga taikaso, nunga kari laun te duap beteram ale karogo kapa kari mom kopa mu te tai sanamaram. Ale bagunang mu Benjamin ko guang inang te tuguma mu ningi arigam. ");
INSERT INTO wsk_vpl VALUES ("GN44_13","002_44_13","GEN","44","13","13","Se launari mel mu arigiman ale nongomang motam nunga ikia ninguru parasaram, se nunga guang nungumik te mu barurumuman. Ale nunga melmasak gi aking donkey awote awuman, ale wonong biya mu te aking peleman namaman. ");
INSERT INTO wsk_vpl VALUES ("GN44_14","002_44_14","GEN","44","14","14","Joseph am ko kawam te bagaram se Judah ko launuria karogo nama kote arataman. Nuna koma dugu te ali awote kapaman ale nunumi am maguwu silataman. ");
INSERT INTO wsk_vpl VALUES ("GN44_15","002_44_15","GEN","44","15","15","Se Joseph nunga maonam, “Nina awuk se kiwem ewere beteman a? Nina ikiman, ani kari imi mel bo suwuta aratuk se me ko ikiekko i maman e?” ");
INSERT INTO wsk_vpl VALUES ("GN44_16","002_44_16","GEN","44","16","16","Se Judah mam, “Ana anape balnakko, aga kari dom? Ana awuk balnakko? Ana lage bo te nanimi bataguru tanakko mu mena. Kaem anananga memek wetang saparam. Se ana aitak suen la nika ura dungan kari, ana se kari bagunang ko ikup kumik te soraram mu agotala.” ");
INSERT INTO wsk_vpl VALUES ("GN44_17","002_44_17","GEN","44","17","17","Bare Joseph mam, “Mena. Ani munan bo suwuta me ta bitirikko. Kari bagunang ko ikup kote soraram umu diram aninga ura dungan kari ko bagarukko. Se nina ningimik den mena mu, nengemang lila te peleral ninga ba kote namaralko.” ");
INSERT INTO wsk_vpl VALUES ("GN44_18","002_44_18","GEN","44","18","18","Se Judah nama gira Joseph koma te sanamaram ale mam, “Kari dom, gemang lila te kuring aisu se den sang kerak balikko. Ni nip biya, ni Pharaoh iwitatala, se ani mu am mel yam bo iwita. Bare ago ko gemang me magarukko. ");
INSERT INTO wsk_vpl VALUES ("GN44_19","002_44_19","GEN","44","19","19","Ni ana ka ura kari iru la kete taiman mu ni nanga nainet ko isuem, ale nanga uria gotek bo karogo agi mu ko nanga isuem. ");
INSERT INTO wsk_vpl VALUES ("GN44_20","002_44_20","GEN","44","20","20","Se ana koma balman, ‘Nanga nainet garuk nunguningkiri, se nanga uria gotek, tom nanga ba garuk ningi bagaram se bilangaram mu ago. Se nanga uria mu ko laun mu kueram. Nuna nunam duap suanta, se aitak nu kota bagoso, se nanga nainet ninguru ko kueso,’ maman. ");
INSERT INTO wsk_vpl VALUES ("GN44_21","002_44_21","GEN","44","21","21","“Se ni ana nu ilak kete tainak se keta motam te arikko balem. ");
INSERT INTO wsk_vpl VALUES ("GN44_22","002_44_22","GEN","44","22","22","Se ana balman, ‘Ana nanga uria mu ilak tainakko me terong. Mu awuk, nu nanga nainet bitiruk, mu nanga nainet kuerukko,’ maman. ");
INSERT INTO wsk_vpl VALUES ("GN44_23","002_44_23","GEN","44","23","23","Bare ni balem, ‘Nina ninga uria ilak me tairal, mu ani nengema motam me arigekko,’ maem. ");
INSERT INTO wsk_vpl VALUES ("GN44_24","002_44_24","GEN","44","24","24","Se ana peleman nanga nainet kote namaman, ale ni kari dom ka kiring manorman se ikiam. ");
INSERT INTO wsk_vpl VALUES ("GN44_25","002_44_25","GEN","44","25","25","“Se tom bo nu balam, ‘Peleral namaral ale na sang ago diaralko,’ mam, ");
INSERT INTO wsk_vpl VALUES ("GN44_26","002_44_26","GEN","44","26","26","mu ana iwita nu manorman, ‘Ana nanga uria ilak namanak mu asele ana kari dom umu kote na dianakko. Bare mena, mu ana me namanakko. Nu ana nangama motam me arigokko balam.’ ");
INSERT INTO wsk_vpl VALUES ("GN44_27","002_44_27","GEN","44","27","27","“Se anananga nainet iwita nanga maonam, ‘Nina ikisan, nenenga ninam Rachel kuriang ilagala diram nunga iluwam. ");
INSERT INTO wsk_vpl VALUES ("GN44_28","002_44_28","GEN","44","28","28","Se bo mu mel memek batutumu naman agila, se kumik me arigisam. ");
INSERT INTO wsk_vpl VALUES ("GN44_29","002_44_29","GEN","44","29","29","Se aitak nina aking ko gotek imi ilak namaral se memek arigok agi mu, nina ani angamang bataga ago mutim aga tugumalko,’ mam. ");
INSERT INTO wsk_vpl VALUES ("GN44_30","002_44_30","GEN","44","30","30","“Owore te se, kari dom, kuriang kari sumu ana nanga nainet ko gomang motam nunguningkiri. Se ana nama aratanak se ");
INSERT INTO wsk_vpl VALUES ("GN44_31","002_44_31","GEN","44","31","31","kuriang kari sumu me nangarak namaruk se arigok, mu nu kueram. Nanga nainet mu garukaram nunguningkiri, se mone yak ma saparam, ewere te se, ana noman bataga karogo mutim tugunakko iwita. ");
INSERT INTO wsk_vpl VALUES ("GN44_32","002_44_32","GEN","44","32","32","Ani nanga nainet manem, ‘Kuriang sumu aninga bitua bowa ningi bagarukko. Ani me ilak kete pelerik tairik, mu ko ikup suen la ani giekko.’ ");
INSERT INTO wsk_vpl VALUES ("GN44_33","002_44_33","GEN","44","33","33","“Buta se, aninga kari dom ningo, ani kuriang kari mu ko kuwim te aga bitar se nika ura dungan kari ko bagarikko. Se nu bitar se ko launari sang arungu peleruk namarukko. ");
INSERT INTO wsk_vpl VALUES ("GN44_34","002_44_34","GEN","44","34","34","Ani kuriang kari sumu agarak me namaruk agi mu, ani awuk pelerik aga ait kote namarikko? Mena! Ani ikup imi ba kumik te aratuk se arigekko me kuesam.” ");
INSERT INTO wsk_vpl VALUES ("GN45_1","002_45_1","GEN","45","1","1","Joseph bo karogo numi kaluwurokko me terong mam, se sail te airam ale ko ura kari nunga maonam, “Nina suen la aratalko!” mam. Se kariimet bo kigilik mena, am mu kota ko launuria arungak, asele nu numi wetang saparam. ");
INSERT INTO wsk_vpl VALUES ("GN45_2","002_45_2","GEN","45","2","2","Ale sail te niakaso, se Egypt kariimet ko niara mu ikiman. Se Pharaoh ko nuwus kuriang se suen la nirung umu ko den ikiman tala. ");
INSERT INTO wsk_vpl VALUES ("GN45_3","002_45_3","GEN","45","3","3","Joseph ko launuria nunga maonam, “Ani Joseph i!” mam. “Aga ait kueram agi am bagoso e?” mam. Bare ko launari nu kuring te me basukasan, mu awuk, nuna noko koma motam ko nguangakasan. ");
INSERT INTO wsk_vpl VALUES ("GN45_4","002_45_4","GEN","45","4","4","Joseph akingtala nunga maonam, “Aningate pingi tairalko,” mam. Se nuna kote pingi namaman, se balam, “Ani nenenga uria Joseph i. Nina ani Ishmael alo nuguting te aga beteman, ale manga taman, se nuna ani agarak Egypt taiman borta. ");
INSERT INTO wsk_vpl VALUES ("GN45_5","002_45_5","GEN","45","5","5","Bare aitak nina uwuta aga beteman mu ko, me ninimi nengemang maguwural ale dolaral nguangaralko. Mu awuk, Kaem ani te kariimet nunga sanguk se me kua parangamonko lage beteram se ani girem imi te tairem. ");
INSERT INTO wsk_vpl VALUES ("GN45_6","002_45_6","GEN","45","6","6","Karak biya sor imi iram mu aitak ko yia ilagala aram. Ale ningam aguwa ale gi nana ko munan mu betela, yia tom 5 nangama ko taiwasan mu ningi me anirukko tala. ");
INSERT INTO wsk_vpl VALUES ("GN45_7","002_45_7","GEN","45","7","7","Buta se Kaem aninga giruwuram se tairem, nina ninga sangik se ninga kuriang gue ali imi te me mena namamonko. Imi kiwem aora bo beteram. ");
INSERT INTO wsk_vpl VALUES ("GN45_8","002_45_8","GEN","45","8","8","“Bore te se, nina ani imi te aga beteman se me tairem, mena. Kaem kota aninga beteram se imi te tairem. Nu ani Pharaoh ko wosagam kitira ko kari gira ko aga beteram. Ale Pharaoh ko imet kuriang kawam digo lilim, se Egypt sor lilim ko governor ko aga beteram. ");
INSERT INTO wsk_vpl VALUES ("GN45_9","002_45_9","GEN","45","9","9","Ario, nina tairate aga ba kote peleral namaral ale iwita maonalko: Ka namar Joseph iwita balam, Kaem Joseph Egypt sor lilim ko governor ko beteram se bagoso ma balalko. Ale pasak ala kote nama kaparko ko balam malko. ");
INSERT INTO wsk_vpl VALUES ("GN45_10","002_45_10","GEN","45","10","10","Ni namar nu kumik duap te, koma Goshen masan mu te, ka kuriang nimasari, ka bulmakau, sipsip, se ka melmasak suen la karogo umu te kuwim toko mam. ");
INSERT INTO wsk_vpl VALUES ("GN45_11","002_45_11","GEN","45","11","11","Ani pingi mu te inang te ninga sinar taikko, mu awuk, karak biya imi yia tom 5 nangama ko taiwoso mu am nanga iluwuruk se, ni se ka kuriang gue lilim, se ka melmasak lilim ago paranga namaral bore ko,” mam. ");
INSERT INTO wsk_vpl VALUES ("GN45_12","002_45_12","GEN","45","12","12","“Nina ta ani agarkaman uwutatala, aga uria Benjamin agarkam, mu nunguningta anigita nengerak munakawasam. ");
INSERT INTO wsk_vpl VALUES ("GN45_13","002_45_13","GEN","45","13","13","Egypt alo nup biya ani aisisan mu se, melmasak suen la nina arigiman mu aga ait maonal se ikiokko. Se pasak ala ilak imi te tai kaparalko,” mam. ");
INSERT INTO wsk_vpl VALUES ("GN45_14","002_45_14","GEN","45","14","14","Ale ko uria Benjamin yasaram ale ilak niakaso. Se Benjamin agotala nu iluwam ale niakaso. ");
INSERT INTO wsk_vpl VALUES ("GN45_15","002_45_15","GEN","45","15","15","Asele nu ko launari suen la nunga yasaram ale nongorak niakaso. Se ko launuria nongomang motam kua kaparam se nu ilak munakakasan. ");
INSERT INTO wsk_vpl VALUES ("GN45_16","002_45_16","GEN","45","16","16","Tom Pharaoh ko kari supuling suen la karogo Joseph ko launuria kote taiman mu ko den ikiman mu nuna amilmilaman. ");
INSERT INTO wsk_vpl VALUES ("GN45_17","002_45_17","GEN","45","17","17","Se Pharaoh Joseph maonam, “Ka launuria nunga manaru se melmasak gi donkey te awumon ale pelemon Canaan namamon, ");
INSERT INTO wsk_vpl VALUES ("GN45_18","002_45_18","GEN","45","18","18","ale nunga nonet se nunga imet kuriang suen la nunga gimon ale arungak aningate taimonko. Se ani Egypt ali koma bo ningo mu nungarik se, nuna ali bilik mu ko ningo nuam te to no se bagamonko. ");
INSERT INTO wsk_vpl VALUES ("GN45_19","002_45_19","GEN","45","19","19","“Ni nunga manaru se iwita betemonko: ana Egypt nanga karis saki nongorak namamon ale nunga imet kuriang se nunga nonet te nongorak taimonko. ");
INSERT INTO wsk_vpl VALUES ("GN45_20","002_45_20","GEN","45","20","20","Nunga biung kako ko ikia me tamonko, mu awuk, Egypt ko mel ningo ningo mu nononga arukko.” ");
INSERT INTO wsk_vpl VALUES ("GN45_21","002_45_21","GEN","45","21","21","Se Israel ko namarari butata beteman. Joseph Pharaoh balam butata karis sang nungaram, ale na sang lage te namonko mu ago nungaram. ");
INSERT INTO wsk_vpl VALUES ("GN45_22","002_45_22","GEN","45","22","22","Ale suan suan guang iru iru nagumonko mu nungaram. Bare Benjamin mu manga silver 300 se guang iru motam 5 karogo tuam. ");
INSERT INTO wsk_vpl VALUES ("GN45_23","002_45_23","GEN","45","23","23","Ale nuet ko mu melmasak imi awuram: donkey 10 Egypt ko mel ningo ningo karogo terong mam, se donkey imet 10 tala mu na inang se melmasak saki lage te no se tairukko mu ago terong mam. ");
INSERT INTO wsk_vpl VALUES ("GN45_24","002_45_24","GEN","45","24","24","Asele ko launuria nunga beteram se namakasan, se nunga maonam, “Lage luan te ninimi karogo me kaeralko!” mam. ");
INSERT INTO wsk_vpl VALUES ("GN45_25","002_45_25","GEN","45","25","25","Se nuna Egypt beteman ale nunga nonet kote Canaan sor te nama tarigiman. ");
INSERT INTO wsk_vpl VALUES ("GN45_26","002_45_26","GEN","45","26","26","Ale manorman, “Joseph marak bagoso! Ale nu Egypt sor lilim bitaruwoso,” maman. Bare Jacob den umu ikiam mu nu tingam ale kuring menaram. ");
INSERT INTO wsk_vpl VALUES ("GN45_27","002_45_27","GEN","45","27","27","Se nuna Joseph den suen biya nunga maonam mu manorman. Se karis, nu te gimon ale ilak pelemon namamonko beteram mu arigam, asele noman biyala saparam. ");
INSERT INTO wsk_vpl VALUES ("GN45_28","002_45_28","GEN","45","28","28","Ale balam, “Aitak asele ani angamang ningi nunguning aram. Aninga namar Joseph am marak bagoso! Ani amotam me kuinisam la, pasak namarik ale arigekko,” mam. ");
INSERT INTO wsk_vpl VALUES ("GN46_1","002_46_1","GEN","46","1","1","Se Israel ko melmasak ago lilim barasam ale namakaso. Nama Beersheba aratam mu nu ko nuet Isaac ko Kaem tama bita tuam. ");
INSERT INTO wsk_vpl VALUES ("GN46_2","002_46_2","GEN","46","2","2","Se tirom Kaem anira te maonam, “Jacob! Jacob!” mam. Se Jacob “Ani iweya,” mam. ");
INSERT INTO wsk_vpl VALUES ("GN46_3","002_46_3","GEN","46","3","3","Se Kaem mam, “Ani Kaem, nika niet ko Kaem. Egypt namarko me nguangerko. Ni te ani kariimet motam biya bo umu te bitirik se aratukko. ");
INSERT INTO wsk_vpl VALUES ("GN46_4","002_46_4","GEN","46","4","4","Ani ni kerak Egypt namarik, ale agata tala aking ka taleng girigir arungak pelerikko. Se ni Egypt baga kuar se Joseph kota kuting te metam kui bagarukko,” mam. ");
INSERT INTO wsk_vpl VALUES ("GN46_5","002_46_5","GEN","46","5","5","Se Jacob Beersheba beteram. Ale ko namarari se nunga imet kuriang ago Pharaoh karis nungaram mu te nunga giman arungak namakasan. ");
INSERT INTO wsk_vpl VALUES ("GN46_6","002_46_6","GEN","46","6","6","Nuna nunga bulmakau se sipsip Canaan karogo bagaman mu se, nunga melmasak suen la karogo Egypt namakasan. ");
INSERT INTO wsk_vpl VALUES ("GN46_7","002_46_7","GEN","46","7","7","Jacob ko namarari, ko nanawusari, ko numasari, imet te kari te, lilim ago Egypt namaram. ");
INSERT INTO wsk_vpl VALUES ("GN46_8","002_46_8","GEN","46","8","8","Imi Jacob ko namarari nongorak Egypt namaram wore nunga nunup, se nunga kuriang gue nunga nunup: Reuben mu Jacob ko namar laun. ");
INSERT INTO wsk_vpl VALUES ("GN46_9","002_46_9","GEN","46","9","9","Se Jacob ko namar Reuben ko namarari mu Hanoch, Pallu, Hezron, se Karmi. ");
INSERT INTO wsk_vpl VALUES ("GN46_10","002_46_10","GEN","46","10","10","Se Jacob ko namar Simeon ko namarari mu Jemuel, Jamin, Ohad, Jakin, Zohar, se Shaul. Shaul mu Canaan imet ko tuagu te. ");
INSERT INTO wsk_vpl VALUES ("GN46_11","002_46_11","GEN","46","11","11","Se Jacob ko namar Levi ko namarari mu Gershon, Kohath, se Merari. ");
INSERT INTO wsk_vpl VALUES ("GN46_12","002_46_12","GEN","46","12","12","Se Jacob ko namar Judah ko namarari mu Er, Onan, Shelah, Perez, se Zerah. Bare ilagala, Er se Onan mu Canaan la kua gilingiman. Se Judah ko namar Perez ko namarari mu Hezron se Hamul. ");
INSERT INTO wsk_vpl VALUES ("GN46_13","002_46_13","GEN","46","13","13","Se Jacob ko namar Issachar ko namarari mu Tola, Puah, Jashub, se Shimron. ");
INSERT INTO wsk_vpl VALUES ("GN46_14","002_46_14","GEN","46","14","14","Se Jacob ko namar Zebulun ko namarari mu Sered, Elon, se Jahleel. ");
INSERT INTO wsk_vpl VALUES ("GN46_15","002_46_15","GEN","46","15","15","Se umu Jacob ko namarari nuwus Leah tuagu te, se nanawus suanta mu Dinah, tom nuna Paddan Aram bagaman tom te. Se ko namar nanawus suen la nunga ilu biguwura mu 33. ");
INSERT INTO wsk_vpl VALUES ("GN46_16","002_46_16","GEN","46","16","16","Se Jacob ko namar Gad ko namarari mu Zephon, Haggi, Shuni, Ezbon, Eri, Arodi, se Areli. ");
INSERT INTO wsk_vpl VALUES ("GN46_17","002_46_17","GEN","46","17","17","Se Jacob ko namar Asher ko namarari mu Imnah, Ishvah, Ishvi, se Beriah. Se nunga nogoras imet mu Serah. Se Asher ko namar Beriah ko namarari mu Heber se Malkiel. ");
INSERT INTO wsk_vpl VALUES ("GN46_18","002_46_18","GEN","46","18","18","Se umu Jacob ko namarari nuwus Leah ko ura saonga imet Zilpah tuagu te. Nunga ilu biguwu sapara mu 16. ");
INSERT INTO wsk_vpl VALUES ("GN46_19","002_46_19","GEN","46","19","19","Se Jacob ko nuwus Rachel tuagu te mu Joseph se Benjamin. ");
INSERT INTO wsk_vpl VALUES ("GN46_20","002_46_20","GEN","46","20","20","Joseph Egypt sor te On wonong ko priest Potiphera nanawus Asenath tam. Ko tuagu te mu Manasseh se Ephraim bilangaman. ");
INSERT INTO wsk_vpl VALUES ("GN46_21","002_46_21","GEN","46","21","21","Se Jacob ko namar Benjamin ko namarari mu Bela, Beker, Ashbel, Gera, Naaman, Ehi, Rosh, Muppim, Huppim, se Ard. ");
INSERT INTO wsk_vpl VALUES ("GN46_22","002_46_22","GEN","46","22","22","Se umu Jacob ko nuwus Rachel tuagu te. Nunga ilu biguwu sapara mu 14. ");
INSERT INTO wsk_vpl VALUES ("GN46_23","002_46_23","GEN","46","23","23","Se Jacob ko namar Dan ko namar mu Hushim. ");
INSERT INTO wsk_vpl VALUES ("GN46_24","002_46_24","GEN","46","24","24","Se Jacob ko namar Naphtali ko namarari mu Jahziel, Guni, Jezer, se Shillem. ");
INSERT INTO wsk_vpl VALUES ("GN46_25","002_46_25","GEN","46","25","25","Se umu Jacob ko namarari nuwus Rachel ko ura saonga imet Bilhah tuagu te arataman. Nunga ilu biguwu sapara mu 7. ");
INSERT INTO wsk_vpl VALUES ("GN46_26","002_46_26","GEN","46","26","26","Jacob ko kuriang se ko numasari noko gue te ilak Egypt namaman mu suen la nunga ilu biguwu sapara mu 66. Bare Jacob ko namarari nunga nunuwus mu me ago nunga kauman. ");
INSERT INTO wsk_vpl VALUES ("GN46_27","002_46_27","GEN","46","27","27","Se Joseph ko namarari ilagala Egypt bilangaman mu sikina namaman mu karogo ilu biguwu sapara mu ko tom 70. ");
INSERT INTO wsk_vpl VALUES ("GN46_28","002_46_28","GEN","46","28","28","Jacob Judah giruwuram, namaruk Joseph kuring te Goshen wonong ko den ninguru taukko maonam. Se tom nuna nama Goshen wonong te arataman, ");
INSERT INTO wsk_vpl VALUES ("GN46_29","002_46_29","GEN","46","29","29","mu Joseph ko karis te aragam ale ko nuet Israel arigokko tairam. Tom nu tai ko nuet kote aratam, mu iluwam ale yasaram, ale ilak tom maiya biya nia lagakaso. ");
INSERT INTO wsk_vpl VALUES ("GN46_30","002_46_30","GEN","46","30","30","Asele nuet aora Israel iwita nu maonam, “Aitak asele ani am kuerikko, mu awuk, ani amotam te ni karkem, ni am marak bagasam!” mam. ");
INSERT INTO wsk_vpl VALUES ("GN46_31","002_46_31","GEN","46","31","31","Se Joseph ko launuria se ko nuet ko kariimikiri ago suen la nunga maonam, “Ani nama tarigirik ale Pharaoh iwita manikko, ‘Aga launuria se aga ait ko kariimikiri ago Canaan mu tai arataman. ");
INSERT INTO wsk_vpl VALUES ("GN46_32","002_46_32","GEN","46","32","32","Nuna bulmakau sipsip nunga bitua kari, se nuna nunga bulmakau se sipsip mel ago lilim taiman,’ maikko. ");
INSERT INTO wsk_vpl VALUES ("GN46_33","002_46_33","GEN","46","33","33","Se tom Pharaoh ninga aurok se kote kasu nagural se ninga ura ko ninga isuok, ");
INSERT INTO wsk_vpl VALUES ("GN46_34","002_46_34","GEN","46","34","34","mu nina iwita maonalko, ‘Kari aromemek, ana nika ura kari. Anananga nainet alo nunga iwitatala, ana gotektek la nanga bulmakau sipsip nunga bitua kari ko lagaman,’ malko. Mu asele nu baluk se nina koma Goshen mu te daigalko, mu awuk, Egypt alo nunga munan te mu, nuna sipsip nunga bitua kari nongorak bagamonko me kuesan.” ");
INSERT INTO wsk_vpl VALUES ("GN47_1","002_47_1","GEN","47","1","1","Joseph namaram ale Pharaoh maonam, ale mam, “Aninga ait se aga launuria, nunga bulmakau sipsip se nunga melmasak lilim ago, Canaan wonong beteman ale taiman, aitak Goshen bagasan,” mam. ");
INSERT INTO wsk_vpl VALUES ("GN47_2","002_47_2","GEN","47","2","2","Ale Joseph ko launuria 5 nunga tuteram ale nunga giam, ale Pharaoh nungarkukko nongorak kote namaram. ");
INSERT INTO wsk_vpl VALUES ("GN47_3","002_47_3","GEN","47","3","3","Se Pharaoh nunga isuam, “Nenenga ura mu anape ya?” mam. Se nuna balman, “Kari aromemek, ana nika ura kari. Anananga nainet nanangatak alo nunga nuguwim te ana sipsip nunga bitua kari alo. ");
INSERT INTO wsk_vpl VALUES ("GN47_4","002_47_4","GEN","47","4","4","Ana taiman sor imi te katir baga asele ko, mu awuk, karak tom imi Canaan ningi mu am memek biya, se anananga sipsip sirsir ito namonko mu mena. Buta se anananga nangamang ni balu se ana Goshen daginakko aniso,” maman. ");
INSERT INTO wsk_vpl VALUES ("GN47_5","002_47_5","GEN","47","5","5","Se Pharaoh Joseph maonam, “Nika niet se ka launuria imi nikate taiman, ");
INSERT INTO wsk_vpl VALUES ("GN47_6","002_47_6","GEN","47","6","6","se Egypt ko ali lilim imi ni kiting te aniso. Ka niet se ka launuria nunga gi ale, ali bilik ningo nunguningkiri mu te nunga bitar se dagimonko, Goshen nunga bitar se dagimonko. Saki nungarki terong mu, nunga bitar se aninga bulmakau nunga bitarmonko.” ");
INSERT INTO wsk_vpl VALUES ("GN47_7","002_47_7","GEN","47","7","7","Se Joseph ko nuet Jacob ilak Pharaoh arigokko kote namaram. Se Jacob bugura kulukam ale Pharaoh den amilmil tuam. ");
INSERT INTO wsk_vpl VALUES ("GN47_8","002_47_8","GEN","47","8","8","Se Pharaoh Jacob isuam, “Nika yia tom awila?” mam. ");
INSERT INTO wsk_vpl VALUES ("GN47_9","002_47_9","GEN","47","9","9","Se Jacob balam, “Ani kuwim suanta te me bagakasam, ani sor suen biya te geraga lagerem ale aga yia tom mu 130. Aninga yia tom mu suen mena, se ningi ikup suen biya arikasam. Aninga ait angatak alo mu betela geraga dalela bagakasan, bare nunga yia tom mu suen biya,” mam. ");
INSERT INTO wsk_vpl VALUES ("GN47_10","002_47_10","GEN","47","10","10","Ale akingtala bugura kulukam ale Pharaoh beteram ale aratam. ");
INSERT INTO wsk_vpl VALUES ("GN47_11","002_47_11","GEN","47","11","11","Buta se Joseph Pharaoh balam butata beteram, ale ko nuet, ko launuria, Egypt sor Rameses ko ali welang ningo Goshen mu nungaram se te dagiman. ");
INSERT INTO wsk_vpl VALUES ("GN47_12","002_47_12","GEN","47","12","12","Se Joseph na inang ko nuet se ko launuria nunga imet kuriang ago terong ma la nungaram. ");
INSERT INTO wsk_vpl VALUES ("GN47_13","002_47_13","GEN","47","13","13","Karak tom mu namaram am maga saparam, se na inang menaram. Sor Egypt ta se sor Canaan am koma suanta am maga saparam. ");
INSERT INTO wsk_vpl VALUES ("GN47_14","002_47_14","GEN","47","14","14","Se Joseph Egypt se Canaan nunga manga na inang te diakasan mu gi saparam, ale karogo Pharaoh ko kawam te namaram. ");
INSERT INTO wsk_vpl VALUES ("GN47_15","002_47_15","GEN","47","15","15","Se tom Egypt se Canaan kariimet nunga manga na te diamonko mu mena saparam mu, Egypt kariimet Joseph kote taiman ale manorman, “Na nangaruko,” maman. “Awuk, am nangarkiwer se kema te kuenakko e? Ana nanga manga suen la menaram,” maman. ");
INSERT INTO wsk_vpl VALUES ("GN47_16","002_47_16","GEN","47","16","16","Se Joseph balam, “Buta agi mu, ninga bulmakau sipsip mel ago tairal ale aisal asele ani na ningarikko.” ");
INSERT INTO wsk_vpl VALUES ("GN47_17","002_47_17","GEN","47","17","17","Se nuna nunga horse, sipsip, goat, bulmakau, donkey, ago Joseph kote taikasan ale tuikasan, se koma ko na inang nungarukaso. Joseph butata nunga katarmuwaram se yia mu menaram. ");
INSERT INTO wsk_vpl VALUES ("GN47_18","002_47_18","GEN","47","18","18","Se umu buring ko, yia iru mu te aking kote taiman ale manorman, “Kari dom, anananga ikup ni kema te me kaluwunakko. Anananga manga mena saparam, se nanga bulmakau sipsip mel mu maingkala nika aram. Se anananga mel bo ta me aniso, mena. Bare ana kariimet se nanga ali la diram aniso. ");
INSERT INTO wsk_vpl VALUES ("GN47_19","002_47_19","GEN","47","19","19","Se awuk, ana nanga nangimik guang se nanga ali karogo metam te am mena namanakko e? Na inang te nanga ali ago likilim nanga dier, se ana Pharaoh ko ura dungan ko baganakko. Se inang muguri nangaru se agunak, ale inang ko me kuenakko, se nanga ali me ipi maga namarukko,” maman. ");
INSERT INTO wsk_vpl VALUES ("GN47_20","002_47_20","GEN","47","20","20","Se Joseph Egypt nunga ali lilim Pharaoh ko diaram. Egypt kariimet karak nunga bilam se suen la nunga ali usi sapaman. ");
INSERT INTO wsk_vpl VALUES ("GN47_21","002_47_21","GEN","47","21","21","Se Joseph Egypt kariimet lilim, dun saki te nama dun saki te, mu Pharaoh ko ura dungan ko nunga gi muruwuram. ");
INSERT INTO wsk_vpl VALUES ("GN47_22","002_47_22","GEN","47","22","22","Bare priest alo nunga ali mu asele Joseph me diaram, mu awuk, Pharaoh priest la manga nungarukaso, se na te dia nokasan ale nunga ali me Joseph kote diakasan. ");
INSERT INTO wsk_vpl VALUES ("GN47_23","002_47_23","GEN","47","23","23","Joseph kariimet iwita nunga maonam, “Nina ikialko,” mam. “Ani nina ninga ali ago lilim ninga diarem, se nina aitak Pharaoh ko la,” mam. “Buta se inang muguri imi gial ale karogo nama aguwalko. ");
INSERT INTO wsk_vpl VALUES ("GN47_24","002_47_24","GEN","47","24","24","Se udagi nunguning kaparuk mu, nunguning tuteral motam 5 awural, ale suanta gira mu Pharaoh ko beteral, ale motam 4 mu nenenga. Inang muguri mu sang aguwa ko awural, ale sang ninga imet kuriang ago nalko,” mam. ");
INSERT INTO wsk_vpl VALUES ("GN47_25","002_47_25","GEN","47","25","25","Se nuna balman, “Kari dom, ni ana ninguru nanga sangem se ana bo me kueman. Se ana suen la mu Pharaoh ko ura dungan kariimet ko baganakko.” ");
INSERT INTO wsk_vpl VALUES ("GN47_26","002_47_26","GEN","47","26","26","Se Joseph Egypt ali lilim ko munan uwutata beteram, se pempem inang garukaso se motam gira mu Pharaoh tusan. Se munan mu aitak am bitawasan. Bare priest alo nunga ali mu nongota nunga, Pharaoh ko mena. ");
INSERT INTO wsk_vpl VALUES ("GN47_27","002_47_27","GEN","47","27","27","Israel alo Egypt sor te Goshen dagi gilingiman. Se nunga melmasak suen biya umu te anikaso, se nunga kuriang gue umu te pagam ale sor magaram. ");
INSERT INTO wsk_vpl VALUES ("GN47_28","002_47_28","GEN","47","28","28","Se Jacob Egypt sor te mu, yia tom 17 bagaram, se ko yia tom lilim biguwu sapara mu 147. ");
INSERT INTO wsk_vpl VALUES ("GN47_29","002_47_29","GEN","47","29","29","Tom nu kuerukko tom pingi aram mu, nu ko namar Joseph auram se tairam se maonam, “Ni nunguningta aninga kuesam agi mu, kiting aninga agaluwong bowa ningi bitar ale, agarak den diram la se ningo la karo tuiko balu aisuko, tom ani amotam kui anirek, mu ni Egypt me aga mutim tugumko. ");
INSERT INTO wsk_vpl VALUES ("GN47_30","002_47_30","GEN","47","30","30","Bare aga gi ale agarak aga ait angatak nunga sor te namar ale aga mutim tugum se nongorak bagarikko,” mam. Se Joseph mam, “Ani ni balsam butata bita saparikko,” mam. ");
INSERT INTO wsk_vpl VALUES ("GN47_31","002_47_31","GEN","47","31","31","Bare Jacob balam, “Ni den nunguningta la baluko,” mam. Se Joseph nuet kualuwong bowa ningi kuting beteram ale balam, “Nunguningta nunguningkiri ani butata bitirikko,” mam, asele Israel ko sikir te numi sangaru se maigam ale Kaem nup patawuram. ");
INSERT INTO wsk_vpl VALUES ("GN48_1","002_48_1","GEN","48","1","1","Tom sang namaram se Joseph den ikiam, “Nika niet kuera ago bagoso,” maman. Se nu ko namarari ilagala Ephraim se Manasseh arungak ko nuet arigimonko namaman. ");
INSERT INTO wsk_vpl VALUES ("GN48_2","002_48_2","GEN","48","2","2","Se tom Jacob den ikiam, “Nika namar Joseph ni karkukko tairam,” mu nu ko anira kuwim te numi tagi gurungumu laga barasu daigam. ");
INSERT INTO wsk_vpl VALUES ("GN48_3","002_48_3","GEN","48","3","3","Ale Joseph maonam, “Kaem Sokel Garagar mu Canaan sor te, wonong Luz mu te, agate aratam ale marak aisam, ");
INSERT INTO wsk_vpl VALUES ("GN48_4","002_48_4","GEN","48","4","4","ale aga maonam, ‘Ani kuriang gue suen biya kisek se kapamon ninguru sor magamonko,” mam. “Ale nika gue te kariimet motam bibiya aratamon ale ilu biguwura suanta bagamon, se kuriang gue ni biring ko mu ali imi nungarik se nononga pempem anirukko,’ mam. ");
INSERT INTO wsk_vpl VALUES ("GN48_5","002_48_5","GEN","48","5","5","“Buta se nika namarari ilagala ani Egypt me tairem la, ka niwus tuagu te bilangaman, mu aninga iwita ikiko. Reuben se Simeon ilak aninga iwitatala, Ephraim se Manasseh mu aninga. ");
INSERT INTO wsk_vpl VALUES ("GN48_6","002_48_6","GEN","48","6","6","Kuriang i bo maingte bilanga kisimon, mu asele nika. Se kari ilagala mu nunup te nunga ali mel mu nuna ko kotam amonko. ");
INSERT INTO wsk_vpl VALUES ("GN48_7","002_48_7","GEN","48","7","7","Ani Paddan baga pelerem tai Canaan lage luan te, Ephrath ko pingia se Rachel kueram ale angamang bataga aisam. Se ani lage Ephrath namaram mu ko norogen te mutim tugumem.” Ephrath nup bo Bethlehem. ");
INSERT INTO wsk_vpl VALUES ("GN48_8","002_48_8","GEN","48","8","8","Ale Israel Joseph ko namarari ilagala mu nungarkam ale isuam, “Imi arika ya?” mam. ");
INSERT INTO wsk_vpl VALUES ("GN48_9","002_48_9","GEN","48","9","9","Se Joseph nuet maonam, “Imi aninga namarari, Kaem ewerete ani aisam wore,” mam. Se Israel mam, “Nongorak tair se marak nungarikko,” mam. ");
INSERT INTO wsk_vpl VALUES ("GN48_10","002_48_10","GEN","48","10","10","Israel aora garukaram nunguning, ale motam sor ari turutuwukaso. Se Joseph ko namarari ilagala mu nongorak kote pingi namaram, se nu nunga iluwam ale nunga yasaram. ");
INSERT INTO wsk_vpl VALUES ("GN48_11","002_48_11","GEN","48","11","11","Ale Israel aora Joseph maonam, “Ani ni me karkikko iwita iki lagakasam. Bare Kaem lage yawara beteram se aitak ani ni karkem, ale ka kuriang ago nungarkem.” ");
INSERT INTO wsk_vpl VALUES ("GN48_12","002_48_12","GEN","48","12","12","Se Joseph ko namarari mu Israel aora gomang te dagiman mu nunga patatuwuram ale ko nuet koma te bugura kulukam ale moke ali ningi kaparam. ");
INSERT INTO wsk_vpl VALUES ("GN48_13","002_48_13","GEN","48","13","13","Asele Joseph ko namarari ilagala mu nunga giam, ale Ephraim mu noko kuting sengam ko beteram, bare mu Israel aora ko ngas ko; se Manasseh mu noko kuting ngas ko beteram, bare mu Israel aora ko sengam ko sanamaram. Se nongorak kote pingi tairam. ");
INSERT INTO wsk_vpl VALUES ("GN48_14","002_48_14","GEN","48","14","14","Bare Israel aora mu kuting sengam mu garukam ale kari uria Ephraim, noko ngas ko sanamiwaram, mu supuling te beteram. Ale kuting ngas mu kuting sengam mu te supuram se garukam ale kari laun Manasseh, noko sengam ko sanamiwaram, mu supuling te beteram. ");
INSERT INTO wsk_vpl VALUES ("GN48_15","002_48_15","GEN","48","15","15","Ale nu Joseph marak tuam, ale iwita balam, “Aninga ait angatak Abraham Isaac nunga Kaem, borta ani kuriang la aga bituam agarak tai aitak, ");
INSERT INTO wsk_vpl VALUES ("GN48_16","002_48_16","GEN","48","16","16","se nuguta Engel ani memek ningi aga sangaru tam, mu kuriang kari ilagala imi marak nungarukko. Ale nuna te ani se aga ait angatak Abraham se Isaac nanga nanip me yumurokko. Se nunga kuriang gue paguk ale sor irokko,” mam. ");
INSERT INTO wsk_vpl VALUES ("GN48_17","002_48_17","GEN","48","17","17","Bare Joseph ko nuet ko kuting numi luan te supuram se kuriang nusupuling te awuram mu arigam, ale me amilmilaram. Se nu nuet ko kuting sengam Ephraim supuling te aniram mu tam, ale Manasseh supuling te bita se, ");
INSERT INTO wsk_vpl VALUES ("GN48_18","002_48_18","GEN","48","18","18","“Mena, aninga Ba, imi kari laun. Nika kiting sengam mu noko supuling te bitarko,” mam. ");
INSERT INTO wsk_vpl VALUES ("GN48_19","002_48_19","GEN","48","19","19","Bare ko nuet kuting tagi batogam ale mam, “Ani ko ikisam, aga namar, ani ko ikiwasam,” mam. “Nu betela noko gue te kariimet motam biya bo aratuk se nu nup biya karogotala bagarukko. Bare ko uria mu nu kiaruk ale nup biya nunguning bagarukko. Se noko gue te mu kariimet saki nunga ilu biguwumon se suanta bagamonko.” ");
INSERT INTO wsk_vpl VALUES ("GN48_20","002_48_20","GEN","48","20","20","Ale tom nung te la marak nungaram ale balam, “Udagi Israel kariimet nunga saki alo marak den nungaru se iwita balmonko, ‘Kaem Ephraim Manasseh nungumik te beteram turan nina ningimik te bitirukko,’ ma balmonko.” Israel aora buta balam, ale Ephraim kari uria mu giruwuram, ale Manasseh kari laun mu udagi ko beteram. ");
INSERT INTO wsk_vpl VALUES ("GN48_21","002_48_21","GEN","48","21","21","Ale Israel aora Joseph maonam, “Ikiko. Ani kuerikko tom pingi aram. Bare Kaem nengerak bagoso mu nengerak peleruk, ninga nenet nenengetak nunga ali te nengerak namarukko. ");
INSERT INTO wsk_vpl VALUES ("GN48_22","002_48_22","GEN","48","22","22","Ale ni mu, nika launari nunga kualala nunguning bagasam, mu ali ningo nunguningkiri, duruk komang kuting, ani Amor arungak kagererem ale nuguting te taem, mu kisisam,” mam. ");
INSERT INTO wsk_vpl VALUES ("GN49_1","002_49_1","GEN","49","1","1","Jacob ko namarari suen la nunga auram ale mam, “Tai biguwural se mel maingte ningimik te aratukko wore ninga manikko,” mam. ");
INSERT INTO wsk_vpl VALUES ("GN49_2","002_49_2","GEN","49","2","2","“Tai biguwural ale nede gurugalko; nina Jacob ko namarari, ninga nenet Israel munakaruk bore ikialko. ");
INSERT INTO wsk_vpl VALUES ("GN49_3","002_49_3","GEN","49","3","3","“Reuben, ni aninga kuriang laun, ni aninga gue gira nunguning se aninga sokel; ni nip ago se sokel ago, saki alo nunga iwita mena. ");
INSERT INTO wsk_vpl VALUES ("GN49_4","002_49_4","GEN","49","4","4","Bare ni nimi ira mena, mu awuk, ni yu lom iwita kuwim suanta te bagara me ikisam; ni aninga anira kuwim te aragem ale karur tugumem. ");
INSERT INTO wsk_vpl VALUES ("GN49_5","002_49_5","GEN","49","5","5","“Simeon se Levi mu launuria, memek betera te mu nunga munan koma suanta: nunga baenat mu te kager daong betesan ale kariimikiri nunga moa batutumusan. ");
INSERT INTO wsk_vpl VALUES ("GN49_6","002_49_6","GEN","49","6","6","Ani nunga biguwura ningi me namarikko, ikia memek ko den kalosan mu ningi me daigekko, mu awuk, nuna nunga nongomang memek te kariimikiri nunga moman se kueman, se bulmakau nusuwik pisi batutumuman mu kumik duap bo mena. ");
INSERT INTO wsk_vpl VALUES ("GN49_7","002_49_7","GEN","49","7","7","Nononga nongomang magara mu memek biya, se koma memek arigimonko! Ani nunga parusuwurik se Israel ningi kuwim suanta te me bagamonko. ");
INSERT INTO wsk_vpl VALUES ("GN49_8","002_49_8","GEN","49","8","8","“Judah, nika launuria mu nip patawumonko; nika kager kari mu nodogotak te nunga ilup ale nunga menawurko; ka launuria mu nubugura kulukuru kisimonko. ");
INSERT INTO wsk_vpl VALUES ("GN49_9","002_49_9","GEN","49","9","9","Ni lion kulak bo iwita, O Judah aninga namar; nika inang moa nasam ale pelesam ka kiwim te nimi dingumusam ale taga anisam. Awiri kumik nguangara mena nika amuma ikiso? Mena. ");
INSERT INTO wsk_vpl VALUES ("GN49_10","002_49_10","GEN","49","10","10","Supuling ura betera ko tam, Judah kuting te iluwa ko kualuwong luan te beteram se aniso mu, gue kigilik bo tairuk me taukko; bare kotam nunguning, noko gue, mu tairuk tauk ale iluwok, ale te kariimet suen la nunga bituok se kuring bowa ningi bagamonko. ");
INSERT INTO wsk_vpl VALUES ("GN49_11","002_49_11","GEN","49","11","11","Nu ko donkey tam waen karogo kalok, ale donkey ko gotek waen kower ningo mu karogo kalokko; ale ko guang mu waen kiri gueyam mu karogo lilim aruk ale te numi bala tuokko. ");
INSERT INTO wsk_vpl VALUES ("GN49_12","002_49_12","GEN","49","12","12","Noko motam mu kaetam, waen ko kiri mu kiaram, se ko kore nikim mu amin kiri siraram mu kiaram. ");
INSERT INTO wsk_vpl VALUES ("GN49_13","002_49_13","GEN","49","13","13","“Zebulun mu langi gagi duap te bagarukko; se noko saun korang mu dal te tai nagu aratu namamonko; se noko ali ko tom mu nama Sidon karogo numi iluwokko. ");
INSERT INTO wsk_vpl VALUES ("GN49_14","002_49_14","GEN","49","14","14","“Issachar mu nu donkey sokel ago iwita, bare nu mel kota giokko wore ningi kaposo ale am ani lagoso. ");
INSERT INTO wsk_vpl VALUES ("GN49_15","002_49_15","GEN","49","15","15","Nu anira kuwim bo se ali ningo arigiso, te noman saparukko yawara, mu te dagiso, ale umu te kari nobowa ningi dungan ura bita se mel ikup ikup gi lagoso. ");
INSERT INTO wsk_vpl VALUES ("GN49_16","002_49_16","GEN","49","16","16","“Dan mu Israel ningi, noko kariimet motam mu nunga tutera kari bagarukko. ");
INSERT INTO wsk_vpl VALUES ("GN49_17","002_49_17","GEN","49","17","17","Nu mot memek iwita lage norogen ko baga se, horse suwik ponor usiso se kari horse awote mu buring ko daguloso, iwita bagarukko. ");
INSERT INTO wsk_vpl VALUES ("GN49_18","002_49_18","GEN","49","18","18","“O Yawe, ani ni aga sangaruko nikate la loaga lagasam. ");
INSERT INTO wsk_vpl VALUES ("GN49_19","002_49_19","GEN","49","19","19","“Gad mu tere kari motam bo taimon ilak kagermonko, bare nu nunga moruk ale nunga karukko. ");
INSERT INTO wsk_vpl VALUES ("GN49_20","002_49_20","GEN","49","20","20","“Asher ko inang mu duap duap se ningo ningo; se na inang mu king naukko koma. ");
INSERT INTO wsk_vpl VALUES ("GN49_21","002_49_21","GEN","49","21","21","“Naphtali mu deer bo mayang batagorman se ko gomang te geraga se kuriang ningo ningo nunga iluso iwita. ");
INSERT INTO wsk_vpl VALUES ("GN49_22","002_49_22","GEN","49","22","22","“Joseph mu mayang waen nunguning karogo, yu gotek bo duap te wore toroman; se ko kower maiso namoso ale kar aragoso kiaso komasang ko kaposo wore iwita. ");
INSERT INTO wsk_vpl VALUES ("GN49_23","002_49_23","GEN","49","23","23","Kager kari memek nongomang memek te nunga daga wol kote tagiman. ");
INSERT INTO wsk_vpl VALUES ("GN49_24","002_49_24","GEN","49","24","24","Bare nu gek am baga se kiaram; noko kuting daga wol karogo mu sokel me kuakaso, mu awuk, Jacob ko Kaem Sokel Garagar, Israel ko Bitua Kari, se ko Manga Gek am, mu nu saongam. ");
INSERT INTO wsk_vpl VALUES ("GN49_25","002_49_25","GEN","49","25","25","Joseph, nika niet ko Kaem ni ninguru ka sangarso, Kaem Sokel Garagar melmasak suen biya te marak kisiso: tuwik se worem te munan kisiso, yu ali ningi se yu naguwoso mu te marak kisiso, kuriang suen biya te marak kisiso. ");
INSERT INTO wsk_vpl VALUES ("GN49_26","002_49_26","GEN","49","26","26","Nika niet ko marak kisam mu girakala ko duruk bibiya imi mu nunga kiaram, ale kumik menara mena. Marak suen la ni Joseph kete la nama saparam, se ni ka launuria ningi ni kari dom bagerko. ");
INSERT INTO wsk_vpl VALUES ("GN49_27","002_49_27","GEN","49","27","27","“Benjamin mu kausik diwang bo daong karogo wore iwita bagoso; nu tumongola mel diwang bo moa kam daongaso, ale bainga ningi ko sikisaki arungu mel diwang mu parusuwu numi tui kam melmasak parusuwuso.” ");
INSERT INTO wsk_vpl VALUES ("GN49_28","002_49_28","GEN","49","28","28","Se imi Israel ko kariimet motam 12 mu nunga nonet marak den nongoma nongoma nunga kiwem te iki se nungaram. ");
INSERT INTO wsk_vpl VALUES ("GN49_29","002_49_29","GEN","49","29","29","Tom nu kiti guruga ko den imi nungaram mu nu mam, “Aninga kariimet giriman aniwasan mu nongote namarikko tom pingi aram. Ani agarak nama Heth kari Ephron ko ali te, manga gogong ningi aga beteralko. ");
INSERT INTO wsk_vpl VALUES ("GN49_30","002_49_30","GEN","49","30","30","Manga gogong mu Machpelah aniso, Mamre duap te se Canaan sor te. Manga gogong mu Abraham noko ali motam ko diaram, ale ko ali karogo diaram. ");
INSERT INTO wsk_vpl VALUES ("GN49_31","002_49_31","GEN","49","31","31","Se Abraham ko nuwus Sarah ilak umu te nunga mutim tuguman. Ale Isaac ko nuwus Rebekah ilak umu te tala nunga mutim tuguman. Se ani aga imet Leah kuwim suanta nukung te la mutim tugumem. ");
INSERT INTO wsk_vpl VALUES ("GN49_32","002_49_32","GEN","49","32","32","Abraham ali se manga gogong umu Heth kari nongote dia tam. Se ani umutang te tala aga mutim tugumalko.” ");
INSERT INTO wsk_vpl VALUES ("GN49_33","002_49_33","GEN","49","33","33","Jacob den umu ko namarari nunga manaru saparam, mu nu suwik tagi patatuwu ko anira kuwim te awuram, ale kuamili kutuwam se ko nuet nongotak nogowom karo namaram. ");
INSERT INTO wsk_vpl VALUES ("GN50_1","002_50_1","GEN","50","1","1","Se Joseph ko nuet awote dagulam iluwam ale ilak mokaso. ");
INSERT INTO wsk_vpl VALUES ("GN50_2","002_50_2","GEN","50","2","2","Ale ko ura kari, kari kuera se kumik guang nunga se me iwira, mu nunga maonam se taiman ko nuet Israel kumik guang nungurman. ");
INSERT INTO wsk_vpl VALUES ("GN50_3","002_50_3","GEN","50","3","3","Nuna day 40 ko ningi ura umu bita gilingiman. Ura mu day tom uwutata taso. Se Egypt kariimet day tom 70 ko Jacob ko mo nia lagakasan. ");
INSERT INTO wsk_vpl VALUES ("GN50_4","002_50_4","GEN","50","4","4","Se nongomang bataga se ma niara ko tom mu menaram se Joseph Pharaoh ko ura supuling nunga maonam, “Nina ani ago ko amilmilasan agi mu, aninga den imi tal ale Pharaoh maonalko: ");
INSERT INTO wsk_vpl VALUES ("GN50_5","002_50_5","GEN","50","5","5","Tom aninga ait kuerukko nega se iwita aga maonam, tom nu kueruk mu ani ilak Canaan sor te kuwim nungam wore te ilak nama mutim tugumekko mam. Se ani aing maem, butata bitirikkowo maem. Se aninga angamang mu ni balu se ani aga ait ilak nama mutim tugumek, asele pelerik tairikko.” ");
INSERT INTO wsk_vpl VALUES ("GN50_6","002_50_6","GEN","50","6","6","Se Pharaoh den koma iwita balam, “Mu terong. Nika niet balam se ni aing maem butata ilak nama mutim tugum ale tairko.” ");
INSERT INTO wsk_vpl VALUES ("GN50_7","002_50_7","GEN","50","7","8","Se Joseph nuet mutim tugumokko ilak nama tarigiram. Se Pharaoh ko ura supuling, se Egypt kari bibiya, se Joseph ko imet kuriang, se ko kariimikiri se ko launuria se ko nuet ko kariimikiri suen la nu ilak namaman. Se ura kari sang la kuriang gotektek se sipsip goat bulmakau nunga bitaru se Goshen bagakasan. ");
INSERT INTO wsk_vpl VALUES ("GN50_9","002_50_9","GEN","50","9","9","Karis se kari horse te geragawara mu ago Joseph ilak namaman. Se kariimet umu kariimet motam biya bo nu ilak namaman. ");
INSERT INTO wsk_vpl VALUES ("GN50_10","002_50_10","GEN","50","10","10","Se tom nuna nama Jordan duap te, Atad ko ali wolong na muguri te warsan ale nungursan burangasan mu te, mu nuna biyala mo niakasan. Ale sor mu te week suanta ko Joseph ko nuet ko mo nia lagakaso. ");
INSERT INTO wsk_vpl VALUES ("GN50_11","002_50_11","GEN","50","11","11","Se Canaan kariimet sor umu te bagaman mu ma niara Atad ko sor wolong umu te mu arigiman, ale nunumi manarukasan, “Egypt alo nongomang ninguru batagoso se mo niawasan,” makasan. Bore te se sor Jordan ko duap te umu nup beteman Abel Mizraim maman. ");
INSERT INTO wsk_vpl VALUES ("GN50_12","002_50_12","GEN","50","12","12","Se Jacob ko namarari nu balam butata bita gilingiman. ");
INSERT INTO wsk_vpl VALUES ("GN50_13","002_50_13","GEN","50","13","13","Nuna giman ilak Canaan namaman, ale ali Machpelah, ko mutim gogong Mamre duap te mu ningi mutim tuguman. Ali mu girakala Abraham Heth kari Ephron kote dia tam. ");
INSERT INTO wsk_vpl VALUES ("GN50_14","002_50_14","GEN","50","14","14","Joseph ko nuet mutim tugumam mu nu ko launuria se kariimet ilak namaman mu arungak peleram Egypt namaram. ");
INSERT INTO wsk_vpl VALUES ("GN50_15","002_50_15","GEN","50","15","15","Se Joseph ko launuria mu ko ikiman, nononga nonet mu kueram, buta se nuna nunumi manarukasan, “Joseph pa memek ana nukote beteman mu te sanamaruk ale koma ko nanga bita maguwurokko agi?” makasan. ");
INSERT INTO wsk_vpl VALUES ("GN50_16","002_50_16","GEN","50","16","16","Ale nuna den bo Joseph kote beteman ale manorman, “Nika niet kuerukko se iwita nanga maonam, ");
INSERT INTO wsk_vpl VALUES ("GN50_17","002_50_17","GEN","50","17","17","‘Nina aninga agiring iwita Joseph maonalko,’ mam: ‘Ani iwita balsam, nika launari nika bita maguwuman, bare ni nunga memek mu am siwu nungaruko,’ mam. Buta se ana nika niet ko Kaem ko ura kari, ni ana nanga memek siwu nangaruko wosengasan,” maman. Se Joseph den umu ikiam ale niakaso. ");
INSERT INTO wsk_vpl VALUES ("GN50_18","002_50_18","GEN","50","18","18","Bare ko launuria mu kote taiman ale koma dugu te dagulaman ale maman, “Ana nika ura dungan kari,” maman. ");
INSERT INTO wsk_vpl VALUES ("GN50_19","002_50_19","GEN","50","19","19","Bare Joseph nunga maonam, “Nina me nguangaralko. Ani Kaem mena. ");
INSERT INTO wsk_vpl VALUES ("GN50_20","002_50_20","GEN","50","20","20","Nina ani memek ko lage te iki se aga beteman. Bare Kaem nenenga ikia memek mu tam ale ningo ko lage te beteram. Se aitak bitawoso iwita, kariimet suen la te nunga saongam. ");
INSERT INTO wsk_vpl VALUES ("GN50_21","002_50_21","GEN","50","21","21","Bore te se nina aitak me nguangaralko. Ani nina se ninga kuriang ago ninga sinar taikko.” Ale nu den welang te aking nongomang sokel tuam. ");
INSERT INTO wsk_vpl VALUES ("GN50_22","002_50_22","GEN","50","22","22","Se Joseph, ko launuria, se ko nuet ko kariimet lilim Egypt bagakasan. Nu yia tom 110 ko bagaram. ");
INSERT INTO wsk_vpl VALUES ("GN50_23","002_50_23","GEN","50","23","23","Ale ko namar Ephraim ko gue te ko girigir aratam se arigam. Se Manasseh ko namar Makir ko kuriang bilangaman mu Joseph gomang te nunga awuram ale noko ma balam. ");
INSERT INTO wsk_vpl VALUES ("GN50_24","002_50_24","GEN","50","24","24","Se Joseph ko launuria nunga maonam, “Ani kuerikko tom pingi aram. Bare Kaem nina ninga sanguk ale sor imi te ninga giok ale nengerak ali sor nu balu Abraham Isaac se Jacob nungaram mu te nengerak peleruk namarukko,” mam. ");
INSERT INTO wsk_vpl VALUES ("GN50_25","002_50_25","GEN","50","25","25","Ale Joseph Israel ko namarari nunga maonam se den imi ilak kaloman, “Nunguningta Kaem tairuk ale ninga sangukko. Se tom mu te aninga asokel bilal ale gial ago sor imi beteral ale namaralko,” mam. ");
INSERT INTO wsk_vpl VALUES ("GN50_26","002_50_26","GEN","50","26","26","Ale Joseph motam kuiniram. Noko yia tom mu 110 ko bagaram. Noko kumik guang mu me iwirokko iki se nungurman burangaman, ale Egypt sor te kes ningi beteman. ");
INSERT INTO wsk_vpl VALUES ("RT1_1","009_1_1","RUT","1","1","1","Israel king mena se kari sinar Israel bitaruwakasan ko tom te, karak biya bo sor mu te kaparam. Se Judah sor ko wonong Bethlehem ko kari bo, ko nuwus se ko namarari ilagala mu nunga giam, ale tom tukunangta ko Judah sor beteman ale namaman Moab sor te bagakasan. ");
INSERT INTO wsk_vpl VALUES ("RT1_2","009_1_2","RUT","1","2","2","Kari mu ko nup mu Elimelech, ko nuwus Naomi, se ko namarari Mahlon se Kilion. Nuna Ephrathah (Efrata) kariimet, nunga wonong Bethlehem, Judah sor te, bare namaman Moab bagakasan. ");
INSERT INTO wsk_vpl VALUES ("RT1_3","009_1_3","RUT","1","3","3","Umu te baga Naomi ko kuari Elimelech kueram. Se nu ko namarari ilagala mu nongorak bagakaso. ");
INSERT INTO wsk_vpl VALUES ("RT1_4","009_1_4","RUT","1","4","4","Se nuna Moab imet nunga giman, bo ko nup Orpah, se bo Ruth. Nuna sor mu te yia tom 10 iwita bagaman se ");
INSERT INTO wsk_vpl VALUES ("RT1_5","009_1_5","RUT","1","5","5","Mahlon Kilion ilak agotala kueman. Se Naomi kari se kuriang mena kota bagakaso. ");
INSERT INTO wsk_vpl VALUES ("RT1_6","009_1_6","RUT","1","6","6","Naomi Moab baga se, Yawe ko kariimet nunga ikup arigam ale na inang te nunga saongam mu ko den ikiam ale notonari ago pelemonko nunumi nunguru burangikasan. ");
INSERT INTO wsk_vpl VALUES ("RT1_7","009_1_7","RUT","1","7","7","Nu ko notonari ilagala mu arungu sor te bagaman mu beteman ale peleman Judah sor te namakasan. ");
INSERT INTO wsk_vpl VALUES ("RT1_8","009_1_8","RUT","1","8","8","Nuna aolak ilu se, Naomi ko notonari ilagala mu nunga maonam, “Nina peleral ale ninga ninam nenet alo nongote namaralko. Nina ilagala munan ningo ani se aga namarari ilagala mu nangate beteman, se angamang mu Yawe uwutatala nengete ningo la bitirukko. ");
INSERT INTO wsk_vpl VALUES ("RT1_9","009_1_9","RUT","1","9","9","Se kawam digo iru pueneral agi mu, Yawe ninga kawam digo lilim ago ninga bituok se ningo la bagaralko,” mam. Asele Naomi wete nunga yasaram ale nongorak sail te niakasan. ");
INSERT INTO wsk_vpl VALUES ("RT1_10","009_1_10","RUT","1","10","10","Bare imet ilagala mu manorman, “Mena. Ana am ni kerak ka kariimet nongote namanakko,” maman. ");
INSERT INTO wsk_vpl VALUES ("RT1_11","009_1_11","RUT","1","11","11","Bare Naomi mam, “Aga nanawusari, nina am peleralko. Ani kuriang kari bo ago iluwek se nina nongorak nalko wore asele agarak tairalko. ");
INSERT INTO wsk_vpl VALUES ("RT1_12","009_1_12","RUT","1","12","12","Buta se aga nanawusari, am peleral ale namaralko. Ani garukerem ale kari bo iru taikko iwita mena. Agi terong iwita ikiek ale aitak tirom kari bo taik agi, ale kuriang kari nunga iluwek ta, ");
INSERT INTO wsk_vpl VALUES ("RT1_13","009_1_13","RUT","1","13","13","bare mu nina kari amon se nongorak nalko kimi bita lagaralko tala, se tom ninga kiarukko. Mena, aga nanawusari, nego ko angamang ninguru batagoso. Bare Yawe buring gurugu aisam mu ko ikup aningate mu am biya nunguningkiri!” mam. ");
INSERT INTO wsk_vpl VALUES ("RT1_14","009_1_14","RUT","1","14","14","Asele akingtala biyala niakasan. Se Orpah akingtala nome yasaram ale asele beteram namakaso. Bare Ruth mu Naomi yasaram ale ilukuawuram ilak bagakaso. ");
INSERT INTO wsk_vpl VALUES ("RT1_15","009_1_15","RUT","1","15","15","Se Naomi mam, “Arikko, ka bo mu peleram ko kariimet nongote se ko kaem alo nongote namoso. Ni betela kowom karo ale namarko,” mam. ");
INSERT INTO wsk_vpl VALUES ("RT1_16","009_1_16","RUT","1","16","16","Bare Ruth mam, “Ni ani ka bitirik ale pelerikko me aga diruwurko,” mam. “Ni apareyate namar, mu ani agotala namarikko. Ni apareyate bager, mu ani agotala mu te bagarikko. Nika kariimet mu aninga kariimet tala, se nika Kaem mu aninga Kaem tala. ");
INSERT INTO wsk_vpl VALUES ("RT1_17","009_1_17","RUT","1","17","17","Ni apareyate baga kuar, mu ani umu te tala baga kuerik, se umu te aga mutim tugumonko. Mateng suanta diram ni analak nanga pagukko. Ani aga den balem umu lage bo kigilik te kulukek agi mu, Yawe am ikup memek nunguningkiri aisuokko,” mam. ");
INSERT INTO wsk_vpl VALUES ("RT1_18","009_1_18","RUT","1","18","18","Se tom Naomi nu Ruth ko ikia gomang motam mu uwuta arigam, mu udagi den bo ago me maonam. ");
INSERT INTO wsk_vpl VALUES ("RT1_19","009_1_19","RUT","1","19","19","Buta se Naomi Ruth ilak wete aolak iluman nama Bethlehem arataman. Tom nuna ilagala Bethlehem kasu naguman mu kariimet nungarkaman ale suen la amilmilakasan. Se nunga imet nunumi isarukasan, “Ewere Naomi e?” makasan. ");
INSERT INTO wsk_vpl VALUES ("RT1_20","009_1_20","RUT","1","20","20","Se Naomi nunga maonam, “Udagi ani Naomi ko me aga auralko. Mara ko aga auralko,” mam. “Mu awuk, Yawe Sokel Garagar mu ikup yaman memek aisam. ");
INSERT INTO wsk_vpl VALUES ("RT1_21","009_1_21","RUT","1","21","21","Tom ani wonong beterem namerem mu, ani aga kari, aga kuriang alo, se aga mel ago namerem, bare aitak pelerem mu Yawe agiting ipi agarak peleram tairam. Se Yawe, Kaem Sokel Garagar, mu memek ikup tawun biya aisam. Se nina anape ko Naomi ko aga auralko?” mam. ");
INSERT INTO wsk_vpl VALUES ("RT1_22","009_1_22","RUT","1","22","22","Se Naomi noton Ruth, Moab imet, mu ilak uwutata Moab sor beteman ale peleman. Nuna inang muguri barley masan mu gia ko tom duap bitawaram se tai Bethlehem arataman. ");
INSERT INTO wsk_vpl VALUES ("RT2_1","009_2_1","RUT","2","1","1","Naomi ko kuari Elimelech ko gue suan bo, ko nup mu Boaz, nu kari nup biya. ");
INSERT INTO wsk_vpl VALUES ("RT2_2","009_2_2","RUT","2","2","2","Tom bo Ruth, Moab imet, mu Naomi maonam, “Aninga ikia mu ura kariimet inang barley bataguru giwasan owore nongote namarik, se ura supuling agarkuk ale amilmilaruk agi mu, ani inang batutumu gisan se sang nubiring ko kaposo mu giekko,” mam. Se Naomi mam, “Aga nanawus yawara, mu terong, am namarko,” mam. ");
INSERT INTO wsk_vpl VALUES ("RT2_3","009_2_3","RUT","2","3","3","Se Ruth namaram ale ura kari inang nunguning batutumukasan mu nogowom karo se saki kapakaso mu gikaso. Nu Boaz ko tom luan ningi kaparam ale inang gikaso mu me ko ikikaso tala. Kari Boaz mu Elimelech ko gue suan tala. ");
INSERT INTO wsk_vpl VALUES ("RT2_4","009_2_4","RUT","2","4","4","Tom me maiyam, Boaz Bethlehem mu tairam. Nu ko ura kariimet den amilmil nunga maonam, “Yawe nengerak bagoso!” mam. Se nuna koma balman, “Yawe marak kisokko!” maman. ");
INSERT INTO wsk_vpl VALUES ("RT2_5","009_2_5","RUT","2","5","5","Se Boaz ko ura kari supuling, ura kariimet nunga bitaruwara, mu isuam, “Imet itiwik mu awiri ko?” mam. ");
INSERT INTO wsk_vpl VALUES ("RT2_6","009_2_6","RUT","2","6","6","Se ko ura kari mu mam, “Mu Moab imet itiwik, Naomi ilak Moab sor te wore tairam,” mam. ");
INSERT INTO wsk_vpl VALUES ("RT2_7","009_2_7","RUT","2","7","7","“Nu iwita aga isuam, ‘Ani am ura kari nogowom karik ale na nunguning gisan se saki ali te kaposo mu giekko terong e?’ mam. Ale turomola la wore katir noman me saparam, am ura iluwaram se tai aitakta katirta noman sapawoso se ni taisam,” mam. ");
INSERT INTO wsk_vpl VALUES ("RT2_8","009_2_8","RUT","2","8","8","Se Boaz Ruth maonam, “Aga nanawus, ikiko. Ni tom luan saki ningi me namar ale tom luan imi me bitarko. Ni aninga ura imet kulak arungu pingi bagerko,” mam. ");
INSERT INTO wsk_vpl VALUES ("RT2_9","009_2_9","RUT","2","9","9","“Ale tom luan aguwaya mu te inang bataguru giwasan mu ninguru arik ale kuriang itiwik nogowom karoko. Ani aga ura kari kulak nunga manem, ni kerak me kaemonko. Se tom ni yu ko kuar agi mu, namar ale kari kulak yu ko kuting te utu awuman mu am noko,” mam. ");
INSERT INTO wsk_vpl VALUES ("RT2_10","009_2_10","RUT","2","10","10","Se Ruth bugura kulukam ale koma motam ali te kaparam se maonam, “Ani sor bo iwareng ko imet, bare ni awuk aninga ari ikiem ale munan ningo butata angimik te beterem?” mam. ");
INSERT INTO wsk_vpl VALUES ("RT2_11","009_2_11","RUT","2","11","11","Bare Boaz noko den koma balam ale mam, “Ani ni ka kari kueram se munan suen la ka neme kumik te beterem mu aga manorman se iki saperem. Ale aguwaya ka niet niam nunga beterem, ka sor wonong nunguning beterem, ale sor bo ko kariimet ni girakala me nunga iki ariga wore nunga ningi bagerko tairem. ");
INSERT INTO wsk_vpl VALUES ("RT2_12","009_2_12","RUT","2","12","12","Buta se Yawe, Israel ko Kaem, ni ko luman bowa ningi yumurko tairem, mu nika munan mu ko koma yawara lilim la kisokko,” mam. ");
INSERT INTO wsk_vpl VALUES ("RT2_13","009_2_13","RUT","2","13","13","Se Ruth akingtala mam, “Kari dom, ni munan ningo aningate beterem. Ani nika ura imet bo mena wore, ni den ningo aga manem ale angamang motam sokel tuem se ani amilmilasam,” mam. ");
INSERT INTO wsk_vpl VALUES ("RT2_14","009_2_14","RUT","2","14","14","Se na nana ko tom te mu Boaz nu maonam, “Ewela tair ale aninga bread ewere sang noko. Bread sang to ale waen te ilu se noko,” mam. Se Ruth ura kariimet arungu daigam bagakaso, se Boaz barley nunguning saki tama te kaiman mu Ruth bolala awu tuam. Se nu inang nam nama kumik ago terong mam se ko na nukum mu am anikaso. ");
INSERT INTO wsk_vpl VALUES ("RT2_15","009_2_15","RUT","2","15","15","Tom nu barasam ale akingtala ura taukko namakaso mu te, Boaz ko ura kari nunga maonam, “Nu inang gi gi namaruk ale saki siping ago kutukutuk mam kaparam mu karogo giok, mu am nemetam la arigal, den bo me maonalko, mena. ");
INSERT INTO wsk_vpl VALUES ("RT2_16","009_2_16","RUT","2","16","16","Bare nina giral ale nunguning saki maingkala kalo awura se anira mu sang gial ale am waru awural se aniruk se nu bolala awurok ale giokko. Nu me giokko iwita me maonalko, am ari se bagaral se giokko,” mam. ");
INSERT INTO wsk_vpl VALUES ("RT2_17","009_2_17","RUT","2","17","17","Se Ruth ura towaram la nama sor baingam. Asele ko inang nunguning bolala awuram mu nungam burangaram, ale inang muguri mu giam ale inang te gia ko guang bo biya mu ningi tugumam, ko ikup mu 13 kilogram iwita. ");
INSERT INTO wsk_vpl VALUES ("RT2_18","009_2_18","RUT","2","18","18","Ale giam ago uningi namaram ale nome kausam se arigam. Asele na kowarkalal nam ko nukum mu nome tuam. ");
INSERT INTO wsk_vpl VALUES ("RT2_19","009_2_19","RUT","2","19","19","Se nome nu isuam, “Ni aitak awiri ko tom luan ningi na nunguning bolala awurem? Kari awiriya ni karkam ale ka saongam mu mel ningo ningo kote kapa tui se lagarukko!” mam. Se nu awiriya kote tom luan ningi inang muguri giam mu ko balam gurugam, ale mam, “Kari mu ko nup Boaz i,” mam. ");
INSERT INTO wsk_vpl VALUES ("RT2_20","009_2_20","RUT","2","20","20","Se Naomi “Aik e?” mam. “Yawe marak ningo tuokko!” mam. Ale noton maonam, “Yawe kariimet kuera se kariimet marak bagara mu ningo la nongote beteso.” Ale mam, “Kari mu anananga gue suan bo, se nu anananga saonga ko ura mu ko kuting te aniso tala,” mam. ");
INSERT INTO wsk_vpl VALUES ("RT2_21","009_2_21","RUT","2","21","21","Se Ruth, Moab imet, mu balam, “Mel bo tala, Boaz ani aking pelerik namarik ale ura iluwekko aga maonam. Nu mam ani noko ura imet arungu pingi la ura ilu sagarik se nama na nunguning bolala awura ko ura mu menarukko mam.” ");
INSERT INTO wsk_vpl VALUES ("RT2_22","009_2_22","RUT","2","22","22","Se Naomi nu maonam, “Mu yawarakala! Ni noko ura imet itiwik arungu am ura toko. Ni tom luan bo kigilik ningi ura iluwer se kariimet i bo ka bita maguwurok bore ko,” mam. ");
INSERT INTO wsk_vpl VALUES ("RT2_23","009_2_23","RUT","2","23","23","Buta se Ruth namaram ale Boaz ko ura imet itiwik arungu pingi la ura iluwakaso. Nu ura iluwaram la, barley se wheat nunguning te bolala awura ko tom mu menaram. Se Ruth eng am nome ilak umu te bagakaso. ");
INSERT INTO wsk_vpl VALUES ("RT3_1","009_3_1","RUT","3","1","1","Tom bo Naomi noton Ruth iwita maonam, “Aga nanawus, ani kari bo arigek se ni kerak nauk ale nika bituok se ni terong la bagerko. ");
INSERT INTO wsk_vpl VALUES ("RT3_2","009_3_2","RUT","3","2","2","Se ni ko ikisam, Boaz, ni ko ura imet kulak nongorak ura tokasam mu anananga gue suan bo. Se aitak tirom mu nu barley te nunga burangara ko kuwim mu te ura iluwokko. ");
INSERT INTO wsk_vpl VALUES ("RT3_3","009_3_3","RUT","3","3","3","Buta se ni guru, ka guang ningo nunguning mu tugum, ale oil siring yawara mu kimik te sapar, ale kuwim te ura towoso mu te nama kapar, bare ni mu te nama kaperem mu me nimi sapar se ko ikiokko, am nimi kaluwur ale bager se nu ko yu inang no kutuwurokko. ");
INSERT INTO wsk_vpl VALUES ("RT3_4","009_3_4","RUT","3","4","4","Ale tom nu anirokko namaruk mu, ni nu kuwim apareya te taga aniso mu ni ninguru arikko. Asele namar, ale ko guang numi te iram mu kinikan sang patawur ale kumik duap te taga anirko. Asele aguwaya mu nu nika manuk se ikiko,” mam. ");
INSERT INTO wsk_vpl VALUES ("RT3_5","009_3_5","RUT","3","5","5","Se Ruth mam, “Ani ni balem mu butata bitirikko,” mam. ");
INSERT INTO wsk_vpl VALUES ("RT3_6","009_3_6","RUT","3","6","6","Asele nu ko nome balam butata kuwim mu te nama kaparam. ");
INSERT INTO wsk_vpl VALUES ("RT3_7","009_3_7","RUT","3","7","7","Se tom Boaz na yu no kutuwuram mu nu amilmil te nama lagaram ale dun te biya, kuwim inang muguri te bolala awuman mu te taga aniram. Se Ruth kumik nirung mena kote namaram ale guang numi te iram mu dun sang patawuram ale kumik duap te taga aniram. ");
INSERT INTO wsk_vpl VALUES ("RT3_8","009_3_8","RUT","3","8","8","Se Boaz aniram nama mung lukan ta, mel bo kumik duap te iwita ko ikiam, ale numi gurugam mu imet bo kumik duap te aniwaram se arigam, ale tingam, ");
INSERT INTO wsk_vpl VALUES ("RT3_9","009_3_9","RUT","3","9","9","ale “Ni awiri ya?” mam. “Ani Ruth i, nika bitua bowa ningi bagasam. Ka guang dun saki te aga irako, mu awuk, aninga sinar ta ko ura mu ni kiting te aniso tala,” mam. ");
INSERT INTO wsk_vpl VALUES ("RT3_10","009_3_10","RUT","3","10","10","Se Boaz mam, “Aga nanawus, Yawe ni kerak bagoso,” mam. “Ni ka kilek ningo aitak beterem imi mu nika kilek ningo ekela uleng beterem mu kia saparam. Ni kari kulak suen biya, nungumik mel ago se nungumik mel mena bagasan, bare ni nunga kamin me tugumem. ");
INSERT INTO wsk_vpl VALUES ("RT3_11","009_3_11","RUT","3","11","11","Buta se aga nanawus, me nguangerko. Ni anapeya ko balu mu ani am bita saparikko. Aninga kariimet aga wonong suan alo mu suen la ko ikisan, ni imet ningo bo. ");
INSERT INTO wsk_vpl VALUES ("RT3_12","009_3_12","RUT","3","12","12","Se mu nunguningta, ani nika kari ko gue suan bo, se nika bitua ko ura mu ani agiting te aniso tala. Bare anananga bo tala aninga ilu kia kam, nu nunguningkiri nika bituokko mu bagoso tala. ");
INSERT INTO wsk_vpl VALUES ("RT3_13","009_3_13","RUT","3","13","13","Bare tirom imi, imi te bager, ale turomola asele ani ko ikiek, nu nika bituokko amilmilaruk, mu terong, nika bituokko. Bare nu uwuta bitirukko me kueruk agi mu, nunguningta nunguningkiri Yawe marak bagoso se ani balsam, ani ka bituekko. Se aitak tirom imi ko mu imi te anir ale asele ko,” mam. ");
INSERT INTO wsk_vpl VALUES ("RT3_14","009_3_14","RUT","3","14","14","Se Ruth nu kumik duap te aniram nama ukiram. Bare munumuning ago, kariimet numi koma arigokko me terong la, nu barasam. Se Boaz maonam, “Kariimet bo ni imi te tairem mu me ta ko ikiokko,” mam. ");
INSERT INTO wsk_vpl VALUES ("RT3_15","009_3_15","RUT","3","15","15","Ale nu maonam, “Marir ko guang kimik te irem sowore karogo tai ulaluwurko,” mam. Se Ruth butata beteram. Se Boaz barley nunguning sang ningi waram, ko ikup mu 20 kilogram iwita, asele patawu tuam se giam ale peleram wonong te namaram. ");
INSERT INTO wsk_vpl VALUES ("RT3_16","009_3_16","RUT","3","16","16","Se Ruth peleram nama nome kote namaram, se Naomi nu isuam, “Aga nanawus, awuk? Dun awuk? Awuk aratam?” mam. Se Ruth munan suen biya Boaz nukote beteram mu maonam se iki saparam. ");
INSERT INTO wsk_vpl VALUES ("RT3_17","009_3_17","RUT","3","17","17","“Se barley nunguning ko ikup 20 kilogram imi tugu aisu se mam, ni kiting ipi piler ale ka neme kote me namarko mam.” ");
INSERT INTO wsk_vpl VALUES ("RT3_18","009_3_18","RUT","3","18","18","Se Naomi mam, “Aga nanawus, ni me neger, ni am baga asele anapeya aratuk mu ko ikiko. Mu awuk, kari umu ikia am moawuruk se dun imi aitakta la nungok se ikikowo,” mam. ");
INSERT INTO wsk_vpl VALUES ("RT4_1","009_4_1","RUT","4","1","1","Tom me maiyam se Boaz nama tarigiram ale wonong ko lage kuring ago biguwura kuwim mu te dagiwaram. Se tom noko gue suan bo, nu ko Ruth maonam, mu tairam, mu nu maonam, “Aga bo, iwita tair ale dagiko,” mam. Se kari mu namaram ale daigam. ");
INSERT INTO wsk_vpl VALUES ("RT4_2","009_4_2","RUT","4","2","2","Se Boaz wonong ko kari dom nunga tom kuting koma singsang nunga giam ale nunga maonam, “Nina iwita tai daigalko,” mam, se tai dagiman. ");
INSERT INTO wsk_vpl VALUES ("RT4_3","009_4_3","RUT","4","3","3","Asele nu ko gue suan mu maonam, “Naomi, Moab sor te baga tairam, mu ni analak nanga launuria Elimelech ko ali bilik wore awiriya diarukko wore ko ilu arigiso. ");
INSERT INTO wsk_vpl VALUES ("RT4_4","009_4_4","RUT","4","4","4","Ani ko ikiem, ani mel imi am ko ka manik se ikiko, mu awuk, ni mu mel imi ko kotam gira nunguning. Ani iwita nika manaru se nika isuek se ni kari dom imi te dagiwasan nomokete se aninga kariimet nomokete ni ali mu dierko, mu dierko. Bare mena agi mu, wetang la aga manaru se ikiekko. Mu awuk, kariimet bo kilimik mel imi ko kotam mena. Mu ni gira se ani ka atumukira bagasam,” mam. Se ko gue suan mu balam, “Ani diarikkowo,” mam. ");
INSERT INTO wsk_vpl VALUES ("RT4_5","009_4_5","RUT","4","5","5","Asele Boaz nu maonam, “Buta se tom ni Naomi se Ruth, Moab imet, mu nongote ali mu dier, mu ni kari kueram mu ko imet gerewa karogo to se noko nup se ko melmasak mu me yumu maga namarukko,” mam. ");
INSERT INTO wsk_vpl VALUES ("RT4_6","009_4_6","RUT","4","6","6","Uwuta balam mu te aking ko gue suan mu mam, “Buta mu ani ali mu me diarikko. Ani buta bitirik, bare ani agata aga kuriang gue nunga melmasak maguwurik bore ko,” mam. Ale “Ni dierko,” mam. “Ani diarikko iwita me ikisam,” mam. ");
INSERT INTO wsk_vpl VALUES ("RT4_7","009_4_7","RUT","4","7","7","Girakala Israel alo nunga munan te mu, kariimet bo, bo kote mel diaso ale taukko, mu nu agi ko komasang mu suwik gomang kutuwu komasang mu tuokko. Nuna kilek umu te munan umu te sokel tusan. ");
INSERT INTO wsk_vpl VALUES ("RT4_8","009_4_8","RUT","4","8","8","Se Boaz ko bo mu nu maonam, “Ni keta dierko,” ma se nu suwik gomang kutuwuram. ");
INSERT INTO wsk_vpl VALUES ("RT4_9","009_4_9","RUT","4","9","9","Asele Boaz kari dom alo se kariimet suen la nunga maonam, “Aitak nina munan imi nemetam te arigiman. Ani Naomi kote Elimelech se Kilion se Mahlon nunga melmasak lilim dia tasam bo. ");
INSERT INTO wsk_vpl VALUES ("RT4_10","009_4_10","RUT","4","10","10","Ale Ruth, Moab imet, Mahlon ko nuwus gerewa, mu aninga aiwus arukko. Ani munan imi te kari kueram umu ko nup se ko melmasak suen biya ko gue suan nunga ningi se wonong lilim ningi me yumu namarukko. Nina suen la munan imi nemetam nede te ari iki sapaman, se mu butata anirukko!” mam. ");
INSERT INTO wsk_vpl VALUES ("RT4_11","009_4_11","RUT","4","11","11","Se kari dom alo se kariimet suen la wonong ko lage kuring ko bagaman mu balman, “Ana nanga namotam nade te ko ari iki sapaman,” maman. “Yawe imet nika kawam pueneso mu sanguk, se nu Rachel se Leah ilak nunga kuriang gue te kariimet motam biya Israel aratam, iwita bagarukko. Se ni mu sokel ago ka gue suan Ephrath alo nunga ningi, se Bethlehem wonong ningi nip ago bagerko. ");
INSERT INTO wsk_vpl VALUES ("RT4_12","009_4_12","RUT","4","12","12","Se Yawe nu imet kulak imi kumik te, kuriang gue suen biya kapa kisokko, se Judah Tamar ilak nutagu te Perez ko kuriang kapaman iwita kapamonko.” ");
INSERT INTO wsk_vpl VALUES ("RT4_13","009_4_13","RUT","4","13","13","Se Boaz nu Ruth noko imet ko tam, ale ilak bagaram. Se Yawe nunga saongam se Ruth tuagu aratam, se kuriang kari bo iluwam. ");
INSERT INTO wsk_vpl VALUES ("RT4_14","009_4_14","RUT","4","14","14","Se wonong ko imet suen la mu Naomi manarukasan, “Yawe nup patawunakko, mu awuk, nuguta ni ka nimas imi ka sangukko kisam. Se nu nup ago Israel alo nunga ningi bagarukko! ");
INSERT INTO wsk_vpl VALUES ("RT4_15","009_4_15","RUT","4","15","15","Nu ni amilmil kisok, ale tom ni garuker mu nu ninguru ka sangukko. Munan bo kuriang kari seven ta me kete betemonko koma, bare nika neton, ninguru ka kueso, imi kete beteram ale nimas imi ilu kisam,” makasan. ");
INSERT INTO wsk_vpl VALUES ("RT4_16","009_4_16","RUT","4","16","16","Se Naomi kuriang patawuram kualuwong te beteram ale ko sinar tokaso. ");
INSERT INTO wsk_vpl VALUES ("RT4_17","009_4_17","RUT","4","17","17","Se imet umu te bagara mu balukasan, “Naomi ko namar ago,” makasan. Ale nup beteman Obed i maman. Obed tuagu te mu Jesse bilangaram, se Jesse tuagu te mu David bilangaram. ");
INSERT INTO wsk_vpl VALUES ("RT4_18","009_4_18","RUT","4","18","18","Imi mu Perez ko kuriang gue luan namaram wore nunga nunup: Perez tuagu te mu Hezron, ");
INSERT INTO wsk_vpl VALUES ("RT4_19","009_4_19","RUT","4","19","19","se Hezron tuagu te mu Ram, se Ram tuagu te mu Amminadab, ");
INSERT INTO wsk_vpl VALUES ("RT4_20","009_4_20","RUT","4","20","20","se Amminadab tuagu te mu Nahshon, se Nahshon tuagu te mu Salmon, ");
INSERT INTO wsk_vpl VALUES ("RT4_21","009_4_21","RUT","4","21","21","se Salmon tuagu te mu Boaz, se Boaz tuagu te mu Obed, ");
INSERT INTO wsk_vpl VALUES ("RT4_22","009_4_22","RUT","4","22","22","se Obed tuagu te mu Jesse, se Jesse tuagu te mu David. ");
INSERT INTO wsk_vpl VALUES ("PS1_1","020_1_1","PSA","1","1","1","Awiriya kariimet memek nunga ikia me karo tuso, ale kariimet memek betesan mu nunga nomolak me karoso, agi kariimet den nunguning mu mel yam ko betera mu arungu me dagiso, mu nu amilmil ago bagarukko. ");
INSERT INTO wsk_vpl VALUES ("PS1_2","020_1_2","PSA","1","2","2","Nu Yawe ko den ninguru ko amilmiloso, ale tirom woremkalal den mu ko kuamin tugu se lagoso. ");
INSERT INTO wsk_vpl VALUES ("PS1_3","020_1_3","PSA","1","3","3","Kari umu nu tam yu norogen te aguwa se baga ko tom te nunguning kapa se gawa me marakaso wore toroman. Se nu anapeya nungurso mu am ningo la arataso. ");
INSERT INTO wsk_vpl VALUES ("PS1_4","020_1_4","PSA","1","4","4","Kariimet memek mu uwuta mena. Nuna tam gawa merang daula itugu warso iwitata. ");
INSERT INTO wsk_vpl VALUES ("PS1_5","020_1_5","PSA","1","5","5","Buta se kariimet memek alo mu tutera kam te koma memek tamonko; nuna kariimet ningo diram mu nunga biguwura ningi me bagamonko. ");
INSERT INTO wsk_vpl VALUES ("PS1_6","020_1_6","PSA","1","6","6","Mu awuk, Yawe mu kariimet ningo diram mu nunga bagara aolak bitaruwoso; bare kariimet memek alo mu sarenga namamonko. ");
INSERT INTO wsk_vpl VALUES ("PS2_1","020_2_1","PSA","2","1","1","Awuk se ali sor lilim la ko kariimet nongomang magoso se ikia memek duap duap betemonko den kalosan? Mu kalomon ale betemon, bare nunguning mena. ");
INSERT INTO wsk_vpl VALUES ("PS2_2","020_2_2","PSA","2","2","2","Ali sor lilim la ko supuling nongomang suan awuman ale Yawe se ko kari atumukiram mu nongorak dun kopa ilumonko den kaloman: ");
INSERT INTO wsk_vpl VALUES ("PS2_3","020_2_3","PSA","2","3","3","“Ana nuguring bowa ningi me baganakko, ana mayang umu batutumunak ale nunga betenak tagi tanakko.” ");
INSERT INTO wsk_vpl VALUES ("PS2_4","020_2_4","PSA","2","4","4","Bare Yawe duruk uningi daigam baga se nunga gusirso, ale nunga den kolara balso. ");
INSERT INTO wsk_vpl VALUES ("PS2_5","020_2_5","PSA","2","5","5","Ale gomang maga se ining nungarso, ale nguangara nungarso, ale balso, ");
INSERT INTO wsk_vpl VALUES ("PS2_6","020_2_6","PSA","2","6","6","“Kari ani king ko bagarukko balem mu ani marak tuem se aninga duruk laili Zion mu te bagoso.” ");
INSERT INTO wsk_vpl VALUES ("PS2_7","020_2_7","PSA","2","7","7","Ani Yawe den balam mu balikko: Nu iwita aga maonam, “Ni aninga kuriang, se aitak ani nika niet bagasam. ");
INSERT INTO wsk_vpl VALUES ("PS2_8","020_2_8","PSA","2","8","8","Ni aninga isaru se ani ali lilim la, se ko kariimet ago kisekko. ");
INSERT INTO wsk_vpl VALUES ("PS2_9","020_2_9","PSA","2","9","9","Se ni supuling ura ko tam aora mu te nunga bitaruko, ale kani iwita nunga pakakur se bilik bilik kapamonko.” ");
INSERT INTO wsk_vpl VALUES ("PS2_10","020_2_10","PSA","2","10","10","Buta se, nina king alo, ikia sinar ago la bagaralko; nina ali sor ko supuling alo, ninguru sinar talko. ");
INSERT INTO wsk_vpl VALUES ("PS2_11","020_2_11","PSA","2","11","11","Yawe ko nguanga se kua bowa nagural ale amilmil tualko. ");
INSERT INTO wsk_vpl VALUES ("PS2_12","020_2_12","PSA","2","12","12","Nina king alo, noko namar suwik duap ningi nebugura kulukalko. Mena mu, noko gomang magara mu tairatela barasuk ale ninga menawurokko. Ikialko. Kariimet arikaya nu nunga yumura kuwim ko arigisan mu amilmilamonko. ");
INSERT INTO wsk_vpl VALUES ("PS3_1","020_3_1","PSA","3","1","1","(David king ko bagakaso, bare noko kuriang Absalom noko ura nu taukko ago kaeyakaso, se David Absalom ko nagu se den imi balam) O Yawe, ani ago ko kager kari memek suen biya! Nuna suen biya nunguningkiri ani agarak kagerawasan! ");
INSERT INTO wsk_vpl VALUES ("PS3_2","020_3_2","PSA","3","2","2","Ale nuna ani ago ko balsan, “Kaem nu me sangukko pa!” masan. ");
INSERT INTO wsk_vpl VALUES ("PS3_3","020_3_3","PSA","3","3","3","Bare Yawe, ni keta suanta aninga karem se ni aninga lautem; ni aninga kager menawusam ale nup biya se sokel aisisam. ");
INSERT INTO wsk_vpl VALUES ("PS3_4","020_3_4","PSA","3","4","4","Ani Yawe kote sail ago niasam, se nu ko duruk laili mu te baga se agiring iluso. ");
INSERT INTO wsk_vpl VALUES ("PS3_5","020_3_5","PSA","3","5","5","Ani taga anisam, ale anisam; ale ukiso se barasasam; Yawe aga bitarso se memek bo me arigisam. ");
INSERT INTO wsk_vpl VALUES ("PS3_6","020_3_6","PSA","3","6","6","Ani kager kari memek suen biya nunguningkiri aga laturu sapaman, bare ani me ta nguangasam. ");
INSERT INTO wsk_vpl VALUES ("PS3_7","020_3_7","PSA","3","7","7","O Yawe, aninga Kaem, bares ale aga bataguru toko! Ni kari memek alo nogol kulukumur ale nogore motam biagerko. ");
INSERT INTO wsk_vpl VALUES ("PS3_8","020_3_8","PSA","3","8","8","O Yawe, ni keta anananga Bataguru Ta Kari. Nika kariimet marak nungaruko. ");
INSERT INTO wsk_vpl VALUES ("PS4_1","020_4_1","PSA","4","1","1","(David ko wur) O aninga Kaem ningo diram, ani nikate airik mu agiring ilupko! Ani ikup memek ningi bagasam ewere te aga sangaru se aeman saparikko; nika gemang aisu ale aga wosenga ikiko. ");
INSERT INTO wsk_vpl VALUES ("PS4_2","020_4_2","PSA","4","2","2","O kariimet, nina tom amaru te aninga Kaem yawara nibiring tua ko munan mu bita talko ya? Ale mel duap duap nunguning mena ko kuesan mu se, kaem kawel nunup patawuwasan mu nibiring tualko ya? ");
INSERT INTO wsk_vpl VALUES ("PS4_3","020_4_3","PSA","4","3","3","Nina ninguru ikialko: Yawe kariimet ningo diram mu nunga balam noko mam; se ani Yawe arusam mu nu ani agiring ikiso. ");
INSERT INTO wsk_vpl VALUES ("PS4_4","020_4_4","PSA","4","4","4","Nina nguanga se munan memek me beteralko; ninga anira kuwim te taga aniral kutek mal ale nengemang motam ninguru ko ikialko. ");
INSERT INTO wsk_vpl VALUES ("PS4_5","020_4_5","PSA","4","5","5","Yawe tama bita tua mu diram la beteral, ale nu la kote loaga se lagaralko. ");
INSERT INTO wsk_vpl VALUES ("PS4_6","020_4_6","PSA","4","6","6","Kariimet suen biya esesan, “Awiri nanga sanguk se daiga bagara ningo ariginakko?” masan. Se Yawe, nika gemang lila te ka ningo nuam anananga nangimik te bitarko. ");
INSERT INTO wsk_vpl VALUES ("PS4_7","020_4_7","PSA","4","7","7","Se tom na inang se waen iru sor magaruk mu ani ninguru amilmilarikko. ");
INSERT INTO wsk_vpl VALUES ("PS4_8","020_4_8","PSA","4","8","8","O Yawe, ni la aga bitarsam, se ani terong bagasam. Buta se ani mel bo ko me nguangasam; ani taga anisam mu lila te ani kuesam. ");
INSERT INTO wsk_vpl VALUES ("PS5_1","020_5_1","PSA","5","1","1","(David ko wur) O Yawe, ni aninga aira ikiko; de gurugu ale aga angamang niara ikiko! ");
INSERT INTO wsk_vpl VALUES ("PS5_2","020_5_2","PSA","5","2","2","Ni aga King se aga Kaem, aga aira iki ale aga sangaruko! Ani nikate diram guranek betesam. ");
INSERT INTO wsk_vpl VALUES ("PS5_3","020_5_3","PSA","5","3","3","Yawe, ni turomola pempem aninga guranek ikisam; aninga aira nikate betesam ale koma ko angimik bita lagasam. ");
INSERT INTO wsk_vpl VALUES ("PS5_4","020_5_4","PSA","5","4","4","Ni Kaem, ni munan memek ko me amilmilasam; kariimet memek alo mu ni kerak me bagamonko. ");
INSERT INTO wsk_vpl VALUES ("PS5_5","020_5_5","PSA","5","5","5","Nunumi patawura ko kariimet alo mu ni kema te me bagamonko; mu awuk, kariimet memek betesan mu ni me nunga kuesam. ");
INSERT INTO wsk_vpl VALUES ("PS5_6","020_5_6","PSA","5","6","6","Den nunguning me bala ko kariimet mu ni nunga maguwusam; ale nuguting gue ago mu se, kawel ko kariimet mu ni me ta nunga kuesam nunguningkiri. ");
INSERT INTO wsk_vpl VALUES ("PS5_7","020_5_7","PSA","5","7","7","Bare ani nika gemang lila biya mu te se, nika kuwim laili ningi am tairikko; ani aimi karogo kapa se, angama ka temple laili mu tuek ale abugura kulukekko. ");
INSERT INTO wsk_vpl VALUES ("PS5_8","020_5_8","PSA","5","8","8","Yawe, aninga kager kari alo suen biya anisan; buta se ni ka munan ningo diram mu te aga lage dingumur ale agarak namarko. ");
INSERT INTO wsk_vpl VALUES ("PS5_9","020_5_9","PSA","5","9","9","Den nuguring te arataso mu am kawel la; nunga nongomang motam mu bo maguwura ko kiwem karogo terong mam. Nunga nodogotak nuguring mu kuera ko mutim iwitata; se nunga nungamili mu den kawel te balsan. ");
INSERT INTO wsk_vpl VALUES ("PS5_10","020_5_10","PSA","5","10","10","Buta se Kaem, ni koma memek nungaruko! Nongota nunga ikia memek betesan umu nunga taliparuk se memek tamonko. Nunga memek suen biya mu koma ko nunga karoko, mu awuk, nuna ni kiring batagorman ko moke. ");
INSERT INTO wsk_vpl VALUES ("PS5_11","020_5_11","PSA","5","11","11","Bare kariimet nika kuesan ale ni nunga sangaruko kete taisan, mu ni nunga bitarsam, se nuna amilmilamon ale amilmil te wur ilu se lagamonko. ");
INSERT INTO wsk_vpl VALUES ("PS5_12","020_5_12","PSA","5","12","12","Mu awuk, ni kariimet ningo diram mu marak nungarsam; Yawe, ni nunga kuesam, ale nunga karem iwita nunga kaluwusam. ");
INSERT INTO wsk_vpl VALUES ("PS6_1","020_6_1","PSA","6","1","1","(David ko wur) O Yawe, ani ago ko gemang magaruk se me aga biriruwurko; ka gemang magara te memek te me aga bitarko. ");
INSERT INTO wsk_vpl VALUES ("PS6_2","020_6_2","PSA","6","2","2","Ani angimik sokel mena kaparam; se ago ko neman bataguk se gemang aisuko; angimik sokel yaman iki se aniso, se ni sokel iru aisuko. ");
INSERT INTO wsk_vpl VALUES ("PS6_3","020_6_3","PSA","6","3","3","Ani angamang tuagu ikup biya; se ni tom amaru te aninga sangaruko? ");
INSERT INTO wsk_vpl VALUES ("PS6_4","020_6_4","PSA","6","4","4","O Yawe, tair ale aga sangaruko; gemang aisu ale kuera lage te bagasam mu aga sangaruko. ");
INSERT INTO wsk_vpl VALUES ("PS6_5","020_6_5","PSA","6","5","5","Ni ikisam, kariimet kuera mu nika nip biya ko balmonko me terong; se kuera iwiwara ko kuwim te mu awiri nika nip patawurukko terong? Mena. ");
INSERT INTO wsk_vpl VALUES ("PS6_6","020_6_6","PSA","6","6","6","Ani niara te angimik sokel mena saparam; tirom suen biya aninga amononge kapa lagoso, se aninga anira kuwim pupurut pagoso. ");
INSERT INTO wsk_vpl VALUES ("PS6_7","020_6_7","PSA","6","7","7","Ani angimik ko kager kari suen biya, se ani nia mo lagasam, ale amotam kui laga muruwuram, se ani sor arigekko me terong. ");
INSERT INTO wsk_vpl VALUES ("PS6_8","020_6_8","PSA","6","8","8","Nina kari memek, tagi talko! Mu awuk, Yawe aninga niara ikiam. ");
INSERT INTO wsk_vpl VALUES ("PS6_9","020_6_9","PSA","6","9","9","Ani nu aga sangukko aurem, se ikiam ale agiring iluwam. ");
INSERT INTO wsk_vpl VALUES ("PS6_10","020_6_10","PSA","6","10","10","Se aninga bita maguwura ko kari mu nguangara dolara nunga iramurok se nongoma kaluwu namamonko. ");
INSERT INTO wsk_vpl VALUES ("PS7_1","020_7_1","PSA","7","1","1","(David nu Benjamin ko kari Cush munan beteram wore ko iki se wur imi iluwam) O Yawe, aninga Kaem, ni aninga yumura kuwim; kari aga momonko aga karowasan, se aga sangaru ale aga bataguru toko. ");
INSERT INTO wsk_vpl VALUES ("PS7_2","020_7_2","PSA","7","2","2","Mena mu, nuna lion iwita aga batutumumon se katir katir kaparikko, se kariimet bo aga sangukko mena. ");
INSERT INTO wsk_vpl VALUES ("PS7_3","020_7_3","PSA","7","3","3","O Yawe, aninga Kaem, ani memek i bo bitirik se ko ikup angimik te aniruk, ");
INSERT INTO wsk_vpl VALUES ("PS7_4","020_7_4","PSA","7","4","4","agi aga tiran yawara ikup te bitirik, agi aga kager kari duap mena nunga bita maguwurik mu asele, ");
INSERT INTO wsk_vpl VALUES ("PS7_5","020_7_5","PSA","7","5","5","am agarkiwer se, aga kager kari aga ilumon ale aga momon maguwumon ale ali te aga sapamon se kua namarikko. Bare ani memek bo me beterem. ");
INSERT INTO wsk_vpl VALUES ("PS7_6","020_7_6","PSA","7","6","6","Buta se Yawe, gemang memek te bares ale kari agarak bita karowasan mu nunga maguwurko! Aninga Kaem, munan diram mu ko sokel ago baluko. ");
INSERT INTO wsk_vpl VALUES ("PS7_7","020_7_7","PSA","7","7","7","Se mu ko, ni kariimet suen la kimik duap te nunga bolala awur ale nika daiga kuwim kualala mu te baga se ");
INSERT INTO wsk_vpl VALUES ("PS7_8","020_7_8","PSA","7","8","8","suen la nunga tutia saparko. Ale Yawe, aninga munan diram mu ko aga wetang saparko, O Kaem Kalel Biya. ");
INSERT INTO wsk_vpl VALUES ("PS7_9","020_7_9","PSA","7","9","9","Kariimet memek alo imi nunga munan memek mu menawur se kariimet ningo mu terong bagamonko, mu awuk, ni munan diram ko Kaem; ni kariimet nunga ikia nunga nongomang motam ko iki sapasam. ");
INSERT INTO wsk_vpl VALUES ("PS7_10","020_7_10","PSA","7","10","10","Kaem Kalel Biya mu aninga karem; nu kariimet nongomang diram mu nunga sangaru taso. ");
INSERT INTO wsk_vpl VALUES ("PS7_11","020_7_11","PSA","7","11","11","Nu tutera ura diram la beteso; nu pempem ko gomang magara wetang saposo. ");
INSERT INTO wsk_vpl VALUES ("PS7_12","020_7_12","PSA","7","12","12","Se kariimet bo me giris palaguk mu sinar taukko: Kaem ko batir kore iluwam, ale ko daga wol tagiram ale sinar ago bagoso. ");
INSERT INTO wsk_vpl VALUES ("PS7_13","020_7_13","PSA","7","13","13","Nu kager ko mel nungam burangaram, ale gatu kore tamatama mu gi awuram se aniso. ");
INSERT INTO wsk_vpl VALUES ("PS7_14","020_7_14","PSA","7","14","14","Ikialko! Kari memek alo ikia memek betemonko ko ikia tasan, kawel betemonko ko den nungursan, ");
INSERT INTO wsk_vpl VALUES ("PS7_15","020_7_15","PSA","7","15","15","ale kari saki te ningi dagulamonko mutim isan, bare mu nongota aking ningi dagulasan. ");
INSERT INTO wsk_vpl VALUES ("PS7_16","020_7_16","PSA","7","16","16","Nuna nongota nunga ikia memek betesan umutang te memek to gilingisan; ale nongota kager daong betesan mu aking peleso nongota nunga moso. ");
INSERT INTO wsk_vpl VALUES ("PS7_17","020_7_17","PSA","7","17","17","Ani wur te Yawe Kaem Kalel Biya mu nup patawurikko, ale noko munan diram la mu ko amilmil tuekko. ");
INSERT INTO wsk_vpl VALUES ("PS8_1","020_8_1","PSA","8","1","1","(David ko wur) O Yawe, anananga Biya, nika nip biya ali lilim iramuram! Se taiti gomang lilim te nika nip biya wetang awurem. ");
INSERT INTO wsk_vpl VALUES ("PS8_2","020_8_2","PSA","8","2","2","Ni kuriang gotektek nuguring te nup biya tasam, ale mu nika sokel aora garagar mu wetang saposo, se kariimet ni kerak barimawara mu nuguring menaso. ");
INSERT INTO wsk_vpl VALUES ("PS8_3","020_8_3","PSA","8","3","3","Tom ani taiti gomang te loagasam ale nika kiting kiwol sige se baras nunga kuwim kuwim te nunga awurem mu arigisam, mu ani ikia tasam: ");
INSERT INTO wsk_vpl VALUES ("PS8_4","020_8_4","PSA","8","4","4","Bare ana kariimet mu anape mel nunguningkiri se ni ana mel biya ko nanga betesam, ale ninguru nanga bitarsam? ");
INSERT INTO wsk_vpl VALUES ("PS8_5","020_8_5","PSA","8","5","5","Ni keta nimi ari se nanga nungem, ale am nika bowa ningi nunguningkiri nanga awurem, ale nikim se nup biya nangarem. ");
INSERT INTO wsk_vpl VALUES ("PS8_6","020_8_6","PSA","8","6","6","Ni mel suen la ana nabowa ningi awurem, ale ana bitarnakko balem: ");
INSERT INTO wsk_vpl VALUES ("PS8_7","020_8_7","PSA","8","7","7","sipsip se bulmakau, se giarum ningi ko melmasak, ");
INSERT INTO wsk_vpl VALUES ("PS8_8","020_8_8","PSA","8","8","8","se inangnang binga geragasan, se wal se mel suen la gagi ningi geragasan, mu bitaru sapanakko balem. ");
INSERT INTO wsk_vpl VALUES ("PS8_9","020_8_9","PSA","8","9","9","O Yawe, anananga Biya, nika nip biya ali lilim iramuram! ");
INSERT INTO wsk_vpl VALUES ("PS9_1","020_9_1","PSA","9","1","1","(David ko wur) O Yawe, ani angamang motam lilim la te ka nip patawurikko; ani nika kiwem bibiya duap duap beterem wore ko balikko. ");
INSERT INTO wsk_vpl VALUES ("PS9_2","020_9_2","PSA","9","2","2","Ani angamang motam ningo te nika amilmilarikko; O Kaem Kalel Biya, ani wur te nika nip patawurikko. ");
INSERT INTO wsk_vpl VALUES ("PS9_3","020_9_3","PSA","9","3","3","Aninga kager kari ni karkaman ale naguman peleman; nuna dagulaman ale mena namaman. ");
INSERT INTO wsk_vpl VALUES ("PS9_4","020_9_4","PSA","9","4","4","Mu awuk, ni aninga munan ningo wore ko aga atumu sangem; ni ka daiga kuwim mu te daigem ale tutera ningo bitawasam. ");
INSERT INTO wsk_vpl VALUES ("PS9_5","020_9_5","PSA","9","5","5","Ni sor saki ining nungarem ale kari memek alo nunga maguwurem; ni nunga nunup siwu saperem se menara biya menaram. ");
INSERT INTO wsk_vpl VALUES ("PS9_6","020_9_6","PSA","9","6","6","Kager kari alo mu memek ko memek, kumik menara mena owore nunga maguwuram. Ni nunga wonong lilim la menawu saperem; se kariimet sor umu ko nungamili sapa namarukko. ");
INSERT INTO wsk_vpl VALUES ("PS9_7","020_9_7","PSA","9","7","7","Yawe mu nu Kaem pempem baga lagoso; nu kiwem ningo ko kua tui lagoso. ");
INSERT INTO wsk_vpl VALUES ("PS9_8","020_9_8","PSA","9","8","8","Ale nu kariimet suen la munan ningo diram te nunga tuterukko; nu tutera ningo te kariimet nunga bituokko. ");
INSERT INTO wsk_vpl VALUES ("PS9_9","020_9_9","PSA","9","9","9","Yawe mu kariimet nunga bita maguwusan wore nunga yumura kuwim, ikup tom te nu nunga manga gek am. ");
INSERT INTO wsk_vpl VALUES ("PS9_10","020_9_10","PSA","9","10","10","O Yawe, awiriya nika nip ko ikiso, mu nu ko loagara mu nikate la beteso, mu awuk, awiriya nikate la loaga lagoso mu ni biring gurugu me tui arigem. ");
INSERT INTO wsk_vpl VALUES ("PS9_11","020_9_11","PSA","9","11","11","Yawe Zion bagoso; wur iluwal ale nup patawuralko! Noko kiwem bibiya beteram mu sor saki nunga ningi balu paogalko. ");
INSERT INTO wsk_vpl VALUES ("PS9_12","020_9_12","PSA","9","12","12","Nu kariimet ikup yaman giwasan mu nunga me buring gurugam, mena; nu nunga niara ikiam ale kariimet nunga bita maguwusan mu koma memek nungarukko. ");
INSERT INTO wsk_vpl VALUES ("PS9_13","020_9_13","PSA","9","13","13","O Yawe, kariimet awiriya aninga bita maguwusan ewere nungarkiko! Ago ko neman bataguk se kuera mutim kuring te aga patawu toko! ");
INSERT INTO wsk_vpl VALUES ("PS9_14","020_9_14","PSA","9","14","14","Se ani nika nip biya Zion ko kariimet nongoma te balu pagik ale ni aninga sangaru taem wore ko amilmil biya bitirikko. ");
INSERT INTO wsk_vpl VALUES ("PS9_15","020_9_15","PSA","9","15","15","Sor saki nongota nunga mutim iluman wore ningi dagulaman; nunga nusuwik mu nongota nunga dagarok kaluwu beteman mu ningi soraram. ");
INSERT INTO wsk_vpl VALUES ("PS9_16","020_9_16","PSA","9","16","16","Yawe kota ko munan diram mu te numi wetang saparam, se kariimet memek alo mu nongota nunga munan mu giris palagam ale nunga taliparam. ");
INSERT INTO wsk_vpl VALUES ("PS9_17","020_9_17","PSA","9","17","17","Kariimet memek alo mu kariimet kuera nunga sor te namamonko, kariimet Kaem nubiring tuman mu suen la karogotala. ");
INSERT INTO wsk_vpl VALUES ("PS9_18","020_9_18","PSA","9","18","18","Bare nu kariimet nungumik mel mena mu me ta nunga kuamili saparukko; se kariimet ikup gi se nukote loaga lagasan mu nu nunga sangukko. ");
INSERT INTO wsk_vpl VALUES ("PS9_19","020_9_19","PSA","9","19","19","Yawe, baresko! Ni kariimet bo ari sager se me ka kiarukko; sor suen la ni kema te taimon se nunga tuterko. ");
INSERT INTO wsk_vpl VALUES ("PS9_20","020_9_20","PSA","9","20","20","O Biya, ni nguangara aromemek te nunga maguwurko; sor suen la nunga kasuru se ikimon, mu nuna ali ewere ko kariimet yam. ");
INSERT INTO wsk_vpl VALUES ("PS10_1","020_10_1","PSA","10","1","1","O Yawe, ni awuk se bagara suwuta? Kariimet ikup arigisan bare awuk se ni me kasagasam? ");
INSERT INTO wsk_vpl VALUES ("PS10_2","020_10_2","PSA","10","2","2","Kariimet memek alo nunumi patawusan, ale nunga ikia memek mu dagarok iwita nungursan ale kariimet kituwura guat te ilusan. ");
INSERT INTO wsk_vpl VALUES ("PS10_3","020_10_3","PSA","10","3","3","Nuna nunga ikia memek mu ko nunumi patawusan ale nunga sikisaki kawel te mel gemasan mu nunga atumu sangorsan; bare nuna Yawe nubiring tusan. ");
INSERT INTO wsk_vpl VALUES ("PS10_4","020_10_4","PSA","10","4","4","Nuna nunga nusupuling lagara te Kaem mel yam ko betesan, ale nongota nunga ikia nongomang karo tusan. ");
INSERT INTO wsk_vpl VALUES ("PS10_5","020_10_5","PSA","10","5","5","Nuna mel suen biya betesan mu terong la aratu saposo, se kualala biya namasan ale nika munan nubiring tusan, ale nunga kager kari mu nunga nusuwik sapasan. ");
INSERT INTO wsk_vpl VALUES ("PS10_6","020_10_6","PSA","10","6","6","Ale nongomang ningi la balsan, “Ana sokel ago bagasan; bo me ta nanga bita maguwurokko,” masan. ");
INSERT INTO wsk_vpl VALUES ("PS10_7","020_10_7","PSA","10","7","7","Nononga nuguring mu bala memek se kawel karogo terong mam; nguangara ko den nungamili kopa te aniso. ");
INSERT INTO wsk_vpl VALUES ("PS10_8","020_10_8","PSA","10","8","8","Nuna wonong duap te yumusan ale loaga guruguwa, kariimet yam am ngual nunga ilusan ale nunga mosan se kuesan. ");
INSERT INTO wsk_vpl VALUES ("PS10_9","020_10_9","PSA","10","9","9","Ale lion iwita yumusan ale kariimet nongota nunumi sangarmonko me terong wore nunga loaga guruguwa, nunga ilusan ale nunga guratasan nongorak namasan. ");
INSERT INTO wsk_vpl VALUES ("PS10_10","020_10_10","PSA","10","10","10","Se kariimet mu memek biya arigisan ale maga namasan; kiwem mu te kariimet moa nobowa tugusan, ");
INSERT INTO wsk_vpl VALUES ("PS10_11","020_10_11","PSA","10","11","11","ale balsan, “Kaem koma motam kaluwuram ale mel imi me ari ko ikiokko,” masan. ");
INSERT INTO wsk_vpl VALUES ("PS10_12","020_10_12","PSA","10","12","12","O Yawe, bares ale kasager lulumerko! O Kaem, kariimet ikup ningi bagasan ewere nunga sangaruko! ");
INSERT INTO wsk_vpl VALUES ("PS10_13","020_10_13","PSA","10","13","13","Nuna awuk se ni Kaem mel yam ko ka betesan? Ale balsan, “Nu ananangate mel bo me bitirukko pa!” masan. ");
INSERT INTO wsk_vpl VALUES ("PS10_14","020_10_14","PSA","10","14","14","Bare O Kaem, ni kariimet umu nunga ikup yaman ko niara mu arigem ale koma bitarko; kariimet nungumik saonga mena mu nikate la loaga lagasan, mu awuk, ni kariimet nungumik nokotam mena mu nunga sangorsam. ");
INSERT INTO wsk_vpl VALUES ("PS10_15","020_10_15","PSA","10","15","15","Ni kariimet memek mu nunga nosokel menawurko! Ale nunga kiwem yumura nunguning umu ko koma ikup yaman ninguru ninguru nungaruko! ");
INSERT INTO wsk_vpl VALUES ("PS10_16","020_10_16","PSA","10","16","16","Yawe, ni King ko butata pempem baga lagasam; se kariimet ni mel yam ko ka betesan mu nika ali te mena namamonko. ");
INSERT INTO wsk_vpl VALUES ("PS10_17","020_10_17","PSA","10","17","17","O Yawe, ani ko ikisam, ni kariimet memek ningi baga se kete niasan aisan mu ni nuguring ilup ale nongomang motam sokel tuiko. ");
INSERT INTO wsk_vpl VALUES ("PS10_18","020_10_18","PSA","10","18","18","Ale ni kuriang marmar se kariimet kituwura guat mu nunga sangaru se ali ko kariimet memek mu udagi me nunga nguangamonko. ");
INSERT INTO wsk_vpl VALUES ("PS11_1","020_11_1","PSA","11","1","1","(David ko wur) Yawe mu aninga yumura kuwim. Se nina anape ko aninga manorsan, ani inangnang iwita bingek nama duruk duap ningi yumurekko aga manorsan? ");
INSERT INTO wsk_vpl VALUES ("PS11_2","020_11_2","PSA","11","2","2","“Arikko!” masan. “Kari memek nunga daga wol tagi muruwuman ale yumura la kariimet ningo diram aolak iluwasan mu te nunga momonko bagasan. ");
INSERT INTO wsk_vpl VALUES ("PS11_3","020_11_3","PSA","11","3","3","Munan ningo ningo ko nukuri maga saparam imi mu kariimet ningo diram mu awuk betemonko? Mena.” ");
INSERT INTO wsk_vpl VALUES ("PS11_4","020_11_4","PSA","11","4","4","Bare ikialko. Yawe ko temple laili ningi bagoso; nu ko daiga kuwim te kualala bagoso. Nu loagoso ale kariimet ninguru nungarki kutuwuso. ");
INSERT INTO wsk_vpl VALUES ("PS11_5","020_11_5","PSA","11","5","5","Nu nungarkoso ale kariimet ningo diram mu nunga amilmiloso; bare kager daong ko kariimet memek mu me nunga kueso. ");
INSERT INTO wsk_vpl VALUES ("PS11_6","020_11_6","PSA","11","6","6","Noko gomang magara mu tama iwita sisuwurok se nungumik kuali kaparukko; se daula bo kowar biya mu nunga maguwurokko. ");
INSERT INTO wsk_vpl VALUES ("PS11_7","020_11_7","PSA","11","7","7","Mu awuk, Yawe mu ningo se diram; nu munan diram la anirukko kueso, se kariimet munan diram la betesan mu nu arigimonko. ");
INSERT INTO wsk_vpl VALUES ("PS12_1","020_12_1","PSA","12","1","1","(David ko wur) O Yawe, nanga sangaruko! Imi te kari ningo nuam bo ta me bagoso; se kariimet nongomang ningi nunguning mu mena tala. ");
INSERT INTO wsk_vpl VALUES ("PS12_2","020_12_2","PSA","12","2","2","Kariimet suen la nunga saki den kawel nunga manorsan; nuguring te den welang balsan, bare nongomang ningi kawel biya aniso. ");
INSERT INTO wsk_vpl VALUES ("PS12_3","020_12_3","PSA","12","3","3","Buta se Yawe, kariimet den welang kawel nuguring te aratuwoso mu nuguring kaloko! Ale kariimet nunumi patawu se anira mu betela nuguring kaloko! ");
INSERT INTO wsk_vpl VALUES ("PS12_4","020_12_4","PSA","12","4","4","Nuna balsan, “Anananga munak den te anapeya mel ko kuesan mu tanakkowo. Kari bo ta ana nagiring me kalokko; ana aguwaya balnakko mu am balnakko,” ma balsan. ");
INSERT INTO wsk_vpl VALUES ("PS12_5","020_12_5","PSA","12","5","5","Bare Yawe iwita balso, “Ani kariimet kituwura nunga bita maguwusan se nongota nunumi sangarmonko me terong, mu nunga niara kikira ikiem; ale aitak barasik ale kariimet memek mu nuguting te nunga giek ale nunga bituekko.” ");
INSERT INTO wsk_vpl VALUES ("PS12_6","020_12_6","PSA","12","6","6","Se Yawe ko den mu nunguningta se nikim garagar, silver tom seven ko, tama kowar tamatama mu te kaisan ale palungursan se nikim kapawoso wore toroman. ");
INSERT INTO wsk_vpl VALUES ("PS12_7","020_12_7","PSA","12","7","7","Se Yawe, ana ikisan, ni kariimet memek mu nunga, nanga bitaru se pempem ningo la baganakko. ");
INSERT INTO wsk_vpl VALUES ("PS12_8","020_12_8","PSA","12","8","8","Tom kariimet kilek memek mu kilek ningo ko balsan ale nup patawusan, mu kari memek alo mu aratasan ale ali eresan ale nunumi patawu patawu geragasan. ");
INSERT INTO wsk_vpl VALUES ("PS13_1","020_13_1","PSA","13","1","1","(David ko wur) O Yawe, ni tom awila nunguningkiri ani ago ko kamili saparukko? Ni tom awila nunguningkiri ani ago ko kema kaluwurko? ");
INSERT INTO wsk_vpl VALUES ("PS13_2","020_13_2","PSA","13","2","2","Ani tom awila nunguningkiri ikia aga moa lagarukko? ale tirom woremkalal angamang bataga lagarukko? Tom awila nunguningkiri aga kager kari aga maguwu lagamonko? ");
INSERT INTO wsk_vpl VALUES ("PS13_3","020_13_3","PSA","13","3","3","O Yawe, ni aninga Kaem, kema gurugu aisu ale agiring ilupko! Aga sangaru se ani me kuerikko; ");
INSERT INTO wsk_vpl VALUES ("PS13_4","020_13_4","PSA","13","4","4","kager kari alo balmon, “Ana ka sokel menawuman,” mamon, ale amilmilamon, “Ni dagulem,” ma aga balmon bore ko. ");
INSERT INTO wsk_vpl VALUES ("PS13_5","020_13_5","PSA","13","5","5","Bare ni ani ago ko kua lagasam mu ko ani angamang ningi nunguning aso; ale kager kari nuguting te aga bataguru toko mu ko ani amilmilasam. ");
INSERT INTO wsk_vpl VALUES ("PS13_6","020_13_6","PSA","13","6","6","Yawe, ani wur iluwek ale nip patawurikko, mu awuk, ni ani ago ko ningo la bita lagasam. ");
INSERT INTO wsk_vpl VALUES ("PS14_1","020_14_1","PSA","14","1","1","(David ko wur) Kariimet ikia sinar mena mu balsan, “Kaem mena!” masan. Nunga ikia maga saparam, se nuna munan suen la betesan mu am memek la betesan; ale bo ta munan ningo me beteso. ");
INSERT INTO wsk_vpl VALUES ("PS14_2","020_14_2","PSA","14","2","2","Yawe duruk wonong te baga se loagoso se ko kariimet lilim nongote tai kaposo, nu bo i ikia sinar karogo se nukote la motam bita lagoso wore arigokko loagoso. ");
INSERT INTO wsk_vpl VALUES ("PS14_3","020_14_3","PSA","14","3","3","Bare mena. Nuna suen la lage ningo nubiring tui muruwuman, ale suen la kilek memek te kapa sapaman, ale bo ta munan ningo bo me bitawoso, am mena biya. ");
INSERT INTO wsk_vpl VALUES ("PS14_4","020_14_4","PSA","14","4","4","Se kariimet memek bitawara mu awuk? Nuna me ari ikimonko e? Nuna aninga kariimet bread nokoyam nunga bita maguwusan; ale Yawe ko ikia me tasan. ");
INSERT INTO wsk_vpl VALUES ("PS14_5","020_14_5","PSA","14","5","5","Bare nuna ninguru nguangamonko, mu awuk, Kaem kariimet ningo diram betesan mu arungak bagoso. ");
INSERT INTO wsk_vpl VALUES ("PS14_6","020_14_6","PSA","14","6","6","Nina memek betera ko kariimet alo, ikialko! Nina kariimet kituwura guat nunga ikia bagara parusuwural maguwuralko taisan, bare Yawe nunga bitarso. ");
INSERT INTO wsk_vpl VALUES ("PS14_7","020_14_7","PSA","14","7","7","O saonga! Aga angamang mu saonga bo Zion barasuk ale Israel kariimet nunga sangukko! Tom Yawe ko kariimet nunga sanguk se aking daiga bagara ningo arigimon, mu Jacob ko digo nongomang motam nungeruk se Israel kariimet amilmilamonko! ");
INSERT INTO wsk_vpl VALUES ("PS15_1","020_15_1","PSA","15","1","1","(David ko wur) O Yawe, awiri nika kuwim laili nunguning mu ningi kasu nagurokko terong? Awiri nika duruk Zion mu te bagarukko terong? ");
INSERT INTO wsk_vpl VALUES ("PS15_2","020_15_2","PSA","15","2","2","Mu awiriya ko bagara aolak diram la, se munan diram la beteso; noko kuring te den nunguning la arataso, umutang ni kerak bagarukko terong. ");
INSERT INTO wsk_vpl VALUES ("PS15_3","020_15_3","PSA","15","3","3","Nu saki alo me nunga balu maguwuso; ale saki alo nungumik te memek bo me beteso; ale saki alo nubiring ko den me balu balu geragoso. ");
INSERT INTO wsk_vpl VALUES ("PS15_4","020_15_4","PSA","15","4","4","Nu kariimet memek nunga me kueso; bare nu kariimet Yawe ko kuring karo tusan mu nunga kueso. Nu mel bitirukko balso mu eng am butata beteso, bitiruk ale ko ikup giokko agi mu me ko nguangoso, am beteso. ");
INSERT INTO wsk_vpl VALUES ("PS15_5","020_15_5","PSA","15","5","5","Nu bo manga te sangarso mu koma tuam uwutatala aking taso, marir manga bo karogo me taso; ale nu kariimet saki alo nungumik den mena, mu nunga bita maguwurokko gomang kulukursan ale manga mel te diasan bare mu me taso, ale munan mu me beteso. Awiriya kiwem imi karo saposo, kariimet umutang gek am bagoso. ");
INSERT INTO wsk_vpl VALUES ("PS16_1","020_16_1","PSA","16","1","1","(David ko wur) O aga Kaem, aga bitaruko, mu awuk, ani nika ningi aga yumura kuwim ningo arigem. ");
INSERT INTO wsk_vpl VALUES ("PS16_2","020_16_2","PSA","16","2","2","Ani nu manorsam, “Ni aninga Kari Biya; ni mena mu, ani ningo bo me arigekko.” ");
INSERT INTO wsk_vpl VALUES ("PS16_3","020_16_3","PSA","16","3","3","Ale nika kariimet ali imi te mu nunga balsam, “Nuna ningo, se ani nunga amilmilasam.” ");
INSERT INTO wsk_vpl VALUES ("PS16_4","020_16_4","PSA","16","4","4","Bare awiriya kaem kawel nogowom karowasan mu, ikup numi awote nunga morukko; ani nunga tama bita nunga kaem nungara mu ningi me bagarikko; ale nunga kaem nunup me ta patawurikko. ");
INSERT INTO wsk_vpl VALUES ("PS16_5","020_16_5","PSA","16","5","5","Yawe, ni aninga mel ningo ningo suen biya; ni aninga ali welang ningo, aga tammanga mel suen la te ningo la aragoso iwita. ");
INSERT INTO wsk_vpl VALUES ("PS16_6","020_16_6","PSA","16","6","6","Ni ani ka munan suen la aisem mu am yawarakala nunguningkiri, se ani ninguru ko amilmilasam. ");
INSERT INTO wsk_vpl VALUES ("PS16_7","020_16_7","PSA","16","7","7","Ani Yawe ko nup patawurikko, mu awuk, nu ikia ningo ani aisiso; ale tirom karogotala aga kiti guruguso. ");
INSERT INTO wsk_vpl VALUES ("PS16_8","020_16_8","PSA","16","8","8","Ani pempem la Yawe te ira sanamasam; nu ani agiting duap ningi aga iluso, bore te se ani gek am bagasam. ");
INSERT INTO wsk_vpl VALUES ("PS16_9","020_16_9","PSA","16","9","9","Ale bore te se, aninga angamang motam lila aso se ninguru amilmilasam; ale aninga adera angimik me maga namarukko tala, ");
INSERT INTO wsk_vpl VALUES ("PS16_10","020_16_10","PSA","16","10","10","mu awuk, ni ani nika kari, ni bowa ningi la lagara, mu agarkiwer se, kuera mutim ningi me kua iwi namarikko. ");
INSERT INTO wsk_vpl VALUES ("PS16_11","020_16_11","PSA","16","11","11","Ni marak pempem bagara ko lage aga kasursam; se ani ni kerak amilmil te baga se, ka kiting sengam mu te ningo la pempem bagarikko. ");
INSERT INTO wsk_vpl VALUES ("PS17_1","020_17_1","PSA","17","1","1","(David ko ngatang bo) O Yawe, ani memek bo me betera, se aga wosenga ewere iki ale aga sangaruko! De gurugu ale ikiko, ani nunguningta balsam. ");
INSERT INTO wsk_vpl VALUES ("PS17_2","020_17_2","PSA","17","2","2","Nika motam sinar mu te ani aga gurugu patawur ale ani angimik den bo mena mu ko aga wetang saparko. ");
INSERT INTO wsk_vpl VALUES ("PS17_3","020_17_3","PSA","17","3","3","Ni tirom tair ale aga angamang motam ningi tatager, mu ni memek bo me arikko; ani agiring te den kawel bo me aratam. ");
INSERT INTO wsk_vpl VALUES ("PS17_4","020_17_4","PSA","17","4","4","Ani nika den ilukuawukasam, ale kager daong ko kari nunga munan kawel mu te me dagulukasam tala. ");
INSERT INTO wsk_vpl VALUES ("PS17_5","020_17_5","PSA","17","5","5","Ani pempem nika molak diram la karo lagakasam, ale katir me paguwukasam. ");
INSERT INTO wsk_vpl VALUES ("PS17_6","020_17_6","PSA","17","6","6","Aga Kaem, ni ani agiring ilusam, bore te se aninga aira nikate betesam; de gurugu ale agiring ikiko. ");
INSERT INTO wsk_vpl VALUES ("PS17_7","020_17_7","PSA","17","7","7","Kariimet kager daong ko nagusan kete taisan mu ni ka kiting te nunga iramursam. Butatala, ka kua aisa ko munan ningo mu wetang sapar ale te aga sangaruko. ");
INSERT INTO wsk_vpl VALUES ("PS17_8","020_17_8","PSA","17","8","8","Nika motam ko ninguru sinar tasam iwitatala, aninga sinar toko; tarak nuam ko luman te ko gotek nunga ereso iwita, aga ira kaluwurko. ");
INSERT INTO wsk_vpl VALUES ("PS17_9","020_17_9","PSA","17","9","9","Aga bitaru se kari memek me aga maguwumonko, mu awuk, kari memek nunguningkiri aga talurman bagasan. ");
INSERT INTO wsk_vpl VALUES ("PS17_10","020_17_10","PSA","17","10","10","Nuna bo kua tuata ko munan me ko ikisan; nuna nunumi patawura ko den balu lagasan. ");
INSERT INTO wsk_vpl VALUES ("PS17_11","020_17_11","PSA","17","11","11","Nuna ani te bagasam mu ko ikiman ale aga laturu gilingiman, ale aga ilu talipamonko kimi bitawasan. ");
INSERT INTO wsk_vpl VALUES ("PS17_12","020_17_12","PSA","17","12","12","Nuna lion iwita yumuman ale inang moa namonko karanga sipa se loagakuawuwasan. ");
INSERT INTO wsk_vpl VALUES ("PS17_13","020_17_13","PSA","17","13","13","Yawe, bares ale nongorak kagerer ale nunga menawurko; ka batir te kari memek nunga moar ale aga bataguru toko. ");
INSERT INTO wsk_vpl VALUES ("PS17_14","020_17_14","PSA","17","14","14","Nika sokel aora garagar mu te aga sangaru toko. Nononga ikia nongomang motam mu na nokoyam ali ewere ko melmasak te aniso; buta se nunga memek koma mu inang iwita ninguru nungaru se namon ale nutagu lagarukko, nunga kuriang imas gue te koma suanta tala bitarko. ");
INSERT INTO wsk_vpl VALUES ("PS17_15","020_17_15","PSA","17","15","15","Se ani mu angimik den mena, owore te se ani nika motam te bagarikko; se tom ani maragarik mu aninga angamang motam amilmilarukko, mu awuk, ani nika kiwim te kerak bagasam. ");
INSERT INTO wsk_vpl VALUES ("PS18_1","020_18_1","PSA","18","1","1","(Yawe kager kari alo nuguting te se Saul kuting te ko ura kari David bataguru tam se David wur imi batogam) O Yawe, ani ninguru ka kuesam; ni sokel ani aisisam. ");
INSERT INTO wsk_vpl VALUES ("PS18_2","020_18_2","PSA","18","2","2","Yawe mu aninga manga gek am, aninga bitua gek am, se aninga bataguru ta kari; nu aninga Kaem, manga biya bo iwita, se ani kararasam ale aga kager kari memek nunga ko te yumusam. Nu aninga karem, se aninga sokel. ");
INSERT INTO wsk_vpl VALUES ("PS18_3","020_18_3","PSA","18","3","3","Aninga niara Kaem nup biya kote beterem, se nu kager kari nuguting te aga bataguru tam. ");
INSERT INTO wsk_vpl VALUES ("PS18_4","020_18_4","PSA","18","4","4","Ani kuera mayang aga taliparam; lom biya aga ira kaluwuram. ");
INSERT INTO wsk_vpl VALUES ("PS18_5","020_18_5","PSA","18","5","5","Kuera mateng ko mayang aga talipi saparam; dagarok iwita aga iluwam. ");
INSERT INTO wsk_vpl VALUES ("PS18_6","020_18_6","PSA","18","6","6","Se ani angamang uririkira sipira mu ningi Yawe aurem, aninga Kaem aga sangukko kote niarem, se nu ko temple ningi baga se agiring ikiam ale dogowa gurugam ale aga niara ikiam. ");
INSERT INTO wsk_vpl VALUES ("PS18_7","020_18_7","PSA","18","7","7","Noko gomang magara mu ali sisuwuram se duruk bibiya yukuman. ");
INSERT INTO wsk_vpl VALUES ("PS18_8","020_18_8","PSA","18","8","8","Ale tama bur kuamuru gogong te aratukaso; ale tama kuamili korang te buluk buluk makaso, ale melmasak kai kai namakaso. ");
INSERT INTO wsk_vpl VALUES ("PS18_9","020_18_9","PSA","18","9","9","Nu taiti gomang kaogam ale tai kaparam; se taiti nuwi kaetam mu sowek bowa ningi anikaso. ");
INSERT INTO wsk_vpl VALUES ("PS18_10","020_18_10","PSA","18","10","10","Engel cherubim bo nu giam ale ilak bingam taiso iwita tairam; ko ariga marir bo luman karogo iwita nu giam ale ilak tairatela tai kaparam. ");
INSERT INTO wsk_vpl VALUES ("PS18_11","020_18_11","PSA","18","11","11","Tuwik ko taiti nuwi kaetam mu ningi numi kaluwuram, taiti nuwi ko tiromorom mu nu lautam. ");
INSERT INTO wsk_vpl VALUES ("PS18_12","020_18_12","PSA","18","12","12","Noko kumik nikim biya taiti nuwi ningi nikim kapakaso, ale pure iwita biliwilik makaso, ale tuwik muguri bibiya iwita kapakaso. ");
INSERT INTO wsk_vpl VALUES ("PS18_13","020_18_13","PSA","18","13","13","Yawe ko nup kuali biya mu duruk wonong te baga se sokel karogo aikaso se pure iwita pagakaso. ");
INSERT INTO wsk_vpl VALUES ("PS18_14","020_18_14","PSA","18","14","14","Ale pure nikim mu gatu iwita bitakaso se kari memek nunga parusuwukaso. ");
INSERT INTO wsk_vpl VALUES ("PS18_15","020_18_15","PSA","18","15","15","O Yawe, ni iningirem se kamuru te daula aratam ale gagi kuring kauram se saun manga wetang te aratam; se ali ningi ali ko nukuri ilukuawuwaram mu wetang te aratam tala. ");
INSERT INTO wsk_vpl VALUES ("PS18_16","020_18_16","PSA","18","16","16","Yawe kualala baga se kuting garukam ale aga tagi patawuram; gagi biya aga iram, bare nu aga tagiram se bausem. ");
INSERT INTO wsk_vpl VALUES ("PS18_17","020_18_17","PSA","18","17","17","Aninga kager kari mu gek am nunguningkiri, se ani nunga kiarikko me terong; bare nu nuguting te aninga bataguru tam. ");
INSERT INTO wsk_vpl VALUES ("PS18_18","020_18_18","PSA","18","18","18","Ani tom memek ningi kaperem se kager kari taiman agarak kagerman, bare nu aga saongam. ");
INSERT INTO wsk_vpl VALUES ("PS18_19","020_18_19","PSA","18","19","19","Nu aninga saongam ale kuwim ningo te aga beteram; nu aninga kueram ale aga bataguru tam. ");
INSERT INTO wsk_vpl VALUES ("PS18_20","020_18_20","PSA","18","20","20","Ani munan laili karo tuem, se Yawe koma ningo aisam; ani memek bo me beterem, se nu marak ningo aisam. ");
INSERT INTO wsk_vpl VALUES ("PS18_21","020_18_21","PSA","18","21","21","Ani noko munan diram la karem; ani munan memek bo me beterem, ale abiring me gurugu tuem. ");
INSERT INTO wsk_vpl VALUES ("PS18_22","020_18_22","PSA","18","22","22","Ani pempem la noko munan mu angama sengem ko aniso, se kuring me kulukurukasam. ");
INSERT INTO wsk_vpl VALUES ("PS18_23","020_18_23","PSA","18","23","23","Ani noko motam te angimik ikup bo mena; ani aimi ko ninguru sinar tokasam, ale memek bo me bitakasam. ");
INSERT INTO wsk_vpl VALUES ("PS18_24","020_18_24","PSA","18","24","24","Se Yawe aninga munan laili arigam ale koma ningo aisam; mu awuk, ani noko motam te diram la bagakasam. ");
INSERT INTO wsk_vpl VALUES ("PS18_25","020_18_25","PSA","18","25","25","O Kaem, awiriya ni ko ko kua kaposo, mu ni ka kua kapara ko munan mu kote betesam; se awiriya munan ningo beteso, mu ni ka munan ningo kote betesam. ");
INSERT INTO wsk_vpl VALUES ("PS18_26","020_18_26","PSA","18","26","26","Awiriya munan diram la beteso, mu ni munan diram mu ilak betesam; bare awiriya munan daeldel bita lagoso, mu ni aguwaya nu bitarko mu nikate mu am mel gotektir. ");
INSERT INTO wsk_vpl VALUES ("PS18_27","020_18_27","PSA","18","27","27","Mu awuk, ni awiriya numi karogo kaposo, mu ni sangaru tasam; bare ni awiriya numi patawuso, mu ni ilak kapasam. ");
INSERT INTO wsk_vpl VALUES ("PS18_28","020_18_28","PSA","18","28","28","Nigita, O Yawe, ani nikinang aisisam; aga Kaem, ni aninga tiromorom bataguru sapasam ale nikim aisisam. ");
INSERT INTO wsk_vpl VALUES ("PS18_29","020_18_29","PSA","18","29","29","Ni te mu ani aga kager kari memek alo am nunga menawurik nongorak pelerikko; ni aga Kaem abiring ko bager, mu ani kager mu ko lauta am parusuwurikko. ");
INSERT INTO wsk_vpl VALUES ("PS18_30","020_18_30","PSA","18","30","30","Kaem ko munan mu ningo se diram; nu mel bo bitirukko balso mu nu eng karo tuso; se kariimet nu kararasan mu nu nononga karem bagoso. ");
INSERT INTO wsk_vpl VALUES ("PS18_31","020_18_31","PSA","18","31","31","Kaem bo awuk wore Yawe iwita bagoso? Mena. Nu kota suanta Kaem se nanga Manga Gek am. ");
INSERT INTO wsk_vpl VALUES ("PS18_32","020_18_32","PSA","18","32","32","Kaem kota sokel aisiso ale aga bitarso. ");
INSERT INTO wsk_vpl VALUES ("PS18_33","020_18_33","PSA","18","33","33","Nu aninga asiwik sokel tuso, se ani deer iwita duruk kuamuru te araga sanamasam. ");
INSERT INTO wsk_vpl VALUES ("PS18_34","020_18_34","PSA","18","34","34","Nu kager aga kasurso, ale agiting sokel tuso, se ani daga wol aora biya mu tagisam. ");
INSERT INTO wsk_vpl VALUES ("PS18_35","020_18_35","PSA","18","35","35","O Yawe, kager ningi ni keta aninga saonga karem bagerem; nika kiting sengam te agiting duap ningi aga iluwem; ni kua kaperem ale nup biya aisem. ");
INSERT INTO wsk_vpl VALUES ("PS18_36","020_18_36","PSA","18","36","36","Ni aninga lage nungem ale ulaluwurem, bore te se ani asiwik ponor te me gurikirem. ");
INSERT INTO wsk_vpl VALUES ("PS18_37","020_18_37","PSA","18","37","37","Ani aga kager kari nunga karem nongorak namerem ale nunga iluwem; ani ninguru nunga maguwurem ale nunga menawurem. ");
INSERT INTO wsk_vpl VALUES ("PS18_38","020_18_38","PSA","18","38","38","Ani nunga ita parusuwu asiwik duap ningi nunga beterem; udagi barasamonko koma mena. ");
INSERT INTO wsk_vpl VALUES ("PS18_39","020_18_39","PSA","18","39","39","Ni kager ko sokel ani aisem; ale aga kager kari arungu kapa adeleng duap ningi nunga awurem. ");
INSERT INTO wsk_vpl VALUES ("PS18_40","020_18_40","PSA","18","40","40","Ni uwuta beterem se ani nodogotak ali karogo irem ale nunga menawurem. ");
INSERT INTO wsk_vpl VALUES ("PS18_41","020_18_41","PSA","18","41","41","Nuna saonga ko niaman, bare kariimet bo nunga sangukko mena; nuna Yawe kote niaman, bare nu nuguring me iluwam. ");
INSERT INTO wsk_vpl VALUES ("PS18_42","020_18_42","PSA","18","42","42","Ani ninguru nunga maguwurem se kupkup marir gi karogo namoso iwita arataman; ale lom gege iwita lage te nunga warem. ");
INSERT INTO wsk_vpl VALUES ("PS18_43","020_18_43","PSA","18","43","43","Ni aga kager kari memek alo nuguting te aga sangaru taem; ale ani sor suen biya nunga supuling biya ko aga beterem. Se kariimet ani me nunga ikia mu aitak ani abowa ningi bagasan. ");
INSERT INTO wsk_vpl VALUES ("PS18_44","020_18_44","PSA","18","44","44","Nuwi saki ko kariimet aninga aip biya ikisan, ale nguangasan ale taisan nubugura kulukuru ani aisisan. ");
INSERT INTO wsk_vpl VALUES ("PS18_45","020_18_45","PSA","18","45","45","Nuna nguanga nguanga nunga yumura kuwim aora mu bita bita aningate taisan. ");
INSERT INTO wsk_vpl VALUES ("PS18_46","020_18_46","PSA","18","46","46","Ikialko, Yawe pempem bagoso! Nu aninga Manga Gek am, se aga Saonga; nup biya pempem anirukko! ");
INSERT INTO wsk_vpl VALUES ("PS18_47","020_18_47","PSA","18","47","47","Nuguta nu Kaem, aninga luan taso, ale sor saki nunga gi ani abowa tuguso, ");
INSERT INTO wsk_vpl VALUES ("PS18_48","020_18_48","PSA","18","48","48","ale kager kari nuguting te aga tagi batagarso. Yawe, ni aga kager kari nongoma te nup biya ani aisem; ni aninga sangem se aga kager kari me aga moman se kuerem. ");
INSERT INTO wsk_vpl VALUES ("PS18_49","020_18_49","PSA","18","49","49","Buta se ani sor saki ko kariimet nongoma te nika nip biyala patawurikko; ale nika nip patawu se wur iluwekko. ");
INSERT INTO wsk_vpl VALUES ("PS18_50","020_18_50","PSA","18","50","50","Kaem ani king ko aga balu beteram se bagasam; noko kua nangara kumik menara mena mu ani David se aga kuriang gue lilim la pempem nanga iramuram. ");
INSERT INTO wsk_vpl VALUES ("PS19_1","020_19_1","PSA","19","1","1","(David ko wur) Taiti gomang kualala aniso mu Kaem ko ningo nanga kasurso; melmasak taiti gomang te mu Kaem ko kiwol wetang te saposo. ");
INSERT INTO wsk_vpl VALUES ("PS19_2","020_19_2","PSA","19","2","2","Kowarkalal suan suan mu mel imi suen la ko nanga kasuruwoso; tirom suan suan karogotala ko nanga kasuruwoso. ");
INSERT INTO wsk_vpl VALUES ("PS19_3","020_19_3","PSA","19","3","3","Kowarkalal se tirom nungumik nuguring mena, se mel imi ko balmon se me ikinakkowo. ");
INSERT INTO wsk_vpl VALUES ("PS19_4","020_19_4","PSA","19","4","4","Bare nunga nuguring ali lilim te geraga saparam; nunga den mu sor suen la te geragam. Taiti gomang te Kaem worem ko kawam bo kaolam. ");
INSERT INTO wsk_vpl VALUES ("PS19_5","020_19_5","PSA","19","5","5","Worem turomola basu arataso mu kari bo imet iru tam ale ko amilmil te ko kawam beteso ale arataso iwita; agi kari bo kolara nagura imi ko nagurokko numi nungurso burangoso iwita. ");
INSERT INTO wsk_vpl VALUES ("PS19_6","020_19_6","PSA","19","6","6","Worem taiti duap koma sang te duap beteso ale nama koma sang te kaposo; mel bo ta noko kowar ko yumurokko yam me terong, mena. ");
INSERT INTO wsk_vpl VALUES ("PS19_7","020_19_7","PSA","19","7","7","Kaem ko munan den mu yam dirkiriyam, se marak iru nangarso; noko den balam mu ana te ira sanamanakko, se awiriya ikia ko tukunangaso wore ikia tuso. ");
INSERT INTO wsk_vpl VALUES ("PS19_8","020_19_8","PSA","19","8","8","Kari Biya ko den mu munan ningo nangarso, se awiriya karo tuso mu amilmiloso; noko den gilalong mu yawarakala nunguning se nikinang ningo nangarso. ");
INSERT INTO wsk_vpl VALUES ("PS19_9","020_19_9","PSA","19","9","9","Awiriya Yawe ko kua kaposo mu kilek ningo beteso, se kilek umu pempem ani lagarukko; den nu balso mu ningo la, se diram nunguningkiri. ");
INSERT INTO wsk_vpl VALUES ("PS19_10","020_19_10","PSA","19","10","10","Kaem ko den mu mel ningo ningo suen biya nunga kia saparam, ali imi ko mel duap duap mu yam nunga kia saparam nunguningkiri; buta se den imi mu ana nangamang ninguru tunakko. ");
INSERT INTO wsk_vpl VALUES ("PS19_11","020_19_11","PSA","19","11","11","Yawe, nika den mu ani nika ura kari ikia ningo aisiso; ani nika den karo tusam mu te ni aninga daiga bagara ningo aisisam. ");
INSERT INTO wsk_vpl VALUES ("PS19_12","020_19_12","PSA","19","12","12","Bare awiri kota ko memek suen la ko iki saposo? Mena. Buta se ani munan memek sang beterem wore me ko ikiem agi, angamili saparam agi mu, ni siwu aisuko. ");
INSERT INTO wsk_vpl VALUES ("PS19_13","020_19_13","PSA","19","13","13","Ale aga sangaru se memek ko iki se wore am ngual me bitirikko; aga sangaru se munan memek mu me aga bituokko; uwuta aga bitar mu ani ni kema te memek biya bo mena, ningo la bagarikko. ");
INSERT INTO wsk_vpl VALUES ("PS19_14","020_19_14","PSA","19","14","14","Aninga agiring te den, se aninga angamang motam nunguning, mu ningo la ni kema te anirukko. O Yawe, ni aninga Manga Gek am se aninga Sangaru Ta Kari. ");
INSERT INTO wsk_vpl VALUES ("PS20_1","020_20_1","PSA","20","1","1","(David ko wur) Tom ni ikup ka iramurokko agi mu, Yawe nika sangukko; anananga nangamang Jacob ko Kaem mu nika sinar taukko! ");
INSERT INTO wsk_vpl VALUES ("PS20_2","020_20_2","PSA","20","2","2","Nu ko temple biya te baga se ka sangukko; nu ko wonong Zion te baga se ka bataguru taukko! ");
INSERT INTO wsk_vpl VALUES ("PS20_3","020_20_3","PSA","20","3","3","Nu ni tama bita nu tuata mu nu ko kuamin ares maukko; nika tama suen la mu nu gomang tuokko. ");
INSERT INTO wsk_vpl VALUES ("PS20_4","020_20_4","PSA","20","4","4","Nu mel suen la ni ko kuesam mu yam kisokko; ale ni ura bitarko ko ikia towasam mu ka sanguk se ningo la bitarko. ");
INSERT INTO wsk_vpl VALUES ("PS20_5","020_20_5","PSA","20","5","5","Buta se tom ni kager menawur ale marirer mu, ana ni marirerem mu ko amilmilanak ale nanga Kaem ko nup patawunakko. Anananga nangamang mu Yawe nika guranek suen la iki karo kisokko. ");
INSERT INTO wsk_vpl VALUES ("PS20_6","020_20_6","PSA","20","6","6","Aitak ani ko ikiem, Yawe nu kota king baongam mu sangarso; nu ko sor laili duruk wonong te baga se noko ngatangara ikiso; noko sokel te nu sangarso se nu kager suen la te mariroso. ");
INSERT INTO wsk_vpl VALUES ("PS20_7","020_20_7","PSA","20","7","7","Sor saki nunga kager ko mel, karis se horse suen biya, mu te ira sanamasan; bare ana mu Yawe anananga Kaem mu te ira sanamasan. ");
INSERT INTO wsk_vpl VALUES ("PS20_8","020_20_8","PSA","20","8","8","Se nuna mu sanami turutuwumon ale dagulamonko; bare ana mu mariranak ale sail karogo sanamanakko. ");
INSERT INTO wsk_vpl VALUES ("PS20_9","020_20_9","PSA","20","9","9","O Yawe, ni king sangaru se nu marirarukko! Tom ana nika arunak mu ni anananga sangaruko! ");
INSERT INTO wsk_vpl VALUES ("PS21_1","020_21_1","PSA","21","1","1","(David ko wur) O Yawe, ni ka sokel king tuem se king nika ko amilmiloso; ni nu sangem se nu kager te mariraram mu ko ninguru tala amilmiloso! ");
INSERT INTO wsk_vpl VALUES ("PS21_2","020_21_2","PSA","21","2","2","Mel nu ko kuakaso ale gomang tuikaso mu ni maingkala tuikasam; se mel ko kuakaso ale nika ngatangarukaso mu ni karogo la tui saperem. ");
INSERT INTO wsk_vpl VALUES ("PS21_3","020_21_3","PSA","21","3","3","Ni nu kote tairem ale marak ningo tuem; ale king ko kitigat gold te nunga mu supuling tugumem. ");
INSERT INTO wsk_vpl VALUES ("PS21_4","020_21_4","PSA","21","4","4","Ni nu marak tuiko balam se ni marak tuem; ale marak tom maiya biya baga lagarukko mu tuem. ");
INSERT INTO wsk_vpl VALUES ("PS21_5","020_21_5","PSA","21","5","5","Ni nu sangem se nu nup biya wore tam; noko nup biya se ko sokel mu ni nu tuem. ");
INSERT INTO wsk_vpl VALUES ("PS21_6","020_21_6","PSA","21","6","6","Ni nu ninguru nunguningkiri kiwem ningo kote beterem, ale ni kiwem mu butata bita se lagerko. Ni nu kumik duap te bagasam se nu ninguru amilmila lagoso. ");
INSERT INTO wsk_vpl VALUES ("PS21_7","020_21_7","PSA","21","7","7","Yawe Kualala Biya, king nika ko gomang ningi nunguning aram. Ni pempem la gemang lila king tui lagasam, se nu te sokel karogo sanami lagoso. ");
INSERT INTO wsk_vpl VALUES ("PS21_8","020_21_8","PSA","21","8","8","Nika kiting mu kager kari kasik la nunga iluwokko; nika sokel mu kariimet ni me ka kuesan mu nunga menawurokko. ");
INSERT INTO wsk_vpl VALUES ("PS21_9","020_21_9","PSA","21","9","9","Tom ni wetang te aratu mu, tama melmasak kai saposo iwita, kager kari mu nunga menawurko. Nunguningta Yawe, ni gemang magaruk se kager kari mu nunga ira nongorak kapar se kasik la tama nunga kanirukko. ");
INSERT INTO wsk_vpl VALUES ("PS21_10","020_21_10","PSA","21","10","10","Ni kager kari mu nunga kuriang nunga moar se kuemon, se nunga taleng girigir bo ta ali imi te udagi me bagarukko. ");
INSERT INTO wsk_vpl VALUES ("PS21_11","020_21_11","PSA","21","11","11","Nuna ikia kalomon ta, den kalomon ta, bare nuna me ta ka kiamonko. ");
INSERT INTO wsk_vpl VALUES ("PS21_12","020_21_12","PSA","21","12","12","Mu awuk, ni ka gatu nongote sapar se nuna nagumonko. ");
INSERT INTO wsk_vpl VALUES ("PS21_13","020_21_13","PSA","21","13","13","O Yawe, nika sokel aora garagar; se mu ko wur ilunak ale nip kualala biya patawunakko. ");
INSERT INTO wsk_vpl VALUES ("PS22_1","020_22_1","PSA","22","1","1","(David ko wur) Aninga Kaem, aninga Kaem, ni awuk se biring gurugu aisem? Ni awuk se aninga aira me ikisam, ale awuk se ani me aga sangorsam? ");
INSERT INTO wsk_vpl VALUES ("PS22_2","020_22_2","PSA","22","2","2","O aga Kaem, ani woremkalal ka arusam, bare ni ani agiring me ilusam; aking tirom ai lagasam, aeman me sapasam. ");
INSERT INTO wsk_vpl VALUES ("PS22_3","020_22_3","PSA","22","3","3","Bare ni King, keta laili nunguningkiri; ana Israel suen la ni nip patawusan. ");
INSERT INTO wsk_vpl VALUES ("PS22_4","020_22_4","PSA","22","4","4","Nanga taleng girigir ni ko ko nongomang ningi nunguning aram, se ni memek ningi nunga sangem ale nunga giem. ");
INSERT INTO wsk_vpl VALUES ("PS22_5","020_22_5","PSA","22","5","5","Nuna nikate niaman, se ni nunga sangem; nuna ni ko ko nongomang ningi nunguning aram, se ni me nunga bita tokasam, am nunga sangarukasam, ale nunga giem. ");
INSERT INTO wsk_vpl VALUES ("PS22_6","020_22_6","PSA","22","6","6","Bare ani kariimet iwita mena, ani ali ko malalok iwita; kariimet suen la ani agarki maguwusan ale aga gusisan. ");
INSERT INTO wsk_vpl VALUES ("PS22_7","020_22_7","PSA","22","7","7","Ale suen la agarkasan mu den kolara balsan, ale nusumulak daleluwu sapasan ale nusupuling sapa gilingisan. ");
INSERT INTO wsk_vpl VALUES ("PS22_8","020_22_8","PSA","22","8","8","Ale aga manorsan, “Ni Yawe ko gemang ningi nunguning masam, bare awuk se me ka sangarso? E nu nika kueso, mu awuk se me ka sangarso?” iwita aga balu gilingisan. ");
INSERT INTO wsk_vpl VALUES ("PS22_9","020_22_9","PSA","22","9","9","Bare ni keta ani ayam tuagu ningi yawarakala aga sinar taem se bilangerem; ale tom ani amin nowakasam mu ni ninguru aga sinar tokasam. ");
INSERT INTO wsk_vpl VALUES ("PS22_10","020_22_10","PSA","22","10","10","Ani bilanga se la, ni ko ko angamang ningi nunguning aram; se ni aninga Kaem bagerem tai aitak. ");
INSERT INTO wsk_vpl VALUES ("PS22_11","020_22_11","PSA","22","11","11","Ani ikup aga iram, se ni ani me aga bitarko! Ani kariimet ito aga sangukko mena. ");
INSERT INTO wsk_vpl VALUES ("PS22_12","020_22_12","PSA","22","12","12","Bulmakau diwang iwita aga taluluru gilingiman; nuna sokel ago nunguningkiri, Bashan sor ko bulmakau turan. ");
INSERT INTO wsk_vpl VALUES ("PS22_13","020_22_13","PSA","22","13","13","Nuna lion iwita mel bo momonko ngang masan ale niasan iwita, aga momon maguwumonko bagasan. ");
INSERT INTO wsk_vpl VALUES ("PS22_14","020_22_14","PSA","22","14","14","Se yu ali awote kaposo ale palenga namoso iwitata, ani asokel mena saparam; ani angimik sokel kutukutuk ma saparam. Aninga angamang motam ningi mu candle iwita kaniram ale palengam kaposo. ");
INSERT INTO wsk_vpl VALUES ("PS22_15","020_22_15","PSA","22","15","15","Ani adogotak garagara mam, ale angamili tarigi gek mam; ni ani kuerikko aga beterem, se ani kuesam. ");
INSERT INTO wsk_vpl VALUES ("PS22_16","020_22_16","PSA","22","16","16","Kausik memek aga taluluru guruguman iwita, kari memek aga taluluru guruguman. Nuna aga asiwik agiting usi barukuman. ");
INSERT INTO wsk_vpl VALUES ("PS22_17","020_22_17","PSA","22","17","17","Se aninga angimik sokel suen la mu ani ko ikiwasam; kariimet ani agarkasan ale “terong memek tam” ma balsan. ");
INSERT INTO wsk_vpl VALUES ("PS22_18","020_22_18","PSA","22","18","18","Nuna aninga angimik guang kututuwu giman ale pagaru nunumi tuman; ale aga guang bo kolamon ale awiriya taukko mu ko kola gilingiman. ");
INSERT INTO wsk_vpl VALUES ("PS22_19","020_22_19","PSA","22","19","19","Bare Yawe, ni awar biya me bagerko! Ni aninga Saonga Kari, tairatela tair ale aga sangaruko! ");
INSERT INTO wsk_vpl VALUES ("PS22_20","020_22_20","PSA","22","20","20","Batir kore ningi aga sangaru toko! Kausik nogore ningi ni aga sangaru toko! ");
INSERT INTO wsk_vpl VALUES ("PS22_21","020_22_21","PSA","22","21","21","Lion nuguring ningi aga bataguru toko! Bulmakau daong memek mu ko aga sangaru toko! ");
INSERT INTO wsk_vpl VALUES ("PS22_22","020_22_22","PSA","22","22","22","Ani ka nip, ka dugu duap aga singsang nunga manikko; ale biguwura ningi ka nip patawurikko. ");
INSERT INTO wsk_vpl VALUES ("PS22_23","020_22_23","PSA","22","23","23","Ale nunga manik, nina arikaya Yawe kuring bowa ningi bagasan mu ko nup patawuralko! Nina Jacob ko taleng girigir, nup biya tualko! Nina Israel ko taleng girigir, nguanga se nup patawuralko! ");
INSERT INTO wsk_vpl VALUES ("PS22_24","020_22_24","PSA","22","24","24","Mu awuk, awiriya ikup memek arigiso, bare nu me ari pateso, ale koma motam me kaluwu namoso, mena; nu aninga aira ikiam, ale aga saongam. ");
INSERT INTO wsk_vpl VALUES ("PS22_25","020_22_25","PSA","22","25","25","Biguwura biya te ani ka nip patawurikko; ale anapeya munan bita kisekko mu, kariimet nika kiring bowa ningi bagasan mu nomokete bita kisekko. ");
INSERT INTO wsk_vpl VALUES ("PS22_26","020_22_26","PSA","22","26","26","Se kariimet nunup mena, kituwura guat mu, na namon nungumik ago terong maukko; kariimet ni ko ko kuesan mu nika nip patawumonko. O Yawe, marak nungaru, se tom suen biya amilmil ago la bagamonko! ");
INSERT INTO wsk_vpl VALUES ("PS22_27","020_22_27","PSA","22","27","27","Ali koma suen la te, kariimet Yawe ko ikimon ale giris palagamon ale kote taimonko; ali lilim ko kariimet nu koma te nubugura kulukurmonko, ");
INSERT INTO wsk_vpl VALUES ("PS22_28","020_22_28","PSA","22","28","28","mu awuk, Yawe nu King Biya; nu ali sor suen la nunga bitarso. ");
INSERT INTO wsk_vpl VALUES ("PS22_29","020_22_29","PSA","22","29","29","Kariimet nungumik mel karogo mu no gi se nup patawumonko; kariimet tom tukunangta baga kua iwi namasan, mu suen la koma dugu te nubugura kulukurmon ale nup patawumonko, mu awuk, nuna pempem marak me baga lagamonko. ");
INSERT INTO wsk_vpl VALUES ("PS22_30","020_22_30","PSA","22","30","30","Se kariimet gue udagi taiwasan mu nu bowa ningi bagamonko; ale nunga kuriang gue mu Kari Biya ko dugu duap nunga manarmon se ikimonko. ");
INSERT INTO wsk_vpl VALUES ("PS22_31","020_22_31","PSA","22","31","31","Nuna noko kiwem ningo umu balu pagarmon ale balmon, “Nu nanga sangaru tam!” mamon se kariimet gue me bilangasan mu maingte karogo ikimonko. ");
INSERT INTO wsk_vpl VALUES ("PS23_1","020_23_1","PSA","23","1","1","(David ko wur) Yawe mu aninga Bitua Kari, se ani mel bo ko me tukunangasam. ");
INSERT INTO wsk_vpl VALUES ("PS23_2","020_23_2","PSA","23","2","2","Nu ani kuwim ningo wolong wore te agarak namoso, yu ningo bo duap te agarak namoso, se ani dagisam ale aeman sapasam. ");
INSERT INTO wsk_vpl VALUES ("PS23_3","020_23_3","PSA","23","3","3","Nu sokel sangam iru aisiso; ale kota ko nup biya ko ningo ko, nu aninga kiti guruguso se lage ningo diram mu karosam. ");
INSERT INTO wsk_vpl VALUES ("PS23_4","020_23_4","PSA","23","4","4","Ani ta memek biya ningi kaparik, bare ani memek mu ko me nguangarikko, mu awuk, ni ani agarak bagasam; nika tam te aga bitarsam mu se, nika sikir te aolak ilu se aga kiti gurugusam mu ani sokel aisiso. ");
INSERT INTO wsk_vpl VALUES ("PS23_5","020_23_5","PSA","23","5","5","Ni aninga kager kari nomotam te na ningo ningo angama te awusam; ale oil siring yawara asupuling te warsam; se ani ninguru ko amilmilasam. ");
INSERT INTO wsk_vpl VALUES ("PS23_6","020_23_6","PSA","23","6","6","Nunguningta, nika ningo se nika gemang lila mu ani agarak pempem ani se lagarukko, se ani ni kerak ka bagara kuwim te butata baga se lagarikko. ");
INSERT INTO wsk_vpl VALUES ("PS24_1","020_24_1","PSA","24","1","1","(David ko wur) Ali imi, se mel suen biya awote aniso, mu Yawe ko la; ali imi lilim la, se kariimet suen la te anisan, mu Kaem ko la. ");
INSERT INTO wsk_vpl VALUES ("PS24_2","020_24_2","PSA","24","2","2","Nu yu gagi nungam asele balam se yu nama kuwim suanta bolala awuman se ali sor aratam ale sokel ago aniso. ");
INSERT INTO wsk_vpl VALUES ("PS24_3","020_24_3","PSA","24","3","3","Arika Yawe ko duruk te nama tarigimonko terong? Ale arika noko kuwim laili mu te sanamamonko terong? ");
INSERT INTO wsk_vpl VALUES ("PS24_4","020_24_4","PSA","24","4","4","Mu kariimet nuguting karur mena, se nongomang motam lilim, se kaem kawel me nunup patawusan, ale saki alo den kawel te me nunga kulursan, kariimet uwuta mu Kaem ko kuwim umu te bagamonko terong. ");
INSERT INTO wsk_vpl VALUES ("PS24_5","020_24_5","PSA","24","5","5","Kariimet uwuta umu Yawe nunga sangaru tauk ale ningo diram ko nunga baluk ale marak sokel yawara nungarukko. ");
INSERT INTO wsk_vpl VALUES ("PS24_6","020_24_6","PSA","24","6","6","Kariimet uwutata mu asele Kaem kote pingi namamonko terong maman, ale Jacob ko Kaem nup patawumonko terong maman. ");
INSERT INTO wsk_vpl VALUES ("PS24_7","020_24_7","PSA","24","7","7","Songkuring kagaru karogo namaralko; girakala ko songkuring kagaru ulal awural se nikim biya ko King te kasu nagurokko! ");
INSERT INTO wsk_vpl VALUES ("PS24_8","020_24_8","PSA","24","8","8","Se nikim biya ko King mu awiri ya? Mu Yawe sokel garagar nunguningkiri, nu kager te sokel karogo. ");
INSERT INTO wsk_vpl VALUES ("PS24_9","020_24_9","PSA","24","9","9","Se songkuring kagaru karogo namaralko; girakala ko songkuring kagaru ulal awural se nikim biya ko King te kasu nagurokko! ");
INSERT INTO wsk_vpl VALUES ("PS24_10","020_24_10","PSA","24","10","10","Se nikim biya ko King mu awiri ya? Mu Yawe Sokel Garagar umutang nikim biya ko King! ");
INSERT INTO wsk_vpl VALUES ("PS25_1","020_25_1","PSA","25","1","1","(David ko wur) O Yawe, aninga Kaem, ani nikate la ira sanamasam. ");
INSERT INTO wsk_vpl VALUES ("PS25_2","020_25_2","PSA","25","2","2","Aninga angamang motam nikate la bita lagasam; ni aninga sangaru se aga kager kari me agarak kapamon ale dolara aisimonko. ");
INSERT INTO wsk_vpl VALUES ("PS25_3","020_25_3","PSA","25","3","3","Awiriya noko ikia nikate la bita lagoso, mu me ta dolurukko; bare kariimet awiriya kawel munan te lagasan mu dolomonko. ");
INSERT INTO wsk_vpl VALUES ("PS25_4","020_25_4","PSA","25","4","4","O Yawe, nika munan ningo aga kasuru ale nika lage ningo aga kasuruko. ");
INSERT INTO wsk_vpl VALUES ("PS25_5","020_25_5","PSA","25","5","5","Nika den nunguning te aga kiti gurugu ale ikia sinar aisko, mu awuk, ni aninga Kaem se aga Saonga Kari; ani kowarkalal maiya nika ko amotam bita lagasam. ");
INSERT INTO wsk_vpl VALUES ("PS25_6","020_25_6","PSA","25","6","6","Nika gemang lila se nika kua nangara, girakala la bita lagasam, mu ko kamili me saparukko. ");
INSERT INTO wsk_vpl VALUES ("PS25_7","020_25_7","PSA","25","7","7","O Yawe, aninga kulak te munan memek beterem, ale asupuling lagara ko kiwem beterem, mu ko kamin me tugumko; nika ningo, se nika kua nangara ko munan mu te ago ko iki ale aga sangaruko. ");
INSERT INTO wsk_vpl VALUES ("PS25_8","020_25_8","PSA","25","8","8","Yawe mu ningo se diram la; se nu kariimet memek bitawara mu, nu noko munan nunga kasurso se nuna karo tusan. ");
INSERT INTO wsk_vpl VALUES ("PS25_9","020_25_9","PSA","25","9","9","Nunumi karogo kapara ko kariimet mu, nu nunga kiti guruguso ale munan diram mu nunga kasurso se karo tusan. ");
INSERT INTO wsk_vpl VALUES ("PS25_10","020_25_10","PSA","25","10","10","Kariimet noko den balam mu karo tusan mu, noko munan mu yawarakala se diram la nongote bita lagoso. ");
INSERT INTO wsk_vpl VALUES ("PS25_11","020_25_11","PSA","25","11","11","O Yawe, nika nip biya mu ko ningo ko, aninga memek duap duap suen la mu siwu aisuko. ");
INSERT INTO wsk_vpl VALUES ("PS25_12","020_25_12","PSA","25","12","12","Kariimet awiriya Yawe bowa ningi la bagasan, mu nu lage ningo nunga kausok se nuna karo tumonko. ");
INSERT INTO wsk_vpl VALUES ("PS25_13","020_25_13","PSA","25","13","13","Nuna daiga bagara ningo arigimonko, se nunga kuriang gue ali imi te terong baga lagamonko. ");
INSERT INTO wsk_vpl VALUES ("PS25_14","020_25_14","PSA","25","14","14","Se nuna munan umu te Yawe nunga balso noko tiran ningo maso, ale noko den nongorak kaolam mu nunga kasurso. ");
INSERT INTO wsk_vpl VALUES ("PS25_15","020_25_15","PSA","25","15","15","Aninga amotam mu Yawe kote la loaga lagasam, mu awuk, nu kota aninga sanguk se dagarok memek mu kiarikko. ");
INSERT INTO wsk_vpl VALUES ("PS25_16","020_25_16","PSA","25","16","16","O aga Biya, gemang aisu ale kema gurugu aisuko, mu awuk, ani angimik saonga bo mena se angimik sokel menaram. ");
INSERT INTO wsk_vpl VALUES ("PS25_17","020_25_17","PSA","25","17","17","Aninga angamang motam ko ikup mu lagaram, se ikup mu te aga sangaru se angimik guyak arukko. ");
INSERT INTO wsk_vpl VALUES ("PS25_18","020_25_18","PSA","25","18","18","Aga angamang yaman se angamang ikup agarak gi ale aga memek suen la siwu waruko. ");
INSERT INTO wsk_vpl VALUES ("PS25_19","020_25_19","PSA","25","19","19","Arikko! Aninga kager kari mu suen biya nunguningkiri! Nuna nunga ikia te ani ago ko nongomang ninguru tala magoso! ");
INSERT INTO wsk_vpl VALUES ("PS25_20","020_25_20","PSA","25","20","20","Se ni aga sangaru to ale aga bitaru se dolara me aisimonko, mu awuk, ni aninga yumura kuwim. ");
INSERT INTO wsk_vpl VALUES ("PS25_21","020_25_21","PSA","25","21","21","Munan ningo se munan diram mu te aga sangaru, se ani te sokel ago sanamarikko, mu awuk, ani nikate la amotam bita lagasam. ");
INSERT INTO wsk_vpl VALUES ("PS25_22","020_25_22","PSA","25","22","22","O Kaem, ni ka kariimet Israel nunga ikup suen la te nunga sangaruko! ");
INSERT INTO wsk_vpl VALUES ("PS26_1","020_26_1","PSA","26","1","1","(David ko wur) O Yawe, aga sangaruko, mu awuk, aninga bagara aolak ko ninguru sinar tokasam, ale ni bowa ningi la baga se, bola pala me nama taikasam. ");
INSERT INTO wsk_vpl VALUES ("PS26_2","020_26_2","PSA","26","2","2","Yawe, ni ani agarki gurugu ale aga angamang motam, aga ikia ningi loager ale memek i arik mu siwu waruko, ");
INSERT INTO wsk_vpl VALUES ("PS26_3","020_26_3","PSA","26","3","3","mu awuk, nika kua aisa mu aninga mel gira nunguningkiri ko betesam, ale ani pempem la nika den nunguning mu karo tui lagasam. ");
INSERT INTO wsk_vpl VALUES ("PS26_4","020_26_4","PSA","26","4","4","Ani kawel kariimet mu arungak me aimi gisam, ale kariimet nungamili sorang karogo mu arungu me sorasam. ");
INSERT INTO wsk_vpl VALUES ("PS26_5","020_26_5","PSA","26","5","5","Ani kariimes memek duap duap bitawara mu arungak me bolala awusam, ale kariimet ikia memek ago mu nunga dulursam. ");
INSERT INTO wsk_vpl VALUES ("PS26_6","020_26_6","PSA","26","6","6","Yawe, aninga bagara aolak ko ninguru sinar tasam, ale umu te ani nika altar duap te taisam, ");
INSERT INTO wsk_vpl VALUES ("PS26_7","020_26_7","PSA","26","7","7","ale ka wur bo nika nip te patawura mu ilu se, nika kiwem duap duap mu ko balsam. ");
INSERT INTO wsk_vpl VALUES ("PS26_8","020_26_8","PSA","26","8","8","Yawe, ani nika temple laili mu ningi bagarikko kua lagasam; mu borta te nika kimik nikim te aniso. ");
INSERT INTO wsk_vpl VALUES ("PS26_9","020_26_9","PSA","26","9","9","Ni memek betera ko kariimet se kariimet nuguting gue karogo mu nongorak me aga sarumu saparko. ");
INSERT INTO wsk_vpl VALUES ("PS26_10","020_26_10","PSA","26","10","10","Nuna kilek memek betemonko sinar ago bagasan, ale manga te kariimet nongomang kulukursan. ");
INSERT INTO wsk_vpl VALUES ("PS26_11","020_26_11","PSA","26","11","11","Bare ani mu aga bagara aolak ko ninguru sinar tasam, bore te se gemang lila te aga sangaru toko! ");
INSERT INTO wsk_vpl VALUES ("PS26_12","020_26_12","PSA","26","12","12","Se aitak ani gek am bagasam; se tom nika kariimet tai ilu biguwumon, mu ani ni Yawe ka nip patawurikko. ");
INSERT INTO wsk_vpl VALUES ("PS27_1","020_27_1","PSA","27","1","1","(David ko wur) Yawe mu aninga nikim se aninga saonga; buta se ani awiri ko nguangarikko? Nu aga bitarso se ani mel bo ko me uririkisam. ");
INSERT INTO wsk_vpl VALUES ("PS27_2","020_27_2","PSA","27","2","2","Kariimet memek aga momon maguwumonko taimon mu, nongota dagulomon memek tamonko. ");
INSERT INTO wsk_vpl VALUES ("PS27_3","020_27_3","PSA","27","3","3","Kager motam biya taimon ale aga laturmon, bare ani me ta nguangarikko; kager kari taimon agarak kagermon ta wore ani am gek kiriyam bagarikko. ");
INSERT INTO wsk_vpl VALUES ("PS27_4","020_27_4","PSA","27","4","4","Ani Yawe mel suanta ko isuem mu iwita: ani noko temple ningi pempem la ilak baga se, noko melmasak duap duap kumik nikim ningi mu ari se, amotam welang tai se, ko ikia to se lagarikko. ");
INSERT INTO wsk_vpl VALUES ("PS27_5","020_27_5","PSA","27","5","5","Se ikup kam ningi mu nu ko kuting bowa ningi aga kaluwurok, ale duruk bo noko duruk Zion iwita te aga bitiruk se ningo la bagarikko. ");
INSERT INTO wsk_vpl VALUES ("PS27_6","020_27_6","PSA","27","6","6","Se kari memek aga momon maguwumonko mu, aliti biya bagamon se ani kualala Yawe ko temple ningi iwita baga se airik ale amilmil te wur yagowom gurugek ale tama bita Yawe tua iwita tuekko. ");
INSERT INTO wsk_vpl VALUES ("PS27_7","020_27_7","PSA","27","7","7","O Yawe, airik mu agiring ikiko, gemang lila aisu ale aga guranek ikiko. ");
INSERT INTO wsk_vpl VALUES ("PS27_8","020_27_8","PSA","27","8","8","Aninga angamang motam balso, nika kema motam arigekko; se Yawe, nika kema motam arigekko angamang aniso. ");
INSERT INTO wsk_vpl VALUES ("PS27_9","020_27_9","PSA","27","9","9","Se ni kema motam ani ago ko me kaluwurko; gemang memek te ani ka ura kari me aga karoko, mu awuk, ni keta ani aga sangorsam. Ni biring me aisu ale me agarki daleluwurko, O Kaem, aninga Saonga Kari. ");
INSERT INTO wsk_vpl VALUES ("PS27_10","020_27_10","PSA","27","10","10","Aninga nang ba ilak agarki daleluwumon, bare Yawe, ni aninga aru tagisam. ");
INSERT INTO wsk_vpl VALUES ("PS27_11","020_27_11","PSA","27","11","11","O Yawe, ni ka munan aga kasuruko, mu awuk, aninga bita maguwura ko kari suen biya bagasan; buta se nika lage diram mu te agarak namarko. ");
INSERT INTO wsk_vpl VALUES ("PS27_12","020_27_12","PSA","27","12","12","Ni kari memek nungarkiwer se nunga ikia memek mu te me aga ilumonko; nuna ani aip te den kawel ninguru balsan ale aga bita maguwusan. ");
INSERT INTO wsk_vpl VALUES ("PS27_13","020_27_13","PSA","27","13","13","Bare ani am ninguru ko iki saperem, Yawe ani ago ko ningo bitirukko mu ani amotam te arigekko. ");
INSERT INTO wsk_vpl VALUES ("PS27_14","020_27_14","PSA","27","14","14","Ani Yawe kote la loaga se kimi bita sagarikko; ani angamang sail tuek ale sokel karogo la bagarik se nu aninga sangukko. ");
INSERT INTO wsk_vpl VALUES ("PS28_1","020_28_1","PSA","28","1","1","(David ko wur) O Yawe, ni aninga Manga gek am, ani nikate aisam; degewa gurugu ale agiring ilupko; mena mu, ani kariimet kua namaman mu toroman kua namarikko. ");
INSERT INTO wsk_vpl VALUES ("PS28_2","020_28_2","PSA","28","2","2","Aninga niara ikiko, gemang aisu ale aga sangaruko! Ani agiting patawurem nika kuwim laili te bagasam mu te garukem ale ka arusam. ");
INSERT INTO wsk_vpl VALUES ("PS28_3","020_28_3","PSA","28","3","3","Ani kariimet memek bitawara mu arungak me aga gurasi saparko; nuna kariimet nongorak bagasan mu arungu den welang balsan, bare nongomang motam ningi ikia memek karogo terong mam. ");
INSERT INTO wsk_vpl VALUES ("PS28_4","020_28_4","PSA","28","4","4","Nononga kiwem memek bita lagaman mu koma nungaruko; nunga memek mu ko koma, te beteman uwutata te iki iki koma nungaruko. ");
INSERT INTO wsk_vpl VALUES ("PS28_5","020_28_5","PSA","28","5","5","Nuna Yawe ko ura biya se mel bita lagaram mu me ko ikia tasan; buta se nu nunga maguwurok ale nunga menawurokko. ");
INSERT INTO wsk_vpl VALUES ("PS28_6","020_28_6","PSA","28","6","6","Ani Yawe ko nup patawurikko, mu awuk, nu aninga aira ikiam. ");
INSERT INTO wsk_vpl VALUES ("PS28_7","020_28_7","PSA","28","7","7","Yawe mu aninga sokel se aninga karem; ani nu te ira sanamasam se nu aninga sangarso; se ani ninguru amilmilasam ale wur te nup patawusam. ");
INSERT INTO wsk_vpl VALUES ("PS28_8","020_28_8","PSA","28","8","8","Yawe mu ko kariimet nunga sokel bagoso; nu ko king baongam mu bitarso ale sangaru taso. ");
INSERT INTO wsk_vpl VALUES ("PS28_9","020_28_9","PSA","28","9","9","Se Yawe, nika kariimet nika ma nunga balem mu nunga sangaru ale marak sokel nungaruko; ale nunga bitua kari baga se nunga gi patawu se nunga bitaruko. ");
INSERT INTO wsk_vpl VALUES ("PS29_1","020_29_1","PSA","29","1","1","(David ko wur) Nina engel sail karogo bibiya, Yawe ko nup patawuralko; noko nup biya se noko sail ko amilmilaralko! ");
INSERT INTO wsk_vpl VALUES ("PS29_2","020_29_2","PSA","29","2","2","Yawe ko nup patawural ale nup biya tualko; ko nup laili mu ko amilmil tualko! ");
INSERT INTO wsk_vpl VALUES ("PS29_3","020_29_3","PSA","29","3","3","Yawe munakoso se gagi gomang suen la te kuring iki gilingisan; Kaem nup biya, se sail te aiso mu pure iwita niaso ale, noko den mu niaso gagi gomang suen la te geragoso. ");
INSERT INTO wsk_vpl VALUES ("PS29_4","020_29_4","PSA","29","4","4","Yawe ko aira mu sokel karogo, noko kuring dogotak mu sokel karogo se aora biya. ");
INSERT INTO wsk_vpl VALUES ("PS29_5","020_29_5","PSA","29","5","5","Noko aira mu aora biya se tam gagam iwita mu yam pakak maso, Lebanon ko tam aora sida mu pakak maso se bilik bilik kaposo. ");
INSERT INTO wsk_vpl VALUES ("PS29_6","020_29_6","PSA","29","6","6","Nu negeso se Lebanon sor uririkiso ale bulmakau gotek iwita tengeso geragoso, se duruk Hermon mu bulmakau diwang gotek iwita biririkoso. ");
INSERT INTO wsk_vpl VALUES ("PS29_7","020_29_7","PSA","29","7","7","Yawe ko aira mu pure nikim iwita taiti gomang te biliwilik maso. ");
INSERT INTO wsk_vpl VALUES ("PS29_8","020_29_8","PSA","29","8","8","Yawe ko dogotak sor garagarayam mu lilim sisuwuso; nu sor garagarayam Kadesh mu yukurso. ");
INSERT INTO wsk_vpl VALUES ("PS29_9","020_29_9","PSA","29","9","9","Yawe ko aira mu tam bibiya yam moa irukuso ale gawa kower kulukumuso se kaposo se sor wetang aso. Se noko temple ningi mu suen la aisan ale balsan, “Kaem nup biya!” masan. ");
INSERT INTO wsk_vpl VALUES ("PS29_10","020_29_10","PSA","29","10","10","Yawe nu King bagoso, yu gagi lilim bitarso; Yawe nu King pempem la bagoso. ");
INSERT INTO wsk_vpl VALUES ("PS29_11","020_29_11","PSA","29","11","11","Yawe ko kariimet sangam sokel nungarso; Yawe ko gomang lila kariimet nungarso. ");
INSERT INTO wsk_vpl VALUES ("PS30_1","020_30_1","PSA","30","1","1","(Temple nup sapara ko wur bo; David ko) Yawe, ani nika nip patawurikko; mu awuk, ani ikup ningi kaperem, bare ni aninga patawurem, se kari memek me aga eremon se kaparik se amilmilamonko. ");
INSERT INTO wsk_vpl VALUES ("PS30_2","020_30_2","PSA","30","2","2","O Yawe, aninga Kaem, ani saonga ko kete airem, se ni aga sangem ale aga nungem. ");
INSERT INTO wsk_vpl VALUES ("PS30_3","020_30_3","PSA","30","3","3","Ani kuera lage te, bare ni aninga sangaru taem, se ani me kua iwi namerem. ");
INSERT INTO wsk_vpl VALUES ("PS30_4","020_30_4","PSA","30","4","4","Nina Yawe ko kariimet ningo, nina wur iluwal ale noko nup laili mu patawuralko. ");
INSERT INTO wsk_vpl VALUES ("PS30_5","020_30_5","PSA","30","5","5","Mu awuk, noko gomang magara mu tom tukunangta ko aniso, bare noko gomang nangara mu tom pempem ko ani lagoso; tirom am nia mo laganakko, bare turomola mu amilmil yawara aking ariginakko. ");
INSERT INTO wsk_vpl VALUES ("PS30_6","020_30_6","PSA","30","6","6","Yawe, tom ani terong baga se mu, ani balem, “Mel bo me ta aga yukuokko,” maem; ");
INSERT INTO wsk_vpl VALUES ("PS30_7","020_30_7","PSA","30","7","7","tom ni ani ago ko terong bitakasam, mu ani duruk aora bo iwita sanamiwakasam; bare tom ni ani ago ko kema kaluwurem, mu ani ninguru tala nguangakasam. ");
INSERT INTO wsk_vpl VALUES ("PS30_8","020_30_8","PSA","30","8","8","Buta se Yawe, ani nika aurem, ale nika gemang lila ko niara wosenga beterem, ");
INSERT INTO wsk_vpl VALUES ("PS30_9","020_30_9","PSA","30","9","9","ale balem, “Ani kurakor kuring nagurek ale mutim ningi kua namarik mu, anape mel ningo ningi aratukko? Mena. Kariimet kueso ale kupkup aso mu, awuk nika nip patawurukko? Agi kuring paguk se nika munan ningo mu ko baluk i? Mena. ");
INSERT INTO wsk_vpl VALUES ("PS30_10","020_30_10","PSA","30","10","10","O Yawe, ni ani agiring iki ale gemang aisuko; aninga Saonga Kari bagerko!” ");
INSERT INTO wsk_vpl VALUES ("PS30_11","020_30_11","PSA","30","11","11","Se ni aninga niara ma mu gurugem se nama irua amilmil ko aram; se kuera mateng ko guang angimik te aniram mu kututuwu warem ale nika amilmil mu guang iwita tugu aisem. ");
INSERT INTO wsk_vpl VALUES ("PS30_12","020_30_12","PSA","30","12","12","Buta se ani agiring me ta kalikko, ani wur iluwek ale ka nip patawurikko. O Yawe, aninga Kaem, ani butata pempem nika nip patawu se lagarikko. ");
INSERT INTO wsk_vpl VALUES ("PS31_1","020_31_1","PSA","31","1","1","(David ko wur) Yawe, ani nikate tairem, ni aninga bitaru se kari memek nuguting te memek me arigek ale dolirikko; nika munan diram te aga bataguru toko. ");
INSERT INTO wsk_vpl VALUES ("PS31_2","020_31_2","PSA","31","2","2","Ni aninga guranek iki ale pasak ala aga bataguru toko; ni manga bo duruk iwita bagasam, se ani nika ningi yumurekko; ni aninga laturu se ani terong bagarik se kager kari me ta aga maguwumonko! ");
INSERT INTO wsk_vpl VALUES ("PS31_3","020_31_3","PSA","31","3","3","Nunguningta, ni aninga kuwim yumura, se ni aninga sinar tasam; se nika nip ningo mu ko iki se aga diruwur ale lage ningo mu te agarak namarko. ");
INSERT INTO wsk_vpl VALUES ("PS31_4","020_31_4","PSA","31","4","4","Kari memek dagarok kira gilingiman, ani te aga ilumonko, bare ni aninga sinar to se ani te memek me arigekko, mu awuk, ni aninga manga gek am. ");
INSERT INTO wsk_vpl VALUES ("PS31_5","020_31_5","PSA","31","5","5","O Yawe, ani agata aimi ni kiting te betesam; ni kiwem nunguning la betera ko Kaem, ni aninga bataguru toko. ");
INSERT INTO wsk_vpl VALUES ("PS31_6","020_31_6","PSA","31","6","6","Ani kariimet kaem kawel nunup patawusan mu me nunga kuesam; bare Yawe, ani mu nikate la ira sanami lagasam. ");
INSERT INTO wsk_vpl VALUES ("PS31_7","020_31_7","PSA","31","7","7","Ni pempem la aninga kua lagasam, buta se ani nika amilmila lagarikko; mu awuk, ni aninga ikup yaman am ari ko iki saperem ale aga sangem. ");
INSERT INTO wsk_vpl VALUES ("PS31_8","020_31_8","PSA","31","8","8","Ni kari memek nungarkiwerem se nuna me aga talipaman, mena; ni aninga sangem se ani asiwik sor ipi ningo mu te beterem. ");
INSERT INTO wsk_vpl VALUES ("PS31_9","020_31_9","PSA","31","9","9","O Yawe, ni ani ago ko gemang batagukko, mu awuk, ani ikup biya ningi kaperem; ani nia mo lagerem ale amotam duap laga saparam, se angimik sokel menaram. ");
INSERT INTO wsk_vpl VALUES ("PS31_10","020_31_10","PSA","31","10","10","Aninga ikup imi kumik menara mena ko iwita, se aga ma niara imi te pasak ala kua namarikko agila pa; ikup memek oworete ani angimik sokel menaram ale angimik galugaluk aram. ");
INSERT INTO wsk_vpl VALUES ("PS31_11","020_31_11","PSA","31","11","11","Kari memek alo owore nungumik te se, aga bagara suan agarki patesan, se aga tiran gar alo mu mel memek bo iwita agarki gilingisan, ale lage te agarkasan mu nuna nagu gilingisan. ");
INSERT INTO wsk_vpl VALUES ("PS31_12","020_31_12","PSA","31","12","12","Nuna ani ago ko nungamili saparam, o kari maingkala kua namaram iwita; ani kani papak mam se waru sapaman iwita. ");
INSERT INTO wsk_vpl VALUES ("PS31_13","020_31_13","PSA","31","13","13","Kari memek abiring ko munakasan mu ani ikisam; nuna ani nguangara bo karogo aisimonko karogo kaesan; ale den ningi aga betemon ale aga momon se kuerikko karogo kaesan. ");
INSERT INTO wsk_vpl VALUES ("PS31_14","020_31_14","PSA","31","14","14","Bare Yawe, ani nikate la ira sanami lagasam; ale balsam, “Ni aninga Kaem,” masam. ");
INSERT INTO wsk_vpl VALUES ("PS31_15","020_31_15","PSA","31","15","15","Ani ni kiting te pempem la bagasam; ni kari memek aninga momonko aga karowasan umu nuguting te aga bataguru toko. ");
INSERT INTO wsk_vpl VALUES ("PS31_16","020_31_16","PSA","31","16","16","Ani nika ura kari, se ni gemang aisuko; nika kua aisa ko munan yawara mu te aga sangaru toko. ");
INSERT INTO wsk_vpl VALUES ("PS31_17","020_31_17","PSA","31","17","17","Yawe, ani nika arusam, ni kari memek me nungarki sager se dolara aisimonko; ni nuna dolara ikup memek ningi nunga waru se, kua paranga mutim ningi namamon ale sor kutek maukko. ");
INSERT INTO wsk_vpl VALUES ("PS31_18","020_31_18","PSA","31","18","18","Nuna kawel kari, nunumi patawusan ale nusupuling lagoso se kariimet ningo diram mu nunga den dolara balsan. Ni nuguring kalo se sisirokko! ");
INSERT INTO wsk_vpl VALUES ("PS31_19","020_31_19","PSA","31","19","19","O Yawe, ni kariimikiri saki nongoma te, kariimet ni bowa ningi nagu tai yumusan mu nika mel ningo ningo nungem mu nungaru gurugusam. ");
INSERT INTO wsk_vpl VALUES ("PS31_20","020_31_20","PSA","31","20","20","Ale kimik duap te nunga kaluwusam, se kari nunga bita maguwumonko den kalosan mu me ta nunga bita maguwumonko, ale kari den te nunga atumumonko mu nunga maguwumonko me terong tala. ");
INSERT INTO wsk_vpl VALUES ("PS31_21","020_31_21","PSA","31","21","21","Ani Yawe nup patawurikko, mu awuk, nu ani tawun biya aga kueso; se tom kager kari aninga karoman ale aga maguwumonko, mu nu aninga saongam se ani noko sokel te terong bagasam. ");
INSERT INTO wsk_vpl VALUES ("PS31_22","020_31_22","PSA","31","22","22","Ani ninguru nguangakasam, ale ikikasam mu ni aninga beterem ale awar biya bagasam iwita ko ikikasam; bare tom ani nikate wosengem, mu ni aninga niara ikiem ale aga sangem. ");
INSERT INTO wsk_vpl VALUES ("PS31_23","020_31_23","PSA","31","23","23","Buta se nina Yawe ko kariimet, nina noko ninguru ko kua tualko! Nu kariimet nu la karo tui lagasan mu ninguru nunga bitarso, bare nu nusupuling lagara ko kariimet mu koma memek nungarso. ");
INSERT INTO wsk_vpl VALUES ("PS31_24","020_31_24","PSA","31","24","24","Nina Yawe ko kariimet nukote la loaga lagasan, nina nengemang ningi gek am sanamaralko. ");
INSERT INTO wsk_vpl VALUES ("PS32_1","020_32_1","PSA","32","1","1","(David ko wur) Awiriya ko munan memek Kaem buring tuam ale ko memek siwu saparam mu amilmilarukko. ");
INSERT INTO wsk_vpl VALUES ("PS32_2","020_32_2","PSA","32","2","2","Awiriya gomang ningi nunguning te ko memek wetang te balu saparam se Yawe siwu tuam mu amilmilarukko. ");
INSERT INTO wsk_vpl VALUES ("PS32_3","020_32_3","PSA","32","3","3","Tom aninga memek ira kaluwukasam mu ani tirom woremkalal yaman karogo niara kikira te angimik sokel menakaso. ");
INSERT INTO wsk_vpl VALUES ("PS32_4","020_32_4","PSA","32","4","4","Mu awuk, tirom woremkalal nika kiting ko ikup aga moakaso, se worem sirsir kaiso se marakaso iwitata, angimik sokel maraka saparam. ");
INSERT INTO wsk_vpl VALUES ("PS32_5","020_32_5","PSA","32","5","5","Bare ani ari ko ikiem ale aga memek wetang te ni Yawe kema te balu saperem, se ni aga ikup memek mu suen la siwu saperem. ");
INSERT INTO wsk_vpl VALUES ("PS32_6","020_32_6","PSA","32","6","6","Buta se awiriya ni karo kisu lagoso mu noko ikup kam ningi pasak ala nikate airukko; se tom yu lom biya lairuk tarigiruk, mu nu te memek bo me taukko. ");
INSERT INTO wsk_vpl VALUES ("PS32_7","020_32_7","PSA","32","7","7","Ni aninga yumura kuwim; ni ikup kam ningi aga bitarsam ale aga sangaru tasam, ale sangaru ta ko wur amilmil angamang ningi betesam. ");
INSERT INTO wsk_vpl VALUES ("PS32_8","020_32_8","PSA","32","8","8","Yawe iwita balam: Ani ka kiti gurugek ale lage te namarko mu ka kausekko; ani de ilu se, ni aninga amotam te la bagerko. ");
INSERT INTO wsk_vpl VALUES ("PS32_9","020_32_9","PSA","32","9","9","Ni horse se donkey, ikia mena se mayang te diram nusumulak kalosan ale nunga tagisan, uwuta me bagerko. ");
INSERT INTO wsk_vpl VALUES ("PS32_10","020_32_10","PSA","32","10","10","Kariimet memek mu ikup yaman tamonko; bare awiriya Yawe kote ikia gomang bita lagoso, mu nu pempem gomang nungarso ale nunga sinar taso. ");
INSERT INTO wsk_vpl VALUES ("PS32_11","020_32_11","PSA","32","11","11","Se nina kariimet diram alo, mu Yawe ko amilmilaralko; nina noko kuring karo tusan, mu wur iluwal ale amilmil kelagalko! ");
INSERT INTO wsk_vpl VALUES ("PS33_1","020_33_1","PSA","33","1","1","Nina kariimet ningo diram, Yawe ko wur iluwal ale amilmil tualko; mu awuk, ana kariimet noko kuring karo tusan mu nup patawunakko mu munan diram. ");
INSERT INTO wsk_vpl VALUES ("PS33_2","020_33_2","PSA","33","2","2","Kulele moral ale noko nup patawuralko, gita moral ale amilmilaralko. ");
INSERT INTO wsk_vpl VALUES ("PS33_3","020_33_3","PSA","33","3","3","Wur iru iluwal ale gita moral, yagowom gurugal ale sail te airal amilmil tualko! ");
INSERT INTO wsk_vpl VALUES ("PS33_4","020_33_4","PSA","33","4","4","Mu awuk, Yawe ko den mu diram se nunguning, se ura suen la gomang ningi nunguning te beteso. ");
INSERT INTO wsk_vpl VALUES ("PS33_5","020_33_5","PSA","33","5","5","Nu munan ningo suen la ko kueso, ale anapeya ningo diram mu ko kueso; nu pempem la ali imi ko kariimet suen la nunga kueso. ");
INSERT INTO wsk_vpl VALUES ("PS33_6","020_33_6","PSA","33","6","6","Yawe den te balam se melmasak suen la kualala mu aratu muruwuman, worem se sige se baras mu taiti gomang te arataman. ");
INSERT INTO wsk_vpl VALUES ("PS33_7","020_33_7","PSA","33","7","7","Nu kari bo yu kani ningi utu betera iwita, gagi yu giam bolala awuram, ale ko tom tom te awu awu ago namaram; ale nu gagi ko nukum mu ali bowa ko du biya beteram. ");
INSERT INTO wsk_vpl VALUES ("PS33_8","020_33_8","PSA","33","8","8","Buta se ali imi te kariimet suen la noko ko la nguanga se kua tui se nu bowa ningi la bagaralko! ");
INSERT INTO wsk_vpl VALUES ("PS33_9","020_33_9","PSA","33","9","9","Mu awuk, nu den te balam se ali imi aratam; ale balam uwutata gek am aratu sanamaram. ");
INSERT INTO wsk_vpl VALUES ("PS33_10","020_33_10","PSA","33","10","10","Yawe ali ewere ko kariimet nunga ikia bitawasan mu batagarso ale parusuwuso se kirker namoso; nuna ura bo betemonko ikia kalomon, bare me ta betemonko. ");
INSERT INTO wsk_vpl VALUES ("PS33_11","020_33_11","PSA","33","11","11","Bare tom Yawe mel bo bitirukko ikia kaloso, mu uwutata arataso; noko gomang motam mu pempem butata ani lagoso. ");
INSERT INTO wsk_vpl VALUES ("PS33_12","020_33_12","PSA","33","12","12","Sor aguwaya mu nuna nunga Kaem mu Yawe, mu amilmilamonko; sor umu ko kariimet nu noko ma nunga balam, mu amilmilamonko. ");
INSERT INTO wsk_vpl VALUES ("PS33_13","020_33_13","PSA","33","13","13","Yawe duruk wonong te daigam baga se, loagoso se aliti kaposo se kariimet suen la nungarkoso; ");
INSERT INTO wsk_vpl VALUES ("PS33_14","020_33_14","PSA","33","14","14","nu ko sor te bagoso mu te baga se, kariimet ali lilim la imi te bagasan mu nungarkoso; ");
INSERT INTO wsk_vpl VALUES ("PS33_15","020_33_15","PSA","33","15","15","nuguta kariimet nongomang motam nungam, buta se nuna aguwaya betesan mu nu ko iki saposo. ");
INSERT INTO wsk_vpl VALUES ("PS33_16","020_33_16","PSA","33","16","16","King bo noko kager kari suen biya mu te la numi me sangarso; agi kager kari bo ta kota ko sokel mu te me numi bataguru taso, mena. ");
INSERT INTO wsk_vpl VALUES ("PS33_17","020_33_17","PSA","33","17","17","Uwutatala, kager te nanimi sangaru ta mu nanga horse ko sokel te la me aniso; nanga horse mu sokel tamatama wore me nanga sangukko. ");
INSERT INTO wsk_vpl VALUES ("PS33_18","020_33_18","PSA","33","18","18","Bare Yawe kariimet nu ko nguanga se nu bowa ningi la bagasan mu nunga sinar taso; awiriya noko kua nangara kumik menara mena mu te la ira sanamasan, ");
INSERT INTO wsk_vpl VALUES ("PS33_19","020_33_19","PSA","33","19","19","mu nu nunga sinar taso se nuna me kuesan; nu karak tom te na nungarso se terong la bagasan. ");
INSERT INTO wsk_vpl VALUES ("PS33_20","020_33_20","PSA","33","20","20","Ana Yawe kote la loagawasan; nu nanga Saonga Kari, se nanga karem. ");
INSERT INTO wsk_vpl VALUES ("PS33_21","020_33_21","PSA","33","21","21","Anananga nangamang motam ninguru ta nu ko ko amilmiloso, mu awuk, ana noko nup laili mu te la ira sanami lagasan. ");
INSERT INTO wsk_vpl VALUES ("PS33_22","020_33_22","PSA","33","22","22","O Yawe, nika kua nangara kumik menara mena mu nangaruko; ana nikate la nangamang ikia bita se lagasan. ");
INSERT INTO wsk_vpl VALUES ("PS34_1","020_34_1","PSA","34","1","1","(David Abimelech ilak baga se kota kari ngualara ko numi beteram se kaoram. David naguram asele wur imi batogam) Ani Yawe ko pempem balu se lagarikko; ko nup patawura mu ani agiring te butata anirukko. ");
INSERT INTO wsk_vpl VALUES ("PS34_2","020_34_2","PSA","34","2","2","Aninga adera angimik mu noko balu patawurukko; kariimet ikup giwasan mu ikimon ale amilmilamonko. ");
INSERT INTO wsk_vpl VALUES ("PS34_3","020_34_3","PSA","34","3","3","Nina ani agarak bolala la ko nup nikim garagar wore patawunakko; ana noko nup biya se noko sail ko amilmilanakko! ");
INSERT INTO wsk_vpl VALUES ("PS34_4","020_34_4","PSA","34","4","4","Ani Yawe kote niarem se nu ikiam ale aninga nguangara angimik ningi mu menawu saparam. ");
INSERT INTO wsk_vpl VALUES ("PS34_5","020_34_5","PSA","34","5","5","Kariimet nu kote la loaga lagasan mu nungumik guyak aso; nuna dolara mu me nunga ira kaluwurokko. ");
INSERT INTO wsk_vpl VALUES ("PS34_6","020_34_6","PSA","34","6","6","Ani ikup biya ningi kaperem ale nu aurem se nu ani agiring ikiam, ale aga ikup suen la te aga saongam. ");
INSERT INTO wsk_vpl VALUES ("PS34_7","020_34_7","PSA","34","7","7","Ikialko. Yawe ko engel mu kariimet noko nguangasan umu nunga laturso ale nunga sangaru taso. ");
INSERT INTO wsk_vpl VALUES ("PS34_8","020_34_8","PSA","34","8","8","Yawe kau to arik ale asele ko ningo nuam mu arikko; kariimet noko ningi yumusan mu amilmilamonko. ");
INSERT INTO wsk_vpl VALUES ("PS34_9","020_34_9","PSA","34","9","9","Nina noko kariimet alo, noko nguangaralko, mu awuk, kariimet nu ko nguangasan, mu mel bo ko me tukunangamonko. ");
INSERT INTO wsk_vpl VALUES ("PS34_10","020_34_10","PSA","34","10","10","Lion mu tom saki na ko kuesan ale nungumik sail menaso; bare kariimet Yawe kote loaga lagasan mu mel ningo bo ko me tukunangamonko. ");
INSERT INTO wsk_vpl VALUES ("PS34_11","020_34_11","PSA","34","11","11","Aninga kuriang alo, tairalko, tairal ale agiring ikialko; ani ninga kausek se Yawe ko nguanga se pempem la bowa ningi bagaralko. ");
INSERT INTO wsk_vpl VALUES ("PS34_12","020_34_12","PSA","34","12","12","Nenenga ningi awiriya marak baga se lagarukko kueso, ale ko gomang tom ningo ningo taiwoso mu arigokko agi mu, ");
INSERT INTO wsk_vpl VALUES ("PS34_13","020_34_13","PSA","34","13","13","kuring kuamili te den memek bo me baluk, ale kore sumulak te den kawel me ta balukko. ");
INSERT INTO wsk_vpl VALUES ("PS34_14","020_34_14","PSA","34","14","14","Nina kiwem memek nibiring tual ale kiwem ningo la beteralko; bagara welang se lila mu nengemang tual ale ko nisipiling diruwuralko. ");
INSERT INTO wsk_vpl VALUES ("PS34_15","020_34_15","PSA","34","15","15","Yawe ko motam mu kariimet diram mu nungarkiwoso, ale nunga aira ko dogowa gurugu lagoso; ");
INSERT INTO wsk_vpl VALUES ("PS34_16","020_34_16","PSA","34","16","16","bare kariimet memek betesan, mu nu buring gurugu nungarso, ale nunga menawuso se udagi kariimet bo me ta nunga ikiso. ");
INSERT INTO wsk_vpl VALUES ("PS34_17","020_34_17","PSA","34","17","17","Kariimet ningo diram mu niasan se Yawe nuguring iluso; nu nunga ikup suen la te nunga sangaru taso. ");
INSERT INTO wsk_vpl VALUES ("PS34_18","020_34_18","PSA","34","18","18","Ale kariimet nongomang motam batagam mu nongorak pingi baga se, kariimet nunumi ikisan mel bo betemonko me terong mu sangam nungarso. ");
INSERT INTO wsk_vpl VALUES ("PS34_19","020_34_19","PSA","34","19","19","Kariimet ningo diram mu ikup suen biya arigimonko, bare Yawe ikup suen la mu te nunga sangukko. ");
INSERT INTO wsk_vpl VALUES ("PS34_20","020_34_20","PSA","34","20","20","Nu nunga nungumik sokel suen la ko sinar tauk se bo ta me maga namarukko. ");
INSERT INTO wsk_vpl VALUES ("PS34_21","020_34_21","PSA","34","21","21","Memek betera ko kariimet alo mu memek arigimonko; nuna kariimet ningo diram mu nunga bita maguwuman mu ko koma memek tamonko. ");
INSERT INTO wsk_vpl VALUES ("PS34_22","020_34_22","PSA","34","22","22","Bare Yawe ko ura kariimet mu nunga sangaru taukko; awiriya noko ningi yumusan mu bo me ta memek tamonko. ");
INSERT INTO wsk_vpl VALUES ("PS35_1","020_35_1","PSA","35","1","1","(David ko wur) Yawe, awiriya ani agarak barimasan mu ni nongorak barimerko; awiriya ani agarak kagersan, mu ni nongorak kagererko. ");
INSERT INTO wsk_vpl VALUES ("PS35_2","020_35_2","PSA","35","2","2","Ni bares ale tai aga sangaruko; nika kager ko karem mel gi ale tai aga sangaruko. ");
INSERT INTO wsk_vpl VALUES ("PS35_3","020_35_3","PSA","35","3","3","Nika gatu mare se saenang gi ale tai kager aga ira baguram mu nongorak kagererko. Ni aninga adera angimik manaru ale balu, “Ani nika saonga ningo,” meko. ");
INSERT INTO wsk_vpl VALUES ("PS35_4","020_35_4","PSA","35","4","4","Kariimet aninga momon se kuerikko agarak kaeyawasan mu, nunga maguwur se dolomonko; arikaya aninga menawumonko ikia bitawasan mu, nunga parusuwur se pelemon ale ngualamon sipimonko. ");
INSERT INTO wsk_vpl VALUES ("PS35_5","020_35_5","PSA","35","5","5","Nuna tam gawa marir itugukoyam iwita nunga itugum se nika engel nunga diruwurok nongorak namarukko. ");
INSERT INTO wsk_vpl VALUES ("PS35_6","020_35_6","PSA","35","6","6","Nu nunga diruwurok se lage tiromorom se palepalengam mu te maga namamonko. ");
INSERT INTO wsk_vpl VALUES ("PS35_7","020_35_7","PSA","35","7","7","Nuna ani ago ko dagarok kira beteman mu kumik duap bo mena, ale ani ago ko mutim bo ilu beteman mu kumik duap bo mena tala. ");
INSERT INTO wsk_vpl VALUES ("PS35_8","020_35_8","PSA","35","8","8","Bare memek umu giris palaguk ale nongota nunga maguwurok se tengemonko; se dagarok beteman mu giris palaguk nongota nunga taliparukko, nongota mutim ilu beteman mu ningi dagulomon ale memek tamonko. ");
INSERT INTO wsk_vpl VALUES ("PS35_9","020_35_9","PSA","35","9","9","Se ani mu Yawe ko amilmilarik ale aga sangaru tam mu ko nup patawurikko. ");
INSERT INTO wsk_vpl VALUES ("PS35_10","020_35_10","PSA","35","10","10","Se aninga adera angimik lilim la te balik, “O Yawe, awiri nika turan a?” maikko. “Ni mu kituwura guat alo nunga bita maguwusan mu nunga sangaru tasam, ale kari memek nuguting te kariimet nosokel mena alo mu nunga bataguru tasam.” ");
INSERT INTO wsk_vpl VALUES ("PS35_11","020_35_11","PSA","35","11","11","Kari memek alo barasasan ale den kawel atumu aisisan; nuna ani mel me ko ikia wore ko aga isarsan. ");
INSERT INTO wsk_vpl VALUES ("PS35_12","020_35_12","PSA","35","12","12","Nuna aninga kiwem ningo mu ko koma kiwem memek agate betesan, se ani angamang motam dagulam. ");
INSERT INTO wsk_vpl VALUES ("PS35_13","020_35_13","PSA","35","13","13","Bare tom nuna kuera ikes tokasan mu ani nuna nogo ko inang bitakasam ale Kaem kote wosenga kira lagakasam; ale wosenga koma me tokasam mu ");
INSERT INTO wsk_vpl VALUES ("PS35_14","020_35_14","PSA","35","14","14","ani mo nia lagakasam, bola aninga tiran agi aga launuria bo ko iwita. Ani angamang bataga te magi lagakasam, bola aninga ayam kuakoyam mo lagakasam. ");
INSERT INTO wsk_vpl VALUES ("PS35_15","020_35_15","PSA","35","15","15","Bare tom ani ikup te dagulem mu nuna ilu biguwuman ale amilmilakasan; kariimet saki aga bita maguwumonko ilu biguwukasan bare ani me ko ikikasam; nuna ago ko bala memek wore me ta bita tokasan. ");
INSERT INTO wsk_vpl VALUES ("PS35_16","020_35_16","PSA","35","16","16","Ani dagulukasam mu nuna gira awom la aga balu maguwukasan; nuna ani ago ko nongomang magakaso se nogore usikasan. ");
INSERT INTO wsk_vpl VALUES ("PS35_17","020_35_17","PSA","35","17","17","O Kari Biya, awuk am suwutata nungarki se lagerko e? Nuna lion iwita daong ko geragasan; buta se ni aninga tagi bataguru to se nuna me aga maguwumonko. ");
INSERT INTO wsk_vpl VALUES ("PS35_18","020_35_18","PSA","35","18","18","Buta bitar mu ani kariimet nunga biguwura motam biya ningi den ningo amilmil balu kisekko; ale kariimet biya ningi nika nip patawurikko. ");
INSERT INTO wsk_vpl VALUES ("PS35_19","020_35_19","PSA","35","19","19","Kager kari memek alo me aga kuawara mu nungarkiwer se aga kiamon amilmilamon ale nomotam kui me parang parang mamonko, mu awuk, kumik duap bo mena. ");
INSERT INTO wsk_vpl VALUES ("PS35_20","020_35_20","PSA","35","20","20","Nuna den bo nongomang lila te me ta balsan, bare nuna kariimet yawarakala dagiman ale kutek maman bagasan mu den kawel atumu nungarsan. ");
INSERT INTO wsk_vpl VALUES ("PS35_21","020_35_21","PSA","35","21","21","Nuna den atumu ani aisisan ale balsan, “Aha! Aha! Karkaman bo! Ana namotam kuagi te kiwem memek bitawerem se karkaman!” masan. ");
INSERT INTO wsk_vpl VALUES ("PS35_22","020_35_22","PSA","35","22","22","O Yawe, kiwem imi ni ari saperem; buta se kiring me kaloko. O aga Biya, aga bitar ale awar biya me bagerko. ");
INSERT INTO wsk_vpl VALUES ("PS35_23","020_35_23","PSA","35","23","23","O Kaem, aga Biya, bares ale tair aga sangaruko! Ni ani ago ko sanamirko. ");
INSERT INTO wsk_vpl VALUES ("PS35_24","020_35_24","PSA","35","24","24","O Yawe, aninga Kaem, nika munan ningo diram la mu te, ani angimik te memek bo mena mu aga wetang saparko; ni nungarkiwer se me ta aga bita maguwumonko. ");
INSERT INTO wsk_vpl VALUES ("PS35_25","020_35_25","PSA","35","25","25","Ni me nungarki sager se balmon, “Ese, terong, ana mel nangamang te aniram mu kumik te aratam!” mamon, ale balmon, “Ana nu menawura biya menawuman!” ma balmonko. ");
INSERT INTO wsk_vpl VALUES ("PS35_26","020_35_26","PSA","35","26","26","Arikaya ani ikup ningi kaperem se amilmilakasan mu, dolara nungaru ale nunga ikia ngualawurko; arikaya ani memek kituwura ko aga balsan ale nuna ningo yawara ko nunumi betesan mu, dolara nungaru ale nunup karogo kaparko. ");
INSERT INTO wsk_vpl VALUES ("PS35_27","020_35_27","PSA","35","27","27","Ni ani angimik memek bo mena mu wetang aga sapar se, kariimet aga kuawara mu ngata betemon ale amilmilamonko. Nuna pempem balmon, “Yawe nup biya tunakko! Nu noko ura kari bituok se ningo la bagarukko kueso,” mamonko. ");
INSERT INTO wsk_vpl VALUES ("PS35_28","020_35_28","PSA","35","28","28","Buta se ani nika munan ningo diram la mu ko balu se, pempem nip patawu se lagarikko. Nunguning. ");
INSERT INTO wsk_vpl VALUES ("PS36_1","020_36_1","PSA","36","1","1","(David ko wur) Kaem ko den bo aningate tairam, mu kariimet memek bitawara wore nunga memek ko den: Nuna Kaem ko me nguanga gilingisan. ");
INSERT INTO wsk_vpl VALUES ("PS36_2","020_36_2","PSA","36","2","2","Nuna nongota nunumi ko ikisan mu nuna terong ko nunumi balsan, bore te se nongota nunga memek mu ari ikimon ale nubiring tumonko me terong. ");
INSERT INTO wsk_vpl VALUES ("PS36_3","020_36_3","PSA","36","3","3","Nononga nuguring te mu den memek se den kawel la arataso; nononga ikia maga saparam se kilek ningo bo me betesan. ");
INSERT INTO wsk_vpl VALUES ("PS36_4","020_36_4","PSA","36","4","4","Nononga anira kuwim te taga anisan mu, kilek memek betemonko mu ko ikia to lagasan; nuna ikia memek karo tumonko gira bagasan, ale ikia memek me ta biriruwusan. ");
INSERT INTO wsk_vpl VALUES ("PS36_5","020_36_5","PSA","36","5","5","O Yawe, nika kua nangara mu kalel biya nunguningkiri, se nika munan nangarak pempem la bagara mu taiti nuwi kiaram. ");
INSERT INTO wsk_vpl VALUES ("PS36_6","020_36_6","PSA","36","6","6","Nika munan ningo dirkiriyam mu duruk bibiya sokel ago iwita; se nika munan diram la tutera mu du biya nunguningkiri. O Yawe, ni kariimet se mel bibiya se gotektek duap duap nunga bitarsam se ningo la bagasan. ");
INSERT INTO wsk_vpl VALUES ("PS36_7","020_36_7","PSA","36","7","7","Nika kua nangara kumik menara mena mu anananga mel yawara nunguningkiri! Se kariimet nika luman bowa nagusan se ni nunga ira kaluwusam. ");
INSERT INTO wsk_vpl VALUES ("PS36_8","020_36_8","PSA","36","8","8","Nika kawam ningi na ningo ningo nungarsam se no gilingisan, se yu ningo nungarsam se nasan ale amilmilasan. ");
INSERT INTO wsk_vpl VALUES ("PS36_9","020_36_9","PSA","36","9","9","Mu awuk, ni marak pempem bagara ko duap; nika nikinang mu ana nikim nangarso. ");
INSERT INTO wsk_vpl VALUES ("PS36_10","020_36_10","PSA","36","10","10","O Biya, nika kua nangara kumik menara mena mu, kariimet nika iki karo tui lagasan mu nongote pempem ani se lagarukko; nika munan ningo nunguningkiri mu, kariimet diram la karo kisisan mu nungaruko. ");
INSERT INTO wsk_vpl VALUES ("PS36_11","020_36_11","PSA","36","11","11","Nunumi patawura ko kariimet mu nungarki sager se ani nusuwik te me aga eremonko, ale nuguting te me agarak kagermonko. ");
INSERT INTO wsk_vpl VALUES ("PS36_12","020_36_12","PSA","36","12","12","Arigalko! Kariimet memek bitawara mu dagulaman aniwasan; nuna dagulaman ale udagi me barasamonko! ");
INSERT INTO wsk_vpl VALUES ("PS37_1","020_37_1","PSA","37","1","1","(David ko wur) Ni kariimet memek mu ningo la bagasan mu ko me gemang dagulokko, ale nunga mel ningo ningo karogo bagasan mu ko me ikia ka morukko, ");
INSERT INTO wsk_vpl VALUES ("PS37_2","020_37_2","PSA","37","2","2","mu awuk, nuna mu sirsir iwita maraka namamonko tom pingi aram, ale tam gawa marakaso ale kaposo iwita mena namamonko. ");
INSERT INTO wsk_vpl VALUES ("PS37_3","020_37_3","PSA","37","3","3","Yawe kote la loaga se kiwem ningo wore bita se lagerko; uwuta mu asele ali imi te baga se mel bo ko me nguangerkowo. ");
INSERT INTO wsk_vpl VALUES ("PS37_4","020_37_4","PSA","37","4","4","Yawe ko la amilmila se lagerko, se nu mel suen la gemang motam te aniso mu kisokko. ");
INSERT INTO wsk_vpl VALUES ("PS37_5","020_37_5","PSA","37","5","5","Nika bagara aolak ka mel suen la Yawe kuting te la bitarko; nu la kote loaga se lager se nu nika sangukko. ");
INSERT INTO wsk_vpl VALUES ("PS37_6","020_37_6","PSA","37","6","6","Nu nika kiwem ningo diram la mu sor ukiso iwita wetang saparukko; se nika kilek yawara mu kowar tai dirmaso ale nikim kaposo iwita nikim kaparukko. ");
INSERT INTO wsk_vpl VALUES ("PS37_7","020_37_7","PSA","37","7","7","Yawe koma te kutek me ale, nu kimi tui sager se nu kiwem arukko; kariimet memek nunga kiwem memek ningi mel ningo ningo gimon se nungarki, mu ko ikia me ka morukko. ");
INSERT INTO wsk_vpl VALUES ("PS37_8","020_37_8","PSA","37","8","8","Gemang me magaruk, se gemang magara ko munan mu biring tuiko; ikia me ka morukko, mu awuk, munan umu maga namara ko lage. ");
INSERT INTO wsk_vpl VALUES ("PS37_9","020_37_9","PSA","37","9","9","Kariimet munan memek bitawara mu mena namamonko; bare awiriya Yawe kote la loaga lagoso mu ali Kaem balam mu te baga lagarukko. ");
INSERT INTO wsk_vpl VALUES ("PS37_10","020_37_10","PSA","37","10","10","Tom me maiyuk se, kariimet memek bitawara mu yumu namamonko; ni nunga loager bare me nungarkiko. ");
INSERT INTO wsk_vpl VALUES ("PS37_11","020_37_11","PSA","37","11","11","Bare kariimet nunumi karogo kapasan, mu ali imi tamon ale amilmil te lila te, te bagamonko. ");
INSERT INTO wsk_vpl VALUES ("PS37_12","020_37_12","PSA","37","12","12","Kariimet memek mu kariimet ningo diram mu nunga maguwumonko ko ikia kalosan ale nogore usisan se gigek maso; ");
INSERT INTO wsk_vpl VALUES ("PS37_13","020_37_13","PSA","37","13","13","bare Kari Biya kariimet memek bitawara mu nunga gusiso, mu awuk, nu ikiso nononga tom mu taiwoso. ");
INSERT INTO wsk_vpl VALUES ("PS37_14","020_37_14","PSA","37","14","14","Kariimet memek mu baenat woyesan ale daga wol tagisan ale kariimet kituwura se nungumik mel mena wore nunga momon se kapamonko; ale kariimet nunga munan ningo diram mu karogo nunga momon se kuemonko geragasan. ");
INSERT INTO wsk_vpl VALUES ("PS37_15","020_37_15","PSA","37","15","15","Bare nunga baenat mu nongota nunga nokosopas atumokko; se nunga daga wol karogo mu koma kilikilik maukko. ");
INSERT INTO wsk_vpl VALUES ("PS37_16","020_37_16","PSA","37","16","16","Ningo diram la baga se kimik mel suen mena ago mu ningo, mu kiwem memek bitawara mu nunga melmasak suen biya kia saparam; ");
INSERT INTO wsk_vpl VALUES ("PS37_17","020_37_17","PSA","37","17","17","mu awuk, Yawe kariimet memek nunga sokel mu maguwurokko, bare nu kariimet ningo diram mu nunga sinar taukko. ");
INSERT INTO wsk_vpl VALUES ("PS37_18","020_37_18","PSA","37","18","18","Yawe kariimet nungumik te den bo mena mu pempem nunga bitarso, ale nunga melmasak balu nungaram mu eng am nononga pempem anirukko. ");
INSERT INTO wsk_vpl VALUES ("PS37_19","020_37_19","PSA","37","19","19","Ikup ko tom te mu nuna me ta memek arigimonko; karak tom te mu nuna na suen biya se me ta tukunangamonko. ");
INSERT INTO wsk_vpl VALUES ("PS37_20","020_37_20","PSA","37","20","20","Bare kariimet memek alo mu mena namamonko; Yawe ilak barimara ko kariimet alo mu giarum ko wakala yawara iwita, nuna mena namamonko - tama bur iwita mena namamonko. ");
INSERT INTO wsk_vpl VALUES ("PS37_21","020_37_21","PSA","37","21","21","Kariimet memek alo mu bo ko mel tasan agi mu, koma me nungarsan; bare kariimet ningo diram betera alo mu, amilmil te melmasak kariimet saki nungarsan; ");
INSERT INTO wsk_vpl VALUES ("PS37_22","020_37_22","PSA","37","22","22","kariimet Yawe marak nungarso mu ali imi tamonko, bare awiriya nu buguwak kalo nungarso mu memek tamonko. ");
INSERT INTO wsk_vpl VALUES ("PS37_23","020_37_23","PSA","37","23","23","Yawe kariimet bo ko munan ko amilmiloso mu sokel tuso; ");
INSERT INTO wsk_vpl VALUES ("PS37_24","020_37_24","PSA","37","24","24","se nu ikup arigok wore nu me ta dagulokko, mu awuk, Yawe kota ko kuting te iluwok se nu me dagulokko. ");
INSERT INTO wsk_vpl VALUES ("PS37_25","020_37_25","PSA","37","25","25","Aninga kulak te tai aitak garuk arem, mu ani Yawe kariimet ningo diram mu buring gurugu nungaram se me nungarkem; agi nunga kuriang inang ko ngatanga ngatanga geragaman se me nungarkem, mena. ");
INSERT INTO wsk_vpl VALUES ("PS37_26","020_37_26","PSA","37","26","26","Nuna nongomang motam ningo te kariimet saki amilmil te melmasak nungarsan; nononga kuriang marak ningo tasan. ");
INSERT INTO wsk_vpl VALUES ("PS37_27","020_37_27","PSA","37","27","27","Nina munan memek nibiring tual ale munan ningo karo tualko; mu asele nina tom pempem ningo la baga se lagaralko. ");
INSERT INTO wsk_vpl VALUES ("PS37_28","020_37_28","PSA","37","28","28","Mu awuk, Yawe kariimet kiwem ningo betesan mu nunga kueso, ale ko kariimet diram la karo tusan mu me buring gurugu nungarso. Nu nunga bituok se ningo la pempem baga lagamonko; bare kariimet memek alo nunga kuriang gue mu maga namamonko. ");
INSERT INTO wsk_vpl VALUES ("PS37_29","020_37_29","PSA","37","29","29","Kariimet ningo diram bitawara mu ali tamon ale te butata baga lagamonko. ");
INSERT INTO wsk_vpl VALUES ("PS37_30","020_37_30","PSA","37","30","30","Munan ningo diram la bagara ko kariimet mu nuguring te ikia sinar den aratukko, ale nunga nungamili te den ningo wore la balmonko. ");
INSERT INTO wsk_vpl VALUES ("PS37_31","020_37_31","PSA","37","31","31","Nononga Kaem ko den mu nononga nongomang motam ningi aniso; nunga aolak mu ningo se diram la. ");
INSERT INTO wsk_vpl VALUES ("PS37_32","020_37_32","PSA","37","32","32","Kari memek alo mu yumusan ale kariimet ningo diram wore nunga kimi bitawasan, nunga momon se kuemonko ko baga lagasan; ");
INSERT INTO wsk_vpl VALUES ("PS37_33","020_37_33","PSA","37","33","33","bare Yawe mu kariimet ningo diram mu nunga bitiruk se me memek tamonko, bare den te nunga betemon mu nu nunga sangukko. ");
INSERT INTO wsk_vpl VALUES ("PS37_34","020_37_34","PSA","37","34","34","Yawe ko la ikia bita se ko munan karo tuiko. Se nu nika sanguk se ni ali mu kotam awurko; nu kariimet memek alo mu nunga karo saparuk mu ni motam te arikko. ");
INSERT INTO wsk_vpl VALUES ("PS37_35","020_37_35","PSA","37","35","35","Ani munan memek betera ko kari bo arigem, nu tam biya bo ali welang te aragam tarigiso iwita tarigiram se arigem. ");
INSERT INTO wsk_vpl VALUES ("PS37_36","020_37_36","PSA","37","36","36","Bare tom me maiyam se apalagaya namaram se ko kuwim ipi aniso; ani ko loagerem, bare me arigem. ");
INSERT INTO wsk_vpl VALUES ("PS37_37","020_37_37","PSA","37","37","37","Kariimet nungumik te den mena se ningo diram la betesan mu nungarkalko; nuna nongomang lila te saki alo nongorak baga lagasan, buta se yawarakala baga se lagamonko. ");
INSERT INTO wsk_vpl VALUES ("PS37_38","020_37_38","PSA","37","38","38","Bare memek betera ko kariimet mu yawarakala me bagamonko, nuna maga sapamonko. ");
INSERT INTO wsk_vpl VALUES ("PS37_39","020_37_39","PSA","37","39","39","Kariimet ningo diram nunga sangaru tata ko munan mu Yawe kote taiso; ikup tom ningi mu, nu nunga manga gek am. ");
INSERT INTO wsk_vpl VALUES ("PS37_40","020_37_40","PSA","37","40","40","Nu nunga sangarso ale kariimet memek nuguting te nunga bataguru taso; nuna nu kote taisan se nunga ira kaluwuso, mu awuk, nu nunga manga gek am. ");
INSERT INTO wsk_vpl VALUES ("PS38_1","020_38_1","PSA","38","1","1","(David ko wur; wosenga den) O Yawe, gemang memek te ani me ining aisuko; nika gemang memek te aga memek koma me aga maguwurko. ");
INSERT INTO wsk_vpl VALUES ("PS38_2","020_38_2","PSA","38","2","2","Mu awuk, nika gatu mare ninguru angimik ningi namaram; nika kiting ninguru aga maguwuram ale agarak kaparam. ");
INSERT INTO wsk_vpl VALUES ("PS38_3","020_38_3","PSA","38","3","3","Nika gemang magara ani ago ko mu kuera yaman ninguru aisam, ale aninga asokel menawu saparam. ");
INSERT INTO wsk_vpl VALUES ("PS38_4","020_38_4","PSA","38","4","4","Aga memek mu ninguru aga iramuru saparam; mel bo ikup biya iwita se giekko me terong. ");
INSERT INTO wsk_vpl VALUES ("PS38_5","020_38_5","PSA","38","5","5","Lot angimik te mu kiri moman ale siring kapa gilingisan; mu aninga ngualara owore ko koma. ");
INSERT INTO wsk_vpl VALUES ("PS38_6","020_38_6","PSA","38","6","6","Ikup ninguru aga iram agarak kaparam se am aliti biya bagasam; ani woremkalal maiya am niara ma te la baga lagasam. ");
INSERT INTO wsk_vpl VALUES ("PS38_7","020_38_7","PSA","38","7","7","Aninga asusuru yaman mu tama iwita barasoso, aninga angimik lilim la yukuwa saparam. ");
INSERT INTO wsk_vpl VALUES ("PS38_8","020_38_8","PSA","38","8","8","Ani menarem ale angimik sokel mena saparam; ani angamang motam yaman karogo nia kika lagasam. ");
INSERT INTO wsk_vpl VALUES ("PS38_9","020_38_9","PSA","38","9","9","O aga Biya, aninga angamang motam mu ni ari saperem; aninga niara kikira mu ni ko iki saperem. ");
INSERT INTO wsk_vpl VALUES ("PS38_10","020_38_10","PSA","38","10","10","Ani angamang motam daung daung maso ale angimik sokel menaso; amotam tiromorom iram se sor arigekko me terong. ");
INSERT INTO wsk_vpl VALUES ("PS38_11","020_38_11","PSA","38","11","11","Aga lot gawir ewere te se, aga gue suan alo se aga sikisaki alo aga dulursan; aga bagara suan alo mu ago ko awar biya bagasan. ");
INSERT INTO wsk_vpl VALUES ("PS38_12","020_38_12","PSA","38","12","12","Kariimet aninga momon se kuerikko mu aninga dagarok kira gilingisan, se kariimet ani yaman aisimonko mu aga maguwumonko balu gilingisan; nuna ani ago ko bala guruga wore me ta bita to arigisan. ");
INSERT INTO wsk_vpl VALUES ("PS38_13","020_38_13","PSA","38","13","13","Bare ani mu kari bo dogowa mena se den me ikiso iwita bagasam; kari bo kuring mena se munakarukko me terong iwita bagasam. ");
INSERT INTO wsk_vpl VALUES ("PS38_14","020_38_14","PSA","38","14","14","Nunguningta, ani kari bo dogowa den me ikia iwita bagasam; kuring mena se den koma me balukko iwita bagasam. ");
INSERT INTO wsk_vpl VALUES ("PS38_15","020_38_15","PSA","38","15","15","O Yawe, ani ni ko ko kimi bita lagasam; O Kari Biya, aninga Kaem, ani ni agiring ilupko kimi bita lagasam. ");
INSERT INTO wsk_vpl VALUES ("PS38_16","020_38_16","PSA","38","16","16","Ani nika manem, “Ani ikup te dagulek mu aga kager kari alo mu me nungarki sager se aga eremon ale amilmil te nunumi me patawumonko,” maem. ");
INSERT INTO wsk_vpl VALUES ("PS38_17","020_38_17","PSA","38","17","17","Se aitak mu ani dagulekko pingi arem; aga yaman mu angimik te am aniso. ");
INSERT INTO wsk_vpl VALUES ("PS38_18","020_38_18","PSA","38","18","18","Ani memek beterem mu ni kema te apusam; ani ikup beterem mu ko angamang ninguru batagoso. ");
INSERT INTO wsk_vpl VALUES ("PS38_19","020_38_19","PSA","38","19","19","Aninga kager kari alo mu suen biya se nosokel aora biya; nuna ago ko me kuesan bare mu kumik duap bo mena. ");
INSERT INTO wsk_vpl VALUES ("PS38_20","020_38_20","PSA","38","20","20","Nuna ani munan ningo betesam mu ko koma mu munan memek mu agate betesan; nuna ani munan ningo betesam wore ko ani agarak barimasan. ");
INSERT INTO wsk_vpl VALUES ("PS38_21","020_38_21","PSA","38","21","21","O Yawe, ni me aga bitarko; O aga Kaem, me aga bitar ale awar biya bagerko. ");
INSERT INTO wsk_vpl VALUES ("PS38_22","020_38_22","PSA","38","22","22","O aga Saonga Kari, urtuk la tair ale aga sangaruko. ");
INSERT INTO wsk_vpl VALUES ("PS39_1","020_39_1","PSA","39","1","1","(David ko wur) Ani balem, “Ani aga kiwem ko sinar taik ale aga agiring te mel bo memek me ta balikko; ani kariimet memek nongoma te den bo ta me balikko.” ");
INSERT INTO wsk_vpl VALUES ("PS39_2","020_39_2","PSA","39","2","2","Buta se ani agiring kalem, ale den bo ta me balukasam, mel bo ningo ko den ta wore me ta balukasam tala. Bare aninga ikup mu yam namaram laga kaparam, ");
INSERT INTO wsk_vpl VALUES ("PS39_3","020_39_3","PSA","39","3","3","se ani ikia ninguru aga moakaso. Se ikup mu ko ikia tokasam mu eng am ikup biyala aga irakaso, se agata aimi ko Kaem isarukasam: ");
INSERT INTO wsk_vpl VALUES ("PS39_4","020_39_4","PSA","39","4","4","“O Yawe, ani marak bagarikko tom wore aga kasuruko; ani ikisam ana tom tukunangta baga kuesan, bare Biya, aga kasuru se ninguru ko ikiekko. ");
INSERT INTO wsk_vpl VALUES ("PS39_5","020_39_5","PSA","39","5","5","Aninga marak bagara ko tom mu ni tukunang gotek nungem, nika loagara te mu aninga marak bagara ko tom mu diriwakala iwita; mu awuk, ana kariimet suen la am tom tukunangta baga kuesan, marir nagiring te pus masan se arataso nama menaso iwita. ");
INSERT INTO wsk_vpl VALUES ("PS39_6","020_39_6","PSA","39","6","6","“Agi tam bo ko tamarum iwita, worem motam kuiniso mu nu karogo mena namoso. Ana namasan taisan, melmasak gemasan, bare mu me nanga sangarso; awiriya giokko mu ana me ko ikisan tala. ");
INSERT INTO wsk_vpl VALUES ("PS39_7","020_39_7","PSA","39","7","7","“Buta se Kari Biya, ani aga loagara biya anape te bita se lagarikko? Aninga loagara biya mu nikate betesam. ");
INSERT INTO wsk_vpl VALUES ("PS39_8","020_39_8","PSA","39","8","8","Aninga memek suen la ningi aga sangaru toko, se kari ikia mena mu me aga gusimonko. ");
INSERT INTO wsk_vpl VALUES ("PS39_9","020_39_9","PSA","39","9","9","Nigita ikup imi ani angimik te beterem, borta ko ani agiring kalem, ale den bo me balem. ");
INSERT INTO wsk_vpl VALUES ("PS39_10","020_39_10","PSA","39","10","10","Ni yaman bo karogo me aisuko; ani nika kiting te kuerikko pingi arem. ");
INSERT INTO wsk_vpl VALUES ("PS39_11","020_39_11","PSA","39","11","11","Ni ana kariimet nanga memek ko nanga dingumusam; ale ni dagor silale guang maguwuso iwitata anananga mel ningo ningo mu maguwusam; ana kariimet mu marir nagiring te pus masan se arataso nama menaso iwita. ");
INSERT INTO wsk_vpl VALUES ("PS39_12","020_39_12","PSA","39","12","12","“O Yawe, aninga niara ikiko; ale aninga wosenga ko degewa guruguko! Ani niawasam ewere aga sangaruko, mu awuk, ani kari iwareng iwita tom tukunangta kerak bagarikko, aninga taleng girigir alo nunga iwita. ");
INSERT INTO wsk_vpl VALUES ("PS39_13","020_39_13","PSA","39","13","13","Nika gemang magara to ilup se ani aeman saparik, ale asele baga kua yumu namarikko.” ");
INSERT INTO wsk_vpl VALUES ("PS40_1","020_40_1","PSA","40","1","1","(David ko wur) Ani aimi ago kaperem ale Yawe kote la loaga se lagerem se nu koma gurugu aisam ale aga aira ikiam. ");
INSERT INTO wsk_vpl VALUES ("PS40_2","020_40_2","PSA","40","2","2","Ani mutim lom gege karogo iwita ningi bagerem se nu aninga patawuram se bausem se sor garagarayam aora mu te aga beteram se sanamerem. ");
INSERT INTO wsk_vpl VALUES ("PS40_3","020_40_3","PSA","40","3","3","Ale amilmil aisam se noko nup te patawura ko wur bo iru ilusam; suen biya munan imi arigimon ale ko sinar amon, ale Yawe te la ira sanami se lagamonko. ");
INSERT INTO wsk_vpl VALUES ("PS40_4","020_40_4","PSA","40","4","4","Awiriya Yawe te la ira sanami lagoso mu amilmilarukko; nu nunumi patawura alo se kaem kawel alo nogowom karo ko kariimet mu me karo nungarso. ");
INSERT INTO wsk_vpl VALUES ("PS40_5","020_40_5","PSA","40","5","5","O Yawe, aninga Kaem, ni kilek bibiya sokel ago suen biya beterem; ni ana nago ko ikia ningo ningo nunguru awurem. Kari bo ta nika tuar mena; ani betela nika munan suen biya umu balu saparikko me terong tala, mu awuk, mu suen biya nunguningkiri. ");
INSERT INTO wsk_vpl VALUES ("PS40_6","020_40_6","PSA","40","6","6","Ni aninga tama bita kisa ko munan mu te me loaga lagasam, bare ni aninga adogowa galuwurem se te kiring iki karo tuekko. Mel altar te kai sapasan mu se, memek te siwu nangaruko tama bita kisa mu ni me te gemang tawun biya aniso. ");
INSERT INTO wsk_vpl VALUES ("PS40_7","020_40_7","PSA","40","7","7","Se ani balem, “Ani ni kiring karo tuekko tairem iweya, nika batoga te ani ago ko iwitata balem se aniso. ");
INSERT INTO wsk_vpl VALUES ("PS40_8","020_40_8","PSA","40","8","8","O aninga Kaem, ani nika gemang karo tuekko ninguru kuesam; nika den mu aninga angamang motam ningi aniso.” ");
INSERT INTO wsk_vpl VALUES ("PS40_9","020_40_9","PSA","40","9","9","O Yawe, ni ikisam, ani biguwura biya ningi agiring me kalosam, nika saonga te nanga sangaru taem mu ko nunga manaru lagasam. ");
INSERT INTO wsk_vpl VALUES ("PS40_10","020_40_10","PSA","40","10","10","Ani nika diram la karo tuata ko munan mu se, ka kiwem ana me nanga bita ariga, nangarak la baga se nanga sangaru tata ko munan mu ko agiring me kalosam. Ani nika kariimet biguwura ningi, nika gemang lila se ka munan nunguning mu ko nunga manaru sapasam. ");
INSERT INTO wsk_vpl VALUES ("PS40_11","020_40_11","PSA","40","11","11","O Yawe, nika gemang lila ani ago ko mu me to ilupko; nika kua aisa ale ka bitua yawara mu pempem la aninga iramurokko! ");
INSERT INTO wsk_vpl VALUES ("PS40_12","020_40_12","PSA","40","12","12","Mu awuk, ani ikup memek suen biya aga lautam; se aga memek bita lagerem mu aga iramuram se kulupik bo te aratikko mena. Aga memek mu suen biya nunguningkiri, se kaura moke mena; se angamang motam sokel mena saparam. ");
INSERT INTO wsk_vpl VALUES ("PS40_13","020_40_13","PSA","40","13","13","O Yawe, gemang aisu ale aga sangaruko; pasak ala tair ale aga sangaruko. ");
INSERT INTO wsk_vpl VALUES ("PS40_14","020_40_14","PSA","40","14","14","Se kariimet aninga momonko negawasan mu dolomon ale parasa namamonko; ale nuna ani memek te namarikko nongomang aniso mu, pelemon ale magi magi namamonko. ");
INSERT INTO wsk_vpl VALUES ("PS40_15","020_40_15","PSA","40","15","15","Ale awiriya aninga gusirsan mu nunga dolara nunga iramurokko. ");
INSERT INTO wsk_vpl VALUES ("PS40_16","020_40_16","PSA","40","16","16","Bare kariimet nika kua lagasan mu nonoman nungeruk se ni ko ko amilmilamonko; kariimet ni nunga sangaruko nomotam bita lagasan mu pempem balmon, “Yawe mu ningo!” ma balmonko. ");
INSERT INTO wsk_vpl VALUES ("PS40_17","020_40_17","PSA","40","17","17","Bare ani kituwura, asokel mena; buta se O Biya, ni ani ago ko kamili me saparukko; O aga Kaem, ni aninga saonga se aga bataguru ta ko kari; ni pasak ala tair ale aga sangaruko. ");
INSERT INTO wsk_vpl VALUES ("PS41_1","020_41_1","PSA","41","1","1","(David ko wur) Kariimet awiriya kariimet kituwura guat nunga sangorsan mu amilmilamonko; tom nuna nongota ikup memek ningi kapamon mu Yawe nunga sangukko. ");
INSERT INTO wsk_vpl VALUES ("PS41_2","020_41_2","PSA","41","2","2","Nu nunga bituok se tom maiya biya amilmil te ali imi te baga lagamonko. Nu kager memek nuguting te nunga bataguru taukko. ");
INSERT INTO wsk_vpl VALUES ("PS41_3","020_41_3","PSA","41","3","3","Tom nuna kuera ikes ago bagamon mu nu nunga sanguk se nungemonko. ");
INSERT INTO wsk_vpl VALUES ("PS41_4","020_41_4","PSA","41","4","4","Ani iwita Yawe aru manem, “Ani ni kema te memek beterem, bare gemang aisu ale kuera ikes ewere siwu waruko.” ");
INSERT INTO wsk_vpl VALUES ("PS41_5","020_41_5","PSA","41","5","5","Kager kari memek nongomang memek karogo iwita ago ko balsan, “Nu yam kua namaruk se nup mena namarukko,” ma balsan. ");
INSERT INTO wsk_vpl VALUES ("PS41_6","020_41_6","PSA","41","6","6","Tom nuna ani agarkamonko taisan, mu nuguring guang te agarak wosengasan, bare nongomang motam mu kigilik aniso; se namasan mu kariimet biya ningi aga balu maguwusan. ");
INSERT INTO wsk_vpl VALUES ("PS41_7","020_41_7","PSA","41","7","7","Aga kager kari memek bolala awusan ale abiring ko kasikasisan; nuna balsan, “O memek biya taukkowo!” masan. ");
INSERT INTO wsk_vpl VALUES ("PS41_8","020_41_8","PSA","41","8","8","“Kuera ikes memek nunguningkiri iluwam, se me ta nungerukkowo!” ma balsan. ");
INSERT INTO wsk_vpl VALUES ("PS41_9","020_41_9","PSA","41","9","9","Aga yawara, aga ilup se isirek, ani nu ilak am suanta, mel katirta wete nasan, bare buring gurugu aisam tala. ");
INSERT INTO wsk_vpl VALUES ("PS41_10","020_41_10","PSA","41","10","10","O Yawe, gemang aisu ale aga sangaru se ani nunga memek koma bita nungarikko! ");
INSERT INTO wsk_vpl VALUES ("PS41_11","020_41_11","PSA","41","11","11","Tom kager kari memek kager te me aga kiasan mu te, ani ikisam mu ni aninga kuesam. ");
INSERT INTO wsk_vpl VALUES ("PS41_12","020_41_12","PSA","41","12","12","Ani kiwem memek bo me beterem, buta se ni aga sangorsam; se ani ni kema te baga se lagarikko. ");
INSERT INTO wsk_vpl VALUES ("PS41_13","020_41_13","PSA","41","13","13","Ani Yawe nup patawurikko, nu ana Israel nanga Kaem, nup biya pempem la butata anirukko! Nunguningta se nunguningkiri! ");
INSERT INTO wsk_vpl VALUES ("PS42_1","020_42_1","PSA","42","1","1","(Korah ko kuriang alo nunga wur bo) Aga Kaem, deer yu ko dogotak marakaso se yu kupuso iwitatala, ani yu ko kuakoyam ni kimik duap te bagarikko ninguru kuesam. ");
INSERT INTO wsk_vpl VALUES ("PS42_2","020_42_2","PSA","42","2","2","Kaem, ni Kaem marak duap; se ani angamang angimik lilim la ni kerak bagarikko. Ani pa amaru aga Kaem koma te nama aratikko ya? ");
INSERT INTO wsk_vpl VALUES ("PS42_3","020_42_3","PSA","42","3","3","Ani tirom woremkalal amononge kapa lagoso, se kariimet pempem la aga isarsan, “Nika Kaem apoko ya?” masan. ");
INSERT INTO wsk_vpl VALUES ("PS42_4","020_42_4","PSA","42","4","4","Ani girakala kariimet nunga girikasam ale nongorak Kaem ko temple te namakasam, ale nama se amilmil te aikasan, Kaem ko wur ilu se nup patawukasan; umu angamin te taiso se angamang motam ninguru batagoso. ");
INSERT INTO wsk_vpl VALUES ("PS42_5","020_42_5","PSA","42","5","5","Aninga angamang motam pa awuk se dagulam? Awuk se kumik lila mena? Bare aninga ikia, aninga loagara mu Kaem kote la bitirikko; se nu aninga sanguk se ani akingtala nup patawurikko; nu aninga Saonga Kari, se ");
INSERT INTO wsk_vpl VALUES ("PS42_6","020_42_6","PSA","42","6","6","aninga Kaem. Ani angamang motam dagulam; se yu Jordan ko supuling duruk Hermon se duruk Mizar te baga se, ni ko ko angamin ares maso, ");
INSERT INTO wsk_vpl VALUES ("PS42_7","020_42_7","PSA","42","7","7","mu awuk, ani nika yu tengeso ale tai tagoso nirung kaposo ale tamun numi moso ale namoso taiso iwita bagasam. ");
INSERT INTO wsk_vpl VALUES ("PS42_8","020_42_8","PSA","42","8","8","Yawe woremkalal pempem gomang aisiso, ale tirom wur aisiso se guranek iwita ilu aga Kaem tusam. ");
INSERT INTO wsk_vpl VALUES ("PS42_9","020_42_9","PSA","42","9","9","Aninga Kaem mu aninga Duruk motongar, se ani isarsam, “Ni awuk se ani ago ko kamili saparam? Awuk se kari memek aga maguwuman se iwitata ma niara te la bagasam?” ");
INSERT INTO wsk_vpl VALUES ("PS42_10","020_42_10","PSA","42","10","10","Nuna kowarkalal maiya la nusuwik sapara den balsan, ale masan, “Nika Kaem apoko ya?” masan. Den imi ani mare iwita angimik barukuso ale ningi namoso se ani kuerikko kaesam. ");
INSERT INTO wsk_vpl VALUES ("PS42_11","020_42_11","PSA","42","11","11","Aninga angamang motam pa awuk se dagulam? Awuk se kumik lila mena? Bare aninga ikia, aninga loagara mu Kaem kote la bitirikko; se nu aninga sanguk se ani akingtala nup patawurikko; nu aninga Saonga Kari, se aninga Kaem. ");
INSERT INTO wsk_vpl VALUES ("PS43_1","020_43_1","PSA","43","1","1","Aga Kaem, kariimet nubiring ni kisiman ale kiwem memek se kawel te aga bita maguwusan umu, nuguting te aga bataguru toko. ");
INSERT INTO wsk_vpl VALUES ("PS43_2","020_43_2","PSA","43","2","2","Ni Kaem, aninga yumura kuwim aora. Ni awuk se biring gurugu aisem? Awuk se kari memek aga maguwuman se iwitata ma niara te la bagasam? ");
INSERT INTO wsk_vpl VALUES ("PS43_3","020_43_3","PSA","43","3","3","Nika nikim se nika bitua ningo mu te lage aga kasuru ale agarak nika bagara kuwim, ka duruk laili mu te agarak namarko. ");
INSERT INTO wsk_vpl VALUES ("PS43_4","020_43_4","PSA","43","4","4","Se ani nika altar duap te namarik ale gita moa se ka nip patawurikko, mu awuk, ni aninga Kaem, ni angamang sangam tuem ale amilmil aisem se ani ni ko ko ninguru amilmilasam. ");
INSERT INTO wsk_vpl VALUES ("PS43_5","020_43_5","PSA","43","5","5","Aninga angamang motam pa awuk se dagulam? Awuk se kumik lila mena? Bare aninga ikia, aninga loagara mu Kaem kote la bitirikko; se nu aninga sanguk se ani akingtala nup patawurikko; nu aninga Saonga Kari, se aninga Kaem. ");
INSERT INTO wsk_vpl VALUES ("PS44_1","020_44_1","PSA","44","1","1","(Korah ko kuriang alo nunga wur bo) O Kaem, ni girakala anananga taleng girigir alo nunga tom te kiwem aora bibiya beterem; dugu duap mu ana nainet alo nanga manorman se ana nadogowa te ikiman. ");
INSERT INTO wsk_vpl VALUES ("PS44_2","020_44_2","PSA","44","2","2","Ni keta kariimet iwareng nunga karo parusuwurem ale ali mu anananga girigir alo nungarem se te yawarakala dagiman; ni kariimet iwareng umu nunga munan memek koma nunga maguwurem, ale anananga girigir alo nunga bituem se gue pagam namaram. ");
INSERT INTO wsk_vpl VALUES ("PS44_3","020_44_3","PSA","44","3","3","Nuna nongota nunga kager ko mel te, agi nongota nunga nosokel te ali mu me bataguru taman, mena; bare mu nika kiting, nika sokel te, se ka kimik nikim mu te kager mu menawurem; mu awuk, ni ka gemang motam ka kariimet ko aniram se uwutata beterem. ");
INSERT INTO wsk_vpl VALUES ("PS44_4","020_44_4","PSA","44","4","4","Ni aninga Kaem se aninga King; ni balsam se ana Jacob ko kariimet gue kager te marirasan. ");
INSERT INTO wsk_vpl VALUES ("PS44_5","020_44_5","PSA","44","5","5","Nika sokel te ana nanga kager kari nunga karosan; nika nip te la ana kager nunga sail menawusan. ");
INSERT INTO wsk_vpl VALUES ("PS44_6","020_44_6","PSA","44","6","6","Ani aga gatu mare karogo, bare umu te la me ira sanamasam; se aga saenang karogotala, bare mu te la betela me marirasam. ");
INSERT INTO wsk_vpl VALUES ("PS44_7","020_44_7","PSA","44","7","7","Bare ni nanga sangorsam se kager me nanga maguwuso; ni kariimet me nanga kuesan mu ngual nungarsam se dolasan. ");
INSERT INTO wsk_vpl VALUES ("PS44_8","020_44_8","PSA","44","8","8","Se Kaem, ana nika saonga mu ko ka balu patawu lagasan, ale nika nip pempem la patawu se laganakko. ");
INSERT INTO wsk_vpl VALUES ("PS44_9","020_44_9","PSA","44","9","9","Bare aitak ni biring gurugu nangarem ale nanga ira kutuwurem; ale aitak ni anananga kager kari kager te me nunga sangorsam. ");
INSERT INTO wsk_vpl VALUES ("PS44_10","020_44_10","PSA","44","10","10","Ni uwuta beterem se ana kager arigiman ale naguman, se nuna anananga melmasak gi gilingiman. ");
INSERT INTO wsk_vpl VALUES ("PS44_11","020_44_11","PSA","44","11","11","Ni ana sipsip nunga momon se kuemonko negawasan iwita nanga beterem, ale nanga parusuwurem se ngual ngual namaman ale kariimet iwareng nunga ningi bagasan. ");
INSERT INTO wsk_vpl VALUES ("PS44_12","020_44_12","PSA","44","12","12","Ni ana ka kariimet nanga merem ale diara kari iwareng nongote nanga ilu arigem, se manga koma aliti ta te nanga diaman iwita, ni manga bo biya nongote me taem. ");
INSERT INTO wsk_vpl VALUES ("PS44_13","020_44_13","PSA","44","13","13","Ni uwutata nanga beterem, se kariimet nangimik duap te bagasan mu nanga balu maguwusan; kariimet saki mu nanga gusirsan ale den dolara nanga manorsan. ");
INSERT INTO wsk_vpl VALUES ("PS44_14","020_44_14","PSA","44","14","14","Ni buta maem se sor saki ko kariimet den dolara nangimik ko balsan; ale kiwem nago ko aratam ewere ko ninguru gusisan. ");
INSERT INTO wsk_vpl VALUES ("PS44_15","020_44_15","PSA","44","15","15","Se ani pempem la aimi ari maguwu lagasam, se dolara mu angama sengem te aniso, ");
INSERT INTO wsk_vpl VALUES ("PS44_16","020_44_16","PSA","44","16","16","mu awuk, kariimet agarak kagersan mu dolara den aisu lagasan, ale agarki maguwusan ale aga gusirsan. ");
INSERT INTO wsk_vpl VALUES ("PS44_17","020_44_17","PSA","44","17","17","Munan memek imi suen la nangimik te aratu saparam, bare ana ni ko ko nangamili me sapakaso, ale ni ikia den nangarak kalem mu me kulukurukasan tala. ");
INSERT INTO wsk_vpl VALUES ("PS44_18","020_44_18","PSA","44","18","18","Ana nabiring gurugu me kisiman, ale nika munan se nika lage nangarem mu nabiring me tuman. ");
INSERT INTO wsk_vpl VALUES ("PS44_19","020_44_19","PSA","44","19","19","Bare ni anananga maguwurem ale kausik diwang nunga ningi nanga awurem; ale tiromorom biya te nanga iramurem. ");
INSERT INTO wsk_vpl VALUES ("PS44_20","020_44_20","PSA","44","20","20","Ni anananga Kaem, se ana nika nip me ko nangamili saparam; ana nagiting patawuman ale kaem kawel bo ko me ngatangaman. ");
INSERT INTO wsk_vpl VALUES ("PS44_21","020_44_21","PSA","44","21","21","Uwutata beteman le, mu ni am ko iki saparko tala, mu awuk, ni anananga ikia yumura mu ni yam ari iki sapasam. ");
INSERT INTO wsk_vpl VALUES ("PS44_22","020_44_22","PSA","44","22","22","Ana nika kariimet ko bagasan, se tom suen biya nanga mosan se kuawasan; ana nangarkasan mu sipsip nunga momon se kuemonko lage te bagasan mu iwita nangarkasan. ");
INSERT INTO wsk_vpl VALUES ("PS44_23","020_44_23","PSA","44","23","23","Kari Biya, baresko! Ni anape ko aniwasam? Ni baresko! Ni biring nangara biya me nangaruko! ");
INSERT INTO wsk_vpl VALUES ("PS44_24","020_44_24","PSA","44","24","24","Ana nanga bita maguwuman se ikup tawun biya ningi bagasan, bare ni anape ko ana nago ko kema kaluwusam ale kamili sapakoyam bagasam? ");
INSERT INTO wsk_vpl VALUES ("PS44_25","020_44_25","PSA","44","25","25","Ana ali te dagulu parasaman ale kariimet kuera iwita aniwasan. ");
INSERT INTO wsk_vpl VALUES ("PS44_26","020_44_26","PSA","44","26","26","Buta se ni bares ale tai nanga sangaruko! Ni ka kua nangara ko munan wore ko kamin ares mauk, se tai nanga sangaru se ana me kua namanakko! ");
INSERT INTO wsk_vpl VALUES ("PS45_1","020_45_1","PSA","45","1","1","(Korah ko kuriang alo nunga wur bo) Den supuling yawara bo aninga angamang motam ninguru atumuso se ani king koma te balu tuekko; aninga angamili mu, garek ko kari ningo bo ko bugu yawara te garekoso wore iwita, se ani den te gurugek patawurikko. ");
INSERT INTO wsk_vpl VALUES ("PS45_2","020_45_2","PSA","45","2","2","Ni kari ningo yawara, se kari bo bo nika iwita mena; nika kiring mu marolila ko den karogo; Kaem uwutata nika beteram owore te se nu pempem la marak ningo kisu lagoso. ");
INSERT INTO wsk_vpl VALUES ("PS45_3","020_45_3","PSA","45","3","3","O king sokel karogo, nika saenang to ale ka luan karogo ituwurko; ni ka nip biya se ka sokel aora biya mu kager ko bala iwita tugumko. ");
INSERT INTO wsk_vpl VALUES ("PS45_4","020_45_4","PSA","45","4","4","Ni nip biya mu karogo kager te namar ale marirerko; nika kager mu, den nunguning se bagara ningo diram mu ko ni kagersam; namar ale kiwem bibiya bitarko. ");
INSERT INTO wsk_vpl VALUES ("PS45_5","020_45_5","PSA","45","5","5","Gatu mare kore tamatama mu kager kari memek nokosopas atumu barurumumonko; sor sor ko kariimet nika siwik duap ningi la kapamonko. ");
INSERT INTO wsk_vpl VALUES ("PS45_6","020_45_6","PSA","45","6","6","O Kaem, nika king ko bagara mu pempem la butata lagerko, se munan ningo diram mu nika king ko tam iwita, nika kingdom te bitaruko. ");
INSERT INTO wsk_vpl VALUES ("PS45_7","020_45_7","PSA","45","7","7","Ni munan ningo ko kua lagasam ale munan memek mu ni biriruwusam; buta se Kaem, nika Kaem, mu amilmil oil sipiling te waram, ale ka saki alo nunga ningi, ni kualala biya ka beteram se bagasam. ");
INSERT INTO wsk_vpl VALUES ("PS45_8","020_45_8","PSA","45","8","8","Ni guang balayam nagurem mu mel siring yawara yawara karogo terong mam; nika kawam bala duap duap wore te bala tuman, ale ni amilmil kisimonko gita te wur yagowom gurugusan. ");
INSERT INTO wsk_vpl VALUES ("PS45_9","020_45_9","PSA","45","9","9","King saki nunga nanawusari se imet nunup bibiya mu karogo taiman; se imet ni ilak nimi kiting ilup se nika niwus ko bagarukko mu, kiting sengam mu te, sor Ophir ko bala gold te nungurman mu naguram ale bagoso. ");
INSERT INTO wsk_vpl VALUES ("PS45_10","020_45_10","PSA","45","10","10","Ikiko, aga nanawus, degewa gurugu ale den imi ikiko: Ni ka kariimet se ka niet ko kawam digo lilim biring tuiko. ");
INSERT INTO wsk_vpl VALUES ("PS45_11","020_45_11","PSA","45","11","11","Se king ka amilmilaruk, ale ka kema motam balayam mu ko kueruk, se ni nup biya tui se nu nika bituokko. ");
INSERT INTO wsk_vpl VALUES ("PS45_12","020_45_12","PSA","45","12","12","Sor Tyre ko kariimet nungumik mel suen biya karogo mu gemang kulukurmonko munan duap duap karogo tai kisimonko. ");
INSERT INTO wsk_vpl VALUES ("PS45_13","020_45_13","PSA","45","13","13","Imet kulak king aguwam mu ko guang mu nikim ago se gold awote biliwilik bagara se ko ariga yam yawarakala; ");
INSERT INTO wsk_vpl VALUES ("PS45_14","020_45_14","PSA","45","14","14","se ko melmasak mu karogo diruwuman ilak king kote namaman; se itiwik kulak noko saonga mu karogo nunga diruwuman nongorak namaman; ");
INSERT INTO wsk_vpl VALUES ("PS45_15","020_45_15","PSA","45","15","15","nuna amilmil te nongorak king ko kawam ningi kasu naguman. ");
INSERT INTO wsk_vpl VALUES ("PS45_16","020_45_16","PSA","45","16","16","O king, nika kuriang kari bilangamon, ale ni, ka niet alo nongorak iwita, nina nigiwim tamon ale ninga ali sor bitarmonko. ");
INSERT INTO wsk_vpl VALUES ("PS45_17","020_45_17","PSA","45","17","17","Ani nika nip biya wetang saparik se kariimet gue udagi taiwasan mu ikimon se sor suen la nika nip mu patawu se lagamonko. ");
INSERT INTO wsk_vpl VALUES ("PS46_1","020_46_1","PSA","46","1","1","(Korah ko kuriang alo nunga wur bo) Kaem mu anananga kuwim yumura se anananga sokel, ikup kam te nanga sangukko sinar ago bagoso. ");
INSERT INTO wsk_vpl VALUES ("PS46_2","020_46_2","PSA","46","2","2","Buta se ana me nguanganakko; ali yukuok se duruk kutukutuk mauk ale gagi ningi kaparuk, ");
INSERT INTO wsk_vpl VALUES ("PS46_3","020_46_3","PSA","46","3","3","se gagi biyala kelaguk nirung kaparuk ale duruk moruk se yukuok, bare ana me ko nguanganakko! ");
INSERT INTO wsk_vpl VALUES ("PS46_4","020_46_4","PSA","46","4","4","Kaem Kalel Biya ko wonong laili umu te, yu yawara bo aniso, se kariimet yu umu ko ninguru amilmilasan. ");
INSERT INTO wsk_vpl VALUES ("PS46_5","020_46_5","PSA","46","5","5","Kaem wonong mu te bagoso, se kager kari me parusuwumonko; sor me ukia palagoso la, Kaem wonong mu sangukko. ");
INSERT INTO wsk_vpl VALUES ("PS46_6","020_46_6","PSA","46","6","6","Ali lilim ningi niara nguangara biya barasoso, kingdom bibiya parasa kapasan; mu awuk, Kaem ko kuring pure iwita pagoso se, ali kutukutuk maso ale turupuso kaposo. ");
INSERT INTO wsk_vpl VALUES ("PS46_7","020_46_7","PSA","46","7","7","Yawe Sokel Garagar mu nangarak bagoso, Jacob ko Kaem mu anananga manga gek am. ");
INSERT INTO wsk_vpl VALUES ("PS46_8","020_46_8","PSA","46","8","8","Tairal Yawe kiwem beteram ewere arigalko, nu ali sor maguwuram ewere arigalko. ");
INSERT INTO wsk_vpl VALUES ("PS46_9","020_46_9","PSA","46","9","9","Nu ali lilim la te kager menawuram, ale daga gatu gi kulukumuram, ale karem gi tama ningi awuram se kani namaram. ");
INSERT INTO wsk_vpl VALUES ("PS46_10","020_46_10","PSA","46","10","10","Ale balam, “Daigal kutek mal ale ani Kaem mu aga ikialko; sor suen la te aip patawumonko, ali lilim la te nup biya aisimonko.” ");
INSERT INTO wsk_vpl VALUES ("PS46_11","020_46_11","PSA","46","11","11","Yawe Sokel Garagar mu nangarak bagoso; Jacob ko Kaem mu anananga manga gek am. ");
INSERT INTO wsk_vpl VALUES ("PS47_1","020_47_1","PSA","47","1","1","(Korah ko kuriang alo nunga wur bo) Airal ale nigiting moralko! Nina kariimet suen la Yawe nup patawuralko! ");
INSERT INTO wsk_vpl VALUES ("PS47_2","020_47_2","PSA","47","2","2","Mu awuk, nu am King duap bo; nu kalel biya, ali lilim la bitarso. ");
INSERT INTO wsk_vpl VALUES ("PS47_3","020_47_3","PSA","47","3","3","Nu sor saki nunga gi nabowa ningi nunga awuram, ale ko kariimet nasiwik duap ningi nunga awuram. ");
INSERT INTO wsk_vpl VALUES ("PS47_4","020_47_4","PSA","47","4","4","Nu ana nanga ali se mel suen la mu balu nangaram, se ana mu ko amilmilasan; ana Jacob ko gue te ko kariimet, nu ninguru nanga kueso. ");
INSERT INTO wsk_vpl VALUES ("PS47_5","020_47_5","PSA","47","5","5","Kariimet amilmil kelaga se, trumpet ituguwaman se Yawe barasam nama tarigiram. ");
INSERT INTO wsk_vpl VALUES ("PS47_6","020_47_6","PSA","47","6","6","Wur iluwal, Kaem nup patawuralko; wur iluwal, nanga King ko nup patawuralko. ");
INSERT INTO wsk_vpl VALUES ("PS47_7","020_47_7","PSA","47","7","7","Mu awuk, Kaem nu ali lilim la ko King, se wur te nup patawuralko. ");
INSERT INTO wsk_vpl VALUES ("PS47_8","020_47_8","PSA","47","8","8","Kaem sor suen la bitarso; nu ko daiga kuwim laili mu awote dagiwoso. ");
INSERT INTO wsk_vpl VALUES ("PS47_9","020_47_9","PSA","47","9","9","Se ali sor suen la ko supuling alo mu tai ilu biguwusan ale Abraham ko Kaem ko kariimet arungu bagasan; mu awuk, ali imi ko king alo mu Kaem ko tala; nu kota suanta King Biya nunguning bagoso. ");
INSERT INTO wsk_vpl VALUES ("PS48_1","020_48_1","PSA","48","1","1","(Korah ko kuriang alo nunga wur bo) Yawe nu Biya! Noko wonong te bagoso umu ningi nup biya pempem to lagarukko! Kaem ko duruk laili mu ");
INSERT INTO wsk_vpl VALUES ("PS48_2","020_48_2","PSA","48","2","2","kalel biya se yawarakala, se ali imi ko kariimet suen la ko amilmilasan. Duruk Zion mu koma north mu te aniso, mu King Biya wore ko wonong. ");
INSERT INTO wsk_vpl VALUES ("PS48_3","020_48_3","PSA","48","3","3","Kaem kota ko kager ko yumura kuwim aora bibiya mu ningi baga se, ko kariimet nunga bitarso ale ninguru nunga sinar taso. ");
INSERT INTO wsk_vpl VALUES ("PS48_4","020_48_4","PSA","48","4","4","Sor saki ko king nunumi gikasan ale Kaem ko wonong mu ilak kagermonko taikasan, duap te ilu biguwukasan, ");
INSERT INTO wsk_vpl VALUES ("PS48_5","020_48_5","PSA","48","5","5","bare tom wonong mu arikasan mu nguangakasan ale nagukasan. ");
INSERT INTO wsk_vpl VALUES ("PS48_6","020_48_6","PSA","48","6","6","Nuna imet kuriang iluwokko yaman taso ale numi tagi gurungumuso ale nguangoso iwita, nguangara nunga iluwam. ");
INSERT INTO wsk_vpl VALUES ("PS48_7","020_48_7","PSA","48","7","7","Se Kaem nuna sor Tarshish ko dal bibiya, daula worem bausa te taira ale nunga maguwura iwita, nunga maguwuram. ");
INSERT INTO wsk_vpl VALUES ("PS48_8","020_48_8","PSA","48","8","8","Yawe Sokel Garagar ko wonong te mel bitakaso se ana nadogowa iki lagaram mu, aitak ana namotam te arigiman: nanga Kaem mu ko wonong bitarso, se pempem ningo la baga lagoso. ");
INSERT INTO wsk_vpl VALUES ("PS48_9","020_48_9","PSA","48","9","9","Anananga Kaem, ana nika temple ningi kapasan mu, ana nika kua nangara ko munan mu ko iki gurugu se amilmil kisisan. ");
INSERT INTO wsk_vpl VALUES ("PS48_10","020_48_10","PSA","48","10","10","Nika kiting sokel garagar mu ali lilim te kager bibiya menawusam, ale munan diram la betesam, se nika nip biya mu sor suen la te patawusan. ");
INSERT INTO wsk_vpl VALUES ("PS48_11","020_48_11","PSA","48","11","11","Duruk Zion te amilmil barasoso, se Judah sor lilim la nonoman nungeso, mu awuk, ni ka munan ningo diram wore te nunga sangaru taem. ");
INSERT INTO wsk_vpl VALUES ("PS48_12","020_48_12","PSA","48","12","12","O kariimet, Zion wonong lilim ko por kaloman mu duap kaoral geragal ale ko kawam kalel bibiya mu ari gurugalko; ");
INSERT INTO wsk_vpl VALUES ("PS48_13","020_48_13","PSA","48","13","13","ale ko kager ko yumura kuwim aora bibiya mu ago arigalko; mu awuk, nina mel arigiman mu suen la gue udagi taiwasan mu nuguring te beteralko. ");
INSERT INTO wsk_vpl VALUES ("PS48_14","020_48_14","PSA","48","14","14","Mel suen la ari ko ikiman umu mu Kaem nungam; nu anananga Kaem pempem baga se nanga kiti gurugokko. ");
INSERT INTO wsk_vpl VALUES ("PS49_1","020_49_1","PSA","49","1","1","(Korah ko kuriang alo nunga wur bo) Kariimet suen la mu nedegawa gurugal ale den ani balsam ewere ikialko. ");
INSERT INTO wsk_vpl VALUES ("PS49_2","020_49_2","PSA","49","2","2","Nina kariimet ninip ago ta, se kariimet ninip mena ta, kariimet mel suen biya karogo, se ningimik mel mena ta, den imi ninguru ikialko. ");
INSERT INTO wsk_vpl VALUES ("PS49_3","020_49_3","PSA","49","3","3","Aninga agiring te ikia sinar ko den balikko; aninga angamang motam ningi den ningo mu balik se ikia ningo ningarukko. ");
INSERT INTO wsk_vpl VALUES ("PS49_4","020_49_4","PSA","49","4","4","Ani den sinar bo angamin te taiso, se aga gita te kola se, ko duap ninga manikko: ");
INSERT INTO wsk_vpl VALUES ("PS49_5","020_49_5","PSA","49","5","5","Ani anape ko tom memek aga irok mu ko ani nguanga se lagarikko? Kari memek nunga kawel te aga laturmon, bare ani me ta nguangarikko. ");
INSERT INTO wsk_vpl VALUES ("PS49_6","020_49_6","PSA","49","6","6","Nuna nunga mel suen biya wore te ira sanamasan, ale nunga manga bibiya wore te nunumi patawusan. ");
INSERT INTO wsk_vpl VALUES ("PS49_7","020_49_7","PSA","49","7","7","Bare ali kari bo ta, bo ko dora kumik dia taukko me terong; agi nu kota numi manga te Kaem kote dia taukko me terong tala. ");
INSERT INTO wsk_vpl VALUES ("PS49_8","020_49_8","PSA","49","8","8","Mu awuk, kariimet bo ko dora diara mu ko koma kalel aromemek; manga ta, anapeya ta te, wore me terong la. ");
INSERT INTO wsk_vpl VALUES ("PS49_9","020_49_9","PSA","49","9","9","Kari bo ikiok numi manga te diaruk ale me kua iwi namaruk, marak pempem bagarukko i mauk wore ko, mu mena. ");
INSERT INTO wsk_vpl VALUES ("PS49_10","020_49_10","PSA","49","10","10","Ana ikisan, kariimet ikia sinar karogo ta wore kuesan tala; se kariimet ikia sinar mena se ngualara mu koma suanta kuesan, ale nunga manga se mel ningo ningo mu betesan se kariimet saki no maguwusan. ");
INSERT INTO wsk_vpl VALUES ("PS49_11","020_49_11","PSA","49","11","11","Mungkala mu nuna nunga ali bibiya karogo, bare aitak mu nononga ali motam gotek te aniwasan umutang nunga ali sor ko pempem anirukko. ");
INSERT INTO wsk_vpl VALUES ("PS49_12","020_49_12","PSA","49","12","12","Kariimet nunup biya mel suen biya karogo ta, wore me marak baga lagasan; nuna buruk kausik kua iwi namasan uwutatala, kua iwi namasan. ");
INSERT INTO wsk_vpl VALUES ("PS49_13","020_49_13","PSA","49","13","13","Aninga sinar den imi ikialko: Kariimet nongota nunga ikia ningo masan ale te ira sanamasan, se kariimet saki nunga ikia umu karo tui gilingisan, ");
INSERT INTO wsk_vpl VALUES ("PS49_14","020_49_14","PSA","49","14","14","mu nuna sipsip iwita, se kuera mateng mu nunga bitua kari iwita nunga bitarso, ale nongorak mutim ningi kapa naguso, se nunga kawam digo mel ningo ningo betesan ale kua iwi namasan; se kariimet ningo diram mu turomola nunga ira kalakumu nama taisan. ");
INSERT INTO wsk_vpl VALUES ("PS49_15","020_49_15","PSA","49","15","15","Bare Kaem ani kuera mutim ningi aga sangaru tauk, se ani nu ilak pempem marak bagarikko. ");
INSERT INTO wsk_vpl VALUES ("PS49_16","020_49_16","PSA","49","16","16","Buta se, awiriya kumik manga mel suen biya, se ko kawam ningi bala mel suen biya, bare bo bo karogo am giwuruk se arik, mu ni me ko gemang dagulokko. ");
INSERT INTO wsk_vpl VALUES ("PS49_17","020_49_17","PSA","49","17","17","Mu awuk, maingte nu kueruk mu mel bo giok ale karogo me namarukko; noko mel ningo ningo mu giok ale karogo mutim ningi me kaparukko tala. ");
INSERT INTO wsk_vpl VALUES ("PS49_18","020_49_18","PSA","49","18","18","Tom nu marak baga se mu, nu ko melmasak mu ko amilmil bitakaso, se kariimet balukasan nu kari yawara makasan. ");
INSERT INTO wsk_vpl VALUES ("PS49_19","020_49_19","PSA","49","19","19","Bare nu kuera ko sor, ko nuet nongotak te kapaman, mu te kaparukko, ale sor nikim me arigokko. ");
INSERT INTO wsk_vpl VALUES ("PS49_20","020_49_20","PSA","49","20","20","Ikialko. Awiriya kumik mel suen biya karogo, bare nu kumik ikia sinar ningo mena, mu nu mel diwang bo iwita kua iwi namarukko. ");
INSERT INTO wsk_vpl VALUES ("PS50_1","020_50_1","PSA","50","1","1","(Asaph wur imi batogam) Yawe nu Kaem, nu sokel garagar, kowar bausa te se nama kowar kapara te, ali lilim ko kariimet suen la nunga aruso. ");
INSERT INTO wsk_vpl VALUES ("PS50_2","020_50_2","PSA","50","2","2","Nu Zion wonong, wonong balayam yawara nunguning mu te baga se, kumik nikim biyala kaposo. ");
INSERT INTO wsk_vpl VALUES ("PS50_3","020_50_3","PSA","50","3","3","Anananga Kaem taiwoso mu tetela la me taiso; tama kuamili biya giram taiso se yar daula samamer lautam ilak taiso. ");
INSERT INTO wsk_vpl VALUES ("PS50_4","020_50_4","PSA","50","4","4","Nu taiti se ali nunga aruso, taimon ale iki sagamon se noko kariimet den te nunga bitirukko aiso: ");
INSERT INTO wsk_vpl VALUES ("PS50_5","020_50_5","PSA","50","5","5","“Aninga kariimet, aninga ma nunga balem se ani agarak tama bita aisa ko den kaloman, mu nunga aural se taimon angama te biguwumonko,” maso. ");
INSERT INTO wsk_vpl VALUES ("PS50_6","020_50_6","PSA","50","6","6","Se taiti gomang lilim mu noko munan ningo dirkiriyam mu balu pagarso, mu awuk, nu kota nu tutera kari. ");
INSERT INTO wsk_vpl VALUES ("PS50_7","020_50_7","PSA","50","7","7","“O aninga kariimet, iki sagaral se ani balikko! O Israel, ani den te ninga bitirikko. Ani Kaem, nenenga Kaem. ");
INSERT INTO wsk_vpl VALUES ("PS50_8","020_50_8","PSA","50","8","8","Ani nenenga tama bita aisa mu ko me iningisam; pempem tama bita aisisan mu yawarakala kani saposo. ");
INSERT INTO wsk_vpl VALUES ("PS50_9","020_50_9","PSA","50","9","9","Ani nenenga bulmakau kari agi goat por ningi bagasan mu ko me balsam tala. ");
INSERT INTO wsk_vpl VALUES ("PS50_10","020_50_10","PSA","50","10","10","Mu awuk, nio yalek se mel suen la giarum ningi mu se, bulmakau mel motongar kuting suen la te no giwasan, mu am aninga tala, se ani anape ko umu ko ninga isuekko? ");
INSERT INTO wsk_vpl VALUES ("PS50_11","020_50_11","PSA","50","11","11","Ani inangnang suen la giarum ningi binga geragasan mu am nunga ikia la; se kusiska se madar ugigi guringi bagasan mu yam aninga tala. ");
INSERT INTO wsk_vpl VALUES ("PS50_12","020_50_12","PSA","50","12","12","Ani ali kari iwita se na ko kuerik, mu ani anape ko nenenga manikko? Ali lilim la se mel suen la awote mu ani ko kotam. ");
INSERT INTO wsk_vpl VALUES ("PS50_13","020_50_13","PSA","50","13","13","O ani pa nengerak bulmakau nunguning nasam e? Ani goat ko gue me nasam tala, mena. ");
INSERT INTO wsk_vpl VALUES ("PS50_14","020_50_14","PSA","50","14","14","Buta se, ani Kaem Kalel Biya agarak den kaloman uwutata beteralko; tama bita aisisan iwitatala, nengemang motam lilim la aisal ale amilmil te aip patawuralko. ");
INSERT INTO wsk_vpl VALUES ("PS50_15","020_50_15","PSA","50","15","15","Ale ikup kam ningi mu aninga aural, se ani ninga sangaru taik se nina ani aip biya aisalko.” ");
INSERT INTO wsk_vpl VALUES ("PS50_16","020_50_16","PSA","50","16","16","Bare nina munan memek betera ko kariimet mu Kaem iwita nenenga ko balso: “Awiri kuring te nina aninga munan den mu ninimi karogo tutia gurugu lagasan? Ale anape ko den ani agarak kaloman mu nigiring guang te la balu lagasan? ");
INSERT INTO wsk_vpl VALUES ("PS50_17","020_50_17","PSA","50","17","17","Nina aninga den biriruwusan, ale to nibiring ko betesan. ");
INSERT INTO wsk_vpl VALUES ("PS50_18","020_50_18","PSA","50","18","18","Nina tere kari nongorak sorasan, ale kari imet karogo, agi imet kari karogo mu nunga tagisan ale nongorak nasan gisan. ");
INSERT INTO wsk_vpl VALUES ("PS50_19","020_50_19","PSA","50","19","19","Nenenga nigiring te den kawel se den memek arataso. ");
INSERT INTO wsk_vpl VALUES ("PS50_20","020_50_20","PSA","50","20","20","Nina nengeta ninga launuria nunga nunup te den kawel balsan, ale nenenga gue suan nubiring ko nunga balu maguwusan. ");
INSERT INTO wsk_vpl VALUES ("PS50_21","020_50_21","PSA","50","21","21","Nina uwuta bitakasan se ani den bo me balukasam, se nina ani nenenga bo iwita aga ikikasan. Bare aitak ani den te ninga betesam ale den te ninguru ninga atumekko. ");
INSERT INTO wsk_vpl VALUES ("PS50_22","020_50_22","PSA","50","22","22","“Nina kariimet nibiring ani aisisan, mu aninga den ikial ale giris palagalko! Mena mu, ani ninga batutumurek se katir katir kaparal se kariimet bo ninga sangukko mena. ");
INSERT INTO wsk_vpl VALUES ("PS50_23","020_50_23","PSA","50","23","23","Ikialko. Kariimet tama bita aisa iwita nongomang ningi nunguning te amilmil aisisan, mu ani aip biya aisisan, ale ani te nunga sangaru taikko lage kuring kagorsan.” ");
INSERT INTO wsk_vpl VALUES ("PS51_1","020_51_1","PSA","51","1","1","(David Uriah ko imet Bathsheba tam, se Yawe ilak tuatara ko kari Nathan ko David maonam se David den imi batogam.) O Kaem, nika kua nangara ko munan mu te gemang lila aisuko; nika gemang bataga biya mu te aga memek siwu waruko. ");
INSERT INTO wsk_vpl VALUES ("PS51_2","020_51_2","PSA","51","2","2","Aninga paguwura suen la siwu waru ale aninga memek anup nunguruko. ");
INSERT INTO wsk_vpl VALUES ("PS51_3","020_51_3","PSA","51","3","3","Aninga bita paguwura mu angamin te aniso, ale aga memek mu wetang te aniso. ");
INSERT INTO wsk_vpl VALUES ("PS51_4","020_51_4","PSA","51","4","4","Ani memek beterem mu ni ari saperem, ani munan memek nika motam te beterem; se ni den te aga betesam mu ni diram la betesam, ale aga memek wetang sapasam mu am diram. ");
INSERT INTO wsk_vpl VALUES ("PS51_5","020_51_5","PSA","51","5","5","Ani kuriang gue te la memek ago, se memek mu karogo aga ayam kumik te bilangerem. ");
INSERT INTO wsk_vpl VALUES ("PS51_6","020_51_6","PSA","51","6","6","Ni ani kuriang gue te la munan diram karo tuekko gemang anikaso; se nang tuagu ningi la ikia sinar aga kausem. ");
INSERT INTO wsk_vpl VALUES ("PS51_7","020_51_7","PSA","51","7","7","Ni hyssop kower te aga bilinguru se aninga memek menarukko; aga memek suen la anu waru se nika metam te nikim la bagarikko. ");
INSERT INTO wsk_vpl VALUES ("PS51_8","020_51_8","PSA","51","8","8","Ni aninga angimik asokel menawurem, bare aitak ni aninga sangaru se aking amilmil te bagarikko. ");
INSERT INTO wsk_vpl VALUES ("PS51_9","020_51_9","PSA","51","9","9","Ni aninga betera memek mu biring tui ale aga memek siwu waruko. ");
INSERT INTO wsk_vpl VALUES ("PS51_10","020_51_10","PSA","51","10","10","O Kaem, angamang motam nikim iru tuiko; ale sokel iru angamang motam ningi bitar se ani ni kerak la bagarikko. ");
INSERT INTO wsk_vpl VALUES ("PS51_11","020_51_11","PSA","51","11","11","Ni ka motam te me aga kau sarumu saparko; ale ka Bur Laili aninga ningi mu me tagi bataguru toko. ");
INSERT INTO wsk_vpl VALUES ("PS51_12","020_51_12","PSA","51","12","12","Aga sangaru tata ko amilmil mu akingtala angamang motam ningi bitarko; aninga ikia sangam aisu, se ani te ni bowa ningi la baga se lagarikko. ");
INSERT INTO wsk_vpl VALUES ("PS51_13","020_51_13","PSA","51","13","13","Mu te ani memek betera kariimet alo mu nika munan nunga kausek se giris palagamon kiring karo tumonko. ");
INSERT INTO wsk_vpl VALUES ("PS51_14","020_51_14","PSA","51","14","14","O Kaem, ni aninga Saonga Kari, gue agiting te aniso imi siwur se ani amilmil te nika munan ningo dirkiriyam mu ko wur iluwekko. ");
INSERT INTO wsk_vpl VALUES ("PS51_15","020_51_15","PSA","51","15","15","Kari Biya, aga sangaru se ka nip biya patawurikko. ");
INSERT INTO wsk_vpl VALUES ("PS51_16","020_51_16","PSA","51","16","16","Ani te tama bita kisa ko sipsip mel ta kete karogo tairik, bare ni mu ko me uririkisam; ani tama bita kisek ta, bare nika gemang motam tawun biya te me aniso tala. ");
INSERT INTO wsk_vpl VALUES ("PS51_17","020_51_17","PSA","51","17","17","O Kaem, tama bita kisa ko munan ni ko kuesam mu iwita: kari ko memek ari ko ikiso ale ko gomang ninguru batagoso; munan o ta umutang ni ko kuesam ale me biriruwusam. ");
INSERT INTO wsk_vpl VALUES ("PS51_18","020_51_18","PSA","51","18","18","O Kaem, nika amilmil ningo te wonong Zion gemang tui ale sangaruko; Jerusalem ko por lautam umu sokel tuiko. ");
INSERT INTO wsk_vpl VALUES ("PS51_19","020_51_19","PSA","51","19","19","Mu te ka kariimet nongomang motam ningo diram la te tama bita kisimonko, mel altar te lilim la kai sapara iwita bita kisimon se ni ko amilmilerko; asele aking bull nunga momon ale altar te aking tama bita kisimonko. ");
INSERT INTO wsk_vpl VALUES ("PS52_1","020_52_1","PSA","52","1","1","(Edom kari Doeg yumura la Saul kote namaram ale David Ahimelek ko kawam te namaram mu ko Saul maonam, se ko David batoga imi batogam) O kari sokel ago, ni anape ko kilek memek betesam mu ko nimi nip patawu lagasam? Ni Kaem motam te mu ni memek, se ni anape ko nimi patawu lagasam? ");
INSERT INTO wsk_vpl VALUES ("PS52_2","020_52_2","PSA","52","2","2","Ni kari maguwura ko den bala ko kua lagasam; nika kawel ko munan betesam mu kapit biling kore wuli karogo wore toroman. ");
INSERT INTO wsk_vpl VALUES ("PS52_3","020_52_3","PSA","52","3","3","Ni kiwem memek se den kawel bala mu ninguru ko kuesam, ale kiwem ningo se den nunguning bala mu biriruwusam. ");
INSERT INTO wsk_vpl VALUES ("PS52_4","020_52_4","PSA","52","4","4","Ni kiring kawel ago! Ale kariimet maguwura ko den baluko ninguru kuesam. ");
INSERT INTO wsk_vpl VALUES ("PS52_5","020_52_5","PSA","52","5","5","Bare ikiko, Kaem ka maguwura biya ka maguwurokko! Nu ka kawam ningi ka woyuk ale ali mu te ka menawura biya ka menawurokko! ");
INSERT INTO wsk_vpl VALUES ("PS52_6","020_52_6","PSA","52","6","6","Se kariimet ningo diram mu arigimon ale nonoman biyala sapamon, ale gusi se balmon, ");
INSERT INTO wsk_vpl VALUES ("PS52_7","020_52_7","PSA","52","7","7","“Arigalko! Kari imitang Kaem te me ira sanami lagakaso, kota ko mel suen biya te sanamikaso, ale kariimet nunga maguwura te sokel ago bagakaso, mu aitak koma tam!” ");
INSERT INTO wsk_vpl VALUES ("PS52_8","020_52_8","PSA","52","8","8","Bare ani mu tam olive bo, Kaem ko temple ko por ningi aragawara wore iwita, ani pempem Kaem ko kua nangara ko munan mu ko kua se te ira sanami lagasam. ");
INSERT INTO wsk_vpl VALUES ("PS52_9","020_52_9","PSA","52","9","9","O Kaem, ani ni kiwem beterem mu ko pempem amilmil kisu se lagarikko; ani nika kariimet nunga biguwura ningi ka nip patawurik ale ilukuawurikko, mu awuk, nika nip mu ningo. ");
INSERT INTO wsk_vpl VALUES ("PS53_1","020_53_1","PSA","53","1","1","(David ko wur) Kariimet sinar mena mu balsan, “Kaem mena!” masan. Nunga ikia maga saparam, se nuna munan suen la betesan mu am memek la betesan; ale bo ta munan ningo me beteso. ");
INSERT INTO wsk_vpl VALUES ("PS53_2","020_53_2","PSA","53","2","2","Kaem duruk wonong te baga se loagoso se ko kariimet lilim nongote tai kaposo, nu bo i ikia sinar karogo se nukote la motam bita lagoso wore arigokko loagoso. ");
INSERT INTO wsk_vpl VALUES ("PS53_3","020_53_3","PSA","53","3","3","Bare mena. Nuna suen la lage ningo nubiring tui muruwuman, ale suen la kilek memek te kapa sapaman; ale bo ta munan ningo bo me bitawoso, am mena biya. ");
INSERT INTO wsk_vpl VALUES ("PS53_4","020_53_4","PSA","53","4","4","Se kariimet memek bitawara mu awuk? Nuna me ari ikimonko e? Nuna aninga kariimet bread nokoyam nunga bita maguwusan; ale Kaem ko ikia me tasan. ");
INSERT INTO wsk_vpl VALUES ("PS53_5","020_53_5","PSA","53","5","5","Bare ikialko, nuna ninguru nguangamonko, nguangara ko nguangara nunga iramurokko; mu awuk, kari ninga moa maguwu lagaman mu ko koma, Kaem ninguru nunga menawurokko, ale nunga nosokel ngil ngual waru parusuwurokko. Nina mariraral se nuna dolomonko, mu awuk, Kaem nunga meram ale susuru gurugu nungaram. ");
INSERT INTO wsk_vpl VALUES ("PS53_6","020_53_6","PSA","53","6","6","O saonga! Aga angamang mu saonga bo Zion barasuk ale Israel kariimet nunga sangukko! Tom Kaem ko kariimet nunga sanguk se aking daiga bagara ningo arigimon, mu Jacob ko digo nongomang motam nungeruk se Israel kariimet amilmilamonko! ");
INSERT INTO wsk_vpl VALUES ("PS54_1","020_54_1","PSA","54","1","1","(Ziph kari alo Saul kote namaman ale David nononga sor te yumuram bagoso mu ko Saul manorman se David batoga imi batogam) O Kaem, nika nip biya ko sokel te aga bataguru toko; ani memek bo me beterem se nika sokel te aga sangaruko. ");
INSERT INTO wsk_vpl VALUES ("PS54_2","020_54_2","PSA","54","2","2","O Kaem, aninga guranek ikiko; degewa gurugu ale aninga aira ikiko. ");
INSERT INTO wsk_vpl VALUES ("PS54_3","020_54_3","PSA","54","3","3","Nusupuling lagara alo mu ani agarak kagerawasan; nuna daong kager ko kari se aninga momon se kuerikko; nuna Kaem mel yam ko iwita ikisan. ");
INSERT INTO wsk_vpl VALUES ("PS54_4","020_54_4","PSA","54","4","4","Nunguningta, Kaem mu aninga saonga kari; nu aninga bitarso se ani terong la bagasam. ");
INSERT INTO wsk_vpl VALUES ("PS54_5","020_54_5","PSA","54","5","5","O Kaem, nononga memek ani ago ko beteman mu koma nungaruko; ni munan diram la karo tua ko Kaem, buta se nunga menawurko. ");
INSERT INTO wsk_vpl VALUES ("PS54_6","020_54_6","PSA","54","6","6","O Yawe, aninga angamang amilmil te tama bo bita kisekko; ani nika nip patawurikko, mu awuk, nika nip mu ningo. ");
INSERT INTO wsk_vpl VALUES ("PS54_7","020_54_7","PSA","54","7","7","Ni aninga sangem se ikup suen la angimik te aratam mu me aga maguwuram, ale amotam te aga kager ni nunga maguwurem se nungarkem. ");
INSERT INTO wsk_vpl VALUES ("PS55_1","020_55_1","PSA","55","1","1","(David ko wur) O Kaem, aninga guranek ikiko! Ni aninga niara imi ko degewa me bagurko. ");
INSERT INTO wsk_vpl VALUES ("PS55_2","020_55_2","PSA","55","2","2","Aninga wosenga imi iki ale agiring ilupko; ikup imi aninga maguwurokko nunguning iwita se angimik gawa kaparam. ");
INSERT INTO wsk_vpl VALUES ("PS55_3","020_55_3","PSA","55","3","3","Kager kari aninga maguwumonko balsan, ale ani ninguru agarak kapa gilingisan; nuna ikup ani angimik te betesan, ale agarak balsan ale agarak barima gilingisan. ");
INSERT INTO wsk_vpl VALUES ("PS55_4","020_55_4","PSA","55","4","4","Ani angamang dung dung maso, se kuerikko betela nguangasam. ");
INSERT INTO wsk_vpl VALUES ("PS55_5","020_55_5","PSA","55","5","5","Nguangara biyala angimik te taiso ale angimik sail menawuram, se angimik barowara maso. ");
INSERT INTO wsk_vpl VALUES ("PS55_6","020_55_6","PSA","55","6","6","Ayo-o, ani inangnang arum iwita luman gemarik ale bingek awar biya namarik ale aeman saparikko. ");
INSERT INTO wsk_vpl VALUES ("PS55_7","020_55_7","PSA","55","7","8","Ani kuwim yumura bo, kariimet mena se awar biya, wore te biririka namarik ale tuwik marir ewere ko yumurekko. ");
INSERT INTO wsk_vpl VALUES ("PS55_9","020_55_9","PSA","55","9","9","O Kari Biya, kariimet memek alo nunga ikia ngualawur ale ikia betemonko mu menawurko! Mu awuk, ani kager daong ngual ngual wonong biya ningi ari lagasam. ");
INSERT INTO wsk_vpl VALUES ("PS55_10","020_55_10","PSA","55","10","10","Tirom kowarkalal nuna ikup betemonko wonong karo gurungumu lagasan; se wonong tuagu ningi kariimet nunga bita maguwura ko munan mu ninguru aniso. ");
INSERT INTO wsk_vpl VALUES ("PS55_11","020_55_11","PSA","55","11","11","Munan memek duap duap barasam ale wonong tuagu ninguru maguwuram; kariimet nguangara tua ale kote mel gia, se kawel ko munan sor lilim iram. ");
INSERT INTO wsk_vpl VALUES ("PS55_12","020_55_12","PSA","55","12","12","Aninga kager kari memek alo nunga bo ago ko bala memek balam le mu, ani ko ikia tawun biya me aga moso le. Agi nu numi biya ko iki se ani kituwura ko aga beteso le mu, ani am abiring tui namasam le. ");
INSERT INTO wsk_vpl VALUES ("PS55_13","020_55_13","PSA","55","13","13","Bare mena. Mu nigita, kari aninga turan tala, aninga bagara suan se aga yawara, nigita munan owore bitakasam. ");
INSERT INTO wsk_vpl VALUES ("PS55_14","020_55_14","PSA","55","14","14","Ni analak nanimi ninguru gikasan, ale kariimet sang nongorak Kaem ko temple ningi namakasan ale Kaem nup patawukasan. ");
INSERT INTO wsk_vpl VALUES ("PS55_15","020_55_15","PSA","55","15","15","Aga bita maguwura ko kari alo mu kuera mateng nunga iluwok se marak loaga se kari kuera nunga mutim ningi kapamonko! Mu awuk, nononga nongomang motam se nunga bagara mu kiwem memek karogo terong ma saparam. ");
INSERT INTO wsk_vpl VALUES ("PS55_16","020_55_16","PSA","55","16","16","Bare ani Yawe, aninga Kaem, mu aurik se nu aninga bataguru taukko. ");
INSERT INTO wsk_vpl VALUES ("PS55_17","020_55_17","PSA","55","17","17","Turomola, woremkalal, bainga ningi ani ikup yaman ningi nia kika lagasam, se nu agiring ikiok ale aga sangukko. ");
INSERT INTO wsk_vpl VALUES ("PS55_18","020_55_18","PSA","55","18","18","Suen biya agarak kagersan, bare ani ikup bo me arigekko, mu awuk, nu aga bituok ale aga bataguru taukko. ");
INSERT INTO wsk_vpl VALUES ("PS55_19","020_55_19","PSA","55","19","19","Kaem, king ko pempem la baga lagoso, mu aga niara ikiok ale aga kager kari nunga menawurokko; mu awuk, nuna nu ko me nguangasan, ale nunga munan memek mu ko me giris palagasan. ");
INSERT INTO wsk_vpl VALUES ("PS55_20","020_55_20","PSA","55","20","20","Aninga tiran yawara mu noko sikisaki ikup ningi nunga waram; ale anananga ikia kaloman mu kulukam. ");
INSERT INTO wsk_vpl VALUES ("PS55_21","020_55_21","PSA","55","21","21","Kuring te mu den welang welang balso, bare gomang motam ningi mu kager ko tama iwita kaniwoso; noko den mu malin kaukoyam ikiko, bare den mu batir iwita nanga bataguruwoso. ");
INSERT INTO wsk_vpl VALUES ("PS55_22","020_55_22","PSA","55","22","22","Nika ikup suen la Yawe kuting te bitarko, se nu giok ale nu nika sangukko; nu kariimet ningo diram mu nungarkiwuruk se memek bo me arigimonko. ");
INSERT INTO wsk_vpl VALUES ("PS55_23","020_55_23","PSA","55","23","23","Bare ni, O Kaem, mu kariimet memek alo mu nunga karanguru se kuwim memek mu te namamonko; kawel kari se kariimet nunga mora se kuera ko kari mu kulak la kua namamonko. Bare ani agata mu, nikate la ira sanami se lagarikko. ");
INSERT INTO wsk_vpl VALUES ("PS56_1","020_56_1","PSA","56","1","1","(Philistia alo wonong sor Gath mu te David ilu talipaman se nu wur imi batogam) O Kaem, gemang motam lila aisuko, mu awuk, kager kari memek aninga momonko aga karo lagasan; nuna kowarkalal maiya ani memek te aga bita gilingisan. ");
INSERT INTO wsk_vpl VALUES ("PS56_2","020_56_2","PSA","56","2","2","Nuna nonoman sapara mena agarak kagera lagasan; nuna suen biya se nunumi patawusan ale agarak kagera gilingisan. ");
INSERT INTO wsk_vpl VALUES ("PS56_3","020_56_3","PSA","56","3","3","Tom ani nguangasam mu aninga loagara suanta mu ni aninga sangaruko mu te betesam. ");
INSERT INTO wsk_vpl VALUES ("PS56_4","020_56_4","PSA","56","4","4","Ni aga Kaem, ani ka den ko amilmilasam, ale nikate la ira sanamasam, ale me nguangasam. Ali ko kari bo awuk ta aga maguwurokko? ");
INSERT INTO wsk_vpl VALUES ("PS56_5","020_56_5","PSA","56","5","5","Nuna kowarkalal maiya dagisan ale den bo te aninga bita maguwumonko wore kupu lagasan, ale nuna aguwaya aga maguwumonko wore ko balu lagasan. ");
INSERT INTO wsk_vpl VALUES ("PS56_6","020_56_6","PSA","56","6","6","Nuna yumusan ale aninga tigiru lagasan; nononga ikia biya mu aninga momon se kuerikko. ");
INSERT INTO wsk_vpl VALUES ("PS56_7","020_56_7","PSA","56","7","7","O Kaem, ni nunga memek koma nungaruko! Nika gemang magara te kariimet umu nunga maguwurko! ");
INSERT INTO wsk_vpl VALUES ("PS56_8","020_56_8","PSA","56","8","8","Ani ikup giem ale karogo mo se memek baga lagerem mu ni ko iki saperem; ni aninga amononge awilaya kaparam mu ni kau saperem ale ko ikisam. ");
INSERT INTO wsk_vpl VALUES ("PS56_9","020_56_9","PSA","56","9","9","Se tom ani nika aurik mu ani ikisam, aga kager kari mu nagu sapamonko. Umu te ani ikisam, Kaem mu aninga saonga bagoso. ");
INSERT INTO wsk_vpl VALUES ("PS56_10","020_56_10","PSA","56","10","10","Ani Kaem ko den ko amilmilasam, ani Yawe ko den ko amilmilasam. ");
INSERT INTO wsk_vpl VALUES ("PS56_11","020_56_11","PSA","56","11","11","Ani Kaem te la ira sanamasam, ale me nguangasam. Ali ko kari bo awuk ta aga maguwurokko? ");
INSERT INTO wsk_vpl VALUES ("PS56_12","020_56_12","PSA","56","12","12","O Kaem, ani aga den balem uwutata bitirik ale amilmil te tama bita kisekko. ");
INSERT INTO wsk_vpl VALUES ("PS56_13","020_56_13","PSA","56","13","13","Mu awuk, ni ani mateng lage te aga bataguru taem, se ani asiwik atumem ale me dagulem; buta se ani Kaem nup patawu se, marak ningo ko nikim te la aolak iluwekko. ");
INSERT INTO wsk_vpl VALUES ("PS57_1","020_57_1","PSA","57","1","1","(David Saul ko naguram ale garap gogong ningi baga se den imi batogam) Gemang aisuko, O Kaem, gemang lila aisuko; ni aninga yumura kuwim. Ani nika kiting bowa kararik ale bagarik se mel memek suen la aga maguwurokko taiso mu mena saparukko. ");
INSERT INTO wsk_vpl VALUES ("PS57_2","020_57_2","PSA","57","2","2","Aninga niara Kaem Kalel Biya mu kote betesam; nu aninga bitarso. ");
INSERT INTO wsk_vpl VALUES ("PS57_3","020_57_3","PSA","57","3","3","Nu duruk wonong te baga se aninga sangarso, ale kager kari aga karowasan mu ining nungarso; Kaem me aga beteso, aninga kueso ale lage mu te aga sangarso. ");
INSERT INTO wsk_vpl VALUES ("PS57_4","020_57_4","PSA","57","4","4","Ani kausik memek aga laturman se kusumuri bagasam; nuna kariimet nunga moa namonko bagasan; nononga nogore mu gatu kore iwita, se nunga nungamili mu batir wuli karogo wore toroman. ");
INSERT INTO wsk_vpl VALUES ("PS57_5","020_57_5","PSA","57","5","5","O Kaem, nika nip biya taiti gomang suen la te wetang saparko, se ka kimik nikim biya mu ali lilim iramurokko. ");
INSERT INTO wsk_vpl VALUES ("PS57_6","020_57_6","PSA","57","6","6","Nuna ani te aga ilumonko dagarok kereman, se ani angamang ninguru ikuwoso; nuna aninga lage te mutim bo iman, bare aking nongota ningi dagulaman. ");
INSERT INTO wsk_vpl VALUES ("PS57_7","020_57_7","PSA","57","7","7","O Kaem, ani ni ko ko angamang me namoso taiso, ani angamang sokel ago bagasam; ani nika wur iluwek ale nip patawurikko. ");
INSERT INTO wsk_vpl VALUES ("PS57_8","020_57_8","PSA","57","8","8","Ani ukira duap ago barasik ale aga gita se kulele kolawirik se sor ukirokko! ");
INSERT INTO wsk_vpl VALUES ("PS57_9","020_57_9","PSA","57","9","9","O Kari Biya, ani sor kasik la nongoma te amilmil kisek, ale kariimet suen la nongoma te wur iluwek ale nip patawurikko. ");
INSERT INTO wsk_vpl VALUES ("PS57_10","020_57_10","PSA","57","10","10","Mu awuk, nika kua nangara mu kumik tom mena, taiti gomang kiaram; se nika munan me nanga bita ariga mu betela, taiti gomang karogo terong mam. ");
INSERT INTO wsk_vpl VALUES ("PS57_11","020_57_11","PSA","57","11","11","O Kaem, nika nip biya taiti gomang suen la te wetang saparko, se ka kimik nikim biya mu ali lilim iramurokko. ");
INSERT INTO wsk_vpl VALUES ("PS58_1","020_58_1","PSA","58","1","1","(David ko wur) Nina supuling alo, nina kiwem diram la te den arigisan ale tutesan? Nina nunguningta kusumuri ko baga se kariimet nunga ikup tutesan? ");
INSERT INTO wsk_vpl VALUES ("PS58_2","020_58_2","PSA","58","2","2","Mena! Nenenga ikia mu munan memek beteralko wore la nengemang te aniso, se nina kariimet suen la nunga maguwuwasan. ");
INSERT INTO wsk_vpl VALUES ("PS58_3","020_58_3","PSA","58","3","3","Kariimet memek alo mu nunga bilangara tom te la lage ningo bita taman; nuna nunam tuagu ningi la den kawel ago terong maman. ");
INSERT INTO wsk_vpl VALUES ("PS58_4","020_58_4","PSA","58","4","4","Nononga nodogawa mu, kausik daong daongarukko se kotam kuring me ikiso iwita, se nononga den mu kausik ko kore wuli karogo iwita; ");
INSERT INTO wsk_vpl VALUES ("PS58_5","020_58_5","PSA","58","5","5","se kariimet bo ta ikia duap duap te nunga lila awurokko me terong, nuna node sisi saparam. ");
INSERT INTO wsk_vpl VALUES ("PS58_6","020_58_6","PSA","58","6","6","O Yawe, ni nuguring ningi nogore kulukumur ale nunga norogen sail biagerko! ");
INSERT INTO wsk_vpl VALUES ("PS58_7","020_58_7","PSA","58","7","7","Nunga menawur se yu palengoso nama maraka namoso iwita maraka namamonko; ale nunga gatu mare iwita nunga kulukumu waruko. ");
INSERT INTO wsk_vpl VALUES ("PS58_8","020_58_8","PSA","58","8","8","Nuna tanan worem nunga kaiso se pasak ala kua namasan iwita, kua maraka namamonko; nuna kuriang gugum motam worem me ariga la kua namara iwita, kua namamonko. ");
INSERT INTO wsk_vpl VALUES ("PS58_9","020_58_9","PSA","58","9","9","Kaem kani tama kuamili awote me karso la, nu kariimet memek mu garuk te, se kulak te, pasak ala nunga sarumu warukko. ");
INSERT INTO wsk_vpl VALUES ("PS58_10","020_58_10","PSA","58","10","10","Kariimet memek bitawara mu nunga memek koma tamon se kariimet ningo diram mu nungarkamon ale amilmilamonko; kariimet memek mu nunga gue kaparuk se kariimet ningo mu awote aolak ilumonko. ");
INSERT INTO wsk_vpl VALUES ("PS58_11","020_58_11","PSA","58","11","11","Asele kariimet balmon, “Nunguningta, Kaem kariimet ningo diram mu koma ningo nungarso; Kaem nunguningta baga se munan diram te ali lilim la tuteso.” ");
INSERT INTO wsk_vpl VALUES ("PS59_1","020_59_1","PSA","59","1","1","(David ko wur; Saul ko kager kari alo David ko kawam laturman ale David momon se kuerukko bagakasan) O Kaem, kari memek nuguting te aga bataguru toko; kari ani agarak barimawasan mu nunga, aga bitaruko. ");
INSERT INTO wsk_vpl VALUES ("PS59_2","020_59_2","PSA","59","2","2","Nuna kari mora se kuera ko kari, mu nuguting te aga bataguru to ale aga sangaruko. ");
INSERT INTO wsk_vpl VALUES ("PS59_3","020_59_3","PSA","59","3","3","Arikko! Nuna yumuman ale aninga momon se kuerikko loagawasan! Nuna kari memek alo nunguningkiri se ilu biguwuman ale ani agarak kagermonko. O Yawe, nuna uwuta aga betesan mu am kumik duap bo mena nunguningkiri. ");
INSERT INTO wsk_vpl VALUES ("PS59_4","020_59_4","PSA","59","4","4","Ani memek bo me beterem, bare ani agarak kagermonko bagasan. O Kaem, ni bares ale aga sangaruko! ");
INSERT INTO wsk_vpl VALUES ("PS59_5","020_59_5","PSA","59","5","5","O Yawe, ni Kaem Sokel Garagar, ni Israel ko Kaem, ni bares ale kari memek alo mu suen la nunga maguwurko, nuna memek nunguningkiri se me ta nunga gemang nungaruko. ");
INSERT INTO wsk_vpl VALUES ("PS59_6","020_59_6","PSA","59","6","6","Nuna tirom pelesan taisan ale wonong karo gurungumu se kausik iwita kager ko ngararak ngararak geragasan. ");
INSERT INTO wsk_vpl VALUES ("PS59_7","020_59_7","PSA","59","7","7","Nuna nuguring te den balsan mu memek biya, batir kore wuli tamatama wore toroman, ale balsan, “Awiri ‘mena’ maukko? Mena!” masan. ");
INSERT INTO wsk_vpl VALUES ("PS59_8","020_59_8","PSA","59","8","8","Bare O Yawe, ni nunga gusisam; ale nunga den alel balsam. ");
INSERT INTO wsk_vpl VALUES ("PS59_9","020_59_9","PSA","59","9","9","Ni aninga Sokel, se aga sangaruko nikate la ira sanami lagasam; O Kaem, ni aninga yumura kuwim, ");
INSERT INTO wsk_vpl VALUES ("PS59_10","020_59_10","PSA","59","10","10","se ni ninguru aga kua lagasam; se ani ikisam, ni aninga sangaru se kager kari memek umu abowa nunga tugumekko. ");
INSERT INTO wsk_vpl VALUES ("PS59_11","020_59_11","PSA","59","11","11","Bare aninga kariimet me ari ikimon bore ko, O Biya, anananga Karem, ni pasak ala kari memek umu me nunga moar se kuemonko; nika sokel aora mu te nunga bila ale nunga parusuwur se nungumik sokel menarukko. ");
INSERT INTO wsk_vpl VALUES ("PS59_12","020_59_12","PSA","59","12","12","Nuna nuguring nungamili te den kawel se nunumi patawura ko den aratu lagoso, bare mu giris palaguk ale nunga taliparukko. Nuna den memek te saki alo nunga balu maguwusan, ");
INSERT INTO wsk_vpl VALUES ("PS59_13","020_59_13","PSA","59","13","13","buta se nika gemang memek te nunga maguwur ale nunga menawu sapar se menara biya menamonko. Ni uwuta bitar se ali sor suen biya ko kariimet te ikimon ale balmon, “Jacob ko Kaem nongorak bagoso.” ");
INSERT INTO wsk_vpl VALUES ("PS59_14","020_59_14","PSA","59","14","14","Aninga kager kari mu tirom pelesan taisan ale wonong karo gurungumu se kausik iwita ngararak ngararak geragasan. ");
INSERT INTO wsk_vpl VALUES ("PS59_15","020_59_15","PSA","59","15","15","Nuna na ko loagasan geragasan, ale me arigisan mu am ngus ngus geraga lagasan. ");
INSERT INTO wsk_vpl VALUES ("PS59_16","020_59_16","PSA","59","16","16","Bare ani nika sokel aora biya mu ko wur iluwekko; turomola pempem mu ani nika kua nangara mu ko wur iluwekko; mu awuk, ikup kam ningi mu ni aninga yumura kuwim, se aninga manga gek am. ");
INSERT INTO wsk_vpl VALUES ("PS59_17","020_59_17","PSA","59","17","17","Ni aninga Sokel, ani wur iluwek ale nip patawurikko; O Kaem, ni aninga yumura kuwim, se ni ninguru aga kua lagasam. ");
INSERT INTO wsk_vpl VALUES ("PS60_1","020_60_1","PSA","60","1","1","(David ko wur, kariimet nunga kausa ko. David sor Aram Naharaim se Aram Zobah ko kariimet nongorak kageraram ale wur batogam. David ko kager supuling Joab kager te pila se, Edom kari twelve thousand, sor wolong “Valley of Salt” masan mu te nunga moram se kueman.) O Kaem, ni ana nago ko gemang magaram se biring gurugu nangarem se kager utu naguram ale nasokel menawuram; bare akingtala nanga sangaruko! ");
INSERT INTO wsk_vpl VALUES ("PS60_2","020_60_2","PSA","60","2","2","Ni wanara sor maguwu kam anananga ali yukuem, se papak mam woselaram ale yukuawoso; bare tair ale nunguru burangir se kuwim kuwim te aking pelerukko. ");
INSERT INTO wsk_vpl VALUES ("PS60_3","020_60_3","PSA","60","3","3","Ni ana nika kariimet ikup ninguru nangarem, se kariimet yu aora nana ale dagulu barasukam ana dagulu barasuwasan. ");
INSERT INTO wsk_vpl VALUES ("PS60_4","020_60_4","PSA","60","4","4","Bare ni gatu supuling se ka gatu patawurem, kariimet ni bowa ningi bagara mu tai nikate la biguwumon ale kager ko sokel iru tamonko. ");
INSERT INTO wsk_vpl VALUES ("PS60_5","020_60_5","PSA","60","5","5","Ni ana ninguru nanga kuesam, bore te se ka sokel te nanga sangaru toko. ");
INSERT INTO wsk_vpl VALUES ("PS60_6","020_60_6","PSA","60","6","6","Kaem ko kuwim laili mu ningi baga se den imi balam, “Ani amilmil te, sail te Shechem ali mu pakakumurik, ale sor wolong Succoth mu karogo tala parusuwu aga kariimet nungaru gurugekko. ");
INSERT INTO wsk_vpl VALUES ("PS60_7","020_60_7","PSA","60","7","7","Gilead mu aninga; se Manasseh mu aninga; Ephraim mu aninga kager ko kitigat; se Judah mu aninga bitua ura ko tam. ");
INSERT INTO wsk_vpl VALUES ("PS60_8","020_60_8","PSA","60","8","8","Moab mu tawir yam bo iwita; se Edom mu aninga asiwik gomang te bitirikko; se Philistia ningi mu ani amilmil ngata te bitirikko.” ");
INSERT INTO wsk_vpl VALUES ("PS60_9","020_60_9","PSA","60","9","9","Bare aga Kaem, awiri ani agarak sor Edom mu te namaruk ale ko wonong sokel aora garagar mu ningi agarak kaparukko? ");
INSERT INTO wsk_vpl VALUES ("PS60_10","020_60_10","PSA","60","10","10","Awiriya bo mena, mu am nigita. Ni biring gurugu nangarem ale kager te me nanga sangarukasam. ");
INSERT INTO wsk_vpl VALUES ("PS60_11","020_60_11","PSA","60","11","11","Bare aitak mu ni ana nanga sangaruko; mu awuk, ali ko kari bo ana nanga sangukko me terong. ");
INSERT INTO wsk_vpl VALUES ("PS60_12","020_60_12","PSA","60","12","12","Bare ana nanga Kaem te mu ana kager te mariranakko; nu kota kager kari memek alo mu nunga waruk se kapamonko. ");
INSERT INTO wsk_vpl VALUES ("PS61_1","020_61_1","PSA","61","1","1","(David ko wur) O Kaem, de gurugu ale aninga guranek ewere ikiko. ");
INSERT INTO wsk_vpl VALUES ("PS61_2","020_61_2","PSA","61","2","2","Ani wonong iwareng bo awar biya wore te baga se, saonga bo taikko lage bo am mena biya se ani nika arusam, ni ani agarak nama manga bo kalel biya owore awote aga patawu bitarko. ");
INSERT INTO wsk_vpl VALUES ("PS61_3","020_61_3","PSA","61","3","3","Mu awuk, ni aninga manga gek am se aga lauta aora; se kari memek me ta aga maguwumonko. ");
INSERT INTO wsk_vpl VALUES ("PS61_4","020_61_4","PSA","61","4","4","Aga angamang mu nika sasal ningi kerak pempem la baga se lagarikko; se ni tarak nuam ko luman te gotek nunga ira kaluwuso iwita, aga ira kaluwurko. ");
INSERT INTO wsk_vpl VALUES ("PS61_5","020_61_5","PSA","61","5","5","O Kaem, ni aninga den kerak balu saperem mu ni ikiem; ale ali mel suen la, awiriya ni iki karo kisisan se nungarem, mu ni agotala aisem. ");
INSERT INTO wsk_vpl VALUES ("PS61_6","020_61_6","PSA","61","6","6","Ni marak sokel ani aisu se ani king ko, tom maiya biya ali imi te baga se aga imas bitir kapa se lagarukko. ");
INSERT INTO wsk_vpl VALUES ("PS61_7","020_61_7","PSA","61","7","7","Se ani nika bitua bowa ningi butata king ko baga se lagarikko; ni pempem la ka kua aisa, kumik menara mena, mu ko munan te aga bitaruko. ");
INSERT INTO wsk_vpl VALUES ("PS61_8","020_61_8","PSA","61","8","8","Se ani mu tom suen la wur ilu se nika nip patawu se, aga den kerak balem mu pempem bita se lagarikko. ");
INSERT INTO wsk_vpl VALUES ("PS62_1","020_62_1","PSA","62","1","1","(David ko wur) Ani Kaem kota aga sangukko mu ko iki se angamang lila te baga lagasam; aninga saonga mu nukote tasam. ");
INSERT INTO wsk_vpl VALUES ("PS62_2","020_62_2","PSA","62","2","2","Nu kota aninga manga aora, se aninga saonga kari; nu aninga manga gek am, se ani me soror maikko. ");
INSERT INTO wsk_vpl VALUES ("PS62_3","020_62_3","PSA","62","3","3","Se nina amaru aninga mora maguwura sowore beteralko? Ani kar parasaram ale dalelawoso iwita bagasam, bare awuk, am aga itakuawural se dagulu parasarikko e? ");
INSERT INTO wsk_vpl VALUES ("PS62_4","020_62_4","PSA","62","4","4","Nunguningta, nuna aninga ura nup ago te bagasam wore te am aga menawumonko nunguningkiri karogo kaesan; nuna nuguring guang la angimik ko ningo balsan ale munan umu ko ninguru amilmilasan, bare nongomang motam ningi mu am maga namarikko balsan. ");
INSERT INTO wsk_vpl VALUES ("PS62_5","020_62_5","PSA","62","5","5","Bare ani Kaem kota aga sangukko mu ko iki se angamang lila te bagarikko; aninga angamang motam ko sangam mu nukote tasam. ");
INSERT INTO wsk_vpl VALUES ("PS62_6","020_62_6","PSA","62","6","6","Nu kota aninga manga aora, se aninga saonga kari; nu aninga manga gek am, se ani me soror maikko. ");
INSERT INTO wsk_vpl VALUES ("PS62_7","020_62_7","PSA","62","7","7","Kaem kota aninga sangarso, ale kota nup biya aisiso; nu aninga manga aora, se aga yumura kuwim. ");
INSERT INTO wsk_vpl VALUES ("PS62_8","020_62_8","PSA","62","8","8","O aga kariimet, Kaem kote la ira sanami se lagaralko; nengemang motam lilim la kausalko; mu awuk, nu anananga yumura kuwim. ");
INSERT INTO wsk_vpl VALUES ("PS62_9","020_62_9","PSA","62","9","9","Kariimet nunup mena mu marir nagiring te pus masan se aratu nama menaso iwita; se kariimet nunup ago mu mel nunguning bo mena, am ko dora wore iwita; se skel te ta nunga awumon mu nungumik ikup mena, wete guyak gotek. ");
INSERT INTO wsk_vpl VALUES ("PS62_10","020_62_10","PSA","62","10","10","Buta se nina tere daong te saki nunga mel tagiral ale me ninimi te patawuralko; se munan umu te mel gemaral, mu me te ira sanamaralko. ");
INSERT INTO wsk_vpl VALUES ("PS62_11","020_62_11","PSA","62","11","11","Kaem ko munan wetang te beteram se ani mel ilagala ko ikiem: “O Kaem, ni sokel karogo, ");
INSERT INTO wsk_vpl VALUES ("PS62_12","020_62_12","PSA","62","12","12","O Kari Biya, ni kariimet ninguru nunga kuesam; ni ana suen la nanga munan betesan mu te iki se diram la koma nangaruko.” ");
INSERT INTO wsk_vpl VALUES ("PS63_1","020_63_1","PSA","63","1","1","(David naguram ale Judea ningi sor garagarayam mu te yumuram baga se den imi batogam) O Kaem, ni aninga Kaem, ani ni kerak pempem bagarikko kua lagasam; ani yu ko kuakoyam, ni ko ko adogotak garagara maso; ani ni kiwim ko angimik sokel menaram, se sor merang garagarayam bo yu mena wore turan bagasam. ");
INSERT INTO wsk_vpl VALUES ("PS63_2","020_63_2","PSA","63","2","2","Ani ni nikim sokel ago ka kiwim laili te bagasam mu, amotam te karki kam ko ikia to lagasam. ");
INSERT INTO wsk_vpl VALUES ("PS63_3","020_63_3","PSA","63","3","3","Nika gemang bataga ani ago ko mu, ali imi ko nam giam suen la kia saparam, se ani mu ko nika nip patawurikko. ");
INSERT INTO wsk_vpl VALUES ("PS63_4","020_63_4","PSA","63","4","4","Ani pempem agiting patawurik ale ka nip patawu se lagarikko. ");
INSERT INTO wsk_vpl VALUES ("PS63_5","020_63_5","PSA","63","5","5","Se aninga angamang motam mu na ningo nokoyam kua kaparuk se wur amilmil ilu se nip patawu se lagarikko. ");
INSERT INTO wsk_vpl VALUES ("PS63_6","020_63_6","PSA","63","6","6","Aninga anira kuwim te taga anisam mu ani ni ko ko angamin tugu lagasam; tirom luan maiya ani ni ko ko me angamili saposo. ");
INSERT INTO wsk_vpl VALUES ("PS63_7","020_63_7","PSA","63","7","7","Mu awuk, ni tom suen biya aninga sangorsam; ani nika luman bowa ningi baga se wur ilusam. ");
INSERT INTO wsk_vpl VALUES ("PS63_8","020_63_8","PSA","63","8","8","Ani ni kerak kapetasam, se ni yawarakala aga bitarsam. ");
INSERT INTO wsk_vpl VALUES ("PS63_9","020_63_9","PSA","63","9","9","Kari aninga momon se kuerikko nongomang aniso mu memek tamon ale kuera mutim ningi kapamonko. ");
INSERT INTO wsk_vpl VALUES ("PS63_10","020_63_10","PSA","63","10","10","Nuna kager ningi kuemon se nunga nungumik guang mu kausik diwang namonko. ");
INSERT INTO wsk_vpl VALUES ("PS63_11","020_63_11","PSA","63","11","11","Bare king mu Kaem ko amilmilarukko; kariimet nu te la ira sanami lagasan mu nup patawumonko; bare kawel ko kariimet mu nuguring sisirokko. ");
INSERT INTO wsk_vpl VALUES ("PS64_1","020_64_1","PSA","64","1","1","(David ko wur) O Kaem, ani ikup memek ningi bagasam; degewa gurugu ale aninga guranek ikiko; aninga bitaru se kager kari me aga maguwumonko. ");
INSERT INTO wsk_vpl VALUES ("PS64_2","020_64_2","PSA","64","2","2","Kiwem memek betera ko kariimet alo mu aninga bita maguwumonko den kalosan; buta se ni aninga kaluwurko. ");
INSERT INTO wsk_vpl VALUES ("PS64_3","020_64_3","PSA","64","3","3","Nononga nungamili mu batir iwita, se nunga den mu gatu kore memek iwita. ");
INSERT INTO wsk_vpl VALUES ("PS64_4","020_64_4","PSA","64","4","4","Nuna nungumik nguangara mena; nuna yumusan ale baga se kariimet nungumik den mena mu nunga mosan. ");
INSERT INTO wsk_vpl VALUES ("PS64_5","020_64_5","PSA","64","5","5","Nuna nunga ikia memek mu betemonko nunumi atumu sangorsan, ale yumura la dagarok betesan ale balsan, “Awiri nangarkukko ya?” masan. ");
INSERT INTO wsk_vpl VALUES ("PS64_6","020_64_6","PSA","64","6","6","Nuna ikia memek kalosan ale balsan, “Ana ikia bo am terong la kaloman se kariimet bo ta me ko ikiokkowo,” masan. ");
INSERT INTO wsk_vpl VALUES ("PS64_7","020_64_7","PSA","64","7","7","Bare nuna me ko ikimon se Kaem noko gatu te nunga moruk se kapamonko. ");
INSERT INTO wsk_vpl VALUES ("PS64_8","020_64_8","PSA","64","8","8","Nu nunga den yumura kaloman mu gurugok se peleruk nongota nunga maguwurokko; se kariimet nungarkamon ale nungumik barowara maukko. ");
INSERT INTO wsk_vpl VALUES ("PS64_9","020_64_9","PSA","64","9","9","Kariimet suen la mu nguangamonko; nuna Kaem kiwem beteram mu ko balmon ale, kiwem umu mu nungamin te ani se lagarukko. ");
INSERT INTO wsk_vpl VALUES ("PS64_10","020_64_10","PSA","64","10","10","Kariimet ningo diram mu nuguting momon ale Yawe ko amilmilamonko; nuna noko nup patawumon se nu nunga bituokko. ");
INSERT INTO wsk_vpl VALUES ("PS65_1","020_65_1","PSA","65","1","1","(David ko wur) O Kaem, ana Zion namanak ale nip patawunakko; ale nanga ikia kerak kaloman mu bita sapanakko. ");
INSERT INTO wsk_vpl VALUES ("PS65_2","020_65_2","PSA","65","2","2","Ni ana nanga guranek koma nangarsam, se ana kariimet suen la nikate taisan. ");
INSERT INTO wsk_vpl VALUES ("PS65_3","020_65_3","PSA","65","3","3","Anananga munan memek umu ko ikup ninguru nanga maguwuso, bare ni anananga memek mu siwu warsam. ");
INSERT INTO wsk_vpl VALUES ("PS65_4","020_65_4","PSA","65","4","4","Kariimet ni nunga balsam nika masam, ale nongorak ka kuwim laili te taisam, mu amilmilamonko! Ana nika munan yawara yawara nika temple laili ningi aniso mu karogo ninguru amilmilasan. ");
INSERT INTO wsk_vpl VALUES ("PS65_5","020_65_5","PSA","65","5","5","O Kaem, anananga Sangaru Ta Kari, ni kiwem duap duap te nagiring ilusam ale nanga bataguru tasam. Ali lilim ko kariimet se gagi batoga te ta wore nikate la nunga loagara ikia betesan. ");
INSERT INTO wsk_vpl VALUES ("PS65_6","020_65_6","PSA","65","6","6","Nika sokel aora mu te duruk bibiya mu nunga nungem, ale mu te nika sokel biya mu wetang saperem. ");
INSERT INTO wsk_vpl VALUES ("PS65_7","020_65_7","PSA","65","7","7","Ni gagi tamun ko kuring nirung kapawaram mu manem se kutek mam; ale kariimet nunga kager ko munak nirung mu uwutatala menawurem. ");
INSERT INTO wsk_vpl VALUES ("PS65_8","020_65_8","PSA","65","8","8","Kariimet awar bibiya bagasan mu nika kiwem bibiya imi arigisan ale biririkasan; kariimet worem bausa te se worem kapara te mu wur ilusan ale amilmilasan. ");
INSERT INTO wsk_vpl VALUES ("PS65_9","020_65_9","PSA","65","9","9","Ni ali imi lilim la ko sinar tasam ale yu tusam se ali welang gemaso; nika yu suen la mu nungumik maraka namara bo mena; se nika kariimet na inang karogo terong ma sapasan. Nika gemang uwutata aniram se ni te uwutata beterem. ");
INSERT INTO wsk_vpl VALUES ("PS65_10","020_65_10","PSA","65","10","10","Ni tuwik te ningam yu tusam se ali mu yu karogo, buta se yu mu ali bugulik tuso se na inang terong la barasoso. ");
INSERT INTO wsk_vpl VALUES ("PS65_11","020_65_11","PSA","65","11","11","Nika ningo mu nangarsam se na inang sor magoso; se kariimet nunga inang te gia ko kitak se korokem mu mel suen la kuring aratu saposo. ");
INSERT INTO wsk_vpl VALUES ("PS65_12","020_65_12","PSA","65","12","12","Sor palunga wosesel biya mu te sirsir ningo barasoso; se duruk luan amilmil kelagoso. ");
INSERT INTO wsk_vpl VALUES ("PS65_13","020_65_13","PSA","65","13","13","Sor sirsir karogo mu sipsip sor magaram ale suen biya; se duruk duap ningi sor wolong mu inang muguri karogo terong mam; se melmasak suen biya ninguru tala amilmilasan. ");
INSERT INTO wsk_vpl VALUES ("PS66_1","020_66_1","PSA","66","1","1","Ali sor lilim ko kariimet, amilmil kelagal ale Kaem nup patawuralko! ");
INSERT INTO wsk_vpl VALUES ("PS66_2","020_66_2","PSA","66","2","2","Wur iluwal, nup biya tual, ale noko nup kualala biya patawuralko! ");
INSERT INTO wsk_vpl VALUES ("PS66_3","020_66_3","PSA","66","3","3","Ale Kaem maonal, “Mel suen la ni betesam mu am duap bo nunguningkiri! Nika sokel aromemek owore te se, kariimet memek ni ko ko ninguru kuruga namasan. ");
INSERT INTO wsk_vpl VALUES ("PS66_4","020_66_4","PSA","66","4","4","Ali lilim la nubugura kulukuru kisisan; ale wur te nip biya patawusan.” ");
INSERT INTO wsk_vpl VALUES ("PS66_5","020_66_5","PSA","66","5","5","Tairal ale Kaem kiwem bibiya beteram ewere arigalko; nu kariimet nunga sangukko mel duap duap beteram! ");
INSERT INTO wsk_vpl VALUES ("PS66_6","020_66_6","PSA","66","6","6","Nu gagi kuring kauram se kariimet te aolak iluman kasu kapaman; buta se tairal se nup patawunakko! ");
INSERT INTO wsk_vpl VALUES ("PS66_7","020_66_7","PSA","66","7","7","Nu ko sokel biya mu te ali lilim bitarso; nu kariimet suen la ninguru nungarki kutuwuwoso; buta se kariimet bo nu ilak me barimarukko! ");
INSERT INTO wsk_vpl VALUES ("PS66_8","020_66_8","PSA","66","8","8","O kariimet, anananga Kaem nup patawuralko; nigiring paogal ale sail te nup patawuralko! ");
INSERT INTO wsk_vpl VALUES ("PS66_9","020_66_9","PSA","66","9","9","Nu ikup ningi nanga sangaru tam se ana ikup mu te me dagulaman. ");
INSERT INTO wsk_vpl VALUES ("PS66_10","020_66_10","PSA","66","10","10","O Kaem, ni ana billy-can kaetam yugur gawa te iri lagara se nama nikim kapara iwita nanga irirem. ");
INSERT INTO wsk_vpl VALUES ("PS66_11","020_66_11","PSA","66","11","11","Ni nanga iki se wore nanga beterem se dungan ura ningi namaman, ale nabiwinang te mel ikup ikup gikasan. ");
INSERT INTO wsk_vpl VALUES ("PS66_12","020_66_12","PSA","66","12","12","Ale nanga bitua kari nungarkiwerem se mel yam ko nanga bitakasan; ni ana tama ningi, se yu lom biya ningi iwita nanga beterem se aolak iluman, bare aitak ni nangarak sor mel suen la terong la karogo mu te nangarak tairem. ");
INSERT INTO wsk_vpl VALUES ("PS66_13","020_66_13","PSA","66","13","13","Buta se ani aga den kerak kalem mu karo tuek ale ka temple ningi tairik ale tama bita kisekko; ");
INSERT INTO wsk_vpl VALUES ("PS66_14","020_66_14","PSA","66","14","14","ani ikup ningi baga se den umu kerak kalem. ");
INSERT INTO wsk_vpl VALUES ("PS66_15","020_66_15","PSA","66","15","15","Ani sipsip mel nungumik titiyam mu ago tairik ale tama bita kisekko; sipsip anumang se, bull se, goat karogo tai tama bita kisekko. ");
INSERT INTO wsk_vpl VALUES ("PS66_16","020_66_16","PSA","66","16","16","O kariimet, nina Kaem kuring bowa ningi bagasan mu, tairal se nu kiwem aningate beteram mu balik se ikialko! ");
INSERT INTO wsk_vpl VALUES ("PS66_17","020_66_17","PSA","66","17","17","Ani nup patawu se nu aga sangukko niarem, ale aga memek me kaluwurem. ");
INSERT INTO wsk_vpl VALUES ("PS66_18","020_66_18","PSA","66","18","18","Bare ani aga memek angamang motam ningi kaluwurem le mu, nu me aga saongam le. ");
INSERT INTO wsk_vpl VALUES ("PS66_19","020_66_19","PSA","66","19","19","Bare nu nunguningta aninga niara ikiam ale agiring iluwam. ");
INSERT INTO wsk_vpl VALUES ("PS66_20","020_66_20","PSA","66","20","20","Se ana Kaem nup biya patawunakko! Mu awuk, nu gomang motam kaolam ale aninga niara me buring tuam. ");
INSERT INTO wsk_vpl VALUES ("PS67_1","020_67_1","PSA","67","1","1","O nanga Kaem, nika gemang lila se ka marak nangaruko; gemang nangaru ale ka nikim yawara nangaruko. ");
INSERT INTO wsk_vpl VALUES ("PS67_2","020_67_2","PSA","67","2","2","Mu te ali lilim ko kariimet nika munan se ka sangaru ta ko sokel mu ko ikimonko. ");
INSERT INTO wsk_vpl VALUES ("PS67_3","020_67_3","PSA","67","3","3","O Kaem, aninga angamang kariimet suen la ni ko ko amilmilamon ale nip patawumonko! ");
INSERT INTO wsk_vpl VALUES ("PS67_4","020_67_4","PSA","67","4","4","Nuna amilmil kelagamon ale wur ilu se nip patawumonko, mu awuk, ni munan diram te la kariimet nunga bitarsam, ale ikia ningo te la ali sor suen biya nunga kiti gurugusam. ");
INSERT INTO wsk_vpl VALUES ("PS67_5","020_67_5","PSA","67","5","5","O Kaem, aninga angamang kariimet suen la ni ko ko amilmilamon ale nip patawumonko! ");
INSERT INTO wsk_vpl VALUES ("PS67_6","020_67_6","PSA","67","6","6","Se ali imi te na inang sor magarukko, Kaem, anananga Kaem, mu nu marak nangarukko. ");
INSERT INTO wsk_vpl VALUES ("PS67_7","020_67_7","PSA","67","7","7","Nunguningta Kaem gomang nangarukko, se ali dun sika te nama dun sika te, nu bowa ningi la bagamonko. ");
INSERT INTO wsk_vpl VALUES ("PS68_1","020_68_1","PSA","68","1","1","(David ko wur) O Kaem, ni bares ale kariimet ni me ka kuesan ale ni kerak barimawasan mu nunga moa parusuwur se nunumi tagimon ale nagumonko. ");
INSERT INTO wsk_vpl VALUES ("PS68_2","020_68_2","PSA","68","2","2","Tama bur marir karogo nama menaso iwita, ni nunga karo parusuwurko; agi buruk ko welang pakongoso se karuwusan se palenga nama menaso iwita, kariimet memek mu ni kema te mena namamonko. ");
INSERT INTO wsk_vpl VALUES ("PS68_3","020_68_3","PSA","68","3","3","Bare kariimet ningo diram mu nongomang kua kaparuk se Kaem koma te amilmilamonko; nuna ninguru amilmilamonko. ");
INSERT INTO wsk_vpl VALUES ("PS68_4","020_68_4","PSA","68","4","4","Ana Kaem ko nup patawura ko wur ilunak ale nup patawunakko. Nup patawuralko. Nu taiti nuwi awote daiga ale namara ko Kaem. Nu koma te amilmilaralko. Noko nup mu Yawe. ");
INSERT INTO wsk_vpl VALUES ("PS68_5","020_68_5","PSA","68","5","5","Kaem nu ko kuwim laili te bagoso, ale kuriang nonet nunam kuera mu nunga bitarso, ale imet nugari kuera mu nunga sinar taso. ");
INSERT INTO wsk_vpl VALUES ("PS68_6","020_68_6","PSA","68","6","6","Nu kariimet nungumik gue suan mena mu nunga sangarso se launuria gue suan gema gilingisan. Se kariimet talipara ningi mu nunga giso ale amilmil nungarso. Bare nusupuling lagara ko kariimet mu sor garagara kiriyam memek mu ningi baga gilingisan. ");
INSERT INTO wsk_vpl VALUES ("PS68_7","020_68_7","PSA","68","7","7","O Kaem, ni girakala nika kariimet nunga giem, ale ni girem ale sor maraka merang mu te nongorak aolak iluwem. ");
INSERT INTO wsk_vpl VALUES ("PS68_8","020_68_8","PSA","68","8","8","Tom mu te ni tairem mu tuwik biya kaparam ale wanara biya tala kaparam se ali yukuam, mu awuk, ni duruk Sinai ko Kaem, se Israel ko Kaem. ");
INSERT INTO wsk_vpl VALUES ("PS68_9","020_68_9","PSA","68","9","9","Ni tuwik biya beterem se kaparam se nika kariimet yu nungarem, ale nika ali magaram mu aking na yu welang tuem. ");
INSERT INTO wsk_vpl VALUES ("PS68_10","020_68_10","PSA","68","10","10","Nika kariimet ali mu te kuwim taman ale dagiman; se nika gemang motam ningo mu te kariimet nungumik mel mena mu nunga bituem. ");
INSERT INTO wsk_vpl VALUES ("PS68_11","020_68_11","PSA","68","11","11","Kari Biya den bo balu paogam, se imet motam biya giman karogo nama iwita balman: ");
INSERT INTO wsk_vpl VALUES ("PS68_12","020_68_12","PSA","68","12","12","“King arika nunga kager kari memek mu nongorak melmasak warman ale nagu sapaman o! Se Israel kari gi karogo nama nunga sasal kawam ningi imet nungarman, se gi parusuwu nunumi tuman o! ");
INSERT INTO wsk_vpl VALUES ("PS68_13","020_68_13","PSA","68","13","13","Bare nina kari am baga se sipsip por ningi mu nunga bitaruwaman mu karogotala kowo! Inangnang dora, luman silver te nunga se mone gold te nunga, se mel ningo ningo mu gialko.” ");
INSERT INTO wsk_vpl VALUES ("PS68_14","020_68_14","PSA","68","14","14","Nunguningta, Kaem Sokel Garagar king alo mu nunga moram parusuwuram se parasaman, ale taiti nuwi duruk Zalmon ira kaluwuso iwitata sor ereman. ");
INSERT INTO wsk_vpl VALUES ("PS68_15","020_68_15","PSA","68","15","15","O Duruk Bashan, ni duruk sokel garagar, nika motongar se kuamuru kuting suen biya, ");
INSERT INTO wsk_vpl VALUES ("PS68_16","020_68_16","PSA","68","16","16","ni anape ko duruk Zion, Kaem te daigok ale pempem te bagarukko atumukiram, wore ko gemang maga lagoso? Yawe kota umu te tom suen biya baga se lagarukko balam. ");
INSERT INTO wsk_vpl VALUES ("PS68_17","020_68_17","PSA","68","17","17","Ikiko! Kaem ko kager ko mel aora aora suen biya nunguningkiri, am kaura koma mena. Kari Biya laili nunguningkiri Duruk Sinai beteram ale tai ko kuwim laili umu te bagoso. ");
INSERT INTO wsk_vpl VALUES ("PS68_18","020_68_18","PSA","68","18","18","O Yawe, ni talipara kari suen biya nunga giem, ale nongorak nup biya taukko nama tarigirem; se kariimet munan ago tai kisukasan; nusupuling lagara ko kariimet alo mu agotala munan ago tai kisukasan. Se nunguningta nunguningkiri, ni Kaem Yawe ka kuwim laili umu te bagasam. ");
INSERT INTO wsk_vpl VALUES ("PS68_19","020_68_19","PSA","68","19","19","Ana Kari Biya nup patawunakko, nu kota suanta anananga Bataguru Tata ko Kaem; nu tom pempem la anananga ikup giso. ");
INSERT INTO wsk_vpl VALUES ("PS68_20","020_68_20","PSA","68","20","20","Nu Yawe, anananga Sangaru Tata ko Kaem, kuera mateng ko lage memek te nanga bataguru taso. ");
INSERT INTO wsk_vpl VALUES ("PS68_21","020_68_21","PSA","68","21","21","Nunguningta, Kaem kager kari memek nunga nusupuling ita pakakumurokko; mu awuk, nuna kiwem memek pempem bita lagasan. ");
INSERT INTO wsk_vpl VALUES ("PS68_22","020_68_22","PSA","68","22","22","Kari Biya iwita balam, “Ani Duruk Bashan ko kager kari memek mu nongorak tai kaparikko; ale kager kari gagi du biya nukum te bagamon ta wore nongorak tai bausekko; ");
INSERT INTO wsk_vpl VALUES ("PS68_23","020_68_23","PSA","68","23","23","asele nina mu nunga maguwural ale nunga gue awote aolak iluwalko; se ninga kausik mu nunga gue namonko.” ");
INSERT INTO wsk_vpl VALUES ("PS68_24","020_68_24","PSA","68","24","24","O Kaem, aninga King, ani kariimet mugum karogo numi kowom kaoram ale nika nip biya patawumonko nika temple ningi kapawasan owore nungarkiwasam. ");
INSERT INTO wsk_vpl VALUES ("PS68_25","020_68_25","PSA","68","25","25","Wur iluwa ko kariimet mu giriman se bawe mora ko kariimet mu nubiring ko; se galawalang sokelel sisuwura ko kuriang itiwik mu kusumuri aolak iluwasan. ");
INSERT INTO wsk_vpl VALUES ("PS68_26","020_68_26","PSA","68","26","26","Nuna aisan ale balsan, “Kaem ko kariimet biya, ko nup patawuralko! Nina Israel ko kariimet, nina Yawe ko nup patawuralko!” ");
INSERT INTO wsk_vpl VALUES ("PS68_27","020_68_27","PSA","68","27","27","Benjamin, kari mom kopa, mu ko gue mu giriman; se Judah ko kari supuling bibiya mu Benjamin ko mu nogowom karowasan; asele Zebulun se Naphtali ko kari supuling bibiya mu atumukira taiwasan. ");
INSERT INTO wsk_vpl VALUES ("PS68_28","020_68_28","PSA","68","28","28","O Kaem, nika sokel aora garagar mu wetang saparko; nika sokel girakala nanga kausem iwitata, aking nanga kasuruko. ");
INSERT INTO wsk_vpl VALUES ("PS68_29","020_68_29","PSA","68","29","29","Nika temple mu Jerusalem aniso, buta se king suen biya nunga munan karogo tai kisimonko. ");
INSERT INTO wsk_vpl VALUES ("PS68_30","020_68_30","PSA","68","30","30","Egypt mu mel diwang memek aora bo yu lom ningi bagoso wore iwita; se deleng te irako. Sor saki mu nu bowa ningi buffalo diwang bibiya iwita bagasan, se sor saki gotektek mu buffalo gotektek iwitatala bagasan, mu ni suen la nunga nosokel menawurko. Se mel diwang mu silver mel karogo tai kisokko; se sor saki gotektek kager ko la kuesan mu nunga karo parusuwur se nagu parasamonko. ");
INSERT INTO wsk_vpl VALUES ("PS68_31","020_68_31","PSA","68","31","31","Sor Egypt mu barowara karu karu nunga mel ningo ningo bronze te nunga mu karogo tai kisimonko; Ethiopia kariimet mu nguanga nguanga nuguting karogo tai kisimonko. ");
INSERT INTO wsk_vpl VALUES ("PS68_32","020_68_32","PSA","68","32","32","Nina ali sor suen la ko kariimet, Kaem ko wur iluwalko; Kari Biya ko nup patawura ko wur iluwalko. ");
INSERT INTO wsk_vpl VALUES ("PS68_33","020_68_33","PSA","68","33","33","Ikialko. Kaem sokel karogo mu pure nia kam aiso, nu taiti girakala la nungam se aniso wore te aolak iluso. ");
INSERT INTO wsk_vpl VALUES ("PS68_34","020_68_34","PSA","68","34","34","Nina Kaem ko sokel aora biya owore ko balu paogalko; nu Israel ko king nikim garagar, se ko sokel biya mu ana taiti gomang te arigisan. ");
INSERT INTO wsk_vpl VALUES ("PS68_35","020_68_35","PSA","68","35","35","O Kaem, ni am duap bo nunguningkiri, nika laili kuwim te bagasam. Ni ana Israel nanga Kaem, se ni sokel ana nangarsam. Ana Kaem ko nup patawunakko! ");
INSERT INTO wsk_vpl VALUES ("PS69_1","020_69_1","PSA","69","1","1","(David ko wur) O Kaem, aga sangaruko, yu bausam adogotak te se sarenga namarikko tom pingi aram! ");
INSERT INTO wsk_vpl VALUES ("PS69_2","020_69_2","PSA","69","2","2","Ani yu lom biya ningi kaperem ale sanamarikko me terong; yu lom biya aga ira kaluwurokko tom pingi aram. ");
INSERT INTO wsk_vpl VALUES ("PS69_3","020_69_3","PSA","69","3","3","Ani ai nia lagerem ale angimik sail menaram ale adogotak maraka saparam. Ni aninga Kaem se ni aga sangaruko amotam bita lagasam, bare yam mena biya. ");
INSERT INTO wsk_vpl VALUES ("PS69_4","020_69_4","PSA","69","4","4","Kari ani agarak memek betesan, mu yam kumik duap bo mena biya; nuna suen biya, amone asupuling te mu ko tom kiaram; nuna suen biya se den kawel ago ko balsan ale aga momon se kuerikko ago kaesan. Ani nunga mel bo me tere naem, bare den ipi atumu aisiman, se ani agata aga mel mu koma ko nungarem. ");
INSERT INTO wsk_vpl VALUES ("PS69_5","020_69_5","PSA","69","5","5","O Kaem, ni aninga memek mu ari saperem; aninga paguwura mu ni ko iki saperem. ");
INSERT INTO wsk_vpl VALUES ("PS69_6","020_69_6","PSA","69","6","6","O Kari Biya, ni Yawe Sokel Garagar, yam agarkiwer se ani dagulek se nika kariimet ningo me nongomang ikuwurokko; nuna ni ko ko nongomang pempem niawoso se me dolomonko, O Israel ko Kaem. ");
INSERT INTO wsk_vpl VALUES ("PS69_7","020_69_7","PSA","69","7","7","Ani ni la karo kisisam, buta se ani agarki maguwu gilingisan, se ani dolara ninguru aga iramuram. ");
INSERT INTO wsk_vpl VALUES ("PS69_8","020_69_8","PSA","69","8","8","Aninga gue suan se aga launuria alo mu ani nononga bo iwita me agarkasan; ");
INSERT INTO wsk_vpl VALUES ("PS69_9","020_69_9","PSA","69","9","9","mu awuk, aninga angamang motam mu nika temple ko tawun biya kueso ale tama iwita kani lagoso, kariimet nika balu maguwusan mu ani agotala aga balu maguwusan. ");
INSERT INTO wsk_vpl VALUES ("PS69_10","020_69_10","PSA","69","10","10","Tom ani aimi karogo kapasam ale inang kaola ko munan karosam mu kariimet aga balu maguwusan. ");
INSERT INTO wsk_vpl VALUES ("PS69_11","020_69_11","PSA","69","11","11","Ani angamang batagoso se aimi karur tugusam ale amone guari pagoso, mu nuna aninga gusirsan. ");
INSERT INTO wsk_vpl VALUES ("PS69_12","020_69_12","PSA","69","12","12","Kariimet lage te ilu biguwusan ale aninga ko munakasan, se yu aora nana ale ngualara ko kari mu wur memek ani ago ko ilusan. ");
INSERT INTO wsk_vpl VALUES ("PS69_13","020_69_13","PSA","69","13","13","Bare O Yawe, aninga guranek nikate betesam. Ni ani ago ko ninguru kuesam, ale tom ni keta ko ikiwasam mu te aninga guranek koma aisuko; ni aga sangaru toko den kalo beterem mu te aga sangaru toko. ");
INSERT INTO wsk_vpl VALUES ("PS69_14","020_69_14","PSA","69","14","14","Ni aninga tagi bataguru to se ani lom gege ningi me sarenga namarikko; ni aninga bitaru se kager kari memek me aga maguwumonko. ");
INSERT INTO wsk_vpl VALUES ("PS69_15","020_69_15","PSA","69","15","15","Ni aga sangaru se lom me aga tagirokko; ni aga sangaru se yu du biya ningi me sarengik, ale mutim ningi me kua namarikko. ");
INSERT INTO wsk_vpl VALUES ("PS69_16","020_69_16","PSA","69","16","16","O Yawe, agiring ilupko, nika kua aisa biya mu ko ningo te aga sangaruko; nika gemang lila ningo mu te kema gurugu aisuko. ");
INSERT INTO wsk_vpl VALUES ("PS69_17","020_69_17","PSA","69","17","17","Biring gurugu nika ura kari me tuiko; ani ikup biya ningi kaperem se ni tairate tai aga sangaruko. ");
INSERT INTO wsk_vpl VALUES ("PS69_18","020_69_18","PSA","69","18","18","Ni aninga te tairate tair ale aga sangaruko; kager kari memek nuguting te aga bataguru toko. ");
INSERT INTO wsk_vpl VALUES ("PS69_19","020_69_19","PSA","69","19","19","Kari aninga balu maguwusan mu ni maingkala nunga iki saperem; aninga aip karogo kapasan ale dolara aisisan mu ni nunga ikiem. ");
INSERT INTO wsk_vpl VALUES ("PS69_20","020_69_20","PSA","69","20","20","Bala se ikia suen la beteman mu aninga angamang motam batogam se aga sokel menaram; ani kariimet bo aga sanguk ale den ningo aisuokko i maem, bare mena. ");
INSERT INTO wsk_vpl VALUES ("PS69_21","020_69_21","PSA","69","21","21","Nuna inang memek wore naikko aisiman; ale yu ko kuerem mu, yu memek mu aisiman. ");
INSERT INTO wsk_vpl VALUES ("PS69_22","020_69_22","PSA","69","22","22","Aninga angamang mu, nunga amilmil inang bibiya ko tom mu geraguk ale nononga tom memek iwita nunga taliparuk se dagulamonko. ");
INSERT INTO wsk_vpl VALUES ("PS69_23","020_69_23","PSA","69","23","23","Ni nunga nomotam tirom awur se sor me arigimonko; nunga nosokel menawur se ikup gimon ale tara tara la lagamonko. ");
INSERT INTO wsk_vpl VALUES ("PS69_24","020_69_24","PSA","69","24","24","Nika gemang memek nungumik kuali bitarko; se nika gemang magara mu nunga maguwurok se mena namamonko. ");
INSERT INTO wsk_vpl VALUES ("PS69_25","020_69_25","PSA","69","25","25","Se nunga kawam digo mu kariimet bo me ta ningi bagarukko; nunga wonong tuagu mu sirsir pagukko. ");
INSERT INTO wsk_vpl VALUES ("PS69_26","020_69_26","PSA","69","26","26","Mu awuk, kariimet saki nunga memek koma nungarem mu agotala nunga bita maguwusan; ni yaman nungarem se lot gawir giman mu nunga den siaman balsan ale ikup nungarsan. ");
INSERT INTO wsk_vpl VALUES ("PS69_27","020_69_27","PSA","69","27","27","Ni nunga memek koma ikup ko ikup nungaruko; ale nunga bitar se nika kariimet ningo nunga por ningi me utu kapamonko. ");
INSERT INTO wsk_vpl VALUES ("PS69_28","020_69_28","PSA","69","28","28","Nunga nunup marak ningo pempem bagara ko batoga ningi mu siwu saparko; ale nunga nunup mu kariimet diram ningo nunga nunup karogo me bitarko. ");
INSERT INTO wsk_vpl VALUES ("PS69_29","020_69_29","PSA","69","29","29","Bare O Kaem, ani ikup yaman tawun biya giem; ni aninga bataguru to ale aga bitaruko. ");
INSERT INTO wsk_vpl VALUES ("PS69_30","020_69_30","PSA","69","30","30","Ani Kaem ko wur iluwek ale nup patawurikko; ani amilmil te ko nup biya mu ko balikko. ");
INSERT INTO wsk_vpl VALUES ("PS69_31","020_69_31","PSA","69","31","31","Ani uwutata bitirik mu Yawe aninga wur te nup patawura ko munan mu ko amilmilarukko; nu tama bita tuata ko munan mu tawun biya me ko kueso. ");
INSERT INTO wsk_vpl VALUES ("PS69_32","020_69_32","PSA","69","32","32","Se kariimet ikup giwasan mu arigimon ale amilmilamonko; Kaem nongomang tua ko kariimet mu aking sokel iru tamonko. ");
INSERT INTO wsk_vpl VALUES ("PS69_33","020_69_33","PSA","69","33","33","Mu awuk, Yawe kariimet nungumik mel mena mu nunga wosenga ikiso, ale ko kariimet talipara ningi mu me nunga kuamili saposo. ");
INSERT INTO wsk_vpl VALUES ("PS69_34","020_69_34","PSA","69","34","34","O taiti gomang se ali lilim, Kaem nup patawuralko; gagi suen la se mel suen la gagi ningi mu betelatala; ");
INSERT INTO wsk_vpl VALUES ("PS69_35","020_69_35","PSA","69","35","35","mu awuk, nu Zion sanguk ale akingtala Judah wonong kuwim kuwim te kalokko. Noko kariimet umu te dagimon ale ali umu aking tamonko; ");
INSERT INTO wsk_vpl VALUES ("PS69_36","020_69_36","PSA","69","36","36","nunga kuriang imas se arikaya nu kua tusan mu eng am umu te bagamonko. ");
INSERT INTO wsk_vpl VALUES ("PS70_1","020_70_1","PSA","70","1","1","(David ko wur) O Kaem, ni aninga sangaruko; O Yawe, pasak ala tair ale aga sangaruko. ");
INSERT INTO wsk_vpl VALUES ("PS70_2","020_70_2","PSA","70","2","2","Se kariimet aninga momonko negawasan mu dolomon ale parasa namamonko; ale nuna ani memek te namarikko nongomang aniso mu pelemon ale magi magi namamonko. ");
INSERT INTO wsk_vpl VALUES ("PS70_3","020_70_3","PSA","70","3","3","Ale awiriya aninga gusirsan mu nunga dolara nunga iramurokko. ");
INSERT INTO wsk_vpl VALUES ("PS70_4","020_70_4","PSA","70","4","4","Bare kariimet nika kua lagasan mu nonoman nungeruk se ni ko ko amilmilamonko; kariimet ni nunga sangaruko nomotam bita lagasan mu pempem balmon, “Yawe mu ningo!” ma balmonko. ");
INSERT INTO wsk_vpl VALUES ("PS70_5","020_70_5","PSA","70","5","5","Bare ani kituwura, asokel mena; buta se O Kaem, tairate tair ale aga bataguru toko. O Yawe, ni aninga saonga se aga bataguru ta ko kari; ni pasak ala tair ale aga sangaruko. ");
INSERT INTO wsk_vpl VALUES ("PS71_1","020_71_1","PSA","71","1","1","O Yawe, ani ni kete taisam, aga bitaru se dolara me aga irokko. ");
INSERT INTO wsk_vpl VALUES ("PS71_2","020_71_2","PSA","71","2","2","Agiring iki ale nika kiwem ningo diram mu te aga sangaru ale aga bataguru toko. ");
INSERT INTO wsk_vpl VALUES ("PS71_3","020_71_3","PSA","71","3","3","Ni pempem aninga manga aora bager se ani te nagu nama yumurekko; ni la balu se ani terong la bagarikko, mu awuk, ni aninga manga gek am se aninga yumura kuwim. ");
INSERT INTO wsk_vpl VALUES ("PS71_4","020_71_4","PSA","71","4","4","O aga Kaem, kari memek nuguting te aga bataguru toko; kari memek kiwem memek bitawara mu me aga kau tamonko. ");
INSERT INTO wsk_vpl VALUES ("PS71_5","020_71_5","PSA","71","5","5","O Yawe, aninga kulak te la, ni keta suanta kete aga loagara bita lagasam. ");
INSERT INTO wsk_vpl VALUES ("PS71_6","020_71_6","PSA","71","6","6","Ni aga ayam tuagu te aga bituem se tom ani bilangerem mu ani nikate la ira sanami lagasam. Ani nika nip pempem la patawu se lagarikko. ");
INSERT INTO wsk_vpl VALUES ("PS71_7","020_71_7","PSA","71","7","7","Kariimet suen biya ani mel memek bo iwita agarkasan, bare ni mu aninga bitua kari aora. ");
INSERT INTO wsk_vpl VALUES ("PS71_8","020_71_8","PSA","71","8","8","Ani pempem nika nip patawusam ale nika nikim sokel garagar mu ko balsam. ");
INSERT INTO wsk_vpl VALUES ("PS71_9","020_71_9","PSA","71","9","9","Tom ani garukarik ale asokel kaparuk mu ni me agarki daleluwur ale due ko me aga sarumu bitarko. ");
INSERT INTO wsk_vpl VALUES ("PS71_10","020_71_10","PSA","71","10","10","Mu awuk, kari memek aninga balu maguwusan; ale ilu biguwusan ale aga momon se kuerikko balsan. ");
INSERT INTO wsk_vpl VALUES ("PS71_11","020_71_11","PSA","71","11","11","Ale “Kaem me sangukkowo!” masan. “Iluwal ale taliparalko; kariimet bo nu me sangukko.” ");
INSERT INTO wsk_vpl VALUES ("PS71_12","020_71_12","PSA","71","12","12","O aga Kaem, aga bitar ale awar biya me bagerko; tairate tair ale aga sangaruko. ");
INSERT INTO wsk_vpl VALUES ("PS71_13","020_71_13","PSA","71","13","13","Kari den te aga atumusan mu dolara memek te nunga menawurko; kari aninga bita maguwumonko bagasan mu memek biya te nunga bitar se dolomonko. ");
INSERT INTO wsk_vpl VALUES ("PS71_14","020_71_14","PSA","71","14","14","Bare aninga loagara mu pempem la nikate bita se, ka nip butata patawu se lagarikko. ");
INSERT INTO wsk_vpl VALUES ("PS71_15","020_71_15","PSA","71","15","15","Ani nika munan ningo diram te nanga sangaru tasam mu ko iki saparikko me terong, bare tirom woremkalal ko balu se lagarikko. ");
INSERT INTO wsk_vpl VALUES ("PS71_16","020_71_16","PSA","71","16","16","O Kaem Yawe, ani nika kiwem bibiya mu ko balikko; ani ni keta suanta ka munan ningo diram mu ko balu pagikko. ");
INSERT INTO wsk_vpl VALUES ("PS71_17","020_71_17","PSA","71","17","17","O Kaem, ani kuriang kulak la ni ka munan ningo ningo mu aga kausem, se tai aitak mu ani am ko baluwasam. ");
INSERT INTO wsk_vpl VALUES ("PS71_18","020_71_18","PSA","71","18","18","Se tom ani garukarik ale amone yak mauk mu ni me ta biring gurugu aisuko; O Kaem, aga sangaru se nika sokel aora garagar mu ko balik se kuriang gue luan udagi taiwasan mu ikimonko. ");
INSERT INTO wsk_vpl VALUES ("PS71_19","020_71_19","PSA","71","19","19","O Kaem, awiri nika iwita? Mena. Nigita ni munan bibiya beterem; nika kiwem ningo diram mu taiti gomang ningi kalel biya. ");
INSERT INTO wsk_vpl VALUES ("PS71_20","020_71_20","PSA","71","20","20","Ni ikiwerem se ani ikup yaman suen biya giem; ani mutim du biya ningi iwita kaperem, bare ani ikisam ni akingtala sokel iru aisu ale aga patawur se bausekko. ");
INSERT INTO wsk_vpl VALUES ("PS71_21","020_71_21","PSA","71","21","21","Ni aninga aip kaparam mu aking patawur ale angamang motam sokel tuiko. ");
INSERT INTO wsk_vpl VALUES ("PS71_22","020_71_22","PSA","71","22","22","O aga Kaem, Israel ko Kaem Laili, ani nika munan diram la ago ko betera mu ko gita morik ale nip patawurikko. ");
INSERT INTO wsk_vpl VALUES ("PS71_23","020_71_23","PSA","71","23","23","Ni aninga sangaru taem, se ani amilmil te airik ale wur te nip patawurikko. ");
INSERT INTO wsk_vpl VALUES ("PS71_24","020_71_24","PSA","71","24","24","Kariimet aninga maguwumonko mu ni nosokel menawurem se dolara biya taman; se tirom woremkalal ani nika kiwem ningo diram mu ko balu se lagarikko. ");
INSERT INTO wsk_vpl VALUES ("PS72_1","020_72_1","PSA","72","1","1","(Solomon ko wur) O Kaem, nika kiwem ningo diram wore king kasuru se, nu te kariimet nunga ikup ko ninguru iki se nungokko. Ni mu ikup guyak ninguru nunga ko Kaem, se ni king sangaruko. ");
INSERT INTO wsk_vpl VALUES ("PS72_2","020_72_2","PSA","72","2","2","Se nu munan ningo diram mu te nika kariimet nunga gi se, aking kariimet nungumik mel mena mu ninguru tala nunga bituokko. ");
INSERT INTO wsk_vpl VALUES ("PS72_3","020_72_3","PSA","72","3","3","Se nika munan ningo diram se bagara ningo bitar se duruk bibiya se ali lilim la awote kaparukko, se kariimet te ningo bagamonko. ");
INSERT INTO wsk_vpl VALUES ("PS72_4","020_72_4","PSA","72","4","4","Se king mu kariimet nungumik mel mena mu nubiring ko sanamaruk ale, kariimet nungumik wonong kawam mena mu nunga gi nu bowa nunga tugumok, ale awiriya kariimet kituwura uwuta mu nunga bita maguwuwasan, mu nu koma ko nunga maguwurokko. ");
INSERT INTO wsk_vpl VALUES ("PS72_5","020_72_5","PSA","72","5","5","Se worem sige pempem nikim kapawasan iwita, kariimet ni ko ko nguanga se bowa ningi nip patawu se lagamonko. ");
INSERT INTO wsk_vpl VALUES ("PS72_6","020_72_6","PSA","72","6","6","Tuwik ningo daguloso ale ningam yu tuso se inang yawarakala aragoso iwitatala, king umu uwutata baga se lagarukko. ");
INSERT INTO wsk_vpl VALUES ("PS72_7","020_72_7","PSA","72","7","7","Tom nu king bagoso mu te mu kiwem ningo diram mu pempem la anirukko; sige nikinang kapa lagoso iwitatala, bagara ningo mu pempem la anirukko. ");
INSERT INTO wsk_vpl VALUES ("PS72_8","020_72_8","PSA","72","8","8","Noko kuting mu maiya biya, gagi dun sang te se nama gagi dun sang te; se ko bitua ningo mu yu Euphrates te se nama ali lilim ko komasang te. ");
INSERT INTO wsk_vpl VALUES ("PS72_9","020_72_9","PSA","72","9","9","Se sor garagarayam te bagara ko kariimet suen la nu bowa ningi bagamonko; kager kari nu ilak memek mu ko suwik duap ningi dagulomon ale kupkup namonko. ");
INSERT INTO wsk_vpl VALUES ("PS72_10","020_72_10","PSA","72","10","10","Se sor Tarshish ko king se tual gotektek sang ko mu manga mel ningo ningo karogo tai tumonko. Sor Sheba se sor Seba ko king mu mel ningo ningo karogo tai tumonko. ");
INSERT INTO wsk_vpl VALUES ("PS72_11","020_72_11","PSA","72","11","11","Se king suen la nu koma te nubugura kulukurmon se kariimet sor suen la mu nu bowa ningi la bagamonko. ");
INSERT INTO wsk_vpl VALUES ("PS72_12","020_72_12","PSA","72","12","12","Mu awuk, kariimet nungumik mel mena mu nu arumon, mu nu nunga nuguring iluwokko; se kariimet mel ko tukunangawasan bare nungumik saonga mena, mu nu kota nunga sangukko. ");
INSERT INTO wsk_vpl VALUES ("PS72_13","020_72_13","PSA","72","13","13","Kariimet nungumik nosokel mena, se mel mena bagasan, mu gomang motam nungarukko; se kariimet nungumik mel mena bagasan, mu nunga giok ale nunga sangukko. ");
INSERT INTO wsk_vpl VALUES ("PS72_14","020_72_14","PSA","72","14","14","Se kariimet saki nunga mosan maguwusan, mu nu nunga giok ale nunga sanguk ale ninguru nunga kuerukko. ");
INSERT INTO wsk_vpl VALUES ("PS72_15","020_72_15","PSA","72","15","15","King mu pempem la baga lagarukkowo! Sor Sheba ko gold mu nu tumonko! Se kariimet nu ko ko Kaem aru ngatangarmon, ale balmon, “Kaem ko marak sokel pempem kumik kuali kapa lagarukko,” ma balmonko. ");
INSERT INTO wsk_vpl VALUES ("PS72_16","020_72_16","PSA","72","16","16","Ali lilim la na inang sor magaruk, ale duruk luan mu inang muguri rice iwita mu karogo terong maukko; se ko tam muguri yaman nuam mu Lebanon ko tam muguri iwita nunguning kapamonko; se ko kariimet wonong bibiya ningi mu gue paguk ale sor suen biya te sirsir pauk maso iwita sor ira sapamonko. ");
INSERT INTO wsk_vpl VALUES ("PS72_17","020_72_17","PSA","72","17","17","Se kariimet noko nup biya mu ko nungamili me ta saparukko, se noko kiwem ningo mu worem kani lagoso iwita, kani se lagarukko. Nu te ali sor suen la marak ningo tamon, ale noko nup patawu se lagamonko. ");
INSERT INTO wsk_vpl VALUES ("PS72_18","020_72_18","PSA","72","18","18","Yawe, Israel ko Kaem, ko nup biya patawunakko! Yam nu kota kiwem bibiya beteso se arataso. ");
INSERT INTO wsk_vpl VALUES ("PS72_19","020_72_19","PSA","72","19","19","Pempem noko nup biya patawunakko! Noko nup biya nikim garagar mu ali sor suen la ari ikimonko! Nunguningta! Nunguningkiri! ");
INSERT INTO wsk_vpl VALUES ("PS72_20","020_72_20","PSA","72","20","20","Se David, Jesse ko namar mu ko aira mu tai iwitata menaram. ");
INSERT INTO wsk_vpl VALUES ("PS73_1","020_73_1","PSA","73","1","1","(Asaph wur imi batogam) Kaem mu Israel arungu yawarakala beteso; nu awiriya nongomang motam ningo diram mu ningo nuam nongote beteso. ");
INSERT INTO wsk_vpl VALUES ("PS73_2","020_73_2","PSA","73","2","2","Bare ani mu, sanami turutuwuwakasam; ani mu ali palenguk se dagulu namarikko iwita. ");
INSERT INTO wsk_vpl VALUES ("PS73_3","020_73_3","PSA","73","3","3","Ko duap mu, ani nunumi patawura ko kariimet mu nungarkikasam ale nunga angamang magakaso, mu awuk, nuna memek bita se wore nunga daiga bagara mu am yawarakala. ");
INSERT INTO wsk_vpl VALUES ("PS73_4","020_73_4","PSA","73","4","4","Nuna ikup mena, ningo la bagasan; ale nungumik kuera ikes mena se sokel ago la bagasan. ");
INSERT INTO wsk_vpl VALUES ("PS73_5","020_73_5","PSA","73","5","5","Nuna kariimet sang ikup giwasan iwita, me ikup giwasan, mena. Nuna sokel ago se ningo la bagasan. ");
INSERT INTO wsk_vpl VALUES ("PS73_6","020_73_6","PSA","73","6","6","Buta se nusupuling lagara ko munan mu kulolo balayam iwita nodogotak tugusan; ale kariimet sang nunga bita maguwura ko kiwem mu guang ningo iwita katasan. ");
INSERT INTO wsk_vpl VALUES ("PS73_7","020_73_7","PSA","73","7","7","Nunga bagara ningo mu ko nomotam welang taiso; se nunumi te patawumonko ikia duap duap nunga moso. ");
INSERT INTO wsk_vpl VALUES ("PS73_8","020_73_8","PSA","73","8","8","Nuna kariimet saki nunga gusirsan ale den memek nungumik ko balsan; nuna nunumi kalel biya betesan ale kariimet saki bala nguangara nungarsan. ");
INSERT INTO wsk_vpl VALUES ("PS73_9","020_73_9","PSA","73","9","9","Nuna duruk wonong te bagakoyam nunumi betesan; ale nunga munak mu ali lilim bitarukoyam munakasan. ");
INSERT INTO wsk_vpl VALUES ("PS73_10","020_73_10","PSA","73","10","10","Se kariimet karo nungarsan; mu nuna anapeya ko balsan mu am nungarsan. ");
INSERT INTO wsk_vpl VALUES ("PS73_11","020_73_11","PSA","73","11","11","Kariimet imitang balsan, “Kaem awuk ta ko ikiokko?” masan. Ale “Kaem Kalel Biya mu ko sinar aruk agi?” masan. ");
INSERT INTO wsk_vpl VALUES ("PS73_12","020_73_12","PSA","73","12","12","Kariimet memek mu nunga kiwem mu uwutata; nuna ikup mena, pempem yawarakala baga se melmasak duap duap gemasan. ");
INSERT INTO wsk_vpl VALUES ("PS73_13","020_73_13","PSA","73","13","13","Se awuk, ani aimi ko sinar taem ale ningo diram la baga lagasam imi ko ningo apoko? Ani memek bo me bita arigem imi ko ningo bo me arigekko agila? ");
INSERT INTO wsk_vpl VALUES ("PS73_14","020_73_14","PSA","73","14","14","Tom suen biya turomola nama bainga ningi ani ikup gi lagasam; ale pempem turomola bu to lagasam. ");
INSERT INTO wsk_vpl VALUES ("PS73_15","020_73_15","PSA","73","15","15","Bare ani uwuta balik, mu ani nika kariimet nunga bo iwita mena. ");
INSERT INTO wsk_vpl VALUES ("PS73_16","020_73_16","PSA","73","16","16","Ani ikia mel suen la imi ninguru ko ikiekko ikia aga moa lagakaso, bare ikup biya nunguning. ");
INSERT INTO wsk_vpl VALUES ("PS73_17","020_73_17","PSA","73","17","17","Bare tom ani nika temple ningi kasu nagu asele aga ikia sinararam, se kariimet memek tom udagi te memek nungumik te aratukko mu ani ko sinarerem. ");
INSERT INTO wsk_vpl VALUES ("PS73_18","020_73_18","PSA","73","18","18","Nunguningta, ni sor palepalengam mu ningi nunga awur se palungurmon ale dagulomon eng am memek tamonkowo! ");
INSERT INTO wsk_vpl VALUES ("PS73_19","020_73_19","PSA","73","19","19","Nuna tairatela memek biya arigimonko; memek bibiya nunga sarumu warukko. ");
INSERT INTO wsk_vpl VALUES ("PS73_20","020_73_20","PSA","73","20","20","O Kari Biya, tom ni barasu sanamir, mu nuna tairate mena namamonko; se nuna mu kari ipingira memek iluso ale turomola kuamili sapa namoso iwitatala, ni nunga kamili saparukko. ");
INSERT INTO wsk_vpl VALUES ("PS73_21","020_73_21","PSA","73","21","21","Tom ani iki maguwukasam se angamang motam dagulukaso, ");
INSERT INTO wsk_vpl VALUES ("PS73_22","020_73_22","PSA","73","22","22","mu ani buruk kausik ko ngualara sipira iwita aimi bitakasam, ale ani ni ko ko ninguru me sinarakasam. ");
INSERT INTO wsk_vpl VALUES ("PS73_23","020_73_23","PSA","73","23","23","Bare ani pempem la ni kerak pingi bagasam; se ni ani agiting te aga ilusam. ");
INSERT INTO wsk_vpl VALUES ("PS73_24","020_73_24","PSA","73","24","24","Nika ikia sinar mu te aga bitarsam; ale tom udagi te mu ni ka sor nikim mu ningi aga aru toko. ");
INSERT INTO wsk_vpl VALUES ("PS73_25","020_73_25","PSA","73","25","25","Ni keta suanta ni aninga angamang motam, se ani anape karogo duruk wonong te se ali imi te ko kuerikko? Mena! ");
INSERT INTO wsk_vpl VALUES ("PS73_26","020_73_26","PSA","73","26","26","Aninga ikia se angimik mu sokel kaparuk agi wore, Kaem, ni keta suanta aninga sail se aga ikia nunguning ko duap, tom suen biya ko. ");
INSERT INTO wsk_vpl VALUES ("PS73_27","020_73_27","PSA","73","27","27","Nunguningta, arikaya nika betesan ale nika ko awar biya bagasan mu mena namamonko; awiriya ni diram la me karo kisisan, mu ni nunga maguwurko. ");
INSERT INTO wsk_vpl VALUES ("PS73_28","020_73_28","PSA","73","28","28","Bare aninga amilmil mu ani ni kimik duap te bagasam. Yawe, ni keta suanta aninga Kaem, se aninga yumura kuwim; se ani nika kiwem suen la beterem mu ko balikko. ");
INSERT INTO wsk_vpl VALUES ("PS74_1","020_74_1","PSA","74","1","1","(Asaph wur imi batogam) O Kaem, ni awuk, nanga mera biya nanga merem e? Awuk se nika gemang memek ka sor wolong yawara ewere ko sipsip nunga maguwuwoso? ");
INSERT INTO wsk_vpl VALUES ("PS74_2","020_74_2","PSA","74","2","2","Ni kariimet imi, girakala ni keta nunga sangaru taem, mu nunga kamin ares maukko. Kariimet gue imi nika ma balem, ni keta nunga bataguru giem. Duruk Zion nika bagara kuwim wore ko ago me kamili saparukko. ");
INSERT INTO wsk_vpl VALUES ("PS74_3","020_74_3","PSA","74","3","3","Melmasak suen biya magara biya maga kuena saparam ewere kema gurugu ale arikko; kager kari memek nika kuwim laili imi maguwu sapaman. ");
INSERT INTO wsk_vpl VALUES ("PS74_4","020_74_4","PSA","74","4","4","Nika kager kari memek alo ngata te kuwim laili ni te nanga biguwukasam mu ningi kapaman; nuna nunga guang kiwol ago balayam wore ningi awu karogo namaman. ");
INSERT INTO wsk_vpl VALUES ("PS74_5","020_74_5","PSA","74","5","5","Nuna burir te tam kaura ko kari nunga kiwem beteman. ");
INSERT INTO wsk_vpl VALUES ("PS74_6","020_74_6","PSA","74","6","6","Nuna kiwol anapeya ningi mu burir manga barasam se te pakakumu maguwu sapaman. ");
INSERT INTO wsk_vpl VALUES ("PS74_7","020_74_7","PSA","74","7","7","Nuna nika bagara kuwim laili mu kaiman se kani malilaram; nika bagara kuwim nika nip biya karogo mu kiwem duap duap te karur tuguman. ");
INSERT INTO wsk_vpl VALUES ("PS74_8","020_74_8","PSA","74","8","8","Nuna nunumi manorman, “Ana aitakta nunga moa parusuwura biya parusuwunakko!” maman; uwuta balu se biguwura kuwim suen la Kaem te nup patawukasan mu kai sapaman. ");
INSERT INTO wsk_vpl VALUES ("PS74_9","020_74_9","PSA","74","9","9","Ana aitak Kaem ko kiwem bibiya duap duap bo ta me arigisan; Kaem ilak tuatara ko kari bo me ta bagoso; se kiwem imi tom amaruya menarukko mu ana bo yam ta me ko ikisan. ");
INSERT INTO wsk_vpl VALUES ("PS74_10","020_74_10","PSA","74","10","10","O Kaem, tom awila nunguningkiri kager kari memek ewere nika gusirmonko? Nuna butata nika nip maguwu se lagamonko e? ");
INSERT INTO wsk_vpl VALUES ("PS74_11","020_74_11","PSA","74","11","11","Ni awuk se kiting kalem, kiting sokel garagar wore awuk se kalem? Kiting kalem wore apur ale nunga maguwurko! ");
INSERT INTO wsk_vpl VALUES ("PS74_12","020_74_12","PSA","74","12","12","Bare O Kaem, ni aninga king, ni girakala la wore bagasam; ni keta ali imi lilim sangaru tasam. ");
INSERT INTO wsk_vpl VALUES ("PS74_13","020_74_13","PSA","74","13","13","Ni keta ka sokel aora biya wore te gagi pagaru ilagala awurem; ale gagi ko mel memek bibiya mu nusupuling ita pakakumurem. ");
INSERT INTO wsk_vpl VALUES ("PS74_14","020_74_14","PSA","74","14","14","Ni keta gagi ko mel memek Leviathan mu supuling suen la ita parusuwurem ale sor merang mu ko buruk kausik se inangnang anapeya namonko nungarem. ");
INSERT INTO wsk_vpl VALUES ("PS74_15","020_74_15","PSA","74","15","15","Ni keta yu tingawara mu se, yu palenga namawara mu nunga barukem se naguwasan; ni tala balem se yu bibiya nungumik maraka mena mu maraka namaman. ");
INSERT INTO wsk_vpl VALUES ("PS74_16","020_74_16","PSA","74","16","16","Woremkalal se tirom mu am nika la; ni worem se sige nuguwim nungarem. ");
INSERT INTO wsk_vpl VALUES ("PS74_17","020_74_17","PSA","74","17","17","Ni keta ali imi lilim ko tom bita bita karogo namerem; ni worem ko tom se tuwik ko tom nungem. ");
INSERT INTO wsk_vpl VALUES ("PS74_18","020_74_18","PSA","74","18","18","O Yawe, kager kari memek nika gusiman wore ko kamin ares mauk, se kariimet ikia ningo mena, nika nip balu maguwuman wore ko ikiko. ");
INSERT INTO wsk_vpl VALUES ("PS74_19","020_74_19","PSA","74","19","19","Nika inangnang biton yawara mu, mel diwang memek nuguting te me bitarko; nika kariimet, ikup memek giman mu, nunga kamili me sapa se lagarukko. ");
INSERT INTO wsk_vpl VALUES ("PS74_20","020_74_20","PSA","74","20","20","Nika den kalem mu ko kamili me saparukko, mu awuk, tiromorom ko kari memek alo kager daong ko ali sor ira sapaman. ");
INSERT INTO wsk_vpl VALUES ("PS74_21","020_74_21","PSA","74","21","21","Buta se kariimet nunga bita maguwuman mu nungarkiwer se me dola namamonko, mena; nuna kituwura guat se nungumik mel mena bare nunga sangaru se nika nip patawumonko. ");
INSERT INTO wsk_vpl VALUES ("PS74_22","020_74_22","PSA","74","22","22","O Kaem, bares ale ni keta ka kiwem ningo diram wore te sokel ago anirukko ko baluko; kariimet memek ni ko ko den alel balu lagasan wore ko ikia toko. ");
INSERT INTO wsk_vpl VALUES ("PS74_23","020_74_23","PSA","74","23","23","Kari memek nunga ngata nirung kawel pempem bita lagasan mu ko kamili me saparukko. ");
INSERT INTO wsk_vpl VALUES ("PS75_1","020_75_1","PSA","75","1","1","(Asaph wur imi batogam) O Kaem, ana amilmil kisisan! Nunguningta ana amilmil kisisan, mu awuk, ni ana nangarak pingi bagasam. Kariimet nika kiwem duap duap beterem mu ko balsan. ");
INSERT INTO wsk_vpl VALUES ("PS75_2","020_75_2","PSA","75","2","2","Ni balsam, “Ani agata kariimet te nunga tuterikko tom mu ko ikiwasam; ani munan diram te kariimet nunga tutesam. ");
INSERT INTO wsk_vpl VALUES ("PS75_3","020_75_3","PSA","75","3","3","Ali lilim la mu yam yukuok se kariimet suen la yam uririkimonko, bare ali ko nukuri mu ani ilukuawusam se aora biya aniso. ");
INSERT INTO wsk_vpl VALUES ("PS75_4","020_75_4","PSA","75","4","4","Ani nusupuling lagara ko kariimet mu nunga manorsam, ‘Nina ninimi me patawuralko!’ Ale kariimet memek mu nunga manorsam, ‘Nina ninip biya mu te sanamaral ale ninimi me te patawu se lagaralko! ");
INSERT INTO wsk_vpl VALUES ("PS75_5","020_75_5","PSA","75","5","5","Nina ninip biya sumu me te sanamaral ale aninga angama te me kalel biya namaralko; nina ninimi patawura ko dogotak te me munakaralko!’ ” ");
INSERT INTO wsk_vpl VALUES ("PS75_6","020_75_6","PSA","75","6","6","Kari bo ta koma worem bausa te agi koma worem kapara te, agi koma aguwaya mu te tairuk ale numi patawu se kariimet nunga tuterukko me balukko, mena. ");
INSERT INTO wsk_vpl VALUES ("PS75_7","020_75_7","PSA","75","7","7","Kaem kota kariimet nunga tuteso, ale memek bitawara mu ilak kapawa se, ningo bitawara mu nunga patawuso. ");
INSERT INTO wsk_vpl VALUES ("PS75_8","020_75_8","PSA","75","8","8","Yawe bagun bo kuting te iluwoso, bagun mu ningi mu waen aora ngisuk karogo wore ningi aniso; nu yu mu waruk se kaparuk se ali sor lilim la ko kariimet memek bitawara mu no laga, no sapamon se nuamur bo me pelerukko. ");
INSERT INTO wsk_vpl VALUES ("PS75_9","020_75_9","PSA","75","9","9","Bare ani mu agiring me ta kalikko; ani Jacob ko Kaem ko balu, wur ilu se, nup butata patawu se lagarikko. ");
INSERT INTO wsk_vpl VALUES ("PS75_10","020_75_10","PSA","75","10","10","Mu awuk, nu iwita balso, “Ani kariimet memek bitawara mu nosokel menawurikko; bare kariimet kiwem ningo bitawara mu ani sokel eng bo karogo nungarikko.” ");
INSERT INTO wsk_vpl VALUES ("PS76_1","020_76_1","PSA","76","1","1","(Asaph wur imi batogam) Judah sor te Kaem ko ikisan; se Israel ningi mu noko nup mu biya. ");
INSERT INTO wsk_vpl VALUES ("PS76_2","020_76_2","PSA","76","2","2","Noko wonong mu Salem aniso; se Zion mu noko bagara kuwim. ");
INSERT INTO wsk_vpl VALUES ("PS76_3","020_76_3","PSA","76","3","3","Umu te nu gatu kore tamatama mu biagaram; nu karem se saenang mel suen biya mu kulukumuram ale menawuram. ");
INSERT INTO wsk_vpl VALUES ("PS76_4","020_76_4","PSA","76","4","4","Ni keta nikim biya karogo; ni King Biya, se duruk bibiya sokel ago mu ni nunga kiarem. ");
INSERT INTO wsk_vpl VALUES ("PS76_5","020_76_5","PSA","76","5","5","Ni te se kager ko kari aora aora mu dagulu kua sapaman se ni nunga kager ko melmasak mu gi saperem; se bo kasagarukko me terong. ");
INSERT INTO wsk_vpl VALUES ("PS76_6","020_76_6","PSA","76","6","6","O Jacob ko Kaem, ni sail karogo balem ale iningirem, se kager kari nunga horse karogo dagulu sor kutek ma saparam. ");
INSERT INTO wsk_vpl VALUES ("PS76_7","020_76_7","PSA","76","7","7","Ni keta suanta kariimet suen la ninguru ka nguanga gilingisan! Ni gemang magaruk, mu awiri ni kema te sanamarukko terong? Mena. ");
INSERT INTO wsk_vpl VALUES ("PS76_8","020_76_8","PSA","76","8","8","Ni duruk wonong te baga se kariimet nunga tutera ko den mu ni balem, se ali lilim den mu ikiam ale nguangaram ale sor kutek ma saparam. ");
INSERT INTO wsk_vpl VALUES ("PS76_9","020_76_9","PSA","76","9","9","Ni barasu sanamerem ale kariimet memek bitawara mu nunga memek koma nungarem, ale nika kariimet nunga bita maguwuwaman mu nunga giem. ");
INSERT INTO wsk_vpl VALUES ("PS76_10","020_76_10","PSA","76","10","10","Kaem, ni kari ko gomang magara nikate beteso mu gurugusam se nika nip biya eng am biyala kisiso; se kariimet nika gemang magara ningi ikup bo me arigiman mu nguanga se nika nip patawumonko. ");
INSERT INTO wsk_vpl VALUES ("PS76_11","020_76_11","PSA","76","11","11","Buta se, ni mel bo Yawe nika Kaem bita tuiko balu mu, eng am uwutata bitarko. Sor suen la nu kota suanta ko nguanga se taimon munan tumonko. ");
INSERT INTO wsk_vpl VALUES ("PS76_12","020_76_12","PSA","76","12","12","Nu king nusupuling lagara mu nunga nosokel karogo kaposo; se ali ko king suen la ko nguangasan. ");
INSERT INTO wsk_vpl VALUES ("PS77_1","020_77_1","PSA","77","1","1","(Asaph wur imi batogam) Ani Kaem kote sail ago niarem; ani Kaem agiring ikiokko kote niarem. ");
INSERT INTO wsk_vpl VALUES ("PS77_2","020_77_2","PSA","77","2","2","Tom ani ikup ningi kaperem, ani Kari Biya kote wosengem; tirom angimik anira mena ani aira wosenga te la lagerem, bare angamang motam me ta kua kaparam. ");
INSERT INTO wsk_vpl VALUES ("PS77_3","020_77_3","PSA","77","3","3","O Kaem, ani ni ko ko angamin tugu se aeman biya gotek sapakasam, ale angamang motam sokel menakaso. ");
INSERT INTO wsk_vpl VALUES ("PS77_4","020_77_4","PSA","77","4","4","Ni nungurukasam se ani amotam anira me arikaso; ani angamang ninguru yukuwakaso se munakarikko me terong. ");
INSERT INTO wsk_vpl VALUES ("PS77_5","020_77_5","PSA","77","5","5","Ani yia se tom nama lagaram mu ko ikia to lagakasam. ");
INSERT INTO wsk_vpl VALUES ("PS77_6","020_77_6","PSA","77","6","6","Ale aga wur tirom ilukasam mu ko angamin ares makaso. Tom ikia bitakasam mu agata aimi iwita isarukasam: ");
INSERT INTO wsk_vpl VALUES ("PS77_7","020_77_7","PSA","77","7","7","“Kari Biya pa, buring gurugu aisam ta agi? Agi ago ko yam ikiwoso agi? ");
INSERT INTO wsk_vpl VALUES ("PS77_8","020_77_8","PSA","77","8","8","Agi ko gomang ani kua aisuwaram mu menaram agi? Se agarak ikia kaolam mu dagulu namaram agi? ");
INSERT INTO wsk_vpl VALUES ("PS77_9","020_77_9","PSA","77","9","9","Kaem pa, noko gomang lila mu ko kuamili saparam agi? Agi noko gomang memek mu noko gomang lila kuwim tam agi?” ");
INSERT INTO wsk_vpl VALUES ("PS77_10","020_77_10","PSA","77","10","10","Bare angamin namara taira ningi iwita ikiem, “Kaem Kalel Biya yia suen biya ningi nanga sangaru lagaram, se ani mel umu te ira sanamasam.” ");
INSERT INTO wsk_vpl VALUES ("PS77_11","020_77_11","PSA","77","11","11","O Yawe, ani ni girakala mel bibiya beterem mu ko angamin ares maso; ani nika kiwem bibiya ni girakala bita lagerem mu aga ikia te taiso. ");
INSERT INTO wsk_vpl VALUES ("PS77_12","020_77_12","PSA","77","12","12","Ani ni ura bibiya beterem mu ko iki gurugekko; ani nika kiwem bibiya suen la beterem mu ko angamin tugumekko. ");
INSERT INTO wsk_vpl VALUES ("PS77_13","020_77_13","PSA","77","13","13","O anananga Kaem, nika kiwem suen la betesam mu laili biya. Kaem bo awuk wore noko nup biya nika iwita? ");
INSERT INTO wsk_vpl VALUES ("PS77_14","020_77_14","PSA","77","14","14","Ni keta Kaem, ni mel duap duap sokel karogo betesam se arataso; nika sokel aora biya sor suen la ko kariimet nunga kasursam se arigisan. ");
INSERT INTO wsk_vpl VALUES ("PS77_15","020_77_15","PSA","77","15","15","Nika kiting sokel aora garagar mu te ka kariimet nunga sangaru taem; ni Jacob se Joseph nunga nunumasari se taleng girigir nunga giem. ");
INSERT INTO wsk_vpl VALUES ("PS77_16","020_77_16","PSA","77","16","16","O Kaem, yu bibiya karkaman; yu bibiya mu karkaman ale nguangakasan; gagi nukum du biya mu uririkiram. ");
INSERT INTO wsk_vpl VALUES ("PS77_17","020_77_17","PSA","77","17","17","Tuwik taiti nuwi ningi wore kapakaso; taiti gomang te pure pagakaso; pure nikim biliwilik makaso ale gatu iwita nama taikaso. ");
INSERT INTO wsk_vpl VALUES ("PS77_18","020_77_18","PSA","77","18","18","Pure nirung daula biya ningi aratukaso, se pure nikim ali sor lilim la nikim tuikaso; ali uririkikaso ale wanara ko kapakaso. ");
INSERT INTO wsk_vpl VALUES ("PS77_19","020_77_19","PSA","77","19","19","Ni gagi tamun ningi aolak iluwem, ale gagi naung du biya mu batagem koma sang ko namerem, bare ka siwik molak me arigiman. ");
INSERT INTO wsk_vpl VALUES ("PS77_20","020_77_20","PSA","77","20","20","Ni ka kariimet sipsip iwita nunga giem; ni Moses, Aaron ilak nunga kari gira ko nunga awurem ale nongorak aolak iluwem. ");
INSERT INTO wsk_vpl VALUES ("PS78_1","020_78_1","PSA","78","1","1","(Asaph wur imi batogam) O aga kariimet, nina aninga den ikialko; nedegawa ninguru gurugal ale den ani balikko ewere ikialko. ");
INSERT INTO wsk_vpl VALUES ("PS78_2","020_78_2","PSA","78","2","2","Ani mel girakala aratukaso wore sang balik se ikial ale te sinar palagalko; ale mel saki nengete yumura wore ninguru ko ikialko. ");
INSERT INTO wsk_vpl VALUES ("PS78_3","020_78_3","PSA","78","3","3","Girakala anananga girigir alo ko nanga manorman, se nadogowa ikiam se ko ikiman. ");
INSERT INTO wsk_vpl VALUES ("PS78_4","020_78_4","PSA","78","4","4","Ana den umu kuriang nongoma te me kaluwunakko; kuriang gue udagi mu nunga manornak ale Kaem ko sokel aora garagar se ko kiwem bibiya duap duap mu me kaluwunakko. ");
INSERT INTO wsk_vpl VALUES ("PS78_5","020_78_5","PSA","78","5","5","Kaem ko munan den Israel kariimet nungaram, nu Jacob ko kuriang imas munan den imi karo tumonko nungaram. Nu girakala anananga nanangatak alo iwita nunga maonam, “Nina aninga munan den imi ninguru ninga kuriang imas nunga kausalko,” mam. ");
INSERT INTO wsk_vpl VALUES ("PS78_6","020_78_6","PSA","78","6","6","Uwuta mu kuriang gue maingte aratamon mu, nuna karogo tala ko ikimon ale aking nunga kuriang gue te mu nunga kasurmonko. ");
INSERT INTO wsk_vpl VALUES ("PS78_7","020_78_7","PSA","78","7","7","Nuna uwuta betemon mu asele, kuriang luan udagi mu Kaem ko nongomang ningi nunguning aruk, se nuna nu mel bibiya nungam mu me ta ko nungamili saparuk, se ko munan den kasik la mu karo tumonko. ");
INSERT INTO wsk_vpl VALUES ("PS78_8","020_78_8","PSA","78","8","8","Nuna nunga taleng girigir alo nusupuling lagakaso iwita me bagamonko. Taleng girigir alo mu noko den sawarukasan ale noko nongomang ningi me nunguning akaso, se ko den me karo tuikasan. ");
INSERT INTO wsk_vpl VALUES ("PS78_9","020_78_9","PSA","78","9","9","Ephraim digo mu gatu mare karogo, bare kager barasam mu nuna nagu sapaman. ");
INSERT INTO wsk_vpl VALUES ("PS78_10","020_78_10","PSA","78","10","10","Kaem den nongorak kaolam mu me karo tuman, ale ko munan den mu karo tumonko nongomang me anikaso. ");
INSERT INTO wsk_vpl VALUES ("PS78_11","020_78_11","PSA","78","11","11","Nuna munan bibiya nu beteram mu ko nungamili saparam, ale kiwem bibiya nongoma te beteram mu karogo ko nungamili saparam. ");
INSERT INTO wsk_vpl VALUES ("PS78_12","020_78_12","PSA","78","12","12","Nu garuk nomotam te kiwem bibiya duap duap bitakaso; kiwem mu ali sor Egypt se kuwim Zoan mu te bitakaso. ");
INSERT INTO wsk_vpl VALUES ("PS78_13","020_78_13","PSA","78","13","13","Kaem gagi pagaru ilagala awuram, duruk iwita koma singsang awuram, ale Israel nongorak kusumuri tairam. ");
INSERT INTO wsk_vpl VALUES ("PS78_14","020_78_14","PSA","78","14","14","Kowarkalal mu taiti nuwi ningi baga se taiti nuwi iwita girikaso; ale tirom mu tama nikim iwita kanikaso ale girikaso. ");
INSERT INTO wsk_vpl VALUES ("PS78_15","020_78_15","PSA","78","15","15","Nu sor maraka garagarayam te manga pakakumukaso se yu kapakaso se nokasan ale yu ko me tukunangakasan. ");
INSERT INTO wsk_vpl VALUES ("PS78_16","020_78_16","PSA","78","16","16","Nu nungam se yu gotek bo manga ningi bausam, ale yu biya bo iwita naguram koropong kaoram ale kaparam. ");
INSERT INTO wsk_vpl VALUES ("PS78_17","020_78_17","PSA","78","17","17","Bare nuna Kaem Kalel Biya mu koma te memek tawun biya bitakasan; nuna sor maraka te baga se nusupuling lagakaso. ");
INSERT INTO wsk_vpl VALUES ("PS78_18","020_78_18","PSA","78","18","18","Nuna ko iki se wore Kaem ira ariga te bitakasan; nuna na ko kuakasan ale na nungarukko sail te ko balukasan. ");
INSERT INTO wsk_vpl VALUES ("PS78_19","020_78_19","PSA","78","19","19","Nuna Kaem ilak barimakasan ale balukasan, “Kaem pa sor maraka iwita te inang suen biya nangarukko terong agi?” makasan. ");
INSERT INTO wsk_vpl VALUES ("PS78_20","020_78_20","PSA","78","20","20","“Nu manga moram se yu biya aratam. Bare aitak awuk? Nu inang daro ko yaman ago mu nangarukko terong?” ");
INSERT INTO wsk_vpl VALUES ("PS78_21","020_78_21","PSA","78","21","21","Se tom Yawe umu ikiam mu gomang magaram, se tama beteram se Jacob ko kariimet nongote tai kaparam, ale gomang magara tawun biya Israel ko magaram. ");
INSERT INTO wsk_vpl VALUES ("PS78_22","020_78_22","PSA","78","22","22","Nuna munan mu Kaem kote bitakasan, mu awuk, nuna noko nongomang ningi me nunguning akaso se nu me nunga sangukko iwita ikikasan. ");
INSERT INTO wsk_vpl VALUES ("PS78_23","020_78_23","PSA","78","23","23","Bare nu umu ko iki se wore taiti gomang sail ago maonam ale taiti gomang ko songkuring kaogam. ");
INSERT INTO wsk_vpl VALUES ("PS78_24","020_78_24","PSA","78","24","24","Ale inang manna mu tuwik iwita beteram se namonko kaparam; nu duruk wonong ko inang imi namonko nungaram. ");
INSERT INTO wsk_vpl VALUES ("PS78_25","020_78_25","PSA","78","25","25","Se imi mu engel nunga inang wore nuna naman; nu inang suen biya nungaram se naman. ");
INSERT INTO wsk_vpl VALUES ("PS78_26","020_78_26","PSA","78","26","26","Se udagi aking balam se koma worem bausa mu te marir barasam, ale ko sokel aora biya mu te balam se yar daula barasam. ");
INSERT INTO wsk_vpl VALUES ("PS78_27","020_78_27","PSA","78","27","27","Ale inangnang beteram se tuwik muguri iwita kaparam ale kupkup iwita ali bala tuam, mu inangnang suen biya nunguningkiri saun muguri iwita kapaman. ");
INSERT INTO wsk_vpl VALUES ("PS78_28","020_78_28","PSA","78","28","28","Te kuwim taman ale bagakasan mu te nu inangnang waram se kaparam ale sasal suen la duap te sor magaram. ");
INSERT INTO wsk_vpl VALUES ("PS78_29","020_78_29","PSA","78","29","29","Se kariimet ninguru naman ale nungumik karogo terong ma saparam; mel ko kueman mu Kaem nungaram. ");
INSERT INTO wsk_vpl VALUES ("PS78_30","020_78_30","PSA","78","30","30","Bare inang mu yam aitak nowaman, inang nuguring ningi yam aniram se, ");
INSERT INTO wsk_vpl VALUES ("PS78_31","020_78_31","PSA","78","31","31","Kaem gomang magaram se nunga kari kulak sokel ago mu nunga moram se kueman, mu kari umu Israel ko kari ningo ningo. ");
INSERT INTO wsk_vpl VALUES ("PS78_32","020_78_32","PSA","78","32","32","Kaem kiwem bibiya duap duap nungurukaso ta wore, kariimet nongomang ningi me nunguning akaso, se memek yam bitawakasan. ");
INSERT INTO wsk_vpl VALUES ("PS78_33","020_78_33","PSA","78","33","33","Buta se nu am motam la nungarkiwakaso se nuna nguangara ago aolak ilukasan, ale ko ningo nuam bo me arigiman, am nama kua namakasan. ");
INSERT INTO wsk_vpl VALUES ("PS78_34","020_78_34","PSA","78","34","34","Tom Kaem sang nunga moakaso se kuakasan, asele sang nongomang gurugukasan ale kote pila taikasan ale sail karogo kote guranek bitakasan. ");
INSERT INTO wsk_vpl VALUES ("PS78_35","020_78_35","PSA","78","35","35","Aitak nungamin ares mam se ko ikiman, Kaem mu nononga Manga Gek am, Kaem Kalel Biya mu nunga Saonga Kari. ");
INSERT INTO wsk_vpl VALUES ("PS78_36","020_78_36","PSA","78","36","36","Bare mu kawelakasan, nuguring guang la balukasan, ale kawel te nungamili gurugu patawukasan. ");
INSERT INTO wsk_vpl VALUES ("PS78_37","020_78_37","PSA","78","37","37","Nuna nongomang motam ningi nunguning te me karo tuikasan, ale den nongorak kaolam mu diram la me karo tuman. ");
INSERT INTO wsk_vpl VALUES ("PS78_38","020_78_38","PSA","78","38","38","Bare Kaem ko noman bataga nononga ko wore te se, nunga memek siwukaso ale me nunga maguwukaso. Tom suen biya noko gomang magara mu am irakaso se kapakaso, se me nunga maguwukaso. ");
INSERT INTO wsk_vpl VALUES ("PS78_39","020_78_39","PSA","78","39","39","Nu ikikaso mu nuna ali ewere ko kariimet; nuna marir taiso ale nama mena namoso iwita, tom tukunangta baga mena namamonko. ");
INSERT INTO wsk_vpl VALUES ("PS78_40","020_78_40","PSA","78","40","40","Nuna sor merang mu te baga se tom suen biya nusupuling lagakaso; se sor garagarayam mu te baga se gomang motam maguwukasan. ");
INSERT INTO wsk_vpl VALUES ("PS78_41","020_78_41","PSA","78","41","41","Nuna Kaem ira ariga ko munan mu me ta bita to arikasan, ale Israel ko Kaem Laili mu gomang maguwukasan. ");
INSERT INTO wsk_vpl VALUES ("PS78_42","020_78_42","PSA","78","42","42","Nuna noko sokel aora garagar mu ko nungamin me ta ares makaso, se tom nu kari memek nuguting te nunga bataguru tam mu ko nungamili saparam tala. ");
INSERT INTO wsk_vpl VALUES ("PS78_43","020_78_43","PSA","78","43","43","Nu Egypt sor mu te kiwem bibiya duap duap beteram, ale Zoan sor ningi kausa beteram mu ko nungamin me ares makaso. ");
INSERT INTO wsk_vpl VALUES ("PS78_44","020_78_44","PSA","78","44","44","Nu sor umu te nunga yu gurugam se gue ko aram, se kariimet umu nunga yu namonko me terong. ");
INSERT INTO wsk_vpl VALUES ("PS78_45","020_78_45","PSA","78","45","45","Nu kuwuling beteram se nunga nokaso, se gorogoro beteram se nunga daiga bagara maguwukaso. ");
INSERT INTO wsk_vpl VALUES ("PS78_46","020_78_46","PSA","78","46","46","Nu yes memek se usiska kurumurum beteram, se nunga ningam ningi tam gawa suen la no sapaman. ");
INSERT INTO wsk_vpl VALUES ("PS78_47","020_78_47","PSA","78","47","47","Nu tuwik muguri bibiya mu beteram se tai kaparam ale nunga tam waen se nunga tam fig maguwu saparam. ");
INSERT INTO wsk_vpl VALUES ("PS78_48","020_78_48","PSA","78","48","48","Nu tuwik biya bo, muguri bibiya, wore beteram se kaparam se nunga bulmakau kua sapaman; pure nikim te nunga sipsip anapeya maguwu saparam se kueman tala. ");
INSERT INTO wsk_vpl VALUES ("PS78_49","020_78_49","PSA","78","49","49","Nu ninguru gomang magaram se ninguru nunga maguwuram; se ko gomang memek mu kuera mateng ko engel alo kariimet nunga maguwu kam, nunga maguwuram. ");
INSERT INTO wsk_vpl VALUES ("PS78_50","020_78_50","PSA","78","50","50","Nu nogo ko gomang magaram se me nongorak kolaram, mena; nu kuera biya bo beteram se tai kaparam se karogo ngual ngual kueman. ");
INSERT INTO wsk_vpl VALUES ("PS78_51","020_78_51","PSA","78","51","51","Nu Egypt nunga kuriang gira bilangara mu nunga moram se kua sapaman; kuriang kari, kari ko gue kuagi, Ham ko gue te, mu nunga maguwuram. ");
INSERT INTO wsk_vpl VALUES ("PS78_52","020_78_52","PSA","78","52","52","Bare nu ko kariimet mu sipsip iwita nunga giam, ale sor garagarayam mu te lage nunga kausam. ");
INSERT INTO wsk_vpl VALUES ("PS78_53","020_78_53","PSA","78","53","53","Nu nunga giam ale nunga bitaru se nongorak namakaso se me nguangakasan; bare nunga kager kari memek mu gagi biya tairam ale nunga ira kaluwuram. ");
INSERT INTO wsk_vpl VALUES ("PS78_54","020_78_54","PSA","78","54","54","Nu nunga giam nongorak tai kota ko duruk laili mu te aratam, sor duruk ali mu nu kota ko sail te bataguru tam. ");
INSERT INTO wsk_vpl VALUES ("PS78_55","020_78_55","PSA","78","55","55","Nu kariimet iwareng giriman ale ali umu te bagaman mu nunga kaoram, ale ali mu pakakumu Israel kariimet nungaram; ale digo digo te kuwim nungaram se te dagiman. ");
INSERT INTO wsk_vpl VALUES ("PS78_56","020_78_56","PSA","78","56","56","Bare Israel kariimet aking Kaem Kalel Biya mu ira ariga te bitakasan ale ilak nusupuling lagakaso; nuna ko munan den me karo tuikasan. ");
INSERT INTO wsk_vpl VALUES ("PS78_57","020_78_57","PSA","78","57","57","Nuna kiwem girakala nunga taleng girigir alo bitakasan iwitatala, nuna nusupuling lagakaso se Kaem kuring kulukurukasan; mare pateweteng se tagira mu me diram namaruk iwita bitakasan. ");
INSERT INTO wsk_vpl VALUES ("PS78_58","020_78_58","PSA","78","58","58","Nuna kaem kawel nunga tama betera kuwim kalokasan, se Kaem gomang ninguru magakaso; ale nunga kaem kawel umu te Kaem gomang motam maguwukasan. ");
INSERT INTO wsk_vpl VALUES ("PS78_59","020_78_59","PSA","78","59","59","Kaem nunga kiwem ewere arigam mu nu gomang ninguru magaram, se buring lilim la gurugu ko kariimet Israel nungaram. ");
INSERT INTO wsk_vpl VALUES ("PS78_60","020_78_60","PSA","78","60","60","Ale ko sasal Shiloh mu betela buring tuam, noko sasal mu kariimet nunga wonong kusumuri anikaso wore beteram. ");
INSERT INTO wsk_vpl VALUES ("PS78_61","020_78_61","PSA","78","61","61","Ale yam kager kari memek nungarkiwaram se noko Kunup Laili mu gi ago nama gilingiman; Kunup umu noko nup biya se ko nikim nunga kasurukaso. ");
INSERT INTO wsk_vpl VALUES ("PS78_62","020_78_62","PSA","78","62","62","Nu ko kariimet nogo ko gomang magaram se kager kari memek am nungarkiwaram se ko kariimet nunga moman se kua gilingiman. ");
INSERT INTO wsk_vpl VALUES ("PS78_63","020_78_63","PSA","78","63","63","Nunga kari kulak mu tama nunga lakumu saparam, se nunga kuriang itiwik mu kari kulak bo nongorak namonko mu mena. ");
INSERT INTO wsk_vpl VALUES ("PS78_64","020_78_64","PSA","78","64","64","Nunga priest arika mu kager kari memek nunga moman se kua sapaman, se nunga imet mu nungumik ma niara mena. ");
INSERT INTO wsk_vpl VALUES ("PS78_65","020_78_65","PSA","78","65","65","Asele Kari Biya kari bo aniwa barasa iwita barasam, ale kari yu nana ale alis ago aira iwitata airam. ");
INSERT INTO wsk_vpl VALUES ("PS78_66","020_78_66","PSA","78","66","66","Ale kager kari memek nongorak kageraram ale nunga kaoram ale nongorak peleram; nu ninguru tala nunga maguwuram se dolaman ale udagi me kagermonko. ");
INSERT INTO wsk_vpl VALUES ("PS78_67","020_78_67","PSA","78","67","67","Nu Joseph ko gue te ko kariimet mu nunga sarumu due ko nunga awuram, ale Ephraim ko gue te mu me nunga atumukiram tala. ");
INSERT INTO wsk_vpl VALUES ("PS78_68","020_78_68","PSA","78","68","68","Bare nu Judah ko gue te ko kariimet mu nunga atumukiram, se duruk Zion mu noko gomang motam. ");
INSERT INTO wsk_vpl VALUES ("PS78_69","020_78_69","PSA","78","69","69","Se noko kawam digo laili mu duruk umutang te kaolam, se ali nu nungam se aora biya aniso iwitatala aora biya aniso. ");
INSERT INTO wsk_vpl VALUES ("PS78_70","020_78_70","PSA","78","70","70","Kaem ko ura kari David atumukiram. ");
INSERT INTO wsk_vpl VALUES ("PS78_71","020_78_71","PSA","78","71","71","Nu sipsip nunga bitaruwaram se Kaem aru tam ale nu ko kariimet Israel nunga bitua kari ko bagarukko beteram. ");
INSERT INTO wsk_vpl VALUES ("PS78_72","020_78_72","PSA","78","72","72","Se David noko ura mu gomang ninguru tuam, ale kariimet ninguru nunga bitarukaso. ");
INSERT INTO wsk_vpl VALUES ("PS79_1","020_79_1","PSA","79","1","1","(Asaph wur imi batogam) O Kaem, sor saki ko kariimet ana nangarak kagerman ale nika ali ningi maingkala utu kapaman; nika temple laili mu ninguru bita maguwu gilingiman ale Jerusalem mu parusuwuman ale ninguru maguwu silataman. ");
INSERT INTO wsk_vpl VALUES ("PS79_2","020_79_2","PSA","79","2","2","Nuna nika kariimet nunga moman se kueman se nunga nungumik nunguning mu inangnang namonko warman; ale nika ura kari nunga nungumik nunguning mu mel diwang se buruk kausik namonko waru gilingiman. ");
INSERT INTO wsk_vpl VALUES ("PS79_3","020_79_3","PSA","79","3","3","Nika kariimet nunga gue mu yu iwita kaparam ale Jerusalem likilim aram, se kariimet bo kariimet kuera mu nunga mutim tugumokko me ta bagoso. ");
INSERT INTO wsk_vpl VALUES ("PS79_4","020_79_4","PSA","79","4","4","Se sor saki nangimik duap te bagara mu nago ko den dolara balsan, ale nanga gusirsan. ");
INSERT INTO wsk_vpl VALUES ("PS79_5","020_79_5","PSA","79","5","5","O Yawe, ni butata ana nago ko gemang maga se lagarukko e? Nika gemang magara butata tama iwita kani se lagarukko e? ");
INSERT INTO wsk_vpl VALUES ("PS79_6","020_79_6","PSA","79","6","6","Nika gemang magara sumu gurugu se, sor wonong nika nip me patawu se, nikate guranek me bitawara, wore nongote namarukko. ");
INSERT INTO wsk_vpl VALUES ("PS79_7","020_79_7","PSA","79","7","7","Mu awuk, nuna Jacob ko gue te tairam mu nunga moman se kua sapaman, se nunga sor wonong maga saparam. ");
INSERT INTO wsk_vpl VALUES ("PS79_8","020_79_8","PSA","79","8","8","Ana nanga taleng girigir alo nunga memek koma me nangaruko; ana nago ko neman bataguk se gemang nangaruko; mu awuk, ana nanga ikia menaram se nangamang motam dagulu parasaram. ");
INSERT INTO wsk_vpl VALUES ("PS79_9","020_79_9","PSA","79","9","9","O Kaem, ni nanga sangaru toko! Keta ka nip biya ko ningo mu ko se, nanga bataguru to ale nanga memek siwu nangaruko. ");
INSERT INTO wsk_vpl VALUES ("PS79_10","020_79_10","PSA","79","10","10","Sor saki ko kariimet nanga isarsan, “Nenenga Kaem apoko ya?” ma balsan mu me terong! Nika ura kari nunga gue kaparam mu ko koma bu nungumik kuali bitar se ana ariginakko. ");
INSERT INTO wsk_vpl VALUES ("PS79_11","020_79_11","PSA","79","11","11","Ana nanga kariimet saki talipara ningi baga se niasan kikisan wore nunga niara ikiko! Nuna uwutata baga kuemonko bagasan; se nika sokel aora biya wore te nunga bataguru toko! ");
INSERT INTO wsk_vpl VALUES ("PS79_12","020_79_12","PSA","79","12","12","O Kari Biya, sor saki nunga bala memek ni kimik kuali beteman mu ko koma tom 7 ko iwita nungaruko! ");
INSERT INTO wsk_vpl VALUES ("PS79_13","020_79_13","PSA","79","13","13","Asele ana nika kariimet, nika sipsip ko nanga balem se ni anananga bitua kari, mu pempem amilmil kisinak ale nika nip biya pempem patawu se laganakko. ");
INSERT INTO wsk_vpl VALUES ("PS80_1","020_80_1","PSA","80","1","1","(Asaph wur imi batogam) O Israel nanga Bitua Kari, ni anananga niara ikiko! Ni ana Joseph ko gue nanga gira kari. Ni ka daiga kuwim te kualala daigem se engel bibiya ka laturman, se nika sokel wetang sapar, ");
INSERT INTO wsk_vpl VALUES ("PS80_2","020_80_2","PSA","80","2","2","se Ephraim se Benjamin se Manasseh ko kariimet arigimonko. Nika sokel aora garagar wore te tai nanga sangaru toko! ");
INSERT INTO wsk_vpl VALUES ("PS80_3","020_80_3","PSA","80","3","3","O Kaem, gemang nangaru ale nanga sangaru toko; nanga sangaru se girakala ningo bagaman uwuta aking baganakko. ");
INSERT INTO wsk_vpl VALUES ("PS80_4","020_80_4","PSA","80","4","4","O Yawe, Kaem Sokel Garagar, awuk? Ni ana nika kariimet nanga aira wosenga ko yam buta gemang maga lagarukko e? ");
INSERT INTO wsk_vpl VALUES ("PS80_5","020_80_5","PSA","80","5","5","Ni namononge mu inang ko iwita nangarem se nokasan, ale namononge yu mu bagun biya wore te iwita kuring aratam se nangarem se nokasan. ");
INSERT INTO wsk_vpl VALUES ("PS80_6","020_80_6","PSA","80","6","6","Ni ana balu maguwura ko mel bo iwita nanga beterem, se sor saki nangimik duap te mu nanga balu maguwusan. ");
INSERT INTO wsk_vpl VALUES ("PS80_7","020_80_7","PSA","80","7","7","O Kaem Sokel Garagar, gemang nangaru ale nanga sangaru toko; nanga sangaru se girakala ningo bagaman uwuta aking baganakko. ");
INSERT INTO wsk_vpl VALUES ("PS80_8","020_80_8","PSA","80","8","8","Girakala ni Egypt sor te tam waen bo taem ale karogo tairem; ni sor saki nunga karem parusuwurem ale ali mu te tam waen mu aguwem. ");
INSERT INTO wsk_vpl VALUES ("PS80_9","020_80_9","PSA","80","9","9","Ni ko kuwim nungem burangerem ale aguwem, se yager ali tam ale palengam ali sor ira saparam. ");
INSERT INTO wsk_vpl VALUES ("PS80_10","020_80_10","PSA","80","10","10","Ko tamarum mu duruk bibiya nunga ira kaluwuram, se kower suen biya mu tam aora sida mu nunga ira saparam. ");
INSERT INTO wsk_vpl VALUES ("PS80_11","020_80_11","PSA","80","11","11","Se ko kower palengam namawaram Gagi Biya Mediterranean tam, ale namawaram Yu Biya Euphrates tam tala. ");
INSERT INTO wsk_vpl VALUES ("PS80_12","020_80_12","PSA","80","12","12","Bare awuk se ni kar waen ningam lautam wore parusuwurem, se kariimet lage mu karo se mu ko nunguning gisan a? ");
INSERT INTO wsk_vpl VALUES ("PS80_13","020_80_13","PSA","80","13","13","Se buruk diwang ira parusuwusan se inangnang, madar, ugigi se anapeya suen la aratasan ale no gilingisan. ");
INSERT INTO wsk_vpl VALUES ("PS80_14","020_80_14","PSA","80","14","14","O Kaem Sokel Garagar, ni duruk wonong te baga se, loager se tai kaparuk se tam waen mu aking ko ari iki ale bitaruko! ");
INSERT INTO wsk_vpl VALUES ("PS80_15","020_80_15","PSA","80","15","15","Ni keta kiting te tam mu aguwem, ale bituem se tam ningo ko aragam. Buta se tair ale bitaruko! ");
INSERT INTO wsk_vpl VALUES ("PS80_16","020_80_16","PSA","80","16","16","Kager kari memek kauman batutumuman ale tama beteman se kaniram; se ni tair ale gemang memek te nunga maguwurko! ");
INSERT INTO wsk_vpl VALUES ("PS80_17","020_80_17","PSA","80","17","17","Bare ana kariimet ni keta nika ma balem, ale keta nunga bituem se gue pagam, wore tai nanga sangaru ale nanga bitaruko. ");
INSERT INTO wsk_vpl VALUES ("PS80_18","020_80_18","PSA","80","18","18","Uwuta mu asele ana udagi te me ka betenakko. Marak iru nangaru se ana pempem nip patawu se laganakko. ");
INSERT INTO wsk_vpl VALUES ("PS80_19","020_80_19","PSA","80","19","19","O Yawe, Kaem Sokel Garagar, gemang nangaru ale nanga sangaru toko; nanga sangaru se girakala ningo bagaman uwuta aking baganakko. ");
INSERT INTO wsk_vpl VALUES ("PS81_1","020_81_1","PSA","81","1","1","(Asaph wur imi batogam) Amilmil te ngata beteralko, Kaem anananga saonga kari; wur te nup patawuralko, nu Jacob ko Kaem! ");
INSERT INTO wsk_vpl VALUES ("PS81_2","020_81_2","PSA","81","2","2","Galawalang sokelel te nirung duap beteralko; ninga bawe se gita te yagowom yawara gurugalko. ");
INSERT INTO wsk_vpl VALUES ("PS81_3","020_81_3","PSA","81","3","3","Tom sige barare la mu kua sokel itugumalko; ale nama garukaso se amilmil ko tom biya arataso mu te akingtala itugumalko. ");
INSERT INTO wsk_vpl VALUES ("PS81_4","020_81_4","PSA","81","4","4","Mu awuk, imi mu Israel nunga munan den, se den aora bo Jacob ko Kaem kote tairam. ");
INSERT INTO wsk_vpl VALUES ("PS81_5","020_81_5","PSA","81","5","5","Mu tom nu Egypt nongorak kager bitawa se, nu Joseph ko kariimet Israel munan den imi nungaram. Tom umu te ani kuring bo iru nuam ikiem, se kuring mu iwita balam, ");
INSERT INTO wsk_vpl VALUES ("PS81_6","020_81_6","PSA","81","6","6","“Ani ikup nibiwinang te mu kututuwurem, ale tam luan gi lagakasan mu kututuwurem. ");
INSERT INTO wsk_vpl VALUES ("PS81_7","020_81_7","PSA","81","7","7","Tom ikup ninga iram se nina aninga aruman mu ani ninga sangaru taem. Aninga yumura kuwim taiti nuwi kaetam mu ningi baga se nigiring iluwem; ale yu Meribah duap te ira ariga te ninga beterem. ");
INSERT INTO wsk_vpl VALUES ("PS81_8","020_81_8","PSA","81","8","8","Aga kariimet, nedegawa gurugal ale sinar den balsam ewere ikialko! Israel kariimet, aga angamang mu aga agiring ewere ninguru ikialko! ");
INSERT INTO wsk_vpl VALUES ("PS81_9","020_81_9","PSA","81","9","9","Nina nebugura kulukal ale kaem bo kilimik me ta nup patawuralko! ");
INSERT INTO wsk_vpl VALUES ("PS81_10","020_81_10","PSA","81","10","10","Ani Yawe, nenenga Kaem; anigita, nina Egypt memek bagaman se ninga giem ale nengerak tairem. Mel i ko kueral mu balal se ani ningarikko. ");
INSERT INTO wsk_vpl VALUES ("PS81_11","020_81_11","PSA","81","11","11","Bare aninga kariimet agiring me ikiman nunguning; Israel nunumi karogo me kapaman ale agiring me karo tuman. ");
INSERT INTO wsk_vpl VALUES ("PS81_12","020_81_12","PSA","81","12","12","Buta se ani nongomang motam aora biya mu ago nunga bita taem, se nongota nunga ikia memek la karo tuikasan. ");
INSERT INTO wsk_vpl VALUES ("PS81_13","020_81_13","PSA","81","13","13","Aninga angamang motam nunguning mu aga kariimet Israel ninguru agiring ikimon ale aga munan karo tumonko aniso! ");
INSERT INTO wsk_vpl VALUES ("PS81_14","020_81_14","PSA","81","14","14","Uwuta mu asele, ani tairate kager kari memek alo nunga maguwuwasan mu nunga morik ale nunga menawurikko. ");
INSERT INTO wsk_vpl VALUES ("PS81_15","020_81_15","PSA","81","15","15","Arikaya ani me aga kuesan mu nguangamon ale ani asiwik duap ningi nubugura kulukurmonko; se ikup memek nungarsam mu butata pempem anirukko. ");
INSERT INTO wsk_vpl VALUES ("PS81_16","020_81_16","PSA","81","16","16","Bare nina mu, ani inang yaman ningo nunguningkiri mu se, honey yaman nuam mu ningarik se nal ale ningimik karogo terong maukko.” ");
INSERT INTO wsk_vpl VALUES ("PS82_1","020_82_1","PSA","82","1","1","(Asaph wur imi batogam) Kaem biguwura biya bitaruwoso; kari supuling bibiya, kaem gotektek iwita nunumi bitawara, wore arataman se nu ko ikia wetang te balu pagarso: ");
INSERT INTO wsk_vpl VALUES ("PS82_2","020_82_2","PSA","82","2","2","“Nina tutera kawel betesan ale kariimet memek bitawara wore nunga atumu sangorsan, bare amaru te kiwem memek sowore bita talko? ");
INSERT INTO wsk_vpl VALUES ("PS82_3","020_82_3","PSA","82","3","3","Ani iwita beteralko balsam: Nina kariimet kituwura se kuriang nunam nonet kuera wore nunga saongalko! Ale kariimet ikup giman ale baga maguwuwasan wore ningo nuam nongote beteralko! ");
INSERT INTO wsk_vpl VALUES ("PS82_4","020_82_4","PSA","82","4","4","Kariimet baga maguwuwasan ale mel suen biya ko tukunangawasan, wore kariimet memek nuguting te nunga bataguru talko! ");
INSERT INTO wsk_vpl VALUES ("PS82_5","020_82_5","PSA","82","5","5","Nina ningimik ikia ningo mena se nina nguala sipawasan! Ale nina tiromorom ningi aolak iluwasan bore te se, kiwem ningo mu yumu namaram. ");
INSERT INTO wsk_vpl VALUES ("PS82_6","020_82_6","PSA","82","6","6","Ani Kaem Kalel Biya iwita balsam, nina kaem iwita ninimi betesan, bare nina suen la aninga kuriang la. ");
INSERT INTO wsk_vpl VALUES ("PS82_7","020_82_7","PSA","82","7","7","Nina ali ko kariimet tala, se ali ko kariimet kuesan iwitatala, nina kueralko; nina kari supuling bibiya dagulasan ale nunup mena namoso iwitatala dagulalko.” ");
INSERT INTO wsk_vpl VALUES ("PS82_8","020_82_8","PSA","82","8","8","O Kaem, ni bares ale ali lilim ko kariimet suen la nunga bita paguwura mu wetang saparko; mu awuk, ali sor suen la ko kariimet mu am nika la. ");
INSERT INTO wsk_vpl VALUES ("PS83_1","020_83_1","PSA","83","1","1","(Asaph wur imi batogam) O Kaem, kiring me kaloko; kutek me ale kiring me sisirokko! ");
INSERT INTO wsk_vpl VALUES ("PS83_2","020_83_2","PSA","83","2","2","Arikko! nika kager kari memek kager ko kirimi karame mawasan, nuna ni me ka kuesan ale ni kerak barimasan. ");
INSERT INTO wsk_vpl VALUES ("PS83_3","020_83_3","PSA","83","3","3","Nuna yumura la nika kariimet nunga maguwumonko ikia memek bitawasan; ale kariimet ni nunga kuesam wore nunga maguwumonko karogo kaeyawasan. ");
INSERT INTO wsk_vpl VALUES ("PS83_4","020_83_4","PSA","83","4","4","Ale “Tairalko,” masan, “nunga wonong sor likilim la menawunak se Israel ko nup eng am mena namarukko,” ma balsan. ");
INSERT INTO wsk_vpl VALUES ("PS83_5","020_83_5","PSA","83","5","5","Nuna nunga ikia yumura mu ko nongomang suanta awuman; ale tai ilu biguwuman, ale ni kerak barimamonko negawasan. ");
INSERT INTO wsk_vpl VALUES ("PS83_6","020_83_6","PSA","83","6","6","Biguwura motam umu Edom ko kariimet, se Ishmael ko, se Moab ko, se Hagrites ko kariimet; ");
INSERT INTO wsk_vpl VALUES ("PS83_7","020_83_7","PSA","83","7","7","se Gebal ko kariimet, se Ammon ko, se Amalek ko, se Philistia ko, se Tyre ko kariimet. ");
INSERT INTO wsk_vpl VALUES ("PS83_8","020_83_8","PSA","83","8","8","Sor Assyria mu ago tala nongorak sanamaram, mu awuk, nuna Lot ko gue Moab se Ammon nongorak numi kuting iluwam. ");
INSERT INTO wsk_vpl VALUES ("PS83_9","020_83_9","PSA","83","9","9","O Kaem, ni munan Midian ko kariimet nungumik te beterem, ale aking yu Kishon te ni king Jabin, se ko kager supuling Sisera nungumik te beterem, uwutatala nungumik te bitarko. ");
INSERT INTO wsk_vpl VALUES ("PS83_10","020_83_10","PSA","83","10","10","Ni Endor wonong te nunga menawurem, ale ali te nunga warem se iwiman. ");
INSERT INTO wsk_vpl VALUES ("PS83_11","020_83_11","PSA","83","11","11","Ni nunga kari supuling alo Oreb se Zeeb nunga maguwurem uwutatala nunga bitarko; ale nunga bitua kari mu, Zebah se Zalmunna nunga beterem uwutatala nunga bitarko. ");
INSERT INTO wsk_vpl VALUES ("PS83_12","020_83_12","PSA","83","12","12","Mu awuk, nuna balman, “Ana Kaem ko ali welang mu ana tanak se anananga arukko,” ma balsan. ");
INSERT INTO wsk_vpl VALUES ("PS83_13","020_83_13","PSA","83","13","13","O aga Kaem, kupkup iwita nunga parusuwurko, se sua ko wakala marir karogo namoso iwita namamonko. ");
INSERT INTO wsk_vpl VALUES ("PS83_14","020_83_14","PSA","83","14","14","Ale tama giarum kaiso se kaniso, ale sua duruk motongar te mu kaniso iwita, ");
INSERT INTO wsk_vpl VALUES ("PS83_15","020_83_15","PSA","83","15","15","yar daula te nunga karo se nagumon, ale ka marir daula samamer biya te nguangara nungaruko! ");
INSERT INTO wsk_vpl VALUES ("PS83_16","020_83_16","PSA","83","16","16","O Yawe, dolara nungaru, nunga maguwur, ale nika sokel aora garagar mu nunga kasuru se arigimonko. ");
INSERT INTO wsk_vpl VALUES ("PS83_17","020_83_17","PSA","83","17","17","Ale nunga maguwur, se eng am butata nguanga dola se lagamonko, nuna nguanga dola laga eng am kua namamonko. ");
INSERT INTO wsk_vpl VALUES ("PS83_18","020_83_18","PSA","83","18","18","Yawe, ni uwuta bitar se nuna ko ikimon, ni keta suanta ni Kaem Kalel Biya, se ali sor lilim la bitarsam. ");
INSERT INTO wsk_vpl VALUES ("PS84_1","020_84_1","PSA","84","1","1","(Korah ko kuriang alo nunga wur bo) O Yawe Sokel Garagar, nika kuwim laili mu am yawarakala! ");
INSERT INTO wsk_vpl VALUES ("PS84_2","020_84_2","PSA","84","2","2","Ani mu te bagarikko kua lagasam; ni la marak duap, se aninga adera, angimik lilim la nika temple laili mu te ni kerak bagarikko ko kuesam. ");
INSERT INTO wsk_vpl VALUES ("PS84_3","020_84_3","PSA","84","3","3","Inangnang singelngel nika altar duap te singir mosan ale nunga gotek nunga sinar tasan uwutata. O Yawe Sokel Garagar, ni aninga King se aga Kaem. ");
INSERT INTO wsk_vpl VALUES ("PS84_4","020_84_4","PSA","84","4","4","Se kariimet nika temple ningi baga se, nika wur ilu se, nika nip patawusan, mu ninguru amilmilamonko. ");
INSERT INTO wsk_vpl VALUES ("PS84_5","020_84_5","PSA","84","5","5","Kariimet nikate sokel to gilingisan, ale duruk Zion te namamonko ko nongomang biyala aniso, mu nuna marak sokel amilmil ago te bagamonko. ");
INSERT INTO wsk_vpl VALUES ("PS84_6","020_84_6","PSA","84","6","6","Tom tai gusong Ma Niara ko masan mu te kapasan, sor garagarayam mu te, bare kuwim mu geraguk yu te aratu kapawara iwita aratukko, se tuwik kaposo se yu laiso iwitata aratukko. ");
INSERT INTO wsk_vpl VALUES ("PS84_7","020_84_7","PSA","84","7","7","Se sokel amilmil ago la lagamonko; ale suan suan nama Kaem Biya Zion bagoso mu koma te aratamonko. ");
INSERT INTO wsk_vpl VALUES ("PS84_8","020_84_8","PSA","84","8","8","O Yawe Sokel Garagar, aninga guranek ikiko; O Jacob ko Kaem, ikiko! ");
INSERT INTO wsk_vpl VALUES ("PS84_9","020_84_9","PSA","84","9","9","Nanga king nigita nangarem wore marak tuiko; nu anananga karem iwita bagoso. ");
INSERT INTO wsk_vpl VALUES ("PS84_10","020_84_10","PSA","84","10","10","Ani nika temple ningi bagarikko ninguru ko kua lagasam; ani sor bo te, day tom 1000 baga se am amilmilarikko; bare aking day tom suanta nika temple ningi baga se ko amilmil mu, day tom 1000 mu am kia saparam. Ani nika temple ningi kasu nagu aratu se lagarikko ninguru ko kuesam; bare ani kariimet memek mu nunga kawam ningi dagi bagarikko me ta ko kuesam. ");
INSERT INTO wsk_vpl VALUES ("PS84_11","020_84_11","PSA","84","11","11","Mu awuk, Yawe mu anananga King se nanga karem; nu ana nanga Kaem. Nu gomang nangarso, ale nup biya nangarso; ale nu kariimet munan diram la betesan mu anapeya mel te me nogore iluso, mel ningo ningo nungarso. ");
INSERT INTO wsk_vpl VALUES ("PS84_12","020_84_12","PSA","84","12","12","O Yawe Sokel Garagar, awiriya nikate ira sanami lagoso mu amilmilarukko. ");
INSERT INTO wsk_vpl VALUES ("PS85_1","020_85_1","PSA","85","1","1","(Korah ko kuriang alo nunga wur bo) O Yawe, nika gemang lila ka ali tuem; Jacob ko kariimet akingtala bagara yawara nungarem. ");
INSERT INTO wsk_vpl VALUES ("PS85_2","020_85_2","PSA","85","2","2","Ni ka kariimet nunga memek siwurem, ale nunga memek beteman mu ira kaluwu saperem. ");
INSERT INTO wsk_vpl VALUES ("PS85_3","020_85_3","PSA","85","3","3","Nika gemang magara to beta ko beterem, ale gemang tama ko kaniwaram mu susuru gurugu tuem. ");
INSERT INTO wsk_vpl VALUES ("PS85_4","020_85_4","PSA","85","4","4","O Kaem, anananga Saonga Kari, nanga gi ale akingtala nanga nunguruko, nika gemang ikup mu bitar se mena namarukko. ");
INSERT INTO wsk_vpl VALUES ("PS85_5","020_85_5","PSA","85","5","5","Mu ni butata ana nago ko gemang maga se lagarukko e? Ale nika gemang magara mu me ta menarukko e? ");
INSERT INTO wsk_vpl VALUES ("PS85_6","020_85_6","PSA","85","6","6","Ni akingtala sokel iru nangaru se, ana nika kariimet amilmilanak ale nip patawunakko. ");
INSERT INTO wsk_vpl VALUES ("PS85_7","020_85_7","PSA","85","7","7","O Yawe, nika kua ana nangara ko munan wore wetang sapar ale nanga sangaru toko. ");
INSERT INTO wsk_vpl VALUES ("PS85_8","020_85_8","PSA","85","8","8","Ani adogowa gurugek ale Kaem Yawe nu anapeya baluk wore ikiekko; mu nu ko kariimet nu diram la karo tusan mu gomang lila balu nungarso. Bare akingtala me pelemon ale ikia memek bitawaman mu me ta betemonko. ");
INSERT INTO wsk_vpl VALUES ("PS85_9","020_85_9","PSA","85","9","9","Nunguningta, awiriya noko nguangasan mu nu nunga sangaru taukko sinar bagoso, mu te noko kumik nikim nanga ali imi lilim la ira saparukko. ");
INSERT INTO wsk_vpl VALUES ("PS85_10","020_85_10","PSA","85","10","10","Se kariimet nunumi ko kua tui se nunumi nongomang nunguning tua ko munan betemonko; ningo diram la bagara ko munan se bagara lila ko munan mu te bagamonko. ");
INSERT INTO wsk_vpl VALUES ("PS85_11","020_85_11","PSA","85","11","11","Numi gomang tua nunguning ko munan mu ali te barasukko; se Kaem nu ningo diram la bagara ko munan mu duruk uningi bitiruk se tai kaparukko. ");
INSERT INTO wsk_vpl VALUES ("PS85_12","020_85_12","PSA","85","12","12","Yawe mu anapeya ningo ningo mu nangaruk, ale nanga ali welang tuok se na inang duap duap ali imi te barasukko. ");
INSERT INTO wsk_vpl VALUES ("PS85_13","020_85_13","PSA","85","13","13","Se ningo diram la bagara ko munan mu girok ale noko lage te aolak iluwokko mu nungok burangarukko. ");
INSERT INTO wsk_vpl VALUES ("PS86_1","020_86_1","PSA","86","1","1","(David guranek imi batogam) O Yawe, aninga wosenga iki ale aga sangaruko; ani agata aimi sangikko me terong. ");
INSERT INTO wsk_vpl VALUES ("PS86_2","020_86_2","PSA","86","2","2","Ni aninga bitaruko, mu awuk, aninga angamang motam nikate la beterem. Ni aninga Kaem; ani nika ura kari yawara; ani nikate la loaga lagasam. ");
INSERT INTO wsk_vpl VALUES ("PS86_3","020_86_3","PSA","86","3","3","O aga Biya, ni ani ago ko gemang batagukko, mu awuk, ani kowarkalal maiya nika aru lagasam. ");
INSERT INTO wsk_vpl VALUES ("PS86_4","020_86_4","PSA","86","4","4","Nika gemang lila ka ura kari ani aisuko, mu awuk, ani ni keta kete angamang motam bita lagasam. ");
INSERT INTO wsk_vpl VALUES ("PS86_5","020_86_5","PSA","86","5","5","O Kari Biya, ni ningo, se ni memek siwu sapara ko Kaem, se awiriya nika arusan mu ni nunga kua lagasam. ");
INSERT INTO wsk_vpl VALUES ("PS86_6","020_86_6","PSA","86","6","6","Bore te se, O Yawe, degewa gurugu ale aninga guranek imi ikiko; ni aninga niara iki ale aga sangaruko. ");
INSERT INTO wsk_vpl VALUES ("PS86_7","020_86_7","PSA","86","7","7","Aninga ikup ko tom ningi ani ka aurik, mu ani ko ikisam, ni aninga agiring ilupko. ");
INSERT INTO wsk_vpl VALUES ("PS86_8","020_86_8","PSA","86","8","8","O Kari Biya, kaem kasik la nunga ningi mu bo ta nika iwita mena; nika kiwem mu kiwem suen la nunga kia saparam. ");
INSERT INTO wsk_vpl VALUES ("PS86_9","020_86_9","PSA","86","9","9","Sor kasik la ni nunga nungem mu taimon ale ni kema te nip patawumonko; nuna nika nip nikim garagar mu patawumonko. ");
INSERT INTO wsk_vpl VALUES ("PS86_10","020_86_10","PSA","86","10","10","Mu awuk, ni keta ni biya se ni kiwem yawara duap duap nunguningkiri betesam; ni keta suanta ni Kaem. ");
INSERT INTO wsk_vpl VALUES ("PS86_11","020_86_11","PSA","86","11","11","O Yawe, nika kiwem aga kasuru se ani nika kiwem diram la karo tui se lagarikko; angamang motam suanta awur se ani ni keta suanta ka bowa ningi baga se lagarikko. ");
INSERT INTO wsk_vpl VALUES ("PS86_12","020_86_12","PSA","86","12","12","O Kari Biya, ni aninga Kaem, ani angamang motam lilim la te ka nip biya patawurikko; ani nika nip biya pempem la balu se lagarikko. ");
INSERT INTO wsk_vpl VALUES ("PS86_13","020_86_13","PSA","86","13","13","Mu awuk, nika kua ani aisa mu kalel biya; ni ani kuera ko mutim ningi iwita wore aga patawu taem. ");
INSERT INTO wsk_vpl VALUES ("PS86_14","020_86_14","PSA","86","14","14","O Kaem, nunumi patawura ko kari alo agarak barimasan; nuna ilu biguwuman ale aninga momon se kuerikko; nuna ni mel yam ko ka betesan. ");
INSERT INTO wsk_vpl VALUES ("PS86_15","020_86_15","PSA","86","15","15","Bare Kari Biya, ni mu gemang bataga se gemang lila ko Kaem, ni gemang tairate me magoso; se ni ninguru nanga kuesam ale gemang nangara nunguning nangarsam. ");
INSERT INTO wsk_vpl VALUES ("PS86_16","020_86_16","PSA","86","16","16","Buta se kema gurugu ale gemang aisuko; ani nika ura kari, nika ura imet bo ko namar, se aga bataguru to ale sokel aisuko. ");
INSERT INTO wsk_vpl VALUES ("PS86_17","020_86_17","PSA","86","17","17","O Yawe, nika ningo nuam ani ago ko wore ko kausa bo bitar se kager kari memek alo arigimon ale dolomonko, mu awuk, ni aninga sangem ale angamang motam patawurem. ");
INSERT INTO wsk_vpl VALUES ("PS87_1","020_87_1","PSA","87","1","1","(Korah ko kuriang alo nunga wur bo) Yawe ko wonong duruk laili Zion awote kaolam; ");
INSERT INTO wsk_vpl VALUES ("PS87_2","020_87_2","PSA","87","2","2","nu Jacob ko wonong sor suen la ningi, Zion mu nu ninguru ko kueso. ");
INSERT INTO wsk_vpl VALUES ("PS87_3","020_87_3","PSA","87","3","3","O Kaem ko wonong, bala ningo ningo ni ko ko balsan. ");
INSERT INTO wsk_vpl VALUES ("PS87_4","020_87_4","PSA","87","4","4","Kaem iwita balam, “Wonong sor aninga ikisan mu ningi, ani Egypt se Babylonia nunga nunup balik ale, Philistia, Tyre, se Cush mu nunga nunup karogo balik, ale iwita balikko, ‘Sor imi Zion wonong ko kariimet tala,’ maikko.” ");
INSERT INTO wsk_vpl VALUES ("PS87_5","020_87_5","PSA","87","5","5","Nunguningta, Zion ko iwita balmonko, “Kariimet imi, se kariimet umu, mu Zion ko kariimet tala,” ma balmonko. “Se Kaem Sokel Garagar mu eng am Zion sokel tuokko,” ma balmonko. ");
INSERT INTO wsk_vpl VALUES ("PS87_6","020_87_6","PSA","87","6","6","Yawe kariimet nunup giok ale nunup duap te mu iwita batagukko, “Kariimet imi Zion wonong ko kariimet.” ");
INSERT INTO wsk_vpl VALUES ("PS87_7","020_87_7","PSA","87","7","7","Se nuna wur ilumon ale iru seseka se balmon, “Ana nanga mel ningo ningo suen la mu Zion ningi bulowolok maso ale taiso,” mamonko. ");
INSERT INTO wsk_vpl VALUES ("PS88_1","020_88_1","PSA","88","1","1","(Korah ko kuriang alo nunga wur bo) O Yawe, ni aninga Kaem, aninga saonga kari; ani tirom kowarkalal ni kema te ka aru wosenga lagasam. ");
INSERT INTO wsk_vpl VALUES ("PS88_2","020_88_2","PSA","88","2","2","Degewa gurugu ale aninga guranek ikiko; aninga niara nikate betesam. ");
INSERT INTO wsk_vpl VALUES ("PS88_3","020_88_3","PSA","88","3","3","Mu awuk, aninga angamang motam ikup ninguru iram, se ani kua namarikko tom pingi aram. ");
INSERT INTO wsk_vpl VALUES ("PS88_4","020_88_4","PSA","88","4","4","Ani kariimet sang mutim ningi kapaman uwutatala kaparikko pingi arem; ale kari bo sokel mena wore turan bagasam. ");
INSERT INTO wsk_vpl VALUES ("PS88_5","020_88_5","PSA","88","5","5","Ani aga sapaman se kariimet kuera nunga ningi bagasam iwita; ale kariimet nunga moman se kueman ale mutim ningi aniwasan se ni nunga kamili sapa namaram se saonga bo me nungaruko iwita ani bagasam. ");
INSERT INTO wsk_vpl VALUES ("PS88_6","020_88_6","PSA","88","6","6","Ni ani mutim du biya wore iwita ningi aga beterem, se mutim mu ningi mu tiromorom biya. ");
INSERT INTO wsk_vpl VALUES ("PS88_7","020_88_7","PSA","88","7","7","Nika gemang magara mu ninguru aga iramuram, gagi tamun biya aga iramuram iwita. ");
INSERT INTO wsk_vpl VALUES ("PS88_8","020_88_8","PSA","88","8","8","Ni uwuta aga beterem se aninga tiran yawara mu nubiring aisiman, ale mel memek bo iwita agarkasan. Ani lauta biya ningi bagasam iwita se nagurekko me terong. ");
INSERT INTO wsk_vpl VALUES ("PS88_9","020_88_9","PSA","88","9","9","Ani angamang bataga se niara ma te amotam sisiram. O Yawe, ani kowarkalal pempem abugura te baga se nika aru lagasam. ");
INSERT INTO wsk_vpl VALUES ("PS88_10","020_88_10","PSA","88","10","10","Ni kiwem bibiya duap duap mu kariimet kuera nongote me betesam; ale kariimet kuera mu barasasan ale nika nip me patawusan. ");
INSERT INTO wsk_vpl VALUES ("PS88_11","020_88_11","PSA","88","11","11","Nika kua ana nangara ko kiwem mu kuera mutim ningi me ko balsan; ale nika gemang nangara nunguningkiri ko munan mu maga namara ko sor te me ko balsan tala. ");
INSERT INTO wsk_vpl VALUES ("PS88_12","020_88_12","PSA","88","12","12","Agi kariimet kueman ale mutim tiromorom biya mu ningi bagasan mu, nika kiwem bibiya duap duap betesam mu ko ari ikimon i? Mena. Kariimet nungamili sapa namara ko kuwim te namaman mu, nika kiwem ningo diram betesam mu nuna me ko ikisan. ");
INSERT INTO wsk_vpl VALUES ("PS88_13","020_88_13","PSA","88","13","13","O Yawe, ani nikate saonga ko niawasam; turomola pempem aninga wosenga nikate betesam. ");
INSERT INTO wsk_vpl VALUES ("PS88_14","020_88_14","PSA","88","14","14","Bare awuk se ni aninga biriruwusam, ale ani ago ko kema motam kaluwusam? ");
INSERT INTO wsk_vpl VALUES ("PS88_15","020_88_15","PSA","88","15","15","Ani aga kulak ko tom te la yaman ikup imi gi lagerem, ale kuerikko tom pingi aram; ani nika gemang memek ko yaman gi lagerem ale angimik sail menaram. ");
INSERT INTO wsk_vpl VALUES ("PS88_16","020_88_16","PSA","88","16","16","Nika gemang memek ninguru aga iramuram; se nguangara ninguru aga maguwuram. ");
INSERT INTO wsk_vpl VALUES ("PS88_17","020_88_17","PSA","88","17","17","Se kiwem imi kowarkalal maiya mu lom iwita aga lautam ale ninguru aga ira baguram. ");
INSERT INTO wsk_vpl VALUES ("PS88_18","020_88_18","PSA","88","18","18","Ni aninga tiran gar ningo se aga gue suan nunga tagi batagem se aninga bita sapaman; ani tiromorom aga iramuram se agata ningi baga maguwu lagasam. ");
INSERT INTO wsk_vpl VALUES ("PS89_1","020_89_1","PSA","89","1","1","(Ezra ko gue te kari Ethan ko wur) O Yawe, ani pempem nika kua ana nangara ko munan mu ko wur iluwekko; ani nika den bala ale diram la karo tuata mu ko munan mu ko pempem balu se lagarikko. ");
INSERT INTO wsk_vpl VALUES ("PS89_2","020_89_2","PSA","89","2","2","Ani ko ikisam, nika kua ana nangara ko munan mu kumik menara mena; se nika den kaola ale diram la karo tuata ko munan mu, taiti gomang iwita pempem la anirukko. ");
INSERT INTO wsk_vpl VALUES ("PS89_3","020_89_3","PSA","89","3","3","Ni iwita balem, “Ani kari bo angamang tuem ale atumukirem wore ilak den kalem, aga ura kari David ilak den iwita kalem, ");
INSERT INTO wsk_vpl VALUES ("PS89_4","020_89_4","PSA","89","4","4","‘Nika gue te la pempem bo king ko aratu se lagamonko; ani nika kuriang gue luan udagi maiya biya mu ninguru nunga bituekko.’ ” ");
INSERT INTO wsk_vpl VALUES ("PS89_5","020_89_5","PSA","89","5","5","O Yawe, taiti gomang te nika kiting kiwol suen la nika balu pagorsan, se engel alo duruk wonong te bolala la nika den bala ale diram la karo tuata ko munan mu ko nip patawusan. ");
INSERT INTO wsk_vpl VALUES ("PS89_6","020_89_6","PSA","89","6","6","Taiti gomang te mel bo ta nika iwita mena; engel bibiya ni kerak wete bagara wore bo ni kerak arerem mena tala. ");
INSERT INTO wsk_vpl VALUES ("PS89_7","020_89_7","PSA","89","7","7","Engel bibiya laili nunguningkiri, nika laturu guruga ale ni kerak bagara, mu nika ninguru nguangasan, mu awuk, ni keta suanta kualala biya bagasam. ");
INSERT INTO wsk_vpl VALUES ("PS89_8","020_89_8","PSA","89","8","8","O Yawe, ni Kaem Sokel Garagar, bo sokel ago nika iwita mena; nika den suen la mu diram la karo tusam. ");
INSERT INTO wsk_vpl VALUES ("PS89_9","020_89_9","PSA","89","9","9","Ni gagi lilim la bitaruwasam; ale tom ko tamun bibiya duruk iwita barasoso mu ni lila awusam ale malin tusam. ");
INSERT INTO wsk_vpl VALUES ("PS89_10","020_89_10","PSA","89","10","10","Ni gagi ko mel memek Rahab ko sokel menawurem; iwitatala, nika sokel aora garagar mu te kager kari memek nunga menawurem. ");
INSERT INTO wsk_vpl VALUES ("PS89_11","020_89_11","PSA","89","11","11","Duruk wonong se ali imi mu am nika la; ni keta ali imi se mel suen la awote mu nungem. ");
INSERT INTO wsk_vpl VALUES ("PS89_12","020_89_12","PSA","89","12","12","Ni keta koma worem te basuso mu nungem, ale aking te nama kaposo mu nungem tala. Se duruk ilagala Tabor se Hermon mu wur te amilmil kisisan. ");
INSERT INTO wsk_vpl VALUES ("PS89_13","020_89_13","PSA","89","13","13","Ni yam sokel garagar! Nika sokel mu yam aromemek se kalel biya! ");
INSERT INTO wsk_vpl VALUES ("PS89_14","020_89_14","PSA","89","14","14","Ni kiwem ningo diram se tutera ningo mu nika barim, te ira sanamasam; ni ka munan me gurugusam patawusam, mena, nika kariimet ninguru nunga kuesam, ale ka den nunga manem mu diram la karo tusam. ");
INSERT INTO wsk_vpl VALUES ("PS89_15","020_89_15","PSA","89","15","15","Yawe, kariimet nika nip patawusan ale nika munan yawara mu ko nikim ningi kerak kapetasan mu amilmilamonko. ");
INSERT INTO wsk_vpl VALUES ("PS89_16","020_89_16","PSA","89","16","16","Kariimet imitang mu ni ko ko pempem irua amilmil te bagasan, ale nika munan ningo mu ko ka nip patawusan. ");
INSERT INTO wsk_vpl VALUES ("PS89_17","020_89_17","PSA","89","17","17","Mu awuk, ni ka nikim se ka sokel aora garagar mu te nanga sangorsam; nika gemang motam nangara ko munan mu te nanga king nup biya tuem. ");
INSERT INTO wsk_vpl VALUES ("PS89_18","020_89_18","PSA","89","18","18","O Yawe, ni keta anananga karem bagasam; ni Israel ko Kaem Laili, se ni keta king ana nangarem. ");
INSERT INTO wsk_vpl VALUES ("PS89_19","020_89_19","PSA","89","19","19","Girakala, ipingira bo te, nika kariimet alo iwita nunga manem, “Ani nenenga kari nuar bo atumukirem ale sokel tuem; nu nenenga kari dom ko bagarukko. ");
INSERT INTO wsk_vpl VALUES ("PS89_20","020_89_20","PSA","89","20","20","Ani aga ura kari David arigem ale tam muguri ko welang laili mu supuling te warem, ale marak tuem. ");
INSERT INTO wsk_vpl VALUES ("PS89_21","020_89_21","PSA","89","21","21","Ale ani nu kuting duap ningi nunguning iluwek ale aninga sokel nu tuek se nu sokel karogo bagarukko. ");
INSERT INTO wsk_vpl VALUES ("PS89_22","020_89_22","PSA","89","22","22","Kager kari memek nu ilak kagermon mu me ta kiamonko; kariimet memek bitawara mu nu ilak me terong mamonko. ");
INSERT INTO wsk_vpl VALUES ("PS89_23","020_89_23","PSA","89","23","23","Ani noko kager kari memek nunga menawurik ale awiriya nu me ko kuesan mu nunga moa parusuwurikko. ");
INSERT INTO wsk_vpl VALUES ("PS89_24","020_89_24","PSA","89","24","24","Ani nu angamang tuek ale ilak bagarikko; ani pempem la nu sangik se nu sokel ago se nup biya karogo bagarukko. ");
INSERT INTO wsk_vpl VALUES ("PS89_25","020_89_25","PSA","89","25","25","Ani noko kingdom ulal awurek se gagi yu luan bibiya kiaruk ale sor saki te ago namarukko. ");
INSERT INTO wsk_vpl VALUES ("PS89_26","020_89_26","PSA","89","26","26","Se nu aninga manuk, “Ni aninga Ait, se aga Kaem; ni aninga Bitua se aga Saonga Kari,” maukko. ");
INSERT INTO wsk_vpl VALUES ("PS89_27","020_89_27","PSA","89","27","27","Ani nu aninga kuriang kari giram bilangaram ko iwita bitirikko, se ali imi ko king suen la nunga kiarukko. ");
INSERT INTO wsk_vpl VALUES ("PS89_28","020_89_28","PSA","89","28","28","Ani angamang motam mu noko pempem anirukko; ale den nu ilak kalem mu tom suen biya anirukko. ");
INSERT INTO wsk_vpl VALUES ("PS89_29","020_89_29","PSA","89","29","29","Se noko kuriang gue luan udagi mu aora biya bagamonko; noko kingdom mu taiti gomang aora biya aniso iwitata pempem anirukko. ");
INSERT INTO wsk_vpl VALUES ("PS89_30","020_89_30","PSA","89","30","30","“Bare noko kuriang gue aninga munan den me karo tumon, ale munan den baluwoso iwita me karomon, ");
INSERT INTO wsk_vpl VALUES ("PS89_31","020_89_31","PSA","89","31","31","agi aninga den suen biya mel yam ko betemon, ale aninga kiti guruga ko den ko me sinar tamon, ");
INSERT INTO wsk_vpl VALUES ("PS89_32","020_89_32","PSA","89","32","32","mu asele nunga memek koma bu nungarikko; ani nunga memek koma yaman ikup nungarikko. ");
INSERT INTO wsk_vpl VALUES ("PS89_33","020_89_33","PSA","89","33","33","“Bare aninga angamang David ko kua tuata mu me ta bita taikko; ani saruk nu ilak kanuwem mu uwutata anirukko. ");
INSERT INTO wsk_vpl VALUES ("PS89_34","020_89_34","PSA","89","34","34","Aninga den nu ilak kalem mu me ta kulukek, agi ko ponor bo me ta gurugekko, mena. ");
INSERT INTO wsk_vpl VALUES ("PS89_35","020_89_35","PSA","89","35","35","Agata aga aip laili nunguningkiri mu te saruk nu ilak kanuwem mu uwutata anirukko; ani David me ta kulekko: ");
INSERT INTO wsk_vpl VALUES ("PS89_36","020_89_36","PSA","89","36","36","Noko kuriang gue luan maiya kaparuk ale maiyukko; noko kingdom mu sokel tuek se tom suen biya anirukko, worem nikim kapa lagoso iwita, ");
INSERT INTO wsk_vpl VALUES ("PS89_37","020_89_37","PSA","89","37","37","se sige taiti gomang te kani lagoso iwitatala.” ");
INSERT INTO wsk_vpl VALUES ("PS89_38","020_89_38","PSA","89","38","38","Bare Yawe, ni kari keta king ko beterem wore ko gemang magaram; se ni nu merem ale biring tuem. ");
INSERT INTO wsk_vpl VALUES ("PS89_39","020_89_39","PSA","89","39","39","Nika ura kari ilak den kalem umu kulukem, ale noko king ko kitigat mu ali gege ningi saperem. ");
INSERT INTO wsk_vpl VALUES ("PS89_40","020_89_40","PSA","89","40","40","Ni noko wonong ko por bibiya parusuwurem maguwurem, se noko kawam aora bibiya mu papak mam kapa saparam. ");
INSERT INTO wsk_vpl VALUES ("PS89_41","020_89_41","PSA","89","41","41","Se awiriya noko sor wonong mu duap te lage umu karo nama se, mu noko melmasak tere gi ago namasan; se ali sor saki ko kariimet alo mu nu gusiru gilingisan. ");
INSERT INTO wsk_vpl VALUES ("PS89_42","020_89_42","PSA","89","42","42","Ni kari nu ilak kagerawara mu aking sokel nungarem, se aitak nuna ninguru amilmilasan. ");
INSERT INTO wsk_vpl VALUES ("PS89_43","020_89_43","PSA","89","43","43","Ni noko kager ko melmasak sokel menawurem, ale kager te nu me sangem. ");
INSERT INTO wsk_vpl VALUES ("PS89_44","020_89_44","PSA","89","44","44","Ni king ko sikir kuting te mu bataguru taem, ale ko daiga kuwim patawu ali te saperem. ");
INSERT INTO wsk_vpl VALUES ("PS89_45","020_89_45","PSA","89","45","45","Nu kari sokel ago, bare ni nu ikup tuem se kari garuk sokel mena iwita baga se dolara aromemek iramuram. ");
INSERT INTO wsk_vpl VALUES ("PS89_46","020_89_46","PSA","89","46","46","O Yawe, ni butata anananga ko pempem nimi kaluwu se lagerko e? Ni ana nago ko gemang butata tama ko kani se lagarukko e? ");
INSERT INTO wsk_vpl VALUES ("PS89_47","020_89_47","PSA","89","47","47","Anananga marak bagara ko tom mu tukunangta wore ni ko ikiko; ana ali ko kariimet nanga nungem se tom bo te kuenakko! ");
INSERT INTO wsk_vpl VALUES ("PS89_48","020_89_48","PSA","89","48","48","Kari awuk wore me kueruk pempem marak bagarukko ya? Mena. Ana suen la kuenak ale mutim ningi iwi namanakko pa! ");
INSERT INTO wsk_vpl VALUES ("PS89_49","020_89_49","PSA","89","49","49","O Biya, girakala ni ninguru nanga kuakasam, bare aitak awuk? Ni David ilak saruk kanuwem mu ko kamili saparam agi? ");
INSERT INTO wsk_vpl VALUES ("PS89_50","020_89_50","PSA","89","50","50","Ana nika ura kariimet se den dolara gisan mu ko kamili me saparukko; me ikia alo den ikup nangarsan se yam giwasan mu ko ikiko. ");
INSERT INTO wsk_vpl VALUES ("PS89_51","020_89_51","PSA","89","51","51","O Biya, kari king ilak kagerawara alo mu den dolara manorsan! Ale nu apareyate namoso agi taiso wore den ikup la tusan. ");
INSERT INTO wsk_vpl VALUES ("PS89_52","020_89_52","PSA","89","52","52","Yawe, ana nika nip pempem la patawu se laganakko! Nunguningta! Nunguningkiri! ");
INSERT INTO wsk_vpl VALUES ("PS90_1","020_90_1","PSA","90","1","1","(Kaem ko kari Moses ko guranek) O Biya, ni anananga bagara kuwim ningo; anananga girigir alo nunga tom te, tai aitak, se pempem la butata bagerko. ");
INSERT INTO wsk_vpl VALUES ("PS90_2","020_90_2","PSA","90","2","2","Duruk ali se mel suen la me aratu namaman ko tom te la, ni Kaem kimik menara mena butata bagasam. ");
INSERT INTO wsk_vpl VALUES ("PS90_3","020_90_3","PSA","90","3","3","Ni balsam se ana kariimet aking kupkup ko geragasan; ale balsam, “Nina kariimet ko gue, nina kueral ale ali ko aralko!” ");
INSERT INTO wsk_vpl VALUES ("PS90_4","020_90_4","PSA","90","4","4","1000 yia mu nika ikia loagara te mu kowarkalal suanta se tairate nama menaso iwita; agi sor ko bitua kari tirom sor bitaruwoso se tairate ukiso iwitatala. ");
INSERT INTO wsk_vpl VALUES ("PS90_5","020_90_5","PSA","90","5","5","Agi kariimet ipingisan ale tairate nungamili sapa namoso iwita, ni nanga sarumu warsam. Agi diri turomola wakala yawara beteso ale ulaloso, ");
INSERT INTO wsk_vpl VALUES ("PS90_6","020_90_6","PSA","90","6","6","bare bainga ningi mu kusuga namoso iwitatala. ");
INSERT INTO wsk_vpl VALUES ("PS90_7","020_90_7","PSA","90","7","7","Nika gemang magara mu tama kuamili iwita nanga lakumam, se ana ninguru nguangasan. ");
INSERT INTO wsk_vpl VALUES ("PS90_8","020_90_8","PSA","90","8","8","Ni anananga kiwem memek mu suen la ari sapasam, ale anananga memek yumura la betesan mu agotala ari sapasam. ");
INSERT INTO wsk_vpl VALUES ("PS90_9","020_90_9","PSA","90","9","9","Anananga bagara ali imi te mu nika gemang magara bowa ningi baga lagasan; ale nanga nangamang bataga se niara mu ago eng kua namasan. ");
INSERT INTO wsk_vpl VALUES ("PS90_10","020_90_10","PSA","90","10","10","Ana yia 70 iwita ko bagasan, se bo sail tagiso mu yia 80 taso; bare yia suen la mu ningi mu yaman ikup karogo la, se yia mu tairate menaso se ana mena namasan. ");
INSERT INTO wsk_vpl VALUES ("PS90_11","020_90_11","PSA","90","11","11","Awiri nika gemang magara mu ko iki saparukko terong? Mena. Nika gemang magara ko sokel mu aora biya, se ana mu ko iki se nika nguanganakko. ");
INSERT INTO wsk_vpl VALUES ("PS90_12","020_90_12","PSA","90","12","12","Ana tom maiya biya ali imi te me baganakko; mu ko ni ninguru nanga kasuru se, ana mu te ikia ningo nuam tanakko. ");
INSERT INTO wsk_vpl VALUES ("PS90_13","020_90_13","PSA","90","13","13","O Yawe, tom awila nunguningkiri nika gemang magara anirukko? Ana nika kariimet gemang lila nangaruko. ");
INSERT INTO wsk_vpl VALUES ("PS90_14","020_90_14","PSA","90","14","14","Ni turomola pempem ka kua nangara ko munan mu te, nanga sangaruko; se mu te ana marak baga se mu, wur ilu se amilmil kisu se laganakko. ");
INSERT INTO wsk_vpl VALUES ("PS90_15","020_90_15","PSA","90","15","15","Ana tom suen biya ikup nangaru lagerem, uwutatala aitak amilmil nangaruko; ana yia suen biya baga maguwu lagaman, uwutatala aitak mu amilmil karogo baga se laganakko. ");
INSERT INTO wsk_vpl VALUES ("PS90_16","020_90_16","PSA","90","16","16","Aitak nika ura bibiya sokel karogo mu, ana nika kariimet nanga kasuruko; ale nika sokel aora garagar nikim karogo mu, anananga kuriang imas ago nunga kasuruko. ");
INSERT INTO wsk_vpl VALUES ("PS90_17","020_90_17","PSA","90","17","17","O Biya, ni anananga Kaem, ka gemang lila nangaruko; se anananga ura mel kasik la betesan mu ningo la aratukko; butata marak sokel tui se aratu nangarukko. ");
INSERT INTO wsk_vpl VALUES ("PS91_1","020_91_1","PSA","91","1","1","Awiriya Kaem koma dugu te pempem bagoso mu Kaem Kalel Biya Sokel Garagar mu ko sinar tauk se nu luman bowa ningi yawarakala baga se, ");
INSERT INTO wsk_vpl VALUES ("PS91_2","020_91_2","PSA","91","2","2","Yawe ko iwita balukko, “Ni aninga yumura kuwim, se aga ngatalek aora; ni aninga Kaem, ani ni ko ko angamang ningi nunguning.” ");
INSERT INTO wsk_vpl VALUES ("PS91_3","020_91_3","PSA","91","3","3","Nunguningta, Kaem tareng memek ni ko ko kaluwu beteman mu ko ka sinar tauk ale ka bituok se kuera memek me kimik te tairukko. ");
INSERT INTO wsk_vpl VALUES ("PS91_4","020_91_4","PSA","91","4","4","Nu tarak ko gotek ereso iwitata, ka iramurok se ni ko luman bowa ningi yawarakala bagerko; nu me ka bitirukko, am ka iramurok ale ka sinar taukko. ");
INSERT INTO wsk_vpl VALUES ("PS91_5","020_91_5","PSA","91","5","5","Se ni mel memek tirom ka maguwurokko tairuk mu ko me nguangerko; ale gatu woremkalal ka morukko tairuk, mu ko betela me nguangerko. ");
INSERT INTO wsk_vpl VALUES ("PS91_6","020_91_6","PSA","91","6","6","Se kuera memek tirom ka maguwurokko tairuk, mu me ko nguangerko, woremkalal tairuk mu betela me ko nguangerko. ");
INSERT INTO wsk_vpl VALUES ("PS91_7","020_91_7","PSA","91","7","7","Se kariimet 1000 iwita ni beta dugu te kuemon, 10,000 iwita kiting sengam mu te dagulu kuemon, bare ni mu memek me toko. ");
INSERT INTO wsk_vpl VALUES ("PS91_8","020_91_8","PSA","91","8","8","Kariimet memek alo koma memek tamonko, se ni mu am motam la nungarkiwerko. ");
INSERT INTO wsk_vpl VALUES ("PS91_9","020_91_9","PSA","91","9","9","Ni Yawe nika Kaem Kalel Biya mu nika bagara kuwim se nika yumura kuwim iwita ko arik, ");
INSERT INTO wsk_vpl VALUES ("PS91_10","020_91_10","PSA","91","10","10","mu ni memek bo me arikko, se memek bo nika kawam duap te me tairukko. ");
INSERT INTO wsk_vpl VALUES ("PS91_11","020_91_11","PSA","91","11","11","Nu ko engel alo nunga manuk se nika namara taira mu te ka bitaru se lagamonko. ");
INSERT INTO wsk_vpl VALUES ("PS91_12","020_91_12","PSA","91","12","12","Nuna kiting duap ningi ka ilumon se manga te siwik motam atum mu me dagulko. ");
INSERT INTO wsk_vpl VALUES ("PS91_13","020_91_13","PSA","91","13","13","Ni lion se mot memek nunga nusupuling ita parusuwurko, lion sokel ago se mot memek bibiya karogo la. ");
INSERT INTO wsk_vpl VALUES ("PS91_14","020_91_14","PSA","91","14","14","Se Yawe iwita balam, “Ani nu sangaru taik ale bituekko, mu awuk, nu aninga kueso ale ani abowa ningi bagoso. ");
INSERT INTO wsk_vpl VALUES ("PS91_15","020_91_15","PSA","91","15","15","Nu aninga aurok mu ani kuring iluwekko; nu memek ningi kaparuk, mu ani ilak baga se bataguru taik ale nup biya tuekko. ");
INSERT INTO wsk_vpl VALUES ("PS91_16","020_91_16","PSA","91","16","16","Ale balik se amilmil te tom maiya biya ali imi te baga se, ani noko saonga yawara mu ko iki se lagarukko.” ");
INSERT INTO wsk_vpl VALUES ("PS92_1","020_92_1","PSA","92","1","1","(Wur imi Sabbath tom ko wur) O Yawe, mel biya aninga angamang motam ningi mu ani amilmil ni kisek ale nip patawurik, ale wur duap duap nika nip te iluwekko, O aninga Kaem Kalel Biya. ");
INSERT INTO wsk_vpl VALUES ("PS92_2","020_92_2","PSA","92","2","2","Turomola pempem mu nika kua ana nangara ko munan mu ko balu pagik, ale tirom mu nika gemang nunguningkiri nangara ko munan mu ko balikko. ");
INSERT INTO wsk_vpl VALUES ("PS92_3","020_92_3","PSA","92","3","3","Ale bawe se gita mel te yagowom yawara gurugek ale nika nip patawurikko. ");
INSERT INTO wsk_vpl VALUES ("PS92_4","020_92_4","PSA","92","4","4","Mu awuk, nika kiwem bibiya te ani amilmil aisisam; se ani nika ura bibiya ni keta kiting te beterem mu ko amilmil wur ilusam. ");
INSERT INTO wsk_vpl VALUES ("PS92_5","020_92_5","PSA","92","5","5","O Yawe, nika ura mu bibiya se yawarakala; nika ikia mu du biya, kalel biya, se ulal biya nunguningkiri! ");
INSERT INTO wsk_vpl VALUES ("PS92_6","020_92_6","PSA","92","6","6","Kariimet ikia ningo nongote mena mu me ta ko ikimonko; kariimet ngualara sipira mu me ta ko sinarmonko: ");
INSERT INTO wsk_vpl VALUES ("PS92_7","020_92_7","PSA","92","7","7","kariimet memek mu sirsir iwita pagamon, se memek bitawara ko kariimet mu yawarakala ko barasamonko, bare nuna me ikisan, nuna memek biya tamon ale menara biya menamonko. ");
INSERT INTO wsk_vpl VALUES ("PS92_8","020_92_8","PSA","92","8","8","Bare O Yawe, ni keta kalel biya nunguningkiri, ni pempem bagasam. ");
INSERT INTO wsk_vpl VALUES ("PS92_9","020_92_9","PSA","92","9","9","Nunguningta nunguning, kari ni kerak barimasan mu mena namamonko; memek bitawara ko kariimet mu parasa namamonko. ");
INSERT INTO wsk_vpl VALUES ("PS92_10","020_92_10","PSA","92","10","10","Bare ni sokel aisem se aninga asokel mu buffalo diwang ko sokel iwita; ni amilmil ningo wore aisem se ani amilmilasam. ");
INSERT INTO wsk_vpl VALUES ("PS92_11","020_92_11","PSA","92","11","11","Ani amotam te aga kager kari memek alo ikup yaman giman se nungarkem; ale adogowa te niaman se nunga niara ikiem. ");
INSERT INTO wsk_vpl VALUES ("PS92_12","020_92_12","PSA","92","12","12","Kariimet ningo diram bagara mu tam ningo naur iwita aragamon, ale Lebanon ko tam aora sida mu iwita tarigimonko. ");
INSERT INTO wsk_vpl VALUES ("PS92_13","020_92_13","PSA","92","13","13","Nuna Yawe ko kawam ningi tam ningo iwita araga se nunguning yawara kapa se lagamonko. ");
INSERT INTO wsk_vpl VALUES ("PS92_14","020_92_14","PSA","92","14","14","Nuna garukamon ta wore yam nunguning kapa se lagamonko; nuna tam iru, nunguning duap beteram ale kaposo iwita, sokel karogo la baga se, ");
INSERT INTO wsk_vpl VALUES ("PS92_15","020_92_15","PSA","92","15","15","ni ko ko iwita balmon, “Yawe ningo diram la baga lagoso; nu anananga manga gek am, se memek bo ta noko ningi me aniso,” ma balmonko. ");
INSERT INTO wsk_vpl VALUES ("PS93_1","020_93_1","PSA","93","1","1","Yawe nu King Biya; nu nup biya nunguningkiri se sokel garagar. Nu ali sokel ago nungam se gek am aniso, ale me namaruk tairukko. ");
INSERT INTO wsk_vpl VALUES ("PS93_2","020_93_2","PSA","93","2","2","O Yawe, ni duap te nunguningkiri bagakasam, ale mel suen biya me aratukaso la, ni tom suen biya ko king bagakasam. ");
INSERT INTO wsk_vpl VALUES ("PS93_3","020_93_3","PSA","93","3","3","Gagi mu nirung biyala kaposo, ko tamun sokel ago kelagoso se nirung biyala barasoso. ");
INSERT INTO wsk_vpl VALUES ("PS93_4","020_93_4","PSA","93","4","4","Bare ni mu am kualala biya, sokel ago nunguningkiri bagasam. ");
INSERT INTO wsk_vpl VALUES ("PS93_5","020_93_5","PSA","93","5","5","O Yawe, nika munan den mu tom suen biya ko; se nika temple tom suen biya laili nunguningkiri anirukko. ");
INSERT INTO wsk_vpl VALUES ("PS94_1","020_94_1","PSA","94","1","1","Yawe, ni kariimet memek bitawara mu koma memek nungara ko Kaem; buta se ni ka gemang magara nunga kasuru se arigimonko. ");
INSERT INTO wsk_vpl VALUES ("PS94_2","020_94_2","PSA","94","2","2","Kaem, ni kariimet nunga tutera ko Kaem, bares ale nunumi patawura ko kariimet ewere koma memek nungaruko. ");
INSERT INTO wsk_vpl VALUES ("PS94_3","020_94_3","PSA","94","3","3","O Yawe, tom awila nunguningkiri kariimet memek bitawara wore amilmil te bagamonko? Nononga tom awila aniso? ");
INSERT INTO wsk_vpl VALUES ("PS94_4","020_94_4","PSA","94","4","4","Nuna nunumi patawura ko den balu balu geragasan; ale nunumi ninguru patawusan. ");
INSERT INTO wsk_vpl VALUES ("PS94_5","020_94_5","PSA","94","5","5","Yawe, nuna nika kariimet nunga eresan nongorak kapasan, kariimet nika ma nunga balem wore nunga bita maguwusan. ");
INSERT INTO wsk_vpl VALUES ("PS94_6","020_94_6","PSA","94","6","6","Nuna imet gera mu se, kariimet iwareng tai nangarak bagara mu nunga mosan se kuesan, kuriang marmar mu agotala nunga mosan se kuesan. ");
INSERT INTO wsk_vpl VALUES ("PS94_7","020_94_7","PSA","94","7","7","Ale balsan, “Yawe me arigiso; Jacob ko Kaem mel ana bitawasan mu tawun biya me ko ikia taso,” masan. ");
INSERT INTO wsk_vpl VALUES ("PS94_8","020_94_8","PSA","94","8","8","Nina kariimet sikina alo, awuk se suwutata nguala sipa lagasan? Nina amaru te ikia ningo tal ale sinararalko? ");
INSERT INTO wsk_vpl VALUES ("PS94_9","020_94_9","PSA","94","9","9","Kaem nu ana nadogowa nungam mu nu kota due mena agi? Nu tala namotam nungam mu nu kota motam mena agila? ");
INSERT INTO wsk_vpl VALUES ("PS94_10","020_94_10","PSA","94","10","10","Kaem ali lilim munan tuiwoso mu, memek koma bu me ningaruk agi? Nu ali lilim ko kausa kari se, awuk, nu kota pa ikia ko tukunangaram agi? Mena. ");
INSERT INTO wsk_vpl VALUES ("PS94_11","020_94_11","PSA","94","11","11","Yawe nu kariimet suen la nunga ikia mu iki ari saposo; nu ko ikiso mu nononga ikia mu mel yam iwita. ");
INSERT INTO wsk_vpl VALUES ("PS94_12","020_94_12","PSA","94","12","12","O Yawe, kariimet ni ka munan den te nunga kiti gurugusam ale nunga dingumusam mu amilmilamonko. ");
INSERT INTO wsk_vpl VALUES ("PS94_13","020_94_13","PSA","94","13","13","Nuna ikup gisan, bare ni nunga sangorsam, ale nongorak bagasam la, kager kari memek mu mutim ningi nama sapasan. ");
INSERT INTO wsk_vpl VALUES ("PS94_14","020_94_14","PSA","94","14","14","Yawe ko kariimet me ta nunga bitiruk ale me ta buring gurugu nungarukko, mena. ");
INSERT INTO wsk_vpl VALUES ("PS94_15","020_94_15","PSA","94","15","15","Buta se ikup te nunga ko munan mu aking diram la aratuk se kariimet munan diram la karo tusan mu amilmilamonko. ");
INSERT INTO wsk_vpl VALUES ("PS94_16","020_94_16","PSA","94","16","16","Awiri ani ago ko barasuk ale kager kari memek nunga menawurokko? Awiri ani ago ko sanamaruk ale kiwem memek betera ko kariimet nongorak barimarukko? Kariimet bo mena. Yawe kota suanta. ");
INSERT INTO wsk_vpl VALUES ("PS94_17","020_94_17","PSA","94","17","17","Se nu ani me aga saongam le mu, ani maingkala kuera mutim ningi aniwasam le. ");
INSERT INTO wsk_vpl VALUES ("PS94_18","020_94_18","PSA","94","18","18","Ani asiwik palengam se “dagulasam” maem, bare Yawe, ni kua aisem ale agiting duap ningi aga iluwem. ");
INSERT INTO wsk_vpl VALUES ("PS94_19","020_94_19","PSA","94","19","19","Tom ani angamang motam kapakaso se magiwakasam mu, ni angamang motam patawukasam ale amilmil aisukasam. ");
INSERT INTO wsk_vpl VALUES ("PS94_20","020_94_20","PSA","94","20","20","Ni memek bitawara ko kari supuling mu nongorak me nimi kiting ilusam; nunga bitua bowa ningi mu kariimet ikup memek ari gilingisan. ");
INSERT INTO wsk_vpl VALUES ("PS94_21","020_94_21","PSA","94","21","21","Nuna kariimet kiwem memek betesan mu nunga sangorsan ale kariimet ningo mu kuera mateng ko lage te nunga betesan se kua namasan. ");
INSERT INTO wsk_vpl VALUES ("PS94_22","020_94_22","PSA","94","22","22","Bare Yawe mu aninga ngatalek aora; aninga Kaem mu aninga manga gek am, ani te aimi kaluwusam. ");
INSERT INTO wsk_vpl VALUES ("PS94_23","020_94_23","PSA","94","23","23","Nu nunga kiwem memek mu ko koma memek nungaruk ale nunga maguwurokko; Yawe, anananga Kaem, mu nunga menawu saparukko. ");
INSERT INTO wsk_vpl VALUES ("PS95_1","020_95_1","PSA","95","1","1","Tairal se Yawe nup patawunakko; sail te ainak amilmilanakko. Nu nanga Saonga se nanga Manga Gek wore ko wur ilunakko. ");
INSERT INTO wsk_vpl VALUES ("PS95_2","020_95_2","PSA","95","2","2","Ana nu koma te kasu nagunak ale amilmil tunakko; ale wur bawe te nup biya patawunakko. ");
INSERT INTO wsk_vpl VALUES ("PS95_3","020_95_3","PSA","95","3","3","Mu awuk, Yawe mu nu Kaem Biya sokel karogo; nu King, nu kaem kawel suen biya nunga kiaram. ");
INSERT INTO wsk_vpl VALUES ("PS95_4","020_95_4","PSA","95","4","4","Nu ali lilim la bitarso; sor gomeng du biya tai nama duruk kalel kalel te mu nu la bitaru saposo. ");
INSERT INTO wsk_vpl VALUES ("PS95_5","020_95_5","PSA","95","5","5","Gagi mu noko, mu nu nungam; se ali mu nu kota kuting te nungam ale bitarso. ");
INSERT INTO wsk_vpl VALUES ("PS95_6","020_95_6","PSA","95","6","6","Yawe kota nanga nungam, se tairal se koma dugu te nabugura kulukurnak ale nup patawunakko, ");
INSERT INTO wsk_vpl VALUES ("PS95_7","020_95_7","PSA","95","7","7","mu awuk, nu anananga Kaem, se ana mu noko kariimet; nu noko sipsip iwita nanga bitarso ale nanga sinar taso. Se aitakta nina ko aira ikial, mu karo tualko. ");
INSERT INTO wsk_vpl VALUES ("PS95_8","020_95_8","PSA","95","8","8","Nu iwita balso: “Nina nengemang aora biya me bagaralko! Girakala ninga taleng girigir sor garagarayam te, sor Meribah se Massah mu te baga se bitakasan mu turan te me beteralko! ");
INSERT INTO wsk_vpl VALUES ("PS95_9","020_95_9","PSA","95","9","9","Nuna ani kilek kilek sokel ago te nunga sangikko beterem mu ari gilingiman, bare aninga ira arikasan, ale angimik ko den duap duap balukasan. ");
INSERT INTO wsk_vpl VALUES ("PS95_10","020_95_10","PSA","95","10","10","Se yia 40 ningi ani kariimet mu nunga ko angamang magakaso se ani nunga balem, kariimet imi nunga ikia nongomang kirker namoso. Nuna aninga agiring karo tumonko mia gilingisan. ");
INSERT INTO wsk_vpl VALUES ("PS95_11","020_95_11","PSA","95","11","11","Se ani angamang magaram se den aora biya balem, nuna aninga kuwim mu te utu nagumon me nonoman sapamonko, ma balem.” ");
INSERT INTO wsk_vpl VALUES ("PS96_1","020_96_1","PSA","96","1","1","Wur iru bo ilu se Yawe nup patawuralko; ali lilim la ko wur iluwalko. ");
INSERT INTO wsk_vpl VALUES ("PS96_2","020_96_2","PSA","96","2","2","Yawe ko wur iluwal ale nup patawuralko; nu anananga sangaru tam mu ko pempem balu paogalko. ");
INSERT INTO wsk_vpl VALUES ("PS96_3","020_96_3","PSA","96","3","3","Noko nikim sokel se kiwem bibiya beteram mu kariimet lilim la nongoma te wetang saparalko. ");
INSERT INTO wsk_vpl VALUES ("PS96_4","020_96_4","PSA","96","4","4","Mu awuk, Yawe nup biya, se nup kualala biya patawura mu diram nunguningkiri; kaem kawel nunga ningi nu kota suanta Kaem nunguning, se ana nu la bowa ningi baganakko. ");
INSERT INTO wsk_vpl VALUES ("PS96_5","020_96_5","PSA","96","5","5","Ali sor saki nunga kaem mu kaem kawel, bare Yawe mu taiti mel suen la nungam. ");
INSERT INTO wsk_vpl VALUES ("PS96_6","020_96_6","PSA","96","6","6","Nu king biya nup ago se sokel ko duap; noko kuwim laili mu ningi nu nikim sokel ago bagoso. ");
INSERT INTO wsk_vpl VALUES ("PS96_7","020_96_7","PSA","96","7","7","Ali sor suen la ko kariimet, Yawe nikim sokel karogo se ko nup patawuralko. ");
INSERT INTO wsk_vpl VALUES ("PS96_8","020_96_8","PSA","96","8","8","Nu King nup biya se nikim ko duap; se munan mel gial ago tairal ale ko temple laili mu ningi kaparalko. ");
INSERT INTO wsk_vpl VALUES ("PS96_9","020_96_9","PSA","96","9","9","Noko munan laili se diram nunguningkiri mu ko iki se nup patawuralko; ali lilim la nu suwik duap ningi la kapa saparal ale nup patawuralko. ");
INSERT INTO wsk_vpl VALUES ("PS96_10","020_96_10","PSA","96","10","10","Sor suen la nunga ningi balal, “Yawe nu king!” malko. Nu ali sokel ago nungam se gek am aniso, ale me namaruk tairukko; nu kariimet diram la nunga tuterukko. ");
INSERT INTO wsk_vpl VALUES ("PS96_11","020_96_11","PSA","96","11","11","Taiti se mel suen la kualala mu amilmilaralko, se ali lilim la mu betela ko; se gagi kelage ale nirung bitar se, mel duap duap ningi mu suen la koma suanta betemonko. ");
INSERT INTO wsk_vpl VALUES ("PS96_12","020_96_12","PSA","96","12","12","Se ningam se na inang suen la ningi mu amilmilaralko; se tam bibiya giarum ningi mu suen la amilmil betemonko. ");
INSERT INTO wsk_vpl VALUES ("PS96_13","020_96_13","PSA","96","13","13","Se melmasak imi suen la Yawe amilmil tumonko. Nu taiso! Nu taiso mu ali lilim tuterukko. Nu munan diram la te ali lilim tuterukko, ale noko munan nunguning se diram mu te ko kariimet nunga giokko. ");
INSERT INTO wsk_vpl VALUES ("PS97_1","020_97_1","PSA","97","1","1","Yawe sor suen la bitaruwoso, buta se ali sor suen la amilmilaralko; lang korang se tual gotektek, amilmilaralko! ");
INSERT INTO wsk_vpl VALUES ("PS97_2","020_97_2","PSA","97","2","2","Taiti nuwi se sor tiromorom biya mu nu lautam ilak bagoso; nu kiwem ningo diram se tutera ningo mu noko barim, te ira sanamoso. ");
INSERT INTO wsk_vpl VALUES ("PS97_3","020_97_3","PSA","97","3","3","Tama nu koma ko giriso ale kager kari memek nu ilak barimawara mu suen la nunga kai saposo. ");
INSERT INTO wsk_vpl VALUES ("PS97_4","020_97_4","PSA","97","4","4","Nu pure nikim beteso se ali lilim la awote kaposo; se ali lilim arigiso ale uririkiso. ");
INSERT INTO wsk_vpl VALUES ("PS97_5","020_97_5","PSA","97","5","5","Yawe mu nu ali sor suen la ko Kari Biya, se duruk bibiya mu nu koma te parasa kapasan. ");
INSERT INTO wsk_vpl VALUES ("PS97_6","020_97_6","PSA","97","6","6","Taiti gomang mu noko munan ningo diram mu ko balu pagaruwoso, se kariimet sor suen la te mu noko nikinang biya mu arigisan. ");
INSERT INTO wsk_vpl VALUES ("PS97_7","020_97_7","PSA","97","7","7","Kariimet awiriya kaem kawel nunup patawuwasan mu dolomonko; nuna kuar anapeya te nunumi patawuwasan mu dolomonko; mu awuk, kaem kawel suen la mu Kari Biya koma te nubugura kulukurmonko. ");
INSERT INTO wsk_vpl VALUES ("PS97_8","020_97_8","PSA","97","8","8","Zion ko kariimet mu owore iki gilingiman ale amilmilasan, se Judah ko wonong suen la mu agotala ko amilmilasan, mu awuk, nuna nika tutera ko munan ninguru ko kuesan. ");
INSERT INTO wsk_vpl VALUES ("PS97_9","020_97_9","PSA","97","9","9","O Yawe, ni Kaem Kalel Biya, ni ali lilim pulawurem; ni kaem kawel suen la nunga kiarem ale kalel biya bagasam. ");
INSERT INTO wsk_vpl VALUES ("PS97_10","020_97_10","PSA","97","10","10","Awiriya Yawe ko kueso mu kiwem memek suen la buring tuokko; mu awuk, nu kariimet munan diram la karo tusan mu nunga bitarso, ale kariimet memek nuguting te nunga bataguru taso. ");
INSERT INTO wsk_vpl VALUES ("PS97_11","020_97_11","PSA","97","11","11","Kariimet ningo diram la bagasan mu nikinang te bagasan; uwutatala kariimet nongomang motam ningo diram mu amilmilasan. ");
INSERT INTO wsk_vpl VALUES ("PS97_12","020_97_12","PSA","97","12","12","Nina kariimet ningo diram la bagasan mu, Yawe ko amilmilaral, ale ko nup laili mu patawuralko. ");
INSERT INTO wsk_vpl VALUES ("PS98_1","020_98_1","PSA","98","1","1","Wur bo iru Yawe ilu tualko, mu awuk, nu ikia bibiya duap duap beteram se aratam; noko kuting sengam mu laili, kota ko kuting te ko kariimet nunga giam. ");
INSERT INTO wsk_vpl VALUES ("PS98_2","020_98_2","PSA","98","2","2","Yawe kiwem te ko kariimet nunga giam mu wetang awuram; ale ko kiwem ningo diram la mu sor suen la nunga kausam. ");
INSERT INTO wsk_vpl VALUES ("PS98_3","020_98_3","PSA","98","3","3","Nu ko den Israel kariimet nunga maonam, nu gomang nungaruk ale nunga sinar taukko mam, mu ko kuamin ares mam ale yawarakala nunga saongam ale nunga giam; se umutang te sor suen la ko kariimet noko saonga yawara beteram mu wetang te ari gilingiman. ");
INSERT INTO wsk_vpl VALUES ("PS98_4","020_98_4","PSA","98","4","4","Ali lilim ko kariimet suen la, nina Yawe ko amilmilaral ale ko wur iluwalko; wur te se amilmil ko ngata nirung te nup patawuralko. ");
INSERT INTO wsk_vpl VALUES ("PS98_5","020_98_5","PSA","98","5","5","Bawe moral ale wur iluwalko; gita se yukelele te yagowom ningo nungal ale ko nup patawuralko. ");
INSERT INTO wsk_vpl VALUES ("PS98_6","020_98_6","PSA","98","6","6","Trumpet se kua sokelel itugumal ale, sail te airal ale Yawe ko amilmilaralko. Nu anananga King. ");
INSERT INTO wsk_vpl VALUES ("PS98_7","020_98_7","PSA","98","7","7","Buta se gagi, ni nirung bitarko, se nina melmasak suen la ningi mu wur iluwalko; ale ali lilim la se, melmasak suen la awote mu karogo tala ngata beteralko! ");
INSERT INTO wsk_vpl VALUES ("PS98_8","020_98_8","PSA","98","8","8","Nina yu luan bibiya, nigiting moralko; nina duruk suen la, bolala la amilmil wur iluwalko! ");
INSERT INTO wsk_vpl VALUES ("PS98_9","020_98_9","PSA","98","9","9","Suen la Yawe koma te wur iluwalko, mu awuk, nu taiso mu ali lilim tuterukko. Nu ali ko kariimet lilim la kiwem ningo diram se munan yawarakala mu te nunga tuterukko. ");
INSERT INTO wsk_vpl VALUES ("PS99_1","020_99_1","PSA","99","1","1","Yawe sor suen la bitaruwoso, buta se sor suen la nguangamon ale barowara mamonko; nu ko daiga kuwim te daigam se engel bibiya nu laturman ale bagasan, buta se ali lilim uririkirokko. ");
INSERT INTO wsk_vpl VALUES ("PS99_2","020_99_2","PSA","99","2","2","Yawe ko sokel Zion ningi mu kalel biya; sor suen la mu noko nup patawusan. ");
INSERT INTO wsk_vpl VALUES ("PS99_3","020_99_3","PSA","99","3","3","Nuna suen la noko nup biya se yawarakala mu yam patawumonko. Nu laili pempem bagoso! ");
INSERT INTO wsk_vpl VALUES ("PS99_4","020_99_4","PSA","99","4","4","Nu mu anananga King sokel garagar; nu diram la tutera ko kiwem mu ko kueso ale ko sail tagiso; ale nu munan ningo se kiwem diram mu ana Israel nanga ningi beteram. ");
INSERT INTO wsk_vpl VALUES ("PS99_5","020_99_5","PSA","99","5","5","Buta se Yawe, anananga Kaem, ko nup kalel biya patawunak ale suwik duap ningi nabugura kulukurnak ale perr tunakko, mu awuk, nu laili nunguningkiri. ");
INSERT INTO wsk_vpl VALUES ("PS99_6","020_99_6","PSA","99","6","6","Moses se Aaron mu noko priest nunga ningi karogo bagakasan, se Samuel mu nunga bo tala, nuna Yawe arukasan se nuguring ilukaso. ");
INSERT INTO wsk_vpl VALUES ("PS99_7","020_99_7","PSA","99","7","7","Nu taiti nuwi ningi baga se nongorak munakakaso; se nuna noko munan den nungaram mu karo tuikasan. ");
INSERT INTO wsk_vpl VALUES ("PS99_8","020_99_8","PSA","99","8","8","O Yawe, anananga Kaem, ni ka kariimet nuguring ilukasam; ni Israel ko memek siwura ko Kaem; tom nuna memek bitakasan mu ni bu nungarukasam, bare aking nunga gikasam ale nunga memek siwu nungarukasam. ");
INSERT INTO wsk_vpl VALUES ("PS99_9","020_99_9","PSA","99","9","9","Buta se ana Yawe, anananga Kaem, ko nup kalel biya patawunak ale noko duruk laili mu te nabugura kulukurnak ale perr tunakko, mu awuk, Yawe, anananga Kaem, mu laili nunguningkiri. ");
INSERT INTO wsk_vpl VALUES ("PS100_1","020_100_1","PSA","100","1","1","Ali lilim ko kariimet, nina suen la amilmil nirung beteral ale Yawe nup patawuralko. ");
INSERT INTO wsk_vpl VALUES ("PS100_2","020_100_2","PSA","100","2","2","Amilmil wur te tairal ale koma te nup patawuralko. ");
INSERT INTO wsk_vpl VALUES ("PS100_3","020_100_3","PSA","100","3","3","Ale ikialko, “Yawe nu Kaem!” Nu kota nanga nungam, se ana noko; ana noko kariimet, se nu nanga bitarso. ");
INSERT INTO wsk_vpl VALUES ("PS100_4","020_100_4","PSA","100","4","4","Ana nangamang amilmil biya te kasu nagunak ale ko temple laili ningi nup patawunakko. ");
INSERT INTO wsk_vpl VALUES ("PS100_5","020_100_5","PSA","100","5","5","Mu awuk, Yawe mu ningo, se noko kua nangara ko munan mu kumik menara mena; se ko munan nangarak pempem la baga lagara mu, gue suen la te ta, wore am koma suanta tai lagoso. ");
INSERT INTO wsk_vpl VALUES ("PS101_1","020_101_1","PSA","101","1","1","(David ko wur) O Yawe, ani nika kua nangara ko munan se ka bitua ningo diram mu ko, wur ilu se ka nip patawurikko. ");
INSERT INTO wsk_vpl VALUES ("PS101_2","020_101_2","PSA","101","2","2","Ani aimi ko sinar taik ale munan diram te la bagarikko angamang aniso, se tair ale aga sangaruko. Aninga ura luan ningi munan diram la aratuk se arigekko; ");
INSERT INTO wsk_vpl VALUES ("PS101_3","020_101_3","PSA","101","3","3","munan memek mu amotam te aratuk se me arigekko. Ani kariimet nubiring ni kisisan mu nunga betera kaora mu mesam, ale me ningi bagarikko. ");
INSERT INTO wsk_vpl VALUES ("PS101_4","020_101_4","PSA","101","4","4","Kariimet kawel kuruwim mu arungu me dugu karikko; ani kilek memek suen la abiring tuekko. ");
INSERT INTO wsk_vpl VALUES ("PS101_5","020_101_5","PSA","101","5","5","Se awiriya saki alo nubiring ko den memek balso, mu ani kuring kalikko; se awiriya numi patawura supuling lagara ko kilek mu te geragoso, mu ani yam amotam la me ariwirikko, ani karikko. ");
INSERT INTO wsk_vpl VALUES ("PS101_6","020_101_6","PSA","101","6","6","Ani kariimet ni kiring karo tusan mu la nunga kua se, balik se agarak bagamonko; kariimet nunga bagara aolak diram mu la aninga ura kariimet bagamonko. ");
INSERT INTO wsk_vpl VALUES ("PS101_7","020_101_7","PSA","101","7","7","Kawel kari memek bo ta ani king aga bitua bowa ningi me bagarukko, ale kariimet kuamili suring ilagala mu aninga amakete me ta bagarukko. ");
INSERT INTO wsk_vpl VALUES ("PS101_8","020_101_8","PSA","101","8","8","Ani turomola pempem barasik ale sor imi te kariimet memek alo nuguring kalikko; ale Yawe ko wonong ningi kariimet memek suen la nunga karik se watingi aratamonko. ");
INSERT INTO wsk_vpl VALUES ("PS102_1","020_102_1","PSA","102","1","1","(Yaman ikup memek ningi baga se, Kaem ko saonga ko guranek) O Yawe, aninga guranek ikiko; ni aninga sangaruko ka arusam. ");
INSERT INTO wsk_vpl VALUES ("PS102_2","020_102_2","PSA","102","2","2","Ani ikup biya ningi kaperem ale bagasam, se ni ani ago ko kema motam me kaluwurko. Degewa gurugu ani aisuko; tom ani airik mu ni tairate agiring ilupko. ");
INSERT INTO wsk_vpl VALUES ("PS102_3","020_102_3","PSA","102","3","3","Mu awuk, aninga marak bagara ko tom ali imi te mu, tairate tama bur iwita mena namoso; aga angimik sokel mu tama ningi barasuwoso iwita. ");
INSERT INTO wsk_vpl VALUES ("PS102_4","020_102_4","PSA","102","4","4","Aninga angamang motam mu, sirsir maraka namoso iwita marakam; ale ani agiring inang dulam. ");
INSERT INTO wsk_vpl VALUES ("PS102_5","020_102_5","PSA","102","5","5","Ani yaman karogo sail te nia kika lagasam, se angimik guang mu tairam angimik sokelel karogo numi iluwam. ");
INSERT INTO wsk_vpl VALUES ("PS102_6","020_102_6","PSA","102","6","6","Ani sor merang ko inangnang urkuk iwita, sor magaram kueneram wore ningi bagasam. ");
INSERT INTO wsk_vpl VALUES ("PS102_7","020_102_7","PSA","102","7","7","Ani taga anisam bare angimik anira mena; ani inangnang bo kota kawam gul te dagi pata lagoso iwita baga lagasam. ");
INSERT INTO wsk_vpl VALUES ("PS102_8","020_102_8","PSA","102","8","8","Kowarkalal maiya kager kari memek angamang maguwura den balu lagasan; nuna ninguru tala aip maguwusan ale am maga namarikko balsan. ");
INSERT INTO wsk_vpl VALUES ("PS102_9","020_102_9","PSA","102","9","9","Ani tama nuwi mu na ko iwita nasam, ale amononge yu mu yu ko nasam, ");
INSERT INTO wsk_vpl VALUES ("PS102_10","020_102_10","PSA","102","10","10","mu awuk, nika gemang magara mu aromemek, se ni aga tagi patawurem ale mel memek bo iwita due ko aga saperem. ");
INSERT INTO wsk_vpl VALUES ("PS102_11","020_102_11","PSA","102","11","11","Aninga marak bagara ko tom mu sor awuru iluwam taiso ko tiromorom iwita; ani sirsir merang maraka namoso wore iwitatala. ");
INSERT INTO wsk_vpl VALUES ("PS102_12","020_102_12","PSA","102","12","12","Bare O Yawe, ni king ko butata pempem baga se lagerko; kariimet gue luan udagi taiwasan mu nika nip biya mu balu iki se lagamonko. ");
INSERT INTO wsk_vpl VALUES ("PS102_13","020_102_13","PSA","102","13","13","Ni bares ale nika wonong Zion gemang tuiko, nu imet itiwik bo ni gemang tua iwita gemang tuiko; mu awuk, ko tom ni balu beterem mu tai aratam. ");
INSERT INTO wsk_vpl VALUES ("PS102_14","020_102_14","PSA","102","14","14","Nika kariimet alo Zion mu magaram kueneram bare am ko kuawasan; ale parasaram magaram bare ko nongomang am batagawoso. ");
INSERT INTO wsk_vpl VALUES ("PS102_15","020_102_15","PSA","102","15","15","Sor suen la mu Yawe ko nguangamonko; ali imi ko king suen la mu nika nikim aora garagar mu ko nguangamonko. ");
INSERT INTO wsk_vpl VALUES ("PS102_16","020_102_16","PSA","102","16","16","Mu awuk, Yawe mu Zion akingtala kalokko, noko nikim aora garagar mu te numi wetang saparukko. ");
INSERT INTO wsk_vpl VALUES ("PS102_17","020_102_17","PSA","102","17","17","Nu ko kariimet magaman kueneman mu nunga guranek ikiokko; nu nunga niara wosenga mu buring me tuokko. ");
INSERT INTO wsk_vpl VALUES ("PS102_18","020_102_18","PSA","102","18","18","Buta se kuriang gue luan udagi taiwasan mu nunga den imi bataguru beteralko se nunga tom udagi mu te, pempem kau tutia iki se Yawe nup patawu se lagamonko. ");
INSERT INTO wsk_vpl VALUES ("PS102_19","020_102_19","PSA","102","19","19","Den umu iwita bataguru beteralko: “Yawe kualala ko sor laili mu te loagaram se tai kaparam, duruk wonong te baga se ali arigam gurugam ale ");
INSERT INTO wsk_vpl VALUES ("PS102_20","020_102_20","PSA","102","20","20","kariimet talipara ningi kua namamonko bagaman mu nunga niara ikiam, ale nunga songkuring kaogam se arataman,” iwitata batogalko. ");
INSERT INTO wsk_vpl VALUES ("PS102_21","020_102_21","PSA","102","21","22","Umu te asele, tom kariimet nunga kingdom koma koma te nup patawumonko tai Jerusalem ilu biguwumon, mu nuna noko nup Zion ningi mu biyala balu pagarmon se nu nup biya taukko. ");
INSERT INTO wsk_vpl VALUES ("PS102_23","020_102_23","PSA","102","23","23","Ani kulak se asokel ago, bare nu aninga asokel menawuram; nu aninga marak bagara ko tom tukunang awuram tala. ");
INSERT INTO wsk_vpl VALUES ("PS102_24","020_102_24","PSA","102","24","24","Se ani iwita balem: “O aga Kaem, aninga tom luan kusumuri me bataguruko! Ni kimik menara mena; kuriang gue suen biya nama lagoso, bare ni am butata baga lagasam. ");
INSERT INTO wsk_vpl VALUES ("PS102_25","020_102_25","PSA","102","25","25","Duap te nunguningkiri girakala biya, ni ali imi ko nukuri yager beterem; se taiti gomang kualala mu, nika kiting kiwol. ");
INSERT INTO wsk_vpl VALUES ("PS102_26","020_102_26","PSA","102","26","26","Melmasak suen la umu mena namamonko, bare ni mu butata baga se lagerko; nuna suen la nanimi te ira ko guang iwita gigira amonko; se guang gigira aram se waru sapara ale iru gia ko iwita, ni nunga menawur se mena namamonko. ");
INSERT INTO wsk_vpl VALUES ("PS102_27","020_102_27","PSA","102","27","27","Bare ni am koma suanta bagasam, ale ni mu kimik menara mena. ");
INSERT INTO wsk_vpl VALUES ("PS102_28","020_102_28","PSA","102","28","28","Nika kariimet nunga kuriang mu ni kema te bagamonko; nononga gue te mu eng am ni kema te pempem butata baga se lagamonko.” ");
INSERT INTO wsk_vpl VALUES ("PS103_1","020_103_1","PSA","103","1","1","(David ko wur) Ani Yawe ko nup patawurikko; angamang motam lilim te noko nup laili mu patawurikko. ");
INSERT INTO wsk_vpl VALUES ("PS103_2","020_103_2","PSA","103","2","2","Ani Yawe ko nup patawurikko; noko munan ago ko beteram mu me ta ko angamili saparukko. ");
INSERT INTO wsk_vpl VALUES ("PS103_3","020_103_3","PSA","103","3","3","Nu aninga memek suen la kututuwuso, ale aga kuera ikes menawuso. ");
INSERT INTO wsk_vpl VALUES ("PS103_4","020_103_4","PSA","103","4","4","Nu kuera mutim ningi aga bataguru taso ale gomang aisu se kua aisu lagoso. ");
INSERT INTO wsk_vpl VALUES ("PS103_5","020_103_5","PSA","103","5","5","Nu munan ningo ningo angimik te beteso se ani taraga iwita kulak sokel ago la bagasam. ");
INSERT INTO wsk_vpl VALUES ("PS103_6","020_103_6","PSA","103","6","6","Yawe ko munan ningo diram mu te, kariimet nunga bita maguwusan mu nunga sangarso. ");
INSERT INTO wsk_vpl VALUES ("PS103_7","020_103_7","PSA","103","7","7","Nu ko munan, ko ikia mu Moses kausam, ale kilek bibiya Israel te nunga sangukko mu beteram se ari gilingiman. ");
INSERT INTO wsk_vpl VALUES ("PS103_8","020_103_8","PSA","103","8","8","Yawe ko gomang bataga se ko gomang lila mu biya, se nu gomang tairate me magoso, se ninguru nanga kueso. ");
INSERT INTO wsk_vpl VALUES ("PS103_9","020_103_9","PSA","103","9","9","Nu ana ining me nangaru lagoso, ale ko gomang magara me ilu lagoso. ");
INSERT INTO wsk_vpl VALUES ("PS103_10","020_103_10","PSA","103","10","10","Ana nanga memek koma memek tanakko, bare nu memek me nangarso; ana memek suen biya mu ko koma, memek biya tanakko, bare uwuta me beteso, mena. ");
INSERT INTO wsk_vpl VALUES ("PS103_11","020_103_11","PSA","103","11","11","Taiti kalel biya ali kiaram iwita, noko kua nangara ana kariimet nu bowa ningi bagasan mu nanga iramuram. ");
INSERT INTO wsk_vpl VALUES ("PS103_12","020_103_12","PSA","103","12","12","Koma worem bausa se worem kapara mu awar bibiya iwita, nu nanga memek mu siwu waram se awar bibiya namaram. ");
INSERT INTO wsk_vpl VALUES ("PS103_13","020_103_13","PSA","103","13","13","Se kari bo ko kuriang gomang nungarso iwitatala, Yawe ana kariimet nu bowa ningi bagasan mu gomang nangarso. ");
INSERT INTO wsk_vpl VALUES ("PS103_14","020_103_14","PSA","103","14","14","Mu awuk, nu aguwaya anananga nungam mu ko ikiso, ale nu ko ikiso mu ana ali te nanga nungam. ");
INSERT INTO wsk_vpl VALUES ("PS103_15","020_103_15","PSA","103","15","15","Sirsir tom tukunangta baga marakaso iwita, ana kariimet nanga marak bagara ko tom mu uwutata. Ana diri wakala tom tukunangta baga, ");
INSERT INTO wsk_vpl VALUES ("PS103_16","020_103_16","PSA","103","16","16","marir nanga ituguso se piri palaga namasan se udagi me nangarkasan iwita. ");
INSERT INTO wsk_vpl VALUES ("PS103_17","020_103_17","PSA","103","17","17","Bare kariimet Yawe bowa ningi bagasan, mu nu pempem nunga kua lagoso; ale ko ningo nuam mu nunga kuriang imas mu karogo la nongote beteso. ");
INSERT INTO wsk_vpl VALUES ("PS103_18","020_103_18","PSA","103","18","18","Awiriya noko den kaolam mu ko sinar taso ale ko kuring karo tuso, mu nu uwutata nunga beteso. ");
INSERT INTO wsk_vpl VALUES ("PS103_19","020_103_19","PSA","103","19","19","Yawe duruk wonong te baga se mel singir la nu la bitarso. ");
INSERT INTO wsk_vpl VALUES ("PS103_20","020_103_20","PSA","103","20","20","Nina Yawe ko engel sokel ago, nu kuring bowa ningi baga se noko den karo tusan, mu noko nup patawuralko. ");
INSERT INTO wsk_vpl VALUES ("PS103_21","020_103_21","PSA","103","21","21","Nina suen la nu ilak baga se kuring karo se ura betesan, mu noko nup patawuralko. ");
INSERT INTO wsk_vpl VALUES ("PS103_22","020_103_22","PSA","103","22","22","Nina melmasak suen la nu nungam se noko bitua bowa ningi bagasan, mu noko nup patawuralko. Se ani mu betela ko nup patawurikko. ");
INSERT INTO wsk_vpl VALUES ("PS104_1","020_104_1","PSA","104","1","1","Ani angamang motam lilim la te Yawe nup patawurikko. O Yawe aninga Kaem, ni nip biya; ni King Biya, se sokel karogo. ");
INSERT INTO wsk_vpl VALUES ("PS104_2","020_104_2","PSA","104","2","2","Ni kakirip bo yamel siraram biya te numi ira iwita, ni ka nikim biya mu te nimi irem ale nikinang biya ningi bagasam; ni taiti gomang kari bo kawam sel tagi kam tagirem, ");
INSERT INTO wsk_vpl VALUES ("PS104_3","020_104_3","PSA","104","3","3","ale yu biya kualala mu ko kuali nunguningkiri ka wonong kalem. Se taiti nuwi mu nika karis iwita, se daula ka giso kerak namoso taiso. ");
INSERT INTO wsk_vpl VALUES ("PS104_4","020_104_4","PSA","104","4","4","Ni balsam se marir daula mu nika den gi karogo nama taisan; se tama kuamili nikim aora biya mu nika ura kari ko bagasan. ");
INSERT INTO wsk_vpl VALUES ("PS104_5","020_104_5","PSA","104","5","5","Ni ali imi ko nukuri nungem ale nukuri mu awote ali imi nungem; se me ta namoso taiso, mena. ");
INSERT INTO wsk_vpl VALUES ("PS104_6","020_104_6","PSA","104","6","6","Ni girakala yu mu guang iwita te duruk ali lilim la iramurem se aniram; yu mu duruk suen la nunga iramuram. ");
INSERT INTO wsk_vpl VALUES ("PS104_7","020_104_7","PSA","104","7","7","Bare ni aking sail ago, pure paga kam, yu tagi taukko balem, se palenga namaram ale ");
INSERT INTO wsk_vpl VALUES ("PS104_8","020_104_8","PSA","104","8","8","duruk bibiya ko gamung kaoram nama sor wolong ningi kapa nama, ko kuwim ni maingkala nunguru beterem mu te ilu biguwuram. ");
INSERT INTO wsk_vpl VALUES ("PS104_9","020_104_9","PSA","104","9","9","Ni yu ko munan gek am beterem, se me ta kia kaparuk ale ali lilim udagi me ta ira kaluwurokko. ");
INSERT INTO wsk_vpl VALUES ("PS104_10","020_104_10","PSA","104","10","10","Ni yu ali ningi nungem, se tengesan ale koropong ningi kapasan, ale duruk kulupik ningi nagusan nama kapasan. ");
INSERT INTO wsk_vpl VALUES ("PS104_11","020_104_11","PSA","104","11","11","Se donkey diwang se giarum ko mel suen biya yu mu nasan, ale udagi yu ko me kuesan. ");
INSERT INTO wsk_vpl VALUES ("PS104_12","020_104_12","PSA","104","12","12","Se inangnang binga geragasan mu yu mu duap te tam kuali singir mosan ale baga se, tam kower te dagi dagi wur ilu gilingisan. ");
INSERT INTO wsk_vpl VALUES ("PS104_13","020_104_13","PSA","104","13","13","Se ni ka wonong kuali biya mu te baga se, tuwik te duruk mel yu nungarsam, se ali awote tam mayang mel suen la amilmil te nunguning kapasan. ");
INSERT INTO wsk_vpl VALUES ("PS104_14","020_104_14","PSA","104","14","14","Ni balsam se sirsir mel bulmakau namonko mu aragoso, ale mel duap duap ko yango, kariimet sapa namonko, mu aragoso: ");
INSERT INTO wsk_vpl VALUES ("PS104_15","020_104_15","PSA","104","15","15","waen, kariimet amilmil nungarso mu se, olive oil, kariimet nungumik sapasan mu se, barley, bread ko kaisan nasan ale sokel karogo bagasan. ");
INSERT INTO wsk_vpl VALUES ("PS104_16","020_104_16","PSA","104","16","16","Se Yawe ko tam sida Lebanon sor te aguwam mu yu karogo terong ma saposo. ");
INSERT INTO wsk_vpl VALUES ("PS104_17","020_104_17","PSA","104","17","17","Se inangnang seng kuali singir mosan ale kuwim tasan. ");
INSERT INTO wsk_vpl VALUES ("PS104_18","020_104_18","PSA","104","18","18","Se duruk kalel bibiya mu goat diwang nunga kuwim; se manga gogong mu mel gotektek sang nunga yumura kuwim. ");
INSERT INTO wsk_vpl VALUES ("PS104_19","020_104_19","PSA","104","19","19","Ni sige se ko bagara aolak mu ana mel duap duap ko tom nanga kausokko beterem; se worem mu tom nu te nama kaparukko mu ko ikiso. ");
INSERT INTO wsk_vpl VALUES ("PS104_20","020_104_20","PSA","104","20","20","Ni tiromorom tagisam se ana tirom nangarso, se giarum ko mel suen la aratasan ale nasan gisan. ");
INSERT INTO wsk_vpl VALUES ("PS104_21","020_104_21","PSA","104","21","21","Se lion mu mel moa namonko sail te niasan ale inang Kaem nungaram wore ko loagasan; ");
INSERT INTO wsk_vpl VALUES ("PS104_22","020_104_22","PSA","104","22","22","se turomola worem numi diruwuso mu aking pila nunga kuwim yumura te taga anisan. ");
INSERT INTO wsk_vpl VALUES ("PS104_23","020_104_23","PSA","104","23","23","Asele kariimet mu nunga ningam ura mel ko barasasan ale ura iluwasan la baingaso. ");
INSERT INTO wsk_vpl VALUES ("PS104_24","020_104_24","PSA","104","24","24","O Yawe, nika ura mu am ningi awote nunguningkiri! Ni ka ikia sinar te la mel nunguru saperem; ali imi nika mel duap duap ago terong ma saparam. ");
INSERT INTO wsk_vpl VALUES ("PS104_25","020_104_25","PSA","104","25","25","Ayo, gagi mu aromemek se ulal biya; mel karanga nama taisan se, mel bibiya se gotektek talip ago, kaura moke mena, mu ningi bagasan. ");
INSERT INTO wsk_vpl VALUES ("PS104_26","020_104_26","PSA","104","26","26","Yagor dal awote namasan taisan, se gagi ko mel bibiya Leviathan masan, ni nunga nungem, mu ningi tinga kola gilingisan. ");
INSERT INTO wsk_vpl VALUES ("PS104_27","020_104_27","PSA","104","27","27","Mel bibiya se gotektek suen la ni nunga nungem imi mu, na ko kuesan mu ni kiting te la na nasan ale nikate la loaga lagasan. ");
INSERT INTO wsk_vpl VALUES ("PS104_28","020_104_28","PSA","104","28","28","Se tom ni na nungarsam mu nuna gi nasan; tom ni kiting urukusam, mu nana mel ningo ningo karogo terong masan. ");
INSERT INTO wsk_vpl VALUES ("PS104_29","020_104_29","PSA","104","29","29","Bare ni biring gurugu nungarsam, mu nuna biririkasan ale nguangasan; tom ni nunga marak gotek te bagasan mu tagi kutuwusam, mu nuna kuesan ale kupkup ko geragasan. ");
INSERT INTO wsk_vpl VALUES ("PS104_30","020_104_30","PSA","104","30","30","Bare tom nika marak betesam se tai kaposo, mu mel suen la aking ali karogo terong ma saposo. ");
INSERT INTO wsk_vpl VALUES ("PS104_31","020_104_31","PSA","104","31","31","Mel ningo nunguningkiri mu, Yawe ko nikim garagar tom suen biya anirukko; aninga angamang nu mel suen biya nungam mu ko ninguru amilmilarukko. ");
INSERT INTO wsk_vpl VALUES ("PS104_32","020_104_32","PSA","104","32","32","Nu nup biya sokel garagar, se motam te la ali arigiso mu ali uririkiso; ale duruk kau taso mu tama bur barasoso. ");
INSERT INTO wsk_vpl VALUES ("PS104_33","020_104_33","PSA","104","33","33","Tom ani marak bagasam imi mu ani Yawe ko wur ilu se lagarikko; ani tom suen biya aga Kaem ko wur ilu se ko nup patawurikko! ");
INSERT INTO wsk_vpl VALUES ("PS104_34","020_104_34","PSA","104","34","34","Ani Yawe ko ninguru amilmila se, kutek maem ale nu ko ko ikia bita lagerem, wore aninga angamang nu ko amilmilarukko. ");
INSERT INTO wsk_vpl VALUES ("PS104_35","020_104_35","PSA","104","35","35","Bare kariimet ikia memek betesan mu ali imi te am mena namamonko. Ani angamang motam lilim la te Yawe ko nup patawurikko! Aleluya! ");
INSERT INTO wsk_vpl VALUES ("PS105_1","020_105_1","PSA","105","1","1","Yawe amilmil tual ale noko nup biyala patawuralko! Noko munan beteram wore sor suen la ko kariimet nunga maonal se ikimonko. ");
INSERT INTO wsk_vpl VALUES ("PS105_2","020_105_2","PSA","105","2","2","Wur iluwal ale nup patawuralko; mel bibiya beteram mu ko balalko. ");
INSERT INTO wsk_vpl VALUES ("PS105_3","020_105_3","PSA","105","3","3","Nina noko kariimet ko bagasan, se noko ninguru amilmilaral ale ko nup laili patawuralko. ");
INSERT INTO wsk_vpl VALUES ("PS105_4","020_105_4","PSA","105","4","4","Yawe ninga sangukko kote namaral ale nu te la ira sanami se lagaralko. ");
INSERT INTO wsk_vpl VALUES ("PS105_5","020_105_5","PSA","105","5","5","O Israel, nina Kaem kilek bibiya ningo ningo beteram mu ko ningamin tugumal ale nu kuring kuluka ko kariimet alo memek nungaram mu ko ago ikialko. ");
INSERT INTO wsk_vpl VALUES ("PS105_6","020_105_6","PSA","105","6","6","Nina noko kariimet, ko ura kari Abraham tuagu te, kapa Jacob tuagu te ko kariimet. ");
INSERT INTO wsk_vpl VALUES ("PS105_7","020_105_7","PSA","105","7","7","Nu Yawe, anananga Kaem; nu ali lilim la iramuram ale bitaruwoso. ");
INSERT INTO wsk_vpl VALUES ("PS105_8","020_105_8","PSA","105","8","9","Noko den Abraham ilak kaolam mu tom suen biya anirukko, Isaac ilak kaolam mu betela nu me ko kuamili saparukko, mena. Mu den mu am tom suen biya anirukko. ");
INSERT INTO wsk_vpl VALUES ("PS105_10","020_105_10","PSA","105","10","10","Akingtala nu Jacob ilak den mu kaolam, ale den mu Israel ko kuriang imas nongote tom suen biya anirukko mam. ");
INSERT INTO wsk_vpl VALUES ("PS105_11","020_105_11","PSA","105","11","11","Ale balam, “Ani ali sor Canaan mu ni se ka kuriang gue arungu ningarikko,” mam. ");
INSERT INTO wsk_vpl VALUES ("PS105_12","020_105_12","PSA","105","12","12","Tom mu te gue me pagakaso, se nuna ilagalata, se kariimet iwareng iwita Canaan kariimet nunga ningi bagakasan. ");
INSERT INTO wsk_vpl VALUES ("PS105_13","020_105_13","PSA","105","13","13","Bare sor suanta te me bagakasan; king bo ko bilik te baga barasu nama bo kote, uwuta uwuta geraga bagakasan. ");
INSERT INTO wsk_vpl VALUES ("PS105_14","020_105_14","PSA","105","14","14","Bare Yawe me nunga bitakaso ewere te se, kariimet bo me ta nunga bita maguwukaso; nononga ningo ko nu king alo den sail ago nunga maonam ale mam, ");
INSERT INTO wsk_vpl VALUES ("PS105_15","020_105_15","PSA","105","15","15","“Nina kariimet motam gotek aninga ma balem imi me ta nunga kau talko; ale aga prophet alo memek bo nungumik te me beteralko,” mam. ");
INSERT INTO wsk_vpl VALUES ("PS105_16","020_105_16","PSA","105","16","16","Udagi te nu balam se karak biya nunga sor te kaparam, ale nunga inang mel suen la mena saparam. ");
INSERT INTO wsk_vpl VALUES ("PS105_17","020_105_17","PSA","105","17","17","Bare nu maingkala ikia bo giram beteram, mu Joseph ura dungan kari iwita ko diaman ale ilak Egypt namaman se bagakaso. ");
INSERT INTO wsk_vpl VALUES ("PS105_18","020_105_18","PSA","105","18","18","Se ko sowek sen te kaloman, ale ain biya mu dogotak tuguman, se yaman kua se baga, ");
INSERT INTO wsk_vpl VALUES ("PS105_19","020_105_19","PSA","105","19","19","den suen la nu kuring te aratam mu nunguning kaparam; se mu te Yawe ko den Joseph ko balam mu nunguning aram. ");
INSERT INTO wsk_vpl VALUES ("PS105_20","020_105_20","PSA","105","20","20","Se Egypt ko king mu balam se Joseph talipara ningi mu beteman se aratam; nu kariimet nunga king biya se balam se uwutata aratam. ");
INSERT INTO wsk_vpl VALUES ("PS105_21","020_105_21","PSA","105","21","21","Nu Joseph nu bowa ningi kari dom ko beteram se ko mel suen biya bitarukaso. ");
INSERT INTO wsk_vpl VALUES ("PS105_22","020_105_22","PSA","105","22","22","Joseph king ko ura kari bibiya se king ikia sinar kari alo suen la nunga bitaru se nunga kiti gurugukaso. ");
INSERT INTO wsk_vpl VALUES ("PS105_23","020_105_23","PSA","105","23","23","Asele Jacob ko kariimet karogo Egypt namaram ale tom sang ko, Ham ko ali umu te bagakaso. ");
INSERT INTO wsk_vpl VALUES ("PS105_24","020_105_24","PSA","105","24","24","Se Yawe balam se noko kariimet gue mu pagam, ale suen biya nunguningkiri se Egypt alo kariimet umu arigiman ale nguangakasan. ");
INSERT INTO wsk_vpl VALUES ("PS105_25","020_105_25","PSA","105","25","25","Ale nunga nongomang magakaso, se kawel kiwem te ninguru nunga bita maguwukasan. ");
INSERT INTO wsk_vpl VALUES ("PS105_26","020_105_26","PSA","105","26","26","Bare Yawe nu ko ura kari Moses se Aaron ilak ura nungaram ");
INSERT INTO wsk_vpl VALUES ("PS105_27","020_105_27","PSA","105","27","27","se nuna Ham ko ali Egypt ningi kiwem duap duap sokel ago bitakasan se aratukaso. ");
INSERT INTO wsk_vpl VALUES ("PS105_28","020_105_28","PSA","105","28","28","Nu tiromorom beteram se ali iramuram, mu awuk, nuna noko kuring me karo tuman. ");
INSERT INTO wsk_vpl VALUES ("PS105_29","020_105_29","PSA","105","29","29","Nu balam se yu suen la gue ko geragam, se wal suen la kua muruwuman. ");
INSERT INTO wsk_vpl VALUES ("PS105_30","020_105_30","PSA","105","30","30","Se nunga ali lilim mu gorogoro ago terong ma saparam; se king ko bagara kuwim ningi mu koma suanta. ");
INSERT INTO wsk_vpl VALUES ("PS105_31","020_105_31","PSA","105","31","31","Se aking balam se kuwuling kasim karogo la nunga sor umu ira saparam. ");
INSERT INTO wsk_vpl VALUES ("PS105_32","020_105_32","PSA","105","32","32","Nu balam se sor lilim la te tuwik yu mu geragam ais muguri ko kapakaso, se pure biliwilik makaso ale sor irakaso; ");
INSERT INTO wsk_vpl VALUES ("PS105_33","020_105_33","PSA","105","33","33","se nunga tam waen se nunga tam fig mu maga saparam, se tam suen la mu kilikilik ma saparam. ");
INSERT INTO wsk_vpl VALUES ("PS105_34","020_105_34","PSA","105","34","34","Nu balam se locust sor lilim la iram ale kaura tutera ko moke mena; ");
INSERT INTO wsk_vpl VALUES ("PS105_35","020_105_35","PSA","105","35","35","nuna tam gawa, sirsir, se na na gia mel suen la mu no sapaman. ");
INSERT INTO wsk_vpl VALUES ("PS105_36","020_105_36","PSA","105","36","36","Asele nu balam se Egypt nunga kuriang kari gira bilangara mu kua parangaman. ");
INSERT INTO wsk_vpl VALUES ("PS105_37","020_105_37","PSA","105","37","37","Se nu Israel alo nunga giam ale arungu aratam; nuna bala ko mel duap duap silver se gold te nunga mu ago lilim aolak taman; nunga kariimet gue 12 mu ningi bo ta me memek arigam. ");
INSERT INTO wsk_vpl VALUES ("PS105_38","020_105_38","PSA","105","38","38","Se tom nuna aolak iluman mu Egypt kariimet nususuru dirmam, mu awuk, nuna Israel nungumik te ikup ninguru arigiman ale nguangakasan. ");
INSERT INTO wsk_vpl VALUES ("PS105_39","020_105_39","PSA","105","39","39","Nu taiti nuwi te nunga bitarukaso, ale tirom tama nikinang te nikim nungarukaso. ");
INSERT INTO wsk_vpl VALUES ("PS105_40","020_105_40","PSA","105","40","40","Nuna na inang ko nu isarman, se nu inangnang duap bo mu suen biya nungaru se, duruk wonong ko inang manna mu karogo nungaram. ");
INSERT INTO wsk_vpl VALUES ("PS105_41","020_105_41","PSA","105","41","41","Nu manga moram se yu palengam aratukaso ale sor garagarayam te yu biya bo iwita nagu namakaso. ");
INSERT INTO wsk_vpl VALUES ("PS105_42","020_105_42","PSA","105","42","42","Nu uwuta nunga bitarukaso, mu awuk, nu ko den ko ura kari Abraham ilak kaolam owore karo tuikaso. ");
INSERT INTO wsk_vpl VALUES ("PS105_43","020_105_43","PSA","105","43","43","Nu ko kariimet nunga giam ale arungu namakaso, se amilmil kelaga se namakasan. ");
INSERT INTO wsk_vpl VALUES ("PS105_44","020_105_44","PSA","105","44","44","Nu kariimet iwareng nunga ali sor umu bataguru ko kariimet nungaram, ale nunga ura kowar bita lagaman mu nu ko kariimet nungaram se kotam awuman. ");
INSERT INTO wsk_vpl VALUES ("PS105_45","020_105_45","PSA","105","45","45","Nu uwuta ko kariimet nungumik te beteram mu ko duap mu, nu nuna ko kuring karo se ko den iki karo tumonko beteram. Se ana Yawe nup patawunakko! ");
INSERT INTO wsk_vpl VALUES ("PS106_1","020_106_1","PSA","106","1","1","Ana Yawe nup patawunakko! Nanga Biya amilmil tunakko, mu awuk, nu Kaem ningo; noko kua nangara ko munan mu kumik menara mena. ");
INSERT INTO wsk_vpl VALUES ("PS106_2","020_106_2","PSA","106","2","2","Yawe kiwem bibiya beteram mu awiri ko balu saparukko terong? agi awiri noko nup biya mu lilim la wetang saparukko terong? ");
INSERT INTO wsk_vpl VALUES ("PS106_3","020_106_3","PSA","106","3","3","Kariimet kiwem ningo diram mu ko munan ilukuawusan, ale sinar la karo tui lagasan, mu amilmilamonko. ");
INSERT INTO wsk_vpl VALUES ("PS106_4","020_106_4","PSA","106","4","4","O Yawe, tom ni ka ningo mu ka kariimet nunga kasuruko mu, ani ago ko kamili me saparukko; ni nunga sangaru toko tom te mu, ani agotala aga sangaru toko. ");
INSERT INTO wsk_vpl VALUES ("PS106_5","020_106_5","PSA","106","5","5","Ni uwuta aga bitar mu, ani awiriya ni nunga atumukirem mu nunga daiga bagara ningo mu ningi agotala bagarikko; ale ka sor ko balem mu nunga amilmil ningi karogo baga se, nika kariimet keta ka ma balem, mu nongorak nika nip patawurikko. ");
INSERT INTO wsk_vpl VALUES ("PS106_6","020_106_6","PSA","106","6","6","Ana girakala nanga nanangatak alo memek bitakasan iwitatala, ana memek beteman; ana munan memek ninguru tala beteman ale kiwem memek duap duap bitakasan. ");
INSERT INTO wsk_vpl VALUES ("PS106_7","020_106_7","PSA","106","7","7","Anananga taleng girigir alo Egypt bagakasan mu nuna ni kiwem bibiya duap duap bitakasam mu arikasan, bare me ko ikia tokasan; nuna nika kiwem yawara yawara mu nunga kasurukasam bare mu agotala me ko sinarakasan; ale nongorak tai gagi biya ko nup Red Sea masan mu te mu aking nubiring gurugu kisiman ale kerak barimakasan. ");
INSERT INTO wsk_vpl VALUES ("PS106_8","020_106_8","PSA","106","8","8","Bare Yawe kota ko nup biya ningo anirukko se nu nunga saongam, ale noko sokel aora garagar mu nunga kausam ale wetang saparam. ");
INSERT INTO wsk_vpl VALUES ("PS106_9","020_106_9","PSA","106","9","9","Nu gagi mu sokel ago maonam se marakam, se sor merang wore te iwita nongorak koma sang te kasu kaparam. ");
INSERT INTO wsk_vpl VALUES ("PS106_10","020_106_10","PSA","106","10","10","Noko kariimet nunga bita maguwuwakasan mu nunga bataguru tam, se memek me arigiman. ");
INSERT INTO wsk_vpl VALUES ("PS106_11","020_106_11","PSA","106","11","11","Bare kager kari memek mu gagi peleram nunga ira kaluwuram se kua sapaman; bo ta me marak bagaram. ");
INSERT INTO wsk_vpl VALUES ("PS106_12","020_106_12","PSA","106","12","12","Asele nuna noko den nongorak kaolam mu ko nongomang ningi nunguning aram, se wur te nup patawukasan. ");
INSERT INTO wsk_vpl VALUES ("PS106_13","020_106_13","PSA","106","13","13","Bare tom me maiyam se mel bibiya nu beteram mu aking ko nungamili saparam, se nu kuring te den tamonko me kimi beteman, bare nunga ikia te la mel bitakasan. ");
INSERT INTO wsk_vpl VALUES ("PS106_14","020_106_14","PSA","106","14","14","Ale sor garagarayam mu te na inang ningo nuam wore namonko ninguru nongomang anikaso se nu ira ariga te beteman. ");
INSERT INTO wsk_vpl VALUES ("PS106_15","020_106_15","PSA","106","15","15","Se mel nuna ko kueman mu nu nungaram, bare udagi te aking kuera memek bo te nunga maguwuram. ");
INSERT INTO wsk_vpl VALUES ("PS106_16","020_106_16","PSA","106","16","16","Sor garagarayam mu te sasal sapaman ale bolala baga se, noko sinar kari Moses se Aaron, nu kota noko ura kari ko nunga balu beteram, mu nunga iki maguwuman. ");
INSERT INTO wsk_vpl VALUES ("PS106_17","020_106_17","PSA","106","17","17","Dathan Abiram ilak nunga memek ko koma, ali kuring kaigam se nunga kariimet sang ago arungak kapa naguman se nunga iram. ");
INSERT INTO wsk_vpl VALUES ("PS106_18","020_106_18","PSA","106","18","18","Ale tama bo pagam ale kariimet nogowom karowara mu nunga kani saparam. ");
INSERT INTO wsk_vpl VALUES ("PS106_19","020_106_19","PSA","106","19","19","Nuna Duruk Horeb te bulmakau gotek ko dora nungurman ale perr tuikasan; ");
INSERT INTO wsk_vpl VALUES ("PS106_20","020_106_20","PSA","106","20","20","Kaem Nikim Ago mu nubiring tuman ale bulmakau sirsir nowara mu ko dora kuar te kisiman ale nup patawukasan. ");
INSERT INTO wsk_vpl VALUES ("PS106_21","020_106_21","PSA","106","21","22","Kaem borta munan bibiya Egypt sor te beteram, ale kiwem duap duap Red Sea te wetang saparam ale nunga sangaru tam, bare am ko ikia bo me ta taman. ");
INSERT INTO wsk_vpl VALUES ("PS106_23","020_106_23","PSA","106","23","23","Buta se nu gomang magaram se balam, noko kariimet nunga maguwurokko mam; bare Moses, kota ko ura kari sinar mu, ilak wosenga kira lagaram se aking ko ikia gurugam. ");
INSERT INTO wsk_vpl VALUES ("PS106_24","020_106_24","PSA","106","24","24","Se tai ali welang karogo nu balu nungaram mu te pingia se mu, den balam mu te me sanamaman, ale ali mu am biriruwukasan. ");
INSERT INTO wsk_vpl VALUES ("PS106_25","020_106_25","PSA","106","25","25","Nuna noko kuring me karo tuikasan, ale nunga sasal ningi baga se nu kumik ko nging ngung kitikituk makasan. ");
INSERT INTO wsk_vpl VALUES ("PS106_26","020_106_26","PSA","106","26","26","Buta se nu den bo ikup nuam nungaram ale balam, “Nina sor garagarayam sumutang te baga kua paranga namaral, ");
INSERT INTO wsk_vpl VALUES ("PS106_27","020_106_27","PSA","106","27","27","se ninga kuriang gue suen la mu nunga parusuwurik se sor saki saki te namamon ale bagamonko!” ");
INSERT INTO wsk_vpl VALUES ("PS106_28","020_106_28","PSA","106","28","28","Bare nuna aking sor Peor mu ko kaem kawel Baal bowa naguman; ale tama bita kaem kawel nodora mena mu nungaru se, nuna na inang mu karogotala nokasan. ");
INSERT INTO wsk_vpl VALUES ("PS106_29","020_106_29","PSA","106","29","29","Nuna nunga kiwem memek umu te Yawe gomang maguwuman, se nu kuera ikes memek bo beteram se nungumik te kaparam. ");
INSERT INTO wsk_vpl VALUES ("PS106_30","020_106_30","PSA","106","30","30","Bare Phinehas barasam ale kariimet awiriya memek beteman mu nunga moram se kueman, asele kuera memek umu menaram. ");
INSERT INTO wsk_vpl VALUES ("PS106_31","020_106_31","PSA","106","31","31","Se kiwem ningo beteram mu te nu kari ningo diram ko balman, se kariimet gue gue te pempem la ko iki se lagamonko. ");
INSERT INTO wsk_vpl VALUES ("PS106_32","020_106_32","PSA","106","32","32","Israel alo tai yu Meribah duap te baga se mu, aking Yawe ko gomang motam yaman tuman, se ko ikup mu Moses giam. ");
INSERT INTO wsk_vpl VALUES ("PS106_33","020_106_33","PSA","106","33","33","Nuna kiwem memek umu beteman se Moses gomang motam ninguru magaram se gomang memek te alis ago ining nungaram. ");
INSERT INTO wsk_vpl VALUES ("PS106_34","020_106_34","PSA","106","34","34","Se nuna aking Yawe kuring kulukurman ale nu kariimet nunga momon se kuemonko balam mu nuna uwuta me beteman. ");
INSERT INTO wsk_vpl VALUES ("PS106_35","020_106_35","PSA","106","35","35","Bare aking nuna nongorak nunumi giman, ale nunga kiwem memek karo tuikasan. ");
INSERT INTO wsk_vpl VALUES ("PS106_36","020_106_36","PSA","106","36","36","Nuna sor mu arungak nunga kaem kawel mu nunup patawukasan, ale kiwem memek mu ko talipara ningi kapaman. ");
INSERT INTO wsk_vpl VALUES ("PS106_37","020_106_37","PSA","106","37","37","Nuna nunga kuriang imet se kuriang kari mu nunga ilu talipi kaem kawel alo mu tama bita nungarukasan. ");
INSERT INTO wsk_vpl VALUES ("PS106_38","020_106_38","PSA","106","38","38","Nunga kuriang nungumik den mena mu nunga moakasan se kuakasan se tama bita Canaan nunga kaem kawel umu nungarukasan; se kuriang umu nunga gue kaparam mu te ali sor lilim la ikup giam. ");
INSERT INTO wsk_vpl VALUES ("PS106_39","020_106_39","PSA","106","39","39","Nuna Kaem kota suanta ilak bagara mena, kaem kawel nobowa nagukasan, ale kiwem umu te memek tagi nongota nungumik te beteman. ");
INSERT INTO wsk_vpl VALUES ("PS106_40","020_106_40","PSA","106","40","40","Buta se Yawe noko kariimet nunga gomang magaram se me ta nunga kuakaso, ale buring gurugu nungaram. ");
INSERT INTO wsk_vpl VALUES ("PS106_41","020_106_41","PSA","106","41","41","Ale nunga giam ale sor saki nongorak kagerawara umu nuguting te nunga awuram se nunga nobowa ningi bagakasan. ");
INSERT INTO wsk_vpl VALUES ("PS106_42","020_106_42","PSA","106","42","42","Se ninguru nunga ereman nongorak kapaman ale mel yam ko nunga bitakasan. ");
INSERT INTO wsk_vpl VALUES ("PS106_43","020_106_43","PSA","106","43","43","Kari Biya nu tom suen biya nunga sangaru tokaso, bare nuna nongota nu ilak dun kopa ilukasan, ale nunga memek umu te eng am memek biya arigiman. ");
INSERT INTO wsk_vpl VALUES ("PS106_44","020_106_44","PSA","106","44","44","Bare nuna ikup ningi baga se nukote ai niakasan, mu nu nuguring ikikaso ale nunga gomang batagakaso. ");
INSERT INTO wsk_vpl VALUES ("PS106_45","020_106_45","PSA","106","45","45","Nu ko den nongorak kaolam mu ko kuamin ares mam se noko kua nungara mu te gomang lila nungaram. ");
INSERT INTO wsk_vpl VALUES ("PS106_46","020_106_46","PSA","106","46","46","Nuna sor saki nobowa ningi memek bagaman mu nu sor umu nongomang motam gurugam se noko kariimet aking nongomang lila nungarukasan. ");
INSERT INTO wsk_vpl VALUES ("PS106_47","020_106_47","PSA","106","47","47","O Yawe, anananga Kaem, nanga sangaruko. Sor saki saki nobowa ningi bagasan imi nanga gi ale nanga wonong duap te nanga bolala awur se ana amilmil kisinak ale ka nip laili mu patawunakko. ");
INSERT INTO wsk_vpl VALUES ("PS106_48","020_106_48","PSA","106","48","48","Ana Yawe nup patawunakko, nu ana Israel nanga Kaem; nu kumik menara mena, pempem butata bagoso. Buta se kariimet suen la nigiring bolala beteral ale “Nunguningta!” malko. Aleluya! ");
INSERT INTO wsk_vpl VALUES ("PS107_1","020_107_1","PSA","107","1","1","Yawe amilmil tunakko, mu awuk, nu ningo, pempem la; noko kua ana nangara ko munan mu, kumik menara mena. ");
INSERT INTO wsk_vpl VALUES ("PS107_2","020_107_2","PSA","107","2","2","Buta se nina awiriya nu ninga sangaru tam mu uwutatala balalko; nina kariimet nu kager kari memek nuguting te ninga bataguru tam, ");
INSERT INTO wsk_vpl VALUES ("PS107_3","020_107_3","PSA","107","3","3","nina kasik la sor kirker ko wore ninga giam ale ninga ilu biguwuram, koma worem bausa te, se koma worem kapara te, koma north namara mu te, se koma south, den mu balal ale amilmil tualko. ");
INSERT INTO wsk_vpl VALUES ("PS107_4","020_107_4","PSA","107","4","4","Kariimet sikina sor merang garagarayam mu te nguala sipa geraga se aguwaya namamon ale sor bo te bagamonko mu me ko ikikasan. ");
INSERT INTO wsk_vpl VALUES ("PS107_5","020_107_5","PSA","107","5","5","Nuna yu inang ko ninguru kueman, ale nongomang nungumik lilim la sokel menaram. ");
INSERT INTO wsk_vpl VALUES ("PS107_6","020_107_6","PSA","107","6","6","Bare nunga ikup mu ningi baga se Yawe aruman, se nu ikup yaman mu ningi nunga sangaru tam. ");
INSERT INTO wsk_vpl VALUES ("PS107_7","020_107_7","PSA","107","7","7","Nu nongorak lage bo diram tam, ale nongorak wonong bo te bagamonko wore te nongorak nama aratam. ");
INSERT INTO wsk_vpl VALUES ("PS107_8","020_107_8","PSA","107","8","8","Ario, nuna Yawe amilmil tumonko; noko kua ana nangara ko munan mu kumik guruga patawura mena; nu kiwem ningo ningo nago ko beteso. ");
INSERT INTO wsk_vpl VALUES ("PS107_9","020_107_9","PSA","107","9","9","Awiriya yu ko kuawasan mu nu yu nungarso, ale na ko kuawasan mu inang ningo nungarso. ");
INSERT INTO wsk_vpl VALUES ("PS107_10","020_107_10","PSA","107","10","10","Kariimet sikina mayang aora te nunga kaloman, se tiromorom ningi nongomang bataga se bagakasan, ");
INSERT INTO wsk_vpl VALUES ("PS107_11","020_107_11","PSA","107","11","11","mu awuk, nuna Kaem nubiring tuman, ale Kaem Kalel Biya mu ko den balam wore me karo tuman. ");
INSERT INTO wsk_vpl VALUES ("PS107_12","020_107_12","PSA","107","12","12","Se nu nunga beteram se ura ikup ikup taman ale nungumik sokel menaram; nuna dagulaman se bo ta nunga sangukko mena biya. ");
INSERT INTO wsk_vpl VALUES ("PS107_13","020_107_13","PSA","107","13","13","Bare nunga ikup mu ningi baga se Yawe aruman, se nu ikup yaman mu ningi nunga sangaru tam. ");
INSERT INTO wsk_vpl VALUES ("PS107_14","020_107_14","PSA","107","14","14","Nuna tiromorom ningi nongomang bataga se bagaman mu, mayang te nunga kaloman mu nu batutumu waram ale nongorak wetang te aratam. ");
INSERT INTO wsk_vpl VALUES ("PS107_15","020_107_15","PSA","107","15","15","Ario, nuna Yawe amilmil tumonko; noko kua ana nangara ko munan mu kumik guruga patawura mena; nu kiwem ningo ningo nago ko beteso. ");
INSERT INTO wsk_vpl VALUES ("PS107_16","020_107_16","PSA","107","16","16","Nu songkuring mel aora aora te nungurman wore batutumuso, ale songkuring mel aora aora te kalo kutiman mu batutumu warso. ");
INSERT INTO wsk_vpl VALUES ("PS107_17","020_107_17","PSA","107","17","17","Kariimet sikina kiwem memek ningi nunumi ngualara sipira ko iwita beteman, ale mu ko koma ikup yaman giman. ");
INSERT INTO wsk_vpl VALUES ("PS107_18","020_107_18","PSA","107","18","18","Nuna inang suen la nuguring meram, se kuemonko tom pingi aram. ");
INSERT INTO wsk_vpl VALUES ("PS107_19","020_107_19","PSA","107","19","19","Bare nunga ikup mu ningi baga se Yawe aruman, se nu ikup yaman mu ningi nunga sangaru tam. ");
INSERT INTO wsk_vpl VALUES ("PS107_20","020_107_20","PSA","107","20","20","Nu balam se kuera ikes nunga bita tam; ale kuemonko mutim norogen te bagaman mu nunga sangaru tam. ");
INSERT INTO wsk_vpl VALUES ("PS107_21","020_107_21","PSA","107","21","21","Ario, nuna Yawe amilmil tumonko; noko kua ana nangara ko munan mu kumik guruga patawura mena; nu kiwem ningo ningo nago ko beteso. ");
INSERT INTO wsk_vpl VALUES ("PS107_22","020_107_22","PSA","107","22","22","Buta se nuna tama bita Kaem tumon ale, wur amilmil te nu kiwem ningo beteram mu ko balmonko. ");
INSERT INTO wsk_vpl VALUES ("PS107_23","020_107_23","PSA","107","23","23","Kariimet sikina dal bibiya te aragaman ale gagi tuagu biya te geraga nama tai se, mel nunumi tui, dia gurugu no gi se bagaman. ");
INSERT INTO wsk_vpl VALUES ("PS107_24","020_107_24","PSA","107","24","24","Nuna Yawe ko kuting mu arigiman, ale kiwem ningo ningo gagi tuagu biya te beteram mu arigiman. ");
INSERT INTO wsk_vpl VALUES ("PS107_25","020_107_25","PSA","107","25","25","Mu awuk, nu balam se marir biya bo duap beteram, se gagi tamun bibiya barasukaso. ");
INSERT INTO wsk_vpl VALUES ("PS107_26","020_107_26","PSA","107","26","26","Gagi tamun mu barasam ale dal bibiya mu nunga patatuwuram nongorak tarigiram, ale asele nongorak kapa nagukaso ale aking basu aratukaso. ");
INSERT INTO wsk_vpl VALUES ("PS107_27","020_107_27","PSA","107","27","27","Se kariimet awote mu, kari yu aora nana ale dagula barasa iwita bitakasan, ale nunga ikia mena saparam. ");
INSERT INTO wsk_vpl VALUES ("PS107_28","020_107_28","PSA","107","28","28","Bare nunga ikup mu ningi baga se Yawe aruman, se nu ikup yaman mu ningi nunga sangaru tam. ");
INSERT INTO wsk_vpl VALUES ("PS107_29","020_107_29","PSA","107","29","29","Nu balam se gagi magaram mu kueram kaparam, ale gagi tamun barasuwaram mu kutek mam ale malin kauram. ");
INSERT INTO wsk_vpl VALUES ("PS107_30","020_107_30","PSA","107","30","30","Gagi malin kauram se nuna amilmilakasan, se nu nunga bituam nongorak nama saun kuring te namamonko mu te nunga beteram. ");
INSERT INTO wsk_vpl VALUES ("PS107_31","020_107_31","PSA","107","31","31","Ario, nuna Yawe amilmil tumonko; noko kua ana nangara ko munan mu kumik guruga patawura mena; nu kiwem ningo ningo nago ko beteso. ");
INSERT INTO wsk_vpl VALUES ("PS107_32","020_107_32","PSA","107","32","32","Buta se nuna noko nup biya kariimet nunga biguwura ningi balmon, ale kari supuling nunga biguwura te agotala nup biya patawumonko. ");
INSERT INTO wsk_vpl VALUES ("PS107_33","020_107_33","PSA","107","33","33","Nu balam se yu bibiya maraka sapaman, se yu gotektek palengawara mu agotala maraka namaman. ");
INSERT INTO wsk_vpl VALUES ("PS107_34","020_107_34","PSA","107","34","34","Nu ali welang ago mu gurugam se nama ali garagarayam memek ko aratam, mu awuk, kariimet owore te anira wore nunga kiwem memek ko koma. ");
INSERT INTO wsk_vpl VALUES ("PS107_35","020_107_35","PSA","107","35","35","Aking nu sor merang mu gurugam se yu motam suen biya ko arataman, se ali marakam mu yu tengeso ale naguso kaposo mu ko gurugam. ");
INSERT INTO wsk_vpl VALUES ("PS107_36","020_107_36","PSA","107","36","36","Asele nu kariimet na ko kuawara wore te nunga awuram se dagiman, ale nunga kawam digo kaloman ale wonong ko guruguman. ");
INSERT INTO wsk_vpl VALUES ("PS107_37","020_107_37","PSA","107","37","37","Nuna nunga inang muguri te aguman, ale mayang waen agotala aguman, se nunguning yawara kapa nungaram se gi no se bagakasan. ");
INSERT INTO wsk_vpl VALUES ("PS107_38","020_107_38","PSA","107","38","38","Nu ko kariimet marak nungaram se kuriang gue suen biya paga nungaram, se nunga bulmakau sipsip mu yam butatala gue pagam. ");
INSERT INTO wsk_vpl VALUES ("PS107_39","020_107_39","PSA","107","39","39","Tom noko kariimet kager te dagulaman, ale memek baga se kager kari memek nuguting te yaman ikup giwakasan, ");
INSERT INTO wsk_vpl VALUES ("PS107_40","020_107_40","PSA","107","40","40","mu Kaem nunga supuling gomang ikup nungaram, ale nunga kaoram se sor merang te, sor lage mena wore te, nguala sipa geragawakasan. ");
INSERT INTO wsk_vpl VALUES ("PS107_41","020_107_41","PSA","107","41","41","Bare nu kariimet nungumik mel mena wore nunga saongam, se nunga kuriang gue mu pagam, ale sipsip gue pagoso sor ereso iwita sor iram. ");
INSERT INTO wsk_vpl VALUES ("PS107_42","020_107_42","PSA","107","42","42","Se kariimet ningo diram bitawara mu munan imi arigisan ale ko amilmilasan, bare memek bitawara alo mu arigisan ale nuguring menaso. ");
INSERT INTO wsk_vpl VALUES ("PS107_43","020_107_43","PSA","107","43","43","Awiriya ikia sinar ago mu, kiwem imi suen la ninguru ko iki se, Yawe ko kua ana nangara biya mu ko kuamin ares maukko. ");
INSERT INTO wsk_vpl VALUES ("PS108_1","020_108_1","PSA","108","1","1","(David ko wur) O Kaem, ani ni ko ko angamang ningi ninguru nunguning aram; ani aga adera angimik lilim la nika wur iluwek ale nip patawurikko. ");
INSERT INTO wsk_vpl VALUES ("PS108_2","020_108_2","PSA","108","2","2","Ani ukira duap ago barasik ale aga gita se kulele kolawirik se sor ukirokko. ");
INSERT INTO wsk_vpl VALUES ("PS108_3","020_108_3","PSA","108","3","3","O Yawe, ani sor kasik la nongoma te amilmil kisek, ale kariimet suen la nongoma te wur iluwek ale nip patawurikko. ");
INSERT INTO wsk_vpl VALUES ("PS108_4","020_108_4","PSA","108","4","4","Mu awuk, nika gemang kua ana nangara mu aromemek se kalel biya, taiti gomang kiaram, se munan diram la ni ana nago ko betesam mu betela, taiti gomang karogo terong mam. ");
INSERT INTO wsk_vpl VALUES ("PS108_5","020_108_5","PSA","108","5","5","O Kaem, nika nip biya taiti gomang suen la te wetang saparko, se ka kimik nikim biya mu ali lilim iramurokko. ");
INSERT INTO wsk_vpl VALUES ("PS108_6","020_108_6","PSA","108","6","6","Nika kiting sengam mu te nanga bataguru to ale nanga sangaruko, umutang te mu ni awiriya nunga kuesam mu terong bagamonko. ");
INSERT INTO wsk_vpl VALUES ("PS108_7","020_108_7","PSA","108","7","7","Kaem ko kuwim laili mu ningi baga se den imi balam, “Ani amilmil te, sail te Shechem ali mu pakakumurik, ale sor wolong Succoth mu karogo tala parusuwu aga kariimet nungaru gurugekko. ");
INSERT INTO wsk_vpl VALUES ("PS108_8","020_108_8","PSA","108","8","8","Gilead mu aninga, se Manasseh mu aninga; Ephraim mu aninga kager ko kitigat, se Judah mu aninga bitua ura ko tam. ");
INSERT INTO wsk_vpl VALUES ("PS108_9","020_108_9","PSA","108","9","9","Moab mu yam ta tawir yam bo iwita, se Edom mu aninga asiwik gomang te bitirikko, se Philistia ningi mu ani amilmil ngata te bitirikko.” ");
INSERT INTO wsk_vpl VALUES ("PS108_10","020_108_10","PSA","108","10","10","Bare aga Kaem, awiri ani agarak sor Edom mu te namaruk ale ko wonong sokel aora biya mu ningi agarak kaparukko? ");
INSERT INTO wsk_vpl VALUES ("PS108_11","020_108_11","PSA","108","11","11","Awiriya bo mena, mu am nigita. Ni biring gurugu nangarem ale kager te me nanga sangarukasam. ");
INSERT INTO wsk_vpl VALUES ("PS108_12","020_108_12","PSA","108","12","12","Bare aitak mu ni ana nanga sangaruko; mu awuk, ali ko kari bo ana nanga sangukko me terong. ");
INSERT INTO wsk_vpl VALUES ("PS108_13","020_108_13","PSA","108","13","13","Bare ana nanga Kaem te mu ana kager te mariranakko; nu kota kager kari memek alo mu nunga waruk se kapamonko. ");
INSERT INTO wsk_vpl VALUES ("PS109_1","020_109_1","PSA","109","1","1","(David ko wur) O Kaem, ni keta suanta ani nika nip patawu lagasam, ni ani ago ko kiring me kaloko. ");
INSERT INTO wsk_vpl VALUES ("PS109_2","020_109_2","PSA","109","2","2","Mu awuk, kariimet memek nuguring kawel ago mu aga balu maguwusan, ale ani ago ko den kawel balsan. ");
INSERT INTO wsk_vpl VALUES ("PS109_3","020_109_3","PSA","109","3","3","Nuna nongomang memek te den te aga bita gilingisan; bare mu kumik duap bo mena biya. ");
INSERT INTO wsk_vpl VALUES ("PS109_4","020_109_4","PSA","109","4","4","Ani nunga kuesam, bare nuna ani den kawel te aga atumusan; bare ani mu guranek ko kari. ");
INSERT INTO wsk_vpl VALUES ("PS109_5","020_109_5","PSA","109","5","5","Nuna ani kiwem ningo betesam mu ko koma kiwem memek agate betesan, ale ani nunga kuesam mu ko koma nuna ani aga bita maguwusan. ");
INSERT INTO wsk_vpl VALUES ("PS109_6","020_109_6","PSA","109","6","6","Kari memek alo ago ko iwita balsan, “Kari memek bo atumukiral se den te ilak aratuk ale den kawel te atumokko. ");
INSERT INTO wsk_vpl VALUES ("PS109_7","020_109_7","PSA","109","7","7","Tom biguwura te ilak aratamon ale munak arigimon mu, nuguta memek ko duap mu ma balmonko; ale noko guranek mu yam kawel la ko balmonko. ");
INSERT INTO wsk_vpl VALUES ("PS109_8","020_109_8","PSA","109","8","8","Buta se nu tom maiya biya marak me bagarukko; se kari bo nu kuwim te kari dom ko aratukko. ");
INSERT INTO wsk_vpl VALUES ("PS109_9","020_109_9","PSA","109","9","9","Se noko kuriang mu nungumik nonet mena bagamon, se noko nuwus mu gerewa bagarukko. ");
INSERT INTO wsk_vpl VALUES ("PS109_10","020_109_10","PSA","109","10","10","Noko kuriang mu ngual ngual geraga se ngatang te gi no se lagamonko; se nunga bagara kuwim memek te bagasan mu te nunga karomonko. ");
INSERT INTO wsk_vpl VALUES ("PS109_11","020_109_11","PSA","109","11","11","Se awiriya nongote mel ipi giam mu taimon ale kote melmasak suen la gi sapamonko, ale noko ura kowar ko nunguning ningo ningo mu agotala gi sapamonko. ");
INSERT INTO wsk_vpl VALUES ("PS109_12","020_109_12","PSA","109","12","12","Se bo ta kiwem ningo bo me ta kumik te betemonko, agi ko kuriang marmar mu nunga nonoman me batagukko. ");
INSERT INTO wsk_vpl VALUES ("PS109_13","020_109_13","PSA","109","13","13","Buta se noko gue te mu menamonko; se kariimet gue luan udagi mu eng me nunga ikimonko. ");
INSERT INTO wsk_vpl VALUES ("PS109_14","020_109_14","PSA","109","14","14","Se noko nuet nongotak nunga memek bita lagaman mu Yawe me ta siwu warukko; ale ko nuam ko memek mu me ta siwu tuokko. ");
INSERT INTO wsk_vpl VALUES ("PS109_15","020_109_15","PSA","109","15","15","Se nunga memek mu Yawe koma te butata anirukko; se nunga nunup ali imi te mu mena namarukko. ");
INSERT INTO wsk_vpl VALUES ("PS109_16","020_109_16","PSA","109","16","16","“Mu awuk, nu kiwem ningo bo bitirukko ikia bo me ta tokaso; nu kituwura guat se nungumik mel mena alo mu nunga bita maguwukaso se nongomang bataga laga kua namakasan. ");
INSERT INTO wsk_vpl VALUES ("PS109_17","020_109_17","PSA","109","17","17","Nu kariimet memek te kua namamonko ko bala mu ko kuakaso, buta se nu kota mu uwutata kuerukko; nu marak ningo ko den ningo balukko me ta amilmilakaso, buta se marak ningo ko den nu me balu tumonko. ");
INSERT INTO wsk_vpl VALUES ("PS109_18","020_109_18","PSA","109","18","18","Kari bo ko guang ningo bo pempem nagurokko ko kua lagoso iwita, nu bo memek te kua namarukko den mu balukko ninguru ko kua paga lagoso; se bala memek mu yu bagun ningi lai kam kumik ningi laiso, ale kanga welang kunum kuting awote palenga kam kumik sokelel ningi palengoso. ");
INSERT INTO wsk_vpl VALUES ("PS109_19","020_109_19","PSA","109","19","19","Buta se kota ko den mu giris palaguk ale guang iwita taliparukko, ale nasuguri te kaola ko mayang iwita ko luan kalok se me ta kutugokko.” ");
INSERT INTO wsk_vpl VALUES ("PS109_20","020_109_20","PSA","109","20","20","Kager kari memek mu ago ko den memek uwutata balman; se Yawe nunga den memek mu ko koma ko uwutata nunga maguwurokko. ");
INSERT INTO wsk_vpl VALUES ("PS109_21","020_109_21","PSA","109","21","21","Bare O Yawe, ni keta suanta ni Kaem, nika nip biya mu ko ningo te aga sangaruko; nika kua aisa mu ko munan ningo umu te aga bataguru toko. ");
INSERT INTO wsk_vpl VALUES ("PS109_22","020_109_22","PSA","109","22","22","Mu awuk, ani kituwura, angimik saonga mena, se angamang motam ningi ninguru batagawoso. ");
INSERT INTO wsk_vpl VALUES ("PS109_23","020_109_23","PSA","109","23","23","Ani sor bainga awuru iluwa ko tiromorom taiso iwita, yumu namawasam; ale kusiska marir itugu saposo iwita. ");
INSERT INTO wsk_vpl VALUES ("PS109_24","020_109_24","PSA","109","24","24","Ani inang kalem ale inang kuwim ko aga abugura sokel menaram; ale angimik guang sokel numi iluwam. ");
INSERT INTO wsk_vpl VALUES ("PS109_25","020_109_25","PSA","109","25","25","Ani mu nononga bala memek ko mel bo iwita agarkasan; tom nuna ani agarkasan mu nusupuling sisuwusan. ");
INSERT INTO wsk_vpl VALUES ("PS109_26","020_109_26","PSA","109","26","26","O Yawe, aninga Kaem, ni aninga sangaruko; nika kua aisa mu ko munan ningo umu te, aga bataguru toko. ");
INSERT INTO wsk_vpl VALUES ("PS109_27","020_109_27","PSA","109","27","27","Ale nika kiting mu nunga kasuru se arigimon ale ikimon mu ni, Yawe, aninga sangaru taem. ");
INSERT INTO wsk_vpl VALUES ("PS109_28","020_109_28","PSA","109","28","28","Nuna maga namara ko den balmon, bare ni marak ningo mu aninga te bitarko; tom agarak kagermon mu dolara ningi kapamonko, bare ani nika ura kari mu amilmilarikko. ");
INSERT INTO wsk_vpl VALUES ("PS109_29","020_109_29","PSA","109","29","29","Kager kari memek mu dolara birigira mu guang iwita nunga iramurok, se dolara mu, guang nunumi te isi gurugusan mu iwita, nungumik isi gurugokko. ");
INSERT INTO wsk_vpl VALUES ("PS109_30","020_109_30","PSA","109","30","30","Ani agiring te Yawe tawun biya amilmil tuekko; kariimet nunga biguwura biya ningi nup patawurikko. ");
INSERT INTO wsk_vpl VALUES ("PS109_31","020_109_31","PSA","109","31","31","Mu awuk, nu awiriya nungumik saonga mena mu nuguting duap ningi nunga iluso, ale den te nunga betesan mu nunga sangaru taso. ");
INSERT INTO wsk_vpl VALUES ("PS110_1","020_110_1","PSA","110","1","1","(David ko wur) Yawe aninga Kari Biya iwita maonam, “Ni kuwim nup ago agiting sengam mu te bager se ani kari memek mu nunga menawu siwik duap ningi nunga awurekko,” mam. ");
INSERT INTO wsk_vpl VALUES ("PS110_2","020_110_2","PSA","110","2","2","Yawe mu ni kerak bagoso se ni Zion la mena, bare sor saki agotala nunga bitaruko; se kari memek mu ni bowa ningi la bagamonko. ");
INSERT INTO wsk_vpl VALUES ("PS110_3","020_110_3","PSA","110","3","3","Tom ni ka nip biya se ka sokel biya wetang sapar, mu ka kariimet amilmil te nunumi ni kisimonko. Nika ura ko guang laili yawara mu nagur mu, worem ko nikim kaposo iwita, sokel ago gek am sanamir ale nikim kaparko. ");
INSERT INTO wsk_vpl VALUES ("PS110_4","020_110_4","PSA","110","4","4","Yawe mu iwita nika balam ale udagi ko ikia me gurugokko: “Ni Melchizedek molak te priest ko pempem baga se lagerko,” mam. ");
INSERT INTO wsk_vpl VALUES ("PS110_5","020_110_5","PSA","110","5","5","O Yawe, aninga Kari Biya mu nika kiting sengam mu te sanamiwoso; tom nu ko gomang magara wetang te bitirukko tom mu te, nu king alo nunga nosokel menawu saparukko. ");
INSERT INTO wsk_vpl VALUES ("PS110_6","020_110_6","PSA","110","6","6","Nu ali sor suen la ko supuling bibiya nunga nosokel menawurok ale kariimet suen la nunga memek koma nungarukko; se kueman parangaman mu ali tuagu ago terong ma sapamonko. ");
INSERT INTO wsk_vpl VALUES ("PS110_7","020_110_7","PSA","110","7","7","Nu kagera saparuk mu te, nu lage luan te yu aniso mu nauk ale noman saparukko; ale nup biya nunguningkiri taukko. ");
INSERT INTO wsk_vpl VALUES ("PS111_1","020_111_1","PSA","111","1","1","Yawe ko nup patawunakko! Ani angamang motam lilim la te, kariimet diram nunga biguwura motam te, Yawe nup biya nunguning tuekko. ");
INSERT INTO wsk_vpl VALUES ("PS111_2","020_111_2","PSA","111","2","2","Yawe kiwem bibiya beteso mu yawarakala nunguningkiri; se arikaya ko amilmilasan ale ko kuesan mu ko nungamin ares ma se lagasan. ");
INSERT INTO wsk_vpl VALUES ("PS111_3","020_111_3","PSA","111","3","3","Nu ura suen la beteso mu sokel nikinang karogo la arataso, se noko munan ningo diram mu kumik menara mena. ");
INSERT INTO wsk_vpl VALUES ("PS111_4","020_111_4","PSA","111","4","4","Nu ko kiwem bibiya beteso mu tom suen biya ko kariimet nungamin te aniso; nu kiwem ningo se marolila ko Kaem. ");
INSERT INTO wsk_vpl VALUES ("PS111_5","020_111_5","PSA","111","5","5","Nu kariimet noko nguanga se kua bowa ningi bagasan mu inang nungarso; ale noko den nongorak kaolam mu ko kuamili me saposo. ");
INSERT INTO wsk_vpl VALUES ("PS111_6","020_111_6","PSA","111","6","6","Nu sor iwareng nunga ali bataguru ko kariimet nungaram, ale mu te noko sokel ko kariimet nunga kausam. ");
INSERT INTO wsk_vpl VALUES ("PS111_7","020_111_7","PSA","111","7","7","Nu mel suen la beteso mu ningo se diram la beteso; noko den balso mu nunguningta se diram la. ");
INSERT INTO wsk_vpl VALUES ("PS111_8","020_111_8","PSA","111","8","8","Se mel umu suen la beteso mu tom pempem la ani lagoso; nu kiwem nunguning se munan diram la te beteso. ");
INSERT INTO wsk_vpl VALUES ("PS111_9","020_111_9","PSA","111","9","9","Nu ko kariimet nunga bataguru tam ale nongorak den kaolam, se den mu tom suen biya anirukko. Nu laili se sokel garagar! ");
INSERT INTO wsk_vpl VALUES ("PS111_10","020_111_10","PSA","111","10","10","Yawe ko nguanga se kua bowa ningi la bagara ko munan mu ikia ningo ko lage kuring nunguningkiri; awiriya noko den karo tusan mu nu ikia ningo nungarso. Buta se noko nup pempem la patawu se laganakko! ");
INSERT INTO wsk_vpl VALUES ("PS112_1","020_112_1","PSA","112","1","1","Ana Yawe ko nup patawunakko! Kariimet noko nguangasan, ale noko munan den ko kuesan, mu amilmilamonko. ");
INSERT INTO wsk_vpl VALUES ("PS112_2","020_112_2","PSA","112","2","2","Nononga kuriang imas mu sokel ago se nunup agotala nunga ali te baga se nunga gue te marak yawara kapa nungarukko. ");
INSERT INTO wsk_vpl VALUES ("PS112_3","020_112_3","PSA","112","3","3","Nunga bagara te mu nungumik mel ago bagamonko; se nononga kiwem ningo diram mu butata pempem la anirukko. ");
INSERT INTO wsk_vpl VALUES ("PS112_4","020_112_4","PSA","112","4","4","Sor tiromorom ningi ta wore, kariimet ningo diram mu nikinang te bagamonko, mu awuk, nuna kariimet saki nongomang nungaru se, marolila te arungu baga se, munan ningo diram te la bagasan. ");
INSERT INTO wsk_vpl VALUES ("PS112_5","020_112_5","PSA","112","5","5","Kariimet nongomang motam ningo amilmil te saki alo mel nungarsan, ale kiwem ningo diram mu bita se nunga bagara aolak ko sinar tasan, mu yawarakala baga se lagamonko. ");
INSERT INTO wsk_vpl VALUES ("PS112_6","020_112_6","PSA","112","6","6","Mu awuk, kariimet munan umu karo tui lagasan mu me ta dagulamonko; se kariimet saki alo kariimet umu nunga kiwem ningo mu ko balu se lagamonko. ");
INSERT INTO wsk_vpl VALUES ("PS112_7","020_112_7","PSA","112","7","7","Nuna ikup duap duap ko den ikisan bare me ta nguangasan; mu awuk, nunga nongomang biya mu, Yawe kote la loaga se lagasan. ");
INSERT INTO wsk_vpl VALUES ("PS112_8","020_112_8","PSA","112","8","8","Nunga nongomang motam mu me ta uririkiso, se nuna me nguangasan; mu awuk, nuna uwutata sokel karogo amilmil te baga se nunga kager kari memek tamon mu nungarkamonko. ");
INSERT INTO wsk_vpl VALUES ("PS112_9","020_112_9","PSA","112","9","9","Nuna amilmil te nunga melmasak kituwura guat alo nungarsan gurugusan; nononga kiwem ningo diram mu butata pempem la anirukko; se kariimet nunga kiwem umu ko nunga balu se lagamonko. ");
INSERT INTO wsk_vpl VALUES ("PS112_10","020_112_10","PSA","112","10","10","Se kariimet memek bitawara mu kiwem imi arigimon ale nongomang magaruk se, nogore usimon se gigek mauk se nongoma kaluwu namamonko; ale nuna mel ko nongomang bita lagaman mu me ta tamonko. ");
INSERT INTO wsk_vpl VALUES ("PS113_1","020_113_1","PSA","113","1","1","Ana Yawe ko nup patawunakko! Nina ko ura kari alo, noko nup patawuralko. ");
INSERT INTO wsk_vpl VALUES ("PS113_2","020_113_2","PSA","113","2","2","Yawe ko nup aitak tom imi te se tom udagi te am butata patawu se lagaralko. ");
INSERT INTO wsk_vpl VALUES ("PS113_3","020_113_3","PSA","113","3","3","Koma worem bausa te nama worem kapara te, Yawe nup patawuralko. ");
INSERT INTO wsk_vpl VALUES ("PS113_4","020_113_4","PSA","113","4","4","Yawe ali sor suen la bitarso; noko nikim nup biya mu taiti gomang kia saparam. ");
INSERT INTO wsk_vpl VALUES ("PS113_5","020_113_5","PSA","113","5","5","Awiri Yawe, anananga Kaem, mu toroman? Nu ko daiga kuwim kalel biya mu te dagiwa se, ");
INSERT INTO wsk_vpl VALUES ("PS113_6","020_113_6","PSA","113","6","6","gomang motam nangarso se taiti ta, ali ta, motam kaposo se ninguru ari kutuwuwoso. ");
INSERT INTO wsk_vpl VALUES ("PS113_7","020_113_7","PSA","113","7","7","Nu kariimet kituwura guat, bune tutuk ali te mu gi no se, nongota nunumi sangarmonko me terong, mu nunga sangarso, ");
INSERT INTO wsk_vpl VALUES ("PS113_8","020_113_8","PSA","113","8","8","ale nunga gi terong la noko kariimet supuling alo nunga ningi nunga awuso se yawarakala bagasan. ");
INSERT INTO wsk_vpl VALUES ("PS113_9","020_113_9","PSA","113","9","9","Nu imet kuin sisira mu nunga bagara aolak te nunga sangarso, se kuriang ilusan ale amilmilasan. Se ana Yawe ko nup patawunakko! ");
INSERT INTO wsk_vpl VALUES ("PS114_1","020_114_1","PSA","114","1","1","Israel kariimet sor iwareng Egypt beteman ale arataman; nuna mu Jacob ko digo ko kariimet alo, ");
INSERT INTO wsk_vpl VALUES ("PS114_2","020_114_2","PSA","114","2","2","se tom mu te Kaem Judah noko bagara kuwim ko beteram, ale Israel lilim mu nunga gira kari bagakaso. ");
INSERT INTO wsk_vpl VALUES ("PS114_3","020_114_3","PSA","114","3","3","Se gagi umu arigam ale tagaram naguram, se yu Jordan kapawaram mu koma ira gurugam peleram. ");
INSERT INTO wsk_vpl VALUES ("PS114_4","020_114_4","PSA","114","4","4","Duruk alo mu uririkikasan ale sipsip anumang bibiya iwita ting ting makasan, se motongar kuting gotektek mu sipsip gotektek iwita ting ting makasan. ");
INSERT INTO wsk_vpl VALUES ("PS114_5","020_114_5","PSA","114","5","5","O gagi, ni mu awuk se tagerem nagurem? O Jordan, se ni awuk se kapawa kema ira gurugem pelerem? ");
INSERT INTO wsk_vpl VALUES ("PS114_6","020_114_6","PSA","114","6","6","Se nina duruk alo, awuk se ting ting makasan? Se nina motongar gotektek koma suanta bitakasan? ");
INSERT INTO wsk_vpl VALUES ("PS114_7","020_114_7","PSA","114","7","7","O ali, tom Kari Biya Jacob ko Kaem taiso mu, koma te mu ni uririkisam; ");
INSERT INTO wsk_vpl VALUES ("PS114_8","020_114_8","PSA","114","8","8","nu manga garap ningi yu beteram se lairam bausam, manga garap aora garagar mu ningi yu palengam kapakaso. ");
INSERT INTO wsk_vpl VALUES ("PS115_1","020_115_1","PSA","115","1","1","Ana mu nanip mena, O Yawe, ana mena; bare nika nip mu nikim garagar, se ni la nup biya toko, mu awuk, ni ana nago ko kuesam ale ka den diram la karo tui lagasam. ");
INSERT INTO wsk_vpl VALUES ("PS115_2","020_115_2","PSA","115","2","2","Sor saki ko kariimet awuk se balsan, “Nononga Kaem apoko ya?” ma nanga balsan? ");
INSERT INTO wsk_vpl VALUES ("PS115_3","020_115_3","PSA","115","3","3","Anananga Kaem mu duruk uningi bagoso; ale kota ko gomang te la mel suen la bita saposo. ");
INSERT INTO wsk_vpl VALUES ("PS115_4","020_115_4","PSA","115","4","4","Bare nononga kaem alo mu, silver se gold te nunga nungurman, kariimet nuguting te nunga nungurman. ");
INSERT INTO wsk_vpl VALUES ("PS115_5","020_115_5","PSA","115","5","5","Kaem kawel alo mu nuguring ago, bare me munakasan, ale nomotam ago, bare sor me arigisan. ");
INSERT INTO wsk_vpl VALUES ("PS115_6","020_115_6","PSA","115","6","6","Nuna nodogawa ago, bare den me ikisan, ale nungamuru ago, bare sor siring me ikisan. ");
INSERT INTO wsk_vpl VALUES ("PS115_7","020_115_7","PSA","115","7","7","Nuguting ago, bare mel te me kau tasan, ale nodoleng ago, bare me aolak ilusan; nuguring nodogotak ago, bare marir te me tagisan. ");
INSERT INTO wsk_vpl VALUES ("PS115_8","020_115_8","PSA","115","8","8","Se arikaya kaem kawel umu nunga nungurman, mu kaem kawel bagasan uwutatala bagamonko; se arikaya nogo ko nongomang ningi nunguning aram mu, koma suanta tala ko bagamonko. ");
INSERT INTO wsk_vpl VALUES ("PS115_9","020_115_9","PSA","115","9","9","O Israel kariimet, nina Yawe kote la loaga se lagaralko! Nu kota ninga saonga kari, se nu kota tala mu ninga karem. ");
INSERT INTO wsk_vpl VALUES ("PS115_10","020_115_10","PSA","115","10","10","O Aaron ko gue te ko priest alo, nina nu kote la loaga se lagaralko! Nu kota ninga saonga kari, se nu kota tala ninga karem. ");
INSERT INTO wsk_vpl VALUES ("PS115_11","020_115_11","PSA","115","11","11","Nina awiriya Yawe ko kua kapa lagasan mu, nu kote la loaga se lagaralko! Nu kota ninga saonga kari, se nu kota tala ninga karem. ");
INSERT INTO wsk_vpl VALUES ("PS115_12","020_115_12","PSA","115","12","12","Yawe ana nago ko kuamili me saparam; nu marak sokel nangarukko. Nu Israel kariimet marak sokel nungarukko, nu Aaron ko gue te priest alo mu marak sokel nungarukko. ");
INSERT INTO wsk_vpl VALUES ("PS115_13","020_115_13","PSA","115","13","13","Nu awiriya nu ko ko kua kapa lagasan, mu marak sokel nungarukko, nuna nunup bibiya se nunup mena mu am koma suanta. ");
INSERT INTO wsk_vpl VALUES ("PS115_14","020_115_14","PSA","115","14","14","Aninga angamang mu Yawe marak ningaruk se gue pagal ale suen aralko; nina se ninga gue udagi mu koma suanta tala. ");
INSERT INTO wsk_vpl VALUES ("PS115_15","020_115_15","PSA","115","15","15","Yawe nu taiti gomang se ali mel suen biya kiwolaram mu marak sokel ningarukko! ");
INSERT INTO wsk_vpl VALUES ("PS115_16","020_115_16","PSA","115","16","16","Taiti gomang kalel biya mu Yawe kota ko, bare ali mu, nu ana kariimet nangaram. ");
INSERT INTO wsk_vpl VALUES ("PS115_17","020_115_17","PSA","115","17","17","Kuera kariimet alo mu noko nup me patawusan; kuera mutim ningi namaman mu koma suanta tala. ");
INSERT INTO wsk_vpl VALUES ("PS115_18","020_115_18","PSA","115","18","18","Bare anangata kariimet marak bagasan ewere amilmil te nup biya tusan, aitak se tom pempem la. Ana Yawe nup patawunakko! ");
INSERT INTO wsk_vpl VALUES ("PS116_1","020_116_1","PSA","116","1","1","Ani Yawe ko kuesam, mu awuk, ani nu aninga sangukko aurem, se agiring ikiam ale gomang aisam. ");
INSERT INTO wsk_vpl VALUES ("PS116_2","020_116_2","PSA","116","2","2","Nu aninga aira ikiam ale aga saongam owore te se, ani ali imi te baga se mu, ani pempem nu aru ngatangaru se lagarikko. ");
INSERT INTO wsk_vpl VALUES ("PS116_3","020_116_3","PSA","116","3","3","Ani ikup se angamang bataga niara aga iramuram, ani kua namarikko pingi arem. ");
INSERT INTO wsk_vpl VALUES ("PS116_4","020_116_4","PSA","116","4","4","Bare ani Yawe nup te airem, “O Yawe, aga sangaruko!” maem. ");
INSERT INTO wsk_vpl VALUES ("PS116_5","020_116_5","PSA","116","5","5","Yawe mu munan nuam, gomang nangara ko Kaem; nu ninguru nanga kueso. ");
INSERT INTO wsk_vpl VALUES ("PS116_6","020_116_6","PSA","116","6","6","Nu kariimet nu kota suanta te la ira sanami lagasan mu nunga sangarso; se ani ikup biya ningi kaperem mu nu aninga saongam. ");
INSERT INTO wsk_vpl VALUES ("PS116_7","020_116_7","PSA","116","7","7","Aninga angamang motam aitak kua kaparam, mu awuk, Yawe ani ago ko ningo beteram. ");
INSERT INTO wsk_vpl VALUES ("PS116_8","020_116_8","PSA","116","8","8","Mu ni, O Yawe, ani memek ningi aga bataguru taem; ni aninga amononge siwurem, ale aninga sangem se me dagulem. ");
INSERT INTO wsk_vpl VALUES ("PS116_9","020_116_9","PSA","116","9","9","Se ani ali imi te baga se mu, ni la karo kisekko. ");
INSERT INTO wsk_vpl VALUES ("PS116_10","020_116_10","PSA","116","10","11","Ani ko ikiem, ikup memek aga iram, ale balem, “Kariimet suen la mu am kawel gurum la,” maem, bare aga nguangara mu ningi ni te sokel ago am sanamiwakasam. ");
INSERT INTO wsk_vpl VALUES ("PS116_12","020_116_12","PSA","116","12","12","Yawe ani ago ko ningo beteram, se anape mel ningo nu tuekko? ");
INSERT INTO wsk_vpl VALUES ("PS116_13","020_116_13","PSA","116","13","13","Ani agiting patawurik ale nu aga sangaru tam mu ko amilmil tui se, ");
INSERT INTO wsk_vpl VALUES ("PS116_14","020_116_14","PSA","116","14","14","ko kariimet nomotam te den ilak balem mu karo tuekko. ");
INSERT INTO wsk_vpl VALUES ("PS116_15","020_116_15","PSA","116","15","15","Yawe ko kariimet mu noko gomang motam, se bo magoso mu nokote mu mel aromemek. ");
INSERT INTO wsk_vpl VALUES ("PS116_16","020_116_16","PSA","116","16","16","O Yawe, nunguningta ani nika ura kari; aninga ayam nika ura imet bagakaso iwitatala, ani ka ura kari bagasam; ani mayang singir aga taliparam, bare ni bataguru guila warem. ");
INSERT INTO wsk_vpl VALUES ("PS116_17","020_116_17","PSA","116","17","17","Ani munan amilmil kisek ale nip patawurikko. ");
INSERT INTO wsk_vpl VALUES ("PS116_18","020_116_18","PSA","116","18","18","Ale den kerak balem mu karo tuekko. Nunguningta, ani Yawe ko kariimet nomotam te, ");
INSERT INTO wsk_vpl VALUES ("PS116_19","020_116_19","PSA","116","19","19","ni Jerusalem ka temple ningi, kuwim laili mu te Yawe amilmil tuekko. Ana Yawe ko nup patawunakko! ");
INSERT INTO wsk_vpl VALUES ("PS117_1","020_117_1","PSA","117","1","1","Ali sor lilim la, Yawe ko nup patawuralko! Imikiri suen la, nup biya tualko! ");
INSERT INTO wsk_vpl VALUES ("PS117_2","020_117_2","PSA","117","2","2","Mu awuk, noko gomang motam ana nago ko mu ulal biya; ale me nanga beteso, nangarak pempem baga lagoso. Se noko nup patawuralko! ");
INSERT INTO wsk_vpl VALUES ("PS118_1","020_118_1","PSA","118","1","1","Yawe amilmil tualko, mu awuk, nu ningo; noko kua ningara mu kumik menara mena. ");
INSERT INTO wsk_vpl VALUES ("PS118_2","020_118_2","PSA","118","2","2","Nina Israel kariimet iwita balalko, “Noko kua ana nangara mu kumik menara mena,” malko. ");
INSERT INTO wsk_vpl VALUES ("PS118_3","020_118_3","PSA","118","3","3","Se nina Aaron ko gue te priest alo butatala balalko, “Noko kua ana nangara mu kumik menara mena,” malko. ");
INSERT INTO wsk_vpl VALUES ("PS118_4","020_118_4","PSA","118","4","4","Se nina kariimet Yawe ko kua kapa lagasan, mu den koma suanta tala balalko, “Noko kua ana nangara mu kumik menara mena,” malko. ");
INSERT INTO wsk_vpl VALUES ("PS118_5","020_118_5","PSA","118","5","5","Ani ikup yaman ningi baga se aga niara Yawe kote beterem, se nu ani agiring iluwam ale aga ikup menawuram. ");
INSERT INTO wsk_vpl VALUES ("PS118_6","020_118_6","PSA","118","6","6","Yawe ani agarak bagoso se ani me nguangasam; awiri ani awuk aga bitirukko? Mena. ");
INSERT INTO wsk_vpl VALUES ("PS118_7","020_118_7","PSA","118","7","7","Nu ani agarak bagoso; nu aninga saonga kari; se ani am amilmil ago bagarik se kariimet ani agarak barimawasan mu dagulamonko. ");
INSERT INTO wsk_vpl VALUES ("PS118_8","020_118_8","PSA","118","8","8","Nina ali kari kote me loaga se lagaralko; bare ningo mu, Yawe te ira sanamaralko. ");
INSERT INTO wsk_vpl VALUES ("PS118_9","020_118_9","PSA","118","9","9","Nina ali ko kari supuling alo nongote me loaga se lagaralko; bare ningo mu, Yawe te ira sanamaralko. ");
INSERT INTO wsk_vpl VALUES ("PS118_10","020_118_10","PSA","118","10","10","Sor wonong suen la aga laturman, bare ani Yawe nup te nunga ita batutumu warem. ");
INSERT INTO wsk_vpl VALUES ("PS118_11","020_118_11","PSA","118","11","11","Nuna ani koma suen la te aga laturman, bare ani Yawe nup te nunga ita batutumu warem. ");
INSERT INTO wsk_vpl VALUES ("PS118_12","020_118_12","PSA","118","12","12","Nuna beras iwita aga tuguman, bare tam sikariring tairate kani namoso iwita, nuna tairate kua namaman; ani Yawe nup te nunga ita batutumu warem. ");
INSERT INTO wsk_vpl VALUES ("PS118_13","020_118_13","PSA","118","13","13","Ani aga diruwuman se pelerem ale dagulekko pingi arem, bare Yawe aga saongam. ");
INSERT INTO wsk_vpl VALUES ("PS118_14","020_118_14","PSA","118","14","14","Yawe mu aninga sokel se aninga bitua; nu aninga sangaru ta kari. ");
INSERT INTO wsk_vpl VALUES ("PS118_15","020_118_15","PSA","118","15","15","Kager te mariraman ko amilmil wur kariimet ningo diram mu nunga sasal ningi barasuwoso: “Yawe kuting te kiwem bibiya beteram! ");
INSERT INTO wsk_vpl VALUES ("PS118_16","020_118_16","PSA","118","16","16","Nu amilmil te ko kuting sengam mu patawuram; nu kuting te kiwem bibiya beteram!” ");
INSERT INTO wsk_vpl VALUES ("PS118_17","020_118_17","PSA","118","17","17","Ani me kuerik, bare marak baga se, Yawe kiwem beteram ewere ko balu pagikko. ");
INSERT INTO wsk_vpl VALUES ("PS118_18","020_118_18","PSA","118","18","18","Nu ani ikup yaman biya aisam, bare agarkiwaram se me kua namerem. ");
INSERT INTO wsk_vpl VALUES ("PS118_19","020_118_19","PSA","118","19","19","Yawe ko kuwim ningo diram mu ko songkuring kagaru aisalko; ani kasu nagurek ale amilmil tuekko. ");
INSERT INTO wsk_vpl VALUES ("PS118_20","020_118_20","PSA","118","20","20","Imi Yawe ko songkuring; kariimet ningo diram wore te ningi kasu nagusan. ");
INSERT INTO wsk_vpl VALUES ("PS118_21","020_118_21","PSA","118","21","21","Ani nika nip patawusam, mu awuk, ni ani agiring ikiem ale kager memek ko sokel menawurem; ni aninga sangaru ta kari. ");
INSERT INTO wsk_vpl VALUES ("PS118_22","020_118_22","PSA","118","22","22","Kawam te kaola ko manga bo, kawam kaola kari alo ari meman, bare mu manga borta aitak kawam giwoso. ");
INSERT INTO wsk_vpl VALUES ("PS118_23","020_118_23","PSA","118","23","23","Yawe butata beteram, se ana arigiman mu yawarakala, se ko amilmilasan. ");
INSERT INTO wsk_vpl VALUES ("PS118_24","020_118_24","PSA","118","24","24","Tom aitakta imi Yawe te mariraram; se ana ko amilmilanak ale amilmil tunakko. ");
INSERT INTO wsk_vpl VALUES ("PS118_25","020_118_25","PSA","118","25","25","Yawe, nanga sangaruko! Nanga sangaru se kager te mariranakko! ");
INSERT INTO wsk_vpl VALUES ("PS118_26","020_118_26","PSA","118","26","26","Marak yawara awiriya Yawe nup te taiso mu kote kaparukko! Ana Yawe ko temple ningi baga se marak den balu ningarsan. ");
INSERT INTO wsk_vpl VALUES ("PS118_27","020_118_27","PSA","118","27","27","Yawe mu nu Kaem Biya; nu ko nikim nangaram. Buta se, nene se sanis sapa sisuwu se, ana nangarak iru seseka se altar duap kaoralko. ");
INSERT INTO wsk_vpl VALUES ("PS118_28","020_118_28","PSA","118","28","28","Ni aninga Kaem, se ani amilmil kisekko; ni aninga Kaem, se ani nika nip patawurikko. ");
INSERT INTO wsk_vpl VALUES ("PS118_29","020_118_29","PSA","118","29","29","Yawe amilmil tualko, mu awuk, nu ningo; noko kua ningara mu kumik menara mena. ");
INSERT INTO wsk_vpl VALUES ("PS119_1","020_119_1","PSA","119","1","1","Kariimet awiriya memek bo mena, Yawe ko karo tua ko den mu diram la karo tui lagasan, mu amilmilamonko. ");
INSERT INTO wsk_vpl VALUES ("PS119_2","020_119_2","PSA","119","2","2","Kariimet awiriya nongomang motam lilim te nu kuring karo tusan, mu amilmilamonko. ");
INSERT INTO wsk_vpl VALUES ("PS119_3","020_119_3","PSA","119","3","3","Nuna memek bo me betesan, bare noko munan ningo mu te la aolak ilusan. ");
INSERT INTO wsk_vpl VALUES ("PS119_4","020_119_4","PSA","119","4","4","Nika kausa ningo nanga kausem, ale diram la ninguru karo tunakko balem. ");
INSERT INTO wsk_vpl VALUES ("PS119_5","020_119_5","PSA","119","5","5","O ani aga angamang biya nunguningkiri mu nika den karo tuekko! ");
INSERT INTO wsk_vpl VALUES ("PS119_6","020_119_6","PSA","119","6","6","Ani ko sinar arik ale butata bitirik mu ani dolara bo me ta taikko. ");
INSERT INTO wsk_vpl VALUES ("PS119_7","020_119_7","PSA","119","7","7","Ani nika den laili mu ko sinar a se, mu ani angamang motam diram te la ka nip patawurikko. ");
INSERT INTO wsk_vpl VALUES ("PS119_8","020_119_8","PSA","119","8","8","Ani nika den la karo tuekko; buta se ni ani me aga bitarko! ");
INSERT INTO wsk_vpl VALUES ("PS119_9","020_119_9","PSA","119","9","9","Kulak itiwik bo awuk ko munan ko sinar tauk se ningo la anirukko? Mu nika den karo tuata ko munan te la. ");
INSERT INTO wsk_vpl VALUES ("PS119_10","020_119_10","PSA","119","10","10","Ani angamang motam lilim nikate bita lagasam; ni aga bitar se nika den bo me ta kulukekko. ");
INSERT INTO wsk_vpl VALUES ("PS119_11","020_119_11","PSA","119","11","11","Ani memek bo nikate me bitirikko angamang, owore te se nika den ninguru ilukuawusam. ");
INSERT INTO wsk_vpl VALUES ("PS119_12","020_119_12","PSA","119","12","12","O Yawe, ani nika nip patawusam; nika den la aga kasuruko. ");
INSERT INTO wsk_vpl VALUES ("PS119_13","020_119_13","PSA","119","13","13","Nika den ni kiring te aratam mu, ani agiring te balu pagorsam. ");
INSERT INTO wsk_vpl VALUES ("PS119_14","020_119_14","PSA","119","14","14","Ani nika den karo tuekko amilmilasam, o kariimet bo noko ali imi ko nam giam suen biya se ko amilmiloso iwita. ");
INSERT INTO wsk_vpl VALUES ("PS119_15","020_119_15","PSA","119","15","15","Ani nika den umu ko iki gurugu se, amotam nika kiwem mu te la bita lagasam. ");
INSERT INTO wsk_vpl VALUES ("PS119_16","020_119_16","PSA","119","16","16","Ani nika den ko ninguru amilmilasam; ani den mu ko me angamili saparukko. ");
INSERT INTO wsk_vpl VALUES ("PS119_17","020_119_17","PSA","119","17","17","Ani nika ura kari, se nika ningo agate bitar se, ani te terong baga se ka den karo tuekko. ");
INSERT INTO wsk_vpl VALUES ("PS119_18","020_119_18","PSA","119","18","18","Aninga amotam sinar awur se, ani mel ningo ningo nika karo tua ko den ningi mu arigekko. ");
INSERT INTO wsk_vpl VALUES ("PS119_19","020_119_19","PSA","119","19","19","Ani kariimet iwareng bo iwita ali imi te bagasam; buta se nika den ani ago ko me kaluwurko. ");
INSERT INTO wsk_vpl VALUES ("PS119_20","020_119_20","PSA","119","20","20","Aninga angamang motam ko niara pempem la mu nika den ko nia lagoso. ");
INSERT INTO wsk_vpl VALUES ("PS119_21","020_119_21","PSA","119","21","21","Ni nunumi patawura ko kariimet mu ining nungarsam, se am memek tamonko, mu awuk, nuna nika den me karo tusan. ");
INSERT INTO wsk_vpl VALUES ("PS119_22","020_119_22","PSA","119","22","22","Yam nungarkiwer se bala memek se ining singi memek angimik te me bita se lagamonko, mu awuk, ani nika den karo tusam. ");
INSERT INTO wsk_vpl VALUES ("PS119_23","020_119_23","PSA","119","23","23","Kari supuling alo ilu biguwumon ale ani memek te aga betemonko balmon ta wore, ani nika ura kari mu nika den la ko iki gurugu lagarikko. ");
INSERT INTO wsk_vpl VALUES ("PS119_24","020_119_24","PSA","119","24","24","Nika den lilim la mu ko ani ninguru amilmilasam, mu awuk, mu aninga wosagam, se aga kiti guruguso. ");
INSERT INTO wsk_vpl VALUES ("PS119_25","020_119_25","PSA","119","25","25","Ani dagulem ale kupkup ningi kurakor kuring nagurem ale aniwasam; buta se ka den te aga patawur ale sokel iru aisuko. ");
INSERT INTO wsk_vpl VALUES ("PS119_26","020_119_26","PSA","119","26","26","Ani aga ikup suen la ka manem se ni ani agiring iluwem; buta se nika den aga kasuruko. ");
INSERT INTO wsk_vpl VALUES ("PS119_27","020_119_27","PSA","119","27","27","Aga sangaru se nika den ko duap ninguru ko ikiek, ale ani nika kiwem bibiya mu ko iki gurugu se lagarikko. ");
INSERT INTO wsk_vpl VALUES ("PS119_28","020_119_28","PSA","119","28","28","Ani angamang motam sokel menaram; nika den te sokel aisuko. ");
INSERT INTO wsk_vpl VALUES ("PS119_29","020_119_29","PSA","119","29","29","Ni aga bitaru se kiwem kawel bo aga bagara aolak me maguwurokko; gemang lila te nika karo tua ko den aga kasuruko. ");
INSERT INTO wsk_vpl VALUES ("PS119_30","020_119_30","PSA","119","30","30","Ani diram la karo tua ko lage mu angamang tuem; ani nika den lilim la angamang tuem. ");
INSERT INTO wsk_vpl VALUES ("PS119_31","020_119_31","PSA","119","31","31","O Yawe, ani nika den ilukuawusam; ni me aga bitar se dolara aisimonko. ");
INSERT INTO wsk_vpl VALUES ("PS119_32","020_119_32","PSA","119","32","32","Ni aninga ikia ulal awurem, se ani nika gemang karo tuekko. ");
INSERT INTO wsk_vpl VALUES ("PS119_33","020_119_33","PSA","119","33","33","O Yawe, nika den te lage aga kasuru se, ani tom pempem karo tui se lagarikko. ");
INSERT INTO wsk_vpl VALUES ("PS119_34","020_119_34","PSA","119","34","34","Aga ikia sinar awur se, ani nika karo tua ko den mu karo tuek, ale angamang motam lilim te karo tuekko. ");
INSERT INTO wsk_vpl VALUES ("PS119_35","020_119_35","PSA","119","35","35","Nika den te aga kiti guruguko, mu awuk, ani umu ningi amilmil arigisam. ");
INSERT INTO wsk_vpl VALUES ("PS119_36","020_119_36","PSA","119","36","36","Angamang motam patawur se ni la ka den karo tui se, ali imi ko nam giam abiring tuekko. ");
INSERT INTO wsk_vpl VALUES ("PS119_37","020_119_37","PSA","119","37","37","Ni agarkiwer se ali ewere ko mel, kumik ningo bo mena mu, amotam me gurugokko; nika den te daiga bagara ningo aisuko. ");
INSERT INTO wsk_vpl VALUES ("PS119_38","020_119_38","PSA","119","38","38","Ani nika ura kari se ni anapeya kariimet ni bowa ningi bagasan mu nunga balem mu ani agotala aisuko. ");
INSERT INTO wsk_vpl VALUES ("PS119_39","020_119_39","PSA","119","39","39","Nika den te aga sangaru se me dolirikko, mu awuk, nika den mu ningo se diram. ");
INSERT INTO wsk_vpl VALUES ("PS119_40","020_119_40","PSA","119","40","40","Ani nika kausa ningo wore ko kua lagasam! Se ka ningo nuam mu te marak iru aisuko. ");
INSERT INTO wsk_vpl VALUES ("PS119_41","020_119_41","PSA","119","41","41","O Yawe, nika kua nangara yawara mu aga kasuru ale balem butata aga sangaruko. ");
INSERT INTO wsk_vpl VALUES ("PS119_42","020_119_42","PSA","119","42","42","Ani nika den te ira sanamasam, ale awiriya aga balu maguwuso mu koma balu tuekko. ");
INSERT INTO wsk_vpl VALUES ("PS119_43","020_119_43","PSA","119","43","43","Aninga loagara mu nika den nunguning mu te la loaga lagasam; buta se aga sangaru se nika den nunguning balu se lagarikko. ");
INSERT INTO wsk_vpl VALUES ("PS119_44","020_119_44","PSA","119","44","44","Ani pempem la nika karo tua ko den mu butata karo tui se lagarikko. ");
INSERT INTO wsk_vpl VALUES ("PS119_45","020_119_45","PSA","119","45","45","Ani nika kausa den ningo mu karo tusam owore te se, ani kiwem bo ko dungan iwita me ta bagarikko, mena. ");
INSERT INTO wsk_vpl VALUES ("PS119_46","020_119_46","PSA","119","46","46","Ani nika den mu king nongoma te am balu pagik, ale kiwem betesam umu ko me ta dolirikko. ");
INSERT INTO wsk_vpl VALUES ("PS119_47","020_119_47","PSA","119","47","47","Ani nika den suen la ninguru ko amilmilasam, mu awuk, ani nunga kuesam. ");
INSERT INTO wsk_vpl VALUES ("PS119_48","020_119_48","PSA","119","48","48","Ani ninguru nunga kuesam ale nunga amilmilasam, ale aga bagara te mu ko iki gurugu se lagarikko. ");
INSERT INTO wsk_vpl VALUES ("PS119_49","020_119_49","PSA","119","49","49","Ni den ka ura kari ani agarak balem mu ko kamili me saparukko; mu awuk, den borta ani te ira sanamasam ale sokel tasam. ");
INSERT INTO wsk_vpl VALUES ("PS119_50","020_119_50","PSA","119","50","50","Tom ani ikup yaman ningi kapasam mu nika den sangam aisiso se ningo la bagasam. ");
INSERT INTO wsk_vpl VALUES ("PS119_51","020_119_51","PSA","119","51","51","Nunumi patawura ko kariimet mu ago ko nongomang bataga bo mena, dolara den te ninguru aga maguwusan, bare ani nika karo tua ko den mu me ta abiring tusam. ");
INSERT INTO wsk_vpl VALUES ("PS119_52","020_119_52","PSA","119","52","52","O Yawe, ani nika den balu beterem se ani lagoso mu ko angamin ares maso, se umu ani angamang motam sangam tuso. ");
INSERT INTO wsk_vpl VALUES ("PS119_53","020_119_53","PSA","119","53","53","Tom kari memek bitawara mu nika den kulukursan, mu ani angamang ikuwoso. ");
INSERT INTO wsk_vpl VALUES ("PS119_54","020_119_54","PSA","119","54","54","Ani apareyate baga se wore, nika den mu ani wur te ilu lagasam. ");
INSERT INTO wsk_vpl VALUES ("PS119_55","020_119_55","PSA","119","55","55","O Yawe, ani tirom ningi nika nip ko angamin ares maso, se ani nika karo tua ko den mu ko iki gurugu lagasam. ");
INSERT INTO wsk_vpl VALUES ("PS119_56","020_119_56","PSA","119","56","56","Se marak ningo angimik te kaparam, mu awuk, ani pempem nika den karo tui lagasam. ");
INSERT INTO wsk_vpl VALUES ("PS119_57","020_119_57","PSA","119","57","57","O Yawe, ni keta aninga mel suen biya; ani nika den karo tuekko aga ikia kalem. ");
INSERT INTO wsk_vpl VALUES ("PS119_58","020_119_58","PSA","119","58","58","Ani angamang motam lilim la te ka isarsam, nika den te balem uwutata gemang lila aisuko. ");
INSERT INTO wsk_vpl VALUES ("PS119_59","020_119_59","PSA","119","59","59","Aninga kiwem kasik la ko ikia taem, ale angamang nika den karo tuekko betesam. ");
INSERT INTO wsk_vpl VALUES ("PS119_60","020_119_60","PSA","119","60","60","Ani tom me aga kiarukko, am tairate la nika den karo tuekko. ");
INSERT INTO wsk_vpl VALUES ("PS119_61","020_119_61","PSA","119","61","61","Memek betera ko kariimet mayang te aga talipamon ta wore, ani nika karo tua ko den ko me ta angamili saparukko. ");
INSERT INTO wsk_vpl VALUES ("PS119_62","020_119_62","PSA","119","62","62","Ani tirom mung luan barasasam ale nika den ningo dirkiriyam mu ko amilmil kisisam. ");
INSERT INTO wsk_vpl VALUES ("PS119_63","020_119_63","PSA","119","63","63","Ani awiriya nika nguangasan mu nongorak suanta, se awiriya nika kausa ningo mu karo tusan, mu nongorak suanta tala. ");
INSERT INTO wsk_vpl VALUES ("PS119_64","020_119_64","PSA","119","64","64","O Yawe, ali imi nika kua ana nangara ko kiwem karogo terong mam; buta se ka den ningo aga kasuruko. ");
INSERT INTO wsk_vpl VALUES ("PS119_65","020_119_65","PSA","119","65","65","O Yawe, ni ka den balem butata, ani ka ura kari agate ningo la bitarko. ");
INSERT INTO wsk_vpl VALUES ("PS119_66","020_119_66","PSA","119","66","66","Nika ikia sinar se tutera ningo aga kasuruko, mu awuk, ani nika den ko angamang ningi nunguning aram. ");
INSERT INTO wsk_vpl VALUES ("PS119_67","020_119_67","PSA","119","67","67","Ni ani bu me aisa la mu ani memek bitakasam, bare aitak ani nika den karo tusam. ");
INSERT INTO wsk_vpl VALUES ("PS119_68","020_119_68","PSA","119","68","68","Ni mu ningo, se ni anapeya betesam mu ningo la; buta se nika den aga kasuruko. ");
INSERT INTO wsk_vpl VALUES ("PS119_69","020_119_69","PSA","119","69","69","Nunumi patawura alo mu ani ago ko den kawel balsan, bare ani angamang motam lilim te nika den karo tusam. ");
INSERT INTO wsk_vpl VALUES ("PS119_70","020_119_70","PSA","119","70","70","Nononga nongomang motam au kaparam se nunga ikia ngualaram, bare ani nika den ko ninguru amilmilasam. ");
INSERT INTO wsk_vpl VALUES ("PS119_71","020_119_71","PSA","119","71","71","Ani bu taem mu aninga ningo ko, mu awuk, bu umu te asele ani nika den mu ari ko ikiem. ");
INSERT INTO wsk_vpl VALUES ("PS119_72","020_119_72","PSA","119","72","72","Den ni kiring te arataso mu aninga te mu mel aromemek, ali imi ko manga se ko mel ningo ningo mu nunga kia saparam. ");
INSERT INTO wsk_vpl VALUES ("PS119_73","020_119_73","PSA","119","73","73","Ni kiting te kupkup ilu biguwurem ale aga nungem; ni aga ikia sinar awur se, ani nika den ko ikiekko. ");
INSERT INTO wsk_vpl VALUES ("PS119_74","020_119_74","PSA","119","74","74","Awiriya nika nguangasan mu, ani agarkamon ale amilmilamonko, mu awuk, ani aga loagara mu am nika den te diram bita lagasam. ");
INSERT INTO wsk_vpl VALUES ("PS119_75","020_119_75","PSA","119","75","75","O Yawe, ani ko ikisam, nika den mu ningo dirkiriyam, se nika diram la karo tua ko munan te ani bu aisem. ");
INSERT INTO wsk_vpl VALUES ("PS119_76","020_119_76","PSA","119","76","76","Ani nika ura kari agarak den kalem uwutata, nika kua nangara kumik menara mena mu te, angamang motam tagi patawurko. ");
INSERT INTO wsk_vpl VALUES ("PS119_77","020_119_77","PSA","119","77","77","Nika gemang lila ani ais se ani te bagarikko, mu awuk, ani nika karo tua ko den ko ninguru amilmilasam. ");
INSERT INTO wsk_vpl VALUES ("PS119_78","020_119_78","PSA","119","78","78","Nunumi patawura ko kariimet alo den kawel kumik duap mena ani ago ko balsan, mu ko koma memek nungaru se dolomonko; bare ani mu nika den mu ko iki gurugu se lagarikko. ");
INSERT INTO wsk_vpl VALUES ("PS119_79","020_119_79","PSA","119","79","79","Awiriya nika den ko nguanga se iki karo tusan mu aningate taimon, se ani nika den umu nunga kausek se ikimonko. ");
INSERT INTO wsk_vpl VALUES ("PS119_80","020_119_80","PSA","119","80","80","Aninga angamang biya mu ni aga sangaru se nika den karo tuekko, ale kiwem umu te mu ani ko dolara me taikko. ");
INSERT INTO wsk_vpl VALUES ("PS119_81","020_119_81","PSA","119","81","81","Ani nika saonga ko kimikam la lagerem ale adera angimik sokel menaram, bare ani nika den te ira sanamasam. ");
INSERT INTO wsk_vpl VALUES ("PS119_82","020_119_82","PSA","119","82","82","Ani nika den wore ko nunguning ko amotam bita se maem, “Ni amaru te aga sangaruko ya?” maem. ");
INSERT INTO wsk_vpl VALUES ("PS119_83","020_119_83","PSA","119","83","83","Ani mu pulut gigira tama motam te kaetma se marakawara owore iwita, bare ani nika den mu ko angamili me saposo. ");
INSERT INTO wsk_vpl VALUES ("PS119_84","020_119_84","PSA","119","84","84","Tom awila nunguningkiri ani, nika ura kari, kimi bita lagarikko? Ni amaru te kari aga bita maguwusan mu nunga maguwurko? ");
INSERT INTO wsk_vpl VALUES ("PS119_85","020_119_85","PSA","119","85","85","Nunumi patawura alo, ani te aga ilumonko, mutim ilu betesan, mu nika karo tua ko den kiasan. ");
INSERT INTO wsk_vpl VALUES ("PS119_86","020_119_86","PSA","119","86","86","Nuna aninga bita maguwusan mu kumik duap bo mena, buta se ni aninga sangaruko; mu awuk, nika den mu mel biya se mel nunguning. ");
INSERT INTO wsk_vpl VALUES ("PS119_87","020_119_87","PSA","119","87","87","Nuna katirta ali imi te aga menawumonko, bare ani nika den mu me ta patawu sapasam. ");
INSERT INTO wsk_vpl VALUES ("PS119_88","020_119_88","PSA","119","88","88","Nika kua nangara ko munan te, aga sangaru se marak baga se nika den karo tuekko. ");
INSERT INTO wsk_vpl VALUES ("PS119_89","020_119_89","PSA","119","89","89","O Yawe, nika den mu kumik menara mena; sokel karogo duruk wonong te butata aniso. ");
INSERT INTO wsk_vpl VALUES ("PS119_90","020_119_90","PSA","119","90","90","Nika diram la karo tua ko munan mu, tom pempem la kuriang luan gue gue te butata aniso; ni ali lilim la nungem burangerem se yager nukuri ago aora biya butata aniso. ");
INSERT INTO wsk_vpl VALUES ("PS119_91","020_119_91","PSA","119","91","91","Nika den uwutata aniram tai aitak, mu awuk, melmasak suen la mu nika ura dungan betesan. ");
INSERT INTO wsk_vpl VALUES ("PS119_92","020_119_92","PSA","119","92","92","Nika karo tua ko den mu ani amilmil aisiso. E ani me ko amilmilasam le mu, tom ani ikup arigem mu te ani angimik lilim ago maga namerem la le. ");
INSERT INTO wsk_vpl VALUES ("PS119_93","020_119_93","PSA","119","93","93","Buta se ani nika den mu me ta angamili saparukko, mu awuk, borta te ni aninga ilukuawurem se ani bagasam. ");
INSERT INTO wsk_vpl VALUES ("PS119_94","020_119_94","PSA","119","94","94","Aga sangaruko, mu awuk, ani nika; se nika den karo tui lagerem. ");
INSERT INTO wsk_vpl VALUES ("PS119_95","020_119_95","PSA","119","95","95","Memek motam alo mu aga momon se kuerikko kimi bitawasan, bare ani nika den ko ikia ninguru bitirikko. ");
INSERT INTO wsk_vpl VALUES ("PS119_96","020_119_96","PSA","119","96","96","Melmasak ningo ningo suen la mu ko tom tukunang gotek, bare nika den mu du biya se ulal biya, se kumik menara ko tom mena. ");
INSERT INTO wsk_vpl VALUES ("PS119_97","020_119_97","PSA","119","97","97","Ani nika karo tua ko den mu ninguru ko kuesam! Ale tom pempem ko iki gurugu lagasam. ");
INSERT INTO wsk_vpl VALUES ("PS119_98","020_119_98","PSA","119","98","98","Nika den mu pempem ani agarak baga se ikia sinar ninguru aisiso, se memek motam alo mu ani agarak me terong maman. ");
INSERT INTO wsk_vpl VALUES ("PS119_99","020_119_99","PSA","119","99","99","Aninga kitigot wiram ale aga ikia sinar aram se aga kausa kari nunga kiarem, mu awuk, ani nika den ko iki gurugu lagasam. ");
INSERT INTO wsk_vpl VALUES ("PS119_100","020_119_100","PSA","119","100","100","Aninga ikia sinar mu kariimet garuk nunga ikia sinar kiaram, mu awuk, ani nika kausa ningo mu karo tusam. ");
INSERT INTO wsk_vpl VALUES ("PS119_101","020_119_101","PSA","119","101","101","Ani lage memek suen la abiring tuem, mu awuk, ani nika den karo tuekko. ");
INSERT INTO wsk_vpl VALUES ("PS119_102","020_119_102","PSA","119","102","102","Ani nika den mu me ari daleluwurem, mu awuk, ni keta aninga kausem. ");
INSERT INTO wsk_vpl VALUES ("PS119_103","020_119_103","PSA","119","103","103","Beras ko ningo mu yamanam, bare nika den mu ani agiring te am yamanam nunguningkiri! ");
INSERT INTO wsk_vpl VALUES ("PS119_104","020_119_104","PSA","119","104","104","Ani nika den mu te ikia ningo tasam; buta se ani tuang memek mu suen la abiring tuem. ");
INSERT INTO wsk_vpl VALUES ("PS119_105","020_119_105","PSA","119","105","105","Nika den mu aninga galep, lage aga kasurso, ale aninga lage nikinang tuso. ");
INSERT INTO wsk_vpl VALUES ("PS119_106","020_119_106","PSA","119","106","106","Ani den bo kalem ale sokel tuem mu iwita, ani nika den diram la karo tuekko maem. ");
INSERT INTO wsk_vpl VALUES ("PS119_107","020_119_107","PSA","119","107","107","O Yawe, ani ikup yaman giem terong mam; nika den ningo mu te marak sokel iru aisuko. ");
INSERT INTO wsk_vpl VALUES ("PS119_108","020_119_108","PSA","119","108","108","O Yawe, angamang motam lilim la te ka nip patawusam mu to ale, nika den aga kasuruko. ");
INSERT INTO wsk_vpl VALUES ("PS119_109","020_119_109","PSA","119","109","109","Tom suen la lage memek mu aga maguwurokko taiso, bare ani nika karo tua ko den mu me ta angamili saposo. ");
INSERT INTO wsk_vpl VALUES ("PS119_110","020_119_110","PSA","119","110","110","Kariimet memek motam alo mu ani ago ko bawang bo beteman, bare ani nika den mu me abiring tuem. ");
INSERT INTO wsk_vpl VALUES ("PS119_111","020_119_111","PSA","119","111","111","Nika den suen la mu aninga mel ningo, pempem agarak anirukko; den mu aninga angamang motam amilmil tuso. ");
INSERT INTO wsk_vpl VALUES ("PS119_112","020_119_112","PSA","119","112","112","Aninga angamang motam mu anapeya aratuk ta wore, nika den karo tui se lagarikko aniso. ");
INSERT INTO wsk_vpl VALUES ("PS119_113","020_119_113","PSA","119","113","113","Ani kariimet ikia ilagala te bagasan mu ani me nunga kuesam, bare ani nika karo tua ko den ko kuesam. ");
INSERT INTO wsk_vpl VALUES ("PS119_114","020_119_114","PSA","119","114","114","Ni aninga manga gek am se aga karem, se aninga loagara mu nika den ningi la bita lagasam. ");
INSERT INTO wsk_vpl VALUES ("PS119_115","020_119_115","PSA","119","115","115","Nina memek betera ko kariimet, tagi talko, se ani aga Kaem ko den karo tuekko. ");
INSERT INTO wsk_vpl VALUES ("PS119_116","020_119_116","PSA","119","116","116","Nika den kalem umu te aga ilukuawur se, ani marak bagarikko; ani nikate la loaga lagasam, umu te aga sangaru se ani me ipi loaga laga dolirikko. ");
INSERT INTO wsk_vpl VALUES ("PS119_117","020_119_117","PSA","119","117","117","Aga sinar to se ani memek bo me arigekko; ani nika den mu la ko ikia to se lagarikko. ");
INSERT INTO wsk_vpl VALUES ("PS119_118","020_119_118","PSA","119","118","118","Ni awiriya nika den me karo tusan mu nunga biriruwusam; mu awuk, nuna ikia kawel mu te nongota nunumi kuluruwasan. ");
INSERT INTO wsk_vpl VALUES ("PS119_119","020_119_119","PSA","119","119","119","Ni ali imi ko kariimet memek mu mel memek iwita nungarkasam ale nunga gi warsam; buta se ani nika den ko kuesam. ");
INSERT INTO wsk_vpl VALUES ("PS119_120","020_119_120","PSA","119","120","120","Ani nika ko nguangasam ale angimik lilim barowara maso; ani abugura kulukursam ale nika den ko ikia to lagasam. ");
INSERT INTO wsk_vpl VALUES ("PS119_121","020_119_121","PSA","119","121","121","Ani kiwem ningo diram se yawarakala mu beterem, buta se ni aga bitaru se memek betera alo mu me aga bita maguwumonko. ");
INSERT INTO wsk_vpl VALUES ("PS119_122","020_119_122","PSA","119","122","122","Ani nika ura kari, aga ningo ko sinar toko; aga bita to se nunumi patawura alo mu me agarak kapamonko. ");
INSERT INTO wsk_vpl VALUES ("PS119_123","020_119_123","PSA","119","123","123","Ni den ningo dirkiriyam kalem owore te ani loaga lagasam, ale ni aga sangaru toko loaga laga, amotam dagulam. ");
INSERT INTO wsk_vpl VALUES ("PS119_124","020_119_124","PSA","119","124","124","Buta se nika kua nangara kumik menara mena wore ko munan te aga sangaru ale nika den aga kasuruko. ");
INSERT INTO wsk_vpl VALUES ("PS119_125","020_119_125","PSA","119","125","125","Ani nika ura kari; aga ikia sinar awur se, ka den ko sinar arikko. ");
INSERT INTO wsk_vpl VALUES ("PS119_126","020_119_126","PSA","119","126","126","O Yawe, ni kiwem bo bitarko, mu awuk, nika den kulukurman. ");
INSERT INTO wsk_vpl VALUES ("PS119_127","020_119_127","PSA","119","127","127","Nunguningta, nika den mu mel ningo ningo kia saparam, mel yawara nunguningkiri ta wore am kia saparam tala, se ani ninguru ko kuesam. ");
INSERT INTO wsk_vpl VALUES ("PS119_128","020_119_128","PSA","119","128","128","Nunguningta, nika den mu aninga kiti guruguso, se kiwem kawel suen la mu ani me ta ko kuesam. ");
INSERT INTO wsk_vpl VALUES ("PS119_129","020_119_129","PSA","119","129","129","Nika den suen la mu yawarakala; buta se ani karo tusam. ");
INSERT INTO wsk_vpl VALUES ("PS119_130","020_119_130","PSA","119","130","130","Nika den apusan mu nikim nangarso, ale kariimet den umu me ko ikia ta wore ikia sinar nungarso. ");
INSERT INTO wsk_vpl VALUES ("PS119_131","020_119_131","PSA","119","131","131","Ani nika den ninguru ko iki kutuwurekko angamang nia lagoso. ");
INSERT INTO wsk_vpl VALUES ("PS119_132","020_119_132","PSA","119","132","132","Kema gurugu ale gemang lila aisuko; kariimet awiriya nika kuesan mu ni uwutata nongote betesam. ");
INSERT INTO wsk_vpl VALUES ("PS119_133","020_119_133","PSA","119","133","133","Nika den te aninga aolak diram la kiti gurugu se kiwem memek bo ta ani me aga kiarukko. ");
INSERT INTO wsk_vpl VALUES ("PS119_134","020_119_134","PSA","119","134","134","Kariimet memek alo nuguting te aga sangaru to se ani nika den karo tuekko. ");
INSERT INTO wsk_vpl VALUES ("PS119_135","020_119_135","PSA","119","135","135","Kema gurugu ale gemang motam ani ka ura kari aisu ale nika den aga kasuruko. ");
INSERT INTO wsk_vpl VALUES ("PS119_136","020_119_136","PSA","119","136","136","Aninga amononge mu yu ko kapawoso, mu awuk, kariimet nika karo tua ko den me karo tusan. ");
INSERT INTO wsk_vpl VALUES ("PS119_137","020_119_137","PSA","119","137","137","O Yawe, ni mu ningo dirkiriyam nunguningkiri, se nika den mu diram la. ");
INSERT INTO wsk_vpl VALUES ("PS119_138","020_119_138","PSA","119","138","138","Nika den suen la nangarem mu am ningo diram, se anananga ningo ko mel biya nunguningkiri, kari bo ko suwik saparukko mel bo mena. ");
INSERT INTO wsk_vpl VALUES ("PS119_139","020_119_139","PSA","119","139","139","Angamang magara mu tama ko kaniwoso, mu awuk, kager kari memek nika den mu mel yam ko betesan. ");
INSERT INTO wsk_vpl VALUES ("PS119_140","020_119_140","PSA","119","140","140","Ni ka den mu me gurugusam patawusam se ani arigem mu am ningo, se yawara nunguningkiri; se ani nika ura kari ninguru ko kuesam. ");
INSERT INTO wsk_vpl VALUES ("PS119_141","020_119_141","PSA","119","141","141","Ani mu kituwura se agarki maguwusan, bare ani nika den mu me ta ko angamili saposo. ");
INSERT INTO wsk_vpl VALUES ("PS119_142","020_119_142","PSA","119","142","142","Nika ningo dirkiriyam la bagara ko munan mu kumik menara mena, se nika karo tua ko den mu den nunguning. ");
INSERT INTO wsk_vpl VALUES ("PS119_143","020_119_143","PSA","119","143","143","Ikup aga iram se angamang daung daung maso, bare nika den mu ani amilmil aisiso. ");
INSERT INTO wsk_vpl VALUES ("PS119_144","020_119_144","PSA","119","144","144","Nika den mu ningo dirkiriyam la pempem aniso; aninga ikia sinar awur se ani te bagarikko. ");
INSERT INTO wsk_vpl VALUES ("PS119_145","020_119_145","PSA","119","145","145","O Yawe, angamang motam lilim te ka arusam; agiring ilup se nika den karo tuekko. ");
INSERT INTO wsk_vpl VALUES ("PS119_146","020_119_146","PSA","119","146","146","Ani nikate aisam, aga sangaru to se ani nika den karo tuekko. ");
INSERT INTO wsk_vpl VALUES ("PS119_147","020_119_147","PSA","119","147","147","Ani worem me bausa la barasasam ale nika saonga ko aisam; aninga amotam mu nika den te la loaga lagasam. ");
INSERT INTO wsk_vpl VALUES ("PS119_148","020_119_148","PSA","119","148","148","Ani tirom mu amotam anira mena, am marak laga se nika den ko iki gurugu lagasam. ");
INSERT INTO wsk_vpl VALUES ("PS119_149","020_119_149","PSA","119","149","149","O Yawe, nika kua nangara mu ko munan yawara mu te agiring ilupko; nika den te daiga bagara ningo aisuko. ");
INSERT INTO wsk_vpl VALUES ("PS119_150","020_119_150","PSA","119","150","150","Kariimet kiwem memek te aga bita maguwumonko mu tai angimik aman, nuna nika karo tua ko den mu me karo tusan. ");
INSERT INTO wsk_vpl VALUES ("PS119_151","020_119_151","PSA","119","151","151","Bare Yawe, ni ani agarak pingi baga se aga sangorsam, se nika den suen la mu nunguning la. ");
INSERT INTO wsk_vpl VALUES ("PS119_152","020_119_152","PSA","119","152","152","Ani ulengkala la nika den mu ari ko ikiem, mu ni girakala la beterem se nukuri ago butata anirukko. ");
INSERT INTO wsk_vpl VALUES ("PS119_153","020_119_153","PSA","119","153","153","Ani ikup yaman ningi bagasam ewere arik ale aga sangaru toko, mu awuk, ani nika karo tua ko den mu me ko angamili saposo. ");
INSERT INTO wsk_vpl VALUES ("PS119_154","020_119_154","PSA","119","154","154","Kari memek nuguting te aga sangaru to ale ka den te balem uwutata aga bitaruko. ");
INSERT INTO wsk_vpl VALUES ("PS119_155","020_119_155","PSA","119","155","155","Memek bitawara alo mu nika den me karo tusan, buta se ni me nunga sangaru toko. ");
INSERT INTO wsk_vpl VALUES ("PS119_156","020_119_156","PSA","119","156","156","O Yawe, nika gemang lila mu mel aromemek; ka den te balem uwutata aga bitaruko. ");
INSERT INTO wsk_vpl VALUES ("PS119_157","020_119_157","PSA","119","157","157","Aninga bita maguwura ko kariimet alo mu suen biya, se aga bita maguwusan, bare ani nika den me ta abiring tusam. ");
INSERT INTO wsk_vpl VALUES ("PS119_158","020_119_158","PSA","119","158","158","Nika kariimet saki nika den nubiring tusan mu ko ninguru angamang magoso, mu awuk, nuna nika den me karo tusan. ");
INSERT INTO wsk_vpl VALUES ("PS119_159","020_119_159","PSA","119","159","159","O Yawe, ani nika den ko kuesam mu ni ko ikisam, buta se ago ko kuar ale aga bitaruko. ");
INSERT INTO wsk_vpl VALUES ("PS119_160","020_119_160","PSA","119","160","160","Nika den suen la mu am nunguning la; nika munan den ningo dirkiriyam la mu kumik menara mena. ");
INSERT INTO wsk_vpl VALUES ("PS119_161","020_119_161","PSA","119","161","161","Kari supuling memek alo aga bita maguwusan mu kumik duap bo mena, bare ani nika den ko suanta nguangasam. ");
INSERT INTO wsk_vpl VALUES ("PS119_162","020_119_162","PSA","119","162","162","Ani nika den ko aisam amilmilasam, o kari bo mel bo ningo arigiso ale iruso ko amilmiloso iwita. ");
INSERT INTO wsk_vpl VALUES ("PS119_163","020_119_163","PSA","119","163","163","Ani kawel ko munan mu me ko kuesam ale biriruwusam, bare ani nika karo tua ko den mu ko kuesam. ");
INSERT INTO wsk_vpl VALUES ("PS119_164","020_119_164","PSA","119","164","164","Ani nika den ningo dirkiriyam mu ko, woremkalal suanta mu, tom suen biya ko amilmil kisisam. ");
INSERT INTO wsk_vpl VALUES ("PS119_165","020_119_165","PSA","119","165","165","Kariimet nika karo tua ko den ko ninguru kuesan mu nongomang lila te bagasan, se tareng memek bo te me ta dagulamonko, mena. ");
INSERT INTO wsk_vpl VALUES ("PS119_166","020_119_166","PSA","119","166","166","O Yawe, ani ni aga sangaru toko kimikam la loaga se, nika den karo tui se baga lagasam. ");
INSERT INTO wsk_vpl VALUES ("PS119_167","020_119_167","PSA","119","167","167","Nika den mu yawara se ani karo tusam, mu awuk, ani tawun biya ko kuesam. ");
INSERT INTO wsk_vpl VALUES ("PS119_168","020_119_168","PSA","119","168","168","Ani nika den karo tusam, mu awuk, ni aninga kiwem mu ari ko iki sapasam. ");
INSERT INTO wsk_vpl VALUES ("PS119_169","020_119_169","PSA","119","169","169","O Yawe, aninga niara ikiko; nika den te aninga ikia sinar awurko. ");
INSERT INTO wsk_vpl VALUES ("PS119_170","020_119_170","PSA","119","170","170","Ni aninga guranek ikiko; nika den te kalem uwuta, aga sangaru toko. ");
INSERT INTO wsk_vpl VALUES ("PS119_171","020_119_171","PSA","119","171","171","Ani wur te nika nip patawurikko, mu awuk, ni ka den aga kasursam. ");
INSERT INTO wsk_vpl VALUES ("PS119_172","020_119_172","PSA","119","172","172","Ani nika den ko wur iluwekko, mu awuk, nika den suen la mu ningo dirkiriyam nunguningkiri. ");
INSERT INTO wsk_vpl VALUES ("PS119_173","020_119_173","PSA","119","173","173","Nika kiting mu aninga sangukko pingi la anirukko, mu awuk, ani nika den karo tuekko angamang beterem. ");
INSERT INTO wsk_vpl VALUES ("PS119_174","020_119_174","PSA","119","174","174","O Yawe, ani ni aga sangaru toko angamang aniso, se nika karo tua ko den mu ani amilmil aisiso. ");
INSERT INTO wsk_vpl VALUES ("PS119_175","020_119_175","PSA","119","175","175","Ni aga bitaru se ani marak baga se nika nip patawurikko, se nika den mu sangam sokel aisuokko. ");
INSERT INTO wsk_vpl VALUES ("PS119_176","020_119_176","PSA","119","176","176","Ani sipsip bo nguala sipa yumu namerem wore iwita. Ani nika ura kari, aga kupu ale agarkiko, mu awuk, ani nika den mu ko me angamili saposo. ");
INSERT INTO wsk_vpl VALUES ("PS120_1","020_120_1","PSA","120","1","1","(Ilu se temple te nama tarigira ko wur) Aninga ikup ningi Yawe arusam, se nu agiring iluso. ");
INSERT INTO wsk_vpl VALUES ("PS120_2","020_120_2","PSA","120","2","2","O Yawe, kariimet nuguring kawel karogo wore nuguting te aga sangaru toko, ale kariimet nungamili guruga patawura karogo mu nuguting te aga sangaru toko. ");
INSERT INTO wsk_vpl VALUES ("PS120_3","020_120_3","PSA","120","3","3","Nina kariimet nigiring memek mu, nu awuk ninga bitiruk i? Ale anape bo karogo nengete bitirukko? ");
INSERT INTO wsk_vpl VALUES ("PS120_4","020_120_4","PSA","120","4","4","Nu kager kari ko daga gotek kore buguyam mu te ninga moruk, ale tuwer giturum kaniwara mu te ninga kaiyokko. ");
INSERT INTO wsk_vpl VALUES ("PS120_5","020_120_5","PSA","120","5","5","Bare ani Meshek kariimet nunga ningi baga maguwu lagasam; ani Kedar kariimet nunga ningi memek baga lagasam. ");
INSERT INTO wsk_vpl VALUES ("PS120_6","020_120_6","PSA","120","6","6","Ani kariimet, lila te bagara ko kiwem mu me ko kuawara umu nunga ningi tom maiya biya bagerem. ");
INSERT INTO wsk_vpl VALUES ("PS120_7","020_120_7","PSA","120","7","7","Ani mu angamang lila ko kari; bare tom ani bagara lila mu ko balukasam, mu nuna kager ko la balukasan. ");
INSERT INTO wsk_vpl VALUES ("PS121_1","020_121_1","PSA","121","1","1","(Ilu se temple te nama tarigira ko wur) Ani amotam duruk te loagasam, bare aninga saonga aparete tairukko? ");
INSERT INTO wsk_vpl VALUES ("PS121_2","020_121_2","PSA","121","2","2","Aninga saonga mu Yawe kote tairukko; nu taiti se ali kiwolaram. ");
INSERT INTO wsk_vpl VALUES ("PS121_3","020_121_3","PSA","121","3","3","Nu me ka bitiruk se dagulko, nika Sinar Kari mu motam me anirukko; ");
INSERT INTO wsk_vpl VALUES ("PS121_4","020_121_4","PSA","121","4","4","nunguningta, Israel ko Sinar Kari mu motam me kuiniso, ale me aniso. ");
INSERT INTO wsk_vpl VALUES ("PS121_5","020_121_5","PSA","121","5","5","Yawe nu kota ka sinar taukko; nu beta dugu te baga se ko tamarum bowa ningi ni bagerko. ");
INSERT INTO wsk_vpl VALUES ("PS121_6","020_121_6","PSA","121","6","6","Se woremkalal mu worem me ka kanirukko, se aking tirom mu mel memek bo me ka maguwurokko. ");
INSERT INTO wsk_vpl VALUES ("PS121_7","020_121_7","PSA","121","7","7","Yawe ka sinar tauk se memek suen biya ka kia kaparukko; nu nika bagara aolak ko sinar taukko. ");
INSERT INTO wsk_vpl VALUES ("PS121_8","020_121_8","PSA","121","8","8","Nu nika namara taira bagara aolak ko sinar tauk se ningo la pempem lagerko. Nunguning. ");
INSERT INTO wsk_vpl VALUES ("PS122_1","020_122_1","PSA","122","1","1","(Ilu se temple te nama tarigira ko wur David batogam) Tom nuna aninga manorman, “Ario! ana Yawe ko temple te namanakko,” maman, mu ani ninguru amilmilerem. ");
INSERT INTO wsk_vpl VALUES ("PS122_2","020_122_2","PSA","122","2","2","O Jerusalem, ana aitak nika songkuring ago sanamiwasan! ");
INSERT INTO wsk_vpl VALUES ("PS122_3","020_122_3","PSA","122","3","3","Jerusalem wonong mu iwita kaloman, numi kitira biya se aora biya nunguningkiri. ");
INSERT INTO wsk_vpl VALUES ("PS122_4","020_122_4","PSA","122","4","4","Umu te Yawe ko kariimet Israel, digo koma koma te tarigisan, ale te balam uwutata te nup patawusan. ");
INSERT INTO wsk_vpl VALUES ("PS122_5","020_122_5","PSA","122","5","5","Ale kuwim umu betela ikup guyak te tuati nunga ko kuwim, se king bibiya David te kaparam mu nunga daiga kuwim. ");
INSERT INTO wsk_vpl VALUES ("PS122_6","020_122_6","PSA","122","6","6","Buta se Jerusalem ko marolila ko guranek beteralko: “O Jerusalem, awiriya nika kueso mu daiga bagara yawara arigimonko. ");
INSERT INTO wsk_vpl VALUES ("PS122_7","020_122_7","PSA","122","7","7","Nika por ka lautam mu ningi mu marolila anirukko, se ka kawam suen la mu bitua karogo la!” ");
INSERT INTO wsk_vpl VALUES ("PS122_8","020_122_8","PSA","122","8","8","Aninga gue suan alo se aga sikisaki alo nunga ningo ko se, ani iwita balsam, “Jerusalem, marolila nika ningi anirukkowo!” ");
INSERT INTO wsk_vpl VALUES ("PS122_9","020_122_9","PSA","122","9","9","Yawe anananga Kaem ko temple laili mu nika ningi aniso mu ko se, ani nika ningo pempem la anirukko mu ko nu aru wosenga se lagarikko. ");
INSERT INTO wsk_vpl VALUES ("PS123_1","020_123_1","PSA","123","1","1","(Ilu se temple te nama tarigira ko wur) O Yawe, ani amotam patawu duruk wonong te, nika daiga kuwim te, nikate loagasam. ");
INSERT INTO wsk_vpl VALUES ("PS123_2","020_123_2","PSA","123","2","2","Ura dungan kari ko kari biya kote sangam taukko motam beteso iwita, agi ura imet, ko imet biya kote sangam taukko motam beteso iwita, uwutatala, anananga namotam Yawe, nanga Kaem, mu kote loaga se laganak se, gomang lila nangaruk nunguningkiri bare asele terong ko. ");
INSERT INTO wsk_vpl VALUES ("PS123_3","020_123_3","PSA","123","3","3","Gemang lila nangaruko, O Yawe, nika gemang lila nangaruko, mu awuk, ana ikup yaman ninguru ta giman terong mam. ");
INSERT INTO wsk_vpl VALUES ("PS123_4","020_123_4","PSA","123","4","4","Nunumi patawura ko kariimet alo mu anananga balu sisuwusan, ale mel yam ko nanga betesan. ");
INSERT INTO wsk_vpl VALUES ("PS124_1","020_124_1","PSA","124","1","1","(Ilu se temple te nama tarigira ko wur; David ko wur) O Israel, ikialko! Yawe ana nangarak me sanamaram le mu, ana memek taman le. Buta se nina nigiring bolala iwita balalko: ");
INSERT INTO wsk_vpl VALUES ("PS124_2","020_124_2","PSA","124","2","2","“Yawe ana nangarak me sanamaram le mu, tom kager kari nangarak kagerman, ");
INSERT INTO wsk_vpl VALUES ("PS124_3","020_124_3","PSA","124","3","3","tom nunga nongomang memek nago ko beteman, mu nuna ana marak nanga lakuman la; ");
INSERT INTO wsk_vpl VALUES ("PS124_4","020_124_4","PSA","124","4","4","se yu lom nanga ira baguram, ale nanga iramuram la, ");
INSERT INTO wsk_vpl VALUES ("PS124_5","020_124_5","PSA","124","5","5","se yu lom kalel biya mu nanga sarumu waram la.” ");
INSERT INTO wsk_vpl VALUES ("PS124_6","020_124_6","PSA","124","6","6","Ana Yawe nup patawunakko, nu ana nanga beteram se kager kore ningi me batuwutuk maman. ");
INSERT INTO wsk_vpl VALUES ("PS124_7","020_124_7","PSA","124","7","7","Ana inangnang iwita naguman bulamara kari ko dagarok kiaman; dagarok mu batagam gogong karogo, se ana kiaman ale naguman. ");
INSERT INTO wsk_vpl VALUES ("PS124_8","020_124_8","PSA","124","8","8","Ana Yawe ko nup te saonga tasan, nu Kiwol Kari taiti se ali nungam. ");
INSERT INTO wsk_vpl VALUES ("PS125_1","020_125_1","PSA","125","1","1","(Ilu se temple te nama tarigira ko wur) Kariimet Yawe te la ira sanamasan mu Duruk Zion iwita sokel ago bagamonko; duruk mu me namoso taiso, bare pempem sokel ago la baga lagoso. ");
INSERT INTO wsk_vpl VALUES ("PS125_2","020_125_2","PSA","125","2","2","Duruk saki Jerusalem laturu guruguman bagasan iwita, Yawe ko kariimet nunga lautam bagoso, aitak se tom pempem la. ");
INSERT INTO wsk_vpl VALUES ("PS125_3","020_125_3","PSA","125","3","3","Kariimet memek alo mu kariimet ningo diram nunga ali sor Yawe nungaram mu me bitaru se lagamonko, mu awuk, kariimet ningo diram nononga kiwem memek iki karo tumon bore ko. ");
INSERT INTO wsk_vpl VALUES ("PS125_4","020_125_4","PSA","125","4","4","O Yawe, ni kariimet ningo diram, nika kiring karo tusan, mu munan ningo la nungumik te bitarko. ");
INSERT INTO wsk_vpl VALUES ("PS125_5","020_125_5","PSA","125","5","5","Bare arikaya pelesan aking kilek memek ningi namasan, mu Yawe nunga karuk se kariimet memek tasan mu nongorak memek tamonko. O Yawe, aninga angamang mu nika gemang lila Israel tui se lila te bagamonko. ");
INSERT INTO wsk_vpl VALUES ("PS126_1","020_126_1","PSA","126","1","1","(Ilu se temple te nama tarigira ko wur) Tom Yawe ana talipara ningi nanga giam nangarak Zion peleram tairam mu ana “Ipingisan i?” maman. ");
INSERT INTO wsk_vpl VALUES ("PS126_2","020_126_2","PSA","126","2","2","Ana gusira ngata te, amilmil te, wur la taikasan, se sor saki ko kariimet ana nangarkikasan mu balukasan, “Yawe kariimet umu nungumik te kilek bibiya beteram,” makasan. ");
INSERT INTO wsk_vpl VALUES ("PS126_3","020_126_3","PSA","126","3","3","Se mu nunguningta, Yawe ana nangimik te kilek bibiya beteram, se ana ninguru amilmilasan. ");
INSERT INTO wsk_vpl VALUES ("PS126_4","020_126_4","PSA","126","4","4","O Yawe, ana peleman taiman bare mel suen la maga saparam; se ni sor garagarayam te tuwik betesam se kaposo iwitata, marak sokel iru nangaru se aking yawarakala te baganakko. ");
INSERT INTO wsk_vpl VALUES ("PS126_5","020_126_5","PSA","126","5","5","Se kariimet nomononge kapa se nunga na inang asursan, mu udagi wur amilmil te na inang nunguning gimonko. ");
INSERT INTO wsk_vpl VALUES ("PS126_6","020_126_6","PSA","126","6","6","Mu awiriya nomononge kapa se, na inang kumi gisan ale asurmonko namasan, mu udagi te amilmil wur ilu se, inang nunguning gi ago taimonko! ");
INSERT INTO wsk_vpl VALUES ("PS127_1","020_127_1","PSA","127","1","1","(Ilu se temple te nama tarigira ko wur; Solomon wur imi batogam) Yawe nu kawam kaola kari mu arungu me bagaruk agi mu, ura kari nongota ura bo nunguning me betemonko. Yawe wonong buring tuok agi mu, bitua kari mu wonong bitarmonko me terong tala. ");
INSERT INTO wsk_vpl VALUES ("PS127_2","020_127_2","PSA","127","2","2","Tumong biyala barasa ale nangata nanga sokel te inang ko ura ilu lagara nama uriluanara, mu ko ikia me terong, mu awuk, Yawe ko kariimet nunga kueso mu inang nungarso se nasan, ale ninguru anisan nonoman sapasan. ");
INSERT INTO wsk_vpl VALUES ("PS127_3","020_127_3","PSA","127","3","3","Yawe kuriang nangarso mu noko munan ningo nunguningkiri wore nangarso. ");
INSERT INTO wsk_vpl VALUES ("PS127_4","020_127_4","PSA","127","4","4","Kari kulak ko kuriang kari aratasan, mu gatu siping ago kari kuting te iluwoso iwita. ");
INSERT INTO wsk_vpl VALUES ("PS127_5","020_127_5","PSA","127","5","5","Kari ko gatu gotek suen biya gatu siping ningi, mu nu amilmilarukko. Kariimet sang taimon nu ilak nunumi ilumon, bare nu me ta dolurukko, mu awuk, noko kuriang alo mu nu sangarmonko. ");
INSERT INTO wsk_vpl VALUES ("PS128_1","020_128_1","PSA","128","1","1","(Ilu se temple te nama tarigira ko wur) Arikaya Yawe ko nguangasan ale noko munan la karo tusan mu amilmilamonko. ");
INSERT INTO wsk_vpl VALUES ("PS128_2","020_128_2","PSA","128","2","2","Uwuta bitar mu ni ka ura kowar ko koma gi noko; marak ningo se daiga bagara ningo mu arik ale amilmilerko. ");
INSERT INTO wsk_vpl VALUES ("PS128_3","020_128_3","PSA","128","3","3","Nika niwus mu tam ningo bo iwita nunguning kapa kisu se lagarukko; nika kuriang mu tam butuk yawara iwita ka laturmonko. ");
INSERT INTO wsk_vpl VALUES ("PS128_4","020_128_4","PSA","128","4","4","Awiriya Yawe ko nguangoso mu, nu uwutata marak sokel tuokko. ");
INSERT INTO wsk_vpl VALUES ("PS128_5","020_128_5","PSA","128","5","5","Aga angamang mu Yawe Zion baga se, ni marak sokel kisok se pempem butata baga se lagerko; se Jerusalem bagara ningo se mel kasik la karogo terong mauk mu ni arikko. ");
INSERT INTO wsk_vpl VALUES ("PS128_6","020_128_6","PSA","128","6","6","Ale ni mu baga laga, ka kuriang nutagu te ka imas aratamon se nungarkiko. Kaem ko lila yawara Israel nengerak bagarukko. ");
INSERT INTO wsk_vpl VALUES ("PS129_1","020_129_1","PSA","129","1","1","(Ilu se temple te nama tarigira ko wur; gira kari duap beteso se kariimet suen la ilu gilingisan) “Ani aga kulak te la, nuna ani tawun biya aga bita maguwuman,” –Israel ni iwita baluko– ");
INSERT INTO wsk_vpl VALUES ("PS129_2","020_129_2","PSA","129","2","2","“Ani aga kulak te la, nuna ani tawun biya aga bita maguwuman, bare nuna ani me ta aga kiaman. ");
INSERT INTO wsk_vpl VALUES ("PS129_3","020_129_3","PSA","129","3","3","Nuna aninga asusuru ninguru pakakumuman, se na muguri te aguwa ko ali pakakumura tam. ");
INSERT INTO wsk_vpl VALUES ("PS129_4","020_129_4","PSA","129","4","4","Bare Yawe mu ningo se diram; nu kari memek nunga mayang ani te aga talipikoyam, mu batutumuram.” ");
INSERT INTO wsk_vpl VALUES ("PS129_5","020_129_5","PSA","129","5","5","Aninga angamang arikaya Zion ko me kuesan mu ikup gimon ale dola namamonko. ");
INSERT INTO wsk_vpl VALUES ("PS129_6","020_129_6","PSA","129","6","6","Ale tari bisek kawam gul te aragoso, ale me tamaso bare maraka namoso wore iwita kuemonko; ");
INSERT INTO wsk_vpl VALUES ("PS129_7","020_129_7","PSA","129","7","7","kari bo ko luan yu naukko me terong, se inangnang seng ko muguri namonko me terong tala. ");
INSERT INTO wsk_vpl VALUES ("PS129_8","020_129_8","PSA","129","8","8","Se awiriya kariimet imi nunga kia kapa se mu, marak den imi me balu nungarmonko: ale balmon, “Kari Biya ko marak sokel nengerak bagoso,” ma me balmon; agi “Ana Kaem Biya ko nup te nina marak sokel ningarsan,” ma me balmonko tala. ");
INSERT INTO wsk_vpl VALUES ("PS130_1","020_130_1","PSA","130","1","1","(Ilu se temple te nama tarigira ko wur) O Yawe, ani ikup ningi sarenga namarikko iwita se ka arusam. ");
INSERT INTO wsk_vpl VALUES ("PS130_2","020_130_2","PSA","130","2","2","O aga Biya, agiring ikiko, degewa gurugu ale agiring iki ale aga sangaruko. ");
INSERT INTO wsk_vpl VALUES ("PS130_3","020_130_3","PSA","130","3","3","O Yawe, ni anananga memek suen la ari kutuwusam, ale memek mu te sanamir mu, awiri memek mena se ningo bagarukko? Mena. ");
INSERT INTO wsk_vpl VALUES ("PS130_4","020_130_4","PSA","130","4","4","Bare ni anananga memek siwu nangarsam, se ana ni bowa ningi kua kisu se laganakko. ");
INSERT INTO wsk_vpl VALUES ("PS130_5","020_130_5","PSA","130","5","5","Ani Yawe aga sangukko angamang motam lilim te ko kimi bitawasam, ale ko den te la ira sanami lagasam. ");
INSERT INTO wsk_vpl VALUES ("PS130_6","020_130_6","PSA","130","6","6","Sor bitua kari sor pasak ukirok se nama noman saparukko kimi tui lagoso iwitatala, ani Kari Biya tairuk aga sangukko amotam bitawasam. ");
INSERT INTO wsk_vpl VALUES ("PS130_7","020_130_7","PSA","130","7","7","O Israel, Yawe kote la loaga se lagaralko, mu awuk, nu ana ninguru nanga kua lagoso, ale nu nanga sangukko terong. ");
INSERT INTO wsk_vpl VALUES ("PS130_8","020_130_8","PSA","130","8","8","Nu kota anananga memek suen la siwura ikiso. ");
INSERT INTO wsk_vpl VALUES ("PS131_1","020_131_1","PSA","131","1","1","(Ilu se temple te nama tarigira ko wur; David ko wur) O Yawe, aitak ani angamang motam kua kaparam, se aimi patawura ko munan mu abiring tuem; ani mel bibiya ko ikia me bitawasam, ale mel duap duap te me loagawasam. ");
INSERT INTO wsk_vpl VALUES ("PS131_2","020_131_2","PSA","131","2","2","Angimik kua lila aram, se kutek maem ale kuriang mimili kitak tuguma se kuamili sapa ani lagara iwita bagasam. ");
INSERT INTO wsk_vpl VALUES ("PS131_3","020_131_3","PSA","131","3","3","O Israel, nina aitak se tom pempem la Yawe kote la loaga se lagaralko. ");
INSERT INTO wsk_vpl VALUES ("PS132_1","020_132_1","PSA","132","1","1","(Ilu se temple te nama tarigira ko wur) O Yawe, nika ura kari David ura ko ikup yaman gi lagaram mu ko kamili me saparukko. ");
INSERT INTO wsk_vpl VALUES ("PS132_2","020_132_2","PSA","132","2","2","Nu den bo Yawe ilak kaolam, Jacob ko Kaem Sokel Garagar mu ilak ikia bo iwita kaolam: ");
INSERT INTO wsk_vpl VALUES ("PS132_3","020_132_3","PSA","132","3","3","“Ani,” mam, “aga kawam ningi me ta kasu nagurek, agi aga anira kuwim te me ta taga anirek, ");
INSERT INTO wsk_vpl VALUES ("PS132_4","020_132_4","PSA","132","4","4","ale amotam kuagi ningi anira me ta tairuk, se amotam kui me ta ira kulukekkowo, ");
INSERT INTO wsk_vpl VALUES ("PS132_5","020_132_5","PSA","132","5","5","yam kaeyawirik ale Yawe ko bagara kuwim bo arigek bare asele kowo, ani Jacob ko Kaem Sokel Garagar wore ko kuwim bo ningi bagarukko wore kalikko.” ");
INSERT INTO wsk_vpl VALUES ("PS132_6","020_132_6","PSA","132","6","6","Ana Ephrathah baga se Kaem ko Kunup Laili mu ko den ikiman, ale nama Jearim wonong te arigiman. ");
INSERT INTO wsk_vpl VALUES ("PS132_7","020_132_7","PSA","132","7","7","“Ana noko bagara kuwim te namanak ale noko suwik duap ningi nabugura kulukurnak ale ko nup patawunak, ale balnak, ");
INSERT INTO wsk_vpl VALUES ("PS132_8","020_132_8","PSA","132","8","8","‘O Yawe, bares ale nika kuwim te tairko, ni se ka Kunup Laili nika sokel aora karogo mu agotala. ");
INSERT INTO wsk_vpl VALUES ("PS132_9","020_132_9","PSA","132","9","9","Se nika priest alo mu munan ningo dirkiriyam mu guang tuguma iwita te bala betemon, se nika kariimet mu amilmil wur ilumonko.’ ” ");
INSERT INTO wsk_vpl VALUES ("PS132_10","020_132_10","PSA","132","10","10","Nika ura kari David ko kamin ares mauk se nika kari marak sokel tuem mu me ari daleluwurko. ");
INSERT INTO wsk_vpl VALUES ("PS132_11","020_132_11","PSA","132","11","11","Yawe David ilak den bo kaolam, se den mu aora biya aniso se nu me maguwurokko. Se den mu iwita: “Ani nika gue te bo bitirik se nika kiwim te king ko bagarukko. ");
INSERT INTO wsk_vpl VALUES ("PS132_12","020_132_12","PSA","132","12","12","Ikiko. Nika kuriang gue aninga den kalem mu karo tumon, ale aninga munan nunga kausem mu karo tumon, mu nononga gue te pempem butata king ko baga lagamonko.” ");
INSERT INTO wsk_vpl VALUES ("PS132_13","020_132_13","PSA","132","13","13","Nunguningta, Yawe nu Zion atumukiram, se mu noko wonong ko aratam. ");
INSERT INTO wsk_vpl VALUES ("PS132_14","020_132_14","PSA","132","14","14","Nu balam, “Imi aninga wonong pempem la anirukko,” mam. “Ani imi te daigek ale baga se kariimet nunga bituekko, mu awuk, ani angamang tuem. ");
INSERT INTO wsk_vpl VALUES ("PS132_15","020_132_15","PSA","132","15","15","Ani Zion na inang mel suen la mu waru tuek se udagi me ko tatopurukko; ani ko kariimet nungumik mel mena mu na inang nungarikko. ");
INSERT INTO wsk_vpl VALUES ("PS132_16","020_132_16","PSA","132","16","16","Ani noko priest alo mu kariimet te nunga gia ko marak sokel mu nungarikko, se noko kariimet amilmil wur ilumonko. ");
INSERT INTO wsk_vpl VALUES ("PS132_17","020_132_17","PSA","132","17","17","“Se ani David ko gue te king bo nup biya sokel garagar Zion bitirikko; se nu mu galep bo iwita kani se lagarukko. ");
INSERT INTO wsk_vpl VALUES ("PS132_18","020_132_18","PSA","132","18","18","Ani noko kager kari memek mu dolara nungarikko; bare nu mu king nup biya sokel ago bagarukko.” ");
INSERT INTO wsk_vpl VALUES ("PS133_1","020_133_1","PSA","133","1","1","(Ilu se temple te nama tarigira ko wur; David ko wur) Launuria arerem la numi gomang suanta bagara ko munan mu mel ningo se yawarakala nunguningkiri! ");
INSERT INTO wsk_vpl VALUES ("PS133_2","020_133_2","PSA","133","2","2","Munan umu oil yawara bo Aaron mone te warman se palengam kapa somone te, se kapa ko guang norogen dogotak te mu kau tam, wore iwita. ");
INSERT INTO wsk_vpl VALUES ("PS133_3","020_133_3","PSA","133","3","3","Se akingtala baras nuwi kusat yawara duruk Hermon te se duruk Zion awote kaposo wore iwita. Mu awuk, munan yawara umu ningi, Yawe ko marak ningo ko kariimet nungarso, se te pempem ningo la baga lagamonko. ");
INSERT INTO wsk_vpl VALUES ("PS134_1","020_134_1","PSA","134","1","1","(Ilu se temple te nama tarigira ko wur) Nina Yawe ko ura kari alo, tirom suen biya noko temple ningi ura betesan, mu nup patawuralko. ");
INSERT INTO wsk_vpl VALUES ("PS134_2","020_134_2","PSA","134","2","2","Nina noko kuwim laili mu ningi nigiting patatuwural ale nup patawuralko! ");
INSERT INTO wsk_vpl VALUES ("PS134_3","020_134_3","PSA","134","3","3","Se Yawe nu taiti se ali kiwolaram mu Zion baga se marak ningarukko. ");
INSERT INTO wsk_vpl VALUES ("PS135_1","020_135_1","PSA","135","1","1","Yawe ko nup patawuralko! Nina nup biya tualko! Nina noko ura kari alo, ");
INSERT INTO wsk_vpl VALUES ("PS135_2","020_135_2","PSA","135","2","2","noko temple ningi ura betesan mu se, sikina noko galung laili nunguningkiri mu ningi ura betesan mu karogotala, noko nup biya patawuralko! ");
INSERT INTO wsk_vpl VALUES ("PS135_3","020_135_3","PSA","135","3","3","Yawe nup patawuralko, mu awuk, nu Kaem ningo; wur te nup biya patawuralko, mu awuk, nu ningo pempem la. ");
INSERT INTO wsk_vpl VALUES ("PS135_4","020_135_4","PSA","135","4","4","Yawe Israel atumukiram ale noko ma balam, Jacob mu noko mel ningo yawara. ");
INSERT INTO wsk_vpl VALUES ("PS135_5","020_135_5","PSA","135","5","5","Ani ikisam anananga Kaem mu ko sokel aora garagar nup biya, nu kaem suen la nunga kiaram. ");
INSERT INTO wsk_vpl VALUES ("PS135_6","020_135_6","PSA","135","6","6","Yawe kota ko gomang te la anapeya mel bitirukko mu beteso se arataso, taiti gomang te, ali imi te, gagi ningi, se gagi nukum du biya mu te. ");
INSERT INTO wsk_vpl VALUES ("PS135_7","020_135_7","PSA","135","7","7","Nu taiti nuwi beteso se basuso; nu pure nikim tuwik ago beteso, ale marir beteso se arataso. ");
INSERT INTO wsk_vpl VALUES ("PS135_8","020_135_8","PSA","135","8","8","Nu Egypt nunga kuriang gira bilangara mu nunga moram se kua sapaman, kariimet ko gue te, se buruk kausik ko gue te koma suanta. ");
INSERT INTO wsk_vpl VALUES ("PS135_9","020_135_9","PSA","135","9","9","O Egypt, nu noko kausa se kiwem bibiya nika ningi beteram, nika Pharaoh se ko ura kari nungumik te beteram. ");
INSERT INTO wsk_vpl VALUES ("PS135_10","020_135_10","PSA","135","10","10","Nu sor suen biya nunga maguwuram, ale nunga king sokel karogo mu nunga moram se kueman: ");
INSERT INTO wsk_vpl VALUES ("PS135_11","020_135_11","PSA","135","11","11","King Sihon, sor Amor mu nunga king mu se, sor Bashan mu nunga king Og se, sor Canaan ko king suen la, kua sapaman. ");
INSERT INTO wsk_vpl VALUES ("PS135_12","020_135_12","PSA","135","12","12","Ale nu nunga ali bataguru tam ale noko kariimet nunga ali ko nungaram, noko kariimet Israel nunga ali ko ma balam. ");
INSERT INTO wsk_vpl VALUES ("PS135_13","020_135_13","PSA","135","13","13","O Yawe, nika nip mu butata pempem anirukko; kariimet gue luan udagi mu ningi, nika nip biya butata ani lagarukko. ");
INSERT INTO wsk_vpl VALUES ("PS135_14","020_135_14","PSA","135","14","14","Mu awuk, ni ka kariimet nunga giem ale bitua ningo te nunga bitarsam, ale gemang motam nungarsam. ");
INSERT INTO wsk_vpl VALUES ("PS135_15","020_135_15","PSA","135","15","15","Sor saki nunga kaem mu, manga tam te agi, silver se gold te nunga nungurman, kariimet nongota nunga nuguting te nunga nungurman. ");
INSERT INTO wsk_vpl VALUES ("PS135_16","020_135_16","PSA","135","16","16","Se nuna nuguring ago wore, me te munakasan, ale nomotam ago wore, me te loagasan; ");
INSERT INTO wsk_vpl VALUES ("PS135_17","020_135_17","PSA","135","17","17","nuna nodogawa ago wore, me te den ikisan, ale nungamuru ago wore, sor siring te me ikisan. ");
INSERT INTO wsk_vpl VALUES ("PS135_18","020_135_18","PSA","135","18","18","Se arikaya kaem kawel mu nunga nungurman ale ko nongomang ningi nunguning aram mu, kaem kawel mu bagasan uwutatala bagamonko. ");
INSERT INTO wsk_vpl VALUES ("PS135_19","020_135_19","PSA","135","19","19","O Israel kariimet, nina Yawe nup patawuralko; O Aaron ko gue te ko priest alo, Yawe nup patawuralko. ");
INSERT INTO wsk_vpl VALUES ("PS135_20","020_135_20","PSA","135","20","20","O Levi ko gue te ko kariimet, Yawe nup patawuralko; nina awiriya noko nguangasan, mu noko nup patawuralko. ");
INSERT INTO wsk_vpl VALUES ("PS135_21","020_135_21","PSA","135","21","21","Yawe ko nup Zion ningi patawuralko; nu Jerusalem bagoso. Yawe ko nup patawuralko. Nunguning. ");
INSERT INTO wsk_vpl VALUES ("PS136_1","020_136_1","PSA","136","1","1","Ana Yawe amilmil tunakko, mu awuk, nu ningo nunguningkiri. ");
INSERT INTO wsk_vpl VALUES ("PS136_2","020_136_2","PSA","136","2","2","Ana Kaem amilmil tunakko, mu awuk, nu kaem kawel suen la nunga kiaram ale nu la Biya. ");
INSERT INTO wsk_vpl VALUES ("PS136_3","020_136_3","PSA","136","3","3","Ana Kari Biya amilmil tunakko, mu awuk, nu kari bibiya suen la nunga kiaram ale nu la Kari Biya. ");
INSERT INTO wsk_vpl VALUES ("PS136_4","020_136_4","PSA","136","4","4","Yawe amilmil tunakko. Nu kota kiwem bibiya duap duap beteso. ");
INSERT INTO wsk_vpl VALUES ("PS136_5","020_136_5","PSA","136","5","5","Noko ikia te la taiti lilim beteram se aratam. ");
INSERT INTO wsk_vpl VALUES ("PS136_6","020_136_6","PSA","136","6","6","Nu ali yu guang awote murakoyam muru beteram. ");
INSERT INTO wsk_vpl VALUES ("PS136_7","020_136_7","PSA","136","7","7","Nu nikim ko melmasak bibiya nunga beteram. ");
INSERT INTO wsk_vpl VALUES ("PS136_8","020_136_8","PSA","136","8","8","Worem mu woremkalal nikim tuokko. ");
INSERT INTO wsk_vpl VALUES ("PS136_9","020_136_9","PSA","136","9","9","Sige se baras mu tirom nikim tumonko. ");
INSERT INTO wsk_vpl VALUES ("PS136_10","020_136_10","PSA","136","10","10","Yawe amilmil tunakko. Nu Egypt kariimet nunga kuriang gira bilangara mu nunga moram se kua sapaman. ");
INSERT INTO wsk_vpl VALUES ("PS136_11","020_136_11","PSA","136","11","11","Nu Egypt alo nunga ningi Israel kariimet nunga giam ale nongorak aratam. ");
INSERT INTO wsk_vpl VALUES ("PS136_12","020_136_12","PSA","136","12","12","Noko kuting sokel aora biya mu te nunga giam. ");
INSERT INTO wsk_vpl VALUES ("PS136_13","020_136_13","PSA","136","13","13","Nu gagi biya Red Sea bataguru ilagala awuram. ");
INSERT INTO wsk_vpl VALUES ("PS136_14","020_136_14","PSA","136","14","14","Ale ko kariimet arungu moke sang te namaram. ");
INSERT INTO wsk_vpl VALUES ("PS136_15","020_136_15","PSA","136","15","15","Bare Pharaoh ko kager kari karogo mu gagi nunga moa mituwuram. ");
INSERT INTO wsk_vpl VALUES ("PS136_16","020_136_16","PSA","136","16","16","Yawe amilmil tunakko. Nu ko kariimet nunga giam ale nu giri giri nongorak sor merang garagarayam mu ningi aolak ilukaso. ");
INSERT INTO wsk_vpl VALUES ("PS136_17","020_136_17","PSA","136","17","17","Nu sor saki ko king sokel garagar mu nunga iram se kapaman. ");
INSERT INTO wsk_vpl VALUES ("PS136_18","020_136_18","PSA","136","18","18","Nu king nunup bibiya nunga moram se kueman. ");
INSERT INTO wsk_vpl VALUES ("PS136_19","020_136_19","PSA","136","19","19","Sor Amor nunga king Sihon. ");
INSERT INTO wsk_vpl VALUES ("PS136_20","020_136_20","PSA","136","20","20","Se sor Bashan nunga king Og, mu nunga moram se kueman. ");
INSERT INTO wsk_vpl VALUES ("PS136_21","020_136_21","PSA","136","21","21","Nu nunga ali sor mu bataguru noko kariimet Israel nungaram. ");
INSERT INTO wsk_vpl VALUES ("PS136_22","020_136_22","PSA","136","22","22","Se ali umu eng am nungara nunguning ko kariimet nungaram. ");
INSERT INTO wsk_vpl VALUES ("PS136_23","020_136_23","PSA","136","23","23","Yawe amilmil tunakko. Nu ana ikup memek biya ningi kapaman bare nago ko gomang batagam. ");
INSERT INTO wsk_vpl VALUES ("PS136_24","020_136_24","PSA","136","24","24","Nu kager kari memek alo nuguting te nanga bataguru tam. ");
INSERT INTO wsk_vpl VALUES ("PS136_25","020_136_25","PSA","136","25","25","Nu kariimet se mel suen la inang nungarso. ");
INSERT INTO wsk_vpl VALUES ("PS136_26","020_136_26","PSA","136","26","26","Buta se, ana tom suen biya anananga Kaem duruk wonong te bagoso mu amilmil tui se laganakko. Noko kua nangara mu kumik menara mena. Nunguningta. ");
INSERT INTO wsk_vpl VALUES ("PS137_1","020_137_1","PSA","137","1","1","Ana Babylon wonong te yu norogen te dagiwa se Zion wonong ko nangamin tuguman ale ko namononge kapakaso. ");
INSERT INTO wsk_vpl VALUES ("PS137_2","020_137_2","PSA","137","2","2","Se nanga wur kagin ko bawe mu tam kower te itutuwuman, ");
INSERT INTO wsk_vpl VALUES ("PS137_3","020_137_3","PSA","137","3","3","mu awuk, kari nanga ilu talipaman ale nangarak nunga sor te taiman mu wur ilunakko nanga diruwukasan, ale nanga manarukasan, “Nina Zion ko wur amilmil bo iluwal se ana ikinakko!” makasan. ");
INSERT INTO wsk_vpl VALUES ("PS137_4","020_137_4","PSA","137","4","4","Bare ana sor iwareng imi te Yawe ko wur ningo ngual kasik ilunakko mu me terong. ");
INSERT INTO wsk_vpl VALUES ("PS137_5","020_137_5","PSA","137","5","5","O Jerusalem, ani ni ko ko angamili sapa namaruk mu, agiting sengam mu magaruk se ani bawe te me morikko. ");
INSERT INTO wsk_vpl VALUES ("PS137_6","020_137_6","PSA","137","6","6","O Jerusalem, ni aninga mel gira, ani ni ko ko amilmil kelaga lagasam; se ani ni ko ko angamili saparuk mu, agiring am sisirokko. ");
INSERT INTO wsk_vpl VALUES ("PS137_7","020_137_7","PSA","137","7","7","O Yawe, munan memek Edom kariimet, tom Jerusalem te dagulam se beteman, mu me ko kamili saparukko; nuna aikasan balukasan, “Wonong sumu am menawuralko!” makasan. “Kawam digo bo me bagarukko.” ");
INSERT INTO wsk_vpl VALUES ("PS137_8","020_137_8","PSA","137","8","8","Babylon, ni iwita ikiko, ni ikup arikkowo! Kari awiriya munan memek ni ana nangimik te beterem mu ko koma beteso mu, kari umu amilmil kelagukko. ");
INSERT INTO wsk_vpl VALUES ("PS137_9","020_137_9","PSA","137","9","9","Kari umu nika kuriang nunga giok ale am manga awote nunga waruk se kua paranga namamonko. ");
INSERT INTO wsk_vpl VALUES ("PS138_1","020_138_1","PSA","138","1","1","(David ko wur) O Yawe, ani angamang motam lilim la te amilmilarik ale nip patawurikko; kaem kawel alo nongoma te ta wore, nika amilmil wur iluwekko. ");
INSERT INTO wsk_vpl VALUES ("PS138_2","020_138_2","PSA","138","2","2","Ani angama motam nika temple laili mu tuek ale, nika kua nangara se diram la karo tua ko kiwem mu ko, abugura kulukek ale nip patawurikko. Mu awuk, ni ka nip se ka den mu ko sinar tasam, se mel suen biya nunga kia saparam ale kualala biya bagoso. ");
INSERT INTO wsk_vpl VALUES ("PS138_3","020_138_3","PSA","138","3","3","Ani ka aurem se ni agiring iluwem; ni sangam aisem se angamang sokel ago bagasam. ");
INSERT INTO wsk_vpl VALUES ("PS138_4","020_138_4","PSA","138","4","4","O Yawe, ali imi ko king suen la nika den ikimon ale nip patawumonko. ");
INSERT INTO wsk_vpl VALUES ("PS138_5","020_138_5","PSA","138","5","5","Nuna nika munan ningo ko amilmilamon ale wur ilu se nip patawumonko, mu awuk, ni nip biya nikim garagar. ");
INSERT INTO wsk_vpl VALUES ("PS138_6","020_138_6","PSA","138","6","6","Yawe kualala biya nup ago baga se ta wore, nu nunumi ago kapara alo mu nunga bitarso; bare nu nunumi patawura alo mu nongorak kaposo. ");
INSERT INTO wsk_vpl VALUES ("PS138_7","020_138_7","PSA","138","7","7","Ani ikup yaman duap duap agate taiso ta wore, ni aninga sangorsam; kager kari memek alo agarak betesan ta wore, ni ka kiting sokel ago mu te aninga bataguru tasam. ");
INSERT INTO wsk_vpl VALUES ("PS138_8","020_138_8","PSA","138","8","8","O Yawe, ani ko ikiem nunguningkiri mu ni keta aninga atumu sangaruko; nika gemang kua aisa mu kumik menara mena. Buta se ni me aga bitarko, mu awuk, ani nika kiting kiwol. ");
INSERT INTO wsk_vpl VALUES ("PS139_1","020_139_1","PSA","139","1","1","(David ko wur) O Yawe, ni aninga angamang ari saperem ale ninguru aga ikisam. ");
INSERT INTO wsk_vpl VALUES ("PS139_2","020_139_2","PSA","139","2","2","Ani dagisam agi barasasam mu ni am ko iki sapasam; ani awar ta bagasam agi wore ni aninga ikia am ari sapasam. ");
INSERT INTO wsk_vpl VALUES ("PS139_3","020_139_3","PSA","139","3","3","Ni aninga namara taira bagara aolak mu am ari ko iki sapasam. ");
INSERT INTO wsk_vpl VALUES ("PS139_4","020_139_4","PSA","139","4","4","O Yawe, den ani agiring te aratukko, mu ni girisam ikiwasam se ani balsam. ");
INSERT INTO wsk_vpl VALUES ("PS139_5","020_139_5","PSA","139","5","5","Ni ani amake ko, abiring ko, se abeta koma singsang bagasam, ale ka kiting te aga iramursam. ");
INSERT INTO wsk_vpl VALUES ("PS139_6","020_139_6","PSA","139","6","6","Ni ani ninguru aga iki sapasam mu aningate mel aromemek, se ani ko iki saparikko me terong. ");
INSERT INTO wsk_vpl VALUES ("PS139_7","020_139_7","PSA","139","7","7","Awiri nika Bur ko motam ko yumura ikiso? Ani aparete nagu namarik ale ni motam ko yumurekko? ");
INSERT INTO wsk_vpl VALUES ("PS139_8","020_139_8","PSA","139","8","8","Ani taiti gomang te ta nama yumurek, bare ni mu te bagasam; aking gagi naung du biya ningi nama yumurek ta, wore ni mu te bagasam tala. ");
INSERT INTO wsk_vpl VALUES ("PS139_9","020_139_9","PSA","139","9","9","Se ani binga nama worem bausa te, se nama gagi biya dun sang te ta wore, ");
INSERT INTO wsk_vpl VALUES ("PS139_10","020_139_10","PSA","139","10","10","nika kiting te am aga ilu se aga kiti guruguwasam. ");
INSERT INTO wsk_vpl VALUES ("PS139_11","020_139_11","PSA","139","11","11","Ani ta balik, “Nikinang menaruk se tiromorom aga lautok ale aga ira kaluwurokko,” ma balik ta wore, ");
INSERT INTO wsk_vpl VALUES ("PS139_12","020_139_12","PSA","139","12","12","tiromorom mu nika motam te am nikim la, mu awuk, tirom se kowarkalal mu nika motam te am koma suanta. ");
INSERT INTO wsk_vpl VALUES ("PS139_13","020_139_13","PSA","139","13","13","Ni aninga angimik nuamur suen la nungem, ni ani ayam tuagu ningi la aga nungem burangerem. ");
INSERT INTO wsk_vpl VALUES ("PS139_14","020_139_14","PSA","139","14","14","Se ni aninga nungem mu am duap bo, se ani ka nip patawusam; ani ninguru ikisam, nika ura suen la bita saperem mu ko balu kutuwurekko me terong. ");
INSERT INTO wsk_vpl VALUES ("PS139_15","020_139_15","PSA","139","15","15","Tom ani aga ayam tuagu ningi yumura la lagawakasam, mu ni aninga angimik lilim mu ari ko ikiwakasam. ");
INSERT INTO wsk_vpl VALUES ("PS139_16","020_139_16","PSA","139","16","16","Tom ani me bilangerem, am gue te bagerem la, ni aga ikiem, ale aga marak bagara tom mu bataguru beterem. ");
INSERT INTO wsk_vpl VALUES ("PS139_17","020_139_17","PSA","139","17","17","O Kaem, nika ikia ani ago ko mu ulal biya se ani awuk ko iki saparikko? Nika ikia suen biya nunguningkiri, ");
INSERT INTO wsk_vpl VALUES ("PS139_18","020_139_18","PSA","139","18","18","se saun iwita, ani kau saparikko me terong; ani taga anirek ale barasik, wore ni ani agarak am butata baga lagasam. ");
INSERT INTO wsk_vpl VALUES ("PS139_19","020_139_19","PSA","139","19","19","O Kaem, aninga angamang ni kariimet memek nunga moar se kuemonko! Nina kari nigiting gue ago, tagi talko! ");
INSERT INTO wsk_vpl VALUES ("PS139_20","020_139_20","PSA","139","20","20","Nuna nika nip balu maguwusan, ale den memek memek ni ko ko balsan. ");
INSERT INTO wsk_vpl VALUES ("PS139_21","020_139_21","PSA","139","21","21","O Yawe, arikaya ni me ka kuesan, mu ani betela me nunga kuesam; se arikaya ni kerak barimasan, mu ani nunga angamang ninguru magoso. ");
INSERT INTO wsk_vpl VALUES ("PS139_22","020_139_22","PSA","139","22","22","Ani me nunga kuesam nunguningkiri, ale kari memek ko nungarkasam. ");
INSERT INTO wsk_vpl VALUES ("PS139_23","020_139_23","PSA","139","23","23","O Kaem, ni aninga angamang motam ari gurugu ale aga ikia suen la ari ikiko. ");
INSERT INTO wsk_vpl VALUES ("PS139_24","020_139_24","PSA","139","24","24","Ale memek mu menawur ale pempem la ningo bagara ko lage te aga bitarko. ");
INSERT INTO wsk_vpl VALUES ("PS140_1","020_140_1","PSA","140","1","1","(David ko wur) O Yawe, ni kari memek alo nuguting te aga bataguru toko! Aga bitaru se kager ko kari memek me aga bita maguwumonko! ");
INSERT INTO wsk_vpl VALUES ("PS140_2","020_140_2","PSA","140","2","2","Nuna pempem nongomang ningi ikia memek betemonko iki gurugu lagasan. Ale ngual ngual kager patawusan. ");
INSERT INTO wsk_vpl VALUES ("PS140_3","020_140_3","PSA","140","3","3","Nunga nungamili nuguring mu mot memek ko wore toroman, mot urer ko kuating memek iwita mu nunga nungamili kopa te aniso. ");
INSERT INTO wsk_vpl VALUES ("PS140_4","020_140_4","PSA","140","4","4","O Yawe, aga sinar to se kari memek alo me aga momon maguwumonko; aga bitaru se kager daong ko kari alo aga sapamon se dagulekko balman mu uwuta me betemonko. ");
INSERT INTO wsk_vpl VALUES ("PS140_5","020_140_5","PSA","140","5","5","Nunumi patawura ko kari alo mu ani aga ilumonko dagarok bo kira beteman; nuna dagarok ko mayang lage ani te namarikko mu te kira karogo nama tai beteman. ");
INSERT INTO wsk_vpl VALUES ("PS140_6","020_140_6","PSA","140","6","6","O Yawe, ani ni ko ko balsam, ni aninga Kaem masam. Aga sangaruko niara kete betesam ewere degewa gurugu ale ikiko. ");
INSERT INTO wsk_vpl VALUES ("PS140_7","020_140_7","PSA","140","7","7","O Yawe, ni keta suanta ni Kaem, ni aga Bataguru Tata aora; ni kager ko tom ningi mu aninga karem yawara. ");
INSERT INTO wsk_vpl VALUES ("PS140_8","020_140_8","PSA","140","8","8","Ni memek bitawara alo mu nunga ikia memek mu me motam la arikko; nunga ikia memek kaloman wore nunguning kaparuk se nunumi patawumon bore ko, maguwurko. ");
INSERT INTO wsk_vpl VALUES ("PS140_9","020_140_9","PSA","140","9","9","Kager kari memek alo aga laturman agarak bagasan mu, motam la nungarkiwer se me aga kiamonko; bare ikup ani angimik te betemonko balman mu giris palaguk ale nongota nunga maguwurokko. ");
INSERT INTO wsk_vpl VALUES ("PS140_10","020_140_10","PSA","140","10","10","Tama kaok kaniwara wore nungumik kuali waru ale tama ningi nunga waruko; mutim du biya mu ningi nunga waru se kapamon ale udagi me pila basumonko! ");
INSERT INTO wsk_vpl VALUES ("PS140_11","020_140_11","PSA","140","11","11","Kawel kari memek alo umu ali imi te kuring bo me ta nungaruko; kager daong ko kari memek alo mu ikup memek nunga irok se memek tamonko. ");
INSERT INTO wsk_vpl VALUES ("PS140_12","020_140_12","PSA","140","12","12","O Yawe, ani ko ikisam ni kariimet nungumik mel mena mu nunga bitarsam, ale kituwura guat alo mu munan ningo diram la nongote betesam. ");
INSERT INTO wsk_vpl VALUES ("PS140_13","020_140_13","PSA","140","13","13","Nunguningta, kariimet ningo dirkiriyam mu nika nip biya amilmil tui se diram la ni kema te bagamonko. ");
INSERT INTO wsk_vpl VALUES ("PS141_1","020_141_1","PSA","141","1","1","(David ko wur) O Yawe, ani nika arusam; tairate agate tairko. Tom ani ka aurik mu, agiring ikiko. ");
INSERT INTO wsk_vpl VALUES ("PS141_2","020_141_2","PSA","141","2","2","Aninga guranek mu mel yawara bo ko tama bur siring yawara iwita toko; aninga agiting kanuwa mu, tirom bainga ko tama bita kisa iwita. ");
INSERT INTO wsk_vpl VALUES ("PS141_3","020_141_3","PSA","141","3","3","O Yawe, aninga agiring ko sinar to se agiring angamili te den memek bo me ta aratukko. ");
INSERT INTO wsk_vpl VALUES ("PS141_4","020_141_4","PSA","141","4","4","Ni agarkiwer se ikia memek bo aninga angamang motam me tagirok, agi kilek memek betera ko kariimet alo nongorak munan memek bitirik ale nunga nam giam ningi me nongorak daigekko. ");
INSERT INTO wsk_vpl VALUES ("PS141_5","020_141_5","PSA","141","5","5","Kakirip ningo dirkiriyam mu aga memek ko bu am aisuokko, mu kiwem ningo agate beteso; nu am ining aisuokko; mu aga dingumuso. Ani kiwem imi ko me ta angamang ikuwoso, mu awuk, ani kariimet memek alo mu nunga memek koma kaola ko guranek bita lagasam. ");
INSERT INTO wsk_vpl VALUES ("PS141_6","020_141_6","PSA","141","6","6","Se memek alo umu nunga kari supuling mu garap te nunga warmon se kapamon, umu te asele nunga kariimet nunga ikia sinar aruk se balmon, “Kari mu ko den umu nunguningta nunguningkiri,” mamonko. ");
INSERT INTO wsk_vpl VALUES ("PS141_7","020_141_7","PSA","141","7","7","Ale balmon, “Nononga nosokelel mu manga papak mam ale parasaram bilik bilik kaparam iwita kuera mutim duap te sor iram,” mamonko. ");
INSERT INTO wsk_vpl VALUES ("PS141_8","020_141_8","PSA","141","8","8","O Yawe, ni keta suanta ni Kaem, ani ni kete la loaga lagasam; ni aninga yumura kuwim, se ani nika ningi yumusam; ni aga bita to se me kua namarikko. ");
INSERT INTO wsk_vpl VALUES ("PS141_9","020_141_9","PSA","141","9","9","Ni aga sangaru se bawang bo ago ko kereman mu me aga kutirokko, nunga dagarok kereman mu ningi me sorarikko tala. ");
INSERT INTO wsk_vpl VALUES ("PS141_10","020_141_10","PSA","141","10","10","Bare memek bitawara alo mu nunga ngual awur se nongota nunga dagarok nunga taliparukko, se ani mu yawarakala la nunga kia kaparik ale ningo la bagarikko. ");
INSERT INTO wsk_vpl VALUES ("PS142_1","020_142_1","PSA","142","1","1","(David Adullam manga gogong ningi yumuwa se den imi batogam) Ani Yawe kote niasam, nu gomang aisuk ale aga sangukko arusam. ");
INSERT INTO wsk_vpl VALUES ("PS142_2","020_142_2","PSA","142","2","2","Ani angamang ikup mu suen la nu manorsam se ikiso. ");
INSERT INTO wsk_vpl VALUES ("PS142_3","020_142_3","PSA","142","3","3","O Yawe, tom ani angamang motam sokel menaso, mu ni keta aninga saonga ko lage mu ko ikisam. Tuang ani te aolak ilusam mu dagarok bo kaluwura la te kira beteman. ");
INSERT INTO wsk_vpl VALUES ("PS142_4","020_142_4","PSA","142","4","4","Ni aninga abeta koma sing sang te loager ale arikko, kariimet bo aga sangukko mena; ani kuwim bo ta te yumurekko mu mena, kariimet bo ta ani ago ko me negeso. ");
INSERT INTO wsk_vpl VALUES ("PS142_5","020_142_5","PSA","142","5","5","O Yawe, ani ni kete niasam, ale balsam, “Ni mu aninga yumura kuwim, se tom ani ali imi te marak baga se mu, ni aninga mel ningo se gira nunguningkiri,” ma balsam. ");
INSERT INTO wsk_vpl VALUES ("PS142_6","020_142_6","PSA","142","6","6","Se degewa gurugu ale aninga niara ikiko; ani aeman sisi kaparam. Kari ikup aisisan mu nuguting te aga sangaru toko, mu awuk, ani nunga kiarikko me terong. ");
INSERT INTO wsk_vpl VALUES ("PS142_7","020_142_7","PSA","142","7","7","Se ikup ewere ko talipara ningi aga sangaru to se ani nika nip patawurikko. Nika ningo mu aninga te bitar se kariimet ningo diram bitawara mu arigimon ale tai agarak ilu biguwumon ale nip patawumonko. ");
INSERT INTO wsk_vpl VALUES ("PS143_1","020_143_1","PSA","143","1","1","(David ko wur) O Yawe, degewa gurugu ale aninga aira ikiko; nika kiwem mu diram nunguningkiri se ni den nunguning balsam; buta se tai aga sangaruko. ");
INSERT INTO wsk_vpl VALUES ("PS143_2","020_143_2","PSA","143","2","2","Ni aninga munan me tuatir ilupko, mu awuk, kariimet bo ta diram nika metam te me bagoso. ");
INSERT INTO wsk_vpl VALUES ("PS143_3","020_143_3","PSA","143","3","3","Kari ani agarak bitawara mu aga iluwam ale aga menawu ali karogo aga beteram; ale tiromorom ningi aga saparam se kariimet kua namakoyam iwita bagasam. ");
INSERT INTO wsk_vpl VALUES ("PS143_4","020_143_4","PSA","143","4","4","Buta se aninga adera angimik sokel menaram, ale angamang motam ningi yukuwa saparam. ");
INSERT INTO wsk_vpl VALUES ("PS143_5","020_143_5","PSA","143","5","5","Ani ulengkala, tom namaram wore ko angamin tugusam; ani nika ura suen la wore ko iki gurugu lagasam, ale nika kiting kiwol suen la nungem mu ko, ari ikisam. ");
INSERT INTO wsk_vpl VALUES ("PS143_6","020_143_6","PSA","143","6","6","Ani guranek te agiting kanusam ale ni kete niasam; ali marakam ale yu ko tukunangaso iwita, ani ni ko ko niawasam. ");
INSERT INTO wsk_vpl VALUES ("PS143_7","020_143_7","PSA","143","7","7","O Yawe, tairate agiring ilupko; aninga adera angimik sail menaram. Ni kema motam ani ago ko me kaluwurko; buta bitar mu ani kua iwi namara iwita bagarikko. ");
INSERT INTO wsk_vpl VALUES ("PS143_8","020_143_8","PSA","143","8","8","Turomola pempem nika kua ani aisa, kumik menara mena mu, aga kasuruko, mu awuk, ani ni kete la loaga lagasam. Ani aguwaya namarikko wore, ko lage aga kasuruko, mu awuk, aninga adera angimik mu ni kete la sokel taso. ");
INSERT INTO wsk_vpl VALUES ("PS143_9","020_143_9","PSA","143","9","9","O Yawe, aninga kager kari alo nuguting te aga bataguru toko, ale ni keta aninga karem iwita aga kaluwurko. ");
INSERT INTO wsk_vpl VALUES ("PS143_10","020_143_10","PSA","143","10","10","Ni aninga Kaem, nika kiwem aga kasuru se ani karo tuekko; se nika Bur Ningo lage diram aga kausok ale sor wolong te agarak aolak iluwokko. ");
INSERT INTO wsk_vpl VALUES ("PS143_11","020_143_11","PSA","143","11","11","O Yawe, keta ka nip ko ningo mu ko, aga sangaru toko; ni ningo dirkiriyam se ikup ningi aga bataguru toko. ");
INSERT INTO wsk_vpl VALUES ("PS143_12","020_143_12","PSA","143","12","12","Nika kua aisa mu wetang sapar ale memek alo mu nunga menawur se sor kutek maukko; suen la nunga maguwu saparko, mu awuk, ani nika ura kari. ");
INSERT INTO wsk_vpl VALUES ("PS144_1","020_144_1","PSA","144","1","1","(David ko wur) Ani Yawe nup patawurikko, nu aninga Manga Aora; nu ani kager ko munan aga kasurso, ale kager biya ningi namarikko aga nungurso burangoso. ");
INSERT INTO wsk_vpl VALUES ("PS144_2","020_144_2","PSA","144","2","2","Nu aninga kua aisa ko Kaem, se aninga manga gek am; nu aninga Sangam, se nu tala aninga Bataguru Tata Kari; nu aninga karem, ani nu kararasam. Nu sor saki ko kariimet arungu tai ani abowa tuguso. ");
INSERT INTO wsk_vpl VALUES ("PS144_3","020_144_3","PSA","144","3","3","O Yawe, ana ali kariimet mu, anape mel nunguningkiri se ni ninguru nanga sinar to lagasam? Ana ali kariimet yam ko gue, wore ni ninguru gemang nangaru lagasam. ");
INSERT INTO wsk_vpl VALUES ("PS144_4","020_144_4","PSA","144","4","4","Ana ali kariimet mu marir pus maso ale mena namoso iwita; anananga marak bagara ko tom mu tamarum iwita, tom tukunangta baga mena namoso iwitatala. ");
INSERT INTO wsk_vpl VALUES ("PS144_5","020_144_5","PSA","144","5","5","O Yawe, ni taiti gomang kaguru ale tai kaparko; duruk nunga kau to se tama bur barasukko. ");
INSERT INTO wsk_vpl VALUES ("PS144_6","020_144_6","PSA","144","6","6","Pure nikim bitar se kaparuk se kager kari memek nunga parusuwurko; nika gatu mare te nunga karo se nagumonko. ");
INSERT INTO wsk_vpl VALUES ("PS144_7","020_144_7","PSA","144","7","7","Kualala kiting garuku se tai kaparuk se aninga bataguru to ale aga sangaruko; yu lom bibiya ewere ningi se, sor iwareng ko kariimet nuguting te aga bataguru toko. ");
INSERT INTO wsk_vpl VALUES ("PS144_8","020_144_8","PSA","144","8","8","Nononga nuguring mu den kawel ago terong mam, se nunga nungamili mu guruga patawura karogo tala. ");
INSERT INTO wsk_vpl VALUES ("PS144_9","020_144_9","PSA","144","9","9","O Kaem, ani wur bo iru ilu kisekko; ani aga gita kolarik ale wur ilu kisekko. ");
INSERT INTO wsk_vpl VALUES ("PS144_10","020_144_10","PSA","144","10","10","Ni king nunga sangorsam se nuna kager te marirasan ko Kaem; se ani nika ura kari David, baenat kore memek wore ningi aga bataguru taem. ");
INSERT INTO wsk_vpl VALUES ("PS144_11","020_144_11","PSA","144","11","11","Buta se sor iwareng ko kari nuguting te aga bataguru to ale aga sangaruko! Nononga nuguring mu den kawel ago terong mam, se nunga nungamili mu guruga patawura karogo tala. ");
INSERT INTO wsk_vpl VALUES ("PS144_12","020_144_12","PSA","144","12","12","Nanga sangaru se anananga kuriang kari nunga kulak te la mu, tam bisek ali welang te aragoso iwita aragamonko; se nanga nanawusari mu, king ko kawam biya ko ngatalek bibiya kiwol karogo aora biya iwita bagamonko. ");
INSERT INTO wsk_vpl VALUES ("PS144_13","020_144_13","PSA","144","13","13","Nanga ningam mu inang duap duap karogo terong ma saparukko; se nanga sipsip mu kuriang ninguru ilumon se kaparuk ale ninguru sor to saparukko; ");
INSERT INTO wsk_vpl VALUES ("PS144_14","020_144_14","PSA","144","14","14","se nanga bulmakau mu, suen la kuriang nutagu ningi karogo yukuwa sapamonko. Se udagi kager memek por kuluka ale utu nagura mu menaruk, se nanga talipara ale sor iwareng te nangarak namara mu bo ago me aniruk, se wonong tuagu ningi yaman ko niara kikira mu mena namarukko. ");
INSERT INTO wsk_vpl VALUES ("PS144_15","020_144_15","PSA","144","15","15","Kariimet marak uwuta nungumik te kaposo mu amilmilamonko; kariimet awiriya Yawe mu nononga Kaem, mu amilmilamonko. ");
INSERT INTO wsk_vpl VALUES ("PS145_1","020_145_1","PSA","145","1","1","(David ko wur) Ani nip biya ko balu pagikko, ni aninga Kaem se aga King; ani pempem la butata nip patawu se lagarikko. ");
INSERT INTO wsk_vpl VALUES ("PS145_2","020_145_2","PSA","145","2","2","Kowarkalal pempem la ani nip patawurik ale ka nip pempem la butata gi patawu se lagarikko. ");
INSERT INTO wsk_vpl VALUES ("PS145_3","020_145_3","PSA","145","3","3","Yawe mu ko nup biya, se nup patawusan mu am diram; noko nup biya mu ko iki kutuwura ko mu me terong. ");
INSERT INTO wsk_vpl VALUES ("PS145_4","020_145_4","PSA","145","4","4","O Kaem, kuriang gue aitak mu, aking kuriang gue bo udagi mu, nika ura bibiya beterem mu nunga manarmonko; nika kiwem bibiya duap duap mu ko nunga manaru gurugumonko. ");
INSERT INTO wsk_vpl VALUES ("PS145_5","020_145_5","PSA","145","5","5","Nuna nika nikim sokel garagar se nip biya mu ko balmon, se ani mu nika kiwem mu ko ikia to se lagarikko. ");
INSERT INTO wsk_vpl VALUES ("PS145_6","020_145_6","PSA","145","6","6","Kariimet nika ura sokel garagar ago beterem mu ko balmon, se ani mu ni mel bibiya beterem mu ko balu pagikko. ");
INSERT INTO wsk_vpl VALUES ("PS145_7","020_145_7","PSA","145","7","7","Nuna nika ningo suen biya mu ko amilmilamon ale wur amilmil ilumon, ale nika munan ningo diram la mu ko amilmil kelagamonko. ");
INSERT INTO wsk_vpl VALUES ("PS145_8","020_145_8","PSA","145","8","8","Yawe mu gomang lila se gomang bataga ko Kaem; nu gomang tairate me magoso, se nu bo ko kua tuata ko munan karogo terong mam. ");
INSERT INTO wsk_vpl VALUES ("PS145_9","020_145_9","PSA","145","9","9","Yawe kariimet suen la nongorak ningo; nu mel suen la nungam mu ko gomang bataga karogo. ");
INSERT INTO wsk_vpl VALUES ("PS145_10","020_145_10","PSA","145","10","10","O Yawe, ni buruk kausik mel gotektek suen la nunga nungem se nama taiwasan, mu nika nip patawumonko; nika kariimet mu suen la amilmil kisimonko. ");
INSERT INTO wsk_vpl VALUES ("PS145_11","020_145_11","PSA","145","11","11","Nuna nika kingdom nikim garagar mu ko balmon, ale nika sokel garagar mu ko munakamon, ");
INSERT INTO wsk_vpl VALUES ("PS145_12","020_145_12","PSA","145","12","12","se kariimet suen la nika kiwem sokel ago bibiya beterem mu ko ikimon, ale ka kingdom nikim ago yawarakala mu ko ikimonko. ");
INSERT INTO wsk_vpl VALUES ("PS145_13","020_145_13","PSA","145","13","13","Nika king ko bagara mu kumik menara mena, se ni king ko tom pempem baga lagerko. Yawe mu noko den kaolam mu diram la karo saposo, ale ko kiwem suen la mu gomang lila te beteso. ");
INSERT INTO wsk_vpl VALUES ("PS145_14","020_145_14","PSA","145","14","14","Nu awiriya ikup ningi bagoso mu sangarso; nu awiriya dagulam mu patawuso se sanamoso. ");
INSERT INTO wsk_vpl VALUES ("PS145_15","020_145_15","PSA","145","15","15","Melmasak suen la marak bagasan mu amilmil te nikate loagasan; ale inang ko kuesan mu ni inang nungarsam. ");
INSERT INTO wsk_vpl VALUES ("PS145_16","020_145_16","PSA","145","16","16","Ni kiting ulaluwusam, ale kariimet mel i ko tukunangasan mu nungarsam. ");
INSERT INTO wsk_vpl VALUES ("PS145_17","020_145_17","PSA","145","17","17","Yawe mel suen la beteso mu ningo se diram la beteso; nu kiwem suen la mu gomang lila te la beteso. ");
INSERT INTO wsk_vpl VALUES ("PS145_18","020_145_18","PSA","145","18","18","Awiriya saonga ko nu arusan, nuna nongomang ningi nunguning te nu arusan, mu nu nongorak pingi bagoso. ");
INSERT INTO wsk_vpl VALUES ("PS145_19","020_145_19","PSA","145","19","19","Nu awiriya noko bowa ningi bagasan, mu mel bo ko tukunangasan mu nungarso; nu nunga niara ikiso ale nunga sangarso. ");
INSERT INTO wsk_vpl VALUES ("PS145_20","020_145_20","PSA","145","20","20","Nu kariimet nu ko kuesan mu nunga bitarso; bare kariimet memek bitawara mu nunga maguwurokko. ");
INSERT INTO wsk_vpl VALUES ("PS145_21","020_145_21","PSA","145","21","21","Ani pempem la Yawe nup patawurikko. Se melmasak suen la marak bagasan mu noko nup laili butata pempem patawu se lagamonko. ");
INSERT INTO wsk_vpl VALUES ("PS146_1","020_146_1","PSA","146","1","1","Ani Yawe nup patawurikko! Ani angamang motam lilim la te nup patawurikko. ");
INSERT INTO wsk_vpl VALUES ("PS146_2","020_146_2","PSA","146","2","2","Aninga bagara tom lilim la te Yawe nup patawurikko; aninga amotam loagawara ko tom imi lilim la te, Kaem ko wur ilu se nup patawu se lagarikko. ");
INSERT INTO wsk_vpl VALUES ("PS146_3","020_146_3","PSA","146","3","3","Nina ali imi ko kari supuling nongote me ira sanamaralko; ali kari bo ta me ninga sangukko. ");
INSERT INTO wsk_vpl VALUES ("PS146_4","020_146_4","PSA","146","4","4","Mu awuk, tom nuna nodora arataso, mu nuna nungumik guang ali ningi namoso; ale nunga ikia betemonko den nungurman mu mena namoso. ");
INSERT INTO wsk_vpl VALUES ("PS146_5","020_146_5","PSA","146","5","5","Bare kariimet Jacob ko Kaem mu nunga saonga bagoso, mu amilmilamonko; nuna Yawe, nononga Kaem, mu kote la loaga lagasan. ");
INSERT INTO wsk_vpl VALUES ("PS146_6","020_146_6","PSA","146","6","6","Nu taiti se ali, se gagi se mel suen la nunga ningi nungam, ale tom suen biya ko kiwol umu diram la iki karo tui lagoso. ");
INSERT INTO wsk_vpl VALUES ("PS146_7","020_146_7","PSA","146","7","7","Nu kariimet kituwura guat alo, nunga bita maguwusan, mu nunga sangarso; ale kariimet na inang ko kuawasan mu inang nungarso. Yawe mu kariimet talipara ningi anisan mu nunga sangarso se aratasan; ");
INSERT INTO wsk_vpl VALUES ("PS146_8","020_146_8","PSA","146","8","8","se kariimet nomotam sisira mu nomotam pagarso se sor arigisan. Nu kariimet nongomang bataga te magi tarawasan mu nunga sangarso, ale kariimet ningo diram mu nunga kueso. ");
INSERT INTO wsk_vpl VALUES ("PS146_9","020_146_9","PSA","146","9","9","Nu kariimet awar taira ale anananga ningi bagara mu nunga sinar taso, ale imet gerewa se kuriang marmar mu agotala nunga sangarso. Bare nu kariimet memek mu nunga ikia bitawasan mu menawuso. ");
INSERT INTO wsk_vpl VALUES ("PS146_10","020_146_10","PSA","146","10","10","Yawe butata King ko tom pempem baga lagoso; O Zion kariimet, nenenga Kaem butata pempem baga lagoso. Se Yawe nup patawuralko! Aleluya! ");
INSERT INTO wsk_vpl VALUES ("PS147_1","020_147_1","PSA","147","1","1","Yawe ko nup patawunakko! Anananga Kaem wur te nup patawura mu kiwem ningo, noko nup patawura ko kiwem mu yawarakala se diram! ");
INSERT INTO wsk_vpl VALUES ("PS147_2","020_147_2","PSA","147","2","2","Yawe akingtala Jerusalem kuwim kuwim te kaloso; nu Israel ko kariimet parasaman sor saki te bagakasan wore nunga gi bolala nunga awuso. ");
INSERT INTO wsk_vpl VALUES ("PS147_3","020_147_3","PSA","147","3","3","Nu kariimet nongomang motam parasaram mu nongomang taso, ale nunga lot gawir kalo nungurso. ");
INSERT INTO wsk_vpl VALUES ("PS147_4","020_147_4","PSA","147","4","4","Nu baras suen la nunga iki saposo, ale suan suan nunup awu awu karogo namaram. ");
INSERT INTO wsk_vpl VALUES ("PS147_5","020_147_5","PSA","147","5","5","Anananga Kari Biya nup biya, se sokel garagar; noko ikia sinar mu kumik ko tom batoga bo mena. ");
INSERT INTO wsk_vpl VALUES ("PS147_6","020_147_6","PSA","147","6","6","Yawe mu kariimet nunumi ago kapasan mu nunga tagi patawuso, bare kariimet memek bitawara mu nongorak kapa ali ago nunga beteso. ");
INSERT INTO wsk_vpl VALUES ("PS147_7","020_147_7","PSA","147","7","7","Yawe wur amilmil ilu tualko; bawe te yagowom gurugu anananga Kaem tualko. ");
INSERT INTO wsk_vpl VALUES ("PS147_8","020_147_8","PSA","147","8","8","Nu taiti nuwi beteso se arataso ale taiti gomang kaluwuso; nu tuwik ali lilim tuso se sirsir duruk motongar te aragoso. ");
INSERT INTO wsk_vpl VALUES ("PS147_9","020_147_9","PSA","147","9","9","Nu bulmakau na nungarso, ale inangnang ko gotek na ko niasan mu na nungarso. ");
INSERT INTO wsk_vpl VALUES ("PS147_10","020_147_10","PSA","147","10","10","Horse ko sokel mu tamatama, bare umu Kaem gomang motam amilmil me tuso. Turan te, kari nuar sokel tamatama mu ko, Kaem gomang motam me barasoso tala, mena. ");
INSERT INTO wsk_vpl VALUES ("PS147_11","020_147_11","PSA","147","11","11","Bare kariimet noko nguanga se, noko kua nangara ko munan nongomang tui se kote loaga lagasan, mu nu ninguru nunga amilmiloso. ");
INSERT INTO wsk_vpl VALUES ("PS147_12","020_147_12","PSA","147","12","12","O Jerusalem, ni Yawe nup patawurko; O Zion, nika Kaem nup patawurko. ");
INSERT INTO wsk_vpl VALUES ("PS147_13","020_147_13","PSA","147","13","13","Mu awuk, nu nika sor kuring sokel tuso, ale nika kariimet nika ningi bagasan, mu marak sokel nungarso. ");
INSERT INTO wsk_vpl VALUES ("PS147_14","020_147_14","PSA","147","14","14","Nu nika ali ko tom bitarso se terong aniso, se inang ningo nuam kisiso se ni karogo terong masam. ");
INSERT INTO wsk_vpl VALUES ("PS147_15","020_147_15","PSA","147","15","15","Noko den balso se tairate ali imi te tai kaposo ale nunguning kaposo. ");
INSERT INTO wsk_vpl VALUES ("PS147_16","020_147_16","PSA","147","16","16","Nu tama bur beteso se sor ereso, ale sor ninguru ipiso ale birigira ningi taiso, se ali awote sirar ma saposo. ");
INSERT INTO wsk_vpl VALUES ("PS147_17","020_147_17","PSA","147","17","17","Nu tuwik muguri bibiya manga karakarang iwita mu warso se kaposo. Se awiri tuwik ipi birigira karogo kaposo mu te bagarukko terong? ");
INSERT INTO wsk_vpl VALUES ("PS147_18","020_147_18","PSA","147","18","18","Aking nu balso se yu ipiram ale auram mu palenga yu ko namoso; nu noko marir guruguso patawuso se yu palengoso ale naguso. ");
INSERT INTO wsk_vpl VALUES ("PS147_19","020_147_19","PSA","147","19","19","Nu noko munan den mu Israel nungaram, noko kiti guruga ko den se noko karo tuata ko den mu ko kariimet umutang nungaram. ");
INSERT INTO wsk_vpl VALUES ("PS147_20","020_147_20","PSA","147","20","20","Bare nu munan imi sor bo ta nongote me bita arigam, mena; nuna noko munan den me ko ikisan. Yawe ko nup patawunakko! ");
INSERT INTO wsk_vpl VALUES ("PS148_1","020_148_1","PSA","148","1","1","O aleluya! Yawe ko nup patawunakko! Taiti kuali mel suen la, noko nup patawuralko! ");
INSERT INTO wsk_vpl VALUES ("PS148_2","020_148_2","PSA","148","2","2","Nina ko engel alo duruk wonong te suen la mu nina ko nup patawuralko. ");
INSERT INTO wsk_vpl VALUES ("PS148_3","020_148_3","PSA","148","3","3","Nina worem sige baras taiti awote nikim kapawasan, nina ko nup patawuralko; baras kaniwasan mu ko nup patawuralko. ");
INSERT INTO wsk_vpl VALUES ("PS148_4","020_148_4","PSA","148","4","4","Yu biya kuali, se mel suen la taiti kuali aniso, mu noko nup patawuralko. ");
INSERT INTO wsk_vpl VALUES ("PS148_5","020_148_5","PSA","148","5","5","Mel suen la imi mu nuna Yawe ko nup am patawumonko! Mu awuk, nu balam se nuna arataman. ");
INSERT INTO wsk_vpl VALUES ("PS148_6","020_148_6","PSA","148","6","6","Nu balam se tala nunga kuwim kuwim te sokel ago bagasan; nu balam se nuna tom suen biya butata baga gilingisan. ");
INSERT INTO wsk_vpl VALUES ("PS148_7","020_148_7","PSA","148","7","7","Ali imi te mel suen la Yawe nup patawumonko! Wal bibiya se mel suen la gagi du te anisan mu se, ");
INSERT INTO wsk_vpl VALUES ("PS148_8","020_148_8","PSA","148","8","8","pure nikim se tuwik samamer, se taiti nuwi se, daula bibiya noko kuring karo tusan mu buta noko nup patawumonko! ");
INSERT INTO wsk_vpl VALUES ("PS148_9","020_148_9","PSA","148","9","9","Se duruk motongar se duruk bibiya se, tam nunguning nasan mu se, giarum ningi ko tam, ");
INSERT INTO wsk_vpl VALUES ("PS148_10","020_148_10","PSA","148","10","10","se buruk kausik tarak inangnang mel, wonong ko se giarum ningi ko se, makina gawitiru, mu suen la noko nup patawumonko! ");
INSERT INTO wsk_vpl VALUES ("PS148_11","020_148_11","PSA","148","11","11","Se nina king se, ali lilim la ko kariimet, ");
INSERT INTO wsk_vpl VALUES ("PS148_12","020_148_12","PSA","148","12","12","se ali sor supuling se kari bibiya, se imet itiwik se kari kulak, se kariimet garuk se kuriang gotektek, ");
INSERT INTO wsk_vpl VALUES ("PS148_13","020_148_13","PSA","148","13","13","mu nina suen la Yawe ko nup patawuralko! Nu kota suanta nup biya. Noko nikim, ko sokel, ko nup biya, mu ali se taiti kia saparam. ");
INSERT INTO wsk_vpl VALUES ("PS148_14","020_148_14","PSA","148","14","14","Noko kariimet Israel mu noko gomang motam, se nu sokel nungaram se ko nup patawusan. Se Yawe ko nup patawunakko! Aleluya! ");
INSERT INTO wsk_vpl VALUES ("PS149_1","020_149_1","PSA","149","1","1","O aleluya! Yawe ko nup patawuralko! Wur iru iluwal ale nup patawuralko; nina ko kariimet biguwural ale ko nup patawuralko. ");
INSERT INTO wsk_vpl VALUES ("PS149_2","020_149_2","PSA","149","2","2","Israel kariimet, Yawe ko amilmilaralko, nu ninga nungam; Zion kariimet, ninga King ko amilmilaralko. ");
INSERT INTO wsk_vpl VALUES ("PS149_3","020_149_3","PSA","149","3","3","Bawe moa se, gita ela se, iru seseka se nup patawuralko! ");
INSERT INTO wsk_vpl VALUES ("PS149_4","020_149_4","PSA","149","4","4","Mu awuk, Yawe nina noko kariimet ninga ninguru amilmiloso; nu nina ninimi karogo kapaman se nu ninga sangaru tam. ");
INSERT INTO wsk_vpl VALUES ("PS149_5","020_149_5","PSA","149","5","5","Nu nenenga ninip biya mu bala iwita nisipiling tugumam se ninguru amilmilaralko; ale tirom anira tom te karogo la amilmil wur ilu se lagaralko! ");
INSERT INTO wsk_vpl VALUES ("PS149_6","020_149_6","PSA","149","6","6","Kaem nup biya tuata mu nina nigiring te aniruk se, batir kore wuli kapawara mu nigiting te iluwal, ");
INSERT INTO wsk_vpl VALUES ("PS149_7","020_149_7","PSA","149","7","7","ale te sor saki ko kariimet memek mu nunga memek koma nunga maguwuralko; ");
INSERT INTO wsk_vpl VALUES ("PS149_8","020_149_8","PSA","149","8","8","ale nunga king se nunga kari bibiya mayang aora te nunga taliparal, ");
INSERT INTO wsk_vpl VALUES ("PS149_9","020_149_9","PSA","149","9","9","ale Kaem ikup aguwaya nunga memek koma balam mu te nunga beteralko. Kaem ko gomang motam noko kariimet nunga mu uwutata. Aleluya! Yawe nup patawuralko! ");
INSERT INTO wsk_vpl VALUES ("PS150_1","020_150_1","PSA","150","1","1","O aleluya! Yawe ko nup patawuralko! Noko kuwim laili ningi ko nup patawuralko; noko sokel taiti gomang te mu ko nup patawuralko. ");
INSERT INTO wsk_vpl VALUES ("PS150_2","020_150_2","PSA","150","2","2","Ura bibiya sokel ago beteram mu ko nup patawuralko; noko nup biya kualala biya aniso mu ko nup patawuralko. ");
INSERT INTO wsk_vpl VALUES ("PS150_3","020_150_3","PSA","150","3","3","Kua sokelel itugu se nup patawuralko; gita kulele ela se nup patawuralko. ");
INSERT INTO wsk_vpl VALUES ("PS150_4","020_150_4","PSA","150","4","4","Tambourine sisuwu se, iru se, nup patawuralko; goyak bawe ela se, iru se, nup patawuralko. ");
INSERT INTO wsk_vpl VALUES ("PS150_5","020_150_5","PSA","150","5","5","Kapa bilik moral ale te nup patawuralko; moral se ko nirung biyala kaparuk se te nup patawuralko. ");
INSERT INTO wsk_vpl VALUES ("PS150_6","020_150_6","PSA","150","6","6","Melmasak suen la marak bagasan mu Yawe nup patawuralko! Aleluya! Yawe Biya nup patawuralko! ");
INSERT INTO wsk_vpl VALUES ("PR1_1","021_1_1","PRO","1","1","1","Batoga imi Israel nunga king Solomon, David ko namar, mu ko ikia sinar den ningi aniso. ");
INSERT INTO wsk_vpl VALUES ("PR1_2","021_1_2","PRO","1","2","2","Den imi ikia sinar se bagara diram te ningo la bagara ko munan mu ka kausokko; nika ikia sinar awurok se den ko nunguning du biya mu ko ikiko. ");
INSERT INTO wsk_vpl VALUES ("PR1_3","021_1_3","PRO","1","3","3","Ale ikia ago la baga se munan diram la se ningo guyak la te bagerko. ");
INSERT INTO wsk_vpl VALUES ("PR1_4","021_1_4","PRO","1","4","4","Ale ikia ninguru me sinarara alo wore nunga kiti gurugok se me ngual kasik bagamonko; ale kulak itiwik nunga kausok se ikia ago la te bagamonko. ");
INSERT INTO wsk_vpl VALUES ("PR1_5","021_1_5","PRO","1","5","5","Se ikia sinar ago mu agotala nunga sanguk, nunga kiti gurugok, ale nunga ikia kunasarukko. ");
INSERT INTO wsk_vpl VALUES ("PR1_6","021_1_6","PRO","1","6","6","Se nuna ikia sinar ko den se den pangan mu ko nunguning ko sinar amon ale ko ikimonko. ");
INSERT INTO wsk_vpl VALUES ("PR1_7","021_1_7","PRO","1","7","7","Yawe ko kua bowa ningi la bagara ko munan mu ikia sinar te ta ko lage kuring nunguning; bare nusupuling aora biya alo mu ikia sinar ko den se diram bagara ko den mu mel yam ko betesan. ");
INSERT INTO wsk_vpl VALUES ("PR1_8","021_1_8","PRO","1","8","8","Aga namar, ni ka niet ko kiti guruga ko den ikiko, ale ka niam ko kausa den me biring tuiko. ");
INSERT INTO wsk_vpl VALUES ("PR1_9","021_1_9","PRO","1","9","9","Nononga den umu kitigat balayam yawara sipiling te tugu kam, se aking kulolo balayam degetak te tugukoyam anirukko. ");
INSERT INTO wsk_vpl VALUES ("PR1_10","021_1_10","PRO","1","10","10","Se aga namar, kari memek alo gemang kulukurmon mu me arungu kapeterko. ");
INSERT INTO wsk_vpl VALUES ("PR1_11","021_1_11","PRO","1","11","11","Nuna balmon, “Nangarak tair se ana namanak yumuwa kari yam bo am monak se kueruk se ");
INSERT INTO wsk_vpl VALUES ("PR1_12","021_1_12","PRO","1","12","12","am ngual kasik nunga maguwunak silatanak se kua namamon ale nungumik guang lilim ago mutim ningi kapa nagumonko; ");
INSERT INTO wsk_vpl VALUES ("PR1_13","021_1_13","PRO","1","13","13","se nunga mel ningo ningo ginak ago tai nanga kawam tugunakko; ");
INSERT INTO wsk_vpl VALUES ("PR1_14","021_1_14","PRO","1","14","14","buta se nangarak tair se mel ginak mu pagaru nanimi tunakko,” mamon. ");
INSERT INTO wsk_vpl VALUES ("PR1_15","021_1_15","PRO","1","15","15","Bare aga namar, kari uwuta mu arungak me sorerko, nika bagara ago kelemak bagerko; ");
INSERT INTO wsk_vpl VALUES ("PR1_16","021_1_16","PRO","1","16","16","mu awuk, nuna kilek memek betemonko me nguangasan, am betesan; ale kari momon se kuerukko mu am guyak la betesan. ");
INSERT INTO wsk_vpl VALUES ("PR1_17","021_1_17","PRO","1","17","17","Ikiko! Inangnang bo karkiwuruk se ni nu te ilupko dagarok bitar, mu te ilup i? Mena! ");
INSERT INTO wsk_vpl VALUES ("PR1_18","021_1_18","PRO","1","18","18","Uwutatala, kari uwuta mu ikia mena; se nuna nongota nunga dagarok te soramonko wore bitawasan. ");
INSERT INTO wsk_vpl VALUES ("PR1_19","021_1_19","PRO","1","19","19","Buta se tere daong nana ko kari alo mu tere daong ko munan te kuemonko. ");
INSERT INTO wsk_vpl VALUES ("PR1_20","021_1_20","PRO","1","20","20","Ikia Sinar aiwoso; nu lage tuang suen la te se, kariimet ningi sor suen la te aiwoso; ");
INSERT INTO wsk_vpl VALUES ("PR1_21","021_1_21","PRO","1","21","21","nu diara guruga kuwim te se, bolala awura kuwim te aiso ale balso: ");
INSERT INTO wsk_vpl VALUES ("PR1_22","021_1_22","PRO","1","22","22","“Nina kariimet ikia aora biya, nina amaru ikia ngualara sowore bita talko? Ale amaru den alel bita lagasan sumu bita talko? Ale amaru ikia ningo me karo tusan mu karo tualko? ");
INSERT INTO wsk_vpl VALUES ("PR1_23","021_1_23","PRO","1","23","23","Nina aninga den sokel karogo ningarukasam mu iki karo tuman le mu, aninga ikia ningo se aninga den ningo mu ninga kausem le. ");
INSERT INTO wsk_vpl VALUES ("PR1_24","021_1_24","PRO","1","24","24","Ani agate tairalko ninga manarukasam, bare nina nibiring aisukasan ale agiring me karo tuikasan. ");
INSERT INTO wsk_vpl VALUES ("PR1_25","021_1_25","PRO","1","25","25","Nina aninga sangam den nibiring tuman, ale den sokel ago ninga manarukasam mu nede sisikaso. ");
INSERT INTO wsk_vpl VALUES ("PR1_26","021_1_26","PRO","1","26","26","Se ko moke, tom nina ikup arigal ale ngualaral sipiral, mu ani nego ko gusirekko. ");
INSERT INTO wsk_vpl VALUES ("PR1_27","021_1_27","PRO","1","27","27","Tom ikup yaman mu daula biya bo iwita ninga iluwok ale ninga sarumurok se ko memek biya ninga irok, mu ani ninga gusirekko. ");
INSERT INTO wsk_vpl VALUES ("PR1_28","021_1_28","PRO","1","28","28","“Nina saonga ko aningate airal, bare ani nigiring me iluwekko; nina ani ago ko loagaral, bare me agarkalko. ");
INSERT INTO wsk_vpl VALUES ("PR1_29","021_1_29","PRO","1","29","29","Mu awuk, nina ikia ningo me karo tuman, ale Yawe bowa ningi bagaralko me kueman. ");
INSERT INTO wsk_vpl VALUES ("PR1_30","021_1_30","PRO","1","30","30","Nina aninga sangam den nibiring tuman, ale den sokel ago ninga manarukasam mu nede sisikaso. ");
INSERT INTO wsk_vpl VALUES ("PR1_31","021_1_31","PRO","1","31","31","Buta se ninga betera kaora memek bita karo lagaman mu ko nunguning kaparuk se gi nalko. ");
INSERT INTO wsk_vpl VALUES ("PR1_32","021_1_32","PRO","1","32","32","Mu awuk, kariimet nunga ikia aora biya mu nunga ikia memek nunga moruk se kuemonko, nunga ikia kawel nunga kulok ale nunga maguwurokko. ");
INSERT INTO wsk_vpl VALUES ("PR1_33","021_1_33","PRO","1","33","33","Bare awiriya aninga den ikiok, mu nu ikup yaman bo me taukko, yawarakala bagarukko; ale nu mel bo ta me ko nguangarukko.” ");
INSERT INTO wsk_vpl VALUES ("PR2_1","021_2_1","PRO","2","1","1","Aga namar, aninga den ka kausem mu ninguru ilukuawur ale gemang motam ningi bitarko. ");
INSERT INTO wsk_vpl VALUES ("PR2_2","021_2_2","PRO","2","2","2","Ikia sinar ko den ko de gurugu se, ko ikia ningo ko ninguru iki gurugu se lagerko. ");
INSERT INTO wsk_vpl VALUES ("PR2_3","021_2_3","PRO","2","3","3","Nunguningta, ikia yumura kupu se ko nunguning ninguru ikiko nia se, ");
INSERT INTO wsk_vpl VALUES ("PR2_4","021_2_4","PRO","2","4","4","silver mel ali ningi ko loaga kam, agi manga mel kariimet kaluwu betera se ko loaga kam, loaga lagerko. ");
INSERT INTO wsk_vpl VALUES ("PR2_5","021_2_5","PRO","2","5","5","Mu asele ni Yawe ko iki ale, nu bowa ningi bagara ko munan mu ninguru ko ikiko. ");
INSERT INTO wsk_vpl VALUES ("PR2_6","021_2_6","PRO","2","6","6","Mu awuk, Yawe ikia sinar nangarso; nu kota ikia ningo se ko nunguning ko duap. ");
INSERT INTO wsk_vpl VALUES ("PR2_7","021_2_7","PRO","2","7","7","Nu ikia sinar ningo umu kariimet munan diram karosan mu nungarso; nu nunga karem baga se, ");
INSERT INTO wsk_vpl VALUES ("PR2_8","021_2_8","PRO","2","8","8","nunga bagara aolak bitarso ale nunga sangarso. ");
INSERT INTO wsk_vpl VALUES ("PR2_9","021_2_9","PRO","2","9","9","Aga namar, ni uwuta bitar mu asele ka ikia sinararuk se ikia ningo diram te la aolak ilu se lagerko. ");
INSERT INTO wsk_vpl VALUES ("PR2_10","021_2_10","PRO","2","10","10","Se ikia sinar mu gemang motam ningi kapa daigok, se ikia ningo mu kamin te yawarakala anirukko. ");
INSERT INTO wsk_vpl VALUES ("PR2_11","021_2_11","PRO","2","11","11","Sinar la bagara ko munan mu ka bituok se sinar karogo la aolak ilupko. ");
INSERT INTO wsk_vpl VALUES ("PR2_12","021_2_12","PRO","2","12","12","Ikia sinar mu ka sanguk se kariimet memek se munak diram me bala alo mu nomolak me karoko. ");
INSERT INTO wsk_vpl VALUES ("PR2_13","021_2_13","PRO","2","13","13","Nuna lage diram mu beteman ale tiromorom ningi aolak ilu se, ");
INSERT INTO wsk_vpl VALUES ("PR2_14","021_2_14","PRO","2","14","14","munan memek betemonko kua gilingisan, ale munan memek mu ko amilmilasan. ");
INSERT INTO wsk_vpl VALUES ("PR2_15","021_2_15","PRO","2","15","15","Nuna diram me aolak ilusan, ale nunga munan mu kawel karogo la. ");
INSERT INTO wsk_vpl VALUES ("PR2_16","021_2_16","PRO","2","16","16","Ikia sinar mu ka kiti gurugok se imet kari ilak diram me bagara mu ko kawel te se ko den welang te me dagulko. ");
INSERT INTO wsk_vpl VALUES ("PR2_17","021_2_17","PRO","2","17","17","Nu kulak la Kaem koma te ko kari ilak numi kuting iluwam mu mel yam ko beteram, ale ko kari beteram. ");
INSERT INTO wsk_vpl VALUES ("PR2_18","021_2_18","PRO","2","18","18","Nunguningta, imet umu ilak ko kawam te yumu namara mu, kuera mutim ningi aolak ilu nama kam. ");
INSERT INTO wsk_vpl VALUES ("PR2_19","021_2_19","PRO","2","19","19","Kari awiriya imet mu ilak yumu namasan mu, udagi bagara ningo ko lage te me pila tai gilingisan. ");
INSERT INTO wsk_vpl VALUES ("PR2_20","021_2_20","PRO","2","20","20","Buta se ni kari ningo diram alo mu nunga nomolak karo ale lage diram la mu te bagerko. ");
INSERT INTO wsk_vpl VALUES ("PR2_21","021_2_21","PRO","2","21","21","Mu awuk, kari munan ningo diram karo tusan, mu ali imi te bagamonko. ");
INSERT INTO wsk_vpl VALUES ("PR2_22","021_2_22","PRO","2","22","22","Bare kari munan memek betesan mu ningam ningi sum memek bila warsan iwitatala, Kaem nunga bila warukko. ");
INSERT INTO wsk_vpl VALUES ("PR3_1","021_3_1","PRO","3","1","1","Aga namar, ani munan den ka kausem mu pempem kamin te anirukko. ");
INSERT INTO wsk_vpl VALUES ("PR3_2","021_3_2","PRO","3","2","2","Se ni karo tui mu ni ali imi te kam maiya biya yawarakala lila karogo bagerko. ");
INSERT INTO wsk_vpl VALUES ("PR3_3","021_3_3","PRO","3","3","3","Saki alo kua nungaru se, ningo la nongorak diram la bagara ko munan mu ilukuawurko; kulolo yawara iwita degetak tugum ale gemang motam ningi bitarko. ");
INSERT INTO wsk_vpl VALUES ("PR3_4","021_3_4","PRO","3","4","4","Ni uwuta bitar mu Kaem gomang motam kisok, se ali imi te betela kariimet agotala nika kuemon se ni nip yawara toko. ");
INSERT INTO wsk_vpl VALUES ("PR3_5","021_3_5","PRO","3","5","5","Gemang motam lilim la Yawe te ira sanamirko, keta ka ikia te me ira sanamirko; ");
INSERT INTO wsk_vpl VALUES ("PR3_6","021_3_6","PRO","3","6","6","munan suen la te mu nu giruwur se nu ka lage suen la dingumurokko. ");
INSERT INTO wsk_vpl VALUES ("PR3_7","021_3_7","PRO","3","7","7","Keta nimi ikia sinar ago ma me baluko; munan memek biring tui ale Yawe kuring bowa ningi la bagerko. ");
INSERT INTO wsk_vpl VALUES ("PR3_8","021_3_8","PRO","3","8","8","Se munan umu ka kimik lilim ko ikes menawurok ale kimik sokel tuokko. ");
INSERT INTO wsk_vpl VALUES ("PR3_9","021_3_9","PRO","3","9","9","Yawe manga mel ningo ningo kisam mu te nup biya tui se, ka inang ningo sang gi ale ago tuiko. ");
INSERT INTO wsk_vpl VALUES ("PR3_10","021_3_10","PRO","3","10","10","Munan umu te ka na inang te bolala awura ko kuwim mu na inang karogo terong mauk, se ka waen mu biya tala kuring aratuk ale kaparukko. ");
INSERT INTO wsk_vpl VALUES ("PR3_11","021_3_11","PRO","3","11","11","Aga namar, Yawe ni te giris meko kiwem bo bu iwita kisok, agi den aora bo ka manuk, mu me ko gemang dagulok se biring tuiko, am iki karo tuiko, ");
INSERT INTO wsk_vpl VALUES ("PR3_12","021_3_12","PRO","3","12","12","mu awuk, Yawe ko kariimet nunga kueso mu bu nungarso, kari namar ko kua nanuguso ale nukum tagiso iwita. ");
INSERT INTO wsk_vpl VALUES ("PR3_13","021_3_13","PRO","3","13","13","Kari awiriya ikia sinar kupuso ale arigiso, ale ko nunguning ko ari ikiso, mu amilmilarukko. ");
INSERT INTO wsk_vpl VALUES ("PR3_14","021_3_14","PRO","3","14","14","Mu awuk, ikia sinar mu silver se gold kiaram, se ko manga motam mu kalel biya. ");
INSERT INTO wsk_vpl VALUES ("PR3_15","021_3_15","PRO","3","15","15","Ikia sinar mu manga diamond nunga diara koma mu am kia saparam; se anapeya mel ni ninguru ko kua lagasam mu ikia sinar mu nunga kia saparam tala. ");
INSERT INTO wsk_vpl VALUES ("PR3_16","021_3_16","PRO","3","16","16","Marak tom maiya biya bagara mu noko kuting sengam te aniso, se nup biya se mel ningo ningo ago bagara ko munan mu noko kuting ngas mu te aniso. ");
INSERT INTO wsk_vpl VALUES ("PR3_17","021_3_17","PRO","3","17","17","Ikia sinar ko munan mu am ningo la suen biya, se ko bagara aolak lila ago se yawarakala. ");
INSERT INTO wsk_vpl VALUES ("PR3_18","021_3_18","PRO","3","18","18","Ikia sinar mu tam bo marak nangarso wore turan; awiriya ilukuawuso mu marak amilmil ago la bagarukko. ");
INSERT INTO wsk_vpl VALUES ("PR3_19","021_3_19","PRO","3","19","19","Ikia sinar umu te Yawe ali imi nungam, ale ikia sinar ko nunguning mu te taiti gomang lilim beteram. ");
INSERT INTO wsk_vpl VALUES ("PR3_20","021_3_20","PRO","3","20","20","Ale noko ikia biya mu te yu ali ningi basu arataso, se yu taiti nuwi ningi mu tuwik ko kaposo. ");
INSERT INTO wsk_vpl VALUES ("PR3_21","021_3_21","PRO","3","21","21","Aga namar, ikia sinar ko munan suen la mu ninguru ilukuawur ale kamili me ta saparukko. ");
INSERT INTO wsk_vpl VALUES ("PR3_22","021_3_22","PRO","3","22","22","Munan umu ni daiga bagara ningo kisok, ale kulolo yawara bo degetak te iwita anirukko. ");
INSERT INTO wsk_vpl VALUES ("PR3_23","021_3_23","PRO","3","23","23","Se ni apalagaya namar mu ningo la lagerko; ");
INSERT INTO wsk_vpl VALUES ("PR3_24","021_3_24","PRO","3","24","24","ale ka anira kuwim te taga anir, mu mel bo ko me nguangerko, yawarakala anirko. ");
INSERT INTO wsk_vpl VALUES ("PR3_25","021_3_25","PRO","3","25","25","Ikup tairatela arataso mu ko me nguangerko, ale kariimet memek alo ikup arigisan mu ni me ko nguangerko. ");
INSERT INTO wsk_vpl VALUES ("PR3_26","021_3_26","PRO","3","26","26","Mu awuk, Yawe ni kerak pingi baga se ka bituok se me dagulko. ");
INSERT INTO wsk_vpl VALUES ("PR3_27","021_3_27","PRO","3","27","27","Awiriya mel ko tukunangaruk se ni karogo bager, mu ni nu am sangaruko. ");
INSERT INTO wsk_vpl VALUES ("PR3_28","021_3_28","PRO","3","28","28","Ni mel ago agi mu, nu manaru ale “Ukirok se asele kisekko,” ma me manaruko. ");
INSERT INTO wsk_vpl VALUES ("PR3_29","021_3_29","PRO","3","29","29","Nika singsang kerak bagasan mu ni yumura la lage memek te me nunga bitarko, mu awuk, nuna ni me ka iki paguwusan. ");
INSERT INTO wsk_vpl VALUES ("PR3_30","021_3_30","PRO","3","30","30","Kari bo am ipi den te me atumko; nu memek bo ni kimik te me beteram. ");
INSERT INTO wsk_vpl VALUES ("PR3_31","021_3_31","PRO","3","31","31","Ni kari daong alis te melmasak gisan mu arik ale nomolak umu me karoko, ");
INSERT INTO wsk_vpl VALUES ("PR3_32","021_3_32","PRO","3","32","32","mu awuk, Yawe kariimet memek nunga bagara aolak memek mu nunga biriruwuso nunguningkiri; bare nu kariimet nunga bagara aolak diram mu noko tiran yawara ko nunga beteso. ");
INSERT INTO wsk_vpl VALUES ("PR3_33","021_3_33","PRO","3","33","33","Yawe ko gomang memek mu kariimet munan memek betesan mu nunga kawam digo lilim awote kaposo; bare noko marak ningo mu kariimet munan diram betesan mu nunga kawam digo lilim ningi kaposo. ");
INSERT INTO wsk_vpl VALUES ("PR3_34","021_3_34","PRO","3","34","34","Nu suwik sapara ko den bala ko kariimet alo mu nu aguwaya nungumik te bitirukko mu nukote ikup bo iwita mena; bare kua kapara ko kariimet alo mu nu gomang nungarso ale nunga sangarso. ");
INSERT INTO wsk_vpl VALUES ("PR3_35","021_3_35","PRO","3","35","35","Awiriya ikia sinar ago mu nup biya taukko; bare nusupuling aora biya alo mu dolomonko. ");
INSERT INTO wsk_vpl VALUES ("PR4_1","021_4_1","PRO","4","1","1","Aga namarari alo, kiti guruga den ani nenenga nenet balsam imi ikial ale ko nunguning talko. ");
INSERT INTO wsk_vpl VALUES ("PR4_2","021_4_2","PRO","4","2","2","Den ani ninga manorsam mu nunguningta, se ningamili me saparukko. ");
INSERT INTO wsk_vpl VALUES ("PR4_3","021_4_3","PRO","4","3","3","Ani gotektir la aga ayam ninguru aga kuakaso; ani aga ait ayam nongorak bagakasam, ");
INSERT INTO wsk_vpl VALUES ("PR4_4","021_4_4","PRO","4","4","4","se aga ait iwita aga manarukaso: “Den ka manorsam imi gemang motam lilim ningi bitar ale ilukuawur, ale karo tui mu ni terong la bagerko. ");
INSERT INTO wsk_vpl VALUES ("PR4_5","021_4_5","PRO","4","5","5","Ikia sinar ilukuawur ale sinar la lagerko; aninga den kamili me saparuk se lage kigilik me karoko. ");
INSERT INTO wsk_vpl VALUES ("PR4_6","021_4_6","PRO","4","6","6","Ni ikia sinar me biring tuiko; kua tui se nu ka bituok ale ka sinar taukko. ");
INSERT INTO wsk_vpl VALUES ("PR4_7","021_4_7","PRO","4","7","7","Mu awuk, ikia sinar mu mel biya nunguningkiri; ka melmasak suen la ira kutuwur ale kupu ale to ale ko sinarerko. ");
INSERT INTO wsk_vpl VALUES ("PR4_8","021_4_8","PRO","4","8","8","Ikia sinar ko kuar se nup biya kisokko, to ale ilukuawur se nip ningo kisokko. ");
INSERT INTO wsk_vpl VALUES ("PR4_9","021_4_9","PRO","4","9","9","Nu mel yawara, kitigat balayam iwita, sipiling te bitirukko.” ");
INSERT INTO wsk_vpl VALUES ("PR4_10","021_4_10","PRO","4","10","10","Aga namar, aninga den iki ale karo tui ale te tom maiya biya ali imi te bagerko. ");
INSERT INTO wsk_vpl VALUES ("PR4_11","021_4_11","PRO","4","11","11","Ani ikia sinar ko munan ka kasursam, ale lage ningo te ka betesam; ");
INSERT INTO wsk_vpl VALUES ("PR4_12","021_4_12","PRO","4","12","12","se te aolak ilup mu mel bo siwik me siruwurok, se nagur mu mel bo me ka taliparukko. ");
INSERT INTO wsk_vpl VALUES ("PR4_13","021_4_13","PRO","4","13","13","Ni kiti guruga ko den imi ilukuawur ale ko sinar to, se daiga bagara ningo kisokko. ");
INSERT INTO wsk_vpl VALUES ("PR4_14","021_4_14","PRO","4","14","14","Ni kari memek nunga nomolak me karo tui, ale munan betesan mu ni me bitarko. ");
INSERT INTO wsk_vpl VALUES ("PR4_15","021_4_15","PRO","4","15","15","Ni lage umu kia kapar ale me te aolak ilupko; bita to ale lage bo kigilik te namarko. ");
INSERT INTO wsk_vpl VALUES ("PR4_16","021_4_16","PRO","4","16","16","Kari memek alo mu memek bo me betemon mu, me ta taga animon ale nonoman sapamonko; kari bo memek te betemon mu asele, taga animon ale animonko. ");
INSERT INTO wsk_vpl VALUES ("PR4_17","021_4_17","PRO","4","17","17","Nuna munan memek mu inang nokoyam nasan, ale kager daong mu yu nokoyam nasan. ");
INSERT INTO wsk_vpl VALUES ("PR4_18","021_4_18","PRO","4","18","18","Munan ningo diram kaora ko kariimet alo nunga bagara aolak mu, worem turomola basuso ale nikim kaposo, nama kowarkalal eng am nikim biyala kaposo iwitata. ");
INSERT INTO wsk_vpl VALUES ("PR4_19","021_4_19","PRO","4","19","19","Bare munan memek kaora ko kariimet alo nunga bagara aolak mu, sor tiromorom biya ningi baga kam; se mel bo nunga taliparuk mu awuk ko ari ikimonko? Mena. ");
INSERT INTO wsk_vpl VALUES ("PR4_20","021_4_20","PRO","4","20","20","Aga namar, degewa tagir ale den balsam mu ninguru ikiko. ");
INSERT INTO wsk_vpl VALUES ("PR4_21","021_4_21","PRO","4","21","21","Ale gemang motam ningi bitar ale ninguru ilukuawurko. ");
INSERT INTO wsk_vpl VALUES ("PR4_22","021_4_22","PRO","4","22","22","Mu awuk, ni umu te bagara aolak ningo arik, se nika kimik lilim ko kuera ikes mu menawurokko. ");
INSERT INTO wsk_vpl VALUES ("PR4_23","021_4_23","PRO","4","23","23","Mel gira nunguningkiri mu ni ka gemang motam ko sinar toko; mu awuk, borta nika bagara aolak suen la kiti guruguwoso. ");
INSERT INTO wsk_vpl VALUES ("PR4_24","021_4_24","PRO","4","24","24","Ni den kawel me ta baluko; ale den memek kiring te me aratukko. ");
INSERT INTO wsk_vpl VALUES ("PR4_25","021_4_25","PRO","4","25","25","Lage te namasam mu la arikuawu se ngual ngual me loagerko. ");
INSERT INTO wsk_vpl VALUES ("PR4_26","021_4_26","PRO","4","26","26","Tuang te aolak ilupko mu ko ninguru iki gurugu ale ningo mu la karo ale, ");
INSERT INTO wsk_vpl VALUES ("PR4_27","021_4_27","PRO","4","27","27","bola pala me nama tairko; kilek memek suen la biring tuiko. ");
INSERT INTO wsk_vpl VALUES ("PR5_1","021_5_1","PRO","5","1","1","Aga namar, ikia sinar ko den balsam ewere ikiko, degewa gurugu ale ko sinarerko, ");
INSERT INTO wsk_vpl VALUES ("PR5_2","021_5_2","PRO","5","2","2","mu te ni sinar ago la baga se, kiring te ikia ningo ko den pempem aratukko. ");
INSERT INTO wsk_vpl VALUES ("PR5_3","021_5_3","PRO","5","3","3","Mu awuk, lage luan imet ko munak mu yaman nuam se welang karogo, ");
INSERT INTO wsk_vpl VALUES ("PR5_4","021_5_4","PRO","5","4","4","bare noko munak karo tuata mu, nukum te mel bo kiti seselak ago nana iwita, agi batir kore wuli koma sing sang ago ka moa kam. ");
INSERT INTO wsk_vpl VALUES ("PR5_5","021_5_5","PRO","5","5","5","Munan nu karowoso mu mutim ningi kua namara ko munan. ");
INSERT INTO wsk_vpl VALUES ("PR5_6","021_5_6","PRO","5","6","6","Nu bagara aolak ningo ko ikia me taso; noko aolak daeldel mu nu kota me ko ikiso. ");
INSERT INTO wsk_vpl VALUES ("PR5_7","021_5_7","PRO","5","7","7","Aga namar, ikiko; ani den ka manorsam mu betegen ko me bitarko. ");
INSERT INTO wsk_vpl VALUES ("PR5_8","021_5_8","PRO","5","8","8","Imet uwuta ko kawam kuringi me namar, agi kumik duap te me dagiko. ");
INSERT INTO wsk_vpl VALUES ("PR5_9","021_5_9","PRO","5","9","9","Ni uwuta bitar mu ka mel ningo ningo waru saparko; ale nongomang magara ko kariimet nuguting te tom maiya biya maga kuena lagerko. ");
INSERT INTO wsk_vpl VALUES ("PR5_10","021_5_10","PRO","5","10","10","Se ka mel ningo ningo mu kariimet iwareng no maguwumonko; se ka ura kowar mu kari bo kigilik ko kawam tugumokko. ");
INSERT INTO wsk_vpl VALUES ("PR5_11","021_5_11","PRO","5","11","11","Se kuera memek ka iluwok se kimik sokelel wetang te aratuk se kuera ko tom ka irok se nia kika lagerko. ");
INSERT INTO wsk_vpl VALUES ("PR5_12","021_5_12","PRO","5","12","12","Ale keta nimi manaru ale balu, “Ani agata den ningo te ningo la bagarikko aga kasurukasan wore me karo tuem; ");
INSERT INTO wsk_vpl VALUES ("PR5_13","021_5_13","PRO","5","13","13","aga kausa se kiti guruga kari alo nuguring me karo nungarem. ");
INSERT INTO wsk_vpl VALUES ("PR5_14","021_5_14","PRO","5","14","14","Buta se aitak ani kariimet biya nomotam te dola magawasam,” meko. ");
INSERT INTO wsk_vpl VALUES ("PR5_15","021_5_15","PRO","5","15","15","Ni ka yu kuting ni keta te yu nasam uwutatala, ni ka niwus kota diram ilak bagerko. ");
INSERT INTO wsk_vpl VALUES ("PR5_16","021_5_16","PRO","5","16","16","Ka yu kuting mu anape ko gi ale karogo nama ngual ngual waru karogo gerageko? ");
INSERT INTO wsk_vpl VALUES ("PR5_17","021_5_17","PRO","5","17","17","Yu kuting mu nika, se nika diram, bo iwareng ilak me nimi tui noko. ");
INSERT INTO wsk_vpl VALUES ("PR5_18","021_5_18","PRO","5","18","18","Ni ka imet ilak kulak te la ninimi giman mu ko amilmiler, se nu neman taukko. ");
INSERT INTO wsk_vpl VALUES ("PR5_19","021_5_19","PRO","5","19","19","Nika niwus mu nika yawara, se mel balayam ningo bo iwita; nu nika kueso, se ni nu ko kuar se nu neman taukko. ");
INSERT INTO wsk_vpl VALUES ("PR5_20","021_5_20","PRO","5","20","20","Se aga namar, ni anape ko kari bo ko imet kowom karo se lagerko? Ale anape ko lage luan imet nika imet iwita ilukuawu lagerko? ");
INSERT INTO wsk_vpl VALUES ("PR5_21","021_5_21","PRO","5","21","21","Ikiko! Kari ko munan suen la mu Yawe ari saposo; ale ko namara taira suen la mu ko iki saposo. ");
INSERT INTO wsk_vpl VALUES ("PR5_22","021_5_22","PRO","5","22","22","Kari ikia memek bita lagoso, mu kota ko ikia memek mu dagarok iwita nu kutiso ale taliposo. ");
INSERT INTO wsk_vpl VALUES ("PR5_23","021_5_23","PRO","5","23","23","Kari uwuta kota ko bagara aolak me bitarso, ale ko munan umu te nguala sipa laga mutim ningi kua namoso. ");
INSERT INTO wsk_vpl VALUES ("PR6_1","021_6_1","PRO","6","1","1","Aga namar, kari bo ni ninguru me ko ikia, bare bo kote dinau beteram, se ni balem kari mu sangaru ale ko dinau koma kutuwurko balem, ");
INSERT INTO wsk_vpl VALUES ("PR6_2","021_6_2","PRO","6","2","2","mu ni keta nimi nu kuting te talipara ningi beterem. ");
INSERT INTO wsk_vpl VALUES ("PR6_3","021_6_3","PRO","6","3","3","Aga namar, ni paguwurem ale uwuta beterem agi mu, ani balsam imi karo tui ale iwita bitarko: am tairatela kari ni sangaruko balem umu kote namar ale, kua kapa se, isaru se, den ni ilak kalem mu kutuwurok ale menawurokko. ");
INSERT INTO wsk_vpl VALUES ("PR6_4","021_6_4","PRO","6","4","4","Ni anir ale ukirok se bares kote namarko me kimi bitarko, mena. ");
INSERT INTO wsk_vpl VALUES ("PR6_5","021_6_5","PRO","6","5","5","Buruk diwang dagarok gulia saposo ale naguso iwita, kote pasak ala namar ale nimi gulia toko. ");
INSERT INTO wsk_vpl VALUES ("PR6_6","021_6_6","PRO","6","6","6","Ni gagor kari, madidir kiwem betesan owore arik ale ka ikia sinar arukko! ");
INSERT INTO wsk_vpl VALUES ("PR6_7","021_6_7","PRO","6","7","7","Nuna kariimet bo guguna me nungarso, ");
INSERT INTO wsk_vpl VALUES ("PR6_8","021_6_8","PRO","6","8","8","bare nuna amaruya inang mena ko tom mu nuna ikisan, ale inang bolala awu gilingisan. ");
INSERT INTO wsk_vpl VALUES ("PR6_9","021_6_9","PRO","6","9","9","Ni tuawun kari, ni amaru te anira geraga sowore bitarko? Kua anira sowore amaru bitar ale baresko? ");
INSERT INTO wsk_vpl VALUES ("PR6_10","021_6_10","PRO","6","10","10","Ni motam kilikilok ma katir la, aking anira katir la, kiting patutumura ale nimi ira barutuwura katir la ko munan umu te, ");
INSERT INTO wsk_vpl VALUES ("PR6_11","021_6_11","PRO","6","11","11","ni kari kimik mel mena lagerko, tere kari ka melmasak gi karogo nama sapara iwita lagerko. ");
INSERT INTO wsk_vpl VALUES ("PR6_12","021_6_12","PRO","6","12","12","Kari memek mu den kawel munaka munaka geragoso. ");
INSERT INTO wsk_vpl VALUES ("PR6_13","021_6_13","PRO","6","13","13","Nu den kawel nika manaru se mu, nu ko bo motam kui te agi kuting te ira ituwokko. ");
INSERT INTO wsk_vpl VALUES ("PR6_14","021_6_14","PRO","6","14","14","Noko gomang motam ningi mu ikia memek bitirukko iki guruguwoso; nu apareyate namoso mu ikup arataso. ");
INSERT INTO wsk_vpl VALUES ("PR6_15","021_6_15","PRO","6","15","15","Buta se nu tairate ikup memek arigokko, se lage bo aking te ningo arigokko mu mena. ");
INSERT INTO wsk_vpl VALUES ("PR6_16","021_6_16","PRO","6","16","16","Munan 6 agi 7 imi se saki saki karogo, imitang Yawe me ko kueso nunguningkiri: ");
INSERT INTO wsk_vpl VALUES ("PR6_17","021_6_17","PRO","6","17","17","nanimi patawura ko munan, den kawel bala ko munan, kari mora se kuera ko munan, ");
INSERT INTO wsk_vpl VALUES ("PR6_18","021_6_18","PRO","6","18","18","ikia memek iki gurugu lagara ko munan, guyak la memek betera ko nagu namara ko munan, ");
INSERT INTO wsk_vpl VALUES ("PR6_19","021_6_19","PRO","6","19","19","den kawel te bo atumu saonga ko munan, launuria bagara suanta nunga kula se nunumi nongomang maguwura ko munan; munan imitang se saki saki karogo imitang Yawe me ko kueso nunguningkiri. ");
INSERT INTO wsk_vpl VALUES ("PR6_20","021_6_20","PRO","6","20","20","Aga namar, ni ka niet ko den ilukuawur ale niam ko kausa den agotala karo tuiko. ");
INSERT INTO wsk_vpl VALUES ("PR6_21","021_6_21","PRO","6","21","21","Nononga den umu gemang motam ningi bitar ale bala yawara iwita degetak tugum se pempem anirukko. ");
INSERT INTO wsk_vpl VALUES ("PR6_22","021_6_22","PRO","6","22","22","Nika bagara aolak te ka kiti gurugokko, ka anira te ka sinar taukko, se aniwa bares mu kerak munakarukko. ");
INSERT INTO wsk_vpl VALUES ("PR6_23","021_6_23","PRO","6","23","23","Mu awuk, nononga den mu nika galep iwita, se nunga kausa mu nikinang kisok ale ka bagara aolak te ka memek ka kausok ale ningo ko lage te ka bitirukko. ");
INSERT INTO wsk_vpl VALUES ("PR6_24","021_6_24","PRO","6","24","24","Nononga den mu ka sanguk se bo ko imet ko kawel te me dagulko, ale lage luan imet ko den welang me ikiko. ");
INSERT INTO wsk_vpl VALUES ("PR6_25","021_6_25","PRO","6","25","25","Ni noko kumik koma motam balayam mu ko me motam barasukko; ale ko motam ko me dagulko. ");
INSERT INTO wsk_vpl VALUES ("PR6_26","021_6_26","PRO","6","26","26","Mu awuk, ni lage luan imet ilak anir, mu ni ka ariga mu mel yam bo iwita; se bo ko imet ilak anira mu kua namara ko lage te ka beteso. ");
INSERT INTO wsk_vpl VALUES ("PR6_27","021_6_27","PRO","6","27","28","Ni tam giturum ko kaok kaniwara mu am yasir i? Agi ni tama kurugu kaok kaniwara mu awote aolak ilup i? Mena. Mu ni kokosa se siwik turupurok ale yoparukko. ");
INSERT INTO wsk_vpl VALUES ("PR6_29","021_6_29","PRO","6","29","29","Uwutatala, ni kari bo ko nuwus yasir, mu ni me namarko, ni kurakor kuring nagurem. ");
INSERT INTO wsk_vpl VALUES ("PR6_30","021_6_30","PRO","6","30","30","Kari bo na ko kueruk ale inang tere nauk, mu ko ikup mu katir buta nuam. ");
INSERT INTO wsk_vpl VALUES ("PR6_31","021_6_31","PRO","6","31","31","Nuna ilumon mu, nu tom 7 ko mel koma am diarukko, agi ko kawam te ko melmasak am gimonko, mu terong, mel bo mena. ");
INSERT INTO wsk_vpl VALUES ("PR6_32","021_6_32","PRO","6","32","32","Bare awiriya imet kuari ago mu ilak tere naso, mu nu kumik ikia sinar mena nunguningkiri; nu kota numi maguwuso. ");
INSERT INTO wsk_vpl VALUES ("PR6_33","021_6_33","PRO","6","33","33","Nuna moa maguwumon ale dolara tumon, se pempem dola se lagarukko. ");
INSERT INTO wsk_vpl VALUES ("PR6_34","021_6_34","PRO","6","34","34","Imet uwuta mu ko kuari mu gomang maga kaparuk se koma bitirukko mu ikia gira awom me ta taukko. ");
INSERT INTO wsk_vpl VALUES ("PR6_35","021_6_35","PRO","6","35","35","Se ikup mu ko diara manga aromemek te ta diamonko balmon, bare nu me ta taukko. ");
INSERT INTO wsk_vpl VALUES ("PR7_1","021_7_1","PRO","7","1","1","Aga namar, aninga den imi ilukuawur ale nika mel ningo bo iwita ko iki se lagerko. ");
INSERT INTO wsk_vpl VALUES ("PR7_2","021_7_2","PRO","7","2","2","Aninga munan den karo tui mu ni te terong la lagerko; nika motam mu mel aromemek se ni ninguru ko sinar tasam iwitatala, aninga den ko ninguru sinar toko. ");
INSERT INTO wsk_vpl VALUES ("PR7_3","021_7_3","PRO","7","3","3","Den mu gemang motam ningi bitar, ale kiting sengam te ilupko. ");
INSERT INTO wsk_vpl VALUES ("PR7_4","021_7_4","PRO","7","4","4","Ikia sinar se ko nunguning mu nika koras agi ka yawara bo iwita ninguru ko kuarko. ");
INSERT INTO wsk_vpl VALUES ("PR7_5","021_7_5","PRO","7","5","5","Nuna nika bitarmon se lage luan imet agi, kari bo ko imet nunga den welang te me dagulko. ");
INSERT INTO wsk_vpl VALUES ("PR7_6","021_7_6","PRO","7","6","6","Ani kawam ko kuring gotek te marir tasan mu te loagawa, ");
INSERT INTO wsk_vpl VALUES ("PR7_7","021_7_7","PRO","7","7","7","kari kulak sang nungarkem, ale nunga ningi bo borara biya, ningo memek kaura tutera mena, mu arigem. ");
INSERT INTO wsk_vpl VALUES ("PR7_8","021_7_8","PRO","7","8","8","Nu aolak iluwam ale lage tuang imet bo ko kawam duap te namara umu kaoram. ");
INSERT INTO wsk_vpl VALUES ("PR7_9","021_7_9","PRO","7","9","9","Mu bainga ningi, sor tirom batagam taiwaram se. ");
INSERT INTO wsk_vpl VALUES ("PR7_10","021_7_10","PRO","7","10","10","Se imet umu lage luan imet ko munan te numi nungam, ale den aguwaya te gomang kulukokko mu iki se kote aratam. ");
INSERT INTO wsk_vpl VALUES ("PR7_11","021_7_11","PRO","7","11","11","Imet umu numi ira mena, palalak imet, kawam te me dagi kulukuso, ");
INSERT INTO wsk_vpl VALUES ("PR7_12","021_7_12","PRO","7","12","12","aitak la tuang suen la te, aitak la diara guruga kuwim te, aitak la sor suen la te kari ko loaga gurugu geragawara. ");
INSERT INTO wsk_vpl VALUES ("PR7_13","021_7_13","PRO","7","13","13","Nu kari kulak mu iluwam yasaram ale kol misikiram, ale diram la maonam ale mam: ");
INSERT INTO wsk_vpl VALUES ("PR7_14","021_7_14","PRO","7","14","14","“Ani aitakta diram mel ningo bo te tama bita tuem, ale ko nukum giem karogo tai kawam te awurem se aniso. ");
INSERT INTO wsk_vpl VALUES ("PR7_15","021_7_15","PRO","7","15","15","Se tairem nika loaga gurugu laga asele aitak karkem! ");
INSERT INTO wsk_vpl VALUES ("PR7_16","021_7_16","PRO","7","16","16","Aninga anira kuwim mu guang bala yawara karogo, Egypt tairam, wore te muru nunguru beterem, ");
INSERT INTO wsk_vpl VALUES ("PR7_17","021_7_17","PRO","7","17","17","ale mel siring yawara yawara, myrrh, aloes, se cinnamon, mu awote warem se aniso. ");
INSERT INTO wsk_vpl VALUES ("PR7_18","021_7_18","PRO","7","18","18","Tair se namanak ale tirom awote ani se kola gusi se laganak la ukirokko. ");
INSERT INTO wsk_vpl VALUES ("PR7_19","021_7_19","PRO","7","19","19","Aninga agari kawam te me bagoso; nu awar biya nunguningkiri namaram. ");
INSERT INTO wsk_vpl VALUES ("PR7_20","021_7_20","PRO","7","20","20","Nu manga biya giam ale ago namaram, ewere te se nu tairate me tairukko, sige imi nukum te asele tairukko.” ");
INSERT INTO wsk_vpl VALUES ("PR7_21","021_7_21","PRO","7","21","21","Nu ko gomang kuluka den mu, se ko den welang yawara umu te kari gomang kuluku lage memek te beteram. ");
INSERT INTO wsk_vpl VALUES ("PR7_22","021_7_22","PRO","7","22","22","Se kari kulak mu tairatela kowom karo ilak namaram; nu bulmakau mora se kuerukko tagi ilak nama kam namaram; ale buruk dagarok ko me ikia, am ngual kasik nagu nama te sorara ");
INSERT INTO wsk_vpl VALUES ("PR7_23","021_7_23","PRO","7","23","23","se gatu te gangarukam iwita namaram; ale aking inangnang binga nama kalilok te sora kam namaram. Kari kulak imi nu kua namarukko lage te namakaso, bare nu kota me ari ko ikikaso. ");
INSERT INTO wsk_vpl VALUES ("PR7_24","021_7_24","PRO","7","24","24","Se aga namar, aninga den imi ninguru iki ale karo tuiko! ");
INSERT INTO wsk_vpl VALUES ("PR7_25","021_7_25","PRO","7","25","25","Imet uwuta mu ko kiwem me gemang tui ale karo tuiko. ");
INSERT INTO wsk_vpl VALUES ("PR7_26","021_7_26","PRO","7","26","26","Mu awuk, imet umu kari suen biya nunga maguwuram se kapa maga sapaman. ");
INSERT INTO wsk_vpl VALUES ("PR7_27","021_7_27","PRO","7","27","27","Noko kawam mu kuera mutim ko korang iwita, ningi kasu nagu nama kua namarko. ");
INSERT INTO wsk_vpl VALUES ("PR8_1","021_8_1","PRO","8","1","1","Ikialko! Ikia Sinar aiwoso; nina ninguru ko ikialko aiwoso. ");
INSERT INTO wsk_vpl VALUES ("PR8_2","021_8_2","PRO","8","2","2","Nu lage luan te, kualala ko baga se aiwoso, lage sorang numi iluwa te aiwoso, ");
INSERT INTO wsk_vpl VALUES ("PR8_3","021_8_3","PRO","8","3","3","wonong ko lage motam beta ko baga se sail karogo balso: ");
INSERT INTO wsk_vpl VALUES ("PR8_4","021_8_4","PRO","8","4","4","“O kariimet, nina suen la aninga aira nengete betesam; ali lilim la ko kariimet, ani ninga arusam. ");
INSERT INTO wsk_vpl VALUES ("PR8_5","021_8_5","PRO","8","5","5","Nina kariimet me sinarara mu sinararalko; nina kariimet ikia aora biya mu, ninga ikia sinararukko. ");
INSERT INTO wsk_vpl VALUES ("PR8_6","021_8_6","PRO","8","6","6","Ikialko, ani den ningo ninga manikko; ani den diram la balsam. ");
INSERT INTO wsk_vpl VALUES ("PR8_7","021_8_7","PRO","8","7","7","Aninga agiring te den nunguning la balsam; ani den kawel bo agiring te me arataso. ");
INSERT INTO wsk_vpl VALUES ("PR8_8","021_8_8","PRO","8","8","8","Den angamili te arataso mu am diram la, bo paguwukam mena. ");
INSERT INTO wsk_vpl VALUES ("PR8_9","021_8_9","PRO","8","9","9","Kariimet ikia sinar ago mu ko ikisan mu diram la se kumik paguwura bo mena. ");
INSERT INTO wsk_vpl VALUES ("PR8_10","021_8_10","PRO","8","10","10","Buta se aninga kiti guruga den ilukuawural ale silver nibiring tualko, ikia ningo ilukuawural ale gold nibiring tualko, ");
INSERT INTO wsk_vpl VALUES ("PR8_11","021_8_11","PRO","8","11","11","mu awuk, ikia sinar mu manga diamond nunga diara koma mu am kia saparam, se anapeya mel ni ninguru ko kuesam mu ikia sinar nunga kia saparam. ");
INSERT INTO wsk_vpl VALUES ("PR8_12","021_8_12","PRO","8","12","12","“Ani Ikia Sinar; ani tutera ningo mu ilak bagasam; ikia ningo se sinar la bagara mu aninga ningi aniso. ");
INSERT INTO wsk_vpl VALUES ("PR8_13","021_8_13","PRO","8","13","13","Kariimet Yawe bowa ningi bagasan, mu nuna ikia memek suen la mesan ale nubiring tusan; ani nusupuling lagara ko munan se nunumi patawura ko munan mu mesam; ale kilek memek betera se den kawel bala mu ani mesam tala. ");
INSERT INTO wsk_vpl VALUES ("PR8_14","021_8_14","PRO","8","14","14","Sangam den se kiti guruga ko den yawara mu aninga ningi aniso, se ikia yumura ko nunguning, se sokel agotala. ");
INSERT INTO wsk_vpl VALUES ("PR8_15","021_8_15","PRO","8","15","15","King alo se ali sor supuling alo mu ani te nunga ali terong la bitarsan, ale munan ningo diram la kalosan; ");
INSERT INTO wsk_vpl VALUES ("PR8_16","021_8_16","PRO","8","16","16","kari bibiya nunup ago mu ani te ali imi terong la bitarsan. ");
INSERT INTO wsk_vpl VALUES ("PR8_17","021_8_17","PRO","8","17","17","“Kariimet aninga kuesan, mu ani betela nunga kuesam; ale aninga kupusan, mu ani agarkasan. ");
INSERT INTO wsk_vpl VALUES ("PR8_18","021_8_18","PRO","8","18","18","Kariimet ani te mel suen biya gemasan ale nunup biya kaposo; ale ani te daiga bagara ningo diram te dagi baga lagasan. ");
INSERT INTO wsk_vpl VALUES ("PR8_19","021_8_19","PRO","8","19","19","Aninga ningo kariimet nungarsam mu gold se silver ningo kia saparam. ");
INSERT INTO wsk_vpl VALUES ("PR8_20","021_8_20","PRO","8","20","20","Ani munan ningo diram la te laga se, ");
INSERT INTO wsk_vpl VALUES ("PR8_21","021_8_21","PRO","8","21","21","kariimet aga kuesan mu mel ningo ningo nungarsam se karogo terong masan. ");
INSERT INTO wsk_vpl VALUES ("PR8_22","021_8_22","PRO","8","22","22","“Ani Yawe ko, se tom nu taiti ali mel suen la me nungurukaso la, ani noko ningi bagakasam. ");
INSERT INTO wsk_vpl VALUES ("PR8_23","021_8_23","PRO","8","23","23","Nu kumik duap se kopa mena iwitatala, ani noko ningi angimik duap se kopa mena bagerem se mel suen biya udagi aratam. ");
INSERT INTO wsk_vpl VALUES ("PR8_24","021_8_24","PRO","8","24","24","Gagi se yu me arata tom te, ");
INSERT INTO wsk_vpl VALUES ("PR8_25","021_8_25","PRO","8","25","25","duruk bibiya se motongar gotektek kuwim me ta ta la, ");
INSERT INTO wsk_vpl VALUES ("PR8_26","021_8_26","PRO","8","26","26","nu ali se tammanga mel awote mu me nungam la, ani noko ningi bagerem. ");
INSERT INTO wsk_vpl VALUES ("PR8_27","021_8_27","PRO","8","27","27","Ani bagerem se nu taiti gomang nungam, ale taiti tagi ago kapa gagi karogo numi kuting iluwam; ");
INSERT INTO wsk_vpl VALUES ("PR8_28","021_8_28","PRO","8","28","28","ale taiti nuwi taiti gomang te awuram, ale yu ali ningi nungam; ");
INSERT INTO wsk_vpl VALUES ("PR8_29","021_8_29","PRO","8","29","29","ale gagi ko tom bita bita karogo namaram ale ali me mituwurokko balam; ale ali ko nukuri awu awu karogo namaram. ");
INSERT INTO wsk_vpl VALUES ("PR8_30","021_8_30","PRO","8","30","30","Nu ani noko ikia sinar te mel suen la imi nunguruwakaso, ale pempem ago ko amilmil kelagakaso; se ani noko ningi betela amilmilakasam, ");
INSERT INTO wsk_vpl VALUES ("PR8_31","021_8_31","PRO","8","31","31","ale ali mel se kariimet suen la nunga nungam mu ko ninguru amilmilakasam. ");
INSERT INTO wsk_vpl VALUES ("PR8_32","021_8_32","PRO","8","32","32","“Se aga kuriang alo, aninga den ninguru ikialko; ani balsam turan beteral, mu amilmilaralko. ");
INSERT INTO wsk_vpl VALUES ("PR8_33","021_8_33","PRO","8","33","33","Aninga karo tua ko den ikial ale ikia sinar ago bagaralko; me nibiring tualko. ");
INSERT INTO wsk_vpl VALUES ("PR8_34","021_8_34","PRO","8","34","34","Awiriya pempem taiso aningate den ikiso ale karo tuso, mu amilmilarukko. ");
INSERT INTO wsk_vpl VALUES ("PR8_35","021_8_35","PRO","8","35","35","Mu awuk, awiriya aninga kupuso ale agarkoso, mu nu bagara ningo arigiso, ale Yawe motam te ningo la lagoso. ");
INSERT INTO wsk_vpl VALUES ("PR8_36","021_8_36","PRO","8","36","36","Bare awiriya ani ago ko doleng saposo, mu kota numi maguwuso; kariimet ani ago ko me negesan mu kua namara ko lage ko kuesan.” ");
INSERT INTO wsk_vpl VALUES ("PR9_1","021_9_1","PRO","9","1","1","Ikia Sinar ko kawam yawara kaolam, ale ngatalek 7 bala ago kisiram mu kawam koma ko bangaru ago namaram. ");
INSERT INTO wsk_vpl VALUES ("PR9_2","021_9_2","PRO","9","2","2","Nu na ningo ningo nungam, ale waen gurugu beteram, ale na inang te awura ko kuwim mu nunguru beteram. ");
INSERT INTO wsk_vpl VALUES ("PR9_3","021_9_3","PRO","9","3","3","Nu ko ura imet itiwik alo den nungaram se namaman, se nu duruk dopang te kualala sanamaram ale aiwoso: ");
INSERT INTO wsk_vpl VALUES ("PR9_4","021_9_4","PRO","9","4","4","“Nina kariimet ikia sinar ko tukunangasan mu tairalko!” Nu kariimet nunga ikia aora biya mu nunga manarso, ");
INSERT INTO wsk_vpl VALUES ("PR9_5","021_9_5","PRO","9","5","5","“Tairal ale na inang se yu waen nunguru beterem ewere nalko. ");
INSERT INTO wsk_vpl VALUES ("PR9_6","021_9_6","PRO","9","6","6","Bagara ngualara sumu beteral ale ikia ago la bagaralko, mu asele nina bagara aolak ningo arigalko,” maso. ");
INSERT INTO wsk_vpl VALUES ("PR9_7","021_9_7","PRO","9","7","7","Ikia sinar suwik sapara ko kari agi, memek betera ko kari mu ko memek mu kasuruko mu, ni ko sinar to se ko; mu awuk, nu koma ko den memek ka manukko. ");
INSERT INTO wsk_vpl VALUES ("PR9_8","021_9_8","PRO","9","8","8","Buta se ikia sinar suwik sapara ko kari, ko memek me manaruko; ni manaru mu kerak dun kopa iluwokko; bare ikia sinar ko kari, ko paguwura kasuru mu nu amilmilarukko. ");
INSERT INTO wsk_vpl VALUES ("PR9_9","021_9_9","PRO","9","9","9","Mu awuk, kari ikia sinar ago mu kiti gurugusam, mu eng am nu ningo nuam ko arataso; uwutatala, ningo diram betera ko kari mu ikia ningo kasursam, mu ni noko ikia ningo mu kunasi tusam. ");
INSERT INTO wsk_vpl VALUES ("PR9_10","021_9_10","PRO","9","10","10","Yawe ko kua bowa ningi la bagara ko munan mu ikia sinar te ta ko lage kuring; Kaem Laili mu ko ninguru iki, mu ni ikia sinar ko nunguning karogo terong meko. ");
INSERT INTO wsk_vpl VALUES ("PR9_11","021_9_11","PRO","9","11","11","Ikia sinar ilukuawur, mu ni tom maiya biya, yia suen biya ali imi te bagerko. ");
INSERT INTO wsk_vpl VALUES ("PR9_12","021_9_12","PRO","9","12","12","Ni ikia sinar karogo, mu ikia sinar mu koma ningo kisokko; bare ni ikia sinar suwik sapar, mu ni keta nimi ikup ningi betesam. ");
INSERT INTO wsk_vpl VALUES ("PR9_13","021_9_13","PRO","9","13","13","Ikia Ngualara mu imet bo numi ira mena, kuring nirung gurum; ikia ningo bo nukote me aniso. ");
INSERT INTO wsk_vpl VALUES ("PR9_14","021_9_14","PRO","9","14","14","Nu noko kawam kuring ko daigam, ale kualala biya baga se loagaram se wonong te kaparam ");
INSERT INTO wsk_vpl VALUES ("PR9_15","021_9_15","PRO","9","15","15","se kariimet lage karo nama taiwasan mu aiso ale nunga manarso: ");
INSERT INTO wsk_vpl VALUES ("PR9_16","021_9_16","PRO","9","16","16","“Nina kariimet ninga ikia me sinar aso, mu aninga kawam te tairalko.” Ale kariimet nunga ikia aora biya mu nunga manarso: ");
INSERT INTO wsk_vpl VALUES ("PR9_17","021_9_17","PRO","9","17","17","“Yu tere te gisan ale nasan mu ko na yawara nunguningkiri; inang tere te gisan ale yumura la nasan mu yaman nuam!” maso. ");
INSERT INTO wsk_vpl VALUES ("PR9_18","021_9_18","PRO","9","18","18","Noko kawam mu, te kua namara ko kawam, bare kariimet me ko ikisan; se kariimet noko kawam te giriman namaman, mu aitak kueman ale mutim ningi anisan. ");
INSERT INTO wsk_vpl VALUES ("PR10_1","021_10_1","PRO","10","1","1","Imi Solomon ko ikia sinar ko den: Kuriang ikia sinar karogo mu, nuet gomang motam amilmil tuso; bare supuling lagara ko kuriang mu, nuam gomang motam batagarso. ");
INSERT INTO wsk_vpl VALUES ("PR10_2","021_10_2","PRO","10","2","2","Munan memek te mel ningo ningo gia mu kumik ningo bo mena; bare munan ningo diram mu memek ko lage te ka bataguru taukko. ");
INSERT INTO wsk_vpl VALUES ("PR10_3","021_10_3","PRO","10","3","3","Yawe kariimet ningo diram mu nungarkiwoso se inang ko me kuesan; bare memek betera ko kariimet mu nu nongoma siruwuso se mel ko kuesan mu me gisan. ");
INSERT INTO wsk_vpl VALUES ("PR10_4","021_10_4","PRO","10","4","4","Gagor ko munan te kimik mel mena lagerko; bare ura kowar ko munan te mu mel ago lagerko. ");
INSERT INTO wsk_vpl VALUES ("PR10_5","021_10_5","PRO","10","5","5","Kari sinar mu inang gia kam te na inang gi bolala awuso; bare awiriya na inang gia kam te ani geraga lagoso mu kota numi dolara tuso. ");
INSERT INTO wsk_vpl VALUES ("PR10_6","021_10_6","PRO","10","6","6","Kariimet munan diram karo lagasan, mu marak ningo tuwik musiring kapakoyam nungumik kuali kaposo; bare kariimet memek nuguring te mu kager ko den aratu lagoso. ");
INSERT INTO wsk_vpl VALUES ("PR10_7","021_10_7","PRO","10","7","7","Kariimet ningo diram mu kuesan mu nunga munan ningo mu mel yawara bo iwita ani lagoso; bare kariimet memek alo kuesan mu nunga nunup mena namoso. ");
INSERT INTO wsk_vpl VALUES ("PR10_8","021_10_8","PRO","10","8","8","Kariimet ikia sinar ago, mu amilmil te iki karo tusan; bare awiriya munak ngualara kuring te aratu lagoso mu maga namoso. ");
INSERT INTO wsk_vpl VALUES ("PR10_9","021_10_9","PRO","10","9","9","Kari ko ikia, ko gomang motam se aolak ko sinar to lagoso, mu sokel ago la lagoso; bare awiriya ikia memek karo lagoso, mu me yumuso. ");
INSERT INTO wsk_vpl VALUES ("PR10_10","021_10_10","PRO","10","10","10","Awiriya memek ereso ale te kaluwurokko motam kui parang maso, mu ikup tagiso; bare kari mel memek wetang saposo, mu bagara ningo lila sokel tuso. ");
INSERT INTO wsk_vpl VALUES ("PR10_11","021_10_11","PRO","10","11","11","Kariimet ningo diram mu ko kuring mu tam bo marak nangarso wore turan; bare kariimet memek nuguring te mu, kager ko den aratu lagoso. ");
INSERT INTO wsk_vpl VALUES ("PR10_12","021_10_12","PRO","10","12","12","Nanimi ko me kuera ko munan mu ikup duap duap tagiso; bare nanimi ko kuera ko munan mu memek suen la ko sokel karogo kaposo. ");
INSERT INTO wsk_vpl VALUES ("PR10_13","021_10_13","PRO","10","13","13","Kariimet sinar mu nuguring te ikia sinar ko den arataso; bare awiriya sinar mena mu bu taukko. ");
INSERT INTO wsk_vpl VALUES ("PR10_14","021_10_14","PRO","10","14","14","Kari ikia sinar ago, mu ikia ningo ningo ilu biguwuso; bare awiriya sinar mena mu munak te ikup tagiso. ");
INSERT INTO wsk_vpl VALUES ("PR10_15","021_10_15","PRO","10","15","15","Kari kumik mel ago mu ko mel ningo ningo mu nu bituokko; bare kari kumik mel mena mu awuk saonga taukko? ");
INSERT INTO wsk_vpl VALUES ("PR10_16","021_10_16","PRO","10","16","16","Kari ningo diram, ko bagara aolak ningo mu ko koma, bagara ningo arigiso; bare kari memek, ko kilek memek mu ko koma, ikup memek arigiso. ");
INSERT INTO wsk_vpl VALUES ("PR10_17","021_10_17","PRO","10","17","17","Awiriya ko memek ko kausa den ningo ilukuawuso, mu bagara ningo ko lage arigiso; bare awiriya ko memek ko kausa den buring tuso, mu lage memek karoso. ");
INSERT INTO wsk_vpl VALUES ("PR10_18","021_10_18","PRO","10","18","18","Awiriya gomang ningi la bo ko me kueso bare kuring guang te den ningo ilak balso, mu kawel kari; se awiriya saki alo nubiring ko balu balu geragoso, mu nu kari borara. ");
INSERT INTO wsk_vpl VALUES ("PR10_19","021_10_19","PRO","10","19","19","Munak tawun biya bala ningi mu memek arataso; bare awiriya ko munak ko sinar taso, mu nu sinar kari. ");
INSERT INTO wsk_vpl VALUES ("PR10_20","021_10_20","PRO","10","20","20","Kari ningo diram ko munak mu silver ningo iwita; bare kari memek ko gomang motam mu ningi mel ningo bo me aniso. ");
INSERT INTO wsk_vpl VALUES ("PR10_21","021_10_21","PRO","10","21","21","Kari ningo diram ko den mu inang ningo iwita, kariimet suen biya nunga sangarso; bare kari supuling aora biya mu kumik ikia ningo bo mena se kua namoso. ");
INSERT INTO wsk_vpl VALUES ("PR10_22","021_10_22","PRO","10","22","22","Yawe ko marak mu yawarakala se mel ningo ningo nangarso; se memek bo ningi nanga maguwurokko me aniso, mena. ");
INSERT INTO wsk_vpl VALUES ("PR10_23","021_10_23","PRO","10","23","23","Kari ngualara mu memek bitirukko mu amilmil te la beteso; bare kari sinar mu ikia sinar ko munan bitirukko ninguru amilmiloso. ");
INSERT INTO wsk_vpl VALUES ("PR10_24","021_10_24","PRO","10","24","24","Kari memek mu mel memek nu me ko kueso ale nguangawoso mu tairuk maguwurokko; bare kari ningo diram mu mel ningo gomang motam te aniso mu taukko. ");
INSERT INTO wsk_vpl VALUES ("PR10_25","021_10_25","PRO","10","25","25","Tuwik lom kaparuk mu kariimet memek nunga sarumu warukko; bare kariimet ningo diram mu aora biya bagamonko. ");
INSERT INTO wsk_vpl VALUES ("PR10_26","021_10_26","PRO","10","26","26","We barare nasam se kere birigiso, se tama bur motam kaiso se motam yu kaposo iwita, kari gagor ura te bitar mu, nu uwutata gemang yaman tuokko. ");
INSERT INTO wsk_vpl VALUES ("PR10_27","021_10_27","PRO","10","27","27","Yawe kuring bowa ningi bagara ko munan te, ali imi te tom maiya biya bagasan; bare kari memek alo mu, nunga ali imi te bagara ko tom mu batagam, tukunangta. ");
INSERT INTO wsk_vpl VALUES ("PR10_28","021_10_28","PRO","10","28","28","Kariimet ningo diram mu, mel ko kimi bitawasan mu arigimon ale ago amilmilamonko; bare kariimet memek alo mu, mel ningo nuam me arigimonko, am ipi kimi bita lagamonko. ");
INSERT INTO wsk_vpl VALUES ("PR10_29","021_10_29","PRO","10","29","29","Kariimet ningo diram mu, Yawe ko munan bowa ningi baga se te ningo la lagasan; bare kariimet memek alo mu, noko munan ningo umu bowa ningi memek arigimonko. ");
INSERT INTO wsk_vpl VALUES ("PR10_30","021_10_30","PRO","10","30","30","Kariimet ningo diram mu nukuri yager ago se nunga baruka ko me terong; bare kariimet memek alo mu ali te me bagamonko. ");
INSERT INTO wsk_vpl VALUES ("PR10_31","021_10_31","PRO","10","31","31","Kari ningo diram kuring te ikia sinar ko den arataso; bare awiriya kuring ningi den memek arataso mu memek tauk ale kuring sisirokko. ");
INSERT INTO wsk_vpl VALUES ("PR10_32","021_10_32","PRO","10","32","32","Kariimet ningo diram mu anapeya balukko mu ko iki se balso; bare kariimet memek nunga den mu am kawel la se kariimet nunga maguwuso. ");
INSERT INTO wsk_vpl VALUES ("PR11_1","021_11_1","PRO","11","1","1","Kariimet skel ko nuamur sang gurugusan se mel ko ikup diram me balso, mu Yawe munan umu me ko kueso nunguningkiri; bare nu kariimet mel ko ikup ko tom diram la balsan mu nunga amilmiloso. ");
INSERT INTO wsk_vpl VALUES ("PR11_2","021_11_2","PRO","11","2","2","Nanimi patawura ko munan taiso mu, buring ko dolara taiso; bare nanimi karogo kapara ko munan mu ikia sinar nangarso. ");
INSERT INTO wsk_vpl VALUES ("PR11_3","021_11_3","PRO","11","3","3","Kawel mena diram la bagara ko munan mu, kariimet ningo nunga kiti guruguso; bare kawel munan mu, kariimet ikia suanta la me kaora mu nunga maguwuso. ");
INSERT INTO wsk_vpl VALUES ("PR11_4","021_11_4","PRO","11","4","4","Mel ningo ningo ago bagara ko munan mu, tom memek ningi me ka sangukko; bare ningo diram la bagara ko munan mu, maga namara ko lage te ka bataguru taukko. ");
INSERT INTO wsk_vpl VALUES ("PR11_5","021_11_5","PRO","11","5","5","Kariimet nungumik den mena alo mu, nunga munan ningo diram mu lage ningo nunga kasurso; bare kariimet memek mu nongota nunga memek nunga maguwuso. ");
INSERT INTO wsk_vpl VALUES ("PR11_6","021_11_6","PRO","11","6","6","Diram la bagara ko kariimet alo mu, nunga munan ningo diram mu nunga sangaru taso; bare ikia suanta la me kaora alo mu, nunga ikia memek mu nunga taliposo. ");
INSERT INTO wsk_vpl VALUES ("PR11_7","021_11_7","PRO","11","7","7","Tom kari memek bo kueso, mu mel taukko ko gomang ikia bita lagoso mu mena namoso; anapeya taukko ko sail tagi lagaram mu ta mena. ");
INSERT INTO wsk_vpl VALUES ("PR11_8","021_11_8","PRO","11","8","8","Kari ningo diram mu ikup kam ningi saonga taso; bare ikup mu geragoso kari memek mu maguwuso. ");
INSERT INTO wsk_vpl VALUES ("PR11_9","021_11_9","PRO","11","9","9","Kaem ko me kuruwa ko kari mu, ko munak memek mu te ko saki alo nunga maguwuso; bare kari ningo diram mu ikia ningo te numi bataguru taso. ");
INSERT INTO wsk_vpl VALUES ("PR11_10","021_11_10","PRO","11","10","10","Tom kariimet ningo diram mu mel betesan se ningo la arataso, mu wonong lilim la amilmilasan; se tom kariimet memek alo kua gilingisan, uwutatala kariimet aisan ale nuguting mosan. ");
INSERT INTO wsk_vpl VALUES ("PR11_11","021_11_11","PRO","11","11","11","Kariimet ningo nuam wonong bo te bagasan, mu wonong mu nup yawara taso; bare kariimet memek wonong bo te bagasan, mu nunga bala memek te wonong mu ko nup magoso. ");
INSERT INTO wsk_vpl VALUES ("PR11_12","021_11_12","PRO","11","12","12","Awiriya ko bo doleng sapara den manarso mu nu kari ngualara; bare kari ikia nunguning ago mu uwuta me bitirukko. ");
INSERT INTO wsk_vpl VALUES ("PR11_13","021_11_13","PRO","11","13","13","Munak gi ago geraga ko munan te den yumura pagorsan; bare kari gomang motam ko sinar taso, mu mel me bala ko mu me wetang te balso. ");
INSERT INTO wsk_vpl VALUES ("PR11_14","021_11_14","PRO","11","14","14","Kari supuling alo wosagam me kiti guruguwomon, mu kariimet memek tamonko; bare kari supuling wosagam ninguru kiti guruguwomon, mu kariimet yawarakala bagamonko. ");
INSERT INTO wsk_vpl VALUES ("PR11_15","021_11_15","PRO","11","15","15","Bo saonga ale ko dinau bo kote beteram umu kutuwura ko bala ni me baluko, mu awuk, ni keta nimi ikup ningi betesam; kari munan umu biriruwuso, mu nu ningo la lagoso. ");
INSERT INTO wsk_vpl VALUES ("PR11_16","021_11_16","PRO","11","16","16","Imet gomang motam ningo se welang ago, mu kariimet nup biya tusan; bare kari darangara alis munumuning te mel ningo ningo giso, mu kumik nup mena. ");
INSERT INTO wsk_vpl VALUES ("PR11_17","021_11_17","PRO","11","17","17","Kari gomang motam ningo se welang ago mu ningo la lagoso; bare ining singi alis daong ko kari mu ikup tagi kota kumik te beteso. ");
INSERT INTO wsk_vpl VALUES ("PR11_18","021_11_18","PRO","11","18","18","Kari memek mu ko ura koma mel nunguning taso i maso, bare mena, ko ura koma mu dora se kawel; bare kari munan ningo diram bita lagoso, mu ko koma mel nunguning taso. ");
INSERT INTO wsk_vpl VALUES ("PR11_19","021_11_19","PRO","11","19","19","Kari munan ningo diram ko sail tagiso, mu bagara ningo arigiso; bare kari munan memek karo tui lagoso, mu kua namara ko lage te namoso. ");
INSERT INTO wsk_vpl VALUES ("PR11_20","021_11_20","PRO","11","20","20","Kariimet ikia memek tom suen biya to lagasan, mu Yawe me nunga kueso; bare kariimet diram la lagasan, mu Yawe nunga amilmiloso. ");
INSERT INTO wsk_vpl VALUES ("PR11_21","021_11_21","PRO","11","21","21","Ninguru ikialko: memek betera ko kariimet alo mu me ipi namamonkowo, nunga memek koma tamonko; bare kariimet ningo diram mu ikup mena, ningo la namamonko. ");
INSERT INTO wsk_vpl VALUES ("PR11_22","021_11_22","PRO","11","22","22","Gold ring balayam yawara buruk kuamuru tuguma mu me terong; se imet koma motam balayam yawara, wore munan memek beteso, mu me terong tala. ");
INSERT INTO wsk_vpl VALUES ("PR11_23","021_11_23","PRO","11","23","23","Kariimet munan ningo la ko kua lagasan, mu bagara ningo arigimonko; bare kariimet kilek ikia memek ko kua lagasan, mu Yawe ko gomang magara arigimonko. ");
INSERT INTO wsk_vpl VALUES ("PR11_24","021_11_24","PRO","11","24","24","Kari amilmil te ko melmasak kariimet sang nungarso guruguso mu, me ta tukunangaso, bo bo karogo am giwoso; bare kari ko melmasak ko dogotak soroso, mu nama eng am kumik mel mena ko arataso. ");
INSERT INTO wsk_vpl VALUES ("PR11_25","021_11_25","PRO","11","25","25","Amilmil te kariimet mel nungara ko kari mu pempem mel karogo la lagarukko; awiriya kariimet sang yu te nunga sangarso, mu ko koma nu betela yu te sangarmonko. ");
INSERT INTO wsk_vpl VALUES ("PR11_26","021_11_26","PRO","11","26","26","Kari ko na inang guramoso mu, kariimet kumik ko bala memek balu gilingisan; bare kari kuting urukuso se kote na inang diasan mu, bala ningo kumik ko balsan. ");
INSERT INTO wsk_vpl VALUES ("PR11_27","021_11_27","PRO","11","27","27","Awiriya munan ningo karo tui lagoso, mu nuna koma munan ningo kote betemonko; bare awiriya munan memek bita karo lagoso, mu koma munan memek arigiso. ");
INSERT INTO wsk_vpl VALUES ("PR11_28","021_11_28","PRO","11","28","28","Awiriya ko mel ningo ningo te ira sanamoso mu dagulokko; bare kari ningo diram mu, tam gawa maramarak iwita marak bagarukko. ");
INSERT INTO wsk_vpl VALUES ("PR11_29","021_11_29","PRO","11","29","29","Kari ikup memek tagi ko imet kuriang nungumik te beteso, mu mel ningo bo me taso; ikia sinar mena alo mu, kari ikia sinar ago mu nunga dungan kari bagamonko. ");
INSERT INTO wsk_vpl VALUES ("PR11_30","021_11_30","PRO","11","30","30","Munan ningo diram ko nunguning mu tam marak nangarso wore turan; awiriya kariimet saki lage ningo te nunga awuso, mu nu ikia sinar kari. ");
INSERT INTO wsk_vpl VALUES ("PR11_31","021_11_31","PRO","11","31","31","Kariimet ningo diram alo nunga munan koma ali imi te tasan. Se awuk? Kariimet memek Kaem nubiring tusan mu nunga munan koma me tamonko e? ");
INSERT INTO wsk_vpl VALUES ("PR12_1","021_12_1","PRO","12","1","1","Awiriya due iluwa ko den ko amilmiloso, mu ikia ningo karogo gek maso; bare awiriya due iluwa ko den mu dulurso, mu nu kari ngualara. ");
INSERT INTO wsk_vpl VALUES ("PR12_2","021_12_2","PRO","12","2","2","Yawe kari ningo mu ko kueso; bare nu kawel kari mu memek te nunga beteso. ");
INSERT INTO wsk_vpl VALUES ("PR12_3","021_12_3","PRO","12","3","3","Nukuri betera ale gek am daiga bagara ko munan mu kilek memek ningi me arataso ale taiso, mena; bare kari ningo diram bitawoso mu ni me baruku sapar i. ");
INSERT INTO wsk_vpl VALUES ("PR12_4","021_12_4","PRO","12","4","4","Kiwem ningo betera ko imet mu ko kiwem mu te kuari nup yawara taso; bare imet ko kiwem memek mu ko kiwem umu kuera memek bo iwita, kuari kumik sail menawuso. ");
INSERT INTO wsk_vpl VALUES ("PR12_5","021_12_5","PRO","12","5","5","Kari ningo diram mu awiriya kote anapeya ningo bitirukko balso mu diram la beteso; bare kari memek nunga bala mu am kawel la. ");
INSERT INTO wsk_vpl VALUES ("PR12_6","021_12_6","PRO","12","6","6","Kari memek ko den mu kari te iluwa ko dagarok iwita; bare kari ningo kuring te den arataso mu kari bataguru taso. ");
INSERT INTO wsk_vpl VALUES ("PR12_7","021_12_7","PRO","12","7","7","Kariimet memek mu ikup arigisan ale maga namasan; bare kari ningo mu ko kawam digo lilim karogo sokel karogo la lagoso. ");
INSERT INTO wsk_vpl VALUES ("PR12_8","021_12_8","PRO","12","8","8","Kari ikia sinar ago mu nup biya taso; bare kari ko ikia daeldel pukakung mu mel yam ko betesan. ");
INSERT INTO wsk_vpl VALUES ("PR12_9","021_12_9","PRO","12","9","9","Munan nunguning mu iwita: kari kituwura ko baga se ke kimik ko ura bitar mu terong; bare kimik mel mena wore nimi kaluwura ale mel suen biya ago iwita baga se inang ko kua lagara mu munan kawel. ");
INSERT INTO wsk_vpl VALUES ("PR12_10","021_12_10","PRO","12","10","10","Munan diram ko kari mu ko buruk kausik mel ninguru nunga bitarso; bare kari memek mu ko buruk kausik mel ningo nungumik te beteso ma se, wore ninguru nunga bita maguwuso. ");
INSERT INTO wsk_vpl VALUES ("PR12_11","021_12_11","PRO","12","11","11","Awiriya ko ali te kuting gege naguso, mu nu na inang mel terong la kapa tuso; bare awiriya ikia kawel karo karo bola pala lagara, mu nu kumik ikia ningo mena. ");
INSERT INTO wsk_vpl VALUES ("PR12_12","021_12_12","PRO","12","12","12","Kari memek alo mu, lage memek te melmur gisan mu ninguru nongomang tusan; bare kari ningo diram mu, nunga ura kowar te mel yager beteso ale nunguning kapa nungarso. ");
INSERT INTO wsk_vpl VALUES ("PR12_13","021_12_13","PRO","12","13","13","Kari memek mu kota ko munak memek giris palagoso ale taliposo; bare kari ningo diram mu ikup memek uwuta mu kia kaposo. ");
INSERT INTO wsk_vpl VALUES ("PR12_14","021_12_14","PRO","12","14","14","Kari ko munak ningo te mel ningo ningo kumik kauso; se ura kowar bitar, mu koma yawara kapa kisokko. ");
INSERT INTO wsk_vpl VALUES ("PR12_15","021_12_15","PRO","12","15","15","Kari supuling aora biya mu anapeya beteso mu ningo la ko iwita balso; bare kari sinar mu kiti guruga den ikiokko due sapa lagoso. ");
INSERT INTO wsk_vpl VALUES ("PR12_16","021_12_16","PRO","12","16","16","Kari supuling aora biya mu pasak gomang magaruk se arikko; bare kari sinar mu bita maguwur, wore me pasak koma bitirukko. ");
INSERT INTO wsk_vpl VALUES ("PR12_17","021_12_17","PRO","12","17","17","Den nunguning bala ko kari mu biguwura motam te den nunguning la balso; bare den kawel bala ko kari mu kawel gurugokko. ");
INSERT INTO wsk_vpl VALUES ("PR12_18","021_12_18","PRO","12","18","18","Munak memek ngual kasik sapara mu batir iwita kari atumuso; bare kari sinar ko den welang mu kari gomang motam lilumuso. ");
INSERT INTO wsk_vpl VALUES ("PR12_19","021_12_19","PRO","12","19","19","Den nunguning balu mu, tom maiya biya ani lagarukko; bare den kawel balu mu, tom tukunangta baga nungamili sapa namarukko. ");
INSERT INTO wsk_vpl VALUES ("PR12_20","021_12_20","PRO","12","20","20","Kariimet memek betemonko den kalosan, mu nongomang motam kawel karogo terong mam; bare kariimet bagara lila sokel tusan mu amilmilamonko. ");
INSERT INTO wsk_vpl VALUES ("PR12_21","021_12_21","PRO","12","21","21","Kariimet ningo diram mu memek bo me nunga maguwuso; bare kariimet memek mu memek suen biya arigisan. ");
INSERT INTO wsk_vpl VALUES ("PR12_22","021_12_22","PRO","12","22","22","Yawe den kawel bala ko kariimet mu nunga biriruwuso; bare den nunguning bala ko kariimet mu nu nunga amilmiloso. ");
INSERT INTO wsk_vpl VALUES ("PR12_23","021_12_23","PRO","12","23","23","Kari sinar mu ko ikia ningo mu ninguru bitarso; bare kariimet ikia aora biya mu nunga kawel mu am ngual ngual balu sapasan. ");
INSERT INTO wsk_vpl VALUES ("PR12_24","021_12_24","PRO","12","24","24","Ura kowar betera ko kari mu kari supuling ko arataso; bare kari gagor mu diruwumon se ura dungan bitirukko. ");
INSERT INTO wsk_vpl VALUES ("PR12_25","021_12_25","PRO","12","25","25","Gemang namara taira bataga iluwa se nguangara mu kimik sokel karogo kaparukko; bare sangam den ningo mu gemang motam sokel tuokko. ");
INSERT INTO wsk_vpl VALUES ("PR12_26","021_12_26","PRO","12","26","26","Kari ningo diram mu ninguru ari ikiso ale asele bo ilak numi giso; bare kari memek nunga munan mu lage memek te nongorak namoso. ");
INSERT INTO wsk_vpl VALUES ("PR12_27","021_12_27","PRO","12","27","27","Kari gagor mu bulamurok bare mel bo me ta morukko; bare ura kowar betera ko kari mu mel ningo ningo giso. ");
INSERT INTO wsk_vpl VALUES ("PR12_28","021_12_28","PRO","12","28","28","Ningo diram la bagara ko munan mu bagara ningo nangarso; se lage mu karo mu kuera mateng me arikko. ");
INSERT INTO wsk_vpl VALUES ("PR13_1","021_13_1","PRO","13","1","1","Kuriang ikia sinar ago, mu ko nuet ko kiti guruga den ilukuawuso; bare ikia sinar suwik sapara ko kuriang mu ko memek manaru, mu me ikiokko. ");
INSERT INTO wsk_vpl VALUES ("PR13_2","021_13_2","PRO","13","2","2","Kari ko munak ningo te mel ningo ningo kumik kauso; bare kawel kari memek mu, kager ko munan mu na nokoyam ko kua nanuguso. ");
INSERT INTO wsk_vpl VALUES ("PR13_3","021_13_3","PRO","13","3","3","Kari ko kuring ko sinar taso, mu ko bagara aolak ko bitua ningo beteso; bare awiriya munak ngual kasik munakoso, mu nu ikup ningi maga namoso. ");
INSERT INTO wsk_vpl VALUES ("PR13_4","021_13_4","PRO","13","4","4","Kari gagor mu melmasak suen biya ko kueso, bare bo me taso; bare ura kowar iluwa ko kari mu melmasak suen biya ago terong maso. ");
INSERT INTO wsk_vpl VALUES ("PR13_5","021_13_5","PRO","13","5","5","Kari ningo diram mu, munan kawel mu me ko kueso nunguningkiri; bare kari memek mu, munan memek dolara ago mu kumik siring kaiyam. ");
INSERT INTO wsk_vpl VALUES ("PR13_6","021_13_6","PRO","13","6","6","Ningo diram la bagara ko munan mu, kari ningo mu lage kasurso se te ningo la lagoso; bare memek betera ko kari mu kota ko memek mu saposo se daguloso. ");
INSERT INTO wsk_vpl VALUES ("PR13_7","021_13_7","PRO","13","7","7","Kariimet saki manga mel ningo ningo karogo iwita nunumi betesan, bare nunguning mu nuna nungumik mel mena. Bare saki mu nuna nungumik manga mel mena iwita nunumi betesan ale bagasan, bare nuna nunga melmasak mu suen biya. ");
INSERT INTO wsk_vpl VALUES ("PR13_8","021_13_8","PRO","13","8","8","Kari kumik manga mel suen biya ago, mu ikup kam ningi te numi bataguru taukko; bare kari kumik mel mena mu anape ko ikup uwuta mu kumik te aratukko? Mena. ");
INSERT INTO wsk_vpl VALUES ("PR13_9","021_13_9","PRO","13","9","9","Kari ko bagara ningo diram mu, galep nikim biya bo iwita; bare kari memek mu, galep iri namoso wore iwita. ");
INSERT INTO wsk_vpl VALUES ("PR13_10","021_13_10","PRO","13","10","10","Nanimi patawura ko nunguning mu nanimi karogo tagisan gurungumusan; bare awiriya ikia sinar ago mu, kiti guruga ko den ilukuawuso. ");
INSERT INTO wsk_vpl VALUES ("PR13_11","021_13_11","PRO","13","11","11","Kari lage memek te manga tagiso, mu manga mu tairate yumu namoso; bare kari ko manga taso ale katir katir bolala awuso, mu manga mu laga tuso. ");
INSERT INTO wsk_vpl VALUES ("PR13_12","021_13_12","PRO","13","12","12","Awiriya anapeya gomang te mu taukko tom maiya biya kimi bita lagoso, mu gomang motam ninguru kaposo; bare tom nu taso mu marak iru kumik te taikoyam amilmiloso. ");
INSERT INTO wsk_vpl VALUES ("PR13_13","021_13_13","PRO","13","13","13","Awiriya karo tua ko den balu maguwuso, mu koma arigokko; bare awiriya ko amilmiloso, mu koma ningo taukko. ");
INSERT INTO wsk_vpl VALUES ("PR13_14","021_13_14","PRO","13","14","14","Kari sinar ko kausa den mu bagara aolak sangarso, ale kari kua namara ko lage te mu sangaru taso. ");
INSERT INTO wsk_vpl VALUES ("PR13_15","021_13_15","PRO","13","15","15","Ikia ningo mu kari nup ningo tuso; bare kawel ko munan mu kari lage memek te beteso. ");
INSERT INTO wsk_vpl VALUES ("PR13_16","021_13_16","PRO","13","16","16","Kari ikia ningo ago mu ko munan mu ikia sinar karogo la beteso; bare kari ko ikia aora biya mu wetang te numi saposo. ");
INSERT INTO wsk_vpl VALUES ("PR13_17","021_13_17","PRO","13","17","17","Den ta ale karogo namara ale diram la me bala mu ikup tagiso; bare den karogo nama diram la bala mu marasin ningo iwita. ");
INSERT INTO wsk_vpl VALUES ("PR13_18","021_13_18","PRO","13","18","18","Awiriya due ta ko den buring tuso, mu kumik mel mena baga se dola lagarukko; bare awiriya kawus maso ale iki karo tuso, mu amilmil taso. ");
INSERT INTO wsk_vpl VALUES ("PR13_19","021_13_19","PRO","13","19","19","Mel ko gemang motam nia laga tata mu gemang motam lila arukko; bare kariimet nusupuling aora biya mu, nunga munan memek umu me bita tamonko nongomang aniso. ");
INSERT INTO wsk_vpl VALUES ("PR13_20","021_13_20","PRO","13","20","20","Awiriya ikia sinar ko kari ilak kapetoso, mu nu agotala ikia sinar kari ko arataso; bare kari, kari ngualara nongorak sorara mu ikup yaman arigiso. ");
INSERT INTO wsk_vpl VALUES ("PR13_21","021_13_21","PRO","13","21","21","Kariimet memek alo mu ikup memek nunga maguwuso; bare kariimet ningo diram alo mu mel ningo ningo karogo terong masan. ");
INSERT INTO wsk_vpl VALUES ("PR13_22","021_13_22","PRO","13","22","22","Kari ningo mu ko mel ningo ningo mu ko kuriang imas nunga awu beteso; bare kari memek ko mel ningo ningo mu geragoso ale kari ningo diram mu nongote namoso. ");
INSERT INTO wsk_vpl VALUES ("PR13_23","021_13_23","PRO","13","23","23","Giarum ningi inang kue paga mu sor magaram ale aniso, kariimet kituwura te to namonko; bare munan kawel ningi arataso se nuna me gi nasan. ");
INSERT INTO wsk_vpl VALUES ("PR13_24","021_13_24","PRO","13","24","24","Awiriya ko kuriang nukum me tagiso, mu ko kuriang ko me kueso; bare awiriya ko kuriang ko kueso mu tom memek bitawoso mu te la dingumuso. ");
INSERT INTO wsk_vpl VALUES ("PR13_25","021_13_25","PRO","13","25","25","Kariimet ningo diram mu nunga na inang terong la no gilingisan; bare kariimet memek mu karak kua se lagasan. ");
INSERT INTO wsk_vpl VALUES ("PR14_1","021_14_1","PRO","14","1","1","Imet ikia sinar ago, mu ko kuari se kuriang se ko kawam digo lilim ninguru ilukuawuso; bare imet sinar mena, mu kota ko kawam digo lilim parusuwuso se kaposo. ");
INSERT INTO wsk_vpl VALUES ("PR14_2","021_14_2","PRO","14","2","2","Kari ko bagara aolak diram mu Yawe bowa ningi la lagoso; bare kari ko aolak memek mu Yawe mel yam ko beteso. ");
INSERT INTO wsk_vpl VALUES ("PR14_3","021_14_3","PRO","14","3","3","Kari ngualara numi patawura ko munak balso, mu ko koma taukko; bare kari ikia sinar ago ko munak mu nu bitarso. ");
INSERT INTO wsk_vpl VALUES ("PR14_4","021_14_4","PRO","14","4","4","Inang bulmakau naukko mu mena mu, ni anape ko bulmakau karogo bagerko? Bare aking bulmakau mena mu, ni awuk inang sor maga kisokko? ");
INSERT INTO wsk_vpl VALUES ("PR14_5","021_14_5","PRO","14","5","5","Den nunguning bala ko kari mu biguwura motam te den bo me kaluwuso; bare den kawel bala ko kari mu kawel gurugokko. ");
INSERT INTO wsk_vpl VALUES ("PR14_6","021_14_6","PRO","14","6","6","Ikia sinar suwik sapara ko kari mu ikia sinar kupok, bare bo me arigokko; bare kariimet ikia nunguning ko ikia, mu guyak la sinarsan. ");
INSERT INTO wsk_vpl VALUES ("PR14_7","021_14_7","PRO","14","7","7","Kari ngualara ilak me kapeterko; mu awuk, ni den sinar bo kuring te me ta ikiko. ");
INSERT INTO wsk_vpl VALUES ("PR14_8","021_14_8","PRO","14","8","8","Kari sinar mu, ikia sinar lage tuso; bare kari sinar mena mu, kota ko ngualara mu te numi kulurso. ");
INSERT INTO wsk_vpl VALUES ("PR14_9","021_14_9","PRO","14","9","9","Nusupuling aora biya alo mu, memek mu mel gotek ko balsan; bare nanimi nangamang tui se bagara suanta ko munan mu, kariimet diram alo mu nunga ningi aniso. ");
INSERT INTO wsk_vpl VALUES ("PR14_10","021_14_10","PRO","14","10","10","Kariimet suan suan kota ko gomang motam yaman ikup mu ninguru ko ikiso; uwutatala, noko amilmil ko sokel mu ko iki saparko me terong. ");
INSERT INTO wsk_vpl VALUES ("PR14_11","021_14_11","PRO","14","11","11","Kari diram ko kawam mu am sanamiwurukko; bare kari memek ko kawam mu dagulok ale parasarukko. ");
INSERT INTO wsk_vpl VALUES ("PR14_12","021_14_12","PRO","14","12","12","Kariimet sang ikisan nuna munan lage karo tusan mu diram la ma balsan. Bare mena. Nuna karosan nama eng memek arigisan ale kua namasan. ");
INSERT INTO wsk_vpl VALUES ("PR14_13","021_14_13","PRO","14","13","13","Gusira amilmil ko munan am betenakko, bare naneman bataga ko munan mu tom sang am aniso; se amilmil gusira niara mu menaruk, bare mu nangamang bataga mu aking am nangate anirukko. ");
INSERT INTO wsk_vpl VALUES ("PR14_14","021_14_14","PRO","14","14","14","Kariimet memek mu nunga betera kaora memek mu ko nunguning la tamonko; se kariimet ningo mu betelatala, nunga betera kaora ningo mu la ko nunguning tamonko. ");
INSERT INTO wsk_vpl VALUES ("PR14_15","021_14_15","PRO","14","15","15","Kariimet nunga ikia ninguru me sinarara alo mu, anapeya balu mu am iki karo tumonko; bare kariimet ikia ago, mu nuna nunga bagara aolak ko ninguru sinar tasan. ");
INSERT INTO wsk_vpl VALUES ("PR14_16","021_14_16","PRO","14","16","16","Kariimet ikia sinar ago, mu nuna munan memek ko ninguru nguangasan ale nubiring tusan; bare kariimet ikia sinar mena, mu nuna anapeya betemonko mu ninguru me ko ikia tasan, mu am tairatela betesan. ");
INSERT INTO wsk_vpl VALUES ("PR14_17","021_14_17","PRO","14","17","17","Kariimet nunga nongomang magara tairate, mu ngualara ko kilek memek tairatela betesan; se aking kariimet saki nunga kawel mu yumura te la, bare kariimet nunga iki gilingisan mu me nunga kua gilingisan. ");
INSERT INTO wsk_vpl VALUES ("PR14_18","021_14_18","PRO","14","18","18","Kariimet nunga ikia tukunangta, mu nunga kilek ngualara mu ko koma diram tasan; bare kariimet ikia ningo nuam ago, mu ko koma nuna ikia ningo nuam biya tala tasan. ");
INSERT INTO wsk_vpl VALUES ("PR14_19","021_14_19","PRO","14","19","19","Kariimet kilek memek bita lagasan mu maingte kariimet munan diram betesan mu nunga nobowa ningi karangamon taimon ale nubugura kulukurmonko. ");
INSERT INTO wsk_vpl VALUES ("PR14_20","021_14_20","PRO","14","20","20","Kariimet nunup mena, nungumik mel mena, mu kariimet sang nungarkasan mu me nunga ikia iwita nungarki patesan; nunga singsang nunguning tala wore am uwutata nungumik te betesan. Bare kariimet nunup ago, nungumik mel suen biya ago, mu kariimet suen la nunga sikisaki ko iwita nunga balsan ale nunga kuesan! ");
INSERT INTO wsk_vpl VALUES ("PR14_21","021_14_21","PRO","14","21","21","Awiriya ko bo mel yam ko beteso, mu nu memek beteso; bare awiriya kariimet ikup ago mu nunga sangarso, mu amilmilarukko. ");
INSERT INTO wsk_vpl VALUES ("PR14_22","021_14_22","PRO","14","22","22","Ni kilek memek bitarko ikia to lager, mu ni lage ningo supurem ale lage memek karosam; bare ni pempem kilek ningo bitarko ikia to lager, mu kariimet nongomang kisimon ale tom suen biya te kerak bagamonko. ");
INSERT INTO wsk_vpl VALUES ("PR14_23","021_14_23","PRO","14","23","23","Ni ura kowar ilup, mu ni ko koma yawara toko; bare ni yam dagi munaka lager, mu ni kimik mel mena bagerko. ");
INSERT INTO wsk_vpl VALUES ("PR14_24","021_14_24","PRO","14","24","24","Kariimet ikia nunguning nongote ago, mu koma mel yawara yawara gisan; bare kariimet ikia nunguning nongote mena, mu nunga ngualara kilek mu eng am butata aniso. ");
INSERT INTO wsk_vpl VALUES ("PR14_25","021_14_25","PRO","14","25","25","Kari den ariga te den nunguning la balso, mu kari sangarso; bare kari den kawel balso mu saki alo memek te nunga beteso. ");
INSERT INTO wsk_vpl VALUES ("PR14_26","021_14_26","PRO","14","26","26","Awiriya Yawe bowa ningi bagoso mu terong la lagoso; se mu noko kuriang nunga yumura kuwim tala. ");
INSERT INTO wsk_vpl VALUES ("PR14_27","021_14_27","PRO","14","27","27","Yawe bowa ningi bagara mu kari ko bagara aolak sangarso, ale kari kua namara ko lage te mu sangaru taso. ");
INSERT INTO wsk_vpl VALUES ("PR14_28","021_14_28","PRO","14","28","28","King ko kariimet biya te nup biya taso; bare kariimet mena, mu king nup mena tala. ");
INSERT INTO wsk_vpl VALUES ("PR14_29","021_14_29","PRO","14","29","29","Awiriya ikia ningo karogo mu numi ira ko kari; bare kari gomang motam tama ko kaniwara mu ngualara munan beteso. ");
INSERT INTO wsk_vpl VALUES ("PR14_30","021_14_30","PRO","14","30","30","Nangamang motam lila te bagara mu nangimik lilim sokel tuso; bare nangamang magara mu nangimik lilim maguwuso. ");
INSERT INTO wsk_vpl VALUES ("PR14_31","021_14_31","PRO","14","31","31","Awiriya kituwura alo nunga bita maguwuso mu Awiriya nunga nungam mu mel yam ko beteso; bare awiriya kariimet mel mena mu nunga sangarso, mu nu Kaem nup biya tuso. ");
INSERT INTO wsk_vpl VALUES ("PR14_32","021_14_32","PRO","14","32","32","Tom ikup memek arataso, mu memek betera ko kariimet umu maga namasan; bare kariimet ningo diram mu kuemon agi ta wore, nunga kuwim yumura karogo. ");
INSERT INTO wsk_vpl VALUES ("PR14_33","021_14_33","PRO","14","33","33","Ikia sinar ko kari mu gomang motam ningi Ikia Sinar ago; se Ikia Sinar mu kariimet ngualara nunga ningi munakawoso tala. ");
INSERT INTO wsk_vpl VALUES ("PR14_34","021_14_34","PRO","14","34","34","Munan ningo diram mu sor sokel se nup biya tuso; bare munan memek mu sor lilim ko kariimet nup memek nungarso. ");
INSERT INTO wsk_vpl VALUES ("PR14_35","021_14_35","PRO","14","35","35","Ura kari ikia sinar ago mu king amilmil tuso; bare ura kari ngualara mu dolara king tuso se gomang magara mu kumik te beteso. ");
INSERT INTO wsk_vpl VALUES ("PR15_1","021_15_1","PRO","15","1","1","Bo gomang memek te munakawara se lila welang te koma balu tua mu, noko tama iruwuso; bare alis ago den koma balu tua umu, tama bo karogo kasi gomang motam ningi bita kam. ");
INSERT INTO wsk_vpl VALUES ("PR15_2","021_15_2","PRO","15","2","2","Ikia sinar kari munakoso, mu ikia ningo ningo kuring te arataso; bare supuling lagara ko kari munakoso, mu bala memek duap duap kuring te arataso. ");
INSERT INTO wsk_vpl VALUES ("PR15_3","021_15_3","PRO","15","3","3","Yawe sor suen la ari kutuwuwoso, kariimet memek se kariimet ningo aguwaya betesan mu am ari sapawoso. ");
INSERT INTO wsk_vpl VALUES ("PR15_4","021_15_4","PRO","15","4","4","Den welang lila ago mu kariimet ninguru nunga sangarso; bare kari kuamili kuring den memek ago, mu kariimet nongomang motam parusuwuso. ");
INSERT INTO wsk_vpl VALUES ("PR15_5","021_15_5","PRO","15","5","5","Kuriang supuling aora biya mu, nuet due iluwa ko den manarso mu tuer pateso ale buring tuso; bare kuriang iki karo tuso, mu nu kuriang sinar. ");
INSERT INTO wsk_vpl VALUES ("PR15_6","021_15_6","PRO","15","6","6","Kariimet ningo diram nunga kawam te, mu mel yawara yawara suen biya aniso; bare kariimet munan kawel te meltutuk gisan, mu meltutuk mu ikup ningi nunga awurokko. ");
INSERT INTO wsk_vpl VALUES ("PR15_7","021_15_7","PRO","15","7","7","Kariimet ikia sinar ago mu, ikia ningo ningo kariimet saki nunga kasursan; bare nusupuling lagara alo mu uwuta me betesan. ");
INSERT INTO wsk_vpl VALUES ("PR15_8","021_15_8","PRO","15","8","8","Yawe kariimet memek nunga tama betera mu biriruwuso; bare nu kariimet ningo nunga guranek mu ko amilmiloso. ");
INSERT INTO wsk_vpl VALUES ("PR15_9","021_15_9","PRO","15","9","9","Yawe kariimet memek mu nunga bagara aolak biriruwuso; bare nu kariimet munan ningo diram karo tui lagasan mu nunga kueso. ");
INSERT INTO wsk_vpl VALUES ("PR15_10","021_15_10","PRO","15","10","10","Awiriya lage ningo buring tuso, mu ikup yaman arigiso; awiriya ko memek kasursan mu ko gomang ikuwoso, mu kuerukko. ");
INSERT INTO wsk_vpl VALUES ("PR15_11","021_15_11","PRO","15","11","11","Kariimet kuera nunga nuguwim mu wetang te Yawe koma te aniso; ewere te se, kari gomang motam mu, awuk Yawe motam te yumurokko? ");
INSERT INTO wsk_vpl VALUES ("PR15_12","021_15_12","PRO","15","12","12","Ikia sinar doleng sapara ko kari mu ko memek kasuru, mu gomang magarukko; nu kariimet sinar mu nunga dulokko. ");
INSERT INTO wsk_vpl VALUES ("PR15_13","021_15_13","PRO","15","13","13","Kari gomang ningi amilmil ago, mu ko koma motam amilmil ago; bare kari gomang motam ikup yaman ago, mu kumik sokel kapa saposo. ");
INSERT INTO wsk_vpl VALUES ("PR15_14","021_15_14","PRO","15","14","14","Kari sinar mu ikia ningo ko ninguru kua lagoso; bare supuling lagara ko kari mu munan memek mu na ko kuakoyam ko kua lagoso. ");
INSERT INTO wsk_vpl VALUES ("PR15_15","021_15_15","PRO","15","15","15","Awiriya ikup yaman memek ningi lagoso, mu ikup biya se maga kuena lagoso; bare awiriya gomang motam amilmil karogo, mu amilmil te no nungia se lagoso. ");
INSERT INTO wsk_vpl VALUES ("PR15_16","021_15_16","PRO","15","16","16","Mel katirta ago baga se Yawe bowa ningi la baga lagara ko munan mu, kari kumik mel suen biya karogo se gomang motam daung daung lagara ko munan kiaram. ");
INSERT INTO wsk_vpl VALUES ("PR15_17","021_15_17","PRO","15","17","17","Na inang mamis memek nimi tui no se nimi ko kua se lagara mu, munan yawara nunguning; bare bulmakau gotek moa kaiya ale inang yawara karogo no se, nimi kore bataguru se nimi ko me kuera mu, munan memek nunguningkiri. ");
INSERT INTO wsk_vpl VALUES ("PR15_18","021_15_18","PRO","15","18","18","Kari ko gomang motam magara tairate, mu ining singi tagi kariimet ningi beteso; bare kari gomang motam lila ago, mu daiga bagara nungurso burangoso. ");
INSERT INTO wsk_vpl VALUES ("PR15_19","021_15_19","PRO","15","19","19","Kari gagor ko lage mu mayang singir ereso; bare kari ningo ko lage mu wetang biya. ");
INSERT INTO wsk_vpl VALUES ("PR15_20","021_15_20","PRO","15","20","20","Kuriang ikia sinar ago mu, nuet gomang motam amilmil tuso; bare kuriang ikia aora biya, mu ko nuam mel yam ko beteso. ");
INSERT INTO wsk_vpl VALUES ("PR15_21","021_15_21","PRO","15","21","21","Kari ikia ningo mena, mu munan memek ko amilmiloso; bare kari ikia sinar ago, mu diram la aolak iluso. ");
INSERT INTO wsk_vpl VALUES ("PR15_22","021_15_22","PRO","15","22","22","Saki alo nunga den sinar yawara biring tua, mu ka ura bitar mu nama dagulokko; bare nunga den sinar te sanamir, mu ka ura nunguning kaparukko. ");
INSERT INTO wsk_vpl VALUES ("PR15_23","021_15_23","PRO","15","23","23","Den ninguru ko iki gurugu laga koma bala, mu amilmil kisokko; ale tom te bala ko mu te iki guruguwa te diram bala, mu ningo nunguningkiri! ");
INSERT INTO wsk_vpl VALUES ("PR15_24","021_15_24","PRO","15","24","24","Kari ikia sinar ago mu, bagara aolak diram ko lage karoso ale ningo nuam ningi nama tarigiso, ale mutim ningi dagulu namara ko lage memek mu kia kaposo. ");
INSERT INTO wsk_vpl VALUES ("PR15_25","021_15_25","PRO","15","25","25","Yawe kari numi patawura ago mu, ko kawam digo mu parusuwu warso; bare nu imet gerewa ko por, mu sokel tuso. ");
INSERT INTO wsk_vpl VALUES ("PR15_26","021_15_26","PRO","15","26","26","Yawe kariimet memek alo nunga ikia memek biriruwuso nunguningkiri; bare munak welang lila ago mu nu ko amilmiloso. ");
INSERT INTO wsk_vpl VALUES ("PR15_27","021_15_27","PRO","15","27","27","Kari guing talal mu nuwus kuriang ikup ningi nunga beteso; bare kari memek bitirukko dia gilingisan bare biriruwuso, mu ningo la bagarukko. ");
INSERT INTO wsk_vpl VALUES ("PR15_28","021_15_28","PRO","15","28","28","Kariimet ningo diram mu, den koma aguwaya balmonko mu, ninguru ko iki gurugu se balsan; bare kariimet memek mu, den memek se bala memek nuguring te aratu lagoso. ");
INSERT INTO wsk_vpl VALUES ("PR15_29","021_15_29","PRO","15","29","29","Yawe kariimet memek alo mu nunga nuguring me ta ikiso; bare nu kariimet ningo diram alo nunga guranek ikiso ale nuguring iluso. ");
INSERT INTO wsk_vpl VALUES ("PR15_30","021_15_30","PRO","15","30","30","Den gilalong gia ko kari koma motam gusira amilmil ago kete tairuk, mu gemang motam amilmil tuokko; ale den ningo mu degewa kaura mu, kimik sokel ko ikes menawu kam. ");
INSERT INTO wsk_vpl VALUES ("PR15_31","021_15_31","PRO","15","31","31","Ni kari saki ka bagara aolak ningo la te pempem lagerko de ilumon se ko amilmiler, mu ni kari ikia sinar bo ko iwita lagerko. ");
INSERT INTO wsk_vpl VALUES ("PR15_32","021_15_32","PRO","15","32","32","Awiriya dogowa ta ko den buring tuso, mu kota numi mel yam ko beteso; bare awiriya iki karo tuso, mu ikia nunguning taso. ");
INSERT INTO wsk_vpl VALUES ("PR15_33","021_15_33","PRO","15","33","33","Ikia sinar ko den mu Yawe bowa ningi la bagara ko munan nanga kasurso; ale nanimi karogo kapara ko munan giriso, asele nanga tagi patawu kualala nanga betera ko munan mu kowom karoso. ");
INSERT INTO wsk_vpl VALUES ("PR16_1","021_16_1","PRO","16","1","1","Ana anapeya betenakko nanga ikia kalonak, bare Yawe aing au mauk mu asele uwutata aratukko. ");
INSERT INTO wsk_vpl VALUES ("PR16_2","021_16_2","PRO","16","2","2","Kari ko munan suen la beteso mu nu ningo la iwita ikiso; bare Yawe munan umu ko ikia yumura mu am iki saposo. ");
INSERT INTO wsk_vpl VALUES ("PR16_3","021_16_3","PRO","16","3","3","Ni anapeya bitarko mu, Yawe kuting te la awu sapar se nu ka sanguk se yawarakala aratukko. ");
INSERT INTO wsk_vpl VALUES ("PR16_4","021_16_4","PRO","16","4","4","Yawe ikia mel suen la ariwoso se nama nukum te arataso; kariimet memek alo nunga tom nukum te memek tamonko mu agotala ariwoso. ");
INSERT INTO wsk_vpl VALUES ("PR16_5","021_16_5","PRO","16","5","5","Yawe nunumi patawura ko kariimet alo mu nunga biriruwuso nunguningkiri. Ninguru ikialko: nuna nunga memek koma tamonko. ");
INSERT INTO wsk_vpl VALUES ("PR16_6","021_16_6","PRO","16","6","6","Ana Yawe ko ninguru kua se pempem den diram la karo tui se laganak, mu nanga memek siwu nangarukko; ana Yawe bowa ningi baganak, mu ana munan memek mu kia kapanakko. ");
INSERT INTO wsk_vpl VALUES ("PR16_7","021_16_7","PRO","16","7","7","Yawe nika bagara aolak ko amilmilaruk, mu awiriya ni kerak dun kopa iluwasan mu karogo la kerak lila te bagamonko. ");
INSERT INTO wsk_vpl VALUES ("PR16_8","021_16_8","PRO","16","8","8","Manga mel suen biya ago baga se, kiwem memek betera mu me terong; bare manga mel katirta karogo baga se, munan ningo diram la karo tua umutang mel biya. ");
INSERT INTO wsk_vpl VALUES ("PR16_9","021_16_9","PRO","16","9","9","Kari ko bagara aolak te anapeya bitirukko agi aguwaya bitirukko, ale amaruya bitirukko mu ko ikia nungurso, bare Yawe aing au mauk mu asele uwutata aratukko. ");
INSERT INTO wsk_vpl VALUES ("PR16_10","021_16_10","PRO","16","10","10","King den balso mu sokel ago se aora biya; owore te se nu sinar la se diram la kariimet nunga bituokko. ");
INSERT INTO wsk_vpl VALUES ("PR16_11","021_16_11","PRO","16","11","11","Mel ko ikup guyak se ko maiya tukunang am diram la tata ko munan mu Yawe ko munan; nu munan diram la beteso. ");
INSERT INTO wsk_vpl VALUES ("PR16_12","021_16_12","PRO","16","12","12","King alo munan memek mu am me ko kuesan nunguningkiri, mu awuk, king ko ura mu munan ningo diram te sokel ago la aniso. ");
INSERT INTO wsk_vpl VALUES ("PR16_13","021_16_13","PRO","16","13","13","King alo kariimet den diram se den nunguning la balsan mu nunga amilmilasan. ");
INSERT INTO wsk_vpl VALUES ("PR16_14","021_16_14","PRO","16","14","14","King gomang magaruk mu, kuera mateng am aratukko tala; buta se ikia sinar kari mu tairate king gomang motam lila tuokko karogo kaerukko. ");
INSERT INTO wsk_vpl VALUES ("PR16_15","021_16_15","PRO","16","15","15","Tom king ko koma motam gusira amilmil ago arik, mu bagara ningo ko tom iwita ikiko; noko gomang amilmil mu worem aora biya ningi yu bugulik ka kautokoyam. ");
INSERT INTO wsk_vpl VALUES ("PR16_16","021_16_16","PRO","16","16","16","Ni ikia sinar toko mu yawarakala, mu gold kiaram; uwutatala, ni ikia ningo tuterko mu yawarakala, mu silver kiaram! ");
INSERT INTO wsk_vpl VALUES ("PR16_17","021_16_17","PRO","16","17","17","Kariimet diram nunga lage biya mu munan memek me te aniso; awiriya ko munan ko sinar taso, mu yawarakala bagarukko. ");
INSERT INTO wsk_vpl VALUES ("PR16_18","021_16_18","PRO","16","18","18","Nanimi patawura ko munan buring ko mu, magara kuenera ko munan taiso; kualala namara ko munan buring ko mu, dagulu parasa namara ko munan taiso. ");
INSERT INTO wsk_vpl VALUES ("PR16_19","021_16_19","PRO","16","19","19","Kua kapara ale kariimet kituwura nongorak bagara ko munan mu, munan yawara; bare nunumi patawura alo nunga sail te kariimet saki nunga melmasak gia mu nongorak nimi tui nana ko munan mu memek. ");
INSERT INTO wsk_vpl VALUES ("PR16_20","021_16_20","PRO","16","20","20","Awiriya kiti guruga ko den iki karo tuso, mu daiga bagara yawara arigiso; uwutatala, awiriya Yawe te ira sanami lagoso, mu amilmilarukko. ");
INSERT INTO wsk_vpl VALUES ("PR16_21","021_16_21","PRO","16","21","21","Kari ikia sinar ago, mu balsan sinar kari masan; se den welang ningo mu kausa ningo sokel tuso, se kariimet karo tusan. ");
INSERT INTO wsk_vpl VALUES ("PR16_22","021_16_22","PRO","16","22","22","Awiriya ikia sinar ago, mu ko ikia sinar mu marak ningo ko yu iwita nu sangaru lagoso; bare nusupuling lagara alo mu nunga munan memek mu te, memek tagi nongota nungumik te betesan. ");
INSERT INTO wsk_vpl VALUES ("PR16_23","021_16_23","PRO","16","23","23","Kari ikia sinar ago mu, kuring te ikia sinar ko den arataso; se kariimet ko den ikimon ale karo tumonko kuesan. ");
INSERT INTO wsk_vpl VALUES ("PR16_24","021_16_24","PRO","16","24","24","Den welang ningo mu honey iwita, kamili te yaman nuam, se kimik lilim sokel tuokko. ");
INSERT INTO wsk_vpl VALUES ("PR16_25","021_16_25","PRO","16","25","25","Kari bo ikiso lage nu karowoso mu diram iwita ikiso; bare karo nama nukum te mu, kuera mateng arigiso. ");
INSERT INTO wsk_vpl VALUES ("PR16_26","021_16_26","PRO","16","26","26","Inang ko kuera ko munan mu kari ura te diruwuso; noko na ko kuera eng am bo karogo ura te diruwuso. ");
INSERT INTO wsk_vpl VALUES ("PR16_27","021_16_27","PRO","16","27","27","Kari memek mu munan memek bitirukko ikia nungurso burangoso; noko munak mu tama kuamili buluwuluk makam. ");
INSERT INTO wsk_vpl VALUES ("PR16_28","021_16_28","PRO","16","28","28","Kari memek kawel kuruwim mu ikup duap duap tagiso; bo buring ko bala mu, tiran ningo nunga parusuwuso. ");
INSERT INTO wsk_vpl VALUES ("PR16_29","021_16_29","PRO","16","29","29","Daong kager ko kari mu ko bo gomang kulukurso ale ilak kager daong memek ko lage te namoso. ");
INSERT INTO wsk_vpl VALUES ("PR16_30","021_16_30","PRO","16","30","30","Kari bo sumulak dun pateso ale motam daleloso, mu ikia memek karogo. ");
INSERT INTO wsk_vpl VALUES ("PR16_31","021_16_31","PRO","16","31","31","Ningo diram la laga nomone yak maso, mu mel yawara bo balayam nusupuling tugu kam. ");
INSERT INTO wsk_vpl VALUES ("PR16_32","021_16_32","PRO","16","32","32","Kager kari tamatama mu ko sokel mu te wonong bo am moa mituwurokko; bare numi ira ko kari mu ko bagara ko sinar taso, mu nu kager kari mu kiaram. ");
INSERT INTO wsk_vpl VALUES ("PR16_33","021_16_33","PRO","16","33","33","Ana anapeya duap duap betenakko ikia am kalonakko, bare Yawe anapeya aratukko agi mena mu nu balso se arataso. ");
INSERT INTO wsk_vpl VALUES ("PR17_1","021_17_1","PRO","17","1","1","Inang gotek bo nirung mena, lila te to nana, mu yawarakala; bare inang ningo kawam digo karogo terong ma se no nguala se, nanimi ining singi tua mu awuk nanga sangukko? ");
INSERT INTO wsk_vpl VALUES ("PR17_2","021_17_2","PRO","17","2","2","Kari bo ko namar dolara munan nuet kote bita lagoso, mu nuet baluk se ura kari yam bo, ikia sinar ago, mu noko kuwim am taukko tala; ale ko namar bo iwita mel kasik biya karogo terong la bagarukko. ");
INSERT INTO wsk_vpl VALUES ("PR17_3","021_17_3","PRO","17","3","3","Gold se silver nunguning agi buawen mu ko ikia ko mu, tama kowar biya wore ningi kaisan ale asele ko ikisan; bare kari ko gomang motam mu Yawe kota gurugu patawu ko ikiso. ");
INSERT INTO wsk_vpl VALUES ("PR17_4","021_17_4","PRO","17","4","4","Kari memek mu ikia memek ikiokko ninguru due tagiso; uwutatala, kawel kari mu den kawel ikiokko ninguru kueso. ");
INSERT INTO wsk_vpl VALUES ("PR17_5","021_17_5","PRO","17","5","5","Awiriya kariimet kituwura nunga doleng saposo, mu nu Awiriya nunga nungam mu agotala ko doleng saposo; uwutatala, awiriya kariimet sang ikup arigisan se nu ko amilmiloso, mu nu me yumu namarukko. ");
INSERT INTO wsk_vpl VALUES ("PR17_6","021_17_6","PRO","17","6","6","Kariimet garuk mu nunga nunumasari te nunup biya kaposo; iwitatala, kuriang alo mu nunam nonet mu nunup biya nungarsan. ");
INSERT INTO wsk_vpl VALUES ("PR17_7","021_17_7","PRO","17","7","7","Ikia sinar ko den mu numi patawura ko kari kuring te me arataso, mena; bare tom bo te aratuk agi mu, ni ninguru ko sinar toko! Uwutatala, kari supuling kuring te den kawel mu me arataso, mena; bare tom bo te aratuk agi mu, ni ninguru ko sinar toko! ");
INSERT INTO wsk_vpl VALUES ("PR17_8","021_17_8","PRO","17","8","8","Manga mel kari tua ale diruwura se mel ningo tere gi karogo tai kisa ko munan mu, kari sika nunga mel ningo, te to no laga gilingisan. ");
INSERT INTO wsk_vpl VALUES ("PR17_9","021_17_9","PRO","17","9","9","Awiriya bo ko memek siwu saposo, mu nu nanimi ko kuera ko munan sokel tuso; bare awiriya bo ko memek umu balu balu geragoso, mu nu tiran ningo nunga parusuwuso. ");
INSERT INTO wsk_vpl VALUES ("PR17_10","021_17_10","PRO","17","10","10","Kari ikia ningo ago mu ko memek tom suanta ko manaru, mu nu pasak ala ari ko ikiokko; bare kari supuling lagara karogo mu tom 100 iwita moa maguwur, bare am me ta ikiokko! ");
INSERT INTO wsk_vpl VALUES ("PR17_11","021_17_11","PRO","17","11","11","Kari memek mu supuling lagara se dun kopa iluwa ko kiwem mu ko kua lagoso; bare kari bo wuli karogo mu betemon se namaruk ale ikup yaman tuokko. ");
INSERT INTO wsk_vpl VALUES ("PR17_12","021_17_12","PRO","17","12","12","Bear nuam ko gotek tere namon se gomang magawuruk mu koma te aratuko mu, sinar toko; bare kari ko ikia munan memek nunguningkiri mu memek bitawuruk se koma te aratuko mu, eng am ninguru ko sinar toko! Umu asele memek ko memek arikko! ");
INSERT INTO wsk_vpl VALUES ("PR17_13","021_17_13","PRO","17","13","13","Awiriya munan ningo mu ko koma munan memek bitiruk, mu memek mu ko kawam digo lilim me ta bita taukko. ");
INSERT INTO wsk_vpl VALUES ("PR17_14","021_17_14","PRO","17","14","14","Kari bo ilak tagira gurungumura ko munan me duap bitarko: duap betera mu kausik daong ko mayang kutuwu kam; se ka gemang memek mu am ira se kaparuk se memek biya bo me aratukko. ");
INSERT INTO wsk_vpl VALUES ("PR17_15","021_17_15","PRO","17","15","15","Kari kumik den mena, yam ipi ikup te betera ko munan, se kari ikup karogo, bare am betera se amilmil te namara ko munan, mu ilagala la Yawe am biriruwuso nunguningkiri. ");
INSERT INTO wsk_vpl VALUES ("PR17_16","021_17_16","PRO","17","16","16","Anape ko kari supulingkiri mena mu ikia ningo te diarukko manga kuting te bitarko? Mu me terong, mu awuk, nu ikia sinar taukko gomang me aniso. ");
INSERT INTO wsk_vpl VALUES ("PR17_17","021_17_17","PRO","17","17","17","Tiran yawara mu pempem ka kua lagarukko; se ka launuria mu ka ikup dun sika giokko bagoso. ");
INSERT INTO wsk_vpl VALUES ("PR17_18","021_17_18","PRO","17","18","18","Ni ikia sinar mena wore asele, kari bo, bo kote dinau bitiruk mu ni sangaru ale kutuwurko baluko. ");
INSERT INTO wsk_vpl VALUES ("PR17_19","021_17_19","PRO","17","19","19","Awiriya ining singi tagira gurungumura bitirukko kua lagoso, koma suanta nu memek tagi kumik te bitirukko kua lagoso; supuling lagara se nimi patawura ko munan mu, memek tagirok se tairuk ka maguwurokko. ");
INSERT INTO wsk_vpl VALUES ("PR17_20","021_17_20","PRO","17","20","20","Kari gomang motam daeldel pukakung mu, munan mu te molak me maiso; awiriya kuamili kawel munan karogo mu ikup ningi daguloso. ");
INSERT INTO wsk_vpl VALUES ("PR17_21","021_17_21","PRO","17","21","21","Kuriang supulingkiri aora biya mu nuet gomang motam batagarso, se amilmil bo kote mena se gomang ikup biya. ");
INSERT INTO wsk_vpl VALUES ("PR17_22","021_17_22","PRO","17","22","22","Nangamang motam amilmil ago bagara mu marasin ningo iwita; bare nangamang ikup ago bagara mu nangimik sokel karogo kaposo. ");
INSERT INTO wsk_vpl VALUES ("PR17_23","021_17_23","PRO","17","23","23","Manga yumura la kariimet kuting te tata ko munan te, mel bo diram la me arataso. ");
INSERT INTO wsk_vpl VALUES ("PR17_24","021_17_24","PRO","17","24","24","Kari sinar mu ikia sinar moke sengem ko beteso; bare kari ikia mena, mu ngual kasik beteso. ");
INSERT INTO wsk_vpl VALUES ("PR17_25","021_17_25","PRO","17","25","25","Kuriang bo ikia memek karo tui lagoso, mu noko nuamnuet nongomang ikup biya lagasan. ");
INSERT INTO wsk_vpl VALUES ("PR17_26","021_17_26","PRO","17","26","26","Kari kumik den mena mu, memek yam ipi kumik te betera mu memek; se kari ningo bo, ko munan ningo ko yam ipi memek te betera mu me terong tala. ");
INSERT INTO wsk_vpl VALUES ("PR17_27","021_17_27","PRO","17","27","27","Kari ikia ningo ago, mu munak ko iki iki munakoso; se kari sinar nunguningkiri mu gomang magara me ikiso. ");
INSERT INTO wsk_vpl VALUES ("PR17_28","021_17_28","PRO","17","28","28","Kari ikia mena mu tom saki kuring kalok ale baga lagaruk, se ni iki mu ikia sinar ko kari bo bagoso i meko! ");
INSERT INTO wsk_vpl VALUES ("PR18_1","021_18_1","PRO","18","1","1","Kari bo kota ko bagara te baga se saki alo arungu me ilu biguwuso, mu nu kota ko ningo mu mel biya ko beteso, ale nu ikia ningo suen la mu mel yam ko beteso. ");
INSERT INTO wsk_vpl VALUES ("PR18_2","021_18_2","PRO","18","2","2","Kari ngualara mu mel ko duap ikiokko me kueso, mena; nu kota ko ikia la balukko kueso. ");
INSERT INTO wsk_vpl VALUES ("PR18_3","021_18_3","PRO","18","3","3","Memek betera ko kari mu bala memek ko lage kuring kagarso; dolara ko munan mu dolara kisokko. ");
INSERT INTO wsk_vpl VALUES ("PR18_4","021_18_4","PRO","18","4","4","Ikia sinar ko den kari kuring te arataso mu gagi du biya wore turan, ale aking yu bulowolok ma ale palenga kapawara wore toroman. ");
INSERT INTO wsk_vpl VALUES ("PR18_5","021_18_5","PRO","18","5","5","Kilek memek bitawara ko kari nunga atumu saonga, ale kari kumik den mena mu ipi den te betera se ikup memek ipi ta, mu kilek memek nunguningkiri. ");
INSERT INTO wsk_vpl VALUES ("PR18_6","021_18_6","PRO","18","6","6","Kari sinar mena mu kota ko munak ngualara munakoso umu ikup yaman tagi kumik te beteso. ");
INSERT INTO wsk_vpl VALUES ("PR18_7","021_18_7","PRO","18","7","7","Kari ngualara mu kota ko munak te numi maguwuso; se ko den mu dagarok iwita taliposo. ");
INSERT INTO wsk_vpl VALUES ("PR18_8","021_18_8","PRO","18","8","8","Kari buring ko bala ko den mu inang yaman yaman iwita; se kariimet amilmil te nasan se nutagu ningi kaposo. ");
INSERT INTO wsk_vpl VALUES ("PR18_9","021_18_9","PRO","18","9","9","Kari kua ani ani lagara mu melmasak maguwura ko kari iwitatala. ");
INSERT INTO wsk_vpl VALUES ("PR18_10","021_18_10","PRO","18","10","10","Yawe mu kawam aora bo kalel biya sanamiwoso wore toroman; se kariimet ningo diram mu te nagu nama yumusan. ");
INSERT INTO wsk_vpl VALUES ("PR18_11","021_18_11","PRO","18","11","11","Kariimet nungumik manga mel suen biya ago mu, nunga melmasak umu kar aora bo nunga lautam nongorak bagoso iwita ikisan. ");
INSERT INTO wsk_vpl VALUES ("PR18_12","021_18_12","PRO","18","12","12","Kari bo me dagula la, mu nu numi patawura ko kari; bare nanimi karogo kapara ko munan mu te nup ningo tasan. ");
INSERT INTO wsk_vpl VALUES ("PR18_13","021_18_13","PRO","18","13","13","Den ninguru me ikia ale tairate koma bala mu memek se dolara karogo. ");
INSERT INTO wsk_vpl VALUES ("PR18_14","021_18_14","PRO","18","14","14","Kuera ikes memek ningi baga se wore ka gemang motam sokel karogo la bager, mu am baga lagerko; bare gemang motam sokel menaruk, mu tom maiya biya me bagerko. ");
INSERT INTO wsk_vpl VALUES ("PR18_15","021_18_15","PRO","18","15","15","Ikia sinar kari mu guyak la ikia ningo taso, ale bo karogo ikiokko due gurugu lagoso. ");
INSERT INTO wsk_vpl VALUES ("PR18_16","021_18_16","PRO","18","16","16","Kariimet mel tua ko mel mu, nika lage kuring am kaguk se kari nup biya ta wore am kote nama aratuko. ");
INSERT INTO wsk_vpl VALUES ("PR18_17","021_18_17","PRO","18","17","17","Den ariga tom te, kari giriso munakoso mu ni ko den ko gemang ningi am nunguning arukko tala; bare aking kari bo tala aratuk ale isaru gurungumurok, mu te ni kamin biya gotek yenerukko. ");
INSERT INTO wsk_vpl VALUES ("PR18_18","021_18_18","PRO","18","18","18","Tom kari ilagala munak te nunumi ilumon nama gek mamon, mu munan sang te awiriya nunguning se awiriya kawel mu te ikiko mu bitar ale Yawe kuting te bitarko. ");
INSERT INTO wsk_vpl VALUES ("PR18_19","021_18_19","PRO","18","19","19","Tiran yawara bo bita maguwura ale aking gomang ta ko karogo kaera mu mel ikup; mu songkuring ain te nunga, agi por aora bo ninga kusumuri anira iwita. ");
INSERT INTO wsk_vpl VALUES ("PR18_20","021_18_20","PRO","18","20","20","Munak aguwaya kiring te arataso mu ko koma uwutatala peleruk se no ale tagu lagarukko; se ka kiring ko koma mu eng am diram la toko. ");
INSERT INTO wsk_vpl VALUES ("PR18_21","021_18_21","PRO","18","21","21","Marak bagara ko den se kuera ko den mu nangamili kopa te aniso; se ni aguwaya mu ko kuar ale balu mu ko koma uwutata toko. ");
INSERT INTO wsk_vpl VALUES ("PR18_22","021_18_22","PRO","18","22","22","Kari imet bo, ko nuwus ko taso, mu mel yawara bo arigam, se Yawe ko amilmiloso. ");
INSERT INTO wsk_vpl VALUES ("PR18_23","021_18_23","PRO","18","23","23","Kari kituwura mu numi karogo kapa se saonga ko wosenga kira lagarukko; bare kari kumik mel suen biya ago mu den koma sail ago am balukko. ");
INSERT INTO wsk_vpl VALUES ("PR18_24","021_18_24","PRO","18","24","24","Kari bo kari duap duap nongorak numi giso, mu memek ningi am dagulokko; bare noko ilup se isirek mu noko launuria nunga kiaram ale am noko yawara nunguningkiri. ");
INSERT INTO wsk_vpl VALUES ("PR19_1","021_19_1","PRO","19","1","1","Kari kimik mel mena ko baga se kimik te den mena bager mu yawarakala; bare kimik mel suen biya ago baga se kawela lager mu memek. ");
INSERT INTO wsk_vpl VALUES ("PR19_2","021_19_2","PRO","19","2","2","Nimi ira mena, gemang gemang ura ni me ninguru ko ikia mu kau tata, ale ko nunguning ura umu maguwura, mu me terong. ");
INSERT INTO wsk_vpl VALUES ("PR19_3","021_19_3","PRO","19","3","3","Kari kota ko munan memek te ko bagara aolak ikup tuso, ale ipi ko Yawe ko gomang magoso. ");
INSERT INTO wsk_vpl VALUES ("PR19_4","021_19_4","PRO","19","4","4","Mel ningo ningo karogo bager, mu daup ka tugumokko; bare kari kituwura mu ari mia gilingisan. ");
INSERT INTO wsk_vpl VALUES ("PR19_5","021_19_5","PRO","19","5","5","Den kawel te bo atumu saonga mu ko memek toko; den kawel kiring te arata mu betela ko ikup arikko. ");
INSERT INTO wsk_vpl VALUES ("PR19_6","021_19_6","PRO","19","6","6","Kariimet suen biya mu, kariimet bibiya nungumik mel karogo se nunga mel ningo saki, saki alo nungarsan owore, nongorak tiran betemonko kua gilingisan. ");
INSERT INTO wsk_vpl VALUES ("PR19_7","021_19_7","PRO","19","7","7","Kari kituwura mu kota ko kotamari ari mia gilingisan; se ko tiran alo eng am kumik duap te mena, awar biya bagasan. Nu nuna sangarmonko nogowom karoso bare nuna nu me sangorsan. ");
INSERT INTO wsk_vpl VALUES ("PR19_8","021_19_8","PRO","19","8","8","Awiriya ikia sinar taso, mu kota ko daiga bagara sangarso; ale awiriya ikia nunguning ilukuawuso mu te yawarakala lagoso. ");
INSERT INTO wsk_vpl VALUES ("PR19_9","021_19_9","PRO","19","9","9","Den kawel te bo atumu saonga mu ko memek toko; den kawel kiring te arata mu betela ko ikup arikko. ");
INSERT INTO wsk_vpl VALUES ("PR19_10","021_19_10","PRO","19","10","10","Kari ngualara bo kawam digo melmasak manga bibiya awote dagiwuruk mu ko ariga terong e? Agi ura kari dungan bo, ko dom biya mu bowa tugumok ale ko melmasak suen la bitaruwuruk mu ko ariga diram e? ");
INSERT INTO wsk_vpl VALUES ("PR19_11","021_19_11","PRO","19","11","11","Kari ikia sinar ago mu tairatela me gomang magoso; nu ko nup yawara mu ilukuawuso ale saki alo bita maguwusan mu mel yam iwita arigiso. ");
INSERT INTO wsk_vpl VALUES ("PR19_12","021_19_12","PRO","19","12","12","King ko gomang magara mu lion nia kam; bare ko amilmil mu baras nuwi kusat sirsir yu tui kam. ");
INSERT INTO wsk_vpl VALUES ("PR19_13","021_19_13","PRO","19","13","13","Supuling lagara ko kuriang mu nuet ko daiga bagara maguwuso; se kari bo ko nuwus iningara munakara ko imet, mu buwung tam irikoyam bita lagoso. ");
INSERT INTO wsk_vpl VALUES ("PR19_14","021_19_14","PRO","19","14","14","Kawam digo se melmasak suen la nanga nainet nainam nangaru gilingisan; bare imet sinar ningo mu Yawe nangarso. ");
INSERT INTO wsk_vpl VALUES ("PR19_15","021_19_15","PRO","19","15","15","Ani geraga lagara mu gagor ko munan; kari nukum nuam te dagi lagara mu na ko kuerukko. ");
INSERT INTO wsk_vpl VALUES ("PR19_16","021_19_16","PRO","19","16","16","Awiriya kiti guruga den karo tuso mu ko daiga bagara ko sinar taso; bare awiriya ko munan ko me sinar taso mu kuerukko. ");
INSERT INTO wsk_vpl VALUES ("PR19_17","021_19_17","PRO","19","17","17","Awiriya kariimet kituwura nunga saonga beteso, mu munan mu Yawe kote bita kam, se Yawe munan nu beteram mu koma tuokko. ");
INSERT INTO wsk_vpl VALUES ("PR19_18","021_19_18","PRO","19","18","18","Ka namar gotektir bagoso la, dingumur se ko tom maiya taiwoso mu ningi ningo la bagarukko; ni uwuta me bitar mu ni karogotala nu kua namarukko lage te betesam. ");
INSERT INTO wsk_vpl VALUES ("PR19_19","021_19_19","PRO","19","19","19","Gomang magara ko kari memek, mu koma memek am arigokko. Ni nu me ta sangaruko; ni sangaru mu ni uwutata sangaru se lagerko. ");
INSERT INTO wsk_vpl VALUES ("PR19_20","021_19_20","PRO","19","20","20","Munan den kisimon mu iki ale kiti guruga ko den mu ilukuawur, mu udagi te ikia sinar kari bagerko. ");
INSERT INTO wsk_vpl VALUES ("PR19_21","021_19_21","PRO","19","21","21","Kari gomang motam ningi mu aguwaya bitirukko mu ko ikia duap duap aniso tala; bare anapeya Yawe ko gomang motam te aniso mu giriso arataso. ");
INSERT INTO wsk_vpl VALUES ("PR19_22","021_19_22","PRO","19","22","22","Saki alo kua nungara ko munan mu mel gira nunguningkiri. Kimik mel mena kituwura bagara mu mel bo mena; bare kawel munan te lagara mu memek biya nunguningkiri. ");
INSERT INTO wsk_vpl VALUES ("PR19_23","021_19_23","PRO","19","23","23","Kua Yawe bowa ningi bagara mu bagara aolak ningo nangarso; ale munan umu te ana nangamang kua kaposo se terong la baga se memek me nanga maguwuso. ");
INSERT INTO wsk_vpl VALUES ("PR19_24","021_19_24","PRO","19","24","24","Kari gagor mu tawir ningi inang taukko kuting garukuso; bare inang patawuruk kuring te bitirukko mu ninguru gagorso! ");
INSERT INTO wsk_vpl VALUES ("PR19_25","021_19_25","PRO","19","25","25","Ikia sinar suwik sapara ko kari moar se ninguru me sinarara alo mu sinarmonko; ikia ningo ko kari bo due to, mu nu ikia ningo nunguningkiri karogo terong maukko. ");
INSERT INTO wsk_vpl VALUES ("PR19_26","021_19_26","PRO","19","26","26","Awiriya nuet moso maguwuso, ale nuam kawam te karo pituwuso, mu kuriang mu nguangara dolara memek tagi wonong tuagu ningi beteso. ");
INSERT INTO wsk_vpl VALUES ("PR19_27","021_19_27","PRO","19","27","27","Aga namar, kiti guruga ko den ko de bagur mu ikia ningo ko lage paguwurko. ");
INSERT INTO wsk_vpl VALUES ("PR19_28","021_19_28","PRO","19","28","28","Kawel den te kari atumu saonga ko kari memek mu, munan diram doleng saposo; se kari memek mu munan memek na ningo no kam naso. ");
INSERT INTO wsk_vpl VALUES ("PR19_29","021_19_29","PRO","19","29","29","Ikia sinar doleng sapara ko kari alo nunga memek tamonko mu nunguru beteman se aniso; uwutatala nusupuling lagara alo nunga bu memek mu nunguru beteman se aniso. ");
INSERT INTO wsk_vpl VALUES ("PR20_1","021_20_1","PRO","20","1","1","Yu aora no ngualer, mu kari ngualara iwita aratu ale den ngual ngual te kager duap bitarko; ni kari ikia sinar mena, mu uwutata bitarko. ");
INSERT INTO wsk_vpl VALUES ("PR20_2","021_20_2","PRO","20","2","2","King ko gomang magara mu lion nia kam; awiriya nu gomang motam maguwuso mu numi pani te beteso. ");
INSERT INTO wsk_vpl VALUES ("PR20_3","021_20_3","PRO","20","3","3","Awiriya ining singi kager ko munan ko me kueso ale biriruwuso, mu nup ningo taso; bare kari ngualara mu tairate ining singi kager duap beteso. ");
INSERT INTO wsk_vpl VALUES ("PR20_4","021_20_4","PRO","20","4","4","Inang aguwa kam te gagora laga inang bo me asuru, mu inang gia kam te anape ko namar ale inang ko loaga se lagerko? ");
INSERT INTO wsk_vpl VALUES ("PR20_5","021_20_5","PRO","20","5","5","Kari ko ikia yumura sang mu gagi du biya iwita, bare kari sinar mu asele karogo kaeyawa ko ikiokko. ");
INSERT INTO wsk_vpl VALUES ("PR20_6","021_20_6","PRO","20","6","6","Kariimet suen biya balsan, “Ikup arigal mu aningate tairalko. Ani ninga saonga ikisam,” masan; bare kariimet nunguningta ka sangarmonko mu suen mena. ");
INSERT INTO wsk_vpl VALUES ("PR20_7","021_20_7","PRO","20","7","7","Kari ningo diram la, mu ko bagara aolak ningo diram la; noko kuriang gue mu yawarakala la bagamonko. ");
INSERT INTO wsk_vpl VALUES ("PR20_8","021_20_8","PRO","20","8","8","Tom king ko daiga kuwim te ikup guyak tuterukko dagiso, mu nu memek mu pasak ko motam sinarso. ");
INSERT INTO wsk_vpl VALUES ("PR20_9","021_20_9","PRO","20","9","9","Awiri baluk, “Aninga angamang motam ko ninguru sinar taem, ale ningo la, memek bo me beterem,” maukko? ");
INSERT INTO wsk_vpl VALUES ("PR20_10","021_20_10","PRO","20","10","10","Skel te ikup guyak diram la me tata, agi mel ko maiya tukunang diram la me ilu ariga ko munan, mu Yawe biriruwuso nunguningkiri. ");
INSERT INTO wsk_vpl VALUES ("PR20_11","021_20_11","PRO","20","11","11","Kuriang ko gomang motam ningi ningo se diram la agi mu ko ikiko mu, ko munan te arikko. ");
INSERT INTO wsk_vpl VALUES ("PR20_12","021_20_12","PRO","20","12","12","Nadogowa te den ikinakko, se namotam te sor ariginakko, Yawe ilagala la bita nangaram. ");
INSERT INTO wsk_vpl VALUES ("PR20_13","021_20_13","PRO","20","13","13","Ni anira ko kua lager, mu ni kari kituwura ko aratuko; loaga se ura iluwer, mu ni inang suen biya karogo bagerko. ");
INSERT INTO wsk_vpl VALUES ("PR20_14","021_20_14","PRO","20","14","14","“Diara tom sumu kalel biya!” ma lagaram, se mel kotam diara tom kutuwuram se kaparam, se diara kari mu koma aliti te diaram, ale namaram munan mu ko numi patawukaso. ");
INSERT INTO wsk_vpl VALUES ("PR20_15","021_20_15","PRO","20","15","15","Gold mu gold, se diamond mel mu diamond mel; bare kari kuring ningi ikia ningo ko den arataso mu, ali imi ko mel ningo nunguningkiri mu kiaram. ");
INSERT INTO wsk_vpl VALUES ("PR20_16","021_20_16","PRO","20","16","16","Kari bo ni ninguru me ko ikia agi mu, nika manga mel agi mu yam ngual me tuiko; ni gir ale noko guang ningo bo to ilup asele mel ko balso mu tuiko; se nu ko guang mu ko negeruk ale pasak tairuk ko ikup kutuwurokko. ");
INSERT INTO wsk_vpl VALUES ("PR20_17","021_20_17","PRO","20","17","17","Kawel kilek te inang gia mu yaman nuam, bare ninguru iki, mu ni saun sakar kiring tuguman se nowasam iwita. ");
INSERT INTO wsk_vpl VALUES ("PR20_18","021_20_18","PRO","20","18","18","Ikia sangam awote ikia kaloko; kiti guruga den to ale asele kager ko namarko. ");
INSERT INTO wsk_vpl VALUES ("PR20_19","021_20_19","PRO","20","19","19","Munak gi ago geraga ko munan te den yumura pagorsan; buta se munak ko kari ilak me sorerko. ");
INSERT INTO wsk_vpl VALUES ("PR20_20","021_20_20","PRO","20","20","20","Awiriya nuamnuet kua namamonko nunga manuk, mu nu galep bo sor tiromorom biya kaniwa iri palagoso iwita. ");
INSERT INTO wsk_vpl VALUES ("PR20_21","021_20_21","PRO","20","21","21","Lage guyak te mel ko tom aitak bare sail te gia, mu kerak tom maiya biya me anirukko. ");
INSERT INTO wsk_vpl VALUES ("PR20_22","021_20_22","PRO","20","22","22","Bo ko memek koma bitarko me baluko; Yawe te ira sanami sager se nu ka sangukko. ");
INSERT INTO wsk_vpl VALUES ("PR20_23","021_20_23","PRO","20","23","23","Mel ko ikup guyak diram la me tata ko munan mu Yawe biriruwuso; ale skel karogo kaera birikara ko munan mu me ko amilmiloso. ");
INSERT INTO wsk_vpl VALUES ("PR20_24","021_20_24","PRO","20","24","24","Yawe kari ko aolak kiti guruguwoso; se ko aolak ko ninguru iki saparukko mu me terong. ");
INSERT INTO wsk_vpl VALUES ("PR20_25","021_20_25","PRO","20","25","25","Ikia ninguru me ta ale, tairate mel balu Yawe tua ale aking udagi ikia ka moa lagara, mu me terong. ");
INSERT INTO wsk_vpl VALUES ("PR20_26","021_20_26","PRO","20","26","26","King ikia sinar ago mu kariimet memek mu nunga tuteso ale memek ninguru nungarso. ");
INSERT INTO wsk_vpl VALUES ("PR20_27","021_20_27","PRO","20","27","27","Yawe kari ko marak mu galep bo iwita tuam, se te anapeya ko gomang motam ningi aniso mu te ari guruguso. ");
INSERT INTO wsk_vpl VALUES ("PR20_28","021_20_28","PRO","20","28","28","King ko kariimet nunga kua nungara se diram la nunga bitua ko munan mu nu sangarso, se tom maiya biya nunga king ko bagarukko. ");
INSERT INTO wsk_vpl VALUES ("PR20_29","021_20_29","PRO","20","29","29","Kari kulak nunga nokokosa barim am biya mu te nunup kaposo; se kariimet garuk mu nokokone te kariimet nunga kua kapa gilingisan. ");
INSERT INTO wsk_vpl VALUES ("PR20_30","021_20_30","PRO","20","30","30","Kari memek bita lagara mu, tom bo iluwa ale moa maguwu gue tua mu am sangukko tala, ale mu te gomang motam gurugok ale munan ningo karoko. ");
INSERT INTO wsk_vpl VALUES ("PR21_1","021_21_1","PRO","21","1","1","King ko ikia se ko gomang motam mu Yawe kuting te aniso; kari ali kauso ale yu lage tuso se te nagu namoso iwita, Yawe king aguwaya bitirukko ikiwoso mu nu uwutata beteso. ");
INSERT INTO wsk_vpl VALUES ("PR21_2","021_21_2","PRO","21","2","2","Kari ko munan suen la beteso mu nu ningo la iwita ikiso; bare Yawe munan umu ko ikia yumura mu am iki saposo. ");
INSERT INTO wsk_vpl VALUES ("PR21_3","021_21_3","PRO","21","3","3","Tama bita Yawe tua mu ningo; bare munan ningo diram la betera mu Yawe ninguru ko kueso. ");
INSERT INTO wsk_vpl VALUES ("PR21_4","021_21_4","PRO","21","4","4","Kari memek mu numi patawu se supuling laga lagoso, ale kiwem memek ago terong mam. ");
INSERT INTO wsk_vpl VALUES ("PR21_5","021_21_5","PRO","21","5","5","Kari ninguru iki guruguso asele ura beteso, mu noko ura yawarakala arataso ale nunguning karogo; bare lage guyak se tukunang te mel tata ko nunguning mu, kimik mel mena, kituwura lagerko. ");
INSERT INTO wsk_vpl VALUES ("PR21_6","021_21_6","PRO","21","6","6","Kawel ko munan te mel suen biya gia mu tama bur iwita pasak mena namarukko, ale dagarok iwita ka taliparukko. ");
INSERT INTO wsk_vpl VALUES ("PR21_7","021_21_7","PRO","21","7","7","Kari memek nunga kager daong ko munan mu nunga sarumu warukko, mu awuk, nuna munan ningo diram betemonko me kuesan. ");
INSERT INTO wsk_vpl VALUES ("PR21_8","021_21_8","PRO","21","8","8","Kari ikup ago mu ko bagara aolak mu daeldel pukakung; bare awiriya ko bagara aolak ko sinar taso mu munan ningo diram la beteso. ");
INSERT INTO wsk_vpl VALUES ("PR21_9","021_21_9","PRO","21","9","9","Nika imet ining singi bitiruk mu ilak kawam ningi bager i? Mena. Aratu ale matangi siwik motam atumu bager mu terong. ");
INSERT INTO wsk_vpl VALUES ("PR21_10","021_21_10","PRO","21","10","10","Kari memek mu inang ko kuakoyam memek bitirukko kua lagoso; ale nu bo gomang tua me ikiso. ");
INSERT INTO wsk_vpl VALUES ("PR21_11","021_21_11","PRO","21","11","11","Ikia sinar suwik sapara ko kari moar se ninguru me sinarara alo mu sinarmonko; ikia ningo ko kari bo due to, mu nu ikia ningo nunguningkiri karogo terong maukko. ");
INSERT INTO wsk_vpl VALUES ("PR21_12","021_21_12","PRO","21","12","12","Yawe mu ningo se diram nunguningkiri; se nu kariimet memek nunga bagara aolak mu ari iki saposo, ale memek te nunga bitirukko. ");
INSERT INTO wsk_vpl VALUES ("PR21_13","021_21_13","PRO","21","13","13","Awiriya kariimet kituwura nunga niara ko dogowa baguso, mu nu tom bo uwutatala niaruk bare kuring me ilumonko. ");
INSERT INTO wsk_vpl VALUES ("PR21_14","021_21_14","PRO","21","14","14","Kari bo ni ko ko gomang magawuruk mu kariimet saki me karkamon la, munan ningo bo tui ale gomang te kulukuru se gomang kua kaparukko. ");
INSERT INTO wsk_vpl VALUES ("PR21_15","021_21_15","PRO","21","15","15","Tom munan ningo mu sor ereso, mu kariimet ningo diram mu amilmilasan; bare memek betera ko kariimet alo mu nguangasan. ");
INSERT INTO wsk_vpl VALUES ("PR21_16","021_21_16","PRO","21","16","16","Awiriya ikia ningo ko lage karowa bita taso, mu nu nama kua namoso. ");
INSERT INTO wsk_vpl VALUES ("PR21_17","021_21_17","PRO","21","17","17","Awiriya na ningo se waen ningo no se, oil kumik palunguru se bagara amilmil mu ko kua lagoso, mu ko manga mel menaruk se nu kari kituwura ko bagarukko. ");
INSERT INTO wsk_vpl VALUES ("PR21_18","021_21_18","PRO","21","18","18","Kariimet ningo diram mu ningo la namamon, bare kariimet diram la me bagara mu nunga memek koma tamonko. ");
INSERT INTO wsk_vpl VALUES ("PR21_19","021_21_19","PRO","21","19","19","Kutek am sor garagarayam memek te keta bagara lagara mu terong nuam; bare gomang magara se ining singi ko imet mu ilak bagara mu mel ikup. ");
INSERT INTO wsk_vpl VALUES ("PR21_20","021_21_20","PRO","21","20","20","Kari ikia sinar ago mu inang ningo ningo ko kawam digo tuguso; bare kari sinar mena mu ko mel ningo am no maguwu lagoso. ");
INSERT INTO wsk_vpl VALUES ("PR21_21","021_21_21","PRO","21","21","21","Awiriya munan ningo diram se bo kua tua ko munan mu ko kua lagoso, mu daiga bagara ningo arigiso ale nup ningo karogo lagoso. ");
INSERT INTO wsk_vpl VALUES ("PR21_22","021_21_22","PRO","21","22","22","Ikia sinar kari mu wonong aora bo nongorak kageraruk ale nunga sokel te ira sanamiwasan mu parusuwurok menawurokko terong mam. ");
INSERT INTO wsk_vpl VALUES ("PR21_23","021_21_23","PRO","21","23","23","Awiriya kuring kuamili ko sinar taso mu ikup bo me arigiso. ");
INSERT INTO wsk_vpl VALUES ("PR21_24","021_21_24","PRO","21","24","24","Numi patawura ale supuling lagara ko kari mu numi patawura ko munan me bita arigiso; noko nup mu “Patawura”. ");
INSERT INTO wsk_vpl VALUES ("PR21_25","021_21_25","PRO","21","25","25","Kari gagor gurum, kuting kua anira, mu kota ko daiga bagara maguwuso. ");
INSERT INTO wsk_vpl VALUES ("PR21_26","021_21_26","PRO","21","26","26","Nu pempem la melmasak bo karogo gemarukko gomang soraga lagoso; bare kariimet ningo diram mu gomang sorara iluwa bo mena kariimet saki mel nungaru lagoso. ");
INSERT INTO wsk_vpl VALUES ("PR21_27","021_21_27","PRO","21","27","27","Kari memek tama beteso, mu Yawe biriruwuso nunguningkiri; mu awuk, nu ikia ningo bo te munan mu me beteso. ");
INSERT INTO wsk_vpl VALUES ("PR21_28","021_21_28","PRO","21","28","28","Den kawel te bo atumu saonga mu mena namarukko; bare den nunguning la bala mu pempem ani lagarukko. ");
INSERT INTO wsk_vpl VALUES ("PR21_29","021_21_29","PRO","21","29","29","Kari memek mu nu numi terong iwita ikiso ale ko memek mu am bita lagoso, bare kari diram mu anapeya bitirukko mu ko iki iki beteso. ");
INSERT INTO wsk_vpl VALUES ("PR21_30","021_21_30","PRO","21","30","30","Ali imi ko ikia biya, ko ikia nunguning, se ko kiti guruga mu ningo agila wore, Yawe me karo tua mu me ta ka sangukko. ");
INSERT INTO wsk_vpl VALUES ("PR21_31","021_21_31","PRO","21","31","31","Kager ko horse se kager ko melmasak mu am nunguru burangi saparko, bare ni kager moa mituwur agi kager ka moa mituwurokko mu Yawe kuting te aniso. ");
INSERT INTO wsk_vpl VALUES ("PR22_1","021_22_1","PRO","22","1","1","Kariimet nomotam te nip ningo ago bagara mu, mel ningo ningo suen la se manga mel ko sokel kia saparam. ");
INSERT INTO wsk_vpl VALUES ("PR22_2","021_22_2","PRO","22","2","2","Kari bo kumik mel suen biya ago agi, se kari bo mu kumik mel mena, kituwura agi, bare mel biya nunguning mu Yawe nuna wete nunga nungam. ");
INSERT INTO wsk_vpl VALUES ("PR22_3","021_22_3","PRO","22","3","3","Kari sinar mu ikup ari se mu, numi tagi batagarso ale kia kaposo; bare kari sinar mena mu ngual kasik geraga nama ningi kaposo ale memek arigiso. ");
INSERT INTO wsk_vpl VALUES ("PR22_4","021_22_4","PRO","22","4","4","Nanimi karogo kapara ko munan se, Yawe bowa ningi bagara ko munan mu mel ningo ningo, bagara aolak ningo, se nup biya nangarso. ");
INSERT INTO wsk_vpl VALUES ("PR22_5","021_22_5","PRO","22","5","5","Kari memek ko tuang te mu mutim ilu beteman ale dagarok kira beteman se aniso; bare kari ko aolak ko sinar taso mu memek mu duap te me namoso. ");
INSERT INTO wsk_vpl VALUES ("PR22_6","021_22_6","PRO","22","6","6","Kuriang gotek bo munan ningo nu te pempem lagarukko mu gotek la kasuru mu, tom nu garukaruk mu nu pempem la karo tui se lagarukko. ");
INSERT INTO wsk_vpl VALUES ("PR22_7","021_22_7","PRO","22","7","7","Kari kumik mel mena, kituwura mu, kari kumik mel ago mu bowa ningi dungan bagoso; se kari bo, bo isarso se mel tuso mu, kari mel tuso umu bowa ningi dungan bagoso. ");
INSERT INTO wsk_vpl VALUES ("PR22_8","021_22_8","PRO","22","8","8","Awiriya kiwem memek mu tam bo iwita aguso, mu ko nunguning mu memek tagi kumik te beteso; ale ko bu, kariimet saki te nunga bita maguwu lagaram, mu kilikilik maukko. ");
INSERT INTO wsk_vpl VALUES ("PR22_9","021_22_9","PRO","22","9","9","Kari ko munan yawara mu, nup ningo se marak ningo kumik ko kaparukko, mu awuk, nu ko mel suen la mu kituwura alo nongorak numi tui no lagoso. ");
INSERT INTO wsk_vpl VALUES ("PR22_10","021_22_10","PRO","22","10","10","Ikia ningo suwik sapara ko kari mu karo sapara mu te, ining singi se tagira gurungumura ko kiwem memek mu menarukko. ");
INSERT INTO wsk_vpl VALUES ("PR22_11","021_22_11","PRO","22","11","11","Awiriya munan diram la ko kueso ale ko munak mu welang yawara la, mu king ko tiran yawara ko bagarukko. ");
INSERT INTO wsk_vpl VALUES ("PR22_12","021_22_12","PRO","22","12","12","Ikia ningo mu Yawe ko motam se ko bitua bowa ningi aniso; bare nu diram la me kaora ko den mu sokel menawuso. ");
INSERT INTO wsk_vpl VALUES ("PR22_13","021_22_13","PRO","22","13","13","Gagor kari nu kawam ningi baga se, “Lion bo watingi bagoso,” maso. “Ani aratik bare aga nauk bore ko!” maso. ");
INSERT INTO wsk_vpl VALUES ("PR22_14","021_22_14","PRO","22","14","14","Imet ko kuari ilak diram bagara mena mu ko den welang mu, mutim bo du biya wore iwita, se kari Yawe ko gomang magara bowa ningi bagoso, mu mutim umu ningi daguloso. ");
INSERT INTO wsk_vpl VALUES ("PR22_15","021_22_15","PRO","22","15","15","Ikia ngualara mu kuriang gomang motam ningi aniso; bare bu te nukum tagira mu ikia mu karo saposo. ");
INSERT INTO wsk_vpl VALUES ("PR22_16","021_22_16","PRO","22","16","16","Awiriya kituwura alo nunga melmasak giso ale noko melmasak mu karogo laguwuso, se awiriya kari melmasak suen biya ago wore gomang te kulukokko mel ningo ningo tuso, mu wete nunga melmasak mu mena namaruk se kari kituwura ko bagamonko. ");
INSERT INTO wsk_vpl VALUES ("PR22_17","021_22_17","PRO","22","17","17","Degewa gurugu ale ikia sinar ko kari kuring te den aratuwoso wore iki ale, anapeya ka kasursam imi gemang motam ningi ilukuawurko, ");
INSERT INTO wsk_vpl VALUES ("PR22_18","021_22_18","PRO","22","18","18","ale gemang motam te se kiring te mel yawara iwita amilmil te balu se lagerko. ");
INSERT INTO wsk_vpl VALUES ("PR22_19","021_22_19","PRO","22","19","19","Mu awuk, ani ni Yawe te la ira sanami se lagerko owore te se, ani aitak ka kasursam. ");
INSERT INTO wsk_vpl VALUES ("PR22_20","021_22_20","PRO","22","20","20","Arikko! Ani nika bala ningo ningo 30 batagem, mu kiti guruga ko den se ikia ningo ko den. ");
INSERT INTO wsk_vpl VALUES ("PR22_21","021_22_21","PRO","22","21","21","Se den nunguning ni te sanamirko mu ilukuawu se, awiriya nika isuok mu ko den koma ningo la balu tuiko. ");
INSERT INTO wsk_vpl VALUES ("PR22_22","021_22_22","PRO","22","22","22","Kariimet kituwura alo mu kituwura se ni me nunga bita maguwur ale nunga melmasak giko; ale biguwura motam te me nunga bitarko, ");
INSERT INTO wsk_vpl VALUES ("PR22_23","021_22_23","PRO","22","23","23","mu awuk, mu Yawe nunga ikup mu te nunga sanguk ale awiriya nunga bita maguwuso mu nu nunga bita maguwurokko. ");
INSERT INTO wsk_vpl VALUES ("PR22_24","021_22_24","PRO","22","24","24","Kari gomang motam tama ko kaniwara mu ilak me tiran bitar, ale kari gomang pasak ala magawara mu ilak me nimi giko. ");
INSERT INTO wsk_vpl VALUES ("PR22_25","021_22_25","PRO","22","25","25","Ni uwuta bitar ale noko kiwem memek mu arik ale keta nimi talipara ningi bitar bore ko. ");
INSERT INTO wsk_vpl VALUES ("PR22_26","021_22_26","PRO","22","26","26","Kari saki kari bo, bo kote dinau beteram umu sangarmon ale ko dinau kutuwumonko balmon, ale nunumi nuguting ilumon, mu ni nunga ningi me bagerko; ");
INSERT INTO wsk_vpl VALUES ("PR22_27","021_22_27","PRO","22","27","27","mu awuk, ni uwuta balu ale aking ikup bo arik ale dinau mu me dier mu, taimon ka melmasak suen la gimon ale ka anira kuwim ago gimon ago namamon bore ko. ");
INSERT INTO wsk_vpl VALUES ("PR22_28","021_22_28","PRO","22","28","28","Girakala taleng girigir alo ali ko tom beteman umu ni me baruku ale karogo kasu namar agi karogo utu tairko. ");
INSERT INTO wsk_vpl VALUES ("PR22_29","021_22_29","PRO","22","29","29","Kari ko ura ningo se guyak la beteso mu king ko ura kari ko aratukko; bare kari bo nup mena mu ko ura kari ko me aratukko. ");
INSERT INTO wsk_vpl VALUES ("PR23_1","021_23_1","PRO","23","1","1","Tom ni kari nup biya bo ilak na noko dagi mu, ka na nana ko munan ko ninguru sinar toko. ");
INSERT INTO wsk_vpl VALUES ("PR23_2","021_23_2","PRO","23","2","2","Ni na tawun biya nana ko kari agi mu, nimi ko sinar to ale na ko iki se noko. ");
INSERT INTO wsk_vpl VALUES ("PR23_3","021_23_3","PRO","23","3","3","Ni noko inang yawara se yaman nuam mu ko me dera bingokko, mu awuk, inang mu bowa ningi kawel munan aguwaya aniso agi mu ni me ko ikisam. ");
INSERT INTO wsk_vpl VALUES ("PR23_4","021_23_4","PRO","23","4","4","Mel ago bagerko neger ale ura te nimi me maguwurko; ikia sinar ago baga se munan mu me bitarko. ");
INSERT INTO wsk_vpl VALUES ("PR23_5","021_23_5","PRO","23","5","5","Mu awuk, tom bo loager mu melmasak mu me arikko; mu luman gemaram ale taraga iwita binga namaram. ");
INSERT INTO wsk_vpl VALUES ("PR23_6","021_23_6","PRO","23","6","6","Kari kaluwu nana mu ko inang yawara yaman nuam mu ko dera bingok se ilak dagi ale me noko; ");
INSERT INTO wsk_vpl VALUES ("PR23_7","021_23_7","PRO","23","7","7","mu awuk, nu “Na yu aniso, am noko,” ma se wore, ko manga na yu ko saparam mu ko dogotak sora se kuring guang la ka kuluruwoso. ");
INSERT INTO wsk_vpl VALUES ("PR23_8","021_23_8","PRO","23","8","8","Se udagi ko ari iki, mu ni inang gotek naem mu awuk kapi waru, ale ka munak ningo ilak munaka lagerem mu awuk ko baluko? Mena. ");
INSERT INTO wsk_vpl VALUES ("PR23_9","021_23_9","PRO","23","9","9","Kari ngualara mu ka den ningo me manaruko, mu awuk, nu nika ikia sinar yawara ko den mu tauk ale den kolara te bitirukko. ");
INSERT INTO wsk_vpl VALUES ("PR23_10","021_23_10","PRO","23","10","10","Girakala girigir alo ali ko tom beteman umu me baruku ale sarumur, agi kuriang nungumik bitua mena mu nunga ali me iramuruko, ");
INSERT INTO wsk_vpl VALUES ("PR23_11","021_23_11","PRO","23","11","11","mu awuk, nunga Bitua Kari bo bagoso tala, mu sokel aora biya; se nunga atumu sanguk ale tawun biya kerak baluko. ");
INSERT INTO wsk_vpl VALUES ("PR23_12","021_23_12","PRO","23","12","12","Kiti guruga ko den gemang tui ale ikia sinar ko den ko degewa gurugu se lagerko. ");
INSERT INTO wsk_vpl VALUES ("PR23_13","021_23_13","PRO","23","13","13","Bu te kuriang nukum tagira ko munan mu me to ilupko; memek bitiruk se nukum tagir mu me kuerukko pa! ");
INSERT INTO wsk_vpl VALUES ("PR23_14","021_23_14","PRO","23","14","14","Bu te nukum tagir mu ni kuera mateng ko lage te bataguru toko. ");
INSERT INTO wsk_vpl VALUES ("PR23_15","021_23_15","PRO","23","15","15","Aga namar, ni ikia sinar ago lager, mu ani ni ko ko angamang amilmil ago lagarikko; ");
INSERT INTO wsk_vpl VALUES ("PR23_16","021_23_16","PRO","23","16","16","tom den ningo se diram mu kiring te aratuk mu, ani angamang motam lilim la te amilmilarikko. ");
INSERT INTO wsk_vpl VALUES ("PR23_17","021_23_17","PRO","23","17","17","Ni memek betera alo nunga kiwem memek umu arik ale ko motam welang me tairukko; ni pempem la Yawe bowa ningi la bagerko. ");
INSERT INTO wsk_vpl VALUES ("PR23_18","021_23_18","PRO","23","18","18","Nunguningta, ni uwuta bita lager mu ni tom pempem daiga bagara ningo mu arik ale ningo la lagerko. ");
INSERT INTO wsk_vpl VALUES ("PR23_19","021_23_19","PRO","23","19","19","Aga namar, degewa gurugu ale ikia sinar ago la baga se, munan lage diram mu la karo tui se lagerko. ");
INSERT INTO wsk_vpl VALUES ("PR23_20","021_23_20","PRO","23","20","20","Yu aora tawun biya nana ko kari alo, se mel ko nunguning nana ko nodogotak ko talalam, mu nongorak me kapeterko, ");
INSERT INTO wsk_vpl VALUES ("PR23_21","021_23_21","PRO","23","21","21","mu awuk, nuna anira geraga te nama kituwura amon, ale nungumik mel mena ko baga se guang karur ago se batuwutukam mu nagumonko. ");
INSERT INTO wsk_vpl VALUES ("PR23_22","021_23_22","PRO","23","22","22","Ni ka niet, ka bulamaram, mu ko kuring iki ale ka niam garukaruk ta wore me mel yam ko bitarko. ");
INSERT INTO wsk_vpl VALUES ("PR23_23","021_23_23","PRO","23","23","23","Den nunguning mu mel yawara, se ninguru sail tagi laga to ale ilukuawurko; uwutatala ikia sinar, kiti guruga ningo, se ikia ningo mu koma suanta tala. ");
INSERT INTO wsk_vpl VALUES ("PR23_24","021_23_24","PRO","23","24","24","Kari ningo diram mu ko nuet mu amilmil te lagoso. ");
INSERT INTO wsk_vpl VALUES ("PR23_25","021_23_25","PRO","23","25","25","Buta se ni ka niamniet nongomang amilmil nungaruko; ka niam mu amilmil biya tuiko. ");
INSERT INTO wsk_vpl VALUES ("PR23_26","021_23_26","PRO","23","26","26","Aga namar, aga den ninguru iki ale amolak la karoko, ");
INSERT INTO wsk_vpl VALUES ("PR23_27","021_23_27","PRO","23","27","27","mu awuk, lage luan imet mu mutim bo du biya wore toroman, se imet ko kari ilak diram me bagara mu yu ko mutim bo kirikirik se du biya wore iwita. ");
INSERT INTO wsk_vpl VALUES ("PR23_28","021_23_28","PRO","23","28","28","Nuna tere kari lage luan te yumuram baga se, imet ilak me diram bagara ko munan te kari suen biya nunga maguwuwoso se kapawasan. ");
INSERT INTO wsk_vpl VALUES ("PR23_29","021_23_29","PRO","23","29","29","Awiri ikup ago? Awiri noman bataga ago? Awiri den tagi gurungumu lagoso? Awiri ininga munaka lagoso? Awiri lot gawir ago lagoso? Awiri motam kuagi guar kiriyam lagoso? ");
INSERT INTO wsk_vpl VALUES ("PR23_30","021_23_30","PRO","23","30","30","Mu awiriya mena, kari yu aora tawun biya nasan ale yu aora duap duap no ari ari geragasan, kari ari borta. ");
INSERT INTO wsk_vpl VALUES ("PR23_31","021_23_31","PRO","23","31","31","Yu waen ko diriyam mu agi, bagun ningi musuk pagoso mu se, degetak luan ningi palenga kaposo mu arik ale me motam barasukko! ");
INSERT INTO wsk_vpl VALUES ("PR23_32","021_23_32","PRO","23","32","32","Mu awuk, nukum te mu yu mu mot memek kuating memek karogo wore iwita daongaso. ");
INSERT INTO wsk_vpl VALUES ("PR23_33","021_23_33","PRO","23","33","33","Se motam bingok ale taratarong kelaguk se dora duap duap arik, ale ka ikia ngualaruk se ikia kawel kamin te tairukko. ");
INSERT INTO wsk_vpl VALUES ("PR23_34","021_23_34","PRO","23","34","34","Agi ni nimi ko iki mu ni gagi tuagu biya te dal biya bo ko gul te taga anirem ale aniwasam iwita ikiko. ");
INSERT INTO wsk_vpl VALUES ("PR23_35","021_23_35","PRO","23","35","35","Ale iwita baluko, “Nuna aninga usagaman bare ani me memek taem! Nuna aninga moman bare ani yaman me ikiem! Se ani amaru te barasik ale yu bo karogo arigek ale naikko ya!” meko. ");
INSERT INTO wsk_vpl VALUES ("PR24_1","021_24_1","PRO","24","1","1","Kari memek nunga kiwem memek mu ko me gemang barasuk se nongorak nimi giko negerko; ");
INSERT INTO wsk_vpl VALUES ("PR24_2","021_24_2","PRO","24","2","2","mu awuk, nononga nongomang mu kager ko la aniso; se nuguring mu ikup ko munak karogo terong mam. ");
INSERT INTO wsk_vpl VALUES ("PR24_3","021_24_3","PRO","24","3","3","Ikia sinar te kawam bo kalo ale ko ngatalek aora bibiya mu ikia nunguning te bangaru bangaru karogo namarko; ");
INSERT INTO wsk_vpl VALUES ("PR24_4","021_24_4","PRO","24","4","4","ale ikia ningo te meltutuk balayam yawara yawara mu ko galung tugu tugu karogo namarko. ");
INSERT INTO wsk_vpl VALUES ("PR24_5","021_24_5","PRO","24","5","5","Ikia sinar ko kari mu ko sokel aora biya, se kari ikia ningo ago mu sokel iru iru giso. ");
INSERT INTO wsk_vpl VALUES ("PR24_6","021_24_6","PRO","24","6","6","Buta se kager ko namar ale marirerko mu, ni kiti guruga ko den se den sangam kari sinar nongote gi ale asele kager ko namarko. ");
INSERT INTO wsk_vpl VALUES ("PR24_7","021_24_7","PRO","24","7","7","Kari ngualara mu ikia sinar taukko ikup biya; buta se kariimet biguwura biya ningi den bo ta me balukko. ");
INSERT INTO wsk_vpl VALUES ("PR24_8","021_24_8","PRO","24","8","8","Ikia memek balu nunga ko kari mu nup betemon ikup memek ko kari supuling mamonko. ");
INSERT INTO wsk_vpl VALUES ("PR24_9","021_24_9","PRO","24","9","9","Ikia memek kari supuling aora biya mu balu nungurso mu memek; se kariimet mu awiriya ikia sinar ko den ko doleng saposo mu ninguru biriruwusan. ");
INSERT INTO wsk_vpl VALUES ("PR24_10","021_24_10","PRO","24","10","10","Ni ikup kam ningi durdur lager, mu ni kituwura se sokel mena! ");
INSERT INTO wsk_vpl VALUES ("PR24_11","021_24_11","PRO","24","11","11","Kariimet nungumik den mena nunga momon se kuemonko nongorak namawomon mu, nunga bataguru to ale nunga ilup se me nunga momon se kuemonko. ");
INSERT INTO wsk_vpl VALUES ("PR24_12","021_24_12","PRO","24","12","12","Bare ni balu, “Arikko, ana mel umu me ko ikiman,” ma balu, bare Kaem kariimet gomang motam tuati ikiwara mu ka kawel mu me ikiok i? Nu nika bitaruwara mu am kuluru i? Se nu kariimet suen la nunga munan betesan mu koma diram la me nungaruk i? ");
INSERT INTO wsk_vpl VALUES ("PR24_13","021_24_13","PRO","24","13","13","Aga namar, ni honey sang noko; mu mel ningo, ni kamili te kau to mu yaman nuam ko ikiko. ");
INSERT INTO wsk_vpl VALUES ("PR24_14","021_24_14","PRO","24","14","14","Uwutatala, ikia sinar mu gemang motam ningi bitar mu yaman nuam; ni to ale ilup mu, maingte ko ningo ari se lager se uwutata ka sangaru se lagarukko. ");
INSERT INTO wsk_vpl VALUES ("PR24_15","021_24_15","PRO","24","15","15","Kari memek bo kari ningo diram bo memek tuokko, ko kawam duap te yumuwoso uwuta me bitar, ale ko kawam digo lilim me maguwurko. ");
INSERT INTO wsk_vpl VALUES ("PR24_16","021_24_16","PRO","24","16","16","Mu awuk, kari ningo diram mu tom 7 ko ta dagulok bare am barasuwurukko, bare kari memek ikup te daguloso mu dagula biya daguloso. ");
INSERT INTO wsk_vpl VALUES ("PR24_17","021_24_17","PRO","24","17","17","Kari ni kerak bitawara mu dagulok mu ni me gusir agi, suwik motam atumok ale taguruk mu ni me amilmilerko. ");
INSERT INTO wsk_vpl VALUES ("PR24_18","021_24_18","PRO","24","18","18","Ni uwuta bitar mu Yawe ni kerak me amilmilaruk, ale noko gomang memek kari mu kumik te mu kutuwu saparukko. ");
INSERT INTO wsk_vpl VALUES ("PR24_19","021_24_19","PRO","24","19","19","Ni kariimet memek mu ningo la bagasan mu ko me gemang dagulokko, ale nunga mel ningo ningo karogo bagasan mu ko me ikia ka morukko, ");
INSERT INTO wsk_vpl VALUES ("PR24_20","021_24_20","PRO","24","20","20","mu awuk, kari memek mu nunga bagara aolak bo maiya biya mena, se nunga galep mu tairate la iri palagukko. ");
INSERT INTO wsk_vpl VALUES ("PR24_21","021_24_21","PRO","24","21","21","Aga namar, Yawe se king nobowa ningi bagerko, ale awiriya nongorak barimawoso mu nongorak me kapeterko. ");
INSERT INTO wsk_vpl VALUES ("PR24_22","021_24_22","PRO","24","22","22","Mu awuk, Yawe se king ilak memek biya bo nungumik te betemonko, se ikup nuna tamonko mu ko memek aguwaya mu awiri ko ikiokko? ");
INSERT INTO wsk_vpl VALUES ("PR24_23","021_24_23","PRO","24","23","23","Bala imi betela ikia sinar ko bala saki: Den ariga kam te nimi kema ko me nguangerko, diram la baluko. ");
INSERT INTO wsk_vpl VALUES ("PR24_24","021_24_24","PRO","24","24","24","Awiriya kari bo memek beteram ta wore manarso, “Ni kari ningo diram,” maso, mu kariimet kumik ko bala memek balmon, se sor suen biya mu nubiring tumonko. ");
INSERT INTO wsk_vpl VALUES ("PR24_25","021_24_25","PRO","24","25","25","Bare awiriya kari memek beteso mu diram la ko memek koma ikup tuso, mu nup ningo se den ningo kumik ko kaparukko. ");
INSERT INTO wsk_vpl VALUES ("PR24_26","021_24_26","PRO","24","26","26","Tiran yawara ilu yasara ale gemang kua kapara iwita, den koma nunguning la se diram la balu kisa mu ni gemang kua kaparukko. ");
INSERT INTO wsk_vpl VALUES ("PR24_27","021_24_27","PRO","24","27","27","Matangi ko ura gek am tala nunguru sapar, ningam asuru asele, kawam kaloko. ");
INSERT INTO wsk_vpl VALUES ("PR24_28","021_24_28","PRO","24","28","28","Kawel ko munan te ka bo den te ipi me bitar, agi kiring te den kawel bo me ta aratukko. ");
INSERT INTO wsk_vpl VALUES ("PR24_29","021_24_29","PRO","24","29","29","Ni balu ale “Kari umu munan agate beteram uwutatala kote bitirikko,” ma me baluko. ");
INSERT INTO wsk_vpl VALUES ("PR24_30","021_24_30","PRO","24","30","30","Ani kari gagor mu ko ningam duap karem ale arigem, ale ko waen ningam mu karogo arigem, kari mu kumik ikia bo ningo mena. ");
INSERT INTO wsk_vpl VALUES ("PR24_31","021_24_31","PRO","24","31","31","Mayang kore ago mu se sum barasam sor ira saparam; se ko ningam ko kar mu parasaram ale kaparam aniram se arigem. ");
INSERT INTO wsk_vpl VALUES ("PR24_32","021_24_32","PRO","24","32","32","Ani anapeya arigem mu ko iki gurugem ale mel arigem mu munan bo aga kausam: ");
INSERT INTO wsk_vpl VALUES ("PR24_33","021_24_33","PRO","24","33","33","Mu iwita, katir la anira ko munan, namotam kilikilok ma ko munan, se nagiting patutumu saen ko betera ko munan mu te, ");
INSERT INTO wsk_vpl VALUES ("PR24_34","021_24_34","PRO","24","34","34","kimik mel mena, kituwura bagara ko munan mu tere kari iwita tairuk ka maguwurokko. ");
INSERT INTO wsk_vpl VALUES ("PR25_1","021_25_1","PRO","25","1","1","Imi Solomon ko ikia sinar ko den saki, Judah ko king Hezekiah ko kari den imi ilu biguwuman ale batagorman. ");
INSERT INTO wsk_vpl VALUES ("PR25_2","021_25_2","PRO","25","2","2","Kaem kota ko ikia te ko mel yumura mu bo to iluso ale bo wetang saposo mu ko nup biya taso; bare king alo mu mel yumura umu kupusan ale duap ikisan mu ko nup biya tasan. ");
INSERT INTO wsk_vpl VALUES ("PR25_3","021_25_3","PRO","25","3","3","Taiti kalel biya se gagi naung du biya iwita, king alo nunga ikia ni me iki saparko. ");
INSERT INTO wsk_vpl VALUES ("PR25_4","021_25_4","PRO","25","4","4","Silver ko manga kai mu asele, silver kota nama kererpuruk, asele ura mel ningo ningo te bitarko; ");
INSERT INTO wsk_vpl VALUES ("PR25_5","021_25_5","PRO","25","5","5","uwutatala, king ko kari dom memek alo umu nunga gi waru se asele, king ko ura mu nama kererpuruk se munan ningo diram te karukko. ");
INSERT INTO wsk_vpl VALUES ("PR25_6","021_25_6","PRO","25","6","6","King koma te keta nimi nip me patawur ale ka sail te noko kari bibiya nunga kulupik ningi kuwim bo toko me karogo kaerko. ");
INSERT INTO wsk_vpl VALUES ("PR25_7","021_25_7","PRO","25","7","7","Nu kota nika manuk, “Iwita tai basuko mauk mu asele ko; bare ni noko dom bibiya nongoma te nu aliti biya ka bitiruk mu dolara ago. Anapeya motam te arigem mu kawel agi wore ko, ");
INSERT INTO wsk_vpl VALUES ("PR25_8","021_25_8","PRO","25","8","8","gemang gemang pasak ala biguwura te me bitarko, mu awuk, den kotam umu den te ka kiaruk ale dolara kisok, mu ni awuk bitarko? ");
INSERT INTO wsk_vpl VALUES ("PR25_9","021_25_9","PRO","25","9","9","Iki paguwura kari bo kote betera mu, kote namar ale wete yumura la balu aruruwuralko; ni noko dugu duap kariimet ningi me balu pagaruko. ");
INSERT INTO wsk_vpl VALUES ("PR25_10","021_25_10","PRO","25","10","10","Kariimet ka bo wetang saperem mu ko dolara kisimon se ka nip mu magara biya magarukko. ");
INSERT INTO wsk_vpl VALUES ("PR25_11","021_25_11","PRO","25","11","11","Kari munak iki kuawuwa ko tom te diram bala mu, kariimet sangam yawara se lila yawara nungarso. ");
INSERT INTO wsk_vpl VALUES ("PR25_12","021_25_12","PRO","25","12","12","Ikia sinar kari awiriya due iluso se nu iki karo tuso, mu kulolo yawara bo gold te nungurman wore dogotak tugumam iwita. ");
INSERT INTO wsk_vpl VALUES ("PR25_13","021_25_13","PRO","25","13","13","Worem biya ningi inang gi laga, degetak garagara ma se yu ipi nana ale gemang kua kapara iwita, dom kari biya mu ko taling kari kumik gagor mena, diram la bita saposo, mu ko gomang motam kua kaposo. ");
INSERT INTO wsk_vpl VALUES ("PR25_14","021_25_14","PRO","25","14","14","Awiriya ko mel ningo ningo ko numi patawuso, ale ko mel sang saki alo nungaruk maso bare me nungarso, mu nu taiti nuwi marir karogo taiso bare tuwik me kaposo wore toroman. ");
INSERT INTO wsk_vpl VALUES ("PR25_15","021_25_15","PRO","25","15","15","Gemang kua kapa se welang karogo munakara ko munan te mu, kari supuling gomang gurugokko me terong ta wore, gomang motam am gurugokko. ");
INSERT INTO wsk_vpl VALUES ("PR25_16","021_25_16","PRO","25","16","16","Honey arik agi mu, ko iki se noko; tawun biya no mu kapirko. ");
INSERT INTO wsk_vpl VALUES ("PR25_17","021_25_17","PRO","25","17","17","Uwutatala, tom sapa sapa ka bo ko kawam te namar mu terong; bare am taira tairate nama taiwer mu ko ko gagorarukko. ");
INSERT INTO wsk_vpl VALUES ("PR25_18","021_25_18","PRO","25","18","18","Bo ko kumik ko den kawel bala ko munan mu, kager ko saenang agi baenat agi gatu kore buguyam te daongasan owore toroman. ");
INSERT INTO wsk_vpl VALUES ("PR25_19","021_25_19","PRO","25","19","19","Kari kore yaman ago na no turutuwu lagoso, agi kari suwik lot ago se sanamara aolak ko me terong, uwutatala, diram la me betera ko kari mu ikup kam ningi te ira sanamir, bare ka sangaru turutuwurokko. ");
INSERT INTO wsk_vpl VALUES ("PR25_20","021_25_20","PRO","25","20","20","Bo gomang ikup karogo bagara se koma te amilmil wur iluwa mu me terong; mu ko ikia, kari bo marir birigira ningi iluwa ale ko kumik guang kutuwu sapara agi, gagi iluwa ale yu welang ningi waru kam, yaman tuso. ");
INSERT INTO wsk_vpl VALUES ("PR25_21","021_25_21","PRO","25","21","21","Kari kerak memek ta wore na ko kueruk mu inang tui se naukko, ale yu ko kueruk mu yu tui se naukko. ");
INSERT INTO wsk_vpl VALUES ("PR25_22","021_25_22","PRO","25","22","22","Uwuta mu, ni tama kaok kaniwara mu nu supuling te awukam yaman tauk ale munan ni kimik te beteram mu ko dolorukko; se Yawe ko koma ningo mu kisokko. ");
INSERT INTO wsk_vpl VALUES ("PR25_23","021_25_23","PRO","25","23","23","Saki alo nubiring ko balu balu geraga ko munan mu kariimet nongomang motam maguwuso se nongoma motam yar daula samamer tuwik karogo tai kam karkamonko. ");
INSERT INTO wsk_vpl VALUES ("PR25_24","021_25_24","PRO","25","24","24","Nika imet ining singi bitiruk mu ilak kawam ningi bager i? Mena. Aratu ale matangi siwik motam atumu bager mu terong! ");
INSERT INTO wsk_vpl VALUES ("PR25_25","021_25_25","PRO","25","25","25","Yu ko degetak garagara maso se yu nasam ale amilmilasam uwutatala, mel bo ko loaga ikia bita lagasam se ko den ningo tai laga tai arataso se ikisam, mu ni amilmilasam. ");
INSERT INTO wsk_vpl VALUES ("PR25_26","021_25_26","PRO","25","26","26","Kari ningo diram mu munan ningo bita taso ale kari memek karo tuso mu ko ariga, yu yawara wore lom gege tuguma wore iwita. ");
INSERT INTO wsk_vpl VALUES ("PR25_27","021_25_27","PRO","25","27","27","Honey ko dera binga se tawun biya nana mu kapi lagerko; uwutatala, nip biya ta ko dera binga se karogo kaeya lagara mu dagulu paraserko. ");
INSERT INTO wsk_vpl VALUES ("PR25_28","021_25_28","PRO","25","28","28","Awiriya kota ko kiwem ninguru me bitarso, mu nu ningam bo inang ago lilim aniram se ko kar parasaram kaparam iwita bagoso. ");
INSERT INTO wsk_vpl VALUES ("PR26_1","021_26_1","PRO","26","1","1","Kari ngualara mu anapeya awuk mam bare ko nup biya taukko? Nup biya tua mu ais muguri worem biya ningi dagulu kam, agi worem tom te tuwik ngual kasik kapara iwita, se munan mu diram mena. ");
INSERT INTO wsk_vpl VALUES ("PR26_2","021_26_2","PRO","26","2","2","Kari bo memek bo me betera bare am ipi magara namarukko bala memek bala, mu am balu te kolerko; inangnang daiga kuwim mena se binga lagoso iwita, bala mu binga lagarukko. ");
INSERT INTO wsk_vpl VALUES ("PR26_3","021_26_3","PRO","26","3","3","Horse mu wip te moar se lage taukko; se donkey mu mayang sumulak te mu tagir se aolak taukko; bare kari ngualara mu tam te susuru bataguru asele ko ikia sinar taukko. ");
INSERT INTO wsk_vpl VALUES ("PR26_4","021_26_4","PRO","26","4","4","Kari ngualara ko munak ngualara mu te ilak me garerko. Sinar toko! Ni nu iwitatala aratu bore ko! ");
INSERT INTO wsk_vpl VALUES ("PR26_5","021_26_5","PRO","26","5","5","Kari ngualara ko bala ngualara mu, koma diram la balu pagaruko; mena, mu nu numi ikiok nu kari sinar bo iwita ikiok ale kota numi kulok bore ko. ");
INSERT INTO wsk_vpl VALUES ("PR26_6","021_26_6","PRO","26","6","6","Kari ngualara den tua se karogo nama saki alo nungara, mu ni kete nimi memek te betera iwita; se ko ikia mu ni keta siwik bataguru saperem, agi mel bo no kuera wore naem iwita. ");
INSERT INTO wsk_vpl VALUES ("PR26_7","021_26_7","PRO","26","7","7","Kari ikia mena mu proverb ko den balso, bare awuk ningi saonga taukko? Mu nu kari bo suwik tilital se gurati gurungumu lagoso iwita. ");
INSERT INTO wsk_vpl VALUES ("PR26_8","021_26_8","PRO","26","8","8","Kari ngualara nup biya tua mu ko ariga daga wol pisi tagi laga bita ta, bare daga gotek me aratu namoso wore iwita. ");
INSERT INTO wsk_vpl VALUES ("PR26_9","021_26_9","PRO","26","9","9","Kari ngualara kuring te proverb arataso mu kumik ningo bo mena; nu ko ariga kari yu naso ngualoso ale tam kore ago wore iluso se kuting atumuso iwita. ");
INSERT INTO wsk_vpl VALUES ("PR26_10","021_26_10","PRO","26","10","10","Kari dom biya mu kari ngualara agi, kari murum kuwim karogo geragawara, mu nunga gi ura te nunga awuso, mu ko ariga, kari daga gotek ngual ngual tagiso ale kariimet te ngual ngual nunga moso wore toroman. ");
INSERT INTO wsk_vpl VALUES ("PR26_11","021_26_11","PRO","26","11","11","Kausik bo kapso ale aking ko kapara naso iwita, kari ngualara mu ko kiwem memek mu gira awom la beteso. ");
INSERT INTO wsk_vpl VALUES ("PR26_12","021_26_12","PRO","26","12","12","Ikia mena ko kari bo kota numi balam nu ikia sinar ago mam se arigem e? Ikiko! Kari ngualara mu saonga taukko lage katir karogo; bare kari ikia mena mu saonga taukko lage bo mena. ");
INSERT INTO wsk_vpl VALUES ("PR26_13","021_26_13","PRO","26","13","13","Kari gagor mu balso, “Lion bo lage te bagoso, lion mu lage karowoso!” maso, ale ura mena kawam ningi la baga lagoso. ");
INSERT INTO wsk_vpl VALUES ("PR26_14","021_26_14","PRO","26","14","14","Songkuring sapasan se namoso taiso iwita, nu ko anira kuwim te titimam baga se, beta sang guruga katir la, aking sang guruga katir la ma se aniwoso. ");
INSERT INTO wsk_vpl VALUES ("PR26_15","021_26_15","PRO","26","15","15","Kari gagor mu tawir ningi inang taukko kuting garukuso; bare inang patawuruk kuring te bitirukko mu ninguru gagorso! ");
INSERT INTO wsk_vpl VALUES ("PR26_16","021_26_16","PRO","26","16","16","Kari 7 mu ikia sinar ago isa koma ningo la baluwasan mu, kari gagor mu kota numi ko balso, noko ikia mu nononga mu kiaram ale kalel biya aniso maso. ");
INSERT INTO wsk_vpl VALUES ("PR26_17","021_26_17","PRO","26","17","17","Kari saki den te nunumi iluwasan se kari bo am ngual kasik ningi numi beteso, mu ko ariga, kari bo kausik taiwoso se dogowa te iluso ale memek taso wore iwita, nu memek taukko. ");
INSERT INTO wsk_vpl VALUES ("PR26_18","021_26_18","PRO","26","18","18","Kari ngualara ko munan ngualara mu, kari bo gatu kore daong karogo kariimet ningi ngual ngual tagiso wore iwita. ");
INSERT INTO wsk_vpl VALUES ("PR26_19","021_26_19","PRO","26","19","19","Uwutatala, noko munan bo mu, kari bo mel bo nunguning mena wore ko tiran bo kulurso se ko gomang ningi nunguning aso, se udagi aking balso, “Ah, ani den kolara balem pa!” maso. ");
INSERT INTO wsk_vpl VALUES ("PR26_20","021_26_20","PRO","26","20","20","Tama kower mena mu tama iriso; uwutatala, kari buring ko bala ko munan mu mena, mu alis ining ko sokel kua kaposo. ");
INSERT INTO wsk_vpl VALUES ("PR26_21","021_26_21","PRO","26","21","21","Tam kaok mu kowar biya, se tama kower iluso ale kaniso; uwutatala, ining munak ko kariimet nungumik te, kager mu tama barasukam barasoso. ");
INSERT INTO wsk_vpl VALUES ("PR26_22","021_26_22","PRO","26","22","22","Kari buring ko bala ko den mu inang yaman yaman iwita; se kariimet amilmil te nasan se nutagu ningi kaposo. ");
INSERT INTO wsk_vpl VALUES ("PR26_23","021_26_23","PRO","26","23","23","Munak welang yawara te bo ko gemang memek mu kaluwura mu ko ariga, kani bo ali te nungurman ale mel bo silver iwita, bare silver nunguning mena, wore te palunguru beteman iwita. ");
INSERT INTO wsk_vpl VALUES ("PR26_24","021_26_24","PRO","26","24","24","Kari memek mu ko munak welang welang te ko ikia yumura memek gomang motam ningi kaluwuso. ");
INSERT INTO wsk_vpl VALUES ("PR26_25","021_26_25","PRO","26","25","25","Buta se kari ni kerak memek mu yawara karogo munakaruk, bare me ko gemang ningi nunguning arukko, mu awuk, nu ikia memek duap duap karogo bagoso. ");
INSERT INTO wsk_vpl VALUES ("PR26_26","021_26_26","PRO","26","26","26","Nu ko munak kawel mu te ko gomang memek mu am kaluwurokko, bare noko munan memek mu wetangaruk se kariimet ko ikimonko. ");
INSERT INTO wsk_vpl VALUES ("PR26_27","021_26_27","PRO","26","27","27","Kari bo kari te iluwokko mutim iso, mu kota ningi dagulokko; kari bo manga aromemek diruwuso se duruk luan karoso kariimet nunga morukko kaposo, mu manga bo nu irok se kuerukko. ");
INSERT INTO wsk_vpl VALUES ("PR26_28","021_26_28","PRO","26","28","28","Kari den nunguning me balso mu kariimet nu me nunga kueso, ale ko munak te nunga maguwuso; Sinar toko! Kari den welang te kaweloso bare ko den mu ikup memek tagirokko. ");
INSERT INTO wsk_vpl VALUES ("PR27_1","021_27_1","PRO","27","1","1","Ni anapeya ukurukse bitarko mu ko me gemang soraguk se kiring kaparukko, mu awuk, ni anapeya aitakta ni kema ko aratukko mu ni me ko ikisam. ");
INSERT INTO wsk_vpl VALUES ("PR27_2","021_27_2","PRO","27","2","2","Ni keta nimi me patawurko; kariimet saki nip patawumonko. ");
INSERT INTO wsk_vpl VALUES ("PR27_3","021_27_3","PRO","27","3","3","Manga se saun mu mel ikup ikup; bare kari ngualara mu gelegele kisa se gemang magara ko ikup mu, manga se saun ko ikup kiaram. ");
INSERT INTO wsk_vpl VALUES ("PR27_4","021_27_4","PRO","27","4","4","Nangamang magara ko kilek mu kariimet saki nongomang maguwuso ale ikup nungarso; bare kari bo terong se ni mena nimi ikia, ale ko gemang magara, mu ko sokel mu kalel biya nunguningkiri. ");
INSERT INTO wsk_vpl VALUES ("PR27_5","021_27_5","PRO","27","5","5","Bo ko memek wetang te la kua tui se maona mu kiwem ningo; bare kua tui se ko memek kaluwu lagara mu me sangukko. ");
INSERT INTO wsk_vpl VALUES ("PR27_6","021_27_6","PRO","27","6","6","Ka tiran yawara mu ka memek wetang te la ka manuk se lot kisu kam ko yaman ikiko, bare mu ka sangukko; bare kari ni kerak memek mu den amilmil kisok ale gira awom ka yasi lagarukko, bare mu ko sinar toko! ");
INSERT INTO wsk_vpl VALUES ("PR27_7","021_27_7","PRO","27","7","7","Kari na ko me kueso mu, na ningo ta wore am merukko; bare kari na ko kueso mu, na aguwaya ta wore am naukko. ");
INSERT INTO wsk_vpl VALUES ("PR27_8","021_27_8","PRO","27","8","8","Ni ka wonong betesam ale awar lagasam, mu nika ariga inangnang bo ko singir beteram ale lagoso iwita. ");
INSERT INTO wsk_vpl VALUES ("PR27_9","021_27_9","PRO","27","9","9","Mel siring yawara yawara mu gemang motam amilmil tuso; uwutatala, ka tiran yawara gomang motam lilim te den sangam kisiso mu gemang motam patawuso. ");
INSERT INTO wsk_vpl VALUES ("PR27_10","021_27_10","PRO","27","10","10","Ni ka tiran yawara, se ka niet ko tiran yawara, mu me nunga bitarko; tom ikup arik ale ka launuria awar bagamon mu ka tiran pingi bagoso mu am ka sangukko. ");
INSERT INTO wsk_vpl VALUES ("PR27_11","021_27_11","PRO","27","11","11","Aga kuriang, ikia sinar karogo lager se ani angamang motam amilmil te lagarikko; se awiriya aninga balu maguwurok, bare ani amilmil te la koma balikko. ");
INSERT INTO wsk_vpl VALUES ("PR27_12","021_27_12","PRO","27","12","12","Kari sinar mu ikup ari se mu, numi tagi batagarso ale kia kaposo; bare kari sinar mena mu ngual kasik geraga nama ningi kaposo ale memek arigiso. ");
INSERT INTO wsk_vpl VALUES ("PR27_13","021_27_13","PRO","27","13","13","Kari bo ni ninguru me ko ikia agi mu, nika manga mel agi mu yam ngual me tuiko; ni gir ale noko guang ningo bo to ilup asele mel ko balso mu tuiko; se nu ko guang mu ko negeruk ale pasak tairuk ko ikup kutuwurokko. ");
INSERT INTO wsk_vpl VALUES ("PR27_14","021_27_14","PRO","27","14","14","Tumong biyala kari sail ago turomola yawara tua, mu nu iki paguwurok ale ni gemang maga se manem i maukko. ");
INSERT INTO wsk_vpl VALUES ("PR27_15","021_27_15","PRO","27","15","15","Kari bo ko nuwus kore korang ining singi ago mu, tuwik tom te bom gogong te tuwik pok pok ma laga kam. ");
INSERT INTO wsk_vpl VALUES ("PR27_16","021_27_16","PRO","27","16","16","Kuring kaloko maona mu, marir kiting te iluwa ko karogo kaeya laga kam, agi oil kiting tuagu ningi iluwa ko karogo kaera iwita. ");
INSERT INTO wsk_vpl VALUES ("PR27_17","021_27_17","PRO","27","17","17","Ain te ain palungursan; uwutatala, kari nunumi kasursan. ");
INSERT INTO wsk_vpl VALUES ("PR27_18","021_27_18","PRO","27","18","18","Awiriya tam fig ko sinar taso, mu ko nunguning sang gi naukko; uwutatala, awiriya ko kari dom ko sinar taso, mu koma nup ningo taukko. ");
INSERT INTO wsk_vpl VALUES ("PR27_19","021_27_19","PRO","27","19","19","Yu ningi tatagasam ale yu ningi kema motam arigisam uwutatala, kari ko munan mu ko gomang motam wetang saposo. ");
INSERT INTO wsk_vpl VALUES ("PR27_20","021_27_20","PRO","27","20","20","Magara kuenera se kuera mateng kariimet kuesan mu nunga lakuso, bare bo karogo ko yam aiwoso; koma suanta tala, kariimet nanga namotam mel suen la ari saposo bare tom bo te me kuring arataso. ");
INSERT INTO wsk_vpl VALUES ("PR27_21","021_27_21","PRO","27","21","21","Gold se silver nunguning agi buawen mu ko ikia ko mu, tama kowar biya wore ningi kaisan ale asele ko ikisan; bare kari bo bala ningo kumik ko balu ale mel tui, se nu aguwaya koma ko bitiruk, umutang te ni kari umu kari aguwaya mu ko kiwem ikiko. ");
INSERT INTO wsk_vpl VALUES ("PR27_22","021_27_22","PRO","27","22","22","Ni supuling lagara ko kari mu kanga ko manga te ita parusuwur, agi tapiok iwita irir, bare ko ngualara mu me ta kutuwu saparko. ");
INSERT INTO wsk_vpl VALUES ("PR27_23","021_27_23","PRO","27","23","23","Ni ka sipsip se ka goat aguwaya bagasan mu ninguru nunga iki ale ninguru nunga bitaruko; ");
INSERT INTO wsk_vpl VALUES ("PR27_24","021_27_24","PRO","27","24","24","mu awuk, mel ningo ningo ilu biguwurem mu ura tui se iru me gi, mu nama menarukko; se ka nip ningo mu am menarukko tala. ");
INSERT INTO wsk_vpl VALUES ("PR27_25","021_27_25","PRO","27","25","25","Ka sipsip goat nunga na ko, sirsir bataguru bolala awur se iru aragukko. ");
INSERT INTO wsk_vpl VALUES ("PR27_26","021_27_26","PRO","27","26","26","Se sipsip mone batutumur gi ale ka guang te nunguruko; ale ka goat sang dier ale manga to ale aking ali iru te dierko. ");
INSERT INTO wsk_vpl VALUES ("PR27_27","021_27_27","PRO","27","27","27","Se ka goat sang mu nunga amin itup, ale ni ka imet kuriang ago no se, sang ka ura imet alo nungaru gurugu se namonko. ");
INSERT INTO wsk_vpl VALUES ("PR28_1","021_28_1","PRO","28","1","1","Kari memek mu kari bo nu me karoso bare am kota nguangoso nagu lagoso; bare kariimet ningo diram mu lion iwita sokel ago bagasan. ");
INSERT INTO wsk_vpl VALUES ("PR28_2","021_28_2","PRO","28","2","2","Ali sor bo ko kariimet nunga supuling nongorak tagi gurungumusan ale nunumi pagorsan mu te supuling iru iru aratasan; bare ikia nunguning se ikia ningo ko kari mu kariimet munan te la nunga bitarso se ningo la bagasan. ");
INSERT INTO wsk_vpl VALUES ("PR28_3","021_28_3","PRO","28","3","3","Kari supuling bo kariimet kituwura nunga bita maguwuso mu, tuwik ikup biya sokel karogo kaposo ale inang sarumu warso wore iwita. ");
INSERT INTO wsk_vpl VALUES ("PR28_4","021_28_4","PRO","28","4","4","Kariimet munan den nubiring tusan, mu nuna kari memek nungumik ko bala ningo balsan; bare awiriya munan den karo tusan, mu nuna kariimet memek nunga memek ko sokel karogo kapasan. ");
INSERT INTO wsk_vpl VALUES ("PR28_5","021_28_5","PRO","28","5","5","Kariimet memek bitawara mu nuna munan diram la betera ko nunguning me ikisan; bare kariimet Yawe karo tui lagasan mu ninguru ko ikisan. ");
INSERT INTO wsk_vpl VALUES ("PR28_6","021_28_6","PRO","28","6","6","Kituwura baga se kimik den mena mu yawarakala; mel suen biya ago baga se diram la me karo tua mu memek. ");
INSERT INTO wsk_vpl VALUES ("PR28_7","021_28_7","PRO","28","7","7","Kuriang munan den karo tuso, mu kuriang ikia sinar ago; bare kuriang kariimet ngual kasik lagasan mu nongorak numi giso, mu nu nuet gomang motam ikup tuso. ");
INSERT INTO wsk_vpl VALUES ("PR28_8","021_28_8","PRO","28","8","8","Awiriya manga biya te taukko ko marir manga kalel biya beteso ale taso, bare ko memek mu koma, ko manga mu geragoso ale kari bo munan ningo karogo mu kote namoso, se nu kariimet kituwura te nunga sangarso. ");
INSERT INTO wsk_vpl VALUES ("PR28_9","021_28_9","PRO","28","9","9","Awiriya munan den me karo tuso, mu Yawe noko guranek mu biriruwuso. ");
INSERT INTO wsk_vpl VALUES ("PR28_10","021_28_10","PRO","28","10","10","Awiriya kari te iluwokko mutim i beteso ale kari diram umu kulurso te ilak namoso, mu kota ningi daguloso; bare awiriya kumik den mena mu koma yawara taukko. ");
INSERT INTO wsk_vpl VALUES ("PR28_11","021_28_11","PRO","28","11","11","Kari kumik mel suen biya karogo mu kota numi ikiso mu nu ikia biya karogo iwita ikiso; bare kari kituwura ikia sinar ago mu kari mu ninguru ari kutuwuso. ");
INSERT INTO wsk_vpl VALUES ("PR28_12","021_28_12","PRO","28","12","12","Tom kari ningo diram mu nama sanamasan, mu amilmil biya kaposo; bare tom kari memek alo nama sanamasan mu kariimet nama yumu gilingisan. ");
INSERT INTO wsk_vpl VALUES ("PR28_13","021_28_13","PRO","28","13","13","Awiriya ko memek duap saguwuso, mu molak me maiso; bare awiriya ko memek duap balso ale giris palagoso, mu ko memek mu mena namoso se ningo la lagoso. ");
INSERT INTO wsk_vpl VALUES ("PR28_14","021_28_14","PRO","28","14","14","Awiriya Yawe bowa ningi baga lagoso, mu amilmilarukko; bare awiriya gomang motam aora biya mu ikup arigokko. ");
INSERT INTO wsk_vpl VALUES ("PR28_15","021_28_15","PRO","28","15","15","Kari supuling ko kiwem memek, mu ko kariimet nunga bita maguwuso se nungumik saonga mena; mu ko ariga lion memek niawoso agi bear daong ko geragawoso mu iwita. ");
INSERT INTO wsk_vpl VALUES ("PR28_16","021_28_16","PRO","28","16","16","Kari supuling kawel munan te se ko sokel te kariimet nongote melmasak giso mu nu kumik ikia ningo bo mena; bare kari supuling lage memek te mel gia mu ko me kueso mu tom maiya biya ningo la bagarukko. ");
INSERT INTO wsk_vpl VALUES ("PR28_17","021_28_17","PRO","28","17","17","Awiriya bo moram se kueram mu butata ikia moa lagaruk se yumu geraga laga kua namarukko; kariimet bo nu me ta sangukko. ");
INSERT INTO wsk_vpl VALUES ("PR28_18","021_28_18","PRO","28","18","18","Awiriya ko bagara aolak diram la mu ningo la lagoso; bare awiriya ko munan daeldel mu tairate maga namarukko. ");
INSERT INTO wsk_vpl VALUES ("PR28_19","021_28_19","PRO","28","19","19","Awiriya ko ali te kuting gege naguso, mu nu na inang mel terong la kapa tuso; bare awiriya ikia kawel karo karo bola pala lagara, mu nu kumik mel mena, kituwura lagarukko. ");
INSERT INTO wsk_vpl VALUES ("PR28_20","021_28_20","PRO","28","20","20","Kari awiriya munan diram karo tuso, mu marak ningo suen la karogo terong bagarukko; bare awiriya mel suen biya gemarukko gomang ani lagoso, mu memek taukko. ");
INSERT INTO wsk_vpl VALUES ("PR28_21","021_28_21","PRO","28","21","21","Ikup guyak ariga kam te, nanimi nangama ko nguangara ale kawel te nanimi saonga mu kiwem memek; bare kariimet sang bread biling te tamonko kiwem umu bita gilingisan. ");
INSERT INTO wsk_vpl VALUES ("PR28_22","021_28_22","PRO","28","22","22","Kari ko mel suen la ko igek se mel suen biya gemarukko gomang ani lagoso, mu kumik mel mena kituwura bagarukko tom kulukumu iram mu me ari ikiso. ");
INSERT INTO wsk_vpl VALUES ("PR28_23","021_28_23","PRO","28","23","23","Awiriya bo ko memek kasurso, mu maingte amilmil biya taukko; bare awiriya den kawel te kari gomang naso, mu maingte nup memek taukko. ");
INSERT INTO wsk_vpl VALUES ("PR28_24","021_28_24","PRO","28","24","24","Awiriya nuamnuet nunga kulurso ale nongote melmasak giso, ale numi por kaloso ale balso, “Munan mu ningi memek bo mena,” maso, mu nu memek ko memek aromemek beteso. ");
INSERT INTO wsk_vpl VALUES ("PR28_25","021_28_25","PRO","28","25","25","Kari mel suen biya ko igek, mu ko munan mu te ining singi kager tagi kariimet ningi beteso; bare awiriya Yawe te la ira sanami lagoso mu ningo la baga lagarukko. ");
INSERT INTO wsk_vpl VALUES ("PR28_26","021_28_26","PRO","28","26","26","Kari kota ko ikia te la ira sanami lagoso, mu kari ngualara; bare awiriya ikia sinar ko munan te lagoso mu memek bo me arigiso. ");
INSERT INTO wsk_vpl VALUES ("PR28_27","021_28_27","PRO","28","27","27","Kari kariimet kituwura mel nungaru lagoso, mu mel bo ko me tukunangarukko; bare awiriya nungarki daleluwu lagoso, mu bala memek kumik ko balmonko. ");
INSERT INTO wsk_vpl VALUES ("PR28_28","021_28_28","PRO","28","28","28","Kari memek mu kari supuling ko aratasan, mu kariimet nama yumu gilingisan; bare tom kua gilingisan, mu kariimet ningo diram mu sor ira gilingisan. ");
INSERT INTO wsk_vpl VALUES ("PR29_1","021_29_1","PRO","29","1","1","Kari ko memek kasuru lagasan bare am dogowa sisi lagoso mu, kam me maiyuk se memek kumik nungera mena mu arigokko. ");
INSERT INTO wsk_vpl VALUES ("PR29_2","021_29_2","PRO","29","2","2","Tom kariimet ningo diram kuwim gi gi namasan, mu amilmil biya kaposo; bare tom kari memek alo nama sanamasan, mu niara kikira biya sor ereso. ");
INSERT INTO wsk_vpl VALUES ("PR29_3","021_29_3","PRO","29","3","3","Kari ikia sinar ko kua lagoso mu nuet amilmil tuso; bare awiriya lage luan imet nongorak nagu aratu lagoso, mu ko manga mel suen biya waru saposo. ");
INSERT INTO wsk_vpl VALUES ("PR29_4","021_29_4","PRO","29","4","4","King diram la betera ko munan te sor bitarso se gek am aora la aniso; bare king kariimet nongote manga gira agowom la gi lagoso, mu sor parusuwuso maguwuso. ");
INSERT INTO wsk_vpl VALUES ("PR29_5","021_29_5","PRO","29","5","5","Munan memek betera ko kari gomang kuluka ko den mu, dagarok memek kira bita kam. ");
INSERT INTO wsk_vpl VALUES ("PR29_6","021_29_6","PRO","29","6","6","Memek betera ko kari mu ko memek umu dagarok iwita taliposo; bare kari ningo diram wur iluwok ale amilmilarukko. ");
INSERT INTO wsk_vpl VALUES ("PR29_7","021_29_7","PRO","29","7","7","Kari ningo diram mu, diram ningo la kariimet kituwura nungumik te betera mu ko sail tagi lagoso; bare kari memek mu uwuta me beteso. ");
INSERT INTO wsk_vpl VALUES ("PR29_8","021_29_8","PRO","29","8","8","Ikia sinar suwik sapara ko kari alo mu kariimet ngual nungarsan se wonong tuagu ningi kager pagoso; bare kari sinar alo mu nongomang memek ko munan biriruwu gilingisan. ");
INSERT INTO wsk_vpl VALUES ("PR29_9","021_29_9","PRO","29","9","9","Kari sinar bo munak te kari ngualara mu ilak aratukko, bare kari ngualara mu gomang magaruk se sail sail te baluk ale bala umu te ningo bo me aratukko. ");
INSERT INTO wsk_vpl VALUES ("PR29_10","021_29_10","PRO","29","10","10","Kari nuguting gue ago mu, kari munan diram la bita lagoso mu me ta ko kuesan ale nunga momon se kuemonko lage kupusan. ");
INSERT INTO wsk_vpl VALUES ("PR29_11","021_29_11","PRO","29","11","11","Kari ngualara mu ko gomang magara mu tama iwita pagoso; bare kari ikia sinar ago mu ko gomang magara mu ninguru kiti guruguso. ");
INSERT INTO wsk_vpl VALUES ("PR29_12","021_29_12","PRO","29","12","12","Kari dom biya pempem la den kawel ko dogowa gurugu lagoso, mu ko supuling alo nu bowa ningi mu kari memek ko aratu sapamonko. ");
INSERT INTO wsk_vpl VALUES ("PR29_13","021_29_13","PRO","29","13","13","Kari kituwura ta se kari nu bita maguwuso mu ta, nuna wete mu Yawe nomotam nungaram ale marak nungaram. ");
INSERT INTO wsk_vpl VALUES ("PR29_14","021_29_14","PRO","29","14","14","King bo kariimet suen la ningo la nunga beteso uwutatala kariimet kituwura nunga beteso, mu nu kam maiya biya king ko lagarukko. ");
INSERT INTO wsk_vpl VALUES ("PR29_15","021_29_15","PRO","29","15","15","Kuriang ko memek te kausa ko bu mu ikia sinar kuriang tuso; bare kuriang katir me due iluwa mu nuam gomang ikup tuso. ");
INSERT INTO wsk_vpl VALUES ("PR29_16","021_29_16","PRO","29","16","16","Tom kari memek kuwim gi gi namasan, mu kiwem memek karogo la sokel taso; bare tairate kariimet ningo diram mu nomotam te dagulu namamonko. ");
INSERT INTO wsk_vpl VALUES ("PR29_17","021_29_17","PRO","29","17","17","Ka namar kiti gurugu se noko kiwem mu gemang lila kisokko; nu gemang motam amilmil tuokko. ");
INSERT INTO wsk_vpl VALUES ("PR29_18","021_29_18","PRO","29","18","18","Tom prophet alo nunga nuguring te ko den bo me arataso, mu kariimet am ngual kasik namasan; bare awiriya Yawe ko den karo tuso mu amilmilarukko. ");
INSERT INTO wsk_vpl VALUES ("PR29_19","021_29_19","PRO","29","19","19","Ni ka ura kari due toko kiring te la me manaruko; nu nika den ikiok, bare me karo tuokko; bu tua mu nu sangukko. ");
INSERT INTO wsk_vpl VALUES ("PR29_20","021_29_20","PRO","29","20","20","Kari ngualara ma balsan mu saonga taukko lage katir karogo. Bare ikiko! Ngual kasik munakara ko kari munakoso mu saonga taukko lage bo mena. ");
INSERT INTO wsk_vpl VALUES ("PR29_21","021_29_21","PRO","29","21","21","Kari dom bo ko ura kari gotektir la mel kasik biya te kuring la karo tui lagoso, mu munan umu te maguwuram se maingte gomang bataga tuokko. ");
INSERT INTO wsk_vpl VALUES ("PR29_22","021_29_22","PRO","29","22","22","Kari ko gomang motam magara tairate mu, memek suen biya beteso, ale ining singi tagi kariimet ningi beteso. ");
INSERT INTO wsk_vpl VALUES ("PR29_23","021_29_23","PRO","29","23","23","Nanimi patawura ko munan te nup memek tasan; bare nanimi karogo kapara ko munan te nup ningo tasan. ");
INSERT INTO wsk_vpl VALUES ("PR29_24","021_29_24","PRO","29","24","24","Tere kari ilak nimi gi se atumu sangaru, mu ni keta nimi maguwusam; mu awuk, den te ka betemon bare ni ninguru duap saguwurko. ");
INSERT INTO wsk_vpl VALUES ("PR29_25","021_29_25","PRO","29","25","25","Ali imi ko kari ko nguangara mu dagarok iwita ka taliposo; bare awiriya Yawe te la ira sanami lagoso, mu terong la lagoso. ");
INSERT INTO wsk_vpl VALUES ("PR29_26","021_29_26","PRO","29","26","26","Kariimet suen biya mu nunga supuling nongomang motam tamonko karogo kaeya lagasan; bare ninguru ikinakko, Yawe kota suanta kote diram la tutera ko munan taiso. ");
INSERT INTO wsk_vpl VALUES ("PR29_27","021_29_27","PRO","29","27","27","Ningo diram la betera ko kariimet mu memek betera ko kariimet mu ninguru nunga biriruwusan; uwutatala, memek betera ko kariimet mu ningo diram la betera ko kariimet mu ninguru nunga biriruwusan tala. ");
INSERT INTO wsk_vpl VALUES ("PR30_1","021_30_1","PRO","30","1","1","Imi kari Agur, Jakeh ko namar, ko bala sang. Nu den imi Ithiel se Ucal iwita nunga maonam: ");
INSERT INTO wsk_vpl VALUES ("PR30_2","021_30_2","PRO","30","2","2","“Ani am kari ngualara bo nunguningkiri, ani kari ko iwita ikia me taem. ");
INSERT INTO wsk_vpl VALUES ("PR30_3","021_30_3","PRO","30","3","3","Ani ikia sinar ko den ko katir me sinarerem, ale Doleng Suan mu ko ikia ningo bo aningate mena. ");
INSERT INTO wsk_vpl VALUES ("PR30_4","021_30_4","PRO","30","4","4","Kariimet i bo duruk uningi nama tarigiram ale aking tai kaparam? Kariimet i bo marir kuting tuagu ningi iluwokko terong? Kariimet i bo gagi lilim la guang bo te ilu kalokko terong? Kariimet i bo ali imi lilim la ko duap ago nungam se aniso? Nina ko nup ikisan agi mu aga maonalko, ale ko namar ko nup ago aga maonalko! ");
INSERT INTO wsk_vpl VALUES ("PR30_5","021_30_5","PRO","30","5","5","“Kaem ko den suen la mu arigiman am nunguning se diram la; awiriya nu kote nagu namasan, mu nu nunga karem se nunga kaluwuso. ");
INSERT INTO wsk_vpl VALUES ("PR30_6","021_30_6","PRO","30","6","6","Noko den bo me ta ka ikia te kunasirko; mu awuk, nu ining kisok ale ka kawel mu wetang saparukko. ");
INSERT INTO wsk_vpl VALUES ("PR30_7","021_30_7","PRO","30","7","7","“O Yawe, ani me kua namasam la, ni mel ilagala ani aisuko ka isarsam: ");
INSERT INTO wsk_vpl VALUES ("PR30_8","021_30_8","PRO","30","8","8","Aga sangaru se den nunguning la balik ale kawel munan mu abiring tuekko; ani aga sangaru se angimik mel ago bagarikko me balsam, agi aga sangaru se angimik mel mena bagarikko me balsam tala, bare aga sangaru se ningo la baga se lagarikko. ");
INSERT INTO wsk_vpl VALUES ("PR30_9","021_30_9","PRO","30","9","9","Ani mel suen biya ago baga se mu, ni Yawe abiring kisek ale mel yam ko ka balik bore ko; agi angimik mel mena baga se tere naik ale ni aga Kaem nip maguwurik bore ko. ");
INSERT INTO wsk_vpl VALUES ("PR30_10","021_30_10","PRO","30","10","10","“Ura kari bo ko dom koma te me balu maguwurko, mu awuk, ura kari mu bala ikup kimik ko baluk se ni mel umu nunguruko. ");
INSERT INTO wsk_vpl VALUES ("PR30_11","021_30_11","PRO","30","11","11","“Kuriang saki nunga nonet bala ikup nunga manorsan, ale nunam alo den amilmil me nunga manorsan. ");
INSERT INTO wsk_vpl VALUES ("PR30_12","021_30_12","PRO","30","12","12","Kariimet saki nuna nunumi arigisan mu nuna nungumik ikup mena ma balsan, bare nuna memek biya ago bagasan. ");
INSERT INTO wsk_vpl VALUES ("PR30_13","021_30_13","PRO","30","13","13","Kariimet saki nuna nunumi patawusan ale nomotam kualala kualala la loagasan. ");
INSERT INTO wsk_vpl VALUES ("PR30_14","021_30_14","PRO","30","14","14","Aking kariimet saki mu kausik diwang nogore daong karogo memek iwita, kariimet kituwura nungumik saonga mena mu nunga moa batutumu namonko iwita geragasan. ");
INSERT INTO wsk_vpl VALUES ("PR30_15","021_30_15","PRO","30","15","15","“Mel suen biya ni la bowa tuguma ko munan mu nanawusari ilagala: bo ko nup mu Aisuko, se bo mu ko nup Aisuko tala. Uwutatala, mel 3 agi 4 imi terong mam ma bala me ikisan, bo ago ko bala mu la ikisan: ");
INSERT INTO wsk_vpl VALUES ("PR30_16","021_30_16","PRO","30","16","16","Bo mu kuera mutim, bo mu imet kuin sisira se kuriang ko nia lagoso, bo mu ali garagarayam yu ko nia lagoso, se bo mu tama gigip kumik ira mena. Mel 4 imitang mu terong mam bala me ikisan. ");
INSERT INTO wsk_vpl VALUES ("PR30_17","021_30_17","PRO","30","17","17","“Awiriya nuet ari daleluwuso, agi nuam ngata tuso, mu kari uwuta mu ilak nama sapara se taraga sengkasik mel taimon ale motam kuagi atumu namon ale kumik guang batutumu namonko. ");
INSERT INTO wsk_vpl VALUES ("PR30_18","021_30_18","PRO","30","18","18","“Mel 3 agi 4 imi mu am mel duap bo nunguningkiri, se ani ko iki saparikko me terong: ");
INSERT INTO wsk_vpl VALUES ("PR30_19","021_30_19","PRO","30","19","19","taraga ko munan taiti gomang te mu, mot ko munan manga awote mu, dal gagi biya awote ko munan mu, se kari imet ilak anira ko munan. ");
INSERT INTO wsk_vpl VALUES ("PR30_20","021_30_20","PRO","30","20","20","“Imet kari ilak diram bagara mena ko munan mu, kari kigilik ilak tere naso ale numi nungurso ale balso, ‘Mel bo ningi memek mena,’ iwita balso. ");
INSERT INTO wsk_vpl VALUES ("PR30_21","021_30_21","PRO","30","21","21","“Munan 3 agi 4 imi arataso mu memek biya se ali wanara ko kaposo: ");
INSERT INTO wsk_vpl VALUES ("PR30_22","021_30_22","PRO","30","22","22","Ura kari yam king kuwim taso, kari ngualara wore kumik ko na inang suen biya, ");
INSERT INTO wsk_vpl VALUES ("PR30_23","021_30_23","PRO","30","23","23","ari mera imet bo laga, mena ningi kari taso, se ura imet ko dom imet kuwim taso ale ko dom kari mu ilak naso giso. ");
INSERT INTO wsk_vpl VALUES ("PR30_24","021_30_24","PRO","30","24","24","“Ali imi te mel gotektek ilagala ilagala imi anisan, nuna gotektek nunguningkiri, bare ikia sinar ago: ");
INSERT INTO wsk_vpl VALUES ("PR30_25","021_30_25","PRO","30","25","25","Madidir mu nosokel gotektir, bare nuna tom udagi inang mena mu ko iki kam inang gi bolala awu gilingisan. ");
INSERT INTO wsk_vpl VALUES ("PR30_26","021_30_26","PRO","30","26","26","Se madar mu betela nosokel gotektir, bare nunga singir mu yumura te nunguningkiri te kalo gilingisan. ");
INSERT INTO wsk_vpl VALUES ("PR30_27","021_30_27","PRO","30","27","27","Se locust mu nungumik king mena, bare nunga paoga paoga te nunumi nogowom kaora la binga gilingisan. ");
INSERT INTO wsk_vpl VALUES ("PR30_28","021_30_28","PRO","30","28","28","Se makina gotektek mu kiting te am ilupko terong, bare nuna king ko kawam ningi agotala baga gilingisan. ");
INSERT INTO wsk_vpl VALUES ("PR30_29","021_30_29","PRO","30","29","29","“Mel 3 agi 4 imi yawarakala se sokel ago aolak ilusan: ");
INSERT INTO wsk_vpl VALUES ("PR30_30","021_30_30","PRO","30","30","30","Lion mu mel aora bo tala, mel bo noko aolak me siruwuso; ");
INSERT INTO wsk_vpl VALUES ("PR30_31","021_30_31","PRO","30","31","31","se tarak anumang se goat anumang mu nusupuling patawusan ale aolak ilusan; se king mu wuli karogo ko kager kari nongorak namoso. ");
INSERT INTO wsk_vpl VALUES ("PR30_32","021_30_32","PRO","30","32","32","“Ni ngualara kilek beterem ale keta nimi patawurem, agi memek bitarko ikia nungem mu, kiting karogo tarigi usir ale ikia toko! ");
INSERT INTO wsk_vpl VALUES ("PR30_33","021_30_33","PRO","30","33","33","Mu awuk, ni bulmakau ko amin kiri guruguwer, mu pakongaruk ale butter ko geragukko; ale kuamuru ita, mu gue kaparukko; uwutatala, ni kari saki nongomang maguwur, mu kager barasukko.” ");
INSERT INTO wsk_vpl VALUES ("PR31_1","021_31_1","PRO","31","1","1","Imi King Lemuel ko bala saki ko nuam kausam: ");
INSERT INTO wsk_vpl VALUES ("PR31_2","021_31_2","PRO","31","2","2","“Ikiko, aga namar! Ni ani atagu ningi bilangerem; ni aninga guranek ko nunguning. Ni ninguru ikiko! ");
INSERT INTO wsk_vpl VALUES ("PR31_3","021_31_3","PRO","31","3","3","Ni imet nungumik te nimi me saparko, imet uwuta mu king suen biya nunga maguwuman. ");
INSERT INTO wsk_vpl VALUES ("PR31_4","021_31_4","PRO","31","4","4","“O Lemuel, ikiko! Yu aora nana mu king alo nunga munan mena; yu aora nana ko kaera mu supuling alo nunga munan mena. ");
INSERT INTO wsk_vpl VALUES ("PR31_5","021_31_5","PRO","31","5","5","Mu awuk, nuna yu aora namon ale munan kaloman wore nungamili saparuk se kariimet kituwura alo nunga bita maguwumon bore ko. ");
INSERT INTO wsk_vpl VALUES ("PR31_6","021_31_6","PRO","31","6","6","Yu aora mu, kariimet kuemonko negawasan agi, kariimet ikup bibiya nunga iramuram se anisan wore nunga mel. ");
INSERT INTO wsk_vpl VALUES ("PR31_7","021_31_7","PRO","31","7","7","Namon ale nunga yaman se nunga ikup ko nungamili saparukko. ");
INSERT INTO wsk_vpl VALUES ("PR31_8","021_31_8","PRO","31","8","8","“Arikaya kituwura se nongota nunumi sangarmonko me terong mu nunga sangaruko. ");
INSERT INTO wsk_vpl VALUES ("PR31_9","021_31_9","PRO","31","9","9","Kituwura alo nunga bitua ko munan diram la ko, sokel karogo balu ale nunga sangaruko.” ");
INSERT INTO wsk_vpl VALUES ("PR31_10","021_31_10","PRO","31","10","10","Imet ningo nunguningkiri ninguru ariga ale ta mu mel yawara nunguningkiri; imet uwuta mu diamond kiaram. ");
INSERT INTO wsk_vpl VALUES ("PR31_11","021_31_11","PRO","31","11","11","Se ko kuari ningo diram la ko iki lagoso, ale mel ningo bo ko me tukunangaso. ");
INSERT INTO wsk_vpl VALUES ("PR31_12","021_31_12","PRO","31","12","12","Nu pempem kuari kote ningo la bita lagoso, ale memek bo kumik te me beteso. ");
INSERT INTO wsk_vpl VALUES ("PR31_13","021_31_13","PRO","31","13","13","Nu kuting kiwol nuam, se sipsip mone se mel saki karogo giso ale guang mel se siru samer duap duap nungurso. ");
INSERT INTO wsk_vpl VALUES ("PR31_14","021_31_14","PRO","31","14","14","Nu dal biya awar inang gi laga karogo taiso, iwita beteso. ");
INSERT INTO wsk_vpl VALUES ("PR31_15","021_31_15","PRO","31","15","15","Nu tumong biyala barasoso ale ko kari, ko kuriang, se ko ura imet lilim nunga inang nungurso. ");
INSERT INTO wsk_vpl VALUES ("PR31_16","021_31_16","PRO","31","16","16","Nu ali bilik ko iki guruguwa dia taso, ale ko manga nukum mu te waen ningam aguso. ");
INSERT INTO wsk_vpl VALUES ("PR31_17","021_31_17","PRO","31","17","17","Nu imet sokel ago, se ko ura suen la sokel ago bita lagoso. ");
INSERT INTO wsk_vpl VALUES ("PR31_18","021_31_18","PRO","31","18","18","Noko diara guruga ninguru ko sinar taso ale manga terong taso; ale tirom karogo la ura iluso. ");
INSERT INTO wsk_vpl VALUES ("PR31_19","021_31_19","PRO","31","19","19","Noko kuting mayang te irukokko mu guyak. ");
INSERT INTO wsk_vpl VALUES ("PR31_20","021_31_20","PRO","31","20","20","Nu kariimet kituwura se mel ko tukunangawara mu nunga sangaru saposo. ");
INSERT INTO wsk_vpl VALUES ("PR31_21","021_31_21","PRO","31","21","21","Marir birigira ko kam ningi mu nu me ikia moso, mu awuk, noko kawam digo ko kariimet guang nungumik te eremonko mu terong la. ");
INSERT INTO wsk_vpl VALUES ("PR31_22","021_31_22","PRO","31","22","22","Nu guang anira kuwim te irokko mu biriso; ale ko guang nagurokko mu yawarakala nunguningkiri. ");
INSERT INTO wsk_vpl VALUES ("PR31_23","021_31_23","PRO","31","23","23","Se ko kuari mu kariimet ko amilmilasan se nu wonong ko supuling bo bagoso. ");
INSERT INTO wsk_vpl VALUES ("PR31_24","021_31_24","PRO","31","24","24","Noko imet mu guang yamel se mayang nunulan te kaola ko mu nungurso ale diara kariimet nongorak diaso. ");
INSERT INTO wsk_vpl VALUES ("PR31_25","021_31_25","PRO","31","25","25","Noko bagara aolak mu ningo diram se sokel ago; ale tom taiwoso mu ko anapeya mu ko me ikia moso. ");
INSERT INTO wsk_vpl VALUES ("PR31_26","021_31_26","PRO","31","26","26","Nu ikia sinar ago munakoso, ale noko kuring te mu diram la kiti guruga ko den arataso. ");
INSERT INTO wsk_vpl VALUES ("PR31_27","021_31_27","PRO","31","27","27","Nu ko kawam digo lilim la ninguru bitarso, ale gagor munan me ikiso. ");
INSERT INTO wsk_vpl VALUES ("PR31_28","021_31_28","PRO","31","28","28","Se ko kuriang den ningo ningo kumik ko balsan; kuari betela beteso ale amilmil tuso. ");
INSERT INTO wsk_vpl VALUES ("PR31_29","021_31_29","PRO","31","29","29","Ale manarso, “Imet suen biya kiwem ningo ningo betesan, bare ni am nunga kia saperem.” ");
INSERT INTO wsk_vpl VALUES ("PR31_30","021_31_30","PRO","31","30","30","Imet ko munak welang welang mu kawel te am ka saparukko; se aking koma motam kumik ko bala mu tom maiya biya me aniso; bare imet Yawe bowa ningi lagoso mu nup biya taukko. ");
INSERT INTO wsk_vpl VALUES ("PR31_31","021_31_31","PRO","31","31","31","Buta se ko munan ningo suen la mu ko amilmil biya tualko; se biguwura motam te ko kiwem ningo mu ko karogo la nup ningo taukko. ");
INSERT INTO wsk_vpl VALUES ("IS1_1","024_1_1","ISA","1","1","1","Kausa yum