﻿USE sofia;
DROP TABLE IF EXISTS sofia.wrs_vpl;
CREATE TABLE wrs_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES wrs_vpl WRITE;
INSERT INTO wrs_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","1","Nemetva seilva owai, mani mani lohvnamoa, wo Sesoava sism vena ovm petham manam manam. ");
INSERT INTO wrs_vpl VALUES ("GN1_2","002_1_2","GEN","1","2","2","Pethava seilva beswonamba lohvnamoa, osva memba daipotava lohvpa. Owai, nis lohvna, mendah andrava eunumbulva lohvna. Pomba vavawonam livna pethasrava. Okombava owai, wo upsilva lohvnamoa, singas kilvralohvna, wo Sesoasongolva posra sena lohmana vevna. ");
INSERT INTO wrs_vpl VALUES ("GN1_3","002_1_3","GEN","1","3","3","Doa Sesoava ona, upsil lovhoara, wo noinda upsilva wohlovhoana. ");
INSERT INTO wrs_vpl VALUES ("GN1_4","002_1_4","GEN","1","4","4","Sesoava nonglana, lehra besal. Doa himba henga ona, upsilva lohv, simba lohv, hovra kava moang vethav samblam, sia eva upsil. ");
INSERT INTO wrs_vpl VALUES ("GN1_5","002_1_5","GEN","1","5","5","Upsilmba himba ona, okomba, wo simba himba ona, sia. Doa simba kilvranamba, lingil lihanamba, wo os doa simba mongasal vena. ");
INSERT INTO wrs_vpl VALUES ("GN1_6","002_1_6","GEN","1","6","6","Doa Sesoava henga ona, doa pomba pethara vavawonam liv, doa pooa mongo sena lira, wo ambsa hovra lohra. ");
INSERT INTO wrs_vpl VALUES ("GN1_7","002_1_7","GEN","1","7","7","Wo himba osangas vena, venamba, ona, nomba pomba livnamba, doa kava momong vindai, sena eva pethara, wo ambsava hovrava lohv, ");
INSERT INTO wrs_vpl VALUES ("GN1_8","002_1_8","GEN","1","8","8","os nengthai, ov. Doa sia kilvranamba, lingil lihanamba, wo os simba sambla doa vewolna. ");
INSERT INTO wrs_vpl VALUES ("GN1_9","002_1_9","GEN","1","9","9","Doa Sesoava henga ona, pomba pethara vavawonam liv, doa hivraprara, hovrangas lira, pethaoa mongnahalmoa wohhivhoara. Doa noinda pomba os wohlina, ");
INSERT INTO wrs_vpl VALUES ("GN1_10","002_1_10","GEN","1","10","10","wo Sesoava ona, doa pethava hivhoai, pomba mongnahalva doa hivrangai, wo noinda himba osva sevrana, wanplomb. Sesoava ona nonglana, besal lehra. ");
INSERT INTO wrs_vpl VALUES ("GN1_11","002_1_11","GEN","1","11","11","Doa Sesoava henga ona, mani mani vlelna phora pethara. Nelus phora, hlalm, ti phora movolnahonam. ");
INSERT INTO wrs_vpl VALUES ("GN1_12","002_1_12","GEN","1","12","12","Wo noinda mani mani vlelna phona, wo Sesoava nonglana, lehra. ");
INSERT INTO wrs_vpl VALUES ("GN1_13","002_1_13","GEN","1","13","13","Doa sia kilvranamba, lingil lihanamba, wo os simba samblamong doa penngiliha vungana. ");
INSERT INTO wrs_vpl VALUES ("GN1_14","002_1_14","GEN","1","14","14","Doa Sesoava henga ona, upsiloa ovraoa lovahvra. Mongo okombanam lohra, wo mongova sinim lovahvra. Upsilva nomba si indhanamba indthueinvav mingum, wo tahonm, wo tihvohm. ");
INSERT INTO wrs_vpl VALUES ("GN1_15","002_1_15","GEN","1","15","15","Upsilva sena lovahvra ovra, wo petharam lovhoapuv vevra. ");
INSERT INTO wrs_vpl VALUES ("GN1_16","002_1_16","GEN","1","16","16","Wo osoa Sesoa vewolna upsilmba mendeklimba sambla. Mendekliva okomba, eusilva weis. Mendekliva okombahul lohv, wo eusilva sinim lohv. Doa hengava Sesoava paim mindnam vewol vena. ");
INSERT INTO wrs_vpl VALUES ("GN1_17","002_1_17","GEN","1","17","17","Honamba Sesoava ovra wosana, okombam, weism, paim. Upsilva honamba sena ovrava lovahvna, petharam lovhoapuv vevna, ");
INSERT INTO wrs_vpl VALUES ("GN1_18","002_1_18","GEN","1","18","18","okombanam sinim. Doa Sesoava nonglana, lehra. ");
INSERT INTO wrs_vpl VALUES ("GN1_19","002_1_19","GEN","1","19","19","Doa sia kilvranamba, lingil lihanamba, wo os simba samblasambla doa penngiliha vungana. ");
INSERT INTO wrs_vpl VALUES ("GN1_20","002_1_20","GEN","1","20","20","Doa henga Sesoava ona, wanplombra lohra mani mani, snanovna snanovna lohra mindkombaiwonam. Tuawaoa mindnam ovra senamonam ahallohvra. ");
INSERT INTO wrs_vpl VALUES ("GN1_21","002_1_21","GEN","1","21","21","Wo honamba os phona. Wanplombrava Sesoava vena tambkomba mendeklim eva eusilm, wo manatuawom, manatuawom nerava os vena. Sesoava ona nongalna, beswonam lehra kava vei. ");
INSERT INTO wrs_vpl VALUES ("GN1_22","002_1_22","GEN","1","22","22","Doa Sesoava awothowol vena, unna, yeoa onganglara towand vislihavm, verava, wanplombra kekel vethara, wo tuawamba unna, yeoa neraoa mindnam pho. ");
INSERT INTO wrs_vpl VALUES ("GN1_23","002_1_23","GEN","1","23","23","Doa sia kilvranamba, lingil lihanamba, wo os simba 5pelara doa penngiliha vungana. ");
INSERT INTO wrs_vpl VALUES ("GN1_24","002_1_24","GEN","1","24","24","Doa henga Sesoa ona, tata mani mani phongavra hona pethara, deuvrini, sungeitrini, eusil noi mani mani, eva mendekli noi mani mani. ");
INSERT INTO wrs_vpl VALUES ("GN1_25","002_1_25","GEN","1","25","25","Wo osoa vewol vena tatam manam manam, wo Sesoava nongalna, lehra. ");
INSERT INTO wrs_vpl VALUES ("GN1_26","002_1_26","GEN","1","26","26","Doa henga Sesoava ona, indhanam pioa vewol velvohra, wo himba si os undna avav, men piv avm. Hev si kuwulva wulvahunvav tambkona, tuawana, wo eva tatana. ");
INSERT INTO wrs_vpl VALUES ("GN1_27","002_1_27","GEN","1","27","27","Wo Sesoava indhanam vewole, os hev ten undna avm, doa tendorinim ungevlirinim vewolna, ");
INSERT INTO wrs_vpl VALUES ("GN1_28","002_1_28","GEN","1","28","28","awothowolna, ona, yeoa towand evevm, verava, yetindioa hona petharaoa kekel vethara, si hengas beswonam vaohuthuivav. Yemba kava vinv, osm yimba si vaohohothovav tambkom, tuawam, tatam manam manam hona petharava. ");
INSERT INTO wrs_vpl VALUES ("GN1_29","002_1_29","GEN","1","29","29","Wo Sesoava os henga unna, ehello, innemba yenamba men luhunv hona pethara, nelus, timov mani mani, yemba doa kava vewol vinna, doa eneo. ");
INSERT INTO wrs_vpl VALUES ("GN1_30","002_1_30","GEN","1","30","30","Tatana innemba tuawanamba men luhunv, pos, tevla, timov, hem kava vewol vinna memba. Wo Sesoava osva onamba, osoa phona, ");
INSERT INTO wrs_vpl VALUES ("GN1_31","002_1_31","GEN","1","31","31","wo hev momo vena, indk vethavna, lehrangas kava vena ovrava, petharava, wandava, porava, sungeitrava, deuvrava, beswonamangas kava vena. Doa sia kilvranamba, lingil lihanamba, wo os simba 6pelara doa penngiliha vungana. ");
INSERT INTO wrs_vpl VALUES ("GN2_1","002_2_1","GEN","2","1","1","Doa osva Sesoava vewolna ovm petham, wo indakonda hevnavhora lohpravna, mani mani mani. ");
INSERT INTO wrs_vpl VALUES ("GN2_2","002_2_2","GEN","2","2","2","Doa sapturava Sesoa nonglana, ona, andrava kavnamba doa kava vepiana, hengava kava ata andra vevavmoa. ");
INSERT INTO wrs_vpl VALUES ("GN2_3","002_2_3","GEN","2","3","3","Ona, andrava kava vungavnamba, englava kava tatongavna, venamba, mongona englava mongasal tovhoana. Wo noinda himba saptumba hevelm kanothona no minguram, no minguram osangas. Osm annind annind pethanindva kamba ningminivra, sembayangna okolawulangavra. ");
INSERT INTO wrs_vpl VALUES ("GN2_4","002_2_4","GEN","2","4","4","Yaweva (Sesoava) os vena ovm petham, wo moamba mongmomba men lohv os. Yawe petham ovm vena, ");
INSERT INTO wrs_vpl VALUES ("GN2_5","002_2_5","GEN","2","5","5","pomba ovriniva mendah owai, wolaihapravnamoa, wo noinda sungeitva lohvnamoa. Indhanamba mendah owai, noinda osomba vivnamoa, wo noinda denwitva osonnamba owai, lohvnamoa petharava. ");
INSERT INTO wrs_vpl VALUES ("GN2_6","002_2_6","GEN","2","6","6","Pomba hasvovnamoa, ambo pethamerini lohosa vena. Phonamba, vena, os gavna, os gavna, pethava uwulila vetha vungu vevna. ");
INSERT INTO wrs_vpl VALUES ("GN2_7","002_2_7","GEN","2","7","7","Doa Yawe petha psevra, tendorinilm noi weis vre. Doa povsiha vemnana lomosmera, noinda tendoriniva vavatan venamba, pholahanga. ");
INSERT INTO wrs_vpl VALUES ("GN2_8","002_2_8","GEN","2","8","8","Doa Yawe denwit wolana di mongona pethara, ten okomba pholohvm. Pethava nomba os nengthavna, Iten, wo no petharava, no tendorinim hev venam, di desvhoana hemba. ");
INSERT INTO wrs_vpl VALUES ("GN2_9","002_2_9","GEN","2","9","9","Doa di hev tim ve, vevna snanovna snanovna, besal novna, besal movolva endwol vevna, hlalm. Wo no denwitmusra mongova timovpa lohvna, honamba indhanariniva nevrava, si dahavavmoa, yunalm si wohamana vevav. Wo mongova eva lohvnata, honamba indhanariniva netava, hev si wohlihavav, memba mona besal, temba monakokla. ");
INSERT INTO wrs_vpl VALUES ("GN2_10","002_2_10","GEN","2","10","10","Wo mongo pomba diva livna Iten pethara, osm denwitmusrava noi sihavna. Doa nomini venamba, pomba nomba kalakula velaha, vena ihilvna, ihilvna, ");
INSERT INTO wrs_vpl VALUES ("GN2_11","002_2_11","GEN","2","11","11","mongova os ningthivna Pison, mongova os ningthivna Gihon, mongova os ningthivna Tikris, mongova os ningthivna Yupretis. Pomba Pisonmba weisming vrena mongom petham, os ningthivna Havila petha, wo diva golva lohvna, ");
INSERT INTO wrs_vpl VALUES ("GN2_12","002_2_12","GEN","2","12","12","golva besal. Diva timba lovahvnamba, nenelva teihnungva besal vinvna, os uvna, deliam. Wo diva eva honmba nalohuku vevna, honmba nomba besal, wo diva mindnam lohv, os nengsm uvna, oniks. ");
INSERT INTO wrs_vpl VALUES ("GN2_13","002_2_13","GEN","2","13","13","Wo pomba Gihonmba weisming vrena mongom petham, os ningthivna Kus petha. ");
INSERT INTO wrs_vpl VALUES ("GN2_14","002_2_14","GEN","2","14","14","Wo eva pomba Tikrisva os gana, venamba, Asiria pethara nohalm, ten okomba pholohvm. Doa pomba mongova os ningthivna Yupretis. ");
INSERT INTO wrs_vpl VALUES ("GN2_15","002_2_15","GEN","2","15","15","Doa Yaweva no tendorinim desvhoana Itenda, omnana, denwitmusra hui ao, wo beswonam lengwol vawovm, kekalvho vewol vevm. ");
INSERT INTO wrs_vpl VALUES ("GN2_16","002_2_16","GEN","2","16","16","Honaoa inneoa yeoa nevm, timov mani mani hona denwitrinioa. ");
INSERT INTO wrs_vpl VALUES ("GN2_17","002_2_17","GEN","2","17","17","Heva os yimba manam nevav nomba timovpa, kava os ona, yimba netava, yimba pev si wohlihavav, memba mona besal, wo temba monakokla. Yemba kava ovomnav no timovpa, wo yimba netava, nonamba lohvav yenamba dahalmba. ");
INSERT INTO wrs_vpl VALUES ("GN2_18","002_2_18","GEN","2","18","18","Doa Yaweva ona, osva sahokla vev, tendoriniva hevhoangas amana vevra. Sehelm ka vemnara, ora hev, wo mongawulm ahamana evevra, andra evevra. ");
INSERT INTO wrs_vpl VALUES ("GN2_19","002_2_19","GEN","2","19","19","Doa petha psevra, wo no pethanamba tuawam manam manam, tatam manam manam, nom os weis vewol vena. Doa nomba wongana, tendorinim os omnana, es yimba nihilva awowol vevav? Doa tendorini nihilm awowol ve, wo nihilva noi wohluhunvna. ");
INSERT INTO wrs_vpl VALUES ("GN2_20","002_2_20","GEN","2","20","20","Vevna, deuvrinim awowol vena, sungeitrinim awowol vena, tuawam awowol vena. Heva os tendoriniva hevna sehelmba nonglanamoa, hev ahamana evelm. ");
INSERT INTO wrs_vpl VALUES ("GN2_21","002_2_21","GEN","2","21","21","Doa Yaweva tendorinim ninmind vrena, himba ninpolva livnamba, doa Sesoa almangkel tendorinina velavra, henga ehlathamnana nihilmba, ");
INSERT INTO wrs_vpl VALUES ("GN2_22","002_2_22","GEN","2","22","22","doa ungevlirinim vena no tendorinina almangalnamba, tendorini indamba wainga. ");
INSERT INTO wrs_vpl VALUES ("GN2_23","002_2_23","GEN","2","23","23","Tendorini ona, pai, menta kanamba sehelva, snal men kav lohvm. Kelva henamba kana kellini, nihilva henamba kana nihillini. Sesoava kana kelna veiva, noinda yunam kava os awov, ungevlirinim, manara, tendorinina nihrini himba velavrana. ");
INSERT INTO wrs_vpl VALUES ("GN2_24","002_2_24","GEN","2","24","24","Doa nom lihvriv, tendoriniva aralavalmba pewolehawol veiva, wo ongali enewolkohowolvav, wo os hemba nilhawolvav mongawa nihnamba. ");
INSERT INTO wrs_vpl VALUES ("GN2_25","002_2_25","GEN","2","25","25","Seilva nihps os ahamana evevna, louva evevnamoa, owai. ");
INSERT INTO wrs_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","1","Yaweva manam manam vewol vena sungeitrava, wo saiholana moakokomomba, sungeitriniva an ata eva lipiangata owai. Doa saihola os osahmanana ungevlirinim, es hevpa Sesoava yemba tanam ovunnama, osva onama, manam yimba enevav honamba timovpa? ");
INSERT INTO wrs_vpl VALUES ("GN3_2","002_3_2","GEN","3","2","2","Ungevliriniva os ona, owai, kava enevra timovpa honamba, memba denwitva endungu vevpa, ");
INSERT INTO wrs_vpl VALUES ("GN3_3","002_3_3","GEN","3","3","3","wo mongova temba lohvpa hovrava, kamba os ovunna, manam yimba enevav, manam yimba ekivravav, yimba enetava, nonamba luhunvav yenamba endahawolalmba. ");
INSERT INTO wrs_vpl VALUES ("GN3_4","002_3_4","GEN","3","4","4","Saihola omnana, owai osva, yemba si osva endahawolvavmoa. ");
INSERT INTO wrs_vpl VALUES ("GN3_5","002_3_5","GEN","3","5","5","Yimba enerava nomba timovpa, yimba si tit evevavmoa, yimba si os elihavav, os ten hev Sesoa avm. Noinda yimba woh elihavav, memba mona besal, wo temba monakokla. Sesoava hevpa honam nengna, wo noinda yemba osva ovunna. ");
INSERT INTO wrs_vpl VALUES ("GN3_6","002_3_6","GEN","3","6","6","Doa ungevliriniva nom tim ona nonglana, pai, timba besal hevm lohv, movolva beswonam hlav, wo ata kava nerava, ata kava wohlihavav. Doa noinda puetve, puetvenamba, ne, wo tlalm waine. ");
INSERT INTO wrs_vpl VALUES ("GN3_7","002_3_7","GEN","3","7","7","Doa enenamba, elihana, wo hevm enonglowole, doa nonora, nihps pivva elohv. Doa fikvla mendekli kuendowol evenamba, evethowole. ");
INSERT INTO wrs_vpl VALUES ("GN3_8","002_3_8","GEN","3","8","8","Doa moakokonam ehellevna, Yaweva men lohmana vev denwitmusra, doa ekithoho tikmonam lounapenam, ");
INSERT INTO wrs_vpl VALUES ("GN3_9","002_3_9","GEN","3","9","9","tendorinim osahanga vemna, yimba hi av? ");
INSERT INTO wrs_vpl VALUES ("GN3_10","002_3_10","GEN","3","10","10","Tendorini ona, yemba kava hellev, men denwitmusra, wo pem kava veiva, noinda kava kithav, kava nihps lohv. ");
INSERT INTO wrs_vpl VALUES ("GN3_11","002_3_11","GEN","3","11","11","Yawe ona, es yimba veiva, wo noinda yimba elihav, yimba nihps lohv? Yimba dihi nei timovpa, nomba yemba temba kava ovunnamba a? ");
INSERT INTO wrs_vpl VALUES ("GN3_12","002_3_12","GEN","3","12","12","Tendorini ona, ungevlirini kana ongal, ye kam men vrahonam, he kamba timovpa putrahoiva, noinda kava nei. ");
INSERT INTO wrs_vpl VALUES ("GN3_13","002_3_13","GEN","3","13","13","Yawe omnana ungevlirinim, manara hevpa yimba honamba vei? Ungevlirini ona, saihola kamba wuho ovrei, noinda kava doa nei. ");
INSERT INTO wrs_vpl VALUES ("GN3_14","002_3_14","GEN","3","14","14","Doa Yawe saiholam omnana os, honamba yimba doa vei, eva yemba kava esesm henga venav. Kinwondava yemba kava plothomnav ora i. Yemangas kava sahokla vrev, tatamba owai, yemangas. Osm enangas yimba si lohmana vevra, wo klesal yimba si nelohmana vevav innemba, verava, yemba si os dahavav. ");
INSERT INTO wrs_vpl VALUES ("GN3_15","002_3_15","GEN","3","15","15","Yemba kava os venav, yimba ungevlirinina ungund, eva ungevliriniva yena ungund. Eva kava verava, yetindiva muskonam vinvra hona ungevlirinina towandmba, si yenam osangas yunalm. Honamba ungevlirinina towandalliniva si yemba nonglavrava, si yena kumba singthavav, wo yimba si hemba monglaval kangthovav. ");
INSERT INTO wrs_vpl VALUES ("GN3_16","002_3_16","GEN","3","16","16","Doa Yawe ungevlirinim omnana, timovpa yimba doa nei, noinda yimba enamba avrava, yemba si kinsombva mendekli plothomnavra. Wo yemba kelathamnavrava, otolmba lengalmba, nihsesoa yemba nonam si venavav kanamini. Si os kava vevra, heva os yimba mendah tlapevmba si os omnavav, kana tlal, hevna keusingi waiamana vevav. ");
INSERT INTO wrs_vpl VALUES ("GN3_17","002_3_17","GEN","3","17","17","Yawe tendorinim omnana, yimba doa ongapevna moam helleiva, wo ne timovpa, nomba temba yemba kava ovunnamba. Osm memba yimba evei, kava pethava si indkokla vrevav, wo innemba beswonamba si phovavmoa hevpa. Yimba si pev mendekli andra vevra aiv, yimba si os innemba nevra. Osangas vaomana vevrava, wo dahara. ");
INSERT INTO wrs_vpl VALUES ("GN3_18","002_3_18","GEN","3","18","18","Yimba osomba vevrava, wo mana vema si solna phovra, ilva si sahoklal phovra, os yimba osonnamba nevav. ");
INSERT INTO wrs_vpl VALUES ("GN3_19","002_3_19","GEN","3","19","19","Andrava yimba si os vevav, vevra, ehala ve, wo innemba yemba os si phomnavra hona petharava. Yunalm yimba si andra vaomana vevav, wo vevrava, dahara, wo pethalm henga si yemba nilhavav. Tanam yemba kava pethana vena, wo pethalm yemba si henga mueisowa vevav. ");
INSERT INTO wrs_vpl VALUES ("GN3_20","002_3_20","GEN","3","20","20","Tendorinina nihilva Atam, wo Atamna ongalva simbepolva indkumbina ongana tendona, wo noinda osva ongalmba awona Ivm. ");
INSERT INTO wrs_vpl VALUES ("GN3_21","002_3_21","GEN","3","21","21","Wo Yawe tatatov lombawol ve, doa Atamimba ongalimba kayenalm vewol vinna. ");
INSERT INTO wrs_vpl VALUES ("GN3_22","002_3_22","GEN","3","22","22","Yawe ona, hillu, tendoriniva honamba doa nei timovpa, noi hevm kava ovunnam. Neiva, doa wohlihav, memba mona besal, wo temba monakokla, os men piv liheivm. Doa manam hevpa murava gavav, ata homeis nevm honi mongo timov, kav ten os sevravm, honamba yimba nerava, yemba si dahavavmoa, si wohlohvav. Si homeis wohavm yunalm. ");
INSERT INTO wrs_vpl VALUES ("GN3_23","002_3_23","GEN","3","23","23","Noinda Yawe Atam wohwolaihapho denwitmusrini. Omnana, gao, osondra veo hona pethara, pevm men kav weis vrenam. Doa wolapho ve tlalongolm. ");
INSERT INTO wrs_vpl VALUES ("GN3_24","002_3_24","GEN","3","24","24","Doa diva denwitrava Yawe hevna ovsongolnindm mendeklim sandha, nohalm sandhana, ten okomba pholohvm. Wo hev ovla velahana, wo nomba ovlava hevm ambo imhravho vrowovna, nehramohra vevna suwemsna. Ovlava nomba, ovsongolnindva nomba os, si homeis indhanarini kohavm no tira, honamba yimba nerava, yemba si dahavavmoa, si wohlohvav. ");
INSERT INTO wrs_vpl VALUES ("GN4_1","002_4_1","GEN","4","1","1","Doa Atam ongalm wailimana ve, wo venamba, ongal ena avna. Anamba, otolm sleiha tuendisrinim, Keinm awona, ona, Yawe hev kamba awothonamba, wo noinda kava tuendisrinimba lengei. ");
INSERT INTO wrs_vpl VALUES ("GN4_2","002_4_2","GEN","4","2","2","Wo henga sism Keinna boaslalm lengna, Apelm awona. Etel boaslal mendekli evewolnamba, wo Apelna andrava sipsipm dahwol vevna, wo Keinna andrava osondra vevna. ");
INSERT INTO wrs_vpl VALUES ("GN4_3","002_4_3","GEN","4","3","3","Doa dawonam Keinmba innemba sena hevna osoriniva, doa inga, Yawem sembayang venalm. ");
INSERT INTO wrs_vpl VALUES ("GN4_4","002_4_4","GEN","4","4","4","Eva Apel heva hevnam sipsip otolm miklenamba yiveltowondmangas, hev noi naembul nihilnahonam holvogoamnana Yawem. Doa Yaweva Apelmba beswonam nonglana hena naembul nihilnahonam, os omnana, yenamba lehra, ");
INSERT INTO wrs_vpl VALUES ("GN4_5","002_4_5","GEN","4","5","5","Keinm hevm, Keinna innem omnana, owai. Wo noinda Keinmba mindnam musk vevna, novlomosva sahoklaltov selthoana. ");
INSERT INTO wrs_vpl VALUES ("GN4_6","002_4_6","GEN","4","6","6","Doa Yawe omnana Keinm, manara yimba musk vev, manara novlomosva yenamba sahoklaltovpa selthoav? ");
INSERT INTO wrs_vpl VALUES ("GN4_7","002_4_7","GEN","4","7","7","Yimba beswonamba vetava, ata kava yemba nihra pethata. Wo heva os yimba sahonamba vetava, nomba sahoklava si yemba yunalm kek vethawulavav. Yena sahoklava maim ora, sungeitwinde yeinda di murapeta lohv, yem helvelm vev. No sahoklaoa yeoa wuleiho, wuleiharava, yemba si kek vethawulavavmoa, owai. ");
INSERT INTO wrs_vpl VALUES ("GN4_8","002_4_8","GEN","4","8","8","Doa Keinmba Apelm boaslalm os ishomnana, pioa lohmana vilengai, wo Keini Apeli di posmusra elohvna, wo Kein phona, Apelm hevna boaslalmba helvakomandha. ");
INSERT INTO wrs_vpl VALUES ("GN4_9","002_4_9","GEN","4","9","9","Doa sism Yawe Keinm osahmanana, boaslapevpa hi av? Kein mosnamona Yawemba ishomnana, kava tit vev, yimba os nengvma, kava lohv, ambo kavna boaslam naengho vromana venalm? ");
INSERT INTO wrs_vpl VALUES ("GN4_10","002_4_10","GEN","4","10","10","Wo Yawe Keinm omnana, mani yimba vei? Boaslapevmba yimba doa helvakomandhai, wo noinda tovolva sovhopei petharava. Doa lohv, maim oi, indhanarinina moalamang petharini kam ishomnav, yeoa esesm veno. ");
INSERT INTO wrs_vpl VALUES ("GN4_11","002_4_11","GEN","4","11","11","Doa yem ka kinwonda plothomnav. Hona petharinioa wohgao. Tovolva doa pethamera gai, maim oi, indhanarini po nev. Pevna englana yimba doa sovhopipahi boaslapevna tovolva. ");
INSERT INTO wrs_vpl VALUES ("GN4_12","002_4_12","GEN","4","12","12","Noinda innemba yimba wolavrava, phovavmoa beswonamba, wo deuvkembelva yenamba si owai, yimba si lohmanangas vevra. ");
INSERT INTO wrs_vpl VALUES ("GN4_13","002_4_13","GEN","4","13","13","Wo Kein Yawem omnana, khui, ambo kinwonda mendekli doa yimba kamba plothomnai, owai, es eva kava vevav! ");
INSERT INTO wrs_vpl VALUES ("GN4_14","002_4_14","GEN","4","14","14","Men yimba kamba wohwolaihangav hona pethariniva, wo kava wohgavrava, yimba kamba hengava si nonglavavmoa. Deuvkembelva kanamba si owai, kava si lohmanangas vevra, wo indhanariniva kamba anongla vetava, kamba si os helvakomandhavav. ");
INSERT INTO wrs_vpl VALUES ("GN4_15","002_4_15","GEN","4","15","15","Wo Yawe omnana, owai, men kava yeindava ovunv, indhanariniva yemba helvakomandhatava, tanamolnam si kava mendeklikumbi kinwonda plothomnavav hemba. Doa Yawe Keinm nihtovra lohoh vemnana, indhanariniva anongla vetava, wo helvakomandhavavmoa. ");
INSERT INTO wrs_vpl VALUES ("GN4_16","002_4_16","GEN","4","16","16","Doa Keinmba wohgana Yawenaminiva, mongona petharam himba gana, os sevriv Not, nomba pethava. Notm os uv, lohmanangas ambo vev, wohavavmoa. Pethava nomba di lohv, okomba ten pholohvm Itenda nohalm. ");
INSERT INTO wrs_vpl VALUES ("GN4_17","002_4_17","GEN","4","17","17","Doa Keinmba ongalm wailimana ve, ongal ena a, wo otolm lenge tuendisrinim, os awona Enokm. Aralva kembel sva, nomba kembelva os sevrana Enok kembel. ");
INSERT INTO wrs_vpl VALUES ("GN4_18","002_4_18","GEN","4","18","18","Wo Enokva mendekli venamba, ombol pola, os awona Iratm. Wo Irat mendekli venamba, ombol pola, os awona Mehutaelm. Mehutael mendekli venamba, hena ombol pola, os awona Metusaelm. Metusael mendekli venamba, hena ombol pola, os awona Lamekm. ");
INSERT INTO wrs_vpl VALUES ("GN4_19","002_4_19","GEN","4","19","19","Doa Lamekva mendekli venamba, ongamba sambla dambtna, mongova Ata, mongova Sila. ");
INSERT INTO wrs_vpl VALUES ("GN4_20","002_4_20","GEN","4","20","20","Atava sis Yapalm lenge, wo Yapalva mendekli venamba, hevtindi os andra vivna, sapim dahwol vivna, wo lailduvra shamana vevna. ");
INSERT INTO wrs_vpl VALUES ("GN4_21","002_4_21","GEN","4","21","21","Yapalna boaslalva Yupal, wo Yupaltindiva noi sis sangalnind, gitasangal vuvsangal vewuvmona vevna. ");
INSERT INTO wrs_vpl VALUES ("GN4_22","002_4_22","GEN","4","22","22","Doa Lamekna aslongo otolm lenge, os awona Tupalkeinm. Tupalkeinmba mendekli venamba, wo hevtindiva nonoanind, os vewol vivna ovlam mandm, no besinamba. Tupalkeinna muskovolva Nama. ");
INSERT INTO wrs_vpl VALUES ("GN4_23","002_4_23","GEN","4","23","23","Wo Lamek ongalm hevnam os unna Ataim Silaim, yeoa kana moam ehellevm, mongova tendo towondriniva kamba helveiva, wo doa kava helvakomandhai. Himba kam sang polavoiva, wo doa ka helvakomandhai. ");
INSERT INTO wrs_vpl VALUES ("GN4_24","002_4_24","GEN","4","24","24","Henomba Keinmba helvakomandhatava, Sesoava henomba kinwonda mendekli si plothomnavav. Kamba henomba helvetava, si kava kinwonda snamemakumbi plothomnavav. ");
INSERT INTO wrs_vpl VALUES ("GN4_25","002_4_25","GEN","4","25","25","Doa Atamba ongalm henga wailimana vevnamba, otolm lenge, Setm awona. Aval ona, Sesoa kamba nengmanana, wo noinda mongo henga Apelna vuhera lohvhoai, ten Kein helvakomandhanam, noinda awona Setm. ");
INSERT INTO wrs_vpl VALUES ("GN4_26","002_4_26","GEN","4","26","26","Wo Setva mendekli venamba, ombol pola, os awona Enosm. Wo nonamba indhanamba Sesoana nihilnonoava seilva os sevra ovrivna, Yawe, wo sembayang hemba vimnivna. Doata. ");
INSERT INTO wrs_vpl VALUES ("GN5_1","002_5_1","GEN","5","1","1","Atamtindiva os nowana, wo men novol velohv. Sesoa Atamba vena, os hev ten lohvm, ");
INSERT INTO wrs_vpl VALUES ("GN5_2","002_5_2","GEN","5","2","2","tlalm vena, ongalm vena, doa os vewolna. Vewolnamba, awothowol venamba, os awowol vena indhanamba. ");
INSERT INTO wrs_vpl VALUES ("GN5_3","002_5_3","GEN","5","3","3","Doa Atamba os ana, venamba 130pelara osomba, wo mongo ombol pola, ona aral hev telohvm, wo os awona Setm. ");
INSERT INTO wrs_vpl VALUES ("GN5_4","002_5_4","GEN","5","4","4","Atamba os wohavna henga 800pelara osomba, wo otolva os phomnavna, vevna tuendis mutundis. ");
INSERT INTO wrs_vpl VALUES ("GN5_5","002_5_5","GEN","5","5","5","Wo Atamba anamba, 930pelara osomba os venamba, doa os wohdahana. ");
INSERT INTO wrs_vpl VALUES ("GN5_6","002_5_6","GEN","5","6","6","Setva os ana, venamba 105pelara osomba, wo ombolva pola, os awona Enosm. ");
INSERT INTO wrs_vpl VALUES ("GN5_7","002_5_7","GEN","5","7","7","Setva os wohavna, henga 807pelara osomba lohmanavna, wo otolva os phomnavna tuendis mutundis. ");
INSERT INTO wrs_vpl VALUES ("GN5_8","002_5_8","GEN","5","8","8","Wo Setva anamba, 912pelara osomba lohmanana, doa os wohdahana. ");
INSERT INTO wrs_vpl VALUES ("GN5_9","002_5_9","GEN","5","9","9","Enosva os anamba, venamba 90pelara osomba lohmanavna, wo ombol pola, os awona Kenanm. ");
INSERT INTO wrs_vpl VALUES ("GN5_10","002_5_10","GEN","5","10","10","Enosva os wohavna, henga 815pelara osomba lohmanana, wo otolva os phomnavna, vevna tuendis mutundis. ");
INSERT INTO wrs_vpl VALUES ("GN5_11","002_5_11","GEN","5","11","11","Wo Enosva anamba, 905pelara osomba os venamba, doa os wohdahana. ");
INSERT INTO wrs_vpl VALUES ("GN5_12","002_5_12","GEN","5","12","12","Kenanmba os ana, venamba, 70pelara osomba lohmanavna, wo ombol polamnavna, os awona Mahalalelm. ");
INSERT INTO wrs_vpl VALUES ("GN5_13","002_5_13","GEN","5","13","13","Kenanmba os wohavna henga 840pelara osomba, wo otolva os phomnavna, vevna tuendis mutundis. ");
INSERT INTO wrs_vpl VALUES ("GN5_14","002_5_14","GEN","5","14","14","Wo Kenanmba anamba, 910pelara osomba lohmanana, doa os wohdahana. ");
INSERT INTO wrs_vpl VALUES ("GN5_15","002_5_15","GEN","5","15","15","Wo Mahalalelva os amana venamba, 65pelara osomba lohmanavna, wo ombol polamnavna, os awona Yaretm. ");
INSERT INTO wrs_vpl VALUES ("GN5_16","002_5_16","GEN","5","16","16","Mahalalelva os wohavna henga 830pelara osomba, wo otolva os phomnavna, vevna tuendis mutundis. ");
INSERT INTO wrs_vpl VALUES ("GN5_17","002_5_17","GEN","5","17","17","Wo Mahalalelva amana venamba, 895pelara osomba os venamba, doa os wohdahana. ");
INSERT INTO wrs_vpl VALUES ("GN5_18","002_5_18","GEN","5","18","18","Yaretva os amana venamba, 162pelara osomba lohmanavna, wo ombol polamnana, os awona Enokm. ");
INSERT INTO wrs_vpl VALUES ("GN5_19","002_5_19","GEN","5","19","19","Yaretva os wohavna henga 800pelara osomba, wo otolva os phomnavna, vevna tuendis mutundis. ");
INSERT INTO wrs_vpl VALUES ("GN5_20","002_5_20","GEN","5","20","20","Wo Yaretva amana venamba, 962pelara osomba os venamba, doa os wohdahana. ");
INSERT INTO wrs_vpl VALUES ("GN5_21","002_5_21","GEN","5","21","21","Enokva os amana venamba, 65pelara osomba lohmanavna, wo ombolva os polamnana, os awona Metuselam. ");
INSERT INTO wrs_vpl VALUES ("GN5_22","002_5_22","GEN","5","22","22","Enokva henga 300pelara osomba venamba, Sesoam mongawundna amana venavna, wo otolva phomnavna, vevna tuendis mutundis. ");
INSERT INTO wrs_vpl VALUES ("GN5_23","002_5_23","GEN","5","23","23","Enokva os amana venamba, 365pelara osomba lohmanavna, ");
INSERT INTO wrs_vpl VALUES ("GN5_24","002_5_24","GEN","5","24","24","Sesoai mongawulm ahamana evevna, wo Sesoa hevm waiwohgana hevindam Sesoaindam, wo indhanamba hengava nunglinamoa. ");
INSERT INTO wrs_vpl VALUES ("GN5_25","002_5_25","GEN","5","25","25","Doa Metuselava os amana vevnamba, 187pelara osomba lohmanana, wo ombol polamna, os awona Lamekm. ");
INSERT INTO wrs_vpl VALUES ("GN5_26","002_5_26","GEN","5","26","26","Metusela os wohamana vevna henga 782pelara osomba, wo otolva os phomnavna, vevna tuendis mutundis. ");
INSERT INTO wrs_vpl VALUES ("GN5_27","002_5_27","GEN","5","27","27","Wo Metusela amana venamba, 969pelara osomba lohmanavna, os venamba, doa os wohdahana. ");
INSERT INTO wrs_vpl VALUES ("GN5_28","002_5_28","GEN","5","28","28","Lamekva os amana venamba, 182pelara osomba lohmanana, wo ombol polamna, os awona Noam. ");
INSERT INTO wrs_vpl VALUES ("GN5_29","002_5_29","GEN","5","29","29","Hev ona, tanam Yawe doa doara hona pethava sahokla ovrena Keinna indkoklara, wo hona tuendisrini Noa si pimba kolvrowol vevav osondrarava. Noinda osva awona Noam. ");
INSERT INTO wrs_vpl VALUES ("GN5_30","002_5_30","GEN","5","30","30","Doa Lamekva os wohavna henga 595pelara osomba, doa otolva os phomnavna, vevna tuendis mutundis. ");
INSERT INTO wrs_vpl VALUES ("GN5_31","002_5_31","GEN","5","31","31","Wo Lamekva amana venamba, 777pelara osomba os venamba, doa os wohdahana. ");
INSERT INTO wrs_vpl VALUES ("GN5_32","002_5_32","GEN","5","32","32","Noava os amana venamba, 500pelara osomba venamba, wo ombolva samblamong vilomnana, os awowol vena Sem Ham Yapetm. ");
INSERT INTO wrs_vpl VALUES ("GN6_1","002_6_1","GEN","6","1","1","Doa indhanamba esvema ophovna, doa hona pethara pilivhoana, wo mutundisva eva os phonata. ");
INSERT INTO wrs_vpl VALUES ("GN6_2","002_6_2","GEN","6","2","2","Wo Sesoanamba monglava ovsongolnindva nom mutundism nungeilvnamba, pai besal hevm, wo hevm avramana vevna hevna nengavnangna. ");
INSERT INTO wrs_vpl VALUES ("GN6_3","002_6_3","GEN","6","3","3","Wo noinda Sesoa ona, indhanamba nomba, si kavsongolva kava wonamana vevavmoa yunalmba hemba. Tanam ka daswolvna kavsongolva hemba, nonapopolmba almba. Heva os himba kalmba avnamoa, noinda himba si wohaevvavmoa eukwonamba, hemba si dalvav. Himba osomba si 120pelara vevrava, os dahavra. ");
INSERT INTO wrs_vpl VALUES ("GN6_4","002_6_4","GEN","6","4","4","Doa ovsongolnindva nomba mutundismba nomba avramana vevnamba hevmba, doa himba otolmba lengwol vivna. Wo nomba otolva sism nihva mendeklikumbi vilovnamba, himba indhanawonga wohavna, wo indhana owalva hemba eisho vruwuleinvna. ");
INSERT INTO wrs_vpl VALUES ("GN6_5","002_6_5","GEN","6","5","5","Doa Yaweva nongalna, pethanindva indkumbiva indhanakokla. Elsus undva henamba ambo sahoklal lovahinv, ");
INSERT INTO wrs_vpl VALUES ("GN6_6","002_6_6","GEN","6","6","7","wo Yawemba kinwondana plothumnivna. Hev nengna, sahonam kava vewol venama, pethara sandhana, wo hona petharini kava si kelvapiangavav, si indhanamba lohhui, tatamba lohhui, tuawava lohhui. Kav venamba honamba, wo beswonamba lohvmoa, noinda kamba kinwondana yuhla wuleuvv. ");
INSERT INTO wrs_vpl VALUES ("GN6_8","002_6_8","GEN","6","8","8","Noamangas Yaweva undna nengmanavna. ");
INSERT INTO wrs_vpl VALUES ("GN6_9","002_6_9","GEN","6","9","10","Noana moamba os lohv. Ombolva samblamong os phomnana, nihilva Sem, Ham, Yapet. Noava indhanarini besal, wo hevho besal lohvna Sesoana novra. Wo himba Sesoam mongawundna amana venavna. ");
INSERT INTO wrs_vpl VALUES ("GN6_11","002_6_11","GEN","6","11","11","Monglava nomba indkumbiva indhanakokla Sesoana novrava, ambo ahalvamana nakra aevulvna indakonda kembella, ");
INSERT INTO wrs_vpl VALUES ("GN6_12","002_6_12","GEN","6","12","12","wo Sesoava nongalna, indhanakokla memba aevulv. ");
INSERT INTO wrs_vpl VALUES ("GN6_13","002_6_13","GEN","6","13","13","Doa Sesoa Noam omnana, doa kava vevav, wo indhanamba si hemba wohsihavav. Himba ahalvamana nakra aevulv, beswonamba owai, noinda kava yunam wohkelvapiangalm vev pethanahonam. ");
INSERT INTO wrs_vpl VALUES ("GN6_14","002_6_14","GEN","6","14","14","Wo yeoa tioa besal dambo, wo botm veo pevm. Kameroa mindnam vewol veo meraoa, wo tenenna selvowol veo mera ambara, homeis si po sihavm. Osm veo, si sena posra velthalohvav. ");
INSERT INTO wrs_vpl VALUES ("GN6_15","002_6_15","GEN","6","15","15","Os veo hona botmoa. Hoanalva os 130pelara mita, wo ahnamba os 22pelara mita, wo indundva os 13pelara mita. ");
INSERT INTO wrs_vpl VALUES ("GN6_16","002_6_16","GEN","6","16","16","Wo os velaihawol veo eneshatuvoa, okomba lovhoasihalm. Wo no eneshatuvpa vewol veo peitsingi. Wo tuvoa os veo ambarasis, wo merava vevta velahawol vulvongao samblamong, sengai hovra sena. ");
INSERT INTO wrs_vpl VALUES ("GN6_17","002_6_17","GEN","6","17","17","Wo pueumbva mendekli si kava wavvav, verava, pueumbva pethava ehlathavav, wo indhanam manam manam kelvapianga, petharava si owai, indhanamba tuawava tatamba, nomba vavatannamba, mongova avavmoa. ");
INSERT INTO wrs_vpl VALUES ("GN6_18","002_6_18","GEN","6","18","18","Men kava yemba ishomnav, yemangas kava venglahav. Wo pueumbva provrava, no botmeraoa wonsihao ongapevm, towandpevm, kopevm, nonamba kava pomba wavvrava. ");
INSERT INTO wrs_vpl VALUES ("GN6_19","002_6_19","GEN","6","19","20","Wo yeoa tuawam tatam indakondam os holvorombol vevm. Henom tlalm ongalm, henom tlalm ongalm vewol vevm, wo mera wolasiha veo, wo beswonam aevulvra, pueumbva livrava. ");
INSERT INTO wrs_vpl VALUES ("GN6_21","002_6_21","GEN","6","21","21","Wo yeoa inneoa indakondana os meilna vinvm, pevnam, tuawanam, tatanam, dom hlewuvulm botmeram. ");
INSERT INTO wrs_vpl VALUES ("GN6_22","002_6_22","GEN","6","22","22","Wo os vena Noava, Sesoa hev ten omnanam. ");
INSERT INTO wrs_vpl VALUES ("GN7_1","002_7_1","GEN","7","1","1","Doa Yawe mendah Noam ishomnavna, yemangas kava nonglav beswonamba, monglava nomba kamba sahokla vriv. Doa no botmera wonsihao, ");
INSERT INTO wrs_vpl VALUES ("GN7_2","002_7_2","GEN","7","2","2","wo tataoa besalangas holvorombol veo, tlalva 7pelara ongalva 7pelara, wo tatamba sahoklal, tlal mongal, ongal mongal. Tatamba os holvorombol veo besal eva sahoklal. Besalva, tepev noi kam sembayang nona venavm. Sahoklalva, tepev noi kam sembayangva nona owai venavm. ");
INSERT INTO wrs_vpl VALUES ("GN7_3","002_7_3","GEN","7","3","3","Tuawaoa osoa, tlalmoa 7pelara, ongalmoa 7pelara, noinda osoa veo, ata homeis sihapiavm, honita si hengava petharava towand vulsihavav. ");
INSERT INTO wrs_vpl VALUES ("GN7_4","002_7_4","GEN","7","4","4","Wo simba 7pelara penngiliha vewol verava, pomba si kava os wavvav, wo si os wohsithavav simba 40pelara okombanam sinim. Wo hona pueumbna si kava kelvapiangavav indhanam, tatam, tuawam, manam manam vavatannamba, nomba temba kava vewol venamba. ");
INSERT INTO wrs_vpl VALUES ("GN7_5","002_7_5","GEN","7","5","5","Wo Noava osoa vena, Yawe hev ten omnanam. ");
INSERT INTO wrs_vpl VALUES ("GN7_6","002_7_6","GEN","7","6","6","Noana osomba os lohmanavna 600pelara, wo os phona, ");
INSERT INTO wrs_vpl VALUES ("GN7_7","002_7_7","GEN","7","7","7","hev, ongal, ombtowondal, kol no botmera wonsihana. ");
INSERT INTO wrs_vpl VALUES ("GN7_8","002_7_8","GEN","7","8","9","Doa osoa vena, tlal ongal tatamba besalva eva sahoklalva Noaindam ambanamba, wo hev wolasiha vena botmerava, wo eva tuawa mani mani. Wo osoa vena Noava, Sesoa hev ten omnanam. ");
INSERT INTO wrs_vpl VALUES ("GN7_10","002_7_10","GEN","7","10","10","Doa simba penngiliha vungupianamba 7pelarava, doa pomba os wohsithana. ");
INSERT INTO wrs_vpl VALUES ("GN7_11","002_7_11","GEN","7","11","12","Doa pethava kawol vuku vevnamba, wo mellini pomba phungu vena os i, wo pomba ovriniva eva osta noshara sovhopevna i. Honamba os phona, tangal 17 vena, weisva sambla doara khuawolna, nonamba Noanamba osomba os lohmanavna 600pelara. ");
INSERT INTO wrs_vpl VALUES ("GN7_13","002_7_13","GEN","7","13","13","Pomba os wohsithana, wo nonamba doara mera aevulvna Noa, ongal, ombtowondal, kol samblamong. ");
INSERT INTO wrs_vpl VALUES ("GN7_14","002_7_14","GEN","7","14","16","Wo tatamba doara wolasiha wonvenata, sungeitrini, deuvrini, eusil, mendekli, wo eva tuawamba indakonda, aralm avalm osangas wonvena, os Sesoa hevm doara omnanam. Doa Yawe hev tuvpa kulvunna. ");
INSERT INTO wrs_vpl VALUES ("GN7_17","002_7_17","GEN","7","17","17","Doa pomba os wohsithana, venamba, simba 40pelara penngiliha vungupianamba, wo heva os pomba sihavnamoa Noana botrava owai, pueumbva vongavnamba, ");
INSERT INTO wrs_vpl VALUES ("GN7_18","002_7_18","GEN","7","18","18","wo botva sena velthalohvna pueumbsra. ");
INSERT INTO wrs_vpl VALUES ("GN7_19","002_7_19","GEN","7","19","19","Pueumbva os vongana i, venamba, olomba mendeklimba mera vethawol vena, ");
INSERT INTO wrs_vpl VALUES ("GN7_20","002_7_20","GEN","7","20","20","henga vongana 7pela mitara doa. ");
INSERT INTO wrs_vpl VALUES ("GN7_21","002_7_21","GEN","7","21","21","Wo mani mani pethariniva wohsihana, tuawam, sapim, tatam, indhanam indkumbimba nonamta wohsihana. ");
INSERT INTO wrs_vpl VALUES ("GN7_22","002_7_22","GEN","7","22","22","Nomba vavatannamba wusprowol vevna, manam manam nonamta mueisowa wohvena. ");
INSERT INTO wrs_vpl VALUES ("GN7_23","002_7_23","GEN","7","23","23","Wo os Yaweva kelvapiangana nonamba, wo heva os Noatatanangas beswonamba wonavna botmerava, tatana tuawana wonvevna. ");
INSERT INTO wrs_vpl VALUES ("GN7_24","002_7_24","GEN","7","24","24","Doa pueumbangas livna, simba 150pelara vevna. ");
INSERT INTO wrs_vpl VALUES ("GN8_1","002_8_1","GEN","8","1","1","Doa Sesoava mendah ninginvna Noatatanam, ten botmera aevulvnam tatam tuawam. Doa ivtovm wolaihapho, wo pueumbva hivrapiha vena. ");
INSERT INTO wrs_vpl VALUES ("GN8_2","002_8_2","GEN","8","2","2","Pomba henga phonamoa, Sesoa hev ona, doata, petharini melva doa kulthawol vei, wo ovriniva pomba hasvonamoa hengava owai. ");
INSERT INTO wrs_vpl VALUES ("GN8_3","002_8_3","GEN","8","3","3","Doa simba 150pelara vevnamba, pueumbva hivrapihavna, venamba, ");
INSERT INTO wrs_vpl VALUES ("GN8_4","002_8_4","GEN","8","4","4","olosra plotho Noana botva. Tangal 17 vena, weisva 7pelara doara khuawol vena, olomba nomba mongona pethara lohvna, os ningthivna Ararat petha. ");
INSERT INTO wrs_vpl VALUES ("GN8_5","002_8_5","GEN","8","5","5","Pueumbva mendahva hivrapihavnamba, wo henga Noava nonglanga vena, olomba mongova phuku vev pueumbmerini, os phona, tangal 1 vena, weisva 10pelara doara khuawol vena. ");
INSERT INTO wrs_vpl VALUES ("GN8_6","002_8_6","GEN","8","6","6","Doa hengava simba 40pelara penngiliha vungupianamba, wo Noava eneshatuv velavhoa, hev ten venam, ");
INSERT INTO wrs_vpl VALUES ("GN8_7","002_8_7","GEN","8","7","7","kungetuwam wolaihapho. Nomba tuawava hengava pronamoa, yunalm himba lohmana vevna, pethava hivhoavna. ");
INSERT INTO wrs_vpl VALUES ("GN8_8","002_8_8","GEN","8","8","8","Wo henga mongom tuawam leumbm wolaihapho, osm vevna, petha hivraimi owaimi. ");
INSERT INTO wrs_vpl VALUES ("GN8_9","002_8_9","GEN","8","9","9","Pueumbva wohhivranamoa, wo leumbva dalohomana vevnamba, ovna, manara ka avhoai, wo veloh venamba, henga pro, wo Noa engla pusnathamnanamba, holvora, meram wolaihasiha. ");
INSERT INTO wrs_vpl VALUES ("GN8_10","002_8_10","GEN","8","10","10","Noava henga os ana minguva mongasal, wo henga leumbmba wolaihapho. ");
INSERT INTO wrs_vpl VALUES ("GN8_11","002_8_11","GEN","8","11","11","Doa leumbva amana venamba, moakokonam henga pro, pilolna tivla pehnana oliv vlel polapethana, wo Noava nengna, pueumbva doa dihi hivrapihav, espetambo liv. ");
INSERT INTO wrs_vpl VALUES ("GN8_12","002_8_12","GEN","8","12","12","Wo henga mongasal minguva venamba, wo henga leumbmba wolaihapho, wo hengava pronamoa. ");
INSERT INTO wrs_vpl VALUES ("GN8_13","002_8_13","GEN","8","13","13","Doa Noava tuv velaihanamba, petham nonglapiha ve, pueumbva hivhoav. Noana osomba os lohmanana 601pelara, wo tangal 1 vena, weisva mongasal doara khuana. ");
INSERT INTO wrs_vpl VALUES ("GN8_14","002_8_14","GEN","8","14","14","Wo sisva henga tangal 27 vena, weisva sambla doara khuawolna, doa hev ona nonglana, doa hivhoana. ");
INSERT INTO wrs_vpl VALUES ("GN8_15","002_8_15","GEN","8","15","15","Doa Sesoa Noam ishomnana, ");
INSERT INTO wrs_vpl VALUES ("GN8_16","002_8_16","GEN","8","16","16","wonpihao botrinioa, pev ongapev towandpev kopev. ");
INSERT INTO wrs_vpl VALUES ("GN8_17","002_8_17","GEN","8","17","17","Wo tatamoa wonpihao, tuawam tatam, wo hev ambo ongaongla vevendvrava, wo henga petham honam lehra vethara vavawonam. ");
INSERT INTO wrs_vpl VALUES ("GN8_18","002_8_18","GEN","8","18","18","Doa Noatatana wonpihana, ");
INSERT INTO wrs_vpl VALUES ("GN8_19","002_8_19","GEN","8","19","19","wo tatamba tuawava eva osta, aral aval aral aval. ");
INSERT INTO wrs_vpl VALUES ("GN8_20","002_8_20","GEN","8","20","20","Doa Noa honmba meilna vena, venamba, songowol venamba, suwem nosram sengalm. Doa besalangas tatana tuawana holvorombol venamba, noi seilm ten noi weseng velvohmanavnam hevm. Notongotata mongasal, notongotata mongasal, osangas holvorombol venamba, wo suwera weseng vevna, osm Yawem sembayang vene. ");
INSERT INTO wrs_vpl VALUES ("GN8_21","002_8_21","GEN","8","21","21","Wo Yawem teihnung vene hevm besal, wo nengna, pethava si hengava kava indkokla vrevavmoa indhanana indkoklarava. Doa kava nongalna, mendahva eusilva vepravnamba, nengavnangva henamba sahoklal lohprinvna. Wo heva os hengava kava indhanamba tatamba wohkelvapiangavavmoa, owai. ");
INSERT INTO wrs_vpl VALUES ("GN8_22","002_8_22","GEN","8","22","22","Honamba pethava si os wohlohvav, innem wolalm, innem aiselm, nelpong vevra, suwepav vevra, hlakomba lohvra, po hasvovra, okomba lohvra, sia kilvravra. Honamba si wuleihavavmoa hona petharava, verava, pethava si honamba os mueisowa vevav. Doata. ");
INSERT INTO wrs_vpl VALUES ("GN9_1","002_9_1","GEN","9","1","1","Doa Sesoava Noatatanam awothowol vena, aralm ishomnana, ombtowondpevoa yenaoa os towand vivra mindnam, verava, doa petham lehra vethara honam. ");
INSERT INTO wrs_vpl VALUES ("GN9_2","002_9_2","GEN","9","2","2","Tatamba tuawava mani mani, tambkova kava yem slowotunv, wo yenapenam si vinvra. ");
INSERT INTO wrs_vpl VALUES ("GN9_3","002_9_3","GEN","9","3","3","Pev vaohotho, tatalm hlavm. Seilva doara yimba osonnangas hlavna, men daipotava kava yemba tatamba wolamnav, hlao. ");
INSERT INTO wrs_vpl VALUES ("GN9_4","002_9_4","GEN","9","4","4","Mongongasalangas yemba kava ovunv, tatamba manam yimba hlavav tovolnahonamba, manara tovolnapopol tatamba av. ");
INSERT INTO wrs_vpl VALUES ("GN9_5","002_9_5","GEN","9","5","5","Yimba eva tovolnapopol avta, wo indhanariniva yemba mongova helvakomandhatava, si kava hemba kinwonda plothomnavav. Wo tatamba yemba winetava, kava miklevav. ");
INSERT INTO wrs_vpl VALUES ("GN9_6","002_9_6","GEN","9","6","6","Kav indhanamba vena, snal undna men kav avm, wo noinda henomba tovolva indhanarininamba kovhoatava, henamba eva indhanamba kuvhueivavta kana moara. ");
INSERT INTO wrs_vpl VALUES ("GN9_7","002_9_7","GEN","9","7","7","Doa yeoa otolmoa towand vivm mindnam, verava, petham honam lehra vetha. ");
INSERT INTO wrs_vpl VALUES ("GN9_8","002_9_8","GEN","9","8","8","Doa Sesoava Noatindim henga unna, ");
INSERT INTO wrs_vpl VALUES ("GN9_9","002_9_9","GEN","9","9","9","kam hillu, yem kava moa ishunv, yem, yetindim, henga si phovavm. ");
INSERT INTO wrs_vpl VALUES ("GN9_10","002_9_10","GEN","9","10","10","Tatamba eva kava ishunv, tuawam tatam manam manam, temba yimba wonpihanamba pevna botriniva. ");
INSERT INTO wrs_vpl VALUES ("GN9_11","002_9_11","GEN","9","11","11","Men kava yemba ishomnav, hengava si indhanamba tatamba kava kelvapiangavavmoa pueumbnamba. Pueumbva snamba si owai, hengava hona pethamba pueumbnamba si indkokla vrevavmoa. ");
INSERT INTO wrs_vpl VALUES ("GN9_12","002_9_12","GEN","9","12","14","Hello, mindva si kava kelathavav tekohovra, honamba osm, kav wohishomnav yem, tatam yunalm. Doa si kava tekomsna ningewol vevrava ovra, wo pom sombvramnavrava, hasvolm, wo mindva si os kelathavra snal. ");
INSERT INTO wrs_vpl VALUES ("GN9_15","002_9_15","GEN","9","15","15","Kava si os nonglavav, wo noinda yem ka vevra, nengmanavra os, doa kava wohishomnana, pueumbva hengava snamba si owai. ");
INSERT INTO wrs_vpl VALUES ("GN9_16","002_9_16","GEN","9","16","17","Wo hona mindva osm, men kav yem wohishomnanam, yem tatam, nom vavatannapopolm. ");
INSERT INTO wrs_vpl VALUES ("GN9_18","002_9_18","GEN","9","18","19","Nihilva Noanamba ombtowondalnamba men, Sem Ham Yapet, botmerini aralva hemba wonpihanamba. Honamba Noana towandva samblamong pivna eindhumunil hona pethanindna annindna annindna indakonda. Hamba nomba Kenanna aral lohna. ");
INSERT INTO wrs_vpl VALUES ("GN9_20","002_9_20","GEN","9","20","20","Doa Noana andrava osondra, wo himba wolana weselmovpa di, os ningthiv grevmov. Indhanamba seilva doarava vinamoa. ");
INSERT INTO wrs_vpl VALUES ("GN9_21","002_9_21","GEN","9","21","21","Doa movolva ksuvhoavnamba, Noa pueitnamba, polm ve. Polm venamba, wainpolalm nilha, doa ne, noinda dai ona. Dai onamba, wo himba posal nihps livna talanahui hevna lailduvmera. ");
INSERT INTO wrs_vpl VALUES ("GN9_22","002_9_22","GEN","9","22","22","Doa Ham aralna lailduvra siha, aralm nonglana, pai nihps liv. Wo phonamba, unna, aramba nihps liv. ");
INSERT INTO wrs_vpl VALUES ("GN9_23","002_9_23","GEN","9","23","23","Wo Semi Yapeti kayen evranamba, aralm nona hehla evevrana. Doa hevna lura ehohlinna, os mumus epravna, aralmba enonglanamoa, mainovna ambo hehla evevrana. ");
INSERT INTO wrs_vpl VALUES ("GN9_24","002_9_24","GEN","9","24","24","Doa Noa henga pho, daiva wuleihanamba, hev hellena, kalelva os kamba yumona vlei, louwolmba! ");
INSERT INTO wrs_vpl VALUES ("GN9_25","002_9_25","GEN","9","25","25","Wo hev ona, Kenanmba Sesoa si kinsomb plothomnavav, Hamna ombolmba, wo Yapetina Semina keusingi si himba wohluhunvav. ");
INSERT INTO wrs_vpl VALUES ("GN9_26","002_9_26","GEN","9","26","26","Wo Semoa henamba mendekli Yawengas lohmanav, wo pioa Yawem nom okulivra. Semna keusingi si Kenamba wohlohvhoamnavav. ");
INSERT INTO wrs_vpl VALUES ("GN9_27","002_9_27","GEN","9","27","27","Wo Yapetoa hemoa Sesoa keknam poauothovra, osva hevtindiva mindnam si phovav, wo mongawulm euvmona vevra Semtindiva. Yapetna eva keusingi si Kenanmba lohmanavav. ");
INSERT INTO wrs_vpl VALUES ("GN9_28","002_9_28","GEN","9","28","28","Doa pueumbva nomba wohhivrapianamba, doa Noava hengava sism osomba vena 350pelara, os avna, ");
INSERT INTO wrs_vpl VALUES ("GN9_29","002_9_29","GEN","9","29","29","wo os wohdahana. Osomba hevnamba os lohmanavna 950pelara. Doata. ");
INSERT INTO wrs_vpl VALUES ("GN10_1","002_10_1","GEN","10","1","1","Men Noatindiva os nowana. Noanamba men Sem, Ham, Yapet. Pueumbva hivranamba, wo Semtindi Hamtindi Yapettindi os phona. ");
INSERT INTO wrs_vpl VALUES ("GN10_2","002_10_2","GEN","10","2","2","Yapetnamba men ombolva Gomer, Makok, Matai, Yavan, Tupal, Mesek, Tiras. Pimba hetindimba os nengsm uv simbehumunilna nihilm. ");
INSERT INTO wrs_vpl VALUES ("GN10_3","002_10_3","GEN","10","3","3","Gomernamba men sespalva Askenasnind, Ripatnind, Tokamanind. ");
INSERT INTO wrs_vpl VALUES ("GN10_4","002_10_4","GEN","10","4","4","Yavannamba men sespalva Elisanind, Tasisnind, Kitnind, Dotannind. ");
INSERT INTO wrs_vpl VALUES ("GN10_5","002_10_5","GEN","10","5","5","Memba honamba wannindna eindhumunil, wo hevna moa, hevna petha os vungeinna di wanda, eva di ten wan hovra kuvundtholla. ");
INSERT INTO wrs_vpl VALUES ("GN10_6","002_10_6","GEN","10","6","6","Hamnamba men ombolva Kus, Isip, Lipia, Kenan. Pimba hetindimba os nengsm uv simbehumunilna nihilm. ");
INSERT INTO wrs_vpl VALUES ("GN10_7","002_10_7","GEN","10","7","7","Kusnamba men sespalva Sepanind, Havilanind, Saptanind, Ramanind, Saptekanind. Ramanindnamba men sespalva Sepanind, Detannind. ");
INSERT INTO wrs_vpl VALUES ("GN10_8","002_10_8","GEN","10","8","8","Wo Kusnamba mongova ombol lohna, nihilva Nimrot. Hengas kuwulva andralva wulluhunna, seilva sna indhanariniva mongova owai, lohnamoa. ");
INSERT INTO wrs_vpl VALUES ("GN10_9","002_10_9","GEN","10","9","9","Wo Nimrotva tatawonga lohvna, Yawe doara hev ona nongaihana avalna era. Wo daipotava henomba tatawongava lohvrava, indhanamba os ishumnivra, yimba os lohv, oi Nimrot, ten Yawe ona nongaihanam. ");
INSERT INTO wrs_vpl VALUES ("GN10_10","002_10_10","GEN","10","10","10","No pethava Nimrotva boasna vaohothonamba, Bapilon petha, wo deuvkembelva samblasambla vewol vena Bapilon, Erek, Akat, Kalne. ");
INSERT INTO wrs_vpl VALUES ("GN10_11","002_10_11","GEN","10","11","11","No petha Bapilonmba wuleihana, wo henga Asiria pethara avhoana, deuvkembelva os vewol vena Nineva, Rehopotir, Kala, Resen. ");
INSERT INTO wrs_vpl VALUES ("GN10_12","002_10_12","GEN","10","12","12","Kalava kotamendekli lohvna. Resen kembelva hovra lohvna Ninevara Kalara. ");
INSERT INTO wrs_vpl VALUES ("GN10_13","002_10_13","GEN","10","13","13","Isip mongova Hamnamba ombolva lohna, wo Isiptindiva men os nowana, Litiatindi, Anamtindi, Lehaptindi, Naptutindi, ");
INSERT INTO wrs_vpl VALUES ("GN10_14","002_10_14","GEN","10","14","14","Krittindi, Kaptortindi, Kaslutindi. Honamba Kaslutindiva eindhumunil lovahinvna Pilistianindna. ");
INSERT INTO wrs_vpl VALUES ("GN10_15","002_10_15","GEN","10","15","15","Wo Kenannamba yiveltowondva lohna, nihilva Saiton, mongova Het, wo pimba os sevriv Sitontindi, Hettindi. ");
INSERT INTO wrs_vpl VALUES ("GN10_16","002_10_16","GEN","10","16","16","Kenanmba simbel luhunvna Yepustindina, Amortindina, Girkastindina, ");
INSERT INTO wrs_vpl VALUES ("GN10_17","002_10_17","GEN","10","17","17","Hivitindina, Arkatindina, Sinitindina, ");
INSERT INTO wrs_vpl VALUES ("GN10_18","002_10_18","GEN","10","18","18","Avatindina, Semartindina, Hamattindina. Wo nomba Kenanna towandalva os geku vena no petharam no petharam. Venamba, petham lehra vetha. ");
INSERT INTO wrs_vpl VALUES ("GN10_19","002_10_19","GEN","10","19","19","Wo ehelva os Saitonda Gasara venamba, Gerarra, wo mongova ehelva Sotomra, Gomorara, Atmara, Sepoimra venamba, murapeta Lasara. ");
INSERT INTO wrs_vpl VALUES ("GN10_20","002_10_20","GEN","10","20","20","Doa Hamnamba men, hevna moa hevna petha hevna kembel, os himba avhoangana. ");
INSERT INTO wrs_vpl VALUES ("GN10_21","002_10_21","GEN","10","21","21","Doa Semba Yapetna etel lohmanana, wo himba simbel luhunna indkumbi Hiprunindm. ");
INSERT INTO wrs_vpl VALUES ("GN10_22","002_10_22","GEN","10","22","22","Semtindiva os nowana Elam, Asur, Apaksat, Lut, Aram. Wo pimba os seivilv Elamnind, Asurnind, Apaksatnind, Lutnind, Aramnind. ");
INSERT INTO wrs_vpl VALUES ("GN10_23","002_10_23","GEN","10","23","23","Wo Aramnamba men towandalva, Usnind, Hulnind, Geternind, Meseknind. ");
INSERT INTO wrs_vpl VALUES ("GN10_24","002_10_24","GEN","10","24","24","Wo Apaksatnamba ombolva Sela, wo Selamba mendekli venamba, ombol pola, nihilva Eper, wo noinda pimba osva nengsm uv, Epernind Semtindi av. ");
INSERT INTO wrs_vpl VALUES ("GN10_25","002_10_25","GEN","10","25","25","Epernamba sambla ombol Pelek, Yoktan. Wo Pelekva mendah avna, wo moang vungu ve notindilm notindilm. Wo noinda osva awona, Pelekm, osm uv, bukethav. ");
INSERT INTO wrs_vpl VALUES ("GN10_26","002_10_26","GEN","10","26","26","Wo Yoktantindimba men Almotatnind Selepnind, Hasamavetnind, Yeranind, ");
INSERT INTO wrs_vpl VALUES ("GN10_27","002_10_27","GEN","10","27","27","Hatoramnind, Usalnind, Diklanind, ");
INSERT INTO wrs_vpl VALUES ("GN10_28","002_10_28","GEN","10","28","28","Opalnind, Apimelnind, Sepanind, ");
INSERT INTO wrs_vpl VALUES ("GN10_29","002_10_29","GEN","10","29","29","Opirnind, Havilanind, Yopapnind. Yoktantindiva os phona, ");
INSERT INTO wrs_vpl VALUES ("GN10_30","002_10_30","GEN","10","30","30","wo ehelva os Yoktantindinamba avhoanganamba Mesa kembella Separ kembella, venamba, di olora ten okomba pholohvm. ");
INSERT INTO wrs_vpl VALUES ("GN10_31","002_10_31","GEN","10","31","32","Doa Semtindiva men hekav, wo hevna moa, hevna petha, hevna kembel, os himba avhoangana. Doa Noatindiva os nowana, Noana ombolva, hevna moa, hevna petha. Pueumbva hivranamba, indkumbi os bukethana, Noana ombolna sespal. ");
INSERT INTO wrs_vpl VALUES ("GN11_1","002_11_1","GEN","11","1","1","Nemetva indkumbiva mongawamona avna, wo himba sevrivna mana vemamba mongawamona. ");
INSERT INTO wrs_vpl VALUES ("GN11_2","002_11_2","GEN","11","2","2","Wo anganamba, os avavho vilangavna, venamba, venamba, dom okomba phovm, doa petha venamba di Bapilonda, di aevulthana nepundra. ");
INSERT INTO wrs_vpl VALUES ("GN11_3","002_11_3","GEN","11","3","3","Doa hevm ambo ishuvna, wou, petha suwera singre vi, honmsna nilhara, nonam deuvm vilm. Doa vinamba, mana vema meilna vinamba petharini, tenenna nihna, kethapetha vevna, nona sithawol vivra si honmba. ");
INSERT INTO wrs_vpl VALUES ("GN11_4","002_11_4","GEN","11","4","4","Doa hev una, mendekli deuvkembel pioa velvohra, wo mongova deuvpa pivm os vivav, verava, ovm tuhlohvra. Wo indhanamba pina andrava nunglinvra, pai, wo pivm unvra, andral. Noinda si pi homeis bukethungu vevm os, no petharam no petharam owai. ");
INSERT INTO wrs_vpl VALUES ("GN11_5","002_11_5","GEN","11","5","5","Doa heva os owai, Yaweva ona nonglalm pihana deuvkembelm deuvmendeklim, noi andra vinam. ");
INSERT INTO wrs_vpl VALUES ("GN11_6","002_11_6","GEN","11","6","6","Hev ona, nunglu, Noana towandva mongawatindi, wo moamba mongasal, wo mongawulmangas himba euvmona vevna, heva os kava doara doa ishunna, bukethungu veo indakonda, no petharam no petharam. Heva os owai, himba deuvkembelva mongasal mendeklikumbi vivna. Mani hengava si vivav hevna nengavnangnamba, memba osva vivpa? ");
INSERT INTO wrs_vpl VALUES ("GN11_7","002_11_7","GEN","11","7","7","Doa pi peivrava, indakondamona vine, osm moamba owalva ishovrava, owalva tit vivra. ");
INSERT INTO wrs_vpl VALUES ("GN11_8","002_11_8","GEN","11","8","8","Wo osoa vena, nomba kembelva deuvpa puleihina, wo bukethungu vena, no petharam no petharam. ");
INSERT INTO wrs_vpl VALUES ("GN11_9","002_11_9","GEN","11","9","9","Doa nomba kembelva os sevrivna Bapel, osm uvna, indakondamoa wulbukethav, manara, Yawe Bapelnindm indakondamona vinna, wo himba bukethungu vena. ");
INSERT INTO wrs_vpl VALUES ("GN11_10","002_11_10","GEN","11","10","10","Men Semtindiva os nowana. Noana ombol Sem lohna, wo Semba osomba 100pelara venamba, ombol pola, Apaksatm awona. Honamba os phona, pueumbva hivrapianamba, osomba sambla vewolna. ");
INSERT INTO wrs_vpl VALUES ("GN11_11","002_11_11","GEN","11","11","11","Wo Semba osomba 500pelara henga anamba, wo otolva phomnavna tuendis mutundis. ");
INSERT INTO wrs_vpl VALUES ("GN11_12","002_11_12","GEN","11","12","12","Apaksatva osomba 35pelara venamba, ombol pola, wo Selam awona. ");
INSERT INTO wrs_vpl VALUES ("GN11_13","002_11_13","GEN","11","13","13","Apaksatva osomba 403pelara henga venamba, wo otolva phomnavna tuendis mutundis. ");
INSERT INTO wrs_vpl VALUES ("GN11_14","002_11_14","GEN","11","14","14","Selava osomba 30pelara venamba, ombol pola, Eperm awona. ");
INSERT INTO wrs_vpl VALUES ("GN11_15","002_11_15","GEN","11","15","15","Wo Selamba osomba 403pelara venamba, henga anamba, wo otolva phomnavna tuendis mutundis. ");
INSERT INTO wrs_vpl VALUES ("GN11_16","002_11_16","GEN","11","16","16","Eperva osomba 34pelara venamba, ombol pola, Pelekm awona. ");
INSERT INTO wrs_vpl VALUES ("GN11_17","002_11_17","GEN","11","17","17","Wo Eperva osomba 430pelara henga anamba, otolva phomnavna tuendis mutundis. ");
INSERT INTO wrs_vpl VALUES ("GN11_18","002_11_18","GEN","11","18","18","Pelekva osomba 30pelara venamba, ombol pola, Leum awona. ");
INSERT INTO wrs_vpl VALUES ("GN11_19","002_11_19","GEN","11","19","19","Wo Pelekva henga osomba vena 209pelara, henga anamba, wo otolva phomnavna tuendis mutundis. ");
INSERT INTO wrs_vpl VALUES ("GN11_20","002_11_20","GEN","11","20","20","Leuva osomba 32pelara venamba, ombol pola, Serukm awona. ");
INSERT INTO wrs_vpl VALUES ("GN11_21","002_11_21","GEN","11","21","21","Wo Leuva henga osomba 207pelara venamba, henga anamba, wo otolva phomnavna tuendis mutundis. ");
INSERT INTO wrs_vpl VALUES ("GN11_22","002_11_22","GEN","11","22","22","Serukva osomba venamba 30pelara, wo ombol pola, Nahorm awona. ");
INSERT INTO wrs_vpl VALUES ("GN11_23","002_11_23","GEN","11","23","23","Wo Serukva osomba 200pelara henga anamba, otolva phomnavna tuendis mutundis. ");
INSERT INTO wrs_vpl VALUES ("GN11_24","002_11_24","GEN","11","24","24","Nahorva osomba venamba 29pelara, wo ombol pola, Teram awona, ");
INSERT INTO wrs_vpl VALUES ("GN11_25","002_11_25","GEN","11","25","25","wo Nahorva henga anamba, osomba 119pelara venamba, wo otolva phomnavna tuendis mutundis. ");
INSERT INTO wrs_vpl VALUES ("GN11_26","002_11_26","GEN","11","26","26","Terava osomba 70pelara venamba, ombol samblamong pho, os awowol vena Apram, Nahorm, Haranm. ");
INSERT INTO wrs_vpl VALUES ("GN11_27","002_11_27","GEN","11","27","27","Teratindi nowana os. Terana ombolva samblamong, Apram, Nahor, Haran. Wo Haranmba mendekli venamba, ombol polamna, Lotm awona. ");
INSERT INTO wrs_vpl VALUES ("GN11_28","002_11_28","GEN","11","28","28","Wo Terava mendah lohvna, Haranmoa os wohdahana. Di Bapilon pethara Ur kembella hemba dahana, ten di doara aval lengnam. ");
INSERT INTO wrs_vpl VALUES ("GN11_29","002_11_29","GEN","11","29","30","Doa Apramba ongam vrana Saraim, himba yunam phangangal avna. Wo Nahorva eva ongam vrana, Milkam Haranna molm. Molva mongova Iska. ");
INSERT INTO wrs_vpl VALUES ("GN11_31","002_11_31","GEN","11","31","31","Doa Tera phonamba, Bapilonm wuleihana, honam wongana, ombolm kolm umbeindilm. Ur kembellini venamba, wonganamba, ona Kenan petharam pulvotam, wo owai, ambo di Haran kembella aevulthana. ");
INSERT INTO wrs_vpl VALUES ("GN11_32","002_11_32","GEN","11","32","32","Wo di Haran kembella Teramba os wohdahana, osomba hevnamba 205pelara os lohmanana. Doa. ");
INSERT INTO wrs_vpl VALUES ("GN12_1","002_12_1","GEN","12","1","1","Wo Yawe Apram os ishomnana, gao, hona kembelmoa wuleiho, pevna aratindim, pevna owalm, pevna petham. Yeoa mongona petharam gao, si yemba kava indthoamnavav. ");
INSERT INTO wrs_vpl VALUES ("GN12_2","002_12_2","GEN","12","2","2","Wo yetindiva si noinda mindnam phovav, kuwulva si mendekli yimba wulluhunvav, manara yemba si kava kolvrevav. Wo yimba si os vinvrata, indhanamba kolvrowol vevav. ");
INSERT INTO wrs_vpl VALUES ("GN12_3","002_12_3","GEN","12","3","3","Wo indhanamba yemba beswonamba vrivrava, nomba indhanamba kava si beswonam eva vewol vevrata. Heva os yemba nomba indhanamba sahonamba vritava, no indhanamba si kava sahonam vewol vevav. Wo kananapopol yimba si beswonam vinvav indakonda pethanindmba. ");
INSERT INTO wrs_vpl VALUES ("GN12_4","002_12_4","GEN","12","4","5","Doa Apramba Yawena moamba hellenamba, wo ga Harandini. Hena osomba os lohmanavna 75pelara, wo himba gana os. Himba ongalm, buesilm, andranindm, wohm, noi wondambnamba, os wohgana Harandini. Andranindva nomba, wohva nomba, himba doara dombvna di Haranda. Wonganamba, Kenanmonam vinamba, doa petham nonglapulvo Kenan petham. ");
INSERT INTO wrs_vpl VALUES ("GN12_6","002_12_6","GEN","12","6","6","Kenan hovmonam vinamba, deuvkembella pulvo Sekemra. Wo diva kembellava murapetava sahit lohvna, os sevrivna More, di aevulthana, nonamba Kenannindva mendah di aevluwul vevna. ");
INSERT INTO wrs_vpl VALUES ("GN12_7","002_12_7","GEN","12","7","7","Wo di Yawe Apram nonglapho, omnana, hona pethangas yetindimba kava si kovorahunvav. Doa Apramba hon songowol venanamba Yawem, temba hemba diva nonglaphonamba. ");
INSERT INTO wrs_vpl VALUES ("GN12_8","002_12_8","GEN","12","8","8","Doa Apramba henga nomini wonga, oloram angana, doa lailduv di vewol vi hovrahovra, Ai kembella, okomba os phovm, Betel kembella, okomba nosis vohavm. Wo di himba henga hon songowol venana Yawem, sembayang venavna. ");
INSERT INTO wrs_vpl VALUES ("GN12_9","002_12_9","GEN","12","9","9","Wo nominiva pulvonamba, avavho vilangavna mendah Kenan petharam. Isipnasis os avavho vilangavna. ");
INSERT INTO wrs_vpl VALUES ("GN12_10","002_12_10","GEN","12","10","10","Doa dawonam owous pho di Kenan pethara, innemba owai, noinda Apram mongona petharam wonga, Isip petharam dom aevulthalm. ");
INSERT INTO wrs_vpl VALUES ("GN12_11","002_12_11","GEN","12","11","12","Himba murava wongavnamba, doa Saraim ongalm os ishomnana, yimba besal hevm, noinda kava pem vev, Isipnindva ata yemba nunglivrava, ata hevm eishovra, Apramna ongal. Noinda kamba ata helvakomandhalmba vivra, wo yemba beswonam vreivav hevm. ");
INSERT INTO wrs_vpl VALUES ("GN12_13","002_12_13","GEN","12","13","13","Os unu, kava Apramnamba muskovol, Isipnindva osva kamba helvakomandhivavmoa, owai, kamba beswonam lelh vrivav yeindava. ");
INSERT INTO wrs_vpl VALUES ("GN12_14","002_12_14","GEN","12","14","14","Doa Isip pethara wonpho, wo Isipnindva Saraim nunglina, pai besal hevm av. ");
INSERT INTO wrs_vpl VALUES ("GN12_15","002_12_15","GEN","12","15","15","Doa Pero kuwultatana eva nunglina, wo Perom ishumnina, ungevliriniva nomba besal hevm, noinda Pero vrana hevm. ");
INSERT INTO wrs_vpl VALUES ("GN12_16","002_12_16","GEN","12","16","16","Vranamba, Pero Apram beswonam vrevna Sarai inda, wo os dambroh vena tatamba mindnam, eva indhanam wuleihowol vemnana andranindilm, tendona onganamba. ");
INSERT INTO wrs_vpl VALUES ("GN12_17","002_12_17","GEN","12","17","17","Heva os Yaweva Perotatanamba vevandm wolaihaphunna, manara Pero Saraim vranamba Apramna ongalm. ");
INSERT INTO wrs_vpl VALUES ("GN12_18","002_12_18","GEN","12","18","19","Wo Pero ona, Apram prora, kav sah ovrelm vev. Apram pronamba, Pero omnana, manaram yimba kamba osva sahonamba venavna, manara yimba kamba omnanamoa, osva memba kana ongal? Manara yimba kamba doarava ishomnana, memba kana muskovol, noinda kava vrana? Oh, men Saraiva, pev vrao, wo waiwohgao kanaminioa. ");
INSERT INTO wrs_vpl VALUES ("GN12_20","002_12_20","GEN","12","20","20","Doa Pero hevtatanam unna, wonango Apram, hevna ongalm, hevna andranindm, wohm manam manam, huiva aevulvavmoa, owai. ");
INSERT INTO wrs_vpl VALUES ("GN13_1","002_13_1","GEN","13","1","1","Doa Apramba nominiva wonganamba Isip pethariniva, henga Kenan pethara aevulthana. Ongalm buesilm wohm di wonavhoana. ");
INSERT INTO wrs_vpl VALUES ("GN13_2","002_13_2","GEN","13","2","2","Wohtowond himba lohna, sipsip meme sapi diva mindnam. ");
INSERT INTO wrs_vpl VALUES ("GN13_3","002_13_3","GEN","13","3","4","Doa henga Kenan hovmonam avavho vilangavna, doa di wonavna, ten seilm hev lailduv wonvenam, honmba songowol venanamba Sesoamba. Diva wonphonamba, doa henga Yawem di sembayang vemnavna. Diva aevulvna hovrahovra Betel kembella Ai kembella. ");
INSERT INTO wrs_vpl VALUES ("GN13_5","002_13_5","GEN","13","5","5","Doa Lotnamba mani mani eva ata lohmanata, ongalm otolm andranindm sipsipm memem sapim. ");
INSERT INTO wrs_vpl VALUES ("GN13_6","002_13_6","GEN","13","6","6","Wo diva no petharava mani mani lohvnamoa mindnamba sapina innemba. Noinda samblaisnamba beswonamba himba evevnamoa. ");
INSERT INTO wrs_vpl VALUES ("GN13_7","002_13_7","GEN","13","7","7","Hena andranindva hevm akosrombomana vevna, nomba andranindva temba himba sapimba dahwol vivnamba. Nonamba vivnamba, ungundva mendah di eku vevna Kenannindva eva Peresnindva. ");
INSERT INTO wrs_vpl VALUES ("GN13_8","002_13_8","GEN","13","8","8","Doa Apram buesilm ishomnana, pimba mongawatindi, wo osva sahokla vev, yena andranind, kana andranind, wo hevmba akosrombomana vev sapina innenilmba. ");
INSERT INTO wrs_vpl VALUES ("GN13_9","002_13_9","GEN","13","9","9","Pioa indakonda petharam engawoli, wo yimba domba gatava, eva kava mongnahalm gavav. Yesna otok, wo yimba domba gatava, eva kava mongnahalm gavav. ");
INSERT INTO wrs_vpl VALUES ("GN13_10","002_13_10","GEN","13","10","10","Doa Lotva nungsis velohanamba, nonglapiha vena Yotanpundm, lehra, besal hevm keleilvna. Nonglanga vena, pomba mindnam gengu vev diva. Pethava nomba snal lohvna, ovna, Yawena oso, ten Yawe hev denwit wolanam, eva maim oi Isipnindna petha, ten keleilinvm Soar kembelnahalm Wo nonamba Lotva osva omnanamba eisilmba Yotanpundram, memba nonam mendah Sesoava kota samblamba indkokla vrowolvnamoa, owai, Sotom kembelm Gomora kembelm, no pundra elohvnam. ");
INSERT INTO wrs_vpl VALUES ("GN13_11","002_13_11","GEN","13","11","11","Doa Lotva os momong evethawolna eisiliva. Enganamba, Lotva eisilmba dasvholahangana, dom ten okomba pholohvm, os singthavna Yotan pundmba. ");
INSERT INTO wrs_vpl VALUES ("GN13_12","002_13_12","GEN","13","12","12","Doa Apramba hevpa di lumbulla wonavna, wo buesilva eva himba di pundra wonavhoa, temba ungundna kembelva luhungu vinvnam. Wo mongo kembella murapeta himba wonavhoana Sotom kembella. ");
INSERT INTO wrs_vpl VALUES ("GN13_13","002_13_13","GEN","13","13","13","Sotom kembelnindva nomba sahoklal, wo hev Yawemba sahokla vrivna. ");
INSERT INTO wrs_vpl VALUES ("GN13_14","002_13_14","GEN","13","14","14","Doa Apram buesilm velaihangana, wo sisva Yawe Apram omnana, nungsis vetok, ambo beswonam nongalungu vevm. ");
INSERT INTO wrs_vpl VALUES ("GN13_15","002_13_15","GEN","13","15","15","Nomba yimba temba nongalvpa, si yetindim kava kovorahunvav, wo he si yunalm wohvaohuthuivav. ");
INSERT INTO wrs_vpl VALUES ("GN13_16","002_13_16","GEN","13","16","16","Yetindiva si mindnam phovav, wo an eva sevelvav, owai, si os ora engalslambosla. ");
INSERT INTO wrs_vpl VALUES ("GN13_17","002_13_17","GEN","13","17","17","Doa wongao, wo avavho vilangavm nonglalm, manara kava si yemba kovorahunvav. ");
INSERT INTO wrs_vpl VALUES ("GN13_18","002_13_18","GEN","13","18","18","Doa Apram hellenamba, lailduvpa ningewol venamba, anga. Anganamba, di wonpho Hepron kembella. Wonphonamba, sahitra henga aevulthana di Mamreinda. Doa Apramba henga honmba songowol venanamba, Yawemba sembayang venalm. ");
INSERT INTO wrs_vpl VALUES ("GN14_1","002_14_1","GEN","14","1","7","Doa buesilva di pundra wonavhoanamba, di ten ungundna kembelva luhungu vinvnam, Sotom kembel, Gomora kembel, wo eva mongla. Wonavhoanamba, sisva daos mendekli di ohona Lotna novra, plalmomba men. Pundnindna kuwulva 5pelara di kusona, hevm una, pioa nomongo owalwolvohra. Himba Sotomnindnamba kuwulva, nihilva Bera, Gomoranindnamba kuwulva, nihilva Birsa, Atmanindnamba kuwulva, nihilva Sina, Sepoimnindnamba kuwulva, nihilva Semper, eva Belanindnamba kuwulva. No Bela kembelva indanam sevrivna os, Soar. Nomba kuwulva himba noinda daosm uvna, osomba 12pelara himba keusingi lovahvna mongnindna kuwulna, wo hev keusingiva noinda ovumnina, nomba kuwulva nihilva Ketolaoma, himba Elamnindna kuwul wulluhunvna. Wo Ketolaomava eva hillinnamba, wo himba owai vevna, wo dawonam mongona tahonnam himba hevna owalm kuwulm 3pelaram nembaomana venamba, doa owalwolalm wonprovna, hevna daosnindm wonambvna. Nomba kuwulva 3pelarava himba Bapilonnindna kuwul, nihilva Amrapel, Elasarnindna kuwul, nihilva Ariok, eva Goinindna kuwul, nihilva Tital. Doa Ketolaomatatana ambanamba, boasna owalwole monglava kembelnindmba, os ningthiv Repai, Sus, Emi, Hor. Repainindmba himba owalwolanamba di Asterotkanara, doa os wohengilanga. Susnindmba himba owalwolanamba di Hamda, doa os wohengilangana. Emnindmba himba owalwolanamba di pundra Kiriataim, os wohengilangana. Hornindmba himba olora Seirra owalwolanamba, doa engilanganamba dem kembellam Elpararam di ella pethakoklara. Doa henga heoa ambna Kates kembellam, no Kates kembelva nonamba os sevrivna Enmispat. Wo osva himba pethamba wohvaohuthunvna hevm Amaleknindna. Wo mongnindm engilanganamba Amornindm, diva temba Hasasontamar kembella aevulvnam. ");
INSERT INTO wrs_vpl VALUES ("GN14_8","002_14_8","GEN","14","8","9","Doa Ketolaoma tatana mendah ambvna owalwolalm, doa kuwulva nomba 5pelara pundra kuso, Sitimpundra kusona hevna daosnindmongo. Sitimpund osm uv, Wanpund. Kusonamba, Ketolaomatatanamba ambanamba, owalwole, owalwolvnamba, welhina mindnam. ");
INSERT INTO wrs_vpl VALUES ("GN14_10","002_14_10","GEN","14","10","10","Doa Sotomnindna kuwul, Gomoranindna kuwul, himba pem engalm evevna. Heva os owai, melva di luhungu vevna pundrava, wo mella epihohowolna. Kuwulva monglava samblamongova wohangana pem oloram. ");
INSERT INTO wrs_vpl VALUES ("GN14_11","002_14_11","GEN","14","11","11","Doa Ketolaomatatana os vivna, Sotom kembella Gomora kembella pulvowolna, wohva mani mani hevelm vravna innenahonam. ");
INSERT INTO wrs_vpl VALUES ("GN14_12","002_14_12","GEN","14","12","12","Lotva doara di Sotomra ana nemetva, wo noinda Lotmba kevrina wohnahonam, os wohwaiangana. ");
INSERT INTO wrs_vpl VALUES ("GN14_13","002_14_13","GEN","14","13","13","Doa mongo indhanarini wohgana, ishomnana Apram Hiprunindrinim, ten mendah wonavnam sahitra murapeta di Mamreinda. Mamreva nomba Amortindi, wo he boaslal sambla os aevulvna Apramna sehel. Boaslal samblana nihilva Eskol eva Aner. ");
INSERT INTO wrs_vpl VALUES ("GN14_14","002_14_14","GEN","14","14","14","Doa Apramba os hellena, Lotva ungundna englisra einv. Wo himba nembaomana vevnamba, nom hev di wonavnam daosnindm, noi ten daos nonora vilovnam, os avna 318pelara. Nembaomana venamba, doa Ketolaomatatanam engilanga. Engilanganamba, di nonglapho Dan kembella. ");
INSERT INTO wrs_vpl VALUES ("GN14_15","002_14_15","GEN","14","15","15","Doa boasna himba hevtatanam moang vuku vena, wo sinim poaita ambwul venamba, ambanamba owalwolalm, doa engilungu vena. Venamba, engilpihal ve, venamba, Hopa kembella di Damaskusra nohalm. ");
INSERT INTO wrs_vpl VALUES ("GN14_16","002_14_16","GEN","14","16","16","Wo wohva innemba henga dumbna, temba himba hevelmba vranamba seilmba Sotom kembelliniva Gomora kembelliniva. Wo eva hevna buesilmba henga mohvena hevna wohnahonam. Ungevlitundism eva indhanam himba henga muehrombol vina, temba himba kekaiv vinamba. ");
INSERT INTO wrs_vpl VALUES ("GN14_17","002_14_17","GEN","14","17","17","Doa Apramtatana os Ketolaomatatanam kuvhoawol vina, henga ambe. Ambvnamba, di Savepundra vivnamba, Sotomnindna kuwulva gavna, monara di anongla vena. Savepundva indanam sevrivna Kuwulna Pund. ");
INSERT INTO wrs_vpl VALUES ("GN14_18","002_14_18","GEN","14","18","18","Wo eva mongo kuwul hevna deuvrini venamba, di Apramba monara anongla vena, nihilva Melkisetek, wo himba Salem kembelnindna mendekli kuwul wulluhunvna. Melkisetekkumbiva nomba hovra luhunvna, vevna indhanam piawol vevna, eva Sesoamendeklim piavna. Himba Apramba nonglaphonamba, wainpol roti noi dembrahona, ");
INSERT INTO wrs_vpl VALUES ("GN14_19","002_14_19","GEN","14","19","19","omnana, Sesoa mendekli yemba awothov, ten ovm petham vewol vevnam. ");
INSERT INTO wrs_vpl VALUES ("GN14_20","002_14_20","GEN","14","20","20","Sesoamba kava okolav, manara himba yemba doa poauothona, wo noinda yengasva welhokomo vina ungundmba. Doa Apramba henga woh eunumbulva mindnam dembrahona Melkisetekmba, noi dembrahona wohva innemba mani mani, temba himba ungundna englariniva dumbnamba. ");
INSERT INTO wrs_vpl VALUES ("GN14_21","002_14_21","GEN","14","21","21","Doa Sotomnindna kuwulva os ishomnana Apramba, katindim henga wonambo, ten pev ungundna englarini muehrombol wonvenam. Wohva innemba owai, pevm iango, kana indhanamangas wonambo. ");
INSERT INTO wrs_vpl VALUES ("GN14_22","002_14_22","GEN","14","22","23","Wo Apramba henga omnana, yetindimba men kava wonambv, wo wohva innemba owai, kava iangavavmoa kavmba. Yawe mendeklina novra men kava yemba wohishomnav, ten ovm petham vewol venam. Wo mani mani yenamba kava wohdembhivav, kava yena mana vemapetava wulavavmoa, owai. Si homeis yimba kamba ishomana venavm os, Apramba kana kolmal ambo iav, noinda wohtowondva lohv. ");
INSERT INTO wrs_vpl VALUES ("GN14_24","002_14_24","GEN","14","24","24","Kavmba kava wulavavmoa, eunumbulva doa kana daosnind hlana, wo Aner, Eskol hena etelva Mamre, hevm moang vinu kana sehelm. ");
INSERT INTO wrs_vpl VALUES ("GN15_1","002_15_1","GEN","15","1","1","Doa sisva Apram inungpunung vevna, Sesoam hellevna, os ishomnavna, manam yimba ungundnapenamba pemba vevav. Kav si yemba kekalvho vromana venavav, wo mana ema besalangas si yemba kava nis ambo vrahovav. ");
INSERT INTO wrs_vpl VALUES ("GN15_2","002_15_2","GEN","15","2","2","Doa Apramba henga omnana, yimba Yawe mendekli av, wo yimba kamba mana emamba besalva vrahovrava, lehra. Heva os kava otolhui lohv, wo si kamba daharava, puewulva si ambalnindrini vaohothovav. Men kainda lohv, kana andranindrini, nihilva Elieser. Himba katindiriniva owai, himba Damaskus kembellini. ");
INSERT INTO wrs_vpl VALUES ("GN15_3","002_15_3","GEN","15","3","3","Yimba kamba venanamoa doarava, osva ongaloa doara tuendisrinim lengmanara, wo noinda andranindriningas si kanamba vaohothovav. ");
INSERT INTO wrs_vpl VALUES ("GN15_4","002_15_4","GEN","15","4","4","Doa henga hellevna Yawem, owai, Elieserva si yenamba vaohothovavmoa. Yena ombpovpa si lohvav, si hev vaohothovav. ");
INSERT INTO wrs_vpl VALUES ("GN15_5","002_15_5","GEN","15","5","5","Doa Yawe waiholopenamba ninmerini amballam, omnana, paim nongalvongo vetok, es hevpa yimba sevelvavma!, si yetindiva os avav. ");
INSERT INTO wrs_vpl VALUES ("GN15_6","002_15_6","GEN","15","6","6","Doa Apramba hellenamba, ona tanamolnam ishov, Yawem lohvhoamnavna hevna undnahonam, wo noinda Yaweva hemba nengthana, indhanarini windel. ");
INSERT INTO wrs_vpl VALUES ("GN15_7","002_15_7","GEN","15","7","7","Doa Yawe ishomnana, kava Yawe, kava doara yemba waipronamba Bapilon petharini Ur kembellini homba, osm hona pethamba kava yemba kovoraholm vev. ");
INSERT INTO wrs_vpl VALUES ("GN15_8","002_15_8","GEN","15","8","8","Wo Apramba henga omnana, lehra, wo mani yimba ata vevav, osva kava lihavav, ora si kavmangas kovorahovav? ");
INSERT INTO wrs_vpl VALUES ("GN15_9","002_15_9","GEN","15","9","9","Doa Yaweva henga omnana, os veo, sapim waipro, memem waipro, sipsipm aralm waipro, nomangas wonpro, ovra memba samblamong tahonna lovahv, wo eva leumbva sambla. ");
INSERT INTO wrs_vpl VALUES ("GN15_10","002_15_10","GEN","15","10","10","Doa Apramba os wohvena, ten Yawe hevm wohomnanam, tatamba nomba ipromnanamba Yawemba, doa ovla vranamba, nona hovrahovra popowol vevna. Venamba, vevna mongnahalm pulundthoavna, mongnahalm pulundthoavna, hovrava mona dihelgavna. Heva os leumb samblava owai, kovhoawolnamoa. ");
INSERT INTO wrs_vpl VALUES ("GN15_11","002_15_11","GEN","15","11","11","Doa tatamba di dembhalohvna, hultuwa ambvnamba wehlalm, wo Apram engalvna hultuwamba. ");
INSERT INTO wrs_vpl VALUES ("GN15_12","002_15_12","GEN","15","12","12","Osangas vevnamba, okombava vohavnamba, Apram ninpol livna. Livnamba, inungpunung vevna, pem mindnam kava vev. ");
INSERT INTO wrs_vpl VALUES ("GN15_13","002_15_13","GEN","15","13","13","Doa Yaweva omnana, tanam yetindiva mindnam avav, wo ungundna petharava si euvmona vevav. Di si himba andranindilmangas avav ungundna keusingi, wo hemba mindnam ishunvav notongandram notongandram, kinsombm hemba vinvav. Hevpa si os ungundna keusingiva avav, wo hena ombolva avav, verava, umbeindilva, simbelva os si avav. Honamba tahonmba si verava, 400pelara lohvrava, ");
INSERT INTO wrs_vpl VALUES ("GN15_14","002_15_14","GEN","15","14","14","wo sisva kava no ungundmba kinwonda plothunvav, temba henomba vivpa, wo yetindiva si beswonam pulvovav ungundna englisriniva. Pulvovrava, wohva mani mani besalva si os ipulvovav. ");
INSERT INTO wrs_vpl VALUES ("GN15_15","002_15_15","GEN","15","15","15","Si yimba verava, mundkola verava, os dahavav, wo yemba si os singvivav. ");
INSERT INTO wrs_vpl VALUES ("GN15_16","002_15_16","GEN","15","16","16","Amornindmba hona pethanindmba kava engilpiangavavmoa lelnamba daipotava. Hena indkoklava mani mendeklima, heva os dawonam himba indkoklava si ora mendekliva vira, si os kava engilpiangavav, wo yetindiva os ambvav homba aevulthalmba. ");
INSERT INTO wrs_vpl VALUES ("GN15_17","002_15_17","GEN","15","17","17","Doa sia kilvranamba, Apramba os nongalvna, pai, suwemba sambla tawolv. Os gawol evevna, tatahovra tawolvna, os ten doara hev tata noi pulundthoawolnam mongnahalm mongnahalm. Mongova luwil doahnasowa litutholohvna, mongova gululuvhoasowa tavna. ");
INSERT INTO wrs_vpl VALUES ("GN15_18","002_15_18","GEN","15","18","18","Wo nonamangas Yaweva Apramba osva omnana, men kava yemba tanam ishomnav, hona pethamangas si kava yetindimba kovorahunvav. Mendekli pethava kava kovorahunvav, verava Isipnindna ambsalla, verava Yupretis pora. ");
INSERT INTO wrs_vpl VALUES ("GN15_19","002_15_19","GEN","15","19","21","Wo ungundva memba huiva aevulvpa, hena pethava kava si yetindim kovorahunvav, Kennindna petha, Kenisnindna petha, Katmonnindna petha, Hitnindna petha, Peresnindna petha, Lepanindna petha, Amornindna petha, Kenannindna petha, Girkasnindna petha, Yepusnindna petha. ");
INSERT INTO wrs_vpl VALUES ("GN16_1","002_16_1","GEN","16","1","2","Doa Apramnamba ongalva Saraiva phal avna, wo noinda himba tlalm omnana, kava andranindrinim men waiav Isipongorinim, nihilva Hakar. Kava yemba os nengmanav, yeoa Hakarm vro, verava, ena vethara, manara, kava phal av, kava si yemba otolva sleihamanavavmoa, manara Yawe doa emba kanamba kevrana. Himba otolva lengtava, si kava osva ovav, kana. Memba pina wevsa luhunv. ");
INSERT INTO wrs_vpl VALUES ("GN16_3","002_16_3","GEN","16","3","3","Doa Apramba hellenamba, ona, lehra, wo Saraiva ungevlirinim nom wolaihaprona, osm mongawulm di ahara. ");
INSERT INTO wrs_vpl VALUES ("GN16_4","002_16_4","GEN","16","4","4","Waiamana venamba, doa Hakarva nukulthoavna, hevm lihana, kakowa doa kinsombol av, noinda osva Saraina moamba hellevnamoa, esesm ahalvna. Nonam phona, Apramba di Kenan pethara avna, tahonmba 10pelara vevna. ");
INSERT INTO wrs_vpl VALUES ("GN16_5","002_16_5","GEN","16","5","5","Doa Saraiva phonamba, tlalm okosve, ye indkokla venamba. Hakarva kana moamba hellevmoa. Lihav, osva ena vethav kamba, wo noinda moamba hellevnamoa. Wo noinda osva Yawe heva osva ovav, an indkoklava vena, ye ora ka. ");
INSERT INTO wrs_vpl VALUES ("GN16_6","002_16_6","GEN","16","6","6","Doa Apramba henga omnana, manapenam, yena memba andranindrini, wo yimba hemba mana vemamba vemnavrava, veo manapenam. Noinda Saraiva Hakarmba sahonam vrevna, wohpholahangana. ");
INSERT INTO wrs_vpl VALUES ("GN16_7","002_16_7","GEN","16","7","7","Doa monam gavna, di pethakoklara ganamba, pora avna di Sur kembella murapeta. Doa Yawena moainal ovsongolnindrini nonglaphonamba, ");
INSERT INTO wrs_vpl VALUES ("GN16_8","002_16_8","GEN","16","8","8","Hakarm omnana, yimba henimonam gav?, yimba Saraina andranindrini. Hinimini yimba prov, hem yimba gav? Hev omnana, kava Sarainamini pem gav. ");
INSERT INTO wrs_vpl VALUES ("GN16_9","002_16_9","GEN","16","9","9","Doa he omnana, owai, henga gao, beswonam avhoao hena keusingi. ");
INSERT INTO wrs_vpl VALUES ("GN16_10","002_16_10","GEN","16","10","10","Yemba si os kava vrevav, yetindiva si mindnam phovav os i, es eva seivilvav. ");
INSERT INTO wrs_vpl VALUES ("GN16_11","002_16_11","GEN","16","11","11","Yimba memba enamba avpa, wo si yimba otolmba lengvav tuendisrinim, os awoo Ismaelm. Noinda osoa veo, Yawe doa yenamba wenopmomba hellena, yemba wavra vovhoamnav. ");
INSERT INTO wrs_vpl VALUES ("GN16_12","002_16_12","GEN","16","12","12","Heva os yena ombol mendekli verava, oi sungeitwinde, wo himba si daos ungundrinimsna lohvav, himba owalmongova euvmona vevavmoa. ");
INSERT INTO wrs_vpl VALUES ("GN16_13","002_16_13","GEN","16","13","13","Doa Hakar hellenamba, evekingil vetha, ona, tanamolnam kava Yawemangas nonglai, wo beswonam kamba ishomni, helveimoa. Noinda os omnana, Sesoa tanamolnam kamba nonglav. ");
INSERT INTO wrs_vpl VALUES ("GN16_14","002_16_14","GEN","16","14","14","Wo noinda indhanamba pomba nomba osva sevriv, Sesoana pomba, nomba Sesoava indhanamba nongalv. Pomba nomba di liv hovrahovra Katesra Beretra. ");
INSERT INTO wrs_vpl VALUES ("GN16_15","002_16_15","GEN","16","15","15","Doa Hakarva ganamba, tuendisrinim di lengna Apraminda. Wo aral os awona Ismaelm. ");
INSERT INTO wrs_vpl VALUES ("GN16_16","002_16_16","GEN","16","16","16","Aralna osomba os lohmanavna 86pelara, wo ombolva os lengmanana. ");
INSERT INTO wrs_vpl VALUES ("GN17_1","002_17_1","GEN","17","1","1","Doa sisva Yaweva henga Apramba nonglaphona. Honamba os phona, Apramna osomba os lohmanavna 99pelara. Phonamba, os ishomnana, kava Sesoa, kava keknamangas lohv, wo yeoa kana moamoa hellengas veo, wo besalm wevsam engvm. ");
INSERT INTO wrs_vpl VALUES ("GN17_2","002_17_2","GEN","17","2","2","Henga yemba kava tanamolnam ishomnav, yetindiva si mindnam phovav kanapopol. ");
INSERT INTO wrs_vpl VALUES ("GN17_3","002_17_3","GEN","17","3","3","Doa Apramba hellenamba, mulumbdandna lohvhoamnana, ku kusithana petharam. Wo henga Sesoa omnana, ");
INSERT INTO wrs_vpl VALUES ("GN17_4","002_17_4","GEN","17","4","4","men kava yemba tanamolnam ishomnav, yimba mani hena aralangas luhunvma, yimba indkumbina luhunv, ");
INSERT INTO wrs_vpl VALUES ("GN17_5","002_17_5","GEN","17","5","5","wo osva yemba kava awov Apraham, Apram nihiloa wuleihao, manara, yimba indkumbina aral luhunv. ");
INSERT INTO wrs_vpl VALUES ("GN17_6","002_17_6","GEN","17","6","6","Monglava yenamba otomotalva si mendekli avav, yetindiva si petharava kekel vethangavav, no pethara, no pethara. ");
INSERT INTO wrs_vpl VALUES ("GN17_7","002_17_7","GEN","17","7","7","Hona tanamolmomba yemba kava maivethavavmoa yena otomotalhumunmba, si kava Sesoa wohluhunvav yena otomotalhumunmba. ");
INSERT INTO wrs_vpl VALUES ("GN17_8","002_17_8","GEN","17","8","8","Pethava honamba kava yemba si kovorahunvav, yem yena otomotalm, men huiva daipotava yimba ambalnindalm lohv Kenannindna pethara. Yetindiva si wohvaohuthuivav yunalm, wo kava hena Sesoa luhunvav. ");
INSERT INTO wrs_vpl VALUES ("GN17_9","002_17_9","GEN","17","9","9","Doa Sesoa mendah Apraham ishomnavna, yeoa kana moamoa vevrarava, osva kana keusingi lovahmanavav, ye yena otomotalm yunalm. ");
INSERT INTO wrs_vpl VALUES ("GN17_10","002_17_10","GEN","17","10","10","Yeoa osangas vivm, hutovpa kukunvm indakonda. ");
INSERT INTO wrs_vpl VALUES ("GN17_11","002_17_11","GEN","17","11","12","Tuendisriniva simba 8pelara vevrava, doa hutovpa os kovhoamnavra. Wo yena wevsaoa osangas luhunvra daipotava, verava yunalm. Memba honamba os lohvra yena nihrava, osm indhanamba yemba nunglivra, yimba doa katindilm siheinna. Honaoa pevtindim vinvm, wo andranindm vinvm, ten aval yena deuvra tetwond vinvm. Wo andranindm vinvm, ten pev indhanana englisrini holvorombol vivnam dina. ");
INSERT INTO wrs_vpl VALUES ("GN17_13","002_17_13","GEN","17","13","13","Hona hutovmomba kava yemba ishomnavpa olhmoa, osva yemba kava tanamolnam wohishomnav. ");
INSERT INTO wrs_vpl VALUES ("GN17_14","002_17_14","GEN","17","14","14","Wo himba nomba mendah hutovna lohv, owai, kava nonglavavmoa, osva ora katindi, manara himba kana moamba engvmoa, owai. ");
INSERT INTO wrs_vpl VALUES ("GN17_15","002_17_15","GEN","17","15","15","Doa Sesoa mendah Apraham ishomnavna os, ongapevpa manam yimba hengava omnavav Sarai, owai, os sevro Sara. ");
INSERT INTO wrs_vpl VALUES ("GN17_16","002_17_16","GEN","17","16","16","Kava si beswonam vrevav, wo ena vethavav, tuendisrinim lenge yeinda. Honamba kava wohvevrava, henamba otomotalva si mindnam pulvovav no pethara no pethara, wo monglava si os kuwul mendekli ilvahul vevav. ");
INSERT INTO wrs_vpl VALUES ("GN17_17","002_17_17","GEN","17","17","17","Doa Aprahamba hellenamba, henga ku kusithana petharam, doa los omnavna, os nengvna, es hevpa kava otolmba nengand vrevav, doa kamba mundkolatov vena, osomba kanamba os 100pelara lohv. Wo ongalva kanamba eva mundkolatovol, osomba os 90pelara henamba lohvta. ");
INSERT INTO wrs_vpl VALUES ("GN17_18","002_17_18","GEN","17","18","18","Doa Sesoam os osahmanana, yimba nonora, ombolva kanamba lohv Ismael, wo es hevpa heindava yena moanonoava lohvavma? ");
INSERT INTO wrs_vpl VALUES ("GN17_19","002_17_19","GEN","17","19","19","Wo Sesoa henga omnana, owai, yena ongapevnonoa Sara si lengvav otolmba, Isakm awoo. Wo kana moanonoava heinda wohlohvav, hem, hena otomotalm si osangas yunalm. ");
INSERT INTO wrs_vpl VALUES ("GN17_20","002_17_20","GEN","17","20","20","Ismaeloa yena hemomomba kava hellevta, wo noinda kava si beswonam vrevav, wo hetindiva si mindnam avav, otomotalva mindnam avav. Kuwulmsna 12pelara si hetindiva ilvahvav. ");
INSERT INTO wrs_vpl VALUES ("GN17_21","002_17_21","GEN","17","21","21","Heva os Isakindangas kana moanonoava si wohlohvav. Ongapevpa yenamba si lengvav hona weisram no tahonnam. ");
INSERT INTO wrs_vpl VALUES ("GN17_22","002_17_22","GEN","17","22","22","Doa Sesoava ishopiamnanamba, doa os dasvholahangana. ");
INSERT INTO wrs_vpl VALUES ("GN17_23","002_17_23","GEN","17","23","23","Doa honanamangas Aprahamba os vena, Sesoava ishomnanamba, wo hutovpa kukunna Ismaelna ombolna, eva hevna andranindna. No andranind, aval ten lengwol vinam hevna deuvra di, eva nomba temba himba indhanana englisriniva muehrombol venamba. ");
INSERT INTO wrs_vpl VALUES ("GN17_24","002_17_24","GEN","17","24","27","Nonamba Aprahamnamba osomba os lohmanavna 99pelara, ombolna os lohmanavna 13pelara, wo aralombolnamba mongawulm kovhoawulinna andranind mongnahonam. ");
INSERT INTO wrs_vpl VALUES ("GN18_1","002_18_1","GEN","18","1","1","Doa Aprahamba mendah wonavna di sahitsingi Mamreinda, Yaweva nonglaphona os. Okombava hovrahovra lohvna, wo Aprahamba tuvra lailduvra avna, ");
INSERT INTO wrs_vpl VALUES ("GN18_2","002_18_2","GEN","18","2","2","wo nonglana, tendomba samblamong di lovahvna murapeta. Doa himba phonamba, lelnam engilganamba, di mulumbdandna lohvhueinnamba, novlomosva petharam kusitheinna, ");
INSERT INTO wrs_vpl VALUES ("GN18_3","002_18_3","GEN","18","3","3","unna, mendekli, lehra yimba ambv, manam yimba nisva khovav, kainda hui saivo, ");
INSERT INTO wrs_vpl VALUES ("GN18_4","002_18_4","GEN","18","4","4","wusivulla hui aevultho. Pomba ata kava yemba wulkeinvav, monglam nonam poswolalm, ");
INSERT INTO wrs_vpl VALUES ("GN18_5","002_18_5","GEN","18","5","5","wo innepeta aiv ata kava boasna yemba wonnevav. Nokara daha ango. Yimba kana deuvram ambeiva, wo yemba kava dahwolalm vev. Doa himba una, lehra, kava saivoi. ");
INSERT INTO wrs_vpl VALUES ("GN18_6","002_18_6","GEN","18","6","6","Doa Aprahamba henga lelnam lailduvra sihanamba, ongalm omnana, plawa mindnam dombo, nona lelnam roti besalangas weiho, wou. ");
INSERT INTO wrs_vpl VALUES ("GN18_7","002_18_7","GEN","18","7","7","Doa nomini venamba, dem sapitatanaindam engilgana, otolm indthoamnana andranindrinim, holvora, omnana, miklerava, puso. Puspiarava, os weiho lelnam. Sapiotolva nomba naembulna, wo hevm tondombamba. ");
INSERT INTO wrs_vpl VALUES ("GN18_8","002_18_8","GEN","18","8","8","Tatamba tanamba, Apraham dombe tata, sapina tetpw, ingeine nom samblamongo indhanam. Dembhakeine, samblamongo indhana noi hlana, Aprahamba hevpa tisingi lohvna murapeta. ");
INSERT INTO wrs_vpl VALUES ("GN18_9","002_18_9","GEN","18","9","9","Doa himba Aprahamba umnina, ongapevpa yenamba Saramba hi av? Unna, ten lailduvra av. ");
INSERT INTO wrs_vpl VALUES ("GN18_10","002_18_10","GEN","18","10","10","Doa mongo herini ishomnana, weisva 12pelarava si khuawol verava, wo nonamba kava henga si os provav, wo nonamba Sarava si os lengvav tuendisrinimba. Doa Sarava mendah poaita avna tuvra, meisra henoinda, ten moa ishomnavnam, aongva vawovna. ");
INSERT INTO wrs_vpl VALUES ("GN18_11","002_18_11","GEN","18","11","12","Hev hellenamba, wo poaita ambo himba los owomanavna, os nengvna, doa kamba mundkolatov vewolv, demutrava kava doa wohwuleihana. Es himba onengv, kava lehra ihilmana evevma tlaiva? ");
INSERT INTO wrs_vpl VALUES ("GN18_13","002_18_13","GEN","18","13","13","Doa nomba tendoriniva Yawe, wo hev henga Aprahamba ishomnana, es hevpa ongapevpa los omnav, es hevpa himba oi, si kava tanamolnam lengvavmi, doa kamba mundkolatov vev? ");
INSERT INTO wrs_vpl VALUES ("GN18_14","002_18_14","GEN","18","14","14","Wo Sesoava manam eva owai vewol vev! Doa kava yemba ishomni, weisva 12pelarava khuawol vevrava, wo si os kava henga provav, wo nonam Sarava tuendisrinimba si lengvav. ");
INSERT INTO wrs_vpl VALUES ("GN18_15","002_18_15","GEN","18","15","15","Doa Sarava pem vevna, ona, owai, kava los omnimoa, wo Sesoa omnana, eie doa yimba los oi. ");
INSERT INTO wrs_vpl VALUES ("GN18_16","002_18_16","GEN","18","16","16","Doa tendomba nomba samblamongova angalm vevna, wo Apraham nungingavna, venamba, di pulvona lumbulla, di lovahthanamba, nomini nonglapuv vena Sotom kembelmba. ");
INSERT INTO wrs_vpl VALUES ("GN18_17","002_18_17","GEN","18","17","17","Doa Yawe nengna, Sotomnindmba kava engilpiangalm vev, ata kava ishomnavav Aprahamba, manam kava komandhavav moamba. ");
INSERT INTO wrs_vpl VALUES ("GN18_18","002_18_18","GEN","18","18","18","Manara, hetindiva si mindnam phovav, si keknamangas avav. Wo pethanindmba indkumbimba himba si awothowol vevav kananapopol. ");
INSERT INTO wrs_vpl VALUES ("GN18_19","002_18_19","GEN","18","19","19","Hemangas kava pusvundthoana, osva himba beswonam si hevna otomotalmba wonavav, wo kana moam ishomana vinvra, osva heoa beswonam wevsam engivra, hillivra. Wo himba osva vivrava, kava hemba os vinvav, temba kava Aprahamba doarava tanamolnam ishomnanamba. ");
INSERT INTO wrs_vpl VALUES ("GN18_20","002_18_20","GEN","18","20","20","Yaweva os nengnamba, doa Aprahamba omnana, kava doa hellena, Sotomnindva Gomoranindva honamba sahokla vilangav, eva moakokla ishulangav. ");
INSERT INTO wrs_vpl VALUES ("GN18_21","002_18_21","GEN","18","21","21","Daipota kaoa nongarava, ora tanam. ");
INSERT INTO wrs_vpl VALUES ("GN18_22","002_18_22","GEN","18","22","22","Doa tendomba nomba samblava dasvholaha engana Sotom monara, wo Yawe hev mendah Aprahami di elohvna monara. ");
INSERT INTO wrs_vpl VALUES ("GN18_23","002_18_23","GEN","18","23","23","Doa Aprahamba murapeta Yawem omnana, es hevpa yimba indhanamba besalmba sahokla vewol vevavma, owai. ");
INSERT INTO wrs_vpl VALUES ("GN18_24","002_18_24","GEN","18","24","24","Besal indhanamba 50pelarava aevultava, es hevpa yimba kembelnindm indkumbim wohindkokla vewol vevavma, owai, ambo nombolvhoawol veo indkumbim. ");
INSERT INTO wrs_vpl VALUES ("GN18_25","002_18_25","GEN","18","25","25","Kava nonora, yimba indhanamba indkumbimba lesvhoawol vev. Wo yimba sesnam indkokla vewol vev indhanakoklamba, besalnindmba owai, yimba sesnamba vewol vinvmoa. Yenamba wevsava besal hevm lohv. ");
INSERT INTO wrs_vpl VALUES ("GN18_26","002_18_26","GEN","18","26","26","Doa Yawe hellenamba, omnana, lehra, besal indhanamba kava nongaltava, 50pelarava aevultava, kava kembelnindm indkumbim osva wuleihinvav, owai vinvav, besal indhanainda kava wohwuleihinvav indkumbimba, wohindkokla vewolalmba. ");
INSERT INTO wrs_vpl VALUES ("GN18_27","002_18_27","GEN","18","27","27","Doa henga Aprahamba Yawem omnana, mendekli, kam helletok, mani kava besalma, oi ata kava yemba osahmanavav, heva os yemba kava isholm venav. ");
INSERT INTO wrs_vpl VALUES ("GN18_28","002_18_28","GEN","18","28","28","Yimba besal indhanamba diva nongaltava, 45pelarava aevultava, 50pelarava owai, wo es hevpa, yimba kembelnindm indkumbimba engilpiangavavma? Doa Yawe henga omnana, besal indhanamba 45pelarava kava nongaltava, kava kembelnindm indkumbim osva pewolehawol vevav. ");
INSERT INTO wrs_vpl VALUES ("GN18_29","002_18_29","GEN","18","29","29","Doa Apraham henga omnana, besal indhanamba 40pelarava aevultava, yimba nongaltava, wo es hevpa yimba vinvav? Doa Yawe henga omnana, 40pelarava aevultava, kava indkumbim osva pewolehawol vevav. ");
INSERT INTO wrs_vpl VALUES ("GN18_30","002_18_30","GEN","18","30","30","Doa henga Apraham omnana, mendekli kam helletok, wo manam yimba kamba koasvevav. Kava mendah nengaomana vev honamba. Besal indhanamba yimba nongaltava, 30pelarava aevultava, wo es hevpa? Yawe omnana, owai, kava osva indkumbim pewolehawol vevav. ");
INSERT INTO wrs_vpl VALUES ("GN18_31","002_18_31","GEN","18","31","31","Doa Aprahamba mendah ishomnavna, yemba mendah kava isholm venav, wo manam yimba kamba koasvevav. Besal indhanamba yimba 20pelarva nongaltava, wo es hevpa? Yawe omnana, osva kava indkumbim hem pewolehawol vevav. ");
INSERT INTO wrs_vpl VALUES ("GN18_32","002_18_32","GEN","18","32","32","Doa Aprahamba henga omnana, manam yimba kamba koasvevav, wo hengava kava yemba ishomnavavmoa honamba, owai. Besal indhanamba yimba nongaltava 10pelarava, wo es hevpa? Doa Yawe omnana, osva kava indkumbim nombolvhoawol vevav. ");
INSERT INTO wrs_vpl VALUES ("GN18_33","002_18_33","GEN","18","33","33","Doa himba ihishopianamba, Yaweva dasvholahangana, wo Aprahamba deuvram hevindam henga gana. ");
INSERT INTO wrs_vpl VALUES ("GN19_1","002_19_1","GEN","19","1","1","Doa tendorini samblava nomba Aprahamba dasvholaha enganamba, di Sotom kembella epho makokonam. Himba Sesoana ovsongolnindrini sambla elohvna. Ephonamba, Lotm nongla epho, Lotva di monamilla avna. Doa Lotva anongla ve sambla indhanamba, hev phonamba, mulumbdandna lohvhueinnamba, ");
INSERT INTO wrs_vpl VALUES ("GN19_2","002_19_2","GEN","19","2","2","unna, mendekli, yem kava dahwol velm vev, kaindam epro. Monglaoa poswol evevrava, os ninoa ihilvm. Otovonam ephorava, os engo. Yimba simolnamba engalmba evetava, osoa engo. Doa tendorini samblava henga ohomnana, owai, kava ata kembelhovra ahavav, simba kilvrarava, ata kava hui ihilvav. ");
INSERT INTO wrs_vpl VALUES ("GN19_3","002_19_3","GEN","19","3","3","Doa Lotva ninhapehna unvna, wo noinda Lotindam engana. Wo Lotva ishunna andranindm, rotim viu, inneoa besal singu. Doa singpieinnamba, doa os hlana. ");
INSERT INTO wrs_vpl VALUES ("GN19_4","002_19_4","GEN","19","4","4","Hlapianamba, wo mendah ninmba shathavnamoa, wo kembelnindva indkumbiva kusovna, tendomba, tendotowondva. Doa deuvm weisming vrina, ");
INSERT INTO wrs_vpl VALUES ("GN19_5","002_19_5","GEN","19","5","5","Lotm umnivna, kam tuvm vileihinu. Nomba tendorini samblam yimba sinim wonsihaiva, wonpho, kava wis angopiamanalm viv no tendorini samblainda. ");
INSERT INTO wrs_vpl VALUES ("GN19_6","002_19_6","GEN","19","6","6","Doa Lotva phonamba, henga tuvpa kolvo, ");
INSERT INTO wrs_vpl VALUES ("GN19_7","002_19_7","GEN","19","7","7","unna, owai, memba yimba uiva sahoklal. ");
INSERT INTO wrs_vpl VALUES ("GN19_8","002_19_8","GEN","19","8","8","Hillu, kavna mosambla men ahav deuvmera, wo owai, indhanariniva kakaiv venamoa. Ata kava wonprovav, wo yeoa wonango, kevruwulu, wo wis angopiamana viu heinda. Honamba indhanarini samblamba manam yimba kevruwul vivav, kava kavna deuvram wonproi, osm kav beswonam wonavav. ");
INSERT INTO wrs_vpl VALUES ("GN19_9","002_19_9","GEN","19","9","9","Doa kembelnindva nomba umnina, kam tuv vileihinu, mani yimba karinima, yenamba kava moamba hillivmoa, yemba eva kava indkokla vrivav. Doa Lotm lukuhnga ovuvna, osm tuvm takapikoho deuvmeram. ");
INSERT INTO wrs_vpl VALUES ("GN19_10","002_19_10","GEN","19","10","10","Heva os owai, nomba tendorini samblava lelnam tuvm evlihanamba, Lotm ekevra, wo henga deuvmeram ewulasiha eve, tuvpa henga ekolvona. ");
INSERT INTO wrs_vpl VALUES ("GN19_11","002_19_11","GEN","19","11","11","Doa kitakita vewol evena kembelnindm, noinda osm novtit vira, tuvmba hengava nunglinamoa. ");
INSERT INTO wrs_vpl VALUES ("GN19_12","002_19_12","GEN","19","12","13","Doa tendorini samblava Lotm ohomnana, ata kava honamba kembelnindmba kelva epiangavav. Manara, Yaweva doa hena indkoklamba nunglinna, oi sahoklalnonoa, wo noinda kamba wolapra vei, kelva epiangalm. Yeoa wongavm, ye ombpovm mopovm puwepevm lelnam. Wo mongla eva yena owapevpa aevultava, nomoa eva wongaota. ");
INSERT INTO wrs_vpl VALUES ("GN19_14","002_19_14","GEN","19","14","14","Kembelnindrini samblamba, nomba doara pusvundthoawulna Lotna mol samblamba, si honi evrowolmanavav. Doa Lot ganamba, unna, ehellatok, ata Yaweva yemba kembelnindmba kelvapiangavav, lelnam engo. Doa ehellenamba, Lotm ohomnana, yimba dasalm ov, wo owai evena. ");
INSERT INTO wrs_vpl VALUES ("GN19_15","002_19_15","GEN","19","15","15","Doa lingil lihavna, henga tendorini samblava nomba Yawena ovsongolnindrini samblava Lotm indslaposla ohovrevna, lelnam wongao, ata homeis yem sahokla vilovm hona kembelnindnahonam. ");
INSERT INTO wrs_vpl VALUES ("GN19_16","002_19_16","GEN","19","16","16","Wo Lotva sambla undva verombvna, lelnamba ganamoa. Wo Yawe wavra vovhoamnana, noinda tendorini samblava kleiha ahaiwo engana nominiva, Lotm, ongalm, mol samblam. ");
INSERT INTO wrs_vpl VALUES ("GN19_17","002_19_17","GEN","19","17","17","Doa Sotom kembellini vinamba, mongo no tendorini samblava unna, lelnam yeoa angavm, manam yimba moih vivav diva pundrava. Manam yimba sisnovpa vemb vevav homba. Oloramangas wohango, wo diva ata yimba beswonam aevulvav. ");
INSERT INTO wrs_vpl VALUES ("GN19_18","002_19_18","GEN","19","18","18","Wo Lot henga unna, owai, es eva kava oloramba. ");
INSERT INTO wrs_vpl VALUES ("GN19_19","002_19_19","GEN","19","19","19","Ye doa kam beswonam wonproi, ata kamba dalvavmoa Sotomnindnahonamba, heva os olomba okla lohv, kava ora angara, hona sahoklava ata kamba monara kakaiv vevav. ");
INSERT INTO wrs_vpl VALUES ("GN19_20","002_19_20","GEN","19","20","20","Dem kava angavav kembel eusillam, ten lohvm. Yimba nonglavma, murapeta ambo lohv, wo beswonam kava diva ata aevulvav. ");
INSERT INTO wrs_vpl VALUES ("GN19_21","002_19_21","GEN","19","21","21","Doa tendorini omnana, lehra, nomba kava ata sahokla evevravavmoa Sotom kembelnahonamba owai. ");
INSERT INTO wrs_vpl VALUES ("GN19_22","002_19_22","GEN","19","22","22","Yeoa lelnam angavm, kava mana vemamba vinvavmoa Sotomnindmba lelnamba, boasna ye di wonphorava. Kava es eva nunginamba evevav. Lotva ona, eusilva nomba kembelva, wo noinda os ningthiv Soar, osm uv, eusil kembel. ");
INSERT INTO wrs_vpl VALUES ("GN19_23","002_19_23","GEN","19","23","23","Okombava mendah phovna, Lotva Soar kembellava os wonphona, ");
INSERT INTO wrs_vpl VALUES ("GN19_24","002_19_24","GEN","19","24","24","wo lelnam Yawe suwemda honboal vethapiha vena senamini kembel samblaram. ");
INSERT INTO wrs_vpl VALUES ("GN19_25","002_19_25","GEN","19","25","25","Wo eva kembelnindm, denwitm, deuvm, osom, petham nom indkokla vrowol vinna, wo mana vemamba temba no pundrava lohvnamba, sahokla vilona. ");
INSERT INTO wrs_vpl VALUES ("GN19_26","002_19_26","GEN","19","26","26","Lotna ongalva sisnov ona vena, doa wanalm nilhana, ona hon. ");
INSERT INTO wrs_vpl VALUES ("GN19_27","002_19_27","GEN","19","27","27","Doa mongnasiva Aprahamba deuvrini venamba, monam ganamba, di pho, ten seilm hev Yawei elohnam monara. ");
INSERT INTO wrs_vpl VALUES ("GN19_28","002_19_28","GEN","19","28","28","Wo himba henga nonglapiha vevna Sotom kembelm, Gomora kembelm, pundm nom. Pai, suwulangas doa vothai, oi ososowa tithueiv! ");
INSERT INTO wrs_vpl VALUES ("GN19_29","002_19_29","GEN","19","29","29","Memba plalmomba os lohv, Sesoa kembelnindm kelvapiangana, di ten Lot wonalohvnam pundra. Heva os Sesoa wavra vovhoamnana Aprahamba, heva os buesilmba indkokla vrenamoa, beswonam. ");
INSERT INTO wrs_vpl VALUES ("GN19_30","002_19_30","GEN","19","30","30","Doa Lotva pem vevna wohalmba no Soar kembellava, wo nominiva wonphona, oloram wongana, di wonavhoana honmera hevna mol samblam. ");
INSERT INTO wrs_vpl VALUES ("GN19_31","002_19_31","GEN","19","31","31","Doa etelva moasalalm ishomnana, aramba doa mundkola vev, pimba tlahui ahav, tendomba owai, huiva avmoa, si pimba otolhui wohahavav. ");
INSERT INTO wrs_vpl VALUES ("GN19_32","002_19_32","GEN","19","32","32","Doa pioa aramoa wainpolna endahoi, ata dai orava, ninpol kovopevav, wo kava ata os heindava vendholothovav avondrava. ");
INSERT INTO wrs_vpl VALUES ("GN19_33","002_19_33","GEN","19","33","33","Wo osoa himba wohevena, wo sinim etelva aralm wailina. Heva os aralva tit vena, doara dai ovna. ");
INSERT INTO wrs_vpl VALUES ("GN19_34","002_19_34","GEN","19","34","34","Doa mongnasiva henga evena, etelva moasalalm ishomnana, sinim kav wailina, wo detioa eva ye ihilo. Wo pimba si osva ena ahavav. ");
INSERT INTO wrs_vpl VALUES ("GN19_35","002_19_35","GEN","19","35","35","Doa osoa evena, henga sinim wainpol endahona aralm, wo moasalalva aralm wailina, wo henga aralva tit vena, doara dai ovna. ");
INSERT INTO wrs_vpl VALUES ("GN19_36","002_19_36","GEN","19","36","36","Wo osva Lotna mol samblava ena ahawolna aralna. ");
INSERT INTO wrs_vpl VALUES ("GN19_37","002_19_37","GEN","19","37","38","Wo sisva etelva otolm lengna tuendisrini, awona Moapm, wo eva sism moasalalva otolm lengna tuendisrini, awona Benamim. Wo Moapiva Benamiva himba simbel elohna Moapnindna Amonnindna. ");
INSERT INTO wrs_vpl VALUES ("GN20_1","002_20_1","GEN","20","1","1","Doa Apraham nomini phonamba Mamreriniva, mongona pethara wonavhoana, Katesra hovra Surra. Doa nomini wonphonamba, mongona pethara wonavhoana Gerarra. Gerarna mendeklina nihilva Apimelek wulluhunna. ");
INSERT INTO wrs_vpl VALUES ("GN20_2","002_20_2","GEN","20","2","2","Doa Apraham Apimelekm os ishomnana, memba ungevliriniva Sarava kana muskovol, heva os ongal. Doa Apimelek unna, wo noinda himba Saramba waiambna. ");
INSERT INTO wrs_vpl VALUES ("GN20_3","002_20_3","GEN","20","3","3","Doa sinim himba inungpunung vevna, Sesoam nonglavna, Sesoa ona, si yenamba dahalmba lohvav, manara, yimba hona ungevlirinim vrana, tlatrini yimba pelvrana. ");
INSERT INTO wrs_vpl VALUES ("GN20_4","002_20_4","GEN","20","4","5","Wo Apimelek ona, kava indkoklava venamoa honindava, Apraham hev ona, kana muskovol, eva ungevliriniva osta ona. Kava indkokla venamoa, titnam kava pelvrana. Wo heva os owai, kava wailinamoa. Es hevpa yimba kamba helvakomandhavavma. Katatanamba helvakomo vevavma. ");
INSERT INTO wrs_vpl VALUES ("GN20_6","002_20_6","GEN","20","6","6","Doa Sesoa henga ona, lehra yimba ov, yimba pelvralmba nengnamoa. Wo noinda yemba kava ollana, osm yimba wailivavmoa, wo yena indkoklava lohvmoa kana novrava. ");
INSERT INTO wrs_vpl VALUES ("GN20_7","002_20_7","GEN","20","7","7","Doa henga yeoa hevnam tlalm pelvraho. Tlalva kana moashulnindrini, wo heoa kamoa osva sahmanavav yeinda, wo yemba si dahavavmoa honindava. Heva os beswonam hello, yimba owai vetava, memba kava yemba ishomnavpa, yenamba dahalmba si lohvav yena, yetatanana. ");
INSERT INTO wrs_vpl VALUES ("GN20_8","002_20_8","GEN","20","8","8","Doa simolnamba Apimelek hevna mendeklim nembaomana vena, os ishunna, hev ten inungpunungra nonglanam. Wo indkumbi pemba esvema vivna. ");
INSERT INTO wrs_vpl VALUES ("GN20_9","002_20_9","GEN","20","9","10","Doa Apimelek ona, Apraham prora, pronamba, doa ishomna, yimba kamba mindnam indkokla vewol vena, Sesoava kamba indkokla vewolalm ovna, kavm kavnam indhanam. Mani kava yemba doara vemnana, wo noinda yimba kamba sahokla vrelm vev? Hona wevsava yimba memba vevnamba, beswonam yimba vevnama. ");
INSERT INTO wrs_vpl VALUES ("GN20_11","002_20_11","GEN","20","11","11","Doa Apraham henga omnana, owai osva, ambo kava os nengna, indhanamba huiva owai, Sesoamba lovahthamnavmoa. Wo yimba kamba helvakomandhivav, Saram pelvravav kanam ongalm. ");
INSERT INTO wrs_vpl VALUES ("GN20_12","002_20_12","GEN","20","12","12","Tanamolnam himba kana muskovol av, aralva mongasal, avalva sambla, wo kava vrana. ");
INSERT INTO wrs_vpl VALUES ("GN20_13","002_20_13","GEN","20","13","13","Wo sisva Sesoava kamba ishomnana, yeoa ararapevmoa wuleihawol veo, wo ungundna pethara lohmana veo, wo noinda kava ishomnana Saram, manam yimba kamba osva omnavav, kana tlal, os kamoa omnavm, kana muskovol, osva yimba kamba kolvrevav. ");
INSERT INTO wrs_vpl VALUES ("GN20_14","002_20_14","GEN","20","14","14","Doa Apimelek hellenamba, ona, oh, men Sarava, vrao. Wo hev nis ambo holvodembrahona Apraham sipsip sapi, eva indhanam wuleihowol venana andranindilm. ");
INSERT INTO wrs_vpl VALUES ("GN20_15","002_20_15","GEN","20","15","15","Wo henga ona, yimba honahalm almba vev kana petharava, manapenam. ");
INSERT INTO wrs_vpl VALUES ("GN20_16","002_20_16","GEN","20","16","16","Wo henga Saramba omnana, men kava tlapevmba senmba 1000pelara dembraohv, plalva os lohv, loum yenam kava ehlathav. Yetatana indkumbiva men nunglutithueiv, uv, Sarana loum ehlathav. ");
INSERT INTO wrs_vpl VALUES ("GN20_17","002_20_17","GEN","20","17","18","Doa Yaweva doara em kakaiv vinna Apimeleknamba ongalnamba, eva andranind unguvlinamba, wo otolmba tetwond vinnamoa, plalva os lohna Sarainda. Wo sisva Apraham Sesoam sahmanana Apimelekinda, wo Sesoava hellena, sishona vrowol vena Apimelekm, ongalm, andranind unguvlim, wo sism heva tetwond vena. ");
INSERT INTO wrs_vpl VALUES ("GN21_1","002_21_1","GEN","21","1","2","Doa Yawe Saram awothona, wo noinda enava avna, otolm sleihana tuendisrini Aprahamna. Honamba os phona, ten seilm Sesoa ishomnanam Apraham. Wo nonamangas phona, Sesoa doara ishomnanamba. ");
INSERT INTO wrs_vpl VALUES ("GN21_3","002_21_3","GEN","21","3","3","Aralva awona Isakm, ");
INSERT INTO wrs_vpl VALUES ("GN21_4","002_21_4","GEN","21","4","4","wo ombolva 8pelara simba piengiliha vunganamba, aralva nihtovpa os kovhoamnana, os Sesoa seilm ten ishomnanam. ");
INSERT INTO wrs_vpl VALUES ("GN21_5","002_21_5","GEN","21","5","5","Aralna osomba os lohna 100pelara, otolva os polamnana. ");
INSERT INTO wrs_vpl VALUES ("GN21_6","002_21_6","GEN","21","6","6","Avalva Sarava os ishomnana, honamba Sesoa kamba venana, noinda kava otolmba holvorana, osm kaoa beswonam avra, indk vethavra, los ovra. Noinda awona Isakmba. Isakva osm uv, los ov. ");
INSERT INTO wrs_vpl VALUES ("GN21_7","002_21_7","GEN","21","7","7","An kanamba tlalmba ishomnana osva, ongapevpa yenamba si otolva sleihavav, tet daohvav owai. Wo men kava vev putowaina. ");
INSERT INTO wrs_vpl VALUES ("GN21_8","002_21_8","GEN","21","8","8","Doa ombolva Isakva mendekli venamba, tetva putlahavnamba, wo nonamba aralva innemba mindnam dembhinvna, hlalm. ");
INSERT INTO wrs_vpl VALUES ("GN21_9","002_21_9","GEN","21","9","9","Doa Aprahamna otol samblava mueri evevna Isakiva Ismaeliva. Ismaelva nomba Hakar doara sleihana Aprahaminda, Hakarva nomba Isipongorini. Doa Sarava nongalnamba, ona, pai, Ismaelva loumona opipahav Isakmba, ");
INSERT INTO wrs_vpl VALUES ("GN21_10","002_21_10","GEN","21","10","10","tlalm omnana, yeoa Hakarmoa andranind unguvlirinimoa wohwuleihalahangao honaminioa. Ombolnahonam wohwolanga veo, manara, yemba si daharava, wo nonamba puewulva yenamba Isakna englara si nalohvav, kavna ombolinda. Kava ovov, yenapuwulva Ismaelna englisrava si espetava nalohvavmoa. ");
INSERT INTO wrs_vpl VALUES ("GN21_11","002_21_11","GEN","21","11","11","Doa Aprahamba hellenamba, himba mindnam duus vevna, ona Ismaelva nomba kanamba ombol. ");
INSERT INTO wrs_vpl VALUES ("GN21_12","002_21_12","GEN","21","12","12","Doa Sesoava Aprahamba os ishomnana, manam yimba duus vevav, ambo vengas veo, os ten ongapev ishovm. Noinda veo, Isaktindiva si mindnam phovav, os nemet ten kav yem tanamolnam wohishomnanam. Hengas si yetindiva wohavav. ");
INSERT INTO wrs_vpl VALUES ("GN21_13","002_21_13","GEN","21","13","13","Wo Ismaelmba kava awothovav, wo hetindiva si mindnam phovav, manara, temba yena ombolta eva. ");
INSERT INTO wrs_vpl VALUES ("GN21_14","002_21_14","GEN","21","14","14","Doa simolnamba Aprahamba Hakarm inne dembrahona, pomba longwol vemnanamba, doa lura hohlomna, omnana, yeoa ombpovm waingao. Doa himba nominiva venamba, pethakoklara di lohmana vevna Bersepara, diva pomba owai, liku vevnamoa. ");
INSERT INTO wrs_vpl VALUES ("GN21_15","002_21_15","GEN","21","15","15","Wo himba pomba enepianamba, doa ombolmba pethara desvhoana wusivulla. ");
INSERT INTO wrs_vpl VALUES ("GN21_16","002_21_16","GEN","21","16","16","Desvhoanamba, dom oklapetam hevpa ganamba, doa di avhoana, ona, kavna otolmindmba kava nonglavavmoa osva. Doa hevpa avhoanamba, wo vawovna. ");
INSERT INTO wrs_vpl VALUES ("GN21_17","002_21_17","GEN","21","17","17","Doa Sesoa hellenamba, wo senamini Sesoana ovsongolnindrini ishopiha vemnana os, Hakar, manam yimba mindnamba duus vevav, Sesoa doa hellei ombpovpa. ");
INSERT INTO wrs_vpl VALUES ("GN21_18","002_21_18","GEN","21","18","18","Yeoa phovm, phorava, dom garava, ombpovm omnarava, kleihawulluhmana veo. Si kava hemba awothovav, wo hetindiva si mindnam phovav. ");
INSERT INTO wrs_vpl VALUES ("GN21_19","002_21_19","GEN","21","19","19","Doa Sesoava mana vema vemnana, wo he beswonam nonglana, pai, pomba ten liv. Doa pomba longwol venamba, ombolm waine. ");
INSERT INTO wrs_vpl VALUES ("GN21_20","002_21_20","GEN","21","20","20","Doa Sesoa ombolmba kolvrena, wo himba mendekli venamba, ");
INSERT INTO wrs_vpl VALUES ("GN21_21","002_21_21","GEN","21","21","21","di pethakoklara himba avna Paranda, wo himba tatawonga lohvna. Avalva ungevlirinim suihanamba, waipro ombolindam, Isipongorinim. ");
INSERT INTO wrs_vpl VALUES ("GN21_22","002_21_22","GEN","21","22","22","Doa nonamba Apimelekva mendekli henga nengmananamba Aprahamba, doa hevna valgonindna kuwulm Pikolm wainga, Aprahaminda di waipho. Ona, doa kava lihai, Sesoanapopol yimba vev andrava mani mani mani. ");
INSERT INTO wrs_vpl VALUES ("GN21_23","002_21_23","GEN","21","23","23","Wo noinda, yeoa kamoa tanamolnam ishomno, osva si yimba kamba deswuhowol vevavmoa, kam eva kavna otolm, kavna sespalm. Yemba kava beswonamangas vevrav, wo noinda yemba kava osva ishomnav, yeoa kamoa beswonam vevravm, kam kavna pethanindm. ");
INSERT INTO wrs_vpl VALUES ("GN21_24","002_21_24","GEN","21","24","24","Doa Apraham henga omnana, si kava os vinvavta yetatanamba. ");
INSERT INTO wrs_vpl VALUES ("GN21_25","002_21_25","GEN","21","25","25","Doa hev Apimelekm omnana, tovalpva ten lohv, kav doara tuveinamba, wo sisva andranindva yenamba ambanamba, una, kana, wo kana andranindm engilna. ");
INSERT INTO wrs_vpl VALUES ("GN21_26","002_21_26","GEN","21","26","26","Doa Apimelek henga ona, memba seilnovra kava hellev snamba, yimba doarava kamba omnanamoa, wo noinda kava tit vena. ");
INSERT INTO wrs_vpl VALUES ("GN21_27","002_21_27","GEN","21","27","27","Doa Aprahamba sapim sipsipm holvorombrahona Apimelekm, doa omnana, pimba si beswonam pivmba wohevevra. ");
INSERT INTO wrs_vpl VALUES ("GN21_28","002_21_28","GEN","21","28","28","Doa henga Aprahamba sipsipm huhul vevna 7pelara, avalangas. ");
INSERT INTO wrs_vpl VALUES ("GN21_29","002_21_29","GEN","21","29","29","Wo Apimelek ona, manara hevpa yimba huhul vev? ");
INSERT INTO wrs_vpl VALUES ("GN21_30","002_21_30","GEN","21","30","30","Wo Aprahamba ona, yemba kava holvorombraholm vev, wo yimba holvorombol vetava, yimba osva unvav, tovalpva nomba Aprahamna. ");
INSERT INTO wrs_vpl VALUES ("GN21_31","002_21_31","GEN","21","31","31","Wo Apimelek holvorombol venamba, wo noinda tovalpva nomba osva ningthiv Bersepa, osm uv, tovalpmomba doa ihishona. ");
INSERT INTO wrs_vpl VALUES ("GN21_32","002_21_32","GEN","21","32","32","Doa Aprahamiva Apimelekiva moamba ihishoepianamba, Apimelek henga hevna kembellam gana, Pikolm waingana. Apimelekva nomba himba kuwul wulluhunvna Pilistianindna. ");
INSERT INTO wrs_vpl VALUES ("GN21_33","002_21_33","GEN","21","33","33","Doa Apraham ti endhana di pora murapeta Bersepara, doa Yawem sembayang vemnana, ona, yimba mendekli, yimba si wuleihavavmoa. ");
INSERT INTO wrs_vpl VALUES ("GN21_34","002_21_34","GEN","21","34","34","Wo Aprahamba di Bersepara mindnam alohna, Pilistianindna pethara. ");
INSERT INTO wrs_vpl VALUES ("GN22_1","002_22_1","GEN","22","1","1","Doa sisva Sesoava Aprahamnamba nengavnangm lehmanavna, ora kamangas lohmanav. Hev omnana, Apraham, wo hev omnana, men kava av. ");
INSERT INTO wrs_vpl VALUES ("GN22_2","002_22_2","GEN","22","2","2","Doa Sesoa omnana, doa Isakm ombpovm dom waingao Moria petharam. Himba hevho lohv, wo yimba mindnam und vev, heva os di kava yemba mongom olom indthoamnavav, osva yimba di kamba ombpovm suwera holvoweihamnavav. ");
INSERT INTO wrs_vpl VALUES ("GN22_3","002_22_3","GEN","22","3","3","Doa Aprahamba hellenamba, simolnamba hev tehpeta hawol venamba, suwem nonam sengalm, doa donkina meisra hohlo, donkira ingalm. Doa ganamba, ombolm waingana, andranindrini samblam wongana. Wonganamba, monarava samblalm shawolna. ");
INSERT INTO wrs_vpl VALUES ("GN22_4","002_22_4","GEN","22","4","4","Doa mongnasiva nonglanga vena olom, nom ten Sesoa doara ishomnanam. ");
INSERT INTO wrs_vpl VALUES ("GN22_5","002_22_5","GEN","22","5","5","Doa Apraham hevna andranindrini samblam unna, yeoa hui waielohvm donkim, kava ombm dom waingav, ata kava Sesoam sembayang waivenavav, henga ata kava waiprovav. ");
INSERT INTO wrs_vpl VALUES ("GN22_6","002_22_6","GEN","22","6","6","Doa Apraham ombolm omnana, yeoa tehoa honaoa ingavm, ata pimba mana vema weseng evemnavav Sesoamba, osm sembayang evemnavav. Aralva hevpa ilohna ovla doahnasowa. Doa mongawulm engavna, ");
INSERT INTO wrs_vpl VALUES ("GN22_7","002_22_7","GEN","22","7","7","ombol omnana, ara, aral omnana, kava hellev, ombol omnana, teh, doahnasowa men pimba plehai engav, wo sipsip otolva owai, mani ata yimba wuweihamnavav Sesoamba? ");
INSERT INTO wrs_vpl VALUES ("GN22_8","002_22_8","GEN","22","8","8","Aral ona, Sesoa hev ata pusvundthoavav, doa mendah mongawulm waingavna. ");
INSERT INTO wrs_vpl VALUES ("GN22_9","002_22_9","GEN","22","9","9","Doa di epho, ten doara Sesoa ishomnanam. Doa aral hon songowol venamba, wo tehva nosra beswonam waihekala, venamba, ombolm wena ningenamba, tehsra sena ningeholotho. ");
INSERT INTO wrs_vpl VALUES ("GN22_10","002_22_10","GEN","22","10","10","Doa ovla vranamba, miklelm nona vevna, ");
INSERT INTO wrs_vpl VALUES ("GN22_11","002_22_11","GEN","22","11","11","wo Yawena moainal ovsongolnindrini senamini ishopiha venana, Apraham. Ona, men kava lohv, ");
INSERT INTO wrs_vpl VALUES ("GN22_12","002_22_12","GEN","22","12","12","wo he ona, doa. Doa kava nonora, yimba kamangas lohmanav keknam, noinda yimba pevna ombpovpa kek vethaimoa, kamba holvoraholmba. Doa manam yimba miklevav, manam tuhvav, wuleiho. ");
INSERT INTO wrs_vpl VALUES ("GN22_13","002_22_13","GEN","22","13","13","Doa Aprahamba nov venamba, ona, pai, sipsip aralva ten lohv, tivtandara doa kaselva kangs othomni. Doa ganamba, holvora, doa miklenamba, suwera waiwuweihamnana Sesoam ombolna vhorava. ");
INSERT INTO wrs_vpl VALUES ("GN22_14","002_22_14","GEN","22","14","14","Doa olomba nomba Aprahamba os nengthana, Yawe mana vema holvoraohv kamba. Wo men daipota indhanamba mendah ishuvmona vev, Yawe hevna olora mana ema holvorahona Aprahamba. ");
INSERT INTO wrs_vpl VALUES ("GN22_15","002_22_15","GEN","22","15","15","Doa henga Yawena ovsongolnindrini senamini ishopiha venana Aprahamba os, Yaweva os oi, ");
INSERT INTO wrs_vpl VALUES ("GN22_16","002_22_16","GEN","22","16","16","daipotava Aprahamba kava tanamolnam isholm venav. Kava kavna nihilmba keknam wohsevrav, kava Yawengas hem ishomnav. Himba hevna ombolmba kek vethaimoa, kamba holvoraholmba, ");
INSERT INTO wrs_vpl VALUES ("GN22_17","002_22_17","GEN","22","17","17","wo noinda hemba kava mindnam kolvrevav. Hetindiva si mindnam phovav. Hemba kava kolvrevav, paimsna himba si avav, oi wan engal. Wo si himba pethava deuvkembelva wohvaohuthuingivav ungundnamba. ");
INSERT INTO wrs_vpl VALUES ("GN22_18","002_22_18","GEN","22","18","18","Hind hind indkumbiva si os nungeilvav, wo kam si ishumnivav, yeoa kamoa os vinu, ten pev Aprahamtindim kolvrowol venam. Himba doa kana moamba hellengas vei, wo noinda honamba si mana vemamba os phovav. ");
INSERT INTO wrs_vpl VALUES ("GN22_19","002_22_19","GEN","22","19","19","Doa Aprahamba ombolmba henga waingana, dom ten andranindrini sambla di ahavnam, doa deuvram wongana Berseparam. Aprahamba di dawonam alohkumbi vena. ");
INSERT INTO wrs_vpl VALUES ("GN22_20","002_22_20","GEN","22","20","20","Doa sisva Aprahamba os hellena, boaslalna Nahorna ombolva mindnam phona. Ongalva Milka 8pelara towand vena, nihilva men. ");
INSERT INTO wrs_vpl VALUES ("GN22_21","002_22_21","GEN","22","21","21","Yiveltowond Us, mongova Bus, mongova Kemuel, ");
INSERT INTO wrs_vpl VALUES ("GN22_22","002_22_22","GEN","22","22","22","mongova Keset, mongova Haso, mongova Piltas, mongova Yitlap, mongova Betuel. Kemuelva nomba sisva aral lohna Aramna, ");
INSERT INTO wrs_vpl VALUES ("GN22_23","002_22_23","GEN","22","23","23","wo Betuelva nomba sisva aral lohna Repekana. ");
INSERT INTO wrs_vpl VALUES ("GN22_24","002_22_24","GEN","22","24","24","Wo Nahorna andraunguvlirini ana, nihilva Reuma, wo himba otolmba lengwol vena Nahorna, nihilva Tepa, Gaham, Tahas, Maka. ");
INSERT INTO wrs_vpl VALUES ("GN23_1","002_23_1","GEN","23","1","1","Doa Aprahamna ongalva os ana, osomba 127pelara lohmanavna, venamba, doa os wohdahana. ");
INSERT INTO wrs_vpl VALUES ("GN23_2","002_23_2","GEN","23","2","2","Di Hepron kembella dahana Kenan pethara, doa tlalva und vawovna. Nomba Hepron kembelva indanam ningthivna Kiriatapa. ");
INSERT INTO wrs_vpl VALUES ("GN23_3","002_23_3","GEN","23","3","3","Ongalva mindil vindilvna, tlalva dom gana kembellam, ten Hitnind aevulvnam, unna, ");
INSERT INTO wrs_vpl VALUES ("GN23_4","002_23_4","GEN","23","4","4","kava yeriniva owai, kava ohalnindrini lohv indanam. Yeoa kamoa pethapetam kovoreihu, kavna ongamindm noindam singvelm. ");
INSERT INTO wrs_vpl VALUES ("GN23_5","002_23_5","GEN","23","5","5","Wo he umnina, ");
INSERT INTO wrs_vpl VALUES ("GN23_6","002_23_6","GEN","23","6","6","manapenam, kava yemba nonora lovahmanav, yimba mendekli lohv. Yimba henahalm nengv, hi besalva lohv, heni ata kava yemba kovoreihuvav? An eva ata kariniva yemba ovomnavav, owai. ");
INSERT INTO wrs_vpl VALUES ("GN23_7","002_23_7","GEN","23","7","7","Doa Apraham ku kusitheinna petharam, unna, ");
INSERT INTO wrs_vpl VALUES ("GN23_8","002_23_8","GEN","23","8","8","lehra, wo melva honmera lohv, yimba os ningthiv Makpela. Di lohv Evronna osopethalla, murapeta di Soharna ombolinda. ");
INSERT INTO wrs_vpl VALUES ("GN23_9","002_23_9","GEN","23","9","9","Ye ishumnu, kam kovorahora pokamamel pethaoa, ata kava diva esvema dembrahovav. ");
INSERT INTO wrs_vpl VALUES ("GN23_10","002_23_10","GEN","23","10","10","Wo Evron hev di ana Hitnindmongo, himba monamilla aevvna. ");
INSERT INTO wrs_vpl VALUES ("GN23_11","002_23_11","GEN","23","11","11","Wo himba ona, mendekli, men yemba kava kovoraohv melva osonahonam, katindiva men hilliv. ");
INSERT INTO wrs_vpl VALUES ("GN23_12","002_23_12","GEN","23","12","12","Doa henga Aprahamba ku kusitheinna, ");
INSERT INTO wrs_vpl VALUES ("GN23_13","002_23_13","GEN","23","13","13","Evronm ishomnana indhanana aongsra, beswonam hello, yemba kava dim dembraholm vev, osm kavna ongamindm singvivav no pethara. ");
INSERT INTO wrs_vpl VALUES ("GN23_14","002_23_14","GEN","23","14","14","Doa Evronmba henga omnana, ");
INSERT INTO wrs_vpl VALUES ("GN23_15","002_23_15","GEN","23","15","15","manapenam, mani diva mindnamma, senmba 400pelara ambo, wouta singviu. ");
INSERT INTO wrs_vpl VALUES ("GN23_16","002_23_16","GEN","23","16","16","Doa Aprahamba ona, lehra, wo senmba velaihangoamnana indakonda, 400pelara os dembrahona, os Evron hev onam indhanana aongsra. Honamba diva snamba indhanamba sovawol vivna maketra. ");
INSERT INTO wrs_vpl VALUES ("GN23_17","002_23_17","GEN","23","17","18","Wo osva Evron pethava kovorahona Aprahamba, honi kovorahona, pethava melnahonam denwitnahonam, vena osora, vena pueilla. Wo Hitnindva indkumbi hillinamba, temba nomba doarava kusonamba, hellelmba, wo hev una, lehrata. ");
INSERT INTO wrs_vpl VALUES ("GN23_19","002_23_19","GEN","23","19","19","Doa Aprahamba hevna ongalmindva di singvena Saramba Kenan pethara. ");
INSERT INTO wrs_vpl VALUES ("GN23_20","002_23_20","GEN","23","20","20","Memba plalmomba lohv, Hitnindva hevna pethapetava kovoreihuna Aprahamba pokamapethalm. ");
INSERT INTO wrs_vpl VALUES ("GN24_1","002_24_1","GEN","24","1","1","Doa Aprahamba mundkola venamba, Yawe doara kolvromana vevna notongandrara notongandrara. Wo himba ongam silelmanavna ombolindam. ");
INSERT INTO wrs_vpl VALUES ("GN24_2","002_24_2","GEN","24","2","4","Doa andranindrini lohmanavna, hengas Aprahamna wohva kekalvho vrowovna. Wo Apraham omnana, yeoa garava, ongam silelguamno kavna ombolindam. Wo manam yimba huiva vravav hona Kenan petharava, owainonoa. Dom gao, ava ten kam lengnam, mongo noi vrao kavna aratindirinina molm. Heva os kamsna tanamolnam ishomno, si osva yimba tanamangas vevavma. Doa pevna englaoa hui yitho kana pohasingi, wo Yawena novra kam tanamolnam ishomno, ten Sesoa luhunvm ovm petham. ");
INSERT INTO wrs_vpl VALUES ("GN24_5","002_24_5","GEN","24","5","5","Doa andranindrini boasna omnana, es hevpa, kava ungevlirinimba diva omnatava, wo himba kamba engpramba owai vetava, wo es kava vevav? Kava osva posalva provavma, wo Isakva kava wolaihangavavma domba, ungevlirinimba vralmba? ");
INSERT INTO wrs_vpl VALUES ("GN24_6","002_24_6","GEN","24","6","6","Doa Apraham omnana, owainonoa, manam yimba kana ombolmba wolaihangavav athumunillamba, owai. ");
INSERT INTO wrs_vpl VALUES ("GN24_7","002_24_7","GEN","24","7","7","Manara, Sesoa mendekli doara kamba nomini waiprona, wo kavna aratindiriniva arana pethamba kava wohwuleihalahaprona. Wo Sesoava doa kamba tanamolnam ishomnana, osva hona pethava Kenan pethava si katindiva vaohuthuivav. Doa yeoa gavm, wo Sesoa mongo hevna ovsongolnindrinimba ata wolaihangavav mi, wo himba miva gavav, osm yimba beswonam si ungevlirinimba waiprovav kana ombolindamba. ");
INSERT INTO wrs_vpl VALUES ("GN24_8","002_24_8","GEN","24","8","8","Wo yimba mongova ungevlirinimba diva omnarava, wo himba ovotava, mani ye veima, owai. Wo manam yimba Isakmba wolaihangavav domba, owai. ");
INSERT INTO wrs_vpl VALUES ("GN24_9","002_24_9","GEN","24","9","9","Doa andranindriniva hevna engla yithana Aprahamna pohasingi, wo tanamolnam ishomnana, kava si osta vevav. ");
INSERT INTO wrs_vpl VALUES ("GN24_10","002_24_10","GEN","24","10","10","Doa nomba andranindriniva ganamba, wohva mindnam kamelva 9pelara iangavna, ungevlirinim nonam sovalm ingavna. Wonganamba, Nahorna kembella wonphonamba di Mesopotamia pethara. ");
INSERT INTO wrs_vpl VALUES ("GN24_11","002_24_11","GEN","24","11","11","Phonamba, kembellava saivnamoa, di peilla tovalpra aevulthana. Os phona makokonam, nonamba ungevliva pomba aihalv vevna. ");
INSERT INTO wrs_vpl VALUES ("GN24_12","002_24_12","GEN","24","12","12","Doa andranindriniva himba Yawem osahmanavna os, Yawe, yimba Sesoa av Aprahamna, wo yeoa kamoa detioa kolvro, osva eva yimba ata Aprahamba kolvravav, kana mendeklim. ");
INSERT INTO wrs_vpl VALUES ("GN24_13","002_24_13","GEN","24","13","13","Men kava po pethalla lohv, wo ungevliva men pomba aihalv vev mendah. ");
INSERT INTO wrs_vpl VALUES ("GN24_14","002_24_14","GEN","24","14","14","Wo mongom ata kava omnavav os, po kam vraho pevna sumbrini. Wo himba kamba osva omnatava, neota, wo eva yena kamelmba ata ka dahwol vevav, wo ata kava os nomba nonglavav, osva memba honamba ungevlirinimba doa yimba doara pusvundthoamnana Isakmba pevna andranindriniva. Wo os ata kava ishovav, Sesoa doa honamba vei, temba hevpa doarava Aprahamba tanamolnamba ishomnanamba. ");
INSERT INTO wrs_vpl VALUES ("GN24_15","002_24_15","GEN","24","15","15","Doa andranindriniva himba mendah Yawem osahmanavna, wo mongova ungevlirini prona, nihilva Repeka. Himba Betuelna mol, Betuelva nomba Nahorna Milkana ombol. Nahorva nomba Aprahamna boaslal doara lohmanavna. ");
INSERT INTO wrs_vpl VALUES ("GN24_16","002_24_16","GEN","24","16","16","Repekava besal hevm, wo mendah tlahui avna. Provna dom, sumbva lura wulprovna. Doa pomba vranamba, henga ga, ");
INSERT INTO wrs_vpl VALUES ("GN24_17","002_24_17","GEN","24","17","17","wo andranindriniva nomba lelnam ganamba, omnana, ei popeta kam vraho sumbrini. ");
INSERT INTO wrs_vpl VALUES ("GN24_18","002_24_18","GEN","24","18","18","Wo he omnana, neo manapenam, doa lurini nethamna. ");
INSERT INTO wrs_vpl VALUES ("GN24_19","002_24_19","GEN","24","19","19","Nenamba, doa he omnana, ata yenamba kamelva kava pomba dahwol vevav, verava, hev ambo lovahavra. ");
INSERT INTO wrs_vpl VALUES ("GN24_20","002_24_20","GEN","24","20","20","Doa lilnam guanamba, kamelna sumbra sovhunna, wo henga ivsho veka vinvna, vevnamba, kamelva lovaha. ");
INSERT INTO wrs_vpl VALUES ("GN24_21","002_24_21","GEN","24","21","21","Andranindriniva ambo nunglul avna, moamba ishovnamoa, os nengvna, Yaweva hona ungevlirinimangas pusvundthoanata doarava. ");
INSERT INTO wrs_vpl VALUES ("GN24_22","002_24_22","GEN","24","22","22","Doa himba pomba ivshopianamba, andranindriniva ona, memba kana kuwulna ombolna ongal. He si vravav. Doa huhmoh vre, vena, mela gol mendekli lomosra yithamna Repekam. Doa gol musung sambla mendekli vethawolmanana englarava. ");
INSERT INTO wrs_vpl VALUES ("GN24_23","002_24_23","GEN","24","23","23","Doa omnana, arapevm sevro, an nihilva henamba? Wo es hevpa, deuvrava vuhemba mindnam lohmanavma?, kava kavna andranindm wonsihalm ov, shalm. ");
INSERT INTO wrs_vpl VALUES ("GN24_24","002_24_24","GEN","24","24","24","Doa hev omnana, aramba kanamba Betuel, Nahorina Milkaina ombol. ");
INSERT INTO wrs_vpl VALUES ("GN24_25","002_24_25","GEN","24","25","25","Lohvta vuhemba, yimba osva ambtava, kamelna vuhemba innemba nalohvta. ");
INSERT INTO wrs_vpl VALUES ("GN24_26","002_24_26","GEN","24","26","26","Doa andranindriniva himba mulumbdandna lohvna, Yawem okolavna, ona, ");
INSERT INTO wrs_vpl VALUES ("GN24_27","002_24_27","GEN","24","27","27","Yawem kava okolav, himba Sesoanonoa Aprahamna kana mendeklina. Himba os beswonam vrei, os seilm ten ishomnanam Apraham. Himba doa kamba waiproi Aprahamna owalindam hom, mongnindindamba owai. ");
INSERT INTO wrs_vpl VALUES ("GN24_28","002_24_28","GEN","24","28","28","Doa Repekava himba lelnam deuvram gana avalindam, wo yunalm moamba wohishopieinna. ");
INSERT INTO wrs_vpl VALUES ("GN24_29","002_24_29","GEN","24","29","30","Wo muskovolva di lohvna, nihilva Lapan, wo himba hellenamba, golm musungm nongmanana muskovolna nihra. Doa nungi lelnam himba ganamba dom tovalpram, andranindrinimba nonglapho, mendah kamelinda lohvna. ");
INSERT INTO wrs_vpl VALUES ("GN24_31","002_24_31","GEN","24","31","31","Nonglaphonamba, omnana, yem ka wongai kavna deuvram. Doa kava lihai, yimba beswonam lohv, Yawe doa yemba kolvrena mindnam. Vuhemba lohmanavta yemba, eva kamelm luhunv. ");
INSERT INTO wrs_vpl VALUES ("GN24_32","002_24_32","GEN","24","32","32","Doa andranindrini no deuvra sihanamba, Lapanmba kin dombnamba kamelnamini, wo innemba dahwol vena kamelmba. Doa pomba wulkanamba, henam monglam nonam poswolalm, andranindrininam eva hevtatanam. ");
INSERT INTO wrs_vpl VALUES ("GN24_33","002_24_33","GEN","24","33","33","Doa inne iambinna. Doa andranindriniva unna, owai, kava lelnamba ata nevavmoa, moam boasna ka yem ishunvai. Doa Lapanmba omnana, wouta. ");
INSERT INTO wrs_vpl VALUES ("GN24_34","002_24_34","GEN","24","34","34","Wo he ona, kava Aprahamna andranindrini. ");
INSERT INTO wrs_vpl VALUES ("GN24_35","002_24_35","GEN","24","35","35","Yawe hemba beswonam vevrav, doa noinda himba lohv ditnamba. Yawe hemba dembrahona sipsipva, memeva, sapiva, senmba, andranindva, andraunguvliva, kamelva, donkiva mindnam. ");
INSERT INTO wrs_vpl VALUES ("GN24_36","002_24_36","GEN","24","36","36","Doa ongalva Sarava tuendisrinim sleihana, nonamba himba mundkolalva avnamba. Wo aralva hena englisra wohna innenamba slowothomanana doa. ");
INSERT INTO wrs_vpl VALUES ("GN24_37","002_24_37","GEN","24","37","37","Doa Aprahamba kamba ishomnana, ongam novm wulluholm ombinam, wo kamba keknam ishomnavna, huiva manam yimba Kenanongoriniva novvevav, ");
INSERT INTO wrs_vpl VALUES ("GN24_38","002_24_38","GEN","24","38","38","owai, kavna aratindi indam gao, di novveo. ");
INSERT INTO wrs_vpl VALUES ("GN24_39","002_24_39","GEN","24","39","39","Wo kava ona, kava omnatava, wo kamba engpramba owai vetava, es hevpa kava vevav? ");
INSERT INTO wrs_vpl VALUES ("GN24_40","002_24_40","GEN","24","40","40","Wo Apraham ona, manapenam, Yawe osva hevna ovsongolnindrinim miva wolaihangavav. Wo yimba mongawulm engavavta, yem kolvrelm, wo yimba osva tanam omnavav kavna aratindirinim. ");
INSERT INTO wrs_vpl VALUES ("GN24_41","002_24_41","GEN","24","41","41","Wo kavna aratindiva yemba ovumnitava, yeindava moamba lohvavmoa. ");
INSERT INTO wrs_vpl VALUES ("GN24_42","002_24_42","GEN","24","42","42","Doa detiva kava tovalpra phoi, wo di kava Yawem osahmanavna os, yeoa kamoa kolvro. Yimba Sesoanonoa wohav Aprahamna kana mendeklina. ");
INSERT INTO wrs_vpl VALUES ("GN24_43","002_24_43","GEN","24","43","43","Men kava lohv tovalpra, wo mongo ungevliriniva ata pom prorava, ata kava os ishomnavav, po kam vraho pevna sumbrini. ");
INSERT INTO wrs_vpl VALUES ("GN24_44","002_24_44","GEN","24","44","44","Wo himba helletava, ata kamba vrahorava, wo himba osva otava, yena kamelmba ata ka dahwol vevav. Wo osva kava ata lihavav, hona ungevliriniva yimba doa pusvundthoamnana Isakmba kana mendeklina ombolindamba. ");
INSERT INTO wrs_vpl VALUES ("GN24_45","002_24_45","GEN","24","45","45","Kava mendah Yawem os osahmanavna kavna nengavnangna, wo mongo ungevlirini provna, sumbva lura euvholotho wulprovna, himba Repeka. Doa himba pom vralm pihaiva, kava omni, po kam vraho, ");
INSERT INTO wrs_vpl VALUES ("GN24_46","002_24_46","GEN","24","46","46","wo hev lurini nethamni, kam omni, neota, wo henga oi, ata yenamba kamelva ka dahwol vevav. Doa ka nevna, he eva kanamba kamelmba dahwol vevna. ");
INSERT INTO wrs_vpl VALUES ("GN24_47","002_24_47","GEN","24","47","47","Doa kava oi, kam arapevna nihilm sevramno, wo he oi, aramba kanamba Betuel, Nahorina Milkaina ombol. Doa pevrahol gol kava lomosra vethamni, musung gol vethawolmani englara. ");
INSERT INTO wrs_vpl VALUES ("GN24_48","002_24_48","GEN","24","48","48","Doa kava mulumbdandna lohvna, Yawem okolavna, oi, yimba Sesoanonoa wohav Aprahamna kana mendeklina, yimba kamba waiproi homba Aprahamna owalindamba, mongnindindamba owai, wo doa kava ungevliriniva omni Isakindamba. ");
INSERT INTO wrs_vpl VALUES ("GN24_49","002_24_49","GEN","24","49","49","Doa andranindriniva mendah ishungeinvna os, yimba beswonamba Aprahamba velmba vinivrava, osoa kamoa ishumnu, wo osva kava ungevlirinimba henga waingavav. Eva yeoa os viuta, wo owai vitava, yeoa osoa kamoa ishumnuta, wo kava henga osva nengvav, henahalm hevpa kava omnavav? ");
INSERT INTO wrs_vpl VALUES ("GN24_50","002_24_50","GEN","24","50","50","Doa Lapani Betueli ehellenamba, ohomnana, manapenam, Yawe honamba vena, manam kava owai momo ohovav, owai, ");
INSERT INTO wrs_vpl VALUES ("GN24_51","002_24_51","GEN","24","51","51","Repekava men av, yeo waiango, Isakna deuvra desvhoao di pevna mendekli inda, memba Yawena nengavnangra lohna. ");
INSERT INTO wrs_vpl VALUES ("GN24_52","002_24_52","GEN","24","52","52","Doa andranindriniva hellenamba, ku kusitha, Yawem okolavna. ");
INSERT INTO wrs_vpl VALUES ("GN24_53","002_24_53","GEN","24","53","53","Doa woh besal dembhapho vevna, Repekam dembraholm. Kayen, di, gol, manimani noi dembrahovna. Doa manimani eva dembrahunvna muskovolm avalm, diva mindnam os i. ");
INSERT INTO wrs_vpl VALUES ("GN24_54","002_24_54","GEN","24","54","54","Doa andranindriniva hevna owalmongo innemba hlanamba, po hlanamba, doa nin shatha. Doa simolnam phonamba, unna, kam henga wolanga viu kavna mendekli indam. ");
INSERT INTO wrs_vpl VALUES ("GN24_55","002_24_55","GEN","24","55","55","Doa Repekana muskovoli avali ohona, Repekaoa dawonam ara, minguva mongasal verava, daha os provma. ");
INSERT INTO wrs_vpl VALUES ("GN24_56","002_24_56","GEN","24","56","56","Wo andranindrini ona, owai, manam yimba kamba kakaiv vivav. Yawe doa kamba poauothona, ungevlirinim omnakalm Isakindam. Wo yeoa kamoa wolanga viu henga kavna mendekli indam. Kava henga galm vev. ");
INSERT INTO wrs_vpl VALUES ("GN24_57","002_24_57","GEN","24","57","57","Doa himba una, Repekam wunuhumnu, sah ovrelm. ");
INSERT INTO wrs_vpl VALUES ("GN24_58","002_24_58","GEN","24","58","58","Doa wunuhumninamba, umnina, yimba hona tendorinimba ata engpethavavma ora owai? Ona, eie, ata kava engavavta. ");
INSERT INTO wrs_vpl VALUES ("GN24_59","002_24_59","GEN","24","59","59","Wo osoa himba umnina, engota, wo andranind unguvlirinimoa pevnamoa yeoa waingao. ");
INSERT INTO wrs_vpl VALUES ("GN24_60","002_24_60","GEN","24","60","60","Doa henga Repekam umnina, yetindioa mindnam esvema phora, wo ungundva himba engilvra, petham muehvalm. ");
INSERT INTO wrs_vpl VALUES ("GN24_61","002_24_61","GEN","24","61","61","Doa Repekai hevna andraunguvlirinii kamelsra ahavhowolnamba, os gapiana andranindrinimongo. ");
INSERT INTO wrs_vpl VALUES ("GN24_62","002_24_62","GEN","24","62","62","Doa anganamba, wo nonamba Isakva doara wuleihana pethamba, di ten tovalp lohvm, os ningthivna Sesoana tovalp, doara hev avhoana pundra pethakoklara. ");
INSERT INTO wrs_vpl VALUES ("GN24_63","002_24_63","GEN","24","63","63","Wo makokonam himba osohovra lohmana vevna. Doa himba nongalga vena, ona, pai, ten kamelva monam ambv. ");
INSERT INTO wrs_vpl VALUES ("GN24_64","002_24_64","GEN","24","64","64","Doa kamelva murapetava vivnamba, Repekava Isakm nonglanamba, doa piha petharam, ");
INSERT INTO wrs_vpl VALUES ("GN24_65","002_24_65","GEN","24","65","65","andranindrinim osahmana, an hevpa temba osomonamba prunv pindamba? Ona, temba Isak kana mendekli prov. Doa Repekava kayenna hevnam novlomosm ehlathana. ");
INSERT INTO wrs_vpl VALUES ("GN24_66","002_24_66","GEN","24","66","66","Doa Isakva pronamba, andranindrini yunalm moa ishopiamnanamba, ten hev venam. Doa Isakva Repekam waingana deuvram, doa himba tlali ahavna, temba deuvpa nemetva noindava Saramba anamba Isakna avalva. ");
INSERT INTO wrs_vpl VALUES ("GN24_67","002_24_67","GEN","24","67","67","Doa Isakva Repekamba mindnam und vevna, himba wuleihavna, indvawomnalmba avalmba, wi vevnamoa hengava, temba seilva avalmba dahamnanamba. ");
INSERT INTO wrs_vpl VALUES ("GN25_1","002_25_1","GEN","25","1","1","Doa Aprahamba ongamba mongom henga vrana, nihilva Ketura, ");
INSERT INTO wrs_vpl VALUES ("GN25_2","002_25_2","GEN","25","2","2","wo himba towand evena ombolm, Simran, Yoksan, Metan, Mitian, Ispak, Suwa. ");
INSERT INTO wrs_vpl VALUES ("GN25_3","002_25_3","GEN","25","3","3","Wo sisva Yoksanmba luhunna Sepana Detanna aral, wo Detanmba simbel luhunna Asurnindna, Letusnindna, Leumnindna. ");
INSERT INTO wrs_vpl VALUES ("GN25_4","002_25_4","GEN","25","4","4","Wo Mitianmba nomba sis aralva luhunna Epana, Eperna, Hanokna, Apitana, Eltana. Memba Keturatindi. ");
INSERT INTO wrs_vpl VALUES ("GN25_5","002_25_5","GEN","25","5","6","Doa Aprahamba mendah lohvna, wo himba nis dembrahunvna manimani nom ombolm, temba ongal sambla towand evenam Keturai Hakari. Wo sism himba wolanga vena mongona petharamba, ten okomba pholohvm. Kamba daharava, kana puewulva Isakmangas si wohnalohmanavav. ");
INSERT INTO wrs_vpl VALUES ("GN25_7","002_25_7","GEN","25","7","7","Doa Aprahamnamba osomba 175pelara os lohmanana, ");
INSERT INTO wrs_vpl VALUES ("GN25_8","002_25_8","GEN","25","8","8","doa os wohdahana. ");
INSERT INTO wrs_vpl VALUES ("GN25_9","002_25_9","GEN","25","9","9","Doa ombol sambla Isaki Ismaeli esingvena di mella honmera, os ningthiv Makpela. Melva nomba di pethara lohv Mamrera nohalm, ten okomba pholohvm. ");
INSERT INTO wrs_vpl VALUES ("GN25_10","002_25_10","GEN","25","10","10","Pethava nomba Evronna englisra seilva lohvna, himba Hitnindrini Soharna ombol. Wo himba doara Aprahamba kovorahona, wo Aprahamba di dembrahona, doa hevna ongalmba Saramba di os singvena. ");
INSERT INTO wrs_vpl VALUES ("GN25_11","002_25_11","GEN","25","11","11","Doa Isaki Ismaeli hevna aralmba di esingvenamba, wo Isakva di wohana no pethara, ten tovalp lohvnam, os ningthivna Sesoana tovalp. Wo Sesoa kolvrevna. ");
INSERT INTO wrs_vpl VALUES ("GN25_12","002_25_12","GEN","25","12","12","Doa Ismaelva Aprahamna ombol lohna, temba Hakarva lengnamba, Hakarva nomba Isipongorini ana, Sarana andranind unguvlirini. ");
INSERT INTO wrs_vpl VALUES ("GN25_13","002_25_13","GEN","25","13","13","Wo Ismaelna ombolva os phona, yivel venamba kalel, Nepaiot, Ketar, Atpel, Mipsam, ");
INSERT INTO wrs_vpl VALUES ("GN25_14","002_25_14","GEN","25","14","14","Misma, Duma, Masa, ");
INSERT INTO wrs_vpl VALUES ("GN25_15","002_25_15","GEN","25","15","15","Hatat, Tema, Yetur, Napis, Ketema. ");
INSERT INTO wrs_vpl VALUES ("GN25_16","002_25_16","GEN","25","16","16","Memba indhanana simbelva 12pelara lovahvna. Wo pethava, kembelva henamba, indhanamba os nengthawol vinvna indakonda simbelna nihilm. ");
INSERT INTO wrs_vpl VALUES ("GN25_17","002_25_17","GEN","25","17","17","Doa Ismaelva osomba 137pelara venamba, doa os hemba dahana. ");
INSERT INTO wrs_vpl VALUES ("GN25_18","002_25_18","GEN","25","18","18","Wo hetindiva di aevluwul vevna Havilara hovra Surra, di Asiria pethamonara aevluwul vevna, ten okomba pholohvm Isipnahalm. Himba indanam aevluwul vevna, Aprahamtindiva indanam aevluwul vevna, manara, himba daosnind avna. ");
INSERT INTO wrs_vpl VALUES ("GN25_19","002_25_19","GEN","25","19","19","Memba moamba Isakna Aprahamna ombolna. ");
INSERT INTO wrs_vpl VALUES ("GN25_20","002_25_20","GEN","25","20","20","Isaknamba osomba os lohmanavna 40pelara, wo os Repekamba vrana. Repekava nomba Betuelna mol, Lapanna muskovol. Betuelva nomba Aramnindrini di lohvna Mesopotamia pethara. ");
INSERT INTO wrs_vpl VALUES ("GN25_21","002_25_21","GEN","25","21","21","Doa Repekava phal avna, wo tlal Yawem osahmanavna nom. Doa himba hellenamba, wo Repekava ena vethana, ");
INSERT INTO wrs_vpl VALUES ("GN25_22","002_25_22","GEN","25","22","22","otolva sambla ihilmanavna emerava, hevm epishawolvna. Doa avalva ona, es hevpa kamba venav? Doa ganamba, Yawem osahmana, ");
INSERT INTO wrs_vpl VALUES ("GN25_23","002_25_23","GEN","25","23","23","Yawe omnana, si yimba lengwolvav, si indakonda ahawolvav, si hevm ehelvawollahavav. Mongova si andral avav, mongova si oiel avav. Wo eteltindiva boaslaltindina keusingi si avav. ");
INSERT INTO wrs_vpl VALUES ("GN25_24","002_25_24","GEN","25","24","24","Doa henanam osoa ambo kelathamnavna, wo otol samblamba os lengwolna, tuendisrini samblam. ");
INSERT INTO wrs_vpl VALUES ("GN25_25","002_25_25","GEN","25","25","25","Yiveltowondva nih aembuna, wo nihtovpa mindnam tatana, os awona Esaum. ");
INSERT INTO wrs_vpl VALUES ("GN25_26","002_25_26","GEN","25","26","26","Sisminiva doara etelna munngulm wohkek vethanamba, os elengepewolna, awona Yakopm. Isakna osomba os lohvna 60pelara, nonamba ombol samblamba avalva lengwolvnamba. ");
INSERT INTO wrs_vpl VALUES ("GN25_27","002_25_27","GEN","25","27","27","Doa tuendisrini samblam mendekli vewolna. Esauva tatawonga lohvna, himba deuvrava avnamoa. Wo Yakopva owai, himba deuvrangas awol vevna. ");
INSERT INTO wrs_vpl VALUES ("GN25_28","002_25_28","GEN","25","28","28","Aralva Isakva Esaumangas nengmanavna mindnamba, manara tatamba nihilangas himba aipra venavna. Wo avalva Repekava Yakopm nengmanavna mindnamba. ");
INSERT INTO wrs_vpl VALUES ("GN25_29","002_25_29","GEN","25","29","29","Doa Yakopva blekra weihavna katangba, Esauva nomini provna nesarini. Pon venavnamba, ");
INSERT INTO wrs_vpl VALUES ("GN25_30","002_25_30","GEN","25","30","30","noinda boaslalm omnavna, kam waihao noi aembulpol. ");
INSERT INTO wrs_vpl VALUES ("GN25_31","002_25_31","GEN","25","31","31","Doa boaslal omnana, manapenam ata kava yemba wainevav. Heva os boasna yeoa kamoa tanamolnam ishomno, os pina aramba daheintava, puewulva kainda si nalohvav, yeindava owai. Kava osm loholm vev yiveltowondalm. ");
INSERT INTO wrs_vpl VALUES ("GN25_32","002_25_32","GEN","25","32","32","Doa etel omnana, lehra, murapeta kamba ponda dahav, arana mana vemamba si kamba kolvrevavmoa osva. ");
INSERT INTO wrs_vpl VALUES ("GN25_33","002_25_33","GEN","25","33","33","Doa boaslal omnana, boasna kam tanamolnam wohishomno, ata kava yemba wainevav. Doa etel tanamolnam ishomnana, puewulva pina aranamba si yeindangas nalohvav. ");
INSERT INTO wrs_vpl VALUES ("GN25_34","002_25_34","GEN","25","34","34","Doa boaslalva wainena roti katangpol, nenamba, os pholahangana. Esauva osva beswonamba nengvnamoa, yiveltowondva ka lohv, owai. Wo himba beswonamba nengvnamoa tanamolmomba, temba Sesoava aralmba ishomnanamba doarava. Esauna mongova nihilva Etom, osm uvna aembul, manara, katangpw aembul nenamba. ");
INSERT INTO wrs_vpl VALUES ("GN26_1","002_26_1","GEN","26","1","1","Doa owousva phovna petharava diva, indanampetam seilva Aprahamna novrava. ");
INSERT INTO wrs_vpl VALUES ("GN26_2","002_26_2","GEN","26","2","2","Wo Yawe nonglaphona, Isakm ishomnavna, manam yimba honamba pethamba wuleihavav, wo manam yimba Isip petharamba wongavav. Si yemba ka indthoamnavav, ora honinda ao, wo si yemba kava waiavav, kolvrevav. ");
INSERT INTO wrs_vpl VALUES ("GN26_3","002_26_3","GEN","26","3","3","Doa honamba pethava si yemba kava kovorahunvav, yem yetindim, seilm nemet ten kava Apraham ishomnanam arapevm. ");
INSERT INTO wrs_vpl VALUES ("GN26_4","002_26_4","GEN","26","4","4","Si yetindiva mindnam phovav paimsna, wo si kava kovorahunvav hona pethava. ");
INSERT INTO wrs_vpl VALUES ("GN26_5","002_26_5","GEN","26","5","5","Indhanamba indkumbiva si hemba nungeilvrava, doa himba eva kamba sah ovrivra, kamoa eva os vinuta yeoa, Isaktindim ten pev vinnam. Arapevpa yenamba Aprahamba kana moam engvna, eva kana lohohmom engvna, wo noinda yemba kava kolvrevav. Doa Isakva hellenamba Sesoamba, wo Apimelekm enggana Gerar kembellam, Apimelekva nomba kuwul mendekli wulluhunvna Pilistianindna. ");
INSERT INTO wrs_vpl VALUES ("GN26_6","002_26_6","GEN","26","6","7","Doa Isakva ongali ahavna di Gerarra Apimelekinda. Tendomba nonamba osihminivnamba hena ongalmba, himba os unvna, memba kana muskovol. Himba pem vevna, ishunilmba, osva memba kana ongal, osra ata kamba helvakomandhivav, wo kana ongalva pelvreivav hevm. Ongalva besal hevm amnavna. ");
INSERT INTO wrs_vpl VALUES ("GN26_8","002_26_8","GEN","26","8","8","Doa sism Apimelek hevna eneshatuvra novvelohvna amballam, nongalna, pai, Isakva Repekam waiav. ");
INSERT INTO wrs_vpl VALUES ("GN26_9","002_26_9","GEN","26","9","9","Doa ona, Isakm umnu, prora hom, ka sah ovrei. Doa Isakva pronamba, Apimelek omnana, Repekava yena ongalma a, muskopevmi? Es hevpa yimba kamba gekalava omnavna, osva kana muskovol. Doa Isak omnana, os kava nengna, kava osva untava, kana ongal, ata yimba kamba helvakomandhivav. ");
INSERT INTO wrs_vpl VALUES ("GN26_10","002_26_10","GEN","26","10","10","Doa Apimelek omnana, yimba honamba kamba sahonam vinvna. Osva mongova kariniva wailitava yena ongapevmba, wo osva mendekli ata indkoklawonam kainamba lohta. ");
INSERT INTO wrs_vpl VALUES ("GN26_11","002_26_11","GEN","26","11","11","Doa Apimelek ishonga vinna indkumbim, os mongova kevratava Isaknamba ongalmba, henomba kava helvakomandhavav. ");
INSERT INTO wrs_vpl VALUES ("GN26_12","002_26_12","GEN","26","12","12","Doa Isak osora innemba koko venamba, wo esvema phona, manara Yawe kolvrena. Himba osangas vaomana vevna, espeta wolavna, wo innemba mindnam phomnavna, ");
INSERT INTO wrs_vpl VALUES ("GN26_13","002_26_13","GEN","26","13","13","wo himba ditowondva noinda lohvna. ");
INSERT INTO wrs_vpl VALUES ("GN26_14","002_26_14","GEN","26","14","14","Sipsipva sapiva esvema lovahmanavna, wo andranindva himba mindnam wonavna. Wo noinda nomba Pilistianindva hemba mueumb vinivna. ");
INSERT INTO wrs_vpl VALUES ("GN26_15","002_26_15","GEN","26","15","15","Doa himba angawul venamba, tovalpva nomba Aprahamna andranind doara tovawol vinam, noindava himba hon dembhapuv vinamba, pundind vewol wohvinna. ");
INSERT INTO wrs_vpl VALUES ("GN26_16","002_26_16","GEN","26","16","16","Doa Apimelek Isakm ishomnana, yeoa pulvo hona petharinioa, yetindiva doa mindnam phona, wo keknamangas lovahv, andra viv. ");
INSERT INTO wrs_vpl VALUES ("GN26_17","002_26_17","GEN","26","17","17","Doa Isakva wonganamba, di aevulthana Gerarpundra, di dawonam wonalohvna. ");
INSERT INTO wrs_vpl VALUES ("GN26_18","002_26_18","GEN","26","18","18","Doa himba henga tovalpva wontovawol wonvena, nomba aralva nemetva temba wontovawol wonvenamba, Pilistianindva doara honmba pundind vewol vinna. Nemet aral ten nengsm ovna tovalpmba nomba, wo Isakva osta eva henga sevel ovna. ");
INSERT INTO wrs_vpl VALUES ("GN26_19","002_26_19","GEN","26","19","19","Doa Isakna andranind henga mel mongo tuveinamba, pom kihie. ");
INSERT INTO wrs_vpl VALUES ("GN26_20","002_26_20","GEN","26","20","20","Wo sism himba dahwol vivna sipsipmba Isaknamba, Gerarnindva himba ambvnamba, koasromb vi, unna, memba pomba kana, yenamba owai. Doa Isakva os tovalpmba nomba sevravna Esek, osm ovna, koasromb. ");
INSERT INTO wrs_vpl VALUES ("GN26_21","002_26_21","GEN","26","21","21","Doa henga mel mongo tuveinamba, doa henga indhanamba ambanamba, koasromb vie. Doa Isakva os tovalpmba nomba sevravna Sitna, osm ovna, daosmoa. ");
INSERT INTO wrs_vpl VALUES ("GN26_22","002_26_22","GEN","26","22","22","Doa Isakva nominiva wonganamba, indanam di wonavhoana, henga tovalp mongo wontovo, wo indhanamba hemba tandwol vinamoa, noinda os tovalpmba nomba sevravna Rehopot, osm ovna, beswonam aevulv. Ona, Yawe hev pimba doa sandhana besal pethara, si pimba beswonam indwonam wohaevulvav. ");
INSERT INTO wrs_vpl VALUES ("GN26_23","002_26_23","GEN","26","23","23","Doa nominiva Isakva wonganamba, di wonpho Bersepara. ");
INSERT INTO wrs_vpl VALUES ("GN26_24","002_26_24","GEN","26","24","24","Doa sinim Yawe phomna, omnana, kava Sesoa, ten Apraham arapev sembayang kam vaomana venavnam, manam yimba pemba vevav, yemba kava waiavav, wo awothovav, wo yetindiva si mindnam phovav, noinda kava doara arapevmba wohishomnana, himba kana andranindrini lohvna. ");
INSERT INTO wrs_vpl VALUES ("GN26_25","002_26_25","GEN","26","25","25","Doa Isakva hellenamba, hon songowol venamba, di sembayang vaomanavna. Doa lailduvpa di vewol wonvena, wo andranind henga mongo tovalpva tuveina. ");
INSERT INTO wrs_vpl VALUES ("GN26_26","002_26_26","GEN","26","26","26","Doa Apimelekva mendekli hevnamini Gerarrini prona, Isakm engprana. Wo hevna mendekli samblam wonprona, vei Ahusatm nonoanindrinim, eva valgonindna kuwulm Pikolm. ");
INSERT INTO wrs_vpl VALUES ("GN26_27","002_26_27","GEN","26","27","27","Wonphonamba, Isakva unna, es hevpa yimba kamba engambei, seilva yimba kamba os umnina, kembeloa honaoa wuleihu, yimba beswonamba kamba wonishonamoa. ");
INSERT INTO wrs_vpl VALUES ("GN26_28","002_26_28","GEN","26","28","28","Doa hev una, doa kava liheiv, Yawe yemba tanamolnam kolvrev, wo kava yemongom moam isholm viv, osm pimba beswonam aevluwul vevav. Yeoa tanamolnam kamoa ishunu, ");
INSERT INTO wrs_vpl VALUES ("GN26_29","002_26_29","GEN","26","29","29","osva yimba si kamba helvawol vivavmoa. Nemetva seilva yimba kamba wonavnamba, kava yemba tandwol vivnamoa, yemba helvawol vinamoa. Kava yemba nungtina, beswonam indwonam, wo doa Yaweva yemba beswonam vewol vev. ");
INSERT INTO wrs_vpl VALUES ("GN26_30","002_26_30","GEN","26","30","30","Doa Isakva hellenamba, innemba mendekli meilna vevna, doa os dahwol vena innena pona. ");
INSERT INTO wrs_vpl VALUES ("GN26_31","002_26_31","GEN","26","31","31","Doa simolnam hev indkumbi nomba moamba wohmokeltheivna, doa hev una, Sesoa hev pimba nongalvav, ora tanamolnam ishuv. Doa himba beswonam aevulvna, wo Isak samblamong indhanam nom wolanga vena. ");
INSERT INTO wrs_vpl VALUES ("GN26_32","002_26_32","GEN","26","32","32","Doa Isakna andranindva nonamba ambna, umnina, doa kava pomba kihei. ");
INSERT INTO wrs_vpl VALUES ("GN26_33","002_26_33","GEN","26","33","33","Wo Isakva os sevravna, memba tovalpva Sipa, osm ovna, tanamolnam wohishuv. Wo noinda indhanamba no kembelmba osva mendah ningthiv, Bersepa, osm ovna, memba tovalpva tanamolmoa. ");
INSERT INTO wrs_vpl VALUES ("GN26_34","002_26_34","GEN","26","34","34","Doa Esau yiveltowondva osomba 40pelara venamba, ongamba sambla dombtna, ungund ongorini samblam Hitnindongo. Mongova Yutit, Berina mol, mongova Basemat, Elonna mol. ");
INSERT INTO wrs_vpl VALUES ("GN26_35","002_26_35","GEN","26","35","35","Doa Isakiva Repekaiva himba sahonam enenginvna honamba ungund ongorini samblamba. ");
INSERT INTO wrs_vpl VALUES ("GN27_1","002_27_1","GEN","27","1","1","Doa Isakmba mundkola venamba, novtit vevna. Doa hev ona, kavna yiveltowond Esau prora. Pronamba, omnana, omb, wo he omnana aralm, men kava lohv. ");
INSERT INTO wrs_vpl VALUES ("GN27_2","002_27_2","GEN","27","2","2","Doa aral omnana, doa kava mundkolal lohv, si lelnam kamba dahavmi. ");
INSERT INTO wrs_vpl VALUES ("GN27_3","002_27_3","GEN","27","3","3","Yeoa pevna bunevalgooa dombrava, wo kamoa tatapetaoa lomno. ");
INSERT INTO wrs_vpl VALUES ("GN27_4","002_27_4","GEN","27","4","4","Lomnarava, weiharava, os kamoa wulsihamno. Omnana, yimba kamba doa sihamnana, ata kava nerava, yemba ata kava Sesoam osahmanavav, mindnam kolvro, manara yimba kana yiveltowond lohv. ");
INSERT INTO wrs_vpl VALUES ("GN27_5","002_27_5","GEN","27","5","5","Doa Isakva hevna yiveltowondm ishomnavna, ongalva poaita avna, hellewulavna. Doa Esauva nesam gana, ");
INSERT INTO wrs_vpl VALUES ("GN27_6","002_27_6","GEN","27","6","6","avalva Yakopm ishomnana, os doa kava hellei, arapevpa yenamba etepevm ishomni, os omni, ");
INSERT INTO wrs_vpl VALUES ("GN27_7","002_27_7","GEN","27","7","7","tatapetaoa kamoa lomno, lomnarava, weiharava, wo os kava ata nevav. Nepiarava, ata os kava Yawemba kolvrelmomba ishomnavav, osm yem awotholm, manara si kamba dahavav. ");
INSERT INTO wrs_vpl VALUES ("GN27_8","002_27_8","GEN","27","8","8","Doa avalva mendah Yakopm ishongamnavna, wo yeoa kana moam hellevm, ");
INSERT INTO wrs_vpl VALUES ("GN27_9","002_27_9","GEN","27","9","9","memetatanaindam garava, wo otol samblam holvorawollava, hom wonproo naembulnangas. Ata kava weithavav, osm arapevpa yenamba mindnam nengmanavra. ");
INSERT INTO wrs_vpl VALUES ("GN27_10","002_27_10","GEN","27","10","10","Weitharava, yeoa os guamno, ata nerava, ata Sesoamba os osahmanavav yeinda, etepevindava owai. ");
INSERT INTO wrs_vpl VALUES ("GN27_11","002_27_11","GEN","27","11","11","Doa Yakop omnana, owai, Esauva mindnam talna lohv, kava owai, yimba nonora. ");
INSERT INTO wrs_vpl VALUES ("GN27_12","002_27_12","GEN","27","12","12","Wo aramba englava kaindava holothotava, ata os nengvav, kava Esauva owai, noinda ata Sesoamba osahmanavav kamba helvelmba. ");
INSERT INTO wrs_vpl VALUES ("GN27_13","002_27_13","GEN","27","13","13","Doa aval omnana, kamba helvetava homeista, doa lelnam gao. ");
INSERT INTO wrs_vpl VALUES ("GN27_14","002_27_14","GEN","27","14","14","Doa himba ganamba, memeotol samblam wonpro, doa aval weitha, osm aral mindnam nengvra. ");
INSERT INTO wrs_vpl VALUES ("GN27_15","002_27_15","GEN","27","15","15","Doa avalva Esauna kayen besal dombna hevna deuvrini, ten nalohvnam, doa Yakopm vewol venana. ");
INSERT INTO wrs_vpl VALUES ("GN27_16","002_27_16","GEN","27","16","16","Doa hev henga memetov vranamba, Yakopinda holowohamnana, vei englara eva wangra. ");
INSERT INTO wrs_vpl VALUES ("GN27_17","002_27_17","GEN","27","17","17","Doa tatanihil vetrahona rotinahonam, omnana, ingamno arapevm. ");
INSERT INTO wrs_vpl VALUES ("GN27_18","002_27_18","GEN","27","18","18","Doa Yakop inganamba, aralm omnana, ara men kava lohv. Doa aral omnana, yimba heni, ora yiveltowond ora kalel? ");
INSERT INTO wrs_vpl VALUES ("GN27_19","002_27_19","GEN","27","19","19","Doa hev omnana, kava yiveltowond Esau, gekala omnavna. Os kava vev, ye ten oim. Yeoa phorava, tataoa honaoa nevm, nerava, Sesoam mindnam sahmano kaindam pevna yiveltowondindam. ");
INSERT INTO wrs_vpl VALUES ("GN27_20","002_27_20","GEN","27","20","20","Doa aral omnana, yimba ambo lelnam loi, es hevpa? Doa kalel omnana, Yawe kam kolvrei, ten pev lohmanavm, noinda kava lelnamba nonglai. Heva os gekala omnavna. ");
INSERT INTO wrs_vpl VALUES ("GN27_21","002_27_21","GEN","27","21","21","Doa aral omnana, murapetam proo, yena nihm ka kevravai. Yimba Esaumi ora owai? ");
INSERT INTO wrs_vpl VALUES ("GN27_22","002_27_22","GEN","27","22","22","Doa kalel murapetam ganamba, aral englaval kevra, omnana, yena moalamangva Yakopna, heva os englava yenamba Esauna. ");
INSERT INTO wrs_vpl VALUES ("GN27_23","002_27_23","GEN","27","23","23","Aralva englavalva kevranamoa, memetovm kevrana talnahonam, ona, Esauna tal. ");
INSERT INTO wrs_vpl VALUES ("GN27_24","002_27_24","GEN","27","24","24","Doa aralva kalelm omnana, tanamolnam yimba Esauma?, wo he omnana, eie, gekala omnavna. ");
INSERT INTO wrs_vpl VALUES ("GN27_25","002_27_25","GEN","27","25","25","Doa aral omnana, tatanihil kam vetraho, boasna kava nerava, os ata kava Sesoamba osahmanavav. Doa kalel vetrahonamba, doa wainpol wulkamna. ");
INSERT INTO wrs_vpl VALUES ("GN27_26","002_27_26","GEN","27","26","26","Doa nenamba, henga kalelm omnana, murapetam proo, kam sendara othoo. ");
INSERT INTO wrs_vpl VALUES ("GN27_27","002_27_27","GEN","27","27","27","Doa kalelva murapetam ganamba, aralm sendara otho. Doa aral teihnunglaku vene kayenm, ona, lehra besal hevm teihnung venav, oi osothnung, temba Yawe doa beswonam vrenam. ");
INSERT INTO wrs_vpl VALUES ("GN27_28","002_27_28","GEN","27","28","28","Wo Sesoaoa pomoa wolaihaprara yena osoram, wo yena innemba mindnam phovav, wo mindnam yena deuvrava nalohvav osonna eva wainpol. ");
INSERT INTO wrs_vpl VALUES ("GN27_29","002_27_29","GEN","27","29","29","Sesoa hev vevav, yena keusingi lovahvav indkumbiva, wo himba hevna kuva yem kusithapramnavav. Wo yetatanamba indkumbiva hillivav yena moamba, hevna kuva yem kusithapramnavav. Sesoa hev vevra, anvemamba yemba indkokla ovretava, eva henomba sahokla vevavta hevmba, wo anvemamba yemba beswonam ovrerava, osva Sesoa henomba kolvrowol vevav. Doa. ");
INSERT INTO wrs_vpl VALUES ("GN27_30","002_27_30","GEN","27","30","30","Doa aralva awothonamba, Yakopva pholahanga. Doa wenokombava venamoa owai, Esau prona, tatapeta wulprona. ");
INSERT INTO wrs_vpl VALUES ("GN27_31","002_27_31","GEN","27","31","31","Weihanamba, os besva vevna i, doa aralm guamnanamba, omnana, phorava, hona tatapetaoa nerava, doa os Sesoam osahmano kaindam, pev ten oim. ");
INSERT INTO wrs_vpl VALUES ("GN27_32","002_27_32","GEN","27","32","32","Doa aral omnana, an yimba? Ona, kava Esau, kava yena yiveltowond. ");
INSERT INTO wrs_vpl VALUES ("GN27_33","002_27_33","GEN","27","33","33","Doa aralmba mindnam eisvna englamonglanahonam, ona, an hevpa tatamba loi, wo kaindam wulproi, men kava daipotangas nei? Temba henomba wulproiva, doa kava Sesoam osahmani, mindnam kolvro, wo honamba kolvrelmomba heinda wohlohmanavav, yeindamba owai. ");
INSERT INTO wrs_vpl VALUES ("GN27_34","002_27_34","GEN","27","34","34","Doa yiveltowondva hellenamba, himba sahonam ambo nengvna, wo eva wi vevna esvema, omnana, Sesoam osahmanota eva kaindam. ");
INSERT INTO wrs_vpl VALUES ("GN27_35","002_27_35","GEN","27","35","35","Doa aral omnana, kava owai, es eva, boaslapevpa yenamba kamba deswuhai, doa kolvrelmomba heinda wohphoi. ");
INSERT INTO wrs_vpl VALUES ("GN27_36","002_27_36","GEN","27","36","36","Doa yiveltowond omnana, memba daipotava himba yemba kandaspolm omni, doarava kamba os eva omnanata. Wo honanamba pimba os ningthiv, Yakopva himba deswuhanindrini lohv. Seilva doarava kamba omnana, pina arana puewulva si kavna englisra nalohvav, yeindava owai. Wo daipotava yemba kandaspolm omni, wo yena kolvrelmomba heinda doa wohphoi, temba yimba kamba isholm venavnamba. Es hevpa yimba wulluhvma moamba, kamba kolvrevma? ");
INSERT INTO wrs_vpl VALUES ("GN27_37","002_27_37","GEN","27","37","37","Doa aral omnana owai, moamba kanamba doa kava Yakopm indthoai, osm yena kuwulalm lohvav si. Owalva indkumbiva si hena anglasingi lovahmanavav. Kana moamba doa kava ishowol vei, osonna eva wainpol mindnam heindava nalohmanavav, kava eva es yemba kolvrevav, owai. ");
INSERT INTO wrs_vpl VALUES ("GN27_38","002_27_38","GEN","27","38","38","Doa yiveltowondva nihnapehna ovna, wivevna, ara, kamoa eva awothota. ");
INSERT INTO wrs_vpl VALUES ("GN27_39","002_27_39","GEN","27","39","39","Doa aral omnana, pomba yena osorava si veihavavmoa, wo innemba si phovavmoa beswonamba. ");
INSERT INTO wrs_vpl VALUES ("GN27_40","002_27_40","GEN","27","40","40","Yimba daosmomangas ishomana vevra, bunenam velm. Wo yimba si boaslapevna anglasingi lohvav, wo sism si yimba wohgavav, yimba si os nengvav, himba kamba ondal ovrevavmoa. ");
INSERT INTO wrs_vpl VALUES ("GN27_41","002_27_41","GEN","27","41","41","Doa yiveltowondva os mindnam wuspromnavna boaslalmba, manara aralva doa kolvrelmomba ishomni boaslalm, hemba owai. Doa himba os nengna, aramba si lelnam kanamba dahavav, wo nonamta si kava kavna boaslalmba helvakomandhavav. ");
INSERT INTO wrs_vpl VALUES ("GN27_42","002_27_42","GEN","27","42","42","Doa avalva hellenamba, ona, Yakop prora, doa pronamba, aval omnana, etepevpa yemba helvakomandhalm vev, manara, yimba doa arapevm kandaspolm omnana, wo yiveltowondna kolvrelmomba yeinda wohphona. ");
INSERT INTO wrs_vpl VALUES ("GN27_43","002_27_43","GEN","27","43","43","Doa beswonam hello, lelnam hona kembelmoa wuleiho, nnopovindam Lapanindam gao Harandam. ");
INSERT INTO wrs_vpl VALUES ("GN27_44","002_27_44","GEN","27","44","44","Wo di dawonam avhoao, etepevna nonam und lohvhoapihamnavra. ");
INSERT INTO wrs_vpl VALUES ("GN27_45","002_27_45","GEN","27","45","45","Si yena indkoklamba maivethavav, wo nonamba kava mongom indhanarinim wolaihapravav, yem waiprolm hom. Si homeis Esauim yeim hoai vewolvm mongawakombanam. Memba osra, si homeis Esau yemba helvakomandhavm, wo mongo indhanarini hemba helvakomandhavav. ");
INSERT INTO wrs_vpl VALUES ("GN27_46","002_27_46","GEN","27","46","46","Doa Repekava Isakm tlalm omnana, kamba gimus venav Esauna ungund ongorini samblara. Hitnindongorini himba ahav, wo Yakopva snamba vratava, osva kamba si wuspromana vevav, verava daha. ");
INSERT INTO wrs_vpl VALUES ("GN28_1","002_28_1","GEN","28","1","1","Doa Isak ona, Yakop prora, pronamba, aral omnana, lehra yimba proi, beswonam hello, manam yimba ungundongorinimba huiva vravav Kenan petharava. ");
INSERT INTO wrs_vpl VALUES ("GN28_2","002_28_2","GEN","28","2","2","Owai, yeoa os veo, gao eindpevindam Betuelindam Mesopotamia petharam. Wo nnopovna molm vrao di, mongom Lapanna molm. ");
INSERT INTO wrs_vpl VALUES ("GN28_3","002_28_3","GEN","28","3","3","Wo Sesoa mendekli yem kolvrowol vera, yem ongapevm, wo otolva eva yenamba si mindnam avav. Wo sewonamba indhanamba mindnam si os yemba ningthivra, simbel kanamba luhunna Yakopva. ");
INSERT INTO wrs_vpl VALUES ("GN28_4","002_28_4","GEN","28","4","4","Sesoa ten keknamangas lohvm, heoa os yemoa beswonam vewol vera, ten nemet Apraham venavnam, wo si yimba hona pethamba vaohothovav, memba yimba lohmana vevpa, Sesoava nemetva Aprahamba indthoamnanamba, omnana, si yetindiva honam vaohuthuivav. ");
INSERT INTO wrs_vpl VALUES ("GN28_5","002_28_5","GEN","28","5","5","Wo osoa aral kalelmba wolaihangana nnolindam Mesopotamia petharam oklam. Nnolva nomba Lapan Betuelna ombol. Betuelva nomba Aramnindrini lohna. ");
INSERT INTO wrs_vpl VALUES ("GN28_6","002_28_6","GEN","28","6","6","Doa Esauva hellenamba os, aramba doa kalelm kolvrelmonamba awothona, wolaihanga nnolindam oklapetharam. Omnana, manam yimba Kenanongorinimba huiva vravav, owai, di vrao nnopovina. ");
INSERT INTO wrs_vpl VALUES ("GN28_7","002_28_7","GEN","28","7","7","Esauva eva hellenamba, boaslava doa oklapetharam gana aralavalna moara. ");
INSERT INTO wrs_vpl VALUES ("GN28_8","002_28_8","GEN","28","8","8","Doa os himba nengna, kana aramba ovov hona ungundongomba. ");
INSERT INTO wrs_vpl VALUES ("GN28_9","002_28_9","GEN","28","9","9","Wo noinda himba Ismaelindam ganamba, di vrana hena molm nihilva Mahalat. Mahalatva nomba Nepaiotna etel, Ismaelva nomba Aprahamna ombol. Seilva Esauva ungundongorini samblam dambtna. ");
INSERT INTO wrs_vpl VALUES ("GN28_10","002_28_10","GEN","28","10","10","Doa Yakop aralnamini Bersepa kembellini venamba, nnolindam gana Harandam. ");
INSERT INTO wrs_vpl VALUES ("GN28_11","002_28_11","GEN","28","11","11","Doa okombava helgang vovhoavna, monara avhoa. Sinim ona lithana, wo kuva holothona honsra sena. ");
INSERT INTO wrs_vpl VALUES ("GN28_12","002_28_12","GEN","28","12","12","Doa inungpunung vevna, os nonglana, yimundva kuethalohvongov, pethara veiva, sena Sesoainda. Wo Sesoana ovsongolnindva nosra ahalapiha vevna. ");
INSERT INTO wrs_vpl VALUES ("GN28_13","002_28_13","GEN","28","13","13","Yawem eva nonglana, di murapeta lohvna. Doa he omnana, kava Yawe, kava Sesoa lohv, ten arapevi eindpevi sembayang evelohmanavnam. Yimba memba livpa hona petharava, si yemba kava kovorahunvav yem, yetindim. ");
INSERT INTO wrs_vpl VALUES ("GN28_14","002_28_14","GEN","28","14","14","Wo yetindiva si os mindnam avav, oi somovtov. Wo hena pethava mindnam si os luhuku vinvav, nohalm nohalm nohalm. Wo yimba kananapopol indkolam monglam beswonam vewol vivav, hindtindim hindtindim. ");
INSERT INTO wrs_vpl VALUES ("GN28_15","002_28_15","GEN","28","15","15","Manam yimba maivethavav, yimba nosharava gavrava, kava yemongo engavav, eva kekalvho vremnavav, wo yemba kava henga si waiprovav hona petharam. Wo yemba kava nombolvhoavavmoa, verava, kava si yemba wohvenavav, os men kav oim. ");
INSERT INTO wrs_vpl VALUES ("GN28_16","002_28_16","GEN","28","16","16","Doa Yakopva nov vawovna, ona tanam Yaweva hona pethara av, nemetva kava titnam ana. ");
INSERT INTO wrs_vpl VALUES ("GN28_17","002_28_17","GEN","28","17","17","Doa pem vevna, henga ona, kava pem vev hona petharava, memba Sesoana deuvpa lohv, honamba yimundva Sesoainda kuethalohvongov. ");
INSERT INTO wrs_vpl VALUES ("GN28_18","002_28_18","GEN","28","18","18","Doa sieunumbulnam phonamba, wo honmba nomba kutumriniva indund vilindthoana, osm si maivethavavmoa, memba kava nonglaiva mana vemamba inungpunungrava. Doa himba olivpol no honsra sovhona, ona, memba honmba Sesoam wohlohmanav. Doa hev nomba pethava os sevrana Betel, osm ovna Sesoana deuvpa. ");
INSERT INTO wrs_vpl VALUES ("GN28_19","002_28_19","GEN","28","19","19","Nemetva hona petharava kembelva dihelna, Lus kembel os uvna. ");
INSERT INTO wrs_vpl VALUES ("GN28_20","002_28_20","GEN","28","20","20","Doa Yakopva Yawemba os osahmanavna, yeoa kamoa beswonam waingavm kavna nnoinam, wo kam dembraohvm inne eva kayen, ");
INSERT INTO wrs_vpl VALUES ("GN28_21","002_28_21","GEN","28","21","21","wo kam henga kavna araindam beswonam waingavm. Yimba osva vevrava, yemba kava wohlohmanavav, ");
INSERT INTO wrs_vpl VALUES ("GN28_22","002_28_22","GEN","28","22","22","wo hona honda si kava yemba sembayang velohmanavav, wo mana vemamba yimba kamba dembrahovrava, wo yemba kava eunumbulva henga dembrahovra. ");
INSERT INTO wrs_vpl VALUES ("GN29_1","002_29_1","GEN","29","1","1","Doa Yakopva mendah monam gavna, dom ten okomba pholohvm. ");
INSERT INTO wrs_vpl VALUES ("GN29_2","002_29_2","GEN","29","2","2","Doa lelnam nonglaphona tovalpm, ten sahalla hovra lohvnam, wo sipsipva samblamong di murapeta pulundvund vevna. Doa mendekli hon ehlathalohvna nomba tovalpmba. ");
INSERT INTO wrs_vpl VALUES ("GN29_3","002_29_3","GEN","29","3","3","Wo sipsipva di kusovna, ata andranind honmba nomba vileivrivav, pom dahwolalm, doa henga ata ehlathivav. ");
INSERT INTO wrs_vpl VALUES ("GN29_4","002_29_4","GEN","29","4","4","Doa Yakopva phonamba, andranindm unna, seh andini yimba? Umnina, kava Haran kembelnind. ");
INSERT INTO wrs_vpl VALUES ("GN29_5","002_29_5","GEN","29","5","5","Unna, yimba nonora amnavma Lapanmba, temba Nahorna umbeindilva lohvpa? Umnina, eie kava nonora amnavta! ");
INSERT INTO wrs_vpl VALUES ("GN29_6","002_29_6","GEN","29","6","6","Hev unna, beswonam avma?, umnina, beswonam! Nonglo, molva men promnav Reselva, aralna sipsipm wonprov. ");
INSERT INTO wrs_vpl VALUES ("GN29_7","002_29_7","GEN","29","7","7","Doa hev unna, yeoa honoa vileivrivm, wo pevna sipsipm po dahwol vivm, manara, okombava mendah hovrahovra lohv, mani sinimma, oi ata yimba wonangavavmoa deuvramba. Owai, boasna po dahwol vivrava, os henga posmusram wonangav, posm hlalm. ");
INSERT INTO wrs_vpl VALUES ("GN29_8","002_29_8","GEN","29","8","8","Wo he umnina owai, mendah sipsipva kusovmoa indakondava, ata heva os kava honmba vileivrivav. ");
INSERT INTO wrs_vpl VALUES ("GN29_9","002_29_9","GEN","29","9","9","Doa Yakopva mendah ishunvna, Reselva sipsipm wonpho, doara wonprolohvna. ");
INSERT INTO wrs_vpl VALUES ("GN29_10","002_29_10","GEN","29","10","10","Doa Yakopva Reselmba nonglanamba, nnolna sipsipnahonam, hev ganamba, hevho honmba nomba velavranamba, doa po nomini longwol venamba, os sipsipm dahwol vena, nnolna sipsipmba. ");
INSERT INTO wrs_vpl VALUES ("GN29_11","002_29_11","GEN","29","11","11","Doa hev Reselmba sendara otho, wi vevna, manara, indk vethavna, ");
INSERT INTO wrs_vpl VALUES ("GN29_12","002_29_12","GEN","29","12","12","ona, kava yena owal, kava Repekana ombol. Doa himba lelnam deuvram ganamba, aralm ishomna. ");
INSERT INTO wrs_vpl VALUES ("GN29_13","002_29_13","GEN","29","13","13","Doa aralva hellenamba, lelnam ganamba, Yakopm ombtambalm kevranamba, sendara otho. Omnana, deuvram engavai kavindam. Doa Yakopva nnolm moa wohishomnanamba, himba omnana, lehra, ");
INSERT INTO wrs_vpl VALUES ("GN29_14","002_29_14","GEN","29","14","14","tanamolnam yimba kana ombtambalnonoa lohv. Doa Yakopva di dawonam alohvna, weisva mongasal khuamnana. ");
INSERT INTO wrs_vpl VALUES ("GN29_15","002_29_15","GEN","29","15","15","Doa Lapanmba ombtambalm Yakopm os ishomnana, pioa ahai, yeoa kana andra vevm, yemba kava si di dembraohvav. Honamba osva lohvmoa, yimba kanamba andrava ombamora vevra. Yemba es hevpa kava dembraohvav? ");
INSERT INTO wrs_vpl VALUES ("GN29_16","002_29_16","GEN","29","16","18","Doa ombtambal omnana, pimba andra avaharava, verava, 7pelara tahonmba everava, kamoa os pelaho pevna mopovmoa Reselmoa. Noinda ona, Reselmba Yakopva und vevna, besal hevm. Mongova molva ana, nihilva Lea, wo himba novpa besal hevm, heva os Reselva lehrangas avna. ");
INSERT INTO wrs_vpl VALUES ("GN29_19","002_29_19","GEN","29","19","19","Doa nnol omnana, lehra, indhanarinimba kava pelahovavmoa, yemangas kava pelahovav. ");
INSERT INTO wrs_vpl VALUES ("GN29_20","002_29_20","GEN","29","20","20","Doa nnol ombolva andra avahanamba, tahonmba 7pelara evena. Yakopva Reselmba mindnam nengmanavna, himba nengvnamoa nomba weismba tahonmba, ovna, os kava vungav. ");
INSERT INTO wrs_vpl VALUES ("GN29_21","002_29_21","GEN","29","21","21","Doa ombtambalva nnolm omnana, kava vralm vev Reselmba. ");
INSERT INTO wrs_vpl VALUES ("GN29_22","002_29_22","GEN","29","22","22","Doa nnol omnana, lehra, doa innemba meilna vevna mindnam, wo ishuku vinvna, indkumbi aembuwul veo. Doa os hlana, hlapianamba, ");
INSERT INTO wrs_vpl VALUES ("GN29_23","002_29_23","GEN","29","23","24","sinimba Lapanmba hevna molm os waingana Yakopindam, Reselmba owai, Leam waingana. Doa Yakopva titnam wailinamba, ");
INSERT INTO wrs_vpl VALUES ("GN29_25","002_29_25","GEN","29","25","25","doa simolnam phonamba, nonglana, ona pai memba Lea, Reselva owai. Doa himba nnolindam ga, omnana, manara yimba kamba deswuhi? Kava yemba waiandra venamba, ona, ka Reselmoa vrai, wo yimba kamba deswuhi Leana. ");
INSERT INTO wrs_vpl VALUES ("GN29_26","002_29_26","GEN","29","26","26","Doa nnol omnana, manam yemba kava pelahovav moasalalmba, wo etelva ambo avra, mani kana wevsanama, owai. ");
INSERT INTO wrs_vpl VALUES ("GN29_27","002_29_27","GEN","29","27","27","No mingunam yemba kava pelahovavta Reselmba, wo boasna pimba indk vithivav, innemba hlalmba, manara yimba doa Leamba vrana. Wo yeoa henga kam waiandra vevm mongawulm, verava, 7pelara tahonmba lohvra. ");
INSERT INTO wrs_vpl VALUES ("GN29_28","002_29_28","GEN","29","28","30","Doa Yakopva omnana, lehra, wo innemba nomba manimani hlapianamba, minguva mongasal venamba, wo os nnolva Reselmba pelahona. Doa sinimba Yakopva Reselmba wailinamba, mindnam und vevna, himba Leamba ambo espeta und vevna. Doa Lapanmba hevna andranind unguvlirinim pelahona, andram kolvrelm molm Leam, nihilva Silpa. Wo mongom pelahona, andram kolvrelm molm Reselm, nihilva Bilha. Doa mindnam andra evevna Yakopiva nnoliva, venamba, tahonmba 7pelara evena. ");
INSERT INTO wrs_vpl VALUES ("GN29_31","002_29_31","GEN","29","31","31","Doa Yakopva espetambo nengmanavna Leamba, wo himba mindnam nengmanavna Reselmba. Doa Yaweva os nonglanamba, wo noinda Leamba himba beswonam vrevna, wo Leava ena avna, Reselva ambo phal avna. ");
INSERT INTO wrs_vpl VALUES ("GN29_32","002_29_32","GEN","29","32","32","Doa Leava otolm lenge tuendisrini, os awona Rupenm. Noinda osva awona, Yawe doa kamba wavra vovhoamnana, wo kana tlamba kamba si os beswonam nengmanavav. ");
INSERT INTO wrs_vpl VALUES ("GN29_33","002_29_33","GEN","29","33","33","Doa hev henga ena a, henga otolm lenge tuendisrini, os awona Simeonm. Noinda osva awona, Yawe nonglanamba, tlamba kamba espetava nengmanavna, wo noinda Yawe kamba hona otolva holvorahona. ");
INSERT INTO wrs_vpl VALUES ("GN29_34","002_29_34","GEN","29","34","34","Doa hev henga ena a, otolm lenge tuendisrini, os awona Levim. Noinda osva awona, kava doa tuendismangas samblamongm towand vei, wo noinda kana tlamba kamba si os indnahonam nengmanavav. ");
INSERT INTO wrs_vpl VALUES ("GN29_35","002_29_35","GEN","29","35","35","Doa hev henga ena a, otolm lenge tuendisrini, os awona Yutam. Noinda osva awona, ka Yawem okolav. Doa mongomba otolmba lengnamoa hengava. ");
INSERT INTO wrs_vpl VALUES ("GN30_1","002_30_1","GEN","30","1","1","Doa Reselva mendah phal avna, hevna etelm muemb vemnavna. Doa himba tlalm mindnam omnana, kaoa eva otolm waiaita. Owaingava osva kamba dahavav. ");
INSERT INTO wrs_vpl VALUES ("GN30_2","002_30_2","GEN","30","2","2","Doa tlalva koasve, omnana, mani kava Sesoama, oi ata kava yemba kolvrevav, owai, Sesoa hev yena emba kevrana, wo noinda yimba phalva av. ");
INSERT INTO wrs_vpl VALUES ("GN30_3","002_30_3","GEN","30","3","3","Doa ongal omnana, men Bilhava av, kana andraunguvlirini, yeoa hemoa wailiu, wo otolmba himba sleiharava, wo ora, kana otol. ");
INSERT INTO wrs_vpl VALUES ("GN30_4","002_30_4","GEN","30","4","4","Doa osangas venata, ");
INSERT INTO wrs_vpl VALUES ("GN30_5","002_30_5","GEN","30","5","5","doa Bilhava ena avna, otolm lengna tuendisrini, doa Reselva awona Danm. ");
INSERT INTO wrs_vpl VALUES ("GN30_6","002_30_6","GEN","30","6","6","Noinda osva awona, Sesoava doa kanamba sah omomba hellenamba, kamba beswonam vevravna, wo ombol polamna. ");
INSERT INTO wrs_vpl VALUES ("GN30_7","002_30_7","GEN","30","7","7","Doa henga Bilhava ena a, otolm lenge tuendisrini Yakopinda. ");
INSERT INTO wrs_vpl VALUES ("GN30_8","002_30_8","GEN","30","8","8","Doa Reselva ombolm awona Naptalim, nonawisra osva awona, kava doa kuvhoai kavna etemba. ");
INSERT INTO wrs_vpl VALUES ("GN30_9","002_30_9","GEN","30","9","9","Doa Leava nengna, otolva kava hengava lengvavmoa, wo noinda tlalm omnana, wo he hena andraunguvlirinim Silpam wailina. ");
INSERT INTO wrs_vpl VALUES ("GN30_10","002_30_10","GEN","30","10","10","Doa Silpava ena avna, otolm lengna tuendisrini Yakopinda. ");
INSERT INTO wrs_vpl VALUES ("GN30_11","002_30_11","GEN","30","11","11","Doa Leava os awona Gatm, noinda osva awona, kakowa lehra vei. ");
INSERT INTO wrs_vpl VALUES ("GN30_12","002_30_12","GEN","30","12","12","Doa henga Silpava ena a, otolm lenge tuendisrini Yakopinda, ");
INSERT INTO wrs_vpl VALUES ("GN30_13","002_30_13","GEN","30","13","13","doa Leava os awona Aserm. Noinda osva awona, kava indk vethav, ungevliva kamba nunglirava, wo uvav, indk vethav. ");
INSERT INTO wrs_vpl VALUES ("GN30_14","002_30_14","GEN","30","14","14","Doa sisva Rupenmba yiveltowondva osoram ganamba, nonamba indhanamba witva hilemohla vivna, doa sauwa vranamba, henga avalm Leam vraohe. Doa Reselva nonglana, etelm Leam omnana, kam espeta vraho ombpovna sauwa. ");
INSERT INTO wrs_vpl VALUES ("GN30_15","002_30_15","GEN","30","15","15","Doa etelva moasalalm omnana, owai, yimba pivna tlamba doa mohvena kanaminiva. Wo men yimba osm vevna, kaoa sauwa vrai yena ombnamimi, osva sahokla vev. Doa moasalalva etelm omnana, kam sauwa tovoraho, ata osva yepevmongo ihilvav tlapiviva. Doa etelva omnana, lehra. ");
INSERT INTO wrs_vpl VALUES ("GN30_16","002_30_16","GEN","30","16","16","Doa makokonam tlalva Yakopva osorini pronamba, Leava ganamba, monara di anongla vena, omnana, ata pimba sinimba mongawulm ihilvav, manara, doa kava sowamba tovorahoi aslongomba Reselmba. Doa mongawulm ihilna, ");
INSERT INTO wrs_vpl VALUES ("GN30_17","002_30_17","GEN","30","17","17","doa Sesoava hena sahmomba hellenamba, wo Leava ena avna. Doa otolm lengnamba tuendisrini, ");
INSERT INTO wrs_vpl VALUES ("GN30_18","002_30_18","GEN","30","18","18","os awona Isakarm. Noinda osva awona, kava seilva phal avna, wo kava ovomnanamoa kavna tlamba, manam yimba wailivav kana andranind unguvlirinimba. Owai, kava ophona, wo noinda Sesoa kamba beswonam esesm venai, kavna ombolva doa polai. ");
INSERT INTO wrs_vpl VALUES ("GN30_19","002_30_19","GEN","30","19","19","Doa henga Leava ena a, otolm lenge tuendisrini, ");
INSERT INTO wrs_vpl VALUES ("GN30_20","002_30_20","GEN","30","20","20","os awona Sepulunm. Noinda osva awona, Sesoa kamba mana vema besal holvorahoi, wo kavna tlamba ata kamba indk vethamanavav, daipotava doa kanamba ombolva os phoi, 6pelara. ");
INSERT INTO wrs_vpl VALUES ("GN30_21","002_30_21","GEN","30","21","21","Doa sisva himba henga otolm lengna mutundisrini, os awona Dinam. ");
INSERT INTO wrs_vpl VALUES ("GN30_22","002_30_22","GEN","30","22","22","Doa Sesoava maivethanamoa Reselmba, owai, hena sah omomba hellenamba, emba sishona vremna. ");
INSERT INTO wrs_vpl VALUES ("GN30_23","002_30_23","GEN","30","23","23","Wo he ena a, otolm lenge tuendisrini, ");
INSERT INTO wrs_vpl VALUES ("GN30_24","002_30_24","GEN","30","24","24","os awona Yosepm. Noinda osva awona, Sesoava kanamba loumomba doa posvena, kana ombol polai. Wo heoa henga mongo kamoa holvorahora. ");
INSERT INTO wrs_vpl VALUES ("GN30_25","002_30_25","GEN","30","25","25","Doa Yakopna kalel polana Yosep, wo sisva aral Lapanm hevna meralm omnana, kava doa huhul vev kavna ungevlitundismba, wo yemba kava dasvholaha angalm vev kavna kembellam. ");
INSERT INTO wrs_vpl VALUES ("GN30_26","002_30_26","GEN","30","26","26","Ungevlitundisva huiva yeindava kava tetwond venamba. Kava yenamba andrava beswonamangas vena. ");
INSERT INTO wrs_vpl VALUES ("GN30_27","002_30_27","GEN","30","27","27","Doa meralva omnana, doa kava novngingssowara nonglana, Yaweva kamba doa beswonam lehra vrena yeindava, ");
INSERT INTO wrs_vpl VALUES ("GN30_28","002_30_28","GEN","30","28","28","wo yeoa kai ahao, es hevpa yemba kava dembraohvav? ");
INSERT INTO wrs_vpl VALUES ("GN30_29","002_30_29","GEN","30","29","29","Doa hev omnana, doa yimba nonglana, kava doa yenamba andrava beswonamangas vena. ");
INSERT INTO wrs_vpl VALUES ("GN30_30","002_30_30","GEN","30","30","30","Yenamba seilva mana vemamba espeta ambo lohvna, wo Yaweva yemba dembrahovna mana vemamba mindnam kana englarini. Wo noinda yenamba mana vemamba mindkombaiwonam lohv. Daipotava kava kavna andram velm nengv. ");
INSERT INTO wrs_vpl VALUES ("GN30_31","002_30_31","GEN","30","31","32","Doa hevna meral omnana, es hevpa yemba kava dembraohvav, wo yimba kai wohahavav? Doa hev omnana, kava nengvmoa osva dim, kamoa yeoa sipsip holvorombraho nis. Yimba osva otava, wouta, osva kava yena sipsipm memem dahwol vevav. Nemetva kava os vevna, veiva daipota men. Wo boasna kava yena sipsipm memem lesvhoawol vevav, wo sipsip otolm suihalangas kava kavmba holvowol vevav. Eva meme otolm dendakondalangas. Wo mongnahalva indanam kava si kavm holvowol vevav, dahwolalm. Memba osm dielm. ");
INSERT INTO wrs_vpl VALUES ("GN30_33","002_30_33","GEN","30","33","33","Wo sismba yimba kanamba naengho vewol vevrava, ora ka yenamba yukov vena, wo yimba osva diva nonglatava, ora sipsipva suihalva owai, ora memeva dendakondalva owai, wo osva si yimba nengvav, ora Yakopva kanamba yukov vena. ");
INSERT INTO wrs_vpl VALUES ("GN30_34","002_30_34","GEN","30","34","34","Doa meralva omnana, lehra yimba ov, pimba osangas evevav. ");
INSERT INTO wrs_vpl VALUES ("GN30_35","002_30_35","GEN","30","35","35","Heva os hev poaita ganamba men honanamba, wo sipsipm memem hevnam momo ve. Venamba, meme aralavalm dendakondalva, meme avalm tutuwulva, honamangas holvowol vena, eva sipsipm suihalm. ");
INSERT INTO wrs_vpl VALUES ("GN30_36","002_30_36","GEN","30","36","36","Doa hevna ombolm himba unna, pioa wonangai hona sipsipm memem dom nohalm Yakopnamini, wo he os aralmongo wonanga. Doa wonanganamba Yakopnaminiva, simba sambla vewulnamba, doa di wuleina. Doa sismba Yakopva meralna sipsipm memem monglam dahwol vevna, os ten nemet hev ihishonam. ");
INSERT INTO wrs_vpl VALUES ("GN30_37","002_30_37","GEN","30","37","37","Doa Yakopva meralna memem mindnam dahwol vevna, doara hevm meralva poaita holvowol venamba dendakondalmba. Doa himba tikla helvarombol venamba, tovol espeta vindvhoanga venamba, oi dendakondal. ");
INSERT INTO wrs_vpl VALUES ("GN30_38","002_30_38","GEN","30","38","38","Doa di dembra, ten he po dahwol velohvnam memem. Noinda vena, memeva di kusolohvna, tlal angola vewol vinvna. Ona, heoa honam tiklam nunglivrava, wo si otolmba towand vivav dendakondalm, kanamba. ");
INSERT INTO wrs_vpl VALUES ("GN30_39","002_30_39","GEN","30","39","39","Doa osoa vivna, wo otolmba towand vivna dendakondalmba. ");
INSERT INTO wrs_vpl VALUES ("GN30_40","002_30_40","GEN","30","40","40","Doa Yakopva sipsipmba mongnahalm indanam dahwol venamba, memeva indanam. Wo osva sipsipva Yakopnamba mindnam phona, wo himba indanam dahwol vevna hevnamba, wo Lapanna meralna himba indanam dahwol vevna. ");
INSERT INTO wrs_vpl VALUES ("GN30_41","002_30_41","GEN","30","41","41","Wo nonamba sipsipva memeva nomba keknamangasva himba angola vewol vivnamba, nonamba Yakopva tiklava di dembhaka vevna, di ten po hlalvohvnam. Ona, heoa honam tiklam nunglivrava, os angola vewol vinvra. ");
INSERT INTO wrs_vpl VALUES ("GN30_42","002_30_42","GEN","30","42","42","Wo nonamba sipsipva, memeva nomba oielva angola vewol vivnamba, owai, nonamba himba tiklava dembhaka venamoa. Wo noinda sisva Lapanna sipsipva memeva oielva lovahvna, wo Yakopna keknamangas lovahvna. ");
INSERT INTO wrs_vpl VALUES ("GN30_43","002_30_43","GEN","30","43","43","Wo honinda Yakopva ditowondva lohvna, henamba sipsipva memeva mindnam lovahmanavna, andranindva mindnam, kamelva mindnam, donkiva mindnam lovahmanavna. ");
INSERT INTO wrs_vpl VALUES ("GN31_1","002_31_1","GEN","31","1","1","Doa Yakopva os hellena, Lapanna ombolva os uvna, Yakopva mana vemamba pina arana doa dambna, Yakopva ditowondva noinda lohv, arana kolmal iav. ");
INSERT INTO wrs_vpl VALUES ("GN31_2","002_31_2","GEN","31","2","2","Doa himba nengna, meramba beswonamba kamba ishomnavnamoa. ");
INSERT INTO wrs_vpl VALUES ("GN31_3","002_31_3","GEN","31","3","3","Doa Yawe hemba ishomnana, honaoa kembelmoa wuleiho, arapevindam gao, kava yei ahavav. ");
INSERT INTO wrs_vpl VALUES ("GN31_4","002_31_4","GEN","31","4","4","Doa himba ongal samblam Leaim Reselim moa pinginnamba, unna eprara, yem kava isholm vinv, men hui kava sipsipm dahwol vawov indhanahuira. ");
INSERT INTO wrs_vpl VALUES ("GN31_5","002_31_5","GEN","31","5","5","Doa epramnanamba, hev unna, doa kava nonora lohv, arapevpa yenamba kamba beswonamba ishomnavnamoa, osva seilva temba. Heva os manapenam, Sesoangas mendah kam waiav, ten kana ara sembayang vaomana venanam. ");
INSERT INTO wrs_vpl VALUES ("GN31_6","002_31_6","GEN","31","6","6","Yimba nonora ahav, kava beswonamangas waiandra vena arapevmba, kava andrava esvema venana, kava pemba venamoa andranapenamba, owai. ");
INSERT INTO wrs_vpl VALUES ("GN31_7","002_31_7","GEN","31","7","7","Heva os himba kamba beswonamba vevravnamoa, himba kamba daspolm olohmanavna, dimba dembraholmba. Himba kamba ona deswuhana, heva os owai, Sesoa kamba kolvrevna. ");
INSERT INTO wrs_vpl VALUES ("GN31_8","002_31_8","GEN","31","8","8","Wo noinda Lapanmba kamba os ishomnana, memeva dendakondalva mindnamba photava, temba yemangas dielm, wo noinda memeva mindnamba phonata, dendakondalangas. Wo sisva himba kamba indanam os ishomnana, memeva tutuwulva photava, temba yemangas dielm, wo noinda memeva mindnamba phonata, tutuwulangas. ");
INSERT INTO wrs_vpl VALUES ("GN31_9","002_31_9","GEN","31","9","9","Sesoa hev honamba vena, maim oi, arapevna englarini holvowol veiva, wo kana englisra holvohla ve. ");
INSERT INTO wrs_vpl VALUES ("GN31_10","002_31_10","GEN","31","10","10","Doa kana yeoa inungpunungmom ehello. Ten seilm weis khuanam, meme aralva angolasongola vivna, wo kava inungpunung vevna, nonglana, meme tlalva angolasongola viv, dendakondal, tutuwul, noiangas angolasongola viv, monglava owai. ");
INSERT INTO wrs_vpl VALUES ("GN31_11","002_31_11","GEN","31","11","11","Doa Sesoana ovsongolnindrini phonamba, kam omnana inungpunungna, Yakop. Wo ka omnana, eie, ");
INSERT INTO wrs_vpl VALUES ("GN31_12","002_31_12","GEN","31","12","12","wo he ona nonglo, meme tlalva angolasongola viv, heva os dendakondal, tutuwul, noiangas angolasongola vev, monglava owai. Honamba kava osva verava, yenamba memeva si mindnam phovav. Manara, doa kava os nonglana, merapevpa yemba sahoklapeta vrevna. ");
INSERT INTO wrs_vpl VALUES ("GN31_13","002_31_13","GEN","31","13","13","Kava Sesoangas lohv, nemet kava yemba nonglaphona Betella, di yimba kamba hon kutumrini vilindthoamnana, olivpol sovhomnana, tanamolmoa ishomnana. Doa yeoa meilna vevm, os arapevindam gao, dom ten avapev yem lengnam. ");
INSERT INTO wrs_vpl VALUES ("GN31_14","002_31_14","GEN","31","14","14","Doa Reseli Leai ehellenamba, ohomnana, lehra yimba ov, kana aralva himba owai, mana emamba kamba vrahunvmoa. ");
INSERT INTO wrs_vpl VALUES ("GN31_15","002_31_15","GEN","31","15","15","Kamba os nongallohv, oi ambalnindrini sambla, mosamblava owai. Himba esvema dombolohv yena englariniva, noinda yimba kamba doa dombtna ongalalm. Wo diva nomba himba iavmoa, doara doa nepiana. ");
INSERT INTO wrs_vpl VALUES ("GN31_16","002_31_16","GEN","31","16","16","Memba honamba mana vemamba doa Sesoa vrana arana englamohrini, yena englisra hohlonamba, memba pina daipotava eva pina ombolna. Pioa Sesoana nengavnangra velvohra, wo arapevindam angai deuvram. ");
INSERT INTO wrs_vpl VALUES ("GN31_17","002_31_17","GEN","31","17","17","Doa Yakopva meilna venamba, ungevlitundism sandhanamba kamelsra, wo himba sis gavna, ");
INSERT INTO wrs_vpl VALUES ("GN31_18","002_31_18","GEN","31","18","18","memem sipsipm engilguavna wohnahonam. Nomba mana vemamba himba doara dombna di Mesopotamia pethara. Wo himba os wonganamba, lelnam angavna, meralm deiswuhalaha angavna, himba tit vevna. ");
INSERT INTO wrs_vpl VALUES ("GN31_19","002_31_19","GEN","31","19","19","Manara, himba doara oklam ganamba, sipsipna talm kovhoawolalm. Wo molva Reselva henisra pohkini tihriniva yukovna dombna, os wonga. ");
INSERT INTO wrs_vpl VALUES ("GN31_20","002_31_20","GEN","31","20","21","Doa himba meralm deiswuhalaha anganamba, lelnam wohnahonam angavna, doa pom Yupretism lovol vevna, Gileat pethamonam angavna, aralindam angavna Kenan petharam. ");
INSERT INTO wrs_vpl VALUES ("GN31_22","002_31_22","GEN","31","22","22","Doa simba samblamong vevnamba, wo nonamba Lapanmba hellena osva, doa Yakoptatanamba wohangana. ");
INSERT INTO wrs_vpl VALUES ("GN31_23","002_31_23","GEN","31","23","23","Doa hev hevna owalm wunuhunna, pioa Yakopm sis engvulangai. Doa anganamba, simba 7pelara vinamba, doa os nonglapulvona diva Gileat petharava, di ten Yakoptatana doara lailduvpa vewol vinam olora. Wo noinda Lapanmba hevna lailduvpa vewol vena diva. ");
INSERT INTO wrs_vpl VALUES ("GN31_24","002_31_24","GEN","31","24","24","Doa sinim Lapanmba inungpunung vevna, Sesoa hemba phomnanamba, omnana, manam yimba tuhvav puwepevmba, manam dandwonamba ishomnavav. ");
INSERT INTO wrs_vpl VALUES ("GN31_25","002_31_25","GEN","31","25","26","Doa mongnasiva Lapanmba puwelmba ishomnavna, es hevpa yimba kamba poaitava dasvholaha wonprona? Yimba kana mosamblam sowotna, oi daosnamona pelvrombt ve. ");
INSERT INTO wrs_vpl VALUES ("GN31_27","002_31_27","GEN","31","27","27","Yimba kamba ishomnanamoa, yimba ambo pev poaita wonprovna. Nemetva yimba kamba osahmanatava, doara kava tihva lohta, doara yemba wolanga veta sangalnahonam, wowonapetam. ");
INSERT INTO wrs_vpl VALUES ("GN31_28","002_31_28","GEN","31","28","28","Yimba sahonam ambo nengvna, wo lelnam poaita ambvna, wo noinda kava hellenamoa, englava kakaiv vinnamoa kavna mosamblanamba, eva umbeindinamba owai. ");
INSERT INTO wrs_vpl VALUES ("GN31_29","002_31_29","GEN","31","29","29","Yemba kava helvevav, heva os owai, sinim Sesoa kamba phomni inungpunungra, omni, manam yimba tuhvav puwepevmba, owai. Nomba Sesoamba temba arapevpa yenamba sembayang venavnamba. ");
INSERT INTO wrs_vpl VALUES ("GN31_30","002_31_30","GEN","31","30","30","Doa kava nonora lohv, yimba lelnam galm vev henga arapevindam, heva os memba mani besalma, yimba kanamba pohkiniva yukovna wulprona. ");
INSERT INTO wrs_vpl VALUES ("GN31_31","002_31_31","GEN","31","31","31","Doa Yakopva omnana, nemetva kava pem vevna, osva yimba kamba ovomnatava, kana mosamblamba manam yimba wohwongavav. Wo noinda kava poaita yem dasvholaha ambvna. Doa pohkiniva yenamba kava tit vev, kava nongalnamoa. ");
INSERT INTO wrs_vpl VALUES ("GN31_32","002_31_32","GEN","31","32","32","Osva yimba nonglatava, mongo karinim pohkinimba ilohtava, osva kava miklevav. Wou, nungsis veo, yimba nonglatava, osoa vrao, pivna andranind men nungeilv, ata nunglutithueivav. Yakopva noinda osva ona, himba tit vena, ongalva pohkiniva doara poaita yukovna dombna. ");
INSERT INTO wrs_vpl VALUES ("GN31_33","002_31_33","GEN","31","33","33","Doa Lapanmba boasna Yakopna lailduvram ganamba, di siha, nungsis ve, ona, owai huiva. Doa Leainda molinda lailduvra sihamna, nungsis ve, ona, owai. Doa andranind unguvlirini samblainda siheine, ona, owai huiva. ");
INSERT INTO wrs_vpl VALUES ("GN31_34","002_31_34","GEN","31","34","34","Doa Reselinda molinda lailduvra sihamnanamba, wo Reselva doara pohkiniva wondara nungna hevina, wondamba nomba mendekli kamelwonda. Doa nungnamba, di nosra avhoana. Doa aralva sihamnanamba, ona nungsis vena, ");
INSERT INTO wrs_vpl VALUES ("GN31_35","002_31_35","GEN","31","35","35","wo mol omnana, ara, lehra yimba vev. Heva os kamba doa weis helvei, kava ata phovavmoa, gekala omnavna. Doa aralva nungsis vepianamba, himba pohkinimba nongalnamoa. ");
INSERT INTO wrs_vpl VALUES ("GN31_36","002_31_36","GEN","31","36","36","Doa Yakopva meralmba dandwonam ishomnavna, kava sahonamba venamoa, wo yunam mani beswonamma, yimba kamba engvuwulprovna, oi yukovnindrinimsnamba, owainonoa. ");
INSERT INTO wrs_vpl VALUES ("GN31_37","002_31_37","GEN","31","37","37","Yimba dihi nonglai mana vemamba lohv kaindava, temba heva yena deuvrini, owainonoa. Kava mana vemamba yenamba wulatava, osva yimba amballa velahavav, wo indkumbiva nunglutithueivra, osva uvra, ka sahonamba vevnata. ");
INSERT INTO wrs_vpl VALUES ("GN31_38","002_31_38","GEN","31","38","38","Yeiva kava ahana, tahonmba venamba 20pelara, wo kava beswonam yenamba dahwol vawona sipsipm memem, venamba, beswonam tetwond vina. Etelmba mongova kava winenamoa sipsipmba aralmba owai. ");
INSERT INTO wrs_vpl VALUES ("GN31_39","002_31_39","GEN","31","39","39","Wo nonamba sungeitwinde helvawol vevna monglamba yenamba sipsipmba, kava kavna holvoranamba, yem esesm holvoraohe, mindilva kava yemba vindilpromnanamoa, yem ishomnanamoa os, memba sungeitwinde helvena, kava owai. Wo mongova yukovindhanamba vreivnamba sinim okombanam, yimba kam omnavna, yeoa kamoa hevesm holvoraho pevnaoa. ");
INSERT INTO wrs_vpl VALUES ("GN31_40","002_31_40","GEN","31","40","40","Elsus okombava kamba dawola owolohvna, wo elsus kamba sihovranamba nelpong velohmanavna, kava beswonamba lilohvnamoa. ");
INSERT INTO wrs_vpl VALUES ("GN31_41","002_31_41","GEN","31","41","41","Honamba andrava kava os vena, tahonmba venamba, 20pelara lohvna. Plalva os lohv, tahonmba 14 pelara vevnamba, wo yei kava andra evevna, venamba, yenamba mopov samblava kava os dombtna. Wo henga sisva tahonmba 6 pelara vevnamba, yei kava andra evevna, venamba, kava osva yena sipsipm memem dahwol vevna. Yimba elsus kamba daspolm olohmanavna, dimba dembraholmba. Yimba pevmangas nengvna, mindnamba mana vemamba ialmba, kamba owai, wo yimba kamba wolaihangalm vevna posal kavna aralindamba. ");
INSERT INTO wrs_vpl VALUES ("GN31_42","002_31_42","GEN","31","42","42","Heva os Sesoava kam kolvrevna. Noinda vena, himba nonglana yem, ten pev kam indkokla vrenam. Wo eva himba nom nonglana, ten ka andra venam. Doa nonglanamba, wo sinim yemba ishomnana, manam tuhvav puwepevmba. Nomba Sesoamba temba kana eindiva araiva sembayang evelohmanavnamba. ");
INSERT INTO wrs_vpl VALUES ("GN31_43","002_31_43","GEN","31","43","43","Doa Lapanmba puwelm ishomnana os, memba ungevlirini samblava kana, wo otomotalva kanata, wo meme sipsip memba kana. Manimani memba kanangas lohv. Heva os kava sandhavavmoa huiva ungevlirini samblamba otomotalmba, owai. ");
INSERT INTO wrs_vpl VALUES ("GN31_44","002_31_44","GEN","31","44","44","Boasna pioa tanamolmoa ihishorava, hon songowol eve, pivnam nengavnangm henga tuhhowolalm, si homeis pimba mai evethavm. ");
INSERT INTO wrs_vpl VALUES ("GN31_45","002_31_45","GEN","31","45","45","Doa puwelva hellenamba, hon indund vilindtho, nengavnangm tuhholm. ");
INSERT INTO wrs_vpl VALUES ("GN31_46","002_31_46","GEN","31","46","46","Doa henga himba hevna towandalm unna, hon dumbu hui songowol viu. Doa vinamba, di murapeta aevulthanamba, doa innemba os hlana. ");
INSERT INTO wrs_vpl VALUES ("GN31_47","002_31_47","GEN","31","47","47","Lapanmba os omnana, memba honmba songollohvpa, osm pina nengavnangm tuhhowolalm. Noinda himba os sevrana hevna moana, Yekar Sahatuta. Doa Yakopva hevna moana os sevrana, Galet. Galetva osm ovna, honmba songollohv, nengavnangm tuhholm. Wo noinda no pethava osva ningthivna Galet. ");
INSERT INTO wrs_vpl VALUES ("GN31_48","002_31_48","GEN","31","48","48","Doa meralva henga omnana, sewonamba pimba si ahawolvav indakonda pethara, Yawengas pimba nongalvra. ");
INSERT INTO wrs_vpl VALUES ("GN31_49","002_31_49","GEN","31","49","49","Wo noinda henga sevravna, memba honmba Mispa, osm ovna, Yawe nongalv. ");
INSERT INTO wrs_vpl VALUES ("GN31_50","002_31_50","GEN","31","50","50","Doa meralva henga puwelm omnana, yimba sahokla verombtava hona ungevlirini samblamba kana molmba, wo yimba ongamba vratava mongomba, kava osva si tit vawovav, Sesoangas heva hev si nonorava avav. ");
INSERT INTO wrs_vpl VALUES ("GN31_51","002_31_51","GEN","31","51","51","Manam yimba maivethavav, memba honmba kava songowol vevpa pi hovrava, eva nomba kava vilindthoaiva, ");
INSERT INTO wrs_vpl VALUES ("GN31_52","002_31_52","GEN","31","52","52","wo sewonamba kava kuvhoavavmoa honamba, yemongova daos uvra, eva manam yimba kuvhueivav honamba, kamongo yimba owalwolalmba vevrava. Doa pimba tanamolmoa ihishoi, wo honamba honmba pina nengavnangm si os tuhhowol vinvra, doa tanamolnam wohihishona. ");
INSERT INTO wrs_vpl VALUES ("GN31_53","002_31_53","GEN","31","53","53","Sesoava pimba si os lesvhoawol vevav, Aprahami Nahori simbelsambla sembayang evelohmanavnam. Doa Yakopva omnana, lehra, tanamolnam kava yemba ishomnav, Sesoana novra kava ishov, temba kavna aralva Isakva sembayang vemnanamba. ");
INSERT INTO wrs_vpl VALUES ("GN31_54","002_31_54","GEN","31","54","54","Doa Yakopva phonamba, tatamba miklenamba, doa suwera wuweihana, wohweisumbulona di olora, Sesoam nonam sembayang vemnavna, doa sisva innemba hlanamba, hevna towandalm unna, ambo hlalm. Doa hlapianamba, di olora shana. ");
INSERT INTO wrs_vpl VALUES ("GN31_55","002_31_55","GEN","31","55","55","Doa simolnam meralva englava kakaiv vinnamba hevna umbeindilnam, eva mol samblanam, doa henga os gana hevna deuvram. ");
INSERT INTO wrs_vpl VALUES ("GN32_1","002_32_1","GEN","32","1","1","Doa Yakopva wongavna monam henga hevna aralindam, doa Sesoana ovsongolnindva hem nonglalm ambvna monaram. ");
INSERT INTO wrs_vpl VALUES ("GN32_2","002_32_2","GEN","32","2","2","Wo Yakopva hev nongalphonamba, ona, memba Sesoana kembelva, noinda no pethamba osva sevrana, Mahanaim. ");
INSERT INTO wrs_vpl VALUES ("GN32_3","002_32_3","GEN","32","3","4","Doa wongavnamba, himba hevna moashulnindrini samblamba mi wolanga venamba, unna, yeoa mi engavm Esauindam kavna eteindam dom Etom petharam, wo os ohomno, memba Yakopna boaslapevna moamba. Kava merainda mindnam ambo avna, wo daipotangas kava henga wonprov. ");
INSERT INTO wrs_vpl VALUES ("GN32_5","002_32_5","GEN","32","5","5","Kava wonav sapimba, donkimba, sipsipmba eva mememba, wo eva andranindmba. Yemba honinda kava ishomnav, yeoa beswonam kam venavm, yimba kana etel lohv. ");
INSERT INTO wrs_vpl VALUES ("GN32_6","002_32_6","GEN","32","6","6","Doa Yakopva mendah monam wongavna, moashulnindrini samblava henga epra, ohomnana, doa kava etepevmba ihishomni, wo himba men daipota monam prov, himba indkumbim indhanam wonprov 400pelara. ");
INSERT INTO wrs_vpl VALUES ("GN32_7","002_32_7","GEN","32","7","7","Doa Yakopva hellenamba, pem vevna, mindnam duus vevna, wo noinda wohna tatanamba hev hovra powalwolvna, sapi sipsip meme kamelnahonam, ");
INSERT INTO wrs_vpl VALUES ("GN32_8","002_32_8","GEN","32","8","8","os himba nengna, osva etemba protava, minindmba wonhelvawol vetava, sisnindva beswonam angavav. ");
INSERT INTO wrs_vpl VALUES ("GN32_9","002_32_9","GEN","32","9","9","Doa Yakopva Yawem sahmanavna os, yimba Sesoa lohv, eindilva kanamba Aprahamba nemetva yemba sembayang velohmanavna. Wo aramba kanamba Isakva os venata, yeoa kamoa hellevm. Nemetva yepev kamba ishomnana, henga arapevindam gao, yem kava waiavav, kolvrevav, wo noinda men kava henga gav. ");
INSERT INTO wrs_vpl VALUES ("GN32_10","002_32_10","GEN","32","10","10","Kava mani besal indhanarinima, heva os yimba kamba wavra vovhoamnav, beswonam vevrav. Nemetva kava nnoindam ganamba, wo alangas kava guana, Yotan pora kava peihavongana, os gavna. Wo men kava henga nomini prov, indhanamba wohva kava woniprov, eunumbulva samblava men. ");
INSERT INTO wrs_vpl VALUES ("GN32_11","002_32_11","GEN","32","11","11","Wo men kava yemba sahmanav, kam kekalvho vrinvm, ata homeis etemba prorava, kamba helvakomo wonvevav, kavm eva ungevlitundism. ");
INSERT INTO wrs_vpl VALUES ("GN32_12","002_32_12","GEN","32","12","12","Wo manam yimba maivethavav, nemetva yimba kamba tanamolnam wohishomnana, ona, yemba si kava kolvrevav, wo yetindiva si mindnam phovav, wo es eva seivilvav, owai, oi wan engal. ");
INSERT INTO wrs_vpl VALUES ("GN32_13","002_32_13","GEN","32","13","13","Doa sinim monara shanamba, wo sieunumbulnam pulvonamba, Yakop hevna tatapeta holvowol ve, Esaum holvorombraholm, osm kam noinda beswonam nihra pethavm. ");
INSERT INTO wrs_vpl VALUES ("GN32_14","002_32_14","GEN","32","14","14","Honi holvowol vena, memeaval 200pelara, memearal 20pelara, sipsipaval 200pelara, sipsiparal 20pelara, ");
INSERT INTO wrs_vpl VALUES ("GN32_15","002_32_15","GEN","32","15","15","kamel aval 30pelara eva hevna otomotalm, sapiaval 40pelara, sapiaral 10pelara, donkiaval 20pelara, donkiaral 10pelara. ");
INSERT INTO wrs_vpl VALUES ("GN32_16","002_32_16","GEN","32","16","16","Doa holvowol vevnamba, pulundthoawol vungavna espeta. Wo hevna andranindm pusvund vungu ve, kekalvho vrilm, unna, yeoa yesna mi wonangawul vevm, kava sis provav. Os angawul vevm, mongo mi wongavm espeta, mongo hovra wongavm espeta, mongo henga hovra wongavm espeta, mongo sis wongavm. ");
INSERT INTO wrs_vpl VALUES ("GN32_17","002_32_17","GEN","32","17","17","Doa mimirinim andranindrinim omnana, yeoa mi wongao, wo yimba Esaumba ata nonglarava, wo ata yemba sahmanavav, an yenamba mendekliva, wo hem yimba gav? Anna memba tatamba angav miva, men yimba wongavm? ");
INSERT INTO wrs_vpl VALUES ("GN32_18","002_32_18","GEN","32","18","18","Yeoa os omno, memba tatamba Yakopna yena boaslapevna. Himba ambo nis yemba holvoraholm vemnav. Boaslapevpa murapeta ten sis prov. ");
INSERT INTO wrs_vpl VALUES ("GN32_19","002_32_19","GEN","32","19","19","Doa Yakopva mongawamoa ishunna nomba andranindmba, hovranindm, hovranindm, ");
INSERT INTO wrs_vpl VALUES ("GN32_20","002_32_20","GEN","32","20","20","doa sisminim unna, yeoa os Esaumoa umnu, boaslapevpa yenamba murapeta sis prov. Yakopva noinda osva unna, os himba nengvna, kava hona tatana ata boasna das ovrevav kavna etemba, wo kava ata anongla everava, osva himba ata tandmomba wuleihavav. ");
INSERT INTO wrs_vpl VALUES ("GN32_21","002_32_21","GEN","32","21","21","Doa himba nomba andranindmba tatamba mi wolanga vena, doa di dawonam ana hevpa. ");
INSERT INTO wrs_vpl VALUES ("GN32_22","002_32_22","GEN","32","22","22","Doa sieunumbulnam Yakopva henga phonamba, ungevlitundismba mi wolanga vena eva ongal samblam, andranind unguvlirini samblam, ombolm 11pelara. ");
INSERT INTO wrs_vpl VALUES ("GN32_23","002_32_23","GEN","32","23","23","Mi wolanga venamba, himba Yapok pom lovol venamba wohnahonam, ");
INSERT INTO wrs_vpl VALUES ("GN32_24","002_32_24","GEN","32","24","24","wo aralva Yakopva ganamoa, himba di nohalm lohvna. Doa mongo tendorini pronamba, di Yakopi hevm epishawolvna. Mendah hevm epishawolvna, heva os Yakopmba himba petharava vendlahanamoa, owai. ");
INSERT INTO wrs_vpl VALUES ("GN32_25","002_32_25","GEN","32","25","25","Wo noinda himba Yakopm yuhval helvena, doa yuhmulva kelkovhoamnana. ");
INSERT INTO wrs_vpl VALUES ("GN32_26","002_32_26","GEN","32","26","26","Doa Yakopm omnana, kam wuleiho, doa lingil lihav. Doa Yakopva omnana, owai, boasna yeoa kam awotho. ");
INSERT INTO wrs_vpl VALUES ("GN32_27","002_32_27","GEN","32","27","27","Doa hev omnana, pevm boasna nihilm sevro, omnana, kava Yakop. ");
INSERT INTO wrs_vpl VALUES ("GN32_28","002_32_28","GEN","32","28","28","Doa hev omnana, men kava yemba henga awov Israelm. Si hengava yemba sevrivavmoa, osva Yakop, owai. Noinda kava yemba osva awov, seilva yimba indhanamongo alhmana vevna, wo henga men yimba Sesoai epishawoli, wo yemba kava vendlahaimoa. Israel maimba memba osm uv, himba Sesoai epishawolv. ");
INSERT INTO wrs_vpl VALUES ("GN32_29","002_32_29","GEN","32","29","29","Doa Yakop omnana, lehra, doa pevm nihilm sevro. Doa hev omnana, es hevpa yimba kamba sahmanav, nihilm sevro, doa hev Yakopm awothona, doa os wohgana. ");
INSERT INTO wrs_vpl VALUES ("GN32_30","002_32_30","GEN","32","30","30","Doa Yakop ona, kava Sesoana novlomosmba doa nonglai, heva os kamba dahavmoa, owai, kanandhav. Noinda no pethava sevrana, os Peniel. Penielva osm ovna, Sesoana novlomos. ");
INSERT INTO wrs_vpl VALUES ("GN32_31","002_32_31","GEN","32","31","31","Doa himba nominiva gavnamba, lingil lihavnamba, wo himba eisko vungavna yuhra. ");
INSERT INTO wrs_vpl VALUES ("GN32_32","002_32_32","GEN","32","32","32","Wo daipotava Israelnindva tatamba hlavpa, heva os owai, himba hlavmoa yuhalva, manara, tendorini doara kelkovhoamnana Yakopna yuhvalva. ");
INSERT INTO wrs_vpl VALUES ("GN33_1","002_33_1","GEN","33","1","2","Doa Yakopva monam wongavna, etelm Esaum nonglanga vena, ona pai, ten wonprov 400pelara. Doa hevna ungevlim unna, pevna ombpovmoa wonango. Andranind unguvlirini sambla mioa wonengavm, wo Lea hovra yeoa wongavm, wo Resel yeoa sis waingavm Yosepkalamoa. ");
INSERT INTO wrs_vpl VALUES ("GN33_3","002_33_3","GEN","33","3","3","Doa Yakop hev mi gavna, ku kusithamnavna Esaum, osm ovna, kuwul, doa os murapeta promnavna, mindnam kusithawol venana 7pelalm. ");
INSERT INTO wrs_vpl VALUES ("GN33_4","002_33_4","GEN","33","4","4","Doa Esauva hevpa lelnam pronamba, boaslalm sendara otho, mindnam indk vethamnavna wenahonam. Yakopva eva wiveholothomnavna. ");
INSERT INTO wrs_vpl VALUES ("GN33_5","002_33_5","GEN","33","5","5","Doa Esauva nungsis venamba, ungevlitundism nongalnamba, doa boaslalm omnana, anna memba ungevlitundisva? Doa hev omnana, memba otolva kanangas, Sesoa kam kolvrenamba, noinda phona. Sesoava besal hevm. ");
INSERT INTO wrs_vpl VALUES ("GN33_6","002_33_6","GEN","33","6","6","Doa andranind unguvlirini samblava murapeta epravna, Esaum ku ekusithawolmanana otolnahonam. ");
INSERT INTO wrs_vpl VALUES ("GN33_7","002_33_7","GEN","33","7","7","Doa Leava pronamba, ku kusithapramnana hevna otolnahonam. Doa sisnonoava Yosepi Reseli epranamba, ku ekusithawolmanana. ");
INSERT INTO wrs_vpl VALUES ("GN33_8","002_33_8","GEN","33","8","8","Doa Esauva boaslalm omnana, kava nongali, nomba temba miva angavnamba, wo es hevpa angav? Doa Yakop etelm omnana, temba yem holvodembraholm ambo nism, osm yeoa und lothovra. ");
INSERT INTO wrs_vpl VALUES ("GN33_9","002_33_9","GEN","33","9","9","Doa etel omnana, owai, kanamba tatamba mindnam, yeoa wonao. ");
INSERT INTO wrs_vpl VALUES ("GN33_10","002_33_10","GEN","33","10","10","Doa boaslal omnana, yeoa holvorombol veo, yimba kamba ind vemnatava. Kava os nonglav, yena novlomosva oi Sesoana, manara, yimba daipotava kamba beswonam lohmanav, daosmomba ishomnavmoa. ");
INSERT INTO wrs_vpl VALUES ("GN33_11","002_33_11","GEN","33","11","11","Sesoava kamba manimani esvema dembrahona, kamba pilivhoana, wo tataoa nooa yeoa holvorombol veo. Doa nihnapehna ovna, wo noinda etel omnana, ka holvoraita, ");
INSERT INTO wrs_vpl VALUES ("GN33_12","002_33_12","GEN","33","12","12","doa pioa engavai araindam, kava mi gavav. ");
INSERT INTO wrs_vpl VALUES ("GN33_13","002_33_13","GEN","33","13","13","Doa boaslal omnana, lehra, heva os kava lelnamba wonprovavmoa, kava ninginv otomotalm eva sipsip sapiotolm. Himba oiel, wo kava lelnamba galmba ovov, manara, mongawakombanamba himba angatava lelnamba, osva hemba wohdalvav tatamba. ");
INSERT INTO wrs_vpl VALUES ("GN33_14","002_33_14","GEN","33","14","14","Yeoa mi gavm, kava sis si wonprovav wowonam ambo, wo yemba di kava deuvra nonglaphovav di Etomra. ");
INSERT INTO wrs_vpl VALUES ("GN33_15","002_33_15","GEN","33","15","15","Doa etel omnana, lehra, ata kava ishunvav monglamba kavna andranindmba, unvav yem onhilvunalm. Doa boaslal omnana, owai, kava kavho beswonam wonprovav. Heva os pev ambo nengvm. ");
INSERT INTO wrs_vpl VALUES ("GN33_16","002_33_16","GEN","33","16","16","Doa honanamangas etelva phonamba, henga Etomram galm vevna. ");
INSERT INTO wrs_vpl VALUES ("GN33_17","002_33_17","GEN","33","17","17","Doa Yakopva nomini venamba, boasna Sukotram wongana, di deuvpa dembrana hevm, wo thindruvpa dembrowol vinna hevna tatam. Noinda no pethava os ningthiv Sukot, osm uvna thindruv. ");
INSERT INTO wrs_vpl VALUES ("GN33_18","002_33_18","GEN","33","18","18","Doa sisva nominiva venamba, Yakopva beswonam wonphonamba Kenan petharava, doa dawonam aevulthanamba di murapeta Sekem kembella, doara himba Mesopotamia pethara alohvna meralinda. ");
INSERT INTO wrs_vpl VALUES ("GN33_19","002_33_19","GEN","33","19","19","Doa pethana aralva hem kovoreihuna pethapeta nomba, doa himba hevmba diva nisreihunna, senmba os 100pelara, nomba silvava. Pethana aralva nomba os lovahvna Hamortindi, Hamorva nomba Sekemna aral lohmanana. ");
INSERT INTO wrs_vpl VALUES ("GN33_20","002_33_20","GEN","33","20","20","Doa Yakopva honmba songowol venamba no petharava, os sevrana, El Elohe Israel, osm ovna, Sesoa, yimba Israelnindna Sesoalm luhunv. ");
INSERT INTO wrs_vpl VALUES ("GN34_1","002_34_1","GEN","34","1","1","Doa Yakoptatanamba di aevulvna Kenan pethara. Doa Dinava molva ganamba, ungevlim sehelm nongalkalm gavna ungund ungevlim. ");
INSERT INTO wrs_vpl VALUES ("GN34_2","002_34_2","GEN","34","2","2","Doa ganamba, tendorini nonglana, kevrana, wailina, os indkokla vrena, nihilva Sekem. Himba Hamorna ombol lohvna Hivtindirini, Hamorva nomba kuwul mendekli himba wulluhunvna. ");
INSERT INTO wrs_vpl VALUES ("GN34_3","002_34_3","GEN","34","3","3","Doa sisva himba Dinam mindnam undnahonam nengmanavna, vralm vevna, ");
INSERT INTO wrs_vpl VALUES ("GN34_4","002_34_4","GEN","34","4","4","hevna aralm omnana, yeoa di nisraho no ungevlirinina aralmoa, ka vratam. ");
INSERT INTO wrs_vpl VALUES ("GN34_5","002_34_5","GEN","34","5","5","Doa Yakopva hellenamba, momba doa indkokla vrei, doa himba mana vema velm vevna, wo owai, manara, ombolva tatam wonlovahmana vevna oklam, hevho avna. ");
INSERT INTO wrs_vpl VALUES ("GN34_6","002_34_6","GEN","34","6","6","Avnamba, Hamorva kembelliniva venamba, engpra, moam ishomnalm, himba Sekemna aral. Engpranamba, Yakopna ombolva ambvna. ");
INSERT INTO wrs_vpl VALUES ("GN34_7","002_34_7","GEN","34","7","7","Doara himba hillinamba, nonora ambvna, doa hemba sahokla vinvna, aembko lomotha vivna, pai, pina muskovmba doa kevrai, himba sahonam venei, wo honamba memba pim louwolm plothuni pim Israelnindm. ");
INSERT INTO wrs_vpl VALUES ("GN34_8","002_34_8","GEN","34","8","8","Doa Hamorva Yakopm nonglaphonamba, omnana, kana ombolva Sekemba yena molm mindnam nengmanav, vralm vev. Wo es hevpa vravavma? ");
INSERT INTO wrs_vpl VALUES ("GN34_9","002_34_9","GEN","34","9","10","Kava yei ihisholm evev tanamolnam, osm mongawulm pioa ambo wohlovahvra. Osva pimba vitava, si yunalm pimba wohaevulvav, yimba honahalmba almba vevrava, osoa wouta. Osva pimba si ongamba evrowolvra, yimba kainda, eva kava yeinda, wo yenamba deuvpa lohvra, eva wohva esvema. ");
INSERT INTO wrs_vpl VALUES ("GN34_11","002_34_11","GEN","34","11","11","Doa Sekem ishunna Yakopm eva towandalm, yimba nomba utava hona yena ungevlirini indava, kava wohva yemba si osva dembrahunvav. ");
INSERT INTO wrs_vpl VALUES ("GN34_12","002_34_12","GEN","34","12","12","Yimba mana vemava wohmba ningtava mindnamba, dinahonamba osva kava nis ambo dembrahunvav yemba. Manam yimba owai vivav, kamoa plahongas viu, kava ambo wohvengas vevav. ");
INSERT INTO wrs_vpl VALUES ("GN34_13","002_34_13","GEN","34","13","15","Doa Yakopna ombolva hillinamba, unna, lehra, heva os boasna yeoa pevna nihtovm kuku, manara, osva owai vitava, kava lou vivav muskovmba pelaholmba. Dasalm unna muskovolnilm. Boasna yeoa nihtovm kuku, wo os pho, men kav, doa osva yemba kava kavna muskovmba pelahunvav. ");
INSERT INTO wrs_vpl VALUES ("GN34_16","002_34_16","GEN","34","16","16","Wo si yunalm pimba mongawulm woheuvmona vevav mongawatindilm, wo ongases vewulvra. ");
INSERT INTO wrs_vpl VALUES ("GN34_17","002_34_17","GEN","34","17","17","Yimba owai vitava, osva kava wohwaiangavav si. ");
INSERT INTO wrs_vpl VALUES ("GN34_18","002_34_18","GEN","34","18","18","Dasalm umnivna, doa Hamori Sekemi ehellenamba ohona, lehra. ");
INSERT INTO wrs_vpl VALUES ("GN34_19","002_34_19","GEN","34","19","19","Doa Sekemba lelnam phonamba, doa osangas vena, manara, himba mindnam nengmanavna Dinam. Hev mendekli nihilm wulluhunna hevtindinam. ");
INSERT INTO wrs_vpl VALUES ("GN34_20","002_34_20","GEN","34","20","20","Doa Hamoriva Sekemiva henga kembellam enganamba, kuksaruvra di epho, mundilm di uhunna, ");
INSERT INTO wrs_vpl VALUES ("GN34_21","002_34_21","GEN","34","21","21","Yakoptindiva pimba musk vinvmoa, pioa nombolvhoawol velvohra, piv mongawulm aevulla. Himba angalmba vevrava mongnahalmba, manam pimba sandhivav, pethava pinamba vavawonam luhunv. Si pimba ongases wonvivra hemongova. ");
INSERT INTO wrs_vpl VALUES ("GN34_22","002_34_22","GEN","34","22","22","Heva os pimba keknam doa ishuni, yeoa nihtovoa kuku, wo os pho men kav. ");
INSERT INTO wrs_vpl VALUES ("GN34_23","002_34_23","GEN","34","23","23","Pioa os velvohra, wo mana vemamba henamba wohva tatamba nomba pim velohunvra. ");
INSERT INTO wrs_vpl VALUES ("GN34_24","002_34_24","GEN","34","24","24","Doa indkumbi noi mundil una, lehra, wo indkumbi hevnamba nihtovmba kokoihanga vivna osangas. ");
INSERT INTO wrs_vpl VALUES ("GN34_25","002_34_25","GEN","34","25","25","Doa simba samblamong vivnamba, mendah nihsesoa vinvna, wo Yakopna ombol sambla Simeoni Levii, himba no kembellam esihohona ovlanahonam ambo wowonam. Kembelnindva nungeilnamoa, himba una, ambo eprav. Doa ephonamba, tendomba helvakomo evepia hevna muskovolnilm. ");
INSERT INTO wrs_vpl VALUES ("GN34_26","002_34_26","GEN","34","26","26","Doa Hamorim Sekemim eva helvakomo evena, wo muskovolm deuvrini Sekemnamini os henga waieprana. ");
INSERT INTO wrs_vpl VALUES ("GN34_27","002_34_27","GEN","34","27","29","Doa sisva Yakopnamba monglamba ombolva anganamba, wohva yunalm dumbpia muskovolnawusra. Sipsipm, memem, sapim, donkim, inne osorinim, eva ungevlitundism, manimani deuvmerinim, doa os wulprona. ");
INSERT INTO wrs_vpl VALUES ("GN34_30","002_34_30","GEN","34","30","30","Doa Yakopva Simeonim Leviim unna, honamba mani beswonamma, memba yimba eveiva, kamba si osva kin plothunvav. Manara indkola ungundva si kamba osva sahonam ningminivav Kenannind, Peresnind, indakonda pethanindva. Pimba mani indkumbima, himba hevm moakot evewollava, pimba si helvakomo vivav, katindiva si wohvitivhoavav. ");
INSERT INTO wrs_vpl VALUES ("GN34_31","002_34_31","GEN","34","31","31","Wo he ohomnana, hona tendoriniva kana muskovolmba kevrinnamba, maim oi ungevlirini monarini, wo noinda kava ohovovna. ");
INSERT INTO wrs_vpl VALUES ("GN35_1","002_35_1","GEN","35","1","1","Doa Sesoa Yakopm ishomnana, honaminioa pho, Betella di avhoao. Wo honoa kamoa di songowol veno, kav ten yem seilm nonglaphonam, nonam pev etepevnamini pem gavnam. ");
INSERT INTO wrs_vpl VALUES ("GN35_2","002_35_2","GEN","35","2","2","Doa Yakopva hellenamba, hevtindim unna, yeoa meilna viu, ");
INSERT INTO wrs_vpl VALUES ("GN35_3","002_35_3","GEN","35","3","3","pimba Betellam ata angavav. Wo di si kava honmba songowol venavav Sesoamba, temba kamba kolvrenamba, nonamba kamba kin venavna eteindava. Kava nohalva nohalva aevluwul vevnamba, himba kamba mongawulm waiavna. ");
INSERT INTO wrs_vpl VALUES ("GN35_4","002_35_4","GEN","35","4","4","Doa yeoa mana vemamoa tihrinioa dembranga viu, temba yimba iaevpa, wo besalangas kayenoa vewol viu, besal wevsam engu. Doa hevtindiva hillinamba, mana vemamba aongrini, tihrini os dembrahuna, wo himba pethara singvewol vena timingra Sekem kembella. ");
INSERT INTO wrs_vpl VALUES ("GN35_5","002_35_5","GEN","35","5","5","Doa Yakoptindiva angalm vevnamba, Sesoava kekalvho vrinvna, wo ungundva pem esvema vivna, himba engilangavnamoa sisva, owai. ");
INSERT INTO wrs_vpl VALUES ("GN35_6","002_35_6","GEN","35","6","6","Doa wonganamba, Betella di wonpho, ");
INSERT INTO wrs_vpl VALUES ("GN35_7","002_35_7","GEN","35","7","7","doa di hon songowol venamba, os sevrana, memba pethava El Betel, osm ovna, Sesoa Betelna. Manara, Sesoava seilva di hemba nonglaphonamba, nonamba himba etelnaminiva pemba gavnamba. No pethava seilva os sevrivna Lus. ");
INSERT INTO wrs_vpl VALUES ("GN35_8","002_35_8","GEN","35","8","8","Doa diva wonavnamba, ungevlirinimba os dahana Deporamba, himba Reselna andranind unguvlirini avna. Dahanamba, di singvina timingra Betella murapeta. Noinda no timba osva sevrivna, wuo ovna. ");
INSERT INTO wrs_vpl VALUES ("GN35_9","002_35_9","GEN","35","9","9","Doa Yakopva di Betella wonavna, doara Mesopotamia petharini wonpronamba, wo Sesoa henga nonglaphona, henga kolvrelmona awothona. ");
INSERT INTO wrs_vpl VALUES ("GN35_10","002_35_10","GEN","35","10","10","Omnana, yemba doara os awona Yakopm, heva os si yemba sevrivav, Israel. Noinda Sesoava hemba henga os awona Israelm. ");
INSERT INTO wrs_vpl VALUES ("GN35_11","002_35_11","GEN","35","11","11","Doa mendah omnana, kava Sesoa mendekli lohv, wo yeoa otolmoa mindnam towand veo. Si yetindiva mindnam phovav no pethara, no pethara, wo si monglava mendekli pulvovav hovrava. ");
INSERT INTO wrs_vpl VALUES ("GN35_12","002_35_12","GEN","35","12","12","Wo nomba pethamba kava yemba si indthueinvav, temba kava doarava indthueinnamba Aprahamimba Isakimba, wo si yetindimba kava wohkovorahunvav. ");
INSERT INTO wrs_vpl VALUES ("GN35_13","002_35_13","GEN","35","13","13","Doa Sesoava os wohvongana, ");
INSERT INTO wrs_vpl VALUES ("GN35_14","002_35_14","GEN","35","14","14","wo Yakopva honmba indund vilindthoana, hevna nengavnangm tuhholm, doa wainpol olivpol no honsra sovhomnana Sesoam. ");
INSERT INTO wrs_vpl VALUES ("GN35_15","002_35_15","GEN","35","15","15","Doa henga no pethamba sevrana Betel. ");
INSERT INTO wrs_vpl VALUES ("GN35_16","002_35_16","GEN","35","16","16","Doa Yakopva Betelnamini wongavna, Epratmonam wongavna. Angavna, doa mendah Epratva oklapeta lohvna, doa Reselmba kelathamnavna, noinda ena avna. Wo himba os vevna, ata hi kava lengvav? ");
INSERT INTO wrs_vpl VALUES ("GN35_17","002_35_17","GEN","35","17","17","Doa kinsomb mendekli venavna, mongo ungevlirini kevruwulavna, omnana, manapenam, doa lengpev otolva. ");
INSERT INTO wrs_vpl VALUES ("GN35_18","002_35_18","GEN","35","18","18","Heva os hemba dahalm vevna, wo otolmba awovna, os hemba wohdahana. Os awona, Benonim, wo aralva henga awona, Bensaminm. ");
INSERT INTO wrs_vpl VALUES ("GN35_19","002_35_19","GEN","35","19","19","Doa Reselmba dahamnanamba, di singvina Eprata mona pethalla. Epratava nomba daipotava os ningthiv, Betlehemkembel. Singvinamba, ");
INSERT INTO wrs_vpl VALUES ("GN35_20","002_35_20","GEN","35","20","20","Yakopva hon di indund vilindthoamnana, wo mendah vilindtholohv Reselna pokamahulsra. ");
INSERT INTO wrs_vpl VALUES ("GN35_21","002_35_21","GEN","35","21","21","Doa nomini wonganamba, di wonavhoana Miktaleterra nohalm. ");
INSERT INTO wrs_vpl VALUES ("GN35_22","002_35_22","GEN","35","22","22","Doa diva himba wonavnamba, Yakopna yiveltowondva Rupenmba phonamba, Bilham kevrana, wailina, Bilhava nomba aralna andranind unguvlirini. Doa aralva hellenamba, hemba noinda musk mindnam venavna os i. ");
INSERT INTO wrs_vpl VALUES ("GN35_23","002_35_23","GEN","35","23","23","Doa Yakopna ombtowondalva os lovahvna, yiveltowondva Rupen, avalva Lea. Wo Leanamba monglava ombolva Simeon, Levi, Yuta, Isakar, Sepulun. ");
INSERT INTO wrs_vpl VALUES ("GN35_24","002_35_24","GEN","35","24","24","Reselnamba ombolva Yosep, Bensamin. ");
INSERT INTO wrs_vpl VALUES ("GN35_25","002_35_25","GEN","35","25","25","Reselnamba andranind unguvlirininamba Bilhanamba ombolva Dan, Naptali. ");
INSERT INTO wrs_vpl VALUES ("GN35_26","002_35_26","GEN","35","26","26","Leanamba andranind unguvlirininamba Silpanamba ombolva Gat, Aser. Memba ombolva 12pelarava Yakop tetwond vena di okla Mesopotamia pethara hevna meralinda. ");
INSERT INTO wrs_vpl VALUES ("GN35_27","002_35_27","GEN","35","27","27","Doa Yakopva aralindam gana Mamreram, ten doara Aprahami Isaki ahalohvnam. Di mura lohv Hepron kembella, doara ningthivna Kiriatapa. ");
INSERT INTO wrs_vpl VALUES ("GN35_28","002_35_28","GEN","35","28","28","Doa Isakva osomba os vena 180pelara, mundkolalnonoa avna, ");
INSERT INTO wrs_vpl VALUES ("GN35_29","002_35_29","GEN","35","29","29","doa os dahana, wo ombol sambla Esaui Yakopi hemba di esingvena. ");
INSERT INTO wrs_vpl VALUES ("GN36_1","002_36_1","GEN","36","1","1","Memba moamba Esauna, nihilva mongo lohmanavna Etom. ");
INSERT INTO wrs_vpl VALUES ("GN36_2","002_36_2","GEN","36","2","2","Wo hena ongalva samblamong aevulvna, nihilva Ata, Oholipama, Basemat. Atava nomba Elonna mol, nomba Hittindirini. Oholipamava nomba Anana mol, nomba Anava Sipeonna ombol lohna, nomba Hivtindirini. ");
INSERT INTO wrs_vpl VALUES ("GN36_3","002_36_3","GEN","36","3","3","Basematva nomba Ismaelna mol, wo Nepaiotna moasalal. ");
INSERT INTO wrs_vpl VALUES ("GN36_4","002_36_4","GEN","36","4","4","Doa Atava otolm lengna tuendisrini, os awona Elivasm, wo Basematva otolm lengna tuendisrini, os awona, Ruelm, ");
INSERT INTO wrs_vpl VALUES ("GN36_5","002_36_5","GEN","36","5","5","wo Oholipamava tuendism samblamongm towand vena, vei Yeus, Yalam, Kora. Memba honamba Esauna towandva os nowana diva Kenan petharava. ");
INSERT INTO wrs_vpl VALUES ("GN36_6","002_36_6","GEN","36","6","6","Doa Esauva hona pethamba Kenan pethamba wuleihavna, mongnahalm gavna, wo ongalm otolm andranindm tatam huhul venamba wohnahonam, wo os wongana. Wohva tatamba nomba himba doara dombna di Kenan pethara. Wonganamba, hevna boaslalmba Yakopmba dasvholahangana. ");
INSERT INTO wrs_vpl VALUES ("GN36_7","002_36_7","GEN","36","7","7","Noinda dasvholahangana, hevna sapiva mindnam lovahmanavna, boaslalnamba eva mindnam lovahmanavna, wo innemba huti vovhoavna, sapiva hlalmba, wo Esauiva Yakopiva mongawulva no petharava eva es ahavta, owai. ");
INSERT INTO wrs_vpl VALUES ("GN36_8","002_36_8","GEN","36","8","8","Doa Esauva wonganamba, di wonavhoana Etom pethara olopethal. ");
INSERT INTO wrs_vpl VALUES ("GN36_9","002_36_9","GEN","36","9","9","Memba novol velohv Esauna umbeindil, wo pimba os ningthiv Etomtindi. ");
INSERT INTO wrs_vpl VALUES ("GN36_10","002_36_10","GEN","36","10","10","Esauna yivelongova Atava otolm mongasal lengna, tuendisrini Elivas. ");
INSERT INTO wrs_vpl VALUES ("GN36_11","002_36_11","GEN","36","11","11","Wo sisva Elivasva ombolm 5pelara towand vena, nihilva Teman, Omar, Sevo, Gatam, Kenas. ");
INSERT INTO wrs_vpl VALUES ("GN36_12","002_36_12","GEN","36","12","12","Elivasna aslongova ana, nihilva Timna, wo himba otolm mongasal lengna tuendisrini, nihilva Amalek. ");
INSERT INTO wrs_vpl VALUES ("GN36_13","002_36_13","GEN","36","13","13","Wo Esauna hovriniongova ana Basemat, wo himba otolm mongasal lengna tuendisrini, Ruel. Wo sisva Ruelva ombolva 4pelara towand vena, nihilva Nahat, Sera, Sama, Misa. ");
INSERT INTO wrs_vpl VALUES ("GN36_14","002_36_14","GEN","36","14","14","Wo Esauna aslongova ana, nihilva Oholipama, wo himba Anana mol, Anava nomba lohvna Sipeonna ombol. Wo Oholipamava ombolva samblamong towand vena, nihilva Yeus, Yalam, Kora. ");
INSERT INTO wrs_vpl VALUES ("GN36_15","002_36_15","GEN","36","15","15","Doa Esauna umbeindpolva os nowana. Esauna yiveltowondva lohna, nihilva Elivas, wo himba mindnam os nowana Temantindi, Omartindi, Sevotindi, Kenastindi, ");
INSERT INTO wrs_vpl VALUES ("GN36_16","002_36_16","GEN","36","16","16","Koratindi, Gatamtindi, Amalektindi. Men honamba os phona Atana umbeindpolva, Atava Esauna yivelongo ana. ");
INSERT INTO wrs_vpl VALUES ("GN36_17","002_36_17","GEN","36","17","17","Esauna hovrini ombolva lohna Ruel, wo himba mindnam os nowana Nahattindi, Seratindi, Samatindi, Misatindi. Men honamba os phona Basematna umbeindpolva, Basematva Esauna hovriniongo ana. ");
INSERT INTO wrs_vpl VALUES ("GN36_18","002_36_18","GEN","36","18","18","Wo Esauna aslongova ana Oholipama, himba Anana mol, wo himba mindnam os nowana Yeustindi, Yalamtindi, Koratindi. ");
INSERT INTO wrs_vpl VALUES ("GN36_19","002_36_19","GEN","36","19","19","Memba honamba Esauna umbeindpolva os phona. ");
INSERT INTO wrs_vpl VALUES ("GN36_20","002_36_20","GEN","36","20","20","Indhanamba seilva Etom pethara aevulvna, wo hev una, kava Seirtindi aevulv. Seirva nomba doara lohna Hortindirini, wo hevna ombolva umbeindpolva os aevulvna, Lotan, Sopal, Sipeon, Ana, ");
INSERT INTO wrs_vpl VALUES ("GN36_21","002_36_21","GEN","36","21","21","Dison, Eser, Disan. ");
INSERT INTO wrs_vpl VALUES ("GN36_22","002_36_22","GEN","36","22","22","Doa nomba Lotannamba umbeindpolva os phona Horitindi, vei Hemantindi. Wo Lotanna muskovol ana, nihilva Timna. ");
INSERT INTO wrs_vpl VALUES ("GN36_23","002_36_23","GEN","36","23","23","Wo nomba Sopalnamba umbeindpolva os phona, Alvantindi, Manahattindi, Epaltindi, Sevotindi, wo Onamtindi. ");
INSERT INTO wrs_vpl VALUES ("GN36_24","002_36_24","GEN","36","24","26","Wo Sipeonmba nomba ombol samblamba towand vena, nihilva Aya eva Ana. Wo sisva Ananamba ombolva mongasal lohmana, nihilva Dison. Wo Disonnamba umbeindpolva phonamba Hemtantindi, Espantindi, Itratindi, Seratindi. Wo Anana molva ana, nihilva Oholipama. (Hona indhanariningas Anava nonglana, pomba mellini phov, pomba nomba suwepav vevna. Himba aralna donkim dahwol vevna di pethakoklara, os nonglana.) ");
INSERT INTO wrs_vpl VALUES ("GN36_27","002_36_27","GEN","36","27","27","Wo nomba Esernamba umbeindpolva phonamba Bilhantindi, Savantindi, Akantindi. ");
INSERT INTO wrs_vpl VALUES ("GN36_28","002_36_28","GEN","36","28","28","Wo nomba Disannamba umbeindpolva phonamba, Ustindi eva Arantindi. ");
INSERT INTO wrs_vpl VALUES ("GN36_29","002_36_29","GEN","36","29","29","Doa hev honingas hevtindiva aevulvna Etom pethara, Horna Seirna umbeindpol, Lotantindi, Sopaltindi, Sipeontindi, Anatindi, ");
INSERT INTO wrs_vpl VALUES ("GN36_30","002_36_30","GEN","36","30","30","Disontindi, Esertindi, Disantindi. ");
INSERT INTO wrs_vpl VALUES ("GN36_31","002_36_31","GEN","36","31","31","Doa seilva Israelnindnamba kuwulva mendekliva wulluhunnamoa, owai mendah. Wo doara kuwul mendekli wulluhunvna Etomnindnam. Mongova dahavna, mongo hevnavhorava lohvhoavna. ");
INSERT INTO wrs_vpl VALUES ("GN36_32","002_36_32","GEN","36","32","32","Seilva Bela kuwulva wulluhunna, himba Beorna ombol lohna Dinhapa kembellini. ");
INSERT INTO wrs_vpl VALUES ("GN36_33","002_36_33","GEN","36","33","33","Wo sismba Yopap wulluhunna, himba Serana ombol Bosra kembellini. ");
INSERT INTO wrs_vpl VALUES ("GN36_34","002_36_34","GEN","36","34","34","Wo hengava sismba Husam kuwulva wulluhunna, himba Temantindirini, ");
INSERT INTO wrs_vpl VALUES ("GN36_35","002_36_35","GEN","36","35","35","wo hengava sismba Hatat kuwul wulluhunna, himba Betatna ombol Avit kembellini. Himba ahalvamana vevna Mitiannindmongo, wo engilpiengina di Moap pethara. ");
INSERT INTO wrs_vpl VALUES ("GN36_36","002_36_36","GEN","36","36","36","Doa hengava sismba Samla kuwulva wulluhunna, himba Masreka kembellini. ");
INSERT INTO wrs_vpl VALUES ("GN36_37","002_36_37","GEN","36","37","37","Wo hengava sismba Saul kuwulva wulluhunna, himba Rehopot kembellini lohvna, nomba di Yupretis pora lohvna. ");
INSERT INTO wrs_vpl VALUES ("GN36_38","002_36_38","GEN","36","38","38","Wo hengava sismba Balhanan kuwulva wulluhunna, himba Akporna ombol. ");
INSERT INTO wrs_vpl VALUES ("GN36_39","002_36_39","GEN","36","39","39","Wo hengava sismba Hatar kuwulva wulluhunna, himba Pau kembellini. Himba ango vrana Mehetapelm, himba Matretna mol avna, Mesahapna muiangol. ");
INSERT INTO wrs_vpl VALUES ("GN36_40","002_36_40","GEN","36","40","40","Doa Esauva simbel luhunna, indkumbina hona Etom kembelnindnamba, Timnatindim, Alvatindim, Yetettindim, ");
INSERT INTO wrs_vpl VALUES ("GN36_41","002_36_41","GEN","36","41","41","Oholipamatindim, Elatindim, Pinontindim, ");
INSERT INTO wrs_vpl VALUES ("GN36_42","002_36_42","GEN","36","42","42","Kenastindim, Temantindim, Mipsartindim, ");
INSERT INTO wrs_vpl VALUES ("GN36_43","002_36_43","GEN","36","43","43","Makteltindim, Iramtindim. Himba di aevluwul vevna, wo indhanamba hena pethamba os sevrowol vivna, hetindi hetindi hetindi. ");
INSERT INTO wrs_vpl VALUES ("GN37_1","002_37_1","GEN","37","1","1","Doa Yakopva mendah Kenan pethara wonavna, di ten aral Isak doara wonanam. ");
INSERT INTO wrs_vpl VALUES ("GN37_2","002_37_2","GEN","37","2","2","Memba Yakoptatanana moamba. Yosepva Yakopna ombol lohmanana, hena osomba os lohmanana 17pelara, hena avalva Resel. Doa Yakoptatanamba os andra velvohvna, sipsipm memem nom dahwol vivna. Wo Yosepva hevna etehumunilmongo andra velvohvna, no etehumunilva lovahmanavna Bilhaina Silpaina towandal. No Bilhaiva Silpaiva aralna andranind unguvlirini sambla ahana. Wo etehumunilva sahokla manimani vivna, wo Yosepva aralm Yakopm osva ishomnavna. ");
INSERT INTO wrs_vpl VALUES ("GN37_3","002_37_3","GEN","37","3","3","Wo aralva Yosepmba wi vevna esvema, Yosepna etehumunilmba espeta ambo wi vewol vevna. Manara aralmba doa mundkola vevna, wo Yosepmba avalva os lengna. Doa aral kayen tokol venana, kayenmba nomba besal, englamelva tokol, wo Yosepm moan vrahona. ");
INSERT INTO wrs_vpl VALUES ("GN37_4","002_37_4","GEN","37","4","4","Doa Yosepna etehumunilva nunglinamba, pai, aramba mindnamba Yosepmangas nengmanav, pimba ninginvmoa, owai, wo Yosepmba sahonam ningminivna, wo beswonamba moamba ishumnivnamoa, owai. ");
INSERT INTO wrs_vpl VALUES ("GN37_5","002_37_5","GEN","37","5","7","Doa sinim Yosepva inungpunung venamba, doa etehumunilm unna, kana inungpunungmom yeoa hillivm. Wo henamba moamba hillivnamba, wo himba esvema ambo ningminivna hemba sahonam. No inungpunungmomba os, piv indkola osora andra viv, wit nisowol viv, ten doara thinam. Wo kavnamba witva kava huhul vewol veiva, doa pethara nislaha, wo henga hev ambo hevm nisvundtho indund. Wo witva yenamba owai, yimba huhul vewol viva, nishi, doa hev ambo weisming vri kanamba, os kusithapramni. ");
INSERT INTO wrs_vpl VALUES ("GN37_8","002_37_8","GEN","37","8","8","Wo etehumunilva umnina, yimba os nengvma, kava si kuwulalm wulluhunvav, wo kam yaga vinvav? Wo noindava esvema ningminivna sahonam hemba ambo. ");
INSERT INTO wrs_vpl VALUES ("GN37_9","002_37_9","GEN","37","9","9","Wo sism henga Yosep inungpunung ve, etehumunilm ishune os. Hev ona, indanam kava inungoi, hengava kava nonglai okombam, eva weism, eva paim 11pelara, kam kuva kusithapramni. ");
INSERT INTO wrs_vpl VALUES ("GN37_10","002_37_10","GEN","37","10","10","Wo honamba inungpunungmomba aralm ishomnana. Wo aralva koasvena, memba yunam snal hevpa inungpunungmomba? Yimba os nengvma, ka eva avapevpa yenamba eva etehumunpevpa yenamba, si katatanamba pulvorava, wo yemba kuva kusithapramnavav, a? ");
INSERT INTO wrs_vpl VALUES ("GN37_11","002_37_11","GEN","37","11","11","Wo etehumunilva mindnam muskonam vreipra vrivna. Heva os aralva nomba inungpunungmomba mendah iavna. ");
INSERT INTO wrs_vpl VALUES ("GN37_12","002_37_12","GEN","37","12","12","Sism Yosepna etehumunilva angana Sekem petharam, dahwolalm sipsipm aralnam. ");
INSERT INTO wrs_vpl VALUES ("GN37_13","002_37_13","GEN","37","13","13","Wo aralva omnana Yosepm os, etehumunpevpa yenamba di Sekemra, kana sipsipm dahwol vewuv. Yeoa meilna vevm, ata yemba kava wolaihangavav. Hev ona, kava doa men meilna vev. ");
INSERT INTO wrs_vpl VALUES ("GN37_14","002_37_14","GEN","37","14","14","Aral ona, yeoa garava, etehumunpevm nongalo, di beswonam aevulvmi, a sahonam aevulvmi? Veo, sipsipm nongalo, beswonam lovahvmi, sahonam lovahvmi? Doa nongalpiarava, henga os pro, kamoa moaoa henga wulpromno. Aralva dingas avna pundra Hepronda, Yosepm velaihangana Sekemram, wo hev ganamba, di pho Sekemra. Wo di ambo lohmana vevna, ");
INSERT INTO wrs_vpl VALUES ("GN37_15","002_37_15","GEN","37","15","15","wo indhanarini mongo di nonglana Yosepm, sah ovre, manam yimba silelv? ");
INSERT INTO wrs_vpl VALUES ("GN37_16","002_37_16","GEN","37","16","16","Wo Yosep ona, kavnam etehumunilm kava silelowol vev. Es hevpa yimba kamba ishomnavavma, ora sipsipmba ten nolhra dahwol vewuv? ");
INSERT INTO wrs_vpl VALUES ("GN37_17","002_37_17","GEN","37","17","17","Wo indhanarini omnana, doa angana. Os kava hellena, os una, angavav Dotandam. Doa Yosepva os engilguana etehumunilmba sis Dotandam. ");
INSERT INTO wrs_vpl VALUES ("GN37_18","002_37_18","GEN","37","18","18","Wo himba mendah provna, etehumunilva okla nonglanga vina. Owai, provmoa murapetava, wo moamba himba ishuvna, ata helvakomandhivav. ");
INSERT INTO wrs_vpl VALUES ("GN37_19","002_37_19","GEN","37","19","19","Wo hevm himba hovra ishuvna os, Yosepkola inungpunungnindrini, himba ten prov. ");
INSERT INTO wrs_vpl VALUES ("GN37_20","002_37_20","GEN","37","20","20","Doa pimba ata helvakomandhirava, wo mindilva ata mella pilpipovvav. Sismba si pimba os ishuvav, sungeitwinde helvakomandhana dihi. Himba si pimba yaga vewol vinvavmoa, temba hevpa nonglanamba hevna inungpunungrava. ");
INSERT INTO wrs_vpl VALUES ("GN37_21","002_37_21","GEN","37","21","21","Doa Rupen yiveltowond hellowolna, Yosepm helvakomandhalm uv. Wo hev ona, pimba manam ata helvakomandhivav, owai. ");
INSERT INTO wrs_vpl VALUES ("GN37_22","002_37_22","GEN","37","22","22","Manam pimba tovolva sovhopiemnivav petharava. Ambo pilpipovra hona mella pethara, hui indhanahuira. Ata yimba sahokla vrivavm homeis. Rupenmba nengvna, Yosepm boaslam etehumunilnisra kava si heva wolaihaphovav hona melliniva, wo araindam henga wolaihangavav, wo noinda osva unna, manam pimba helvakomandhivav. ");
INSERT INTO wrs_vpl VALUES ("GN37_23","002_37_23","GEN","37","23","23","Doa Yosepva etehumunilm engilpronamba, wo noinda kevrina, wo kayenmba tokolva englamelnamba selvpingimnina. ");
INSERT INTO wrs_vpl VALUES ("GN37_24","002_37_24","GEN","37","24","24","Doa waianganamba mellava, diva pomba hivranam doara, doa no mella di holopipovvna. ");
INSERT INTO wrs_vpl VALUES ("GN37_25","002_37_25","GEN","37","25","25","Wo sism hev aevulthanamba, innemba os hlana. Inne mendah hleuvna, wo nungeilna, mongnindva indhanamba ten ambv. Ismaelnind Gileat petharini ambvna, wo Isip petharam oklam maketram angavna. No Ismaelnindva bisnis indhana, wo kamelva hevnamba kinmba ilvahinvna maketram tenen innem. ");
INSERT INTO wrs_vpl VALUES ("GN37_26","002_37_26","GEN","37","26","26","Wo Yuta hovrini etehumunilm boaslalm unna, manam pimba Yosepmba pivna boaslalmba helvakomandhivav, owai osva. Manam pimba sahonamba vivav, wo pivna aramba osilminivav, wo pivna indkoklava seslala vewol ovivra. ");
INSERT INTO wrs_vpl VALUES ("GN37_27","002_37_27","GEN","37","27","27","Osva lehra, pioa holvoreihunda nom Ismaelnindm, wo pimba di dumbvra. Pinamba mongawa pendarinina nihilva pimba indkokla vrimnivavmoa osva. Wo etehumunilva honamba Yutana moamba os una, lehrata. ");
INSERT INTO wrs_vpl VALUES ("GN37_28","002_37_28","GEN","37","28","28","Wo Mitiannindva khovombvna hom, etehumunilva Yosepm mellini wolaihapulvonamba, wo hemba Ismaelnindm holvoreihunna, dim noindam dombolm. Doa Ismaelnindva diva hilivhueinna etehumunilm os 20pelara kinava. ");
INSERT INTO wrs_vpl VALUES ("GN37_29","002_37_29","GEN","37","29","29","Rupennisra osva vina. Wo Ismaelnindva Yosepmba waiangana Isip petharam. Doa henga sism Rupenmba mellam pro, hevna boaslalm mellinim henga wolaihapholm vevna, ona, pai, Yosepva avmoa, es vei? Wo noinda hevna boaslalm und venamba, kayenmba hevnamba os popowol vena. ");
INSERT INTO wrs_vpl VALUES ("GN37_30","002_37_30","GEN","37","30","30","Wo henga gana towandaslalindam, ona, honamba tuendisriniva Yosepva avmoa. Es hevpa kava ata vevav? ");
INSERT INTO wrs_vpl VALUES ("GN37_31","002_37_31","GEN","37","31","31","Wo sism etehumunil pulvona, memem mikli, wo Yosepna kayen tovolla pethie. ");
INSERT INTO wrs_vpl VALUES ("GN37_32","002_37_32","GEN","37","32","32","Petheinamba, doa moan vilangana aralindam Yakopindam, wo eva dasalmomba ishumnina os, honamba kayenmba ka moan vreina, nonglo, es hevpa yena ombolnami owaimi? ");
INSERT INTO wrs_vpl VALUES ("GN37_33","002_37_33","GEN","37","33","33","Wo aral nonglanamba, hev ona, lehrata, memba Yosepna kayenmba. Sungeitwinde helvakomandhanamba, doa os sahonam wunungu vena. ");
INSERT INTO wrs_vpl VALUES ("GN37_34","002_37_34","GEN","37","34","34","Doa Yakop phona, hevna kayen popowol vena, wo kayenkolol vetha, wo osva indvaomana vevna hevna ombolmba. Wo esvema wi vaomana vevna. ");
INSERT INTO wrs_vpl VALUES ("GN37_35","002_37_35","GEN","37","35","35","Wo indkola hevna ombolva molva ambvnamba, moa waiishuvmona vevna, wo ona, hena undm dindwond ovrivna. Heva os owai, wo hev ona, owai, kava wena av mendah, kamba verava, dahara, wo os kava kavna ombolm Yosepm waiavav, di ten indhanasongo aevulvm. Wo osva wena avna Yosepm hevna tendo towondrinim. ");
INSERT INTO wrs_vpl VALUES ("GN37_36","002_37_36","GEN","37","36","36","Wo nonamba di okla Isip pethara nomba Mitiannindva, himba Yosepmba wuleihina, Potipana englisra holvoreihuna andranindilm ambo. Holvoreihunamba, doa himba Mitiannindmba di dembrahunvna. No Potipava kuwul wulluhunvna polisinamba, no polisiva kekalvho vruwuvna Perona deuvmba, no Perova Isipna mendekli kuwul himba wulluhunvna. ");
INSERT INTO wrs_vpl VALUES ("GN38_1","002_38_1","GEN","38","1","1","Doa Yuta Yakopna hovrini ombol lohvna. Wo himba hevna etehumunilmba sandhalaha ganamba, di avhoa Hirainda di kembella Atulamra. ");
INSERT INTO wrs_vpl VALUES ("GN38_2","002_38_2","GEN","38","2","2","Wo di himba ungevlirinim nonglanamba Kenanongorinim, hevna aralna nihilva Suwa, wo wohvrana. Wohvranamba, wailimana vevna, ");
INSERT INTO wrs_vpl VALUES ("GN38_3","002_38_3","GEN","38","3","3","doa ena avna, otolm lengna tuendisrini, os awona Erm. ");
INSERT INTO wrs_vpl VALUES ("GN38_4","002_38_4","GEN","38","4","4","Wo henga sism himba ena avna, otolm lenge tuendisrini, os awona Onanm. ");
INSERT INTO wrs_vpl VALUES ("GN38_5","002_38_5","GEN","38","5","5","Wo henga sism mongom lengna, os awona Selam. Aralva di Kesipra avna, avalva hevinda lengna sisminimba. ");
INSERT INTO wrs_vpl VALUES ("GN38_6","002_38_6","GEN","38","6","6","Doa Erva mendekli venamba, aralva Erinda ongamba vrana, nihilva Tamar. ");
INSERT INTO wrs_vpl VALUES ("GN38_7","002_38_7","GEN","38","7","7","Heva os Erva sahokla vevna, wo noinda Yawe hemba hilpiana. ");
INSERT INTO wrs_vpl VALUES ("GN38_8","002_38_8","GEN","38","8","8","Doa Yutava Onanm ombolm omnana, etepevmba yenamba doa dahana, wo yeoa pelimoa Tamarmoa pethao, wailu, pina wevsava os luhunv. Wo himba tuendisrinimba lengtava yeindava, no ombpovpa si Ernavhora lohvav, wo Ertindimba si osva vitivhoavavmoa. ");
INSERT INTO wrs_vpl VALUES ("GN38_9","002_38_9","GEN","38","9","9","Wo Onanmba hev nengvna os, hona ungevliriniva kaindava lengtava otolmba, wo Ernavhora si lohvav, kanavhorava lohvavmoa. Wo noinda hev hevna moamulm pethanamba, wailimana vevna, heva os beswonamba wailimana vevnamoa, himba sahonam ambo vevravna, osmba enamba avavmoa. ");
INSERT INTO wrs_vpl VALUES ("GN38_10","002_38_10","GEN","38","10","10","Wo Yawe nonglana, Onanmba osva sahonam memba vev, wo Yawe hemba noinda hilpia, doara etelmsna hilpianamba. ");
INSERT INTO wrs_vpl VALUES ("GN38_11","002_38_11","GEN","38","11","11","Doa Yutava kolm omnana, yeoa henga gao arapevindam, di dawonam avm, wo kana kalelva Selava boasna mendekli vevra, si heva os himba yemba pethavav. Yutava pemba vevna lelnamba vralmba kalelindava, manara, doa Yawe hilpiawolna yiveltowondm hovrinim, noinda osva ovomnana. Doa kolva hellenamba, hevna aralindam os wohgana. ");
INSERT INTO wrs_vpl VALUES ("GN38_12","002_38_12","GEN","38","12","12","Doa sisva Yutana ongalmba dahamnanamba, wo hev wi vepianamba, seheli Hirai himba engavna, Timnaram enganamba, ten andranind hena sipsipna talm koaowuvunvnam. Hirava nomba Atulam kembellini. ");
INSERT INTO wrs_vpl VALUES ("GN38_13","002_38_13","GEN","38","13","13","Doa Tamarva hev hellenamba, meramba ata Timnamonam gavav. ");
INSERT INTO wrs_vpl VALUES ("GN38_14","002_38_14","GEN","38","14","14","Doa hev pethasevpa sowol vena, temba himba pethasev vawovnamba tlalindamba. Doa hevna novlomosva ehlathanamba, doa Enaim kembellam ganamba, di monamilla avhoana, no Timnamonara lohvna. Os vevna, oi monaunguvlirini. Os nengvna, Yutana kalelva Selava doa mendekli vena, wo aral kamba himba omnavmoa hevna kalelindamba, homeis si kava muhsoh wohavm. Aralva pepehmoa ishovna. ");
INSERT INTO wrs_vpl VALUES ("GN38_15","002_38_15","GEN","38","15","15","Doa hev monapethalla avna, Yutava provna, nonglapho, ona, monaunguvlirini, novlomosm ehlathaiva. Tit vrevna, heva os hevna kol. ");
INSERT INTO wrs_vpl VALUES ("GN38_16","002_38_16","GEN","38","16","16","Doa nonglaphonamba, hemba omnana, mani ata yemba kava venavav, osmba yemba kava wailivav? Doa hev omnana, mani ata yimba kamba dembrahovav, nonungnamba, waililmba? ");
INSERT INTO wrs_vpl VALUES ("GN38_17","002_38_17","GEN","38","17","17","Doa hev omnana, yemba kava ata memeotol holvoraohvav kavnamini. Doa hev omnana, lehra, wo boasna yeoa kamoa mana vema vraho, wo kamba yimba ata memeotol holvorahorava, os ata yemba kava no mana vemamba henga vrahovav. ");
INSERT INTO wrs_vpl VALUES ("GN38_18","002_38_18","GEN","38","18","18","Doa himba omnana, mani ata kava yemba vrahovav? Doa hev omnana, kam no dembraho, vei omorini eva ala. Doa himba os dembrahona, os wailina. ");
INSERT INTO wrs_vpl VALUES ("GN38_19","002_38_19","GEN","38","19","19","Doa hev henga deuvram ganamba, novlomosrini pingamnana, henga silem pethasev vena tlalinda. Wo sisva himba ena avna eindilna. ");
INSERT INTO wrs_vpl VALUES ("GN38_20","002_38_20","GEN","38","20","20","Doa Yuta hev ganamba, henga sehelm Hiram wolaihanga memeotolnahonam, omnana, vraho, wo mana vemamba kanaoa henga dembrakara. Doa hev ganamba, silelnamba, wo owai, nonglanamoa. ");
INSERT INTO wrs_vpl VALUES ("GN38_21","002_38_21","GEN","38","21","21","Doa tendom Enaimnindm osihinvna, monaunguvliriniva hi av, seilva huiva avnamba? Doa he umnina, snamba huiva owai, avmoa mongova monaunguvliriniva doarava, veiva, daipota men. ");
INSERT INTO wrs_vpl VALUES ("GN38_22","002_38_22","GEN","38","22","22","Doa himba henga Yutam engpranamba, omnana, kava nonglaimoa. Tendomba ui, snamba huiva owai doarava, veiva daipota men. ");
INSERT INTO wrs_vpl VALUES ("GN38_23","002_38_23","GEN","38","23","23","Doa Yuta omnana, iavra, pimba indhanamba ishuntava, himba osva pimba los unvav. Kava oi vrahoi memeotolva, heva os owai, yimba nonglaimoa. ");
INSERT INTO wrs_vpl VALUES ("GN38_24","002_38_24","GEN","38","24","24","Doa weisva samblamong khuawol venamba, wo indhanariniva Yutam os ishomnana, kopevpa yenamba tlahui, heva os ena av, himba sahokla vena. Doa Yutava hellenamba, omnana, pimba pivna wevsana vinivra, helvakomandhirava, suwera wuweihi. ");
INSERT INTO wrs_vpl VALUES ("GN38_25","002_38_25","GEN","38","25","25","Doa indhanamba Tamarm waiangavna, himba moamba ishonga vemnana Yutam, os omnana, nonglo, hona omorinina alana aralva hev kam venana, ena vethara. Wo os dembhanga vemnana omorini ala, ona, anna? ");
INSERT INTO wrs_vpl VALUES ("GN38_26","002_38_26","GEN","38","26","26","Doa Yuta nongalna, ona, pai kana memba. Doa ona, himba sahonamba venamoa, kava kav sahonamba vena, kava owai vena, omnalmba kavna kalelindamba. Doa himba hengava Tamarmba kolmba kevranamoa. ");
INSERT INTO wrs_vpl VALUES ("GN38_27","002_38_27","GEN","38","27","27","Doa Tamarva ena avna, doa kelathamna, otolva sambla ihilwolmanavna emerava. ");
INSERT INTO wrs_vpl VALUES ("GN38_28","002_38_28","GEN","38","28","28","Doa mindnamba kelathamnavnamba, mongova hevna engla puspipho, doa ungevliriniva noi ten Tamarm vrevnam, he kevranamba, benam aembulna englaval hoahm mokelthoamna, ona, memba yiveltowond. ");
INSERT INTO wrs_vpl VALUES ("GN38_29","002_38_29","GEN","38","29","29","Heva os owai, otolva henga hevna englava kivrasiha vena, mongomba lengna. Doa no ungevliriniva omnana, pai, yimba es hevpa owapevmba kuvhoai? Wo noinda osva awona Peresm. ");
INSERT INTO wrs_vpl VALUES ("GN38_30","002_38_30","GEN","38","30","30","Doa mongomba henga lengna sism benam englanahonam, os awona Seram. ");
INSERT INTO wrs_vpl VALUES ("GN39_1","002_39_1","GEN","39","1","1","Doa Ismaelnindva Yosepmba Potipainda dasvhohalvona, wo Yosepva Potipana deuvmera andra vawovna. No Potipava kuwul wulluhunvna polisimba, no polisiva kekalvho vruwuvna Perona deuvmba, wo no Perova Isipna mendekli kuwul himba wulluhunvna. ");
INSERT INTO wrs_vpl VALUES ("GN39_2","002_39_2","GEN","39","2","2","Doa Yaweva Yosepmba nesmos vrevna, wo Yosepva andrava vevnamba manimani, hena andrava beswonam phovna. ");
INSERT INTO wrs_vpl VALUES ("GN39_3","002_39_3","GEN","39","3","3","Wo Potipava doa nonglana, osva Yawe Yosepmba nesmos vrev, wo Yosepva andra vev beswonamangas noinda. ");
INSERT INTO wrs_vpl VALUES ("GN39_4","002_39_4","GEN","39","4","4","Wo hevpa os vevna, lehra yimba andra vev kana andrava, wo omnana, kana kekalvho vro deuvmoa wohnahonam. ");
INSERT INTO wrs_vpl VALUES ("GN39_5","002_39_5","GEN","39","5","5","Wo nonamba Yaweva keknam vewol vevna Potipatatanamba. Hevpa keknam vewol vevna wohm eva indhanam, di Potipana deuvmera eva osom. ");
INSERT INTO wrs_vpl VALUES ("GN39_6","002_39_6","GEN","39","6","6","Wo Potipava Yosepm omnana, ye kanamba si kekalvho vrevav, wo hevpa nengvnamoa mana vemamba, owai, himba ambo hevna innemangas nengvna nelm. Wo nihva Yosepnamba besal lohvna. ");
INSERT INTO wrs_vpl VALUES ("GN39_7","002_39_7","GEN","39","7","7","Wo dawonam Potipana ongal nonglana ona, pai besal hevm, kam wailira. ");
INSERT INTO wrs_vpl VALUES ("GN39_8","002_39_8","GEN","39","8","8","Wo Yosep omnana, kamba owai. Potipa yena tlapevpa kana kuwulva kamba os omnana, yeoa kanamoa deuvmoa wohmoa kekalvho vro, wo noinda himba nengowol vevmoa mana vemamba. ");
INSERT INTO wrs_vpl VALUES ("GN39_9","002_39_9","GEN","39","9","9","Honamba deuvnamba ka kuwulva wulluhv, osva hevpa temba, wo kamba ovomnanamoa mana vemamba, yemangas hena ongalm. Es hevpa kava osva sahonamba vevav Sesoana novrava, owai. ");
INSERT INTO wrs_vpl VALUES ("GN39_10","002_39_10","GEN","39","10","10","Wo elsus ungevliriniva nomba Yosepmba ishomnavna mindnam, kam wailu. Heva os owai, Yosepva henamba moamba hellevnamoa, osva ovna, lehra kamba omnav, wo wailinamoa. Yosepva murapetava gavnamoa domba ungevlirini indamba, owai. ");
INSERT INTO wrs_vpl VALUES ("GN39_11","002_39_11","GEN","39","11","11","Wo Yosepva deuvra sihanamba, andram velm, wo monglava andranindva diva aevulvnamoa, ");
INSERT INTO wrs_vpl VALUES ("GN39_12","002_39_12","GEN","39","12","12","wo Potipana ongal kayenm keknam kevremnana Yosepnam, wo hev omnana, ye kam wailu. Wo owai, Yosepva deuvmeriniva amballam wohpholahangana dandwonam, ungevlirini di Yosepna kayenmba englana moanvulamnana. ");
INSERT INTO wrs_vpl VALUES ("GN39_13","002_39_13","GEN","39","13","14","Doa wunuhunna andranindm, hev gekala ona, nunglu, kana tlal waiprona nom Hipru tendorinim Yosepm pina deuvram, wo pim sahokla vewol vevna. Kana deuvmeram sihaiva, wo kam omnavna, yem ka waili. Heva os owai, ka mindnam wunuhoiva. ");
INSERT INTO wrs_vpl VALUES ("GN39_15","002_39_15","GEN","39","15","15","Wo himba kam helleiva, pai, wunuhov, doa noinda hevna kayenmba moanvelahaphoi amballam, wohpholahangai. ");
INSERT INTO wrs_vpl VALUES ("GN39_16","002_39_16","GEN","39","16","16","Wo Potipana ongalva moanvulamnana kayenmba Yosepnamba, venamba, hevna tlal deuvram dom prona. ");
INSERT INTO wrs_vpl VALUES ("GN39_17","002_39_17","GEN","39","17","17","Doa hev tlalm gekala omnana mongawamoa noi ambo. Hev ona, honamba Hiprunindriniva, yimba memba waiprunnamba Yosepva, hev proiva deuvmeram dom kaindam, wo kam sahokla vrelm vevna. ");
INSERT INTO wrs_vpl VALUES ("GN39_18","002_39_18","GEN","39","18","18","Wo ka wunuhoiva, wo di hevna kayenmba moanvelahaphoi kana englara, amballam wohpholahangai. Ungevlirini ishovna, wo hev ona, noi yena andranindriniva kam os venavna. ");
INSERT INTO wrs_vpl VALUES ("GN39_19","002_39_19","GEN","39","19","19","Doa Potipa hellenamba, wo esvema tandna, ");
INSERT INTO wrs_vpl VALUES ("GN39_20","002_39_20","GEN","39","20","20","wo hev hevna polisim unna, Yosepm kevru, buiram wolaihasuvu. Wo polisi kevrinamba, buira wolaihasuvna di buiduvra, ten Pero kuwulna buinind aevulvnam. ");
INSERT INTO wrs_vpl VALUES ("GN39_21","002_39_21","GEN","39","21","21","Wo heva os Yawe Yosepm mendah nesmos vrevna, ");
INSERT INTO wrs_vpl VALUES ("GN39_22","002_39_22","GEN","39","22","22","wo noinda buinindna kuwulva Yosepm und vevna, omnana, yeoa kekalvho vewol veo buinindmoa monglamoa. Wo Yosep kuwulva buinindnamba wulluhunvna, wo andramba eva henamba kekalvho vrinvnata. ");
INSERT INTO wrs_vpl VALUES ("GN39_23","002_39_23","GEN","39","23","23","Wo Yaweva beswonam vewol venavna Yosepmba, wo noinda Yosepva andra vevna manimani, wo nomba beswonamangas phovna. Wo kuwulva buinindnamba nengvnamoa mana vemamba, Yosepva kekalvho vewol vevnamba. Manara, Yawe Yosepmba waiandra vevna. ");
INSERT INTO wrs_vpl VALUES ("GN40_1","002_40_1","GEN","40","1","1","Doa Pero kuwulna andranindrini samblava hev sahonam evevna. Wainpolna kuwuli rotina kuwuli honi Perom sahonam evemnana. Perova Isipnindna mendekli kuwul wulluhunvna, wo honi andranindrini sambla elohmanana. ");
INSERT INTO wrs_vpl VALUES ("GN40_2","002_40_2","GEN","40","2","2","Wo Pero tandwol ve honi andranindrini samblamba, ");
INSERT INTO wrs_vpl VALUES ("GN40_3","002_40_3","GEN","40","3","3","doa buiram hemba wolasiha ve, wo no hena buiduvrava, ten Yosepm doara wolaihasihanam. ");
INSERT INTO wrs_vpl VALUES ("GN40_4","002_40_4","GEN","40","4","4","Doa buina kuwulva Yosepm omnana, yeoa honamoa indhanarini samblamoa dahwol vevm. Doa no indhanarini samblava diva buirava os ahana esvema i. ");
INSERT INTO wrs_vpl VALUES ("GN40_5","002_40_5","GEN","40","5","5","Wo himba inungpunung evena, indanam himba evewolvna, wo plalva eva indanam. ");
INSERT INTO wrs_vpl VALUES ("GN40_6","002_40_6","GEN","40","6","6","Wo Yosepva nongalphonamba simekumbra, wo he nongalna, duus avahav. ");
INSERT INTO wrs_vpl VALUES ("GN40_7","002_40_7","GEN","40","7","7","Wo hev osihinna, manara yimba sahonamba duus avahav? ");
INSERT INTO wrs_vpl VALUES ("GN40_8","002_40_8","GEN","40","8","8","Wo hev ohomnana, kava inungpunung eveiva, wo huiva indhanariniva owai, ata kamba moamba ishunta inungpunungna plalmba. Doa Yosep unna, Sesoangas heva hev pimba ishunvav no inungpunungna plalmba. Wo kam ihishomnotok pevna inungpunungmom nom. ");
INSERT INTO wrs_vpl VALUES ("GN40_9","002_40_9","GEN","40","9","9","Doa wainpolna kuwul ishomnana hemba. Hev ona, kanamba inungpunungva os, murapetava kava nonglana grevweselm. ");
INSERT INTO wrs_vpl VALUES ("GN40_10","002_40_10","GEN","40","10","10","Nomba klalva samblamong liavna. Doa mothol venamba, vlel peholothonamba, wo sesel ve, movol ketha lelnam. Wo nihil vena, venamba, aembul ksuvho doa. ");
INSERT INTO wrs_vpl VALUES ("GN40_11","002_40_11","GEN","40","11","11","Wo kava mokva Peronamba wulluhvna, doa ka pueite grevna movolva, wo englana kelvowol ve, wo wainpolva pihavna di mokra. Wo os kava vrahona Peromba kavna kuwulmba. ");
INSERT INTO wrs_vpl VALUES ("GN40_12","002_40_12","GEN","40","12","12","Wo Yosep ona, hona inungpunungna plalmomba os, grevklalva samblamongova liav, osm lehvrev simba samblamong. ");
INSERT INTO wrs_vpl VALUES ("GN40_13","002_40_13","GEN","40","13","13","Nomba simba samblamongova vepiarava, wo Perova yenamba wevsakoklamba si os maivethavav, wo yemba buiriniva wolaihangavav. Wo osva yemba henga Perova hevna andramba wolaihasihavav, daha Perom wainoa moknahonam vrahovav, nemet ten pev kuwul wulluhunam wainpolna andranindm. ");
INSERT INTO wrs_vpl VALUES ("GN40_14","002_40_14","GEN","40","14","14","Hello beswonam, yimba osva avrava, daha kamoa nengmanavm, kam wavra vovhoamnavrava, wo Perom os ishomno, Yosepva yena buirava nembaipeta avma, doa wolaihapho. ");
INSERT INTO wrs_vpl VALUES ("GN40_15","002_40_15","GEN","40","15","15","Manara, seilva nemetva indhanamba kamba nis ambo waiambna kavna pethariniva, Hiprunindna pethariniva homba, kava ophonamoa. Wo eva hona petharava mana vemamba kava venamoa, wo kamba ombamora huiva bui vina. Doa kaoa pholahangara. ");
INSERT INTO wrs_vpl VALUES ("GN40_16","002_40_16","GEN","40","16","16","Doa rotina kuwul hellena, inungpunungmom besal hevm lehra, wo Yosepm ishomnana, kava eva os inungpunung veita. Honamba os, kava sumbva samblamong kura ingavna, ");
INSERT INTO wrs_vpl VALUES ("GN40_17","002_40_17","GEN","40","17","17","wo merava senamba rotiva snanovna snanovna pilivhoana, kav vewol venam. Wo Pero kuwulva ata nevav. Heva os tuawa hlavna honamba rotiva sumbriniva. ");
INSERT INTO wrs_vpl VALUES ("GN40_18","002_40_18","GEN","40","18","18","Wo Yosep ona, hona inungpunungmomba os lohv, sumbva samblamongova euvhalohv, osm lehvrev simba samblamong. ");
INSERT INTO wrs_vpl VALUES ("GN40_19","002_40_19","GEN","40","19","19","Nomba simba samblamongova vepiarava, doa os Perova yemba wolaihaphovav hona buiduvriniva, doa yena kuwulva kovho. Wo yena nihilva tiklara vendkleihavav, wo tuawa yenamba nihilva wuhhlahalv vewuvav. ");
INSERT INTO wrs_vpl VALUES ("GN40_20","002_40_20","GEN","40","20","20","Doa simba samblamong venamba, Perova ona, innemba ata hlavav deti honanamangasm, avamba kamba doarava honanam lengna. Wo himba hevna andranindm ishunna. Wo no wainpolna kuwulm waipro, eva no rotina kuwulm waipro buirini, wo honi andranindrini samblamba indthoawol vinna hena mongo andranindna novra. ");
INSERT INTO wrs_vpl VALUES ("GN40_21","002_40_21","GEN","40","21","21","Wo Pero wainpolna kuwulmba velaihangana hevnam andram, os seilm ten doara hev andra vevnam. ");
INSERT INTO wrs_vpl VALUES ("GN40_22","002_40_22","GEN","40","22","22","Wo rotina kuwulnamba kuwul kovhoamna, vendkleihina. Perova os vinna, ten Yosep inungpunung plalmomba seilm doara ishunnam. ");
INSERT INTO wrs_vpl VALUES ("GN40_23","002_40_23","GEN","40","23","23","Heva os wainpolna kuwulva hengava nengmananamoa Yosepmba, owai, maivethana. ");
INSERT INTO wrs_vpl VALUES ("GN41_1","002_41_1","GEN","41","1","2","Tahonmba sambla vewolnamba, wo Yosepva mendah buira avna, wo Pero hev inungpunung vevna. Os inungpunung vevna, kava Nail popethalla lohvna, wo sapiva 7pelarava di Nail pomerini pulvoiva, doa pos hlavna di popethalla. Hemba po ambo pihawol vevna i. ");
INSERT INTO wrs_vpl VALUES ("GN41_3","002_41_3","GEN","41","3","3","Wo henga sism mongo 7pelarava sapi pulvo Nail pomerini, wo almangkelangas, wo beswonamba lovahvnamoa. Wo sapiva dom ambna, owal di lovahvnam. ");
INSERT INTO wrs_vpl VALUES ("GN41_4","002_41_4","GEN","41","4","4","Doa sism sapiva almangkelangasva wohwehala vepiavna nomba sapimba besalmba. Doa kava os phona. ");
INSERT INTO wrs_vpl VALUES ("GN41_5","002_41_5","GEN","41","5","5","Wo henga sism inungpunung ve. Os vevna, kava witm osora nunglul lohvna, nihilva 7pelarava mongawatilla endv. Doa mendekliva venamba, sevral endv. ");
INSERT INTO wrs_vpl VALUES ("GN41_6","002_41_6","GEN","41","6","6","Wo henga sism pola, tilva mongongasal nihilva 7pelara endv. Doa vuvi suwepaval vevna, wo nihilva ksav vilona. ");
INSERT INTO wrs_vpl VALUES ("GN41_7","002_41_7","GEN","41","7","7","Doa honamba witva sahoklal himba nomba witmba besalmba wohhlapiana. Doa kava henga phona, ona pai kava inungpunung vevna. ");
INSERT INTO wrs_vpl VALUES ("GN41_8","002_41_8","GEN","41","8","8","Doa simekumbrava himba ambo duuswonam vevna, wo nonoanindm nom wunuhunna Isiprinim eva indhanam indkumbim, ten ishowol vivm inungpunungna plalm. Hev ishunna inungpunungmom samblam, heva os mongova indhanariniva owai, ishowol vevmoa inungpunungna plalmba. ");
INSERT INTO wrs_vpl VALUES ("GN41_9","002_41_9","GEN","41","9","9","Wo nomba wainpolna kuwulva di lohvna, Perom omnana, daipotava ata yemba kava ishomnavav kavna wevsakoklamba, kav seilm ten venam, men henga kava nengv. ");
INSERT INTO wrs_vpl VALUES ("GN41_10","002_41_10","GEN","41","10","10","Nemetva yimba tandwol vena kamba andranindmba pevnamba, wo yimba kamba mongawulmba rotina kuwuliva buiduvra wolasiha vena. Yena buinindna kuwul kamba kekalvho vrinvna. ");
INSERT INTO wrs_vpl VALUES ("GN41_11","002_41_11","GEN","41","11","11","Doa kava inungpunung evena di buimera, wo kana inungpunungmomba indakonda lohwolinna plalva. ");
INSERT INTO wrs_vpl VALUES ("GN41_12","002_41_12","GEN","41","12","12","Wo nonamba mongova indhanariniva Hiprurini kamba wonavna buimera, he nomba buinindna kuwulna andranindrini, nihilva Yosep. Wo kava ihishomnana inungpunungmomba, doa he hellenamba inungpunungmomba kanam, wo kam ishunna inungpunungna indanam plalva. ");
INSERT INTO wrs_vpl VALUES ("GN41_13","002_41_13","GEN","41","13","13","Wo dawonam, ten hev kam ishunnam buimera, os vinna kam eva rotina kuwulm. Os vinna, ye kam hom wolaihaprana kavna andramba henga, wo rotina kuwulmba yimba vendkleihana. ");
INSERT INTO wrs_vpl VALUES ("GN41_14","002_41_14","GEN","41","14","14","Doa Perova ishonga vemnana Yosepm, wo lelnam angana buiduvram omnahalvolm. Wo Yosepva boasna keuta ningena, ningenamba, kayen besal vewol venamba, wo os himba prona Peroindam. ");
INSERT INTO wrs_vpl VALUES ("GN41_15","002_41_15","GEN","41","15","15","Doa Perova Yosepm omnana, kava inungpunung vena, wo owai, an ata eva ishovav inungpunungna plalva? Wo kam umni, Yosepva inungpunungmomba yenamba hellerava, ata yemba beswonam inungpunungna plalmba ishomnavav, mani hevpa si pimba vinvav. ");
INSERT INTO wrs_vpl VALUES ("GN41_16","002_41_16","GEN","41","16","16","Wo Yosep ona, owai kava, Sesoa hev kamba ishomnavav honamba yenamba inungpunungmomba, wo yemba kava hengava ata os ishomnavav beswonamba. ");
INSERT INTO wrs_vpl VALUES ("GN41_17","002_41_17","GEN","41","17","17","Wo Pero Yosepm ishomnana os, kava inungpunung vevna, Nail popethalla lohv, ");
INSERT INTO wrs_vpl VALUES ("GN41_18","002_41_18","GEN","41","18","18","wo sapiva 7pelarava Nailpomerini pulvona, wo pos himba hlavna. Hemba po ambo pihawol vevna i. ");
INSERT INTO wrs_vpl VALUES ("GN41_19","002_41_19","GEN","41","19","19","Wo henga sism mongo 7pelarava sapi pulvo Nailpomerini, wo almangkelangas, wo himba beswonamba lovahvnamoa. Seilva snamba kava nonglanamoa huiva Isip petharava. ");
INSERT INTO wrs_vpl VALUES ("GN41_20","002_41_20","GEN","41","20","20","Wo sism sapiva almangkelangasva wohwehala vepiana nomba sapimba besalmba. ");
INSERT INTO wrs_vpl VALUES ("GN41_21","002_41_21","GEN","41","21","21","Wo doa hlapianamba, mendah almangkelangasva lovahvna. Kava os nongalvna, mana vemamba mongova hlavnamoa. Doa kava os phona. ");
INSERT INTO wrs_vpl VALUES ("GN41_22","002_41_22","GEN","41","22","22","Doa henga kava ona lithana, henga kava inungpunungva vevna os, witm kava nunglul lohvna, witva nihilva 7pelarava mendekli besal endvna mongawatilla. ");
INSERT INTO wrs_vpl VALUES ("GN41_23","002_41_23","GEN","41","23","23","Wo henga sism pola, tilva mongasal nihilva 7pelara endvna, wo vuvi suwepaval pronamba, wo hemba ksav vilona. ");
INSERT INTO wrs_vpl VALUES ("GN41_24","002_41_24","GEN","41","24","24","Wo honamba witva ksavalva, himba nomba wit besalmba lenuk vepieina. Wo honamba inungpunungmomba kava ishunna kavnamba nonoanindmba, heva os owai, kamba ishumninamoa inungpunungna plalmba, tit viv himba. ");
INSERT INTO wrs_vpl VALUES ("GN41_25","002_41_25","GEN","41","25","25","Wo Yosepva Perom ishomnana, plalva yena inungpunung samblanamba mongongasal. Sesoa hev yemba ishomnana inungpunungra, os hevpa velmba vev. ");
INSERT INTO wrs_vpl VALUES ("GN41_26","002_41_26","GEN","41","26","26","Honamba sapiva besalva 7pelarava lovahv, osm lehvrev, tahonmba si 7pelarava, wo honamba witva besalva 7pelarva endv, osm lehvrev tahonmba si 7pelarava. Inungpunungva samblava yenamba, wo heva os plalva lohv mongasal. ");
INSERT INTO wrs_vpl VALUES ("GN41_27","002_41_27","GEN","41","27","27","Wo honamba sapiva almangkelangasva lovahv, osm lehvrev si tahonmba 7pelarava owai, innehui, wo honamba witva ksavalva endv, osm lehvrev, tahonmba si 7pelarava owai, innehui. ");
INSERT INTO wrs_vpl VALUES ("GN41_28","002_41_28","GEN","41","28","28","Honamba os yemba doa kava ishomani, Sesoa hev yemba ishomnav mana vemamba, hevpa yemba si vaomana vinvav. ");
INSERT INTO wrs_vpl VALUES ("GN41_29","002_41_29","GEN","41","29","29","Wo 7pelarava tahonnamba innemba esvema huiva Isip petharava, Isipna indakonda kembella. ");
INSERT INTO wrs_vpl VALUES ("GN41_30","002_41_30","GEN","41","30","30","Heva os sewonamba si owai, tahonnamba 7pelarava si innehui phovav, wo yimba Isipnindva si ningvavmoa honamba besalva tahonmba. Si owous mendekli yemba nongalphovav 7pelara tahonnamba, wo yimba si maivithivav, honamba besalva tahonmba innemba mindnamba. ");
INSERT INTO wrs_vpl VALUES ("GN41_31","002_41_31","GEN","41","31","31","Manara, honamba owousva sis provav, si sahokla vilovav. ");
INSERT INTO wrs_vpl VALUES ("GN41_32","002_41_32","GEN","41","32","32","Sesoa doa wohnengna, honamba velmba, wo noinda yenamba inungpunungva phona samblalva. Mani wenokombanamma, Sesoava si nonam vevavta. ");
INSERT INTO wrs_vpl VALUES ("GN41_33","002_41_33","GEN","41","33","33","Doa yeoa besal indhanarinim pusvundthoao, ten nonorangas lohvm, nengavnangva besal, wo he si kuwulva yei ewulluhunvav Isipnindnamba. ");
INSERT INTO wrs_vpl VALUES ("GN41_34","002_41_34","GEN","41","34","34","Eva yeoa pusvund veo mendeklimoa mindnam pethanindnamoa. Wo tahonnamba innemba esvema, nomba mendekliva innemba osorava moang vivra. Indakonda osora moang vivra, vevrava, doa 5pelara eunumbulva. ");
INSERT INTO wrs_vpl VALUES ("GN41_35","002_41_35","GEN","41","35","35","Eunumbulva samblasambla mengnam indhanam, wo mongova eunumbulva no mendekliva dumbvra, yem taeksm vinilm. Dumbvrava, doa dawonam iswol vivra mongona tahonnam. Deuvkembella iswol vivra, di no kembella, di no kembella, wo yena keusingi dembhuluhungu vevra, manara, yimba Isipna kuwul wulluhunv. ");
INSERT INTO wrs_vpl VALUES ("GN41_36","002_41_36","GEN","41","36","36","Wo 7pelarava tahonmba si phovrava huiva Isiprava, wo Isipnindva innehui, si dumbvra innemba, noi ten iswol vinam deuvkembella, wo noinda Isipnindva si dalvavmoa no owousrava. ");
INSERT INTO wrs_vpl VALUES ("GN41_37","002_41_37","GEN","41","37","37","Wo Peroi hevna kuwul eusili Yosepm umnina, lehra yimba osva innemomba ishovna. ");
INSERT INTO wrs_vpl VALUES ("GN41_38","002_41_38","GEN","41","38","38","Wo Pero hevna kuwul eusilm ishunna, honamba indhanarinimba Yosepmba, Sesoasongol doa pethamnana, hi eva pimba nunglivav Yosepna nengavnangnamba, owai! ");
INSERT INTO wrs_vpl VALUES ("GN41_39","002_41_39","GEN","41","39","39","Doa Perova Yosepm ishomnana, Sesoangas hev yemba doa ishomnana honamba manam manam, mongova indhanariniva snamba owai, nonorava lohvmoa, osva yimba memba lohvpa. ");
INSERT INTO wrs_vpl VALUES ("GN41_40","002_41_40","GEN","41","40","40","Yem kava mendeklilmba ata pusvundthoavav. Manimani kanamba yena englisra kava holothovav, kekalvho vrowolalm. Wo si indhanamba kanamba lehra eva yena moam hillivav. Kava kuwulnonoa lohv, wo kanamba moangas si yenamba kuvhoavav. ");
INSERT INTO wrs_vpl VALUES ("GN41_41","002_41_41","GEN","41","41","41","Doa yem kava pusvundthoav, ye kuwulva huiva Isiprava si kamba pethamnavav. ");
INSERT INTO wrs_vpl VALUES ("GN41_42","002_41_42","GEN","41","42","42","Doa Perova gamamba mongasal wulavna, gamamba nomba hevna kuwulgama, wo gamamba nomba selvlahanamba hevna englariniva, wo Yosepna englara os vethana. Wo Perova besal kayenmba dombal moanvrahona Yosepmba, eva gol omoriniva hena omora holothomnana. ");
INSERT INTO wrs_vpl VALUES ("GN41_43","002_41_43","GEN","41","43","43","Wo Perova hevna valgonindm ishunna, wo hevna pethamnalmba karismba indthoamnana Yosepm. Unna, honina Yosepmoa waiambo. Wo Yosepva no karisra monam gavna, nomba karisva hosra kiliheinamba, hos kevri iangavna. Wo amiva mi ishuwul anginvna, monaoa wuleihimnu, Yosepva pina kuwulva ten sis prov. Doa plalmomba os lohv, Perova Yosepm pusvundthoana Isipnindna kuwulm mongom. ");
INSERT INTO wrs_vpl VALUES ("GN41_44","002_41_44","GEN","41","44","44","Wo hengava Perova Yosepm omnana, kava mendekli kuwul lohv, wo kava os ov, Isipriniva mongova indhanariniva owai, hevna nengavnangnamba velmba, yemsna heva sahminivra. ");
INSERT INTO wrs_vpl VALUES ("GN41_45","002_41_45","GEN","41","45","45","Doa Pero Yosepm awona, Isipna moana os awona Sapenatpaniam, osm ovna, Sesoa ishomnav hemba. Wo Yosepm ungevlirinim pleihunna, nomba ungevliriniva nihilva Asenat, wo himba Potiperana mol, nomba Potiperava sembayangna andranindrini lohvna di Heliopolis kotara. Wo Yosepva Isipna kuwul wulluhunna. ");
INSERT INTO wrs_vpl VALUES ("GN41_46","002_41_46","GEN","41","46","46","Wo nonamba Yosepna tahonmba 30pelara lohmanavna, wo no andramba os sihana, Perona andrava. Wo himba Peromba dasvholahangana, wo Isipnindna indakonda kembelm nungsis vaomana vevna. ");
INSERT INTO wrs_vpl VALUES ("GN41_47","002_41_47","GEN","41","47","47","Wo nonamba tahonmba 7pelarava innemba esvema phona Isiprava. ");
INSERT INTO wrs_vpl VALUES ("GN41_48","002_41_48","GEN","41","48","48","Doa phonamba, Yosepva meilna vungu vevna innemba esvema, innemba nomba dembhasiha vungu vevna inneduvra, no kembella, no kembella osora murapeta. ");
INSERT INTO wrs_vpl VALUES ("GN41_49","002_41_49","GEN","41","49","49","Innemba esvema meilna vevna, ovna i wan engalmsna, wo Yosepva no innemba sevel loh venamba, doa wuleiha, ambo nis dembrivna. ");
INSERT INTO wrs_vpl VALUES ("GN41_50","002_41_50","GEN","41","50","50","Doa tahonmba innehuinamba mendah pronamoa, wo Asenatva Yosepna ongalva otolmba lengsamba vena tuendisrinim. ");
INSERT INTO wrs_vpl VALUES ("GN41_51","002_41_51","GEN","41","51","51","Doa Yosep ona, Sesoa doa kam waiamana vev, wo noinda kavna kinwonda kava doa wuleihawol vena, kavna aratatanamba kava mendah duus vewol vevmoa. Wo noinda Yosep no hevna yiveltowondmba os awona Manasem, osm ovna, duus vevmoa Yutana moana. ");
INSERT INTO wrs_vpl VALUES ("GN41_52","002_41_52","GEN","41","52","52","Wo sisva henga ongalva tuendisrinim mongom lengsamba vena, wo Yosep ona, Sesoa kam otolm venana huiva, nemetva kamba kinwondava plothomnana. Doa nomba os sisminiva awona tuendisriniva, ona Evraim, osm ovna, otolva phov Yutana moana. ");
INSERT INTO wrs_vpl VALUES ("GN41_53","002_41_53","GEN","41","53","53","Doa tahonmba 7pelarava besalva kohopianamba, ");
INSERT INTO wrs_vpl VALUES ("GN41_54","002_41_54","GEN","41","54","54","wo 7pelara tahonmba innehui phona, os ten doara Yosepva Perom ishomnanam. Wo mendekli owousva phona indakonda no pethara, no pethara, heva os innemba diva esvema kekel vethalohvna Isipnindna indakonda kembellava. ");
INSERT INTO wrs_vpl VALUES ("GN41_55","002_41_55","GEN","41","55","55","Wo Isipnindva hevna osoriniva innemba hlapianamba, doa hev henga Perom kuwulm wi vimnivna, inne kam dembrahunu no pevna inneduvrini. Wo Perova unna, wou boasna ango Yosepindam, hena moam hillimnu. ");
INSERT INTO wrs_vpl VALUES ("GN41_56","002_41_56","GEN","41","56","56","Wo no Isipnindva indkumbi ponda aevulvna, wo Yosepva hevna andranindm unna, wo he tuvm velaihawol vinnamba inneduvrinim, wo indakonda kembelnind di innemba sovawol vivna. ");
INSERT INTO wrs_vpl VALUES ("GN41_57","002_41_57","GEN","41","57","57","Wo eva monglava ungundva saivna di Isip pethara, innem sovawolalm Yosepinda. Manara, owousva indakonda pethara esvema phongana. ");
INSERT INTO wrs_vpl VALUES ("GN42_1","002_42_1","GEN","42","1","1","Owousva phonamba, wo nonamba Yakopva Yosepna aralva di ponda avna hevna pethara Kenanda. Wo sism Yakopva osva hellepra vena, innemba di nalohv, indhanamba noi esvowolka vev Isip petharini. Wo hevna ombolm ishunna, manam hevpa yimba ombamba aevulv? ");
INSERT INTO wrs_vpl VALUES ("GN42_2","002_42_2","GEN","42","2","2","Moamba kava os hellei, innemba Isipra di nalohv. Yeoa angarava, sovawol vihalvo pivm. Si homeis pim mongo dahavm hona owousra. ");
INSERT INTO wrs_vpl VALUES ("GN42_3","002_42_3","GEN","42","3","3","Doa Yosepna etehumunilva 10pelarava angana Isip petharam, innem sovawolalm. ");
INSERT INTO wrs_vpl VALUES ("GN42_4","002_42_4","GEN","42","4","4","Heva os Yakopva velaihanganamoa kalelmba Bensaminmba, manara, hev pepeh vrevna, homeis si mana vema venavm monara. Bensaminmba nomba Yosepna boaslalnonoa himba lohmanavna. ");
INSERT INTO wrs_vpl VALUES ("GN42_5","002_42_5","GEN","42","5","6","Osva Yakopnamba ombolva innem sovawolalm angana Isipram, wo Yosepva di kuwul wulluhunvna, nom indhana innem sovawolalm angalvohvnam. Wo etehumunilva hemba nonglapulvonamba, doa hevna novlomosva pethara woseina. Heva os owai, liheinamoa Yosepmba hevna boaslalmba. ");
INSERT INTO wrs_vpl VALUES ("GN42_7","002_42_7","GEN","42","7","7","Wo Yosepva hevna etehumunilmba nongalnamba, wo lihawol vena, heva os ishunnamoa osva. Owai, hev dandwonam ishunvna, hinimini yimba ambei? Wo hev umnina, Kenandini kava ambei, innem kava sovawolalm viv yeinda. ");
INSERT INTO wrs_vpl VALUES ("GN42_8","002_42_8","GEN","42","8","8","Wo Yosepva lihawol venamba hevna etehumunilmba, heva os etehumunilva liheinamoa hemba, owai. ");
INSERT INTO wrs_vpl VALUES ("GN42_9","002_42_9","GEN","42","9","9","Wo Yosep henga nengna inungpunungmom, wo nengavnang ve. No inungpunungva himba vena, seilva diva aevvnamba Kenandava. Os inungpunung vena, kava etehumunna kuwul wulluhunv. Wo Yosepva nomba ishunnamoa, owai, himba ambo dasalm unna, yimba indhanamba novtatholm vinvna kamba Isipnindmba. Yimba asluwul ambei monam, ora ka owalwolei bunena. ");
INSERT INTO wrs_vpl VALUES ("GN42_10","002_42_10","GEN","42","10","10","Wo he eva umnina, owai, ambo kava innem sovawolalm ambei. ");
INSERT INTO wrs_vpl VALUES ("GN42_11","002_42_11","GEN","42","11","11","Kanamba aralva mongongasal luhunv, kava yunam nongal pethanindva, owai, kava tanam moamba ishowol viv. ");
INSERT INTO wrs_vpl VALUES ("GN42_12","002_42_12","GEN","42","12","12","Wo Yosep unna, owai, yimba asluwulambei monam, ora ka owalwolei bunena. ");
INSERT INTO wrs_vpl VALUES ("GN42_13","002_42_13","GEN","42","13","13","Wo hev una, owai, doarava kava 12pelarava Kenanda di aevulvna, kanamba aralva mongongasal. Wo kana boaslakalelva tendo towondriniva mendah di arali ahav Kenanda. Eva boaslamba mongova doa hoai vena doara. ");
INSERT INTO wrs_vpl VALUES ("GN42_14","002_42_14","GEN","42","14","14","Wo Yosep henga ona, doa kava mongawulm ishoi, yimba hona indhanamba nongal pethanindmangas viv, si tanam yemba os kava vinvav. ");
INSERT INTO wrs_vpl VALUES ("GN42_15","002_42_15","GEN","42","15","16","Boaslapevpa yenamba hom prunda kaindam. Ka nonglalm vev. Hona monana yemba kava si wiyeiwol vevav. Mongo pevrinim vileihingu, omnakarava, waiprora hom, wo yeoa indhanaoa monglaoa hui kana buira aevulo, verava, ka levrapivungunda moam yenam beswonam, verava, ora tanam ora owai. Osva verava, moamba yenamba owaingava, ka beswonam tau vinda yem, yimba nongal pethanind. Ka tanam ishov. ");
INSERT INTO wrs_vpl VALUES ("GN42_17","002_42_17","GEN","42","17","17","Doa osva ishunnamba, doa buimera os wolasiha vena simba samblamongo nin vina. ");
INSERT INTO wrs_vpl VALUES ("GN42_18","002_42_18","GEN","42","18","18","Wo mongnasiva Yosep ishunna, mongmomba yemba kava wuleinv. Kana moamba yimba hillitava, si osva yimba beswonam aevulvav. Manara, kava sembayangba velohmanav Sesoamba, wo hevna moamba kava hellowol vev. ");
INSERT INTO wrs_vpl VALUES ("GN42_19","002_42_19","GEN","42","19","19","Es hevpa yimba tanam ishuvmi? Doa mongongasal yeriniva si avav huiva buiduvra, wo yimba honamba monglava angavav pevindam. Wo inneoa iengilgu ongahmunpevm arapevtatanam, di ten ponda aevulvm. ");
INSERT INTO wrs_vpl VALUES ("GN42_20","002_42_20","GEN","42","20","20","Wo pevna boaslalmoa waiambo kaindam, wo osva kava yemba beswonam lihawol vevav, ora tanam ishuna. Wo yemba si dalvavmoa kana moarava. Doa etehumunilva hillinamba Yosepna moamba, una, lehra, ");
INSERT INTO wrs_vpl VALUES ("GN42_21","002_42_21","GEN","42","21","21","wo hevm hovra ishuvna, tanam pimba piv doara sahonam vina. Tanamolnam pimba piv doara sahokla vrina pivna boaslamba. Pimba mindnam wonewolovna, kam wolaihapulvo mellini, heva os owai, pimba hemba wolaihapulvonamoa no melliniva. Wo deti Sesoava pimba kinmba noinda plothuni, noinda pimba buirava aevulv. ");
INSERT INTO wrs_vpl VALUES ("GN42_22","002_42_22","GEN","42","22","22","Wo Rupen yiveltowond ona, lehra yimba uvta. Os kava yemba ishunna, manam yimba osva sahoklava vrivav Yosepmba pivna boaslamba, heva os owai, yimba kana moamba meishanam pingina. Wo deti Sesoava pimba henga esesm vinv boaslana dahalmba. ");
INSERT INTO wrs_vpl VALUES ("GN42_23","002_42_23","GEN","42","23","23","Wo Yosepva nomba moamba hellevna, manara, hevna moamba memba, Kenannindna moa. Etehumunilva nomba os ningvna, Isipriniva honamba kuwulva, wo tit vev pina moamba. Manara, indhanariniva hovra di avna, etehumunilna moam hillinvna, wo umhravho vrinvna Yosepm Isipnindm. ");
INSERT INTO wrs_vpl VALUES ("GN42_24","002_42_24","GEN","42","24","24","Wo Yosepva etehumunilna no moamba osva hillinnamba, wo nengna, kam ishumniv, wo sandhalahanga, doa osoa wi vena. Doa wi vepianamba, wo henga prunna, wo mongo etelm Simeonmba pusvundthoana, doa polisi wena Simeonmba ningina etehumunilna novra, wo buiram os waiangana hemba. ");
INSERT INTO wrs_vpl VALUES ("GN42_25","002_42_25","GEN","42","25","25","Sism etehumunilnisra Yosep ishunna hevna andranindm, wo andranindva etehumunilna innewondara nunguwul vivna witmovpa. Wo no diwondava etehumunilnamba di nunghupuv vinvna no innewondamera, henona henona, Yosepna moara. Diva nomba himba Yosepm doara dembrahuna no witramba. Etehumunilva tit vivna, dimba hevna wondara nunguluhuku vinvna. Doa inne dembrahunna monaram, ");
INSERT INTO wrs_vpl VALUES ("GN42_26","002_42_26","GEN","42","26","26","wo etehumunilva donkisra di huhlinamba witwondava, doa os anga. ");
INSERT INTO wrs_vpl VALUES ("GN42_27","002_42_27","GEN","42","27","27","Doa sinimba monara shana, wo mongo hevna wondam pevho, doa inne donkim dahwol ona vena. Doa hevna dim nongla innesra, ");
INSERT INTO wrs_vpl VALUES ("GN42_28","002_42_28","GEN","42","28","28","wo unna owalm, nunglu, diva kanamba innenahonam men nungulohv, no diva piv ten Isipna kuwulm dembrahuim inneram. Wo monglava hillinamba honamba, wo undva sahonam luhunvna, wo pemba esvema vivna, wo moamba esvema ishuwul vevna. Hev una, Sesoava manam hevpa pimba osva memba vinv? ");
INSERT INTO wrs_vpl VALUES ("GN42_29","002_42_29","GEN","42","29","29","Doa henga anganamba, Kenanda di pulvona, wo hevna aralm ishumnina, nom hevm ten vinnam. ");
INSERT INTO wrs_vpl VALUES ("GN42_30","002_42_30","GEN","42","30","30","Wo os ishuna, mendekliva Isipnindnamba ishunna kamba esvema, wo kam gekala owol vevna, yimba hona indhanamba nongal pethanind. ");
INSERT INTO wrs_vpl VALUES ("GN42_31","002_42_31","GEN","42","31","31","Wo os kava umnina, kava tanam ishowol viv, kava nongal pethanindma yunam. ");
INSERT INTO wrs_vpl VALUES ("GN42_32","002_42_32","GEN","42","32","32","Kava 12pelara aratindiva lovahna, aralva kanamba mongongasal luhunv. Mongomba doa dahana, eva tendo towondrini kalelva di Kenanda aralm waiav. ");
INSERT INTO wrs_vpl VALUES ("GN42_33","002_42_33","GEN","42","33","33","Doa mendekliva nomba ishunna kamba, yerinioa mongo ka waiai hui buira, wo osva kava si nunglinvav yenamba, ora tanam. Wo monglaoa yeoa witoa dumbu. Dumbrava, doa os iengilgu pevna tomotalm, di ten ponda aevulvm. Doa ango, ");
INSERT INTO wrs_vpl VALUES ("GN42_34","002_42_34","GEN","42","34","34","wo pevna boaslakalelmoa henga waiambo, wo osva kava yemba si lihawol vevav, yimba nongal pethanindva owai, yimba tanam ishowol viv. Wo kava si buiriniva wolaihaphunvav etepevmba yenamba, wo osva yimba si henga innemba sovawol vivav huiva Isiprava. ");
INSERT INTO wrs_vpl VALUES ("GN42_35","002_42_35","GEN","42","35","35","Doa moamba ishopiennamba, ombolva witmovpa sohol vilanganamba wondariniva, wo osva hevna diwondava nungeilvna, diwondava nomba innewondamera doara nunguluhuku velohunvna. Wo araltatanamba dimba nunglivnamba, pem vivna. ");
INSERT INTO wrs_vpl VALUES ("GN42_36","002_42_36","GEN","42","36","36","Wo aral ona, ye vivnamba, kana ombolva noinda hoai vewolna. Seilm doara Yosepva hoai vena, Simeonmba di Isipra hoai vena, wo daipotava yimba hoai velm umniv henga Bensaminmba kanamba ombkalelmba. Yimba kam kinwonda oplothumniv nona. ");
INSERT INTO wrs_vpl VALUES ("GN42_37","002_42_37","GEN","42","37","37","Doa Rupen yiveltowond aralm omnana, aevvra, ka kavho si Bensaminmba beswonam waingavav Isipramba. Si henga kava waiprovav yeindamba homba. Kava waipromba owai vetava Bensaminmba, osoa yeoa kana ombol samblamoa helvakomandhowolo. ");
INSERT INTO wrs_vpl VALUES ("GN42_38","002_42_38","GEN","42","38","38","Wo Yakop ona owai, Bensaminmba ombkalamba yimba waingavavmoa Isipramba, manara, hevna etelmba doa dahana Yosepmba, wo hevho mendah lohv, Reselna kana ongana ombolva. Ata homeis monara mana vema venavm. Kamba doa putowa vena, wo mana vemamba venatava monarava, osva si kamba dahavav. Osva owai. ");
INSERT INTO wrs_vpl VALUES ("GN43_1","002_43_1","GEN","43","1","1","Doa nonamba honamba owousva mendekli phovna Kenan petharava. ");
INSERT INTO wrs_vpl VALUES ("GN43_2","002_43_2","GEN","43","2","2","Wo Yakoptatanamba nomba innemba hlapiana, temba seilmba ihilvonamba nomba Isipriniva, wo Yakopva henga hevna ombolm unna, ango henga Isipram, innepetam sovawolalm pivm. ");
INSERT INTO wrs_vpl VALUES ("GN43_3","002_43_3","GEN","43","3","3","Wo Yuta hovrini aralmba os omnana, yemba doara kava ishumnina, kuwulva nomba Isipriniva ovunna kamba mindnam. Os kamba ishunna, pevna boaslapevmoa hom waiambo, wo manam yimba pevhova ambvav. Yenamba moamba osva kava hillinvavmoa. ");
INSERT INTO wrs_vpl VALUES ("GN43_4","002_43_4","GEN","43","4","4","Wo yimba osva otava, boaslamba Bensaminmba wouta waiangota, osva kava si angavav, innemba sovawolalmba pivmba. ");
INSERT INTO wrs_vpl VALUES ("GN43_5","002_43_5","GEN","43","5","5","Wo yimba Bensaminmba ovotava, osva kava si angavavmoa, owai, manara nomba kuwulva Isipriniva doa kamba ishunna os, manam yimba hengava homba ambvav pevhova, pevna boaslapevmoa waiambo. ");
INSERT INTO wrs_vpl VALUES ("GN43_6","002_43_6","GEN","43","6","6","Wo Yakop ona, manara yimba eva ishumnivna nomba kuwulmba, kanamba mongova boaslalva luhunv? Yimba kamba kin plothumniv nonamba. ");
INSERT INTO wrs_vpl VALUES ("GN43_7","002_43_7","GEN","43","7","7","Wo ombolva una, nomba kuwulva kam sah owol vevna esvema mehonam katatanam. Hev ona, arapevpa mendah yenamba einvma a dahanami? Mongova yenamba boaslalva luhunvma a owaimi? Os sah owol vevna, wo noinda kava ishumnina hemba. Kava tit vina, ata kamba ishunvav, boaslapevmoa waiambo. ");
INSERT INTO wrs_vpl VALUES ("GN43_8","002_43_8","GEN","43","8","8","Wo Yuta henga aralm os ishomnana, yimba otava, wo osva kavna boaslamba Bensaminmba kava waiangavav. Wo os kava angavav mongawulm, innemba sovawolalmba. Wo osva si yemba kana tovotalmba, pimba si dalvavmoa owousrava, owai. ");
INSERT INTO wrs_vpl VALUES ("GN43_9","002_43_9","GEN","43","9","9","Ata kava beswonam waiangavav, wo kava waipromba owai vetava homba yeindamba, osva honamba kana kinmba si wohlohvav, verava, kamba si dahavav. ");
INSERT INTO wrs_vpl VALUES ("GN43_10","002_43_10","GEN","43","10","10","Wenokombo mindnam doa pimba vina, kava henga angav. ");
INSERT INTO wrs_vpl VALUES ("GN43_11","002_43_11","GEN","43","11","11","Doa aral ishunna, honamba osva phovmoa kana moarava, yeoa eva os viuta, manara ponda pimba aevulv. Wo boasna hui dumbu mana ema besal pivna petharini, wo os ianga Isipram, nom kuwulm nis dembreihu. Os yuhvpsu, tenen ten beswonam teihnung vevm, eva timov noi ten hlawol vevm, ");
INSERT INTO wrs_vpl VALUES ("GN43_12","002_43_12","GEN","43","12","12","eva dioa mindnam iango. Honaoa dioa henga iango, temba yena innewondarava Isipnindva nungunamba. Kava tit vev, dihi maivithina, wo noinda osva vina. ");
INSERT INTO wrs_vpl VALUES ("GN43_13","002_43_13","GEN","43","13","13","Wo eva boaslapevmoa Bensaminmoa waiango Isipna kuwulindam. ");
INSERT INTO wrs_vpl VALUES ("GN43_14","002_43_14","GEN","43","14","14","Wo Sesoa mendekli no Isipna kuwulna undmba weihaloh vremnara, wo himba si osva yemba wavra vovhoawol vinvav. Wo osva si Simeonmba phovav, temba buirava Isiprava livpa, wo eva Bensaminmba henga si homba provav beswonam. Wo mongova kanamba ombolva hoai vetava, kavkolo, si kamba wohdahavav. Doa angota. ");
INSERT INTO wrs_vpl VALUES ("GN43_15","002_43_15","GEN","43","15","15","Wo ombolva no denwit nunguwul vinamba, diva mindnam nunguwul vina, os angana, Bensaminmba waianganata. Anganamba, Isipra di kuwulm henga nonglapulvo. Mendah tit vrivna no kuwulmba Yosepmba hevna boaslalmba. ");
INSERT INTO wrs_vpl VALUES ("GN43_16","002_43_16","GEN","43","16","16","Wo Yosepva nongalna, ten hevna boaslalmba waiambvna, wo hev omnana andranindrinim, no hevnam deuvm kekalvho vremnavm, honaoa indhanamoa kana deuvram wongao, sapi mongo lurava os ningehu, honamba indhanamba ata kava wonnevav okomba hovranam. ");
INSERT INTO wrs_vpl VALUES ("GN43_17","002_43_17","GEN","43","17","17","Doa andranindriniva os vena, Yosep ten ishomnanam, etehumunilm wongamnana Yosepna deuvram. ");
INSERT INTO wrs_vpl VALUES ("GN43_18","002_43_18","GEN","43","18","18","Wo monam wongavna, etehumunilva pem vivna, hevm ishuna os, doara pina diva innewondamera hev dembhisuv vinna, wo himba honam nengnamba, wo pimba wonprov hona deuvramba. Ata pimba lelnam helvawol vivav, wo pimba ata andranindilm kekaiv vivav, eva pivna donkinahonam. ");
INSERT INTO wrs_vpl VALUES ("GN43_19","002_43_19","GEN","43","19","19","Wo tuvra doa saivvnamba, himba deuv kekalvhonindrinim di umnina os, yeoa kana moam hillinvm. ");
INSERT INTO wrs_vpl VALUES ("GN43_20","002_43_20","GEN","43","20","20","Nemetva kava hom Isipram ambna, innemba dina sovawolalmba, dina sovawol vinamba, ");
INSERT INTO wrs_vpl VALUES ("GN43_21","002_43_21","GEN","43","21","21","doa henga Kenandam os kavindam iangavna. Wo di monara shavna, wo diva kanamba innewondamera kava nungeilna. Indakonda nunguluhuku vinvna, diva kanamba mongova shelohnamoa. Daipotava diva nomba henga kava iambi yeindam. Kava tit viv, an dihi diva dembhisiha vena? ");
INSERT INTO wrs_vpl VALUES ("GN43_22","002_43_22","GEN","43","22","22","Wo mongova diva kava men doa iambi, innem sovawolalm henga. ");
INSERT INTO wrs_vpl VALUES ("GN43_23","002_43_23","GEN","43","23","23","Wo andranindrini unna, manam yimba duus vivav. Dihi Sesoa hev nengna, yemba beswonam vinna, no Sesoamba arapevpa yenamba sahlohmanav. No diva yenamba doara ka dombna, innem sovawolalm, manapenam. Doa andranindrini buiram gana, ganamba, Simeonmba wolaihapho, henga sis waipro, dom mongla etehumunil ten aevulvnam. ");
INSERT INTO wrs_vpl VALUES ("GN43_24","002_43_24","GEN","43","24","24","Wo no andranindriniva Yosepna etehumunilm wonsihana Yosepna deuvra, wo po vrahunna, monglam nonam poswolalm, eva etehumunilna donkim inne dahwol vinna. ");
INSERT INTO wrs_vpl VALUES ("GN43_25","002_43_25","GEN","43","25","25","Wo etehumunilva denwit meilna vivna, wondamerini dumbvna, ten iambnam Kenandini. Manara, doa hilli, mendekli kuwulva ata provav, ata hevm wonnevav okomba hovranam. ");
INSERT INTO wrs_vpl VALUES ("GN43_26","002_43_26","GEN","43","26","26","Wo Yosep prona, doa denwit noi dembreimnina, wo hev ku kusithapramna petharam, manara himba mendekli. ");
INSERT INTO wrs_vpl VALUES ("GN43_27","002_43_27","GEN","43","27","27","Wo Yosep moaivrowonam sah owol vevna, yimba beswonam aevulvma, eva arapevpa yenamba beswonam einvma, ten nemet pev kam ishumninam? ");
INSERT INTO wrs_vpl VALUES ("GN43_28","002_43_28","GEN","43","28","28","Wo etehumunilva una, kanamba aralva beswonam einv di Kenan pethara. Wo henga ku kusithapramna Yosepm. ");
INSERT INTO wrs_vpl VALUES ("GN43_29","002_43_29","GEN","43","29","29","Wo Yosep nonglana, Bensaminmba boaslakalelva men wailovahv etehumunil, wo unna, yena boaslapevpa hi, ten doara yepev kam ishumninam. Wo Bensaminm omnana, tuendisrini, Sesoa hev yemba wavra vovhoamnara, wo beswonam yimba huiva avav. ");
INSERT INTO wrs_vpl VALUES ("GN43_30","002_43_30","GEN","43","30","30","Wo Yosep und vevna hevna boaslalmba, wo lelnam wivelm vevna, wo noinda sandhalaha sihana hevna deuvmeram, di poaita wo vawovna. ");
INSERT INTO wrs_vpl VALUES ("GN43_31","002_43_31","GEN","43","31","31","Doa Yosepva wo vepianamba, wemba wuleihanamba, doa wenopva pora poswol venamba, henga os prona deuvmeriniva. Phonamba, hevna andranindm unna, inne kam hui meyasra dembhimnu. ");
INSERT INTO wrs_vpl VALUES ("GN43_32","002_43_32","GEN","43","32","32","Doa Yosepva hevna meyara avhoanamba hevho, wo murapeta di etehumunilva aevulthana mongona meyara hevho. Wo mongnahalva Isipnind aevulthangana, ten Yosepna deuvra shalvohvnam. Noinda osva vina, Isipnindva doara ovuvna, mongawulmba manam innemba wonhlavav Hiprunindmba. ");
INSERT INTO wrs_vpl VALUES ("GN43_33","002_43_33","GEN","43","33","33","Wo Yosepna moara andranindriniva etehumunilm hena meyara sandhana. Yosepna novlomossis sandhana os, miva etelm desvhoana, hovrava hovrinim sandhana, wo mullava Bensaminm boaslanonoam desvhoana. Wo etehumunilva hevm anongla venamba, pai, es hevpa honamba Isipna kuwulva pimba beswonamba levrapiawol vena, etel memba, hovrini memba, kalel memba, avamba pimba os tetwond vivna? Noinda osva una, mendah tit vivna, kuwulva Yosepva hevna boaslalmba. ");
INSERT INTO wrs_vpl VALUES ("GN43_34","002_43_34","GEN","43","34","34","Wo Yosep ona, wo andranind noi inne dumbe Yosepna meyarini, etehumunilmba lesowol vina hevna meyasra, wo Bensaminmba mindnam lisminina. Wo os innemba hlavna Yosepmongo, os ningvna lehra hevm. ");
INSERT INTO wrs_vpl VALUES ("GN44_1","002_44_1","GEN","44","1","1","Innemba hlapianamba, doa Yosep omnana andranindrinim, wondara inneoa nunguwul vinu, honaoa indhanaoa mindnam ata iangavav. Eva henga hena diwondava nunguwul vungu vinu, henona, henona hevna innewondamera, inneram noi kam dembrahuim. ");
INSERT INTO wrs_vpl VALUES ("GN44_2","002_44_2","GEN","44","2","2","Wo eva kana mokoa no tuendisrinina wondamera yeoa euvnongaihu dinahonam. Mokva nomba kanamba besal. Etehumunilna aongrava ishonamoa. Wo andranindriniva os vena, Yosep ten ishomnanam. ");
INSERT INTO wrs_vpl VALUES ("GN44_3","002_44_3","GEN","44","3","3","Simolnamba etehumunilmba wolanga vena, wo hevna donkira himba angana. ");
INSERT INTO wrs_vpl VALUES ("GN44_4","002_44_4","GEN","44","4","4","Doa kembellini pulvolaha anganamba, wo mendah okla angavna, doa Yosep di hevna deuvra andranindrinimba omnana, yeoa phorava, honam pethanginu. Wo yimba nongallava, di osihinu os, manara yimba kuwulna mokva komandhul angav? Hevpa yemba beswonam vinna, yimba sahokla vri hemba. ");
INSERT INTO wrs_vpl VALUES ("GN44_5","002_44_5","GEN","44","5","5","Kuwulva no mokna nelohv pomba, wo wulalohv, nengam osm noinda novngings sowara nonglavav, osva mana vemamba si phovav. Yimba ambo mindnam tetevul vriv. ");
INSERT INTO wrs_vpl VALUES ("GN44_6","002_44_6","GEN","44","6","6","Wo Yosepna andranindriniva engilguanamba, di nongalpho monara. Doa phonamba, hem ishunna Yosepna honi moamba. ");
INSERT INTO wrs_vpl VALUES ("GN44_7","002_44_7","GEN","44","7","7","Wo etehumunilva andranindrinimba umnina, owai, es eva yimba nengi, temba osva yimba ovnamba, kava es ata yenamba komandhita? ");
INSERT INTO wrs_vpl VALUES ("GN44_8","002_44_8","GEN","44","8","8","Yimba kamba doa nonora luhunv, henga kava ambna Kenandini yeindam, eva henga kava yemba dembreihuna diva, ten kava wondamera doara nunglinam. Wo es hevpa yimba ovna, kava sen gol yena kuwulna deuvriniva ata es komaita? ");
INSERT INTO wrs_vpl VALUES ("GN44_9","002_44_9","GEN","44","9","9","Yimba nonglatava, honamba mokva kariniva huiva mongova wulluhtava, nomoa indhanarinimoa dahara, wo si kava yena andranindilm wohlovahvav. ");
INSERT INTO wrs_vpl VALUES ("GN44_10","002_44_10","GEN","44","10","10","Wo andranindriniva os opla vrinna, ona moamba yenamba lehra. Kava nonglatava hona mokmba, mongova yeriniva wulluhtava, nongas si andranindilmba kanamba wohlohvav, eva yimba monglava ata angavav arapevindam. ");
INSERT INTO wrs_vpl VALUES ("GN44_11","002_44_11","GEN","44","11","11","Wo lelnam innewondam etehumunilva dembhivna henoi henoi pethara, wo pawol vilangana indakonda. ");
INSERT INTO wrs_vpl VALUES ("GN44_12","002_44_12","GEN","44","12","12","Wo Yosepna andranindriniva himba Yosepna mokm silelvna wondamera, os seilva yiveltowondinda, venamba, os novvungana hovramininda, venamba, kalelna wondara euvvrana Bensamininda. ");
INSERT INTO wrs_vpl VALUES ("GN44_13","002_44_13","GEN","44","13","13","Etelva nunglinamba di, os mindnam duus vivna, doa hevna kayen popowol vina. Manara, undva sahonam vrivna, pina boaslamba mani ata vinivav. Wo hevna innewonda henga donkisra sena huhlina, wo monara ehhalvona, henga os angana kuwulindam. ");
INSERT INTO wrs_vpl VALUES ("GN44_14","002_44_14","GEN","44","14","14","Wo etehumunilva anganamba, Yosepna deuvra di pulvo, mendah avna Yosepva. Wo Yosepnapenam pem vendral ve pethara, ");
INSERT INTO wrs_vpl VALUES ("GN44_15","002_44_15","GEN","44","15","15","doa Yosep unna, yimba yukov vi, kana mokva komendhi. Yimba kamba saivmonavmoa, osva kava novngingssowara nongalv, mana vemamba yimba vivpa. ");
INSERT INTO wrs_vpl VALUES ("GN44_16","002_44_16","GEN","44","16","16","Wo Yuta hovrini ophona, es ata yemba kava umnivav, owai. Honamba ata kava es sishona vrivav? Sesoava hevpa doa kanamba wevsakoklamba doaraminiva ambara vithini, wo noinda honatongova osva phov. Kava indkumbi si os wohlovahvav yena andranindilm. ");
INSERT INTO wrs_vpl VALUES ("GN44_17","002_44_17","GEN","44","17","17","Wo Yosep ona, owai osva, es hevpa osva kava vevav. No pevna boaslalangas si andranindilmba lohvav, ten mok hena wondamerini euvvreim, wo yeoa monglaoa ango henga pevna arapevindam. ");
INSERT INTO wrs_vpl VALUES ("GN44_18","002_44_18","GEN","44","18","18","Wo Yuta Yosepm murapetam engpranamba, ona, kamoa nunglulihao, mongawulm ye ka ihishoi. Yimba kuwul hevm, os Pero men, heva os yimba manam kamba koasvevav. ");
INSERT INTO wrs_vpl VALUES ("GN44_19","002_44_19","GEN","44","19","19","Nemetva yimba kamba osihinna os, arapevpa yenamba einvma, boaslalva yenamba luhunvma a owaimi? ");
INSERT INTO wrs_vpl VALUES ("GN44_20","002_44_20","GEN","44","20","20","Wo kava una, kana aralva mundkolal einv, eva boaslalva kanamba mongova tendo towondrini kalel luhunv. Avamba hem sleihana, nonamba aramba doa mundkola vevna. Etelnonoamba doa dahana doara Yosepmba, wo boaslalangas mendahva lohv mongawa moshrini, nihilva Bensamin. Wo aramba nomba ombolmba mindnam und vevna. ");
INSERT INTO wrs_vpl VALUES ("GN44_21","002_44_21","GEN","44","21","21","Wo yimba mendekli lohv, yimba pevpa kamba os ishunna, nomba boaslapevmoa hom waiambo, ka nonglatam hui boasna. ");
INSERT INTO wrs_vpl VALUES ("GN44_22","002_44_22","GEN","44","22","22","Wo henga yemba kava ishumnina, aramba nomba ombolmba nunglulihavmoa. Osva nunglulihatava, si osva aramba dahavav. ");
INSERT INTO wrs_vpl VALUES ("GN44_23","002_44_23","GEN","44","23","23","Wo yimba kamba ishunna, pevna boaslapevmoa waiambo, manam yimba pevhova homba Isipramba ambvav, hengava innemba sovawolalmba, owai. ");
INSERT INTO wrs_vpl VALUES ("GN44_24","002_44_24","GEN","44","24","24","Wo kava kavna araindam Kenandam henga anganamba, os ishopulvomnana aramba, kam ten ye ishunnam. ");
INSERT INTO wrs_vpl VALUES ("GN44_25","002_44_25","GEN","44","25","25","Wo dawonam ara ona, yeoa Isipram henga ango, henga innepetam sovawolalm pivm. ");
INSERT INTO wrs_vpl VALUES ("GN44_26","002_44_26","GEN","44","26","26","Wo kavna aram kava umnina, ata kava angavavmoa, manara kavhova kava angatava, osva Isipna kuwulva kamba moamba ishunvavmoa, owai. ");
INSERT INTO wrs_vpl VALUES ("GN44_27","002_44_27","GEN","44","27","27","Wo kavna aramba os kamba unna, yimba nonora av, honamba Reselva kana ango ombol samblam slethana, ");
INSERT INTO wrs_vpl VALUES ("GN44_28","002_44_28","GEN","44","28","28","wo mongova Yosepva doa kamba dasvholahangana, wo hengava kava nonglanamoa, owai. Os kava nengna, sungeitwinde doa winena. ");
INSERT INTO wrs_vpl VALUES ("GN44_29","002_44_29","GEN","44","29","29","Eva ombmba mongova Bensaminmba yimba waiangalmba vev oklam kanaminiva. Wo monara mana vemamba hemba venatava, yimba kamba osva kinwonda plothumnivav. Doa kamba putowa vena, wo os si kava undva vovhoarava, osva kamba si lelnam dahavav. ");
INSERT INTO wrs_vpl VALUES ("GN44_30","002_44_30","GEN","44","30","31","Wo Yuta mendah Yosepm ishomnavna os, kavhova hengava kava angatava kavna araindamba, eva aramba kamba os nongallava, hona tuendisrinimba Bensaminmba waiambvmoa, wo si os dahavav. Manara, arana undva hona tuendisrininapopol lohmanav. Aramba si indvawarava, daha. ");
INSERT INTO wrs_vpl VALUES ("GN44_32","002_44_32","GEN","44","32","32","Os kava kavna aramba wohishomnana, osva kava waipromba owai vetava honamba tuendisrinimba, honamba kana kinmba si wohlohvav, verava, kamba dahavav. ");
INSERT INTO wrs_vpl VALUES ("GN44_33","002_44_33","GEN","44","33","33","Wo noinda osva kava yemba osahmanav, honamba tuendisrinimba Bensaminmba henga araindam etehumunil daha waiangavma, wo eva kavpa yena andranindilm wohlohvav hena vuhera? ");
INSERT INTO wrs_vpl VALUES ("GN44_34","002_44_34","GEN","44","34","34","Kava kavhova gavavmoa araindamba. Manara, aramba henaslalm av, wo es eva kava osva nonglavav kavna aranamba novlomosmba, osva si sahonam. ");
INSERT INTO wrs_vpl VALUES ("GN45_1","002_45_1","GEN","45","1","1","Doa Yutava ishopianamba, wo Yosepva wivelm vevna, wo hevna andranindm ishunna pulvo, noinda vena, ata homeis ka wivevm hona andranindna novra. Wo andranindva os pulvonamba, wo Yosepva hevho hevna etehumunilm wonavna. ");
INSERT INTO wrs_vpl VALUES ("GN45_2","002_45_2","GEN","45","2","2","Wo Yosepva esvema wivenamba, wo Isipnindva hemba ambo hillina, wo hona hena wemomba ganamba, di pho Peroinda. ");
INSERT INTO wrs_vpl VALUES ("GN45_3","002_45_3","GEN","45","3","3","Wo Yosepva wivevna, hevna etehumunilm os ishunvna, kava yena boaslal Yosep luhunv, pina aramba mendah einvmi dahanami? Wo etehumunilva mindnam pem vivna, hengava opla vrimninamoa. ");
INSERT INTO wrs_vpl VALUES ("GN45_4","002_45_4","GEN","45","4","4","Wo Yosep henga unna, hom ambo, wo doa murapetam dom anganamba, wo Yosep henga unna, kava yena boaslal Yosep luhunv. Nemetva yimba kamba wuleihinna no Ismaelnindm, wo yimba diva dumbna kainda. Wo himba kamba waiambna hom Isipram. ");
INSERT INTO wrs_vpl VALUES ("GN45_5","002_45_5","GEN","45","5","5","Yimba kamba os sahonam vrivna, heva os manam yimba sahonamba undva vivav. Wo pevmba manam yimba musk vivav hona sahoklarava, nemetva pevpa temba kamba vininamba, owai. Manara, Sesoa hev kam wolaihaprana homba Isipramba, yena englana vinna. Manara, hev nengna, si homeis pina aratatanamba owousra dalvm. ");
INSERT INTO wrs_vpl VALUES ("GN45_6","002_45_6","GEN","45","6","6","Tahonmba sambla owousva doa phona hona petharava, eva henga si tahonmba 5pelara phovav, wo nonamba indhanamba osoriniva innemba dombawuvavmoa. ");
INSERT INTO wrs_vpl VALUES ("GN45_7","002_45_7","GEN","45","7","7","Sesoa doara hev honamba nengna, wo kam mi doa wolaihaprana hom Isipram, wo noinda yemba dalvavmoa si owousrava, owai. Memba Sesoana wevsa prov, wo pimba luklukul vithiv, besal. Si yimba indkolava beswonam aevulvav, manara, kava kuwul, wo innemba mindnam kava doa inneduvra meilna vena hui Isipra. ");
INSERT INTO wrs_vpl VALUES ("GN45_8","002_45_8","GEN","45","8","8","Ye yunam kamba wolaihambnama, owai, Sesoa hev kamba wolaihaprana homba. Wo Sesoa kamba os pusvundthoana Perona engphol. Kava Perona deuvkelvholm lohv, kava Isipna kuwul wulluhunv pethanahonam. ");
INSERT INTO wrs_vpl VALUES ("GN45_9","002_45_9","GEN","45","9","9","Yeoa lelnam ango pivna araindam, wo os ishumnu, honamba moamba memba pevna ombpovnamini Yosepnamini. Kamba Sesoa pusvundthoana Isipnindna kuwulalm. Manam yimba wowonamba vivav, nungi henga lelnam hom ambo kaindam. ");
INSERT INTO wrs_vpl VALUES ("GN45_10","002_45_10","GEN","45","10","10","Si yimba aevulthavav kainda murapeta di Gosen pethara. Ye, yena tomotal, ongal, pevna ombolna towandal, yena meme sipsip sapi manimani, wo wonambpiao, hui murapeta kainda aevultho daha. ");
INSERT INTO wrs_vpl VALUES ("GN45_11","002_45_11","GEN","45","11","11","Gosen petharava yimba aevultharava, yem kava si wonalohvra. Tahonmba 5pelara si phovav innehuiva, wo kava osva ovov, pevm eva pevna ongatowondalm sipsipm memem sapim manimani ponmba vintava. ");
INSERT INTO wrs_vpl VALUES ("GN45_12","002_45_12","GEN","45","12","12","Wo Yosep hevna etehumunilm unna, doa yimba kamba wohlihipiei. Yimba henga pivna araindava pulvorava, ");
INSERT INTO wrs_vpl VALUES ("GN45_13","002_45_13","GEN","45","13","13","ishumnu os, Yosepva daipotava kuwulva mendekli wulluhunv Isipnindnamba. Eva ishumnu manam manam, doa memba yimba nunglipieina. Doa lelnam ango, omnahalvorava, waiambo. ");
INSERT INTO wrs_vpl VALUES ("GN45_14","002_45_14","GEN","45","14","14","Wo Yosepva hevna boaslalnonoam sendara otho Bensaminm, os indk vethavna, wo Bensaminmba eva osta. ");
INSERT INTO wrs_vpl VALUES ("GN45_15","002_45_15","GEN","45","15","15","Doa Yosepva os kakaiv vungavna hevna etehumunilmba, indk vethavna, wo sism hev waiishuvna Yosepmba. ");
INSERT INTO wrs_vpl VALUES ("GN45_16","002_45_16","GEN","45","16","16","Doa Perova hevna deuvra hellena, Yosepna etehumunilva aevulvna Yosepna deuvra. Wo Pero, hevna kuwul eusil os vivna, lehra, ");
INSERT INTO wrs_vpl VALUES ("GN45_17","002_45_17","GEN","45","17","17","wo Perova moamba ishonga vemnana Yosepm os, etehumunpevoa yenaoa innewondava huhlira donkiramoa, doa Kenandam henga angara, ");
INSERT INTO wrs_vpl VALUES ("GN45_18","002_45_18","GEN","45","18","18","hevna aralm otomotalm hevnam kaindam henga hom wonambra. Si kava Isipna besal pethava hemba kovorahunvav, wo si himba innemba besal huiva hlavav. ");
INSERT INTO wrs_vpl VALUES ("GN45_19","002_45_19","GEN","45","19","19","Yeoa etehumunpevm henga ishundava, hui dumbra karisoa, nomba sapi kevri iangav. Dumbrava, wo os iangavra Kenandam, wo nona si hevna aralm ongalm otomotalm hom wonambvav Isipram. ");
INSERT INTO wrs_vpl VALUES ("GN45_20","002_45_20","GEN","45","20","20","Wo wohva manam iambvav homba, owai, di dembralaha ambo. Noinda vira, hui besal himba si dumbvav wohva besal Isiprini. ");
INSERT INTO wrs_vpl VALUES ("GN45_21","002_45_21","GEN","45","21","21","Wo Yosepna etehumunilva os vina, Perova ishunnamba. Wo Yosep hemba karisva kovorembrahunna, nomba sapi kevri iangav. Eva himba mongla inne dembrahunna, monaram hevm hlalm. ");
INSERT INTO wrs_vpl VALUES ("GN45_22","002_45_22","GEN","45","22","22","Eva Yosepva moang vinna indakonda kayenmba hevna etehumunilmba, wo hevna boaslalmba 5pelara dembrahona, eva senmba 300pelara dembrahona. ");
INSERT INTO wrs_vpl VALUES ("GN45_23","002_45_23","GEN","45","23","23","Doa Yosepva dembhanga venana esvema besalva wohva Isipriniva, hevna aralm dembhanga venana. Wo no wohva donkiva 10pelara os iangavna. Wo himba hevna aralm dembhanga venana innemba mindnam, monaram osm hilwul ambalm, Kenandini Isipram ambvram. Himba roti witmov innemba manimani noi dembhanga venana, wo monglava donkiavalva 10pelara wulangavna innenahonam. ");
INSERT INTO wrs_vpl VALUES ("GN45_24","002_45_24","GEN","45","24","24","Doa Yosepva hevna etehumunilmba wolanga vena, ishunna, yeoa ango, manam yimba pevmba anonglamana ovovav monarava, temba pevpa doarava kamba vininamba, owai, maivithu. ");
INSERT INTO wrs_vpl VALUES ("GN45_25","002_45_25","GEN","45","25","25","Wo os etehumunilva Isipriniva vinamba, Kenandam aralm os enggina, no innemba wohva iangana. Doa himba nonglapulvonamba, ");
INSERT INTO wrs_vpl VALUES ("GN45_26","002_45_26","GEN","45","26","26","hev umnina, Yosepva yena ombpovpa kana boaslamba dahanamoa doarava, owai, mendah beswonam lohv. Wo daipotava himba kuwul wulluhunv Isipnindnamba. Wo Yakopva hellenamba, meng pawovna, os hev nengvna, gekala uv. ");
INSERT INTO wrs_vpl VALUES ("GN45_27","002_45_27","GEN","45","27","27","Wo henga ombtowondalva aralm ishumnina, os Yosep ten Isipra ishunnam. Wo Yakop nongalna karismba, ten Yosepva dembhapra venam, hevm henga nona Isipram waiangavavm. ");
INSERT INTO wrs_vpl VALUES ("GN45_28","002_45_28","GEN","45","28","28","Wo os hevm vevna, lehrangas, tanamolnam Yosepva kana ombolva mendah beswonam lohv. Ka boasna nonglakai, wo os kamba daha dahavma. ");
INSERT INTO wrs_vpl VALUES ("GN46_1","002_46_1","GEN","46","1","1","Wo Yakopva hevnamba meilna vevna manimani, venamba, doa nongana Kenandini Isipram. Boasna Bersepa pethara pulvonamba, wo di tatamba wuweihana, wohweisumbulona, nona Sesoam sembayang venavna, hevna aral Isak doara os vaomana venam. ");
INSERT INTO wrs_vpl VALUES ("GN46_2","002_46_2","GEN","46","2","2","Wo sinim Yakopva inungpunung vevna, wo Sesoa os omnana, Yakop. Wo Yakop henga ona, men kava av. ");
INSERT INTO wrs_vpl VALUES ("GN46_3","002_46_3","GEN","46","3","3","Wo hev opla vremnavna, kava Sesoa, te kam pevna aral Isak sembayang doara velohmanavnam. Manapenam yimba vevav, Isipram wohgao, wo di Isiprava yemba si os kava awothovav, yetindiva si mindnam phovav eva indpetama. ");
INSERT INTO wrs_vpl VALUES ("GN46_4","002_46_4","GEN","46","4","4","Kav yemba ata wongavav honaminiva Isipram, wo kav yetindimba sewonam si henga Isipriniva Kenan petharam wonprovav. Yemba daharava, Yosep hev si yemba singvevav. ");
INSERT INTO wrs_vpl VALUES ("GN46_5","002_46_5","GEN","46","5","5","Doa mongnasiva hevna ombolva Yakopmba desvhueina karisra, doa ombolna ongal, ombolna otol, himba aevulthana karisra, te Pero dembhapra vinnam. Wo osva Yakopva Bersepamba wuleihanamba, Isipram os nongana. ");
INSERT INTO wrs_vpl VALUES ("GN46_6","002_46_6","GEN","46","6","6","Wo himba hevna sapiva wohva manimani iangana, ten Kenanda doara dumbnam. ");
INSERT INTO wrs_vpl VALUES ("GN46_7","002_46_7","GEN","46","7","7","Wo os Isipram Yakoptindiva angana. ");
INSERT INTO wrs_vpl VALUES ("GN46_8","002_46_8","GEN","46","8","8","Men nihilva lovahinv Yakopna towandalnamba, honam wongana Isipramba. Yakopva seilva Leam vrana, wo yiveltowondva tendorini Rupen. ");
INSERT INTO wrs_vpl VALUES ("GN46_9","002_46_9","GEN","46","9","9","Rupenna ombolva Hanok, Palu, Hesron, Kalmi. ");
INSERT INTO wrs_vpl VALUES ("GN46_10","002_46_10","GEN","46","10","10","Wo Simeon hovriniva lohna, eva hena ombtowondal Yemuel, Yamin, Ohat, Yakin, Sohar, Saul. Saulnamba avalva Kenanongorini. ");
INSERT INTO wrs_vpl VALUES ("GN46_11","002_46_11","GEN","46","11","11","Wo Levi hovriniva lohna, eva hevna ombtowondalva Gelson, Kohat, Merari. ");
INSERT INTO wrs_vpl VALUES ("GN46_12","002_46_12","GEN","46","12","12","Wo Yuta hovriniva lohna, eva hena ombtowondalva Er, Onan, Sela, Peres, Sera. Erimba Onanimba honamba samblamba Kenanda doara endahawolna. Peresna ombolva sambla Hesron, Hamul. ");
INSERT INTO wrs_vpl VALUES ("GN46_13","002_46_13","GEN","46","13","13","Wo Isakar hovriniva lohna, eva hevna ombolva Tola, Puva, Yop, Simron. ");
INSERT INTO wrs_vpl VALUES ("GN46_14","002_46_14","GEN","46","14","14","Wo Sepulun kalelva lohna, eva hena ombtowondalva Seret, Elon, Yalel. ");
INSERT INTO wrs_vpl VALUES ("GN46_15","002_46_15","GEN","46","15","15","Rupen Simeon Levi Yuta Isakar Sepulun nomba ombolva Lea towand vena, di mendah aevulvna Mesopotamia pethara, eva molva mongasal sleihana Dinam. Yakopina Leaina towandalva os lovahvna 33pelara. ");
INSERT INTO wrs_vpl VALUES ("GN46_16","002_46_16","GEN","46","16","16","Wo mongova Yakopna ongalva ana Silpa. Silpanamba sambla, Gat eva Aser. Gatna ombolva mindnam, Sipion, Haki, Suni, Espon, Eri, Aroti, Areli. ");
INSERT INTO wrs_vpl VALUES ("GN46_17","002_46_17","GEN","46","17","17","Wo Aserna ombolva mindnam, Imna, Isva, Isvi, Beria, molva mongasal Sera. Beriana ombolva sambla Heper, Malkel. ");
INSERT INTO wrs_vpl VALUES ("GN46_18","002_46_18","GEN","46","18","18","Honamba 16pelarava towandalva Silpana, nomba Silpava himba andranind unguvlirini, ten Lapan Leam hevnam molm pelvrahonam. ");
INSERT INTO wrs_vpl VALUES ("GN46_19","002_46_19","GEN","46","19","19","Wo mongova Yakopna ongalva ana Resel. Reselva slethana samblam Yosepm, Bensaminm. ");
INSERT INTO wrs_vpl VALUES ("GN46_20","002_46_20","GEN","46","20","20","Yosepva ango vrana Asenatm di Isipra, wo ombolva sambla slethana Manasem, Evraim. Asenatva nomba Potiperana mol, Potiperva nomba sembayang andranindrini di Heliopolis kotara lohvna. ");
INSERT INTO wrs_vpl VALUES ("GN46_21","002_46_21","GEN","46","21","21","Wo Bensaminna ombolva mindnam, Bela, Beker, Aspel, Gera, Naman, Ehi, Ros, Mupim, Hupim, At. ");
INSERT INTO wrs_vpl VALUES ("GN46_22","002_46_22","GEN","46","22","22","Honamba 14pelarava Yakopina Reselina towandal os phunna. ");
INSERT INTO wrs_vpl VALUES ("GN46_23","002_46_23","GEN","46","23","23","Wo mongova Yakopna ongalva ana Bilha. Bilhana towandalva os Dan, Naptali. Danna ombolva mongasal Husim, ");
INSERT INTO wrs_vpl VALUES ("GN46_24","002_46_24","GEN","46","24","24","wo Naptalina ombolva os Yasel, Guni, Yeser, Silem. ");
INSERT INTO wrs_vpl VALUES ("GN46_25","002_46_25","GEN","46","25","25","Honamba 7pelarava ombtowondalva Bilhana, no Bilhava himba andranind unguvlirini, ten Lapan Reselm hevnam molm pelvrahonam. ");
INSERT INTO wrs_vpl VALUES ("GN46_26","002_46_26","GEN","46","26","26","Doa Yakopna towandalva os lovahna 66pelara, ten Isip petharam wohanganam. Wo Yakopna kolva indanam, huiva moakot vivmoa. ");
INSERT INTO wrs_vpl VALUES ("GN46_27","002_46_27","GEN","46","27","27","Wo Yosepna ongalva samblam slethana di Isipra tuendisrini samblam, wo osva Yakoptindimba 70pelara lovahna, di Isipra aevulthana. ");
INSERT INTO wrs_vpl VALUES ("GN46_28","002_46_28","GEN","46","28","28","Wo Yakopva Gosenda wonphona, Yutam ombolm mi wolaihanga, Yosepm sahmonalm. Yutava ga, Yosepm nonglapho di kembella, ishomnana, Gosen petharam dom gao, aram di anongla veo monara. ");
INSERT INTO wrs_vpl VALUES ("GN46_29","002_46_29","GEN","46","29","29","Wo Yosepva hevna karisra siha, Gosendam os gana. Phonamba, aralm monara anongla ve, wo lelnam sendara otho, indk vethavna. ");
INSERT INTO wrs_vpl VALUES ("GN46_30","002_46_30","GEN","46","30","30","Wo Yakop Yosepm ishomnana, kamba osva dahavra, yemba doa kava henga nonglaphoi, beswonam yimba lohv. ");
INSERT INTO wrs_vpl VALUES ("GN46_31","002_46_31","GEN","46","31","31","Wo Yosepva os hevna etehumunilm eva hevna araltatanam ishunna, detiva kava ata Perom kuwulm isholm gamnavav, wo os ata kava ishomnavav, etehumunilva kanamba, boaslalva kanamba, aralavalva kanamba doara Kenanda di aevulvnamba, doa pulvoi kainda. ");
INSERT INTO wrs_vpl VALUES ("GN46_32","002_46_32","GEN","46","32","32","Honamba kana owalva os andra viv, sipsipm memem sapim dahwol viv, doarava os vivna. Wo noinda himba hevna sipsipm memem sapim wohm manimani doa wonambna hom. Wo Perova os ata hellerava, yemba si ishopra vinvav, hom ambo. ");
INSERT INTO wrs_vpl VALUES ("GN46_33","002_46_33","GEN","46","33","33","Wo yimba hevm nonglapulvorava, hev yemba si sahindava, manandra yimba vive? ");
INSERT INTO wrs_vpl VALUES ("GN46_34","002_46_34","GEN","46","34","34","Wo yeoa os umnu, kuwul, kava os andra vivna, kavna deuvtatam kava dahwol vewuvna, os kana eindhumunilva doarava vivnam. Yimba osva utava, Perova si yemba os ishunvav, di aevultho di Gosen pethara Isipra murapeta, di petha besalla. Manara, Isipnindva ovowol viv sipsipna andranindmba Isip petharava. ");
INSERT INTO wrs_vpl VALUES ("GN47_1","002_47_1","GEN","47","1","2","Wo os Yosepva Pero kuwulindam gana, etehumunilm 5pelaram wongana. Doa Perom nonglapulvonamba, Yosep omnana, kana aratindiva doa hom ambna Kenan pethariniva, hevna sipsipm memem sapim wohm manimani doa wonambna, Gosennahalm di dawonam aevulv. Doa henga omnana, menta kana etehumunilva. ");
INSERT INTO wrs_vpl VALUES ("GN47_3","002_47_3","GEN","47","3","3","Doa Pero unna, yimba manandra velvohvna? Wo he umnina, kava sipsipm memem sapim dahwol velvohvna, eindhumunmba doarava os vivna. ");
INSERT INTO wrs_vpl VALUES ("GN47_4","002_47_4","GEN","47","4","4","Wo hom kava ambna yena petharam, manara, owous mendekli diva phovnamba Kenan petharava, wo posva owai, tatamba kanamba ata heni eva hleinvta. Wo pev ishorava, kava di dawonam aevulthavav Gosen pethanahalm. ");
INSERT INTO wrs_vpl VALUES ("GN47_5","002_47_5","GEN","47","5","5","Doa Pero hellenamba, Yosepm omnana, lehra pevna arapevtatanamba ambna. ");
INSERT INTO wrs_vpl VALUES ("GN47_6","002_47_6","GEN","47","6","6","Yeoa petham orava, ora, men besalva lohv, di sandho. Wo himba Gosendava aevulthatava, lehra, nomba pethava besalangas lohv. Wo monglava heriniva nonoanindva lovahtava, nooa dahwol vira kana sapim. ");
INSERT INTO wrs_vpl VALUES ("GN47_7","002_47_7","GEN","47","7","7","Doa Yosep Yakopm waipronamba, Perom indthoamnana, omnana, menta kanamba aramba. Doa Yakopva Perom awothona, ");
INSERT INTO wrs_vpl VALUES ("GN47_8","002_47_8","GEN","47","8","8","wo he omnana, osomba yenamba es lohv? ");
INSERT INTO wrs_vpl VALUES ("GN47_9","002_47_9","GEN","47","9","9","Doa hev omnana, osomba kanamba 130pelara lohv, os kava lohmanangas vevna. Osomba kanamba aiv espetambo lohvna, kinwonda aiv kamba plothomnavna. Eindhumunilva kanamba doara os lovahmana vevna osomba mindnam. ");
INSERT INTO wrs_vpl VALUES ("GN47_10","002_47_10","GEN","47","10","10","Doa hev henga Perom awotholahangana. ");
INSERT INTO wrs_vpl VALUES ("GN47_11","002_47_11","GEN","47","11","11","Doa os Yosepva hevna araltatanamba sandhana Isipra, petha besalla Rameses kotara murapeta, os ten Pero ishomnanam hevm. ");
INSERT INTO wrs_vpl VALUES ("GN47_12","002_47_12","GEN","47","12","12","Doa sandhanamba, innemba dembrahuluhunvna, vevna aralm, etehumunilm, etehumuniltatanam, vevna otomotalnahonam. Henomba otolva mindnamba eva innemba mindnamta, henomba otolva espetava, innemba espeta. ");
INSERT INTO wrs_vpl VALUES ("GN47_13","002_47_13","GEN","47","13","14","Doa owousva mendekli phona vavawonam, wo Isipnind Kenannind himba ponda euvmona vevna. Doa himba sovawol velvohvna innemba kuwulinda Yosepinda. Wo himba diva domblohvna, Perona deuvram ainga velohvna. ");
INSERT INTO wrs_vpl VALUES ("GN47_15","002_47_15","GEN","47","15","15","Wo sisva himba hevna diva eunumbuvnamba Isipnind Kenannind, doa Isipnindva Yosepm umnina, inne kam henga dembrahunu, kava dihui, si homeis kamba sihavm. ");
INSERT INTO wrs_vpl VALUES ("GN47_16","002_47_16","GEN","47","16","16","Doa Yosepva unna, tataoa yeoa wonambo, kam yeoa holvorembreihu, ata kava yemba dembrahunvav innemba. ");
INSERT INTO wrs_vpl VALUES ("GN47_17","002_47_17","GEN","47","17","17","Doa himba hevna deuvtatam wonamblohvna, hosm sipsipm, memem, sapim, donkim, wo Yosep inne dembrahuluhunvna. Honamba venamba tahonmba mongasal, noinda tatamba eunumbupiana. ");
INSERT INTO wrs_vpl VALUES ("GN47_18","002_47_18","GEN","47","18","18","Doa sisva henga himba Yosepm umnina, kava manam yemba gekalava umnivav, kava tatahui dihui, wo mani eva kava yemba dembreihuvav, owai. Yemba doa kava wohdembreuhpieina tatana dinamba. Mani eva yemba kava dembreihuvav hengava, owai, pethangas eva kangas nis ambo av. ");
INSERT INTO wrs_vpl VALUES ("GN47_19","002_47_19","GEN","47","19","19","Manam yimba kamba nongallihavav, si kamba dalvav osrava. Yeoa kamoa holvorombol veo andranindilm, osoa kava Perona innemba wuleivav, monglava hlavra, wo osva kava aevvav, wo Perona andranindilm lovahvav wo hev pethava kanamba wohvaohothunvav. Pethava honamba si sahokla vevavmoa. ");
INSERT INTO wrs_vpl VALUES ("GN47_20","002_47_20","GEN","47","20","20","Doa Yosepva hellenamba, unna, lehra, wo Isipnind hevna petham wohwuleihimnina Perom kuwulm, wo Yosep innemba dembrahunvna. Owous mendekli nongal lohvna, wo noinda indkumbi hevna petham wohwuleihimnina, wo osva Perova indakonda pethava wohvaohothowol vinna. ");
INSERT INTO wrs_vpl VALUES ("GN47_21","002_47_21","GEN","47","21","21","Wo os Isipnindva indkumbiva Perona andranindilm lovahvna. ");
INSERT INTO wrs_vpl VALUES ("GN47_22","002_47_22","GEN","47","22","22","Sembayang andranindangas himba hevna petham mendah vaohuthulovahvna, manara, Perova hemba innemba nis ambo dembrahuluhunvna, wo hevna pethamba wuleihimninamoa Peromba. ");
INSERT INTO wrs_vpl VALUES ("GN47_23","002_47_23","GEN","47","23","23","Doa Yosep Isipnindm ishunna, kana moara yimba doa pevna pethamba Peromba wohwuleihimninamba, wo hev vaohotho, wo yeoa hevna andranindilm lovahe. Men yemba kava dembrahunv innemba, wolalm, wo yeoa wuleirava, ");
INSERT INTO wrs_vpl VALUES ("GN47_24","002_47_24","GEN","47","24","24","phorava, wo eunumbuloa eusilva henga iambmano Perom. Wo monglaoa inneoa yeoa dawonam iaevvm, hlalm, eva wulalm. ");
INSERT INTO wrs_vpl VALUES ("GN47_25","002_47_25","GEN","47","25","25","Doa Isipnind hillinamba, Yosepm umnina, lehra yimba ov, yimba kamba beswonam vewol velohv, wo kamba dalvmoa, wo kava Peronamba andranindilm si lovahvav. ");
INSERT INTO wrs_vpl VALUES ("GN47_26","002_47_26","GEN","47","26","26","Doa memba plalmomba lohvpa, Isipnind hevna osorini inne eunumbulva Perom kuwulm ainga vimnivna, wo mendah viv. Sembayang andranindangas himba hevna petham wuleihimninamoa Peromba. ");
INSERT INTO wrs_vpl VALUES ("GN47_27","002_47_27","GEN","47","27","27","Doa Israelnindva di Isip pethara aevulvna Gosennahalm, wo himba wohtowond aevulvna, otomotalva mindnam. ");
INSERT INTO wrs_vpl VALUES ("GN47_28","002_47_28","GEN","47","28","28","Wo Yakopva hev di avna, tahonmba 17pelara vevnamba, osomba henamba os lohvna 147pelara, wo murapeta hemba doa dahalm vevna. ");
INSERT INTO wrs_vpl VALUES ("GN47_29","002_47_29","GEN","47","29","29","Doa hev ona, hom Yosep prora, wo Yosepva pronamba, aral omnana, yeoa englaoa hui yitho kana pohasingi, wo kam os tanamolnam ishomno, manam yimba kamba singvivav huiva Isip petharava, owainonoa. ");
INSERT INTO wrs_vpl VALUES ("GN47_30","002_47_30","GEN","47","30","30","Kamba huiva daharava, wo yeoa kamoa os vindilango, di singviu, ten kana eindim araim doara singvewol vinam. Doa ombol omnana, si kava os vevavta. ");
INSERT INTO wrs_vpl VALUES ("GN47_31","002_47_31","GEN","47","31","31","Doa aral omnana, tanamolnam kam ishomno. Doa ombol tanamolnam hemba wohishomnana, Sesoana nihilmba himba sevrana. Doa Yakop hellenamba, himba hevna vuhera avna, hevna ku kusithavna, Sesoam ishomnana, lehra. ");
INSERT INTO wrs_vpl VALUES ("GN48_1","002_48_1","GEN","48","1","1","Doa Yosepva hellena, aramba uvavul venav. Doa himba aralm engganamba, ombol samblam wongana, Manaseim Evraimim. ");
INSERT INTO wrs_vpl VALUES ("GN48_2","002_48_2","GEN","48","2","2","Doa aralva hellenamba, ona, omb memba kamba vengsihav. Wo himba saha vrevna pholmba, phonamba, vuhera avna, ");
INSERT INTO wrs_vpl VALUES ("GN48_3","002_48_3","GEN","48","3","3","os ombolmba ishomnana. Sesoa mendekliva kam seilva phomnana di Lusra Kenan pethara, kam awothona, ");
INSERT INTO wrs_vpl VALUES ("GN48_4","002_48_4","GEN","48","4","4","ona, yetindiva si mindnam phovav. Manara, kav si yemba kolvrowol vevav, wo memba pethava yimba avpa, si kava yetindim kovorahunvav, wo si himba wohvaohuthuivav. ");
INSERT INTO wrs_vpl VALUES ("GN48_5","002_48_5","GEN","48","5","5","Doa Yakopva mendah ishongamnavna, kava yena ombpov samblam ninginv Evraimim Manaseim, yimba men hui Isip petharava towand venamba, kava mendah di kavna pethara aevulvnam. Wo kava os hemba ninginvmoa, kanamba umbeindil sambla owai, kanamba ombol sambla, oi kavna yiveltowond, pethamnal. Wo si yimba pevm kana puewulva moang vinvrava, wo pevna mongo ombolmba manam yimba dembraohvav, owai, hevm moang vinu Evraimim Manaseimangas. ");
INSERT INTO wrs_vpl VALUES ("GN48_6","002_48_6","GEN","48","6","6","Mongova yimba waiatava ombpovmba, manam yimba dembraohvav kana puewulva. Owai, heoa espeta daha ambo dombvma Evraimina Manaseina englisharini. ");
INSERT INTO wrs_vpl VALUES ("GN48_7","002_48_7","GEN","48","7","7","Men kava yemba ishomnav avapevnilmba Reselnilmba. Nemetva kava mindnam nengmanavna, wo hemba di Kenan pethara dahanamba, kava mindnam wo vevna. Kava di singvena Eprata mona pethalla, nonam ten kav wonprovnam Mesopotamia petharini. Mani Eprata kembelliniva oklama. (Daipota indhanamba os Epratamba ningthiv Betlehem kembel.) ");
INSERT INTO wrs_vpl VALUES ("GN48_8","002_48_8","GEN","48","8","8","Doa Yakopva Yosepna ombol samblam nongalnamba, aralm osahmana, anna memba ombol samblava? ");
INSERT INTO wrs_vpl VALUES ("GN48_9","002_48_9","GEN","48","9","9","Yosep omnana, memba kana ombol samblava, Sesoa kamba hui holvorombtrahona Isip pethara. Doa aral omnana, hom murapetam wonproo, kava awothowolm vev. ");
INSERT INTO wrs_vpl VALUES ("GN48_10","002_48_10","GEN","48","10","10","Henamba novpa sahoklal, himba beswonamba nongalvnamoa, doa hemba mundkola vena. Doa Yosep hevna ombol samblamba murapetam wonpro, eindil sendara othowolna mehtatnahonam. ");
INSERT INTO wrs_vpl VALUES ("GN48_11","002_48_11","GEN","48","11","11","Wo hev Yosepm omnana, seilva yimba hoai vena, wo kava nengvnamoa, yemba nonglalmba hengava. Heva os Sesoa kamba beswonam vrevna, wo noinda men kava yemba nongalv ombpovnahonam. ");
INSERT INTO wrs_vpl VALUES ("GN48_12","002_48_12","GEN","48","12","12","Doa Yosep hevna ombol samblam holvorawolnamba eindilna plisrini, wo hev ku petharam kusithamna aralm. ");
INSERT INTO wrs_vpl VALUES ("GN48_13","002_48_13","GEN","48","13","13","Doa Yosep phonamba, hevna ombol samblam kleiharombtia. Mongova sihana englana kevrana, mongova nihana englana kevrana. Doa hev desvhoawolna, Evraimba sihanasis desvhoana eindilna englara, Manasemba nihanasis desvhoana. ");
INSERT INTO wrs_vpl VALUES ("GN48_14","002_48_14","GEN","48","14","14","Doa eindil hevna engla holothowolinna, awothowolm. Wo boasna himba hevna englam imhravhoawolna, nihamba os gana Evraimna kuram, boaslalna kuram, sihamba os gana Manasena kuram, etelinam. ");
INSERT INTO wrs_vpl VALUES ("GN48_15","002_48_15","GEN","48","15","15","Doa Yakopva mendah ishovna moamba, awothowol vena Yosepm eva otolsamblam, ona, Sesoa hona otolsamblamoa koldombra, ten kana arai eindi doara elohmanavnam, kamba himba desvhuluhmana vevna, veiva daipota men. ");
INSERT INTO wrs_vpl VALUES ("GN48_16","002_48_16","GEN","48","16","16","Wo eva Sesoana ovsongolnindriniva hona otolsamblamoa koldombra, temba kamba ungundna englisriniva mohvenamba. Si indhanamba hona ombol samblamba nungeilvav, unvav, memba umbeindpolva Yakopna, Aprahamna, Isakna, wo si hetindiva mindnam nuweku vevra. ");
INSERT INTO wrs_vpl VALUES ("GN48_17","002_48_17","GEN","48","17","18","Doa Yosepva nonglana, aralm koasve, omnana, owai osva, Manaseva men etel lohmanav, wo yeoa pevna niham hevna kura holotho. Doa hev aralna englam kevrana, ona Manasena kura holotho. ");
INSERT INTO wrs_vpl VALUES ("GN48_19","002_48_19","GEN","48","19","19","Wo aral omnana, owai, kava nonora, wo mekava yem ishomnav, Manasetindiva si mindnam phovavta, heva os hena boaslalva si mendekli polohvav, wo hetindiva si esvema kekel vethangavav no petharam no petharam. ");
INSERT INTO wrs_vpl VALUES ("GN48_20","002_48_20","GEN","48","20","20","Wo osva Yakopva hevna umbeindil samblam awothowolna, henga unna, si yetindiva mindnam nuweku vevav Israelnindangas. Wo sism Israelnindva indhanam awothowol vivav, himba os unvav, Sesoa yem beswonam vewol vevra, oi hev ten nemet Evraimim Manaseim vewol venam. Os Yakopva hevna umbeindil samblam ishunna, pethamnalva mi gavav, yiveltowondva sis lohvav. ");
INSERT INTO wrs_vpl VALUES ("GN48_21","002_48_21","GEN","48","21","21","Doa Yakopva Yosepm ishomnana, yimba nonglav kamba, murapeta kamba doa dahalm vev, heva os Sesoa yemba waiavav, wo yemba henga si waingavav pevna petharam, pevna simbepevna petharam. ");
INSERT INTO wrs_vpl VALUES ("GN48_22","002_48_22","GEN","48","22","22","Wo yimba garava, yeoa pethamoa nomoa vaohotho Sekemra, temba petha besal lohv. Yem kava kovoraohv, yena etehumunpevmba owai. Kava kavm doa doara ungundna petham muehvena Amornindna pethamba. ");
INSERT INTO wrs_vpl VALUES ("GN49_1","002_49_1","GEN","49","1","1","Doa Yakop ona, otomotalva kanaoa prapiara. Doa ambanamba, hev unna, hui murapeta kusoo, yemba kava isholm vinv, si mana vemamba yemba phunvav. ");
INSERT INTO wrs_vpl VALUES ("GN49_2","002_49_2","GEN","49","2","2","Doa unna, yimba katindi Yakoptindi, wo kava eva Israel. ");
INSERT INTO wrs_vpl VALUES ("GN49_3","002_49_3","GEN","49","3","3","Rupen, mekava yemba ishomnav, yimba kana yiveltowond, wo kava yenanapopol lohv. Nemetva kangas tendoriniva lohvna, yemba kava wailohmana vevna. Wo yimba kelsombovhol lohv, wo boaslapevmba yimba kuvhoawol vev andramba. ");
INSERT INTO wrs_vpl VALUES ("GN49_4","002_49_4","GEN","49","4","4","Wo heva os yimba pueumbmsna lohv, mana vemamba yimba wohpilingavav. Yimba yiveltowond lohv, heva os owai, yimba kuwulva mendekliva wulluhunvavmoa, manara, yimba sahonam vena, yimba kana vuhera sihanamba, kana andranind unguvlirinim Bilham wailina. ");
INSERT INTO wrs_vpl VALUES ("GN49_5","002_49_5","GEN","49","5","5","Simeon, Levi yimba ehellevm, yimba etel boaslal elohv, indhanamba yimba bunevalgona welhowol evev. ");
INSERT INTO wrs_vpl VALUES ("GN49_6","002_49_6","GEN","49","6","6","Doa yimba ekithohovpa, di ihishov, indhanam helvawolalm. Kava owai vev, manam kava hellevav, yemongova kava anongla vevavmoa. Nemetva yimba daosm ohovna, indhanam ewuleihavna, wo ungundna sapiaralm ambo muerialm tengamol koaksa evevna. ");
INSERT INTO wrs_vpl VALUES ("GN49_7","002_49_7","GEN","49","7","7","Tandmomba yenamba esvema luhunvna, kava ovov, memba sahoklal. Tandmomba yenamba indhanam endesvotvna, kin plothunvna. Yetindiva si mongawulmba aevulvavmoa, owai, ka si wolanga vuku vevav, dom hovram ten katindi Israeltindi aevluwul vevm. Wo di hovra himba aevluwul vevra nohalm nohalm. ");
INSERT INTO wrs_vpl VALUES ("GN49_8","002_49_8","GEN","49","8","8","Yuta yeoa hellevm, owapevpa si yem wivivav, manara, yimba ungundmba omoval kakaiv velohv. Etepevpa si kuva kusithapramnavav yemba. ");
INSERT INTO wrs_vpl VALUES ("GN49_9","002_49_9","GEN","49","9","9","Yimba os sungeitwindena nihna, oi laion. Himba hevna tatamba wena vevna, wo henga hevna vuheram gavna. Doa di himba indund lithavna, englamongla shuawol vevna, an eva ata gavta kevralmba hemba, owai. ");
INSERT INTO wrs_vpl VALUES ("GN49_10","002_49_10","GEN","49","10","10","Yimba si kuwul mendekli wulluhunvav, wo simbepolva yenamba si osangas wulvahinvav. Verava, hona indhanarini si lohvav kuwulalmba, Silo. Monglava indhanamba si woh iambmanavav yemba, hevna kuva kusithapramnavav. ");
INSERT INTO wrs_vpl VALUES ("GN49_11","002_49_11","GEN","49","11","11","Yimba si donkina meisra gavav, doa holoperava, donkimba wena ningevav. Denwitmingra ningevav, nomba denwitva besalangas, wainpolva nominiva besvev os i. ");
INSERT INTO wrs_vpl VALUES ("GN49_12","002_49_12","GEN","49","12","12","Wo yimba mindnam nevav, novnihilva yenamba aembul lovahvav. Wo lomba yenamba dombal elohvav, manara, sapina tetpolva yimba elsus nelohvav. ");
INSERT INTO wrs_vpl VALUES ("GN49_13","002_49_13","GEN","49","13","13","Sepulun yeoa hellevm, yimba si di wanda aevulvav, wo sipva si ambvrava yeindam, dom angavra wohnahonam. Pethava yenamba garava, doa Siton kembella. ");
INSERT INTO wrs_vpl VALUES ("GN49_14","002_49_14","GEN","49","14","14","Isakar yeoa hellevm, yimba kinnindrini ambo, oi donki. Yimba pevna kinsingi si lohmana vevav, ");
INSERT INTO wrs_vpl VALUES ("GN49_15","002_49_15","GEN","49","15","15","heva os yimba si nonglavav, pai memba besal kuksa vekohal lohv, memba pethava besal luhuku vev. Doa henga yimba gavav, kinda vithavav, os gavav, yimba si os lohmana vevav, oi andranindrini indhanana. ");
INSERT INTO wrs_vpl VALUES ("GN49_16","002_49_16","GEN","49","16","16","Dan yeoa hellevm. Yimba si kuwul wulluhunvav pevtindim. Wo himba si os aevulvra, oi katindi Israeltindi. ");
INSERT INTO wrs_vpl VALUES ("GN49_17","002_49_17","GEN","49","17","17","Wo yimba os av, oi saihola monapethalla hethilohv, saipusuhla. Wo indhanarini hossra prorava, yimba lelnam nungi lovav hosna munngulmba. Wo hosva ata pemba vilivhoarava, wo aralmba wupianga meisis pethara. ");
INSERT INTO wrs_vpl VALUES ("GN49_18","002_49_18","GEN","49","18","18","Doa Yakopva mendah ishongeinvna, ona Yawe, kava yem amnav, kam kolvro. ");
INSERT INTO wrs_vpl VALUES ("GN49_19","002_49_19","GEN","49","19","19","Gat yeoa hellevm, indhanamba si yemba monarava kevrirava, yemba helvakomandhirava, wo diva wohva hevm nomba dumbra. Wo owai, yimba si engilguavav hemba. ");
INSERT INTO wrs_vpl VALUES ("GN49_20","002_49_20","GEN","49","20","20","Aser yeoa hellevm, osonnamba yenamba si bes vevav os i. Indhanamba si lihvav, wo uvav, honamba lehra dihelv kuwulilmba. ");
INSERT INTO wrs_vpl VALUES ("GN49_21","002_49_21","GEN","49","21","21","Naptali yeoa hellevm, yimba meme nenmalmsna lohv. Pevelm ambo lohmana vev. Yimba otolva besalangas towand velohv. ");
INSERT INTO wrs_vpl VALUES ("GN49_22","002_49_22","GEN","49","22","22","Yosep yeoa hellevm, yimba wainweselmsna endv pora, wo klalva hoanwonam lelga vev, pueilmba ningev, wo wainmovpa mindnam kethav. ");
INSERT INTO wrs_vpl VALUES ("GN49_23","002_49_23","GEN","49","23","23","Ungundva yenamba yemba engvilangav bunevalgona, ");
INSERT INTO wrs_vpl VALUES ("GN49_24","002_49_24","GEN","49","24","24","heva os yimba kuvund vrevmoa, yimba indundangas pviav, wo englava yenamba keknam elohv. Manara, Sesoa hev yemba poauothov, Sesoa mendekli. Himba pimba Israelnindmba os poauothowol vev, oi tendorini mi gav, sipsipm wongav, kekalvho vrungeinv. ");
INSERT INTO wrs_vpl VALUES ("GN49_25","002_49_25","GEN","49","25","25","Tanam Sesoava kana mendekli lohv, hev yemba si poauothovav, wo kolvrevav. Manara, himba keknamangas wohlohv. Himba pom wolaihaprinvna senaminiva eva pethariniva, temba novolva livpa. Yetindina ongahmunilva si tetwond vevav mindnam. ");
INSERT INTO wrs_vpl VALUES ("GN49_26","002_49_26","GEN","49","26","26","Sesoa yemoa mindnam awothora, wo eva dembrahora manimani olorini besal doaramini. Kava Sesoam nengmanav, manam himba aivovo vevav, men honamba kava daipotava ov. Sesoaoa yena kura engla holothora, ovra, Yosepm men kava mindnam nengmanav. Henamba etehumunilmba memba espetambo kava ninginv. ");
INSERT INTO wrs_vpl VALUES ("GN49_27","002_49_27","GEN","49","27","27","Bensamin yeoa hellevm, yimba sungeitwindenonoa. Yimba simolnam eunumbolohv tatamba. Wo simba yimba mendah eunumbolohvna. ");
INSERT INTO wrs_vpl VALUES ("GN49_28","002_49_28","GEN","49","28","28","Doa memba Israelna ombol 12pelara lovahna, wo hona moamba he ishuwul vinvna, nonamba eunillam hev ishunnam. Hev vena, awothowol vena, ishunna, yimba honamba si os lohvav, yimba honamba si os lohvav. ");
INSERT INTO wrs_vpl VALUES ("GN49_29","002_49_29","GEN","49","29","29","Doa Yakop henga unna, kamba dahav. Wo yeoa kamindmoa di singviu Kenan pethara. ");
INSERT INTO wrs_vpl VALUES ("GN49_30","002_49_30","GEN","49","30","32","Honmera singviu, di ten sahal lohvm. Nomba sahalva Evron seilva vaohothonamba, wo Aprahamba kovorahona, wo diva hev dombna. Evronmba nomba Hitnindrini lohna. Sahalva nomba os ningthivna Makpela, wo di lohv Mamrera nohalm, ten okomba pholohvm. Aprahamba doara di singvina eva ongalm Saram. Isakmba di singvinamba eva ongalm Repekam. Dita kava singvena kavna ongamba Leamba. ");
INSERT INTO wrs_vpl VALUES ("GN49_33","002_49_33","GEN","49","33","33","Doa ishopianamba, lithanamba, os wohdahana. ");
INSERT INTO wrs_vpl VALUES ("GN50_1","002_50_1","GEN","50","1","1","Doa aralmba daheinnamba, Yosepva wenamona sendara otho. ");
INSERT INTO wrs_vpl VALUES ("GN50_2","002_50_2","GEN","50","2","2","Doa andranindm Isipnindm unna, yeoa kana aramindm ningewol vinu, os pev ten tevivm, osm si nung vevavmoa. ");
INSERT INTO wrs_vpl VALUES ("GN50_3","002_50_3","GEN","50","3","3","Doa himba os vivnamba, simba 40pelarava vivnamba, os hev ten vivnam. Wo Isipnind wivivna, simba 70pelarava vivnamba. ");
INSERT INTO wrs_vpl VALUES ("GN50_4","002_50_4","GEN","50","4","4","Doa wi vepieinamba, Yosep Perotatanam ishunna, kamba indoa vetava, yeoa kuwulm mendeklimoa Peromoa os ishumnu, ");
INSERT INTO wrs_vpl VALUES ("GN50_5","002_50_5","GEN","50","5","5","aramba kanamba dahavnamba, kamba os ishomnavna, ona, manam yimba kamba huiva singvivav Isip petharava, owai, Kenan petharava dioa singviu, ten kav doara pokama nongthonam. Aramba kamba os ishomnanamba, wo Perooa heoa kam nombolvhoara, gavra singvelm, wo henga si kava provav. ");
INSERT INTO wrs_vpl VALUES ("GN50_6","002_50_6","GEN","50","6","6","Doa Perova hellenamba, moa henga ishopra vemnana, ona, gaota, di singviu arapevmindmoa. Yimba os tanamolnam ishomnana. ");
INSERT INTO wrs_vpl VALUES ("GN50_7","002_50_7","GEN","50","7","7","Doa Yosepva ganamba, aralm singvelm, wo himba indkumbi singvelmba angana, indakonda Isipna kuwulva, kuwulna nonoanindva, Isipna mundil, ");
INSERT INTO wrs_vpl VALUES ("GN50_8","002_50_8","GEN","50","8","8","Yoseptatana, Yosepna etehumunilva, wo araltatanamba. Otomotal eva tata nomba deuvra aevulvna di Gosennahalm. ");
INSERT INTO wrs_vpl VALUES ("GN50_9","002_50_9","GEN","50","9","9","Anganamba, monglava hossra angavna, eva monglava karissra angavna, nomba karisva hosva kevri iangavna. ");
INSERT INTO wrs_vpl VALUES ("GN50_10","002_50_10","GEN","50","10","10","Doa di pulvona Atatra, Yotanpora nohalm, di temba indhanamba witmovpa osora huhul vewol vivnam. Pulvonamba, di lovahthavna, mindnam wuo ovna, wo Yosepva hevna wevsa vevna, minguva mongasal venamba, wi vevna, doa os henga angavna Kenandam. ");
INSERT INTO wrs_vpl VALUES ("GN50_11","002_50_11","GEN","50","11","11","Wo no pethanind Kenannind nungeilnamba, una, pai hona Isipnind mindnam ningminivna mindmba, esvema vivna. Wo noinda no pethamba os ningthivna, Epelmisraim, osm uvna, Isipnind wuo ov. ");
INSERT INTO wrs_vpl VALUES ("GN50_12","002_50_12","GEN","50","12","13","Wo osva Yakopna ombolva aralmindmba vindilangana, di singvina Kenan pethara. Os vivna, ten nemet hev ishunnam. Wo honmera singvinamba di Makpelara, temba Mamrera nohalm lohvna, ten okomba pholohvm. Aprahamba seilm doara no pethamba kovo vrena, osm ongamindilm singvelm, himba Evronm diva dembrahona. ");
INSERT INTO wrs_vpl VALUES ("GN50_14","002_50_14","GEN","50","14","14","Doa singvinamba, henga Isip petharam angana mongawulm. ");
INSERT INTO wrs_vpl VALUES ("GN50_15","002_50_15","GEN","50","15","15","Doa aralmba daheinnamba, etehumunilva hevm eishovna, Yosepva mendah pimba sahonam ninginvmi, pi ten nemet indkokla vrinam? Dihi honam esesm pimba velm vinv? ");
INSERT INTO wrs_vpl VALUES ("GN50_16","002_50_16","GEN","50","16","16","Wo noinda moa ishonga vimnina, una, aramba pinamba kamba ten nemet ishunnam, ");
INSERT INTO wrs_vpl VALUES ("GN50_17","002_50_17","GEN","50","17","17","yeoa Yosepmoa os ishumnu, heoa maivethara sahoklamoa, nomoa temba nemetva yimba vimninamba. Wo noinda yeoa kana sahoklalmoa maivithinu. Kava ambo andranind lovahmanav Sesoana, temba pina aramba lohmananamba. Doa Yosepva hellenamba, wo und vewol vevna hevna etehumunilmba, noinda wo vewol vevna. ");
INSERT INTO wrs_vpl VALUES ("GN50_18","002_50_18","GEN","50","18","18","Doa sisva etehumunilva hevpa ambmananamba, Yosepnapenam pem vendral vena, umnina, men kava lovahv, oi yena andranind. ");
INSERT INTO wrs_vpl VALUES ("GN50_19","002_50_19","GEN","50","19","19","Doa Yosep unna, owai, manapenam, Sesoangas esesmba vevra, kava owai. Manam yimba pemba vivav kanapenamba, owai. ");
INSERT INTO wrs_vpl VALUES ("GN50_20","002_50_20","GEN","50","20","20","Yimba ningminivna kam, sahonam hemoa vrelvohra, heva os owai, Sesoa kam kolvrena, wo himba lehra beswonam vena honinda. Hev kamba waiprona homba, manara, himba yem kolvrowolalm vevna, si homeis owousra dalvm pivna aratindimba. Wo mendah beswonam aevulv. ");
INSERT INTO wrs_vpl VALUES ("GN50_21","002_50_21","GEN","50","21","21","Yemba ka dahwol vevav, yena otomotalnahonam. Wo wowonam himba ishunvna, nomba etehumunilva beswonam hillivna, wo indk vithivna, uvna, lehra. ");
INSERT INTO wrs_vpl VALUES ("GN50_22","002_50_22","GEN","50","22","23","Doa Yosepva di dawonam Isipra aevulvna aratindilmongo. Aevulanamba, hevna umbeindil lohvna, nomba Evraimna ombol. Eva no umbeindilna ombol hena novra lohvna, Yosepna simbel. Wo eva mongo hevna umbeindil lohvna, nomba Manasena ombol, nihilva Makir. Wo sismba Makirna ombolva lovahvna. Honamba otolva phovnamba, Yosepva missra dashalohvna, ovna, kana ombol. ");
INSERT INTO wrs_vpl VALUES ("GN50_24","002_50_24","GEN","50","24","24","Doa Yosepm dahavna, etehumunilm unvna, murapeta kamba dahav, heva os manam yimba duus vivav, owai, Sesoa hev yem si wonavav, si yemba wonphovav hona pethariniva. Verava, yemba wongavav Kenan petharam, temba himba nemetva tanamolnam ishunnam pivna simbelm Apraham, pivna eindilm Isakm, wo pivna aralm Yakopm. ");
INSERT INTO wrs_vpl VALUES ("GN50_25","002_50_25","GEN","50","25","25","Doa henga unna, yeoa kamoa tanamolnam ishumnu, si Sesoava yemba wongarava honaminiva, yeoa os viu, kana kelmoa Kenan petharam iango, di singvewol viu. ");
INSERT INTO wrs_vpl VALUES ("GN50_26","002_50_26","GEN","50","26","26","Doa Yosepmba os dahana, hevna osomba 110pelara lohmanavna, os hemba dahana. Doa andranind hev ningewol vinamba hevna wevsana, doa petimerava os vindithina. Doata. ");
INSERT INTO wrs_vpl VALUES ("RT1_1","009_1_1","RUT","1","1","2","Nonamba Israelnindva king kuwulhui mendah avna, valgonindna kuwulva kekalvho vewol vivnamba hemba, innemba beswonamba phunvnamoa, owousva mendekli nongalphona. Wo noinda mongova tendoriniva hevna kembelliniva venamba, mongona petharam Moap petharam ga, di dawonam alohvna. No tendorinina nihilva Elimelek. Elimelekva nom wongana, vena, ongalm eva ombol samblam hevnam. Ongalna nihilva Naomi, ombol samblanamba vei, mongova Malon, mongova Kilion. Himba Evratatindirini Betlehem kembellini. Moap petharam wonganamba, di wonpho, wo di aevulvohvna dawonam. ");
INSERT INTO wrs_vpl VALUES ("RT1_3","009_1_3","RUT","1","3","3","Wo venamba, Elimelekm di dahana, ongaloa wonana ombol samblamoa hevho. ");
INSERT INTO wrs_vpl VALUES ("RT1_4","009_1_4","RUT","1","4","4","Doa venamba, ombol samblava ango endombtowolna, Moapunguvlirini samblam, mongova Orpa, mongova Rut. Doa peliva Naomiva diva os wonana, osomba 10pelaraka luhunna, ");
INSERT INTO wrs_vpl VALUES ("RT1_5","009_1_5","RUT","1","5","5","wo ombol samblamba os endahawolna, Malonimba Kilionimba. Wo doa Naomiva kol samblam pelim wonavna, doara aralm ombol samblam dalna. ");
INSERT INTO wrs_vpl VALUES ("RT1_6","009_1_6","RUT","1","6","6","Doa Naomiva hellepra vena, Sesoa Yaweva doa kolvrowol vena, wo noinda Yutanindnamba innemba beswonamba phunv. ");
INSERT INTO wrs_vpl VALUES ("RT1_7","009_1_7","RUT","1","7","7","Hellenamba, henga galm vevna hevna Yuta petharam Moap petharini, kol samblamba wongalm vevna. ");
INSERT INTO wrs_vpl VALUES ("RT1_8","009_1_8","RUT","1","8","8","Doa hev wonganamba monara, hev unna kol samblam, owai henga engowolo pevna petharam, yem di woneuvmona vera pevna arapev. Yimba doa kamba nesmos vewol evena, kam eva eindpevm, talapevsamblam. ");
INSERT INTO wrs_vpl VALUES ("RT1_9","009_1_9","RUT","1","9","9","Wo yemoa eva Sesoa nesmos vrowollata, osm hengava yemba beswonam si deumbtivav. Doa Naomi mehtat vewol venamba, os nongtana. Wo kol samblava ewavewolvna, ");
INSERT INTO wrs_vpl VALUES ("RT1_10","009_1_10","RUT","1","10","10","ohomnana wenamona, owai, ata pivva mongawulm angavav yetindiram. ");
INSERT INTO wrs_vpl VALUES ("RT1_11","009_1_11","RUT","1","11","11","Doa ongal Naomi unna, owai, yemba kava os unv, pevna kembellam henga engowolo. Es hevpa, yimba kamba os enengmanavma, si himba henga towand vevav, wo yemba noi endombtowolvav? ");
INSERT INTO wrs_vpl VALUES ("RT1_12","009_1_12","RUT","1","12","13","Owainonoa, doa kamba ongaklatov vena, hengava kava si talarava vongavavmoa. Osva kava otava, kava ata deti talarava vongavav sinim, wo otolm lengwollava tuendisrini samblam, wo es hevpa, yimba enengvma, nomba kalelmba aheinilmba, yemba dombtolmba? Owai, kosambla, yemba kava mindnam und vewolv, Sesoa Yawe yemba doa kinwondava pelhola vinna, yimba peli ahamana evev. Wo kamba eva osta plothomnana, noinda kava peli otolhuiva av. ");
INSERT INTO wrs_vpl VALUES ("RT1_14","009_1_14","RUT","1","14","14","Doa kol samblava henga ewavewolvna, wo Orpangas Naomimba onunghovna, doa Rutva owai, ganamoa, himba Naomii oholohna di. ");
INSERT INTO wrs_vpl VALUES ("RT1_15","009_1_15","RUT","1","15","15","Wo Naomi omnana Rutm, nonglatok, ten moasalapevpa Orpava gav pevtindiram pevna tihram, os mongawulm waingao. ");
INSERT INTO wrs_vpl VALUES ("RT1_16","009_1_16","RUT","1","16","16","Wo Rut omnana, owai, yemba kava es eva ata nombolvhoavav! Pivva ata verava, mongawulm engara, wo manam yimba kamba okilamnavav, engalva yeiva. Yimba mongona kembellamba gavrava, eva kava no kembellamba provavta, wo kava yetindilm nilhavav, wo Sesoamba kava os eva sembayang venavrata, ten pev vivm. ");
INSERT INTO wrs_vpl VALUES ("RT1_17","009_1_17","RUT","1","17","17","Yemba diva dahatava, eva kamba si di dahavavta, wo kamba di singvivav. Pimba mongawulm wohahamana evevra, wo mani eva si pimba aputkat verombolvav, owai, Sesoa si kamba esesmba venavav no putkitrava. Endahawolangas si pimba aputkat verombolvav. ");
INSERT INTO wrs_vpl VALUES ("RT1_18","009_1_18","RUT","1","18","18","Doa Naomi nengna, Rutva nihnapehna ov, wo hengava ovomnanamoa. ");
INSERT INTO wrs_vpl VALUES ("RT1_19","009_1_19","RUT","1","19","19","Doa Naomiva Rutmba kolmba os waingana, doa hev engolanamba, di talalna Betlehem kembella epho. Wo nomba deuvnindva evekingil vithina, hemba nungeilvnamba, una pai, Naomi henga men yimba provma? ");
INSERT INTO wrs_vpl VALUES ("RT1_20","009_1_20","RUT","1","20","20","Wo Naomi hev unna, manam yimba kana nihilva osva sevrivav, Naomi, owai os uvm, Mara, kava ungevlirinikokla av. Manara, Sesoa, noi keknamangas wohavm, kamba doa indkokla vrena, wo noinda kava peliva otolhuiva av. ");
INSERT INTO wrs_vpl VALUES ("RT1_21","009_1_21","RUT","1","21","21","Kava seilva hona kembellava avnamba, kava ata manam eva sahta owai, wo heva os Sesoava henga doa kamba waiproi posal. Pina Yutana moanamba Naomimba osm uv, indk vethav, wo manam yimba kamba hengava osva sevrivav Naomi owai, noinda Sesoa mendekli doa kamba kinwonda snavema plothomnana. ");
INSERT INTO wrs_vpl VALUES ("RT1_22","009_1_22","RUT","1","22","22","Naomiva henga Rutm kolm waiprona Moap petharini, wo no Rutva himba Moapongorini avna. Wo himba os ephona Betlehemrava, kembelnindva doa sihavna, bali aembulva osoriniva thelm mengnamba. ");
INSERT INTO wrs_vpl VALUES ("RT2_1","009_2_1","RUT","2","1","1","Wo diva Betlehemrava mongo tendorini lohvna, nihilva henamba Boas, himba Elimelekna mongawatindirini. Wo no Boasva himba wohtowond lohvna, mendekli kuwulva wulluhunvna. ");
INSERT INTO wrs_vpl VALUES ("RT2_2","009_2_2","RUT","2","2","2","Wo Rutva Naomim omnana, kava doa galm vev, dom ten andranind bali aembul thivm, balipeta andranindna englamohrini dalinvm, wo nom petharinim tongolm pivm mengnam, wo no andranindva kamba osva umnitava, sis proota. Wo Naomi omnana, gaota, memba kana Yutanindna wevsa. ");
INSERT INTO wrs_vpl VALUES ("RT2_3","009_2_3","RUT","2","3","3","Doa Rutva ganamba, di nongalpho no andranindm, hev umnina, manapenam proota. Doa hev ga, andranindm engalgavna, bali aembul tongolm, nom ten englamohrini dalinvm. Doa Rutva os venamba, Boasna ambsalla pho titnam, eindilna mongawatindiriniinda. ");
INSERT INTO wrs_vpl VALUES ("RT2_4","009_2_4","RUT","2","4","4","Doa nonamba Boasva deuvrini venamba, osoram dom nonglalm gavna, hevna andranindm nongalalm. Wo andranindm sehmona mapotho vewol ovovna, Sesoa Yawe yemba wonandra vev, wo eva no andranind opulvona, Sesoa eva yemba nesmos vrevta. ");
INSERT INTO wrs_vpl VALUES ("RT2_5","009_2_5","RUT","2","5","5","Wo Boasva Rutm di osora nonglanamba, nom andranindna kuwulm osahmana, andini temba ungevliriniva? ");
INSERT INTO wrs_vpl VALUES ("RT2_6","009_2_6","RUT","2","6","6","Wo he omnana, temba Naomina kol Moapongorini, ten Naomi waipronam. ");
INSERT INTO wrs_vpl VALUES ("RT2_7","009_2_7","RUT","2","7","7","Wo simekumbra himba kam sahmanavna, oi, kava yem andranindm sis engalpralm vev, bali aembulm tongolm kavm mengnam. Himba doara heva lohvhoai simekumbra, veiva, doa daipota men, wo daipota ambo men avhoav osoruvrava. ");
INSERT INTO wrs_vpl VALUES ("RT2_8","009_2_8","RUT","2","8","8","Doa Boasva domba ganamba, Rutm omnana, kam hello. Manam yimba osva vevav, mongona osonindm engalga, bali aembul tongolm, aembu. Yeoa huiangas tongka vawovm, men kana andranind unguvli andra vewuvm. ");
INSERT INTO wrs_vpl VALUES ("RT2_9","009_2_9","RUT","2","9","9","Yeoa hem naengho vewol vevm, himba domba angavrava, eva yeoa dom tongolm sis petheinvm pevm mengnam. Doa kava ishuni kavna andranind tendomba, yemba himba si indkokla vrivavmoa. Wo yenamba innemolva kongla verava, noi andranindna po ninu, ten doara longwol vi, dembri. ");
INSERT INTO wrs_vpl VALUES ("RT2_10","009_2_10","RUT","2","10","10","Doa Rutva kuva os kusithamnana petharamba, omnana, kava ambo ungundunguvlirini, manara yimba kamba osva nesmos vrei? ");
INSERT INTO wrs_vpl VALUES ("RT2_11","009_2_11","RUT","2","11","11","Wo Boas omnana henga, doara kava hellena, osva yimba nesmos vrowol vevna Naomiputowam ongapevm, nonamba talapevmba dahavnamba, veiva, daipota men. Wo kava nonora lohv, yimba os vena, pevna ararapevmba sandhalaha provna, kembelva wuleihalaha provna, wo yimba hom provna, tendona ungevlinamba seilva yimba nongalnamoa. ");
INSERT INTO wrs_vpl VALUES ("RT2_12","009_2_12","RUT","2","12","12","Yimba temba nomba vaomana venamba, Sesoa Yawe yemoa nesmos vrera noindaoa. Yimba os nengvna, kava peli av, wo Sesoa hev kamba kekalvho vremnavra Yuta petharava, wo noinda yimba homba pronamba. Wo Sesoa yemba si esesm henga beswonam venavav, wo yemba manavemava si pilivhoavav Sesoanamini. ");
INSERT INTO wrs_vpl VALUES ("RT2_13","009_2_13","RUT","2","13","13","Wo Rut henga ona, mendekli, kava ambo memba ungundunguvlirini, yena kava andra vevmoa, heva os owai, yimba kamba moa besal ishomnav, wo kava indk vethav. ");
INSERT INTO wrs_vpl VALUES ("RT2_14","009_2_14","RUT","2","14","14","Doa dawonam innemba hlavnamba, Boas Rutm omnana, prorava, inne yem men ka poavlahamniva, neluspora veltharava, os neo. Wo noinda Rutva osva vena, andranind tendona ongana waihlavna. Doa monglava balimovolva suwerava singinamba, Boasva Rutm dembrahona. Doa Rutva no innemba nenamba, e pilivhoamnanamba, monglava dembhana dawonam. ");
INSERT INTO wrs_vpl VALUES ("RT2_15","009_2_15","RUT","2","15","16","Doa innemba nepianamba, Rutva ganamba, bali henga osora tongvna. Wo Rutnisra Boasva hevna andranindmba ishunna, osva manam yimba Rutmba otindivav, noi himba ata tongvra murapetarini, ten niskovakova lohvm. Wo nomba yimba temba nisvund vipieiva, nominioa henga monglaoa vilvrombol vivrava, pethara dembhivm, wo Rutva ata prorava, noi tongvav, wo manam yimba otindivav. ");
INSERT INTO wrs_vpl VALUES ("RT2_17","009_2_17","RUT","2","17","17","Doa nonamba Rutva os andra vawona, venamba, okombava singvalva vevnamba, bali tongawovna di osora. Doa tongavnamba, tith vewol ve. Doa tith vewol vepianamba, lengelva kelva nomba pingavna, nihilangas dembravna. Wo nomba baliwondava kinmba os vevna i, oi newulvusona. ");
INSERT INTO wrs_vpl VALUES ("RT2_18","009_2_18","RUT","2","18","18","Wo Rutva ongalputowam Naomim pulnonglapho, wo Rutva ongalputowam onungnathamnana no baliwondava, innemungilva nomba dembrahona, ten Boas hevm okombanam wainenam. ");
INSERT INTO wrs_vpl VALUES ("RT2_19","009_2_19","RUT","2","19","19","Wo ongalputowa osahmana, pai, hi yimba detiva baliandrava vei? Anna osorini yimba baliva tongoi? Sesoa henomba nesmos vrei, temba henomba yemba nesmos vreiva. Wo Rut omnana, mongo tendorinina osorini kava tongoi, tendoriniva nomba os alv Boas. ");
INSERT INTO wrs_vpl VALUES ("RT2_20","009_2_20","RUT","2","20","20","Naomi omnana, Sesoa Yawe Boasm nesmos vrera, noinda yemba himba nesmos vrei. Boasva nomba Elimelekna kana talana mongawatindirini, wo pimba si nesmos vewol vevra. Sesoava mendah pimba ninginv, wo mendah nengaomana vinv pina talamba, temba doarava endahawolnamba. Sesoava pina talamba maivevmoa, wo osva Sesoanapopol Boasva pimba nesmos vewol vev. ");
INSERT INTO wrs_vpl VALUES ("RT2_21","009_2_21","RUT","2","21","21","Wo Rut omnana, mongmomba mendah lohv, yemba kava ishomnimoa, os kamba omni, yimba hui si wohtongka vawovra, verava, balina witna kana andranind thipieira. ");
INSERT INTO wrs_vpl VALUES ("RT2_22","009_2_22","RUT","2","22","22","Wo Naomiputowa ona, lehra, osm yimba mongona tendorinina osoriniva tongtava, yemba si indkokla vrivav. Lehra yimba Boasna andranind unguvlimba engallohmana vev, balimba tongolmba. ");
INSERT INTO wrs_vpl VALUES ("RT2_23","009_2_23","RUT","2","23","23","Wo noinda Rutva osva vena, baliva witva Boasna osorini tongawovna, venamba, thipieina, doa venamba, ambo ongalputowa Naomi waialohvna. ");
INSERT INTO wrs_vpl VALUES ("RT3_1","009_3_1","RUT","3","1","1","Doa dawonam Naomi Rutm kolm omnana, kava tendorinim silelalm venav yem, osm yimba pevna deuvra di wohavra beswonam. ");
INSERT INTO wrs_vpl VALUES ("RT3_2","009_3_2","RUT","3","2","2","No tendorinina nihilva Boas, pev ten hena andranind unguvlim engallohmana vevnam, yimba nonora, himba pina owal, Elimelekna mongawatindirini. Beswonam hello, daipotava hona sinimba ata Boasva balim lesvhoawol vawovav andra vuhera mongavhora. ");
INSERT INTO wrs_vpl VALUES ("RT3_3","009_3_3","RUT","3","3","3","Yeoa boasna veo, pora daloho, wel sandana pevm nihra selvo, kayen besal vewol veo, wo dom nongao, ten Boas andra vevm, wo heva os manam yimba pevmba lelnamba ambara vethavav, ambo dawonam kethalohvm. ");
INSERT INTO wrs_vpl VALUES ("RT3_4","009_3_4","RUT","3","4","4","Boasva innemba nepiarava, ninmba lithalmba vevrava, yeoa os novna vrevm, osm ora, ten nolhara ata lithavav. Wo verava, himba ninpolva kovopevrava, domoa os gao, garava, silimut mulm liomnarava, di lithamna monglatomra. Osm ambo vevra, yeoa kam pethamno. Wo Boasva nonora lohv Yutanindna wevsamba, ata heva hev yemba omnavav, ora notongo veo, ora yemba kava si osva pethamnavav. ");
INSERT INTO wrs_vpl VALUES ("RT3_5","009_3_5","RUT","3","5","5","Doa Rut Naomim henga omnana, ata kava os wohvevavta, men pev kam ishomnavm. ");
INSERT INTO wrs_vpl VALUES ("RT3_6","009_3_6","RUT","3","6","6","Doa sinim Rutva nonganamba, di pho, Boas ten bali huhul vewol vawovnam, wo os wohvena, ten doara Naomi hevm ishomnanam. ");
INSERT INTO wrs_vpl VALUES ("RT3_7","009_3_7","RUT","3","7","7","Doa Boasva heva vena, inne nepianamba, hevm beswonamangas avna, venamba, nitata vilpromnavna, venamba, doa dom ga, bali di huhul vewol velvohvm, di ambo wohlithana. Doa Rutva ambo ewonapetam pronamba, silimut mulm lionamba, Boasna monglatomra litha. ");
INSERT INTO wrs_vpl VALUES ("RT3_8","009_3_8","RUT","3","8","8","Doa sihovranam Boasva nov pevhoawolnamba, ona imharavho vrena, nonglana, pai, memba ungevlirini liv kana monglatomrava, ");
INSERT INTO wrs_vpl VALUES ("RT3_9","009_3_9","RUT","3","9","9","wo hev omnana, an yimba? Doa Rut omnana, memba ka Rut. Yimba mendekli lohv, Elimelekna mongawatindirini lohv, no Elimelekva himba kanamba eindil lohvna. Talamba kanamba doa dahana, wo kava yemba os osahmanav, pevna wevolm veo, pev ten vivm, kamoa ye pethao, osm kava beswonam avra yeinda. ");
INSERT INTO wrs_vpl VALUES ("RT3_10","009_3_10","RUT","3","10","10","Doa Boasva Rutm omnana, Sesoa Yawe yemoa nesmos vrera, manara, tendo towondva mindnam huiva lovahv, monglava wohtowond, monglava wohhuinind. Heva os owai, yimba monglamba tendo towondmba ishungu vinvnamoa, osva kamba lehra mongova vravav, owai, yimba kamangas ishomni. Ongapevpa Naomiva pevnamba yimba nesmos vrevna, wo eva yimba kamba osta mindnam veni, wo doa yimba kamba omni, kam pethao. ");
INSERT INTO wrs_vpl VALUES ("RT3_11","009_3_11","RUT","3","11","11","Huiva tendomba mendekliva indkumbi yemba nonora lovahmanav, oi, ungevlirini besal av. Manam yimba duus vevav, kava si os yemba venavav, pev men oim. ");
INSERT INTO wrs_vpl VALUES ("RT3_12","009_3_12","RUT","3","12","12","Tanam yimba oi, osva kava Elimelekna mongawatindirini, heva os tendoriniva mongova huiva lohv, Elimelekna mongawatindirininonoa, kava ahalpeta lohv. ");
INSERT INTO wrs_vpl VALUES ("RT3_13","009_3_13","RUT","3","13","13","Yimba daipotava sinimba hui av, simera heva kava no tendorinimba silelvav, ora es nengv. Himba osva otava, kav vrav, manapenam. Wo himba osva otava, owai, osva ka yemba vravav, waiamana vevav. Sesoa Yawena novra yemba kava tanamolnam ishomnav. Doa henga hui ao, verava, lingil lihara. ");
INSERT INTO wrs_vpl VALUES ("RT3_14","009_3_14","RUT","3","14","14","Doa Rutva os wohvena, simba mendah kukvilihavna, himba pholahangavna, noinda Boas venana, ata homeis kana andranind yem nunglivm. ");
INSERT INTO wrs_vpl VALUES ("RT3_15","009_3_15","RUT","3","15","15","Wo Boas Rutm omnana, ye pevna kayen wovthao, doa Rutva wovthanamba, Boasva nosra baliva ihmanavna mindnam, venamba, sambla velaworamsna pilivhoawolmanana no kayennahonam, venamba, Rutna lura epolotho. Doa os meis evewolna, vena Rut gana, Boas gana. ");
INSERT INTO wrs_vpl VALUES ("RT3_16","009_3_16","RUT","3","16","16","Doa Rutva henga os pulpeihna deuvram, Naomiputowam pulnonglapho, wo Naomiputowa osahmana, es hevpa Boasva yemba omni? Wo Rutva Naomimba ishomnavna nom, hevm ten Boas ishomnanam. ");
INSERT INTO wrs_vpl VALUES ("RT3_17","009_3_17","RUT","3","17","17","Henga ona, wo henga Boas kam omni, ata yimba ombawondanamba es nonglaphovav ongapevputowamba, bali honi kethanguao. ");
INSERT INTO wrs_vpl VALUES ("RT3_18","009_3_18","RUT","3","18","18","Wo Naomi ona, Boasna wevsava kava nonora amnav, deti ata gavav, moamba isholva honamba pinamba. Manam pimba duus evevav honamba, dawonam ambo ahavai, mani si phovav Sesoanaminiva. ");
INSERT INTO wrs_vpl VALUES ("RT4_1","009_4_1","RUT","4","1","1","Doa Boasva nungi ganamba, di monamilla avna, ten doara kuksa velvohvm. Nonglanga vena, pai, ten kana sehelva kohangav, ten doara Boas Rutm ishomnanam, Elimelekna mongawatindirininonoa. Doa Boas hem wunuhomna, e, seh hom dawonam kam engpratok, hui avhoarava, kava moapeta yemba isholm wulamnav. ");
INSERT INTO wrs_vpl VALUES ("RT4_2","009_4_2","RUT","4","2","2","Doa henga Boas vena, 10pelara mendekli kuwulm nemba no kembelnindm, unna, aevtho, kana moam boasna hillu, os avhoaprana. ");
INSERT INTO wrs_vpl VALUES ("RT4_3","009_4_3","RUT","4","3","3","Doa hev no sehelm omnana, yemba kava isholm venav Elimelekna moam, pivna mongawatindirininam. Naomiva peli Moap petharini himba henga doa prona hom, wo kava men yem ishomnav, himba tlalnapuwulm petham kovoraholm vinv tlalna mongawatindim, wo hevpa di dombvra. Himba nomangas ninginv Elimelekna mongawatindimangas. ");
INSERT INTO wrs_vpl VALUES ("RT4_4","009_4_4","RUT","4","4","4","Kava yemba osm isholm venav, yimba hona pethamba kovovralmba vetava, wohorava, wo yemba indkumbi kuwulva ata hillivav, men kusoim hui, eva mongla kembelnind. Wo no pethava yimba kovovralmba owai vetava, kam osoa ishomno, manara kava ahalpeta lohmanav, mongova eva owai. Wo no Boasna sehel ona, ka si no pethava wulluhvav. ");
INSERT INTO wrs_vpl VALUES ("RT4_5","009_4_5","RUT","4","5","5","Wo Boas henga omnana, wouta, wo Naomiva yemba hona Elimelekna pethava wuleihamnatava, yeoa Rutmoa Elimelekna kolmoa eva vraota, memba pina wevsava. Wo Rutva yeindava ombolva lengrava, kava si os umnivra, Malonna vuheram, ten Rutna tlalm seilm dahanam. Wo no Elimelekna pethava no ombolva si wohvaohothovav. ");
INSERT INTO wrs_vpl VALUES ("RT4_6","009_4_6","RUT","4","6","6","Wo Boasna sehel henga ona, owai, kava Rutmba vravavmoa, manara, kana ombolnonoava si vaohothovavmoa no pethava, no pethava no Rutna ombol si vaohothovav, mongova owai. Kava owai, ye Rutmoa petharava, petham osoa wulluho. ");
INSERT INTO wrs_vpl VALUES ("RT4_7","009_4_7","RUT","4","7","7","Wo seilva Yutanindva os vivna, mongova indhanariniva pethava kovovrahovnamba, manavemanava sesmba among veka vevna owalmongo, himba hevna spatova selvoravna, henom selvrahovna, nom ten petham kovovravnam, wo no indkumbi osva nunglutithueivna, doa moamba ihisho epiei. ");
INSERT INTO wrs_vpl VALUES ("RT4_8","009_4_8","RUT","4","8","8","Wo Boasna sehelva hevna spatova monglarini selvranamba, Boasm selvrahona, ona, ye pethaoa daha wulluho. ");
INSERT INTO wrs_vpl VALUES ("RT4_9","009_4_9","RUT","4","9","9","Wo Boas nom mendekli kuwulm 10pelaram, eva indhana monglam unna, doa yimba nunglutithuei. Doa men kava Naomimba diva dembraohv, wo Kilionina Malonina puwulva kava vaohothovav, ten seilm hena aral Elimelek wulluhunam, ");
INSERT INTO wrs_vpl VALUES ("RT4_10","009_4_10","RUT","4","10","10","wo osoa eva Rutva kava kavm vrav Malonna peliva. Wo osm no Elimelektindiva si vitivhoavavmoa, wo hevna pethava si Rutna ombol vaohuthivav huiva. Doa yimba men pev nunglutithuei. ");
INSERT INTO wrs_vpl VALUES ("RT4_11","009_4_11","RUT","4","11","11","Wo no mendekli kuwul 10pelara eva indhana indkumbi umnina, lehra, doa kava nunglutithuei. Sesoa Yawe si Rutmba nesmos vrevra yena deuvrava, wo otolmba mindnam towand vevra, os ten Reseli Leai towand evevnam, no Reselva Leava pina tomonalna Yakopna ongal sambla ahana. Si yimba mendekliangas lohvra kana Evratatindilm hui Betlehem kembella. ");
INSERT INTO wrs_vpl VALUES ("RT4_12","009_4_12","RUT","4","12","12","Wo Sesoa Yawe si verava, yena Rutina otolva si mendekli kuwulva wulvahvav indhanana novrava, os ten Perestatana seilm mendekli lovahvnam, no Peresva yena simbel luhunna, Yutaina Tamaina ombol. ");
INSERT INTO wrs_vpl VALUES ("RT4_13","009_4_13","RUT","4","13","13","Doa Boasva Rutmba wohvraulna, wailimana vevna, wo Sesoa Rutm nesmos vrevnamba, Rutva ena avna, wo doa os lengna tuendisrinimba. ");
INSERT INTO wrs_vpl VALUES ("RT4_14","009_4_14","RUT","4","14","14","Wo nonamba ungevli indkumbi Naomiputowam umnina, kava Sesoam okuliv, he yem beswonam vrei, detiva yena umbeindilva doa powolai, wo no yena umbeindil mendekli luhunda pina Yutanindinda. ");
INSERT INTO wrs_vpl VALUES ("RT4_15","009_4_15","RUT","4","15","15","Kopevpa yenamba Rutva seilva yemba und vevna, wo yemba kekalvho vrevna os i. Monglava indhanamba osva vewol vivmoa, memba Rutva vevnamba. Wo himba doa lengi yena ombendpevpa, wo no ombendpev yemba si lunitilm lotholohmanavav yunalmba, wo yemba si dahomana vevav, verava, yemba ongaklatov vera. ");
INSERT INTO wrs_vpl VALUES ("RT4_16","009_4_16","RUT","4","16","16","Doa Naomi otolm nom waiamana vevna, ona, kana ombol, ");
INSERT INTO wrs_vpl VALUES ("RT4_17","009_4_17","RUT","4","17","17","wo ungevli indkumbi moa ishuwul vevna, ona, lehra Naomina umbeindilva doa polana, wo ombolva nomba Opetm awuna, Opetva memba osm uv, lunit Yutanindna moana. Doa Opetva os lohna, wo sism hemba mendekli venamba, Yesina aral lohna. Wo no Yesiva mendekli venamba, Devitna aral lohna, no Devitva Yutanindna kuwul wulluhunvna. ");
INSERT INTO wrs_vpl VALUES ("RT4_18","009_4_18","RUT","4","18","18","No Devit kuwulva os lohna Peresna sespal. Peresna ombolva Hesron, ");
INSERT INTO wrs_vpl VALUES ("RT4_19","009_4_19","RUT","4","19","19","no Hesronna ombolva Ram, no Ramna ombolva Aminatap, ");
INSERT INTO wrs_vpl VALUES ("RT4_20","009_4_20","RUT","4","20","20","no Aminatapna ombolva Nason, no Nasonna ombolva Salmon, ");
INSERT INTO wrs_vpl VALUES ("RT4_21","009_4_21","RUT","4","21","21","no Salmonna ombolva Boas, no Boasna ombolva Opet, ");
INSERT INTO wrs_vpl VALUES ("RT4_22","009_4_22","RUT","4","22","22","no Opetna ombolva Yesi, no Yesina ombolva Devit. Doata Rutna moamba. ");
INSERT INTO wrs_vpl VALUES ("JH1_1","033_1_1","JON","1","1","1","Yawe Sesoana moashulnindrini mongo doara lohna, nihilva henamba Yona, Amitaina ombol. ");
INSERT INTO wrs_vpl VALUES ("JH1_2","033_1_2","JON","1","2","2","Hev omnana, phorava, honaminioa dom gao Nineva kembellam, wo di kana moam ishomana vinvm, no kembelva mendekli lohv. Os ishunu, Sesoava doa yenamba nunglinna, yimba ambo sahonam av. ");
INSERT INTO wrs_vpl VALUES ("JH1_3","033_1_3","JON","1","3","3","Wo heva os owai, Yonava osva venamoa, himba Yawemba ona nombolvhoa lahangana, wo himba Ninevaramba ganamoa, himba indanam gana Yopa kembellam wandam. Wo diva mongova botva vohalm vevna Yopariniva, Tasis kotaram wanda mongnahalm. Doa Yonava no botna aralm di dembrahona, vongo botra. Os nengvna, kava Yawenaminiva wohgalm vev. ");
INSERT INTO wrs_vpl VALUES ("JH1_4","033_1_4","JON","1","4","4","Doa botva nomba Yopariniva vohavna wanplombmonam, doa botva mendah monamba hovrahovra ona gana, Yawe vuvi mendeklim deuhpho. Deuhphonamba, vuviva wanplombrava mendekli vevna, ombokva mendekli vevnamba, wo botva indkokla vevna. ");
INSERT INTO wrs_vpl VALUES ("JH1_5","033_1_5","JON","1","5","5","Wo no botna andranindva pemba esvema vivna, nokovhoawolnapenam os i. Wo himba vivnamba, hevna tihm indakonda wewusa unvna, no tihmba himba doara sembayang velvohinvnam. Wo no andranindva mendah wewusa unvnamba, wohva himba botriniva deimbvnamba, wanmera dembrapuv vevna, os ningvna, ata kava vikokowonam beswonam angavav, kinmba doa kava dembhapuv vipiei. Heva os owai, eva vikokolva, botva mendah powalwolalm wohvevna. Nomba andranindva diva vivnamba nonamba, Yonava himba bot endallam pihanamba, di ninpol wohkovopena. ");
INSERT INTO wrs_vpl VALUES ("JH1_6","033_1_6","JON","1","6","6","Yonava ninpol doara wohkovopena, wo botna aralva ganamba, Yonam dandwonam velanongla ovravna, pai, yimba ambo ninm proima? Pho, wo pevna tihm sahmana, nom ten pev sembayang velvohmanavm. Os sahmano, kam wavra vovhueinu. Wo pimba ata osva nokovhoawol vilovavmoa. ");
INSERT INTO wrs_vpl VALUES ("JH1_7","033_1_7","JON","1","7","7","Botna aralva os Yonamba omnanamba, doa andranindva nomba os hevm eishovna, piv hona vuvina plalm aslalvai, manara pimba indkokla vilolmba vev? Anna indkoklava dihi lohv? Doa aslalanamba, wo osva himba nunglina, Yonana indkoklava lohvna. ");
INSERT INTO wrs_vpl VALUES ("JH1_8","033_1_8","JON","1","8","8","Doa hev alalkohona Yonam, doa kava aslali, yena indkoklava dihi lohv, wo noinda pimba indkokla vilolmba vevna, ata pimba nepola vilota. Es hevpa yena indkoklava tanam lohvmi? Wo hev os sah ovrivna, yimba esalm prona? Snal yenamba moamba? Andini yimba? ");
INSERT INTO wrs_vpl VALUES ("JH1_9","033_1_9","JON","1","9","10","Doa Yona unna, kava Hiprunindrini, wo Yawem kava sembayang velohmanav, ten Sesoa mendekli sena avm, hev ten doara vewolna wanim pethaim. Henaminiva kava wohgalm vevna, wo noinda hona yena botrava kava siheinna. Wo no botna andranindva pemba esvema vivna Sesoanapenamba, os umnina, pai, indkoklava yenamba nomba mendekli lohv, yimba Sesoana moamba nombolvhoa lahaprona. ");
INSERT INTO wrs_vpl VALUES ("JH1_11","033_1_11","JON","1","11","11","Doa nonamba vuviva esvemava daihavna, ombokva mindnam vevnata, wo no andranindva henga Yonamba umnina, ata yemba kava es vinivav, wo noinda wanmba ata beswonam lithavav hevnavhora, pimba beswonam ata aevulvav? ");
INSERT INTO wrs_vpl VALUES ("JH1_12","033_1_12","JON","1","12","12","Wo Yona unna, ambo kam wanplombra pilpipovo, wo noinda wanmba ata beswonam lithavav. Noinda viu, kava indkokla vena, Sesoana moamba kava nombolvhoa lahaprona, wo hona vuviva pimba noinda indkokla vewolalmba vev. ");
INSERT INTO wrs_vpl VALUES ("JH1_13","033_1_13","JON","1","13","13","Doa andranindva henga botm wulangalm vevna engalpethallam. Heva os owai, botva ombokra saha vrevna, hengava galmba engalpethallamba. ");
INSERT INTO wrs_vpl VALUES ("JH1_14","033_1_14","JON","1","14","14","Doa no botna andranindva Yawem mindnam ishumnivna os, kava ata hona tendoriniva Yonamba pilpipovvav wanplombra, wo manam yimba kamba hengava esesmba indkokla vewol vevav henilmba. Manara, yimba Yawe, pev vuviva honamba deuhphoi. Wo manam yimba kamba osva ishunvra, temba pevpa ishunvpa no pevna indhanamba, temba helvakomo vewol vivpa owalmba. ");
INSERT INTO wrs_vpl VALUES ("JH1_15","033_1_15","JON","1","15","15","Doa Yonamba os kevrinamba, botriniva wanplombra pilpipovna, wo wanmba lilnam henga hevnavhora beswonam lithavna. ");
INSERT INTO wrs_vpl VALUES ("JH1_16","033_1_16","JON","1","16","16","Wo osva botna andranindva mindnam pem vivna, Yawenapenam, wo Yawem sembayang vinivna, tatamba wesang vinivna, wohweisumbul owolovna hemba. Os uvna, si kava Yawemba sembayang velvohmana venavav. ");
INSERT INTO wrs_vpl VALUES ("JH1_17","033_1_17","JON","1","17","17","Doa Yaweva wanmerinim tambkom mendeklim wolaihangana, Yonam wunukhoalm. Wo Yonamba tambkona emerava diva os ana, okomba samblamong si samblamong. ");
INSERT INTO wrs_vpl VALUES ("JH2_1","033_2_1","JON","2","1","1","Yonava tambkona emerava livnamba, Sesoam himba sembayang vaomnavna os, ");
INSERT INTO wrs_vpl VALUES ("JH2_2","033_2_2","JON","2","2","2","Yawe, yem kava ishomnav, hona indkoklava mendekliva kamba nonglaphoiva, wo noinda yem kava sahmanai. Kamba nepola velm vei, di indhanana sumbhol avm, wo yimba kamba hellei. ");
INSERT INTO wrs_vpl VALUES ("JH2_3","033_2_3","JON","2","3","3","Doa pev men kam wanplombmera holopipahai, wo os kava wan endallam pihai. Wan kamba wohehlithi, wo ombokva mendekli kasra sena vevna, no ombokva pev ten doara deuhphoim. ");
INSERT INTO wrs_vpl VALUES ("JH2_4","033_2_4","JON","2","4","4","Wo kava os omni, yimba doa kamba wohwolaihangai pevnaminiva. Heva os owai, os kava nengv, hengava kava si pevindava phovavta, diva mendekli temepelduvrava. ");
INSERT INTO wrs_vpl VALUES ("JH2_5","033_2_5","JON","2","5","5","Tanam, wanplombva kamba wohehlithi, wo wan ilva kamba ningei kura, wo kamba wusprovna, ");
INSERT INTO wrs_vpl VALUES ("JH2_6","033_2_6","JON","2","6","6","wo kava os nengvna, ata kava wan endalm nonglaphovav, di olona plalva lohv, kava di si yunalmba wohavav sahonamba. Heva os owai, yimba kana Sesoa lohv, wo pev kamba henga beswonam waivongai, wo henga mekava beswonam av. ");
INSERT INTO wrs_vpl VALUES ("JH2_7","033_2_7","JON","2","7","7","Kava os nengvna, kamba dahav, novpa kanamba velawosa vevna, wo noinda yemba kava sahmanalm vongai, wo yimba kamba hellei. Di pevinda mendekli tempelduvra yimba kamba hellapra vev, wo kamba deuhphoi. ");
INSERT INTO wrs_vpl VALUES ("JH2_8","033_2_8","JON","2","8","8","Monglava indhanamba yemba meis haravhueimniv, hevna tihsongomangas okolowol viv, heva os no tihva indhanamba kekalvho vewol vinvmoa. ");
INSERT INTO wrs_vpl VALUES ("JH2_9","033_2_9","JON","2","9","9","Heva os kavpa owai, kava si yemba sembayang vemnavav tatasowanahonam, wo yemba okolavra sangalna. Memba yemba kava wohishomniva, si kava vevav, manara, doa kava yemba lihai, yengas indhanamba lopshawol vev, noinda beswonam av. ");
INSERT INTO wrs_vpl VALUES ("JH2_10","033_2_10","JON","2","10","10","Wo doa nonamba Yaweva tambkom omnana, Yonam nongollahalm gao wan engallam beswonam. ");
INSERT INTO wrs_vpl VALUES ("JH3_1","033_3_1","JON","3","1","1","Doa Yaweva henga Yonam omnana, ");
INSERT INTO wrs_vpl VALUES ("JH3_2","033_3_2","JON","3","2","2","phorava, honaminioa dom gao Nineva mendekli kembellam, wo ishungu vinu no kana mendeklimom, ten seilm pevm kav ishomnanam. ");
INSERT INTO wrs_vpl VALUES ("JH3_3","033_3_3","JON","3","3","3","Wo Yonava no Sesoana moamba hellenamba, Ninevaram ga. Nineva kembelva nomba mendeklinonoa wohlohvna, wo kembelhovmonamba indhanamba angavnamba, simba samblamong vewol velvohvna. ");
INSERT INTO wrs_vpl VALUES ("JH3_4","033_3_4","JON","3","4","4","Wo Yonava no kembelhovmonam mongawa okombanam ganamba, doa kembelnindm os ishunna, doa mongova weisva khuarava, wo eunumbulwusnam nonam, Sesoava si yemba indkokla vewol vevav, wo yemba si os mueisowa vevav. ");
INSERT INTO wrs_vpl VALUES ("JH3_5","033_3_5","JON","3","5","5","Doa Ninevanindva os no Sesoana moamba hillina. Indkumbi himba hillinamba, kuwul eva ombandhana, wo hevm eishovna, lehra oita, pimba indhanakokla, wo doa pioa sahoklaoa maivethalvohra. Os pimba si innemba lovahavra, wo kayenmba kolol pimba vewol vivra, wo osva Sesoava si pimba nongalvra, doa himba wenumbsna av. ");
INSERT INTO wrs_vpl VALUES ("JH3_6","033_3_6","JON","3","6","6","Doa Ninevanindnamba king kuwulva no Sesoana moamba hellenamba, hevna kursiva besalva wuleihalahaphonamba, kayenmba besalva selvvrana, kayen kolol vethavna. Vethanamba, doa smovsram holvape, di avna, osm vevna, Sesoana novra kava indhanakokla. ");
INSERT INTO wrs_vpl VALUES ("JH3_7","033_3_7","JON","3","7","7","Doa king kuwul kembelnindm moa ishonga vinna os, kava yena kuwul luhunv, ka mongla mendekli yena, os yemba kava ishunv, manam yimba innemba hlavav, aembu. Pevna deuvtatava manam yimba innemba pomba dahwol vivra. ");
INSERT INTO wrs_vpl VALUES ("JH3_8","033_3_8","JON","3","8","8","Kayenoa kolol vewol viu, pevm eva pevna deuvtatam, wo Sesoam pepthanam sahvungo vinivm. Daipota pevna indkoklaoa yeoa wuleihu, notongom, notongom, ");
INSERT INTO wrs_vpl VALUES ("JH3_9","033_3_9","JON","3","9","9","Sesoava dihi no lomomomba maivethalm vev, wo si pimba osva indkokla vewol vevavmoa. ");
INSERT INTO wrs_vpl VALUES ("JH3_10","033_3_10","JON","3","10","10","Doa Sesoa nongalna Ninevanindmba, ona, hevna indkoklava doa wuleihina. Wo himba wavra vovhueinnamba, noinda hevna undmba weihaloh vrevna, indkokla vewol venamoa, beswonam. ");
INSERT INTO wrs_vpl VALUES ("JH4_1","033_4_1","JON","4","1","1","Doa Yonava os nonglavna, Yaweva Ninevanindm indkokla vewolalmba vevmoa, wo noinda hemba wusprovna, ");
INSERT INTO wrs_vpl VALUES ("JH4_2","033_4_2","JON","4","2","2","Yawem ishomnavna os. Kava seilva diva kavna petharava avnamba, kava yena wevsava nengvna, yimba indhanamba wavra vewol vinv, yemba lelnamba wusprowol vevmoa indhanana indkoklarava. Yimba indhanamba nongalvpa, himba hevna indkoklava wuleihiv, wo yimba si os pevna undmba weihaloh vrevav, indkokla vewol vevavmoa hemba. Os kava yemba nonora lohmanav, wo noinda kava lelnam wohgana yenaminiva mongona petharam, yena moamba nombolvhoa lahangana. ");
INSERT INTO wrs_vpl VALUES ("JH4_3","033_4_3","JON","4","3","3","Ninevanindmba kana ungundmba yimba indkokla vewol venamoa, wo kamba noinda wusprov, wo kamoa dahara, kava lohvavmoa. ");
INSERT INTO wrs_vpl VALUES ("JH4_4","033_4_4","JON","4","4","4","Doa Yawe Yonam henga omnana, yena nengavnangva yunam besalma, ah? ");
INSERT INTO wrs_vpl VALUES ("JH4_5","033_4_5","JON","4","5","5","Doa Yonava Nineva kotariniva venamba, dom ga, okomba ten pholohvm, wo thindruvpeta venamba, di avhoa. Nineva kotanindmba nongalga vawovna, osm vevna, Yawe manavema vintami no kembelnindm? ");
INSERT INTO wrs_vpl VALUES ("JH4_6","033_4_6","JON","4","6","6","Doa Yawe Sesoava Yonamba nengmanana, ona, ka numhavav. Doa hev ona, wo noinda mongo weselva di polanamba, Yonana thindruvm ehlathavna, ata humeis vuvrevm, wusproa. Wo nonamba Yonava indk vethavna no wesellava. ");
INSERT INTO wrs_vpl VALUES ("JH4_7","033_4_7","JON","4","7","7","Doa simolnam venamba, simba bumbuthovnamba, Sesoava henga mongom simbetohom wolaihaprana, nomba weselva kovokusethavna, wo nomba weselva henga os wohsoulana. ");
INSERT INTO wrs_vpl VALUES ("JH4_8","033_4_8","JON","4","8","8","Doa okombava hovrahovra vevnamba, Sesoava vuvim suwepavalm wolaihapramnavna, no vuviva nomini prona, ten okomba pholohvm. Wo nomba vuviva okombahulva vevnamba suwepaval, wo Yonamba vuvrenamba, wo noinda hemba novluwul vovhoana. Wo Yonava mindnam duus vevna, os nengvna, kamoa dahara, kava lohvavmoa ");
INSERT INTO wrs_vpl VALUES ("JH4_9","033_4_9","JON","4","9","9","Wo henga Sesoa omnana, yemba yunam wusprovma hona weselkoklarava, ah? Wo Yona ophona, lehrata kamba wusprov. ");
INSERT INTO wrs_vpl VALUES ("JH4_10","033_4_10","JON","4","10","10","Wo henga Yawe omnana, weselva nomba mongnasiva polanamba, mongnasiva henga soulavna. Yimba pevpa endhanamoa honamba, yimba piara vrenamoa, wo es hevpa yemba wusprov noindava? Memba yemba wusprovpa hona weselkolarava, ");
INSERT INTO wrs_vpl VALUES ("JH4_11","033_4_11","JON","4","11","11","wo eva kava wavra vovhueinvavta Nineva kembelnindmba. Manara, kota mendekli lohv, himba indhanamba eva indpetamma, 120,000pelara av, wo otolva mindnam diva wulaevv, nomba otolva tit viv araravalna indkoklava. Wo eva deuvtatava mindnam diva wulaevv. Doata Yonana moa. ");
INSERT INTO wrs_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Memba novol velohvpa moamba, Yesus Kristusnamba simbehumunilva os phona. Yesus Kristusva Devitva kuwultindirini lohna, himba Aprahamtindirini lohvna. ");
INSERT INTO wrs_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","No Aprahamna ombolva lohna, nihilva Isak. No Isakna ombolva mongo lohna, nihilva Yakop. No Yakopna ombolva lohna, nihilva Yuta, wo eva mongla towandal. ");
INSERT INTO wrs_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","No Yutana ombolsambla elohna, nihilva vei Peres eva Sera, hena avalva Tamar einna. No Peresna ombolva lohna, nihilva Hesron, wo no Hesronna ombolva lohna, nihilva Ram. ");
INSERT INTO wrs_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Wo eva no Ramna ombolva lohna, nihilva Aminatap. No Aminatapna ombolva lohna, nihilva Nason. Wo no Nasonna ombolva lohna, nihilva Salmon. ");
INSERT INTO wrs_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","No Salmonna ombolva lohna, nihilva Boas, hena avalva Rahap, himba ungund-ongorini avna. No Boasna ombolva lohna, nihilva Opet, hena avalva Rut, himba ungund-ongorini Moap petharini. No Opetna ombolva lohna, nihilva Yesi. ");
INSERT INTO wrs_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Wo no Yesina ombolva lohna, nihilva Devit, himba kuwulmendekli wulluhunna Israelnindnam. No Devitna ombolva lohna, nihilva Solomon, hena avalva Batsepa, himba Uriana peli avna. ");
INSERT INTO wrs_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Wo no Solomonna ombolva lohna, nihilva Rehopoam. Wo eva no Rehopoamna ombolva lohna, nihilva Apaisa. No Apaisana ombolva lohna, nihilva Asa. ");
INSERT INTO wrs_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Wo no Asana ombolva lohna, nihilva Yehosapat. Wo no Yehosapatna ombolva lohna, nihilva Yoram. Wo no Yoramna ombolva lohna, nihilva Usia. ");
INSERT INTO wrs_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Wo no Usiana ombolva lohna, nihilva Yotam. Wo eva Yotamna ombolva lohna, nihilva Ahas. Wo no Ahasna ombolva lohna, nihilva Hesekia. ");
INSERT INTO wrs_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Wo no Hesekiana ombolva lohna, nihilva Manase. No Manasena ombolva lohna, nihilva Amon. Wo no Amonna ombolva lohna, nihilva Yosaia. ");
INSERT INTO wrs_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Wo eva Yosaiana ombolva lohna, nihilva Yekonia, wo eva mongla towandal. Nonamba Yekoniava velohvnamba, ungundva Bapilonnind ambanamba, helvakomolm velmba Israelnindm, wena ningewol vivnamba, os wonanga vevna Bapilon petharamba. ");
INSERT INTO wrs_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Ungundva os vinna, wo henga sism Yekoniana ombolva lohna, nihilva Seltil. No Seltilna ombolva lohna, nihilva Serupapel. ");
INSERT INTO wrs_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","No Serupapelna ombolva lohna, nihilva Apiut. Wo Apiutna ombolva lohna, nihilva Eliakim. Wo no Eliakimna ombolva lohna, nihilva Asor. ");
INSERT INTO wrs_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Wo Asorna ombolva lohna, nihilva Satok. Wo no Satokna ombolva lohna, nihilva Akim. Wo Akimna ombolva lohna, nihilva Eliut. ");
INSERT INTO wrs_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Wo no Eliutna ombolva lohmanana, nihilva Eliasar. Wo Eliasarna ombolva lohna, nihilva Matan. Wo no Matanna ombolva lohmanana, nihilva Yakop. ");
INSERT INTO wrs_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Wo no Yakopna ombolva lohmanana, nihilva Yosep. Wo no Yosepna ongalna nihilva Maria, doa himba os Yesusmba lengna, indhanamba si os hemba alvra, himba Kristus lohv, Sesoa hemba doa pusvundthoana, Israelnindm kolvrowolalm. ");
INSERT INTO wrs_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Memba honamba Yesus Kristusna simbehumunil. Tomonalva seilkakalva Apraham luhunna, wo ombolva lohmanana, wo henga mongo. 14pelara honamba vaomana vena, henga yuholtho, henga yuholtho, venamba, Devitva os lohna. Devitna ombolva lohnamba, wo noi sespalva ana, honamba 14pelara vaomana vena, henga yuholtho, henga yuholtho, wo os nonam ungundva Bapilondiniva ambna, Yekoniamba ungund kevrina Bapilonda, wo ombolva henamba di lohna. Honamba os vaomana vena, 14pelarava os vevnamba, venamba, Yesus Kristusva men eunilliniva lohv. ");
INSERT INTO wrs_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Mariava Yesusmba lengvnamba, nomba moamba os lohvna. Doara doa heva pusvundthueina Mariamba osva, Yosep hemba si vravav. Wo heva os Yoseppa mendah vranamoa, wo eva mongawulmba waiamana venamoa, heva os doa Mariamba ena vethavna. Wo hemba Yoseppa vrenamoa, eva mongova tendoriniva owai, owai, Sesoasongol hemba poauothona, wo os hemba ena vethana. ");
INSERT INTO wrs_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Yoseppa besal lohvna, himba os nengvna, kava si Mariamba waiishuvav kuwulinda, eva hevna araravalinda. Wo henga hev nengna, owai, ata homeis Mariamba lou venavm indhanamoserava. Ambo kava hevna araravalm unvav, pinamba doaraminimomba os luhunv, ye ka pioa wuleihalohra, wo si kava Mariamba vravavmoa. Homeis si indkumbi eishomana venavm musera, Mariava doa indkokla vena. ");
INSERT INTO wrs_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Yoseppa os nengvna, doa heva os sinimba himba inungpunungra mendeklina ovsongolnindrinimba nonglana. Doa ovsongolnindriniva omnana, Yosep, yimba Devittindirini lohv, manam yimba engvavav Mariamba, osva gavra, owai, yeoa omno hemoa pevna ongalalm, wo waiamana veo hemoa. Doa himba ena av, wo heva os honamba indhanariniva venanamoa, owai, memba honamba Sesoasongol vena. ");
INSERT INTO wrs_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Mariava si sewonamba ombolva lengvav, wo os yimba awovav Yesus. Noinda osoa awo, himba si indhanamba lopshavav monakoklariniva, wo noinda osva Sesoava si hemba bui vewol vevavmoa hevna indkoklarava. ");
INSERT INTO wrs_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Honamba osm vinna Yosepimba Mariaimba, himba doaraminimomba wohehengvna, Sesoana moashulnindrinina moamba, ten ishunvnam, si os phovav sewonamba, os novol velohv, ");
INSERT INTO wrs_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","Mongova ongamalongoriniva si tlalhui avav, heva os ambo hemba si nis ena vethavav. Wo sismba himba si ombolmba lengrava, si os awovav Emanuelm, memba osm, pimba Sesoa wonav. ");
INSERT INTO wrs_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","25","Doa Yoseppa ninvhoriniva phonamba, os wohve, ten mendeklina ovsongolnindrini inungpunungra ishomnanam, Mariamba os wohvrana hevna ongalalm. Wo heva os owai, himba vruwulluhnamoa Mariamba, venamba, os ombolmba lengna, wo doa Yoseppa os awona Yesus. ");
INSERT INTO wrs_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","2","Mariava lengna Yesusmba Betlehemda di Yutia provinsra, nonamba kuwul Herotva di avna mendekli kuwulalm. Nonamba avalva Yesusmba lengvnamba, wo mongla sism nonoanindva mongona pethariniva ambvnamba Yerusalem kotaramba, wo hev osihinna indhanam, hi otolva lingilv, nomba si sewonamba himba mendekli kuwul wulluhunvav Yutanindnamba? Hev unna, kava nonglalm viv hem, seilva kava paim nunglina nosis, ten okomba pholohvm, wo kava nonora avna, hona paiva memba osm phoi, hona indhanariniva si sewonamba mendekli kuwul wulluhunvav. Kava aslalambei noinda homba, hemba nonglalmba, doa kava si os mulumbdandna lovahthamnavav hemba. ");
INSERT INTO wrs_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","5","Herot kuwulva nomba moamba hellenamba, osva mongova kuwulva si lohvav, wo himba os mindnam nengavnang vevna i, wo eva Yerusalem kotanindva himba mindnam evekingil vithivna no moarava. Herot onbanamba mendekli sembayang andranindnam, katekism, himba nonora avna doaraminimomba. Hev unna, yimba es ningminiv Kristusmba? Hi si avalva lengvav hemba? Katekis umnina, avalva si lengvav Betlehemda hui Yutia provinsra. Manara, noinda moamba doaraminimomba moashulnindnamba Sesoamomba os novol veluhunv, ");
INSERT INTO wrs_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","Yimba Betlehemnind, yimba Yutia provinsra aevulv, maim oi, kembel eusilnind, wo heva os owai, yimba mani ombandhanama kuwulna novrava. Noinda yerini si lohvav mendeklilmba. Himba si kuwul wulluhunvav kana Israelnindnamba vuhebesallamba, maim ora, besal kekalvhonindrini hevna sipsipm desimbuingav. Sesoa honamba ishunna Betlehemnindm. ");
INSERT INTO wrs_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","8","Herotva nomba katekisna moamba hillinnamba, doa himba nambavna nomba nonoanindmba ehalnindmba poaita. Himba hevho wonishovna, no moamba Herotnamba mongova indhanariniva owai, hilwilvnamoa. Herotva mindnam sahowol vevna, heniweisnam hevpa yimba no pai nemelmba nunglina, polavnamba? Doa himba ishumninamba, doa hev os wolanga vena, yeoa ango Betlehemdam, sahowol vilango indhanam, hi otolva, nomba si sewonamba Kristusva lohvav? Yimba nunglirava, wo henga hom ambo, kam ishumnu, wo eva ata kav garava, mulumbdandna lohvhoamnavav. Heva os owai, Herotva ambo dasalm unvna. ");
INSERT INTO wrs_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","No nonoanindva hillinamba Herotmba, wo os angana himba Betlehemdamba. Nomba paiva nemetva doarava temba himba nunglinamba, henga himba nunglina. Wo no paiva mi deisumbingavna, venamba, di wohlohvhoavna no deuvnalhra, Yesusm di lingilvnam. ");
INSERT INTO wrs_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","11","Doa no nonoanindva indk vithivna mindnam, una, pimba paiva beswonam desimbuiproi, doa hev no deuvra saivnamba, nunglie otolm. Mariava waiavna hemba, doa hev mulumbdandna lovahthamnanamba, Yesusm okulivna. Doa okulipieinamba, hevna wondam ashol vevnamba, woh besal dumbvnamba, dembrehue Yesusm, gol eva tinanal titeiuhnungna besal, eva paura sandana, diva os lohmanav i. ");
INSERT INTO wrs_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Doa osva vepieinamba, henga angalm vevna himba. No sinimba inungpunungra Sesoana moam hillie, unna, manam yimba hengava Herot kuwulindamba angavav, owai, manam yimba ishumnivav hemba. Doa os angana weilmonam hevna petharam. ");
INSERT INTO wrs_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Nonamba nonoanindva angavnamba hevna petharamba, Yoseppa no sinim inungpunungra nonglav mendeklina ovsongolnindrinim. Doa ovsongolnindrini omnana hem, pevm eva pevna avalombolm nungi lelnam wongao Isip petharam, dawonam di wonavm, heva verava, sewonam, yemba si ka omnavav, henga pro. Noinda Herotva si wolapra vevav valgonindmba homba, otolmba osmba ovra, men waiaevulv, helvakomo vivra. ");
INSERT INTO wrs_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","15","Doa no sinimangas Yoseppa phonamba hevna vuheriniva, os wohwongana Isip petharam avalombolmba, wo di dawonam aevulvna. Yoseppa wohengna doaraminimomba, mendeklina moashulnindrinina moamba, os novol velohv, Kana ombolva Isipra avna, wo kava os omnavav hemba, yeoa henga gao pevna petharam. ");
INSERT INTO wrs_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Herotva nengna, ona, kamba deswuhina no nonoanindva, himba ambo weilmonam angana mongnamonam hevna petharamba, himba kamba ishumninamoa, osva ten nolhra otolva lingilv. Wo noinda hemba wuspronamba, unna hevna valgonindm, yeoa saivrava Betlehemda, tuendism helvakomo vilango. Nomangas, ovra men sambla tahonnamba, eva nom hesnalm mendeklipetam, no nonoanindva doara kamba ishumnina, una, sambla tahonmba vewulnamba, nemelva paiva os powolana okombapholsis, wo kava nunglinamba, nonora avna, Kristusmba doa lengei. ");
INSERT INTO wrs_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Doa valgonindva saivnamba, os wohvina, ten Herot hev wohtnam, os otolmba tuendismba helvakomo vi. Himba wohengina moashulnindrinina Yeremaiana doaraminimom, no moamba os novol velohv, ");
INSERT INTO wrs_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","Indhanamba hillivna mongova mindnam wo vewol vevna Rama kembella. Reselangas mindnam wivewol vevnata hevna otolmba, wo eva an ata hemba enendmond ovravav, kana otolva doa wohdalei, hev wenamonam ona. ");
INSERT INTO wrs_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","20","Nonamba Herotmba dahanamba, wo doa mendeklina ovsongolnindriniva Yosepindam provna Isipramba, Yoseppa inungpunungra nongle. Yeoa ongapevmoa ombpovmoa pevna petharam Israelm wongao. Noinda no indhanamba, temba yena otolmba helvakomandhalmba vivnamba, doa doara dalpiana. ");
INSERT INTO wrs_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","22","Yoseppa os wohvena, hevna ongal ombolm os wongana Israel petharam. Wonphonamba, moamba os hellena, Herotna ombol aralna vhorava mendekli kuwulalmba wulluhunv Yutia provinsnindnamba, nihilva Arkelaus. Yoseppa pepeh vevna domba galmba, doa hev henga inungpunungra Sesoana moam hellena, manam yimba Yutia provinsrava avav, Galili provinsram gao. ");
INSERT INTO wrs_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Doa Yoseppa os wohvena, himba di avna Nasaret kembella. Himba wohengvna moashulnindrinina doaraminimom, Kristusmba, indhanamba si alvra os, himba Nasaret kembellini lohv. ");
INSERT INTO wrs_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","2","Doa venamba, Yonmba tetangamanamba lohvnamba, himba Sesoana moashulnindrini lohvna. Himba ganamba, sahal pethara amana vevna di Yutia provinsra. Himba undva wulluhunvna, Sesoamomangas indhanamba ishunilmba. Yeoa wuleihu indkoklamoa, Sesoam engivm. Sesoava nambav hevna nemel indhanam mongawatilm, yimba beswonam avav. ");
INSERT INTO wrs_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Yonmba wohengvna moashulnindrinina Aisaiana doaraminimom, no moamba os novol velohv, Indhanarini sahal petharava avna, himba keknam ishunvna, yeoa monaoa vuenghivm, osm si mendekliva beswonam engpravav. Monamoa nomoa selelevhoawol vivm, temba wulvongopiha vewol vevpa. Yeoa beswonamangas vivm. ");
INSERT INTO wrs_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Yon Baptaisna wevsa, himba malova os vewol vevna, Sesoana moashulnind nemet ten vewol vivnam, besalva owai. Henamba malova langangal, ereworalva owai, tatatov ban vethavna. Himba sungeitinne nevna, noi meleumb eva yuhvna suwul, osonnamba owai. ");
INSERT INTO wrs_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Annind annind os provna, hena moamba hellelmba, noi provna Yerusalem kotanind, Yutia provinsnind, Yotanpo pethalnind. ");
INSERT INTO wrs_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Yonmba elsus poswol velohvna Yotanpora, wo himba indkumbiva musera moakus uvna, kava sahoklal, kava doa indkoklava wuleihiv kavnamba. ");
INSERT INTO wrs_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Varisinind eva Satusinind, himba keknam wohengivna sembayang wevsam, wo himba nonglalm ambna Yonm. Kam ambo poswol veo pona, hev umnina Yonm. Yon unna, yimba sahoklal, an yemba unna, homba kaindamba ambalmba? Yimba os ningvma, kava si beswonamba lovahvav, sewonamba Sesoava lesvhoawol vevrava indhanamba, pimba si os beswonam avav. Owai, yimba ambo dasalm vinv, kava tanam kavmba weihaloh vewol viv. ");
INSERT INTO wrs_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Boasna yeoa besalwevsam engivra, wo indhanamba si os uvra, doa tanam himba wuleihina hevna indkoklamba. Wo yeoa kamoa os umnivm, kam pona poswol veo. ");
INSERT INTO wrs_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Wo manam yimba pevmba osva uvra, pimba Aprahamna umbeindpol, wo noinda pimba lehra Sesoana novrava. Owai, Sesoava osva nengtava, Aprahamna umbeindpol hona indhanangas himba lehrava aevulv, Sesoava honmba tongvarava pethariniva, nona Aprahamna umbeindpolalm vewol ve. ");
INSERT INTO wrs_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Ai, hillutuk, mongo indhanarini mand wulluhv, wo himba denwit sahoklalm hilolm vev. No denwitva movolva beswonamba kethalohvmoa, wo himba si suwera hiloihapiha vevra. ");
INSERT INTO wrs_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Yon Baptaisva mendah ishunvna indkumbim indhanam, kava indhanamba pona poswol velohv, wo doa himba wuleihiv hevna indkoklamba. Wo heva os mongova indhanariniva si sis kamba engpravav, himba kamba kuvhoav, hena andrava tanamolnonoam phov. Kava ambo andranindrini, wo noinda kava ambo eskand venav hena andrava, maim oi, monglam kekaiv venav. Wo he si ovav, wo Sesoasongolva yeindava si sihangu vinvra, wuhhowolalm. Wo himba si yemba mera vevav, osm yimba si wuleihivav pevna sahoklamba, nomba temba yimba Sesoamba indkokla vrivpa. ");
INSERT INTO wrs_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Himba spetna witmovpa lesvhoawol vevra, movolva besalva huhul vevra vuhebesalla, monglava ombamba nalohvavmoa, wo kelva himba suwera tolsang vevra, noi suwemba vuthoahui tawov. ");
INSERT INTO wrs_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Yesusva hevna Galili provinsrini venamba, Yon Baptaisindam dom gana Yotanporam, osm Yon kam di pona posvera. ");
INSERT INTO wrs_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Yon ovomnana hemba, owai, manara yimba kamba osva omni? Owai, heva ye kam posvo. ");
INSERT INTO wrs_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Yesus omnana, pioa besalwevsam engalvohra Sesoana novraoa, yeoa kamoa posvo. Wo doa Yonmba hengava ovomnanamoa Yesusmba, himba wohposvena pona. ");
INSERT INTO wrs_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Yesusva porini kleihovhoa vungo venamba, doa henanam melm nonglavongo ve ovmera, wo Yesusva nonglovongo ve, Sesoasongol holopevna nomini heindam avhoalm, maim ona, leumb holopev. ");
INSERT INTO wrs_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Yesusva moalamangm hellevongo ve Sesoanamini, memba kana ombolnonoa, kava indk vethamnav, beswonam nonglav hemba. ");
INSERT INTO wrs_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Henga Sesoasongol deisvungana Yesusmba sahal petharam, osm Setanmba di Yesusmba newond ovravra, yeoa kana nengavnangm engo. ");
INSERT INTO wrs_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","3","Nonamba Yesusva innemba owaimomolva nenamoa, simba 40pelara penngiliha vungamnana innehuiva, wo hemba ponmba os venavna i. Setan pronamba, newondmona wohishomnavna, seilmba omnana, yimba tanamba Sesoana ombolva lohtava, honam honm petharinim ishunu, ata innelm rotimsna wohnilhawol venavav yemba. ");
INSERT INTO wrs_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Yesus omnana Setanm, owai, moamba os novol velohv, hona innenapopolva indhanamba avavmoa, heva os Sesoana moamba yunalmba temuramba wohengitava, himba beswonam wohavav. ");
INSERT INTO wrs_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","6","Setanmba henga wainga Yesusmba Yerusalem kotaram, doa sembayangduvra wivsram waivonganamba, omnana, hui lohvhoao. Yimba tanamba Sesoana ombolva lohtava, ambo nis vilivhoapiha veo, ata beswonam. Moamba os novol velohv, Sesoava ata ishunvav hevna ovsongolnindm, yem kekalvho vremnalm beswonam, osm yena monglava ata hondava motvavmoa. ");
INSERT INTO wrs_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Yesus omnana, lehra, heva os mongmomba os novol velohv, Manam yimba Yawemba lehsambaihavav, temba yena Sesoa mendekli einv. ");
INSERT INTO wrs_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","9","Hengava Setanmba Yesusmba waivongana olosram senam, nov wolaihamnana indakonda petham, nom huhmohnahonam. Setan omnana Yesusm, kam mulumbdandna lohvhoamno, wo kam okolo os, mendekli, wo si kava hona huhmohva yena englisra hohlovav, wo eva ye si pethava honamba vaohothovav. ");
INSERT INTO wrs_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Yesus omnana, wohgao, yimba dasalm ov, moamba os novol velohv, indhanarinioa mulumbdandnaoa Yawemangas lohvhoamnavra, yeoa hemangas sembayang venavm. ");
INSERT INTO wrs_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Doa nonamba Setanmba wohgavnamba Yesusnaminiva, Sesoana ovsongolnind ambna, Yesusm kolvralm. ");
INSERT INTO wrs_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","13","Sismba Yesusva hellevna moamba, ona, doa Yon Baptaismba buimera wolaihasuvvna. Yesusva os gana hevna provinsram Galili provinsramba. Heva os himba Nasaret kembellava avnamoa, himba Kapaniam kembella avna. No kembelva Galiliplomb pethalla lohvna, Sepulun nindna eva Naptali nindna pethara. ");
INSERT INTO wrs_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Moashulnindrini Aisaia doara novol vena hona moamba no indhanamba, os novol velohv, ");
INSERT INTO wrs_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","16","Sepulun nind eva Naptali nind, noi Yutanind, himba sikulmonam eivvna. Himba mongnahalm Yotanpo pethalla eivvna plombmonara. Temba Galili provins, dita ten mindnam Yutanindna meisnind avnam. Wo daipotava doa Sesoa hemba indkumbim wohlovhueinv. Himba os avna, ovna, mindil vendkovo kovongav, Sesoamba kevrivnamoa, wo heva os daipotava himba mendekli upsilmba nungliv henga. Yesusva no doaraminimomba wohengvna, wo os himba ishunvna Sesoana nemelmomba. ");
INSERT INTO wrs_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Yesusva di avna Galilira, seilnonoava hevna nemelmomba di moakus unvna, wuleihivm indkoklamoa, Sesoam engivm, himba nambavna hevtindilm, unna, yimba si kana keusingi lovahvav. ");
INSERT INTO wrs_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Yesusva gavna Galiliplomb pethallam, nongalna etel boaslalm, pohlalawonda waivelthavna tambkom, memba hena andra luhunvna. Nihilva vei, Simon Pita mongova, eva mongova Endru. ");
INSERT INTO wrs_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","20","Doa Yesus unna hem, yeoa kam waiengpro, yemba ka si nomtvav, indhanam kekaiv velm. Doa pohlalawondava waivelahana, Yesusm waiengpethamnavna, henam andram lihalm. ");
INSERT INTO wrs_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Hev wonganamba, henga Yesusva nongalna etel boaslalm mongom mongawa aranam, nihilva vei Yems eva Yon, aralna nihilva Sepeti. Himba botmera aralm waiahavna, pohlalawondam wonsishona wonvrevna. Yesus unna hemba, botmoa velaha epho, yeoa kam epawohamno. ");
INSERT INTO wrs_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Wo osoa ambo os Yesusmba epawohamnana, di vena, botm eva aralm dembhalaha ephona. ");
INSERT INTO wrs_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Doa Yesusva sihanamba Galili provinsrava, himba sembayangduvra sihalohmana vevna, moakus unvna nemelmom, os Sesoatindi nemel ao. Doa himba uvavulmungilmba sishona vewol vevna, eva uvavulkoklanamba himba wohvena, os sishona vewol vevna. Doa Yesusmomba os luhungu vevna hindra hindra hindra, os hillivna puehalnind Siria pethanind. ");
INSERT INTO wrs_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Wo indhanamba wulprovna uvavulnindmba Yesusindamba, nom ten indkokla vilovnam, snam novtitmungilm, monglakoklanam, lombamungilm, nihvuvramungilm, eva nom tihsongomungilm, nom eva ten os lovahmana vevnamoa, ambo osangas aevulv kihhui. Doa Yesus henga beswonam sishona vewol vevna. ");
INSERT INTO wrs_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Wo noinda indkumbiva engvalvohmana vevna Galili provinsnind, Dekapolisnind, Yerusalem kotanind, Yutia provinsnind, eva indhana noi Yotanpo pethalnind, maim heva ten angavnam ehalla. ");
INSERT INTO wrs_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Yesusva ona nongalna, owai, men kamba pelkleihamnav, doa oloram vonganamba, di avhoa, hevna aonghal mahalnindva wailgotho vrinamba, ");
INSERT INTO wrs_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","himba hovra numhowol vevna. ");
INSERT INTO wrs_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","Yesusva os ishunvna, himba nomba osva ningvrava, kava sahoklal Sesoana novrava, yeoa henooa indk vithivm, beswonamangas kakowa, manara Sesoava si yemba kekaiv vevav hevtindilm. ");
INSERT INTO wrs_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Hindva nomba wenumbsnamba avrava, henooa indk vithivm, manara Sesoa hemba si washowol vevav. ");
INSERT INTO wrs_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Himba nomba hevmba iovolmba owai vivrava osva, kangas lovahv, henooa indk vithivm, manara Sesoava si hemba milowol vevav hevna nemeltindilm. ");
INSERT INTO wrs_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Hindva nomba undva ningvpa, kamba inneponamsna po pihamsna vinv, manam manam elsusmba beswonamba vewuvmona velmba, heoa und lothoprara. Sesoava si hemba mindkombawonam wohlehra vethavav. ");
INSERT INTO wrs_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Henomba hevna owalmba lelh avramana vevrava, unvra, kava yemba wavra vrowol vev, henooa indk vithivra, manara Sesoa hemba si wavra vovhueinvav. ");
INSERT INTO wrs_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Himba nomba mongawa indnangasva, osva kava Sesoamangas engv, henooa indk vithivra, himba si Sesoamongo aevulvav, eva nunglira. ");
INSERT INTO wrs_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Indhana himba nomba perkaramomba suwemsnamba vuthoawol vivpa, heoa indk vithira, manara Sesoava si os unvav hemba, kana ombolnonoa. ");
INSERT INTO wrs_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Indhanamba himba nomba Sesoana besalwevsamba engivpa, wo indhanamba monglava ositv, hemba kin ohuhlinv, heoa indk vithivra, manara Sesoava hemba si hevtindilm sandhavav. ");
INSERT INTO wrs_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","Yimba hona indhanamba, memba kamba engivpa, nonamba owapevpa monglava ositvpa, kinmba pelhola ovinvpa, moakoko owol vivpa osva, yimba indhanakokla, ");
INSERT INTO wrs_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","yeoa mindnam indk vithivm, manara Sesoava doa yemba kokolma vinna hevna vuherava, yemba esesmba si os lotvav eva mani eskandma no kindava. Os doarava Sesoana moashulnindmba indhanamba kinmba pelhola vinvna, wo eva yemba si os kinmba pelhola vinvavta. ");
INSERT INTO wrs_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Yimba nomba indhanamba, memba kamba engivpa, yimba maim oi, wan einv pethanindmba. Heva os yeoa novnovhora avm, ata homeis wan yena tepepe vinvm, wo hengava bes vevavmoa owai, indhanamba wohningesapingivav tombaikasram. ");
INSERT INTO wrs_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","Yimba katindiva maim oi, wokla lovhueinv pethanindm, Sesoana monamba men os. Mana vemamba pivva senamba woklamsnamba lavraholothuvpa, indhanamba nungliv, lovhoav. ");
INSERT INTO wrs_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Yimba lampuva lavravpa, yimba velawomera indthoavma? Owai, yimba sena indthoai, osm indkumbiva nokambara novvivra. ");
INSERT INTO wrs_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Yimba os maim oi, lampu, yimba beswonam owapevmongova kuksa vev, wo os himba yena wevsabesalm nunglinvrava, Sesoamba okulivra, memba pevpa osva umnivpa ara. ");
INSERT INTO wrs_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","18","Yesusva mendah ishunvna no indhanamba, yimba manam osva ningvav, Yesusva prona, kam ishunilm, wuleihalm Mosesna doaraminimomba, eva Sesoana moashulnindna moam, nomba temba indhanamba no moamba engivpa, owai. Owai, kava prona, wohengalm no doaraminimom. No moamba eva mendeklinonoata, wo eva an si poswol vevav, wo ovav, sahoklal, owai. Owaimomolva mongova moapetava si shalohol vevavmoa, verava, ovi pethai imhara evhowolvram. Tanamolnam no moamba si wohlohvav yunalm, osm indhanamba si os temurava engwol vivra indakondava. ");
INSERT INTO wrs_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Mongo indhanarini nonora lohvra mongasalm moam Sesoana bukurinim, wo ovra, sahoklal, wo owalm ishunvra, sahoklal, yeoa wuleihu, wo no indhanariniva himba si sesvmomoa kleihavav Sesoaindava ambo. Eva snamba moamba eusilva, himba manam owalmba osva unvav, wuleihu. Sesoava hemba si mullam vrepra vrevav. Wo heva os mongova yeriniva wohengvrava Sesoana moamba, eva numhowol vevrava owalmba, wo no indhanariniva si kuwulmsna wulluhunvav Sesoaindava. ");
INSERT INTO wrs_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Katekis eva Varisi, himba os uv, kava lehra engiv Sesoana moamba, heva os hena wevsava ambo seposam. Yimba katindiva, yeoa besalwevsam wohengivm pevna indnahonam, seposamba owai, wo noindangas yimba si Sesoatindi nemel avav. ");
INSERT INTO wrs_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","Yimba nonora, Mosesva pina simbelva Sesoana moamba doara os ishunna, manam yimba helvakomo vivav indhanamba. Himba nomba indhanarinimba helvakomandhatava, hemba nomba owalva wetat uvra. ");
INSERT INTO wrs_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Doa heva os men kav yemba ishunv, kavna aonghal mahalnindm, yimba pevna owapevrinimba wuspromnatava, yena wetatmomba si lohvav. Eva himba nomba owalmba moakoklanamba okos vetava, mundilva hemba wetat uvav, umnira, yena indkoklava lohv. Osva omnatava hevna mongawa tindirinimba, yimba ambo tovolkola lohv, wo heoa pepeh vera, himba si suwekembellam gavav. ");
INSERT INTO wrs_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","24","Yimba pevna owapevrinimba indkokla vretava, nungi lilnam henga epawoho nihra. Wo nonamba yimba novoa venavrava manimani pevnamba Sesoamba altasengrava, wo yimba nengvra henga nomba, osva kava indkokla vrena doa kavna owarinimba, wo dawonam yeoa Sesoamoa sembayangmoa wuleihamnarava, wo garava, henga hemoa nihra pethao, wo os manimani Sesoamoa altasengraoa hohlomno, sembayang venalmba nonamba. ");
INSERT INTO wrs_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","26","Yemba indhanariniva mongova wetatramba waingatava, henga nungi lelnam nihra petharava, sehmoa ovro. Honisna veno, os yimba gavav wetatmoramba. Yimba owai venatava pevna sehpevmba, si himba homeis imharavhoamnavm yemba wetatmora. Men yemba kava ishomnav, osva yimba si owainonoa wuleihalahaphovavmoa nomba buiva, verava, yimba boasna wohsovawol vepiara nom, ora, osm kamba umnina. ");
INSERT INTO wrs_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","28","Yimba nonora, Mosesva pina simbelva Sesoana moamba doara os ishunna, manam yimba ongariskuiva owapevnamba vivav. Wo heva os men kav yemba ishunv, mongova yeriniva novnangasva ungevlirinimba nonglavrava, muemb nevrava hemba, osva kevralmba, wo doa himba indkokla vei, himba doa nengavnangra kevrei. ");
INSERT INTO wrs_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Yena nihanovpa yemba indkoklamba velmba indthoamnatava, no novoa vilipingo. Lehra yimba mongawa novnamba lohvav, si homeis Sesoa yem sambla novnahonamba pilpiapahavm suwekembella. ");
INSERT INTO wrs_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Yimba pevna nihananglanamba indkoklamba velmba vetava, yeoa wohkovopingo. Homeis mongawa englana loho, si homeis Sesoa yem pilpiapahavm suwekembella sambla englanahonamba. ");
INSERT INTO wrs_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","Yimba nonora, Mosesva pina simbelva Sesoana moamba doara os ishunna, tendoriniva hevna ongalmba engvavrava, ehallamba wolaihangalmba, heoa boasna moapetaoa tombaira novol venavrava, os vraohvra, wo os wohengvavra nonahonam. ");
INSERT INTO wrs_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Wo heva os men kav yemba ishunv, mongal indkoklalva mendekliva lohv, tendoriniva hevna ongalmba pelvpiangalmba, osva ungevlirinimba mongova tendoriniva doarava kevratava. Tendoriniva hevna ongalmba ombamorava nisva pelvpiangatava, wo noindava tendoriniva sahonam vev. Himba osva ungevlirinim indkokla vrev, temba mongova tendoriniva hengava hemba pethatava. Sesoava hemba os nengmanavra, memba yimba tendoriniiva ahavpa, memba mani yena tlalma? Wo sisminimba tendorinimba, Sesoava os nengmanavra, yimba doa mongona tendorinina ongalmba pelvrav. ");
INSERT INTO wrs_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","Yimba nonora, Mosesva pina simbelva Sesoana moamba doara os ishunna, yimba mana vemamba mendeklimba tanamolnamba wohishomnatava, yeoa wohvengas veo, manam yimba owai vevav. Wo eva mana vemava yimba ona sevratava, yeoa os wohveo, ten pev onam. ");
INSERT INTO wrs_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Wo heva os kav yemba ishunv, moana wevsam sisla ovralm, owai, osoa wuleihu. Manam yimba osva sevrivra, senakembelmba, nomba osva ovra, kava lehra ishov, owai, manara noinda Sesoana kembel, himba di av. ");
INSERT INTO wrs_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Manam yimba osva sevrivra, hona petha, pevna moamba sisla ovralmba, manara, maim oi, Sesoana ovhoavhokoholvuhe, mongla ialm. Manam yimba osva sevrivra, Yerusalem kota, moamba pevnamba sisla ovralmba, manara memba Sesoana kotava, pina mendekli kuwulna. ");
INSERT INTO wrs_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Manam yimba osva sevrivra, kana ku, pevna moamba sisla ovralmba, manara, yimba pevhopolmoava es eva vevav, pevna tamba weihaloh vrevav, osva suwihal, eva dombal, eva tamba mongasalva owainonoa. ");
INSERT INTO wrs_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Wo yimba osmba olmba vivrava, osva, memba tanam, osangas umnivm, memba tanam, hengava mongova owai. Wo eva yimba osmba olmba vivrava, owai, osangas umnivm, owai. Manam yimba moamba hoanavho vrivav tokwonamba, sisla ovralmba, ata indhanamba lelnam ningvav, tanam. Temba Setanna wevsa prov. ");
INSERT INTO wrs_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","Yimba nonora, Mosesva pina simbelva Sesoana moamba doara os ishunna, esesmba manapenam, yena novpa mongova indhanariniva vilipingatava, eva yeoa henaoa esesm vilipingamno. Mongova indhanariniva yena lomba tembilpingamnatava, eva yeoa henaoa esesm tembilpingamnota. ");
INSERT INTO wrs_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","40","Wo heva os daipota kav men ishunv yemba, mongova yemba indhanariniva helvalmba vetava, manam yimba wuspromnavav hemba. Mongova indhanariniva yemba sang polatava, henga mongnasis haravhoamno. Mongova indhanariniva yemba wetat otava duangindava, pevna kayen moanvrarava, moan vraho bayupanasnahonam. ");
INSERT INTO wrs_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Yemba mongova ungundriniva omnatava osva, kana kin ingao ambo nis, manam yimba aongpa vevav, wo manam yimba owaimomo omnavav, yeoa kolvro hemoa, wo hena kinmoa ehallamoa ingao. ");
INSERT INTO wrs_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Mongova indhanariniva yemba osahmanatava, mana vemamba yenamba vralmba dawonamba, ata kava henga wulprovav, kolvro, manam yimba meisva haravhoamnavav. ");
INSERT INTO wrs_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","44","Yimba nonora, Mosesva pina simbelva Sesoana moamba doara os ishunna, pevna sehpuinamoa pevna indnahonam indvewol vivm, wo heva os no ungundmoa, temba yemba musk vinvpa, nomoa musk vinvm. Wo heva os daipotava kav men yemba ishunv, ungundm pevna indnahonam indvewol viu elsusoa. No indhanam yem ten ositvm moakoklana, Sesoam osihminivm hem beswonam vewolalmba, ");
INSERT INTO wrs_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","wo osva Sesoa senamini si nongalvav yemba beswonam, wo ovav, yimba kana ombolnonoa, yimba os men kav. Sesoana wevsava os men, himba okombam vrev, pholm eva lovhueinilm indkumbim. Vei besal indhanam eva indhanakoklam, kolvrowolalm hem. Wo eva himba pom wolaihaprinv osoram indhanakokla nindnahonam, besal indhanamangasva owai. ");
INSERT INTO wrs_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Indhanamba nomba yemba hevna indnahonamba indvewol vivrava, eva yimba esesm hemba indvewol vivrata pevna indnahonam, temba besal. Heva os puehalnindva eva hona wevsamba wohengiv, himba indhanamba indvewol viv, nomba temba hemba himba indvewol vivpa. Wo yena wevsaoa kuvhoawol vinda henamoa, yeoa pevna ungundmoa ind vewol vivm pevna indnahonam. Sesoava si yemba esesm noindava vinvav. ");
INSERT INTO wrs_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Wo eva yimba sehmoa owol vivrava pevna sehpuinamba, temba eva mani mendeklima. Manara, eva puehalnindva vivta osva, himba sehmonamba owalmba ishunv hevna sehelmba. ");
INSERT INTO wrs_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Yimba kana aonghal mahalnind, yimba Sesoana mongawatindi, yeoa honamangas ningvm, besal wevsam engilm, os Sesoa ara hev ten avm sena, mana vemakethahui hem. ");
INSERT INTO wrs_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Yesusva mendah ishunvna hevna aonghal mahalnindm, yimba kana mongawatindi, yimba Sesoana wevsamba engvrivrava, manam yimba pevmba enetesna avramana vevra undmoserava, manam yimba owapevmba osva unvav, kam nunglu, kava besalangas lehra. Yimba osva vitava, Sesoava arapevpa senaminiva si yemba esesmba vinvavmoa. ");
INSERT INTO wrs_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Indhanamba yimba kolvrowol vivrava, manam yimba muserava vivra, noinda indhanamba monglava yemba nungeilvrava, wivewol vivra yemba, himba besal indhanangas. Temba sahoklal wevsava sambla mona indhananamba, kam unvra, lehra viv. Sembayangmera eva monahulumbra osva temba vivpa, mongom vuvna mi pieivna, owalva hemba os pelkleihaomana venav. Ambo osm viv, indhana mongla kam nungeilvrava, wivewol vivra kam, himba hevm besalangas lovahv. Temba hemba wivewol ovivpa, himba indk vithiv hona wivewolmorava, wo heva os Sesoava hemba si esesmba vinvavmoa. ");
INSERT INTO wrs_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","4","Nonamba yimba indhanamba kolvrowol vivrava nomba innehuinindmba, poaita vinvm, ata homeis mongo yem nongalvm. Heva os arapev senamini hengas nongalv mana vemamba, eva mana vemamba yimba poaitava vivav, wo noinda himba si yemba esesmba vinvav. ");
INSERT INTO wrs_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","6","Yimba Sesoamba isholmba vinivrava, poaita, manam yimba muserava vivav, ata homeis indhana yem nungeilvm. Temba sahoklal wevsa samblamona indhananamba, himba sembayangmera eva monahulumbra domangas lovahthalm vev indkumbina novram, wo Sesoam ishumniv. Himba hevpa indk vithiv, kamba indkumbiva lehra nungeilv. Temba hemba beswonamba nungeilvpa, himba indk vithiv hona wivewolmorava, wo heva os Sesoava hemba si esesmba vinvavmoa sewonamba. Nonamba yimba arapevmba ishomnavpa, pevna kamarrava veo. Yena arapevpa senaminiva wohnonglav mana vemamba, eva poaitava mana vemamba besalva yimba vevav, wo si himba yemba esesmba vinvav. ");
INSERT INTO wrs_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Wo yimba Sesoamba isholmba venavpa, manam yimba tokwonamba ishomnavav, temba nomba moamba plalhui, ambo temba os uvra, lalalala. Temba puehalnindna wevsa osva luhunv, himba Sesoamba tit viniv. Himba os ningv, kava tokwonamba moamba ishumnivpa, dihi Sesoava kamba helwolv. ");
INSERT INTO wrs_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Owai, Sesoava yena arapevpa himba doa nonora luhunvna yena almba, eva nom ora notongohui yimba, wo noinda osva manam yimba tokwonamomba ishumnivav hemba. ");
INSERT INTO wrs_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Yimba Sesoamba ishumnilmba vivpa, honam kana moam engivm, ");
INSERT INTO wrs_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Yimba mendekli, kava os ningv indkumbioa yena nemeltindilm saivra. Yena ovsongolnindva yena undmba wohengivna sena, eva kaoa yena undmoa os engilvohrata huioa petharaoa. ");
INSERT INTO wrs_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Yeoa kamoa inneoa dembrehunu detimangas. ");
INSERT INTO wrs_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Kava indkoklava maivithinv indhananamba, temba kamba vinvpa, wo yeoa eva kanaoa os maivethinuta, men ka vivm. ");
INSERT INTO wrs_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Kam kokmondha vewol veo mana vemakoklarinioa, ata homeis kam piasahavm monakoklaram. Kam kokmondha vewol veo Setanna penam. ");
INSERT INTO wrs_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Yimba maivithinvrava indkoklava indhananamba, nomba temba yemba indkoklava vewol vivpa, nonamba Sesoa ara senamini eva si yenamba maivethinvavta. ");
INSERT INTO wrs_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Wo heva os yimba yunalmba nengeuvmona vevrava no indkoklamba, temba indhanamba monglava yemba vinvpa, Sesoava si yenamba osva maivethinvavmoa. ");
INSERT INTO wrs_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","Yimba innemba hlalmba wuleihivrava, wo os Sesoamba sembayang vimnivra, os pevna indnahonam wohviu. Samblamona indhanamba himba seposam viv, himba pethasavna av, osm indhanamba monglava nungeilvra hemba, himba innemba lovahav. Tanam monglava indhanamba wivewol viv hemba, heva os Sesoava si hemba esesmba vinvavmoa, owai. ");
INSERT INTO wrs_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Nonamba yimba innemba lovahavrava, novlomosm poswol vivm, eva ta leiswol vivm, os ten doara pev velvohvnam. ");
INSERT INTO wrs_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","Indhanamba si osva liheivavmoa, heva os Sesoava si lihawol vevav. Pimba nunglivmoa hemba, heva os himba yemba nongalv, yimba mana vemamba vivpa, wo himba si esesmba vinvav yemba. ");
INSERT INTO wrs_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","20","Yesusva ishunvna hevna aonghal mahalnindm, mana vema besalva Sesoava doa pimba kokolma vinna senakembella, yeoa nomoa muemb hlawol vevm, manam yimba duus vewol vivav mana vemamba besalmba hona pethariniva. Manara, noinda omav, wolwa noi kukuldav mana vemamba besalva huiva. Wo eva yukovnind si tuvpa velavra, yukovnam vralm. Wo heva os mana vemava besalva nalohv Sesoana kembella senamba, yunalm wohnalohvav, mueisowa vilohui diva, os omavhui wolwahui yukovnindhui lohv. ");
INSERT INTO wrs_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Wohva yenamba diva nalohvrava, undva yenamba diangas endvra. ");
INSERT INTO wrs_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","Yeoa mana vemanonoamangas ningvm, wo osva yimba si lovahvav, os ora indhanarini novbesalna, himba upsilmba nonglav, senakembelmangas andra vev. ");
INSERT INTO wrs_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Yimba hona petharinimangasva ningtava, yimba si os lovahvra, ovra, indhanarini novkoklana. Himba eva es nongalvav, sahonam andra vev, himba sikulmonam wohlohv. ");
INSERT INTO wrs_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","Sesoana nengavnangmangas engivm, manam yimba dimangasmba mindnamba ningvra. Andranindrini es hevpa wohenginvra kuwulsamblamba, owai, himba mongomangas und vevra, mongomba owai. Himba mongnangas andra vevra, mongomba meis haravhoamnavra. Manam yimba osva dimba vravra, ovra, kana kuwul. ");
INSERT INTO wrs_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","Manam yimba pevmangasva ningvav osva, mani ata pimba hlavav?, mani malotovpa ata kava vewol vivav? Yimba kuvhoawol vev innena pikiannamba. Yimba tit vivma, yena nihva innemba nelmangasva lohvmoa, wo eva yena nihva pikianmba vewolalmangasva lohvmoa? ");
INSERT INTO wrs_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Nungeiltuk, tuawava himba osomba vivmoa, wo eva himba ehlanamba andra vivmoa, innemba dombolmba. Wo heva os Sesoa hemba innemba daswolv. Ye miva lovahv Sesoana novrava, tuawava owai, wo noinda himba yemba kolvrowol vev. ");
INSERT INTO wrs_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Mindnamba nengavnangna wevsa mana vemam, es hevpa yemba kolvravavma?, owai. Yimba mindnamba duus vetava, yunalmba almba, es hevpa yimba wohavavma hona petharava yunalmba?, owai. ");
INSERT INTO wrs_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","29","Manam yimba ningvav pikianmba osva, mani si pimba vewol vivav? Bungam nungeiltuk, kulva besal temba posmusrava phowol vevpa. Himba andrava vivmoa, himba englanamba kayenmba kondvravmoa. Heva os Sesoa hemba huhmoh vewol vev besal kulnamba, wo os himba wohkuvheiv Solomon kuwulmba, ten nemet lohnam wohtowond. ");
INSERT INTO wrs_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","No bungarava Sesoava besal kulna huhmoh vewol vei hemba. Wo heva os ambo mongawakombanam lohoiva, kongla vepie, wo suwem taihavra. Tanam Sesoava yemba si daswolvav huhmohva, noinda yeoa hemoa pevna undnahonam lovahthamno, heva seposam lovahmanalm owaiva. ");
INSERT INTO wrs_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Wo manam yimba duus vivav osva, kava mani si hlavav? Mani pikianalmba si kava vewol vivav? ");
INSERT INTO wrs_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Sna wevsava temba puehalnindna, Sesoamba himba tit viniv. Yena arapevpa doara doa lihawol vinna osva, himba honam ningv mindnamba. ");
INSERT INTO wrs_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Heva os yeoa mindnam nengavnang vivm, Sesoana nemeltindilm saivolm, wo hena wevsabesalm engilm. Wo eva himba si os kolvrowol vevav yemba, nomba temba yimba ningvpa. ");
INSERT INTO wrs_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Manam mindnamba yimba osva duus vivra, simerava mani kin plothunvav kamba? Owai, detimangas yeoa ningvm osva, es hevpa ata kava vivav hona kindava, detiva memba phovpa. Doata simeraminimoa kinmoa manam yimba duus vivav detiva. ");
INSERT INTO wrs_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","Yesusva mendah numhowol vevna hevna aonghal mahalnindm, manam yimba ositvav indhanamba osva, yenamba indkoklava lohginv. ");
INSERT INTO wrs_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Wuleihu, Sesoangas yemoa osetra hengaoa, wo no wevsava yimba temba engivpa, nonamba yimba indhanamba ositvpa, Sesoava eva si os yemba vinvavta. ");
INSERT INTO wrs_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Manam yimba osva unvav pevna sehpevmba, yimba singpong ilvahv pevna novmerava, nonamba yena sehpevpa sahonamba vivrava. Wo eva yimba pevmba os lihavavmoa, kava sahoklalva lohvmoa, snamba maim oi, tipopov yena novmerava. ");
INSERT INTO wrs_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Manam yimba pevna sehpevmba osva unvav, ata ka kilvivav singpongva yena novmeriniva, wo yimba nengvmoa, tipopovpa pevna novriniva. ");
INSERT INTO wrs_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Owai, seiloa boasna pevna novrini kilvu tipopovoa, wo beswonamba yimba os novvivra, wo os kilvinu pevna sehpevna novrinioa. ");
INSERT INTO wrs_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","Sesoana moamba besalva, snal maim oi, bungana huhmoh kul. Manam yimba ishunvav nomba indhanamba, miemsnamba temba vuvt andasuh avramana vevpa. No indhanamba si ningvavmoa Sesoana moamba, temba snal maim oi, mewonda ningvavmoa huhmohmba. Yimba pevna huhmoh besalva dembhatava mewondana novlomossisva, miemba monglana dakonda vevav no huhmohva, eva windemba imharavhoarava, yemba helvevav. ");
INSERT INTO wrs_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","Yimba Sesoamba ishomnavpa, manam yimba kivrawuliha vrevav, osva Sesoava yemba si vuhebesalla sandhavav. Yimba aslalvrava, nonglalmba, Sesoava yemba si indthueinvav mana vemava besalva. Yimundtomdaoa elsus lovahthamnavrava, tuvmoa os vindewuvmonavm, wo Sesoava ata ovav, sihaota. ");
INSERT INTO wrs_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Himba nomba Sesoamba osihminivrava, tanam Sesoava henomba si sandhavav vuhebesalla. Indhanamba nomba aslalvrava, nonglalmba, tanam Sesoava si indthueinvav mana vemam besalva. Nomba indhanamba elsusva yimundtomdava tuvpa temba vindewuvpa deuvriniva, Sesoava si os unvav, saivo. ");
INSERT INTO wrs_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Sesoa yena arapev senamini, himba yemba dembrahunilm vinv, nomba yimba temba osihminivrava hemba. Yena ombpovpa yemba osva omnatava, kam newul, wo es hevpa yimba hon tongrahovavma, owai. ");
INSERT INTO wrs_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Osva himba yemba omnatava, kam tambko, wo es hevpa yimba saipusuhla wuraohvavma, owai. ");
INSERT INTO wrs_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Yimba indhanamba sahoklal, heva os yimba pevna otolmba mana vema besal moang vinv. Wo yena arapevpa senaminiva himba nihvuhinhui, wo himba si tanam daswolvav besalva mana vemava, nonamba yimba hemba osihminivrava. ");
INSERT INTO wrs_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Mana vemava besalva yimba osva ningvrava, indhanaoa os kamoa vinda lehahra, wo eva yeoa wohvinuta hemoa os. Honi mongal plalva Mosesna moana eva owal moashulnindna moana. ");
INSERT INTO wrs_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","Nomba monamba temba Sesoana kembellamba dihelgavpa kekelmel, wo heva os yeoa ehlana aslalo, engalmoa no monamoa. Mongova monamba dihelgav, hevm besal, wo vaval saivolmba, indhanamba mindnam osva angalvohv. Indkumbiva no vavalmonam engiv, wo heva os hemba si indkokla vilovav. ");
INSERT INTO wrs_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Yeoa kekelmelmonam engivm, tanam kekelmel tiplakoplamona, wo heva os yimba si pulvovav ehavelkembella, wo yimba si beswonam wohaevulvav. Indhanamba ambo eskand si saivnga vevav, nonglalmba nomba monamba. ");
INSERT INTO wrs_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","Yimba kana aonghal mahalnind undundna aevvm. Indhanakoklava men aevulv, yemba si os unvav, yemba moamba besalva men kava wulembinv Sesoanamba. Himba yemba dasalmba si os unvra, wo yimba si hilwilvra hemba, gurubesal, wo heva os tanam himba sahoklal, snal maim ui, allambawonda. ");
INSERT INTO wrs_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","17","Indhanam nom nungeilu, es andra viv? Yeoa lesvhoawol viu hemoa, os maim oi, denwitna aral hevna nukm mendenglit owol vev. Wo yimba os lihawol vivav, himba ambo dasalm guruwolmba lovahv. Es hevpa pueuvpa yimba leihavavma mandariniva? Es hevpa wombamovpa yimba pueitvavma sumbriniva? Nuktva besal, yimba nungluwularava, wo yimba nonglavav, movolva besal. No nuktva doa merava lalao vev, movolmba yimba nonglavav, sahoklal endv. ");
INSERT INTO wrs_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Nuktva tilva besalva lohvpa, movolva sahoklalva endvavmoa, wo nuktva tilva sahoklalva lohvpa, movolva besalva endvavmoa. ");
INSERT INTO wrs_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","20","Nomba denwitva, temba movolmba endpralmba owai velohvpa, doa denwitna aralva ovla wulsiharava, wohhilivutho, suwe tithoa. Hillu hona kana moam, wo indhanana andram lesvhoawol vinu. ");
INSERT INTO wrs_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","Eva indkumbiva si saivvavmoa Sesoatindi nemellamba, owai. Kamba ombamora ambo osva alvav, mendekli, wo heva os owai, eva mani indkumbi si saivvavmoa Sesoatindi nemellamba. No indhanangas ten ara senaminina moam engivm, wo henongas hevho si saivvav Sesoaindava. ");
INSERT INTO wrs_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Eunillamba oviva pethaiva mueisowa vewolvrava, wo kava indhanamba lesvhoawol vevrava, monglava indhanamba si os kamba umnivra, mendekli, kava yena moamba indhanamba ishuvmona vinvna, kava tihsongomba indhanana nihmeriniva engilinvna. Kava mendekli andra vina yenanapopol. ");
INSERT INTO wrs_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Wo kava si os hemba wohishopieinvav, lehra, heva os yemba nomba kava tit vinv. Yemba kava osva nongalnamoa, ona, kana aonghal mahalnindnonoa. Yeoa angavm ehallam kanaminioa, manara noinda yimba indhanakokla vilov. ");
INSERT INTO wrs_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","25","Indkumbiva himba nomba engivpa kana moamba, himba snal, oi indhanarini nengavnang besalna. Himba deuvm velm vev, doa mandamba himba wosapiha vev petha besallava lumbulla. Wo doa sismba vuvina ponamba vevna, wo hena deuvmba os wiki vrowolloh vina, wo pueumb pro, owai, hena deuvpa beswonam wohlohmanavna. ");
INSERT INTO wrs_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","27","Indhanamba nomba hillivrava kana moamba, wo heva os kek vithivmoa, engivmoa, no indhanamba temba snal maim oi, indhanarini nengavnangkoklana. Himba deuvm velm vev, heva os himba popethalla vev, mandana engalla. Wo sismba vuvina ponamba vevna, deuvm nom pulshatha, pueumb pronamba, os tupulusva wulangana. ");
INSERT INTO wrs_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","29","Yesusva ishopianamba, wo no indhanamba di aevulvnamba, evekingil vruwul uvna, Yesusna moamba kin vev. Katekisna moamba ambo kolmalmoa, heva os Yesusva aralna moamba kuvuluhv. ");
INSERT INTO wrs_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","2","Yesusva oloriniva pihavnamba, Kapaniam kotaram gavna, indhanamba indkumbiva sis pelpathamnavna hemba. Doa mongo kismungil indhanarini pro, hev novlomossis mulumbdandna lohvhoamna Yesusm. Hev omnana, kam sishona vro, yimba nengellava osva, mendekli. ");
INSERT INTO wrs_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Wo doa Yesusva hevna engla luonamba, oholothomnana no kismungil indhanarini inda, omnana, kava wohnengvta mindnam, yemba kolvralmba, yena nihtovpa henga ata beswonam hevnavhora lohvav, wo os venamba, hena nihtovpa beswonam henga kanandhana. ");
INSERT INTO wrs_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Yesus omnana hem, manam yimba muserava honamba ishovav, owai, yeoa gao sembayang andranindrini indam, nethalm. Himba ata yena nihtovmba os naengho vrevav. Wo yeoa Sesoamoa inne dembraho honindaoa, os nemet ten doara Moses novol venam. Osm indkumbiva yemba si os umnivra, Sesoava hemba doa sishona vrena, hena kisva doa selvpena, doa hevna nihna lohv. ");
INSERT INTO wrs_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","6","Nonamba Yesusva sihavnamba Kapaniam kotarava, valgonindna kuwulva di avna, 100pelara valgonindnamba himba kuwulva wulluhunvna. Hev Yesusindam pronamba, hev omnana Yesusm, kana andranindriniva men ambo sahonam englamonglahui nendav, yeoa hemoa kolvro, mendekli. ");
INSERT INTO wrs_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","8","Yesus omnana hem, ata kava garava domba, hemba ata kava beswonam sishona vrevav. Wo noi kuwul omnana Yesusm, kava mani besal indhanarinima, ata yimba es hevpa kana deuvrava sihavav, owai. Yeoa hui monara sishona vro, wo ata andranindrinimba kanandhavav deuvrava. ");
INSERT INTO wrs_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Kanamba kuwulva lohv, no kuwulna keusingi kava andra vev. Wo eva ka valgonindna kuwulva wulluhunv, himba kana andranind, osva kava mongomba omnatava, dom gao, hom pro mongomba, himba osangas wohviv. Kava os nengv, Sesoava doa yemba anglavuhuvoho vrena, kana andranindrinimoa os veno. ");
INSERT INTO wrs_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Yesusva evekingil vethavna no valgonindna kuwulna moarava, hev unna no indhanam, ten pelpathalohmanavnam hem, hillu honam valgonindna kuwulna moam, himba kamba keknam hevna indnahonam nengmanav. Himba ambo puehalnindrini lohv, wo heva os yimba kana mongawa Israelnindva, kava mongomba snamba nonglavmoa yeriniva, himba hevna indnahonam kamba ningminivmoa, osva memba hona indhanariniva, owai. ");
INSERT INTO wrs_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Yesusva mendah ishunvna no indhanam, hillu, sewonamba Sesoava si hevna nemeltindimba innemba wonnevav, pina simbehumunil noi Apraham, Isak eva Yakop si aevultharava, noi si hlavav. Wo eva mongla puehalnind si kusorava, si os wonhlavav hemba, no puehalnindva kamba keknam hevna indnahonam ningminiv. ");
INSERT INTO wrs_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Wo heva os pina mongawa Israelnindva, himba nomba temba doarava hillinamba Sesoana nemeltindinamomba, himba nomba si hlavavmoa no innemba, owai. Sesoava si hemba sandhavav amballa sikulmonam, wo himba di si wenumbsnamba uwuvra, manara, himba kamba hevna undnahonamba ningminivnamoa. ");
INSERT INTO wrs_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Yesus henga omnana no valgonindna kuwulm, gao deuvram, yena andranindrinimba ata kanandhavav, manara, yimba kamba keknam pevna indnahonam lohvhoamnav. Wo nonamangas no andranindrinimba os kanandhana. ");
INSERT INTO wrs_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","15","Henga Yesusva ganamba, Pitana deuvra siha, himba ona nonglana Pitana kolalm, men nihvuvramungil liv. Hev englaval kevra, wo no nihvuvravpa henamba os hoai vena, wo himba venamba, innesowava venavna Yesusmba. ");
INSERT INTO wrs_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Simokokonamba kembelnindva wulkusovna uvavulnindm, eva nom ten tihsongo nihmera aevulungu vinvnam, indkokla vewol vinvnam. Wo Yesus unna no tihsongom, phopiengu vinu, wo os wohphopianamba, os bukethana, wo os Yesusva sishona vewol vena no indhanamba. ");
INSERT INTO wrs_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Yesusva wohengvna Aisaia moashulnindrinina doaraminimom, no moamba os novol velohv, No indhanarini pimba sungiavho vrowol vena pina uvavullava, himba pina kinmba pungeinvna. ");
INSERT INTO wrs_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Yesusva nongalna, indhanamba kamba mindnam kulthoamnav, wo hev unna hevna aonghal mahalnindm, honaminioa angai, pom lovol verava, ata nomilm aevulthavav popethalla. ");
INSERT INTO wrs_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Doa himba angalm vevna mongawulm, heva os boasna mongo katekisrini pro Yesusindam, guru, kava yem pethamnalm venav, yimba eva hivemava gavra, kava yem pethamnavra. ");
INSERT INTO wrs_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Doa Yesusva omnana hem, lehra, heva os beswonam boasna nengo. Tuawava lara ovavhoa vewol viv, miemba lara vilov, noindamba sihalmba. Wo heva os kava owai, kava arana ombol lohv deuvhui, osmba di kava lilohvra. ");
INSERT INTO wrs_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Mongo hevna aonghal mahalnindrini omnana Yesusm, kava si yemba sewonam wohengvav, boasna ata kava gavav deuvram arana mindsowaram, prorava, henga yem wohengvra mendeklim. ");
INSERT INTO wrs_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Yesus olhmona omnana hem, owai, singvilmba indhanamindmba yeoa wuleihinu indhanam, nom ten dalvm, katindiriniva owai. Yeoa kamangas wohenguvmona vevm. ");
INSERT INTO wrs_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","24","Yesusva hevna aonghal mahalnindm botra wonsihanamba, os wongavna plombmonam, vuviva mendekli vevna plombsrava, wo plombva mera vethalm vevna botmba. Wo heva os Yesusva indwonam ninpol kovopena botmerava. ");
INSERT INTO wrs_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Hevna aonghal mahalnind anganamba, dehpunduh vri, mendekli, kam kolvrowol veo, pimba ata nepola vilovav. ");
INSERT INTO wrs_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Yesus unna hem, mani yemba helvowol vev osva? Manapenam eva yimba Sesoamba wuleihiv? Yesus phonamba, no vuvikoklam olla, eva plombm os, wuleiho. Wo vuviva os wuleihanamba, plombva henga beswonam livna hevnavhora. ");
INSERT INTO wrs_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Hevna aonghal mahalnindva tit viwul vevna, wo hevm ishuwul vevna, pai, hona indhanariniva, vuvina plombnamba eva hena vuehisingi. ");
INSERT INTO wrs_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Yesustatanamba ambanamba mongnahalm, plombpethalla peivoe pethara, no pethava Gatara indhanana. Hev peivnamba, mongo sambla indhana epra Yesusindam, doara heva doa tihsongova hena nihmerava saivunna. Noinda himba daimungil eprana, nomini hev ten ovavhoa lohmana evevnam pokamapethara. Indhanamba deuvnindva nomba pem vivna, atonglalmba no monamba. ");
INSERT INTO wrs_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","No indhanarinikokla sambla velaipho evemna Yesusm, yimba Sesoana ombol, manam yimba vinv kamba? Yimba memba homba proiva, yimba kamba kinsombwonda kethinvma? Owai, mendah lohv honamba. ");
INSERT INTO wrs_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","31","Miemba mindnam ehalla deuvnindnamba inne hlalvohinvna, no tihsongova Yesusm velaipho vinivna, yimba kamba engalalm vevma, a? Wo manam yimba kamba nisva engalvav, kam wolasiha veo di meina nihmera. ");
INSERT INTO wrs_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Yesus unna tihsongom, yeoa meina nihmera sihangu vinu. Wo no tihsongova indhanarini samblamba wuleihawol vina, meina nihmera sihangu vinvna, wo nungi lelnam miemba dandwonam ona gapiana moainalla pora, os nokovhoawol vena, wohdalna. ");
INSERT INTO wrs_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Wo no deuvnindva nungeilnamba, temba daoh vrevnamba miemba, pipivehanga vena os deuvramba, nom moam ishunilm indkumbim, eva tihsongo mungilsamblana moam. ");
INSERT INTO wrs_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Indkumbiva prapiavna Yesusm nonglalm, wo nonamba himba Yesusmba nunglivnamba, himba os umnivna, kanaminioa wohgeinu. ");
INSERT INTO wrs_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Yesustatanamba henga no botra saivnamba, wonavhoa, os plombmonam wongana, Kapaniam kotaram henga angana. Temba nomba Kapaniam kotava Yesusna kembel. ");
INSERT INTO wrs_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Yesusva di ona vena, indhanam monglam nongalna, ten ambv, himba indhanarinim mongom uvavulmungil towara wulambvna, no indhanariniva eva ata es englamonglava shuawol vevta. Yesusva doara lihawol vena, no indhanamba kamba indnahonam lovahmanav, wo Yesus omnana no indhanarinim, seh, men kava daipota yemba kilumbshuav pevna indkoklarava, yeoa daipotaoa indk vetho. ");
INSERT INTO wrs_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Di doara katekisva monglava lovahvna, hev hillinamba, hev ningvna, Yesusva Sesoamba opilpihav osva, Sesoangas indhanana sahoklalmba selvhinv, mongova snamba indhanariniva owai. ");
INSERT INTO wrs_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Wo Yesusva hev ambo lihawol vinna no katekisna nengavnangmba, wo hev unna, yena nengavnangva sahonam lovahinv, kava beswonam vev. Sesoa doara kamba pusvundthoana, moa mendekli vraohna, os kava selvhinvra indhanana sahoklalmba hona pethanindnamba. ");
INSERT INTO wrs_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","6","Ata henga kava hona indhanarinimba os omnavav, pholahangao, wo yimba ata liheivav, osva kava tanam ishoi, seh, men kava daipota yena indkoklamba selvlahav. Wo doa Yesus no indhanarinim omnana towatrinim, pho, pevna tikar lengvarava, pevna deuvram gao. ");
INSERT INTO wrs_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","8","Wo nungi lelnam no indhanariniva pho, kinsombwonamba owai, himba undmosera gavna, wo indkumbiva mindnam evekingil vithivna. Himba os uvna, Sesoam okulu, himba tanam mongom indhanarinim snamba moamba doa vraohna, mendekliandramba velmba. ");
INSERT INTO wrs_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Yesusva nominiva venamba, gavna, wo nonglana, indhanariniva men kantorra andra vev, no indhanariniva indhanana taeks di dombluhunvna. Temba hena andra, hena nihilva Matiu. Wo doa Yesus omnana, yeoa katindim petheinu, wo doa himba phonamba, os Yesusm pethamnana. ");
INSERT INTO wrs_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Wo innemba hlavna Matiuna deuvrava, Matiu, Yesus hev, eva hevna aonghal mahalnind noi hlavna. Wo eva indkumbi taeksdombnind, eva no indhana ten sembayangm beswonam engvm owai vivnam, himba Yesustatanamongo di mongawulm hlavna. ");
INSERT INTO wrs_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Varisinindva monglava nomba sembayangmba keknamba vivnamba, nunglivnamba, hev Yesusna aonghal mahalnindm unna, Yesusva osva sahonam vev, manara, himba innemba wonnev taeksdombnindmba, eva nom indhanam, ten sembayangm beswonam velm owai velvohvm. ");
INSERT INTO wrs_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Yesusva no moamba hellenamba, hev unna olhmona Varisinindm, indhanamba nomba besalva, himba angavmoa mantri indamba, wo heva os indhanamba uvavulmungilva angav mantri indam, hevm kolvrowolalm. ");
INSERT INTO wrs_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Hillu honam mongom Sesoana moam, wo ningvm hona moana plalm. Sesoava os unna indhanamba, Wevsava os lohv, owapevmba indhanamba yimba indvewol vivrava, kolvrowol vivrava, temba mendeklinonoa. Memba no wevsava, tatam yimba suwera wesang viv, kam nonam okolalm, temba mendekliva owai, no wevsava ambota kana novrava. Yesusva mendah ishunvna, kava hona petharamba osmba pronamoa, unvra besal indhanamangas, yeoa saivo Sesoatindi nemellam. Owai, kava indkumbim moakot velm prona, nom indhanakokla nindnahonam, ten sembayang beswonam engivmoa. ");
INSERT INTO wrs_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Henga mongla Yon Baptaisna aonghal mahalnind ambe Yesusindam. Hev umnina, ka eva Varisinind, kava innemba lovahalvohv, os kava sembayangna wevsam engiv. Wo heva os owai, yena aonghal mahalnindva himba innemba lovahalvohvmoa, himba hlangas velvohv elsusva, es hevpa osva? ");
INSERT INTO wrs_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Yesus unna, kavna aonghal mahalnindva lehra viv. Es hevpa indhanamba diva innerava duuswonam vivavma, innemba lovahavavma, nonamba innetihna araravalva diva ahavrava? Owai, wo heva os sismba ungund ambrava, no innena aralmba waianga, wo nonamba hetindiva si ku kusithapravav, wo innemba hlavavmoa. ");
INSERT INTO wrs_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Yesusva mendah ishunvna olhmona hemba, kana nemelmoa eva Varisinindna wevsa mongawulmba akiliha evevmoa. Es hevpa, yimba nemelva pevna bayuva kovovravavma, kuendowol velmba melmba pevna bayukololmba? Owai, henga osva bolavov. ");
INSERT INTO wrs_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Es hevpa wimbva pepavnamba mongawulmba sovhundthoavavma sumb ovshanovollava yimba? Owai, sumbva powallava, wo wimbva os noshara gapiavav. Wimbpapavna yeoa sumb nemella sovhundthoao. ");
INSERT INTO wrs_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Yesusva mendah moamba nomba ishunvna indhanamba, wo mongo sembayangnindna kuwul pronamba Yesusindam, ku kusithamnanamba, osahmana, kana momba doa wohdahai, yeoa prorava, pevna engla sena holothomno, osm himba henga ata beswonam phovav. ");
INSERT INTO wrs_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","21","Wo doa Yesusva hellenamba, pho, wo hem pethamnavna, wo hevna aonghal mahalnindva hemba patvmonavna sisva. Monam mendah ona angana, mongova ungevliriniva di avna, himba tovoltowond vaomana vevna, 12pelara tahonmba lohmanavna. No ungevliriniva os nengna, ata ambo kava kayen mulm Yesusnam kevravav, wo ata kamba kanandhavav. Nonamba Yesusva hemba kuvhoana, sis himba pethamnanamba, Yesusna kayen mulm kevranga ve. ");
INSERT INTO wrs_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Wo Yesusva lohvhoanamba, os ona haravhoana, ungevlirinim nongle. Yesus omnana ungevlirinim, yimba kamba pevna indnahonam amnav, ata yemba henga kanandhavav, yeoa indk vetho daipotaoa. Wo doa no ungevlirinina tovol kik vevnamba, wo doa beswonamangas no ungevliriniva avna. ");
INSERT INTO wrs_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","24","Yesusva ganamba, no sembayang kuwulna deuvra pho. Himba di ona nongalna, men osva viv, wohna vuvna ondahawolavnamba, wuovnamba, no mindm vinivna. Hev unna, yeoa phopiao deuvmerinioa amballam, di kuksa veo, hona mutundisriniva dahaimoa, himba ambo ninliv. No indhanamba losgoplala omnavna Yesusmba, uvna, dasalm ov, esalm osva ov. ");
INSERT INTO wrs_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Himba no indhanamba wolapho ovona amballam, wo hevpa dom osihav, di ungevlirinimindm vindilvnam, no ungevlirinimindna englam kevramna, wo no ungevliriniva henga beswonam pho. ");
INSERT INTO wrs_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Indhanamba no moamba wulvahvna Kapaniam kota nosis, osva Yesusva doa os vei. ");
INSERT INTO wrs_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Yesusva nominiva venamba, monam ona gana, wo novtitmungil sambla epawohamnavna hemba, hev ihishonga evemnana, yimba Devit kuwultindirini lohv, Sesoa yemba pusvundthoana, yeoa kam und vewol verava, kolvrowolo. ");
INSERT INTO wrs_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","29","Yesusva deuvra sihanamba, wo eva no novtitmungil sambla esihoho, wo hev unna hemba, yimba os enengvma, kava arana moana lohv, kava vevav? Hev ohona, e yimba keknamangas lohv, mendekli. Wo doa Yesus novm kekaiv ovinna hevna englana, unna, yimba kamba keknam pevna indnahonam elohmanavna, wo noinda ata kava yemba ovinvavmoa, kolvrowolalmba. ");
INSERT INTO wrs_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","31","Wo doa henga beswonam nov evevna, upsilm enonglavna, Yesusva keknam ongawolna, manam yimba monglamba ihishunvav. Wo heva os ephonamba deuvmeriniva, himba no moamba wulephovna osva no kembella no kembella, ohona, Yesusva os kamba vini. ");
INSERT INTO wrs_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","No novtitmungilva Yesusmba dasvholaha engavnamba, henga mongla indhana moahuim wulambvna, himba moamba ishovnamoa. Doara tihsongo nihmera sihamnanamba, wo noinda himba moamba ishovnamoa. ");
INSERT INTO wrs_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Yesus wohengvapiangamnana tihsongomba hena nihmeriniva, wo henga no indhanariniva beswonam ishovna. Wo no indhanamba indkumbiva os evekingil vithivna, an osva vev honamba? Daipota eva nemet snamba indhanariniva owai, men Yesusangas lohv. ");
INSERT INTO wrs_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Wo heva os mongla Varisinind hev una, Setanmba hev anglavuhuvoho vrev Yesusmba, wo noinda Yesusva engilinv hena tihsongomba. Varisinindva dasalm uvna. ");
INSERT INTO wrs_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Yesusva mindnam lohmana vevna no kembella no kotara diva. Himba os vevna, no sembayangduvrava sihavnamba, indhanam numhowol vevna, yeoa pevmoa weihaloh avramana vevm, wo Sesoatindi nemelalm saivoe. Yesusva mindnam sishona vewol vevna indhanamba, eva snamba ovna, memba uvavulkokla venav, himba ambo nis sishona vewol vevna. ");
INSERT INTO wrs_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Yesusva nomba indhanamba indkumbimba nongalvnamba, hemba mindnam wavra vinvna, hona indhanamba indwonamba aevulvmoa, owai, himba snal aevulv, maim oi, sipsip aralhui, wongalmba vuhebesallamba, indwonamba lovahalmba. Hena nengavnangva mindnam luhungu vinv mana vemamba, wo himba noinda beswonamba aevulvmoa. ");
INSERT INTO wrs_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","38","Doa Yesus unna hevtindim olhmona, osonnamba doa nihil lohv, wo esvema, wo yeoa Sesoam mendeklim osihminivm, osm himba homba mindnam andranindmba wolapra vevav, no osonnam kokolma velm, manara, himba osona aral lohv, noinda andranindva himba eskand ambo tuvulv. ");
INSERT INTO wrs_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Yesusva hevna aonghal mahalnindm mongawulm moakot venamba, unna, kava yemba awothowol vev, osm yimba si honanapopol indhanana tihsongomba wolapho vinvra nihmeriniva. Yimba indhanamba si sishona vewol vivra, eva sna uvavulkoklava indhanamba vinvra, yimba wohvengas vinvra hemba. ");
INSERT INTO wrs_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Men nihilva honi Yesusna moalamangnindnamba 12pelarava lovahinv, Simon mongova henamba nihilva Pita, boaslal Endru, Yems hev eva boaslal Yemsna Yon, himba Sepetina ombolsambla. ");
INSERT INTO wrs_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Pilip eva Bartolomiu, Tomas, Matiu, no Matiuva himba doarava taeks dombluhunvna. Yems Alviusna ombol, eva Tatius. ");
INSERT INTO wrs_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Simon, noi nemet ten Romduangm wolapho vesambaihanam, eva Yutas Iskariot, no si he sewonamba Yesusmba ungundna englisrava holvoholothunvav. ");
INSERT INTO wrs_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","6","No 12pelarava Yesustindiva, Yesusva wolanga vungu vevna, unna hemba, yeoa ango, manam yimba monarava Yutanindna meisnindmba patvunvav, wo eva manam yimba angavav Samarianindramba. Yeoa ango pivna mongawatindiram Israelnindindam. Himba sahonam aevulv, os maim oi, sipsip aralhui kekalvholmba. ");
INSERT INTO wrs_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","8","Yeoa angarava, os ishunvm hemoa, yeoa pevmoa weihaloh vewol viu, indkoklamoa wuleihivm, wo Sesoana nemeltindilm saivvm. Doa mumra vev. Uvavulmungilmoa sishona vewol vivm, eva wolapulvo vevm nomoa, temba doarava sihavnamba. Indhanamba ovra, memba tihsongomungil, wolapulvo vinvm hena nihmerinioa. Nomba ovra, memba kisna, hemoa sishona vewol vivm. Kava doa yemba mindnam awothowol ve, pevmba nonapopolmba. Wo kava osva yemba ninginvmoa, yeoa kamoa di deiswilvm, wo doa yeoa angarava, indhanam kolvrowol vilango, wo manam yimba osva unvav hemba, kam di deiswilu. ");
INSERT INTO wrs_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","10","Nonamba yimba angavpa, ango posal, manam yimba diva nungivav sakrava, eva owaimomolmba olpeliva. Manam yimba pikianmba nungul vivav wondarava monaramba, mongova manam yimba moan pethavav. Manam mongova spatova yimba ianga vevra, manam yimba henga mongova kohopethavra alamba. Ambo posal os lelga vevm, wo indhana si yemba deiswilvra, nomba yimba ningvrava, yimba hem kolvrowol vivra, wo he si yemba kolvrowol vivra, nomba yimba ningvrava mana vemamba. ");
INSERT INTO wrs_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Yimba diva pulvovrava osva deuvkembellava kotarava, nom osihinvm, ora men hehoni besal indhanariniva lohv, kamba ata kolvrowol vevav, wo yeoa di wohaevulvm no deuvrangas. ");
INSERT INTO wrs_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","13","Yimba no deuvrava saivrava, os unvm nomoa, Sesoa yemba wonav. Wo himba yemba sehmoa owol vivrava, Sesoa hemba vinvra indwonam. Heva os himba yemba sehmoa owolmba owai vitava, yena moamba heindava sihangu vinvavmoa, henga si pepra vevra pevindam. ");
INSERT INTO wrs_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Yimba deuvramba angarava, wo indhanamba diva yemba sehmonamba holvorombol ovimba owai vitava, meis haravhueinvra yena moamba, wo yeoa os sandhalahapulvo, pevna somovtov monglarinioa os bumb vewol viu, osm vinvra, indkoklava mendah yenamba luhunv. ");
INSERT INTO wrs_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Tanamolnam sewonamba Sesoava lesvhoawol vevrava indkumbimba, no indhanamba si esesm hemba sahokla vewol vevav. Sotomnind eva Gomoranind nemetva doarava himba indhanakoklanonoa avna. Wo heva os henamba esesmba eva mani si mendeklima, osma no indhanana, ten yem ovinvm. ");
INSERT INTO wrs_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","Kava yemba wolanga vev, kavna andram velm, wo indhanakoklava si yemba helvowol vivav, os ten allambawonda sipsipm helvakomo vivm. Wo noinda osva yeoa novnovhora avm. Wo himba yemba indkokla vewol vivrava, yeoa nesmos vewol viu hemoa, manam yimba hengava hemba vinvav esesmba. ");
INSERT INTO wrs_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","18","Yeoa novnovhora avm, indhanakoklava yemba si ningewol vivra, wetatmoram wonanga vevrava, di helvowol vivra sembayangduvmera. Wo kainda himba yemba di si wetat owol vivav duangmendekli inda. Wo yeoa ambo ishunvm kana nemelmom nom kuwul mendeklim, eva Yutanindna meisnindm ambalnindm. ");
INSERT INTO wrs_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","20","Nonamba no indhanakoklava yemba kekaiv vivrava, yemba wetatmomba wonisholmba, manam yimba duus vivav, manamoa ata kava ishunvav no indhanamba? Owai, Sesoasongol yena nengavnangrava si ishunvra, os unvm hemoa. Yimba os ishuvra, mani pevna nengavnangnamangasma, si Sesoasongol ishunvra yena nengavnangrava. ");
INSERT INTO wrs_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","Yemba kinmba si mendekli pelhola vinvra. Boaslalva si etelmba ungundna englara bumbrisvra, he helvakomo vivra hemba. Aralva hevna towandalva si ungundna englara bumbriswol vivra, wo otomotalva imharavhueinvra, arahumunilmba ungundna englara pelhola ve, wo ungund pulvovra, hemba helvakomo ve. ");
INSERT INTO wrs_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Indhanamba si osangas yemba vinvav kavnilm, wo heva os yimba nomba kinmba iangavrava, wo manam yimba wuleihivav, kalmba pevna undnahonamba almba, wo yemba si kava sandhavav vuhe besallava. ");
INSERT INTO wrs_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Indhanamba mongona kembelnindva kinmba yemba opluthuntava, sandhalaha ango nominioa, mongona kembellam ango, di numhowol vivm. Wo nonamba kava si provrava hona petharamba, si mani eva wenokombonamma owai, si yimba mendahva ora numhowol vira indhanamba deuvnindmba Israelnindna provinsrava. ");
INSERT INTO wrs_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","25","Monglava indhanamba kamba os indkokla vrivna, wo eva yemba si os vinvrata, manara yimba katindi kavna aonghal mahalnind, eva kavna andranind. Aonghal mahalnindva himba iangavav kinmba, osta ten hevna guruna. Andranindva himba iangavav kinmba, osta ten hevna kuwulna. Wo doa indhanamba opipovvnata kuwulmba, osva yimba tanam Setannonoa, wo hetindimba si os moalusnamba woneivra yemba katindimba. ");
INSERT INTO wrs_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","Manam yimba pemba vinvav no indhanakoklanapenamba. Nomba mana vemava, memba daipotava poaitava komandhalohvpa, Sesoava si henga ambara dembhapho vevav. Moamba nomba indhanamba temba poaitava owalmba moashavoshanamba ishunvpa, Sesoava si sism henga ambara henga dembhapho vevav no poaitamomba, osm indkumbiva helletithoavra. ");
INSERT INTO wrs_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Hona moamba kava yemba sinim ishunv, heva os yeoa okombanam moakus unvm musera indhanamoa. Hona moamba kava ambo eskand indhanam ishunv ambo oiwonam, heva os yeoa mindnam moakus unvm, di ten kusovm os maketra, tihra, eva di ten kembella kuksa vevm. ");
INSERT INTO wrs_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","No indhanakoklava yemba helvakomo vivav, heva os owai, yena indva mueisowa vilunvavmoa. Wo noinda osva manam yimba henapenamba vinvav. Sesoamangas yeoa ningminivm beswonam hena popolmangas. Indhanamba yemba helvakomo vivra, heva os Sesoava yena ind eva nihil suwekembella losang vevav mongawulm, hukum vewolalm, wo noinda osva yeoa hemoa pepeh vrivm pevna undnahonam. ");
INSERT INTO wrs_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","31","Eusiltuwava, an ninginv hemba, osva mendekli? Indhanamba owai, heva os Sesoava nonora av osva, os euvmona vev, wo mongova dahavpa, Sesoava nonora. Sesoava yena arapevpa yemba nonora luhunv, wo eva yena nihmba. Yimba mendekli, wohkuvhoawol viv tuawamba Sesoana novrava, wo noinda osva manam yimba pemba vivav indhananapenamba. ");
INSERT INTO wrs_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","33","Indhanamba himba nomba muserava moakus uvrava osva, kava Yesustindim wohpatvunv, wo sism kava si wohindthoawol vevav hemba kavna arainda senamini inda, katindi. Wo heva os himba nomba owalmba nomba osva unvrava, kava tit venav Yesusmba, wo sismba kava aramba senaminimba si eva os omnavavta, kava eva tit venavta hemba. ");
INSERT INTO wrs_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","36","Manam yimba kamba osva ningminivra, Yesusva petharam prov, osm indkumbim mongawundnam alm, owai. Kava prov, daosm velm indhanahovram. Kava ishunv kavna moamba hona pethanindm, osm si vivra, tendoriniva arali hevm ehelvowolvra, mutundisriniva avali hevm ehelvowolvra, wo eva kolva ongali hevm ehelvowol ahavra. Indhanariniva mongova himba nomba kamba engvrava, si hevtindimba nongalvrava, wo ovra, himba kamba musk viniv, himba ahnam lovahv Kristusna moarava. ");
INSERT INTO wrs_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Himba nomba mindnamba araravalmba indvewol verava, wo kamba ambo eskand indvevra, wo himba tanamba katindilmba lohvmoa. Wo himba nomba eva hevna ombolmka molmka mindnamba undnahonamba indvewol vevrava, wo kamba ambo eskand indvevra, wo himba osva tanamba katindilmba lohvmoa. Kava si owai, beswonamba hemba nonglavavmoa. ");
INSERT INTO wrs_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","39","Himba nomba hevna kruseva pungavrava, wo kam wohengvrava, himba nomba tanam katindilnonoa wohlohvav. Wo himba nomba osva nengvrava, kava kavna nengavnangva wohvepiavra, heva os owai, hemba si indkokla vevav. Wo heva os himba hevna nengavnangva wuleihatava, wo kanamangas engvra, himba nomba si vuhe besalla avav. ");
INSERT INTO wrs_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","Himba nomba yemba holvorombol ovotava, wo yena moamba hillivra, henomba kamba eva holvoreivta osva. Indhanamba kamba losnamonamba indwonamba holvoreitava, temba himba nom viniv, ten henoi kam hom wolaihapranam hona petharam. ");
INSERT INTO wrs_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Indhanamba nomba moashulnindmba losnamonamba indwonamba holvorombol vivrava, memba besal, yeoa ambvrava, kam ishumnivm, wo Sesoa si kolvrowol vevav no indhanamba, os men Sesoa hevna moashulnindm vinvm. Indhanamba nomba besal indhanamba losnamonamba indwonamba holvorombol vivrava, memba besal hevm, yeoa ambvrava, kam ishumnivra, wo hemba nomba Sesoava si hemba kolvrowol vevav, os men Sesoa hevna besal indhanam vinvm. ");
INSERT INTO wrs_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Himba nomba mongomba katindirinimba moknamba pomba vraohtava, yimba memba kana mongawa Yesustindirini, wo noinda osva Sesoava si hemba maivethavavmoa, eva snamba indhanariniva mani nihil mendeklinama, owai, himba katindirinita. ");
INSERT INTO wrs_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Yesusva ishupieinnamba hevna aonghal mahalnindmba 12pelarava, wo himba nominiva venamba, wo os lohmana vevna di mendekli kembella, indhanam ishomana vinvna nemelmom. ");
INSERT INTO wrs_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","3","Nonamba Yon Baptaisva buimera avna, wo di himba moamba osva hellena, Yesusva os vev, wo Yonmba nominiva wolapra vena hevna andranindmba Yesusindamba, yeoa angarava, Yesusm osihminu, es hevpa yimba tanam ambo Kristusma, kava Israelnindva os ningv, himba si kaindam prunvav? Yesus Kristusva lohmba owai vetava, kava si osangas hemba nengviluwuvra. ");
INSERT INTO wrs_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Yesusva nomba moamba hellenamba Yonnamba, wo hev unna nom Yontindim, yeoa henga angarava, Yonmoa os ishumnu, men pev kam nunglivm, men kav vevm, eva men pev hillivm, men kav indhanam ishunvm. ");
INSERT INTO wrs_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Yeoa Yonmoa os ishumnu, Yesusva novtitmungilmba doa sishona vewol vena, himba daipotava henga beswonam novviv. Indhanamba monglakoklanamba, doa daipotava himba beswonam lovahmana vev. Indhanamba nomba lombamungilva, daipotava doa himba besalangas lovahv. Indhanamba nomba aongmimungilva, doa daipotava himba beswonam hilwilv henga. Indhanamba nomba ovna, memba mindil, Yesusva henga doa wolapho vevna. Indhanamba nomba ovna, memba innehui malohui deuvhui, wo Yesusva hemba honi nemelmoa ishunvna. ");
INSERT INTO wrs_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Yesus unna, yeoa hona moaoa Yonmoa os ishumnu, wo eva os, kava os omnav Yonmba, himba nomba kamba mindnamba keknamba hevna undnahonamba lohvhoamnavrava, wo osangas wohvevra, himba nomba si indk vethavav. ");
INSERT INTO wrs_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","8","Yontindiva no moamba Yesusnamba hillipieinamba, doa os wohangana, Yesusmba dasvholaha angana, Yonmba ishumnilmba. Yesusva mendah osangas ishomana vinvna indkumbimba, nom ten hillimnivnam hena moam. Yesus unna, nemetva yimba os nunglina, Yon Baptaisva indhanamba pona poswol vevna diva pethakoklarava. Snal lohvna, es yimba nunglivna? Yimba os umnivnama, maim oi, wandm vuvi kusukul vewol vev? Owai, yimba os umnivnama, Yonmba malo nemel besal ilohv? Owai, indhanamba nomba snamba, yimba nongalvra hemba mendekli kuwulna deuvrangas. ");
INSERT INTO wrs_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Es hevpa, snal Yon Baptaisva luhunvna yeindava? Yimba osva umnivnama, himba kamba ishunvna Sesoana moam? Lehra yimba temba uv, Yonmba os vena. Wo hillu, Yonna moamba mendekli, himba moashulnind owalmba henga kuvhoawol vev, Sesoanamba doarava temba aevulnamba. ");
INSERT INTO wrs_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Manara, Sesoana moamba doara novol velohvna, Yon Baptaisva ambo kolmalm wohengvna no moamba, os novol velohv, Sesoa omnana Kristusm, kana moashulnindriniva di si avra, wo kava hemba si mi wolaihangavav, monam mim vuenghanguamnalm yem, osm yimba noindava beswonam gavav. ");
INSERT INTO wrs_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Yesusva mendah ishomana vinvna hemba, unna, Yon Baptaisva eva mendekli indhanarinita lohv. Wo mongova snamba doarava wulluhnamoa, memba Yonna moamba. Wo heva os Sesoana nemeltindiva daipotava av, wo himba mendekli lovahv, Yonmba kuvhueiv, manara noinda himba Sesoana nemelmoa ilvahv. Eva indhanariniva Sesoana nemeltindiriniva, himba nomba nihilva eusil wulluhvra, heva os no indhanariniva mendekli, Yon Baptaisva owai, manara noinda no indhanariniva Sesoana nemelmoa wulluhv. ");
INSERT INTO wrs_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Yon Baptaisinda venamba, verava, men daipotava kainda, Sesoava doa moakot vevna mongawulm hevna nemeltindilm. Indhanamba eva ombamba nisva es saivvav owai, himba heva boasna ehlana andra vivra. Yeoa indhanaoa snangas vilo, maim ovra, kelsombovhol indhanarini monatuv kekelmella wahpavwonam sihav. ");
INSERT INTO wrs_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","15","Yesusva mendah wohishomana vinvna hemba Mosesna eva doaraminina moashulnindna lohohmom, os temba novol velohv, Sesoana nemeltindiva si sism phovav. Mongova Elaitamsna himba hesna mi provav, wo Sesoava hetindim mongawatilmba moakot vevra. Moamba os novol velohv, wo kam keknam hillu, Yon Baptaisva hengas hona indhanarini. Yeoa honam keknam ningvrava, wo kam keknam pevna undnahonam ningminivm. ");
INSERT INTO wrs_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","17","Yimba hona indhanamba sambla undna, yimba os maim oi, otol dilohov kembella. Monglava hevm akosrombmana vev, kava indk vithiv, sangalna euvmona ovov, wo heva os yimba kamba opatvunvmoa. Mongova os uv, kava elo viv, heva os yimba kamba kolvrowol vivmoa elorava. ");
INSERT INTO wrs_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","19","Nonamba Yon Baptaisva yemba wonavnamba, himba inne besalva nevnamoa, wo himba wainmba wonnevnamoa yemba, himba lohovna. Wo yimba os umnivna, dai venav, manam pimba hillimnivav hena moamba. Wo daipotava kava yem wonav, kava innemba yemba wonnev, wo indwonam kava av, wo yimba kamba loumona ishuwul venav, Yesusva innemba mindnam nev, himba wainmba mindnam nev, himba taeks dombnindmba eva nom monglam, ten sembayangm engvm owai vivm, himba wainmba nom wonnevna, manam yimba hena moamba hillivav. Yimba hona indhanamba memba sambla undna, heva os Sesoana nemelmomba kava moakus ulihev, wo indhanamba besalundnamba himba wohkek vithiv nemelmomba, memba tanamolnam. ");
INSERT INTO wrs_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Yesus unna, indhanana sahoklalva luhungu vinv mendah. Himba kamba nungliv, kava mendekli andrava vevpa, os maim oi, Sesoa hev vev, heva os owai, himba kamba hillivnamoa, wo hevna indkoklariniva hevmba weihaloh avramana vevnamoa. ");
INSERT INTO wrs_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","Ye Korasin kotanind, wo ye eva Betsaita kotanind, wavrapeto. Sesoava si yemba hukum vewol vevav, manara, kava mendekli andra vinvna yena novrava, heva os yimba weihaloh avramana vevnamoa pevmba. Ungund Tairnind, wo eva Saiton kotanind, himba doarava snamba kanamba mendekliandramba nunglitava, ata himba doara wuleihita hevna indkoklamba lelnam. Himba ata pikiankolol vewol vitava, somov sawol vita, uta, kava indhanakokla, kava doa wuleihiv. ");
INSERT INTO wrs_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Sismba Sesoava si lesvhoawol vevra indkumbimba, wo Sesoava si kinsomb pelhola vinvav no Tairnindm, wo eva Saitonnindm hevna indkoklarava, wo yem Korasin eva Betsaitanindm, Sesoava si yemba mindnam esvema kinsomb pelhola vinvav. ");
INSERT INTO wrs_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Yesusva mendah osangas ishunvna, yimba Kapaniam kotanind, yimba os ningvma, kava monara lovahv senamba, heva os owai, Sesoava si yemba pingipiha vevav dom, ten indhana snal avm mindilmsna. Kava mendekliandra vewol vinvna yena novrava, heva os owai, yimba pevna indkoklariniva pevmba weihaloh avramana vevnamoa. Himba Sotom kotanindva doarava nunglitava no andramendekliva, ata himba doara wuleihita indkoklava, ata himba beswonam avta. ");
INSERT INTO wrs_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Heva os yimba pevm weihaloh avramana venamoa, wo sismba Sesoava lesvhoawol vevrava indhanamba, himba si Sotomnindmba kinsomb pelhola vinvra, wo heva os yimba hona indhanamba, Sesoava si esvema yemba vinvav kinsombva. ");
INSERT INTO wrs_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","26","Yesusva indk vethavna, wo himba Sesoam aralm okolavna, ara, yimba mendekli senamininindna, wo eva hona pethanindna hui. Yimba lehra vena, pevna besal nemelmomba yimba ishunnamoa nonoanindmba, owai. Memba os maim oi, yimba komandhinv hemba, wo himba liheivavmoa, wo heva os ombandhanamba yimba ishunvna pevna nemelmomba hemba, wo himba wohkek vithivna. Lehra osva yimba vena, memba yena besal nengavnangva. ");
INSERT INTO wrs_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Kana aramba doa wohhohlona manimani kana englara, ona, ye kuwuloa wulluhunu honanaoa. Mongova mana vemamba dihelvmoa poaitava, kana englisrangas. Heva os indhanamba kanamba plalva tit vivna, Sesoangas hevhoangas nonorava lohvna kana plalmba. Indhanamba Sesoana plalmba tit vivna, kava kavangas nonorava lohv. Kava osva indhanamba vinvrava, wo moamba ishunvrava, wo osangas himba lihavra aramba Sesoamba. ");
INSERT INTO wrs_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Yesusva mendah unvna indhanamba olhmona, yimba hona indhanamba kinmba wena niswol vivpa, os yimba ianga vev, yeoa kaindam ambvrava, ata yemba ka sishona vewol vevra, wo yemba ata os kanandhawol vevav beswonam. ");
INSERT INTO wrs_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","30","Wo doa yeoa kana kinoa livreiu, wo kam engivm, wo kana moam hillivm. No kinmba kava ata yemba plothunvavpa, kin vevmoa, ivrakokol. Kava wowonam vev, wo owai, kava kavmba wulovongovmoa, wo noinda si yimba indwonam vivav. Kava yemba popaiha vewol vev, osm verava, ye wohveleksethira honam besalnemelmom. Wo undva yenamba si kin vilunvavmoa, wondewonam. ");
INSERT INTO wrs_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","2","Sismba Yesusva hevna aonghal mahalnindm wongavna sapturamba vah iaevul okombanam. Himba monam wongavna, ten osohovmonam dihelgavm. Yesustindimba doa pon vinvna, wo doa hev witmov pueitnamba, noi hlawulangavna. Monglava doara di Varisinindva lovahvna, nungeilnamba hemba, wo umnina Yesusm, nongaltok, yetindiva doa doaramini lohohmomba pilpikovoi, os novol velohv, manam osva vivav vah iaevul okombanamba. ");
INSERT INTO wrs_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Yesus unna no Varisinindm, katindiva lehra viv, mongova men moamba os novol velohv pina Devitna simbelnamba, himba nomba osva vivna, wo yimba beswonamba hillivnamoa dihi? ");
INSERT INTO wrs_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Yimba nonora, Devittindimba eva ponmba vinnata, wo himba Sesoana sembayangduvra wonsihanamba, wo roti vra, honi men piv sevrivm, no rotiva Sesoana novrava nalohv. No rotiva heva sembayang andranindangas hlav, ombandhanamba owai, es eva hlavav. Heva os Devitva vrana no rotiva, hev eva hevtindi os wonnena, hemba nonamba mindnam pon vinvna. ");
INSERT INTO wrs_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Mongmomba eva novol velohvta Mosesnamba honi vah iaevul okombanamba, wo kava os nengv, yimba beswonamba hillivnamoa. Sembayang andranindva tempelduvmerava himba andra viv hevna andrava diva vah iaevul okombanamba, ombakombonamangasva owai. Himba hevna andramba wuleihivavmoa vah iaevul okombanamba, wo heva os moamba os novol velohv, lehra viv, himba sahonamba vivmoa. ");
INSERT INTO wrs_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Hillu, pina doaramini lohohmomba eva pina tempelduvpa hevm mendekli, wo heva os mongo men nemel tendorini, wo hev eva hevtindi himba mendeklinonoa. Hetatanamba mendeklinonoa, heva os tempelduvpa mani mendeklima, wo yeoa hena moamoa wohhellangas vinvm. ");
INSERT INTO wrs_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Mongmomba os novol velohv, Sesoava os ona, innepeta tata suwera wesang wevsa besal mendekli, heva os indhanana wevsava, temba owalmba akolvramona vevpa, temba mendeklinonoa, kava nom und vev. Moamba nomba os novol velohv, heva os yimba beswonamba hillivnamoa. Yimba doarava hillitava plalmomba no moanamba, wo osva yimba ata katindiva nangwol ovuvavmoa huiva. ");
INSERT INTO wrs_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Kava arana ombol, wo Sesoa kamba hev hona mendeklimomba vraohna, wo kava noinda indhanamba wohtvra, mana vemamba himba velmba vivrava hona vahi aevul okombanamba. ");
INSERT INTO wrs_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","10","Yesusva nominiva venamba, wo sembayangduvra siha, mongova indhanariniva doara di avna, henamba englava doara heva doa vendpethamnana, no mungil avna. Varisinindva doara di lovahna, wo hev umnina Yesusm, es yimba nengv, es hevpa yimba lehra sishona vrevavma indhanarinimba hona vah iaevul okombanamba? Himba ambo dasalm umnivna Yesusmba, doara doa himba hevmba ishuvna, osva Yesusva hona indhanarinimba sishona vretava detiva, ata pimba Yesusmba wetat uvav kuwulinda osva, Yesusva doa pilpikoheini lohohmomba pinamba. ");
INSERT INTO wrs_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","12","Yesusva doara nonora, himba temba osva ningvnamba, wo Yesusva hemba olhmona unna, yenamba sipsippa mellava mongova selvopetava honanamba detiva, es hevpa yimba holvopivongovavma a owaimi? Yimba holvopivongovavta, noinda hevm besalta, eva kamba indhanamba sishona vewolalmba detiva. Yimba osva tit vivma, indhanariniva mendeklinonoa, sipsippa owai? Kava hona indhanarinimba ata sishona vrevrava, osva kava pilpikohavavmoa pivna doaraminimomba, owai. ");
INSERT INTO wrs_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Wo Yesus omnana no indhanarinim englapetmungilm, engla pevna liotok, no indhanarini shuana hevna englam, wo hena englava os henga wohkanandhana. ");
INSERT INTO wrs_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","No Varisinindva os wohphopiana ambaramba, wo hevm eishu vreihungu vevna, es hevpa pivva Yesusmba helvakomandhivavma? ");
INSERT INTO wrs_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Yesusva nonora luhunvna, himba ningminiv, kam helvakomandhalm, wo hevpa os wohgana nominiva mongnahalm. Indkumbiva sis pelpethaomana venavna, wo Yesusva uvavulkoklamungilmangas sishona vewol vevna. ");
INSERT INTO wrs_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","17","Yesusva ongawolvna keknam, manam muserava yimba ishunvra indhanamba, osva Yesus kamba sishona vrei. Yesusva wohengvna moamba Aisaia moashulnindrinina doaramininamba, nomba moamba os novol velohv, ");
INSERT INTO wrs_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","Sesoa unna, men kana andranindriniva, kava kav kikih vrena hemba, wo kava hemba mindnam und vev, indk vethamnav, kava si kavsongolva heindamba wolaihapravav, wo os himba nonapopol si ishunvra Yutanindna meisnindmba, osva Sesoava si yemba lesvhoawol vevav beswonam. ");
INSERT INTO wrs_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Noi kana andranindriniva si indhanamba ongawolvavmoa, eva vevandnamba ishunvavmoa hemba, himba muserava hulaikalawonamba indhanamba ishunvavmoa. ");
INSERT INTO wrs_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Himba si ambo innenal indhanarini lohvra, himba si indhanamba kinwondava pelhola vinvavmoa, owai, himba si kolvrowol vevra hemba, wo indhanamba noinda si osva uvav, Sesoana wevsava lehra, himba pimba lesvhoawol vev. ");
INSERT INTO wrs_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Yutanindna meisungundva indkumbi si he hona indhanarinimba osva umnivav, hengas keknamba lohv, wo he si pimba kolvrowol vevav. ");
INSERT INTO wrs_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","23","Henga mongo indhanarinim waiambna Yesusindam, heva doara nemet tihsongo hena nihmera sihanamba, wo himba noinda vena, novtit vevna, moahui lohvna, moalamangva pongthoamnana. Wo doa Yesusva hemba sishona vrenamba, doa henga himba beswonam nongalvnamba, moa ishovna. Wo indkumbiva no indhanarinimba nunglivnamba, nihtov daihaprinvna, pem viwul vevna. Himba os hevmba eishovna, Yesusva dihi Kristus lohvma, nomba Devittindirini lohv? ");
INSERT INTO wrs_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Varisinindva no moamba hillivnamba, indhanamba temba hemba ishunvnamba, osva Yesusva Kristus lohvma? Wo heva os himba hevm eishovna, owai Yesusva andranindrininonoa, himba Setannapopol vev, Sesoanapopolva owai. Setanmba kuwul wulluhunv tihsongonamba, wo noinda osva Yesusva wolapho vev tihsongomba indhanana nihmerinimba Setannapopol. Himba ambo dasalm uvna. ");
INSERT INTO wrs_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","26","Yesusva doara nonora luhunvna Varisinindna nengavnangmba, wo himba olhmona unna hemba, yimba dasalm uv. Hev unna, mongnindva avra, wo daos oho hevm, wo hev os muhavav, avavmoa. Wo es hevpa Setanmba hevnamba owalmba wulengvapiangatava hevna indhanaminiva, temba os hevm ahalvakomandhavav owalmongo, wo os wohsihavav. ");
INSERT INTO wrs_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Yimba os uv, Yesusva Setannapopol tihsongomba wolapho vev. Yetindiva henoi ten wolapho vevm tihsongom indhananamini, wo annapopol himba viv? Yeoa hemoa sahowol viu, yemba si himba ishunvav, Sesoanapopol. ");
INSERT INTO wrs_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Sesoasongolva kolvrav kamba, henapopol kava wolapho vev tihsongokoklava. Memba honamba os, Sesoava doa hevtindim wonav beswonam, heva os owai, yimba liheivnamoa. ");
INSERT INTO wrs_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Yesusva mendah Varisinindmba olhmona unvna, os mongova indhanariniva lohvra, kelsombovhol indhanarini avra, an sihavav no indhanarinina deuvrava, osmba wohva hevm wohingavav? Henongas henoi seilm saongna no kelsombovhol indhanarinim ningevavm, wo himba no wohva os wohingavav. ");
INSERT INTO wrs_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Indhanamba himba nomba temba kamba andrava velmba owai vinivpa, himba tanam kana moamba hillivmoa. Indhanamba himba nomba kamba kolvralmba owai vivpa, osonnamba kokolma velmba kana deuvrava, himba tanamolnam no innemba dembhanga viv. ");
INSERT INTO wrs_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Indhanamba himba nomba Sesoamba indkokla vrivpa, moakoklanamba umnivpa, Sesoava si maivethinvav hena indkoklamba. Wo heva os indhanamba himba nomba Sesoasongolmba moakoklanamba umnivrava, temba mendeklinonoa indkoklava, Sesoava nomba henamba si maivethinvavmoa, si yunalm wohluhunvav no indhananamba. ");
INSERT INTO wrs_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Indhanamba nomba kamba arana ombolmba moakoklanamba eishomnavrava, Sesoava si no indkoklava maivethinvav, wo heva os indhanamba moakoklanamba umnivrava Sesoasongolmba, temba mendeklinonoa indkoklava, wo si yunalm luhunvav no indhananamba, nonamba Sesoava si lesvhoawol vevrava indhanamba. ");
INSERT INTO wrs_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Yesusva mendah ishunvna Varisinindm, movolla pimba osva liheivav, hona denwitva besal lohv, hona denwitva sahoklal lohv. Denwit besalva movolva besal kethav, sahoklalva tilva movolva sahoklal kethav. ");
INSERT INTO wrs_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Yimba sahoklal indhana, os maim oi, saipusuhla. Yimba sahoklal indna vilov, wo noinda es eva moa besalva yimba ishuvav, owai. Manara noinda mindemba yenamba kolmal dombv undna. ");
INSERT INTO wrs_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Besal indhanamba besal indna vilov, wo himba moamba ishuvpa, himba tanamolnam wohishuv mana vemamba. Sahoklal indhanamba indkoklanamba, wo himba moamba os ishuvpa, himba mana vemamba sahoklalm ishuv, wo himba dasalm uv. ");
INSERT INTO wrs_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Si sewonamba pethava mueisowa vevrava, Sesoava si lesvhoawol vevav yemba, wo eva no moam si sahowol vevra, nemet ten pev ishuvnam indakondakonda moa, eva moa eusilva yimba temba ishuvnamba, nomba temba yimba beswonamba ningvnamoa. ");
INSERT INTO wrs_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Nonamba Sesoava yemba beswonamba nongalvrava, temba osra, yimba hona petharava moamba beswonam ishovna. Heva os nonamba Sesoava moamba wulluhmanatava yemba, temba noinda yimba doa nemetva moakoklava ishovna hona petharava. ");
INSERT INTO wrs_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Henga katekis eva Varisinind hev umnina Yesusm, kana novra andramendekli vintok, osm kav nom nunglivav, wo uvav, tanam memba honamba Sesoanaminiangas. ");
INSERT INTO wrs_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Yesus unna, owai, yimba indhanakokla, wo yimba kamba engivmoa pevna undnahonamba. Yimba ambo dasalm kamba sah ovrivna, kava nonglalm viv andramendeklim. Sism si yimba nunglivav mana vemamba mendekliva, kamba venavrava, os ten nemet moashulnindrinim Yonam venanam. Honamangas yimba si nunglivav. ");
INSERT INTO wrs_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Yimba nonora, nemetva Yonava tambkona emerava samblamongonin vena, wo himba henga os phona. Wo kava si sismba samblamongonin vevav pethamerava, wo si henga kava beswonam phovav. ");
INSERT INTO wrs_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Kava si os vevav, wo sismba Sesoava indkumbimba indhanamba lesvhoawol vevrava, himba si yemba os unvav, es hevpa yimba eva? Wo nonamba Nineva kotanindna englapundva si owosaluhunvav yeinda, os yenamba sahokla luhunv. No Ninevanindva himba Yonana moamba hillivna, wo hevna sahoklalmba wuleihina. Wo yimba hona indhanamba owai, wuleihivnamoa pevna sahoklalmba. Kana moamba mendekli kuvhoav Yonanamba, wo heva os yimba hillivmoa, wo pevna sahoklalmba wuleihivmoa. ");
INSERT INTO wrs_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Sismba Sesoava nonamba yemba lesvhoawol vevrava, kuwul mendekli puehalnindrini himba hevna englapundva si yeinda woseinvav, yenamba sahoklava luhunv. No kuwul mendekliva ehalmini prona pethamullini, kuwul Solomonm nonglalm, himba hellelm vevna Solomonna Sesoamom. Wo kana moamba kuvhoav kuwul Solomonna moamba, wo heva os owai, yimba hillivnamoa. ");
INSERT INTO wrs_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Yesusva mendah ishunvna katekism eva Varisinindm, yeoa pevm weihaloh vewol virava, kana moam engivm, si homeis yena und ambo nis lovahinvm. Men os, indhanariniva mongova tihsongomungilva lohtava, hena nihva snal maim ui, tihsongona deuv, no tihsongova pholahangatava, di ambo lohmana vevra vuhekoklara pohuira, vuhe besalm silelvra, noindam eha vawolm. ");
INSERT INTO wrs_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","Heva os owai, no tihsongova os ov, kava henga gav, dom ten seilm kav avnam kavna deuvmera. No tihsongova hengava gavnamba hevna deuvramba, ovna novvesiha vevnam, mongova indhanariniva avmoa, deuvpa ambo povawov beswonam, kava henga si hui wohavav. ");
INSERT INTO wrs_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Heva os seilmba himba ganamba, owalm 7pelara onkeinna tihsongo owalm, temba nomba indkoklalnonoa, wo no deuvram wonprona, wo di mongawulm aevulvna. Wo no indhanariniva si os wohindkokla vovhoavav, hena nihmerava tihsongova mindnam aevulv, mongalva owai. Yimba indhanakokla, wo noinda osva yeoa pevmoa weihaloh vewol vivm. ");
INSERT INTO wrs_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Yesusva mendah ishunvna, wo indkumbiva os helletithoavna, wo Yesusna avaltatanamba ambanamba, amballa lovahtha, wo una, kava Yesusm moam isholm viniv. ");
INSERT INTO wrs_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Mongo indhanarini di omnana Yesusm, yena avapevtatanamba ten amballa lovahv, himba yem moam isholm viniv. ");
INSERT INTO wrs_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","50","Yesusva no indhanarinim nongla, wo ona, an kana avalva, wo eva anmund kana towandaslalva? Himba mendah wohishunvna, wo hevna aonghal mahalnindmba indthoawol ovovna englana, men hona indhana, kana avalnamba, towandaslalnamba. Indkumbiva himba nomba kana senaminina arana moamba kek vithirava, eva engivrava, temba himba nomba katindi. ");
INSERT INTO wrs_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","3","Yesusva no deuvriniva venamba, wo ambo di avhoa plombpethalla, indhanam ishunilm. Diva nonamba indkumbi kusomnana, ambo alapat vevna, Yesusmba hellelmba, wo Yesusva botsra sena avhoanamba, indkumbiva nomba hellelmba vivnamba, nomba engalla kusona, Yesusva mindnam olhmonamba unvna. ");
INSERT INTO wrs_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","6","Indhanariniva witkul kuku vev hevna osora, himba nonamba witkuva kuku vevpa, bumb vupingu vev, monglava ambo kuku vepethav nambotindilla monara, wo tuawa hlapiav. Monglava honsra kuku vepethav, pethava ambo dasalm hehlathalohv senamba. No pethakoklarava witkuva lelnam phov, heva os owai, plalva pipiha vevmoa, okombara wohsimind wohvev. ");
INSERT INTO wrs_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","9","Monglava ilkoklasra kuku vepethav, wo il wohvendningewol vevpa, wohmueisowa vev. Wo heva os monglava witkuva pethabesalla kuku vepethav, wohphongas vev. No nihil besal wohkethav mindnamba. Monglava 100pelara kethavna, monglava 60pelara kethavna, monglava 30pelara kethavna. Yimba lihalmba vitava hona olhmomba, keknam hillu, beswonam ningvm. ");
INSERT INTO wrs_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","12","Hevna aonghal mahalnindva ambanamba Yesusindam, umnina, guru, esalm yimba unv hona olhmonamba hona indhanamba? Yesus unna, Sesoava pusvund venamoa hona indhanamba, wiyelmba, wo kava unvna hona olhmona. Yemba kava plalmona ishunvna, noinda Sesoa doara yemba pusvund vena, wiyelmba hona plalmomba, nemetva doarava poaita lohvna, heva os daipotava kava yemba musera ishunv. Hillu, indhanariniva Sesoana moamba wiyerava lohvrava, Sesoava si dembraohvav hemba, wo himba si mindnam iavav. Wo heva os indhanariniva eskandva iatava Sesoana moamba, Sesoava si komavav, himba wiyeivavmoa Sesoana moamba, Sesoana nemeltindiva os av men. ");
INSERT INTO wrs_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Hona indhanamba kava olhmona unna hemba, noinda himba aongna novna nona himba lovahmana vevna, heva os himba nungeilvnamoa mana vemamba, wo himba liheivnamoa plalmomba, owai. ");
INSERT INTO wrs_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Himba keknam wohengivna Aisaia moashulnindrinina moam doaraminim, os novol velohv men, Sesoa unna Israelnindm, yimba hona indhanamba si osangas hellelvohvra hona moamba, heva os yimba levrapivolvavmoa hona moana plalva. Yimba si os aslalvra, wo os aslalloh vevra, wo heva os yimba si mana vemamba nunglivavmoa. ");
INSERT INTO wrs_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Manara, noinda yimba kelsombovhol av. Yena aongva nithawol vilunv, yimba beswonamba hilwilvmoa, wo yena novpa yimba novvivmoa, yimba kolthoawol viv. Yimba kamba nunglivmoa, wo yimba kamba hillivmoa, wo kana moamba liheivmoa. Yimba pevna indkoklamba wuleihivmoa. Yimba osva vitava, kava osva yemba sishona vewol vevav, heva os owai, yimba vivmoa osva. Sesoava os ona. ");
INSERT INTO wrs_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Yesusva mendah osangas ishulprunvna hevna aonghal mahalnindmba, ona, hona indhanamba wohengivna keknam moashulnindna moamba, wo heva os yimba katindiva, yimba beswonam novviv, beswonam hilliv, wo beswonam levrapivolv kana moamba. Yimba wohkanandhina, yeoa indk vithu. ");
INSERT INTO wrs_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Nemetva mindnam avna Sesoana moashulnindva, wo himba eva mongla besal indhana, himba keknam ningvna osva, kava lihalm viv Kristusmba. Heva os owai, himba kamba nunglinamoa, yengas daipota kamba men nungliv. Himba kana moamba hellelm vivna, heva os owai himba, men yengas daipota. ");
INSERT INTO wrs_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","Yesusva mendah ishunvna hevna aonghal mahalnindm, yeoa hillivm, kava yem ishunv, indhanamba owai, no olhmona plalmomba, indhanariniva witmovpa kuku vevnamba hevna osorava. ");
INSERT INTO wrs_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Indhanariniva hellevrava besal nemelmomba, Sesoana nemeltindina moamba, wo no indhanariniva gimus vetava, no moamba kek vethalmba, wo Setanmba owai, wenokombova vevavmoa, himba lelnam prorava, no moamba yukov vika. Memba os, maim oi, Sesoava osora wolai, wo Setan proiva, yukov vika. Hona moamba lehv witkulm, nom ten monara bumb vepinganam nambotindilla monara. ");
INSERT INTO wrs_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Wo witkuva, temba bumb vepinganamba petharava, ambo temba dasalm nalohv senamba honsrava, no witkuva indhanam lehwol viv, himba besal nemelmomba hilliv, wohkek vithiv, wo indk vithiv, ");
INSERT INTO wrs_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","wo heva os himba mindnamba kek vithivmoa, os maim oi, tipla pipiha vev pethamera. Wo monglava indhanamba kinwondamomba hemba pelhola ovumnitava, osihitava hemba osva, yimba Yesustindirini, himba os kana moamba lelnam wuleihavav, himba katindilmba lohvavmoa. ");
INSERT INTO wrs_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","No witkuva, temba ilkoklarava bumb vepingavnamba, indhanam lehwol vivna, himba besal nemelmomba hilliv, wo sismba kinmba phungu vinvna hemba, wo himba mindnam ningvna, kava si wohtowond wohavav yunalm. Wo no nengavnangva os, ten ilkokla osom ehlathanam, wo owai, innemba phonamoa. ");
INSERT INTO wrs_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Wo heva os no witkuva, temba pethabesallava bumb vepingavnamba, nomba temba indhanam lehwol viv, nom ten besal nemelmom kek vithivm, wo velokusa vivm plalmom hevm. Himba snal, maim oi, pethabesal, aralva ambo eskand wolav, heva os movolva 100pelara kethavna, monglava 60pelara kethavna, monglava 30pelara kethavna. ");
INSERT INTO wrs_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","25","Yesusva mendah unvna olhmona hemba, Sesoana nemeltindi os av, indhanariniva witmovbesal hevna osora wolavna, sismba hevpa deuvrava ninmba livnamba, mongla ungund anganamba, ilkoklakul kukuvi poaita hena osora. ");
INSERT INTO wrs_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","27","Doa sismba no witmovpa phovna, wo heva os mendah vevna, wo eva ilkoklava phovnata. Wo doa andranindva nunglivnamba, anga osona aralindam, umnina, nemetva yimba temba witkuva kukuvenamba pevna osorava, es hevpa witkuva besalangasma? Owai, ilkoklanahonam phov. ");
INSERT INTO wrs_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Doa osona aral unna hemba, esma ungund vina honamba. Wo andranind umnina, ata kava angarava, ilkoklava vileivav plalnahonam. ");
INSERT INTO wrs_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","30","Osona aral unna, owai, ata homeis yimba witnahonam vileivm. Sism si aembulva ksuvhoapravrava, wo kava si unvav kavna andranindmba, ilsna lumeihu boasna, niswol vivrava, doa os suweraoa nisseng vivm, wo huhul vivm witoa di kana inneduvra. ");
INSERT INTO wrs_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","32","Yesusva henga unna olhmona, Sesoana nemeltindiva os av men, indhanariniva mana vema eusil endhav hevna osora, no movolva os sevriv, mastat, wo mindnamba nuktva movolva mendekli, himba owai, eusilnonoa. Wo heva os himba nungi lelnam mendekli ve, wo kuvhoawol ve osonnamba monglava, wo tuawava di lamba dembrulsihav klallava. ");
INSERT INTO wrs_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Yesusva mendah unvna olhmonangas, Sesoana nemeltindiva os av men, ungevliriniva yisva ambo eskand vevna, wo plawanahonam imharavho vrevna, samblamong os kuendhalohvna. Wo doa sismba no plawava esvema tevwol vena bretalm. ");
INSERT INTO wrs_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","35","Yesusmba nomba temba pelkleihalohmana venavpa, himba olhmonangas unvna hemba, plalmomba owai. Himba wohengvna Sesoana moashulnindna moam, os men novol velohvm, Sesoava os ona, kava si olhmonangas ishomana vinvra moamba indhanamba. Kava moamba no si ishunvra, doarava kava seilmba ishunnamoa, poaita komandhalohvna, nonamba ovi pethaimba kava vewolvnamba, veiva, daipota men. ");
INSERT INTO wrs_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Yesusva sandhalahapho, nomba temba tellohmana vevnamba, wo deuvram ga, wo hevna aonghal mahalnind ambanamba, umnina, kam ishunu ilkoklanam plalm osorinim. ");
INSERT INTO wrs_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","38","Yesus unna, no indhanariniva temba witkulva nemelva kukuvenamba hevna osorava, kam lehna, kava arana ombol. No osomba lehwol vev indhanam pethanindm indkumbim. Besalva witkuva lehwol viv indhanam, nom ten Sesoana nemeltindilm avm. Ilkoklava nom indhanam lehwol viv, ten Setanm engivm. ");
INSERT INTO wrs_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","No indhanariniva temba ilkoklava kukuvenamba kana osorava, temba hev Setan. Andranindva nomba temba osonnava kokolma vivnamba osoriniva, temba lehwol vivna Sesoana ovsongolnindm, himba hevna andra vivav, nonam hona ovi pethai mueisowa evewolvram. ");
INSERT INTO wrs_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","41","Andranindva ilkoklava osoriniva lumeihvnamba, suwera singi, wo memba osm kava si sewonamba os vevav. Kava si wolanga vungu vevav kavna ovsongolnindmba, osm himba si Sesoana nemeltindimba lesvhoawol vivra. Himba si engilvra no indhanakoklamba, temba Sesoana lohohmomba aongpa vivpa, wo indhanam owalm kekaiv viv monakoklaram. ");
INSERT INTO wrs_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","43","Sna indhanamba hemba si mendekli suwera losang vivav, wo himba si di wewusowa owovav, nihsesowanahonam, wo besal indhanamba si Sesoana nemeltindiva avav. Sesoava si hemba woklamsna vewol vevav mindnam, ovra okomba. Yimba kana moamba hellelmba vitava, aong vivm keknam, ningvm beswonam. ");
INSERT INTO wrs_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Sesoana nemeltindiva os av, disumb, disumbna aralva disumbva pethamera singvekomandhana yukovnapenam. Henga mongnanam mongova indhanariniva di andra vevna, himba petha ona snewol vena, wo nongle no disumbm, ona, pai, kava kavm honamba diva amba velei. Doa himba henga poaita ambo hehla vre pethana, wo os gana deuvram indwonam. Di himba deuvrava hevna wohva indhanam moang vinvna, osm di nona dombvna, petham nonam kovovralm hevm, no disumbnamba, temba hevpa hehla vrenamba pethanamba. ");
INSERT INTO wrs_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","Eva mongmomba os lohv, Sesoana nemeltindiva snal lovahv, maim oi, bisnisandranindrini, himba bisnisandra vev nona, lelna nihna, os ningthiv peral. Himba dina sovawol vevpa, wo henga indhanam monglam daswolv, dim dombolm nonam hevm. ");
INSERT INTO wrs_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Doa himba nonglavna peralmba besalva, diva os lohmanav i. Himba ganamba, hevna wohva wohdombpiavnamba, indhanam daswolvna, dim nonam dombolm, osm himba no dina sovavav nomba peralva. Hev omnana no peralna aralm, kava nom vev peralm kavm, kam nisraho. ");
INSERT INTO wrs_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","Mongova olhmomba os lohv, Sesoana nemeltindiva snal av, maim oi, mendekli pohlalawonda tambkorini. Tambko velnindva piapovvra porava, doa tambkova snanovna snanovna diva os pilivhoa no wondarava. ");
INSERT INTO wrs_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Doa henanam tambkova pilivhoara, andranindva kololavrapulvo engallam tambkonahonam. Wo di engalla himba aevulthara, tambkom pepemowoli, vei besal tambko eva tambkokokla, no indhanamba doarava hlavnamoa. Besal tambkova himba sumbra sungowol vivna, tambkokoklava himba pinganga vivna ehallam. ");
INSERT INTO wrs_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","50","Memba honamba osm olhna, si os vevav, nonamba oviva pethaiva mueisowa evewolvrava. Sesoana ovsongolnind si bukethapravav, wo naengho vewol vivra Sesoatindimba, osmba he si indhanakoklamba vileivra indhanabesal hovriniva, wo suwe mendeklirava losang vivra. Himba si wewusowa owovra nihsesoanahonam. ");
INSERT INTO wrs_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","52","Yesusva no olhmomba ishopianamba, wo hev hevna aonghal mahalnindm unna, es hevpa yimba levrapivolvma hona kana moana plalva? Hev una, iya, hev unna, lehra, himba nomba levrapivolvpa Sesoana doaraminimomba, wo eva kana nemelmom hevm numha avramana vevrava, nom Sesoana nemeltindimom, himba nomba beswonam avav. Himba os avav, maim oi, innetna lohv hevna deuvra. Nonamba himba tihmba vevpa, himba mindnam innemba indhanamba dahwol vev, vei, doaramini inne, eva nemel inne. ");
INSERT INTO wrs_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Yesusva no olhmomba ishopieinnamba, ");
INSERT INTO wrs_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","wo doa os wohgana hevna kembellamba. Himba wonsihanamba sembayangduvra, hevna owalm di numhowol vevna hemba. Himba evekingil vithivna, an numha vrena Yesusmba, himba moamba besal wulluhv? An awothona, noinda himba andrava mendekliva vev, osva maim uv, Sesoa hevangas, es hevpa? ");
INSERT INTO wrs_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Himba ambo Yosepna ombol, andranindrini pirini. Hena avalva Maria av, wo hena towandaslalva os av, vei Yems, Yosep, Simon, Yutas, ");
INSERT INTO wrs_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","wo hena hamuskovolva men pimba mongawulm aevulv, es hevpa honamba Yesusva nonoramsnamba vevpa, honamba andrava memba vevpa? ");
INSERT INTO wrs_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","No indhanamba mindnam duus vinivna Yesusmba os i. Wo himba owai, undnahonamba hena moamba kek vithivnamoa. Yesus unna, Sesoana moashulnindriniva ishunvrava moa besalva puehalnindmba, himba hillivav. Wo heva os himba hevna kembelnindmba moamba isholmba vintava, himba os umnivav, manam pimba hillivav. ");
INSERT INTO wrs_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Yesusva ambo eskand mendekliandrava vena diva, indhanamba kolvrowolalmba, manara noinda himba keknamba undnahonamba lovahthamnavnamoa hemba. ");
INSERT INTO wrs_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","2","Herotva kuwul mendekli wulluhunvna Galili provinsnindna, Galiliva Yesusna provins. Himba hellena moakolm, ona, Yesusva mindnam mendekliandra vev, wo doa hev unna hevna andranindm, memba hona Yesusva, Yon Baptais tanamolnam. Kava helvakomandhana hemba nemetva, wo himba henga doa phona pokamariniva beswonam, wo noinda himba hona mendekliandrava vev nonapopol. ");
INSERT INTO wrs_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","5","Herotva doa doara nemet helvakomandhana Yon Baptaismba, hona moamba os. Yonmba mendah ishomnavna Herotmba, doa yimba sahokla vindana, yimba ungevliriniva pelvrana, ye pevna etepevna Pilipna ongalm pelvrana, hena nihilva Herotias. Memba yimba Sesoana lohohmom pilpikohav, wo noinda Herotmba mindnam wuspronamba, hevna valgonindm wohtna, wena ningu Yonm, wo buimera desvhueu. Herotva Yonmba helvakomandhalm vevna, heva os owai, himba henga pem vinvna indhananapenam, noinda indhanamba os ningvna, Yonmba Sesoana moashulnindrini, ata homeis kam hilvivm Yonnilm. ");
INSERT INTO wrs_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","7","Dawonam Herotva inne wonnevna, osm ona, honanam avamba kamba lengna nemetva nonam. Indhanamba mindnam kusona, Herotna innemba hlalmba Herotmongova, wo Herotiasna molva pronamba, di indhanahovra deisil vewol vevna, osm indkumbiva hemba os nunglutithueivra. Herotva hemba indk vethamnavna, wo omnana, kava yemba mana vemava wohvraohangas vevra, yimba kamba osahmanavrava. Herotva tanam nihnamolnam wohishomnavna. ");
INSERT INTO wrs_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","No ungevliriniva omnana Herotm, hevna nengavnangnamba owai, avalna nengavnangna Herotiasna. Omnana Herotm, yeoa wohtrava pevna valgonindm, angarava, Yon Baptaisna kuwul kuvhueira, wo pirinda kuvulambra, kava nonglalm vev. ");
INSERT INTO wrs_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Wo heva os Herotva duus vevna, wo mindnam nengavnang vevna, wo heva os henga hev nengna, kava doa mongawamolm ishomni hona ungevlirinimba indkumbina novra hona kana innerava, wo kava wohvevav hona kavna moamba. Ata kava os wohvevav, ten he kam wohosahmanim. ");
INSERT INTO wrs_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","11","Herotva hevna valgonindm ishunvna, yeoa ango buiduvram, dom Yon ten avm, wo kuwul kuvhueimnirava, wo ungevlirinim pirinda kuvulambmano, kovoreihu, wo os wohvina, wo himba venamba, hevna avalm kovoraohna. ");
INSERT INTO wrs_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Wo sism no Yontindiva ambanamba, os vindliangana ehallam, singvelmba. Yonmba singvepieinamba, hev anganamba, Yesusm ishumnina, ");
INSERT INTO wrs_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","wo Yesusva hellenamba, wo os wongana botra hevho indhanahuiram, hevhom wonalm. ");
INSERT INTO wrs_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Yesusva os wohgana botra, wo heva os doa deuvnindva hilli, wo noinda himba engvawulangavna pethamonam sis. Himba indakonda kotanind annind, annind, di mongawulm kusovna popethalla hesna, ata Yesusva os phovav huiva. Nonamba Yesusva botriniva holopevpa engallamba, himba indkumbim nongalvna. Himba und vewol vevna hemba, wo nomba ovna, men uvavulmungilva, nomba himba sishona vewol vevna. ");
INSERT INTO wrs_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Simba doa kilvrapiavna, wo hevna aonghal mahalnind ambanamba, umnina, Yesus, simba doa okilvrapiav, ata mani hlavav, pivva huiva memba innehui kembella aevulv. Yeoa hona indhanamoa monglamoa wolanga vungu veo no kembellam, no kembellam, innem sovawolalm hevm. ");
INSERT INTO wrs_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","18","Yesus unna hevna aonghal mahalnindm, owai, aevulvra hona indhanamba hui, ye deiswilu inneoa hemoa. Hevna aonghal mahalnind umnina Yesusm, pivva huiva innemba mindnamba ieivvmoa, ambo vei 5pelara rotiva, tambkokongla sambla. Yesus unna, kam dembrehu, wo os hev dembrehuna Yesusm. ");
INSERT INTO wrs_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Wo doa Yesus unna no indhanam, yeoa hui avhoapro ilsra, wo os wohvina. Yesusva no innepetava dombnamba, wo novvevongo ve, wo Sesoam omnana, lehra yimba besal, kam kolvrowol veo. Doa hev no roti popowol ve, wo hevna aonghal mahalnindm moang vinvna, unna, yeoa hona indhanamoa moang viwul vinvm. ");
INSERT INTO wrs_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Wo doa hevna aonghal mahalnindva osangas no indhanamba wohvinna, wo no indhanamba indkumbimba no innemba hlavnamba, venamba, wohpilivhoawol vevna. Wo no inne eunumbulva hevna aonghal mahalnind dumbvnamba, henga sungowol vivna, venamba, sumbva os lohna 12pelara, no inne eunumbulva songoihalohna. ");
INSERT INTO wrs_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Wo tendomba no innerava os mara lohnama 5000pelara, wo owai, ungevlitundismba es eva ata seivilta. ");
INSERT INTO wrs_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Henga Yesusva yinavana vewol ovovna hevna aonghal mahalnindm, lelnam yeoa saivo botra, wo henga ango dom mongnahalm plombpethallam, kava ata hui avav, hona indhanam wolanga velm hevna deuvram. ");
INSERT INTO wrs_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","24","Wo Yesusva os wohwolanga vungu vena no indhanamba deuvramba, wo hevpa os vongana oloramba hevho, Sesoamba sembayang venalmba. Doa himba di hevho sembayang vawovna, wo doa simba wohkilvravna. Nonamba hevna aonghal mahalnindva botva di plombhovmonam wulangavna, plombva wulainduwuvna botmba, noinda vuviva sahoklal provna nonamba. ");
INSERT INTO wrs_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","26","Doa simba hovrahovrava endvnamba, Yesusva hevna aonghal mahalnindindamba prunvna, wo himba plombsra sena provna monglana, wo hevna aonghal mahalnindva nunglivnamba hemba, himba mindnam pem vivna, uvna, sumbho, wo hemba eiswol vevna mindnam, kingesanga ovna. ");
INSERT INTO wrs_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","28","Nungi lelnam Yesusva hevmba ambara ovithinna os, memba ka, manam yimba pemba vivav. Pita omnana Yesusm, yimba tanamba Yesusva, yeoa kam omno, dom prolm yeindam, plombmonam prolm monglanam senam, os ye ten provm, kava ata os provav, mendekli. ");
INSERT INTO wrs_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","30","Yesus omnana, wouta pro, doa Pitava os botriniva pihanamba pora, wo sena gavna posra dom Yesusindam, wo himba nonglana, pai vuviva sahoklal vevna, wo doa himba pem vevna, wo plombmera os nokovhoana. Pitava Yesusm winevna, kam kolvro. ");
INSERT INTO wrs_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Wo nungi lelnam Yesusva holvorana hemba hevna englana, ata homeis yem nepola vevm, hev omnana, yimba kamba keknamba pevna undnahonamba lohmanavnamoa, manara? Manara yimba osva memba pemba vevna? ");
INSERT INTO wrs_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","33","Wo doa Pitai Yesusiva os henga esihohona botrava, wo doa no vuvikoklava wuleihavnamba, no indkumbiva hevna aonghal mahalnindva mulumbdandna Yesusmba eilungung venavna, tanamolnam yimba Sesoanangas ombol lohv. ");
INSERT INTO wrs_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","35","Mendah wongavna no botmera, doa di wonpho mongnahalm, wo botrini wonholope engallam Genesaret kembella. No Genesaret kembelnindva Yesusmba wohliheivna os, memba Yesus, doa himba moamba wulaindawul vevna osva indakonda kembellava diva, wo doa indkumbiva indhanamba wulprovna uvavulnindmba Yesusindava. ");
INSERT INTO wrs_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Doa Yesusva sishona vewol vevna uvavulnindmba, wo hev umnina Yesusm, ambo kava monglava ata kayenmulm yenam kekevra vrivra, os kamba wohkanandhawol vevra. Yesus unna, wouta viu, os ten pev uvm. Wo himba nomba kayenmulmba kevravnamba, wo henomba wohkanandhavna. ");
INSERT INTO wrs_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Mongla katekis eva Varisinind, himba nomba keknam engivna doaraminimomba, himba Yerusalem kotarini ambvna, Yesusm nonglalm. Hev umnina Yesusm, ");
INSERT INTO wrs_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","yetindiva himba kana simbehumunna lohohmomba enginvmoa. Himba hevna englava beswonamba poswol velvohvmoa, innemba hlalmba vevpa, osva memba pina lohohmomba luhunvpa simbehumunnamba. Elsus himba hona lohohmomba pilpikovolvohv, memba osva sahoklal. ");
INSERT INTO wrs_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","4","Yesus unna hemba, yimba pev indkokla viv Sesoana novrava, katindiva owai. Yimba kek vithiv pevna doaraminimomangasm, Sesoana moamba aongpa viv. Nemetva Sesoava os ona, yeoa pevna ararapevmoa hilwilvm, eva kolvrowol vivm hemoa. Sesoava osta ona, himba nomba araravalva moakoklanamba koasromb vivrava, mongla indhana henomoa snamoa wohhelvakomo vivra. ");
INSERT INTO wrs_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","7","Sesoava os unvna indhanamba, heva os yimba indhanamba ishunvna, mongova indhanariniva osva hevna araravalmba osva untava, kava Sesoam diandra venav, yemba kolvralmba owai, temba no indhanariniva lehra vev, eva himba owai vevta, hevna araravalmba kolvrowolalmba. Yena moamba mindnam phunv vavawonam, pilpiapahalm Sesoana doaraminimom, manara, yimba owai, tanamba lovahthamnavmoa Sesoamba pevna undnahonamba, ambo dasalm ambara tovolla. Yimba tanam wohengiv doaraminimomba, Aisaia moashulnindrinina moamba, men os novol velohv, ");
INSERT INTO wrs_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","9","Sesoava os ona, hona indhanamba kamba wiviv hevna mobesalna, heva os ambo dasalm tovolla moanamba eishov. Hevna undnahonamba, owai, himba kamba lovahthamnavmoa, wo hena sembayangmba ambo sena seposam dasalm vivna. Himba indhanamba owalmba hevna nengavnangna numhowol vivna. Honamba Sesoava os ona, himba osva memba dasalm viv. ");
INSERT INTO wrs_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","11","Yesusva ishupieinnamba Varisinindmba, wo henga hev unna indkumbim indhanam, yeoa hom ambvm murapetam, wo kana olhmom hillivm, wo eva beswonam keknam ningvm. Mana vemava indhanariniva nevrava, manapenam, manara osm Sesoava hemba sahonamba nongalvavmoa no indhanamba. Wo heva os moakoklava indhanariniva ishotava hevna mindenamba, noindangas Sesoava si osva ovav, yenamba indkoklava luhunv. Manara noinda mindemba kolmal dombv undrini. ");
INSERT INTO wrs_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","13","Henga Yesustindi ambanamba, umnina Yesusm, no Varisinindva himba mindnam ahalakowolvna hona yena moarava. Yesusva olhmona unvna hevna aonghal mahalnindm, kana arana osorava innemba besal lohv, si yunalm wohlohvav, manara hev wolana. Ilkoklava nomba phovrava, hev si velaihanga vevra plalnahonam. ");
INSERT INTO wrs_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Manam yimba duus vinvav no hena daosmomba, himba snal vilov, oi novtitmungil. Wo mongova novtitmungilva untava owalmba novtitmungilmba, kava beswonam yemba deis vungavra, wo hesamblava si noinda eplapewolvav potandarava. ");
INSERT INTO wrs_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Pita omnana Yesusm, kam ishunu no olhmona plalm, nom mengmerinim. ");
INSERT INTO wrs_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Yesus omnana Pitam, eva yimba snama mongla indhana, ten he titnam avm? ");
INSERT INTO wrs_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Mani inne hlav indhanamba, emera pilivhoa, wo henga eva ekokolm aiahav, undrava sihavmoa. ");
INSERT INTO wrs_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Wo heva os no moamba indhanariniva mengnamba ishovpa, nomba undmeriniangas phov. Henamba undva nihvuhinnamba lohtava, wo eva no indhanariniva nihvuhinnata Sesoana novrava. ");
INSERT INTO wrs_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","20","Mindnam phunv indkoklava indhanana undmeriniva, men os himba viv, nengavnangkoklana viv, indhanam helvakomo viv, ongariskui vulangav, tlatrinim ungevlim pelvrombol vulangav, yukov viv, dasalm ishumniv duangm, eva moalusna ishunv owalm. Memba honamba sahoklal Sesoana novrava. Wo heva os himba nomba innemba nisva nevrava, temba himba nomba owai, sahonamba vevmoa Sesoana novrava. ");
INSERT INTO wrs_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","22","Yesusva nominiva venamba, os gana Yutanindna meisnindna petharam, dom ten Tair kota eva Saiton kota elohvnam. Yesusva himba hevho wongavna hevna aonghal mahalnindmangas, numhowolalm. Doa mongo ungevlirini no kembellini pro Yesusindam, no ungevliriniva Kenan tindiriniongo. No ungevliriniva pronamba, dandwonam Yesusm omnana, mendekli, yimba Devit kuwultindirini lohv, kam wavra vovhoamno, wo kana mom sishona vro. Nemet doara heva tihsongo nonglanamba, wo noinda himba uvavulmungil dihelv. ");
INSERT INTO wrs_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","24","Yesusva hemba opla vramnanamoa, wo hevna aonghal mahalnind umnina, wolaihango no ungevlirinimoa, pimba mendah wohengalomana ovov, wunuhona. Yesus omnana no ungevlirinim, Sesoa kamba wolaihaprana hona petharamba Israelnindmangas, himba snal aevulv, maim oi, sipsip aralhui, ten doa hoai vilonam. ");
INSERT INTO wrs_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","27","Wo heva os no ungevliriniva wohgavnamoa, hev pronamba, Yesusna monglara mulumbdandna lohvhoamna, mendekli, kam kolvro. Doa Yesusva hemba olhmona omnavna, memba osva sahoklal, kava innemba dembhanga vetava otolnaminiva, wo windem daswolvra. Wo ungevlirini henga olhmona omnavna, lehra, yimba tanam ishov, heva os innesleholva dalv, nomba araravalva hlavpa, windemba nongas sleholangas hlav. ");
INSERT INTO wrs_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Yesusva indk vethavna, wo omnana hemba, lehra, daipotava kava yemba lihav, yimba kamba keknam wohamnav pevna undnahonam. Kava ata vevav, memba yimba kamba osahmanavpa, wo doa os hena molva wohlesvhoana. ");
INSERT INTO wrs_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","30","Yesusva nominiva venamba, wo Galiliplomb pethalmonam gavna, wo himba oloram vongana, ambo di avna. Indkumbi indhanamba provna Yesusindamba domba, wo nomba indhanamba himba mindnam nihkoklana wulprovna. Monglava snal, es eva ata sikih vivta, owai, monglava snal, es eva ata lovahmana vevta, monglava novtitmungil, monglava moahui, moamba ishuvnamoa, wo monglava indkumbiva wavranind. Indhanamba mendah wulprovna no nihkoklanamba, wo Yesusinda di velahakavna murapeta, os Yesusva nongalvra hemba. Wo Yesusva os sishona vewol vevna, wo os hemba henga wohkanandhawol vevna. ");
INSERT INTO wrs_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Indhanamba nomba nunglivnamba, uvna, pai pai pai no indhanamba nemetva himba moamba ishuvnamoa, wo heva os himba henga men daipota beswonam ishuv moamba. No indhanamba temba seilva sikih vemba owai vivnamba, himba henga beswonam lovahmana vev. No indhanamba nemetva temba lovahmanamba owai vevnamba, daipotava doa henga himba beswonam lovahmana vev. No indhanamba temba seilmba novtit vivnamba, daipotava doa henga beswonam novviv. Pioa Sesoam okolalohra, pioa Israelnindoa sembayang velvohmanara Sesoam, himba keknamangas wohav. ");
INSERT INTO wrs_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Yesusva hevtindim unna, hom ambo, kam hillu, kamba wavra venav hona indhanamba, samblamongonin himba doa huiva pimongova vina, wo hena innemba doa huti vina, ata mani himba hlavav? Kava hemba posalva pondava wolanga vetava, ata homeis mongom vetakolavm monara ponnahonam. ");
INSERT INTO wrs_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Hevna aonghal mahalnind umnina, hi ata pimba innemba dumbvav, hemba dahwol velmba, osva verava, pilivhoawol vera? Huiva deuvpa mongova murava lohvmoa. ");
INSERT INTO wrs_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","36","Yesus unna hevna aonghal mahalnindm, es yimba rotiva iambei? Hev umnina, 7pelara rotiva, eva tambkokongla mongla eusil ambo. Wo doa Yesus unna no indhanam, avhoapro pethasra beswonam. Doa hev no 7pelara roti eva tambkokongla hevtindimini dumbunnamba, doa Sesoam nehvongo ovomnana, Sesoa yimba lehra. Hev popowol venamba eskand eskand, daswolvna hevna aonghal mahalnindm, unna, moang viwul vinu hona indhanam, hlalm. ");
INSERT INTO wrs_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Hevna aonghal mahalnindva os wohvina, wo doa hev hlanamba, pilivhoawol vuku ve, wo innemba eunumbulva ambo wohlohna, sumbva 7pelara hengava os sungowol vina. ");
INSERT INTO wrs_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","No indhanamba himba os hlana, 4000pelara tendomba, ungevlitundisva owai, seivilvmoa. ");
INSERT INTO wrs_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Wo doa Yesus unna no indhanam, hona innekra angawul veo pevindamoa. Yesusva hevna aonghal mahalnindm botra wonsihanamba, plombmonam os wongana Makatan petharam. ");
INSERT INTO wrs_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Mongla Varisinind eva Satusinind ambanamba Yesusindam, himba doara hevmba ishunna mongawulm, una, pioa ambo dasalm osahal vohmanara Yesusm. Doa hev umnina Yesusm, mendekliandra vinu kana novra, kav vei, nonglalm viv, eva lihalm viv, osva yimba Sesoanapopol vev. ");
INSERT INTO wrs_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","3","Yesus unna hemba, owai, yimba pevna undnahonamba kamba ningminivmoa keknamba, yimba ambo kamba dasalm osihminiv. Honamba mana vemava hona pethariniva, yimba nonora av, wo heva os kana nemelmomba yimba beswonamba liheivmoa. Okomba vohanamba yimba nungliv, ovpa aembul lohv, simerava besal lohvav. Simekumbrava yimba os uv, ovpa aembul, eva teko ningev, ata po hasvovav, wo eva vuvi vevav detiva. Yimba pev nonora vilov tekomba, wo heva os kana nemelmomba, Sesoana nemeltindimomba yimba wohtitviv. ");
INSERT INTO wrs_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Yimba sahoklal indhana, snal ungevlirini tlalnamini veiva, mongom indhanarinim pelvilkoho. Yimba ambo kamba dasalm osihminivna, tanamba owai. Yimba si nunglivav mana vemamba mendekliva Sesoanaminiva, kamba si phomnavav. Hona mana vemava mendekliva, nomba temba Sesoana moashulnindrinimba Yonamba venanamba nemetva, eva si os kamba venavavta, wo si os yimba nunglivav. Wo doa Yesusva os dashalahangana hemba, wo os wohgana. ");
INSERT INTO wrs_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","6","Yesusva hevna aonghal mahalnindmba os wongana botra plombmonam, wo himba maivithina, innemba iambalmba. Doa mongnahalm wonphovna, wo Yesusva unna hemba, yeoa beswonam eivvm, no Varisinind eva Satusinindna, yimba manam hleinvav hena rotiva, aembu. ");
INSERT INTO wrs_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Doa hevna aonghal mahalnindva no moamba hillinamba, wo doa hevm asahmana ungu vevna, Yesusva rotim ov. Pivva rotiva maikumi viva, iambalmba homba, noinda osva Yesusva ishov, wo mendah hevna aonghal mahalnindva wohishuvna. ");
INSERT INTO wrs_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","9","Yesusva helwolnamba, unna, wuleihu innehuimomoa, yimba kamba undnahonamba ningminivrava pevna undnahonamba, yimba osva ningvavmoa innemba. Yimba levrapivolnama kana mendekliandramba? Yimba maivithinama, kava rotiva 5pelara popowol vinvnamba, dahwol velmba 5000pelarava indhanamba? Wo sismba nonamba es yimba innemungilva sumbrava sungowol vina? ");
INSERT INTO wrs_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Wo henga kava 7pelara rotiva popowol vinna 4000pelara indhanamba, wo os dahwol vena, wo sismba no innemungilva es yimba sungowol vina sumbrava? Kam ishumnu. ");
INSERT INTO wrs_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","12","Kava ambo yemba os unv, aembu, manam yimba rotiva hleinvav Varisinindna eva Satusinindnamba. Yimba nonora avma, kava yemba rotimba ishunvmoa, wo doa os himba levrapivolna, una, Yesusva pimba olhmona unv, himba innemba ishovmoa, himba pim ishunv, manam yimba hilwilinvav Varisina eva Satusinindna moamba, temba sahoklal. ");
INSERT INTO wrs_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Yesusva wongavna hevna aonghal mahalnindm monam, wo venamba, di wonphona pethara, os sevriv Sisaria Pilipai. Di himba hevna aonghal mahalnindmba osva osihinna, es hevpa indhanamba kamba doarava sevra ovriv, an hevpa kava? ");
INSERT INTO wrs_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Hev umnina Yesusm, monglava indhanamba yemba os umniv, yimba Yon Baptais, nemet ten dahanam, wo himba henga beswonam phona. Monglava indhanamba os uvna, yimba moashulnindrini Elaita, nemet ten anam, himba henga doa beswonam phona. Monglava indhanamba os uvna, yimba moashulnindrini Yeremaia doaramini, a mongo Sesoana moashulnindrini doaramini. ");
INSERT INTO wrs_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","16","Doa Yesus unna hevna aonghal mahalnindm, an yeriniva nengv, osva an kava? Pita ophona, yimba Kristus, yimba tanam Sesoana ombolnonoa, wo hev yemba opusvundthona Kristus maimba, hevpa ambo wohav hev. ");
INSERT INTO wrs_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Yesus omnana Pitam, lehra, Yonana ombol yimba lehra lohv. Yimba indhanapolmoava levrapieimoa osva, owai, kana ara senamini he yemba indthoamni, wo yimba os kamba levrapiei, an hevpa himba. ");
INSERT INTO wrs_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Yimba Pita, memba osm hon, wo hona honsra kava si kavtindiva mongawulm moakot vevav, nomba kamba keknamba ningminivrava. Himba si keknamangas wohlovahvav deuvmsna honsra, wo suwekembelnindva hevnapopolva si katindimba engilpingivavmoa. ");
INSERT INTO wrs_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","20","Kava si kiva yem nisrahovav, yimba tuvpa nonamba velaihavrava, indhanamba si os saivra Sesoana nemeltindilm, eva kava henga yemba mendekli moamba vraohv. Mana vemava yimba ovinvrava indhanamba hona petharava, manam osva yimba vivav, Sesoava si os ovav, lehra ov. Nomba mana vemava yimba unvrava indhanamba hona petharava, os viu, Sesoava si os ovav, lehra ov. Wo doa Yesusva hevna aonghal mahalnindm indkumbim keknam ongawolna os, manam yimba ishuwul vevav hona moamba muserava, osva himba Kristus lohv. ");
INSERT INTO wrs_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Doa Yesusva hevna aonghal mahalnindm ishunvna hevna kinwondamom seilnovra nonam, himba si wohvevav. Ona, kava gavav henga si Yerusalemram, wo di mundilva, kuwulva sembayang andranindnamba, eva katekisva si os kamba himba moangakalanamba osihivra, wo kamba kinwonda opluthumnivra. Wo manara, no moara ambo indhanamba si kamba helvakomandhivav. Wo kava si pokamarava samblamongonin vevav, wo henga si kava phovav beswonam kavna nihna. ");
INSERT INTO wrs_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Wo heva os Pitava no moamba hellevnamba, hemba indkokla venavna, himba venamba, Yesusm dawonam ehallapetam wainga, wo mindnam vevandwonam omnana, owai, hona kinwondava yemba plothumnivavmoa, Sesoa yemba kolvravav. ");
INSERT INTO wrs_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Doa Yesusva imharavhoanamba, omnana Pitam, wuleiho, manam yimba monamba kanamba hiluvla ovravav Setanmsnamba, monamba memba Sesoa kamba indthoamnana, enggalmba. Yimba os nengvna, ten ombandhana ningvm, wo yimba Sesoana nengavnangva nengvmoa. ");
INSERT INTO wrs_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Doa Yesus hevna aonghal mahalnindm indkumbim unna, yimba himba nomba yeriniva kamba pethalmba venavrava, henooa hevna nengavnangmoa wuleihavra, os pungavra hevna kruseva, os men ka pungavm kavnam. ");
INSERT INTO wrs_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Wo heva os himba nomba hevna nengavnangmba engvrava, owai, henomba si wohpelpevav yunalm, hemba si wohmueisowa vevav undnahonam. Wo himba nomba yeriniva wuleihavrava hevna nengavnangva, wo kana nengavnangmangas wohengvrava, himba nomba si yunalm wohavav beswonam. ");
INSERT INTO wrs_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Monglava indhanamba hevna nengavnangva engivrava, himba innetnamba wohtowondva museriniva lovahvrava, wo es hevpa yunalm himba si lovahvavma? Owai, hemba si wohmueisowa vilovav yunalm. Wo es hevpa himba si dina suveivavma hevna monamba hengava, owai, hemba si mueisowa vilovav. ");
INSERT INTO wrs_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Kava si provav henga sewonam hona petharamba. Kava arana ombol lohv, wo kava si arana mendeklimomba wonwulprovav hevna ovsongolnindm. Os si kava lesvhoawol vevav indhanamba, wo indakonda esesmba vinvra indhanamba, nona hui ten hev pethara avnam, sahoklalna eva besalna. ");
INSERT INTO wrs_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Hillu, monglava memba yimba aevulvpa huiva, si yimba mendah aevulvra, wo yimba si kamba nunglivav, nonamba kava provrava hengava, wo os einvra indkumbina indhanana kuwulalm. ");
INSERT INTO wrs_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Simba 6pelara vinamba, sismba Yesusva hevna aonghal mahalnindm samblamongom wonvongavna olo anavlasallam. Yesusva nom wongana Pitam, Yemsm eva Yonm, wo himba di aevulvna Yesusmongo. ");
INSERT INTO wrs_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Hena novra Yesusna nihva indatovpa selthueinna, wo hevna novlomosva okombamsna lovhueinvna, wo hevna kayenmba dombakakalangas vewol velohmanavna. ");
INSERT INTO wrs_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Doaramini moashulnindrini sambla, nemet ten endahawolnam, himba ephonamba, Yesusm wai ihisholohv Mosesi Elaitai. ");
INSERT INTO wrs_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Doa Pita omnana Yesus mendeklim, memba hevm pimba lehra huiva aevulv. Ata kava samblamong deuvpa vewol vevav huiva, mongova pevm, mongova Mosesm, mongova Elaitam, osm yimba noinda aevulvra, yimba osva nengtava. ");
INSERT INTO wrs_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Pitava mendah ishovna, wo henanam teko hena novpa sowaivmanavna, wo os wohmera vena, wo himba moam hillivna, no tekomerini phovna, hem ishunvna, memba kana ombolnonoa, kava mindnam und wohvev, yeoa yunalm helluvmona venavm hena moamoa. ");
INSERT INTO wrs_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","No samblamongo indhanamba no moamba hillivnamba, os vendral vena kusis petharam, himba mindnam pem viwul vevna. ");
INSERT INTO wrs_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Yesus pronamba, wolapho vevna englana, pulvo, pepehmoa wuleihu. ");
INSERT INTO wrs_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Wo himba nov pevhoawol vivnamba, nov viwul vevna, pai, Yesusangas memba lohv. ");
INSERT INTO wrs_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Doa henga Yesusva wonopihavna olorini, hev unna, manam mongomba ishumnivav, nomba yimba temba nungliva, sewonam heva, nonam kav phovram henga beswonam pokamarini, os ishunu indhanamoa. ");
INSERT INTO wrs_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Wo hev no samblamong indhana umnina Yesusm, katekisva os isholvohinv indhanamba, Elaitava moashulnindriniva, nemetva temba lohnamba, himba si hesna provav henga hona petharamba, wo Kristusva si sis pethamnavav. Es hevpa memba tanamma? ");
INSERT INTO wrs_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","13","Doa Yesus unna, katekisva tanam ishuv, Elaitamsna si provav, manam manam manam kokolma vewolalm, osm Kristusva sis si provav. Heva os Elaitamsna doa prona henga hona petharamba. Heva os pethanindva hemba liheivnamoa, owai, himba indkokla vrivna sahonam, wo eva kamba osta si indhanamba vinivra. Wo doa no Yesustindiva samblamongova os levrapivolna no olhmomba, Yesusva Yon Baptaism onngamnavna. ");
INSERT INTO wrs_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","16","Yesusva no samblamong indhanamba hevna aonghal mahalnindmba di henga wonphona, indkumbi di avnam, wo mongo indhanarini pronamba, mulumbdandna lohvhoamna Yesusm, mendekli, kolvro kana ombm, hemba mindnam eisomana vev. Hemba elsus vendpaomana vev, os vev suwera eva pora. Kava waiprona yena aonghal mahalnindindamba yenisra, kavna ombmba sishona vrelmba, wo himba lihvna, heva os owai. ");
INSERT INTO wrs_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Doa Yesus unna muskonam no indhanam, ten kusovnam, yimba hona indhanamba keknamba Sesoamba lovahthamnavmoa, osmba si himba yemba kolvrowol vevra. Yimba indhanakokla, wo kana aonghal mahalnindva lihvna, wo heva os owai. Kamba doara gimus vovhoana. Hom waiambo no tuendisrinim kaindam. ");
INSERT INTO wrs_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Hev waiambe Yesusindam, wo Yesus dandwonam omnana nom tihsongom, di nihmera amnavnam, omnana, wuleihalahangao, wo no tihsongova os no tuendisrinimba pewolehalahangana, wo no tuendisrinimba os wohkanandhana nungi lelnam. ");
INSERT INTO wrs_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Sism hevna aonghal mahalnindva ambvna hevho Yesusindam, mongova diva anamoa, hev umnina Yesusm, kava lihvna, tihsongomba pewoleihalmba no tuendisrinimba, heva os kava lehleh vi, manara? ");
INSERT INTO wrs_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","21","Yesus unna, yimba keknamba pevna undnahonamba Sesoamba lovahmanavmoa, tanam himba si wohengvapiangavav no tihsongova no tuendisrinina nihmeriniva. Yimba Sesoamba pevna undnahonamba lovahthamnavrava, wo yimba mendekliandrava vivra, wo plel vevavmoa. Eva eskandva yimba Sesoamba lovahalmba vinivra, oi, sahaikw, sna indna, yimba olomba mendeklimba os umnivav, yeoa huioa wuleiho, dom gao, di loho, wo olomba os wohvevav. ");
INSERT INTO wrs_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","23","Yesusva hevna aonghal mahalnindmba wonavna Galili provinsra. Hev unna, indhanamba si kamba holvorehunvav indhanakoklana englisra, wo himba si kamba helvakomandhivav. Wo samblamongonin si kava vevav pokamarava, wo si os kava henga phovav beswonam kavna nihna. Hevna aonghal mahalnindnamba undva potra pihaprinvna. ");
INSERT INTO wrs_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Yesustindiva di eivvna Kapaniam kotara, wo di taeksnindva diva dumbvna sembayangdam, henona henona, temba nomba Yutanindna wevsava os luhunvna. Hev ambanamba, Pitam umnina, es hevpa Yesusva ata kamba moang vinvavma, ora owai? ");
INSERT INTO wrs_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Pita unna, Yesusva ata yemba moang vinvavta. Sism Pitava Yesusi ahavna deuvmera, wo Pitava nom nengvna, ata Yesusva daswolvmi owaimi? Wo heva os Yesusva doara nonora lohmanavna Pitana nengavnangmba, wo omnana, Simon, es yimba nengv, duangva anmundm sahowol vivra taeks dimba? Es hevpa, himba hevna ombolm sahowol vivavma, ora himba kembelnindm sahowol vivra? ");
INSERT INTO wrs_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Pita omnana Yesusm, duangva sahowol vev taeks dimba kembelnindm, hevna towandalmba owai. Yesus omnana Pitam, pivva eva Sesoanamba ombolta, wo noinda osva manam eva pimba deiswilvav no taeksmba tempelliniva. ");
INSERT INTO wrs_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Wo heva os manam yimba osva unvav hemba, osva himba ata homeis pina moamba hillinvavmoa. Ata pimba ambo deiswilvav hemba. Yeoa komalaoa vrarava, wo guao, plombra piapihao di. Ata tambkova nukhoavav, wo yeoa os vrao no tambkooa, wo mengm tenglawolmano. Ata yimba di nonglavav senmba. No senoa velavrarava, nom sembayang dinindm velareihunu, kalm eva pevelm, hem dembrahunilm. Wo doa Pitava os wohvena. ");
INSERT INTO wrs_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Yesusna aonghal mahalnind ambanamba, hev umnina Yesusm, Sesoana nemeltindi indhanana, an henamba mendekliva wulluhunv? ");
INSERT INTO wrs_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Yesusva nom moam helle, wo hev omnana otollinim, prorava, hui lohvhoao, ");
INSERT INTO wrs_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","wo Yesusva no otollinim kevra wulluhvna, wo hev unna hevna aonghal mahalnindm, yimba himba nomba sihalmba vevrava Sesoana nemeltindilmba, boasna himba nomba wuleihavav hevna nengavnangva, wo kana nemeltindilmba os sihavav. Himba nomba snal, ora, otollini, himba hevmba wohwuleihamnav Sesoam. ");
INSERT INTO wrs_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Indhanariniva himba nomba wuleihavrava hevna nengavnangva, wo kana moam kek vethavrava, osva hona otolliniva memba, wo henongas si mendeklilmba lohvav Sesoana nemeltindirava. ");
INSERT INTO wrs_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Indhanariniva himba nomba sehmoa ovravrava otollinimba katindirinimba, osva memba honamba, himba katindirini, wo no indhanariniva temba kam sehmoa ovrav nonamba. ");
INSERT INTO wrs_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Indhanariniva himba nomba moangakala ovravrava katindirinimba, wo no katindiriniva indkokla ve, wo kava os omnavav no indhanarinimba, wavra, himba si hukum vravav, himba si os ovav, doara kamoa dahata, wo kava owai veta, hona otolmba moangakala ovralmba. ");
INSERT INTO wrs_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Kava os unv, wavro, hona pethanindmba, himba katindimba newondmoa owol velvohv, osm heoa noinda indkokla vira. No indhanamba hona pethariniva, himba hona petharinim wevsam engiv. Wo heva os himba si kinwondangas nengas sveivav noindava, himba temba vilenginvpa katindimba. ");
INSERT INTO wrs_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Yesusva mendah ishunvna hevna aonghal mahalnindmba, yimba indkoklava vivrava pevna englamonglanamba, koaihanga viu, osm yimba hengava osva indkoklava vivavmoa. Wo osva yimba Sesoatindilmba mongawa englanaka, mongawa monglanaka avav. Heva os owai, si himba yemba pilpiapahavavmoa englamonglanahonam suwekoklarava, diva yunalm tawov, vuthoahui vev no suwemba. ");
INSERT INTO wrs_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Yimba pevna novnamba indkoklava vivrava, mongnahaloa velarombol viu, velaihanga vivm, wo os yimba avav si Sesoatindilmba mongawa novnamba, heva os owai, himba si yemba pingipiha vevavmoa samblanovnamba suwekoklarava, nomba temba wohtawovpa, vuthoahui vev. ");
INSERT INTO wrs_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","11","Nomba otolmba eusilmba manam yimba indkokla vewol vivav hemba, owai, aembu, noinda Sesoava doa sandhana hevna ovsongolnindmba, hemba kekalvho vrinilmba elsusmba. Himba di aevulv, ten Sesoa kana aral avm sena. ");
INSERT INTO wrs_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","14","Sesoava indk vethav, nonamba indhanamba wuleihivpa monakoklamba, wo Sesoana monam engiv. Es yimba ningv, deuvnindriniva sipsippa osva wonatava 100pelarava, wo mongova sipsipmba nomba hoai vevav, wo es hevpa no sipsipna aralva vevav? Himba 99pelara wolalahangavav ilmusrava, nom silelguavra, ten hoai venanam. Nonamba himba suwiharava, himba henga indk vethavav, himba espeta ambo ninginvav nomba sipsipmba 99pelarava, himba beswonam lovahv. Aralva nomangas indk vethamnavav, ten nemet hoai venam. Wo Sesoava yena aralva senamba, himba snal, himba ovov, osmba henamba otolva hetindiriniva mongova osva hoai vevavmoa henaminiva, owai. ");
INSERT INTO wrs_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","Yemba pevna mongawa Kristusnindriniva sahokla vretava, yeoa garava heindam, omno, yimba kamba indkokla vrena, pioa sishona evevrei, ambo pivho yengas, kangas. Wo himba yena moamba helletava, yimba temba hena undm sishona vremnav osva. ");
INSERT INTO wrs_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Wo heva os himba yena moamba aongpa vetava, gao, henga mongom onkeinu mongawa indhanamka samblaindhanamka Kristusnindrinim, hellelm yem, nom ten yem sahokla vrenam. Nomba Sesoana moamba os novol velohv, Yemba mongova osva omnatava, yimba doa indkokla vindai, wo sambla indhanaka, samblamong indhanaka, heoa osva aevvrata, wo hillivra nomba moamba. ");
INSERT INTO wrs_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Wo no indhanariniva yena moamba hellemba owai wohvevrava, yeoa indkumbim Kristusnindm ishunu, osm himba sishona vrivav hemba. Wo no indhanariniva osangasva hellemba indkumbinamba Kristusnindnamba owai vinvrava, wo os hemoa wohwolaihapulvo ambalnindilm, yimba kamba petheinvnamoa, Sesoamba pevna undnahonamba lovahthamnalmba, yimba os vevna, ovna, puehalnindrini. ");
INSERT INTO wrs_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Nomba mana vemava yimba osva indhanamba unvrava, manam yimba osva vivav, wo nomba mana vemava Sesoava senaminiva himba si indhanamba os unvav osva, manam yimba vivav. Wo nomba mana vemava yimba indhanamba ishunvrava osva, noi viu, wo eva nomba mana vemava, Sesoava senaminiva himba si indhanamba os unvav, noi viu. ");
INSERT INTO wrs_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Wo eva yimba katindirini samblava mana vemava mongawa indnamba enengtava, wo Sesoam ohosahmanavra, kam honi os vinu. Wo Sesoava os hemba wohvinvav. Himba ara senamininonoa. ");
INSERT INTO wrs_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Nonamba yimba katindiva mongawulm kusovrava, yimba temba katindi, eva sambla indhanaka samblamong indhanaka, wo eva si kava prorava, di hemba wonavra. ");
INSERT INTO wrs_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Pita pronamba Yesusindam, wo hev omnana, mendekli, kana mongawa Kristusnindriniva kamba elsusva sahokla vrowotava, es hevpa kava elsus maivethomana venavavma, os hona engla thera, mongo tovhoawolla? ");
INSERT INTO wrs_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Yesus omnana Pitam, owai osva, yeoa maivethomana vinu hena sahoklamoa osangas. ");
INSERT INTO wrs_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Hillu, Sesoana nemeltindi snal av, kuwulva avna mindnam andranindnahonam, himba hena dim kekalvho vrimnivna. Henga hev ona, kava isholm vinv no andranindm, osm himba kanamba diva, nemetva dumbnamba bisnisandra velmba nonamba, kaindam henga iamb vera. ");
INSERT INTO wrs_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Seilva nom andranindrinim waiambmanana, no indhanariniva himba seilva kuwulna diva dawonam ondombnam. ");
INSERT INTO wrs_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Hev omnana no kuwulm, kanamba diva huti vev, kavnamba melmba ehlathalmba. Wo no kuwul omnana, kava si yemba holvorahunvav mongla indhanana englara dinasvom, wo os kav diva dombvav kavmba. Eva yena ongatowondpevm, wohm kava si indhanam moang vinvrava, wo diva kavm dombvra, nemetva kava yemba esvema milion kina dembrahonamba. ");
INSERT INTO wrs_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Doa no indhanariniva venamba, pethara vendpe kuwulna novlomossis, hev omnana, kam wavra vovhoamno, wo kam englamomoa omno, kavnamba melmba ehlathalmba, kava si yemba wohvenavav henga. ");
INSERT INTO wrs_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Wo kuwulva wavra vovhoamnanamba, wo omnana, yenamba melva kava doa daipota men maivethav, yimba kamba dembrahovavmoa esesmba, beswonam gao. ");
INSERT INTO wrs_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Wo no indhanariniva venamba nominiva, monam os gavna, himba andranindrinimba owalmba os anongla evena di, himba nomba doara kina 5pelara snapolmoa nemnanam, hev dandwonam okivrana, kam di dembraho lelnam, nemetva yimba kanamba 5 kinava nenamba, henga esesm kam veno. ");
INSERT INTO wrs_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","No indhanariniva mulumbdandna lohvhoamnanamba, wo omnana, kam wavra vovhoamno, kam dawonam ambo englamomoa omno, kav si os kavna melmba ehlathavav. ");
INSERT INTO wrs_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Wo heva os no andranindriniva hemba wavra vovhoamnavnamoa, owai. Himba polisim wetat unvna, osm buimera hemba wolaihasuvvav, wo himba di dawonam avra buira, verava, kam wohvepiamnara. ");
INSERT INTO wrs_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Mongla andranind kuwulna himba nom moam hillinamba, wo himba mindnam duus vivna, mindnam eishovna, wo anganamba, kuwulm ishumne, una, yena andranindriniva os vei. ");
INSERT INTO wrs_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Wo kuwulmba mindnam wusprovna, wo ona, no andranindrini hom kaindam prora. Nonamba himba pronamba, kuwul omnana, yimba andranindrini sahoklal lohv. ");
INSERT INTO wrs_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Nemetva yimba kamba osahmanana, wavra vrelm, wo kav ehlathana mendekliva melva yenamba. Wo heva os owai, yimba wavra vovhoamnanamoa pevna mongawa andranindrinimba. ");
INSERT INTO wrs_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Yeoa buira wohao, verava, pevna melmoa wohehlatho, yimba temba kaindava venanamba. Yimba buira av, diva si yunalm kin yemba yuhulu wulavav buimerava. ");
INSERT INTO wrs_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Doa Yesusva mendah ishunvna hevna aonghal mahalnindmba, kana ara senaminiva si yemba buiva vewol vevra osta, yimba maivethalmba owai vintava pevna mongawa Kristusnindnamba, nomba temba yemba indkokla vewol vivpa. ");
INSERT INTO wrs_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","2","Yesusva moamba ishupieinnamba indhanamba, wo os gana Galili provinsriniva Yutia provinsram, Yotan popethalmba nohalm. Indhanamba diva mindnam kusovna Yesusindava, moam hellemnalm henam. Himba nom sishona vewol vevna uvavulnindm. ");
INSERT INTO wrs_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Mongla Varisinind ambanamba Yesusindam, wo dasalm ambo osihminivna. Hev umnina, tendoriniva himba nomba hevna ongalmba wohpelvpingallava moahui, Sesoana lohohmomba es novol velohv? Es yimba nengv? ");
INSERT INTO wrs_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","5","Yesus unna, os kava nengv, yimba doa maivithina moamba nomba temba novol velohvpa, Sesoava seilva indhanamba vevnamba, himba tendorinim ungevlirinim vewolna, wo Sesoava osva os ona, tendoriniva si os wuleihawol vevav hevna araravalmba deuvmba, wo himba hevna ongalmangas waiavra, wo nonamba himba doa os enilhawolei mongawanihna, samblava owai. ");
INSERT INTO wrs_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Yesusva mendah ishunvna Varisinindm, yimba no moana plalmba levrapivolvmoa, tendorini ungevlirini indakonda nihnamba himba owai. Sesoava doa doara os ona, mongawanihna, wo noinda osva pimba hengava popowol vivavmoa indakondava. Tendoriniva hevna ongalmba wohengvapiangavavmoa owai. ");
INSERT INTO wrs_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Wo henga no Varisinind umnina Yesusm, Mosesva doara doa ovonamoa honamba, tendoriniva hevna ongalmba engvapiangalmba. Moses ona, tendorini tombai novol verava, ongalmomba engvalmba, wo vraohra nomba tombaiva, wo osva wolaihangavra nonahonamba. Manara osva Mosesva ona? ");
INSERT INTO wrs_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","9","Yesus unna, yena simbehumunpevpa kelsombovho vinvna, himba Sesoana moamba engivnamoa, wo noinda no moamba Mosesva osva ishunvna. Memba Sesoana nengavnangva owai seilva, owai, ka ishunv yem, tendoriniva hevna seilminimba engvavrava, henga mongo vravra, himba sahokla vev Sesoana novrava. Sesoava si os omnavav hemba, himba indkokla vewol vev ungevliva. Mongova plalva os lohv, hena ongalva mongi tendoriniiva akivra evetava, wo osva himba wohengvapiangavav. ");
INSERT INTO wrs_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Hevna aonghal mahalnind umnina Yesusm, yena moamba kin vev, heva os owai, es eva engivav? Osva si kava ongamba dumbvavmoa, kava si ambo tendomuh lovahvav. ");
INSERT INTO wrs_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","12","Yesus unna, tendomuhna wevsava os men, indkumbiva engivmoa, indkumbiva ongamba si vravav. Heva os Sesoava doa doara pusvund vena indhanamba monglava, wo tendomuh lovahvav. Monglava indhanamba doara aval snal ambo nihkoklana tetwond vevna, wo noinda osva es eva tetwond vevra, owai, wo himba tendomuh lovahvra. Monglava indhanamba henamba doara teilsuva velarombol vinvna, wo noinda himba si tendomuhva wohavav. Wo monglava indhanamba nihbesalangas, wo heva os himba Sesoamangas andra venalm viv, wo himba si tendomuhva wohlovahvav, noinda kava Sesoana nemeltindim andra vinv. Yeoa indakonda hillivm kana moam, wo engivm, himba nomba heva hevnalhra hevnalhra indakonda. ");
INSERT INTO wrs_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","15","Doa araravalva otolmba wulprapiavna hevnamba Yesusindam, osm ata Yesusva hevna englava huhlinvrava, awothowol vevra. Heva os Yesusna aonghal mahalnindva koasromb vivna araravalmba, unvna, manam yimba viv memba. Wo heva os Yesus unna hemba, ambvra otomotalva kaindam, ata ye ovinvav hem. Indhanamba snamba temba himba si Sesoamba hevna undnahonam lovahthamnavav, wo hena nemeltindim engilvra, wo beswonam avra. Wo doa Yesusva hevna engla huhlinvna otomotalna kurava, wo awothowol vena, wo doa osva venamba, os dashalaha wohgana. ");
INSERT INTO wrs_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Doa tendorini pronamba Yesusindam, omnana, guru ishomno kam, heni wevsabesalva kava vevav, wo osva Sesoava kamba noindava beswonam nonglavra, wo kam venavav, beswonam yunalm wohalm. ");
INSERT INTO wrs_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Yesus omnana, manara yimba kamba osahmanav besalwevsamba? Mongawa indhanariningas tanamba besalva, Sesoa. Engvm moam, nom Sesoa ten nemet doara Mosesm dembrahonam, os yimba si beswonam avav yunalmba. ");
INSERT INTO wrs_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","19","Hev omnana Yesusm, heni moamba? Yesus omnana, honi moamba, manam yimba indhanarinimba helvakomandhavav, manam yimba ongariskui vevav, manam yimba yukov vevav, manam yimba moangakala ovravav duangmba, tanamangas wohishovm. Pevna ararapevmoa helwolvm, wo eva kolvrowol vevm, und vewol vevm indhanam monglamoa, wo beswonam vinvm, os ten pev vrevm pevm. ");
INSERT INTO wrs_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","No tendorini omnana Yesusm, no moamba kava nemetva beswonam wohengna, ishomno kam henga mongmom, kava si keknam wohengvav, wo si osva kava beswonam wohavav yunalm. ");
INSERT INTO wrs_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Yesus omnana, yimba vetava, men kav dawonam yem ishomnavm, yimba osva Sesoana nengavnangm wohengvav, yem ten hev nengmanavm. Pevna wohoa yeoa dinasvom moang vinvm monglam, wo no dioa nom daswolvm, ten innehui eivvm. Yimba si wohhui lohvav huiva hona petharava, wo heva os yenamba wohva tanamba si kokolma velohvra di Sesoana kembella. Wo os yimba si katindilmba sihavav. ");
INSERT INTO wrs_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Wo doa no tendoriniva os Yesusmba dasvholahangana, himba mindnam os nengvna i, manara himba wohnindrini lohvna. ");
INSERT INTO wrs_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","24","Doa Yesusva nonglanamba no tendorinim, doa gai. Wo hev unna hevna aonghal mahalnindm, wohtowondva indhanariniva, es hevpa si sihavav Sesoana nemeltindilmba? Hillituk, miemba lehra sihavav meiskismerava. Heva os wohtowondva saha vrowovav, sihalmba Sesoana nemeltindilmba, es eva, melva kekelmel. ");
INSERT INTO wrs_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","26","Nomba hevna aonghal mahalnindva mindnam ningvna i, mindnam eishovna, wo umnina, wohnindriniva saha vretava, Sesoana nemeltindilmba sihalmba, wo es hevpa eva kava ombandhanamba saivvavma, owaimi? Yesus unna, indhanariningasva hevhova es eva sihavavma Sesoana nemeltindilmba, owai. Wo heva os Sesoava monamba vuenghamnatava hemba, osva himba si sihavav. ");
INSERT INTO wrs_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Pita omnana Yesusm, kava yetindi, kava kavnamba wuleiha ambwol vena, yem patvmonana, mani si vuhesmba yimba kamba daswolvav? ");
INSERT INTO wrs_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Yesus unna, si sewonam hona pethava mueisowa vevav, wo nemel phovra, wo kava si os avav musera indkumbina indhanana kuwulalm. Kava si avra vuhe besalla kavinda, wo yimba katindiva, kava si yemba sandhavav di. Yimba 12pelarava, yimba indakonda si aevluwul vevra vuhe besalla, Israelnindnam 12pelaram kuwulalm. ");
INSERT INTO wrs_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Eva no indhana ten hevna deuvm wuleihalaha ambvnam, wo os katindim patvunvna, kava si vuhesm mana vema besal vinvav hemba. Himba hevna aratindimba sandhalaha ambvrava aralm avalm petham, wo kam engivra, kava si esvema hemba daswolvra, wo himba si os wohaevulvav beswonamangas yunalm. ");
INSERT INTO wrs_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Wo heva os memba indhanamba daipotava kamba patvmonavpa, mindnamba nomba himba nihilva mendekli ilvahv, heva os sewonamba si himba nihil eusilva ilvahvav. Wo himba nomba daipotava memba nihil eusilva ilvahvpa, henoi si nihil mendekliva ilvahvav. ");
INSERT INTO wrs_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","2","Yesusva ishunvna hevna aonghal mahalnindm nengam Sesoana nemeltindim. Hev ona, Sesoava lehra vethawol vev indhanamba indkumbim. Men os olhmomba osmba, os Sesoava lehra vethawol vev. Okombava bonamosta vevnamba, denwitna aralva gavna, wo hev unna indhana monglam, yeoa kana denwitandra viu detioa. Doa hev moa eishonamba, wo doa denwitna aral unna hemba, dawonamba okombava singvelva vevrava, ata kava os moang vinvav henom K1 henom K1, hona wevsana doara pivva among velohv. Doa ishopieinnamba, os angamnana, denwitandramba venalmba. ");
INSERT INTO wrs_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","4","Henga ambo osoa okomba numbva vevnamba, no denwitna aralva henga ona gana, wo nongalna, monglava indhanamba ten kusov kembella. No denwitna aral unna, eva yeoa angota kana denwitandram, kava ata yemba beswonam moang vinvav. Doa os angamnana, hena denwitandramba velmba. ");
INSERT INTO wrs_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Henga ga, okombava hovrahovrava lohvnamba, wo henga os vena, seilm hev ten venam, himba henga wolanga ve monglamba indhanamba hevna andram. Okombava vohavnamba, hengava gavna, wo henga indkolam wolanga ve hevna denwitandram. ");
INSERT INTO wrs_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Doa okombava singvel vevna, doara avhoana olorava, henga no denwitna aralva gavna, wo ona nongalna indhanamba, ambo men aevulv andrahui. Hev unna, nambaipeta eva huiva yimba aevulima andrahuiva, manara? ");
INSERT INTO wrs_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Hev umnina, mongova indhanariniva proimoa homba, kamba ishunilmba, hena andramba velmba diandramba. No denwitna aral unna, yeoa eva angota, wo kana denwitandra viu, wo os angana. ");
INSERT INTO wrs_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Doa ananmba ovnamba, no denwitna aral omnana hevna kuwulm, yeoa garava, nom andranindm nambaka verava, moang vinu di, himba detiva kana andra viva. Mioa nom moang vinu, ten eunillam kav wolasiha veim, nonam okombava doa singvel vevna, wo nom eva okombava vohavnamba, himba andramba saivoi, verava, nom ten eva okombava hovrahovrava lohvnamba, himba andramba saivoi. Wo nom ten os saivoim, okombava doa okombanumb vevna, himba saivoi andramba. Wo eunillamoa nom ten doara sieunumbulnam hesna saivoim. Os moang vinu, men kav nengvm. ");
INSERT INTO wrs_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Indhana noi ambna, ten andram os saivoim, okombava doa singvel vevna, wo hemba os moang vinna henom K1 henom K1, osangas mongawakombanamba andra vinamba. ");
INSERT INTO wrs_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Okombava bonamostava vevnamba, heno andram saivnam, venamba, okombava singvelva vevnamba, himba nomba nunglivnamba, hevm ishuwul vevna, uvna, pimba ata mindnam dumbvav, K1angasva owainonoa. Wo heva os owai, K1angas dumbna. ");
INSERT INTO wrs_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Diva dumbnamba, doa himba musknahonam ishumnivna denwitna aralmba, umnina, ");
INSERT INTO wrs_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","hona indhanamba, memba himba ambo eskand andra visimbeihi, nonamangas okombava doa singvel vevna, veiva, daipota men. Heva os kava eva sna okombam sovohalaima, veiva, daipota men. Wo yimba ambo kamba lohohra moang vini, os ten hem vinim. ");
INSERT INTO wrs_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Doa denwitna aral omnana mongom, seh, simekumbrava kava yemba doa wonishoi mongawulm, wo yena dim ka vei, ishuni, os yemba kava ata moang vinvra K1. Doa kava nom moamangas wohengi, wo yemba indakonda kava os wohmoang vini lehra. Kava yena diva yiskomeinimoa, owai. ");
INSERT INTO wrs_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Doa angawul veo deuvram nona ambo. Hona indhanamba memba himba eskandva andra viva, kava lehra vethalm vev henahonam, wo kava noinda daswoli K1. ");
INSERT INTO wrs_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Kavna diva kava moang vini hemba, yenamba owai. Kava lehra vethalm vevna henahonam, wo manam yemba mindnamba wusapramana vinvav, owai. ");
INSERT INTO wrs_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Yesus honamba olhmomba ishunna, wo unna hevtindim, no indhanamba memba daipotava eusilva lovahvpa, wo si sewonamba Sesoava hemba mi sandhavav. Himba nomba daipotava memba mendekliva lovahvpa, Sesoava si hemba sis sandhavav. ");
INSERT INTO wrs_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Yesusva Yerusalemram gavna, hevna aonghal mahalnindva ella wongavna, wo di monara osva dendwolla ishunna, ");
INSERT INTO wrs_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","hillu, kava arana ombol, wo heva os di Yerusalemra indhanamba si kamba holvoholothivav kuwul tempelna andranindna englisra, wo eva katekisna englisra. Nomba indhanamba si kamba os umnivav, yemoa dahangas wohvera, ");
INSERT INTO wrs_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","doa himba si os kamba holvoholothivav kuwul Romduangna englisrava, noinda himba tit viniv Sesoamba. Nomba indhanamba si kamba mueri vrivrava, losgoplala dahamnavra, wo osoa hilvivra, wo os si kamba tirava pakonamba lepetheivav. Wo os si kamba dahavav, wo si kava samblamongoninmba verava, si os kava henga beswonam phovav kavna nihna. ");
INSERT INTO wrs_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","21","Sepetina ongal hevna ombolsamblam wonprovna Yesusindam, Yemsim Yonim, himba Yesustindirini sambla elohvna doara. Hev pronamba, Yesusm mulumbdandna lohvhoamna novlomossis, omnana, mendekli, os kam veno. Yesus omnana, manam yimba vev, es ata yemba kava venavav? Hev omnana, os kava nengv, men kana ombsamblava, yeoa kam doara ishomno, osva yimba hemba si sandhavav kuwulalm vuhe besalla. Sewonamba yimba avrava kuwul mendeklilmba, mongova yena nihanasis avra, mongova yena sihanasis avra. ");
INSERT INTO wrs_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","23","Yesus unna nom etel bosalalm Yemsim Yonim, hona moamba memba yena avapevpa kamba osahmaniva, yimba levra epivongovmoa, osva mani si venavav. Es hevpa honamba, wo es hevpa yimba ambo kinmba wulengavavma kamongova, si kamba indhanamba pelhola vinivrava? Doa hev ohomnana Yesusm, kava evevav. Wo Yesus unna hemba, tanam yemba si kinsomb pelhola vinvavta, indhanamba kamba vinivrava. Heva os hona moamba yenamba, osva kava si ahavav kuwulalm Yesusmongo, kava es eva vinvav yemba. Kana arangas honamba vev. Himba si vinvav no indhanam, hev doara ten pusvund venam, ona, himba si kana ombmongo kuwulalm aevulvav. ");
INSERT INTO wrs_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Nomba Yesusnindva 10pelara no moamba hillina, Yemsiva Yoniva Yesusm ohosahmanavna, kuwulalm ahalm Yesusmongom, doa nomba 10pelarava wusapramana vinvna Yemsi Yonimba. ");
INSERT INTO wrs_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Yesus unna hevna aonghal mahalnindm, hui kusotok mongawulm, wo unna, yeoa besalwevsamangas engivm, wuleihivm pevna nengavnangmoa, wo enginvm indhanana nengavnangm, kolvrowolalm hem. Yimba nonora vilunv wevsamba kuwulnamba puehalnindnamba, himba tit viniv Sesoamba. Nomba kuwulva indhanamba monglana weilhivpa, moanangas vewol oviv. Indhanamba hemba os nengsmoa uv, mendekli pina, wo himba os vinv, hev ten ningvm, mana vemam velm. ");
INSERT INTO wrs_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Wo heva os yimba katindiva manam yimba engivav no wevsamba. Yimba nihil mendekliva ilvahalmba vetava, pevna nengavnangmoa wuleihivm, wo enginvm indhanana nengavnangm. ");
INSERT INTO wrs_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Yimba osmba vitava, indhanaoa monglaoa kamoa os nengsmoa uvra, kuwul, yeoa andra vinvm hena. ");
INSERT INTO wrs_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Wo eva osta, kava men arana ombolva kav, heva os kava homba pronamoa, indhanamba kamba kolvrilmba. Owai, kava indhanam kolvrowolalm prona. Kava si kavmba kihpiavav, dahalmba. Wo os kava si indhanamba kilumbshuawol vevav, nonamba temba hevna indkoklanahonamba euvmona vevpa. ");
INSERT INTO wrs_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","31","Yesusva hevna aonghal mahalnindmba Yeriko kotariniva wongavna, wo indkumbiva indhanamba pelkleihamnavna hemba nonglalm. Novtitnindrini samblava di ahavna monapethalla. Himba ehellena, Yesusva doa hesna mi kohai, doa hev dandwonam ihishonga evemnana, kam wavra vovhueinu, wo kam kolvrowolo, yimba kuwul Devittindirini lohv. Doa indhana velaipulvo ovinvna dandwonam, esalm yimba ohov, ewuliho, wo heva os owai, himba mindnam nihnapehna ohovravna, mendekli, kam kolvrowol veo. ");
INSERT INTO wrs_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","34","Doa Yesusva di dawonam moih venamba, wo unna, manam yimba ohov, mani ata kava yemba vinvav? Hev ohomnana, kam vinu, wo kava henga ata beswonam nov evevra. Doa Yesusva wavra vovhueinnamba, novm kekaiv vinna, wo doa nungi lelnam beswonam henga nov evevnamba, wo doa os Yesusna aonghal mahalnindm epawohinna. ");
INSERT INTO wrs_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","3","Yesusva hevna aonghal mahalnindm wongavna Yerusalemram. Doa murapetava wonkaksalala vrevnamba, Betpaki kembella di wonsihavna, os ningthiv, oliv denwit olo. Di nomini Yesusva hevna aonghal mahalnindrini samblamba mi wolanga ovov, yeoa yesna mi engavm no kembellam, ten ambara lohvm. Ata yimba di lelnamba enonglavav donki avalmba, wena ningewula pathalohvra deuvtra. Mongnasisva avalindava hevna otol mendah bimbehusil lohv, wo yeoa hemoa epelvrombtvrava, hom wonepro. Kava nosram galm vev. Mongova indhanariniva yemba osva untava, manaram yimba evev?, yeoa os ohomno no indhanarinimoa, mendekli nosram galm vevpa, wo henga himba lelnam ata wolapra vevav. ");
INSERT INTO wrs_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Yesusva os wohvena, himba wohengna moam nom Sesoana moashulnindrinina doaraminim, os ten novol velohvm, ");
INSERT INTO wrs_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","Sesoava hevna moashulnindrinim ishomnav, yeoa Sion kotanindm unu, nunglu, yena mendekliva ten prunv yemba, himba hevmba wivevmoa, owai, himba hevmba wohpiapahav, donkisra sena prov, wo donkiva nomba mendah bimbehusil. ");
INSERT INTO wrs_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","7","Doa hevna aonghal mahalnindrini samblava ehellenamba, doa engavna, donki avalombolm ohonekinvna Yesusindam. Hev ohonekinnamba, doa hevna kayen ambarini selvowol evenamba, donkisra ehohla, wo Yesusva nosra senamba avhoana, wo os gavna monamba Yerusalemramba. ");
INSERT INTO wrs_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","9","Indkumbiva indhanamba hevna pikianmba monara velahangavna, Yesusm nonam okolalm, osm Yesusva donkinamba nosrava enggavna. Indhanamba monglava tivla kueivnamba, monara vevta vilangavna. Yesusva gavnamba, indhanamba vevna, mi gavna, sis provna, wo dandwonam mindnam os sangalva seivilvna momnanamba, Kava yemba okuliv, yimba kuwul Devittindirini lohv. Sesoa yemoa awothora, yimba hevnapopol prov, kava Sesoamba okuliv senaminim. ");
INSERT INTO wrs_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","11","Os Yesusva sihana Yerusalemrava, wo indkumbiva kotanindva evekingil vithiwul vevna, no indhanariniva temba, an hevpa prov? Wo noi indhana ten Yesusm pelkleihamnavnam, noi unna hemba, memba Yesus Nasaret kembellini Galili provinsrini. Himba Sesoana moashulnindrini lohv. ");
INSERT INTO wrs_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Doa Yesusva venamba, siha tempelpulmera, wo os himba engilpiphona nomba indhanamba, nomba temba himba vevna, esvowolvna, eva wulprovna dinasvom tempelpulmeramba. Wo no indhanamba himba sembayang diva temba iambvnamba, dises velmba tempel diramba. Wo doa Yesus phona, hena meyava mulgotho piha vinna dinahonam. Wo eva no indhana, ten leumb wulprovna, nonam sembayangm, Yesusva henga hena kursiva mulgothowol vinna. ");
INSERT INTO wrs_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Hev unna, Sesoana moamba os novol velohv, kana tempelduvpa osm lohv, indhanamba si kamba hui sembayang velvohmanavra. Sesoava os ona, heva os yimba bisnisandra velvohv huiva, wo noinda eva yimba kelsombovhol indhana, indhanam kin huhlinv, snal ov, yukovnind, di ten hev keketv vevm hevna vuhera. ");
INSERT INTO wrs_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Yesusva di mendah avna tempelpulmera, doa vena, novtitmungil, eva monglakoklana ambna Yesusindam, wo Yesusva hemba os sishona vewol vena. ");
INSERT INTO wrs_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Otovotalva Yesusmba okulivna, doa sembayang andranindna kuwul eva katekis, himba nungli Yesusm, una, himba os mendekliandrava os vev. Wo himba otindna hemba, ");
INSERT INTO wrs_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","otovotalva huiva yemba okuliv, himba os uv, okuli Yesusm, kuwul Devittindirini. Himba osva uvavmoa, yeoa hemoa ishunu os, poaita ambo. Doa Yesus unna hemba, kava lehra helwolv hemba, memba besal, kamba himba okuliv. Es hevpa yimba maivithivma, Sesoana moamba os novol velohv, Sesoa, yimba doa nengavnangva tuhowol vinna otolnamba eva tetmengnanamba, wo os himba yena nihilva okulivna. ");
INSERT INTO wrs_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Doa Yesusva os dashalahangana no kuwulmba, wo os wohgana no tempelliniva, himba hengava moamba ishunnamoa hemba. Himba venamba Yerusalemriniva, os gana Betani kembellam, ninmba dom. ");
INSERT INTO wrs_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Lingil lihapihavnamba, Yesusva Betani kembellini venamba, henga Yerusalemram gavna. Hemba pon venavna, ");
INSERT INTO wrs_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","wo himba nonglana, men fikva lohv monapethalla. Doa hev murapetam ganamba, hev nonglana, besal vlelva, heva os owai, movolhui. Wo doa os himba omnana no fikmba, hengava si movolva kethavavmoa yena tillava, owai. Doa ambo lelnam os soulana. ");
INSERT INTO wrs_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Wo hevna aonghal mahalnindva nomba nunglinamba, himba evekingil vruwul vevna, es hevpa honamba, hona timba ambo lelnam soulai mongawa okombanamba? ");
INSERT INTO wrs_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Yesus unna hemba, yimba Sesoamba keknamba pevna undnahonamba ningminitava, sambla undnamba owai, wo eva yimba os mendekliandrava vivrata. Yimba si vivra, os men kav venaim hona fikm, wo si os yimba vivra mana vemava mendekliva. Yimba si os unvra hona olomba, pulvorava, pevm wanplombra pingipuv veo, wo no olomba os hevmba wohvevra. ");
INSERT INTO wrs_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Mana vemava yimba Sesoamba osihminivrava, vinilmba yemba, wo keknamba pevna undnahonamba ningminivrava, himba si os yemba wohvinvra. ");
INSERT INTO wrs_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Yesusva henga tempelduvra sihanamba, wo numhowol vevna indhanamba di. Doa sembayang andranindna kuwul, wo mongla mundil ambna heindam, wo osihminina, an yemba hevpa pusvundthoana, wo noinda yimba moamba mendekliandrava snamba vev?, kam ishunu. ");
INSERT INTO wrs_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Doa Yesus unna, ata kava boasna yem sahinvav, yimba hona kana moamba opla vritava, ata kava yemba ishunvav, osva henoi kamba pusvundthoana, wo kava os mendekli moamba wulluhv. ");
INSERT INTO wrs_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Yon Baptaisva doara indhanamba elsus poswol velohvna ponamba. An pusvundthoana Yonmba hevna andramba? Sesoami a indhanami? Kam ishumnu. Doa no kuwulva hevm mindnam eishovna, os pivva Yesusmba osva ishumnitava, Sesoa Yon Baptaismba pusvundthoana, wo ata Yesusva pimba os unvav, eva manara yimba Yonna moamba hellemba owai vivna? Yenamba indkoklava luhunv. ");
INSERT INTO wrs_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Wo pimba osva Yesusmba umnitava, Sesoava owai, indhana ambo Yonmba pusvundthueina, ata hona indhanamba pimba musk vinvav, manara, himba os ningvna, Yonmba Sesoana moashulnindrini lohv. ");
INSERT INTO wrs_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","No kuwulva os ishuvna hevmba poaitava, doa hev umnina Yesusm, kava tit viv, an vraohna Yon Baptaismba mendekliva moamba. Doa Yesus unna, noinda ata kava yemba ishunvavmoa, osva ora, henoi kamba mendekliva moamba vraohna, os kava andra vev. ");
INSERT INTO wrs_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Yesusva mendah ishunvna no kuwulmba, hev unna, yeoa boasna kana olhmom hillivm, wo kam ishumnu, es yimba ningv? Tendoriniva ombolva samblamba wonavna, doa hev ganamba yiveltowondindam, hev omnana, yeoa daipota gao, kana denwitm lengwol vikao. ");
INSERT INTO wrs_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Ombol omnana aralm, kamba owai, wo heva os owai, himba sism henga nengna, lehra, wo os gana. ");
INSERT INTO wrs_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Wo aralva henga kalelindam ga, hev omnana, yeoa gao, kana denwitm lengwolalm. Hev omnana aralm, lehra, ata kava gavav, wo heva os sismba himba nengna, owai, kamba gumus venav, an ata eva gavav? ");
INSERT INTO wrs_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Memba kana olhmoa, es yimba ningv? Heni ombolva vena mana vemava, temba hevna aralva unvnamba? Hev umnina, yiveltowond. Wo os Yesusva unna hemba, yimba lehra ui, wo hona olhmomba yemba nov wuleihinv pevna wevsam, yimba Sesoatindi nemelalmba saivolmba vevmoa. Wo heva os indhanakokla snal di dambolnind, ungevlirini monarini, himba maivithiv hevna indkoklamba, wo Sesoatindi nemelalm himba saivv. ");
INSERT INTO wrs_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Kava honamba noinda ishov, Yon Baptaisva nemetva prona, Sesoana moara yemba indthueinilm, monabesalm engalm. Wo heva os owai, yimba hillimnivnamoa hena moamba. Wo heva os no indhanakoklava, himba Yonna moamba hillivna. Yimba hemba nungeilvna, himba hevna indkoklamba maivithivna, wo heva os owai, yimba pevna nengavnangva weihaloh vewol vivnamoa, wo Yonna moamba kek vithivnamoa, owai. ");
INSERT INTO wrs_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Yesusva mendah osangas ishongeinvna no kuwulmba, yeoa kana moam henga hillivm. Mongo tendorini avna, himba denwit wola, os sevriv wain, si sewonam movolva besal kethavav, os nengvna. Hev pueil ningenamba, vuhe pongvhoana, wainmovm kelvolalm wainpolalm. Deuv vena, kekalvho vrelm no sungeittatam eva yukovnindm, ata homeis ambvavm. Doa hevpa galm vevna mongona kembellam, boasna himba mongom indhanam ishunna, yeoa kana denwitmoa kekalvho vruwuvm, lengwol vewuvm beswonam. Si dawonamba movolva endandpravra, monglava kavm, monglava pevm. ");
INSERT INTO wrs_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Hevpa mongona kembella avna, wo nonamba doa wainmba doa movol kethapravna. Doa hev wolapravna hevna andranindmba no kembellini, ten hev avnam, dom ten heno kekalvho vruwuvmonavm hena denwitm, hev naengho vewol ovovna, iambmano kavm monglaoa wainmovoa, os ten nemet piv ishunam. ");
INSERT INTO wrs_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Wo heva os no indhanamba himba no andranindmba kekaiv vinamba, mongomsna hilvinamba, henga mongom helvakomandhi, eva henga mongom honna helvakomo vina. ");
INSERT INTO wrs_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Wo henga no denwitna aral wolapra ve hevna andranindm mindnam. Henga naengho vewol ovona, kavmoa dembrahura wainmovoa. Wo heva os owai, no kekalvhonindva no andranindmba sahonam vewol vina, wo noinda posalva hengava angana. ");
INSERT INTO wrs_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Doa denwitna aralva henga hevna ombolnonoam wolaihangavna, aralva os nengvna, ata himba hillivav kana ombolna moamba. ");
INSERT INTO wrs_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Wo heva os owai, no indhanamba no denwitna aralna ombolmba nunglivnamba, wo hevm ishuwul vevna, memba ombolnonoa, si sewonamba he vaohothovav hona pethava. Pioa hemoa helvakomandhalvohra, wo piv hona pethava si wulvahvav denwitnahonam. ");
INSERT INTO wrs_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Doa kevrinamba, wo pilpipulvo amballa denwitmusriniva, wo os helvakomandhina. ");
INSERT INTO wrs_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Memba Yesusna olhmoa wohhenga, Yesus unna no sembayang andranindna kuwulm, es yimba ningv?, no denwitna aralva es si vinvav no indhanamba, nonamba hevpa provrava? ");
INSERT INTO wrs_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Hev umnina Yesusm, nonamba himba provrava, himba si os helvakomo vevav hemba. Himba indhanakokla, wo himba si und vewol vevavmoa hemba, wo himba si hevna denwitva mongnindna englisra holothunvav, unvav, kana kekalvho vruwuvm. No indhanamba himba si dembrahuvra denwitmovpa, nonamba aembulva ksuvhoapravrava. ");
INSERT INTO wrs_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Yesus unna, yimba lehra uv, wo es hevpa yimba maivithinama Sesoana moamba? Men os novol velohv, Deuvandranindva honmba mendekliva ahnam vileihivna, sahoklal, wo heva os sism Sesoa no honmba deuvna hovmundilmsna lothona. Sesoava mendekliva memba vinvpa pina novrava, pivva indk vithiv, himba beswonam vev. ");
INSERT INTO wrs_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Kam hillu, Sesoava si yemba wolapho vevav hevna nemeltindiriniva, wo eva himba si nembavav nom, ten heno hena moam hillivm, wo eva beswonam engivm. Wo eva mongmomba novol velohvta, ");
INSERT INTO wrs_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","no honsrava indhanariniva engkavrava, vetakolavra, kel tetepemna. Wo eva no honmba indhanamba plothomnavrava, indhanarinimba somovtovolm nilhavav. ");
INSERT INTO wrs_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","46","Doa nomba sembayang andranindna kuwul eva Varisinind, himba Yesusna olhmom hillie, pimba himba os pusvund vev, oi indhanakokla. Wo doa himba wusapramana venavna, kevralm vivna, buiram wolaihasuvulm. Heva os owai, kuwulva pem vivna indhananapenam, ata homeis pim helvowol vivm, indhanamba indkumbiva os ningvpa, Yesusva Sesoana moashulnindrini lohv. ");
INSERT INTO wrs_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Yesusva mendah ishongeinvna no sembayang andranindna kuwulmba. ");
INSERT INTO wrs_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","Hev unna, Sesoana nemeltindiva os av, mongo kuwul mendekli tihinne kokolma vevna, dahwol velm. No kuwul ona, kana ombva si ongamba vravav, wo noinda pivva si os innemba mendekliva hlavrava, indk vithivra. ");
INSERT INTO wrs_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Doa hev moa wulluhungu vinvna indhanam, daha kuso kainda, innem hlalm. Doa venamba, nomba tihva ophovna, no kuwulva hevna andranindmba velahtungu vevna, unna, yeoa ango, no indhanam suwutwul veo os, doa innemba tepiangei, ata pimba di hlavav kana kuwulna deuvra. Wo heva os no indhanamba aongpa vina, no andranindmba unna, owai, ata kava ambvavmoa. ");
INSERT INTO wrs_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Wo henga monglam kuwulva wolanga vungu ve hevna andranindm, unna, yeoa ishohilvunu no indhanamoa, ambra, doa innemba tepiangei. Kavna mendekli sapi, eva sapiotol naembulna, kava doa welhiva, doa suweriniangas vithalohv. Doangas, yeoa ambangas veo. ");
INSERT INTO wrs_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Doa heva os no indhanamba no moamba hillivnamoa, aongpa vivna, wo himba osm viwulilm vevna, hev ten ningwul vevnam. Mongova hevna osondram gavna, mongova hevna tokondram gavna. ");
INSERT INTO wrs_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Monglava no indhanamba himba kekaiv vina no kuwulna andranindmba, wo os helvowol vinamba, helvakomo vi. ");
INSERT INTO wrs_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","No kuwulva esvema wusprovna, doa himba hevna valgonindm wolanga ve, wo valgonindva no indhanamba deuvsowanamana vrevna, eva helvakomo vivna. ");
INSERT INTO wrs_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Henga no kuwulva hevna andranindm nembanamba, wo unna, innemba doangas, nomba indhanamba temba kava ishuniva hemba, ambalmba, heva os himba besalva owai, kamba hillimoa beswonamba. ");
INSERT INTO wrs_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Yeoa henga angawul vevm deuvkembellam eva monaluwullam, wo indhanam nembawul vevm, yimba nomba nungeilvrava, wonamb vevm hemoa hom. ");
INSERT INTO wrs_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Doa no andranindva os angawul vena deuvram monaluwullam, wo ishuwul vinvna indkumbim, yeoa prapiao, inne mendeklim hlalm. Yimba hona indhanamba besal monglava, monglava sahoklal. Wo doa no kuwulna mendekliduvpa venamba, pilivhoanamba, ambo plissra desvhoavna. ");
INSERT INTO wrs_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","Doa ovhoanganamba, wo no kuwulva di nungsis vungu ovovna hemba sehmona. Wo di kuwulva nongla mongom tendorinim, himba pikiankoklana. Himba pikianmba besalva vewol venamoa, inne mendekliriniva nonamba nelmba. ");
INSERT INTO wrs_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Doa kuwul omnana hemba, seh, yimba mendeklirini innenamba pikianmba vewol veimoa, yimba ambo pikiankoklana nis sihai kana mendekli innerava, manara? No tendoriniva opla vramnanamoa kuwulmba inne mendeklinamba. ");
INSERT INTO wrs_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Doa kuwul unna hevna andranindm, ningu keknam hona sahoklal indhanarinim, wo amballam ningesva pipulvo dom sikulmeram. Ata himba di wovawovra, wo kinsomb mendekli venavra. ");
INSERT INTO wrs_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Yesusva nomba olhmomba ishopianamba, doa hev unna, Sesoava indkumbim das owol vev, ambo, wo heva os ambo eskand indhanam himba kikih vewol vev hemba, honi si kana nemeltindilmba saivvav. ");
INSERT INTO wrs_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Monglava Varisinindva kusonamba, poaitamoa ishumnivna Yesusm. Ata pimba deiswihivav Yesusmba, osm ora moakokla ishora, wo os hemba pimba wetat uvav. ");
INSERT INTO wrs_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Himba wolanga vi monglam hevnam eva kuwul Herotna andranindm Yesusindam. Hev noi umnina Yesusm dasalm, guru, yemba kava liheiv, yimba tanamolnamangas moamba ishov, wo numhowol vev indhanam indakonda, os viu Sesoana novraoa. Yimba pemba vinvmoa indhananapenamba, owai, yimba mongawamoa ishunv indkumbimba, eva snamba kuwulmba, ombandhanamba. ");
INSERT INTO wrs_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Es yimba nengv, taeksdimba Sisa duangmba dembraholmba? Kava vivavma owaimi? ");
INSERT INTO wrs_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Wo heva os Yesusva doara siheinna, himba ambo osm kamba ishumniv, ora noinda moakokla ishovra. Wo Yesus unna hemba, yimba moangakalanind, es hevpa yimba kamba lihminiv osva. ");
INSERT INTO wrs_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Kam nihminu sen, snanovna yimba taeksva dembroh velvohmanav Sisa duangmba. Doa hev nihminina no sen. ");
INSERT INTO wrs_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Yesus osihinna, temba nihilva novlomosva kokopa velohvpa sendava, anna? ");
INSERT INTO wrs_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Hev umnina Yesusm, Sisana, yimba nonora lohv. Yesus henga unna hemba, temba Sisanamba, henga yeoa dembrehu Sisam hevm, taeksram, memba besal osva. Wo heva os mana vemava Sesoanamba, henga dembrehu Sesoam hevm. ");
INSERT INTO wrs_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Himba hona moamba hillivnamba, evekingil vruwul vevna, wo doa os Yesusmba wohdesvho bukethana, hengava pimba lihminivavmoa Yesusmba. ");
INSERT INTO wrs_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Ambo no okombanamangasta mongla mundil, himba Satusina moam engivna, ambe Yesusindam. Himba os ningvna, tanam temba nemetva indhanamba sihaomana venamba, si hengava beswonam hevna nihna phopiavavmoa sismba, owai. Himba Yesusm lihminivna, osm ora noinda moakokla ishovra. ");
INSERT INTO wrs_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","Hev Yesusm umnina, Mosesva nemetva os ona, wo os memba novol velohv, mongova tendoriniva ongangona lohvra, wo hemba daha otolhui, wo boaslal moamulmba petha. Wo himba otolva lengtava surava, indhanamba si os uvra, eisilna vuheram, ten dahanam. ");
INSERT INTO wrs_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Mongo kariniva vena, aral luhunvna, aval einna, wo 7pelara tetwond evena tuendismba. Yiveltowondsna ongamba vranamba, wo hemba eneha dahana otolhui, wo pethamnal pethana muemulmba hevna ongalalm. ");
INSERT INTO wrs_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","27","Wo eva nomba pethamnalmba daha otolhui, wo henga mongo boaslal petha muemulmba hevna ongalalm. Wo hemba daha otolhui, osangas venamba, lundthoana, no mongawatindimba 7pelarava, nomba ungevlirinimba vruwuvna, venamba, wohsihana. Eunillamba no ungevlirinim dahana. ");
INSERT INTO wrs_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Wo doa kam ishuntok, sewonamba nomba indhanamindva phopiavrava beswonamba hengava, heni si vravav no ungevlirinimba hevna ongalalmba no 7pelarava, nemetva doarava nomba 7pelarava vruwuvna hevna ongalalm? ");
INSERT INTO wrs_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Yesus unna, yimba titnam ishuv, manara, yimba tit viv Sesoana doaraminimomba beswonamba, wo eva yimba tit vivta, osva Sesoava keknamangas lohv. Wo noinda yimba moakoklava eishov, osmangas, tanammi si phopiavav indhanamindva beswonamba? ");
INSERT INTO wrs_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Hillu, nomba indhanamindva hengava nihilnahonamba pulvovrava, nonamba si otolhui, ongahui. Si os ovra, Sesoana ovsongolnind, ten muhsoh avm. Honamba wevsava onganamba eseskosmba, himba si hengava vivramoa, owai. ");
INSERT INTO wrs_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Sesoana doaraminimomba yimba beswonamba levrapivolvmoa. Os novol velohv, Sesoava os ona, ");
INSERT INTO wrs_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","Kava Sesoa luhunv Aprahamna, Isakna eva Yakopna, yena simbehumunpevna, himba kamba sembayang vewuvmona venavna. Sesoava osva ishunvna pina simbelm 3pelaram, doara doa nemet hemba dalna, heva os daipotava himba beswonam aevulv Sesoaindava. Hona moamba pimba nonora av, indhanamindva si henga phopiavav tanam. ");
INSERT INTO wrs_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Wo ombandhanamba no moam Yesusnam hillinamba, evekingil vruwul vevna, besal hevm. ");
INSERT INTO wrs_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Varisinindva hellelvohvna, Yesusva ishunvna Satusinindna kuwulmba, wo owai, himba opla vrimnivnamoa Yesusmba. Wo doa Varisinindva hevm eishovna, ata daipotava pimba Yesusmba deiswihivav, wo os angana Yesusindam. ");
INSERT INTO wrs_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Nomba mongova katekism Varisinindva wailovahvna. Hev dasalm Yesusm omnana, ");
INSERT INTO wrs_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","guru, Sesoana lohohmoa temba novol velohvpa, heni hevpa mendekliva wohkuvhoawol vev?, kam ishomno. ");
INSERT INTO wrs_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Yesus omnana, men honi moamba mendekliva, Yeoa indhanaoa yeoa Yawemoa keknam pevna undnahonam und vivm, pevna undnahonam, eva pevna nihnahonam, eva pevna nengavnangnahonam. Himba yena Sesoa luhunv. ");
INSERT INTO wrs_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Nomba Sesoana lohohmomba, honangas moamba mendekliva lohv, owalmba kuvhoawol vev. ");
INSERT INTO wrs_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Wo eva mongmomba novol velohvta. Os novol velohv, Yeoa indhanaoa owapevmoa lelh avramana vevm, os pev ten pevm nesmos vromana vevm. ");
INSERT INTO wrs_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Honi lohohmosamblava mendekliva novol vewol lohv. Moamba nomba nemetva Mosesva temba novol vewol venamba, wo eva monglana Sesoana moashulnindna moamba, ambo kelvalohprav hona moa samblara. ");
INSERT INTO wrs_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","42","No Varisinindva mendah kusomnavna Yesusmba, wo hev unna, es yimba ningminiv? Kristusva, indhanarinim Sesoa pusvundthoana indhanam kolvrowolalm, antindirini himba si lohvav? Varisinind umnina, Kristusva si lohvav kuwul Devittindirini, nemet ten doara lohnam. ");
INSERT INTO wrs_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Yesus unna, lehra, heva os Devitmba Sesoasongol wuhmoh ovravna hemba, wo himba ona, Kristusva si kana mendekli lohvav. Nomba moamba Devitnamba men novol velohv os, ");
INSERT INTO wrs_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","Sesoa omnana Kristusm kana mendeklim, yeoa hui avhoao kana nihanasis. Verava, ka boasna yena ungundm vinda, osm yemba ku kusitheimnivra pethara. ");
INSERT INTO wrs_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","No moamerava Devitva ona os, Kristusva kana mendekli. Wo yimba hona indhanamba osva uvna, Kristusva si Devitna umbendil lohvav. Lehrami, owaimi? ");
INSERT INTO wrs_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Owainonoa, mongova Varisinindriniva Yesusmba opla vremnanamoa, himba pekmek wohvevna, dasalmba Yesusmba ishomnalmba hengava, wo venamba, hengava sismba owaimomolmba mongmomba ishumnivnamoa. ");
INSERT INTO wrs_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","4","Yesusva ishunvna hevna aonghal mahalnindm eva indhanam monglam, unna, katekis eva Varisinind himba moakus uvmona vev Mosesna doaraminimomba. Yeoa indkumbioa manapenam hillivm, engivm, heva os yimba manam hevmba daohtvowol vivra, osva hevpa temba vivpa, owai. Yemba unvrava Sesoana moamangas, engivm, heva os manam hevmba yimba daohtvowol vivav. Himba indhanamba moamba kinil ishunv, snal es eva engivav. Manara, himba snal vilov, indhanarini mongo ten owalm kinwonda okithamnavm, pungalm, wo heva os hevpa kolvravavmoa, nomba kinmba wulangalmba. ");
INSERT INTO wrs_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Honi indhanamba viv netesnalmba, osmba kam unvra, Sesoava henamba hillinv moamba. Varisinind eva katekis honi vinv indhanamba monglamba, osmba kam nungeilvra. Himba mendekli musung misara, noi vewol vivnamba hevna englara eva mira, osm indhanamba hemba si nungeilvra, himba Sesoam sembayang viniv. Himba hevna kayen tokolmba mulmba huhmoh vewol vivna, osm indhanamba nungeilvra hemba, indhana besalangas. ");
INSERT INTO wrs_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Indhanamba innemba hlalmba tihrinimba, mongawulmba kusovnamba nonamba, no Varisinindna katekisnamba himba hevmba hevm mimangas aevulthalmangas vevna, dom ten innena aral inne kokolma vevnam. Sembayangduvrava temba kusovnamba, himba hevm vuhe besalangas mim angavna, aevulthalmba, os indkumbi indhana kamoa nungeilvra. ");
INSERT INTO wrs_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Nonamba eva indhanamba monglamba anonglakaka vevnamba, heva hemba sehmonangas wonishuvna, osva himba noindava indk vithivna. Nonamba eva indhanamba hemba osva nengsmoa uvnamba, guru, hevpa indk vithivna mindnam. ");
INSERT INTO wrs_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Heva os yeoa wohengivm, yenamba guruva mongasal luhunv, kangas, yimba os lovahv, maim oi, mongawa pendarini. Aembu, manam yimba osva ningvav, indhanaoa monglaoa kana nihilmoa wulovolvra, wo kamba os seivilvra, guru, owai. ");
INSERT INTO wrs_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","10","Mongova ombandhanariniva hona pethariniva, manam yimba wulovolvav, pivna arangas senamininonoangas. Yenamba kangas mendekliva luhunv, Kristus, Sesoa doara kamba pusvundthoana, noinda osva manam yimba mongomba indhanarinimba osva umnivra, mendekli. ");
INSERT INTO wrs_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","12","Himba nomba yimba kana aonghal mahalnindriniva hevna nengavnangva wuleihavrava, wo engvra yena nengavnangm, osm yem kolvrowolalm, temba no indhanariniva yena kuwul tanam luhunv. Himba nomba hevmba wulovongovrava, Sesoa hem nomba si pilpiapahavav. Himba nomba hevna nengavnangva wuleihavrava, Sesoa hem nomba si wulvongovav, wo mendeklilm awovav. ");
INSERT INTO wrs_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","Yesusva mendah ishunvna Varisinindna katekisnam, yimba samblamona vilov, yimba moamba besal ishunv indhanamba, heva os yimba mana vemava mindnam sahonam viv, memba yimba tuv pepeivinv Sesoana nemeltindim, osm es eva saivvav. Yimba pevpa owai es eva saivvav, wo yimba pevpa tuvpa petheinv, nomba indhanamba temba lihvpa, saivolmba. Wavro, Sesoa si yemba hukum vewol vevav noindava. ");
INSERT INTO wrs_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","Yimba pelimba deswuhawol vivpa, deuvpa pevm muehrombol vinv, eva wohva nomba pevm. Sembayangmba tokwonamba dasalm yimba ambo Sesoamba viniv, honam pevna wevsakoklam leslala vewolalm. Wavro, Sesoava si yemba mendekli kinsomb plothunvav. ");
INSERT INTO wrs_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","Yimba samblamona vilov, yimba lovahmana vev no provinsram no provinsram, ishuvmona vinv indhanam, os yeoa kam patvunu kavtindim. Yimba ehlana andra viv, osmba mongomba indhanariniva yemba suwiharava, yem petheinvav. Heva os himba nonamba yena wevsakoklamba enginvrava, himba temba monahulumbm suwekembelnindna monam engginvra. Wavro, Sesoa si yemba hukum vewol vevav. ");
INSERT INTO wrs_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","Yimba indhanamba os ishunv, kam patvunvm besalmonam, heva os owai, yimba novtitmungilnonoa, noinda yimba besalmonamba wohtit viv. Yimba indhanamba os ishunv, yimba piasevra ovrallava tempelduvmba, temba owai, eva mani mendeklimoma. Heva os yimba piasevra ovrallava golmba, no ten tempelduvrava dihelvm, temba noindava mendekli moamba lohv, yeoa noindaoa wohengivm. ");
INSERT INTO wrs_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Yimba novtitmungil undhui vilov, yimba os ningvma, golva nomba sena nalohv Sesoana novrava, wo heva os tempelduvpa owai? Yimba tit viv, manara, tempelduvpa kuvhoav Sesoana novrava, wo noindava golva eva sena nalohv. ");
INSERT INTO wrs_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Yimba eva osta ishunv indhanamba, yimba pevna moamba yivalthawol ovivrava, osva altamba sevrivrava, temba owai, eva mani mendeklimoma. Heva os yimba pevna moamba yivalthawol ovivrava, mana emamba sevrivrava, nomba temba altasrava hohlolohmanavrava Sesoamba, temba noindava mendekli moamba lohv, yeoa noindaoa wohengivm. ");
INSERT INTO wrs_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Yimba tit wohviv, yimba os ningvma, mana emava altasrava temba hohlolohvpa, nomba temba sena nalohv Sesoana novrava, wo heva os altava owai? Yimba tit viv, manara, altava kuvhoav Sesoana novrava, wo noindava mana emava nomba temba altasrava hohlolohvpa, eva sena nalohv. ");
INSERT INTO wrs_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Hillu, himba nomba hevna moamba yivalthawol ovivrava, osva altamba sevrivrava, noindava samblanam wohelohvra, mongasalva owai, vera, alta eva mana ema altasra ten sena hohlolohvm Sesoana novra. Wo noinda honi sambla yivalthawol wohevev henonamba moamba. ");
INSERT INTO wrs_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Wo eva himba nomba hevna moamba yivalthawol ovivrava, osva tempelduvmba sevrivrava, noindava samblanam wohelohvra, vera, tempelduv eva Sesoa hev, noinda ten wohavm. Honi sambla yivalthawol wohevev henonamba moamba. ");
INSERT INTO wrs_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Wo eva himba nomba hevna moamba yivalthawol ovivrava, osva Sesoana kembelmba sevrivrava, noindava samblanam wohelohvra, vera, Sesoana vuhe, eva hev, noinda ten wohwulavm kuwul. Honi sambla yivalthawol wohevev henonamba moamba. ");
INSERT INTO wrs_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","Yesusva mendah osangas ishunvna Varisinindm katekism, unna, yimba samblamona vilov. Yimba snakand lohohmomba engiv, noinda yimba karivalsowa pevnamba puvrombol viv, Sesoamba eunumbul dembreuhv. Memba yimba lehra viv, heva os lohohmomba mendekliva yimba engivmoa, wo noinda yimba owapevmba beswonamba nesmos avramana vevmoa, yimba und avramana vevmoa hemba, wo eva yimba Sesoamba keknamba undnahonamba amnavmoa. Hona lohohmomba mendeklioa yeoa wohengivm temura eusilnahonam. ");
INSERT INTO wrs_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Yimba indhanamba os ishunv, kam patvunu, heva os yimba novtitmungilnonoa. Yimba mendekli andra viv, Sesoana moamba engalmba ambo snakand, heva os moamba kinilmba yimba owai, engivmoa, eva ningvmoa, owai. ");
INSERT INTO wrs_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","Pevna mokna pirinna yimba hevm beswonamangas novnovhora ambarasisva poswol viv, heva os no innemba yimba no pirinsrava hlavpa, no innemba yimba pevna ehlanamba dumbvmoa. Owai, yimba daosnamona ishunv indhanamba, innemba yemba daswolalmba, wo yimba pevmangas osva ningv. ");
INSERT INTO wrs_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Wo noindava yimba pevm lehwol viv novtitmungilmsna. Yeoa pevna wevsamoa weihaloh avramana vevm, wo Sesoava si yemba nongalvrava, ovra, eva hena pirinna moknamba nihvuhinhui naluhunv, ambarasis merasis. ");
INSERT INTO wrs_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","28","Yimba samblamona vilov, yimba snal av, oi pokama, indhanamba huhmoh vriv hemba, heva os merava no nalohv indhananakel eva mana vemanung. Indhanamba yemba nungeilvrava, uvra, besal, heva os owai, yenamba nengavnangva sahoklal luhunv. Yimba samblamona vilov, yimba moamba besal ishunv, heva os yimba pevpa mindnam sahonam wohviv. Wavro, Sesoa si yemba hukum vewol vevav. ");
INSERT INTO wrs_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","30","Yesusva mendah ishunvna katekisnam Varisinindnam, velokusa vinvna hena wevsakoklam. Ona, doara doa yena simbehumunpev helvakomo vewuvmona vivna Sesoana moashulnindmba. Daipotava yimba noinda no besal moashulnindna pokamava huhmoh vewol vriv. Yimba os ishuv, kava nonamba doarava lovahtava, temba simbehumunmba anamba, ata kava kolvrowol vita Sesoana moashulnindmba, helvakomolmba owai. ");
INSERT INTO wrs_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","33","Yimba temba osva uvpa, yimba pevm pusvund viv os, kava indhanakokla, noinda yimba osva uv, kava nonindta, ten Sesoana moashulnindm helvakomo vewuvmona vivnam. Wou, wohvilango, os ten pev velm vivm, no wevsana, Sesoana moashulnindm helvakomo vivnam, wou. Yimba sahoklal av, saipusuhlamsna, wo Sesoava si noinda yemba hukum vewol wohvevav suwekembellava. ");
INSERT INTO wrs_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Kava si wolapra vevav kavna andranindmba homba. Monglava si moashulnindilm, monglava si nonoanindalm, monglava si katekisalm. Wo heva os yimba si hemba helvakomo vivra monglamba, monglamba si yimba wekal vivra tira sena, monglamba si yimba helvowol vivra di sembayangduvra, os wohengilwul vevra no kotaram no kotaram. Yena arahumunpev hona wevsava doara vivna, wo noinda yimba viluwulkovvna. ");
INSERT INTO wrs_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","36","Si Sesoava sewonam yemba hukum vewol vevav. Indhana besalva nemetva temba anamba, yena simbehumunpev helvakomo vivna, noindava. Sesoava si yemba sahonam vinvav esesm. Seilkakalmba hevm Apelm helvakomandhina, sismba Sekaraia, Berekiana ombolm helvakomandhina. Di hevm tempelpulmera hovrahovra, vena, tempelm piana, eva altasengm piana, di helvakomandhina. Tanamolnam esesmba hona wevsakoklanamba si Sesoava yemba indkumbimba piprinvav. ");
INSERT INTO wrs_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Yesusva mendah osangas ishongeinvna, unna, yimba Yerusalemnindva, yimba Sesoana moashulnindmba helvakomo velvohv, nomba temba Sesoava yemba wolapra veluhunvpa. Monglamba yimba honna welhalvohv, helvakomo velmba. Elsus kava und vewol vev yemba, holvuih velm kavna anglasingi ayam avalmsna, os men ayam hevna otolm komawol vivm hevna anglakomonam. Heva os owai, yimba beswonamba kalmangasva avmoa. ");
INSERT INTO wrs_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Wo noinda yena tempelduvpa, Sesoava si wohwuleihinvav, si hevho deuvs lohvav. Hillu, hengava si yimba kamba nunglivavmoa, heva verava, ovi pethai imharavhoawolvrava, os. Yimba si os kamba hengava nunglivav, kava petharamba provrava, yimba si os uvra, ");
INSERT INTO wrs_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Sesoa kanothona Yesusmba, himba men prov, Sesoa mendeklina andram velm. ");
INSERT INTO wrs_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","2","Yesusva tempelliniva wonvenamba, os wongana hevna aonghal mahalnindmba. Hevna aonghal mahalnind umnina, nonglo, tempelduv, eva mongla deuv hevm besal snal i. Hev unna, lehra, heva os ungundva si ambrava, tuploihapuv vevav. Himba honmba si mongova nungthuvavmoa owalsrava, owai. ");
INSERT INTO wrs_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Yesusva olora avna, os ningthiv, oliv denwit olo, tempelduvmba nonglapiha vawovna. Hevna aonghal mahalnind ambanamba, umnina dendwolla, hona yena moarava, ungundva henanam si phovav? Wo manamsna si kava nunglirava, wo noinda nonorava avra, Kristusva henga prov, pethava doa mueisowa vev? ");
INSERT INTO wrs_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","5","Yesus unna, beswonam aevvm, indhanamba si yemba pepehmoa eishoraohvra, kava Kristus. Mindnam indhanamba si pepra vevra, wo eishovra dasalm, wo indkumbiva indhanamba ningvra, lehra uv, Kristus tanam memba. Heva os owai, manam yimba hilwilvav. ");
INSERT INTO wrs_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Wo eva mongnahalmba yimba si hillivra, daos uhulengav hevm mongnindmongo, yimba si weitm hillivra. Monglamba ambo yimba si vuvimora hilwilvra, os ten nolhra daos uhulengav. Heva os owai, yeoa beswonam ningvm, manam yimba duus vivav, temba owai, ovimba pethaimba mueisowa velmba. ");
INSERT INTO wrs_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Mongona kotanindva si mongona kotanindmongo hevm daos ohohavra. Owous mendekli si singthapravav, wo eva nenvpa si mendekli vungu vinvra no kembella no kembella. ");
INSERT INTO wrs_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Hona kinmba si os maim uvra, seilnovra ungevlirinim espeta helvaketha vromana vev kinsombolm. Si heva sewonam mindnamba kelathamnavav. ");
INSERT INTO wrs_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","Ungundva si yemba kekaiv vivrava, perkara vewol vivra, wo yemba kin pelhola ovinvrava, wo helvakomo vivra, kana aonghal mahalnindmba. Indkumbi indhanamba si yemba musk vinvra. ");
INSERT INTO wrs_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Wo honanamba indhanamba mindnam, memba kamba engivpa, si kamba wuleihivav, hengava engvrivavmoa. Himba si hevm owalmongo musk avramana vevra. ");
INSERT INTO wrs_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Wo indhana eva mindnam si pepra vevra, dasalm uvra, kava tanam Kristus ishov, kam hillivm. Indkumbi indhanamba si hemba patvunvra. Yimba manam hilwilvav hemba. ");
INSERT INTO wrs_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Indkumbiva si wevsakoklam engivra, wo eva indkumbiva Kristusnindna wevsava, owalmba alalhmana avralmba, himba si wuleihivra. ");
INSERT INTO wrs_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Wo indhanamba monglava himba nomba kalmangasva keknamba lovahvrava, osangasva kinmba honamba pulangavra, wo hemba kava si sandhavav vuhe besalla, himba si di wohaevvav beswonamba. ");
INSERT INTO wrs_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Kana moamba arana nemeltindim, himba si ilvahinvav mana vemara no pethanindm no pethanindm, osm indkumbiva si aong lalahapravra, hellelmba, Yesusna moamba memba, wo pethava si os wohmueisowa vevav. ");
INSERT INTO wrs_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","Sewonam yimba katindiva si nunglivav, mana vemava sahoklalva Sesoana moainal vuherava tempelmerava. No mana vemakoklava, nemet doara moashulnindrini Daniel novol vewol venam. Sesoava si os ovav, owai, sahoklal. Himba nomba hona moamba tombairiniva nunglivrava, beswonam ningvm, plalm beswonam velokusa vivm pevm. ");
INSERT INTO wrs_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","18","Wo nonamba yimba nunglivrava, yeoa hona indhanaoa memba yimba huiva Yutiaprovinsrava aevulvpa, yeoa wohbukethango oloram. Indhanariniva hevna peillava andra vevrava, himba hengava sihavavmoa, hevna lapolamba dombolmba, owai, ambo nis wohgavra. Indhanariniva hevna osorava andra vevrava, himba hengava gavavmoa deuvramba, hevna lapolamba dombolmba, owai. ");
INSERT INTO wrs_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Wavrapeta ungevlim nom enakinnindm, eva no otolm, ten lupulielm wulapravm, himba owai, si es eva pemba bukethungu vevra no kindava. ");
INSERT INTO wrs_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Ata homeis phovm seponam, eva sapturam, vah iaevul okombanam. Yeoa Sesoamoa osihminivm, kam wonawo hona mendekli kindaoa, ata homeis no kin kam mera vevm nonam. ");
INSERT INTO wrs_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Wo hona kinmba si phovav, si honi wohkuvhoawol vevav doaraminimba, wo sewonamba snamba si owai sismba. ");
INSERT INTO wrs_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Sesoava doara doa ona, hona kinnamba kava si okombava ambo tovolahavav, indhanam homeis si wohsihavm. Hona indhanamba kava memba kavalmba kikih vewol venamba, homeis si wohsihavm, kava si hutemotho vrevav nambaiva hona kinnamba. ");
INSERT INTO wrs_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","24","Nonamba mendekliva kinmba phovrava, indhanamba si ambvrava, moamba dasalm ishuvra, kava Kristus, kava Sesoana moashulnindrini lohv. Himba si andrava mendekli vivra indhanana novra, ambo dasalm deiswitvra. Himba si nomba eva deiswitvrata, Sesoava temba kikih vewol venamba hevmba, heva os owai. Sewonamba yemba indhanamba osva unvrava, Kristusva men, manam yimba hemba hilwilvav, owai. ");
INSERT INTO wrs_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","26","Kava yem ishunv kavna nemeltindim daipotava, yeoa hillivm, yeoa pevmoa kokolma avramana vevm. Yemba no moangakalanindva osva unvrava, Kristusva doa proi sungeitrava, manam yimba hilwilvav. Himba os untava, men hovra kethalohv, manam yimba hilwilvav, owai. ");
INSERT INTO wrs_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Manara noinda kava si hengava provrava hona petharava, indkumbiva hona petharava si kamba mongawulm nunglivav, provrava wingmsna. ");
INSERT INTO wrs_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Pivva nongalwol viv, endandva prowol vev tatanungra di, pivva osva nonora avra beswonamba, men honalhra nunglav. ");
INSERT INTO wrs_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","Yesusva mendah ishunvna, Hona mendekli kinmsna si provav seilmba hona petharava, wo hengava okombava si mueisowa vevra, weisva wohsihavra, henga owai. Paiva ovriniva velaral vevra, wo mana vemava nomba keknamba wosalohvpa ovrava, nomba wohvelaral vevrata. ");
INSERT INTO wrs_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Kava arana ombol lohv, mana vemava ovriniva si lehvravav kam. Wo indhanamba indkumbiva hona pethanindva vavawonamba si nomba nunglivrava, vevra, wewusowa ovra, pekmek vungavra. Wo sism si kamba nunglivav, osva kava tekomerini pihavrava homba. Kava kavnakambara huhmohnahonam si ambo pihavra, keknamangas os maim oi, Sesoa hev. ");
INSERT INTO wrs_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Indhanamba si hillivav Sesoana vuvwitmba, kava si os wolapra vevav kavna ovsongolnindmba indakonda kembellamba hona petharava, wo he si mongawulmba pulundthueivav kavtindimba kaindava, nomba doara hev Sesoa doa kikih vewol vungana di di di indakonda hona petharava. ");
INSERT INTO wrs_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","33","Fikdenwit si yemba numhowol vevra, nonamba himba vlelva peholothovrava ningilva, yimba os uvra, doara velohv, osombva doa murapeta vev. Wo ambo osangasta, nonamba yimba nunglivrava pevna novnamba honamba, kava memba yemba ishunvpa, yimba si os nonorava avra, doa murapeta vev. ");
INSERT INTO wrs_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","35","Yimba hona indhanamba daipotaminiva, monglava yimba si mendah aevulvra, wo honamba si os phovav mana vemava. Ovi pethaiva si mueisowa vevav, heva os kana moamba si wohlohvav, mueisowa vevavmoa, indhanamba si wohengivra yunalm. ");
INSERT INTO wrs_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","Indhanamba tit vivra, henanam si kava provav, ovsongolnindva senaminiva himba tit viv, kava kavpa tit vev, Sesoa ara hevangas nonorava av kana prolmba. ");
INSERT INTO wrs_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Yeoa kokolomb avramana vevm pevmoa, kana prolmba si osta vevav, nemet ten pueumb pronam Noana novra, indkumbiva si evekingil vrivav. ");
INSERT INTO wrs_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Hona indhanamba indwonam vaomana velavna, inne nevna, onganung vevna, indwonam anonglakaka vevna, nonamangasta himba maim vivna, Noava wonsihavna sip mendeklirava. ");
INSERT INTO wrs_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Nonamba Noava wonsihavnamba, nomba indkumbiva pethanindva wohtit vina, osmba kamba doa kinmba mendekli prunv, wo henanam pueumb provna, os mera wohvena. Kava provrava, si osta vinvav indhanamba. ");
INSERT INTO wrs_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","41","Kava provrava, sambla indhanariniva si osora andra evevra. Mongomba kana ovsongolnind waiangavav, mongova di avav hevho. Ungevlirini samblava wonda honawol avahavra, kana ovsongolnind mongomba waiangavav, mongova di avav hevho. ");
INSERT INTO wrs_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Yimba tit viv, homba henanam kava si provav, yena mendekliva, noinda osva ambo novkaka aevvm, manam yimba shathavav, undundna aevvm. ");
INSERT INTO wrs_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","44","Deuvna aralva nonorava lohtava, osva hona sinim ata yukovnindriniva provav, wo owai, lithavavmoa, himba wohkekalvho vrowovav yunalm hevna deuvmba. Wo yeoa osangas wohaevulvm, novkaka kana prollamoa, undundna aevvm. Kava nonam si provav, homeis si yimba os uvavm, detiva ata owaimi? ");
INSERT INTO wrs_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Kava lehwol ovov yem monglana wevsam, nom ten undnahonam lovahmanavm, himba nomba kamba keknamba nengavnangva wulluhmanavrava. Himba snal maim ui, kuwul hevna andranindrinim pusvundthoav, yeoa kana andranindna innena kuwul wulluhunu, nonamangas dumbunvm, ten hlalm vevram, kava mongona petharam dawonam gav. ");
INSERT INTO wrs_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","47","Nonamba kuwulva hengava provpa, no hena andranindriniva beswonamba vetava, moamba wohengmanatava, no kuwulva hemba indk vethamnavrava, wo eva himba no andranindriniva indk vethamnavrata. Lehra, no kuwulva omnavav nom hevna andranindrinim, daipotava kava men yemba pusvundthoav, kavna manam manam ye si kuwulva wulluhunvav. ");
INSERT INTO wrs_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","49","Wo heva os no andranindriniva sahoklalva lohtava, himba os nengvra, kana kuwulva si lelnamba provavmoa, weisva mindnam si khuawol venavav, homba prolmba. Wo no andranindriniva si os helvowol vevra hevna owalmba andranindmba, eva ambo lohkohangas vevra mongla owalmongo sehelmongo, daip hlalvohmana vevra. ");
INSERT INTO wrs_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","51","Wo no kuwulva hengava si prorava, andranindriniva evekingil vrevav, omnavav, yimba os nengvna, detiva ata owaimi? Wo no kuwulva os bui vevav no andranindrinimba, himba si di desvhoavav vuhekoklara, ten no kelsombovhol indhana aevulvm. Himba di si wewusowa owovra, kava kav ambo vivna. ");
INSERT INTO wrs_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Kava nonamba provrava, Sesoana nemeltindiva si os avra, okombava pelangalla avnamba, 10pelara ungevliva angavna, innem hlalm. Hevna ungevlirinina sehelna deuvram angavna, hena nemel tlalva ata himba provav, wo himba innemba mendekli waihlavav mongawulm sinimba. ");
INSERT INTO wrs_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","4","Hona ungevliva 5pelara himba doara ningna, lampum kerosinm nonahonam iangalmba lampumba. Nomba owalva 5pelarava, owai, no nengavnangva vrinamoa, himba lungi anganamoa mongova ombamba kerosinva hevna lampuramba, ambo lampuangas nis. ");
INSERT INTO wrs_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Doa hev anganamba sehel unguvlirinina deuvram, di ambara nengviluwuvna. No sehel unguvlirinina tlalva mendah provnamoa, himba wenokomba vawovna, noinda venamba, nomba ungevliva 10pelarava nin shatha. ");
INSERT INTO wrs_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Heva venamba, sihovranam indhanarini mongo dandwonam di pholohongonam, nunglu no indhanarinim, hona ungevlirinina tlalva ten prov monam, pioa angarava, suwihie, und wailotholvohra. ");
INSERT INTO wrs_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Nomba ungevliva 10pelarava pulvonamba ninmerini, lampum hevnam sishona vewol vilangavna, unna, pina lampuva ata beswonam taprinvav, ata pivva innemba os hlavav. ");
INSERT INTO wrs_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Nomba 5pelarava owalva, himba hevmba doara beswonamba ningnamoa, himba doarava keromba kokolma vewol vinamoa, hev nom owalm 5pelaram unna, kanamba lampuva doa vuthawol vini, kam pevna kero sovhomoakot viwul vinu. ");
INSERT INTO wrs_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Owal noi 5pelara, doara ten beswonam ningnam, doara ten kero kokolma vewol vinam, hev unna, owai, ata kanamba kerova huti vinvav, yeoa tokoram angarava, sovawol vihelvo pevmoa. ");
INSERT INTO wrs_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Nomba 5pelarava os angana, kerosinm sovawolalm. Henasira no sehel unguvlirinina tlalva prunna, wo nomba 5pelarava ungevliva, himba temba doarava beswonamba nengavnangva kokolma vewol vinamba, himba beswonam vilivna, lampu lawol vina, doa os saivna, innemba hlalmba. Indhanamba tuvpa os petheina keknamba. ");
INSERT INTO wrs_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Nomba ungevliva 5pelarava, temba keromba sovawolalmba angavnamba, henga ambvna. Doa di tuvra olvohvna, mendekli mendekli, kam tuv velaihinu, ");
INSERT INTO wrs_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","hev unna, owai, yimba kana sehelva owai. ");
INSERT INTO wrs_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Yesusva mendah osangas ishongeinvna hevna aonghal mahalnindmba, doara ningvm, mi kokolma vinivm kam, manara yimba tit viv, henanam kava si hengava provav. ");
INSERT INTO wrs_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Yesus henga ona, kava nonamba provrava, Sesoana nemeltindiva si os vivra, mongo kuwul lohvra, wo himba galm vevra mongona ehalkembellam. Hev onbavavm hevna andranindm, unvav, yeoa kanasiraoa kana bisnisandra vewuvu. ");
INSERT INTO wrs_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Himba galmba vevnamba, himba boasna lesvhoawol vevna hevna nengavnangna hevna andranindmba, nengna, hona indhanariniva lehra lohv bisnisandramba, honamba mongova besalpeta bisnisandrarava, nomba mongova owainonoa bisnisandrarava. Doa hev moang vinv minindrinimba K5000ra, pethamnalmba K2000ra dembraohv, wo eunillinimba K1000ra dembraohv, unna, kana dimoa honaoa milowol vewuvm, bisnis nona vewuvm. Wo doa os sandhalaha wohgana. ");
INSERT INTO wrs_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Kuwulva gavnamba, no andranindriniva temba K5000va dombnamba, himba nungi lelnam nona bisnisandra vevna, venamba, hengava himba K5000 dombna, wo os lohmanana mongawulmba K10,000. ");
INSERT INTO wrs_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Eva osta nomba temba K2000va dombnamba, himba inganamba, nona bisnisandra vawovna, venamba, henga mongla K2000 dombna nona, wo os lohmanana mongawulmba K4000. ");
INSERT INTO wrs_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Heva os no indhanariniva, memba K1000va dombnamba, himba bisnisandrava venamoa, himba kuwulna diva singvena pethamera. ");
INSERT INTO wrs_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","Kuwulva diva os ana, weisva mindnam khuawol venavna, wo no kuwulva pronamba, unna nom hevnam andranindm, kava kavna dimom yemba wonisholm vev, osm ora yimba hona samblamong indhanamba beswonam vina, ora owai. ");
INSERT INTO wrs_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","No andranindriniva ten K5000 dombnam, onehmanana eva noi, ten hev henga bisnisandrara K5000 dombnam. Yimba kamba K5000 dembrahonamba men, wo eva men monglava K5000va, kava milowonamba kavna bisnisandrarava. ");
INSERT INTO wrs_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Doa no kuwul omnana no hevna andranindrinim, yimba beswonam vena, yimba andranindrini besal, yimba kamba undnahonam andra venana. Yimba andrava beswonam vena kana dinamba, heva os mani mendeklima diva. Daipotava ata kava yemba mendekli diva dembraohvav, nonam andra velm. Sihao, yem ka waiai indwonam. ");
INSERT INTO wrs_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","No andranindrini ten K2000 dombnam, kuwulm nom onehmanana eva noi, ten hev bisnisandrara dombnam henga K2000, ona memba kavna andrarini. ");
INSERT INTO wrs_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Kuwul omnana, yimba lehra vena, yimba besal andranindrini lohv, yimba kamba undnahonam andra venavna. Yimba beswonam andra vena kana dinamba, mani mendekli dima. Daipotava kava ata yemba mendekli diva dembraohvav, andra velm nonam. Hom sihao, yem ka waiai indwonam. ");
INSERT INTO wrs_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Andranindrini noi ten K1000 kuwul dembrahonam, hev omnana kuwulm, kava os nengna, yimba kelsombovhol lohv, yimba osonnava nis ambo dumbunv, yimba pevpa wolavmoa, owai. ");
INSERT INTO wrs_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Wo kava noinda yenapenam venamba, kava yena no K1000va os komana pethamera, nonapenam ata homeis indhana yukov vivm. Men, dombo. ");
INSERT INTO wrs_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Kuwul omnana, yimba aivol andranindrinikokla, yimba tanamba osva nengtava, kuwulva os vewol vev hevmangas, ");
INSERT INTO wrs_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","ata yimba kana diva dembhata benkra, hengam moaowohonam, wo daipotava ata kava iavta K1000, eva no benk kam moaowohonam huhlimnitam, heva os owai. ");
INSERT INTO wrs_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Doa kuwul unna hevna andranindm, no K1000 dumbu hona andranindrinikoklanamini, wo nom dembreihu, ten kana K10,000 iavnam. ");
INSERT INTO wrs_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Noinda osva viu, himba nomba mana vemamba mindnamba iavrava, wo Sesoava si hemba henga mindnam venavav, wo manam eva himba si ovav. Heva os himba nomba eskandva iavrava, Sesoava si henaminiva henga dumbunvra henaminiva. ");
INSERT INTO wrs_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Sna indhanarinikoklamoa kanaoa, yeoa indkumbi kekeloa ovrarava amballam, sikulmeram pilpipuvu. Himba di owovav, kava doa doara kav sahonam lohna. ");
INSERT INTO wrs_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Kava arana ombol, sewonam sism henga kava si provav kuwul mendeklimsna, kavna ovsongolnindm wonprovav. Kava si kavna kursira avhoarava, indhanam mongawatilm huhul vindthoalm, hindm hindm indakonda pethanindm kavna novlomossis. ");
INSERT INTO wrs_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Wo si os kava lesvhoawolvra, vera, mongnasis pulundthoavra, eva mongnasis pulundthoavra, besal indhanam eva indhanakoklam. Si maim ora, devtatana kekalvhonindrini hevna devtatam pepemowolv, vei memetatana, eva sipsiptatana. ");
INSERT INTO wrs_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Nomba besal indhanamba kava si kavna nihanasis pulundthoavav, nomba monglava kavna sihanasis. ");
INSERT INTO wrs_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Wo kava si os unvav nomba kavna nihanasisnindmba, Sesoava doa yemba awothowol vena. Nemetva Sesoava pethava vevnamba, himba yemba pusvund vena hevna nengavnangnamba, hevna nemeltindilm alm. Men daipota yimba saivv hena nemeltindilm, wo beswonam eivvra, ovra, hevna towandalnonoa. ");
INSERT INTO wrs_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Kamba ponmba venavnamba, yimba kamba deuhvna, eva kamba pehava venavnamba, yimba kamba po vreuhna nelm. Kava yena kembellava lohmana vinvna, yimba kamba pevna deuvram das ovrivna. ");
INSERT INTO wrs_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Kava pikianhuiva vevnamba, ye kamba dembrehuvna pikianmba, vewol velmba. Kava uvavulmungilva dihelvnamba, yimba kamba tungwulaevvna. Kava buimerava avnamba, yimba kamba nonglahalv vrevna, moa waiishuvna. ");
INSERT INTO wrs_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","No besal indhanamba si os kamba umnivra, henanam kava tanamba yemba osva nunglina, ona, pon venav, inne daholvohra? Henanam kava yemba osva nunglina, ona, peha venav, po vraholvohra? ");
INSERT INTO wrs_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Henanam kava yemba osva nunglina, ona, ungundrini prov, kavna deuvram das ovri? Henanam kava yemba osva ona nunglina, malohui, yemba kava os dembrehuna? ");
INSERT INTO wrs_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Henanam eva kava yemba osva nunglina, ona, uvavulm dihelv buira, yemba nonglahalv vrena, moa waiishuna? Kava wohtitviv honamba. ");
INSERT INTO wrs_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Wo no indhanamba kava si os unvav, yimba osangas wohvinvnam beswonamangas kana nemeltindimba. Himba hona indhanamba ambo nihil eusilna lovahv, kinmba heindam ongunv, wo yimba kolvrowol vivna. Nonamba yimba hemba beswonamba vewol vivnamba, yimba nonamba temba kam vinivna. ");
INSERT INTO wrs_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","Wo kava si os unvav no indhanakoklamba kavna sihanasisnindmba, ango kanaminioa suweram. Sesoa yemba hukum vewolalm vev pevna sahoklara. Nomba temba suwekembelva, Sesoa doara heva hev vena, Setanm eva hevna andranindm hevna sahoklara hukum vewolalm, eva yeoa angarava, no suwekembella aevulvm yunalm di. ");
INSERT INTO wrs_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Manara, noinda kamba ponmba venavnamba, yimba kamba innemba deuhvnamoa, owai, kamba pehava venavnamba, yimba kamba pomba vreuhvnamoa, owai. ");
INSERT INTO wrs_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Kava seilnovrava yena kembellava prunvnamba, yimba kamba sehmoa ovrivnamoa. Kava malohuiva vevnamba, yimba kamba moan ovrahunamoa osva, noi vetho. Kava uvavulmungil avna buimera, heva os yimba mongova kamba ononglanamoa, moamba waiishuvnamoa, owai. ");
INSERT INTO wrs_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Wo nomba indhanakoklava si os kamba umnivra, mendekli, henanam kava yemba osva nunglina, ona, ambo sahonam av, wo heva os kava yemba kolvrivnamoa? Henanam yemba ponmba venavna, pehava venavna, ungundrinisnamba provnamba, malohuiva, uvavulmungilva dihelvnamba buimerava, wo kava yemba kolvrivnamoa? Kava tit viv nomba, manara yimba kamba ombamorava osetv? ");
INSERT INTO wrs_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Wo kava ishunvav hemba, yimba no indhanamba nihil eusilnamba kolvrowol vivnamoa, owai, yimba nomba temba vivnamba, yimba kam meis wohhehara omnavna. ");
INSERT INTO wrs_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Wo no indhanakoklava si angarava, suwekembella yunalm wohaevulvav, hevna sahaposwora. Heva os no besal indhanamba si wohaevvav yunalm kavnahonam arainda. ");
INSERT INTO wrs_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","2","Yesusva hevna aonghal mahalnindmba ishopieinnamba, hev unna, sambla nin vewullava, pimba si os Pasova innemba mendekliva hlavav, wo ungundva si os kamba kikih vrivav Romduangna kuwulna englisramba, wohtvav, lepetheiu hemoa. ");
INSERT INTO wrs_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Yesusva os ishunna hevna aonghal mahalnindmba, wo nonamba Yerusalemrava sembayang andranindna kuwulva eva mundilva mongawulm kusovna, moam moakalthalm, Yesusm indkokla vrelm. Himba di kusovna sembayang andranindna kuwulna deuvra, hena nihilva Kaiapas. ");
INSERT INTO wrs_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","5","Hev una, pimba si kevrivav Yesusmba poaita, wo Romduangm osihminivav, helvakomandhalmba. Owai, manam pimba honamba osva vivav hona innetihna novrava, si indkumbiva pimba osva nungeilvrava, wo daos uhu wulengavra osangas. ");
INSERT INTO wrs_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","7","Yesusva Betani kembella avna Simonna deuvra, no Simonmba nemetva himba doara lombamungil lohna, wo henga doara hoai venana, besal lohvna. Himba inne Yesusmba waihlavna mongawulm, mongo ungevliriniva Yesusindam murapetam provna, hev vena, welsanda botelnahonam longpethana, no welna botelna diva os lohvna i. Hev Yesusna kura sovhomnavna novnavhora. ");
INSERT INTO wrs_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","9","Yesusna aonghal mahalnindva hemba nunglivnamba, himba wuspromana venavna no ungevlirinimba, manaram osva himba hevpa vev, welm ambo eunumbov? Himba doara ata no welva guata maketram, wo di nona dombota, wo pivva ata diva deiswilta nom innehuinindm. Heva os owai, welva doa himba sovhopiai. ");
INSERT INTO wrs_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","11","Yesusva helwolnamba, ona, os umniv no ungevlirinimba. Hev unna, manam yimba hona ungevlirinimba okusviv, himba kamba lehra venav besal hevm. Indhanamba innehuiva mindnam angu vev, wo sna indhanamoa yeoa kolvrowol vivm ambo nis pevna undna. Heva os kava si yemba wonavavmoa yunalmba. ");
INSERT INTO wrs_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Ungevliriniva kamba welsandana sovhomni, sewonamba kamindmba indhanamba si osta vinivav, nonamba kamba dahavrava. ");
INSERT INTO wrs_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Temba kamba ungevliriniva venaiva, indhanamba si kana besal nemelmomba wulvahmana vevra indakonda pethara, indhanam ishuvmonalm. Wo os himba si indhanamba owalmba eishorahungu vevra hona ungevlirinina moamba, memba himba kamba venaiva, wo indhanamba si os ningvra, lehra hevm venata. ");
INSERT INTO wrs_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Mongo noi Yesusna aonghal mahalnindrini, nihilva Yutas Iskariot, hev ganamba, sembayang andranindna kuwulm unna, ");
INSERT INTO wrs_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","kam di dembrehu, ka si Yesusmba yemba holvorahunvav. Es ata yimba kamba dembrehuvav? Hev seivileinamba, hev umnina, sen mendekli ata kava yemba dembrehuvav 30pelara, wo os dembrehuna. ");
INSERT INTO wrs_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Wo Yutasva os nengvna, es hevpa kava si Yesusmba holvoholothunvav hena englarava? ");
INSERT INTO wrs_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Doa Yutanindna Pasova innetihva phunvna, nonamba temba himba hlalvohvnamba rotiva yishuiva. Yesustindiva ambanamba, hev umnina, hi ata kava innemba kokolma vivav, osm pivva ata detiva di hlavav? ");
INSERT INTO wrs_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","19","Yesus unna, ango Yerusalemram, wo umnu no indhanarinim, kava nonora lovahv, pina guruva os oi, kanamba doa murapeta vev, yena deuvra ata kava wonnevav Pasova tihinnemba kavtindimba. Yesusva osva ishunnamba hevna aonghal mahalnindmba, doa himba os angana, innemba kokolma velmba. ");
INSERT INTO wrs_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","21","Okombava doa singvel vevna, Yesusva hevna aonghal mahalnindm wonavhoanamba mongawulm, inne wonnevna. Hev unna, tanamolnam, mongo honi yerini ata kamba ungundna englarava holvorahunvav. ");
INSERT INTO wrs_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","23","No moamba hevna aonghal mahalnindva hillivnamba, mindnam duus viwul vevna, Yesusm sah ovruwul vevna, uvna, mendekli, an hevpa ata vevav? Yesus unna, honi mongo yerini, men piv inne hlaim mongawa sospandini, henongas ata honamba kamba venavav. ");
INSERT INTO wrs_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Kav arana ombol lohv, kava wohengvav doaraminim tombaimom. Wo noindava himba ata os kamba ungundmba holvorahunvav, wo os ata kamba dahavav. Heva os kava no indhanarinimba os omnav, wavrapeta, yenamba si indkoklava mendekli lohvav, eva si bui vera mendekli. ");
INSERT INTO wrs_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Yutas hona indhanarini ata Yesusmba hevna ungundmba pusvundthueinvav, hev omnana, guru, ata ka vevavma? Yesus omnana, osta pev ten ovm. ");
INSERT INTO wrs_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Mendah wonnevna, Yesus roti vranamba, Sesoam omnana, lehra, wo doa popowol venamba, hevna aonghal mahalnindm daswolungu vevna, hlao honaoa, memba kana nihil. ");
INSERT INTO wrs_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Henga wain moknahonam vra, Sesoam omnana, lehra yimba. Hev ovrahunna hevna aonghal mahalnindm, henoi henoi nevrava, os hlao honaoa, memba kana tovolva. ");
INSERT INTO wrs_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","29","Memba tovolva moam lehvoh vev, nom ten Sesoa hev ovrahunnam nom pim hevtindinonoam. Kana tovolva ata sovhopevav, indhanam vavawonam kilumb shuawolalm. Wo noinda osva kava si hengava nevavmoa wainmba, heva verava, sewonam kana arana nemeltindiva arana huhmohsingiva avrava, wo os si kava yemba wainmba nemelva wonnevav. ");
INSERT INTO wrs_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","31","Doa hev wonnepianamba, sangalna Sesoam wonokolavna mongawulmangas, venamba, os wongana oloram, os no olomba ningthiv, oliv denwit olo. Doa di pulvonamba, Yesus unna, sinimba ata yimba kamba undnahonamba ningminivavmoa, manara doaraminimomba os novol velohv men, Sesoava os ona, sipsipna kekalvhonindrinimba si kava helvakomandhavav, wo no sipsippa si os bukethavav. ");
INSERT INTO wrs_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Doa henga si kava beswonam phovav, wo kava si os gavav Galili provinsramba, yeoa dom ambo kaindamoa. ");
INSERT INTO wrs_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","34","Pita omnana, Yesus, nomba ata yemba undnahonamba ningminivavmoa, heva os kava owai, osva vevavmoa. Yesus omnana, hona sinim ata yimba samblamongolm osva owovav, kava tit venav Yesusmba, os ayamba ata ophovav. ");
INSERT INTO wrs_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Pita omnana, owai, eva kamba helvakomandhuwiltava yeimba, kava osva ovovavmoa, kava tit venav hemba. Owalva nomba hevna aonghal mahalnindva osangas mongawamoa ishumnivna Yesusmba. ");
INSERT INTO wrs_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","37","Yesusva hevna aonghal mahalnindmba wonganamba Getsemani petharam, unna hem, hui yeoa dawonam aevulmanavm kamoa. Ata kava dom gavav, sembayang velm. Samblamong indhanam wongana hevpa nihrava, Pitam Yemsm Yonm, ehallapetam os wongana, mindnam os duus vevna i, kin mendekli plothopiha venavna. ");
INSERT INTO wrs_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","39","Hev unna no samblamong indhanam, kava mindnam duus vev, os kava nengv, ata kamba dahavav. Yeoa hui novkaka eivvm, kava sembayangmba vevrava. Himba ona gasambaihana, novlomossis pethara lithanamba, ona, ara, hona kinwondaoa kanaminioa nengasvo. Os veo, ten pev nengvm, osva owai, memba kava nengvpa. ");
INSERT INTO wrs_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Yesusva phonamba, henga dom gavna, di hevna aonghal mahalnind samblamong eivvnam, heva os owai, himba doara ninpol kokoral vena. Hev omnana Pitam, yimba hona samblamong indhanamba, owai, es eva yimba novkakava kamongova eivvav dawonampetamba. ");
INSERT INTO wrs_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Yeoa novkaka eivvm, Sesoam osihminivm, ata homeis yem plel vevm hona kinda. Pevna undnahonam yimba novkakam aevulalm vev kamongo, heva os owai, nihva yenamba kosksa vilunv. ");
INSERT INTO wrs_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Yesusva hemba dashalahanganamba, Sesoam henga hevho ishomnavna, omnana, ara, yimba hona kinmba kanaminiva pilpiapahamba owai vetava, memba kamba plothomnavpa, kava ata wohpungavav, os ten pev nengvm. ");
INSERT INTO wrs_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Hev henga pronamba, no hevna aonghal mahalnindm samblamongom nongalna, henga nin shav himba, hemba gumus vinvna, novkakamba aevulalmba. ");
INSERT INTO wrs_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Yesusva hemba henga dashalahanganamba, Sesoam ishomnavna no mongawamom, seilm hev ten ishoka vaomananam. ");
INSERT INTO wrs_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","46","Hev henga pronamba hevna aonghal mahalnindindam, unna, yimba mendah shavma, indwonam aevulvma? Kamba kevralmba, ata daipota kamba kevrivav. No indhanariniva, himba temba kamba holvorahunilmba vinvpa indhanakoklana englisrava, men wohprov. Pulvorava, pevm beswonam sishona avramana veo, hem nonglalm. ");
INSERT INTO wrs_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Yesusva mendah ona ishunna no moamba hevna aonghal mahalnindmba, Yutasva os wonphona no indhanamba. Himba mongo Yesusna aonghal mahalnindrini lohvna. Wo noi wulprovna ovlakas tenga, Yesusm kevralm. Sembayang andranindna kuwul eva mongla kuwul no indhanamba wolanga vina, unna, kevrirava Yesusmoa, hom waiambo. ");
INSERT INTO wrs_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Yutasva doara ishunna no indhanamba, temba hevpa wonganamba, os Yesusiva ata kava mosnin ohovovav, wo ata yimba os osva liheivav, ten dihi Yesusva, tenta himba, os kevru hemoa. ");
INSERT INTO wrs_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","50","Doa Yutasva nungi lelnam Yesusindam pronamba murapetam, omnana, guru, doa mosnin ohovovna, indwonam lohvm. Yesus omnana Yutasm, seh, andramba memba yimba homba proiva, veo. Doa no indhana ten Yutas wonpronam, pulvona, Yesusm kevri. ");
INSERT INTO wrs_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Doa nungi lelnam mongo hevna aonghal mahalnindrini phona, hevna ovlakas hevna kellini velavranamba, vuving vrenamba, mendekli sembayang andranindna andranindrinina angol nona singeitpingamnana. ");
INSERT INTO wrs_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Doa Yesus omnana nom hevna aonghal mahalnindrinim, osoa wuleiho, henga pevna ovlakasoa vilitho hevna kella. No indhanamba temba hevna ovlakasva wulluhpravpa, hevna ungundmba nonamba helvowolalmba, ungundva eva hevna himba ilvahvra, no indhanamba helvakomo velmba ovlakasnamba. ");
INSERT INTO wrs_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","54","Yimba tit vivma, kava osva otava, ara, kam kolvro, himba ata vengas vevav, hevna ovsongolnindm 1000pelara wolapra vevav, kamba pueil ningimnivav hona ungundnapenamba? Wo heva os owai, kava osva vevmoa, kava temura doaraminimom, ten novol velohvm, nom wohengv. Os novol velohv, kava kinmba si wohpungavav. ");
INSERT INTO wrs_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","56","Doa Yesus unna no indhanam ten kusomnanam hevm, yimba os ningvma, kava daos indhanarini lohvma, wo noinda yimba kamba wulpromnavna ovlakasna tenganamba, nonamba kevralmba? Elsus kava tempellava alohvna, indhanamba numhowol vawovna, wo heva os yimba ambnamoa domba, kamba kevralmba. Manara? Noinda ye ka Sesoana moashulnindna doaraminimomba enginvpa, noinda yena undva luhprinvra, kamba indkokla vrelmba. Doa hevna aonghal mahalnindva nonam wohbukethana pem. ");
INSERT INTO wrs_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","58","No indhanamba kevrinamba Yesusmba, os waiangana no sembayang andranindna kuwulna deuvram, Kaiapasindam. Doara heva doa kusoi katekis, mundil mongla, Yesusmba nengvilivna. Pitava ambo wowonam ehallapeta Yesusmba pethamana venavna, wo venamba, no mendekli kuwulna pueilmera siha. Hev sihanamba, di waieivvna kekalvhonind. Himba os nengvna, es hevpa ata Yesusmba vinivav? ");
INSERT INTO wrs_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","No sembayang andranindna kuwul eva Yutanindna kuwul mendekli mongla, Yesusm waiishuvna wetatmona, muembnavho ovrivna, helvakomandhalm. Boasna indhanam unvna, ambo hom, wo ishuvm daspolm, Yesus ten indkokla vevnam, os no hevna indkoklarava pivva ata helvakomandhivav hemba. ");
INSERT INTO wrs_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Indkumbi prapia, henoi henoi provna, moangakalamoa ambo ishohalv vevna, Yesusva os vena. Heva os owai, mongawamomba eukw vrivnamoa, osm mundilva uvra, helvakomandhiu. Himba indakonda vilulolohvna. Doa mongo samblaindhana epranamba, moangakalamona Yesusm ohosihavna os, ");
INSERT INTO wrs_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","hona indhanariniva os ona, kava Sesoana tempelduvpa tupulorava, hengava kava samblamongo okombanam vevav. ");
INSERT INTO wrs_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Doa no sembayang andranindna kuwul phonamba, hovra lohvhoanamba, omnana, Yesus, hona indhanamba yemba os ishumniv, sahonam vaomana vena, ata yimba es hengava hemba unvav? ");
INSERT INTO wrs_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Wo heva os owai, Yesusva henga moamba ishonamoa. Henga mendekli kuwul ona, yeoa kamoa tanamolnamoa ishunu Sesoana novra, osm ora yimba Kristusnonoa, Sesoana ombol? ");
INSERT INTO wrs_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Doa Yesus omnana, lehrata os pev ten ovm, wo hello, sewonam si yimba kamba nonglavav, kava Sesoana nihanasisva avrava, Sesoa noi himba hevnapopol wohav. Kava Sesoana ombol, wo yimba si kamba henga nonglavav, kava holopevrava tekomeriniva. ");
INSERT INTO wrs_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Doa no mendekli kuwulva himba mengpoavna hellevnamba Yesusmba, hev dandwonam viliphomna, unna, Yesusva ambo Sesoam moalusna ishomnav. Venamba, hevna kayen popowol ve, manara noinda himba Yesusmba mindnam wuspromnavna. Hev unna, manam hengava eva ata pimba indhanamba monglamba nembavav, homba kusolmba, Yesusna sahoklalva velokusa velmba, owai, pimba doa hillimni Yesusna moamba, no moanamba himba Sesoam opilpihavna. ");
INSERT INTO wrs_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Es yimba ningv? No sembayang andranindna kuwul una, himba doa sahonam ishoi, pioa hemoa helvakomandhalvohra. ");
INSERT INTO wrs_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Doa indhanamba muembkosva wulopravna Yesusna novlomosrava, wo os hilvivna, sang polasopla vrivna, ");
INSERT INTO wrs_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","umnina, yimba Kristusva tanamba olohtava, os o, henoi kamba helvav. ");
INSERT INTO wrs_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Pitava mendah di avna no pueilmera, mongo andranindrini ungevlirini kuwulna nongla ophona, kava os nengv, yimba Yesusi evevna mongawulm, no Galili tendorini. ");
INSERT INTO wrs_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","71","Pita unna indkumbina novra, owai, kava nomba tit vev, temba yimba ishovpa. Doa Pitava os deuvpultuvrava phona, henga mongo ungevlirini di nongla, wo unna nom indhanam, hona indhanariniva Yesus Nasaretrinii evevna mongawulm. ");
INSERT INTO wrs_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Pitava henga ophona, kava tit venav hemba. Kava tanam yemba ishunv. ");
INSERT INTO wrs_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Wo doa no indkumbi prapianamba Pitaindam, umnina, yimba mongo tanam Yesusna aonghal mahalnindrininonoa lohv, manara yena moamba snal, ten Galilinind ishuvm, Yesustindi, kava nonora. ");
INSERT INTO wrs_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","75","Pitava henga ophona, kava tit venav no indhanarinimba. Kava gekalava ollava honamba, Sesoa daha kamoa esesm venavma. Doa henanam ayamba ophovna, wo henga Pitava nengna, nom Yesusva os ona, samblamongolm yimba si osva ovav, kava tit venav Yesusmba, simerava simekumbrava mendah ayamba ophovramoa. Doa Pitava os ambaram pholahanganamba, di wovelohvna mindnam. ");
INSERT INTO wrs_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Lingilliha pihavnamba, no kuwulva Yutanindnamba henga kusovna mongawulm. Hev una, pioa boasna monam aslalvohra, osm pimba ata os helvakomandhivav Yesusmba. ");
INSERT INTO wrs_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Hev ishunamba, doa polisim wohtina, doa polisi pulvona, wena ninginamba Yesusm, os ningiwul angana Pailat duangindam. ");
INSERT INTO wrs_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Yutasva nongalna, ata Yesusmba helvakomandhivav, wo himba mindnam und vevna. Hev sen 30pela noi pepavena, seilm ten dembrehunam, mendekli kuwulindam inga, himba henga dembrahunilm vinvna mendekli kuwulm no sen mendekliva. ");
INSERT INTO wrs_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Hev unna no kuwulm, Yesusnamba sahoklava lohmanavnamoa, ka ambo nis yena englisra holvoholothunna, wo kava doa indkokla vena. Mendekli kuwul umnina Yutasm, yeinda temba ambo lohv. ");
INSERT INTO wrs_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Doa Yutasva no K30va os pingipiha vena di tempelmera, wo hevpa os wohganamba, tira hevm wikleihana, os dahana. ");
INSERT INTO wrs_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","No mendekli kuwul diva tungeinamba, doa hevm eishovna, una, pivva hona diva pivna disumbra dembhivavmoa huiva, owai, noinda hona diva indhanarinim sovana, dahalm nona. ");
INSERT INTO wrs_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Hev no dim naengho vrinamba, hev una, hona dinaoa mongo petha nona kovovralvohra. Sewonamba mindva dahavrava ehalnindrinimba huiva Yerusalemrava, di singvewol vivra hemba. ");
INSERT INTO wrs_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Wo noinda no pethava, indhanamba seilva alvna, sospan petha, heva os sismba hengava os weihaloh vrina tovolpetha, veiva, daipotava pivva osangas alv. ");
INSERT INTO wrs_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","10","Moashulnindrini Yeremaia moamba doara novol vewol vena, wo sismba indhanamba nomba wohengivna moamba, men os novol velohv, Monglava Israelnindva 30pelarava kinava wohomokilthina, nonamba indhanarinimba sovalmba. Doa dawonam himba K30 ieuvmona vevna, wo venamba, petha nona kovovri, no pethava os ningthiv, sospan petha. Sesoa mendekli kamba omnana, os veo. ");
INSERT INTO wrs_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Yesusm ningiwul imbanamba di Pailatna novlomosra murapeta, doa hev omnana, es hevpa ye kuwulva wulluhunvma Yutanindnamba? Yesus omnana Pailatm, eiya osta ten pev ovm. ");
INSERT INTO wrs_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Yutanindva mendekliva moangakalamonamba osihivnamba, owai, Yesusva hemba opla vrinvnamoa. ");
INSERT INTO wrs_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Pailat omnana, yimba hona moamba helwolvma, himba yena indkoklam velokusa viv? ");
INSERT INTO wrs_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Wo heva os owai, Yesusva hemba opla vremnanamoa, wo Pailatva ambo mengpoavna ovna, owai, Yesusva moamba kamba opla vremnavmoa hengava. ");
INSERT INTO wrs_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","16","Doaraminim Pailatva wevsam wohenglohvna, Pasovatihva lohlohvnamba no tahonnam, no tahonnam, nomba himba os vevna, buinindrinim mongom wolaihapho, heva hev nom Yutanind umnivnam. Wo nonamba indhanarinikokla avna, nihilva Yesus Barapas, himba buimera avna. ");
INSERT INTO wrs_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Doa Yutanind prapianamba Pailatindam, umnina, kam mongo indhanarinimoa wolaihaphunu, os ten pev no wevsam englohvm. Doa Pailat unna, henam yimba osva ningv, kam wolaihaphunu, Barapasm mava, mava Yesusm, men indhana os ningthivm, Kristus? ");
INSERT INTO wrs_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Pailat osva unvna hemba, noinda Pailatva os nengna, kuwulkuwulva doa wusapramana veni Yesusmba, kana novlomosra doa wetatmomba waiishui. Ata kava Yesusmba wuleihinvav. ");
INSERT INTO wrs_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Pailatva mendah ona ishunna kuwulm, ongal ishopra venana, no indhanariniva temba Yesusva besal, ata ye os ovav, hemoa dahara, owai. Kava sinim inungpunungra nonglaiva, wo kava lithavnamoa beswonamba, ata ye wohtvav, hem helvakomandhalm. ");
INSERT INTO wrs_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Kuwulkuwulva Yesusmba pewoleihalmba ningvnamoa, wo no di pulundtholohvnam ombandhanam hev unna, Pailatmoa yeoa os umnu, yem Barapasm kikih vrinda, Yesusmoa helvakomandhu. ");
INSERT INTO wrs_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Pailat osihinvna indkolam hevm, anm yimba ningminiv kamba, osva kam pewoleihinu hem nom? Hev indkumbi dandwonam opelpanam, kam pewoleihinu Barapasm. ");
INSERT INTO wrs_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","23","Pailat henga unna, Yesusmba eva ata kava es venavav? Memba hemba osva alvpa, Kristus. Hev umnina, valgonindm wohto, hemoa tira lepetheira. Pailat henga unna, manara? Mani himba vena? Hev dandwonam opelpanganam, tira lepetheiu. ");
INSERT INTO wrs_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Pailatva nengna, indkumbiva ata kana moamba engivavmoa, himba nihnapehna uv, lepethalmangas Yesusmba. Ata homeis daos mendekli hui ohovm hevm. Doa Pailatva hevna engla indkumbina novra pona poswol ve. Hev moakus uliheinna, hona indhanarinina dahalmba kaindava lohvmoa, memba heva yeinda pevinda ambo luhunv. ");
INSERT INTO wrs_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Indkumbi di opelpanganam mongawamona, lehra besal hevm, moamba lohtava hona mindrava, no moamba kavinda luhunvav eva kavna otovotalla. ");
INSERT INTO wrs_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Pailatva wohtna, Barapasmoa wolaihapulvunu buimerinioa indhanam. Doa Yesusm wevdakana di esvema vina, unna, ata verava, os valgonindmba wuleihinvav, lepethalmba tirava. ");
INSERT INTO wrs_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Doa seilva boasna Pailatna valgonind kleihavreinamba, Pailatna mendekliduvra waisaive, eilungung vrivna, osm nonglara. ");
INSERT INTO wrs_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Hev kayenmba selvol vinivna, hevna aembul vithimnivna, osm ovra, kuwulmendekli lohv. ");
INSERT INTO wrs_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Doa tivowosal weilvrinamba, kura weilvholothumnina, os ovna, kuwulmendeklina topimsna. Tenga vreuhna nihananglam, wo mulumbdandna henoi henoi dasalm olvohmanavna sehmona, okombahul mendekli Yutanindna, ");
INSERT INTO wrs_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","di os muembkosvna wehlav, tenga hevnamini muhvinamba, nona di kuval ohulithue. ");
INSERT INTO wrs_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Loumonamba ishopieimninamba, henga kayen aembulva selvreimnivna, henga hevna vewol vinivna, os waiangana, lepethalmba. ");
INSERT INTO wrs_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Ona waiangana, indhanarinim mongom anongla ve, nihilva Simon, himba Sairini kotarini lohvna, doa hev wuhhuna Simonm, yeoa Yesusna kruseoa pungao. ");
INSERT INTO wrs_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","35","Doa hev Yesusm ningiwul angav dom, os sevralvohv Golkota, memba osm, kukel petha. Wain vreihue, nelm, nomba wainmba doara obatnahonam moakot vinamba, thamba esvema vevna. Yesusva ambo nisambaihana, nenamoa, wo doa os pakonamba wohlepetheina tirava, doa no Yesusna kayenmba hev kat mueri vivna, osm himba nomba hevm dombvav, owalmba kuvhoawol vetava. ");
INSERT INTO wrs_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","37","Di hevpa kelvho aevulvna, diva tirava senamba Yesusna kurava moamba novol vepetheina, osm manara Yesusmba lepetheina. No moamba os novol vepetheina, ");
INSERT INTO wrs_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Ambo nonamangasta samblaindhanam kelsombovhol samblam os wekal vina Yesusnahonam, mongova Yesusna sihanasis, mongova nihanasis, Yesusva hevmba hovra. ");
INSERT INTO wrs_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","40","Indhanamba monamba ahalakoho vevnamba, Yesusmba loumona nonglakov ovrivna, umnivna, yimba osva onamba, kava tempelduvpa tupulovav, wo hengava kava samblamong okombanam vevav. Wo eva daipota pevm kolvratok, yimba tanamba Sesoana ombolva lohtava, eva pevm wolaihapihatok hona tirini. ");
INSERT INTO wrs_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","42","Sembayang andranindna kuwul, katekis, mundil loumona ishumnivna, himba indhanamba monglamba kolvrowol vevna, heva os owai, hevmba kolvravmoa. Himba tanamba kuwul mendekliva luhuntava pina Israelnindnamba, eva hev ambo holoperata tirinioa, wo pimba osva ata undnahonam ningminivav hemba. ");
INSERT INTO wrs_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Himba Sesoam keknam doara wohlohmanavna, wo himba os isholohvna, kava Sesoana ombol. Wo eva daipotaoa Sesoaoa hemoa kolvrarata, Sesoava hemba nonglalmba vetava. ");
INSERT INTO wrs_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Eva osta, no kelsombovhonindrini sambla ten wikleihalohwolvm, Yesusmba loumonamba noi ihishomnavna. ");
INSERT INTO wrs_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Doa okombava hovrahovrava vevnamba, venamba, sivravnamba, wo simba wohehlathangu vevna pethamba, venamba, 3klok okomba vohanam. ");
INSERT INTO wrs_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Doa Yesusva dandwonam wenamona ishovongo venana, ara kana, ara kana, manara yimba kamba nombolvhoav? Himba hevna moana ishovna, eli eli lama sapaktani. ");
INSERT INTO wrs_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Indhanamba monglava doara di murapeta lovahvna, hillie hona Yesusna moam, wo hev una, Yesusva Elaita moashulnindrinim doaraminim wunuhomnav. ");
INSERT INTO wrs_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","49","Mongo nungi lelnam ganamba, lembatamsna kovovra, wo doa wainpora velthanamba, wandtanglara ningewolanamba, Yesusm nethavongo vene, nelm. Mongla owal no indhanarinim umnina, ata ye os venavav Yesusm, dawonam ambo, ata Elaitava prorava, Yesusmba wolaihapihavav kruseriniva. ");
INSERT INTO wrs_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Doa Yesusva kingemba eunillamba os onamba, doa os wohvitivhoana. ");
INSERT INTO wrs_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Doara di kayenmba mendekliva kleihalohvna tempelduvmera, doa nonamba heva hev ambo powalwolna samblanam, dipeh venamba, dingoho mulla. Doa nonamba os vena, nenv mendekli vevna, honmba vevna, popopengavna, ");
INSERT INTO wrs_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","wo doaraminiva pokamava heva hev ambo wuwuliha geku vevna. ");
INSERT INTO wrs_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Indhanamba nomba temba Sesoamba seilva undnahonamba amnavnamba, wo dalvnamba, singvewol vie, himba henga beswonam phopiana pokamariniva hevna nihna. Sismba Yesusva hevpa beswonamba si phovrava hengava, no indhanamba Yerusalemrava saivrava, wo indkumbiva si os nungeilvra hemba. ");
INSERT INTO wrs_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Yesusmba diva kruserava vendendvnamba mindilva, valgonindva di wohkekalvho vrivna, wo himba di nomba nunglina nenvpa, temba nomba vinnamba, wo himba pemba os viwul vevna i. Valgonindna kuwul, valgonind hev una, tanam Yesusva Sesoana ombolnonoa. ");
INSERT INTO wrs_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Nonamba Yesusmba kruserava vendendvnamba, ungevliva ambanamba, okla lovahthanamba, nonglamb velvohvna. No ungevliva nemetva himba Yesusmongo lovahmana vevna, nonamba provnamba Galili provinsrini Yerusalemramba. Himba yunalm wongavna, wo he innemba Yesusmba dahwol angavna. ");
INSERT INTO wrs_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Mongova Maria Maktalarini, Maria mongo Yemsina Yosepina aval, mongova Sepetina ongal, wo eva mongla ungevli. ");
INSERT INTO wrs_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Nonamba doa okombava pelangalla avnamba, mongo indhanarini wohtowand lohvna, nihilva Yosep, himba Yesusmindm singvelm vevna. Himba nemetva Yesusna aonghal mahalnindrini lohvna, himba Arimatia kembellini. ");
INSERT INTO wrs_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Hev ganamba Pailatindam, hev omnana, kava Yesusmindm kruserinim vendvelm vev, singvelm. Pailat unna hevna valgonindm, wuleihimnu Yosepmoa, Yesusmindmba vendvelm. ");
INSERT INTO wrs_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Doa Yoseppa Yesusmindva vendvenamba, kayen dombal nemelna ninge, ");
INSERT INTO wrs_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","wo doa os ningithana honme nemellava, Yosepna hevna no honmeva doara heva nemet dihi andranind tuveina, wo doarava mongova mindva noindava singvinamoa, khui lohvna mendah. Doa Yoseppa honmba mendekliva lukuh vrunganamba, tuvm no wohehlatha, wo os hevpa gana deuvramba. ");
INSERT INTO wrs_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Ungevlirini samblava di ahana, pokamam nom kekalvho evevrahana, Maria Maktala eva mongo Maria. ");
INSERT INTO wrs_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","63","Memba hona okombanamba yumatnam Yutanindva inne meilna vildavna, hlalm sapturam, vah iaevul okombanam. Doa sapturamba mundil, mongla katekis, Varisinind mongawulm hev moakot venamba, Pailatm moam ishomnalm angamnavna. Hev umnina, kava ningv Yesusna moam, nonam mendah himba novkaka lohvna, himba dasalm ishovna ambo, himba os ovna, si kamba dahavav, wo heva os samblamong nin verava, kava henga si beswonam phovav kavna nihna. ");
INSERT INTO wrs_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Kava yemba os ningminiv, yeoa pevna valgonindm undava, heoa Yesusna pokamamoa samblamong okombanam kekalvho vruwuvra. Ata homeis mongla hevna aonghal mahalnind ambrava, poaita vindilanga Yesusmindmba, wo indhanamba dasalm ishunvra os, Yesusva doa henga beswonam phoi hevna nihna. Si homeis hona hena nemelmoa doaraminim Yesusnam hevnam kuvhoavm, os kava si henga beswonam phovav. ");
INSERT INTO wrs_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","66","Pailat unna, ata kana valgonindva vivav, yimba ishuntava hemba osva. Yeoa angarava, pokamamoa beswonamangas kekalvho vruwuvm. Wo no mendekli kuwulva os angana, honmem kekalvho vruwuvulmba, valgonindm diva murapeta sandhina, unna, yeoa kekalvho vruwuvm. Wo hev vena, euvpos lothuna no hontuvpethal, osm vivna, ata mas tuv velevhueivm. ");
INSERT INTO wrs_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Yutanindva vah iaevulvna sapturava, doa venamba, lingil lihavnamba, mongnasiva ungevlirini samblava epravna, Yesusna pokamam nonglalm. Mongova Maria Maktala, eva mongo Maria. ");
INSERT INTO wrs_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Wo nonamba osoa ambo di nenv snavema ve, Sesoana ovsongolnindriniva os holopena senaminiva, dom pokamarangas lohvhoanamba, doa honm nom imharavho vrungua, pokamam ten ehlathalohvnam. Venamba, hevpa di avna honsra sena. ");
INSERT INTO wrs_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Henamba novlomosva os vevna, ovna, wing, wo hena kayenmba dombalnonoa. ");
INSERT INTO wrs_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Nomba valgonindva honmeva kekalvho vruwuvnamba, himba no ovsongolnindrinimba nunglinamba, hemba mindnam eiswol vevna pem, wo hemba kokoral vevna. ");
INSERT INTO wrs_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Doa ovsongolnindriniva unna no ungevlirini samblam, pemba manam yimba evev, kava nonora, yimba Yesusmindm nonglalm epri, nom ten lepetheinam. ");
INSERT INTO wrs_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Owai huiva, himba doa henga beswonam pholahangai, os ten hev seilm onam. Hom murapetam eprarava, enonglo. No mellava, temba seilmba vindyithinamba Yesusmindmba, owai, vuhengas lohv. ");
INSERT INTO wrs_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Ovsongolnindriniva mendah ishunvna hemba, doa yeoa lelnam engarava, hevna aonghal mahalnindm ihishunu, os Yesusva doa phoi henga beswonam, himba Galili provinsram prolm vev yeindam. Yeoa angarava, nunglupulvo hemoa di. Doa ovsongolnindriniva nomba moamba ungevlirini samblamba ishopieinnamba, hev unna, doata hona moam, kava yemba isholmba vinvna. ");
INSERT INTO wrs_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","No ungevlirini samblava pem evevna, hev os und ekanandhawolvna, doa hev dandwonam engavna, hevna mongawa aonghal mahalnindm ishunilm. ");
INSERT INTO wrs_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Wo nungi lelnam Yesusva hev monara phunnamba, unna, es hevpa? Wo doa hev murapetam enganamba, mulumbdandna elohvhoamnanamba, monglam ekivrawolmananamba, sembayangna ohokolavna. ");
INSERT INTO wrs_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Doa Yesus unna, pepehoa ewuliho, yeoa engarava, katindim ihishunu, heoa angara Galiliram, di himba si kamba nunglivav. ");
INSERT INTO wrs_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","No ungevlirini samblava pokamariniva ishunilmba Yesustindimba mendahva engavnamba, valgonindva no Yesusna honmemba kekalvho vruwuvnamba, himba saivna Yerusalem kotara, kuwul mendekli sembayang andranindnam ishunilm, nom ten nunglinam di pokamara, nenv mendeklim, eva Sesoana ovsongolnindrinim. ");
INSERT INTO wrs_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","13","Sembayang andranindna mendekli kuwul eva mongla kuwul owal mongawulm kusovna, moam mongalm mokalthalm. Doa hev unna no valgonindm, men diva mindnam, kava ambo yemba nis dembrehunv, wo yeoa indkumbimoa indhanamoa hona moamoa ishunu, kava kekalvhonindva nin shavna, wo Yesusna aonghal mahalnindva sinim poaita ambanamba, os vindilangana Yesusmindmba. Heva os owai, himba moam kukuvna ambo. ");
INSERT INTO wrs_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Kuwulva nomba kusonamba, mendah moamba ishunvna no valgonindmba, unna, os wohviu, men kav yem ishunvm, wo hona moamba duang Pailatva helletava, kava si hemba newondmona ishumnivav, himba yemba ongoltava hona moarava. ");
INSERT INTO wrs_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Doa valgonindva no diva dumbnamba, os wohangana, wo no moangakalamom indhanam ishuwul vinvna indkumbim, no moamba osva vruwul vevna hindkembel, hindkembel, wo Yutanindva indkumbiva no moamba osva kek vithina, Yesusmindva dihi tanam poaita yukovna vindilhalvna? Yutanindva nomba moamba mendah kek vithuvmona vev. ");
INSERT INTO wrs_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","17","Yesusna aonghal mahalnindva 11pelara angavna Galili provinsram, doara heva hev Yesus ten unnam. Hev anganamba, di olora nonglapulvonamba, doa sembayangna okulivna. Monglava sambla und verumbul vevna, ovna, tanamma hev Yesus? ");
INSERT INTO wrs_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Doa Yesus murapetam pronamba, unna, Sesoa kamba mendeklilmba awothona, wo kangas kuwulva wulluhunv manana manana senaminim eva petharinim. ");
INSERT INTO wrs_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Noinda yeoa bukethungu vevrava, numhowol viwul vevm indhanam pethanindm, kavm engalm. Pona poswol vivm, arana nihilm sevrivrava, kanam, wo eva Sesoasongolnam. ");
INSERT INTO wrs_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Numhowol vivm hona moana, men kav yem iamana venam. Doa hillu, kava si elsus yemba wonamana vevra, verava, ovi pethai mueisowa vera. Doata Matiuna Yesusmoa. ");
INSERT INTO wrs_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Hona tombairava memba plalmomba lohvpa, Yesus Kristusna nemelmoa besalva seilva phona, noi Yesus Kristus Sesoana ombol. ");
INSERT INTO wrs_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Nemetva Aisaiava moashulnindriniva novol vena os, Sesoava ombolm omnana, hello kam, yemba si kava kavna andram wolaihangavav, wo kavna moashulnindrinim si kava osva wolaihangavav, wo he miva gavav, yena monamba vuenghungavav. ");
INSERT INTO wrs_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Wo doa hev si gavav, wo di indhanahuiram amana vevav, wo indhanam di nembaomana vevav, os mendekliva doa mura prolm vev. Yeoa monaoa vuenghimnivm, wo mendekliva beswonamba yeindamba si siheinvav. ");
INSERT INTO wrs_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Doa Aisaiava os doarava no Sesoana moamba novol vena, wo osva Yon Baptaisva sism wohengvna. Hev phonamba, di indhanahuira amana vevna. Wo no Yonmba indhanam ishomana vinvna os, yeoa sahoklamoa wuleihu. Yimba osva vivrava, yemba kava os pona poswol vevav. Manara, yena sahoklava mindnam luhunv Sesoana novra, wo himba si os nomba yenamba maisasa vrinvav, hengava nengvavmoa. ");
INSERT INTO wrs_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Wo Yutanind indkumbi, Yerusalem kembelnind indkumbi embauvmona vevna, Yonm di nonglapulvulvohvna, wo hena moamba hillivnamba, wo hevna indkoklamom moakus umnivna, wo Yon nomba pona poswol vinvna. Os vivna di Yotan pora. ");
INSERT INTO wrs_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Yonna wevsava os, kayen vethulamana vevna, kayenmba nomba tatana talna vina, besalva owai. Wo innemba noi Yonmba naomana vevna sungeitinne, vevna meleumb, eva yuhvsu. Honi Yonna inne kayen os lohna, os Sesoana moashulnindva doarava os vivna. ");
INSERT INTO wrs_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Wo Yon indhanam ishomana vinvna, os si mongova indhanariniva sis provav, wo kava hena anglasingi lohv. Kava indhanakola ambo, wo he kamba wohkuvhoavav. ");
INSERT INTO wrs_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Kava yemba daipotava ponangas poswol vaomana vev, heva os hena andrava si mendekli phovav, wo hena moara Sesoasongolva yena nihmerava sihaomana vinvav. Doa yimba si os henanapopol wohaevvav. ");
INSERT INTO wrs_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Doa nonamba Yesusva hevnamini Nasaret kembellini venamba Galili provinsriniva, wo Yotan pora Yonm nonglapho, wo himba Yesusmba pona posvena. ");
INSERT INTO wrs_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Wo Yesusva porini meillam vonganamba, doa os nonglana, ovrava mel lohvna, wo noshara Sesoasongol holope leumbna nihna, wo Yesusina avhoana. ");
INSERT INTO wrs_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Wo Yesusva Sesoam ovrini hellena, os yimba kana mongal ombol, yem kava mindnam indk vethamnav. ");
INSERT INTO wrs_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Wo Yonmba Yesusmba pos vepianamba pona, doa lelnam Sesoasongol Yesusm wuhhona, indhanahuiram gawe. ");
INSERT INTO wrs_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Wo noinda Yesusva indhanahuiram gana, wo simba 40pelara lohmanavna diva. Wo diva himba Setanm nonglapho, no Setanmba Sesoana ungund. Wo himba Yesusm newondmona isholohmanavna. Yesusva di indhanahuira amana vevna, di ten sungeitwindeva sahoklal luhungu vevnam, wo Sesoana ovsongolnind hemba kekalvho vrimnivna. ");
INSERT INTO wrs_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Wo dawonam Herot kuwul Yonmba buira wolaihasihana, wo nonamba Yesusva Galili provinsram ganamba, di indhanam Sesoana nemelmom besalm isholohmana vinvna. ");
INSERT INTO wrs_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Os ishunvna, daipotava men lehrava phov, manara noinda Sesoava indhanamba hevtindilm nembaomana vev. Wo noinda osva hengava manam yimba ningvav pevna indkoklamba. Owai, wuleihu, wo honi nemelmomoa kek vithivm, enguvmona vevm. ");
INSERT INTO wrs_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Doa dawonam Yesusva Galiliplomb pethalmonam gavna, wo di nongalphona Simonim Endruim etel bosalalm. Nomba etel bosalalva doara tambko andra evelohvna dinasvom sovawolalm, wo nonamba tambkom pohlalawondana eslelvna. ");
INSERT INTO wrs_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Wo Yesus unna, daipotangas yimba tambko andrava evev, wo yimba si kamba ehengpetharava, indhanamba yimba si os nembaomana evevra Sesoatindilm. Pohlalawondaoa eplaho, kam ehengpetho. ");
INSERT INTO wrs_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Wo noinda pohlalawondamba evalahavna, Yesusm ehengpetha, lohmana evevna hetindilm. ");
INSERT INTO wrs_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Wo Yesusva mendah gavna, tendorini samblam nongalna Yemsim Yonim, Sepetina ombolsamblam. Hev pohlalawondam henga beswonam ehonavna botsra. ");
INSERT INTO wrs_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Wo Yesus unna, yeoa kam ehengpetho katindilm. Wo os evena, aralm, andranindm, himba sandhalaha epihonamba botrini, Yesusm ehengpetha. ");
INSERT INTO wrs_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Wo wonganamba, Kapaniam kembella wonpho, wo no sapturam sembayangduvra wonsiha. Sapturava Yutanindva vah iaevluwul vevna hevna volm. Doa Yesusva di indhanam Sesoana moam ishomana vinvna. Ishunvnamba, ");
INSERT INTO wrs_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","wo indhana hillivnamba, os uvna, pai, doarava katekisva pimba osva moakus unvnamoa, osva Yesusva memba moakus ovpa. Yesusva nengthal lohv, wo aralna moalamangva kuvuwulluhv. ");
INSERT INTO wrs_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Wo Yesusva mendah ishunvna, doa mongova indhanariniva sembayangduvra sihana, indhanarinimba nomba tihsongo doara pothomnana, wo himba daikaka vevna. ");
INSERT INTO wrs_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","Wo hev Yesusm mindnam omnana, Yesus, es yimba kamba ata venavav? Doa kava nonora, yimba Sesoanamini prona, besal yimba, wo ata kam humeis ye nihsesowolm venavm. ");
INSERT INTO wrs_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Tihsongomungilva os ishomnana, wo Yesusva tihsongom omnana, wuleihao, wohgao. ");
INSERT INTO wrs_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Doa tihsongova indhanarinimba nomba kusukul vrevna, mindnam kinge os ovna, doa tihsongova nihmeriniva os phona. ");
INSERT INTO wrs_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Wo indhana di sembayangduvra una, pai, mani hevpa manamoa memba? Yesusva besal lohv, wo hena moamba tihsongova hillivpa, wo os vivta. Snamba andrava pivva doarava nunglinamoa, owai. ");
INSERT INTO wrs_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Wo lelnam indkumbi moa wulaindahalv vevna di mongona kembella mongona kembella Galili provinsra. ");
INSERT INTO wrs_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Wo Yesusva sembayangdini phonamba, Simoni inam Endrui inam geinnamba, Yemsim Yonim domangas wongana. ");
INSERT INTO wrs_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Wo Simonna kolalva di doara deuvra uvavulmungil nendawovna, nih vuvremnavna, wo Yesusm ishumne. ");
INSERT INTO wrs_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Wo Yesusva deuvra sihanamba, muram ga, doa englaval kleiha vre, wuleihapholm vevna. Wo uvavulva nomba os daipotangas wuleihana, wo ungevliriniva nomba beswonam lohmana vevna, wo innesowa vinvna. ");
INSERT INTO wrs_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Doa simba okilvravnamba, nomba deuvnindva uvavulmungilmba, tihsongo mungilmba mindnam nom tungiambv vevna no deuvram, Yesus di avnam, ");
INSERT INTO wrs_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","wo indkumbi no deuvnindva di kusopra. ");
INSERT INTO wrs_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Wo Yesus vinvna, wo uvavulmungilmba nomba kanandhawol vevna, manamungil manamungil, wo tihsongova mindnam Yesus engilpingu vinvna no indhanana nihmeriniva. Tihsongova nomba Yesusna doa nonora lovahvna, os Sesoanamini prona, besal lohv. Wo noinda Yesus no tihsongomba ovunna, moamba wuleihu, manam yimba indhanamba osva unvav. ");
INSERT INTO wrs_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Doa sia eunumbullam, mongova indhanamba mendah ninshavna, wo Yesus no deuvrini holopenamba hevho, indhanahuiram ganamba, di sembayang vawovna Sesoam. ");
INSERT INTO wrs_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Wo Simontatana sis engavulanga lingil lihanam, ");
INSERT INTO wrs_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","wo Yesusm di yumna vlie, una Yesus, indkumbi yemba aslulangalm vevna, yeoa hem wolapho vera. ");
INSERT INTO wrs_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Wo Yesus unna, owai, honaminiva mongona kembellam kava wongalm vev yemba, no kembella eva kava Sesoana nemelmom isholm geinv, memba kana andrava, hona andram kava pronata. ");
INSERT INTO wrs_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Wo Yesus isholohmana vevna mongona kembella mongona kembella di Galili provinsra. Wo di indakonda sembayangduvra himba indhanam wonamana ovovna, Sesoana nemelmom ishomana vinvna, wo tihsongom engilpingu vinvna indhanana nihmerini. ");
INSERT INTO wrs_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Wo di mongova lombamungilva pronamba, Yesusm mulumbdandna lohvhoamna, wo himba Yesusm osahmana, kana wosavam kevro, wo kana nihtov lesvhoara. Ata ye kevravavmi owaimi. ");
INSERT INTO wrs_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Wo Yesus hem wavra vovhoamnanamba, wo engla holothomnanamba, omnana, tanamolnam ata kava yena wosavam kevravav, yena nihtovoa lesvhoara. ");
INSERT INTO wrs_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Wo Yesusva os ishomnavnamba, lombamba lelnam heniminiva selpevna, wo he beswonam pho. ");
INSERT INTO wrs_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Wo Yesus ongawolna, garava, manam yimba indhanamba ishunvav, osva doa Yesus kamba sishona vrei. ");
INSERT INTO wrs_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","Owai, ambo sembayangna andranindrini inam gao. Garava, innepetaoa guao, os Moses doara ten novol venam. Wo hemoa no innepetaoa vraho, Sesoam nonam okolalm. Wo sembayangna andranindriniva yemba os ata naengho vrevav, doa lombamba yenamba wohselpei, wo indkumbi si os yemba nonora, yemba doa kanandhana. Doa lelnam gao. ");
INSERT INTO wrs_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Heva os owai, himba ganamba, moakus une, wo indhana indkumbi moa wulaindahalv vevna no kembella no kembella, wo noinda Yesusva es eva mongona kembellava sihavta, monamilla kulthoamnavnam, ka nunglivai. Noinda Yesusva monamilla ambo alohvna, wo di indhanamba heindam ambalvohvna, kana kinwondam nembashapiha vinu. ");
INSERT INTO wrs_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Wo henga Yesus Kapaniamra phona deuvra. Phonamba, doa indhanamba os hillina, wo noinda hevinda kusona. ");
INSERT INTO wrs_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Kusonamba, wo deuvra kekel vithina, deuvra tuvra monara os kekel vithina. Wo osva Yesusva wonamana vevna, hevna besal nemelmom ishunna. ");
INSERT INTO wrs_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Mendah ishunvna, wo indhanamba ambna, wo tendorinim wulimbna. Tendo samblasambla wulimbna towara. Nomba tendoriniva monglakoklana doara livna os. ");
INSERT INTO wrs_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Wulimbnamba, doa Yesusindam wulsaivolm vevna, heva os owai, indhanamba kekel vithina. Doa volnamba, wivtam vevla vinamba, doa tendorinim no mella enesna towara piapove. Piapovvnamba, Yesus di deuvmera avnam. ");
INSERT INTO wrs_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Wo himba os nongalnamba, wo nengna, hona tendomba kam ningminivna, ata sishona vrevav. Doa noinda himba no tendorinim os omnana, seh, indkoklava yenamba mekava poswol vei. ");
INSERT INTO wrs_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Doa monglava katekisva di hiluwuluwuvna, os ningminivna, Yesusva gekala ov, Sesoangas hev indkoklava poswol vinv indhananamba. ");
INSERT INTO wrs_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","Manam himba osva ov, osva sem Sesoamba opipahav. ");
INSERT INTO wrs_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Doa Yesusva hev ambo lihawol vena, katekisva kamba os ningminiv, wo noinda unna, manam yimba kamba osva ningminiv? ");
INSERT INTO wrs_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","10","Yimba os ningv, kava dasalm oi, kava tendorinim omni, indkoklava yenamba kava poswol vei. Hillu, kava ata henga tendorinimba omnavav, pho, deuvram gao, wo tendoriniva ata verava, kamba osva ata yimba liheivav, os kava dasalmba oimoa, kava tanamolnam hena indkoklava doa poswol vei. Manara, kava arana ombol lohv, he kamba moamba mendekliva kovorahona, wo noinda kava hona tendorinimba osva omnav. Doa himba tendorinimba monglakoklanamba omnana, ");
INSERT INTO wrs_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","yeoa phovm, monglana lohvhoao, vuhesaloa deuvram guao. ");
INSERT INTO wrs_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Doa tendorini phonamba, vuhesal vranamba, doa wulvoha hevna deuvram no indhanana novra. Wo indkumbi os uvna, pai, pai, es hevpa Sesoava vei. Doa noinda Sesoam okulivna, lehra, doarava kava osva nunglinamoa. ");
INSERT INTO wrs_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Wo Yesusva henga Galiliplomb pethalmonam ga, ganamba, wo indhana mindnam di kusomna. Kusomnavnamba, Yesus wonamana vevna, ishunna hevna nemelmom besalm. ");
INSERT INTO wrs_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Ishopieinnamba, monam henga ga, Livaim nonglakoho, Livaiva nomba Alviusna ombol, wo himba kantorra mera avna, duangna andrava vawovna, di indhanamba hevna taeksva dembhasuv velvohvna. Doa Yesus phonamba, omnana, pro, kam engpetho katindilm. Doa Livai phonamba, hevna andrava wuleihavna, Yesusm wohengpetha. ");
INSERT INTO wrs_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Wo venamba, dawonam Livaiva Yesus hetindim inne wonnena. Wo nonamba Yesusva indhanamba mindnam wonnawovna, taeksdi dombnindm, puehalnindm, manara, sna indhanamba mindnam doarava Yesusmba tellohmana vevna. ");
INSERT INTO wrs_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Wo Yesus wonnevnamba, mongova katekisva os nunglul lovahvna, himba os lovahvna Varisinindilm. Doa himba Yesustindim osihinvna, es hevpa Yesusva osva vev, os honam taeksnindm puehalnindm wonnawov? Owai, osva sahoklal. ");
INSERT INTO wrs_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Wo ona ishune, Yesus hellowole, wo hev henga olhmona unna, os mantriva uvavulnindmangas obatva dahwol vaomana vev, besalnindmba owai. Wo osva kava prov, monglava indhanamba ningvra kava indhanakokla, wo kava no indhanamba das owol vev. Wo monglava indhanamba ningvra kava besal, wo no indhanamba owai. ");
INSERT INTO wrs_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Doa Yon Baptaistatana monglava Varisinind, honi indhana innemba lovahavna, os ningvna, sembayangna wevsa os kava engiv. Doa mongova indhanamba Yesusm osihminivna, os Yontatanamba, katekisva innemba lovahavna, heva os yena hellelnindva osva lovahavnamoa, manara? ");
INSERT INTO wrs_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Doa Yesus henga olhmona unna, tendoriniva ongamba vravrava, hetindiva uvav, lehra vrav, wo owai, innemba nonamba lovahavavmoa, beswonam hlawuvav. ");
INSERT INTO wrs_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Kava mendah hui hona pethara lohvna, katindiva innemba lovahavnamoa, heva os si kamba ungundva engvapingivav, wo osva katindiva kamba und vewuvav, wo noinda innemba si lovahavav kanasirava. ");
INSERT INTO wrs_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Doa Yesusva mongo olhmona unna, os hillu, deuvpa nemelva yimba dimbrirava, deuvtva manam yimba kololva dumbvav. Yimba osva virava, deuvpa lelnam pilpevav. ");
INSERT INTO wrs_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Wo manam yimba kolakoklarava kovav yesva, nemella ko. Kolakoklava ata humeis powalvm, wo yesva shara vetvaral vevav. Kana moamba yessowamsna, wo katekisnamba wevsava kolakoklamsna, wo mongawulmba elohvmoa, owai, ata powalvav. ");
INSERT INTO wrs_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Wo sapturava Yesusva hev wonga osohovmonam, wo ponda angavna, wo hev innepeta momnanam dombolangavna, hilluwul angavna. ");
INSERT INTO wrs_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Wo Varisinindva di lovahvna, nongalvohvna, hev Yesusm kueisvina, yetindiva esm detiva sapturava viv. Osva himba witmovpa englanamba temba nenoh vewol vivpa. Kava ui, andra viv sapturava, wo Sesoana moamba himba osva sahokla vriv. ");
INSERT INTO wrs_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Wo Yesus hev ona, owai, yimba doa tombaira nunglina, wo doa yimba nonora, nemetva Devitva simbehumunilliniva os vena. Heva os yimba mendah plalmba tit viv. ");
INSERT INTO wrs_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Ponmba vinvnamba, doa Devitva sembayangduvra siha, roti noi ne, ten Sesoana novra nalohvnam, nomba rotiva os uvna, manam ombandhanamba hlavav, hev noi sembayang andranindangas hlav. Heva os Devitva vena nemetva, doa he moang vinnata rotiva. Nonam vena, Apiatar nonamba sembayang andranindna kuwulva wulluhunvna. Yimba nonora, Devit sembayangduvna wevsamba osva engvnamoa, heva os yimba memba kamba kueisvivna, yimba saptuna wevsava engivmoa. Manara noinda yimba mendah levrapivolvmoa, Sesoava os nengvna, wo tomonalmba indthueinna saptuna wevsam, sembayangduvna wevsam. ");
INSERT INTO wrs_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Sesoava seilva indhanam vewol vena, wo dawonam unna, detioa sapturaoa vah iaevulo. Himba nengnamoa, osva indhanamba pueilmera kava wolasiha vevav, owai, himba kolvrowolalm beswonam vevna. ");
INSERT INTO wrs_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Kava arana ombol lohv, osm kav indhanam kava ishunvra, mani ata detiva vivav sapturava. ");
INSERT INTO wrs_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Wo sapturava Yesusva henga sembayangduvra sihanamba, pai, indhanariniva englakoklanamba men av. ");
INSERT INTO wrs_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Wo Varisinind di muskonam nunglul aevulvna, ata Yesusva es vevav, ata englakoklanamba sishona vrevavmi? Wo pi nunglirava, ishulanga, Yesusva sapturava andra vei, Mosesna moamba himba pilpiakohai. ");
INSERT INTO wrs_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Doa Yesusva englakoklanamba omnana, phorava, hui mura lohvhoao indhanana novra. ");
INSERT INTO wrs_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Doa nom Varisinindm sah owol ve, es hevpa Mosesna pina tomonalnamba moamba es novol velohv? Detiva sapturava kava beswonam vevmi, ora kava sahonam vev? Kava hona indhanarinimba sishona vrevavmi, ora kava nombalvhoavav? Wo Varisinindva moanghui aevulvna. ");
INSERT INTO wrs_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Doa Yesus hem muskonam nungsis vungo, duus vevna, yimba undva sahoklal, yimba wavra vovhueimnivmoa hona englamungilmba. Doa Yesus omnana, englaoa yeoa shuavm, wo shuanamba, doa beswonam wohlohmanavna. ");
INSERT INTO wrs_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Wo noinda nomba Varisinindva pulvonamba, anga, Herot kuwultatanam ishulanginna. Kusonamba, hev poaita unna, es hevpa pimba Yesusva si vinivav? Doa hev una, si helvakomandhivav. Hena monana pimba si helvakomandhivav? ");
INSERT INTO wrs_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","10","Ungundva osva poaitava uvnamba, wo noinda Yesus hevtindim wonga, Galiliplombra wonpho, wo indhanamba mindnam kusona, doa Yesus wolapho vevna. Galili provinsnind kusona, wo eva oklanind mindnam, ten doara hillinamba, Yesus os mendekliandra vev. Os Yutia provinsnind, Yerusalem kotanind, Itumeanind, Yotanpora hilnind, Tair kotanind, Saiton kotanind, indkumbi noi engalla kekel vithie, ambo Yesusm lukul vruwul vevna, os ningvna, Yesusm ka ambo tuhivrava, ata kamba lesvhoawol vevav. Wo Yesusva hevtindim unna, ata humeis kamba singtheivav, bot vreu, ata kava botra vongarava, avhoa posra. ");
INSERT INTO wrs_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Wo nomba tihsongomungilva Yesusm nunglivnamba, doa pethara dalvna Yesusina, os Yesusm mindnam umnivnamba, yimba Sesoana ombol. ");
INSERT INTO wrs_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Doa Yesusva no tihsongom ongowolna, manam yimba kamba osva muserava sevravriv, yimba he. ");
INSERT INTO wrs_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Doa Yesusva Galilipundrini indhanahuiram vonganamba, hevtindiva sis engvolnamba, Yesusna moara. ");
INSERT INTO wrs_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Doa lumbulla kusonamba, Yesusva tendomba 12pelara pusvund vena nominiva, unna, yimba kana moalamangnind lovahv, yemba kava boasna wonamana vevav, doa si kava yem wolanga vevav, kana moam ishuvmona velm. ");
INSERT INTO wrs_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Wo yemba kava si os poauothowol vevav, wo noinda tihsongomungilmba yimba si beswonam wolapulvo vewuvmona vevra. ");
INSERT INTO wrs_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Doa boasna Simonm pusvundthoanamba, awona, yimba Pita lohv. ");
INSERT INTO wrs_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Yemsm Yonm etel bosalalm Sepetina ombolsamblam pusvundthoawolna, awowolna, yimba holaiklana ombolsambla, doara yimba indvuvral elohvna. ");
INSERT INTO wrs_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Wo mongom himba pusvund vena, Endrum, Pilipm, Bartolomium, Matium, Tomasm, Yemsm temba Alviusna ombol, wo eva Tatiusm. Wo Simonmba himba pusvundthoana, Simonmba nomba indva wulluhvna, os Romduangmoa engilpingilvohara pivna Yutanindna petharinioa. ");
INSERT INTO wrs_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","Wo Yutas Iskariotm pusvundthoana, noi Yesustindilm dawonam lohvna, wo sewonamba henoi si Yesusva ungundna englisrava desvhueinvav. ");
INSERT INTO wrs_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Doa Yesustatana deuvram anga, wo henga kembelnind mindnam ksunna, Yesusna moam ka hillivai, wo noinda Yesustatanava innemba hlahuiva vevna. ");
INSERT INTO wrs_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Wo moamba prona, wo Yesusna aval boasalal himba os hillina hevindava, os hevm ishunna, Yesusva innemba nehui vev, dihi daikaka ov?. Wo noinda Yesusindam hevnamini anga, waiembalm henga. ");
INSERT INTO wrs_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Doa mongla katekis Yerusalemrini holvoral vena, wo ishuvmona vevna, os unna, tihsongona kuwul Setan sihamnavpa, wo Yesusva nonapopol andra vev, tihsongomba wolanga vev. ");
INSERT INTO wrs_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Wo Yesus hev hellenamba, indhanam unna, ambtok. Ambanamba, henga Yesus olhmona unna, os katekisva nomba unna, tihsongona kuwul Setan kam sihamnavpa, wo henapopol kava noinda tihsongova wolanga vaomana vinv indhanana nihmeriniva. Osva owai, owamba kava wolanga vetava, beswonamba kava aevulvavmoa, indkokla vilovav. ");
INSERT INTO wrs_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Hev unna, mongona pethanindva avra, wo daos oho hevm, wo heva os muhavav, avavmoa. ");
INSERT INTO wrs_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Wo mongawa kembelnind avra, wo daos oho hevm, wo heva os muhavav, avavmoa. ");
INSERT INTO wrs_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Wo Setanmba hevna owalmba wolanga vetava, beswonamba aevulvavmoa, indkokla vilovav. ");
INSERT INTO wrs_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Himba kam sihamnavmoa, owai, kava doa Setanmba wena ningena, wo noinda hena andrava kava sahokla vringu venav, hena tihsongova kava wolanga vaomana vev. ");
INSERT INTO wrs_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Doa tanam kava yem ishunv, indhanamba indkoklava vivra, wo Sesoana nihilva sahokla ovrivra, nomba hena indkoklava Sesoava si poswol vewol vinvra. ");
INSERT INTO wrs_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Heva os indhanamba Sesoasongolmba sahokla ovrivra, nomba poswol vinvramoa, hena indkoklava si wohluhunvra. Yesusva noinda osva unna, manara noinda himba Sesoasongolnapopol andra vaomana vevna, heva os katekismba nomba Sesoasongolmba sahokla ovrivna, ");
INSERT INTO wrs_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","himba gekala uvna, Yesusva Setannapopol andra vaomana vev. ");
INSERT INTO wrs_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Wo Yesusva mendah deuvmera avna, indhanam mindnam wonavna, wo hevna avalna boasalalna muram ambna, ambanamba, ambara lovahmanavna, wo unna, Yesus photok. ");
INSERT INTO wrs_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Wo mongova indhanamba hilwulnamba, noi ten deuvmera kusovnam, doa Yesusm umne, nongaltok, ten avapevtatanamba yenamba amballa lovahv, yem umniv, photok. ");
INSERT INTO wrs_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","35","Doa Yesus unna, an kana owalva eva lovahv? Himba nomba Sesoana moamba hillivpa, wo enguvmona vevpa, himba nomba kana avalmsna, kana boasalalmsna kana muskovolmsna. Wo Yesus nungsis vungo indhanam ten kusonam, unna, memba yimba eva aevulvpa, kana avalmsna kana boasalalmsnata. ");
INSERT INTO wrs_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Wo Yesusva Galili plombpethalla henga indhanam ishomana vinvna di. Wo indhana mindnam henga di kusopramna, engalla kekel vethapra, wo noinda Yesusva botra vonganamba, avhoa. Avhoanamba, nominiva kihhe, wo indhanamba engalla kusona, ");
INSERT INTO wrs_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","wo Yesusva hevm ishomana vinvna, olhmona unvna os, ");
INSERT INTO wrs_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","yeoa hillivm. Mongova indhanariniva osoram gavna, witmovm kokovelm gavna. ");
INSERT INTO wrs_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Himba nomba koko vengavnamba, monglava monara poksra dalvna, wo tuawa ambna, hlapia. ");
INSERT INTO wrs_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Wo monglava dalvna di pethara, nomba pethava honsra ambo dasalm lohvna, wo noinda lelnam phovna, ");
INSERT INTO wrs_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","wo okombava suwelva lovhoavnamba, witva nomba soulawol vevna, plalva pipiha vevnamoa. ");
INSERT INTO wrs_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Wo monglava witmovpa pethara dalvna, no pethava ilsasva mera lohvna, wo nomba il wunithavna, wo nihilva endvnamoa. ");
INSERT INTO wrs_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Wo monglava witmovpa petha besallava dalvnamba, wo nomba beswonam phovna, wo nihilva mindnam endvna. Mongova 30pelara endvna mongawatillava, wo mongova 60pelara endvna mongawatillava, wo mongova 100pelara endvna mongawatillava. ");
INSERT INTO wrs_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Honi olhmoa kanamba yimba hillivra, heva os aongoa keknam elepewolvra. ");
INSERT INTO wrs_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Doa nomba indkumbiva bukethavnamba, doa hevho Yesusm sahminie, no 12pelara indhana, nom hev ten pusvund venam, eva mongla ombandhana, noi Yesusm engvulvahmana vevnam. Hev Yesusm sahminie, es hevpa honamba yenamba olhmonamba plalva lohv? ");
INSERT INTO wrs_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Wo Yesus henga unna, plalmomba doarava poaita lohvna, men daipotangas ka yemba moakus unv, os Sesoa daipotava hevtindimba nembaomana vev, os yeoa pevna sahaposwomoa maivithivm. Heva os nomba indhanamba temba bukethavpa, himba Sesoamba undnahonamba ningminivmoa, noinda kava moakus unimoa, kava olhmonangas uni. ");
INSERT INTO wrs_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Doara mongo Sesoana moashulnindriniva nonora avna, ona, si os phovav sewonamba, wo os novol vena, Indhanamba si hiluvmona verava, si nungluvmona vevra, heva os owai, si beswonamba nunglivavmoa, si beswonamba levrapivolvavmoa, si humeis himba hevna indkoklamba wuleihivm, wo Sesoava hena indkoklamba poswol vinvra. Wo Yesus henga unna, moamba honamba doa yimba tombaira nunglina, wo daipotava indhanamba hona moamba wohengiv. ");
INSERT INTO wrs_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Doa Yesus unna, yimba kamba umni, olhmomba yenamba kava tit viv. Doa es eva yimba mongova kanamba olhmomba si beswonamba levrapivolvav? ");
INSERT INTO wrs_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Wo hillu, yemba kava men plalmomba ishunv, indhanariniva nomba witmovm osora koko vengavna, wo plalmomba honanamba os lohv, mongo indhanariniva Sesoana moamba ishomana vinv. ");
INSERT INTO wrs_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Wo witmovpa monglava monara dalna poksra, wo tuawa hlapia. Wo plalmomba honanamba os lohv, mongova indhanamba Sesoana moamba hillivnamba, wo Setan hev lelnam provpa, wo maikumi vewol ve, wo noinda himba Sesoana moamba maivithie. ");
INSERT INTO wrs_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Wo witmovpa monglava pethara koko venamba, no pethava honsra dasalm lohv, wo plalmomba honanamba os lohv, mongova indhanamba Sesoana moamba hillivnamba, lelnam indk vithivna, ");
INSERT INTO wrs_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","heva os moamba kek vithivnamoa, ambo sesmomowanam kleihalohvna, wo dawonam mongo sahoklava nonglaphotava, mongova indhanamba hemba os nungeilvrava, doa Sesoana moamba hilliv, wo noinda sahokla vri, wo noinda himba Sesoana moamba undsasa vrivav. ");
INSERT INTO wrs_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Wo witmovpa monglava pethara dalna, no pethava ilsasva mera lohvna, wo plalmomba honanamba os lohv, mongova indhanamba Sesoana moamba hillivnamba, ");
INSERT INTO wrs_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","wo sismba himba hevna petharamba nengeuvmona vevna andramba, wo os ningvna, heva kava diandra vivav, wohtowond lovahe, wo nomba nengavnangva ilmsna wunithavna, wo himba Sesoana moamba engivavmoa. ");
INSERT INTO wrs_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Wo witmovpa monglava petha besalla dalna, wo plalmomba honanamba os lohv, mongova indhanamba Sesoana moamba hillivna, wohkek vithivna, wo himba Sesoana andrava vewuvmona vevna, wo hena andrava inne nihilmsna endungu vinvna, monglava 30pelara, monglava 60pelara, monglava 100pelara. ");
INSERT INTO wrs_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","22","Wo Yesus henga unna, mana emamba daipotava komandhul avrava, si ambarangas dembrivav, wo mana emamba daipotava ehlatha wulaevrava, si musera viliheivav. Doa noinda yimba wokla lavvrivrava, yimba manam tekillava komandhivav. Owai osva, ambara lavraholothu, wo noinda indhanamba beswonam nokambara novvivra. ");
INSERT INTO wrs_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Himba nomba kana moamba beswonamba hiluvmona velm vevrava, heva os aongoa keknam elepewolvra. ");
INSERT INTO wrs_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Moamoa kanaoa yeoa hillivm, kek vithivm. Wo yimba indhanamba es hevpa lesvhoawol velm vivrava, ora mindnam, ora espeta, Sesoa heva hev yemba nongalvav, wo hev yemba lesvhoawol vevav, ora snal. ");
INSERT INTO wrs_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Heva os yeoa aongoa lelahapravm, wo himba nomba moamba kanamba hiluwulvahvrava, Sesoava hemba os mongmomba mumushhoa vrinvav, wo himba nomba moamba kanamba espetambo hiluwulvahvrava, Sesoava moamba nomba si wohposwol vinvav. ");
INSERT INTO wrs_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Wo Yesus unna, katindiva os phov. Mongova indhanarini innemsna osora pethara tekoko vei, ");
INSERT INTO wrs_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","wo simba mindnamba andra vungaiva, veiva, nil wulphungu ve, doa indhanarini nomba nengi, es hevpa phoi? ");
INSERT INTO wrs_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Owai, pethanapopol phoi, doa nil wulpho, wo si verava, lile, wo nihilva si endvav. ");
INSERT INTO wrs_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Si aembul verava, doa pueite, wenokombo vevavmoa. Doa Sesoana nemeltindiva os phovav. ");
INSERT INTO wrs_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Wo Yesus unna, es kava yemba hengava ishunvav, Sesoana nemeltindiva si os mindnam aevulvav, wo es kava yemba hengava olhmona ishunvav noindamba? ");
INSERT INTO wrs_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Nengara, Sesoana nemeltindiva mastatkulmsna. Kulva nomba eusikandal, ");
INSERT INTO wrs_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","heva os indhanarini kukuvungu verava osora, phorava, innemba kuvhoangu ve, wo klalva mendekli kulvuhanga vevav, doa tuawava lamba di thiwulsihavra wusivilla. Doa Sesoana nemeltindiva si os mindnam aevulvav. ");
INSERT INTO wrs_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Doa noinda Yesusva olhmongas vena mindnamba, os hev ten ishunnam. Wo indhana beswonamba hiluwulvahvrava, doa hengava Yesusva nomba ishunvra. ");
INSERT INTO wrs_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Doa olhmongas Yesusva vena, wo hevtindimangas himba plalmomba velokusa vinvna. ");
INSERT INTO wrs_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Wo nomba simba kilvravnamba, Yesus hevnam unna, botra pimba ata no plombpethallam angavav. ");
INSERT INTO wrs_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Wo indhana mendah di engalla lovahvna, hevtindi botra aevulthana, te Yesus mendah avnam, wo wonga. Wo monglava indhanamba hevna botsra avhoangana. ");
INSERT INTO wrs_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Wo mendah wongavna, vuvi mendekli vena, wo ombokva mendekli vevna, botrava sihavna, wo botra pilivhoalm vevna, ");
INSERT INTO wrs_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","wo Yesusva di omolsis livna, kuva wangtomra holothuwulvna, yihalna olvna. Wo hevtindi dehue, umnina, guru, photok, pimba pilipihalm vev botva, wo ata pimba nepola vilovav, wo yimba kamba ninginvmoa. ");
INSERT INTO wrs_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Doa Yesus pho, vuvim ovomnana, wuleiho, wo ombokm omnana, yeoa eva wuleihaota. Doa noinda vuviva wuleihana, wo ombokva eva wuleihanata, wo pomba beswonam livna, wo botva beswonam gavna. ");
INSERT INTO wrs_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Doa Yesus henga unna, es hevpa yimba pemba vivna? Yimba osva ningvnamoa, hev kamba wongav, kam beswonam kekalvho vewol vungav. ");
INSERT INTO wrs_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Wo noinda himba una, pai, es hevpa vei, wo hevm ishue, sumbho, vuviva ombokva hena moamba hillivna, wo wuleihe. Wo noinda pem vivna Yesusnapenamba. ");
INSERT INTO wrs_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Doa Yesustatanamba nohalm pulvo, Gerasanindna pethara di pulvona. ");
INSERT INTO wrs_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Wo botrini wonholopenamba engalla, wo mongova indhanariniva phona. No indhanariniva tihsongomungilva, wo noinda dai omana vevna, ");
INSERT INTO wrs_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","wo indhanahuira limana vevna pokamahulsra. Dai omana vevna, wo indhanamba eva es kekel vivta, owai. ");
INSERT INTO wrs_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Wenamba englamonglava indhanamba henamba ningewol velvohmanavna, heva os owai. Indhanamba indkumbim eva pingokoho vaomana vevnata, wemba nomba himba bilvhanga vaomana vevna. ");
INSERT INTO wrs_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Wo okombanam sinim di pokamahulsra eva olora weingona lohmana ovovna, hevm honsra pusungu vevna aiv. ");
INSERT INTO wrs_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Wo himba Yesusm nonglanga venamba, Yesusva ten botra prov, wo Yesus holopenamba, doa daikakamungil lelnam promnanamba, mulumbdandna lohvhoamna Yesusinda murapeta, ");
INSERT INTO wrs_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","doa Yesusm mindnam omnana, Yesus, yimba Sesoa mendeklina ombol, es ata yimba kamba venavav? Sesoana novra men kava yem ishomnav, manam yimba kamba ata nihsesowolm venavav. ");
INSERT INTO wrs_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","9","Doa Yesus tihm omnana, tihva nomba no daikakamungilna nihmera avna, omnana pevm sevro nihilm. Wo tih una, Mindnam, manara kava mindnam aevv. Doa Yesus tihm unna, yimba sahoklal vilov, nihmerini pulvo. ");
INSERT INTO wrs_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Doa daikakamungilva Yesusm mindnam ishomnana, tihva honamba manam yimba oklava wolanga vevav kanaminiva, owai. ");
INSERT INTO wrs_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Wo monglava deuvmotovpa mura di olopethalla ki hlalvohvna, ");
INSERT INTO wrs_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","wo Yesus no tihm wolanga velm vevna, tihva wenamona una, kamoa wolanga veo, nom deuvmotovm mera saivoe, ");
INSERT INTO wrs_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","doa Yesus unna, wouta. Doa tihva indhanarinimini pulvonamba, nom deuvmotovra sihangu vena, doa noinda no deuvmotovpa olora vitivhoalla, lomosis peivvna plombram, wo wusprowol venamba, wohdalna. Nomba deuvmotovpa eva notongopetamma, 2000pelara lovahvna. ");
INSERT INTO wrs_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Doa nomba indhanamba miemba dahwol vinamba, nomba lelnam gapiana, deuvkembelnindm ishulanginna, deuvnindm monanindm. Wo indkumbi nonglalm embanamba, es hevpa vine. ");
INSERT INTO wrs_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Doa Yesusm nonglapulvona, wo indhanarinim nom nunglina, ten doara dai omana vevnam, wo malona beswonam av, beswonam men nengavnang vawov. Doa noinda indkumbi nunglivnamba, pem vinivna Yesusnapenam. ");
INSERT INTO wrs_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Wo nomba indhanamba doara miemba dahwol vewuvnamba, noi osva no kembelnindmba ishunna, Yesusva os vini. Yesus daikakamungilmba wolaihaphona, wo tihsongova henaminiva meinda sihapieinnamba, noinda miemba nomba dalna. ");
INSERT INTO wrs_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Doa noinda no indhana Yesusm opholihina, ai kanaminioa geinu. ");
INSERT INTO wrs_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Doa Yesusva nomini botra vongo, wo no indhanarini mura pronamba, ten doara Yesusva selvhoapipahamnanam. Hev ona, Yesus, pioa engai, yei kava mongawulm ahamana velm vev. ");
INSERT INTO wrs_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Doa Yesus omnana, owai, deuvram gao, sehpevm os ishongeinu, Sesoava kamba wavra vovhoamni, wo noinda kanamba selvhoapipahai, wo kava beswonam lohv daipotava. ");
INSERT INTO wrs_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Doa himba noinda os vena, ganamba, mongona kembella mongona kembella di Dekapolisnahalm, wo nom ishungeinna, Yesusva kamba doa sishona vrena. Wo nomba indhanamba hillivnamba, os uvna, pai, es hevpa vevna. ");
INSERT INTO wrs_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Doa Yesustatana nomini botra wongavna, henga mongnahalm wonpho, wo Yesus botrini petharam holopenamba, engalla lohvna, wo indhana mindnam di Yesusinda kusoprana. ");
INSERT INTO wrs_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Wo mongo tendorini pronamba, no tendoriniva mendekli lohvna Yutanindna sembayangnindna, nihilva Yairus. Pronamba, Yesusm pethara lithamnavna novlomossis, ");
INSERT INTO wrs_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","osm vevna, Yesusm mindnam osahmanavna, omnana, momba kanamba doa indnakra vev. Pro, engla holothomno, ata noinda uvavulva wuleihavav, wo ata beswonam avav. Tahonmba henamba 12pelara lohmanana. ");
INSERT INTO wrs_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Wo Yesusva pethamna, wo ombandhanamba mindnam eva mongawulm gapiavna, mi sis nihanasis sihanasis. ");
INSERT INTO wrs_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Wo Yesusi Yairusi mendah monam engavna, mongova ungevlirini mura provna, nomba ungevlirinimba wosepul kovhoavna, tahonmba 12pelara vena. ");
INSERT INTO wrs_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Wo no ungevliriniva diva doarava aiwo vohavna obatrava mantrimba, esvemawus esvema tahon himba dembrahowovna obatramba, heva os demutrava wuleihavnamoa, ambo nihva hevnamba aiv wohgavna. ");
INSERT INTO wrs_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","28","Wo no ungevliriniva doara hellenamba, Yesusva os andra vev, doa nengvna, ambo ata eva kava Yesusna malom tuhrava, wo kamba kanandhavav. Wo Yesusva mendah monam gavna, ombandhanamba pelkleihamnavna, doa no ungevliriniva sis pethamna, Yesusna malom tuhmana englana, ");
INSERT INTO wrs_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","wo tovolva wohkik vena, wo hevm nonglana, kamba doa kanandhai. ");
INSERT INTO wrs_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Doa Yesusva nungi lilnam os nengvna, an kana meississongolpetava kenga vrei, wo meissis umharavhoa, ona, an kanamba malova tuhi? ");
INSERT INTO wrs_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Wo hevtindi umnina, snallava esm yimba owol vev? Pev nongalo, indhanamba mindnam maim ambo alalapat vev. ");
INSERT INTO wrs_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Wo Yesusva mendah ona novvungu vena, an kamba tuhi? ");
INSERT INTO wrs_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Wo ungevliriniva nomba pem eisungu vevna, wo Yesusinda muram prona, mulumbdandna lohvhoa, doa Yesusm moakus omana, kamba wosepul kovhoaomana vevnamba, noinda yemba kava tuhi. ");
INSERT INTO wrs_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Wo Yesus omnana, yimba os nengi, Yesus kanamba ata selvhoapipahavav, wo noinda yimba kamba tuhi, wo noinda yimba beswonam av. Doa beswonam gao, doa yenamba kik vei tovolva. ");
INSERT INTO wrs_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Yesus mendah no ungevlirinim ishomnavna, wo monglava indhana Yairusna deuvrini ambanamba, Yairusm umnina, doa mopevmba dahai, manam yimba ombamba Yesusm waiprovav. ");
INSERT INTO wrs_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Doa Yesusva hena moamba hillinna, doa Yairusm omnana, manam yimba duus vevav honindava, ambo kam keknam nengmanavm. Ata kava yemba beswonam vemnavav. ");
INSERT INTO wrs_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Wo Yesus ongowolna, manam indkumbiva yimba prapiavav, Pita Yems Yon yengas ambo. Yemsi Yoni etel boasalal. ");
INSERT INTO wrs_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Wo wonganamba, Yairusna deuvra wonpho. Doa Yesus os nongalna, indhana mindnam di wuo ovna. ");
INSERT INTO wrs_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Wo deuvra siha, os unna, manam hevpa yimba wuo ov? Momba honamba dahaimoa, ambo dawonam ninliv. ");
INSERT INTO wrs_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Himba olhmona ishunvna, wo no indhana los umnina, gekala ov, doa wohdahai, ata hengava snamba es phovav? Wo Yesus nomba indhanamba engalungu ve, unna, phopiao. Wo araravalm Yemsm Yonm Pitam honamangas hevho wonsiha no deuvrava, otolm ten vindilvnam. ");
INSERT INTO wrs_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Doa Yesus nom otolmindilm englaval okivra, hevna moana omnana, talita kum, osm omnavna, mo pho. ");
INSERT INTO wrs_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Doa no mutundisrinimba mindilva henga phona, beswonam lohmana vena. Doa no indhanamba deuvmera di nunglutithueivnamba, os uvna, pai, pai, es hevpa vei? ");
INSERT INTO wrs_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Wo Yesus araravalm unna, inne endaho, wo manam yimba ishuvmona vinvav indhanamba, osva Yesusva os vena, aembu. ");
INSERT INTO wrs_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Wo Yesus nomini ganamba, hevna kembellam Nasaret kembellam gana. Wo hevtindiva sis engpithina. ");
INSERT INTO wrs_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Wo sapturava Yesus sembayangduvra siha di hevna kembella, wo indhana di kusovna, wo Yesus di wonamana vevna, Sesoana moamba ishomana vinvna, doa indkumbi umnina, pai, nonorangas lohv. ");
INSERT INTO wrs_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Himba ambo andranindrini lohvna, Mariana ombol, wo hena boasalalva lovahv, Yems, Yosep, Yutas, Simon, wo eva muskovolva men euvmonav. An dihi hemba ishomnana, wo himba noinda nonorava lohv? An dihi hemba omnana, wo noinda himba mendekliandrava vaomana vev, indhanamba wolapho vaomana vev? Doa noinda duus vimnivna, moamba hillimnivnamoa. ");
INSERT INTO wrs_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Wo Yesusva hena moamba nonora, doa hem olhmona ishunna, os mongova Sesoana moashulnindriniva oklamba garava, wo Sesoana moam dim ishomana vinvra no okla kembelnindm, himba os umnivav, nonorangas lohv, moamoa hillimni. Doa no moashulnindrini henga hevindamba prorava, wo Sesoana moamba ora owalmba ishunda, no owalva os umnivav, ombandhana olohv, plohvra. ");
INSERT INTO wrs_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","6","Wo nonamba Yesusva os tungundthoawolalm vevna no deuvnindmba hevna owalmba, heva os owai, himba Yesusmba undnahonam lovahthamnavnamoa, wo noinda es eva tungundthoawol vevav ombamba, owai. Uvavulnindm eskand ambo himba hevna englava huhlinvna, wo os momongo wolapho vevna. Himba nengvna, kamba undnahonam lovahthamnavmoa. Wo Nasaretnindva owalva os vina, wo Yesus hev mongona kembella mongona kembella os lohmana vevna, Sesoana nemelmom ishollohmana vinvna. ");
INSERT INTO wrs_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Doa himba hevna hellelnindm 12pelaram unna, hom kuso, wo kusonamba, unna, yem ka poauothowol vei, wo noinda yimba angarava, yimba si os tihsongova indhanaminiva wolapho vaomana vinvav, yem ka poauothowol vei. ");
INSERT INTO wrs_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Innemba manam yimba iangavav, innemba, innewondava, diva mindnam. ");
INSERT INTO wrs_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Spatuangas vewol viu, kayen vethowol viu mongasal, wo ala pepavu. ");
INSERT INTO wrs_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Henoi samblindhana engavra, henoi samblindhana engavra, os ango. Anguwul verava, mongona kembellava yimba nomba ephovrava, di mongawaduvra dawonam wohihillohvm, inne enevm, verava, henga yimba mongona kembellamba engavrava. ");
INSERT INTO wrs_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Wo mongona kembelnindva yemba sehmonamba holvorombol owai ovitava, doa nominioa engavra, wo monara pethaslehol spaturini bumb vewol eveo no indhanana novra, osm himba ningvra, kava sahonam viv, hona Sesoana moamba kava aongpa viv. ");
INSERT INTO wrs_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Doa no 12pelara hellelnindva himba anguwul vena, no kembellam no kembellam anguwul vena, wo kembelnindm woneuvmona vevna, Sesoana nemelmoa besal ishuvmona vinvna. Os ishuvmona vinvna, yeoa sahoklamoa wuleihu. ");
INSERT INTO wrs_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Doa himba tihsongova mindnam indhanana nihmerini wolapho vewuvmona vevna, wo uvavulmungilva himba welna selvowol vaomana vinvna, wo lesvhoawol vi. ");
INSERT INTO wrs_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Yesusna hellelnindva os mendekliandra vivna, wo indkumbi hillivna, os uvna, Yesusva os vev. Monglava uvna, Yesusva Yon Baptais, ten doara dahanam, no pokamarini phona hevna nihna, noinda osva mendekliandrava vewol vev. ");
INSERT INTO wrs_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Doa monglava indhanamba uvna, owai, Yesusva Elaita, Sesoana moashulnindrini, ten doara heva amana vevnam, doa henga beswonam phona. Wo monglava indhanamba uvna, owai, Yesusva mongova Sesoana moashulnindriniva, ten doara euvmona venam pina simbehumunilmongo, doa henga beswonam phona. ");
INSERT INTO wrs_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Wo Herot kuwul hev hellenamba, Yesusva os andra vev, doa hev ona, Yesusva Yon Baptais, ten doara kav wohtvnam, wo kuwul kovheimninam buimera. Henga himba pokamarini beswonam phona hevna nihna. ");
INSERT INTO wrs_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","18","Wo honamba Herotna moana, plalva seilva os lohmanana. Yon Baptaisva mendah beswonam lohvna, he Herotm kuwulm ononglowomana vevna, os doa yimba sahokla vena Sesoana novra, etepevna Pilipna ongalva doa yimba pelvrana. ");
INSERT INTO wrs_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","20","Wo no Herotna ongal Herotias doa himba wuspromnavna, Yonm helvakomandhalm vevna. Heva os owai, Herotva monglam hevna valgonindm unna, angarava, Yonm buiram waiango, wena ningu. Herotva os nengvna, Yonmba Sesoana andranindrini besal lohv, wo himba Yonmba beswonam buirangas dawonam dahowovna. Doa himba sambla und verombvna Yonna Sesoamom. Hev indnahonam hellellohvna, doa heva os himba hevmba duus velohvna Sesoanapenam. ");
INSERT INTO wrs_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Doa sism alowoh vethana, wo Yonmba helvakomandhalva, Herotiasva vevnamba, seilva os vena. Mendah Yonmba buira livna, wo Herot inne indkumbim dahwol vevna. Nomba innemba nom ona hlavna, ten aval hevm nonam lengnam. Wo nonamba kuwulm nembaomana vena, valgonindna kuwulm, hevna andranindna kuwulm, wo deuvkembelnindna mendeklim no Galili provinsnindnam. ");
INSERT INTO wrs_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Doa Herotiasna mol pronamba, sangalna oindalohvna no indkumbi kuwulna novra, wo os una, pai, besal hevm. Wo Herot beswonam avna, no mutundisrinim omnana, doa yimba beswonam oindalohi, yemba kava ata mana emamba vraohvav. Pev orava, mani ata yemba kava vraohvav? ");
INSERT INTO wrs_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Kava gekalava ovmoa, yemba kava tanamolnam omnav Sesoana novra, mani mani mani yemba kava os dembrahowovav, eva mana emamba mendekliva yemba kava vrahangas vevra. ");
INSERT INTO wrs_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Wo mutundisrini nomba avalm Herotiasm sehgavna, os manam kava ata Herotmba omnavav, kam doa omni, pev orava, mani ata yemba kava vraohvav? Doa Herotias omnana, os ishomno, Yon Baptaisna kuwul kovhoao. ");
INSERT INTO wrs_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Wo nungi lelnam mutundisriniva ganamba, Herotm ishomnana, kava osm ov, Yon Baptaisna kuwuloa kuvulambo pirinda, ka nonglalm vev daipotangas. ");
INSERT INTO wrs_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Herot hellenamba, duus vevna, heva os hev doa musera omni mutundisrinim, es hengava eva kava ovovav. ");
INSERT INTO wrs_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Wo lelnam hevna valgonindrinim wuleihanganamba, Yonna kuwul kovhoaka di buimera. Venamba, henga prona, ");
INSERT INTO wrs_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Yonna kuwul pirinda kovopethana, mutundisrinim vraohna, wo mutundisrini avalinam kuvunga, nethamna. ");
INSERT INTO wrs_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Doa Yonna hellelnindva buiduvram anganamba, Yonna nihil vindilhalvonamba, singvi. Doa honamba plalmomba os lohv, Yonmba helvakomandhivnamba. ");
INSERT INTO wrs_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Wo Yesusna hellelnindva 12pelarava mendah anguwul vevna andram. Vevnamba, henga Yesusindam kusopho ve, wo Yesusm moa ishumnina, hev ten indhanam Sesoamoa ishuvmona vinvnam, selvhoapipaha vaomana vinvnam kinwondam. ");
INSERT INTO wrs_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Wo nonamba indhana mindnam Yesusindam kusonamba, osm honi pim tungundthoawol ve, wo noinda innemba Yesustatana indwonamba hlalvohvnamoa. Doa Yesus hevtindim unna, pioa dem angai indhanahuiram, wo dawonam di eha vawovav. ");
INSERT INTO wrs_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Wo noinda botra wonvongo, dem wonga, hev ten wonishonam. ");
INSERT INTO wrs_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Wo mendah pomonam angavna, indhana mindnam no kembelnind no kembelnind di engalla luhungu vevnam, nongalvohvna, ona ten wongav. Wo noinda hesna engalmonam lelnam gapia, dom Yesus ten wongavnam. ");
INSERT INTO wrs_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Wo Yesusva di botrini wonholopevna, nomba indhanamba di doara ksulvna. Wo Yesusva nongalvna, nengvna, os wavro, hona indhanamba sipsipmsna aevulv, no sipsipmba aralva dahwol vevmoa beswonamba. Sahonam aevulv, wo noinda kamba tellohmana vev, Sesoana moam hillilm. Wo noinda Yesusva hem wonamana vevna, Sesoana nemelmomba ishomana vinvna mindnam. ");
INSERT INTO wrs_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Wo okombava vohavnamba, hevtindi Yesusm ishumnina, huiva innemba nalohvmoa, wo si ata kilvravav, ");
INSERT INTO wrs_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","no indhanamoa wolanga veo, wo mongo kembellam dom angara, wo innem di sovawol vira hevm. ");
INSERT INTO wrs_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Doa Yesus hev unna, pev hemoa inneoa dahwol viu. Wo hevtindi una, pai, diva esvemava heni kava dumbvav, wo nona innemba sovawol virava, wo hona indhanamba dahwol vi, owai. ");
INSERT INTO wrs_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Wo henga Yesus sah owol ve, es yimba innemba pivnamba temba ieivv, nungsis vituk. Doa nunglinamba, henga una, rotiva pinamba limara aiv nunguluhunv, vei tambkova sambla. ");
INSERT INTO wrs_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Wo Yesus unna, indhanam unu avhoaprara pethara smosra. Monglaoa indanam aevulthavra, monglaoa indanam aevulthavra. ");
INSERT INTO wrs_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Wo noinda aevulthanamba, monglava 100pelara, monglava 50pelara, os avhoangu vevna, mindnam. ");
INSERT INTO wrs_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Doa Yesus no roti tambko dombnamba, wo nov vevongovna, wo Sesoam sembayang venavna, yimba besal, lehra yimba vei. Venamba, rotiva popowol vinna hevna hellelnindm, unna, moang vinu indhanam. Doa tambkova eva os venata, indkumbim moang vinna. ");
INSERT INTO wrs_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","44","Doa indkumbi hlanamba, emba pilivhoangu vinna. No tendomba temba Yesusva dahwol venamba eva indpetamma 5000pelara, wo eva ungevlitundism es eva sevel viv? Doa hev os vina, hlawol loh venamba, eunumbulva pinge. Wo Yesus unna hevna hellelnindm, eunumbuloa henga nooa dembunu. Doa 12pelara wondamba nomba innemungilva nunguwul vina, pilivhoawol vi. ");
INSERT INTO wrs_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Wo Yesus hevtindim unna, yeoa botra vongopiao, nohalm plombnahalm yesna ango, Betsaita kembellam ango. Unnamba, ");
INSERT INTO wrs_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","doa no kembelnindm unna, pevna deuvram beswonam anguwul veo. Venamba, hevpa hevhova lumbullam indhanahuiram vonganamba, di Sesoam sembayang vaomanavna. ");
INSERT INTO wrs_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Doa si kilvravnamba, hevtindiva mendah plombhovmonam angavna, botva wulangavna, ");
INSERT INTO wrs_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","wo hev nongalga velohvna, vuvikoklara botva sahavrevna, angalmba. Doa si indulnam Yesus sis engilgavna, plombsra monglana ambo gavna. Murava nongalphovnamba, kuelwolalm vevna, ");
INSERT INTO wrs_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","50","hevtindi di onunglina, sumbho temba provmi, wo pem mindnam daikaka ovuvna. Wo lelnam Yesus ovunna, manapenam yimba uv, memba ka prov, indwonam aevu. ");
INSERT INTO wrs_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Wo himba botra engalvungo, doa noinda vuvi wuleihavnamba. Wo henga nengavnang vewuvna, pai, es hevpa osva vev? ");
INSERT INTO wrs_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Tit vivna, himba Yesusmba levrapivolvnamoa. Yesusva no rotiva tambkova espetava hena novra pavmong vinna, osm mindnam phona, heva os owai, mendah himba levrapivolvnamoa Yesusmba, ora snal lohv. ");
INSERT INTO wrs_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Doa plombmonam os wongavna, pethara pulvonamba, Genesaret pethara pulvona, wo botva engalla viliheivna, ");
INSERT INTO wrs_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","wo botriniva wonvenamba, wo indhanamba no kembelnindva di nunglutithueina, os Yesusva hevpa teprov, ");
INSERT INTO wrs_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","doa lelnam kembellam anguwul venamba, uvavulmungilm towara aiemb vevna Yesusindam. Doa Yesus mongona kembella mongona kembella os lohmana vevna no pethara. Wo indhana uvna, Yesus no kembellam doa gai, wo indhana hillivna, wo uvavulmungilmba os no kembellam tungiangavna. ");
INSERT INTO wrs_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Yesusva os lohmana vevna kembella, kota mendeklira, wo indhana uvavulmungilmba towara aiemb vevna museram monaram. Wo Yesus mura gavna, no uvavulmungilva Yesusm osihminivna, ambo ka yena kayenmulm ambo tuhi, doa himba nomba tuhvnamba, himba nomba lesvhoawol vevna. ");
INSERT INTO wrs_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","4","Wo Varisinind, katekis Yerusalemrini ambanamba, Yesusina kusona. Nonindva himba simbehumunilna moamba wulaevvna, wo mindnam ninginvna, os uvna, innemba yimba manam hlavav, yimba englava poswol vehui vivrava mindnamba. Maketrava yimba sovawol vevrava, wo hengava yimba deuvramba iprovrava, boasna mindnam pora dalohavrava, inneoa os nevm. Wo mongona moamba os una, mokoa pirinioa sospanoa no innesowarinioa mindnam poswol vivm. Wo eva pevna ninvhomoa poswol vivm. Wo hona simbehumunnamba wevsava henamba os luhunvna mindnam, wo Yutanindva mindnam engivna os. ");
INSERT INTO wrs_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Doa no indhanamba Yesusm nonglapulvo, wo os ishumnina, yetatanamba osva vivmoa, kava memba vivpa, himba englava poswol vivmoa mindnamba, owai, innemba ambo nis hlav, wo noinda pivna simbehumunna wevsava maisasa vriv. Es hevpa himba osva viv? Sahokla viv Sesoana novrava. ");
INSERT INTO wrs_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Doa Yesus hev unna, yimba gekala uv, yimba sambla indna vilov. Yimba simbehumunna moamba vriv, os yimba uv, kava Sesoana moamba memba vriv. Heva os owai, undnahonamba yimba Sesoamba lovahthamnavmoa. Tanam Aisaia doara novol vena yena wevsanamba, wo os he novol vena, Sesoa osva ona, hona indhanamba kamba okuliv moana, heva os owai, undnahonamba kamba lovahthamnavmoa. ");
INSERT INTO wrs_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Himba ombam kamba ambo dasalm sembayang viniv, himba simbehumunilna wevsana vivna, himba uvna, memba Sesoana wevsana pimba viv, heva os owai. ");
INSERT INTO wrs_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Doa Yesus henga unna, Sesoana moamba yimba ahnam piengiv, wo simbepevna moa wulaevv. ");
INSERT INTO wrs_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Yimba os ningv, beswonam kava viv, heva os owai, sahoklal. Yimba osva viv, yimba Sesoana moamba wuleihiv, simbehumunna wulaevv. ");
INSERT INTO wrs_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Moses doara Sesoana moamba novol vena os, Yeoa arapevna moamoa hillinvm, wo nesmos ambo vewol vivm. Mongova yeriniva himba nomba araravalmba tandwolva vevrava, wo yeoa henomoa eva perkarra wonvivm, wo helvakomo wohvivm ");
INSERT INTO wrs_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Sesoa os unna, heva os yimba pev indamona ishunv, os beswonam indhanariniva araravalmba ovunvra, yem ka beswonam nesmos vewol velm vev, heva os owai, kava korpanna wevsa vena, wo noinda diva kanamba Sesoamangas nalohmanav, yem kava nesmos vewol vevavmoa nonamba. ");
INSERT INTO wrs_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Yimba indhanamba osva numhowol vivpa, wo eva himba noinda Sesoana moamba ahnam piengiv, araravalmba beswonamba nesmos vewol vivmoa. ");
INSERT INTO wrs_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Simbehumunilna wevsana yimba osva numhowol vivpa, wo noinda indhanamba Sesoana moamba ahnam piengiv. Memba wevsa sahoklal yimba viv, wo mendah sahoklalva mindnam yenamba luhunv snal men. ");
INSERT INTO wrs_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Wo Yesus ombandhanam henga unna, indkumbi kusotok, kam hillu, wo pisuvu. ");
INSERT INTO wrs_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","16","Yimba os ningvma, kava honatongo innemba hlavrava, wo noinda kana indkoklava si osva lohvav Sesoana novra? Yimba os ningvma? Owai osva, yimba es eva sahonam vivavma innerava, owai, pevna nengavnangnangas yimba sahoklava viv, wo noinda Sesoana novra yena indkoklava luhunv. ");
INSERT INTO wrs_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Wo Yesustatanamba nominiva wonvenamba, wo mongona deuvra wonsiha. Wo wonavhoanamba, doa hevtindi umnina, hona moamba plalva es hevpa lohv? ");
INSERT INTO wrs_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Wo Yesus unna, yimba os tit vivma, ten mongona indhanamba tit vivm? Mendah yimba os ningvma, honatongo innemba kava hlavrava, wo noinda kava sahoklalva lovahvav Sesoana novra? ");
INSERT INTO wrs_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Owai, innemba yenamba undrava sihavmoa, osmba indkoklal lohmanara, owai, innemba ambo yenamba eramba sihav, doa henga di kakusra. Wo Yesusva himba osva ovunnamoa, mongova innemba manam yimba hlavav, owai, innemba besalangas. ");
INSERT INTO wrs_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Wo henga ishongeinvna, pevna nengavnangna yimba ambo Sesoana novra sahokla viv. ");
INSERT INTO wrs_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Nengavnangva sahoklal indhanamba vewuvmona vev, os goariskui viv, yukov viv, indhanam helvakomo viv, ");
INSERT INTO wrs_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","muemb viv wohm, ungevlim, moangakala ovriv, kelsombovho viv, tandmoa ishuv, besalmba moamba hillivmoa. ");
INSERT INTO wrs_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Sesoa hev hona sahoklava nongalv, indhana hevna nengavnangna ambo viv, wo noinda himba sahoklalva lovahv Sesoana novrava. ");
INSERT INTO wrs_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Doa Yesusva nominiva wonganamba, wo Tair kotara wonphona. Phonamba, mongona deuvra wonsiha di, os nengvna, manam ombandhana mendalm kusovma, kavtindim kava wonishomana velm vev. Heva os owai, es eva ata wonkithata, indhanana novsra wonamana vevna. ");
INSERT INTO wrs_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","26","Wo mongova no kembella di avna Ponisia ongoriniva, Yutanindriniva owai. Himba Siria petharini, wo hena moamba Grikna moamba. Wo no ungevlirininamba molva, tihva doara nonglana. Doa aval hev os hellena, Yesusva di mongona deuvra amana vev, wo hev Yesusindam lelnam ga. Ganamba, Yesusinda di vendapi, osm vevna, Yesusangas mendekliva lohv. Vendapenamba, doa Yesusm osahmana mindnam, kana molnamini tihsongom wolaihangamno. ");
INSERT INTO wrs_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Doa Yesus olhmona ambo dembhamnana, manam kava otolna innemba dembringa vinvav windemba, osva owai. Boasna kava otolm innemba dahwol vevav, pilivhoawol ve. Osm ovna, boasna kava Yutanindmsna tungundthoawol vepiarava, wo yemba mongnindmba mendah dawonam. ");
INSERT INTO wrs_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Doa himba ona, tanam yimba ovta, heva os monglava windemba inneslehol ambo hlawol vev, noi otol ten pethara dembrapuv vevm lomungillini. ");
INSERT INTO wrs_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Wo Yesusva omnana, lehra yimba osva ovta, wo ye os ishoiva, wo noinda doa kava mopevnamba tihsongova wolaihangai, deuvram mopevindam gao. ");
INSERT INTO wrs_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Doa hev ganamba, molm di nonglaphona, beswonam av, nin ambo liv, wo tihsongova doa wohgamni. ");
INSERT INTO wrs_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Wo Yesus nomini Tairrinimba wonga, wo Saitonda wonkohanamba, mongo pethara wonkohanamba, no pethava os ningthiv Dekapolis. Doa Galiliplombra wonpho, ");
INSERT INTO wrs_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","wo indhana di waiambna anguminam. Angumina, heva os ishovnamoa beswonam moamba. Waipulvonamba, Yesusm umnina engla holothomno hona indhanarinim, noinda lesvhoara. ");
INSERT INTO wrs_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Wo Yesus anguminam dem oklapetam waingana indhanahuiram, doa englapundna angoval tuhowolmana. Doa hevna englapundm limbenenamba, doa angumina mindem tuhe. ");
INSERT INTO wrs_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Doa ovm nonglavongo vevnamba, kinda wusprovnamba, os nengvna, kava kavm kinwonda kethav hona anguminindrinina. Doa anguminam hev omnana hevna moana, epata, osm temba omnavna, mengna aongnaoa yenaoa pasapo vera. ");
INSERT INTO wrs_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Osoa venana, wo beswonam helwolvna, wo mindemba henga kikih promnana, moa beswonam ishovna. ");
INSERT INTO wrs_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Doa Yesusva indkumbim ongowole, manam yimba osva ishuwul anguwul vevav, os Yesusva vei, owai. Heva os owai, moamba os wulvahmana vena, wo Yesusva eva mindnam ongowolvna, indhanamba henga mindnam ishuwul anguwul vevna. ");
INSERT INTO wrs_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Wo indkumbi no moamba hillivnamba, una, pai, besalangas, Yesusva mani mani mani vewol vev. Seilva angumi vevna, wo daipotava beswonam helwolv, moahuiva, eva nomba henga moa ishuv. ");
INSERT INTO wrs_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","2","Wenokombowonamba owai, indhanamba mindnam lelnam Yesusina kusonamba, Yesusna moam hellelm vevna. Wo Yesus hevtindim unna, kusotok, no indhanam kava wavra vovhueinv, manara noinda sambla mongonin pimund doa aevvna, wo daipota innehui. ");
INSERT INTO wrs_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Wo pondava kava hengava wolanga verava hevna kembellam, monglava ata ponda daikaka velangavav, manara mongova monamba murama. ");
INSERT INTO wrs_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Wo Yesusm hevtindi umnina, huiva osomba lohvmoa, heni pimba ata no indhanamba dahwol vivav, owai? ");
INSERT INTO wrs_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Wo himba osihinna, es yimba innemba ieivv? Wo hev una, 7pela rotiva kava ieivv. ");
INSERT INTO wrs_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Wo Yesus indkumbim indhanam nom unna, hui pethasra avhoapro. Wo roti no 7pelara dombnamba, wo Sesoam os ishovongo ovomnana, lehra yimba kamba dembrahuni. Doa englana popowol venamba, hevtindim unna, moang viwul vinu indhanam, wo osva vina. ");
INSERT INTO wrs_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Tambkopetava eva Yesusm dembrehunamba, wo Yesus henga Sesoam os ishovongo ovomna, besal, doa henga unna, moang viwul vinu, wo osva vina. ");
INSERT INTO wrs_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","9","Wo hlanamba, doa emba pilivhoangu vina, wo no indhanamba eva indpetamma, hui 4000pelara lohvna. Wo nomba innemungilva hetindiva henga wondara nunguna, wondamba nomba 7pelarava pilivhoawol vena. Doa indhanamba nokra Yesusva unna, doa deuvram pevindam gapiangu veo. ");
INSERT INTO wrs_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Doa nonamba lelnam Yesusva nominiva botra wonvongana hevtindimba. Wonvonganamba, Dalmanuta petharam wonga. ");
INSERT INTO wrs_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Doa monglava Varisinind ambanamba, Yesusm ambo dasalm osihminivna, os umnivna, kana novra mana ema mendekli vintuk, wo osva kava yemba nunglutithueivav, tanam Sesoa hev yemba pusvundthoana. Himba Yesusmba undnahonamba lovahmanavnamoa, himba ambo dasalm umnivna. ");
INSERT INTO wrs_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Wo Yesus mindnam ninginvna hona moarava, undva henamba potra pihamnana. Doa hev unna, es hevpa yimba ambo novolm ambvma. Yemba kava tanamolnam ishunv, kava yena novrava mana vemamba mendekliva vinvmoa, owai. ");
INSERT INTO wrs_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Doa Yesusva henga nominiva hevtindim wonvenamba, botra wonvongavna, plombmonam wongavnamba, ");
INSERT INTO wrs_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","wo hevtindi umnina, pai, pimba innemba dumbimoa, rotiva mongasal memba nungaihalohv. ");
INSERT INTO wrs_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Doa Yesus unna, ai kam hillu, manam yimba Varisinindna Herotkuwulna rotiva hleinvav, owai, aembu, henamba sahoklal vilinv. ");
INSERT INTO wrs_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Wo hevtindiva no moam hillinamba, wo hevm asahmana ovna, manam osva oi, pimba rotiva dumbimoa, wo hlavavmoa. ");
INSERT INTO wrs_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Wo Yesus unna, manam yimba pevpa osva ishuv, kava rotihui. Mendah kana olhmomba yimba tit vrivma, undhui yimba vilovma? Kava rotimba ovmoa, kava Varisinindm eva Herotm nom unvna. Hena wevsava indkoklal luhunv, wo yimba hena moamba hillindava, yimba eva os vivavta. ");
INSERT INTO wrs_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Wo yenamba novpa lovahinv, heva os owai, yimba nunglivmoa. Yenamba aongva lovahinv, heva os owai, yimba hillivmoa. Yimba kana moamba levrapivolvmoa owai, mendah yimba tit viv. ");
INSERT INTO wrs_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Yimba nunglinama, nomba seilva temba kava rotiva 5pelarava popowol vinnamba, 5000pelara indhanamba dahwol vena? Wo innemungilva nomba, es wondamba lohna, yimba nunguwul vinamba? Wo hevtindi una, 12pelara wondamba. ");
INSERT INTO wrs_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Wo Yesus henga unna, lehra, wo kava henga rotiva 7pelarava popowol vinnamba, doa 4000pelara indhanam dahwol vena, wo innemungilva nomba es yimba nunguwul vina? Wo una, 7pelara wondamba. ");
INSERT INTO wrs_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Doa Yesus unna, lehra, heva os owai, mendah yimba levrapivolvmoa kamba, ora snal lohv. ");
INSERT INTO wrs_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Doa nominiva wonganamba, Betsaita kembella di wonpho, wo botrinimba wonholopenamba. Wo indhana mongom novtitmungilm waiambanamba Yesusindam, wo Yesusm osihminina mindnam, engla holothomno, lesvhoara, noinda os novvera beswonam henga. ");
INSERT INTO wrs_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Wo Yesus kleihavranamba nom novtitmungilm, doa oklapetam wainga kembelliniva, wo muembna novval pelpethamnana, wo os englanamba kevra, es hevpa yimba doa beswonam novvevma? ");
INSERT INTO wrs_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Wo no tendoriniva eskand ambo novvevnamba, ona, kava nongalv, maim oi timba lovahv, heva os owai, lovahmana vev, wo noinda kava os nongalv, indhanamba. ");
INSERT INTO wrs_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Doa Yesus henga novval kevra, wo beswonam he wohnovvevnamba, beswonam mana emamba nonglavna. ");
INSERT INTO wrs_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Wo Yesus omnana, pevna deuvram wohgao, di ishunu, wo homba hengava indhanamusarava manam yimba sihavav, owai. ");
INSERT INTO wrs_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Wo nominiva Yesusva wonvenamba, Sisaria Vilipai kembellam wongavna, wo monara Yesus hevtindim osihinna, indhanamba indkumbiva es hevpa kamba ningminiv, an hevpa kava lohv? ");
INSERT INTO wrs_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Hev umnina, monglava yemba os sevriv, Yon Baptais henga pokamarini lohv. Wo monglava os uv, yimba Elaita moashulnindrini, doara pethara men amana venam, wo monglava os uv, yimba mongo Sesoana moashulnindrini, ten doara pethara hui men euvmona venam, wo henga beswonam phona. ");
INSERT INTO wrs_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Wo hev henga unna, yimba pevpa es eva kamba ningminiv, an kava lohv? Doa Pita omnana, yimba mendekli lohv, Kristus, doara Sesoa yemba pusvundthoana, wo hom petharam yem doa wolaihapihana, kam kolvrowol velm. ");
INSERT INTO wrs_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Wo Yesus unna, lehrata, heva os manam yimba hona moamba moakus uvav, owaiangas. ");
INSERT INTO wrs_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Doa nonam moakus unnata, osva ona, kamba si sahokla vrivav. Kava arana ombol lohv, heva os kamba si hilvivav, nihsesoa vrivav. Indkumbiva nomba mundil, katekis, sembayang andranindna kuwul, himba kamba si musk vinivav, wo kamba helvakomandhivav, kamba si wohdahavav. Heva os simba sambla si elohvrava, si kava henga beswonam phovav pokamarinimba kavna nihna. ");
INSERT INTO wrs_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Wo Yesusva osva moakus unnamba, wo Pita Yesusm waingana oklapetam, okusv vena, manam yimba osva ishov, kamba si dahavav. ");
INSERT INTO wrs_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Wo Yesus umharavhoanamba, hevtindim nongalvnamba, Pitam ononglavna, wuleihao, Setannamini yimba moamba kovovrav. Yimba ambo titmom ishomnav, wo Sesoana nengavnangva yimba tit venav. ");
INSERT INTO wrs_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Wo Yesus unnamba, ombandhanamba kusorava, kam hillu katindimongo, himba nomba kamba engpethalmba vevrava, osva katindilmba sihalmba vevrava, heva os himba nomba hevna nengavnangva wuleihavra, kana nengavnangna vevra. Osangas vevra, wo eva lehra himba keknam lohvra ungundna novrava. Manara, noinda si ungundva hemba nihsesowolm vinivav, os kavm men. ");
INSERT INTO wrs_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Heva os himba nomba hevna nihtovpa lelh vrevrava, os nengvra, es kava beswonamangas avra, hemba nomba si dahavav, wo Sesoainava si avavmoa. Heva os himba nomba hevna nengavnangva wuleihavrava, kana kek vethavra, himba nomba si wohlohvav Sesoaindamba. Himba hevna nengavnangva wuleihavrava, wo kana besal nemelmom hellevra, wo indhanamoserava ishomana vinvra. ");
INSERT INTO wrs_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Katindiva osangas vivra, wo es hevpa mongo indhanariniva hevna nengavnangva vevrava, wo wohva esvema huhul vevrava hona petharava, wo sisva dahavra. ");
INSERT INTO wrs_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Doa es hevpa himba nomba besalmonam gavavma, owainonoa, mani hevna woh noi si kolvravavma, owai. ");
INSERT INTO wrs_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Doa himba nomba yeriniva pemba vetava, osva kanamba moamba ishuhuiva vintava indhanamoserava, hemba nomba kava si beswonamba nonglavavmoa, nonamba hengava kava provrava. Manara noinda himba lou vivna, kana moamba ishunilmba hona pethanindmba sahoklalva. Kava arana ombol lohv, doa kava si sewonam henga hona petharam provav, Sesoana besal ovsongolnindm kava si os wonprovav, wo nonamba Sesoana pusambakambava kam lovhoamnavav, pethanindna novpa sowaivunvav. ");
INSERT INTO wrs_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Wo Yesus mendah ishongeinna, hillivm beswonam, tanam kava ov, hona pethara si Sesoana nemeltindiva musera phovav. Si phorava, yimba monglava mendah si os pehnana lovahvav, wo pevna novna yimba si os nunglivav, uvav, keknamangasm lohv. ");
INSERT INTO wrs_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Wo 6pelara simba shulanganamba, Yesus vena, Pitam omnana Yemsm Yonm nom unna, wo mongo olora wonvongo hevho. Doa himba ona nunglina, pai, Yesusna nihva doa nilhai, ");
INSERT INTO wrs_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","wo kayenmba lovhoamnav henamba dombalnonoa, oi okomba lovhoav. Anna eva malova osva phovav, ponamba sabonnamba pos verava, owai, osva henangas vei. ");
INSERT INTO wrs_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Henga ona nunglina, pai, doaramini simbehumunil sambla Mosesi Elaitai wai ihisholohv, no Sesoana moashulnindrini sambla doara ten ahamana evevnam. ");
INSERT INTO wrs_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","6","Doa Pitava Yemsva Yonmba, himba mindnam pem wonvevna, moamba beswonamba ishuvnamoa. Wo Pitana moa di kuelwolgana, ona, lehra kava ambei homba, yem nongalalm. Ka thindruv wondembrawol vei, vera yem, Mosesm, Elaitam, honam. ");
INSERT INTO wrs_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Wo Pitava mendah ishovna, wo tekopukul pihanamba, mera ve, wo Sesoava no tekomera di moamba opinna, kana memba ombolnonoa, hem kava mindnam und vev. Hena moamoa keknam yeoa hillimnivm. ");
INSERT INTO wrs_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Wo Pita Yems Yon henga hev ona novvina, pai, Mosesiva Elaitaiva es evei, Yesusangas hevho lohv memba. ");
INSERT INTO wrs_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Doa henga wonpiha olorinimba, wo Yesus unna, manam yimba ishunvav indhanamba, osva temba yimba nungliva. Kava arana ombol lohv, wo kava si pokamarini henga phovav, wo nonam daha yeoa moakus unu, temba pevpa nungliva. ");
INSERT INTO wrs_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Wo moamba nomba wohkek vithina hevm samblamongo indhanamba, doa hevm asahmana ovna, hona moamba Yesusva memba oiva, osva kava henga si phovav pokamariniva, honamba es hevpa dihi plalva lohv? ");
INSERT INTO wrs_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Doa hev henga Yesusm osihminina, es hevpa katekisva os pimba ishowol velvohinvna, nomba Elaitava simbehumunilliniva hona petharava si hengava phovav miva, wo Kristus hev si os phovav sis? ");
INSERT INTO wrs_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","13","Wo Yesus henga unna, tanamta, Elaitamsna miva phovavta, wo mana emamba mana emamba os nemel henga wohvewol vevav, wo daha Kristus hev sism phovav. Wo men kava yemba ishunv, Elaitamsnamba doa doara phona hona pethara, Yon Baptaisangas. Wo doa yimba nonora, indhana hevna nengavnangna hem sahokla vrimnina, doa helvakomandhina. Os vinina, ten doara Sesoana moashulnindrini tombaira novol venam. Wo yimba nunglinama, mongmomba tombairava novol velohv, indhanamba Kristusmba hevmba dembhimnivav eva kinwonda plothumnivav, men kamba. ");
INSERT INTO wrs_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Wo Pita Yems Yon Yesus no olorini peivvnamba, ona nungeilna, pai, indhanamba es kusoi. Wo mongova Yesustindiva mera vina, katekismund hevm di anonglamana ovovna. ");
INSERT INTO wrs_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Wo Yesusva ona phona, no indkumbiva una, pai, Yesusva hevpa ten prov, wo Yesusindam dem gapianamba, di mapotho ovrivna. ");
INSERT INTO wrs_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Doa Yesus osihinna, manamoa yimba eishovna?, ");
INSERT INTO wrs_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","18","Wo mongo tendorini os sevrana, ombmba kanamba tihsongomungil menav, moamba ishowol vevmoa, wo no tihsongova ombva doara vromana vev, pethara lukuhpe, wo mius vevpa, wo lo bombothovpa, kikmik vevpa. Wo noinda yeindam kava waiproi, wo yenisrava yetindim kava osihiniva, tihsongom ombnamini wuleihingimnu, heva os owai, lehloh venapia, owai. Nom kava ishuvna. ");
INSERT INTO wrs_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Yesusva no moamba hellenamba, unna, yimba indkumbiva kamba undnahonamba lovahthamnavmoa, osva himba hona tuendisrinimba wolaihaphovav, wo slei kamba yeindava gimus vinivma? Doa tuendisrinim hom waiambo kaindam. ");
INSERT INTO wrs_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","No tuendisrinim waiambna, wo tihsongova Yesusmba nonglavnamba, tuendisrinimba kekel vevna, wo tuendisriniva eisvna, pethara lipe, di umharavho vre, mius vevnamba. ");
INSERT INTO wrs_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Wo Yesus aralm sah ovrana, es hevpa doara os vaomana venavma? Wo aral omnana, eie doara tueind venana. ");
INSERT INTO wrs_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Doara ambo hona tihsongova nihmera sihamnanamba, wo mindnam helvakomandhalm velohv. Os suwera luweihav, eva pora levelthav. Doa yeoa osoa kana ombm wolaihapho, tanam yimba wolaihaphovavmi owaimi? ");
INSERT INTO wrs_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Wo Yesus omnana, manam yimba sambla undva verombvav, ai tanam ata wolaihaphovavmi owaimi? Manara noinda himba nomba kamba keknamba nengmanavrava, hemba nomba ata kava mana emamba mendekli venavav. ");
INSERT INTO wrs_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Doa aralva mindnam omnana, kava os nengvta, yimba ata venavav, pev kana indoa keknam lotho, wo mindnam kava ata yemba os nengmanavav. ");
INSERT INTO wrs_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Wo nonamba indkumbiva kusopravna, wo Yesus nongalna, doa mindnam tihsongom ononglana, wuleihao, wohgao, manam yimba hengava hona tuendisrininamba nihrava sihavav, yimba sahokla vrenamba mahui angumi hona tuendisriniva. ");
INSERT INTO wrs_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Wo tihsongo weingo ovna eunillam, mindnam wongapola vrevnamba tuendisrinimba, doa os nihmerini phona, wohgana os. Wo tuendisrinimba nomba di vindilvna, wo indhana os uvna, doa wohdahai, ");
INSERT INTO wrs_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","heva os Yesus englaval kevranamba, wuleihapho, wo lohvna beswonam, tihsongo doa gana. ");
INSERT INTO wrs_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Wo Yesus nominiva wonvenamba, mongona deuvra wonsiha, doa hevtindi hem osihminina, es hevpa eva manara kava owai viv, tihsongova nomba engalva? ");
INSERT INTO wrs_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Wo Yesus unna, himba nomba Sesoam aram sahlohmanavna elsus, wo hemba nomba Sesoa poauothovav, noinda tihsongova snamba himba engalomana vevav. ");
INSERT INTO wrs_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Wo Yesus nominiva wonvenamba, Galili provinsra wonkohanamba, os nengvna, ata humeis kamba mongova indhanarinimba dihi nongalvav, ora men wongav, ");
INSERT INTO wrs_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","manara noinda osm wonvevna, himba hevtindimangas wonamana velm vevna, os unvna, kava memba arana ombol lohv, heva os kamba si sahokla vrivav, wo si ungundna englisra desvhueivav, wo kamba si helvakomandhivav. Doa samblanin kava si verava pokamarava, henga beswonam pholahanga. ");
INSERT INTO wrs_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Wo hevtindiva hillivnamba, tit vivna, manam os ov, wo pem vimnivna osahmanalmba, osva manam hevpa yimba osva onengv? ");
INSERT INTO wrs_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Wo Kapaniam kembella wonphonamba, mongona deuvra wonsiha, wo Yesus di hevtindim osihinna, manamoa yimba monarava ishulambvna? ");
INSERT INTO wrs_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Wo monarava nomba moamba ishulambanamba, an pina kuwulva wulluhunv? Yesushui hev ishuvna, wo noinda hevm alhwol wulambvna. Wo Yesus osihinna, wo himba lous vrivna, ata es ishumnivav, monarava doa pimba koasromb vei. ");
INSERT INTO wrs_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Doa Yesus avhoanamba, unna, hui aevtho, moapeta yemba kava ishowolm vinv. Himba nomba yeriniva kuwulva wulluhulva vinvrava, hevmangasva owai, indkumbim ninginvra. ");
INSERT INTO wrs_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Doa Yesus mongo otollinim kleihulpronamba, wolaiha hovra. Wo englana hev nimbis othomnana, wo hevtindim henga unna, ");
INSERT INTO wrs_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","himba nomba hona otollinimsnamba beswonam mapotho ovrarava, oi otolva Yesustindirini, wo himba nomba kavmba osta mongawulmba mapotho ovravav. Wo himba nomba kamba osva mapotho ovrarava, himba nomba Sesoamba hevmba eva osta mapotho ovravavta mongawulmba, nom ten kam wolaihapihanam. ");
INSERT INTO wrs_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Doa Yon Yesusm omnana, kava indhanarinimba os nunglina, tihsongom wolanga vevna indhanana nihmerini, wo yena nihilva sevromana vevna, os tihsongom wolanga vevna. Wo noinda kava ovumnina, yimba karini luhunvma? ");
INSERT INTO wrs_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Doa Yesus unna, manam yimba osva hengava vivav. Himba nomba mendekliandrava vewol vevrava, kana nihilva sevromana vevrava, indhanam os wolapho vevrava, himba nomba kamba dathovavmoa nunginamba. ");
INSERT INTO wrs_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Himba nomba pimba vreipra vremba owai vitava, himba nomba pina sehel pina mongawa andranindrini. ");
INSERT INTO wrs_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Tanam yemba kava ishunv, indhanariniva yemba nongalvrava Kristustindi, wo noinda yemba ambo pongas dahwol vevra, no indhanarinimba sesva si kava nesmos vrevav. Tanamolnam kava ov. ");
INSERT INTO wrs_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Wo Yesus henga unna, memba wevsa sahoklal prov, indhanarini otollinim mai vrev, wo noinda otolliniva sahonamba vev, nomba temba kamba lovahmanavpa indnahonamba. Sesoa nomba indhanarinimba kinwonda plothomnavav os i, wo himba os ovav, pai, kamoa doara dahata wanplombra, kava ata osva indkoklava vetamoa. ");
INSERT INTO wrs_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","44","Doa henga olhmona unna, himba nomba sahoklava noi hevna englanamba nengvtava, os maim ora, englaoa nooa kanaoa kav kokoihanga vera. Os kava si Sesoaindam mongawa englana gavav, sambla englanamba si humeis kava suweram gavm, no suwemba wohtawov. ");
INSERT INTO wrs_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","46","Doa himba nomba sahoklava noi hevna monglanamba nengvta, os maim ora, monglaoa nooa kanaoa kav kokoihanga vera, os kava si Sesoaindam mongawa monglanamba gavav, sambla monglanamba si humeis kamba suweram holopisuvvm. ");
INSERT INTO wrs_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","48","Doa eva himba nomba sahoklava noi hevna novnamba nengvtava, os maim ora, novoa kanaoa kav velaihanga vera, os kava si Sesoana kembella sihavav mongawa novnamba, sambla novnamba si humeis kamba tembaikassra pilpiangivm, domba temba nembelta kamba wohwehlavav, suwemba wohtawovav. ");
INSERT INTO wrs_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Doa mendah olhmona ishunvna, yimba katindiva yeoa indkumbioa keknam lovahthavm, manara noinda Sesoa yeinda wanna itowol vevav. Wo no wanmba suwemsna tavav, yena indkoklava poswol vinvra, oi helavlasowa povolv. ");
INSERT INTO wrs_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Wanmba besal hevpa, heva os wanmba tepepeva vetava, es yimba vivav, wo hengava bes vevav, owai. Noinda osva yeoa pevmoa wanmsna beswonam ningehaloho, wo etemboslamsna beswonam aevultho. ");
INSERT INTO wrs_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Nominiva wonvenamba, wo Yutia provinsram wonga, venamba, di Yotan popethalla wonpho. Wo indhana di mindnam henga kusomna, wo Yesus henga wonishomana vena hevna wevolm. ");
INSERT INTO wrs_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Wo mongla Varisinind ambna, osm ambvna, Yesusm dasalm sah ovrilm, doara ningna, heoa ata Mosesna lohohmom moakoklana ishomnavra. Wo Yesusm umnina, es yimba nengv, tendorini hevna ongalmba wohwolaihangavavma, es hevpa beswonam kava osva vivmi? ");
INSERT INTO wrs_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Wo Yesus unna, Mosesva doarava es Sesoana moamba novol vena, tendoriniva ongalmba wolaihangavra? ");
INSERT INTO wrs_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Wo henga he umnina, yimba nonora, Mosesva os novol vena, himba nomba ongalmba pilpiangatava, boasna tombairasna novol vevrava, ungevlirinim vraho, os pilpiangavra. ");
INSERT INTO wrs_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Wo Yesus unna, lehra yimba uv. Heva os Mosesva noinda novol vena, ye yena simbehumunpev kelsombovho vivna, Sesoana moamba hillivnamoa. ");
INSERT INTO wrs_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","8","Manara noinda Sesoava hevpa seilva nengnamoa osva, owai, himba seilva manimani vaomana vena, doa vewolna tlalm ongalm, wo unna, tendoriniva ongamba vrarava, araravalmoa wuleihowol vevra, ongaliangas ahavra, wo si os uvra mongongal, wo noinda mongawundna wohahamana evevra. ");
INSERT INTO wrs_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Sesoava hevpa temba ningewol vinv, manam tendorinimba snamba pilpiangavra. ");
INSERT INTO wrs_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Wo dawonam deuvram wonganamba, di deuvra hevtindi osihminina no ongamom, Yesus hev ten nom Varisinindm ishunim. ");
INSERT INTO wrs_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Doa Yesus unna, himba nomba hevna ongalva pilpiangavrava, wo mongom vravra, himba nomba osva ongom sahokla vrevra Sesoana novrava. ");
INSERT INTO wrs_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Wo honamba eva os lohvta, ungevliriniva tlalmba wuleihaiva, mongona tlara vongo, osva eva indkokla vevta Sesoana novrava. ");
INSERT INTO wrs_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Doa mongona indhana otolm wonambvna, Yesusinam wonambvna, osm Yesus awothowol vera, eva englana kekaiv vevra. Wo hevtindi onungli, engilwul ve, ");
INSERT INTO wrs_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","wo Yesusva nongalnamba, ongowolna hevtindim, manaram yimba engilv, lehra otolva wonambv kainamba. Honamba otolva Sesoam lovahmanav indnahonam, wo indhanamba mundilva si osta virava, sna indhanamba si osva Sesoana nemeltindilm saivvav. ");
INSERT INTO wrs_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Tanam yemba kava unv, himba nomba Sesoam omnamba owai vetava, hona otolmsna ovramoa, aya, himba nomba Sesoana nemeltindilm si sihavavmoa. ");
INSERT INTO wrs_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Doa nom otolm unvnamba, wo kekaiv vawovna, unna, Sesoa yem beswonam wonvera. ");
INSERT INTO wrs_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Wo Yesus nominiva venamba, monam mendah gavna, indhanarini mongo lelnam pronamba, mulumbdandna di lohvhoa, wo Yesusm osahmana, guru, yimba besal, es hevpa kava vevrava, wo Sesoava kamba si hevna kembellava waiavav? ");
INSERT INTO wrs_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Doa Yesus omnana, manara yimba kamba osva omni, besal, Sesoangas besalva av. ");
INSERT INTO wrs_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Men henga yemba kava ishomnav, yimba pev nonora, Sesoana moamba lohv. Os manam yimba indhanarinimba helvakomandhavav, manam yimba goariskuiva vevav, manam yimba yukovpa vevav, manam moangakalava yimba ovav, ararapevna moamba hillinvra. ");
INSERT INTO wrs_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Wo he Yesusm omnana, kava eusilva mendah vevnamba, veiva daipota, hona Sesoana moam kava engomana vev. ");
INSERT INTO wrs_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Wo Yesusva nonglavna, doa und vevna, doa omnana, mongongal moamba yimba mendah vevmoa. Garava, wohoa dioa indhanam moang vepieinu, no indhanam dihui ten euvmona vevm, verava, yeoa katindilm sihao, wo pioa mongawulm lovahmana ve. Yimba osva vetava, Sesoava yemba si beswonam kokolma venavav diva hevindamba. ");
INSERT INTO wrs_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Doa no indhanarini wohva diva mindnam iavna, wo no moamba hellenamba, undva henamba potra pihamnana, novlomosva henamba sahoklatov selthoana, doa Yesusnaminiva noinda wohga. ");
INSERT INTO wrs_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Wo Yesusva nonglana, himba gavnamba, hevtindim nongalna, unna, snamba indhanamba wohva diva temba mindnamba ieuvmona vevpa, sna indhanamba si saha vrowovav, sihalmba Sesoana nemeltindilmba. Es eva, melva kekelmel. ");
INSERT INTO wrs_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Doa hevtindiva no moam hillivnamba, una, pai. Doa Yesus hev unna henga, tuendis kana, owaita, Sesoana nemeltindilm es eva ombamba saivvav. ");
INSERT INTO wrs_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Wo olhmona henga unna, es hevpa miemba sihavavma meiskismerava owainonoa. Osta eva no wohnindva Sesoana nemeltindilmba es eva saivvav. ");
INSERT INTO wrs_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Wo hevtindiva no moarava os uvna, pai, pai, an eva si beswonamba sihavav Sesoana nemeltindilmba? ");
INSERT INTO wrs_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Doa Yesus hem nongalna, unna, heva himba nomba hevna nengavnangnamba Sesoana nemeltindilmba sihavav, heva os owai, heva Sesoana andrava memba hevangas heva vewol vev, indhanamba wonsihalmba hevtindilva. ");
INSERT INTO wrs_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Wo Pita ishomnana, kam nongalo, doa kava kavnamba wohva dembrehalaha ambna, wo men kava mongawulm lovahmana vev yetindilm, kamba si es yimba vinvav? ");
INSERT INTO wrs_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Doa Yesus unna, yemba kava tanamolnam unv, himba nomba kamba engpithivrava, wo kana besal nemelmoa ishuvmona vinvrava, himba nomba nombalvhoawol vivav hevna owalmba, etehumunilm, muskovolm, towandaslalm, araravalm, molombolm, deuvm, osom. ");
INSERT INTO wrs_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","Heva os hemba nomba si kava mana ema esvema sesm vinvav hona petharava, kava sesm vinvav deuvm, etehumunilm, muskovolm, avalm, molombolm, osom. Doa kana ungundva hemba nomba sahokla vewol vivav. Heva os sewonamba Sesoana kembellava himba si beswonamangas wohaevvav. ");
INSERT INTO wrs_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Wo himba nomba daipotava indhanana kuwulva ilvahinvpa, sna indhanamba si nonamba vahsingiva lovahvav. Wo himba nomba daipotava memba vahsingiva lovahvpa, sna indhanamba si sewonamba mendeklilmba lovahvav. ");
INSERT INTO wrs_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Wo Yerusalem monam wongavna, Yesus hev miva gavna, wo hevna hellelnindva sis angavna, mindnam duus vivna, Yesusmba mani si vimnivav di Yerusalemra? Wo mongla indhanamba sis enggivna, pem vivna. Wo Yesus hevtindim unna, indhanahuiram hui kusotok. ");
INSERT INTO wrs_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Doa yem ka ishuni, os si kamba vinivav Yerusalem kembellava. Hillu beswonam, Yerusalemram pimba angav, wo kava arana ombol lohv, heva os kamba di ungundra wetat unvav, wo sembayang andranindna kuwul eva katekis kamba moa waiishuvav, ora nonam si yemba helvakomandhivav. Verava, kamba wetat umnivav di meisungundinda Romduanginda. ");
INSERT INTO wrs_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Wo himba eva kamba osva vrepra vrevra. Wo indhanamba kamba si os muembkosvna wehlavra, evndakalna hilvivra, wo verava, kamba si wohhelvakomandhi. Wo samblanin ambo kava verava, wo henga beswonam pho. ");
INSERT INTO wrs_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Doa Sepetina ombolsambla Yemsi Yoni epranamba, Yesusm ohomnana, kava moapeta yem wulelohmanav. ");
INSERT INTO wrs_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Wo Yesus unna, manamom hevpa yimba kamba sahalm ohomnav? ");
INSERT INTO wrs_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Wo himba ohona, os kam vinu, kava kuwulalm si elohe yeinda murapeta, vevra sihanasis lohvra mongova, mongova nihanasis lohvra, yimba si sewonamba kuwulalm lohvra indhanana indkumbina novrava. ");
INSERT INTO wrs_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Wo Yesus henga unna, yimba kamba ohosahmini, heva os yimba mendah tit evev hona andramba. Es hevpa kanamba yimba kinkumbi tanam ambo pulengavavma? Wo kamba nihsesoava vimnivrava, yimba kamba tanam ehengpravavma? Ungundva yemba helvowol vivav, wo yimba ambo tanam keknam elohvavma? ");
INSERT INTO wrs_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Wo himba ohomnana, kava tanam si elohvav. Wo henga Yesus unna, tanam yimba si nonamba kinmba kanamba pulengavavta, wo yemba eva si nihsesoava vinvav. ");
INSERT INTO wrs_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Heva os memba kamba ohosahmanavnamba, osva kuwulalm kam awowol veo, owai, kava unvavmoa, Sesoangas heva hev hona andramba pusvund vev. ");
INSERT INTO wrs_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Doa monglava 10pelava Yesustindiva hillinamba, Yemsiva Yoniva os evena, wo os musk vinvna i. ");
INSERT INTO wrs_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Wo Yesusva lihawol venamba, wo hevtindim unna, kusotok, yem ka ishuni. Yimba pev nonora lovahv, kuwulva himba nomba temba ilvahinvpa puehalnindnamba, indhanamba hena keusingi lovahinv, hengas ondal vewol ovovra, wo himba vengas viv hena moara. ");
INSERT INTO wrs_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Wo yemba osva ka unv, manam osva yimba katindiva lovahv, owai, kuwulva yeriniva snamba luhunvmoa. Himba nomba kuwulva yerinimba hovrava wulluhunvtava, wo heoa ambo andranindrinimsna luhunvra, wo yemba wonandra vevra. ");
INSERT INTO wrs_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Doa himba nomba yena kuwulva wulluhunvtava, heoa hevna nengavnangva maivethavra, wo indkumbina nengavnangra andra vevra, os kav men vevm. ");
INSERT INTO wrs_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Kava arana ombol lohv, wo heva os kava osva pronamoa hona petharava, wo ondal vewol ovoe indkumbimba. Owai, kava osm prona, indkumbim ambo kollombvra. Wo eva kamba si dahavav, wo nonamba kava indhanamba mindnam kilumbshuawol vevav hevna sahaposworiniva. ");
INSERT INTO wrs_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Wo nominiva wonganamba, Yeriko kembellava wonkohavnamba, ambo wonkohangavna indkumbim hevtindim, ombandhana eva mongawulm gapiavna. Wo mongo indhanariniva novtitmungilva monara avna, nihilva Batimeus, wo himba Timeusna ombol. Monara ambo avna, indhanamba okohowovnamba, ambo himba owovna, senpeta kam aiv velaihakov venavm, osoa dombvna. Wo hev di avna, Yesusva nonamba wonongovnamba, ");
INSERT INTO wrs_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","doa os hellenamba, Yesus Nasaretrinimba men wonokohov. Doa he mindnam di wunuho, os Yesus, yimba mendekli Devittindirini, kam wavra vovhoamno. ");
INSERT INTO wrs_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Wo indkumbi di lalkoho, os wuleihao, wo henga he di mindnam wunuho, yimba mendekli, kam wavra vovhoamno. ");
INSERT INTO wrs_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Doa Yesusva hellenamba, lohvhoa dawonam, unna, umnu no indhanarinim, kaindam prora. Wo anganamba, novtitmungilm umnina, indk vetho, pho, Yesusva yemba omni. Gao Yesusindam. ");
INSERT INTO wrs_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Wo himba lelnam phonamba, bayupanasva selvhsapingavna, lelnam Yesusindam gavna. ");
INSERT INTO wrs_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Wo Yesus omnana, es ata yemba kava venavav? Wo hev omnana, kava henga beswonam novvelm vev. ");
INSERT INTO wrs_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Wo hev omnana, gao, yimba kamba indnahonam lohmanav, wo noinda yemba kava sishona vrei. Wo noinda he beswonam nongalvnamba, Yesusm engpetha, no monam angavnam Yerusalemram. ");
INSERT INTO wrs_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Wo murava wonvenamba Yerusalemrava, doara wonkuvhoawol venamba kembelsamblamba eusilva, no kembelva os uv Betpaki Betani. Wo diva murava olomba nomba os ningthiv oliv denwit. Wo nominiva Yesus unna hevtindirinim samblam, ");
INSERT INTO wrs_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","mi yesna engo no kembellam, wo yimba ata donkitam enonglavav, no donkirava indhanamba nonamba lovahmana venamoa doarava. Ohomnarava, waiepra, ");
INSERT INTO wrs_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","wo anemamba yemba osva sah owol vetava, manaram yimba donkitava waiengav, os uhunu, Yesus mendekli nona lohmana velm vevpa, ata lohmana verava, henga ata waiambvav lelnam. ");
INSERT INTO wrs_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Wo enganamba, enonglana, men donkitava lohv, wena kleihinamba, monapethalla lohvna di deuvra. Wo himba donkitana wemba epelvhovnamba, ");
INSERT INTO wrs_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","wo indhana sah owol vi, manaram yimba donkitana wemba epelvhov? ");
INSERT INTO wrs_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Wo he uhunna, os Yesus ten doara hevm ishunnam. Wo hev unna, wouta waiengo. ");
INSERT INTO wrs_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Doa himba donkimba waienganamba Yesusindam, wo hevna malova sena moan vehola evena donkisra, wo Yesus nosra avho, Yerusalemram os noinda gavna. ");
INSERT INTO wrs_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Doa indhanamba hevna wevsava doara vewol vivna, hemba nomba kuwulalva pusvundthueivnamba, wo seilnovrava sihavnamba, monarava os vavta velahangavna kayenmba nemel. Wo tivtanda besal vlel hilhala uvnamba peillini, monara vavta vilaheingivna, osm kuwulva dakonda vilsiha. ");
INSERT INTO wrs_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Wo Yesusva nonamba sihavnamba donkinamba, indhanamba vena mi sis, Yesusva hovra lohvna. Doa saivnamba, indhanamba kingawonga vruwul ongowovna, Os hosana, osm uvna, Sesoam kava okuliv, wo hev yem poauothovra, yimba hevna moara kuwulalm meprov. ");
INSERT INTO wrs_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Wo yimba si kana kuwul wulluhunvav Devitna vuhera, ten doara heva kana simbelna kuwul wulluhunvnam. Wo henga kingawonga vruwul ongowovna, hosana. ");
INSERT INTO wrs_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Wo Yerusalemra diva phonamba, tempella siheine, no tempelva Yutanindna mendekli sembayangduv luhunvna. Wo di mera mum vaomana vena, doa simba okilvravnamba, nominiva wonganamba hevtindim, wo henga Betanira ninmba wonlina. ");
INSERT INTO wrs_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Wo mongnasiva henga nominiva wonvenamba Betaniriniva, doa wonprona henga Yerusalemram. Wo monam wongavna, Yesusm pon vene, ");
INSERT INTO wrs_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","wo mongo tim fikm nonglalm siha monapethalla, nomba fikva vlelva mindnam lohvna. Doa Yesusva sihanamba, nom fikmovm silelvna, movol endvmi, heva os owai, novvelohvnamba, endvnamoa, mendah. ");
INSERT INTO wrs_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Doa Yesus no tim omnana, kava ovov, movolva yemba si hengava endvavmoa, hlalmba, yemoa wohsoulara. Wo hevtindiva no moamba os hillina. ");
INSERT INTO wrs_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Wo Yerusalemra wonphonamba, henga tempella wonsiha, doa bisnis indhanam nom tempelmerinim engalungu ve, di esvowolvnam. Vevnamba, no indhanana meyam mulgothowul vinvna, diva tholpingu vinvna, no meyarava duangna di dombawuvna sembayangnindna, wo tempeldiva dembreluhunvna. Doa himba kursim mulgothowul vinvna, no kursirava di dombawuvna, leumb hemba holvorombrehunvna. No tempeldina leumbna sembayangnindva os vivna, dembvnamba, leumbva sembayang andranindm holvorehunvna, suweram wiwehalm Sesoam, dingas hevpa disumbra dembhapuv vehal vevna. ");
INSERT INTO wrs_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Doa Yesus ovunna, manam yimba hengava wohva hona deuvrava huiva aisuv vevav tempellava. ");
INSERT INTO wrs_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Manara nengara tombairava Sesoana moamba os novol velohv, Hona tempelva kana deuvpa memba lohvpa, os yepev Yutanind wo indkumbi annind annind hona deuvraoa kamoa sembayang vewuvmonavm. Sesoava hevpa os ona, heva os yimba vuhemba kelvhueinvna, dimangas ningminivna, noinda deuvpa honamba os lohv, oi, indhanakoklana deuvpa. ");
INSERT INTO wrs_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Doa sembayang andranindna kuwul eva katekis hillinamba, Yesusm muembnavho vrivna, os ningvna, ombandhanamba Yesusna moam hillivpa, wo os luklukul vriv, lehra ovta. Doa noinda ishuvna, es pimba Yesusmba kevrirava poaita, helvakomandhalm? ");
INSERT INTO wrs_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Wo okombava vohavnamba, Yesusva nominiva wonvohavna Yerusalemriniva. ");
INSERT INTO wrs_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Doa mongnasiva simolnam monam henga Yerusalemram wongavna, no denwitm fikm ona nunglina, doa vlelva plalva wohksuvhoai. ");
INSERT INTO wrs_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Wo Pitava Yesusna moam nom omminim nengna, omnana Yesusm, nonglo, hona timba yimba omba omnanamba, doa ksuvhoai, ambo tanamolnam yimba saha vruluhna. ");
INSERT INTO wrs_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Wo Yesus henga unna, hi hevpa mana ema mendekli kava venama, snamba an ona? Yemba kava tanam ishunv, Sesoamoa keknam yeoa lovahmanavm pevna undnahonam. ");
INSERT INTO wrs_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Yimba eva os vivavta, wo hona olomba yimba osva umnirava, wanplombra pilpeo, wo Sesoava osta vevav. Wo manam yimba sambla indva lowohivav, osva tanammi owaimi, mongawundnamba yimba lovahtava, Sesoava vevav. ");
INSERT INTO wrs_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Wo noinda yemba kava unv, Sesoam yimba mana emamba osihminivrava, mongawundna vivm, wo yemba osva Sesoava vinvav. ");
INSERT INTO wrs_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","26","Wo yimba Sesoamba sembayang vinirava, yeoa boasna indhanana indkoklaoma maisasa vrinu, temba yemba indkoklava vininamba. Manam yimba hengava ninginvav, esesmba velmba, owai. Yimba osva vivrava, wo yenamba Sesoava arapevpa osva si sahoklava maikumi vinvav. ");
INSERT INTO wrs_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Wo Yerusalemra henga wonphonamba, tempelmera wonlohmana vevna, wo monglava kuwulva prapia, sembayang andranindna kuwul, katekis, Yutanindna mundil, himba Yesusindam prapia, ");
INSERT INTO wrs_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","wo umnina, an yemba omnana, wo noinda yimba osva vewol vev? An yemba pusvundthoana, wo noinda yimba bisnis indhanam engalungu vevna hona tempelmeriniva? ");
INSERT INTO wrs_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Doa Yesus sesm unna, dawonam, yem kava sah owol velm vev, wo yimba kamba ishumnitava, osva ata yemba kava moakus unvav, henoi kamba pusvundthoana, noinda kava osva vewol vev. ");
INSERT INTO wrs_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Yimba pev doa doara nunglina Yon Baptaisna andramba. Wo an Yonmba pusvundthoana, ora indhana ambo, ora Sesoa hev? Wou kam ishumnu. ");
INSERT INTO wrs_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Doa kuwulva nomba hevm poaita ishuvna, osva pimba umnitava, Sesoa hev Yonmba wolaihaprana, wo himba ata os ovav, esm yimba Yonna moamba eva engangava owai vivna? ");
INSERT INTO wrs_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Wo pimba umnitava, indhana ambo Yonmba pusvundthueina, owai Sesoava, ata pimba ombandhanamba helvowol vivav, manara noinda himba os ningv, Yonmba Sesoana moashulnindrini. ");
INSERT INTO wrs_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Wo noinda Yesusm umnina, es ata kava yemba ishumnivav, an Yonmba wolaihaprana, pusvundthoana, kava tit viv. Doa Yesus unna, yimba kamba beswonamba ishumnimoa, wo noinda ata yemba kava moakus unvavmoa, osva an kamba pusvundthoana, noinda kava osva andra vevna. ");
INSERT INTO wrs_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Doa Yesus no kuwulm olhmona ishunvna, mongo indhanarini oso wolavnamba, no osomba weselmuvoso, no weselmuvpa os ningthiv grep. Wo pueilva ningivnamba, doa mongo mel tovhoanamba, grepmovm noinda polm sovhowolalm. Doa kekalvhoruvpa dembrana, noindam hevna osom kelvhoalm. Wo monglam andranindm himba sandhana, diva osorava andra vivna hevnisra. Doa himba hevpa dawonam wohgana, mongona kembellam oklam gana, os isholahangeinna, grepmovpa si endungu verava, si aembul ksuvhoarava, piv si moang vivav, vera yem eva kavm, yimba kana osondra viv. ");
INSERT INTO wrs_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Doa aembulva vevnamba grepmovpa, wo osona aralva hellenamba, mongom andranindrinim wolaihangana, omnana, gao nom kana andranindm undava, yem dembrehura kana grepmovoa. ");
INSERT INTO wrs_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Wo andranindriniva ganamba, no osorava ona phona, wo no andranind kevrinamba, hilvi, umnina ambo posal gao. ");
INSERT INTO wrs_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Wo henga osona aral mongom wolaihangana, ikao. Wo henga andranind di kuwul powalmini, sahokla vruwul ve. ");
INSERT INTO wrs_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Wo henga osona aral mongom henga wolaihanga, wo andranind helvakomandhie. Wo osona aralva henga andranindm mindnam wolanga velohvna, heva os angavnamba, andranind noi monglamba ambo helvowol vivna, monglamba helvakomo vivna. ");
INSERT INTO wrs_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Wo osona aralva hev ona, owai, andranindva eivvmoa, kavna ombolm mongasalm waiavna, kava mindnam und vev. Wo hemba kava wolaihangarava, si beswonam hillimnivra. ");
INSERT INTO wrs_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Doa wolaihanga ombolm no andranindindam, heva os owai, hillinamoa, wo una, hona tuendisriniva si mendekli verava, si os ovav, kana pethava memba, heva os yenamba owai. Wo helvakomandhalvohra hemoa, wo pivmangas hona pethava si wohluhunvav. ");
INSERT INTO wrs_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Doa noinda helvakomandhinamba, mindilva puehallam vindpingina. ");
INSERT INTO wrs_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Wo Yesusva olhmona mendah ishongeinvna, doa osona aralva es si andranindmba nomba vinvav? Es yimba ningv?, hev si osoram garava, no andranindm helvakomo vevav, monglamba andranindmba unvav, kana yeoa andra viu. ");
INSERT INTO wrs_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Wo Yesus mendah ishongeinvna, doa pev nonora, os Sesoana moamba tombairava novol velohv os, Andranindva honduv andembrana, wo mongova honmba nunglina, una, sahoklal, wo piengi. Wo heva os no honmba henga mongo andranindrini vra, wo no honmba daipotava lunitilm wohlothol lohv. ");
INSERT INTO wrs_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Sesoava hev vena, wo pimba nunglivnamba, wo besal hevm. ");
INSERT INTO wrs_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Doa kuwulva Yesusna olhmomba hillinamba, liheivna, plalmomba pi inda, manara noinda Yesus hev ona, yimba indhanakokla. Doa noinda Yesusmba awusapramana venavna, bui velm vivna. Heva os owai, bui vinamoa, ambo ombandhananapenam pem vivna, humeis ata pim helvowol vivm, wo noinda Yesusva nunglul liheinamba, hevpa buketha. ");
INSERT INTO wrs_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Wo dawonam monglava indhanamba ambanamba Yesusindam. Mundil hemba wolambv vena. Monglava katekisva, ten Varisinindilm lovahvna, monglava Herot kuwultindiva, himba Yesusm sah ovralm ambna ambo dasalm, os ningvna, heoa moakokla ishomnavra Sisa duangm. ");
INSERT INTO wrs_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Ambanamba, os dasalmomba ishumnivna, kava yemba nonora, yimba tanam ishowol vev, yimba mongawamoa ishowol vinv kuwulm, ombandhanam. Yimba mongawamoa ishowol vinv, yimba pemba vewol vevmoa, yimba musera ishowol vinv, yimba besmoa Sesoana moamba ishowol vinv indhanamba. Doa kam hona moam beswonam ishunu, men pimba taeks velvohinvpa duangm nom Sisam. Es hevpa hona wevsava pimba beswonam vivmi owaimi? Sisa duangm piv taeks vimniv ora owai? ");
INSERT INTO wrs_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Wo Yesusva nonora luhunvna, unna, anm dasalva yimba umnivna?, hom sen viliwulambrava, ka nonglai. ");
INSERT INTO wrs_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Wo mongova senmba Yesusm vilirehuna, wo Yesus sah owol vena, anna memba kuva namamba hona sendava kovopathalohv? Wo he una, Sisana duangna, pev nonora lohv. ");
INSERT INTO wrs_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Doa Yesus henga unna, hona senmba Sisa duang venamba, wo pimba taeksrava hevm Sisam henga dembraholvohv, wo manapenam, beswonam viv Sesoana novra. Doa Sisa duang pimba taeksm sehinvrava, dambroh vivra, wo doa Sesoa hev mana vemamba pimba sehinvrava, osva vinivav. Wo noinda nomba mundilva os luklukul avramana vena, pai, Yesusva doa pina wemba pelpikoheini. ");
INSERT INTO wrs_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Wo dawonam mongla kuwulva ambanamba Yesusindam, Satusilm himba lovahvna. No indhanamba os euvmona ovovna, si tanam mindilva pokamariniva pulvovavmoa. Doa Yesusm he dasalm osihminivna, ");
INSERT INTO wrs_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","Mosesva doara heva Sesoana moamba novol vinna, osva mongova tendorinimba dahatava, wo ongalva otolhui amnavra, wo boasalal henga moamulmba pethavav, wo towand eve, wo no otolva indhanamba si os uvav, eisilna vuheram, ten doara dahanam. ");
INSERT INTO wrs_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Wo men kava yem osihminiv, mongo aratindi 7pelara lovahvna mendekliangas, wo etelsna ongamba vranamba, wo etelmba dahavna, wo otolva lohmananamoa, ");
INSERT INTO wrs_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","wo pelimba boasalal vra, vranamba, wo daha boasalalva eva otolmba waiamnanamoa. Wo mongo boasalal pelimba henga eva vra vranamba, wo daha, wo osangas vruwuvna no ungevlirinimba. ");
INSERT INTO wrs_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Venamba, osangas 7pelara nomba aratindiva sihapiana, wo otolmba no ungevliriniva waianamoa, wo ungevlirinimba sism dahanata. ");
INSERT INTO wrs_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Doa yem kava sah ovriv, sewonamba mindilva indhanamba hengava pokamariniva phopiarava hevna nihna, an hevpa hona aratindiriniva, ungevlirinimba nomba memba vruwuvnamba, an hevpa vravav? ");
INSERT INTO wrs_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Doa Yesus unna, yimba sahonam ui, manara, yimba tit viv moamba tombairinimba Sesoana moamba, eva yimba tit vivta, Sesoava keknamangas lohv. ");
INSERT INTO wrs_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Mindil indhanamba indkumbi si pulvovav, doa si muhsoh lovahvav, os Sesoana ovsongolnind muhsoh aevvm. ");
INSERT INTO wrs_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Yimba nonora, Mosesva temba nonglanamba suwemda taihavna tira, heva os no timba tavnamoa. Sesoava Mosesm nonam ishomnana, os kava mendah men mendekli lohv Aprahamna Isakna Yakopna. ");
INSERT INTO wrs_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Sesoava os ishomnana, wo noinda Mosesva os wohlihana, no kana simbelva samblamongova, ten doara dalnam, mendah lovahv Sesoaindava. Mosesva os lihanamba, wo noinda pimba liehiv, mindilva indkumbiva si tanam pulvovav pokamariniva henga hevna nihna. Honamba Sesoana moamba yimba levrapivolvmoa, wo noinda yimba kamba dasalmomba ishumnivna, mindilva es pulvovav pokamariniva? ");
INSERT INTO wrs_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Wo mongo katekisva di mura hellowol lohvna, Yesusva wonishovnamba, os nengvna, Yesusna moamba besal hevm, wo Yesusindam pronamba, Yesusm omnana, kam omno, heni Sesoana moamba mendekliva lohv? ");
INSERT INTO wrs_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Doa Yesus omnana, honi Sesoana moamba mendekliva lohv, wo Moses novol vewol vena, Yimba Israelnind yeoa hillivm, Yawe pina Sesoava einv, wo himba mongongasal einv, wo yeoa nom Yawem undnahonam nengeuvmona vinu, ten pina Sesoa einvm. ");
INSERT INTO wrs_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Wo yimba osva Sesoamba und vivrava, wo manam yimba sambla undva vewol vivra, owai, mongawundna vivm, wo manam yimba ambo seposam vivav, owai, pepthanam vivra. ");
INSERT INTO wrs_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Wo mongova Sesoana moamba mendekliva os novol velohv, Yeoa indhanamoa os nesmos vewol vivm, os pev pevna nihm ten lelh vewol vivm. Honi Sesoana moasambla mendekliva eluhunv pim. ");
INSERT INTO wrs_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Wo no katekis henga Yesusm omnana, yimba lehra oi, tanam yimba oi, Sesoava mongongal av, wo mongova avmoa. ");
INSERT INTO wrs_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Wo hemangas pimba ind vinivra, wo ningminivra indnahonam, wo eva vevra, indhanam pi nesmos vewol vivra, os pivm men pi lelh avramana vevm. Doa hona wevsava, memba yimba kamba ishuniva, kuvhoav, wo pina wevsava ambo tuvulinv, hona wevsava memba pimba tatamba innemba weisumbulol ololohvpa huiva tempellava. ");
INSERT INTO wrs_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Doa Yesusva hellenamba, no katekisva nonoramsna ishov, oi pimba Sesoam mongawundna und vivra, wo hev omnana, yimba murapeta doa sihalm vev Sesoana nemeltindilm, mendahpeta vev. Wo Yesusva ishopianamba, indkumbi pekmek vivna, wo hengava Yesusmba dasalmba ishumninamoa, humeis ata kana moakoklam indhanamusara moakus unvm. ");
INSERT INTO wrs_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Doa dawonam Yesusva mendah indhanam wonamana vevnamba, moa wonishomana vevna di tempelmera, wo he unna, yimba nonora, katekisva yemba os ishulvohinvna, si mongova indhanariniva provav Kristus, Sesoa hev si pusvundthoavav, pivm Yutanindm wolapho velm vevav, wo himba Devittindirini luhunvav, ten doara heva kuwul wulluhunnam. Tanam himba osva uv, heva os mongmomba men kava yemba ishunv. ");
INSERT INTO wrs_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Yimba nonora, doara Sesoasongol no Devitna nengavnangm otuhtna, wo Devitva noinda novol vena os, Doa Sesoa kana mendeklim ishomnav Kristusm, os yemba kava mendeklielm pusvundthoav kavna nihanasis, osm kav men lohvm, wo si ungundmba yenamba ka engilinvav, yena keusingi lovahmanavav. ");
INSERT INTO wrs_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Wo hona moara Devitva os ona, Kristusva si mendekli luhunvav, oi Sesoa hev, wo kamba kuvhoavav. Doa es hevpa katekisva yemba osva ishunvna, Kristusva Devitna sespel si lohvav, wo Devitm kuvhoavavmoa? Doa ombandhanamba indkumbiva Yesusmba hillivnamba, os uvna, pai, besalangas. ");
INSERT INTO wrs_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Wo Yesusva moamba mendah ishunvnamba ombandhanam, unna, yeoa novnovhora katekisna wevsanapenamoa vinu, manam yimba osva vivav. No katekisva kayenmba tokol vewol viv, kam unvra, himba nonora lovahv mendekli, wo musera di lovahmana vevna netesnalm. ");
INSERT INTO wrs_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Wo himba sembayangduvra os vivna, hevm besallangas avhoapravna kuwulmsna, wo innemba dahwol vivnamba, himba indanam besalla aevulvna. ");
INSERT INTO wrs_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Wo himba pelimba dasalm ovivnamba, wo wohva osva muehrombol vivna. Doa vivnamba, dasalm Sesoam ambo sembayang vivna, hevm selawosla vewol vivna indhanana novra, heva os owai, sewonamba si Sesoava hemba mindnam kinwondava plothowol vinvav honamba. ");
INSERT INTO wrs_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Wo Yesusva mendahva diva tempelmera lohvnamba, mura di disumbra avhoa, ambo nongalvna, sembayangnind sen aiemb vevnamba, di dembrapuv ve. Dinindva mindnam senmba mindnam dembrapuv vevna, ");
INSERT INTO wrs_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","mongo peli pronamba, dihui amana vevna, wo ambo aiv sambla senmba vilipipohowole olpeli. ");
INSERT INTO wrs_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","44","Wo Yesus nongle, hevtindim unna, hillu, yem ka ishuni, wo hev unna, yemba tanamolnam kava unv, hona dinindva senmba mindnam dembrapuv vei, heva os mindnamba mendah wulav, wo no peliva dihui, wo nomba ambo senmba samblava vilipipohowolei disumbrava, wo noinda he kuelwolv no dinindmba. Manara noinda himba osva nengeimoa, inneram kavm wulav, owai, ambo vilipipohowolei. ");
INSERT INTO wrs_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Wo Yesusva tempelliniva nominiva ona phona, mongo hevtindirini omnana, nonglo, hona pina tempelduvpa besal hevm luhunv mendekliangas. Honna dembrina, honmba honamba seswit os i. ");
INSERT INTO wrs_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Wo Yesus omnana, tanam hona deuvpa mendeklikumbi, heva os si sewonamba wohtaka vinvav, wo honmba honamba lohvavmoa, owai, pethara si velaiha luhungu vevav. ");
INSERT INTO wrs_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Doa nominiva tempellinimba wonganamba, wo olora wonpho, nomba olomba os ningthivna olivdenwit, wo avhoanamba hevpa tempelduvm henga nonglanga vawovna, doa Pita, Yems, Yon, Endru, hengas ambanamba, Yesusm sah ovri, ");
INSERT INTO wrs_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","Henanam hevpa nomba si phovav? Esalm mani hevpa si phovav, wo noinda pimba ningvav, pina tempelduvm ata wohtaka vinvav? ");
INSERT INTO wrs_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Wo Yesus henga ishunna, yeoa novnovhora aevvm, indhanamba dasalm si humeis yemba sahokla vewol ovivra. ");
INSERT INTO wrs_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Si sewonamba indhanamba mindnam pulvuwul vevav, si os ovra, mekava Kristusva provta, wo indkumbim indhanam gekala unvav, wo indhanamba si os uvav, tanamta. Heva os owai, mendah kanamba lohv. ");
INSERT INTO wrs_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","8","Wo yimba si hillivav, no kembellava ten owalwol, wo yimba si nungeilvav, indhanamba owalwolvrava, wo si daoskumbi mongnind mongnind ohovav, no pethara no pethara ohovav. Wo si nenv vevra mongona kembella mongona kembella, wo si owous phovav no kembella no kembella. Hona sahoklasna si phovav, heva os owai, mendah kanamba lohv, wo mendah hona pethava lohv, manam yimba osva uvav, oi, meprovmi Kristusva. Owai, boasna sahoklava mendeklikumbi indhanamba si nongalphovav, oi ungevlirinim kelathamnav. ");
INSERT INTO wrs_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","Doa hona sahoklava phovrava, yeoa beswonam novnovhora vivm. Noinda viu, indhanamba si os yemba katindimba wonishovav, wo buimera wolasuv vevra, wo sembayangduvra yemba monglamba si helvowol vivav, wo yemba si wonangavra kuwul mendekli indam, di yemba perkarra wonvivav. Hona plalmomba os lohv, men pev kana andra vivm. ");
INSERT INTO wrs_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Wo yimba nonamba beswonamba no kuwulmba ishunvra, kana nemelmomba ishunvra, wo osangasta kembelnindva ehalnindva indkumbi boasna kana besalmomba hillirava. ");
INSERT INTO wrs_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Doa nonamba kuwulva yemba ongowol vivrava, osva manandra yimba viv?, wo manam pemba yemba eiswol vevav, Sesoasongol hev yemba si os otuhowol vevav, wo moamba beswonamangas yimba ishuvra, manara nengara mani pevna nengavnangnama yimba ishuvav, owai, Sesoasongol hev yemba otuhowol vevav, os ishu. ");
INSERT INTO wrs_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Wo nonamba daosva ohovrava, wo si osva indhanamba wavrava owalva unvramoa, wo etelva eva wohtivra, boasalamoa wangkomandhiu, himba Kristustindirini. Wo aralva ombolmba os vinvrata, wo tovotalva pulvovra, wohtivra, araravamoa helvakomo viuta. ");
INSERT INTO wrs_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Indkumbi yemba si os nungeilvav, katindi memba, wo noinda yemba si musk vinvav. Doa himba nomba keknamangasva lovahvrava, wo kamba maivethahuiva vivrava, hemba nomba Sesoava si hevalm nembaomana vevav. ");
INSERT INTO wrs_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","Doa yimba si indhanarinimba nunglivav hui Yerusalemra. Himba tihmonasharava si os lohvav sahoklal, snamba Sesoava os omnavav, yemba kava ovomnav, wo kava kavna tempelduvpa wohwuleihav noinda. Doa nonaoa pevoa Yutia provinsnindoa lelnam meishanam vovoha vevm, olora dawonam di aevvm. Yimba memba honamba tombaimomba nunglivpa, yeoa beswonam ninginvm, wo yimba osva hona olhmopetava liheivav. ");
INSERT INTO wrs_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Wo no sahoklava phorava, wo nonamba himba nomba mendah ambara avra deuvrava, manam himba nomba hengava merava deuvrava sihavra, wohva dambolmba, owai, lelnam ambo meishanam vohavm. ");
INSERT INTO wrs_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Wo himba nomba osorava andra vevrava, manam himba nomba gavra deuvramba, wulkalmba kayenmba hevnamba, owai, ambo wailmonam wohgavra oloram. ");
INSERT INTO wrs_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Mongova ungevliriniva nonamba enamba avrava, wo mongova otolva lupulilva waiavrava, wavro, nonamba ambo sahokla nongal lohvav, saha vrivav lelnamba gapialmba. ");
INSERT INTO wrs_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Wo yeoa Sesoamoa elsus osahuwuvmonavm, os manam seponamba hona sahoklava kamba nongal lohvav, osombnam heva vera, lelnam osva kava gapiavav. ");
INSERT INTO wrs_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Manara, nonamba hona kinkumbiva indkumbimba si plotheinvav ora i, hona kinkumbiva mendekli hevm, seilva espetambo lohvna, Sesoa seilva hona pethava venamba, veiva daipota men, wo eva sewonamba si osva owaita. ");
INSERT INTO wrs_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Wo nonamba Sesoava no kinkumbiva si eneha ambo wuleihavav, indhanam si humeis indkumbim dalvm. Sesoava monglava indhanamba doa doara kikih vewol vena hevtindilm, wo noinda si humeis nomba sihapiavm. ");
INSERT INTO wrs_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Wo nonamba mongova indhanariniva osva yemba unvrava, nunglu, men Kristusva, Sesoava hehonam pusvundthoana, doa men proi, wo mongova yemba osva unvrava, Kristusva no kembella doa phoi, wo manam yimba hilwul vivav, ambo gekala yem temba unv. ");
INSERT INTO wrs_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Moangakalanind snal si pulvovav, wo mana emamba mendekliva vewol vivra ombandhanam, osra luklukul vrivav, ambo uvav Sesoanamini. Himba Sesoanindm nomba dasalm vinvra, kam engalpethavra, heva os owai, Sesoava eva nongalihavavma, kava temba kikih vewol venamba. ");
INSERT INTO wrs_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Doa yemba kava moakus uni, honamba si sewonamba os phovav, wo noinda yeoa novnovhora vivm, hona sahoklava manimani yemba nongalphovrava. ");
INSERT INTO wrs_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","Wo no sahoklava boasna nongal lohpiarava, wo nonamba kana prolmba si os phovav. Doa okombava lovhoavavmoa, wo weisva eva osta, ");
INSERT INTO wrs_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","wo paiva ovriniva velaral vevra, wo eva manimani nomba ovrava temba keknamba lohvpa, monamba si owulihivav. ");
INSERT INTO wrs_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Kava arana ombol lohv, doa nonamba kava si tekohovrava petharam pihavav indhanana novra. Wo kavna pusambanakambava kana kura si os lovhoavav, yena novpa sowaivwol vinvav, wo an eva kana moamba piengavav, owainonoa. ");
INSERT INTO wrs_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Doa nonamba kava si kavna ovsongolnindva wolanga vungu vevav. Vevrava, wo henoi katindimba kaina nembaomana vivav, nom Sesoa doara ten kikih vewol venam no petharinim no petharinim indkumbim. ");
INSERT INTO wrs_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","Doa Yesus henga unna, hona olhmom keknam kana hillivm, timba polva engsihaiva, wo ningilva nemelva pehlothovpa, wo yimba os ningv, doa mura osombva pholm vev. ");
INSERT INTO wrs_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Doa yimba nomba nunglivrava, yem kav men seilm ishunim, wo osva yimba nonora ningvav, ora Yesusva mura prolm vev. ");
INSERT INTO wrs_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Tanam, mani wenokombonamma, monglava yeriniva si mendah lovahvra, himba si os nunglivav novnamba. ");
INSERT INTO wrs_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Tanam kava yemba ishunv, ovna pethanamba si umharavhoavav, heva os kana moamba si wohlohvav. ");
INSERT INTO wrs_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","Wo Yesus henga unna, kava si homba petharamba henga provav, wo indhanamba tit viv honamba, oi henanam si Yesusva provav? Owai, Sesoana ovsongolnindva eva tit vivta, kavpa eva tit vevta, Sesoangas kanarangas nonorava av. ");
INSERT INTO wrs_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Yimba eva tit vivta, wo noinda yeoa undundna aevvm. ");
INSERT INTO wrs_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Men kava olhmona ov, os indhanarini hevna denwitm os vevav, indhanamba unvav, kana denwitmoa hui lengwol vewuvm kavnasiraoa. Mongo no andra, mongo no andra os unvav. Wo galmba verava, mongom no andranindrinim omnavav, denwitmoa kanamoa kekalvho vro, henga kava si prorava, wo daha henga yeoa kamoa kavna denwitoa os wuleihamno. ");
INSERT INTO wrs_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Doa Yesusva olhmomba wuleiha, wo henga hevtindim unna, hona olhmomba yeoa keknam wuleivvm, wo undundna aevvm, yimba tit viv, henanam kava hengava si provav. Kava si ambo kuimbsuwenamgava pihavav, ora simolnam, ora okomba vohanam, ora sinim. ");
INSERT INTO wrs_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Manam yemba gimus vivav, wo kava si mura prolmba vevrava, yimba kamba nunglivavmoa. ");
INSERT INTO wrs_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Yemba men kava ishunv, wo eva indhanamba indkumbimba kava os ishunvta, yeoa undundna vivm kanasiraoa. ");
INSERT INTO wrs_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Wo sembayang andranindna kuwul eva katekis kusonamba, hevm ishue, es pivva si Yesusmba poaitava kevrirava, helvakomandhalm? Hev ningna, sambla simba elohv, wo indkumbiva kusovav, wo innemba hlavav huiva Yerusalemrava, nomba innemba osva hlavav, ningvra, Sesoava simbehumunilmba seilva wonphona Isip petharini. Nonamba rotiva hlavav yishui. ");
INSERT INTO wrs_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Wo no kuwulva ishuvna hevm, aembu, manam pimba Yesusva hona innenindna novrava kevrivav, wo buiram waianga, pimba ora muserava kevrira, wo pimba himba helvowol vivav. Poaita ambo kevrivav. ");
INSERT INTO wrs_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Wo nonamba Yesusva mongona deuvra avna Simonina, no deuvpa Betani kembella, no Simonmba doara lombamungil anamba, doara selpuemnana. Wo inne di ona wonnawona, mongo ungevlirini botel sanda wulprona, botelva nomba besal hevm, no sandava teihnungva besal hevm vevna, diva os lohmanavna i. Wulpronamba, kewul powalnamba, doa Yesusna kura sovho, osm vevna, Yutanind ten indhana mindilm sovhowol vinvnam, os singvi. ");
INSERT INTO wrs_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Wo nonamba monglava no indhanamba musk vivna, hevm ishuvna, esm hevpa himba hona sandava ombamba sovhov? ");
INSERT INTO wrs_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Hona sandava pimba doarava maketramba wulangatava, pimba diva eva ata os dumbtami mindnam, os 300 kinara phota, wo innehuinindm moang vi. Wo noinda no ungevlirinimba okusv vina. ");
INSERT INTO wrs_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Doa Yesus unna, manam yimba okusvvav, sahokla ovriv, ");
INSERT INTO wrs_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","mani sahokla veima, kam memba undnahonam beswonam vrei. Yimba innehuinindmba moang velm vinvrava, viu, men euvmona velvohvm. Heva os kava owai, mani yemba kava mongawulm si wohwonamana vevavma, osva yimba kamba si vruwuvmona vevav, owai. ");
INSERT INTO wrs_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Wo hona ungevliriniva memba kamba sandanamba sovhoholothomniva, memba osm kamba vemni, yimba si os kamba vinivav mindilva. Mongova monamba lohvmoa, kamba okolalmba. ");
INSERT INTO wrs_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Tanam kava yemba ishunv, kanamba moamba honamba besal si os hellenguamana vethavav indakonda petharava, wo hona ungevliriniva memba veiva, si eva henamba osta hellenguamana vethavavta, wo indhanamba si beswonam hemba ningminiv, besal. ");
INSERT INTO wrs_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Doa nonamba mongova hevtindirini gana, nihilva Yutas Iskariot. Ganamba, himba sembayang andranindna kuwulm moam ishomnalm geinna, unna, ka yemba si indthueinvav, osva men Yesusva, wo yimba nonamba si kevrirava, buiram waianga, os pev men ningminivm. ");
INSERT INTO wrs_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Wo kuwulva hillinamba, indk vithivna, umnina, yemba kava si di dembrehuvav. Wo doa Yutasva nengvna, henanam si kava indthueinvav, osva Yesusva men? ");
INSERT INTO wrs_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Wo rotiva yishuiva nonamba hlavnamba, nengewuvna, Sesoava tomonalmba seilva wonphona Isip petharini, wo sipsip miklewol vivnamba, wehla ve. Doa nonamba Yesustindiva Yesusm umnina, yimba es nengv, ata kava heni deuvram angavav, no sipsipna nihilva huhul velmba, wo pimba hla? ");
INSERT INTO wrs_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Wo hev samblindhanam unna, Yerusalemram dem esihoho, wo diva yimba monarava mongova tendorinimba ata anongla evevav, no tendoriniva po guavav, hem ehengpethota. ");
INSERT INTO wrs_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Wo ata himba mongona deuvram gavav, doa yeoa sis enggo, wo no deuvna aralm ohosahmano, pina guruva os oi, yimba kamarva venamba mendekliva, hi lohv, no kamarrava kava ata no sipsipna nihilm woniprovav wonnelmba? ");
INSERT INTO wrs_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Wo no deuvna aral yemba ata wonvongavav no kamarram mendekliram. No kamarva sena lohv, wo tikarva manimani os nalohv, ata pimba lehra hlawuvav, wo yeoa di meilna eveota no kamarra. ");
INSERT INTO wrs_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Doa no hevtindirini samblava mi enga Yerusalemram, wo osoa enonglana, ten Yesus hev ishunnam, wo di innemba meilna evenata. ");
INSERT INTO wrs_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Doa simba okilvravnamba, Yesusva no deuvrava wonphovna, ");
INSERT INTO wrs_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","doa hevtindim 12pelaram mongawulm wonnawovnamba, doa Yesus unna, yemba kava tanam unv, mongo yerini kamba ata ungundmba indthueinvav, honi yerini men piv mongawulm hlavm. ");
INSERT INTO wrs_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Wo undva henamba potra pihengu vinvna, hevm os ningwul vevna, an hevpa dihi, wo henoi henoi ovna, kamma, owai? ");
INSERT INTO wrs_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Wo Yesus henga unna, men kava yem mongawulm wonnevm mongawa sospanda, pev honi ambo ata. ");
INSERT INTO wrs_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Kava arana ombol lohv, wo doara doa tombairava novol vina, kamba si helvakomandhivav, wo kamba si osva dahavavta, tenovol vinam. Heva os himba nomba yeriniva kamba ata ungundmba indthueinvavpa, heva hevm umniv wavro. Manara, noinda si hemba sesmba sewonam kinwonda plothomnavav, wo nihsesoava venavav os i. Himba si os ovav, mani avamba kamba osm lengnama? ");
INSERT INTO wrs_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Doa mendahva wonnevnamba, Yesus hev rotiva vranamba, wo Sesoam ishovongo venana, lehra yimba kamba dembrahuni, wo rotiva nomba popowol venamba, doa pavmong vine hevtindim, wo unna, dumbu, hla, kana nihil memba. ");
INSERT INTO wrs_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Wo wain eva mokna vra, Sesoam henga ishovongo venana, lehra yimba, wo unna, hlao, doa ambo mongawa mokna hlana. ");
INSERT INTO wrs_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Wo Yesus unna, hona wainmba memba kana tovol. Doa tanam kamba ata dahavav, wo kana tovolva ata os sovhopevav, indhanamba mindnam kolvrowolalmba. Osm yimba liheivav, Sesoa tanam ishunv hevtindimba. ");
INSERT INTO wrs_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Doa tanam kava yemba unv, hengava wainmba kava si nevavmoa, verava kava si sewonam wainmba nemelva nevav di Sesoainda. ");
INSERT INTO wrs_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Wo wonnepianamba, Sesoam sangal wonsevramnanamba, wo nominiva wongana, henga indhanahuiram wonganamba oloram, no olomba os ningthiv oliv denwit. ");
INSERT INTO wrs_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Wo Yesus unna, ata yimba kanaminiva pem bukethavav, kana ungundnapenam, os doarava Sesoana moashulnindriniva tombairava novol vena, Sesoa sipsipna kekalvhonindrinimba si helvakomandhavav, wo noinda sipsippa pem bukethungu vevav. ");
INSERT INTO wrs_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Doa Yesus henga unna, osta detiva ata phovav, heva os henga si kava beswonam pokamariniva phovav, wo kasna si miva yemba desumbi gavav Galili provinsramba. ");
INSERT INTO wrs_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Wo Pita omnana, owai, yetindiva indkumbiva pemba angatava, kava owai. ");
INSERT INTO wrs_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Doa Yesus Pitam omnana, tanam hona sinimba ata yimba os ovav, kava Yesusmba tit vrev. Ata honamba moamba samblamongolm opiowol vevav yimba, wo ayamba samblalm mendah opiowol vre. ");
INSERT INTO wrs_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Wo Pita mindnam henga omnana, owai, pimoa mongawulm endahowolla, heva os kava osva ovavmoa, kava Yesusmba tit vrev, wo hevtindiva indkumbiva osangas umninata. ");
INSERT INTO wrs_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Wo nominiva wonganamba, Getsemani pethara wonpho indhanahuira, wo Yesus unna hevtindim, yeoa hui aevvm, kava ata dem gavav, Sesoam sembayang venalm. ");
INSERT INTO wrs_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Doa Yesusva Pitam Yemsm Yonm nomangas demba wongana, wo hevpa di duuskumbi vevna, ata kamba kinkumbi plothomnavav, kamba helvakomandhivav. ");
INSERT INTO wrs_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Wo himba no samblamongolm ishunna, kamba kinkumbi venav, kamba ata daipota hui dahavmi, kavvei. Yeoa hui aevulvm, novkaka aevvm, kava dem gav. ");
INSERT INTO wrs_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Doa hev espeta ganamba, pethara plakope duusnahonam, daikaka vungavna, wo os Sesoam aralm sahvungo venana, es hevpa honamba kinkumbi kamba plothomnavna, lehra ye nengas pipahamnav, ");
INSERT INTO wrs_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","wo heva os kana moarava manam yimba nengas pipahamnavav, owai, pevna nengavnangna ambo veo, ora owai. ");
INSERT INTO wrs_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Wo henga ona prona, pai, samblamongova ninshav, wo Simon Pitam omnana, Simon, manam yimba liv? Espetava yimba novkakava avnamoa kanisrava. ");
INSERT INTO wrs_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Yeoa novkaka aevu, wo Sesoam osahuwuvmonavm, ata homeis yem plel vevm hona kinda. Tanam yimba kam engpetvolm vev, heva os owai, yemba gimus vinv. ");
INSERT INTO wrs_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Doa Yesusva hengava espetava ganamba, Sesoam osahmana, os doara hev ten seilm osahmananam, ");
INSERT INTO wrs_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","wo henga engilpranamba, ona, pai, ninshav, henga nitata vinvnamba. Wo Yesusva sah owol vevnamba, himba lous vrivna, moamba sesva ishomnalva. ");
INSERT INTO wrs_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Doa henga ganamba, henga Sesoam osahmanana, wo henga engilpranamba, nongalna, mendah ninshav. Wo unna, mendah yimba shaolavma, doata. Kava arana ombol lohv, heva os ata kamba sehsimbihal indthueinvav indhanakoklam. ");
INSERT INTO wrs_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Pulvo, nunglu, no sehsimbihalva doa proi, kamba indthoalmba. ");
INSERT INTO wrs_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Doa Yesus mendah wonishovna, wo Yutas phona, no Yutasva mongo hetindirini. Himba desumbi provna, wo indkumbi noinda pelkleihamna, ovlatenga himba iambvna. No indkumbiva himba os ambna Yutanindna kuwulna moara, katekis, sembayang andranindna kuwul, mundil, honamba kuwulva wolanga vina hemba. ");
INSERT INTO wrs_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Wo Yutas doara no kuwulm ishunna, ata kava garava, hemangas mapotho ovre, pev u, ten Yesusvata, nom kava kevralmba ambv, wo os wohkekel viuta, waianga, wo novnovhora waiangavm. ");
INSERT INTO wrs_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Doa Yutas pronamba, omnana, guru, doa Yesusm mehtat vene, osm vena mapotho ovre. ");
INSERT INTO wrs_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Doa noi indkumbi prapianamba, Yesusm kekel vi. ");
INSERT INTO wrs_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Doa mongo hevtindirini phonamba, ovla hevna selvoramnanamba, mongo no andranindrinina angol singeitpipahamna, no andranindriniva tempelna kuwulna andranindrini. ");
INSERT INTO wrs_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Doa Yesus unna, mani kava daosnindrini avnama, noinda yimba ovlana tenganamba wulprapiavna, kamba helvalmba? ");
INSERT INTO wrs_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Elsus kava no tempelduvrava indhanamoserava wonamana vevna, wo owai, yimba nonamba kamba kevrivnamoa diva. Wo os doara Sesoana moashulnindrini tombaira novol vena, osva noinda yimba kamba wohvenalm vinivta. ");
INSERT INTO wrs_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Doa nonamba hevtindiva pem bukethana, wo Yesusva hevho ungundna englisra lohvna. ");
INSERT INTO wrs_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Wo mongo tuendisrini kayenpetava ambo vethanamba, wo Yesusm sis engpetha novolm, wo ungundva nunglinamba, ona, mongo hetindirini, wo ona kevrina. ");
INSERT INTO wrs_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","Heva os owai, kayenmangas himba kevrimnina, hevoa snilung nihps wohgana. ");
INSERT INTO wrs_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Doa Yesusmba waianganamba, tempelna mendekli kuwulinda di waipulvo, di Yutanindna kuwul indkumbi kusovnam, tempelnindna kuwul, mundil, katekis, honi kusovna diva. ");
INSERT INTO wrs_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Wo Pitava sis engilguavna, wowonam ambo gavna. Venamba, siha pueilmera no kuwulna deuvpethalla, wo suwera pathavhueinna, poaita ambo avho kekalvhonindmongo. ");
INSERT INTO wrs_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Doa noi kuwul di moakumbi wuleindavna Yesusm, osm aslalmanavna, manamoara, mani venamba, noinda pimba ata duangm umnivav, helvakomandho? Heva os owai, aslalloh venamba. ");
INSERT INTO wrs_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Wo indhanamba mindnam diva lovahvna, dasalm ambo umnivna, Yesusva os vena, heva os owai, mongawamomba ishuvnamoa, indakondamoa ambo eishu vruwul avna. ");
INSERT INTO wrs_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Wo mongla no indhana opulvonamba, umnina, ");
INSERT INTO wrs_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","kava os hillina, os Yesusva ona, si kava tempelduvpa taka vindava, nomba indhanamba temba dembrinamba huiva Yerusalemrava, wo mongo tempelduvpa henga kava si vevav, samblamongo okombanam vevav, no tempelva indhanamba vivavmoa, ambo kava kavho vevav. ");
INSERT INTO wrs_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Heva os gekala ambo olvohvna, mongawamomba tanamba ishuvnamoa. ");
INSERT INTO wrs_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Wo noi sembayang andranindna kuwul hev hovra lohvhoanamba, Yesusm sah ovre, es eva ata yimba ishovav hona wetatmomba yemba memba umniva? Yimba moamba sesva wulluhunvmi owaimi? ");
INSERT INTO wrs_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Doa Yesusva moanghui ambo lohvna, moapetava osva sevranamoa. Wo himba henga sah ovri, es hevpa yimba Kristusma? Sesoa yem men pusvundthoanam, osm kam Yutanindm kolvrowol velm? Yimba Sesoana ombol tanam ambo lohvmi owaimi, nomba temba pimba hemba okuliv? ");
INSERT INTO wrs_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Doa Yesus ona, evasalm ka honita. Kava arana ombol lohv, wo yimba si kamba henga nunglutithueivav, kava si Sesoa mendeklina nihanasis avav, temba keknamangas lohvpa. Doa nomini henga si hona petharam kava provav, wo nonamba yimba kamba si os nunglutithueivav, kava tekohovra si pihavav. ");
INSERT INTO wrs_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Doa tempelna kuwulm wusprovna Yesusna moara, wo noinda hevna malom powale, ona pimba doa Yesusnamba moamba hilli, manam mongmomba indhananamba hillinvav, owai. ");
INSERT INTO wrs_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Sesoamba himba doa sahokla ovrei, oi, kava Kristus, Sesoai lohohra kava elohv. Es hevpa yimba ningv? Es hevpa pimba vinivav hona indhanarinimba? Wo kuwulva nomba indkumbi mongawamomba mindnam hevm ishuvna, ambo duangm wohtivra helvakomandhalm. ");
INSERT INTO wrs_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Doa monglava muembkosvna wehlavna, wo monglava novlomosm kayenna ehlithiminivna, wo ohilvivna, dasalm umnivna, an yemba helvav, sevro, yimba nonoanindrini lohvtava. Wo kekalvhonindva kevrinamba, englambambna sang pulavna, helvuwul vevna. ");
INSERT INTO wrs_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Wo Pitava mendah di suwera deuvpethalla avna, doa mongo ungevlirini phona, kuwulna andranindunguvlirini, ");
INSERT INTO wrs_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Pitam nongla, wo muram suweram pronamba, liha, wo ona, yimba Yesustindirini men Nasaretrini. ");
INSERT INTO wrs_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Wo Pita omnana, es yimba ov, kava tit vev. Wo nominiva Pitava gana, ona tuvra pholm, wo lilnam ayamba ophona. ");
INSERT INTO wrs_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Wo henga nomba ungevlirini nonglana, wo nom indhanam unna, ten deuvpethalla aevvnam, os hona tendoriniva memba Yesustindirini, ");
INSERT INTO wrs_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","wo henga Pita ona, owainonoa. Wo dawonam no indhanamba umnina, tanamta yimba esm osalv, yimba Yesustindirinita, manara nengara yimba Galili provinsrini, moamba yenamba indanampeta. ");
INSERT INTO wrs_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Doa Pita unna, kava tanamolnam ov, kava gekalava otava, ata Sesoava kamba sahokla vrevav. Kava tit vrev, hemba nomba yimba temba umnivpa. ");
INSERT INTO wrs_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Wo nonamba Pitava ona ishollohna, ayam opho, seilm ophoi, eva men henga ophov. Doa Pitava nengna, Yesusva honam kamba doarava ishomnana, os honi sinimba yimba ata penahonam samblamongolm osalwolvav, Yesusva kava tit vrev. Wo yimba osva ata ishopiarava, doa ayamba ata henga ophovav. Doa Pita duuskumbi venavna, wo mindnam wo ve. ");
INSERT INTO wrs_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Wo lingil lihavnamba, no Yutanindna kuwul indkumbiva moapetava henga ishuvna, ata es hevpa vinivav Yesusmba? Wo moamba ishopieinamba, ata os vinivav, wo polisi Yesusmba saongna ningina, wo ningulanga Pailat duangindam. ");
INSERT INTO wrs_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Doa di henga Pailat sah ovre, es hevpa yimba kuwul mendekli wulluhunvma Yutanindna? Doa Yesus ona, ten ye oimta. ");
INSERT INTO wrs_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Wo no kuwul, ten doara hev kevrinam, noi osva moangakala ovrivna, Yesusva os vevnata, osm Pailatm dasalm ovrivna. Os ningvna, Pailatva ata Yesusmba helvakomandhavav kana moara. ");
INSERT INTO wrs_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Wo Pailatva henga Yesusm omnana, yemba ambo mindnam indkokla ovriv, es yimba ata sesva ishunvav? ");
INSERT INTO wrs_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Wo Yesusva moamba hengava ishonamoa. Doa noinda Pailatva os nengaloh vevnamba, pai, hona indhanariniva es hevpa? ");
INSERT INTO wrs_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Wo Pailat duangna wevsa os lohmanavna, Yutanindva no innemba mendekliva hlawuvnamba no tahonnam no tahonnam os hlawuvna, wo mongasal buinindrinim wolapho vawovna Yutanindna moara. ");
INSERT INTO wrs_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Wo nonamba mongova indhanariniva buimera livna, nihilva Barapas, wo himba daosnindm engalpethanamba, duangna valgonindm engvapingilm vevna, wo indhanamba helvakomo vivnamba, noinda bui vina. ");
INSERT INTO wrs_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Doa Yutanind mindnam prapianamba, Pailatm sah ovri, kam os vinu, mepev doara velohvm, mongongalm buimerinim wolaihapho. ");
INSERT INTO wrs_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","10","Wo Pailat nengna, honi indhanamba Yesusmba musk vinivmoa, kuwulangas hev Yesusmba muembnavho vriv, wo noinda Pailat unna, es yimba ningv, Yesusm kava wolaihaphovavma, men yena kuwul wulluhunvm? ");
INSERT INTO wrs_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Doa sembayang andranindna kuwulva di mura lovahvna, no moamba hillinvnamba, wo ombandhanam otuhtina, osm mindnam Pailatm umnira, os Barapasmoa wolaihapho, Yesusva owai. ");
INSERT INTO wrs_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Wo henga Pailat osah owol ve, es ata kava eva venavav Yesusmba, memba osva yimba ningthivpa, Yutanindna kuwul? ");
INSERT INTO wrs_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Doa he di mindnam umnina, pakona hemoa tira krusera lepetheiu. ");
INSERT INTO wrs_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Doa Pailat henga unna, owai, heva os mana vemakoklava venamoa. Wo henga he di mindnam umnina, pakona lepetheiu krusera. ");
INSERT INTO wrs_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Wo Pailatva hena moamba hillinnamba, wo Barapasm wolaihinginna, doa Yesusm hevna valgonindindam wolaihangavna, wo valgonindva ambo esvema di Yesusmba hilvi wepondanasna. Doa Pailat hevna valgonindm unna, pakonaoa daha os lepetheiu. ");
INSERT INTO wrs_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Doa valgonindva Yesusmba waianganamba Pailatduangna pueilmera, wo indkumbim valgonindm nembapho vi, nonglalm. ");
INSERT INTO wrs_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Wo Yesusmba kayen aembul vithimninamba, wo topilm wesel nasna weilvrimnina, wo kura weilholothumnie Yesusm, dasalm ambo osm ora memba kuwul. ");
INSERT INTO wrs_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Doa Yesusm dasalm ambo moari ovruwuvna, yimba Yutanindna kuwul a? ");
INSERT INTO wrs_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Wo tengana kuval hevri, wo muembksvna wehla, wo dasalm mulumbdandna ambo lovahthamnavna, os kuwulm ten vewol vinivm. ");
INSERT INTO wrs_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Wo osva moari vepiemninamba, wo kayen aembulva henga selvoreimnivna, hevna henga vithimnivna, wo Yesusmba waianga, kruseram lepethalm. ");
INSERT INTO wrs_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Wo Yesusmba monara waiangavna, mongo indhanariniva provna monam, nihilva Simon, oklamini himba provna, wo Yerusalemram pholm vevna, no Simonmba Aleksandaina Rupusina aral, wo Sairini kotanindrini. Doa valgonind umnina, Yesusna kruseoa pungao. ");
INSERT INTO wrs_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Wo Yesusmba dem waipulvo, nomba os ningthiv Golkota nomba olomba, osm ovna, oi indhanana kukel. ");
INSERT INTO wrs_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Wo Yesusm wainmba daholm vivna, no wainmba obatnahonam moakot vinamba, osm daholm vivna, ata humeis nihsesoa venavm, heva os owai, Yesusva nenamoa. ");
INSERT INTO wrs_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Doa pakona kruserava hevpa lepetheinamba. Wo Yesusna malova dumbnamba, doa pilai win vivna, osm hevm moang viwul vina mongom mongom. ");
INSERT INTO wrs_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Wo Yesusmba nonamba krusera simolnam lepetheivnamba, dihi os yamba 9pelara vevna. ");
INSERT INTO wrs_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Wo valgonindva nomba hevna volm vina, wo krusesra sena os moapeta tombaira kleihina, osm hona moara lepetheie, wo os moapetava kleihina, ");
INSERT INTO wrs_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","28","Doa indhanarini samblava di Yesusinda murapeta krusera lepethiwulna, nomba indhanarini samblava helvakomonindrini sambla, lepethiwulna noinda. Mongova sihanasis eva mongova nihanasis, os lepethiwulna. ");
INSERT INTO wrs_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Doa indhanamba di monarava kohawovnamba, wo Yesusm nonglavol ovovna, loskas ovrakov ovrivna, ye honi kana tempelduvpa Yerusalemrinimba taka velva olohvnama, wo ovna, kava henga si samblamongo okombanam ambo dembravav? ");
INSERT INTO wrs_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Pev doara ten indhanam wolapho vevnam, eva os pevmoa wuleihota, kruserinioa holopeo. ");
INSERT INTO wrs_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Doa no Yutanindna kuwul indkumbi os hevm moarialm ishune, pim wolapho velm prona hona pethara, heva os hevpa owai, kruserinimba holopevmoa. ");
INSERT INTO wrs_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Ai Sesoava yemba tanamba doarava pusvundthoatava, wo tanam yimba kana kuwul wulluhunvtava, wo daipotaoa kruserinioa os eva holopeota, wo yemba kava undnahonam lovahthamnavav, tanam lehra lohv. Wo no daosnindrini samblava hevna kruse pethalliniva eva ohokosv venata Yesusmba. ");
INSERT INTO wrs_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Wo okombava hovrava lohvnamba, doa heva os simsna okilvra, venamba, okomba vohanam yam 3pelara vena. ");
INSERT INTO wrs_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Doa nonamba Yesus hevnamona kinge o, os eloi eloi lama sapaktani, osm ovna, kana Sesoa, kana Sesoa, manara yimba kamba nunglulihai? ");
INSERT INTO wrs_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Doa mura mongova di hillilvahvna no moamba, wo os una, pai, hillu, Yesusva Elaitam wunuhomnav, ten doara heva amana venam. ");
INSERT INTO wrs_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Doa mongo indhanarini lelnam ganamba, lembatamsna vranamba, wainpolla velthanamba, wo tenglara lothonamba, wo Yesusm mengval nethavongovna mengutilm. Wo ona, piv dawonam nunglul lovahv, ata Elaita provmi, wolaihapihavmi owaimi? ");
INSERT INTO wrs_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Doa Yesusva eunillam kinge onamba mindnam, wo wohdaha. ");
INSERT INTO wrs_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Doa wohdahanamba, wo mana vema os phona tempelmera di Yerusalemra, wo kayenmba mendekliva merava tempelduvra kleihalohvnamba, mongo tuvra diva kleihalohvnamba, wo heva hev ambo hovrahovra powalwolna. Os powalwolna dipeh, venamba dingoho. ");
INSERT INTO wrs_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Doa Yesusva nonamba dahavnamba, wo mongo valgonindna kuwul nunglul lohvna, Yesusva hena novra wohdahana, wo hev ona, tanamolnam hona indhanariniva Sesoana ombolta. ");
INSERT INTO wrs_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Wo eva mongova ungevliva okla lovahvna, nonglanga velvohvna. Honi lovahvna, Salome, Maria Maktalarini, Maria Yemsina Yosepina aval, no Yemsva boasalal lohvna. ");
INSERT INTO wrs_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","No ungevliva doarava engpethalvohmana vevna, Yesusva diva Galili provinsrava andra vevnamba, wo hetindim innemba dahwol velvohvna. Wo mongla ungevli mindnam di eva Yesusm nunglul lovahvna, ten Yesusm Galilirini Yerusalemram doara engambnam. ");
INSERT INTO wrs_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","43","Okombava pelangalla avnamba, wo mongova Yutanindna kuwul provna, nihilva Yosep. Himba besal lohvna, Arimatia kembellini. Wo himba indva wulluhunvna, Sesoava si hevna nemeltindimba beswonam wonavav, wo himba nom nengaomana vevna. Wo himba doara nengna, simba ata kilvravav, simerava temba vah iaevulvav. Wo es hevpa Yesusva mindilva vindkleihalohvav kruserava. Ambo os nengvna, ambo ka gavai, Pailat duangm osahmana, es hevpa Yesusmindmba kava ata detiva singvivavma? Wo pepehtovpa piengana, ambo nis ganamba, Pailatm osahmanana. ");
INSERT INTO wrs_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Wo himba hellenamba, ona pai, es hevpa Yesusmba lelnamba dahai? Wo wunuhomna valgonindna kuwul, noi wulluhunvnam, wo sah ovre, es hevpa Yesusva doa dahaimi, owaimi? ");
INSERT INTO wrs_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Wo no valgonindna kuwul omnana, doa dahaita, wo noinda Pailat Yosepm omnana, wouta gao, vindpipahota, wo singviu pokamara. ");
INSERT INTO wrs_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Wo Yoseppa ganamba, kayen dombal nemel sovakanamba, wulpro, Yesusm kruserini vindpipaha, no kayenna ningenamba, honmera yitha, no melva doara hina indhana hev. Doa hon mendekli vaval umharavho vrunganamba, no melva ehlatha. ");
INSERT INTO wrs_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Wo Maria Maktalarinii, Maria Yosepna avali, himba nonamba di nunglul elohvna, Yoseppa Yesusmindmba honmerava vindithavnamba, ona nolhra ten. ");
INSERT INTO wrs_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Sapturava vepieinamba, doa no sinimta ambo Salome, Maria Maktalarini, Maria Yemsna aval, hona ungevli samblamongo anganamba, welsanda sovawol vehalvna. Nomba wel sandava besal hevm teihnungva vevna, wo no welva Yesusmindm pokamaram selvolm iangalm vevna. Yutanindna wevsana himba iangavna. ");
INSERT INTO wrs_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Minguram okombava bonamostava vevnamba, dem anga pokamaram, ");
INSERT INTO wrs_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","wo olongovnamba, hevm ishune, an pimba ata kollombvav, honmba nomba pokamarinimba velavhoalmba? No honmba mendekliva pokamariniva. ");
INSERT INTO wrs_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Doa pokamarava diva pulvonamba, nunglina, pai, honmba doa ahnam umharavho vrulangai, melva os velaihalohv. No honmba mendekli. ");
INSERT INTO wrs_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Doa mellava saivnamba, ona nunglina, pai, mongova tuendisriniva malo dombalna tokolna men av nihanasis, wo ungevliva pemba os vivna i. ");
INSERT INTO wrs_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Wo himba unna, yimba manapenam viv? Yimba Yesusm Nasaretrinim aslalalm ambei, ten krusera dahanam? Owai, huiva vindilvmoa, doa henga beswonam phoi. Nunglu, men honinda vindil liheinata, wo vindilvmoa. ");
INSERT INTO wrs_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Doa henga angota, Pitam, mongla hevtindim os ishunu, doa Yesusva mi yemba desumbi gai Galili provinsram. Wo di si yimba hemba nonglapulvovav, os hev doara ten yem ishunnam. ");
INSERT INTO wrs_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Doa ungevliva mindnam pem vivna, eiswol vevna, pokamarinimba vinamba, lelnam anga, pepehnahonam ambo angavna, monarava himba ishunvnamoa indhanamba. ");
INSERT INTO wrs_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Wo nonamba Yesusva pokamarinimba simolnamba phonamba minguram, wo seilva himba Maria Maktalarinisnam ishokamnana, no Mariana nihmerini himba doara 7pelara tihsongomba engilpingu venanamba. Noinda nonglana, heoa kam lihara, kava beswonam lohv. ");
INSERT INTO wrs_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Doa nonglanamba, Mariava silelguawol vevnamba, Yesustindim ishunilm. Wo himba mendah duus vinivna Yesusmindm, os wuo ovna. ");
INSERT INTO wrs_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Doa Mariava unna, Yesusva henga doa phoi, kava doa nonglai. Doa himba os ningvna, gekala ov. ");
INSERT INTO wrs_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Doa Yesusva indanampeta nilhana, wo hevtindirini sambla himba mongona kembellam engavna oklapetam, wo hev engilpetha. Wo henga sism osva enengna, Yesus hev memba. ");
INSERT INTO wrs_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Doa no samblava henga eprinnamba hevtindi indam, ihishune, kava Yesusva doa enonglai monara. Wo nomba ninginvna, gekala ohov. ");
INSERT INTO wrs_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Wo dawonam ambo mongawulm hevtindiva 11pelara avhoapronamba, inne hlavna, doa Yesus di heva hev ambo hovra phune, wo koasromb vevna, manaram yimba osva uvna, Yesusva phonamoa pokamarinimba? Monglava indhanamba yemba ishunvnamba, osva Yesusva doa kava nungli, wo yimba os ningvna, gekala uv, yimba undhui lovahvma? ");
INSERT INTO wrs_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Yeoa angawul veota, mongona kembellam, mongona kembellam hona petharaoa, wo kana nemelmoa besal wulvahmana vinu indkumbimoa. ");
INSERT INTO wrs_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Doa himba nomba kamba osva undnahonamba lovahthamnavrava, wo henomoa pona pusvu, hemba nomba Sesoava si lopshavav. Wo himba nomba kamba lovahthamnamba owai vevrava, Sesoava si hemba nomba os unvav, yenamba sahoklal luhunv. ");
INSERT INTO wrs_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Doa himba nomba kamba keknamba lovahthamnavrava, himba nomba os vivra, tihsongova indhanana nihrinimba engilvra, kana nihilm os sevrivrava. Wo himba nomba moamba ishuvav, ten seilm tit vivnam, ishuvnamoa. Wo indhanamba nungeilvrava, uvra, Sesoanamini. ");
INSERT INTO wrs_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Wo eva himba nomba os vivra, saiholava kevrivra, wo mana emamba sahoklalva hlavra, wo noindava dalvramoa. Wo eva himba englana huhlinvra uvavulmungilmba, wo hemba nomba kanandhawol vevra. ");
INSERT INTO wrs_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Doa Yesusva hev mendekli hona moamba ishopieinnamba, Sesoa waivongo hevindam, wo murapeta hevinda nihanasis desvhoana kuwul mendeklielm. ");
INSERT INTO wrs_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Wo hevtindiva bukethungu vena, wo no besalmoa Yesusna indkumbim isholvohmana vinvna, mongona kembella, mongona kembella. Wo mendekli hev poauothowol vevna, wo himba mendekliandra vewol vivna. Wo noinda indkumbiva osva ningvna, Yesusmomba tanam. Doata Makna Yesusmomba. ");
INSERT INTO wrs_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","2","Kava Luk, wo yemba kava honamba tombaimomba pipramnav, yimba Tiopilus, wo pev kuwul wulluhv. Yimba nonora lohv, moamba mendekliva doara phunna huiva kaindava, Yesusmomba. Indhanamba novnamba nunglivnamba, nonamba Yesusva hevna andrava kovonevnamba. Vevnamba, doa kek vithivna, wo heva os ambo mana vemamba phonamba, himba nonglangas vivna. Doa osva himba Yesusna moalamangnindilm lovahvna, wo hev kamba ishomana vinivna Yesusmomba nomba. ");
INSERT INTO wrs_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","4","Doa indhanamba monglava doara nomba Yesusmomba tombairava novol vewol vina, doa kava eva osangas vevta, Yesusmomba tombairava novol vewol vevra. Manara, kav doara plalmomba velokusa vena kavmba, doa kav tombaira novol vewol vena, osm lohohra lohgara. Kava mongova moamba maivethanamoa. Tiopilus, yimba kuwul wulluhv, wo osm kava vev, yeoa lihao beswonam. Yimba plalmomba lihavav, temba indhanamba doarava yemba ishumninamba Yesusmomba, wo os yimba nonorava lohvav, tanam. ");
INSERT INTO wrs_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Doa mongova tendoriniva lohna nihilva Sekaraia. Himba sembayang andranindrini lohvna, nonam lohvna Herot mendekli kuwul wulluhunvnam Israelnindnam. Sekaraiana ongalva avna, nihilva Elisapet, tlal ongalva himba Arontindirini, nomba temba doara lovahvnam sembayangna andranind. Sekaraia, hevna mongawa andranind, himba hevm os ningthiwul vivna, pimba doaramini andranindrinim engiv Apaisam. ");
INSERT INTO wrs_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","7","Doa tlal ongalva himba Sesoa mendeklina doaraminimomba ekek vethavna, beswonam ehengvna, doa mendekliva os hemba nongalna, besalangas. Doa heva os himba muhsoh ahamana evevna, os mundkola vewolvna, ongalva doara phal avna. ");
INSERT INTO wrs_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Doa sembayangna andranindva nomba himba tempella andra vivna, wo Sekaraiava mongawulm wonandra vevna, wo os uvna, memba pina honanamba phunv, pimba Apaisanind. ");
INSERT INTO wrs_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","10","Doa andranindva nomba os vivna, temba hevpa doara os velvohvnamba, himba mongom hevm pusvundthueivna, doa Sekaraiam pusvundthueivna, doa osva himba tempelmera sihana, osm tinenm suweram sengamnalm, Sesoa mendeklimoa teihnung besal eilsuhra. Os vevna, andranindva elsus velvohvnam, wo himba deuvmera sihanamba, kembelnindva mindnam ambara lovahvna, sembayang vivna nonamba. ");
INSERT INTO wrs_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","12","Sekaraiava mana emamba nomba suwera sengavna sengsra, oi lang, doa mongo mendeklina ovsongolnindrini hemba nonglaphona di sengra nihanasis, wo Sekaraiava hemba nonglavna. Doa Sekaraiava luklukul vethavna, pem vevna. ");
INSERT INTO wrs_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","14","Doa ovsongolnindriniva omnana, Sekaraia, pepehtovpa wuleiho, wo pevna sahmomomba Sesoava doara hellena, wo doara kek vethavna, wo noinda himba si yemba venavav, doa ongapevmba yenamba si ena vethavav, otolm lenge, tuendisrinim. Yeoa hemoa os awo Yon. Himba si phorava, yimba indk evethamnavav, wo si indhanamba indkumbiva indk vithimnivav, lehra phona. ");
INSERT INTO wrs_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Sesoa mendekliva si Yonmba os nonglavav, mendekli, wo Yonmba manam nevav biava eva daipva, owai. Avalva mendahva hemba lengvra, doara Sesoasongolva Yonnamba nihmerava sihamnavra, wuhholm. ");
INSERT INTO wrs_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Doa os Yonmba si Sesoana moamba ishomana vinvav Israelnindmba, wo mindnamba himba hevna indkoklamba wuleihivav, mendeklim engivav henga, nomba temba hena Sesoa luhunvpa. ");
INSERT INTO wrs_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Wo Yonmba si os lohmana vevrava, wo Sesoasongolva hemba poauothovra mindnam. Doa indhanamba si os uvav, Yonmba os vawov, oi Elaita moashulnindrini, ten doara lohvnam. Wo Yonmba si os mi desvulprovav, doa Kristusva si os prunvav. Yonmba si os Sesoana moamba ishomana vinvav indhanamba, wo mundilva si os hillivra, wo hev si hevna otolmba und vewol vivav henga. Indhanamba kelsombovholva Yonna moamba si os hillivra, doa hev si os hengava Sesoam beswonam lovahthamnavav, maim ura, indhana besal. Doa Israelnindva himba si os Sesoamba mendeklimba aevulmanavav, si himba provav, pioa hemangas engivra, Yonmba os ishona. ");
INSERT INTO wrs_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Doa Sekaraiava mendah ovsongolnindrinina moamba hellevna, ona, es hevpa kava lihavav, osva moamba honamba yenamba tanam? Kavm kana ongalm doara doa mundkola vewolna, wo es hevpa kana ombolva si lohvav? ");
INSERT INTO wrs_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","20","Doa ovsongolnindriniva omnana Sekaraiam, kava Gaprel lohv, wo Sesoana novra kava wohlohv yunalm, hena andra velm. Himba kamba homba doa wolaihapri, yem ishomnalm hona moamba besal. Es hevpa yimba kana moamba hellevmoa? Doa Sesoava ata yemba venavav, wo noinda ata yimba moahui lohvav, verava, si yena ombpovpa phovav. Sesoava doara doa pusvundthoana, ora nonam. ");
INSERT INTO wrs_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Wo os Sekaraiava wenokomba vevnamba, tempelmerinim pholm, mendah nomba Sesoana ovsongolnindrinina moamba hellevna. Doa sembayangnindva, temba ambarava lovahvnamba, himba tit vivna, pai, es hevpa manara wenokombava vev? ");
INSERT INTO wrs_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Doa os Sekaraiava phunnamba tempelmeriniva, doa heva os moahui, himba ambo englana vinvna, indthueinvna. Doa sembayangnindva nomba ningna, doa Sesoava Sekaraiamba nov wolaihamni mana vemamba tempelmerava. ");
INSERT INTO wrs_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Doa dawonam Sekaraiava hevna mongawa andranind himba andrava vipieinamba, wo hevindam angawul vena os deuvram. ");
INSERT INTO wrs_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","25","Doa sism ongalva ena vethavna. Himba hevna deuvmba wuleihanamoa, weisva 5pelara khuawol vevna. Ona, doa Sesoa mendekliva kamba beswonam nonglana, wo doa kamba beswonam venana. Indhanamba si kamba hengava umnivavmoa osva, phal, owai. ");
INSERT INTO wrs_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","27","Doa weisva enamra venamba, Sesoava hevna ovsongolnindrinimba Gaprelmba os wolaihangana ungevlirinim ongamalm mongom, nihilva Maria. Indhanamba doa doara nomba ungevlirinimba pusvundthueinamba, umnina, yena tlalva si Yosep lohvav, nomba Yoseppa Devittindirini lohvna, nomba Mariava himba Nasaret kembella avna Galili provinsra. ");
INSERT INTO wrs_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Ovsongolnindriniva hemba nonglaphonamba, doa hev omnana, Maria beswonam ao, Sesoa mendekliva doara yemba waiavna, wo doa yemba nesmos vrena. ");
INSERT INTO wrs_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Doa Mariava hellenamba hona moamba, mindnam duus vevna, hev nengna, manamoa snamba hevpa? ");
INSERT INTO wrs_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Doa ovsongolnindrini henga omnana, pepehoa wuleiho, Sesoava yemba beswonam nonglav. ");
INSERT INTO wrs_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Hello, yimba tlahui, heva os yimba ena si avav, arava, doa yimba si tuendisrinim lengvav. Wo os yeoa awo Yesus. ");
INSERT INTO wrs_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Si himba mendekli kuwulva wulluhunvav, wo Yawe Sesoa mendekliva si hemba nonglavav, oi, kana ombol. Doa hev Yesusmba si os desvhoavav simbehumunillinina vuhera, Devit kuwulna vuhera. ");
INSERT INTO wrs_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Doa os himba yunalm si kuwulva wulluhunvav yenamba Israelnindnamba, wo hev hona vuhemba si wuleihavavmoa. ");
INSERT INTO wrs_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Doa Maria ovsongolnindrinimba omnana, es hevpa honamba kava nisva enamba avav, mani kava tlatrinima? ");
INSERT INTO wrs_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Doa ovsongolnindriniva henga omnana, Sesoasongolva yemba si ehlathamnavrava, wo Sesoa senaminiva yemba poauothovav. Doa osva yemba si ena vethavav, otolm lenge tuendisrinim. Wo noinda Sesoava si omnavav, kana ombolva, besal. ");
INSERT INTO wrs_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Hello, pevna owapevm nengmano Elisapetmoa, nemetva os umnivna, phal av, doa mundkola vena. Heva os enamra weisva doa khuawol venamba, Elisapetva enamba os ana. ");
INSERT INTO wrs_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Sesoava mani owai vevavma? ");
INSERT INTO wrs_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Doa Maria omnana, mani hevpa, kaoa ambo mendeklina andra ungevlirinielm ai, wo os ambo kam venara, ye ten pev oim. Doa ovsongolnindriniva os wohwuleihana, os gana. ");
INSERT INTO wrs_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","40","Doa Mariava ena avna, himba hevna owalm Elisapetm nonglalm vevna, ten ena avnamta. Wo hev meilna venamba, doa hev Elisapetm enggana lelnam. Os hev enggana mongona kembellam dom oloram Yutia provinsram. Wo Mariava diva sihanamba Sekaraiana deuvrava, doa hev Elisapetmba omnana, yimba lehra av. ");
INSERT INTO wrs_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","42","Doa Elisapetva hellenamba Mariana moamba, doa otolva dalohka venavna Elisapetna emera. Wo Sesoasongolva Elisapetna nihmera sihamnavna, doa Elisapetva Mariam mindnam omnana, lehra yimba prov kaindamba. Sesoava yemba doa nesmos vrena, wo eva hev yena otolmba nesmos vrenata, ten yena emera livm. Ungevlina nihilmba yenamangas wulvongav. ");
INSERT INTO wrs_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","44","Yimba si lengvrava hona otolmba, wo mani himba ombandhanarinima, owai, himba si kana mendeklielm lohvav, oi Sesoa hev. Noinda yimba kamba doa nonglai, memba besalta. Yimba kamba ophomniva, otolva kana emera und lothovnamba, os dalohka vevna. ");
INSERT INTO wrs_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Doa Elisapetva mendah Mariam ishomnavna os, Sesoa mendekli doa yemba beswonam vrena, manara, moamba temba himba yemba ishomnanamba, yimba kek vethavna dawonam, ona, mendekliva si os vevav tanam. Doa os yimba beswonam indwonam av. ");
INSERT INTO wrs_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","47","Elisapetva Mariamba ishopiamnanamba, doa Maria ona, Sesoam mendeklim kava undnahonam okolav, kava hemba indk vethamnav, wo himba doa kamba lopslahana monakoklariniva, wo kava beswonam av. ");
INSERT INTO wrs_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Kava ambo andra ungevlirini av hena, wo heva os kamba himba beswonam nonglav. Doa si os indhanamba indkumbiva kamba uwuvmona venavra yunalm, Sesoa doa Mariamba beswonam vevrana. ");
INSERT INTO wrs_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Sesoava keknamangas lohv, wo hevpa kamba mendekli andrava venana, kolvralmba kamba. Himba besalangas nihvuhinmba owai, wo pimba hemba okuliv os, besal senamini. ");
INSERT INTO wrs_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Indhanamba himba nomba Sesoamba okulivrava, wo engivra, Sesoava hemba nomba wavrava vovhueinvra, wo nesmos vewol vevra, vei eindilm aralm ombolm indkumbim. ");
INSERT INTO wrs_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Sesoava hevna englanamba mendekliandra vewol vena, wo himba keknam lohv, wo hev indhanamba engilungu vevra, nomba temba kelsombovhova vivnamba. ");
INSERT INTO wrs_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Doa kuwulva pethanindna, nomba temba vuherava mendeklilmba aevulvnamba, Sesoava hemba nomba doa wolapiha vena. Wo pimba ombandhanamba owai, Sesoava pimba vuhe besalla sandhana. ");
INSERT INTO wrs_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Doa indhanamba nomba temba pondava aevulvnamba, Sesoava hemba nomba dahwol vena innemba besal. Doa heva os innetnamba himba os ishunvna hemba, yeoa posal ango. ");
INSERT INTO wrs_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","55","Doa pimba Israelnindva Sesoana andranind lovahv, wo himba pimba nesmos vewol vev. Sesoava hevna moamba maivethanamoa, temba hevpa doara pina simbehumunmba ishunnamba, ona, yetindimba kava si wavrava vovhoawol vawoinvra yunalm. Hev Aprahamba osangas ishomnana doara. ");
INSERT INTO wrs_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Wo Mariava osva Sesoana nihilm okolavna, wo hev hevnam mangawalm Elisapetm mendah waiavna, weisva samblamong khuawol venana, doa hengava hevindam os gana. ");
INSERT INTO wrs_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","58","Doa Elisapetmba kelathamnavna, otolm lengalm, doa owalva hemba indk vithimnivna, lehra, doa Sesoa mendekliva Elisapetmba nesmos vrei. ");
INSERT INTO wrs_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","61","Ombolva himba simba 8pelarava venamba, wo owalva ambna, doa nihtovpa kovhueimnina, osm ora Sesoatindi. Doa una, pioa os awui Sekaraia, memba aralna nihil. Doa aval ona, owai, os kava awoi Yon. Owalva umnina, owai osva, seilva mani simbehumunilnamba nihil lohnamoa. ");
INSERT INTO wrs_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","63","Aralva Sekaraiava di lohvna, hev mendah moahui lohvna, wo angumi vevna. Doa owalva englana ambo indthueimnivna hemba, es yimba awov pevna ombpovmba? Sekaraiava englana ambo indthueinvna, osm ovna, tombai wulproo, doa hev os novol vinna, nihilva henamba Yon. Doa owalva os nengavnang viwul vevna, pai, lehra awohoi avalna moara. ");
INSERT INTO wrs_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","66","Doa nonamangas aralna mengva povhoana, wo himba hengava beswonam moamba ishovna os, ona Sesoam kava okolav. Doa owalva indkumbiva mindnam ningvna, os honamba moamba mera vena kembelnindm indkumbim di olora Yutia provinsra. Indkumbiva kek vithivna, una, hona Yonmba si manalm lohvav? Ningvna, Sesoa mendekliva memba hemba waiavpa. ");
INSERT INTO wrs_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Doa Sesoasongolva sihamnana Sekaraiam, wo himba nov wolaihamnana nom, si os phovav. ");
INSERT INTO wrs_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","Ona, Yawem mendeklim kava okolav, himba Sesoa luhunv pina Israelnindna. Himba pimba beswonam nongalnamba, doa buiriniva wolapho ve, unna, yimba katindilm lovahv, kava yemba doa kanothowol vev. ");
INSERT INTO wrs_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Sesoava doa mongom hevna andralm wolaiahaprav hom, osm pim lopshara monakoklariniva, nomba indhanariniva himba prov Devittindirini, Sesoana andranindrini. ");
INSERT INTO wrs_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","71","Sesoa doa doara hevna moashulnindmba ishunna honamba, doa moashulnindva himba moakus unna pina simbehumunmba, os unna, Sesoava si pimba lopshawol vevav ungundna englisriniva. Doa ungundva nomba temba pimba daosalm unvnamba, Sesoa pimba hena englisriniva muehrombol vevav, doa pimba beswonam aevulvav. ");
INSERT INTO wrs_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","73","Sesoava os ishunna pina simbehumunmba, ona, si kava yetindimba wavrava vovhueinvav, doa nesmos vewol vevra. Sesoava Aprahamba moamba honi ovrahona, pina simbehumunillinimba, wo hengava maivethanamoa, owai, wohvev, nomba temba hevpa omnanamba. ");
INSERT INTO wrs_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","75","Sesoava Aprahamba ishomnana os, yetindimba kava si ungundna englisriniva muehrombol vevav, wo himba kanamba sembayangnind wohlovahvav os. Himba pepehtovpa wuleihivav, wo kamangas andra vinivra yunalmba. ");
INSERT INTO wrs_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Sekaraiava mendah hevna ombolm ishomnana os, Omb, Sesoa mendekliva si prinvav, wo yimba si mi desvungavav hemba, monam vuenghamnalm. Doa Sesoava senaminiva si os yemba omnavav, kana moashulnindrini. ");
INSERT INTO wrs_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Yimba si os Sesoanindmba ishunvav, Sesoava pinamba indkoklava si poswol vinvav. Doa himba si os uvav, lehra himba doa pimba lopshawol vena monakoklariniva, mona besalla sandha. ");
INSERT INTO wrs_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Sesoava pimba wavrava vovhueinv, wo und vewol vev, wo noinda himba mendeklimba si wolaihaprinvav pimba, wo pimba uvav, doa pimba okombava lovhueinna. ");
INSERT INTO wrs_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Mendekliva provrava, hev si os indhanamba upsil lovhueinvra, nomba temba sikulmonam aevulvpa. Wo nomba indhanamba, temba dalalmba vevpa, himba hemba nomba si os wolapho vevav beswonam. Mendekliva pina pethanindna kemonglam naengho vewol vungeinvra, osm alm no monanam indwonam. ");
INSERT INTO wrs_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Sekaraiava honamba moamba omnanamba hevnam ombolm, doa sismba ombolva mendekli venamba, henamba nengavnangva besalangas wohlohmanavna. Himba seilva indhanahuira amana vevna, doa sismba hev Yutanindmongo euvmona vevna, osm moa ishomana vinvra. ");
INSERT INTO wrs_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","2","Mariava Yesusmba lengvnamba, honamba moamba os phona. Akustusva himba duang mendekli luhunvna Romnindna, doa himba moa ishonga vinna os, kava novol velm vev nihilm indakonda pethanindnam, no provinsnindnam, no provinsnindnam, indkumbinam. Memba seilnovra nomba duangva indhanana nihilva novol vewol vinna tombairava. Nonam vena, Kuirinius himba kuwul eusil wulluhunvnam Siria provinsnindna. ");
INSERT INTO wrs_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Wo nonamba duangva osva onbavna, wo noinda deuvnindva himba wohgapiangu vevna hevna kembellamba, osm henamba nihilva lopo vinvra tombairava di hevindava. ");
INSERT INTO wrs_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","5","Wo Yoseppa Mariatalaiva, himba hem waiavna di Nasaret kembella, mera Galili provinsra. Himba Devittindirini, wo noinda himba galm vevna hevna kembellam Betlehemram, no kembellam nemet ten Devit simbehumunillini anam. Nomba Betlehemba di lohvna Yutia provinsra. Yoseppa venamba Nasaretriniva, wo doa os gana Betlehemramba, Mariamba os waingana, ena avna. Hev omnana, Betlehemra duangva pina nihilva novol vewol vinvav si tombairava. ");
INSERT INTO wrs_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","7","Yosep os waingana Mariamba Betlehemram, doa di Mariamba kelathamnavna, otolmba lengalmba. Hev os lengna hevna mimirinim tuendisrinimba, wo malona hemba ningilahana. Doa hev os otolmba nomtholahana boksmera, di ten sapi inne hlalvohvnam. Wo heva os mani vuhe besallama, ambo sahoklalla, manara, owai, vuhemba lohvnamoa deuvrava, ninmba shalmba, doa doara pilivhoangu vena deuvpa. ");
INSERT INTO wrs_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","9","Mariava Yesusmba lengvnamba, wo andranindva di kekalvho vewol vewuvna hevna sipsipmba di kembelnumbra maim. Himba di ambara lulungu vevna sinimba, ten sipsip lulungu vevnam ilsra. Doa mongo Sesoana ovsongolnindriniva holopinnamba andranindm nom, wo dingas Sesoana pusambanakambava weisming vewol vena, di he kekalvho vrivnam, wo andranindva pemba os vivna i. ");
INSERT INTO wrs_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","11","Doa heva os ovsongolnindriniva unna hemba, pepehtovpa wuleihu, kava moa besal wulprunv yemba. Indkumbiva si hillivrava, doa indk vethapravra. Honi sinimba di Betlehem kembellava mongova ungevliriniva doa lengei tuendisrinim. Wo eva mani ombandhanarinima, owai, himba si os lohvav Kristus mendeklielm. He si yemba lopslahawol vevav monakoklariniva. ");
INSERT INTO wrs_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Memba yem kava ishunv, ango dom nonglalm hem, ata yimba os nunglivav, otolva malona ningilvra. Himba ata vuhe besallava lingilvramoa, owai, ata himba lingilvra, di ten sapim dahwol velvohvm, wo ata yimba nunglivav hemba, eva uvav, tanam hona moamba ovsongolnindrininamba. ");
INSERT INTO wrs_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","14","Wo nungi lelnam ovsongolnindva esvema senamini pihapianamba, di mongawulm kusovna noi owallini ovsongomongo. Doa hev indkumbi sangal sevrivna, Sesoana nihilm okulivna. Hev uvna, pioa Sesoamoa okolalvohvra, nihilm wivimnivra, manara, ten senanonoa hev avm. Wo Sesoava si nesmos vewol vevra indhanamba hona petharava, nomba indhanamba temba hevpa beswonamba doa nongalvpa. Wo si indwonam aevulvav himba. ");
INSERT INTO wrs_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","16","Doa ovsongolnindva osangas vinamba, wo os wohangana Sesoaindam ovram henga, hev sipsipna kekalvhonindmba nomba sandhalaha angana os. Doa sipsipna kekalvhonindva nomba hevm ishuwul vevna, piv ambo indkumbi angavai dom Betlehemram, nungli honam nengam, mani hevpa dihi phoi? Sesoa mendekliva pimba doa ishuni, angavai bavo. Wo noinda himba lelnam anganamba, Yosepim Mariaim di nongalpulvo, otolva boksmera ningilvna, di ten sapi noinda inne hlalvohvnam. ");
INSERT INTO wrs_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","18","Doa hev otolmba nunglutithueivnamba, hev ishunvna Mariaim Yosepim, eva monglam indhanam, nom ten ovsongolnind noi moa Sesoana doara hem ten ishunnam, otolmom. Wo no indkumbiva diva no moamba os hillinvna sipsipna kekalvhonindnamba, wo himba indk vethapravna, besal, wo himba mindnam nengavnang wohvivna. ");
INSERT INTO wrs_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Wo Mariava hevpa himba maivethanamoa, memba daipotava ishunvpa, owai, himba yunalm nengaomana vevna, wo lehvna, plalmom levrapialm vevna hevm, nom hev ten vena, nonglanam, eva hellenam. ");
INSERT INTO wrs_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Doa sipsipna kekalvhonindva ishupieinnamba, os henga sandhambuona, hevna sipsipm kekalvho vrelm. Hev indkumbi momnanam Sesoam sangal sevrimnivnamba, nihilm wulovolmanavnam, honamba pivva doa vi, nungli eva hilli, memba hevm besalangas. Doa memba Sesoana ovsongolnindriniva pimba ishuniva, honamba tanam men osm. ");
INSERT INTO wrs_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Wo Yesusva simba 8pelara venamba, doa nihtovpa kovhueimnivna, osm ora Sesoatindi. Araravalva os awohona Yesus, os ten seilm ovsongolnindrini Mariam ishomnanam. ");
INSERT INTO wrs_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Doa dawonam araravalva ohona, pioa engavai Yerusalemram tempellam. Moses moashulnindrini seilva doara os novol vewol vena, araravalva osangas evevra, osm beswonam elohvra Sesoana novrava. Doa himba enganamba, ombolm waiengana, ohona, pioa hemoa os Sesoa mendeklimoa ihindthoamnavav di tempella. ");
INSERT INTO wrs_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Noinda osva ohona, mendeklina tombaimomba doara novol velohv os, avalva yiveltowondmba lengvrava, doa araravalva otolmba waiengavra, mendeklim ihindthoamnalm, osm ora yetindirini. ");
INSERT INTO wrs_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Doa araravalva hevna ombolmba os waiephona tempella di, ohona, pivva ata tatapetava holvo evrahunvra andranindm, wo he ata suwera wohweihimnivav, Sesoam sembayang venalm. Doaramini tombaimomba os novol velohv, araravalva os evevra, leumb samblamba holvorombtrahunvra, wo owaingava, himba ambo hinumb otolsamblam holvorombtrahunvra. ");
INSERT INTO wrs_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Doa Yesusna araravalva tempella ahavna, mongo mundil tendorini di avna, nihilva Simeon, himba Yerusalemra wohavna. Himba besal indhanarini, wo Sesoana moam engvna doara. Himba undva os vrevna doara, tanamolnam Sesoava si pimba Israelnindmba sandhavra, osm beswonam ara. Doa doara Sesoasongolva sihamnana, nengavnangm sishona vremnana. ");
INSERT INTO wrs_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Sesoasongolva doara ishomnana os, yemba nisva dahavavmoa owai, boasna yimba pevna novnamba nonglavav indhanarinim Kristusm, temba Sesoa mendekliva hemba pusvundthoanamba, osm yem Israelnindm lopshalm monakoklariniva. Hemangas yimba doara amnavna. ");
INSERT INTO wrs_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Wo Sesoasongolva henamba tuhmanana nengavnangmba, doa himba tempellam pronamba, nonamba araravalva Yesusmba waiepravnamba, nom osm velm, ten lohohmora luhunvm, vinilm otolm. ");
INSERT INTO wrs_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Doa diva Simeonmba Yesusmba avalnamini holvoranamba, os Sesoam okolavna. ");
INSERT INTO wrs_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","30","Hev ona, mendekli, yena moamba tanamolnam, temba yimba doarava kamba ishomnanamba. Doa kava men nonglav indhanarinimba, temba yimba kamba doara ishomnanamba, si provav. Himba kamba Israelnindmba si lopshawol vevav monakoklariniva. Doa manapenam, kamba dahavra indwonam, manara, kava doa hemba kavna novnamba nonglai. ");
INSERT INTO wrs_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","32","Yimba doa desvhoai hemba, osm indhanamba indkumbiva si hemba nunglivav, no pethanind no pethanind. Doa osva himba si upsil lovhueinvav puehalnindmba, nomba temba Yutanindna meisungundva angavpa, wo himba eva si os yena moamba kek vithivavta. Wo kamoa Israelnindmoa indhanamba si kamba okolowol vivav, yimba Sesoatindi. ");
INSERT INTO wrs_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Simeonmba os Sesoam okolavna, doa Yesusna araravalva tit evevna, ohona, pai esalm hevpa himba pina ombolmba osva ishomnav? ");
INSERT INTO wrs_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Doa henga Simeonmba Yoseptatanamba awothowol vena, aralm, avalm, ombolm, ona, Sesoaoa yemoa kolvrowol vera. Doa hev henga avalmangas ishomnana os, yena ombpovmba Sesoava doa pusvundthoana, mendeklim andram velm. Henanapopol Israelnindva mindnam si Sesoamba lovahthamnavav undnahonamba. Doa heva os monglamba Israelnindmba hemba wohplel vevav os. Himba Yesusmba si nunglivav, uvra, keknam, doa heva os himba hemba okus vivra. ");
INSERT INTO wrs_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Indhanamba mindnam si yena ombpovmba nunglivav, wo os hevna nengavnangva si amballa phunvav, vei besal indhanana, eva sahoklal indhanana. Doa heva pevm si os kinsombva venavav, oi bunena lui. ");
INSERT INTO wrs_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","37","Simeonmba osva ishomnanamba Mariamba, doa ongakolarini phunna, nihilva Ana. Himba Asertindirini avna, wo Panuelna mol avna. Doara himba tatlana avna, tahonmba 7pelara vena. Doa tlalmba os dahana, wo hev peli avna, tahonmba mindnam vena. Osomba henamba esvema, 84pelara lohmanavna. Doa elsus hev tempellamba tonglalohvna, hev innemba diva lohovna, sembayang os vevna sinim eva okombanam. Doa hev Sesoana moashulnindrini avna os. ");
INSERT INTO wrs_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Doa Anava phonamba, wo hev Yoseptatanam di wonlohvna, wo hev ona, Sesoava lehra vei, Kristusva doa phoi. Doa hev Yesusmom ishunvna hevna mongawa sembayangnindmba, nomba temba doara undva ilvahvnamba osva, Sesoava si pimba Yerusalemnindmba buiriniva wolapho vevav, osm indhana besal aevulla. ");
INSERT INTO wrs_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Anava os ishopianamba, doa araravalva sembayang wevsava wohevepianamba di tempella, nomba temba doara novol velohv mendeklina moara. Doa Yoseptatana nominiva vinamba, henga hevna kembellam angana Nasaret kembellam Galili provinsram. ");
INSERT INTO wrs_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Ombolmba mendekli vena, doa undva henamba beswonam lohvna, wo hev wiyera lohvna manam manam manam. Doa Sesoava hemba beswonam nonglavna, lehra. ");
INSERT INTO wrs_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","42","Doa dawonam araravalva Yesusmba Yerusalemram waiengana tihram, os ningthiv Pasovatih. Yesusna osomba os lohmanavna 12pelara, nonamba waienganamba. Araravalna wevsava os prunvna, himba Yerusalemramba etonglalohvna Pasovatihramba henga no tahonnam no tahonnam. ");
INSERT INTO wrs_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Wo tihva vipieinamba, wo innemba hlapianamba, doa tihnindva angawul vena hevna kembellam. Araravalva monam engavna, os hevna ombolm enengmanavna, dihi hesna gav, dihi monglam indhanam wongav? Doa heva os owai, ombolva mendah pronamoa, owai di himba wohana. ");
INSERT INTO wrs_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","46","Araravalva os titnam engavna, simba mongasal evena, doa hev hevna ombolm eslelvna owalhovra, di ten bukithavnam, heva os owai, enonglanamoa. Doa hev henga Yerusalemram engana, eslelalm dom. Ephonamba, diva henga eslelvna hemba, simba mongasal evevna, no kotava mendekli lohv. Doa mongnasiva hev henga hevna ombolmba enonglana tempellava. Himba katekisnindmongo aevulvna, hena Sesoamomba hillinvna, doa hev hemba osihinvna, plalmba velokusa vevna. ");
INSERT INTO wrs_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","48","Tempelnindva di Yesusm hillimnivna, doa indkumbiva una, pai himba und besalna lohv. Himba moamba besal esesmba ishowol vinv, lehra lohv. Araravalva eva ehellemnavna henamba moamba, doa tit evevna, doa avalva hemba omnana, omb, es hevpa yimba kamba hona kinwondava plothunv, araiva kava yemba duusnahonam eslelvna? ");
INSERT INTO wrs_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","50","Yesus unna, pev doara enengta, dihi tempellava av, es hevpa yimba kamba indanamba eslelvna? Manara, memba deuvpa kana arana lohv, kava hui wohlohvra dawonam. Araravalva ehellenamba no moamba, wo heva os tit evena plalmba. ");
INSERT INTO wrs_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","52","Doa araravalva nominiva evenamba, hevna ombolmba waiengana henga Nasaret kembellam. Avalva maivethanamoa hona moamba owai. Doa Yesusva araravalna moamba hillinvna, aongpa vevnamoa, doa hemba mendekli venamba, undva besalangas wulluhvna. Sesoava hemba beswonamba nonglavna, wo eva owalva hemba beswonam nunglivna, besal. ");
INSERT INTO wrs_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","2","Doa Yon Baptaisva mendekliva venamba, wo himba sahal petharava avna, doa diva Sesoava hemba moamba ishopra vemnana, yeoa kek vethavm kana moamoa, doa indhanam moakus unvra, noinda yimba Sekaraiana ombol lohv. Honamba os phona, nonamba Taiperiasva mendekli kuwul wulluhvna. Hev doara hevna andrarava sihanamba, tahonmba 15pelara vewol vevna nonamba. Wo eva Pontius Pailatva himba kuwul wulluhunvna Yutia provinsra, wo Herotva himba kuwul wulluhunvna Galili provinsra, wo Herotna boasalalva Pilippa himba kuwul wulluhunvna Ituria provinsra eva Trakonitis provinsra, wo Lisaniasva himba kuwul wulluhunvna Apilini provinsra. Wo eva Anasi Kaiapasi himba sembayang andranindna kuwul sambla ahai eluhunvna Yutanindna. Doa nonamba Sesoava Yon Baptaismba moamba ishopra vemnanamba, wo hev hemba keknam poauothovna. ");
INSERT INTO wrs_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Wo Yonmba himba lohmana vevna petharava di Yotanpora, wo hev Sesoamomba ishomana vinvna indhanam. Unvna, yeoa pevna indkoklamoa wuleihivm, ata kava yemba pona poswol vevav, doa Sesoava si os yena indkoklamba hengava ninginvramoa. ");
INSERT INTO wrs_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","5","Os Yonmba Aisaia moashulnindrinina Sesoamomba wohengvna, temba os novol velohv, Indhanariniva sahal pethakoklara av, wo hev indhanamba wunuhuku vinv os, yeoa monamoa vuenghimnu Sesoa mendeklimoa, wo himba besalmonam engpravav. Doa yeoa os vivm, wulpehaloa pethana selelevhoawol vivm, wo temba wulvongavpa ahnam, osoa vuenghivm. Temba moaltowata vrivpa, dioa indund vuenghivm, wo melva diva luhuku vevrava, nooa pethana selelevhoawol vivm. ");
INSERT INTO wrs_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Yimba osva vivrava, doa Sesoava si pimba monakoklariniva lopshawol vevav, wo indhanamba indkumbiva si os nunglutithueivav, no pethanind no pethanind indkumbiva. ");
INSERT INTO wrs_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Doa Yonmba Sesoamomba ishomana vinvna os, wo indkumbiva nonglahalv vrelvohvna, umnina, yeoa ambo kamoa pona poswol veo. Doa Yon unna, owai osva, yimba saipusuhlamsna viv, wo noinda Sesoava si yemba wusprunvav, wo honindava yimba ketvvavmoa. ");
INSERT INTO wrs_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Boasna yeoa pevna indkoklamoa maivithivm, wo Sesoava si mendenglit ovra, besal. Yeoa pevna indkoklamoa maivithivm, wo beswonam vivm, doa indhanamba si os yemba nungeilvrava, doa himba hevna indkoklamba wuleihinata. Wo manam yimba osva pevm uvra, pimba Aprahamtindi, pimba osva lehrava lovahv Sesoana novra. Owai, yeoa pevna indkoklamoa maivithivm, osva yimba Aprahamtindilmba lovahvav. Sesoava osva nengtava, Aprahamtindi besal indhanangas aevulv, himba osva honmba petharini dombrava, Aprahamtindilm vewol veta doara. ");
INSERT INTO wrs_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Ai, hillituk, indhanariniva mand doa wulluhv, wo himba tim hilolm vev. Denwitva nomba beswonamba movolva klihavmoa, doa nomba himba hilovra, suwe tithoavra, doa wohta. ");
INSERT INTO wrs_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","11","Yon Baptaisva os ishomana vinvna, doa indhanamba umnina, es kava vivav, wo Sesoava si os kamba beswonam nongalvav? Doa hev unna, himba nomba yeriniva bayuva samblava wulawoltava, heoa mongooa vrahora, henom ten bayuhui avm. Wo himba nomba innemba iavrava, heoa osoa moang vinvra indhanam. ");
INSERT INTO wrs_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","13","Doa monglava indhanamba Yonindamba eva ambvnamba, temba taeks diva dombolvohvnamba indhanana englariniva, heoa duangm dembreuhvra, wo himba Yonm umnina os, mani hevpa kava vivav, wo osva yimba kamba pona poswol vevra? Yon unna, duangva doara ishunna, taeksva nolharangas lohv, manam yimba indhananamba mindnamba dumbunvra. ");
INSERT INTO wrs_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Doa monglava valgonindva Yonindamba ambvnamba, hem umnina, kava es hevpa vivav? Yon unna, manam yimba indhanamba lomombmomba ishunvav, gekalava unvav, dimba dombolmba. Wo manam yimba pevna diramba sahonamba ningvav, owai. ");
INSERT INTO wrs_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Doa indhanamba Yonmba hillimnivna, hev mindnam ningvna, Yon Baptaisva Kristus provmi, temba Sesoava hemba pusvundthoanamba, osm pim Israelnindm popeng vewolalmba? Pimba hemba doara aevulmanavnata. ");
INSERT INTO wrs_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Doa hev unna, kava Kristusva owai, kava ambo yemba pona poswol velohv, wo heva os mongo indhanariniva sis kamba engprav, hevna andramba velmba. Wo memba kava vevpa ambo seposam, hev si pepthanamba vilprovav sis. Kava mani besalma, an hena andrapetava vevav? Wo himba os ovrava, doa Sesoasongolva yena nihmera siheinvav, wuhholm. Heva os Kristusva himba monglamba indhanamba kinsomb pelhola vinvra, oi suwe tav. ");
INSERT INTO wrs_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Himba doa andranindrinielm lohv, wo hev hevna spet wulluhv, nonam innem kelvalm, doa movolva besalva hev huhul vevra hevna deuvra, sleholva nomba suwera sengavra. Nomba suwemba vuthavavmoa, owai, wohtawovra yunalmba. ");
INSERT INTO wrs_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Doa os Yonmba Sesoamomba besalva mindnam ishunvna indhanamba, osm nengavnangoa henaoa phunvra. ");
INSERT INTO wrs_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","20","Doa Herot kuwulva sahonam vena, doa Yon Baptaisva moakus olohmanavna elsus os, yimba doa sahokla vevna, yimba boasalapevna ongalmba pelvrana Herotiasm, wo eva yenamba monglava indkoklava mindnam lohgav. Doa Herotva hellenamba, hev Yonmba buira wolaihasihana, hev eva honamba osva sahonam venata. ");
INSERT INTO wrs_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","22","Yon Baptaisva indhanamba mindnam poswol vevna pona. Doa hev Yesusmba eva posvena. Wo Yesusva mendah di lohvna, hev sembayang vemnavna Sesoamba, wo mel lohvna ovra sena, doa Sesoasongolva nomini Yesusmba pihamnana nihnahonam, oi leumb. Doa himba Sesoana moalamangm hellevongo vena senaminim, ona, yimba kana ombolnonoa lohv, yemba kava und vev, wo beswonam nonglav. ");
INSERT INTO wrs_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Doa Yesusva hevna andramba sihanamba, Sesoamomba ishomana vinvna indhanamba. Hena osomba mara os lohmanavnama 30pelarami. Indhanamba os umnina, Yosepna ombol, titnam himba umnivna. Memba Yosepna simbehumunilva novol velohv, Nomba Yoseppa himba Helina ombol lohmanavna. ");
INSERT INTO wrs_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Nomba Heliva himba Matatna ombol lohmanavna. Nomba Matatva himba Livaina ombol lohmanavna, nomba Livaiva himba Melkina ombol lohmanavna, nomba Melkiva himba Yanaina ombol lohmanavna, nomba Yanaiva himba Yosepna ombol lohmanavna, ");
INSERT INTO wrs_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","nomba Yoseppa himba Matatiasna ombol lohmanavna, nomba Matatiasva himba Amosna ombol lohmanavna, nomba Amosva himba Nahumna ombol lohmanavna, nomba Nahumba himba Eslina ombol lohmanavna, nomba Esliva himba Nakaina ombol lohmanavna. ");
INSERT INTO wrs_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Nomba Nakaiva himba Matna ombol lohmanavna, nomba Matva himba Matatiasna ombol lohmanavna, nomba Matatiasva himba Semeinna ombol lohmanavna, nomba Semeinva himba Yosekna ombol lohmanavna, nomba Yosekva Yotana ombol lohmanavna, ");
INSERT INTO wrs_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","nomba Yotamba himba Yoananna ombol lohmanavna, nomba Yoananva himba Lesana ombol lohmanavna, nomba Lesamba himba Serupapelna ombol lohmanavna, nomba Serupapelva himba Seltilna ombol lohmanavna, nomba Seltilva himba Nerina ombol lohmanavna, ");
INSERT INTO wrs_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","nomba Neriva himba Melkina ombol lohmanavna, nomba Melkiva himba Ataina ombol lohmanavna, nomba Ataiva himba Kosamna ombol lohmanavna, nomba Kosamba himba Elmatamna ombol lohmanavna, nomba Elmatamba himba Erna ombol lohmanavna. ");
INSERT INTO wrs_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Nomba Erva himba Yosuana ombol lohmanavna, nomba Yosuana himba Elieserna ombol lohmanavna, nomba Elieserva himba Yorimna ombol lohmanavna, nomba Yorimba himba Matatna ombol lohmanavna, nomba Matatva himba Livaina ombol lohmanavna, ");
INSERT INTO wrs_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","nomba Livaiva himba Simeonna ombol lohmanavna, nomba Simeonmba himba Yutana ombol lohmanavna, nomba Yutava himba Yosepna ombol lohmanavna, nomba Yoseppa himba Yonamna ombol lohmanavna, nomba Yonamba himba Eliakimna ombol lohmanavna, ");
INSERT INTO wrs_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","nomba Eliakimba himba Meliana ombol lohmanavna, nomba Meliamba himba Menana ombol lohmanavna, nomba Menamba himba Matatana ombol lohmanavna, nomba Matatamba himba Natanna ombol lohmanavna, nomba Natanva himba Devitna ombol lohmanavna. ");
INSERT INTO wrs_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Nomba Devitva himba Yesina ombol lohmanavna, nomba Yesiva himba Opetna ombol lohmanavna, nomba Opetva himba Boasna ombol lohmanavna, nomba Boasva himba Salmonna ombol lohmanavna, nomba Selamba himba Nasonna ombol lohmanavna, ");
INSERT INTO wrs_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","nomba Nasonva himba Aminatapna ombol lohmanavna, nomba Aminatappa himba Atminna ombol lohmanavna, nomba Atminva himba Alnina ombol lohmanavna, nomba Alniva himba Hesronna ombol lohmanavna, nomba Hesronva himba Peresna ombol lohmanavna, nomba Peresva himba Yutana ombol lohmanavna, ");
INSERT INTO wrs_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","nomba Yutava himba Yakopna ombol lohmanavna, nomba Yakoppa himba Isakna ombol lohmanavna, nomba Isakva himba Aprahamna ombol lohmanavna, nomba Aprahamba himba Terana ombol lohmanavna, nomba Teramba himba Nahorna ombol lohmanavna, ");
INSERT INTO wrs_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","nomba Nahorva himba Serukna ombol lohmanavna. Nomba Serukva himba Leuna ombol lohmanavna, nomba Leuva himba Pelekna ombol lohmanavna, nomba Pelekva himba Eperna ombol lohmanavna, nomba Eperva himba Selana ombol lohmanavna, ");
INSERT INTO wrs_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","nomba Selamba himba Kainanna ombol lohmanavna, nomba Kainanva himba Apaksatna ombol lohmanavna, nomba Apaksatva himba Semna ombol lohmanavna, nomba Semba himba Noana ombol lohmanavna, nomba Noava himba Lamekna ombol lohmanavna, ");
INSERT INTO wrs_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","nomba Lamekva himba Metuselana ombol lohmanavna, nomba Metuselamba himba Enokna ombol lohmanavna, nomba Enokva himba Yaretna ombol lohmanavna, nomba Yaretva himba Mahalalelna ombol lohmanavna, nomba Mahalalelva himba Kenanna ombol lohmanavna, ");
INSERT INTO wrs_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","nomba Kenanva himba Enosna ombol lohmanavna, nomba Enosva himba Setna ombol lohmanavna, nomba Setva himba Atamna ombol lohmanavna, nomba Atamba himba Sesoana ombol lohmanavna. Memba Yosepna simbehumunilva novol velohv. ");
INSERT INTO wrs_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","2","Sesoasongolva doara Yesusm pihamnana, wuhholm, wo noinda Yesusva Yotanporini venamba, doa hev indhanahuiram sahal petharam ganamba, di alohvna, simba 40pelara penngiliha vewol vena, wo Sesoasongolva hemba di waialohvna. Doa heva os diva Setanmba hemba newond ovralohvna, kana nengavnangna veo. Yesusva innemba lohomanavna, nonamba simba 40pelara vewol vena, doa heva os hemba pon venavna os i. ");
INSERT INTO wrs_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Doa Setanmba hon vranamba, Yesusm ishomnana os, yimba tanamolnamba Sesoana ombolva lohtava, yeoa hona honmoa vrarava, wo innelm weihaloh ovro. ");
INSERT INTO wrs_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Wo Yesusva henga ishomnana, owai, moamba doara novol velohv os, Innekrangasva owai indhanamba os wohaevulvavmoa, heva mongona innekra aevulvav Sesoana moarava. ");
INSERT INTO wrs_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","6","Wo henga Setanmba Yesusm waivongana sena, doa os hev hemba lelnam indivungu venana indakonda pethamba, omnana, Sesoava doa doara kamba kuwulalm pusvundthoana indakonda pethanindnam. Wo hemba nomba kava pusvundthoavrava, himba nomba si os kuwulva wulluhunvav, wo huhmohva henangas. Heva os yeoa boasna kamoa mulumbdandna lohvhoamnavra. ");
INSERT INTO wrs_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Yeoa os vevm, doa yimba ata os kuwulva wulluhunvav, wo indakonda pethanindva yemba si os alvra, kuwul. ");
INSERT INTO wrs_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Doa Yesusva omnana, owai, moamba doara novol velohv os, Indhanamba Yawemangas mulumbdandnamba lovahthamnavra. Hengas Sesoanonoa yenamba luhunv, mongova owai. ");
INSERT INTO wrs_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","11","Wo hengava Setanmba Yesusm waingana Yerusalemram, doa waivongana sena wivtram tempelduvram. Wo hev omnana, yimba tanamolnamba Sesoana ombolva olohtava, yeoa petharam vilivhoapiha veo nis ambo. Ata yimba beswonam lohvhoavav, manara, moamba doara novol velohv os, Sesoava hevnamba ovsongolnindmba ishunvav, yemba kolvrilmba. Wo eva mongmomba novol velohv os, ovsongolnindva yemba ata beswonam waiangavav, heva os ata yemba hondava motvavmoa. ");
INSERT INTO wrs_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Doa Yesusva omnana, owai, kava osva vevavmoa, yimba titnam ov, mongmomba novol velohv os, Indhanariniva manam Yawe Sesoamba lehsambaihavav, osm verava, ora kam kolvrav, ora owai. ");
INSERT INTO wrs_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Doa Setanmba vepiana, hemba newond ovravna, os wohwuleihana. Hev nengna, si henga kava Yesusmba lehmanavav. ");
INSERT INTO wrs_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Sesoasongolva Yesusm poauothona, doa himba hevna provinsram gana Galili provinsram. Phonamba, indhanamba moa wulaindahalv vevna, Yesusva doa phoi. ");
INSERT INTO wrs_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Yesusva lohmana vevna di, doa himba sembayangduvram galohvna, indhanam wonishomana vevna, doa indhanamba umnina, besal. ");
INSERT INTO wrs_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Hev lohmana venamba, doa hevinda phona Nasaret kembella, wo hev di sembayangduvra sihana sapturam, os ten hev velohvnam. Wo sembayang vivnamba, doa hev hovra lohvhueinnamba, Sesoana tombaimom boaita unilm. ");
INSERT INTO wrs_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Wo katekis hemba buku vraohnamba pawolalm, nomba moamba temba Aisaia moashulnindrini doara novol vewol venamba. Wo Yesusva bukuva pawol venamba, doa moam mongom pusvundthoana, os boaita unna. ");
INSERT INTO wrs_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","19","Ona, os novol velohv, Sesoasongol doa kaindava sihana, doa kamba pusvundthoana, hevna moam ishunilm indhanamba, nomba temba beswonamba aevulvmoa. Hukumnindmba kava si os ishunvav, yeoa pulvovm beswonam. Wo novtitmungilmba kava si os ishunvav, yimba ata beswonam nov vivav. Sesoava osm kamba wolaihaprana, osm kava si indhanamba wolapho vevav, nomba temba kinmba wulaevulvpa, doa indhanamba indkumbimba kava si os ishunvav, Sesoa mendekliva yemba wavrava vovhueinv, doa hev si os yemba nembaomana vevav hevtindilmba. ");
INSERT INTO wrs_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Yesusva os boaita upieinnamba sembayangnindm nom, doa bukuva henga pawahana, henga katekism vraohe, os avhoana. Doa sembayangnindva nomba hemba novnangas nunglivna. ");
INSERT INTO wrs_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Wo hev hemba henga ishunvna os, memba tombaimomba doara novol velohv, heva os kav hona moamba men wohengv yena novra. Hona moamba kavm lehv. ");
INSERT INTO wrs_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Sembayangnindva nomba hillinamba, una, pai, Yesusva besal, hena moamba besal, doa heva os himba pina owal ambo oluhunv, Yosepna ombol, es hevpa himba nonorava lohv? ");
INSERT INTO wrs_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Yesusva hellenamba, nengna, himba doa kana moamba hilli, heva os himba kamba hevna undnahonam keknam ningminivmoa. Doa Yesus unna, yimba dihi kamba os umniv, yimba mantrialm lohvtava, doa yeoa pevmoa sishona vrevm. Yimba dihi kamba os umniv, mendekliandramba nomba temba yimba Kapaniam kembellava vewol venamba, eva huioa os veota. ");
INSERT INTO wrs_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Doa kava os lohv, oi moashulnindrini Sesoamomba ora hevna owalmba ishunda, doa heva os owalva hemba ovumniv, manam hillivav. ");
INSERT INTO wrs_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Nengam kava ov, Elaitam moashulnindrinim, doara heva himba lohmana vevna. Wo pomba huiva owai hasvovnamoa, tahonmba 3pelara eunumbul vevna, doa owous os phona, wo indhanamba ponda aevulvna. Wo peliva mindnam angu vevna huiva pina pethara, wo hemba wohsihavna. ");
INSERT INTO wrs_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Doa heva os Sesoava Elaitamba wolaihapranamoa homba, osm pelimba pina Israelnindnamba kolvrowolalmba. Owai, hev hemba ungundindamba wolaihangana Saiton kotaram, doa di Elaitava pelim kolvrana Sarepat kembella. Yimba nonora av. ");
INSERT INTO wrs_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Wo eva mongmomba os novol velohv, Elaisa moashulnindrini doara lohvna, wo lombamungilva mindnam angu vevna huiva, doa heva os Elaisava hemba sishona vewol venamoa owai. Hev ungund tendorinim Sirianindrinim sishona vrena, nihilva Naman. Yimba nonora av. ");
INSERT INTO wrs_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","30","Yesusva os ishunnamba sembayangnindm nom, doa himba wusapramana vevna os i. Hev phopianamba, Yesusm kekel vi, doa os lukuh vrulangavna moainallam, pilpiapahalm peilsis, osm honsra vetaka vepera, noinda dahara. Doa heva os owai, Yesusva yuhyuhyuh os phona, sandhalahangana nominiva. ");
INSERT INTO wrs_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Wo Yesusva Galili provinsram ganamba, di dawonam alohvna Kapaniam kembella. Doa hev sapturam sembayangduvra sihanamba, indhanamba numhowol vevna di. ");
INSERT INTO wrs_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Doa sembayangnindva nomba luklukul vithivna, lehra, katekisna moamba kolmalmoa, doa heva os Yesusva aralna moalamangva wulluhv. ");
INSERT INTO wrs_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","34","Doa di sembayangduvra mongo tendorini avna, doara tihsongova sihamnana, doa nengavnangm weihaloh vremnana. Doa himba mindnam ovna, Yesus, yimba Nasaretrini, mani ata yimba kamba vinvav? Kava nonora lohv, yimba Sesoanamini prona, yimba henamba lohvta. Ata yimba kamba indkokla vewol vevavma? ");
INSERT INTO wrs_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Yesusva hellenamba, doa tihsongom nom ishomnana os, yeoa moaoa wuleiho, doa nihmerini pho. Doa tihsongova Yesusmba hellenamba, doa hev tendorinim nom lolahana pethara indhanamosera, doa os wuleihalahangana, himba tendorinimba nomba hethanamoa. ");
INSERT INTO wrs_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Sembayangnindva nomba luklukul vithivna, pai pai, Yesusna moamba nihnamolm lohv, mani kolmalmoma. Owai, himba tihsongomba ishunvpa, eva himba hilliv, doa os wohviv. ");
INSERT INTO wrs_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Wo indhanamba nomba moamba wulaindahalv vevna indakonda kembella, Yesusva os vena. ");
INSERT INTO wrs_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","39","Wo Yesusva sembayangduvriniva venamba, Pitaindam gana. Pitana kolalva uvavulmungilva di dihelvna, nih vuvramnavna mindnam. Indhanamba Yesusmba os umnina, yeoa hemoa sishona vro. Doa Yesusva murapeta hemba lohvhoamnanamba, ambo moa ishomnana, nihvuvra vuvuloa wuleihara. Doa nihvuvravpa os wuleihanata, wo ungevliriniva os phonamba, doa innesowa vinvna. ");
INSERT INTO wrs_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Yesusva os venamba, wo okombava helgang vovhoanamba, doa kembelnindva himba uvavulmungilmba wonambwol vevna Yesusindam. Notongovul notongovul, doa Yesusva hevna engla huhlungu vinvna, doa hemba kanandhowol vevna os. ");
INSERT INTO wrs_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Yesusva os vevna, wo tihsongova gapiavna, nomba temba doarava indhanana nihmerava angu vinvnamba. Hev mindnam uvna, yimba Sesoana ombol, wo os gapiavna. Hev Yesusm liheivna, doa heva os Yesusva hemba ovunna, manam yimba kamba bambara ovrivav. ");
INSERT INTO wrs_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Wo lingil lihanamba, wo Yesusva kembelnindmba sandhalahangana, nominiva indhanahuiram gana. Doa indhanamba hemba aslalvna, wo di nunglivna, nihnapehna umnivna, manam yimba kamba sandhalahangavav, owai, kam wohwonao. ");
INSERT INTO wrs_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Doa Yesusva unna, owai, kava honaminiva galm vev, kava kembelnindm monglam isholm vinv Sesoana nemelmom besalm. Sesoava doa kamba homba wolaihaprana, osm kava indhanam indkumbim das owol vevav, Sesoatindilm kam pelkleihamno. ");
INSERT INTO wrs_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Doa Yesusva os lohmana vevna Yutia provinsra, wo Sesoana nemelmoa besal ishomana vinvna indhanam. ");
INSERT INTO wrs_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Doa Yesusva plombpethalla lohvna Galiliplomb. Indhanamba mindnam kulthoamnavna, yeoa kamoa Sesoamomoa ishunu. ");
INSERT INTO wrs_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Yesus hellenamba, wo hev botsamblamba nongalna di popethalla. Tambko andranindva doara songothuna, hevna pohlalawondam pona poswol vivna. ");
INSERT INTO wrs_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Doa Yesusva mongo no botra Simonina sihanamba, avhoa. Wo hev Simonm omnana, yeoa kamoa waingavm espeta novolpethallam. Doa Simonmba os venamba, doa Yesusva botra avna, indhanamba ishunvna, nomba temba engallava kusovnamba. ");
INSERT INTO wrs_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Ishopieinnamba, doa hev Simonm, monglam andranindm unna, yeoa hona botmoa wulangavm plombhovmonam, dom ten pomba novol livm. Doa dioa yeoa pevna pohlalawondamoa pora piapovo, tambkom dombolm. ");
INSERT INTO wrs_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Wo Simonmba hemba omnana, guru, sinimba kava piapovloh veiva, tambkova kava dumbimoa, veiva, lingil lihai. Heva os ata kava hengava pohlalawondamba piapovvavta, men yimba kamba wohtei. ");
INSERT INTO wrs_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","7","Wo vinamba, doa tambkova wohpilivhoana, pohlalawondamba kokopingu vevna tambkona kinm. Wo Simontatana monglam andranindm englana vinvna, osm yeoa pevna botmoa wulambo hom, wo kana pohlalawondamoa kevrivm, ata homeis powalvm. Doa andranindva nomba ambanamba, kuldumbna Simontatanam, doa tambkova nomba songawulna no botsamblara. Doa botsamblava venamba, pilivhoawole, wo kin vethawolnamba, ona nokovhoawolna plombra. ");
INSERT INTO wrs_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","9","Simonmba nongalnamba, doa hev tit vevna, pai, tambkova esvema, doa hev Yesusna monglara mulumbdandna lohvhoa, omnana, mendekli, mani kava besal indhanarinima, owai, kava indhanakoklarini, yeoa kanaminioa gao. ");
INSERT INTO wrs_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Doa nomba botmerava aevulvnamba, himba eva pemba vivnata. Tendorini samblamba botmera ahavna Yemsi Yoni, himba Sepetina ombolsambla. Himba Simonna mongawa andranind elohvna, wo hev tit evevna, mindnam enengvna. Doa Yesusva Simonmba omnana os, pepehtovoa wuleiho. Si yimba katindilm avav, wo kai elohmana evevra. Doa yimba os si tambkomba silelvavmoa owai, yimba indhanamba silelvav, katindilm lovahalm. ");
INSERT INTO wrs_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Wo andranindva nomba himba hevna botsamblamba henga aiwo ambna popethallamba, wo hev pethara peivna, doa hev hevna andramba wuleihinamba, os Yesusm patvmonana, hena moam hellelm. ");
INSERT INTO wrs_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Wo Yesusva mongona kembella alohvna, mongo tendorini prona, lombamba doara hemba wohvongana. Doa hev Yesusm nonglanamba, mulumbdandna lohvhoamna, novlomosva pethara lothona, doa hev omnana, mendekli, yeoa kamoa sishona vro, ata ye vevmi, owaimi. ");
INSERT INTO wrs_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Doa Yesusva hevna englana tuhmanana, ona, yena nihtovoa lesvhoara, doa nungi lelnam hena nihtovpa wohlesvhoana. ");
INSERT INTO wrs_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Wo Yesusva hemba ovomnana os, manam yimba indhanamba moakus unvav, osva, Yesusva os vei, owai. Yeoa sembayang andranindinam gavm, osm himba yena nihtovm nonglavav, ora besal. Doa os yeoa hemoa vraho mana vemaoa, osm Sesoam sembayang venavra. Moses doara os novol vewol venata, yeoa engvm. Doa osva indhanamba indkumbiva si yemba nunglivav, nihtovpa besal. ");
INSERT INTO wrs_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Doa heva os owai, indhanamba himba moamba nomba isholvohmana vevna di di di, wo noinda indhanamba mindnam kusolvohvna, osm Yesusna moam hellelm. Doa Yesusva lohmana vevna, himba hemba os umnivna, guru, yeoa kamoa sishona vewol veo. ");
INSERT INTO wrs_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Doa heva os Yesusva elsus indhanahuiram galohvna, Sesoam sembayang vemnalm. ");
INSERT INTO wrs_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Wo Yesusva indhanamba wonavna deuvra, os wonishomana vevna, doa monglava Varisinindva, katekisva ambna, nomba temba Mosesna doaraminimomba wohengivnamba. Himba doara ambna Galili provinsrini eva Yutia provinsrini, wo eva Yerusalem kotarini. Doa Sesoa mendekliva himba Yesusmba nonamba poauothona, osm ora uvavulmungilm wolapho velm. ");
INSERT INTO wrs_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Wo Yesusva mendah ishunvna hemba, doa tendomba monglava ambna, uvavulmungilm wulambna towara. Nomba tendoriniva himba ambo lingas vevna, englamonglava shuawol vevnamoa. ");
INSERT INTO wrs_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Doa ona wulsaivol vena, heva os owai, doara indhanamba vuhemba kelvhueina, doa noinda wivtram wulvolna hemba, wo vevla vinamba, noshara piapovvna enesra towanahonam. Vinamba, Yesus di avnam indhanana musera. ");
INSERT INTO wrs_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Doa Yesusva nongalnamba, nengna os, kamba mindnam ningminiv hevna undnahonam. Doa Yesusva uvavulmungilm omnana os, seh, men kava doa yemba kilumbshuav, pevpa temba sahonamba vevnamba. ");
INSERT INTO wrs_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Wo nomba Varisinindva eva katekisva, temba mongawulmba aevulvnamba, himba hillivna, una, es hevpa Yesusva osva ov, Sesoava hevho indhanamba kilumbshuawol vev. Yesusva osva Sesoamba opipahav. ");
INSERT INTO wrs_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Wo Yesusva hillinvna, wo hev lihawol vinna hena nengavnangmba, wo hev unna, kava tanamolnam ishomni uvavulmungilmba, wo manam yimba kamba sahonamba ningminivav. ");
INSERT INTO wrs_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","24","Kava ombamba ishomnimoa, kava yemba kilumbshuai, owai, kava tanam omni. Heva os anmund ata liheivav, osva tanamolnam? Noinda ata kava hengava omnavav, pho, wo himba ata phorava, doa os ata yimba liheivav, osm kana moamba tanamolnam. Kava arana ombol lohv, wo Sesoa kamba doara moamba mendekli dembrahona, osm kava indhanamba kilumbshuawol vevra hevna sahaposworiniva. Doa Yesusva os uvavulmungilmba nomba henga omnana os, yeoa phovm, pevna vuhesaloa guao deuvram. ");
INSERT INTO wrs_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Doa tendoriniva nomba nungi lelnam phonamba, hevna vuhesalva guana deuvram indhanana novra. Os hev sangalna ongovna, Sesoam kava okolav. ");
INSERT INTO wrs_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Wo indhanamba nunglinamba, doa os pemba vivna i, una, snamba pimba nunglinamoa doarava. Pioa okolalohra Sesoamoa. ");
INSERT INTO wrs_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Yesusva nominiva venamba, monam gavna, doa hev tendorinim nonglana, men av, nihilva Livai. Himba hevna kantorra andra vawovna, indhanana taeks diva domboluhunvna. Yesusva hemba yumna velanamba, omnana, yeoa katindilmoa petheinu. ");
INSERT INTO wrs_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Wo Livaiva himba hevna andramba wohwuleihanamba, os Yesustindimongo lovahmana vevna. ");
INSERT INTO wrs_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Himba indk vethavna, wo sismba hevpa innemba mindnam meilna vevna, ona, pimba ata Yesusmba waihlavav. Wo innemba nomba hlavnamba, hevna mongawa andranindva eksuwulpravna, hlalm, wo indhanamba mindnam esvema avna. ");
INSERT INTO wrs_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Wo Varisinindva eva katekis, himba Varisinindm patvunvna, himba nungeilnamba, doa hev monglam Yesusnindm nom unvna, sahonam yimba viv, yimba taeksnindmongo kusov, wo yimba innemba wonhlav indhanamba monglamba, es hevpa?, honamba sembayangna wevsava beswonamba himba engivmoa. ");
INSERT INTO wrs_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Wo Yesusva hevpa helwolvna hemba, ona, os ishuv, wo hev olhmona olhinnam. Unna, indhanamba nomba besal indhanamba, himba nomba mantri indamba angavmoa, owai. Heva os hind noi uvavulnindangas, himba nomba mantrimba aslalvra, osm kam sishona vewol veo. ");
INSERT INTO wrs_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Kava hona petharamba pronamoa, osm indhanamba lothopiawol vevra, unvra, yimba sahonam viv, nomba temba osva ningvpa, osva kava indhana windel. Wo heva os himba nomba osva ningvrava, kava indhanakokla, hemba nomba kava os isholm vinv, yeoa pevna indkoklamoa maivithivm, doa Sesoatindilm saivo. ");
INSERT INTO wrs_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Doa indhanamba Yesusm osihminivna os, Yon Baptaistindiva eva Varisinindva, himba elsus innemba lovahalvohv, wo os himba Sesoamba sembayang velvohmanav. Doa heva os yetindiva owai, himba innemba lovahalvohvmoa, himba hlangas viv undnahonam. Memba sahoklal. ");
INSERT INTO wrs_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Wo Yesusva henga unna, katindiva indk vithiv. Es yimba ningv, indhanamba ongai yisva hlavrava, wo indk vithivra, ongal tlal evrowoli hevm, wo es hevpa himba innemba lovahavav, owai, hlangas vevav. Tlalva mendahva lohvrava, doa hlangas vevav. ");
INSERT INTO wrs_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Wo heva os sismba ungundva tendorinimba waiangavrava, doa owalva hlavavmoa innemba, owai, himba lovahavav. ");
INSERT INTO wrs_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Wo Yesusva mendah hemba olhmonamba unvna os, kana moamba nemelmoa, wo mushhueinvmoa Varisinamba katekisnamba doaraminimomba. Memba osm, mongo indhanarini bayuva sambla hevnamba selvo aiwo avra, mongova nemel, wo mongova bolavol. Wo hev nemelmba kovhoavrava, doa kuendwol vevra bolavolmba nona. Memba besalma? Owai, himba osva nemelmba indkokla vrevna, wo kololva bolavkalal dihelv mendah, sahoklal. ");
INSERT INTO wrs_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","38","Wo eva ungevliriniva kolakolarava yesva kovrava, doa yesva vetvaral vevra kolashara. Newulva besalva kolabesalla kovra. ");
INSERT INTO wrs_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Monglava indhanamba himba yestalangas doara hlalvohvna, wo mongo indhanariniva hemba ora pepavna wonnevra, wo himba bes hlarava, doa uvav os, yestalva besal, pepavnamba sahoklal. ");
INSERT INTO wrs_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Wo sapturamba indhanamba vah iaevluwul vevna, wo Yesustindiva himba monam angavnamba, doa osohovmonam angavna os. Wo hev witmov englana pueitvinamba, wo englana sanbas vewol vivna, os kelva tongovoral vevna, doa nihilva hlavna. Ponmba vinvnamba, noinda himba hlavna. ");
INSERT INTO wrs_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Wo Varisinindva monglava di lovahvna, wo hev hemba nungeilnamba, unna, es hevpa yimba osva viv sapturamba? Doaraminimomba os novol velohv, manam yimba nonamba vivav osva. ");
INSERT INTO wrs_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","4","Doa Yesus unna, owai, katindiva lehra viv. Tanam doaraminimomba novol velohv, heva os owai, yimba pevpa plalmomba beswonamba velokusa vivmoa. Yimba nonora, Devitna simbehumunillinina moamba os novol velohv, Devitmba ponmba venavnamba, hev sembayangduvrava sihanamba, doa roti nena, nomba temba Sesoana novrava dihelmanavnamba. Rotiva nomba os novol velohv, ombandhanamba manam hlavav, sembayang andranindangas hlavra. Doa heva os Devitva hevnam wonnena. Yimba tit vivma plalmba? ");
INSERT INTO wrs_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Kava arana ombol lohv, kava eva indhanamba wohtlohv, sapturamba vah iaevul okombanamba manam manam velmba nonamba. ");
INSERT INTO wrs_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Wo mongona sapturamba Yesusva mongo sembayangduvra sihanamba, avhoa, os hev indhanamba moam ishomana vinvna, Sesoana nemelmom besalm. Doa mongova tendoriniva di avna, hena nihananglava doara englabong venana. ");
INSERT INTO wrs_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Wo Varisinindva eva katekisva himba di mongawulm sembayangduvmera sembayang vivna, wo himba Yesusmba naengho vruwul vevna, ata englabong mungilmba sishona vrevavmi, owaimi? Himba osva vetava, ata pimba hemba ishumnivav os, yimba indkokla vindai, yimba memba osva veiva sapturamba. ");
INSERT INTO wrs_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Yesusva lihawol vinna hena nengavnangmba, doa heva os hev englabong mungilmba omnana, proo, hui hovra lohvhoao, doa himba os lohvhoana Yesusna novra. ");
INSERT INTO wrs_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Yesusva os unna Varisinindmba, es yimba ningv, Sesoana moamba es novol velohv? Sapturamba kava sishona vrevavma hona indhanarinimba? Kava lehrava beswonam vevravmi, osm heoa beswonam ara, ora kava nombolvhoara, hemba dahavav? Wou ishutuk. ");
INSERT INTO wrs_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Yesusva hemba nongaluku vevna novnangas, doa hev englabong mungilmba os omnana, yeoa pevna englaoa shuavm. Doa os himba shuanamba, wo englava hevnamba beswonam lohmanana. ");
INSERT INTO wrs_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Doa Varisinindva nomba os musk vivna mindnam, una, es hevpa Yesusva osva vei detiva, doa hevm ishuvna, es pimba Yesusmba si vinivav? ");
INSERT INTO wrs_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","13","Wo henga Yesusva gana, sembayang venalm Sesoam aralm. Hev indhanahuiram gana oloram, doa os sembayang venamba, okombava vohavnamba, venamba, lingil lihana, hev sembayangangas vawovna. Doa sismba himba hevna aonghal mahalnindmba nembaomana venamba, doa monglamba nominiva hev kikih vewol vena, ona, yimba si kana moalamangnindalmba lovahvav. Wo 12pelarangas hev kikih vewol vena os. ");
INSERT INTO wrs_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","16","Seilva hev Simonm pusvundthoana, weihaloh vrenamba, Pitam awo, ona, yimba Pita lohv. Doa Endrum pusvundthoana, nom Simonna boasalal. Doa Yemsim Yonim pusvundthoawol vena. Doa honam pusvund vena, Pilipm, Bartolomium, Matium, Tomasm, Yemsm, nomba Alviusna ombol lohvna. Doa henga mongom Simonm pusvundthoana, nomba Simonmba indhanamba os umnivna Selot, himba duangm Romnindm engalpingalm vevna Yutanindna petharinim. Doa hev Yutasm pusvundthoana, nomba mongo Yemsna ombol, doa hev henga mongom Yutasm pusvundthoana nomba Iskariotrini, temba sismba Yesusmba ungundna englisrava desvhoanamba. ");
INSERT INTO wrs_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","18","Wo Yesusva hevnamba aonghal mahalnindmba nominiva wonpronamba oloriniva pundram vavallam, di lohvhoa. Doa indhanamba esvema hemba di wonkusovna, vei Yesustindi mongla eva kembelnind. Nomba indhanamba doara kusovna, osm Yesusna moam hellelm. Una, himba ata pina owalmba sishona vewol vevav, memba uvavulmungilva aevulvpa. Nomba oklanindva himba doara ambwol vena Yutia provinsrini, Yerusalemrini, eva ungundna kotarini, Tair kota eva Saiton kota. Doa Yesusva osangas venamba, uvavulmungilmba nomba sishona vewol vena, wo eva hev sishona vewol venata, indhanamba nomba temba doarava tihsongova nihmerava sihangu vinnamba hemba. Hev sishona vewol venamba, doa tihsongova nomba gapiana. ");
INSERT INTO wrs_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Yesusva eusmongal lohvna, os sishona vewol vevna, doa indakonda hemba kanandhowol vena, wo noinda indhanamba Yesusm kulthoamnana, osm ora hena nihmba tuhvra, kamoa eva osta lesvhoawol verata. ");
INSERT INTO wrs_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Yesusva hevna aonghal mahalnindm nongalnamba, hev unna, yimba ambo sena posra ahalohv owousra, doa heva os yeoa indk vithivm, manara, yimba Sesoatindilm lovahv. ");
INSERT INTO wrs_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Henga unna, yemba ponmba vinv, doa heva os si yemba pilivhoawol vevra. Yimba daipotava wena uwuv, doa heva os si yimba los uvav. ");
INSERT INTO wrs_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Si indhanamba yemba musk vinvra, Yesustindi, doa hev si os yemba wonishuvavmoa, owai, hev ambo yemba moakoklava ishunvav. Hev yenamba nihilva si os pingipuv ovunvav, sahoklal, doa heva os manam yimba duus vivav noindava, owai, indk vithu. ");
INSERT INTO wrs_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Yeoa os plasra avm nonamoa undwonam, manara, Sesoava yemba mana vemamba mendekliva doa kokolma vinna hevindava. Wo indhanamba nomba temba yemba musk vinvnamba, himba osangas vivna, temba hevnamba simbehumunmba musk vinvnamba Sesoana doaramini moashulnindmba. ");
INSERT INTO wrs_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Yeoa indk vithu, doa heva os dinindva nomba si hemba kinsomb pelhola vinvav, wo henamba wenoppa si pihangu vinvav. Manara, hevna wohmba memba himba daipotava huhul velvohvpa, si hengava himba dumbvavmoa owai. Manimani notongorava hemba daipotava indva lothoprinv, owai, si hengava himba dumbvavmoa wohva. ");
INSERT INTO wrs_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Nomba indhanamba temba daipotava wohva mindnamba iaevluwul vevpa, hemba osva indva lothoprinv, kamba pilivhoawol vev, doa heva os si sismba himba ponda uwuvav. Wo nomba indhanamba, temba daipotava osva ishuvpa, kava lehra, doa heva os si sismba henamba wenoppa pihangu vinvav wenahonam. ");
INSERT INTO wrs_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Yemba indhanamba wi vewol ovitava, yeoa pepeh vivm, manara noinda pina simbehumunmba hona wevsana vinvna moashulnind daspolmba. ");
INSERT INTO wrs_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","28","Doa yeoa hillivm, kek vithivm, wo ungundva yemba mana vemamba vinitava, yeoa hemoa und vewol vivm, heva os manam yimba esesmba vinivav. Wo indhanamba yemba moakoklava ishuntava, yeoa hemoa moamba besal esesmba ishunvra os, Sesoava yemba nesmos vrowol vera. Wo indhanamba yemba pulnamba wehla vevrava, yeoa hemoa beswonam vewol vivm, wo Sesoam osihminu os, yeoa hemoa nesmos vewol vera. ");
INSERT INTO wrs_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Wo indhanariniva yemba sangvalva helvetava, doa heva os manam yimba hevmba hengava helvevav, owai, ambo nethamno mongnahalm. Wo indhanariniva yena bayupanasva ora moan vrara, wo hemba osoa moan vrahora, manam hemba ovomnavav, owai, ambo hemba dembrahora talananahonam. ");
INSERT INTO wrs_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Wo indhanariniva yemba mana vemamba osahmanavrava, wo hemba os vrahora, wo indhanariniva yena wohmba hevna englana vrarava, wo manam yimba hemba okusv vevav, kanaoa kavm vraho, owai. ");
INSERT INTO wrs_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Yeoa ningvm besalmonam, wo indhanaoa kamoa osangas vinivrata eva, wo hona wevsangas yeoa vinvmta hemoa. ");
INSERT INTO wrs_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","Wo indhanamba yemba und vewol vivrava, wo yimba hemba hengava undva vewol vivrava esesmba, wo an si osva yemba wivewol ovovav. Manara, puehalnindva himba osangas viv, himba undva vewol viv indhanamba, nomba temba hemba undva vewol vivpa. ");
INSERT INTO wrs_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Wo indhanamba yemba nesmos vewol vivrava, wo yimba hemba hengava nesmos vewol vivrava esesmba, wo an si osva yemba wivewol ovovav. Manara, puehalnindva himba osangas viv, himba nesmos vewol viv indhanamba, nomba temba hemba undva vewol vivpa. ");
INSERT INTO wrs_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Wo yimba owapevmba pevnamba os ninginvra hevmba, ata kamba mana vemamba esesmba dembrahunvav, wo osva yimba hemba mana vemamba dembrahunvra. Wo an si osva yemba wivewol ovovav. Manara, puehalnindva himba osangas viv, himba mana vemamba dembrahunv owalmba, temba hemba mana vemamba esesmba dembrahunvpa. ");
INSERT INTO wrs_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Manam yimba osva vivav, owai, yeoa pevna ungundmoa und vewol vivm, wo nesmos vewol vivm, wo mana vemamba dembrahunvra. Wo manam yimba osva ninginvav, heoa kamoa henga dembrahunda, owai. Sesoava sena av, wo hev yemba si os mana vemamba mindnamba huhul vewol vinvav. Hev si os yemba beswonam nongalvav, kana ombol, kana wevsam engiv. Manara, Sesoana wevsava os prov, hev nesmosal av, wo hev wavrava vovhoawol veluhunv indhanakoklamba, nomba temba himba Sesoamba okolamba owai vivpa. ");
INSERT INTO wrs_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Wo yeoa indhanamoa wavra vovhueinvm, wo indkoklamoa henamoa maivithivm, noinda osva viu, Sesoa pina aral osangas vinv pimba. ");
INSERT INTO wrs_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","Wo manam yimba indhanana doaramini pokokva vileivrivav, wo Sesoava si eva osva yenamba velavravavmoa pokokva. Wo manam yimba indhanamba osva ishunvav, yemba doa wohplel vei pevna indkoklarava. Wo eva Sesoava si yemba ishunvavmoa, osva yemba doa wohplel vei. Owai, yeoa indhananaoa indkoklamoa maivithivm, wo Sesoava si eva os yenamba maivethinvavta. ");
INSERT INTO wrs_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Wo yeoa indhanamoa moang vinvm mana vemaoa, nomba indhanamba temba mana vemahuiva aevulvpa, doa Sesoava si os yemba henga esesmba dembrahunvav. Wo mani espetama, owai, yemba si wondanahonam dembrahunvav esvema, oi tendorini nahov valawora peindindva vrev, osm mindnam pilivhoara. Wo yena valawova ora mendekli ora eusil, temba yimba indhanamba songowol vinvpa, doa Sesoava si os yena wevsam engvav. ");
INSERT INTO wrs_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Yesusva mendah hevna aonghal mahalnindm isholuhunvna, hev olhmona ona, indhanariniva novtitmungilva avrava, wo mongova provrava, temba eva novtitmungilta, ishomnavra os, ata yemba kava beswonam waingavav. Heva os owai, ata hemba mongawulm yunam epelepewolvav potandara. ");
INSERT INTO wrs_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Wo indhanariniva avrava, hevna guruna moamba hellellohvrava, wo manam himba osva nengmanavav, kava kavna gurum kuvhoav. Owai, heoa hevna guruna keusingi lohra, osm moam kek vethavra. Wo sism si nengavnangva pilivhoamnavav, doa si os hevpa gurualm lohvav. Wo indhanamba monglamba si os hena moamba hillimnivav, kek vithi, yimba doa nonora lohv. ");
INSERT INTO wrs_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","Wo manam yimba osva vivav, oi indhanarini hevna owalmba ishomni os, singpongpetava yena novrava doa pathalohv, doa heva os hevpa tit vev hevnamba, osva tipopov kavindava eva pathalohvta. ");
INSERT INTO wrs_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Manam yimba pevna owalmba osva ishomnavav, mana ema eusil ka ata vramnavav yena novrinisna. Yimba gekala ov, boasna yeoa vrao tipopovoa pevna novrinioa. Doa osva ata yimba henga beswonamba nonglavav, mana ema eusil vramnavav owapevna novriniva. ");
INSERT INTO wrs_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","Yesusva mendah olhmonamba isholuhunvna hevna aonghal mahalnindm. Timba besalva lohvrava, doa movolva sahoklalva endvavmoa, owai, besalangas endvra. Wo eva mongova timba merava lelao vethatava, osva movolva besalva endvramoa owai. ");
INSERT INTO wrs_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Indhanana wevsava os prov, himba timuvm naengho vriv, doa os sevriv, memba timba besal, pueuvpa, memba timba sahoklal, umba. Pueuvpa endwol vevmoa umrava, wo auva endwol vevmoa psaorava. ");
INSERT INTO wrs_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Doa indhanariniva besalva lohv, hena nengavnangva besal lohmanav, doa osva himba beswonam velohv andrava. Wo heva os mongo indhanarini sahoklalva lohv, hena nengavnangva sahoklal lohmanav, doa osva himba sahonam velohv andrava. Manara, mindemba yenamba kolmal dombv undna. ");
INSERT INTO wrs_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","48","Yimba indhanamba kamba elsus alv, mendekli maimba, doa heva os owai, yimba kana moamba kek vithivmoa, wo engivmoa. Himba nomba kana moamba kek vithivrava, wo engivrava, himba nomba besal aevulvav. Himba snal lovahv, oi indhanarini temba nengna, kava deuvm velm vev. Doa os himba petha tovawol vevna mindnam, doa milukulva besal di dembhapiha vungavna. Doa sismba pueumbva mendekli pronamba, ona deuvmba viluwulkohana, doa heva os owai, deuvpa keknam wohlohna, wo dalohnamoa, doa pueumbva gapiana. ");
INSERT INTO wrs_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Wo himba nomba kana moamba hillivrava, wo kek vithivmoa, himba nomba os lovahv, oi indhanarini temba nengna, kava deuvm velm vev. Doa heva os himba beswonamba vevnamoa, himba seposam ambo sena pelkleihana. Doa sismba pueumbva pronamba, deuvmba os tupulis wulkohamnana. ");
INSERT INTO wrs_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Doa Yesusva ishopieinnamba, henga Kapaniam kembellam gana. ");
INSERT INTO wrs_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Doa mongova duangva di avna, himba Yutanindna meisnindrini, himba valgonindna kuwul wulluhunvna. Wo hena andranindriniva eva lohvnata, uvavul mendekli hemba venavna, wo himba indnakra vevna. Duangva hevna andranindrinimba mindnam und vevnata. ");
INSERT INTO wrs_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Wo duangva doara hellena moamba, Yesusva henga proi. Doa hevpa ganamoa, himba monglam indhanam wolanga vena, Yutanindm mundilm wolanga vena, unna, yeoa angarava, Yesusm ishumnu os, heoa prora, kana andranindrinim wolaihaphora. ");
INSERT INTO wrs_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","5","Doa Yutanindva nomba anganamba, Yesusm ishumnina undnahonam, yeoa garava, duangna andranindrinimba sishona vrera. Duangva nomba besal lohv, himba pimba Yutanindmba und vewol vev, hevpa hevna dinamba kamba sembayangduvpa dembrinna. Yeoa hemoa beswonam vevravm. ");
INSERT INTO wrs_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","7","Doa Yesusva hellenamba, os engalguana. Doa hev wonganamba, duangna deuvra murapeta pulvovna, doa hev indhanamba monara anongla vinna, nomba indhanamba himba duangna sehel ambvna. Doa himba Yesusm duangna moamba ishumnina os, mendekli, mani kava besal indhanarinima, osm yimba kana deuvrava sihavav. Wo kava lou vevna, osm kav yem hom omnakavra. Yeoa hui monara lohvm, doa moa ambo ishovm, doa os ata kana andranindrinimba kanandhavav deuvrava. ");
INSERT INTO wrs_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Kava ambo valgonindrini lohv, wo kana kuwulva lohv. Doa kava hena moamba hellellohv, doa kava osangas velohv. Wo kava valgonindm monglam isholuhunv, doa himba kana moamba hellelvohv. Kava mongomba ishomnavrava os, proo, doa himba os provra. Wo kava kavna andranindrinimba ishomnavrava os, yeoa os vevm, doa himba os vevra. Kana moamba keknam lohv valgonindindava, doa yena moamba keknamangas lohv. Yeoa ishovm, ata kana andranindrinimba kanandhavav os. ");
INSERT INTO wrs_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Doa Yesusva no moamba hellenamba valgonindna kuwulnamba, wo hev ona, pai, moamba besal. Wo hev indhanamba ishunna, nomba temba hemba engambvnamba, os ona, hona duangva himba ungundrini lohv, heva os himba doa kamba hevna undnahonam lohvhoamnav. Yimba Israelnindva yimba kamba pevna undnahonamba lovahmanavmoa, osva himba memba. ");
INSERT INTO wrs_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Doa nomba indhanamba henga angana, temba moamba Yesusmba monarava ishumninamba. Anganamba, henga duanginda pulvona, doa di himba duangna andranindrinimba nunglina, pai, doa kanandhai. ");
INSERT INTO wrs_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Doa Yesusva nominiva ganamba mongona kembellam Nain kembellam. Hev hevtindim wongana, wo ombandhanamba mindnam sis patvmonavna. ");
INSERT INTO wrs_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Doa Yesusva no kembella murapeta provna, wo kembelnindva mindm wulambvna towara singvelm. Nomba indhanarinimba doara dahanamba, wo avalva mendah amnavna, himba peli avna, wo ombolva mongova owai henamba. Avalva towara sis engpravna wenahonam, wo owalva mindnam hemba waiambvna sis wenahonam. ");
INSERT INTO wrs_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Doa Yesus mendekliva nongalnamba, wowora viv, doa hev mindilna avalm wavra vovhoamnavna, wo hemba omnana, wuleiho wemoa. ");
INSERT INTO wrs_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Doa hev murapeta ganamba, towamba englana tuhna, wo indhanamba dawonam lovahvna, nomba temba wulvahvnamba, doa Yesusva nom mindm omnana os, yeoa phovm. ");
INSERT INTO wrs_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Doa no indhanarini-mindva henga beswonam phonamba, avhoa, temba nomba doarava wohdahanamba, doa hev moa owalm ishunvna. Doa Yesusva hena avalm os ishomnana, ombpovpa yenamba men av. ");
INSERT INTO wrs_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Wo indhanamba nomba pem vivna, doa hev Sesoamba okulivna os, tanam Yesusva Sesoana moashulnindrini lohv, Sesoava hemba homba wolaihaprinna, pim sishona vewolalm. ");
INSERT INTO wrs_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Doa indhanamba nomba moamba wulaindahalv vevna indakonda kembella di Yutia provinsra. ");
INSERT INTO wrs_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Yon Baptaisva ona ana, doa hevna aonghal mahalnindva moamba iambmanana, Yesusva os andra vevna, os os os. Mendekliandrava os i. ");
INSERT INTO wrs_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","Doa Yon Baptaisva hellenamba, wo hevtindirini samblam wolanga vena, ona, yeoa engavm, Yesus mendeklim os ohosahmano, es hevpa yimba Kristusnonoa lohvma? Nomba indhanariniva temba osva umnivpa, si provav. Doa Yesusna moaoa kam henga wulepramno. Yesusva Kristusnonoava owaingava, pimba henga dawonam si aevulmanavav Kristusnonoamba. ");
INSERT INTO wrs_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Doa indhanarini samblava nomba Yesusinda ephona, doa hev Yesusmba ihishomnana Yonna moamba. Ohona, yimba owaingava, kava dawonam osva aevulmanavav. ");
INSERT INTO wrs_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Doa nonamangas Yesusva indhanamba mindnam sishona vewol vevna, nomba indhanamba temba uvavulmungil shavnam, nihsesoava vinvnam. Wo Yesusva eva tihsongomba engvapianginna indhanana nihmeriniva. Wo hev novtitmungilm sishona vewol vevna, wo himba henga nov vivna. ");
INSERT INTO wrs_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Doa Yesusva indhanarini samblamba ishunna, nomba temba Yon Baptaisna moamba wulepramnanamba, unna, yeoa henga engavm, wo Yon Baptaismoa ihishomno, memba yimba enonglavpa honamba, wo memba yimba ehellevpa honamba. Os ihishomno, novtitmungilva doa henga beswonam novviv. Monglamungilva doa henga beswonam lovahmana vev. Lombamungilva doa henga beswonam aevv. Aongmimungilva doa henga beswonam aongviv. Indhanamindva doa henga beswonam aevulv. Doa indhanamba nomba temba sahonamba aevulvpa, Yesusva hevmba nemelmomba besal isholuhunv. Yeoa Yon Baptaismoa osoa ihishomno. ");
INSERT INTO wrs_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Doa indhanamba nomba temba kamba hevna undnahonamba lovahthamnavpa kikihhuiva, heoa nooa indk vithira. ");
INSERT INTO wrs_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","25","Doa nomba indhanarini samblava henga enganamba, temba Yon Baptaisna moamba wulepramnanamba Yesusmba, doa Yesusva indhanamba os ishunna, Yon Baptaisva snal lohv, es yimba ningv? Yimba seilva doara hemba nonglalmba anganamba sahal petharam, himba manalm lohvna? Himba ambo wandmsna lohvnama, vuvira dalohvnama? Owai, yimba hemba os nunglinama oi, tendoriniva talana bayu besalangas ilohv? Owai, snamba indhanamba himba kuwulna deuvrangas aevluwul vev, wo himba innemba besalangas hlawol vev. ");
INSERT INTO wrs_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Doa yimba Yon Baptaismba os nunglinama oi, Sesoana moashulnindrini? A a tanam himba moashulnindrinielm lohvna, wo hev kuvhoawol vevna moashulnindmba indkumbimba. ");
INSERT INTO wrs_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Himba mendekli lohvna, manara, Sesoana doaramini tombaimomba Yonmba ishomnav, wo os novol velohv, Sesoava Kristusmba os ishomnav, si kava kavna moashulnindrinim wolaihangavav, wo himba yemba mi deisvungavav, yena monam vuenghamnavav. ");
INSERT INTO wrs_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Yon Baptaisva mendekli lohvnata, wo hena moamba kuvhoawol vinna indakonda moamba, nomba temba Sesoana moashulnindva doara ishowol vivnamba. Doa heva os katindiva himba Sesoana nemelmomba ilvahv, wo noinda himba kuvhueiv Yon Baptaismba. Himba nomba katindiriniva eva eusilva lohtava, wo heva os hena moamba mendekli, kuvhoawol vevra. ");
INSERT INTO wrs_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Doa nomba indhanamba temba Yesusna moamba hillivnamba, himba umnina, lehra ov, Sesoana wevsa besal. Himba noinda osva uvna, hemba doarava Yon Baptaisva pona poswol vevna. Wo taeksnindva eva os umnivnata, temba sembayang wevsava beswonamba engimba owai vivna. ");
INSERT INTO wrs_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Doa heva os monglava indhanamba himba Yon Baptaismba ovumnina, manam himba pimba pona poswol vevav. Varisinind eva katekis himba osva vivna, wo osva himba meis haravhueivna Sesoana besalmomba. ");
INSERT INTO wrs_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Doa Yesusva nomba indhanamba mendah ishomana vinvna os, yimba hona pethanindva lovahv, wo kava yemba olhmona olhalm vinv, osm ora yimba pevpa osva lovahv. Yimba keknamba amnavmoa kana moamba. ");
INSERT INTO wrs_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Yimba os lovahv, oi otol mueri vewuvmona vev, araravalva kuksa vev. Himba hevm os dasalm ishunv, kava yemba sangal sevrinvna, wo heva os owai, yimba indk vithivnamoa. Doa os kava henga mindsang vivna, wo heva os owai, yenamba wenoppa pihangu vinvnamoa. ");
INSERT INTO wrs_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Yon Baptaisva himba seilva doara yeindamba phunnamba, doa heva os himba innemba mendeklimba nelohvnamoa wainnamba, doa yimba hemba umnina, daisongomungilna amana ovov. ");
INSERT INTO wrs_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","35","Wo sismba kav yeindamba phunna, wo kav innemba besal nelohvna, doa yimba kamba gekala umniv, sahoklal, innemangas mindnamba nengv. Himba wain-mengna, doa hev puehalnindm wonav, nomba temba sembayang wevsava beswonamba engivmoa. Yimba pevna nengavnangva lesvhoawol vivmoa beswonamba. Doa heva os monglava indhanamba himba nengavnangva besal ilvahv, wo hev beswonam moamba lesvhoawol viv, vei besal eva sahoklal, doa hev os isholvohv, Sesoana moamba besal. ");
INSERT INTO wrs_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Yesusva hevna aonghal mahalnindmba ishomana vinvna, doa mongo indhanarini di avna, nihilva Simon, himba Varisinindrini doara lohvna, sembayangmomba doara keknamangas ilohvna. Hev Yesusmba os ishomnana, ata yemba kava wainevav, wo Yesusva engganamba, di wonavna Simonna deuvra. ");
INSERT INTO wrs_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Doa no kembella mongo ungevlirini avna, himba ungevlirinikokla avna. Himba moam hellena, Yesusva Simoninda av, doa hev engganamba, wel sanda pethana botelnahonam, diva os lohvna i. ");
INSERT INTO wrs_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Hev no deuvrava sihanamba, wo Yesusinda murapeta avhoa, doa hev hevna wevsakoklamba nengvnamba, wo vevna, wo henamba wenoppa Yesusna monglasra pihamnavna. Doa ungevliriniva hevna tana Yesusna monglamba poswol vevna hevna wenopmba, sanbas vrevna mindnam, doa os hevna nengavnangmba Yesusmba lohvhoamnanamba, wo hev wel sandava selvowol vevna Yesusna monglara. ");
INSERT INTO wrs_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Doa Simonmba mendah Yesusm wainevna, wo hev nonglana, nomba ungevliriniva os vev, wo hev nengna, memba tendoriniva Yesusva tanam Sesoana moashulnindrini lohtava, himba ata ovomnata. Himba hev ambo ata honam ungevlirinim lihata, doa hev ata lihata, osva ungevlirinikokla. ");
INSERT INTO wrs_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Doa Yesusva hev ambo Simonna nengavnangmba lihamnana, os ishomnana, Simon, yem kava waiisholm vev. Wo Simon ona, wouta. ");
INSERT INTO wrs_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Doa Yesus hemba os ishomnana, olhmona kava yemba omnav. Mongo bisnis indhanarini avna, himba doara moang vinna hevna diva hevna sehelsamblam. Himba os mongom dembrahona kina 50pelara, wo himba os mongom dembrahona kina 500pelara, unna, yeoa kamoa henga daha endombrohwolo. ");
INSERT INTO wrs_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Doa sismba himba nomba sehelsamblam henga ishunna os, kam endembraho. Doa himba ohona, kava dihui ahav. Doa nomba bisnis indhanariniva unna, yimba dihuiva elohv, doa heva os yena melva kava men ehlathinv. Memba olhmoa, wo es yimba nengv, an nomba bisnisnindrinimba mindnamba indk vethamnavra, wo an eva espetava indk vethamnavra hemba? ");
INSERT INTO wrs_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Doa Simonmba Yesusmba os ishomnana, os kava nengv, nomba indhanariniva temba hena melva os lohmananamba kina 500pelara, himba nomba si hemba mindnam ind vethamnavav. Doa Yesusva Simonmba os ishomnana, lehra yimba ov. ");
INSERT INTO wrs_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Wo Yesusva nomba ungevlirinimba indthoavna novlomosna, ona, memba ungevliriniva himba kamba mindnam und vev, heva os yimba owai. Yena deuvrava kava sihaiva, wo owai, yimba besalwevsam engimoa, yimba pomba kamba vrahoimoa, osm ora, kava kavna monglamba poswol vevav. Doa heva os hona ungevliriniva himba kana monglamba wenopona posvei, wo hevna tana poswol vevna. ");
INSERT INTO wrs_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Yimba kamba osva omnimoa, lehra yimba prov, doa heva os ungevliriniva himba monglara kamba sanbas vrevna. Osm vevna, kava yeinda aiva, veiva, daipotava men. ");
INSERT INTO wrs_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Yimba kamba kurava selvoimoa welnamba, osm ora, lehra yimba prov kaindamba. Doa heva os ungevliriniva himba welsandava besalva doa kana monglarava selvowol vei. ");
INSERT INTO wrs_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Seilva himba ungevlirinikokla avna, doa heva os kav hena indkoklamba poswol wohvemni. Pimba honamba noinda nonorava av, himba kalmangas undnahonamba alm vevna. Heva os indhanariniva himba nomba kamba ishomnavmoa, kana posveo, doa himba nomba kamba mindnamba und vevavmoa hevna undnahonamba. ");
INSERT INTO wrs_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Doa Yesusva henga ungevlirinimba os ishomnana, yena indkoklamba doa kava poswol vei. ");
INSERT INTO wrs_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Doa nomba indhanamba temba mongawulm aevulvnam, himba hevm ishuvna os, es hevpa Yesusva osva ov, yena indkoklamba kava poswol vev? ");
INSERT INTO wrs_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Doa Yesusva henga ungevlirinimba os ishomnana, yeoa beswonam gavm. Yimba kamba pevna undnahonam lohvhoamniva, wo noinda kava doa yemba lopslahai monakoklariniva. ");
INSERT INTO wrs_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Doa dawonam Yesusva kembellava kotarava os lohmana vevna, Sesoana nemelmom besalm ishomana vinvna. Hev ona, si Sesoatindilm nemel avav, yeoa saivvm. Hevna aonghal mahalnindva 12pelara mongawulm lovahmana vevna. ");
INSERT INTO wrs_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","3","Doa ungevliva eva mindnampetam mongawulm lovahmana vevnata Yesustatanamongo. Himba hevna dina innemba sovawol vinivna, doa Yesustatanam dahwol vivna. Nomba ungevliva doara tihsongo hevna nihra siheku vinnamba, wo hemba uvavulva vinvna, doa Yesusva hemba doara sishona vewol vena. Mongona ungevlirinina nihilva Maria, himba Maktala ongorini prona, doara tihsongova 7pelara hena nihrava saivna aiv, doa Yesusva doara tihsongomba engvapiangamnana. Mongona ungevlirinina nihilva Yoana, nomba Kusana ongal avna, Kusava himba nomba Herot kuwulna andranindrini lohvna. Wo mongova ungevlirinina nihilva Susana. ");
INSERT INTO wrs_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Doa indhanamba mindnam ambna no kembellini no kembellini, Yesusinda kusona, hellelm, wo himba olhmona ishomana vinvna hemba. ");
INSERT INTO wrs_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","Doa mongo indhanariniva witmov koko velm ingana osoram. Wo hev wondarini ihrombol vevnamba, koko vengavna. Wo monglava witmovpa monara pethakoklarava dalvnamba, indhana monglana lisingsing vewol vina, doa tuawa hlapiana. ");
INSERT INTO wrs_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Doa hevpa mendah koko vengavna, wo monglava witmovpa pethara dalvna, nomba pethava dasalm lohvna honsra. Doa nil vevnamba, os dalvna, manara, plalva pipiha vevnamoa, noinda dalvna. ");
INSERT INTO wrs_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Doa hevpa mendah koko vengavna, wo monglava witmovpa pethara dalvna, nomba pethava ilsas merava lohvna soposalna. Nilva ona vena, ilva wohvendningenamba, wo witva phonamoa. ");
INSERT INTO wrs_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Doa hevpa mendah koko vengavna, wo witmovpa pethabesalla dalvna. Wo nilva vevnamba, doa beswonam phovna, wo movolva esvema beswonam kethavna 100pelara mongawatillava. Yesusva olhmonamba os unna, doa hevpa mindnam unna henga, himba nomba levrapivolalmba vivrava hona moamba, himba nomba hevna aongva elepewolinvra, doa beswonam ningvra. ");
INSERT INTO wrs_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Doa Yesusna aonghal mahalnindva 12pelara nomba moamba hillinamba, wo hev Yesusm ishumnina os, yeoa kamoa plalmomba ishunvm. ");
INSERT INTO wrs_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Wo himba unna, lehra, ata kava yemba ishunvav. Sesoava yemba doara pusvund vena, osm yimba levrapivolvra plalmomba. Yimba si beswonam levrapivolvav moamba, osmba Sesoatindiva si nemel avav. Nomba moamba temba seilva indhanamba tit vivna, wo hillivnamoa, yimba levrapivolvav. Heva os monglamba indhanamba owai, kava hemba ambo olhmonamba ishomana vinv. Himba hillivrava, doa heva os himba tit vivav plalmomba. Himba nunglivav novna ambo, heva os himba plalva velokusa vivavmoa. ");
INSERT INTO wrs_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Plalmomba os lohv, witmovpa nomba lehvrowol vev Sesoana moamsna. ");
INSERT INTO wrs_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Doa witmovpa nomba temba monarava pethakoklarava dalvnamba, himba lehwol vev indhanam, nomba temba Sesoana moamba hillivpa. Doa heva os himba kek vithivmoa owai, wo Setanmba prinv, moamba henga dombv. Doa osva nomba indhanamba Sesoamba hevna undnahonamba lovahthamnavmoa, wo Sesoava hemba lopshavavmoa monakoklariniva. ");
INSERT INTO wrs_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Doa witmovpa nomba temba honsrava dalvnamba, himba lehwol vev indhanam, nom ten Sesoana moamba hillivpa. Wo hevpa indk vithiv, doa heva os himba kek vithivmoa yunalmba owai. Setanmba hemba kinwonda plothunv, doa osva nomba indhanamba Sesoana moamba wuleihiv. Himba witmsna vilov, nomba temba plalva pipiha venamoa. ");
INSERT INTO wrs_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Doa witmovpa nomba temba petharava dalvnamba, ilsasva doara mera lohvna, himba lehvrowol vev indhanam, nomba temba Sesoana moamba hillivpa. Doa heva os himba kek vithivmoa yunalmba owai. Mindnam himba ningv mana vemam hona pethariniangas, kava honamba iavmoa, kava posal av. Si kava mindnamba iavrava, os kava beswonamba avav. Doa os himba Sesoana moamba wuleihiv. Wo hena innemba ksuvhueinvmoa, il doa vendvongana. ");
INSERT INTO wrs_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Doa witmovpa nomba temba pethabesalla dalvnamba, himba lehwol vev indhanam, nomba temba Sesoana moamba hillivpa, doa hev kek vithiv yunalmba. Undva henamba besalangas luhunvna, uv, memba moamba besal nihnamolnam, pioa kek vithivra, os engivra. Doa dawonam hena andrava innemsna ksuvhueinvav beswonam. ");
INSERT INTO wrs_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Doa Yesusva mendah ishongeinvna os, himba nomba woklava leivrava, himba nomba woklamba ehlithinvavmoa velawonamba owai. Wo himba holtuvsingiva yithivavmoa owai. Himba sena songoholothunvav, doa deuvnindva beswonamba nunglivav. ");
INSERT INTO wrs_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Mana emamba daipotava mendah ehlathalohv, doa heva os si Sesoava nomba ambara wulavav. Moamba nomba temba Sesoatindi nemelva avav, moamba nomba doara poaitava lohvna, doa heva os daipotava yimba hilliv. ");
INSERT INTO wrs_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Doa yenaoa aongoa elepewolvra, doa moamba besal kek vithivra. Doa osva Sesoava yemba moamba mongova mushhueinginvav. Wo heva os nomba indhanamba temba Sesoana moamba kek vethalmba owai vivpa, Sesoava henamba henga si dumbinvav, nomba himba temba osva ningvpa, kava nonorangas av. ");
INSERT INTO wrs_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Doa mongnasiva Yesusva indhanamba wonavna, Sesoamom ishomana vinvna os, doa hevna aval boasalal himba engambna. Wo heva os owai, indhanamba mindnam no deuvrava kekel vethavna. ");
INSERT INTO wrs_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Wo nomba indhanamba Yesusmba umnina, Yesus, avapevpa yenamba, boasalapevpa yenamba, men yem engambv. ");
INSERT INTO wrs_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Doa Yesusva henga unna, lehra, doa heva os memba indhanamba himba nomba Sesoana moamba kek vithivpa, wo eva engivpa, hemba nomba kava indkumbim os nengsmoa ov, ava, boasala. ");
INSERT INTO wrs_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Doa Yesusva hevtindim wongana botra. Hev unna, pioa plombhovmonam angavai, doa nohalm peivoe. ");
INSERT INTO wrs_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Doa himba mendah wongavna, Yesusva lithanamba, ninpol kovope. Doa nungi lelnam vuvi mendekli vevna, pom tuhvna, doa pomba botra ona pilivhoana. ");
INSERT INTO wrs_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Doa Yesusna aonghal mahalnindva murapeta ambanamba, os umnina, mendekli, ata pimba nepola vilovav, pomba botrava pilivhueinv. Doa Yesusva phonamba, vuvimba ovomnana, vuvim, ombakm, ona, wuleiho. Doa vuviva os wuleihana eva ombakva, wo pomba beswonam lithapihavna. ");
INSERT INTO wrs_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Doa Yesusva hevtindim unna, yimba pem vivna, es hevpa yimba kamba lovahthamnavnamoa beswonamba? Doa pem vivna Yesusnapenam, snal hevpa lohv hona tendoriniva, vuvi ombak hena moamangas hilliv, doa wuleihiv? ");
INSERT INTO wrs_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Doa Yesustindiva pethara peivna plombra nohalm, Gerasanindna pethara. Ten nomilm lohvm, wo Galili provinsva honamil lohvna. ");
INSERT INTO wrs_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Doa Yesusva mongom indhanarinim nonglana di, Gerasanindrinim, wo doara tihsongova hena nihmera saivmanana, doa himba os daikaka velohvna, weisva mindnam khuawol venana. Doa himba nihps lohmana vevna, deuvrava lilohvnamoa, owai, himba pethara lilohvna pokamahulsra. ");
INSERT INTO wrs_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","29","Doara nomba tihsongova nomba indhanarinimba wohkevruwul alohvna, wo noinda indhanamba hemba wena ninginamba, os waiaevvna beswonam. Doa heva os himba wemba nomba pokpingalohvna, henga indhanahuiram pholahangalohna. Doa nomba indhanariniva Yesusmba nonglanamba, doa Yesusva tihsongom unna, yeoa pewoleihu hona indhanarinimoa. Doa indhanariniva Yesusna novra pethara pelpena, dandwonam omnana, Yesus, yimba Sesoana ombol, ten sena lohvm, mani ata yimba kamba vinvav? Manam yimba kamba sahonamba vinvav. ");
INSERT INTO wrs_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Doa Yesusva hemba omnana, pevna nihilm sevro, doa himba omnana, nihilva kanamba mindnam, himba noinda osva ona, tihsongova mindnam doara sihipiamnana. ");
INSERT INTO wrs_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Doa nomba tihsongova Yesusmba os alalkohona, manam yimba kamba wolanga vevav mellamba sikulmeram, owai, kamoa wolanga veo meina nihmeram. ");
INSERT INTO wrs_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Tihsongova noinda osva ishumnina, deuvmotovpa mindnam di murapeta ki hlavna sewolla. Doa Yesusva tihsongomba ophunna, wouta ango, meina nihram sihipiangu vinu. ");
INSERT INTO wrs_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Doa tihsongova no miena nihra sihipiangu vinna, doa nomba miemba daikaka noinda vivna, doa sewolla pihipihanamba, plombra holvoral ve, os nepola vilona. ");
INSERT INTO wrs_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Doa miena kekalvhonindva nunglinamba, doa lelnam anga, kembelnindm ishunilm monglam, kembelnindm monanindm. ");
INSERT INTO wrs_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Gerasanindva prapianamba, doa Yesusinda pulvo, indhanarinim nom nungli, temba doarava tihsongova saivmananamba. Pai doa himba besal lohv daipotava. Himba Yesusinda avna pikiannahonam, doa moamba beswonam himba ishovna. Doa kembelnindva pem vivna. ");
INSERT INTO wrs_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Doa indhanamba nomba temba nunglinamba novnamba, himba kembelnindm ishunvna, Yesusva hona indhanarinimba doa sungiavho vrei. ");
INSERT INTO wrs_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Doa Gerasanind indkumbi himba pem vivna os i, doa Yesusm umnina, yeoa kanaminioa geinu. Wo Yesusva henga botra sihanamba, ona, pioa henga Galili provinsram angai. ");
INSERT INTO wrs_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Wo nomba indhanariniva temba tihsongova seilva hena nihrava saivmanamba, himba Yesusmba nihnapehna omnavna, yei kaoa engai. ");
INSERT INTO wrs_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","Doa Yesusva hemba ovomnana, owai, yeoa pevindam gavm, di owapevm yeoa os ishunu, Sesoa doa kamba sungiavho vrei. Doa himba os Yesusmba wuleihalahanganamba, doa no kembella lohmana vevna. Hev moakus unna, Yesusva kamba os venai. ");
INSERT INTO wrs_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Yesusva henga hevna petharam phonamba, doa indhanamba indk vithimnivna, lehra yimba prov, kava yemba aevulmanavna doara. ");
INSERT INTO wrs_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Doa mongo indhanarini pronamba, nihilva Yairus, himba sembayangna kuwul luhunvna. Hev Yesusm mulumbdandna lohvhoamnana, doa omnana wenopnahonam, yeoa kana deuvram proo. ");
INSERT INTO wrs_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Himba noinda osva omnana, hevna molva mongasal avna, osomba henamba os lohmanana 12pelara, doa himba indnakra vevna. Doa Yesusva Yairusi enganamba, indkumbi monara kelvhueinna. ");
INSERT INTO wrs_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Doa mongo ungevliriniva eva avnata, doara himba tovoltowond vaomana vevna, tahonmba 12pelara vewol vena. Wo owai, indhanamba hemba sishona vrinamoa. ");
INSERT INTO wrs_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Wo Yesusva monam ona gana, doa nomba ungevliriniva sis engvaguavna, doa Yesusna kayenmulm tuhmanana, doa nungi lelnam tovolva wuleihana. ");
INSERT INTO wrs_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Doa Yesusva ona, an kamba tuhi? Indkumbi umnina, kava owai. Wo Pita omnana, indkumbi monara kelvhueinv, es hevpa yimba osva ov, an kamba tuhi? ");
INSERT INTO wrs_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Doa Yesusva henga ona, kamba tuhita, kana meississongolpetava doa kenga vrei. Kava doa nonglai. ");
INSERT INTO wrs_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Doa ungevliriniva nomba nengna, Yesusva nonora, doa hev murapeta pronamba, mulumbdandna lohvhoamnana, wo hemba eisungu vevna Yesusnapenam. Doa hev moakus omnana musera, kamba wosepul kovhoavna, noinda kava yemba tuhi. Wo doa kamba wohkikvei. ");
INSERT INTO wrs_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Doa Yesusva nomba ungevlirinimba ishomnana, yimba kamba lohvhoamniva pevna undnahonam, wo yemba noinda lesvhoai, yeoa beswonam gavm. ");
INSERT INTO wrs_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Yesusva mendah nomba ungevlirinimba ishomnavna, wo mongo indhanarini pronamba Yairusna deuvrini. Doa hev Yairusm os ishomnana, mopovmba yenamba doa wohdahai, gurumba pivnamba ombamba manam yimba waiprovav eva ata. ");
INSERT INTO wrs_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Yesusva hellenamba no moamba, doa hev Yairusmba os omnana, duusoa wuleiho, kamoa pevna undnahonam lohvhoamno. Ata kava yena mopovmba sishona vrevav. ");
INSERT INTO wrs_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Doa Yesusiva Yairusiva monam henga enganamba, wo Yairusna deuvra waipho. Doa Yesusva ombandhanamba ovunna, manam yimba saivvav, honangas saivra, Pita, Yon, Yems, Yairus eva ongal. ");
INSERT INTO wrs_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Doa himba hevho saivna, wo deuvnindva wuo ovna, henamba wenoppa pihangu vinvna. Doa heva os Yesusva unna, wuleihu, hona mutundisrinimba wohdahaimoa, owai, himba ninpol kovopevna. ");
INSERT INTO wrs_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Doa deuvnindva nomba Yesusmba los umnivna, gekala ov, doa wohdahai. ");
INSERT INTO wrs_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Doa Yesusva mutundisrinimba nomba kevrana englavalva, doa mindnam omnana, yeoa pho. ");
INSERT INTO wrs_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Doa himba henga vavatan vevnamba, phona beswonam, doa Yesusva indhanam nom os unna, yeoa hemoa inneoa dahu. ");
INSERT INTO wrs_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Doa araravalva luklukul evethavna, wo heva os Yesus hemba ovunna, manam yimba moakus uvav muserava. ");
INSERT INTO wrs_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Yesusva hevna moalamangnindmba 12pelaramba nembaomana venamba, doa hevm awothowol vena, unna, yeoa angawul vevm, doa tihsongom engvapianginvm indhanana nihmerinim, doa uvavulmungilmba sishona vewol vivm, men kava yemba awothowol vevm. ");
INSERT INTO wrs_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Wo angarava, yeoa indhanamoa os ishowol vinvm, Sesoatindiva si nemel avav, yeoa pevna indkoklamoa maivithivm, os saivra. ");
INSERT INTO wrs_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Wo yimba angavrava, manam yimba kinmba ianga vevra, nomba alamba, wondamba, innemba, diva, bayuva monglava, owai, doa lelnam ango. ");
INSERT INTO wrs_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Wo yimba angarava, wo mongova kembelnindva yemba ora, osindhivra, doa yeoa dingas wohaevulvm, verava, wo yimba henga mongona kembellamba nominiva os angavav. ");
INSERT INTO wrs_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Wo mongova kembelnindva yemba ovumnivrava, eva yenam nemelmom, doa yeoa hemoa wuleihalaha ango, wo hevna novra yeoa monglapethaoa bumb vewol viu, osm heoa nunglira, ora, kava wevsakoklana av. ");
INSERT INTO wrs_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Doa moalamangnindva hillinamba, os anga, wo kembella lovahmana vevna, himba Sesoana nemelmoa besal ishuvmona vinvna, doa uvavulmungilmba sishona vewol vivna hemba henga beswonam. ");
INSERT INTO wrs_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","8","Yesusva mendekliandra vewol vevna, doa Herot kuwul moam hellena os, mongova indhanariniva mendekliandra vungu vev, noinda himba nengavnangva mindnam vevna, an hevpa vev osva? Wo monglava indhanamba os uvna, Yon Baptais vev, ten doara wohdahanam, henga beswonam phonam. Wo monglava indhanamba os uvna, owai, Elaita moashulnindrini vev, ten doara amana venam, henga prov. Wo monglava indhanamba os uvna, owai, mongo moashulnindrini vev, noi ten doara amana venam, henga beswonam phona. ");
INSERT INTO wrs_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Doa Herotva ona, Yon Baptaisnamba kuwulva kava doara kovhoamnanata, an hona mendekliandramba vev? Kava nonglalm vev no indhanarinimba. ");
INSERT INTO wrs_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Yesusna moalamangnindva lovahmana vepianamba, henga ambna, doa hev Yesusm moam nom ishumnivna temura, ten hev vivna, sishona vewol vivna uvavulmungilm, eva moa besal ishunvna. Doa Yesusva hemba wongana mongona kembellam Betsaita kembellam. Hev unna, pioa aevulvohra pivho. ");
INSERT INTO wrs_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Hev anganamba, doa kembelnindva hillinamba, os Yesusm sis patvmonavna. Doa Yesusva hemba unna, lehra yimba ambei, doa hev unna, Sesoana nemeltindilmba si snal avav. Doa Yesusva hemba sishona vewol vena, nomba temba doarava uvavulmungilva aevulvnamba. ");
INSERT INTO wrs_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Yesusva os vevnamba, doa okombava helgang vovhoavnamba, doa hevna moalamangnindva 12pelara ambmanavna, umnina os, yeoa hona indhanamoa wolanga vevm kembellam, heoa aslalwol vevra vuhem eva innem. Huiva indhanamba aevvmoa, owai. ");
INSERT INTO wrs_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Doa heva os Yesusva hemba os ishunna, owai, yeoa hemoa inneoa dahwol vivm. Himba umnina, owai, pimba iaevv rotiva 5pelara eva tambkokonglava sambla, ata pimba lehra vethavavmoa. Es hevpa kava angavav, innemba sovawolalmba, owai, eva indhanapeta avma. ");
INSERT INTO wrs_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Himba noinda osva Yesusm umnina, tendomba 5000pelarava diva aevulvnamba. Doa Yesusva hevtindim unna, yeoa hemoa os ishunu, aevthuwul vera, di 50pelara pulundthoavra, di 50pelara pulundthoavra osangas. ");
INSERT INTO wrs_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Doa hevtindiva hillinamba, wo kembelnindm moam os ishunna, yeoa hui aevthuwul vevm, di 50pelara pulundthoavra, di 50pelara pulundthoavra osangas. Doa kembelnindva osangas vina. ");
INSERT INTO wrs_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Doa Yesusva nomba rotiva 5pelara eva tambkokonglava sambla dambnamba, doa hev ovram nov vevongo vena, ona, Sesoava lehra vei. Doa hev povmang vinna hevtindim 12pelaram, unna, yeoa povmang vinvm hona indhanam. ");
INSERT INTO wrs_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Doa indkumbiva hlapianamba, emba pilivhoaku vinna. Doa hevtindiva innemungilva songowol vinvna sumbra, venamba, 12pelara lohna. Doa sumbva nomba pilivhoawol vinna. ");
INSERT INTO wrs_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Wo Yesusva hevho Sesoamba sembayang venavna, hevtindiva murapeta aevulvna, doa Yesusva ganamba, unna os, kembelnindva es kamba ningthiv? ");
INSERT INTO wrs_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Doa himba Yesusmba os ishumnina, monglava indhanamba os uv, yimba Yon Baptais, himba doa henga beswonam phona. Wo monglava indhanamba os uv, yimba Elaita, ten doara amana venam, wo monglava indhanamba os uv, yimba mongo moashulnindrini Sesoana, ten doara amana venam, wo henga himba beswonam phona doa. ");
INSERT INTO wrs_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Doa Yesusva hellenamba, hevtindim unna, yimba es hevpa ningv, an kava lohv? Doa Pita omnana, yimba Kristus lohv, ten doara Sesoa pusvundthoana. ");
INSERT INTO wrs_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Yesusva mendah hevtindim ishunvna os, manam yimba moakus unvav indhanamba, osva Yesusva Kristus lohv, owainonoa. ");
INSERT INTO wrs_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Kava arana ombol lohv, doa heva os indhanamba kamba si kin vreihuvmona vevav. Mundil, katekis, sembayang andranindna kuwul, himba kamba si os ovumnivav, mani yimba kana kuwulma, doa indhanamba si os kamba helvakomandhivav. Wo heva os kava si samblamongonin verava, henga si kava beswonam phovav kavna nihna. Memba Sesoana nengavnangva doara lohvna. ");
INSERT INTO wrs_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Yesusva indhanamba indkumbimba ishunna os, himba nomba kamba engivrava, himba nomba boasna hevna nengavnangm maivithivra, wo os engivra kamba. Heoa elsus velvohvra, hevna kruseoa indund ilvahvrava, doa os kamoa patvmonavra. ");
INSERT INTO wrs_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Himba nomba hevna nengavnangmba vewol vitava, himba nomba vuhe besallava aevulthavavmoa, owai, hemba nomba si wohdalvav. Wo heva os himba nomba hevna nengavnangmba maivithivrava, wo kam engivra, himba si vuhe besalla wohaevulthavav. ");
INSERT INTO wrs_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Wo mongova indhanariniva hevna nengavnangnamba vewol vevrava, wo os himba iavra manimani besalva, wo himba si os ovav, kakowa lehra. Wo heva os owai, hemba si wohdahavav, wo hevnamba manimani es si hemba mohliheivav, owai. ");
INSERT INTO wrs_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Doa himba nomba lous vritava, kamba mendeklielmba sevralmba, eva kana moamba hellelmba, hemba nomba kava si beswonamba nongalvavmoa, nonamba kava petharamba provrava. Kava henga si provav aranakambara, kavna pusambanakambara, eva ovsongolnindnakambara. ");
INSERT INTO wrs_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Monglava katindiva si os novnamba nunglivav, pai Sesoatindiva nemel av muserava. Monglava yeriniva himba si os mendah pehnana aevulvra, wo hevpa novnamba nunglivav. ");
INSERT INTO wrs_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Doa henga mongona minguram Yesusva ganamba mongo oloram indhanahuiram, osm Sesoam sembayang vaomanalm. Doa hev hevtindim samblamongom wongana, Pitam, Yemsm, Yonm, nom wongana. ");
INSERT INTO wrs_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Doa Yesusva di Sesoam sembayang vaomanavna, doa hevna novlomosva indatov selthoamnana, doa hevna kayenmba mindnam lovhoamnavna os i. ");
INSERT INTO wrs_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","31","Doa nungi lelnam indhanarini samblava ephomnana, Mosesi Elaitai ephomnanamba, Yesusmba wai ihishovna di, nomba moashulnindrini samblava temba doarava elohnamba. Himba Yesusna pusambanakambara oholohvna, ishuvna Yesusna dahalmom. Una, Yesusmba si dahavav di Yerusalem kotara, doa os himba hevna andramba lehra vethavav, wo hona pethamba himba os wuleihavav. ");
INSERT INTO wrs_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Wo Pita, Yems, Yon hona indhanamba, himba nin shavna, doa heva os himba pulvonamba, pai, Yesusva indhanarini samblam wonisholohv hevna pusambanakambara. ");
INSERT INTO wrs_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Wo Mosesi Elaitai himba nomba engalmba evevnamba, doa nungi lelnam Pitava Yesusm ishomnana os, mendekli, lehra kava aevulv huiva, ata kava thindruvpa samblamong vewol vinvav, vera, yem eva Mosesm eva Elaitam, Pitava beswonamba nengvnamoa, ambo nis ishovna. ");
INSERT INTO wrs_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","35","Pitava mendah ishovna, wo tekopukul pihanamba, mera ve, doa Pita, Yems, Yon himba pem vivna. Doa hev moalamangm hellepra vina tekomera, os ovna, memba indhanariniva Yesusva kana ombol lohv, doa doara heva kava hemba kikih vrena, yeoa hena moamoa hillimnivm. ");
INSERT INTO wrs_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Nomba indhanarini samblamongova nomba moamba hillivna, doa himba henga Yesusmba nunglivna, pai, hevho lohv, nomba indhanarini samblava doa engai. Doa Pitava Yemsva Yonmba himba nomba moamba ishunnamoa indhanamba owalmba nonamba, owai. ");
INSERT INTO wrs_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","38","Wo mongnasimba Yesustindiva nominiva vinamba, oloriniva peivna, doa indhanamba mindnam Yesusinda kusovna, nonglalm. Wo indhanariniva mera lohvna no indhanahovra, ambo himba Yesusm ishomnavna mindnam, guru, kana ombolva mongongal lohv, tihsongova doa doara pothomnanamba, wo yeoa hemoa beswonam naengho vrevm, os daha sishona vro. ");
INSERT INTO wrs_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Mongnanamba tihsongova hemba kevralohvpa, wo himba kingenangas ondawolohv. Wo petharam vendpipahavpa, os eisvpa, mius mengra koletwolv. Tihsongova nomba sahoklal, himba lelnamba pewolehalohvmoa, ambo wowonapetam pewolehalohv, omnana, ombna nihrava buhumbh phovhoalohv. ");
INSERT INTO wrs_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Yenisrava kava yena pevtindimba os ishuni, yeoa kana ombmoa sishona vrivm, doa himba lehloh viva, wo heva os owai. Wo pev eva hemoa, ye bavo sishona vretok. ");
INSERT INTO wrs_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Doa Yesusva nomba indhanamba os ishunna, yimba indhanakokla vilov, yimba kamba mindnamba ningminivmoa, osm Yesusva hona otolmba ata sishona vrevav. Sleima yena kindava kamba wuspromana vinvma? Doa aralm omnana, ombpovmoa hom waiproo kaindam. ");
INSERT INTO wrs_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","43","Wo ombolva Yesusindam ganamba, doa tihsongova hemba pethara vendlahana, wo ombolmba eisungu venavna. Doa Yesusva nomba tihsongomba engvapiangamnana, os ombolmba sishona vrena. Wo Yesus aralmba os omnana, kleihungao beswonam. Wo indkumbiva una, pai pai Sesoava keknamangas lohv. Wo Yesusva mendekliandramba vewol vevna, wo indkumbiva nunglinamba, pai pai, es hevpa vev. Doa hev hevtindim unna, ");
INSERT INTO wrs_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","yeoa beswonam hillinvm, Sesoava si kamba indhanakoklana englisra desvhueinvav. ");
INSERT INTO wrs_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Wo Yesusnamba hillinamba hona moamba, wo heva os owai, himba tit vivna, plalmomba manara dihi? Sesoava moana plalva komandhinna, wo himba pem vivna, Yesusmba osahmanalmba plalmomba. ");
INSERT INTO wrs_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Wo Yesustindiva hevm mindnam asamovna, an pina kuwulva luhunv? ");
INSERT INTO wrs_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","48","Doa Yesusva heva hev ambo lihawol vinna hena nengavnangmba, wo hev ishunilm vinvna besalmomba. Doa hev otollinim mongom waipronamba, almangsis wolaihana hevna aonghal mahalnindna novra. Doa Yesus unna, himba nomba hona otollinimba beswonamba nunglivrava, wo nesmos vrivra, osm ora, Yesustindi, himba nomba kam eva nesmos vrivta. Wo himba nomba kamba nesmos vrivrava, himba nomba temba Sesoam nesmos vrivta, nom kam hom wolaihapranam. Wo himba nomba yeriniva sisva gavrava, osm ora, ata homeis eusilmba vetakolavm, doa hemba nomba yimba si os nunglivra, kana mendekli luhunv. ");
INSERT INTO wrs_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Doa Yon Yesusm os ishomnana, mendekli, kava mongom indhanarinim nunglina, himba yena nihilmba sevravnamba, nona tihsongom engvapianginvna indhanana nihmeriniva. Wo heva os kava hemba ovumnina os, mani yimba Yesustindirinima lohvma. ");
INSERT INTO wrs_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Doa Yesusva Yonmba os ishomnana, manam yimba hengava ovomnavav snamba indhanarinimba owai. Mani himba pina ungundrinima, owai, himba pina mongawa andranindrini luhunv. ");
INSERT INTO wrs_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Doa Sesoava Yesusmba murapeta waingalmba vevna hevindamba, wo noinda Yesusva putpiahui vevna, Yerusalemramba himba elsus galohvna. ");
INSERT INTO wrs_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Yesusva mendahva gavnamba, himba monglam hevtindim mi wolanga vena, moam ishunilm mongona kembelnindm Samaria pethanindm. Himba os unna, Yesusva ata huiva phovav, yeoa vuheoa kokolma vinivm. ");
INSERT INTO wrs_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Doa heva os nomba kembelnindva ovumnina hemba, owai, Yesusva Yerusalemram gav, huiva ata livavmoa. ");
INSERT INTO wrs_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Wo Yesustindiva hillinamba, doa Yemsiva Yoniva himba musk evevna, doa hev Yesusm ohomnana, mendekli, pioa Sesoamoa osihmini, osm ora, heoa suweoa vetpipahara hona kembellaoa, wo hona kembelnindmoa vitivhoara. ");
INSERT INTO wrs_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","56","Doa heva os Yesusva hemba novna nongalnamba, os ovunna, owai, wo hev mendah wongavna mongona kembellam. ");
INSERT INTO wrs_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Yesusva hevtindim wongavna monam, mongo indhanarini pronamba, Yesusm omnana, yimba mongona kembellava gavrava, eva kava prongas vevrata domba. ");
INSERT INTO wrs_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Doa Yesusva hemba ishomnana os, yeoa boasna beswonam nengo. Vuhemba kanamba besalva lohvmoa. Miemba himba lovahmana vevpa, doa heva os hena lamba lohv. Wo tuawava himba amana vevpa, doa heva os hena lamba lohv. Kava arana ombol lohv, wo heva os kava vuhehui. ");
INSERT INTO wrs_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Wo mongova indhanariniva pronamba, doa Yesusva hemba os ishomnana, yeoa katindim petheinu. Doa himba Yesusmba henga os ishomnana, dawonam sewonam. Ka boasna gavai, kavna aramindm singvelm, wo kava henga si provav, yemba pethamnalmba. ");
INSERT INTO wrs_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Doa Yesusva hemba henga ishomnana os, manam dawonamba, yeoa kamoa daipotangas pethamno, wo os si yimba indhanamba ishomana vinvav moamba, Sesoatindiva si nemelva avav. Wo hona andrava memba yimba velmba vevpa, yeoa owai veo, arapevmindva si mind owal hev singvivav. ");
INSERT INTO wrs_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Wo mongova indhanariniva pronamba, wo hev Yesusmba os ishomnavna, mendekli, kava yetindilm sihalm vevta, wo heva os kava boasna deuvram garava, kavna owalmba ishunvav, yemba kava wohwuleihawol velahangavav si. ");
INSERT INTO wrs_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Doa Yesusva hemba henga olhmona omnana os, himba nomba Sesoatindilmba lohvrava, himba nomba Sesoana lukandra vevav. Wo manam himba lumba velahavra, sisnov venga ve hevna osom deuvm owalm. Himba manam duus vevra, ambo Sesoana andrangas nis vevra. ");
INSERT INTO wrs_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Doa dawonam Yesus mendekli monglam hevnam andranindm pusvund vena, hev mindnam pusvund vena 72pelara. Unna, yeoa bukethungu vevm, henoi engavra, henoi engavra, wo yeoa mi angawul vevm no kembellam no kembellam, kava si provav sis. ");
INSERT INTO wrs_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Wo hev henga olhmona unna, innemba mindnam lohv osorava, doa heva os osondranindva espeta aevulv. Doa osona aralva mendekli lohv, yeoa hemoa osihminivm os, mendekli, osonnamba mindnam yenamba doa nihil lohv, yeoa pevna andranindmoa wolanga veo, wo himba si meilna vivra innemba pevindam. ");
INSERT INTO wrs_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Wo Yesusva mendah nomba hevna andranindmba ishunna, yeoa beswonamangas angawul vevm. Yimba si ungundhovra lovahvav, os ora, sipsip otol ten sungeitwonda ailgutho vrivm hovra. ");
INSERT INTO wrs_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Noinda yeoa lelnam ambo angavm, wo manam yimba kinmba iangavav, di, wonda, spato. Wo monarava manam yimba lovahthamnavav mongomba, osmba ora, indhanamba moa waiishovra hemba owai. ");
INSERT INTO wrs_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Wo yimba mongona deuvrava ephovrava, doa yeoa boasna deuvnindmoa os awothowol ohovo, Sesoa yemoa nesmos vewol vera, wo os yimba beswonamba aevulvra. ");
INSERT INTO wrs_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Wo mongova nomba indhanariniva os nengvra, kava Sesoana moarava indwonam avra, doa himba yena moamba si os hellevav, indwonam avav. Doa snamba indhanariniva lohmba owai vetava diva, doa yena moamba si os henga pevindam prunvav. ");
INSERT INTO wrs_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Wo yimba mongona deuvrava ahavrava, yeoa nengas evevm inneoa, temba nomba deuvnindva yemba dahwol vivrava. Heoa yemoa dahwol vivra esesm, moa ten pev ihishomana evinvm. Manam yimba mongona deuvrava vongakliha evevav owai. ");
INSERT INTO wrs_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","9","Wo yimba mongona kembella ephorava, wo nomba kembelnindva yemba beswonam kanandhinvrava, doa yeoa nengas inneoa evevm, temba himba yemba dahwol vivrava. Doa dioa yeoa uvavulmungilmoa wolapho evevm, eva kembelnindm os ihishunvm, Sesoava os yemba unv, heoa katindilmoa saivra, doa kana keusingi aevulla. ");
INSERT INTO wrs_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","11","Wo mongona kembelnindva yemba ovunvrava, doa manam yimba diva ahavav owai. Kembel hovra elohvhunu, os ihishunu, kava yemba wohwuleihawol velaha engav mongona kembellam. Wo eva yena pethasmovpa kava bumb vewol evev hui kavna monglariniva. Sesoava yemba oi nembaomana vei hevtindilmba, heva os owai, yimba aongpa vi. ");
INSERT INTO wrs_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Wo Yesusva mendah hevna andranindmba 72pelaram ishunvna os, tanam si Sesoava indhanamba lesvhoawol vevav, doa hev si os indhanakoklamba kinwonda plothunvav esesm. Sesoava si Sotom kembelnindmba kinwonda plothunvav espeta, heva os nomba kembelnindva, temba yemba si ovunvrava, hemba nomba si Sesoava kinwonda plothunvav mendekli. ");
INSERT INTO wrs_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Kava wavra vinv indhanamba Korasin kembelnindm eva Betsaita kembelnindm. Himba pina Israelnind, himba kana mendekliandram doa novna nunglina, doa heva os owai, himba hevna indkoklamba wuleihinamoa. Kava ungundna petharamba doarava gatava, wo mendekliandrava doarava vinta hena novra, himba doara hevna indkoklamba wuleihita, Tairnind eva Sitonnind. Hev hevna indkoklamba ata wuleihita doara, doa kayenkola vevravta, eva pethasavna avta. ");
INSERT INTO wrs_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Doa Sesoava si hemba kinwondava eusil plothunvav Tairnindm, Sitonnindm. Doa heva os himba si Korasinnindmba Betsaitanindmba kinwondava mendekli plothunvav. ");
INSERT INTO wrs_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Sesoava si Kapaniam kembelnindna nihilmba wivewol vevavmoa owai, hevpa si hemba kinwonda plothunvav os i, doa himba si os moainalla peivvav suwekembellam. ");
INSERT INTO wrs_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Yesusva mendah hevna andranindm 72pelaram ishunvna os, himba nomba yena moamba kek vithinvrava, memba osm, himba nomba kana moamba eva kek vithivta. Doa heva os himba nomba yena moamba aongpa vivrava, memba osm, himba nomba kana moamba eva aongpa vivta. Wo himba nomba kana moamba aongpa vivrava, memba osm, himba nomba Sesoana moamba eva aongpa vivta, temba kamba homba wolaihapranamba. ");
INSERT INTO wrs_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Yesusva hevna andranindmba doara wolanga vungu venamba, wo henga himba eksuwulpravna. Doa hev indk vithivna, mendekli, kava yena nihilva sevrivna, os andra vivna, doa tihsongova eva kana moamba hillinvnamba, os gapiangu vevna. ");
INSERT INTO wrs_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Doa Yesusva hemba ishunna os, lehra, kava doara nonglana Setanmba tihsongona kuwulmba, himba Sesoanaminiva wohpelpenamba, ona wing vev, ");
INSERT INTO wrs_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","hillu, kava yemba doara awothowol vena, noinda yimba indkumbiva moamba mendekliva ilvahv, wo yimba lovahmana vevrava, wo yimba saipumka dongolmka dathovrava, yemba helvevavmoa, owai, Setanmba himba yemba indkokla vewol vevavmoa. ");
INSERT INTO wrs_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Tihsongova doa yena moamba hilliv, memba besalta. Wo heva os yeoa avm eisnakra, noinda Sesoava doa yena nihilva novol vewol vinna hevna bukurava. ");
INSERT INTO wrs_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Doa nonamangas Sesoasongolva Yesusm otuhomnana nengavnangm henam, doa Yesusva indk vethavna, ona, ara yimba mendekli kuwul wulluhunv, vei ovna eva pethana. Yena moamba besalva yimba doara komandhana, wo nonoanindva himba levrapivolnamoa. Doa indhanamba nomba temba snakolava euvmona vevpa, yimba hemba ishunna, wo himba levrapivolv. Yimba lehra vena pevna nengavnangnamba. ");
INSERT INTO wrs_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Yesusva mendah hevtindim ishunvna, Sesoa ara doa kamba wolaihana, honamba andrava velmba, wo noinda indhanamba owai, kana plalmba velokusa vivavmoa, arangas vev. Wo indhanamba owai, kana arana plalmba velokusa vivavmoa, kavangas vev. Indhanamba himba nomba kana aralna plalmba velokusa velmba vivrava, kava hemba ambo numhowol vevra nomangas. ");
INSERT INTO wrs_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Wo Yesusva mendah hevtindim wonavna hevho, doa hev unna, yeoa indk vithu, Sesoava doa yemba mindnam und vewol vevna, doa noinda yimba pevna novnamba nungliv kamba. ");
INSERT INTO wrs_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Indhanamba mindnam doara aevluwul vevna nonoanind, moashulnind, kuwul, himba kamba nonglalm vivna, kam kana andram. Doa heva os himba nunglinamoa, yengas nunglina. Himba hellelm vivna kana moamba, doa heva os owai, yengas hilliv. ");
INSERT INTO wrs_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Wo mongo katekis pronamba, doa himba Yesusna nengavnangva lehalm vevna, osm ora, ata sahonampetam ishovmi? Hev osahmanana, guru, mani kava si vevav, wo noinda kava beswonamba wohavav yunalmba, wo eva Sesoaindava phovav? ");
INSERT INTO wrs_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Yesus omnana, Sesoana lohohmomba es novol velohv? Yimba nonora lohvma? ");
INSERT INTO wrs_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Katekis omnana, os novol velohv moamba, Yeoa Yawe Sesoa mendeklimoa pevna undnahonam und vivm, wo nengavnangva yenaoa hemangas vinivm. Doa yeoa indhanamoa monglamoa und vewol vivm, os pev men pevm und vewol vivm. ");
INSERT INTO wrs_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Doa Yesusva hemba omnana, lehra yimba oi, yeoa moaoa honamoa wohengvm, wo osva si yimba yunalmba wohavav. ");
INSERT INTO wrs_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Doa heva os katekisva Yesusm henga osahmanana, anmundm kava kolvrowol vevav? Kavnamangasmi? Noinda osva osahmanana, Yesusva ata homeis os nengvav, himba titnam ov. ");
INSERT INTO wrs_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Doa Yesusva hemba olhmona omnana, mongova indhanariniva Yerusalemriniva nongavna, Yeriko kotaram gavna. Doa monarava himba yukovnindm monglam anongla vena. Wo himba vena, hevm hilvina, di dumbumni, pikian selvowol vini nihrini, wo doa hevpa os wohgapiana, hemoa di pelaha angana, hemba wohkovopena. ");
INSERT INTO wrs_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Wo mongova indhanariniva no monam provna, himba sembayang andranindrini lohvna, os ningthivna, pris, wo himba nonglana nomba indhanarinimba, temba kovopiasambaihanamba, ona, men dahawov monara, doa heva os himba sishona vrenamoa hemba, ambo himba nis kohosihana, os gana. ");
INSERT INTO wrs_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Wo mongova indhanariniva sis henga provna, himba eva sembayang andranindrinita, os hemba ningthivna, Livait. Himba eva nonglakohanata nomba indhanarinimba, temba monarava dahawovnamba, wo sishona vrenamoa, nis ambo kuvhoana. ");
INSERT INTO wrs_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Wo no indhanariniva mendah dahawovna monarava, doa mongova indhanariniva sis henga pronamba, himba ungundrini lohvna, Samaria petharini. Wo hevpa no monam gavna, wo hev nomba indhanarinim nonglana, doa wavra vovhoamnana. ");
INSERT INTO wrs_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Wo hev ganamba murapetam, avhoamnanamba, doa wosavatovol poswol venavna, olivpolna wainna nona vewol venana wosavamba, doa ningemna. Doa hev no indhanarinim omnana, yeoa kana donkisra avhoao hui, wo os tungungana kuksaruvramba, os nesmos vrena. ");
INSERT INTO wrs_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Wo mongnasiva nomba ungundriniva galm vevna henga no monam. Boasna himba 10 kina levranamba hevna wondariniva, wo lerahona kuksaruvna aralm, ona, yeoa wosavamungilmoa honamoa dahowovm. Kava henga si provav, yemba nongalka vevav. Yimba pevna dinamba innemba dahowotava, yemba si kava esesmba dembrahovav. ");
INSERT INTO wrs_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Doa Yesusva olhmonamba ishopianamba, mendah katekismba nomba ishomnavna os, es yimba nengv, nomba samblamong indhanamba embawuvnamba, nonglakov vrevna helvamungilmba. Heni indhanarini nomba samblamong indhanamba beswonamba vevrana helvamungilmba, osm ora hevnamangas? ");
INSERT INTO wrs_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Doa katekisva Yesusm omnana, himba nomba temba wavrava vovhoamnana, wo kolvrana hemba. Doa Yesusva omnana, lehrangas hevm yimba oi honamba, doa yeoa honaoa osangas viliwulkohao. ");
INSERT INTO wrs_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","39","Wo Yesusva hevna aonghal mahalnindva mendah wongavna monam, doa mongo kembella wonpho. Ungevliriniva sambla ahavna diva, nihilva vei, Mata eva Maria, etelmosalal. Doa Mata Yesusm omnana, yeoa sihao hom kana deuvram, hui aloho. Wo Yesusva osangas wohvena. Wo hevpa moa ishunvna, Mariava himba murapeta ahavna Yesusinda, moam hellemnalm. ");
INSERT INTO wrs_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Wo heva os Matava innesowa vinvna nom indhanam indkumbim, doa hevpa Yesusindam ganamba, Yesusm omnana, kana moasalalmoa wolaihaphotok, kam kolvrara, om kamba nombolvhoaima. Es yimba nengv? ");
INSERT INTO wrs_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","42","Doa Yesusva hemba omnana, Mata, yimba mindnam vev, wo eva yimba mindnam nengavnang vungu vev. Heva os men honi wohkuvhoawol vev, nomba temba yimba nengvpa. Mariava doa nengei honamba, wo noinda kava hemba wolaihaphovavmoa owai. ");
INSERT INTO wrs_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Yesusva sembayang vevna, wo sembayang vepianamba, doa mongo hevtindirini omnana, mendekli, kam numhowol veo hona wevsam. Yon Baptais doara ten hevna aonghal mahalnindm numhowol vena, Sesoamba sembayang vemnalmba, yeoa kamoa os numhowol veota. ");
INSERT INTO wrs_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Doa Yesusva unna hemba, yeoa os ishumnivm Sesoamoa, Ara, kava os ningv, indkumbioa yena nihilmoa longong ovrivra. Temba yimba avpa pevnakambarava, nenglelnam prowolavra. ");
INSERT INTO wrs_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Yeoa kamoa inneoa dembrahunvm os detimangas. ");
INSERT INTO wrs_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Yeoa kana indkoklamoa maivethinvm, manara kava doa maivithinna indkoklamba, nomba temba indhanamba indkumbiva kamba vinvnamba. Yeoa kamoa kelvhueinvm, ata homeis Setan kam newondmoa ishunvm. ");
INSERT INTO wrs_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","7","Doa Yesusva mendah hevna aonghal mahalnindm ishunvna, hevpa olhmona unna os, owapevpa yenamba sinimba prorava ehalliniva, yem nonglapho, wo heva os yimba innehui avra nonamba, yimba es venavav? Yimba sehpevna deuvram garava, yimundtomda lohvra, omnavav, seh phorava, innepeta kam aiv vraho, plawapeta samblamong. Kana owal kamba engpraiva sihovranam oklamini. Wo innemba kava iavmoa, dahwolalmba hemba. Doa noi tendorini yemba omnavav dihi, owai, tuvpa doa kolvolohv, katatanamba ninshav. ");
INSERT INTO wrs_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Nomba yena sehpevpa himba yemba innemba lelnamba dembrahovavmoa, doa heva os yimba hemba beswonam loushuiva omnavrava, yemba ata dembrahovav. Heva os Sesoava snamba owai, yemba lilnam vrahovav, noinda yeoa hemoa osihminivm. ");
INSERT INTO wrs_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Yeoa Sesoam osihminivm, wo himba yemba dembrahunvav. Wo yimba aslalvrava, wo yimba os nunglivav. Wo yimba yimundtomdava olvohmanavrava, wo Sesoava yemba osva os unvav, saivo. ");
INSERT INTO wrs_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Manara, indhanamba himba nomba osihminivrava Sesoamba, himba nomba dumbvra. Wo himba nomba mana vemam aslalvrava, eva himba nunglivavta. Wo himba nomba tuvpethalla olvohvrava, hemba nomba Sesoava os unvav, saivo. ");
INSERT INTO wrs_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","13","Yimba hona indhanamba pethanindva indhanakokla av, doa heva os yimba inne besal deiswilv pevna tomotalmba. Wo yena ombpovpa yemba tambkomba osahmanarava, wo yimba saipusuhlava wurahovavmoa owai. Wo yena ombpovpa yemba ayamsumba osahmanarava, wo yimba dongolva wurahovavmoa owai. Sesoava yena aral sena einv, wo himba besalangas lohv. Eva yimba hemba osihminivrava, pevsongoloa yeoa kamoa wolaihaprinvm, wo himba wohvevav osangas. ");
INSERT INTO wrs_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Doa mongo indhanarini tihsongo mungil avna, noinda moahui avna, doa Yesusva engvapiangamna tihsongom, wo nomba indhanariniva henga beswonam ishovna moamba. Doa indhanamba nunglinamba, luklukul vithivna, pai. ");
INSERT INTO wrs_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Doa monglava nomba indhanamba nunglivnamba nomba, himba os uvna, Setanmba tihsongonamba kuwulva Yesusmba doa poauothona, noinda himba engvapiangamni tihsongomba. ");
INSERT INTO wrs_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Wo eva monglava nomba indhanamba Yesusmba lihminivna, yeoa henga mendekliandram vinvm kana novra. Osva ata kava yemba liheivav, Sesoanapopol vev. ");
INSERT INTO wrs_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Doa Yesusva hena nengavnangva lihawol vinna, ona, dasalm uv. Wo hevpa olhmona unna, mongnindva hevmba ahalvamana vetava, hemba nomba mueisowa vilovav indkumbimba. ");
INSERT INTO wrs_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Yimba doa kamba os umni, Setanmba Yesusmba doa poauothona, wo noinda nonapopol yimba tihsongova engvapiangamnana indhanarinina nihmeriniva. Owai osva, Setanmba hevna owalmba engvapiangatava, doa hevtindiva aevvavmoa, mueisowa vilovav. ");
INSERT INTO wrs_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Owapevpa yenamba tihsongova engavapiangina indhanana nihmerini. Wo es yimba ningv, himba Setanna popol vinvma? Owai, wo noinda owapevpa hevpa yemba os ishunvra, Yesusva Sesoanapopol vevna, Setannapopolva owai. ");
INSERT INTO wrs_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Doa Sesoava kamba poauothona, wo noinda henapopol kava engvapiangav tihsongova. Memba osm, doa Sesoana nemeltindi av, si homeis yimba kuvhueivm. ");
INSERT INTO wrs_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Yesusva henga unna olhmona hemba, mongo tendorini kelsombovhol bunevalgona hevna deuvm kekalvho vrowovna, doa hevna wohva manimani beswonam nalohmanavav. Ona, ata kava kekalvho vrevav. ");
INSERT INTO wrs_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Doa heva os mongova indhanariniva provra, himba nomba kuvhoavav hemba, ata vera, hevm helvakomandha-sambaihara, bunevalgo dombmanara, woh manimani moang vuku vinvav. Nomba kelsombovho tendorinina bunevalgova ekhuanamoa hevmba. ");
INSERT INTO wrs_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Indhanariniva kamba kolvralmba owai vetava andramba, himba temba ungundrini kana. Indhanariniva indhanamba nembaomana velmba owai vetava kaindamba, memba osm, himba temba wohengalpingav indhanamba kanaminiva. ");
INSERT INTO wrs_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Indhanariniva avnamba, wo tihsongova hena nihmera avnata, wo no tihsongova wohpholahanganamba, pewolehana no indhanarinimba. Wo no tihsongova lohmana vevna kuvundtholla, pohuira. Wo heva os owai, vuhemba lohvnamoa, eha vawolmba, doa hev henga ona, ata henga kava gavav, dom ten seilm kav pongvhoanam indhanarini inda. ");
INSERT INTO wrs_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Himba hengava ganamba, no indhanarinina nihmera sihamnav, ona, kana deuvpa besalangas lohv, manimani hevnavhora lohv. ");
INSERT INTO wrs_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Doa tihsongova nomba gana, owalm nemba 7pelara, nomba temba sahoklalnonoa, wo hev os mongawulm angavna, di saivoe nihmera. Doa no indhanarinimba hemba wohindkokla vovhoavna mindnam. ");
INSERT INTO wrs_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Yesusva mendah ishunvna indhanamba, doa ungevlirini mindnam omnana, yimba besal, yena avapevpa, yemba temba lengnamba, himba indk vethavra. Himba yemba tetva dahovnamba, himba indk vethavra. Noinda Sesoa hemba doa nesmos vrena. ");
INSERT INTO wrs_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Yesusva omnana, yimba lehra ov, doa heva os no indhanamba, temba Sesoana moamba hillivpa, wo engivpa, no indhanaoa indk vithirata mindnam. Noinda Sesoa hemba nomba nesmos vewol vev mindnam. ");
INSERT INTO wrs_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Indhanamba mindnam kusovna, wo Yesus unna, yimba hona indhanamba sahoklal. Manara, yimba elsus kamba olvohmanav, kana novra vinu mendekliandra. Owai, ata osva kava yemba vinvavmoa. Heva os Yonava moashulnindrini nemet ten venam, honamangas kava si vinvav yena novrava. ");
INSERT INTO wrs_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Yona nemet ten venam, Nineva kembelnindva nunglinamba, una, Sesoanamini. Kava arana ombol lohv, doa Sesoava si os kamba venavav, ten nemet Yonam venanam. Doa indhanamba nunglivav kamba, wo os uvav, Yesusva Sesoanamini. ");
INSERT INTO wrs_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Yimba indhanakokla av, wo si Sesoava yemba wolapho vevav pokamarini, wo yemba lesvhoawol vevav. Wo nonamba kuwul unguvliriniva Sepanindnamba si phovav, si os himba yemba indthoawol vevav indkumbina novra, yenamba indkoklava luhunv. Nomba indhanariniva himba doara heva avna, wo hevna kembellini venamba, os prona hom, osm Solomon kuwulna moam hellelm. Wo mongova indhanariniva men yem wonav, hena moamba besalangas, kuvhoav Solomonna moamba, doa heva os yimba kek vithivmoa. ");
INSERT INTO wrs_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Wo eva Nineva kembelnindva nemet ten anam, wo sismba himba si pulvovav pokamariniva, yemba indthoawol vivav, wo uvav, yenamba indkoklava luhunv. Nomba kembelnindva Yonana Sesoamomba hillinamba, doa os himba hevna indkoklamba wuleihina. Wo mongova indhanariniva men yem wonav, himba Yonamba kuvhoav, wo heva os yimba hena moamba kek vithivmoa. ");
INSERT INTO wrs_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Indhanariniva lampuva lav vravrava, himba demutsingiva lavralahavavmoa, eva velawonamba ehlathavavmoa, owai, himba sena kleihavav, osm no deuvnindva nunglivra no lampumba. ");
INSERT INTO wrs_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Yena novpa maim oi, lampu, wo tav mindel. Wo yena novpa dendalangasva lohvrava, doa yena nengavnangva besal lohvav, oi lampuva beswonam lovhoasiha vev. Heva os yena novpa sahoklalva lohtava, doa yena nengavnangva sahoklal lohvav, oi lampuva lovhoasiha vevmoa, wohkilvrav. ");
INSERT INTO wrs_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Yeoa Sesoana moamoa beswonam ningvm, si homeis lampu lovhoasiha vem owai vevm, wo yena nengavnangva sahoklal lohvav. ");
INSERT INTO wrs_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Yena nengavnangva besalangas lohvrava, yimba uvav, lampuva wohlovhoasiha vev mindnam, eskandpetava kilvralohvmoa, upsilangas lohv. ");
INSERT INTO wrs_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Yesusva mendah ishunvna indhanamba, doa Varisinindrini omnana, Yesus proo, yem ka wainei. Doa Yesusva sihanamba, avhoanamba, wo hev mongawulm enevna. Heva os Yesusva ambo nis nevna, himba hevna englava poswol venamoa, osva temba Varisinindva hevpa vivpa hevna wevolmba. ");
INSERT INTO wrs_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Doa Varisinindriniva himba duus vevna, ona, pai, kana wevsamba Yesusva enginvmoa, ambo nis nev. ");
INSERT INTO wrs_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Yesus mendekli omnana, yimba Varisinindva yimba poswol velvohv ambalsisangas mok pirin pevna englam, doa heva os yimba pevna nengavnangkokla vriv, memba osm yimba merasisva poswol velvohvmoa. Noinda yena nengavnangkoklava os luhunv, yukov velm eva ten pev sahonam vilangavm. ");
INSERT INTO wrs_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Yimba nengavnanghui av. Es hevpa Sesoava ambalsisangas venama, owai, himba meranahonam venata. Wo eva os viuta meraoa, ten ambarasis pev vivm. ");
INSERT INTO wrs_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Yimba diva pevmangas ningv, wo heva os yeoa pevna no dioa indhanam deiswulu, nom innehuinindm, wo osva yena nengavnangva besalangas lohvav Sesoana novrava. Doa nomba temba yimba duus vivpa poswol vewolalmba, yimba hengava si duus vivavmoa honamba. ");
INSERT INTO wrs_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","Yimba Varisinind yeoa pepeh viu, si homeis Sesoava yemba sahonam nongalvm. Manara, manimani osonelusva yimba elsus Sesoamba nona sembayang velvohmanav. Heva os wevsava besalva yimba vivrivmoa owapevmba, eva Sesoamba pevna indnahonam ninginvmoa, yimba owai wohviv. Yeoa wevsana besal avm, owapevm akol velm, eva Sesoam undnahonam amnalm. Wo osonelusva dombroh velmba Sesoana, manam yimba wuleihivav. ");
INSERT INTO wrs_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","Yimba Varisinind yeoa pepeh viu, si homeis Sesoava yemba sahonam nongalvm. Manara, yimba os velvohv, nonamba indhanamba avhoangavnamba sembayangduvrava, yimba pevm vuhe besalmangas mim aevulalm viv indkumbina novram. Wo nonamba indhanamba maketrava kusovrava, yimba os ningv, kam indkumbi nungeilvra, sehmoa owol vivra, nihilm kanam iovolinvra. ");
INSERT INTO wrs_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Yimba Varisinind yeoa pepeh viu, si homeis Sesoava yemba sahonam nongalvm. Manara, yenamba undva sahoklal maim oi, pokama. Indhanamba titnam pokamahulsra sena diaka vevna, osva tit vivna, mana ema sahoklal merava. ");
INSERT INTO wrs_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Katekisva eva di mongawulm aevulvnata, Yesusmba hillivna, doa mongo herini omnana, nomba moamba yenamba pepehmomba, kam eva yena loumomba plothunvta. ");
INSERT INTO wrs_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Doa Yesus unna, yimba katekis, yeoa pepeh viuta, si homeis Sesoava yemba sahonam nongalvm. Manara, yimba moamba mindnam ambo ishunvpa indhanamba, yeoa os viu. Memba osm, yimba kinwonda opluthunv hemba, heva os yimba no kinwondava kullumbvmoa, iangalmba. ");
INSERT INTO wrs_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","48","Yeoa pepeh viuta. Sesoana moashulnind doara heva lovahvna, wo yena simbehumunil helvakomo vivna hemba. Doa daipotava yimba nomba moashulnindna pokamamba huhmoh vewol viv, osm hemba nengeuvmona vinvra. Wo yimba memba osva vivpa, maim ui, pina simbehumunilva lehra hemba helvakomo vivna. ");
INSERT INTO wrs_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","50","Sesoava doara nonorangas wohavna, wo noinda osva ona, kava si wolapra vevav kavna moashulnindm, heva os Israelnindva hemba monglamba helvakomo vivav, monglamba engilwul vevav. Wo yena simbehumunilva osangas wohvivna, Sesoana moashulnindmba helvakomo vivna doara, veiva, daipota men vewuv. Noinda Sesoava si yemba esesmba vinvav. ");
INSERT INTO wrs_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Seilmba Apelmba helvakomandhina, eunillam Sekaraiamba helvakomandhina di tempelmera, di hevm hovrahovra, vei altasengra, vei moainalvhora. Noinda yenamba esesmba luhunv, wo Sesoava si tanam yemba indkokla vewol vevav noinda. ");
INSERT INTO wrs_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","Yimba katekis, yeoa pepeh viuta, yimba kunti wulvahv deuvna, wo indhanamba saivra, Sesoamomba di hillivra, kek vithivra. Doa heva os yimba komandhina kuntiva. Yimba pevpa saivvmoa, wo noinda indhanamba eva saivvmoa, manara, yeinda luhunv. ");
INSERT INTO wrs_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","54","Yesusva os unna katekism eva Varisinindm nom, wo os himba pholahangana no deuvriniva. Wo himba noinda wusapramana venavna Yesusmba, doa mindnam himba sah ovruwul vevna Yesusmba. Himba Yesusna tanamolmomba hellelmba vivnamoa, himba ambo dasalm novtatholm vinivna, kevralm, osm umnivra, ora moakokla ishora. ");
INSERT INTO wrs_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Yesusva ishunvna Sesoana moam, wo indhanamba os kusovna i, hena moamba hellelmba, indhanamba os i ambo alapat vevna. Wo seilva Yesusva hevna aonghal mahalnindm ishunna, innemba nomba Varisinindnamba manam yimba hleinvav, himba sambla indna vilov. Beswonam ningvm, wo manam yimba hena wevolmba vinvra. ");
INSERT INTO wrs_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","3","Himba ambo hevm leslala vewol ovivna, doa heva os mana emamba daipotava hehlathalohvpa, Sesoa si wohpelahavav. Wo memba yimba nonglamba owai vivpa daipotava, indhanamba si sewonam nunglivav. Wo sinimba moamba yimba ishuvrava, indhanamba okombahul hillivav. Wo moamba yimba poaitava monglamba wonishovrava, indkumbiva henga hillivav kuksaruvra. ");
INSERT INTO wrs_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","Yimba himba nomba kana sehelva, manam yimba pemba vinvav, indhana owapevnapenamba vinvav. Himba yemba helvakomandhitava, heva os yena undmba indkokla vrivavmoa. ");
INSERT INTO wrs_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Heva os mongova indhanariniva lohv, yeoa hemoa pepehva vru, himba yemba helpiatava, yena undva himba suwekembella pilpipihavav. Beswonam no indhanarinimangas vru. ");
INSERT INTO wrs_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","7","Yimba nonora, tuawa belkasva himba namahui, indhanamba hemba maketra sovawol vev espeta dina, doa heva os Sesoava es eva maisasa vethavav hemba, owai. Sesoana nengavnangnamba yimba kuvhueiv beltimba, wo noinda manam yimba pemba vivav indhananapenamba. Sesoava nonora lohv, tamba yenamba kuriniva, ora es phona, wo noinda manam yimba pemba vivav indhananapenamba. ");
INSERT INTO wrs_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","9","Yesus unna, kava arana ombol lohv, yimba himba nomba moakus unvrava muserava, kava Yesustindi, doa henga kava kav sism moakus unvav hemba osva, katindi. Kava kavna arana ovsongolnindna novra si moakus ovav osva. Doa himba nomba ishunvrava, kava tit viniv Yesusmba, doa hemba nomba kava ovsongolnindna novra ishunvav, kava tit vev. ");
INSERT INTO wrs_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Wo himba nomba kamba indkokla ovratava, Sesoava si nomba indkoklamba hengava nengavavmoa. Doa heva os himba nomba Sesoasongolmba indkokla ovratava, Sesoava si maivethavavmoa nomba indkoklamba. ");
INSERT INTO wrs_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","12","Yemba katindimba, si sism indhanamba yemba wetat owol vivav sembayangna kuwulinda eva duanginda, himba Yesustindi. Wo heva os manam yimba mindnamba duus vivav nonamba, es hevpa pimba ishunvav? Owai, Sesoasongolva nonamba yemba otuhowol vevav, os ishunu no indhanamoa. ");
INSERT INTO wrs_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Doa mongo indhanarini Yesusm omnana, guru, kana aramba doa dahana. Yeoa ishomno kana etem, aranapuwulm wohm moang velm beswonam. ");
INSERT INTO wrs_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Doa Yesus omnana hem, seh owai, kamba osmba pusvundthoanamoa yena kuwulalmba. ");
INSERT INTO wrs_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Yeoa indkumbi hillu, manam yimba pevmba alhuvav dirava, manara, indhanariniva himba mindnamba wohva iavrava, himba si nonapopolva wohavavmoa owai. ");
INSERT INTO wrs_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Yesus olhmona unna, mongo tendorini avna, himba dinindrini avna, innetna lohvna. ");
INSERT INTO wrs_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","18","Hev nengna, hi si kava innemba meilna vevav, kana deuvpa mani mendeklima? Si kava honamba tupulorava, henga mendeklikumbi vevav, wo no deuvrava kava si weimb, osonna, woh, di noi dembhasiha vevav. ");
INSERT INTO wrs_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Manam eva kava si sahvav, si kava honakrangas wohavav, inne, woh, di no tahonnam no tahonnam. Ambo si kava indwonam avra, nawongas vevra osonnana, wainna. ");
INSERT INTO wrs_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Innetnamba os ona, doa heva os Sesoa omnana, yimba nengavnanghui, ata sinimba yemba dahavav. Wo no wohva innemba yimba meilna venamba, an si iavav hevmba? ");
INSERT INTO wrs_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Memba lehvrav, mongo indhanarini meilna vev wohna osonnana hevmba, doa heva os Sesoana novrava himba owousra polohv. Manara, himba Sesoamba undnahonamba lohvhoamnavmoa. ");
INSERT INTO wrs_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Yesus hevtindimba henga ishunna, manam yimba mindnamba duus vivav wohna innenamba, osva ata mani kava pikianalmba vreivav? ");
INSERT INTO wrs_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Yena nihva innemba nelmangasva lohvmoa, wo eva yena nihva pikianmba vewolalmangasva lohvmoa owai. Yeoa keknamoa pevna undm ningvm. ");
INSERT INTO wrs_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Nengam kava ov kungem tuawam, himba osomba hiluvmoa, osonnamba himba psewol vivmoa, wo himba meilna vivmoa deuvrava. Doa heva os himba beswonam euvmona vev. Manara, Sesoa doara doa hemba innemba vinna. Wo heva os pi indhana tuawamba kuvhoawol viv Sesoana novrava. ");
INSERT INTO wrs_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","26","Himba nomba yeriniva duus vaomana vetava mindnamba, wo himba nomba hevna tahonmba mumushhoa vrungavma noindava, owai. Yimba es hevpa eva nomba vevav, memba mani mendeklima, noinda manam yimba duus vivav, mana emamba monglamba. ");
INSERT INTO wrs_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Nengam kava ov solam, himba huhmohna vilov, wo huhmohva nomba hevhopolmoava phovmoa, owai, Sesoava hemba nenga vrev, wo noinda huhmohva henamba mindnam kuvhueiv Solomon kuwulna huhmohmba, temba wohtnamba wohlohvnamba doarava. ");
INSERT INTO wrs_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Sesoa hev kulva posrava nenga vrev, heva os no kulva ambo eusil, mani mendeklima. Detiva nemel phov, heva os simerava kongla henga vilovav, wo indhanamba suwera singivav. Sesoa hev vevpa, heva os pi indhana kuvhoawol viv no kulmba. Wo noinda Sesoa hev yenamba nesmos vewol vevav huhmohmba, noinda himba mindnam pimba und vewol vev. Manam eva yimba duus vivav, manara, doa doara Sesoava hev wohav. ");
INSERT INTO wrs_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","31","Manam yimba elsusva nengeuvmona vevav nomba, innem eva pom hlalm. Yimba manam duusva mindnamba vivav innemba. Puehalnindva mindnamba duus viv innemba aslalalmba, doa heva os yimba owai, Sesoa arapev himba doa yenamba nunglini, himba innem aslalv. Doa yeoa ehlana andra viu, Sesoatindim patvunilm, memba andramendekli. Wo os Sesoava hevpa yemba innemba daswolvav. ");
INSERT INTO wrs_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Yimba katindiva espeta kuvulv, wo manam yimba pemba vivav, ara yemba doa ninginna, kava si hemba kavtindilm nembaomana vevav. ");
INSERT INTO wrs_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Yeoa pevna wohoa indhanam deiswulu, dim nonam dombolm. Wo no dioa indhanam deiswulu nom innehuinindm. Os yimba diva pevmba dumbvav, nomba temba si mueisowa vevavmoa. Memba osm, yimba pevna wohna dina meilna vivav Sesoainda sena, wo nomba si yunalm wohnalohvrava, mueisowa vevavmoa. Yukovnindva dumbvavmoa, wo wolwava indkokla vewol vivavmoa. ");
INSERT INTO wrs_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Noinda osoa viu, no vuherava yena wohva naluhunvpa, no vuhemba yimba elsus ningminivavta. ");
INSERT INTO wrs_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","37","Yeoa beswonam kekalvhonindilm lovaho. Maim uvra, bisnisnindrini av, wo hena kekalvhonindva hena deuvm kekalvho vrimniv. Nonamba bisnis nindriniva garava mongona kembellamba tihramba, kekalvhonindva uvra, ata prorava, pivva lelnam tuvoa hemba vileihimnivav. Wo bisnis nindriniva prorava, tuvm vindini, ora nongalsiha vera hevna kekalvhonindm, mendah novkaka aevulv. Himba ata osva verava, unvav, aevultho, doa hevna kayen wambkomb vre hutewonam, doa inne dahwol ve, wo osva no kekalvhonindva himba indk vithivav. ");
INSERT INTO wrs_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Eva himba bisnisnindriniva sihovranamba provra, nongalvra, mendah aevulv, doa hev no hevnam kekalvhonindm nesmos vewol vevav. Yimba kana andranind os viu, no besal kekalvhonind ten vivm, yeoa boasna meilna vildavm pevm, wokla lavrawol vivm pevm. ");
INSERT INTO wrs_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Manara, deuvna aralva nengtava, osva ata yukovnindriniva sinim provav, doa himba no sinimba novkaka wohavav, hevna deuvm kekalvho vrowovav, wo osva hena deuvpa beswonamangas lohvav. ");
INSERT INTO wrs_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Doa yeoa novkaka aevvm. Kava arana ombol lohv, wo kava henga si hona petharamba provav, si homeis yimba tit vewuvm kana prolmba. ");
INSERT INTO wrs_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Doa Pita Yesusm omnana, mendekli, hona olhmomba memba yimba ovpa, kam yimba ishunvma pevna aonghal mahalnindm ora indkumbim? ");
INSERT INTO wrs_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","44","Mendekli unna hemba, yeoa indkumbioa mongawundna vivm, beswonam kana andra vivm. Doa yemba kava wulengu vevav kekalvhonindilm, kavna andranindm innem dahwol vawolalm elsusm. Wo kuwulva prorava, hevna kekalvhonindrinim nonglavra, lehra vev, doa henga kekalvhonindriniva indk vethavav. Kuwulva hemba os omnavav, yimba lehra, daipotava kava yemba desvhoav, kana manimani kekalvho vrowolm. ");
INSERT INTO wrs_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Wo heva os no kekalvhonindriniva sahoklalva lohtava, himba os nengvra, kana kuwulva wenokomba vev, ata provmi, owaimi? Doa os himba innengas nevra eva biangas nevra, doa dai ovra, andranindm owalmba helvowol vevra. ");
INSERT INTO wrs_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Himba os nengvra, kana kuwulva lelnamba si provavmoa. Wo heva os kuwulva henga lelnam ata prorava, yumna velavav, doa himba kekalvhonindrinim nom helvevav mindnam, doa wolaihaphovav amballam puehalnindilm. ");
INSERT INTO wrs_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","Nomba kekalvhonindriniva himba doara lihamnana kuwulna nengavnangmba, ona, yeoa os vevm. Doa heva os himba osva lihrava avnamoa, wo noinda hemba kinsomb plothomnana mendekli. ");
INSERT INTO wrs_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Wo mongo kekalvhonindrini lohvna, himba kuwulna nengavnangmba espetambo lihamnavna. Wo himba indkoklapeta vevnata, ona, kuwulva ata kamba kinwondava mindnampetam plothomnavav. Doa heva os owai, kuwulva hemba ambo espeta venavna, yimba espetambo lihavna kana nengavnangmba. Hemba nomba Sesoava moamba mindnam dembrahunvrava, hemba nomba Sesoava si os ishunvav, yimba andra mendekli vinama kainda? Hemba nomba Sesoava wohva dembrahunvrava mindnamba, kana kekalvho vru, hemba nomba si Sesoava henga unvav, kavmoa henga dembrahunu mindnam. ");
INSERT INTO wrs_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Hev mendah olhmona unvna, kava osm prona, suwem tithoalm pethara, wo kava mindnam nengv, suweoa lelnam wohtaihangara. ");
INSERT INTO wrs_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Si kamba nihsesoava venavav, wo kava mindnam nengv, lelnam kamoa venavra, osm kav pungarava, wuleiha. ");
INSERT INTO wrs_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Es hevpa yimba kamba os ningminivma, Yesusva osm prona, osm daosmom ovunilm? Owai, kava osm prona, osm mongnindva mongnindva hevm daos ohovra. ");
INSERT INTO wrs_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Si sewonam mongawatindi 5pelarava aevulvav mongawaduvra, wo si himba momong vildavav, vera, samblamong lovahvra, sambla elohvra. Doa hevm daosmoa ishuvra kanilm. ");
INSERT INTO wrs_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Aralva ombolm okosvevra, ombolva aralm okosvevra, avalva eva molm okosvevra, kolalva puwelm okosvevra, puwelva eva kolalm okosvevra kanilm. ");
INSERT INTO wrs_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","56","Hev mendah ishunvna, nom ten engvalvohmana vevnam, yimba nungliv tekomba, wo tekova nosisva provpa, yimba uvav, pomba ata hasvovav, wo osangas phovav. Wo eva yimba vuvimba hillivpa, nosisva provpa, yimba uvav, pom engv, wo osangas phovav. Yimba doa lihawol vivta tekomba eva okombamba, doa heva os yimba tit viv honamba, si yena lesvhoawolalmomba phunvav. Yimba pev maim os uv, kava lehra, heva os owai. ");
INSERT INTO wrs_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","59","Yeoa beswonam ningvm, besalmonam engivm. Os men, indhanariniva yemba perkara waivelmba vevrava, pioa duangindam engara, kana perkaramom hellelm. Wo heva os hui doara monara pevmoa beswonam eknowoho. Si homeis yimba duanginda ephorava, wo duang polisim wohtvav, kevru buiram hemoa. Yemba buirava wolaihasihatava, yimba lelnamba si phovavmoa buiriniva, owai. Yeoa pevna melm hehla vewol vaomana veo, verava, mongova poaitava lohvavmoa. ");
INSERT INTO wrs_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Yesusva ishunvna indhanam, wo henanam indhana mongla nongal-pulvonamba, doa hev umnina, os kava hillina, monglava Galili provinsnindva doa angana tempelduvram, Sesoam sembayang venalm, tata wesang vivna. Doa mendah vivna osangas, doa Pailat duang hevna valgonindm wolanga ve, helvakomolm. ");
INSERT INTO wrs_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","3","Yesus unna, yimba os ningvma, hona Galilinindva himba indhanakoklanonoa, wo himba hevna owalm wohkuvhoawol vina, indkokla velmba, wo noinda Sesoava hemba kinmba mendekli plothunna? Yimba os ningvma? Owai, yeoa pevm weihaloh vewol vivm pevna indkoklarinioa. Si homeis yemba esesm vinvm, wo eva yemba indkokla vilovm. ");
INSERT INTO wrs_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","5","Yimba pev nonora, Siloam kembelnindmba hemba 18pelara deuvnahonam plel vena, os wohdalna hemba. Wo yimba os ningvma, himba indhanakoklanonoa, wo himba hevna owalm Yerusalem kotanindm wohkuvhoawol vina, indkokla velmba? Owai, yeoa pevm weihaloh vewol viu pevna indkoklarinioa. Si homeis yemba eva indkokla vilovm. ");
INSERT INTO wrs_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Yesus olhmona unna, indhanariniva wombamba endhanamba hevna denwit owalnahonamba, doa hevpa nonglaka vrowovna, tahonmba samblamong vevna, osm vevna, ora movolva doa kethav? ");
INSERT INTO wrs_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","No denwitna aralva hevna andranindrinim omnana, wombamoa wohheo, samblamong tahonmba ambo wohlohawona, movolva kethavnamoa. Ambo himba petha besallava ombam lohv. ");
INSERT INTO wrs_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","9","Andranindriniva ophona, mendekli, owai, boasna si ka pethavaval, il noi mingilla dembhamnavav, wo mongona tahonnam si os nunglivav, ora movol kethav, ora owai. Owai vetava, si os kava hilahavav. ");
INSERT INTO wrs_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","11","Yesusva sembayangduvra sihanamba sapturamba, indhanam ishunvna Sesoamomba. No ungevliriniva kilumbmungilva, himba tahonmba 18pelara vewol vena, eva ata es indundva avhoavta. Manara, tihsongova hena nihmera avna. ");
INSERT INTO wrs_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","13","Yesusva nom ungevlirinim nonglana, omnana, hom protok, doa hev omnana, yemoa kanandhara, doa Yesus hevna engla kura holothomnavna, wo nungi lelnam ungevliriniva indund lohvhoana, Sesoam okolavna. ");
INSERT INTO wrs_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Sembayangnindna kuwul nonglana, wo himba musk venavna Yesusm, doa hev no sembayangnindm unna, detiva sapturava indhanamba sishona vewolalmba lohvmoa, sembayangmangas lohv. Okombava 6pelarava pimba andrangas viv, wo nonamangas sishona vewol vivra, detiva owai. ");
INSERT INTO wrs_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","16","Doa Yesus mendekli unna, yimba sambla undna vilov, yimba sapturamba pona innenamba dahwol viv pevna tatam, heva os yimba kamba ovomnavna, hona indhanarinimba sishona vrelmba. Kava detiva lehra sishona vrei hona ungevlirinimba, manara, himba pina mongawatindi Aprahamtindi av, heva os tihsongona kuwulva Setanmba hemba kevrulana 18pelara tahonnam. ");
INSERT INTO wrs_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Yesusva osva onamba, doa nomba indhanamba temba hemba musk vinivnamba, himba lou vivna, wo indhanamba indkumbiva indk vithivna hena besal andrava. ");
INSERT INTO wrs_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","19","Henga Yesus unna, Sesoana nemeltindiva snal hevpa av? Es hevpa eva kava yemba ishunv? Os, indhanariniva nuk kul endhav osora, os sevriv mastat, wo eusilkandal, doa heva os pholavpa timsna, wo tuawava lamba thiwul sihav diva. ");
INSERT INTO wrs_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","21","Henga Yesus unna, es hevpa eva kava yemba ishunv? Os, ungevliriniva rotim velm vev. Hev yisva ambo eskand vevav, plawava mindnam, doa heva os plawava tevwol vevav, monglava ombamba ihhalohvavmoa. ");
INSERT INTO wrs_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","23","Wo Yesusva lohmana vevna kembellava kotarava, numhowol vaomana vevna Sesoamom, himba Yerusalemram gavna. Mongo tendorini ophomnana, mendekli, no indhanamba Sesoa doa sandhana mona besalla henga, wo es hevpa, himba ambo eskandma? ");
INSERT INTO wrs_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","Yesus unna, tuvpa kekalmal lohv, indkumbiva si saha vruwuvav, saivolmba no deuvrava, heva os owai. Heva os yeoa ehlana lihvm, ombamba eva yimba saivvavmoa. ");
INSERT INTO wrs_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","26","Si sewonamba aralva deuvnamba, himba phorava, tuv keknam kolvo. Yimba si amballa yimundtomda lovahvra, wo umnivra, mendekli, kava saivolm vev. Doa hev si yemba unvav, owai, yemba kava tit vewol vev, mani yimba katindima. Doa yimba si os umnivav, mendekli, kava yemba waihlana innemba, wo yimba Sesoana moamba kamba ishunna kavna kembella. ");
INSERT INTO wrs_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Doa himba yemba si os unvav, lehra, heva os owai, yemba kava tit vinv, honaminioa buketho, yimba indhanakokla. ");
INSERT INTO wrs_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Sesoava yemba si os kin plothunvav, wo yimba si nungeilvav pevna simbehumunpevmba Apraham, Isakm, Yakopm, no samblamong indhanamba, himba Sesoatindilm saivvav moashulnindmongo. Doa heva os yimba ambara lovahvav, duus vivav wenahonam. ");
INSERT INTO wrs_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","30","Indkumbiva indakonda kembellini si ambwol vevav, no pethanind no pethanind, doa himba si os Sesoatindilm saivvav inneram. Memba osm, monglava no indhanamba daipotava miva lovahvpa, wo sewonamba himba sis lovahvav. Wo nomba temba daipotava sisva lovahvpa, si sewonamba himba mi wohlovahvav. ");
INSERT INTO wrs_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Monglava Varisinindva ambna, doa hev umnina Yesusm, wohgao honaminioa, Herot kuwulmendekli yemba helvakomandhalm ov. ");
INSERT INTO wrs_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Yesus unna, owai, himba kamba muembnavho ambo ovrav. Yeoa ango, os umnu no indhanarinimoa, Yesusva os ona, kava andra vev, tihsongom engalalm, wo indhanamba sishona vewol vevra. Kava ambo eskand andra vevav honamba deti simera, doa imnisi os kava wohvepiavav. ");
INSERT INTO wrs_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Heva os kava kavna andramba ata wuleihavavmoa, kava si wohviluwulkohavav kavna monara di Yerusalemrava imnisi. Kava moashulnindrini Sesoana, wo noinda kamba di si yunam dahavav, mongona kembellava owainonoa. ");
INSERT INTO wrs_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Kamba wavra venav nomba Yerusalemnindmba, himba indhanakokla, himba Sesoana moashulnindmba helvakomo vivna, honna weilhivna, nom Sesoa ten wolapra vinnam hem. Elsus kava nenglohv, no kembelnindm huhul velmba kavindamba, osm ayam aval hevna otolm ten onbavm, doa heva os owai, himba kamba ovumnivna. ");
INSERT INTO wrs_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Wo noinda Sesoa doa nombolvhoawol vena hemba tempelnahonam hevhomangas. Wo kamba himba si hengava nunglivavmoa, verava, henga kav si provavm. Doa kamba si os nunglivav, uvra, pioa okulira hemoa, himba Sesoa mendeklina andraram prov. ");
INSERT INTO wrs_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Sapturamba Yesus mongo sembayangna kuwulindam gana, nomba Varisinindrini lohvna, himba Yesusm wainelm vevna. Wo monglava Varisinindva kusovna di, Yesusm nonglalm, osm mani himba ata vevav? ");
INSERT INTO wrs_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","3","Doa mongova tendoriniva murapeta avna Yesusinda, uvavulmungil avna, englamongla nesambungu vrevna. Doa Yesus unna no Varisinindm eva katekism, es yimba ningv, detiva sapturava, wo kava sishona vrevavma honi indhanarinimba owaimi? Doaraminimomba es novol velohv, es yimba ningv? ");
INSERT INTO wrs_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Doa heva os Varisinindva wohhilivhoana poaita, doa Yesusva engla holowolahamnanamba, os sishona vrena indhanarinimba, wo wolaihangana hemba. ");
INSERT INTO wrs_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Wo hev unna no Varisinindm, yenamba sapimka ombpovmka mellava holapetava sapturamba, es hevpa yimba owai vevavma, a ye wolaihavongotami lelnam? Yimba wohvengas vevav eva sapturava. ");
INSERT INTO wrs_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","No Varisinindva himba owai, eva es Yesusmba moamba opla vrimnita, owainonoa. ");
INSERT INTO wrs_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Doa nomba Varisinindva himba mongawulm waihlavna Yesusm, Yesusva hemba nongalvna, himba mimangas aevulthalm vevna vuhe besalla innena aralna novra. Doa hev olhinna hemba. ");
INSERT INTO wrs_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","9","Yimba kusovrava kuwulna mendeklina innerava, manam yimba vuhe besallava innena aralna novra avhoavav. Ata homeis yem wolaihaphovm no vuheriniva. Wo kuwulva mendekliva owalmba mongomba das ovratava no hevna inneramba, wo yem nonglavav kuwulva, vuhe besalva he doa kelvhoai. Wo yemba kleiha vrarava, omnavav, hona vuheoa wuleihamno hona indhanarinim. Yemba louva venarava, yimba mulla avhoavav meisra. ");
INSERT INTO wrs_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Heva os yimba inneramba garava, yeoa meisra mulla avhoao. Heva hev innena aral ata yemba kleiha vrarava, wo yemba omnavav, seh dom gao vuhe besallam mim. Wo os yena nihilva innena aralva wulvongavav no innenindna novra. ");
INSERT INTO wrs_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Himba nomba hevmba iovolvrava, Sesoava si hemba nomba dembrapiha vevav. Wo himba nomba hevmba dembrapuv vevrava, Sesoava henonamba nihilva ivongavav. ");
INSERT INTO wrs_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","14","Wo Yesus omnana no indhanarinim, ten hem wainevnam, yimba innemba mendekli dahwol velmba vetava, manam yimba owapevm sehpevm dinindmangas nomba unvav, osmba kamba esesm si waihlavav, owai. Yeoa nom unu, dihuinindm, innehuinindm, monglamungilm, novtitmungilm henom. Osm himba yemba si esesm waihlavavmoa, wo doa Sesoa hev si yemba kanothowol vevav, wo yimba indk vithivav. Si os vevav, nonam hev besal indhanam wolapho vevram pokamarinim. ");
INSERT INTO wrs_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Mongo noi indhanarini Yesus ten wonnevnam, himba Yesusna moam hellenamba, wo hev omnana, kava ningv mindnam, Sesoana nemeltindilm saivolm, wo si kava indk vithivav sewonamba no Sesoana innerava. ");
INSERT INTO wrs_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","17","Yesus omnana, lehra, heva os si homeis ye kuvhueivm monam. Memba os, kuwulva innemba meilna vevna, wo moamba lohmana vevna hindm hindm hindm, daha ambo hona kana inneram. Doa innemba tangapianamba, wo hevna andranindrinim wolaihangana, omnana, onka vinu hona kana inneram, nomba temba kava doarava das owol vevnamba. ");
INSERT INTO wrs_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","20","Heva os indkumbiva no indhanamba himba kongswil ovovna. Mongo ophona, kava petham kovovranamba, wo kava ata nom nonglalm gavav. Manam yimba kamba sahonamba nengmanavav. Wo eva mongo ophona, kava sapim 10pelara sovawol venamba, wo ata kava nom lehwol vevav. Manam yimba kamba sahonamba nengmanavav. Wo eva mongo ophona, kava daipota ango vraiva, wo ata kava provavmoa. ");
INSERT INTO wrs_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Doa no andranindriniva hev gana, henga no moamba ingana hevna kuwulindam. Wo no kuwulmba wusprovna, doa henga hev omnana, lelnam gao kotaram, indhanam nembaomana velm. Monara ten lohkaka vevm, eva deuvrinim unu ombandhanam, kana innem hlalm ambra, no indhanamba innehuinind, monglamungil, novtitmungil. ");
INSERT INTO wrs_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Doa no andranindriniva ganamba, os wohvena. Hev ganamba kuwulindam, hev omnana, yimba temba kamba ishomniva, kava doa vei, heva os mendah vuhemba lohv, pilivhoavmoa hona yena innerava. ");
INSERT INTO wrs_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","24","Wo henga kuwul omnana hevna andranindrinim, yeoa henga gao, indhanam keknam ishunu, ambalm. Dihi ten aevluwul vev osoruvra, kuvundtholla, narava, monapethalla, kava osm nengv, hona kana deuvoa pilivhoara. No indhanamba kava seilva temba das owol vevnamba, wo himba kongswil ovovnam, himba kanamba innemba hlavavmoa eunumbulpetava. ");
INSERT INTO wrs_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","26","Doa indkumbi Yesusm pelkleihamnavna sis, doa hev imharavhoanamba, nongalna, unna, himba nomba katindilmba petheinilmba vevrava, himba nomba hevna owalmba pewolehawol vevra, os katindilmba petheinvra. Heoa wuleihara hevna nengavnangva, os katindilmba petheinvav. ");
INSERT INTO wrs_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Himba nomba katindilmba petheinilmba vevrava, ombamba vivavmoa, owai, heoa boasna hevna kruse indund iangara, kana dandsra ambvra, os katindilmba petheinvra. ");
INSERT INTO wrs_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Indhanariniva nengtava osva, kava deuvm mendeklim velm vev, heoa boasna hevna dim nonglara, es si kava sovawol vevra mani mani mani? ");
INSERT INTO wrs_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","30","Eskand himba boalgal milukul wosavrava, wo hena diva huti vevav. Doa indhanamba diaka vevrava, los umnivra hemba, hona indhanariniva deuvpa hivisimbaihana, diva dihi huti venana? ");
INSERT INTO wrs_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Mongova olhmomba os men. Mongo kuwul nengvra daosm mongnindmongo, seilva himba boasna os nengvav, katatanamba mindnam, 10,000pelara av, si kava wohhelvakomo vivra. Heva os himba kamba kuvhoawol vivav, himba mindnam, 20,000pelara av. Es hevpa si lohvav honamba? ");
INSERT INTO wrs_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Wo no kuwulva henga nengvav, owai, wo noinda wonganamoa daosmba, ambo himba moa pinginna no ungundmba, pioa pivm sehmoa ohovrowolei. ");
INSERT INTO wrs_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Yesus unna no olhmonamba, doa hev henga unna, himba nomba yeriniva katindilmba petheinilmba vevrava, heoa hevna dim, wohm wuleihivra, katindilm os petheinvm. ");
INSERT INTO wrs_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","35","Wanmba besal, heva os tepepe vetava, osva bes vevavmoa, an hengava suwepavna vrevav beswonamba, owai. No wanmba ombam lohvav, indhanamba dembranga vivav. Hillu pevna aongna. ");
INSERT INTO wrs_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Yesus numhowol vevna indhanam, doa no indhana ten taeks di dumbluamb velvohvnam indhananam, himba duangna englisra dembhalvohvnam, nomba indhanamba himba ambna, Yesusm hellelm. Wo eva puehalnind himba eva ambnata. ");
INSERT INTO wrs_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Doa vena, Varisinind eva katekis himba nungeilnamba, hevm ishuwul vevna, Yesusva indhanakoklam honam sehmoa owol vev, wo wonnev, osva sahokla vev. ");
INSERT INTO wrs_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","4","Doa Yesus olhmona unna, mongova yeriniva wonatava 100pelara sipsipmba, wo mongova hoai vetava, aralva no sipsipnamba es vevav? Himba wolanga vevav 99pelarava, ilm hlawuvulm, mongom silelguavav, hevpa ten hoai venam. ");
INSERT INTO wrs_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","6","Doa hev silelguarava, nembavra petharava, henga os waiprovav wangra deuvram, indk vethavav. Doa hev hevna mongawatindim unvav, detioa pioa inne mendekli hlalvohmanara, manara, doa kava nembavra pethai, nomba temba nemetva hoai venamba. ");
INSERT INTO wrs_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Sesoava eva os vevta, noi indhanarini men vevm, wo mongo indhanakoklariniva hevna indkoklamba wuleihatava, Sesoava si hemba mindnamba indk vethamnavav. Sesoava indk vithinvav espetava besal indhanamba 99pelaramba, temba indhana windel. ");
INSERT INTO wrs_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Mongova olhmomba os men. Mongova ungevliriniva diva mindnam iavna, kina sen 10pelara, heva os mongova doa hoai venana. Doa hev wokla lavra, doa nokambara silelvna, sanangna lononglam kelvevna deuvmerini. ");
INSERT INTO wrs_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Doa hev velavranamba, ango owalm unna, doa kava velavrei, kava indk vethav, wo pioa indkumbi indk vethalvohra. ");
INSERT INTO wrs_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Wo osangasta eva Sesoana ovsongolnindva himba si indk vithinvra, nomba temba indhanariniva hevna sahoklamba maivethavpa. ");
INSERT INTO wrs_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","12","Yesus mendah ishunvna, mongova indhanariniva hevna ombol samblam wonavna. Kalel omnana, ara yemba kava os nengmanav, kava galm vev mongona kotaram, kam doara moang vinu pevna dina wohna, kam dembhamnavm eva pevna yiveltowondm dembhamnavm, osra yem sira dahatami. Doa aralva os wohvena. ");
INSERT INTO wrs_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Doa kalelva himba hevna wohna dinamba meilna venamba, os wohvohana. Himba ganamba, doa di pho no kotara, hev ten dom gavnam. Wo diva os weisva dalmanana, wo nonamba himba hevna dina wohnamba engalpingavna hevna kelsombovhora. ");
INSERT INTO wrs_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","15","Doa henanam owous phona no kotarava, doa himba nonamba os vevna, mani ata kava nevav? Doa hev mongom indhanarinim omnana, kava yena diandram velm vev. Kava innehui av. No indhanarini omnana, lehra, yeoa kana miem dahwol vawo kavna pethara. ");
INSERT INTO wrs_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Doa hev osangas vevna, timuv dahwol vevna miemba, heva os hemba indhanariniva innemba dembrahonamoa nelmba, doa hev nengna, ata kava ambo meina inne ninvav. ");
INSERT INTO wrs_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","19","Doa henga hev beswonam nengna, kamba pon venav huiva, heva os kana arana andranindva himba innesra av. Kava ata henga gavav kavna araindam, wo omnavav, kava doa yemba indkokla vrowolna, vei yem eva Sesoam. Kava mani besal indhanarinima, wo yimba manam kamba osva omnavav, kana omb, owai. Os ambo kamoa nengthavm, kana andranindrini, wo kava yena andra vevra. ");
INSERT INTO wrs_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Hev os nengna, doa nominiva os wohprona aralindamba. Himba mendah ehalla provna, aralva ona nov venga vena, nonglana, kana ombva os lohmana vewol vevna, teprovm. Doa aralva lihanamba hemba, lelnam ga, ombolm soltho avondra wavranahonam, mapotho ovravna. ");
INSERT INTO wrs_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Doa ombol omnana, ara, kava yemba doa indkokla vrowolna, vei yem eva Sesoam. Wo manam yimba kamba osva omnavav, omb. ");
INSERT INTO wrs_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Heva os aralva hena moamba hellevnamoa, hev hevna andranindm unna, lelnam ango, noi iamb veo kana besal bayu, spato, musung, noi vewol vimnu. ");
INSERT INTO wrs_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Doa henga ango, kana sapi otol mendhal lu, ningesang viu, ata pimba innemba mendekli hlavav. ");
INSERT INTO wrs_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Manara, kana ombolmba maim ona, doa dahana, heva os owai, doa himba proi. Seilva hemba hoai vena, heva os doa henga proi. Doa noi innemba hlavnamba, moa holothoavnam mindnam. ");
INSERT INTO wrs_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","Yiveltowondva mendah osondra vevna, doa hev monam provna, hellowolga ve, manara hevpa mindnamba osva uv? Di vevna, wemangosangal dahawolavnamba, noinda esvemava ovuvna. ");
INSERT INTO wrs_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Wo hev mongom andranindrinim osahmanana, mani hevpa oviv? ");
INSERT INTO wrs_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Andranindrini omnana, yena boasalapevpa doa proi, wo arapevpa innemba mendekli meilna vei, os oi himba, kana ombva kalelva henga doa beswonam proi. ");
INSERT INTO wrs_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Doa heva os etelmba wusprovna, ata kava sihavavmoa no innerava. Doa aral holopenamba, omnana, sihao innem nelm, noinda psivihara. ");
INSERT INTO wrs_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Doa hev omnana, owai, kamba wusprov, eva yimba kamba om waiamana venama, kava yena andra vevna, eva hellevna, yimba mana vemamba ovnamba. Heva os yimba kamba osva omnanamoa, men honi memeotoloa wonloo pevna sehpevmoa. ");
INSERT INTO wrs_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Wo hona yena ombpovpa, memba daipotava proiva, yimba innemba mendekli hemba veni. Himba diva yenamba wohdembhanga vepiana hevna kelsombovhora, eva ungevlira. Wo noinda kava ata sihavavmoa yena innerava. ");
INSERT INTO wrs_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","32","Doa aral oiwonam omnana yiveltowondm, yemba kava mongawavhora waiamana vev, wo hona wohva memba kava iavpa yenangas. Doa heva os pioa indk vethalvohra daipota, manara, yena boasalapevpa maim una, doa dahana, heva os himba doa henga proi. Seilva hemba hoai vena, heva os doa henga proi. ");
INSERT INTO wrs_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Yesus olhmona unna hevtindim, mongova bisnisnindriniva ditnamba avna, wo eva hena andranindrini himba kekalvho vremnavna bisnism wohm dim. Doa nom bisnisnindrinim umnina, yena andranindriniva himba beswonamba iavmoa yena dina wohnamba. ");
INSERT INTO wrs_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","3","Doa bisnisnindriniva omnana, es hevpa tanamma, kam nethamnato noi kavna tombai, ten noina di sihavm. Kava nonglalm vev, osm ora tanam. Si yemba kava wolaihaphovav kavna andrariniva. Doa no andranindriniva nengvna, si es hevpa kava vevav sewonamba, memba kamba bisnisnindriniva wolaihapholmba oiva hevna andrariniva? Kava eva mani andralma, ilmba kovhoalmba, kamba si louva venavra, indhanamba sah owolalmba, kam dembrehu di. ");
INSERT INTO wrs_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","5","Doa himba hevna nengavnangmba beswonam vevna, ona, indhanamba ata ka kolvrowol vevra, osm si sewonamba he kamba beswonamba vinivra. Doa hev os vena, hev indhanam nemba, nom ten hena nama novol vewol veluhunvm tombairava. Doa hev omnana mimirinim, es novol velohv tombairava, bisnisnindriniva mani yemba vraohna, yenamba mel lohv heindava, wo mani yimba si vrahovav hemba? ");
INSERT INTO wrs_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","7","Himba omnana no andranindrinim, kanamba melva 100pelara botel welva. Doa no andranindrini omnana, poswol veo 100pelaraoa, 50 pelara veo ambo. Wo os himba wohvena. Doa andranindriniva henga mongom omnana, es novol velohv tombairava, bisnisnindriniva mani yemba vraohna, yenamba melva lohv heindava, wo mani yimba si vrahovav hemba? Himba omnana no andranindrinim, kanamba melva 100pelara bek plawa. Doa no andranindrini omnana, poswol veo 100pelaraoa, 80pelara veo ambo. Wo os himba wohvena. ");
INSERT INTO wrs_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Yesusva mendah ishunvna os, no andranindriniva himba sahonam vena, himba hevna bisnisnindrinim deswuhavna os. Doa heva os no bisnisnindriniva himba hemba omnana, doara yimba doa beswonam nengavnangva kokolma vrena, pevmba kolvralmba sewonamba. Memba lehra. Wo Yesusva mendah hevtindim ishunvna, no andranindriniva himba puehalnindna wevsam enginvna, wo heva os hev hevna nengavnangmba beswonamba doarava vena, sewonamba velmba. Yimba katindiva dendalangas aevv, wo heva os si Sesoa yemba lesvhoawol vewol vevav. Si homeis yimba owai vivm, pevna nengavnangm doara beswonam vivm. ");
INSERT INTO wrs_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Yesusva mendah ishunvna hevtindimba, yemba kava dim ishunv, pethanindva honamba mindnam ninginv, huhul velm. Heva os ombamba manam yimba iaevvav owai, owapevmoa monglam kolvrowol viu nona, wo yemba os si unvav, besal indhana. Wo hona pethana dinamba yimba wuleihalaha angavrava, Sesoava si yemba sehmona ongolvav, si yimba vuhe besalla wohaevulvav yunalm. ");
INSERT INTO wrs_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Himba nomba di eskand iavra, wo besal wevsam engvra, indhanamba uvav, himba diva mendekliva iatava, himba beswonam engvav besal wevsamba. Heva os himba nomba di eskand iatava, wo sahoklal wevsam engvra, indhanamba uvav, himba diva mendekliva iatava, himba beswonamba engvavmoa besal wevsamba. ");
INSERT INTO wrs_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","12","Yimba hona diva iavrava hona pethariniva, wo yimba besal wevsamba engva owai vetava, an si yemba alamba tovorahovav, nonapopolmba loholmba? owai. Wo yimba indhanarinina diva kekalvho vremnavrava pevna kelsombovhorava, an si yemba mana ema besalva ovrahovav osva, memba yena? owai. ");
INSERT INTO wrs_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Andranindriniva himba helwolvavmoa kuwul samblamba, owai. Himba mongmangas engvra, mongomba musk venavra. Himba mongmangas hellevra, aongpa venavra mongomba. Noinda yimba dimba alengvtava, yimba Sesoana andrava pevna undnahonam vivavmoa. ");
INSERT INTO wrs_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Yesusva hevtindimba ishunvna dimom, Varisinindva murapeta aevulvna, hillimnivna, no Varisinindva dimangas mindnam ningvna, hev meis aharavhomana ovomnavna, an ata yena moamba hellevav? ");
INSERT INTO wrs_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Yesus unna, memba yena wevsa yimba indhanamba isholvuhinv, kava wevsava besalangas engiv. Heva os Sesoava yena undva lihawol vinv, osva indkoklal luhungu vinv. Nomba mana vemamba wevsamba indhanamba mindnam ninginvrava, besalangas, Sesoava hevna meis haravhoavav. ");
INSERT INTO wrs_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Sesoana lohohmomba eva hevna moashulnindna moamba novol velohv doara, wo indhanamba ilvahvna, moakus unvna, venamba, sismba Yon Baptais lohna. Doa daipotava men kava nemelmoa besal moakus unv, doa indkumbiva ehlana lihv, saivolm vev Sesoana nemeltindiram. ");
INSERT INTO wrs_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Sesoana lohohmomba doara novol velohvta, heva os owai, hena moamba ombamba lohvavmoa, osm ora indkumbi wohengivra. Pethaiva oviva si mueisowa vewolvav, doa heva os Sesoana moamba wohlohvav. ");
INSERT INTO wrs_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Tendoriniva ongamba vravrava, wo henga engvavra, henga mongo vravra, osva temba Sesoana moam pilpikohav. Sesoava os nonglav, temba ongariskui vev. Wo temba tendoriniva seilva no ungevlirinimba engvanamba, ye vravra henga hemba, osva temba Sesoana moam yimba eva pilpikohavta. Sesoava os nonglav, yimba ongariskui temba vevta. ");
INSERT INTO wrs_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Yesus olhmona unna indhanam, doa mongo tendorini avna, himba innetna lohvna, noi inne di pikian besal aembul, wo innemba himba beswonamangas nelohvna elsus. ");
INSERT INTO wrs_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","21","Doa hena tuvpethalla mongova tendoriniva kismungilva vendkuetha lohvna, nihilva Lasarus. Himba innehuinindrini lohvna, os nengvna, kava inneslehol innemungilm nelm venav no innetnanam, ten pihangu venavm meyarini. Windemba ambalvohvna, hena wosavam mindena limbewol velvohvna. ");
INSERT INTO wrs_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","23","Doa dawonam venamba, no kismungilmba daha, wo Sesoana ovsongolnindva hena undm omnahalvmana vuhe besallam Apraham simbelindam. Doa eva no innenindrinim daha, os singvina. Wo hena undva os gana, dom ten indhanasongo avnam suwera. Doa hev ona nov vevongo vena muramo, ten Aprahamba eva Lasarusva mongnahalm elohv. ");
INSERT INTO wrs_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Doa hev ishonga vemnana Apraham simbelm, simbe, kam wavra vovhoamno, hom Lasarusm wolaihapro, omno os, englapund pora veltharava, wo kana mindem uwut vrera nona, kamba vuvrevpa mindnam hona suwera. ");
INSERT INTO wrs_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","26","Apraham ishomnana hemba, omb, owai, nengo, nom yimba petharava avnamba, yimba manam eva ata sahta pevmangasva, owai. Doa heva os owai, hona Lasarusva himba kismungil amana vevna owousra. Doa daipotava himba men beswonam av, wo yemba nihsesoa mindnam venav. Wo eva mendekli olo pimba kalvholuhunv, yem eva kam. Wo noinda osva hona indhanamba ambvavmoa yeindamba, eva yimba homba ambvavmoa kaindamba. ");
INSERT INTO wrs_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","28","Doa noi innetna henga omnana, yeoa wolaihango Lasarusm kana araindam petharam. Wo os ongawolla, yeoa Sesoana moam wohengivm, wo osm himba si kuvhueivav hona suwekembelmba. Kana towandaslalva 5pelara lovahav. ");
INSERT INTO wrs_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Apraham omnana, yena towandaslalva himba ilvahv Mosesna Sesoamomba, eva moashulnindna moa. Wo heoa no moamoa wohengivra, wo si himba beswonam osva kuvhueivav suwekembelmba. ");
INSERT INTO wrs_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Doa innetna omnana, owai, osva engivavmoa, heva os mongo indhanarini beswonam pokamariniva phorava, ishunvra, wo himba hillivrava, wo hevna indkoklamba wuleihivav. ");
INSERT INTO wrs_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Apraham omnana, owai, himba engivmoa Mosesna eva moashulnindna Sesoamomba, eva himba hillivavmoa indhanarinina moamba, osva tanam, temba nomba pokamariniva phonamba. ");
INSERT INTO wrs_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","2","Yesus hevtindim unna, tanam mana vemamba sahoklal hona petharini indhanamba si kekaiv vevav, wo noinda himba indkoklava vivra, notongokokla, notongokokla. Wo no indhanariniva owalmba wonsiharava no indkoklarava, hev kinmba vravav Sesoaindava, eva owalva snakolava vilovra. Wo himba ovav, kamoa doara dahata, wo hona indkoklaoa os kohata. ");
INSERT INTO wrs_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","4","Yeoa besal monam engivm. Yenamba etepevpa yemba indkokla vretava, yeoa ishomno hena indkoklamoa. Doa himba wuleihatava hevna indkoklamba, manam yimba hengava nengvav. Wo himba yemba indkoklava vretava, wo himba ovav, kava doa yemba indkokla vrei, yeoa kana indkoklamoa maivetho, wo manam yimba hengava nengavav. Wo hengava yemba venavrava osva, osangas venavm. Wo honamba osva vaomanatava esvemava yemba, yeoa osangas maivethamno. ");
INSERT INTO wrs_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Hevtindi 12pelara Yesus mendeklim umnina, kam kolvrowol veo, kava yem keknamangas lovahalm venav, osm keknam. ");
INSERT INTO wrs_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Doa Yesus unna, yimba kamba ningminivrava espetava, wo yena nengavnangva maim ora, sahaikw, homeista, wo yimba kanapopol mendekliandrava vivra. Yimba osva utava, ti velavhoao petharini, wanplombra lohvhoa, wo timba wohvelavhoavav, verava, wanplombra vilundthoa. ");
INSERT INTO wrs_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","9","Yimba andranindrinimba waiavrava, yena osondra sipsipandra noi vevra. Doa himba andra vaomana verava, vepiarava, doa deuvram pro, yimba hemba omnavavma, osva lelnam sihao, avhoao, kava yem dahwolm vev? Owai, yimba os omnavav hemba, yeoa pora daloho, pikian besal vewol veo, kana innesowa veo. Doa kava nepiarava, daha yeoa os neo. No yena andranindriniva vepiarava, nomba temba yimba omnavpa, yimba es esesmba omnavav hemba, owai. ");
INSERT INTO wrs_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Doa yimba kana andranind, yimba andrava vivrava, vepieirava, nomba temba kava unnamba yemba, doa yeoa os u, kava ambo andranind, kava ambo kuwulna moam engiv, wo kava osva ningvmoa, heoa kamoa iovongovra, owai. ");
INSERT INTO wrs_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","13","Yesusva mendah gavna monam Yerusalemram. Himba hovra phona Samaria provinsra eva Galili provinsra. Hev mongona kembella sihalm vevna, doa lombamungil 10pelara nunglinamba hemba, ehalla ambo ishomb ovowolvohvna vevandnam, una, Yesus, yimba mendekli, kam ninginu, wo kam kolvrowol veo. ");
INSERT INTO wrs_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Yesus nongalnamba, doa hev unna hemba, yeoa ango sembayang andranindindam, wo he ata yena nihmba naengho vrowol vinvav. Doa no lombamungilva os angana, wo doa monara hevna nihm ona nungeilna, pai pai pina nihtovpa beswonamangas lohprinv. Lombamba doa wohselvpingu vei. ");
INSERT INTO wrs_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","16","Mongongal gana heriniva hengava Yesusindamba, Sesoam mindnam aongtanahonam ishomnavna, ona, lehra yimba kamba veni doa. Mulumbdandna lohvhoanamba Yesusinda, omnana, lehra yimba veni. Doa noi indhanariniva himba Samarianindrini ungundrini, himba Yutanindriniva owai. ");
INSERT INTO wrs_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","19","Doa Yesus ona, es hevpa kava sishona vewol vei 10pelara lombamungilva, a owaimi? Wo nomba monglava 9pelarava hi? Hona ungundriningas Sesoamba okolav, wo eva nomba Yutanindva 9pelarava owai. Doa Yesus omnana hemba, yeoa gao deuvram, yimba kamba lohvhoamnav pevna indnahonam, wo noinda yemba lesvhoai. ");
INSERT INTO wrs_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Varisinind Yesusm osihminina, henanam si Sesoava pimba kekalvho vewol vevav, pivm eva pivna petham? Doa Yesus unna, yimba si mana emamba novnamba nunglivavmoa, osm yimba uvav, men phov. ");
INSERT INTO wrs_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Indhanamba si nunglivavmoa, uvra, Sesoatindi nemel ten av, owai. Heva os monglava yimba doa Sesoana moamba hillina, wohkek vithiv, wo noinda himba doa Sesoana nemeltindilm av. ");
INSERT INTO wrs_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Yesus hevtindim ishunna, sewonamba yimba si os uvav, kava nonglalm viv Kristusmba, heoa kamoa kolvrowol vera. Doa heva os owai, yimba si nonamba nunglivavmoa kamba. ");
INSERT INTO wrs_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Indhanamba si yemba os unvav, dom nov venga viu, Kristusva ten avmi? Doa heva os owai, manam yimba hilwilvav, hemba patvunvav. ");
INSERT INTO wrs_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Manara, kava arana ombol lohv, kana prolmba hengamba petharamba si maim ora, wing vei, indkumbiva indakonda pethanindva si os nunglivav novnamba nonamangas mongawulm. ");
INSERT INTO wrs_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Heva os seilmba hona indhanamba pethariniva si kamba mindnam kin vreihuvmona vevav, wo kamba meis haravhueimnivav, doa henga sism kava si provav. ");
INSERT INTO wrs_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","27","Yesusva mendah ishunvna hevtindim, kava si prolmba vevrava, kava nungi lelnam si phovav. Os ten Noa nemet pueumbm nengvlomana venam. Nonamba indhanamba manam ata onengvhuta, ambo indwonam aevvna, inne ongases noi vewuvmona vevna. Doa Noava wonsihavna siprava, doa pueumbva nomba indkumbimba wohmera vena, wo hemba mueisowa vilona. ");
INSERT INTO wrs_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","29","Kana prolmba si maim ora, Sotom kembelnind hev ambo indwonam aevvna, nomangas vivna, innem, maketm, tokom, osondram, deuvandram. Doa nonamba Lotva no kembelliniva dashalahanganamba, doa nungi lelnam suwe honboal ovrini vetral venamba, miklewol wohvena no kembelnindmba. ");
INSERT INTO wrs_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","32","Wo nonamba kava si kavmba ambara vethavrava hona petharava, si indhanamba os ningvav, pai kamba indkokla vilov. Doa nonamba indhanamba kuksaruvrava aevrava, himba manam saivvav deuvmeramba, hevna wohmba dombolmba, owai. No indhanamba osondrava vivrava, himba deuvramba manam ambvav, owai. Manam yimba osva vivav, temba Lotna ongalva venamba, osva haravhoanamba, henga nengvhoana hevna deuvna wohnam, wo noinda hemba mueisowa vena. ");
INSERT INTO wrs_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Himba nomba hevna nengavnangmba engivrava, beswonamba almba, hemba nomba mueisowa vilovav. Doa heva os himba nomba hevna nengavnangmba wuleihivrava, Sesoana nengavnangmba engivrava, himba si beswonam aevulvav yunalm. ");
INSERT INTO wrs_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","36","Kava nonamba provrava, sambla indhana ihilvra nin sinim. Wo mongova nomba kana ovsongolnind waiwohangavav, mongomba wuleihivav. Wo nonamba eva ungevlirini samblava ahavhorava, innesowa evevra. Wo mongova nomba kana ovsongolnind waiwohangavav, mongomba wuleihivav. ");
INSERT INTO wrs_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Yesusva os ona, wo hevtindi umnina, honamba henahalm si vevav? Doa Yesus olhmona unna, tatamba diva nunglavpa, endandva dingas kusov. ");
INSERT INTO wrs_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","2","Yesusva hevtindimba ishunna os, yeoa elsus ishuvmona venavm Sesoam, manam yimba kivrawuliha vrivav. Memba kana olhmoa, mongo tendorini avna duang, himba wetatmom hellelluhunvna. Himba indhanakoklarini lohvna, os Sesoana nengavnangmba nengvnamoa, eva owalna indhananam. ");
INSERT INTO wrs_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","5","No kembellava mongo peli avna, himba moa wulamanavna mongom indhanarinim, doa himba elsus nomba duangmba nonglaka vrelohvna, os hemba isholohmanavna, kana moam sishona vro. Heva os minguva mindnam kuvhoawol vungana, duangva moamba henamba sishona vremnanamoa. Doa sism duangva henga nengvhoana, kava vei, Sesoam indhanam ninginvmoa, heva os hona ungevlirinina moamba maim oi, poata kam ishoka venav aongmera, wo kamba kin vraholohv. Doa ata kava sishona vrevav hena moamba. ");
INSERT INTO wrs_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","8","Mendekliva mendah ishunvna, no duangkoklava himba os vevna, wo Sesoava es hevpa vinvav hevnamba, nomba temba elsusva womana venavpa hemba? Es hevpa himba ovunvavma os, dawonam, owai. Himba hellengas vinvra hena moamba lelnamangas. Doa heva os kava si provrava petharamba, si kava nonglavavma mongomba indhanarinimba, osva himba Sesoamba undnahonam amnavnami, owaimi? ");
INSERT INTO wrs_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","10","Yesus indhanam unna olhmona, no indhanamba himba hevm wivewol ovinvna, kava besal indhanangas Sesoana novra, monglava indhanamba sahoklal. Hev ona, sambla indhana ahavna, mongo Varisinindrini, eva mongova nomba taeks di domblohvnam. Doa no sambla indhanamba enganamba, tempelduvra esihohona, sembayang velm. ");
INSERT INTO wrs_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","12","No Varisinindriniva hev lohvhoanamba, os hevna nengavnangna sembayang vevna, hevmba wulovongovna. Ona, Sesoa, kava snamba owai, monglava temba indhanakoklava vilovpa, owai, kava lehra. Monglava temba snal vilov, owalna di dumbunv, goariskui viv, indkokla vewol vilangav tendonam onganam. Wo kava owai, snamba honamba indhanariniva, memba taeks diva domblohvpa. Kava beswonamangas vev, innemba sambla okombanamba kava lohollohv mongawa minguramba. Diva kavna kava powalwollohv 10pelarava, vev, 9pelarava kavinda sihav, mongal yemba sihamnav. ");
INSERT INTO wrs_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Doa Varisinindriniva sembayang vepiana osva, doa no taeksnindrini himba murapetamba prunnamoa mongla sembayangnindindamba, himba ambo ehalla lohvhoanamba, wo senamba nov vevongo venamoa, owai, ambo ku kusitha. Hev ona, Sesoa, kava indhanakoklarini, yeoa kamoa wavra vovhoamno, kamoa kilumbshuao. ");
INSERT INTO wrs_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Doa taeksnindrinina indkoklamba Sesoava poswol vena, wo himba os deuvramba ganamba, Sesoava hemba nengthana, indhanarini windel. Heva os no Varisinindrinimba hemba owai. Manara, himba nomba hevmba wulvongavrava, Sesoava hemba nomba si pelpipahavav. Doa heva os himba nomba hevna indkoklamba Sesoamba ishomnavrava, Sesoava hemba wulvongavav. ");
INSERT INTO wrs_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Doa araravalva hevna otolm wonamb vevna Yesusindam, vevna tetmengnam eva tingil, umnina, yeoa pevna engla huhlinu, os awothowol veo. Doa Yesusna aonghal mahalnind nungeilnamba, ovunvna, owai, wonanga veo. ");
INSERT INTO wrs_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","17","Doa Yesus otolm huhul vena, unna, ambvra otolva kaindam, manam yimba ovunvav. Manara, snamba indhanamba Sesoana nemeltindilm vilovav. Yeoa otolmsna vilo, os di ambo aralinda wukleiha olohv, wo eva osta yimba Sesoana nemeltindilm avav. ");
INSERT INTO wrs_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Doa mongo kuwul pronamba, hev omnana Yesusm, yimba guru besal, kam ishomno, kava es vevav, osmba beswonamba almba yunalmba? ");
INSERT INTO wrs_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","20","Yesus omnana, manara yimba kamba osva omni, besal indhanarini, heva os Sesoangas besalva. Yimba doara doa hellena moamba doaraminiva, temba novol velohvpa osva, manam yimba goariskuiva vivav, manam yimba indhanamba helvakomo vivav, manam yimba yukov vivav, manam yimba makoko vewol vewuvmona ovovra indhanamba osva, ararapevna moamoa hillinvm. Yeoa hona moamangas engvm. ");
INSERT INTO wrs_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Doa kuwulva omnana, kava eusilva, veiva daipota men, kava moamba nomba wohengna beswonam. ");
INSERT INTO wrs_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Yesus hellenamba hemba, doa hev omnana, heva os mongo boasna mana vema veo, pevna woh owapevm moang vinu, osm yem di dembrehura nonasesm. Wo diva yimba dombvra nona, doa moang vungu vinu no dioa innehuinindm, osva Sesoava yemba mana ema besalva kokolma venavav hevindava. Doa yeoa kavtindilm pethao. ");
INSERT INTO wrs_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Doa no kuwulva himba hellenamba no moamba, himba duus vevna, os nengvna, wohva diva kanamba mindnam. ");
INSERT INTO wrs_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","25","Yesusva hemba nonglavna, mindnam duus vev, hev unna hevtindim, indhanamba wohnindmba dinindmba kin vinv, es eva saivvav Sesoatindi nemelalmba? Sapi mendekli sihalm vev kasvholla, lelnam sihavav. Wo heva os dinindriniva sihalmba Sesoatindilmba, owai, es eva sihavav. ");
INSERT INTO wrs_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Doa no indhanamba hillina no moam, hev una, pai an si sihavav Sesoatindilmba, yunalmba alva? owai. ");
INSERT INTO wrs_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Doa Yesus unna, indhanamba heva hevpa es eva saivvav Sesoatindilmba owai, doa heva os Sesoava hemba nembalmba vetava, hev ambo vevav. ");
INSERT INTO wrs_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Doa Pita omnana Yesusm, kava doa deuvm ongatowondalm wuleihalaha ambna, osm yem patvmonalm pevtindilm. Si es hevpa? ");
INSERT INTO wrs_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","30","Yesus unna, tanam indhanamba himba nomba hevna deuvna, ungevlituendisna, etehumunilna, araravalnamba wuleihawol ambwol vevrava, osm Sesoana nemeltindilm saivolm, wo Sesoava si hemba mindnam esesmba vinvav hona petharava. Wo nonamba sismba si himba Sesoana kembella beswonam aevulvav yunalm. ");
INSERT INTO wrs_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Yesusva hevna aonghal mahalnindm 12pelaram nembanamba, ishunvna, hillu beswonam, pivva angav Yerusalemram. Doa diva indhanamba si kamba indkokla vrivav. Himba wohengivav nomba moamba, temba Sesoana moashulnindva doara kamba novol vewol vininamba. Kava arana ombol lohv, wo mongova moamba doaraminiva si kethalohvavmoa, si kamba wohvelapieimnivav. ");
INSERT INTO wrs_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","33","Himba si kamba Yutanindna meisungundna englara desvhueinvav, wo himba si kamba loumona okos vivra, muembkosvna vinivra kamba. Himba si kamba hilvivav, doa si os kamba helvakomandhivav, wo samblamongo nin si kava verava, henga kava si beswonam phovav kavna nihna. ");
INSERT INTO wrs_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Hevtindiva hillina no moam, heva os himba tit vivna no moana plalmba, himba hevmba velokusa vinnamoa. ");
INSERT INTO wrs_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Himba mendah monam wongavna, doa murapeta Yeriko kotara wonphovna. Novtitmungilva murapeta monapethalla avna, sah owol vawovna indkumbim, yeoa kam wavro vovhueimnu, kam sen dembrehu. ");
INSERT INTO wrs_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","37","Doa hev hellena weitm, memba osva indkumbi kohav, doa venamba, hev no indhanam murapeta osihinna, anmund angav? Doa himba umnina, Yesus Nasaret kembellini himba men gav. ");
INSERT INTO wrs_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Doa no novtitmungilva aongtanahonam osahmanana, Yesus, yimba Devittindirini, yeoa kamoa wavra vro, wo kolvro. ");
INSERT INTO wrs_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Wo noi indhana mi ten Yesusm desvulangavnam, he mindnam lalkohona, wuleiho, poaita ambo ao. Heva os owai, hev mindnam ovna, kam kolvro. ");
INSERT INTO wrs_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","41","Yesus lohvhoanamba, unna, waiembo novtitmungilm hom kaindam. Doa di murapeta Yesusinda pho, Yesus omnana, es yimba nengv, ata yemba kava es venavav? Hev omnana Yesusm, kam sungiavho vro, kava nov velm vev henga. ");
INSERT INTO wrs_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Yesus omnana, men yemba kava venav, yena novpa doa pevhoawolei. Manara, yimba kamba keknam pevna indnahonam lohvhoamnavna. ");
INSERT INTO wrs_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Wo nungi lelnam hena novpa pevhoawolna, doa himba Yesusm os engpethana, ovna, kava Sesoamba okolav. Indhanamba indkumbiva nunglivnamba, una, piv okuliv Sesoamba. ");
INSERT INTO wrs_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","3","Yesusva kohangavna Yeriko kotamonam, mongova indhanariniva lohvna, nihilva Sakius, himba kuwul wulluhunvna no indhanana, ten taeks di dombolvohvnam, himba dinindrini. Himba hellena, ona, doa Yesusva kohai, hev nengna, kava nonglalm vev Yesusm. Heva os owai, himba nonglavnamoa, himba petha ksil lohvna, doara indkumbi mera vithina Yesusmba. ");
INSERT INTO wrs_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","5","Doa himba mi kohana, dandwonam os ganamba, tira vongo. Osm vevna, ata Yesusva men provav, ata hui kava nonglavav hemba. Doa Yesusva pronamba murapeta di no tira, hev nov vevongo ve, omnana, Sakius, yeoa lelnam holopeo, detiva kava ata yena deuvra livav. ");
INSERT INTO wrs_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Doa Sakiusva lelnam holopenamba tiriniva, Yesusm hevna deuvram wainga, hev indk vethavna. ");
INSERT INTO wrs_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Heva os indhanamba nunglivnamba, himba ovumnivna, Sakiusva indhanakoklarini, es hevpa ata Yesusva hena deuvrava nevav innemba? ");
INSERT INTO wrs_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Deuvmera aevulvna, Sakiusva pho, hev omnana, mendekli, si kava beswonam vevav, wohva mindnam kavnamba kava si indhanam moang vinvra, nom ten ambo nis euvmona vevm. Eva nom nemet ten kav ambo nis di dombvnam taeksram, kava henga si esesm vinvav hemba, 4pelara 4pelarava sena hohlonginvav. ");
INSERT INTO wrs_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","10","Yesus omnana hem, deti doa Sesoava lopshai monakoklariniva yetatanamba. Manara, yimba doa Sesoamba keknam pevna undnahonam lohvhoamni, os ten Apraham tomonapev lohvnam. Kava arana ombol lohv, kava prona hona petharam, sna indhanam silelwolalm, lopshalm, nom ten monakoklam engivm. ");
INSERT INTO wrs_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Indhanamba hena moamba hillivna, wo Yesusva henga hemba olhmona unna. Noinda osva ishunna, Yesusva doara doa murapeta prona Yerusalemram, wo noinda indhanamba os ningvna, Sesoatindi nemelva musera avav daipota. ");
INSERT INTO wrs_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Doa Yesus olhmona unna, osm hena nengavnangm sungiavho vrowol vinna, eva mani lelnamma, memba sewonam. Yesus ona, mongo kuwul avna, himba nominiva galm vevna mongona kembellam, osm kam awora kuwul mendeklielm, wo henga kava provav kuwul wulluhunilm. ");
INSERT INTO wrs_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Himba boasna hevna andranindm 10pelaram unna, ambtok. Doa di moang vinvna, os henom 20 kina, henom 20 kina, venamba, singthana hevna andranindmba, bisnisandra nona vewol viu, verava, kav provra. Doa os sandhalahangana. ");
INSERT INTO wrs_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Wo monglava indhanamba no pethanindva hemba musk vinivna, himba moa pinginna no kembellamba, himba temba ganamba, una, kava ningminivmoa hemba, osva kana kuwul wulluhunda. ");
INSERT INTO wrs_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Heva os owai, hemba doa mendekli kuwulalm awona, hev henga prona hevna kembellam. Doa hev unna andranindm, hom ambtok, kava nonglalm vev dim nom, ten kav yem daswolahanganam. Yimba es dumbna hengava senamba? ");
INSERT INTO wrs_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Mongo hevna andranindrini ophona, mendekli, yimba kamba 20 kina lerahona, wo kava yenisrava bisnisandra venamba, 200 kina kava dombna. ");
INSERT INTO wrs_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Doa kuwul omnana, lehra yimba besal andranindrini lohv. Yimba lehra hona andrava vena, eva mani mendekliandram kava yemba seilva omnanamma. Daipota kava yemba mendeklilm awov, si yimba kuwul 10pelara kembelnindna wulluhunvav. ");
INSERT INTO wrs_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Doa mongo hevna andranindrini ophona, mendekli, yimba kamba 20 kina lerahona, wo kava yenisrava bisnisandra venamba, 100 kina kava dombna. ");
INSERT INTO wrs_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Doa kuwul omnana, lehra, si yimba kuwul 5pelara kembelnindna wulluhunvav. ");
INSERT INTO wrs_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","21","Doa mongo hevna andranindrini ophona, mendekli, yimba kamba 20 kina lerahona, doa heva os kava ningekomandhana, nonamba bisnisandra venamoa yenisrava. Men yena diva. Kava yemba os nonglavna, yimba andral lohv, yimba ambo nis dombunv indhanana wohna osonnanamba. ");
INSERT INTO wrs_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","23","Doa kuwul omnana, yimba andranindrini sahoklal, yimba kamba os nonglavna ona, andral lohv a? Kava ambo nis dombunvma owalna wohva a? Yena moamba pevm ambo olhai, indhanakoklarini. Yimba doarava pevna nengavnangmba beswonamba vretava, yimba kana diva benkrava dembhatava kanasirava, wo ata senamba hohlol lohta, heva os owai, yimba sahonam vena. ");
INSERT INTO wrs_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","25","Doa kuwul unna no indhanam, no 20 kinaoa henaminioa livru, wo henom lerihu, ten 200 kina dombnam. Andranindva umnina, mendekli, es hevpa osva, himba 200 kina iav? ");
INSERT INTO wrs_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Kuwul unna, himba nomba mana emava iavrava, himba nomba si dombvav. Heva os himba nomba eskandva wulavrava mana emava, henamba vreivav, hevpa nis wohavav. ");
INSERT INTO wrs_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Doa no indhanamba temba kamba ovumnivnamba, kuwulalmba wulluhunilmba, hemoa hom wonambo, helvakomolm kana novra. ");
INSERT INTO wrs_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28"