﻿USE sofia;
DROP TABLE IF EXISTS sofia.wro_vpl;
CREATE TABLE wro_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES wro_vpl WRITE;
INSERT INTO wro_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Wundjaŋuru wḁląnu-wunia Jesu Christ, God Iŋko:lu. ");
INSERT INTO wro_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Ge wiri-wiri kauwi:ŋu tjo:lbądaia nąnja, Wai, wąląn ?ŋąra ŋaianąŋga kąŋaŋadjaŋuru mąnŋąle ŋunmiŋum, Aua kalumba ŋundjaŋąŋga pitja brar njeŋuru; ");
INSERT INTO wro_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Ŋąla-ŋąla iąruŋ jero:l gejiri bundul' dąnja, Brar wuriŋuru kalumba Inaiuri anąŋga, Tjuwąlja anąŋgaia tjḁdąŋuru irandju. ");
INSERT INTO wro_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","John keŋgunal, aua baptize ąŋgi:leri bundul' dąnja, ardi:um kulula baptism kulaŋąn kunja umąra wai wunja. ");
INSERT INTO wro_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Kariŋaŋuru aua nąnja tḁmbium mararawam Judaea nąrim, ardarawaia Jerusale' ŋąria; baptize kadiŋaieneri aua nąnja maro:lalim Jordan nąnja, umąra wunja arkanąŋga kubądbaŋgąlana. ");
INSERT INTO wro_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","John tai kąniŋaiena camel iwondimąlja, iŋwierlumba nąnja tjąŋgundja waiḁm, mindjąl kundjuŋiri durgenja, ŋi:nja. ");
INSERT INTO wro_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Aua ardi:um kulula kundjuŋiri, Pale ŋaiu keŋgal inaiud' ban dąga ŋaiu nąnja, irkąlja ierdunara nąnja nḁniọwu nąnuŋamiri wu ŋąnnumbąna waiel iŋąnŋuma wunja. ");
INSERT INTO wro_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Ŋaiu baptize njinji:la agu nąnja, aua pitja baptize njinji: Iŋandj Mąmaia nąnja. ");
INSERT INTO wro_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Gejau kuniŋaiena Jesu iŋgeŋgunal Nazareth i dągu Galilee nąnja, baptize kąniŋaiena John nąnja Jordan nąnja. ");
INSERT INTO wro_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Maiirgi:rkum ag' i dągu paibiri iŋgąninal, mąra kumbuna ąndjo:lu dalar kąmiena, Iŋandj kuluko:ka kądjindja jeri iŋgauwonal aua nąnja: ");
INSERT INTO wro_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Ŋąla-ŋḁla kunjąŋgunal ąndjo:l' di dągu, Ŋundju ŋunŋungula ŋedura ŋąnŋundjunu, tjukul ŋunana. ");
INSERT INTO wro_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Maiirgi:rkum Iŋandj kąŋaŋawu bundul' kuru. ");
INSERT INTO wro_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Bundul' dąnja kąnineri lewąra forty, ko:ndjuina Satan nąnja; adburaia nąnja kąnineri; wąląn-ŋaria kaueranawodjąŋa. ");
INSERT INTO wro_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Pąlejau John iŋganawi:na, Jesu keŋgunal Galilee nąnja, ardi:um kululeri wąląnu-wunia God nąri. ");
INSERT INTO wro_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Kundjuŋiri, Gejau ko:rug kumiena, bąndaia God anąŋga wodjulu kunuŋ: kuluŋąn njirwa, wąląnu-wunia purąŋudjareri. ");
INSERT INTO wro_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Tjanai iŋgeŋeri wo:ndum Galilee nąrim, mąra ko:nandu Simon a Andrew iwomale Simon anąŋga, net wo:ndu' ŋuru wai iŋgaiąbunandiri: djaia ŋąrandu iŋgąninandu. ");
INSERT INTO wro_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Jesu kundjuŋąnąŋgandu, Tjąrąmalandowandu, ŋaiu njinjandjuandu djaia ŋąrandu i:dja wunja. ");
INSERT INTO wro_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Maiirgi-rkum net kanmaŋgi:landi, kąmalandonandu. ");
INSERT INTO wro_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Pąląwurde irai iŋgeŋaŋuriri, mąra ko:nandu James Zebedee iŋko:lu a John iwomale, auandu kuda: namąndi nąnja iŋgąninandiri net njiriba iŋgeŋandiri. ");
INSERT INTO wro_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Maiirgi:rkum ai ko:nandu: kanmąngi: landu Zebedee iranąŋgandu namąndi nąnja ardawodjieja nąnja, kąmalandonandu. ");
INSERT INTO wro_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Capernaum dąra kariŋaŋuru; maiirgi:rkum Wunaiurujau dadjurdkąrim dąra keŋa, kaniiŋgundąla. ");
INSERT INTO wro_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Rąngąri kariŋa wuniiŋgundie anąŋga nąnja: gewunja kaniiŋgundąla iurulwora iŋgąnina, wiri-wiri-ŋąria kądjindja ŋuru-ŋuru. ");
INSERT INTO wro_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Maiirgi:rkum dadjurd-kąrim maninja kąnineri i:dja agula inuru kudai; ");
INSERT INTO wro_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","Aua jero:l kundjuŋu, kundjuŋiri, Ŋani kunjedjuna, ŋundju Jesu Nazareth ŋąra? Ŋunjąŋgunal ąŋąmąndju wunja? Laiburu ŋąnuŋąnu ŋundju ąŋguja ŋunŋunuŋ, Mąmaia ŋąra God anąŋga. ");
INSERT INTO wro_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Jesu aua kąmaiḁmbuna, kundjuŋiri, Kumuk minjo:, ba beŋgaldḁga. ");
INSERT INTO wro_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Agula inuru, dalar iŋgąmąn, ŋąla-ŋąla daraiu jero:l geŋiri, ba keŋgunaldąga. ");
INSERT INTO wro_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Ardarawaia rąngąri kariŋa, arge wurura burkai ąŋgaiąbieneri, kubądjuŋiri, Aŋudja wuna? Wuniiŋgundie wuŋunali! Iurulba kudai aua agulaia arduria kąmnjenaŋgori, arka ŋuru kaueraŋuru. ");
INSERT INTO wro_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Djo:jąn aua wunja kunjaŋanuru maiagekąriŋuru tąmbium mararawa' ŋuru Galilee wo:ri kumbąneri. ");
INSERT INTO wro_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Maiirgi:rkum, wuno:murum dadjurd-kąrim i dagam ba ąŋgeŋgunal, maiarum Simon a Andrew anąngandam dąra kariŋgunal, James a John kuda:. ");
INSERT INTO wro_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Simon kurumąnangąnja we njimbuneri lądja kundjuŋiri; maiirgi:rkum njąŋga wunja kubądjuŋunąŋga: ");
INSERT INTO wro_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Aua keŋgunal, njino:ri kuŋgaŋurula, brai nji:la; lądja njąngaiąndiwela, gejau njąŋga kanawodjąŋa. ");
INSERT INTO wro_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Kąlekąlem, mąrąŋunja njąŋgawona ŋuru, kanbąrkaŋurulaldąga ardarawaia adbaramareja, arka kuda: agulaia kudai. ");
INSERT INTO wro_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Malaiindem mararawam djaruk kadbiena maiamundu' nąnja. ");
INSERT INTO wro_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Aua kanmurduna ardarawaia ara ąŋgąnineri ardamalimbia ąŋganbąrwuneri, agulaia ardarawaia wai kandjąbuna; agulaia wa panąŋunja puŋgarwąluiri wunja, gewunja arka laiburu ąŋgąninanąŋga. ");
INSERT INTO wro_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Mąmąŋgunu, wunuŋgule lewąra wąli wa puŋganinja, bḁri kąnina, dąnde keŋaŋuru, tḁmbiu' ŋuru wugem keŋaŋuru, ma dadjurd kundjuŋiri. ");
INSERT INTO wro_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Simon, arka aua nąnja aŋgąnineri, kaueramalando:no iwondedba; ");
INSERT INTO wro_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Mąra kauero:na, kubadjuŋunąŋga, Ardarawaia ŋunbąrkąnjiro:jiri. ");
INSERT INTO wro_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Aua kundjuŋanąŋgori, Maiagekąri' ŋuru ŋąri:u, malaiindem maiakari' ŋuru, ma kuda: ardi:um ŋalu; gewunja wuna ŋanŋunjḁŋgunal. ");
INSERT INTO wro_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Dadjurd-kąrim arkanḁŋgam dąra keŋaŋuru Galilee mararawam iŋgeŋeri, ardi:um kululeri, agulaia wai kandjąbuneri. ");
INSERT INTO wro_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Leper kąmurka, burkai kaiąbuna, luŋgudja kąninanąŋga, kundjunąŋga, Ŋąmba tjuŋundjara, rarwa gole pąnjąngąndju. ");
INSERT INTO wro_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Ruluk iŋgamiena iŋgaieriwuna, ino:ri la mamąn, kąmąndanąla, kundjunąŋga, Korega ŋḁnuŋ, rarwa bąnu. ");
INSERT INTO wro_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Maiirgi:rkum leper mareja kaiąndiwela, rargara kandjuiena. ");
INSERT INTO wro_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Njadbama kundjuŋunąŋga, maiirgi:rkum kąŋadja:la, kundjunąŋga, ");
INSERT INTO wro_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","Manindj, i:dja pindjalunąŋgoriri kari:, baiuŋuru, dadjurd-kąra pąmiimbaienąŋga, rarwa ŋunŋunjandjuiena moia ąno: Moses geŋu, adąŋądjaieja wunja arka nąnja. ");
INSERT INTO wro_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","O! Aua keŋaŋuru wunmanbąli ŋąla-ŋąla djo:jąn djenbeŋuru kundjąbuneri, gewunja Jesu. kądjinba njele malaiindem pąndurąm dąra pąŋgeŋenja, dąnde wugem maninja kąnineri: maiagekąrim i dągam kaueramurkąla. ");
INSERT INTO wro_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Wuno: murum Capernaum njele dḁra iŋgena. pale kulunu wunŋąlu, njauul-njauul kuniŋaiena aua. maiaram maninja iŋgąnina. ");
INSERT INTO wro_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Ardarawaia djaruk kadbiena, ge ma kadiądi: na, balaium mano:rum, kari maiamundu' nąnja:. ŋąla-ŋąla kululanąŋgori. ");
INSERT INTO wro_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Kariŋa, kaueraŋuraldąga i:dja imareja iąlu,. mano: iŋgaŋurienal iąruŋuri nąnja. ");
INSERT INTO wro_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Wuno:murum wodjulu kądjinba pariŋgunjal peleŋgąraia wunja, maiarum malerdum ma. iŋgąnina pąlkąr madbąn; wuno:murum maŋgadjilelemala, jeri kaueriąbuna inarugu imareja weiŋgauwoneri ma. ");
INSERT INTO wro_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Jesu mąra ango:na arko wa paueraŋudjarenja, imareja iąlu kundjunąŋga, Woŋąląŋ, umąra. ŋundjanąŋga wai kundjąbieŋąnu. ");
INSERT INTO wro_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Atjąkekąria wiri-wiri ŋąria ma kadineri atją. ąŋgauwoneri arkulum maninja ni: ąŋgąnineri, ");
INSERT INTO wro_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","Aŋudjakunja indja wurunąŋgowa kundjiri? Djadi kundjiri: ąŋguja umąra gole puŋgaiąb ŋąmba wa iarun, God? ");
INSERT INTO wro_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Maiirgi:rkum Jesu iŋaui nąnja mąra kumbuna arkulum maninja ge ni: ąŋgąnineri, kundjunąŋgori, Aŋudjakunja wuna ni: njiduniri njirkulum maninja? ");
INSERT INTO wro_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Ŋąnąŋga wunia, Ŋąnŋundjunąŋga imareja iąlu, Umąra Ŋundjanąnga wai kundjąbieŋąnu; ŋąnŋundjunąŋga, Bḁri bąnu, ŋunarugu tjąrawąd minjąm, wudaua baiu? ");
INSERT INTO wro_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","O! Laiburu njirkunuŋ wunja I:dj' iŋko:lu wundjurulu kudai kabąlba nąnja umara wai kunja, (imareja iąlu kundjunąŋga). ");
INSERT INTO wro_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","Kuŋenu, Bari bąnu, ŋunarugu tjąrawąd minjam, maiaram nundjanąŋga' ŋuru baiuŋuru. ");
INSERT INTO wro_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Aua bḁri kąnina, maiirgi:rkum inarugu tjḁrawąd kumąŋ, keŋaŋuru ardarawaia adbąnŋąle ŋuru; gewunja ardarawaia rąngąri kariŋa, God kauero:do:dala, kubadjuŋiri, Wuna kądjinu wa mąra puŋarwi:nja. ");
INSERT INTO wro_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Njele keŋaŋuru pąlawąlula wo:ndum maninja; peleŋgąraia ardarawaia kauerąmurkąla, kaniiŋgundąla. ");
INSERT INTO wro_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Tjąnai iŋgeŋeri Levi Alphaeus iŋko:lu mąra ko:na, atja ingąnineri kaiug kąmąŋ manma, kundjunąŋga, Tjąnmalando:. Bḁri kąnina Kąmalando: na. ");
INSERT INTO wro_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Ge kuniŋaiena, atja iŋgauwoneri mindjąl geŋeri maiaram anąŋgam maninja, publicandia ardarawaia, arworia kuda: atją karwona Jesu nąnja inalalaia kuda:. ");
INSERT INTO wro_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Wiri-wiri nąria Pharisia ŋąria mąra iŋgarwuna aua mindjąl geŋeri arworia nąnja, publicandia nąnja, inalalaia kubadjuŋąnąŋgori. Mindjąl kundjiri, djo: keŋeri publicandia, arworia nąnja. ");
INSERT INTO wro_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Jesu nuru iŋgąnina kundjunąŋgori, Adbuludjia bąnmąndja wa lai parwonąŋga, adbąramareja lai karwonanąnga: wa pąŋengunjal ardinia ai kunja, O! arworia wunja. ");
INSERT INTO wro_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Inalalaia John anąŋgaia Pharisia arkanąŋgaia kuda: kadja-mindjieneri: kariŋgal kubądjunaŋga, Ḁŋudjakunja inalalaia John, Pharisia arkanąŋgaia kuda:kajamindjąŋa, ŋunalalaia wa padjamindjan? ");
INSERT INTO wro_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Jesu kundjuŋąnaŋgori, Aŋgo:lo:lia pąnąn ŋąria gole padjamindja pąnąnmoia arka nąnja iŋgąnuŋ? Pąnąnmoia arka nąnja ingąnun kądjinba padjamindjąn. ");
INSERT INTO wro_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Lewąra pitja njejeŋgal, pąnąnmoia eno: ŋguie arka nanja, gejau pitja arejamindjie lewąra ge nąnja. ");
INSERT INTO wro_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","I:dja kari wobi tjuwai ŋara wa jarkeba pąŋgeŋąn wobi inindiri nąnja: madji iŋąmano: kundju, kąno:ŋgu, iŋunala inindiri i dągu, kuniŋudba mawodjinim manuŋ. ");
INSERT INTO wro_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","I:dja kari wine iŋunąli wa pąngo:gulen waiḁm manindidba nąnja: madji wine waiąm dalar kąna pąmąm, gejau wine wundur pąŋgąnu, waiam kuda: :O! wine iŋunąla waiḁm maŋunąlam maninja. ");
INSERT INTO wro_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Gejau kuniŋaiena, Wunaiurujau yardba corn ŋarim rui kamąŋeri; inalalaia corn ri: iŋąmura kubądjuŋ wali aŋgeŋąŋuriri. ");
INSERT INTO wro_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Pharisia kubądjununaŋga, Wai! Anudjakunja Wunaiurujau kubądjiri ge wunia ŋuru-ŋuru? ");
INSERT INTO wro_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Aua kundjuŋąnąŋgori, Wawu puranindjenjiri David genu, ino:ra iŋgąnina, baia iŋgo:na, aua, arka aua nąnja kuda:? ");
INSERT INTO wro_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Dąra iŋgeŋanuru maiaram God anąngąm Abiathar gejau inaiuri dadjurd kąra, mindjąl geŋu wuro:dbori ąŋgąmiimbu ŋąra, aia wunia ŋuru-ŋuru mindjąl kunja dadjurd kąria ekamandj, ąŋgąno:na kuda: arka aua nąnja ąŋgąnineri? ");
INSERT INTO wro_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Gejau kundjuŋąnąŋgori, Wunaiurujau wondi kumbi:na i:dja wunja, kari i:dja Wunaiurujau wunja; ");
INSERT INTO wro_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Gewunja I:dj' iŋko:lu Wunaiurujau inaiuri kąnuŋanąŋga. ");
INSERT INTO wro_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Njele dadjurd-kąrim dara keŋa; ma i:dja kąnina ino:ri dalga kudai. ");
INSERT INTO wro_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Mu:n kauero:na, ŋąmba Wunaiurujau iŋgąmurdu wunja; de iŋgarwu wunja. ");
INSERT INTO wro_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Aua kundjuŋunąŋga i:dja ino:ri dalga kudai, Ma bowelge. ");
INSERT INTO wro_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Gejau kundjunąŋgori, Wunaiurujau wunia kunuŋ wunia ŋąnŋundju, woru ŋanŋundju? Iedjer iŋąngandju, bąda iŋąnŋumbu? Arka kumuk kubąrwuna. ");
INSERT INTO wro_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Wunjili:wa ąŋgo:na, ii:la iŋgąmąŋąnąŋgori arkulum burudum ąŋgąnineri, i:dja kundjunąŋga, Ŋuno:ri la mama. La mąmąŋ; ino:ri umulugu kuŋgandjuiena. ");
INSERT INTO wro_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Pharisia kariŋaŋuru, maiirgi:rkum kubąrwądeŋu aua wunja, ŋḁrunąŋgọwu iŋgadbalim. ");
INSERT INTO wro_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Jesu, inalalaia kuda: wo:ndu' ŋuru kariŋaŋuru; peleŋgąraia ardarawaia Galilee ḁlp kauerąmalando:na; Judaea ḁlp, ");
INSERT INTO wro_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Jerusalem alp, Idumea ḁlp, Jordan kanal' gąrim ḁlp, Tyre, Sidon ŋąrim alp, peleŋgąraia ŋuru karkaŋuruleri wunaiuru aua geŋu, kauerąmurkąla. ");
INSERT INTO wro_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Inalalaia kundjuŋąnąŋgori namąndi pidi:n iŋganana pelengąraia wunja, limbitja pauero: ŋąna; ");
INSERT INTO wro_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Ardarawaia ąŋgąmurduna; gewunja ardamalimbia ąŋgąnineri karwonanąŋga iŋgadbandana wunja. ");
INSERT INTO wro_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Agulaia, arduria, wuno:murum mąra iŋgarwuna, imąnŋąle ŋuru karwona, jero:l kubądjuŋ, kubąluleri, Ŋundju God ŋunŋungu:la. ");
INSERT INTO wro_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Njḁdbama kundjuŋąnąŋgori, Laiburu ŋąnŋuniŋaienu pąnjarandjuiri. ");
INSERT INTO wro_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Tḁląmbąn ŋuru pai kanina ŋuru, aua nąnja ai kanbu, arka ąŋąma gejiri; kauerąmurkąla. ");
INSERT INTO wro_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Twelve (ąnŋenŋąlja) kangandeŋu, aua nąnja ąŋgąnuŋ wunja, ąŋgaŋaŋawu wunja, ardi:um karwąluiri, ");
INSERT INTO wro_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Wundjurulu kudai wunja agulaia wai ąŋganbadjąb wunja; ");
INSERT INTO wro_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Simon iŋumba kuŋgandeŋu Peter; ");
INSERT INTO wro_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","James Zebedee iŋko:lu a John James ŋawanąŋga; auandu iŋumbandu kuŋgandeŋunąŋgandu Boanerges, gejąkawąli Mąlnirinja iŋko:landu. ");
INSERT INTO wro_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Andrew a Philip, a Bartholomew, a Matthew, a Thomas, a James Alphaeus iŋko:lu, a Thaddeus, a Simon Canaan ŋara, ");
INSERT INTO wro_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","Judas Iscariot kuda: aia tjiriwin iŋgo:na. ");
INSERT INTO wro_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Maiarum dąra keŋa. Peleŋgąraia njele djḁruk kadbieŋu, gewunja kadjinba mindjḁl puŋgadji:nja. ");
INSERT INTO wro_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Jḁligaia anąŋgaia wuno:murum ŋuru ąŋgąnina, kariŋa ŋuru laburd iŋgadba wunja, kubądjuŋ, Maro:wa kąnuŋ. ");
INSERT INTO wro_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Wiri-wiri-ŋąria arka Jerusalem i dągam jeri ąŋgawonal, kubądjuŋ, Aua Beelzebub kudai, agula inaiud' dąnja agulaia wai kandjąbiri. ");
INSERT INTO wro_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Ai kanbuna aua nąnja, bare-bare kundjuŋąnąŋgori, Ŋḁrunąŋgọwu Satan wai kaiḁb Satan? ");
INSERT INTO wro_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Bąndaia nąmba dalar kąmienu kaue ŋundju-ŋundju nąnja, bandaia ge kadjinba puŋgawelgen. ");
INSERT INTO wro_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Maiarum ŋamba dalar mąŋgąmieŋu maue ŋundju-ŋundju nanja, maiarum maue kądjinba pąmawelgen. ");
INSERT INTO wro_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Satan ŋąmba bḁri ingąnina aue ŋundju-ŋundju nąnja, aue kądjinba pąŋgawelgen, gole kaui kąniŋaieŋu. ");
INSERT INTO wro_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","I:dja kari maiarum iurulwora anąŋgam kądjinba dąra pąŋgeŋąn, wuląnbiri anaŋgaia wul ąŋgano:ŋgu wunja, ŋamba wa iurulwora auurle murd pąngamąn ŋąri, gejau maiarum anąŋgam wul-wul kąrim mąŋgandju. ");
INSERT INTO wro_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Nidji kuŋenuriri, Umąra darawa pitja wai njejąbienąŋgori i:dja ąŋgo:lo:lia, djadi darawa dja:di kadju; ");
INSERT INTO wro_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","O! Aua dja:di ge Iŋandj Mąmaia nąnja kądjinba wai puŋgaiąbienąŋga, umąra kądjinma ŋąri kundjiri; ");
INSERT INTO wro_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Kadjuŋu, Aua agula inuru kudai. ");
INSERT INTO wro_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Ma kariŋgal karanąŋgąnja, iwomomaleja kuda:; dąnde ąŋgawelgeŋiri, kaueraŋąŋawunąŋga, ai iŋgarwuna. ");
INSERT INTO wro_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Peleŋgąraia wo:ri kauero:neri, atją karwoneri, kubądjunąŋga, Wai! Ŋundju karanja, ŋunbomomaleja dąnde ŋunbąrkanjiro:jiri. ");
INSERT INTO wro_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Aua kandjo:lba, kundju, Aŋgu-ąŋguja ŋaiu karanja, ŋḁwomomaleja? ");
INSERT INTO wro_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Wunjili:wa kanbiri arka wo:ri iŋgarwuneri, atją ąŋgauwoneri, kundju, Wai! naiu karanja, ŋąwomomaleja. ");
INSERT INTO wro_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Gewunja aua ge God lai kauwonanąŋga, aia ŋḁwomale, ŋḁwomalinja, karanja. ");
INSERT INTO wro_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Tjilenda wun-man-bąli kaniiŋgundaleri wo:ndum pąlawḁlul' dąnja. Djąruk kadbiena aua nąnja peleŋgąraia djenbeŋuru, gewunja namąndi nąnja dąra kena, atją kauwona wo:ndum maninja; pelengąraia ardarawaia wo:ŋdum wodjulu kadina kabąiba nąnja. ");
INSERT INTO wro_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Darawa kaniiŋgundąla bare-bare nanja, kundjuŋąnąŋgori ąŋgąniingundaleri. ");
INSERT INTO wro_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","Nuru njidu; wai! tjaląngąnja ŋąra keŋaŋuru, Tjaląngąnja njąŋo:gule kundjuŋu; ");
INSERT INTO wro_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Ge kuniŋaiena, tjḁląngąnja njąŋgo:guleŋeri, ndjakekąrinja njąŋgari:na kalumba nanja, punaria wuŋo:ru ŋąria kariŋgunal, mindjḁl kubądjuŋanąŋga. ");
INSERT INTO wro_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Ndjakekąrinja njąngari:na kaiug bądąm maninja, ma kabąlba pidi:n dąka wąli; maiirgi:rkum ba wa kundjuŋal, kabąlba tjalani ŋuru-ŋuru pąngąngalb; ");
INSERT INTO wro_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Wuno-murum mąrąŋunja ba njiŋgengunal, wori kaŋuriena, wondudba ino:ra, iralga kandjuiena. ");
INSERT INTO wro_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Ndjakekąrinja njąŋgari:na wonąndja nąnja; wonąndja ba wa kubądjuŋal, limbitja kauero:neri, kurab kari wa bari pąŋgaiąndenja. ");
INSERT INTO wro_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Ndjakekąrinja njąŋgarima kabąlba mḁniam maninja, kurab bḁri kandjąndala, tjḁlanai kubądjuŋiri, karwongenjiri; bḁri kandjąndala, atjąkekąria 30, atjakekąria 60, atjąkekąria 100. ");
INSERT INTO wro_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Gejau kundjuŋu, Aua ini:um kudai ŋuru wunja, ŋuru kaninja. ");
INSERT INTO wro_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Wuno:murum auekama iŋgąnina, arka wo:ri iŋgarwuneri ąnŋenŋąlja nąnja, burkai kaueriąbuna bḁre-bḁre wunja. ");
INSERT INTO wro_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Aua kundjuŋanąŋgori, Njiri nanja kunauwi:na wundjąlgaie God ŋąri; arka nąnja dąnde nąria darawa kuniŋaieŋu bḁre-bḁre nąnja; ");
INSERT INTO wro_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Gewunja mąŋgadidjeri pąmadidja ŋąna, wa mąra pḁmarwun; ŋuru ąŋgąnuŋiri ŋuru padu ŋana, wa puŋgadenąn madji worarkar njele pądu ŋąna, wai puŋgaiąbienąŋgori. ");
INSERT INTO wro_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Kundjunaŋgori, Wawu laiburu pinjidin bḁre-bḁre wuna? Ŋarunąŋgọwu pitja laiburu njirąnu bḁre-bḁre darawa? ");
INSERT INTO wro_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Tjḁląngąnja ŋąra ŋąla-ŋąla ko:gulejiri. ");
INSERT INTO wro_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Andja kaduŋ arka kalumba nąnja, ma ŋąla-ŋąla ko:gulieŋu; wuno:murum ŋuru ąŋgąnina, maiirgi:rkum keŋgal Satan, kąno:ŋgu ŋąla-ŋąla ko: guliena arka nąnja. ");
INSERT INTO wro_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Arge kądjindjia ąŋgo:guliena kaiug bądąm maninja, arka ŋąla-ŋąla wuno:murum ŋuru ąŋgąnina, maiirgi:rkum tjukul ŋąria kubądba; ");
INSERT INTO wro_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Wondudba ardo:reja arge wurura, pulągajau kaduŋ; gejau murdądąr, wundjo:rie keŋgal ŋąla-ŋąla wunja, maiirgi:rkum idjuwa karwona. ");
INSERT INTO wro_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Atjąkekąria kaduŋ wonąndja nąnja ąŋgo:guliena; ąndja kaduŋ arka ŋąla-ŋąla ŋuru ąŋgąnina, ");
INSERT INTO wro_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","Murdądąr bąndaia ŋąri, wuŋgadjuie wuląnbiri ŋąri, tjąkąri lai kauwonąnąŋgori, dąra kunjąŋgal, ŋąla-ŋąla limbitja kumbu, kurab wuno:ra kuniŋaieŋu. ");
INSERT INTO wro_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Arka kaduŋ kabąlba mąniam maninja ąŋgo:guliena; arka ŋąla-ŋąla ŋuru karkaŋuru, kadba, kurab bḁri ąŋgaiąnda, atjąkekąria 30, atjakekąria 60, atjąkekąria 100. ");
INSERT INTO wro_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Njele kundjuŋąnąŋgori, Tjḁnaim maŋuriena maŋgandieŋu wunja waiuru kuni:n, waiuru inarugu, wawu ŋuwonu nąnja pḁmandienja? ");
INSERT INTO wro_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Gewunja kari kundjąlgiena, ŋąmba wa mąra puŋgauwi:n; kari mululu ŋḁri, ŋąmba wa lewąra njini puŋgeŋgal gąri. ");
INSERT INTO wro_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","I:dja ŋąmba ini:um kudai ŋuru wunja, ŋuru kąninja. ");
INSERT INTO wro_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Kundjuŋąnąŋgori, Maranindj ŋąnąŋga ŋuru wurąŋungaŋuru; kądjinu wurąŋungugule pitja njo:gulienuri; tjile pitja njḁnawi:nuri. ");
INSERT INTO wro_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Aua kudai, pitja njanawi:naŋga, aua ino:ra, pitja njḁno:ŋgienąŋga ge njini kudai iŋgąnuŋ. ");
INSERT INTO wro_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Kundjuŋu, Wuna kadjinu bąndaia God anąŋga, i:dja tjḁląnganja njąŋgo:gulejiri kabąlba nąnja; ");
INSERT INTO wro_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Kulunu iŋgąnuŋ, bari iŋgąnuŋ, wundugum lewąra, tjḁląngąnja ba pinjeŋąŋ pinjimbąnge ŋąna, ŋḁrunąŋgọwu wa laiburu pąŋgąnin. ");
INSERT INTO wro_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Kabąlba kurab bąri kaiąnda mauekama; jedmąŋgḁngule, imuŋga njini, gejau corn arąŋga njini imuŋga nąnja. ");
INSERT INTO wro_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Wuno:murum kurab iwidjara iŋganuŋ, maiirgi:rkum kuldjuru ko:gule, wulgundjiri gole keŋgunal. ");
INSERT INTO wro_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Kundjuŋu, Ŋḁrunąŋgọwu kądjinu workundju bąndaia God anąŋga? Bḁre-bḁre ŋḁnąŋga nanja workungugule? ");
INSERT INTO wro_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Kądjinu tjḁląngąnja ndjḁruŋ mustard, njiŋge, kabąlba nąnja njąŋgo:gulienu, pidi:n njinuŋ tjḁląngąnja njindarawa mandągąnja kabalba nąnja. ");
INSERT INTO wro_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Wuno:murum njąŋgo:gulieŋu, tjḁlanai kundju, njinaiud' ban dągąnja irululu darawa nąnja njiniŋaienu, njuŋgalalidjerudja njinaiudj njąŋgo:gulejiri, gewunja punaria wuŋo:ru ŋaria gole atją parwa djedba ma nąnja. ");
INSERT INTO wro_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Bare-bare darawa wuna kadjinu ŋąla-ŋąla kululanąŋgori, gole ŋuru ŋąna padu; ");
INSERT INTO wro_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Nąmba wa bare-bare nąnja wa puŋgenjanąŋgori; argekama inalalaia kanmiimbuneri. ");
INSERT INTO wro_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Lewara gejau kąle-kąlem njiŋgąnina, kundjunąŋgori, Kanal' guru ŋḁriuri. ");
INSERT INTO wro_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Peleŋgąraia ąŋganbądbąŋgi:la, kaueraŋuru arka nąnja, aua geŋida, namąndi nąnja. Namąndi tjąkekąri aua nąnja kuladi:na. ");
INSERT INTO wro_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Adjadjiri mandjum maiilworam meŋgal, pąląŋgąrinja namąndi dai njimbunal, gewunja namandi kąlabu kundjuŋiri. ");
INSERT INTO wro_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Aue ŋundju-ŋundju umbąnde nąnja kąnina, kulunu kąnineri bururu nąnja; kauero:lunda, kubądjunąŋga, Iniiŋgundeja, gole ŋarkḁriiŋiri, wawu djerara pąmąndjąmąn? ");
INSERT INTO wro_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Barele kąnina, mandjum mamaiḁmbuna, wo:ndum kundjuŋunąŋga, Abi:la, kąmuk bowi:. Mandjum wudun kundjuŋu, tjumulu njini kunina. ");
INSERT INTO wro_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Kundjuŋanąŋgori, Ąŋudja kunja njirkulguneŋiri? Weni wawą panjḁrąŋudjarąn ŋąri? ");
INSERT INTO wro_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Djenbeŋuru karkulgunenja, arge wurura kubądjuŋ, Indja ąŋguja, mąndjum a wo:ndum ŋuru iŋgarkaŋurandu? ");
INSERT INTO wro_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Wo:ndum kanal' gąrim madburkalal Gerasene kąlguwam. ");
INSERT INTO wro_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Wuno:murum namąndi i dągu ba iŋgeŋgunal, maiirgi:rkum kąmąndjerala pąndjąm i dągąm i:dja agula inuru kudai. ");
INSERT INTO wro_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Aua iŋgąnineri pąndjąm maninja; i:dja kari kądjinba njele murd pauerąmenja, kari tjąŋadjąŋ njiniŋge; ");
INSERT INTO wro_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Gewunja tjile-jile murd iŋgąmiena ilawondinja ŋąria njiniŋge a tjąŋadjąn njiniŋge, tjąŋadjąŋ dalar kadbiena aua nąnja, ilawondinja ŋąria kalelemina; i:dja kari wa dąrąngu pąŋgąninja iŋgamaiąmbu wunja. ");
INSERT INTO wro_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Kądjinma, wundugum a lewąra, pąndjąm maninja, tḁląmbąn nąnja, jero:l kundjuŋiri. dur kąnineri aue ŋundju-ŋundju kaiugu nąnja. ");
INSERT INTO wro_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Wuno:murum bọwąra Jesu mąra iŋgo:na, tjḁri kumąn luŋgudja kąninanąŋga. ");
INSERT INTO wro_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","Ŋąla-ŋąla daraiu jero:l kundjuŋu, kuluiri, Ŋąni ŋenu, Jesu, God karąŋ ŋąra mandj ŋunŋungu:la? Burkai ŋundjąb God nąnja, pąmbalọa puŋunareri. ");
INSERT INTO wro_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Gewunja aua kundjuŋanąŋga, Ba beŋgal, ŋundju agula ŋunuru, i:dja i dągu. ");
INSERT INTO wro_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Burkai kaiąbuna, Nunŋumba ŋḁnąŋga? Kundjunąŋga, Ŋḁŋumba Legion; ḁri ardarawaia arkunuŋ. ");
INSERT INTO wro_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Djenbeŋuru burkai kaiąbuna tąmbium ma i dągąm wai pandjiąbiri. ");
INSERT INTO wro_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Ma tąląmbąn manumbądba nanja kadineri wiriŋąria ardarawaia pig no:wa kadineri. ");
INSERT INTO wro_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Burkai kaueriąbuna, Pig nąnja ąnŋaŋawu, arka nąnja dąra arkunjąŋaŋuru wunja. ");
INSERT INTO wro_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Kanuŋu:la. Agulaia arduria ba kariŋgunal, pig nąnja dḁra kariŋaŋuru; wiriŋąria wo:nąŋgąli pąlja kubądjuŋuru wo:ndu' ŋuru, 2,000 (ardarawaia), idjąba kubądjuŋiri wo:ndum maninja. ");
INSERT INTO wro_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Arka barui ąŋganbądo roeri kubądaiila, malaiindem maninja bare-bare kadiŋaieneri; wuraląn' nąnja. Arka kariŋgunal mąra wunja ŋḁnąŋga wuna kąniŋaiena. ");
INSERT INTO wro_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Jesu kauerąmurkąla, Mąra kauero: aua agula kudai iŋgąnina, atja iŋgąnineri, tai iŋgąni:na, ini:um kudai, aua legion kudai iŋgąnina, karkulgunena. ");
INSERT INTO wro_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Arka mąra iŋgarwuna kubądjuŋąnąŋgori ŋąrunḁŋgọwu tjumąn kąmienanąŋga agulaia kudai iŋgąnina, pig wunja kuda:. ");
INSERT INTO wro_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Wun-man-bąli burkai kaueriąbuna maiamiŋgum arkananąŋgam i dągąm iŋgeŋuru. ");
INSERT INTO wro_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Namąndi nąnja dąra iŋgeŋaŋuriri aua agulaia kudai iŋgąnina burkai kaiąbuna, Atją ŋąrenandu kundjuŋanąŋga. ");
INSERT INTO wro_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Aua wa paŋgąnąŋu:nja, O! kundjununanga, Baiuŋuru maiaram ŋundjanąŋga' ŋuru, jḁligaia ŋundjanąŋgaia ŋuru, minjenąŋgori wunenaiuru Inaiuri geŋąnu, ŋuŋundjeriwuna. ");
INSERT INTO wro_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Aua keŋaŋuru, wun-man-bąli djo:jan kumąŋ Decapolis nąnja wunenaiuru Jesu geŋunąŋga; i:dja ardarawaia rąngąri kariŋa. ");
INSERT INTO wro_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Wuno:murum Jesu njele ŋurąk iŋgauwona namąndi nanja kanal' guru, peleŋgąraia ardarawaia djḁruk kadbiena aua nąnja; wo:ndum maninja wodjulu kąnina. ");
INSERT INTO wro_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Keŋgal iḁruŋ ardenaiuri nąnja dadjurdkąrim, iŋumba Jairu; mąra iŋgo:jiri, kauwona ierdu nąnja. ");
INSERT INTO wro_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","Djenbeŋuru burkai kaiąb, kundjiri, Pameranja pidi:nja ŋaianąŋgąnja kuŋgadjuiri; ŋunŋunjaŋgal, ŋuno:ri ndjąmąndana, njąŋgąmurdieŋu wunja, ndjedjed njiŋgąnuŋ. ");
INSERT INTO wro_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Keŋaŋurandu; peleŋgąraia djenbeŋuru kauerąmalando:na, ŋąndọa kadjaŋuriena. ");
INSERT INTO wro_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Woŋaiinja, njiŋge gulu: wo: kauwonanaŋgeri tjauądba manŋenŋalb, ");
INSERT INTO wro_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Darawa kąniŋaienanąŋga bąnmąndjia ardarawaia nąnja, darawa kanawunguleri ko:l geŋeri, njimulugu ŋuru-ŋuru wa pinjininja, duŋ njimbi: neri, ");
INSERT INTO wro_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Nuru njiŋgąnina Jesu wunja, peleŋgąraia nąnja iwelbam njeŋgunal, wobi anąŋga kąmąndanala. ");
INSERT INTO wro_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Gewunja kundjuŋu, Naiu ŋąmba iŋąnŋumandana wobi ekamandj, pitja ŋḁmulugu ŋewandjuie. ");
INSERT INTO wro_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Maiirgi:rkum dumbulu gulu: njąŋganąŋga djabąn kuniŋaiena; pąl njinina njąŋganąba nąnja njąŋgąmurduiena mareja njąŋganąŋgaia. ");
INSERT INTO wro_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Maiirgi:rkum Jesu, aue wurura laiburu iŋgąnina wundjurulu aua i dąga keŋaŋuru, worarkar kąnina peleŋgąraia nąnja, kundjuŋu, Aŋguja wobi ŋaianąŋga kąmąndanala? ");
INSERT INTO wro_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Inalalaia kubądjuŋunąŋga, Mąra kandjo: peleŋgąraia ŋąndọa ąŋgaŋurieŋąnu, Aŋguja ŋąnmąndanala kundjiiri? ");
INSERT INTO wro_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Aua wunjili:wa kanbuna, mąra njaŋo: kundjuŋu njąŋga wuna geŋu. ");
INSERT INTO wro_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Woŋaiinja, njiŋgulgunineri djedjerara njiŋgąnineri, laiburu njiŋgąnineri kąniŋaienanąŋga, njeŋgunal njimbąna imąnŋąle ŋuru, darawa nidji kundjuŋunąŋga. ");
INSERT INTO wro_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Aua kundjuŋunąŋga, Pąmeranja, wa pąnjąnŋudjarąn ŋąri, ŋumulugu ŋungandjuna; abi:la baiu, ŋumulugu bąnu mareja ŋundjanąŋgaia. ");
INSERT INTO wro_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Wąli kaluleri, kariŋgal maiaram i dągam inaiuri dadjurdkąrim anąŋgam, kubądjiri, Ŋundju pąmerinja gole njimąn; ąŋudja kunja iniiŋgundeja njele kąndjąŋąliŋgeri? ");
INSERT INTO wro_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","O! Jesu ŋąla-ŋąla kaluiena ŋuru iŋgąnina, inaiuri dadjurd-kąrim kundjunąŋga, Puŋungulgunejiri, pąnjąnŋudjareri. ");
INSERT INTO wro_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","I:dja kari wa panąŋu:nja pauerąmalando: jiri aua nąnja, Peter a James a John James iwomaleja argekama. ");
INSERT INTO wro_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Maiaram inaiuri dadjurd-kąrim anąŋgam maŋgadburkal; njḁnini kadjuŋiri mąra kanbiri, wolawuri ąŋgąnineri, kanbądemeri. ");
INSERT INTO wro_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Wuno:murum dąra iŋgeŋą, kundjunaŋgori, Aŋudja kunja njḁnini kuriiri, wolawuri njidiŋiri? Woŋąląŋunja njimąn wa pinjinin, mi:a we njimbąneri. ");
INSERT INTO wro_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Arka djerai kaueraŋurula. Aua, ardarawaia dąnde woląmbąra ąŋgo:na, kanmura woŋḁląŋunja iranąŋga, karanąŋgąnja, arka aua nąnja ąŋgąnineri, dąra keŋa njiŋgąninum woŋąląŋunja. ");
INSERT INTO wro_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Woŋąląŋunja njino:ri kumąŋ, kundjunąŋga, Talitha cumi; ge jąka wąli, Woralinja, kuŋenu, bḁri bąnu. ");
INSERT INTO wro_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Maiirgi:rkum woralinja bḁri njinina, wudawa njeŋa; tjauądba manŋenŋal' kąri njinina. Arka maiirgi:rkum rąngąri kariŋa djenbeŋuru. ");
INSERT INTO wro_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Njadbama kundjuŋąnąŋgori, I:dja kari wuna wa laiburu padinja; kundjuŋu, Njirano: mindjąl geja. ");
INSERT INTO wro_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Ma i dąba keŋaŋuru; kąlguwam anąŋgam mamurkal; inalalaia kauerąmalando: ");
INSERT INTO wro_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Wuno:murum Wunaiurujau kąnina, wun-man-bąli kaniiŋgundaleri dadjurd-kąrim maninja. Ardarawaia ŋuru iŋgarkaŋurula rąngąri kariŋa, kubądjuŋiri, I:dja indja ŋḁmbula wa wuna kudai? Aŋudja wuna wuni:ndjąru kąnauwi nanąŋga i:dja indja, wundjurulu dara ino:ri nąnja kauwi:na? ");
INSERT INTO wro_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Wawu indja tjumąndjamąndja, Mary ibanąŋga, ŋawaia James a Joses a Judas a Simon? Nawawanaŋgąnja ŋurama ŋḁri nąnja wawu padin? Kauwai kariŋanąŋga. ");
INSERT INTO wro_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Jesu kundjuŋąnąŋgori, Tjo:lbąda ioimaląn ino:ra wa pąŋgąnin, ŋąmba wa kąlguwam anąŋgam maninja, aue madeja nąnja, maiarum anąŋgam maninja. ");
INSERT INTO wro_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Ma wundjurulu dara kądjinba pungenja, adbamarejamandj kaduguja ino:ri kanmąndanala, kanmurduna. ");
INSERT INTO wro_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Rąngąri keŋa iŋgarkudjarala. Maiarundjeruŋum wo:ri kanbuneri, kaniiŋgundaleri. ");
INSERT INTO wro_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Ąnŋenŋąlja ai kanbuna aua nanja, wun-man-bali kanŋaŋawuneri iḁruŋandu, iḁruŋandu; wundjurulu ka:no:na agulaia arduria nąnja. ");
INSERT INTO wro_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Kundjuŋąnąŋgori, Kari puraŋuriri wuda:wa ąŋgeŋaŋuriri, tjąndur' ekama; wuro:dbori kari, widi kari, kaiug kari widi nąnja; ");
INSERT INTO wro_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Ardjerdu nąnja ardjerdu ŋąri; wobi iaruŋandu tai pinjidinjiri. ");
INSERT INTO wro_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Kundjuŋąnąŋgori, Maiagekąrim maiarum dąra njirkunjąŋa, ma atja njidu ma i dągam njirkunjąŋaŋuru njini. ");
INSERT INTO wro_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Tḁmbium maiagekąrim njiri wa pitja pinjinmąn ŋąri, wa pitja ŋuru pinjingaŋurun ŋąri, wuno:murum ma i dągam njirkunjąŋaŋuru, tjurnim njidjerdu waiuru djeradjera maro: wunuŋądjaie arka nąnja. ");
INSERT INTO wro_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Arka karinanuru, ardi:um kubalula kuluŋąn kunja. ");
INSERT INTO wro_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Agulaia ardarawaia wai kanbądjąbuna, ardarawaia adbamareja oil njiniŋge kanbądja:mala, kanbądburduna. ");
INSERT INTO wro_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Herod inaiuri ŋuru kaŋurula; iŋumba laiburu kąniŋaiena, aua kundjuŋu, John Baptist bḁri kąnina imąndj i dąga, gewunja wundjurulu wuna aua nąnja ŋu:na kunuŋ. ");
INSERT INTO wro_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","O! Atjakekąria kubądjuŋ, Elijah kąnuŋ, Atjakekąria kubądjuŋ, tjo:lbąda kąnuŋ, iaruŋ tjo:lbądaia kądjindja. ");
INSERT INTO wro_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","O! Herod ŋuru iŋgaŋurula kundjuŋu, John, imri: ŋaiu dur ŋḁnŋumbuna, bḁri kąnina. ");
INSERT INTO wro_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Herod aue ŋundju-ŋundju kanŋaŋawuna, John kąmąŋ, murd kḁmąŋ bur kąrim maninja, Herodias wunja, Philip ŋawanąŋga mąŋgąnąŋganja; njiŋge pilin njąŋgawonanąŋga. ");
INSERT INTO wro_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","John Herod geŋunąŋga, Wunia ŋuru-ŋuru ŋundju kudai ŋawalo:lidj. mąŋgąnąŋgąnja. ");
INSERT INTO wro_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Herodias njiŋge ŋąnda njimaienanąŋga, Bąda iŋo;, kundjuŋu; kądjinba puŋgenja; ");
INSERT INTO wro_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Gewunja Herod John ko:lgunąla, laiburu iŋgąninanąŋga aua i:dja iḁduŋuru, mąmaia iŋgąnina, imuludja kaŋurula. Wuŋo:murum ŋuru iŋgaŋurula, darawa kundjuŋu, tjukul ŋuru kaŋurula. ");
INSERT INTO wro_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Wuniajau kąniŋaiena, Herod kuli:ndjiau, mąŋąri ardaiuri kangandjuna ardenaiuri anąŋgaia wunja, mąnŋąle-ŋąria anąŋgaia wunja, i:dja ardenaiuri Galilee ŋąria wunja. ");
INSERT INTO wro_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Herodias ibąnąŋgąnja dąra njiŋgeŋgunal, djor geŋu, Herod tjukul kandjuna, arka kuda: mąŋąri nąnja atja ąŋgauwoneri; inaiuri njimbąridja kundjuŋunąŋga, Tjḁniau ąŋudja ŋąma tjuŋundjiri, pitja ŋunjano:. ");
INSERT INTO wro_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Tjauaien kundjuŋunąŋga, Ŋąnąŋga tjąnŋuniau, pitja ŋunjano:, bąndaia ŋaianąŋga wulemi njini. ");
INSERT INTO wro_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Njąŋga dąnde njeŋaŋuru, karanąŋgąnja kundjuŋunąnga, Aŋudja iŋąniau? Njąŋga kundjuŋu, John Baptist imri:. ");
INSERT INTO wro_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Maiirgi:rkum dąra njeŋgunal inaiuri nąnja, kąniauwuna, kundjuŋiri, Ŋąma kuŋe tjḁnŋuno: weni ąŋgąm maninja John Baptist imri:. ");
INSERT INTO wro_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Inaiuri pakul djenbeŋuru kąnina; mia tjauaien geŋunąŋga, arka wunja mąŋąri nąnja atją ąŋgauwoneri, kądjinba pinjingąriinja. ");
INSERT INTO wro_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Maiirgi:rkum inaiuri mąląniŋara kaŋaŋawuna mu:n-ŋąria nąnja, kundjuŋu imri: tjuŋungaŋural; aua keŋaŋuru imri: dur kumbuna bur-kąrim maninja. ");
INSERT INTO wro_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Imri: anąŋga ąŋgąm maninja kungaŋurulal, njimbąridja njino:na; njimbąridja karanąŋgḁnja njino:na. ");
INSERT INTO wro_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Wuno:murum inalalaia ŋuru ąŋganina, kariŋgunal, durgu tjḁrawąd kubądbąŋ, pąndjąm maninja kubąrkandeŋu. ");
INSERT INTO wro_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Arkaŋawieja djḁruk kadiŋaiena Jesu nanja; darawa kubądjuŋunąŋga ge kadjuŋu, ge aŋganbądiiŋgundala. ");
INSERT INTO wro_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Aua kundjuŋąnaŋgori, Njirge wurura njidjurliŋgal wugem ŋuru, wąli ŋoiba njidu. Gewunja ardarawaia djo:lio:li kubądjuŋiri, ŋoiba wa puŋgąninjanąŋgori mindjḁl kunja. ");
INSERT INTO wro_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Kariŋaŋuru namąndi nąnja wugem ŋuru pąlawąde. ");
INSERT INTO wro_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Mara kanbąrwuna aŋgeŋaŋuriri, ardarawaia laiburu kadina, ma ŋuru pąlja kubadjuŋ ardjerdu i dągu malaiindem mararawam i dągąm, wuk kanbąrwuna. ");
INSERT INTO wro_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Aua ba keŋgunal peleŋgąraia djenbeŋuru mara kanbuna, kandjeriwuna, ąŋgąnineri kukundjeria kądjindjia kukundja-ŋąra ardo:reja; wunman-bali kaniiŋgundaleri. ");
INSERT INTO wro_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Lewąra wundur kąnina, inalalaia kauerąmurkala, kubądjuŋ, Tḁmbium mḁna wugem, lewąra weni wundur kunina; ");
INSERT INTO wro_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Anŋaŋawu, ąŋgeŋuru wunja tḁmbiu' ŋuru maiarindjeruŋu' ŋuru wo:ri mąŋgarwiri, ąŋgąmura wunja mindjḁl kunja. ");
INSERT INTO wro_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","O! Kandjo:lbala kundjuŋąnąŋgori, Njiri arano: mindjḁl kunja. Arka kubḁdjunąŋga, Arejuŋuru, ąnjerąmura wuro:dbori kaiug darawa ŋąri, ąnjerano: mindjḁl kunja? ");
INSERT INTO wro_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Aua kundjunąŋgori, Wuro:dbori wodi ardarawaia njiri kudai? Njiriu, aranindj. Wuno:murum laiburu ąŋgąnina, kubḁdjiri, Ąnŋąlja, djaia iąrunandu kuda:. ");
INSERT INTO wro_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Kundjuŋąnąŋgori ardarawaia atją wunja wiri-ŋąria nąnja tjo:lilia nąnja. ");
INSERT INTO wro_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Atją karwona tjudu karwiineri, hundred nąnja, fifty nąnja. ");
INSERT INTO wro_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Wuro:dbori ąnŋąlja, djaia iḁruŋandu kḁnmąŋ, ąndjo:l' kuru kąle kąmurkąla, wunia kulula, wuro:dbori kalemala; inalalaia ka:no:na adbąnŋąle ŋuru ąŋganbąrkugule wunja; djaia iḁruŋandu dalar kundjuŋąnąŋgandu arka nḁnja. ");
INSERT INTO wro_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Ardarawaia mindjąl kubądjuŋ, barui kadawi:na. ");
INSERT INTO wro_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Ilelemi tjḁrawąd kubądbąŋ, tjuŋgurlu wunŋenŋąlu, djaia ŋąri kuda:. ");
INSERT INTO wro_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Arka wuro:dbori mindjḁl kadjuŋu i:dja 5,000 kadina. ");
INSERT INTO wro_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Maiirgi:rkum inalalaia kundjuŋąnąŋgori namąndi dąra ąŋgeŋuru wunja, arkurle ąŋgeŋuru kanal' kuru Bethsaida ŋuru, wąli peleŋgąraia ąŋaŋaŋawu kundjiri. ");
INSERT INTO wro_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Pale ąŋgaiąndiwela, keŋaŋuru tḁląmbąn ŋuru dadjurd kunja. ");
INSERT INTO wro_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Kąlekąlem njiŋgąnina, namḁndi wo:ndum puląga nanja kunina, aua iḁruŋama kabalba nąnja kąnina. ");
INSERT INTO wro_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Mąra ąŋgo:na idjąba kadjuŋu, kar kadjuŋeri, gewunja mḁndjum baruba ąŋgo:neri, wulo:lum pulągajau kanmurkal, wudawa iŋgeŋeri wo:ndum maninja; tjḁnai ŋejunąŋgori kundjuŋu; ");
INSERT INTO wro_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","O! Arka mąra iŋgarwuna wudawa iŋgeŋeri wo:ndum maninja, iŋandj ŋali kubądjuŋ, jero:I kubądjuŋ; ");
INSERT INTO wro_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Ardarawaia mąra iŋgarwuna iląla kadina. Aua maiirgi:rkum kululanąŋgori, kundjunąŋgori, Tjukul njidu; ŋaiąkawąli, pinjirgulgunejiri. ");
INSERT INTO wro_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Pai kąnina ŋuru arka nuru namąndi ŋuru; mąndjum wudun kundjuŋu; arge wurura djenbeŋuru rąngąri kariŋa; ");
INSERT INTO wro_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Wa puŋgadenenja wuro:dbori wunja, arkulum burudum. ");
INSERT INTO wro_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Wuno:murum ŋurąk ąŋgauwona, bąndaia madburkalal Gennesaret nąnja, palul' dąnja murd kubadbąŋ. ");
INSERT INTO wro_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Namąndi nąnja ba ąŋgeŋgunal, maiirgi:rkum laiburu kadinanąŋga. ");
INSERT INTO wro_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Tjąri kubądbąŋ tḁmbium ma mararawam wo:ri mąŋgarwuneri, wun-man-bḁli adbamareja mano: kanbąrkaŋuruleri, ma ŋuru ąŋgąnina aua iŋgąnina. ");
INSERT INTO wro_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Ma dąra iŋgeŋgunal, maiarundjeruŋum, malaiindem, wugem, adbamareja we kanbąri:la tjau-ŋąrim maninja, burkai kaueriąbuna iŋgadbąndana wunja. iamiŋgum wobi anąŋga mandj; arka iŋgadbąndanala adbuludja karkandjuiena. ");
INSERT INTO wro_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Djḁruk kadbienanąŋga Pharisia, atjąkekąria wiri-wiri-ŋąria kuda:, Jerusalem i dągu ąŋgeŋgunal, ");
INSERT INTO wro_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Mara ąŋganbąrwuna atjąkekąria inalalaia maia arkanąŋga mindjąl kadjuŋu ardo:ri muramąna bądaia, gejąkawąli wa kulai puŋgarwi:nja. ");
INSERT INTO wro_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Gewunja Pharisia, Jew ardarawaia kuda:, ardo:ri ŋąmba wa njḁdbama kulai puŋgarwun ŋąri, wa mindjąl puŋgadjin, wunindi:ru mababaia arkanąŋga karkaŋuru; ");
INSERT INTO wro_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Tjau-ŋąrim idągu ąŋgeŋgal, nąmba wa kulai puŋgarwun ŋąri, wa mindjal puŋgadjin; darawa tjḁkekąri kuda: kunuŋ, kadbąŋ karka-ŋuru wunja, njḁligąnja, karega, ąŋgąm kulai ąŋganbąrwu. ");
INSERT INTO wro_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Pharisia, wiri-wiri-ŋąria kuda: burkai kaueriąb, Aŋudjakunja ŋunalalaia wa pareŋąn wunindi:ru mababaia arkanąŋga nḁnja, maia arkanąŋga mindjąl kadju ardo:ri muramḁna? ");
INSERT INTO wro_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Aua kundjuŋąnąŋgori, Tjḁdąm Isaiah tjo:lba kundjuŋu njiri wunja, njidbiŋum njiljaljadbune, kądjinu wiri-wiri kauwi:ŋu, Worumba ąndja ŋuru ŋḁnbąrkaŋuru ardjalim njiniŋgem, Arkaui bọwora ŋai' i dągu kunuŋ. ");
INSERT INTO wro_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Mąljąm luŋgu-luŋgudja kubądbara, Ąŋganiiŋgunderi ŋąla-ŋąla i:dja arkanąŋga. ");
INSERT INTO wro_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Ŋąla-ŋąla God anąŋga kurąmąŋgi, wunindi:ru i:dja arkanąŋga kuraŋuru. ");
INSERT INTO wro_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Gejau kundjuŋanąŋgori, Tjḁdąm ŋąla-ŋąla God anąŋga wai kuriąb, wunindi:ru njirkanąŋga wurąŋungaŋuru. ");
INSERT INTO wro_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Gewunja Moses kundjuŋu, Nuru aŋurandu iro:lidj, nundju karanja; aua woru ge iranąŋga wunja, karanaŋgąnja wunja, nidji debad keŋenja; ");
INSERT INTO wro_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","O! Njiri kuri:, I:dja ŋąmba genąŋga iranąnga, karanąŋgąnja, Ge ŋąmba tjuŋunjąm naiu ŋąri Corban kunuŋ, gejąkawąli God ŋąri kunauwi:ŋu; ");
INSERT INTO wro_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Njiri wa pinjinąnun aua genangandu iranąŋga, karanąŋgąnja; ");
INSERT INTO wro_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Ŋąla-ŋąla God anąŋga wunąmiaru kurandju wunindi:ru njirkanąŋga nąnja wurąŋuno:na; darawa tjąkekąri kądjinu kuri:. ");
INSERT INTO wro_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Peleŋgąraia njele ai kanbuna aua nąnja, kundjuŋąnąŋgori, Nuru tjąraŋuru, njidarawa, wuranena; ");
INSERT INTO wro_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Kari i:dja dḁnde ŋąri, dąra keŋanąŋga kądjinba muramąna bąda pąŋgandjun; ge keŋgal i:dja i dągu, ge muramąna bḁda kandju. ");
INSERT INTO wro_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","I:dja ŋąmba ini:um kudai ŋuru wunja, ŋuru kąninja. ");
INSERT INTO wro_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Wuno:murum maiarum dąra iŋgena peleŋgąraia i dągu, inalalaia burkai kaueriąbuna bḁre-bḁre wunja. ");
INSERT INTO wro_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Aua kundjuŋąnąŋgori, Njiri kuda: wa puranenḁn wurunąŋgọwu kuda:? Wawu mąra puro:n, ge dąnde ŋari i:dja dąrą keŋa, muramąna bḁda kądjinba pąŋgandjun; ");
INSERT INTO wro_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Gewunja ini:um maninja wa dąra puŋgeŋąn, iŋulum maninja dąra kunjąŋa, dąnde kunjaŋuru wai kunja? Mąŋąria ardarawaia rar gąria kangąndjuna. ");
INSERT INTO wro_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Kundjuŋu kuda:, Ge i:dja i dągu keŋgal, ge i:dja muramąna bąda kandju. ");
INSERT INTO wro_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Gewunja mamulbą i dągu, i:dja ini:um i dągu, kunjąŋgal ni: woru, wurni-wurni, maneba, wurkemąnma, ");
INSERT INTO wro_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","Wuri-wuri, albąnda, woru, wuŋgądjuie, worago:ra, ambula woru, jaum, iamuroi, woŋąla; ");
INSERT INTO wro_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Wuna darawa woru mamulba i dągu kunjąŋgal, i:dja muramąna bąda kandju. ");
INSERT INTO wro_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Ma i dągu bḁri kąnina, keŋaŋuru maiamiŋgu' ŋuru Tyre a Sidon. Maiarum maninja dąra keŋa, I:dja kari laiburu padara kundjuŋu; O! kądjinba pąŋgaielgaienja. ");
INSERT INTO wro_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Maiirgi:rkum woŋaiinja, ibąnąŋgąnja pidi:nja agula inuru kudai, ŋuru iŋgaŋurula, njeŋgunal, ierdu nąnja njimbąna. ");
INSERT INTO wro_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Woŋaiin' njiŋge Greek njinina, Syrophoenician njąŋga madeja. Burkai kaiąbuna agula ibąnąŋgąnja wai iŋgaiąbunąŋga wunja. ");
INSERT INTO wro_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Aua kundjuŋunąŋga, Woŋąlaląŋuja arkurle barui kadawi:nja; wunia ŋuru-ŋuru maia woŋąlaląŋuja arkanąŋga ąŋganbądo:ngu wunja, kąnąŋguria ąŋganbądo:naŋgori. ");
INSERT INTO wro_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Njąŋga kaio:lbąla, kundjuŋunąŋga, Jau, Inaiuri, mia kąnąŋguria pąlalo:nma waiuru arkindjia woŋąlaląŋuja arkanąŋgaia mindjḁl kubądjunąngori. ");
INSERT INTO wro_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Aua kundjuŋunaŋga, Ŋąla-ŋąla wuna tjuŋundjuŋu, ŋundjuweja baiuŋuru, agula ibąnja njąŋgaiąndiwela. ");
INSERT INTO wro_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Njeŋaŋuru maiarum njąŋganąŋga ŋuru, woŋąląŋunja mąra njimbuna we njąŋgawoneri njinarugu nąnja, agula njąŋgaiąndiwela. ");
INSERT INTO wro_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Njele keŋaŋuru maiamiŋgum Tyre i dagu, Sidon bulumąn keŋa, wo:ndum Galilee ŋuru, pulaga ŋuru maiamiŋgum Decapolis. ");
INSERT INTO wro_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Kaueraŋuraldąga iḁruŋ wombąria, ŋąla-ŋala iamidj; burkai kaueriąb ino:ri aua nanja iŋgamąndana wunja. ");
INSERT INTO wro_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Kawai kąmąŋ peleŋgąraia i dągu iḁrun, ino:ri ini:um maninja kuŋgandeŋu, tjipa: kundjuŋu, ambula kąmąndanalanąŋga; ");
INSERT INTO wro_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Andjo:l' kuru kale kundjuŋu, ŋoi kundjabuna, kundjunąŋga, Ephphatha, gejakawali, Lei kuniŋaienjąnu. ");
INSERT INTO wro_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Ini:um lei maniŋaiena, tjilwanja ąnbula burąŋgai njimaiena, tjḁdąŋuru kulula. ");
INSERT INTO wro_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Kundjuŋąnąŋgori i:dja kari piriinąŋgoriri; O! tjile geŋunąŋgori, tjilenda njele kubądjuŋ. ");
INSERT INTO wro_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Djenbeŋuru rąngąri kariŋa, kubądjuŋiri, Aua darawa wunia kundjuŋu; wombąria nuru wunja kandju, iamidj kalu wunja kandju. ");
INSERT INTO wro_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Gejau peleŋgąraia djenbeŋuru njele ąŋgąnina, ardo:reja mindjḁl kunja, inalalaia ai kanbuna aua nąnja, kundjunąŋgori, ");
INSERT INTO wro_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","Peleŋgąraia ka:ŋaieriwu, ŋaiu nanja weni lewara tjḁruŋuri ąŋgąnina, ardo:reja mindjḁl kunja; ");
INSERT INTO wro_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Aŋgaiamindjąŋa ŋąmba aŋąnŋaŋawu tḁmbium arkanaŋga' ŋuru, kalumba nąnja jaŋgo: pitja pare, atjąkekąria arka nąnja pąlawurde kariŋgunal. ");
INSERT INTO wro_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Inalalaia kauerio:lbąla, Ŋḁrunąnŋgọwu i:dja ąndja barui kanbado: wuro:dbori ŋuru wugem maninja? ");
INSERT INTO wro_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Aua burkai kandjąbuna, Wuro:dbori wod' irarawaia njiri nąnja? Kubądjuŋ, seven (ąnŋenŋąlja). ");
INSERT INTO wro_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Peleŋgąraia kundjunąŋgori, Atja njirwa kabąlba nąnja. Wuro:dbori ąnŋenŋąlja kanmąŋ, wunia kulula, ko:lemala, inalalaia ka:no:nanaŋgori adbąnŋąle ŋuru ąŋganbąrkande wunja; arka peleŋgąraia adbąnŋąle ŋuru kanbąrkandeŋu. ");
INSERT INTO wro_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Djaia iḁruŋuri pidi:ndjia kuda: arka nąnja kadina; wunia ka:lulanąŋgori, kundjuŋu, Arka kuda: adbąnŋąle ŋuru a:rande. ");
INSERT INTO wro_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Mindjal kubądjuŋ, barui kubądjuŋ; tjḁrawad kanbadbąŋ arki:ndjiŋindjia arli:wa ąŋgeneri tjuŋgurlu seven (wunŋenŋąlu). ");
INSERT INTO wro_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Arka kadina kądjinu four thousand, (djenbeŋuru); gejau kanŋaŋawuna. ");
INSERT INTO wro_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Maiirgi:rkum namąndi dąra keŋa inalalaia kuda:, tḁmbium Dalmanutha madburkalal. ");
INSERT INTO wro_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Pharisia ba kariŋgunal, wunmanbąli burkeba kaueriąbuna, kubąrkąnjiro:nanąŋga umiimbaie ąndjo:l' di dągu, kauero:ndjuneri. ");
INSERT INTO wro_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Ŋoi kundjąbuna wunaiuru iŋaui nąnja, kundjiri, Aŋudjakunja woi madberi ąndja umiimbaie kubąrkąnjiro:? Nidji kuŋenuriri, umiimbaie kari woi madberi ąndja wa puŋgano:wienąŋgori. ");
INSERT INTO wro_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Kandjąndiwela, njele namandi dąra iŋgeŋa keŋaŋuru kanal' kuru. ");
INSERT INTO wro_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Woŋąla kadina wuro:dbori ąŋganbądba wunja; namąndi nąnja arka nąnja ardo:reja wuro:dbori iḁruŋ ekamandja. ");
INSERT INTO wro_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Kundjuŋąnąŋgori, Maranindj, li:a marąm leaven Pharisia arkanąŋga, leaven Herod anąŋga. ");
INSERT INTO wro_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Arge wurura kubarwadeŋu kubądjuŋiri, Gewunja wuro:dbori ŋądo:ra. ");
INSERT INTO wro_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Jesu mąra ko:na kundjunąŋgori, Ąŋudjakunja njirwadejiŋiri, wuro:dbori njido:ra? Wawu puranindjąn, puranenąn? Njirkaui burudu? ");
INSERT INTO wro_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Njirkumbula kudai, wawu puranindjan? Njidi:um kudai, wawu ŋuru pinjidin? Wawu ni: puraŋurun? ");
INSERT INTO wro_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Wuro:dbori five, (ąnŋąlja), ąŋąnŋalelemala five thousand, (ardarawaia), nąnja, tjuŋgurlu wodi darawa arkindjiŋindjia tjḁrawąd kurąmaŋ? Kubądjunąŋga, Twelve, (wunŋenŋąlu). ");
INSERT INTO wro_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Seven, (ąnŋenŋąlja), four thousand, (ardarawaia) nąnja, tjuŋgurlu wodi darawa arkindjinindjia tjḁrawąd kurąmąŋ? Kubadjunąŋga, Seven, (wunŋenŋąlu). ");
INSERT INTO wro_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Gejau kundjuŋąnąŋgori, Wąli wawu puranenan? ");
INSERT INTO wro_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Bethsaida madburkalal. Ambulidj kaueraŋuraldąga, burkai kaueriąb iŋgąmąndana wunja. ");
INSERT INTO wro_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Aua ambulidj ino:ri laburd kąmąŋ, maiarindjeruŋ' i dągąm kaŋurula; ambula tjipa: iŋgo:na, ino:ri iŋgąmąndanala, burkai kaiąbuna, Koru mandjanindj? ");
INSERT INTO wro_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Aua ąle kundjuŋu, kulula, I:dja mara ka:no:; mara ąŋąnŋumbu ŋuwonu kądjindjia, wudawa ąŋgeŋeri. ");
INSERT INTO wro_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Gejau ambulkandu tjilenjile kąmąndanala; manindjąŋa njḁdbama, kąmurduiena, darawa mąra kumbuna tjḁdąmanma. ");
INSERT INTO wro_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Maiarum anąŋga' ŋuru kaŋaŋawuna, kundjuŋiri, Maiarindjeruŋu' ŋuru dąra puŋunjeŋuriri. ");
INSERT INTO wro_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Gejau Jesu keŋaŋuru, inalalaia kuda:, maiar indjeruŋu' ŋuru Caesarea Philippi ŋąrim. Kalumba nąnja inalalaia burkai kandjąbuna, kundjuŋąnąŋgori, Nai' ąŋguja i:dja kubądjareri? ");
INSERT INTO wro_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Kubądjuŋanąŋga, John Baptist; atjąkekąria Elijah; atjąkekąria njele, iḁruŋ tjo:lbądaia nąnja. ");
INSERT INTO wro_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Arka burkai kandjąbuna, Njiri ŋai' ąŋguja kuriareri? Peter kaio:lbala kundjiri, Ŋundju Christ ŋunuŋ. ");
INSERT INTO wro_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Kundjuŋąnaŋgori, I:dja kari aua wunja pir-iinąŋgoriri. ");
INSERT INTO wro_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Wunmanbąli kaniiŋgundaleri, I:dj'iŋko:lu darawa madj kuni:njanąŋga, iŋgaiąbieŋu mababaia nąnja, ardenaiuri dadjurdkąria nanja, wiri-wiri-ŋaria nąnja, bąda iŋgauwi:ŋu, pąle kulunu tjḁruŋandu njele bḁri iŋgaiąndieŋu. ");
INSERT INTO wro_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Ŋąla-ŋąla wuna pąndurąm kulula. Peter kamąŋ aua, wunmanbḁli kamaiḁmbuna. ");
INSERT INTO wro_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Aua worarkar kanina inalalaia mara ąŋgo:na, Peter aua kąmaiḁmbuna, kundjiri, Ŋąlerdu ŋuru baiuŋuru, Satan; ŋundju God kąri wa ni: pundjaŋurun, i:' kari ni: kundjaŋuru. ");
INSERT INTO wro_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Peleŋgaraia ai kanbuna aua nąnja inalalaia nanja, kundjuŋąnąŋgori, I:dja ŋąmba iŋąmalando: gejara, aue ŋundju-ŋundju karii:nja, wongaia anąŋga manuk kumenja, ŋḁnmalando:nja. ");
INSERT INTO wro_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Aua iŋaui ŋąmundulba ge, pitja njoiim; aua iŋaui koiim ŋaiu wunja, wąląnu-wunia wunja, pitja njḁmundulba. ");
INSERT INTO wro_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Bąndaia daraiu aŋudjakunja i:dja kąma, ge iŋaui kọakaliba. ");
INSERT INTO wro_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Aŋudja i:dja kąno: iŋaui kąnauwi:nu? ");
INSERT INTO wro_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Aua djiąn kąmara ŋąla-ŋąla kuda: ŋaianąŋga, ąndja woi mąŋgadberi wurni-wurnia, arworia nąnja, I:dj'iŋko:lu kuda. pitja djiąn njąmanąnga, wuno:murum iŋgeŋgal pąlemba nanja Iranąŋga anąŋga, wąląnŋaria mąmaia nąnja. ");
INSERT INTO wro_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Kundjuŋąnąŋgori, Nidji kuŋenuriri, Atjąkekąria ŋuruma kaduŋ arka nḁnja ąŋgauwelgeŋiri, debara kądjinba puŋgavkagunąn, mąra karwu njini bąndaia God anąŋga keŋgal wundjurul' dąnja. ");
INSERT INTO wro_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Pale lewąra six, (wunŋąlu), Jesu kanma aua nąnja Peter a James a John, tḁląmbąn ŋuru karąŋ ŋuru kangąŋural adagąragenu; kaleŋ kaiąbiena adbąnŋąle nąnja; ");
INSERT INTO wro_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Wobi anąŋga pąlemba kadiŋaiena, ardo:roi djenbeŋuru, kulai-ŋąra kari kabąlba nąnja arge kądjindjia ardo:roi kądjinba paŋgąndjun. ");
INSERT INTO wro_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Mąra karwi:nanąŋgori Elijah Moses kuda:; auandu kubąluleri Jesu nąnja. ");
INSERT INTO wro_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Peter kaio:lba, kundjunąŋga Jesu, Rabbi, wunia arkunuŋ ŋuruma; jḁndąlpa maiaruŋurim wondi mero:; maiaruŋum ŋundju wunja, maiarunum Moses wunja, maiaruŋum Elijah wunja. ");
INSERT INTO wro_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Gewunja wa laiburu pąŋgąninja ŋąnąŋga iŋgaio:lba; gewunja karkulgunenja. ");
INSERT INTO wro_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Ąngubąn kunjąŋgunal djer' njindjąbunanąŋgori; aŋgubąn i dągu ŋąla-ŋąla kunjąŋgunal, Indja iŋąngula ŋedura ŋanŋundjunąŋga; ŋuru irąŋuru. ");
INSERT INTO wro_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Maiirgi:rkum wunjili:wa mąŋgarwuna, kari wa mara panbarwi:nja tjile, Jesu auekama arka nąnja. ");
INSERT INTO wro_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Wąli tḁląmbąn idągu jeriba kadjuŋaliri, kundjuŋąnąŋgori, I:dja kari piriinąŋgoriri mąra karwuna, I:dj' iŋko.iu imąndj i dągu bąri iŋgąnuŋ njini. ");
INSERT INTO wro_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Ŋąla-ŋąla wuna kubąrkaŋurula. arge wurura burkeba kadjąbieneri ąŋudja bḁri iŋgąnuŋ imąndj i dągu kąnuŋ. ");
INSERT INTO wro_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Burkai kaueriabuna, kubadjuŋiri, Wiri-wiri-ŋąria kubądju Elij'urle keŋgunjal. ");
INSERT INTO wro_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Aua kundjuŋąnąŋgori, Elij'urle nidji keŋgal, darawa kangąrąŋum; ŋḁrunąŋgọwu wiri-wiri kauwi:ŋu I:dj'iŋko:lu wunja, aua darawa madj kuni:njanąŋga, kaui kandjui:nja? ");
INSERT INTO wro_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","O! Kuŋenuriri, Elijah gole keŋgunal, kubadjuŋąnąŋga kuda: lai kauwonąnąŋgori, kądjinu wiri-wiri kauwi:nanaŋga. ");
INSERT INTO wro_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Wuno:murum inalalaia ąŋganbądburkalal, peleŋgąraia djenbeŋuru mąra kanbąrwuna wo:ri ąŋganbąrwuneri, wiri-wiri-ŋąria kuda: burkeba kanbądjąbuneri. ");
INSERT INTO wro_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Maiirgi:rkum pelengąraia ardarawaia, mąra iŋgarwunaia, djenbenuru rąngari kariŋa, wąri-wąri iŋgadburkąla, wulmai kubądjuŋanaŋga. ");
INSERT INTO wro_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Aua burkai kandjąbuna, Ŋąnąŋga burkeba kariabiri? ");
INSERT INTO wro_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Iḁruŋ peleŋgąraia nąnja kaio:lbąla, Iniiŋgundeja, kąŋaŋurulaldu iŋḁngula, agula iamidj kudai; ");
INSERT INTO wro_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Nąnḁm ma iŋgąm wai kaiąb, tjąŋalar kari kąnuŋ, iwiąk wurąŋgąn kumbu, ro:ngoi keŋeri; nunalalaia kuŋeŋąnąŋgori arka wai iŋgadjąb wunja, kądjinba wai paueriąbi:nja. ");
INSERT INTO wro_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Kandjo:lba kundjiri, Woi marąŋunmandjeri njirkudjaria, ŋąnąŋgiau njiri nąnja ŋenu? Ŋąnąŋgiau njinjąma? Iraŋuralgąra. ");
INSERT INTO wro_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Kaueraŋurulaldąga; mąra iŋgo:neri, maiirgi:rkum agula dalar kąmąŋ; kabąlba nąnja kauwona, bądawai kauwi:na tjąŋalar kąri. ");
INSERT INTO wro_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Aua iranąŋga burkai kaiąbuna, Ŋanąŋgiau wuna kunjąŋgunaldąga? Aua. kundjuŋu iḁnd' a:ndjḁnu. ");
INSERT INTO wro_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Tjilejile wai kariiŋiri wia' nąnja, agu nąnja, bąda iŋgo: wunja; ŋundju ŋąmba ŋąni tjuŋundju wunja, ąndjeriwandu, ąŋawodjandu. ");
INSERT INTO wro_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Jesu kundjuŋanąŋga, Ŋundju ŋąmba tjunundju wunja, darawa gole puŋge aua wa puŋgąŋudjarąn ŋąri. ");
INSERT INTO wro_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Maiirgi:rkum worala iranąŋga jero:l kundjuŋu, kundjuŋiri, Ŋaiu wa puŋąŋudjarąn; tjḁnawodju ŋḁnŋuŋudjara. ");
INSERT INTO wro_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Wuno:murum Jesu mąra ąngo:na peleŋgaraia niiriŋu tjḁri kadburąŋaliri, agula inuru kąmaiḁmbuna, kundjuŋanąŋga, Ŋundju agula wombąru, ŋundjamugu, kuŋenu, ba beŋgal dąga, tjile dḁra puŋunjąŋurunąŋgeri. ");
INSERT INTO wro_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Jero:l geŋu, djenbeŋuru dalar iŋgąmąn, ba keŋgunal; iḁnda imąndja kądjindja kąniŋaiena; gewunja ardarawaia kubądjuŋ, Imąn kąnuŋ. ");
INSERT INTO wro_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","O! Jesu ino:ri kąmąŋ, brai ki:la; gejau bḁri kąnina. ");
INSERT INTO wro_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Wuno:murum maiarum maninja iŋgeŋgunal, inalalaia a:dagaragenu burkai kaueriąbuna, Ąri kądjinba pedjąbi:nja. ");
INSERT INTO wro_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Kundjuŋąnąŋgori, Wuna kądjinu kądjinba puŋgeŋgunal ŋąmba wa dadjurd dkąga ma. ");
INSERT INTO wro_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Ma i dągu kariŋaŋuru, Galilee bulumąn karinŋaŋuru, i:dja kari wa laiburu arąnu puŋgenja. ");
INSERT INTO wro_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","Gewunja inalalaia kaniiŋgundala, kundjuŋąnąngori, I:dj'inko:lu kanauwi:nu i:dja ardo:ri nąnja, pitja bąda ewuro:; bąda iŋgauwi:ŋu, pąle kulunu tjḁruŋandu pitja bḁri njele enu. ");
INSERT INTO wro_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Ŋąla-ŋąla wa puŋgadenenja, karkulgunenja burkai iŋgadjąb wunja. ");
INSERT INTO wro_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Capernaum madburkalal; wuno:murum maiarum maninja ingąnina, burkai kandjabuna, Ŋḁnąŋga kurawadeŋu kalumba nąnja? ");
INSERT INTO wro_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Kąmuk kubąrwuna, gewunja arge wurura kadi:neri ąŋguja inaiuri iŋgąnuŋ. ");
INSERT INTO wro_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Atją kauwona, twelve, (ąnŋenŋąlja), ai kanbuna; kundjunąŋgori, Iḁruŋ ŋaiurle ŋąmba ge, pąle ardarawaia nąnja pitja enu, inawodjieja ardarawaia nąnja. ");
INSERT INTO wro_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Worala kąmąŋ, arka pulaga nąnja kandeŋu, ŋuluruwa kaŋuriri, kundjuŋanąŋgori. ");
INSERT INTO wro_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","Aua iŋgąm iḁruŋ ąndja woŋąlaląŋuja nḁnja ŋaŋumba nąnja, ŋaiu ŋḁnma; aua ŋḁnŋuma, ŋaiu wa pąŋąnmąn, O! aua ŋḁnŋunŋaŋawuna. ");
INSERT INTO wro_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","John kundjuŋanąŋga, Iniiŋgundeja, iḁruŋ mara kerwuna agulaia wai ąŋgo:neri ŋunŋumba nąnja, kedbaiąmbuna, ḁri wa penmalando:nja. ");
INSERT INTO wro_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","O! Jesu kundjuŋu, Pąramaiḁmbiri, gewunja i:dja kari, wundjurulu ŋḁŋumba nąnja ge, kadjinba maiirgi:rkum woru puŋgengąra. ");
INSERT INTO wro_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Aua wa ŋąnda pąŋądbąn ŋąri, ŋḁri nḁnja kąnuŋ. ");
INSERT INTO wro_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Aua agu njinŋuno: djo: wunja, gewunja Christ anąŋgaia njirkunuŋ, nidji ląŋugu anąŋga kądjinba puŋgoiimąn. ");
INSERT INTO wro_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Iḁruŋ ąndja bi:rwidiŋąria nąnja arka wa pąŋąnbąrkudjarąn ŋąri, aua ŋḁri iŋgąm, wunianąŋga ma no:gu daraiu ileŋga nąnja jarko:li kąnuŋ, wo:ndu' ŋuru wai iŋgaiąbieŋu. ");
INSERT INTO wro_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Ŋuno:ri ŋąmba nḁri ŋunŋuma, dur minjo:; wuniąnu ma tjo:da wundjedjer' kuru ŋunŋunjąŋa, ŋuno:ri tjḁruŋandu kudai ŋąmba ŋunŋunjąŋaŋuru mamara' ŋuru, wiḁn' kuru kądjinba tjimi puŋgauwi:n nari. ");
INSERT INTO wro_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Ma tjąmuldja arkąnąŋgąnja kądjinba debądi puŋgadjin, wiḁnu wa tjimi puŋgauwi:n. ");
INSERT INTO wro_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Ŋundjerdu ŋąmba ŋḁri ŋunŋuma, dur minjo:; wuniąnu ma wundjedjer' kuru ŋunŋunjąŋaŋuru ŋunbąndadj, ŋundjerdu tjḁruŋandu kudai ŋąmba ŋunŋundjąbieŋu mamąra' ŋuru. ");
INSERT INTO wro_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","Ma tjąmuldja arkąnąŋgąnja kądjinba debądi puŋgadjin, wiḁnu wa tjimi puŋgauwi:n. ");
INSERT INTO wro_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Ŋungubulu ŋamba nḁri ŋunŋuma, wai minjąb; wunianu ma bąndaia God anąŋga ŋuru ŋunnunjąŋaŋuru ŋungubul' tjḁruŋ kudai, ŋąmba ŋungubul' tjḁruŋandu kudai wai ŋunŋundjąbieŋu mamąra' ŋuru; ");
INSERT INTO wro_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Ma tjąmuldja arkąnąŋgąnja kądjinba debądi puŋgadjin, wiḁnu wa tjimi puŋgauwi:n. ");
INSERT INTO wro_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Ardarawaia kąrąmbal' kąri arandjui: wiḁn' njininge. ");
INSERT INTO wro_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Kąrąmbąlja inia kąnuŋ; O! kąrąmbḁlja wulapa ŋąmba wa pąŋgeŋąn, ąŋudjaniŋge wulapa ŋąra irewandju? Njirkaui nąnja kąrąmbąlja kudai njidu, jḁmulili ŋąri njidu. ");
INSERT INTO wro_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Ma i dągu bḁri kąnina, keŋgal maiamiŋgum Judaea Jordan kanal' gąrim; peleŋgąraia djaruk kadbieŋunąŋga njele; gejau, kądjinu geŋirida, njele kaniiŋgundąla. ");
INSERT INTO wro_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Pharisia kauerąmurkąla, burkai kaueriąbuna' Wuniowu i:dja mąŋgąnąŋgąnja njąŋgaiąb? Kauero:ndjuneri. ");
INSERT INTO wro_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Kandjo:lbąla kundjuŋąnąŋgori, Ŋąnąŋga Moses kundjuŋunuri? ");
INSERT INTO wro_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Arka kubądjuŋ, Moses ąnąŋu:la wiri-wiri njerkundju mili-mili njerkundjąba ŋąra, wai njerkundjąba. ");
INSERT INTO wro_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","O! Jesu kundjuŋąnąŋgori, Gewunja njirkulum burudum wunauie wuna wiri-wiri kundjuŋunuri. ");
INSERT INTO wro_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","O! Wunindidj-i-dągu wondijau, Auąndja, njiŋgąnja wondi kanbuna. ");
INSERT INTO wro_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Wuna wunja i:dja iranąŋga a karanąŋgąnja pitja ejąndiwejąndu, mąŋgąnąŋgąn' njininja pitja njewąndura; ");
INSERT INTO wro_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Iaruŋandu iwiliri iḁruŋamandj pitja eniŋaiejandu; gewunja iḁruŋandu wa njele pąŋgąningąndu, O! iḁruŋamandj. ");
INSERT INTO wro_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Auandu God pidjin iŋgo:nandu, i:dja tjauala: paueriąndandiri. ");
INSERT INTO wro_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Maiarum maninja inalalaia njele wuna wunja burkai kaueriąbuna. ");
INSERT INTO wro_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Kundjuŋąŋgori, Aua mąŋgąnąŋgąnja njąŋgaiąb, ndjakąrinja pilin iŋgauwona, wurni-wurni njinaneri; ");
INSERT INTO wro_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Njąŋga kuda: kulanąŋga ŋąmba iŋgaiąb, iakąra ŋąmba iŋgąm, njąŋga kuri njinuŋ. ");
INSERT INTO wro_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Woŋąlaląŋuja bi:rwidiŋąria kanbąrkaŋurulaldaga, ąŋgąmąndana wunja, inalalaia kanbądbaiḁmbuna. ");
INSERT INTO wro_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","O! Jesu mąra ko:na, mąra-mąra kąnina, kundjuŋąnąŋgori, Woŋąlaląŋuja kariŋgunjalgḁra; kąre paro:jiri, gewunja arge kądjindjia bąndaia God anąŋga. ");
INSERT INTO wro_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Nidji kuŋenuriri, Aua bąndaia God anąŋga wa puŋgąmąn ŋąri woŋąląŋ pidi:ndja kḁdjindja, kądjinba ma dąra pąŋgeŋąn ŋuru. ");
INSERT INTO wro_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Ŋuluruwa kaŋurula, pąli kanbuna, ino:ri kanmḁndanaleri. ");
INSERT INTO wro_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Wąli kalumba ŋuru iŋgeŋaŋuriri, iḁruŋ wḁri-wḁri kąmurkalal, imąnŋąle ŋuru luŋgudja kąnina, burkai kaiąbuna, Iniiŋgundeja inia, ŋąni pitja ŋe wundjedjeru kądjinma ŋąri ŋąma wunja? ");
INSERT INTO wro_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Jesu kundjuŋunąŋga, Ąŋudjakunja inia kundjiara? Kari inia wa pąŋgąnin, God auekama. ");
INSERT INTO wro_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Wununauie gole laiburu ŋunuŋanąŋga, Bḁda pąndjo:jiri, Wurniwurni puŋuniri, Maneba pąm-ąndjorjiri, Pare pandjaŋuriri, Pielgielge puŋuniri, Iro:lidj, karanja ŋuru aŋurandu. ");
INSERT INTO wro_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Aua kundjuŋanąŋga, Iniiŋgundeja, wuna darawa kuŋeŋiri, woŋąląŋ andjḁnu. ");
INSERT INTO wro_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Jesu kąnindjąŋa, ŋedura kundjuŋanąŋga, kululanąŋga, Tjḁruŋ ŋuno:ra, baiuŋuru, ko:l dju ąndjąŋąngaŋuleria, ardjeja ąno:, wuląnbiri ąndjo:l' dąnja pitja kudai ŋunjḁnu; gejau beŋgal, tjḁnmalando: ");
INSERT INTO wro_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Imiŋum ŋundi-ŋundi kundjuŋu, pakul ŋąri keŋaŋuru, wuląnbiri ardarawaia kudai iŋgąnina. ");
INSERT INTO wro_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Jesu wunjili:wa kanbuna, inalalaia kundjuŋąnąŋgori, Adbąnŋąlim kunuŋ arka wuląnbiri tjiŋi:ria bąndaia God anąŋga dąra ąŋgeŋuru wunja. ");
INSERT INTO wro_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Inalalaia ŋąla-ŋąla anąŋga rąngąri kubądburawuna. Mia Jesu tjile kandjo:lba, kundjunąŋgori, Woŋąlaląŋuja, Adbąnŋąlim kunuŋ arka wuląnbiri pąrąd ąŋganbądburawu bąndaia God anąŋga dąra ąŋgeŋuru wunja. ");
INSERT INTO wro_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Camel abi:la mandągu bulumąn keŋaŋuru needle ambul' dąnja, i:dja tjiŋi:ra bąndaia God anąŋga dąra iŋgeŋuru wunja. ");
INSERT INTO wro_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Rąngąri djenbeŋuru kariŋa, kubądjuŋanąŋga, Ąŋguja emundulbaie? ");
INSERT INTO wro_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Jesu kanindjeri, kundjiri, I:dja nąnja adbąnŋąlim kunuŋ, kari God nąnja; darawa gole puŋgąnu God nąnja. ");
INSERT INTO wro_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Wunmanbąli Peter kundjuŋanąŋga, Wai, darawa kunjedjąndiwela, ŋunbądbalando:na. ");
INSERT INTO wro_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Jesu kundjuŋu, Nidji kuŋenuriri, I:dja ŋąmba ąŋgaiąndiwe maiarum, ŋawawaia, ŋawawanja, karanąŋgąnja, iranąŋga, woŋąlaląŋunąŋgaia, kabąlba, ŋaiu wunja, wąląnu-wunia wunja, ");
INSERT INTO wro_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","Pitja ąnjąm ardarawaia nąnja ma, weni wendjiau, maiarum, ŋawawaia, ŋawawanja, kararaia, woŋąlaląŋuja, kabąlba, wundjo:rie kuda:; bąndaia keŋgal djini wundjedjeru kądjinma ŋąri. ");
INSERT INTO wro_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Mia ardarawaia mąnŋąle ŋąria pitja pąle arąnu, pąle ŋąria pitja mąnŋąle arąnu. ");
INSERT INTO wro_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Kalumba nąnja kadineri, Jerusalem ŋuru pai kadineri; Jesu adbąnŋąle ŋuru keŋaŋuriri; rangąri kariŋa; arka iŋgadbalando:neri karkulgunenja. Twelve, (ąnŋenŋąlja), njele kanmąŋ, wunmanbąli kundjuŋąnąŋgori wuna kaniŋaieŋunąŋga. ");
INSERT INTO wro_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Wai, Jerusalem ŋuru pai ŋḁduŋiri; I:dj' iŋko:lu pitja eno:wi:nąŋgori ardenaiuri dadjurdkąria a wiri-wiriŋąria; pitja wure pąro:nąŋga imąn kunja, pitja ąnbąrano:nąŋga edbulia, ");
INSERT INTO wro_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Arka berka pitja ewurana:na, pitja tjipa: ewuro:, pitja ŋoiilwa ewuraŋuru, pitja bąda ewuro:; pąle kulunu tjḁruŋandu pitja bḁri enu. ");
INSERT INTO wro_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Wodjulu kąmurkalgandu James a John, Zebedee iŋko:landu, kundjunąŋgandu, Iniiŋgundeja, njḁrenandu tjuŋundjunjḁrendu burkai ŋuŋnunbądjąbandu. ");
INSERT INTO wro_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Aua kundjuŋąnąŋgandu, Ŋḁnąŋga kuriandareri ŋḁnŋundjunurendu? ");
INSERT INTO wro_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Kundjuŋąnąŋgandu, Ąno:wandu atją arkuunuŋandu, iakąra ŋundju worawerdum maninja, iakąra tjamauim maninja, pąlemba ŋundjanąŋga nąnja. ");
INSERT INTO wro_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","O! Jesu kundjuŋąnąŋgandu, Wa laiburu pinjidingandu ŋḁnąŋga ŋa:d njirkunuŋandu. Koru djo: pinjiriandu cup ŋaiu djo: ŋḁnŋunjąŋa, koru baptize pinjidandu baptism njiniŋge ŋaiu baptize ŋḁnŋunuŋ? ");
INSERT INTO wro_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Auandu kundjuŋąnąŋgandu, Gole pedandu. Jesu kundjuŋąnąngandu, Cup ŋaiu djo: ŋąnŋunjaŋa njirendu pitja djo; njiriandu; baptism ŋaiu baptize ŋḁnŋunuŋ njirendu pitja baptize njirenandu; ");
INSERT INTO wro_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Mia atja njirkunuŋandu ŋaiu worawerdum, tjamauim maninja, ŋaianąŋga kunina miri njinŋuno:wandu, arkanąŋga arka wunja wunamanja kanina. ");
INSERT INTO wro_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Wuno:murum ten, (ąnŋenŋąlja), ŋuru ąŋgąnina, wun man bąli adji:la kaueramąŋąnąŋgandu James a John. ");
INSERT INTO wro_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Gejau Jesu ai kanbuna aua nąnja, kundjuŋąnąŋgori, Laiburu njiduŋ arka ąŋgandiena ardaiur' kunja edbulia nąnja ardaiur' kaduŋąnąngori; ardenaiuri arkanąŋga i:a karwi:ŋunąŋgori. ");
INSERT INTO wro_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Njiri nąnja wurunąŋgọwu wa puŋganin; O! aua njiri nąnja ŋḁnaiuru ŋenu gejiri, inawodjieja njirkanąŋga pitja enu; ");
INSERT INTO wro_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Aua njiri nąnja ŋaiurle ŋenu gejiri, inawodjieja ardarawaia nąŋja pitja enu. ");
INSERT INTO wro_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Gewunja nidji I:dj' iŋko:lu keŋgunal kari iŋgąnawodjieŋu wunja, O! ąŋgąnawodju wunja, iŋaui ąŋgano: ląŋugu ardarawaia wunja. ");
INSERT INTO wro_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Jericho madburkal; wąli Jericho i dągu iŋgeŋaŋuriri, inalalaia nąnja, peleŋgąraia djenbeŋuru kuda:, Timaeus iŋko:lu, Bartimaeus, ŋa:d bąda ambulidj, atją kąnineri kalumba mawondąram maninja. ");
INSERT INTO wro_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Wuno.murum ŋuru iŋgąnina Jesu Nazareth ŋąra iŋgąnina, wunmanbąli jero:l kundjuŋiri, kululeri, Jesu, ŋundju David ŋunŋungula, tjḁndjeriwu. ");
INSERT INTO wro_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Ardarawaia kauerąmaiḁmbuna, kḁmuk iŋgauwi:ŋu wunja; O! jero:l kundjuŋu djenbeŋuru ma, Ŋundju David ŋunŋungula, tjḁndjeriwu. ");
INSERT INTO wro_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Jesu ba:d kundjuŋu, kundjuŋu, Ai iro:. Ai kauero: ambulidj, kubądjunąŋga, Tjukul bąnu, bḁri bąnu, ai ŋunbiri. ");
INSERT INTO wro_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Aua, wobi anąŋga wai iŋgaiąbuna, kurąd kąnina, Jesu kąmurkalal. ");
INSERT INTO wro_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Jesu kaio:lbala, kundjunu, Ŋḁni njejara kundjiareri? Ambulidj kundjuŋanąŋga, Rabboni, mąŋąnŋunindj wunja. ");
INSERT INTO wro_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Jesu kundjuŋanąŋga, Ŋundjunuru baiuŋuru; ŋundju wa pindjąŋudjarenja ŋunmurduwi:ŋu. Maiirgi:rkum manindjąŋa, kalumba nḁnja kąmalando:na. ");
INSERT INTO wro_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Jerusalem djali mąŋgadba, Bethphage a Bethany nąnja, inalandu kąŋaŋawandu, kundjunąŋgandu, ");
INSERT INTO wro_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","Njiriŋurandu maiarindjeruŋu' ŋuru mąndjo:ri mąŋgąnuŋ; maiirgi:rkum wąli ma dąra njirkumbąnaŋurandu, pitja mąra irewandu donkey kauila murd iŋgąmiena, i:dja kari wen' njini kądjinba atją parwi:njanąŋga; burąŋgai irąmandu, iraŋuralgandu. ");
INSERT INTO wro_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","I:dja ŋąmba kadjunurendu, Ąŋudjakunja wuna kuriandiri, wuriandu, Inaiuri iŋąma kundju, maiirgi:rkum pitja pąleŋuru eŋaŋawal. ");
INSERT INTO wro_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Keŋaŋurandu, donkey kauila mąra ko:nandu murd iŋgabiena maiamundu' nąnja dąnde kalumba ");
INSERT INTO wro_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Atjąkekąria ma ąŋgawelgenjiri kubądjuŋąnąŋgandu, Ŋḁni kuriandiri donkey burąŋgai irąŋunmąngandiri? ");
INSERT INTO wro_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Kundjuŋąnąŋgoriandu ge i dągu Jesu geŋunąŋgandu, arka kaueranaŋu:landu. ");
INSERT INTO wro_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Donkey kauila Jesu kaueraŋuraldąga, wobi arkanąŋga kauero:gulenąŋga; aua atją kauwonanąŋgori. ");
INSERT INTO wro_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Ardarawaia wobi arkanąŋga kalumba nąnja pąlọa kariŋanąŋgeri; atjąkekąria jedmąŋgąnu wuŋgalalidjerugu dur kadjuŋaliri paddock nąnja. ");
INSERT INTO wro_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Arka mąnŋąle ąŋgeŋaŋuriri, arka kuda: pąle iŋgadbalando:neri, jero:l kubądjuŋ, Hosanna; Tjukul ŋąra aua iŋgeŋgaliri Inaiuri iŋumba nąnja. ");
INSERT INTO wro_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Tjukul ŋąri bąndaia keŋgaliri, David irai ŋarkanąŋga ŋąri, Hosanna karąŋ ŋąri ma. ");
INSERT INTO wro_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Jerusalem dąra keŋa; wuno:murum wunjili:wa ko:na darawa nąnja, kąlekąlem njiŋgąnina, dąnde keŋaŋuru Bethany ŋuru, twelve, (ąnŋenŋąlja), nąnja. ");
INSERT INTO wro_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Mąŋgunu, Bethany i dągu ąŋgeŋgunal, baia: ko:na. ");
INSERT INTO wro_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Tjilium bọwora mąra mąŋgo:na jedmąŋgąnu kudai, keŋgunal, ŋąmba maia ma nąnja mara ąŋgo: minja; mąŋgąmurkalal, kari wa mąra panbi:nja, jedmąŋgąn' dąka ma; gewunja tjilium kurabjau wa puŋgąninja. ");
INSERT INTO wro_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Maio:lbąla, kundjuŋanąŋga, I:dja kari mindjḁl puŋgadjiri ŋundju nąnja wendji dągu kądjinma njini. Inalalaia ŋuru kaueraŋurula. ");
INSERT INTO wro_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Jerusalem madburkalal; dadjurdkąrim manaiudba dara kena, wunmanbąli wai kanbuna arka ko:l kadjuŋeri, ąŋganbądbąŋeri dadjurdkąrim manaiudba maninja, pąlalo:nma kaiug kaleŋ-ŋąria arkanąŋga tjaueri maiąbuna, adbąląkąrim kuda: arka kuluko:ka ko:l kadjuŋiri; ");
INSERT INTO wro_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","I:dja kari pa:nąŋu:nja tjalumba mano: iŋgaŋuru wunja dadjurdkąrim manaiudba pulągori. ");
INSERT INTO wro_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Kaniiŋgundąla, kundjuŋąnąŋgori, Wawu wiri-wiri puŋgauwi:nja, Maiarum ŋaianąŋgam pitja merimie maiarum dadjurdkąrim, worumbaia ardarawaia wunja? O! njiri marandjuna kąnmenma lulunŋąria arkanąŋgąm. ");
INSERT INTO wro_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Ardenaiuri dadjurdkąria, wiri-wiri-naria kuda: ŋuru kadina, buluk kubąrkąnjiro:na ŋarunąŋgọwu bąda iŋgarwu; gewunja kauero:lgunąla, peleŋgąraia ardarawaia rąngąri ąŋgeŋaia ąŋganiiŋgundaleri. ");
INSERT INTO wro_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Kalekalem kądjinma keŋaŋuru manaiudba i dągu. ");
INSERT INTO wro_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Mąmąŋgunu tjḁnai ąŋgeŋeri, tjilium mąra marwuna maralgam wondudba i dągu. ");
INSERT INTO wro_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Peter ni: kaŋurula, kundjunąŋga, Rabbi, wai, tjilium ŋundju wure mąndjąŋunbuna maralga' njinim mḁnina. ");
INSERT INTO wro_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Jesu kandjo:lbą kundjunąŋgori, God pąrąŋudjareri. ");
INSERT INTO wro_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Nidji kuŋenuriri, Aua genąŋga tḁlḁmbąn wuna, Tjḁrawąd pąmie, wo:ndu' ŋuru paiąbie; iŋaui nąnja ŋąmba wa puŋgąŋudjarąn ŋąri, kądjinba puŋgąŋudjarąn ge ka:lu kąniŋaieŋu; pitja njḁnunąŋga. ");
INSERT INTO wro_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Gewunja kuŋenuriri, Darawa dadjurd wurąŋundju, wurąŋuniau, purąŋudjareri gole kudai njirkunina, pitja kudai njirąnu. ");
INSERT INTO wro_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Wuno:murum njirkumbąlgeŋiri dadjurd wurąŋundjiri, wai wuriąb, ŋąmba ŋąnda arąŋunma; gewunja Iranura kuda: aua ąndjo:l' dąnja iŋgąnuŋ, umąra njirkanąŋga wai kąna puŋgaiąbanuri. ");
INSERT INTO wro_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Njiri ŋąmba wa wai puriąbun, Iranura aua ąndjo:l' dąnja iŋgąnuŋ umąra njirkanaŋga wa wai puŋgaiąbun-nuri. ");
INSERT INTO wro_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Jerusalem njele madburkal; wudawa iŋgeŋeri dadjurdkąrim manaiudba nąnja, kauerąmurkal ardenaiuri dadjurdkąria, wiri-wiri-nąria, mababaia. ");
INSERT INTO wro_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Kubadjuŋanąŋga, Ŋḁnąŋga wundjurul' njiniŋge wuna kundjiiri? Ąŋguja wuna wundjurulu ŋuno:na wuna tjuŋundjindjiri? ");
INSERT INTO wro_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Jesu kundjuŋąnąŋgori, Tjḁruŋ burkai njinjiąb, tjḁrio:lba, pitja ŋenuri ŋąnąŋga wundjurul' njiniŋge wuna ŋḁnŋundjiri. ");
INSERT INTO wro_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Baptism John anąŋga, ąndjo:l' kąri, i:dja ŋąri kunina? Tjario:lba. ");
INSERT INTO wro_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Arge wurura kubąrwadeŋu, kubądjuŋiri, Ŋąmba workundju, Ąndjo:l' kari, pitja nje, Ąŋudjakunja kurąŋudjarala? ");
INSERT INTO wro_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Ŋąmba workundju, I:dja ŋąri, peleŋgąraia kanbąrkulgunąla; gewunja ardarawaia nidji John tjo:lbąda ŋali kubądjuŋanąŋga. ");
INSERT INTO wro_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Jesu kauerio:lbala, kubądju, Wa laiburu pedin. Jesu kundjunąŋgori, Ŋaiu wa puŋenuri ŋąnąŋga wundjurul' njiniŋge wuna ŋḁnŋundjiri. ");
INSERT INTO wro_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Wunmanbąli kululanąŋgori bḁre-bḁre nąnja. l:dja tjḁriŋąrjm ro:pa keŋa, ŋuwonu ŋąli-ŋąli kundjąndąla, balaium tjḁri mo:na wine kunja, maiarum karąŋ ŋąrim wondi mo:na, tjḁriŋąria kanino:la, tąmbium maiakąri' ŋuru keŋaŋuru. ");
INSERT INTO wro_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Kurabjau kąŋaŋawuna tjḁriŋąria ŋuru inawodjieja, kurab tjḁriŋąrim maninja ąŋgąmura wunja tjariŋąria nąnja. ");
INSERT INTO wro_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Arka laburd kauerąmąŋ, ŋoiilwa kaueraŋurula, ino:ra kaueraŋaŋawuna. ");
INSERT INTO wro_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Njele inawodjieja iakąra arka nąnja kąŋaŋawuna; aua imri: dai kubąrwuna, wodbandągu kubądjuŋąnąŋga. ");
INSERT INTO wro_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Iakąra kąŋaŋawuna; aua bąda kauero:na; atjąkekąria ardarawaia; atjąkekąria ŋoiilwa kanbąrkaŋuruleri, atjąkekąria bądawerdai kanbąrkanaleri. ");
INSERT INTO wro_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Wąli iḁruŋ kudai iŋko:lu, ŋedura geŋunąŋga; pąle nąnja kąŋaŋawuna arka nąnja, kundjuŋiri, Ŋuru ewuraŋuru iŋąngula. ");
INSERT INTO wro_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","O! Arge tjḁriŋąria arge wurura kadi:na, Indja iwulgu; ŋariu, bąda ąro:, tjḁriŋąrim ŋarkanąŋgam pitja menu. ");
INSERT INTO wro_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Laburd kauerąmąŋ, bąda kauero:na, tjḁriŋąrim i dągam wai kaueriąbuna. ");
INSERT INTO wro_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Gewunja ŋḁni pitja nje inaiuri tjariŋąrim nara? Pitja ejeŋgal, tjąriŋąria bądawerdai njenąŋgori, tjariŋąrim atjąkekąria anjąnino:. ");
INSERT INTO wro_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Wiri-wiri wuna wuna wawu mąra puro:njiri; Kaiug ge wondiŋąria wai kadjabuna, Ge i di dągu kuniŋaiena umri: ruko:wa; ");
INSERT INTO wro_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Wuna Inaiuri i dągu, Rąngąri ŋarkumbul' dąnja kunuŋ? ");
INSERT INTO wro_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Kubąrkąnjiro:na ląburd iŋgadba wunja; pelengąraia kanbąrkulgunąla; gewunja kubądidjąŋa bare-bare geŋu arka wunja; kaueriąndiwela, kariŋaŋuru. ");
INSERT INTO wro_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Kanbąrkaŋawu aua nąnja atjąkekaria Pharisia a Herod ŋąria, iŋgadba wunja ŋąla-ŋąla nąnja. ");
INSERT INTO wro_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Wuno:murum ąŋgeŋgunal, kubądjunąŋga, Iniiŋgundeja, laiburu ḁduŋąnu nidji ŋunŋunuŋ, kari wa pandjo:lgunąn; gewunja ŋundju i:dja wa pandjąnindjąn, O! nidji God ŋąri kandjaniiŋgunderi; Wuniowu kaiug Caesar erkuno:? Worwu ge? ");
INSERT INTO wro_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Ko:ru kedo:? Wawu pedo:n? Aua laiburu kąninanąŋgori adbiŋum mąljaljadbuneja, kundjunąnąŋgori, Aŋudjakunja tjḁro:ndjuiri? Kaiug wuraŋuralgąra, ŋḁnŋunindj wunja. Kubąrkaŋurulaldąga. ");
INSERT INTO wro_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Gejau kundjuŋąnąŋgori, Aŋguja anąŋgam imiŋum mḁna, wiri-wiri wuna? Kubądjuŋąnąŋga, Caesar anąŋga. ");
INSERT INTO wro_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Jesu kundjuŋanąŋgori, Caesar irano: Caesar anąŋgaia, God irano: God anąŋgaia. Djenbeŋuru rąngąri kauerąmurawuna. ");
INSERT INTO wro_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Kauerąmurkal kuda: Sadducia, arka kadju adbąndj i dągu wa bari padjąndien, burkai kaueria-buna, kubadjuŋiri, ");
INSERT INTO wro_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","Iniiŋgundeja, Moses wiri-wiri kundjuŋunjąri, I:dja ŋawanąŋga ŋąmba debąra iŋgeŋa, mąŋgąnąŋgąnja pąle njąŋgaiąndiwe, woŋąląn kari wa paŋgaiąndiwen, ŋawanąŋga mąŋgąnąŋgąnja njimenja, woŋaląŋuja ąŋgaiąnda ŋawanąŋga wunja. ");
INSERT INTO wro_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Ŋawawaia ąnŋenŋąlja kadina; iwulgu mąŋgąnąŋgąnja njimąn, debąra keŋa, woŋąląŋuja kari wa pandjąndiwenja; ");
INSERT INTO wro_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Pulai njimąŋ, debąra keŋa, woŋąląŋuja kari wa pandjąndiwenja; ");
INSERT INTO wro_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Ge pula: ŋąra, ąnŋenŋąlja woŋąląŋuja kari wa panbądjandiwenja. Pąle nąnja woŋaiinja kuda: debąra njeŋa. ");
INSERT INTO wro_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Adbandj' i dągu bąri ąŋgąnuŋ mąŋgąnąŋgąnja nḁni anąŋgąnja pitja njenu? Gewunja anŋennąlja njiŋgarkaŋuruleri mąŋgąnąŋgorinja. ");
INSERT INTO wro_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Jesu kundjuŋąnąŋgori, Wawu wuna wunja kurąmiḁdma, mili-mili a wundjurulu God anąŋga wa laiburu pinjidin ŋąri? ");
INSERT INTO wro_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Wuno:murum adbąndj i dągu bḁri ąŋgąnuŋ, kari wa pąnąn parwąn, kari wa pąnąn padawi:n; O! wąląnŋąria ąndjo:l' dąnja kądjindjia kaduŋ. ");
INSERT INTO wro_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Mia adbąndja wunja bḁri ąŋgaiąndieŋu; wawu mąra puro:njiri mili-mili nąnja Moses anąŋga, Irululu wunja, God kalulunąŋga, geŋunąŋgeri, Ŋaiu God Abraham anąŋga, God Isaac anąŋga, God Jacob anąŋga? ");
INSERT INTO wro_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Aua God adbąn ŋąra ŋuru-ŋuru, ardjedjerkąra; djenbeŋuru kurąmiḁdma. ");
INSERT INTO wro_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Iaruŋ wiri-wiri ŋąra keŋgunal, ŋuru kangaŋurula burkeba ąŋgaiąbieneri, laiburu iŋgąnina tjḁdąŋuru ąŋgaio:lbąla, burkai kaiąbuna, Ŋąnaŋga wununauie kauurle darawa nąnja? ");
INSERT INTO wro_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Jesu kaio:lbąla, Kauurle kunuŋ, Ŋuru njidu, Israel; Inaiuri God ŋarkanąŋga, Inaiuri iḁruŋamandj kąnuŋ; ");
INSERT INTO wro_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Ŋedura djunąŋga Inaiuri God ŋundjanąŋga ŋunŋaui dara nąnja, ŋunŋandj irara nąnja, ŋuni:um mararawam maninja, ŋundjurulba mararawam maninja. ");
INSERT INTO wro_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Tjąkąri wuna, Ŋedura djunąŋga mąmąŋgąlja ŋundjanąŋga ŋunge ŋundju-ŋundju kądjinu. Wununauie tjąkąri wunaiuru wa puŋgąnin wuna nąnja. ");
INSERT INTO wro_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Wiri-wiri ŋąra kundjuŋanąŋga, Nidji, Iniiŋgundeja, tjḁdąŋuru kundji:ŋu. Aua iḁruŋ iŋgąnuŋ; iakąra kari auekama; ");
INSERT INTO wro_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Aua ŋedura wunja iŋaui dara nąnja, ini:um mararawam maninja, iurulba mararawam maninja, mąmąŋgalja ŋedura wunja aue ŋundju-ŋundju kądjinu, wunaiud' ban dągu ma irarai wori tjąmi wunja, ląŋugu nąnja. ");
INSERT INTO wro_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Jesu mąra iŋgo:na ini:u' ŋąra iŋgaio:lbąla, kundjuŋąnąŋga, Ŋundju bḁndaia God anąŋga bọwora wa puŋąnin. Pąlejau i:dja kari dąrąngu wa padinja burkai iŋgadjąb wunja. ");
INSERT INTO wro_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Jesu kandjo:lbąla, kundjuŋu, ąŋgąniiŋgundaleri dadjurdkąrim manaiudba nąnja, Ŋḁrunąŋgọwu wiri-wiri ŋąria kubądju Christ David iŋko:lu? ");
INSERT INTO wro_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","David aua ŋundju-ŋundju kundjuŋu Iŋandj Mąmaia nąnja, Inaiuri kundjunanąŋga Inaiuri ŋaianąŋga, Atja bọwa ŋaiu worawerdum maninja, Ardauurgundjia ŋundjanąŋgaia ąŋandju njini ŋundjerduŋąri ŋundjerdu waiuru. ");
INSERT INTO wro_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","David aua ŋundju-ŋundju Inaiuru kundjunąŋga; ŋḁmbula wa iŋko:lu? Peleŋgąraia tjukul ŋąri ŋuru kaueraŋurula. ");
INSERT INTO wro_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Ąŋganiiŋgundaleri kundjuŋu, Maranindjąnąŋgori wiri-wiri ŋąria, wobi kąrąŋgen' nąnja wudawa ŋeju kadju' wulmai tjauŋąrim maninja lai kauwonanąŋgori, ");
INSERT INTO wro_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Adbąląkarim karąŋ ŋąrim dadjurdkąrim maninja, ardarub kąrąŋ ŋąrim maia kuri ąŋganuŋjau; ");
INSERT INTO wro_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Arka maiarum ardjo:jo:ria arkanąŋgam mindjąl kadju, adja:djin bądaia dadjurd kąrąŋgen kadju; ąndja wure wundjuŋgundia pitja pąrąm. ");
INSERT INTO wro_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Atją kauwona kaiugkąrim mąndjo:ri, mąra kanbuna peleŋgąraia kaiug karkąndeŋu kaiugkąrim maninja. ");
INSERT INTO wro_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Njeŋgunal ndjḁruŋunja ndjenja ndjo:rinja, njąŋga kuŋgandeŋu kaiug pidi:n tjḁruŋandu. ");
INSERT INTO wro_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Inalalaia ai kanbuna aua nąnja, kundjuŋąnąŋgori, Nidji kuŋenuriri, Njina ndjenja ndjo:rinja kuŋgąndeŋu dara man dągu ardarawaia nąnja karkąndejiri kaiugkąrim maninja; gewunja arka ardarawaia kubąrkąndeŋu darawa arkanąŋga nąnja; njąŋga pidi:n njąŋga-nąnga nąnja kuŋgąndeŋu darawa kanawunguleri, darawa njiniŋge njiŋgąniŋiri. ");
INSERT INTO wro_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Wąli dadjurdkąrim manaiudba i dągam iŋgeŋaŋuriri iḁruŋ inalala kundjuŋanąŋga, Iniiŋgundeja, manindj ąŋudja kądjinu kaiug, ąŋudja kądjinu maiarum! ");
INSERT INTO wro_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Jesus kundjuŋanąŋga, Ko:ru mandjanindj maiarum mąna manaiudba? Ŋuruma kądjinba puŋgąmąŋgien kaiug tjḁruŋ tjąkąri nąnja, nąmba pitja wa puŋgaiąbien. ");
INSERT INTO wro_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Wąli atją iŋgauwona kurandu Oliva ŋąri nąnja, dadjurdkąrim manaiudba mąndjo:ri, Peter a James a John a Andrew mululu burkai kaueriabuna. ");
INSERT INTO wro_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","Minjenjḁri, wuna ŋanąŋgiau pitja njḁnu? Ąŋudja umiimbaie wuna darawa ko:rug kąni:ŋu? ");
INSERT INTO wro_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Wunmanbąli Jesu kundjuŋąnąŋgori, Maranindj i:dja kari pinjirbąrkadjuiri. ");
INSERT INTO wro_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Ardarawaia pitja areŋgal ŋḁŋumba nąnja, pitja bare Ŋaiu ŋḁnuŋ, ardarawaia pitja ąnbaradju. ");
INSERT INTO wro_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Wuno:murum ŋuru njirkunuŋ mąlanim, wąląnu mąlani 'ŋąri, djerara pąmąrąmeri, wuna madj kunjąŋgunjal; umindjuŋuru wąli kui. ");
INSERT INTO wro_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Gewunja worumba pitja bḁri arąmurkie worumba ŋąnja, bąndaia bąndaia nąnja; kabąlba ŋulin-ŋulin pitja mewi: maiagekąrim maninja; wurkalba pitja menu; wuna wundjaŋuru wurgunu ŋąri. ");
INSERT INTO wro_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","Mia maranindj njiri wunja, pitja ąnbąranino: nuri karwądeja nąnja; dadjurdkąrim maninja pitja ŋoiilwa njiraŋurie, adbąnŋąle ŋuru ŋarai a arderaiuri pitja njirawelge ŋaiu wunja wunąŋądjaie arka nąnja. ");
INSERT INTO wro_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Wąląnu-wunia kauurle madj ardi:um kuluienja worumbaia ardarawaia nąnja. ");
INSERT INTO wro_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Wuno:murum njinŋumbąrkaŋuru ąŋganbądino:nuri, gewurle djerara pąmąrąmeri ŋḁnąŋga pitja wurąŋulu; ge pitja kąnino:wi:ŋunuri gejau, ge wuralu; gewunja njiri ŋuru-ŋuru wurąŋulu, mia Iŋandj Mąmaia. ");
INSERT INTO wro_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Ŋawaia pitja iŋgąnino: ŋawanąŋga imąn kunja, iranąŋga iŋko:lu; woŋąlaląŋuja pitja bḁri arąmurkie ardenaiuri nąnja, pitja ąnbąrandju adbąn kunja. ");
INSERT INTO wro_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Pitja njiro:ndjurie i:dja ardarawaia nąnja ŋḁŋumba wunja; mia aua birem bire geja umindjuŋuru njini, aia pitja emundulbaie. ");
INSERT INTO wro_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","Wuno:murum mąra wurąŋunbu wemunbu mawodbaŋąri kauwelgeŋiri ma wunianąŋga ŋuru-ŋuru, (aua mąra iŋgo: kunenenja), gejau Judaea nanja ąŋgąnuŋ tḁląmbąn ŋuru kubądii:nja; ");
INSERT INTO wro_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Aua maiarum karąŋ nąnja iŋgąnuŋ, jeri pąŋgawenja, dąra pąŋgejiri ąŋgąmura wunja maiarum anąŋgam maninja. ");
INSERT INTO wro_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Aua paddock nąnja iŋgąnuŋ djo:li pąŋgąniri wobi iŋgąmura wunja. ");
INSERT INTO wro_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Wurgunu arka nąnja mḁnduwaia ąŋgąnuŋ, arka nanja ŋumugu ąŋganbądo: jiri lewąra ge. ");
INSERT INTO wro_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Wurąniau imaiajau puŋgąniri. ");
INSERT INTO wro_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Gewunja lewąra ge pitja njḁnu wurgunu wuna kądjinu wa puŋgąninja wundjaŋuru i dągu wondijau ge God wondi ąŋgo:na wen' njini, kądjinba puŋgąnin. ");
INSERT INTO wro_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Ŋąmba wa Inaiuri gejau tjau puŋgandjunja, iwiliri kari wa panmundulbenja; O! adburieja wuŋja, arka ąŋgąmurąŋ, lewąra ge tjau kuŋgandjuna. ");
INSERT INTO wro_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Gejau i:dja ŋąmba kadjunuri, Wai, Christ ŋuru kąnuŋ wai, ma! arąŋudjara; ");
INSERT INTO wro_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Gewunja pitja bḁri araiąndie Christ tjibareja, tjo:lbądaia tjibareja, umiimbaie, rąngąri pitja pąrąmiimbu, ąŋganbąrkadju wunja, ŋąmba kadju, adburieja. ");
INSERT INTO wro_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","O! Maranindj; wai, darawa kauurle kuŋeŋuniri. ");
INSERT INTO wro_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","Lewąra gejau, wurgunu ge pąle ŋąnja, marąŋunja wundugum pitja njeniŋaie, kunjila raląli pitja wa puŋgandjun, ");
INSERT INTO wro_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Jąlŋgandam andjo:l' di dagu pitja mewari:, wundjurulu ąndjo:l' kąri pitja ŋulin-ŋulin njawi:. ");
INSERT INTO wro_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Gejau pitja mąra irewu I:dj' iŋko:lu iŋgeŋgaliri ąŋguban nąnja wundjurulu dara, pąlemba nąnja. ");
INSERT INTO wro_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Gejau pitja ąnjaŋaŋawu wąląnŋąria, adburieja anąŋgaia pitja djḁruk ąnbąrąmeri mąndjum maiaruŋurim i dągam, kabąlba mamindjuŋuru i dągam, ąndjo:lu umindjuŋuru njini. ");
INSERT INTO wro_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","Weni tjilium maninja laiburu njidu bḁre-bḁre manąŋgam; wuno:murum malalindjeruba marąmbul' mąŋgąnuŋ, jedmąŋgąnu ko:gulejiri, laiburu njiduŋ miriŋunu lo:jenda. ");
INSERT INTO wro_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Wuna kądjinu njiri kuda:, wuno:murum mąra wurąŋunbu wuna kąniŋaieŋiri, laiburu njidu wodjulu kąnuŋ, maiamundu' nąnja. ");
INSERT INTO wro_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Nidji kuŋenuriri, Woi mąŋgadberi ąndja kądjinba kąmburuk padin, wuna darawa ko:rug kamieŋu njini. ");
INSERT INTO wro_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Ąndjo:lu a kabąlba pitja kąmburuk arąnu, ŋąla-ŋąla ŋaianąŋga kądjinba kąmburuk puŋgąnin. ");
INSERT INTO wro_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","Lewąra gejau i:dja kari wa laiburu padin, kari wąląnŋąria ąndjo:l' dąnja, kari Iŋko:lu, Iraia ekamandj. ");
INSERT INTO wro_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Maranindj, mu:n maro:, dadjurd wuri:; gewunja wa laiburu pinjidin ąŋudjau kąnuŋ. ");
INSERT INTO wro_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","I:dja kądjindja, naua-naua atją iŋgąnuŋ tḁmbium maiakąri' nąnja, maiarum anąngam maŋgaiąndiwela, ardawodjieja ŋąla-ŋąla ąŋgąnino:la, ardjeruŋadjeruŋ ŋu:na wunja, geŋunąŋga maiamunduŋąra mu:n kunja. ");
INSERT INTO wro_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Mu:n maro: gewunja, wa laiburu pinjidin ąŋudjau iŋgeŋgal inaiuri maiaraŋąra, ŋąmba kąlekąlem, ŋamba karo:ŋgum, ŋamba mi:puradba, ŋąmba mąmąŋgunu; ");
INSERT INTO wro_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Ŋamba mąlja-mąlja iŋgeŋgal mąra njinŋumbu kulunu njirkunuŋ. ");
INSERT INTO wro_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Ge ŋąnŋundjunuri ardarawaia kuŋenąŋgori, Mu:n maro:. ");
INSERT INTO wro_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Pale lewąra tjaruŋandu Wukiau, maia iroroi; ardenaiuri dadjurdkaria, wiri-wiri-ŋaria kuda: kub-arkanjiro:na mululu iŋgadba wunja, bąda iŋgarwu wunja. ");
INSERT INTO wro_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Gewunja kubądjuŋ, Kari maŋąrijau, madji jauum pamąnu peleŋgąraia nanja. ");
INSERT INTO wro_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Bethany nąnja iŋgąnineri, maiarum maninja Simon leper anąngam. atja ingauwoneri mąnari nąnja, woŋaiinja njeŋgunal alabaster mulugu kudai ąŋgaiameri nąra nard inia ŋara-ŋąra, mulugu kule-mala, pąlulu kundjuŋu imri: nąnja. ");
INSERT INTO wro_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Mia atjąkekąria arge wurura ardji:la kauer-ąmąŋ, Aŋudjakunja ąŋgaiameri ŋara indja wundur kauwi:ŋu? ");
INSERT INTO wro_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Gewunja ąŋgaiameri ŋąra indja ko:l pąŋgąni:nja kaiug dara wunja, ardjeja nąnja paŋgąno:wi:nja. Jau njimbąrkaŋurula. ");
INSERT INTO wro_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","O! Jesu kundjuŋu, Njininja; ąŋudjakunja njiraŋaliŋgeri? Wunia kundjuŋara. ");
INSERT INTO wro_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Ardjeja kudai njiri kądjinma njiduŋ, ŋąmba ŋe wurąŋundju wunia wuriąnąŋgori, ŋaiu kądjinma wa panjiraŋurun. ");
INSERT INTO wro_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Njąŋga kundjuŋu ge wunja. Ŋąŋanąba kauurlejau maiamala ro:k kunja. ");
INSERT INTO wro_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Nidji kuŋenuriri, Ma maiągekąrim maninja wąląnu-wunia ardi:um kaluieŋu bąndaia daraiu nąnja, ge woŋaiin' njina geŋu pitja njaluie ni: njiŋgaŋurieŋu wunja. ");
INSERT INTO wro_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Judas Iscariot, iḁrun twelve, (ąnnenŋąlja), nąnja, ardenaiuri dadjurdkąria kanmurkąlaŋuru, ąŋgąnino:nąŋga wunja. ");
INSERT INTO wro_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Arka, wuno:murum ŋuru ąŋgąnina, tjukul kadineri, tjauaien kubądjuŋanąŋga kaiug iŋgado: wunja. Aua kuŋąnjio:na ŋḁrunąŋgọwu wuniama ąŋgąnino:nąŋga. ");
INSERT INTO wro_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Lewąra kauurle maia iroroi ŋąri, Wukiau iŋgarwuneda, inalalaia kubądjunąŋga, Ŋḁnąm njiriuri kundji:njḁri ardamanja anjerkungḁndju, Wukiau mindjḁl tjuŋundju wunja? ");
INSERT INTO wro_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Inalalandu kaŋaŋawandu, kundjunąŋgandu, Manaiudba ŋuru njiriŋurandu pitja njinjąmąndjerandu i:dja wurawa agu mano: kaŋuriri; irąmalando:wandu; ");
INSERT INTO wro_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Ma dąra iŋgeŋuru wurinąŋgandu i:dja maiara' ŋąra, Iniiŋgundeja kundjiri, Ŋḁnąm balaium nauadjen ŋąrim ŋaianąŋgam, ma Wukiau pitja mindjḁl ŋe ŋḁnalalaia nąnja? ");
INSERT INTO wro_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Aua ŋundju-ŋundju pitja njinjąmiimbandu balaium karąŋ ŋąrim manaiudba manamanja mąŋgandjuiena; ma ardamanja arandju ŋḁri wunja. ");
INSERT INTO wro_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Inalalandu keŋaŋurandu manaiudba mamurkalalgandu, mąra ko:nandu kądjinu geŋunąŋgandu, Wukiau ardamanja kangąndjunandu. ");
INSERT INTO wro_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Kąlekąlem njiŋgaŋina, aua keŋgal twelve, (ąnŋenŋąlja), nąnja. ");
INSERT INTO wro_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Wąli atją aŋgauwoneri, mindjąl kadjuŋiri, Jesu kundjuŋu, Nidji kuŋenuriri, iḁruŋ njiri nąnja tjiriwin pitja mewara. ");
INSERT INTO wro_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Wunmanbąli pakul kadineri, iḁruŋ iḁrun kubądjuŋanąŋga, Ŋaiu? ");
INSERT INTO wro_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Aua kundjuŋąnąŋgori, Iḁrun twelve, (ąnnenŋąlja), nąnja, ŋaiu nąnja ąŋgąm maninja tjąkąl kaiąb. ");
INSERT INTO wro_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Mia I:dj' iŋko:lu ko:ru keŋuru kądjinu wiri-wiri kauwi:nanąŋga; O! wurgunu i:dja nąnja aia nąnja I:dj' iŋko:lu tjiriwin mąŋgauwi:na. Wunianąŋga ma i:dja aia ŋąmba wa pąŋgalelwenja. ");
INSERT INTO wro_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Wąli mindjḁl kadjuŋiri, maia kąmąŋ, wunia kulula, kąlemala, kano:na, kundjuŋu, Irąm, indja ḁŋŋanąba. ");
INSERT INTO wro_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Cup kąmąŋ, iŋgo:lbo:na kano:na, ardarawaia djo:jo: kubądjuŋanąŋga. ");
INSERT INTO wro_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Kundjuŋąnąŋgori, Indja gulu ŋaianąŋga, tjauaien ŋąri, pḁlulu kḁniŋaieŋu ardarawaia wunja. ");
INSERT INTO wro_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Nidji kuŋenuriri, Kądjinba njele djo: pąŋeŋąn kurab wuŋgalalidjerugu ŋąra, lewąra ge njini iŋunąli pitja djo: ŋeju bąndaia God anąŋga nanja. ");
INSERT INTO wro_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Kan ąŋgąnina dąnde kariŋaŋuru kurandu Oliva ŋąri ŋuru. ");
INSERT INTO wro_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Jesu kundjunąŋgori, Njidarawa pitja nḁri njirąmie; gewunja wiri-wiri kauwi:ŋu, Kukundja ŋąra pitja ŋoiil ŋenąŋga, kukundjeria pitja tjauala pąla arọwa. ");
INSERT INTO wro_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Wunmanbu kunina, pąle bḁri ŋḁnŋundjąndieŋu, njidbąnŋąle ŋuru pitja ŋejuŋuru Galilee ŋuru. ");
INSERT INTO wro_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Gejau Peter kundjuŋanąŋga, Ardarawaia ŋąmba nḁri ąŋgąmieŋu, ŋaiu kari. ");
INSERT INTO wro_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Jesu kundjunąŋga, Nidji kuŋenu, weni wundugum, punąra tjḁruŋandu wąli wa jero:l puŋgen ŋąri tjḁruŋuri pitja ŋunjariiara. ");
INSERT INTO wro_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","O! njḁdbama djenbeŋuru kulula, Ŋaiu ŋąmba debąra ŋḁnŋunjąŋa ŋundju nąnja, kądjinba pąŋariinu. Ge kądjinu kuda adarawaia kubądjuŋ. ");
INSERT INTO wro_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Tambium madburkal Gethsemane mąŋgarimiena; inalalaia kundjunąŋgori, Ŋuruma atją njirwa, wąli dadjurd ŋḁnŋundju. ");
INSERT INTO wro_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Kąmuri aua nąnja Peter a James a John, wunmanbąli djenbeŋuru rąngąri keŋa, tjąbąra mamienanąŋga. ");
INSERT INTO wro_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Kundjunąŋgori, Ŋḁŋuma pakul djenbeŋuru ŋḁnuŋ, ŋąmąn njini; ŋuruma atją njidu, mu:n maro:. ");
INSERT INTO wro_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Mąnŋąle iraiu keŋaŋuru, kabąlba nąnja kauwona, dadjurd kundjuŋu ŋąmba kąnuŋ wunja aua i dągu pąŋgawąndjḁlu. ");
INSERT INTO wro_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Kundjuŋu, Abba, Iraia, darawa gole pindji:; cup wuna tjḁno:ŋgu; wunmanbu kunina, kari ŋaiu ne ŋḁnŋundju, O! ŋundju ŋe tjuŋundju. ");
INSERT INTO wro_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Keŋgal, mąra kanbiri kulunu ąŋgąnuŋiri, Peter kundjunąŋga, Simon, ko:ru kulunu ŋunuŋiri? Wawu mu:n pąmąndjo:ndjiri tjḁruŋiau? ");
INSERT INTO wro_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Mu:n maro:, dadjurd wuri: pinjiriŋuriri wuŋgundjuie ŋuru; arkuma korega, arwiliria djima. ");
INSERT INTO wro_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Njele keŋaŋuru, dadjurd kundjuŋu, ŋąla-ŋąla tjaue njele kulula. ");
INSERT INTO wro_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Njele keŋgunal, mąra kanbuna kulunu aŋgąnineri, arkumbula nima djenbeŋuru kunineri; wa laiburu padinja ŋḁnąŋga workundjo:lba kubądjuŋ. ");
INSERT INTO wro_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Keŋgal pąlejau, kundjunąŋgori, Kulunu njidu weni, ŋoiba njidu, gole wąli, gejau kunjąŋgunal; wai, I:dj' iŋko:lu tjiriwin iŋgauwi:nu arworia ardori nąnja. ");
INSERT INTO wro_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Bḁri njidu, ŋḁriuri; wai, aua tjiriwin mąŋgo:wara wodjulu kąnuŋ. ");
INSERT INTO wro_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Maiirgi:rkum, wąli kaluleri, keŋgal Judas, iąruŋ twelve, (ąnŋenŋąlja), nąnja, aua nąnja peleŋgąraia kuldjuru a dia kudai, ardenaiuri dadjurd kąria i dągu, wiri-wiri ŋąria, mababaia i dągu. ");
INSERT INTO wro_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Aua tjiriwin mąŋgo:nanąŋga umiimbaie kano:na, kundjuŋiri, Aua iŋąngulbo:. aiąkawąli; irąm, nḁmululum iraŋuru. ");
INSERT INTO wro_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Wuno:murum iŋgeŋgunal, maiirgi:rkum kąmurkąla, kundjiri, Rabbi, ko:lbo:na. ");
INSERT INTO wro_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Ardori kauerąmąndanala, kauerąmąŋ. ");
INSERT INTO wro_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","O! iąruŋ arka nąnja ma ąŋgauwelgenjiri, kuldjuru anąnga ri: kąmąŋ, inaiuri dadjurd kąra inawodjieja ko:na, ini:um dur mo:na. ");
INSERT INTO wro_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Jesu kandjo:lbąla, kundjuŋąnąŋgori, Ko:ru ba njireŋgunal lulun ŋąra nąnja kądjindia, kuldjuru a dia kudai lḁburd tjḁrąŋunma wunja? ");
INSERT INTO wro_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Tjile-jile ŋḁnŋuninanuriri dadjurdkąrim manaiudba nąnja njinŋuniiŋgundaleri, njiri wa pąnjiraŋurunja; mia wuna kuniŋaiena mili-mili ko:rug ąŋgąmieŋu wunja. ");
INSERT INTO wro_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Ardarawaia kaueriąndiwela, kubądaiila. ");
INSERT INTO wro_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Algunja iḁruŋ kąmalando:na aua nąnja, wobi dąda ŋąra womura iŋgąnina, inąmiari iŋanąbeka manma; lḁburd kauerąmąŋ; ");
INSERT INTO wro_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","Wobi dąda ŋąra kąmąŋgi:la, inąmiari kundaiila. ");
INSERT INTO wro_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Jesu kaielwa kaueraŋurula inaiuri dadjurd kąra ŋuru; djḁruk kadbiena aua nąnja miriŋu ardenaiuri dadjurd kąria a mababaia a wiri-wiri ŋąria. ");
INSERT INTO wro_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Peter bọwora kąmalando:na, mamulba njini, maiarum maninja, inaiuri dadjurd kąra anąŋgam; atją kauwoneri mąląni' ŋąria nąnja, aua dąrarąra kundjuŋiri kąlaŋgąla geŋiri wiḁnu. ");
INSERT INTO wro_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Ardenaiuri dadjurd kąria, karwądeja ardarawawaia kuda, kubąrkąnjiro:na wunąŋądjaie Jesu wunja bąda iŋgarwu wunja; wa mąra puŋgarwi:nja. ");
INSERT INTO wro_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Ardarawaia tjibareja kadąŋądjaienanąŋga, ąŋgąnąŋądjaiena arge wurura wa panbądburkenja. ");
INSERT INTO wro_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Atjąkekąria karwelgenja, tjibareja kadąŋądjaienanąŋga, kubądjuŋiri, ");
INSERT INTO wro_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","Nuru kerkaŋurula geŋiri, Mḁna dadjurd kąrim wondi mąŋgauwi:na ardori njiniŋge pitja mąŋąmandju, lewąra tjḁruŋuri nąnja pitja wondi mąŋo: maiakąrim wondi mąŋgauwi:ŋu ardori mḁnąmiadba. ");
INSERT INTO wro_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Wurunąŋgọwu ąŋgąnąŋądjaiena arge wurura wa panbądburkenja. ");
INSERT INTO wro_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Inaiuri dadjurd kąra puląga nąnja kauwelgenja, Jesu burkai kaiąbuna, kundjuŋiri, Ŋḁnąŋga ąndja ąŋgąnąŋądjaieŋąnu? ");
INSERT INTO wro_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Aua kąmuk ko:na, kari wa pąŋgaio:lbenja. Njele inaiuri dadjurd kąra burkai kaiąbuna, kundjunąŋga, Ko:ru Christ ŋunuŋ, Tjukul ŋąra ŋunŋungula? ");
INSERT INTO wro_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Jesu kundjuŋu, Ŋaiu ŋḁnuŋ; pitja mąra irewu I:dj' iŋko:lu atją iŋgąnuŋiri wundjurulu worawerdum maninja, iŋgeŋgaliri ąŋguban nąnja ąndjo:l' kąri. ");
INSERT INTO wro_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Inaiuri dadjurd kąra wobi anąŋga dalar kąmąŋ, kundjiri, Ŋḁnia miri adąŋądjaieja ąŋgąnuŋ kuriiri? ");
INSERT INTO wro_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Djadi ŋuru kuraŋurula, ŋḁnąŋga ni: njidun? Ardarawaia wure kubądjuŋanąŋga imąn kunja. ");
INSERT INTO wro_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Atjąkekąria wunmanbąli tjipa kauero:na, imiŋum womura marwuna, paui kauerąmąŋ, kubądjuŋanąŋga. Tjo:lba minje: mąląni' ŋąria kauerąmąŋ dad kubądjuŋanąŋga arduna njiniŋge. ");
INSERT INTO wro_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Wąli Peter waiuru iŋgąnina maiarum maninja, njeŋgal ndjḁruŋunja njinawodjienja inaiuri dadjurd kąra anąŋgąnja; ");
INSERT INTO wro_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Mąra iŋgo:na Peter kalguneri, kąnindjąŋa, kundjiri, Ŋundju kuda: Nazareth ŋąra, Jesu nąnja, ŋunineri. ");
INSERT INTO wro_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Aua kariina, kundjuŋiri, Ŋaiu wa laiburu pąŋanin, wa puŋanenąn ŋḁni kundjiiri; dąnde keŋaŋuru mąnŋąli' ŋąri' ŋuru, gejau punḁra jero:l kundjuŋu. ");
INSERT INTO wro_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Njinawodjienja mąra ko:na wunmanbąli njele arka ma ąŋgauwelgenjiri kundjuŋąnąŋgori, Indja iḁruŋ arka nąnja. ");
INSERT INTO wro_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","O! aua njele kariina. Wąli pąlejau njele arka ma ąngauwelgenjiri Peter kubądjuŋanąŋga, Nidji ŋunuŋ arka nąnja, Galilee ŋąra ŋunŋunuŋiri. ");
INSERT INTO wro_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","O! Aua wunmanbąli djadi kundjuŋu, kanŋujo:na, Wa laiburu pąŋąninnąŋga i:dja indja irąŋunbalundjiri. ");
INSERT INTO wro_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Maiirgi:rkum tjilenda punḁra jero:l kundjuŋu. Peter ni: kuŋgaŋurula ŋąla-ŋąla Jesu geŋunąŋga, Punḁra tjilenda wąli wa jero:l puŋgen ŋąri, tjḁruŋuri pitja ŋunjariiara. Wuno:murum ge ni: kaŋurula, wola kundjuŋu. ");
INSERT INTO wro_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Maiirgi:rkum mąmąŋgunu ardenaiuri dadjurd kąria, mababaia nąnja, wiri-wiri ŋąria kuda:, karwadeja ardarawaia, kubąrwadeŋu, Jesu murd kauerąmąŋ, kaueraŋurula, Pilate kauerąnino:lanąŋga. ");
INSERT INTO wro_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Pilate burkai kaiḁbuna, Ko:ru ŋunaiuru Jew arkanąŋga? Aua kaio:lbąla, kundjunąŋga, Kundjaluiri. ");
INSERT INTO wro_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Ardenaiuri dadjurd kąria de kubąrwunanąŋga darawa. ");
INSERT INTO wro_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Pilate tjile burkai kaiḁbuna, kundjuŋiri, Ŋundju kari wa pandjio:lbąn? Wai, tjḁruŋ ŋḁnąŋga wuna de ŋunŋumbąrwu? ");
INSERT INTO wro_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","O! Jesu tjile wa pąŋgaio:lbenja; gewunja Pilate rangḁri keŋa. ");
INSERT INTO wro_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Mąŋąria kurijau burąŋgai iŋgąmąŋerida arka nąnja iaruŋ bur iŋgąni:neri, aua iŋgadiauwuna. ");
INSERT INTO wro_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Iḁruŋ kąnina iŋgąrimiena Barabbas, murd iŋgąmiena arka nąnja bḁri ąŋgaiąndiena, i:dja bḁri ąŋgaiąndiena bąda ąŋganbąrwuna. ");
INSERT INTO wro_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Peleŋgąraia pai kadina wunmanbąli burkai kaueriąbuna ge kądjinu geŋąnąŋgoririda. ");
INSERT INTO wro_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Pilate kandjo:lbąla, Burąŋgai imnjąmnjąri kuri:ara Inaiuri Jew arkanąŋga? ");
INSERT INTO wro_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Gewunja laiburu kąnina muŋur kunja ardenaiuri dadjurd kąria iŋgadino:la. ");
INSERT INTO wro_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","O! Ardenaiuri dadjurd kąria kanbądjurujuro:na peleŋgąraia, aua Barabbas burąŋgai iŋgąmąnąŋgori. ");
INSERT INTO wro_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Pilate tjile kandjo:lbąla kundjuŋąnąŋgori, Ŋḁni ge kuŋenąŋga irąŋundim Inaiuri Jew Arkanąŋga? ");
INSERT INTO wro_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Arka njele jero:l kubądjuŋ, Wongaia nąnja ande. ");
INSERT INTO wro_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Pilate kundjuŋąnąŋgori, Aŋudja kunja, ŋḁnąŋga woru kundjuŋu? Djenbeŋuru jero:l kubądjuŋ, Wongaia nąnja ande. ");
INSERT INTO wro_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Pilate korega kundjuŋu peleŋgąraia jedji ąŋgano: wunja, Barabbas burąŋgai kąmąŋąnąŋgori, Jesu kanino:la, wodpiliba iŋgaio:rala, wongaia wunja. ");
INSERT INTO wro_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Mąlani' ŋąria kaielwa kaueraŋurula maiaru' ŋuru Praetorium; mąlani' ŋąria ardarawaia ai kanbąrwu. ");
INSERT INTO wro_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Wobi tubudubulja tai kaueri:, imḁrulja wonąndja ŋąra paio iŋgarwuna, tai kaueri:. ");
INSERT INTO wro_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Wunmanbąli wulmai kubądjuŋanąŋga, Imlaraŋaia Inaiuri Jew arkanąŋga. ");
INSERT INTO wro_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Imri: ŋoiil kubadjuŋanąŋga ki:lŋgu njiniŋge, tjipa: kauero:na, luŋgu-luŋgudja kubądbąŋanąŋga. ");
INSERT INTO wro_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Wuno:murum umbili iŋgadbaŋ, wobi tubudububulja bura: kauerąmąŋanąŋga, wobi anąŋga mandjia tai kaueri:la. Kaielwa kaueraŋuru wongaia nanja iŋgarkąnde wunja. ");
INSERT INTO wro_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Kauerandju iḁruŋ tjḁnai iŋgeŋeri, Simon Cyrene ŋąra, Alexander a Rufus iranąŋgandu, iŋgeŋuru wunja wongaia mano: kaŋuru wunja. ");
INSERT INTO wro_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Kaueraŋural tḁmbium maninja Golgotha, ge jąka wąli kaluieŋu, Tḁmbium pąndju ŋąrim. ");
INSERT INTO wro_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Tjąmi kadinanąŋga wine luku-lukur kąra myrrh nąnja, aua wa pąŋgąmenja. ");
INSERT INTO wro_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Wongaia nąnja kauerande, wobi anąŋgaia wolara kaueralgara, kubądjąbuneri arka wunja, ŋani ąŋąm kubądjuŋiri. ");
INSERT INTO wro_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Mąmąŋgunu lewąra kunina, wongaia nąnja kauerandeŋu. ");
INSERT INTO wro_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Wiri-wiri de nari karan wiri-wiri kumbi:na, INAIURI JEW ARKANĄŊGA. ");
INSERT INTO wro_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Aua ŋąnja wongaia nąnja lulun ŋąrandu kauerandeŋandu, iąkąra worawerdum maninja, iąkąra mamauim maninja. ");
INSERT INTO wro_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Mili-mili ko:rug kąmiena, gejiri, Aua dulu: kaŋuriena arworia nanja. ");
INSERT INTO wro_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Arka tjąnaj ąŋgeŋeri jau kubądjuŋanąŋga, adbri: wona-wona kubądjuŋiri, kubąluleri, A, ŋundju dadjurd kąrim mąndjąŋunmąndjuiri, lewąra tjḁruŋuri wondi mąndjąŋunbu, ");
INSERT INTO wro_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Pąmąndulbaie, wongai' i dągu jeri bowal. ");
INSERT INTO wro_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Ge kądjinu ardenaiuri dadjurd kąria arge wurura umbili iŋgadbąŋ, wiri-wiri ŋḁria kuda:, kubadjuŋ, Atjąkekąria kanmunduibąla, aue wurura kądjinba pąŋgąmundulbaien. ");
INSERT INTO wro_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Christ, Inaiuri Israel, jeri kauwenja weni wongai' i dągu, arkanindj wunja, wa pąrkudjarąn. Auandu wongaia nąnja aua nąnja iŋgandienandu jau kundjuŋąnąŋgandu. ");
INSERT INTO wro_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Njileŋgąrinja njiŋgąnina, wundugum mąnina tḁmbium mararawam maninja jḁląŋgąru njini. ");
INSERT INTO wro_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Jḁląŋgąrujau Jesu ŋąla-ŋąla daraiu jero:l kundjuŋu, Eloi, Eloi, lama sabachthani? Ge jąka wali kaluieŋu, God ŋaianąŋga, God ŋaianąnga, ąŋudja kunja tjḁndjąndiwela? ");
INSERT INTO wro_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Atjąkekąria ma ąŋgauwelgenjiri, ŋuru ąŋgąnina, kubądjuŋ, Wai, Elijah ai ko:jiri. ");
INSERT INTO wro_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Iaruŋ tjḁri kumąŋ, irgem maiawora kudam kąlabu kundjuŋu, ki:lŋgu nąnja kuŋgąndeŋu, kąno:na djo: wunja, kundjuŋu, Kąninja, adjenindj Elijah ŋąmba iŋgeŋgal jeri iŋgaiąb wunja. ");
INSERT INTO wro_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Jesu ŋąla-ŋąla daraiu jero:l kundjuŋu, iŋandj wudi keŋa. ");
INSERT INTO wro_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Jarąla dadjurd kąrim manaiudba nąnja dalar keŋa karąŋ i dągu waiud' djini. ");
INSERT INTO wro_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Wuno:murum centurion, mąndjo:ri iŋgauwelgenjiri, mąra iŋgo:na wurunąŋgọwu iŋandj wudi iŋgeŋa, kundjuŋu, Nidji i:dja indja God Iŋko:lu kąnina. ");
INSERT INTO wro_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Woŋaia kuda: kadineri bọwora kaueranindjąŋeri, arka nąnja Mary Magdalena, Mary karanąŋgandinja James pidi:ndja a Joses, Salome kudanja; ");
INSERT INTO wro_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Arka wuno:murum Galilee nąnja iŋgąnineri, iŋgadbalando:neri, iŋgadawodjuŋeri; woŋaia ardarawaia atjąkekąria, aua nąnja Jerusalem ŋuru pai ąŋgąninal. ");
INSERT INTO wro_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Kąlekąlem njiŋgąnina, Wunamanjiau, ge jąka wąli lewąra kauurle Sabbath, ");
INSERT INTO wro_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Keŋgunal Joseph Arimathea ŋąra, kauadeja joimaląndja aua kuda: bąndaia God anąŋga kaŋąnjiro:na; dąrąngu dąra keŋaŋuru Pilate ŋuru, kąniauwuna durgu Jesu. ");
INSERT INTO wro_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Pilate rąngąri keŋa ŋąmba gole wuna debąra iŋgeŋa; ai iŋgo:neri centurion, burkai kaiąbuna, ŋąmba ŋḁnąŋgiau ŋąna debąra iŋgena. ");
INSERT INTO wro_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Wuno:murum ŋuru iŋgaŋurula centurion nąnja, durgu Joseph kąno:na. ");
INSERT INTO wro_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Aua wobi dąda ŋąra kąmurąŋ, jeri ingaiąbuna, wobi dąda ŋąra nąnja murdba kąmąŋ, kandeŋu kąnmenma nąnja, kaiug nąnja dur mąŋgauwi:na; kaiug ruluba kuŋgaŋurulal kąnmenma maiamundum maninja. ");
INSERT INTO wro_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Mary Magdalena a Mary Joses karanąŋgąnja mąra mo:nandu ma we iŋgandiena. ");
INSERT INTO wro_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Sabbath wundur kąniŋaiena, Mary Magdalena a Mary James karanąŋgąnja a Salome arkąniŋąria kanbądburąŋ, ąŋgeŋgal kunja, iŋgadjam wunja. ");
INSERT INTO wro_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Aliŋąri wundugum manma lewąra kauurle, kąnmenma mąŋgadburkal, mąrąŋunja bḁri njiŋgąnina. ");
INSERT INTO wro_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Arge wurura kubądjuŋiri, Ąŋguja ruluba kuŋgaŋuruŋąri kaiug kąnmenma maiamundu' nąnja? ");
INSERT INTO wro_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Kḁle ąŋgąnuŋ, mąra kanbąrwu kaiug gole ruluba kaŋuriena; daraiu djenbeŋuru kunina. ");
INSERT INTO wro_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Kąnmenma dąra ąŋgeŋgunal, algunja mḁra kauero:na worawerdum maninja atją iŋgąnineri, wobi iroroi tai iŋgąniŋaiena; rangąri kariŋa. ");
INSERT INTO wro_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Aua kundjunaŋgori, Rąngąri pinjiriiri, Jesu Nazareth ŋąra kąrąŋąnjiro:jiri, wongaia nąnja iŋgandiena; bḁri kąnina, ŋuru kauiąk; maranindj tḁmbium ma we iŋgarkandenu. ");
INSERT INTO wro_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Njiriuri, wurinąŋgori inalalaia Peter kuda:, Njidbąnŋąle ŋuru keŋaŋuru Galilee ŋuru; ma pitja mąra irewu, kądjinu geŋanuri. ");
INSERT INTO wro_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Dąnde kariŋaŋuru, kanmenma i dągu pąlja njininuri; gewunja djedjerawa ŋąria, rąngąri njiniŋaienuri; kari wa puŋgadji:njanąŋgorj, njiŋgo: lgunenjuri. ");
INSERT INTO wro_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Wuno:murum bḁri iŋgąnina aliŋąri lewąra kauurle, Mary Magdalena njąŋgurlenja mąra kauwi:nanąŋga, njiŋge i dądj agulaia ąnŋalja wai aŋgaiąbunanąŋga. ");
INSERT INTO wro_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Njąŋga njeŋaŋuru, arka aua nąnja ąŋgąnineri kundjuŋąnąŋgori, iŋgademaleri, wola:wuri ąŋgąnineri. ");
INSERT INTO wro_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Arge, wuno:murum ŋuru ąŋgąnina aua iedjer iŋgąniŋaiena, mara iŋgauwi:nanąŋga, kubąrkudjarala. ");
INSERT INTO wro_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Wuna pale dji:ŋuru mąra kauwi:nanąŋgandu, wudawa iŋgeŋandiri, bundul' kuru. ");
INSERT INTO wro_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Auandu keŋaŋurandu, atjąkekąria kundjuŋąnąŋgoriandu; arka kauerąŋudjaralandu. ");
INSERT INTO wro_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Pąlejau mara kauwi:nanąŋgori eleven, (anŋenŋąlja), arge wurura, atją ąŋgauwoneri mindjḁl kunja, jau kangąŋurula arge karkudjarala, argulum burudum, ąŋganbąrkudjarala mąra iŋgarwuna pąlejau bḁri iŋgąnina. ");
INSERT INTO wro_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Kundjuŋąnąŋgori, Njidjurli bąndaia daraiu ŋuru, wąląnu-wunia wurinąŋgori ardarawaia wondi ąŋgauwi:naia. ");
INSERT INTO wro_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Aua wa pąngąŋudjarḁn ŋąri, baptize iŋgąniŋaiena, pitja emundulbaie; aua iŋgąŋudjura pitja wure ewi:. ");
INSERT INTO wro_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Wuna umiimbaie pitja pąramalando: arge wa puŋgarkudjarąn; ŋḁŋumba nąnja agulaia pitja wai ąnbąro:, ąnbula iŋunąli njiniŋge pitja pąralu; ");
INSERT INTO wro_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Pąmąlinja pitja tjḁrawąd ąnbąram, debąd kari ŋąmba djo: ąŋgeŋa wa bąda panbąrwun; adbąramareja ardo:ri pitja ąnbąrąmąndana, arge adbulugu pitja arąniŋaie. ");
INSERT INTO wro_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Gejau Inaiuri Jesu, pąle kalulanąŋgori, ąndjo:l kuru kaŋuriena, God worawerdum maninja atją kauwona. ");
INSERT INTO wro_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Arka kariŋaŋuru, maiagekąrim maninja ardi:um kubąluleri, Inaiuri arka nąnja ŋuna kąnineri, ŋąla-ŋąla birem-bire kuŋgandjuna umiimbaie njiniŋge kąmalando:neri. Amen. ");
INSERT INTO wro_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Gewunja ardarawaia ardo:ri nąnja kauerą-mąŋ wiri-wiri wunja bḁre-bḁre ge ḁri nąnja wa pinjerkudjarąn ŋąri, ");
INSERT INTO wro_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Kądjinu ąnŋumbądino:la wundjaŋuru i dągu ḁdąŋądjaie arkunina ŋąla-ŋąla njerkundjuŋu, ");
INSERT INTO wro_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Wunia mąra kumbinara ŋaiu kuda:, wunbir-iau darawa kuŋąmalando:na, namululum tjḁdąman-ma wiri-wiri ŋḁnŋundjunu, Theophile ŋunia, ");
INSERT INTO wro_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Laiburu ŋunŋunuŋ nidji ŋąla-ŋąla wunja ŋunŋuniiŋgundiena. ");
INSERT INTO wro_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Kąnina Herod inaiurijau Judaea ŋąra iḁruŋ dadjurd-ŋąra iŋumba Zacharias, Abijah ŋąra, mąŋ-gąnąŋgąnja Aaron pąmąmarąnąŋgaia ŋąrinja, njąŋumba Elizabeth. ");
INSERT INTO wro_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Miriŋandu inia kąninandu mąnŋąle God, keŋ-andiri ŋąla-ŋąla God anąŋga darawa nąnja iwork-andu ŋuru-ŋuru. ");
INSERT INTO wro_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Woŋąląŋ ino:randu, gewunja Elizabeth njąŋgundinja njinina, miriŋandu mababandu. ");
INSERT INTO wro_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Ge kuniŋaiena, wąli aua dadjurd ŋąri geŋ-eri inaruba nąnja mąnŋąle God, ");
INSERT INTO wro_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Kądjinu dadjurd-ŋąra geŋirida, aua nąnja kumbana ŋuru iŋąnim duru kąmnji: wunja wuno:murum iŋgeŋa ŋuru dadjurd-kąrim ŋuru Inaiuri anąŋgąm, ");
INSERT INTO wro_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Peleŋgąraia ardarawaia worumbaia dadjurd kubądjuŋiri dąnde iŋąnimiau. ");
INSERT INTO wro_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Mąra kauwi:nananga wąląnŋąrą Inaiuri anąŋga, kauelgenjiri worawerdum maninja altar iŋąni' ŋąrim. ");
INSERT INTO wro_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Wuno:murum mąra iŋgo:na Zacharias ko:lgunąla, luren kumąŋ. ");
INSERT INTO wro_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Wąląnŋąra kundjuŋanąŋga, Puŋungulgunejiri, Zacharias, gewunja ŋad indjąŋunmąŋ nuru kuŋgaŋuriena, mąŋgąnja Elizabeth ibanaŋga pitja bḁri ejąndąnu, iŋumba pitja tjerim John. ");
INSERT INTO wro_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Pitja tjukul indjanana, jedji ŋunjọwa, ardarawaia pitja tjukul ewuranana kuli:n iŋgalelwona. ");
INSERT INTO wro_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Gewunja aua pitja inaiuri enu mąnŋąle Inaiuri; wine, djo: ŋąri wundjilwora kądjinba djo: pąŋgeŋąn, pitja kąlabu eni: Iŋandj Mąmaia nąnja karanąŋgąnja njąŋulum i dagam. ");
INSERT INTO wro_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Ardarawaia ąŋgo:lo:lia Israel pitja wolai ąnjiąb Inaiuri God arkanąŋga ŋuru. ");
INSERT INTO wro_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Aua pitja ejeŋuru imiŋum mąnŋąle iŋandj nąnja, iurulba nąnja Elijah anąŋga, wolai wunja arkaui iraraia arkanąŋga woŋalaląŋuja ŋuru, arka wa ŋuru paueraŋurun ŋąria ardi:u'ŋąri nuru tjądąŋuria arkanąŋga ŋuru, brar kunja worumba ardamanja ąŋganuŋanąŋga Inaiuri. ");
INSERT INTO wro_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Zacharias kundjuŋanąŋga wąląnŋąra, Ŋḁrunąŋgọwu wuna pitja laiburu ŋenu? Gewunja ŋaiu maba ŋḁnuŋ, mąŋganja mabąnja. ");
INSERT INTO wro_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Wąlanŋąra kaio:lbąla kundjuŋanąŋga, Ŋaiu Gabriel ŋḁnuŋ, nḁnŋumbąlgeŋu imąnŋḁleŋuru God, ŋanŋaŋawienal ŋanŋulunu wunja wąląnu wunia wuna ŋąngąŋuraldu wunja; ");
INSERT INTO wro_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Wai, ŋundjamugu pitja ŋunjąnu, kądjinba pindjalun lewara njini wuna kąniŋaienu, gewunja ŋąla-ŋąla ŋaianąŋga kundjąŋudjaralara, wuna pitja korug njąmie tjḁdąmiau. ");
INSERT INTO wro_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Peleŋgąraia kauerananaleri Zacharias, rąn gąri kariŋa aua maranu dadjurdkąrim maninja iŋgąnineri. ");
INSERT INTO wro_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Wuno:murum ba iŋgeŋgunal kądjinba puŋgalunjanąŋgori, mąra kauero:na aua mąra ąŋgo:na ardidjieja, dadjurdkąrim maninja; aua marali mo:nanąŋgori, iamidj atją kąnineri. ");
INSERT INTO wro_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Ge kuniŋaiena, wuno:murum ko:rug kąmiena gejau aua geŋiri, keŋaŋuru maiarum anąŋga' ŋuru. ");
INSERT INTO wro_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Pąle wuna Elizabeth mąŋgąnąŋgąnja mąnduwanja njinina, njiŋge ŋundju-ŋundju njindjḁlgiena kunjila inŋąlja, kundjuŋiri, ");
INSERT INTO wro_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Wunmąŋgowu Inaiuri kundjuŋara wuno:murum ŋḁnŋunindjąŋa edbrai ŋaianąŋga kundjąbunara wunja i:dja nąnja. ");
INSERT INTO wro_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Kunjila iakąrąjau wąląnŋąra Gabriel kąŋaŋawiena God idągu malaiinde' ŋuru Galilee nąnja manumba Nazareth, ");
INSERT INTO wro_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Njimbąridja nąnja tjauien njiŋgąniŋaiena i:dja nąnja iŋumba Joseph, David ŋąra, njiŋge njimbąridja njąŋumba Mary. ");
INSERT INTO wro_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Njąŋgamurkalal kundjuŋu, Njimląraŋaienja, tjukul ŋąrinja, Inaiuri ŋundju nąnja kąnuŋ. ");
INSERT INTO wro_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Ŋąla-ŋąla ge nąnja iląla njinina, njiniąkamanma kundjuŋu, Ŋḁnąŋga wulmai wuna? ");
INSERT INTO wro_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Wąląn-ŋąra kundjuŋanąŋga, Puŋungulgunejiri, Mary, gewunja God tjukul ŋunanala. ");
INSERT INTO wro_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Wai, mąnduwa pitja ŋunjąnu, ibo:lidj pitja kuli:n indjo:, iŋumba pitja tjerim Jesu. ");
INSERT INTO wro_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Pitja inaiuri enu, pitja erimie Karąŋ-ŋąra mandj Iŋko:lu, Inaiuri God pitja eno: imąla' kąrim David iranąŋga anąŋgąm. ");
INSERT INTO wro_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Aua pitja inaiuri enu Jacob ŋąria nąnja kądjinma, bąndaia anąŋga kądjinba kui puŋgąniŋaien. ");
INSERT INTO wro_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Mary kundjuŋanąŋga wąląn-ŋąra, Ŋḁrunąŋgọwu wuna pitja njḁnu, gewunja i:dja wa laiburu pąŋanin-nąŋga? ");
INSERT INTO wro_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Wąląn-ŋąra njindjo:lbąla, kundjuŋanąŋga, Inandj Mamaia pitja bud ŋunjo:, wundjurulu Karąŋ-ŋąra mandj anąŋga pitja djedba mewandjunu; gewunja kuda: aua mamaia ŋąra iŋgelelwa ŋundju nąnja pitja erimie God Inko:lu. ");
INSERT INTO wro_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Wai, Elizabeth ŋawanja ŋundjanąŋga kuda: ibanąŋga mąnduwa njinuŋ, mabąnja njiŋgąnun, weni pula: jau njąŋga nąnja njąŋgąrimiena njąŋgundinja. ");
INSERT INTO wro_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Gewunja ŋąla-ŋąla kari God anąŋga wundjurulu wuno:ra kądjinba puŋganin. ");
INSERT INTO wro_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Mary kundjunu, Wai, njinawodjienja Inai-uri anąŋgąnja; ŋaiu nąnja kuninja ŋąla-ŋąla ŋundjunaŋga nąnja. Gejau wąlan-ŋąra njindjąndiwela. ");
INSERT INTO wro_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Gejau Mary bḁri njinina njimurkąla ŋuru kurorandu ŋuru maiirgi:rkum malaiindem Juda ŋuru. ");
INSERT INTO wro_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Maiaru' ŋuru dąra njena Zacharias anąŋgąm, wulmai kundjuŋa-nąŋga Elizabeth. ");
INSERT INTO wro_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Ge kuniŋaiena, wuno:murum Elizabeth ŋuru njiŋgaŋurula wulmai Mary geŋunąŋga, ianda mąnduwanja njąŋganąŋga djuwąd kąnina, Elizabeth kąlabu njini:na Iŋandj Mamaia nąnja. ");
INSERT INTO wro_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Njąŋga jero:l kundjuŋu, ŋąla-ŋąla daraiu njiniŋge kulula, Ŋundju tjukul ŋąrinja woŋaia nąnja, tjukul ŋąra kurab ŋundju mąnduwa. ");
INSERT INTO wro_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Ŋḁru wuna ŋaiu nąnja, kąranąŋgąnja Inaiuri ŋaianąŋga ŋḁnŋumurkala? ");
INSERT INTO wro_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Gewunja, wai, ge-i-di-dągu, ŋala-ŋąla wulmai ŋundjanąŋga ŋḁni:um maninja kąni:na, iḁnda ŋaiu mąnduwa djuwąd kąnina tjukul wunja. ");
INSERT INTO wro_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Tjukul ŋąrinja njąŋga wa pąŋgąŋudjarenja, gewunja pitja ko:rug njḁmie kaluienanąŋga Inaiuri nąnja. ");
INSERT INTO wro_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Mary kundjuŋu, Ŋḁŋuma Inaiuri inaiur' Kąŋandju, ");
INSERT INTO wro_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Ŋḁŋandj tjukul kąninaieŋu God ŋaiu kḁremada nąnja; ");
INSERT INTO wro_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Gewunja aua njinindjąŋa njimbąldjinja njinawodjienja aŋaŋgąnja; Gewunja wai, pąle nąnja worumbaia ardarawaia ŋaiu tjukul ŋąrinja pitja ŋḁnbąrarim; ");
INSERT INTO wro_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Gewunja iurulba ŋąra wunaiuru kundju-ŋara; Mama:iŋumba. ");
INSERT INTO wro_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Wundjeriwie anąŋga kunuŋ worumba nąnja worumba njini arka iŋgarkugunuleri. ");
INSERT INTO wro_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Wundjurulu alum njiniŋgem kanmiimbuna; Papa: ŋąria tjauala: kandjąndąla ni: wunja ardi:um maninja. ");
INSERT INTO wro_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Ardjilwora adbąląkarim i dągam wai kandjąbuna, Arwąlŋaia brai kanji:la. ");
INSERT INTO wro_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Baia ŋąria barui kano:na ardinia njiniŋgeja; Tjiŋiria ardo:no:reja kanŋaŋawuna. ");
INSERT INTO wro_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Inawodjieja Israel kąnawodjąŋa, Wundjeriwie anąŋga ni: kaŋurula, ");
INSERT INTO wro_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","(Kądjinu kalulanąŋgori iraraia ŋarkanąŋgaia) Abraham ąŋgo:lo:lia kuda: kądjinma. ");
INSERT INTO wro_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Mary njąŋga nąnja atjḁ njinina kunjila iḁruŋuri, djo:li njininal maiarum njąŋganąŋgam. ");
INSERT INTO wro_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Gejau Elizabeth nḁnja ko:rug kumiena kuli:n kunja; ibąnąŋ bari kaiąndala. ");
INSERT INTO wro_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Njiŋge wururia ŋawawaia kuda: nuru kadina Inaiuri wundjeriwie wunaiuru kundjuŋanąŋga; tjukul kadina njąŋga nąnja. ");
INSERT INTO wro_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Ge kuniŋaiena, pale lewąra wunŋąlu, kariŋgunal ianda dur kunja, iŋgadimenja Zacharias iranąŋga iŋgaŋumbura. ");
INSERT INTO wro_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Karanąŋgąnja kandjo:lbąla kundjuŋu, Kari; pitja erimie John. ");
INSERT INTO wro_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Kubadjunananga, I:dja kah nawawaia nanja wa pangarimien inumba wuna. ");
INSERT INTO wro_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Irananga nunuin kadinananga narunangowu ingarim. ");
INSERT INTO wro_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Aua burkai kandjabuna mili-mili wunja, wiri-wiri kundjunu, Inumba John. Ardarawaia rangari karina. ");
INSERT INTO wro_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Maiirgi:rkum iamundu pąlkar kumiena, anbula, kulula, God ko:do:dala. ");
INSERT INTO wro_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Arge wururia karkulgunena, kurorandu darawa Judaea nanja nala-nala wuna darawa njauul-njauul kuninaiena. ");
INSERT INTO wro_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Ardarawaia nuru karkanurulaia kubadban ardi:um maninja, kubadjuniri, Anudja kara ianda indja pitja enu? Gewunja Inaiuri ino:ri aua nanja kunina. ");
INSERT INTO wro_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Irananga Zacharias kalabu kani:na Inandj Mamaia nanja, tjo:lba kundjunu, kundjuniri, ");
INSERT INTO wro_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","Tjukul nara Inaiuri God Israel ananga; Gewunja mia kanmurkalal worumba anangaia, burangai kandjabuna, ");
INSERT INTO wro_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Tjirimbirinja umundulbaie narinj a bari njindjandalanari Inko:lu David naria nanja. ");
INSERT INTO wro_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","(Kadjinu kalula ardjamundu nanja tjo:lbadaia mamaia ardindiria anangaia.) ");
INSERT INTO wro_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Umundulbaie ardauurgundj narkananga nanja, ardo:ri nanja ardarawaia narkubarkundjuru; ");
INSERT INTO wro_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Wundjeriwie kandju wunja iraraia narkananga nanja, Ni: kanuru wunja tjauaien mama: ananga; ");
INSERT INTO wro_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Tjauaien genunanga iraia narkananga Abraham, ");
INSERT INTO wro_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","Narkuno: wunja, ardauurgundj ardo:ri nanja nadbundulbaienu, Luren kari arkunawod jenja, ");
INSERT INTO wro_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","Mama: nąnja, tjḁdąŋuru nąnja, imąnŋąle ŋuru ŋadjedjera ŋarkunuŋiau. ");
INSERT INTO wro_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Jau, ŋundju, iḁnda, pitja ŋunjerimie tjo:Ibąda Karąŋ-ŋąra mandj anąŋga; Gewunja pitja ŋunjeju Inaiuri imiŋum imąnŋąle ŋuru tjuwąlja anąŋgaia brar kunja; ");
INSERT INTO wro_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Worumba anąŋgaia laiburu ąndjano: wunja' umundulbaie Umąra arkanąŋga wai kunja, ");
INSERT INTO wro_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Wundjeriwie God ŋarkanąŋga wunja, Wuna nąnja purḁŋgurąŋgunu karąŋ ḁlp kąjmnjeŋgunalgąri, ");
INSERT INTO wro_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Lei ąŋgo: wunja arge wundugum maninja atją ąŋgąnnŋiri, djedba debąra ŋąri ŋąnja; Ŋḁdjerdu kaielguruŋgu wunja kalumba jamulili ŋąra ŋuru. ");
INSERT INTO wro_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Iḁnd a kauwongenja, iŋandj birem-bire kąniŋaiena, bundul' dąnja kanineri gejau njini iŋgamiimbienanąŋgori Israel. ");
INSERT INTO wro_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Gejau kuniŋaiena, ŋąla-ŋąla Caesar Augustus anąŋga kunjąŋaŋuru bąndaia daraiu wiri-wiri kumbi:nja. ");
INSERT INTO wro_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Wuna wiri-wiri kauurle kunina Cyrenius inaiuri iŋgąnma Syria nąnja. ");
INSERT INTO wro_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Ardarawaia kariŋaŋuru wiri-wiri ąŋgauwi:ŋu wunja, iḁrundjḁruŋ malaiindem anąŋgą' ŋuru. ");
INSERT INTO wro_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Joseph kuda: pai kąnina Galilee ḁlp malaiindem Nazareth ḁlp Judaea ŋuru malaiindem David ŋąri' ŋuru mḁŋgąrimieŋu Bethlehem, gewunja David ŋąra aua madeja, ");
INSERT INTO wro_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Wiri-wiri iŋgauwi:ŋu Mary mąŋgąnąŋgąnja nąnja, mąnduwa: njiŋgąnineri. ");
INSERT INTO wro_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Ge kuniŋaiena, wąli ma iŋgąninandu, ko:rug kumiena njąŋga kuli:n kunja, ");
INSERT INTO wro_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Bḁri kaiąndąla ibąnąŋ iwulga, wobi murd kąmąŋ, kandeŋu buluman maia ŋąrim maninja, gewunja balaium maui maiarum maninja auandu wunja. ");
INSERT INTO wro_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Gejau kukundja ŋąria kadina tḁmbium ma nąnja, duiba kariŋeri, wiri-ŋaria kanbądidjąŋeri wulo:lum. ");
INSERT INTO wro_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Wąląn-ŋąra Inaiuri amąŋga kauwelgenja arkąnąŋedba, pąlemba Inaiuri anąŋga wo:ri kanbuneri, djenbeŋuru karkulguneri. ");
INSERT INTO wro_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Wąląn-ŋąra kundjuŋąnąŋgori, Pinjirgulgunejiri, gewunja wai, wąląnu wunia kuŋaŋuralduri, tjukul ŋąri djenbeŋuru, worumbaia ardarawaia pitja njḁnunąŋgori. ");
INSERT INTO wro_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Gewunja njiri nąnja weni kuli:n kauwona Kąremada, aiąkawąli Christ Inaiuri, malaiindem David ŋarim maninja. ");
INSERT INTO wro_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Wuna umiimbaienuri, iḁnda pitja mąra irewu wobi nąnja murd iŋgąmieŋu, buluman maia ŋąrim maninja iŋgandienu. ");
INSERT INTO wro_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Maiirgi:rkum wąląn-ŋąra nąnja kadina peleŋgąraia mąlani' ŋąria ąndjo:l' kąria, God kauero:do:daleri, kubądjuŋiri, ");
INSERT INTO wro_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","Pąlemba God nąnja karąŋ nąnja, kabąlba nąnja jḁmulili ŋąri, i:dja wunianąŋgori. ");
INSERT INTO wro_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Ge kuniŋaiena, wuno:murum wąląn-ŋḁria ąnganbądjąndiwela ąndjo:l' kuru, kukundja ŋąria kubąlula arge wururu, Bethlehem ko:ru madburka, worenindj wuna ko:rug kąmieŋu, wuna Inaiuri laiburu ŋarkuŋgandjuna. ");
INSERT INTO wro_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Pąlja mḁninḁl, Mary mąra njimbąrwuna a Joseph a lḁnda we iŋgauwoneri buluman maia ŋąrim maninja. ");
INSERT INTO wro_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Wuno:murum mąra karwuna laiburu kanbąrkąndjuna ŋąla-ŋąla wunja kaluienanąŋgori iḁnda indja wunja. ");
INSERT INTO wro_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Ardarawaia ŋuru ąŋgąnina rąngḁri kariŋa ge kaluienanąŋgori kukundja ŋąria nḁnja. ");
INSERT INTO wro_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Mary ŋąla-ŋąla wuna darawa kuŋgaŋurula, ni: kuŋgaŋurula njini:um maninja. ");
INSERT INTO wro_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Gejau kukundja ŋąria djo:li kadina, pąlemba ŋąra iŋgarkandjuna God, iŋgarko:do:dala darawa wunja ŋuru ąŋgąnina, mąra karwuna, kądjinu kaluienanąŋgori. ");
INSERT INTO wro_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Wuno:murum lewara wunŋenŋąlu ko:rug kąmiena iḁnda dur kunja, iŋumba kundimaiena Jesu, iŋgąrimaiena wąląn-ŋḁra nąnja wąli pąŋgąninja njąŋulum maninja. ");
INSERT INTO wro_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Wuno:murum lewąra ko:rug kąmiena njąŋga rar kunja ŋąla-ŋąla nąnja Moses anąŋga, kaŋurulalgąndu Jerusalem maninja Inaiuri tjąmi iŋgąnuŋąnąŋgandu wunja. ");
INSERT INTO wro_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Kądjinu wiri-wiri kauwi:ŋu ŋąla-ŋąla nąnja Inaiuri anąŋga, Ardarawaia auauąndjia arwulgulguja pitja ararimie mamaia Inaiuri nąnja, ");
INSERT INTO wro_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Mama: ŋąri tjąmi wunja kąkdjinu kaluieŋu ŋąla-ŋąla nąnja Inaiuri anąŋga, kulkulkoiandu, O! wauarandu kauauilandu. ");
INSERT INTO wro_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Gejau wai, i:dja kąnina Jerusalem maninja iŋumba Simeon, i:dja aia iḁduŋuru, inia kąnina, kuna:naleri jḁmbula ŋąri Israel arkanąŋga, Iŋandj Mamaia kąninanąŋga. ");
INSERT INTO wro_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Kumiimbaienanąŋga Iŋandj Mamaia nąnja aua kadjinba debąra pąŋgeŋąn wąli mąra pąŋgo:nja ŋąri Christ Inaiuri anąŋga. ");
INSERT INTO wro_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Aua keŋgunal Iŋandj nąnja dadjurdkąrim maninja; wuno:murum inenaiurgąndu iḁnda Jesu iŋgaŋurulalgąndu geŋunąŋgandu kadjuŋirida ŋḁla-ŋąla nąnja, ");
INSERT INTO wro_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Gejau aua ŋuri kąmąŋ, wunia kululanąŋga God, kundjuŋu, ");
INSERT INTO wro_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","Weni, Inaiuri, inawodjieja ŋundjanąŋga abi:lu ŋąri keŋenjaŋuru, ŋąla-ŋąla ŋundjanąnga nąnja; ");
INSERT INTO wro_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Gewunja ŋambula mḁra kuŋo:na umundulbaie ŋundjanąŋga, ");
INSERT INTO wro_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Ge wunamanja tjuŋungąndjuna adbąnŋąle ŋuru worumbaia ardarawaia adbiŋum; ");
INSERT INTO wro_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Marąma worumbaia ąnjąmiimbu wunja Worumba ŋundjanąŋga Israel pąlemba arkanąŋga. ");
INSERT INTO wro_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Iranąŋga a karanąŋgąnja rąngąri keŋandu ge kaluiena aua wunja; ");
INSERT INTO wro_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Simeon pali ko:nandu, kundjuŋanąŋga Mary karanąŋgąnja, Wai indja kandieŋu ąŋgauwona wunja, pai kunja ardarawaia Israel nąnja, umiimbaie wunja pitja njaluie ŋąnda wunja. ");
INSERT INTO wro_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Jau, kuldjuru ŋunŋandj ŋundjanąŋgamandj pitja dad njenu; gewunja ni: ardi:um mararawam maninja pitja njḁmiimbaie. ");
INSERT INTO wro_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Tjo:lbądinja njinineri Anna, Phanuel pamarąnąŋganja, worumba Asher ŋąrinja, maba manja, kulanąŋga nąnja njinina tjauądba mąnŋalb pąnąn pąlejau, ");
INSERT INTO wro_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Njimauarinja njinineri tjauądba eighty-four, (djenbeŋuru), dadjurdkąrim wa pąmaiąndiwenja, luŋgudja njiŋgąnineri, njiŋgaiamindji:njiri, dadjurd geŋeri, wundugum, lewąrajau. ");
INSERT INTO wro_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Ge-i-di-dągu njeŋgunal, God ko:lbo:na, kundjuŋu aua wunja ardarawaianąŋgori umundulbaie Jerusale' ŋąri ka:da:neri. ");
INSERT INTO wro_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Wuno:murum ko:rug kąmąŋandu darawa ŋąla-ŋąla nąnja Inaiuri anąŋga, djo:li kąninalgąndu Galilee nąnja malaiindem anḁŋgandam Nazareth. ");
INSERT INTO wro_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Iḁnda kauwongenja, dąrąngu iŋgąnina, ini:u'ŋąra, God jedji kauwonanąŋga. ");
INSERT INTO wro_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Keŋaŋurandu inenaiurgąndu tjauądba kądjinma Jerusale' ŋuru mąŋąri Wukiau ŋuru. ");
INSERT INTO wro_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Wuno:murum aua wii:la iŋgąnina, pai kąninandu mąŋąri geŋandirida; ");
INSERT INTO wro_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Wuno:murum ko:rug kąmąŋandu, wąli djo:li iŋgąninalgąndu, Jesu wii:la pale atją kąnineri Jerusalem maninja; inenaiurgąndu wa laiburu pąŋgąninjandu. ");
INSERT INTO wro_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Aua peleŋgąraia pulągori nąnja ŋali kundjuŋandu, tjaruŋiau keŋaŋurandu kalumba nanja, kąŋąnjiro:nandu arge wurura nąnja a laiburia nąnja. ");
INSERT INTO wro_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Wa mara paŋgo:njandu ŋąri, djo:li kaninalgandu Jerusalem, iŋgąŋąnjiro:wandu. ");
INSERT INTO wro_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Ge kuniŋaiena, pąle lewąra tjḁruŋuri, mara ko:nandu dadjurdkąrim maninja, atją iŋgąnineri pulągori adiiŋgundieja nąnja, ŋuru ąŋgaŋuruleri, burkaiba ąŋgaiąbuneri. ");
INSERT INTO wro_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Rąngąri kariŋa ardarawaia ŋuru iŋgarkaŋuruleri aua ini:u' ŋąri ąŋgaio:lbąla. ");
INSERT INTO wro_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Wuno:murum mąra iŋgo:nandu rḁngąri keŋandu, karanąŋgąnja kundjuŋanąŋga, Ibaia, ąŋudjakunja wurunąŋgọwu kundji:ŋunjḁrendu? Wai, iro:lidj ŋaiu kuda: ŋunbąrkąnjiro:nandiri pakul ḁdinanandiri. ");
INSERT INTO wro_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Aua kundjuŋąnąŋgandu, Ḁŋudjakunja tjḁrąŋąnjiro:nandiri? Wawu laiburu pinjidinjandiri naiu pąŋąnin Iraia ŋaianąŋga ŋąri? ");
INSERT INTO wro_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Auandu wa puŋganenenjandu ŋḁrunąŋgowu geŋunąŋgandu. ");
INSERT INTO wro_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Jeri kauwona auandu nąnja, Nazareth mamurkalal; ŋuru kaŋurulandiri; karanąŋgąnja ŋąla-ŋąla wuna darawa njini:um maninja kuŋgaŋuruleri. ");
INSERT INTO wro_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Jesu kauwongenjaŋuriri ini:u' ŋąra, iŋanąba nąnja, jedji karwonanąŋga God, i:dja kuda:. ");
INSERT INTO wro_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Tiberias Caesar inaiuri-jau, Pontius Pilate inaiuri Judaea nanja, Herod inaiuri Galilee nąnja, Philip ŋawanąŋga inaiuri Iturea, tḁmbium Trachonitis nąnja, Lysanias inaiuri Abilene nąnja, ");
INSERT INTO wro_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Annas a Caiaphas inaiurgąndu dadjurdŋąrandu, ŋąla-ŋąla God anąŋga kunjąŋgunaldąga John Zacharias iŋko:lu bundul' dąnja. ");
INSERT INTO wro_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Aua mamurkalal tḁmbium mararawum wo:ri mo:neri Jordan, ardi:um kululeri baptism kuluŋąn kunja, umąra wai wunja; ");
INSERT INTO wro_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Kądjinu wiri-wiri kauwi:ŋu mili-mili nąnja ŋąla-ŋąla Isaiah tjo:lbąda anąŋga, Ŋąla-ŋąla iḁruŋ jero:l gejiri bundul' dąnja, Brar wuriŋuru kalumba Inaiuri anąŋga, Tjuwąlja anąŋgaia tjḁdąŋuru arandjunuru; ");
INSERT INTO wro_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Mąŋuraim mararawum kąlabu pitja meniŋaie, Taląmban, kurandu darawa, waiuru pitja njḁniŋaie; Wunkoli-koli tjḁdąŋuru pitja njąnu, Arkwiangaia kalumba wongąląlum pitja arąnu, ");
INSERT INTO wro_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Arwiliria ardarawaia umundulbaie God anąŋga pitja mąra pąro:. ");
INSERT INTO wro_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Gewunja kundjuŋąnąŋgori peleŋgąraia iŋgadburkalal baptize ąŋgandjui:ŋu wunja aua nanja, Njiri kauauilaia kauanja ŋąria, ąŋguja njiniiŋgundąla wuraraiu wundji:la kengal? ");
INSERT INTO wro_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Gewunja bḁri iraiąnda kurab kuluŋan inia wunja; wa piriiri njirge wurura nąnja, Ḁri kudai Abraham irai; kuŋenuri God gole bari puŋgaianda kaiug wuna nąnja woŋąlaląŋuja Abraham wunja. ");
INSERT INTO wro_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Weni ŋadjura kandieŋu ŋuwonu wondudba nąnja; gewunja ŋuwonu darawa kurab inia wa bḁri pąŋgaiąndąn ŋąri, dur kumbi:ŋu, wia' nąnja kundjąbienu. ");
INSERT INTO wro_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Gejau peleŋgąraia burkai kaueriąbuna, kubądjuŋiri, Nani kundjedju? ");
INSERT INTO wro_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Aua kandjo:lbąla, kundjuŋanąŋgori, Aua wobi iaruŋandu kudai, kąno:nja aua ino:ra, aua mąŋąri kudai kądjinu kundji:nja. ");
INSERT INTO wro_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Kaiug-ŋąria kuda: kauerąmurkalal baptize ąŋgandjui:ŋu wunja, arge kubądjuŋąnąŋga, Iniiŋgundeja, ŋḁni kunjedju? ");
INSERT INTO wro_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Aua kundjuŋąnąŋgori, Purąmureri tjilenda njiri wunja wiri-wiri kauwi:ŋu. ");
INSERT INTO wro_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Malani' ŋąria kuda: burkai kaueriąbuna, kubądjuŋiri, Ari kuda: ŋḁni kunjedju? Aua kundjuŋąnąŋgori, I:dja kari kwiar pariiri, bḁre paraŋuriri, ląŋugu njirkanąŋga jedji njirwa. ");
INSERT INTO wro_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Worumbḁia ardarawaia iŋgadanaleri, ardi:ąka man ma ni: ąŋgąnineri John wunja, ŋąmba aua Christ iŋgąnuŋ; ");
INSERT INTO wro_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","John kandjo:lbąla, kundjuŋąnąŋgori ardarawaia, Ŋaiu ko:ru baptize njinji: agu njiniŋge; O! keŋgal iḁruŋ ii:lwora man dąga ŋaiu nąnja, ŋḁniọwu ŋḁnuŋamiri burangai inanŋuma irkąlja ierdu ŋąra anąŋga; aua pitja baptize njinji: Iŋandj Mąmaia nąnja, wria' nąnja. ");
INSERT INTO wro_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Mąndju' ŋąra anąŋga ino:ri nąnja, maiaŋąrim anąŋgam pitja rargąrim djenbeŋuru mewandju, wheat pitja djḁruk ema maiarum maninja, bululuk pitja wori nje wia' nąnja kądjinba puŋgamaren ŋąri. ");
INSERT INTO wro_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Wuniiŋgundie darawa tjąkekąri kululanąŋgori wąląnu-wunia i:dja nąnja. ");
INSERT INTO wro_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","O! Herod inaiuri, iŋgąmaiḁmbiena aua nąnja Herodias wunja ŋawanąŋga mąŋgąnąŋgąŋja, dara wunja Herod worn kandjuneri, ");
INSERT INTO wro_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Wuna kuda: kuŋgandeŋu darawa nąnja, bur ki:la John burkąrim maninja. ");
INSERT INTO wro_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Ge kunina wuno:murum i:dja ardarawaia baptize ąŋgąniŋaiena, Jesu kuda: baptize iŋgąniŋaiena, dadjurd geŋiri, ąndjo:lu pąlkąr kumiena, ");
INSERT INTO wro_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Jeri kauwonal Iŋandj Mamaia iŋanąba kuluko:ka kądjindja aua nanja, ŋala-ŋąla andjo:l'di dągu kunjąŋgunal, Ŋaiu ŋunŋungu:la, ŋedura ŋḁnŋundjunu, tjukul ŋunana. ");
INSERT INTO wro_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Jesu ŋundju-ŋundju punuŋgula kąnineri, ŋali kuniŋaiena Joseph iŋko:lu, Heli iŋko:lu, ");
INSERT INTO wro_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Math at iŋko:lu, Levi iŋko:lu, Melchi iŋko:lu, Janna iŋko:lu, Joseph iŋko:lu, ");
INSERT INTO wro_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Mattathias iŋko:lu, Amos iŋko:lu, Naum iŋko:lu, Esli iŋko:lu, Naggai iŋko:lu, ");
INSERT INTO wro_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Maath iŋko:lu, Mattathias iŋko:lu, Semein iŋko:lu, Josech iŋko:lu, Joda iŋko:lu, ");
INSERT INTO wro_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Joanan iŋko:lu, Rhesa iŋko:lu, Zerubbabel iŋko:lu, Shealtiel iŋko:lu, Neri iŋko:lu, ");
INSERT INTO wro_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Melchi iŋko:lu, Addi iŋko:lu, Cosam iŋko:lu, Elmadam iŋko:lu, Er iŋko:lu, ");
INSERT INTO wro_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Jesus iŋko:lu, Eliezer iŋko:lu, Jorim iŋko:lu, Matthat iŋko:lu, Levi iŋko:lu, ");
INSERT INTO wro_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Symeon iŋko:lu, Judas iŋko:lu, Joseph iŋko:lu, Jonam iŋko:lu, Eliakim iŋko:lu, ");
INSERT INTO wro_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Melea iŋko:lu, Menna iŋko:lu, Mattatha iŋko:lu, Nathan iŋko-lu, David iŋko:lu, ");
INSERT INTO wro_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Jesse iŋko:lu, Obed iŋko:lu, Boaz iŋko:lu, Salmon iŋko:lu, Nahshon iŋko:lu, ");
INSERT INTO wro_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Amminadab iŋko:lu, Arni iŋko:lu, Hezron iŋko:lu, Perez iŋko:lu, Judah iŋko:lu. ");
INSERT INTO wro_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Jacob iŋko:lu, Isaac iŋko:lu, Abraham iŋko:u, Terah iŋko:lu, Nahor iŋko:lu, ");
INSERT INTO wro_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Serug iŋko:lu, Reu iŋko:lu, Peleg iŋko:lu, Eber iŋko:lu, Shelah iŋko:lu, ");
INSERT INTO wro_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Cainan iŋko:lu, Arphazad iŋko:lu, Shem iŋko:lu, Noah iŋko:lu, Lamech iŋko:lu, ");
INSERT INTO wro_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Methuselah iŋko:lu, Enoch iŋko:lu, Jared iŋko:lu, Mahalaleel iŋko:lu, Cainan iŋko:lu, ");
INSERT INTO wro_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Enos iŋko:lu, Seth iŋko:lu, Adam iŋko:lu, God iŋko:lu. ");
INSERT INTO wro_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Jesu kąlabu iŋgąniŋaiena Iŋandj Mamaia nąnja, djo:li kąnina Jordan ḁlp, kaielguruŋgi:na Iŋandj nąnja bundul' kuru. ");
INSERT INTO wro_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Lewąra forty (da:ra) ko:ndjui:na agula nąnja. Gejau kari wa mindjḁl puŋgenjiri; wuno:murum gejau ko:rug kąmaiena, baia ko:na. ");
INSERT INTO wro_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Agula kundjuŋanąŋga, Nundju ŋąmba God ŋunŋungula, kaiug wuna minjenąŋga ge njini mąŋąri njḁnu. ");
INSERT INTO wro_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Jesu kaio:lbala, Wiri-wiri kumbi:ŋu, I:dja iedjer pitja wa pąŋgąnin mąŋąri njiniŋge ekamandj, O! ŋąla-ŋąla God anąŋga darawa njiniŋge. ");
INSERT INTO wro_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Pai kaŋurula, kąmiimbuna tḁmbium mararawam bąndaia nąnja nọa-nọa. ");
INSERT INTO wro_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Agula kundjuŋanąŋga, Pitja ŋunjano: wundjurulu wuna dara, pąlemba kąnąŋgam, gewunja kunauwi:nara, aua lai nanŋumbunanąŋga kąŋano:; ");
INSERT INTO wro_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Gewunja ŋundju ŋąmba luŋgudja ŋunŋunuŋara, darawa ŋundjanąŋga pitja njḁnu. ");
INSERT INTO wro_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Jesu kaio:lbąla kundjuŋanąŋga, Wiri-wiri kumbi:ŋu, Lungudja bąnunąŋga Inaiuri God ŋundjanąŋga, auekamandj inawodju. ");
INSERT INTO wro_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Kaŋurulal Jerusale' ŋuru, kauwelgendjuna maŋuri nąnja dadjurdkąrim maninja, kundjuŋanąŋga, Ŋundju ŋąmba God ŋunŋungula, ŋunge ŋundju-ŋundju wai paiąbie ŋuru-i-dągu; ");
INSERT INTO wro_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Gewunja wiri-wiri kumbi:ŋu, Wąlḁnnąria anąŋgaia pitja njenąngori ŋundju wunja, ŋunbąranindj wunja, ");
INSERT INTO wro_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Ardo:ri nąnja ŋunbąraŋuru, madji ŋundjerdu kaiugu nąnja duk puŋgąm. ");
INSERT INTO wro_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Jesu kaio:lbąla kundjuŋanąŋga, Kuluieŋu, Pąndjo:ndjuiri God Inaiuri ŋundj anąŋga. ");
INSERT INTO wro_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Agula, wuno:murum dara wuŋgundjuie ko:rug kąmąŋ, wali kaiąndiwela. ");
INSERT INTO wro_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Jesu djo:li kąnina Iŋandj iurulba nąnja Galilee nąnja: djo:jąn kunjąŋaŋuru aua wunja tḁmbium mararawam wo:ri mo:neri. ");
INSERT INTO wro_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Kaniiŋgundala dadjurd-kąrim maninja arkanąŋgam, ko:lbo:wi:na ardarawaia nąnja. ");
INSERT INTO wro_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Nazareth mamurkala ma dąldja iŋgauwi:na, kądjinu geŋirida, Wunaiurujau dąra keŋaŋuru dadjurd-kąrim maninja, kauwelgenja ka:lu wunja mili-mili nąnja. ");
INSERT INTO wro_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Kąno:wi manąŋga mili-mili tjo:lbąda Isaiah anąŋga, mili-mili pąlkar kąmąŋ, inarub mąra mo:na ma wiri-wiri kauwi:na, ");
INSERT INTO wro_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","Iŋandj Inaiuri anąŋga ŋaiu nąnja, Gewunja ŋḁndja:mala wąląnu-wunia ardjeja ardi:um ŋḁnŋulunąŋgori wunja; Ŋanŋaŋawuna ardi:um ŋḁnŋulunąŋgori burąŋgai bur ąŋgąniŋiri, Arkumbambulidjia kąle mąŋgarwu wunja, Kubąn-kubąn ŋąria burąŋgai ąŋąnŋuma wunja, ");
INSERT INTO wro_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Ardi:um ŋḁnŋulu wunja wuniau Inaiuri anąŋga. ");
INSERT INTO wro_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Mili-mili tjilibid kąmąŋ, i:dja kąno:na, atją kauwona; arkumbula ardarawaia dadjurd-kąrim maninja kuni:nidjauwi:nanąŋga. ");
INSERT INTO wro_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Wun-man-bąli kundjuŋanąŋgori, Weni ko:rug kumieŋu wiri-wiri wuna njidi:um maninja. ");
INSERT INTO wro_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Ardarawaia kadąŋądjaienanąŋga, rąngąri kariŋa ŋąla-ŋąla wunia ŋąri keŋgunal iamundu i dągu, kubądjuŋ, Wawu indja Joseph iŋko:lu? ");
INSERT INTO wro_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Aua kundjuŋąnąŋgori, Nidji pitja wureluara, bḁre-bḁre wuna, Bąnmąndja, ŋundju-ŋundju pąmurdui:; ge ŋuru arkunina kąniŋaiena Capernaum maninja, ŋuru kuda: dju kąlguwam ŋundjanąŋgan maninja. ");
INSERT INTO wro_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Aua kundjuŋu, Nidji kuŋenuri, tjo:lbąda kari wa pąŋgąmien kąlguwam anąŋgam maninja. ");
INSERT INTO wro_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","O! Nidji kuŋenuri, Ndjo:ro:rinja njindarawanja njiladinja Elijahjau Israel nąnja, wuno: murum andjo:lu bur kąniŋaiena tjauądbajau maiaruŋurim, kunjila inŋąlja, moro:do:d njinina djenbeŋuru bąndaia daraiu nąnja; ");
INSERT INTO wro_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Elijah wa pąŋgaŋanawienja ardari' nąnja, O! Sarepta nąnja ekama, Sidon nąnja, woŋaiinja ndjo:rinja nąnja. ");
INSERT INTO wro_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Leper ŋąria ardarawaia kadina Israel nąnja Elisha tjo:lbądajau, atjḁruŋuja wa panbuduwi:nja, Naaman Syria ŋąra ekamandj. ");
INSERT INTO wro_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Ardarawaia ardji:la kauerąmąŋ dadjurdkąrim maninja, wuno:murum wuna ŋuru ąŋgąnina. ");
INSERT INTO wro_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Bari kadina, wai kaueriąbuna malaiindem dąnde ŋuru, kauerielguruŋgula wo:nąŋgąli tḁląmbąn ŋuru ma maliindem arkanąŋgam wondi maŋgauwi:na, wai iŋgadjąb wunja imri: ŋuru. ");
INSERT INTO wro_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","O! aua bulumąn keŋa arka nąnja, keŋanuru. ");
INSERT INTO wro_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Jeri kauwonal Capernaum nąnja, malaiindem Galilee nąnja. Kaniiŋgundaleri Wunaiurujau; ");
INSERT INTO wro_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Rąngąri kariŋa wuniiŋgundie nąnja, gewunja nala-ŋala anąŋga wundjurul' kari kunina. ");
INSERT INTO wro_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Dadjurd-kąrim maninja i:dja kąnina iŋandj agula inuru kudai, jero:l kundjuŋu, ŋąla-ŋąla daraiu, ");
INSERT INTO wro_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","Ai! ŋḁni kunjedjunu, ŋundju Jesu Nazareth ŋąra? Ŋunjąŋgunal ąndjąŋunmąndju wunja? Laiburu ŋḁnuŋąnu ŋundj' ąŋguja, Mamaia God anąŋga. ");
INSERT INTO wro_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Jesu kąmaiḁmbuna, kundjuŋiri, Kąmuk bowi:, ba beŋgaldąga. Agula iŋgaiąbuna puląga nąnja, be keŋgunaldąga, wa mareja puŋgąmenja-nąŋga. ");
INSERT INTO wro_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Rąngąri kunjąŋgunaldągori ardarawaia, arge wurura kubąluleri kubądjuŋiri, Ḁŋudja ŋąla-ŋąla wuna? gewunja wunaiuru nąnja, wundjurul' dąnja, arkandj arduria kundjunąŋgori, arka ba kariŋgal. ");
INSERT INTO wro_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Djo:jąn aua wunja kunjąŋaŋuru tḁmbium mararawa' ŋuru wo:ri mo:neri. ");
INSERT INTO wro_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Bḁri kąnina dadjurd-kąrim i dągam, dąra keŋaŋuru maiaru' ŋuru Simon anąŋgam. Simon kurumąnąŋgąnja lądja djenbenuru kundjuŋiri; burkai kaueriąbuna njąŋga wunja. ");
INSERT INTO wro_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Njindjanąla, lądja kumaiḁmbuna, wuna njindjąndiwela; maiirgi:rkum bḁri njinina, kanawodjąŋa. ");
INSERT INTO wro_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Wuno:murum mąrąŋunja njąŋgawoneri, ardarawaia adbąramareja kudai, mareja dji:dji: ŋąria, kanbądawungulaldąga; ardarawaia iḁruŋ-iḁruŋ ino:ri kanmąndanąla, kanmurduna. ");
INSERT INTO wro_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Agulaia kuda: ardarawaia ba kariŋgunaldągori, jero:l kubądjuŋiri, kubąluleri, Ŋundju God ŋunŋungula. Aua kanmaiḁmbuna, wa pa:nąŋunja ka:ralu wunja, gewunja arka laiburu ąŋgąnina-nąŋga aua Christ iŋgąnina. ");
INSERT INTO wro_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Mąmąŋgunu, ba keŋgunal, keŋaŋuru bun-dul' kuru; peleŋgąraia kaueraŋanjiro:naŋuriri, kauerąmurkalal; iŋgarkanenja, aua arka wa pandjḁndiwenŋuru. ");
INSERT INTO wro_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","O! kundjuŋąnąŋgori, Malaiindem maiḁkekąrim maninja wąląnu-wunia kuŋalunja bąndaia wunja God anąŋga, gewunja ŋḁŋaŋawiena. ");
INSERT INTO wro_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Ardi:um kululeri dadjurd-kąrarim maninja Judaea nąnja. ");
INSERT INTO wro_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Ge kunina, wuno:murum peleŋgąraia aua ŋąnja kudmun iŋgadjąndala ŋuru karkaŋuru wunja ŋąla-ŋąla God anąŋga, aua kauelgenjiri duŋunda agu Gennesaret, ");
INSERT INTO wro_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Mąra kumbunandii namąndi tjḁruŋandu kumbąlgenjandu duŋunda agu; djaia ŋąria kariŋaŋuru wundj'-i-dagu, net arkanąŋga kulai kanbąrwuneri. ");
INSERT INTO wro_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Dąra keŋa namąndi tjḁruŋ nąnja, Simon anąŋga, burkai kaiąbuna iŋgeŋuru wunja ruluk iraiu kabąlb'i dągu. Atją kauwona, peleŋgąraia kaniiŋgundąla namąndi nąnja. ");
INSERT INTO wro_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Wuno:murum ka:luleri wudun geŋu, aua Simon kundjuŋanąŋga, Njiriŋuru tjalani ŋuru, net njirkanąŋga wai araiąb arema wunja. ");
INSERT INTO wro_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Simon kaio:lbąla kundjuŋu, Inaiuri, wulo:lum mararium kerkąriŋiri, kari wa panjądbenja; mia ŋąla-ŋąla ŋundj anąŋga nąnja net pitja iŋaiąb. ");
INSERT INTO wro_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Wuno:murum ge kadjuŋu, bur kanbąri:la djaia wiri-wiri ŋąria djenbeŋuru; gewunja net arkanąŋgaia ka:lemi:neri. ");
INSERT INTO wro_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Mara:li marwunanąŋgori arkaŋąlja namąndi tjąkąri nąnja, ąŋgeŋgal ąŋganbądawodju wunja; arka kariŋgunal, namąndiandu kąlabu kubąrkandjuna ge njini pitja jauąk kauwenjandu. ");
INSERT INTO wro_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Wuno:murum Simon Peter kąnindjąŋa kauwona Jesu iluŋgu nąnja kundjuŋiri, Tjḁndjandiwe, gewunja ŋaiu i:dja umąra ŋąri, Inaiuri. ");
INSERT INTO wro_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Gewunja aua rąngąri keŋa, ardarawaia aua nąnja kuda:, wiri-wiri ŋąria djaia ąŋganbądburąn. ");
INSERT INTO wro_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Ge kądjinu James a John, Zebedee iŋko:landu, auandu iŋaŋąlguri Simon nąnja. Jesu Simon kundjuŋanąŋga, Puŋungulgunejiri, wuna pąle i:dja pitja ąndjąmeri. ");
INSERT INTO wro_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Wuno:murum namąndi karkaŋurulal kabalba nąnja, darawa kubądbąŋgi:la, kaueramalando:na. ");
INSERT INTO wro_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Ge kunina wuno:murum aua malaiindem maiaruŋum maninja iŋgaŋineri, wai! i:dja leper ŋąra iraraia; aua wuno:murum Jesu mąra iŋgo:na, imiŋum maninja kauwona kąniauwima, kundjuŋiri, Inaiuri, ŋąmba tjuŋudju wunja, ŋaiu rargąri tjḁngandju. ");
INSERT INTO wro_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Aua ino:ri la mamąŋ, kąmąndanąla, kundjuŋiri, Koru dudbąla, kuŋe wunja, rarwu bąnu; maiirgi:rkum leprosy kaiąndiwela. ");
INSERT INTO wro_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Kundjuŋanąŋga, I:dja kari pinclji:nąŋgoriri, O! baiuŋuru, pąmiimbaienąŋga dadjurd ŋḁra, tjąmi bąnu rargąri ŋunŋunina moia, ge Moses geŋida, umiimbaie wunja arka nąnja. ");
INSERT INTO wro_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Mia kunjąŋaŋuru djenbeŋuru djo:jąn aua wunja, djąruk kadbiena peleŋgąraia ŋuru iŋgarkaŋuru wunja, ąŋgąmurdui: wunja mareja arkanąŋgaia. ");
INSERT INTO wro_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Aua keŋaŋuru bundul' kuru, dadjurd kundjuŋu. ");
INSERT INTO wro_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Tjąruŋiau kaniiŋ gundaleri, Pharisia a adiiŋgundieja ŋąla-nąla ŋąria ma atją kadineri, arka ąŋgeŋgunal malaiindem mararawum ḁlp Galilee nąnja, Judaea nąnja, Jerusalem maninja; wundjurulu Inaiuri anąŋga aua nąnja kunina ąŋgąmurdu wunja. ");
INSERT INTO wro_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Gejau, wai! i:dja mano: kaueranuruleri inarugu nąnja i:dja iąla iŋgąnina, markandjuro:na iŋgarkaŋural kunja iŋgarkande imąnŋąle ŋuru. ");
INSERT INTO wro_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Wuno:murum wa mḁra pąmarwi:nja ŋąrunąŋgowu iŋgarkaŋural kunja peleŋgąraia wunja, pai kadina maiarum malerdu' ŋuru, jeri kaueriąbuna malerdu' ŋuru inarugu kuda: puląga nąnja imąnŋąle Jesu. ");
INSERT INTO wro_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Wuno:murum aua mąra ąŋgo:na arka wa pauerąŋudjarenja ŋąri, kundjuŋu, I:dja, umąra ŋundjanąŋga wai kundjąbieŋąnu. ");
INSERT INTO wro_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Wunmanbąli wiri-wiri ŋąria a Pharisia kubąrwądeŋu, kubądjuŋiri, Indja ąŋguja woru ka:luiri? Ąŋguja umąra gole wai puągaiąb, God auekamandj? ");
INSERT INTO wro_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","O! Jesu laiburu kąnina ardi:um maninja, kandjo:lbąla, kundjuŋąnąŋgori, Ąŋudja njidi:um maninja kurawadejiri? ");
INSERT INTO wro_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Ŋḁnąŋga wunia man dągu ŋąnŋulu wunja, Umąra ŋundjanąnga wai kundjąbieŋąnu, ŋąnŋulu wunja, Bḁri bąnu, wudawa baiu? ");
INSERT INTO wro_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Laiburu njirkunuŋ wunja I:dj' iŋko:lu wundjurulu kudai kabąlba nąnja umąra wai kunja, kundjuŋanąŋga iąla, Kuŋenu, bḁri bąnu, ŋunarugu tjḁrawąd minjąm, baiuŋuru maiarum ŋimdjanąŋga' ŋuru. ");
INSERT INTO wro_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Maiirgi:rkum adbąnŋąle ŋuru kauwelgenja, tjḁrawąd kumąŋ wuna nąnja we iŋgauwoneri, maiarum anąŋgam mamurkąląŋuru, God ko:do:daleri. ");
INSERT INTO wro_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Ardarawaia rąngąri kariŋa, God kauero:do:dala, luren kubądbąŋeri, kubądjuŋiri, Rąngąri weni mąra worwuna. ");
INSERT INTO wro_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Wuna pąlejau keŋaŋuru, mąra ko:na kaiugu ŋąra iŋumba Levi atja iŋgąnineri kaiug karim maninja, kundjuŋanąŋga, Tjḁnmalando:. ");
INSERT INTO wro_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Aua darawa kundjąndiwela, bḁri kąnina, kąmalando:na. ");
INSERT INTO wro_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Levi maia ardaiur' kangąndjuna aua wunja maiarum anąŋgam maninja; peleŋgąre djenbenuru kaiugu ŋąria atjąkekąria auandu nąnja atją kadina. ");
INSERT INTO wro_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Pharisia, wiri-wiri ŋąria arkanąŋgaia kuda:, inalalaia jau kanbąrkaŋurula, kubądjuniri, Ḁŋudja kunja kaiugu ŋąria nąnja, arwod' dąnja, mindjḁl kuriiri, djo: njiriŋiri? ");
INSERT INTO wro_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Jesu kandjo:lbąla, kundjuŋąnąŋgori, Adbuludja bąnmąndja wa lai pąŋgawon-nąŋgori, O! adbąramareja lai kauwonąnąŋgori. ");
INSERT INTO wro_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Wa pąŋeŋgunjal ai wunja tjḁdąŋuria, O! rworia kuluŋąn kunja. ");
INSERT INTO wro_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Kubądjuŋanąŋga, John inalalaia tjile-jile kadjamindjąŋa, dadjurd kubądjiri, ge kądjinu Pharisia arkanąŋgaia, O! ŋunalalaia mindjḁl kubądjiri, djo: kariŋiri. ");
INSERT INTO wro_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Jesu kundjuŋąnąŋgori, Pąnąnmoia jḁląlanąŋgaia, wąli pąnąnmoia arka nąnja iŋgąniŋiri, ko:ru kariamindja? ");
INSERT INTO wro_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","O! lewąra pitja njejeŋgal gejau pąnąnmoia arka nąnja pitja emąląŋaie, gejau pitja arejamindja, lewąra ge nąnja. ");
INSERT INTO wro_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Bare-bḁre kuda: kundjuŋąnąŋgori, I:dja kari aia dalar iŋgąmieŋu wobi iŋunali nąnja wa pąŋganden wobi inuŋgule nąnja; madji iŋunąli dalar pąŋgąm, iŋunąli inuŋgule nąnja wa pidjin pąŋgauwi:ngąndu. ");
INSERT INTO wro_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","I:dja kari wine iŋunąli wa pąŋganden waiḁm mḁnuŋgulem maninja; madji wine iŋunąli waiḁm muŋgur pąmo:, pḁlulu pąŋgąnu, waiḁm pitja bąda pamo:wi:; ");
INSERT INTO wro_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","O! wine iŋunḁli kandienja waiam maŋunąlim maninja. ");
INSERT INTO wro_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","I:dja kari inuŋgule djo: iŋgeŋa wa lai pąŋgawon-nąŋga iŋunąli; ge wunja kundjiri, Inuŋgule inia man dąga. ");
INSERT INTO wro_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Ge kunina Wunaiurujau bulumąn keŋa corn nąnja, inalalaia ri: kubądjuŋiri, mindjḁl kubądjuŋiri, corn ardori nąnja wurąŋgąn kubądjuŋiri. ");
INSERT INTO wro_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Pharisia atjąkekaria kubądjun, Ąŋudja kunja kuriiri ge wunia ŋuru-ŋuru Wunaiurujau? ");
INSERT INTO wro_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Jesu kandjo:lbąla kundjuŋu, Wawu laiburu pinjidinjiri wuna David geŋu wuno:murum baia iŋgo:na, arka aua nąnja kuda:? ");
INSERT INTO wro_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Dąra iŋgeŋiri maiaru' ŋuru God anąŋgam, kanmąŋ maia adbiimbaie ŋąria, mindjḁl kundjuŋu, arka aua nąnja ka:no:na, arge mindjḁl kunja wunia ŋuru-ŋuru, dadjurdŋąria argekamandj? ");
INSERT INTO wro_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Kundjuŋąnąŋgori, I:dj'iŋko:lu inaiuri kąnuŋ Wunaiurujau. ");
INSERT INTO wro_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Ge kunina Wunaiurujau tjąkąriau dąra keŋ-aŋuru dadjurdŋąrim maninja, kaniiŋgundąla; i:dja ma kąnineri, worawerdum anąŋgąm maralgam; ");
INSERT INTO wro_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Wiri-wiri ŋąria a Pharisia kaueranindjąŋeri ŋąmba Wunaiurujau iŋgąmurdu, mara karwuna-nąŋga wunja de iŋgarwu wunja. ");
INSERT INTO wro_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Aua laiburu kąninanąŋgori ni: ąŋgąnineri, kundjuŋanąŋga i:dja ino:ri dalga kudai, Bḁri bąnu, bọwelge puląga nąnja; aua bḁri kąnina, kauwelgenja. ");
INSERT INTO wro_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Jesu kundjuŋąnąŋgori, Burkai njinjiąb, Wuniọwu Wunaiurujau wunia workundju, woru workundju? Iŋaui workumbundulba, bąda arkumba? ");
INSERT INTO wro_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Wunjili:wa kanbuna ardarawaia nąnja kundjuŋanąŋga, Ŋuno:ri la mąma. Ge kundjuŋu, ino:ri kumurdui:na. ");
INSERT INTO wro_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Ardji:la bḁri kąnina, arge wurura kubąrwadeŋu ŋąni Jesu kadjunąŋga wunja. ");
INSERT INTO wro_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Gejau kunina dąnde keŋaŋuru tḁląmbąn ŋuru dadjurd kunja, kądjinma wundugum dadjurd kundjuŋąnąŋgeri God. ");
INSERT INTO wro_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Wuno:murum mąmąŋgunu njiŋgąnina, ai kanbuna inalalaia, arka nąnja kanmurąŋ twelve, (ąnŋenŋąlja), arge kandimąla arkaŋawieja, ");
INSERT INTO wro_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Simon aua kuda: iŋgąrimala Peter, Andrew iwomale, James a John, Philip a Barthomolew, ");
INSERT INTO wro_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Matthew a Thomas, James Alphaeus iŋko:lu a Simon iŋgąrimaiena Zealot, ");
INSERT INTO wro_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Judas James iŋko:lu a Judas Iscariot, aua iŋgąnina tjiriwin ŋąra. ");
INSERT INTO wro_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Jeri kauwonal arka nąnja kauwelgenja wauim maninja, peleŋgąraia ardarawaia inalalaia, peleŋgąre djenbeŋuru worumba Judaea marara-wum ḁlp, Jerusalem ḁlp, maiamiŋgum Tyre a Sidon, ");
INSERT INTO wro_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Arka ąŋgeŋgunal aua ŋuru iŋgarkaŋuru wunja, ąŋgąmurdui: wunja mareja arkanąŋgaia, arka pąmbąla ąŋgąnineri agulaia arduria nąnja kadburduwi:na; ");
INSERT INTO wro_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Peleŋgąre ardarawaia kubąrkąnjiro:na iŋ-gadbąndana wunja, gewunja wundjurulu auedągu kunjąŋgunal, ardarawaia kanmurduna. ");
INSERT INTO wro_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Ambula ba:l kumąŋ inalalaia nąnja kundjuŋu, Tjukul ŋąri njidje, gewunja njirkanąŋga bąndaia God anąŋga. ");
INSERT INTO wro_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Tjukul ŋąri njiri baia ŋąri weni, gewunja pitja barui njiranowi:. Tjukul ŋąri njiri wola: wur-ąŋundju weni, gewunja pitja djirai njirąnu. ");
INSERT INTO wro_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Tjukul ŋąri njiduŋ wuno:murum i:dja njin-ŋumbąrkundjuru, wolara njinŋumbąrkaru, jau njin-ŋumbąrkaŋuru, njirkumba wai kadjąb woru kąd-jinu I:dj'iŋko:lu wunja. ");
INSERT INTO wro_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Gejau tjukul njidu, kurkudjal njidu, gewunja wai! wunaiuru ląŋugu njirkanąŋga ąndjo:l' dąnja; gewunja ge kądjinu iranąŋgoria kubądju-ŋąnąŋgori tjo:lbądaia. ");
INSERT INTO wro_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","O! Wurgunu njiri nąnja, tjiŋi:ra, gewunja jḁmbula njirkanąŋga gole kurąmąŋ. ");
INSERT INTO wro_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Wurgunu njiri nąnja, weni barui wurąŋund-ju, gewunja pitja baia njinjo:. Wurgunu njiri dji-rai ŋąri weni, gewunja pitja wola: wureju, dji:rwa njirąnu. ");
INSERT INTO wro_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Wurgunu wuno:murum i:dja ardarawaia wunia njiri wunja ka:lu, gewunja ge kądjinu ira-nąŋgoria kubądjuŋąnąŋgori tjo:lbądaia tjibareja. ");
INSERT INTO wro_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","O! Kuŋenuri ŋuru njirkunuŋiri, Ardauurgu-nuria njidarienąŋgori, wunia wurinąŋgori ark a njinŋumbądjo:ndjuriria, ");
INSERT INTO wro_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Wunia wuralunąŋgori arka woru ka:lunuri, dadjurd wuri: arka wunja woru kadjunuri. ");
INSERT INTO wro_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Aua ŋunmąŋulp maiaruŋum ŋoiil ge, maiak-ąrim kuda: ino:, aua ŋunŋuno:ŋgu wobi ŋundja-nąŋga, iakąra wunja pąndjąmaiḁmbiri. ");
INSERT INTO wro_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Ano: ardarawaia ŋunŋumbądiauia, aua wuląnbiri ŋundjanąŋga ŋunŋuno:ŋgu, pąndjąniauwiri. ");
INSERT INTO wro_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Lai njirkumbąnanąŋgori i:dja kadjunuri ge kądjinu wurinąŋgori. ");
INSERT INTO wro_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","Njiri ŋąmba lai ąŋgawonanuri arka lai njirwanąŋgori, ŋḁnąŋga wungulbo:wie njiri nḁnja? Gewunja arworia kuda: kadarieŋanąŋgori ąŋganarieŋąnąŋgori. ");
INSERT INTO wro_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Njiri ŋąmba wunia wurąŋundjunąŋgori arka wunia kadjunuri, ŋḁnąŋga wungulbo:wie njiri nąnja? Arworia kuda: ge-i-di-dągu kubądju. ");
INSERT INTO wro_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Njiri ŋąmba njirkunawodjąŋa arka ni: njirkunuŋąnąŋgori arąŋunma njele, ŋḁnąŋga wungulbo:wie njiri nąnja? Arworia kuda: kadawodjieŋu arwor' ŋundju-ŋundjia ge-i-di-dągu kadba njele. ");
INSERT INTO wro_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","O! Njiri ardauurgunuri njidarienąŋgori, wunia wuri:, arano:wodju wa ni: pinjidin njele; ląŋugu wunaiuru pitja njḁnunuri, pitja njiranu Karąŋ-ŋąra mandj njinŋungula, aua inia iŋgḁnuŋąnąŋgori aljaljadbuneja a arworia. ");
INSERT INTO wro_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Araijeriwu, Iro:lidj kądjinu ąŋgaieriwu. ");
INSERT INTO wro_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","Wure paro:jiri, pitja wa wure pinjirwi:n; bąda paro:jiri, pitja wa bḁda pinjirwi:n; wai wuraiąb, pitja wai njejąbienuri. ");
INSERT INTO wro_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Arano:, pitja njḁno:wi:nuri; wunaiuru, wunia, pąndjuk ŋąri, lukuluk ŋąri, tjauaiba ŋąri mąląma njirkanąŋgam maninja pitja njinbąrano:; gewunja kądjinu arąŋano: ge kądjinu pitja njąno: wi:nuri. ");
INSERT INTO wro_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Bḁre-bḁre kuda: kundjuŋąnąŋgori, Ambulidj ambulidj kaielguruŋ? Wawu dagulum maninja pąŋgawengąndu? ");
INSERT INTO wro_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Inalala karąŋ wa pąŋgąnin inaiuri nąnja; O! ardarawaia gole ko:rug ąŋgḁmieŋu inaiuri kądjindjia pitja arąnu. ");
INSERT INTO wro_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","Ąŋudja kunja mandjanindj tjurnim nawalo: lidj ambula nąnja, ŋuwonu ŋungubul' dąnja wa pindjąnindjąn? ");
INSERT INTO wro_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Ŋḁrunąŋgowu pitja djenḁŋga nawalo:lidj, Ŋawaia, nali mḁŋamal tjurnim ŋungubul' dąnja, ŋunge ŋundju-ŋundju kądjinba pindjąnindjąn ŋuwonu ŋungubul' dąnja? Ŋunmiŋum mąljaljadbune, ŋundjurle wai tjąb ŋuwonu ŋungubul' dąnja, gejau pitja wunia mandjanindj tjurnim ŋawalo:lidj ambula nąnja mandjiąba wunja. ");
INSERT INTO wro_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","Gewunja ŋuwonu wunia kurab iwori wa bḁri pąŋgaiąndąn, tjąkąri njele ŋuwonu woru kurab inia wa bḁri pąŋgaiąndąn. ");
INSERT INTO wro_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Ŋuwonu darawa laiburu kuniŋaieŋu kurab kąnąŋga nąnja; gewunja wonąndja nąnja wa pąmadburąn tjili:um, kari irululu kakadja ŋḁri nḁnja kanera. ");
INSERT INTO wro_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","I:dja inia wunia iŋaui nąnja wunia ba kungąŋural; i:dja iwori woru iŋaui nąnja woru ba kuŋgąŋural; gewunja dara iŋaui nąnja iamundu kuluiri. ");
INSERT INTO wro_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","Ąŋudja kunja tjḁrarim Inaiuri, Inaiuri, wa piriin ge ŋḁnŋundju? ");
INSERT INTO wro_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Aua ŋḁnjąmurkal, ŋąla-ŋąla ŋaianąŋga ŋuru iŋgḁnuŋ ge kąminje, pitja njinjąmiimbu ąŋguja kądjindja iŋgḁnuŋ. ");
INSERT INTO wro_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Kądjindja kąnuŋ i:dj a maiarum mąŋgandeŋiri, aua tjḁri geŋiri tjalani, maiarum mąŋgandeŋu kaiugu nąnja; worumbąm mąŋgeŋgunal, maro:ralim dai mąŋgo:na maiarum ma nąnja, kądjinba jḁlala pąmo:nja, gewunja tjḁdąm mąŋgandiena. ");
INSERT INTO wro_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","O! Aua ŋuru iŋgąnuŋ, wa puŋgen, kądjindja i:dja maiarum mąŋgandeŋu kabąlba nḁnja waiuru mano:ruma, ma nąnja maro:lalim dai mo:na, maiirgi:rkum mauwona, djenbeŋuru malemi:neri. ");
INSERT INTO wro_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Wuno:murum wudun geŋu ŋąla-ŋąla dara anąŋga worumba ŋuru ąŋgąnineri, Capernaum maninja dąra keŋaŋuru. ");
INSERT INTO wro_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Centurion iḁruŋ i:dja anąŋga ara iŋgąnineri, kuŋgądjuneri, iŋgąnarienanąŋga. ");
INSERT INTO wro_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Wuno:murum Jesu wunja ŋuru iŋgąnina, kanŋaŋawuna aua nąnja arwawongąria Jew ŋąria, burkai kaueriąbuna iŋgeŋgal wunja, i:dja anąŋga iŋgąmurdu wunja. ");
INSERT INTO wro_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Wuno:murum Jesu iŋgadburkalal, njḁdbama burkai kaueriąbuna, kubądjuŋiri, Inia kąnuŋ aua wunja wuna tjuŋundju. ");
INSERT INTO wro_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Gewunja worumba ḁri kąnarieŋunjḁri, aue ŋundju-ŋundju wondi maŋgo:na dadjurdŋąrim ḁri wunja. ");
INSERT INTO wro_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Jesu arka nḁnja keŋaŋuru. Wuno:murum maiarum bọwora wa pąŋgąninja, centurion arkaŋalja aua nąnja kanŋaŋawuna, kundjuŋąnąŋga, Inaiuri, djądjeri pindjii:ri; gewunja ŋḁniowu ŋanuŋamiri ŋunŋunjąŋgal waiuru malerdum ŋaianąŋgam; ");
INSERT INTO wro_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Gewunja ŋḁwe wurura wa puŋenja ŋḁnia ŋḁnŋunuŋ ŋunŋunmurkal; O! ŋąla-ŋąla minje, gejau i:dja ŋaianąŋga pitja emurdui:. ");
INSERT INTO wro_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Gewunja ŋaiu kuda: i:dja ŋḁndieŋu wundjurulu waiuru, mąląni'-ŋąria ŋaiu kudai waiuru ŋaiu nąnja, indja kuŋenąŋga, Baiu, aua keŋga; iąkąra, Beŋgal, aua keŋgal; i:dja ŋaianąŋga, ge dju, ge kundju. ");
INSERT INTO wro_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Wuno:murum Jesu wuna ŋuru iŋgąnina, rąngąri keŋa, wąlŋarai kauwona peleŋgąre iŋgad balando:neri, kundjuŋąnąŋgori, Kuŋenuri, wa puŋgąŋudjarien-ŋąri wuna kądjinu wa mąra puŋo: nja, kari Israel nąnja. ");
INSERT INTO wro_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Arkaŋawieja djo:li kadinal maiarum maninja, i:dja mąra kauero:na imulugu. ");
INSERT INTO wro_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Ge kunina mąŋgundjiau, keŋaŋuru malaiinde' ŋuru maŋumba Nain, inalalaia peleŋgąre djenbenuru aua nąnja kariŋaŋuriri. ");
INSERT INTO wro_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Wuno:murum malaiindem maiamundum wodjulu iŋgąninal, wai, mano: kuŋgaŋuriena durgu i:dja, karanąŋgąnja iḁruŋamandj, njąŋga ndjo:rinja; peleŋgąre djenbeŋuru malaiinde' ŋąria njaŋga nąnja kadina. ");
INSERT INTO wro_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Inaiuri, wuno:murum mąra njiŋgo:na, njąŋgaieriwuna, kundjuŋąnąŋga, Wola: pindjii:ri. ");
INSERT INTO wro_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Wodjulu keŋgunal, mano:ŋąri kumąndanąla, arka mano: iŋgarkaŋurula karwelgenja. Aua kundjuŋu, Algunja, kuŋenu, Bḁri bąnu. ");
INSERT INTO wro_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Imandja atją kąnina, wunmanbąli kululeri, karanąŋgąnja aua njino:na. ");
INSERT INTO wro_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Ardarawaia karkulguneneri, God kauero:do:dala, kubądjuŋiri, Tjo:lbąda inaiuri bḁri kąni:na nari nąnja, God worumba anąŋga mia kanmurkalal. ");
INSERT INTO wro_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Djo:jąn wuna aua wunja kunjąŋaŋuru Judaea mararawa' ŋuru, tḁmbium mararawam wo:ri mo:neri. ");
INSERT INTO wro_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","John inalalaia wuna darawa kubądjuŋąnąŋga. John inalalandu ai ko:nandu, ");
INSERT INTO wro_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","Kaŋaŋawunandu Inaiud' dąnja, kundjuŋiri, Ŋundju aua iŋgeŋgal, iąkąrawu kedana? ");
INSERT INTO wro_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","I:gąndu wuno:murum iŋgąmurkalalgąndu, kundjuŋandu, John Baptist ḁrendu ąnŋaŋawunandu ŋundju nąnja kundjiri, Ŋundju aua iŋgeŋgal, iąkarawu kedana? ");
INSERT INTO wro_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Ge-i-di-dągu ardarawaia kanmurduna mareja, widji, agulaia arworia, ardarawaia arkumbambulidjia ka:no:na mąŋgadidja wunja. ");
INSERT INTO wro_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Aua kaio:lbąlandu kundjuŋąnąŋgandu, Njiriandu, wurinąŋgandu John arąŋunindjąŋandu, ŋuru njikuninandu; arkumbambulidjia kąle kadju, arwonwondadjia wudawa ąŋgeŋa, leper nḁri a rargąria ąŋgandjuiŋu, woŋąlaia ŋuru ąŋgąnuŋ, adbąn bḁri ąŋgaiąndieŋu, ardjeja wąląnu-wunia kalui:ŋanąŋgori; ");
INSERT INTO wro_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Tjukul ŋąra aua ŋaiu nąnja wa djiḁn puŋgąmąn. ");
INSERT INTO wro_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Wuno:murum wąląnŋąrandu John anąngandu iŋgeŋanurandu, wunmanbąli peleŋąraia kululanąŋgori John wunja, Aŋudja njiriŋanuru bundul' kuru mąra wunja? Ki:lŋgu jaląla mąndjum maninja? ");
INSERT INTO wro_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","O! Ḁŋudja njiriŋaŋuru mąra wunja? I:dja wobi mumula tai iŋgąniŋaiena? Wai! arka wobi adbąlalaia nąnja, tjiŋi:ra ąŋgeŋa, maiarum ardaiud' dąnja kadun. ");
INSERT INTO wro_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","O! Ąŋudja njiriŋaŋuru mąra wunja? Tjo:lbąda? Jau, kuŋenuri, inaiud' ban dąga tjo:lbąda nąnja. ");
INSERT INTO wro_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Indj-indja aua wunja wiri-wiri kauwi:na, Wai! wąląn-ŋąra ŋaianąŋga kąŋanądjaŋuru mąnŋąle ŋunmiŋum, Aua kalumba ŋundjanąŋga pitja brar njeŋuru mąnŋąle ŋundju. ");
INSERT INTO wro_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Kuŋenuriri, Arka nąnja kuli:n ąŋgauwi:na woŋaia nąnja kari inaiud' ban dąga John nąnja; O! aua pidi:n njini bąndaia God anąŋga nąnja iŋgąnuŋ, inaiud' ban dąga aua nąnja kąnuŋ. ");
INSERT INTO wro_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Worumba ardarawaia ŋuru ḁŋgḁnina, publicandjia, God kauero:do:dala, arka John nąnja baptize ąŋgandjui:na; ");
INSERT INTO wro_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","O! Pharisia, ŋąla-ŋąla ŋąria kuda:, wai kubądjąbuna ŋąla-ŋąla wuni:u' ŋąri God anąŋga, arka wa baptize parkandjuienja aua nąnja. ");
INSERT INTO wro_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Gewunja ąŋudja kądjindjia kaŋandju i:dja woi mąŋgadberi andja? Ąŋudja arka kądjindjia? ");
INSERT INTO wro_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Arka kądjindjia woŋąlaląŋuja tjo:lgarim maninja atją ąŋgąŋuŋ, atjąkekąria ai ąŋganbąrwiria arka kadjiri, Dendem marwunuri, wa djor piriinja; Wola: kunjedjuŋunuri wa pararemenja. ");
INSERT INTO wro_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Gewunja John Baptist keŋgunal wuro:dbori wa mindjḁl puŋgenja, wine wa djo: pąŋgeŋenja, gejau kuri:, Aua agula kudai. ");
INSERT INTO wro_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","I:dj' iŋko:lu keŋgunal mindjal geŋeri, djo: iŋgeŋeri, gejau kuri:. Wai, i:dja albąnda, djo: ŋara, iŋaŋalja publicandjia a arworia. ");
INSERT INTO wro_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Wuni:ndjąru tjḁdąŋuru kuŋgandjui:na wonąlaląŋuja ardarawaia kąnąŋga nąnja. ");
INSERT INTO wro_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Iḁrun Pharisee burkai kaiḁbuna mindjḁl kunja aua nąnja; dara keŋaŋuru maiaru' ŋuru Pharisee anąŋgam, atją kauwona mindjḁl kunja. ");
INSERT INTO wro_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Gejau, wai, woŋaiinja, njąŋga maliindem maninja njiwodj, wuno:murum laiburu njiŋgąnina aua atją ingąnineri maiarum maninja Pharisee anąŋgam, kaŋurulal alabaster ąŋgaiamieneri ŋąra, ");
INSERT INTO wro_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Pale ierdu nanja njimbąlgenja wola: geŋeri, wunmanbąli ierdu kulai kumbuna mandud' 'jiniŋgem, tjakąra njiniŋge njimri: ŋąri wuliŋgąra kundjuŋiri, ierdu kuŋgulbo:na, ąŋgaiamieneri ŋąra njiniŋge kundjamąla. ");
INSERT INTO wro_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Pharisee, wuno:murum mąra ko:na, aua burkai iŋgaiąbuna, iniąka manma kundjuŋu, Indja, ŋąmba tjo:lbąda iŋgąnuŋ, laiburu iŋgąnuŋ ąŋgunja, ąŋudja kąrinja njąŋga iŋgąmąndana, njiwodj njingąnuŋ. ");
INSERT INTO wro_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Jesu kaio:lbąla kundjuŋąnaŋga, Simon, ąŋudja-kąna ŋenu. Aua kundjuŋu, Inaiuri, minje. ");
INSERT INTO wro_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","I:dja iḁruŋ, iḁruŋandu tjaue kumbunanąŋ-gandu; iąkara tjaue kumbunanąŋga kaiug wunŋen-ŋąlu, iąkąra kaiug darawa. ");
INSERT INTO wro_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Wuno:murum ino:randu ingąninandu, ko:lulwa wai kimdjąbunanąŋgandu. Ŋḁniandu aia kąnarieŋunąŋgandu? ");
INSERT INTO wro_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Simon kaio:lbąla kundjuŋu, Kunenaŋga ŋana aua darawa wai kaiąbunanąnga. Aua kundjuŋąnąŋga, Nidji kundji:nu. ");
INSERT INTO wro_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Wąlŋąre njimurkala woŋaiinja, kundjuŋąnaŋga Simon, Ndjanindj woŋaiin' njina? Maiarum nundjanąŋgam dąra ŋeŋgunal, agu ŋaierdu wunja wa pąndjano:nja; O! njąŋga ŋaierdu kulai kumbuna mandud' 'jiniŋgem njąŋganąŋgam, wuliŋgąra kundjuŋu tjąkąra njiniŋge njąŋganḁŋga. ");
INSERT INTO wro_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Wa pąnjąngulbo:nja; O! njąŋga ŋḁnŋunjeŋgunalgule wa wudun puŋgenja ko:lbo:na wunja ŋaierdu. ");
INSERT INTO wro_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Ŋḁmri: wurŋi:wa njiniŋge wa pindjiamenja; O! njąŋga ŋaierdu ąŋgaiamieneri ŋąra njiniŋge kundjamąla. ");
INSERT INTO wro_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Gewunja kuŋenu, Umąra njąŋganąŋga wai kundjąbieŋimąŋga, ge darawa kunuŋ, gewunja djenbeŋuru ŋedura geŋu. Aua pidi:nu wai kaiąbieŋunąŋga, aua pidi:nu ŋedura kundjiri. ");
INSERT INTO wro_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Gejau kundjuŋąnąŋga woŋaiinja, Umąra ŋundjanąŋga wai kundjąbieŋąnu. ");
INSERT INTO wro_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Ark a aua ŋąnja atją ąŋgauwoneri wunmanbali arge wurura kubądjuŋ, Ąŋguja indja, aua kuda: umąra wai kaiąb? ");
INSERT INTO wro_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Aua kundjuŋanąŋga woŋaiinja, Wa puŋgąŋudjarien ŋąri nundjanąŋga ŋunmundulbąla; abi:la baiu. ");
INSERT INTO wro_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Ge kunina lo:jenda pąlejau aua keŋaŋuru malaiindem, maiarundjeruŋuma, ardi:um kululeri, kungąŋuruleri wąląnu-wunia bąndaia God anąŋga, twelve aua nąnja; ");
INSERT INTO wro_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Woŋaia atjąkekąria arka ąŋgąmurdui:neri agulaia arduria a mareja, Mary njąŋgąrimiena Magdalena, njąŋge-i-dągu ąŋgeŋa agulaia ąnŋąlja, ");
INSERT INTO wro_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Joanna mąŋgąnąŋgąnj a Chuza inaiuri Herod nąnja, a Susanna a njindarawanja ndjkekąrinja, arka ąŋganbądo:neri wuląnbiri arkanąŋgaia. ");
INSERT INTO wro_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Wuno:murum peleŋgąraia djenbeŋuru djḁruk aŋgąmiena, iŋgadburkalal malaiindem mararawum ḁlp, kulula bąre-bḁre nąnja. ");
INSERT INTO wro_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","Tjalangąnja ŋąra keŋaŋuru wolumbąra wunja tjḁląngąnja anąŋganja. Wąli wolumbąra geŋiri, ndjkekąrinja njąŋgari:na kalumba iaminim maninja; djąmbąba njindjo:riena, punaria wuŋo:ru ŋąria mindjḁl kubądjuŋanąŋga. ");
INSERT INTO wro_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Ndjkekąrinja njąŋgari:na kaiugu nąnja, njiŋge ba wa kundjuŋal, njindalga njinina gewunja agu njino:ra. ");
INSERT INTO wro_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Ndjkekąrinja njąŋgari:na wonąndja nąnja, wonąndja ba wa kubądjuŋal, limbitja kauero:na. ");
INSERT INTO wro_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Ndjkekąrinja njąŋgari:na kabąlba mḁnium maninja, ba wa kundjuŋal, kurab bḁri kaiąndąla irara. Wuna ka:lula, jero:l kundjuŋu, Aua ini:um kudai ŋuru wunja, ŋuru kąninja. ");
INSERT INTO wro_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Inalalaia burkai kaueriąbuna, Ŋḁnąŋga bḁre-bḁre wuna? ");
INSERT INTO wro_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Aua kundjuŋu, Njiri nąnja kuno:wi:ŋu laiburu wunja wundjąlgeje bąndaia ŋąri God anąŋga, O! atjąkekąria bḁre-bḁre nąnja, gewunja madidjeri wa pąmadidjąn, ŋuru ąŋgąnuŋiri wa puŋgadenąn. ");
INSERT INTO wro_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Bḁre-bḁre wima kunuŋ. Tjḁląnganja ŋala-ŋąla God anąŋga kunuŋ. ");
INSERT INTO wro_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Arka kalumba iaminim maninj a ark a ŋuru ąŋgąnina, gejau keŋgal agula kano:ŋgu ŋąla-ŋąla ardi:um maninja, madji wa puŋgarkudjarąn, arąmundulbaie ŋąna. ");
INSERT INTO wro_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Arka kaiugu nąnja arka wuno:murum ŋuru ąŋgąnina tjukul ŋąri ŋąla-ŋąla kubądba, arka wondudba ardo:no:reja, pulągajau wa puŋgarkudjarąn, ąŋgo:ndjui:ŋu jarąŋga kaduŋ. ");
INSERT INTO wro_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Njiŋge puląga wonąndja nąnja, arka ŋuru ąŋgąnina, wurgunu nąnja, wuląnbi' dąnja, tjukul ŋąri arkaui nąnja ąŋgeŋuriri, limbitja karwi:ŋu, kurab kari wa bḁri paueriąndąn. ");
INSERT INTO wro_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Njiŋge kabąlba manium maninj a, arka kaduŋ, argulum mąnium, aliŋąri nąnja, ŋąla-ŋąla ŋuru ąŋgąnina, njḁdba kubądba, kurab bḁri kaueriąnda njḁmula ŋąri. ");
INSERT INTO wro_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","I:dja kari wuno:murum tjanaim duru ki:la wa bur puŋgennąŋga ḁŋgąm maninja, wa puŋgan-den inarugu waiuru, O! tjanai' ŋąra nąnja kuŋgande, gewunja arka dąra ąŋgeŋgaliri tjanaim pitja mąra ewuro:. ");
INSERT INTO wro_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Gewunja kari kaielgaiena ŋąmba wa pitja mąra puŋgauwi:n; kari wundjąlgeje ŋąri ŋąmba wa pitja laiburu puŋgąniŋaien, ŋąmba wa pitja marąma nąnja puŋgeŋgunal gąri. ");
INSERT INTO wro_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Gewunja maranindj ŋḁrunąŋgọwu ŋuru njirkunuŋ, gewunja aua kudai aua nąnja pitja njḁno:wi:, aua ino:ra pitja eno:ngie aua nąnja ge mąra kauwi:ŋu aua kudai ŋąna. ");
INSERT INTO wro_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Kauerąmurkalal karanąŋgąnja a ŋawawanaŋgaia, aua nąnja kądjinba pareŋgunjal peleŋgąre nąnja. ");
INSERT INTO wro_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Kului manąŋga, Ŋundju karanja, nundju nawawaia, dąnde karwelgeŋiri, Mąra ero: kubądjiri. ");
INSERT INTO wro_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Aua kandjo:lbąla kundjuŋąnąŋgori, Ŋaiu karanja, ŋaiu nawawaia kaduŋ arka ŋąla-ŋąla God anąŋga ŋuru ąŋgąnuŋ, ge kadju. ");
INSERT INTO wro_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Ge kunina mąŋgundjiau aua dąra keŋaŋuru namąndi ŋąnja, aua ŋundjuŋundju inalalaia kuda:, kundjuŋąnąŋgori, Wo:ndum kanalu ŋḁriuri; bḁri kubąrkaŋurula. ");
INSERT INTO wro_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Wąli kariŋaŋuriri aua kulunu kąnina. Adjadjiri mąndjum maiąbaiąbenal wo:ndum maninja, kąlabu kundjuŋiri, arka wunauurgun' nąnja kadina. ");
INSERT INTO wro_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Kauerąmurkalal bḁri kaueriąndąla, kubądjuŋiri, Inaiuri, Inaiuri, debąra ŋḁriuri. Aua bḁri kąnina, mamaiḁmbunandu mąndjum a pąląŋgąrinja wo:ndum maninja, wudun kundjuŋandu, tjumulu kunina. ");
INSERT INTO wro_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Kundjuŋąnąngori, Nḁnąm wa puŋgąŋudjarien-ŋąri njirkanąŋga? Arka karkulguneneri, rąngąri kariŋa, arge wurura kubądjuŋiri, Indja ąŋudja kąra, aua mąndjum, wo:ndum genąŋgandu, mauandu ŋuru kaŋurandu? ");
INSERT INTO wro_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Madburkąla tḁmbium Gerasenia arkanąŋgam, ma inalu Galilee. ");
INSERT INTO wro_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Wuno:murum ba iŋgeŋgunal pąlul' dąnja, i:dja kąmąndjerąla malaiindem ḁlp, agulaia kudai, golema wobi wa tai pąŋgąninja, maiarum maninja wa atją pąŋgąninja, O! madem maninja. ");
INSERT INTO wro_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Wuno:murum Jesu mąra iŋgo:na, jero:l kundjuŋu, Ŋaiu ŋḁni kuŋenu, Jesu ŋunŋungula God Karąŋ ŋąra mandj? Burkai ŋunjiąb, pąnjąnbiri. ");
INSERT INTO wro_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Gewunja aua geŋanąŋga agula inuru ba iŋgeŋgaldąga i:dja nąnja. Gewunja tjile-jile laburd iŋgąmąn, kaŋuriena bur iŋgąni:na tjąŋadjąŋ nąnja, ierdu-ŋąria nąnja, tjąŋadjąŋ dalar kąmaŋ, kaŋaŋa-wiena agula nąnja bundul' kuru. ");
INSERT INTO wro_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Jesu burkai kaiąbuna, Ŋunŋumba ŋḁnąŋga? Aua kundjuŋu, Legion, gewunja agulaia ardarawaia dąra ąŋgenaŋuru aua nąnja. ");
INSERT INTO wro_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Arka burkai kaueriąbuna kari puŋgenjanąŋgori ąŋgeŋaŋuru tjalani ŋuru. ");
INSERT INTO wro_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Ma kadina wiriŋąri pig ardarawaia no:wa kadineri tḁląmbąn nąnja; burkai kaueriąbuna aua ąnjąnąŋu wunja ąŋgeŋaŋuru arka nąnja; aua kanąŋula. ");
INSERT INTO wro_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Agulaia i:dja ba kariŋgunaldąga, pig ŋuru dąra kariŋaŋuru, wiri-ŋąri tjḁri kubądburąŋ wo:naŋgąli-i-dągu wo:ndu' ŋuru, jauarḁra kubądjuŋ. ");
INSERT INTO wro_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Arka barui ąŋganbądo:neri wuno:murum mąra ąŋgo:na ge tjumąn kąmiena, pąlja kubądjuŋiri, kubąlula malaiindem maninj a, wauim maninja. ");
INSERT INTO wro_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Arge kariŋaŋuru mara wunja ge tjumąn kąmiena, Jesu kauerąmurkalal, mąra kauero:na i:dja aua agulaia iŋgadjąndiwela atją iŋgąnineri, tai iŋgąni:na, ini:um kudai, Jesu ierdu nąnja; karkulguneneri. ");
INSERT INTO wro_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Arka kuda: mąra ąŋgo:na kubądjuŋąnąŋgori ŋḁrunąŋgowu iŋgąmundulbaiena aua agulaia kudai. ");
INSERT INTO wro_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Peleŋgąraia ardarawaia tḁmbium Gerasenia wo:ri mąŋgarwuneri burkai kaueriąbuna ąŋgaiąndiwe wunja, gewunja djenbeŋuru karkulguneneri; aua namąndi nąnja dąra keŋaŋuru, djo:li kąninaŋuru. ");
INSERT INTO wro_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Mia i:dja aia agulaia iŋgadjąndiwela burkai kaiąbuna aua nąnja iŋgąnuŋ wunja; O! kaŋaŋawuna, kundjuŋiri, ");
INSERT INTO wro_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","Djo:li bąnuŋuru tḁmbium ŋundjanąŋga' ŋuru, minje wunaiuru God geŋąnu. Aua keŋaŋuru, malaiindem mararawum maninja djo:jąn kumąŋeri wunaiuru Jesu geŋanąŋga. ");
INSERT INTO wro_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Wuno:murum Jesu djo:li iŋgąninal peleŋgąraia kauerąmąŋ; gewunja ardarawaia kauerananąla. ");
INSERT INTO wro_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Gejau wai! keŋgunal i:dja iŋumba Jairus, aua inaiuri dadjurdŋąrim maninj a iŋgąnina, kauwona Jesu ierdu nąnja, burkai kaiąbuna iŋgeŋgal kunja maiarum anąŋgam, ");
INSERT INTO wro_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Gewunja pąmaranja ndjḁruŋamanj a aua kudai, njąŋga woralinja, kuŋgądjuneri. Wąli iŋgeŋaŋuriri peleŋgąraia aua nąnja naia kadbiena. ");
INSERT INTO wro_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Woŋaiinja ndjḁruŋ, njąŋga golema gulu wo: kumbąnanąngeri, njąŋga kądjinba pinjimurduienja i:dja kari nąnja. ");
INSERT INTO wro_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Iwelbam njeŋgunal kąmąndanąla iamiŋgum wobi anąŋga, maiirgi:rkum dumbulu gulu njąŋganąŋga tjimi kunjąŋa. ");
INSERT INTO wro_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Jesu kundjuŋu, Ąŋguja ŋąnmąndanąla? Ardarawaia kari kubądjuŋ. Peter kundjuŋu, Inaiuri, peleŋgąre ŋundju nąnja djḁruk kadbieŋiri, ŋąndọa karkaŋurieŋiri. ");
INSERT INTO wro_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Jesu kundjuŋu, Ąŋguja ŋąna ŋḁnmąndanala; gewunja laiburu ŋḁnina wundjurulu ŋḁndjąndiwela. ");
INSERT INTO wro_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Gejau woŋaiinja, wuno:murum mąra ko:na wa pinjindjąlgaienja, djedjeriwa njeŋgunal, njimbąna imąnŋąle ŋuru, ąŋudjakunja iŋgąmąndanąla njąŋga kundjuŋu peleŋgḁre adbąnŋąle ŋuru, ŋḁrunąŋgọwu maiirgi:rkum njąŋgąmurduiena. ");
INSERT INTO wro_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Aua kundjuŋanąŋga, Pąmaranja, wa panjąnŋudjarenja, ŋunmundulbaieŋu; abi:la baiu. ");
INSERT INTO wro_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Ge-i-di-dągu aua kaluleri, kengal iḁruŋ dadjurdŋąrim inaiuri-i-dągu, kundjuŋiri, Pąmaranja ŋundjanąŋga gole njimąnja, inaiuri djądjeri pindjiinąŋgeri. ");
INSERT INTO wro_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Jesu ŋuru iŋgąnina kaio:lbąla, Puŋungulgunejiri; dja pąnjąŋudjareri, pitja njemundulbaie. ");
INSERT INTO wro_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Maiarum mąŋgamurkalal, wa panąŋunjai:dja kari dąra ąŋgeŋgal kunja, argekama Peter a James a John, woralinja iranąŋga a karanąŋgąnja. ");
INSERT INTO wro_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Ardarawaia wola kubądjuŋiri, njimbądema-leri. O! aua kundjuŋu, Wola piriiri; wa debąra pinjeŋąn dąga, kulunu njinuŋiri. ");
INSERT INTO wro_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Arka kauerii:la, laiburu ąŋganina njąnga debąra njiŋgeŋa. ");
INSERT INTO wro_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Aua njino:ri kumąŋ, ai kundjuŋu, kundjuŋiri, Woŋaląŋunja, bḁri bąnu. ");
INSERT INTO wro_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Njiŋandj djo:li njimurkaiena, maiirgi:rkum bḁri njinina, gejau aua kundjuŋu, Njino: mindjḁl kunja. ");
INSERT INTO wro_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Gejau inenaiurgandu rḁngḁri keŋandu; O! aua kundjuŋąnąŋgandu i:dja kari piriinąŋgoriri ge tjumąn kąniŋaiena. ");
INSERT INTO wro_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Twelve ai kanbuna, kano:na wundjurulu, iaŋąri, agulaia ardarawaia nąnja, mareja nąnja, ąŋgąmurdu wunja. ");
INSERT INTO wro_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Kanŋaŋawuna ardi:um kalu wunja bąndaia God anąŋga, adbąramareja adbulugu ąŋgandju wunja. ");
INSERT INTO wro_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Kundjuŋąnąŋgori, Kari parąmeri li:wu njirkanąŋga wunja, kari tjḁndura, kari bururu, kari maia, kari kaiug; kari wobi iąruŋandu parąmeri. ");
INSERT INTO wro_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Maiarum maua dąra njirkunjąŋaŋuru, ma atja njidu, ma-i-dągąm maraiąndiwe. ");
INSERT INTO wro_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Arka njiri wa pinjidbądbąn, wuno:murum malaiindem maue marąŋundjąndiwe, tjurnim njidjerdu nąnja jaląla wuri:nąŋga umiimbaie wunja arka nąnja. ");
INSERT INTO wro_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Arka kariŋaŋuru, maiarundjeruŋuma buluman kariŋa wąląnu-wunia ardi:um kubąluleri, kanbądburduneri kądjinma. ");
INSERT INTO wro_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Gejau Herod inaiuri ŋuru kąnina darawa tjumąn kąmiena, lara kundjuŋu, gewunja kaluiena atjąkekąria nąnja John bḁri iŋgaiąndiena imąndj-i-dągu; ");
INSERT INTO wro_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Atjąkekąria nąnja Elijah mara iŋgauwi:na; atjąkekąria nąnja tjo:lbąda iḁruŋ ardindi' dąnja bḁri iŋgaiąndiena njele. ");
INSERT INTO wro_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Herod kundjuŋu, John imri: ŋaiu dur kuŋo:na; O! indj' ąŋguja aua wunja wuna ŋuru ŋąnŋunuŋ? Mąra iŋo:, kundjuŋu. ");
INSERT INTO wro_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Arkaŋawieja djo:li ąŋgąninal, kubądjuŋąnąŋga ge kadjuŋu. Aua kanmurąŋ, kariŋaŋuru argekama malaiinde' ŋuru maŋumba Bethsaida. ");
INSERT INTO wro_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","O! Peleŋgąraia laiburu ąŋgąnina, kauerąmalando:na; aua kanmurąn, kululanąŋgori bandaia God anąŋga wunja, arka lai kauwonanąŋgori adbulugu wunja aua kanmurduna. ");
INSERT INTO wro_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Mąrąŋunja gole njimbąnaŋuriri, arge twelve kariŋgunal, kubądjuŋąnąŋga, Peleŋgąre ąnŋaŋawu, kariŋenjaŋuru maiarundjeruŋuma, tḁmbium ma-i-dąba, ma atją kadinja, mąŋari mąra kauero:nja, gewunja nąri ŋuruma bundul' danja ŋḁduŋ. ");
INSERT INTO wro_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Aua kundjuŋąnąŋgori, Njiri arano: mindjąl kunja. Arka kubądjun, Ḁri nąnja kari, argekamandj wuro:dbori iḁruŋuri, djaia iḁruŋandu, ąnjerkuma mḁŋḁri peleŋgare ąndja wunja. ");
INSERT INTO wro_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Gewunja arka peleŋgąre djenbeŋuru, five thousand. Aua inalalaia kundjuŋąnąŋgori, atja ari: ardarawaia fifty nąnja. ");
INSERT INTO wro_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Ge kubądjuŋ, ardarawaia atją kanbąri:la. ");
INSERT INTO wro_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Gejau aua kanmąŋ wuro:dbori iḁruŋuri, djaia iḁruŋandu, ąndjo:lu kąle kąmurkąla, wunia kululanąŋgori, kalemala, inalalaia kano:na peleŋgąre adbanŋale ŋuru aŋganbąrkande wunja. ");
INSERT INTO wro_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Mindjḁl kubądjuŋ, ardarawaia barui kubądjuŋ, gejau kadburiena ilelemia arli:wa ąŋgeŋa ąŋgąm manŋennąlb, twelve. ");
INSERT INTO wro_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Ge kunina, aua iḁruŋamandj iŋgąnina, dadjurd generi, inalalaia aua nąnja kadina, burkai kandjąbuna kundjuŋiri, Peleŋgąraia ŋai' ąŋguja kubḁdjareri? ");
INSERT INTO wro_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Kauerio:lbąla, kubądjuŋ, John Baptist, atjąkekąria Elijah, atjąkekąria iḁruŋ tjo:lbąda ardindi' dąnja bḁri iŋgḁnina njele. ");
INSERT INTO wro_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Aua kundjuŋąnąŋgori, O! njiri ŋai' ąŋguja kuriara? Peter kaio:lbąla, kundjuŋu, Christ God anąŋga. ");
INSERT INTO wro_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Aua njḁdbama kundjuŋąnąŋgori i:dja kari wuna piriinąŋgoriri; ");
INSERT INTO wro_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Kundjuŋiri, I:dj' iŋko:lu darawa kundji:nja, pitja wai kaiąbienja, mababaia nąnja, dadjurdŋąria ardenaiud' dąnja, wiri-wiri ŋąria nḁnja, pitja bada kauwi:nja, gejau pąle kulunu tjḁruŋandu pitja bḁri kaiąndienja. ");
INSERT INTO wro_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Ardarawaia kundjuŋąnąŋgori, Aua nąmba lai kauwonanąŋga ŋḁnŋunmalando: wunja, aua ŋundju-ŋundju kari kąni:nja, wongaia anąŋga tjile-jile kumenja, ŋḁnmalando:nja. ");
INSERT INTO wro_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Gewunja aua lai kauwonanąŋga iŋaui kąmundulba wunja, pitja njọakaliba; aua inaui kọakaliba ŋaiu wunja, aia pitja njḁmundulba. ");
INSERT INTO wro_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Gewunja bąndaia daraiu ąŋudjakunja i:dja kuma, aua ŋundju-ŋundju iŋgọakalibieŋu, iŋgawelbuneŋu? ");
INSERT INTO wro_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Gewunja aua djiḁn kąrnara, ŋąla-ŋąla ŋaianąŋga kuda:, aia pitja I:dj'iŋko:lu djiḁn njąmanąŋga, wuno:murum iŋgeŋgal pąlemba nąnja anąŋgąm, Iranąŋga, wąląnŋąria mamaia arkanḁŋga kuda:. ");
INSERT INTO wro_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Nidji kuŋenuriri, atjąkekąria kaduŋ ŋuru ąŋgawelgeŋiri, arka wa pitja debąra pareŋąn mąra njini kadjo: bąndaia God anąŋga. ");
INSERT INTO wro_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Ge kunina ŋąla-ŋąla wuna pąlejau, lewąra wunŋąlu, kąmurąŋori Peter a John a James, pai kąninaŋuru tḁląmbąn ŋuru dadjurd kunja. ");
INSERT INTO wro_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Wąli aua dadjurd geŋeri imiŋum dji: manina, wobi anąŋga iroroi pąlemba kąnina. ");
INSERT INTO wro_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Gejau wai, i:gąndu kululandiri aua nąnja, iŋgąninandu Moses a Elijah. ");
INSERT INTO wro_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Auandu mąra kauwi:nandu pąlemba nanja, kundjuŋandu debąra anąŋga wunja, ge pitja ko:rug kąma Jerusalem maninja. ");
INSERT INTO wro_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Peter, auandu kuda: aua nąnja kulunu ko:nori; wuno:murum barele iŋgąninuri, kanindjąŋori pąlemba anąŋga, i:gąndu kuda: iŋgawelgenjandiri aua nąnja. ");
INSERT INTO wro_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Ge kunina, wąli iŋgaiąndiwejandiri, Peter kundjuŋąnąŋga Jesu, Inaiuri, wunia kunuŋ ḁriŋguri ŋuru wunja, jḁndąlpa maiaruŋurim wondi mewi:njuri, maiaruŋum ŋundju wunja, maiaruŋum Moses wunja, maiaruŋum Elijah wunja; wa laiburu pąŋgąninja ge geŋu. ");
INSERT INTO wro_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Wąli wuna geŋeri, ąŋgubąn kunjąŋgunal, djer njindjąbuna arka nąnja; arka karkulguneneri wąli ąŋgubąn dḁra ḁŋgeŋaŋuriri. ");
INSERT INTO wro_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Gejau ŋąla-ŋąla kunjąŋgunal ąŋgubąndj-i-dągu, kundjuŋiri, Indja ŋḁmąnda iŋąnŋumąŋ, ŋuru iraŋuru. ");
INSERT INTO wro_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Wuno:murum ŋąla-ŋąla wudun geŋu, mąra kauwi:na Jesu auekamandj. Kumuk kumbunori, gejau i:dja kari wa puŋgadji:njanąŋgori ge mąra ko:no:ri. ");
INSERT INTO wro_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Ge kunina, mąŋgundjiau wuno:murum tḁląmbąndj-i-dḁgu jeri ąŋgauwonal, peleŋgąraia ardarawaia kauerąmąndjerala. ");
INSERT INTO wro_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Gejau wai, i:dja peleŋgąraia nąnja jero:l kundjuŋu, kundjuŋiri, Iniiŋgundeja, burkai ŋunjiąb, imnjanindj ŋḁmąnda, ge wunja iąruŋara. ");
INSERT INTO wro_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Wai, agula kąma, maiirgi:rkum jero:l kundjiri, tjąŋalar kąri kandjuiri, njini pąŋgaiąndi-wen, kumąg pitja kundjunąŋgeri. ");
INSERT INTO wro_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Burkai kaŋaiąbuna ŋunalalaia aua wai kunja, arka kądjinba puŋgadji:nja. ");
INSERT INTO wro_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Jesu kaio:lbąla, kundjuŋu, O worumba njirkudjarie, njirkolikoli, ŋḁnąŋgiau njiri nąnja ŋḁnuŋ, njinma; indjąŋungula imal. ");
INSERT INTO wro_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Wąli iŋgeŋgaliri agula kaiąbuna, djenbeŋuru dalar kąmąŋ; Jesu kąmaiḁmbuna agula inuru, worala kąmurduna, kąnino:la iranąŋga. ");
INSERT INTO wro_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Ardarawaia wundjurulu God anąŋga rąngąri kubądburauwuna. Wąli rąngąri kadburauwuneri darawa aua geŋiri, kundjuŋąnąŋgori inalalaia. ");
INSERT INTO wro_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","Ŋąla-ŋąla wuna kuŋgandienja njidi:um maninja: gewunja I:dj' iŋko:lu pitja eno:wi:i:dja ardo:ri nąnja. ");
INSERT INTO wro_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Ŋąla-ŋąla wuna wa puŋgadenenja, kundjąlgaienanąŋgori, wa laiburu padin kunja, karkulguneneri ŋąla-ŋąla wuna burkai iŋgadjąb wunja. ");
INSERT INTO wro_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Kadąŋąnaŋądjaieneri arge wurura, ąŋguja arka nąnja inaiuri pitja enu. ");
INSERT INTO wro_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","O! Jesu mąra ko:na ḁŋgąnąŋąnaŋądjaieneri ardi:um maninja, worala kąmąŋ, kauelgendjuna iwondąra nąnja, ");
INSERT INTO wro_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Kundjuŋąnąŋgori, Aua iŋgam indja worala ŋḁnŋumba wunja, ŋaiu ŋḁnma; aua ŋḁnŋuma, kąma aua ŋḁnŋaŋawuna; gewunja aua pidi:ndja njidarawa nąnja, aia inaiuri kąnuŋ. ");
INSERT INTO wro_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","John kaio:lbąla kundjuŋu, Inaiuri, iḁruŋ mąra kerwuna ŋunŋumba nąnja agulaia wai ąŋgaiąbuneri, kedbaiḁmbuna gewunja wa pąlimba pinjedjinguri. ");
INSERT INTO wro_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Jesu kundjuŋąnąŋga, Pąndjąmaiḁmbiri: gewunja aua wa ŋąnde pąnmḁn ŋąri, ŋąri nąnja kąnuŋ. ");
INSERT INTO wro_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Ge kunina wuno:murum gejau ko:rug kąmaieneri aua pai iŋgaŋurieŋu wunja, imiŋum njḁdbama mandenu iŋgenŋuru wunja Jerusale' ŋuru. ");
INSERT INTO wro_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Wąląnŋąria imiŋum mąnŋąle kanŋaŋawuna. Arka kariŋaŋuru, dąra kariŋaŋuru maiarundjeruŋma Samaritan ŋąrim, mḁnamanja wunja aua wunja. ");
INSERT INTO wro_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Arka wa pauerąmenja, gewunja imiŋum iŋgeŋaŋuriri Jerusale' ŋuru. ");
INSERT INTO wro_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Inalalandu, James a John, wuna mḁra ko:nandu kundjuŋandu, Inaiuri, lai kumbąnąnu kunjedjandu wiḁnu kunjąŋgunjal ąndjo:l' di dągu arka wori wunja? ");
INSERT INTO wro_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Wąlŋąrai kauwona, kąmaiḁmbunandu. ");
INSERT INTO wro_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Kariŋaŋuru maiarundjeruŋuma maiakąrim. ");
INSERT INTO wro_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Wuno:murum ąŋgeŋaŋuriri kalumba nąnja iḁruŋ kundjuŋąnąŋga, Ŋaiu ŋunjąmalando: ŋḁnąm ŋunŋunjąŋaŋuru. ");
INSERT INTO wro_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Jesu kundjuŋąnąŋga, Kąnąnguria do:lo:dba kudai, punaria wuŋo:ru ŋąria waiaru, O! I:dj'iŋko:lu ino:ra ŋḁnąm imri: we ki:. ");
INSERT INTO wro_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Aua kundjuŋanąŋga iąkąra, Tjḁnmalando:. O! aua kundjuŋu, Tjḁndjabawurle ro:k iŋi: iraia ŋaianąŋga. ");
INSERT INTO wro_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Kundjuŋąnąŋga, Ądbąn ro:k kadi:nja ḁdban arkanąŋgaia; ŋundju baiuŋuru ardi:um minjalu bąndaia God anąŋga. ");
INSERT INTO wro_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Iąkąra kuda: kundjuŋu, Ŋaiu ŋunjąmalando: Inaiuri; O! tjḁndjąbawurle ąŋąnawendja wunja arka maiarum ŋaianąngam maninja. ");
INSERT INTO wro_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Jesu kundjuŋąnąŋga, I:dja kari ino:ri la mąŋgam plough nąnja, wararkar iŋgąnuŋ, iniọwu kąnuŋamiri bąndaia God anąŋga. ");
INSERT INTO wro_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Wuna pąlejau Inaiuri kangąndjuna atjąkekąria seventy, arka kanŋaŋawuna iḁriḁruŋandu imiŋum mąnŋąle manaiudba mararawa' ŋuru, tḁmbium mararawa' ŋuru, ma aua ŋundju-ŋundju pitja ejeŋgal. ");
INSERT INTO wro_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Kundjuŋąnąŋgori, Wulgundjiri ko:ru wunaiuru, O! i:dja kadąguja; gewunja burkai iriąb Inaiuri wulgundjiri ŋąra ąnjaŋaŋawu wunja i:dja wulgundjiri ŋuru. ");
INSERT INTO wro_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Njidjurli; wai, njinŋaŋawu kukundjeria kądjindjia kąnąŋguria nąnja. ");
INSERT INTO wro_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Puraŋuriri kaiug kari, bururu kari, njidjerduŋąri kari; i:dja kari wulmai piriinąŋgoriri kalumba nąnja. ");
INSERT INTO wro_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Maiarum maua njirkunjąŋaŋuru, wuri:wurle, Jḁmulili maiarum mḁna nąnja. ");
INSERT INTO wro_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Jḁmulili iŋko:lu ma ŋąmba iŋgąnuŋ, jḁmulili njirkanąŋga ma nanja pitja atją njąnu; ŋḁmba kari, njiri nąnja pitja djo:li njḁnu. ");
INSERT INTO wro_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Maiarum maua nąnja atja njidu, mindjḁl wurąŋundjiri, djo: njirkunjąŋeri arge njinŋumbądo:; gewunja inawodjieja ląŋugu anąŋga inia kąnuŋanąŋga. Pinjiriiri maiarum maiaru' ŋuru. ");
INSERT INTO wro_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Manaiudba maua njirkunjąŋaŋuru njinŋumbądba, mindjḁl wuri: arge njidbąnŋąle nąnja ąŋgandieŋu, ");
INSERT INTO wro_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Adbąramareja ma nąnja arąmurdu, wurinąŋgori, Bąndaia God aŋaŋga gole wodjulu kunjąŋgunalduri. ");
INSERT INTO wro_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Manaiudba maua njirkunjąŋaŋuru njiri wa pinjinbadban ŋari, njiriŋuru kalumba ma ŋuru, wuri:, ");
INSERT INTO wro_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","Tjurnim manaiudba njiri ŋąrim ḁri ardjerdu nąnja mąŋgąnuŋ, wuliŋgąra kunjedju njiri nąnja; mia laiburu njidu bąndaia God anąŋga wodjulu kunjąŋgunal. ");
INSERT INTO wro_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Kuŋenuri gejau Sodom maniam man dągąm pitja menu manaiudba maua nąnja. ");
INSERT INTO wro_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Wurgunu ŋundju nąnja, Chorazin, wurgunu ŋundju nąnja, Bethsaida; gewunja ŋąmba Tyre nąnja, Sidon nąnja, kandjui:na rąngąri kąninanurendu, golema kuluŋąn mąŋgawenjandu atją mąŋgawonandu sackcloth nąnja, pimbinąl' dąnja. ");
INSERT INTO wro_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","O! Tyre nąnja, Sidon nąnja, wunia man dągu pitja njḁnu wurejau njirendu nąnja. ");
INSERT INTO wro_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Ŋundju, Capernaum, ąndjo:l' kuru brai ŋundjandieŋu? Mamąra' ŋuru pitja wai ŋunjejabie. ");
INSERT INTO wro_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Aua ŋuru njinŋungaŋuru ŋuru ŋḁngaŋuru; aua njinŋunŋąndjuŋandjo: ŋanŋąndjuŋąndjo:; aua ŋḁnŋunŋąndjuŋąndjo: kąŋąndjuŋąndjo: aua ŋḁnŋunŋaŋawuna. ");
INSERT INTO wro_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Arge seventy djo:li kadinal tjukul ŋąri kubadjuŋ, Inaiuri, agulaia kuda: waiuru kanbąrkandeŋunjḁri ŋunŋumba nąnja. ");
INSERT INTO wro_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Aua kundjuŋąnąŋgori, Mąra kąŋo:na Satan, mąlŋirinja kądjindja, iŋgauwona ąndjo:l' di dągu. ");
INSERT INTO wro_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Wai, ŋaiu njino:na wundjurulu djąmbąba wunja pąmalinja nąnja, bandjia nąnja, wundjurulu darawa inauurgundj anąŋga, kari kądjinba pḁmbąla pinjinbąrkandjun. ");
INSERT INTO wro_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Mia, tjukul pinjidi:ri wuna nąnja, agulaia waiuru ąŋganbąrkandeŋunuri, tjukul njidu gewunja njirkumba wiri-wiri kauwi:na ąndjo:l' dąnja. ");
INSERT INTO wro_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Ge-i-di-dągu tjukul kąnina Iŋandj Mąmaia nąnja, kundjuŋu, Ŋungulbo:, Iraia, Ŋunaiuru ąndjo:l' kąra, kabḁlba ŋąra, gewunja wuna kundjaielgeŋu ardi:u' ŋąria ŋuru, ardi:um dąrąnguja ŋuru, kandjąmiimbuna woŋąlaląŋuja; jau, Iraia, gewunja wurunąŋgọwu wunia kuniŋaiena ŋungubul' dąnja. ");
INSERT INTO wro_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Darawa kunauwi:nara Iraia ŋaianąŋga nąnja, i:dja kari wa laiburu pąŋgąnin ąŋguja Iŋko:lu Iraia ekamandj, ąŋguja Iraia Iŋko:lu ekamandj, aua kuda: Iŋko:lu ko:rega iŋgąnuŋ iŋgąmiimbu wunja. ");
INSERT INTO wro_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Wąlŋąrai kauwonąnąŋgori inalalaia, argekama kundjuŋu, Tjukul ŋąri arkumbula mąŋgadidjeri njiri marąŋunindj; ");
INSERT INTO wro_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Gewunja kuŋenuri, tjo:lbądaia ardarawaia ardenaiuri kuda: lai kumbąnanąŋgori mąŋgadidja wunja ge njiri marąŋunindj, wa pąmadidjenja; ŋuru wunja njiri ŋuru wurąŋungąŋurula, wa ŋuru puŋgarkaŋurinja. ");
INSERT INTO wro_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Wai, iḁruŋ ŋąla-ŋąla ŋąra kauwelgenja ko:ndjuna kundjuŋiri, Iniiŋgundeja, ŋḁni kuŋe ŋaiedjer kądjinma ŋḁnŋunuŋ wunja? ");
INSERT INTO wro_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Aua kundjuŋanąŋga, Ŋḁnąŋga wiri-wiri kauwi:na ŋąla-ŋąla nąnja? Ŋarunąŋgọwu mili-mili mąra kąnd jo:? ");
INSERT INTO wro_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Aua kaio:lbąla kundjuŋu, Pąnarienąŋga Inaiuri God ŋundjanąŋga ŋunŋulum mararawam, ŋunŋaui dara, ŋundjurulba mararawam, ŋuni:um mararawam; mąmuŋgąlja ŋundjanąŋga kuda: ŋundju kądjindja. ");
INSERT INTO wro_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Aua kundjuŋanąŋga, Tjḁdąm tjḁndjo:lbala; ge dju ŋundjedjer ŋunjanu. ");
INSERT INTO wro_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Aua Ŋaiḁdąŋuru ŋandjuie kundjuŋu, kundjuŋąnąŋga Jesu, Ąŋguja mąmuŋgąlja ŋaianąŋga? ");
INSERT INTO wro_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Jesu kaio:lbąla kundjuŋu, I:dja iḁrun jeri kauwonaŋuriri Jerusalem i-dągąm Jericho ŋuru; kauwona lulun ŋąria nąnja, wobi bura kauerąmąŋanąŋga, ŋoiil kubądjuŋąnąŋga, kariŋaŋuru kauerąmąŋgi:la wodjulu kuŋgądjuneri. ");
INSERT INTO wro_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Wąli iḁruŋ dadjurdŋąra kalumba tjaue keŋgunal, mąra iŋgo:na, kanalu keŋa. ");
INSERT INTO wro_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Ge kądjinu iḁruŋ Levite, tḁmbium ma iŋgeŋgunal, mąra ko:na, kanalu keŋa. ");
INSERT INTO wro_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Mia, Samaria ŋąra iḁruŋ iŋgeŋaŋuriri keŋgunal ma iŋgąnina, mąra iŋgo:na, kaieriwuna. ");
INSERT INTO wro_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Kąmurkąlaŋuru, malum anąŋgąm murd kundjuŋu, pḁlulu kundjuŋąnąŋga oil, wine, kandeŋu punąra nąnja anąŋgamandj, kaŋurula maiaru' ŋuru, kanaleri. ");
INSERT INTO wro_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Mąŋgundjiau kumąŋ kaiug tjḁruŋandu, maiaruŋąra kąno:na kundjuŋu, Aneri, kaiug tjąkąri ŋundju ŋąmba kąndjano:, ŋaiu wuno:murum djo:li ŋḁnŋunuŋal pitja ŋunjano:. ");
INSERT INTO wro_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Ŋania arge iḁruŋuri ni: ŋunuŋ mąmuŋgąlja iŋgąnina aua iŋgauwona lulunŋaria nąnja? ");
INSERT INTO wro_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Aua kundjuŋu, Aua iŋgaieriwuna. Jesu kundjuŋąnąŋga, Baiuŋuru, ge-i-di-dągu dju. ");
INSERT INTO wro_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Wąli ąŋgeŋaŋuriri, maiarundjeruŋuma mamurkalal; woŋaiinja ndjḁruŋunja, njąŋumba Martha, kąmąŋ maiarum njąŋganąŋgąm maninja. ");
INSERT INTO wro_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Njąŋga ŋawanja kudai, njąŋgąrimiena Mary, njąnga kuda: atją njimbąna Inaiuri ierdu nąnja, ŋąla-ŋąla anąŋga ŋuru kuŋgaŋurula. ");
INSERT INTO wro_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","O! Martha lara kundjuŋiri darawa maiarum maŋinja; kąmurkalal kundjuŋu, Inaiuri, kari ŋundju nąnja ŋawanja ŋḁndjąndiwela ŋaiḁruŋ maiaru' wunja? Gewunja minjenąŋga njiŋgeŋgal ŋḁnŋunawodju wunja. ");
INSERT INTO wro_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Inaiuri njąŋgaio:lbąla kundjuŋąnąnga, Martha, Martha, ni: ŋunuŋ, lara kundji, darawa wunja, ");
INSERT INTO wro_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Tjḁruŋuma kuninja; Mary ge wunia kumąŋ, wa puŋgano: ŋgienąŋga. ");
INSERT INTO wro_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Ge kunina, wąli aua tḁmbium maninja iŋgąnina dadjurd geŋeri, wuno:murum wudun geŋu, iḁruŋ inalala kundjuŋąnąŋga, Inaiuri, ąnmiimbu dadjurd njerkundju wunja, kądjinu ge John kuda: ąŋgąmiimbuna inalalaia. ");
INSERT INTO wro_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Aua kundjuŋąnąŋgori, Wuno:murum dadjurd wurąŋundju, wuri:, Iraia ar-arkanąŋga ąndjo:!' dąnja, Ŋunŋumba mąma: kuninja, Bąndaia ŋundjanąŋga kunjąŋgunjal. Lai kauwonąnu kuninja, kabąlba nąnja kądjinu ąndjo:l' dąnja. ");
INSERT INTO wro_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Maia ar-arkanąŋgaia lewąra wunja kądjinma ąnjano:. ");
INSERT INTO wro_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Umąra ar-arkanąŋga wai minjo:njḁri; gewunja ḁri kuda: wai njerkumbunąŋgori ardarawaia tjaue ąŋganbąrwunjḁri. Ąri kaielwa pandjaŋuriri wuŋgundjuie nąnja, O! ri: ąnmḁl woru nąnja. ");
INSERT INTO wro_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Gejau kundjuŋąnąŋgori, Ąŋguja njiri nąnja jḁlai kudai, indjąŋunmurkaŋuru wulo:lum, tjuŋundjąnąŋga, Jalai, maia iaruŋuri nunjanawodju; ");
INSERT INTO wro_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","Gewunja jḁlai ŋaianąŋga kandjalu iŋgeŋgal ŋḁnmurkalal, ŋḁno:ra ąŋąngandenja imąnŋąle ŋuru. ");
INSERT INTO wro_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Aua mamulba pitja ejo:lbo: nje, Pąnjąnŋąliŋgeri; maiamundu gole bur kunina, woŋąlaląŋuja ŋaianąŋgaia ŋaiu nąnja ardaragu nąnja kaduŋ; kądjinba bḁri pąŋąnin, puŋano:n. ");
INSERT INTO wro_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Kuŋenuri, ŋąmba wa bḁri pąŋgąnin, wa pąŋgąno:n, jḁlai anąŋga iŋgąnuŋ, tjile-jile iŋgḁniau pitja bḁri enu, eno: irarawaia lai iŋgauwonanąŋgori. ");
INSERT INTO wro_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Ŋaiu kuŋenuri, Iraniau, pitja njḁno:wi:nuri; arąŋąnjiro:, pitja mąra arewu; denden maro:, pąlkąr njḁmienuri. ");
INSERT INTO wro_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Gewunja ardarawaia iŋgadiau kubądba; aua kąŋąnjiro: mąra kumbu; aua denden maŋgo: pitja pąlkąr njḁmienąŋga. ");
INSERT INTO wro_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Ŋḁnia njiri nąnja iraia iŋgąnuŋ iŋko:lu ŋąmba iŋgąniau wuro:dbo:ri, pitjowu eno: kaiug? Djaia iŋgąniau, aua djaia wunja pitjọwu eno: kauanja? ");
INSERT INTO wro_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Wonaui ŋąmba iŋgąniau, pitjọwu eno: bandja? ");
INSERT INTO wro_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Gewunja njiri, njirworu njirkunuŋ, ŋąmba laiburu njirkunuŋ wunia arąŋuno: woŋąlaląŋuja njirkanąŋgaia, djenbeŋuru man dągu Iraia ąndjo:l' kąra pitja anjano: Iŋandj Mamaia arka iŋgadiau? ");
INSERT INTO wro_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Agula wai ko:neri iamidja kulula; peleŋgąraia rąngąri kariŋa. ");
INSERT INTO wro_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","O! Atjąkekąria arka nąnja kubądjuŋ, Beelzebub nąnja, agula inaiuri, wai kanbiri agulaia. ");
INSERT INTO wro_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Atjąkekąria, kauero ndjuneri, burkai kaueriąbuna umiimbaie ąndjo:l' kąri. ");
INSERT INTO wro_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Aua laiburu kąnina ardi:um maninja, kundjuŋąnąŋgori, Bąndaia daraiu dalar kąmiena ŋąnde kaua ŋundju-ŋundju wuliŋgąra kumbi:ŋu; maiarum kuda: ŋąnda maiarum, mauwona. ");
INSERT INTO wro_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Satan ŋąmba ŋąnda aua ŋundju-ŋundju dalar iŋgąmieŋu, ŋḁrunąŋgọwu bąndaia anąŋga pitja njḁwelge? njiri wurąŋundjiri Beelzebub nąnja ŋaiu agulaia wai ąŋąnŋumbiri. ");
INSERT INTO wro_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Ŋaiu ŋąmba Beelzebub nąnja agulaia wai ąŋąnŋumbu, ąŋguja nąnja njidbąndia wai ąŋganbąrwu? Gewunja arka wureŋąria pitja arąnunuri. ");
INSERT INTO wro_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","O! ŋaiu ŋąmba God ino:ri nąnja agulaia wai ąŋąnŋumbu, gejau kunjąŋgunalduri bąndaia God anąŋga. ");
INSERT INTO wro_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Wuno:murum i:dja iurulwora tjinḁlja kudai maiarum anąŋgam mąŋganeri, wuląnbiri anąŋgaia jḁmulili kaduŋ. ");
INSERT INTO wro_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Mia, ŋąmba iurulwora man dąga aua nąnja iŋgeŋgal, puluru iŋgi:, eno:ŋgu tjinalja irarawaia pąrąd iŋgąmurauwuna, wuląnbiri anąŋgaia kąla ąnjo. ");
INSERT INTO wro_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Aua ŋaiu nąnja ŋąmba wa pąŋgąnin, ŋąnda ŋḁnmeri; aua ŋaiu nąnja ŋąmba wa djḁruk panmąn, tjauwąre kanbiri. ");
INSERT INTO wro_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Agula inuru, i:dja iŋgaiąndiwela, keŋuriri maro:do:d kuru, Ŋoiba kąŋąnjiro:jiri, wa mąra puŋgo:n, gejau kundjiri, Djo:li ŋenu maiarum ŋaianąŋgam ma-i-dągam ŋḁnŋunjąŋgunal. ");
INSERT INTO wro_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Gejau keŋgal, mąra mo: brar mąŋgąniŋaieŋu, mḁnamanjam. ");
INSERT INTO wro_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Gejau keŋuriri kanmąŋ agulaia atjąkekąria ąnŋenŋąlja arwod' ban dągaia aua nąnja, arka karingal, ma atją kaduŋ, pąlejau i:dja aia iwod' ban dągaia auurle nąnja. ");
INSERT INTO wro_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Ge kunina, wuna geŋeri, woŋaiinja ndjḁruŋ peleŋgąre nąnja ŋąla-ŋąla njąŋganąŋga brai kundjąndąla, kundjuŋąnąŋga, Tjukul ŋąrim njąŋulum kuli:n ŋunŋumbuna, tjukul ŋąri ŋamugu muka tjuŋunbuna. ");
INSERT INTO wro_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Aua kundjuŋąnąŋga, Jau, tjukul ŋąria man dągaia arka ŋąla-ŋąla God anąŋga nuru ąŋgąnuŋ, ge karkaŋuru. ");
INSERT INTO wro_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Wuno:murum peleŋgąraia djḁruk ąŋgąmienanąŋga wunmanbąli kundjuŋu, Woi marąŋunmąndjiri ąndja arworia kaduŋ; umiimbaie kubąrkąnjiro:; umiimbaie wa puŋgano:wi mąŋgori umiimbaie Jonah anąŋga wundąkama. ");
INSERT INTO wro_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Kądjinu Jonah imiimbaie Nineveh ŋąria nąnja iŋgąniŋaiena, wunmąŋgọwu pitja enu I:dj' iŋko:lu woi marąŋunmąndjiri ąndja nąnja. ");
INSERT INTO wro_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Njinaiudj araworinja pitja bḁri njenu wure nąnja i:dja woi marąŋunmąndjiri ąndja nąnja, njąŋga pitja wure njo:nąŋgori; gewunja njeŋgunal bąndaia umindjuŋuru-i-dągu ŋuru kaŋuru wunja wuni:ndjaru Solomon anąŋga, wrai, inaiud' ban dąga Solomon nąnja ŋuruma kąnuŋ. ");
INSERT INTO wro_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","I:dja Nineveh ŋąria pitja bḁri arąnu wure nąnja woi marąŋunmąndjiri ąndja nąnja, pitje wure paro:nąŋgori; gewunja arka kuluŋąn karwona ŋąla-ŋala Jonah anąŋga nąnja; wai, inaiud' ban dąga Jonah nąnja ŋuruma kąnuŋ. ");
INSERT INTO wro_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","I:dja kari tjanaim duru mąŋgi:la, wa pąmanden tḁmbium maielgaiem maninja, kari kuni:n waiuru, O! tjanai' ŋąri nąnja, gewunja arka dąra ąŋgeŋgaliri tjanaim mąŋgadidjaliri. ");
INSERT INTO wro_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Tjanaim ŋunnunąba nąnja ambula kunuŋ: ŋungubulu tjḁdąŋuru kąnun, ŋunŋunąba mararam maro: manuŋ; woru kąnuŋ, ŋunŋunąba mararam duiba ŋąrim mḁnuŋ. ");
INSERT INTO wro_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Gewunja manindj madji maro: ŋundju nąnja duiba ŋąrim pąmąnu. ");
INSERT INTO wro_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Gewunja ŋunŋunąba mararam ŋąmba maro: ŋąrim mąŋgąnuŋ, duiba ŋąrim mano:ram, maro: ŋąrim pitja mararam menu, kądjinu tjanaim pąlemba ŋąrim marąm ŋunŋunjano:. ");
INSERT INTO wro_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Wąli kaluleri, iḁruŋ Pharisee burkai kaiąb mindjḁl kunja aua nąnja; dąra keŋaŋuru, atja kauwona rnindjḁl kunja. ");
INSERT INTO wro_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Pharisee mąra ko:na rąngąri keŋa auurle wa kulai puŋgo:nja wąli wa mindjḁl puŋgenja. ");
INSERT INTO wro_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Inaiuri kundjuŋąnąŋga, Weni njiri Pharisia rar gąri karandju ilerduŋuru cup, ilerduŋuru plate, O! njirkuluŋuru kąlabu njirkuniŋaieŋu lulun, umąra. ");
INSERT INTO wro_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Njiri woŋąla, wawu aua ilerduŋuru iŋgandeŋu, iŋuluŋuru kuda: kandeŋu? ");
INSERT INTO wro_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Mia lulwa arano: wuląnbiri gole parano:, gejau wai, darawa rar gąri kunuŋanuri. ");
INSERT INTO wro_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","Wurgunu njiri nąnja, Pharisia, gewunja jedmąŋgąnu birwidiŋąri kurano:, wuk kuro: wure, ŋedura God anąŋga; ge piriin, tjąkąri wuk puro:jiri. ");
INSERT INTO wro_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","Wurgunu njiri nąnja, Pharisia, lai mąŋgauwonanuri adbąlakąrim mąnŋąleŋąrim dadjurdŋąrim maninja, lai kauwonanuri wulmai tjauŋąrim maninja. ");
INSERT INTO wro_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Wurgunu njiri nąnja, gewunja njiri kądjindjia ro:kŋąrim wa mąra pąmarwi:nja, i:dja wudawa ąŋgeŋeri wa laiburu padin. ");
INSERT INTO wro_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","I:dja ŋąla-ŋąla ŋąra kaio:lba kundjunąŋga, Iniiŋgundeja, ge tjuŋundjiri kandjąmaiąmbu ḁri kuda:. ");
INSERT INTO wro_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Aua kundjuŋu, Wurgunu njiri nąnja nąla-ŋąla ŋąria kuda:, gewunja njiri nimaia i:dja nąnja karande, njiri parąmąndaneri nimaia njido:ri tjḁruŋ njiniŋge. ");
INSERT INTO wro_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Wurgunu njiri nąnja, gewunja do:lo: wondi wuro: tjo:lbądaia arkanąŋga, iraraia njirkanąŋgaia bada ąŋganbąrwuna. ");
INSERT INTO wro_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Gewunja njidąŋądjaieŋu, arąŋąnu: ge iraraia njirkanąŋgaia kadjuŋu, arka bąda ąŋganbąrwuna, njiri do:lo: wondi wuro:. ");
INSERT INTO wro_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Gewunja kuda: God wuni:ndjaru kundjuŋu, Ąŋaŋaŋawunąŋgori tjo:lbądaia, arkaŋawieja kuda:, atjąkekąria pitja bąda ąnbąro:, pitja ąnbḁro:ndju; ");
INSERT INTO wro_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Gewunja gulu: tjo:lbądaia ardarawaia arkanąŋga pḁlulu kąniŋaiena bąndaia wunuŋgule wundjaŋuru-i-dągu burkai njejąbie woi marąŋunmąndjiri ąndja nąnja. ");
INSERT INTO wro_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Gulu: Abel anąŋga ge-i-dągu gulu: njini Zachariah anąŋga, aua debąra iŋgeŋa wia' ŋąrim dadjurdŋąrim puląga nąnja; Jau, kuŋenuri, burkai njejabie woi marąŋunmąndjiri ąndja nąnja. ");
INSERT INTO wro_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","Wurgunu njiri nąnja ŋąla-ŋąla ŋąria, gewunja kurąmąląŋąla lągąd ŋąri; njiri wa dąra pinjiriŋenjaŋuru, arąmaiḁmbuna arka dąra ąŋgeŋaŋuriri. ");
INSERT INTO wro_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Wuno:murum ma-i-dągam iŋgeŋgunal, wiri-wiri ŋąria a Pharisia njḁdbama ŋąnda kubądbąŋanąŋga, burkai kaueriąbuna kalu darawa wunja. ");
INSERT INTO wro_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Kauerananaleri, kadba wunja iamundu nąnja. ");
INSERT INTO wro_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Pulągajau, wuno:murum peleŋgąraia djenbeŋuru djḁruk ąŋgąmiena, gewunja arge wurura djąmbąba kanbądjo:rąla, wunmanbąli kundjuŋąnąŋgori inalaia arkurle, Maranindj leaven Pharisia arkanąŋga, gejąkawḁli tjibḁre. ");
INSERT INTO wro_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Kari kuni:n kąni:ŋu, ŋąmba wa pitja mąra puŋgauwi:n; kari kaielgaieŋu, ŋąmba wa pitja laiburu puŋgąniŋaien. ");
INSERT INTO wro_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Gewunja ge wundugum wurąŋulula, lewąra pitja ŋuru njąniŋaie; ge ardi:um maninja kujoia wurąŋundjuŋu balaium maninja, pitja jero:l njḁniŋaie karąŋ maiarum maninja. ");
INSERT INTO wro_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","Kuŋenuri, jḁlalaia ŋaianąŋgaia, paro:lguneri arka njirkanąba mąŋgarwuja, pąlejau kari kądjinba puŋgadjin. ");
INSERT INTO wro_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","O! Njinjąniiŋgunda ąŋguja irąŋungulguna: Iro:lguna aua gole bąda iŋgo:na wundjurulu kudai wai kunja mamąru' ŋuru; jau, kuŋenuri, iro:lguna. ");
INSERT INTO wro_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Wawu wurira iḁruŋuri kado:wi:ŋu kaiug tjąruŋandu pidi:n kunja? Kari iḁrun woŋąla wa pąŋgąniŋaien God ambula nąnja. ");
INSERT INTO wro_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Tjąkąra kuda: njidbri: ŋąri darawa laiburu kuniŋaieŋu. Pinjirgulgunejiri, wurira ardarawaia nąnja njidia ma njiduŋ. ");
INSERT INTO wro_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","Kuŋenuri, I:dja ŋąmba ŋaiu wunja gejiri i:dja adbąnŋąle ŋuru, aua kuda: wunja I:dj' iŋko:lu pitja nje adbąnŋąle ŋuru wąląnŋąria God anąŋgaia; ");
INSERT INTO wro_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Aua ŋaiu wunja ŋḁmidja gejiri i:dja adbąnŋąle ŋuru, pitja ŋḁmidja eniŋaie wąląnŋąria God anąŋgaia adbąnŋąle ŋuru. ");
INSERT INTO wro_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Aua I:dj' iŋko nąnja ŋąla-ŋąla ŋąnda kąma, pitja wai njejąbienąŋga; O! aua Iŋandj Mamaia iŋgąŋujo:, wa pitja wai puŋgaiąbiennąŋga. ");
INSERT INTO wro_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","Wuno:murum njinŋumbąrkaŋural dadjurdŋąrim maninja, ardenaiud' dąnja, wundjurul' dąn-ja, lara piriiri ŋḁrunąŋgọwu, ŋḁnąŋga arąŋundjo: Iba, wuraŋulu; ");
INSERT INTO wro_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Gewunja Iŋandj Mamaia pitja njinjaniiŋgunda ge-i-di-dągu ŋḁnąŋga wurąŋundju. ");
INSERT INTO wro_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Iḁruŋ peleŋgąre nąnja kundjuŋąnąŋga, Iniiŋgundeja, minjenąŋga ŋawaia ŋaianaŋga wuląnbiri karŋąl kanbi:njara. ");
INSERT INTO wro_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Aua kundjuŋąnąŋga, I:dja, ąŋguja ŋḁngandeŋu wure ŋąra, karŋąl ŋąra, njiri nąnja? ");
INSERT INTO wro_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Gejau kundjuŋąnąŋgori, Maranindj, njiri ŋundju-ŋiundju njirkaŋurie wuŋgąlbąnda dara nąnja, gewunja i:dja iŋaui kui wuląnbiri ardarawaia kudai. ");
INSERT INTO wro_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Bḁre-bḁre kundjuŋąnąŋgori, kundjuŋiri, Kabąlba i:dja tjiŋi:ra anąŋgam wunia bḁri kandjąndąla. ");
INSERT INTO wro_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Iniąkamanma kundjuŋu, kundjuŋiri, Ŋḁni ŋe, gewunja ŋḁno:ra ma kurab ŋaianąŋga ąŋąngande? ");
INSERT INTO wro_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Kundjuŋu, Wuna ŋe; jarąŋga mąŋo: maiarum ŋaianąŋgam, pitja wondi mąŋana manaiud' ban dągąm, ma pitja djḁruk ąŋąm corn ardarawaia ŋaianąŋgaia, wuląnbiri ŋaianąŋgaia. ");
INSERT INTO wro_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Pitje ŋenąŋga ŋḁŋaui, Ŋḁŋaui, ŋundju kudai wuląnbiri ardarawaia golema ąŋgandiena; ŋoiba bąnu, mindjḁl dju, djo: baiu, tjukul bąnu. ");
INSERT INTO wro_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","O! God kundjuŋąnąŋga, Woŋąla, weni wundugum ŋunŋaui pitja burkai njejąbie ŋundju nąnja: ąŋguja anąŋgaia pitja arąnu arka ardamanja ąndjąŋungandjuna? ");
INSERT INTO wro_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Wuna kądjinu aua wuląnbiri ąŋgarąŋum aua ŋundju-ŋundju wunja, tjiŋi:ra kauiąk God nanja. ");
INSERT INTO wro_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Kundjuŋąnąŋgori inalalaia, Gewunja kuŋenuri, Lara piriiri njirkaui wunja, nḁnąŋga mindjal wurąŋundju, kari njirkanąba wunja, ŋḁnąŋga tai njirkunuŋ. ");
INSERT INTO wro_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Gewunja njirkaui wunaiud' ban dągu mąŋąri nąnja, njirkanąba wobi nąnja. ");
INSERT INTO wro_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Ni: araŋuriri woŋguraia, arka wa panbąrkanden, wa djḁruk panbądbąn, ardo:ra maiarum, ardo:ra maiaŋąrim, God barui kano:; njidia man dągaia djenbeŋuru punaria nąnja. ");
INSERT INTO wro_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Anguja njiri nąnja, lara gejiri, iwąndu gole pąŋgande irindja nąnja? ");
INSERT INTO wro_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Gewunja njiri ŋąmba pidi:nma kądjinba piriin, ąŋudja kunja lara kuriiri tjąkḁri wunja? ");
INSERT INTO wro_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Ni: wuraŋuriri maruku, ŋḁrunąŋgowu bḁri kąnuŋ, paii wa puŋgadjiŋ jarkai wa puŋgadjin; O! kuŋenuri Solomon pąlemba mararam anąŋgam maninja wa tai pąŋgąninja tjḁruŋ wuna kądjinu. ");
INSERT INTO wro_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Wurkąlam ŋąmba God ge kądjinu tai mąŋgi:, maue weni kabąlba nąnja mąŋgąnuŋ, mḁŋgunu mąŋgaiąbieŋu wia' nąnja, djenbeŋuru ma njiri, njirkudjarie. ");
INSERT INTO wro_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Parąŋąnjiro:jiri nąnąŋga mindjal wurḁŋundju, ŋḁnḁnga djo: njirkunjąŋa, lara piriiri. ");
INSERT INTO wro_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Wuna darawa kubąrkąnjiro:jiri worumbaia bąndaia nąnja; Iraia njirkanąŋga laiburu kąnuŋ njiri wuna ŋąma wurąŋundjiri. ");
INSERT INTO wro_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Mia wurąŋąnjiro: bąndaia God anąŋga, gejau wuna darawa pitja njḁnunuri. ");
INSERT INTO wro_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Pinjirgulgunejiri, wiri:m pidi:ndja; gewunja lai kumbąnanąŋga Iro:lidj bąndaia njinŋuno: wunja. ");
INSERT INTO wro_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Aro:gule wuląnbiri njirkąnąŋgaia, ardjeja arano:; wurąndju njiri ŋundju-ŋundju wunja bururu kądjinba wunuŋgule puŋgąnin ŋąri, wuląnbiri ąndjo:l' dąnja kądjinma ŋąri, ma lulun ŋąra kari wa wodjulu pareŋąn, wuno:lu wa panmąndjun. ");
INSERT INTO wro_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Gewunja ma wuląnbiri njirkąnąŋga ąŋgąnuŋ, ma kuda: njidi:um pitja menu. ");
INSERT INTO wro_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","Njirkwierlumba murd kąninja, tjanaim njirkananąŋgam duru mani:nja; ");
INSERT INTO wro_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Njiri kuda: i:dja kądjindjia njidu inaiuri arkanąŋga iŋgadaneri, wuno:murum djo:li iŋgąnuŋal mąŋąria pąnąn ŋąria dągu; wuno:murum iŋgeŋgal, denden mąngo:, maiirgi:rkum pąlkąr pąrąmanąŋga. ");
INSERT INTO wro_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Tjukul ŋąria ardawodjieja arge, wuno:murum inaiuri iŋgeŋgal, mąra ąnjo: mu:n mąŋgarwiri; nidji kuŋenuri, murd enie, arge atją ąnji:, pitja ejeŋgal, ąnjanowodju. ");
INSERT INTO wro_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Ŋąmba kąngulnąm, ŋąmba maiaium, iŋgeŋgal, wurunąŋgowu mąra ąŋgo:, arge tjukul ŋąria kaduŋ. ");
INSERT INTO wro_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Wuna laiburu njidu, inaiuri maiaru' ŋąra ŋąmba laiburu iŋgąnina ąŋudjau lulunŋąra iŋgeŋgunal, mun mąŋgo:na, wa pąŋgąnąŋunja maiarum anąŋgam kurug mąŋgauwi:ŋu. ");
INSERT INTO wro_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Njiri kuda: njidamanja njidu, gewunja gejau wa ni: pinjidin ŋąri ejeŋgal I:dj' iŋko:lu. ");
INSERT INTO wro_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Peter kundjuŋu, Inaiuri, ḁri kundjinjḁriri bḁre-bḁre wuna, ardarawaia? ");
INSERT INTO wro_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Inaiuri kundjuŋu, Ąŋguja aua nidji, ini:u' ŋąra maiaru' ŋąra, aue inaiuri karąŋ ewąndenąŋgori i:dja anąŋgaia, mąŋąria ąnjano: wunja tjḁdąmiau? ");
INSERT INTO wro_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Tjukul ŋąra inawodjieja aue, wuno:murum inaiuri iŋgeŋgal, mąra iŋgo: ge kądjinu gejiri. ");
INSERT INTO wro_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Nidji kuŋenuri, karąŋ ewąndenąŋgori ardarawaia anąŋgaia. ");
INSERT INTO wro_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","O! inawodjieja aue ŋąmba ini:um maninja gejiri, Inaiuri ŋaianąŋga wi: kundjal, wunmanbąli ąŋgąmandjuiri algalgunjia, arwąriwąridjia, mindjḁl gejiri, djo: iŋgeŋiri, pulwul iŋgeŋiri. ");
INSERT INTO wro_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Inawodjieja aue inaiuri anąŋga pitje ejeŋgal gejau wa ni: pąŋgąnin ŋąri, gejau wra laiburu pąŋgąnin ŋąri, pitja dur ewu, anąŋga ŋąri pitje eno: arkudjarieja nąnja. ");
INSERT INTO wro_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","Inawodjieja laiburu iŋgąnina Inaiuri anąŋga ŋąma geŋeri, inamanja wa pąŋganinja, wa puŋgenja inaiuri ŋąma geŋeri, wodpiliba ejo:rie djenbeŋuru; ");
INSERT INTO wro_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Aua wa laiburu pąŋgąninja, geŋu wodpili kąri, aua wodpiliba ejo:rie pidi:nu. Aua dara kąno:wi: ŋunąŋga aua nąnja dara pitja burkai njejąbienąŋga; aua dara ąŋgąnino:, aua nąnja dara pitja ewąrąniau. ");
INSERT INTO wro_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Ŋeŋgunal wiḁnu ŋḁnŋungande wunja kabąlba nąnja, ŋḁnąŋga ŋąma nḁnŋundju ŋąmba gole duru kąniŋaiena? ");
INSERT INTO wro_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Baptism ŋaiu kudai wuna nąnja baptize ŋḁni:nja, ŋḁruąŋgọwu ŋąnda ŋḁmieŋu ko:rug kąmie njini. ");
INSERT INTO wro_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Ni: njiduŋ ŋḁnŋunjąŋgunal jḁmulili kabąlba nąnja ąŋąnŋuno: wunja? Kari, kuŋenuri, dalar kąri. ");
INSERT INTO wro_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Gewunja pitja arąnu wendj-i-dągu ąnŋąlja maiarum maiaruŋum maninja, dalar arąmie iḁrunuri ŋąnda iḁruŋandu, iḁruŋandu ŋąnda iḁruŋuri. ");
INSERT INTO wro_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Dalar arąmie iraia ŋąnda iŋko:lu, iŋko:lu ŋąnda iraia, karanja ŋąnda ibanja, ibanja ŋąnda karanja, ŋḁlindjanja ŋąnda ŋḁlindjanja. ");
INSERT INTO wro_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Kundjuŋąnąŋgori peleŋgąraia kuda:, Wuno:murum mąra wurąŋunbu ąŋgubąn bḁri kąnuŋiri Marąŋąm maninja, maiirgi:rkum kuri:, Adja keŋgaliri, ge kądjinu kunuŋ; ");
INSERT INTO wro_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Wuno:murum jḁląŋgąra wo: kauwonal, kuri:, Mąra-mąra pitja njḁnu, ge kunuŋ. ");
INSERT INTO wro_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Njidbiŋum njiljaljadbune, laiburu njiduŋ mąra wunja kabąlba mamiŋum, andjo:lu umiŋu, ąŋudja kunja wa laiburu pinjidin mąra wunja wendjiau? ");
INSERT INTO wro_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","Ąŋudja kunja njiri ŋundju-ŋundju nąnja wunia wa wure puro:n? ");
INSERT INTO wro_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Wąli ŋunŋunjąŋaŋuru inauurgundj nąnja inaiur' kuru, kalumba nąnja lia mąma ŋḁrunąŋgọwu bura ŋunŋumieŋunąŋga, madji lalewa ŋunŋunjaŋuriri wure ŋąra ŋuru, wure ŋąra ŋunŋuno: bur ŋąranąŋga, bur ŋąra puŋungąnde bur ŋąrim man-inja. ");
INSERT INTO wro_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Kuŋenu, ma-i-dągąm wa pitja ba puŋunjąŋąn tjuŋuno:na njini darawa. ");
INSERT INTO wro_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Atjąkekąria ma kadina ge-i-di-dągu kadjuŋanąŋga Galilee ŋąria wunja, gulu arkanąŋga Pilate nąmbąr ko:na mąma:ŋąri arkanąŋga nąnja. ");
INSERT INTO wro_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Aua kandjo:lbąla, kundjuŋąnąŋgori, Ni: njiduŋ arge Galilee ŋąria arwod' ban dągaia Galilee ŋąria ardarawaia nąnja, gewunja wuna kąniŋaienanąŋgori? ");
INSERT INTO wro_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Kari, kuŋenuri, O! njiri ŋąmba wa kuluŋąn pinjirwąn, ge kądjinu njidarawaia pitja debąd njireju. ");
INSERT INTO wro_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Arka ąnŋenŋąlja arge mąŋgauwonanąŋgori maiarum kąrąngenma Siloam ŋḁrim, ąŋgąmąndjo:na, ni: njiduŋ arka arwod' ban dągaia i:dja ardarawaia nąnja Jerusalem maninja atją ąŋgauwoneri? ");
INSERT INTO wro_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Kari, kuŋenuri, O! njiri ŋąmba wa kuluŋąn pinjirwąn, arge kḁdjindjia pitja debąd njireju. ");
INSERT INTO wro_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Bḁre-bḁre wuna kuda: kundjuŋu. I:dja iḁrun tjilium kudai mąŋgandiena kabąlba anąŋgam maninja; keŋgunal kurab kąŋąnjiro:na maua nąnja, wa mąra pąŋgo:nja. ");
INSERT INTO wro_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Kundjuŋąnąŋga kabąlba nąra, Wai, tjauądba maiaruŋurim ŋeŋgunal kurab kąŋąŋąnjiro:na tjilium mḁna nąnja, wa mąra pąŋo:nja; dur mo:; ąŋudjakunja kabąlba mąŋariŋgiri? ");
INSERT INTO wro_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Aua kaio:lbąla, kundjuŋąnąŋga, Inaiuri, maninja tjauadba mḁna kuda:, wo:ri mḁŋąminjo:jiri tjḁri mąŋo: njini, tjąŋunim mąŋande, ");
INSERT INTO wro_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Gejau ŋąmba kurab iŋgąm, wunia; ŋąmba kari, pitja dur mąndjo:. ");
INSERT INTO wro_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Kaniiŋgundaleri maiąruŋam dadjurdŋąrim maninja Wunaiurujau. ");
INSERT INTO wro_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Wai, woŋaiinja njąŋandj mareja kudai golema, tjiŋgur njinina, kądjinba tjḁdąŋuru pinjimbąlgenja. ");
INSERT INTO wro_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Jesu mąra njaŋgo:na, ai njimbuna, kundjuŋąnąŋga, Woŋai, bur a ŋunmieŋu mareja ŋundjanąŋga nąnja. ");
INSERT INTO wro_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Ino:ri njimąndanąla, maiirgi:rkum ndjḁdąŋuru njiŋgandjuiena, God ko:do:dala. ");
INSERT INTO wro_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Inaiuri dadjurdŋąra ii:la kąmaŋ Jesu Wunaiurujau njąŋgąmurduna, peleŋgąre kundjuŋąnąŋgori, Lewąra tjąkąri kunuŋ ŋuna wunja; gejau njireŋgal njirąmurdui: wunja, kari Wunaiurujau. ");
INSERT INTO wro_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","O! Inaiuri kaio:lbąla kundjuŋu, Njidbiŋum njiljaljadbune, wawu njidarawaia Wunaiurujau burąŋgai pinjirąmąn buluman, donkey njirkanąŋga jḁndąlpa nąnja, wawu pinjiraŋurun djo: wunja? ");
INSERT INTO wro_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Njąŋga, Abraham pąmaranja njiŋgąnuŋ, njąŋge Satan murd njąŋgaman wai, golema, wawu burąŋgai pinjąmaien wuna murd kunja Wunaiurujau? ");
INSERT INTO wro_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Wuna geŋu ardauurgundj' ardarawaia anąŋgaia djiḁn kubądbąŋ, peleŋgąre ardarawaia tjukul kadina darawa wundjurul' kąri aua nąnja kąniŋaiena. ");
INSERT INTO wro_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Gejau kundjuŋu, Ąŋudja kądjinu bḁndaia God anąŋga, ąŋudja kądjinu kuŋandju? ");
INSERT INTO wro_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Kądjinu tjḁląngąnja mustard, njiŋge i:dja njimaŋ, njąŋgandeŋu kabąlba anąŋgam maninja; njąŋgawelgenja ŋuwonu njini kuniŋaiena, punaria wuno:ru ŋąria wuŋgalalidjerugu nąnja atją kadina. ");
INSERT INTO wro_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Njele kundjuŋu, Ąŋudja kądjinu kuŋandju bąndaia God anąŋga? ");
INSERT INTO wro_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Leaven kądjinu, woŋaiinja iŋgąmąŋ, iŋgaielgeŋu iroroi iḁruŋuri nąnja, irarawaia leaven iŋgą niŋaiena njini. ");
INSERT INTO wro_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Bulumąn keŋaŋuru manaiudba, maiarundjeruŋama, kaniiŋgundaleri, keŋaŋuriri Jerusale' ŋuru. ");
INSERT INTO wro_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Iḁruŋ kundjuŋąnąŋga, Inaiuri, kadḁguja kaduŋ ąŋgąmundulbaieŋu? Aua kundjuŋąnąŋgori, ");
INSERT INTO wro_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","Jḁkunu wuri: njirkunjąŋa wunja maiamundu pidi:nma ŋuru, gewunja ardarawaia, kuŋenuri, jḁkunu bąre dąra ąŋgeŋa wunja, kadjinba pareŋąn. ");
INSERT INTO wro_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Wuno:murum inaiuri maiaru' ŋąra bḁri iŋgąnina, maiamundu bur ki:la, dąnde njirkumbąl-geŋuriri maiamundu nąnja denden marąŋunbiri, wurąŋundjiri, Inaiuri, pąlkar minjąmanjḁri; aua njinjo:lba, pitja njenuri, Wa laiburu pąŋąninuri, ŋḁru njirkunuŋ; ");
INSERT INTO wro_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Gejau pitja wureju, Mindjḁl kunjedjuŋ, djo:jo: kunjedjuŋ ŋunmąnŋąle ŋuru, kandjąniiŋgundaleri kalumba nąnja ar-arkanąŋgaia; ");
INSERT INTO wro_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Aua pitja nje, Kuŋenuri, wa laiburu pąŋąnin nḁru njirkunuŋ; njidjuliara, njidarawaia woru wurąŋundju. ");
INSERT INTO wro_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Pitja njąnu wola, kadur arwiąk, wuno:murum mąra arąŋunbu Abraham, Isaac, Jacob, tjo:lbądaia ardarawaia, bąndaia God anąŋga nąnja, njiri dąnde pitja wai njirkunjąbieŋu. ");
INSERT INTO wro_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Pitja areŋgal Woriŋąri ḁlp, Marąŋam ḁlp, Bembąram ḁlp, Arawori ḁlp, pitja atją arọwa bąndaia God anaŋga nąnja. ");
INSERT INTO wro_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Wai, kaduŋ pąleŋąria pitja arąnu mąnŋąleŋąria, kaduŋ mąnŋąleŋąria pitja arąnu pąleŋąria. ");
INSERT INTO wro_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Ge-i-di-dḁgu kariŋgunal atjąkekąria Pharisia kubądjuŋąnąŋgeri, Dąnde pąminjeju, baiuŋuru mḁndj'-i-dągu, gewunja Herod Bąda iŋo: kundjuŋiri. ");
INSERT INTO wro_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Aua kundjuŋḁnąŋgori, Njidjuliŋuru, wurinanga aue fox, Wai, agulaia wai kaŋo:, dudbąl kaŋandju, weni, mąŋgunu; mąŋgundjiau pitja ko:rug ŋḁmie. ");
INSERT INTO wro_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Mia madj ŋeŋenja weni, mąŋgunu, mąngundjiau, gewunja tjo:lbąda kądjinba debąra pąŋgeŋąn dąnde Jerusalem. ");
INSERT INTO wro_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","O Jerusalem, Jerusalem, tjo:lbądaia ąndjąŋunbiri, kaiug do: tjuŋundjunąŋgori arkaŋawieja ŋundju nąnja, wodi darawajau ŋąma kuŋeŋu djḁruk ąŋąnŋuma ŋundju woŋąlaląŋuja punara kądjinu djḁruk ąŋgąm bi:rwidori njąŋganąŋgaia njąŋgalum maninja, ŋundju wa ŋąma pindjiinja. ");
INSERT INTO wro_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Wai, maiarum ŋundjanąŋgam mamaŋgienąnu wuliŋgąra kąrim; kuŋenuri, Ŋaiu wa pitja mąra pąnjaro:n wuna njejeŋgal djini gejau wurąŋundju, Tjukul ŋąra aua iŋgeŋgal Inaiuri iŋumba nąnja. ");
INSERT INTO wro_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Ge kunina wuno:murum iŋgeŋaŋuru maiaru' ŋuru iḁruŋ Pharisee inaiuri anąŋgąm Wunaiurujau maia mindjḁl kunja, kaueranindjąŋeri. ");
INSERT INTO wro_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Wai, i:dja iḁruŋ imąnŋąle ŋuru kąn kundjuŋu. ");
INSERT INTO wro_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Jesu kandjo:lbąla, kundjuŋąnąŋgori ŋąla-ŋḁla ŋąria, Pharisia kuda: kundjuŋiri, Wuniọwu Wunaiurujau karąmurdu wunja, wuniọwu ŋuru-ŋuru? ");
INSERT INTO wro_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Arka kumuk kubąrwuna. Aua kąmąŋ, kąmurduna, burąŋgai kąmąŋ. ");
INSERT INTO wro_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Kundjuŋąnąŋgori, Ąnguja njiri nąnja, woŋąląŋ, buluman kudąi, windjeri nąnja iŋgauwona, wawu maiirgi:rkum ri: pąndjąmąn Wunaiurujau? ");
INSERT INTO wro_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Arka wuna nąnja kądjinba njele pauerio: Ibenja. ");
INSERT INTO wro_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Bḁre-bḁre kundjuŋąnąŋgori arka ai ąŋgauwi:na, mąra ąŋgo:na ŋḁrunąŋgọwu mąŋgadbąŋąm adbalikąrim mąnŋḁle ŋąrim, kundjuŋąnąngori, ");
INSERT INTO wro_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","Wuno:murum ai ŋunŋumbi:ŋu iḁruŋ nąnja mąŋąri pąnan ŋąria nąnja, atją puŋuniri adbḁlikąrim mąnŋąle ŋąrim maninja, madji ai iŋgauwi:ŋu aua nąnja inaiud' ban dągaia ŋundju nąnja, ");
INSERT INTO wro_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Gejau iŋgeŋgal aua ai ŋunŋumbuna, genu, Adbąlikarim indja ino:, gejau djiḁn pindjąm, adbąlikąiam waiuru mąndjąŋunma. ");
INSERT INTO wro_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","O! Wuno:murum ai ŋunŋumbi:ŋu, baiu, atją bąnu adbąlikąrim waiur' kąrim maninja, gewunja wuno:murum iŋgeŋgal aua ai ŋunŋumbi:na, pitja njenu, Jḁlai, karąŋ ŋuru baiuŋuru; gejau pitja iŋo:lja indjąm adbąnŋale ŋuru ardarawaia atją ąŋgąnuŋ ŋundju nąnja. ");
INSERT INTO wro_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Gewunj a aua ŋundju-ŋundju karąŋ iŋgandjuienu pitja waiuru ejąbie, aua ŋundju-ŋundju waiuru iŋgandjuieŋu pitja karąŋ ejąbie. ");
INSERT INTO wro_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Aua kuda: kundjuŋąnąŋga aua ai iŋgo:na, Wuno:murum ąndjąŋungandju mąŋąria, lewąra, wunduga' jau, ai pandjo:jiri jḁlalaia, ŋawawaia ŋundjanąŋgaia, njiri madeja, mąmuŋgąlia tjini:ria, ŋąmba wa arka kuda: njele ai ŋunŋumbarwu, pitja pąle ŋuru ŋunbąrano: njele. ");
INSERT INTO wro_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","O! Wuno:murum mąŋąria ąndjąŋungandju, ai ąnjo: ardjeja, aralidjia, arwondawondadjia, arkumbambulidjia; ");
INSERT INTO wro_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Gejau tjukul pitja ŋunjąnu, arka ardoreja ŋunŋumbądo: pąle ŋuru; pitja njḁno:wi:nu pḁle ŋuru bḁri ąŋgaiabieŋu atjḁdąŋuria. ");
INSERT INTO wro_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Wuna ŋuru kąnina iḁruŋ atją iŋgąnina aua nąnja kundjuŋąnąŋga, Tjukul ŋąra aua mąŋąri mindjḁl ge bąndaia God anąŋga nąnja. ");
INSERT INTO wro_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Aua kundjuŋąnąŋga, I:dja iḁruŋ mąŋąria ardaraia kangąndjuna, ardarawaia ai kanbuna; ");
INSERT INTO wro_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Kaŋaŋawuna inawodjieja anąŋga mąŋąrijau ge wunja arka ai ąŋgauwi:na, Njireŋgal, gewunja ardamanja kaduŋ. ");
INSERT INTO wro_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Arka ardarawaia tjḁruŋama karkąriina. Auurle kundjuŋąnąŋga, Kabąlba mąŋąmurąŋ, madj ŋejuŋuru mąŋanindj wunja; burkai ŋundjąb, ŋḁninja. ");
INSERT INTO wro_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Iąkąra kuda: kundjuŋu, Buluman ąnŋąlja iḁruŋandu ŋąri kaŋąmurąŋ, ŋejuŋuru jḁkunu ąŋo:ndju; burkai ŋundjąb, ŋḁninja. ");
INSERT INTO wro_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Iąkąra kuda: kundjuŋu, Mąŋganja pąnąn ŋḁwona, ge wunja kadjinba pąŋeŋąn. ");
INSERT INTO wro_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Inawodjieja keŋgunal, wuna wąląnu kuŋgaŋurulaldąga inaiuri anąŋga. Gejau inaiuri maiaru' ŋąra ii:la kąmąŋ, inawodjieja anąŋga kundjuŋąnąŋga, Baiuŋuru maiirgi:rkum kalumba ŋuru, tjuwąlja ŋuru malaiindem maninja, ąnmural ardjeja, aralidjia, arkumbambulidjia, arwondawondadjia. ");
INSERT INTO wro_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Inawodjieja kundjuŋu, Inaiuri, kuniŋaiena ge tjuŋundjuŋu, wali balaium manuŋiri. ");
INSERT INTO wro_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Inaiuri inawodjieja kundjuŋąnąŋga, Baiuŋuru kalumba ŋuru, bundul' kuru, ąngandju ąŋgeŋgal kunja, maiarum ŋaianąŋgam kąlabu mąngąniniŋaieŋu wunja. ");
INSERT INTO wro_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Gewunja kuŋenuri, i:dja kari ai ąŋgauwi:na mąŋąria ŋainąŋga pitja wa panbąrkargunąn. ");
INSERT INTO wro_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Peleŋgąraia ardarawaia kariŋa aua nąnja, wararkar kḁnina, kundjuŋąnąŋgori, ");
INSERT INTO wro_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","I:dja iḁruŋ ŋąmba ŋḁnŋunmurka, ŋąmba wa paŋgundjurun iranąŋga, karanąŋgąnja, mąŋgąnąŋgąnja, woŋąlaląŋuja anąŋgaia, ŋawawaia, ŋawawanja, jau, iŋaui anąŋga ma kuda:, kądjinba pąŋgąnin ŋḁnalala. ");
INSERT INTO wro_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Aua wongaia anąŋga wa mano: puŋgaŋurun, ŋąmba wa ŋḁwelbam pąŋąnmalando:n ŋąri, kądjinba pąŋgąnin ŋḁnalala. ");
INSERT INTO wro_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Gewunja ąŋguja njiri nąnja ŋąma gejiri maiarum wondi mąŋgo: ŋąra, wawu auurle atją pąŋgąnin, wawu pąmąnindjąŋ wodi mararawąm kudai, ŋąmba gole ko:rug mąngąm. ");
INSERT INTO wro_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Madji waiuru ŋąna pąmande, ko:rug kądjinba pąmemąn, ardarawaia mąŋgadidjeja wunmanbąli umbili paueram, ");
INSERT INTO wro_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","Puŋgadju, I:dja indja wondi mąŋgo:neri, kądjinba ko:rug pąmąmenja. ");
INSERT INTO wro_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Ąŋguja inaiuri iŋgeŋaŋuriri mąląnim mąŋgo: wunja inaiuri iąkąra nąnja, wawu auurle atją pąŋgąnin, puŋgawaden aua kudai mąląniŋaria peleŋgąre, ŋąmba iŋgąmurka aua iŋgąmąndjera mḁląniŋaria peleŋgąraia tjilenda kudai? ");
INSERT INTO wro_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Ŋąmba wa puŋgen, iąkąra wąli bọwora iŋgąnuŋ, wąląnŋąra kaŋaŋawu, jḁmbula ŋąri kąniau. ");
INSERT INTO wro_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Ge kądjinu njidarawaia, aua ŋąmba wa panmąŋgi:n ardarawaia anąŋgaia, aua kądjinba pąŋgąnin ŋḁnalala. ");
INSERT INTO wro_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","Kąrąmbąlja inia kąnun; O! kąrąmbąlja ŋąmba gula-gula iŋgąniŋaiena, ŋḁrunaŋgọwu wuląpaŋąra eniŋaie? ");
INSERT INTO wro_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Inia ŋuru-ŋuru kabąlba wunja, tjąŋunim wunja, dḁnde kaueriąb. Aua ini:um kudai ŋuru wunja, ŋuru kąninja. ");
INSERT INTO wro_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Gejau kauerąmurkalaliri ardarawaia publicandia arworia kuda: ŋuru iŋgarkaŋuru wunja. ");
INSERT INTO wro_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Pharisia, wiri-wiri ŋąria kuda: jau karkaŋuriena kubądjuŋiri, Indja arworia kanma, arka nąnja mindjḁl kundju. ");
INSERT INTO wro_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Aua kundjuŋąnąŋgori bḁre-bḁre wuna, kundjuŋiri, ");
INSERT INTO wro_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","I:dja aŋguja njiri nąnja, kukundjeria one hundred, (ardarawaia), kudai iŋgąnuŋ, iḁruŋ arka nąnja ŋąmba iŋgoiimąla, atjąkekąria bundul' dąnja wawu panmąŋgi:n, pąŋgąŋąnjiro:n aue iŋgoiimiena, mąra iŋgo: njini? ");
INSERT INTO wro_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Wuno:murum mąra iŋgo:na, da kundjunąŋga, tjukul kąnuŋ. ");
INSERT INTO wro_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Maiarum mḁŋgąmurkal, ai kanbu jḁlalaia, mąmuŋgąlia anąŋgaia, kundjuŋiri, Tjukul njidu ŋaiu nąnja, mąra iŋąnŋumbuna kukundjera ŋaianąŋga iŋgoiimiena. ");
INSERT INTO wro_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Kuŋenuriri, ge kądjinu tjukul kunuŋ andjo:l' dąnja iwori iḁruŋ kuluŋąn iŋgauwona, ardarawaia atjḁdąŋuria man dągaia arka wa lai kuluŋąn puŋgauwonanąŋgori. ");
INSERT INTO wro_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Woŋaiinja ąŋgunja kaiug wunŋenŋąlu kudai njiŋgąnuŋ, tjḁruŋ ŋąmba koiim, tjanaim wawu duru puŋgi:n, maiarum brar puŋgen, njḁdbama pąmąnindjąn mąra njo: njini? ");
INSERT INTO wro_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Wuno:murum mąra ko:na, ai kanbu jḁlalaia, mąmuŋgąlia njąŋganąŋgaia, kundjiri, Tjukul njidu naiu nąnja, mąra ŋḁnŋumbuna kaiug ge ŋḁnŋunjoiimala. ");
INSERT INTO wro_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Ge kądjinu, kuŋenuriri, tjukul kunuŋ adbąnŋąle ŋuru wąląnŋaria God anąŋgaia iwori iḁruŋ wunja kuląŋąn iŋgauwona. ");
INSERT INTO wro_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Kundjuŋu, I:dja iḁruŋ ko:landu iḁruŋandu kudai. ");
INSERT INTO wro_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Pidi:ndja auandu nąnja kundjuŋąnąŋga iranąŋga, Iraia, tjḁnjano: wuląnbiri arge ŋaianąŋgaia pitja arąnu. Aua karŋąl kundjuŋąnąŋgandu iedjer ŋąria anąŋgaia. ");
INSERT INTO wro_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Pąlejau maranu puŋgąnin dągu pidi:ndja iŋko:lu djḁruk kanmąŋ ardarawaia, keŋaŋuru tḁmbium bọwora ŋuru, ma tjaueri kundjuŋąnąŋgori wuląnbiri ardarawaia imąra njini kąnineri. ");
INSERT INTO wro_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Wuno:murum ardarawaia wolumbąra genu, baia djenbeŋuru tambium ma kanbuneri, aua wunmanbąli ino:ra kąnineri. ");
INSERT INTO wro_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Gejau keŋaŋuru pidjin kąninaŋurandu i:dja nąnja tḁmbium ma ŋąra, aua kaŋaŋawuna yardba nuru pig barui ąŋgano: wunja. ");
INSERT INTO wro_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Ŋḁŋulum barui mąŋano: kundjuŋu, waiąm maninja pig mindjḁl kadjuŋu, i:dja kari wa pąŋgano:njanąŋga. ");
INSERT INTO wro_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Wąli aua ini:um kudai, kundjuŋu, Wodi ardarawaia ardawodjieja iraia ŋaianąŋga mąŋąri ko:ru ardara man dągaia kaduŋ, ŋaiu ŋuruma baia ŋḁnbiri, kuŋadjuiri. ");
INSERT INTO wro_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Bḁri ŋenu, iraia ŋaianąŋga iŋąmurka, pitja ŋenąŋga, Iraia, umąra kuŋeŋu ŋąnda ąndjo:lu, ŋungubul' kuru. ");
INSERT INTO wro_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Weni ŋḁniọwu ŋḁnuŋamiri tjḁnŋungula ŋḁnŋundimieŋu wunja, ŋaiu tjḁngąndju inawodjieja iḁruŋ ŋundjanąŋga kądjindja. ");
INSERT INTO wro_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Bḁri kąnina, iranąŋga kąmurkąla. Wąli bọwora iŋgąnina, iranąŋga mąra ko:na, kaieriwuna, wąri-wąri kąmurkąla, kauwona ileŋga nąnja, ko:lbo:na. ");
INSERT INTO wro_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Iŋko:lu kundjuŋanąŋga, Iraia, umąra kuŋeŋu ŋąnda ąndjo:lu, ŋungubul' kuru, weni ŋḁniowu ŋḁnuŋamiri tjḁnŋungula ŋḁnŋundimieŋu wunja. ");
INSERT INTO wro_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","O! Iraia kundjuŋąnąŋgori ardawodjieja anąŋgaia, Maiirgi:rkum irąmal wobi inia ŋąra-ŋąra, tai iri:, imąrulja ino:ri nąnja irande, ierduŋąri ierdu nąnja, ");
INSERT INTO wro_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Irąmal buluman kauila wurŋi:wu ŋąra iŋgandjui:na, iro:, mindjal wodju, tjukul ŋḁdu, ");
INSERT INTO wro_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Gewunja indja iŋąngula imąn kąnineri, iedjer kąnuŋiri, koiimiena, mąra kauwi:ŋu. ");
INSERT INTO wro_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","Gejau iŋko:lu iwongąra yardba nąnja kąnineri; wąli iŋgeŋgunaliri maiarum mąŋgamurkalaliri, kan ŋąri, djor ŋąri ŋuru kuŋgaŋurula. ");
INSERT INTO wro_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Inawodjieja ai ko:na, burkai kaiąbuna, Ąŋudja ge? ");
INSERT INTO wro_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Aua kundjuŋanąŋga, Ŋunbomale keŋgunal, iro:lidj ko:na bulumąn kauila wurŋi:wa ŋąra iŋgandjui:na, imulugu iŋgąmąŋ. ");
INSERT INTO wro_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Aua ii:la kąmąŋ, wa dąra pąŋeŋąn kundjuŋu; gewunja iranąŋga ba keŋgunal, burkai kaiąbuna. ");
INSERT INTO wro_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Aua kaio:lbąla, kundjuŋąnąŋga iranąŋga, Wai, golema ŋaiu ŋunŋunawodjąŋ, kądjinba ŋąla-ŋąla ŋundjanąŋga puŋalemi:nja, kądjinba pąnjano:nja nḁnigunja kauila, ŋaiu tjukul ŋąnŋunuŋ wunja jḁlalaia ŋaianąŋgaia nąnja; ");
INSERT INTO wro_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","O! wuno:murum indja indjąŋungula iŋgeŋgunal, aua mindjąl geŋu ŋundjedjer ŋąria arkurindjalja nąnja, kandjo:na aua wunja buluman kauila wurŋi:wa ŋąra iŋgandjuiena. ");
INSERT INTO wro_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Aua kundjuŋanąŋga, Iŋąngula, ŋundju kądjinma naiu nąnja ŋunuŋ, ardarawaia ŋaianḁŋgaia ŋundjanąŋgaia kaduŋ; ");
INSERT INTO wro_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Wunia kunina tjukul arkunuŋ, erkungo:do; da wunja, gewunja indja ŋunbomale imąn kąnineri, iedjer kąnuŋiri; koiimiena, mąra kauwi:ŋu. ");
INSERT INTO wro_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Ge kuda: kundjuŋąnąŋgori inalalaia, I:dja tjiŋi:ra kąnina, aua i:dja maiaru' ŋąra kudai, de iŋgauwi:nanąŋga wuląnbiri anąŋgaia tjaueri geŋu. ");
INSERT INTO wro_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Ai ko:na, kundjuŋąŋanga, Ŋḁnąŋga wuna ŋuru ŋḁnŋunuŋąnu? Minje ŋundjanąŋga maiaru' ŋąri wunja; gewunja ŋąmba njele kądjinba puŋąnindąga maiaru' ŋąra. ");
INSERT INTO wro_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Aua maiaru' ŋąra ini:ąkamanma kundjuŋu, Nḁni kuŋe, gewunja inaiuri ŋaianąŋga kuno:ŋgulara maiaru' ŋąri? Kądjinba tjḁri pąmąŋo:n, ŋad ŋḁnŋunjąŋa djiḁn kuŋąm. ");
INSERT INTO wro_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Laiburu ŋḁnuŋ ŋḁni ŋąnŋundju, gewunja wuno:murum ŋḁnŋundjąbieŋu maiaru' ŋąri i dągu, ŋḁnbąrąm maiarum arkanąŋgam maninja. ");
INSERT INTO wro_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Ai kanbuna i:dja miriŋu tjaue karwunanąŋga inaiuri anąŋga, kundjuŋąnḁŋga auurle, Wod' ardarawaia tjaue kandjo:nanąŋga inaiuri ŋaianąŋga? ");
INSERT INTO wro_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Aua kundjuŋu, Oil one hundred, (irarawa). Aua kundjuŋąnąŋga, Mili-mili ŋundjanąŋga iminjąm, atjabąnu maiirgi:rkum wiri-wiri dju fifty, (ąnŋenŋąlja). ");
INSERT INTO wro_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Burkai kaiąbuna iąkąrą, Ŋundju wod' ardarawaia tjaue kandjo:nanąŋga? Aua kundjuŋu, Wheat one hundred, (irarawa). Kundjuŋąnąŋga, Mili-mili ŋundjanaŋga iminjąm, wiri-wiri dju eighty, (anŋenŋąlja). ");
INSERT INTO wro_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Inaiuri ko:do:dala aua maiaru' ŋąra iwori gewunja wuni:uŋąri geŋu; gewunja bąndaia wuna ąŋgo:lo:lia ardi:uŋąria man dągaia arlewąraia nąnja arkulieja nąnja. ");
INSERT INTO wro_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Kuŋenuri, jḁligaia arandju njiri ŋundju-ŋundju wunja mammon wor' kąri nąnja, gewunja wuno:murum ŋaibąra kandju, pitja njinbąrąm maiarum kądjinma ŋąrim maninja. ");
INSERT INTO wro_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Aua pąrąd mureja pidi:n nąnja iŋgąnuŋ, pąrąd mureja kąnuŋ wunaiud' dąnja; aua pąrąd mureja kari pidi:n nąnja wa pąŋgąnin, pąrąd mureja kari wa pąŋgąnin wunaiud' dąnja. ");
INSERT INTO wro_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Gewunja pąrąd mureja ŋąmba wa pinjidinja, mammon wor' kąri nąnja, ąŋguja pąrąd njinmurau nidji ŋąri wunja? ");
INSERT INTO wro_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Ŋąmba pąrąd mureja wa pinjidinja iąkąra anąŋga wunja, ąŋguja njinjano: njirkanąŋga mandj? ");
INSERT INTO wro_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Inawodjieja kari kądjinba pąŋgąnawodjąngąndu inaiuri iḁruŋandu; gewunja iąkąra pitja ewąndjuru, iąkąra pitja enarienąnga, O! iąkara pitja ewodikąna, iąkąra pitja eŋąndjaŋąndjo:. Njiri kądjinba pąrąnawodjąngąndu God, mammon kuda:. ");
INSERT INTO wro_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Pharisia, kaiug lai kauwonąnąŋgori, wuna ŋuru karkąŋurula, umbili kauerąmąŋ. ");
INSERT INTO wro_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Kundjuŋąnąŋgori, Njiri njiduŋ tjḁdąŋuru njirkandjuieŋu i:dja adbąnŋąle ŋuru, O! God laiburu kąnuŋanuri njirkulum, gewunja ge i:dja nąnja karąŋ kąnuŋ, God ambula nąnja wod' dąka ma kunuŋ. ");
INSERT INTO wro_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Wuniiŋgundie, tjo:lbądaia kuda: John njini; ge-i-dągu pąlejau bąndaia God anąŋga wunia kuluiena, i:dja ardarawaia ma ŋuru djin kadbieŋiri. ");
INSERT INTO wro_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Korega wąli kunuŋ andjo:lu a kabąlba kąmburuk mąŋgąnuŋandu, pidi:nu wuniiŋgundie nąnja kądjinba puŋgauwąn. ");
INSERT INTO wro_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Aua mąŋgąnąŋgąnja njąŋgandeŋuru, ndjąkąrinja njiŋgąm, wurni kąnuŋ; aua njąŋgąm njąŋga njąŋgandiena kulanąŋga i dągu aua wurni kąnuŋ. ");
INSERT INTO wro_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","I:dja iḁruŋ tjiŋi:ra kąnina, tai kąni:na tubudubulja wobi imąlala nąnja, kądjinma wuniama mindjḁl kundjuŋiri. ");
INSERT INTO wro_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Iḁruŋ ieja, iŋumba Lazarus, kandiena maiamundu anąŋga nąnja, aua wulubąda iraraia, ");
INSERT INTO wro_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Lai kumbunanąŋga barui iŋgąnowi:ŋu wunja arge nąnja ąŋgariineri pąlalo:nma tjiŋi:ra anąŋgam i dągu; kąnąŋguria kuda: kariŋgunal mula kubąrwunanąŋga widji anąŋga. ");
INSERT INTO wro_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Ge kunina ŋad kąra debąra keŋa, manuk kaŋuriena wąląnŋąria nąnja mąląma ŋuru Abraham anąŋgam; tjiŋi:ra kuda: debąra kena, ro:k kąni:na. ");
INSERT INTO wro_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Mamąram maninja bal kumąŋ, pąmbalọa nąnja iŋgąnina mąra ko:na Abraham bọwora, Laząrus kuda: mąląma nąnja. ");
INSERT INTO wro_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Jero:l kundjuŋu, kulula, Iraia Abraham, tjḁndjeriwu, Lazarus iŋaŋawu umąndja ino:ri tjąkąl iŋgaiąb wunja agu nąnja, ąnbula ŋaianąŋga imaia iŋgandju wunja, gewunja ŋḁmareja ŋḁnun wiḁnu wuna nąnja. ");
INSERT INTO wro_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Abraham kundjuŋu, Iŋangula, ni: minjaŋuru ŋundju wunia kudai ŋundjedjer ŋunŋunina, ge kądjinu Lazarus woru; weni ŋuruma aua jḁmbula kauwi:ŋu, ŋundju ŋunmareja ŋunuŋ. ");
INSERT INTO wro_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Wuna darawa tjąkąri wąli, puląga njiri ḁri nąnja tjḁrigulum manaiudba maniŋaieŋu, gewunja arka ŋurąk ŋewa kadju ŋuru i dągąm njiri nąnja kądjinba ŋurąk parwąn, kari ma i dągąm ḁri nḁnja kądjinba ŋurąk parwąn. ");
INSERT INTO wro_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Aua kundjuŋu, Gewunja burkai ŋunjiḁb, iraia, aua iŋaŋawu maiarum iraia ŋaianąŋga ŋuru, ");
INSERT INTO wro_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","Gewunja ŋaiu kudai ŋawawaia anŋąlja; aua kundji mjanąŋgori, madji arka kuda: ŋąmba wa pareŋgunal gąri tḁmbium mḁna nąnja, pąmbalọa ŋąrim. ");
INSERT INTO wro_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Abraham kundjuŋu, Arka kudai Moses, tjo: lbądaia kuda:, arge ŋuru kanbąrkaŋurunja. ");
INSERT INTO wro_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Aua kundjuŋu, Kari, iraia Abraham; mia ŋąmba iḁruŋ imąndj i dągu ḁŋgąmurka ŋuru, kuluŋḁn pitja arọwa. ");
INSERT INTO wro_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Aua kundjuŋąnąŋga, Ŋąmba wa ŋuru panbḁrkaŋurun Moses, tjo:lbądaia kuda:, kądjinba paririmbaien ŋąmba iḁruŋ bḁri iŋgandiena imąndj i dągu. ");
INSERT INTO wro_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Kundjuŋąnąŋgori inalalaia, Madj kunjąŋgunjal womąlai kari, O! wurgunu njḁnunąŋga aua ŋanja keŋgal. ");
INSERT INTO wro_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Wunia man dągu aua wunja ŋąmba kaiug mill kąri murd kąmieŋu iurup nąnja, wai iŋgaiąbieŋu wo:ndu' ŋuru, ŋąmba nḁri iŋgąm iḁruŋ birwidiŋąria ąndja nąnja. ");
INSERT INTO wro_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Maranindj njiri ŋundju-ŋundju wunja. Ŋawalo:lidj ŋąmba woru genu, imaiḁmbu, kuluŋąn ŋąmba iŋgauwona, wai tjąbunąŋga. ");
INSERT INTO wro_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Ŋḁmba woru genu wunŋąlu lewąra tjḁruŋ, wunŋąlu kaleŋ ŋunŋunmurka, gejiri, Kuluŋąn ŋḁwona, pitja indjieriwu. ");
INSERT INTO wro_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Arkaŋawieja kubądjuŋąnąŋga, Inaiuri, pąrąd ŋąri wunaiud' minjandjunjḁri. ");
INSERT INTO wro_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Inaiuri kundjuŋu, Njiri ŋąmba pąrąd wurąŋunma tjḁląngąnja mustard kądjinu, wurąŋundjunąŋga tjilium mḁna, Ri: pąmie, wai paiąbie wo:ndu' ŋuru, pitja njinjąrąŋgąla. ");
INSERT INTO wro_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Ąŋguja njiri nąnja inawodjieja kudai iŋgąnuŋ tjḁri iŋgeŋa, kukundjeria barui ąŋgąno:, wuno: murum iŋgeŋgal yardba i dḁgu, pitja djenąŋga, Maiirgi:rkum beŋgal, atjąbąnu, mindjḁl kunja? ");
INSERT INTO wro_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Wawu pindji:nąŋga, Brar dju ge mindjḁl ŋḁnŋundju, tai bąnu, tjḁnawodju mindjḁl ŋḁnŋundju njini, djo: nḁnŋunjąŋa njini, pąlejau pitja mindjḁl dje, djo: ŋunjeju? ");
INSERT INTO wro_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Inawodjieja ko:lbo: gewunja kundjunu aua geŋunąŋga? ");
INSERT INTO wro_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Ge kadjinu njiri kuda: wuno:murum wurąŋundjuŋu ge kąni:nanuri, wuri:, Ari ardawodjieja adia ŋuru-ŋuru, kunjedjuŋ kunjedji:nja. ");
INSERT INTO wro_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Ge kunina wąli iŋgeŋaŋuriri Jerusale' ŋuru, bulumąn kena pulaga nąnja Samaria a Galilee. ");
INSERT INTO wro_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Wąli dąra iŋgeŋgunaliri maiarundjeruŋum, kauerąmąndjerala i:dja ḁnŋenŋąlja leper ŋąria, arka bọwora jo:la kubądjuŋ, ");
INSERT INTO wro_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","Ŋąla-ŋąla arkanąŋga brai kubądjąndąla kubądjuŋ, Jesu, Inaiuri, ąndjeriwu. ");
INSERT INTO wro_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Aua ąŋganindjąŋa kundjuŋąnąŋgori, Njiriu, njidbiimbaienąŋga dadjurd ŋąra. Ge kunina, wąli ḁŋgeŋaŋuriri, kadburduiena. ");
INSERT INTO wro_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Iḁruŋ arka nąnja, wuno:murum iŋganindjiena aua iŋgąmurdui:na, wąlŋąrai kauwona, ŋąla-ŋąla daraiu ko:do:daleri God. ");
INSERT INTO wro_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Kauwona imiŋum maninja ierdu imąnŋąle ŋuru, ko:lbo:neri; aua kuda: Samaria ŋąra. ");
INSERT INTO wro_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Jesu kaio: lbąla kundjuŋu, Wawu ąnŋenŋąlja panburdui:nja? Atjąkekąria ŋḁnia? ");
INSERT INTO wro_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Wawu mąra parwimja wąlŋąrai ąŋgauwona God iŋgarko:do:da wunja, indja edbul' ekamandj? ");
INSERT INTO wro_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Gejau kundjuŋąnąŋga, Bḁri bąnu, baiuŋuru; wa puŋgąŋudjarien ŋąri ŋundjąnąŋga ŋunmundulbąla. ");
INSERT INTO wro_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Burkai iŋgaiąbiena Pharisia nąnja ąŋudjau keŋgal bąndaia God anąŋga, kandjo:lbąla, kundjuŋu, Bąndaia God anąŋga wa puŋgeŋgunal mu:n njiniŋge, ");
INSERT INTO wro_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Kari pitja puŋgadjin, Wai ŋuru, ma; gewunja bąndaia God anąŋga mamulba njiri nąnja kunuŋ. ");
INSERT INTO wro_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Kundjuŋąnąŋgori inalalaia, Lewąra pitja njejeŋgal ŋąma wurąŋundjiri mąra wunja lewąra tjḁruŋ I:dj' iŋko:lu anąŋga, pitja wa mḁra puro:n. ");
INSERT INTO wro_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Pitja bąrenuri, wai ma, wai ŋuru; njiri kari arwelbam, parąmalando:jiri. ");
INSERT INTO wro_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Gewunja kądjinu mąlŋirinja mal kundjiri kanalu waiuru andjo:l' dąnja indal' djini waiuru andjo:l' dąnja, ge kadjinu pitja enu I:dj' iŋko:lu lewąra anąŋga nanja. ");
INSERT INTO wro_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Darawa wungurle madj kundji:nja, madj kaiąbienja ąndja arkulieja nąnja. ");
INSERT INTO wro_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Noahjau kądjinu, pitja njḁnu I:dj' iŋko:lu lewąra anąŋga nąnja: ");
INSERT INTO wro_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Mindjḁl kubądjuŋiri, djo: kariŋeri, pąnąn karwoneri, pąnąn kunja kadowi:neri, lewąra ge njini Noah dąra iŋgeŋaŋuru ark ŋuru, worumbąm maŋgeŋgunal, ardarawaia bądawadai kundjuŋąnąŋgori. ");
INSERT INTO wro_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Kądjinu Lotjau; mindjḁl kubądjuŋiri, djo: kariŋeri, kanbądburąŋeri, ko:l kubądjuŋiri, kanbąrkandeŋiri, bąn kubadjuŋiri; ");
INSERT INTO wro_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","O! ge-i-di-dagu Lot mąŋgaiandiwela Sodom, wiḁnu, brimstone pḁlulu kuninal ąndjo:l' di dągu, bądawadai kundjuŋąnąŋgori. ");
INSERT INTO wro_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Ge kądjinu pitja njḁnu lewąra I:dj' iŋko:lu pitja emiimbaie. ");
INSERT INTO wro_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Lewąra gejau aua iŋgąnuŋ maiarum malerdu nąnja, wuląnbiri anąŋgaia maiarum maninja, jeri pąŋgowaliri ąŋgaŋuru wunja; aua kuda: yardba nąnja iŋgąnuŋ, wararkar pąŋgąniri pąle ŋuru. ");
INSERT INTO wro_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Ni: njiraŋuru Lot mąŋgąnąŋgąnja. ");
INSERT INTO wro_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Aua buluk iŋgeŋa iŋaui kąmąndulba wunja, pitja njoiim; aua koiim, pitja wundjedjer njandju. ");
INSERT INTO wro_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Kuŋenuri, wundugum majau iḁruŋandu pitja enandu inarugu tjḁruŋ nąnja, iąkąra pitja emie, iakąra pitja emąŋgie; ");
INSERT INTO wro_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Ndjḁruŋandinja pitja wurąŋgan njejandiri, ndjąkąrinja pitja njemie, ndjąkąrinja pitja njemąŋgie. ");
INSERT INTO wro_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Iaruŋandu pitja enandu yardba nąnja, iąkḁra pitja emie, iąkąra pitja emangie. ");
INSERT INTO wro_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Kauerio:lbąla, kubądjuŋanąŋga, Ŋḁnąm, Inaiuri? Aua kundjuŋąnąŋgori, Ma durgu, ma kuda: pitja djḁruk arąmie waranaia. ");
INSERT INTO wro_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Bḁre-bḁre kundjuŋąnąŋgori, kądjinma dadjurd kubądji:nja, ilura padiri. ");
INSERT INTO wro_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Kundjuŋu, Wureŋąra iḁruŋ kąnina malaiindem maiaruŋam maninja aua God wa paŋgo:lgunenja, i:dja wa ŋuru paŋgaŋurunja. ");
INSERT INTO wro_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Ndjo:rinja malaiindem maua nąnja njinina, njąŋga tjile-jile kąmurkalal kundjuŋiri, Wure tjḁno: inauurgundj ŋaianąŋga wunja. ");
INSERT INTO wro_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Wąli kądjinba puŋgenja; O! pąlejau ini: ąkamanma kundjuŋu, Ŋaiu ŋąmba wa pąŋo:lgunąn God, wa ŋuru pąŋaŋurun i:dja, ");
INSERT INTO wro_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","Ko: ge wunja njina ndjo:rinja ŋḁnŋąliŋga, wure ŋo mąŋga, ŋąmba wa pinjeŋgaliri tjile-jile kadada pąŋąngandjuiri. ");
INSERT INTO wro_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Inaiuri kundjuŋu, Ŋuru njidu wureŋąra alikoli ge. ");
INSERT INTO wro_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Wawu God wure panbun adburieja anąŋgaia, jero:l kadjunąŋgeri lewąra, wundugum, njḁmula iŋgąnuŋąnąŋgori? ");
INSERT INTO wro_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Kuŋenuri aua pitja wure ąnjo: maiirgi:rkum. O! wuno:murum I:dj' iŋko:lu iŋgeŋgal, mąra njo: pąrąd ŋąri kabąlba nąnja? ");
INSERT INTO wro_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Kundjuŋąnąŋgori atjąkekąria ark a ŋundju-ŋundju pąrąd ąŋgąmurauwi:na, tjḁdąŋuru wa ąŋgąmiena, atjąkekąria iluk ąŋganbądbąŋ, bḁre-bḁre wuna. ");
INSERT INTO wro_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","I:gąndu pai kąninandu dadjurdŋąrim ŋuru dadjurd kunja, iąkąra Pharisee, iąkąra publican. ");
INSERT INTO wro_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Pharisee kauwelgenja, wuna dadjurd kundjuŋu ini:ąkamanma, God, ŋungulbo: ŋaiu i:dja atjąkekąria kądjin' ŋuru-ŋuru, adbia, arkolikolia, wurni-wurnia, indja publican ŋaiu kądjin' ŋuru-ŋuru; ");
INSERT INTO wro_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Ŋaiamindjąŋa tjḁruŋandu mąnŋąle Wunaiurujau, adbunduŋuru kaŋano: ardarawaia ąŋąnŋunawungeri. ");
INSERT INTO wro_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Publican bọwora kauwelgenja, wa bal nąma puŋgenja ąndjo:l' kuru, O! imąnŋąlim ŋoiil kundjuŋu, kulula, God tjḁndjeriwu ŋḁworu. ");
INSERT INTO wro_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Kuŋenuri indja jeri kauwonaŋuru maiarum anąŋga' ŋuru tjḁdąŋuru iŋgandjui:na iąkąra nąnja; gewunja aua ŋundju-ŋundju waiuru iŋgąni:ŋu pitja brai eni:. ");
INSERT INTO wro_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Kanbąrkaŋurulaldąga: ardjaiandia aua ąŋgąmąndana wunja; inalalaia mąra aŋganbarwuna kanbądbaiḁmbuna, ");
INSERT INTO wro_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","O! Jesu ai kanbuna, kundjuŋu, Woŋąlaląŋuja kariŋgunjalgąra, kąre paro:jiri, gewunja arge kądjindjia bąndaia God anąŋga. ");
INSERT INTO wro_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Nidji kuŋenuri, aua bąndaia God anąŋga ŋąmba wa puŋgąmąn ŋąri woŋąląŋ kądjindja, ma ŋuru wa pitja pąŋgeŋąn ŋuru. ");
INSERT INTO wro_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Iḁruŋ inaiuri burkai kaiąbuna kundjuŋu, Iniiŋgundeja ŋunia, ŋḁni kuŋe wundjedjer kądjinma ŋąri ŋḁnŋuma? ");
INSERT INTO wro_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Jesu kundjuŋąnąŋga, Ąŋudja kunja ŋḁnia kundjiara? Kari inia, God auekamandj. ");
INSERT INTO wro_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Laiburu ŋunuŋ ŋąla-ŋąla wununauie, Wurni puŋuniri, Bąda pandjo:jiri, Maneba pąmąndjo:jiri, Pḁre pandjaŋuriri, Iro:lidj, karanja ŋuru aŋurandu. ");
INSERT INTO wro_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Aua kundjuŋu, Wuna darawa kuŋeŋiri woŋḁląŋ ŋḁnŋuninal. ");
INSERT INTO wro_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Jesu ŋuru ingąnina kundjuŋąnąŋga, Wąli tjḁruŋ ŋuno:ra; ardarawaia ąndjąŋunauwungaia ko:l dju, ardjeja ąno:, gejau pitja kudai ŋunjąnu wuląnbiri ąndjo:l' dąnja; kąkọ, tjḁnmalandowal. ");
INSERT INTO wro_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Aua wuna ŋuru iŋgąnina djenbeŋuru pakul kąnina, gewunja djenbeŋuru tjiŋi:ra kąnina. ");
INSERT INTO wro_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Jesu iŋgąŋindjąŋa kundjuŋu, Adbąnŋąle ŋuru arka wuląnbiri kudai ąŋgąnuŋ ąŋgeŋa ŋuru bandaia God anąŋga ŋuru. ");
INSERT INTO wro_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Camel needle ambula pąŋgejuŋuru ŋąna, tjini:ra imąnŋąle ŋuru iŋgeŋa ŋuru bąndaia God anąŋga ŋuru. ");
INSERT INTO wro_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Arka ŋuru ąŋgąnina kubądjuŋ, Ąŋguja ŋąna pąŋgąmundulbaie? ");
INSERT INTO wro_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Aua kundjuŋu, Ge i:dja wa puŋgadjin ŋąri, God gole puŋge. ");
INSERT INTO wro_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Peter kundjuŋu, Wai, ḁri kanjedbąŋgi:la ar-arkanąŋgaia, ŋunbądbalando:na. ");
INSERT INTO wro_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Aua kundjuŋąnąŋgori, Nidji kuŋenuri, i:dja kari wa pąŋgąnin, ŋąmba ąŋgąmąŋgi:la maiarum, mąŋganja, ŋawawaia, inenaiurgandu, woŋąlalḁŋuja, bąndaia God anąŋga wunja. ");
INSERT INTO wro_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","Wa pitja ino:ra pąŋgeŋan, pitja ąnjam ardarawaia atjąkekąria wendjiau, bąndaia keŋgal gąri nanja wundjedjer kądjinma ŋąri. ");
INSERT INTO wro_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Kanmurąŋ twelve, inalalaia, kimdjuŋąnąŋgori, Wai, Jerusale' ŋuru pai ŋḁrąnu, gejau pitja ko:rug njḁmie darawa wiri-wiri kauwi:na tjo:lbądaia nąnja I:dj' iŋko:lu wunja. ");
INSERT INTO wro_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Aua pitja enowi:nąŋgori edbulia, umbili pitja njąm, woru pitja njąmienąŋga, pitja tjipa ewi:; ");
INSERT INTO wro_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Pitja wodpili ewuro:, bąda ewuro:; lewąra tjḁruŋuriau pitja bḁri enu. ");
INSERT INTO wro_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Arka wuna darawa wa puŋgadenenja; ŋąla-ŋąla wuna kundjąlgaiena-ŋąŋgori, wa laiburu padinja ge kaluiena. ");
INSERT INTO wro_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Ge kunina, wąli wodjulu iŋgeŋgunaliri Jericho nąnja, iḁruŋ ambulidj atją kąnineri kalumba iwondąra nąnja, kaniauwuneri. ");
INSERT INTO wro_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Ŋuru iŋgąnina peleŋgąre tjḁnai ąŋgeŋeri, burkai kandjąbuna, Ąŋudja wuna? ");
INSERT INTO wro_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Kubądjuŋąnąŋga, Jesu Nazareth ŋąra tjḁnai keŋeri. ");
INSERT INTO wro_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Aua jero:l kundjuŋu, Jesu, David ŋunŋungula, tjḁndjeriwu. ");
INSERT INTO wro_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Arka mąnŋąle ąŋgeŋeri kauerąmaiḁmbuna, aua kumuk kunja; O! aua tjąkąri djenbeŋuru jero:l kundjuŋu, David ŋunŋungula, tjḁndjeriwu. ");
INSERT INTO wro_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Jesu kauwelgenja, kundjuŋu iŋgaŋurieŋal kunja. Wuno:murum wodjulu iŋgeŋgunal, burkai kaiąbuna, ");
INSERT INTO wro_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","Ŋḁni djejara kundjiara? Aua kulula, Inaiuri, bal ŋḁnŋuma. ");
INSERT INTO wro_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Gejau Jesu kundjuŋąnąŋga, Bal minjąm; pąrąd ŋundjanąŋga ŋunmundulbąla. ");
INSERT INTO wro_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Maiirgi:rkum bal kumąn, kąmalando:na, God ko:do:daleri. I:dja ardarawaia mara iŋgąrwuna God kauero:do:dala. ");
INSERT INTO wro_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Jericho dąra keŋgunal, bulumąn keŋaŋuriri. ");
INSERT INTO wro_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Wai, i:dja iŋumba iŋgąrimiena Zacchaeus, aua publican inąiuri iŋgąnina, tjiŋi:ra kąnina. ");
INSERT INTO wro_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Kąŋąnjiro:na Jesu iŋgąnindja wunja, ąŋguja iŋgąnina, kądjinba pąŋgąnindjenja peleŋgąre nąnja, aua iau iŋgąnina. ");
INSERT INTO wro_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Mąnŋąle wąri-wąri keŋa, pai kąnina tjilium maninja iŋgąnindja wunja, ma ŋuru iŋgeŋa ŋuru. ");
INSERT INTO wro_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Jesu, wuno:murum iŋgeŋgunal tḁmbiu' ŋural, kąle kundjuŋu, kundjuŋąnąŋga, Zacchaeus, maiirgi:rkum jeri bọwal; weni maiarum ŋundjanąŋgam maninja atją ŋenu. ");
INSERT INTO wro_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Aua maiirgi:rkum jeri kauwonal, tjukul kąmąŋanąŋga. ");
INSERT INTO wro_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Mara iŋgarwuna, ardarawaia jau karkaŋuriena, kubądjuŋiri, Aua dąra keŋaŋuru atja wunja i:dja iwori nąnja. ");
INSERT INTO wro_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Zacchaeus kauwelgenja kundjuŋanąŋga Inaiuri, Wai, Inaiuri, alamia wuląnbiri ŋaianąŋgaia ardjeja ąŋano:, ŋąmba woru ąŋąnŋuno:ŋgula i:dja nąnja, ardarawaia atjąkekąria pitja ąŋano:naŋga. ");
INSERT INTO wro_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Jesu kundjuŋanąŋga, Weni umundulbaie kunjąŋgunal maiarum mḁna nąnja, aua kuda: Abraham iŋko:lu iŋgąnuŋ. ");
INSERT INTO wro_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Gewunja I:dj' iŋko:lu keŋgunal iŋgąŋąnjiro: wunja, iŋgąmundulba wunja, iŋgoiimiena. ");
INSERT INTO wro_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Arka ŋuru ąŋgąnina bḁre-bḁre kuda: kundjuŋąnąŋgori, aua Jerusalem wodjulu iŋgąnina, arka ni: kadina bąndaia God anąŋga maiirgi:rkum mąra njḁwi:. ");
INSERT INTO wro_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Gewunja kundjuŋu, I:dja iḁruŋ inaiuri tḁmbiu' ŋuru bọwora keŋa-ŋuru, mąŋgąma wunja tḁmbium aua ŋundju-ŋundju wunja, djo:li iŋgąninal kunja. ");
INSERT INTO wro_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Ai kanbuna ardawodjieja anąŋgaia ąnŋenŋąlja, kaiug wunŋenŋąlu kanino:la, kundjuŋąnąŋgori, Wuraŋuriri ŋḁnŋunjeŋgal djini. ");
INSERT INTO wro_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","I:dja anąŋgaia kauero:ndjurula, wąląnu kubąrkaŋawuna iwelbam, kubądjuŋ, Wa lai pąŋgauwon-njḁri indja inaiuri iŋgąnuŋanjḁri. ");
INSERT INTO wro_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Ge kunina wuno:murum djo:li iŋgąninal, tḁmbium gole mąŋgąmąŋ, kundjuŋu ai aŋgauwi:ŋu wunja ardawodjieja arka kaiug ąŋgąnino:la, aua laiburu iŋgąnuŋ wunja ŋḁni kadjuŋu ardjerundjerunŋuja. ");
INSERT INTO wro_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Iwurle kąmurkalal kundjuŋu, Inaiuri, kaiug ŋundjanąŋga gole kumurąŋ kaiug wunŋenŋąlu tjąkąri. ");
INSERT INTO wro_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Aua kundjuŋąnąŋga, Wuniama, inawodjie ŋunia, pąrąd ŋąra ŋunŋunina pidi:n nąnja, ŋunaiuru bąnu malaiindem manŋenŋąlba nąnja. ");
INSERT INTO wro_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Iąkąra keŋgunal kundjuŋu, Kaiug ŋundjanąnga, Inaiuri, gole kumurąŋ kaiug tjąkąri wun-ŋąlu. ");
INSERT INTO wro_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Aua kuda: kundjuŋanąŋga, Ŋundju kuda: ŋunaiuru bąnu malaiindem manŋąlba nąnja. ");
INSERT INTO wro_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Iąkąra keŋgunal kundjuŋu, Inaiuri, wunindja kaiug ŋundjanąŋga, kuŋaŋurulal kuŋandeŋu wobi nąnja; ");
INSERT INTO wro_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Gewunja ŋungulgunąla, i:dja ŋundądarąda ŋunŋunuŋ, kimdjąmura wa pindjandenja ŋąri, dur kundji: wa pindjandenja kabąlba nąnja. ");
INSERT INTO wro_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Aua kundjuŋanąŋga, Ŋundjamundu ŋund-janąŋga nąnja pitja wure ŋo:nu, inawodjie ŋuworu. Laiburu ŋunina ŋaiu i:dja ŋḁrądarąda, kuŋąmura wa puŋandenja, dur kuŋe wa puŋandenj a kabąlba nąnja; ");
INSERT INTO wro_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Ąŋudja kunja wa pindjąnino:nja kaiug ŋaianąŋga kaiug ŋąria? Gejau djo:li ŋąnŋuninal ŋḁnŋumąŋ ŋainąŋga tjąkąri nąnja? ");
INSERT INTO wro_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Arka ŋaiilem ąŋgauwelgenjiri kundjuŋąnąŋgori, Aua kaiug irano:ŋgu, irano: aua wunŋenŋąlu kudai. ");
INSERT INTO wro_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Kubądjuŋanąŋga, Inaiuri, aua gole kudai kaiug wunŋenŋąlu. ");
INSERT INTO wro_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Kuŋenuri, Aua kudai iŋgąnuŋ pitja njḁno:wi:nąŋga; aua ino:ra pitja njḁno:ŋgienąŋga ge aua kudai. ");
INSERT INTO wro_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Mia ardauurgundjia ŋaianaŋgaia, arka wa lai pąŋgauwenjanąŋgori ŋḁnaiuru ark a nąnja, araŋural, bąda arana ŋḁmąnŋąle ŋuru. ");
INSERT INTO wro_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Wuno:murum wuna geŋu, mąnŋąle keŋaŋuru pai kąninaŋuriri Jerusale' ŋuru. ");
INSERT INTO wro_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Ge kunina, wuno:murum mąŋgamurkalaliri Bethphage a Bethany, kurandu nąnja kąrimiena Oliva ŋąri, kaŋaŋawunandu inalalandu, ");
INSERT INTO wro_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","Kundjuŋiri, Njiriandu maiarundjeruŋu' ŋuru mąndjo:ri, ma nąnja njirkunjąŋaŋurandu pitja mąra irewandu donkey kauila murd iŋgąmiena, bura irąmandu, iraŋuralgandu. ");
INSERT INTO wro_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Iąruŋ ŋąmba burkai njindjąbandu, Ąŋudjakunja burąŋgai kąrąmandiri? Wurunąŋgowu wurinąŋgandu, Inaiuri iŋąma kundju. ");
INSERT INTO wro_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Iŋaŋawiandu keŋaŋurandu, mąra ko:nandu kądjinu geŋunąŋgandu. ");
INSERT INTO wro_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Wąli burąŋgai iŋgąmąŋandiri kauila, anąŋga ŋąria kubądjuŋanąŋgandu, Ąŋudjakunja kauila burąŋgai kąrąmandiri? ");
INSERT INTO wro_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Kundjuŋandu, Inaiuri iŋąma kundju. ");
INSERT INTO wro_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Kaŋurulalgandu Jesu nąnja, wobi anąŋgandu ko:guleŋandu kauila nąnja, Jesu atka kaueri:la. ");
INSERT INTO wro_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Wąli iŋgeŋaŋuriri, wobi arkanąŋga ląŋgąr kanbąrkandjuna kalumba nąnja. ");
INSERT INTO wro_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Wuno:murum wodjulu iŋgeŋgunaliri gole ŋḁlilim maninja kurandu Oliva ŋąri, peleŋgąre ardarawaia inalalaia wunmanbąli tjukul kadineri, God kauero:do:daleri ŋąla-ŋąla daraiu wundjurulu darawa wunja kadidjąŋa; ");
INSERT INTO wro_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Kubądjuŋiri, Tjukul ŋąra aua iŋgeŋgal Inaiuri iŋumba Inaiud' dąnja; andjo:l' dąnja jḁmbula ŋąri, pąlemba karąn ŋąri nąnja. ");
INSERT INTO wro_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Atjąkekąria Pharisia peleŋgąre nąnja Kubądjuŋanąŋga, Iniiŋgundeja, ŋunalalaia ąnmaiḁmbu. ");
INSERT INTO wro_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Aua kandjo:lbąla kundjuŋu, Kuŋenuri, ąndja ŋąmba kumuk karwu, kaiuguja jero:l puŋgadju. ");
INSERT INTO wro_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Wuno:murum wodjulu iŋgeŋgunal, malaiindem manindjąŋa, wola: kundjuŋu maua wunja, ");
INSERT INTO wro_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","Kundjuŋiri, Ŋundju ŋąmba laiburu ŋunŋunina lewąrajau ŋundjanąŋga, ŋundju kuda:, wunia jḁmbula ŋąri; weni kundjąlgiena ŋungubul' dąnja. ");
INSERT INTO wro_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Gewunja lewąra pitja njejeŋgal ŋundju nąnja gejau ardauurgundjia ŋundjanąŋgaia pitja mewąraru kabąlba ŋundju nąnja, pitja wo:ri mewuro:nu, pitja tjilibid ŋunbąrąm kądjinma, ");
INSERT INTO wro_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Ŋarwu ŋunbąraru, woŋąlaląŋuja ŋundju nąnja kuda:; kądjinba puŋgadbąŋgi:n kaiug kaiug nąnja ŋundju nąnja, wa laiburu puŋuninja ŋąri ŋunŋunbadburkajau. ");
INSERT INTO wro_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Dąra keŋaŋuru dadjurdŋąrim maninja, wai kandjąbuna arka ko:l kadjuŋu, ");
INSERT INTO wro_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Kundjuŋąnąŋgori, Wiri-wiri kumbi:na, Maiarum ŋaianąŋgam pitja meniŋaie maiarum dadjurdŋąrim; O! njiri marandjuna kąnmenma lulun ŋąria arkanąŋgam. ");
INSERT INTO wro_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Kaniiŋgundaleri tjile-jile dadjurdŋąrim maninja. Ardenaiuri dadjurdŋąria, wiri-wiri ŋąria kuda: kubąrkąnjiro:na bąda iŋgarwu wunja, ardenaiuri i:dja kuda:, ");
INSERT INTO wro_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Wa mąra parwi:nja ŋḁnąŋga kadju wunja; peleŋgąraia ardarawaia djḁruk ąŋgadbiena aua ŋuru iŋgarkaŋuru wunja. ");
INSERT INTO wro_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Ge kunina, lewąra tjḁruŋujau, aua ąŋgąniiŋgundaleri i:dja dadjurdŋąrim maninja, wąląnuwunia ardi:um kaluleri, kauerąmurkalal ardenaiuri dadjurd ŋąria, wiri-wiri ŋąria, mababaia kuda:, ");
INSERT INTO wro_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Kubąlula, kubądjuŋąnąŋgeri, Minjenjḁri, Ąŋudja wundjurulu njiniŋge wuna kundji:, ąŋguja ŋuno:na wundjurulu wuna? ");
INSERT INTO wro_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Aua kandjo:lbąla kundjuŋąnąŋgori, Ŋaiu kuda: burkai njinjiąb ŋąla-ŋąla tjḁruŋ, wuriara, ");
INSERT INTO wro_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Baptism John anąŋga, ąndjo:l' i dagu, i:dja i dągu, kunina? ");
INSERT INTO wro_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Arge wurura kubąrwḁdeŋiri, Ŋąmba njerkulu, Ąnd jo:l' i dągu, aua pitja nje, Ąŋudjakunja kurąŋudjaralanąŋga? ");
INSERT INTO wro_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Ŋąmba njerkulu, I:dja i dągu, i:dja ardarawaia kaiug pitja tjuna bąreŋḁri, gewunja arka wa pauerąŋudjarąn John tjo:lbąda iŋgąnina. ");
INSERT INTO wro_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Kauerio:lbąla, wa laiburu padinja ŋḁru i dągu. ");
INSERT INTO wro_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Jesu kundjuŋąnąŋgori, Ŋaiu wa puŋen-nuri ąŋudja wundjurulu njiniŋge wuna ŋḁnŋundju. ");
INSERT INTO wro_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Wunmanbali i:dja kundjuŋąnąŋgori bḁre-bḁre wuna; I-dja iḁrun tjḁri ŋąrim mandeŋu, maua manino: la tjḁri ŋąria, maiąndiwela tḁmbium maiąkąri' ŋuru maranu. ");
INSERT INTO wro_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Wuniajau kaŋaŋawuna tjḁri ŋąria nąnja inawodjieja, arka kurab tjḁri ŋąrim maninja iŋgado: wunja; O! tjḁri ŋaria wodpiliba kauerio:rala, kaueraŋaŋawuna ino:ra. ");
INSERT INTO wro_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Inawodjieja iąkąra njele kąŋaŋawuna; aua wodbandąga wodpiliba kauerio:rala, umąra kubądjuŋanąŋga, kaueraŋaŋawuna ino:ra. ");
INSERT INTO wro_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Iąkąra njele kąŋaŋawuna; aua kuda: iŋgadbalimąla, wai kaueriąbuna. ");
INSERT INTO wro_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Gejau kundjuŋu inaiuri tjḁri ŋąrim, Ŋani ne? Pitja iŋaŋaŋawu iŋąngula ŋḁnŋunarieŋunąŋga; djiu ŋąna arka ŋuru paueraŋuru. ");
INSERT INTO wro_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Tjḁri ŋąria wuno:murum aua mąra iŋgarwuna, arge wurura kadiŋaiena, Indja iŋko:lu kąnuŋ; bąda ąro;, gejau tjḁri ŋąrim ŋarkanąŋgam pitja menu. ");
INSERT INTO wro_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Wai kaueriąbuna dąnde tjḁri ŋąrim, bąda kauero:na. Gewunja ŋḁani pitja njenąŋgori inaiuri tjḁri ŋąrim? ");
INSERT INTO wro_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Pitja ejeŋgal, pitja bąda anjo: ąndja tjḁri ŋąria, tjḁri ŋąrim atjąkekąria pitja menino:nąŋgori. Ŋuru ąŋgąnina kubądjuŋ, Kari puŋgąniri. ");
INSERT INTO wro_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Aua kanindjąŋa, kundjuŋu, Gewunja ąŋudja wuna wiri-wiri kauwina, Kaiug ge wondi mąŋgarwiria wai kadjąbuna, ge i di dągu umri: ruko:wa kuniŋaiena? ");
INSERT INTO wro_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Aua iŋgauwona kaiug ge nąnja pitja elemie; aua nąnja ge kauwona, pitja wurąŋgąn njenąŋga tjurni' njinim. ");
INSERT INTO wro_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Wiri-wiri ŋąria, ardenaiuri dadjurd ŋąria kuda:, kubąrkąnjiro:na laburd iŋgadba wunja ge i di dągu; i:dja kanbąrkulgunąla; laiburu ąŋgąnina auą geŋu bḁre-bḁre wuna arka wunja. ");
INSERT INTO wro_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Mu:n marwunanąŋga, kanbąrkaŋawuna tjąŋąrkuja, adjadjin ąŋgąnuŋ wunja tjḁdąŋuria, aua laburd iŋgadba wunja ŋąla-ŋąla nąnja, gejau arka pitja ewurino: wundjurul' dąnja inaiuri anąŋga. ");
INSERT INTO wro_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Burkai kaueriąbuna, kubądjuŋ, Iniiŋgundeja, laiburu ḁduŋąnu nidji tjuŋundju, ąndjąniiŋgunda, i:dja kari wa pandjo:lgunąn, God ŋąri nidji kandjaniiŋgunderi; ");
INSERT INTO wro_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Wuniọwu ḁri Caesar kaiug erkuno:, wuniọwu ŋuru-ŋuru? ");
INSERT INTO wro_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Aua laiburu kąninanąŋgori ardjadjin bądaia, kundjuŋąnąŋgori, ");
INSERT INTO wro_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","Tjḁrąmiimbu kaiug tjḁruŋ; ąŋguja anąŋgam imiŋum, wiri-wiri? Arka kubądjuŋ, Caesar anąŋga. ");
INSERT INTO wro_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Aua kundjuŋąnąŋgori, Gewunja irano: Caesar Caesar anąŋga, irano: God God anąŋga. ");
INSERT INTO wro_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Kądjinba laburd puŋgadbąn ŋąla-ŋąla anąŋga i:dja adbąnŋąle ŋuru, rąngąri kariŋa aua ąŋgaio:lbąla, kumuk karwuna. ");
INSERT INTO wro_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Kauerąmurkalal atjąkekąria Sadducia, arka kubądjiri kari wa bḁri padin, burkai kaueriąbuna, ");
INSERT INTO wro_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","Kubądjuŋ, Iniiŋgundeja, Moses wiri-wiri kundjuŋunjḁri, i:dja ŋawanąŋga ŋąmba debąra iŋgeŋa mąŋgąnąŋgąnja kudai, woŋąląŋ ino:ra, ŋawanąŋga mąŋganja njimenja, woŋąląŋ bḁri ąŋgaiąnda wunja ŋawanąŋga wunja. ");
INSERT INTO wro_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Gewunja kadina ŋawawaia ąnŋąlja; iwurlge mąŋgąnąŋgąnja njimąŋ, debąra keŋa woŋąląŋ ino:ra; ");
INSERT INTO wro_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Pulaŋąra kuda:; ");
INSERT INTO wro_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Leŋgunda kuda: njimąŋ, ge kądjinu ąnŋąlja miriŋu, woŋąląŋ ardo:raia, debąra kadjurlina. ");
INSERT INTO wro_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Pąlejau woŋaiinja kuda: debąra njeŋa. ");
INSERT INTO wro_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Gewunja bḁri ąŋgąnuŋjau, ąŋguja anąŋgąnja mąŋgąnąŋgąnja pitja njeŋu? Gewunja ąnŋąlja njimąŋeri mąŋgąnąŋgorinja. ");
INSERT INTO wro_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Jesu kundjuŋąnąŋgori, Ąŋgo:lo:lia bąndaia wuna ŋąria pąnąn karwona, pąnąn kunja kado:wi: nja; ");
INSERT INTO wro_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Arka ardinia mandjia bąndaia ge ąŋgąmąŋ wunja, bḁri ąŋgąnuŋ wunja adbąn nąnja, wa pąnąn parwąn, wa pado:wi:n pąnąn kunja; ");
INSERT INTO wro_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Kądjinba debąra pariŋąn njele, gewunja kaduŋ wąląn ŋąria kądjindjia, God ąŋgo:lo:lia kaduŋ arka bḁri ąŋgaladiąŋ. ");
INSERT INTO wro_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Adbąn bḁri ąŋgąnuŋ, Moses kanmiimbuna irulul' dąnja, wuno:murum geŋunąŋga Inaiuri God Abraham anąŋga, God Isaac anḁŋga, God Jacob anąŋga. ");
INSERT INTO wro_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","God wa pąŋgąnin adbąn arkanąŋga, O! ardjedjeria arkanąŋga; gewunja ardarawaia ardjedjeria kaduŋanąŋga. ");
INSERT INTO wro_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Atjąkekąria wiri-wiri ŋąria kauerio:lbąla kubądjuŋ, Iniiŋgundeja, wunia kundjalula. ");
INSERT INTO wro_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Pąlejau kari kądjinba dąrąngu padinja kari burkai iŋgadjąb wunja. ");
INSERT INTO wro_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Kundjuŋąnąŋgori, Nḁrunąŋgowu kubądjiri Christ David iŋko:lu? ");
INSERT INTO wro_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","David ŋundju-ŋundju kundjiri mili-mili kan nąra nąnja, Inaiuri kundjuŋąnąŋga Inaiuri ŋaianąŋga, Atjąbąnu ŋaiu worawerdum maninja, ");
INSERT INTO wro_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","Ąŋande njini ardauurgundjia ŋundjanąŋgaia ŋundjerdu waiuru. ");
INSERT INTO wro_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Gewunja David kąrim Inaiuri, ŋḁrunąŋgowu iŋko:lu kąnuŋ? ");
INSERT INTO wro_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Peleŋgąre ardarawaia wąli ŋuru ąŋgąnineri kundjuŋąnąŋgori inalalaia, ");
INSERT INTO wro_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","Lia marąm wiri-wiri ŋąria wunja, arka lai kauwoŋąnąŋgori wudawa ąŋgeŋuru wunja wobi karąŋgendjia nąnja, wulmai lai kauwonąnąŋgori ko:l ŋąrim maninja, adbąli' kąrim karąŋ ŋąrim mąŋąria nąnja. ");
INSERT INTO wro_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Arka mindjḁl kadju maiarum ardjo:jo:ria arkanąŋgam, mara-maranu dadjurd kadju, ąŋgąnindjieŋu wunja; umąlimaie wunaiuru pitja pąrąm. ");
INSERT INTO wro_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Bal kumąŋ, mąra kanbuna tjiŋi:ria lulwa karkuguleŋu kaiugŋąri' ŋuru. ");
INSERT INTO wro_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Mąra njimbuna kuda: ndjḁruŋ ndjo:rinja ndjenja ma ko:guleŋu kaiug tjḁruŋandu pidi:nu. ");
INSERT INTO wro_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Aua kundjuŋu, Nidji kuŋenuri, njąŋga ndjo:rinja ndjenja kuŋguguleŋu tjąkąri man dągu ardarawaia nąnja; ");
INSERT INTO wro_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Gewunja ąndja ardarawaia darawa kudai ąŋgąnuŋ, lulwa kubąrkuguleŋu, O! njąŋga njino:ra kuŋguguleŋu darawa wundjedjeru njąŋgananga. ");
INSERT INTO wro_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Atjąkekąria kadjuŋiri dadjurdŋąri' wunja, mamąlalam mąŋgąnina kaiug wunia njiniŋge, ląŋugu njiniŋge, kundjuŋu, ");
INSERT INTO wro_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","Wuna wurąŋunindj, lewąra pitja njejeŋgal, gejau wa pitja puŋgąmąŋgien ŋuruma kaiug kaiug nąnja, nąmba wa puŋgaiąbien ŋąri. ");
INSERT INTO wro_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Burkai kaueriąbuna kubądjuŋ, Iniiŋgundeja, Ąŋudjau gewunja wuna pitja njḁnu? Ŋḁnąŋga umiimbaie wuna pitja njejeŋgal? ");
INSERT INTO wro_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Aua kundjuŋu, Maranindj, pinjirkądjuiejiri; gewunja ardarawaia pitja areŋgal ŋḁŋumba nąnja, pitja bąre, Ŋaiu ŋḁnuŋ, lewąra wodjulu kunuŋ; paramalando:jiri. ");
INSERT INTO wro_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Wuno:murum ŋuru njirkunuŋ mąląni' wunja, wurgunu wunja, pinjirgulgunejiri; wungurle madj kunjąŋgunjal, O! umindjuŋuru maiirgi:rkum ŋuru-ŋuru. ");
INSERT INTO wro_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Gejau kundjuŋąnąŋgori, Worumba pitja bari arąmurkie worumba nąnja, bąndaia bąndaia nąnja. ");
INSERT INTO wro_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Ŋuli-ŋulim manaiudba pitja menu, tḁmbium maiagekąri' nąnja pitja njąnu kaladadąru, wungulgunia kuda: umiimbaie wunenaiuru and jo:l' di dągu. ");
INSERT INTO wro_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Wuna darawa wąli puŋgąninja ardo:ri njiri nąnja pitja parandenuri, pitja njinbąrejo:ra pitja ąnbąranino:nuri dadjurdŋąrim maninja, bur kąrim maninja, njinbąraŋural ardenaiud' dąnja, mąnanąmbaraia nąnja ŋḁŋumba wunja. ");
INSERT INTO wro_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Umiimbaie pitja njḁniŋaienuri. ");
INSERT INTO wro_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Gewunja tjḁdąŋuru wurandju njidi:um maninja gewurle ni: pinjidiri arąŋundjo'lba; ");
INSERT INTO wro_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Gewunja ŋaiu pitja njinjano: njidjamundu a wuni:ndjaru, wuna nąnja ardauurgundjia njirkanąŋgaia ardarawaia kądjinba pitja parwelgen, kądjinba pitja pinjinbądjo:lbąn. ");
INSERT INTO wro_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Pitja njiraninowie njidenaiurgandu nąnja, ŋawawaia nąnja, njiri madeja nąnja, jḁligaia nąnja, atjąkekąria njiri nąnja pitja njinbąrandju njirkumbi:nu wunja. ");
INSERT INTO wro_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Pitja njiro:ndjurie ardarawaia nąnja ŋḁŋumba wunja. ");
INSERT INTO wro_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Tjąkąra tjḁruŋ njidbri: nąnja wa pitja debąd puŋgeŋąn. ");
INSERT INTO wro_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Njḁmula njirkunuŋ njirkandj pitja arem. ");
INSERT INTO wro_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","Wuno:murum mąra marąŋunbu Jerusalem wo:ri mąŋgauwi:na mąlaniŋąria nąnja, gejau laiburu njidu wuliŋgądba wodjulu mąŋgąnuŋ. ");
INSERT INTO wro_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Gejau arka Judaea nąnja ąŋgąnuŋ kubądaiinja tḁląmbąn ŋuru; arka puląga nąnja madjąndiwenja ŋuru, arka bundul' dąnja ąŋgąnuŋ dąra parengaliri ma nąnja. ");
INSERT INTO wro_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Gewunja wuna kunuŋ umalimaiejau, darawa wiri-wiri kauwi:na ko:rug kąmieŋu wunja. ");
INSERT INTO wro_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Wurgunu arka nąnja mąnduwanja ąŋgą-nuŋ, ŋamugu ąŋganbądo: gejau; wurgunu wunaiuru pitja njḁnu kabąlba nąnja, wundji:la worumba ąndja nąnja. ");
INSERT INTO wro_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Pitja arọwa kuldjuru iamundu nąnja, pitja araŋurie murd-murdkaia worumbaia ardarawaia ŋuru, Jerusalem pitja djąmbąba mejo:rie edbulia nąnja, ko:rug njḁmie njini lewąra edbulia arkanąŋga. ");
INSERT INTO wro_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","Umiimbaie pitja njąnu mąrąŋun' nąnja, kunjila nąnja, jalŋgąndąm maninja; kabąlba nąnja kuda: pakul ŋąri worumbaia nąnja, lia mąŋgadbaia pąląŋgąrinja wo:ndum auuba mąŋgo:. ");
INSERT INTO wro_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","I:dja ŋarwu ąŋgauwona luren kunja, kadidja wuna pitja njḁniŋaie bąndaia nanja; wundjurulu ąndjo:l' dąnja pitja djera-djera njḁniŋaie. ");
INSERT INTO wro_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Gejau pitja mąra irewu I:dj' iŋko:lu iŋgeŋgaliri ąŋgubąn nąnja wundjurul' dąnja pąlemba manaiudba nąnja. ");
INSERT INTO wro_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Wuna wunmanbąli kąniŋaieŋu, bal wurąm, njidbri: brai wuri:, gewunja umundulbaie njirkanąŋga wodjulu kunjąŋgaliri. ");
INSERT INTO wro_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Bḁre-bḁre kundjuŋąnąŋgori, Maranindj tjilium, ŋuwonu darawa kuda:; ");
INSERT INTO wro_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Wuno:murum gole la-la mąŋgąm, wuranindj, njiri ŋundju-ŋundju laiburu njiduŋ wodjulu tjauądba; ");
INSERT INTO wro_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Ge kądjinu njiri kuda:, mąra wurąŋunbu wuna ko:rug kąmieŋu, laiburu njidu bąndaia God anąŋga wodjulu kąnuŋ. ");
INSERT INTO wro_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Nidji kuŋenuri, Arkulieja ąndja pitja wa pareŋąn, darawa wąli ko:rug puŋgąmien. ");
INSERT INTO wro_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Ąndjo:lu, kabąlba pitja ejuŋurandu, ŋąla-ŋąla ŋaianąŋga pitja wa puŋgeŋan ŋuru. ");
INSERT INTO wro_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","Maranindj njiri ŋundju-ŋundju wunja, ŋąmba njirkulum kąlabu ŋąna pąmąniŋaie wungąlbąnda nąnja, djo: nąnja, wun' ŋąri wundjedjer kąri nąnja, gejau lewąra ge maiirgi:rkum puŋgeŋgalduri limbitja ŋąri kądjinu; ");
INSERT INTO wro_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Gewunja pitja njejeŋgal ardarawaia nąnja atją ąŋgąnuŋ mamiŋum kabąlba mararawam maninja. ");
INSERT INTO wro_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Barele njidu kądjinma, iraniau njidia ma wunja jąŋanai njirkumbąna wunja wuna darawa keŋgaliri, njirkumbąlgeŋu wunja imąnŋąle ŋuru I:dj' iŋko:lu. ");
INSERT INTO wro_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Kądjinma lewąra kaniingundaleri dadjurdŋąrim maninja, kądjinma wundugum dąnde keŋaŋuru, atją kąnina tḁląmbąn Oliva ŋąri nąnja. ");
INSERT INTO wro_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Peleŋgąraia ardarawaia aliŋąri kauerąmurkalal dadjurdŋąrim maninja aua ŋuru iŋgarkaŋuru wunja. ");
INSERT INTO wro_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Mąŋąrijau lo:jenda kunjąŋgunal maia iroroi, iŋgąrimiena Wukiau. ");
INSERT INTO wro_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Ardenaiuri dadjurdŋąria, wiri-wiri ŋąria kuda: kubąrkąnjiro:na ŋḁrunąngọwu iŋgadbalim wunja; peleŋgąraia ąŋganbąrkulgunaleri. ");
INSERT INTO wro_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Satan dąrąk keŋaŋuru Judas nąnja iŋgąrimiena Iscariot, aua iḁruŋ twelve, inalalaia nąnja iŋgąnina. ");
INSERT INTO wro_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Aua keŋaŋuru, kumbądeŋunąŋgori ardenaiuri dadjurdŋąria, ardenaiuri dadjurdŋąrim ŋąria kuda:, ŋḁrunąŋgọwu ąŋgąnino:nąŋga wunja. ");
INSERT INTO wro_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Arka tjukul kadina, tjauaien kubądjuŋąnḁŋga kaiug iŋgado: wunja. ");
INSERT INTO wro_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Aua korega kundjuŋu, kuŋąnjiro:na wuniama ąŋgąnino:nąŋga wunja peleŋgąraia adbidjaia. ");
INSERT INTO wro_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Lewara maia iroroi kunjąŋgunal gejau Wukiau iŋgarwuneda. ");
INSERT INTO wro_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Kaŋaŋawunandu Peter a John, kundjuŋiri, Njiriŋurandu, brar wuriandu Wukiau, ŋḁri mindjḁl kunja. ");
INSERT INTO wro_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Auandu kundjuŋąnąŋgandu, Ŋḁnam maninja Brar wuriandu kundji:njḁrendu? ");
INSERT INTO wro_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Aua kundjuŋąnąŋgandu, Wai, wuno:murum malaiinde' ŋuru njirkunjąŋurandu pitja njindją-mąndjerandu i:dja wuraua agu mano: iŋgaŋuru; irąmalando:wandu maiaru' ŋuru ma dąra iŋgeŋuru. ");
INSERT INTO wro_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Wuri:nąŋgandu inaiuri maiaru' ŋąra, Iniiŋgundeja kundjunu, Ŋḁnąm balaium, ma Wukiau mindjḁl ŋḁnŋundju ŋḁnalalaia nąnja? ");
INSERT INTO wro_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Aua pitja njinjąmiimbandu balaium manaiudba karąŋ ŋąrim mḁnamanjam; ma brar wuriandu. ");
INSERT INTO wro_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Keŋaŋurandu mąra ko:nandu kądjinu geŋunąŋgandu, brar kundjuŋandu Wukiau. ");
INSERT INTO wro_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Wuno:murum gole ko:rug kąmiena, atją kauwona, arkaŋawieja kuda: aua nąnja. ");
INSERT INTO wro_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Kundjuŋąnąŋgori, Djenbeŋuru mindjḁl ŋe kuŋeŋu wuna Wukiau njiri nąnja, wąli debąra pąŋeŋąn; ");
INSERT INTO wro_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Gewunja kuŋenuri, Kądjinba njele mindjḁl puŋen, ko:rug njḁmie njini bąndaia God anąŋga nąnja. ");
INSERT INTO wro_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Djo: ŋąra kąmąn, wunia kulula, kundjuŋu, Irąm, dalar wuri: njirge wurura; ");
INSERT INTO wro_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Gewunja kuŋenuri, Kądjinba djo: pąŋeŋąn njele kurab wuŋgalalidjerugu ŋąra, bąndaia God anaŋga keŋgal djini. ");
INSERT INTO wro_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Wuro:dbori kamḁŋ, wunia kulula, kḁlemḁla, kano:na, kundjuŋu, Indja kąnun ŋḁŋḁnąba iŋgąnauwi:ŋu njiri wunja; wuna wuri: ni: tjḁruŋungąŋuru wunja. ");
INSERT INTO wro_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Djo: ŋąra kuda: kądjindja pąlejau mindjḁl kadjuŋu, kundjuŋiri, Indja djo: ŋąra kąnuŋ tjauaien wuŋunąli gulu, ŋaianąŋga nąnja, pḁlulu kaniŋaiena njiri wunja. ");
INSERT INTO wro_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","O! Wai, ino:ri aua tjiriwin mąŋgo:wara ŋaiu nąnja pąlalo:nma nąnja kunuŋ. ");
INSERT INTO wro_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Mia, I:dj' iŋko:lu keŋaŋuriri, kądjinu kauwi:na aua wunja. O! wurgunu i:dja nąnja aua tjiriwin mąŋgo:ja. ");
INSERT INTO wro_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Arge wurura wunmanbąli burkeba kadjąbiena ąŋguja arka nąnja wuna geja. ");
INSERT INTO wro_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Ai karwiineri ąŋguja arka nąnja inaiuri iŋgąniŋaieŋu. ");
INSERT INTO wro_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Aua kundjuŋąnąŋgori, Ardenaiuri edbulia arkanąŋgaia ardjurulworaia kaduŋąnąŋgori, arka ardjurulba mąŋgąnuŋ kadimieŋu ardinieja. ");
INSERT INTO wro_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Wuna kądjinu njiri kari; O! aua inaiuri iŋgąnuŋ njiri nąnja kąninja iwomale kądjindja; aua iurulba mąŋgąnuŋ, inawodjieja kądjindja kąninja. ");
INSERT INTO wro_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Gewunja ąŋguja inaiud' ban dąga, aua atją iŋgauwona mąŋąri nąnja, aua iŋgąnawodjeri? Wawu pąŋgąnin aua atją ingauwona? O! ŋaiu njiri puląga nąnja ŋḁnun, kądjindja inawodjieja. ");
INSERT INTO wro_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Njiri njiduŋ atją njirkunina ŋaiu nąnja wuŋgundjuie ŋaianąŋga nąnja; ");
INSERT INTO wro_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Bąndaia ŋande njiri wunja, kądjinu Iraia ŋaianąŋga kandeŋu ŋaiu wunja, ");
INSERT INTO wro_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Mindjḁl wurąŋundju wunja, djo: njirkunjąŋa wunja, pąlalo:nma ŋaianąŋga nąnja bąndaia ŋaianąŋga nąnja, atja njirkumbąna wunja adbąlikąrim manŋenŋąlba nąnja, wure wurąŋunbimḁŋgori worumbaia ąnŋenŋąlja Israel ŋąria. ");
INSERT INTO wro_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Simon, Simon, wai, Satan Iŋąma kundjuŋąnu, djera-djera ŋunŋumbu wunja corn kądjindja; ");
INSERT INTO wro_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","O! Ŋaiu dadjurd kuŋeŋu ŋundju wunja, pąrąd ŋundjanąŋga ilura puŋuniri; ŋundju, wuno:murum kuluŋąn ŋunŋumbąna, ŋundju ŋawawaia birem-bire ąŋgandju. ");
INSERT INTO wro_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Aua kundjuŋąnąŋga, Inaiuri, ŋḁnamanja nąri ŋąnŋunjąŋaŋuru ŋundju nąnja bur kąrim ŋuru, debąra ŋarkunjąŋandu. ");
INSERT INTO wro_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Aua kundjuŋu, Kuŋenu, Peter, weni, punara wa pitja jero:l puŋgen, ŋundju wąli tjḁruŋuri pindjiin wa laiburu puŋuningąra. ");
INSERT INTO wro_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Kundjuŋąnąŋgori, Wuno:murum ŋaiu njinŋunjąŋaŋawuna bururu njido:ra, tjalumba njido:ra, njidjerdu ŋąria njido:ra, gejau njidąmiaru? Arka kubądjuŋ, Kari. ");
INSERT INTO wro_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Gejau kundjuŋąnąŋgori, O! weni, aua bururu kudai kuŋgaŋurinja, tjalumba kądjindja, aua kuldjuru ino:ra, wobi ko:l kundji:nja, kumarenja. ");
INSERT INTO wro_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Gewunja kuŋenuri, Wuna wiri-wiri kauwi:na madj ko:rug kumaienja ŋaiu nąnja, AUA KAUWI:NA ARWORIA NĄNJA; gewunja ŋaiu ŋąri umindju kudai. ");
INSERT INTO wro_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Kubądjuŋ, Inaiuri, wai, ŋuruma kuldjuru tjḁruŋandu. Kundjuŋąnąŋgori, Gole kunuŋ. ");
INSERT INTO wro_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Ba keŋgunal, keŋaŋuru kądjinu geŋirida tḁląmban ŋuru Oliva ŋąri; inalalaia kuda: kauerąmalando:na. ");
INSERT INTO wro_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Wuno:murum tḁmbiu' nąnja iŋgąnina kundjuŋąnaŋgori, Dadjurd wuri: pinjireŋuru wuŋgundjuie ŋuru. ");
INSERT INTO wro_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Kaŋuriena arka nąnja kądjinu kaiug tjuna workundju, luŋgudja kąnina, dadjurd kundjuŋu, ");
INSERT INTO wro_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","Kundjuŋiri, Iraia, ŋundju ŋąmba lai kauwonąnu, wuna djo: ŋąri tjḁno:ŋgu; O! kari ge lai kauwonara, lai kauwonąnu kuninja. ");
INSERT INTO wro_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Mąra kauwi:nanąŋga wąląnŋąra ąndjo:l' kąra, birem-bire kandjuna. ");
INSERT INTO wro_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Pąmbalọa kaŋuriena, wundjilwora dadjurd kundjuŋu; mąŋadjinja anąŋgąnja pin njinineri gulu: kądjinu do:ra njimbąneri kabąlba ŋuru. ");
INSERT INTO wro_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Bḁri iŋgąnina dadjurd geŋiri, inalalaia kanmurkalal, mąra kanbuna kulunu ąŋgąnineri pakul kunja. ");
INSERT INTO wro_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Kundjuŋanąŋgori, Ąŋudjakunja kulunu njiduŋiri? Bari njidu, dadjurd wuri: pinjireŋuru wuŋgundjuie ŋuru. ");
INSERT INTO wro_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Wąli kaluleri wai, peleŋgąre, aua kuda: Judas iŋgąrimiena, iḁruŋ twelve, inalalaia, nąnja, adbąnŋąle ŋuru keŋaŋuru, Jesu kąmąndjerala, ko:lbo:na. ");
INSERT INTO wro_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Jesu kundjuŋąnąŋga, Judas, I:dj' iŋko:lu tjiriwin mandjo:nąŋga tjḁnŋungulbo:? ");
INSERT INTO wro_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Arka wo:ri iŋgarwuneri mąra karwuna kubądjuŋ, Inaiuri, kanjḁrwu kuldjuru njiniŋge? ");
INSERT INTO wro_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Iḁruŋ arka nąnja ko:na inawodjieja inaiuri dadjurdŋąra anąŋga, ini:um worawerdu' ŋąrim dur mo:na. ");
INSERT INTO wro_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Jesu kąndjo:lbąla kundjuŋu, Ge njini kuninja wąli; ini:um mamąndanąla, kąmurduna. ");
INSERT INTO wro_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Gejau Jesu kundjuŋanąŋgori iŋgadburkalal ardenaiuri dadjurdŋąria, dadjurdnąrim ŋąria, mababaia, Njirkunjeŋgunal lulun ŋąra kądjinu, kuldjuru, diam njiri kudai? ");
INSERT INTO wro_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Tjile-jile ŋḁnŋunineri njiri nąnja dadjurdŋąrim maninja, njido:ri wa la pąmąrąmenjara; O! wuna njirkanąŋgajau, wundjurulu duiba ŋąri. ");
INSERT INTO wro_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Kauerąmąŋ, kauerielguruŋgula, kaueraŋurula maiaru' ŋuru inaiuri dadjurdŋąra anąŋgam; Peter kuda: bọwora kąmalando:na. ");
INSERT INTO wro_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Wuno:murum wiḁnu karkuguleŋu puląga maiarum maninja, kurug ąŋgąnina, Peter atja kauwona puląga nąnja. ");
INSERT INTO wro_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Njimbąridja ndjḁruŋ mąra iŋgo:na atjḁ iŋgąnineri marąma nąnja, njḁdba kąnindjąŋa, kundjuŋu, Indja kuda: aua nąnja kąnina. ");
INSERT INTO wro_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Aua kari kundjuŋu, kundjuŋiri, Woŋaiinja, wa laiburu pąŋąninnąŋga. ");
INSERT INTO wro_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Wąli pąlejau iąkąra mąra ko:na, kulula, Ŋundju kuda: arka nąnja ŋuŋuŋ. O! Peter kundjuŋu, I:dja, wa pąŋąnin. ");
INSERT INTO wro_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Wąli pąlejau, iąkara njḁdbama kundjuŋu, Nidji indja kuda: aua nanja kąnina, Galilee ŋara iŋganuŋ. ");
INSERT INTO wro_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Peter kundjuŋu, I:dja wa laiburu pąŋąnin tjuŋunjalu. Maiirgi:rkum, wąli kaluleri, punara jero:l kundjuŋu. ");
INSERT INTO wro_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Gejau Inaiuri wararkar kąnina, Peter kąnindjąŋa. Peter ni: kuŋgaŋurula ŋąla-ŋąla Inaiuri anąŋga, kądjinu geŋunąŋga, Punara wąli jero:l puŋgen, weni tjḁruŋuri kari djejara. ");
INSERT INTO wro_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Dąnde keŋaŋuru, njḁdba wola: kundjuŋiri. ");
INSERT INTO wro_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","I:dja aua iŋgadbąŋ umbili kauerąmąŋ, wodpiliba kauerio:rala. ");
INSERT INTO wro_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Imąndjugu womburuk kubąri:la, burkai kaueriąbuna, kubądjuŋiri, Tjo:lba minjalu, ąŋguja ŋunŋumbuna? ");
INSERT INTO wro_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Darawa tjąkąri wodbandągu kubądjuŋąnąŋga. ");
INSERT INTO wro_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Wuno:murum lei mąŋgo:na, mababaia i:dja nąnja djḁruk kadbiena, ardenaiuri dadjurdŋąria, wiri-wiri ŋąria kuda:, kaielwa kaueraŋurula karwądeŋąrim ŋuru. ");
INSERT INTO wro_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Kubądjuniri, Ŋundju Christ ŋąmba ŋunŋunun, minjenjḁri. Aua kundjuŋąnąŋgori, Ŋaiu ŋąmba ŋḁnŋundjunuri, pitja dja pąnjḁrąŋudjara, ");
INSERT INTO wro_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Namba burkai njinŋundjąb, kądjinba pąnjḁrio:lbąn. ");
INSERT INTO wro_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Wendj-i-dągu I:dj' iŋko:lu pitja atja ewa worawerdum maninja wundjurulu God anąŋga nąnja. ");
INSERT INTO wro_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Ardarawaia kubądjuŋ, Ŋundju God ŋunŋungula? Aua kundjuŋąnąŋgori, Njiri kuri: ŋḁnŋunuŋ. ");
INSERT INTO wro_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Arka kubądjuŋ. Aŋudja piri adąŋądjaieja ąŋąma wodju? Ŋḁri ŋundju-ŋundju ŋuru karkaŋurula iamundu nąnja. ");
INSERT INTO wro_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Arka ardarawaia bḁri kadina, kaueraŋurula Pilate ŋuru. ");
INSERT INTO wro_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Wunmanbąli de kauero:na, kubądjuŋiri, Indja mąra kerwuna worumba arkanąŋga arkolikolia ąŋgandjuna, kąre ko:nanąŋgori kaiug iŋgado: wunja Caesar, geŋiri aua ŋundju-ŋundju Christ inaiuri iŋgąnuŋ. ");
INSERT INTO wro_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Pilate burkai kaiąbuna, kundjuŋiri, Ŋundju ŋunaiuru Jew ŋąria arkanąŋga? Aua kaio:lbąla, kundjuŋu, Ŋundju kundjaluiri. ");
INSERT INTO wro_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Pilate kundjuŋąnąŋgori ardenaiuri dadjurdŋąria, peleŋgąraia kuda:, I:dja indja nḁnja worn kari wa mąra puŋo:n. ");
INSERT INTO wro_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Arka njḁdbama kubądjuŋ, Peleŋgąraia kanŋąndjeru, kaniiŋgunderi Judaea mararawam maninja, Galilee maiaŋuru i dągam ŋuru njini. ");
INSERT INTO wro_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Pilate ŋuru iŋgąnina, burkai kandjąbuna i:dja ŋąmba Galilee ŋąra iŋgąnuŋ. ");
INSERT INTO wro_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Laiburu iŋgąnina aua Herod ŋąrim waia iŋgąnina, kaŋaŋawuna Herod ŋuru, aua gejau Jerusalem maninja iŋgąnina. ");
INSERT INTO wro_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Wuno:murum Herod Jesu iŋgąnindjąŋa, djenbeŋuru tjukul kąnina; gewunja maranu lai kauwonanąŋga iŋgąnindja wunja, ŋuru iŋgąnina aua wunja, ini:u' ŋąra kąnina umiimbaie kąnindja wunja aua nąnja kąniŋaiena. ");
INSERT INTO wro_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Burkai kaiąbuna ŋąla-ŋąla darawa nąnja; O! aua kari wa pąŋgaio:lbenja. ");
INSERT INTO wro_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Ardenaiuri dadjurdŋąria, wiri-wiri ŋąria kuda:, karwelgenja, njḁdbama de kauero:na. ");
INSERT INTO wro_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Herod mąląniŋąria anąŋgaia kuda: iluk kauerąmąŋ, umbili kauerąmąŋ, wobi pąlemba ŋąra tai kaueri:la, tjile kąŋaŋawuna Pilate ŋuru. ");
INSERT INTO wro_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Ge i di dągu Herod a Pilate, aue wururandujḁligaiandu kąniŋaienandu; auurlejandu inauurgun-gąndu. ");
INSERT INTO wro_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Pilate naia kanmąŋ ardenaiuri dadjurd ŋąria, ardenaiuri peleŋgąraia kuda:, ");
INSERT INTO wro_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","Kundjuŋąnąŋgori, I:dja indja kąraŋurulalgąra kądjindja iḁruŋ peleŋgąraia ąŋgąŋąndjeru, wai, ŋaiu njidbąnŋąle ŋuru aua burkai kąŋaiabuna, kari wa mąra puŋo:nja i:dja indja nąnja, ge njiri de irąŋunbu. ");
INSERT INTO wro_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Kari Herod kuda:; gewunja kąŋaŋawunalgąri njele, wai, kari debḁd' kḁri wa pungauwi:nanąŋga. ");
INSERT INTO wro_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Wodpiliba iŋaio:ra, burąŋgai iŋąm. ");
INSERT INTO wro_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Burąŋgai kąmenjanąŋgori iḁruŋ mąŋąrijau. ");
INSERT INTO wro_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Arka jero:l kubądjuŋ tjḁruŋama, Aŋuru, burąŋgai imanjḁri Barabbas; ");
INSERT INTO wro_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Aua wurgunu tjḁruŋ wunja malaiindem maninja kąniŋaiena, wurkemąn' kunja, iŋgaiąbiena bur kąrim maninja. ");
INSERT INTO wro_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Pilate njele kundjuŋąnąŋgori, korega geŋu Jesu burąŋgai wunja. ");
INSERT INTO wro_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","O! arka jero:l kubḁdjun, kubąlula, Wongaia nąnja ande. ");
INSERT INTO wro_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Tjḁruŋuri kundjuŋąnąŋgori, Ąŋudjakunja, ŋḁnąŋga woru indja kundjuŋu? Ŋaiu wa mąra puŋo:nja kari debąd' kąri aua nąnja; gewunja wodpiliba iŋaio:ra, burąŋgai iŋąm. ");
INSERT INTO wro_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Arka njḁdbama, ŋąla-ŋąla daraiu njiniŋge, burkai kaueriąbuna wongaia nąnja iŋgande wunja, gejau ŋąla-ŋąla arkanąŋga puluru ki:la. ");
INSERT INTO wro_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Gejau Pilate wure kumbuna kuninja kądjinu burkai iŋgadjąbuna. ");
INSERT INTO wro_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Burąŋgai kąmąŋąnąŋgori aua wurgunu wunja, wurkemąn' kunja, iŋgaiąbiena bur kąrim maninja, aua iŋgadiauwuna, O! Jesu kanino:la lai kauwonąnąŋgori wunja. ");
INSERT INTO wro_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Wąli iŋgadjelguruŋgula, laburd kauerąmąŋ Simon Cyrene ŋąra, iŋgeŋgunaliri bundul' ḁlp, aua nąnja wongaia kubḁrkandeŋu, mano: wunja Jesu iwelbam. ");
INSERT INTO wro_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Kauerąmalando:na peleŋgąraia djenbeŋuru i:dja, woŋaia kuda:, arka wola: kubądjuŋiri, kaueraremaleri, ");
INSERT INTO wro_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Jesu wararkar kanmurkąla kundjuŋu, Pąmąmaraia Jerusale' ŋąria, wola: piriareri; wola: wuri: njiri ŋundju-ŋundju wunja, woŋąlaląŋuja njirkąnąŋgaia wunja. ");
INSERT INTO wro_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Gewunja, wai, lewąra pitja njejeŋgal wuno: murum pitja bąre, Tjukul ŋąria njąŋgąngundia, arkulum kądjinba bḁri padjąndienja, ŋamugu kądjinba panbądo:nja. ");
INSERT INTO wro_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Gejau pitja bąrenąŋgori tḁleląmbąn, Njirwa ḁri nanja; kurorandu, Ro:k wuri:njḁri. ");
INSERT INTO wro_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Gewunja wuna ŋąmba kadju ŋuwonu kalguru nąnja, ŋḁnąŋga pitja njḁniŋaie dalga nąnja? ");
INSERT INTO wro_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Kaielguruŋgienandu kuda: iḁruŋandu iwaworkandu aua nąnja iŋgauwi:ŋandu wunja. ");
INSERT INTO wro_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Gejau madburkąla tḁmbium maŋgąrimiena Pąndjuŋąrim, ma wongaia nąnja kauerandeŋu iwaworkandu kuda:, iąkąra worawerdum maninja, iakąra mamauim maninja. ");
INSERT INTO wro_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Gejau Jesu kundjuŋu, Iraia, wai tjąbunąŋgori; gewunja wa laiburu padin ŋąni kadjiri. Wobi anąŋga arge wurura dalar kubądjuŋ, kauerąmurąŋeri. ");
INSERT INTO wro_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Peleŋgąraia karwelgenja kaueranindjąŋeri. Ardenaiuri kuda: umbili kauerąmąŋeri, kubądjuŋ, Atjąkekąria kanmundulbąla, aue ŋundju-ŋundju kąmundulbaienja, indja ŋąmba iŋgąnuŋ Christ, iŋgąmuriena God anąŋga. ");
INSERT INTO wro_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Mąlani' ŋąria kuda: umbili kauerąmąŋeri, kauerąmurkalaleri, vinegar kąno:na, ");
INSERT INTO wro_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","Kubądjuŋiri, Ŋundju ŋąmba ŋunŋunuŋ Jew ŋąria inaiuri arkanąŋga, pamundulbaie. ");
INSERT INTO wro_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Wiri-wiri kuda: kuniŋaiena aua nąnja, INDJA INAIURI JEW ŊĄRIA ARKANĄŊGA.' ");
INSERT INTO wro_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Iḁruŋ iwaworkandu iŋgalienjandu kąŋujo:na, Ŋundju wawu Christ puŋunin? Ŋunge ŋundju-ŋundju pąmundulbaie, ḁrendu kuda:. ");
INSERT INTO wro_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Iąkąra kaio:lbąla kamaiḁmbuna, kundjuŋiri, Ŋundju wawu God puŋungulgunen, wure nąnja wundji-di-dągu ŋunŋunuŋ? ");
INSERT INTO wro_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Ŋḁrendu kuda: wuniama, gewunja wodbandu kądjinu workundjuŋandu; O! indja kari woru wa puŋgenja. ");
INSERT INTO wro_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Kundjuŋąnąŋga, Jesu, ni: tjḁngąŋuru wuno:murum ŋunŋunjąŋa bąndaia ŋundjanąŋga nąnja. ");
INSERT INTO wro_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Aua kundjuŋąnąŋga, Nidji kuŋenu, weni pitja ŋunjąnu ŋaiu nąnja Paradisa nąnja. ");
INSERT INTO wro_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Lewąra njinina, duiba maniŋaiena kabąlba mararawam maninja kąle-kąle' njinim, ");
INSERT INTO wro_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Mąrąŋunja duiba ŋąrinja njiniŋaiena, jarąla dadjurd ŋąrim maninja dalar kąniŋaiena puląga nąnja. ");
INSERT INTO wro_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Ŋąla-ŋąla daraiu jero:l kundjuŋu Jesu kulula, Iraia, ŋuno:ri nąnja ŋunino: ŋḁŋandj. Wuna kalula, iŋandj wudi keŋa. ");
INSERT INTO wro_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Centurion mąra ko:na wuna kąniŋaiena, God ko:do:dala, kundjuŋiri, Nidji i:dja indja iḁdąŋuru kąnina. ");
INSERT INTO wro_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Peleŋgąraia ardarawaia djaruk aŋgąmiena wuna kadidja wunja, wuno:murum kadidjąna wuna kąniŋaiena, adbąnŋąlim deba marwuna, djo:li kadinal. ");
INSERT INTO wro_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Laiburia ardarawaia anąŋgaia bọwora karwelgenjiri, woŋaia kuda: iŋgadbalando:na Galilee alp, wuna kubądidjąŋeri. ");
INSERT INTO wro_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Wai, i:dja iŋumba Joseph, kauadeja, i:dja inia, iḁdąŋuru, ");
INSERT INTO wro_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","Aua wa panmurkenja arka kalula, kadjuŋu, Arimathaea ŋąra, malaiindem Judaea nąnja, aua kunanąla bąndaia God anąŋga, ");
INSERT INTO wro_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Aia kąmurkąlaŋuru Pilate, kąniauwuna durgu Jesu. ");
INSERT INTO wro_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Jeri kaiąbuna, murd kąmąŋ wobi imąlala njiniŋge, kandeŋu kąnmenma nąnja kaiug nąnja dur mąŋgauwi:na, ma nąnja wąli i:dja kari wa we parwenja. ");
INSERT INTO wro_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Lewąra ge Ardamanjajau, Wunaiurujau wodjulu kuninaleri. ");
INSERT INTO wro_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Woŋaia kuda: kauerąmalando:na, aua nąnja ąŋgeŋgunaliri Galilee ḁlp, kąnmenma mąra marwuna, ŋḁrunąŋgọwu durgu kandiena. ");
INSERT INTO wro_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Djo:li kadinal, ardamanja kanbąrkandjuna arkąnim manieja, ąŋgaiamie ŋąria. ");
INSERT INTO wro_vpl VALUES ("LK23_57","072_23_57","LUK","23","57","57","Wunaiurujau ŋoiba kadina, ŋąla-ŋąla nąnja. ");
INSERT INTO wro_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Lewąra gewurle pąle Wunaiurujau, aliŋąri mąmąŋgunu, kąnmenma madburkalal, markaŋurulal arkąnim manieja mḁnamanja mąŋgarkandjuna. ");
INSERT INTO wro_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Mąra kubąrwuna kaiug ruluba kaŋuriena kąnmendj-i-dągu. ");
INSERT INTO wro_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Dąra kariŋa, wa mąra puŋgarwi:nja durgu Jesu Inaiuri anąŋga. ");
INSERT INTO wro_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Ge kunina, wąli ardi:um idjedja njiŋgąnineri wuna wunja, wai i:dja iḁruŋandu kauwelgenjandu arka nąnja wobi pąlemba ŋąra nąnja; ");
INSERT INTO wro_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Arka karkulgunenja, idjidja kubądbaŋ arbiŋum kabąl' kuru, auandu kundjuŋandu, Ąŋudjakunja kąrąŋąnjiro:jiri iedjer adbąn nanja? ");
INSERT INTO wro_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Ŋuruma wa pąŋgąnin. O! bḁri kąnina. Ni: wuraŋuru kalulanuri wąli Galilee nąnja iŋgąnineri, ");
INSERT INTO wro_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","Geŋiri, I:dj' iŋko:lu madj kḁnauwi:nja i:dja arworia ardo:ri nąnja, wongaia nąnja kandienja, pąle kulunu tjḁruŋandu bḁri kąninja. ");
INSERT INTO wro_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Arka ni: kubąrkaŋurulanąaŋga ŋąla-ŋąla anąŋga, ");
INSERT INTO wro_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Djo:li kadinal kąnmenm' ḁlp, darawa wuna kubądjuŋąnąŋgori eleven, inalalaia, atjąkekąria ardarawaią kuda. ");
INSERT INTO wro_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Arge kąninuri Mary Magdalena, Joanna, Mary James anąŋgąnja, atjąkekąria kuda: arka nąnja wuna kubądjuŋanąŋgori arkaŋawieja. ");
INSERT INTO wro_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Ŋąla-ŋąla wuna mąra kumbi:nanąŋgori woŋąla kadjinu, arka dja kubąrkudjarala. ");
INSERT INTO wro_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","O! Peter bḁri kąnina, tjḁri kumąnaŋuru kąnmen' ŋuru; ilu kąnina, mąra ko:na wobi ekamandj; keŋaŋuru, ini:ąkamanma rąngąri keŋa wuna tjąnda kąmiena. ");
INSERT INTO wro_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Gejau, wai, iḁruŋandu arka nąnja lewara ge-i-di-dągu keŋaŋurandiri maiarundjeruŋu' ŋuru wodjulu Jerusale' nąnja, maŋumba Emmaus. ");
INSERT INTO wro_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Kululandiri aue wururandu wuna darawa tjumąn kąmiena. ");
INSERT INTO wro_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Ge kunina, wąli kalulandiri, burkeba iŋgaiąbienandiri, Jesu mandja kąmurkalalgąndu, auandu nąnja keŋo:ri. ");
INSERT INTO wro_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","O! ambulkandu djiḁn kumienandu aua wa laiburu pąŋgąninjanąŋgandu. ");
INSERT INTO wro_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Aua kundjuŋąnąŋgandu, Ŋḁnąŋga wuna ŋąla-ŋąla ai njirkumbi:ŋandiri njirkunjąŋaŋurandiri? Auandu pindi-windi kauwelgenjandu. ");
INSERT INTO wro_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Iąkąra kaio:lbąla, iŋumba Cleopas, kundjuŋąnąŋga, Ŋundju edbulwu Jerusale' nąnja, wawu laiburu puŋunindjiri wuna tjumąn kąmiena ma nąnja wendjiau? ");
INSERT INTO wro_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Aua kundjuŋąnąŋgandu, Ŋḁnąŋga? Auandu kundjuŋąnąŋgandu, Jesu Nazareth ŋąra wunja, aua iŋgąnina i:dja tjo:lbąda, iurulba kudai geŋu, kalula, God imąnŋąle ŋuru, i:dja ardarawaia kuda:; ");
INSERT INTO wro_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Ardenaiuri dadjurd ŋąria, ardenaiuri ararkanąŋgaia, ąŋganbądino:nąŋga wure nąnja debąr' kunja, wongaia nąnja iŋgarkandeŋu. ");
INSERT INTO wro_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","O! ari ardi:u' ŋąria ḁdina aua pitja ąnjąmundulba Israel; weni kuda: lewąra tjḁruŋuri wuna tjumąn kąmiena. ");
INSERT INTO wro_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Woŋaia atjąkekąria kuda: ḁri nąnja rąngąri ąnbąrkąndjuna, arka aliŋąri kąnmenma nąnja ąŋgąnina; ");
INSERT INTO wro_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","Durgu anąŋga wa mąra puŋgarwi:nja, kariŋgunal kubądjuŋiri ardidjieja wąląnŋąria ąŋganbądidjąŋa, arka kadjuŋu aua iedjer iŋgąnuŋ. ");
INSERT INTO wro_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Atjąkekąria kuda: ḁri nąnja kąnmen' ŋuru madburkąlaŋuru, mąra kubąrwuna kądjinu woŋaia kadjuŋu; aua wa mąra pauero:nja. ");
INSERT INTO wro_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Gejau aua kundjuŋąnąŋgandu, O woŋąla, njirkulum tjanąnba ŋąri wurąŋunŋudjara darawa tjo:lbądaia kadjuŋu. ");
INSERT INTO wro_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Wawu Christ wuna ko:ru puŋgenja, iŋgeŋaŋuru pąlemba ŋuru anąŋgąm? ");
INSERT INTO wro_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Gejau Moses auurle tjo:lbądaia ardarawaia njini, kąmiimbunandu mili-mili irarawa nąnja wuna aua ŋundju-ŋundju wunja. ");
INSERT INTO wro_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Gejau mąmurkalalkuri maiarundjeruŋuma ma ŋuru iŋgeŋaŋuririŋguri, aua kundjuŋu ingenaŋuriri njele. ");
INSERT INTO wro_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Auandu wore kąmąŋandu, kundjuŋandu, Atją bąnu ḁrendu ąanja, Kąle-kąlem njiŋgąnuŋ, mąrąŋunja gole we njimbąneri. Dąra keŋaŋuru atją wunja auandu nąnja. ");
INSERT INTO wro_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Ge kunina, wuno:murum atją iŋgauwona, auandu nąnja, wuro:dbori kąmąŋ, wunia kulula, dewod ko:na, kąno:nandu. ");
INSERT INTO wro_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Gejau ambulkandu tjalan kumbunandu, laiburu kąninanąŋgandu; aua kąmburuk kąnina auandu nąnja. ");
INSERT INTO wro_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Aue ŋundju-ŋundjandu kąni:nandu, Wawu ŋarkulandum mąra-mąra pąmąninjandu ŋąrendu nąnja, wąli geŋuŋḁrendiri kalumba nąnja, wąli ŋarkumiimbunandu mili-mili? ");
INSERT INTO wro_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Ge-i-di-dągu bḁri kąninandu, djo:li kąninalgąndu Jerusale' nąnja, mąra kanbunandu eleven, inalalaia, djaruk ąŋgąmiena, atjąkekąria kuda: arka nąnja, ");
INSERT INTO wro_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Kubądjuŋiri, Inaiuri nidji bḁri kąnina, mąra kauwi:nanąŋga Simon. ");
INSERT INTO wro_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Gejau auandu kundjuŋandu wuna kalumba nąnja, ŋḁrunąŋgọwu aua laiburu iŋgąni:nanąŋgandu wuro:dbori dewod iŋganaleri. ");
INSERT INTO wro_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Wuna wąli kadjuŋiri, Jesu aua ŋundju-ŋundju kauwelgenja arka puląga nąnja, kundjunąnąŋgori, Abi:la kuninjanuri. ");
INSERT INTO wro_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Arka luren kubądbąŋ, karkulgunenja, iŋan' ŋali kubądjuŋ mąra iŋgarwuna. ");
INSERT INTO wro_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Aua kundjuŋąnąŋgori, Ąŋudjakunja djerara mąrąmeri, ąŋudjakunja njidi:akamanma kuriiri? ");
INSERT INTO wro_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Ŋḁno:ri, ŋaierdu, wuranindj, ŋaiąkawḁli ŋaiu ŋundju-ŋundju; tjḁrąmąndana, tjḁrąnindj, gewunja iŋandj iwiliri, inari ino-ra, kądjinu tḁarąŋunindj ŋaiu kudai ŋḁnŋunuŋ. ");
INSERT INTO wro_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Wuna geŋu kanmiimbuna ino:ri, ierdu. ");
INSERT INTO wro_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Arka wąli karkudjarala gewunja tjukul ąŋgąnina, rąngąri ąŋgeŋa, aua kundjuŋąnąŋgori, Njiri mąŋąri kudawu? ");
INSERT INTO wro_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Kauerano:na djaia iwidjḁra. ");
INSERT INTO wro_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Aua kąmąŋ, adbąnŋąle ŋuru mindjal kundjunu. ");
INSERT INTO wro_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Gejau kundjuŋąnąŋgori, Wuna ŋąla-ŋąla ŋḁnŋundjuŋanuri wąli njiri nąnja ŋḁnŋunineri, ko:rug kumaienja darawa wiri-wiri kauwi:na ŋąla-ŋąla Moses anąŋga nąnja, tjo:lbądaia nąnja kuda:, kan nanja kuda:, ŋaiu wunja. ");
INSERT INTO wro_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Gejau ardi:um pąlkḁr mamurąŋąnąŋgori mili-mili iŋgadena wunja; ");
INSERT INTO wro_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Kundjuŋąnąŋgori, Wurunąŋgowu wiri-wiri kumbi:na Christ madj puŋgenja, bḁri kaiąndienja imąndj i dągu lewąra tjḁruŋuri jau. ");
INSERT INTO wro_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Kuląŋąn ardi:um kuluienja iŋumba nąnja umąra wai kunja worumbaia ardarawaia nąnja, Jerusalem maninja mauurlem. ");
INSERT INTO wro_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Wuna nąnja njidąŋądjaieja. ");
INSERT INTO wro_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Wai, kuŋaŋaŋawunuri tjauaien ŋaiu Iraia anąŋga; atja njidu manaiudba nąnja wurąŋunma njini wundjurulu karąŋ i dągu. ");
INSERT INTO wro_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Kangaŋurulaŋuru dąnde ŋuru Bethany njini, ino:ri la mamąŋąnąŋgori, pąli kanbuna. ");
INSERT INTO wro_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Ge kunina, wąli pąli ąŋgo:neri, kąno:ŋgienanąŋgori, mano: kaŋuriena ąnd jo:l' kuru. ");
INSERT INTO wro_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Arka luŋgu-luŋgudja kabądbąŋąnąŋga, Jerusalem maninja djo:li kadinal, tjukul djenbeŋuru kadina. ");
INSERT INTO wro_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Kądjinma kadineri dadjurdŋąrim maninja, God kauero:do:daleri. ");
ALTER TABLE wro_vpl ADD FULLTEXT(verseText);
UNLOCK TABLES;
