﻿USE sofia;
DROP TABLE IF EXISTS sofia.wrk_vpl;
CREATE TABLE wrk_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES wrk_vpl WRITE;
INSERT INTO wrk_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Ngayu Madiyu, ngayu karungka narrinya nangangi Jisus Krayiskanyi. Ngala waluku barri jangayu nijarrijba yalunya, nanganginmuku miminganjamuku wankalamuku jali jungku wabula, juju waluwa nangandu Jisus Krayisnyina. Nanda wankalanyi nganinyi Yabrayam, nyuli jungku barrinani wankalanyi miminganja nangangi Dayibidkanyi, baki nanda Dayibid, nyuli jungku barrinani wankalanyi miminganja nangangi Jisus Krayiskanyi. ");
INSERT INTO wrk_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","6a","Nanda wankalanyi Yabrayam, nangangi jandanyi nganinyi niji nangangi Yayisak. Baki Yayisak barri, nangangi jandanyi nganinyi niji nangangi Jakub. Baki nanda Jakub, kajamuku nanganginmuku jandanyimuku nganinyimuku, ngala yingamali nangangi niji Juda. Baki nanda Juda, nangangi maninganja, niji barri Tamarr, kujarra bulangi jandanyiwuya nganinyiwuya, niji bulangi Biris, baki Sira. Baki nanda Biris, nangangi jandanyi nganinyi, niji nangangi Yisrun. Baki nanda Yisrun barri, nangangi jandanyi nganinyi, niji nangangi Ram. Baki nanda Ram, nangangi jandanyi nganinyi, niji nangangi Yaminadab. Baki nanda Yaminadab, nangangi jandanyi nganinyi niji nangangi Najun. Baki nanda Najun barri, nangangi jandanyi nganinyi niji nangangi Salmun barri. Baki nanda Salmun barri, maninganja nangangi niji Rayab. Bulangi jandanyi nganinyi, niji nangangi Buwas. Baki nanda Buwas, nangangi maninganja barri, niji nangangi Rud, baki bulangi jandanyi nganinyi barri niji nangangi Yubid. Baki nanda Yubid jandanyi nganinyi barri, nangangi niji Jisi. Baki nanda Jisi, nangangi jandanyi nganinyi, niji nangangi Dayibid barri. Nanda Dayibid, nyuli walkurra mambuka nanganginmukuyngka mungkijimukuyngka Jumukuyngka. Maruka nyuli muwa nangangi Kudkanyi. Kudanyu nyuli durrijba nanda jangkurr nangangi Kudkanyi. Jungku nyuli yurlurrmba nangangi barri. Nani barri yali jungku nanamuku wankalamuku. Barriwa. ");
INSERT INTO wrk_vpl VALUES ("MT1_6b","070_1_6b","MAT","1","6b","11","Baki nanda Dayibid, nangangi maninganja, niji nangangi Bajiba. Nanda jibarri Bajiba, nanda waluwinyi nawinganja nangangi, niji nangangi Yuraya, ngala kuyuyi jibarri Dayibidwanyi jali nangka janyba nanda waluwinyi nawinganja nangangi. Nanda Dayibid, nangangi jandanyi nganinyi, niji nangangi Sulumun. Baki nanda Sulumun, nangangi jandanyi nganinyi, niji nangangi Riyubuwam. Baki nanda Riyubuwam, nangangi jandanyi nganinyi, niji nangangi Yabija. Baki nanda Yabija barri, nangangi jandanyi nganinyi, niji nangangi Yasa. Baki nanda Yasa, nangangi jandanyi nganinyi, niji nangangi Jiyusabad. Baki nanda barri Jiyusabad, nangangi jandanyi nganinyi, niji nangangi Jiyuram. Baki nanda barri Jiyuram, nangangi jandanyi nganinyi, niji nangangi Yusiya. Baki nanda barri Yusiya, nangangi jandanyi nganinyi, niji nangangi Judam. Baki nanda barri Judam, nangangi jandanyi nganinyi, niji nangangi Yayas. Baki nanda barri Yayas, nangangi jandanyi nganinyi, niji nangangi Yisikiya. Baki nanda barri Yisikiya, nangangi jandanyi nganinyi, niji nangangi Manasa. Baki nanda barri Manasa, nangangi jandanyi nganinyi, niji nangangi Yamun. Baki nanda barri Yamun, nangangi jandanyi nganinyi, niji nangangi Jusiya. Baki nanda barri Jusiya, jandanyimuku nangangi nganinyimuku, yingamali nangangi niji Jiyuyakin. Nani barri yali jungku nanamuku wankalamuku. Barriwa. ");
INSERT INTO wrk_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","16","Nanamanji barri jali jungku Jiyuyakin walkurra mambuka yalungi Jumukuyngka, baki yingka nyuli walkurra mambuka yalungi jalili yalu jungku yingkana yajina juju karru. Nanangini yingkawanyi nyuli daba yalunya Jumuku. Daba nyuli wakara, baki kuyu nyuli yalunya nanganginkurri yajiyurri, juju karru, niji Babilun. Marrimba nyuli yalunya nanganginyina yajina yurrngumba barri, baki janyba yalungki kudiyamuku. Ngala baku barri juju nanamuku yingkamuku yali wijba bayungu yalunginkurri yajiyurri. Nanda Jiyuyakin, nangangi jandanyi nganinyi, niji nangangi Jiyaldil. Baki nanda barri Jiyaldil, nangangi jandanyi nganinyi, niji nangangi Sirubabil. Baki nanda barri Sirubabil, nangangi jandanyi nganinyi, niji nangangi Yabiyud. Baki nanda barri Yabiyud, nangangi jandanyi nganinyi, niji nangangi Yiliyakim. Baki nanda barri Yiliyakim, nangangi jandanyi nganinyi, niji nangangi Yasurr. Baki nanda barri Yasurr, nangangi jandanyi nganinyi, niji nangangi Saduk. Baki nanda barri Saduk, nangangi jandanyi nganinyi, niji nangangi Yajim. Baki nanda barri Yajim, nangangi jandanyi nganinyi, niji nangangi Yiliyud. Baki nanda barri Yiliyud, nangangi jandanyi nganinyi, niji nangangi Yiliyasarr. Baki nanda barri Yiliyasarr, nangangi jandanyi nganinyi, niji nangangi Madan. Baki nanda Madan, nangangi jandanyi nganinyi, niji nangangi Jakub. Baki nanda barri Jakub, nangangi jandanyi, niji nangangi Jusib. Nanda barri Jusib, nyuli nawinganja nanankanyi jibarrinyi, niji Mari, jali ngardanganja nangangi Jisuskanyi. Nanda Jisus, yingka niji nangangi Krayis, barrinani “nanda jali yarrijba Kudwanyi wankambawarr.” ");
INSERT INTO wrk_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Nani barri yali jungku nanamuku wankalamuku yurrngumba nanankurri jali nangka binandaba Mari bardardanyi Jisus Krayiskanyi. ");
INSERT INTO wrk_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Nanda wurrumbarra, niji Mari, nyuli wulanbi nangangi Jusibkanyi. Waluwa buli jungku maykarra, baki ngawukuku nyuli nanda wurrumbarra, ngala miku nyuliyanyi kuluka yingkana nganinyina. Manjijbayi Kudwanyi nangangi Kunyba Ngarndu nangandurri wurrumbarrayurri, baki nanankardi nyuli ngawukuku. ");
INSERT INTO wrk_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Nanda nganinyi Jusib, nyuli kunyba nganinyi. Jungku nyuli kunybana nananyina yuwana Musiskanyi. Nanda yuwa yanybaka nayi. Jaliyi yingkawanyi yabimba jibarri ngawukuku, jala waluwa nyulu nawinganjayudi, baki nanda balki. Nyulu jungkuka balkina yuwana nanda jibarri. Nanangini nganinyiwanyi marda nyulimi karu yingkamuku nanganginkanyi wulanbinyi, baki janyulu manyirru nanda jibarri. Nani barri nanda yuwa yanybaka. Nanda barri Jusib, ngamu kulukayi nangangi wulanbi Mari yingkana nganinyina. Ngala kunyba nyuli. Miku nyuliyanyi nulijba manyirrumbikanyi nanda wurrumbarra yalungi. Miku nyuliyanyi nulijba yabimbikanyi kiji nangangi. Baki nanankardi barri mankumanku nangki Jusib, miku janyulu kuyu Mari nanganginkanyi maninganjanyi, ngala kardarda barri janyulu manjijba nanganbunanyi. Miku nyuliyi mili nangangi wulanbi. Barriwa. ");
INSERT INTO wrk_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Ngala mankumanku nangki Jusib nani barri, baki manjijba Yanjil nangandurri Kudwanyi. Buwarrajimbayi yaji Jusibwanyi, baki najba nyuli Yanjil jali yanyba nangangi. “Ninji Jusib, ngani wankalanyi nijanganjinyi, nangangi niji Dayibid. Mikujiyi marrala yajinyi. Marda ninjimi kuyu nanda wurrumbarra Mari nganyingkanyi maninganjanyi. Ngawukuku nyulu, ngala miku nyuliya kuluka yingkana nganinyina, miku nyuliyanyi jungku balkina yuwana nangangi Kudkanyi. Manjijba Kudwanyi nangangi Kunyba Ngarndu nangandurri, baki nanankardi nyuli ngawukuku. ");
INSERT INTO wrk_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Baku barri janangka birnandaba jukanyi, baki janinji nijarrijba nanda bardarda Jisus. Janinji nijarrijba bardarda Jisus, janyulu nyulungangi marrimba yalunya mardarda nanganginmuku mungkijimuku. Miku yalungkiyi janyba yurrngumba, jala yalu yabimba balki yaji. Miku yalungkiyi janyba, nyulungangi marrimbaja yalunya mardarda.” Barriwa. Nani barri yanyba nyuli Yanjil nangangi, jali nyulu buwarrajimba yaji. Nanda niji Jisus, nanda Ju yanyi, barrinani “marrimbawarr mardarda.” ");
INSERT INTO wrk_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Wabula barri kamambarra yanybayi wankalanyi nangangi jangkurr Kudkanyi, baki yarrijba nyuli nanda jangkurr najana Kudkanyi. Nayi nyuli yanyba, ");
INSERT INTO wrk_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“Janyulu ngawukuku wurrumbarra, ngala mikukiyanyi kuluka yingkana nganinyina. Janyulu ngawukuku, baki janangka birnandaba jukanyi. Jayalu nijarrijba nanda bardarda Yimanyuwil.” Nanda niji Yimanyuwil, nanda Ju yanyi barrinani “Jungkuka Kud ngamandu.” Nayinda wankalanyi jangkurr wurrumbarranyi, yanybaka nanankanyi Marinyi, jali jungku juju bayngkani. Barriwa. ");
INSERT INTO wrk_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Buwarrajimbayi yaji Jusibwanyi, baki kamu nyuli walajba. Yabimba nyuli nanda jali karu Yanjilwanyi. Kuyu nyuli nanda wurrumbarra Mari nanganginkanyi maninganjanyi. ");
INSERT INTO wrk_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Ngala miku nyuliyanyi kuluka nangandu waluwa nangki birnandaba bardardanyi. Muningka buli kuluka, ngala nyuli ngawukuku. Baku barri nangki birnandaba Mari jukanyi, baki nijarrijbayi niji Jisus Jusibwanyi. Barriwa. ");
INSERT INTO wrk_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Nanamanji barri jali nangka birnandaba Mari bardardanyi Jisuskanyi, nganinyi niji Yirud, nyuli walkurra mambuka yalungi Jumukuyngka. Walajbayi Jisus barrawuyabarrawuyana niji Bidliyim. Baku barri bijal yingkamuku yali badajba karrina. Nanamuku barri yalili ningkijba warrawiji. Yalili ningkijba warrawiji jingkiykanyi yaji. Badajba yali karrina nanankurri walkurrayngkurri barrawuyabarrawuyarri niji Jirusalim. ");
INSERT INTO wrk_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Jali yalu wanbiya nanaba baki yililikajba yali, “Wanjawa nanda bardarda jalija baku jungku walkurra mambuka narringi Jumukuyngka. Wanjawa nyulu. Najba nurri nangangi warrawiji jali kirrijba kingkarri karrina. Najba nurri nangangi warrawiji, baki badajba nurri waykanyi nanda bardarda nurrunginkanyi kunybanyi jangkurranyi. Wanjawa nyulu.” ");
INSERT INTO wrk_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Kajamukunyi yali manku nanda yalungi jangkurr, baki balkijba yali muwa. Baki nanda walkurra mambuka Yirud, nyuli marda balkijba muwa jali nyulu manku jangkurr nanankanyi bardardanyi jalija baku walkurra mambuka. Kudanyu nyuli balkijba muwa. ");
INSERT INTO wrk_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Manjijba nyuli yingka wudumbiji yalunya, mambukamuku yalunginkanyi jurjkanyi, baki milidimbawarrmuku yuwanyi. Badajba yali nangandurri, baki nyuli ngajaka yalunya, “Nanda naja nangangi kudkanyi yanybaka nangangi Krayiskanyi, ngala wanyi yanybaka nanda naja nangangi. Wanjawa barri nangangi ngardanganja janangka birnandaba. Wanjawa yajina. Wanyi yanybaka nanda naja Kudkanyi.” Barriwa. ");
INSERT INTO wrk_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Jananganja yali, “Nanda naja Kudkanyi yanybaka, ‘Birnandaba janangka jibarri nanankanyi Krayiskanyi nananyina barrawuyabarrawuyana niji Bidliyim, nananyina walkurranyina yajina niji Judiya.’ Nanda wankalanyi jali yanyba jangkurr Kudkanyi, yarrijba nyuli nayi najana Kudkanyi, ");
INSERT INTO wrk_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","‘Nanda barrawuyabarrawuya Bidliyim, nananyina walkurranyina yajina Judiya, miku nanda walkurra barrawuyabarrawuya. Nanda ngawamba bayakarda yaji ngala nanda jirrinyi yaji. Nananyina yajina janangka birnandaba jibarri nanankanyi Krayiskanyi jalija baku jungku walkurra mambuka. Janyulu walkurra mambuka yalungi Jumukuyngka, jala nganinyimuku baki jibarrimuku nangangi Kudkanyi’.” Nani barri yali jananganja nanda mambuka Yirud. ");
INSERT INTO wrk_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Mankuyi yalungi jangkurr Yirudwanyi, baki manjijba nyuli yingka kuyunki yalunya karrinawunyi nangandurri. Janyulu kardarda yanyba yalungi. Jilajba yali nangandurri, ngala nyuli nyubana jungku. Kardarda nyuli yanyba yalungi. Miku yaliyi yingkamukunyi manku nangangi jangkurr. Ngajaka nyuli yalunya, wanyimbala walajbayi nanda warrawiji, baki yali jananganja nanda mambuka. ");
INSERT INTO wrk_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Baki nyuli jirrinyba yalunya, “Kujba janarri nanankanyi bardardanyi. Kudanyu janarri kujba nangangi. Jalija narri wakaramba, baki janarri wijba ngakindurri. Janganarri karu wanjawa nanda bardarda jungkuka, baki jangayu marda jilajba nangandurri. Jangayu ngayu marda wajba nanda bardarda kunybanyi jangkurranyi ngakinkanyi.” Nani barri nyuli jirrinyba yalunya, baki nyuli manjijba yalunya kula Bidliyimyurri. ");
INSERT INTO wrk_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","10","Nanamuku karrinawunyi, yali barlba nanganbunanyi, baki mili yali barlba kula, baki mili yali najba nanamannga warrawiji jalili yalu wabula najba karru. Najba yali nanamannga warrawiji, baki yabijba yali muwa. Nanda barri warrawiji jilajbayi kula, baki yali durrijba kula. Jilajbayi warrawiji nanankurri Bidliyimyurri, baki kurrkunbayi. Jungkuyi warrawiji lalijina yundu nanda barrawu, jali jungku nanda bardarda Jisus kalawunyi barri. ");
INSERT INTO wrk_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Yali ngankijba kalawunyi barrawuna, baki najba yali bulanya, nanda bardarda Jisus, baki nangangi ngardanganja Mari. Mururu yali wayka jambana, baki wajba yali bardarda yalunginkanyi kunybanyi jangkurranyi. Baki wajba yali bardarda yajinyi. Yingka yaji dankurrdankurr malankarri, niji kuld, yingka yaji barrinani jirrki ngala nanjananja jali banjawa kunyba kudu, niji brangkinsins, baki yingka yaji barrinani yingka jirrki jali banjawa kunyba kudu, niji barri mirr. Nanankanyi yajinyi yali wajba bardarda. Wabula yalunjali wajba kajanyi dungalanyi wudumbiji nanda yaji bardardanyi. ");
INSERT INTO wrk_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Baki wijba yali karri yalunginkurri yajiyurri. Wijba yali yingkana yubalina. Miku yaliyanyi wijba langki Jirusalimyurri. Miku yaliyanyi karu nanda mambuka Yirud wanjawa yajina janyulu wakaramba bardarda. Ngala yali buwarrajimba yaji nanamukunyi karrinamukunyi, baki karuyi yalunya Kudwanyi, miku yaliya wijba nangandurri Yirudyurri. Baki nanankardi yali wijba karri yingkana yubalina. ");
INSERT INTO wrk_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Baku barri bijal nanda Jusib, nawinganja nangangi Marinyi, nyuli buwarrajimba yaji marda. Najba nyuli Yanjil Kudkanyi jilaykanyi nangandurri. Yanybayi Yanjil nangangi, “Nanda mambuka Jumukuyngka niji Yirud, janyulu bardajba nanginkurri, baki janyulu kujba nanginkanyi bardardanyi kurdanbiji. Walajbakiyi dulu. Kuyukiyi nganyi maninganja baki bardarda, baki wirlku janarri kula nanankurri yajiyurri Yijibyurri. Nanaba janarri jungku nanankurri jalija ngayu karu narringi wiykanyi nanginkurri.” Nani barri karuyi Jusib Yanjilwanyi. ");
INSERT INTO wrk_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Yinarramba barri walajbayi Jusib. Dulaba nyuli Mari baki nanda bardarda. Baki barlba yali kula ngala nyuli yuwajiwa mungana yaji. Barlba yali kula Yijibyurri, baki nanaba yali jungku. ");
INSERT INTO wrk_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Nanda jangkurr Kudkanyi jali yanyba wankalanyi, nanda jangkurr yanybaka nayi, “Kaya ngayi ngakinkanyi jandayngkanyi. Wudumba ngayi nanamunanyi Yijibnanyi.” Duja nanda jangkurr. Wijbayi Jisus kulani Yijibnanyi. ");
INSERT INTO wrk_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Nanamukunyi karrinawunyi yali jujamba nanda walkurra mambuka Yirud. Miku yaliyanyi wijba nangandurri karunki wanjawa yajina bardarda Jisus. Nanda mambuka barri jali nyulu jingkijba, yali jujamba, baki ngarrangarra nyuli muwa yalungi. Kudanyu nyuli kuliwijba yalungi. Jirrinyba nyuli nanganginmuku ngarrkadabawarrmuku. Jirrinybayi yalunya, yalu kurdanbiji bukambiju jukamuku nananyina barrawuyabarrawuyana Bidliyim. Yalu kurdanbiji bukambiju jukamuku, nanamuku jali yalu jungku bardarda, baki nanamuku jali yalu jungku yingamalina baki kujarranyina kindilkurrina. Nani nyuli jirrinyba yalunya, jingkijbangangi nyuli, walajbayi nanda warrawiji karrina kujarranyina kindilkurrina wabula. Nani barri karuyi mambuka nanamukunyi karrinawunyi. Barriwa. ");
INSERT INTO wrk_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Barlbayi ngarrkadabawarrmuku kula nanankurri Bidliyumyurri, baki kurdanba yali bukambiju jukamuku, bardardamuku, baki bayayawa jukamuku. Nanda wankalanyi niji nangangi Jirimaya yanyba nyuli jangkurr nangangi Kudkanyi. Duja barri nangangi jangkurr, nayinda barri. ");
INSERT INTO wrk_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“Manku ngayu yalunya ngindunkurri kudanyu barri, nanamuku jala jungku nananyina yajina niji Rama. Manku ngayu yalunya ngindunkurri kudanyu barri. Nanda jibarri Rajil nyulu nginduka nanganginkanyi kulunganjamukuyngka. Mikuwali yingkawanyi kurrkunba yalunya ngindunkurri, janybangangi yalungki nanganginmuku bayamuku. Janyba yalungki.” Nani barri yanybayi nanda wankalanyi Jirimaya. Yanyba nyuli jangkurr Kudkanyi, nanda jangkurr najana Kudkanyi. Duja nangangi jangkurr. Kurdanba yali jukamuku. Baki Yirud barri ngamu yali kurdanba Jisus, ngala miku. Nyulu jungkuyi Jisus kularra Yijib. ");
INSERT INTO wrk_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Baku barri nanda mambuka Yirud nangki janyba. Baki wijbayi Yanjil nangandurri Jusibyurri ngala nyuli jungku kularra. Wijbayi Yanjil nangandurri ngala nyuli buwarrajimba yaji. ");
INSERT INTO wrk_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","Yanybayi Yanjil nangangi, “Walajba janarri, baki janarri wijba narringinkurri yajiyurri Yisrayilyurri. Ninji baki nganyi maninganja baki jandanyi, janarri wijba langki, janybangangi yalungki jali nulijba kurdanbikanyi nayinda juka. Yuku janarri wijba barri.” Nani barri yanybayi Yanjil nangangi Jusibkanyi. ");
INSERT INTO wrk_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Baki walajbayi Jusib. Kuyu nyuli nangangi maninganja baki juka, baki wijba yali langki Yisrayilyurri. ");
INSERT INTO wrk_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Wijba yali langki Yisrayilyurri. Ngala karu yali Jusib nanankanyi buyingkinyi mambukanyi yalunginkanyi Jumukuyngka. Nangangi niji Yarrkilayis. Nyuli jandanyi nanankanyi waluwiyngkanyi mambukanyi Yirudkanyi. Jali manku nanda jangkurr Jusibwanyi, baki marrala nyuli. Mankumanku nangki nangangi Yarrkilayiskanyi, yiningki janyulu nyulu kurdanba Jisus. Nanankardi barri nyuli marrala wiykanyi nanankurri yajiyurri niji Judiya. Ngala mili nyuli buwarrajimba yaji, baki karuyi Jusib Yanjilwanyi, nyulu jilaji mili langki nanankurri yajiyurri, niji Kalili. ");
INSERT INTO wrk_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Nanankardi barri barlba yali mili langki Kaliliyurri, baki nanaba yali jungku barrawuyabarrawuyana niji Nasarid. Nanda jangkurr najana Kudkanyi yanybaka, “Nanda barri nangangi yaji Nasarid.” Duja nanda jangkurr. Jardijbayi Jisus nananyina yajina niji Nasarid. ");
INSERT INTO wrk_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Baku barri, jali jardijba Jisus walkurra nganinyi, baki yingka nganinyi niji Jun, nyuli jilajba mangkurruyurri yajiyurri, nananyina yajina niji Judiya. Yalili nijarrijba nanda nganinyi “Jun Ngurrunbawarr.” Jungku nyuli mangkurruna yajina, bundu bundalina niji Jurdan. Baki nyuli milidimba yalunya nanaba jangkurranyi nanganginkanyi Kudkanyi. ");
INSERT INTO wrk_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","Nyulili karu yalunya, “Wijbakiyi jungku balki nangangi Kudkanyi. Marda narrimi ngindu muwa narringinkanyi balkinyi yajinyi. Marda narrimi ngindu muwa, badajbangangi winyurruwa nanda lalanbawarr ngambalangi. Janyulu badajba winyurruwa barri.” Nani barri nyulili karu yalunya. ");
INSERT INTO wrk_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Nanda wankalanyi Yayisaya jalili yanyba jangkurr nangangi Kudkanyi, yarrijba nyuli jangkurr najana Kudkanyi. Yarrijba nyuli jangkurr nanankanyi nganinyingkanyi Junkanyi. Yarrijba nyuli nayi barri, “Jilajbaja nganinyi mangkurruna. Kaya janyulu kudanyu barri. Kaya janyulu nayi barri, ‘Birrirrinja narringkaja kurdulu, badajbajangangi nanda walkurra mambuka. Janyulu badajba, nanda jalija manjijba Kudwanyi. Birrirrinja narringkaja kurduluna nangangi.’” Nani barri yarrijbayi Yayisayawanyi nangangi Junkanyi. ");
INSERT INTO wrk_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Nanda Jun Ngurrunbawarr nayi nyulili jungku. Wudumba nyulili nganya nanankanyi yanimalkanyi niji kamil. Nanda kamil barrinani yarrama. Wudumba nyulili nganya, bakili nyuli yabimba jumbala nangangi nanaba nganyana. Bakili nyulu kijijba waba nanganginyina muwana. Wardamba nangkili ngawamba nyangkunyalinyi baki ngandalanyi. Miku nangkiyanyi wardamba barnyinyi, ngawamba nyangkunyalinyi baki ngandalanyi. ");
INSERT INTO wrk_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Kajamuku yali badajba nangandurri mankunki nangangi jangkurr. Badajba yali bayunguna Jirusalimnanyi, baki kulani nanamunanyi walkurrananyi yajinanyi, niji Judiya. Baki nanamunanyi yajinanyi bundu bundalina, niji Jurdan, yali badajba nanamunanyi yajinanyi marda nangandurri. ");
INSERT INTO wrk_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Ngindu yali muwa yalunginkanyi balkinyi yajinyi, baki karu yali Jun, yali jungku balki nangangi Kudkanyi. Baki nyuli ngurrunba yalunya wabudana Junwanyi. Nyuli babdayis yalunya bundalina niji Jurdan. Barriwa. ");
INSERT INTO wrk_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Badajba yali yingkamuku nangandurri Junyurri, nyuluja ngurrunba yalunya marda. Kudiyamuku yali Barasimuku jalili kudanyu durrijba nanda yuwa nangangi Musiskanyi, ngala miku yaliyanyi jingkijba Kud. Baki kudiyamuku yali Sajusimuku jalili durrijba nanda yuwa nangangi Musiskanyi, ngala yalili yanyba, mikuyaji Yanjilkanyi, baki miku ngambaliyi jungku wanka yurrngumba, ngala ngambalaja jungku kurdan yurrngumba barri. Nanamuku yali badajba nangandurri marda. Najbayi yalunya Junwanyi, baki ngirrwa nyuli yalungi, “Narri balkimuku barrinani miya. Wanyingini karuyi narrinya nangangi Kudkanyi, janyulu manjamanjamba narringi balki yaji baki nanankardi janyulu miku daba narrinya. Wanyingini karuyi narrinya wirlkunkanyi nanankanyi balkinyi yajinyi jalija yabimba narringi Kudwanyi. ");
INSERT INTO wrk_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Jaliyi narri ngindu muwa narringinkanyi balkinyi yajinyi, baki marda narringkimi yangkalamba narringinanyi balkinanyi yajinanyi. Marda narrimi yabimba ngawamba kunyba yaji, baki yingkamukunyi jayalu jingkijba narrinya, narri ngindunkanyi muwa jungunkanyi narri balki. Jayalu jingkijba narrinya ngindunkanyi muwa, jaliyi narri yabimba ngawamba kunyba yaji. ");
INSERT INTO wrk_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Marda narringkimi miku mankumanku nangangi Kudkanyi, nyulu yanybaka narringi, narri jungku kunyba nangangi. Kunyba narri jungku nangangi, Yabrayamngangi nyuli narringi wankalanyi nijanganjinyi. Marda narringkimi miku mankumanku nangangi, narri jungunkanyi kunyba nangangi, narri jungunkanyi kunyba nangangi Kudkanyi, nyulungangi Yabrayam jungkuyi kunyba nangangi Kudkanyi. Yanybaka Kud narringi, narri jungunkanyi balki nangangi. Narri jungkuka balki nangangi, mikungangi narrimi ngindu muwa narringinkanyi balkinyi yajinyi. Baki nanankardi barri janyulu yabimba balki yaji narringi Kudwanyi. Miku narrimi jungku kunyba nangangi Kudkanyi, barrinani jungkuyi Yabrayam kunyba nangangi. Miku narrimi barrinani dujanya jandanyimuku nangangi Yabrayamkanyi. Yuku nyulu kuyungka nayinda dungalamuku Kudwanyi. Yuku nyulu wankambaka yalunya, baki yabimba yalunya nganinyimuku, yalu jungunkanyi barrinani dujanya jandanyimuku nanankanyi wankalanyi Yabrayamkanyi. Ngala narri balkimuku, baki nanankardi janyulu yabimba balki yaji narringi Kudwanyi.” Barriwa. Nani barri ngirrwayi Jun yalungi. Muningka nyuli yanyba dungalanyi. Nanda dungala barrinani ngurranyimuku jali baku kuyu nanda jangkurr nangangi Kudkanyi. Yali jungku dujanya nanganginmuku jandanyimuku Yabrayamkanyi. ");
INSERT INTO wrk_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Baki mili nyuli yanyba yalungi. Muningka nyuli yanyba yalungi, “Yingka nganinyi, kajamuku nanganginmuku kalawanyi. Kudiyamuku yalu kunybayudi mamayudi, ngala kudiyamuku mikuyaji mamanyi yalundu. Baki wudumbaka lama nganinyiwanyi, dayangka nyulu kalawanyi jala mikuyaji mamanyi. Dayangka nyulu, baki janybaka jangurri. Barriwa. Nanda nganinyi, nyulu barrinani Kud, baki nanamuku kurndamuku, yalu barrinani nganinyimuku. Kudiya nganinyimuku yalu jungku kunyba nangangi Kudkanyi. Yalu barrinani kurnda jirdi kajanyi mamanyi. Ngala kudiya nganinyimuku yalu jungkuka balki nangangi Kudkanyi. Yalu barrinani nanda kurnda jala mikuyaji mamanyi, jali nyulu daya baki janybayi jangurri. Nanamuku balkimuku nganinyimuku janyulu bukamba yalunya Kudwanyi. Janyulu janyba yalunya jangurri. ");
INSERT INTO wrk_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Ngayu yawumba narrinya wabudana, baki yingkamukunyi jayalu jingkijba narrinya. Jayalu jingkijba narrinya, narri ngindu muwa narringinkanyi balkinyi yajinyi, ngala yingka janyulu badajba bayngkani ngakindu. Nanda jalija badajba bayngkani ngakindu, nyulu walkurra mambuka. Nyulu mili walkurra mambuka ngaki. Nyulu ngiruka, ngala miku ngayu ngiruka barrinani nyulu. Nanda jalija badajba, janyulu yawumba nanda Kunyba Ngarndu Kudkanyi narrindu. Janyulu yawumba Kunyba Ngarndu narrindu, jaliyi narri ngindu muwa narringinkanyi balkinyi yajinyi. Ngala jaliyi narri miku ngindu muwa nanankanyi balkinyi yajinyi, baki yajbaja narrinya janguwanyi, mankanyi narringi. Barriwa. ");
INSERT INTO wrk_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Jala yalu wudumba nanda daburrul yami jarrkanyi, baki waluku yalu dulaba nanda waban yaminanyi. Yajba yalu nanda waban janguna, ngala yalu kilimba nanda yami jarrkanyi yaji. Nanda yami kunyba mama. Baki nani barri nanda jalija badajba, janyulu manjijba yalunya balkimuku jangurri Yilyurri, ngala janyulu kilimba yalunya jala yalu ngindu muwa yalunginkanyi balkinyi yajinyi.” Nani barri yanybayi Jun yalungi jali jila nangandurri. Barriwa. ");
INSERT INTO wrk_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Nanamanji barri badajbayi Jisus nangandurri Junyurri. Badajba nyuli langina nanganginmunanyi yajinanyi Nasaridnanyi. Nanda yaji Nasarid, nananyina walkurranyina yajina, niji Kalili. Badajba nyuli ngurrunbiji Jisus Junwanyi. ");
INSERT INTO wrk_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Ngala mikukiyanyi nulijba Jun ngurrunbikanyi Jisus. Yanyba nyuli Jisuskanyi, “Marda nganinjimi ngurrunba, ngala ninji jilajbayi ngakindurri, ngayu ngurrunbikanyi ninga.” ");
INSERT INTO wrk_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Ngala jananganjayi Jisuswanyi, “Janinji yabimba nanda jala ninga karu. Nani barri yanybaka Kud. Janungkala yabimba nanda jala nyulu nulijba niyangi yabimbikanyi yaji.” Barriwa. Baki ngayangkuyi Jun nangangi, janyulu ngurrunba Jisus. ");
INSERT INTO wrk_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Baki ngurrunbayi Jisus wabudana Junwanyi. Walajba nyuli waykalinya wabudananyi, baki yinarramba nyuli najba laliji kingkarri. Najba nyuli laliji bardawambikurri nangka. Baki najba nyuli nanda Kunyba Ngarndu Kudkanyi karralankurri kingkarrinya wayka nangandurri. Jungkuyi Ngarndu Kudkanyi nangandu barrinani babangka kulukuku kingkarrinya wayka baki jungkuka kurndana, nani barri karralayi wayka Kunyba Ngarndu Kudkanyi nangandurri Jisusyurri, baki jungkuyi nangandu. ");
INSERT INTO wrk_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Baki yanybayi Kud jangkurr kingkarrinya. Yanyba nyuli, “Nayinda nyulu ngakinmirra jandanyi. Maruka ngayu muwa nangangi kudanyu barri. Nyulu jungkuka kunyba baki mirnarrijba ngayu muwa nangangi.” Nani barri kingkarrinya yanybayi Kud. Barriwa. ");
INSERT INTO wrk_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Baki manjijbayi Jisus kingkarri Kunybawanyi Ngarnduwanyi Kudkanyi. Manjijba nyuli Jisus kingkarri dungalarri. Jungkuyi Jisus dungalana. Mikuyaji yingkanyi nanaba. Yulwa yalu nganinyimuku nanankanyi yajinyi mulijinyi. Manjijbayi Jisus kingkarri nanankurri yajiyurri Kunybawanyi Ngarnduwanyi Kudkanyi, baki badajbayi nanda mambuka wuwarranyi, niji Sayidin. Badajba nyuli nangandurri Jisusyurri, baki balanja nyuli. ");
INSERT INTO wrk_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Jungkuyi Jisus nanaba yingamali yakarl, baki bijal mili, nyuli jungku nanaba. Miku nyuliyanyi kuyu mama nangandurri nanankurri. Mikuyaji mamanyi nanaba nangandu, baki birrkalanyi nyuli kudanyu barri. ");
INSERT INTO wrk_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Baki nanda mambuka wuwarranyi Sayidin, nyuli jilajba nangandurri Jisusyurri balanjanki. Yanybayi Sayidin nangangi, “Ninji barri birrkalanyi. Mikuyaji mamanyi nganyindu. Wanyingkanyi ninji miku wudumba mama. Najbakiyi nayinda dungalamuku wayka jambana. Jaliyi ninji dujanya nangangi jandanyi Kudkanyi, baki jirrinybakiyi yalunya, yalungka yangkalambiji mamanyi. Waluku jalija yalu jungku dungala, ngala jayalu jungku barrinani mama, ninji jarrkanyi nanda barrinani damba. Jaliyi ninji dujanya nangangi jandanyi Kudkanyi, baki ninji ngiruka yabimbikanyi yaji nani barri.” ");
INSERT INTO wrk_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Ngala jananganjayi Sayidin Jisuswanyi, “Miku ngayiyi yabimba nanda jala ninji yanyba. Nanda jangkurr najana Kudkanyi yanybaka nayi, ‘Mardakimi nganinyi miku nulijba ngawamba mamanyi, ngala marda nyulimi nulijba nanganginkanyi jangkurranyi Kudkanyi. Marda nyulimi kudanyu nulijba bukamba nanankanyi jangkurranyi Kudkanyi.’ Nani barri yanybaka jangkurr najana Kudkanyi.” Barriwa. ");
INSERT INTO wrk_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Baki mili barri nanangini Sayidinwanyi nyuli balanja Jisus. Kuyuyi Jisus Sayidinwanyi. Kuyu nyuli Jisus walkurrayngkurri jurjyurri nanaba Jirusalim. Nanaba buli jungku juju barri kingkarri yundukula jurjina. ");
INSERT INTO wrk_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Yanybayi Sayidin nangangi, Jisuskanyi, “Jaliyi ninji dujanya nangangi jandanyi Kudkanyi, baki bulbulngijbakiyi wayka. Bulbulngijbakiyi juju wayka jambarri, jaliyi ninji dujanya nangangi jandanyi Kudkanyi. Yanybaka jangkurr Kudkanyi nayi barri, ‘Jirrinybayi yalunya Yanjilmuku Kudwanyi. Nyuli jirrinyba yalunya, yalu lalanbiji ninya. Miku ningiyi munyajba linjumbikurri nganyingka. Kudanyu ningaja lalanba yurrngumba barri.’ Nani yanybaka jangkurr Kudkanyi, baki nanankardi jaliyi ninji bulbulngijba wayka jambarri, baki janinyalu lalanba Yanjilmukunyi. Miku nganyingkiyi linjumba mankanyi, jaliyi ninji dujanya nangangi jandanyi Kudkanyi.” ");
INSERT INTO wrk_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Ngala jananganjayi Jisuswanyi, “Ngala mili nanda jangkurr Kudkanyi yanybaka nayiba, ‘Marda ninjimi miku balanja nganyi mambuka Kud. Marda ninjimi miku balanja nanda nganyi mambuka Kud.’” Nani barri jananganjayi Sayidin Jisuswanyi. Barriwa. ");
INSERT INTO wrk_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Baki mili balanjayi Jisus Sayidinwanyi. Kuyu nyuli Jisus juju barri kingkarri yundu kulawirana. Juju barri kingkarrinyan bangani buli jungku kulawirana. Yanybayi Sayidin nangangi Jisuskanyi, “Ninji najbangka yaji juju, langki baki kula, karri baki bayungu. Juju ninji najbangka yaji lukuluku. Yingka nyulu mambuka nanankanyi yajinyi langki. Yingka nyulu mambuka nanankanyi yajinyi kula. Kajamuku mambukamuku, ninji najbangka yalungi yaji. ");
INSERT INTO wrk_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Jangayu yarrijba ninga wirimalaru yingkamukuyngka mambukanyi. Janinga yarrijba wirimalaru bukambijuyngka yalungi, jaliyi ninji kuyu ngaki jangkurr, jaliyi ninji durrijba ngaki yuwa. Janinji wirimalaru bukambijuyngka yajinyi jaliyi nganinji yarrijba nganiyingkanyi mambukanyi.” Barriwa. ");
INSERT INTO wrk_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Ngala mili jananganjayi Sayidin Jisuswanyi, kudanyu nyuli ngirrwa nangangi, “Barriwakiyi jilajba juju ngakinbunanyi. Wijbakiyi nganinji balanja. Yanybaka nayi barri nanda jangkurr najana Kudkanyi, ‘Ngawamba yingamali nyulu dujanya Kud. Nyulu wirimalaru bukambijuyngka yalungi. Marda ninjimi yanyba mududu nangangi baki brijbakimi nangangi. Marda ninjimi wajba Kud kunybanyi jangkurranyi nganyingkanyi. Marda ninjimi yabimba yaji ngawamba nangangi, miku yingkanyi jala miku dujanya Kud.’ Barriwakiyi barlba ngakinbunanyi. Ngayu yurlwangka nganyingkanyi jangkurranyi.” Nani barri jananganjayi Sayidin Jisuswanyi. ");
INSERT INTO wrk_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Baki barlbayi Sayidin. Yingijba nyuli Jisus nyubana jungunkurri kulawirana. Baki badajba yali Yanjilmuku nangandurri, lalanba yali Jisus nanaba mulijina yajina. Barriwa. ");
INSERT INTO wrk_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Baku barri yali wudumba nanda Jun Ngurrunbawarr. Wudumba yali Jun ngarrkadabawarrmukunyi baki kijijba yali. Yarrijba yali brisinyina. Bayngkani barri barlbayi langki Jisus nanankurri walkurrayngkurri yajiyurri, niji Kalili. ");
INSERT INTO wrk_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Miku nyuliyanyi jungku nanganginyina yajina Nasarid, ngala nyuli jungku yingkana barrawuyabarrawuyana, yaji niji Kabirnayum. Nanda barrawuyabarrawuya langiya nananyina kanjana, niji Kalili, baki nananyina walkurranyina yajina jalili yalu wankalana nijarrijba, Jibulun baki Nabdali. ");
INSERT INTO wrk_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Nanda wankalanyi niji Yayisaya, nyulili yanyba jangkurr nangangi Kudkanyi, baki nyuli yarrijba jangkurr najana Kudkanyi. Duja nangangi jangkurr. ");
INSERT INTO wrk_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","Nayi nyuli yarrijba, “Ngayu yanybaka yalungi jala jungku nanankuyanyina yajina, Jibulun baki Nabdali, nananyina walkurranyina yajina Kalili. Kudiyamuku yalu jungkuka karrurriybana nanaba bundalina niji Jurdan, baki kudiyamuku yalu jungkuka bayangarrinybana kanjana. Yalu jungkuka yalunginyina ngurranyina yajina. Ngayu yanybaka yalungi jala yalu jungku nananyina yajina. ");
INSERT INTO wrk_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Yalu jungku barrinani mungana yajina. Nani yalu jungkuka barrinani mungana yajina, mikungangi yaliyi jingkijba Kud. Ngala badajbaja yingka yalundurri. Janyulu badajba yalundurri, baki janyulu barrinani mirnbi yalungi, yalu naykanyi yaji. Nanangini yingkawanyi janyulu milidimba yalunya nangangi Kudkanyi, baki jayalu jingkijba Kud. Jayalu jingkijba jungunkanyi yurlurrmba nangangi.” Barriwa. Nani yanybayi jangkurr najana Kudkanyi. ");
INSERT INTO wrk_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Ngala jungkuyi Jisus nanaba Kabirnayum, baki milidimba nyuli yalunya nangangi Kudkanyi. Yanybayi Jisus yalungi, “Nanijba barri yuku narri jungku kunyba nangangi Kudkanyi, baki janyulu lalanba narrinya Kudwanyi. Wijba narri jungku balki. Yangkalamba janarringka narringinbunanyi balkinanyi yajinanyi, baki janarri kuyu nayinda kunyba jangkurr nangangi Kudkanyi. Jungku janarri kunyba nangangi Kudkanyi yurrngumba barri. Ngindu janarringka muwa narringinkanyi balkinyi yajinyi. Kuyu janarri nayinda kunyba jangkurr nangangi Kudkanyi, baki janyulu lalanba narrinya yurrngumba barri.” Nani barri nyuli milidimba yalunya Jisuswanyi. ");
INSERT INTO wrk_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Jilajbayi Jisus yundu bayunguna wabudana. Walkurra nanda wabuda barrinani kanja niji Kanja Kalili. Jilajbayi Jisus baki najba nyuli bulanya buwakula, Sayimin baki Yandru. Nanda Sayimin, yingka niji nangangi, Bida. Najbayi bulanya janybikurri bardija wayka wabudarri. Janyba bulili bardija kakunyi mungkujbirriwuyanyi. Nani barri bulili waki yurrngumba wudumbikanyi kaku. ");
INSERT INTO wrk_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Yanybayi Jisus bulangi, “Jilajba janimbala ngakinduwa. Janimbala jungku ngakindu yurrngumba barri, baki jangayu milidimba nimbalanya. Nanijba barri nimbala wudumbaka kaku, ngala baku barri janimbala wudumba yingkamuku ngaki.” ");
INSERT INTO wrk_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Baki yinarramba buli yingijba nanda bardija, yingijba buli bardija yurrngumba barri, baki jilajba buli nangandu Jisusnyina. ");
INSERT INTO wrk_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Mili yali jilajba bayunguna wabudana, baki najba yali yingkawuya buwakula bulanya. Najbayi bulanya, Jayims baki Jun. Marda nijanganjinyi bulangi niji nangangi Zibidi, nyuli bulandu marda. Jungku yali muwardana, baki ngarrkadaba yali bardija nanda bardawayudi. Yanybayi Jisus bulangi, buwakulayngka bulaja jilajba nangandu Jisusnyina. Barriwa. ");
INSERT INTO wrk_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Baki yingijba buli nanda nijanganjinyi bulangi. Nyuli wambu jungku muwardana baki jawuda wakiwarr nangandu, ngala barlbayi buwakula nangandu Jisusnyina. Barriwa. ");
INSERT INTO wrk_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Jilajbayi Jisus nananyina walkurranyina yajina Kalili. Nyulili jilalajba kajayurri jurjyurri, bakili milidimba yalunya nanaba. Milidimba nyulili yalunya kunybanyi jangkurranyi Kudkanyi, nyulu lalanbawarr ngambalangi. Bakili nyulu kunymamba kajamuku jalili yalu lunji. ");
INSERT INTO wrk_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Kajamuku jalili jungku nananyina walkurranyina yajina niji Siriya, yali manku jangkurr nangangi Jisuskanyi. Manku yali jangkurr nangangi, bakili yalungka yanyba nangangi. Bakili kuyu kajamuku jalili yalu lunji nangandurri. Baki kunymamba nyuli yalunya Jisuswanyi. Kudiya yali balkijba muwa, kudiya yali balkijba kulaji, kudiya barri miku yalungkiyanyi ngirringirrikimba mankanyi, kudiya yalu wuwarryudi mankanyina. Lunji yali yanina yanina ngalyayudi. Kuyu yalunjali nangandurri Jisusyurri, baki nyuli kunymamba yalunya bukambiju. ");
INSERT INTO wrk_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Kajamuku yali jilajba nangandurri. Kudiyamuku yali jilajba bayunguna Kalilinanyi, kudiyamuku yali jilajba karrurrinanyi, nanda yaji Dikabulis. Kudiyamuku yali jilajba kulani Jirusalimnanyi, baki Judiyananyi. Kudiyamuku yali jilajba karrurrinybananyi. Yali burrijba nanda bundal niji Jurdan. Baki yali jilajba nangandu, ngala nyuli jilalajba lukuluku milidimbikanyi yalunya jangkurranyi, baki kunymambikanyi yalunya mankanyi. ");
INSERT INTO wrk_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Kajamuku yali jilajba nangandu Jisusnyina, walkurra muramuku. Najbayi yalunya Jisuswanyi, baki mankumanku nangki, janyulu milidimba yalunya. Kirrijba nyuli kingkarri dungalana, baki jungkurrijba nangki jambana. Jilajba yali nanganginmuku kandimuku nangandurri, baki jungku yali walu nangandu. Baki walkurra muramuku yali jungku nanaba nangandu marda. ");
INSERT INTO wrk_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Baki milidimbayi yalunya Jisuswanyi. Milidimbayi yalunya kajanyi jangkurranyi. Nayi nyuli yanyba, ");
INSERT INTO wrk_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Nanda jala nangka jingkijba, miku nangkimi yabimba jungunkanyi kunyba, janyulu nyulu mirnarrijba muwa. Nyulu jingkijbangka, ngawamba yuku nyulu yabimbaka jungunkanyi kunyba Kudwanyi. Janyulu lalanba nanda yurrngumba Kudwanyi, jala jingkijba nani, baki nanankardi janyulu mirnarrijba muwa. Barriwa. ");
INSERT INTO wrk_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Nanda jala ngindu muwa nanganginkanyi balkinyi yajinyi, baki yingkamukuyngka yalunginkanyi balkinyi yajinyi, janyulu nyulu mirnarrijba muwa. Yabimbaja kunyba yaji nangangi Kudwanyi, baki nanankardi janyulu mirnarrijba muwa. Barriwa. ");
INSERT INTO wrk_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Nanda jala miku nangka walkurramba, ngala jala nangka bayakardamba, janyulu nyulu mirnarrijba muwa. Yabimbaja walkurra yaji nangangi Kudwanyi. Nanda barri janyulu mili wanka jungku nangandu Kudnyina, baki nanankardi barri janyulu mirnarrijba muwa. Barriwa. ");
INSERT INTO wrk_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Nanda jala nulijba jungunkanyi kunyba nangangi Kudkanyi jala nulijba yabimbikanyi nanda jala yanyba kud nangangi yabimbikanyi yaji, janyulu nyulu mirnarrijba muwa. Nyulu jingkijbangka Kud, nyulu lalanbawarr, baki nanankardi barri janyulu mirnarrijba muwa. Barriwa. ");
INSERT INTO wrk_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Nanda jala yabimbaka kunyba yaji yalungi yingkamukuyngka, janyulu nyulu mirnarrijba muwa. Nyulu jingkijbangka Kud, nyulu kandimbaka nanda, marda yabimbaka kunyba yaji nangangi. Nanankardi barri janyulu mirnarrijba muwa. Barriwa. ");
INSERT INTO wrk_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Nanda jala yurrngumba nulijba durriykanyi nanda yuwa nangangi Kudkanyi, jala miku nulijba durriykanyi nanda yingka yuwa, janyulu nyulu mirnarrijba muwa. Miku janangka ngadijba Kud nanganbunanyi, ngala janyulu najba Kud baku barri, baki nanankardi barri janyulu mirnarrijba muwa. Barriwa. ");
INSERT INTO wrk_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Nanda jala yurrngumba kandimba yalunya jala yalu kijiyudi, nanda jala nulijba kurrkunbikanyi yalunya kijinyi, nanda jala nulijba yalungi jungunkanyi mardumardu muwa, janyulu nyulu mirnarrijba muwa. Janyulu kuyu nanda nanganginmirra jandanyi Kudwanyi, baki nanankardi janyulu mirnarrijba muwa. Barriwa. ");
INSERT INTO wrk_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Nanda jala miku nangkimi yangkalamba nanganbunanyi Kudnanyi ngala yingkamukunyi yalu yabimba kiji nangangi, durrijbangangi nyuli yuwa nangangi Kudkanyi, janyulu nyulu marda mirnarrijba muwa. Nyulu jingkijbangka, janyulu mili jungku wanka nangandu lalanbawarranyina, baki nanankardi barri janyulu mirnarrijba muwa. Barriwa. ");
INSERT INTO wrk_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","12","Narri ngakinmuku kandimuku, yingkamukunyi jayalu yabimba kiji narringi, jayalu jujamba jangkurr narringi, durrijbangangi narri ngaki jangkurr. Jayalu yanyba balki jangkurr narringi, ngakingangi. Miku narriyi ngirukijba muwa, ngala janarri mirnarrijba muwa nanankanyi kijinyi. Janarri mirnarrijba muwa, jingkijbangangi narri Kud, janyulu yabimba kunyba yaji narringi. Janyulu lalanba narrinya. Janyulu mili wankamba narrinya, narri jungunkanyi nangandu kingkarri. Baki mili kunyba yaji janyulu yabimba narringi marda. Mili kunyba yaji janyulu yabimba. Wabula kamambarra barri yali yabimba kiji yalungi jalili yanyba nangangi jangkurr Kudkanyi. Kaja kiji yalili yabimba yalungi, baki nani barri jayalu yabimba kiji narringi marda, ngala janarri mirnarrijba muwa nanankanyi kijinyi. Barriwa.” ");
INSERT INTO wrk_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Mili yingka jangkurr yanybayi Jisus yalungi, “Nanda barri ngarrawa, nanda kunyba barnyinyi. Kunymambaka barnyi ngarrawawanyi, baki mikuwali ngujbulijba nanda barnyi. Baki narri barri, narri barrinani nanda ngarrawa. Narri kunymambaka yalunya yingkamuku marda, baki yalu jungku kunyba. Malumba yalu jungku kunyba narrindu. Ngala jaliyi nanda ngarrawa jardibirri, baki ngambala janyba nanda ngarrawa. Nanda ngarrawa miku kunyba barnyinyi jala nyulu jardibirri. Nani barri nanda narringi, jaliyi narri miku marrimba ngaki jangkurr, jaliyi narri miku milidimba yalunya yingkamuku ngakinkanyi jangkurranyi, baki janarri jungku barrinani nanda jardibirri ngarrawa, jala miku kunyba barnyinyi. Janyba yalu nanda jardibirri ngarrawa. Baki nani barri, janyulu janyba narrinya Kudwanyi, miku nyuliyi lalanba narrinya jaliyi narri miku marrimba ngaki jangkurr. Janyulu janyba narrinya nanganbunanyi.” Nani barri yanybayi Jisus yalungi ngarrawanyi. ");
INSERT INTO wrk_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","16","Baki mili yingka jangkurr yanybayi Jisus yalungi, “Minimbaka yaji mungana mirnbiwanyi. Nyulu yarrijbangka mirnbi yundurrinybana nganinyiwanyi, baki janyulu mirnarrijba yaji juju. Miku nyulimi yarrijba mirnbi kalawunyi darladarlana. Miku. Murumbaka mirnbi darladarlawanyi. Yarrijbangka nyulu nanda mirnbi yundurrinybana yajina. Barriwa. Jala nangangi barnda kingkarri dungalana, baki najba yali nangangi mirnbi kingkarri kajamukunyi. Jujunanyi yalu najba nanda mirnbi nanganginyina barndana. Baki narri barri, narri barrinani nanda mirnbi. Narri minimbaka yalunya yingkamuku ngaki. Jala narri ngayangayijba nanankanyi yuwanyi Kudkanyi, baki yingkamukunyi jayalu najba narrinya jungunkurri yurlurrmba nangangi Kudkanyi. Kajamukunyi yalu najba mirnbi mungana, baki nani barri, kajamukunyi jayalu najba narrinya jungunkurri yurlurrmba nangangi. Baki jayalungka marda yangkalamba nangandurri Kudyurri, jayalu yalu marda jungku yurlurrmba nangangi.” Barriwa. Nani yanybayi Jisus yalungi mirnbinyi. ");
INSERT INTO wrk_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","Baki mili nyuli milidimba yalunya nayi barri. “Badajba kuna ngayi, manjamanjambikanyi nanda yuwa nangangi Musiskanyi. Miku. Marda narringkimi miku mankumanku nani ngaka. Miku ngayiyanyi badajba manjamanjambikanyi nanda yuwa nangangi Musiskanyi, baki nanda yingka jangkurr jalili yalu milidimba wankalamukunyi jali yanyba jangkurr Kudkanyi. Miku ngayiyanyi badajba manjamanjambikanyi yalungi jangkurr, ngala ngayi badajba dujambikanyi yalunginkanyi jangkurranyi. Yalunginyi jangkurrwanyi karungka narrinya ngaki. Wabula kamambarra yanybayi Kud, janyulu manjijba nanda marrimbikanyi yalunya mardarda. Baki nanamukunyi wankalamukunyi, yali yarrijba nanda jangkurr Kudkanyi najana. Yali yarrijba nanda jangkurr miku yangkalambikanyi. Yali yanyba nangangi Kudkanyi, janyulu manjijba nanda baku barri juju. Miku ngayiyanyi badajba manjamanjambikanyi nanda yalungi jangkurr, ngala jali ngayu badajba baki narri jingkijba duja nanda jangkurr. ");
INSERT INTO wrk_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Mankuwa narri nayinda jangkurr. Bukamba nanda yuwa jali yanyba Kud nangangi Musiskanyi, nanda nangangi yuwa Kudkanyi. Yuwajiwa jungkuja nanda yuwa duja yurrngumba barri. Yurrngumba jungkuja duja nanankurri jalija bukamba yaji Kudwanyi. Nanamanji barri janyulu manjamanjamba laliji baki jamba Kudwanyi. Baki yurrngumba nanankurri jungkuja duja nanda yuwa. ");
INSERT INTO wrk_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Nanankardi barri, marda narrimi bukambiju ngayangayijba nanankanyi yuwanyi. Marda narringkimi miku mankumanku, “Nanda yuwa nangangi Musiskanyi, kudiya nanda walkurra, jangayu ngayangayijba nanankanyi yuwanyi, ngala kudiya bayakarda, jangayu yurlwa nanankanyi yuwanyi.” Marda narringkimi miku mankumanku nani barri. Bukamba nanda yuwa nanda jirrinyi yuwa narringi. Miku yingka walkurra, ngala yingka bayakarda. Jaliyi narri miku ngayangayijba bukamba nanankanyi yuwanyi, baki jaliyi narri milidimba yalunya marda, yalu miku ngayangayiykanyi bukamba nanankanyi yuwanyi, baki nanda balki. Miku nyuliyi lalanba narrinya mili Kudwanyi. Miku nyuliyi mili wankamba narrinya baku barri. Ngala jaliyi narri ngayangayijba bukamba nanankanyi yuwanyi, baki jaliyi narri milidimba yalunya marda, yalu ngayangayiykanyi nanankanyi yuwanyi, baki janyulu mirnarrijba muwa narringi Kud. Janyulu mili lalanba narrinya. Janyulu mili wankamba narrinya baku barri. ");
INSERT INTO wrk_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Kudanyu ngayu karungka narrinya. Jaliyi narri yabimba yaji nani barri, baki janyulu mili lalanba narrinya Kudwanyi. Janyulu mili wankamba narrinya baku barri, jaliyi narri ngayangayijba nanankanyi yuwanyi. Ngala nanamuku milidimbawarrmuku yuwanyi, baki nanamuku Barisimuku, miku nyuliyi lalanba yalunya, mikungangi yalimi jungku yurlurrmba nangangi Kudkanyi. Miku yalimi ngayangayijba nanankanyi yuwanyi Kudkanyi, baki miku yalunjalimi milidimba yingkamuku ngayangayiykanyi nanankanyi yuwanyi. Milidimbaka yalunjalu yinini yuwanyi yalunginkanyi yuwanyi, ngala miku yalunjalimi milidimba nanankanyi duja yuwanyi Kudkanyi. Baki nanankardi barri miku nyuliyi lalanba yalunya Kudwanyi.” Barriwa. ");
INSERT INTO wrk_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","Mili barri yanybayi Jisus yalungi, “Narri jingkijba nayinda jangkurr, jali jirrinyba Kudwanyi wabula. Nayi nyuli jirrinyba, ‘Mikujiyi kurdanba yingka. Jaliyi ninji kurdanba yingka, baki jayalu kuyu ninya kurdusyurri, baki jayalu nanaba yanyba nganyingkanyi balkinyi yajinyi.’ Nani barri jayalu yabimba nganyi jaliyi ninji kurdanba yingka. ");
INSERT INTO wrk_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Ngala nanijba barri ngayu narrinya karungka mili jangkurranyi. Jaliyi ninji jungku ngarrangarra muwa nanankanyi yingkanyi, baki nanda balki. Ninji jungkuka balkina yuwana Kudkanyi, jaliyi ninji ngarrangarra muwa yingkanyi. Yiningki janinji yanyba balki jangkurr nangangi. Yiningki janinji yanyba nangangi, ‘Ninji mudu. Ngayu ngarrangarra muwa nganyi.’ Baki yiningki janinji daba nanda. Jaliyi nganyingka kurrkunba kijiwiykanyi yingkanyi baki miku ninjiyi daba, miku ninjiyi kurdanba nanda yingka. Ngayu karungka narrinya, jaliyi ninji yingkanyi ngarrangarra muwa nuliykanyi kurdanbikanyi nanda yingka, baki marda nganyingkimi janyba. Marda nyulimi manjijba ninya wayka jangurri Yilyurri Kudwanyi. Barriwa. ");
INSERT INTO wrk_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Kudiyana narri jilajba walkurrayngkurri jurjyurri. Narri jilajba waykanyi Kud yajinyi. Ngala jalija ninji wanbiya jurjina, jaliyi ninji mankuwa yingkanyi, nyulu ngarrangarra muwa nganyi, yabimbangangi ninji balki yaji nangangi, jaliyi ninji mankuwa nani, baki mikujiyi wajba Kud nanankanyi yajinyi. Jilijbawa. ");
INSERT INTO wrk_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","Yingijbakiyi nanda yaji nanaba jurjina, baki jilajbakiyi nanankurri yingkayurri. Karukiyi nanda, ninji ngindu muwa nanankanyi balkinyi yajinyi jala ninji yabimba nangangi. Baki yuku barri, janinji wijba jurjyurri, baki wajba Kud nanankanyi yajinyi. Waluku janinji karu nanda, ninji ngindu muwa nganyingkanyi balkinyi yajinyi, baki yuku barri janinji wajba Kud yajinyi. Barriwa. ");
INSERT INTO wrk_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","26","Mili jangkurr jangayu yanyba narringi. Muningka jangayu yanyba. Wajbayi ninga dungala nganinyiwanyi, ninji wiykunumbikanyi nanda dungala baku barri. Jaliyi nyulu ngajaka ninya nanankanyi dungalanyi, baki marda ninjimi dulu wiykunumba nangandurri. Jaliyi ninji miku wiykunumba baki yiningki janyulu karu yirlarr nanankanyi dungalanyi. Baki janinya karrinjarrijba kalawuyngkurri kurdusnyina. Jayalu yanyba nganyi, baki jayalu yarrijba ninya brisinyina, baki janinga marrimba nanaba, nanankurri jalija ninji wiykunumba bukamba nanda dungala nangandurri. Nanankardi barri, marda ninjimi dulu wiykunumba nanda dungala waluwa nyuli karu yirlarr. Barriwa. ");
INSERT INTO wrk_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","“Mili jangkurr jangayu milidimba narrinya. Narri jingkijba nayinda jangkurr, ‘Mikujiyi kuluka yingkana, jala miku nganyinmirra kayikayi.’ ");
INSERT INTO wrk_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Ngala nanijba barri ngayu karungka narrinya mili jangkurranyi. ‘Jaliyi ninji najba yingka jibarri, baki kudanyu ninji nulijba nangangi kulukankanyi nangandu, ngala miku, jaliyi ninji kudanyu nulijba nangangi nani, baki nanda balki. Jaliyi ninji kuluka nangandu, nanda balki, baki jaliyi ninji nulijba nangangi nani barri, baki nanda marda balki. Mikujiyi ningkijba yingka jibarri nani, mikujiyi nulijba nangangi nani, baki miku janinji yabimba balki yaji. ");
INSERT INTO wrk_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Ninji najbangka yaji yamiyudinyi. Jaliyi ninji najba yaji, baki nanankardi barri nganyingka mankumanku yabimbikanyi balki yaji, barrinani jala ninji najba yingka jibarri, baki nganyingka mankumanku kulukankanyi nangandu. Jaliyi nganyingka mankumanku nanankanyi balkinyi yajinyi nani barri, jaliyi ninji yabimba nanda balki yaji, baki nanda balki. Jaliyi nganyingka mankumanku nanankanyi jali ninji najba, baki ninji yabimba nanda balki yaji, baki miku ninji jilajba kingkarri nangandurri Kudyurri, ngala janinji jilajba wayka jangurri Yilyurri. Marda nganyingkimi kurrkunba yabimbikurri nanda balki yaji jali ninji najba, baki janinji jilajba kingkarri nangandurri Kudyurri. Barriwa. ");
INSERT INTO wrk_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Ninji yabimbaka yaji marniyudinyi. Jaliyi nganyingka mankumanku yabimbikanyi balki yaji nganyinjudinyi marniyudinyi, baki nanda balki. Jaliyi nganyingka mankumanku yabimbikanyi nanda balki yaji, jaliyi ninji yabimba nanda balki yaji, baki miku ninjiyi jilajba kingkarri nangandurri Kudyurri, ngala janinji jilajba wayka jangurri Yilyurri. Marda nganyingkimi kurrkunba yabimbikanyi nanda balki yaji marniyudinyi, baki janinji jilajba kingkarri nangandurri Kudyurri. Barriwa. ");
INSERT INTO wrk_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","Marda nayinda barri jangkurr yali yanyba wabula barri maykarranyi. ‘Jaliyi nanda maninganja kuluka yingkana nganinyina, baki nanda nawinganja nangangi, yuku nyulu manjijba nangangi maninganja nanganbunanyi. Yuku nyulu wajba nangangi maninganja jangkurranyi najana, baki muningka manjijba nanganbunanyi. Nanda jangkurr najana yanybaka jibarrinyi, miku nyulimi mili nangangi maninganja. Baki yuku barri yingkawanyi kuyuja nanda jibarri nanganginkanyi maninganjanyi. Nani barri yanybaka yuwa nangangi Musiskanyi jaliyi kuluka jibarri yingkana nganinyina. ");
INSERT INTO wrk_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Ngala nanijba barri ngayu karungka narrinya mili jangkurranyi. Jaliyi wajbangka nangangi maninganja nanankanyi najanyi nganinyiwanyi baki manjijba nanganbunanyi, ngala nanda jibarri mikukiyanyi kuluka yingkana nganinyina, baki nanda balki. Yanybaka naja, miku nanda jibarri yuwajiwa nangangi maninganja, ngala balki nanda jangkurr najana. Miku nyuliyanyi kuluka yingkana nganinyina, baki nanankardi barri yuwajiwa nanda jibarri nangangi maninganja. Nanangini jibarriwanyi jaliyi nyulu wudumba yingka nawinganja, baki nyulu yabimbaka balki yaji, baki nanda buyingkinyi nawinganja nangangi, nyulu marda yabimbaka balki yaji. Nani barri bula jungku balki, yuwajiwangangi nyulu maninganja nanankanyi waluwiyngkanyi nganiyngkanyi. Barriwa. ");
INSERT INTO wrk_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","Narri jingkijba barri, yalunjalu karuyi nayinda, “Jala ninji yanyba ngiruka jangkurr, miku yangkalambikanyi, jala ninji ngajaka Kud mankunkanyi nganyi ngiruka jangkurr, baki marda ninjimi yabimba nanda yaji. Jaliyi ninji miku yabimba nanda jala ninji ngajaka Kud mankunkanyi yaji, baki nanda balki, balkimirra.’ Nani barri yalunjalu karuyi. ");
INSERT INTO wrk_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","37","Ngala nanijba barri ngayu karungka narrinya mili jangkurranyi. Jala ninji nulijba yanybikanyi ngiruka jangkurr, miku yangkalambikanyi, baki mikujiyi ngajaka Kud mankunkanyi nganyi jangkurr. Jaliyi ninji ngajaka Kud nani, baki nanda balki. Nanda nanganginkanyi jangkurranyi Sayidinkanyi. Ngala jala ninji nulijba yanybikanyi ngiruka jangkurr, baki ngawamba yanyba nayi, ‘Yi. Jangayu yabimba nanda yaji.’ Baki yingka jangkurr barrinani nayi, ‘Miku jangayu yabimba nanda yaji.’ Ngawamba nani barri marda ninjimi yanyba ngiruka jangkurr. ");
INSERT INTO wrk_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","Baki narri jingkijbangka nayinda marda. Yalu yanyba, ‘Jaliyi yingkawanyi linjumba nganyi yami, jabarri marda ninjimi linjumba nangangi yami. Jaliyi nyulu dalyamba nganyi mayi, jabarri marda ninjimi dalyamba nangangi mayi.’ ");
INSERT INTO wrk_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Ngala nanijba barri ngayu karungka narrinya mili jangkurranyi. Jaliyi yingkawanyi yabimbaka kiji nganyi, baki mikujiyi daba. Jaliyi yingkawanyi daba nganyi karnkul, baki mikujiyi kurrkunba. Yuku janyulu daba nganyi yingka karnkul marda. ");
INSERT INTO wrk_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Jaliyi yingka nulijba kuyunkanyi nganyi danyan, baki wajbakiyi marda nganyingkanyi yingkanyi jumbalanyi. ");
INSERT INTO wrk_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Jaliyi ngarrkadabawarranyi karu ninga kuyunkanyi nangangi yaji juju bijal, ngala janyulu muningka jila nganyindu, baki yabimbakiyi nanda jali nyulu karu, ngala milikiyi yabimba. Kuyukiyi nangangi yaji jujumirra. ");
INSERT INTO wrk_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Jaliyi yingkawanyi ngajaka ninya yajinyi, baki mikujiyi kilimba nanda yaji nganyindu. Wajbakiyi nanankanyi jali nyulu ngajaka ninya. Nani barri marda narrimi yabimba yaji nangangi. Barriwa. ");
INSERT INTO wrk_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","Marda nayinda jangkurr narri jingkijba, ‘Marda ninjimi maruka muwa yalungi nganyingkanyi kandimukuyngka, ngala marda ninjimi ngirra yalunya jala yalu miku nganyinmuku mungkijimuku.’ ");
INSERT INTO wrk_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Ngala nanijba barri ngayu karungka narrinya mili jangkurranyi. Marda ninjimi maruka muwa yalungi, nganyingkanyi kandimukuyngka, baki marda ninjimi maruka muwa yalungi, jala yalu miku nganyinmuku mungkijimuku. Baki marda ninjimi maruka muwa yalungi jala yalu ngirra ninya. Marda ninjimi yanyba mududu nangangi Kudkanyi yalungi, jala yalu yabimba kiji nganyi. ");
INSERT INTO wrk_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Jaliyi ninji jungku nani barri marukankanyi muwa yalungi bukambijuyngka, baki ninji jungku barrinani nyulu jungkuka nganyi Buwakanya kingkarri. Nyulu marukangka muwa yalungi bukambijuyngka. Nyulu yabimbaka kunyba yaji yalungi jala kunybamuku, baki yalungi jala balkimuku. ");
INSERT INTO wrk_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Ngala jaliyi ninji maruka muwa ngawamba yalungi jala yalu maruka muwa nganyi, baki wanyingkanyi mardakimi Kudwanyi yabimba kunyba yaji nganyi. Nanamuku balkimuku yalu marda jungkuka nani. Wanyingkanyi mardakimi Kudwanyi yabimba kunyba yaji yalungi. Ngala jaliyi ninji maruka muwa yalungi jala yalu ngirra ninya, baki janyulu mirnarrijba muwa nganyi Kud. ");
INSERT INTO wrk_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Jaliyi ninji ngawamba jungku yalundu nganyinmukunyina mungkijimukunyi, baki nanda kuna kunyba. Nani yalu marda jungku nanamuku balkimuku. Yalu marda jungkuka yalunginyina mungkijimukunyina. Ngala jaliyi ninji jungku yalundu jala ninyalu ngirra, yanybikanyi yalungi, baki janyulu mirnarrijba muwa nganyi Kud. ");
INSERT INTO wrk_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Nganyi Buwakanya kingkarri, nyulu jungkuka kunyba yurrngumba barri. Miku nyulimi yabimba balki yaji. Miku yingamali balki yaji nyulu yabimbaka. Kunyba nyulu jungkuka yurrngumba barri. Baki narri barri, marda narrimi nulijba jungunkanyi barrinani nyulu. Marda narrimi nulijba yabimbikanyi ngawamba kunyba yaji barrinani nyulu yabimbaka kunyba yaji. Barriwa.” ");
INSERT INTO wrk_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Mili barri yanybayi Jisus yalungi jali yalu jungku yundu kulawirana. “Kajamuku yalungka jujambangka. Yalungka mankumankuka, yalu jungkuka yurlurrmba nanankanyi yuwanyi Musiskanyi, ngala miku. Ngala yalu nulijba yalungi yingkamukuyngka, yalungka yanybikanyi yalungi jujambawarrayngka, yalu jujambawarrmuku jungkuka yurlurrmba nanankanyi yuwanyi. Nanankardi barri yalu nulijba yalungi yingkamukuyngka naji yalunya yabimbikurri yaji nangangi Kudkanyi. Nanankardi barri miku yalimi kardarda yanyba mududu nangangi Kudkanyi yalunginyina barndana. Ngala yalu yanyba mududu nangangi, yalu wajba Kud yalunginkanyi kunybanyi jangkurranyi yajina jala yalunya najba kajamukunyi. Miku nanda kunyba. Jaliyi ninji yabimba yaji nani barri, baki nganyi Buwakanya kingkarri miku janyulu mirnarrijba muwa nganyi. Miku janyulu yabimba kunyba yaji nganyi. ");
INSERT INTO wrk_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Jaliyi yingka nyulu jungku mikuyaji mamanyi, mikuyaji dungalanyi, baki wajbakiyi nanda mamanyi baki dungalanyi. Ngala marda nganyingkimi miku barrarrakijba, wajbangangi ninji yalunya yajinyi marda dungalanyi. Ngala kardardakiyi wajba yajinyi. Miku ninyiyi yingkawanyi najba waykurri nanda. Kudiyamuku yalungka barrarrakijba, wajbangangi yalunjalu yajinyi. Nulijba yalu yalungi yingkamukuyngka naykanyi, jala yalu wajba yingka yajinyi. Baki nanankardi yalunjalu wajba yajinyi walu yalundu kajamukunyina, barrinani jurjina, baki burrandi barndana. Yalu barrakijarramuku. Wajba yalu yajinyi, nulijbangangi yalu yalungi yingkamukuyngka, waykanyi yalunya yalunginkanyi kunybanyi jangkurranyi. Nanankardi miku janyulu wajba yalunya nanganginkanyi kunybanyi jangkurranyi Kudwanyi. ");
INSERT INTO wrk_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Ngala jaliyi ninji nulijba waykanyi yingka mamanyi baki dungalanyi, baki marda ninjimi kardarda wajba yajinyi. Marda ninjimi ngadijba nanda kunyba yaji jala ninji yabimba. Marda ninjimi miku karu nanda nganyi kandi. Marda ninjimi miku munyajba nanda yingka jingkiykanyi nanda kunyba yaji jali ninji yabimba. ");
INSERT INTO wrk_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Nani barri marda ninjimi wajba yingka yajinyi. Mikuwali yingkawanyi jingkijba, ngawamba Kud. Nyulu najbangka bukamba yaji Kudwanyi. Nyulu najbangka nanda jala ninji yabimba kardarda. Baki nganyi Buwakanya kingkarri, janyulu mirnarrijba muwa nganyi, yabimbangangi ninji yaji kardarda. Miku ninjiyanyi nulijba yalungi waykanyi ninga kunybanyi jangkurranyi. Nanankardi barri, nganyinyi Buwakayu kingkarri, janyulu wajba ninga kunybanyi yajinyi, jaliyi ninji wajba kardarda yajinyi. ");
INSERT INTO wrk_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","Mikujiyi jungku barrinani nanamuku barrakijarramuku, jala nulijba yalungi yingkamukuyngka waykanyi yalunginkanyi kunybanyi jangkurranyi. Mikujiyi jungku barrinani yalu jungku. Yalu karrinjaka burrandi jurjina baki barndana, baki nanaba yalu yanyba mududu nangangi Kudkanyi, nulijbangangi yalu yalungi yingkamukuyngka naykanyi yalunya yanybikanyi mududu Kudkanyi. Yalu nulijba yalungi yingkamukuyngka yanybikanyi kunyba jangkurr yalungi, ngala miku nyuliyi nyulu yanyba kunyba jangkurr yalungi Kud. Yingkamuku jayalu yanyba kunyba jangkurr yalungi, baki nanankardi miku nyuliyi yanyba kunyba jangkurr yalungi. ");
INSERT INTO wrk_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","7","Ngala ninji barri, jala ninji yanyba mududu nangangi Kudkanyi, baki mikujiyi muningka yanyba nangangi. Mikujiyi muningka yanyba nangangi yurrngumba barri. Nani barri yalili yanyba ngurranyimuku. Ngala jilajbakiyi kalawunyi nganyinyina barndana. Jungkukiyi nanaba ninjuman baki nanabakiyi yanyba mududu nangangi nganyingkanyi Buwakaya kingkarri. Miku ninjiyi najba Buwakanya Kingkarri, ngala yuku nyulu najbangka ninya kingkarrinya. Yurrngumba ninya najbangka, baki nanankardi janyulu wajba ninya kunybanyi yajinyi. Janyulu wajba ninga nanankanyi jala ninji ngajaka yajinyi. ");
INSERT INTO wrk_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Mikujiyi jungku barrinani yalu jala yalu miku jingkijba Kud. Ngamu nyulu mankuka yalungi jangkurr Kudwanyi, ngawamba jala yalu yurrngumba yanyba mududu nangangi Kudkanyi. Mikujiyi jungku barrinani yalu. Mikujiyi yanyba mududu nangangi barrinani yalu yanybaka. Nganyinyi Buwakayu nyulu jingkijbangka nanda yaji jala ninji nulijba. Nyulu jingkijba nanda yaji, waluwa ninji ngajaka Buwakanya nanankanyi yajinyi. ");
INSERT INTO wrk_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Ngala jala ninji yanyba mududu nangangi Kudkanyi, baki marda ninjimi yanyba nayi barri. ‘Buwakanya Kingkarri, ninji nurrungi Buwakanya jala ninji jungkuka lalijina. Nurru wajbangka ninga nurrunginkanyi kunybanyi jangkurranyi. Ninji barri kudukudu. ");
INSERT INTO wrk_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Ninji barri lalanbawarr nurrungi. Ninji lalanbaka nurrunya, nganyinmuku jandanyimuku. Nurru nulijbangka yalungi, bukambijuyngka wandijiyana, yalu yabimbikanyi nanda jala ninji nulijba yalungi yabimbikanyi yaji. Nani barri yalu yabimbaka yaji Yanjilmukunyi. Yalu yabimbaka nanda jala ninji nulijba yalungi yabimbikanyi yaji. ");
INSERT INTO wrk_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Nurru ngajaka ninya, janinji wajba nurrunya mamanyi yurrngumba, baki miku nurriyi birrkalijba. ");
INSERT INTO wrk_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Nurru ngajaka ninya, janinji manjamanjamba nurrungi balki yaji, jali nurru yabimba. Nurru manjamanjambaka nanda balki yaji jali yalu yabimba nurrunya yingkamukunyi, baki nani barri janinji manjamanjamba nurrungi balki yaji. ");
INSERT INTO wrk_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Mikujiyi balanja nurrunya kudanyu barri, ngala marrimbakiyi nurrunya mardarda nanamunanyi balkinanyi wuwarrnanyi Sayidinanyi. Marrimbakiyi nurrunya mardarda, baki miku nurrunyiyi wudumba Sayidinwanyi.’ Barriwa. Nani barri marda narrimi yanyba mududu nangangi Buwakaya Kingkarri. ");
INSERT INTO wrk_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Jala narri manjamanjamba nanda balki yaji jali yabimba yingkawanyi narringi, baki narringinyi Buwakayu janyulu nyulu manjamanjamba narringi balki yaji marda. ");
INSERT INTO wrk_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Ngala jaliyi narri miku manjamanjamba nanda balki yaji jali yabimba yingkawanyi narringi, baki nani barri marda miku janyulu nyulu manjamanjamba narringi balki yaji marda Buwakayu Kingkarri. Barriwa.” ");
INSERT INTO wrk_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","17","Kudiyana barri jali yalu nulijba Jumuku jungunkanyi kunyba nangangi Kudkanyi, baki miku yaliyanyi jarrba mama. Miku yaliyanyi jarrba mama, yiningki yingamalina kambana, yiningki marndakaja. Nani barri yalili jungku miku jarrkanyi mama, jalili yalu nulijba jungunkanyi kunyba nangangi Kudkanyi. Barriwa. Mili barri milidimbayi nanganginmuku kandimuku Jisuswanyi. Yanyba nyuli, “Jala ninji jungku miku jarrkanyi mama, baki marda ninjimi jungku kunyba wali. Ngala kudiyamuku jala yalu jungku miku jarrkanyi mama, baki yalu jungku balki wali. Miku yalungkimi wakardaba mankanyi, ngala yalu jungku jambayudi mankanyi baki nyungka, baki jambayudi jumbala. Nani yalu jungku, nulijbangangi yalu yalungi yingkamukuyngka, yalu jingkiykanyi yalunya, miku yalimi jarrba mama nanamanji. Yalu nulijba yalungi jingkiykanyi nani yalunya. Ngala narri barri, jaliyi narri jungku miku jarrkanyi mama, baki miku narriyi jungku barrinani yalu. Wakardaba narringkaja mankanyi. Kunymamba narringkaja nyungka. ");
INSERT INTO wrk_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","Baki yingkamukunyi jayalu miku jingkijba narrinya, narri jungku miku jarrkanyi mama. Jayalu miku jingkijba narrinya, narri nulijba jungunkanyi kunyba nangangi Kudkanyi. Ngala narringinyi Buwakayu janyulu jingkijba nani narringi. Janyulu jingkijba, narri jungunkanyi miku jarrkanyi mama, narri nulijba jungunkanyi kunyba nangangi. Nyulu najbangka narrinya yurrngumba barri, nyulu najbangka nanda jala narri kardarda yabimba, baki janyulu yabimba kunyba yaji narringi baku barri. Barriwa. ");
INSERT INTO wrk_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","“Marda narrimi miku nulijba wudumbikanyi kaja yaji yurrngumba barri. Marda narrimi miku dalburrijba kudukudu yaji narringinmirra, barrinani dungala, barrinani jumbala, baki mama. Narringi kaja jumbala, jayalu balkijba baku barri. Baki yiningki janyulu maninjakujba narringi dungala yingkawanyi, jaliyi narri dalburrijba kudukudu yaji. ");
INSERT INTO wrk_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","21","Jaliyi narri nulijba wudumbikanyi kaja yaji, baki janarringka mankumanku wudumbikanyi nanda yaji yurrngumba barri, ngala miku janarringka mankumanku nangangi Kudkanyi. Janarri nulijba mili yajinyi baki mili yajinyi yurrngumba barri, ngala miku janarri nulijba nangangi Kudkanyi. Ngala marda narrimi nulijba yabimbikanyi kunyba yaji. Marda narrimi nulijba yabimbikanyi kaja kunyba yaji nangangi Kudkanyi, baki yalungi yingkamukuyngka. Marda narrimi wajba yalunya yajinyi, jala yalu jungku mikuyaji yajinyi. Marda narrimi wajba yalunya narringinkanyi kunybanyi jangkurranyi. Jaliyi narri yabimba kunyba yaji nani barri, baki mikuwali yingkawanyi maninjakujba nanda kunyba yaji. Jaliyi narri nulijba yabimbikanyi kunyba yaji nani barri, baki narringka mankumanku nangangi Kudkanyi, narri nulijbangka jungunkanyi kunyba nangangi marda. Barriwa. ");
INSERT INTO wrk_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","23","Jaliyi narri jingkijba nanda kunyba yaji narri yabimbikanyi, baki narri yabimba nanda kunyba yaji, baki nanda kunyba. Ngala jaliyi narri jingkijba nanda kunyba yaji narri yabimbikanyi, ngala miku narrimi yabimba nanda kunyba yaji, ngala narri yabimba balki yaji, baki nanda balki, balkimirra. Barriwa. ");
INSERT INTO wrk_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","Mikukimi nganinyiwanyi waki kujarrayngka mambukanyi. Jalimi nyulu waki kujarrayngka, yingkawanyi karuja nanda nganinyi yabimbikanyi yingka yaji, ngala yingkawanyi karuja nganinyi yabimbikanyi yingka yaji. Wanyi yaji janyulu yabimba. Miku nyuliyi waki kujarrayngka mambukanyi. Janyulu maruka muwa yingkanyi, baki janyulu yurlwa yingkanyi. Baki nani barri miku narriyi waki wudumbikanyi kaja yaji narringi, baki malumba narri waki nangangi Kudkanyi. Jaliyi narri waki wudumbikanyi kaja narringi yaji, baki miku narriyi waki nangangi Kudkanyi. Barriwa. ");
INSERT INTO wrk_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","Wabula ngayi karu narrinya, marda narrimi miku balkijba muwa wudumbikanyi mama marda wabuda, baki jumbala ngarambikanyi mankanyi. Marda narrimi miku balkijba muwa nanankanyi yajinyi. Ngala jaliyi narringka mankumanku nangangi Kudkanyi, jaliyi narri nulijba jungunkanyi kunyba nangangi, baki wakinkanyi nangangi, baki janyulu lalanba narrinya. Janyulu nyulu wajba narrinya mamanyi baki wabudanyi baki jumbalanyi. ");
INSERT INTO wrk_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Mankumanku narringka julakinyi. Mikukimi julakiwanyi yarrijba yami jambana. Mikukimi jardiykunumba nangangi mama. Miku nyulimi dalburrijba kaja mama bakunyi. Mikukimi yabimba yaji nani julakiwanyi, ngala nyulu lalanbaka nanda julaki narringinyi Buwakayu Kingkarrinya. Nyulu lalanbaka nanda julaki, baki nani barri nyulu lalanbaka narrinya marda. Narri barri mili walkurra julakinyi, baki nanankardi janyulu kudanyu lalanba narrinya barri. ");
INSERT INTO wrk_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Jaliyi narri balkijba muwa narringinkanyi mamanyi baki jumbalanyi, baki janarri kuna jungku yurrngumba malbungujba mankanyi. Janarri kuna malbungujba mankanyi, balkijbangangi narri mamanyi baki jumbalanyi. Miku barri. Miku narriyi jungku yurrngumba, balkijbangangi narri muwa yajinyi. ");
INSERT INTO wrk_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","Wanyingkanyi narri balkijba muwa jumbalanyi. Ningkijba narri nayinda kaja jal, jala jardijba karnbana. Miku yalimi balkijba muwa jumbalanyi. Miku yalimi yabimba jumbala yalungi. Miku yalimi waki wudumbikanyi dungala, mamanyi marda jumbalanyi. Ngala yalu kunybamirra ngambala naykanyi yalunya nanda jal. ");
INSERT INTO wrk_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Nanda wankalanyi mambuka niji Sulumun, kaja nangangi yaji. Kaja kunyba jumbala nangandu. Ngala miku nangangi jumbala kunybamirra, ngambala naykanyi yalunya, barrinani nayinda kaja jal, yalu kunybamirra ngambala naykanyi yalunya. Nanda jal mili kunyba nanganginkanyi jumbalanyi Sulumunkanyi. ");
INSERT INTO wrk_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Nayinda karnba jalyudi, nyulu lalanbaka yalunya Kudwanyi. Jardijbangka karnba janjawala, ngala nyulu dukujbaja jala wurarawala. Ngawamba jungkuka karnba marndakaja, baki yajbaja karnba janguwanyi. Ngala narri barri, narri mili walkurra karnbanyi. Nyulu lalanbaka karnba Kudwanyi, baki marda narrimi jingkijba Kud, nyulu lalanbaka narrinya marda. Marda narrimi jingkijba Kud, janyulu wajba narrinya narringinkanyi yajinyi. ");
INSERT INTO wrk_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Marda narrimi miku balkijba muwa narringinkanyi yajinyi. Marda narringkimi miku mankumanku nayi, ‘Mikuyaji mamanyi ngakindu munganawayngka, mikuyaji jumbalanyi. Yanka jangayu wudumba mama, baki nyanyalu. Yanka jangayu wudumba jumbala.’ ");
INSERT INTO wrk_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Nanamuku jala yalu miku jingkijba Kud, nani barri yalu jungku. Nani barri yalu balkijba muwa yalunginkanyi yajinyi. Ngala narringinyi Buwakayu Kingkarri nyulu jingkijbangka nanda yaji jala narri nulijba. Nyulu lalanbaka narrinya. Janyulu nyulu wajba narrinya nanankanyi yajinyi jala narri nulijba. ");
INSERT INTO wrk_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Marda narringkimi miku mankumanku narringinkanyi yajinyi, ngala marda narringkimi mankumanku nangangi Kudkanyi. Nyulu lalanbawarr narringi. Marda narrimi yanyba kunyba jangkurr nangangi. Marda narrimi ngajaka Kud, yanka janarri waki nangangi. Jaliyi narringka mankumanku nangangi Kudkanyi nani barri, baki nyuluja lalanba narrinya. Nyulu jingkijbangka narrinya jala narri mikuyaji mamanyi, mikuyaji jumbalanyi, baki janyulu nyulu lalanba narrinya. ");
INSERT INTO wrk_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Nanankardi barri marda narrimi miku balkijba muwa munganawayngka yajinyi. Yiningki badajbaja kiji narrindurri munganawa. Marda narrimi miku balkijba muwa nanankanyi kijinyi, jalija badajbawali munganawa. Marda narrimi miku balkijba muwa munganawayngka yajinyi.” Barriwa. Nani barri milidimbayi yalunya Jisuswanyi jali yalu jungku yundu kulawirana. ");
INSERT INTO wrk_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","2","Mili barri milidimbayi yalunya Jisuswanyi. “Marda narrimi miku dulu jurlwa yalungi yingkamukuyngka. Marda narringkimi miku dulu yanyba, ‘Nanda nganinyi nyulu balki. Miku nyulimi durrijba Kud. Nyulu yabimbaka balki yaji.’ Marda narringkimi miku dulu yanyba nani nangangi. Marda narrimi mankuwa Kud, baku barri janyulu karrinjarrijba narrinya walu nangandu, baki janyulu yanyba narringinkanyi balkinyi yajinyi jala narri yabimba. Jaliyi narri dulu jurlwa yalungi, baki janyulu nyulu dulu jurlwa narringi marda Kud. Janyulu dulu jurlwa narringi, jalija narri karrinja walu nangandu. Jaliyi narringka yanyba balki jangkurr yingkanyi, baki janyulu Kud yanyba balki jangkurr narringi, jalija narri karrinja walu nangandu. Nanankardi marda narrimi miku dulu jurlwa yingkanyi. ");
INSERT INTO wrk_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","5","Wanyingkanyi narri mankumankuwa nanda balki yaji jali nyulu yabimba, ngala narri mamanumba nanda balki yaji narringi jali narri yabimba. Nanda barrinani muningka yanyba nanankanyi yingkanyi, ‘Ninji barri, nanda bayakarda yaji barrinani nanda dilwil nganyinyina yamina. Jangayu dulaba nanda dilwil nganyinbunanyi yaminanyi.’ Nani ninji yanyba nangangi, ngala miku ninjimi jingkijba, nanda walkurra yaji barrinani nanda walkurra jakuwanda nganyinyina yamina, baki miku ninjiyi najba yaji kudanyu dulaykanyi dilwil nanganbunanyi yaminanyi. Nanda bayakarda yaji nanganginyina yamina, nanda barrinani balki yaji jali nyulu yabimba, ngala nanda walkurra yaji nanganginyina yamina, nanda barrinani kaja balki yaji jali ninji yabimba. Ninji jurlwangka nangangi, nanankanyi nanganginkanyi balkinyi yajinyi, ngala miku ninjimi mankuwa nanda kaja balki yaji, jali ninji yabimba. Ninji jurlwa nangangi nanganginkanyi balkinyi yajinyi, ngala miku nganyingka mankumanku nganyingkanyi balkinyi yajinyi. Nanda balki. Waluku barri marda ninjimi mankuwa nganyi balki yaji. Marda ninjimi ngindu muwa nganyingkanyi balkinyi yajinyi, baki janyulu manjamanjamba nganyi balki yaji Kudwanyi. Baki yuku barri janinji karu nanda yingka nanganginkanyi balkinyi yajinyi. ");
INSERT INTO wrk_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","Miku narrimi wajba bajangu malabanyi yajinyi. Miku. Yiningki janinya bijba ninya. Baki miku narrimi wajba bikibiki dungalanyi, yurlwangangi janyulu bikibiki nanankanyi dungalanyi, yarrijbangangi janyulu dungala jambana. Baki nani barri nanamuku jala yalu ngirra Kud, marda narrimi miku milidimba yalunya malabanyi yajinyi. Marda narrimi miku milidimba yalunya nangangi Kudkanyi. Jayalu miku manku narringi jangkurr. Yalu balkimirra nangangi. Miku yalimi nulijba nangangi Kudkanyi. Yalu barrinani bajangumuku. Miku yalimi nulijba malabanyi yajinyi. Yalu barrinani bikibikimuku. Yalu yurlwangka nanganginkanyi yajinyi Kudkanyi. Barriwa. ");
INSERT INTO wrk_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","8","Jaliyi narri nulijba yajinyi, baki marda narrimi ngajaka Kud nanankanyi yajinyi, baki janyulu wajba narrinya nanankanyi yajinyi. Jaliyi narri nulijba jingkiykanyi yaji, marda narrimi ngajaka Kud, baki janyulu karu narrinya nanankanyi yajinyi Kudwanyi. Jaliyi narri nulijba jingkiykanyi Kud, baki marda narrimi ngajaka Kud, baki janyulu minimba narrinya jungunkanyi yurlurrmba nangangi. ");
INSERT INTO wrk_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Jaliyi ninya ngajaka mamanyi nganyinyi jandanyiwanyi, baki wanyingkanyi janinji wajba. Janinji kuna wajba dalunyi. Miku ninjiyi wajba dalunyi. ");
INSERT INTO wrk_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Jaliyi ninya ngajaka kakunyi, baki wanyingkanyi janinji wajba. Janinji kuna wajba miyanyi. Miku ninjiyi wajba miyanyi. ");
INSERT INTO wrk_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Narri balkimuku, ngala narri wajba narringi jandanyi mamanyi jala narrinya ngajaka. Ngala Kud, nyulu kunybamirra, baki janyulu wajba narrinya nanankanyi kunybanyi yajinyi jala narri ngajaka nanankanyi yajinyi. Narringinyi Buwakayu Kingkarri, janyulu wajba narrinya nanankanyi jala narri nulijba. ");
INSERT INTO wrk_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Narri nulijba yingkamukuyngka, yalu yabimbikanyi kunyba yaji narringi, baki nani barri, marda narrimi yabimba nanamannga kunyba yaji yalungi. Nani barri milidimbaka narrinya yuwawanyi Musiskanyi yabimbikanyi nanamannga kunyba yaji. Baki nanamuku wankalamuku jali yanyba jangkurr nangangi Kudkanyi, yalili marda milidimba narrinya nanamannga jangkurranyi. Barriwa. ");
INSERT INTO wrk_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","14","Ngayu karungka narrinya, nanda yubal jala karralangka wayka nanankurri jangurri Yilyurri, walkurra nanda yubal. Bulidarri nanda yubal, yurlurrmba wayka Yilyurri. Damarldamarl nanda yubal jilaykanyi wayka, baki kajamuku yalu jilalajba nananyina yubalina. Kajamuku yalu jilalajba nanankurri Yilyurri. Ngala marda narrimi miku jilajba nanawa. Marda narrimi jilajba yingkana yubalina jala kirrijba kingkarri nangandurri Kudyurri. Bayakarda nanda yingka yubal, dungalayudi, balki. Ngawamba kujajarra yalu jilalajba nananyina yubalina. Ngawamba kujajarranyi yalu durrijba nanda yuwa nangangi Kudkanyi, yalu jungkuka yurlurrmba nangangi, baki jayalu mili jungku wanka nangandu kingkarri yurrngumba barri. ");
INSERT INTO wrk_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","Marda narrimi najbawa yalunya balkimuku milidimbawarrmuku. Yalili yanyba, yalu milidimbaka narrinya jangkurranyi Kudkanyi, ngala miku. Yalu jujambawarr. Nanda jib nyulu kulukulu, miku nyulimi bijbawarr, ngala nanda warrki, nyulu bijbawarr. Nanamuku jujambawarrmuku, yalu yanyba kulukulu jangkurr, baki ngamu yalu kunybamuku milidimbawarrmuku, ngamu yalu jungku kulukulu barrinani jib, ngala miku. Ngala yalu jungku barrinani nanda warrki jala bijbawarr. Miku yalimi yanyba duja jangkurr nangangi Kudkanyi. Barrinani nanda, yalunginyi jangkurrwanyi bijbangka narrinya. Jayalu yabimba kiji narringi. Jaliyi narri kuyu yalungi jangkurr, baki janarri miku jungku yurlurrmba nangangi Kudkanyi. ");
INSERT INTO wrk_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Ngala yanka barri janarri jingkijba yalunya, yalu jujambawarrmuku. Yanka janarri jingkijba yalunya. Janarri najba nanda jala yalu yabimba. Miku yalimi yabimba kunyba yaji nangangi Kudkanyi, ngala yalu jungkuka balki nangangi. Miku yalimi durrijba nangangi yuwa. Miku yalimi yabimba kunyba yaji yalungi yingkamukuyngka, ngala yalu yabimba balki yaji yalungi. Nani barri janarri jingkijba yalunya jujambawarrmuku. Nanamuku jujambawarrmuku, yalu barrinani nyilanyila. Mikukimi nyilanyila jardijba jirdi mamanyi. Baki nanamukunyi jujambawarranyi miku yalimi milidimba kunyba jangkurr, ngala yalu milidimba jujambawarr jangkurr. Ngala nanda kalawanyi jardijbangka jirdi kunybanyi mamanyi. Nanamuku jala yalu durrijba Kud, yalu barrinani nanda kalawanyi. Baki yalungi kunyba jangkurr barrinani nanda kunyba mama kurndana. Barriwa. ");
INSERT INTO wrk_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Nanda kunyba kurnda jardijbangka walkurra, kudukudu mama nangandu, kunyba jarrkanyi. Ngala nanda balki kurnda jardijbangka madil, baki ngawamba bijal mama nangandu, baki balki jarrkanyi nanda mama. ");
INSERT INTO wrk_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Nanda kunyba kurnda, mikuyaji balkinyi mamanyi nangandu. Ngala nanda madil kurnda, mikuyaji kunybanyi mamanyi nangandu. ");
INSERT INTO wrk_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Baki nanda lalanbawarr kurndanyi barri, janyulu daya nanda madil kurnda, baki janybaja jangurri. Nanamuku balkimuku milidimbawarrmuku, yalu barrinani nanda balki kurnda, jala mikuyaji kunybanyi mamanyi nangandu. Miku kunyba yalungi jangkurr. Janybaja nanda balki kurnda jangurri lalanbawarranyi, baki nani barri janyulu janyba yalunya Kudwanyi. Janyulu janyba yalunya jangurri Yilyurri. ");
INSERT INTO wrk_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Nani barri janarri jingkijba yalunya, balkimuku milidimbawarrmuku jujambawarrmuku, mikungangi yalimi durrijba yuwa nangangi Kudkanyi, ngala yalu yabimba balki yaji. Ngala janarri jingkijba yalunya jala yalu durrijba Kud. Janarri jingkijba yalunya, yabimbangangi jayalu kunyba yaji, milidimbangangi jayalunjalu nanganginkanyi jangkurranyi Kudkanyi. Barriwa. ");
INSERT INTO wrk_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","Kajamuku yalu yanyba ngaki, ngayu yalunginkanyi mambukanyi. Yalu yanyba, ‘Ninji ngaki mambuka. Jangayu ngayangayijba nganyingkanyi jangkurranyi.’ Nani yalu yanyba, ngala kudiyamuku yalungi miku yalimi ngayangayijba ngakinkanyi jangkurranyi. Miku yalimi yabimba nanda jala nyulu nulijba yalungi yabimbikanyi Buwakanya Kingkarri. Miku yalimi yabimba nangangi yaji. Miku ngayimi dujanya yalungi mambuka. Miku jangayu lalanba yalunya. Ngala kudiyamuku, yalu ngayangayijba ngakinkanyi jangkurranyi, yalu yabimba nanda jala nyulu nulijba yalungi yabimbikanyi Buwakanya Kingkarri. Dujanya ngayu yalungi mambuka. Jangayu lalanba yalunya. Ngawamba yaluja jungku mili wanka nangandu kingkarri. Ngawamba yaluja jungku wanka nangandu yurrngumba barri. ");
INSERT INTO wrk_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Baku barri janyulu karrinjarrijba yalunya Kudwanyi, jarrbalambikanyi yalunya, kudiya kingkarri jungunkanyi nangandu, ngala kudiya wayka Yilnyina. Janyulu karrinjarrijba bukambiju yalunya walu ngakindu, baki jangayu yanyba yalungi. Nanamanji barri kajamuku jayalu yanyba ngaki, ‘Mambuka. Nurrili milidimba yalunya nanganginkanyi jangkurranyi Kudkanyi. Nurrili manjijba kaja wuwarr yalunbunanyi mankanyinanyi, ninjingangi. Kaja ngiruka yaji nurrili yabimba nganyi.’ Nani barri jayalu yanyba ngaki. ");
INSERT INTO wrk_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Ngala jangayu yanyba yalungi, ‘Miku ngayimi jingkijba narrinya. Miku narrimi ngakinmuku kandimuku. Narri jujambawarrmuku. Barriwa narri barlba ngakinbunanyi, narri balkimuku.’ Nani barri jangayu yanyba yalungi, jalili yalu miku waki ngaki. Miku yaliyanyi durrijba ngaki jangkurr. Miku yaliyanyi ngayangayijba nangangi ngakinkanyi Buwakaya Kingkarri. Barriwa. ");
INSERT INTO wrk_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","25","Jangayu muningka karu narrinya nanginkanyi jangkurranyi. Yabimbayi barrawu nganinyiwanyi. Yabimba nyuli ngiruka barrawu. Nanda nganinyi nyuli jingkijbawarr. Jungku nyuli kunyba kulaji, baki yabimba nyuli nanda barrawu yundu kunybana yajina, yundu dungalana yajina yabimbikanyi barrawu. Baki janjawala barri, warrmbayi yaji yunkurrwanyi. Warrmbayi karrina kudanyu barri. Yirrbayi walkurra janja, baki wirlkuyi mali. Ngala mikukiyanyi dalyamba nanda barrawu yunkurrwanyi. Ngala mikukiyanyi dalyamba nanda barrawu maliwanyi. Jungkuyi nanda barrawu ngiruka yurrngumba. Mikukiyanyi dalyawijba nanda barrawu, jungkuyingangi ngiruka yundu kunybana yajina. Baki narri barri, jaliyi narri manku ngaki jangkurr, baki ngayangayijba ngakinkanyi jangkurranyi, baki janarri jungku ngiruka ngaki. Janarri jungku ngiruka barrinani nanda ngiruka barrawu jali mikukiyanyi dalyawijba. Jala yingkamukunyi yalu yabimba kiji narringi, jala yalu linjumba narrinya, jala yalunjalu karu balkinyi jangkurranyi narringi, yalu barrinani nanda yunkurr baki janja baki mali. Jayalu yabimba walkurra kiji narringi, ngala miku narringkiyi yangkalamba ngakinbunanyi. Yuwajiwa janarri jungku ngiruka ngaki, marrimbangangi narri ngaki jangkurr narringinyina kurduluna. Barriwa. ");
INSERT INTO wrk_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","27","Ngala yingka barri nyuli nganinyi mudu. Yabimba nyuli barrawu, ngala miku yundu kunybana jambana, ngala yabimba nyuli barrawu yundu jundurrjundurrina yajina, bundu bundalina. Baki janjawala barri, warrmbayi yaji kudanyu yunkurrwanyi, baki yirrbayi walkurra janja. Wirlkuyi mali, baki dalyawijbayi nanda nangangi barrawu bukamba. Mikuyaji barrawunyi barri nangangi. Baki nani barri, jaliyi narri miku kuyu ngaki jangkurr, jaliyi narri miku ngayangayijba ngakinkanyi jangkurranyi, baki narri jungkuka barrinani nanda barrawu dalyawijba jali. Jala yingkamukunyi yalu yabimba kiji narringi, jala yalu linjumba narrinya, jala yalunjalu karu balkinyi jangkurranyi narringi, baki miku narriyi jungku ngiruka ngaki. Ngala janarringka yangkalamba ngakinbunanyi, mikungangi narrimi jungku ngiruka ngaki, mikungangi narrimi marrimba ngaki jangkurr narringinyina kurduluna.” Barriwa. ");
INSERT INTO wrk_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Nani barri milidimbayi yalunya muran Jisuswanyi. Baki manmala yali nanganginkanyi jangkurranyi jali nyulu milidimba yalunya. Manmala yali kudanyu barri. ");
INSERT INTO wrk_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Miku nyuliyanyi milidimbawarr barrinani yalu jalili milidimba nanda wankalanyi yuwa nangangi Musiskanyi. Yinini nyuli milidimbawarr. Nyuli milidimbawarr barrinani walkurra mambuka. Nanankardi yali manmala nangangi. ");
INSERT INTO wrk_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Karrala yali wayka kulawirananyi Jisus baki nanganginmuku kandimuku. Karrala yali wayka, baki yalunjali durrijba muramukunyi. ");
INSERT INTO wrk_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Badajbayi nganinyi nangandurri Jisusyurri. Nanda nganinyi ngujbulijba nyuli nangangi waban bukamba. Yingkamuku yalili marrala nanankanyi nanganginkanyi ngalyanyi. Mikukiyanyi kunybijba mankanyi. Jiwilijbayi nanda ngalya nangandu, baki janangka janyba baku barri. Nanankardi barri kudanyu yalili marrala nanankanyi ngalyanyi. Jilajba nyuli nangandurri Jisusyurri, baki mururu nyuli wayka mujina nangandu Jisusnyina, baki yanybayi nangangi, “Mambuka, jaliyi ninji nulijba ngaki kunymambikanyi nganinji mankanyi, baki yuku ninji kunymamba ngaki mankanyi.” Barriwa. ");
INSERT INTO wrk_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Manjijba nangki marni Jisus nangandurri, baki marrimbayi nanda nganinyi. Baki yanybayi Jisus nangangi, “Ngayu nulijbangka nganyi kunymambikanyi nganyi mankanyi. Kunybakiyi jungku mankanyi.” Baki yinarramba kunybijbayi nangangi mankanyi. Kunybijbayi. ");
INSERT INTO wrk_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Baki jirrinybayi nanda nganinyi Jisuswanyi, maramaramba nyuli, “Mikujiyi karu yalunya yingkamuku jali ngayu kunymamba nganyi mankanyi. Mikujiyi karu yalunya. Ngala jilajbakiyi nangandurri nanankurri mambukarri jurjkanyi. Minimbakiyi nganyingka mankanyi nangangi, baki muningka wajbakiyi Kud barnyinyi. Nani barri yanybayi nanda wankalanyi Musis, muningka waykanyi Kud barnyinyi. Jayalu wajba Kud barnyinyi, jalija kunybijba mankanyi. Nanankardi barri janinji wajba kud barnyinyi, baki yingkamukunyi jayalu jingkijba ninya, ninji mirnarrijba nangangi muwa Kudkanyi, kunybijbangkangangi nganyi mankanyi.” Barriwa. Nani barri jirrinybayi nganinyi Jisuswanyi. Barriwa. ");
INSERT INTO wrk_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Baki wijbayi Jisus bayungu. Wijba nyuli nanankurri barrawuyabarrawuyarri, niji Kabirnayum. Jali nyulu wanbiya, baki jilajbayi nganinyi nangandurri. Nanda nganinyi, miku nyuliyanyi mungkiji nangangi Jisuskanyi. Nyuli ngurranyi. Nyuli mambuka yalungi ngarrkadabawarrmukungka, yalungi yaji Rum. Jilajba nyuli nangandurri Jisusyurri, baki kudanyu nyuli ngajaka Jisus, ");
INSERT INTO wrk_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","“Mambuka, ngaki wakiwarr, nyulu lunjika. Lunjika nyulu kudanyu barri. Miku nangkimi ngirringirrimba mankanyi. Kudanyu nyulu lunjika barri.” ");
INSERT INTO wrk_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Jananganjayi mambuka Jisuswanyi, “Jangayu jilajba nganyindu. Jangayu kunymamba nangangi mankanyi.” ");
INSERT INTO wrk_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Ngala jananganjayi mambukawanyi, “Miku barri. Ninji walkurra mambuka. Miku ninjiyi jilajba ngakindurri barndarri. Jaliyi ninji muningka yanyba jangkurr, kunymambikanyi nangangi mankanyi, baki ngayu jingkijba, janyulu kunybijba mankanyi. Ngala mikujiyi jilajba ngakindurri barndarri, walkurrangangi ninji mambuka. ");
INSERT INTO wrk_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Ngayu mambuka yalungi ngarrkadabawarrmukuyngka, baki yingkamuku yalu mili walkurra ngaki, yalu ngakinmuku mambukamuku. Jala ngayu jirrinyba ngaki ngarrkadabawarr, nyulu jilaykanyi karri, baki janyulu ngayangayijba ngakinkanyi jangkurranyi, janyulu jilajba karri. Jala ngayu jirrinyba yingka ngarrkadabawarr, nyulu jilaykanyi ngakindurri, baki janyulu jilajba ngakindurri. Jala ngayu jirrinyba yingka yabimbikanyi yaji, baki janyulu yabimba nanda yaji. Nani barri ngayu mambuka ngakinmukuyngka ngarrkadabawarrayngka. Baki nani marda ninji barri mambuka kunymambikanyi mankanyi. Jaliyi ninji yanyba jangkurr kunymambikanyi nangangi mankanyi, ngaki wakiwarr, baki ngayu jingkijba, janyulu kunybijba mankanyi.” Nani barri yanybayi nanda mambuka nangangi Jisuskanyi. ");
INSERT INTO wrk_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Jali manku nangangi jangkurr Jisuswanyi, baki manmala nyuli. Kudanyu nyuli manmala, baki yanyba nyuli yalungi muranyi nangandu, “Ngayu karungka narrinya. Nayinda mambuka, miku nyulu ngaki mungkiji, nyulu ngurranyi ngaki. Nangangi yaji juju bayangarri, niji Rum, ngala ngana nyulu jingkijbangka kudanyu. Nyulu kuyungka ngaki jangkurr. Miku yingamali ngakinyi mungkijiwanyi kudanyu kuyungka ngaki jangkurr barrinani nyulu kuyungka ngaki jangkurr. Ngana nyulu jingkijba kudanyu barri. ");
INSERT INTO wrk_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Kudanyu ngayu karungka narrinya. Kajamuku ngurranyimuku jayalu badajba lukulukunanyi, karrina baki bayunguna, langina baki kulani. Jayalu badajba, baki jayalu kuyu ngaki jangkurr. Baki baku barri jayalu jungku kingkarri nangandu Kudnyina. Jayalu jungku yalundu marda wankalamukunyina jali kuyu nanda jangkurr nangangi Kudkanyi, jali durrijba nangangi jangkurr. Jayalu jungku yalundu marda ngamanginyina wankalanyina mungkijimukunyina, barrinani Yabrayam, baki Yayisak, baki Jakub. Kajamukunyi ngurranyimukunyi jayalu kuyu ngaki jangkurr, baki jayalu marda jungku kingkarri yalundu. ");
INSERT INTO wrk_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Ngala kajamuku mungkijimuku ngambalangi Jumuku, miku jayalu jungku kingkarri yalundu, mikungangi yaliyi kuyu ngaki jangkurr. Baki miku janyulu lalanba yalunya Kudwanyi, ngala janyulu manjijba yalunya nanankurri Yilyurri. Baki nanamanji barri jayalu balkijba muwa. Kudanyu barri jayalu ngindu muwa, mikungangi nyuliyi lalanba yalunya nanamanji Kudwanyi.” Barriwa. Nani yanybayi Jisus yalungi muranyi. ");
INSERT INTO wrk_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Baki mili yanybayi Jisus nangangi mambukanyi, “Wijbakiyi nganyindurri barndarri. Janyulu kunybijba mankanyi nganyi wakiwarr. Jangayu kunymamba nangangi mankanyi, kuyungangi ninji ngaki jangkurr.” Barriwa. Baki kunybijbayi nanda wakiwarr mankanyi nanamanji jali yuwajiwa yanybayi Jisus mambukanyi. Barriwa. ");
INSERT INTO wrk_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Baku barri jilajbayi Jisus nanganginkurri barndarri Bidanyi. Ngankijba nyuli kalawunyi barrawuna baki najba nyuli bardibardi jalyuna. Nanda bardibardi nyuli ngunyarringanja nangangi Bidanyi. Lunji nyuli kudanyu barri. Ngarrangarra nyuli mankanyi. ");
INSERT INTO wrk_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Marrimbayi bardibardi marni Jisuswanyi, baki yinarramba kunybijbayi mankanyi nanda bardibardi. Mardumardu mankanyi. Walajba nyuli, baki wudumbayi mama yalungi. Barriwa. ");
INSERT INTO wrk_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Ngabungaburri barri, ngala nyulu bijal mungarri yaji, baki kuyu yalunjali nangandurri Jisusyurri. Kuyuyi yalunya kajamuku nangandurri Jisusyurri. Kajamuku yali wuwarryudi, baki yanybayi Jisus yalungi wuwarrmukuyngka. Jakajba nyuli wuwarr yalunbunanyi mankanyinanyi. Kunymamba nyuli bukambiju yalunya jali yalu lunji. ");
INSERT INTO wrk_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Nani barri kunymambayi yalunya Jisuswanyi. Nanda wankalanyi niji Yayisaya, jali yanyba jangkurr nangangi Kudkanyi, yarrijba nyuli najana nayi jangkurr Kudkanyi. “Nyuli kunymamba ngambalanya jali ngambala lunji. Nyuli dulaba nanda ngalya ngamanbunanyi mankanyinanyi.” Duja nanda jangkurr jali nyulu yarrijba najana. Kunymambayi yalunya bukambiju Jisuswanyi. Barriwa. ");
INSERT INTO wrk_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Baku barri kajamuku yali nangandu Jisusnyina, walkurra muramuku. Najbayi yalunya Jisuswanyi, baki nulijba nyuli barlkanyi nyulu yalunbunanyi. Baki nyuli jirrinyba yalunya nangangimuku kandimuku, yalu burriykanyi karrurrinybarri kanjana muwardana. Jilajba yali wudumbiji muwarda. ");
INSERT INTO wrk_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Yingamali nanaba nangandu, nyuli milidimbawarr yuwanyi Musiskanyi. Yanyba nyuli nangangi Jisuswanyi, “Milidimbawarr, birrirrinja ngaka jilaykanyi nganyindu. Yurrngumba barri, janga jilalajba nganyindu yingkayurri yajiyurri, baki yingkayurri yajiyurri jalija ninji jilajba.” ");
INSERT INTO wrk_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Jananganjayi nanda nganinyi Jisuswanyi, “Nanda wardaba nyulu kulukangka bardawana jambana, baki nanda julaki kulukangka kurndana. Ngala ngayu, Buwanya Bukambijuyngka, mikuyaji barndanyi ngaki kulukankanyi. Jaliyi ninji jilajba ngakindu yurrngumba, baki mikuyaji barndanyi nganyi marda.” Nani barri jananganjayi nganinyi Jisuswanyi. ");
INSERT INTO wrk_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Baki yingka nganinyi, nyuli kandi nangangi Jisuskanyi. Nyuli yanyba nangangi, “Mambuka, marda ngayu marda nulijba jilaykanyi nganyindu, ngala waluku barri, jangayu wijba ngakindurri barndarri. Jalija nangka janyba ngaki nijanganjinyi, jalija ngayu makaba nangangi mankanyi, baki jangayu wijba nganyindurri, jangayu jilalajba nganyindu yurrngumba.” ");
INSERT INTO wrk_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Ngala jananganjayi Jisuswanyi, “Jilajba janinji ngakindu nanijba barri, baki janinji jungku wanka nangangi Kudkanyi. Ngala yingkamuku jala yalu jungku barrinani kurdan nangangi Kudkanyi, yuku jayalu makaba nganyi nijanganjinyi jalija nangka janyba.” Nani barri jananganjayi Jisuswanyi. ");
INSERT INTO wrk_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Ngankijba yali muwardana, Jisus baki nanganginmuku kandimuku. Barlba yali karrurrinybarri kanjana, muwardayudi. ");
INSERT INTO wrk_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Warrmbayi yunkurrwanyi kudanyu karrina. Lakululumbayi yunkurrwanyi wabuda, baki walajbayi juju kingkarri lakululu. Ngankijbayi wabuda kalawuyngkurru muwardana, baki ngurrulijbawali nanda muwarda. Ngala kulukayi Jisus muwardana. Kuluka nyuli jali warrmba yunkurrwanyi karrina. Ngankijbayi wabuda kalawuyngkurru muwardana, ngala nyuli yuwajiwa kuluka kalawuyngkurru. ");
INSERT INTO wrk_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Yali dulaba Jisus kandimukunyi. Dulaba yali, yanyba yali nangangi, “Mambuka. Miku ninjiyi kuna marrala, ngambalaja ngurrulijba. Marrimbakiyi ngambalanya mardarda.” ");
INSERT INTO wrk_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Jananganjayi yalunya Jisuswanyi, “Wanyingkanyi narri marrala. Wanyingkanyi. Miku kuna nganarriyi jingkijba, jangayu lalanba narrinya. Jalimi nganarri kudanyu jingkijba, baki miku narriyi marrala.” Baki walajbayi Jisus. Walajba nyuli, baki kudanyu yanybayi yunkurranyi marda kanjanyi. Jirrinyba nyuli yunkurr marda kanja jungunkanyi kardarda. Baki kanangurrijbayi yaji, marda yunkurr marda lakululu. ");
INSERT INTO wrk_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Ngala manmala yali nanganginmuku kandimuku. Manmala yali kudanyu barri, baki yanyba yalungki, “Nayinda Jisus, ngiruka nyulu, walkurra. Kardijbayi yunkurr marda lakululu jali nyulu jirrinyba yalunya. Walkurra nyulu.” Nani barri yalungki yanyba nangangi. Barriwa. ");
INSERT INTO wrk_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Mili yali barlba karri, baki kamu yali wanbiya karrurrinybana jambana, nanda yaji niji Kadara. Jali walajba Jisus muwardananyi, baki kujarra nganinyiwuya buli jilajba nangandurri. Jilajba buli nanamunanyi yajinanyi jalili yalu makaba nganinyiyurru baki jibarriyurru, nanaba kumayanguna. Nanankuya nganinyiwuya buli wuwarryudi. Kudanyu buli mudu jali jungku wuwarr bulandu. Yingkamuku nganinyimuku, miku yaliyanyi jilajba yubalina nanaba. Kudanyu yali marrala bulangi. ");
INSERT INTO wrk_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Jilajba buli nangandurri Jisusyurri, baki kaya buli kudanyu nangangi, “Ninji barri jandanyi nangangi Kudkanyi, wanyimba janinji ngalinya. Badajba kuna ninji nanginkurri, daji ngalinya. Nanankanyi kuna ninji jilajba nanginkurri.” Nani buli kaya nangangi. ");
INSERT INTO wrk_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Bundu nanaba wardamba yalungki kajamuku bikibikimuku. ");
INSERT INTO wrk_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Baki yililikajba yali Jisus wuwarrmukunyi. Kudanyu yali yililikajba Jisus, “Jalija ninji manjijba nurrunya bulanbunanyi, baki manjijbakiyi nurrunya yalundurri bikibikimukuyngkurri. Janurru ngankijba nanaba bikibikina.” ");
INSERT INTO wrk_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Jananganjayi Jisuswanyi, “Yuku barri. Ngankijbakiyi bikibikina.” Baki ngankijba yali wuwarrmuku bikibikina. Baki muningka yali wirlku bikibikimuku, muningka yali yirrba wayka wabudana. Yirrba yali wayka karnarrana yajina, baki yali bukambiju ngurrulijba wabudana. ");
INSERT INTO wrk_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Nanamuku lalanbawarrmuku bikibikinyi, wirlku yali kula yalunginkurri barrawuyabarrawuyarri. Wanbiya yali, baki karu yalunjali mungkijimuku yalungi bikibikinyi baki nanankanyi jali yabimba Jisuswanyi. ");
INSERT INTO wrk_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Baki bukambiju nanamuku jali yalu jungku nananyina barrawuyabarrawuyana, yali jilajba nangandurri Jisusyurri. Yalu jalili jungku nananyina yajina, yali ngajaka Jisus, janyulu barlba yalunginbunanyi yajinanyi. Baki barlbayi Jisus baki nanganginmuku kandimuku. Barriwa. ");
INSERT INTO wrk_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Wijba yali bayangarri Jisus baki nanganginmuku kandimuku. Ngankijba yali muwardana baki birlbidamba yali bayangarrinybarri nanankurri yajiyurri niji Kabirnayum. ");
INSERT INTO wrk_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Jali yalu wanbiya nanaba, baki yingkamukunyi yali kuyu nganinyi nangandurri Jisusyurri. Nanda nganinyi nyuli lunji, miku nangkiyanyi ngirringirrimba nangangi mankanyi. Kuluka nyuli yurrngumba jalyuna. Marrimba yali nangangi jalyu. Kuyu yali nanda nganinyi nangandurri Jisusyurri. Najbayi yalunya Jisuswanyi, baki jingkijba nyuli yalunya, nanda nganinyi jali lunji, baki nanamuku jali yalu kuyu nganinyi. Jingkijba nyuli yalunya, mankumanku yalungki nangangi Jisuskanyi, yuku nyulu kunymamba nanda nganinyi jala nyulu lunji. Yuku nyulu kunymamba nangangi mankanyi. Baki yanybayi Jisus nganiyngkanyi jali lunji, “Mikujiyi marrala. Jangayu manjamanjamba nganyi balki yaji. Jangayu manjamanjamba nanda balki jali ninji yabimba.” ");
INSERT INTO wrk_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Ngala kudiyamuku milidimbawarrmuku yuwanyi Musiskanyi, yali nanaba nangandu. Manku yali nangangi jangkurr Jisuskanyi, baki yanyba yalungki, “Nayinda nganinyi nyulu balki. Jungkuka nyulu balki nangangi Kudkanyi. Miku nyuliyi manjamanjamba balki yaji. Ngawamba Kudwanyi yuku nyulu manjamanjamba balki yaji, ngala mikuwali nganinyiwanyi. Nayinda barri nyulu jujambawarr.” Nani barri yalungki yanyba nangangi Jisuskanyi. ");
INSERT INTO wrk_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Ngala jingkijbayi yalunya Jisuswanyi. Jingkijba nyuli nanda jali yalungka yanyba nangangi. Baki yanyba nyuli yalungi, “Wanyingkanyi narringka mankumanku balkinyi jangkurranyi ngaki, yanybangangi ngayi jangkurr manjamanjambikanyi nangangi balki yaji. Wanyingkanyi. ");
INSERT INTO wrk_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Wanyi barri mili jardibirri yaji yabimbikanyi. Manjamanjambikanyi balki yaji kuna, kunymambikanyi nayinda nganinyi mankanyi kuna. Wanyi mili jardibirri yaji yabimbikanyi. ");
INSERT INTO wrk_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Ngayu Buwanya Bukambijuyngka. Nyuli yarrijba ngana walkurra mambuka, miku nganinyiwanyi, ngala Kudwanyi. Baki nyuli karu ngana, yuku ngayu manjamanjamba balki yaji. Jalija nganarri najba kunymambikurri nayinda nganinyi mankanyi, baki janganarri jingkijba, yuku ngayu manjamanjamba nangangi balki yaji marda.” Nani barri yanybayi Jisus yalungi. Baki mili nyuli yanyba nanankanyi nganiyngkanyi jali kuluka jalyuna, “Walajbakiyi waykalinya. Walajbakiyi. Mukulmbakiyi nganyi jalyu, baki wijbakiyi nganyindurri barndarri.” ");
INSERT INTO wrk_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Yinarramba walajbayi nanda nganinyi jalyunanyi. Walajba nyuli, mukulmbayi nangangi jalyu, baki wijbayi nanganginkurri barndarri. ");
INSERT INTO wrk_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Kajamukunyi yali najba nanda jali yabimba Jisuswanyi. Najba yali nanda nganinyi jali mili kunybijba nangangi mankanyi, baki marrala yali. Marrala yali, ngala yali wajba Kud yalunginkanyi kunybanyi jangkurranyi, yabimbangangi nyuli Jisus ngiruka yabimbikanyi ngiruka yaji nangangi Kudkanyi. Barriwa. ");
INSERT INTO wrk_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Kamu barri mili jilajbayi Jisus karri yubalina, baki nanganginmuku kandimuku yali jilajba nangandu. Jilajba nyuli, baki najba nyuli nganinyi, nangangi niji Madiyu. Jungku nyuli barrawuna wakinkanyi. Waki nyulili Kubaminkanyi. Kuyu nyulili dungala yalunbunanyi, waykanyi Kubamin mambuka. Najba nyuli nanda Madiyu jungunkurri barrawuna Jisuswanyi. Baki yanybayi Jisus nangangi, “Jilajbakiyi ngakindu.” Walajba nyuli Madiyu, baki jilajba nyuli nangandu Jisusnyina. ");
INSERT INTO wrk_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Jilajba buli bayungu barndarri nangangi jala barnda Madiyukanyi. Jungkuyi Jisus nanaba. Jarrba nyuli mama nanaba nangandu, baki yali jungku nangandu marda nanganginmuku kandimuku. Jilajbayi yingkamuku nanankurri barrawurri. Yali balkimuku. Kudiyamuku yalungi, yalili waki Kubaminkanyi, ngala yali maninjaku. Yalili kuyu dungala yalunbunanyi Kubaminkanyi, ngala kudukudu dungala yalili kuyu, bakili yalu kilimba kudiya nanda dungala yalungi. Malumba yalungki wardamba mamanyi nangandu Jisusnyina. ");
INSERT INTO wrk_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Jawudamuku yali jilajba nanankurri barndarri, Barisimuku yalu jalili kudanyu durrijba nanda yuwa nangangi Musiskanyi. Baki yali najba Jisus wardambikurri nangka mamanyi yalundu balkimukunyina. Ngajaka yali kandimuku Barasimukunyi, “Wanyingkanyi wardamba nangka narringi milidimbawarr mamanyi yalundu, balkimukunyina. Wanyingkanyi.” ");
INSERT INTO wrk_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Manku nyuli nanda yalungi jangkurr Jisuswanyi, baki nyuli jananganja yalunya, “Mikuwali badajba yarrbirra yalundurri jala yalu kunyba mankanyi, ngala nyulu badajba yalundurri jala yalu balki mankanyi. Baki nani barri, miku ngayiyanyi badajba nanganbunanyi Kudnanyi milidimbiji yalunya jala yalu jungku kunyba. Ngala ngayi badajba milidimbiji yalunya jala yalu jungku balki. ");
INSERT INTO wrk_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Ngala barriwa barri barlba. Wijba narri narringinkurri barndarri. Janarringka mankumanku nanankanyi jangkurranyi najana Kudkanyi. Yanybaka nanda jangkurr, ‘Miku ngayimi nulijba narringi, nganarri waykanyi bulukimukuyngka marda sibmukuyngka marda julakimukuyngka. Miku ngayimi nulijbangka narringi, nganarri waykanyi yajinyi nani, ngala ngayu nulijbangka narringi, narri jungunkanyi kunyba yalungi yingkamukuyngka. Marda narrimi yabimba kunyba yaji yalungi yurrngumba barri.’ Nani yanybaka nanda jangkurr. Marda narringkimi mankumanku nanankanyi jangkurranyi.” Baki mili yanybayi Jisus yalungi, “Miku ngayiyanyi badajba nanginkurri milidimbiji yalunya jala yalu jungku yurlurrmba nangangi Kudkanyi. Miku. Ngala ngayi badajba milidimbiji yalunya jala yalu jungku balki nangangi Kudkanyi.” Nani barri jananganjayi yalunya Barasimuku Jisuswanyi. Barriwa. ");
INSERT INTO wrk_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Baki kandimuku Junkanyi Ngurrunbawarrayngka, yali badajba nangandurri Jisusyurri. Ngajaka yali, “Jawudana barri, miku yalungkimi wardamba mamanyi kandimuku Junkanyi, baki Barasimuku. Miku yalungkimi wardamba mamanyi kudiyana, ngala nganyinmuku kandimuku yalungka wardamba mamanyi yurrngumba barri. Wanyingkanyi yalu miku kudiyana miku jarrkanyi mama.” ");
INSERT INTO wrk_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Jananganjayi yalunya Jisuswanyi, “Nanda buyingkinyi nawinganja, kajamuku yalu nangandu ngala nyulu jalannga wudumba maninganja. Miku yaliyi jungku birrkalanyi, ngala yalungka wardamba kajanyi mamanyi. Ngala baku barri janyulu jarimba nanda nangangi nawinganja yingkawanyi. Baki nanamanji barri, miku yaliyi jarrba mama nanganginmukunyi kandimukunyi, ngala jayalu ngindu muwa nangangi. Barriwa.” ");
INSERT INTO wrk_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Mili yanybayi Jisus yalungi nayi barri, “Jaliyi jumbala bakarrawijba, baki ngambala ngarrkadaba jumbala yingkayudinyi rakiyudinyi. Jaliyi buyingkinyi nanda rak, jala ngambala wakardaba nanda jumbala, baki bayakardangujbangka nanda buyingkinyi rak. Baki mili barri bakarrawijbaja nanda jumbala, bayakardangujbangangi nanda rak. ");
INSERT INTO wrk_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Baki mili janarringka mankumanku nanginkanyi jangkurranyi. Ngambala yarrijba ngarrki krayibkanyi kalawunyi bindawarrana. Nanda bindawarra waba jibkanyi. Jaliyi ngambala yarrijba buyingkinyi ngarrki kalawunyi waluwinyi bindawarrana, baki nanda balki. Jalija nanda ngarrki ngujbul bijal, baki dumbaja nanda waba bindawarra. Bunyarrijba janangka nanda ngarrki, baki bakarrawijbaja nanda bindawarra. Ngala ngambala yarrijba buyingkinyi ngarrki krayibkanyi kalawunyi buyingkinyi wabana bindawarrana. Jalija nanda ngarrki ngujbul bijal, baki yuku nanda bindawarra. Mikuwali bakarrawijba nanda waba. Miku nangkiyi bunyarrijba nanda ngarrki. Jungkuka kunyba barri kalawunyi bindawarrana yurrngumba barri.” Nani barri yanybayi Jisus yalungi. Barriwa. ");
INSERT INTO wrk_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Ngala yanybayi Jisus nanda jangkurr, baki jilajbayi nganinyi nangandurri, nyuli mambuka jurjkanyi. Jali nyulu wanbiya nangandu, Jisusnyina, baki mururu nyuli wayka. Yanyba nyuli Jisuskanyi, “Ngaki jandanyi, nanda ngila nyuli lunji. Lunji nyuli kudanyu barri, baki nangki janyba. Janinji kuna jilajba ngakindurri barndarri baki janinji marrimba nanda ngila wankambiji.” Nani nyuli ngajaka Jisus. ");
INSERT INTO wrk_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Walajbayi Jisus, baki jilajbayi nangandu barndarri. Barlba yali bulandu marda, nanganginmuku kandimuku Jisuskanyi. ");
INSERT INTO wrk_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Kajamuku yali lukuluku malumba nangandu Jisusnyina jali nyulu jilajba. Baki yingamali jibarri nanaba yalundu. Nyuli lunji. Ngulya jurrwayi yurrngumba. Wabulinyi jurrwayi yurrngumba 12 kindilkurrinyi. Jilajba nyuli bayngkani nangandu Jisusnyina, baki nyuli marrimba nangangi jumbala. ");
INSERT INTO wrk_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Mankumanku nangki nanda jibarri barrin, “Jaliyi ngayu marrimba nangangi jumbala, baki jangayu kunybijba.” Baki jilajbayi jibarri, baki marrimbayi nangangi jumbala. ");
INSERT INTO wrk_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Yangkalamba nangki Jisus. Najba nyuli jibarri, baki yanybayi nangangi, “Jibarri, mikujiyi marrala. Ninji kunybijba, kuyungangi ninji ngaki jangkurr.” Yinarramba kunybijbayi jibarri, dukujbayi nanda ngulya nangandu. Baki nyuli jingkijba, kunybijbayi nanda ngulya nangangi. Barriwa. ");
INSERT INTO wrk_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Mili barri jilajbayi Jisus nangandu mambukana jurjkanyi, baki wanbiya yali nanganginyina barndana. Kajamuku yali nanaba barndana, marda nanamuku brijbawarrmuku. Ngindu yali muwa kudanyu barri nanankanyi ngilayurruwa. ");
INSERT INTO wrk_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Wanbiyayi Jisus, baki yanyba nyuli yalungi, “Barriwa narri barlba. Wijba janarri barndarri. Mikukimi nayinda ngila kurdan. Muningka nyulu kulukangka. Miku nangkimi janyba.” Ngala yali yurlwa nangangi. Kakalijba yali nanganginkanyi jangkurranyi. Kakalijba yali. ");
INSERT INTO wrk_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Ngala manjijbayi yalunya Jisuswanyi barndananyi. Jali yalu barlba, baki ngankijbayi Jisus barrawuna. Jilajba nyuli nangandurri ngilayurruwarri. Marrimbayi ngila marni Jisuswanyi, baki walajbayi nanda ngila waykalinya. Walajba nyuli, baki yuku barri nyuli. Barriwa. ");
INSERT INTO wrk_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Kajamuku yali manku jangkurr nangangi Jisuskanyi, jali nyulu wankamba nanda ngila. Kajamuku jali jungku lukuluku nananyina yajina, yali manku nanda jangkurr. Barriwa. ");
INSERT INTO wrk_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Yingijbayi nanda barnda nangangi mambukanyi Jisuswanyi, baki barlba nyuli yubalina. Jali nyulu jilajba baki durrijbayi Jisus nganinyiwuyanyi. Buli kabuji yami. Kaya buli nangangi. Kudanyu buli kaya nangangi, “Ninji, mungkiji nangangi nanankanyi wankalanyi Dayibidkanyi, ngindukiyi muwa ngalingi. Ngindukiyi muwa ngalingi kabujiwuyayngka.” Nani buli kaya nangangi. ");
INSERT INTO wrk_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Ngankijbayi Jisus kalawuyngkurri barrawuna, baki bula ngankijbayi bayngkani nangandu. Jilajba buli nangandurri, baki yanybayi Jisus bulangi, “Wanyingkanyi nimbala kaya ngaki. Mankumanku kuna nimbalaka, yuku ngayu kunymamba nimbalanya kabuji yami. Nani kuna nimbalaka mankumanku ngaki.” Jananganja buli Jisus, “Yi, mambuka. Ngali jingkijba ninya, ninji ngiruka. Yuku ninji kunymamba ngalinya yami.” ");
INSERT INTO wrk_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Baki marrimba bulanyi yami Jisuswanyi. Marrimba nyuli yami, baki yanyba nyuli bulangi, “Jangayu yabimba nanda yaji, jala nimbala jingkijba ngana, yabimbikanyi yaji. Jangayu kunymamba nimbalanya yami.” ");
INSERT INTO wrk_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Baki yinarramba barri kunybijbayi bulangi yami, baki najba buli yaji. Ngala jirrinyba bulanyi maramarambiji yaji Jisuswanyi. Kudanyu nyuli jirrinyba bulanya, “Miku janimbala karu yalunya jali ngayu kunymamba nimbalanya yami.” ");
INSERT INTO wrk_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Jilajba buli barndananyi, ngala miku buliyanyi karda jungku. Karu buli yalunya nangangi Jisuskanyi jali nyulu kunymamba bulanya. Baki kajamuku lukuluku nananyina yajina, yali manku nanda jangkurr nangangi Jisuskanyi. ");
INSERT INTO wrk_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Ngala barlba buli jali kunymamba bulanya yami Jisuswanyi, baki wanbiyayi yingkamuku nangandu Jisusnyina. Kuyu yali nganinyi nangandurri Jisusyurri. Nyuli balki janyi. Miku nyuliyanyi yanyba jangkurr, jungkuyingangi wuwarr nangandu mankanyina. ");
INSERT INTO wrk_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Jakajbayi nanda wuwarr mankanyinanyi Jisuswanyi, baki yinarramba yanybayi nanda nganinyi jali balki janyi. Yanyba nyuli jangkurr. Bukambiju nanaba nangandu yalu manmalayi. Manmala yali kudanyu barri. Baki yanyba yalungki, “Jalannga barri ngambala najba nganinyi jirdi balkinyi janyinyi yanybikurri. Jalannga barri. Miku wabula nanginyina yajina Yisrayil kunymambayi balki janyi nganinyiwanyi. Miku barri.” Nani barri yalungki yanyba. ");
INSERT INTO wrk_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Kudiyamuku yalungi jali najba Jisus kunymambikurri nanda nganinyi janyi, yali Barasimuku, jalili kudanyu durrijba nanda yuwa nangangi Musiskanyi. Baki yanyba yalungki Barasimuku, “Nanda mambuka wuwarranyi, nanda Sayidin, nyuli yabimba nayinda Jisus ngiruka jakaykanyi nanda wuwarr nanganbunanyi mankanyinanyi. Nyuli yabimba Jisus ngiruka Sayidinwanyi.” Nani barri yalungki yanyba nangangi Jisuskanyi. Barriwa. ");
INSERT INTO wrk_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Mili barri barlbayi Jisus baki nanganginmuku kandimuku. Jilalajba yali lukuluku nananyina walkurranyina yajina. Yidamba yali kaja barrawuyabarrawuya, baki milidimbayi yalunya yingkana jurjina baki yingkana jurjina Jisuswanyi. Milidimba nyuli yalunya kunybanyi jangkurranyi nangangi Kudkanyi, nyulu lalanbawarr. Kajamuku jali lunji jirdi yinini yinini ngalyanyi, yali jilajba nangandurri, baki nyuli kunymamba yalunya bukambiju. ");
INSERT INTO wrk_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Kajamuku yali jilajba nangandurri Jisusyurri mankunki nangangi jangkurr. Najbayi yalunya Jisuswanyi, baki ngindu nyuli muwa yalungi. Kudanyu nyuli ngindu muwa yalungi, balkijbangangi yali muwa yajinyi. Miku yaliyanyi jingkijba, yanka yuku yalu jungku yurlurrmba nangangi Kudkanyi. Yalu barrinani jibmuku. Yakika yalu jibmuku jala mikuyaji lalanbawarrayngka lalanbikanyi yalunya, baki miku yalungkiyanyi jingkijba wanjawa yalu jilalajba. Nani barri nanda muramuku. Mikuyaji lalanbawarrayngka karunkanyi yalunya. Miku yaliyanyi jingkijba, yanka jayalu jungku yurlurrmba nangangi Kudkanyi. ");
INSERT INTO wrk_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Baki yanybayi Jisus yalungi nanganginmukuyngka kandimukuyngka. Muningka nyuli yanyba yalungi, “Nanginmuku, nganinyimuku baki jibarrimuku, yalu barrinani kingkirr. Nanda kingkirr jala jardijba janjawala, waluku walajbangka wuju, baki baku barri bayngkani, kujarra baki kujarra yakarl, nanda kingkirr yamiyudi, kunyunyu jarrkanyi. Wudumbaka yami baki wuyalangka yalu jarrkanyi. Barriwa. Najba narri nanda kingkirr, kudukudu mama kunyunyu. Birrirrinja nangka nanda yami wudumbikanyi yalu. Nani barri yalu muramuku marda. Birrirrinja yalungka yangkalambikanyi yalungka nangandurri Kudyurri. Birrirrinja yalungka yangkalambikanyi Kudyurri, barrinani nanda yami birrirrinja nangka wudumbikanyi yalu. Ngala ngawamba kujajarra ngambala karunki yalunya yanka jayalungka yangkalamba nangandurri Kudyurri. Ngawamba kujajarra ngambala karunki yalunya. ");
INSERT INTO wrk_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Marda narrimi yanyba mududu nangangi Kudkanyi. Marda narrimi yililikajba Kud, nyulu manjiykanyi kajamuku milidimbawarrmuku yalundurri. Janyulu manjijba kajamuku milidimbawarrmuku yalundurri, barrinani kajamukunyi yalu wudumba nanda kingkirr yami.” ");
INSERT INTO wrk_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Baku barri kayayi Jisus yalungi nanganginmukuyngka kandimukuyngka, nyuli yanybikanyi yalungi. Yali 12 barri nganinyimuku. Yanyba nyuli yalungi, “Ngayu jirrinyba narrinya. Janarri jilalajba lukuluku. Ngayu yabimbaka narrinya ngiruka narri yabimbikanyi ngiruka yaji. Janarri kunymamba yalunya jala yalu lunji jirdi yinini yinini ngalyanyi. Janarri kunymamba yalunya. Janarri jakajba wuwarr yalunbunanyi mankanyinanyi. Ngayu yabimba narrinya ngiruka jakakaykanyi wuwarr, baki kunymambikanyi yalunya.” ");
INSERT INTO wrk_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Nani barri nyuli jirrinyba yalunya nanganginmuku kandimuku 12 barri. Nayinda barri yalungi niji. Sayimin barri, yingka niji nangangi Bida, baki nanda kanyiya nangangi niji Yandru. Marda buwakula, Jayims baki Jun, bulangi nijanganjinyi niji nangangi Sibidi. ");
INSERT INTO wrk_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Baki Bilib baki Bardulumu, marda Dumas baki Madiyu, nanda jalili wudumba dungala yalunbunanyi Jumukunanyi yalungi Kubaminkanyi. Baki yingka nanamannga niji Jayims, ngala nangangi nijanganjinyi niji nangangi Yalbayis, baki Dadayus. ");
INSERT INTO wrk_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Baki yingka nanamannga niji Sayimin, ngala nangangi yaji niji Kayinan, baki Judas Yiskariyud, nyuli nanda jali baku nangka yangkalamba nanganbunanyi Jisusnanyi, baki karuyi mambukamuku jurjkanyi, wanjawa jayalu wakaramba Jisus. Barriwa. ");
INSERT INTO wrk_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Nanamuku 12 barri nganinyimuku, yali kandimuku nangangi Jisuskanyi. Manjijba nyuli yalunya lukuluku nananyina yajina. Karu nyuli yalunya, “Miku narriyi jilajba nanankurri yajiyurri niji Samariya. Miku narriyi jilajba nanankurri yajiyurri jala yalu jungku ngurranyimuku. ");
INSERT INTO wrk_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Janarri jilalajba nananyina yajina niji Yisrayil, jala yalu jungku narringinmuku mungkijimuku. Yalu barrinani nanda jibmuku jala yalu yakika. Mikuyaji lalanbawarrayngka lalanbikanyi yalunya. Miku yalimi jingkijba yanka jayalu jungku yurlurrmba nangangi Kudkanyi. ");
INSERT INTO wrk_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Janarri karu yalunya nangangi Kudkanyi, nyulu lalanbawarr yalungi. Birrirrinja nangka Kud lalanbikanyi yalunya, jaliyi yalungka yangkalamba nangandurri Kudyurri. ");
INSERT INTO wrk_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Janarri kunymamba yalunya jala yalu lunji. Janarri kunymamba yalunya jala yalu ngujbulijba waban, jala marrala yalu nangangi. Janarri wankamba yalunya jala yalungka janyba. Janarri jakajba wuwarr nanganbunanyi mankanyinanyi. Ngayu yabimba narrinya ngiruka yabimbikanyi bukamba nayinda yaji. Ngala miku nganarriyi wajba dungalanyi, yabimbangangi narrinya ngiruka. Muningka ngayu yabimbaka narrinya ngiruka. Baki nani barri, jalija narri yabimba ngiruka yaji yalungi, baki miku narriyi kuyu yalungi dungala. Muningka janarri yabimba ngiruka yaji yalungi marda. ");
INSERT INTO wrk_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Miku narriyi kuyu kudukudu yaji narrindu jalija narri jilalajba. Mikuyaji dungalanyi janarri kuyu narrindu. ");
INSERT INTO wrk_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Miku narriyi kuyu bindawarra narrindu ngajakankanyi yingka dungalanyi yarriykanyi dungala bindawarrana. Miku narriyi kuyu yingka mili jumbala, miku yingka mili jabunungkaji, miku yingka mili ridiridi janarri kuyu. Narri wakingka nangangi Kudkanyi. Janyulu nyulu lalanba narrinya. Nanamuku jalija narri kunymamba yalunya, marda yalimi wajba narrinya yajinyi. Nani barri marda yalimi lalanba narrinya jala narri milidimba yalunya. ");
INSERT INTO wrk_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Jalija narri wanbiya barrawuyabarrawuyana, baki janarri kujba kunybanyi nganiyngkanyi. Jalija ninji jingkijba nyulu kunyba, nyulu nulijba kandimbikanyi ninya, baki yuku barri janinji jungku nanganginyina barndana. Nanaba janinji jungku yurrngumba jalija ninji milidimba yalunya nananyina barrawuyabarrawuyana. ");
INSERT INTO wrk_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Jalija ninji ngankijba barndana milidimbikanyi yalunya nanaba, baki marda ninjimi ngajaka Kud, janyulu nyulu wajba yalunya mardumardu muwa. Baki nanamuku jalili jungku nananyina barndana, janyulu wajba yalunya mardumardu muwa Kudwanyi. ");
INSERT INTO wrk_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Jaliyi yalu kandimba ninya, baki janyulu wajba yalunya mardumardu muwa Kudwanyi. Ngala jaliyi yalu miku kandimba ninya, baki miku janyulu wajba yalunya mardumardu muwa. ");
INSERT INTO wrk_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Jalija narri wanbiya barrawuyabarrawuyana, baki yiningki jayalu yurlwa narringi. Yiningki jayalu miku manku narringi jangkurr. Barlba narri nanamunanyi yajinanyi. Jayajayamba narringka nukami manjiykanyi jundurr. Jayalu najba narrinya jayajayambikurri narringka nukami, manjiykanyi jundurr, baki jayalu jingkijba, yalu balkimuku. Balki yalu, mikungangi yaliyi manku nangangi jangkurr Kudkanyi. ");
INSERT INTO wrk_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Baku barri, janyulu karrinjarrijba yalunya bukambiju walu nangandu Kudwanyi. Janyulu karrinjarrijba yalunya barrinani kurdusnyina. Nanamanji barri janyulu yanyba yalungi balkimukuyngka jalili jungku nananyina barrawuyabarrawuyana. Janyulu yanyba yalungi, ‘Narri jungkuka balkimuku. Miku narriyanyi kandimba ngakinmuku kandimuku, jali ngayu manjijba narrindurri. Miku narriyanyi manku yalungi jangkurr ngaki. Nanankardi barri jangayu yabimba kiji narringi. Janarringka janyba yurrngumba. Nanamuku wankalamuku jalili jungku nanawuyanyina yajina, niji Sudum baki Kumurra, yali balkimuku, ngala narri barri narri balkimirra. Janarringka narringka janyba yurrngumba barri.’” Barriwa. ");
INSERT INTO wrk_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","Mili yanybayi Jisus yalungi nanganginmukuyngka kandimukuyngka. Yanyba nyuli, “Manku narri nayinda ngaki jangkurr. Ngayu manjijbangka narrinya kajayurri yajiyurri lukuluku. Marda narringkimi najbawa yalungi. Narri kunybamuku nganinyimuku, ngala ngayu manjijbangka narrinya yalundurri jala yalu balkimuku. Marda narringkimi najbawa, yanka narri jungku yalungi. Marda narrimi miku manku kiji yalungi. ");
INSERT INTO wrk_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Marda narringkimi najbawa yalungi, jala ngananjalu ngirra. Jayalu marrimba narrinya. Jayalu kuyu narrinya nangandurri malbuyurri kurdusyurri. Jayalu wajuba narrinya jurjina. ");
INSERT INTO wrk_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Jayalu kuyu narrinya mambukarri jurjkanyi, marda mambukarri Kubaminkanyi, kuyungangi narri ngaki jangkurr. Ngala jalija yalu kuyu narrinya nanamukuyngkurri mambukarri, baki janarri karu yalunya ngaki. Janarri karu yalunya ngakinkanyi jangkurranyi. ");
INSERT INTO wrk_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Jalija yalu kuyu narrinya kurdusyurri, jalija yalu karrinjarrijba narrinya walu mambukana, baki marda narrimi miku balkijba muwa, nanankanyi jangkurranyi jalija narri jananganja nanda mambuka. Marda narrimi miku balkijba muwa. Jalija narri karrinja walu nananyina mambukana, baki yingkawanyi janyulu karu narrinya nanankanyi jangkurranyi, narri yanybikanyi. ");
INSERT INTO wrk_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Nanda jangkurr jalija narri yanyba, miku nanda narringi jangkurr, ngala yingkawanyi janyulu wajba narrinya nanankanyi jangkurranyi. Janyulu wajba narrinya Kunybawanyi Ngarnduwanyi Kudkanyi. Janyulu nyulu karu narrinya jangkurranyi jananganjankanyi nanda mambuka. Nanankardi barri marda narrimi miku balkijba muwa jalija narri karrinja walu nangandu mambukana. ");
INSERT INTO wrk_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","Nanamanji barri kajamukunyi mungkijimukunyi baki ngurranyimukunyi jala ngananjalu ngirra, jayalu manjijba narrinya mambukarri, nyulu kurdanbiji narrinya. Buwakula, yingkawanyi manjijbaja yingka nangandurri mambukarri. Nijanganjinyiwanyi manjijbaja jandanyi nangandurri mambukarri, baki jandanyiwanyi manjijbaja nijanganjinyi baki yarrijinyi nangandurri mambukarri, nyulu kurdanbiji yalunya. ");
INSERT INTO wrk_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Kajamukunyi jayalu ngirra narrinya ngaki. Nanamukunyi jala yalu miku kuyu ngaki jangkurr, jayalu ngirra narrinya. Jayalu yabimba kiji narringi. Ngala jaliyi narri yuwajiwa kuyu ngaki jangkurr, jaliyi narringka miku yangkalamba ngakinbunanyi, baki jangayu marrimba narrinya mardarda. Jayalu yabimba kiji narringi yingkamukunyi, ngala jangayu marrimba narrinya mardarda. Jangayu marrimba yalunya mardarda bukambiju jaliyi yalungka miku yangkalamba ngakinbunanyi. ");
INSERT INTO wrk_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Jalija yalu yabimba kiji yingkana barrawuyabarrawuyana, baki janarri yingijba nanda yaji. Jilajba yingkarri barrawuyabarrawuyarri. Janarri jilajba yingkarri barrawuyabarrawuyarri baki yingkarri barrawuyabarrawuyarri nanginyina walkurranyina yajina Yisrayil. Ngayu Buwanya Bukambijuyngka, jangayu wijba nanginkurri jambarri baku barri, ngala miku narriyi yidamba bukamba barrawuyabarrawuya waluwa ngayuja wijba. ");
INSERT INTO wrk_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","25","Nanda jala yingkawanyi milidimbaka, miku nyulimi walkurra, ngala nanda nangangi milidimbawarr, nyuli mili walkurra nangangi. Nanda jala nyulu milidimbaka yingkawanyi, marda nyulimi mirnarrijba muwa, jala nyulu bayakarda nganinyi. Nanda wakiwarr, miku nyulimi walkurra, ngala nanda nangangi mambuka, nyulu mili walkurra nangangi. Baki nanda wakiwarr, marda nyulimi mirnarrijba muwa jala nyulu bayakarda nganinyi. Baki nani barri ngayu narringi mambuka, baki narri ngaki wakiwarrmuku. Yalu yabimbaka kiji ngaki, baki jayalu yabimba walkurra kiji narringi. Yalungka yanyba ngaki, ngayu mambuka yalungi wuwarranyi, baki nani barri jayalungka yanyba narringi, narri wuwarrmuku marda. Barriwa. ");
INSERT INTO wrk_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","Marda narrimi miku marrala yalungi yingkamukuyngka, jalija yalu yabimba kiji narringi. Nanijba barri miku narrimi jingkijba bukamba yaji, ngala baku barri janyulu minimba narrinya bukamba yajinyi Kudwanyi. Janyulu minimba narrinya yalungi nanamukuyngka jala yalu kunybamuku, baki nanamukuyngka jala yalu balkimuku. Janyulu minimba narrinya yalungi. Miku yaliyi ngadijba nanganbunanyi Kudnanyi. Nanankardi barri marda narrimi miku marrala yalungi. ");
INSERT INTO wrk_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Kardarda ngayu karungka narrinya nanginkanyi jangkurranyi. Ngala baku barri, janarri kudanyu karu yalunya nanginkanyi jangkurranyi. Janarri kudanyu karu yalunya jala jungku barndana, baki jurjina, baki barrawuyabarrawuyana. Janarri kudanyu karu yalunya bukambiju nanginkanyi jangkurranyi jala ngayu kardarda karu narrinya. ");
INSERT INTO wrk_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Marda narrimi miku marrala yalungi jala yalu ngirra narrinya. Yiningki jayalu kurdanba narrinya mankanyi, ngala miku yaliyi kurdanba narrinya ngarndu. Marda narrimi miku marrala yalungi. Ngala marda narringkimi kudanyu mankumanku nangangi Kudkanyi. Yuku nyulu kurdanbaka narrinya mankanyi, baki ngarndu marda. Yuku nyulu manjijba narrinya jangurri Yilyurri, jaliyi narri yurlwa nanganginkanyi jangkurranyi. ");
INSERT INTO wrk_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Nanda bayakarda julaki, nanda kijirrikijirri. Yuku narri wudumba nanda julaki yingamalina bayakardana dungalana. Ngala jingkijbaja Kudwanyi, jalija nangka janyba yingamali kijirrikijirri baki yirrbaja jambarri. Ngawamba nangkaja janyba, jaliyi munyajba janybikurri nangka Kudwanyi. ");
INSERT INTO wrk_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Jingkijbangka narrinya marda Kudwanyi. Kudanyu nyulu jingkijbangka narrinya. Nyulu jingkijbangka yankana nyungka narringinyina kulajina. ");
INSERT INTO wrk_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Lalanbaka kijirrikijirri Kudwanyi, ngala narri barri mili walkurra nanankanyi kijirrikijirrinyi. Janyulu lalanba narrinya marda Kudwanyi. Kudanyu janyulu lalanba narrinya. Nanankardi barri marda narrimi miku marrala yalungi jala yalu ngirra narrinya.” Barriwa. ");
INSERT INTO wrk_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","Mili barri yanybayi Jisus yalungi nanganginmukuyngka kandimukuyngka. “Jala nganinyi miku manyirru ngaki, ngala kudanyu nyulu karungka yalunya, nyulu durrijbangka ngaki jangkurr, baki miku ngayiyi manyirru nangangi. Jalija nyulu karrinja walu nangandu Kudnyina, baki jangayu karu Kud nangangi, ‘Nayinda nganinyi nyulu ngaki kandi. Nyulu durrijba ngaki jangkurr yurrngumba barri.’ ");
INSERT INTO wrk_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Ngala jala nganinyiwanyi karungka yalunya, miku nyulimi durrijba ngaki jangkurr, baki nanamanji baku barri jangayu karu Kud nangangi, ‘Nayinda nganinyi miku nyulimi ngaki kandi. Miku nyuliyanyi durrijba ngaki jangkurr.’ Nani barri jangayu karu Kud yinini yinini jangkurranyi yalungi. ");
INSERT INTO wrk_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","Marda narringkimi miku mankumanku ngaki, ngayi badajba yabimbiji yalunya bukambiju yalu jungunkanyi malumba mardumardu muwa. Miku ngayiyanyi badajba nanankanyi, ngala ngayi badajba yabimbiji kiji yalungi. Baki jayalungka jakakajba kudanyu barri. ");
INSERT INTO wrk_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Kudiyamukunyi jayalu kuyu ngaki jangkurr, ngala kudiyamukunyi jayalu miku kuyu ngaki jangkurr, baki nanankardi badajbaja kiji yalundurri. Yingkawanyi buwakaya kuyuja ngaki jangkurr, ngala nanganginyi jandanyiwanyi janyulu miku kuyu ngaki jangkurr. Yingkawanyi ngardanganjawanyi kuyuja ngaki jangkurr ngala nanganginyi kulunganjawanyi janyulu miku kuyu ngaki jangkurr. Yingkawanyi bardibardiwanyi kuyuja ngaki jangkurr, ngala nanganginyi ngunyarringanjawanyi janyulu miku kuyu ngaki jangkurr. Nani barri badajbaja kiji yalundurri. ");
INSERT INTO wrk_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Mungkijimuku jayalungka kudanyu jakakajba, baki jayalungka ngirra. ");
INSERT INTO wrk_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Nanda jala kudanyu marukangka muwa nanganginkanyi nijanganjiyngkanyi marda yarrijiyngkanyi, ngala ngawamba bijal nyulu marukangka muwa ngaki, miku nyulimi jungku kunyba ngaki. Miku nyulimi dujanya ngaki kandi. Nanda jala kudanyu marukangka muwa nanganginkanyi jandayngkanyi, ngala ngawamba bijal nyulu marukangka muwa ngaki, baki miku nyulimi jungku kunyba ngaki. Miku nyulimi dujanya ngaki kandi. Nanda jala kudanyu marukangka muwa nanganginkanyi kulunganjanyi ngala ngawamba bijal nyulu marukangka muwa ngaki, baki miku nyulimi jungku kunyba ngaki. Miku nyulimi dujanya ngaki kandi. ");
INSERT INTO wrk_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","39","Nanda jala durrijbangka ngaki jangkurr, yingkamukunyi jayalu yabimba kiji nangangi. Jayalu ngarrkadaba, yiningki jayalu kurdanba. Jaliyi nangka miku yangkalamba ngakinbunanyi, baki nyulu dujanya ngaki kandi. Janyulu mili wanka jungku baku barri nangandu Kudnyina. Ngala jaliyi nangka yangkalamba ngakinbunanyi jala yingkamukunyi yalu yabimba kiji nangangi, baki miku nyulimi dujanya ngaki kandi. Miku nyuliyi wanka jungku nangandu Kudnyina, ngala janyulu jungku kurdan yurrngumba barri. ");
INSERT INTO wrk_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","Jaliyi nganinyiwanyi kandimba narrinya jala narri durrijba ngaki jangkurr, baki nanda barrinani ngana nyulu kandimbaka. Baki jala ngana nyulu kandimba, baki nanda barrinani nyulu kandimbaka Kud, jali ngana manjijba nanginkurri wayka. ");
INSERT INTO wrk_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Manjijbangka milidimbawarrmuku Kudwanyi, baki nyulu yabimbaka kunyba yaji yalungi. Jaliyi yingkawanyi kandimba milidimbawarr, manjijbayingangi nanda nganinyi Kudwanyi, baki janyulu yabimba kunyba yaji nangangi Kudwanyi. Barriwa. Jaliyi nganinyiwanyi kandimba yingka, jala jungku kunyba nangangi Kudkanyi, baki janyulu yabimba kunyba yaji bulangi Kudwanyi. Janyulu yabimba kunyba yaji nangangi jala jungkuka kunyba, baki nangangi jala kandimba nanda. ");
INSERT INTO wrk_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Ngayu yanybaka duja jangkurr narringi. Jaliyi ninji yabimba kunyba yaji nangangi jalili nyulu durrijba ngaki jangkurr yurrngumba, baki nanda kunyba. Jaliyi ninji yabimba bijal yaji nangangi, ninji wajba nanda durrijbawarr wabudanyi ngaraykanyi, baki nanda kunyba. Jaliyi ninji wajba nanda wabudanyi, nyulungangi ngaki durrijbawarr, baki jangayu yabimba kunyba yaji nganyi.” Barriwa. Nani barri yanybayi Jisus yalungi nanganginmukuyngka kandimukuyngka. ");
INSERT INTO wrk_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Barriwa barri bukamba nyuli milidimba yalunya Jisuswanyi nanamuku 12 barri kandimuku nangangi. Baki yinarramba barlbayi Jisus nanamunanyi yajinanyi jali nyulu milidimba yalunya nanaba. Mili nyuli jilalajba lukuluku nananyina yajina, bakili nyulu milidimba yalunya. ");
INSERT INTO wrk_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Nanamanji barri nanda Jun Ngurrunbawarr nyulili jungku brisinyina. Wabula barri yali marrimba, baki manjijba yali brisinyurri. Ngala nyuli jungku brisinyina, baki manku nyuli jangkurr nangangi Jisuskanyi. Manku nyuli jangkurr nanankanyi yajinyi jali yabimba Jisuswanyi. Baki manjijba nyuli kudiya nanganginmuku kandimuku nangandurri Jisusyurri. ");
INSERT INTO wrk_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","Wanbiya yali, baki yanyba yali nangangi Jisuskanyi, “Nanangini Junwanyi Ngurrunbawarranyi nyulili karu yalunya yingkanyi walkurrayngka nganiyngkanyi jalija badajba bayngkani nangandu. Nyulili karu yalunya nanankanyi yingkanyi jalija nyulu badajba nanginkurri. Karukiyi nurrunya, ninji kuna nanda walkurra nganinyi, jali karu yalunya nangangi Junwanyi. Ninji kuna nanda. Yiningki janurru mili yukumba yingkanyi. Karukiyi nurrunya nganyi, jaliyi ninji nanda walkurra nganinyi, yanyba jali Jun nangangi.” ");
INSERT INTO wrk_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Jananganjayi yalunya Jisuswanyi, “Wijba janarri nangandurri Junyurri, baki janarri karu Jun nanankanyi jala narri najba. Janarri karu Jun nanankanyi jala narri manku yalunya yanybikurri. ");
INSERT INTO wrk_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Kajamuku jali yalu wabula kabuji yami, ngala nanijba barri yalu kunyba yami naykanyi yaji. Kajamuku jali wabula yalu balki nukami, jali miku jilajba, ngala nanijba barri yalu yuku kunyba nukami jilaykanyi. Kajamuku jali yalu wabula ngujbulijba waban, ngala nanijba barri yalu kunyba waban. Kajamuku jali yalu wabula balki kuwarda, jala mikuwali manku yaji, ngala nanijba barri yalu yuku, kunyba kuwarda mankunkanyi yaji. Kudiya jali nangka barriwa janyba, ngala nanijba barri yalu mili wanka jungku. Baki nanda kunyba jangkurr nangangi Kudkanyi, ngayu karungka yalunya nanankanyi jangkurranyi. Kajamuku jala miku yalungka walkurramba, ngala jala yalungka bayakardamba, ngayu karungka yalunya nanankanyi kunybanyi jangkurranyi nanganginkanyi Kudkanyi. ");
INSERT INTO wrk_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Kajamukunyi yalu manku ngaki jangkurr, yalu najba ngana kunymambikurri yalunya, baki ngana yalu jingkijba, ngayu nanda walkurra, jali ngayu badajba bayngkani nangandu Junyina. Nani yalu jingkijba ngana, baki nanankardi yalu mirnarrijbangka muwa ngaki. Janarri wijba nangandurri Junyurri. Janarri karu Jun ngakinkanyi jangkurranyi, baki janyulu jingkijba ngayu nanda.” ");
INSERT INTO wrk_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Baki barriwa barlba yali kandimuku nangangi Junkanyi Ngurrunbawarrayngka. Wijba yali nangandurri karunki yaji. Ngala yali barlba, baki yanybayi Jisus yalungi muranyi jali yalu nanaba nangandu. Nayi nyuli yanyba yalungi, “Wabula barri narri jilajbayi kula nangandurri Junyurri. Narri jilajbayi kularriji mangkurruyurri yajiyurri, naji nanda Jun, baki mankunki nangangi jangkurr. Narri jilajbayi nangandurri, baki wanyi narri najba. Najba kuna narri nganinyi jali yangkalamba kaja jangkurr, jali mili dingkaba yanyba. Jungku nyuli nani kuna, barrinani wunanybala karnba. Jala warrmbaka yunkurrwanyi karrina baki wayngkalulumbaka nanda karnba bayungu. Ngala jala warrmbaka yunkurrwanyi bayunguna, baki wayngkalulumba nanda karnba karri. Nani kuna nyulili mili yanyba dingkaba Jun. Ngala miku barri. Miku nyuliyanyi jungku nani Jun. Miku nyuliyanyi mili yanyba dingkaba. ");
INSERT INTO wrk_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Jungku kuna nyuli barrinani jirrinyi nganinyi, barrinani walkurra mambuka jirdi kunybanyi jumbalanyi. Nani kuna nyuli jungku. Miku nyuliyanyi jungku nani. Nanda walkurra mambuka jirdi kunybanyi jumbalanyi, nyulili jungku walkurranyina barrawuna. Ngala Jun miku nyuliyanyi walkurra mambuka. ");
INSERT INTO wrk_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Ngala wanyi narri najba. Najba kuna narri nganinyi jalili yanyba jangkurr nangangi Kudkanyi. Yi. Jali narri najba Jun, baki narri najba nanda nganinyi jalili yanyba jangkurr nangangi Kudkanyi. Nyuli walkurramirra nganinyi nangangi Kudkanyi. ");
INSERT INTO wrk_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Nanda naja Kudkanyi yanybaka nangangi Junkanyi. Yanybaka naja nayi barri nangangi, ‘Yanybaka Kud, “Ninji ngaki jandanyi, jangayu manjijba nganinyi waluwa nganyindu. Janyulu karu yalunya, nanangini nganinyiwanyi, jalija ngayu manjijba. Janyulu karu yalunya nganyi, janinji badajba. Janinji badajba bayngkani nangandu. Marda yalungkimi mankumanku nanankanyi balkinyi yajinyi jali yalu yabimba. Marda yalimi ngindu muwa nanankanyi balkinyi yajinyi, badajbangangi janinji.’” Nani barri nanda naja Kudkanyi yanybaka nangangi Junkanyi. ");
INSERT INTO wrk_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Nyulu nanda jali manjijba Kudwanyi karunki yalunya nanganginkanyi jangkurranyi Kudkanyi. Ngayu karungka narrinya duja jangkurranyi. Nanda Jun Ngurrunbawarr, nyulu walkurramirra nganinyi. Miku yingka mili walkurra nangangi. Nyulu mili walkurra yalungi wankalamukuyngka jali yanyba jangkurr nangangi Kudkanyi wankalana. Nyulu mili walkurra yalungi. Ngala baku barri kajamukunyi jayalu kuyu ngaki jangkurr, baki janyulu lalanba yalunya Kudwanyi. Ngala nanamuku jalija kuyu ngaki jangkurr, jayalu mili walkurra nangangi Junkanyi Ngurrunbawarrayngka. Jayalu mili walkurra nangangi. ");
INSERT INTO wrk_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Yanybayi Jun jangkurr Kudkanyi karunkanyi yalunya, marda yalimi ngindu muwa yalunginkanyi balkinyi yajinyi. Karuyi yalunya Junwanyi nangangi Kudkanyi nyulu Lalanbawarr. Jalannga barri jali yanyba Jun nani, baki yali manku kiji nangangi yingkamukunyi. Nanamanji barri yali yabimba kiji nangangi, baki yurrngumba nanginkurri yuwajiwa yalu manku kiji nurrungi jala milidimba nanamannga jangkurranyi. Yalu balkimuku. Yalu dabawarrmuku. ");
INSERT INTO wrk_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","14","Narri jingkijba nanda jangkurr najana Kudkanyi jali yanyba nanamuku wankalamuku. Baki nanda yuwa nangangi Musiskanyi najana Kudkanyi, narri jingkijba nanda jangkurr marda. Yalunginyi jangkurrwanyi karungka narrinya nanankanyi barrinani Yalayija jalija manjijba Kudwanyi. Narri jingkijba nanda jangkurr, baki jaliyi narri kuyu nanda jangkurr, baki narri jingkijba nayi marda. Nanda Jun Ngurranbawarr, nyulu nanda barrinani Yalayija jali manjijba Kudwanyi. ");
INSERT INTO wrk_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Narri jungku kuwardayudi, narri manku ngaki jangkurr, baki marda narrimi jingkijba ngaki jangkurr nangangi Junkanyi Ngurranbawarryngka.” Barriwa. ");
INSERT INTO wrk_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","Mili yanybayi Jisus yalungi, “Nganinyimuku baki jibarrimuku jala yalu jungku nanijba, yalu barrinani bayamuku jala baja burrandi barndana yajina. ");
INSERT INTO wrk_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","Malumba yali baja bayamuku. Yingka yanybayi yalungi, ‘Waluku ngayi nulijba ngambalangi bajankanyi ngambala wangarranyi, ngala miku narriyanyi nulijba bajankanyi nani ngakindu. Bayngkani barri ngayi nulijba ngambalangi bajankanyi ngambala makaykanyi kuyuwana, ngala mili barri miku narriyanyi nulijba bajankanyi nani ngakindu. Miku narrimi mirnarrijba muwa bajankanyi yinini yinini.’ Nani barri yanybayi yingka yalungi bayamukuyngka. ");
INSERT INTO wrk_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Jali badajba Jun karunki jangkurranyi Kudkanyi, baki miku nyuliyanyi jarrba mama kudiyana, miku nyuliyanyi ngaraba nanda ngarrki krayibkanyi. Ngala ngindu nyuli muwa, jungkukangangi nganinyimuku balki nangangi Kudkanyi. Nani nyuli jungku Jun Ngurrunbawarr, ngala yali yanyba nangangi, jungkuka wuwarr nangandu mankanyi. ");
INSERT INTO wrk_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Ngala jali ngayu Buwanya Bukambijuyngka badajba milidimbiji jangkurranyi Kudkanyi, baki jarrba ngayi yaji, ngaraba ngayi ngarrki krayibkanyi. Ngala yalu yanyba ngaki, ‘Najbakiyi nanda nganinyi. Jarrbangka nyulu kaja mama. Ngarabangka nyulu kaja ngarrki krayibkanyi. Baki nyulu kandimbaka yalunya balkimuku jala kuyu bayngkani dungala ngamanbunanyi yalungi kubaminkanyi.’ Nani barri yalu yanyba yinini yinini jangkurr. Nani barri yalu barrinani bayamuku. Miku yalimi mirnarrijba muwa nangangi Junkanyi, nanankanyi jali nyulu yabimba. Baki miku yalimi mirnarrijba muwa ngaki nanankanyi jala ngayu yabimba. Ngala nanamuku jala kuyu nanda jangkurr nangangi Junkanyi, baki kuyu ngaki jangkurr marda, yalu barri kunyba kulaji. Yalu jungkuka kunyba kulaji nangangi Kudkanyi yurrngumba barri. Barriwa.” Nani yanybayi Jisus yalungi. ");
INSERT INTO wrk_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Yabimba nyuli kaja ngiruka yaji Jisuswanyi. Yabimba nyuli ngiruka yaji kajana barrawuyabarrawuyana. Ngala nanamuku jali yalu jungku nananyina yajina, yali yurlwa nanganginkanyi ngirukanyi yajinyi. Miku yaliyanyi ngindu muwa yalunginkanyi balkinyi yajinyi. Miku yalungkiyanyi yangkalamba yalunginbunanyi balkinanyi yajinanyi. Baki yanybayi Jisus yalungi, ");
INSERT INTO wrk_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","“Narri jala jungku nananyina yajina niji Kurasin, baki yingkana yajina niji Bidsayida, badajbaja walkurra kiji narrindurri. Yabimba ngayi kaja ngiruka yaji narringinyina yajina, ngala miku narriyanyi kuyu ngaki jangkurr. Wabula barri wankalana, nanamuku jali jungku nanawuyanyina yajina niji Daya baki Sayidun, yali balkimuku. Ngala jaliyanyi yingkawanyi yabimba nanamannga ngiruka yaji yalunginyina yajina, barrinani nganarri najba yabimbikurri yaji, baki yaliyanyi ngindu muwa. Yaliyanyi ngindu muwa yalunginkanyi balkinyi yajinyi. Yalungkiyanyi yangkalamba nangandurri Kudyurri, jaliyanyi yalu najba nanamannga ngiruka yaji. ");
INSERT INTO wrk_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Ngayu karungka narrinya. Jalija nyulu karrinjarrijba yalunya bukambiju walu nangandu Kudwanyi, baki janyulu ngirrwa yalungi balkimukuyngka. Janyulu yanyba yalungi jalili wabula jungku nanawuyanyina yajina Daya baki Sayidin. Janyulu yanyba yalungi, yalu balkimuku. Ngala narri jala jungku nanginkuyanyina yajina Kurasin baki Bidsayida, janyulu yanyba narringi, narri balkimirra. Miku narriyanyi kuyu ngaki jangkurr, baki nanankardi narri mili balki yalungi nanamukuyngka wankalamukuyngka. Barriwa. ");
INSERT INTO wrk_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Ngala narri jala jungku nananyina barrawuyabarrawuyana Kabirnayum, mankumanku kuna narringka, narri kunybamuku, baku janarri jungku kingkarri nangandu Kudnyina. Nani kuna narringka mankumanku. Ngala ngayu karungka narrinya, miku narrimi kunybamuku, ngala narri marda balkimuku. Janyulu manjijba narrinya Yilyurri Kudwanyi, mikungangi narriyanyi kuyu ngaki jangkurr. Jaliyanyi nganinyiwanyi yabimba nanamannga ngiruka yaji nananyina yajina Sudum, barrinani nganarri najbangka yabimbikurri yaji, baki yuwajiwa jungkukiyanyi nanda barrawuyabarrawuya nanijba barri. Ngala dalyambayi nanda yaji Kudwanyi. Kurdanba nyuli bukambiju jali yalu jungku nanaba, jungkungangi yali balki nangangi. Ngala narri barri narri yurlwa ngakinkanyi yajinyi, baki narri jungkuka mili balki yalungi. ");
INSERT INTO wrk_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Jalija nyulu karrinjarrijba bukambiju yalunya walu nangandu Kudwanyi, baki janyulu yanyba, “Nanamuku jali jungku Sudum, yali jungku balki ngaki, ngala nanamuku jali jungku Kabirnayum, yalu jungkuka balkimirra, yurlwangangi yalu nanankanyi ngirukanyi yajinyi jali yabimba Jisuswanyi. Yalu jungkuka ngiruka balkimuku.’ Barriwa.” Nani barri yanybayi Jisus yalungi jali yurlwa nanankanyi ngirukanyi yajinyi jali nyulu yabimba yalunginyina yajina. Barriwa. ");
INSERT INTO wrk_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","26","Nanamanji barri yanybayi Jisus mududu nangangi Kudkanyi. Yanyba nyuli, “Buwakanya. Ninji barri walkurra mambuka lalijinyi baki jambanyi. Walkurra mambuka ninji bukambijuyngka yajinyi. Mirnarrijba ngayu muwa nganyi. Ninji ngadijba nganyi jangkurr yalunbunanyi jala yalungka mankumanku, yalu kunyba kulaji nganyi, yalu jingkijbangka nganyi yuwa. Yalungka mankumanku yalu jingkijbangka nganyi yuwa, yalu kunyba kulaji nganyi, ngala miku. Baki miku yalimi nulijba jingkiykanyi ngaki jangkurr nganyi. Nanankardi barri ninji ngadijba nganyi jangkurr yalunbunanyi. Ngala ninji minimbayi yalunya jala yalungka miku mankumanku yalu jingkijbangka nganyi jangkurr. Ninji minimbayi yalunya jala yalu mili nulijba jingkiykanyi nganyi jangkurr. Ninji minimba yalunya ngakinkanyi jangkurranyi, duja nanda ngaki jangkurr. Nani barri ninji yabimba yaji.” Barriwa. ");
INSERT INTO wrk_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Mili barri yanybayi Jisus yalungi, “Ngakinyi Buwakayu nyuli wajba ngana bukamba yajinyi. Nyuli yarrijba ngana walkurra mambuka bukamba yajinyi. Ngawamba nyulu ngana jingkijba ngakinyi Buwakayu. Baki ngawamba ngayu jingkijbangka nanda ngaki Buwakanya. Ngala jangayu yarrijba kudiya jingkiykanyi ngaki Buwakanya. Jangayu minimba yalunya ngakinkanyi Buwakaya, baki jayalu marda jingkijba ngaki Buwakanya. ");
INSERT INTO wrk_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Narri jala narri balkijba muwa, jala yabimba balki yaji, jala jungku narri balki nangangi Kudkanyi, marda narrimi badajba ngakindurri. Narri barrinani nganinyi jala wakingka mambukanyi, jala dukanarrijba wabuda kurndayudinyi. Rambaka janki wabudawanyi, baki biwi nangangi janki. Baki nani barri narringinyi balkiwanyi yajiwanyi rambaka narringi kurdulu. Ngala jaliyi narri badajba ngakindurri, jaliyi narri durrijba ngaki yuwa, baki mikukimi ngakinyi yuwawanyi ramba narringi kurdulu. ");
INSERT INTO wrk_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","30","Marda narrimi badajba ngakindurri. Marda narrimi kuyu ngaki jangkurr. Marda narrimi durrijba ngaki jangkurr, baki jangayu manjamanjamba narringi balki yaji, baki janarri jungku mardumardu muwa. Miku ngayiyi kijiwijba narringi. Miku ngayiyi ngirrwa narringi, ngala jangayu yili yanyba narringi. Jangayu milidimba narrinya ngaki, baki jangayu yabimba narrinya jungunkanyi mardumardu muwa. Marda narrimi durrijba ngaki yuwa. Mikukimi ngakinyi yuwawanyi ramba narringi kurdulu. Kunyba ngaki yuwa narringi. Janarri dululijba kurdulu.” Barriwa. ");
INSERT INTO wrk_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Baku barri burrandijba yali nananyina yajina jali jardijba nanda karnba daburrul. Nanda karnba yami kunyunyu jarrkanyi. Burrandijba yali, Jisus baki nanganginmuku kandimuku ngala nyuli Sadidi barri. Birrkalanyi yali kandimuku, baki dulaba yali yami, baki jarrba yali. ");
INSERT INTO wrk_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Ngala kudiyamuku Barisimuku jalili kudanyu durrijba nanda yuwa nangangi Musiskanyi, yali nanaba marda yalundu. Yali najba kandimuku dulaykurri yami baki jarrkurri yaji. Baki yanyba yalungki, “Yalu dulabangka yami karnbananyi. Nani barri yalu wakingka.” Baki yanyba yali nangangi Jisuskanyi, “Najbakiyi yalunya nganyinmuku kandimuku. Yalu dulabangka daburrul yami jarrkanyi. Nani yalu wakingka. Nani yalu jungkuka balkina yuwana Musiskanyi. Yanybaka nanda yuwa, mardakimi nganinyi miku waki Sadidi barri. Yuku yalu waki yingkana kambana, ngala miku Sadidi. Jala barri Sadidi ngala nganyinmuku kandimuku yalu wakingka, yalu dulabangka daburrul yami. Wanyingkanyi yalimi miku ngayangayijba nanankanyi yuwanyi Musiskanyi.” ");
INSERT INTO wrk_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Jananganjayi yalunya Jisuswanyi, “Narri jingkijbangka nanda jangkurr najana Kudkanyi, jala karu ngambalanya nanankanyi walkurrayngka mambukanyi Dayibidkanyi. Narri jingkijbangka nanda jala nyuli yabimba. Jali yalu birrkalanyi, Dayibid baki nanamuku yalu nangandu, baki wanyimbayi Dayibid. ");
INSERT INTO wrk_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","5","Ngankijba nyuli kalawunyi walkurranyina jurjina Kudkanyi, baki wajbayi Dayibid dambanyi mambukawanyi jurjkanyi. Jarrba yali nanda damba. Ngala nanda damba, nanda kudukudu yaji nangangi Kudkanyi. Nanda yuwa nangangi Musiskanyi yanybaka, ngawamba mambukamukunyi jurjkanyi, ngawamba yuku yalu jarrba nanda kudukudu mama. Mikuwali yingkawanyi, ngawamba mambukawanyi jurjkanyi. Ngala barimbayi nanda yuwa Dayibidwanyi. Jarrba nyuli nanda mama baki yalu nangandu. Baki narri jingkijba yalunya mambukamuku jurjkanyi. Yalu waki Sadidi marda. Yalu karrinja walu yalundu jurjina. Yalu yanybaka mududu nangangi Kudkanyi. Yalunjalu milidimbaka jangkurranyi Kudkanyi baki yuwanyi Musiskanyi. Nani barri yalu marda wakingka Sadidi. Nani kuna barri yalu barimbaka nanda yuwa, miku wakinkanyi Sadidi. Nani kuna barri. Ngayu karungka narrinya duja. Dayibid baki nanamuku nangandu yali birrkalanyi. Jaliyanyi yalu miku wudumba mama baki yaliyanyi majubujba mankanyi, baki miku yaliyanyi jilajba juju. Yuku barri nanangini mambukwanyi jurjkanyi yalunya wajbayi dambanyi, baki yali kunyba mankanyi jilaykanyi. Nanda mambuka jurjkanyi, jali nyulu wajba yalunya dambanyi, miku nyuliyanyi jungku balki nangangi Kudkanyi, ngala nyuli jungku kunyba nangangi. Baki nanamuku jala yalunjalu milidimbaka jurjina Sadidi barri, miku yalimi jungku balki nangangi Kudkanyi, ngala yalu marda jungkuka kunyba nangangi. ");
INSERT INTO wrk_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Nanda yuwa jurjkanyi, baki nanda yuwa miku wakinkanyi Sadidi, nanda kunyba yuwa. Ngala ngayu karungka narrinya yingkanyi yuwanyi Kudkanyi, nyulu lalanbikanyi narrinya. Nayinda yingka yuwa mili walkurra nanankanyi waluwiyngkanyi yuwanyi. Nayinda yuwa yanybaka nangangi Kudkanyi, nyulu lalanbaka narrinya. ");
INSERT INTO wrk_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Nanda naja Kudkanyi yanybaka, ‘Miku ngayimi nulijba narringi waykanyi nganarri barnyinyi. Ngala ngayu nulijba narringi yabimbikanyi kunyba yaji yalungi yingkamukuyngka. Ngayu nulijba narringi kandimbikanyi yalunya jala yalu balkijba muwa.’ Jalimi narri kudanyu jingkijba nanda jangkurr najana Kudkanyi, baki miku narrimi yanyba yalungi yingkamukuyngka yalu jungkuka balkina yuwana jala yalu yabimba kunyba yaji yingkamukuyngka. Miku yalimi jungku balki jala yalu yabimba kunyba yaji yalungi. ");
INSERT INTO wrk_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Ngayu Buwanya Bukambijuyngka narringi. Ngayu mambuka bukambijuyngka narringi yurrngumba barri. Ngayu mambuka narringi jala narri waki, baki jala narri jungku, marda ngayu mambuka nanankanyi yajinyi jala narri yabimba Sadidi barri.” ");
INSERT INTO wrk_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Kamu barri yingkijbayi nanda yaji Jisuswanyi, baki mili jilajba nyuli, baki wanbiya nyuli barrawuyabarrawuyana, baki ngankijba nyuli jurjina nanaba. Bayakarda nanda jurj. ");
INSERT INTO wrk_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Nanaba jurjina jungkuyi nganinyi jirdi balkinyi marninyi. Mikuwali marrimba yaji. Mardil nangangi marni. Barriwa. Kudiya nanaba jurjina yali nulijba balanjankanyi Jisus. Yali nulijba Jisuskanyi nyulu yabimbikanyi balki yaji nanankanyi yuwanyi Musiskanyi. Baki ngajaka yali Jisus, “Jaliyi nganinyiwanyi kunymamba yingka jala lunji ngala nyulu Sadidi yajina, baki nani nyulu wakingka. Nani nyulu wakingka ngala nyulu Sadidi yajina. Wanyi ninji yanyba. Jungku kuna nyulu balkina yuwana, jaliyi nyulu waki nani Sadidi yajina. Wanyi ninji yanyba nangangi.” Nani barri yali ngajaka Jisus balanjanki ngajaka. ");
INSERT INTO wrk_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Jananganjayi yalunya Jisuswanyi, “Mankumankuwa narringka nganiyngkanyi jirdi kajanyi jibkanyi. Jaliyi yingamali nangangi jib yirrba wayka rirrkina Sadidi yajina, baki mikuwali kirrijba, baki wanyimba janyulu. Jaliyi nyulu yingkijba nanda jib wayka wabudana baki ngurrulijbaja. Ngala janyulu dulaba nanda jib waykalinya wabudananyi ngala nyulu yuwajiwa Sadidi yajina, baki nanda kunyba. Mikukimi nanda yuwa Musiskanyi yanyba, marda ninjimi munyajba nanda jib ngurrulijba, jaliyi nyulu jirrba wabudarri Sadidi yajina. Yuku nyulu yabimbaka kunyba yaji Sadidi yajina. ");
INSERT INTO wrk_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Ngala yingamali nganinyi, nyulu mili walkurra jibkanyi. Yuku ninji kunymamba nganinyi jala lunji ngala nyulu Sadidi yajina. Yuku ninji kunymamba Sadidi yajina.” Nani barri jananganjayi yalunya Jisuswanyi. ");
INSERT INTO wrk_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Baki yanybayi Jisus nganiyngkanyi jali mardil marni. Jirrinyba nyuli nanda nganinyi, “Manjijbakiyi nganyingka marni.” Manjijba nangki marni baki kunybijbayi nanda marni. Yuku barri nyuli yabijba marni barrinani nanda yingka marni. ");
INSERT INTO wrk_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Kudiyamuku jali najba Jisus kunymambikurri marni Sadidi yajina, yali Barisimuku, baki yali ngarrangarra muwa. Yinarramba yali walajba. Barlba yali jurjnanyi, baki yanyba yalungki kurdanbikanyi Jisus. ");
INSERT INTO wrk_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Ngala mankuyi jangkurr yalungi Jisuswanyi, yalu nulijba kurdanbikanyi Jisus, baki barlba nyuli nanamunanyi yajinanyi. Baki kajamuku yali jilajba nangandu walkurra muranmuku. Nyulu kunymambayi yalunya jali yalu lunji. Kunymamba nyuli yalunya bukambiju. ");
INSERT INTO wrk_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Ngala jirrinyba nyuli yalunya, marda yalimi miku karu yalunya yingkamuku nangangi. Nani barri nyuli jirrinyba yalunya Jisuswanyi. ");
INSERT INTO wrk_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Nanda wankalanyi Yayisaya jali yanyba jangkurr nangangi Kudkanyi, yarrijba nyuli jangkurr najana Kudkanyi. Duja nanda jangkurr nayi barri. ");
INSERT INTO wrk_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“Yanybaka Kud nayi barri, ‘Nayinda, nyulu ngaki wakiwarr. Ngayi yarrijba nayinda, nyulu wakinkanyi ngaki kudanyu. Ngayu marukangka muwa nangangi. Mirnarrijba ngayu muwa nangangi, marda jangayu yawumba ngaki Kunyba Ngarndu nangandu, baki janyulu yanyba ngaki jangkurr. Janyulu karu yalunya bukambiju nanankanyi jalija ngayu yabimba yalungi, jaliyi yalu mili jungku balki ngakinkanyi yuwanyi yurrngumba barri. Janyulu karu yalunya nanankanyi balkinyi yajinyi jalija ngayu yabimba yalungi. ");
INSERT INTO wrk_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Miku nyuliyi ngarrangarra muwa yalungi. Miku nyuliyi jakakajba yalunya. Miku nyuliyi ngirrwa yalungi. Miku nyuliyi waka yalunya burrandi barndana. ");
INSERT INTO wrk_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Ngala janyulu jungku mardumardu muwa yalungi. Janyulu kandimba yalunya jala yalu miku ngirukijba mankanyi jala yalu majabujba mankanyi. Janyulu milidimba yalunya kunybanyi jangkurranyi. Yurrngumba janyulu milidimba yalunya nanankurri jalija kunybawanyi yajiwanyi wakaramba nanda balki yaji. Nanankurri janyulu milidimba yalunya. ");
INSERT INTO wrk_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Baki jayalu jingkijba nanda marda, janyulu marrimba yalunya mardarda. Janyulu marrimba yalunya bukambiju. Nani janyulu yabimba, nanda wakiwarr ngaki.’” Barriwa. Nani barri yanybayi nanda wankalanyi Yayisaya. Duja nanda nangangi jangkurr. Yanyba nyuli nangangi Jisuskanyi. Barriwa. ");
INSERT INTO wrk_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Baku barri kudiyamuku yali jilajba nangandurri Jisusyurri. Kuyu yali nganinyi jali kabuji yami. Nyuli kabuji yami, baki balki janyi. Miku nyuliyanyi najba yaji, miku nyuliyanyi yanyba jangkurr, jungkuyingangi wuwarr nangandu mankanyina. Kuyu yali nanda nganinyi nangandurri Jisusyurri, baki kunymambayi nganinyi Jisuswanyi. Yuku nyuli najba yaji baki yanyba jangkurr. ");
INSERT INTO wrk_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Ngala nanda muramuku nanaba nangandu, manmala yali jali kunymamba nganinyi Jisuswanyi. Manmala yali kudanyu barri. Yililikajba yalungka, “Yanybayi Kud, janyulu manjijba nganinyi marrimbiji ngambalanya mardarda. Nanda jalija manjijba Kudwanyi, janyulu barrinani jandanyi nangangi Dayibidkanyi juju bayngkani nangandu. Nani yanybayi Kud. Nayinda Jisus, yiningki nyulu nanda jali yanyba Kud janyulu manjijba nanginkurri.” ");
INSERT INTO wrk_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Mankuyi yalungi jangkurr kudiyamukunyi Barasimukunyi. Manku yali nanda jangkurr jali yalungka yililikajba, baki jananganja yali, “Miku barri, miku. Miku nyulimi nanda jalija manjijba Kudwanyi. Nayinda Jisus, nyulu yabimbaka ngiruka yaji, nyulu jakajbangka wuwarr, wakingkangangi nyulu nangangi mambukanyi wuwarranyi, Sayidinkanyi. Nanangini Sayidinwanyi nyulu yabimbaka Jisus ngiruka, yabimbikanyi ngiruka yaji, baki nanankardi nyulu jakajbangka wuwarr.” ");
INSERT INTO wrk_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Ngala jingkijbayi Jisuswanyi nanda jali yalungka yanyba. Jingkijba nyuli nanda jangkurr. Baki yanyba nyuli yalungi, “Jalimi yalu mungkiykurramba kurdanbiji, baki baku barri, janyulu mikuyaji mungkijinyi. Janyba jayalungka bukamba. Jalimi yalu mungkiykurramba kurdanbiji, yalu jala kuluka yingamalina barndana, baki baku barri janyulu mikuyaji mungkijinyi nanaba barndana. ");
INSERT INTO wrk_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Jalimi yalu mungkiykurramba kurdanbiji, Sayidin marda wuwarrmuku, baki baku barri janyulu mikuyaji wuwarranyi, kurdanbangangi jayalungka. ");
INSERT INTO wrk_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Narri yanyba ngaki, ngayu jakajba wuwarr mankanyinanyi, nyulungangi yabimbaka ngana ngiruka jakaykanyi wuwarr Sayidinwanyi. Ngala kudiyamuku kandimuku narringi, yalu marda jakajba wuwarr mankanyinanyi. Yanka yalu jakajba wuwarr. Nyulu kuna yabimbaka yalunya ngiruka marda Sayidinwanyi. Nanankardi kuna yalu jakajbangka wuwarr. Nanda jangkurr jali narri yanyba ngaki, miku nanda duja. ");
INSERT INTO wrk_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Miku ngayiyi jakajba wuwarr, nyulungangi ngana yabimbayi ngiruka Sayidinwanyi. Ngala nyulu yabimbaka ngana ngiruka nani Kunybawanyi Ngarnduwanyi Kudkanyi. Wajba ngana nanganginkanyi Kunybanyi Ngarndunyi Kudwanyi, baki nanankardi ngayu ngiruka jakaykanyi wuwarr. Jaliyi narri jingkijba nani ngaki, baki narri jingkijba nayi marda nangangi Kudkanyi. Nyulu barri nayi lalanbawarr Kud, marda nyulu barri ngana manjijbayi marrimbiji yalunya mardarda. ");
INSERT INTO wrk_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Mikuwali ngankijba nganinyi barrawuna jala nanda nangangi barrawu ngirukanyi nganiyngkanyi. Miku nyuliyi ngankijba barrawuna maninjakuji yaji. Waluwa barri marda nyulimi kijijba nanda ngiruka nganinyi kurulyudinyi nanangini maninjakuwanyi. Jala nyulu kijijba nanda ngiruka nganinyi, baki yuku barri janyulu maninjakujba nangangi yaji. ");
INSERT INTO wrk_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Badajba ngayi milidimbiji yalunya nangangi Kudkanyi, marda yalimi durrijba nangangi yuwa yurrngumba barri. Ngakinmukunyi kandimukunyi, yalunjalu milidimba nanamannga jangkurranyi durriykanyi Kud. Jaliyi nganinyi ngaki kandi, baki nani nyulu milidimbaka yalunya. Ngala jaliyi nganinyi miku ngaki kandi, baki nyulu kandi nangangi Sayidinkanyi, nyulu nulijbangka yangkalambikanyi yalunya yingkamuku nanganbunanyi Kudnanyi. ");
INSERT INTO wrk_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","32","Jala nganinyi yanybaka balki jangkurr, jala nyulu yabimbaka yinini yinini balki yaji, baki yuku nyulu manjamanjambaka nanda balki yaji Kudwanyi. Yuku nyulu manjamanjambaka nanda yinini yinini balki yaji nangangi, jaliyi nanda nganinyi nyulu ngindu muwa jungunkanyi balki. Jala nganinyi yanybaka balki jangkurr ngaki, Buwanya Bukambijuyngka, jala nyulu yanyba balki jangkurr ngaki, baki yuku nyulu manjamanjambaka nanda balki yaji Kudwanyi. Yuku nyulu manjamanjambaka nanda balki yaji, jaliyi nanda nganinyi ngindu muwa jungunkanyi balki. Ngala jala nganinyi yanyba balki jangkurr nangangi Kunybanyi Ngarndunyi Kudkanyi, jala nyulu mijba nanda Kunyba Ngarndu Kudkanyi, baki mikuwali manjamanjamba nanda balki yaji Kudwanyi. Miku nyuliyi manjamanjamba nanda balki yaji miykanyi Kunyba Ngarndu nangangi Kudkanyi. Barriwa.” ");
INSERT INTO wrk_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Mili barri yanybayi Jisus yalungi Barasimukuyngka. “Jala kunyba karlawanyi jardijba kunybana jambana, baki kaja kunyba mama nangandu. Ngala jala balki nanda karlawanyi, jala mardil jardijba, baki balki nanda mama nangandu. Jala narri najba kaja kunyba mama kurndana, baki narri jingkijba kunyba nanda kurnda ngiruka barri. Ngala jala narri najba balki mama kurndana, baki narri jingkijba balki nanda kurnda. Narri barrinani nanda balki kurnda jirdi balkinyi mamanyi. ");
INSERT INTO wrk_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Narri balkimuku. Miku narriyi yanyba kunyba jangkurr, jungkungangi narri balki kurdulu yurrngumba barri. Mankumanku narringka balkinyi jangkurranyi yurrngumba, baki yanyba narri ngawamba balki jangkurr yurrngumba. Narri barrinani nanda bijbawarr miya, jala yabimba kiji yalungi, jala yalunya bijba. Narri nulijbangka yabimbikanyi kiji yalungi, narri nulijbangka linjumbikanyi yalunya. ");
INSERT INTO wrk_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Ngala nanda nganinyi jirdi kunybanyi kurdulunyi nangka mankumankuka kunybanyi yajinyi. Baki nanankardi nyulu yabimbaka kunyba yaji, nyulu yanybaka kunyba jangkurr marda. Ngala nanda nganinyi jirdi balkinyi kurdulunyi, nangka mankumankuka balkinyi yajinyi, baki nanankardi nyulu yabimbaka balki yaji, nyulu yanybaka balki jangkurr marda. ");
INSERT INTO wrk_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","37","Ngayu karungka narrinya duja jangkurr. Janyulu karrinjarrijba narrinya walu nangandu Kudwanyi. Janyulu karrinjarrijba narrinya, baki janyulu mankuwa bukamba narringi balki jangkurr. Narri jala jungku balki nangangi, janyulu mankuwa narringi balki jangkurr, baki nanankardi barri janyulu yanyba narringi, narri balkimuku. Janyulu yabimba balki yaji narringi. Ngala narri jala yanyba kunyba jangkurr, janyulu mankuwa narringi jangkurr marda Kudwanyi. Baki janyulu yanyba narringi, narri kunybamuku.” Barriwa. Nani barri milidimbayi yalunya Jisuswanyi. ");
INSERT INTO wrk_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Kudiyamuku jali milidimbawarr yuwanyi Musiskanyi, baki kudiyamuku Barasimuku, yali yanyba nangangi Jisuskanyi. Ngajaka yali Jisus, “Milidimbawarr. Yuku ninji yabimba kaja ngiruka yaji. Nurrimi najba ninya yabimbikurri mili ngiruka yaji. Ngiruka yaji nurrimi najba ninya yabimbikurri.” Nani yali ngajaka Jisus, ngala miku yaliyanyi kuyu nangangi jangkurr, nyuli milidimbawarr nangangi Kudkanyi. ");
INSERT INTO wrk_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Ngala jananganjayi yalunya Jisuswanyi, “Nganarri jingkijba, ngayu kunymamba yalunya jala yalu lunji, ngayu jakajba wuwarr yalunbunanyi mankanyinanyi, ngala nganarri ngajaka, ngayu yabimbiji mili ngiruka yaji. Kajamuku yalu jungku balki nangangi Kudkanyi, baki narri marda, narri jungkuka balki nangangi. Miku narrimi durrijba nangangi yuwa. Miku ngayiyi minimba narrinya mili ngirukanyi yajinyi. Ngawamba yingamali ngiruka yaji janarri najba, barrinani ngiruka yaji jali yabimba Kudwanyi nangangi Junakanyi. ");
INSERT INTO wrk_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Nanda wankalanyi Juna, nyuli yirrba wayka wabudarri jali nanda waya karrinja burrandi kanjana. Yirrba nyuli wabudarri, ngala mikukiyanyi ngurrulijba. Bilyinybayi nanda nganinyi walkurranyi kakuwanyi, ngala mikukiyanyi kurdanba Juna kakuwanyi. Jungku nyuli kalawunyi muwana wankan. Kujarraka barndayka nyuli jungku muwana, baki baku barri balunbayi nanda kaku nanankanyi nganiyngkanyi. Manjijbayi nanda Juna bijalina wabudana, baki yuku nyuli jungku. Miku nyuliyanyi ngurrulijba. Mardarda nyuli jungku kalawunyi kakuna muwana kujarraka barndayka. Baki nani barri ngayu marda Buwanya Bukambijuyngka. Nani barri janganarri najba jungunkurri kalawunyi jambana kujarraka barndayka. Miku ngayiyi yabimba narringi mili ngiruka yaji. Ngawamba nanda ngiruka yaji janarri najba. ");
INSERT INTO wrk_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Manjijbayi nanda wankalanyi Juna Kudwanyi. Manjijba nyuli Juna karri barrawuyabarrawuyarri niji Niniba. Manjijba nyuli Juna karri milidimbiji yalunya nangangi Kudkanyi. Nanamuku jali yalu jungku nanaba Niniba, yali jungku balki nangangi Kudkanyi. Kudanyu yali jungku balki, ngala milidimbayi yalunya Junawanyi, baki yali ngindu muwa yalunginkanyi balkinyi yajinyi. Ngindu yali muwa, baki yangkalamba yalungki nangandurri Kudyurri, baki jungku yali kunyba nangangi. Ngayu milidimbaka narrinya ngirukanyi jangkurranyi, ngala miku narrimi ngindu muwa narringkanyi balkinyi yajinyi. Miku narringkimi yangkalamba nangandurri Kudyurri. Baku barri jalija nyulu karrinjarrijba narrinya walu nangandu Kudwanyi, nanamanji barri nanamuku jali wabula yalu jungku Niniba, jali yalungki yangkalamba nangandurri Kudyurri, jayalu ngirrwa narringi. Nayi jayalu yanyba, ‘Nurrungki yangkalamba nangandurri Kudyurri, jali milidimba nurrunya Junawanyi, ngala miku narringkiyanyi yangkalamba nangandurri Kudyurri jali milidimba narrinya Jisuswanyi. Ngala nanda Jisus, nyulu mili walkurra nangangi Junakanyi. Nyulu mili walkurra nangangi, ngala miku narriyanyi kuyu nangangi jangkurr.’ Nani barri jayalu ngirrwa narringi nanamanji barri. ");
INSERT INTO wrk_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Baki yingka wankalanyi jibarri, nyuli mambuka nanganginkanyi yajinyi juju kula niji Jiba. Nyuli jilajba kulani nanda jibarri mambuka yidambiji yingka mambuka niji Sulumun. Nyuli mambuka yalungi Jumukuyngka nanda Sulumun. Nyuli kunyba kulaji. Wajbayi kunyba kulaji Kudwanyi. Baki badajbayi nanda jibarri nangandurri mankunki nangangi jangkurr nangandu. Janyulu nyulu marda ngirrwa narringi jalija nyulu karrinjarrijba narrinya walu nangandu Kudwanyi. Janyulu yanyba narringi, ‘Ngayi kuyu nanda jangkurr nangangi Sulumunkanyi, kunybangangi nangangi kulaji. Ngala nanda Jisus nyulu mili kunyba kulaji nangangi Sulumunkanyi, ngala miku narriyanyi kuyu nangangi jangkurr.’ Nani barri janyulu nyulu marda ngirrwa narringi nanamanji baku barri. Barriwa.” ");
INSERT INTO wrk_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","45","Mili yanybayi Jisus yalungi. Muningka nyuli yanyba, “Jala wuwarr barlba nanganbunanyi mankanyinanyi, baki nyulu jilajbangka lukuluku. Kujbangka yingkanyi mankankanyi nyulu ngankiykanyi. Jaliyi nyulu miku wakaramba yingka mankanyi, baki nangka yanyba, ‘Barriwa jangayu wijba nanankurri mankanyiyurri jali ngayu yingijba.’ Baki nyulu wijbangka nanankurri mankanyiyurri. Nyulu najbangka mikuyaji yingkanyi, mikuyaji kunybanyi wuwarranyi nanaba mankanyina. Mikuyaji kunybanyi wuwarranyi nanaba, ngala likalika nanda mankanyi, kunyba jungunkanyi. Nyulu mili barlbangka, baki wudumbaka kaja mili wuwarrmuku. Nyulu wudumbaka 7 mili wuwarr, baki yalu wijbangka nanankurri mankanyiyurri. Yalu jungkuka nangandu mankanyina yurrngumba barri. Baki nanda nganinyi nyulu jungkuka balki. Kudanyu barri nyulu jungkuka balki, jungkukangangi nangandu mankanyina nanamuku wuwarrmuku, jala waki nangangi Sayidinkanyi. Narri milidimbawarr jala manku ngaki jangkurr, narri barrinani nanda nganinyi wuwarryudi. Jalannga jali narri manku nanda duja jangkurr nangangi Kudkanyi, baki narri ngindu muwa narringinkanyi balkinyi yajinyi. Ngindu narri muwa, ngala miku narringkiyanyi yangkalamba nangandurri Kudyurri, baki mikukiyanyi ngankijba Kunyba Ngarndu Kudkanyi narrindu mankanyina. Muningka narri ngindu muwa narringinkanyi balkinyi yajinyi, baki baku barri mili narri jungku balki nangangi. Kudanyu narri jungku balki nangangi barrinani nanda nganinyi, kudanyu nyuli jungku balki jali kajamuku wuwarr nangandu mankanyina.” Nani barri yanyba Jisus yalungi milidimbawarrayngka. Barriwa. ");
INSERT INTO wrk_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Ngala yuwajiwa yanybayi Jisus yalungi, baki wanbiya yali ngardanganja nangangi Jisuskanyi marda bababanyamba nyulu yalunya. Karrinja yali danbina barndana. Miku yaliyanyi bunundujba Jisusyurri muramukungangi. Manjijba yali jangkurr nangandurri Jisusyurri, nyulu jilaykanyi yalundurri, yalu yanybikanyi nangangi. ");
INSERT INTO wrk_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Jungkuyi muramuku nangandu Jisusnyina, baki yali yanyba nangangi, “Nanda ngardanganja nganyi, marda bababanyamba ninji yalunya, danbina yalu jungku. Yalu kujbangka nganyi, ninji jilajbaja yalundurri.” ");
INSERT INTO wrk_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","49","Ngala yinybayi yaji Jisuswanyi marnina. Yinyba nyuli yalunya nanganginmuku kandimuku, baki jananganja nyuli, “Najba janarri yalunya, nanginmuku ngakinmuku kandimuku. Yalu barrinani ngaki ngardanganja, barrinani ngaki bababanyamba ngayu yalunya. ");
INSERT INTO wrk_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Nanda jala durrijbangka nangangi jangkurr ngakinkanyi Buwakaya Kingkarri, nanda jala yabimbaka nanda yaji jala nyulu nulijba nangangi yabimbikanyi, nyulu barrinani nanda bababanyamba ngayu nangangi. Nyulu barrinani ngaki ngardanganja.” Nani barri jananganjayi yalunya Jisuswanyi. Barriwa. ");
INSERT INTO wrk_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","2","Kamu barri yingijbayi nanda barrawu Jisuswanyi, baki barlba nyuli kula kanjarri. Kajamuku yali jilajba nangandurri baki jungkurrijba nangki Jisus, milidimbiji yalunya. Kudukudu yali jilajba nangandurri, mankunki nangangi jangkurr, walkurra muramuku. Bukamba yalungki ngirringirrimba, baki jululumba yalungki. Nanankardi barri nyuli ngankijba muwardana baki jungku nyuli wilina kanjana. Baki milidimba nyuli yalunya muramuku, ngala nyuli jungku muwardana, ngala yali jungku bijalina. ");
INSERT INTO wrk_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Milidimba nyuli yalunya kajanyi jangkurranyi. Muningka nyuli yanyba yalungi, “Manku nganarri. Wudumbayi kudukudu yami nganinyiwanyi barrinani daburrul yami. Janyba nyuli nanda yami jambarri, jardiykunumbikanyi. ");
INSERT INTO wrk_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Jawuda yami yirrbayi yubalina, baki wanbiyayi julakimuku. Jarrba yali nanda mama yubalina julakimukunyi. Barriwa. ");
INSERT INTO wrk_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Marda jawuda yami yirrbayi didirrina yajina. Walajbayi daburrul karnba, ngala bijal jamba didirrina yajina. ");
INSERT INTO wrk_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Mikuyaji landurranyi jardijbayi didirrina yajina, baki janyba nangki. Yajbayi nanda karnba ngardarawanyi, baki janyba nangki. Janyba nangki, mikuyajingangi landurranyi. Barriwa. ");
INSERT INTO wrk_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Marda jawuda yami yirrbayi yajina jali jardijba nyilanyila. Walajbayi nanda yami wuju, marda walajbayi nanda nyilanyila, baki munybayi yaji. Jardijbayi juju kingkarri nanda nyilanyila, ngala ngawamba madilijbayi nanda daburrul yami. Mikuwali jardijba nani kingkarri. Munybayi yingkawanyi. Mikuyaji yaminyi nangandu daburrulina. Barriwa. ");
INSERT INTO wrk_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Marda mili jawuda yami yirrbayi kunybana jambana. Nanda karnba jardijbayi walkurra. Kudukudu yami nangandu jardijbayi. Yingka karnba yami nangangi kaja bijal, yingka karnba yami nangangi kaja, baki yingka karnba yami nangangi kajamirra.” Barriwa. ");
INSERT INTO wrk_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Yanybayi Jisus yalungi, “Jaliyi narri nulijba jingkiykanyi ngaki jangkurr, baki manku narri kudanyu.” Barriwa. ");
INSERT INTO wrk_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Kamu barri yali jilajba nangandurri Jisusyurri nanganginmuku kandimuku. Yilikajba yali Jisus, “Wanyingkanyi ninji muningka yanyba jangkurr yalungi. Wanyingkanyi ninji karu yalunyi nanankanyi jangkurranyi yaminyi.” Nani yali yilikajba Jisus. ");
INSERT INTO wrk_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Jananganjayi yalunya Jisuswanyi, “Narri jingkijbangka Kud, nyulu marukangka muwa narringi, nyulu lalanbaka narrinya yurrngumba barri. Ngala yingkamukunyi miku yalimi jingkijba Kud, nyulu lalanbawarr. Baki nanankardi muningka ngayu yanyba yalungi, ngayu milidimbiji yalunya. ");
INSERT INTO wrk_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Jaliyi nganinyiwanyi bijal jingkijba ngana, baki jangayu mili milidimba ngaki. Jaliyi nyulu kudanyu manku ngaki jangkurr, baki nyulu mili jingkijba yaji ngaki. Ngala jaliyi nyulu miku kudanyu manku ngaki jangkurr, baki nyulu mamanumba nanda ngaki jangkurr. ");
INSERT INTO wrk_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Muningka ngayu yanybaka jangkurr yalungi, mikungangi yalimi jingkijba Kud. Miku yalimi jingkijba nanda jala ngayu milidimba yalunya nangangi. Muningka yalu manku ngaki jangkurr, ngala miku yalimi jingkijba ngaki jangkurr. ");
INSERT INTO wrk_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Nanda wankalanyi Yayisaya, nyuli yarrijba jangkurr najana Kudkanyi. Duja nangangi jangkurr. Nanganginyi jangkurrwanyi karungka ngambalanya yalungi jala muningka yalu manku ngaki jangkurr. Nayi nyuli yarrijba, ‘Jungku narri kuwardayudi, ngala miku narrimi manku yaji. Jungku narri yamiyudi ngala miku narrimi najba yaji. ");
INSERT INTO wrk_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Narri Jumuku, narri jungku jardibirri muwa. Yurlwa narri ngakinkanyi jangkurranyi. Nani narringka makaba narringi kuwarda, baki miku narriyi manku ngaki jangkurr. Miku narriyi najba nanda ngiruka yaji jala ngayu yabimba. Jungku narri nani, baki nanankardi miku nganarrimi jingkijba. Ngala jaliyi narri jingkijba ngaki yaji, jaliyi narri kuyu ngaki jangkurr, baki jangayu manjamanjamba narringi balki yaji. Jangayu janyba narringi balki yaji narrinbunanyi kurdulunanyi.’ Nani barri nyuli yarrijba jangkurr najana Kudkanyi, nanangini wankalawanyi. Yarrijba nyuli nanda jangkurr jali karu Kudwanyi. ");
INSERT INTO wrk_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Ngala narri barri, ngakinmuku kandimuku, marda narrimi mirnarrijba muwa, najbangangi narri nanda ngiruka yaji jala ngayu yabimba, baki manku narri ngaki jangkurr. Baki nganarri jingkijba. Nganarri jingkijba nanankanyi jala ngayu yabimba, baki narri kuyu ngaki jangkurr. ");
INSERT INTO wrk_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Nayinda jangkurr jala ngayu karu narrinya, duja nayinda jangkurr. Nanamuku jali manjijba Kudwanyi yanybikanyi nangangi jangkurr, baki kajamuku wankalamuku jali kuyu nangangi jangkurr Kudkanyi, nulijba yali naykanyi ngana, baki mankunkanyi ngaki jangkurr. Ngala miku ngana yaliyanyi najba, miku yaliyanyi manku marda ngaki jangkurr. Janyba yalungki waluwa ngaki. Barriwa.” ");
INSERT INTO wrk_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","Mili yanybayi Jisus yalungi kandimukuyngka, “Manku nganarri. Jangayu mili karu narrinya nanankanyi yaminyi jali muningka ngayu yanyba narringi barrin. Nanda daburrul yami nanda barrinani jangkurr nangangi Kudkanyi. ");
INSERT INTO wrk_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Jawuda yami yirrbayi yubalina. Baki nani barri, jawuda yalu manku nangangi jangkurr Kudkanyi, ngala yurlwa yalu nanganginkanyi jangkurranyi. Nanda jala yalu yurlwa, yalu barrinani nanda yubal. Nanda yubal jardibirri, baki mikuwali jardijba mama nanaba. Jarrbayi yami yubalina julakimukunyi. Baki nani barri, yalu jardibirri kurdulu. Nanda jangkurr jala yalu manku, jawurrbangka nanda jangkurr yalunbunanyi Sayidinwanyi. Barriwa. ");
INSERT INTO wrk_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","21","Jawuda yami yirrbayi didirrina yajina. Baki nani barri, jawudawanyi yalu kuyu nangangi jangkurr Kudkanyi, baki yalu mirnarrijba muwa. Ngala yingkamuku yalu ngirrwa yalungi, kuyungangi yali nanda jangkurr. Baki miku yalimi mili nulijba nanankanyi jangkurranyi Kudkanyi. Yalu yingkijbangka nanda jangkurr. Yalu jala yingkijbangka nanda jangkurr nangangi Kudkanyi, yalu barrinani nanda didirr yaji. Nanda yami jali walajba didirrina yajina, mikuyaji landurranyi. Yuku wankijbayi bijal, ngala yajbayi yaji ngardarawanyi, baki janyba nangki. Nanda karnba wankijba bijal didirrina yajina. Nanda didirr yaji nanda barrinani yalu jala bijal kuyu nangangi jangkurr Kudkanyi. Ngala jala yingka ngirrwa yalungi, baki miku yalimi mili nulijba jangkurranyi Kudkanyi. Yingijba yali nangangi jangkurr. Barriwa. ");
INSERT INTO wrk_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Jawuda yami yirrbayi yajina jali jardijba nyilanyila. Baki nani barri, jawuda yalu mankuka jangkurr nangangi Kudkanyi. Bijal yalu kuyungka nanda jangkurr, ngala kudanyu yalu nulijbangka yingkanyi yajinyi. Nulijbangka yalu kajanyi dungalanyi marda yajinyi. Yalu kuliwijbangka yajinyi kudanyu barri. Yalu jala kuliwijba yajinyi, yalu barrinani nanda jamba jala jardijba nyilanyila. Nanda daburrul yami jardijbayi mardil, mikuyaji yaminyi. Nani barri yalu jala kuliwijbangka yajinyi, ngala miku yalimi nulijba nanganginkanyi jangkurranyi Kudkanyi. Jardijba yalu mardil kurdulu nangangi Kudkanyi. Barriwa. ");
INSERT INTO wrk_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Jawuda yami yirrbayi kunybana jambana. Baki nani barri, jawudawanyi yalu mankuka nangangi jangkurr Kudkanyi. Yalu kuyungka nanda jangkurr, baki yalunya kunymambaka yingkamuku yalu mirnarrijkanyi muwa. Yalu jala kunymambaka yingkamuku, yalu barrinani nanda kunyba jamba. Nanda karnba jali jardijba kunybana jambana, yingka karnba yami nangangi kaja bijal, yingka karnba yami nangangi kaja, baki yingka karnba yami nangangi kajamirra. Nani barri yalu jala kunymamba yingkamuku mirnarrijkanyi muwa. Yingkamuku yalu jungkuka bijal kunyba, yingkamuku yalu jungkuka kunyba, baki yingkamuku yalu jungkuka kunybamirra. Barriwa.” ");
INSERT INTO wrk_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Mili barri yanybayi Jisus yalungi. Muningka nyuli yanyba yalungi, “Jangayu karu narrinya nanankanyi jangkurranyi, jala lalanba narrinya Kudwanyi. Janybayi daburrul yami jambana nganinyiwanyi. Janyba nyuli daburrul yami jardiykunumbikanyi mili yami jarrkanyi. ");
INSERT INTO wrk_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Kamu barri mungana jali kuluka nanda nganinyi baki bukambiju jali nangandu, baki badajbayi yingka. Ngirra nyuli nanda jali janyba daburrul yami. Nyuliyanyi yabimba balki yaji nangangi. Binanyba nangki mungana, baki yarrijba nyuli yinini yami nananyinawa jambana. Nanda yingka yami miku yaliyi jarrba. Yarrijba nyuli yami jambana, baki binanyba nangki nanganginkurri barndarri. ");
INSERT INTO wrk_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Baku barri walajbayi nanda daburrul karnba, baki jardijbayi walkurra yamiyudi. Baki jardijbayi nanda yingka marda nangandu. ");
INSERT INTO wrk_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Badajba yali wakiwarrmuku mambukanyi. Bardajba yali nangandurri, baki yanyba yali, ‘Mambuka. Nanda daburrul yami jali ninji janyba jambana, kunyba nanda yami, mikuyaji yingkanyi yaminyi nangandu. Ngala yanka barri jardijbangka yingka karnba nangandu. Yanka barri.’ ");
INSERT INTO wrk_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Jananganjayi yalunya mambukawanyi, ‘Yi. Janyba ngayi ngawamba kunyba daburrul yami jambana, ngala yingkawanyi jala ngana ngirra, yiningki nyuli janyba yinini yami jambana.’ Baki ngajaka yali nanda mambuka, ‘Janurru kuna dulaba nanda yingka karnba.’ ");
INSERT INTO wrk_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Ngala nyuli jananganja yalunya, ‘Miku. Miku narriyi dulaba. Jilijbawa yaji. Jaliyi narri dulaba nanijba nanda yingka karnba, baki yiningki janarri dulaba kudiya daburrul karnba marda. Jardijbangka yalu malumba jambana. Yiningki walajbawali daburrul karnba, jaliyi narri dulaba nanda yingka nanijba. ");
INSERT INTO wrk_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Ngala munyajba janarri daburrul baki nanda yingka karnba. Mili janyulu jardijba barri. Jayalu jardijba malumba nanankurri jalija kunyunyu daburrul yami. Nanamanji barri jangayu karu ngakinmuku wakiwarrmuku, waluku jayalu dulaba nanda yingka karnba, baki nanamunanyi jayalu bakarrijba. Baki yuku barri kamu jayalu wudumba nanda daburrul yami. Jayalu wudumba nanda yami, baki jayalu dalburrijba ngakinyina barrawuna yarriykanyi mama.’ Nani barri jananganjayi yalunya mambukawanyi. Barriwa.” ");
INSERT INTO wrk_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","32","Mili barri nyuli milidimba yalunya Jisuswanyi. “Jangayu mili karu narrinya nanankanyi jangkurranyi jala lalanba narrinya Kudwanyi. Mili barri jangayu muningka yanyba narringi. Nanda nukunu yami, yuku nanda bayakarda yami. Janybaka yami jambana nganinyiwanyi. Ngala baku barri walajbangka wuju nukunu. Jardijbangka juju kingkarri, walkurramirra nanda nukunu. Yabimba yalu jabaka nukununa kingkarrinyina bangani julakimukunyi. Nani barri jardijbangka walkurra nanda bayakarda yami. Barriwa.” Nani muningka yanybayi Jisus yalungi. Nanda nukunu yami, jali jardijba, waluku nanda kurdalirri kurnda, ngala baku barri janyulu jardijba wunanybala. Nanda barrinani nayi. Waluku barri ngawamba kujajarra yali kuyu nanda jangkurr nangangi Jisus Krayiskanyi, yali durrijba nangangi yuwa, ngala baku barri mili yali kuyu nangangi jangkurr, baki mili, baki mili yurrngumba barri. Baku yali jungku kajamuku jali kuyu nangangi jangkurr, wirdikudukudumukunyi. Barriwa. ");
INSERT INTO wrk_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Mili barri nyuli milidimba yalunya nangangi Kudkanyi. “Jangayu mili karu narrinya nanankanyi jangkurranyi, jala lalanba narrinya Kudwanyi. Mili barri jangayu muningka yanyba narringi. Jala yabimbaka damba jibarriwanyi, baki nyulu wudumbaka kaja kandirri baki bijal bululu. Jidimbaka yaji jibarriwanyi, jirdi wabudanyi. Kamu barri bululujbangka nanda damba, walkurramba nangka. Nani barri walkurrambaka nanda damba bijalwanyi bululuwanyi. Barriwa.” Nani muningka yanybayi Jisus yalungi. Nanda kandirri jala bululu yaji kalawunyi, waluku barri nanda bayakarda yaji, ngala kamu barri walkurramba nangka nanda damba. Nanda barrinani nayi. Jalannga jala nganinyi kuyungka jangkurr nangangi Kudkanyi, baki ngawamba bijal nyulu jingkijbangka Kud. Ngala baku barri janyulu jingkijba mili yaji nangangi Kudkanyi, baki janyulu jungku mili ngiruka nangangi. Janyulu mili jingkijba Kud yurrngumba barri, baki janyulu jungku mili ngiruka, baki mili ngiruka nangangi yurrngumba barri. Barriwa. ");
INSERT INTO wrk_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Nanamanji barri mikukiyanyi yanyba Jisus yurlurrmba jangkurr yalungi muramukuyngka. Yurrngumba nyuli muningka yanyba jankurr yalungi milidimbikanyi yalunya. ");
INSERT INTO wrk_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Nanda wankalanyi barri yanyba nyulu jangkurr nangangi Kudkanyi, baki yarrijba nyuli nanda jangkurr najana Kudkanyi. Nayi barri nanda jangkurr. “Jalija ngayu milidimba yalunya, baki muningka jangayu yanyba yalungi. Miku jangayu yanyba yurlurrmba jangkurr. Muningka jangayu yanyba yalungi. Jangayu milidimba yalunya buyingkiyngkanyi yajinyi, jala miku yaliyanyi jingkijba yingkamukunyi jali yalu jungku wabula.” Nani barri yarrijbayi wankalawanyi. Duja nangangi jangkurr. Muningka barri yanybayi Jisus yalungi. Barriwa. ");
INSERT INTO wrk_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Kamu barri barlbayi Jisus yalunbunanyi muramukunanyi, baki ngankijba nyuli barrawuna. Jilajba yali kandimuku Jisuskanyi nangandurri, baki yanyba yali, “Miku nurrimi jingkijba nanda jangkurr jali ninji muningka yanyba barrin. Miku nurrimi jingkijba nanda jangkurr nganyi daburrulanyi marda nanankanyi yingkanyi karnbanyi. Karukiyi nurrunya yurrngumba nanankanyi jangkurranyi, ngambala jingkiykanyi.” ");
INSERT INTO wrk_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Jananganjayi yalunya Jisuswanyi, “Jangayu karu narrinya. Nanda nganinyi jali janyba daburrul yami jambana, nyulu barrinani ngayu Buwanya Bukambijuyngka. ");
INSERT INTO wrk_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Baki nanda jamba jala jardijba karnba nanaba, nanda jamba barrinani bukamba yaji wandijiyana. Nanda kunyba daburrul yami, nanda barrinani nganinyimuku baki jibarrimuku jala yalu durrijba nangangi jangkurr Kudkanyi. Baki nanda balki yami jali janyba yingkawanyi, nanda barrinani nanamuku jala durrijba nangangi jangkurr Sayidinkanyi. ");
INSERT INTO wrk_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Nanda nganinyi jali nangka binanyba, jali janyba nanda balki yami, nyulu barrinani nanda mambuka wuwarranyi, Sayidin. Nanamanji barri jali yalu karlba nanda karnba kunyunyuyudi yamiyudi, nanda barrinani nanamanji jalija bukamba nayinda yaji Kudwanyi. Baki nanamuku wakiwarrmuku jali yalu karlba nanda karnba, yalu barrinani Yanjilmuku jala waki nangangi Kudkanyi. ");
INSERT INTO wrk_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Wudumba yali nanda balki karnba wakiwarrmukunyi, baki bakarrijba yali janguna. Baki nani barri baku barri jalija bukamba nayinda yaji Kudwanyi. ");
INSERT INTO wrk_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Nanamanji barri ngayu Buwanya Bukambijuyngka, jangayu manjijba ngakinmuku Yanjilmuku. Jayalu badajba yalundurri wudumbiji bukambiju yalunya jala yalu jungku balki nangangi Kudkanyi. Nanamuku jala yalu yabimba balki yaji, baki nanamuku jala yalunjalu yabimba yingkamuku yabimbikanyi balki yaji, jayalunjalu wudumba bukambiju wandijiyana Yanjilmukunyi. ");
INSERT INTO wrk_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Jayalunjalu marrimba, baki jayalunya janyba walkurrayngkurri jangurri, Yilyurri. Nanaba barri jayalu ngindu muwa nanankanyi balkinyi yajinyi jali yalu yabimba. Kudanyu jayalu balkijba muwa, baki muningka jayalungka waka kudanyu barri. ");
INSERT INTO wrk_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Ngala nanamuku jali yalu jungku yurlurrmba nangangi Kudkanyi, jali durrijba nangangi jangkurr, jayalu jungku kingkarri lalijina. Jayalu jungku kingkarri ngalindu, Kudnyina. Kudanyu jayalu mirnarrijba muwa, jungkungangi jayalu kingkarri lalijina yurrngumba barri. Narri jala mankuka nayi jangkurr, marda narringkimi mankumanku, yanka narri jungku nangangi Kudkanyi. Barriwa.” ");
INSERT INTO wrk_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","“Mili barri jangayu karu narrinya nangangi Kudkanyi, jala lalanba narrinya Kudwanyi. Mili barri jangayu muningka yanyba narringi. Kurrijbayi jamba nganinyiwanyi, baki wakaramba nyuli kaja dungala kalawuyngkurru. Wakaramba nyuli nanda kaja dungala kalawuyngkurru jambana, ngala miku nanda nangangi jamba, ngala nanda yingkanyi nganiyngkanyi nangangi jamba. Baki mankumanku nangki nanda nganinyi jali wakaramba nanda kaja dungala jambana. Mankumanku nangki, ‘Jangayu wudumba nanda jamba dungalana. Jalija nanda ngaki jamba, baki nanda kaja dungala jambana, nanda ngaki dungala marda.’ Barriwa. Mili nyuli makaba nanda dungala jambana, baki wijba nyuli nanganginkurri barndarri. Wudumba nyuli bukamba nangangi yaji, baki wajbayi yingka nanankanyi yajinyi wudumbikanyi dungala. Kuyu nyuli nanda dungala nangandurri jala nanda nangangi jamba dungalayudi. Wajba nyuli nanda yingka dungalanyi, baki wudumba nyuli nanda jamba nanganginmirra. Baki nanda kaja dungala jambana, nanda nanganginmirra dungala marda, jungkukangangi nanganginyina jambana. Barriwa.” ");
INSERT INTO wrk_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","46","“Mili barri jangayu karu narrinya nangangi Kudkanyi jala lalanba narrinya. Muningka jangayu yanyba narringi. Najbayi kunyba yarrama nganinyiwanyi. Kunybamirra nanda yarrama, ngala nanda yingkanyi, nanda yarrama nangangi. Ngala nulijba nyuli nanankanyi kunybanyi yarramanyi, ngala mikuyaji dungalanyi nangandu wudumbikanyi nanda yarrama. Ngala wudumbayi bukamba nangangi yaji nganinyiwanyi. Wudumbayi nangangi wuni baki ngubungu, marda jalyu junu, baki wajbayi yingka nanankanyi yajinyi, nyulu wudumbikanyi dungala. Nani barri nyuli wudumba kaja dungala, baki wijba nyuli nangandurri, mambukarri nanankanyi kunybanyi yarramanyi. Wajba nyuli mambuka dungalanyi, baki wudumba nyuli nanda yarrama. Nanda nanganginmirra yarrama, baki kudanyu barri nyuli mirnarrijba muwa. Barriwa.” Nanda jangkurr nganiyngkanyi jali wakaramba kaja dungala jambana, jali nulijba nanankanyi dungalanyi nanganginkanyimirra, baki nanda jangkurr nganiyngkanyi jali wakaramba kunyba yarrama, jali nulijba yarramanyi nanganginkanyimirra, yanyba bula nanankujarra jangkurrwuya nanamannga. Marda narrimi nulijba nangangi Kudkanyi, nyulu lalanbikanyi narrinya. Marda narrimi kudanyu nulijba nangangi nani. Mardakimi nayinda jirrinyi narringi, nyulu lalanbikanyi narrinya Kudwanyi. Mardakimi miku yingka yaji jirrinyi narringi. Marda narrimi kudanyu nulijba nangangi Kudkanyi, nyulu lalanbikanyi narrinya.” ");
INSERT INTO wrk_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","Mili barri yanybayi Jisus yalungi. “Mili jangayu karu narrinya nangangi Kudkanyi, jala lalanba narrinya Kudwanyi. Mili barri jangayu muningka yanyba narringi. Kudiyawanyi nganinyiwanyi yalili wajarrijba kaku, bakili wajba yingka kakunyi wudumbikanyi yalu dungala. Barlba yali kanjana muwardana, baki janyba yali badija kanjana. Walkurra nanda badija, baki wakaramba yali kaja kaku, yinini yinini kaku. ");
INSERT INTO wrk_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Jali walbinyi nanda badija, baki wililijba yali badija waykalinya wabudananyi. Wudumba yali kaku badijananyi. Kudiya kaku jali kunyba jarrkanyi, yali yarrijba bindawarrana, ngala kudiya kaku jali balki jarrkanyi, muningka yali janyba wabudarri. ");
INSERT INTO wrk_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Nanda jangkurr wudumbikanyi kaku, nanda barrinani nanamanji baku barri jalija bukamba yaji Kudwanyi. Nanda kaku, yinini yinini kaku, yalu jungku barrinani nganinyimuku baki jibarrimuku. Kudiya kaku kunyba jarrkanyi, ngala kudiya balki jarrkanyi. Baki nani barri, kudiya yalu jungku yurlurrmba nangangi Kudkanyi, ngala kudiya yalu jungku balki nangangi Kudkanyi. Nanamuku wajarrijbawarrmuku, yalu barrinani Yanjilmuku. Nanamanji barri jalija bukamba yaji Kudwanyi, baki janyulu manjijba yalunya Yanjilmuku, baki jayalunjalu wudumba jala yalu jungku balki nangangi Kudkanyi. Jayalunjalu dulaba yalunbunanyi kunybamukunanyi, ");
INSERT INTO wrk_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","baki janybaja walkurrayngkurri jangurri Yilyurri. Nanaba jayalu ngindu muwa nanankanyi balkinyi yajinyi jali yalu yabimba. Kudanyu jayalu balkijba muwa, marda jayalungka waka kudanyu. Barriwa.” Nani barri milidimbayi yalunya Jisuswanyi. Nani nyuli milidimba yalunya nanganginmuku kandimuku. ");
INSERT INTO wrk_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Ngajaka nyuli yalunya, “Jingkijba kuna narri nanda jali ngayu karu narrinya. Jingkijba kuna narri ngaki jangkurr.” Jananganja yali, “Yi. Nurru jingkijbangka nayinda nganyi jangkurr.” ");
INSERT INTO wrk_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Baki yanybayi Jisus yalungi, “Jaliyi narri jingkijba ngaki jangkurr nangangi Kudkanyi, nyulu lalanbikanyi narrinya, jaliyi narri kuyu ngaki jangkurr nangangi, baki marda narrimi milidimba yalunya yingkamuku nanankanyi nanamannga jangkurranyi. Marda narrimi mankuwa nanda jangkurr najana Kudkanyi, nanda jangkurr jali yarrijba wankalamukunyi. Marda narrimi mankuwa nanankanyi wankalanyi jangkurranyi Kudkanyi, baki milidimba yalunya ngakinkanyi buyingkiyngkanyi jangkurranyi marda. Barriwa.” Nani barri muningka yanybayi Jisus yinini yinini jangkurr yalungi milidimbikanyi yalunya. ");
INSERT INTO wrk_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Jali nyulu yanyba Jisus bukamba nanda jangkurr yalungi, baki barlba yali nanamunanyi yajinanyi, Jisus marda nanganginmuku kandimuku. ");
INSERT INTO wrk_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Barlba yali bayungu baki wanbiya yali nanganginyina yajina Jisuskanyi. Ngankijbayi Jisus jurjina, baki nyuli milidimba yalunya nanganginmuku mungkijimuku. Jali yalu manku nangangi jangkurr Jisuskanyi, baki manmala yali. Manmala yali, baki yanyba yalungki, “Yanka nyuli jingkijba nanda jangkurr. Yanka nyuli jingkijba milidimbikanyi marda kunymambikanyi yalunya. ");
INSERT INTO wrk_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Miku nyulu mambuka. Muningka nyulu jungkuka barrinani ngambala. Miku nyulimi mambuka milidimbikanyi yaji. Muningka nyulu jandanyi nangangi jalili nyulu yabimba barrawu wabula. Nyulu kulunganja nangangi Marikanyi. Baki kaja bababanyamba nyulu yalunya nayiba, Jayims baki Jusib, Sayimin baki Judas. ");
INSERT INTO wrk_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Marda jibarrimuku bababanyamba nyulu yalunya, yalu jungkuka nanganginyina yajina marda. Miku nyulimi mambuka, ngala yanka nyuli jingkijba milidimbikanyi ngambalanya.” ");
INSERT INTO wrk_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Nani barri yalungki yanyba. Miku yaliyanyi kuyu nangangi jangkurr mungkijimukunyi nanganginyina yajina. Yurlwa yali nanganginkanyi jangkurranyi. Yanybayi Jisus yalungi, “Nanda jala yanybaka jangkurr nangangi Kudkanyi, nyulu jilalajbangka lukuluku. Nyulu yanymimbaka jangkurr nanaba yajina yalungi Kudkanyi, baki yalu kuyungka nanda nangangi jangkurr. Ngala jala nyulu jungkuka nanganginyina yajina, jala nyulu yanybaka jangkurr nanganginmukuyngka mungkijimukuyngka, baki miku yalimi kuyu nangangi jangkurr. Yalu yurlwangka nangangi nanganginkanyi jangkurranyi. Baki nani barri narri marda, narri ngakinmuku mungkijimuku, ngakinmuku bababanyamba ngayu narrinya, ngala miku narrimi kuyu ngaki jangkurr. Nganarri jingkijba yurrngumba wabulinyi, ngala narri yurlwangka ngaki ngakinkanyi jangkurranyi. Barriwa.” ");
INSERT INTO wrk_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Baki miku nyuliyanyi yabimba kaja ngiruka yaji nanaba nanganginyina yajina. Ngawamba kujajarra nyuli kunymamba yalunya, mikungangi yaliyanyi kuyu nangangi jangkurr. ");
INSERT INTO wrk_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","2","Nanamanji barri, nanda nganinyi, niji Yirud, nyuli walkurra mambuka Kubaminkanyi nanankanyi yajinyi Kalilikanyi. Manku nyuli yalunya yanybikurri nangangi Jisuskanyi, nanankanyi ngirukanyi yajinyi jali nyulu yabimba, baki ngamungku nyulu Jisus nanamannga Jun Ngurranbawarr. Yanyba nyuli yalungi nanganginkanyi wakiwarrayngka, “Nanda Jun Ngurranbawarr, jali ngayu kurdanba, jali yingkawanyi daya janki ngaki, nyulu mili wankijbayi. Mili nyulu wanka jungkuka nanijba. Ngawamba nanda Jun, ngawamba nyulu ngiruka kunymambikanyi yalunya mankanyi. Miku yingka ngiruka kunymambikanyi yalunya. Ngawamba nyulu Jun Ngurranbawarr.” Nani barri ngamungku nyulu Jisus nanamannga Jun Ngurranbawarr. ");
INSERT INTO wrk_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","4","Wabula barri nanangini mambukawanyi Yirudwanyi, nyuli jarimba nanda jibarri, jali yingkanyi nangangi maninganja, jali maninganja nanganginkanyi bababanyamba nyulu Yirudkanyi, niji Bilib. Jarimba nyuli nanda jibarri, baki kuyuyi nangangi barri maninganja. Nanda jibarri niji nangangi Yirudayis. Nani barri yabimbayi balki yaji Yirudwanyi. Jungku nyuli balkina nananyina yuwana Kudkanyi. Nani barri nyuli jungku balki nanda Yirud. Baki nanankardi barri ngirrwayi nangangi Jun Ngurrunbawarr. Ngirrwa nyuli nangangi nanankanyi balkinyi yajinyi jali nyulu yabimba. Nanankardi barri nyuli manjijba nanganginmuku ngarrkadabawarrmuku Yirudwanyi. Nyuli manjijba yalunya wudumbiji Jun Ngurrunbawarr. Marrimba yali Jun, baki yarrijba yali brisinyina kiybakiybayudi. Nani barri yabimbayi yaji Yirudwanyi nangangi Junkanyi, karungangi Yirud Junwanyi, nyulu Yirud jungkuyi balki nangangi Kudkanyi. ");
INSERT INTO wrk_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Nulijba nyuli kurdanbikanyi Jun Yirudwanyi, ngala nyuli marrala. Marrala nyuli yalungi Jumukuyngka. Jingkijba yali Jun, nyuli yanyba jangkurr nangangi Kudkanyi. Jalimi nyulu kurdanba Jun, baki jayalu ngarrangarra muwa nangangi Yirudkanyi. Jayalu ngarrangarra muwa nangangi, yanybayingangi Jun jangkurr nangangi Kudkanyi. Ngala yarrijba nyuli Jun brisinyina, Yirudwanyi. ");
INSERT INTO wrk_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Nanda jibarri Yirudayis, kulunganja nangangi wurrumbarra. Nyuli kunyba kajurrawarr, nanda wurrumbarra. Kudiyamukunyi mambukamukunyi yali yidamba Yirud. Jarrba yali mama nangandu, ngaraba yali yaji marda. Yabimba yali jarrkanyi yaji. Ngala yalungki wardamba, baki manjijba yingka Yirudwanyi wudumbiji nanda wurrumbarra. Badajba nyuli baki kajurrayi walu yalundu. ");
INSERT INTO wrk_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Kudanyu nyulu kajurra yalungi, Yirudkanyi marda mambukamukuyngka. Mirnarrijba yali muwa nangangi. Yanybayi Yirud nangangi wurrumbarranyi, “Wanyingkanyi ninji nulijba. Janinga wajba yajinyi. Janinga wajba nanankanyi jala ninji nulijba. Duja ngayu yanyba.” ");
INSERT INTO wrk_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Jilajbayi wurrumbarra danbiyurri, baki karuyi nangangi ngardanganja nanankanyi jangkurranyi waykanyi yajinyi Yirudwanyi. Yilikajbayi nangangi ngardanja, “Wanyingkanyi jangayu ngajaka. Wanyingkanyi.” Jananganjayi ngardanganjawanyi, “Yilikajbakiyi nanganginkanyi kulajinyi Junkanyi Ngurrunbawarrayngka. Yilikajbakiyi nanganginkanyi kulajinyi.” Wijba nyuli Yirudyurri wurrumbarra, baki yanybayi nangangi, “Wajba janganinji kulajinyi Junkanyi Ngurrunbawarrayngka najana. Nulijba ngayu nanganginkanyi kulajinyi.” Barriwa. ");
INSERT INTO wrk_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Ngala nginduyi Yirud muwa. Kudanyu nyuli ngindu muwa, mikungangi nyuliyanyi nulijba kurdanbikanyi Jun. Ngala nyuli yilikajba wurrumbarra barrin wanyingkanyi yajinyi janyulu wajba. Nyuli yanyba waykanyi yajinyi, baki bukambijunyi yali manku nanda nangangi jangkurr. Miku nyuliyi yangkalamba nanda jangkurr. Barriwa, janyulu wajba yajinyi. ");
INSERT INTO wrk_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Baki nyuli jirrinyba ngarrkadabawarr, “Dayakiyi Jun janki, baki wiykunumbakiyi kulaji nanginkurri.” ");
INSERT INTO wrk_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Barlbayi ngarrkadabawarr, baki nyuli kurdanba Jun. Nyuli daya janki brisinyina. Wiykunumba nyuli kulaji najana, baki wajbayi wurrumbarra. Baki kuyuyi kulaji wurrumbarrawanyi, wajbayi nangangi ngardanganja kulajinyi. Barriwa. ");
INSERT INTO wrk_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Nanamuku kandimuku Junkanyi, jali yalu manku Jun janyba nangki, jilajba yali brisinyurri baki dulaba yali nangangi mankanyi, makaykanyi. Baki yali yarrijba nangangi mankanyi kalawunyi kumayanguna. Yarrijba yali mankanyi kumayanguna kalawunyi, baki yali jilajba Jisusyurri. Karu yali Jisus nangangi Yirudkanyi, nyuli kurdanba Jun Ngurrunbawarr. Barriwa. ");
INSERT INTO wrk_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Jali nyulu manku nanda jangkurr nganinyiyurruwa Jisuswanyi, baki barlba nyuli nanamunanyi yajinanyi. Barlba nyuli karrurrinybarri kanjana muwardana. Barlbayi nyuluma karrurrinybarri nanankurri yajiyurri jali mikuyaji yingkanyi nanaba. Nulijba nyuli nyuluman jungunkanyi. Ngala jawudamukunyi yali najba Jisus jilaykurri muwardana karrurrinybarri, baki yalunjali karu yingkamuku nangangi Jisuskanyi, barlbayi karrurrinybarri muwardana. Baki yali barlba nukamina nanankurri yajiyurri. Dulu yali barlba. ");
INSERT INTO wrk_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Wanbiyayi Jisus karrurrinybana, baki walajbayi muwardananyi. Nyuli najba yalunya walkurra muranmuku wanbiyankurri, baki ngindu nyuli muwa yalungi. Kudanyu nyuli ngindu muwa yalungi, mikuyajingangi nyuli lalanbawarrayngka yalungi. Baki kunymamba nyuli yalunya. Kunymamba nyuli yalunya kajamuku jali yalu lunji. ");
INSERT INTO wrk_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Ngabungabu barri jilajbayi nangandurri Jisusyurri kandimuku nangangi. Baki yanyba yali Jisuskanyi, “Barriwa barri. Ngabungabu yaji nayinda. Mikuyaji mamanyi nayiba, baki mikuyaji barndanyi. Marda ninjimi manjijba yalunya barrawuyabarrawuyarri lukuluku. Marda ninjimi manjijba yalunya wudumbiji yalungi mama.” ");
INSERT INTO wrk_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Jananganjayi yalunya Jisuswanyi, “Miku ngayiyi manjijba yalunya. Yuku yalu wambu jungku nayiba. Janarri wajba yalunya nayiba mamanyi.” ");
INSERT INTO wrk_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Yanyba yali nangangi Jisuskanyi, “Ngala ngawamba bayayawa mama nayiba nurrundu. Ngawamba kujarra baki kujarra baki yingamali bayayawa damba, marda kujarra kaku nayiba nurrundu.” ");
INSERT INTO wrk_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Baki yanyba nyuli yalungi, “Janarri kuyu nanda mama ngakindurri. Janganarri wajba mamanyi.” ");
INSERT INTO wrk_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Baki jirrinybayi yalunya muramuku Jisuswanyi, yalu jungunkanyi dalbu dalbu nanaba karnbana, baki jungkurrijba yalungki karnbana. Barriwa. Wudumbayi nanda damba marda kaku Jisuswanyi. Kingkarri nyuli najba lalijiyurri, baki yanybayi Kudkanyi nanankanyi mamanyi. Yanyba nyuli mududu nangangi Kudkanyi nanankanyi mamanyi. Barriwa. Baki dalyamba nyuli damba. Wajbayi kandimuku, baki yali wajba muramuku dambanyi. Wawajba yalunjalili dambanyi marda kakunyi. ");
INSERT INTO wrk_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Jarrba yali mama bukambijunyi, baki wardijba yali muwa. Ngala miku yaliyanyi jarrba kudanyu nanda mama. Kudiya mama kiliyi nanaba. Baki wudumba yali nanda mama kandimukunyi, baki yarrijba yali birndawarrana mijimbanguna 12 barri. ");
INSERT INTO wrk_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Kajamukunyi yali jarrba mama mijimbangu 5000 barri nganinyimuku. Baki jibarrimuku baki bayamuku marda. Barriwa. ");
INSERT INTO wrk_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Baki jirrinyba nyuli yalunya nanganginmuku kandimuku Jisuswanyi. Yanybayi yalungi, “Janarri ngankijba muwardana, baki janarri barlba kanjana bayangarrinybarri. Ngala jangayu manjijba yalunya muramuku yalunginkurri barndarri.” Baki barlba yali kandimuku nangangi muwardana. ");
INSERT INTO wrk_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Baki manjijba nyuli yalunya muramuku Jisuswanyi. Mudambayi yalunya, baki barlba yali. Ngala kirrijbayi Jisus kingkarri dungalana. Kirrijba nyuli nyubana yanybiji nangangi Kudkanyi. Jungku nyuli nanaba dungalana kingkarrinyin bangani, baki mungijbayi nangangi yaji. ");
INSERT INTO wrk_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Ngala nanganginmuku kandimuku yuwajiwa yali wajanganja burrandijba kanjana. Kudanyu yali wajanganja baralala, karnungkumbayingangi yalunya yunkurrwanyi bayunguna baki walajbayi lakululu. ");
INSERT INTO wrk_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Ngala nyulu kambalingijba yaji karrina, baki jilajbayi Jisus yalundurri. Jilajba nyuli nukamina yundu wabudana. ");
INSERT INTO wrk_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Najba yali Jisus jilaykurri yundu wabudana, baki ngamungku nyuli wuwarr. Marrala yali, baki kaya yali, “Wuwarr, nanda wuwarr badajbangka.” Marrala yali kudanyu barri. ");
INSERT INTO wrk_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Yinarramba barri yanybayi Jisus yalungi, “Miku narriyi marrala ngaki. Nayinda ngayu, Jisus. Miku narriyi marrala ngaki.” ");
INSERT INTO wrk_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Baki yanybayi Bida nangangi Jisuskanyi, “Mambuka, miku ninyiyi jingkijba. Jaliyi ninji dujanya nanama ninji, baki janganinji karu, jangayu jilajba nganyindurri yundu wabudana, jaliyi ninji miku wuwarr, jaliyi ninji dujanya.” ");
INSERT INTO wrk_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Jananganjayi nyulu Bida, Jisuswanyi, “Yi. Jilajbakiyi ngakindurri yundu wabudana.” Baki walajbayi Bida. Walajba nyuli muwardananyi, baki jilajbangka nyulu nangandurri Jisusyurri yundu wabudana. ");
INSERT INTO wrk_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Ngala warrmbayi yaji yungkurrwanyi kudanyu barri. Baki nanankardi marralayi Bida. Marrala nyuli, baki karralangka wayka wabudana, baki kaya nyuli nangangi Jisuskanyi. Kayayi Bida, “Mambuka. Marrimbakiyi nganinji. Marrimbakiyi nganinji mardarda barri.” ");
INSERT INTO wrk_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Baki yinarramba marrimba nyuli Bida Jisuswanyi. Marrimba nyuli baki yanybayi Bidanyi, “Wanyingkanyi nganyingka mankumankuka janinji ngurrunba nanda. Wanyingkanyi nganyingka balkijba muwa. Marda nganinjimi jingkijba, janinga marrimba mardarda. Marda nganinjimi jingkijba, janinga kudanyu lalanba.” ");
INSERT INTO wrk_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Buli ngankijba muwardana, baki kurrkunba nangki yungkurr. Mikukiyanyi warrmba mili. ");
INSERT INTO wrk_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Baki nanamukunyi kandimukunyi, yali wajba Jisus kunybanyi jangkurranyi yalunginkanyi. Kunybanyi jangkurranyi yali wajba Jisus. Yanyba yali nangangi, “Nayinda jangkurr duja, ninji nangangi jandanyi Kudkanyi. Ninji nangangi jandanyi.” ");
INSERT INTO wrk_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Mili yali wajanganja bayungu. Birlbidamba yali bayangarrinybarri, baki wanbiya yali nananyina yajina niji Kinisirid. ");
INSERT INTO wrk_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Jala yali walajba muwardananyi, jawudamukunyi yali jingkijba Jisus. Jingkijba yali Jisus, baki wirlku yali lukuluku nani. Wirlku yali yalundurri jala yalu lunji, baki kuyu yalunjali nangandurri Jisusyurri. ");
INSERT INTO wrk_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Yililikajba yali Jisus, “Yuku kuna janurru marrimba nganyi jumbala, baki janurru kunybijba. Yuku kuna.” Bukambiju jali yalu marrimba nanda jumbala nangangi Jisuskanyi, baki yali yabijba mankanyi. Yabijba yali mankanyi. ");
INSERT INTO wrk_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Nanamanji barri nanamuku Barasimuku, nayi yalungi yuwa. Waluku yalungkili wakardaba marni, baki kamu yalili jarrba mama. Nani barri yalungi yuwa nanamukuyngka Barasimukuyngka. Baki yalunjalili karu yingkamuku, marda yalungkimi bukambiju waluku wakardaba marni, baki kamu jayalu jarrba mama. Nani barri yalunjalili karu nanankanyi yuwanyi. Jalili yalu wudumba mama dungalana, miku yaliyanyi jarrba nanda mama ngala yali jilajba. Waluku yalungkili wakardaba marni, baki kamu yaluja jarrba nanda mama. Mili yalungi yuwa wakardaykanyi yaji. Wakardaba yalili yukurumuku marda bujilimuku. Wakardaba yalili kaja yaji yalunginkanyi yuwanyi. Karuyi yalunya wakardaykanyi yaji nanankanyi yuwanyi, jalili yalunya karu wankalawanyi. Nanamanji barri nanamuku Barasimuku, nani barri yalili wakardaba yaji nanankanyi yuwanyi. Barriwa. Baku barri kudiya Barasimuku, baki kudiya milidimbiwarr yuwanyi, badajba yali kulani Jirusalimnanyi. Badajba yali nangandurri Jisusyurri baki yali ngajaka Jisus. ");
INSERT INTO wrk_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“Najba nurri nganyinmuku kandimuku jarrkurri mama. Jarrba yali mama nganyinmukunyi kandimukunyi, ngala miku yalungkiyanyi waluwa wakardaba marni. Dulu yali jarrba nanda mama. Wanyingkanyi yalungkimi miku wakardaba marni waluwa yalu jarrkanyi yaji. Nani barri yanybaka nanda yuwa wakardaykanyi yaji. Ngala wanyingkanyi miku yalimi ngayangayiyba nanankanyi yuwanyi.” Barriwa. ");
INSERT INTO wrk_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","4","Jananganjayi yalunya Jisuswanyi, “Ngala narri barri, wanyingkanyi narriyi miku ngayangayijba nanganginkanyi yuwanyi Kudkanyi, ngala narri ngayangayijba narringinkanyi yuwanyi. Yanybayi Kud nayinda jangkurr, ‘Marda ninjimi lalanba bulanya, nganyi nijanganjinyi marda ngardanganja. Marda ninjimi wajba bulanya mamanyi marda dungalanyi. Marda ninjimi miku yanyba balki jangkurr bulangi. Jaliyi ninji yanyba balki jangkurr bulangi, jaliyi ninji miku wajba bulanya mamanyi marda dungalanyi, baki marda ninyalimi kurdanba yingkamukunyi.’ Nanda jangkurr, nanda nangangi yuwa Kudkanyi. ");
INSERT INTO wrk_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","6","Ngala miku narrimi milidimba yalunya nanankanyi nanganginkanyi jangkurranyi. Yinini jangkurranyi narri milidimba. Narri milidimba yalunya, jaliyi yingka nyulu yanyba bulangi nanganginkanyi nijanganjiyngkanyi baki ngardanganjanyi, jaliyi nyulu yanyba bulangi, ‘Miku ngayiyi wajba nimbalanyi mamanyi, miku ngayiyi lalanba nimbalanya. Yanyba ngayi jangkurr nangangi Kudkanyi, jangayu wajba Kud dungalanyi baki yajinyi, baki miku ngayiyi yangkalamba nanda jangkurr. Baki nanankardi barri miku ngayiyi wajba nimbalanya dungalanyi baki yajinyi. Miku ngayiyi lalanba nimbalanya.’ Narri yanyba jaliyi nyulu yanyba nani bulangi, baki nanda kunyba. Narri yanybaka nanda kunyba nyulu waykanyi Kud dungalanyi, ngala mikuyaji mili dungalanyi wudumbikanyi mama bulangi. Ngala balki nanda narringi yuwa. Miku narrimi ngayangayijba nanganginkanyi yuwanyi Kudkanyi. Narringinyi yuwawanyi manjamanjambaka nanda yuwa nangangi Kudkanyi. Nanangini balkiwanyi jangkurrwanyi manjamanjambaka nanda kunyba jangkurr nangangi Kudkanyi. Narri jungkuka balki jala miku narrimi lalanba bulanya yarrijinyi baki nijanganjinyi, jala miku narrimi wajba bulanya dungalanyi, ngala narri wajba Kud dungalanyi. Nani barri narri yurlwa nanganginkanyi jangkurranyi Kudkanyi, ngala narri milidimba yalunya narringinkanyi jangkurranyi. ");
INSERT INTO wrk_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Narri balkimuku. Narri yabimba balki yaji jala narri mamanumba nanda yuwa nangangi Kudkanyi, jala narri karu yalunya yinini yuwanyi. Narri balkimuku. Nanda wankalanyi jangkurr jali yanyba Yasisaya, duja nanda jangkurr. Nanangini jangkurrwanyi karungka yalunya narringi. Nayi nanda jangkurr, ");
INSERT INTO wrk_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","‘Yanybaka Kud nayinda jangkurr, ‘Nanginmuku, muningka yalu yanyba, yalu maruka muwa ngaki, yalu durrijba ngaki yuwa, ngala miku. Miku yalimi maruka muwa ngaki. Miku yalimi durrijba ngaki yuwa. Muningka yalu wajba ngana yalunginkanyi kunybanyi jangkurranyi, ngala miku yalimi kunyba kurdulu ngaki. ");
INSERT INTO wrk_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Jalija yalu wajba ngana kunybanyi jangkurranyi, baki miku ngayiyi manku yalungi jangkurr. Miku ngayiyi manku yalungi kunyba jangkurr, mikungangi yalimi milidimba ngakinkanyi jangkurranyi. Yalu yanybaka nanda ngaki jangkurr, ngala miku. Milidimba yalunjalu yalunginkanyi jangkurranyi, miku ngakinkanyi jangkurranyi.’ Nani barri nanda jangkurr najana Kudkanyi. Barriwa.” ");
INSERT INTO wrk_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Baki kayayi Jisus yalungi muramukuyngka, yalu jilaykanyi nangandurri. Mili nyuli yanyba yalungi wakardaykanyi yalungka marni baki jarrkanyi mama. Yanyba nyuli yalungi, “Manku janarri ngaki jangkurr, baki jingkijba janarri. ");
INSERT INTO wrk_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Miku nyulimi jungku balki, jarrbangkangangi nyulu mama. Nyulu jungkuka balki, mankumankukangangi nangka balkinyi yajinyi. Waluku nangka mankumankuka balkinyi yajinyi, baki nyulu yanybaka balki jangkurr, nyulu yabimbaka nanda balki yaji. Nani barri nyulu jungkuka balki.” Barriwa. ");
INSERT INTO wrk_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Yanybayi nanganginmuku kandimuku nangangi Jisuskanyi, “Nanamuku Barasimuku, miku yalimi mirnarrijba muwa nanankanyi nganyingkanyi jangkurranyi, ngala yalu ngarrangarra muwa.” ");
INSERT INTO wrk_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Jananganjayi yalunya Jisuswanyi, “Jangayu muningka karu narrinya jangkurranyi. Yarrijba karnba yami nanganginyina jambana mambukawanyi baki baku barri jardijbayi kunyba karnba. Ngala jardijbayi yingka karnba marda, jala mikukiyanyi yarrijba nanda yami jambana mambukawanyi. Jardijbayi nanda yingka balki karnba. Ngala nanda mambuka, janyulu badajba, janyulu dulaba bukamba nanda balki karnba jali miku nyuliyanyi yarrijba yami jambana. Janyulu dulaba bukamba nanda balki karnba. Nanda kunyba karnba, nanda barrinani nanamuku jala durrijba nanda jangkurr nangangi Kudkanyi. Ngala nanda balki karnba, nanda barrinani nanamuku jala miku yalimi durrijba nangangi jangkurr. Baki nanda mambuka jali dulaba nanda balki karnba, nyulu barrinani ngaki Buwakanya kingkarri. Bukamba yalu jala miku yalimi durrijba nangangi jangkurr, janyulu dulaba yalunya ngakinyi Buwakayu. Janyulu bukamba yalunya, mikungangi yalimi durrijba nangangi jangkurr. ");
INSERT INTO wrk_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Marda narrimi miku balkijba muwa yalungi Barasimukuyngka. Yalu barrinani nanda kabujiwuya. Jaliyi yingkawanyi kabujiwanyi yalilijba nanda yingka kabuji, baki jabula yirrba wayka bardawana. Jabula yirrba, mikungangi bulimi najba yaji wanjawa bula jilalajba. Nanamukunyi Barasimukunyi, miku yalimi durrijba nanda yuwa nangangi Kudkanyi, ngala yalu durrijbangka yalungi yuwa. Nanankardi barri yalu jungku balki nangangi Kudkanyi, baki yalu yalilijba yingkamuku, yalu marda jungunkanyi balki nangangi.” ");
INSERT INTO wrk_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Yilikajbayi Jisus Bidawanyi, “Wanyi nanda jangkurr. Miku nurrimi jingkijba nanda nganyi jangkurr. Yanka barri jangkurrwanyi balkimbaka nanda nganinyi. Karukiyi nurrunya mili.” ");
INSERT INTO wrk_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","17","Jananganja nyuli Bida, Jisuswanyi, “Marda narri kuna. Miku narrimi kunyba kulaji jingkiykanyi yaji kuna. Miku kuna narrimi jingkijba ngaki jangkurr. Jungku kuna narri barrinani yalu. Jangayu karu narrinya nanankanyi jangkurranyi. Nanda mama jala narri jarrba, nanda mama ngankijbangka narrindu muwana. Mikukimi jungku nanda mama muwana yurrngumba. Nanda mama walajbangka muwananyi, mankanyinanyi. Nani barri miku narrimi jungku balki, jarrbangangi narri jawuda mama. ");
INSERT INTO wrk_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Ngala jaliyi narringka mankumanku balkinyi yajinyi, baki janarri yabimba balki yaji. Baki nani barri janarri jungku balkina yuwana Kudkanyi. Waluku nangka mankumanku nganinyi balkinyi, baki kamu janyulu yanyba balki jangkurr. ");
INSERT INTO wrk_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Kamu janyulu yabimba balki yaji. Kamu janyulu kurdanba yingka nganinyi. Kamu janyulu kuluka yingkana jibarrina, kamu janyulu maninjakujba yaji, kamu janyulu jujamba yaji. ");
INSERT INTO wrk_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Nani barri waluku nangka mankumanku nganinyi balkinyi yajinyi, baki kamu janyulu yabimba nanda balki yaji. Nani barri jungku nanda nganinyi balkina yuwana Kudkanyi. Ngala miku nyulimi jungku balkina yuwana Kudkanyi, jarrbangangi nyulili mama barrin. Barriwa.” ");
INSERT INTO wrk_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Barlbayi Jisus nanamunanyi yajinanyi. Barlba nyuli yingkayurri yajiyurri. Barlba nyuli langki, bundu nanankuyanyina barrawuyabarrawuyana, niji Daya marda Sayidun. ");
INSERT INTO wrk_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Ngala jungkuyi Jisus nanaba, baki jilajbayi jibarri nangandurri. Nanda jibarri, nangangi yaji niji Kayina, bundu nananyina yajina jali jungku nanamanji Jisus. Nanda kulunganja nangangi ngila, nyuli lunji. Lunji nyuli kudanyu barri. Jilajbayi jibarri nangandurri. Yanyba nyuli Jisuskanyi, “Mambuka. Ninji barrinani jandanyi nanankanyi wankalanyi Dayibidkanyi. Ngindukiyi muwa ngaki. Ngaki kulunganja nyulu wuwarryudi mankanyiyudi. Kudanyu nyulu lunjika. Janinji kuna jakajba nanda wuwarr ngilananyi mankanyinanyi. Janinji kuna jakajba nanda wuwarr, baki janyulu yuku jungku.” Nani nyuli ngajaka Jisus. ");
INSERT INTO wrk_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Nanda jibarri, nangangi yaji Kayinan, baki nyuli ngurranyi yalungi Jumukuyngka. Baki nanamuku Jumuku, miku yaliyanyi maruka muwa yalungi ngurranyimukuyngka barrinani nanankanyi jibarrinyi. Yalili yanyba, “Yingkamuku ngurranymuku, yalu barrinani bajangumuku.” Manku nyuli nanda jangkurr jibarrinyi Jisuswanyi, ngala miku nyuliyanyi jananganja nanda jibarri. Miku nyuliyanyi yanyba jangkurr. Ngala yali jilajba kandimuku nangandurri. Yililikajba yali Jisuskanyi, “Mambuka. Marda ninjimi barriwa manjijba nanda jibarri nganyinbunanyi. Nyulu durrijbangka ngambalanya. Janyulu yabimba kiji ngambalangi.” ");
INSERT INTO wrk_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Ngala nyuli jananganja nanda jibarri Jisuswanyi. “Ngana manjijbayi ngakinyi Buwakayu milidimbiji ngawamba yalunya, ngakinmuku mungkijimuku, Jumuku. Yalu barrinani jibmuku jala yalu yakika. Miku yalimi jingkijba yaji wanjawa jayalu jilajba. Manjijba ngani Buwakayu milidimbiji yalunya nangangi Kudkanyi. Barriwa.” ");
INSERT INTO wrk_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Jali manku nangangi jangkurr jibarriwanyi, baki mururu nyuli wayka walu nangandu. Baki yanyba nyuli nangangi, “Mambuka. Kunymambakiyi ngaki ngila.” ");
INSERT INTO wrk_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Jananganja nyuli nanda jibarri Jisuswanyi. “Waluku barri janurru wajba bayamuku mamanyi. Waluku jayalu jarrba kaja mama. Miku nurriyi wajba bajangumuku mamanyi waluwa. Waluku jayalu yalu jarrba yaji bayamukunyi. Ngayu Ju, ngala ninji ngurranyi ngaki. Badajba ngayi milidimbiji yalunya ngakinmuku mungkijimuku Jumuku. Badajba ngayi yabimbiji ngiruka yaji yalungi barri. Yalu barrinani nanamuku bayamuku. Miku ngayiyanyi badajba milidimbiji yalunya ngurranyimuku. Miku ngayiyanyi badajba yabimbiji ngiruka yaji yalungi. Yalu barrinani nanamuku bajangumuku.” ");
INSERT INTO wrk_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Yanybayi jibarri Jisuskanyi, “Yuku barri, mambuka. Ngala jala yalu jarrba mama bayamukunyi, jaliyi yirrba jawuda mama jambarri, baki nanda jarrbangka bajanguwanyi. Jarrbangka nanda bijal mama bajanguwanyi, jaliyi yirrba mama jambarri. Ngala jala ninji milidimba yalunya nganyinmuku mungkijimuku, baki kudiyamukunyi ngurranyimukunyi yalu marda mankuka nganyi jangkurr. Yalu marda kuyungka nganyi jangkurr. Janinji kuna yabimba ngiruka yaji yalungi marda ngurranyimukuyngka jala kuyu nganyi jangkurr. Janinji kuna kunymamba marda ngaki ngila.” ");
INSERT INTO wrk_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Baki nyuli jananganja jibarri Jisuswanyi, “Mirnarrijba ngayu muwa nanankanyi jangkurranyi jali ninji yanyba. Kudanyu barri nganinji jingkijba, yuku ngayu yabimba ngiruka yaji. Jangayu kunymamba nanda ngila. Wijbakiyi wayka barndarri ngilayurri. Nanda wuwarr barlbayi nanganbunanyi mankanyinanyi. Mikuyaji wuwarranyi nanaba ngilana mankanyina.” Ngala nyuli yanyba nanda jangkurr, baki kunybijbayi nanda ngila mankanyi. Barlbayi wuwarr jali yanyba Jisus nanda jangkurr. Barriwa. ");
INSERT INTO wrk_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Mili barlbayi Jisus, baki wijba nyuli kula nanankurri yajiyurri karriya nananyina kanjana niji Kalili. Kirrijba nyuli kingkarri dungalana, baki jungkurrijba nangki. ");
INSERT INTO wrk_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Badajbayi walkurra muramuku nangandurri, baki kuyu yalunjali kajamuku jala yalu lunji nangandurri. Kudiya yali balki nukami, kudiya yali kabuji yami, kudiya miku yaliyanyi jilalajba. Kudiya yali balki janyi, miku yaliyanyi yanyba jangkurr, kudiya yali yinini yinini ngalya. Kuyu yalunjali nangandurri Jisusyurri. Jungku yali walu nangandu baki nyuli kunymamba yalunya bukambiju. ");
INSERT INTO wrk_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Ngala yalu muramuku, manmala yali. Kudanyu yali manmala, jali yalu najba Jisus kunymambikurri yalunya. Najba yalunjali jali yalu balki janyi yanybikurri. Najbayi yalunya jali yalu balki nukami jilajkurri, marda yalunya jala kabuji yami naykanyi yaji. Baki mirnarrijba yali muwa nanankardi. Baki yali wajba Kud yalunginkanyi kunybanyi jangkurranyi. ");
INSERT INTO wrk_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Marndakaja barri jali yalu yuwajiwa jungku dungalana, kayayi Jisus yalungi nanganginmukuyngka kandimukuyngka, yalu jilaykanyi nangandurri. Badajba yali baki yanyba nyuli yalungi. Yanybayi Jisus, “Nginduka ngayu muwa yalungi nanginmukuyngka muramukuyngka. Yali jungku ngakindu kujarraka barndayka, baki nanijba barri mikuyaji mamanyi nayiba yalundu jarrkanyi. Warriyaluku. Birkalanyi yalu kudanyu barri. Jawuda yalingi barnda juju barri. Jalimi ngayu manjijba yalunya barndarri, baki yiningki jawuda jayalu jungku buwandiwa. Majabujba mankanyi yalu, birrkalanyingangi.” Nani barri yanybayi Jisus yalungi kandimukuyngka. ");
INSERT INTO wrk_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Yanybayi kandimuku nangangi Jisuskanyi, “Ngala yanka janurru wajba yalunya mamanyi, yanka barri. Miku nurriyi wudumba mama nanginyina mangkurruna yajina.” ");
INSERT INTO wrk_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Yilikajbayi yalunya Jisuswanyi, “Yankanu damba narrindu.” Jananganja yali, “Ngawamba 7 bayayawa damba, marda kudiya bayayawa kaku.” ");
INSERT INTO wrk_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Baki jirrinyba yalunyi muramuku Jisuswanyi, yalu jungunki jambana. ");
INSERT INTO wrk_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Baki wudumba nyuli nanda damba, marda kaku. Baki nyuli yanyba mududu nangangi Kudkanyi. Dalyamba nyuli nanda bayayawa damba baki kaku. Wajba nyuli yalunya kandimuku nanankanyi mamanyi, baki yalunjali wajba muramuku nanankanyi bayayawanyi dambanyi, marda kakunyi. Wajba yalunjali bukambiju mamanyi. ");
INSERT INTO wrk_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Jarrba yali nanda mama, baki wardijba yali muwa. Miku yaliyanyi jarrba bukamba nanda mama, kiliyi kudiya mama. Wudumba yali nanda mama kandimukunyi. Yarrijba yali bindawarrana, 7 bindawarra walbinyi. ");
INSERT INTO wrk_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Kajamukunyi yali jarrba nanda mama, mijimbangumukunyi. 4000 nganinyimuku, baki kajamuku jibarrimuku marda wawarramuku, walkurra muramuku. ");
INSERT INTO wrk_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Baki manjijbayi yalunya Jisuswanyi. Nyuli manjijba yalunya yalunginkurri barndarri. Baki nyuli ngankijba muwardana. Ngankijba nyuli muwardana, marda nanganginmuku kandimuku nangandu, baki jilajba yali bayangarrinybarri yingkayurri yajiyurri, niji Makadan. ");
INSERT INTO wrk_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Jala yali wanbiya bayangarrinybana, baki yingkamuku yali jilajba nangandurri Jisusyurri. Kudiya yali Barasimuku baki kudiya yali Sajusimuku jala yalu jurlwa nangangi Jisuskanyi. Jilajba yali nangandurri balanjanki Jisus. Yanyba yali Jisuskanyi, “Yabimbakiyi ngiruka yaji nurrungi, baki janurru jingkijba Kud, nyulu mirnarrijbangka muwa nganyi, ninji nangangi kandi. Nani janinya nurru jingkijba jaliyi ninji yabimba ngiruka yaji nurrungi.” ");
INSERT INTO wrk_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","3","Ngala jananganjayi yalunya Jisuswanyi, “Narri jingkijba nanda yaji lalijina. Yingkana kambana narri najba laliji, baki narri yanyba, ‘Miku. Mikuwali yirrba janja winyurru.’ Ngala yingkana kambana narri najba ngalu lalijina, baki narri yanyba, ‘Yirrbaja janja winyurru.’ Narri najba nanda laliji, baki narri jingkijba nanda yaji janjanyi. Ngala narri najbayi nanda ngiruka yaji jali ngayu yabimba, ngala miku narriyi jingkijba yaji. Miku nganarriyi jingkijba, jaliyi manjijba ngana Kudwanyi. ");
INSERT INTO wrk_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Ngala miku barri. Miku ngayiyi yabimba mili ngiruka yaji narringi. Narri jungku balki nangangi Kudkanyi. Miku narrimi ngayangayijba nanganginkanyi jangkurranyi ngirukanyi. Yi. Kajamuku yalu jungku balki barrinani narri. Miku ngayiyi yabimba mili ngiruka yaji narringi. Ngawamba yingamali ngiruka yaji janarri najba baku barri, barrinani nanda ngiruka yaji jali jungku Juna wanka muwana kakuna kujarraka barndayka. Ngawamba ngiruka yaji barrinani nani janarri najba yaji.” Nani barri jananganjayi Jisuswanyi. Barlba nyuli yalunbunanyi. ");
INSERT INTO wrk_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Ngankijba yali muwardana, baki mili yali jilajba karrurrinybarri kanjana, Jisus marda kandimuku. Ngala mamanumba yali yaji kandimukunyi. Mamanumba yali yaji damba. Mikuyaji mamanyi yalundu muwardana. ");
INSERT INTO wrk_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Yanybayi Jisus yalungi, “Marda narringkimi najbawa yalunginkanyi bululunyi yajinyi, Barasimukuyngka marda Sajusimukuyngka. Marda narringkimi najbawa yalunginkanyi bululunyi yajinyi.” ");
INSERT INTO wrk_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Jali manku nangangi jangkurr kandimukunyi, baki ngamu yanybayi Jisus dambanyi. Baki yanyba yalungki, “Mikuyaji dambanyi ngambalangi. Nanankardi barri nyuli yanyba nani barri, mamanumbangangi ngambali kuyunkanyi ngambalangi damba.” ");
INSERT INTO wrk_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Ngala mankuyi yalunya Jisuswanyi, baki nyuli yanyba yalungi, “Wanyingkanyi narringka yanyba nani dambanyi. Miku kuna narrimi jingkijba ngaki jangkurr. Miku kuna narrimi kuyu ngaki jangkurr. ");
INSERT INTO wrk_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Miku kuna narrimi jingkijba ngaki jangkurr. Miku kuna narrimi mankumankuwa nanda wabulinyi yaji jali ngayu yabimba, jali kajamukunyi yalu jarrba damba marda kaku, baki wardijba yali muwa. Miku kuna narrimi jingkijba nanda yaji jali waluku ngayi dalyamba damba yalungi 5000kanyi. Yankanu bindawarra narri wudumbayi nanda mama, jali yalu yingijba. Yankanu barri. ");
INSERT INTO wrk_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Baki mili jangkurr ngayu ngajaka narrinya. Buyingka barri baku mili ngayi dalyamba mama yalungi muramukuyngka 4000kanyi. Dalyamba ngayi 7 damba yalungi waluwa yali jarrba. Bayngkani barri yankanu bindawarra narri wudumbayi nanda mama nanamanji, jali yalu yingijba. Yankanu barri. Mamanumba kuna narri nanda jali ngayu kujarraka yabimba damba. ");
INSERT INTO wrk_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Jaliyi narri mankumankuwa nanda yaji jali ngayu yabimba, baki marda nganarrimi jingkijba. Marda nganarrimi jingkijba, yuku ngayu wajba narrinya dambanyi. Yuku ngayu wajba narrinya mamanyi jala narri nulijba. Jaliyi nganarri jingkijba nani, baki marda narrimi jingkijba ngaki jangkurr nanankanyi yalunginkanyi bululunyi yajinyi. Miku ngayiyanyi yanyba nanankanyi mamanyi narri jarrkanyi, ngala ngayi yanyba yalunginkanyi yuwanyi jalili yalunjalu milidimba, Barasimukunyi baki Sajusimukunyi. Jala narri yabimba damba, baki narri yarrijba nanda bululu yaji kandirrina, baki bululunbaka mama. Walkurramba mama bululuwanyi yajiwanyi. Baki nani barri nanda yuwa jalili yalunjalu milidimba Barasimukunyi baki Sajusimukunyi. Waluku barri kudiyamukunyi yali kuyu yalungi yuwa, yali durrijba nanda yuwa, ngala baku barri mili yali kuyu nanda yuwa, baki mili baku barri. Baki nanijba barri kajamukunyi yalu kuyungka nanda yuwa, yalu durrijbangka nanda yuwa. Ngala narri barri, marda narringkimi najbawa nanankanyi yuwanyi. Miku nanda nangangi yuwa Kudkanyi. Nanda ngawamba yalungimayngka yuwa. Nanda balki yuwa. Baki nanankardi barri marda narringkimi najbawa yalunginkanyi yuwanyi. Barriwa.” ");
INSERT INTO wrk_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Jali yanyba Jisus nanda jangkurr yalungi, baki jingkijba yali yaji kandimukunyi. Jingkijba yali nanda jangkurr jali yanyba Jisus barrin bululunyi yajinyi. Miku nyuliyanyi yanyba bululunyi yajinyi jala walkurramba damba, ngala nyuli yanyba yalunginkanyi yuwanyi Barasimukuyngka marda Sajusimukuyngka. Nyuli yanyba yalunginkanyi balkinyi yuwanyi. Barriwa. ");
INSERT INTO wrk_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Baku barri mili yali jilajba langki, Jisus marda nanganginmuku kandimuku. Jilajba yali langki nanankurri yajiyurri, bundu nananyina barrawuyabarrawuyana, niji Sisariya Bilibayi. Ngala yali jilajba yubalina, ngajaka nyuli nangangi kandimuku Jisuswanyi, “Ngayu Buwanya Bukambijuyngka, wanyingkanyi yalu yanybaka ngaki, wanyi ngayu, wanyi. Wanyingkanyi yalu yanyba ngaki, wanyi ngayu.” ");
INSERT INTO wrk_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Jananganja yali Jisus nanganginmukunyi kandimukunyi, “Yanybaka yalu yinini yinini jangkurr nganyi. Yingkamuku yalu yanybaka nganyi, ninji Jun Ngurrunbawarr. Yingkamuku yalu yanybaka nganyi, ninji nanda wankalanyi Yalayija mili wankiykanyi. Yingkamuku yalu yanyba nganyi, ninji wankalanyi jali yanyba jangkurr Kudkanyi, yiningki Jirimaya, yiningki yingka.” Barriwa. ");
INSERT INTO wrk_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Yanybayi Jisus yalungi, “Ngala narri barri, wanyingkanyi narri yanybaka ngaki, Wanyi ngayu, wanyi.” ");
INSERT INTO wrk_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Baki jananganjayi Bidawanyi, “Ninji barri Krayis. Ninji Jandanyi nangangi Kudkanyi, jala nyulu jungku wanka yurrngumba. Ninji nanda Krayis, jali manjijba Kudwanyi.” Nani barri jananganjayi Bidawanyi. Kamambarra barri yanybayi Kud yalungi wankalanyi. Karuyi yalunya, baku barri juju, janyulu manjijba walkurra mambuka. Janyulu jilajba nanda mambuka lalanbiji yalunya Jumuku. Baki jayalu nijarrijba nanda mambuka ‘Krayis’. Jingkijbayi Bidawanyi, nanda nganinyi Jisus, nyulu nanda mambuka Krayis, jali manjijba Kudwanyi. ");
INSERT INTO wrk_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Baki yanybayi Jisus nangangi Bidanyi, “Nanda jangkurr nganyi, nanda kunyba jangkurr. Sayimin Bida, ninji jandanyi nangangi Junkanyi. Mikukiyanyi yingkawanyi karu ninya nanankanyi jangkurranyi, ngala ngakinyi Buwakayu Kingkarri nyuli ninya karu nanankanyi jangkurranyi ngaki. Nyuli ninga karu ngaki, ngayu barri Krayis. ");
INSERT INTO wrk_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Ngayu karungka ninya. Nganyi niji Bida, nanda niji Krik yanyi barrinani ‘dungala’. Baki ninji barrinani nanda dungala. Janinji jungku ngiruka barrinani nanda ngiruka dungala. Janinji kuyu ngaki jangkurr, baki janinji marrimba ngaki jangkurr mardarda nganyinyina kurduluna yurrngumba barri. Janinji kuyu ngaki jangkurr, baki janinji milidimba yalunya ngakinkanyi jangkurranyi. Baki kajamukunyi jayalu durrijba ngaki jangkurr, ninjingangi ngiruka milidimbikanyi yalunya. Baki jayalu marda jungku ngiruka ngaki. Baki miku nyuliyi yangkalamba yalunya Sayidinwanyi. Miku nyuliyi yangkalamba yalunya ngakinbunanyi, jungkungangi jayalu ngiruka ngaki. Baki jalija yalungka janyba, baki janyulu mili wankamba yalunya Kudwanyi, yalu jungunkanyi nangandu kingkarri. Miku nyuliyi jarimba yalunya Yilyurri nanangini Sayidinwanyi, jungkungangi yalu ngiruka ngaki yurrngumba barri. ");
INSERT INTO wrk_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Ninji Bida, baki nanginmukunyi ngakinmukunyi kandimukunyi marda, janarri karu yalunya yingkamuku ngakinkanyi kunybanyi jangkurranyi. Yingkamuku jalija yalu kuyu nanda jangkurr, janarri karu yalunya nangangi Kudkanyi, janyulu lalanba yalunya. Ngala yingkamuku jalija yalu miku kuyu ngaki jangkurr, janarri karu yalunya nangangi Kudkanyi, miku janyulu lalanba yalunya, ngala janyulu janyba yalunya nanganbunanyi. Jaliyi narri manjamanjamba nanda balki yaji yalungi, baki janyulu najba yalunya Kudwanyi jungunkanyi kunybana yuwana. Jaliyi narri miku manjamanjamba yalungi balki yaji, baki yuwajiwa jayalu jungku balkina yuwana.” Nani barri yanybayi Jisus yalungi. ");
INSERT INTO wrk_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Baki jirrinybayi yalunya Jisuswanyi. Yanyba nyuli kudanyu yalungi, “Miku narriyi karu yalunya yingkamuku nanankanyi jangkurranyi ngaki, ngayu Krayis. Miku. Barriwa.” ");
INSERT INTO wrk_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Nanamunanyi barri milidimbayi yalunya yurlurrmba jangkurranyi Jisuswanyi. Nyuli milidimba yalunya nanganginmuku kandimuku yurlurrmba jangkurranyi. Yanyba nyuli, “Ngayu karungka narrinya, jangayu barlba kula nanankurri Jirusalimyurri, baki jayalu yabimba kiji ngaki nanaba. Nanamukunyi mambukamukunyi baki malbumalbuwanyi jurjkanyi, baki milidimbawarrmukunyi yuwanyi, jayalu yabimba kiji ngaki nanaba. Janganjalu manjijba janybiji ngaka. Jangaka janyba, ngala baku barri kujarraka barndayka, jangayu mili wankijba barri.” ");
INSERT INTO wrk_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Nani barri nyuli milidimba yalunya. Ngala nanangini kandiwanyi Bidawanyi, nyuli kuyu Jisus danbiyurri, baki yanybayi Bida nangangi Jisuskanyi. Kudanyu yanyba nyuli nangangi, “Mikujiyi yanyba nanda jangkurr, yalu yabimbikanyi kiji nganyi, marda janybikanyi nganyingka. Mikujiyi yanyba nani barri, mambuka.” ");
INSERT INTO wrk_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Yangkalamba nangki Jisus mankanyi. Ningkijba nyuli Bida, baki yanybayi nangangi, “Barriwa barri. Barlbakiyi ngakinbunanyi. Miku nganinjiyi kurrkunba nani, yabimbikanyi nangangi yaji Kudkanyi. Nyuli yanyba nanda jangkurr ngaki Sayidin. Nyuli karu ninya Sayidinwanyi, ninji yanybiji nanda jangkurr ngaki. Miku nganyingkimi mankumanku yajinyi barrinani nangka mankumankuka Kud yajinyi. Ngala nganyingka mankumankuka barrinani nganinyi nangka mankumankuka yajinyi.” ");
INSERT INTO wrk_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Baki yanybayi Jisus yalungi kandimukuyngka, “Jaliyi narri nulijba jilaykanyi ngakindu, baki marda narringkimi miku lalanba narringka. Marda narrimi yurlwa narringinkanyi yajinyi. Mardakimi nanda narringi yaji miku jirrinyi narringi. Jaliyi narri jilajba ngakindu, baki yiningki kurdanbaja narrinya yingkawanyi. Yiningki janyulu kurdanba narrinya, milidimbangangi narri ngaki jangkurr. Barriwa. ");
INSERT INTO wrk_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Jaliyi narri kudanyu nulijba jungunkanyi wanka nayiba yajina yurrngumba, baki janarringka janyba. Ngala jaliyi narringka janyba, mikungangi narringkiyi yangkalamba ngakinbunanyi, ngala narri durrijbayi ngaki jangkurr kudanyu barri, jaliyi narringka janyba nanankardi, baki janarri mili jungku wankan yurrngumba barri. ");
INSERT INTO wrk_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Mankumanku narringka nganiyngkanyi jirdi kajanyi yajinyi. Mirnarrijba nyulu muwa nanganginkanyi yajinyi, ngala warriyaluku, mankumanku nangka nanganginkanyi yajinyi, ngala miku nangkimi mankumanku nangangi Kudkanyi. Nangangi yaji jirrinyi nangangi, ngala miku nyulu Kud jirrinyi nangangi. Jalija nangka janyba, baki miku janyulu mili wanka jungku. Mikuwali nanganginyi yajiwanyi mili wankamba nanda nganinyi. ");
INSERT INTO wrk_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","28","Kudiya narri jala narri jungku nayiba ngakindu, janganarri najba janybikurri ngaka. Baki janganarri najba mili wankiykurri baku barri. Kudiya narringi miku narringkiyi janyba waluwa ngayuja wijba. Baku barri ngayu Buwanya Bukambijuyngka, jangayu jungku kingkarri nangandu ngakinyina Buwakayu, baki janyulu lalanba yalunya bukambiju, jala yalu kuyu ngaki jangkurr. Janyulu lalanba yalunya kudanyu barri. Jangana nyulu yarrijba walkurra mambuka barrinani nyulu. Marda nanganginmuku Yanjilmuku, jayalu ngakinmuku wakiwarrmuku marda. Baki baku barri janyulu karrinjarrijba yalunya bukambiju walu ngalindu nyalinyalimbikanyi yalunya. Nanamanji barri jangana nyulu yarrijba Kudwanyi, ngayu karunkanyi yalunginkanyi yajinyi. Jangayu yabimba balki yaji yalungi jali yalu jungku balki yurrngumba. Jangayu manjijba yalunya wayka Yilyurri. Ngala nanamuku jali yalu jungku kunyba, jangayu yabimba kunyba yaji yalungi. Jangayu manjijba yalunya kingkarri, jungunkanyi nangandu Kudnyina yurrngumba barri. Barriwa.” Nani barri yanybayi Jisus yalungi. Barriwa. ");
INSERT INTO wrk_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Baku barri, 6 kambana baku, kirrijba yali dungalana, Jisus marda murrku nanganginmuku kandimuku, Bida marda buwakula Jayims baki Jun. Kirrijba yali juju kingkarri yundurrinybana dungalana yaluman. ");
INSERT INTO wrk_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Jali yalu jungku nanaba yundu, baki yangkalamba nangki Jisus. Wali nangangi bilirrbayi, barrinani kamba, jali nangka yangkalamba Jisus. Marda jumbala nangangi, bilirrbayi bunyala. ");
INSERT INTO wrk_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Baki yali najba Jisus, murrkuwanyi, marda yali najba kujarra mili karrinjankurri wilina nangandu. Buli malbuwuya wankalawuya jali bula jungku juju wabula kamambarra. Yingka wankala nyuli Musis, marda yingka wankala nyuli Yalayija. Badajba buli kingkarrinya. Yanyba yalungki malbuwuya baki Jisus. Barriwa. Nani barri yali najba yaji kandimukunyi. Najba yali Jisus marda malbuwuya yanybikurri yalungka. Barriwa. ");
INSERT INTO wrk_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Yanybayi Bida Jisuskanyi, “Mambuka. Yuku barri kunyba nurru nayiba naykanyi narrinya. Jangayu yabimba murrku ngarndu wanjirr, yingka nganyi, yingka nangangi Musiskanyi marda yingka nangangi Yalayijakanyi. Yabimba jangayu ngarndu narringi.” Ngala muningka yanybayi Bida nanda jangkurr. ");
INSERT INTO wrk_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Jala yanybayi Bida nani barri, baki walajbayi ngalu. Walajbayi ngalu waykalinya, baki bilirrbayi. Murumbayi yalunya ngaluwanyi. Baki yali manku jangkurr ngaluna kandimukunyi. Yanybayi Kud ngaluna, “Nayinda ngaki jandanyi, jala ngayu maruka muwa nangangi. Mankukiyi nangangi jangkurr.” Barriwa. ");
INSERT INTO wrk_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Jali yalu manku nanda jangkurr kandimukunyi, baki marrala yali. Kudanyu yali marrala, baki yirrba yali jambarri, wayka wali. ");
INSERT INTO wrk_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Ngala badajbayi Jisus yalundurri. Marrimbayi yalunya, baki yanybayi, “Walajbakiyi. Miku narriyi marrala.” ");
INSERT INTO wrk_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Baki walajba yali waykalinya, baki kujba yalungki lukuluku, ngala miku yaliyanyi najba nanankujarra wankalawuya. Mikuyaji bulangi nanaba, ngawamba karrinjayi Jisus yalundu. Barriwa. ");
INSERT INTO wrk_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Karrala yali wayka dungalananyi. Ngala yali karrala wayka, baki yanybayi Jisus yalungi. Jirrinyba nyuli yalunya, “Mikujiyi karu yalunya nanankanyi jali narri najba. Ngayu Buwanya Bukambijuyngka, jangaka janyba, ngala baku barri jangayu wankijba mili. Yuku barri nanamanji baku janarri karu yalunya nanankanyi jali najba nanaba dungalana. Yuku barri nanamanji baku, ngala jilijbawa yaji.” Barriwa. ");
INSERT INTO wrk_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Jali yalu karrala wayka, baki yilikajba yali Jisus kandimukunyi, “Nanamuku milidimbawarrmuku yuwanyi, wanyingkanyi yalili yanyba nayi barri, ‘Waluku janyulu wijba nanda wankalanyi Yalayija. Janyulu wijba waluku.’ Wanyingkanyi yali yanyba nani barri. Wanyingkanyi.” ");
INSERT INTO wrk_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Jananganja nyuli yalunya Jisuswanyi, “Yuku barri. Yanybayi Kud najana. Yanyba nyuli nayi ‘Waluku barri janyulu badajba. Janyulu badajba nanda barrinani Yalayija. Janyulu badajba karunki yalunya kunybanyi jangkurranyi, baki janyulu kunymamba bukamba yaji. Janyulu karu yalunya, marda yalimi ngindu muwa, yurlwangangi yalu nanankanyi yuwanyi Kudkanyi. Waluku barri janyulu badajba, baki baku barri badajbaja nanda yingka Buwanya Bukambijuyngka. Janyulu badajba bayngkani nangandu nananyina barrinani Yalayija. Barriwa.’ ");
INSERT INTO wrk_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Ngala ngayu karungka narrinya nanginkanyi jangkurranyi. Nanda nganinyi barrinani Yalayija, ngala nyuli badajba yalundurri, ngala yali yurlwa nangangingangi. Miku yaliyanyi kandimbangangi. Baki nani barri marda jayalu jungku ngaki, Buwanya Bukambijuyngka. Jayalu yurlwa ngaki. Jangananjalu ngirra. Jangananjalu daba.” Barriwa. ");
INSERT INTO wrk_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Baki yali jingkijba nangangi jangkurr kandimukunyi. Jingkijba yali, nyuli karu yalunya nangangi Junkanyi Ngurrunbawarrayngka. Nanda Jun, nyuli nanda barrinani Yalayija jali badajba. Barriwa. ");
INSERT INTO wrk_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Karrala yali kula wayka jambarri, Jisus marda kandimuku nangangi. Wijba yali yalundurri, yingkamukuyngkurri kandiyurri yalungi. Walkurra muramuku yali jungku nanaba yalundu kandimukunyina. Baki jilajbayi Jisus yalundurri. Jali nyulu wanbiya yalundu, baki jilajbayi nganinyi nangandurri Jisusyurri. Mururu nyuli wayka nangandu Jisusnyina. ");
INSERT INTO wrk_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","Baki yanyba nyuli, “Mambuka. Ngayu ngajaka ninga, janinji ngindunki muwa ngakinkanyi jandaynkanyi. Warriyaluku ngaki jandanyi. Ngankijbayi wuwarr nangandu mankanyina. Balkimbaka kaburr wuwarrwanyi. Janybaka nanda kaburr wuwarrwanyi kudiyana jangurri, kudiyana wabudarri. ");
INSERT INTO wrk_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Ngayi ngajaka yalunya, nganyinmuku kandimuku. Ngayi ngajaka yalunya jakaji nanda wuwarr, ngala miku yaliyi jakajba. Miku yaliyi kunymamba ngaki jandanyi, miku.” ");
INSERT INTO wrk_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Yanybayi Jisus yalungi, muramukuyngka. “Bukambiju narri jala narri wanka jungku nanijba, miku narrimi kuyu ngaki jangkurr. Narri yurlwangka ngaki. Ngayu jungkuka narrindu yurrngumba. Ngayu milidimbaka kaja narrinya, ngala miku narrimi kuyu ngaki jangkurr. Wanyimbala janarri kuyu ngaki jangkurr. Wanyimbala.” Baki yanybayi Jisus nijanganjiyngkanyi, “Kuyukiyi nanda kaburr ngakindurri. Kuyukiyi.” ");
INSERT INTO wrk_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Kuyu nyuli nangangi jandanyi nangandurri Jisusyurri, baki nyuli jirrinyba nanda wuwarr. Jirrinybayi wuwarr walaji kaburrnanyi mankanyinanyi. Walajbayi nanda wuwarr kaburrnanyi, baki kunybijbayi nanda kaburr. ");
INSERT INTO wrk_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Kamu barri, barlba yali yalunbunanyi muramukunanyi. Barlbayi Jisus marda kandimuku. Jali yaluman jungku, baki yali ngajaka Jisus kandimukunyi, “Yuku ninji jakajbayi nanda wuwarr. Ngala wanyingkanyi miku nurriyi jakajba. Wanyingkanyi.” ");
INSERT INTO wrk_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Jananganjayi yalunya Jisuswanyi, “Narri kuyu ngaki jangkurr, ngala miku narrimi kudanyu kuyu ngaki jangkurr. Jalimi kudanyu narri kuyuyi ngaki jangkurr, baki yuku janarri jakajba wuwarr barrinani ngayu. Ngayu karungka narrinya nanginkanyi jangkurranyi. Jaliyi narri kuyu ngaki jangkurr, jaliyi narri jingkijba ngaki jangkurr, nanda duja jangkurr ngaki, baki yuku janarri yabimba ngiruka yaji. Ngiruka yaji janarri yabimba marda, jaliyi narri jingkijba ngaki jangkurr duja barri. Yuku janarri yanyba nanankanyi dungalanyi, ‘Dungala. Barlbakiyi nanamunanyi yajinanyi. Jungkukiyi nanaba yingkana yajina.’ Jaliyi narri yanybaka nani dungalanyi, baki janyulu barlba. Janyulu jungku yingkana yajina. Yuku janarri yabimba bukamba yaji, jaliyi narri kudanyu kuyu ngaki jangkurr. ");
INSERT INTO wrk_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Baki mili yali barlba nanamunanyi yajinanyi, Jisus marda nanganginmuku kandimuku. Jilajba yali kula. Jali yali wanbiya nananyina walkurranyina yajina Kalili, baki yanybayi Jisus yalungi, “Jawudawanyi, janganjalu wudumba Buwanya Bukambijuyngka. ");
INSERT INTO wrk_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Janganjalu marrimba baki janganjalu kurdanba. Jangaka janyba, ngala baku barri jangayu wankijba mili. Kujarraka barndayka jangayu mili wankijba. Barriwa.” Jali yalu manku nangangi jangkurr Jisuskanyi, baki yali ngindu muwa kandimuku. Kudanyu yali ngindu muwa nangangi. Barriwa. ");
INSERT INTO wrk_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Mili yali barlba kula Kabirnayumyurri, baki wanbiya yali barrawuyabarrawuyana. Ngankijbayi Jisus kalawuyngkurru barrawuna, ngala yuwajiwa karrinjayi Bida danbina. Yalu jalili yalu wudumba dungala yalunbunanyi walkurrayngka jurjkanyi, yali jilajba nangandurri Bidayurri. Ngajaka yali Bida, “Nganyinyi milidimbawarranyi nyulu kuna wajbangka yalunya dungalanyi walkurrayngka jurjkanyi. Nyulu kuna wajbangka yalunya dungalanyi jurjkanyi.” ");
INSERT INTO wrk_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Jananganjayi yalunya Bidawanyi, “Yi. Nyulili wajba dungalanyi walkurrayngka jurjkanyi.” Barriwa. Baki ngankijbayi Bida barrawuna jali jungku Jisus nanaba. Baki waluwa nyuluwarri yanybayi Jisus nangangi, Sayimin Bida, “Wanyingkanyi ninji yanyba. Wanyingkanyi. Wanjangini mardakimi wajba walkurra Kubamin mambuka dungalanyi. Nanganginmukunyi jandanyimukunyi kuna. Nanamukunyi ngurranyimukunyi kuna jalili yalu jungku nanaba nanganginyina yajina. Wanyingkanyi ninji yanyba.” ");
INSERT INTO wrk_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Jananganjayi Bidawanyi, “Nanamukunyi ngurranyimukunyi jalili yalu jungku nanaba nanganginyina yajina, marda yalimi wajba nanda Kubamin mambuka dungalanyi. Ngala miku nanganginyi jandanyimukunyi, miku yaliyi wajba dungalanyi.” Barriwa. Baki yanybayi Jisus nangangi Bidanyi, “Yanyba ninji duja jangkurr. Mardakimi miku jandanyimukunyi wajba Kabamin mambuka dungalanyi. Yuku yalu muningka jungku. Miku yaliyi wajba nanda mambuka. Barriwa. Ngala ngayu nangangi jandanyi Kudkanyi baki marda ngayimi miku wajba yalunya mambukamuku jurjkanyi dungalanyi. Nanda jurj, nanda nangangi yaji ngakinkanyi Buwakaya Kingkarri. Nanankardi barri marda ngayu muningka jungku, miku waykanyi dungalanyi. ");
INSERT INTO wrk_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Ngala yalu mambukamuku jurjkanyi, yiningki jayalu kijiwijba, jaliyi miku nungkala wajba yalunya dungalanyi. Jilajbakiyi wayka kanjarri, baki wajarrijbakiyi kakunyi. Nanda lirrka kaku jalija ninji wakaramba, dalamba ninji nangangi janyi. Nanaba janyina janinji wakaramba yingamali dungala. Dulabakiyi nanda dungala kakunanyi janyinanyi. Wajbakiyi yalunya nanankanyi dungalanyi. Nani janinji wajba yalunya dungalanyi jala yalu nulijba niyangi waykanyi yalunya dungalanyi. Barriwa.” ");
INSERT INTO wrk_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Nanamanji barri badajba yali nangandurri Jisusyurri nanganginmuku kandimuku. Badajba yali nangandurri, baki yilikajba yali, “Nimbala Kud, nimbala walkurrawuya mambukawuya nanankanyi yajinyi kingkarri. Ngala wanyi janyulu jungku walkurra mambuka bayngkani nimbalandu. Wanyi barri.” ");
INSERT INTO wrk_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Ngala wudumbayi juka Jisuswanyi. Karrinjarrijba nyuli nanda juka burrandi yalundu. ");
INSERT INTO wrk_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","5","Baki yanybayi Jisus yalungi kandimukuyngka, “Najba janarri nayinda juka. Narri nulijbangka jungunkanyi walkurra mambuka, ngala marda narringkimi yangkalamba kurdulu, marda narrimi jungku bayakarda barrinani nayinda juka. Miku nyulu walkurra mambuka, ngala muningka nyulu bayakarda. Jaliyi narringka miku yangkalamba kurdulu, jaliyi narri miku jungku bayakarda barrinani nayinda juka, baki miku janyulu lalanba narrinya Kudwanyi. Marda narrimi lalanba yalunya nanamuku jala yalu miku walkurra mambuka, ngala muningka bayakarda jungku. Marda narrimi lalanba nanamuku jala yalu bayakarda barrinani nayinda juka. Jala narri lalanbaka nanda bayakarda, baki nanda barrinani jala nganarri lalanba. Nanda barrinani jala nganarri lalanbaka, marukangangi ngayu muwa yalungi bayakardanyi. Maruka ngayu yalungi jala narri lalanba yalunya. Jala nganarri lalanbaka, baki nanda barrinani jala narri lalanbaka Kud, manjijbangangi ngani Kudwanyi narrindu. Nanda jala lalanbaka yalunya bayakardamuku, janyulu nyulu walkurra nganinyi bayngkani ngalindu. ");
INSERT INTO wrk_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Yalu kuyungka ngaki jangkurr bayamukunyi. Yalu yabimbaka kunyba yaji ngaki. Jaliyi yingkawanyi nyulu milidimbaka bayamuku yalu yabimbikanyi balki yaji, baki nanda balkimirra. Nanda balkimirra jaliyi yingkawanyi nyulu milidimbaka bayamuku, yalu yabimbikanyi balki yaji. Dabaja nanda nganinyi kudanyu barri Kudwanyi. Jaliyi nyulu yabimba balki yaji nani barri, baki marda nangkimi janyba. Jaliyanyi nangka janyba wabula, baki miku nyuliyanyi yabimba bayamuku, yalu yabimbikanyi balki yaji. Jaliyanyi nangka janyba wabula, baki miku nyuliyanyi yabimba nanda balki yaji nani barri, baki miku nyuliyanyi daba nanda nganinyi Kudwanyi. ");
INSERT INTO wrk_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Marda narringkimi miku yangkalamba nanganbunanyi Kudnanyi. Kudiya jayalungka yangkalamba nanganbunanyi, baki nanda balki. Baki kudiyawanyi jayalu balanja narrinya. Jayalu nulijba narringi, narringka yangkalambikanyi nanganbunanyi Kudnanyi. Najbawa narringkiyi. Jaliyi narri munyajba yingka, nyulu yangkalambikurri narrinya nanganbunanyi Kudnanyi, baki nanda balki. Ngala nanda jala balanjaka narrinya, jala nulijbangka narringi, narringka yangkalambikanyi nanganbunanyi, nanda jala balanjaka narrinya nani, baki nyulu jungkuka balki. Nyulu barri balkimirra. Janyulu mankuwa nangangi balki yaji Kudwanyi. ");
INSERT INTO wrk_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Ninji yabimbaka yaji marniyudinyi. Jaliyi nganyingka mankumanku yabimbikanyi balki yaji nganyinjudinyi marniyudinyi, baki nanda balki. Jaliyi nganyingka mankumanku yabimbikanyi nanda balki yaji, jaliyi ninji yabimba nanda balki yaji, baki miku ninjiyi jilajba kingkarri nangandurri Kudyurri, ngala janinji jilajba wayka jangurri Yilyurri. Ninji jilajbangka nukamina. Jaliyi nganyingka mankumanku jilaykanyi nukamina, ninji yabimbikanyi balki yaji, baki nanda balki. Jaliyi nganyingka mankumanku jilaykanyi baki yabimbikanyi nanda balki yaji, jaliyi ninji jilajba baki yabimba nanda yaji, baki miku ninjiyi jilajba kingkarri nangandurri Kudyurri, ngala janinji jilajba wayka jangurri Yilyurri. Marda nganyingkimi kurrkunba yabimbikurri nanda balki yaji marniyudinyi, marda nganyingkimi kurrkunba jilaykurri nukamina yabimbiji nanda balki yaji, baki janinji jilajba kingkarri nangandurri Kudyurri. Barriwa. ");
INSERT INTO wrk_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Ninji najbangka yaji yamiyudinyi. Jaliyi ninji najba yaji, baki nanankardi nganyingka mankumanku yabimbikanyi balki yaji, barrinani jala ninji najba yingka jibarri, baki nganyingka mankumanku kulukankanyi nangandu. Jaliyi nganyingka mankumanku nanankanyi balkinyi yajinyi nani barri, jaliyi ninji yabimba nanda balki yaji, baki nanda balki. Jaliyi nganyingka mankumanku nanankanyi jali ninji najba, baki ninji yabimba nanda balki yaji, baki miku janinji jilajba kingkarri nangandurri Kudyurri, ngala janinji jilajba wayka jangurri Yilyurri. Marda nganyingkimi kurrkunba yabimbikurri nanda balki yaji jali ninji najba, baki janinji jilajba kingkarri nangandurri Kudyurri. Barriwa. ");
INSERT INTO wrk_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","11","Nanamuku bayayawamuku, marda narrimi miku yurlwa yalungi, ngala marda narrimi kudanyu maruka muwa yalungi. Marda narrimi lalanba yalunya. Ngaki Buwakanya jala jungkuka kingkarri lalijina, kajamuku nanganginmuku Yanjilmuku, jala yalu waki nangangi. Yalunjalu lalanbaka bayayawamuku bayamuku Yanjilmukunyi. Yalunjalu lalanbaka yurrngumba barri, baki marda narrimi lalanba yalunya marda. ");
INSERT INTO wrk_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","Mankumanku narringka nanginkanyi jangkurranyi, jalija ngayu muningka yanyba narringi. Yingka nganinyi, nyulu lalanbawarr jibkanyi. Kajamuku nangangi jibmuku, wirdikudukudu, 100 barri. Yingamali nangangi jib, jilajbayi nyubana, baki yakika nyuli. Mikuwali wijba nganinyiyurri. Baki nginduyi muwa nanda lalanbawarr nangangi. Yingkijba nyuli nanganginmuku yingkamuku jibmuku barrikina, ngala nyuli kujba nanankanyi yingamaliyngka jali yakika munjimunji. ");
INSERT INTO wrk_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Kudanyu nyuli kujba nanankanyi jibkanyi, baki wakara. Wakaramba nyuli, baki mirnarrijba nyuli muwa. Yingkamuku nanganginmuku jibmuku mardarda yali jungku barrikina, baki mirnarrijba nyuli muwa yalungi. Ngala kudanyu barri nyuli mirnarrijba muwa jali nyulu wakaramba nanda yingka jali yakika. ");
INSERT INTO wrk_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Nanamuku bayayawamuku, yalu barrinani jibmuku. Baki Kud nyulu barrinani nanda lalanbawarr jibkanyi. Jaliyi yingamali yalungi bayayawamukuyngka, jaliyi nangka yangkalamba nanganbunanyi Kudnanyi, baki nyulu nginduka muwa Kud nanankanyi. Kudanyu nyulu nginduka muwa nanankanyi. Ngala jaliyi mili nangka yangkalamba nangandurri Kudyurri, baki mirnarrijbangka muwa Kud nangangi. Mirnarrijbangka nyulu muwa yalungi jala yalu durrijba nangangi yuwa yurrngumba, ngala kudanyu barri nyulu mirnarrijbangka muwa yalungi, jala yalu mili wijba nangandurri. ");
INSERT INTO wrk_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","Jaliyi yingkawanyi nyulu yabimbaka balki yaji nganyi, nganyinyi kandiwanyi, baki marda ninjimi miku karu yalunya yingkamuku nanankanyi balkinyi yajinyi jali nyulu yabimba nganyi. Ngala marda ninjimi jilajba nangandurri jali yabimba balki yaji nganyi. Marda ninjimi jilajba nangandurri, baki kardarda yanyba nangangi nanankanyi yajinyi jali nyulu yabimba nganyi. Yiningki janyulu ngindu muwa nanankanyi balkinyi yajinyi. Jaliyi nyulu ngindu muwa, baki janinji manjamanjamba nanda balki yaji, jali nyulu yabimba nganyi, baki janimbala mili jungku kandiyarra. ");
INSERT INTO wrk_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Ngala jaliyi nyulu miku ngindu muwa nanankanyi balkinyi yajinyi, baki marda ninjimi mili wijba nangandurri bayngkani barri. Marda ninjimi kuyu yiningki yingamali, yiningki kujarra nganinyiwuya nganyindu, baki mili janinji yanyba nangangi nanganginkanyi balkinyi yajinyi. Nayi barri yanybaka naja Kudkanyi, ‘Jala ninji yanyba yingkanyi nanankanyi balkinyi yajinyi jali nyulu yabimba, baki mardakimi yiningki kujarra, yiningki murrku jungku nganyindu mankunki nimbalangi jangkurr. Jayalu manku nimbalangi jangkurr, baki jayalu jingkijba wanyi jangkurr dujanya.” Nani yanybaka jangkurr najana Kudkanyi, baki nanankardi barri marda ninjimi kuyu bulanya nganyindu, jala ninji mili yanyba nanankanyi jali yabimba balki yaji nganyi. ");
INSERT INTO wrk_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Ngala jaliyi nyulu yurlwa bulanginkanyi jangkurranyi marda, baki marda ninjimi karu yalunya, jala yalu malumba jungku jurjina, jala kuyu nangangi jangkurr Kudkanyi. Marda ninjimi karu yalunya nanankanyi balkinyi yajinyi jali nyulu yabimba nganyi. Baki jaliyi nyulu yurlwa yalungi marda bukambijuyngka, baki marda yalimi yanyba nangangi, miku nyuliyi mili jilajba jurjyurri. Miku nyuliyi mili jungku yalundu. Barriwa. ");
INSERT INTO wrk_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Kudanyu ngayu karungka narrinya, jaliyi narri manjamanjamba balki yaji yalungi, baki Kudwanyi janyulu najba yalunya jungunkanyi kunybana yuwana. Ngala jaliyi narri miku manjamanjamba yalungi balki yaji, baki yuwajiwa jayalu jungku balkina yuwana. ");
INSERT INTO wrk_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Baki mili jangkurranyi ngayu karungka narrinya. Jaliyi yiningki kujarra, yiningki murrku narringi, jaliyi yalu yanyba mududu nangangi Kudkanyi nanankanyi yajinyi, jaliyi yalu ngajaka Kud nanankanyi yajinyi, baki ngakinyi Buwakayu Kingkarri janyulu yabimba nanda jala yalu ngajaka. ");
INSERT INTO wrk_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Jala yiningki kujarra, yiningki murrku malumba yalu jungku, jaliyi yalu ngakinmuku kandimuku, jaliyi yalu kuyu ngaki jangkurr, baki jangayu ngayu jungku yalundu marda. Ngaki ngarndu janyulu jungku yalundu kandimbiji yalunyaja. Barriwa.” ");
INSERT INTO wrk_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Baki jilajbayi Bida nangandurri Jisusyurri, baki ngajaka nyuli, “Mambuka, jala yingkawanyi kandiwanyi nyulu yabimbaka balki yaji ngaki, baki marda ngayimi manjamanjamba nanda balki yaji nangangi. Ngala jalili nyulu yabimbaka balki yaji ngaki yurrngumba barri, baki yankana marda ngayimi manjamanjamba nangangi balki yaji. Kujarraka baki kujarraka baki kujarraka barndayka kuna. Wanyi ninji yanyba.” ");
INSERT INTO wrk_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Jananganjayi Bida Jisuswanyi, “Miku ngawamba kujarraka baki kujarraka baki kujarraka barndayka, ngala marda ninjimi yurrngumba manjamanjamba nanda balki yaji, jalili nyulu yabimba nganyi. Marda nganyingkimi miku kurrkunba manjamanjambikanyi nangangi balki yaji yurrngumba. ");
INSERT INTO wrk_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Muningka jangayu karu narrinya nanginkanyi jangkurranyi. Nanda walkurra mambuka, kaja nanganginmuku wakiwarrmuku. Kudiya yali jilajba nangandurri mambukarri, wudumbiji dungala nanganbunanyi. Jayalu wiykunumba nanda dungala nangandurri baku. Badajbaja yingkana yakarlina, baki yingkana yakarlina baki yingkana yakarlina, ngala miku yaliyanyi wiykunumba nanda dungala nangandurri mambukarri. ");
INSERT INTO wrk_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Kuyu yali yingka wakiwarr nangandurri mambukarri. Wabula, nanangini wakiwarranyi, nyuli wudumba kaja dungala nanganbunanyi, wirdikudukudu dungala, barrinani 1,000,000 dula, ");
INSERT INTO wrk_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","ngala mikuyaji kajanyi dungalanyi nangandu wiykunumbikanyi mambukarri. Nanankardi barri nanda mambuka nyuli kijiwijba nanankanyi nganiyngkanyi. Jirrinyba nyuli yingka wudumbiji nanda wakiwarr, marda nangangi maninganja, marda jandanyimuku. Janyulu wudumba yalunya, baki wajbaja yingka nganinyi dungalanyi, barrinani waykanyi yingka bulukinyi dungalanyi. Nani barri nanganginyi mambukawanyi janyulu wudumba nanda dungala, jala miku nyuliyi wiykunumba wakiwarranyi. Nani barri nyuli jirrnyba yingka wudumbiji nanda wakiwarr. ");
INSERT INTO wrk_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Jali manku nanda jangkurr wakiwarranyi, baki jilajba nyuli nangandurri mambukarri. Mururu nyuli wayka nangandu, baki ngajaka nyuli, ‘Yukumbakiyi mili nayiba ngaki, baki janinga wajba bukamba nanankanyi dungalanyi. Ngindu ngayu muwa nganyi, mikungangi ningiyanyi wajba wabula nanankanyi dungalanyi. Jaliyi ninji yukumba bijal mili, baki janinga wajba dungalanyi.’ Barriwa. Nani nyuli yanyba nanganginkanyi mambukanyi. ");
INSERT INTO wrk_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Baki nanda mambuka, nyuli ngindu muwa nanankanyi nganiyngkanyi baki yangkalamba nangki kulaji. Yuku barri. Miku nyuliyi wiykunumba nangandurri nanda dungala. Yuku barri, nyulu kiliyi nanda kaja dungala nangandu. ");
INSERT INTO wrk_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Ngala nanda wakiwarr, nyuli barlba mambukananyi, baki wijba nyuli nanganginkurri barndarri. Ngala nyuli jilajba, baki najba nyuli yingka wakiwarr, jali wabula wudumba bijal dungala nanganbunanyi, baki jilijbawa wiykunumbaja nanda dungala. Najba nyuli nanda yingka wakiwarr, baki kijiwijba nyuli nangangi. Marrimba nyuli nanda dujana ngurlkumbayi duka. Kaya nyuli nangangi, ‘Wiykunumbakiyi nanda dungala jali ninga wajba. Barriwa wiykunumbakiyi yinarramba.’ ");
INSERT INTO wrk_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Ngala nanda yingka wakiwarr, nyuli yirrba jambarri, baki kudanyu nyuli yilikajba, ‘Yukumbakiyi bijal mili, baki jangayu wiykunumba bukamba dungala.’ ");
INSERT INTO wrk_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Ngala miku nyuliyanyi ngindu muwa, nanda waluwinyi wakiwarr. Jardibirri nyuli muwa. Karu nyuli yilarrmuku nanankanyi yingkanyi wakiwarrayngka, baki yali wudumba nanda yingka, baki janybayi brisinyurri. Nanaba janyulu jungku yurrngumba nanankurri jalija nyulu wiykunumba bukamba dungala nangandurri. ");
INSERT INTO wrk_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Ngala yingkamuku wakiwarrmuku, yali jingkijba nanda yaji. Yali najba nanda wakiwarr jilaykurri brisinyurri, baki ngindu yali muwa nangangi. Kudanyu yali ngindu muwa nangangi, baki jilajba yali nangandurri mambukarri. Karu yali mambuka nanankanyi wakiwarrayngka, manjijbayi brisinyurri nanangini waluwinyiwanyi wakiwarranyi. ");
INSERT INTO wrk_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Baki kijiwijbayi nanda mambuka nangangi. Manjijba nyuli yingka wudumbiji nanda waluwinyi wakiwarr. Badajba nyuli mambukarri, baki yanybayi mambuka nangangi, ‘Ninji balkimirra. Miku ngayiyanyi yabimba kiji nganyi, ngala ngayi ngindu muwa nganyi. Manjamanjamba ngayi nanda kaja dungala jali ninji wudumba ngakinbunanyi. Manjamanjamba ngayi nanda dungala jali nganinji ngajaka. ");
INSERT INTO wrk_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Ngala wanyingkanyi miku ninjiyanyi ngindu muwa nanankanyi, jali nyulu wudumba bijal dungala nganyinbunanyi. Wanyingkanyi ninji yabimba kiji nangangi.’ ");
INSERT INTO wrk_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Baki nanda mambuka, nyuli ngarrangarra muwa nanankanyi balkinyi wakiwarrayngka. Kudanyu nyuli ngarrangarra muwa nangangi. Manjijba nyuli nanda brisinyurri, baki nanaba nyuli jungku yurrngumba nanankurri jalija nyulu wiykunumba bukamba nanda kaja dungala nangandurri mambukarri.” Barriwa. ");
INSERT INTO wrk_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Baki yanybayi Jisus yalungi, “Ngaki Buwakanya Kingkarri, nyulu lalanbawarr. Ngala jaliyi narri jungku barrinani nanda balki wakiwarr, jaliyi narri miku manjamanjamba yingkanyi nangangi balki yaji, baki miku nyuliyi manjamanjamba narringi balki yaji ngakinyi Buwakayu. Ngala jaliyi narri manjamanjamba yingkanyi nangangi balki yaji, baki janyulu marda manjamanjamba narringi balki yaji. Barriwa.” ");
INSERT INTO wrk_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Jali bukamba yanyba Jisus nani yalungi, baki yali barlba nanamunanyi yajinanyi Kalilinanyi, Jisus marda nanganginmuku kandimuku. Jilajba yali kula yingkayurri yajiyurri, niji Judiya. Birlbidamba yali bundal niji Jurdan, baki jilajba yali kula Judiyayurri. ");
INSERT INTO wrk_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Kajamuku yali jilajba nangandu Jisusnyina, ngala nyuli jilajba. Kunymamba nyuli nanamuku jali yalu lunji. Kunymamba nyuli yalunya jali yalu jilajba nangandurri. ");
INSERT INTO wrk_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Baki jawuda Barasimuku yali jilajba nangandurri. Balanja yali Jisus. Ngajaka yali Jisus Barasimukunyi, “Jaliyi nyulu yingkijba nangangi maninganja nganinyiwanyi, jaliyi muningka nyulu manjijba nanda jibarri nanganbunanyi, miku nyulu mili nangangi maninganja, baki jungkuka kuna nyulu kunybana yuwana. Wanyi ninji yanyba.” Nani barri yali ngajaka Jisus balanjanki. ");
INSERT INTO wrk_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Jananganja yalunyi Jisuswanyi, “Miku kuna narrimi jingkijba nanda jangkurr najana Kudkanyi. Nayi barri yanybaka nanda jangkurr, ‘Juju wabula kamambarra, jala mikuyaji yajinyi, baki yabimbayi bukamba yaji Kudwanyi. Yabimba nyuli nganinyi marda jibarri. ");
INSERT INTO wrk_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Baki yanybayi Kud, “Mardakimi nganinyiwanyi yingijba bulanya nijanganjinyi marda ngardanganja. Marda nyulimi maninganja wudumba, baki jabula malumba jungku yurrngumba. Maykarra bula. Waluku bula kujarra, ngala bayngkani barri bula maykarra, barrinani yingamali.’” ");
INSERT INTO wrk_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Maykarra bula jungkuka malumba barrinani yingamali. Yanybaka Kud, ‘Jala nanankujarra maykarra jungkuka barrinani yingamali, baki mardakimi yingkawanyi miku nyalimba bulanya. Mardakimi miku nyalimba bulanya yingkawanyi.’ Nani barri yanybayi Kud, baki nanankardi marda nyulimi miku manjijba nangangi maninganja nganinyiwanyi.” Barriwa. Nani barri jananganjayi yalunya Jisuswanyi. ");
INSERT INTO wrk_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Ngala mili barri yali ngajaka Jisus, “Ngala wanyingkanyi Musiswanyi wajbayi ngambalanya yinini yuwanyi maykarrayngka. Nanda nangangi yuwa yanybaka, ‘Yuku nyulu wajba nangangi maninganja najanyi nganinyiwanyi. Yuku nyulu wajba najanyi jala yanybaka, miku nanda jibarri mili nangangi maninganja. Yuku nyulu wajba jibarri nanankanyi najanyi, baki muningka manjijba nanda jibarri nanganbunanyi.’ Wanyingkanyi wajbayi ngambalanya nanankanyi yinini yuwanyi Musiswanyi.” ");
INSERT INTO wrk_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Jananganjayi yalunya Jisuswanyi, “Nani barri yanybayi Musis, jingkijbangangi nyuli narrinya, narri jardibirri kurdulu nangangi Kudkanyi. Miku narriyi kuyu nangangi jangkurr, jala nyulu milidimba narrinya Kudwanyi. Ngala jalannga barri jali yabimba nganinyi baki jibarri Kudwanyi, baki miku nyuliyanyi yanyba nani barri, manjiykanyi maninganja nanganbunanyi najayudi. Miku nyuliyanyi yanyba nani jalannga barri. ");
INSERT INTO wrk_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Ngayu karungka narrinya, jaliyi muningka nyulu manjijba nangangi maninganja nanganbunanyi nganinyiwanyi, jaliyi muningka manjijba nanganbunanyi, ngala miku nyuliyanyi kuluka yingkana nganinyina nanda jibarri, baki nanda balki. Nyulu jungkuka balkina yuwana Kudkanyi nanda nganinyi. Baki jaliyi nyulu kuyu yingka jibarri nanganginkanyi maninganjanyi, baki nanda balki. Nyulu jungkuka balkina yuwana Kudkanyi, yuwajiwangangi nanda waluwinyi jibarri nangangi maninganja. Nani ngayu karungka narrinya manjiykanyi nanda nganyi maninganja. Barriwa.” ");
INSERT INTO wrk_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Kamu barri yanybayi kandimuku Jisuskanyi nangangi, “Nanda yuwa jala ninji yanybayi bulangi maykarrayngka, nanda jardibirri yuwa ngambala durriykanyi. Jaliyi nyulu balki jibarri ngala miku nyuliyanyi kuluka yingkana nganinyina, baki miku nyuliyi manjijba nanganbunanyi nawinganjawanyi. Marda ngambalimi miku jamalu jibarri. Marda ngambalimi jungku nyubana.” ");
INSERT INTO wrk_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Jananganjayi yalunya Jisuswanyi, “Nanda jangkurr maykarrayngka, yi, nanda jardibirri jangkurr durriykanyi, ngala miku ngayiyanyi yanyba nanda jangkurr bukambijuyngka yalungi. Ngala kudiyawanyi jayalu durrijba nanda jangkurr, jayalu mirnarrijba muwa nanankanyi jangkurranyi, miku muningka manjiykanyi nanda maninganja nangangi. Ngayi yanyba nanda jangkurr yalungi, jalija durrijba nanda jangkurr ngaki. ");
INSERT INTO wrk_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Ngala jawudamukunyi, miku yaliyi jamalu nanda jibarri. Yingkamukunyi, miku yaliyi jamalu nanda jibarri, mikungangi yaliyi yabimba jibarri ngawukuku. Nanankardi barri miku yaliyala jamalu nanda jibarri. Ngala yingkamuku barri, miku yalimi nulijba jibarrinyi, jungkungangi yalu barrinani buluki, jali yalunya karlba nganinyiwanyi. Nanankardi barri miku yaliyala jamalu nanda jibarri. Ngala yingkamukunyi barri, miku jayalu jamalu nanda jibarri, nulijbangangi yalu wakinkanyi nangangi Kudkanyi yurrngumba barri. Mankumanku yalungka, ‘Jaliyi ngayu jamalu nanda jibarri, baki baku barri janungkala jungku jirdi kajanyi bayamukuyngka. Jaliyi ngayuman jungku, baki yuku ngayu jilalajba yingkarri yajiyurri baki yingkarri yajiyurri karunki yalunya nangangi Kudkanyi. Ngala jaliyi ngayu jungku jirdi maninganjanyi baki bayamukuyngka, baki marda ngayimi wambu jungku lalanbijina yalunya bayamuku baki maninganja.” Nanankardi barri miku yaliyala jamalu nanda jibarri, ngala yali waki nangangi Kudkanyi. Yi, jardibirri nayinda jangkurr, ngala kudiyawanyi jayalu durrijba nayinda jangkurr, jayalu jungku nani barri.” Barriwa. ");
INSERT INTO wrk_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Baku barri, kudiyawanyi yali kuyu bayamuku nangandurri Jisusyurri. Kaja bayamuku yali kuyu nangandurri. Nulijba yali nangangi, nangka yarriykanyi marni yalundu, nyulu yanybikanyi mududu nangangi Kudkanyi yalungi. Baki janyulu lalanba yalunya Kudwanyi, janyulu yabimba kunyba yaji yalungi. Ngala nanganginmuku kandimuku Jisuskanyi, yali ngirrwa yalungi. Kudanyu yali ngirrwa yalungi, jali kuyu bayamuku nangandurri. ");
INSERT INTO wrk_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Ngala yanybayi Jisus yalungi nanganginmukuyngka kandimukuyngka, “Janarri munyajba bayamuku jilaykanyi ngakindurri. Marda narrimi miku kurrkunba yalunya. Nanginmukunyi bayamukunyi, ngana yalu jingkijbangka, miku ngayimi jujambawarr. Yalu kuyungka ngaki jangkurr, baki nanankardi nyulu lalanbaka yalunya Kudwanyi. Jaliyi nganinyiwanyi jingkijba ngana barrinani nanginmukunyi bayamukunyi ngana yalu jingkijbangka, baki janyulu marda lalanba nanda Kudwanyi, barrinani nyulu lalanbaka nanginmuku bayamuku. Nanankardi barri janarri munyajba bayamuku jilaykanyi ngakindurri.” Barriwa. ");
INSERT INTO wrk_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Baki yarrijba nangki Jisus marni yalundu bayamukunyina. Yanyba nyuli mududu nangangi Kudkanyi yalungi. Ngajaka nyuli Kud, nyulu lalanbiji yalunya. Nani nyuli yabimba yalungi, baki barriwa nyuli barlba. Mili nyuli jilajba kula barri. ");
INSERT INTO wrk_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Baku barri badajbayi nganinyi nangandurri Jisusyurri, baki yanyba nyuli nangangi, “Milidimbawarr. Wanyi kunyba yaji jangayu yabimba, baki janyulu wankamba ngana Kudwanyi, ngayu jungunkanyi mili wanka nangandu yurrngumba barri. Wanyi kunyba yaji jangayu yabimba.” ");
INSERT INTO wrk_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Jananganjayi nanda nganinyi Jisuswanyi, “Wanyingkanyi nganinji ngajaka kunybanyi yajinyi. Ngawamba Kud, nyulu kunyba. Yingkamuku miku yalimi kunyba. Jaliyi ninji nulijba jungunkanyi wanka yurrngumba barri, baki marda ninjimi durrijba nanda yuwa nangangi Kudkanyi yurrngumba barri.” ");
INSERT INTO wrk_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Mili barri ngajakayi Jisus nganinyiwanyi, “Wanyi barri nanda yuwa nangangi Kudkanyi jala marda ngayimi durrijba yurrngumba barri. Wanyi barri yuwa.” Baki jananganjayi Jisuswanyi, “Ninji jingkijbangka nanda yuwa nangangi Kudkanyi, jali nyulu jirrinyba narrinya bukambiju. Nayinda nanda yuwa nangangi Kudkanyi. Mikujiyi kurdanba nganinyi. Mikujiyi kuluka yingkana jibarrina jala miku nganyi maninganja. Mikujiyi maninjakujba yaji. Mikujiyi jujamba yaji yalungi yingkamukuyngka. ");
INSERT INTO wrk_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Marda ninjimi maruka muwa yalungi yingkamukuyngka barrinani nganyingka maruka muwa. Kuyukiyi bulangi jangkurr, nganyingkanyi nijanganjiykanyi baki yarrijiyngkanyi. Nani barri nanda yuwa jala marda ninjimi durrijba.” ");
INSERT INTO wrk_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Yanybayi nganinyi Jisuskanyi, “Ngayangayijba ngayu nanankanyi yuwanyi yurrngumba barri. Yurrngumba ngayu ngayangayijba bukamba nanankanyi yuwanyi. Wanyi yingka yaji marda ngayimi yabimba, ngayu jungunkanyi wanka nangandu Kudnyina.” ");
INSERT INTO wrk_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Baki jananganjayi Jisuswanyi, “Jaliyi ninji nulijba jungunkanyi kunyba nangangi Kudkanyi yurrngumba barri, jaliyi ninji nulijba jungunkanyi nani barri, baki marda ninjimi yabimba nayi barri. Barlbakiyi, baki wajbakiyi yingkamuku bukamba nganyingkanyi yajinyi dungalanyi. Janinji wudumba kaja dungala nganyingkanyi yajinyi. Wajbakiyi yalunya nanankanyi dungalanyi, nanamuku jala yalu jungku mikuyaji dungalanyi. Wajbakiyi yalunya nanankanyi kajanyi dungalanyi. Baki barriwa, baki wijbakiyi ngakindurri. Jilalajbakiyi ngakindu yurrngumba barri. Baki yuku barri janyulu mirnarrijba Kud muwa nganyi, janyulu mili wankamba ninya.” Barriwa. ");
INSERT INTO wrk_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Jali nyulu manku nanda jangkurr nangangi Jisuskanyi nganinyiwanyi, baki barlba nyuli. Baki ngindu nyuli muwa nanankanyi jangkurranyi. Ngindu nyuli muwa, jungkungangi nyuli kajayudi yajiyudi marda dungalayudi. Barlba nyuli nanganbunanyi Jisusnanyi, ngala miku nyuliyala yabimba nanda jali karu Jisuswanyi. ");
INSERT INTO wrk_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Baki yanybayi Jisus nanganginkanyi kandimukuyngka, “Warriyaluku barri, jala nyulu kajayudi yajiyudi baki dungalayudi. Jardibirri nyulu jungunkanyi kandi nangangi Kudkanyi, nyulu lalanbikanyi Kudwanyi. Jardibirri nyulu jungunkanyi kandi nangangi Kudkanyi jala nyulu kajayudi yajiyudi. ");
INSERT INTO wrk_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Mili ngayu karungka narrinya. Jala nganinyi jirdi kajanyi yajinyi, jala nyulu nulijba jungunkanyi kandi nangangi Kudkanyi, baki nanda jardibirri. Jalimi nanda kamil ngankijba kalawunyi yamina nidilina, baki nanda jardibirri. Mikuwali ngankijba. Ngala jala nganinyi jirdi kajanyi yajinyi, jala nyulu kuyu jangkurr nangangi Kudkanyi, jala nyulu kandi nangangi Kudkanyi, baki nanda jardibirri nyulu kudanyu barri.” Barriwa. ");
INSERT INTO wrk_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","26","Baki nyuli ningkijba yalunya Jisuswanyi, baki jananganjayi, “Miku yalungkimi wankamba. Miku. Ngawamba Kudwanyi, yuku nyulu wankambaja yalunya mili. Yuku barri nyulu. Ngawamba Kudwanyi, yuku nyulu marrimbaka yalunya mardarda. Yuku nyulu yabimbaka bukamba yaji Kudwanyi.” Jali yalu manku nanda jangkurr nangangi Jisuskanyi, baki manmala yali kandimuku. Manmala yali kudanyu barri, baki ngajaka yali Jisus, “Jaliyi jardibirri jungunkanyi kandi nangangi Kudkanyi, baki wanyimuku janyulu marrimba yalunya mardarda Kudwanyi. Wanyimuku jayalu wankijba mili nangandu kingkarri.” ");
INSERT INTO wrk_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Yanybayi kandi Bida nangangi, “Ngala nurru barri, yingijba nurri bukamba nurrungi yaji nganyi, baki jilajba nurri nganyindu. Baki nanankardi barri wanyingkanyi yajinyi janurrunya wajba Kudwanyi. Wanyingkanyi yajinyi barri.” ");
INSERT INTO wrk_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","30","Jananganjayi Jisuswanyi, “Karungka ngayu duja jangkurranyi. Nanda jala ngaki kandi, nyuli yingijba bukamba nangangi yaji ngaki. Yingijba nyuli nangangi barnda. Marda yingijba nyuli yalunya, buwanganjamuku, marda majunganjamuku, marda bababanyamba nyulu yalunya. Yingijba nyuli nangangi ngardanganja marda nijanganjinyi. Yingijba nyuli yalunya nanganginmuku jandanyimuku marda, baki kardikardimba nyulu yalunya, baki yingijba nyuli nangangi jamba. Bukamba nanganginmuku nyuli yingijba yalunya ngaki. Ngala jangayu wajba nanda yingkanyi yajinyi. Kajanyi yajinyi jangayu wajba nanda, mili baki mili. Baki janyulu jungku mili wanka yurrngumba. Janyulu jungku mili wanka kingkarri nangandu Kudnyina. Kajamuku jala ngamu yalu walkurra, janyulu baku bayakardamba yalunya Kudwanyi. Janyulu bayakardamba yalunya, jala ngamu yalu walkurra. Ngala yingkamuku jala yalungka mankumanku, yalu bayakarda, janyulu walkurramba yalunya Kudwanyi. Janyulu walkurramba yalunya barri. Ngala narri barri, baku barri janarri jungku kingkarri nangandu Kudnyina. Baku barri, jalija nyulu yabimba bukamba yaji buyingkinyi Kudwanyi, baki ngayu Buwanya Bukambijuyngka, jangayu jungku mambuka bayngkani nangandu Kudnyina. Baki narri marda, ngakinmuku 12 kandimuku, janarri jungku kingkarri ngalindu. Janarri jungku mambukamuku bayngkani ngalindu. Janarri jungku mambukamuku bukambijuyngka yalungi jalija nyulu mili wankamba yalunya Kudwanyi. Janarri mambukamuku yalungi narringinmukuyngka mungkijimukuyngka.” Barriwa. Nani yanybayi Jisus yalungi. ");
INSERT INTO wrk_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Baki mili barri milidimbayi yalunya Jisuswanyi, “Jangayu mili karu narrinya nangangi Kudkanyi, nyulu lalanbawarr yalungi jala durrijba nangangi jangkurr. Muningka barri jangayu karu narrinya mambukanyi. Walajbayi nanda mambuka ngala nyulu kambalingijba yaji, baki jilajba nyuli yingkarri barndarri wudumbiji jawuda, yalu wakinkanyi nangangi. Wudumba nyulu yalunya, yalu wakinkanyi nanganginyina jambana, jala jardiykunumba nyulu krayib wanjirr. ");
INSERT INTO wrk_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Karu nyuli yalunya, janyulu wajba yalunya dungalanyi. Janyulu wajba yalunya barrinani 20 dulanyi, jaliyi yalu waki nangangi wujuju barri. Baki nyuli manjijba yalunya wakinkanyi nanganginyina jambana. ");
INSERT INTO wrk_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Kamu barri ngala nyulu yuwajiwa yalibala, jilajbayi nanda mambuka yingkarri barndarri, baki najba nyuli nganinyimuku jungunkurri nanaba. ");
INSERT INTO wrk_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Baki nyuli yanyba nanamannga jangkurr yalungi, janyulu wajba yalunya dungalanyi jaliyi yalu waki nanganginyina jambana. ");
INSERT INTO wrk_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Baki yali marda jilajba, baki wakiyi nangangi. Kamu barri mukunjana, jilajbayi nanda mambuka yingkarri barndarri, baki wudumba nyuli mili nganinyimuku. Karu nyuli yalunya nanamannga jangkurranyi, baki yalu marda jilajbayi, baki wakiyi nangangi. Baki kamu barri ngabungabu bijal, mili nyuli wudumba yalunya, yalu wakinkanyi nangangi dungalanyi. ");
INSERT INTO wrk_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Baki kamu barri ngabungabu, mili nyuli jilajba yingkarri barndarri baki najba nyuli nganinyimuku muningka jungunkurri nanaba. Ngajaka nyuli yalunya, ‘Wanyingkanyi narri muningka jungku wujuju, miku wakinkanyi. Wanyingkanyi barri. Jaliyi narri waki, baki janarri wudumba dungala mamanyi. Wanyingkanyi narri miku wakingka.’ ");
INSERT INTO wrk_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Jananganja yali nanda mambuka, ‘Nurrimi waki, ngala mikuyaji wudumbikanyi nurrunya, wakinkanyi nangangi.’ Baki yanybayi nanda mambuka yalungi, ‘Yuku janarri waki ngaki. Jilajba janarri ngakindurri jambarri jali jardijba krayib wanjirr. Nanaba janarri waki ngaki dungalanyi.’ Nani nyuli yanyba yalungi, baki barlba yali, waki yali nangangi. ");
INSERT INTO wrk_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Kamu barri ngabungaburri ngala nyulu karrala kamba wayka bayungu, baki yanybayi nanda mambuka nanganginkanyi walkurrayngka wakiwarrayngka jali waki nangangi yurrngumba barri. Karu nyuli nanda walkurra wakiwarr. ‘Wudumbakiyi yalunya jali yalu waki jala ngakinyina jambana, baki wajbakiyi yalunya dungalanyi. Waluku barri janinji wajba yalunya dungalanyi jali yalu waki ngawamba bijal ngaki ngabungabunanyi. Baki bayngkani janinji wajba yalunya dungalanyi jali yalu waki ngaki bijal mili, bijalnanyi ngabungabunanyi, baki bayngkani yalunya jali yalu waki ngaki mukunjanananyi, baki bayngkani yalunya jali yalu waki ngaki yalibalananyi. Baki bayngkani janinji wajba yalunya jali yalu waki ngaki wujuju yurrngumba kambalingiykanyi yaji. Nani barri janinji wajba yalunya dungalanyi.’ Barriwa. ");
INSERT INTO wrk_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Baki kaya nyuli yalungi, baki wajbayi yalunya dungalanyi. Nanamuku jali yalu waki ngawamba bijal, wajba nyuli yalunya dungalanyi barrinani 20 dulanyi. Nani nyuli wajba yalunya bukambiju wakiwarr nanamannga dungalanyi barrinani 20 dulanyi, nanamuku jali waki bijal nangangi mambukanyi, baki nanamuku jali yalu waki kudanyu nangangi. Nanamannga dungalanyi nyuli wajba yalunya. ");
INSERT INTO wrk_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Ngala nanamuku lirrkamuku jali yalu waki nangangi yurrngumba wujuju, ngamu jayalu wudumba mili dungala yalungi jala waki ngawamba bijal, ngala miku. Nyuli wajba yalunya nanamannga dungalanyi barrinani 20 dulanyi. Nanamannga dungalanyi nyuli wajba yalunya bukambiju. ");
INSERT INTO wrk_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Ngala nanamukunyi lirrkamukunyi, yali kuyu yalungi dungala, ngala balkijba yali muwa nanankanyi dungalanyi. Baki jakakajba yali nanankanyi mambukanyi, wirangu dungala. Nulijba yali mili dungalanyi. ");
INSERT INTO wrk_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","Yanyba yali nangangi mambukanyi, ‘Nanamuku jadunyimuku wakiwarrmuku, waki yali ngawamba bijal nganyi, ngala nurru barri, waki nurri kudanyu nganyi wujuju barri, ngala nyulu ngarrangarra yaji kudanyu barri. Ngala wajba ninji yalunya nanamannga dungalanyi barrinani ninji wajba nurrunya. Miku ninjiyanyi wajba nurrunya mili dungalanyi yalungi.’ ");
INSERT INTO wrk_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Ngala jananganjayi yalunya mambukawanyi, ‘Manku narri ngaki jangkurr. Miku ngayiyanyi jujamba narrinya. Miku. Wajba ngayi narrinya nanankanyi dungalanyi, 20 dulanyi jali narrinya karu, jangayu wajba. Ngayangku narri wakinkanyi 20 dulanyi, baki narrinya wajbayi 20 dulanyi. Miku ngayiyanyi jujamba narrinya. Miku. ");
INSERT INTO wrk_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Ngala kuyu janarri nayinda dungala, baki wijba janarri narringinkurri barndarri. Marda narrimi mirnarrijba muwa nanankanyi dungalanyi. Nulijbangka ngayu yabimbikanyi kunyba yaji bukambijuyngka yalungi jala yalu waki ngaki. Nulijbangka ngayu waykanyi narrinya bukambiju nanamannga dungalanyi. ");
INSERT INTO wrk_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Nayinda ngaki dungala, baki yuku jangayu ngayu wajba yalunya nanginkanyi dungalanyi, yingka baki yingka baki yingka. Yiningki narri ngurunguru yalunya, wajbangangi ngayi yalunya nanamannga dungalanyi. Yiningki narri kuliwijba dungalanyi.’ Barriwa. Nani barri jananganjayi mambukawanyi. ");
INSERT INTO wrk_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Ngayu karungka narrinya. Nanamuku jali yalu waki ngawamba bijal nangangi mambukanyi, yalu barrinani nanamuku jala yalu kuyu ngaki jangkurr, ngala marndakaja jayalungka janyba. Ngawamba bijal mili yalu wanka jungku nayiba jambana, ngawamba bijal jayalu waki ngaki. Ngala janyulu yabimba kunyba yaji yalungi Kudwanyi, janyulu mili wankamba yalunya, yalu jungunkanyi nangandu kingkarri. Ngala nanamuku jali yalu waki kudanyu nangangi wujuju barri, yalu barrinani nanamuku jala yalu kuyu ngaki jangkurr, ngala yuwajiwa jayalu jungku wanka nayiba jambana yurrngumba barri. Kudanyu jayalu waki ngaki yurrngumba barri. Baki janyulu yabimba nanamannga kunyba yaji yalungi Kudwanyi, janyulu mili wankamba yalunya marda, yalu jungunkanyi nangandu kingkarri. Janyulu yabimba nanamannga kunyba yaji bukambijuyngka yalungi jala yalu kuyu ngaki jangkurr. Barriwa.” ");
INSERT INTO wrk_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Baku barri jilajba yali kula Jirusalimyurri, Jisus marda nanganginmuku kandimuku. Yingkamuku yali jilajba kula nangandu. Baki nyuli yanyba yalungi nanganginmukuyngka kandimukunyi. Kardarda nyuli yanyba yalungi. Mikuyaji yingkanyi mankunkanyi nangangi jangkurr, ngawamba kandimukuyngka. Nayi nyuli yanyba yalungi ngala yali jilajba, ");
INSERT INTO wrk_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“Narri. Ngambala jilajbangka kularriji. Ngambala jilajbangka nanankurri Jirusalimyurri. Janganjalu wudumba, Buwanya Bukambijuyngka. Janganjalu wudumba walkurrawanyi mambukawanyi jurjkanyi, marda milidimbawarrmukunyi yuwanyi. Jayalu yanyba ngaki, marda ngakimi janyba. ");
INSERT INTO wrk_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Baki ngaki jayalunjalu wajba ngurranyimuku. Janganjalu bajalingijba nanamukunyi ngurranyimukunyi. Jayalu yanyba balki jangkurr ngaki. Jayalu kakalijba ngaki. Janganjalu wajuba kurulyudinyi. Janganjalu langandaba wabangkarra kurndana. Nani barri janganjalu kurdanba barri. Ngala baku barri, kujarraka barndayka jangayu mili wankijba. Nanamanji barri jangayu mili wankijba.” Nani barri yanybayi Jisus yalungi nanganginmukuyngka kandimukuyngka. ");
INSERT INTO wrk_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Ngala yali jilajba kula yubalina, baki jilajbayi jibarri bundu nangandu Jisusyurri. Nyuli maninganja nangangi Sibidikanyi, baki nyuli ngardanganja bulangi buwakulayngka, niji bulangi Jayims marda Jun. Jilajba nyuli bundu nangandurri, baki nanganginwuya kulunganjawuya jilajba buli bayngkani nangandu. Mururu nyuli wayka walu nangandu, baki ngajaka nyuli Jisus, nyulu yabimbiji kunyba yaji nangangi. ");
INSERT INTO wrk_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Ngajakayi jibarri Jisuswanyi, “Wanyimba jangayu nganyi. Wanyimba.” Jananganja nyuli jibarriwanyi, “Mambuka, janinji kuna yabimba kunyba yaji nurrungi. Ninga ngajakangka, janinji kuyu bulanya ngakinkuya jandanyiwuya kingkarri nganyindu. Janinji kuyu bulanya kingkarri nganyindu, bula jungunkanyi nganyindu, jungunkanyi yingka jinyanyina nganyindu, yingka wakunyina nganyindu barrinani mambukawuya bayngkani nganyindu. Nani barri kuna jabula jungku nganyindu, jalija ninji jungku walkurra mambuka kingkarri yajina Kudkanyi.” ");
INSERT INTO wrk_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Jananganjayi yalunya Jisuswanyi, “Miku narrimi jingkijba nanda jangkurr jala nganarri ngajaka. Janganjalu linjumba. Janganjalu kurdanba. Nani kuna jayalu linjumba nimbalanya, jayalu kudanyu linjumba nimbalanya marda. Nulijba kuna nimbala nanankanyi linjumbikanyi nimbalanya, barrinani jayalu yabimba ngaki yaji. Nani kuna nimbala nulijba.” Jananganja buli buwakulawanyi, “Yuku barri ngali. Yuku jayalu ngalinya linjumba nani barri.” Barriwa. ");
INSERT INTO wrk_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Baki mili yanybayi Jisus bulangi, “Jayalu linjumba nimbalanya, jayalu kudanyu linjumba nimbalanya, barrinani janganjalu linjumba. Ngala wanyimuku jayalu jungku walkurra ngakindu. Miku ngayiyi yarrijba yalunya jalija yalu jungku walkurra ngakindu. Ngala ngakinyi Buwakayu janyulu nyulu yarrijba yalunya yingka jinyanyina, baki yingka wakunyina ngakindu. Birrirrinja nyuli nanamukuyngka jalija yalu jungku mambuka bayngkani ngakindu. Yiningki nimbala, yiningki yingkamuku.” Barriwa. ");
INSERT INTO wrk_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Ngala manku yali yaji yingkamukunyi kandimukunyi. Manku yali bulanya ngajakankurri Jisus nanankanyi yajinyi, baki yali ngarrangarra muwa bulangi. Baki ngirrwa yali bulangi. ");
INSERT INTO wrk_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Baki nyuli karu yalunya Jisuswanyi, yaluja jilajba nangandurri, baki nyuli yanyba yalungi, “Narri barri, jingkijba narri yalunya walkurramuku mambukamuku ngurranyimuku. Yalu yanybaka nyilala jangkurr yalungi. Yalu ngirrwawarrmuku. ");
INSERT INTO wrk_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Ngala narri barri, marda narrimi miku jungku walkurra mambuka barrinani yalu ngurranyimuku jungkuka walkurra mambuka. Miku. Jaliyi yingamali narringi, jaliyi nyulu nulijba jungunkanyi walkurra mambuka, baki marda nangkimi bayakardamba. Marda nyulimi lalanba yalunya yingkamuku. Marda nyulimi waki yalungi yingkamukuyngka. ");
INSERT INTO wrk_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Jaliyi nyulu nulijba jungunkanyi mili walkurra yalungi, baki marda nyulimi jungku barrinani wakiwarr yalungi, marda nyulimi waki kudanyu yalungi yurrngumba barri. ");
INSERT INTO wrk_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Marda nyulimi jungku barrinani ngayu. Ngayu Buwanya Bukambijuyngka yalungi, ngala badajba ngayi lalanbiji yalunya, miku yaluwali lalanbiji ngana. Jayalu mili wankijba nangandu Kudnyina, janybangangi jangaka yalungi. Barriwa.” ");
INSERT INTO wrk_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Mili yali jilajba kula, baki wanbiya yali barrawuyabarrawuyana niji Jiriku. Baki mili yali barlba nanamunanyi bayungu, Jisus marda nanganginmuku kandimuku. Walajbayi walkurra muramuku, baki jilajba yali nangandu Jisusnyina. ");
INSERT INTO wrk_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Jungkuyi wilina yubalina kujarra nganinyiwuya kabujiwuya. Jali jilajba Jisus bundu bulandu, baki kaya buli nangangi nanankujarra kabujiwuya. Kudanyu buli kaya nangangi, “Ninji barri. Ninji Jandanyi nangangi wankalanyi Dayibidkanyi, ngindukiyi muwa ngalingi, kabujiwuyayngka. Ngindukiyi muwa ngalingi.” Nani buli kaya kudanyu barri nangangi. ");
INSERT INTO wrk_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Kajamuku yali ngirrwa bulangi kurrkunbiji bulanya kayankurri. Yanyba yali, “Kardakiyi jungku, Karda. Mikujiyi kaya.” Ngala mili barri kayayi kabujiwuya nangangi Jisuskanyi, “Ninji barri Jandanyi nangangi Dayibidkanyi. Ngindukiyi muwa ngalingi.” ");
INSERT INTO wrk_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Jilajbayi Jisus, baki karrinjayi. Baki nyuli kaya bulangi. Walajba buli, baki jilajba buli nangandurri. Jali bula wanbiya nangandu, baki ngajaka nyuli bulanya, “Wanyimba jangayu nimbalangi. Wanyimba.” ");
INSERT INTO wrk_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Jananganja buli Jisus, “Mambuka. Nulijba ngali nganyi, ninji waykanyi ngalinya kunybanyi yaminyi. Nulijba ngali nganyi, ninji kunymambikanyi ngalingi yami, baki jangali mili najba yaji.” ");
INSERT INTO wrk_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Baki nginduyi Jisus muwa bulangi. Manjijba nangki Jisus marni bulandurri. Marrimba nyuli bulanya yami, ngindungangi nyuli muwa bulangi. Marrimba nyuli bulangi yami, baki yinarramba yuku buli najba yaji. Yuku buli najba yaji, baki jilajba buli nangandu Jisusnyina. Baki mili yali jilajba bayungu Jirikunanyi. ");
INSERT INTO wrk_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Jilajba yali bayungu Jisus baki nanganginmuku kandimuku. Bunundujba yali Jirusalimyurri. Nanda barrawuyabarrawuya Jirusalim, nanda yaji bayinga, ngala nanda bayakarda barrawuyabarrawuya niji Bidbaj, nanda yaji kulaya, ngala langkiya barri nanda kulawira niji Yulib. Wanbiya yali barrawuyabarrawuyana Bidbaj, baki manjijbayi Jisuswanyi kujarra kandiwuya waluwa yalundu. ");
INSERT INTO wrk_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","Jirrinyba nyuli bulanya, “Janimbala ngankijba nayinda barrawuyabarrawuya, baki nanaba janimbala wakaramba yirrikirri kijijinyi, marda nangangi bulungu, walkurra bijal nangandu. Janimbala dulaba kurul, baki kuyu nimbalaja bulanya ngakindurri. ");
INSERT INTO wrk_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Jaliyi yingkawanyi ngajaka nimbalanya, wanyimba nimbalaja nanda yirrikirri, baki janimbala jananganja, ‘Nyulu nulijbangka yirrikirrinyi nanda mambuka barri.’ Nani barri janimbala jananganja, baki yuku barri janyulu munyajba nimbalanya kuyunkanyi bulanya ngakindurri.” ");
INSERT INTO wrk_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","5","Nani barri yanybayi Jisus bulangi kandiwuyayngka. Wankalana barri yanybayi nganinyi jangkurr Kudkanyi. Nayi nyuli yanyba, “Ngayu karungka narrinya jala jungku Jirusalim. Badajbangka nanginkurri narrindurri narringi mambuka walkurramirra. Ngala miku nyulimi ngabangabala yarramana barrinani yalu yingkamuku mambukamuku ngabangabala yarramana. Miku nangkiyi walkurramba. Ngala bayakardambaka nangka, baki ngabangabala nyulu yirrikirrina, jala bulungu, walkurra bijal.” Duja nanda jangkurr jali yanyba wankalanyi. Yabimbayi yaji nani Jisuswanyi. Barriwa. ");
INSERT INTO wrk_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Baki barlba buli kandiwuya, baki yabimba buli nanda jali karu bulanya Jisuswanyi. ");
INSERT INTO wrk_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Wudumba buli yirrikirri baki nangangi bulungu, baki kuyuyi nangandurri Jisusyurri. Dulaba buli bulangi danyan baki yarrijbayi nanda jumbala bulunguna ngulurrina. Baki jungkuyi Jisus yundu ngulurrina. ");
INSERT INTO wrk_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Kajamuku yali nangandu Jisusnyina, walkurra muramuku. Yingkamukunyi yali dulaba yalungi danyan, baki yarrijba yali yubalina, nanda yirrikirri jilaykanyi nyulu jumbalana. Ngala yingkamukunyi yali dalyamba wanjirr kurndananyi, baki yarrijba yali wanjirr yubalina. Nani barri yalili yabimba yaji, jalili badajba walkurra mambuka yidambiji yalunya. ");
INSERT INTO wrk_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Baki yingkamuku yali jilajba walu nangandu Jisusnyina, ngala yingkamuku yali jilajba bayngkani nangandu. Bukambiju yali kaya kunyba jangkurr nangangi Kudkanyi. Kudanyu yali kaya nangangi, “Nayinda nyulu barrinani jandanyi nangangi Dayibidkanyi. Nurru wajbangka Kud kunybanyi jangkurranyi nurrunginkanyi, nangangingangi Jisuskanyi. Ninya nurru ngajakangka, janinji yabimba kunyba yaji nangangi Jisuskanyi. Nyulu walkurramirra mambuka nurrungi Jumukuyngka. Mirnarrijba nurru muwa nangangi barri.” Nani barri yali kaya, ngala yali jilajba yubalina nangandu. ");
INSERT INTO wrk_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Jali ngankijba Jisus Jirusalim karrina, baki bukambiju jali yalu jungku nananyina yajina, walajba yali barndananyi. Najba yalunjali badaykurri baki kayankurri, ngala miku yaliyanyi jingkijba yaji. Yali yililikajba muramuku nangangi, “Nayinda nganinyi, wanyi nyulu, wanyi nyulu.” Nani barri yali yililikajba kudanyu yajinyi. ");
INSERT INTO wrk_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Baki jananganja yali, “Nayinda nganinyi, nyulu yanybawarr jangkurranyi Kudkanyi. Nangangi yaji langkurri niji Nasarid, nanayina walkurranyina yajina niji Kalili. Nyulu yanybaka jangkurr nangangi Kudkanyi.” Barriwa. ");
INSERT INTO wrk_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Baki ngankijbayi Jisus walkurranyina jurjina nanaba. Ngankijba nyuli, baki najba nyuli yalunya nanaba. Yalunjali wawajba yajinyi dungalanyi, baki wududumba yali bayngkani dungala yajinyi. Najbayi yalunya Jisuswanyi, baki ngarrangarrayi muwa. Baki jakajba nyuli yalunya bukambiju nanamunanyi jurjnanyi. Janyba nyuli yalungi darladarlamuku dungalayudi. Kudiya yali jungku darladarlana, jali yalunjalu wajba kulukukunyi dungalana. Baki janyba nyuli yalungi darladarla marda. ");
INSERT INTO wrk_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Baki ngirrwa nyuli yalungi, “Nanda naja nangangi Kudkanyi yanybaka, ‘Kajamuku jayalu badajba ngakinkurri walkurrayngkurri jurjyurri. Jayalu yanyba mududu ngaki nanaba.’ Nani barri yanybaka jangkurr najana Kudkanyi, ngala narri barri, narri maninjakumuku. Narri maninjakujbangka yaji nanginyina nanganginyina jurjina.” Nani barri nyuli ngirrwa yalungi kudanyu barri. Barriwa. ");
INSERT INTO wrk_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Jungkuyi Jisus jurjina, baki jawuda jirdi kabujinyi yaminyi, marda jirdi balkinyi nukaminyi, yali jila nangandurri. Jilajba yali nangandurri, baki nyuli kunymamba yalunya. ");
INSERT INTO wrk_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Ngala mambukamuku jurjkanyi, baki nanamuku jali yalu milidimba yuwanyi Musiskanyi, yali nanaba marda jurjina. Najba yali Jisus yabimbikurri ngiruka yaji. Baki manku yali bayamuku nanaba kayankurri, “Nayinda, nyulu mungkiji nangangi nanankanyi wankalanyi Dayibidkanyi. Nurru wajbangka Kud kunybanyi jangkurranyi nurrunginkanyi nangangingangi.” Nani barri yali manku bayamuku kayankurri, baki nanankardi ngarrangarra yali muwa nangangi Jisuskanyi. ");
INSERT INTO wrk_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Baki ngajaka yali Jisus, “Manku kuna ninji nanda jangkurr, jala yalu kayangka bayamuku. Miku yalungi jangkurr kunyba.” Jananganjayi yalunya Jisuswanyi, “Yi. Manku ngayu yalungi jangkurr. Nanda kunyba jangkurr yalungi barri. Miku kuna narriyanyi najba nanda jangkurr najana Kudkanyi. Miku kuna narriyanyi najba nanda jangkurr jala yanybaka, ‘Milidimbayi ninji bayamuku, yalu waykanyi ninya kunybanyi jangkurranyi yalunginkanyi.’ Miku kuna narriyanyi najba nanda jangkurr.” Nani barri jananganjayi yalunya Jisuswanyi. ");
INSERT INTO wrk_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Baki barlbayi yalundunanyi Jisus. Barlba nyuli nanamunanyi barrawuyabarrawuyananyi Jirusalimnanyi. Jilajba nyuli karri bayakardarri barrawuyabarrawuyarri niji Bidani, baki nanaba nyuli kuluka mungana. ");
INSERT INTO wrk_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Munganawa barri, ngala wijbayi Jisus bayungu Jirusalimyurri, baki birrkalanyi nyuli. ");
INSERT INTO wrk_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Najba nyuli kurnda barrinani kalawumbi danbina yubalina. Baki jilajba nyuli kurndarri wudumbiji mama. Ngala najba nyuli mikuyaji mamanyi nanaba, ngawamba wanjirr. Jilijbawa jardijbangka mama. Baki yanybayi Jisus nanankanyi kurndanyi, “Miku ninjiyi mili jardiykunumba mama. Miku.” Baki yinarramba barri dukujbayi nanda kurnda. ");
INSERT INTO wrk_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Baki kandimuku nangangi Jisuskanyi, yali nanaba nangandu. Manku yali nangangi jangkurr, baki najba yali kurnda dukuykurri, baki manmala yali. Manmala yali kudanyu barri, baki ngajaka yali, “Yanka barri nanda kurnda dulu dukujbangka nani barri. Yanka barri.” ");
INSERT INTO wrk_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Jananganjayi yalunya Jisuswanyi, “Ngayu karungka narrinya, jaliyi narri kudanyu kuyu nangangi jangkurr Kudkanyi, baki janarri jingkijba Kud. Janarri jingkijba Kud, janyulu yabimba nanda yaji, jala narri ngajaka Kud yabimbikanyi. Miku narringkimi mankumanku nangangi, yiningki janyulu yabimba narringi yaji Kudwanyi, yiningki miku. Janarri jingkijba Kud, janyulu yabimba nanda yaji jala narri ngajaka. Jaliyi narri kudanyu kuyu nangangi jangkurr nani barri, baki yuku marda janarri yanyba nanankanyi kurndanyi nani barri. Yuku marda janarri yabimba nanamannga yaji. Janarri yanyba kulawiranyi, ‘Ninji kulawira, walajbakiyi. Yirrirdkunumba nganyingkiyi. Jungkukiyi kanjana.’ Nani barri janarri yanyba kulawiranyi, baki janyulu ngayangayijba narringinkanyi jangkurranyi. Janangka yirrirdkunumba. Janyulu jungku kanjana. ");
INSERT INTO wrk_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Jaliyi narri kudanyu kuyu nangangi jangkurr Kudkanyi, baki janyulu yabimba nanda yaji jala ninji ngajaka Kud yabimbikanyi. Barriwa.” Nani barri jananganjayi yalunya Jisuswanyi. ");
INSERT INTO wrk_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Mili barri jilajbayi Jisus bayungu Jirusalimyurri. Wanbiya nyuli, baki mili nyuli ngankijba walkurranyina jurjina. Baki milidimba nyuli yalunya nanaba yajina. Ngala nyuli milidimba yalunya, baki jilajba yali nangandurri mambukamuku jurjkanyi marda malbumalbu. Ngajaka yali Jisus, “Wanyingini yarrijba ninya mambuka. Wanyingini ninya karuyi jakaykanyi yalunya jurjnanyi. Wanyingini ninya karuyi milidimbikanyi yalunya.” Barriwa. ");
INSERT INTO wrk_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Jananganjayi yalunya Jisuswanyi, “Waluku barri jangayu ngajaka narrinya yajinyi. Jaliyi nganarri jananganja, baki yuku jangayu karu narrinya, wanyingini ngana karuyi yabimbiji yaji nani barri. ");
INSERT INTO wrk_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Ngala waluku barri janganarri karu, wanyingini manjijbayi nganinyiyurru Jun, ngurrunbiji yalunyi. Wanyingini. Yiningki Kudwanyi, yiningki nganinyiwanyi. Waluku janganarri karu.” Barriwa. Baki karda yalungki jakakajba. Yanyba yalungki, “Wanyingkanyi jangambala jananganja. Wanyingkanyi. Jaliyi ngambala yanyba, manjijbayi Jun Kudwanyi, baki janyulu yilikajba ngambalanya, ‘Ngala wanyingkanyi miku narriyanyi kuyu nangangi jangkurr.’ Nani janyulu yilikajba ngambalanya, jaliyi ngambala yanyba, manjijbayi Jun Kudwanyi. ");
INSERT INTO wrk_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Ngala kajamuku muramuku yalu yanybaka nangangi Junkanyi, nyuli yanybawarr jangkurranyi nangangi Kudkanyi, jali manjijba Kudwanyi. Jaliyi ngambala yanyba, manjijbayi Jun nganinyiwanyi, baki yiningki jangamanjalu daba. Marrala ngambala yalungi. Yiningki jangamanjalu daba, jaliyi ngambala yanyba, manjijbayi nganinyiwanyi.” Barriwa. Nani barri yalungki jakakajba wanyingkanyi jangkurranyi jayalu jananganja Jisus. ");
INSERT INTO wrk_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Nanankardi barri yali jananganja, “Miku nurriyi jingkijba, wanyingini manjijbayi Jun. Miku nurriyi jingkijba.” Barriwa. Baki yanybayi Jisus yalungi, “Miku nganarriyanyi jananganja kunymamba, baki miku ngayiyi jananganja narrinya. Miku ngayiyi karu narrinya nanankanyi jali ngana karu milidimbiji yalunya.” Barriwa. ");
INSERT INTO wrk_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Mili barri yanybayi Jisus yalungi mambukamukuyngka jurjkanyi baki malbumalbunyi. “Wanyi janarri karu nanginkanyi jangkurranyi. Yingka malbu kujarra nangangi jandanyiwuya. Yingkana kambana nyuli walajba, baki yanyba nyuli nanganginkanyi lirrkanyi jandayngkanyi, ‘Kajakaja. Janinji waki ngaki winyurru. Janinji jilajba baki janinji waki ngakinyina jambana jala jardijba krayib wanjirr.’ ");
INSERT INTO wrk_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Ngala jananganjayi jandanyiwanyi, ‘Miku ngayimi nulijba wakinkanyi nganyi. Jangayu wambu jungku barndana.’ Nani barri nyuli jananganja nangangi nijanganjinyi, ngala kamu barri yangkalamba nangki. Jilajba nyuli, baki waki nyuli nanganginkanyi nijanganjiyngkanyi nanganginyina jambana. ");
INSERT INTO wrk_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Waluku barri yanybayi malbu nanganginkanyi lirrkanyi jandayngkanyi, baki bayngkani barri nyuli jilajba nanganginkurri jaduyngkurri jandayngkurri, baki ngajaka nyuli nanda jadunyi nangangi jandanyi wakinkanyi nanganginyina jambana. Jananganjayi nanangini jandanyiwanyi, ‘Yi malbu. Jangayu waki ngaki. Jangayu waki nganyinyina jambana.’ Ngala jujijba nyuli. Miku nyuliyanyi jilajba. Miku nyuliyanyi waki nangangi. Wambu nyuli jungku barndana. Barriwa. ");
INSERT INTO wrk_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Ngayu ngajakangka narrinya, Wanyingini yabimbayi nanda jali ngajaka malbuwanyi. Wanyingini.” Baki jananganja yali, “Nanda lirrka jandanyi jali nangka yangkalamba, nyuli yabimba nanda jali ngajaka malbuwanyi.” Baki yanybayi Jisus yalungi, “Ngayu karungka narrinya, nanamuku jala yalu balkimirra, nanamuku jala yalu kuluka yingkana nganinyina baki yingkana nganinyina yurrngumba barri, nanamuku jala yalu kuyu bayngkani dungalana yalunbunanyi yurrngumba barri, jayalungka yangkalamba nangandurri Kudyurri. Janyulu lalanba yalunya Kudwanyi. ");
INSERT INTO wrk_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Badajbayi Jun Ngurrunbawarr, baki milidimba nyuli narrinya nanankanyi yurlurrmba yuwanyi, narri durriykanyi, ngala miku narriyanyi kuyu nangangi jangkurr. Ngala nanamukunyi balkimukunyi, yali kuyu nangangi jangkurr, yali durrijba nangangi yuwa. Narri jingkijbangka yalunya, yali kuyu nangangi jangkurr, baki jungku kunybana nanganginyina yuwana, ngala yuwajiwa barri miku narrimi ngindu muwa narringinkanyi balkinyi yajinyi. Miku narrimi kuyu nangangi jangkurr. Baki nanankardi barri janyulu lalanba yalunya waluwa narringi Kudwanyi.” Barriwa. Nani barri ngirrwayi Jisus yalungi. Barriwa. ");
INSERT INTO wrk_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Mili barri yanybayi Jisus yalungi milidimbiji yalunya. Muningka nyuli yanyba yalungi, “Karrinjarrijbayi krayib wanjirr malbuwanyi nanganginyina jambana. Karrinjarrijba nyuli kaja wanjirr jambana. Yabimba nyuli barriki lukuluku jambana, baki kurrijba nyuli lawarr. Nanda lawarr jidimbikanyi ngarrki krayibnanyi. Baki yabimba nyuli barrawu jungunkanyi nganinyi kalawunyi jala yalu lalanba nanda jamba. Nani nyuli yabimba yaji malbuwanyi. Baki yarrijba nyuli yingkamuku nganinyimuku, yalu lalanbiji nangangi jamba. Baki janyulu wajba yalunya kudiyayngka krayibkanyi lalanbikanyi nangangi yaji. Baki barlba nyuli yingkarri yajiyurri. Barlba nyuli juju, baki jungku nyuli nananyina yajina yurrngumba barri. Barriwa. ");
INSERT INTO wrk_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Jardijbayi wanjirr walkurra mamayudi. Jali nanda mama kunyunyu, baki manjijbayi nanganginmuku wakiwarrmuku malbuwanyi. Manjijba nyuli yalunya yalundurri jala lalanba nangangi jamba. Manjijbayi yalunya wudumbiji nangangi mama, kudiyambikanyi kudukudu. ");
INSERT INTO wrk_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Ngala nanamuku nganinyimuku jali yalu lalanba nangangi jamba, miku yaliyi kunybamuku. Marrimba yali nanamuku wakiwarrmuku jali manjijba malbuwanyi. Yingka yali wajuba, yingka yali kurdanba, yingka yali daba dungalayudinyi. ");
INSERT INTO wrk_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Ngala manjijbayi mili wakiwarrmuku malbuwanyi. Manjijba nyuli kaja mili yalundurri wudumbiji nangangi mama. Jabarri mili yali marrimba yalunya nanamukunyi balkimukunyi lalanbawarranyi. Wajuba yali, baki kurdanba yali, baki daba yali dungalayudinyi. ");
INSERT INTO wrk_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Baku barri manjijbayi yingka yalundurri malbuwanyi. Manjijbayi nangangi jandanyi. Mankumanku nangki malbu, ‘Jalija jilajba ngakinmirra jandanyi yalundurri, baki jayalu karda jungku. Miku yaliyi daba. Jayalu kuyu nangangi jangkurr.’ ");
INSERT INTO wrk_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Ngala jali yalu najba nangangi jandanyi jilaykurri yalundurri, baki yanyba yalungki, ‘Nayinda jala badajbangka, nyulu jandanyi nangangi malbunyi. Jalija nangka janyba malbu, baki nanangini nanganginyi jandanyiwanyi, janyulu wudumba nayinda jamba ngabayidi. Jangambala marrimba, jangambala kurdanba, baki jangambala kuyu nayinda jamba ngabayidi ngamanginkanyi barri.’ Nani barri yalungki yanyba. ");
INSERT INTO wrk_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Baki jali wanbiya nanda jandanyi, baki marrimba yali, janyba yali danbiyurri barrikina, baki kurdanba yali. Barriwa.” ");
INSERT INTO wrk_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Baki ngajakayi yalunya Jisuswanyi, “Jalija badajba nanda malbu nanganginkurri jambarri, baki wanyimba janyulu yalunya, jali nyulu yarrijba lalanbikanyi nangangi yaji. Wanyimba janyulu yalunya.” ");
INSERT INTO wrk_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Jananganja yali, “Janyulu kurdanba nanamuku balkimuku lalanbawarrmuku. Janyulu kurdanba yalunya, baki janyulu yarrijba yingkamuku lalanbikanyi nangangi jamba. Janyulu yarrijba kunybamuku lalanbawarrmuku, jalija wajba nanda malbu nanganginkanyi mamanyi jalija kunyunyu.” Barriwa. Baki yanybayi Jisus yalungi, “Yi. Nanda jangkurr narringi duja jangkurr. ");
INSERT INTO wrk_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","43","Ngayu karungka narrinya. Miku nyuliyi mili lalanba narrinya Kudwanyi, ngala janyulu lalanba yalunya jala yalu ngindu muwa yalunginkanyi balkinyi yajinyi, jala yalu jungku kunyba nanganginyina yuwana. Janyulu lalanba yalunya Kudwanyi, miku narrinya.” Baki mili yanybayi Jisus yalungi, “Jingkijba kuna narri nayi jangkurr najana Kudkanyi jala muningka yanybaka, ‘Jali yalu yabimba barrawu, baki miku yaliyanyi nulijba yingamali kurnda. Ngala janyba yali nanda kurnda. Ngala baku barri yingkawanyi nyuli yabimba barrawu nangangi Kudkanyi. Wudumba nyuli nanda kurnda jali yalu waluwa janyba, baki yarrijba nyuli yundukula nananyina barrawuna Kudkanyi. Nanda jirrinyi kurnda nanganginyina barrawuna.’” Barriwa. Nani yanybayi Jisus yalungi, nyuli barrinani nanda jirrinyi kurnda yundukula, jali waluwa yingkawanyi janyba. Kajamuku yali yurlwa nangangi Jisuskanyi, ngala nyuli yarrijba Jisus walkurra mambuka Kudwanyi. Mili barri yanybayi Jisus yalungi, “Mili nanda jangkurr najana Kudkanyi yanybaka. ‘Ngambala najbangka yaji jala yabimbaka Kudwanyi, baki ngambala mirnarrijba muwa nangangi.’ Barriwa. ");
INSERT INTO wrk_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Mankuyi nangangi jangkurr mambukamukunyi jurjkanyi marda Barasimukunyi. Manku yali nanda jangkurr jali muningka nyulu yanyba, baki jingkijba yali, nyulu karuyi jangkurranyi yalungi. Jingkijba yalungki, nyuli yanyba yalungi, yalu jungunkanyi balki nangangi Kudkanyi. ");
INSERT INTO wrk_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Baki nanankardi barri yali ngarrangarra muwa nangangi. Yali kijiwijba kudanyu barri. Yaliyanyi marrimba Jisus, yaliyanyi janyba brisinyurri, ngala miku yaliyanyi marrimba. Marrala yali yalungi muramukuyngka. Marrala yali muramukuyngka jali yanyba nangangi Jisuskanyi, nyuli nanda jala yanyba jangkurr nangangi Kudkanyi. Nanankardi barri miku yaliyanyi marrimba Jisus nanamanji barri. Barriwa. ");
INSERT INTO wrk_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","2","Mili barri yanybayi Jisus yalungi muramukuyngka, “Jangayu mili karu narrinya Kudkanyi. Mili barri jangayu muningka yanyba narringi. Yingka barri walkurra mambuka, nyuli jandanyiyudi. Jamaluyi jibarri jandanyiwanyi, baki yabimbayi wangarr bulangi nanangini mambukawanyi. Yabimba nyuli wangarr bulangi jali bulangka jamalu. ");
INSERT INTO wrk_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Manjijba nyuli nanganginmuku wakiwarrmuku wudumbiji yingkamuku wangarranyi. Karu yalunjali wangarranyi, ngala miku yaliyanyi nulijba badaykanyi. ");
INSERT INTO wrk_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Baki manjijba nyuli mili wakiwarrmuku yalundurri wudumbiji yalunya. Karu yalunjali nanankanyi jangkurranyi mambukanyi, ‘Marda narrimi walajba wangarranyi. Ngarrkadaba ngayi buluki baki kabikabi. Kaja barnyi ngayi wudumba narringi marda mama. Marda narrimi walajba wangarranyi.’ ");
INSERT INTO wrk_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Ngala yurlwa yali nanankanyi jangkurranyi mambukanyi. Miku yaliyala badajba. Yingkamukunyi yali muningka yabimba yaji yalungi. ");
INSERT INTO wrk_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Ngala yingkamukunyi yalunjali marrimba nanamuku wakiwarrmuku mambukanyi. Yalunjali wajuba baki kurdanba. ");
INSERT INTO wrk_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Ngala nanda mambuka barri, jali nyulu manku jangkurr nanankanyi yajinyi, baki ngarrangarra nyuli muwa. Ngarrangarra nyuli muwa yalungi jali yalu kurdanba nanganginmuku wakiwarrmuku. Baki manjijba nyuli nanganginmuku ngarrkadabawarrmuku yalundurri. Ngarrkadaba yalunjali balkimuku, baki kurdanba yalunjali. Baki bakarrijba yali yalungi barndamuku. Bakarrijba yali nanamuku barrawuyabarrawuya, barriwa barri bukamba. ");
INSERT INTO wrk_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Baki mili nyuli kaya yalungi nanganginmukuyngka wakiwarrmukuyngka. Baki yanyba nyuli yalungi, ‘Nanamuku jali ngayu ngajaka barrin jilaykanyi wangarranyi, yali balkimuku. Jungku yali balki, yurlwangangi yali ngakinkanyi jangkurranyi. Ngala kaja mama nyulu nayiba marda barnyi wangarranyi. ");
INSERT INTO wrk_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Janarri jilalajba yubarlina lukuluku. Janarri karu yalunya jala narri najba barndana. Janarri yililikajba yalunya, yalu walaykanyi nanginkurri wangarranyi.’ Nani barri nyuli jirrinyba yalunya. Barriwa. ");
INSERT INTO wrk_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Baki jilalajba yali lukuluku. Najba yali kajamuku, nganinyimuku baki jibarrimuku, kudiya kunybamuku baki kudiya balkimuku. Baki yililikajba yalunjali walaykanyi wangarranyi. Baki kajamuku yali walajba nanankanyi wangarranyi, jali yabimba mambukawanyi. Kajamuku yali walajba. Jali yalu wanbiya, baki wajba yalunjali kunybanyi jumbalanyi wakiwarrmukunyi. Yawumba yalungki nanda jumbala, baki ngankijba yali barrawuna wangarranyi. Baki walbinyi nanda barrawu. Barriwa. ");
INSERT INTO wrk_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","Waluku barri bukambiju yali ngankijba barrawuna, baki bayngkani barri nanda mambuka ngankijbayi. Ngala najba nyuli yingamali nganinyi, mikuyaji kunybanyi jumbalanyi nangandu. Miku nangkiyanyi yawumba kunyba jumbala jali wajba wakiwarranyi. ");
INSERT INTO wrk_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Baki ngajakayi nanda nganinyi mambukawanyi, ‘Kandi. Wanyingkanyi ninji ngankijba barrawuna wangarranyi, mikuyaji kunybanyi jumbalanyi, jali ngayu wajba ninga.’ Nani barri ngajakayi nganinyi mambukawanyi, ngala miku nyuliyanyi jananganja nanangini nganinyiwanyi. Mikukiyanyi jananganja nanda mambuka. ");
INSERT INTO wrk_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Baki nanangini mambukawanyi, nyuli jirrinyba nangangi wakiwarr, ‘Marrimbakiyi nayinda nganinyi. Kijijbakiyi nangangi jalu baki nguli kurulyudinyi, baki janybakiyi danbiyurri, jala mungijba yaji. Nanaba barri janangka ngindu muwa. Kudanyu barri janangka ngindu muwa, mikungangi nangkiyanyi yawumba nanda kunyba jumbala.’ Barriwa.” ");
INSERT INTO wrk_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Nani barri yanybayi Jisus yalungi wangarranyi, baki mili nyuli yanyba yalungi, “Nanda mambuka jali yabimba wangarr yalungi, nyuli barrinani Kud. Nanangini mambukawanyi, nyuli yililikajba yalunya, yalu walaykanyi nanganginkurri barrawurri wangarr. Kajamuku nyuli yililikajba wangarranyi. Baki nani barri nyulu marda yililikajbangka yalunya Kudwanyi. Nyulu yililikajbangka yalunya walaykanyi nangandurri, jungunkanyi mili wanka nangandu kingkarri. Jali yilikajba yalunya wakiwarranyi, baki kajamuku yali yurlwa nanankanyi jangkurranyi mambukanyi. Miku yaliyala walajba wangarranyi. Baki nani barri, kajamuku yalu yurlwangka nanganginkanyi jangkurranyi Kudkanyi, baki miku yaliyi jungku mili wanka nangandu Kudnyina yurrngumba barri. Ngala yingkamuku walajba yali wangarranyi, yalungki yawumba jumbala jali wajba yalunya mambukawanyi. Baki nani barri yingkamuku yalu kuyungka nanda jangkurr jali wajba yalunya Kudwanyi. Jayalu jungku mili wanka nangandu Kudnyina. Ngala yingka nyuli nulijba jungunkanyi wangarranyi, baki ngankijba nyuli barrawuna, ngala miku nangkiyanyi yawumba jumbala jali wajba mambukawanyi. Baki nani barri, yingkamuku yalu nulijba jungunkanyi mili wanka nangandu Kudnyina, ngala miku yalimi kuyu nanda jangkurr, jali wajba Kudwanyi. Miku yalimi kuyu nangangi jangkurr, baki nanankardi janyulu janyba yalunya danbiyurri nanankurri Yilyurri. Barriwa.” Nani barri nyuli milidimba yalunya Jisuswanyi. ");
INSERT INTO wrk_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Nanamukunyi Barasimukunyi yali manku nangangi jangkurr, baki jingkijba yali, jali muningka yanyba Jisus jangkurranyi, baki nyuli karu nanankanyi jangkurranyi yalungi. Jingkijba yalungki, yalu jungunkanyi balkina yuwana Kudkanyi. Nanankardi barri yaliyanyi marrimba Jisus. Barlba yali baki yanyba yalungki, yanka jayalu marrimba Jisus. Yanka jayalu yililikajba Jisus jangkurranyi, balanjankanyi Jisus, nyulu yanybikanyi balki jangkurr. ");
INSERT INTO wrk_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Nani barri yalungki yanyba, baki manjijba yali yingkamuku yalunya nangandurri Jisusyurri. Manjijba yalunjali jawuda yalunginmuku kandimuku, baki jawuda jali yalu durrijba jangkurr nangangi Yirudkanyi, jali yalu nulijba Yirudkanyi yalunginkanyi mambukanyi. Wanbiya yali, baki yanybayi yali nangangi Jisuskanyi, “Milidimbawarr. Nurru jingkijbangka ninga, ninji yanybaka duja jangkurr. Ninji milidimbaka duja nangangi Kudkanyi. Miku ninjimi marrala yalungi yingkamukuyngka. Ninji milidimbaka walkurra mambukamuku, baki bayakardamuku. Ninji milidimbaka bukambiju yalunya. ");
INSERT INTO wrk_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Karukiyi nurrunya, wanyi ninji yanyba nanginkanyi. Nanda wirimalaru Kubaminkanyi, niji Sisa, nyulu wudumbaka dungala ngamanbunanyi. Nyulu manjijbangka nganinyimuku wudumbiji dungala ngamanbunanyi. Yuku barri kuna yuwana Kudkanyi ngambala waykanyi Kubamin mambuka dungalanyi. Jangambala wajba kuna. Yiningki miku ngambaliyi wajba dungalanyi. Wanyi ninji yanybaka.” Nani yali ngajaka Jisus. ");
INSERT INTO wrk_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Ngala jingkijbayi yalunya Jisuswanyi, balanja yali. Muningka yali ngajaka Jisus, nyulu yanybikanyi balki jangkurr nanankanyi mambukanyi Sisakanyi. Baki jaliyi nyulu yanyba balki jangkurr nani mambukanyi, baki jayalu marrimba. Baki yanybayi Jisus yalungi, “Narri jujambawarrmuku. Wanyingkanyi nganarri balanjaka. Wanyingkanyi narri nulijbangka jujambikanyi nganarri. ");
INSERT INTO wrk_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Minimbakiyi yingamali dungala ngaki.” Baki minimba yali dungalanyi. ");
INSERT INTO wrk_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Baki ngajakayi yalunya Jisuswanyi, “Wanyi wali nayiba dungalana, wanyi niji nayiba dungalana. Wanyi barri.” ");
INSERT INTO wrk_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Baki jananganja yali, “Nayinda nangangi wali baki nangangi niji Sisakanyi.” Barriwa. Baki yanybayi Jisus yalungi, “Ngayu karungka narrinya nanginkanyi jangkurranyi. Wajbakiyi Sisa nanankanyi nanganginkanyi yajinyi, ngala wajbakiyi Kud nanankanyi nanganginkanyi yajinyi.” Barriwa. ");
INSERT INTO wrk_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Jali yalu manku nangangi jangkurr, baki manmala yali. Manmala yali nanganginkanyi jangkurranyi. Baki barlba yali. Barriwa. ");
INSERT INTO wrk_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Kamu barri badajbayi yingkamuku nangandurri Jisusyurri. Yali Sajusimuku jalili yalu durrijba nanda yuwa nangangi Musiskanyi, ngala yalili yanyba, miku ngambaliyi jungku mili wanka yurrngumba, ngala jangambala jungku kurdan yurrngumba barri. Badajba yali nangandurri. ");
INSERT INTO wrk_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","Baki yanyba yali, “Milidimbawarr. Yarrijbayi Musiswanyi jangkurr najana Kudkanyi ngambalangi. Nayi nangangi jangkurr yanybaka, ‘Jaliyi nangka janyba buwanya, baki yingijba nyulu nangangi maninganja, ngala buli mikuyaji bardardanyi bulangi. Jaliyi nangka janyba nangangi buwanganja nani barri, baki nanganginyi bababanyamba nyulu janyulu wudumba nanda jibarri. Baki baku barri jalija bula wakaramba bardarda, baki jayalu muningka yanyba nanankanyi bardardanyi, ‘Nayinda bardarda, nyulu jandanyi nangangi, nanankanyi buwanganjarruwa. Nyulu nangangi jandanyi.’ Nani barri yanybaka yuwa nangangi Musiskanyi. Nani jayalu muningka yanyba nanankanyi bardardanyi. ");
INSERT INTO wrk_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Janurru nurru karu ninga buwawakulayngka. Kajamuku buwawakula, 7-barri. Nanangini lirrkawanyi, nyulu wudumbayi maninganja, ngala bijal barri baku nangki janyba. Mikuyaji bardardanyi bulangi. Mikuyaji. Barriwa. Baki yingkawanyi bababanyamba nyulu bayngkani nangandu, nyuli wudumba nanda miyaji. ");
INSERT INTO wrk_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Ngala janyba nangki nanda nganinyi marda, baki mikuyaji nangangi bardardanyi. Barriwa. Baki yingkawanyi bababanyamba nyulu bayngkani nangandu, nyuli wudumba nanda miyaji, ngala baku barri bijal nangki janyba, mikuyaji nangangi bardardanyi. Barriwa. Nani barri yingkawanyi bababanyamba nyulu wudumbayi nanda miyaji, baki nangki janyba. Baki yingkawanyi wudumbayi baku, baki yingkawanyi baku barri. Nani barri bukambiju buwawakula yalungki janyba. ");
INSERT INTO wrk_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Ngala nanda miyaji, mikuyaji nangangi bardardanyi. Baki baku barri bayngkani nangki janyba nanda miyaji marda. ");
INSERT INTO wrk_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Baku barri juju jalija yalu wankijba mili, baki wanyi janyulu nawinganja nanankanyi jibarrinyi. Wanyi barri. Nyuli maninganja yalungi bukambijuyngka buwawakulayngka. Wanyi janyulu nawinganja nanankanyi jibarrinyi.” Barriwa. Nani barri yalu ngajaka Jisus. ");
INSERT INTO wrk_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Ngala jananganjayi yalunya Jisuswanyi, “Barimba narri nanda jangkurr jali yanyba Musis najana Kudkanyi. Barimba narri nangangi jangkurr. Miku narrimi jingkijba nanda naja Kudkanyi. Baki miku narrimi jingkijba nanda ngiruka yaji jalija yabimba Kudwanyi baku barri. ");
INSERT INTO wrk_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Jalija yalu mili wankijba, baki miku jayalu wudumba maninganja, baki nawinganja. Miku jayalu jungku mili maykarra. Ngala jayalu jungku barrinani Yanjilmuku, jala mikuyaji yalungi kayikayinyi. ");
INSERT INTO wrk_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Ngala narri barri, narri yanyba nanankanyi nganinyiyurruwa, miku nyuliyi wankijba mili. Janyulu jungku kurdan yurrngumba. Ngala narri jingkijba nanda jangkurr najana Kudkanyi. Yanybayi Kud nayinda jangkurr yalungi wankalamukuyngka, ");
INSERT INTO wrk_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","‘Ngayu Kud nangangi Yabrayamkanyi. Ngayu Kud nangangi Yayisakanyi. Marda ngayu Kud nangangi Jakubkanyi.’ Nani barri yanybayi Kud yalungi wankalamukuyngka. Ngala miku nyulimi Kud yalungi jala yalu jungku kurdan. Ngala nyulu Kud yalungi nanamukuyngka jala yalu wanka jungku. Nanankardi ngambala jingkijba, nanamuku wankalamuku yalu mili wankijba barri, nyulungangi yalungi Kud.” Barriwa. ");
INSERT INTO wrk_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Jali yalu manku nangangi jangkurr muramukunyi, baki manmala yali. Manmala yali nanganginkanyi jangkurranyi, jali nyulu jananganja yalunya Sajusimuku. Nangangi jangkurr mili ngiruka yalunginkanyi jangkurranyi. Nyuli wakaramba yalunya, baki miku yaliyi jananganja Jisus mili jangkurranyi. Barriwa. ");
INSERT INTO wrk_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Yingkamukunyi yalunjali karu Barasimuku nanankanyi jangkurranyi Jisuskanyi, jali mikuwali jananganja Sajusimukunyi baki yalungki malumba yanyba Barasimuku. ");
INSERT INTO wrk_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Yaliyanyi jujamba Jisus, baki manjijba yali yingka jali milidimba yuwanyi Musiskanyi. Manjijba yali nanda milidimbawarr nangandurri Jisusyurri, jujambikanyi Jisus jangkurryudinyi. ");
INSERT INTO wrk_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","Ngajaka nyuli Jisus, “Milidimbawarr. Nanda yuwa jungunkanyi ngambala kunyba nangangi Kudkanyi, kaja nanda jangkurr. Ngala wanyi nanda yingamali jirrinyi jangkurr. Janganinji karu, wanyi yingamali jirrinyi jangkurr.” ");
INSERT INTO wrk_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Jananganjayi Jisuswanyi, “‘Marda ninjimi maruka muwa nangangi Kudkanyi. Marda ninjimi kudanyu maruka muwa nangangi. Marda ninjimi kudanyu nulijba nangangi Kudkanyi nganyinyina kurduluna. Marda nganyingkimi mankumanku nangangi Kudkanyi nganyinyina kulajina.’ ");
INSERT INTO wrk_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Nayinda nanda yingamali jirrinyi jangkurr, narri ngayangayiykanyi. ");
INSERT INTO wrk_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Marda yingka jirrinyi jangkurr bayngkani nangandu. Nayi barri, ‘Nganyingka maruka muwa, baki nani barri marda ninjimi kudanyu maruka muwa yalungi yingkamukuyngka marda.’ ");
INSERT INTO wrk_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Nanginkujarra jirrinyi yuwa narringi. Bukamba nanda yuwa nangangi Musiskanyi, baki nanda jangkurr nangangi Kudkanyi jali yanyba wankalamuku, yalu bayngkani nanankujarrayngka. Nanankujarra yuwa kujanya nanamukuyngka yingkamukuyngka yuwanyi. Jaliyi narri ngayangayijba nanankujarrayngka yuwanyi, baki janarri ngayangayijba bukamba nanamukuyngka yingkamukuyngka yuwanyi. Barriwa.” ");
INSERT INTO wrk_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Karrinjayi jawuda Barasimuku nangandu Jisusnyina, baki ngajaka nyuli yalunya, ");
INSERT INTO wrk_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“Nanamukunyi wankalamukunyi nangangi Kudkanyi, yali karu ngambalanya nangangi Krayiskanyi jalija manjijba Kudwanyi baku barri. Yali karu ngambalanya nangangi. Wanyi narri yanyba nangangi Krayiskanyi. Wanyi nyulu barrinani wankalanyi nijanganjinyi nangangi Krayiskanyi.” Jananganja yali, “Nanda walkurra nganinyi Dayibid, nyulu barrinani wankalanyi nijanganjinyi nangangi Krayiskanyi.” Barriwa. ");
INSERT INTO wrk_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Baki mili ngajakayi yalunya Jisuswanyi, “Minimbayi Dayibid yajinyi Kunybawanyi Ngarnduwanyi Kudkanyi. Minimba nyuli Dayibid Krayiskanyi, baki yanybayi Dayibid nangangi, ‘Nanda Krayis, nyulu ngaki mambuka. Mambuka nyulu ngaki.’ Barriwa. ");
INSERT INTO wrk_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","Baki yarrijbayi nayinda jangkurr najana Dayibidwanyi. Nayinda barri, ‘Yanybayi Kud ngakinkanyi mambukanyi Krayiskanyi. Yanybayi Kud nangangi, “Jungkukiyi ngakindu. Kajamuku, jala miku yalimi maruka muwa ngaki, janinya yalu daba, ngala jangayu ngayu yalunya daba wakara barri. Jangayu wakaramba yalunya, jalija ngayu daba yalunya. Baki jayalu jingkijba ninya, ninji barri mambuka yalungi.’ Nani nyuli yarrijba jangkurr najana Dayibidwanyi. ");
INSERT INTO wrk_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Yanybayi Dayibid nangangi Krayiskanyi, nanda Krayis, nyulu nangangi mambuka. Ngala yanka barri nyulu Dayibid barrinani wankalanyi miminganja nangangi Krayiskanyi nanankanyi, jali nyulu kuyu nangangi mambuka. Yanka barri. Janganarri jananganja.” ");
INSERT INTO wrk_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Ngala miku yaliyanyi jingkijba wanyi jangkurr jananganjankanyi. Kardarda yali jungku, baki nanamunanyi kambananyi, marrala yali ngajakankanyi Jisus mili jangkurranyi. Baki miku yaliyanyi ngajaka mili barri. ");
INSERT INTO wrk_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Baki yanybayi Jisus yalungi muramukuyngka, baki nanganginmukuyngka kandimukuyngka. Yanyba nyuli, ");
INSERT INTO wrk_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","“Nanamuku jala milidimba yuwanyi Musiskanyi, baki nanamuku Barasimuku, yalu marda milidimbawarr nanankanyi yuwanyi Musiskanyi. Yalu jingkijbawarr nanganginkanyi yuwanyi Musiskanyi wankalanyi. ");
INSERT INTO wrk_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Nanankardi barri marda narrimi kuyu yalungi jangkurr. Marda narrimi ngayangayijba yalunginkanyi jangkurranyi. Yalu milidimbaka narrinya, narri jungunkanyi kunymamba nananyina yuwana Musiskanyi. Nani yalu milidimbaka narrinya, ngala yalu barri, miku yalimi jungku kunyba nananyina yuwana. Marda narrimi kuyu yalungi jangkurr, ngala marda narrimi miku yabimba nanda jala yalu yabimba, mikungangi yalimi jungku kunymamba nananyina yuwana. Yalunjalu karu yingkamuku ngayangayiykanyi yuwanyi Musiskanyi, ngala yalu barri miku yalimi ngayangayijba nanankanyi yuwanyi. ");
INSERT INTO wrk_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Baki yalu yabimbaka kaja mili yuwa narringi ngayangayiykanyi. Kaja mili yuwa yalu yabimbaka, ngala miku yalungi yuwa kunyba. Jardibirri yalungi yuwa ngayangayiykanyi. Miku yalimi ngayangayijba bukambijuyngka yalunginkanyi yuwanyi, ngala yalu yurlwa kudiyayngka yalunginkanyi yuwanyi. Yalunjalu milidimbaka nanankanyi yuwanyi, ngala miku yalunjalimi minimba, yanka jayalu jungku kunymamba nananyina yuwana. ");
INSERT INTO wrk_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Yalili yarrijba jawuda nanda yuwa najana milidimbawarranyi, bakili yalu kijijba nanda naja yalunginyina jaluna baki walina, barrinani bakiri. Nani barri yalili jungku, baki yingkamuku jayalungka mankumanku yalungi milidimbawarrayngka, yalu jungku kunymamba nananyina yuwana. Yalili yarrijba kurdalirri kurul yalundu jumbalana. Barlbarlbalakili yalundu ngulina. Nani barri yalili yabimba minimbiji yalunya, yalu marukangka muwa nangangi Kudkanyi. Nani barri yalili jungku. Baki nanankardi yingkamuku barri, ngamu yalu jungkuka kunymamba nangangi Kudkanyi. Ngala miku yalimi jungku kunymamba nangangi. Yalunjalu jujambaka. ");
INSERT INTO wrk_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Nulijba yalu yalungi, yalungka mankumankunkanyi yalungi, yalu jirrinyi nganinyimuku. Jalili yalu jungku jurjina, baki wangarrina, bakili yalu jungku walu barri yalundu mambukamukunyina. ");
INSERT INTO wrk_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Muningka yalili jilajba lukuluku barrawuyabarrawuyana, baki yingkamukunyi yalunjalili najba jilalaykurri. Yanyba yalungkili, yalu walkurramuku. Nulijba yalu yingkamukuyngka, yalu yanybikanyi yalungi nayi barri, “Narri barri, narri Milidimbawarr yuwanyi nangangi Kudkanyi. Nurru wajbangka narrinya kunybanyi jangkurranyi nurrunginkanyi.” Barriwa. ");
INSERT INTO wrk_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Ngala narri barri ngakinmuku kandimuku, marda narrimi miku munyajba yingka, nyulu nijarriykanyi narrinya “Milidimbawarr.” Marda narrimi miku munyajba yingka nyulu yarriykanyi yingka mili walkurra waluwa yingkanyi. Narri jungku kandimuku, narri jungku barrinani buwawakula. Miku narrimi milidimbawarr yalungi. Ngala yingamali narringi milidimbawarr. Ngawamba yingamali narringi milidimbawarr, ngayu barri. ");
INSERT INTO wrk_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Narri jungkuka nayiba jambana, ngala ngawamba yingamali nyulu narringi Buwakanya Kingkarri. Nyulu Kud, nyulu narringi Buwakanya Kingkarri, nyulu jirrinyimirra mambuka narringi. Nanankardi barri, marda narrimi miku yarrijba yingka jirrinyimirra mambuka narringi. Marda narrimi miku nijarrijba yingka ‘Buwakanya,’ jala nyulu miku dujanya nganyi nijanganjinyi. ");
INSERT INTO wrk_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Baki marda narrimi miku nijarrijba yingka ‘Walkurra Mambuka.’ Ngawamba yingamali narringi walkurra mambuka, ngayu barri Krayis. ");
INSERT INTO wrk_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Nanda walkurra narringi, marda nyulimi jungku wakiwarr narringi. ");
INSERT INTO wrk_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Nanda jala nangka walkurramba, janyulu nyulu bayakardamba Kudwanyi. Ngala nanda jala nangka bayakardamba barri, jala wakiwarr yalungi, janyulu nyulu walkurramba Kudwanyi. Barriwa. ");
INSERT INTO wrk_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","Narri, Barasimuku, baki narri milidimbawarrmuku yuwanyi, ngayu karungka narrinya ngirukanyi jangkurranyi. Narri balkimirra. Narri jujambawarrmuku. Dabaja narrinya Kudwanyi. Miku narrimi milidimba yurlurrmba jangkurr nangangi Kudkanyi, baki nanankardi barri miku yaliyi kirrijba kingkarri nangandurri Kudyurri, miku nyuliyi lalanba yalunya Kudwanyi. Baki miku nyuliyi lalanba narrinya marda, milidimbangangi narri balki jangkurr. Nanamuku jala yalu nulijba kuyunkanyi nanda duja jangkurr nangangi Kudkanyi, narri jujamba yalunya. Narri yabimba yalunya kuyunkanyi narringi balki jangkurr. Nanankardi barri janarri miku jungku mili wanka nangandu Kudnyina. Baki nanamuku jala yalu kuyu narringi jangkurr, narringinyi balkiwanyi jangkurrwanyi kurrkunbaka yalunya marda, yalu jungunkanyi mili wanka nangandu Kudnyina. ");
INSERT INTO wrk_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","Narri Barasimuku, baki narri milidimbawarrmuku yuwanyi, ngayu karungka narrinya ngirukanyi jangkurranyi. Narri balkimuku. Narri jujambawarrmuku. Dabaja narrinya Kudwanyi. Miku narrimi milidimba yurlurrmba jangkurranyi. Narri jilajbangka juju nukamina yingkarri yajiyurri, baki yingkarri yajiyurri. Narri birlbidambaka kanja yingkarri yajiyurri, baki yingkarri yajiyurri. Narri kujbangka yalungi, jalija yalu manku narringi jangkurr, baki janarri milidimba yalunya narringinkanyi balkinyi jangkurranyi. Baki jalija yalu kuyu nanda jangkurr narringi, jalija yalu durrijba nanda jangkurr, baki jayalu jungku mili balki nangangi Kudkanyi. Baki nanankardi barri janyulu bukamba yalunya Kudwanyi. Janyulu manjijba yalunya wayka jangurri Yilyurri. Baki janyulu manjijba narrinya marda jangurri Yilyurri, milidimbangangi narri yalunya nanankanyi balkinyi jangkurranyi. Barriwa. ");
INSERT INTO wrk_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","17","Narri balkimuku. Narri mudumuku. Dabaja narrinya Kudwanyi. Narri barrinani nanda nganinyi jala wililijba nanda kabuji kurndayudinyi, ngala nyulu marda kabuji yami. Miku narrimi kudanyu jingkijba nanda yuwa nangangi Kudkanyi, jala narri milidimba yalunya. Miku narrimi milidimba yalunya kunymamba, ngala barimba narri milidimba yalunya. Nayi narri milidimba. Narri karu yalunya nanankanyi dankurrdankurranyi malankarrinyi walkurranyina jurjina. Nanda dankurr malankarri nanda kudukudu yaji, ngala miku nanda walkurra jurj kudukudu. Ngawamba nanda malankarri kalawuyngkurru jurjina. Ngala narri mudumuku. Ngala miku nanda kunyba jangkurr narri yanyba. Nanda walkurra jurj, nanda kudukudu yaji nangangi Kudkanyi, ngala miku nanda dankurr malankarri yaji kudukudu. Jala yalu yarrijba nanda dankurr malankarri kalawuyngkurru jurjina, baki yabimbaka malankarri kudukudu nanangini jurjwanyi, nandangangi jurj nangangi yaji Kudkanyi. ");
INSERT INTO wrk_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Baki narri yanyba yingka jangkurr. Narri milidimba yalunya nayi barri, ‘Nanda dungala yaji, niji Yalda nananyina walkurranyina jurjina, miku nanda dungala kudukudu. Ngala nanda barnyi jala yalu yarrijba yundu nananyina dungalana, nanda barri kudukudu.’ Nani barri narri milidimba yalunya, ngala miku nanda kunyba jangkurr. ");
INSERT INTO wrk_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Narri barrinani nanda kabujimuku. Miku narrimi jingkijba nanda duja jangkurr. Nanda dungala yaji, nanda Yalda, nanda kudukudu yaji nangangi kudkanyi, ngala miku nanda barnyi kudukudu. Ngala jala yalu yarrijba nanda barnyi yundu dungalana Yaldana, baki yabimbaka nanda barnyi kudukudu nanangini dungalawanyi. ");
INSERT INTO wrk_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","21","Nayinda barri duja jangkurr. Nanda walkurra jurj, nanda kudukudu yaji nangangi Kudkanyi, baki nanda dungala Yalda, nanda kudukudu yaji nangangi marda. Ngala nanda dankurr malankarri, ngawamba nyulu jungkuka kudukudu, jala yalu yarrijba kalawuyngkurru nananyina jurjina nangangi Kudkanyi. Baki nanda barnyi marda, ngawamba nyulu jungkuka kudukudu, jala yalu yarrijba yundu nananyina dungalana nangangi Kudkanyi. ");
INSERT INTO wrk_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Baki nani barri nayi marda. Jaliyi yingka yanybaka nanankanyi lalijinyi kingkarri, nanda kudukudu yaji, baki miku nanda duja jangkurr. Miku nanda laliji kudukudu. Ngawamba Kud jala jungkuka lalijina, nyulu barri kudukudu. Nani barri narri barimba milidimba yalunya. Barriwa. ");
INSERT INTO wrk_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","Narri Barasimuku, baki narri milidimbawarrmuku yuwanyi, ngayu karungka narrinya ngirukanyi jangkurranyi. Narri balkimuku. Narri jujambawarrmuku. Dabaja narrinya Kudwanyi. Narri ngayangayijbangka kudiyayngka bayakardanyi yuwanyi Kudkanyi, narri wajbaja Kud bijalanyi mamanyi jala narri jardiykunumba, ngala miku narrimi ngayangayijba nanankanyi jirriyngkanyi yuwanyi. Miku narrimi jungku yurlurrmba yalungi yingkamukuyngka. Miku narrimi yabimba kunyba yaji yalungi. Miku narrimi ngindu muwa yalungi jala yalu balkijba muwa. Miku narrimi kuyu nanda jangkurr nangangi Kudkanyi. Marda narrimi ngayangayijba nanankanyi jirriyngkanyi yuwanyi Kudkanyi, baki yuwajiwa janarri ngayangayijba nanankanyi bayakardanyi yuwanyi marda. ");
INSERT INTO wrk_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Narri barrinani nanda kabuji jala wililijba nanda yingka kabuji. Baki yingkanyi barri jangayu muningka karu narrinya. Narri barrinani nanda nganinyi jali dulaba kunima nanganbunanyi nyanyalunanyi waluwa nyuli ngaraba nyanyalu. Ngala nyuli yurlwa warrkinyi jali banjarrba nyanyaluna, baki bilyinyba nyuli nanda warrki nganinyiwanyi. Baki nani barri narri marda. Narri ngayangayijba nanankanyi bayakardanyi yuwanyi nanganginkanyi Kudkanyi, ngala narri yurlwa nanganginkanyi jirriyngkanyi yuwanyi. Barriwa. ");
INSERT INTO wrk_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","Narri Barasimuku, baki narri milidimbawarrmuku yuwanyi, ngayu karungka narrinya ngirukanyi jangkurranyi. Narri balkimuku. Narri jujambawarrmuku. Dabaja narrinya Kudwanyi. Narringka wakardaba mankanyi dulaykanyi jamba, barrinani yanybaka yuwa wakardaykanyi narringka mankanyi. Narri dulaba nanda jamba mankanyinanyi, baki narri jungku likalika mankanyi, ngala miku narrimi dulaba nanda balki yaji narringinbunanyi kurdulunanyi. Miku narrimi ngayangayijba nanankanyi yuwanyi, jungunkanyi jirdi kunybanyi kurdulunyi nangangi Kudkanyi. Yuwajiwa narri jungku jirdi balkinyi kurdulunyi. Narri ngayangayijbangka nanankanyi yuwanyi waykanyi Kud yajinyi, ngala yuwajiwa narri kuliwijba yajinyi marda. Narri jarijbangka yalunginkanyi yajinyi, narri kuyungka bayngkani dungala yalunbunanyi. Baki narri dalburrijba kaja yaji narringinmirra yaji. Nani barri narri kuliwijba yajinyi. ");
INSERT INTO wrk_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Narri barrinani nanda kabujimuku. Miku narringkimi jingkijba, narri jungunkanyi balki nangangi Kudkanyi. Marda narrimi waluku janyba nanda balki narringinbunanyi kurdulunanyi. Marda narrimi jungku kunyba nangangi Kudkanyi yurrngumba barri, baki janarri jungku likalika nangangi Kudkanyi. Barriwa. ");
INSERT INTO wrk_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","28","Narri Barasimuku, baki narri milidimbawarrmuku yuwanyi, ngayu karungka narrinya ngirukanyi jangkurranyi. Narri balkimuku. Narri jujambawarrmuku. Dabaja narrinya Kudwanyi. Narri barrinani kumayangu jala yalu makaba kuyuwana. Yalu laduba nanda kumayangu wilina, baki kunymamba nanda yaji yalu naykanyi. Kunyba nanda yaji wilina, ngala kalawuyngkurru barri balki yaji ngujbul. Nani barri narri jungkuka. Wakardaba narringka mankanyi, baki narri jungku kunyba mankanyi, ngala yuwajiwa narri balki kalawuyngkurru. Yuwajiwa narri jungkuka balki kurdulu nangangi Kudkanyi. Barriwa. ");
INSERT INTO wrk_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","32","Narri Barasimuku, baki narri milidimbawarrmuku yuwanyi, ngayu karungka narrinya ngirukanyi jangkurranyi. Narri balkimuku. Narri jujambawarrmuku. Dabaja narrinya Kudwanyi. Yingkamuku wankalamuku yali yanyba jangkurr nangangi Kudkanyi, ngala yingkamukunyi, miku yaliyanyi kuyu yalungi jangkurr. Ngala yalunjali daba, yalunjali kurdanba. Baki yali makaba kuyuwana kumayanguna. Baki narri lalanbaka nanda kumayanguna. Narri warlwarlmbaka nanda yaji yurrngumba barri. Narri yanybaka nayi barri, ‘Nanamuku wankalamuku, jali kurdanba yalunya, yalu balkimuku. Jaliyanyi nurru jungku nanamanji, baki miku nurriyanyi kurdanba yalunya. Miku.’ Nani narri yanybaka. Ngala nanamuku wankalamuku, yalu barrinani wankalanyi nijanganjinyimuku narringi, baki narri jungkuka barrinani yalu jungkuyi. Narri nulijbangka kurdanbikanyi nganarri. Narri nulijbangka kurdanbikanyi nganarri, yanybangangi ngayu jangkurr nangangi Kudkanyi. Narri jardibirri muwa. Yuwajiwa janarri yurlwa ngakinkanyi jangkurranyi. Janganarri kurdanba, barrinani narringinmukunyi wankalamukunyi yalunjali kurdanba nanamuku jali yanyba jangkurr nangangi Kudkanyi. ");
INSERT INTO wrk_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Narri balkimuku. Narri barrinani bijbawarr miya jala nangka ngadijba karnbana, jala yukumbaka biykanyi yingka. Narri yukumbaka linjumbikanyi yalunya. Ngala miku narringkiyi ngadijba nanganbunanyi Kudnanyi. Janyulu wakaramba narrinya. Janyulu manjijba narrinya wayka Yilyurri. ");
INSERT INTO wrk_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Ngayu karungka narrinya. Baku barri jangayu manjijba yalunya yingkamuku narrindurri. Jangayu manjijba yalunya yanybawarr jangkurranyi Kudkanyi, baki yalunya milidimbawarr, baki yalunya jirdi kunybanyi kulajinyi. Jangayu manjijba yalunya narrindurri, ngala miku janarri kuyu yalungi jangkurr, ngala janarri yabimba balki yaji yalungi marda. Yingkamuku janarri kurdanba yalunya. Yingkamuku janarri langandaba yalunya wabangkarra kurndana. Yingkamuku janarri wajuba yalunya jurjina, janarri jakajba yingkananyi barrawuyabarrawuyananyi, baki yingkananyi barrawuyabarrawuyananyi. Nani janarri yabimba balki yaji yalungi marda. ");
INSERT INTO wrk_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","36","Baki nanankardi barri janyulu daba narrinya Kudwanyi. Bukambiju narrinya jala narri kurdanba nanganginmuku nganinyimuku Kudkanyi, jali yalu jungku kunyba nangangi, janyulu daba narrinya Kudwanyi. Nanda lirrka jali yalu kurdanba, nyuli nanda kunyba nganinyi, niji Yabil. Baki kajamuku yalunjali kurdanba bayngkani nangandu. Baki nanda yingka yali kurdanba, niji nangangi Sakaraya, nyulu jandanyi nangangi Birakiyanyi. Kurdanba yali nanda nganinyi kalawuyngkurru walkurranyina jurjina, wilina dungalana, niji Yalda. Yi. Kajamuku narri kurdanba yalunya, ngala janyulu daba narrinya Kudwanyi. Janyulu kurdanba bukambiju narrinya Jumuku, jala narri kurdanba nanamuku kunybamuku nganinyimuku. Janyulu kurdanba narrinya Kudwanyi.” Barriwa. Nani barri kudanyu ngirrwayi Jisus yalungi Barasimukuyngka baki milidimbawarrayngka. ");
INSERT INTO wrk_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Baki nginduyi Jisus muwa yalungi jali yalu jungku nananyina barrawuyabarrawuyana Kudkanyi, niji Jirusalim. Kudanyu nyuli ngindu muwa yalungi, baki yanyba nyuli, “Narri Jumuku, kudanyu ngayu nginduka muwa narringi. Narri kurdanbayi yalunya jali manjijba Kudwanyi karunkanyi nanganginkanyi jangkurranyi. Narri kurdanbayi yalunya, ngala ngayu nulijbangka lalanbikanyi narrinya. Yurrngumba ngayu nulijbangka lalanbikanyi narrinya, barrinani lalanbaka nanganginmuku bulungumuku julakiwanyi, barrinani bulungumuku jungkuka mardarda kala jaluna. ");
INSERT INTO wrk_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Nani barri ngayu nulijbangka lalanbikanyi narrinya marda. Ngala narri yurlwangka ngaki, baki nanankardi narringi walkurra jurj, janyulu manimani. Mikuyaji yalungi jungunkanyi nanaba muramukuyngka yurrngumba barri. ");
INSERT INTO wrk_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Ngayu karungka narrinya, barlba jangayu yurrngumba barri. Miku nganarriyi najba mili barri. Ngala baku barri juju, jalija narri kuyu ngaki jangkurr, ngawamba nanamanji barri janganarri mili najba. Baku barri juju jalija narri yanyba nangangi Kudkanyi ngaki, ‘Nurru ngajakangka Kud, nyulu lalanbiji nanda jali nyulu manjijba. Nurru ngajakangka Kud, nyulu yabimbiji kunyba yaji nangangi.’ Ngawamba nanamanji barri janganarri mili najba.” Barriwa. Nani barri nginduyi Jisus muwa yalungi, jali yalu jungku nanaba Jirusalim. Barriwa. ");
INSERT INTO wrk_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Baki walajbayi Jisus walkurrananyi jurjnanyi. Jali nyulu walajba, baki badajba yali nanganginmuku kandimuku nangandurri. Yanyba yali nangangi nanankanyi jurjkanyi, walkurra nanda jurj, kunyba barrawu, baki ngiruka marda dungalana. ");
INSERT INTO wrk_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Ngala yanybayi Jisus yalungi, “Yi. Nayinda jurj walkurra, ngala ngayu karungka narrinya, dalyawijbaja nayinda jurj bukamba barri. Baki jarrbalijbaja bukamba dungala. Miku yingka dungala yundu nangandu yingkana. Jarrbalijbaja bukamba dungala.” Barriwa. ");
INSERT INTO wrk_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Baki jilajbayi Jisus karri, baki kirrijba nyuli kulawirana niji Yulib. Badajba yali kandimuku nangangi nangandurri, baki karda yali yanyba nangangi. Ngajaka yali Jisus, “Karukiyi nurrunya, wanyimbala dalyawijbaja nanda walkurra jurj. Wanyimbala. Baki yanka janurru jingkijba jalija ninji wijba, jalija bukamba nangka nayinda yaji. Karukiyi nurrunya, wanyimbaja yaji nanamanji, baki janurru jingkijba, winyurruwa janinji wijba. Karukiyi nurrunya nanankanyi yajinyi.” Barriwa. ");
INSERT INTO wrk_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Baki jananganjayi yalunya Jisuswanyi, “Marda narringkimi lalanbawa, baki marda narrimi miku munyajba yingka jujambikanyi narrinya. ");
INSERT INTO wrk_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Nanamanji barri jayalu badajba nanamuku jujambawarrmuku. Waluku yingka baki bayngkani yingka, baki yingka, baki yingka. Jayalu yanyba, ‘Ngayu Krayis, nanda jali manjijba Kudwanyi.’ Nani barri jayalunjalu jujamba. ");
INSERT INTO wrk_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Nanamanji barri janarri manku yaji yalungi yingkamukuyngka, jayalungka daba. Janarri manku yaji yalungi, jayalungka daba, yingkamuku bundu narringinyina yajina, ngala yingkamuku juju. Ngala marda narrimi miku marrala. Marda narrimi miku marrala jalija narri manku yaji, yalungka daykurri. Bunjulijba jayalungka daykanyi, ngala jilijbawa bukambaja yaji Kudwanyi. ");
INSERT INTO wrk_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Ngayu karungka narrinya. Jayalungka daba. Yalu jala jungku yingkana yajina, baki yingkana yajina, jayalungka daba ngurranyimuku. Baki nanamanji barri mikuwali jardijba nanda mama kajana yajina, baki jayalu birrkalanyi jungku, mikuyaji mamanyi. Baki kulbaja jamba marda. Kudanyu barri kulbaja kudukudu jamba, bundu baki juju barri. ");
INSERT INTO wrk_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Bukamba nayinda kiji badajbaja waluwa, baki bayngkani barri mili kiji badajbaja, walkurra kiji. Barriwa. ");
INSERT INTO wrk_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","Nanamanji barri jayalu marrimba narrinya, baki janarrinya kuyu nangandurri mambukarri kurdusnyina, nyulu dabanki narrinya. Janyulu jirrinyba yalunya, yalu kurdanbiji narrinya. Bukambijunyi jayalu ngirra narrinya, durrijbangangi narri ngaki jangkurr. ");
INSERT INTO wrk_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Kajamuku jalija kuyu ngaki jangkurr, jayalu karrinja walu nangandu mambukana kurdusnyina, baki janyulu yabimba kiji yalungi. Ngala warriyaluku barri, kajamuku jayalungka yangkalamba ngakinbunanyi. Jayalu yingijba ngaki jangkurr. Yalu jala yalu waluku jungku malumba kandimuku, jayalungka ngirra. Yingkawanyi janyulu karu mambuka kurduskanyi nanganginkanyi kandinyi, baki jayalu marrimba nanda nangangi kandi dabanki. ");
INSERT INTO wrk_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Badajbaja yingkamuku jujambawarrmuku, baki jayalunjalu jujamba kajamuku jala durrijba ngaki jangkurr. ");
INSERT INTO wrk_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Walkurrambaja nanda kiji baki nanankardi barri miku jayalungka mili maruka muwa. Miku yaliyi jingkijba wanyi yalungi mungkijimuku, ngala jayalungka jakakajba. ");
INSERT INTO wrk_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Ngala nanamuku jalija yalungka miku yangkalamba ngakinbunanyi, jalija yalu jungku ngiruka ngaki yurrngumba barri, janyulu marrimba yalunya mardarda Kudwanyi. Jayalu jungku mili wanka nangandu kingkarri. ");
INSERT INTO wrk_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Ngala waluku barri kajamukunyi jayalunjalu karu kunybanyi jangkurranyi Kudkanyi. Jayalunjalu karu nangangi Kudkanyi, janyulu lalanba yalunya jala yalu kuyu nangangi jangkurr. Waluku barri jayalunjalu karu bukambiju wandijiyana nangangi, baki bayngkani barri bukambaja yaji Kudwanyi. Barriwa. ");
INSERT INTO wrk_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","Yingka wankala jali yanyba jangkurr nangangi Kudkanyi, niji nangangi Danyil. Karu nyuli yalunya yingkanyi jalija badajba baku barri juju. Janyulu balkimirra. Janyulu yabimba kaja balki yaji yalungi. Ngayu karungka narrinya, badajbaja nanda balkimirra. Janyulu ngirra Kud. Janyulu karrinja nanaba malaba yajina, baki janyulu balkimba nanda yaji.” Narri jala narri najba nanda jangkurr nangangi Danyilkanyi najana, marda narrimi jingkijba nangangi jangkurr nanankanyi balkinyi jalija nyulu badajba nangankurri. ");
INSERT INTO wrk_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","“Jalija nyulu badajba, baki nanamuku jalija yalu jungku nananyina walkurranyina yajina Judiya, baki marda yalimi wirlku nanganbunanyi. Marda yalimi wirlku juju nanganbunanyi kulawirarri yajiyurri. ");
INSERT INTO wrk_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Nanamanji barri jalija nyulu badajba, baki kudiya jayalu jungku danbina jambana. Marda yalimi miku ngankijba barrawuna wudumbiji yalungi yaji. Ngala marda yalimi yinarramba wirlku kulawirarri. ");
INSERT INTO wrk_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Kudiya jayalu waki munjimunji. Marda yalimi miku wijba barndarri wudumbiji yalungi jumbala. Ngala marda yalimi yinarramba wirlku kulawirarri. ");
INSERT INTO wrk_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Kudiya jibarrimuku, jayalu ngawukuku. Kudiya ngardanganjamuku jayalu ngamulujba bardarda yalungi. Ngala warriyaluku. Miku yaliyi wirlku dulu. Jayalunjalu daba burrandiwa. ");
INSERT INTO wrk_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Marda narrimi yanyba mududu nangangi Kudkanyi. Marda narrimi ngajaka Kud, ‘Mikujiyi munyajba nanda balkimirra badaykanyi Sadidi, jala marda nurrimi wuyalijba Jumuku. Baki mikujiyi munyajba badaykanyi wurarawala, jala madujba yaji kudanyu barri.’ Nani barri marda narrimi ngajaka Kud. ");
INSERT INTO wrk_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Wabula barri kamambarra yabimbayi yaji Kudwanyi. Nanamunanyi yurrngumba nanginkurri mikuyaji walkurrayngka kijinyi barrinani nayinda kiji jalija badajba, jalija marda narrimi wirlku kulawirarri. Baki bayngkani barri miku mili walkurra kiji barrinani nayinda kiji. ");
INSERT INTO wrk_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Ngala kurrkunbaja nanda kiji Kudwanyi. Jalimi miku nyulu kurrkunba kiji, baki bukambiju jayalungka janyba nanankanyi kijinyi. Ngala janyulu kurrkunba nanda kiji, marukangangi nyulu muwa nanganginmukuyngka jali nyulu wabula yarrijba nanganginmirra. Barriwa. ");
INSERT INTO wrk_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Nanamanji barri jalija badajba nanda balkimirra, nanda jalija ngirra Kud, yingka janyulu yanyba, ‘Najbakiyi nayinda, nyulu Krayis jali manjijba Kudwanyi,’ ngala yingka janyulu yanyba yingkanyi, nyulu nanda Krayis. Ngala marda narrimi yurlwa yalunginkanyi jangkurranyi. ");
INSERT INTO wrk_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Badajbaja jujambawarrmuku baki jayalu yanyba jujambawarr jangkurr. Yingka yanybaja, ‘Ngayu Krayis,’ ngala yingka yanybaja, ‘Ngayu Krayis.’ Yingka yanybaja, ‘Manjijba ngani Kudwanyi karunki nangangi jangkurr,’ ngala yingka yanybaja, ‘Ngala manjijba ngani Kudwanyi karunki nangangi jangkurr.’ Jayalu nulijba jujambikanyi yalunya, jali yarrijba nanganginmirra Kudwanyi. Jayalu yabimba ngiruka yaji jujambiji yalunya, ngala miku jayalunjalu jujamba. ");
INSERT INTO wrk_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Ngala marda narrimi najbawa yalunya. Ngayu karungka narrinya nanginkanyi yajinyi waluwa barri, baki jalija yalu badajba nanamuku jujambawarrmuku, baki janarri jingkijba yalunya, baki miku narriyi kuyu yalungi jangkurr. ");
INSERT INTO wrk_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Jaliyi yingkawanyi karuja narrinya, ‘Nyulu jungkuka nanaba karru mangkurruna yajina nanda Krayis,’ baki miku narriyi barlba nanankurri. Jaliyi yingkawanyi karuja narrinya, ‘Nangka ngadijbangka bundu nayiba,’ baki miku narrimi kuyu nangangi jangkurr. Jujamba yalu yanyba. ");
INSERT INTO wrk_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Ngayu karungka narrinya, jalija ngayu badajba Buwanya Bukambijuyngka, baki jangayu badajba dulu, barrinani ngajarrwanyi jala bumbaju yaji karrina bayungu. Nani jangayu badajba dulu. ");
INSERT INTO wrk_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Jala nangka janyba mankanyi, baki badajba bukaji. Badajbaja kaja bukaji jarrji yaji. Baki nani barri jalija walkurramirra nanda kiji, baki nanamanji barri jangayu badajba marda. ");
INSERT INTO wrk_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","Nanankardi walkurrananyi kijiwunyi barri, baki mikuyaji kambanyi, mikuyaji yakarlanyi. Mikuwali yajba yaji kambawanyi baki yakarlwanyi. Jayalu yirrba warrawiji kingkarrinya. Jayalu karrala wayka. Ngirringirrimba jayalungka kamba baki yakarl, baki warrawiji. Ngirringirrimba jayalungka, baki jayalu wirlku yingkarri yajiyurri. ");
INSERT INTO wrk_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Baki nanamanji barri ngayu Buwanya Bukambijuyngka, jangayu wijba, baki janganjalu najba lalijina. Janganjalu najba badaykurri ngaluna bukambijunyi. Baki jangayu walkurra mambuka yalungi. Baki bukambiju wandijiyana jala yalu jungku balki nangangi Kudkanyi, jayalungka ngindu muwa. Kudanyu jayalungka ngindu muwa, jalija ngayu wijba. ");
INSERT INTO wrk_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Jayalu manku yaji barrinani jala ngurrwangka yaji kudanyu barri, baki manjijbaja Yanjilmuku Kudwanyi. Janyulu manjijba nanganginmuku Yanjilmuku langki baki karri, kula baki bayungu lukuluku wandijiyana. Baki jayalunjalu wudumba nanganginmirra Kudkanyi, baki kuyuja yalunya nangandurri Kudyurri.” Barriwa. ");
INSERT INTO wrk_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","Mili yanybayi Jisus yalungi, “Mankumanku narringka nanankanyi kabulanyi. Jala narri najba kabula jal, baki narri jingkijbangka, barringa barri ngardarawala. Barringa barri ngardarawala, jala walajba kabula jal. ");
INSERT INTO wrk_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Baki nani barri, jalija narri najba nayinda walkurra kiji, baki janganarri jingkijba, jangayu wijba jambarri. Janganarri jingkijba, ngayu Buwanya Bukambijuyngka, jangayu wijba jambarri winyurruwa barri. ");
INSERT INTO wrk_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Marda narrimi mankumankuwa nayinda ngaki jangkurr. Ngakinmuku mungkijimuku, Jumuku, miku yaliyi bukamba, waluwa badajbaja nayinda walkurra kiji. Kudiyamuku ngakinmuku mungkijimuku jayalu yuwajiwa jungku, jalija badajba nayinda kiji. ");
INSERT INTO wrk_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Baku barri janyulu manjamanjamba laliji baki jamba Kudwanyi. Janyulu manjamanjamba yalunya. Ngala ngaki jangkurr barri, mikuwali manjamanjamba ngaki jangkurr yingkawanyi. Duja ngaki jangkurr jungkuka yurrngumba barri. Barriwa. ");
INSERT INTO wrk_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","Ngala miku ngambalimi jingkijba wanyimbala badajbaja nanda walkurra kiji. Baki miku ngambalimi jingkijba, wanyimbala jangayu wijba jambarri. Nanamukunyi Yanjilmukunyi jala yalu waki nangangi Kudkanyi, miku yalimi jingkijba. Baki ngayu barri Buwanya Bukambijuyngka, miku ngayimi jingkijba. Ngala ngawamba Buwakayu Kingkarri, ngawamba nyulu jingkijbangka, wanyimbala badajbaja nanda walkurra kiji. Ngawamba nyulu jingkijbangka wanyimbala jangayu marda wijba. ");
INSERT INTO wrk_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Wabula kamambarra, manjijbayi walkurra mali Kudwanyi, baki makabayi bukamba yaji walkurranyi maliwanyi. Nanamanji barri yingka wankala, niji nangangi Nuwa, nyuli jungku kunyba nangangi Kudkanyi. Baki nanankardi barri marrimbayi Nuwa mardarda Kudwanyi. Marrimba nyuli Nuwa mardarda, baki nangangi maninganja, baki nanganginmuku jandanyimuku nganinyimuku, baki yalinginmuku maninganjamuku. Marrimbayi bukambiju yalunya mardarda Kudwanyi, jungkungangi Nuwa kunyba nangangi Kudkanyi. ");
INSERT INTO wrk_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Ngala bukambiju yalu yingkamuku, yali jungku balki nangangi Kudkanyi. Yurlwa yali nangangi Kudkanyi, ngala muningka yalungka mankumankuyi yalunginkanyi yajinyi. Jarrba yali yaji, baki ngaraba yali, baki jamalu yalungki, ngala miku yalungkiya mankumanku nangangi Kudkanyi. Miku yaliyanyi kuyu nanda jangkurr nangangi Kudkanyi, jali karu yalunya Nuwawanyi. Nani barri yali jungku yurrngumba barri, nanankurri jali ngankijba Nuwa muwardana kalawuyngkurru. ");
INSERT INTO wrk_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Ngala jali manjijba mali Kudwanyi, baki jingkijba yali nanda jangkurr jali karu yalunya Nuwawanyi, nanda duja jangkurr. Ngurrunbayi yalunya bukambiju maliwanyi. Barriwa. Baki nani marda jalija ngayu wijba Buwanya Bukambijuyngka. Nanamanji jayalu jungku nani marda. Miku jayalu kuyu nangangi jangkurr Kudkanyi, miku jayalungka birrirrinja jilaykanyi ngakindurri. Ngawamba kujajarra jayalu jungku kunyba nangangi Kudkanyi, jayalungka birrirrinja jilaykanyi ngakindurri. ");
INSERT INTO wrk_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Nanamanji barri jalija ngayu wijba, yiningki kujarra nganinyiwuya, jabula malumba waki. Kuyuja yingka ngakindurri Yanjilwanyi, ngala janyulu yingijba nanda yingka wambu barri. ");
INSERT INTO wrk_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Yiningki kujarra jibarriwuya, jabula wuyala mama. Kuyuja yingka ngakindurri Yanjilwanyi, ngala janyulu yingijba nanda yingka jibarri wambu barri. ");
INSERT INTO wrk_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Marda narringkimi birrirrinja jilaykanyi ngakindurri. Miku narrimi jingkijba wanyimbala jangayu wijba Buwanya Bukambijuyngka. Nanankardi barri marda narringkimi birrirrinja yurrngumba jilaykanyi ngakindurri. Barriwa.” ");
INSERT INTO wrk_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Mili yanybayi Jisus yalungi. Muningka nyuli yanyba, “Yiningki badajbayi maninjaku nganyindurri barndarri mungana. Miku ninjiyanyi jingkijba badaykanyi nyulu, baki maninjakujba nyuli nganyi yaji mungana. Ngala jaliyanyi ninji jingkijba, wanyimbala nyuluja badajba nanda maninjaku, baki nganyingkiyanyi birrirrinja nangangi. Ninjiyanyi jungku yamininyi mungana yukumbikanyi nanankanyi maninjakunyi, baki miku nyuliyi maninjakujba yaji. ");
INSERT INTO wrk_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Baki nani barri miku nganarri jingkijba Buwanya Bukambijuyngka. Miku narrimi jingkijba wanyimbala jangayu wijba nanginkurri. Marda narringkimi miku mankumanku, ‘Jilijbawa janyulu wijba. Jilijbawa. Miku nyuliyi badajba winyurru. Yiningki janyulu badajba baku barri ngardarawala.’ Marda narringkimi miku mankumanku nani barri, mikungangi narrimi jingkijba wanyimbala jangayu badajba. Yiningki winyurruwa, yiningki baku barri. Ngala marda narringkimi birrirrinja yurrngumba ngaki jilaykanyi ngakindurri jalija ngayu wijba. Barriwa.” ");
INSERT INTO wrk_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Mili barri yanybayi Jisus yalungi. Muningka nyuli yanyba yalungi, “Yingka mambuka nyuli barlba nanganbunanyi barndananyi. Barlba nyuli yingkarri yajiyurri, baki jungku nyuli nanaba yurrngumba. Waluwa nyuli barlba, baki yarrijba nyuli yingka wakiwarr nangangi lalanbikanyi nangangi jamba baki nanganginmuku yingkamuku wakiwarrmuku, waykanyi yalunya mamanyi. Janyulu yarrijba kunyba wakiwarr, jirdi kunybanyi kulajinyi lalanbikanyi nangangi yaji. ");
INSERT INTO wrk_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Baku barri jalija nyulu wijba nanda mambuka, baki janyulu mirnarrijba muwa nanankanyi lalanbawarrayngka jali nyulu yarrijba. Baki nanda lalanbawarr janyulu marda mirnarrijba muwa, jungkungangi nyuli kunyba nanganginkanyi mambukanyi. Kudanyu nyuli lalanba nanda yaji mambukanyi, marda nanganginmuku wakiwarrmuku. ");
INSERT INTO wrk_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Baki nanangini mambukawanyi, janyulu yarrijba nanda kunyba lalanbawarr mambuka bayngkani nangandu, lalanbikanyi nanganginkanyi yajinyi junu. Janyulu lalanba nangangi jamba baki bulukimuku baki wakiwarrmuku yurrngumba barri, nyulungangi kunyba kulaji baki kunyba lalanbawarr barri. ");
INSERT INTO wrk_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Ngala jaliyi miku kunyba nanda lalanbawarr, jali yarrijba mambukawanyi lalanbikanyi nangangi yaji. Jaliyi nyulu balki nganinyi, baki yiningki janangka yanyba, ‘Ngaki mambuka, janyulu jungku nananyina yajina yurrngumba barri. Miku nyuliyi wijba dulu.’ ");
INSERT INTO wrk_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","Baki miku janyulu lalanba yalunya wakiwarrmuku kudanyu barri. Miku janyulu wajba yalunya mamanyi, ngala janyulu daba yalunya. Janyulu kandimba yingkamuku balkimuku. Jayalu malumba jungku, baki jayalungka wardamba mamanyi, jayalu ngaraba kamukamu. ");
INSERT INTO wrk_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","51","Ngala baku barri janyulu wijba nanda mambuka nanganginkurri barndarri. Janyulu wijba nanamanji jalimi miku jingkijba nanda balki lalanbawarr. Baki janyulu najba nanda lalanbawarr wayawayambikurri nangka kulaji. Ngala nanganginmuku wakiwarrmuku jungku yalu birrkalanyi. Janyulu najba nanda balki yaji jali yabimba nanangini lalanbawarranyi, baki janyulu ngarrangarra muwa nangangi. Janyulu kudanyu ngarrangarra muwa nangangi, baki janyulu daba nanda balki lalanbawarr baki janyulu janyba nanganbunanyi barndananyi. Baki janangka ngindu muwa nanda balki lalanbawarr, janyulu waka kudanyu barri. Barriwa.” Nani barri muningka yanybayi Jisus yalungi karunki yalunya yajinyi. Marda yalimi jungku barrinani nanda kunyba lalanbawarr jirdi kunybanyi kulajinyi. Waki nyuli kudanyu barri, baki nani nangki birrirrinja nanganginkanyi mambukanyi jali nyulu wijba. Nanankardi barri yabimbayi kunyba yaji nangangi mambukawanyi. Ngala nanda balki lalanbawarr miku nangkiyanyi birrirrinja nanankanyi mambukanyi jali nyulu wijba. Baki nani barri marda jalija wijba Jisus. Nanamuku kunybamuku, janyulu yabimba kunyba yaji yalungi, jayalu jungku mili wanka kingkarri barri. Ngala nanamuku balkimuku, janyulu yabimba balki yaji yalungi, janyulu janyba yalunya jangurri Yilyurri jalija nyulu wijba.” Barriwa. ");
INSERT INTO wrk_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","5","Mili barri yanybayi Jisus yalungi, “Mili jangayu karu narrinya nanankanyi jangkurranyi jala lalanba narrinya Kudwanyi. Mili barri jangayu muningka yanyba narringi. Jamalu bulangki, baki kamu barri mungana yali yabimba wangarr bulangi barrawuna. Walajbayi kaja wurrumbarramuku wangarranyi 10 barri. Walajba yali, ngala jilijbawa wanbiyaja nanda buyingkinyi nawinganja. Badajbaja nyulu jujunanyi. Baki jilajba yali wurrumbarramuku yubalina madamadambiji yalungka. Nani barri yalili yabimba yaji Jumukunyi, jalili bulangka jamalu. Wudumba yali mirnbi. Kaja mirnbi yali wudumba. Yingkamuku wurrumbarramuku, 5 barri, yali kunyba kulaji. Bunyarrijba yali yalungi mirnbi kunguyudinyi waluwa yali jilajba, baki kuyu yali mili kungu yalundu bayayawana bujilina. Ngala nanamuku yingkamuku wurrumbarramuku, yali mudumuku. Miku yaliyanyi kuyu mili kungu yalundu. Baki jilajba yali juju bijal, baki yukumba yali nanankanyi nanganginkanyi nawinganjanyi. Yukumba yali nangangi, bak kuluka yali. Barriwa. ");
INSERT INTO wrk_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Burrandi mungana barri, kayayi yingka yalungi wurrumbarramukuyngka, ‘Nyulu badajbangka nanda buyingkinyi nawinganja. Jangambala jilajba nangandurri, madamadambiji ngambalaka.’ ");
INSERT INTO wrk_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Walajba yali wurrumbarramuku baki kunymambayi yalungi mirnbi, waluwa jayalu jilajba nangandurri. ");
INSERT INTO wrk_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Ngala nanamuku mudumuku wurrumbarramuku, mikuyaji mili kungunyi yarriykanyi mirnbina. Ngajaka yalunjali yingkamuku, ‘Janarri wajba nurrunya kudiyayngka narringinkanyi kungunyi, baki janurru marda jilajba mirnbiyudi.’ ");
INSERT INTO wrk_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Ngala jananganja yalunjali mudumuku, ‘Miku nurriyi wajba narrinya kungunyi. Ngawamba bayakarda nayi kungu nurrungi, miku kaja. Janarri wijba, mili wudumbiji narrinyi kungu dungalana.’ ");
INSERT INTO wrk_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Baki wijba yali wudumbiji mili kungu. Ngala jala yalu yuwajiwa wudumbawa yaji, ngala wanbiyayi nanda buyingkinyi nawinganja nangangi. Baki nanamuku kunybamuku wurrumbarramuku jali yalu mili kuyu kungu yalundu, yalungki birrirrinja, baki yali jilajba nangandu barrawurri wangarranyi. Wanbiya yali, baki ngankijba yali barrawuna, baki murumbayi bardawa yingkawanyi baki kijijbayi kudanyu barri. ");
INSERT INTO wrk_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Kamu barri nanamuku yingkamuku wurrumbarramuku yali wanbiya barrawuna, ngala murumbayi nanda bardawa. Baki kaya yali nangangi nawinganjanyi, ‘Dulabakiyi nayinda bardawa. Dulabakiyi, baki janurru ngankijba.’ ");
INSERT INTO wrk_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Ngala jananganjayi nawinganjawanyi, ‘Miku ngayiyi dulaba. Miku ngayimi jingkijba narrinya. Miku.’” Barriwa. Nani barri muningka yanybayi Jisus yalungi. ");
INSERT INTO wrk_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Baki mili yanybayi Jisus yalungi, “Nanamuku wurrumbarramuku jirdi kunybanyi kulajinyi, yalungki birrirrinja jilaykanyi nangandu buyingkinyina nawinganjana jali nyuli badajba. Baki nani barri marda narringkimi birrirrinja jilaykanyi ngakindu jalija ngayu badajba. Barriwa.” ");
INSERT INTO wrk_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Mili barri yanybayi Jisus yalungi, “Mili jangayu karu narrinya nanankanyi jangkurranyi, jala lalanba narrinya Kudwanyi. Mili barri jangayu muningka yanyba narringi. Yingka mambuka nyuli barlba nanganbunanyi yajinanyi. Nyuli barlba yingkarri yajiyurri, baki jungkuyi nanaba yajina. Ngala waluku barri, waluwa nyuli barlba, baki yanyba nyuli yalungi murrkuyngka wakiwarrayngka nanganginkanyi. Karu nyuli yalunya, jayalu lalanba nangangi dungala ngala janyulu jungku nananyina yingkana yajina. ");
INSERT INTO wrk_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Baki wajba nyuli yalunya wakiwarrmuku nanganginkanyi dungalanyi. Yingka wakiwarr, nyuli kunybamirra kulaji, baki nyuli wajba nanda wakiwarr kajanyi dungalanyi, 5,000 dulanyi. Yingka wakiwarr, nyuli kunyba kulaji, baki nyuli wajba nanda wakiwarr kajanyi dungalanyi, 2,000 dulanyi. Ngala yingka wakiwarr, nyuli kunyba bijal kulaji, baki nyuli wajba nanda wakiwarr kudiyanyi dungalanyi 1,000 dulanyi. Nani nyuli wajba yalunya dungalanyi lalanbikanyi nangangi, baki barlba nyuli. ");
INSERT INTO wrk_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Nanda wakiwarr jirdi kunybanyimirra kulajinyi nangangi, nyuli kuyu nanda kaja dungala 5,000 dula, baki nyulu wudumba kaja yaji nananyina dungalana. Baku barri nyuli wajba yingkamuku nanankanyi yajinyi, baki wudumba nyuli kaja mili dungala 10,000 dula. Nani barri nyuli yabimba nanangini wakiwarranyi jirdi kunybanyimirra kulajinyi nangangi. Nani nyuli walkurramba nanda dungala jali wajba mambukawanyi, nyulu lalanbikanyi. Barriwa. ");
INSERT INTO wrk_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Baki nanda wakiwarr jirdi kunybanyi kulajinyi, nyuli kuyu nanda 2,000 dula, baki nyuli yabimba nanamannga yaji. Wudumba nyuli kaja yaji nananyina dungalana, baki baku barri nyuli wajba yingkamuku nanankanyi yajinyi dungalanyi, baki wudumba nyuli 4,000 dula. Nani nyuli walkurramba nanda dungala jali wajba mambukawanyi. Barriwa. ");
INSERT INTO wrk_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Ngala nanda yingka wakiwarr jali bijal kunyba kulaji, barlba nyuli, baki ngadijba nyuli nanda 1,000 dula jali wajba mambukawanyi. Kurrijba nyuli lawarr jambana, yarrijba nyuli nanda dungala wayka lawarrina, baki makaba nyuli yaji. Barriwa. ");
INSERT INTO wrk_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","Baku barri juju wijbayi nanda mambuka nanganginkurri yajiyurri. Wijba nyuli, baki manjijba nyuli yingka wudumbiji nanganginmuku wakiwarrmuku. Baki badajba yali nanamuku murrku wakiwarrmuku, jali wajba yalunya dungalanyi lalanbikanyi mambukawanyi. Jilajba yali nangandurri mambukarri. ");
INSERT INTO wrk_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Waluku barri walajbayi nanda wakiwarr jali wajba mambukawanyi 5,000 dulanyi, baki nyuli yanyba, ‘Mambuka. Nganinji wajbayi 5,000 dulanyi, baki ngayi walkurramba nanda dungala. Nanijba nyulu 10,000 dula. Ninga wajbangka bukamba nanginkanyi kajanyi dungalanyi.’ Barriwa. ");
INSERT INTO wrk_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Baki jananganjayi mambukawanyi, ‘Ninji kunyba wakiwarr. Ninji kunyba kulaji. Waki ninji kudanyu barri ngaki, baki nanankardi janinga yarrijba mambuka bayngkani ngakindu lalanbikanyi kaja ngaki yaji. Ngankijbakiyi ngakinkurri barrawurri. Jungkukiyi ngakindu, baki janungkala mirnarrijba muwa.’ Nani barri nyuli jananganja nanda wakiwarr. Barriwa. ");
INSERT INTO wrk_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Bayngkani barri walajbayi nanda wakiwarr jali wajba mambukawanyi 2,000 dulanyi, baki yanyba nyuli, ‘Mambuka. Nganinji wajbayi 2,000 dulanyi, baki ngayi walkurramba nanda dungala. Nanijba barri nyulu 4,000 dula. Ninga wajbangka bukamba nanginkanyi kajanyi dungalanyi.’ Barriwa. ");
INSERT INTO wrk_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Baki jananganjayi mambukawanyi, ‘Ninji kunyba wakiwarr. Ninji kunyba kulaji. Waki ninji kudanyu barri ngaki, baki nanankardi janinga yarrijba mambuka bayngkani ngakindu lalanbikanyi kaja ngaki yaji. Ngankijbakiyi ngakinkurri barrawurri. Jungkukiyi ngakindu, baki janungkala mirnarrijba muwa.’ Nani barri nyuli jananganja nanda wakiwarr. Barriwa. ");
INSERT INTO wrk_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Bayngkani barri walajbayi nanda wakiwarr, jali wajba mambukawanyi 1,000 dulanyi, baki yanyba nyuli, ‘Mambuka. Ninga jingkijbangka ninji jardibirri muwa. Miku ninjimi waki wudumbikanyi dungala. Ngala ninji wudumbaka yingkamuku, yalu wakinkanyi kudanyu nganyi, baki nanankardi ninji wudumbaka kaja dungala, wakingangi yalu kudanyu nganyi nganyinmuku wakiwarrmuku. ");
INSERT INTO wrk_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Baki marrala ngayu nganyi. Miku ngayiyanyi nulijba mamanumbikanyi nanda dungala jali nganinji wajba lalanbikanyi nganyi. Marrala ngayi mamanumbikanyi nanda dungala nganyi, baki ngadijba ngayi nanda dungala. Makaba ngayi wayka jambana. Nayiba nanda dungala, nanda 1,000 dula jali nganinji wajba wabula. Nayiba nanamannga dula.’ Barriwa. ");
INSERT INTO wrk_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Ngala ngirrwayi mambuka nangangi, ‘Ninji barri balki. Ninji bunmalijba. Wanyingkanyi ninji ngadijba nanda dungala jambana. Nganinji jingkijba, ngayu wudumbaka dungala, wakingangi narri kudanyu ngaki. ");
INSERT INTO wrk_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Baki nanankardi barri marda ninjiyanyi yabimba yaji barrinani nanankujarranyi, bula yabimbayi yaji. Marda ninjiyanyi walkurramba nanda dungala ngaki. Marda ninjiyanyi yarrijba nanda 1,000 dula najana. Baki baku barri ninjiyanyi dulaba najananyi, baki ninjiyanyi wudumba 1,000 dula baki bijal mili. Marda ninjiyanyi yarrijba dungala najana nani. Miku ninji kunyba wakiwarr. Ninji balkimirra.’ Nani barri ngirrwayi mambuka nangangi. ");
INSERT INTO wrk_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Baki karu nyuli yingka wakiwarr nangandu, ‘Kuyukiyi nayinda dungala nanganbunanyi. Wajbakiyi nanda jali wudumba mijimbangu dungala ngaki, 10,000 dula. Nyulu kunyba wakiwarr. Wajbakiyi nanginkanyi dungalanyi. ");
INSERT INTO wrk_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","30","Ngala kuyukiyi nayinda balki wakiwarr ngakinbunanyi. Janybakiyi nanankurri danbiyurri jala mungijba yaji. Nanaba janangka ngindu muwa kudanyu barri. Nanda jala jungku jirdi kajanyi yajinyi, janyulu wudumba mili yaji, baki nyulu jungkuja kajamukuyngka yajinyi jirdi. Ngala nanda jala jungku jirdi bayayawayngka yajinyi, janyulu mamanumba nanda bayayawa yaji. Yingkawanyi kuyuja yaji nanganbunanyi, baki janyulu jungku mikuyaji yajinyi.’ Nani barri yanybayi mambuka yalungi. Janarri jingkijba nanda jangkurr. Kud, nyulu barrinani nanda mambuka. Jaliyi ngambala waki kudanyu nangangi Kudkanyi, baki janyulu wajba ngambalanya kajanyi yajinyi. Janyulu yabimba kunyba yaji ngambalangi. Ngala jaliyi ngambala miku kudanyu waki nangangi, baki miku janyulu wajba ngambalanya yajinyi. Miku janyulu yabimba kunyba yaji ngambalangi. Barriwa.” ");
INSERT INTO wrk_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Mili barri yanybayi Jisus yalungi, “Baku barri ngayu Buwanya Bukambijuyngka, jangayu wijba nanginkurri, baki jangayu wirimalaru nanamanji barri. Jangayu wijba nanginkurri, baki yalu Yanjilmuku, jayalu marda wijba ngakindu. Jangayu wijba, baki jangayu wirimalaru yalungi bukambijuyngka. ");
INSERT INTO wrk_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Nanamukunyi Yanjilmukunyi jayalunjalu kuyu bukambiju ngakindurri. Nganinyimuku baki jibarrimuku, bukambiju wandijiyana, jayalunjalu kuyu ngakindurri, baki jangayu nyalinyalimba yalunya. Jangayu nyalinyalimba yalunya, barrinani yalili nyalinyalimba bulukimuku. ");
INSERT INTO wrk_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Nanamuku barri, jala yalu maruka muwa nangangi Kudkanyi, jala yalu jungku yurlurrmba nanganginkanyi yuwanyi, jangayu manjijba yalunya nanankurri karriya yajiyurri. Ngala nanamuku jala miku yalimi maruka muwa nangangi Kudkanyi, jala yalu miku jungku yurlurrmba nanganginkanyi yuwanyi, jangayu manjijba yalunya nanankurri bayinga yajiyurri. ");
INSERT INTO wrk_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Baki ngayu wirimalaru, jangayu yanyba yalungi, nanamukuyngka karriya ngakindu, ‘Kabukawa. Janarri jungku kingkarri nangandu Kudnyina yurrngumba barri. Narri jungkuyi yurlurrmba nangangi Kudkanyi, baki Buwakanya Kud nyulu mirnarrijbangka muwa narringi. Wabula kamambarra, waluwa yabimbayi yaji Kudwanyi, waluwa nyuli yabimba laliji baki jamba, nanamanji barri mankumanku nangki Kud, janyulu kuyu narrinya nanganginkurri yajiyurri, narri jungunkanyi nangandu yurrngumba. Nani barri mankumanku nangki Kud wabula. Baki nanijba nyulu yabimbaka nanda yaji. Janarri jungku nangandu kingkarri yurrngumba barri lalijina. ");
INSERT INTO wrk_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Jangayu manjijba narrinya nangandurri, jungkungangi narri kunyba ngaki. Jali ngayu birrkalijba, baki nganarri wajbayi mamanyi. Jali ngayu warinjijba, baki nganarri wajbayi wabudanyi. Jali ngayu ngurranyi narringi, baki nganarri kandimbayi, nganarri kuyuyi narringinkurri barndarri. ");
INSERT INTO wrk_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Jali ngayu mikuyaji jumbalanyi, baki nganarri wajbayi jumbalanyi. Jali ngayu lunji, baki nganarri lalanbayi. Jali ngayu jungku brisinyina, baki nganarri yidadambayi barri.’ Barriwa. Nani jangayu yanyba yalungi nanamukuyngka karriya jali yalu jungku yurlurrmba nangangi Kudkanyi. ");
INSERT INTO wrk_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Ngala janganjalu yililikajba, ‘Ngala Mambuka. Wanyimbala ninji birrkalijbayi, wanyimbala, baki ninya nurru wajba mamanyi. Wanyimbala ninji warinjijbayi, baki ninya nurru wajba wabudanyi. ");
INSERT INTO wrk_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Wanyimbala ninji jungkuyi barrinani ngurranyi nurrungi, baki ninya nurru kandimba. Wanyimbala ninji jungkuyi mikuyaji jumbalanyi, baki ninya nurru wajba jumbalanyi. ");
INSERT INTO wrk_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Wanyimbala ninji lunjiyi, baki ninya nurru lalanba. Wanyimbala ninji jungkuyi brisinyina, baki ninya nurru yidadamba. Miku ninjiyanyi jungku nani. Miku ninya nurriyanyi lalanba nani barri. Miku nurriyi jingkijba nganyi jangkurr.’ Nani barri janganjalu yililikajba. ");
INSERT INTO wrk_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Baki jangayu jananganja yalunya nayi barri, ‘Ngayu wirimalaru. Ngayu karungka narrinya. Jali narri lalanba yalunya nanamuku bayakardamuku, baki nanda barrinani jali nganarri lalanba, yalungangi bababanyamba ngayu yalunya. Jali narri wajba nanda bayakarda mamanyi ngala nyuli birrkalijba, baki nanda barrinani jali nganarri wajba mamanyi. Jali narri wajba nanda bayakarda wabudanyi ngala nyuli warinjijba, baki nanda barrinani jali nganarri wajba wabudanyi. Nani barri nganarri lalanbayi, jali narri ngindu muwa yalungi, jali narri lalanba yalunya bayakardamuku. Baki nanankardi barri ngayu mirnarrijbangka muwa narringi. Barriwa janarri jungku kingkarri nangandu Kudnyina.’ Nani barri jangayu yanyba yalungi karriya. ");
INSERT INTO wrk_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","Ngala nanamuku jalija yalu jungku bayinga ngakindu, jangayu yanyba yalungi, ‘Narri balkimuku. Barriwa janarri barlba juju ngakinbunanyi. Yanybaka Kud narringi, janarri jungku kurdan yurrngumba. Ngayu manjijbangka narrinya wayka Yilyurri, jala yajbangka walkurra jangu yurrngumba barri. Nanaba jayalu jungku marda, nanda mambuka wuwarranyi, nanda Sayidin, baki nanganginmuku balkimuku Yanjilmuku. Ngayu manjijbangka yalunya janguyurri, baki jayalu jungku nanaba janguna yurrngumba, baki janarri marda jungku yalundu janguna. ");
INSERT INTO wrk_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Ngayu manjijbangka narrinya janguyurri, mikungangi narriyanyi jungku kunyba ngaki, mikungangi nganarriyanyi lalanba. Jali ngayu birrkalijba, baki miku nganarriyanyi wajba mamanyi. Jali ngayu warinjijba, baki miku nganarriyanyi wajba wabudanyi. ");
INSERT INTO wrk_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Jali ngayu ngurranyi narringi, baki miku nganarriyanyi kandimba. Jali ngayu mikuyaji jumbalanyi, baki miku nganarriyanyi wajba jumbalanyi. Jali ngayu lunji, baki miku nganarriyanyi lalanba. Jali ngayu jungku brisinyina, baki miku nganarriyanyi yidadamba. Nanankardi barri jangayu manjijba narrinya jangurri. Barriwa.’ Nani barri jangayu yanyba yalungi. ");
INSERT INTO wrk_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Ngala nanamukunyi balkimukunyi, jayalu yililikajba ngana, ‘Ngala mambuka. Ngala wanyimbala ninji birrkalijbayi. Ngala wanyimbala ninji warinjijbayi. Ngala wanyimbala ninji jungku ngurranyi nurrungi. Ngala wanyimbala ninji jungkuyi mikuyaji jumbalanyi. Ngala wanyimbala ninji lunjiyi. Ngala wanyimbala ninji jungkuyi brisinyina. Wanyimbala ninji jungkuyi nani, nurru lalanbikanyi ninya. Miku ninya nurriyanyi najba jungunkanyi nani.’ Nani barri janganjalu yililikajba. ");
INSERT INTO wrk_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Baki jangayu jananganja yalunya, ‘Ngayu wirimalaru. Ngayu karungka narrinya, narri najbayi nanamuku bayakardamuku jungunkanyi nani, ngala miku narriyanyi ngindu muwa yalungi, miku narriyanyi lalanba yalunya. Ngala narri yurlwayi yalungi. Baki nanda barrinani narri yurlwayi ngaki, yalungangi bababanyamba ngayu yalunya.” ");
INSERT INTO wrk_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Nani barri jangayu jananganja yalunya, nanamuku balkimuku. Baki jangayu manjijba yalunya wayka Yilyurri, yalu jungunkanyi nanaba yurrngumba. Ngala nanamuku kunybamuku, jangayu manjijba yalunya kingkarri nangandurri Kudyurri, baki nanaba jayalu jungku mili wanka nangandu yurrngumba barri. Barriwa.” Nani yanybayi Jisus yalungi milidimbikanyi yalunya. Barriwa. ");
INSERT INTO wrk_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Jali bukamba milidimbayi yalunya nanginkanyi jangkurranyi Jisuswanyi, baki mili nyuli yanyba yalungi, nanganginmukuyngka kandimukuyngka, ");
INSERT INTO wrk_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Narri jingkijbangka, baku barri yingkana munganawa jayalu yabimba nanda wangarr, niji Kangandijba Barndana Yajinyi, jalili yalu jarrba nanda bulungu nangangi jibkanyi, baki damba ngala nyulu mikuyaji bululunyi. Jayalu yabimba nanda wangarr yingkana munganawa, baki nanamanji barri, janganjalu wudumba, Buwanya Bukambijuyngka. Janganjalu wudumba. Janganjalu langandaba wabangkarra kurndana kurdanbiji ngana.” Nani nyuli yanyba yalungi. Barriwa. ");
INSERT INTO wrk_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Ngala mambukamuku jurjkanyi baki malbumalbumuku, malumba yali jungku yanybikanyi yalungki nangangi Jisuskanyi. Malumba yali jungku nanganginyina barrawuna Kayabaskanyi, jali walkurra mambuka jurjkanyi. ");
INSERT INTO wrk_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Yanyba yalungki yanka jayalu kardarda marrimba Jisus, baki jayalu kurdanba Jisus. Miku yaliyanyi nulijba yalungi muramukuyngka jingkiykanyi jalija yalu marrimba Jisus. ");
INSERT INTO wrk_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Yanyba yalungki, “Jangambala marrimba Jisus baki jangambala kurdanba, ngala miku nanamanji jalija ngambala jungku nanginkanyi wangarranyi. Kajamuku yalu badajbangka nanginkurri nanginkanyi wangarranyi, baki yalungka yanyba nangangi Jisuskanyi, nyulu nanda jali manjijba Kudwanyi. Jayalu yabimba kiji ngambalangi jaliyi ngambala marrimba Jisus wangarrina. Jayalu yabimba walkurra kiji ngambalangi.” Barriwa. Nani yalungki yanyba marrimbikanyi Jisus kardarda barri. ");
INSERT INTO wrk_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Barlbayi Jisus karri nanankurri bayakardarri barrawuyabarrawuyarri niji Bidani, baki ngankijba nyuli barrawuna. Nanda nangangi barrawu Sayiminkanyi. Nanda nganinyi Sayimin, wabula nyulili ngujbulijba waban bukamba, ngala nanijba kunybijbayi barri. Jungkuyi Jisus baki nanganginmuku kandimuku nangandu, baki wardamba yalungki mamanyi. ");
INSERT INTO wrk_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Ngala yalungki wardamba mamanyi, baki ngankijbayi jibarri kalawuyngkurru barrawuna. Kuyu nyuli bujili nangandu marnina. Kalawunyi bujilina nanda yaji barrinani jirrki, ngala nanjananja. Banjawayi kunyba kudu. Nanamanji barri yalili yarrijba nanda yaji kuyuwanana Jumukunyi waluwa yalili makaba mankanyi nangangi jambana. Wajbayi kajanyi dungalanyi jibarriwanyi, baki wudumba nyuli nanda barrinani jirrki. Jilajba nyuli nangandurri Jisusyurri, baki bindabayi nanda barrinani jirrki nangandu kulajina Jisusnyina. ");
INSERT INTO wrk_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","9","Najba yali yaji kandimukunyi. Najba yali jibarri bindabankurri nanda barrinani jirrki nangandu kulajina, baki yali ngarrangarra muwa nangangi. Yanyba yalungki, “Nayinda jibarri, nyulu balki. Wanyingkanyi nyuli bindaba nanda yaji nangandu kulajina. Jaliyanyi nanda nurrungi, baki nurriyanyi wajba yalunya nanankanyi wudumbiji kaja dungala. Baki nurriyanyi wajba yalunya nanankanyi dungalanyi, yalunya jala mikuyaji yalungi dungalanyi.” ");
INSERT INTO wrk_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Ngala jingkijbayi Jisus nanda jali yalungka yanyba, baki yanyba nyuli yalungi, “Wijbakiyi jurlwa nanankanyi jibarrinyi. Yabimba nyuli kunybamirra yaji ngaki. ");
INSERT INTO wrk_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Jawuda nanda jala mikuyaji yalungi dungalanyi, yurrngumba yalu jungkuka narrindu. Yurrngumba yuku narri lalanba yalunya jala mikuyaji dungalanyi yalungi. Ngala miku ngayiyi ngayu jungku nayiba narrindu yurrngumba. Miku janarri jurlwa nangangi. ");
INSERT INTO wrk_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Bindaba nyuli nanda barrinani jirrki ngakinyina mankanyina, baki nanankardi birrirrinja ngaka mankanyi makaykanyi nganjalu jambana. ");
INSERT INTO wrk_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Ngayu karungka narrinya duja jangkurranyi. Baku barri juju jayalunjalu karu ngakinkanyi kunybanyi jangkurranyi. Yurrngumba jayalunjalu karu wandijiyana. Jalija yalunjalu karu ngaki, baki jayalunjalu karu nanginkanyi jibarrinyi marda. Jayalunjalu karu nanginkanyi yajinyi jali nyulu yabimba ngaki. Baki jayalu marda jingkijba nayinda jibarri, nyulu kunyba marda ngaki.” Barriwa. ");
INSERT INTO wrk_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Yingka kandi nangangi Jisuskanyi, niji Judas Yiskariyud, nyuli jilajba yalundurri, walkurrayngkurri mambukarri jurjkanyi. ");
INSERT INTO wrk_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","Ngajaka nyuli yalunya, “Yankanu dungala janganarri wajba, jaliyi ngayu kuyu narrinya nangandurri Jisusyurri, narrija marrimbiji Jisus.” Yanyba yali nangangi, “Janinya nurru wayba 30 dulanyi, jaliyi ninji kuyu nurrunya nangandurri.” Baki wajba yali Judas nanankanyi dungalanyi. Barriwa. ");
INSERT INTO wrk_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Nanankardi barri nanangini Judaswanyi nyuliyanyi kuyu yalunya mambukamuku jurjkanyi nangandurri Jisusyurri, yalu marrimbiji Jisus. Yurrngumba nangki mankumanku yanka janyulu kuyu yalunya nangandurri. Barriwa. ");
INSERT INTO wrk_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Jali waluwinyi nanda wangarr yalungi niji Kangandijba Barndana Yajinyi, baki jilajba yali kandimuku nangandurri Jisusyurri. Baki yilikajba yali, “Wanjawa yajina janurru yarrijba nayinda yaji kamunyi wangarranyi. Wanjawa yajina janurru yarrijba mama barri.” ");
INSERT INTO wrk_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Yanybayi Jisus kujarrayngka yalungi. Nyuli karu bulanya, jabula jilajba yingkarri kandiyurri nangangi Jisuskanyi. Yanyba nyuli, “Jalija nimbala wanbiya nangandu, baki janimbala yanyba nayinda jangkurr nangangi, ‘Nanda Milidimbawarr nurrungi, nyulu yanybaka, barringa barri bukamba nyulu wakinkanyi nayiba jambana. Nyulu baki nanganginmukunyi kandimukunyi, janurru jarrba nayinda wangarr kamu nganyinyina barrawuna.’ Nani barri janimbala yanyba nangangi, baki janimbala yarrijba yaji wangarranyi nanganginyina barrawuna.” Barriwa. ");
INSERT INTO wrk_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Baki jilajba buli nanankurri nganinyiyurri. Karu buli nanankanyi jangkurranyi Jisuskanyi, baki jilajba buli nangandu nanganginkurri barrawurri. Baki nanaba buli yundijba mama kamunyi wangarranyi niji Kangandijba Barndana Yajinyi. Barriwa. ");
INSERT INTO wrk_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Ngala nyuli mungimungijba yaji, baki badajba yali karrina, Jisus baki nanganginmuku kandimuku. Jilajba yali nanankurri barrawurri baki jungku yali wangarranyi. ");
INSERT INTO wrk_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Ngala yali jarrba yaji, baki yanybayi Jisus yalungi, “Ngayu karungka narrinya, yingamali narringi janangka yangkalamba ngakinbunanyi. Janyulu karu yingkamuku wanjawa janganjalu wudumba. Baki janganjalu marrimba.” Barriwa. ");
INSERT INTO wrk_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Jali manku nanda jangkurr kandimukunyi, baki ngindu yali muwa. Yanyba yali nangangi, yingka, baki yingka, baki yingka, “Mambuka. Miku kuna ngayu nanda. Miku ngayiyi ngayu karu yalunya nganyi.” Nani yalili yanyba nangangi. ");
INSERT INTO wrk_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Jananganjayi yalunya Jisuswanyi, “Yingamali jala jarrbangka mama ngakindu, janangka yangkalamba ngakinbunanyi. Janyulu karu yalunya ngaki. ");
INSERT INTO wrk_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Ngayu Buwanya Bukambijuyngka, jangaka janyba. Nanangini najawanyi Kudkanyi karungka yalunya ngaki, jangaka janyba. Ngala nanda nganinyi jalija yalunya wajba ngaki, janangka ngindu muwa. Janangka ngindu muwa kudanyu barri. Jaliyanyi nangki miku binandaba, baki yuku janyulu kunyba yaji nangangi.” Barriwa. ");
INSERT INTO wrk_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Baki nanda Judas, jali wujina wudumba dungala yalunbunanyi, nyulu marda yanybayi nangangi Jisuskanyi, “Milidimbawarr. Miku kuna ngayu nanda. Miku jangayu karu mambuka nganyi. Miku barri.” Ngala kardarda barri jananganjayi Judas Jisuswanyi, “Ninji barri nayi. Ninji.” Barriwa. ");
INSERT INTO wrk_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Ngala yalungki wardamba mamanyi, baki wudumbayi kudiya damba Jisuswanyi. Marrimba nyuli nanda damba, baki yanyba nyuli mududu nangangi Kudkanyi nanankanyi dambanyi. Dalyamba nyuli damba baki wawajba nyuli yalunya bijalanyi dambanyi. Yanyba nyuli yalungi, “Kuyu narri nayinda damba. Janarri jarrba. Nayinda damba barrinani ngaki mankanyi.” Barriwa. ");
INSERT INTO wrk_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Baki nyuli wudumba yukururu jirdi ngarrkinyi krayibkanyi. Yanyba nyuli mududu nangangi Kudkanyi nanankanyi ngarrkinyi, baki wawajba nyuli yalunya ngarrkinyi. Yanyba nyuli yalungi, “Ngaraba narri bukambijunyi nayinda ngarrki. ");
INSERT INTO wrk_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Nayinda ngarrki barrinani ngaki ngulya. Bukambijunyi yalu barimbaka yaji. Baki marda yalungkimi janyba yalunginkanyi balkinyi yajinyi jalili yalu yabimba. Ngala jangaka ngaka janyba yalungi. Jalija yalu kuyu ngaki jangkurr, baki jayalu wankijba, janybangangi jangaka yalungi. Nani barri ngaki ngulya barlbangka kajamukuyngka. Nani barri jangayu yabimba, nanankanyingangi jangkurranyi jali yanyba Kud, miku yangkalambikanyi. ");
INSERT INTO wrk_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Ngayu karungka narrinya, miku ngayiyi mili ngaraba ngarrki krayibkanyi nayiba jambana. Ngala baku barri jalija ngayu wankijba mili, jalija ngayu jungku kingkarri nangandu Kudnyina, nanamanji barri jalija ngambalaka malumba jungku, baki jangayu mili ngaraba ngarrki krayibkanyi narrindu. Barriwa.” ");
INSERT INTO wrk_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Brijba yali wangarr, baki barriwa yali walajba barndananyi. Barlba yali karrurrinybarri kulawirarri niji Yulib ngala nyulu mungijba yaji. ");
INSERT INTO wrk_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Ngala yali jilajba, baki yanybayi Jisus yalungi, “Kamu barri ngala nyulu yuwajiwa mungana yaji, baki janarri wirlku ngakinbunanyi. Janganarri yingijba nyubana jungunkurri. Nanda naja Kudkanyi yanybaka nayi barri, ‘Jalija nyulu daba nanda lalanbawarr jibkanyi Kudwanyi, jalija nyulu kurdanba, baki jayalu jarrbalijba jibmuku.’ Nanda jangkurr yanybaka ngaki. Jalija ngananjalu daba, baki janarri wirlku ngakinbunanyi. ");
INSERT INTO wrk_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Ngala baku barri jalija ngayu mili wankijba, baki jangayu jilajba langki nanankurri yajiyurri Kaliliyurri. Jangayu jilajba langki nanankurri waluwa narringi.” Barriwa. ");
INSERT INTO wrk_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Yanybayi Bida nangangi Jisuskanyi, “Jaliyi nanginmuku yalu wirlku nganyinbunanyi, ngala miku ngayiyi. Miku ningiyi yingijba nyubana. Miku.” ");
INSERT INTO wrk_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Ngala yanybayi Jisus nangangi Bidanyi, “Ngayu karungka ninga. Bukambiju janarri wirlku ngakinbunanyi, baki mili yaji janinji yabimba ngaki. Janinji karu yalunya yingkamuku, miku nganinjimi jingkijba. Kujarraka barndayka janinji karu yalunya, miku nganinjimi jingkijba, waluwa kayaja nanda julaki barrinani dalmurra. Waluwa nyulu kayaja kamu ngala nyulu kambalingijba yaji.” ");
INSERT INTO wrk_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Ngala jananganjayi Jisus Bidawanyi, “Miku ngayiyi karu yalunya nani nganyi. Miku. Jaliyi nganjalu kurdanba, baki miku ninyiyi yingijba nyubana. Miku ngayiyi yanyba yalungi, miku ninyimi jingkijba. Duja ngayu yanyba.” Nani barri nyuli jananganja Jisus. Baki nanamuku yingkamuku kandimuku, yali marda yanyba nanamannga jangkurr nangangi. Barriwa. ");
INSERT INTO wrk_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Mili barri yali jilajba Jisus baki nanganginmuku kandimuku, baki wanbiya yali nananyina yajina munjimunji, niji Kidsamani. Yanybayi Jisus yalungi, “Janarri jungku nayiba, ngala jangayu jilajba bijal bundu. Jangayu yanyba mududu nangangi Kudkanyi.” Barriwa. ");
INSERT INTO wrk_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Kuyu nyuli murrku nanganginmuku kandimuku nangandu, Bida, baki jandanyiwuya nangangi Sibidikanyi, niji bulangi Jayims baki Jun. Jilajba yali bijal bundu nangandu Jisusnyina. Ngala Jisus barri kudanyu nangki ngindu nangangi muwa. ");
INSERT INTO wrk_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Yanyba nyuli yalungi murrkuyngka, “Nginduka ngaka muwa. Kudanyu ngaka nginduka muwa. Jungku janarri nayiba, baki najbawa janarri yaji ngaki.” ");
INSERT INTO wrk_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Mili jilajbayi Jisus bijal bundu yalunbunanyi, baki kulujarrijba nangki wayka jambana wali wayka. Baki yanyba nyuli mududu, “Buwakanya. Winyurruwa jayalu jilajba wudumbiji ngana. Nulijba yalu kurdanbikanyi nganjalu. Ngala ninga ngayu jingkijba, yuku ninji yabimba bukamba yaji. Janinji kuna wudumba nayi kiji ngakinbunanyi. Ngala jaliyi ninji miku wudumba nayi kiji ngakinbunanyi, baki yuku barri. Jangayu yabimba nanda jala ninji nulijba ngaki yabimbikanyi.” Nani barri yanybayi Jisus mududu baki barriwa barri. ");
INSERT INTO wrk_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Wijbayi Jisus yalundurri murrkuyngkurri, baki najbayi yalunya kulukankurri. Dulabayi yalunya Jisuswanyi, baki yanyba nyuli nangangi Bidanyi, “Wanyingkanyi narri kuluka, jali narrinya ngajaka, najbawankanyi yaji ngakindu. Wanyingkanyi narri miku najbawa bijal ngakindu. ");
INSERT INTO wrk_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Janarri najbawa ngakindu, baki janarri yanyba mududu nangangi Kudkanyi. Marda narrimi ngajaka Kud, nyulu yabimbiji narrinya ngiruka nangangi barri. Nulijba narri najbawankanyi yaji ngakindu, ngala narri ngunjarra, baki narri kuluka. Nulijba narri yabimbikanyi kunyba yaji, ngala miku narrimi ngiruka yabimbikanyi kunyba yaji. Ngala Sayidin nyulu ngiruka. Nyulu nulijbangka jujambikanyi narrinya, narri yabimbikanyi balki yaji. Nanankardi barri marda narrimi ngajaka Kud, nyulu yabimbiji narrinya ngiruka nangangi.” Barriwa. ");
INSERT INTO wrk_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Mili barri jilajbayi Jisus bijal bundu yalunbunanyi, baki mili nyuli yanyba mududu nangangi Kudkanyi, “Buwakanya. Jaliyi ninji miku wudumba nayi kiji ngakinbunanyi, baki yuku barri. Jangayu yabimba nanda yaji jala ninji nulijba ngaki yabimbikanyi.” Nani barri yanybayi Jisus mududu, baki barriwa barri. ");
INSERT INTO wrk_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Mili nyuli wijba yalundurri, baki najbayi yalunya kulukankurri. Miku yalungkiyanyi kurrkunba kulukankanyi. ");
INSERT INTO wrk_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Baki mili barri nyuli barlba bijal bundu yalunbunanyi. Mili nyuli yanyba mududu nangangi Kudkanyi. Yanyba nyuli nanamannga jangkurr nangangi. Nani barri yanybayi Jisus mududu, baki barriwa barri. ");
INSERT INTO wrk_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Baki mili nyuli wijba yalundurri. Walajba yali jali nyulu yanyba yalungi. Yanyba nyuli, “Yuwajiwa kuna narri kuluka. Walajba narri. Nanijba barri nanamuku balkimuku, yalu badajbangka wudumbiji ngana, marrimbiji ngana Buwanya Bukambijuyngka. ");
INSERT INTO wrk_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Janarri walajba. Jangambala jilajba. Nayinda nyulu badajbangka, nanda jali nangka yangkalamba ngakinbunanyi. Nyulu kuyungka yalunya ngakindurri, yalu marrimbiji ngana.” Barriwa. ");
INSERT INTO wrk_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Ngala yuwajiwa yanybayi Jisus yalungi, baki wanbiyayi nanda yingka kandi Judas, baki kajamuku yalu nangandu. Yingkamukunyi yali kuyu wunanybala jankunbijinyi, yingkamukunyi yali kuyu kuduru. Manjijbayi yalunya mambukamukunyi jurjkanyi, baki malbumalbuwanyi, yalu marrimbiji Jisus. ");
INSERT INTO wrk_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Waluwa yanybayi nanda balki kandi Judas yalungi, “Nanda jalija ngayu jawunja, nyulu nanda jala narri kujba nangangi. Nanda barri janarri marrimba.” Nani barri nyuli yanyba yalungi waluwa barri. ");
INSERT INTO wrk_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Wanbiya yali, baki yinarramba jilajbayi Judas nangandurri Jisusyurri, yanybayi nangangi, “Nanama ninji Milidimbawarr”, baki jawunja nyuli Jisus. ");
INSERT INTO wrk_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Yanybayi Jisus nangangi, “Kandi. Dulukiyi yabimba nanda yaji nganyi.” Baki bunundujba yali nangandurri, baki marrimba yali Jisus. ");
INSERT INTO wrk_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Ngala yingka nanaba, kandi nangangi Jisuskanyi, nyuli karrinja nanaba jankunbijinyiyudi wunanybalanjudi. Dulaba nyuli kingkarri nangangi jankunbijinyi, baki jinamba nangki. Karlba nyuli kuwarda jankunbijinyiyudinyi, barriwa barri bukamba. Karlba nyuli nangangi kuwarda, nanda jalili waki nangangi mambukanyi jurjkanyi. ");
INSERT INTO wrk_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Ngala jirrinybayi nanda kandi Jisuswanyi, “Wiykunumbakiyi nanda jankunbijinyi. Yarrijbakiyi kalawuyngkurru. Marda ninjimi miku dulu daba yalunya jankunbijinyiyudinyi, ngala waluku barri marda ninjimi ngajaka Kud, ninji daykanyi yaji. Jaliyanyi ngayu nulijba nganyi daykanyi yalunya, baki ningiyanyi karu. ");
INSERT INTO wrk_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Jaliyanyi ngayu nulijba dulaykanyi ngaka yalunbunanyi, baki yuku ngayiyanyi ngajaka ngaki Buwakanya Kingkarri. Yuku ngayiyanyi ngakaja, nyulu manjiykanyi kajamuku Yanjilmuku dabawarrmuku ngakindurri, baki yalunjaliyanyi daba wakara barri nanginmuku. ");
INSERT INTO wrk_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","56","Ngala miku. Miku ngayiyanyi ngajaka ngaki Buwakanya nani. Nanamuku wankalamuku jali yalu yanyba jangkurr nangangi Kudkanyi, yali yarrijba nanda jangkurr najana Kudkanyi. Nanda naja yanybaka ngaki, janganjalu marrimba, janganjalu linjumba. Jaliyanyi manjijba Kudwanyi Yanjilmuku daji yalunya, baki miku duja nanda jangkurr najana Kudkanyi. Ngala duja yalungi jangkurr. Ngayu yabimbaka nanda jala yalungi jangkurr yanybaka ngaki.” Barriwa. Baki yanybayi Jisus yalungi nanamukuyngka lukuluku, “Wanyingkanyi narri jilajba wudumbiji ngana jankunbijinyiyudi baki kuduruyudi barrinani narri jilajba wudumbiji nanda maninjaku jalija daba narrinya. Yingkana kambana baki yingkana kambana ngayi milidimba yalunya walkurranyina jurjina narrindu, ngala miku nganarriyanyi marrimba nanaba. Wanyingkanyi nanijba narri jilajba nanginjudi marrimbiji ngana.” Barriwa. Bukambiju kandimuku nangangi yali wirlku barri. Wirlku yali nanganbunanyi, marralangangi yali kudanyu barri. ");
INSERT INTO wrk_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Nanamukunyi jali yalu marrimba Jisus, kuyu yali Jisus barrawurri. Nanda nangangi barrawu, walkurrayngka mambukanyi jurjkanyi, niji nangangi Kayabas. Nanaba jungkuyi milidimbawarrmuku yuwanyi baki malbumalbumuku. Malumba yali jungku nananyina barrawuna, baki yukumba yali nangangi Jisuskanyi. Yali kuyu Jisus yalundurri. ");
INSERT INTO wrk_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Ngala durrijbayi yalunya Bidawanyi. Durrijba nyuli juju bijal bayngkani, baki ngankijba nyuli barrikina jali lukuluku nananyina barrawuna. Jungku nyuli yalundu yilarrmukunyina, nyulu naji yaji, wanyimba jayalu nangangi Jisuskanyi. ");
INSERT INTO wrk_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","60","Nanamuku walkurramuku mambukamuku jurjkanyi, baki nanamuku kunsilmuku, nulijba yali kurdanbikanyi Jisus. Kujba yali yingkamukuyngka, yalu karunkanyi jujambawarrayngka jangkurranyi nangangi Jisuskanyi, nanankanyi jali nyulu yabimba. Jala yingkamuku yalu yanyba jujambawarr jangkurr nangangi, baki nanamuku mambukamuku baki kunsilmuku, jayalu yanyba kurdanbikanyi Jisus. Nanankardi yali kujba yalungi jalija yalu yanyba jujambawarr jangkurr nangangi Jisuskanyi. Kajamukunyi yali yanyba jujambawarr jangkurr nangangi, ngala miku yaliyanyi yanyba balkinyi yajinyi jali yabimba Jisuswanyi. Miku yaliyanyi yanyba nanganginkanyi balkinyi yajinyi, yalu kurdanbikanyi Jisus. Kujba yalungki yingkamukuyngka. Ngajaka yali yingka, baki yingka, baki yingka. Baki kujarra nganinyiwuya buli jilajba yalundurri kunsilmukuyngkurri. ");
INSERT INTO wrk_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","Baki yanyba buli yalungi, “Nayinda nganinyi, wabula nyuli yanyba, ‘Yuku ngayu dalyamba nayinda walkurra jurj. Ngala baku barri, kujarraka barndayka, yuku jangayu mili yabimba yingka jurj.’ Nani nyuli yanyba wabula. Duja ngali karungka narrinya.” Barriwa. ");
INSERT INTO wrk_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Karrinjayi nanda walkurra mambuka jurjkanyi, baki ngajaka nyuli Jisus, “Ninji mankuyi bulangi jangkurr, ngala wanyingkanyi ninji miku jananganja bulanya nanankanyi jangkurranyi jali bula yanyba. Wanyingkanyi barri.” ");
INSERT INTO wrk_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Ngala miku nyuliyanyi jananganja nanda mambuka Jisuswanyi. Karda nyuli jungku. Baki mili ngajakayi Jisus walkurranyi mambukawanyi jurjkanyi, “Karukiyi nurrunya duja. Mankuka nganyi jangkurr Kudwanyi. Ninji kuna nanda Krayis jali manjijba Kudwanyi. Ninji kuna Jandanyi nangangi Kudkanyi. Karukiyi nurrunya duja jangkurranyi.” ");
INSERT INTO wrk_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Baki jananganjayi walkurra mambuka Jisuswanyi, “Yi. Ngayu Krayis. Ngala ngayu karungka narrinya. Janganarri najba Buwanya Bukambijuyngka. Janganarri najba jungunkurri kingkarri nangandu Kudnyina, baki badaykurri kingkarrinya lalijinanyi ngaluna. Nani barri janganarri najba.” ");
INSERT INTO wrk_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Jali manku nanda jangkurr mambukawanyi jurjkanyi, baki bakarramba nyuli nangangi jumbala. Nani yalili bakarramba yalungi jumbala Jumukunyi, jalili yingka yanyba balki jangkurr nangangi Kudkanyi. Bakarramba nyuli nangangi jumbala, baki kaya nyuli kudanyu barri, “Jujamba nyuli yalunya. Jujamba. Jujambawarr jangkurr nyuli yanyba ngambalangi nangangi Kudkanyi. Nyulu balkimirra. Mikujiyi kuyu mili karunkanyi ngambalanya nanganginkanyi balkinyi yajinyi. Ngambala mankuyi nangangi jangkurr. Barriwa nyulu balkimirra. ");
INSERT INTO wrk_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Wanyimba jangambala nangangi Jisuskanyi. Wanyimba.” Baki jananganja yali, “Marda nangkimi janyba. Yanyba nyuli balkimirra jangkurr nangangi Kudkanyi, baki nanankardi marda nangkimi janyba.” Barriwa. ");
INSERT INTO wrk_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Baki yali kiwumba wali Jisus yingkamukunyi, ngala yingkamukunyi yali daba Jisus marniyudinyi. Daba yali Jisus muwana marnina. ");
INSERT INTO wrk_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","Ngirrikimba yali Jisus, baki yali yanyba nangangi, “Jaliyi ninji dujanya Jandanyi nangangi Kudkanyi, baki karukiyi nurrunya, wanjangini ninya daba. Marda ninjimi jingkijba nanda jali ninya daba, jaliyi ninya manjijbayi Kudwanyi. Karukiyi nurrunya wanjani nanda nganinyi.” Barriwa. ");
INSERT INTO wrk_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Jungkuyi Bida barrikina muwana, lukuluku nananyina barrawuna. Jilajbayi nangandurri jibarri jalili waki nangangi mambukanyi jurjkanyi. Jilajba nyuli nangandurri Bidayurri, baki nyuli yanyba nangangi Bidanyi, “Ninya jingkijbangka, jungku ninji barri nangandu Jisusnyina, nangangi yaji Kalili. Ninji marda jungkuka nangandu.” ");
INSERT INTO wrk_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Ngala jujambayi nanda jibarri Bidawanyi. Yanyba nyuli, “Miku barri. Miku ngayimi jingkijba nanda nganinyi. Miku.” Nani barri yanybayi Bida nangangi, walu yalundu yingkamukunyina. ");
INSERT INTO wrk_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Baki barlbayi Bida bardawarri barrikina. Barriwa. Kamu barri najbayi Bida yingkawanyi jibarriwanyi wakiwarranyi. Yanyba nyuli yalungi nganinyimukuyngka jali yalu jungku nanaba nangandu. Yanyba nyuli yalungi, “Nanda nganinyi nyulili jungku nangandu Jisusnyina.” ");
INSERT INTO wrk_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Baki mili barri jujambayi Bidawanyi. Yanyba nyuli, “Ngayu karungka ninya. Miku ngayimi jingkijba nanda Jisus. Miku.” Barriwa. ");
INSERT INTO wrk_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Kamu barri yalu jali karrinja nanaba nangandu, yanyba yali nangangi Bidanyi, “Yi. Ninji barri kandi nangangi Jisuskanyi. Ninji nangangi kandi. Yanyba ninji barrinani nyulu yanybaka nanda jangkurr. Nanamannga jangkurr nimbala yanybaka. Nganyi yaji Kalili marda, barrinani nangangi yaji.” Barriwa. ");
INSERT INTO wrk_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Baki jananganjayi yalunya Bidawanyi. Jujamba nyuli yalunya. Yanyba nyuli balki jangkurr yalungi, “Ngayu karungka narrinya duja jangkurranyi. Ngayu ngajakangka Kud, nyulu dabanki ngana jaliyi miku duja nanda jangkurr. Miku ngayimi jingkijba nanda nganinyi. Miku.” Nani barri jananganjayi Bidawanyi, baki yinarramba kayayi nanda julaki barrinani dalmurra. Kaya nyuli barri. ");
INSERT INTO wrk_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Baki mankuwayi Bidawanyi nanda jangkurr jali yanyba Jisus nangangi barrin, “Kujarraka barndayka janinji karu yalunya, miku nganinjimi jingkijba, waluwa kayaja nanda julaki barrinani dalmurra.” Mankuwayi nanda jangkurr Bidawanyi, baki ngindu nangki muwa kudanyu barri. Barlba nyuli juju barri, baki ngindu nangki muwa. Kudanyu nangki ngindu muwa mirlarryudi. Barriwa. ");
INSERT INTO wrk_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Ngala nyulu kambalingijba yaji, baki yanyba yalungki walkurramuku mambukamuku jurjkanyi marda malbumalbumuku. Yanyba yalungki Jisuskanyi, yanka jayalu kurdanba Jisus. ");
INSERT INTO wrk_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Baki yali kijijba Jisus jaluwuya. Kijijba yali, baki kuyu yali Jisus nangandurri Biladyurri. Nanda Bilad, nyuli walkurra mambuka Kubaminkanyi nananyina yajina. ");
INSERT INTO wrk_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Ngala nanda Judas, jali kuyu yalunya Jisusyurri, jali nyulu jingkijba jayalu kurdanba Jisus, baki ngindu nyuli muwa. Kudanyu nyuli ngindu muwa nanankanyi jali nyulu yabimba, kuyunkanyi yalunya nangandurri Jisusyurri. Kudanyu nyuli ngindu muwa, baki wijba nyuli yalundurri mambukamukuyngkurri jurjkanyi baki malbumalburri. Wiykunumba nyuli nanda 30 dula, jali yalu waluwa wajba. Wiykunumba nyuli nanda dungala yalundurri. ");
INSERT INTO wrk_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Yanyba nyuli yalungi, “Ngayu balki. Yabimba ngayi balki yaji jali ngayu kuyu yalunya narringinmuku yilarrmuku wudumbiji Jisus. Nanankardi jayalu kurdanba Jisus, ngala nyulu kunyba nganinyi. Miku nyuliyanyi yabimba balki yaji. Miku. Ngala ngayu barri balkimirra.” Barriwa. Ngala jananganja yali Judas, “Miku nanda nurrungi yaji. Miku. Barriwakiyi barlba. Kuyukiyi nayinda dungala nurrunbunanyi.” ");
INSERT INTO wrk_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Baki janyba nyuli nanda 30 dula wayka jambarri Judaswanyi. Janyba nyuli nanda dungala jambarri kalawuyngkurru jurjyurri, baki barlba nyuli. Barlba nyuli, baki nangki langandaba kurndana. Langandaba nangki dukana kurndana kurulyudinyi, baki nani nangki janyba. Barriwa. ");
INSERT INTO wrk_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","7","Jala nyuli barlba jurjnanyi, baki wudumba yali nanda 30 dula. Wudumba yali nanda dungala, baki yanyba yalungki, “Wanyimba ngambalaja nanginkanyi dungalanyi. Wanyimbaja. Wajba ngambali nganinyi nanginkanyi dungalanyi nyulu yabimbiji balki yaji ngambalangi, ngambala kurdanbikanyi Jisus. Wanyimba jangambala nanginkanyi dungalanyi. Miku ngambaliyi yarrijba dungala darladarlana jurjkanyi. Marda ngambalimi wudumba jamba nanginyina dungalana. Marda ngambalimi wudumba jamba makaykanyi kuyuwana nanaba.” Nani barri yalungka yanybayi, baki wudumba yali jamba nananyina dungalana. Wudumba yali nangangi jamba, nanankanyi jalili mungkijbirri yabimbikanyi kulkarra, yukururu, baki bujili junu. Baki nanaba yalili makaba ngurranyimuku kuyuwana. ");
INSERT INTO wrk_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Baku barri, yingkamukunyi yalili nijarrijba nanda yaji, “Ngulyayudi Jamba.” Nani barri yalili nijarrijba nanda jamba, wudumbangangi yali nanda jamba nananyina balkina dungalana. ");
INSERT INTO wrk_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Yingka wankalanyi jali yanyba jangkurr nangangi Kudkanyi, niji nangangi Jirimaya. Yarrijba nyuli nayi jangkurr najana Kudkanyi, “Nanda 30 dula, jali yalu wayba yingka wudumbikanyi nanda nganinyi, jayalu mili kuyu nanda dungala Jumukunyi. ");
INSERT INTO wrk_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Jayalu mili kuyu nanda dungala, baki jayalu wudumba jamba nananyina dungalana. Jayalu wudumba nangangi jamba nanankanyi jalili mungkijbirri yabimbikanyi kulkarra, baki yukururu baki bujili junu.” Nani barri nyuli yarrijba. Duja nangangi jangkurr. Barriwa. ");
INSERT INTO wrk_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Kuyu yali Jisus nangandurri Biladyurri, baki karrinjayi Jisus walu nangandu. Ngajakayi Jisus Biladwanyi, “Ninji barri kuna walkurra mambuka yalungi Jumukuyngka.” Jananganjayi Bilad Jisuswanyi, “Yi. Ngayu nanda. Ngayu.” ");
INSERT INTO wrk_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Baki yali jujamba Bilad nangangi Jisuskanyi, nanamukunyi mambukamukunyi jurjkanyi, marda malbumalbuwanyi. Yanyba yali balki jangkurr nangangi Jisuskanyi. Jujamba yali Bilad nanankanyi jali yabimba Jisuswanyi. Ngala miku nyuliyanyi yanyba Jisus. Miku nyuliyanyi jananganja yalunya. ");
INSERT INTO wrk_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Baki yanybayi Bilad nangangi Jisuskanyi, “Manku kuna ninji yalungi jangkurr. Wanyingkanyi ninji karda jungku. Yanyba yalu kajanyi nganyingkanyi balkinyi yajinyi. Ngala miku kuna ninjiyi jananganja yalunya.” Barriwa. ");
INSERT INTO wrk_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Ngala mili miku nyuliyanyi yanyba Jisus nangangi Biladkanyi. Miku nyuliyanyi jananganja nanda kabamin mambuka. Baki manmalayi Bilad. Manmala nyuli jali mikukiyanyi jananganja Jisuswanyi. Barriwa. ");
INSERT INTO wrk_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Yurrngumba yingkana kindilkurrinyina baki yingkana kindilkurrinyina, ngala nyuli wangarr niji Kangandijba Barndana Yajinyi barri, baki nanangini kabaminwanyi mambukawanyi nyulili muningka manjijba yingamali nganinyi jalili jungku brisinyina. Nyulili muningka manjijba yingamali nanganginkurri barndarri. Yalili karu nanda mambuka nanankanyi jalija nyulu manjijba. Yalili nijarrijba nangangi niji, bakili nyulu muningka manjijba nanda jalili yalu nijarrijba. ");
INSERT INTO wrk_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Nanamanji barri jungkuyi nganinyi brisinyina, nangangi niji Barabas. Jingkijba yali nanda nganinyi bukambijunyi Jumukunyi. ");
INSERT INTO wrk_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Badajbayi walkurra muramuku barrawurri Biladkanyi. Jilajba yali mankunki yaji nangangi Jisuskanyi. Karrinja yali nanaba danbina, baki ngajakayi yalunya Biladwanyi, “Nayimanji barri, ngayili muningka manjijba yingamali nganinyi brisinanyi. Ngala wanyi jangayu manjijba nanijba barri. Nanda nganinyi niji Barabas kuna. Nayinda kuna Jisus, niji nangangi Krayis. Wanyi jangayu manjijba.” Barriwa. ");
INSERT INTO wrk_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Jingkijba nyuli yalunya mambukamuku jurjkanyi Biladwanyi. Nyuli jingkijba yalunya, yali kuyu Jisus nangandurri, ngurungurujbangangi yali nangangi Jisuskanyi. ");
INSERT INTO wrk_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Ngala jungkuyi Bilad kurdusnyina, baki manjijbayi jangkurr nangandurri nanganginyi maninganjawanyi. Manjijba nyuli nayi jangkurr nangandurri, “Buwarrajimba ngayi yaji barrin mungana. Buwarrajimba ngayi yaji nangangi Jisuskanyi. Nanankardi ngayu jingkijba nyulu yurlurrmba nganinyi, kunybamirra. Miku nyuliyanyi yabimba balki yaji. Miku. Nginduka ngayu muwa nangangi. Mikujiyi yabimba balki yaji nangangi. Mikujiyi manjijba yalundurri, yalu kurdanbikanyi.” Nani barri manjijbayi jangkurr nangandurri maninganjawanyi. ");
INSERT INTO wrk_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Jungkuyi Bilad kalawuyngkurru kurdusnyina, ngala nanamuku muramuku yali jungku danbina. Yanybayi yalungi muramukuyngka nanamuku mambukamuku jurjkanyi baki malbumalbumuku. Karu yalunjali marda yalimi ngajaka Bilad, janyulu muningka manjijba nanda nganinyi Barabas brisinanyi, ngala janyulu manjijba Jisus janybikanyi nangka. Nani barri yali yanyba kudanyu yalungi muramukuyngka. ");
INSERT INTO wrk_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Jilajbayi Bilad yalundurri muramukuyngkurri, baki ngajaka nyuli yalunya, “Wanyi barri jangayu muningka manjijba. Jisus kuna. Barabas kuna. Wanyi jangayu muningka manjijba.” Jananganja yali muramukunyi. Kaya yali, “Manjijbakiyi Barabas. Manjijbakiyi Barabas.” ");
INSERT INTO wrk_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Baki ngajakayi yalunya Biladwanyi, “Ngala wanyimba jangayu nanginkanyi Jisuskanyi, jala yalu nijarrijba Krayis. Wanyimba jangayu nangangi.” Mili barri yali kaya kudanyu nangangi, “Kurdanbakiyi. Kurdanba. Langandabakiyi kingkarri kurndana.” ");
INSERT INTO wrk_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Ngajakayi yalunya Biladwanyi, “Wanyingkanyi marda ngayimi kurdanba. Miku nyuliyanyi yabimba balki yaji. Nyulu jungkuka kunybana yuwana. Wanyingkanyi marda ngayimi kurdanba.” Ngala mili yali kaya nangangi, “Kurdanbakiyi. Langandabakiyi kingkarri kurndana. Kurdanbakiyi.” Nani barri yali kudanyu kaya nangangi. ");
INSERT INTO wrk_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Baki jingkijbayi Biladwanyi, miku nyuliyi yabimba yalunya, yalungka yangkalambikanyi yalunginkanyi jangkurranyi nangangi Jisuskanyi, ngala jayalu mili ngarrangarra muwa, baki jayalu kijijiwujba danbina. Nani barri jingkijbayi Biladwanyi, baki wudumba nyuli wabuda. Wakardaba nangki marni walu yalundu muramukunyina. Nani nangki wakardaba marni minimbiji yalunya, miku nanda nangangi yaji kurdanbikanyi Jisus. Baki yanybayi Bilad yalungi, “Miku ngayimi nulijba kurdanbikanyi nanda Jisus. Nanda narringi yaji. Miku ngaki.” ");
INSERT INTO wrk_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Ngala yali jananganja Bilad muramukunyi, “Yi. Nurrungi nanda yaji kurdanbikanyi Jisus. Nurru Jumuku, janurru nurru yanyba kurdanbikanyi Jisus. Jaliyi nayinda balki kurdanbikanyi Jisus, baki yuku janyulu daba nurrunya Kudwanyi. Janyulu yabimba balki yaji nurrungi baki nurrunginmukuyngka mimimba nurru yalunya, jala yalu juju bayngkani nurrundu. Nani yuku janyulu daba nurrunya, jaliyi balki kurdanbikanyi Jisus. Janangka janyba nurrunginkanyi yajinyi, miku nganyingkanyi yajinyi.” Nani barri yali jananganja Bilad. Barriwa. ");
INSERT INTO wrk_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Baki muningka manjijbayi Barabas brisinanyi Biladwanyi. Nanganginyi ngarrkadabawarrmukunyi yali dulaba Barabas brisinanyi, baki muningka manjijbayi nanganginkurri barndarri. Ngala nyuli jirrinyba nanganginmuku ngarrkadabawarrmuku, yalu wajuji Jisus, yalu kurdanbiji Jisus barrinani kudanyu ngajakayi Bilad Jumukunyi. Baki wajuba yali Jisus nanaba. ");
INSERT INTO wrk_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Baki nanamukunyi ngarrkadabawarrmukunyi Biladkanyi, yali kuyu Jisus kalawuyngkurru nanganginyina barrawuna. Karrinja yali lukuluku nangandu baki ngirrikimba yali Jisus. ");
INSERT INTO wrk_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Dulaba yali nangangi jumbala nanganbunanyi, baki yali yarrijba danyan nangandu mankanyina. Nganmarra nanda danyan, wunanybala wayka darnyiyurruwa. ");
INSERT INTO wrk_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Wudumba yali wakankurrul kurnda nyilanyilayudi, baki kijijba yali bakiri. Yarrijba yali nanda bakiri lukuluku nangandu kulajina Jisusnyina. Wajba yali Jisus nanankanyi ridiridinyi marrimbikanyi nyulu. Nani barri jungkuyi walkurra mambuka nanamanji barri, jirdi bakirinyi baki nganmarranyi danyanyi, baki ridiridinyi. Mururu yali wayka walu nangandu, baki muningka yali kaya nangangi, “Ninji barri, ninji walkurra mambuka yalungi Jumukuyngka. Ninji barri wirimalaru yalungi.” Nani barri yali muningka kaya nangangi baki ngirrikimba yali Jisus. ");
INSERT INTO wrk_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Baki kiwumba yali Jisus. Dulaba yali nanda ridiridi nanganbunanyi marninanyi, baki daba yali Jisus kulaji ridiridiyudinyi. ");
INSERT INTO wrk_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Nani barri yali ngirrikimba Jisus. Barriwa. Baki dulaba yali nanda nganmarra danyan nanganbunanyi mankanyinanyi, baki mili yawumba nangki Jisus nanganginkanyi jumbalanyi. Baki kuyu yali Jisus bayungu kulawirarri langandaji. ");
INSERT INTO wrk_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Ngala yali jilajba bayungu, baki yingka nganinyi, niji Sayimin, nyuli jilajba bayunguna. Nangangi yaji juju bayungu, yaji niji Sayirin. Nyulu jilajbayi bayunguna nananyina yubalina. Baki nanamukunyi ngarrkadabawarranyi, yali jirrinyba nanda nganinyi, nyulu kuyunkanyi nanda wabangkarra kurnda nangangi Jisuskanyi. Baki dukangarrijba nyuli kurnda bayangarriji. ");
INSERT INTO wrk_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Mili yali jilajba bayungu, baki wanbiya yali nananyina kulawirana, niji Kulkuda. Nanda niji Kulkuda, nanda Ju yanyi, barrinani ‘Kulaji Nguli.’ ");
INSERT INTO wrk_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Jidimba yali malumba jirrki baki ngarrki krayibkanyi. Yarrijba yali jawuda yukururuna, baki wajba yali Jisus. Balanjayi kardarda, ngala miku nyuliyanyi ngaraba kudanyu. ");
INSERT INTO wrk_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Baki yali langandaba Jisus wabangkarra kurndana ngarrkadabawarranyi. Ngarrkadaba yali Jisus marni nyilanyilayudinyi. Dulaba yali nangangi jumbala, baki baja yali barrinani kard wudumbikanyi nangangi jumbala. Baki kuyu yali, nanda yalungi jumbala. ");
INSERT INTO wrk_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Baki jungku yali nanaba ngarrkadabawarrmuku, baki lalanba yali Jisus. ");
INSERT INTO wrk_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Yarrijba yali jangkurr najana. Nanangini jangkurrwanyi karuyi yalunya nanankanyi balkinyi yajinyi jali yalu yanyba yabimbayi Jisuswanyi. Yarrijba yali jangkurr najana, baki langandaba yali nanda naja kingkarri kurndana Jisusnyina. Nayi nanda jangkurr najana, “Nayinda nyulu Jisus. Nyulu walkurramirra mambuka yalungi Jumukuyngka.” Barriwa. ");
INSERT INTO wrk_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Baki langandaba yali yingkawuya nangandu Jisusnyina, maninjakuwuya. Yingka langayi wabangkarra kurndana karriya, ngala yingka langayi wabangkarra kurndana bayinga, ngala nyulu Jisus burrandi bulandu. ");
INSERT INTO wrk_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Kajamuku yali kangandijba yalundu, baki ngirringirrimba yalungki kulaji. Nani barri yalungkili ngirringirrimba kulaji, jalili yalu bajalingijba yingka. Ngirrikimba yali Jisus. Yanyba yali balki jangkurr nangangi, ");
INSERT INTO wrk_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","“Yanybayi ninji, yuku janinji dalyamba nanda walkurra jurj, ngala baku barri kujarraka barndayka, yuku janinji yabimba yingka mili jurj. Jaliyi yuku ninji yabimba yaji nani, jaliyi ninji dujanya nangangi jandanyi Kudkanyi, baki lalanba nganyingkiyi. Karralakiyi wayka kurndananyi, jaliyi ninji dujanya jandanyi nangangi Kudkanyi.” Nani barri yali yanyba balki jangkurr nangangi. ");
INSERT INTO wrk_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Baki mambukamuku jurjkanyi, baki malbumalbumuku, baki milidimbawarrmuku yuwanyi, yali marda yanyba balki jangkurr nangangi, ");
INSERT INTO wrk_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","“Nyuli yalunya marrimba mardarda Jisuswanyi, ngala miku nangkiyi marrimba mardarda. Yanyba nangki, nyulu walkurra mambuka nurrungi Jumukuyngka. Jaliyi nyulu karrala wayka kurndananyi, baki yuku janurru kuyu nangangi jangkurr, nyulu nurrungi mambuka. Janurru kuyu nangangi jangkurr, jaliyi nyulu karrala wayka kurndananyi. ");
INSERT INTO wrk_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Nangka yanybaka, nyulu jandanyi nangangi Kudkanyi, nyulu kuyungka nanda jangkurr nangangi Kudkanyi. Nani barri nangka yanybaka. Ngala jaliyi nyulu dujanya nangangi jandanyi Kudkanyi, baki yuku barri janurru najba Kud dulaykurri Jisus kurndananyi. Janurru najba Kud marrimbikurri Jisus mardarda, jaliyi dujanya nyulu jandanyi nangangi.” Nani barri yali yanyba balki jangkurr nangangi. ");
INSERT INTO wrk_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Baki nanankuya maninjakuwuya, jali bula langa nangandu, buli marda yanyba balki jangkurr nangangi. Buli marda yanyba nanamannga jangkurr nangangi. Barriwa. ");
INSERT INTO wrk_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Ngala nyulu mukunjana barri, baki mungijbayi yaji bukamba. Mikuyaji ngardaranyi. Yuwajiwa mungijbayi yaji, baki mili walajbayi nanda ngardara ngabungabu bijal. ");
INSERT INTO wrk_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Ngala nyuli yuwajiwa mungijba yaji, baki kayayi Jisus kudanyu barri. Kudanyu nyuli kaya Ju yanyi, “Yiluyi. Yiluyi. Lama sabakdani.” Barrinani, “Ngaki Kud. Ngaki Kud. Wanyingkanyi nganinji yingijba.” Nani barri kayayi Jisus. Barriwa. ");
INSERT INTO wrk_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Jawuda jali karrinja bundu nangandu, jali manku Jisus kayankurri, yanyba yali, “Mankukiyi. Nyulu kayangka nangangi Yalayijakanyi.” ");
INSERT INTO wrk_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Yarangul nanaba jirdi ngarrkinyi krayibkanyi ngujbulanyi. Yingkawanyi nyuli kijijba karnjal wadiwadina. Yarrijba nyuli karnjal ngarrkina, baki manjijba nyuli kingkarri nangandurri Jisusyurri janyiyurri, nyulu ngaraykanyi. ");
INSERT INTO wrk_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Ngala yingkamuku, jali yalu manku Jisus kayankurri, yali yanyba, “Jangambala yukumba nayiba. Jangambala lalanba yaji, jaliyi nyulu badajba Yalayija nanginkurri, jaliyi nyulu marrimba Jisus mardarda, jaliyi nyulu waykalumba Jisus kurndananyi.” Barriwa. ");
INSERT INTO wrk_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Baki mili kayayi Jisus kudanyu barri. Kaya nyuli, baki mikukiyanyi ngalijba. Barriwa barri nangki janyba Jisus. Barriwa. ");
INSERT INTO wrk_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Kalawuyngkurru nananyina walkurranyina jurjina, langayi walkurra blanki. Langayi nanda walkurra blanki kingkarrinya wayka jambarri. Nanamanji barri jali nangka janyba Jisus, baki bakarrawijba nanda blanki Kudwanyi. Bakarrawijba nyuli kingkarrinya wayka bukamba. Kulbayi jamba, baki dumba nyuli walkurra dungala. ");
INSERT INTO wrk_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Baki nanda jamba jalili yalu makaba kuyuwana, dumba nyuli nanda jamba marda. Nanda mankanyi yalungi, waluwa jali yalu durrijba Kud, walajba yali wankan mili. ");
INSERT INTO wrk_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Barlba yali nanamunanyi yajinanyi kumayangunanyi. Jali Jisus mili wankijba, baki jilajba yali nanankurri barrawuyabarrawuyarri Jirusalimyurri. Najba yalunjali jali yalu wankijba mili kajamukunyi. ");
INSERT INTO wrk_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Yali najba bukamba nayi yaji, ngarrkadabawarrmukunyi, jali yalu lalanba Jisus, baki yalunginyi mambukawanyi. Najba yali jamba kulbankurri. Bukamba nanda yaji yali najba, baki marrala yali. Kudanyu barri yali marrala, baki yanyba yalungki, “Nayinda Jisus, dujanya nyuli Jandanyi nangangi Kudkanyi. Dujanya nyuli nangangi jandanyi.” ");
INSERT INTO wrk_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","56","Jali langa Jisus kurndana, jali nangka janyba, baki karrinjayi jawuda jibarrimuku bundu bijal nangandu. Yali nanamuku jibarrimuku jalili yalu jilalajba nangandu Jisusnyina, jalili yalu lalanba Jisus, baki yali badajba langina Kalilinanyi nangandu. Kudiya yalungi, yingka jibarri nangangi niji Mari Makdalin, yingka nangangi niji Mari, nyuli ngardanganja bulangi Jayimskanyi baki Jusibkanyi. Yingka nyuli maninganja nangangi Sibidikanyi. Karrinja yali juju bijal nangandu Jisusnyina jali nangka janyba. ");
INSERT INTO wrk_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","58","Baki yingka nganinyi, niji nangangi Jusib, nangangi yaji Yarimadiya, nyuli jungku jirdi kajanyi yajinyi, kajanyi dungalanyi. Nyuli marda kandi nangangi Jisuskanyi. Ngabungabu barri nyuli jilajba nanankurri mambukarri Biladyurri, baki ngajaka nyuli Bilad, “Jangayu kuna kuyu nanda Jisus mankanyi makaykanyi. Yuku kuna jangayu kuyu nangangi mankanyi.” Barriwa. Baki karuyi nanganginmuku ngarrkadabawarrmuku Biladwanyi, yalu waykanyi nanda Jusib mankanyi Jisuskanyi. ");
INSERT INTO wrk_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Baki kuyuyi Jisus mankanyi Jusibwanyi. Wudumba nyuli wunanybala raki barrinani blanki, baki kijijba nyuli mankanyi lukuluku bukamba nukamiyurru. ");
INSERT INTO wrk_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Baki yarrijba nyuli mankanyi kumayanguna. Nanda nanganginmirra kumayangu makaykanyi nangangi mankanyi baku barri jalija nangka janyba. Buyingkinyi nanda kumayangu. Ngawamba yali kurrijba nanda lawarr wujina dungalana. Yarrijba nyuli Jisus mankanyi kumayanguna, baki murumba nyuli bardawa nangangi dungalayudinyi. Karranunumba nyuli walkurra dungala murumbiji bardawa, baki barlba nyuli. ");
INSERT INTO wrk_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Nanda jibarri Mari Makdalin, baki nanda yingka jibarri niji Mari, buli jungku nanaba. Najba buli Jusib yarriykurri mankanyi kumayanguna. Barriwa. ");
INSERT INTO wrk_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Munganawa barri Sadidi, jilajba yali mambukamuku jurjkanyi, baki Barasimuku. Jilajba yali nangandurri Biladyurri yanybiji nanangi. ");
INSERT INTO wrk_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Yanyba yali, “Mambuka. Nanda nganinyiyurru nyuli jujambawarr. Karu nyuli yalunya, ‘Jalija ngaka janyba, baki jangayu mili wankijba. Baku barri kujarraka barndayka, jangayu mili wankijba barri.’ Nani barri nyuli yanyba, nanda jujambawarr. ");
INSERT INTO wrk_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Baki nanganginmukunyi kandimukunyi yiningki jayalu dulaba nangangi mankanyi. Yiningki jayalu ngadijba nangangi mankanyi. Baki jayalunjalu karu nangangi Jisuskanyi, nyulu mili wankijbayi. Nyulu mili wankijbayi, mikuyajingangi mankankanyi kumayanguna. Jaliyi yalu dulaba nangangi mankanyi, jaliyi yalu yanyba nani nangangi, baki nanda balki. Nanankardi barri nurru ngajaka ninya, janinji jirrinyba nganyinmuku ngarrkadabawarrmuku, yalu lalanbiji nanda kumayangu. Yurrngumba kujarraka barndayka jayalu lalanba nanda kumayangu, baki mikuwali nanganginyi kandimukunyi dulaba nangangi mankanyi.” Barriwa. ");
INSERT INTO wrk_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Jananganjayi yalunya Biladwanyi, “Yuku barri. Yuku janarri kuyu yalunya narringinmuku yilarrmuku. Janarri yarrijba yalunya lalanbiji nanda kumayangu. Jayalu kudanyu lalanba nanda kumayangu narringi, baki mikuwali yingkawanyi dulaba nanda mankanyi.” Nani barri jananganjayi yalunya Biladwanyi. Barriwa. ");
INSERT INTO wrk_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Barlba yali kumayangurri mambukamuku jurjkanyi, baki Barasimuku, baki yilarrmuku. Kijijba yali kurul danbina kumayanguna langina kularriji yundukula dungalana. Marrumba nanda kurul dungalana birnyiyudinyi. Jaliyi yingkawanyi dulaba dungala baki ngankijba kumayanguna, baki waluku janyulu dalyamba nanda kurul. Baki jayalu najba nanda kurul dalyawiykurri, baki jayalu jingkijba ngankijbayi yingka kumayanguna. Nani barri yali marrumba nanda kurul, baki lalanba yali nanda yaji yilarrmukunyi. Ngala mambukamuku jurjkanyi baki Barasimuku, yali wijba yalunginkurri barndarri. Barriwa. ");
INSERT INTO wrk_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Munganawa barri Sadidi, wuyalijba yali. Yingkana mungana Sundi, ngala nyuli kambalingijba yaji, baki jilajbayi jibarriwuya karri kumayangurri. Jilajba buli Mari Makdalin, baki yingka jibarri niji Mari. ");
INSERT INTO wrk_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Waluwa barri mungana kulbayi nanda jamba kudanyu barri, baki karralayi Yanjil nangangi Kudkanyi. Karrala nyuli kingkarrinya lalijinanyi wayka kumayangurri, baki lukulukumba nyuli nanda dungala bardawananyi. Lukulukumba nyuli nanda dungala wiliyurri bardawarri, baki jungku nyuli dungalana. ");
INSERT INTO wrk_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Nanda Yanjil barri, bilirrbayi wali nangangi barrinani nanda mirnbi ngajarranyi, baki nangangi jumbala buludamirra. ");
INSERT INTO wrk_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Ngala nanamuku yilarrmuku jali yalu lalanba nanda kumayangu, marrala yali. Kudanyu yali marrala jali yalu najba nanda Yanjil, baki birrirra yali muwa kudanyu barri. Yirrba yali wayka jambarri, baki kuluka yali kudanyu barri barrinani yalungki janyba. Barriwa. ");
INSERT INTO wrk_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Jali bula wanbiya jibarriwuya kumayanguna, baki yanybayi nanda Yanjil bulangi, “Marda nimbalimi miku marrala. Ngayu jingkijbangka nimbalanya, nimbala kujbangka nangangi Jisuskanyi, nanankanyi jali yalu langandaba wabangkarra kurndana. ");
INSERT INTO wrk_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Miku nyulimi nayiba. Miku nyulimi nangangi mankanyi kumayanguna. Walajba nyuli. Nyulu mili wanka jungkuka, barrinani wabula nyuli karu narrinya, nyuluja mili wankijba. Kabukawa. Najba janimbala nayinda kalawunyi kumayanguna. Janimbala najba nanda yaji jali jungku nangangi mankanyi wulaninyi. Janimbala najba mikuyaji mankankanyi nanaba. ");
INSERT INTO wrk_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Ngala janimbala dulu wirlku yalundurri nanganginmukuyngkurri kandimukuyngkurri. Janimbala karu yalunya nangangi Jisuskanyi, walajba nyuli, nyulu mili wanka jungkuka. Baki nyulu jilajbangka langki waluwa yalundu Kaliliyurri. Nanaba jayalu najba Jisus. Barriwa. Nani janimbala karu yalunya. Ngala miku nimbaliyi mamanumba nayinda jangkurr.” Barriwa. Nani barri yanybayi Yanjil bulangi. ");
INSERT INTO wrk_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Dulu buli wirlku kumayangunanyi. Dulu buli wijba bayungu barrawuyabarrawuyarri. Marrala buli yajinyi, ngala mili buli mirnarrijba muwa yajinyi. Wirlku buli yalundurri kandimukuyngkurri karunki yajinyi. ");
INSERT INTO wrk_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Ngala buli wirlku, baki wakun minimba nangki Jisus bulangi. Karrinja nyuli walu bulandu. Kurrkunba bulangki, baki yanybayi Jisus bulangi, “Nanama nimbala.” Jingkijba buli, nyuli Jisus. Jilajba buli nangandurri. Mururu buli wayka jambana walu nangandu, baki marrimba buli nangangi nukami. Nani buli yabimba minimbiji nyuli walkurramirra bulangi. Baki wajba buli Jisus kunybanyi jangkurranyi bulanginkanyi. ");
INSERT INTO wrk_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Yanybayi Jisus bulangi, “Miku nimbaliyi marrala ngaki. Janimbala jilajba yalundurri, ngakinmukuyngkurri kandimukuyngkurri, jala ngayu bababanyamba ngayu yalunya. Janimbala karu yalunya, jayalu jilajba langki Kaliliyurri. Nanaba janganjalu najba.” Barriwa. Nani buli najba Jisus, baki mili buli jilajba yalundurri kandimukuyngkurri karunki yajinyi. ");
INSERT INTO wrk_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Ngala buli jilajba, baki walajba yalu nanamuku yilarrmuku, baki kudiyamuku yali wijba barrawuyabarrawuyarri. Yali jilajba walkurrayngkurri jurjyurri, baki karu yali mambukamuku jurjkanyi nanankanyi yajinyi, jali yalu najba. Karu yali mambukamuku Yanjilkanyi jali badajba, baki dungalanyi jali jungku wilina, baki mikuyaji mankankanyi nanaba kumayanguna. ");
INSERT INTO wrk_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Baki yanyba yalungki mambukamuku jurjkanyi, baki malbumalbumuku. Yanyba yalungki, wanyimba jayalu nanankardi. Yanyba yalungki, baki wajba yali yilarrmuku kajanyi dungalanyi. ");
INSERT INTO wrk_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","Wajba yali yilarrmuku dungalanyi, baki jirrinyba yalunjali, “Miku narriyi yanyba duja jangkurr nanankanyi yajinyi, ngala janarri yanyba nayi barri, ‘Ngala nurri kuluka mungana, baki wanbiya yali kandimuku nangangi Jisuskanyi. Wanbiya yali, baki maninjakujba yali nanda mankanyi ngala nurri kulukawa.’ Nani barri janarri yanyba. ");
INSERT INTO wrk_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Ngala nanda mambuka Bilad, jaliyi yingkawanyi karu Bilad narringinkanyi jangkurranyi, narri kulukankanyi, jala marda narriyanyi lalanba nanda kumayangu, jaliyi yingkawanyi karu Bilad nani narringi, baki janurru nurru yanyba nangangi Biladkanyi narringi. Janurru kurrkunba Bilad nyulu yabimbikanyi kiji narringi, nyulu daykanyi narrinya. Yuku narri jungku mardumardu muwa nanginkanyi yajinyi. Miku nurriyi munyajba Bilad, nyulu yabimbikanyi kiji narringi.” Nani barri yalunjali jirrinyba, yalu yanybiji jujambawarr jangkurr yilarrmuku. ");
INSERT INTO wrk_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Baki kuyu yali nanda kaja dungala yilarrmukunyi. Kuyu yali nanda dungala, baki barlba yali. Yabimba yali nanda yaji jali yalunjalu jirrinyba mambukamukunyi jurjkanyi. Karu yalunjali kandimukuyngka Jisuskanyi, yali maninjakujba nanda mankanyi ngala yali kulukawa yilarrmuku. Kajamukunyi jali yalu jungku lukuluku nananyina yajina, yali manku nanda jujambawarr jangkurr, baki kuyu yali nanda jangkurr. Yuwajiwa yalungka yanyba nanankanyi yajinyi, maninjakujba jali yalu nanda mankanyi nanganginmukunyi kandimukunyi. Barriwa. ");
INSERT INTO wrk_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Jilajba buli jibarriwuya yalundurri kandimukuyngkurri. Karuyi yalunya jangkurranyi Jisuskanyi, baki barlba yali langki Kaliliyurri. Nanamuku kandimuku 11 barri, yali jilajba langki nanankurri kulawirarri jali yanyba Jisus yalungi yalu jilaykanyi nanankurri. ");
INSERT INTO wrk_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Wanbiya yali, baki najba yali Jisus, baki jilajba yali bijal bundu nangandurri. Baki yali wajba Jisus kunybanyi jangkurranyi yalunginkanyi. Ngala yingkamukunyi, yali jingkijba, nanda nyuli Jisus mili wanka jungunkanyi. Ngala yingkamuku yalungki mankumanku, yiningki nanda Jisus mili wankijbayi, ngala yiningki nanda yingka. ");
INSERT INTO wrk_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Baki jilajbayi Jisus bundu yalundurri, baki yanyba nyuli yalungi, “Yarrijba ngani Kudwanyi wirimalaru narringi. Ngana nyuli yarrijba wirimalaru bukambijuyngka yalungi wandijiyana, lalijina baki jambana. ");
INSERT INTO wrk_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Baki ngayu karungka narrinya. Janarri jilalajba lukuluku wandijiyana. Janarri mililidimba yalunya ngaki. Kudanyu janarri mililidimba yalunya ngaki, baki kajamukunyi jayalu kuyu narringi jangkurr ngaki, jayalu marda ngakinmuku kandimuku. Jalija yalu kuyu ngaki jangkurr, baki janarri ngurrunba yalunya marda. Janarri karu yalunya nayi, yalungi mambuka nyulu Kud. Yalungi mambuka nyulu nanda Buwakanya Kingkarri, baki nyulu nanda Jandanyi nangangi Kudkanyi, baki nyulu nanda Kunyba Ngarndu nangangi Kudkanyi. Malumba yalu jungkuka barrinani yingamali mambuka yalungi. ");
INSERT INTO wrk_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Janarri milidimba yalunya, yalu ngayangayiykanyi ngakinkanyi jangkurr. Jayalu ngayangayijba bukambijuyngka nanankanyi jangkurranyi jali ngayu milidimba narrinya. Mankumankuwa narri. Jangayu jungku narrindu yurrngumba barri. Jangayu jungku narrindu kurduluna yurrngumba nanankurri jalija bukamba yaji Kudwanyi.” Barriwa barri. Bukamba nayinda jangkurr. ");
INSERT INTO wrk_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Ngayu karungka narrinya nangangi Jisus Krayiskanyi. Ngayu karungka narrinya kunybanyi jangkurranyi nangangi Jisus Krayiskanyi, nyulu jandanyi nangangi Kudkanyi. ");
INSERT INTO wrk_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Wabula wankalana yarrijbayi jangkurr najana Kudkanyi nganinyiwanyi. Nangangi niji Yayisaya. Nanda nganinyi, nyuli yanybawarr jangkurranyi Kudkanyi. Yarrijba nyuli nanda jangkurr najana jali karu Kudwanyi. Nayinda barri nanda jangkurr jali yanyba Kud nanganginkanyi jandayngkanyi, “Jangayu manjijba nganinyi waluwa nganyindu, baki janyulu kaya yalungi. Janyulu kaya yalungi nayi barri, ‘Birrirrinja narringkaja kurdulu nangangi. Birrirrinja narringkaja kurdulu.’ ");
INSERT INTO wrk_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Nanda nganinyi jalija ngayu manjijba waluwa barri nganyindu, janyulu jungku mangkurruna yajina, baki janyulu kaya yalungi barri, ‘Birrirrinja narringkaja kurdulu, badajbajangangi nanda walkurra mambuka. Janyulu badajba, nanda jalija manjijba Kudwanyi. Birrirrinja narringkaja kurdulu nangangi’.” Barriwa. Nani barri yanybayi nanda jangkurr najana Kudkanyi. Barriwa. ");
INSERT INTO wrk_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Jungkuyi nganinyi mangkurruna yajina, nangangi niji Jun Ngurrunbawarr. Nyulili ngurrunba yalunya wabudana. Nyulili babdayis yalunya. Nyulili milidimba yalunya nayi barri, “Ngindu narri muwa narringinkanyi balkinyi yajinyi. Ngindu narri muwa, jungkungangi narrili balki nangangi Kudkanyi, baki janyulu manjamanjamba narringi balki yaji Kudwanyi, baki jangayu ngurrunba narrinya wabudana.” Nani barri nyulili milidimba yalunya. ");
INSERT INTO wrk_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Kajamuku yali badajba nangandurri Junyurri, mankunki nangangi jangkurr. Badajba yali kulani nanamunanyi walkurrananyi yajinanyi niji Judiya, baki bayunguna barrawuyabarrawuyananyi niji Jirusalim. Ngindu yali muwa yalunginkanyi balkinyi yajinyi, baki karu yali Jun, yali jungku balki nangangi Kudkanyi. Baki nyuli ngurrunba yalunya wabudana Junwanyi. Nyuli ngurrunba yalunya bundalina, niji Jurdan. ");
INSERT INTO wrk_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Nanda barri Jun Ngurrunbawarr, nayi nyulili jungku. Wudumba nyulili nganya nanankanyi yanimalkanyi, niji kamil. Nanda kamil barrinani yarrama. Wudumba nyulili nanda nganya, bakili nyulu yabimba jumbala nangangi nganyayudinyi. Bakili nyulu kijijba waba nanganginyina muwana. Wardamba nangkili ngawamba nyangkunyalinyi baki ngandalanyi. Miku nangkiyanyi wardamba barnyinyi, ngawamba nyangkunyalinyi baki ngandalanyi. ");
INSERT INTO wrk_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Karuyi yalunya Junwanyi Ngurrunbawarranyi, “Nanda barri nganinyi jalija nyulu badajba bayngkani ngakindu, nyulu walkurra mambuka ngambalangi. Nyulu mili walkurra mambuka ngaki. Nyulu ngiruka, ngala miku ngayu ngiruka barrinani nyulu. ");
INSERT INTO wrk_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Ngayu yawumba narrinya wabudana, ngala nanangini jalija badajba, janyulu yawumba Kunyba Ngarndu nangangi Kudkanyi narrindu. Janyulu yawumba nanda Kunyba Ngarndu nangangi Kudkanyi narrindu kurduluna.” Nani barri karuyi yalunya Junwanyi. Barriwa. ");
INSERT INTO wrk_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Nanamanji barri badajbayi Jisus nangandurri Junyurri. Badajba nyuli langina nanganginbunanyi yajinanyi, niji Nasarid. Nanda yaji Nasarid, nananyina walkurranyina yajina, niji Kalili, Badajbayi Jisus nangandurri Junyurri, baki ngurrunbayi Jisus wabudana Junwanyi. Ngurrunba nyuli Jisus bundalina, niji Jurdan. ");
INSERT INTO wrk_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Jali walajba Jisus wabudananyi, baki yinarramba nyuli najba laliji kingkarri. Najba nyuli laliji bardawambikurri nangka. Baki najba nyuli nanda Kunyba Ngarndu nangangi Kudkanyi karralankurri kingkarrinya wayka nangandurri. Karralayi nanda Kunyba Ngarndu Kudkanyi nangandurri, baki jungkuyi ngarndu nangandu kulajina, barrinani babangka kulukuku kingkarrinya wayka, baki jungkuka kurndana. ");
INSERT INTO wrk_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Baki yanybayi Kud jangkurr kingkarrinya. Nayi nyuli yanyba, “Ninji barri ngakinmirra jandanyi, jala ngayu maruka muwa kudanyu barri. Ninji jungkuka kunyba. Ngayu mirnarrijbangka muwa nganyi barri.” Barriwa. ");
INSERT INTO wrk_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Yinarramba barri manjijbayi Jisus kingkarri Kunybawanyi Ngarnduwanyi Kudkanyi. Manjijba nyuli Jisus kingkarri dungalarri. Jungkuyi Jisus nanaba dungalana. Mikuyaji yingkanyi nangandu. Yurlwa yali nganinyimuku nanankanyi mulijinyi yajinyi. ");
INSERT INTO wrk_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Jungkuyi Jisus nanaba nyuluman, baki jawuda bijbawarr yanimal nanaba nangandu marda. Jungku nyuli nanaba yingamali yakarl, baki bijal mili nyuli jungku nanaba. Ngala badajbayi nanda mambuka wuwarranyi, niji Sayidin. Badajba nyuli nangandurri Jisusyurri, baki balanja nyuli Jisus. Nulijba nyuli nangangi Jisuskanyi, nyulu yanybikanyi balki jangkurr nangangi Kudkanyi, nyulu yabimbikanyi balki yaji nangangi barri. Nanankardi barri nyuli balanja Jisus, ngala jungkuyi Jisus kunyba yurrngumba barri. Baki nanamuku Yanjilmuku jalili yalu waki nangangi Kudkanyi, badajba yali nangandurri Jisusyurri. Lalanba yali Jisus nanaba mulijina yajina. Barriwa. ");
INSERT INTO wrk_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Baku barri yali wudumba nanda Jun Ngurrunbawarr. Wudumba yali Jun ngarrkadabawarrmukunyi, baki kijijba yali. Yarrijba yali brisinyina. Barriwa. Bayngkani barri barlbayi Jisus langki nanankurri walkurrayngkurri yajiyurri, niji Kalili. Jungku nyuli nanaba, baki karu nyuli yalunya nanankanyi kunybanyi jangkurranyi nanganginkanyi Kudkanyi. ");
INSERT INTO wrk_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Yanybayi Jisus nayi barri yalungi, “Nanijba barri yuku narri jungku kunyba nangangi Kudkanyi, baki janyulu lalanba narrinya Kudwanyi. Wijba narri jungku balki. Yangkalamba narringka narringinbunanyi balkinanyi yajinanyi, baki janarri kuyu nayinda kunyba jangkurr nangangi Kudkanyi. Jungku janarri kunyba nangangi Kudkanyi yurrngumba barri. Ngindu janarringka muwa narringinkanyi balkinyi yajinyi. Kuyu janarri nayinda kunyba jangkurr nangangi Kudkanyi, baki janyulu lalanba narrinya yurrngumba barri.” Nani barri milidimbayi yalunya Jisuswanyi. Barriwa. ");
INSERT INTO wrk_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Jilajbayi Jisus yundu bayunguna wabudana. Walkurra nanda wabuda, barrinani kanja, niji barri Kanja Kalili. Jilajbayi Jisus, baki najba nyuli bulanya buwakula, Sayimin baki Yandru. Nyulu najbayi bulanya janybikurri bardija wayka wabudarri. Janyba bulili bardija wayka kakunyi, mungkijbirriwuyanyi. Nani barri bulili waki yurrngumba wudumbikanyi kaku. ");
INSERT INTO wrk_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Yanybayi Jisus bulangi, “Jilajba janimbala ngakinduwa. Janimbala jungku ngakindu yurrngumba barri, baki jangayu milidimba nimbalanya. Nanijba barri nimbala wudumbaka kaku, ngala baku barri janimbala wudumba yingkamuku ngaki nganinyimuku.” ");
INSERT INTO wrk_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Baki yinarramba buli yingijba nanda bardija. Yingijba buli bardija yurrngumba barri, baki jilajba buli nangandu Jisusnyina. Barriwa. ");
INSERT INTO wrk_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Jilajba yali bijal mili bayunguna wabudana, baki najba yali yingkawuya buwakula bulanya. Najbayi bulanya, Jayims baki Jun. Marda nijanganjinyi bulangi, niji nangangi Jibidi, nyuli bulandu marda. Jungku yali muwardana, baki ngarrkadaba yali nanda bardawa badija. ");
INSERT INTO wrk_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Najbayi yalunya Jisuswanyi baki yinarramba nyuli yanyba bulangi buwakulayngka, bulaja jilajba nangandu Jisusnyina. Baki yingijba buli nanda nijanganjinyi bulangi. Nyuli wambu jungku muwardana, baki jawuda wakiwarr nangandu. Ngala barlba buli buwakula nangandu Jisusnyina. Barriwa. ");
INSERT INTO wrk_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Jilajba yali, baki wanbiya yali nananyina barrawuyabarrawuyana, niji Kabirnayum, baki jungku yali nanaba. Ngala nyulu Sadidi, baki ngankijba yali jurjina. Baki yanybayi Jisus yalungi nanaba jurjina. Nyulu milidimbayi yalunya nanganginkanyi jangkurranyi Kudkanyi. ");
INSERT INTO wrk_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Manku yali nangangi jangkurr, baki manmala yali. Manmala yali kudanyu barri. Mankumanku yalungki, “Wanyi nayinda. Wanyi. Miku nyulimi barrinani nanamuku milidimbawarrmuku yuwanyi Musiskanyi. Yalili milidimba ngawamba nanankanyi wankalanyi yuwanyi. Ngala nayinda barri yinini nyulu. Nyulu yanybaka jangkurr nangangi Kudkanyi barrinani walkurra mambuka. Wanyi nyulu. Wanyi.” Barriwa. Nani barri yalungki mankumanku nangangi Jisuskanyi. ");
INSERT INTO wrk_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Ngala yanybayi Jisus yalungi jurjina, baki ngankijbayi yingka nganinyi jurjina. Jungkuyi balki wuwarr nangandu mankanyina. Ngankijbayi nanda nganinyi wuwarryudi, ");
INSERT INTO wrk_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","baki kaya nyuli kudanyu barri, “Ninji barri Jisus, nganyi yaji Nasarid. Wanyimba janinji nurrungi. Badajba kuna ninji kurdanbiji nurrunya. Ngayu jingkijbangka ninya, ninji barri nanda malaba nangangi Kudkanyi.” Barriwa. ");
INSERT INTO wrk_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Ngala ngirrwayi Jisus nanankanyi wuwarranyi. Ngirrwa nyuli nangangi, “Kardakiyi jungku. Karda. Walajbakiyi nanganbunanyi mankanyinanyi. Walajbakiyi.” Barriwa. ");
INSERT INTO wrk_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Ngala janybayi nanda nganinyi wayka jambarri wuwarrwanyi. Janyba nyuli wayka, baki kayayi nanda wuwarr kudanyu barri. Kaya nyuli kudanyu, baki walajba nyuli nanganbunanyi mankanyinanyi. Baki yuku barri nanda nganinyi. ");
INSERT INTO wrk_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Ngala nanamuku barri jali yalu karrinja nanaba lukuluku bulandu, manmala yali. Kudanyu yali manmala nanankanyi jali yalu najba, baki yililikajba yalungki nangangi Jisuskanyi, “Wanyi nayinda. Wanyi. Nyulu kuna buyingkinyi milidimbawarr. Nyulu yanybaka barrinani yalu yanybaka walkurramuku mambukamuku. Jirrinybaka nyulu wuwarrmuku, yalu walaykanyi mankanyinanyi, baki yalu ngayangayijbangka nanganginkanyi jangkurranyi, yalu walajbangka mankanyinanyi.” Nani barri yalungki yanyba nangangi Jisuskanyi. ");
INSERT INTO wrk_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Yingkamukunyi yalunjali karu yingkamuku nangangi Jisuskanyi, jabarri yalunjali karu yingkamuku nangangi barri. Kajamukunyi yali manku jangkurr nangangi Jisuskanyi, baki nanganginkanyi jangkurranyi. Kajamukunyi jalili yalu jungku langkiya baki bayinga, karriya baki kulaya nananyina walkurranyina yajina Kalili, yali manku jangkurr nangangi. Barriwa. ");
INSERT INTO wrk_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Walajbayi Jisus jurjnanyi, baki jilajba nyuli barrawurri. Nanda bulangi barrawu, buwakulayngka, Sayiminkanyi, baki Yandrukanyi. Ngankijbayi Jisus nanaba barrawuna, marda kujarra kandiwuya nangandu, Jayims baki Jun. ");
INSERT INTO wrk_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Nanaba barrawuna kulukayi bardibardi jali nyulu lunji. Nyuli ngunyarringanja nangangi Sayiminkanyi. Ngarrangarra nyuli mankanyi. Karu yali Jisus nanankanyi bardibardinyi, nyuli lunji. ");
INSERT INTO wrk_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Jilajbayi Jisus nangandurri, marrimba nyuli bardibardi marni, baki kingkarrumba nyuli bardibardi marninanyi. Kunybijbayi nanda bardibardi mankanyi. Mardumardu mankanyi. Walajba nyuli baki wudumbayi mama yalungi barri. Barriwa. ");
INSERT INTO wrk_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Ngabungaburri barri, ngala nyulu bijal mungarri yaji, baki kuyu yalunjali nangandurri Jisusyurri. Kajamuku jali yalu lunji, baki kajamuku jali yalu wuwarryudi, yalunjali kuyu nangandurri Jisusyurri, ngala nyulu bijal mungarri yaji. ");
INSERT INTO wrk_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Baki bukambiju jali yalu jungku nananyina yajina, yali jilajba nanankurri barrawurri jali jungku Jisus. Kajamuku, wirdikudukudumuku yali jilajba nanankurri, baki karrinja yali danbina. ");
INSERT INTO wrk_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Baki kunymambayi yalunya Jisuswanyi. Kunymamba nyuli bukambiju jali yalu lunji. Jakajba nyuli wuwarr yalunbunanyi mankanyinanyi. Baki kardamba nyuli wuwarr yanybikanyi. Jingkijba yali Jisus wuwarrmukunyi, baki nanankardi nyuli kardamba yalunya yanybikanyi. Barriwa. ");
INSERT INTO wrk_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Munganawa barri ngala nyuli kamambawurri yaji, baki walajbayi Jisus. Walajba nyuli barrawunanyi, baki jilajba nyuli munjiyurri. Mikuyaji yingkanyi nanaba. Nyubana nyuli jungku. Baki yanybayi Jisus mududu nangangi Kudkanyi. Yanyba nyuli mududu nangangi Kudkanyi nanaba nyubana. Barriwa. ");
INSERT INTO wrk_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Bijal barri kamu walajbayi Sayimin, baki yingkamuku nangandu. Durrijba yali Jisus. ");
INSERT INTO wrk_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Wakaramba yali Jisus, baki yanyba yali nangangi, “Kajamuku barri yalu kujbangka nganyi. Yalu kujbangka nganyi bukambiju.” ");
INSERT INTO wrk_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Ngala yanybayi Jisus yalungi, “Ngambalaja jilajba yingkarri barrawuyabarrawuyarri, baki yingkarri barrawuyabarrayuwarri. Jangambala yidamba kajamuku barrawuyabarrawuya, baki jangayu yanyba yalungi. Jangayu milidimba yalunya marda jangkurranyi. Nanankardi barri ngayi badajba milidimbiji yalunya kajamuku.” Barriwa. ");
INSERT INTO wrk_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Baki mili jilajbayi Jisus. Jilalajba nyuli lukuluku barri nananyina yajina Kalili. Jilalajba nyuli langki, kula, bayungu, baki karri. Kaja jurj nyuli nanaba yajina, baki ngankijba nyuli yingkana baki yingkana baki yingkana milidimbiji yalunya. Milidimba nyuli yalunya kajana jurjina. Baki kajamuku jali yalu wuwarryudi mankanyi, nyuli jakajba wuwarr yalunbunanyi mankanyinanyi. Barriwa. ");
INSERT INTO wrk_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Jilajbayi nganinyi nangandurri Jisusyurri. Nanda nganinyi ngujbulijba nyuli nangangi waba bukamba. Yingkamuku yalili marrala nanankanyi nanganginkanyi ngalyanyi. Mikukiyanyi kunybijba mankanyi. Jiwilijbayi nanda ngalya nangandu, baki janangka janyba baku barri. Nanankardi barri kudanyu yalili marrala nanankanyi ngalyanyi. Jilajba nyuli nangandurri Jisusyurri, baki mururu nyuli wayka mujina nangandu Jisusnyina, baki yanybayi nangangi Jisuskanyi, “Jaliyi ninji nulijba ngaki, kunymambikanyi ngaki mankanyi, baki yuku ninji kunymamba ngaki mankanyi.” Barriwa. ");
INSERT INTO wrk_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Nginduyi Jisus muwa nangangi. Ngindu nyuli muwa nangangi, baki manjijba nangki marni. Manjijba nangki Jisus marni nangandurri, baki marrimbayi nanda nganinyi. Baki yanybayi Jisus nangangi, “Ngayu nulijbangka nganyi, kunymambikanyi ninga mankanyi. Kunybakiyi jungku mankanyi.” ");
INSERT INTO wrk_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Baki yinarramba kunybijbayi nangangi mankanyi. Mili kunyba nangangi waba. ");
INSERT INTO wrk_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","44","Baki jirrinybayi nanda nganinyi Jisuswanyi. Maramaramba nyuli, “Mikujiyi karu yalunya yingkamuku jali ngayu kunymamba nganyi mankanyi. Mikujiyi karu yalunya. Ngala jilajbakiyi nangandurri, nanankurri mambukarri jurjkanyi. Minimbakiyi nganyingka mankanyi nangangi, baki muningka wajbakiyi Kud barnyinyi. Nani barri yanybayi nanda wankalanyi Musis, muningka waykanyi Kud barnyinyi. Jayalu wajba Kud barnyinyi, jalija kunybijba mankanyi. Nanankardi barri, janinji wajba Kud barnyinyi, baki yingkamukunyi jayalu jingkijba ninya, ninji mirnarrijba muwa nangangi Kudkanyi, kunybijbangkangangi nganyi mankanyi.” Barriwa. Nani barri jirrinybayi nganinyi Jisuswanyi. Maramaramba nyuli nganinyi, baki manjijba nyuli nanda nganinyi nangandurri mambukarri jurjkanyi. ");
INSERT INTO wrk_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Ngala mikukiyanyi karda jungku nanda nganinyi. Jilajba nyuli, baki karu nyuli yalunya bukambiju nangangi Jisuskanyi. Nyuli karu yalunya nangangi Jisuskanyi, nyuli kunymamba nangangi mankanyi. Mankuyi nanda jangkurr kajamukunyi, baki jilajba yali nangandurri Jisusyurri, wirdikudukudumuku. Jilalajba yali nangandu lukuluku yurrngumba barri. Baki nanankardi barri mikukiyanyi mili jilalajba Jisus barrawuyabarrawuyana, ngala jungku nyuli munji. Ngala kajamuku yali jilajba nangandurri munjiyurri. Jilajba yali langina baki bayunguna, karrina baki kulani. Malimalijba yalungki nangandurri Jisusyurri. Barriwa. ");
INSERT INTO wrk_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Bijal barri baku wijbayi Jisus nanankurri barrawuyabarrawuyarri niji Kabirnayum. Wijba nyuli, baki jungku nyuli barrawuna. Kajamuku yali manku jangkurr nangangi Jisuskanyi, nyulu jungkuka nananyina barrawuna. ");
INSERT INTO wrk_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Baki jilajba yali nangandurri barrawurri. Ngankijba yali kalawuyngkurru barrawuna. Baki walbinyi nanda barrawu nyulu kalawuyngkurru. Baki mili barri yali wanbiya kajamuku, baki karrirrinja yali danbina barrawuna. Baki milidimbayi yalunya Jisuswanyi. Nyuli karu yalunya nangangi Kudkanyi. ");
INSERT INTO wrk_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Yingkamuku yali jilajba nangandurri Jisusyurri. Kuyu yali nganinyi kujarrawanyi baki kujarrawanyi. Nanda nganinyi nyuli lunji. Miku nangkiyanyi ngirringirrimba nangangi mankanyi. Kuluka nyuli yurrngumba jalyuna. Marrimba yali nangangi jalyu, baki kuyu yali nanda nganinyi nangandurri Jisusyurri. ");
INSERT INTO wrk_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Kajamuku yali karrinja danbina barrawuna, baki walbinyi nanda barrawu nyuli. Baki nanankardi barri miku yaliyi ngankijba. Miku yaliyi kuyu nanda nganinyi nangandurri Jisusyurri. Kajamuku yali kalawuyngkurru barrawuna, baki lukuluku marda. Ngala nanamuku jali yalu kuyu nanda nganinyi, kirrijba yali kingkarri yundu nananyina barrawuna. Kirrijba yali kingkarri, baki jungku yali yundukula barrawuna. Bardawamba yali nanda barrawu yundu. Kijijba yali kujarra baki kujarra kurul jalyuna. Baki manjijba yali nanda nganinyi wayka kurulyudinyi. Manjijba yali wayka jambarri walu nangandu Jisusnyina. ");
INSERT INTO wrk_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Najbayi yalunya Jisuswanyi, baki jingkijba nyuli yalunya, nanda nganinyi jali lunji, baki nanamuku jali yalu kuyu nganinyi. Jingkijba nyuli yalunya, mankumanku yalungki nangangi Jisuskanyi, yuku nyulu kunymamba nanda nganinyi jala nyulu lunji. Yuku nyulu kunymamba nangangi mankanyi. Baki yanybayi Jisus nganiyngkanyi jali lunji, “Ngaki kandi. Jangayu manjamanjamba nanda balki jali ninji yabimba.” ");
INSERT INTO wrk_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Ngala kudiyanymuku milidimbawarrmuku yuwanyi Musiskanyi, yali jungku nanaba nangandu. Manku yali nangangi jangkurr Jisuskanyi, baki yanyba yalungki, ");
INSERT INTO wrk_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Nayinda nganinyi nyulu balki. Jungkuka nyulu balki nangangi Kudkanyi. Miku nyuliyi manjamanjamba balki yaji. Ngawamba Kudwanyi yuku nyulu manjamanjamba balki yaji, ngala mikuwali nganinyiwanyi. Nayinda barri nyulu jujambawarr.” Nani barri yalungki yanyba nangangi Jisuskanyi. ");
INSERT INTO wrk_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Ngala yinarramba jingkijbayi yalunya Jisuswanyi. Jingkijba nyuli nanda jali yalungka yanyba nangangi. Baki yanyba nyuli yalungi barri, “Wanyingkanyi narringka mankumanku balkinyi jangkurranyi ngaki, yanybangangi ngayi jangkurr manjamanjambikanyi nangangi balki yaji. Wanyingkanyi. ");
INSERT INTO wrk_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Wanyi barri mili jardibirri yaji yabimbikanyi. Manjamanjambikanyi balki yaji kuna. Kunymambikanyi nayinda nganinyi mankanyi kuna. Wanyi mili jardibirri yaji yabimbikanyi. ");
INSERT INTO wrk_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Ngayu Buwanya Bukambijuyngka. Nyuli yarrijba ngana walkurra mambuka, miku nganinyiwanyi, ngala Kudwanyi. Baki nyuli karu ngana, yuku ngayu manjamanjamba balki yaji. Jalija nganarri najba kunymambikurri nayinda nganinyi mankanyi, baki janganarri jingkijba, yuku ngayu manjamanjamba nangangi balki yaji marda.” Nani barri yanybayi Jisus yalungi. Baki mili nyuli yanyba nanankanyi nganiyngkanyi, jali kuluka jalyuna, ");
INSERT INTO wrk_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“Ngayu karungka ninya. Walajbakiyi waykalinya. Walajbakiyi. Baki mukulmbakiyi nganyi jalyu, baki wijbakiyi nganyinkurri barndarri.” ");
INSERT INTO wrk_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Yinarramba walajbayi nanda nganinyi jalyunanyi. Walajba nyuli, mukulmbayi nangangi jalyu, baki barlbayi nanankardi barndananyi. Baki nanamuku barri jali yalu najba nanda nganinyi walaykurri, baki manmala yali. Kudanyu yali manmala, ngala yali wajba Kud yalunginkanyi kunybanyi jangkurranyi. Baki yanyba yalungki, “Jalannga ngambala najba nganinyi kunybiykurri jala nyulu lunji nanginkanyi ngalyanyi. Jalannga ngambala najba kunybiykurri.” Barriwa. ");
INSERT INTO wrk_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Baku barri mili jilajbayi Jisus bayunguna yundu nananyina wabudana niji Kalili. Kajamuku yali jilajba nangandurri, baki nyuli milidimba yalunya. ");
INSERT INTO wrk_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Ngala jilajbayi Jisus, baki najba nyuli nganinyi, nangangi niji Madiyu, yingka niji nangangi Libayi, ngala nangangi nijanganjinyi, nangangi niji Yalbayis. Jungkuyi nanda nganinyi barrawuna nyulu wakinkanyi. Waki nyulili Kubaminkanyi. Kuyu nyulili dungala yalunbunanyi, waykanyi Kabamin mambuka. Najba nyuli nanda Madiyu jungunkurri barrawuna Jisuswanyi, baki yanybayi Jisus nangangi, “Jilajbakiyi ngakindu.” Walajba nyuli Madiyu baki jilajba nyuli nangandu Jisusnyina. ");
INSERT INTO wrk_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Jilajba buli bayungu barndarri, nangangi jala barnda Madiyukanyi. Jungkuyi Jisus nanaba. Jarrba nyuli mama nanaba nangandu, baki yali jungku nangandu marda nanganginmuku kandimuku. Jilajbayi yingkamuku nanankurri barrawurri. Yali balkimuku. Kudiyanymuku yalungi, yalili waki Kabaminkanyi, ngala yali maninjaku. Yalili kuyu dungala yalunbunanyi Kabaminkanyi, ngala kudukudu dungala yalili kuyu, bakili yalu kilimba kudiya nanda dungala yalungi barri. Malumba yalungki wardamba mamanyi nangandu Jisusnyina. ");
INSERT INTO wrk_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Jawudanymuku yali jilajba nanankurri barndarri. Yali milidimbawarrmuku yuwanyi Musiskanyi. Jilajba yali barndarri, baki najba yali Jisus wardambikurri nangka mamanyi yalundu balkimukunyina. Ngajaka yali kandimuku nangangi Jisuskanyi, “Wanyingkanyi wardamba nangka narringi milidimbawarr mamanyi yalundu balkimukunyina. Wanyingkanyi.” ");
INSERT INTO wrk_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Manku nyuli nanda yalungi jangkurr Jisuswanyi, baki nyuli jananganja yalunya, “Mikuwali badajba yarrbirra yalundurri jala yalu kunyba mankanyi, ngala nyulu badajba yalundurri jala yalu balki mankanyi. Baki nani barri, miku ngayiyanyi badajba nanganbunanyi Kudnanyi milidimbiji yalunya jala yalu jungku kunyba. Ngala ngayi badajba milidimbiji yalunya jala yalu jungku balki.” Nani barri jananganjayi yalunya Jisuswanyi. Barriwa. ");
INSERT INTO wrk_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Nanamuku kandimuku Junkanyi Ngurrunbawarrayngka, baki nanamuku Barasimuku, kudiyana barri miku yalungkiyanyi wardamba mamanyi barndaykamba, ngala yalungki mankumanku nangangi Kudkanyi yurrngumba barri. Nanamuku Barasimuku, kudanyu yalili durrijba nanda yuwa nangangi Musiskanyi, ngala miku yaliyanyi jingkijba Kud. Kudiyana barri miku yalungkiyanyi wardamba mamanyi, ngala yali yanyba mududu nangangi Kudkanyi. Nanamanji kambana barri, miku yalungkiyanyi wardamba mamanyi kandimuku Junkanyi baki Barasimuku. Yingkamuku yali jilajba nangandurri Jisusyurri, baki ngajaka yali, “Kudiyana barri miku yalungkimi wardamba mamanyi kandimuku Junkanyi, baki Barasimuku. Miku yalungkimi wardamba mamanyi kudiyana, ngala nganyinmuku kandimuku yalungka wardamba mamanyi yurrngumba barri. Wanyingkanyi yalu miku kudiyana miku jarrkanyi mama. Wanyingkanyi.” ");
INSERT INTO wrk_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Jananganjayi yalunya Jisuswanyi, “Nanda buyingkinyi nawinganja, kajamuku kandimuku yalu nangandu ngala nyulu jalannga wudumba maninganja. Miku yaliyi jungku birrkalanyi, ngala yalungka wardamba kajanyi mamanyi. ");
INSERT INTO wrk_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Ngala baku barri janyulu jarimba nanda nangangi nawinganja yingkawanyi. Baki nanamanji barri, miku yaliyi jarrba mama nanganginmukunyi kandimukunyi, ngala jayalu ngindu muwa nangangi.” Barriwa. ");
INSERT INTO wrk_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Mili barri yanybayi Jisus yalungi nayi barri, “Jaliyi jumbala bakarrawijba, baki ngambala ngarrkadaba jumbala yingkayudinyi rakiyudinyi. Jaliyi buyingkinyi nanda raki, jala ngambala wakardaba nanda jumbala, baki bayakardangujbangka nanda buyingkinyi raki. Baki mili barri bakarrawijbaja nanda jumbala, bayakardangujbangkangangi nanda raki. Baki nanankardi barri ngambala wudumba waluwinyi raki ngarrkadaykanyi. Barriwa. ");
INSERT INTO wrk_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Baki mili janarringka mankumanku nanginkanyi jangkurranyi. Ngambala yarrijba ngarrki krayibkanyi kalawunyi bindawarrana. Nanda bindawarra waba jibkanyi. Jaliyi ngambala yarrijba buyingkinyi ngarrki kalawunyi waluwinyi bindawarrana, baki nanda balki. Jalija nanda ngarrki ngujbul bijal, baki dumbaja nanda waba bindawarra. Bunyarrijba janangka nanda ngarrki, baki bakarrawijbaja nanda bindawarra. Ngala ngambala yarrijba buyingkinyi ngarrki krayibkanyi kalawunyi buyingkinyi waba bindawarra. Jalija nanda ngarrki ngujbul bijal, baki yuku nanda bindawarra. Mikuwali bakarrawijba nanda waba. Miku nangkiyi bunyarrijba nanda ngarrki. Jungkuka kunyba barri kalawunyi bindawarrana yurrngumba barri.” Nani barri yanybayi Jisus yalungi. Barriwa. ");
INSERT INTO wrk_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Baku barri burrandijba yali nananyina yajina jali jardijba nanda karnba barrinani daburrul. Nanda karnba yami kunyba jarrkanyi. Burrandijba yali, Jisus baki nanganginmuku kandimuku, ngala nyuli Sadidi. Ngala yali burrandijba, baki dulabayi yami kandimukunyi. Dulaba yali yami, baki jarrba yali. ");
INSERT INTO wrk_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Ngala kudiyanymuku Barasimuku jalili yalu kudanyu durrijba nanda yuwa nangangi Musiskanyi, yali nanaba marda yalundu. Yali najba kandimuku dulaykurri yami baki jarrkurri yaji. Baki yanyba yalungki, “Yalu dulabangka yami karnbananyi. Nani barri yalu wakingka.” Baki yanyba yali nangangi Jisuskanyi, “Najbakiyi yalunya, nganyinmuku kandimuku. Yalu dulabangka yami jarrkanyi. Nani barri yalu wakingka. Nani barri yalu jungkuka balkina yuwana Musiskanyi. Yanybaka nanda yuwa, mardakimi nganinyi miku waki Sadidi barri. Yuku yalu waki yingkana kambana, ngala miku Sadidi. Jala barri Sadidi, ngala nganyinmuku kandimuku yalu wakingka, yalu dulabangka yami. Wanyingkanyi yalimi miku ngayangayijba nanankanyi yuwanyi Musiskanyi. Wanyingkanyi.” ");
INSERT INTO wrk_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Jananganjayi yalunya Jisuswanyi, “Narri jingkijbangka nanda jangkurr najana Kudkanyi, jala karu ngambalanya nanankanyi walkurrayngka mambukanyi Dayibidkanyi. Narri jingkijbangka nanda jali nyulu yabimba. Jali yalu birrkalanyi, Dayibid baki nanamuku yalu nangandu, baki wanyimbayi Dayibid. ");
INSERT INTO wrk_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Ngankijba nyuli kalawunyi walkurranyina jurjina Kudkanyi, baki wajbayi Dayibid dambanyi mambukawanyi jurjkanyi. Jarrba yali nanda damba. Nanamanji barri nanda malbu, niji Yabiyadarr, nyuli walkurra mambuka jurjkanyi. Jarrba yali nanda damba. Ngala nanda damba, nanda kudukudu yaji nangangi Kudkanyi. Nanda yuwa nangangi Musiskanyi yanybaka, ngawamba mambukamukunyi jurjkanyi, ngawamba yuku yalu jarrba nanda kudukudu mama. Mikuwali yingkawanyi, ngawamba mambukawanyi jurjkanyi. Ngala barimbayi nanda yuwa Dayibidwanyi. Jarrba nyuli nanda mama, baki yalu nangandu.” ");
INSERT INTO wrk_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Mili barri yanybayi Jisus yalungi, “Wankalana kamambarra yabimbayi nganinyi Kudwanyi. Baki yanybayi Kud nangangi nganiyngkanyi, ‘Janarri waki 6 kambana, baki munganawa janarri wuyalijba. Jalija narri wuyalijba, baki janarri jungku kunyba barri.’ Nanyina kambana jala yalu wuyalijba, yabimbayi nanyina kambana Kudwanyi. Yabimba nyuli nanyina kambana yalungi nganinyimukuyngka. ");
INSERT INTO wrk_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Ngayu Buwanya Bukambijuyngka narringi. Ngayu mambuka bukambijuyngka narringi yurrngumba barri. Ngayu mambuka narringi, jala narri waki, baki jala narri jungku. Marda ngayu mambuka nanankanyi yajinyi jala narri yabimba Sadidi barri.” Nani barri jananganjayi yalunya Jisuswanyi. ");
INSERT INTO wrk_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Kamu barri Sadidi wijbayi Jisus barrawuyabarrawuyarri, baki ngankijba nyuli jurjina nanaba. Bayakarda nanda jurj. Nanaba jurjina jungkuyi nganinyi jirdi balkinyi marninyi. Mikuwali marrimba yaji. Mardil nangangi marni. Barriwa. ");
INSERT INTO wrk_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Kudiya nanaba jurjina Barasimuku, yali nulijba balanjankanyi Jisus. Nulijba yali Jisuskanyi, nyulu yabimbikanyi balki yaji nanankanyi yuwanyi Musiskanyi. Baki nanangajba yali Jisus naji jaliyi nyulu kunymamba nangangi marni nanamanji Sadidi. Nanamuku Barasimuku yalili yanyba, jaliyi yingkawanyi kunymamba yingka Sadidi barri, baki nanda balki, wakingkangangi nyulu Sadidi. Nanangajba yali Jisus, naji jaliyi nyulu kunymamba nangangi marni Sadidi. ");
INSERT INTO wrk_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Yanybayi Jisus nganiyngkanyi jirdi balkinyi marninyi, “Kabukawa.” Baki jilajba nyuli nangandurri Jisusyurri. Karrinjayi walu nangandu. ");
INSERT INTO wrk_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Baki yanybayi Jisus yalungi Barasimukuyngka. Ngajakayi yalunya, “Wanyi yanybaka ngambalangi yuwa, ngambala wakinkanyi Sadidi. Wanyi yaji marda ngambalimi yabimba Sadidi. Kunyba yaji kuna. Balki yaji kuna. Yuku kuna ngambalaja wankamba yingka nganinyi. Yuku kuna ngambalaja kurdanba. Wanyi yanybaka nanda yuwa ngambala yabimbikanyi yaji Sadidi. Wanyi barri yanybaka.” Barriwa. Ngala miku yaliyanyi jananganja Jisus. Karda yali jungku. ");
INSERT INTO wrk_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Wangkawangkijbayi Jisus yalungi, baki kijiwijba nyuli yalungi. Ngindu nyuli muwa yalungi, jardibirringangi yali muwa. Miku yaliyanyi ngindu muwa nanankanyi nganiyngkanyi jirdi balkinyi marninyi, ngala jardibirri yali muwa nangangi. Yanybayi Jisus nanankanyi nganiyngkanyi. Jirrinyba nyuli nanda nganinyi, “Manjijbakiyi nganyingka marni.” Manjijba nangki marni, baki kunybijbayi nanda marni. Yuku barri nyuli yabijba marni barrinani nanda yingka marni. ");
INSERT INTO wrk_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Ngala nanamuku Barasimuku, yali ngarrangarra muwa nangangi Jisuskanyi. Yinarramba yali walajba, baki barlba yali jurjnanyi. Barlba yali yalundurri kandimukuyngkurri Yirudkanyi, baki yanyba yalungki yalu kurdanbikanyi Jisus. Barriwa. ");
INSERT INTO wrk_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","8","Ngala barlbayi Jisus karri, marda nanganginmuku kandimuku nangandu. Barlba yali karri barri kanjarri. Ngala yingkamuku yali jilajba nangandurri Jisusyurri. Kajamuku yali jilajba nangandurri yingkananyi yajinanyi, baki yingkananyi yajinanyi. Yingkamuku yali jilajba kulani Jirusalimnanyi, baki Judiyananyi, baki Yidumiyananyi. Yingkamuku yali jilajba bayunguna Kalilinanyi. Yingkamuku yali jilajba langina Dayananyi baki Sayidunnanyi. Yingkamuku yali jilajba karrurrinybananyi bundalnanyi Jurdananyi. Kajamuku yali jilajba nangandurri mijimbangu, mankungangi yalunjali yanybikurri nangangi Jisuskanyi, nanda yaji jali nyulu yabimba. ");
INSERT INTO wrk_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Bunundijba yali nangandurri Jisusyurri kajamuku barri. Jululumba yalungki, yalu karrinjankanyi bundu nangandu barri. Baki karuyi nanganginmuku kandimuku Jisuswanyi, yalu wudumbiji muwarda nangangi. Jayalu kuyu muwarda bundu bijalina jali nyulu karrinja nanaba. Jaliyi yalu bunundijba kudanyu barri, jaliyi yalu jululumba Jisus, baki janyulu ngankijba muwardana, baki janyulu milidimba yalunya, ngala nyulu jungku muwardana. ");
INSERT INTO wrk_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Wabula barri kunymambayi Jisuswanyi kajamuku jali yalu lunji. Baki nanankardi barri kajamuku jali yalu lunji, yali jilajba bundu nangandurri. Jululumba yalungki, nulijbangangi yali marrimbikanyi Jisus. Nulijba yali marrimbikanyi Jisus, nyulu kunymambiji yalunya. Nanankardi barri yalungki jululumba, yalu karrinjankanyi bundu nangandu Jisusnyina. ");
INSERT INTO wrk_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Yingkamuku yali nanaba nangandu, jali yalu wuwarryudi mankanyi. Jali yalu najba Jisus wuwarrmukunyi, baki yirrba yali jambarri nganinyimuku wuwarryudi, baki kaya yali kudanyu barri, “Ninji barri jandanyi nangangi Kudkanyi. Ninji nangangi jandanyi.” Barriwa. ");
INSERT INTO wrk_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Ngala maramarambayi wuwarrmuku Jisuswanyi. Wijba yali karunkanyi nangangi Jisuskanyi, wanyi nyuli. Maramaramba nyuli yalunya. Barriwa. ");
INSERT INTO wrk_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Baku barri kirrijbayi Jisus kingkarri dungalana. Nulijba nyuli jawudanymukuyngka yalu jilalaykanyi nangandu yurrngumba barri. Baki kaya nyuli yalungi, nanganginmukuyngka kandimukuyngka. Jilajba yali nangandurri. ");
INSERT INTO wrk_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Baki nyuli yarrijba 12 nganinyimuku, nanganginmirra kandimuku. Yanyba nyuli yalungi, “Janarri jilalajba ngakindu, baki jangayu milidimba narrinya. Baki baku barri jangayu manjijba narrinya yingkarri yajiyurri, baki yingkarri yajiyurri. Baki janarri milidimba yalunya yingkamuku nanankanyi kunybanyi jangkurranyi Kudkanyi. ");
INSERT INTO wrk_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Jangayu yabimba narrinya ngiruka, narri yabimbikanyi ngiruka yaji. Nanamuku jala yalu wuwarryudi mankanyi, janarri jakajba wuwarr yalunbunanyi mankanyinanyi.” Barriwa. ");
INSERT INTO wrk_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Yarrijbayi 12 nganinyimuku nanganginmuku kandimuku Jisuswanyi. Nayinda barri yalungi niji. Sayimin barri, yingka niji nangangi Bida. ");
INSERT INTO wrk_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Marda buwakula, Jayims baki Jun. Bulangi nijanganjinyi, niji nangangi Sibidi. Yanybayi Jisus bulangi nanankuya nganinyiwuya, buli barrinani ngurrwangka, baki nijarrijbayi bulanya yingka niji, ‘Nganinyiwuya Ngurrwangka.’ ");
INSERT INTO wrk_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Yingkamuku yalungi niji Yandru baki Bilib, marda Bardulumu baki Madiyu, marda Dumas. Baki yingka nanamannga niji Jayims, ngala nangangi nijanganjinyi, niji nangangi Yalbayis. Baki mili barri Dadayus, baki yingka nanamannga niji Sayimin, ngala nangangi yaji niji Kayina. ");
INSERT INTO wrk_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","Baki Judas Yiskariyud. Nyuli nanda jali baku nangka yangkalamba nanganbunanyi Jisusnanyi, baki karuyi mambukamuku jurjkanyi wanjawa jayalu wakaramba Jisus. Barriwa. ");
INSERT INTO wrk_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Wijbayi Jisus nanganginkurri ngardanganjarri barndarri. Baki kajamuku yali jilajba nangandurri nanaba, walkurra muramuku. Karrinja yali lukuluku nangandu wujuju bayungu. Baki miku yaliyi jarrba mama Jisuswanyi baki nanganginmukunyi kandimukunyi. Miku yaliyi jarrba mama, karrinjangangi muramuku lukuluku yalundu yurrngumba, ngala milidimbayi yalunya Jisuswanyi. ");
INSERT INTO wrk_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Ngala nanganginyi mungkijimukunyi, yali manku jangkurr Jisuskanyi baki kajamukuyngka nangandu. Manku yali jangkurr nangangi, nyuli nananyina barndana, baki kajamuku yali nangandu lukuluku karrinja. Baki yali jilajba nanankurri wudumbiji Jisus. Ngamu nyuli Jisus mudu, baki nanankardi yali jilajba wudumbiji. Ngala miku nyuliyanyi mudu. Miku. ");
INSERT INTO wrk_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Kudiyanymuku jali yalu milidimbawarrmuku yuwanyi, wanbiya yali kulani Jirusalimnanyi. Karu yalunjali yingkamuku nangangi Jisuskanyi, “Nayinda Jisus, nyulu yabimbaka ngiruka yaji, nyulu jakajbangka wuwarr, wakingkangangi nyulu nangangi mambukanyi wuwarranyi Sayidinkanyi. Nanangini Sayidinwanyi nyulu yabimbaka Jisus ngiruka, yabimbikanyi ngiruka yaji, baki nanankardi nyulu jakajbangka wuwarr.” Nani barri yalunjali karu nangangi Jisuskanyi milidimbawarrmukunyi. ");
INSERT INTO wrk_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Ngala yanybayi Jisus yalungi muramukuyngka, jali yalu jungku nangandu. Yanyba nyuli yalungi, “Jalimi ngana yabimba ngiruka jakakaykanyi wuwarr mambukawanyi wuwarranyi, baki nanda barrinani nangka jakajbangka Sayidin. Yanka barri nangka jakajba Sayidin. Yanka barri. ");
INSERT INTO wrk_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Jalimi yalu mungkiykurramba kurdanbiji, baki baku barri janyulu mikuyaji mungkijinyi. Janyba jayalungka bukamba barri. ");
INSERT INTO wrk_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Jalimi yalu mungkiykurramba kurdanbiji, yalu jala kuluka yingamalina barndana, baki baku barri janyulu mikuyaji mungkijinyi nanaba barndana. ");
INSERT INTO wrk_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Baki jalimi yalu mungkiykurramba kurdanbiji Sayidin marda wuwarrmuku, baki baku barri janyulu mikuyaji wuwarranyi, kurdanbangangi jayalungka. ");
INSERT INTO wrk_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Mikuwali ngankijba nganinyi barrawuna jala nanda nangangi barrawu ngirukanyi nganiyngkanyi. Miku nyuliyi ngankijba barrawuna maninjakuji yaji. Waluwa barri, marda nyulimi kijijba nanda ngiruka nganinyi kurulyudinyi nanangini maninjakuwanyi. Jala nyulu kijijba nanda ngiruka nganinyi, baki yuku barri janyulu maninjakujba nangangi yaji. ");
INSERT INTO wrk_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Jala nganinyi yanybaka balki jangkurr, jala nyulu yabimbaka yinini yinini balki yaji, baki yuku nyulu manjamanjambaka nanda balki yaji Kudwanyi. Yuku nyulu manjamanjambaka nanda yinini yinini balki yaji nangangi, jaliyi nanda nganinyi nyulu ngindu muwa jungunkanyi balki. ");
INSERT INTO wrk_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Ngala jala nganinyi yanybaka balki jangkurr nangangi Kunybanyi Ngarndunyi Kudkanyi, jala nyulu mijba nanda Kunyba Ngarndu Kudkanyi, baki mikuwali manjamanjamba nanda balki yaji Kudwanyi. Miku nyuliyi manjamanjamba nanda balki yaji miykanyi Kunyba Ngarndu nangangi Kudkanyi.” Barriwa. ");
INSERT INTO wrk_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Nani barri yanybayi Jisus yalungi muramukuyngka, yanybangangi yali milidimbawarrmuku nangangi Jisuskanyi, yabimbayi Jisus ngiruka jakaykanyi wuwarr Sayidinwanyi. Barriwa. ");
INSERT INTO wrk_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Baki wanbiya yali barndana ngardanganja nangangi Jisuskanyi marda bababanyamba nyulu yalunya. Karrinja yali danbina barndana. Miku yaliyanyi bunundujba Jisusyurri muramukungangi. Manjijba yali jangkurr nangandurri Jisusyurri, nyulu jilaykanyi, yalu yanybikanyi nangangi. ");
INSERT INTO wrk_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Jungkuyi muramuku nangandu Jisusnyina, baki yali yanyba nangangi, “Nanda ngardanganja nganyi, marda bababanyamba ninji yalunya, danbina yalu jungku. Yalu kujbanka nganyi, ninji jilajbaja yalundurri.” ");
INSERT INTO wrk_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","34","Ngala jananganjayi yalunya Jisuswanyi, “Najba janarri yalunya, ngakinmuku kandimuku nayiba ngakindu. Yalu barrinani ngaki ngardanganja, barrinani ngaki bababanyamba ngayu yalunya. ");
INSERT INTO wrk_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Nanda jala durrijbangka nangangi jangkurr, ngakinkanyi Buwakaya Kingkarri, nanda jala yabimbaka nanda yaji jala nyulu nulijbangka nangangi yabimbikanyi yaji, nyulu barrinani nanda bababanyamba ngayu, nyulu barrinani ngaki ngardanganja.” Nani barri jananganjayi yalunya Jisuswanyi. Barriwa. ");
INSERT INTO wrk_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Mili barri jungkuyi Jisus bundu kanjana, baki nyuli milidimba yalunya yajinyi. Kajamuku yali jilajba nangandurri mankunki nangangi jangkurr, kajamuku muramuku. Bukamba yalungki ngirringirrimba, baki jululumba yalungki barri. Nanankardi barri nyuli ngankijba muwardana, baki jungku nyuli wilina kanjana. Baki milidimba nyuli yalunya muramuku, ngala nyuli jungku muwardana, ngala yali jungku bijalina. ");
INSERT INTO wrk_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Milidimba nyuli yalunya kajanyi jangkurranyi. Muningka nyuli yanyba yalungi, milidimbiji yalunya kajanyi yajinyi. ");
INSERT INTO wrk_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","Muningka yanybayi Jisus yalungi, “Manku nganarri. Wudumbayi kudukudu yami nganinyiwanyi, barrinani daburrul yami. Janyba nyuli nanda yami jambarri jardiykunumbikanyi yaji. ");
INSERT INTO wrk_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Jawuda yami yirrbayi yubalina, baki wanbiyayi julakimuku. Jarrba yali nanda mama yubalina julakimukunyi. Barriwa. ");
INSERT INTO wrk_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Marda jawuda yami yirrbayi didirrina yajina. Walajbayi daburrul karnba, ngala bijal jamba didirrina yajina. ");
INSERT INTO wrk_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Mikuyaji landurranyi jardijbayi didirrina yajina, baki janyba nangki. Yajbayi nanda karnba ngardarawanyi, baki janyba nangki. Janyba nangki, mikuyajingangi landurranyi. Barriwa. ");
INSERT INTO wrk_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Marda jawuda yami yirrbayi yajina jali jardijba nyilanyila. Walajbayi nanda yami wuju, marda walajbayi nanda nyilanyila, baki munybayi yaji. Jardijbayi juju kingkarri nanda nyilanyila, ngala ngawamba madilijbayi nanda daburrul yami. Mikuwali jardijba nani kingkarri. Munybayi yingkawanyi. Mikuyaji mamanyi nangandu daburrulina. Barriwa. ");
INSERT INTO wrk_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Marda mili jawuda yami yirrbayi kunybana jambana. Nanda karnba jardijbayi walkurra. Kudukudu yami nangandu jardijbayi. Yingka karnba yami nangangi kaja bijal, yingka karnba yami nangangi kaja, baki yingka karnba yami nangangi kajamirra.” Barriwa. ");
INSERT INTO wrk_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Yanybayi Jisus yalungi, “Jaliyi narri nulijba jingkiykanyi ngaki jangkurr, baki manku narri kudanyu barri.” Barriwa. ");
INSERT INTO wrk_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Kamu barri kajamuku yali jilajba nanganbunanyi Jisusnanyi. Wijba yali yalunginkurri barndarri. Ngala nanganginmuku 12 kandimuku yali wambu jungku nangandu Jisusnyina, marda jawuda mili yalundu. Baki yanyba yali nangangi Jisuskanyi, “Miku nurrimi jingkijba nanda jangkurr nganyi yaminyi. Karukiyi nurrunya mili nanamannga jangkurr.” Barriwa. ");
INSERT INTO wrk_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Ngala yanybayi Jisus yinini jangkurr yalungi barri, “Narri jingkijbangka Kud, nyulu marukangka muwa narringi, nyulu lalanbaka narrinya yurrngumba barri. Ngala yingkamukunyi, miku yalimi jingkijba Kud, nyulu lalanbawarr. Baki nanankardi barri muningka ngayu yanyba yalungi, ngayu milidimbiji yalunya. ");
INSERT INTO wrk_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Nanda jangkurr najana Kudkanyi yanybaka nanginmukuyngka jala yalu muningka manku ngaki jangkurr. Nayi barri nanda jangkurr, “‘Jungkuka yalu yamiyudi, ngala miku yalimi najba ngaki yaji. Jungkuka yalu kuwardayudi, ngala miku yalimi manku ngaki yaji. Jalimi yalu manku ngaki jangkurr, jalimi yalu jingkijba ngaki jangkurr, baki yalimi ngindu muwa, yalu jungunkanyi balki. Yalungkimi yangkalamba yalunbunanyi balkinanyi yajinanyi, baki ngayimi manjamanjamba yalungi balki yaji. Ngala miku yalimi najba ngaki yaji, miku yalimi manku ngaki yaji, baki nanankardi barri miku ngayiyi manjamanjamba yalungi balki yaji.’” Barriwa. ");
INSERT INTO wrk_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Mili yanybayi Jisus yalungi kandimukuyngka, “Miku kuna narrimi jingkijba nanda ngaki jangkurr jali ngayu muningka yanyba yaminyi. Jaliyi narri miku jingkijba nayinda jangkurr, baki yanka janarri jingkijba yingka jangkurr jalija ngayu muningka yanyba narringi. ");
INSERT INTO wrk_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Manku nganarri. Jangayu mili karu narrinya nanankanyi yaminyi. Nanda daburrul yami, nanda barrinani jangkurr nangangi Kudkanyi. ");
INSERT INTO wrk_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Jawuda yami yirrbayi yubalina. Jawuda yalu manku nangangi jangkurr Kudkanyi, ngala yurlwa yalu nanganginkanyi jangkurranyi. Nanda jala yalu yurlwa, yalu barrinani nanda yubal. Nanda yubal jardibirri, baki mikuwali jardijba mama nanaba. Jarrbayi yami yubalina julakimukunyi. Baki nani barri yalu jardibirri kurdulu. Nanda jangkurr jala yalu manku, jawurrbangka nanda jangkurr yalunbunanyi Sayidinwanyi. Barriwa. ");
INSERT INTO wrk_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","17","Jawuda yami yirrbayi didirrina yajina. Jawudawanyi yalu kuyu nangangi jangkurr Kudkanyi, baki yalu mirnarrijba muwa. Ngala yingkamuku yalu ngirrwa yalungi, kuyungangi yali nanda jangkurr. Baki miku yalimi mili nulijba nanankanyi jangkurranyi Kudkanyi. Yalu yingijbangka nanda jangkurr. Yalu jala yingijbangka nanda jangkurr nangangi Kudkanyi, yalu barrinani nanda didirr yaji. Nanda yami jali walajba didirrina yajina, mikuyaji landurranyi. Yuku wankijbayi bijal, ngala yajbayi yaji ngardarawanyi, baki janyba nangki. Nanda karnba wankijbayi bijal didirrina yajina. Nanda didirr yaji, nanda barrinani yalu jala bijal kuyu nangangi jangkurr Kudkanyi. Ngala jala yingka ngirrwa yalungi, baki miku yalimi mili nulijba jangkurranyi Kudkanyi. Yingijba yalu nangangi jangkurr. Barriwa. ");
INSERT INTO wrk_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","19","Jawuda yami yirrbayi yajina jali jardijba nyilanyila. Jawuda yalu mankuka jangkurr nangangi Kudkanyi. Bijal yalu kuyungka nanda jangkurr, ngala kudanyu yalu nulijbangka yingkanyi yajinyi. Nulijbangka yalu kajanyi dungalanyi marda yajinyi. Yalu kuliwijba yajinyi kudanyu barri. Yalu jala kuliwijba yajinyi, yalu barrinani nanda jamba jala jardijba nyilanyila. Nanda daburrul yami jardijbayi mardil, mikuyaji yaminyi. Nani barri yalu jala kuliwijbangka yajinyi, ngala miku yalimi nulijba nanganginkanyi jangkurranyi Kudkanyi. Jardijba yalu mardil kurdulu nangangi Kudkanyi. Barriwa. ");
INSERT INTO wrk_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Jawuda yami yirrbayi kunybana jambana. Jawudawanyi yalu mankuka jangkurr nangangi Kudkanyi. Yalu kuyungka nanda jangkurr, baki yalunya kunymambaka yingkamuku, yalu mirnarriykanyi muwa. Jala yalu kunymamba yingkamuku, yalu barrinani nanda kunyba jamba. Nanda karnba jali jardijba kunybana jambana, yingka karnba yami nangangi kaja bijal, yingka karnba yami nangangi kaja, baki yingka karnba yami nangangi kajamirra. Nani barri yalu jala kunymamba yingkamuku, yalu mirnarriykanyi muwa. Yingkamuku yalu jungkuka bijal kunyba, yingkamuku yalu jungkuka kunyba, baki yingkamuku yalu jungkuka kunybamirra.” Barriwa. Nani barri karuyi yalunya nanankanyi jangkurranyi yaminyi Jisuswanyi. ");
INSERT INTO wrk_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Mili barri yanybayi Jisus yingka jangkurr yalungi milidimbikanyi yalunya. “Wudumbaka mirnbi nganinyiwanyi, baki langandabangka kingkarri, nyulu naykanyi bukamba yaji mungana barri. Miku nyulimi yarrijba kalawuyngkurru darladarlana. Miku. Murumbaja mirnbi darladarlawanyi. Ngala nyulu langandabangka mirnbi kingkarri, naykanyi bukamba yaji. ");
INSERT INTO wrk_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Baki nani barri jalija nyulu ngadijba nangangi yaji nganinyiwanyi, baki baku barri janyulu wakaramba nanda nangangi yaji yingkawanyi. Janyulu wakaramba nanda jali nyulu ngadijba. Baki jalija nyulu karda karu yingka yajinyi, baki baku barri jayalu jingkijba nanda yaji bukambijunyi. Jayalu jingkijba nanda jali nyulu karda karu yingka. ");
INSERT INTO wrk_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Jaliyi narri nulijba jingkiykanyi yaji, baki marda narrimi manku yaji. Marda narrimi kudanyu manku yaji, jaliyi narri nulijba jingkiykanyi yaji.” Barriwa. ");
INSERT INTO wrk_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Baki mili yanybayi Jisus yalungi, “Mankumankuwa narri, nanda jala narri manku. Jaliyi narri wajba nganinyi kajanyi yajinyi, jabarri narrinyaja wajba baku barri. Wajbaja narrinya kajanyi yajinyi Kudwanyi. Jaliyi narri ngirrwa nganiyngkanyi, jabarri baku barri ngirrwaja Kud narringi barri. ");
INSERT INTO wrk_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Jaliyi narri kudanyu manku ngaki jangkurr, baki janarri jingkijba mili yaji ngaki. Ngala jaliyi narri miku kudanyu manku ngaki jangkurr, baki janarri mamanumba nanda ngaki yaji.” Barriwa. ");
INSERT INTO wrk_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Baki mili barri yanybayi Jisus yalungi, “Jangayu karu narrinya nanankanyi jangkurranyi jala lalanba narrinya Kudwanyi. Jangayu muningka yanyba narringi. Jarrbalambayi daburrul yami jambana nganinyiwanyi. ");
INSERT INTO wrk_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Ngala miku nyuliyanyi mili waki jardiykunumbikanyi nanda karnba. Muningka nyuli jungku kajana kambana. Miku nyuliyanyi mili waki jardiykunumbikanyi nanda karnba. Ngala baku barri walajbayi nanda wuju waykalinya. Ngala miku nyuliyanyi jingkijba yanka barri jardijbayi karnba. Miku. ");
INSERT INTO wrk_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Manjijbayi karnba kingkarri jambawanyi. Waluku walajbayi wuju bayakarda waykalinya, baki baku barri jardijbayi walkurra yamiyudi. ");
INSERT INTO wrk_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Jali kunyunyu nanda yami, baki birrirrinja nangka nyulu wudumbikanyi nganinyiwanyi. Baki wudumba nyuli nanda yami jarrkanyi jali bukamba kunyunyu barri. Nanda nganinyi jali nyulu jarrbalamba daburrul yami, nyulu barrinani Kud. Yarrijbayi nangangi jangkurr ngambalandu kurduluna Kudwanyi. Jardijbayi nanda daburrul yami jambana, jardijbayi walkurra karnba yamiyudi. Birrirrinja nangka wudumbikanyi nganinyiwanyi. Baki nani barri mankumankuyi ngambalaka nanankanyi nanganginkanyi jangkurranyi, baki jardijbangka nanda jangkurr ngambalandu kurduluna. Baki baku barri ngambalaka birrirrinja durriykanyi nangangi jangkurr Kudkanyi. ");
INSERT INTO wrk_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Mili barri nyuli milidimba yalunya Jisuswanyi, “Jangayu mili karu narrinya nanankanyi jangkurranyi, jala lalanba narrinya Kudwanyi. Mili barri jangayu muningka yanyba narringi. ");
INSERT INTO wrk_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Nanda nukunu yami, yuku nanda bayakarda yami. Janybaka yami jambana nganinyiwanyi. ");
INSERT INTO wrk_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Ngala baku barri walajbangka wuju nukunu. Jardijbangka juju barri kingkarri, walkurramirra nanda nukunu. Yabimba yalu jabaka nukununa kingkarrinyina bangani julakimukunyi. Nani barri jardijbangka walkurra nanda bayakarda yami. Barriwa.” Nani barri muningka yanybayi Jisus yalungi. Nanda nukunu yami jali jardijba, waluku nanda kurdalirri kurnda, ngala baku barri janyulu jardijba wunanybala. Nanda barrinani nayi barri. Waluku barri ngawamba kujajarra yali kuyu nanda jangkurr nangangi Jisuskanyi, yali durrijba nangangi yuwa, ngala baku barri mili yali kuyu nangangi jangkurr, baki mili, baki mili yurrngumba barri. Baku yali jungku kajamuku jali yalu kuyu nangangi jangkurr wirdikudukudumukunyi. Barriwa. ");
INSERT INTO wrk_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","34","Nanamanji barri mikukiyanyi yanyba Jisus yurlurrmba jangkurr yalungi muramukuyngka. Yurrngumba nyuli muningka yanyba jangkurr yalungi milidimbikanyi yalunya. Kaja jangkurr nyuli muningka yanyba yalungi. Jali yalu jingkijba yingka jangkurr, baki nyuli yanyba mili jangkurr yalungi barri. Ngala jali nyulu jungku ngawamba yalundu nanganginmukunyina kandimukunyina, baki mili nyuli yanyba yalungi. Yanyba nyuli yurlurrmba jangkurr yalungi, yalu jingkiykanyi nanda jali nyulu muningka yanyba. Barriwa. ");
INSERT INTO wrk_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Nananyina kambana jungkuyi Jisus muwardana ngala nyuli milidimba yalunya. Kamu barri mungarri yanybayi Jisus yalungi nanganginmukuyngka kandimukuyngka, “Jangambala birlbirdamba kanja karrurrinybarri.” ");
INSERT INTO wrk_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Baki ngankijba yali kandimuku nangandu muwardana, baki barlba yali karri muwardana. Yingkamuku muwarda nanaba marda bijalina. Jawudamuku yali ngankijba nanamukunyina muwardana, baki barlba yali karrurrinybarri marda nangandu. ");
INSERT INTO wrk_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Walajbayi yunkurr karrina, baki warrmbayi yaji kudanyu barri. Lakululumbayi yunkurrwanyi wabuda, baki walajbayi juju kingkarri lakululu. Ngankijbayi wabuda kalawuyngkurru muwardana, baki ngurrulijbawali nanda muwarda. ");
INSERT INTO wrk_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Ngala kulukayi Jisus bunyina muwardana. Kulukayi Jisus nanganginyina kulajbina. Ngankijbayi wabuda muwardana, ngala nyuli yuwajiwa kuluka kalawuyngkurru. Dulaba yali Jisus kandimukunyi. Dulaba yali, baki yanyba yali nangangi. “Milidimbawarr. Miku ninjiyi kuna marrala, ngambalaja ngurrulijba. Marrimbakiyi ngambalanya mardarda.” ");
INSERT INTO wrk_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Walajbayi Jisus, baki kudanyu yanybayi yunkurranyi marda kanjanyi, “Kardakiyi jungku. Kanangurrijbaja lakululu marda yunkurr.” Baki kanangurrijbayi yaji, marda yunkurr marda lakululu. ");
INSERT INTO wrk_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Baki yanybayi Jisus yalungi kandimukuyngka, “Wanyingkanyi narri marrala. Wanyingkanyi. Miku kuna nganarriyi jingkijba, jangayu lalanba narrinya. Jalimi nganarri kudanyu jingkijba, baki miku narriyi marrala.” ");
INSERT INTO wrk_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Ngala manmala yali nanganginmuku kandimuku. Manmala yali kudanyu barri, baki yanyba yalungki, “Nayinda Jisus, ngiruka nyulu, walkurra. Kardijbayi yunkurr marda lakululu, jali nyulu jirrinyba yalunya. Walkurra nyulu.” Nani barri yalungki yanyba nangangi. Barriwa. ");
INSERT INTO wrk_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Mili barri yali barlba karri muwardana, Jisus baki nanganginmuku kandimuku, baki kamu yali wanbiya karrurrinybana jambana. Nanda yaji niji Kirasin. ");
INSERT INTO wrk_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Jali walajba Jisus muwardananyi, baki jilajbayi nganinyi nangandurri. Jungkuyi wuwarr nangandu mankanyina. Jilajba nyuli nanamunanyi yajinanyi jalili yalu makaba nganinyiyurru baki jibarriyurru nanaba kumayanguna. ");
INSERT INTO wrk_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","4","Nyulili jungku nananyina yajina jalili yalu makaba kuyuwana. Kuluka nyulili nanaba. Nyuli mudu kudanyu barri, wuwarrngangi nangandu mankanyina. Yalili kijijba nangangi jalu baki darnyi kurulyudinyi, ngala nyulili dalyamba nanda kurul. Mili yalili kijijba kijbakijbayudinyi, ngala nyulili dalyamba kijbakijba marda. Miku yaliyi kijijba nanda mudu mili. Nyuli ngiruka kudanyu barri. ");
INSERT INTO wrk_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Yurrngumba barri kambana baki mungana, nyulili muningka jilalajba nananyina yajina, nyulili muningka kaya, nangkili karlba mankanyi majajayudinyi. ");
INSERT INTO wrk_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Nanda barri mudu, jali nyulu najba Jisus jujunanyi, baki nyuli wirlku nangandurri Jisusyurri, baki mururu nyuli mujina wayka jambana nangandu. ");
INSERT INTO wrk_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","8","Yanybayi Jisus nangangi, “Wuwarr. Walajbakiyi nanganbunanyi mankanyinanyi. Walajbakiyi.” Ngala kayayi nanda mudu nganinyi. Kudanyu nyuli kaya, “Ninji barri jandanyi nangangi Kudkanyi. Wanyimba janinji ngaki. Badajba kuna ninji nanginkurri daji ngana. Nanankanyi kuna ninji jilajba nanginkurri.” Nani barri nyuli kaya nangangi Jisuskanyi. Barriwa. ");
INSERT INTO wrk_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Ngajakayi nanda mudu nganinyi Jisuswanyi, “Wanyi nganyi niji.” Baki jananganjayi nganinyiwanyi, “Ngaki niji Kaja, kajangangi nurru wuwarrmuku kalawuyngkurru mankanyina.” ");
INSERT INTO wrk_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Baki yililikajba nyuli Jisus, “Mikujiyi manjijba yalunya wuwarrmuku nanginbunanyi yajinanyi. Munyajbakiyi yalunya yuwajiwa jungunkurri nayiba yajina.” ");
INSERT INTO wrk_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Bundu barri nanaba lungkulina wardamba yalungki kajamuku bikibikimuku. ");
INSERT INTO wrk_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Baki yililikajba yali Jisus wuwarrmukunyi. Kudanyu yali yililikajba Jisus, “Jalija ninji manjijba nurrunya nanganbunanyi, baki manjijbakiyi nurrunya yalundurri bikibikimukuyngkurri. Janurru ngankijba nanaba bikibikina.” Barriwa. ");
INSERT INTO wrk_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Baki barriwa munyajba yalunya wuwarrmuku ngankiykurri bikibikimukunyina Jisuswanyi. Baki ngankijba yali bikibikina. Baki muningka wirlku yali bikibikimuku. Muningka yali yirrba wayka wabudana. Yirrba yali wayka karnarrana yajina, baki yali bukambiju ngurrulijba wabudana. Nanamuku bikibikimuku yali wirdikudukudumuku, 2000 barri. ");
INSERT INTO wrk_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Ngala nanamuku lalanbawarrmuku bikibikinyi, wirlku yali kula yalunginkurri barrawuyabarrawuyarri. Wanbiya yali, baki karu yalunjali mungkijimuku yalungi bikibikinyi, baki nanankanyi jali yabimba Jisuswanyi. Baki kajamuku yali jilajba nanankurri Jisusyurri naji yaji. ");
INSERT INTO wrk_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Wanbiya yali nangandu Jisusnyina, baki najba yali nanda mudu nganinyi, jali barrin wuwarryudi mankanyi. Ngala miku nyuliyanyi mili muningka kaya. Karda nyuli jungku jumbalayudi. Miku nyuli mudu, ngala kunyba nyuli kulaji. Najba yali nanda nganinyi, baki marrala yali. ");
INSERT INTO wrk_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Baki nanamukunyi jali yalu najba Jisus manjiykurri wuwarrmuku yalundurri bikibikyurri, yalunjali karu yingkamuku. Yalunjali karu yingkamuku jali yalu wanbiya nanaba. ");
INSERT INTO wrk_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Baki yali ngajaka Jisus, janyulu barlba yalunbunanyi yajinanyi. ");
INSERT INTO wrk_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Jali mili ngankijba Jisus muwardana, baki nanangini nganinyiwanyi jali waluwa nyulu wuwarryudi mankanyi, kudanyu nyuli ngajaka Jisus, “Jangayu jila nganyindu. Munyajbakiyi ngana jilaykanyi nganyindu.” ");
INSERT INTO wrk_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Ngala jananganjayi Jisuswanyi, “Mikujiyi jilajba ngakindu. Miku. Ngala wijbakiyi nganyinkurri barndarri. Karukiyi yalunya nganyinmuku mungkijimuku, nanankanyi yajinyi jali yabimba Kudwanyi nganyi. Karukiyi yalunya nangangi Kudkanyi, nyuli ngindu muwa nganyi, baki nyuli kunymamba ninya mankanyi.” Barriwa. ");
INSERT INTO wrk_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Baki wijbayi nanda nganinyi. Jilalajba nyuli nananyina yajina. Yidamba nyuli kaja barrawuyabarrawuya, 10 barri. Baki nyuli karu yalunya nanankanyi jali yabimba Jisuswanyi nangangi, jali nyulu jakajba wuwarrmuku nanganbunanyi mankanyinanyi. Baki bukambiju jali yalu manku nangangi jangkurr, baki manmala yali. Kudanyu yali manmala nanankanyi yajinyi. Barriwa. ");
INSERT INTO wrk_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Wijba yali bayangarrinybarri Jisus baki nanganginmuku kandimuku. Ngankijba yali muwardana, baki birlbirdamba yali bayangarriji. Wanbiya yali, baki walajba yali muwardananyi. Jilajbayi walkurra muramuku nangandurri Jisusyurri, mijimbangu barri. Karrinja yali lukuluku nangandu. ");
INSERT INTO wrk_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Jilajbayi nganinyi nangandurri Jisusyurri. Nyuli mambuka jurjkanyi nananyina yajina, nangangi niji Jayirus. Wanbiya nyuli nanaba nangandu Jisusnyina, baki mururu nyuli wayka nangandu. ");
INSERT INTO wrk_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","Yanyba nyuli nangangi Jisuskanyi, “Ngaki jandanyi, nanda ngila, nyulu lunjika. Lunjika nyulu kudanyu barri. Barringa barri janangka janyba. Janinji kuna jilajba ngakinkurri barndarri, baki janinji marrimba nanda ngila kunymambiji.” Nani nyuli ngajaka Jisus. ");
INSERT INTO wrk_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Walajbayi Jisus baki jilajbayi nangandu nanganginkurri barndarri. Kajamuku yali lukuluku malumba nangandu Jisusnyina jali nyulu jilajba. Jululumba yalili Jisus. ");
INSERT INTO wrk_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Baki yingamali jibarri nanaba yalundu. Nyuli lunji. Ngulya jurrwayi yurrngumba barri. Wabulinyi jurrwayi yurrngumba 12 kindilkurrinyi. ");
INSERT INTO wrk_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Wabula barri nyulili barlba kajayurri yarrbirrayurri. Nyulili wajba yalunya kajanyi dungalanyi. Ngala jaru barri. Miku yaliyala kunymamba nanda jibarri. Yuwajiwa jurrwayi ngulya yurrngumba barri. Lunji nyuli kudanyu barri. Mikuyaji dungalanyi nangandu. ");
INSERT INTO wrk_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Waluwa nyuli manku yalunya yanybikurri nangangi Jisuskanyi, nyuli kunymamba yalunya yingkamuku. Baki nulijba nyuli Jisuskanyi, nyulu kunymambikanyi nangangi mankanyi marda. Jilajba nyuli bayngkani nangandu Jisusnyina. ");
INSERT INTO wrk_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Mankumanku nangki nanda jibarri, “Jaliyi ngayu marrimba nangangi jumbala, baki jangayu kunybijba.” Nani barri mankumanku nangki, baki nanankardi nyuli jilajba bayngkani nangandu Jisusnyina. ");
INSERT INTO wrk_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Baki marrimba nyuli nangangi jumbala. Baki dukujbayi nanda ngulya nangandu. Dukujbayi. Jingkijbayi jibarriwanyi, dukujbayi nanda ngulya, kunybijbayi nangangi mankanyi. ");
INSERT INTO wrk_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Ngala yinarramba barri majabujbayi Jisus mankanyi, jali marrimba jumbala jibarriwanyi. Majabujba nyuli mankanyi. Yangkalamba nangki Jisus, baki yanyba nyuli yalungi, “Wanyingini marrimbayi ngaki jumbala. Wanyingini.” ");
INSERT INTO wrk_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Ngala yanybayi nanganginmuku kandimuku nangangi, “Kajamuku yalu lukuluku nganyindu. Yalili jululumba ninya yurrngumba barri. Wanyingkanyi ninji ngajaka, wanyingini ninya marrimbayi.” ");
INSERT INTO wrk_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Ngala mili kulwayi Jisus yalungi naji nanda jali marrimba nangangi jumbala. ");
INSERT INTO wrk_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Ngala nanda jibarri, jingkijba nyuli, kunybijbayi nangangi mankanyi, baki marrala nyuli kudanyu barri. Birrirra nyuli mankanyi nangangi. Ngala jilajba nyuli nangandurri Jisusyurri, baki mururu nyuli wayka nangandu. Baki karu nyuli Jisus nanganginkanyi mankankanyi. ");
INSERT INTO wrk_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Yanybayi Jisus nangangi, “Jibarri, mikujiyi marrala ngaki. Ninji kunybijbangka, kuyungangi ninji ngaki jangkurr. Wijbakiyi nganyinkurri barndarri. Janinji jungku mardumardu muwa.” Barriwa. ");
INSERT INTO wrk_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Ngala yuwajiwa yanybayi Jisus jibarrinyi, baki wanbiyayi kudiya nanganbunanyi barndananyi mambukananyi. Jilajba yali nangandurri mambukarri Jayirusyurri, baki karu yali, “Janyba nangki nganyi jandanyi ngilayurru. Janyba nangki. Marda nyulimi miku jilajba nanda milidimbawarr nganyinkurri barndarri. Marda nyulimi wambu jungku, janybangangi nangki nganyi jandanyi ngilayurru.” ");
INSERT INTO wrk_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Ngala yurlwayi Jisus nanankanyi jangkurranyi. Manku nyuli, ngala yurlwa nyuli. Ngala yanyba nyuli nanankanyi mambukanyi, “Mikujiyi marrala yajinyi, ngala kuyukiyi ngaki jangkurr.” Barriwa. ");
INSERT INTO wrk_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Baki yanybayi Jisus yalungi muramukuyngka, “Miku janarri mili jilajba ngakindu. Miku.” Ngala ngawamba kujarra yingamali kandimuku yali mili jilajba nangandu. Yali Bida, baki buwakula Jayims baki Jun. Ngawamba yali mili jilajba nangandu, marda nanda mambuka Jayirus. ");
INSERT INTO wrk_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Mili yali jilajba, baki wanbiya yali barndana. Kajamuku yali nanaba barndana. Ngindu yali muwa kudanyu barri nanankanyi ngilayurruwa. ");
INSERT INTO wrk_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Ngankijbayi Jisus barndana, baki yanyba nyuli yalungi, “Wanyingkanyi narri kudanyu ngindu muwa. Wanyingkanyi. Mikukimi nayinda ngila kurdan. Muningka nyulu kulukangka. Miku nangkimi janyba.” ");
INSERT INTO wrk_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Ngala yurlwa yali nangangi. Kakalijba yali nanganginkanyi jangkurranyi. Kakalijba yali. Ngala manjijbayi yalunya barndananyi Jisuswanyi. Jali yalu barlba, baki kuyu nyuli yalunya, ngardanganja nangangi ngilayurruwa, baki nijanganjinyi nangangi, marda murrku kandimuku nangangi. Jilajba yali nangandurri ngilayurruwarri. ");
INSERT INTO wrk_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Marrimbayi ngila marni Jisuswanyi, baki yanybayi nangangi, “Dalida kumi.” Nanda jangkurr Ju yanyi barrinani, “Ngila. Ngayu karungka ninya, walajbakiyi.” Barriwa. ");
INSERT INTO wrk_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Baki walajbayi nanda ngila waykalinya. Walajba nyuli, baki jilajba nyuli. Yuku barri nyuli. Nanda barri ngila, barringa barri nyuli wurrumbarra. Jali yalu najba nanda ngila walaykurri, baki manmala yali. Manmala yali kudanyu barri. ");
INSERT INTO wrk_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Jirrinybayi yalunya Jisuswanyi, maramaramba nyuli, “Miku janarri karu yingkamuku, jali ngayu wankamba nayinda ngila. Miku. Ngala wajba janarri ngila mamanyi.” Nani barri nyuli jirrinyba yalunya Jisuswanyi. Barriwa. ");
INSERT INTO wrk_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Barlba yali nanamunanyi yajinanyi, Jisus marda nanganginmuku kandimuku. Barlba yali bayungu, baki wanbiya yali nanganginyina yajina Jisuskanyi. ");
INSERT INTO wrk_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Ngala nyuli Sadidi, baki ngankijbayi Jisus jurjina, baki nyuli milidimba yalunya nanganginmuku mungkijimuku kajamuku barri. Jali yalu manku nangangi jangkurr, baki manmala yali. Manmala yali, baki yanyba yalungki, “Yanka nyuli jingkijba nanda jangkurr. Yanka nyuli jingkijba milidimbikanyi marda kunymambikanyi yalunya. ");
INSERT INTO wrk_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Miku nyulimi mambuka. Muningka nyulu jungkuka barrinani ngambala. Miku nyulimi mambuka milidimbikanyi yaji. Nyulu nanda, jalili nyulu muningka yabimba barrawu wabula. Nyulu kulunganja nangangi Marikanyi. Baki kaja bababanyamba nyulu yalunya nayiba, Jayims, baki Jusib, Judas baki Sayimin. Marda jibarrimuku bababanyamba nyulu yalunya, yalu jungkuka nanginyina yajina marda.” Nani barri yalungki yanyba nangangi. Miku yaliyanyi kuyu nangangi jangkurr mungkijimukunyi nanganginyina yajina. Yurlwa yali nanganginkanyi jangkurranyi. ");
INSERT INTO wrk_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Yanybayi Jisus yalungi, “Nanda jala yanybaka jangkurr nangangi Kudkanyi, nyulu jilalajbangka nanaba yajina. Nyulu yanymimbaka jangkurr yalungi Kudkanyi, baki yalu kuyungka nanda nangangi jangkurr. Ngala jala nyulu jungkuka nanganginyina yajina, jala nyulu yanybaka jangkurr nanganginmukuyngka mungkijimukuyngka, baki miku yalimi kuyu nangangi jangkurr. Yalu yurlwangka nangangi nanganginkanyi jangkurranyi. Baki nani barri narri marda. Narri ngakinmuku mungkijimuku, ngakinmuku bababanyamba ngayu narrinya, ngala miku narrimi kuyu ngaki jangkurr. Nganarri jingkijba yurrngumba wabulinyi, ngala narri yurlwangka ngaki, ngakinkanyi jangkurranyi.” Barriwa. ");
INSERT INTO wrk_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Baki miku nyuliyanyi yabimba kaja ngiruka yaji nanaba nanganginyina yajina. Ngawamba kujajarra nyuli marrimba yalunya, nyulu kunymambiji yalunya. ");
INSERT INTO wrk_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Manmalayi Jisus, jali yalu miku kuyunkanyi nangangi jangkurr. Manmala nyuli kudanyu barri yalungi. Baki mili jilalajbayi Jisus. Yidamba nyulili kaja barrawuyabarrawuya, bakili nyulu milidimba yalunya jangkurranyi Kudkanyi. Barriwa. ");
INSERT INTO wrk_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Yanybayi Jisus yalungi nanganginmukuyngka kandimukuyngka. Yanyba nyuli yalungi. Baki manjijba nyuli yalunya, kujarra nayiwa, kujarra nayiwa, baki kujarra nayiwa. Nani nyuli manjijba yalunya nanankurri barrawuyabarrawuyarri. Karuyi yalunya Jisuswanyi, yuku jayalu jakajba wuwarr yalunbunanyi mankanyinanyi. ");
INSERT INTO wrk_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","9","Yanybayi Jisus yalungi, “Ngayu manjijbangka narrinya milidimbiji yalunya, ngala miku narriyi kuyu kudukudu yaji narrindu jalija narri jilalajba. Mikuyaji dungalanyi janarri kuyu narrindu. Miku narriyi kuyu bindawarra narrindu, ngajakankanyi yingka dungalanyi, yarriykanyi dungala bindawarrana. Miku narriyi kuyu mili mama. Miku narriyi kuyu mili jumbala, ngawamba jumbala nganyindu mankanyina, baki jabunungkaji nganyindu nukamina, baki ridiridi jilaykanyi. Nani barri janarri jilalajba mikuyaji kajanyi yajinyi narrindu.” Barriwa. ");
INSERT INTO wrk_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Mili yanybayi Jisus yalungi, “Jalija narri wanbiya barrawuyabarrawuyana, baki janarri jungku kunybana nganinyina, jala nyulu nulijba kandimbikanyi narrinya. Janarri jungku nanganginyina barndana yurrngumba, jalija narri milidimba yalunya nananyina barrawuyabarrawuyana. ");
INSERT INTO wrk_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Jalija ninji wanbiya barrawuyabarrawuyana, baki yiningki jayalu yurlwa narringi. Yiningki jayalu miku manku narringi jangkurr. Barlba narri nanamunanyi yajinanyi. Jayajayamba narringka nukami manjiykanyi jundurr. Jayalu najba narrinya jayajayambikurri narringka nukami, baki jayalu jingkijba, yalu balkimuku. Balki yalu, mikungangi yaliyi manku nangangi jangkurr Kudkanyi.” Nani barri yanybayi Jisus yalungi. ");
INSERT INTO wrk_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Baki nyuli manjijba yalunya. Barlba yali. Baki milidimba yalunjali kandimukunyi Jisuskanyi. Milidimba yalunjali, marda yalimi ngindu muwa yalunginkanyi balkinyi yajinyi. ");
INSERT INTO wrk_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Baki yabimba yali ngiruka yaji marda. Jakajba yali wuwarr yalunbunanyi mankanyinanyi. Bunyarrijba yali nanjananja kungu yalundu mankanyina, jali yalu lunji, baki kunymambayi yalunya mankanyi Kudwanyi. Nani barri yali yabimba ngiruka yaji kandimukunyi Jisuskanyi. Barriwa. ");
INSERT INTO wrk_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Nanamanji barri, nanda nganinyi, niji Yirud, nyuli walkurra mambuka Kubaminkanyi nanankanyi yajinyi Kalilikanyi. Manku nyuli yalunya yanybikurri nangangi Jisuskanyi, nanankanyi ngirukanyi yajinyi jali nyulu yabimba. Ngala yanyba yali yinini yinini jangkurr nangangi Jisuskanyi. Yingkamuku yali yanyba nangangi Jisuskanyi, “Nayinda Jisus, nyulu nanda Jun Ngurrunbawarr jali nangka janyba. Mili nyulu wanka jungkuka nanijba barri. Baki nanankardi barri nyulu ngiruka kunymambikanyi yalunya mankanyi.” ");
INSERT INTO wrk_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Ngala yingkamuku yali yanyba nangangi Jisuskanyi, “Nayinda Jisus, nyulu nanda wankalanyi nganinyi, niji Yalayija, ngala nyulu mili wanka jungkuka.” Ngala yingkamuku yali yanyba nangangi Jisuskanyi, “Nayinda Jisus, nyulu yanybaka jangkurr nangangi Kudkanyi, barrinani nanamuku wankalamuku jali yalu yanyba jangkurr nangangi Kudkanyi.” Nani barri yali yanyba yinini yinini jangkurr nangangi. ");
INSERT INTO wrk_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Ngala jali manku yalungi jangkurr nanangini mambukawanyi Yirudwanyi, baki yanyba nyuli, “Nayinda Jisus, nyulu nanda Jun Ngurrunbawarr, jali ngayu kurdanba, jali yingkawanyi daya nangangi janki ngaki. Mili nyulu jungkuka wanka nanijba barri.” Nani barri yanybayi Yirud yalungi nangangi Jisuskanyi. ");
INSERT INTO wrk_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","20","Wabula barri nanangini mambukawanyi Yirudwanyi, nyuli jarimba nanda jibarri, jali yingkanyi nangangi maninganja, jali maninganja nanganginkanyi bababanyamba nyulu Yirudwanyi, niji Bilib. Jarimbayi nanda jibarri, baki kuyuyi nangangi barri maninganja. Nanda jibarri nangangi niji Yirudayis. Nani barri yabimbayi balki yaji Yirudwanyi. Jungku nyuli balki nananyina yuwana Kudkanyi. Nani barri nyuli jungku nanda Yirud. Baki nanankardi barri ngirrwayi nangangi Jun Ngurrunbawarr. Ngirrwa nyuli nangangi Yirudkanyi, “Ninji jungkuka balkina yuwana Kudkanyi. Jarimba ninji nanda jibarri, jali nangangi maninganja Bilibkanyi. Nani barri ninji jungkuka balkina yuwana Kudkanyi.” Barriwa. Nanangini jibarriwanyi Yirudayiswanyi, nyuli jingkijba Jun Ngurrunbawarr. Nyuli jingkijba, ngirrwayi Jun nangangi Yirudkanyi, nangangingangi Yirudayiskanyi. Baki ngarrangarra nyuli muwa nangangi Junkanyi. Nulijba nyuli yalungi, yalu kurdanbikanyi Jun. Ngala kardambayi jibarri Yirudwanyi, yalu kurdanbikanyi Jun. Kardamba nyuli jibarri, marralangangi nyuli nangangi Junkanyi Ngurrunbawarrayngka. Jingkijba nyuli Jun, nyulu kunyba nganinyi, jali nyulu yabimba kunyba yaji nangangi Kudkanyi yurrngumba barri. Nanankardi nyuli kardamba nanda jibarri Yirudwanyi. Ngala nyuli manjijba yilarrmuku, yalu wudumbiji Jun. Wudumba yali, yarrijba yali brisinyina, baki kijijba yali. Jali jungku Jun brisinyina, baki karu nyuli Yirud nanganginkanyi jangkurranyi Kudkanyi. Mankumanku nangki Yirud nanankanyi jangkurranyi, baki balkijba nyuli muwa. Balkijba nyuli muwa, ngala mili nyuli manku jangkurr nangangi Junkanyi Ngurrunbawarrayngka nangangi Kudkanyi. Mili nyuli manku nanda jangkurr Yirudwanyi, baki mili baki mili. Barriwa. ");
INSERT INTO wrk_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Nanda jibarri Yirudayis, kulunganja nangangi wurrumbarra. Nyuli kunyba kajurrawarr nanda wurrumbarra. Yabimbayi walkurra wangarr Yirudwanyi. Kajamuku mambukamuku Kubaminkanyi, yali jungku nangandu marda mambukamuku yalungi yilarranyi, marda malbumalbu nanankanyi yajinyi. Jarrba yali mama nangandu, ngaraba yali yaji marda. Yabimba yali jarrkanyi yaji. ");
INSERT INTO wrk_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Ngala yalungki wardamba, baki wanbiyayi nanda wurrumbarra, baki kajurrayi nyulu yalundu. Kudanyu nyuli kajurra yalungi, Yirudkanyi baki mambukamukuyngka. Mirnarrijba yali muwa nangangi. Yanybayi Yirud nangangi wurrumbarranyi, “Wanyingkanyi ninji nulijba. Janinya wajba yajinyi. Janinya wajba nanankanyi jala ninji nulijba. ");
INSERT INTO wrk_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Jaliyi ninji nulijba, baki janinya wajba kudiyanyi jambanyi, marda kajanyi barrawunyi, marda nganinyimukuyngka yalu wakinkanyi nganyi. Janinya wajba nanankanyi jala ninji nulijba. Duja ngayu yanyba.” Nani barri yanybayi Yirud nangangi. ");
INSERT INTO wrk_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Jilajbayi wurrumbarra danbiyurri, baki karuyi nangangi ngardanganja nanankanyi jangkurranyi, waykanyi yajinyi Yirudwanyi. Yilikajbayi nangangi ngardanganja, “Wanyingkanyi jangayu ngajaka. Wanyingkanyi.” Jananganjayi ngardanganjawanyi, “Yilikajbakiyi nanganginkanyi kulajinyi Junkanyi Ngurrunbawarrayngka. Yilikajbakiyi nanganginkanyi kulajinyi.” ");
INSERT INTO wrk_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Wijbayi wurrumbarra nangandurri Yirudyurri, baki yanybayi nangangi, “Wajba janganinji kulaji Junkanyi Ngurrunbawarrayngka najana. Nulijba ngayu nanganginkanyi kulajinyi.” Barriwa. ");
INSERT INTO wrk_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Ngala nginduyi Yirud muwa. Kudanyu nyuli ngindu muwa, mikungangi nyuliyanyi nulijba kurdanbikanyi Jun. Ngala nyuli yilikajba wurrumbarra barrin wanyingkanyi janyulu wajba. Nyuli yanyba waykanyi yajinyi, baki bukambijunyi yali manku nangangi jangkurr. Miku nyuliyi yangkalamba nangangi jangkurr. Barriwa janyulu wajba yajinyi. ");
INSERT INTO wrk_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Baki nyuli jirrinyba ngarrkadabawarr, “Dayakiyi Jun janki, baki wiykunumbakiyi kulaji nanginkurri.” Barlbayi ngarrkadabawarr, baki nyuli kurdanba Jun. Nyuli daya janki brisinyina. ");
INSERT INTO wrk_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Wiykunumba nyuli kulaji najana, baki wajbayi wurrumbarra. Baki kuyuyi kulaji wurrumbarrawanyi, wajbayi nangangi ngardanganja kulajinyi. Barriwa. ");
INSERT INTO wrk_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Nanamuku kandimuku Junkanyi, jali yalu manku Jun Ngurrunbawarr nangki janyba, baki jilajba yali brisinyurri, baki dulaba yali nangangi mankanyi makaykanyi. Baki yali yarrijba nangangi mankanyi kalawunyi kumayanguna. Barriwa. ");
INSERT INTO wrk_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Waluwa barri manjijbayi yalunya kandimuku Jisuswanyi, yalu milidimbiji nangangi yaji. Barlba yali, baki milidimba yalunjali. Baki baku yali wijba nangandurri Jisusyurri. Karu yali Jisus bukamba nanankanyi yajinyi jali yalu yabimba, baki jali yalunjalu milidimba. Barriwa. ");
INSERT INTO wrk_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Kajamuku yali jilajba nangandurri Jisusyurri. Baki mili jawudamuku yali jilajba bayngkani yalundu, baki mili bayngkani barri. Miku yalungkiyi wardamba mamanyi, Jisus baki nanganginmuku kandimuku, kajangangi yalu nanaba nangandu yurrngumba barri. Yanybayi Jisus yalungi kandimukuyngka, “Jangambala ngambala jilajba munjimunji. Jangambala jungku ngambalaman, jala yalungi mikuyaji muramukuyngka. Jangambala wuyalijba nanaba barri.” Barriwa. ");
INSERT INTO wrk_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Ngankijba yali muwardana, baki birlbirdamba yali karrurrinybarri jungunkanyi yaluman. ");
INSERT INTO wrk_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Ngala kajamukunyi barri, yali najba nganinyimuku jilaykurri muwardana, baki yali jingkijba, nanamuku nganinyimuku, yali Jisus baki nanganginmuku kandimuku. Baki yali jingkijba nanda yaji jalija nyulu jilajba nanankurri. Baki wirlku yali nukamina nanankurri yajiyurri. Kajamuku yali wirlku lukuluku nanankurri yajiyurri, ngala jilajbayi Jisus muwardana. Baki wanbiya yali waluwa yalundu, Jisusnyina baki kandimukunyina. ");
INSERT INTO wrk_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Walajbayi Jisus muwardananyi, baki nyuli najba yalunya walkurra muramuku. Baki ngindu nyuli muwa yalungi. Kudanyu nyuli ngindu muwa yalungi, mikuyajingangi nyuli lalanbawarrayngka yalungi. Baki milidimbayi yalunya Jisuswanyi. ");
INSERT INTO wrk_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Ngabungabu barri jilajbayi nangangi kandimuku nangandurri Jisusyurri, baki yanyba yali nangangi, “Barriwa barri ngabungabu yaji nayinda. Mikuyaji mamanyi nayiba, baki mikuyaji barndanyi. ");
INSERT INTO wrk_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Marda ninjimi manjijba yalunya barrawuyabarrawuyarri. Marda ninjimi manjijba yalunya wudumbiji yalungi mama.” ");
INSERT INTO wrk_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Jananganjayi yalunya Jisuswanyi, “Miku ngayiyi manjijba yalunya. Yuku yalu wambu jungku nayiba. Janarri narri wajba yalunya nayiba mamanyi.” Jananganja yali Jisus, “Kajamuku nanginmuku. Jayalu jarrba kudukudu mama. Yanka janurru wudumba damba yalungi. Jaliyi 200 dula nurrundu, baki yuku janurru wudumba kudukudu damba yalungi.” ");
INSERT INTO wrk_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Ngajakayi yalunya Jisuswanyi, “Yankanu damba yalundu. Kujbakiyi yankanu damba.” Jilajba yali, wakaramba yali, baki karu yali Jisus, “Wakaramba nurri ngawamba kujarra baki kujarra baki yingamali bayayawa damba, baki kujarra kaku marda.” ");
INSERT INTO wrk_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Baki jirrinybayi yalunya muramuku Jisuswanyi, yalu jungunkanyi dalbu dalbu nanaba karnbana. Baki jungkurrijba yalungki karnbana. ");
INSERT INTO wrk_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Jawuda yali malumba jungku 100 barri, jawuda yali malumba jungku 50 barri. Nani barri yali jungku dalbu dalbu. Barriwa. ");
INSERT INTO wrk_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Wudumbayi nanda damba marda kaku Jisuswanyi. Kingkarri nyuli najba lalijiyurri, baki yanyba nyuli nangangi Kudkanyi nanankanyi mamanyi. Barriwa. Baki dalyamba nyuli damba. Wajbayi kandimuku, baki yali wawajba muramuku nanankanyi dambanyi. Jabarri dalyambayi kaku Jisuswanyi, baki wajbayi kandimuku. Wawajba yalunjalili muramuku dambanyi baki kakunyi. ");
INSERT INTO wrk_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Jarrba yali bukambiju, baki wardijba yali muwa. ");
INSERT INTO wrk_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Ngala miku yaliyanyi jarrba kudanyu nanda mama. Kudiya mama kiliyi nanaba. Baki wudumba yali nanda mama kandimukunyi, baki yarrijba yali bindawarrana, 12 barri. ");
INSERT INTO wrk_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Kajamukunyi yali jarrba mama mijimbangumukunyi nganinyimukunyi, 5000mukunyi. Barriwa. ");
INSERT INTO wrk_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Baki jirrinyba nyuli yalunya nanganginmuku kandimuku Jisuswanyi. Yanybayi yalungi, “Janarri ngankijba muwardana, baki janarri barlba kanjana bayangarrinybarri, nanankurri yajiyurri niji Bidsayida. Ngala jangayu manjijba yalunya muramuku yalunginkurri barndarri.” Baki barlba yali kandimuku nangangi muwardana. ");
INSERT INTO wrk_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Baki manjijba nyuli yalunya muramuku Jisuswanyi. Mudambayi yalunya, baki barlba yali. Ngala kirrijbayi Jisus kingkarri dungalana. Kirrijba nyuli nyubana yanybiji nangangi Kudkanyi. ");
INSERT INTO wrk_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Jali mungana barri, baki nanganginmuku kandimuku yuwajiwa yali wajanganja burrandijba kanjana, ngala jungkuyi Jisus nanaba dungalana kingkarrinyin bangani. ");
INSERT INTO wrk_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Najbayi yalunya kandimuku Jisuswanyi. Nyuli najba yalunya wajanganjankurri. Kudanyu yali wajanganja, karnungkumbayingangi yalunya yunkurrwanyi bayunguna. Ngala nyulu barringa barri kambalingijba yaji karrina, baki jilajbayi Jisus yalundurri. Jilajba nyuli nukamina yundu wabudana. Jilajba nyuli bayungu langkiya yalundu. ");
INSERT INTO wrk_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Najba yali Jisus jilaykurri yundu wabudana, baki ngamungka nyuli wuwarr. Marrala yali, baki kaya yali, “Wuwarr, nanda wuwarr badajbangka ngamandurri.” ");
INSERT INTO wrk_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Marrala yali kudanyu barri, jali yalu najba Jisus. Ngala yanybayi Jisus yalungi, “Miku narriyi marrala ngaki. Nayinda ngayu Jisus. Miku narriyi marrala ngaki.” ");
INSERT INTO wrk_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Ngankijbayi Jisus muwardana, baki kurrkunba nangki yunkurr. Mikukiyanyi warrmba yaji mili. Ngala manmala yali kandimuku. Manmala yali kudanyu barri. ");
INSERT INTO wrk_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Miku yaliyanyi kudanyu jingkijba mamanyi. Nanda bayayawa mama, ngala walkurrambayi Jisuswanyi. Miku yaliyanyi jingkijba, yanka nyuli yabimba nanda bayayawa mama kudukudu. Barriwa. ");
INSERT INTO wrk_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Mili yali wajanganja bayungu. Birlbidamba yali bayangarrinybarri, baki wanbiya yali nananyina yajina, niji Kinisirid. Baki kijijba yali muwarda. ");
INSERT INTO wrk_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Jali yalu walajba muwardananyi, baki jawudanymukunyi yali jingkijba Jisus. ");
INSERT INTO wrk_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Jingkijba yali Jisus, baki wirlku yali nayiwa baki nayiwa baki nayiwa. Wirlku yali yalundurri jali yalu lunji. Baki kuyu yalunjali nangandurri Jisusyurri, nyulu kunymambiji yalunya. ");
INSERT INTO wrk_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Jalili wanbiya Jisus barrawuyabarrawuyana, bakili yalu kuyu nangandurri nanamuku jali yalu lunji. Yalunjalili kuyu burrandijba barndana, nyulu kunymambiji yalunya. Yililikajba yali Jisus, jaliyi yuku yalu marrimba nangangi jumbala, baki jayalu kunybijba mankanyi. Baki bukambiju jali yalu marrimba nangangi jumbala, baki kunybijba yali mankanyi. Barriwa. ");
INSERT INTO wrk_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","4","Nanamanji barri nanamuku Barasimuku, nayi yalungi yuwa. Waluku yalungkili wakardaba marni, baki kamu yalili jarrba mama. Nani barri yalungi yuwa nanamukuyngka Barasimukuyngka. Baki yalunjalili karu yingkamuku, marda yalungkimi bukambiju waluku wakardaba marni, baki kamu jayalu jarrba mama. Nani barri yalunjalili karu nanankanyi yuwanyi. Jalili yalu wudumba mama dungalana, baki miku yaliyanyi jarrba nanda mama ngala yali jilajba. Waluku yalungkili wakardaba marni, baki kamu yaluja jarrba nanda mama. Mili yalungi yuwa wakardaykanyi yaji. Wakardaba yalili yukururumuku, marda bujilimuku. Wakardaba yalili kaja yaji yalunginkanyi yuwanyi. Karuyi yalunya wakardaykanyi yaji nanankanyi yuwanyi jalili yalunya karu wankalamukunyi. Nanamanji barri nanamuku Barasimuku, nani barri yalili wakardaba yaji nanankanyi yuwanyi. Barriwa. Baku barri kudiya Barasimuku, baki kudiya milidimbawarrmuku yuwanyi, badajba yali kulani Jirusalimnanyi. Badajba yali nangandurri Jisusyurri. Najba yali kudiya kandimuku Jisuskanyi jarrkurri mama. Miku yalungkiyanyi wakardaba marni waluku yali jarrba mama. ");
INSERT INTO wrk_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Yanyba yali nangangi Jisuskanyi, “Najba nurri nganyinmuku kandimuku jarrkurri mama. Jarrba yali mama, ngala miku yalungkiyanyi waluwa wakardaba marni. Dulu yali jarrba nanda mama. Wanyingkanyi yalungkiyanyi miku wakardaba marni waluwa yali jarrba yaji. Nani barri yanybaka nanda yuwa wakardaykanyi yaji. Ngala wanyingkanyi miku yalimi ngayangayijba nanankanyi yuwanyi.” Barriwa. ");
INSERT INTO wrk_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Jananganjayi yalunya Jisuswanyi, “Narri balkimuku. Narri yabimba balki yaji, jala narri mamanumba nanda yuwa nangangi Kudkanyi, jala narri karu yalunya yinini yuwanyi. Narri balkimuku. Nanda wankalanyi jangkurr jali yanyba Yayisaya, duja nanda jangkurr. Nanangini jangkurrwanyi karungka yalunya narringi. Nayi nanda jangkurr, ‘Nanginmuku, muningka yalu yanyba, yalu maruka muwa ngaki, yalu durrijba ngaki yuwa, ngala miku. Miku yalimi maruka muwa ngaki. Miku yalimi durrijba ngaki yuwa. Muningka yalu wajba ngana yalunginkanyi kunybanyi jangkurranyi, ngala miku yalimi kunyba kurdulu ngaki. ");
INSERT INTO wrk_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Jalija yalu wajba ngana kunybanyi jangkurranyi, baki miku ngayiyi manku yalungi jangkurr. Miku ngayiyi manku yalungi kunyba jangkurr, mikungangi yalimi milidimba ngakinkanyi jangkurranyi. Yalu yanybaka nanda ngaki jangkurr, ngala miku. Milidimbaka yalunjalu yalunginkanyi jangkurranyi, miku ngakinkanyi jangkurranyi.’ Nani barri nanda jangkurr najana Kudkanyi. Barriwa. ");
INSERT INTO wrk_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Narri yurlwangka nanankanyi jangkurranyi Kudkanyi, ngala narri durrijbangka nanda wankalanyi jangkurr, jali yalu yanyba nganinyimuku.” Nani barri ngirrwayi Jisus yalungi barri. ");
INSERT INTO wrk_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Mili barri yanybayi Jisus yalungi, “Narri yurlwangka nanankanyi yuwanyi Kudkanyi, ngala narri ngayangayijbangka narringinkanyi wankalanyi yuwanyi. ");
INSERT INTO wrk_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Nanda barri yuwa jali wajba Musis Kudwanyi, nanda yuwa yanybaka nayi barri, ‘Marda ninjimi lalanba bulanya nganyi nijanganjinyi marda ngardanganja. Marda ninjimi wajba bulanya mamanyi baki dungalanyi. Marda ninjimi miku yanyba balki jangkurr bulangi. Jaliyi ninji yanyba balki jangkurr bulangi, jaliyi ninji miku wajba bulanya mamanyi marda dungalanyi, baki marda ninyalimi kurdanba yingkamukunyi.’ Nanda jangkurr, nanda nangangi yuwa Kudkanyi. ");
INSERT INTO wrk_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","12","Ngala miku narrimi milidimba yalunya nanankanyi nanganginkanyi jangkurranyi. Yinini jangkurranyi narri milidimba. Narri milidimba yalunya, jaliyi yingka nyulu yanyba bulangi, nanganginkanyi nijanganjiyngkanyi baki ngardanganjanyi, jaliyi nyulu yanyba bulangi, ‘Miku ngayiyi wajba nimbalanya dungalanyi baki yajinyi, miku ngayiyi lalanba nimbalanya. Yanyba ngayi jangkurr nangangi Kudkanyi, jangayu wajba Kud dungalanyi baki yajinyi, baki miku ngayiyi yangkalamba nanda jangkurr. Baki nanankardi barri miku ngayiyi wajba nimbalanya dungalanyi baki yajinyi. Miku ngayiyi lalanba nimbalanya.’ Narri yanyba, jaliyi nyulu yanyba nani bulangi, baki nanda kunyba. Narri yanybaka nanda kunyba, nyulu waykanyi Kud dungalanyi, ngala mikuyaji mili dungalanyi wudumbikanyi mama bulangi. ");
INSERT INTO wrk_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Ngala balki nanda narringi yuwa. Miku narrimi ngayangayijba nanganginkanyi yuwanyi Kudkanyi. Narringinyi yuwawanyi manjamanjambaka nanda yuwa nangangi Kudkanyi. Nanangini balkiwanyi jangkurrwanyi manjamanjambaka nanda kunyba jangkurr nangangi Kudkanyi. Narri jungkuka balki, jala miku narrimi lalanba bulanya yarrijinyi baki nijanganjinyi, jala miku narrimi wajba bulanya dungalanyi, ngala narri wajba Kud dungalanyi. Baki narri milidimbaka mili kajanyi balkinyi yajinyi marda. Mili kajanyi balkinyi yajinyi narri milidimbaka yalunya barri.” Barriwa. ");
INSERT INTO wrk_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Baki kayayi Jisus yalungi muramukuyngka, yalu jilaykanyi nangandurri. Mili nyuli yanyba yalungi, wakardaykanyi yalungka marni baki jarrkanyi mama. Yanyba nyuli yalungi, “Manku janarri ngaki jangkurr, baki jingkijba janarri. ");
INSERT INTO wrk_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Miku nyulimi jungku balki, jarrbangkangangi nyulu mama. Nyulu jungkuka balki, mankumankukangangi nangka balkinyi yajinyi. Waluku nangka mankumankuka balkinyi yajinyi, baki nyulu yanybaka balki jangkurr, nyulu yabimbaka nanda balki yaji. Nani nyulu jungkuka balki.” Barriwa. ");
INSERT INTO wrk_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Kamu barri barlbayi Jisus yalunbunanyi murananyi. Ngankijba nyuli barrawuna, baki jungku nyuli nanaba kalawuyngkurru. Jilajbayi nanganginmuku kandimuku nangandurri, baki ngajaka yali Jisus, “Wanyi nanda jangkurr jali ninji yanyba barrin. Miku nurrimi jingkijba.” ");
INSERT INTO wrk_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","19","Ngala jananganjayi yalunya Jisuswanyi, “Marda narri kuna. Miku narrimi kunyba kulaji jingkiykanyi yaji kuna. Miku kuna narrimi jingkijba ngaki jangkurr. Jungku kuna narri barrinani yalu. Jangayu karu narrinya nanankanyi jangkurranyi. Nanda mama jala narri jarrba, nanda mama ngankijbangka narrindu muwana. Mikukimi jungku nanda mama muwana yurrngumba. Nanda mama walajbangka muwananyi, mankanyinanyi. Nani barri mikuwali nanangini mamawanyi yabimba narrinya balki, narringka mankumankunkanyi balkinyi yajinyi. Miku narrimi jungku balki, jarrbangangi narri jawuda mama.” Barriwa. Nani barri yanybayi Jisus mamanyi, bukamba mama kunyba jarrkanyi. Miku jawuda mama malaba, miku yaliyi jarrkanyi. Barriwa. ");
INSERT INTO wrk_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Baki mili yanybayi Jisus yalungi, “Ngala jaliyi narringka mankumanku balkinyi yajinyi, baki janarri yabimba balki yaji. Baki nani barri janarri jungku balkina yuwana Kudkanyi. ");
INSERT INTO wrk_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Waluku nangka mankumanku nganinyi balkinyi, baki kamu janyulu yabimba balki yaji, kamu janyulu maninjakujba yaji. Kamu janyulu kurdanba yingka nganinyi. ");
INSERT INTO wrk_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","Waluku nangka mankumanku nganinyi balkinyi, baki kamu janyulu kuluka yingkana jibarrina, kamu janyulu kuliwijba yajinyi, kamu janyulu jujamba yalunya, kamu janyulu ngurrunajba yingka, kamu janyulu barrakijarra. ");
INSERT INTO wrk_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Nani barri waluku nangka mankumanku nganinyi balkinyi yajinyi, baki kamu janyulu yabimba nanda balki yaji. Nani barri jungkuka nanda nganinyi balkina yuwana Kudkanyi. Ngala miku nyulimi jungku balkina yuwana Kudkanyi, jarrbangangi nyulili mama barrin.” Barriwa. Nani barri yanybayi Jisus yalungi kandimukuyngka. ");
INSERT INTO wrk_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Barlbayi Jisus nanamunanyi yajinanyi. Barlba nyuli yingkayurri yajiyurri. Barlba nyuli langki bundu nanankuyanyina barrawuyabarrawuyana, niji Daya marda Sayidun. Ngankijbayi Jisus barrawuna, baki jungku nyuli nanaba. Nulijba nyuli jungunkanyi karda nanaba barrawuna nyuluman, ngala miku. Wakaramba yali Jisus nananyina barrawuna yingkamukunyi. ");
INSERT INTO wrk_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","26","Jilajbayi jibarri nangandurri. Nanda jibarri nangangi yaji niji Bunijiya. Miku nyuliyanyi mungkiji nangangi Jisuskanyi. Miku nyuliyanyi Ju, ngala nyuli ngurranyi. Yanyba nyuli yinini yanyi, Krik yanyi. Nanamuku Jumuku, miku yaliyanyi maruka muwa yalungi ngurranyimukuyngka barrinani nanda jibarri. Yalili yanyba yalungi, “Yingkamuku ngurranyimuku, yalu barrinani bajangumuku.” Ngala nanda kulunganja nangangi ngila, nyuli lunji. Jungkuyi wuwarr nangandu mankanyina. Manku nyuli nangangi Jisuskanyi, nyuli nanaba barrawuna, baki jilajbayi jibarri nangandurri, baki mururu nyuli wayka jambana nangandu. Yilikajba nyuli Jisus, nyulu jakaji nanda wuwarr ngilananyi mankanyinanyi. ");
INSERT INTO wrk_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Ngala yanybayi Jisus nangangi jibarrinyi, “Waluku barri janurru wajba bayamuku mamanyi. Waluku jayalu jarrba kaja mama. Miku nurriyi wajba bajangumuku mamanyi waluku barri. Waluku jayalu yalu jarrba yaji bayamukunyi. Ngayu Ju, ngala ninji ngurranyi ngaki. Badajba ngayi milidimbiji yalunya ngakinmuku mungkijimuku Jumuku. Badajba ngayi yabimbiji ngiruka yaji yalungi barri. Yalu barrinani nanamuku bayamuku. Miku ngayiyanyi badajba milidimbiji yalunya ngurranyimuku. Miku ngayiyanyi badajba yabimbiji ngiruka yaji yalungi. Yalu barrinani nanamuku bajangumuku.” ");
INSERT INTO wrk_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Yanybayi jibarri nangangi Jisuskanyi, “Yuku barri, mambuka. Ngala jala yalu jarrba mama bayamukunyi, jaliyi yirrba jawuda mama jambarri, baki nanda jarrbangka bajanguwanyi. Jarrbangka nanda bijal mama bajanguwanyi, jaliyi yirrba mama jambarri. Ngala jala ninji milidimba yalunya nganyinmuku mungkijimuku, baki kudiyanymukunyi ngurranyimukunyi yalu marda mankuka nganyi jangkurr. Yalu marda kuyungka nganyi jangkurr. Janinji kuna yabimba ngiruka yaji yalungi marda ngurranyimukuyngka jala kuyu nganyi jangkurr. Janinji kuna kunymamba marda ngaki ngila.” ");
INSERT INTO wrk_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Baki nyuli jananganja jibarri Jisuswanyi, “Mirnarrijba ngayu muwa nanankanyi jangkurranyi jali ninji yanyba. Kudanyu barri nganinji jingkijba, yuku ngayu yabimba ngiruka yaji. Jangayu kunymamba nanda nganyi ngila. Wijbakiyi wayka barndarri ngilayurri. Nanda wuwarr barlbayi nanganbunanyi mankanyinanyi. Mikuyaji wuwarranyi nanaba ngilana mankanyina.” Barriwa. ");
INSERT INTO wrk_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Wijbayi nanda jibarri nanganginkurri barndarri. Jali nyulu wanbiya, baki najba nyuli ngila jalyuna. Mikuyaji wuwarranyi nangandu. Barriwa. ");
INSERT INTO wrk_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Baku barri barlbayi Jisus nanamunanyi yajinanyi Dayananyi. Jilajba nyuli langki nanankurri yajiyurri Sayidunyurri. Mili nyuli jilajba karrurrinyba kula nananyina yajina jali kaja barrawuyabarrawuya 10 barri. Baki mili nyuli jilajba bayungu nanankurri kanjarri, niji Kalili. ");
INSERT INTO wrk_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Kuyu yali nganinyi nangandurri Jisusyurri jawudawanyi. Nanda nganinyi, nyuli mudu kuwarda. Miku nyuliyi manku yaji. Baki nyuli balki janyi. Miku nyuliyi yanyba jangkurr kunymamba barri. Nyuli balki janyi. Yalu jali yalu kuyu nanda nganinyi nangandurri Jisusyurri, ngajaka yali Jisus, nyulu marrimbiji nanda nganinyi kulaji marniyudinyi. ");
INSERT INTO wrk_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Dulabayi nanda nganinyi yalunbunanyi Jisuswanyi. Jungkuyi bulaman. Baki yarrijba nangki Jisus marni nanganginyina kuwardana. Janybayi jabula Jisuswanyi, baki yarrijba nangki marni nanganginyina jalinyina. ");
INSERT INTO wrk_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Najbayi laliji kingkarri Jisuswanyi, baki wirnngalijbayi kudanyu barri. Baki yanybayi Jisus nganiyngkanyi, “Yibada.” Nanda jangkurr Ju yanyi, barrinani, “Dumbakiyi kuwarda, baki wirriwirrijbakiyi jalinyi.” ");
INSERT INTO wrk_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Baki yinarramba kunybijbayi nanda nganinyi. Manku nyuli yaji, baki yanyba nyuli jangkurr kunymamba barri. ");
INSERT INTO wrk_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Wijbayi Jisus yalundurri muramukuyngkurri, baki jirrinyba nyuli yalunya. Maramaramba nyuli, “Miku narriyi karu yingkamuku nanginkanyi nganiyngkanyi, jali ngayu kunymamba. Miku narriyi karu.” Nani barri nyuli jirrinyba yalunya, ngala miku yaliyanyi ngayangayijba nanganginkanyi jangkurranyi. Barlba yali, baki karu yali yingkamuku. Jali mili jirrinyba yalunya, miku karunkanyi Jisuswanyi, baki mili yali karu yingkamuku, nyuli kunymamba nanda nganinyi. ");
INSERT INTO wrk_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Baki jali yalu manku nanda jangkurr, baki manmala yali. Manmala yali kudanyu barri, baki yanyba yali, “Nanangini Jisuswanyi, nyulu yabimbaka bukamba yaji kunymamba. Nyulu kunymambaka kuwarda mankunkanyi yaji. Marda nyulu kunymambaka janyi yanybikanyi jangkurr.” Barriwa. ");
INSERT INTO wrk_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Marndakaja barri mili yali jilajba nangandurri Jisusyurri walkurra muramuku. Jungku yali nangandu murrkana kambana. Bukamba yali nanda mama jali yalu kuyu yalundu, ngala mili yali jungku nangandu, mikuyaji mamanyi. Kayayi Jisus yalungi nanganginmukuyngka kandimukuyngka. Badajba yali, baki yanybayi Jisus yalungi, ");
INSERT INTO wrk_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“Nginduka ngayu muwa yalungi, nanginmukuyngka muramukuyngka. Yali jungku ngakindu kujarraka barndayka, baki nanijba barri mikuyaji mamanyi yalundu jarrkanyi. Birrkalanyi yalu kudanyu barri. ");
INSERT INTO wrk_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Jawuda yalungi barnda juju barri. Jalimi ngayu manjijba yalunya barndarri, baki yiningki jawuda jayalu jungku buwandiwa. Majabujbayi mankanyi yalu, birrkalanyingangi.” Nani barri yanybayi Jisus yalungi kandimukuyngka. ");
INSERT INTO wrk_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Yanybayi kandimuku nangangi Jisuskanyi, “Ngala yanka janurru wajba yalunya mamanyi. Yanka barri. Miku nurriyi wudumba mama nanginyina mangkurruna yajina.” ");
INSERT INTO wrk_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Yilikajbayi yalunya Jisuswanyi, “Yankanu damba narrindu. Yankanu.” Jananganja yali, “Ngawamba 7 bayayawa damba.” ");
INSERT INTO wrk_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Baki jirrinybayi yalunya muramuku Jisuswanyi, yalu jungunki jambana. Baki wudumba nyuli nanda damba, baki yanyba nyuli mududu nangangi Kudkanyi. Dalyamba nyuli nanda bayayawa damba. Wajba nyuli yalunya kandimuku nanankanyi mamanyi, baki yalunjali wawajba muramuku nanankanyi bayayawanyi dambanyi. ");
INSERT INTO wrk_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Mili kujajarra bayayawa kaku yalundu marda. Wudumbayi nanda kaku Jisuswanyi, jabarri nyuli yanyba mududu nangangi Kudkanyi nanankanyi kakunyi. Baki nyuli jirrinyba kandimuku, yalunjalu wawaykanyi kakunyi marda. ");
INSERT INTO wrk_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Jarrba yali nanda mama, baki wardijba yali muwa. Miku yaliyanyi jarrba bukamba nanda mama. Kiliyi kudiya mama. Wudumba yali nanda mama kandimukunyi. Yarrijba yali bindawarrana, 7 bindawarra walkinyi. ");
INSERT INTO wrk_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Kajamukunyi yali jarrba nanda mama, mijimbangumukunyi, 4000 barri. Baki manjijbayi yalunya Jisuswanyi. Nyuli manjijba yalunya yalunginkurri barndarri. ");
INSERT INTO wrk_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Baki ngankijbayi Jisus muwardana. Ngankijba nyuli muwardana, marda nanganginmuku kandimuku nangandu, baki jilajba yali bayangarrinybarri yingkayurri yajiyurri, niji Dalmanuda. Barriwa. ");
INSERT INTO wrk_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Jali yalu wanbiya bayangarrinybana, baki yingkamuku yali jilajba nangandurri Jisusyurri. Yali Barasimuku jali yalu jurlwa nangangi Jisuskanyi. Jilajba yali nangandurri balanjanki Jisus. Yanyba yali Jisuskanyi, “Yabimbakiyi ngiruka yaji nurrungi, baki janurru jingkijba Kud, nyulu mirnarrijbangka muwa nganyi, ninji nangangi kandi. Nani janinya nurru jingkijba, jaliyi ninji yabimba ngiruka yaji nurrungi.” Barriwa. ");
INSERT INTO wrk_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Wirnngalijbayi Jisus kudanyu barri. Ngindu nyuli muwa yalungi jali yalu balanja Jisus. Baki yanyba nyuli yalungi, “Narri jala narri jungku nayimanji barri, wanyingkanyi nganarri ngajaka ngayu yabimbiji mili ngiruka yaji narringi. Narri najbayi nanda ngiruka yaji jali ngayu yabimba, ngala miku narriyi jingkijba yaji. Miku nganarriyi jingkijba, jali manjijba ngana Kudwanyi. Ngala miku barri. Miku ngayiyi yabimba mili ngiruka yaji narringi. Miku.” Nani barri jananganjayi yalunya Jisuswanyi. ");
INSERT INTO wrk_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Barlbayi Jisus yalunbunanyi. Ngankijba yali muwardana, Jisus baki kandimuku, baki mili yali jilajba karrurrinybarri kanjana muwardayudi. ");
INSERT INTO wrk_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Ngala mamanumba yali yaji kandimukunyi. Mamanumba yali wudumbikanyi mili damba. Ngawamba yingamali damba yalundu muwardana. ");
INSERT INTO wrk_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Yanybayi Jisus yalungi, “Marda narringkimi najbawa yalunginkanyi bululunyi yajinyi, Barasimukuyngka baki Yirudkanyi. Marda narringkimi najbawa yalunginkanyi bululunyi yajinyi.” ");
INSERT INTO wrk_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Jali manku nangangi jangkurr kandimukunyi, baki ngamu yanybayi Jisus dambanyi. Baki yanyba yalungki, “Mikuyaji dambanyi ngambalangi. Nanankardi barri nyuli yanyba nani barri, mamanumbangangi ngambala kuyunkanyi ngambalangi damba.” ");
INSERT INTO wrk_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Ngala mankuyi yalunya Jisuswanyi, baki nyuli yanyba yalungi, “Wanyingkanyi narringka yanyba nani dambanyi. Miku kuna narrimi jingkijba ngaki jangkurr. Balki kuna narri kulaji jingkiykanyi ngaki yaji. ");
INSERT INTO wrk_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Narri yamiyudi. Nganarri najbangka yabimbikurri yaji, ngala miku kuna narrimi jingkijba nanda yaji. Narri kuwardayudi. Narri mankuka ngaki jangkurr, ngala miku kuna narrimi jingkijba nanda jangkurr. Miku kuna narrimi mankuwa nanda wabulinyi yaji. ");
INSERT INTO wrk_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Miku kuna narrimi mankuwa nanda yaji jali ngayu yabimba, jali kajamukunyi yalu jarrba damba marda kaku, baki wardijba yali muwa. Miku kuna narrimi jingkijba nanda yaji jali waluku ngayu dalyamba damba yalungi 5000kanyi. Yankanu bindawarra narri wudumbayi nanda mama jali yalu yingijba. Yankanu barri.” Jananganja yali “Wudumba nurri 12 bindawarra.” ");
INSERT INTO wrk_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Baki mili ngajakayi yalunya Jisuswanyi, “Buyingka barri baku mili ngayi dalyamba mama yalungi muramukuyngka 4000kanyi. Dalyamba ngayi 7 damba yalungi waluwa yali jarrba. Bayngkani barri yankanu bindawarra narri wudumbayi nanda mama nanamanji jali yalu yingijba. Yankanu.” Jananganja yali, “Wudumba nurri 7 bindawarra nanamanji barri.” ");
INSERT INTO wrk_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Mili yanybayi Jisus yalungi, “Jilijba kuna narri jingkijba. Jilijba kuna.” Barriwa. Miku yaliyanyi jingkijba nangangi jangkurr bululunyi yajinyi. Jalili yalu yabimba damba, bakili yalu yarrijba nanda bululu yaji kandirrina, bakili bululunba mama. Walkurrambakili nanda mama bululuwanyi yajiwanyi. Baki nani barri yalu Barasimuku baki Yirud. Yalu barrinani nanda bululu yaji. Yalu yabimbaka kaja balki yaji, baki nanankardi barri yalunjalu yabimbaka yingkamuku yalu yabimbikanyi kaja balki yaji marda. Barriwa. ");
INSERT INTO wrk_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Birlbirdamba yali kanja karrurrinybarri, baki wanbiya yali nananyina yajina niji Bidsayida. Jawudanymukunyi, yali kuyu kabuji nganinyi nangandurri Jisusyurri. Kudanyu yali ngajaka Jisus, nyulu marrimbiji nanda kabuji, nyulu kunymambiji. ");
INSERT INTO wrk_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Marrimbayi kabuji marni Jisuswanyi, baki yalilijbayi danbiyurri barrawuyabarrawuyana. Jabulabayi Jisuswanyi kabuji yami, baki marrimba nyuli kabuji marniyudinyi. Ngajakayi kabuji Jisuswanyi, “Najba kuna ninji yaji.” ");
INSERT INTO wrk_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Ningkiningkijbayi yaji nganinyiwanyi, baki yanyba nyuli, “Ngayu najbangka nganinyimuku, ngala yalu barrinani kurndamuku jilalaykurri.” ");
INSERT INTO wrk_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Mili marrimbayi nanda nganinyi Jisuswanyi. Yarrijba nangki Jisus marni nanganginyina yamina. Mili ningkiningkijbayi yaji nganinyiwanyi, baki najba nyuli yaji kunymamba. Najba nyuli bukamba yaji jujunkurri. ");
INSERT INTO wrk_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Baki yanybayi Jisus nangangi, “Mikujiyi jilajba barrawuyabarrawuyarri, ngala wijbakiyi nganyinkurri barndarri.” Baki manjijbayi nanda nganinyi nanganginkurri barndarri Jisuswanyi. Barriwa. ");
INSERT INTO wrk_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Baku barri mili yali jilajba langki, Jisus marda nanganginmuku kandimuku. Jilajba yali langki nanankurri yajiyurri bundu nananyina barrawuyabarrawuyana, niji Sisariya Bilibayi. Ngala yali jilajba yubalina, baki ngajaka nyuli nangangi kandimuku Jisuswanyi, “Wanyingkanyi yalu yanybaka ngaki. Wanyi ngayu. Wanyi.” ");
INSERT INTO wrk_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Jananganja yali Jisus kandimukunyi, “Yanybaka yalu yinini yinini jangkurr nganyi. Yingkamuku yalu yanybaka nganyi, ninji Jun Ngurrunbawarr. Yingkamuku yalu yanybaka nganyi, ninji nanda wankalanyi Yalayija, mili wankijbayi. Yingkamuku yalu yanybaka nganyi, ninji wankalanyi jali yanyba jangkurr nangangi Kudkanyi.” Barriwa. ");
INSERT INTO wrk_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Yanybayi Jisus yalungi, “Ngala narri barri, wanyingkanyi narri yanybaka ngaki. Wanyi ngayu.” Baki jananganjayi Bidawanyi, “Ninji barri Krayis. Ninji nanda Krayis jali manjijba Kudwanyi.” Nani barri jananganjayi Bidawanyi. Kamambarra barri yanybayi Kud yalungi wankalanyi. Karuyi yalunya, baku barri juju, janyulu manjijba walkurra mambuka. Janyulu jilajba nanda mambuka lalanbiji yalunya Jumuku. Baki jayalu nijarrijba nanda mambuka Krayis. Jingkijbayi Bidawanyi, nanda nganinyi Jisus, nyulu nanda mambuka Krayis jali manjijba Kudwanyi. ");
INSERT INTO wrk_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Baki jirrinybayi yalunya Jisuswanyi, “Miku janarri karu yingkamuku nanankanyi jangkurranyi ngaki, ngayu Krayis. Miku janarri karu yalunya nani ngaki.” Barriwa. ");
INSERT INTO wrk_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Nanamunanyi barri milidimbayi yalunya kandimuku Jisuswanyi. Karu nangki yalungi, “Ngayu Buwanya Bukambijuyngka. Ngayu karungka narrinya, jayalu yabimba kiji ngaki, nanamukunyi mambukamukunyi, baki malbumalbuwanyi jurjkanyi baki milidimbawarrmukunyi yuwanyi. Jayalu yabimba kiji ngaki. Janganjalu manjijba janybiji ngaka. Jangaka janyba, ngala baku barri kujarraka barndayka, jangayu mili wankijba barri.” ");
INSERT INTO wrk_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Nani barri nyuli yanyba yurlurrmba jangkurr. Ngala nanangini kandiwanyi Bidawanyi, nyuli kuyu Jisus danbiyurri, baki yanybayi Bida nangangi Jisuskanyi, “Mikujiyi yanyba nanda jangkurr, yalu yabimbikanyi kiji nganyi, marda janybikanyi nganyingka. Mikujiyi yanyba nani barri.” ");
INSERT INTO wrk_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Yangkalamba nangki Jisus mankanyi. Ningkijba nyuli Bida, baki yanyba nyuli nangangi, “Barriwa barri, Barlbakiyi ngakinbunanyi. Nyuli yanyba nanda jangkurr ngaki Sayidin. Ninya karuyi Sayidinwanyi, ninji yanybiji nanda jangkurr ngaki. Miku nganyingkimi mankumanku yajinyi barrinani nangka mankumankuka Kud yajinyi. Ngala nganyingka mankumankuka yajinyi barrinani nganinyi nangka mankumankuka yajinyi.” Barriwa. ");
INSERT INTO wrk_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Baki kayayi Jisus yalungi muramukuyngka baki nanganginmukuyngka kandimukuyngka, yalu jungunki nangandu. Baki yanyba nyuli yalungi, “Jaliyi narri nulijba jilaykanyi ngakindu, baki marda narringkimi miku lalanba narringka. Marda narrimi yurlwa narringinkanyi yajinyi. Mardakimi nanda narringi yaji miku jirrinyi nganyi. Jaliyi narri jilajba ngakindu, baki yiningki kurdanbaja ninya yingkawanyi. Yiningki janyulu kurdanba ninya, milidimbangangi narri ngaki jangkurr. ");
INSERT INTO wrk_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Jaliyi narri kudanyu nulijba jungunkanyi wanka nayiba yajina yurrngumba, baki janarringka janyba. Ngala jaliyi narringka janyba, mikungangi narringkiyi yangkalamba ngakinbunanyi, ngala narri durrijbayi ngaki jangkurr kudanyu barri, jaliyi narringka janyba nanankardi barri, baki janarri mili wanka jungku yurrngumba barri. ");
INSERT INTO wrk_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","37","Mankumanku narringka nganiyngkanyi jirdi kajanyi yajinyi. Mirnarrijba nyulu muwa nanganginkanyi yajinyi. Ngala warriyaluku. Mankumanku nangka nanganginkanyi yajinyi, ngala miku nangkimi mankumanku nangangi Kudkanyi. Nangangi yaji jirrinyi nangangi, ngala miku nyulu Kud jirrinyi nangangi. Jalija nangka janyba, baki miku janyulu mili wanka jungku. Mikuwali nanganginyi yajiwanyi mili wankamba nanda nganinyi. ");
INSERT INTO wrk_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Kajamuku yalu balkimiku. Yalu yurlwangka nangangi Kudkanyi. Yalu yabimbaka balki yaji nangangi Kudkanyi. Yalungka yangkalamba nanganbunanyi yuwananyi Kudkanyi. Nani barri yalu balkimuku. Ngayu Buwanya Bukambijuyngka, jangayu walkurra mambuka barrinani Buwakanya Kud. Baku barri jangayu wijba. Jangayu wijba kingkarrinya, baki nanamuku Yanjilmuku, jayalu jilajba ngakindu. Jaliyi narri yurlwa ngaki nanijba barri, jaliyi narri manyirru ngaki baki ngakinkanyi jangkurranyi, baki jangayu yurlwa narringi, jangayu manyirru narringi jalija ngayu wijba.” Barriwa. ");
INSERT INTO wrk_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Mili yanybayi Jisus yalungi, “Kudiya narri jala narri jungku nayiba ngakindu, janganarri najba janybikurri ngaka. Baki janganarri najba mili wankiykurri baku barri. Kudiya narringi, miku narringkiyi janyba waluwa ngayuja wankijba mili. Baku barri jangayu jungku kingkarri nangandu ngakinyina Buwakayu, baki janyulu lalanba yalunya bukambiju, jala yalu kuyu ngaki jangkurr. Janyulu lalanba yalunya kudanyu barri.” Barriwa. ");
INSERT INTO wrk_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Baku barri 6 kambana, kirrijba yali dungalana, Jisus marda murrku nanganginmuku kandimuku, Bida marda buwakula Jayims baki Jun. Kirrijba yali juju kingkarri yundurrinybana dungalana yaluman. Jali yalu jungku nanaba yundu, baki yangkalamba nangki Jisus. Mankanyi nangangi bilirrbayi barrinani kamba, jali nangka yangkalamba Jisus. ");
INSERT INTO wrk_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Marda jumbala nangangi bilirrbayi bunyala kudanyu barri. Mikuwali yingka jumbala bilirrba nani barri. ");
INSERT INTO wrk_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Baki yali najba Jisus murrkuwanyi, marda yali najba kujarra mili karrinjankurri wilina nangandu. Buli malbuwuya wankalawuya, jali bula jungku juju wabula kamambarra. Yingka wankala nyuli Musis, marda yingka wankala nyuli Yalayija. Badajba buli kingkarrinya. Yanyba yalungki, malbuwuya baki Jisus. Barriwa. Nani barri yali najba yaji kandimukunyi. Najba yali Jisus marda malbuwuya yanybikurri yalungka. Barriwa. ");
INSERT INTO wrk_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Yanybayi Bida nangangi Jisuskanyi, “Mambuka. Yuku barri kunyba nurru nayiba naykanyi narrinya. Jangayu yabimba murrku ngarndu wanjirr, yingka nganyi, yingka nangangi Musiskanyi, marda yingka nangangi Yalayijakanyi. Yabimba jangayu ngarndu narringi.” ");
INSERT INTO wrk_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Ngala muningka yanybayi Bida nanda jangkurr. Muningka nyuli yanyba, marralangangi yali kandimuku. Marrala yali kudanyu barri. ");
INSERT INTO wrk_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Ngala walajbayi ngalu. Walajbayi ngalu waykalinya, baki murumbayi yalunya ngaluwanyi. Baki manku yali jangkurr ngaluna kandimukunyi. Yanybayi Kud ngaluna, “Nayinda ngaki jandanyi, jala ngayu maruka muwa nangangi. Mankukiyi nangangi jangkurr.” Barriwa. ");
INSERT INTO wrk_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Baki kujba yalungki dulu lukuluku kandimuku, ngala miku yaliyanyi najba nanankujarra wankalawuya. Mikuyaji bulangi nanaba. Ngawamba karrinjayi Jisus yalundu. Barriwa. ");
INSERT INTO wrk_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Karrala yali wayka dungalananyi. Ngala yali karrala wayka, baki yanybayi Jisus yalungi. Jirrinyba nyuli yalunya, “Mikujiyi karu yalunya nanankanyi jali narri najba. Ngayu Buwanya Bukambijuyngka, jangaka janyba, ngala baku barri jangayu wankijba mili. Yuku barri nanamanji baku janarri karu yalunya nanankanyi jali narri najba dungalana. Yuku barri nanamanji baku barri, ngala jilijbawa yaji.” Barriwa. ");
INSERT INTO wrk_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Baki yali ngayangayijba nanganginkanyi jangkurranyi. Miku yaliyanyi karu yingkamuku nanankanyi jali yalu najba dungalana. Ngala yililikajba yalungki nanganginkanyi jangkurranyi, janangka janyba, baki janyulu baku mili wankijba. Yililikajba yalungki nanankanyi jangkurranyi, mikungangi yaliyanyi jingkijba nanda jangkurr. ");
INSERT INTO wrk_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Baki ngajaka yali Jisus kandimukunyi, “Nanamuku milidimbawarrmuku yuwanyi, wanyingkanyi yalili yanyba nayi barri, ‘Waluku janyulu wijba nanda wankalanyi Yalayija. Janyulu wijba waluku.’ Wanyingkanyi yalili yanyba nani barri. Wanyingkanyi.” ");
INSERT INTO wrk_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Jananganjayi yalunya Jisuswanyi, “Yuku barri. Yanybayi Kud najana. Yanyba nyuli nayi, ‘Waluku barri janyulu badajba. Janyulu badajba nanda barrinani Yalayija. Janyulu badajba karunki yalunya kunybanyi jangkurranyi, baki janyulu kunymamba bukamba yaji. Janyulu karu yalunya, marda yalimi ngindu muwa, yurlwangangi yalu nanankanyi yuwanyi Kudkanyi. Waluku barri janyulu badajba, baki baku barri badajbaja nanda yingka, Buwanya Bukambijuyngka. Janyulu badajba bayngkani nangandu nananyina barrinani Yalayija. Jayalu yurlwa nangangi, jayalu linjumba nangangi mankanyi.’ Barriwa. ");
INSERT INTO wrk_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Ngala ngayu karungka narrinya nanginkanyi jangkurranyi. Nanda nganinyi barrinani Yalayija, ngala nyuli badajba yalundurri, ngala yali yurlwa nangangingangi. Yali linjumba, yali kurdanba, barrinani yanybayi najana Kudkanyi, jayalu yabimba yaji nangangi.” Barriwa. Nani barri yanybayi Jisus yalungi, ngala yali karrala wayka dungalananyi. ");
INSERT INTO wrk_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Karrala yali kula wayka jambarri, Jisus marda kandimuku nangangi. Wijba yali yalundurri, yingkamukuyngkurri kandiyurri yalungi. Walkurra muramuku yali jungku nanaba yalundu kandimukunyina, marda kudiya jali yalu milidimbawarrmuku yuwanyi. Jakakajba yalungki kandimuku marda milidimbawarrmuku. ");
INSERT INTO wrk_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Jali yalu najba Jisus jilaykurri yalundurri muramukunyi, baki manmala yali. Kudanyu yali manmala, baki wirlku yali nangandurri. ");
INSERT INTO wrk_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Ngajakayi nangangi kandimuku Jisuswanyi, “Wanyingkanyi narringka jakakajabangka. Wanyingkanyi.” ");
INSERT INTO wrk_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Yanybayi nganinyi nangangi Jisuskanyi, “Milidimbawarr. Warriyaluku ngaki jandanyi. Ngayu kuyungka nganyindurri. Ngankijbayi wuwarr nangandu mankanyina, baki nyulu jakudiyngka. Mikuwali yanyba. ");
INSERT INTO wrk_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Balkimbaka kaburr wawarrwanyi. Janybaka nanda kaburr jambarri wuwarrwanyi. Jabula kanngangka janyina, baki bijba nangka mayi. Baki nganarrkalijbangka mankanyi. Ngayi ngajaka yalunya nganyinmuku kandimuku. Ngayi ngajaka yalunya, jakaji nanda wuwarr, ngala miku yaliyi jakajba. Miku yaliyi kunymamba ngaki jandanyi. Miku.” ");
INSERT INTO wrk_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Yanybayi Jisus yalungi muramukuyngka, “Bukambiju narri, jala narri jungku nanijba, miku narrimi kuyu ngaki jangkurr. Narri yurlwangka ngaki. Ngayu jungkuka narrindu yurrngumba. Ngayu milidimbaka kaja narrinya, ngala miku narrimi kuyu ngaki jangkurr. Wanyimbala janarri kuyu ngaki jangkurr. Wanyimbala.” Baki yanybayi Jisus nangangi nijanganjiyngkanyi, “Kuyukiyi nanda kaburr ngakindurri. Kuyukiyi.” ");
INSERT INTO wrk_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Kuyu nyuli nangangi jandanyi nangandurri Jisusyurri. Jali najba Jisus wuwarrwanyi, baki ngirringirrimbayi nanda kaburr wuwarrwanyi. Ngirringirrimba nyuli kaburr. Yirrbayi kaburr jambarri, baki kanngayi jabula janyina. ");
INSERT INTO wrk_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Ngajakayi nijanganjinyi Jisuswanyi, “Wanyimbala nyuli lunji jalannga barri.” Jananganjayi nijanganjinyiwanyi, “Lunji nyuli ngala nyuli bayakarda juka yurrngumba barri. ");
INSERT INTO wrk_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Dabakili kaburr yurrngumba wuwarrwanyi. Janybakili jangurri baki wabudarri kurdanbiji. Ngala yuku kuna ninji kunymamba ngaki jandanyi. Jaliyi yuku ninji kunymamba, baki ngindukiyi muwa ngalingi, baki yabimbakiyi nanda kunyba yaji ngalingi barri.” ");
INSERT INTO wrk_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Yanybayi Jisus nangangi, “Wanyingkanyi nganinji ngajaka, yuku kuna ngayu kunymamba nganyi jandanyi. Marda ninjimi kuyu ngaki jangkurr. Jala yalu kuyu ngaki jangkurr, baki nganjalu jingkijba, yuku ngayu kunymamba yalunya jala yalu lunji, yuku ngayu wankamba yalunya jala yalungka janyba. Marda ninjimi marda kuyu ngaki jangkurr.” ");
INSERT INTO wrk_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Baki nginduyi nanda nijanganjinyi, baki kudanyu yanyba nyuli nangangi Jisuskanyi, “Bijal ngayu kuyungka nganyi jangkurr. Ngala nganinjikiyi kandimba, baki jangayu mili kuyu nganyi jangkurr kudanyu barri.” Barriwa. ");
INSERT INTO wrk_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Kulwayi Jisus, baki najba nyuli yalunya muramuku wirlkunkurri nangandurri. Baki jirrinyba nyuli nanda wuwarr, “Ninji wuwarr, ngayu jirrinybaka ninya, walajbakiyi nanganbunanyi mankanyinanyi kaburrnanyi. Walajbakiyi. Mikujiyi mili wijba nanganginkurri mankanyiyurri.” ");
INSERT INTO wrk_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Kayayi nanda kaburr. Kaya nyuli kudanyu barri. Ngirringirrimbayi kaburr wuwarrwanyi, baki walajbayi wuwarr nanganbunanyi mankanyinanyi. Muningka kulukayi kaburr jambana, baki ngamu nangki janyba. Yanyba yalungki, “Janyba nangki nayinda kaburr. Janyba nangki.” ");
INSERT INTO wrk_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Ngala marrimbayi kaburr marni Jisuswanyi, baki kingkarrumba nyuli nanda kaburr. Baki karrinjayi yuku barri. ");
INSERT INTO wrk_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Kamu barri barlba yali, Jisus marda kandimuku. Ngankijba yali barrawuna, baki jungkuyi yaluman. Ngajaka yali Jisus kandimukunyi, “Yuku ninji jakajbayi nanda wuwarr, ngala wanyingkanyi miku nurriyi jakajba. Wanyingkanyi.” ");
INSERT INTO wrk_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Jananganjayi yalunya Jisuswanyi, “Jalija ninji jakajba wuwarr barrinani nanda wuwarr, baki marda narrimi waluku yanyba mududu nangangi Kudkanyi. Marda narrimi kudanyu yanyba mududu nangangi Kudkanyi, waluwa narri jakajba wuwarr barrinani nanda.” Barriwa. ");
INSERT INTO wrk_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Baki mili yali barlba nanamunanyi yajinanyi, Jisus marda nanganginmuku kandimuku. Jilajba yali kula baki kangandijba yali nananyina walkurranyina yajina, niji Kalili. Jilajba yali karda. Mikukiyanyi nulijba jisus yalungi kajamukuyngka, yalu jingkiykanyi nyuli nanaba. Karda nyuli jilajba. ");
INSERT INTO wrk_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","Baki milidimba nyuli yalunya kandimuku nangangi. Yanybayi Jisus yalungi, “Jawudawanyi, janganjalu wudumba Buwanya Bukambijuyngka. Janganjalu marrimba, baki janganjalu kurdanba. Jangaka janyba, baki baku barri jangayu wankijba mili. Kujarraka barndayka jangayu mili wankijba barri.” Barriwa. ");
INSERT INTO wrk_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Ngala nanganginmukunyi kandimukunyi, miku yaliyanyi jingkijba nangangi jangkurr. Miku yaliyanyi jingkijba, ngala marrala yali nangangi ngajakankanyi. Baki miku yaliyanyi ngajaka Jisus nanankanyi jangkurranyi. ");
INSERT INTO wrk_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","34","Mili yali jilajba Jisus baki kandimuku. Jilajba yali karri Kabirnayumyurri. Ngala yali jilajba yubalina, baki jakakajba yalungki kandimuku. Kardarda yalungki jakakajba, wanyi yalungi mili walkurra yingkamukuyngka. Wanbiya yali barrawuyabarrawuyana, baki ngankijba yali barrawuna. Ngala yali jungku nanaba, baki ngajakayi yalunya Jisuswanyi, “Wanyi nanda jangkurr jali narringka yanyba yubalina. Wanyi nanda jangkurr.” Barriwa. Ngala miku yaliyanyi jananganja Jisus. Karda yali jungku, manyirrungangi yali nanankanyi yalunginkanyi jangkurranyi. ");
INSERT INTO wrk_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Jungkurrijba nangki Jisus, baki yanyba nyuli yalungi kandimukuyngka 12kanyi, “Jaliyi ninji nulijba jungunkanyi walkurra mambuka, baki marda nganyingkimi bayakardamba. Marda ninjimi waki yalungi yingkamukuyngka.” ");
INSERT INTO wrk_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Wudumbayi juka Jisuswanyi, baki karrinjarrijba nyuli nanda juka burrandi yalundu. Marrimba nyuli juka jaluyudinyi, baki yanyba nyuli yalungi kandimukuyngka, ");
INSERT INTO wrk_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Najba janarri nayinda juka. Miku nyulu walkurra mambuka, ngala muningka nyulu bayakarda. Marda narrimi lalanba yalunya, nanamuku jala yalu miku walkurra mambuka, ngala muningka bayakarda jungku. Marda narrimi lalanba nanamuku jala yalu bayakarda barrinani nayinda juka. Jala narri lalanbaka nanda bayakarda, baki nanda barrinani jala nanda nganarri lalanba. Nanda barrinani jala nganarri lalanba, marukangangi ngayu muwa yalungi bayakardanyi. Jala nganarri lalanbaka, baki nanda barrinani jala narri lalanbaka Kud, manjijbangangi ngana Kudwanyi narrindurri.” Barriwa. ");
INSERT INTO wrk_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Baku barri yanybayi kandi, niji Jun, nangangi Jisuskanyi. Yanyba nyuli, “Milidimbawarr. Najba nurri nganinyi jakaykurri wuwarr mankanyinanyi. Jakajba nyuli wuwarr nijarriykanyi ninya niji. Ngala miku nyulimi kandi ngambalangi, baki kurrkunba nurri nanda nganinyi. Karu nurri, marda nyulimi miku jakajba wuwarr, mikungangi nyulimi kandi ngambalangi.” ");
INSERT INTO wrk_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Ngala yanybayi Jisus nangangi, “Marda ninjiyanyi miku kurrkunba nanda nganinyi jakaykanyi wuwarr. Nanda jala yabimbaka ngiruka yaji nijarriykanyi ngana niji, baki miku nyuliyi baku yanyba balki jangkurr ngaki. Miku nyuliyi yurlwa ngaki baku barri. ");
INSERT INTO wrk_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Nanamuku jala yalu miku yurlwa ngambalangi, yalu kandimuku ngambalangi. ");
INSERT INTO wrk_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Kudanyu ngayu karungka narrinya. Narri ngakinmuku. Jaliyi yingkawanyi yabimba kunyba yaji narringi, jaliyi nyulu wajba narrinya wabudanyi ngala narri warrinjijba, narringangi ngakinmuku kandimuku, baki janyulu yabimba kunyba yaji nangangi Kudwanyi. Janyulu yabimba kunyba yaji nanankanyi, jali nyulu yabimba kunyba yaji narringi barri.” Barriwa. ");
INSERT INTO wrk_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Mili barri karuyi yalunya bayamukuyngka Jisuswanyi. “Yalu kuyungka ngaki jangkurr bayamukunyi. Yalu yabimbaka kunyba yaji ngaki. Jaliyi yingkawanyi nyulu milidimbaka bayamuku, yalu yabimbikanyi balki yaji, baki nanda balkimirra. Nanda balkimirra, jaliyi yingkawanyi nyulu yabimbaka bayamuku, yalu yabimbikanyi balki yaji. Dabaja nanda nganinyi kudanyu barri Kudwanyi. Jaliyi nyulu yabimba balki yaji nani barri, baki marda nangkimi janyba. Jaliyanyi nangka janyba wabula, baki miku nyuliyanyi yabimba bayamuku yalu yabimbikanyi balki yaji. Jaliyanyi nangka janyba wabula, baki miku nyuliyanyi yabimba nanda balki yaji nani barri. Baki miku nyuliyanyi daba nanda nganinyi Kudwanyi. ");
INSERT INTO wrk_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Ninji yabimbaka yaji marniyudinyi. Jaliyi nganyingka mankumanku yabimbikanyi balki yaji nganyinjudinyi marniyudinyi baki nanda balki. Jaliyi nganyingka mankumanku yabimbikanyi nanda balki yaji, jaliyi ninji yabimba nanda yaji, baki miku ninjiyi jilajba kingkarri nangandurri Kudyurri, ngala janinji jilajba wayka jangurri Yilyurri. Marda nganyingkimi kurrkunba yabimbikurri nanda balki yaji marniyudinyi, baki janinji jilajba kingkarri nangandurri Kudyurri. Barriwa. ");
INSERT INTO wrk_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Ninji jilajbangka nukamina. Jaliyi nganyingka mankumanku jilaykanyi nukamina, ninji yabimbikanyi balki yaji, baki nanda balki. Jaliyi nganyingka mankumanku jilaykanyi, baki yabimbikanyi nanda balki yaji. Jaliyi ninji jilajba baki yabimba nanda yaji, baki miku ninjiyi jilajba kingkarri nangandurri Kudyurri, ngala janinji jilajba wayka jangurri Yilyurri. Marda nganyingkimi kurrkunba jilaykurri nukamina yabimbiji nanda balki yaji, baki janinji jilajba kingkarri nangandurri Kudyurri. Barriwa. ");
INSERT INTO wrk_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Ninji najbangka yaji yamiyudinyi. Jaliyi ninji najba yaji, baki nanankardi nganyingka mankumanku balkinyi yajinyi, barrinani jala ninji najba yingka jibarri, baki nganyingka mankumanku kulukankanyi nangandu, jaliyi nganyingka mankumanku nanankanyi balkinyi yajinyi nani barri, jaliyi ninji yabimba nanda balki yaji, baki nanda balki. Jaliyi nganyingka mankumanku nanankanyi jali ninji najba, baki ninji yabimba nanda balki yaji, baki miku janinji jilajba kingkarri nangandurri Kudyurri, ngala janinji jilajba wayka Yilyurri. Marda nganyingka nganyingkimi kurrkunba yabimbikurri nanda balki yaji jali ninji najba, baki janinji jilajba kingkarri nangandurri Kudyurri. Barriwa. ");
INSERT INTO wrk_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Nanaba wayka Yilnyina, yalu jarrbangka barnyi yurrngumba barri mawuwanyi. Baki mikuwali mungijba jangu. Yajbangka yaji yurrngumba barri janguwanyi. ");
INSERT INTO wrk_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Jaliyi narringka miku yangkalamba ngakinbunanyi jala yingkamukunyi yalu wajba narrinya kijinyi, baki janarri jardijba ngiruka kurdulu. Janarri jardijba mili ngiruka kurdulu ngaki. Barriwa. ");
INSERT INTO wrk_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Nanda ngarrawa, nanda kunyba barnyinyi. Kunymambaka barnyi jarrkanyi ngarrawawanyi. Ngala jaliyi nanda ngarrawa jardibirri, baki ngambala janyba nanda ngarrawa. Nanda ngarrawa miku kunyba barnyinyi jala nyulu jardibirri. Narri barrinani nanda ngarrawa. Marda narringkimi mardumardumba muwa, baki marda narrimi mardumardu muwa yalungi yingkamukuyngka. Marda narrimi maruka muwa yalungi. Nani barri janarri kunymamba yalunya yingkamuku, barrinani kunymambaka barnyi ngarrawawanyi. Ngala jaliyi narringka miku mardumardumba muwa, jaliyi narringka jakakajba yajinyi, baki narri barrinani nanda jardibirri ngarrawa jali yalu janyba. Narri barrinani nanda jardibirri ngarrawa, mikungangi narriyi yabimba yalunya yingkamuku, yalu jungunkanyi mardumardu muwa. Miku.” Barriwa. Nani barri yanybayi Jisus yalungi. ");
INSERT INTO wrk_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Baki yali barlba nanamunanyi yajinanyi, Jisus marda nanganginmuku kandimuku. Jilajba yali kula yingkayurri yajiyurri, niji Judiya. Birlbirdamba yali bundal niji Jurdan, baki jilajba yali kula Judiyayurri. Kajamuku yali jilajba nangandurri Jisusyurri, jabarri nyuli milidimba yalunya. ");
INSERT INTO wrk_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Baki jawuda Barasimuku, yali jilajba nangandurri. Balanja yali Jisus. Ngajaka yali Jisus Barasimukunyi, “Jaliyi nyulu yingijba nangangi maninganja nganinyiwanyi, jaliyi muningka nyulu manjijba nanda nanganbunanyi, miku nyulu mili nangangi maninganja, baki jungkuka kuna nyulu kunybana yuwana. Wanyi ninji yanyba.” Nani barri yali ngajaka Jisus balanjanki. ");
INSERT INTO wrk_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Jananganjayi yalunya Jisuswanyi, “Wanyi yanybaka nanda yuwa nangangi Musiskanyi yingiykanyi maninganja. Wanyi yanybaka nangangi yuwa maykarrayngka.” ");
INSERT INTO wrk_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Jananganja yali, “Nanda yuwa nangangi Musiskanyi yanybayi nayi barri, ‘Yuku nyulu wajba nangangi maninganja najanyi nganinyiwanyi. Yuku nyulu wajba najanyi jala yanybaka, miku nanda jibarri mili nangangi maninganja. Yuku nyulu wajba nanda jibarri nanankanyi najanyi, baki muningka manjijba nanda jibarri nanganbunanyi.’ Nani barri nangangi yuwa yanybayi.” ");
INSERT INTO wrk_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Yanybayi Jisus yalungi, “Nani barri yanybayi Musis, jingkijbangangi nyuli narrinya, narri jardibirri kurdulu nangangi Kudkanyi. Miku narriyi kuyu nangangi jangkurr, jala milidimba narrinya Kudwanyi. ");
INSERT INTO wrk_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Juju wabula kamambarra jali mikuyaji yajinyi, baki yabimbayi bukamba yaji Kudwanyi. Baki karungka ngambalanya jangkurrwanyi Kudkanyi, jali yabimba bukamba yaji Kudwanyi, baki yabimba nyuli nganinyi baki jibarri. ");
INSERT INTO wrk_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Baki yanybayi Kud, ‘Mardakimi nganinyiwanyi yingijba bulanya nijanganjinyi marda ngardanganja. Marda nyulimi maninganja wudumba, baki jabula malumba jungku yurrngumba maykarra bula. ");
INSERT INTO wrk_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Waluku bula kujarra, ngala bayngkani barri bula maykarra barrinani yingamali.’ Maykarra bula jungkuka malumba barrinani yingamali. ");
INSERT INTO wrk_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Yanybaka Kud, jala nanankujarra maykarra jungkuka barrinani yingamali, baki mardakimi yingkawanyi miku nyalimba bulanya. Mardakimi miku nyalimba bulanya yingkawanyi. Jungkuka nganinyi balkina yuwana Kudkanyi jaliyi nyulu muningka manjijba nangangi maninganja.” Nani barri jananganjayi yalunya Jisuswanyi. ");
INSERT INTO wrk_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Kamu barri wijba yali Jisus baki kandimuku barndarri. Jali yali jungku barndana, baki mili yali ngajaka Jisus maykarrayngka kandimukunyi. ");
INSERT INTO wrk_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Baki yanybayi Jisus yalungi, “Jaliyi muningka nyulu manjijba nangangi maninganja nanganbunanyi nganinyiwanyi, baki nyulu wudumbaka yingka jibarri nanganginkanyi maninganjanyi, baki nanda balki. Barimba nyulu kuluka nangandu. Nyulu jungkuka balkina yuwana Kudkanyi, yuwajiwangangi nanda waluwinyi jibarri nangangi maninganja. ");
INSERT INTO wrk_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Jabarri jaliyi muningka nyulu yingkijba nangangi nawinganja jibarriwanyi, baki nyulu wudumbaka yingka nganinyi nanganginkanyi nawinganjanyi, baki nanda balki. Barimba nyulu kuluka nangandu. Nyulu jungkuka balkina yuwana Kudkanyi, yuwajiwangangi nanda waluwinyi nganinyi nangangi nawinganja.” Barriwa. Nani barri milidimbayi yalunya maykarrayngka Jisuswanyi. ");
INSERT INTO wrk_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Baku barri kudiyawanyi yali kuyu bayamuku nangandurri Jisusyurri. Kajamuku bayamuku yali kuyu nangandurri. Nulijba yali nangangi, nangka yarriykanyi marni yalundu, nyulu yanybikanyi mududu nangangi Kudkanyi yalungi. Baki janyulu lalanba yalunya Kudwanyi, janyulu yabimba kunyba yaji yalungi. Ngala nanganginmuku kandimuku Jisuskanyi, yali ngirrwa yalungi. Kudanyu yali ngirrwa yalungi, jali kuyu bayamuku nangandurri, ");
INSERT INTO wrk_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","15","Mankuyi yalunya ngirrwankurri yalungi Jisuswanyi, baki yanybayi Jisus yalungi kandimukuyngka, “Janarri munyajba bayamuku jilaykanyi ngakindurri. Marda narrimi miku kurrkunba yalunya. Nanginmukunyi bayamukunyi, ngana yalu jingkijbangka, miku ngayimi jujambawarr. Yalu kuyungka ngaki jangkurr, baki nanankardi nyulu lalanbaka yalunya Kudwanyi. Jaliyi nganinyiwanyi jingkijba ngana barrinani nanginmukunyi bayamukunyi ngana yalu jingkijbangka, baki janyulu marda lalanba nanda Kudwanyi, barrinani nyulu lalanbaka nanginmuku bayamuku. Ngala jaliyi nganinyiwanyi miku jingkijba ngana, barrinani nanginmukunyi bayamukunyi ngana yalu jingkijbangka, baki miku nyuliyi lalanba nanda nganinyi Kudwanyi. Mikumirra.” Barriwa. ");
INSERT INTO wrk_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Baki marrimbayi bayamuku jaluna Jisuswanyi. Nganarrijbayi yalunya, yarrijba nangki marni yalundu bayamukunyina, baki yanyba nyuli mududu nangangi Kudkanyi yalungi. Ngajaka nyuli Kud, nyulu lalanbiji yalunya. Barriwa. ");
INSERT INTO wrk_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Mili jilajbayi Jisus kula. Ngala nyuli walajba barrawuyabarrawuyananyi, baki wirlkuyi nganinyi nangandurri. Mururu nyuli wayka nangandu, baki yanyba nyuli nangangi Jisuskanyi, “Ninji barri kunyba milidimbawarr. Wanyi kunyba yaji jangayu yabimba, baki janyulu wankamba ngana Kudwanyi, ngayu jungunkanyi mili wanka nangandu yurrngumba barri. Wanyi kunyba yaji jangayu yabimba.” ");
INSERT INTO wrk_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Jananganjayi nanda nganinyi Jisuswanyi, “Wanyingkanyi ninji yanyba ngaki, ngayu kunyba. Ngawamba Kud, nyulu kunyba ngambalangi. Yingkamuku, miku yalimi kunyba, ngawamba nyulu kunyba. ");
INSERT INTO wrk_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Ninji jingkijbangka nanda yuwa nangangi Kudkanyi, jali nyulu jirrinyba narrinya bukambiju. Nayinda nanda yuwa nangangi Kudkanyi. Mikujiyi kurdanba nganinyi. Mikujiyi kuluka yingkana jibarrina jala miku nganyi maninganja. Mikujiyi maninjakujba yaji. Mikujiyi jujamba yaji yalungi yingkamukuyngka. Mikujiyi jujamba yaji wudumbiji bayngkani dungala. Kuyukiyi bulangi jangkurr, nganyingkanyi nijanganjiyngkanyi baki yarrijiyngkanyi. Nani barri nanda yuwa, jala marda ninjimi durrijba.” ");
INSERT INTO wrk_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Yanybayi nganinyi nangangi Jisuskanyi, “Milidimbawarr, jingkijba ngayi nanda yuwa jali ngayu juka, baki ngayangayijba ngayi nanankanyi yuwanyi yurrngumba jukananyi. Yurrngumba ngayu ngayangayijba bukamba nanankanyi yuwanyi.” Barriwa. ");
INSERT INTO wrk_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Ningkijbayi nganinyi Jisuswanyi, baki maruka nyuli muwa nangangi. Yanybayi Jisus nangangi, “Yingka mili yaji marda ninjimi yabimba, baki janinji jungku kunyba nangangi Kudkanyi. Barlbakiyi, baki wajbakiyi yingkamuku bukamba nganyingkanyi yajinyi dungalanyi. Janinji wudumba kaja dungala nganyingkanyi yajinyi. Wajbakiyi yalunya nanankanyi dungalanyi, nanamuku jala yalu jungku mikuyaji dungalanyi. Wajbakiyi yalunya nanankanyi kajanyi dungalanyi. Baki barriwa, baki wijbakiyi ngakindurri. Jilalajbakiyi ngakindu yurrngumba barri. Baki yuku barri janyulu mirnarrijba Kud muwa nganyi, janyulu mili wankamba ninya.” Barriwa. ");
INSERT INTO wrk_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Jali nyulu manku nanda jangkurr nangangi Jisuskanyi nganinyiwanyi, baki barlba nyuli. Baki ngindu nyuli muwa nanankanyi jangkurranyi. Ngindu nyuli muwa, jungkungangi nyuli kajayudi yajiyudi marda dungalayudi. Barlba nyuli nanganbunanyi Jisusnanyi, ngala miku nyuliyala yabimba nanda jali karu Jisuswanyi. Barriwa. ");
INSERT INTO wrk_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Baki yanybayi Jisus nanganginkanyi kandimukuyngka, “Warriyaluku barri jala nyulu kajayudi yajiyudi baki dungalayudi. Jardibirri nyulu jungunkanyi kandi nangangi Kudkanyi, nyulu lalanbikanyi Kudwanyi. Jardibirri nyulu jungunkanyi kandi nangangi Kudkanyi, jala nyulu kajayudi yajiyudi.” ");
INSERT INTO wrk_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Manmala yali kandimuku. Manmala yali nanganginkanyi jangkurranyi. Baki mili yanybayi Jisus yalungi, “Jala nganinyi jirdi kajanyi yajinyi, jala nyulu nulijba jungunkanyi kandi nangangi Kudkanyi baki nanda jardibirri. ");
INSERT INTO wrk_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Jalimi nanda kamil ngankijba kalawunyi yamina nidilina, baki nanda jardibirri. Mikuwali ngankijba. Ngala jala nganinyi jirdi kajanyi yajinyi, jala nyulu kuyu jangkurr nangangi Kudkanyi, jala nyulu kandi nangangi Kudkanyi, baki nanda jardibirri nyulu kudanyu barri.” Barriwa. ");
INSERT INTO wrk_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Jali yalu manku nanda jangkurr nangangi Jisuskanyi, baki manmala yali kandimuku. Manmala yali kudanyu barri, baki ngajaka yali Jisus, “Jaliyi jardibirri jungunkanyi kandi nangangi Kudkanyi, baki wanyinmuku janyulu marrimba yalunya mardarda Kudwanyi. Wanyinmuku jayalu wankijba mili nangandu kingkarri.” ");
INSERT INTO wrk_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Baki nyuli ningkijba yalunya Jisuswanyi, baki jananganjayi, “Miku yalungkimi wankamba. Miku. Ngawamba Kudwanyi, yuku nyulu wankambaja yalunya mili. Yuku barri nyulu. Ngawamba Kudwanyi, yuku nyulu marrimbaka yalunya mardarda. Yuku nyulu yabimbaka bukamba yaji Kudwanyi.” ");
INSERT INTO wrk_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Yanybayi kandi Bida nangangi, “Ngala nurru barri, yingijba nurri bukamba nurrungi yaji nganyi, baki jilajba nurru nganyindu.” ");
INSERT INTO wrk_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Jananganjayi Jisuswanyi, “Karungka ngayu duja jangkurranyi. Nanda jala ngaki kandi, nyuli yingijba bukamba yaji ngaki. Yingkijba nyuli nangangi barnda. Marda yingijba nyuli yalunya, buwanganjamuku marda majunganjamuku, marda bababanyamba nyulu yalunya. Yingijba nyuli nangangi ngardanganja marda nijanganjinyi. Yingkijba nyuli yalunya, nanganginmuku jandanyimuku marda, baki kardikardimba nyulu yalunya, baki yingijba nyuli nangangi jamba. Bukamba nanganginmuku nyuli yingijba yalunya ngaki. ");
INSERT INTO wrk_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","Ngala jangayu wajba nanda yingkanyi yajinyi. Kajanyi yajinyi jangayu wajba. Jangayu wajba nanda kajanyi barndanyi baki jambanyi. Jangayu wajba kajanyi buwanganjanyi, kajanyi majunganjanyi, kajanyi bababanyamba nyulu yalunya. Jangayu wajba kajanyi ngardanganjanyi, kajanyi nijanganjiyngkanyi. Jangayu wajba kajanyi jandayngkanyi, kajanyi kardikardimba nyulu yalunya, Kajanyi yajinyi jangayu wajba nanda jali nyulu yingijba bukamba nangangi yaji ngaki. Baki jangayu munyajba yalunya waykurri nanda kijinyi. Jangayu munyajba yalunya linjumbikurri nangangi mankanyi. Ngala janyulu jungku mili wanka yurrngumba barri. Janyulu jungku mili wanka kingkarri nangandu Kudnyina. ");
INSERT INTO wrk_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Kajamuku jala ngamu yalu walkurra, janyulu baku bayakardamba yalunya Kudwanyi. Janyulu bayakardamba yalunya jala ngamu yalu walkurra. Ngala yingkamuku jala yalungka mankumanku, yalu bayakarda, janyulu walkurramba yalunya Kudwanyi. Janyulu walkurramba yalunya barri.” Barriwa. Nani yanybayi Jisus yalungi, ngala yali jilajba yubalina. ");
INSERT INTO wrk_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Mili yali jilajba kula Jirusalimyurri, Jisus marda nanganginmuku kandimuku. Jilajbayi Jisus waluwa, ngala jilajbayi kandimuku bayngkani nangandu, baki yingkamuku yalundu. Manmala yali kandimuku Jisuskanyi. Manmala yali nangangi, nyulu wiykanyi Jirusalimyurri. Ngala nanamuku yingkamuku yalundu, yali marrala yajinyi. Mili yanybayi Jisus yalungi nanganginmukuyngka kandimukuyngka. Kardarda nyuli yanyba yalungi. Mikuyaji yingkanyi mankunkanyi nangangi jangkurr, ngawamba kandimukunyi. Karu nyuli yalunya nanankanyi jalija yabimba yaji nangangi baku barri yingkamukunyi. ");
INSERT INTO wrk_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Yanybayi Jisus yalungi, “Narri. Ngambalaja jilajba kularriji. Ngambalaja jilajba nanankurri Jirusalimyurri. Janganjalu wudumba, Buwanya Bukambijuyngka. Janganjalu wudumba walkurrawanyi mambukawanyi jurjkanyi, marda milidimbawarrmukunyi yuwanyi. Jayalu yanyba ngaki, marda ngakimi janyba. Baki ngaki jayalunjalu wajba ngurranyimuku. ");
INSERT INTO wrk_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Janganjalu bajalingijba nanamukunyi ngurranyimukunyi. Jayalu yanyba balki jangkurr ngaki. Jayalu kakalijba ngaki. Janganjalu wajuba kurulyudinyi. Janganjalu langandaba kurndana. Nani barri janganjalu kurdanba barri. Ngala baku barri kujarraka barndayka jangayu mili wankijba. Nanamanji barri jangayu mili wankijba barri.” Nani barri yanybayi Jisus yalungi, nanganginmukuyngka kandimukuyngka. Barriwa. ");
INSERT INTO wrk_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Ngala yali jilajba kula yubalina, baki jilajba buli bundu nangandurri Jisusyurri, buwakula Jayims baki Jun. Bulangi nijanganjinyi, nangangi niji Sibidi. Jilajba buli bundu nangandurri, baki yanyba buli nangangi, “Milidimbawarr. Janinya ngaliya ngajaka yajinyi, janinji yabimba nanda yaji ngalingi.” ");
INSERT INTO wrk_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Jananganjayi bulanya Jisuswanyi, “Wanyimba jangayu nimbalangi. Wanyimba.” ");
INSERT INTO wrk_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Baki jananganja buli, “Jalija ninji jungku walkurra mambuka kingkarri yajina Kudkanyi, baki janinji kuyu ngalinya kingkarri nganyindu, ngaliya jungunkanyi nganyindu, jungunkanyi yingka janyanyina nganyindu, yingka wakunyina nganyindu, jangaliya jungku barrinani mambukawuya bayngkani nganyindu. Nani kuna jangaliya jungku nganyindu jalija ninji jungku walkurra mambuka kingkarri barri.” ");
INSERT INTO wrk_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Jananganjayi bulanya Jisuswanyi, “Miku nimbalimi jingkijba nanda jangkurr jali ngana ngajaka. Janganjalu linjumba. Janganjalu kurdanba. Nani kuna jayalu linjumba nimbalanya, jayalu kudanyu linjumba nimbalanya marda. Nulijba kuna nimbala nanankanyi linjumbikanyi nimbalanya, barrinani jayalu yabimba yaji ngaki. Nani kuna nimbala nulijba.” ");
INSERT INTO wrk_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Jananganja buli buwakulawanyi, “Yuku barri ngali. Yuku jayalu ngalinya linjumba nani barri.” Baki mili yanybayi Jisus bulangi, “Jayalu linjumba nimbalanya. Jayalu kudanyu linjumba nimbalanya barrinani janganjalu linjumba. ");
INSERT INTO wrk_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Ngala wanyinmuku jayalu jungku walkurra ngakindu. Miku ngayiyi yarrijba yalunya, jalija yalu jungku walkurra ngakindu. Ngala ngakinyi Buwakayu, janyulu nyulu yarrijba yalunya yingka janyanyina, baki yingka wakunyina ngakindu. Birrirrinja nyuli nanamukuyngka jalija yalu jungku mambuka bayngkani ngakindu. Yiningki nimbala. Yiningki yingkamuku.” ");
INSERT INTO wrk_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Ngala manku yali yaji yingkamukunyi kandimukunyi. Manku yali bulanya ngajakankurri Jisus nanankanyi yajinyi, baki yali ngarrangarra muwa bulangi, Jayimskanyi baki Junkanyi. ");
INSERT INTO wrk_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Baki nyuli karu yalunya Jisuswanyi, yaluja jilajba nangandurri, baki nyuli yanyba yalungi, “Narri barri. Jingkijba narri yalunya walkurramuku mambukamuku ngurranyimuku. Yalu yanybaka nyilala jangkurr yalungi. Yalu ngirrwawarrmuku. Yingkamuku yalu birrirra yalungi. ");
INSERT INTO wrk_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Ngala narri barri, marda narrimi miku jungku walkurra mambuka barrinani yalu ngurranyimuku jungkuka walkurra mambuka. Miku. Jaliyi yingamali narringi, jaliyi nyulu nulijba jungunkanyi walkurra mambuka, baki marda nangkimi bayakardamba. Marda nyulimi lalanba yalunya yingkamuku. Marda nyulimi waki yalungi yingkamukuyngka. ");
INSERT INTO wrk_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Jaliyi nyulu nulijba jungunkanyi mili walkurra yalungi, baki marda nyulimi jungku barrinani wakiwarr yalungi. Marda nyulimi waki kudanyu yalungi yurrngumba barri. ");
INSERT INTO wrk_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Marda nyulimi jungku barrinani ngayu. Ngayu Buwanya Bukambijuyngka yalungi, ngala badajba ngayi lalanbiji yalunya, miku yaluwali lalanbiji ngana. Jayalu mili wankijba nangandu Kudnyina, janybangangi jangaka yalungi.” Barriwa. ");
INSERT INTO wrk_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Mili yali jilajba kula, baki wanbiya yali barrawuyabarrawuyana niji Jiriku. Baki mili yali barlba nanamunanyi bayungu barri, Jisus marda nanganginmuku kandimuku. Walajbayi walkurra muramuku, baki jilajba yali nangandu Jisusnyina. Jungkuyi nganinyi wilina yubalina. Nyuli kabuji yami. Niji nangangi Bardimayus. Nangangi nijanganjinyi, niji nangangi Dimayus. Jungku nyulili wilina yubalina nanda kabuji, bakili nyulu ngajaka yalunya dungalanyi, jalili yalu jilajba nanganbiyangka. ");
INSERT INTO wrk_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Jungkuyi nanda kabuji wilina yubalina, ngala jilajbayi walkurra muramuku nanganbiyangka. Manku nyuli yalunya yanybikurri yalungka nangangi Jisuskanyi, jali nyulu mungkiji nanankanyi yajinyi, niji Nasarid. Yanyba yalungki nangangi jisuskanyi, nyuli nanaba yalundu. Baki kayayi nanda kabuji. Kaya nyuli kudanyu barri, “Jisus. Ninji jandanyi nangangi wankalanyi Dayibidkanyi. Ngindukiyi muwa ngaki kabujinyi. Ngindukiyi muwa ngaki.” Nani barri nyuli kaya kudanyu barri. ");
INSERT INTO wrk_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Kajamuku yali ngirrwa nangangi kurrkunbiji kayankurri. Ngala mili nyuli kaya kudanyu barri, “Jisus, ninji jandanyi nangangi Dayibidkanyi. Ngindukiyi muwa ngaki.” ");
INSERT INTO wrk_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Jilajbayi Jisus, baki karrinjayi. Baki yanyba nyuli, “Kuyukiyi kawa ngakindurri nanda kabuji.” Kudiya yali jilajba nangandurri kabujiyurri, baki yanyba yali nangangi, “Yuku barri, walajbakiyi kawa. Kayangka Jisus nganyi. Nyulu kayangka nganyi. Walajbakiyi kawa.” ");
INSERT INTO wrk_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Dulaba nangki danyan nanda kabuji, baki walajbayi. Baki jilajba nyuli nangandurri Jisusyurri. ");
INSERT INTO wrk_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Ngajakayi kabuji Jisuswanyi, “Wanyimba jangayu nganyi. Wanyimba.” Jananganjayi kabujiwanyi, “Milidimbawarr. Nulijba ngayu mili naykanyi yaji. Ngayimi mili najba yaji.” ");
INSERT INTO wrk_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Baki yanybayi Jisus nangangi, “Barriwa barri barlbakiyi. Nganinji jingkijbangka, yuku ngayuja kunymamba ninya. Jangayu yabimba ninya naykanyi yaji, jingkijbangangi nganinji, yuku ngayuja kunymamba ninya.” Baki yinarramba najbayi yaji nanangini kabujiwanyi. Najba nyuli yaji, baki jilajba nyuli nangandu Jisusnyina mili bayungu barri. Barriwa. ");
INSERT INTO wrk_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Jilajba yali bayungu, Jisus baki nanganginmuku kandimuku. Bunundujba yali Jirusalimyurri. Nanda barrawuyabarrawuya Jirusalim, nanda yaji bayinga, ngala yingka bayakarda barrawuyabarrawuya niji Bidbaj, nanda yaji kulaya, ngala yingka bayakarda barrawuyabarrawuya niji Bidani karriya. Ngala langkiya barri nanda kulawira niji Yulib. Ngala yali bunundujba Jirusalimyurri, baki manjijbayi Jisuswanyi kujarra kandiwuya waluwa yalundu. ");
INSERT INTO wrk_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","Jirrinyba nyuli bulanya, “Janimbala ngankijba nayinda barrawuyabarrawuya kulaya, baki nanaba janimbala wakaramba yirrikirri. Janimbala wakaramba yirrikirri walkurra bijal kijijinyi. Jilijbawa yalu jungku ngulurrina yirrikirrina. Janimbala dulaba kurul, baki kuyu nimbalaja ngakindurri. ");
INSERT INTO wrk_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Jaliyi yingkawanyi ngajaka nimbalanya, wanyimba nimbalaja nanda yirrikirri, baki janimbala jananganja, ‘Nyulu nulijbangka yirrikirrinyi nanda mambuka, ngala janyulu manjijba nganyindurri kamu barri jalija nyulu bukamba.’ Nani barri janimbala jananganja.” Barriwa. ");
INSERT INTO wrk_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Barlba buli kandiwuya, baki wakaramba buli yirrikirri kijijinyi danbina barrawuna. Dulaba buli kurul. ");
INSERT INTO wrk_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Ngala kudiyamukunyi jali yalu karrinja nanaba, najba bulanjali dulaykurri kurul, baki ngajaka yali, “Wanyimba janimbala yirrikirrinyi. Wanyingkanyi nimbala dulaba kurul.” ");
INSERT INTO wrk_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Jananganja buli nanankanyi jangkurranyi jali karu bulanya yanybikanyi Jisuswanyi. Baki manjijba yali yirrikirri bulandu. Barriwa. ");
INSERT INTO wrk_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Baki kuyu buli nanda yirrikirri nangandurri Jisusyurri. Dulaba buli bulangi danyan, baki yarrijbayi nanda jumbala yirrikirrina ngulurrina. Baki jungkuyi Jisus yundu ngulurrina. ");
INSERT INTO wrk_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Kajamuku yali nangandu Jisusnyina, walkurra muramuku. Yingkamukunyi yali dulaba yalungi danyan, baki yarrijba yali yubalina, nanda yirrikirri jilaykanyi nyulu jumbalana. Ngala yingkamukunyi, yali dalyamba wanjirr kurndananyi, baki yarrijba yali wanjirr yubalina. Nani barri yalili yabimba yaji, jalili badajba walkurra mambuka yidambiji yalunya. ");
INSERT INTO wrk_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","10","Baki yingkamuku yali jilajba walu nangandu Jisusnyina, ngala yingkamuku yali jilajba bayngkani nangandu. Bukambiju yali kaya kunyba jangkurr nangangi Kudkanyi. Kudanyu yali kaya nangangi, “Nayinda nyulu walkurra mambuka. Nurru wajbangka Kud kunybanyi jangkurranyi nurrunginkanyi, nangangingangi Jisuskanyi. Ninya nurru ngajakangka, janinji yabimba kunyba yaji nangangi Jisuskanyi. Nyulu walkurramirra mambuka nurrungi Jumukuyngka, barrinani nanda wankalanyi Dayibid, nyuli walkurramirra mambuka yalungi barri. Mirnarrijbangka nurru muwa nangangi barri.” Nani barri yali kaya, ngala yali jilajba yubalina nangandu. ");
INSERT INTO wrk_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Jali ngankijba Jisus Jirusalim karrina muwa, baki jilajba nyuli walkurrayngkurri jurjyurri nanaba. Ngankijba nyuli kalawuyngkurru, baki ningkijba nyulu yaji nanaba kalawuyngkurru. Kudanyu nyuli ningkijba yaji lukuluku barri, baki mili walajba nyuli jurjnanyi. Baki barlba yali karri, Jisus baki nanganginmuku kandimuku. Jilajba yali karri nanankurri bayakardarri barrawuyabarrawuyarri, niji Bidani. Jilajba yali kulukanki nanaba, ngabungabungangi nyuli yaji. ");
INSERT INTO wrk_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Munganawa barri jali yalu wijba karrina Bidaninanyi, baki birrkalanyi nyuli Jisus. ");
INSERT INTO wrk_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Najba nyuli kurnda barrinani kalawumbi jujunkurri. Nanda kurnda kajayudi wanjirryudi. Jilajbayi Jisus nanankurri kurndarri wudumbiji mama. Ngala najba nyuli mikuyaji mamanyi nanaba, ngawamba wanjirr. Jilijbawa jardijbangka mama. ");
INSERT INTO wrk_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Baki yanybayi Jisus nanankanyi kurndanyi, “Miku jayalu mili jarrba mama nanginkanyi kurndanyi, mikuwalingangi jardijba mili mama nanginyina kurndana.” Kandimuku nangangi Jisuskanyi, yali nanaba nangandu. Manku yali nanda jangkurr jali yanyba Jisus nanankanyi kurndanyi. Manku yali nangangi jangkurr. Barriwa. ");
INSERT INTO wrk_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Mili yali jilajba. Wanbiya yali Jirusalim, baki ngankijbayi Jisus walkurranyina jurjina nanaba. Ngankijba nyuli, baki najba nyuli yalunya nanaba. Yalunjali wawajba yajinyi dungalanyi, baki wudumba yali bayngkani dungala yajinyi. Najbayi yalunya Jisuswanyi, baki ngarrangarrayi muwa. Jakajba nyuli yalunya bukambiju nanamunanyi jurjnanyi. Janyba nyuli yalungi darladarlamuku dungalayudi. Kudiya yali jungku darladarlana, jali yalunjalu wajba kulukukunyi dungalana. Baki janyba nyuli yalungi darladarla marda. ");
INSERT INTO wrk_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Kudiyamukunyi muningka yali kuyu yalungi yaji kalawuyngkurru barrikina lukuluku nananyina jurjnyina. Birlbirdamba yali barriki yalunginjudinyi yajiyudinyi. Kurrkunbayi yalunya Jisuswanyi. Ngirrwa nyuli yalungi, “Miku narriyi kuyu yaji nayiwa. Janarri kuyu yaji nanawa danbina lukuluku barri.” ");
INSERT INTO wrk_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Milidimbayi yalunya Jisuswanyi. Yanyba nyuli nayi barri, “Nanda naja nangangi Kudkanyi yanybaka, ‘Kajamuku jayalu badajba ngakinkurri walkurrayngkurri jurjyurri. Jayalu badajba kajananyi yajinanyi ngurranyimuku. Jayalu yanyba mududu ngaki nanaba.’ Nani barri yanybaka jangkurr najana Kudkanyi, ngala narri barri, narri maninjakumuku. Narri maninjakujbangka yaji nanginyina nanganginyina jurjina.” Nani barri yanybayi Jisus yalungi. ");
INSERT INTO wrk_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Ngala mambukamuku jurjkanyi baki nanamuku jali yalu milidimba yuwanyi Musiskanyi, yali nanaba marda jurjina. Manku yali nanda jangkurr nangangi Jisuskanyi, baki nulijba yali kurdanbikanyi Jisus. Baki yanyba yalungki, yanka jayalu kurdanba. Ngala marrala yali nangangi Jisuskanyi. Marrala yali nangangi. Kajamukunyi yali manku Jisus milidimbikurri jangkurranyi Kudkanyi. Manku yali nangangi jangkurr, baki bukambiju yali manmala nanganginkanyi jangkurranyi. Manmala yali bukambiju, baki nanankardi barri marrala yali nangangi mambukamuku jurjkanyi baki milidimbawarrmuku. ");
INSERT INTO wrk_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Jali nyulu ngabungabu yaji, baki mili barlba yali Jirusalimnanyi, Jisus baki kandimuku. Jilajba yali karri nanankurri yingkayurri barrawuyabarrawuyarri kulukaja nanaba. Barriwa. ");
INSERT INTO wrk_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Munganawa barri wijba yali Jirusalimyurri. Wijba yali nananyina yubalina jali yalu jilajba wulani. Najba yali nanda kurnda jali ngirrwa Jisus nangangi. Dukujbayi bukamba wanjirr. Janyba nangki mankanyi nangangi. ");
INSERT INTO wrk_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Mankuwayi Bidawanyi nanda jangkurr jali ngirrwa Jisus nanankanyi kurndanyi. Baki yanyba nyuli nangangi Jisuskanyi, “Milidimbawarr. Najbakiyi nanda kurnda jali ninji ngirrwa. Janyba nangki barri. Janyba nangki.” ");
INSERT INTO wrk_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Yanybayi Jisus yalungi kandimukuyngka, “Marda narrimi kuyu nangangi jangkurr Kudkanyi. ");
INSERT INTO wrk_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Ngayu karungka narrinya, jaliyi narri kudanyu kuyu nangangi jangkurr Kudkanyi, baki janarri jingkijba Kud. Janarri jingkijba Kud, janyulu yabimba nanda yaji jala narri ngajaka Kud yabimbikanyi yaji. Miku narringkimi mankumanku nangangi, yiningki janyulu yabimba narringi yaji Kudwanyi, yiningki miku. Janarri jingkijba Kud, janyulu yabimba nanda yaji jala narri ngajaka. Jaliyi narri kudanyu kuyu nangangi jangkurr nani barri, baki yuku barri janarri marda yabimba nanamannga ngiruka yaji. Janarri yanyba kulawiranyi, ‘Ninji kulawira, walajbakiyi. Yirrirdkunumba nganyingkiyi. Jungkukiyi kanjana.’ Nani barri janarri yanyba kulawiranyi, baki janyulu ngayangayijba narringinkanyi jangkurranyi. Janangka yirridkurnumba. Janyulu jungku kanjana. ");
INSERT INTO wrk_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Jala narri ngajaka Kud yajinyi, jaliyi narri kudanyu kuyu nangangi jangkurr Kudkanyi, jaliyi narri jingkijba Kud, janyulu yabimba nanda yaji jala narri ngajaka Kud yabimbikanyi yaji, baki janyulu yabimba nanda yaji narringi. Janyulu yabimba nanda yaji jala narri ngajaka. ");
INSERT INTO wrk_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Waluwa narri yanyba mududu nangangi Kudkanyi, waluwa narri ngajaka Kud yajinyi, baki marda narringkimi mankumanku, jaliyi yingkawanyi yabimba balki yaji narringi barri. Baki marda narrimi manjamanjamba nanda balki yaji jali nyulu yabimba narringi. Marda narrimi mamanumba nangangi balki yaji. Baki narringinyi Buwakayu kingkarri, janyulu manjamanjamba narringi balki yaji marda. Baki yuku barri janarri yanyba mududu nangangi Kudkanyi. Janarri ngajaka Kud yajinyi.” Barriwa. ");
INSERT INTO wrk_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Mili yali jilajba bayungu, baki wanbiya yali Jirusalim. Baki mili ngankijbayi Jisus walkurranyina jurjina. Jilajba yali nangandurri, mambukamuku jurjkanyi, marda milidimbawarrmuku yuwanyi, marda malbumalbu. ");
INSERT INTO wrk_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Ngajaka yali Jisus, “Wanyingini yarrijba ninya mambuka. Wanyingini ninya karu jakaykanyi yalunya jurjnanyi. Wanyingini ninya karuyi milidimbikanyi yalunya.” Barriwa. ");
INSERT INTO wrk_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Jananganjayi yalunya Jisuswanyi, “Waluku barri jangayu ngajaka narrinya yajinyi. Jaliyi nganarri jananganja, baki yuku jangayu karu narrinya, wanyingini ngana karuyi yabimbiji yaji nani barri. ");
INSERT INTO wrk_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Ngala waluku barri janganarri karu, wanyingini manjijbayi nganinyiyurru Jun ngurrunbiji yalunya. Wanyingini manjijbayi. Yiningki Kudwanyi, yiningki nganinyiwanyi. Waluku janganarri karu.” Barriwa. ");
INSERT INTO wrk_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Baki karda yalungki jakakajba. Yanyba yalungki, “Wanyingkanyi jangambala jananganja. Wanyingkanyi. Jaliyi ngambala yanyba, manjijbayi Jun Kudwanyi, baki janyulu yilikajba ngambalanya, ‘Ngala wanyingkanyi miku narriyanyi kuyu nangangi jangkurr.’ Nani janyulu yilikajba ngambalanya, jaliyi ngambala yanyba, manjijbayi Jun Kudwanyi. ");
INSERT INTO wrk_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Ngala kajamuku muramuku, yalu yanybaka nangangi Junkanyi, nyuli yanybawarr jangkurranyi nangangi Kudkanyi, jali manjijba Kudwanyi. Jaliyi ngambala yanyba, manjijbayi Jun nganinyiwanyi, baki yiningki jangamanjalu daba. Marrala ngambala yalungi. Yiningki jangamanjalu daba, jaliyi ngambala yanyba, manjijbayi nganinyiwanyi.” Barriwa. Nani barri yalungki jakakajba wanyingkanyi jangkurranyi jayalu jananganja Jisus. ");
INSERT INTO wrk_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Nanankardi barri yali jananganja, “Miku nurriyi jingkijba, wanyingini manjijbayi Jun. Miku nurriyi jingkijba.” Barriwa. Baki yanybayi Jisus yalungi, “Miku nganarriyanyi jananganja kunymamba, baki miku ngayiyi jananganja narrinya. Miku ngayiyi karu narrinya nanankanyi jali ngana karu milidimbiji yalunya.” Barriwa. ");
INSERT INTO wrk_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Mili barri yanybayi Jisus yalungi milidimbiji yalunya. Muningka nyuli yanyba yalungi, “Karrinjarrijbayi krayib wanjirr malbuwanyi nanganginyina jambana. Karrinjarrijba nyuli kaja wanjirr jambana. Yabimba nyuli barriki lukuluku jambana, baki kurrijba nyuli lawarr. Nanda lawarr jidimbikanyi ngarrki krayibnanyi. Baki nyuli yabimba barrawu jungunkanyi nganinyi kalawunyi, jala nyulu lalanba nanda jamba. Nani nyuli yabimba yaji malbuwanyi. Baki yarrijba nyuli yingkamuku nganinyimuku, yalu lalanbiji nangangi jamba. Baki janyulu wajba yalunya kudiyayngka krayibkanyi lalanbikanyi nangangi yaji. Baki barlba nyuli yingkayurri yajiyurri. Barlba nyuli juju, baki jungku nyuli nananyina yajina yurrngumba barri. Barriwa. ");
INSERT INTO wrk_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Jardijbayi wanjirr walkurra mamayudi. Jali nanda mama kunyunyu, baki manjijbayi nangangi wakiwarr malbuwanyi. Manjijba nyuli yalundurri, jala lalanba nangangi jamba. Manjijbayi nanda wudumbiji nangangi mama, kudiyambikanyi kudukudu. ");
INSERT INTO wrk_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Ngala nanamuku nganinyimuku jali yalu lalanba nangangi jamba, miku yaliyi kunybamuku. Marrimba yali nanda wakiwarr jali manjijba malbuwanyi. Wajuba yali, baki mili manjijbayi nangandurri malbuyurri mikuyaji mamanyi nangandu. ");
INSERT INTO wrk_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Ngala manjijbayi yingka wakiwarr yalundurri lalanbawarrayngkurri wudumbiji nangangi mama. Ngala marrimba yali nanda wakiwarr marda. Daba yali kulaji, baki yabimba yali balki yaji nangangi. ");
INSERT INTO wrk_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Manjijbayi yingka mili malbuwanyi, ngala yali kurdanba nanda yingka. Mili wakiwarrmuku manjijbayi malbuwanyi, wudumbiji nangangi mama. Jabarri mili yalunjali marrimba nanamukunyi balkimukunyi lalanbawarranyi. Kudiya yali wajuba. Kudiya yali kurdanba barri. ");
INSERT INTO wrk_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Baki manjijbayi yingka yalundurri malbuwanyi. Manjijba nyuli nanganginmirra jandanyi, jali nyulu kudanyu maruka muwa nangangi. Mankumanku nangki malbu, ‘Jalija jilajba ngakinmirra jandanyi yalundurri, baki jayalu karda jungku. Miku yaliyi daba. Jayalu kuyu nangangi jangkurr.’ ");
INSERT INTO wrk_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Ngala jali yalu najba nangangi jandanyi jilaykurri yalundurri, baki yanyba yalungki, ‘Nayinda jala badajbangka, nyulu jandanyi nangangi malbunyi. Jalija nangka janyba malbu, baki nangini nanganginyi jandanyiwanyi, janyulu wudumba nayinda jamba ngabayidi. Jangambala marrimba, jangambala kurdanba, baki jangambala kuyu nayinda jamba ngabayidi ngamanginkanyi barri.’ Nani barri yalungki yanyba. ");
INSERT INTO wrk_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Baki jali wanbiya nanda jandanyi, baki marrimba yali. Kurdanba yali, baki janyba yali nangangi mankanyi danbiyurri barrikina.” Barriwa. ");
INSERT INTO wrk_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Baki ngajakayi yalunya Jisuswanyi, “Wanyimbaja malbuwanyi yalunya, jali nyulu yarrijba lalanbikanyi nangangi yaji. Wanyimba janyulu yalungi. Jangayu karu narrinya. Janyulu badajba nanganginkurri jambarri, baki janyulu kurdanba nanamuku balkimuku lalanbawarrmuku. Janyulu kurdanba yalunya, baki janyulu yarrijba yingkamuku lalanbikanyi nangangi jamba. Janyulu yarrijba kunybamuku lalanbawarrmuku. Barriwa.” ");
INSERT INTO wrk_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Mili yanybayi Jisus yalungi, “Jingkijba kuna narri nayi jangkurr najana Kudkanyi jala muningka yanybaka, ‘Jali yalu yabimba barrawu, baki miku yaliyanyi nulijba yingamali kurnda. Ngala janyba yali nanda kurnda. Ngala baku barri yingkawanyi, nyuli yabimba barrawu nangangi Kudkanyi. Wudumba nyuli nanda kurnda jali yalu waluwa janyba, baki yarrijba nyuli yundukula nanganginyina barrawuna Kudkanyi. Nanda jirrinyi kurnda nanganginyina barrawuna.’” Barriwa. Nani yanybayi Jisus yalungi, nyuli barrinani nanda jirrinyi kurnda yundukula, jali waluwa yingkawanyi janyba. Kajamuku yali yurlwa nangangi Jisuskanyi, ngala nyuli yarrijba Jisus walkurra mambuka Kudwanyi. ");
INSERT INTO wrk_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Mili barri yanybayi Jisus yalungi, “Mili nanda jangkurr najana Kudkanyi yanybaka, ‘Ngambala najbangka yaji jala yabimbaka Kudwanyi, baki ngambala mirnarrijbangka muwa nangangi,’ Barriwa.” ");
INSERT INTO wrk_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Mankuyi nangangi jangkurr mambukamukunyi jurjkanyi marda malbumalbuwanyi. Manku yali nanda jangkurr jali muningka nyulu yanyba, baki jingkijba yali, nyulu karuyi yingkamuku jangkurranyi yalungi barri. Jingkijba yalungki, nyuli yanyba yalungi, yalu jungunkanyi balki nangangi Kudkanyi. Baki nanankardi barri yali ngarrangarra muwa nangangi. Yali kijiwijba kudanyu barri. Yaliyanyi marrimba Jisus, yaliyanyi janyba brisinyurri, ngala miku yaliyanyi marrimba. Marrala yali yalungi muramukuyngka. Baki nanankardi barri miku yaliyanyi marrimba Jisus nanamanji barri. Ngala barlba yali nanganbunanyi. Barriwa. ");
INSERT INTO wrk_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Manjijba yali yingkamuku nangandurri Jisusyurri. Manjijba yali kudiya Barasimuku, baki kudiya jali yalu durrijba jangkurr nangangi Yirudkanyi, jali yalu nulijba Yirudkanyi yalunginkanyi mambukanyi. Manjijba yalunjali yilikaykanyi jangkurranyi, balanjankanyi Jisus, nyulu yanybikanyi balki jangkurr. ");
INSERT INTO wrk_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Wanbiya yali nangandu Jisusnyina, baki yanyba yali nangangi, “Milidimbawarr. Nurru jingkijbangka ninya, ninji yanybaka duja jangkurr. Ninji milidimbaka duja nangangi Kudkanyi. Miku ninjimi marrala yalungi yingkamukuyngka. Ninji milidimbaka walkurra mambukamuku baki bayakardamuku. Ninji milidimbaka bukambiju yalunya. Karukiyi nurrunya, wanyi ninji yanyba nanginkanyi. Nanda wirimalaru Kubaminkanyi, niji Sisa, nyulu wudumbaka dungala ngamanbunanyi. Nyulu manjijbangka nganinyimuku wudumbiji dungala ngamanbunanyi. Yuku barri kuna yuwanyi Kudkanyi ngambala waykanyi Kubamin mambuka dungalanyi. Jangambala wajba kuna. Yiningki miku ngambaliyi wajba dungalanyi. Wanyi ninji yanybaka.” Nani yali ngajaka Jisus. ");
INSERT INTO wrk_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Ngala jingkijbayi yalunya Jisuswanyi, balanja yali. Muningka yali ngajaka Jisus, nyulu yanybikanyi balki jangkurr nanankanyi mambukanyi Sisakanyi. Baki jaliyi nyulu yanyba balki jangkurr nani barri mambukanyi, baki jayalu marrimba. Baki yanybayi Jisus yalungi, “Wanyingkanyi nganarri balanjaka. Wanyingkanyi narri nulijbangka jujambikanyi nganarri. Minimbakiyi ngaki yingamali dungala, ngayu naykanyi.” ");
INSERT INTO wrk_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Baki minimba yali dungala. Baki ngajakayi yalunya Jisuswanyi, “Wanyi wali nayiba dungalana. Wanyi niji nayiba dungalana. Wanyi barri.” Baki jananganja yali, “Nayinda nangangi wali baki nangangi niji Sisakanyi.” Barriwa. ");
INSERT INTO wrk_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Baki yanybayi Jisus yalungi, “Ngayu karungka narrinya nanginkanyi jangkurranyi. Wajbakiyi Sisa nanankanyi nanganginkanyi yajinyi, ngala wajbakiyi Kud nanankanyi nanganginkanyi yajinyi.” Barriwa. Jali yalu manku nangangi jangkurr, baki manmala yali. Manmala yali nanganginkanyi jangkurranyi. ");
INSERT INTO wrk_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Badajbayi yingkamuku nangandurri Jisusyurri. Yali Sajusimuku jalili yalu durrijba nanda yuwa nangangi Musiskanyi, ngala yalili yanyba, miku ngambaliyi jungku mili wanka yurrngumba, ngala jangambala jungku kurdan yurrngumba barri. Badajba yali nangandurri, baki yanyba yali, ");
INSERT INTO wrk_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","“Milidimbawarr. Yarrijbayi Musiswanyi jangkurr najana Kudkanyi ngambalangi. Nayi nangangi jangkurr yanybaka, jaliyi nangki janyba buwanganja, baki yingijba nyulu nangangi maninganja, ngala bula mikuyaji bardardanyi bulangi. Jaliyi nangka janyba nangangi buwanganja nani barri, baki nanganginyi bababanyamba nyulu, janyulu wudumba nanda jibarri. Baki baku barri jabula wakaramba bardarda, baki jayalu muningka yanyba nanankanyi bardardanyi, ‘Nayinda bardarda, nyulu jandanyi nangangi, nanankanyi buwanganjarruwa. Nyulu nangangi jandanyi.’ Nani barri yanybaka yuwa nangangi Musiskanyi. Nani jayalu muningka yanyba nanankanyi bardardanyi. ");
INSERT INTO wrk_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Janurru nurru karu ninya buwawakulayngka. Kajamuku buwawakula 7-barri. Nanangini lirrkawanyi, nyulu wudumbayi maninganja, ngala bijal barri baku nangki janyba. Mikuyaji bardardanyi bulangi. Mikuyaji. Barriwa. ");
INSERT INTO wrk_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Baki yingkawanyi bababanyamba nyulu bayngkani nangandu, nyuli wudumba nanda miyaji. Ngala janyba nangki nanda nganinyi marda, baki mikuyaji nangangi bardardanyi. Barriwa. Baki yingkawanyi bababanyamba nyulu bayngkani nangandu, nyuli wudumba nanda miyaji, ngala baku barri bijal nangki janyba, mikuyaji nangangi bardardanyi. Barriwa. ");
INSERT INTO wrk_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Nani barri yingkawanyi bababanyamba nyulu, wudumbayi nanda miyaji, baki nangki janyba. Baki yingkawanyi wudumbayi baku, baki yingkawanyi baku barri. Nani barri bukambiju buwawakula yalungki janyba. Ngala nanda miyaji, mikuyaji nangangi bardardanyi. Baki baku barri bayngkani nangki janyba nanda miyaji marda. ");
INSERT INTO wrk_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Baku barri juju, jalija yalu wankijba mili, baki wanyi janyulu nawinganja nanankanyi jibarrinyi. Wanyi barri. Nyuli maninganja yalungi bukambijuyngka buwawakulayngka. Wanyi janyulu nawinganja nanankanyi jibarrinyi.” Barriwa. Nani barri yalu ngajaka Jisus. ");
INSERT INTO wrk_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Ngala jananganjayi yalunya Jisuswanyi, “Barimba narri nanda jangkurr, jali yanyba Musis najana Kudkanyi. Barimba narri nangangi jangkurr. Miku narrimi jingkijba nanda naja Kudkanyi. Baki miku narrimi jingkijba nanda ngiruka yaji jalija yabimba Kudwanyi baku barri. ");
INSERT INTO wrk_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Jalija yalu mili wankijba, baki miku jayalu wudumba maninganja baki nawinganja. Miku jayalu jungku mili maykarra. Ngala jayalu jungku barrinani Yanjilmuku, jala mikuyaji yalungi kayikayinyi. ");
INSERT INTO wrk_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Ngala narri barri, narri yanybaka nanankanyi nganinyiyurruwa, miku nyuliyi wankijba mili. Janyulu jungku kurdan yurrngumba barri. Ngala narri jingkijbangka nanda jangkurr najana Kudkanyi, jali yarrijba Musiswanyi. Ngala jungkuyi Musis mangkurruna yajina, baki yanybayi Kud nangangi. Yanybayi Kud nangangi manikujananyi jali yajba nanda wanjirr. Yanybayi Kud nayinda jangkurr nangangi yalungi wankalamukuyngka, ‘Ngayu Kud nangangi Yabrayamkanyi. Ngayu Kud nangangi Yayisakanyi. Marda ngayu Kud nangangi Jakibkanyi.’ Nani barri yanybayi Kud nangangi yalungi wankalamukuyngka. Mikukiyanyi yanyba Kud, ‘Ngayi Kud nangangi nganinyiyurruwa Yabrayamkanyi. Ngayi Kud nangangi nganinyiyurruwa Yayisakanyi. Ngayi Kud nangangi nganinyiyurrawa Jakibkanyi.’ Mikukiyanyi yanyba Kud nani barri. ");
INSERT INTO wrk_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Miku nyulimi Kud yalungi jala yalu jungku kurdan. Ngala nyulu Kud yalungi nanamukuyngka jala yalu wanka jungku. Nanankardi barri ngambala jingkijba nanamuku wankalamuku, yalu mili wankijba barri, nyulungangi yalungi Kud. Nanangini jangkurrwanyi Kudkanyi minimbaka narrinya, barimba narri nanda jangkurr jungunkanyi mili wanka. Miku narrimi jingkijba nanda ngiruka yaji jalija yabimba Kudwanyi baku. Barriwa.” Nani barri jananganjayi yalunya Jisuswanyi. ");
INSERT INTO wrk_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Yingka jali nyulu jungku nanaba mankunkurri yaji, nyuli milidimbawarr yuwanyi Musiskanyi. Baki jingkijba nyuli, jananganjayi Jisuswanyi kunybanyi jangkurranyi buwawakulayngka. Baki ngajaka nyuli Jisus, “Nanda yuwa jungunkanyi ngambala kunyba nangangi Kudkanyi, kaja nanda jangkurr. Ngala wanyi nanda yingamali jirrinyi jangkurr. Janganinji karu, wanyi yingamali jirrinyi jangkurr.” ");
INSERT INTO wrk_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Jananganjayi Jisuswanyi, “Nayinda barri jirrinyi jangkurr narri ngayangayiykanyi. ‘Bukambiju narri Jumuku. Janganarri manku. Ngambalangi Kud, ngawamba nyulu duja Kud. Nyulu duja wirimalaru ngambalangi. ");
INSERT INTO wrk_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Marda ninjimi maruka muwa nangangi Kudkanyi. Marda ninjimi kudanyu maruka muwa nangangi. Marda ninjimi kudanyu nulijba nangangi Kudkanyi nganyinyina kurduluna. Marda nganyingkimi mankumanku nangangi Kudkanyi nganyinyina kulajina. Marda ninjimi waki kudanyu nangangi barri.’ Nayinda nanda yingamali jirrinyi jangkurr narri ngayangayiykanyi. ");
INSERT INTO wrk_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Marda yingka jirrinyi jangkurr bayngkani nangandu. Nayi barri, ‘Nganyingka maruka muwa, baki nani barri marda ninjimi kudanyu maruka muwa yalungi yingkamukuyngka marda.’ Nanginkujarra jirrinyi yuwa narringi barri. Miku yingka yuwa mili jirrinyi nanginkujarrayngka.” Barriwa. ");
INSERT INTO wrk_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Mili yanybayi nanda milidimbawarr nangangi Jisuskanyi, “Yuku barri milidimbawarr. Kunyba nganyi jangkurr. Ngambalangi Kud, ngawamba nyulu duja Kud. Nyulu duja wirimalaru. Mikuyaji yingkanyi. ");
INSERT INTO wrk_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Kunyba nganyi jangkurr, marda ngambalimi kudanyu maruka muwa nangangi Kudkanyi. Marda ngambalimi kudanyu nulijba nangangi Kudkanyi ngamanginyina kurduluna. Marda ngambalakimi mankumankuwa nangangi Kudkanyi ngamanginyina kulajina. Marda ngambalimi kudanyu waki nangangi. Marda ngambalimi kudanyu maruka muwa yalungi yingkamukuyngka, barrinani ngambalaka maruka muwa. Nanginkujarra jirrinyi yuwa ngambalangi. Jala ngambala wajba Kud barnyinyi, jala ngambala yundijba nanda barnyi nangangi Kudkanyi, baki ngambala yabimba kunyba yaji. Ngala jala ngambala ngayangayijba nanginkujarrayngka yuwanyi, baki ngambala yabimbaka mili kunyba yaji.” Nani barri yanybayi nanda milidimbawarr nangangi Jisuskanyi. ");
INSERT INTO wrk_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Jali manku nangangi jangkurr Jisuswanyi, baki jingkijbayi Jisuswanyi, nyuli kunyba kulaji nanda milidimbawarr, baki jananganja nyuli kunyba jangkurr. Baki yanybayi Jisus nangangi, “Nyulu lalanbaka nanganginmuku kandimuku Kudwanyi. Nyulu lalanbaka yalunya. Ninji jingkijbangka kudiya nangangi yaji Kudkanyi. Barringa barri ninji kandi nangangi Kudkanyi.” Nani barri yanybayi Jisus nangangi. Baki nani barri nyuli jananganja yalunya kunybanyi ngirukanyi jangkurranyi, jali yalu ngajaka Jisus yajinyi. Baki nanankardi barri miku yaliyanyi mili ngajaka Jisus yajinyi. Marrala yalu ngajakankanyi mili jangkurranyi. Barriwa. ");
INSERT INTO wrk_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Jungkuyi Jisus walkurranyina jurjina, baki nyuli milidimba yalunya muramuku yajinyi. “Nanamuku milidimbawarrmuku yuwanyi Musiskanyi yalu yanyba nangangi Krayiskanyi, nanda walkurra nganinyi Dayibid, nyulu barrinani wankalanyi miminganja nangangi Krayiskanyi. ");
INSERT INTO wrk_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Ngala yarrijbayi jangkurr najana Dayibidwanyi. Yarrijba nyuli jangkurr jali minimba Kunybawanyi Ngarnduwanyi Kudkanyi. Nayinda nanda jangkurr jali yarrijba Dayibidwanyi, ‘Yanybayi Kud ngakinkanyi mambukanyi Krayiskanyi. Yanybayi Kud nangangi, “Jungkukiyi ngakindu. Kajamuku jala miku yalimi maruka muwa ngaki, janinya yalu daba, ngala jangayu ngayu yalunya daba wakara barri. Jangayu wakaramba yalunya, jalija ngayu daba yalunya. Baki jayalu jingkijba ninya, ninji barri mambuka yalungi.’” Nani nyuli yarrijba jangkurr najana Dayibidwanyi. ");
INSERT INTO wrk_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Yanybayi Dayibid nangangi Krayiskanyi, nanda Krayis, nyulu nangangi mambuka. Ngala yanka barri nyulu Dayibid barrinani wankalanyi miminganja nangangi Krayiskanyi, nanankanyi jali nyulu kuyu nangangi mambuka. Yanka barri.” Nani barri yanybayi Jisus yalungi muramukuyngka. Baki mirnarrijba yali muwa jali yalu manku nangangi jangkurr. Mirnarrijba yali muwa nanganginkanyi jangkurranyi. ");
INSERT INTO wrk_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Baki mili nyuli milidimba yalunya muramuku, “Najbawa janarri yalunya, milidimbawarrmuku yuwanyi Musiskanyi. Najbawa janarri yalunya. Yalili jilajba wunanybalayudi danyayudi nukamiyurru wayka, baki yingkamukunyi jayalunjalu jingkijba, yalu milidimbawarrmuku yuwanyi. Muningka yalili jilalajba lukuluku barrawuyabarrawuyana. Muningka yalili jilalajba, nulijbangangi yalu yingkamukuynga, yalunjalu naykanyi, marda jingkiykanyi yalungi, yalu jirrinyi nganinyimuku. ");
INSERT INTO wrk_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Jalili yalu jungku jurjina, baki wangarrina, bakili yalu jungku walu barri yalundu mambukamukunyina. ");
INSERT INTO wrk_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Ngala miku yalunjalimi lalanba jibarrimuku miyajimuku, ngala yalili kuyu yaji yalunbunanyi, nanda yalungi yaji. Bakili yalu yanyba mududu nangangi Kudkanyi. Yalili kudanyu yanyba mududu nangangi, nulijbangangi yalungi yingkamukuyngka, yalunjalu naykanyi yanybikurri mududu nangangi. Miku yalimi yanyba mududu kunymamba. Muningka yalu yanyba mududu nangangi nananyina yajina jalija yalunjalu najba kajamukunyi. Ngamu yalu jungku kunyba nangangi Kudkanyi, ngala miku. Nani barri yalili yabimba balki yaji nanamukunyi milidimbawarrmukunyi, baki nanankardi barri janyulu daba yalunya Kudwanyi. Jayalu jungku kurdan yurrngumba barri, jalija yalungka janyba.” Barriwa. ");
INSERT INTO wrk_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Jungkuyi Jisus walkurranyina jurjina bundu darladarlana. Nanda darladarla jangumba yarriykanyi dungala kalawuyngkurru nangangi Kudkanyi. Jungkuyi Jisus bundu darladarlana, baki muningka nyuli najba yalunya. Najba nyuli yalunya nganinyimuku baki jibarrimuku yarriykanyi dungala darladarlana. Nani barri yalili wajba Kud dungalanyi nanamanji barri. Kajamukunyi jirdi kajanyi yajinyi baki kajanyi dungalanyi, yarrijba yali kaja dungala darladarlana, ngala yuwajiwa kaja dungala yalundu. Kiliyi kaja dungala yalundu. ");
INSERT INTO wrk_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Baki jilajbayi jibarri nanankurri. Nyuli miyaji. Ngawamba bijal yaji nangandu. Jilajba nyuli darladarlarri, baki yarrijba nyuli kujarra bayakarda dungala kalawuyngkurru. Nanankujarra dungalawuya barrinani yingamali bayakarda dungala ngambalangi nanijba barri. Yarrijba nyuli nanankujarra bayakardawuya dungala darladarlana. ");
INSERT INTO wrk_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Kandimuku nangangi Jisuskanyi, yali nanaba nangandu jurjina. Baki yanybayi Jisus yalungi, “Ngayu karungka narrinya duja. Nanangini jibarriwanyi miyajiwanyi, nyuli yarrijba barrinani kaja dungala darladarlana. Ngala nanamukunyi yingkamukunyi, yarrijba yali barrinani kujajarra dungala darladarlana. ");
INSERT INTO wrk_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Yarrijba yali kaja dungala kalawuyngkurru, ngala yuwajiwa kaja mili dungala yalundu. Baki nanankardi barri yali yarrijba barrinani kujajarra dungala. Ngala nanangini miyajiwanyi, yarrijba nyuli ngawamba kujarra bayakarda dungala. Ngala yarrijba nyuli bukambiju nangangi dungala darladarlana. Baki nanankardi barri nyuli yarrijba barrinani kaja dungala, mikuyajingangi mili dungalanyi nangandu wudumbikanyi yaji. Mikumirra.” Barriwa. ");
INSERT INTO wrk_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Jali walajba Jisus walkurrananyi jurjnanyi, baki yanybayi yingka kandi nangangi, “Milidimbawarr. Ningkijbakiyi nayinda walkurra jurj, kunybamirra, jirdi kajanyi walkurrayngka dungalanyi jali yalu dalburrijba yabimbikanyi jurj.” ");
INSERT INTO wrk_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Yanybayi Jisus, “Yi. Nayinda jurj walkurra. Ngala dalyawijbaja nayinda jurj bukamba barri. Jarrbalijbaja bukamba dungala. Mikuyaji yingkanyi dungalanyi yundu nangandu. Jarrbalijbaja bukamba dungala.” Barriwa. ");
INSERT INTO wrk_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Baki jilajbayi Jisus karri, baki kirrijba nyuli kulawirana niji Yulib. Baki badajba yali kudiyamuku kandimuku nangandurri, Bida baki Jayims, baki Jun, baki Yandru. Badajba yali yanybiji karda nangangi. Jungku yali karriya kulawirana, baki najba yali nanda walkurra jurj bayinga barri. ");
INSERT INTO wrk_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","Ngajaka yali Jisus, “Karukiyi nurrunya, wanyimbala dalyawijbaja nanda walkurra jurj. Wanyimbala. Yanka janurru jingkijba, jalija dalyawijba, jalija nangka bukamba nayinda yaji. Karukiyi nurrunya, wanyimbaja yaji nanamanji barri.” Barriwa. ");
INSERT INTO wrk_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Baki jananganjayi yalunya Jisuswanyi, “Marda narringkimi lalanbawa, baki marda narrimi miku munyajba yingka jujambikanyi narrinya. ");
INSERT INTO wrk_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Nanamanji jayalu badajba, nanamuku jujambawarrmuku. Waluwa yingka, baki bayngkani yingka, baki yingka, baki yingka. Jayalu yanyba, ‘Ngayu Krayis, nanda jali manjijba Kudwanyi.’ Nani barri jayalunjalu jujamba. ");
INSERT INTO wrk_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Nanamanji barri janarri manku yaji yalungi yingkamukuyngka, jayalungka daba. Janarri manku yaji yalungi, jayalungka daba, yingkamuku bundu narringinyina yajina, ngala yingkamuku juju. Ngala marda narrimi miku marrala. Marda narrimi miku marrala, jalija narri manku yaji yalungka daykurri. Bunjulijba jayalungka daykanyi, ngala jilijbawa bukambaja yaji Kudwanyi. ");
INSERT INTO wrk_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Ngayu karungka narrinya, jayalungka daba. Yalu, jala yalu jungku yingkana yajina, baki yingkana yajina, jayalungka daba ngurranyimuku. Baki nanamanji barri kulbaja jamba marda. Kudanyu barri kulbaja kudukudu jamba, bundu baki juju barri. Baki mikuwali jardijba nanda mama kajana yajina, baki jayalu birrkalanyi jungku, mikuyaji mamanyi. Bukamba nayinda kiji badajbaja waluwa, baki bayngkani barri mili kiji badajbaja, walkurra kiji. Barriwa. ");
INSERT INTO wrk_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","Marda narringkimi lalanbawa. Nanamanji barri jayalu marrimba narrinya, baki janarrinya kuyu nangandurri mambukarri kurdusyurri. Jayalu wajuba narrinya jurjina. Jayalu karrinjarrijba narrinya walu yalundu mambukamukunyina kabaminkanyi, kuyungangi narri ngaki jangkurr. Ngala jalija yalu kuyu narrinya mambukamukuyngkurri, baki janarri karu yalunya ngaki. Janarri karu yalunya ngakinkanyi jangkurranyi. ");
INSERT INTO wrk_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Ngala waluku barri yingkamukunyi jayalunjalu karu kunybanyi jangkurranyi Kudkanyi. Jayalunjalu karu bukambiju mungkijimuku wandijiyana, baki bayngkani barri janyulu bukamba yaji Kudwanyi. ");
INSERT INTO wrk_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Jalija yalu kuyu narrinya Kurdusyurri, jalija yalu karrinjarrijba narrinya walu nangandu mambukana, baki marda narrimi miku balkijba muwa nanankanyi jangkurranyi jalija narri jananganja nanda malbu. Marda narrimi miku balkijba muwa. Jalija narri karrinja walu nananyina mambukana, baki yingkawanyi janyulu karu narrinya nanankanyi jangkurranyi, narri yanybikanyi. Nanda jangkurr jalija narri yanyba, miku nanda narringi jangkurr, ngala janyulu wajba narrinya nanankanyi jangkurranyi Kunybawanyi Ngarnduwanyi Kudkanyi. Janyulu nyulu karu narrinya jangkurranyi jananganjankanyi nanda mambuka. Nanankardi barri marda narrimi miku balkijba muwa, jalija narri karrinja walu nangandu mambukana. ");
INSERT INTO wrk_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Nanamanji barri kajamukunyi mungkijimukunyi baki ngurranyimukunyi, jala ngananjalu ngirra, jayalu manjijba narrinya. Jayalu manjijba narrinya mambukarri, nyulu kurdanbiji narrinya. Buwakula yingkawanyi manjijbaja yingka nangandurri mambukarri. Nijanganjinyiwanyi manjijbaja jandanyi nangandurri mambukarri, baki jandanyiwanyi manjijbaja nijanganjinyi baki yarrijinyi nangandurri mambukarri, nyulu kurdanbiji yalunya. ");
INSERT INTO wrk_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Kajamukunyi jayalu ngirra narrinya ngaki. Nanamukunyi jala yalu miku kuyu ngaki jangkurr, jayalu ngirra narrinya. Jayalu yabimba kiji narringi. Ngala jaliyi narri yuwajiwa kuyu ngaki jangkurr, jaliyi narringka miku yangkalamba ngakinbunanyi, baki jangayu marrimba narrinya mardarda. Jayalu yabimba kiji narringi yingkamukunyi, ngala jangayu marrimba narrinya mardarda. Jangayu marrimba yalunya mardarda bukambiju, jaliyi yalungka miku yangkalamba ngakinbunanyi. ");
INSERT INTO wrk_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","Yingka wankala, nyuli yanyba jangkurr nangangi Kudkanyi. Karu nyuli yalunya yingkanyi jalija nyulu badajba baku barri juju. Janyulu balkimirra. Janyulu yabimba kaja balki yaji yalungi. Ngayu karungka narrinya, badajbaja nanda balkimirra. Janyulu ngirra Kud. Janyulu karrinja nanaba malabana yajina, baki janyulu balkimba nanda yaji.” Barriwa. Narri jala narri najba nangangi jangkurr najana, marda narrimi jingkijba nangangi jangkurr nanankanyi balkinyi jalija nyulu badajba nanginkurri. “Jalija nyulu badajba, baki nanamuku jalija yalu jungku nananyina walkurranyina yajina Judiya, marda yalimi wirlku nanganbunanyi. Marda yalimi wirlku juju nanganbunanyi kulawirarri yajiyurri. ");
INSERT INTO wrk_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Nanamanji barri jalija nyulu badajba, baki kudiya jayalu jungku danbina jambana. Marda yalimi miku ngankijba barrawuna, wudumbiji yalungi yaji. Ngala marda yalimi yinarramba wirlku kulawirarri. ");
INSERT INTO wrk_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Kudiya jayalu waki munjimunji. Marda yalimi miku wijba barndarri wudumbiji yalungi jumbala. Ngala marda yalimi yinarramba wirlku kulawirarri. ");
INSERT INTO wrk_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Kudiya jibarrimuku, jayalu ngawukuku. Kudiya ngardanganjamuku jayalu ngamulujba bardarda yalungi. Ngala warriyaluku. Miku yaliyi wirlku dulu. Jayalunjalu daba burrandiwa. ");
INSERT INTO wrk_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Marda narrimi yanyba mududu nangangi Kudkanyi. Marda narrimi ngajaka Kud, ‘Mikujiyi munyajba nanda balkimirra badaykurri wurarawala, jala madujba yaji kudanyu barri.’ Nani barri marda narrimi ngajaka Kud. ");
INSERT INTO wrk_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Wabula barri kamambarra yabimbayi yaji Kudwanyi. Nanamunanyi nanginkurri mikuyaji walkurrayngka kijinyi barrinani nayinda kiji, jalija badajba, jalija marda narrimi wirlku kulawirarri. Baki bayngkani barri miku mili walkurra kiji barrinani nayinda kiji. ");
INSERT INTO wrk_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Ngala kurrkunbaja nanda kiji Kudwanyi. Jalimi miku nyulu kurrkunba kiji, baki bukambiju jayalungka janyba nanankanyi kijinyi. Ngala janyulu kurrkunba nanda kiji, marukangangi nyulu muwa nanganginmukuyngka, jali nyulu wabula yarrijba nanganginmirra. Barriwa. ");
INSERT INTO wrk_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Nanamanji barri jalija badajba nanda balkimirra, yingka janyulu yanyba, ‘Najbakiyi nayinda, nyulu Krayis jali manjijba Kudwanyi.’ Ngala yingka janyulu yanyba yingkanyi, nyulu nanda Krayis. Ngala marda narrimi yurlwa yalunginkanyi jangkurranyi. ");
INSERT INTO wrk_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Badajbaja jujambawarrmuku, baki jayalu yanyba jujambawarr jangkurr. Yingka yanybaja, ‘Ngayu Krayis’, ngala yingka yanybaja, ‘Ngayu Krayis’. Yingka yanybaja, ‘Manjijba nganyi Kudwanyi, karunki nangangi jangkurr’, ngala yingka yanybaja ‘Ngala manjijba nganyi Kudwanyi karunki nangangi jangkurr’. Jayalu nulijba jujambikanyi yalunya, jali yarrijba nanganginmirra Kudwanyi. Jayalu yabimba ngiruka yaji jujambiji yalunya ngala miku jayalunjalu jujamba. ");
INSERT INTO wrk_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Ngala marda narrimi najbawa yalunya. Ngayu karungka narrinya nanginkanyi yajinyi waluwa barri, baki jalija yalu badajba nanamuku jujambawarrmuku, baki janarri jingkijba yalunya, baki miku narriyi kuyu yalungi jangkurr. ");
INSERT INTO wrk_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","Nanankardi walkurrananyi kijinanyi barri, baki mikuyaji kambanyi, mikuyaji yakarlanyi. Mikuwali yajba yaji kambawanyi baki yakarlwanyi. ");
INSERT INTO wrk_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Jayalu yirrba warrawiji kingkarrinya. Jayalu karrala wayka. Ngirringirrimba jayalungka kamba, baki yakarl, baki warrawiji. Ngirringirrimba jayalungka, baki jayalu wirlku yingkarri yajiyurri. ");
INSERT INTO wrk_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Baki nanamanji barri ngayu Buwanya Bukambijuyngka, jangayu wijba, baki janganjalu najba lalijina. Janganjalu najba badaykurri ngaluna bukambijunyi. Jangayu walkurra mambuka yalungi. Baki bukambiju wandijiyana jala yalu jungku balki nangangi Kudkanyi, jayalungka ngindu muwa. Kudanyu jayalungka ngindu muwa jalija ngayu wijba. ");
INSERT INTO wrk_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Baki manjijbaja yalunya Yanjilmuku Kudwanyi. Janyulu manjijba nanganginmuku Yanjilmuku langki baki karri, kula baki bayungu, wandijiyana. Baki jayalunjalu wudumba nanganginmirra Kudkanyi, baki kuyuja yalunya nangandurri Kudyurri.” Barriwa. ");
INSERT INTO wrk_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","Mili yanybayi Jisus yalungi, “Mankumanku narringka nanankanyi kabulanyi. Jala narri najba kabula jal, baki narri jingkijbangka barringa barri ngardarawala. Barringa barri ngardarawala, jala walajba kabula jal. ");
INSERT INTO wrk_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Baki nani barri jalija narri najba nayinda walkurra kiji, baki janganarri jingkijba, jangayu wijba jambarri. Janganarri jingkijba, ngayu Buwanya Bukambijuyngka, jangayu wijba jambarri winyurruwa barri. ");
INSERT INTO wrk_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Marda narrimi mankumankuwa nayinda ngaki jangkurr. Ngakinmuku mungkijimuku Jumuku, miku yaliyi bukamba, waluwa badajbaja nayinda walkurra kiji. Kudiyamuku ngakinmuku mungkijimuku jayalu yuwajiwa jungku, jalija badajba nayinda kiji. ");
INSERT INTO wrk_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Baku barri janyulu manjamanjamba laliji baki jamba Kudwanyi. Janyulu manjamanjamba yalunya. Ngala ngaki jangkurr barri, mikuwali manjamanjamba ngaki jangkurr yingkawanyi. Duja ngaki jangkurr jungkuka yurrngumba barri. Barriwa. ");
INSERT INTO wrk_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","Ngala miku ngambalimi jingkijba wanyimbala badajba nanda walkurra kiji. Baki miku ngambalami jingkijba, wanyimbala jangayu wijba. Nanamukunyi Yanjilmukunyi jalili yalu waki nangangi Kudkanyi, miku yalimi jingkijba. Baki ngayu barri Buwanya Bukambijuyngka, miku ngayimi jingkijba. Ngala ngawamba Buwakayu Kingkarri, ngawamba nyulu jingkijbangka wanyimbala badajbaja nanda walkurra kiji. Ngawamba nyulu jingkijbangka wanyimbala jangayu marda wijba. ");
INSERT INTO wrk_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Marda narringkimi lalanbawa. Marda narringkimi najbawa ngaki. Marda narringkimi birrirrinja jilaykanyi ngakindurri. Miku narrimi jingkijba wanyimbala jangayu wijba. Nanankardi barri marda narringkimi birrirrinja yurrngumba jilaykanyi ngakindu.” Barriwa. ");
INSERT INTO wrk_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Mili yanybayi Jisus yalungi, “Jangayu muningka yanyba narringi, narri jingkiykanyi mili yaji. Barlbayi mambuka nanganbunanyi yajinanyi, baki jilalajba nyuli yingkana yajina. Ngala waluku barri, waluwa nyuli barlba, baki yarrijba nyuli kudiyamuku nanganginmiku wakiwarrmuku, yalu lalanbikanyi nangangi yaji ngala nyuli barlba. Yingka nyuli yarrijba lalanbikanyi nanda bardawa barrikina lukuluku nanganginyina barrawuna. Baki nyuli karu nanda lalanbawarr bardawanyi, ‘Najbawakiyi yaji ngaki jalija ngayu wijba. Najbawakiyi yaji ngaki, ninji dulaykanyi nanda bardawa ngaki.’ ");
INSERT INTO wrk_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","37","Baki nanangini lalanbawarranyi bardawanyi, marda nyulimi najbawa nangangi yaji yurrngumba barri. Miku nyuliyi jingkijba wanyimbala janyulu wijba. Yiningki ngabungabu, yiningki mungana, yiningki ngala nyulu kambalingijba yaji, yiningki yalibala. Nanankardi barri marda nyulimi najbawa nangangi yaji yurrngumba barri, bakiyi wijba nanda mambuka ngala nyulu kulukawa. Barriwa. Baki nani barri miku narrimi jingkijba wanyimbala ngayuja wijba, yiningki winyurru, yiningki baku barri. Baki nanankardi barri marda nganarrimi najbawa jalija ngayu wijba.” Barriwa. Nani barri yanybayi Jisus yalungi. ");
INSERT INTO wrk_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Baku barri yingkana munganawa jayalu yabimba nanda wangarr, niji Kangandijbayi Barrawuna Yajinyi, jalili yalu jarrba nanda bulungu nangangi jibkanyi, baki damba ngala nyulu mikuyaji bululunyi. Nanamanji barri jali yingkana mungawawa jayalu yabimba nanda wangarr, baki malumba yali jungka, mambukamuku jurjkanyi baki milidimbawarrmuku yuwanyi. Malumba yali jungku, baki yanyba yalungki yanka jayalu marrimba Jisus, baki jayalu kurdanba Jisus. Miku yaliyanyi nulijba yalungi muramukuyngka jingkiykanyi jalija yalu marrimba Jisus. ");
INSERT INTO wrk_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Yanyba yalungki, “Jangambala marrimba Jisus, baki jangambala kurdanba, ngala miku nanamanji jalija ngambala jungku nanginkanyi wangarranyi. Kajamuku yalu badajbangka nanginkurri nanginkanyi wangarranyi, baki yalungka yanyba nangangi Jisuskanyi, nyulu nanda jali manjijba Kudwanyi. Jayalu manku kiji ngambalangi, jaliyi ngambala marrimba Jisus wangarrina. Jayalu manku walkurra kiji ngambalangi,” Barriwa. Nani yalungki yanyba marrimbikanyi Jisus kardarda barri. ");
INSERT INTO wrk_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Barlbayi Jisus karri nanankurri bayakardarri barrawuyabarrawuyarri niji Bidani, baki ngankijba nyuli barrawuna. Nanda nangangi barrawu Sayiminkanyi. Nanda nganinyi Sayimin, wabula nyulili ngujbulijba waban bukamba, ngala nanijba kunybijbayi barri. Jungkuyi Jisus baki nanganginmuku kandimuku nangandu, baki wardamba yalungki mamanyi. Ngala yalungki wardamba mamanyi, baki ngankijbayi jibarri kalawuyngkurru barrawuna. Kuyu nyuli bujili nangandu marnina. Kalawunyi bujilina nanda yaji barrinani jirrki, ngala nanjananja. Banjawayi kunyba kudu. Niji nanankanyi yajinyi, nard. Nanamanji barri yalili yarrijba nanda yaji kuyuwana Jumukunyi, waluwa yalili makaba mankanyi nangangi jambana. Wajbayi kajanyi dungalanyi jibarriwanyi, baki wudumba nyuli nanda nard. Jilajba nyuli nangandurri Jisusyurri, baki bindabayi nanda yaji nangandu kulajina Jisusnyina. ");
INSERT INTO wrk_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","5","Ngala kudiya nanaba jali yalu najba jibarri bindabankurri nanda nard nangandu kulajina, baki yali ngarrangarra muwa nangangi. Baki yanyba yalungki, “Nayinda jibarri, nyulu balki. Wanyingkanyi nyuli bindaba nanda yaji nangandu kulajina. Jaliyanyi nanda nurrungi, baki nurriyanyi wajba yalunya nanankanyi wudumbiji kaja dungala. Baki nurriyanyi wajba yalunya nanankanyi dungalanyi, yalunya jala mikuyaji yalungi dungalanyi.” Nani barri yali jurlwa nanankanyi jibarrinyi. ");
INSERT INTO wrk_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Ngala yanybayi Jisus yalungi, “Wijbakiyi jurlwa nanankanyi jibarrinyi. Yabimba nyuli kunybamirra yaji ngaki. ");
INSERT INTO wrk_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Jawuda jala yalu mikuyaji yalungi dungalanyi, yurrngumba yalu jungkuka narrindu. Yurrngumba yuku narri lalanba yalunya, jala mikuyaji yalungi dungalanyi. Ngala miku ngayiyi ngayu jungku nayiba narrindu yurrngumba. Miku narriyi jurlwa nangangi. ");
INSERT INTO wrk_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Bindaba nyuli nanda nard ngakinyina mankanyina, baki nanankardi barri birrirrinja ngaka mankanyi makaykanyi nganjalu jambana. ");
INSERT INTO wrk_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Ngayu karungka narrinya jangkurranyi. Baku barri juju jayalunjalu karu ngakinkanyi kunybanyi jangkurranyi. Yurrngumba jayalunjalu karu wandijiyana. Jalija yalunjalu karu ngaki, baki jayalunjalu karu nanginkanyi jibarrinyi marda. Jayalunjalu karu nanginkanyi yajinyi, jali nyulu yabimba ngaki. Baki jayalu marda jingkijba nayinda jibarri, nyulu kunyba marda ngaki.” Barriwa. ");
INSERT INTO wrk_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Yingka kandi nangangi Jisuskanyi, niji Judas Yiskariyud, yangkalamba nangki kurdulu nanganbunanyi Jisusnanyi. Baki jilajba nyuli yalundurri, walkurrayngkurri mambukarri jurjkanyi. Karuyi yalunya Judaswanyi, janyulu kuyu yalunya nangandurri Jisusyurri, yalu marrimbiji Jisus. ");
INSERT INTO wrk_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Mirnarrijba yali muwa nangangi, baki karu yali Judas, jayalu wajba dungalanyi, nyulu kuyunkanyi yalunya nangandurri Jisusyurri. Baki nanankardi barri nanangini Judaswanyi nyuliyanyi kuyu yalunya mambukamuku jurjkanyi nangandurri Jisusyurri, yalu marrimbiji Jisus. Yurrngumba barri nangki mankumanku yanka janyulu kuyu yalunya nangandurri. Barriwa. ");
INSERT INTO wrk_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Jali waluwinyi nanda wangarr yalungi, niji Kangandijbayi Barrawuna Yajinyi, jalili yalu kurdanba nanda bulungu jibkanyi. Jali waluwinyi nanda wangarr, baki jilajba yali kandimuku nangandurri Jisusyurri. Baki yilikajba yali, “Wanjawa yajina janurru yarrijba nayinda yaji kamunyi wangarranyi. Wanjawa yajina janurru yarrijba mama barri.” ");
INSERT INTO wrk_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Yanybayi Jisus kujarrayngka yalungi. Nyuli karu bulanya, “Janimbala jilajba bayungu barrawuyabarrawuyarri Jirusalimyurri. Jalija nimbala wanbiya, baki janimbala najba nganinyi dukanarriykurri wabuda lujulujuna. Janimbala jilajba nangandu wakiwarrina. ");
INSERT INTO wrk_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Janimbala jilajba nangandu barrawurri. Jalija nimbala wanbiya barrawuna, baki janimbala yanyba nangangi mungkijinyi nanankanyi barrawunyi, ‘Nanda milidimbawarr nurrungi, nyulu yanybaka nganyi, nyulu baki nanganginmukunyi kandimukunyi, janurru jarrba nayinda wangarr kamu nganyinyina barrawuna. Nani barri nyulu yanybaka nganyi. Wanjawa yajina jangaliya yarrijba mama. Janinji minimba ngalinya barri.’ Nani barri janimbala yanyba nangangi barri. ");
INSERT INTO wrk_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Baki janimbalanya minimba walkurrayngka yajinyi yundukula barrawuna. Nanda kunyba yaji yabimbikanyi wangarr. Nanaba barri janimbala yarrijba mama kamunyi wangarranyi.” Nani barri yanybayi Jisus bulangi, baki nyuli manjijba bulanya. ");
INSERT INTO wrk_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Barlba buli barrawuyabarrawuyarri, baki yabimba buli nanda yaji jali karu Jisuswanyi. Najba buli nganinyi wabudayudi, baki jilajba buli nangandu mungkijiyurri barrawunyi. Nyuli minimba bulanya yajinyi yundukula barrawuna, baki nanaba buli yundijba bulungu jib kamunyi wangarranyi, niji Kangandijbayi Barrawuna Yajinyi. ");
INSERT INTO wrk_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Ngala nyuli mungimungijba yaji, baki badajba yali karrina, Jisus baki nanganginmuku kandimuku 12 barri. Jilajba yali nanankurri barrawurri, baki jungku yali wangarranyi. ");
INSERT INTO wrk_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Ngala yali jarrba yaji, baki yanybayi Jisus yalungi, “Ngayu karungka narrinya, yingamali narringi jala nyulu jarrbangka mama ngakindu, janangka yangkalamba ngakinbunanyi. Janyulu karu yingkamuku wanjawa janganjalu wudumba. Baki janganjalu marrimba.” ");
INSERT INTO wrk_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Jali manku nanda jangkurr kandimukunyi, baki ngindu yali muwa. Yanyba yali nangangi, yingka baki yingka baki yingka, “Miku kuna ngayu nanda. Miku ngayiyi karu yalunya nganyi.” Nani yalili yanyba nangangi. ");
INSERT INTO wrk_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Jananganjayi yalunya Jisuswanyi, “Yingamali jala jarrbangka mama ngakindu, janangka yangkalamba ngakinbunanyi. Janyulu karu yalunya ngaki. ");
INSERT INTO wrk_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Ngayu Buwanya Bukambijuyngka, jangaka janyba. Nanangini najawanyi Kudkanyi karungka yalunya ngaki, jangaka janyba. Ngala nanda nganinyi jalija yalunya wajba ngaki, janangka ngindu muwa. Janangka ngindu muwa kudanyu barri. Jaliyanyi nangka miku birnandaba, baki yuku janyulu kunyba yaji nangangi.” Barriwa. ");
INSERT INTO wrk_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Ngala yalungki wardamba mamanyi, baki wudumbayi kudiya damba Jisuswanyi. Marrimba nyuli nanda damba, baki yanyba nyuli mududu nangangi Kudkanyi nanankanyi dambanyi. Dalyamba nyuli damba, baki wawajba nyuli yalunya bijalanyi dambanyi. Baki yanyba nyuli yalungi, “Kuyu narri nayinda damba. Janarri jarrba. Nayinda damba barrinani ngaki mankanyi.” Barriwa. ");
INSERT INTO wrk_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Baki nyulu wudumba yukururu jirdi ngarrkinyi krayibkanyi. Yanyba nyuli mududu nangangi Kudkanyi nanankanyi ngarrkinyi, baki wawajba nyuli yalunya ngarrkinyi. Baki ngaraba yali bijal ngarrki bukambijunyi. ");
INSERT INTO wrk_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Baki yanybayi Jisus yalungi, “Nayinda ngarrki barrinani ngaki ngulya. Bukambijunyi yalu barimbaka yaji. Baki marda yalungkimi janyba yalunginkanyi balkinyi yajinyi, jalili yalu yabimba. Ngala jangaka ngaka janyba yalungi. Jalija yalu kuyu ngaki jangkurr, baki jayalu wankijba, janybangangi jangaka yalungi. Nani barri ngaki ngulya barlbangka kajamukuyngka. Nani barri jangayu yabimba yaji, nanankanyingangi jangkurranyi, jali yanyba Kud miku yangkalambikanyi. ");
INSERT INTO wrk_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Ngayu karungka narrinya, miku ngayiyi mili ngaraba ngarrki krayibkanyi nayiba jambana. Ngala baku barri jalija ngayu wankijba mili, jalija ngayu jungku kingkarri nangandu Kudnyina, nanamanji barri jangayu mili ngaraba ngarrki krayibkanyi.” Barriwa. ");
INSERT INTO wrk_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Brijba yali wangarr, baki barriwa yali walajba barndananyi. Barlba yali karrurrinybarri kulawirarri niji Yulib, ngala nyulu mungijba yaji. ");
INSERT INTO wrk_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Ngala yali jilajba, baki yanybayi Jisus yalungi, “Kamu barri ngala nyulu yuwajiwa mungana yajina, baki janarri wirlku ngakinbunanyi. Janganarri yingijba nyubana jungunkurri. Nanda naja Kudkanyi yanybaka nayi barri, ‘Jalija nyulu daba nanda lalanbawarr jibkanyi Kudwanyi, jalija nyulu kurdanba, baki jayalu jarrbalijba jibmuku.’ Nanda jangkurr yanybaka ngaki. Jalija ngananjalu daba, baki janarri wirlku ngakinbunanyi. ");
INSERT INTO wrk_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Ngala baku barri, jalija ngayu mili wankijba, baki jangayu jilajba langki nanankurri yajiyurri Kaliliyurri. Jangayu jilajba langki nanankurri waluwa narringi barri.” Barriwa. ");
INSERT INTO wrk_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Yanybayi Bida nangangi Jisuskanyi, “Jalija nanginmuku yalu wirlku nganyinbunanyi, ngala miku ngayiyi. Miku ninyiyi yingkijba nyubana. Miku.” ");
INSERT INTO wrk_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Ngala yanybayi Jisus nangangi Bidanyi, “Ngayu karungka ninya. Bukambiju janarri wirlku ngakinbunanyi, baki mili yaji janinji yabimba ngaki. Janinji karu yalunya yingkamuku, miku nganinjimi jingkijba. Kujarraka barndayka janinji karu yalunya, miku nganinjimi jingkijba waluwa kayaja kujarraka nanda julaki barrinani dalmurra, waluwa nyulu kayaja kamu ngala nyulu kambalangijba yaji.” ");
INSERT INTO wrk_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Ngala jananganjayi Jisus Bidawanyi, “Miku ngayiyi karu yalunya nani nganyi. Miku. Jaliyi nganjalu kurdanba, baki miku ninyiyi yingkijba nyubana. Miku ngayiyi yanyba yalungi, miku ninyimi jingkijba. Duja ngayu yanyba.” Nani barri nyuli jananganja Jisus. Baki nanamuku yingkamuku kandimuku, yali marda yanyba nanamannga jangkurr nangangi. Barriwa. ");
INSERT INTO wrk_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Mili barri yali jilajba, Jisus baki nanganginmuku kandimuku, baki wanbiya yali nananyina yajina munjimunji, niji Kidsamani. Yanybayi Jisus yalungi, “Janarri jungku nayiba, ngala jangayu jilajba bijal bundu. Jangayu yanyba mududu nangangi Kudkanyi.” Barriwa. ");
INSERT INTO wrk_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Kuyu nyuli murrku nanganginmuku kandimuku nangandu, Bida baki Jayims baki Jun. Jilajba yali bijal bundu nangandu Jisusnyina. Ngala Jisus barri, kudanyu nangki ngindu muwa. ");
INSERT INTO wrk_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Yanyba nyuli yalungi murrkunyi, “Nginduka ngaka muwa. Kudanyu ngaka nginduka muwa. Jungku janarri nayiba, baki najbawa janarri yaji ngaki.” ");
INSERT INTO wrk_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","36","Mili jilajbayi Jisus bijal bundu yalunbunanyi, baki kulujarrijba nangki wayka jambana, wali wayka. Baki yanyba nyuli mududu nangangi Kudkanyi, “Buwakanya. Winyurruwa jayalu jilajba wudumbiji ngana. Nulijba yalu kurdanbikanyi nganjalu. Ngala ngayu jingkijbangka ninya, yuku ninji yabimba bukamba yaji. Janinji kuna wudumba nayi kiji ngakinbunanyi. Janinji kuna wudumba nayi kiji. Ngala jaliyi ninji miku wudumba nayi kiji ngakinbunanyi, baki yuku barri. Jangayu yabimba nanda jala ninji nulijba ngaki yabimbikanyi yaji.” Nani barri yanybayi Jisus mududu, baki barriwa. ");
INSERT INTO wrk_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Wijbayi Jisus yalundurri murrkuyngkurri, baki najbayi yalunya kulukankurri. Dulabayi yalunya Jisuswanyi, baki yanyba nyuli nangangi Bidanyi, “Wanyingkanyi narri kuluka, jali narrinya ngajaka najbawakanyi yaji ngakindu. Wanyingkanyi narri miku najbawa yaji ngakindu. ");
INSERT INTO wrk_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Najbawa janarri ngakindu, baki yanyba janarri mududu nangangi Kudkanyi. Marda narrimi ngajaka Kud, nyulu yabimbiji narrinya ngiruka nangangi barri. Nulijba narri najbawankanyi yaji ngakindu, ngala narri ngunjarra, baki narri kuluka. Nulijba narri yabimbikanyi kunyba yaji, ngala miku narrimi ngiruka yabimbikanyi kunyba yaji. Ngala Sayidin nyulu ngiruka. Nyulu nulijbangka jujambikanyi narrinya, narri yabimbikanyi balki yaji. Nanankardi barri marda narrimi ngajaka Kud, nyulu yabimbiji narrinya ngiruka nangangi barri.” Barriwa. ");
INSERT INTO wrk_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Mili barri jilajbayi Jisus bijal bundu yalunbunanyi. Baki mili nyuli yanyba mududu nangangi Kudkanyi. Yanyba nyuli nanamannga jangkurr jali nyulu yanyba barrin. Nani barri mili yanybayi Jisus mududu, baki barriwa barri. ");
INSERT INTO wrk_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Mili nyuli wijba yalundurri, baki najbayi yalunya kulukankurri. Miku yalungkiyanyi kurrkunba kulukankanyi. Mili dulabayi yalunya Jisuswanyi, baki manyirru yali. Miku yaliyanyi jingkijba wanyi jangkurr yanybikanyi nangangi Jisuskanyi. ");
INSERT INTO wrk_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Baki mili barri nyuli barlba bijal bundu yalunbunanyi. Mili barri yanybayi Jisus mududu, baki barriwa barri. Baki mili nyuli wijba yalundurri. Yanyba nyuli yalungi, “Yuwajiwa kuna narri kululuka. Walajba narri. Nanijba barri nanamuku balkimuku, yalu badajbangka wudumbiji ngana, marrimbiji ngana Buwanya Bukambijuyngka. ");
INSERT INTO wrk_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Janarri walajba. Jangambala jilajba. Nayinda nyulu badajbangka, nanda jali nangka yangkalamba ngakinbunanyi. Nyulu kuyungka yalunya ngakindurri, yalu marrimbiji ngana.” Barriwa. Walajba yali ngala nyuli yanyba yalungi. ");
INSERT INTO wrk_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Ngala yuwajiwa yanybayi Jisus yalungi, baki wanbiyayi nanda yingka kandi Judas, baki kajamuku yalu nanaba nangandu. Yingkamukunyi yali kuyu wunanybala jankunbijinyi, baki yingkamukunyi yali kuyu kuduru. Manjijbayi yalunya mambukamukunyi jurjkanyi baki milidimbawarrmukunyi yuwanyi, baki malbumalbuwanyi, yalu marrimbiji Jisus. ");
INSERT INTO wrk_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Waluwa yanybayi nanda balki kandi Judas yalungi, “Nanda jalija ngayu jawunja, nyulu nanda jala narri kujba nangangi. Nanda barri janarri marrimba, janarri kuyu.” Nani barri nyuli yanyba yalungi waluwa barri. ");
INSERT INTO wrk_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Wanbiya yali, baki yinarramba jilajbayi Judas nangandurri Jisusyurri, yanybayi nangangi, “Nanama ninji Milidimbawarr”, baki jawunja nyuli Jisus. ");
INSERT INTO wrk_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Bunundujba yali nangandurri, baki marrimba yali Jisus. ");
INSERT INTO wrk_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Ngala kandi nangangi Jisuskanyi, nyuli karrinja nanaba jankunbijinyiyudi wunanybalanjudi. Dulaba nyuli kingkarri nangangi jankunbijinyi, baki jinamba nangki. Karlba nyuli nangangi kuwarda jankunbijiyudinyi. Barriwa barri bukamba karlba nyuli kuwarda, nanda jalili waki nangangi mambukanyi jurjkanyi. ");
INSERT INTO wrk_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Yanybayi Jisus yalungi nanamukuyngka lukuluku, “Wanyingkanyi narri jilajba wudumbiji ngana jankunbijinyiyudi baki kuduruyudi, barrinani narri jilajba wudumbiji nanda maninjaku, jalija daba narrinya. ");
INSERT INTO wrk_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Yingkana kambana, baki yingkana kambana ngayi milidimba yalunya walkurranyina jurjina narrindu, ngala miku nganarriyanyi marrimba nanaba. Wanyingkanyi nanijba barri narri jilajba nanginjudinyi marrimbiji ngana. Nanamuku wankalamuku jali yalu yanyba jangkurr nangangi Kudkanyi, yali yarrijba nanda jangkurr najana Kudkanyi. Nanda naja yanybaka ngaki, janganjalu marrimba, janganjalu linjumba. Duja yalungi jangkurr. Narri yabimbaka nanda yaji ngaki.” ");
INSERT INTO wrk_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Bukambiju kandimuku nangangi, wirlku yali. Wirlku yali nangandunanyi, marralangangi yali kudanyu barri. Barriwa. ");
INSERT INTO wrk_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Ngala yingka kaburr, nyuli jilajba bayngkani nangandu Jisusnyina. Ngawamba yingamali jumbala lukuluku nangandu mankanyina, barrinani danyan. Marrimbayi kaburr yingkawanyi. ");
INSERT INTO wrk_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","Ngala ngawamba nyuli marrimba nangangi jumbala. Jali wirlku nanda kaburr, baki dalijbayi nangangi jumbala. Yingijba nyuli jumbala wambu yingkana marnina, baki wirlku nyuli mikuyaji jumbalanyi. Barriwa. ");
INSERT INTO wrk_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Kuyu yali Jisus barrawurri. Nanda nangangi barrawu, walkurrayngka mambukanyi jurjkanyi. Nanaba barri jungkuyi mambukamuku jurjkanyi, baki milidimbawarrmuku yuwanyi, baki malbumalbumuku. Malumba yali jungku nananyina barrawuna, baki yukumba yali nangangi Jisuskanyi. Kuyu yali Jisus yalundurri. ");
INSERT INTO wrk_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Ngala durrijbayi yalunya Bidawanyi. Durrijba nyuli juju bijal bayngkani, baki ngankijba nyuli barrikina jali lukuluku nananyina barrawuna. Jungku nyuli yalundu yilarrmukunyina. Ngarrijba nyuli janguna. Barriwa. ");
INSERT INTO wrk_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","56","Nanamuku walkurramuku mambukamuku jurjkanyi, baki nanamuku kunsilmuku, nulijba yali kurdanbikanyi Jisus. Kujba yali yingkamukuyngka, yalu karunkanyi jujambawarrayngka jangkurranyi nangangi Jisuskanyi, nanankanyi jali nyulu yabimba. Jala yingkamuku yalu yanyba jujambawarr jangkurr nangangi, baki nanamuku mambukamuku baki kunsilmuku, jayalu yanyba kurdanbikanyi Jisus. Nanankardi barri yali kujba yalungi, jalija yalu yanyba jujambawarr jangkurr nangangi Jisuskanyi. Kajamuku yali yanyba yinini yinini jujambawarr jangkurr nangangi. Miku yaliyanyi yanyba nanamannga jangkurr nangangi. ");
INSERT INTO wrk_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Kudiya yalungki karrinjarrijba, baki yanyba yali nayi jujambawarr jangkurr, ");
INSERT INTO wrk_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“Manku nurri nayinda nganinyi yanybikurri nayi barri, ‘Jangayu dalyamba nayinda walkurra jurj. Jangayu dalyamba nayinda jurj jali yalu yabimba yingkamukunyi. Ngala baku barri kujarraka barndayka, jangayu mili yabimba yingka jurj. Ngayu barri ngiruka yabimbikanyi ngiruka yaji. Jangayu ngayuman yabimba nanda yingka jurj kujarraka barndayka.’ Nani barri nurri manku Jisus yanybikurri.” ");
INSERT INTO wrk_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Ngala miku yaliyanyi yanyba nanamannga jangkurr. Yinini yinini jangkurr yali yanyba nangangi. ");
INSERT INTO wrk_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Karrinjayi nanda walkurra mambuka jurjkanyi burrandi yalundu, baki ngajaka nyuli Jisus, “Ninji mankuyi yalungi jangkurr, ngala wanyingkanyi ninji miku jananganja yalunya nanankanyi jangkurranyi, jali yalu yanyba. Wanyingkanyi barri.” ");
INSERT INTO wrk_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Ngala miku nyuliyanyi jananganja nanda mambuka Jisuswanyi. Karda nyuli jungku. Baki mili ngajakayi Jisus walkurranyi mambukawanyi jurjkanyi, “Ninji kuna nanda Krayis, jali manjijba Kudwanyi. Ninji kuna jandanyi nangangi Kudkanyi. Karukiyi nurrunya duja jangkurranyi.” ");
INSERT INTO wrk_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Baki jananganjayi walkurra mambuka Jisuswanyi, “Yi. Ngayu Krayis. Ngala ngayu karungka narrinya, janganarri najba Buwanya Bukambijuyngka. Janganarri najba jungunkurri kingkarri nangandu Kudnyina, baki badaykurri kingkarrinya lalijinanyi ngaluna. Nani barri janganarri najba.” Barriwa. ");
INSERT INTO wrk_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Jali manku nanda jangkurr mambukawanyi jurjkanyi, baki bakaramba nyuli nangangi jumbala. Nani barri yalili bakaramba yalungi jumbala Jumukunyi, jalili yingka yanyba balki jangkurr nangangi Kudkanyi. Bakaramba nyuli nangangi jumbala, baki yanyba nyuli, “Mikujiyi kuyu mili karunkanyi ngambalanya nanganginkanyi balkinyi yajinyi. ");
INSERT INTO wrk_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Ngambala mankuyi nangangi jangkurr. Jujambawarr jangkurr nyuli yanyba ngambalangi nangangi Kudkanyi. Jujambawarr jangkurr. Wanyimba ngambalaja nangangi Jisuskanyi. Wanyimba.” Baki bukambiju yali yanyba, “Marda nangkimi janyba, yanybangangi nyuli balkimirra jangkurr nangangi Kudkanyi.” Nani barri yali yanyba. ");
INSERT INTO wrk_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Baki yali kiwumba wali Jisus yingkamukunyi, ngala yingkamukunyi yali makaba Jisus yami, baki daba yali Jisus marniyudinyi. Ngala ngajaka yali Jisus, “Wanjangini ninya daba. Marda ninjimi jingkijba nanda jali ninya daba. Wanjangini ninya daba. Karukiyi nurrunya.” Kuyu yali Jisus yilarrmukunyi, baki yali marda daba Jisus muwana marnina. Barriwa. ");
INSERT INTO wrk_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Jungkuyi Bida barrikina muwana lukuluku nananyina barrawuna. Jilajbayi nangandurri jibarri jalili waki nangangi mambukanyi jurjkanyi. ");
INSERT INTO wrk_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Najba nyuli Bida ngarambikurri nangka janguna. Ningkijbayi Bida jibarriwanyi, baki yanyba nyuli nangangi, “Ninya jingkijbangka, jungku ninji barri nangandu Jisusnyina, nangangi yaji Nasarid. Ninji marda jungkuka nangandu.” Barriwa. ");
INSERT INTO wrk_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Ngala jujambayi nanda jibarri Bidawanyi. Yanyba nyuli, “Miku barri. Miku ngayimi jingkijba nanda nganinyi. Miku.” Nani barri yanybayi Bida nangangi. Walajbayi Bida, baki barlba nyuli bardawarri. ");
INSERT INTO wrk_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Mili najbayi Bida nanangini jibarriwanyi, baki yanyba nyuli yalungi jali yalu karrinja nanaba, “Nayinda nganinyi, nyulu kandi nangangi Jisuskanyi.” Barriwa. ");
INSERT INTO wrk_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Mili barri jujambayi Bidawanyi, “Miku ngayimi nangangi kandi. Miku.” Barriwa. Kamu barri yalu jali karrinja nanaba nangandu, yanyba yali nangangi Bidanyi, “Yi. Ninji barri kandi nangangi Jisuskanyi. Ninji nangangi mungkiji. Nganyi yaji Kalili marda. Nimbala mungkijiwuya. Yingamali nimbalangi yaji.” Barriwa. ");
INSERT INTO wrk_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Baki jananganjayi yalunya Bidawanyi. Jujamba nyuli yalunya. Yanyba nyuli balki jangkurr yalungi, “Ngayu karungka narrinya duja jangkurranyi. Ngayu ngajakangka Kud, nyulu dabanki ngana jaliyi miku duja nanda jangkurr. Miku ngayimi jingkijba nanda nganinyi. Miku.” Nani barri jananganjayi yalunya Bidawanyi. ");
INSERT INTO wrk_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Baki yinarramba kayayi nanda julaki barrinani dalmurra. Kaya nyuli barri. Baki mankuwayi Bidawanyi nanda jangkurr jali yanyba Jisus nangangi barrin, “Kujarraka barndayka janinji karu yalunya, miku nganinjimi jingkijba, waluwa kayaja kujarraka nanda julaki barrinani dalmurra.” Mankuwayi nanda jangkurr Bidawanyi, baki ngindu nangki muwa kudanyu barri. Kudanyu nangki ngindu muwa mirlarryudi. Barriwa. ");
INSERT INTO wrk_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Ngala nyulu kambalingijba yaji, baki yanyba yalungki, walkurramuku mambukamuku jurjkanyi, baki malbumalbumuku, baki milidimbawarrmuku yuwanyi, baki kunsilmuku. Yanyba yalungki nangangi Jisuskanyi. Barriwa. Kijijba yali Jisus jaluwuya, baki kuyu yali Jisus nangandurri Biladyurri, nyulu yanybiji kurdanbikanyi Jisus. Nanda Bilad nyuli walkurra mambuka kabaminkanyi nananyina yajina. Wajba yali Bilad nangangi Jisuskanyi. ");
INSERT INTO wrk_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Ngajakayi Jisus Biladwanyi, “Ninji barri kuna walkurra mambuka yalungi Jumukuyngka.” Jananganjayi Bilad Jisuswanyi, “Yi. Ngayu nanda.” ");
INSERT INTO wrk_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Baki yali jujamba Bilad nangangi Jisuskanyi, nanamukunyi mambukamukunyi jurjkanyi. Yanyba yali balki jangkurr nangangi Jisuskanyi. Jujamba yali Bilad nanankanyi jali yabimba Jisuswanyi. ");
INSERT INTO wrk_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Yanybayi Bilad nangangi Jisuskanyi, “Manku kuna ninji yalungi jangkurr. Wanyingkanyi ninji karda jungku. Yalu yanybaka kajanyi nganyingkanyi balkinyi jangkurranyi. Ngala miku kuna ninjiyi jananganja yalunya.” Barriwa. ");
INSERT INTO wrk_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Ngala mili miku nyuliyanyi yanyba Jisus nangangi Biladkanyi. Miku nyuliyanyi jananganja nanda kubamin mambuka. Baki manmalayi Bilad. Manmala nyuli jali mikukiyanyi jananganja Jisuswanyi. ");
INSERT INTO wrk_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Yurrngumba barri yingkana kindilkurrinyina, baki yingkana kindilkurrinyna, ngala nyuli Kangandijbayi Barrawuna Yajinyi, baki nanangini Kubaminwanyi mambukawanyi, nyulili muningka manjijba yingamali nganinyi jalili jungku brisinyina. Nyulili muningka manjijba yingamali nanganginkurri barndarri. Yalili karu nanda mambuka nanankanyi jalija nyulu manjijba. Yalili nijarrijba nangangi niji, bakili nyulu muningka manjijba nanda jalili yalu nijarrijba. ");
INSERT INTO wrk_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Nanamanji barri jungkuyi nganinyi brisinyina, nangangi niji Barabas. Waluwa barri nyulu baki yingkamukunyi yali manku kiji yalungi Kubaminkanyi. Yalunjali daba, baki kurdanbayi yingka nanangini Barabaswanyi. Nanankardi barri yali marrimba nanda Barabas yilarrmukunyi, baki yarrijba yali brisinyina. ");
INSERT INTO wrk_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Badajbayi walkurra muramuku barrawurri Biladkanyi. Karrinja yali nanaba danbina, baki yililikajba yali Bilad, nyulu muningka manjiykanyi yingamali brisinanyi. ");
INSERT INTO wrk_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Ngajakayi yalunya Biladwanyi, “Nayimanji barri ngayili muningka manjijba yingamali nganinyi brisinanyi. Ngala wanyi jangayu manjijba nanijba barri. Jangayu kuna manjijba narringi mambuka Jumukuyngka. Jangayu kuna manjijba nayinda Jisus.” ");
INSERT INTO wrk_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Jingkijba nyuli yalunya mamabukamuku jurjkanyi Biladwanyi. Nyuli jingkijba yalunya, yali kuyu Jisus nangandurri, ngurungurujbangangi yali nangangi Jisuskanyi. ");
INSERT INTO wrk_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Yanybayi yalungi muramukuyngka nanamuku mambukamuku jurjkanyi baki malbumalbumuku. Karu yalunjali, yalimi ngajaka Bilad, janyulu muningka manjijba brisinanyi nanda nganinyi Barabas, ngala janyulu manjijba Jisus janybikanyi nangka. Nani barri yali yanyba kudanyu yalungi muramukuyngka. Baki nanankardi barri yali ngajaka Bilad muramukunyi. Yali ngajaka Bilad, nyulu muningka manjiykanyi Barabas. ");
INSERT INTO wrk_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Ngajakayi yalunya muramuku Biladwanyi. Nyuli ngajaka yalunya, “Jaliyi ngayu manjijba Barabas, baki wanyimba jangayu nangangi, narringinkanyi mambukanyi Jumukuyngka. Wanyimba jangayu nangangi Jisuskanyi.” ");
INSERT INTO wrk_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Kaya yali kudanyu nangangi, “Kurdanbakiyi. Kurdanba. Langandabakiyi kingkarri kurndana.” ");
INSERT INTO wrk_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Ngajakayi yalunya Biladwanyi, “Wanyingkanyi barri marda ngayimi kurdanba. Miku nyuliyanyi yabimba balki yaji. Nyulu jungkuka kunybana yuwana. Wanyingkanyi marda ngayimi kurdanba.” Ngala mili yali kaya nangangi, “Kurdanbakiyi. Langandabakiyi kingkarri kurndana. Kurdanbakiyi.” Nani barri yali kudanyu kaya nangangi. ");
INSERT INTO wrk_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Nulijbayi Bilad yabimbikanyi kunyba yaji yalungi muramukuyngka, baki muningka nyuli manjijba Barabas brisinanyi, ngala nyuli jirrinyba nanganginmuku ngarrkadabawarrmuku, yalu wajuji Jisus, yalu kurdanbiji Jisus, barrinani kudanyu ngajakayi Bilad Jumukunyi. Baki wajuba yali Jisus nanaba barri. ");
INSERT INTO wrk_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Baki nanamukunyi ngarrkadabawarrmukunyi Biladkanyi, yali kuyu Jisus kalawuyngkurru nanganginyina barrawuna. Baki yali kaya yalungi yingkamukuyngka ngarrkadabawarrmukuyngka, baki bukambiju yali karrinja lukuluku nangandu Jisusnyina, baki yali ngirrikimba Jisus. ");
INSERT INTO wrk_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Dulaba yali nangangi jumbala nanganbunanyi, baki yarrijba yali danyan nangandu mankanyina. Nganmarra nanda danyan, wunanybala wayka darnyiyurruwa. Wudumba yali wardankurrul kurnda nyilanyilayudi, baki kijijba yali bakiri. Yarrijba yali nanda bakiri lukuluku nangandu kulajina Jisusnyina. Nani barri jungkuyi walkurra mambuka nanamanji barri, jirdi bakirinyi, jirdi nganmarranyi danyanyi. ");
INSERT INTO wrk_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Baki muningka yali kaya nangangi, “Ninji barri, ninji walkurra mambuka yalungi Jumukuyngka. Ninji barri wirimalaru yalungi.” Nani barri yali muningka kaya nangangi, baki ngirrikimba yali Jisus. ");
INSERT INTO wrk_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Daba yali Jisus kulaji ridiridiyudinyi, baki kiwumba yali nangandurri. Mururu yali wayka walu nangandu. ");
INSERT INTO wrk_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Nani barri yali ngirrikimba Jisus ngarrkadabawarrmukunyi. Barriwa. Baki dulaba yali nanda nganmarra danyan nanganbunanyi mankanyinanyi, baki mili yawumba nangki Jisus nanganginkanyi jumbalanyi. Baki kuyu yali Jisus bayungu kulawirarri langandaji. ");
INSERT INTO wrk_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Ngala yali jilajba bayungu, baki yingka nganinyi, niji Sayimin, nyuli jilajba bayunguna. Nangangi yaji juju bayungu, yaji niji Sayirin. Jandanyiwuya nangangi bulangi niji Yalisandra baki Rubas. Nyulu jilajbayi bayunguna nananyina yubalina. Baki nanamukunyi ngakadabawarrmukunyi, yali jirrinyba nanda nganinyi, nyulu kuyunkanyi nanda wabangkarra kurnda nangangi Jisuskanyi. Baki dukanarrijba nyuli kurnda bayangarriji. ");
INSERT INTO wrk_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Mili yali jilajba bayungu, baki wanbiya yali nananyina yaji niji Kulkuda. Nanda niji Kulkuda, nanda Ju yanyi, barrinani Kulaji Nguli. ");
INSERT INTO wrk_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Jidimba yali malumba jirrki baki ngarrki krayibkanyi. Yarrijba yali jawuda yukururuna, baki wajba yali Jisus. Ngala miku nyuliyanyi ngaraba. ");
INSERT INTO wrk_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Baki yali langandaba Jisus wabangkarra kurndana ngarrkadabawarrmukunyi. Ngarrkadaba yali Jisus marni nyilanyilayudinyi. Dulaba yali nangangi jumbala, baki baja yali barrinani kard wudumbikanyi nangangi jumbala. Baki kuyu yali nanda yalungi jumbala. ");
INSERT INTO wrk_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Langandaba yali Jisus nyilanyilayudinyi ngala nyuli yalibala. ");
INSERT INTO wrk_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Yarrijba yali jangkurr najana. Nanangini jangkurrwanyi karuyi yalunya nanankanyi balkinyi yajinyi, jali yalu yanyba yabimbayi Jisuswanyi. Yarrijba yali jangkurr najana, baki langandaba yali nanda naja kingkarri kurndana Jisusnyina. Nayi nanda jangkurr najana, “Nayinda nyulu walkurramirra mambuka yalungi Jumukuyngka.” Barriwa. ");
INSERT INTO wrk_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Baki langandaba yali yingkawuya nangandu Jisusnyina maninjakuwuya. Yingka langayi wabangkarra kurndana karriya, ngala yingka langayi wabangkarra kurndana bayinga, ngala nyulu Jisus burrandi bulandu. ");
INSERT INTO wrk_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Kajamuku yali jilajba kangandijba yalundu, baki ngirringirrimba yalungki kulaji. Nani barri yalungkili ngirringirrimba kulaji, jalili yalu bajalingijba yingka. Ngirrikimba yali Jisus. Yanyba yali balki jangkurr nangangi, “Yanybayi ninji, yuku janinji dalyamba nanda walkurra jurj, ngala baku barri kujarraka barndayka, yuku janinji yabimba yingka mili jurj. ");
INSERT INTO wrk_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Jaliyi yuku ninji yabimba yaji nani, baki lalanba nganyingkiyi. Karralakiyi wayka kurndananyi.” Nani barri yali yanyba balki jangkurr nangangi. ");
INSERT INTO wrk_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Baki mambukamuku jurjkanyi, baki milidimbawarrmuku yuwanyi, yali marda yanyba balki jangkurr nangangi, “Nyuli yalunya marrimba mardarda Jisuswanyi, ngala miku nangkiyi marrimba mardarda. Miku. ");
INSERT INTO wrk_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Yanyba nangki, nyulu nanda Krayis jali manjijba Kudwanyi, nyulu walkurra mambuka nurrungi Jumukuyngka. Jaliyi nyulu karrala wayka kurndananyi, baki yuku janurru kuyu nangangi jangkurr. Janurru kuyu nangangi jangkurr, jaliyi nyulu karrala wayka kurndananyi.” Nani barri yali yanyba balki jangkurr nangangi. Baki nanankuya maninjakuwuya, jali bula langa nangandu, bula marda yanybayi balki jangkurr nangangi. Bula marda yanybayi nanamannga jangkurr nangangi. Barriwa. ");
INSERT INTO wrk_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Ngala nyulu mukunjana barri, baki mungijbayi yaji bukamba. Mikuyaji ngardaranyi. Yuwajiwa mungijbayi yaji, baki mili walajbayi nanda ngardara ngabungabu bijal. ");
INSERT INTO wrk_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Ngala nyuli yuwajiwa mungijba yaji, baki kayayi Jisus kudanyu barri. Kudanyu nyuli kaya Ju yanyi, “Yiluyi. Yiluyi. Lama sabakdani.” Barrinani “Ngaki Kud. Ngaki Kud. Wanyingkanyi nganinji yingijba.” Nani barri kayayi Jisus. Barriwa. ");
INSERT INTO wrk_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Jawuda jali yalu karrinja bundu nangandu, jali manku Jisus kayankurri, baki yanyba yali, “Mankukiyi. Nyulu kayangka nangangi Yalayijakanyi.” ");
INSERT INTO wrk_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Yarungul nanaba jirdi ngarrkinyi krayibkanyi ngujbulanyi. Yingkawanyi nyuli kijijba karnjal wadiwadina. Yarrijba nyuli karnjal ngarrkina, baki manjijba nyuli kingkarri nangandurri Jisusyurri janyiyurri, nyulu ngaraykanyi. Baki yanyba nyuli, “Jangambala yukumba nayiba. Jangambala lalanba yaji, jaliyi nyulu badajba Yalayija nanginkurri, jaliyi nyulu marrimba Jisus mardarda, jaliyi nyulu waykalumba Jisus kurndananyi. Barriwa.” ");
INSERT INTO wrk_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Baki mili kayayi Jisus kudanyu barri, baki barriwa barri nangki janyba Jisus. Barriwa. ");
INSERT INTO wrk_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Kalawuyngkurru nananyina walkurranyina jurjina langayi walkurra blanki. Langayi nanda walkurra blanki kingkarrinya wayka jambarri. Nanamanji barri jali nangka janyba Jisus, baki bakarrawijbayi nanda blanki Kudwanyi. Bakarrawijba nyuli kingkarrinya wayka bukamba barri. Barriwa. ");
INSERT INTO wrk_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Nanda mambuka yalungi ngarrkadabawarrayngka jali yalu lalanba Jisus, nyuli karrinja nanaba walu nangandu Jisusnyina. Najba nyuli Jisus janybikurri nangka, baki yanyba nyuli, “Nayinda Jisus, dujanya nyuli jandanyi nangangi Kudkanyi. Dujanya nyuli nangangi jandanyi.” ");
INSERT INTO wrk_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","41","Jali langa Jisus kurndana, jali nangka janyba, baki karrinjayi jawuda jibarrimuku juju bijal nangandu. Yali nanamuku jibarrimuku jalili yalu jilalajba nangandu Jisusnyina, nananyina yajina Kalili, jalili yalu lalanba Jisus. Baki yali badajba langina nangandu nanankurri Jirusalimyurri. Jawuda yalungi, yingka jibarri nangangi niji Mari Makdalin, yingka nangangi niji Mari, nyuli ngardanganja bulangi Jayimskanyi baki Jusibkanyi. Baki yingka nangangi niji Salumi. ");
INSERT INTO wrk_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","43","Munganawa barri Sadidi, jalili yalu miku waki Jumuku. Miku yalili yundijba mama Sadidi Jumukunyi. Ngala yalili yundijba waluwa barri. Yingka nganinyi, nangangi niji Jusib, nangangi yaji Yarimadiya. Nanda Jusib, nyulu walkurra nganinyi, jali nyulu jungku yalundu kunsilina walkurrayngka jurjkanyi. Mankumanku yalungki kunymamba nangangi. Nulijba nyuli nangangi Kudkanyi, nyulu lalanbikanyi. Ngala nyulu ngabungabu, baki jilajbayi Jusib yurlurrmba nangandurri Biladyurri, baki ngajaka nyuli Bilad, “Jangayu kuna kuyu nanda Jisus mankanyi makaykanyi. Yuku kuna jangayu kuyu nangangi mankanyi.” ");
INSERT INTO wrk_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Manmalayi Bilad. Mankumanku nangki, dulu nangki janyba Jisus. Kaya nyuli nangangi, mambukanyi yalungi ngarrkadabawarrayngka, baki ngajaka nyuli nanda mambuka, jaliyi nangki janyba Jisus. ");
INSERT INTO wrk_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Karuyi Bilad mambukawanyi, “Yi, nangki janyba.” Baki karuyi Jusib Biladwanyi, yuku janyulu dulaba Jisus mankanyi makaykanyi. ");
INSERT INTO wrk_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Wudumbayi walkurra raki barrinani blanki Jusibwanyi. Wudumba nyuli nanda walkurra raki, baki wijba nyuli nanankurri yajiyurri jali langa Jisus mankanyi. Dulaba nyuli Jisus mankanyi, baki kijijba nyuli mankanyi lukuluku bukamba nukamiyurru rakiyudinyi. Baki yarrijba nyuli mankanyi kumayanguna, jali kurrijba nanda lawarr wujina dungalana yingkawanyi. Yarrijba nyuli Jisus mankanyi kumayanguna, baki murumba nyuli bardawa nangangi dungalayudinyi. Karranunumba nyuli walkurra dungala murumbiji bardawa. ");
INSERT INTO wrk_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Nanda jibarri Mari Makdalin, baki nanda yingka jibarri niji Mari, jali nyulu ngardanganja nangangi Jusibkanyi, jungku buli nanaba. Najba buli Jusib yarriykurri mankanyi kumayanguna. Barriwa. ");
INSERT INTO wrk_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Munganawa barri Sadidi, baki jali yalu wuyalijba. Ngala mungana barri wudumba yali jirrki jibarrimukunyi. Wudumba yali nanjananja jirrki jali kunyba kudu. Jayalu yarrijba mankanyina Jisusnyina. Murrku yali jibarrimuku, yingka nyuli Mari Makdalin, yingka nyuli nanda Mari jali nyulu ngardanganja nangangi Jayimskanyi, baki yingka nyuli Salumi. ");
INSERT INTO wrk_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Yingkana mungana Sundi, ngala nyuli kambalingijba yaji, baki jilajba yali jibarrimuku kumayangurri. ");
INSERT INTO wrk_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","4","Ngala yali jilajba, baki ngajaka yalungki, “Wanyingini janyulu jululumba dungala bardawananyi, baki jangambala ngankijba kalawuyngkurru kumayanguna. Wanyingini janyulu jululumba dungala ngambalangi.” Nani barri yalungki ngajaka, walkurrangangi nanda dungala bardawana. Wanbiya yali kumayanguna, baki najba yali nanda dungala jungunkurri wilina bardawana. ");
INSERT INTO wrk_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Ngankijba yali kumayanguna, baki najba yali nganinyi jungunkurri kalawuyngkurru wilina muwana. Nangangi jumbala nyuli buludamirra. Najbayi nganinyi jibarrimukunyi, baki marrala yali yajinyi. ");
INSERT INTO wrk_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Yanyba nyuli yalungi, “Miku narriyi marrala ngaki. Ngayu jingkijbangka narrinya, narri kujbangka nangangi Jisuskanyi, nangangi yaji Nasarid, jali yalu langandaba kurndana. Miku nyulimi nayiba. Mili nyuli walajba. Najba janarri danbal jali kululuka nangangi mankanyi nanaba. Miku nyulimi nayiba. Walajbayi mili. ");
INSERT INTO wrk_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Ngala wijba janarri karri Jirusalimyurri, Wijba janarri yalundurri kandimukuyngkurri Jisuskanyi. Baki janarri yanyba nayinda jangkurr yalungi, baki nangangi Bidanyi. Nyulu jilajbangka langki Kaliliyurri waluwa yalundu. Nyulu jilajbangka langki nanankurri, baki nanaba jayalu najba Jisus, barrinani nyuli karu yalunya wabula. Jayalu najba Jisus nanaba barri.” Barriwa. ");
INSERT INTO wrk_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Walajba yali jibarrimuku kumayangunanyi, baki wirlku yali karri. Wirlku yali, marralangangi yali yajinyi. Birrirri yali mankanyi. Miku yaliyanyi karu yingkamuku nanankanyi yajinyi. Barriwa. ");
INSERT INTO wrk_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Walajbayi Jisus kumayangunanyi Sundi barri, ngala nyuli barringa barri kambalangiykanyi yaji. Baki minimba nangki Jisus waluku nangangi Mari Makdalinkanyi. Nyuli najba Jisus waluwa yingkamukuyngka. Nanda Mari Makdalin, nyuli nanda jibarri jali waluwa jakajba kaja wuwarr 7-barri nanganbunanyi mankanyinanyi Jisuswanyi. Najba nyuli Jisus waluku barri. ");
INSERT INTO wrk_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","11","Baki jilajbayi Jisus yalundurri nanganginmukuyngkurri kandimukuyngkurri. Malumba yali jungku, baki ngindu yali muwa kudanyu barri nangangi Jisuskanyi. Karuyi yalunya Mariwanyi, nyuli najba Jisus mili wankiykurri. Jali yalu manku nangangi jangkurr, baki miku yaliyanyi kuyu nanda jangkurr. Ngamu jujambayi yalunya Mariwanyi. Miku yaliyanyi kuyu nangangi jangkurr. Barriwa. ");
INSERT INTO wrk_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Kamu barri najba buli Jisus yingkawuyanyi. Ngala buli jilajba bayungu yubalina Jirusalimnanyi, baki kabujurru bulanya Jisuswanyi. Waluku barri yakanajba buli Jisus, ngala kamu buli jingkijba. ");
INSERT INTO wrk_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Wijba buli karri Jirusalimyurri, baki bula marda karuyi yalunya kandimuku nangangi Jisuskanyi, mili wankijbayi. Ngala miku yaliyanyi kuyu bulangi jangkurr marda. Barriwa. ");
INSERT INTO wrk_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Kamu barri jali yalu jarrba yaji kandimukunyi 11 barri, baki minimba nangki Jisus yalundurri. Ngirrwa nyuli yalungi, mikungangi yaliyanyi kuyu yalungi jangkurr jali yalu najba Jisus mili wankijbayi. Yali jardibirri kurdulu. Miku yaliyanyi kuyu nanda jangkurr yalungi nangangi Jisuskanyi mili wankijbayi. ");
INSERT INTO wrk_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Yanybayi Jisus yalungi, “Ngayu karungka narrinya. Janarri jilalajba wandijiyana. Janarri milidimba yalunya bukambiju ngakinkanyi kunybanyi jangkurranyi. ");
INSERT INTO wrk_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Kajamukunyi jayalu kuyu narringi jangkurr ngaki, baki janarri ngurrunba yalunya wabudana. Baki janyulu marrimba yalunya mardarda Kudwanyi. Ngala yingkamukunyi jayalu miku kuyu narringi jangkurr ngaki, baki janyulu daba yalunya Kudwanyi. Janyulu manjijba yalunya wayka jangurri. ");
INSERT INTO wrk_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Ngala nanamuku jalija yalu kuyu narringi jangkurr ngaki, jangayu yabimba yalunya ngiruka, yalu yabimbikanyi ngiruka yaji. Kudiyana jayalu jakajba wuwarrmuku yalundunanyi mankanyinanyi nijarriykanyi ngaki niji. Kudiyana jayalu yanyba yinini yinini yanyi. ");
INSERT INTO wrk_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Kudiyana barri jaliyi yalu marrimba bijbawarr miya, baki miku yalunyiyi kurdanba miyawanyi. Jaliyi yalu ngaraba yilarr, baki miku yaliyi lunji. Jaliyi yalungka yarrijba marni yalundu jala yalu lunji, baki jayalu kunybijba mankanyi. Nani barri jayalu yabimba ngiruka yaji ngaki.” Barriwa. ");
INSERT INTO wrk_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Nani barri yanybayi mambuka Jisus yalungi, baki bayngkani nyuli kirrijba kingkarri lalijiyurri. Jungku nyuli nangandu Kudnyina. Nyulu walkurra mambuka bayngkani nangandu Kudnyina. ");
INSERT INTO wrk_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Ngala nanganginmuku kandimuku yalili jilalajba wandijiyana. Yalunjalili milidimba kunybanyi jangkurranyi Jisuskanyi. Bakili kandimba yalunya mambukawanyi Jisuswanyi ngala yalili waki nangangi. Baki nanankardi barri yalili yabimba ngiruka yaji, ngala yalunjalili milidimba. Yingkamukunyi yalunjali najba kandimuku yabimbikurri ngiruka yaji, baki yali yanyba, “Nanda jangkurr nangangi Jisuskanyi, nanda duja jangkurr. Ngambala najbangka Kud wakinkurri yalundu.” Barriwa barri. Bukamba nayinda jangkurr. ");
INSERT INTO wrk_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","2","Wabula kamambarra barrabarruji, jali mikuyaji jambanyi, mikuyaji wabudanyi, nanamanji kamambarra, baki nanda barri jungku nyulili Kudnyina. Nanda barri jungkukili kingkarri nangandu Kudnyina, nanda karu jali jangkurranyi nangangi kudkanyi. Jungku bulili malumba, nanda baki Kud. Malumba bulili jungku nanankujarra. Mankumanku bulangkili nanamannga jangkurranyi. Yanyba bulili nanamannga jangkurr. Nyulu barrinani Kud nanda barri. ");
INSERT INTO wrk_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Nanda jalili jungku Kudnyina, yabimba nyuli bukamba yaji, laliji, baki jamba, baki kanja. Bukamba yaji nyuli yabimba. Waluwa mikuyaji, ngala bayngkani nyuli yabimba yaji, laliji, marda yaji wandijiyana, marda kanja. Bukamba yaji nyuli yabimba. ");
INSERT INTO wrk_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Nanangini barri nyuli yabimba ngambalanya wankan jungunkanyi yurrngumba. Yabimbayi nganinyimuku marda jibarrimuku jungunkanyi yurrngumba wankan. Barriwa. Nanda barri nanda Jisus, nyulu barrinani mirnbi. Jala warnbarrarlbangka yaji mirnbiwanyi, baki minimbaka yaji, baki najba yalu yaji mungana. Nani barri nanda Jisus, nyulili minimba ngambalanya nanankanyi yuwanyi Kudkanyi. ");
INSERT INTO wrk_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Nanda mirnbi warnbarrarlbangka yaji yurrngumba mungijba jala yaji. Yurrngumba nyulu warnbarrarlbangka yaji. Mikuwali mungamba nanda mirnbi nanangini mungawanyi. Warnbarrarlbangka yaji yurrngumba mirnbiwanyi. Barriwa. ");
INSERT INTO wrk_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Baki bayngkani juju, nyuli manjijba nganinyi Kudwanyi. Nijarrijba nyuli nanda nganinyi Jun. ");
INSERT INTO wrk_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Manjijba nyuli nanda, karunki yingkamuku nganinyimuku nanankanyi mirnbinyi. Manjijbayi nanda Jun Kudwanyi, karunki yalunya nanankanyi Jisuskanyi. ");
INSERT INTO wrk_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Nanda Jun, miku nyuli nanda barrinani nanda mirnbi. Miku. Ngala nyuli badajba karunki yalunya nanankanyi mirnbinyi. Miku nyuli barrinani nanda mirnbi. ");
INSERT INTO wrk_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Ngala Jisus, nyulu nanda barrinani nanda mirnbi walkurra. Nyulu minimbaka ngambalanya nanankanyi yuwanyi Kudkanyi. Nyulu karungka bukambiju ngambalanya jangkurranyi Kudkanyi. ");
INSERT INTO wrk_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Baki nanda Jisus, badajba nyuli jambarri. Badajba nyuli, baki nyuli jungku ngambalandu nanganginyina yajina. Yabimba nyuli bukamba yaji, ngala mungkijimuku nangangi, mudumbanyi yali nangangi. Nanda Jisus jali yabimba yaji wandijiyana, miku yaliya jingkijba nanda Jisus. ");
INSERT INTO wrk_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Badajba nyuli nanganginkurri yajiyurri, ngala nanganginmuku mungkijimuku, miku yaliya kandimba. Miku yaliya kuyu nangangi jangkurr. ");
INSERT INTO wrk_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Ngala yingkamukunyi yuku. Kandimba yali Jisus. Manku yali, baki kuyu yali nangangi jangkurr. Jingkijba yali, nyulu jandanyi nangangi Kudkanyi. Jali yalu kuyu nangangi jangkurr, baki nyuli karu yalunya jungunki kunybana yuwana Kudkanyi. Jaliyi yalu jungku kunybana yuwana Kudkanyi, baki yalu jungku barrinani jandanyimuku nangangi Kudkanyi. Nani nyuli yarrijba yalunya jandanyimuku nangangi Kudkanyi. ");
INSERT INTO wrk_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Nanganginmuku jandanyimuku nyuli yarrijba yalunya. Jandanyi yalu nangangi Kudkanyi, ngala miku barrinani bula kuluka malumba maykarra, baki bayngkani nangka binandaba bardardanyi. Miku nani. Miku. Ngala Kudwanyi nyulu yarrijba yalunya nanganginmirra jandanyimuku. Yarrijba nyulu yalunya, kuyu jali yalu nangangi jangkurr Jisuskanyi. ");
INSERT INTO wrk_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Nanda Jisus, karu jala ngambalanya jangkurranyi Kudkanyi, nanda Jisus manjijbayi Kudwanyi ngamandurri. Jungku nyuli ngambalandu mankanyiyudi. Jungku nyuli, baki yanyba nyuli duja jangkurr, mankumanku nangki kunybanyi yajinyi. Najba ngambali nanda Jisus. Jingkijba ngambali nyuli walkurra mambuka, nyulungangi jandanyi nangangi Kudkanyi, nanganginmirra jandanyi nyuluman. ");
INSERT INTO wrk_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Nanda Jun Ngurrunbawarr, yanyba nyuli Jisuskanyi. Karu nyuli yingkamuku kudanyu Jisuskanyi. Nayi nyuli yanyba yalungi, “Nanda jalija badajba bayngkani ngakindu, nyulu barri walkurra mambuka nyuluman. Miku ngayu walkurra. Miku. Ngala nanda, nyulu walkurramirra, jungkungangi nyulu waluwa ngaki, waluwa ngayi bardarda. Ngala ngayu mikuyaji, ngala nyulu jungku wankan.” ");
INSERT INTO wrk_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Nyulu walkurra mambuka, baki nyulu yabimba kunyba yaji ngambalangi. Kunyba yaji nyulu yabimba ngambalangi, marukangangi nyulu muwa ngambalangi. Kaja yaji kunyba nyulu yabimba, baki mili kunyba yaji, baki mili, marukangangi nyulu muwa bukambijuyngka, nganiyngkanyi, jibarrinyi, bayamukuyngka. Barriwa. ");
INSERT INTO wrk_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Nanangini wankalawanyi Musiswanyi, kamambarra nyuli milidimba ngambalanya yuwanyi Kudkanyi. Milidimba nyuli yuwanyi Kudkanyi. Ngala nanangini Jisuswanyi Krayiswanyi, mili nyulu milidimba ngambalanya yingkanyi jangkurranyi. Nanda jangkurr yanybaka Kudkanyi, nyulu maruka muwa ngambalangi. Nanda jangkurr jali yanyba Jisus Krayis, nanda duja jangkurr Kudkanyi, maruka nyulu muwa ngambalangi. ");
INSERT INTO wrk_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Nanda Jisus, jungku nyuli wilina Kudnyina. Ngawamba nyuli najba Kud. Miku yingkawanyi najbayi Kud. Miku. Ngawamba Jisuswanyi nyuluman najbayi Kud, baki nyuli karu ngambalanya Kudkanyi. Barriwa. ");
INSERT INTO wrk_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Nanamuku mambukamuku jurjkanyi, jungku yalili Jirusalim. Jali yalu manku nangangi Junkanyi Ngurrunbawarrayngka, baki manjijba yalunjali nangandurri. Manjijba yali kudiya malbumalbu jurjkanyi. Manjijba yalunjali nangandurri Junyurri. ");
INSERT INTO wrk_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","28","Kangandijba yali karri bundalina niji Jurdan, jali ngurrunba yalunya Junwanyi. Kangandijba yali nanankurri yajiyurri Bidaniyurri. Jali yalu wanbiya Junyina, ngajaka yali, “Ninji ngurrunbawarr, wanyi ninji, wanyi.” Jananganjayi yalunya Junwanyi. Mikuwali julanba. Jananganja nyuli, “Miku ngayu nanda Krayis. Miku.” Barriwa. Baki ngajaka yali, “Ngala wanyi ninji. Ninji kuna nanda wankalanyi Yalayija.” Jananganjayi Junwanyi, “Miku. Miku ngayu nanda Yalayija.” Mili yali ngajaka nanda Jun, “Ngala ninji kuna nanda jali nyulu manjijba Kudwanyi. Nanda wankala Musis yanyba nyuli nayinda jangkurr, ‘Manjijba janyulu yingka barrinani ngayu. Yingka barrinani ngayu janyulu manjijba Kudwanyi.’ Barriwa. Ninji kuna nayi.” Ngala mili yalunya jananganjayi Junwanyi, “Miku ngayu nayinda. Miku ngayu.” Baki mili yali yanyba nangangi Junkanyi, “Ngala wanyi barri ninji. Karukiyi nurrunya nganyi. Karukiyi nurrunya wanyi ninji. Nanamuku manjijba jali nurrunya nganyindurri, yalu nulijba jingkiykanyi nganyi. Wanyi jangkurr nganyi janurru wiykunumba yalundurri. Ngala wanyi barri ninji.” Barriwa. Baki jananganjayi Junwanyi. Nayi nyuli yanyba, “Ngayu nayi. Nanangini wankalawanyi Yayisayawanyi yarrijba nyuli nayinda jangkurr. Yarrijba nyuli najana Kudkanyi nayi, ‘Jilalajbaja nganinyi mangkurruna. Kaya janyulu kudanyu. Kaya janyulu nayi.’ Birrirrinja narringka nanda narringi kurdulu, badajbangangi nanda walkurra mambuka. Badajba janyulu, nanda jalija Kudwanyi manjijba. Birrirrinja narringka nanda kurdulu nangangi. Nani yanybayi nanda Yayisaya. Barriwa. Nanda jala kaya mangkurruna nanda ngayu.” Barriwa. Kudiyamuku nanaba jali yanyba nangangi Junkanyi, manjijbayi yalunya Barasimukunyi nangandurri Junyurri. Nanamuku Barasimuku yalili kudanyu durrijba nanda yuwa nangangi Musiskanyi. Ngajaka yali Jun nangingkanyi jangkurranyi Barasimukunyi, “Yanyba ninji, miku ninji Krayis. Miku ninji Yalayija. Miku ninji nanda barrinani Musis. Ngala wanyingkanyi ninji yalunya ngurrunba. Wanyingkanyi barri.” Jananganja yalunyi Junwanyi, “Ngurrunba ngayili yalunya wabudana. Wabudana ngayili ngurrunba yalunya. Ngala nayiba jungkuka yingka nganinyi narrinbu, ngala miku narrimi jingkijba. Miku. Miku narrimi jingkijba nanda jala jungkuka narrinbu. Ngala nyulu nanda jala badajba bayngkani ngakindu. Waluwa ngayi badajba, baki bayngkani nyulu. Nyulu walkurra mambuka, ngala miku ngayu. Miku ngayu walkurra dulaykanyi nangangi jabunungkaji. Miku ngayu walkurra barrinani nanda. Miku ngayiyi dulaba jabunungkaji nanganbunanyi nukaminanyi. Walkurra kudanyu nyulu ngaki. Nyulu ngiruka. Miku ngayu.” Nani jananganjayi yalunya Junwanyi. Barriwa. Nani yali yililikajba Jun Jumukunyi, baki wijba yali bayungu Jirusalimyurri. ");
INSERT INTO wrk_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Munganawa, najbayi Jisus Junwanyi. Najba nyuli Jisus badaykurri nangandurri. Ngala nyuli badajba, baki yanybayi Jun yalungi nanganbu, “Ningkijbakiyi narri. Nanda jala badajbangka, nyulu barrinani Bulungu Jibkanyi. Ngambalili kurdanba bulungu jibkanyi manjamanjambikanyi ngambalangi balki yaji Kudwanyi. Nyulu jala badajbangka nyulu barrinani Bulungu Jibkanyi Kudkanyi. Kuyu janyulu narringi balki yaji, yabimba jala narri. Manjamanjamba janyulu narringi balki yaji, Bulungungangi nyulu, barrinani Jib Kudkanyi.” Nayinda jangkurr “Bulungu Jibkanyi Kudkanyi”, nayinda yingka niji nangangi barrinani Krayiskanyi. ");
INSERT INTO wrk_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Mili yanybayi Jun nayi, “Nanda jala badajbangka, nyulu nanda, yanyba jala ngayi narringi wabula. Karu ngayi narrinya nangangi wabula. Nyulu nanda walkurra mambuka, manjijba jali Kudwanyi. Nyulu nanda walkurra mambuka. Miku ngayu walkurra mambuka barrinani nyulu, jungkungangi nyuli waluwa ngaki. ");
INSERT INTO wrk_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Miku ngayiya jingkijba kudanyu wanyi nayi badajba bayngkani ngakindu. Miku ngayiya jingkijba. Ngala ngurrunba ngayu yalunya, jali yalu ngindu yalunginkanyi balkinyi yajinyi. Baki jayalu jingkijba nanamukunyi Jumukunyi. Jayalu jingkijba nanda jala badajba ngamandurri. Jayalu jingkijba, nyulu Bulungu Jibkanyi, nanda Krayis.” Nani Junwanyi karuyi yalunya Jumuku, Jisuskanyi. Nani nyuli karu yalunya ngala badajbayi Jisus nangandurri Junyurri. ");
INSERT INTO wrk_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Baki mili karuyi yalunya Junwanyi, “Najba ngayi nanda Kunyba Ngarndu Kudkanyi. Najba ngayi nanda Ngarndu karralankurri kingkarrinya. Kingkarrinya nyuli karrala nangandurri Jisusyurri. Jungku nyuli nangandu kulajina, barrinani kulukuku babangka kingkarrinya kurndarri. Nani barri karralayi Ngarndu Kudkanyi nangandurri Jisusyurri. ");
INSERT INTO wrk_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Miku ngayiya jingkijba wanyi nayinda, jangumba karralayi kingkarrinyi nanda Kunyba Ngarndu Kudkanyi nangandu kulajina, barrinani kulukuku. Kudwanyi manjijbayi ngana ngurrunbiji yalunya. Manjijbayi ngana ngurrunbiji kalawunyi wabudana. Yanybayi Kud ngaki, ‘Ngurrunba janinji yalunya. Yingka barri janyulu badajba nganyindurri. Jalija nyulu wanbiya, manjijba jangayu ngaki Kunyba Ngarndu nangandurri. Najba janinji ngaki Ngarndu karralankurri nangandurri kulajiyurri, jungunki nangandu kulajina. Jalija ninji najba, baki janinji jingkijba nanda nyulu. Yawumba ninji yalunya wabudana, ngala nyulu, yawumba janyulu Ngaki Kunyba Ngarndu yalundu.’ Nani barri yanybayi Kud ngaki, jali ngana manjijba Kudwanyi. ");
INSERT INTO wrk_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Ngala nanamanji jali ngayu najba Jisus, nanamanji ngayi jingkijba. Jingkijba ngayi, nyulu Jandanyi Kudkanyi. Karu ngayu narrinya, nayinda nyulu Jandanyi Kudkanyi nyuluman.” Barriwa. Nani yanybayi Jun yalungi ngala badajbayi Jisus nangandurri. Barriwa. ");
INSERT INTO wrk_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Munganawa barri, ngala nyuli ngabungabujba yaji, nanda Jun Ngurrunbawarr, jungku nyuli nanaba. Jungku nyuli baki kandiwuya nanaba nangandu. Malumba yali jungku nanamannga nanda yaji. ");
INSERT INTO wrk_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Jungkuyi Jun baki mili nyuli najba Jisus jilaykurri. Najba nyuli Jisus jilaykurri. Najba nyuli Jisus jilaykurri nanganduyangka. Baki nyuli yanyba, “Ningkijbakiyi. Nanda, nyulu Bulungu Jibkanyi Kudkanyi.” ");
INSERT INTO wrk_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Manku buli nanda jangkurr, kandiwuyanyi Junkanyi, jali jungku nangandu. Manku buli baki walajba buli. Walajbayi baki durrijba buli Jisus. ");
INSERT INTO wrk_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Yangkalambayi Jisus, baki najba nyuli bulanya kandiwuya Junkanyi. Najbayi bulanya durriykurri bayngkani nangandu. Yanyba nyuli bulangi. Nayi nyuli yanyba, “Wanyingkanyi ngana nimbala durrijba. Wanyingkanyi.” Jananganja buli, “Milidimbawarr. Wanjawa nganyi barnda. Wanjawa janinji kuluka.” ");
INSERT INTO wrk_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Yanybayi Jisus bulangi, “Nimbala. Jilajba janimbala ngakindu, baki janimbala najba ngaki barnda. Janimbala jilajba ngakindu.” Barriwa. Baki barlba buli nangandu Jisusnyina. Najba buli nangangi barnda, baki jungku buli nangandu baki mungijbayi yaji. ");
INSERT INTO wrk_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Nanankujarra, manku jali jangkurr Junkanyi, jilajba jali nangandu Jisusnyina, yingka nangangi niji Yandru, nyuli kanyiya nangangi Sayimin. ");
INSERT INTO wrk_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Baki Yandru, waluku nyuli barlba kuji nanganginkanyi buwanganjanyi. Kujbayi nangangi, niji nangangi Sayimin. Jala wakarambayi nangangi buwanganja, karu nyuli, “Wakaramba nurri nanda Krayis. Wakaramba nurri.” Barriwa. ");
INSERT INTO wrk_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Baki buli badajba Jisusyurri. Jala buli wanbiya nangandu, baki ningkijba nyuli Sayimin Jisuswanyi. Ningkijba nyuli, baki yanybayi Sayiminkanyi, “Nganyi niji Sayimin, ninji jandanyi Junkanyi. Nanda Jun, yingka nyuli, malbu nanamannga niji Jun. Nganyi niji Sayimin, ngala wajba ningaja yingkanyi nijinyi. Nijarrijba janinga yingka niji, Bida. Nanda niji Bida, nanda buyingkinyi niji nganyi.” Nanda jangkurr Bida, Krik yanyi barrinani nanda jangkurr ‘dungala.’ ");
INSERT INTO wrk_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","44","Nanankujarra buwakula Yandru marda Bida, jungku bulili barrawuyabarrawuyana niji Bidsayida. Nanda bulangi yaji Bidsayida. Marda yingka nganinyi, jungku nyulili nanaba, nangangi niji Bilib. Barriwa. Munganawa barri, najbayi wakaramba nyuli nanda Bilib Jisuswanyi. Najbayi baki yanybayi nangangi, “Barlba jangayu nanankurri yajiyurri niji Kalili. Janinji jilajba ngakindu. Langki nungkalaja jilajba.” Barriwa. ");
INSERT INTO wrk_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Waluku barri jilajbayi Bilib. Wakaramba nyuli nangangi kandi, niji Nadanyil. Yanybayi Bilib nanganginkanyi kandinyi, “Wakaramba nurri nanda Kudkanyi. Nanangini wankalawanyi Musiswanyi, yarrijba nyuli najana Kudkanyi. Yarrijba nyuli nangangi, manjijba jalija Kudwanyi. Wakara barri. Wakaramba nurri nanda barrinani Musis. Marda yingkamukunyi wankalamukunyi, yanyba jali jangkurr Kudkanyi, yarrijba yali nangangi marda. Wakaramba nurri nanda, yanyba jali yalu nangangi, nangangi niji Jisus. Jungku nyulili Nasarid, nangangi yaji. Nyulu jandanyi nangangi malburruwa Jusibkanyi. Wakaramba nurri barri.” Barriwa. ");
INSERT INTO wrk_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Jananganjayi Bilib kandiwanyi Nadanyilkanyi. Yanybayi, “Nanda, najba jali narri, nangangi yaji Nasarid kuna. Mikuyaji walkurrayngka mambukanyi jardijbayi nanama Nasarid.” Barriwa. Baki Bilib, nyuli yanyba nanganginkanyi kandinyi, “Jilajbakiyi ngakindu naji nanda Jisus. Janinji najba Jisus.” Baki barlba buli Jisusyurri. ");
INSERT INTO wrk_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Najba nyuli bulanya Jisuswanyi. Jali nyulu najba bulanya badaykurri bundu nangandu, baki yanyba nyuli, “Najbakiyi nanda nangandu Bilibnyina. Nyulu kunyba nganinyi Ju, kunybamirra. Nyulu yanybawarr yurlurr, marda jungkuka kunyba. Mikuyaji nangandu balkinyi. Miku nyulimi jujamba yaji.” Barriwa. ");
INSERT INTO wrk_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Mankuyi nanda jangkurr Nadanyilwanyi. Ngala nyuli wanbiya, baki ngajaka nyuli Jisus. “Miku nganinji jingkijba. Miku nganinji najba wabula. Yanka ninji yanyba nanda jangkurr ngaki. Yanka barri.” Jananganjayi Jisuswanyi, “Najba ningi barrin, jungku jali ninji ngarnduna kalawumbina. Najbayi ninga jungunki nanaba, waluwa jilajbayi Bilib nganyindurri.” Barriwa. ");
INSERT INTO wrk_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Baki yanybayi Nadanyil Jisuskanyi, “Milidimbawarr. Ninji Jandanyi Kudkanyi. Ninji walkurra mambuka bukambijuyngka Jumukuyngka. Ninji Jandanyi Kudkanyi.” ");
INSERT INTO wrk_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Yanybayi Jisus, “Nanda jangkurr yanyba ninji ngaki. Mankumanku nganyingka ngayu Jandanyi Kudkanyi kuna, karungangi ninga, najba ninga barrin ngarnduna kalawumbina. Nani kuna nganyingka mankumanku ngaki, ngayu Jandanyi Kudkanyi. Nanda ngaki yaji kunyba, ngala ngawamba bijal ngiruka jingkijba jala ngayi, ninji nanaba ngarnduna. Mili jardibirri ngiruka yaji baku. Najba janganinji yabimbikurri ngiruka yaji kudukudu baku barri.” ");
INSERT INTO wrk_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Mili yanybayi Jisus, “Karungka ngayu duja jangkurr. Baku barri, najba janinji bardawa lalijina. Najba janinji nanamuku Yanjilmuku, waki jala Kudkanyi. Badajba jayalu ngakindurri, Buwayarri Bukambijuyngka. Wurrududu jayalu kingkarrinya ngakindurri, baki kirrijba jayalu kingkarri. Barriwa.” Nani yanybayi Jisus nangangi Nadanyilkanyi. ");
INSERT INTO wrk_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Yingkana mungana, jamalu bulangki nananyina yajina barrawuyabarrawuyana, niji Kayina, baki jarrba yali kunyba mama bulangi. Marda ngardanganja nangangi Jisuskanyi, jarrba nyuli mama nanaba bulangi. ");
INSERT INTO wrk_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Jisus marda nanganginmuku kandimuku, jungku yali nanaba. Jarrba yali mama marda. Jarrba yali mama, baki ngaraba yali marda ngarrki krayibkanyi. ");
INSERT INTO wrk_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Kamu barri, yali ngaraba bukamba ngarrki krayibkanyi. Jali bukamba nanda ngarrki, baki ngardanganja Jisuskanyi yanyba nyuli nangangi Jisuskanyi. Nayi nyuli yanyba, “Mikuyaji ngarrkinyi krayibkanyi. Mikuyaji. Bukamba yali.” Barriwa. ");
INSERT INTO wrk_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Jananganjayi Jisuswanyi, “Wanyingkanyi nganinji karu ngarrkinyi. Wanyingkanyi. Jilijbawa ngayuja minimba yalungi nanda ngiruka yaji jalija ngayu yabimba. Jilijbawa. Barriwa.” ");
INSERT INTO wrk_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Ngala nyuli karu yalunya wakiwarrmuku ngardanganjawanyi Jisuskanyi. Yanyba nyuli yalungi, “Yabimbakiyi nanda, karu jalija narrinya yabimbikanyi. Yabimbakiyi nanda, yanyba jalija nyulu. Barriwa.” ");
INSERT INTO wrk_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Nanamuku Jumuku, nayinda yalungi yaji. Waluku yalungkili wakardaba marni, baki bayngkani yali jarrba yaji. Nanda yuwa Jukanyi yanybayi nani wakardaykanyi marni. Barriwa. Jungkuyi nanaba kaja lujuluju marda yalungi wabudanyi. Nanda lujuluju yalungi jungkuyi kujarra yingamali baki kujarra yingamali. Walkurra barri kudanyu nanda lujuluju. ");
INSERT INTO wrk_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Baki yanybayi Jisus yalungi wakiwarrayngka. Karu nyuli yalunya, “Wudumbakiyi yalunya kaja lujuluju baki kularrijbakiyi wabuda. Kularrijba janarri wabuda.” Ngayangayijba yali nanda jangkurr Jisuskanyi. Wudumba yali wabuda, kularrijba yali nanda wabuda walbinyi. ");
INSERT INTO wrk_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Baki karu nyuli yalunya Jisuswanyi, “Wudumbakiyi kudiya wabuda lujulujunanyi. Wudumbakiyi wabuda, baki kuyukiyi nanda wabuda mambukarri. Wajba janarri nanda mambuka wabudanyi lujulujunanyi. Barriwa.” Ngayangayijba yali Jisuskanyi. Kuyu yali nanda wabuda mambukarri. Barriwa. ");
INSERT INTO wrk_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Marrimbayi nanda wabuda mambukawanyi, wajba jali wakiwarranyi. Marrimba nyuli, baki balanjayi. Ngala miku nanda wabuda. Miku. Waluwa nyuli wabuda, ngala yangkalamba nangki ngarrki krayibkanyi. Miku nyuliya jingkijba nanda ngarrki krayibkanyi mambukawanyi. Miku nyuliya jingkijba, ngala wakiwarranyi, yuku yalu jingkijbayi. Nanda mambuku jilajbayi nangandurri buyingkingkurri nawinganjarri. Ngamu kilimbayi kunyba ngarrki kamunyi nawinganjawanyi. ");
INSERT INTO wrk_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","Baki yanybayi nangangi, “Yingkamukunyi, waluku yalunjalu wajba kunybayi ngarrkinyi krayibkanyi. Waluku nanda kunyba ngarrki, ngala bayngkani wajba yalunjalu yingkanyi ngarrkinyi jala miku kunyba. Ngala ninji barri miku. Bayngkani ninji wajba nurrunya nanginkanyi kunybanyi ngarrkinyi. Ninji barri kunyba nganinyi. Kunyba ninji.” ");
INSERT INTO wrk_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Nani yabimbayi walkurra yaji ngiruka Jisuswanyi. Jalannga nyuli yabimba ngiruka yaji nananyina yajina Kayina. Nanda yaji Kayina, nananyina walkurranyina yajina Kalili. Jingkijba yali, nyuli walkurra mambuka, yabimbangangi nyuli nanda ngiruka yaji ngarrkinyi krayibkanyi. Nanamukunyi nanganginmukunyi kandimukunyi, jingkijba yali, nyuli Jandanyi Kudkanyi. Barriwa. ");
INSERT INTO wrk_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Baku barri jilajba nyuli karri, marda yali jilajba nangandu, nangangi ngardanganja, marda nanganginmuku kanyiyamuku, marda nanganginmuku kandimuku. Bukamba yali jilajba karri Kabirnayumyurri. Jungku yali nanaba mardunguji. ");
INSERT INTO wrk_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Winyurru nanda wangarr yalungi, niji ‘Kangandijbayi Barrawuna Yajinyi,’ jalili yalu jarrba nanda damba, mikuyaji bululunyi. Kajamuku Jumuku yalili jilajba Jirusalimyurri wangarranyi. Jisus marda yingkamuku nangandu, jilajba yali kularriji Jirusalimyurri. Jilajba yali wangarranyi niji ‘Kangandijbayi Barrawuna Yajinyi.’ ");
INSERT INTO wrk_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Jilajbayi Jisus walkurrayngkurri, jurjyurri. Ngankijba nyuli kalawunyi, baki najba nyuli kajamuku nganinymuku nanaba jurjina, kalawunyi. Kudiya yali jungku nanaba bulukiyudi, marda kudiya yali nanaba jibyudi, kudiya yali kulukukuyudi. Jungku yali nanaba waykanyi yajinyi, marda bulukinyi, marda jibkanyi, marda kulukukunyi. Wajba yalunjali dungalanyi yingkamukunyi, wudumba jali yalu nanda yaji. Barriwa. Ngala yingkamukunyi, yali kuyu yalungi dungala, wajba yalunjali yingkanyi dungalanyi. Jali nyulu ngankijba kalawunyi jurjina, baki najbayi yalunya Jisuswanyi, baki nyuli ngarrangarra muwa yalungi. Ngarrangarra nyuli muwa jala nyuli najba yalunya wawaykurri yajinyi. ");
INSERT INTO wrk_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Wudumba nyuli laja, baki yabimba nyuli kurul wajuykanyi yaji. Jakajba nyuli nanamuku bulukimuku, marda jibmuku. Jakajbayi danbiyurri kurulyudinyi. Jakajba nyuli jurjnanyi danbiyurri. Baki nyuli janyba darladarlamuku, jungku jali nanda dungala yundu. Janyba nyuli baki jarrbalamba nyuli yalungi dungala junu. ");
INSERT INTO wrk_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Baki jirrinyba nyuli nanamuku, kuyu jali kulukuku kalawunyi wudumbiji dungala. Jirrinyba nyuli, “Mikujiyi kuyu yaji nayiwa. Kuyukiyi yaji nanawa danbiyurri. Mikujiyi kuyu nanda kulukuku kalawuyngkurru jurjyurri. Nayinda yaji jurj nangangi Kudkanyi. Nayinda nangangi barrawu ngakinkanyi Buwanganjanyi. Miku nayinda barrawu waykanyi narrinya dungalanyi.” ");
INSERT INTO wrk_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Baki kandimukunyi Jisuskanyi, mankuwa yali wankalanyi jangkurr. Nayi nanda jangkurr, “Ngurrunajba nganyi ngakinkanyi Kudkanyi. Marda ngurrunajba nganyingkanyi barrawunyi jurjkanyi. Janganjalu linjumba, kurdanba, marukangangi ngayu muwa nganyingkanyi jurjkanyi, kurrkunbangangi ngayu yalunya, baki yalu barimba nanda kudukudu yaji nganyi.” Kandimukunyi Jisuskanyi mankuwa yali nanda jangkurr, jali Jisuswanyi jakajbayi yaji jurjnanyi. ");
INSERT INTO wrk_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Ngala mambukamukunyi jurjkanyi, ngajaka yali Jisus, “Wanjangi ninya karuyi jakaykanyi yalunya jurjnanyi nani. Karuyi ninya Kudwanyi kuna. Jaliyi ninya karu Kudwanyi, baki yabimbakiyi ngiruka yaji nurrungi, baki janurru jingkijba ninji walkurra ngiruka. Janinya nurru jingkijba, manjijba ninyi Kudwanyi, yabimba jalija ninji ngiruka yaji.” Barriwa. ");
INSERT INTO wrk_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Jananganjayi yalunya Jisuswanyi, “Jaliyi dalyawijba nayinda jurj, baki jangayu mili yabimba nayinda jurj. Kujarraka barndayka jangayu mili yabimba, baki kunybijbaja bukamba.” Barriwa. ");
INSERT INTO wrk_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Yanyba yali nangangi, “Miku ninjimi yabimba mili kujarraka barndayka. Miku. Jali yalu yabimba nayinda jurj, waki yali yurrngumba kajana kindilkurrinyina. Kajana kindilkurrinyina, 46 barri yali waki yabimbiji nayinda jurj. Miku ninjiyi mili yabimba kujarraka barndayka.” Barriwa. ");
INSERT INTO wrk_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Jali yanyba Jisus mili yabimbikanyi yaji, miku nyuliya yanyba yabimbikanyi nanda walkurra jurj. Miku. Ngala yanyba nyuli nanganginkanyi mankankanyi, janyulu wankijba mili. Wankijba janyulu mili kujarraka barndayka bayngkani jalija nangka janyba. ");
INSERT INTO wrk_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Baku barri jali kurdanba yalu Jisus, baki wankambayi Jisus mili Kudwanyi, baki mankumanku yalungki kandimuku Jisuskanyi. Mankuwa yali nangangi jangkurr, yabimbikanyi yaji mili. Baki jingkijba yali nanda yingka wankalanyi jangkurr nangangi, ngurrunajba jali yajinyi. Kuyu yali nanda wankalanyi jangkurranyi. Marda kuyu yali nanda jangkurr Jisuskanyi, yabimbikanyi yaji mili. Barriwa. ");
INSERT INTO wrk_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Jungkuyi Jisus Jirusalim wangarranyi niji ‘Kangandijbayi Barrawuna Yajinyi.’ Ngala nyuli nanaba, yabimba nyuli kaja walkurra yaji ngiruka. Kajamukunyi, jingkijba yali Jisus, nyuli Krayis, najbangangi yali nanda ngiruka yaji kaja, yabimba jali nyulu. Najba yali nanda ngiruka yaji baki jingkijba yali, nyuli Krayis. ");
INSERT INTO wrk_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","25","Ngala Jisuswanyi jingkijba nyuli yalunya. Jingkijba nyuli bukambiju, nganinymuku jibarrimuku, baki mikukiya yingkawanyi karu Jisus yalungi, wanyingkanyi nangka mankumanku yalungi. Muningka yalunya jingkijba. Jingkijbayi yalunya, nanamanji yali kuyu nangangi jangkurr, maruka yali muwa nangangi. Ngala baku jayalungka yangkalamba nanganbunanyi. Nani nyuli jingkijba yalunya. Baki nyuli jabulinyba yalunya Jisuswanyi. Jabulinybayi yalunya. Barriwa. ");
INSERT INTO wrk_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Nanda mambuka Jukanyi, niji nangangi Nikidimus. Nyuli barri Barasi. ");
INSERT INTO wrk_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Jilajba nyuli nangandurri Jisusyurri. Jilajbayi mungana yanybikanyi. Yanybayi Nikidimus, “Mambuka. Nurru jingkijba ninya, ninji milidimbawarr. Manjijbayi ninya Kudwanyi. Mikuwali yabimba yaji nyuluma kunymambikanyi yalunya. Ngawamba kunymambikanyi yalunya, kandimba jala nanda Kudwanyi.” Barriwa. ");
INSERT INTO wrk_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Yanybayi Jisus nangangi, ngala miku yurlurrmbikanyi, “Ngayu karungka ninya duja. Muningka janyulu yingka walajba mili, baki yuku janyulu jungku yurrngumba Kudnyina.” Barriwa. ");
INSERT INTO wrk_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Ngajakayi Jisus malbuwanyi, “Yanka barri mili nganinyi walajbaja. Yanka nyulu mili ngankijba muwana ngardanganjana jali jalanmirri birnandaba nangka mili. Mikuwali ngankijba mili.” Barriwa. ");
INSERT INTO wrk_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","6","Jananganjayi Jisuswanyi, “Nayinda duja jangkurr. Jalija nangka birnandaba Kunyba Ngarndu Kudkanyi nangangi, baki yuku janyulu jungku nangandu, Kudnyina. Nanda jala walajba bardarda mankanyi, yuku nyulu jungku nayiba yajina, ngala nanda jala birnandaba nangka Kunyba Ngarndu Kudkanyi, yuku janyulu jungku wanka yurrngumba Kudnyina. ");
INSERT INTO wrk_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Mikujiyi manmala, yanyba jala ngayu nganyi, marda ninjimi mili walajba baki jungku janinji wanka yurrngumba. Mikujiyi manmala. ");
INSERT INTO wrk_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Janganyingka mankumanku yunkurranyi. Warrmbaka yaji yunkurrwanyi. Yuku ninji manku yunkurr, ngala miku ninjimi jingkijba, wanjamunanyi badajbangka, wanjakurri jilajbangka. Miku ninjimi jingkijba. Barrinani nangka birnandaba nangangi Kunyba Ngarndu Kudkanyi. Miku ninjimi jingkijba kudanyu yunkurranyi. Miku ninjimi kudanyu jingkijba nanda Kunyba Ngarndu Kudkanyi, nangka birnandaba nangangi. Duja ngayu yanyba. Janyulu walajba mili.” Barriwa. ");
INSERT INTO wrk_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Yanybayi malbu Nikidimus, “Yanka barri nayinda. Miku ngayimi jingkijba.” ");
INSERT INTO wrk_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Jananganjayi Jisuswanyi, “Ninji mambuka Jukanyi. Ninji milidimbawarr, ngala miku ninjimi jingkijba. ");
INSERT INTO wrk_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Nayinda duja jangkurr. Nurru karungka nanda jala nurru jingkijba. Nurru karungka nanda jala nurru najba yaji, ngala miku ninjimi kuyu nurrungi jangkurr. ");
INSERT INTO wrk_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Jala ninya karu jungunkanyi nanijba, baki miku ninjimi kuyu nanda jangkurr, ngala yanka janinji jingkijba, jalija ninya karu nanganginkanyi yajinyi Kudkanyi. Yanka janinji kuyu nanda jangkurr. ");
INSERT INTO wrk_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Mikuwali yingka kirrijba kingkarri Kudyurri. Ngawamba nanda jali karrala wayka Kudnanyi. Ngawamba yuku nyulu kirrijba kingkarri Kudyurri. Ngawamba nyuli Buwanya Bukambijuyngka. ");
INSERT INTO wrk_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Juju wabula nanda mambuka Musis, jala nyuli jungku nanaba mangkurruna yajina, langandaba nyuli miya, yabimba jali nyulu. Langandaba nyuli miya kurndana. Nani barri jayalu Buwanya Bukambijuyngka langandaba kurndana. ");
INSERT INTO wrk_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","Baki nanda jala mirnarrijbangka muwa nangangi Buwaya Bukambijuyngka, janyulu wankijba yurrngumba.” Nani barri yanybayi Jisus nangangi malbunyi. ");
INSERT INTO wrk_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Marukangka Kud muwa kudanyu barri bukambijuyngka, nganinyimukuyngka, jibarrimukuyngka, bayamukuyngka. Manjijbayi nangangi Jandanyi Kudwanyi, marukangkangangi nyulu muwa bukambijuyngka. Ngala nanda jala jungku kunyba yurrngumba, jala kuyu nangangi jangkurr jandayngkanyi, janyulu wankijba yurrngumba. Jalija nangka janyba, baki mili wankijbaja, janyulu jungku wanka kingkarri Kudnyina. ");
INSERT INTO wrk_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Manjijbayi Kudwanyi nangangi Jandanyi Jisus. Manjijbayi Jisus Kudwanyi, miku muningka karunkanyi yalunya yalu balki kudanyu, miku jayalu jungku yurrngumba nangandu Kudnyina. Miku nanankardi manjijbayi Jisus Kudwanyi. Ngala manjijba nyuli Jisus, nyulu karunkanyi yalunya Kudkanyi, karunkanyi yalunya, marukangka muwa yalungi Kud kudanyu. Manjijbayi Jisus Kudwanyi nyulu karunkanyi yalunya, jalija yalu jungku kunyba, jalija yalu kuyu nangangi jangkurr, waluwa jayalungka janyba, baki mili jayalu walajba. Jayalu jungku wanka kingkarri nangandu. ");
INSERT INTO wrk_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Nanda jala kuyu jangkurr Jisuskanyi, baki maruka muwa Kudkanyi, nanda jala jungku kunybana yuwana Kudkanyi, janyulu wankijba mili. Ngala nanda jala miku kuyu jangkurr nangangi Jisuskanyi, Jandayngkanyi Kudkanyi. Nanda jala miku kuyu nangangi jangkurr, jalija nangka janyba, miku janyulu mili wanka jungku Kudnyina. Jaliyi nyulu miku maruka muwa Kudkanyi, jaliyi nyulu miku jungku kunyba Kudkanyi, baki miku kuyu nanda jangkurr Jisuskanyi, mikuwali mili wankijba. Barriwa. ");
INSERT INTO wrk_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","20","Nani barri, jala nyulu mungijba yaji, baki mikukimi najba yaji. Mikuwali yingkawanyi najba. Jaliyi nganinyi nulijba barimbikanyi yaji baki nyulu barimba yaji mungana, mikuwali yingkawanyi najba nanda barimbikanyi yaji. Barimba nyulu yaji mungana. Mirnarrijba nyulu muwa munganyi jala mikuyaji mirnbinyi wambarralba yaji. Nyulu balki jungku mungana, jala mikuwali najba yingkawanyi. Ngala Jisus, nyulu barrinani mirnbi. Yalu, jala yalu balki, miku yalimi jilajba nangandurri Jisusyurri. Jingkijbangka yalunya Jisuswanyi, yalu balki jungku. ");
INSERT INTO wrk_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Ngala nanda jala jungku kunybana yuwana Kudkanyi, jala maruka muwa Kudkanyi, nyulu jungkuka kunyba yurrngumba, kambana baki mungana. Baki yingkawanyi najbangka, baki jingkijbangka nangangi kunyba yaji. Nyulu jilajbangka Jisusyurri, marukangangi nyulu muwa Kudkanyi baki Jisuskanyi. Barriwa. ");
INSERT INTO wrk_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","23","Baku barri barlba yali Jirusalimnanyi, Jisus marda nanganginmuku kandimuku. Jilalajba yali langkurri nananyina walkurranyina yajina Judiya. Marda ngurrunba yali kudiya, jungku jali yalu nanaba. Nanda Jun Ngurrunbawarr, nyuli nanaba marda, nananyina yajina Yayinin. Nanda Yayinin, bundu yingkana yajina Salim. Ngurrunba nyuli yalunya kajangangi wabuda nanaba. Nanamuku jilajba jali nangandurri, ngurrunba nyuli yalunya. ");
INSERT INTO wrk_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Nanamanji jilijbawa yarrijba nyuli Jun brisinyina, nanangini walkurranyi mambukawanyi. ");
INSERT INTO wrk_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Kudiya kandimuku nanganginmuku Junkanyi jakakajba yali. Jakakajba yali kandimuku Junkanyi, marda yingka Ju jungku jali nanaba. Jakakajba yalungki jangkurranyi, yarrijba jali Musiswanyi wakardaykanyi yalungka. Jakakajba yalungki nanankanyi yuwanyi Musiskanyi wakardaykanyi yalungka. ");
INSERT INTO wrk_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Baki jilajba yali Junyurri. Yanyba yali nangangi, “Milidimbawarr. Jingkijba ninji nanda jali jungku wabula nganyindu, karrurrinybana bundalina. Mankuwa kuna ninji nanda. Karu ninji nurrunya nangangi. Nanijba barri nyuli ngurrunba yalunya, baki kajamuku yali barlba nangandurri. Yingijba ninyalu, baki barlba yali bukamba nangandurri.” Barriwa. ");
INSERT INTO wrk_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Jananganjayi yalunya Junwanyi, “Yingkamuku jilajba yali ngakindurri. Yingkamuku barlba yali nangandurri. Ngala ngawamba Kudwanyi nyulu manjijba yalunya. Manjijbangka Kudwanyi yalunya. Barriwa. ");
INSERT INTO wrk_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Manku narri ngaki jangkurr wabula. Manku nganarri yanybikurri, ‘Miku ngayu Krayis. Miku. Ngala manjijba ngani Kudwanyi. Manjijba ngani karunki yingkamuku Krayiskanyi.’ Karu ngayi yalunya, manjijba ngani Kudwanyi waluwa nangangi. Baki bayngkani nanda Krayis, janyulu jilajba. Manjijba ngani Kudwanyi karunki yalunya birrirranjanki yalungka Krayiskanyi. ");
INSERT INTO wrk_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Mirnarrijba ngayu muwa, manjijbangangi ngani Kudwanyi karunki yalunya Krayiskanyi. Nanda walkurra yaji. Ngala Krayis, nyulu walkurramirra mambuka bukambijuyngka, jungku jalili wandijiyana. Miku ngayu walkurra. Ngala Krayis, badajba nyuli, baki mirnarrijba ngayu muwa, badajbangangi nyuli. Baki mirnarrijba ngayu muwa yalungi jali yalu barlba nangandurri. Miku ngayimi ngirukijba muwa, yingijba jala ngananjalu, baki barlba nangandurri. Miku. Marda yalimi barlba nangandu, baki janyulu milidimba yalunya. Nyulu walkurra mambuka. Miku ngayu. Miku. ");
INSERT INTO wrk_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Waluwa nyuli badajba, ngayi walkurra mambuka. Ngala bayngkani nyuli badajba, nyulu walkurra mambuka. Miku ngayu walkurra. Nanijba nyulu walkurra mambuka. Miku ngayu. Kajamukunyi yalu durrijba Krayis nanijba, ngala kujajarranyi ngana yalu durrijba. Ngala ngayu mirnarrijba muwa nanankanyi. Barriwa.” ");
INSERT INTO wrk_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Nanda Krayis, nyulu walkurra mambuka. Ngala yingkamuku mambukamuku, miku yalu mambuka barrinani Krayis. Nanamuku yingkamuku mambukamuku yalu jandanyi maykarranyi bulangi, ngala Krayis, nyulu Jandanyi Kudkanyi. Nyulu walkurra mambuka, badajbangangi nyuli Kudnanyi. Baki yanyba nyulili yajinyi Kudkanyi, ngala yingkamuku mambukamuku, yalili yanyba jambanyi yajinyi. Miku yaliyi jingkijba nanda laliji yaji. ");
INSERT INTO wrk_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Nanda jali badajba Kudnanyi, karungka nyulu yalunya yajinyi, najba jali nyulu yaji. Karungka nyulu yalunya jangkurranyi, karu jali Kudwanyi, ngala miku yalimi kuyu nangangi jangkurr Krayiskanyi. Ngala ngawamba kujajarrawanyi yali kuyu nangangi jangkurr. ");
INSERT INTO wrk_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Nanamukunyi kuyu jala nangangi jangkurr, jingkijba yalu Kud, nyulu duja. Yanyba nyulu duja jangkurr. Ngala yingkamuku miku jali yalu kuyu nangangi jangkurr, mankumanku yalungka Kudkanyi, jujamba nyulu yalunya. ");
INSERT INTO wrk_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Nanda badajba jali Kudnanyi, yanyba nyulu nangangi jangkurr Kudkanyi, jungkukilingangi nanda Kunyba Ngarndu Kudkanyi nangandu. ");
INSERT INTO wrk_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Buwakanya Kingkarri, maruka nyulu muwa kudanyu nanganginkanyi Jandayngkanyi. Yabimba nyuli nangangi Jandanyi ngiruka yabimbikanyi bukamba yaji. ");
INSERT INTO wrk_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Nanda jala kuyu jangkurr Jandayngkanyi Kudkanyi, janyulu wankijba mili bayngkani jalija nangka janyba. Jungku janyulu wanka mili Kudnyina. Ngala nanda jala miku ngayangayijba jangkurranyi Jandayngkanyi, miku wali wankijba mili. Miku janyulu jungku wanka mili Kudnyina. Baki Kud, janyulu ngarrangarra muwa yalungi jala miku kuyu jangkurr Krayiskanyi. Ngarrangarra janyulu muwa yurrngumba. Barriwa. ");
INSERT INTO wrk_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","2","Kajamuku yali barlba Jisusyurri. Milidimba nyuli yalunya. Jali yalu kuyu nangangi jangkurr, baki ngurrunba yalunjali nanganginyi kandimukunyi Jisuskanyi. Miku nyuliya ngurrunba yalunya Jisuswanyi, ngala karu nyuli nangangi kandimuku, yalunjalu ngurrunbiji, nanamuku kuyu jali nangangi jangkurr. Kajamuku, yali jilajba Jisusyurri, kuyu yali nangangi jangkurr, ngala ngawamba kudiyamuku, yali jilajba nangandurri Junyurri. Ngurrunbawarrayngkurri. Nanamukunyi Barasiwanyi manku yali nanankanyi. Manku yali kajamukuyngka, kuyu jali jangkurr Jisuskanyi, ngala ngawamba kudiyamukunyi kuyu yali jangkurr Junkanyi. Manku yali nanda, baki ngirukijba yali muwa. ");
INSERT INTO wrk_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Ngala Jisuswanyi jingkijbayi yalunya Barasimuku. Jingkijba nyuli, yali ngirukijba muwa nangangi. Baki barlbayi Jisus Judiyananyi. Barlba nyuli langki Kaliliyurri, marda kandimuku nangandu. Barlba yali langki. ");
INSERT INTO wrk_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Ngala buwandijba yali langki nananyina yingkana yajina Samariya. ");
INSERT INTO wrk_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Jila yali barrawuyabarrawuyarri niji Sikarr, nananyina walkurranyina yajina Samariya. Jila yali bundu nananyina yajina jali juju wabula wankalana, wajbayi yajinyi Jakubwanyi. Wajba nyuli nangangi jandanyi Jusib, nanankanyi yajinyi. ");
INSERT INTO wrk_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Nanangini wankalawanyi nyuli kurrijba rirrki nanaba. Barriwa. Jisus marda kandimuku jilajba yali jujunanyi. Wanbiya yali nanaba mukunjana, baki balkijbayi Jisus. Jungku nyuli bundu rirrkina, ");
INSERT INTO wrk_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","8","ngala nangangi kandimuku, jilajba yali barrawuyabarrawuyarri, wudumbiji mama dungalana. Jungkuyi Jisus rirrkina, ngala jibarri jalili jungku nanaba Sikarr, jilajba nyuli rirrkiyurri wudumbiji wabuda walkurranyina yukururuna. Ngajakayi jibarri Jisuswanyi, “Wajba janganinji wabudanyi ngaraykanyi.” ");
INSERT INTO wrk_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Jananganjayi jibarriwanyi, “Kurdu nganyi Ju kuna, ngala ngajaka nganinji wabudanyi.” Barriwa. Nanamuku jali jungku Samariya, miku yali mungkiji Jukanyi. Miku yalunjaliya kandimba Jumukunyi. Miku yalili yanyba yalungi. Jungku yali yanina yanina. Baki nanankardi yanybayi jibarri nangangi Jisuskanyi, “Kurdu nganyi Ju kuna, ngala ngajaka nganinji wabudanyi.” ");
INSERT INTO wrk_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Jananganjayi jibarri Jisuswanyi, “Miku nganinjimi jingkijba. Jalimi nganinji jingkijba, jalimi ninji jingkijba nanda jala yuku wajba ninya Kudwanyi, baki nganinji ngajaka wabudanyi, yinini wabuda nanda wanka. Jalimi nganinji ngajaka wabudanyi, baki jangayu wajba ninya nanankanyi yinini wabudanyi.” ");
INSERT INTO wrk_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Yanybayi jibarri, “Mikuyaji yukururunyi nganyindu, wudumbikanyi wabuda. Juju wayka nanda wabuda rirrkina. Wanjawa janinji wudumba nanda wabuda jala jungku wanka. ");
INSERT INTO wrk_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Ngala mambuka kuna ninji. Walkurra mambuka kuna. Nanangini wankalawanyi nyuli yabimba nayinda rirrki nurrungi. Nyuli walkurra mambuka, nanda malbu Jakub. Ngaraba nyulili wabuda nanginyina rirrkina, baki nanganginyi jandanyimukunyi baki bulukimukunyi, yalili ngaraba nayinda wabuda. Ninji kuna walkurramirra mambuka nangangi. Barriwa.” ");
INSERT INTO wrk_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Jananganjayi jibarri Jisuswanyi, “Nanda jala ngaraba nayinda wabuda rirrkina, baku janyulu mili warinjijba, janyulu mili ngaraba, ");
INSERT INTO wrk_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","ngala nanda jala ngaraba wabuda, wajba jala ngayu, miku nyulimi warinjijba mili. Janyulu wanka jungku yurrngumba Kudnyina.” Nani yanybayi Jisus wabudanyi. Karu nyulili yalunya Kudkanyi Jisuswanyi. Nanda jala kuyu nangangi jangkurr, marda maruka nyulu muwa Kudkanyi, jalija nangka janyba, janyulu wankijba mili yurrngumba Kudnyina. Nanda jala jungku mikuyaji wabudanyi wariyngkanyi baki janangka janyba. Nanda jala ngaraba wabuda, yuku nyulu wanka jungku nayiba jambana. Nanda jangkurr, yanyba jala Jisus, nanda jangkurr barrinani wabuda. Nanda jala kuyu jangkurr Jisuskanyi, janyulu yuku wanka jungku yurrngumba Kudnyina. Nani nanda jangkurr Jisuskanyi barrinani wanka wabuda. ");
INSERT INTO wrk_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Yanybayi jibarri Jisuskanyi, “Mambuka. Nganinji wajba nanankanyi wabudanyi, jala nganinji karu, baki miku ngayiyi warinjijba mili. Miku ngayu mili jila nanginkurri rirrkiyurri wabudanyi.” ");
INSERT INTO wrk_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Yanybayi Jisus nangangi, “Barriwakiyi jilajba. Wudumbakiyi nganyi nawinganja. Janinji wiykunumba ngakindurri.” ");
INSERT INTO wrk_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Jananganjayi jibarriwanyi, “Mikuyaji nawinganjanyi ngakinkanyi.” Yanybayi Jisus nangangi, “Nanda duja jangkurr, yanyba ninji ngaki, mikuyaji nawinganjanyi nganyingkanyi. ");
INSERT INTO wrk_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Kaja barri nganyi nawinganja yingijba ninji, kujarra baki kujarra baki yingamali. Ngala nanijba ninji yingkana kuluka. Miku nanda nganyi nawinganja. Duja ninji yanyba, mikuyaji nawinganjanyi nganyi.” Barriwa. ");
INSERT INTO wrk_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Yanybayi jibarri, “Mambuka. Jingkijba ninji bukamba yaji. Ninji walkurra mambuka, yanyba jala ninji jangkurr Kudkanyi. ");
INSERT INTO wrk_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Maruka nurru muwa Kudkanyi. Nurrili jilajba jurjyurri nanginyina dungalana. Nayiba nurrili yanyba mududu Kudkanyi. Ngala narri Jumuku, narri yanyba nurrungi, marda nurrimi jila nanankurri walkurrayngkurri jurjyurri, nanaba Jirusalim. Marda nurrimi yanyba mududu Kudkanyi nananyina jurjina.” Barriwa. ");
INSERT INTO wrk_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Jananganjayi Jisuswanyi, “Jibarri, mankukiyi nayinda duja jangkurr. Winyurruwa badajbaja nanda yaji jalija yalu miku jila jurjyurri nanginyina dungalana, marda miku nananyina yajina Jirusalim. Miku nayiba, baki miku Jirusalim jayalu yanyba Buwakaya Kingkarri. Barriwa. ");
INSERT INTO wrk_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Miku narrimi jingkijba nanda, yanyba jala narri mududu nangangi. Ngala nurru barri Jumuku, jingkijba nurru nanda, yanyba jala nurru mududu nangangi. Nanda jala jila marrimbikanyi bukambiju mardarda kurdu nangangi Ju. ");
INSERT INTO wrk_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Winyurruwa badajbaja nanda yaji marda nanijba, nanda jala wajba Buwakanya Kingkarri kunybanyi jangkurranyi, nanangini Kunybawanyi Ngarnduwanyi Kudkanyi, nyulu kandimba nanda jala wajba Buwakanya kunybanyi jangkurranyi. Nulijba Kud yalungi waykanyi Kud kunybanyi jangkurranyi, yanybikanyi mududu nangangi. ");
INSERT INTO wrk_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Buwakanya Kud, nyulu duja yijan. Nanangini Kunybawanyi Ngarndwanyi Kudkanyi, nyulu kandimba nanda jala yanyba mududu Kudkanyi, jala yanyba duja jangkurr Kudkanyi.” Barriwa. ");
INSERT INTO wrk_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Yanybayi jibarri Jisuskanyi, “Jingkijba ngayu Kud, janyulu manjijba nanda kingkarrinya, nangangi niji Krayis. Manjijba janyulu Krayis milidimbiji nurrunya bukamba.” Barriwa. ");
INSERT INTO wrk_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Yanybayi Jisus, “Ngayu, yanyba jala ngayu nganyi, ngayu nayinda jali ngana manjijba Kudwanyi. Barriwa.” ");
INSERT INTO wrk_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Ngala yanybayi Jisus jibarrinyi, wanbiya yali kandimuku nangangi. Manmala yali Jisuskanyi, yanybangangi nyuli nanankanyi ngurrayngkanyi jibarrinyi. Ngala miku yaliyanyi ngajaka Jisus, “Wanyimba janurru nganyi.” Miku yaliyanyi ngajaka, “Wanyingkanyi ninji yanyba nangangi.” ");
INSERT INTO wrk_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Barriwa barlbayi jibarri. Yingijbayi yukururu baki jilajbayi nanganginkurri barndarri. Yanyba nyuli nanganginkanyi mungkijimukuyngka, ");
INSERT INTO wrk_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","“Barriwa ngambalaja. Najba janarri nanda, karu jali ngana bayankalijbanyi ngaki. Yiningki nayinda nanda jala manjijbayi Kudwanyi. Yiningki nyulu Krayis.” ");
INSERT INTO wrk_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Barriwa barlba yali barndananyi nayinkardi. Jilajba yali Jisusyurri. ");
INSERT INTO wrk_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Ngala yuwaji yanybayi jibarri nanganginkanyi mungkijimukuyngka, nanamanji yanyba yali kandimuku Jisuskanyi. Yanyba yali, “Jarrbakiyi nayinda mama jala nurru kuyu.” ");
INSERT INTO wrk_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Ngala yanybayi Jisus, “Yinini mama nayiba ngakindu. Miku narrimi jingkijba nayinda yinini mama.” Barriwa. ");
INSERT INTO wrk_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Ngala miku yaliyanyi jingkijba nangangi jangkurr kandimukunyi. Miku yaliyanyi jingkijba jangkurr, ‘Yinini nayinda mama.’ Yanyba yalungki, “Yiningki yingkawanyi wajbayi mamanyi jali ngambala jarijba.” ");
INSERT INTO wrk_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Yanybayi Jisus yalungi, “Manjijba ngani Kudwanyi yabimbiji yaji. Jala ngayu yabimba nayinda yaji Kudkanyi, baki ngayu maruka muwa. Jala ngayu jarrba mama baki ngayu maruka muwa. Nani barri ngayi yabimba nayinda yaji Kudkanyi, baki ngayu maruka muwa. ");
INSERT INTO wrk_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Nanda kingkirr jala jardijba janjawala, waluku walajbangka wuju, baki bayngkani baku, kujarra baki kujarra yakarl, nanda kingkirr yamiyudi, kunyunyu. Wudumba yalu yami baki wuyala yalu jarrkanyi. Barriwa. Najba narri nanda kingkirr, kudukudu mama kunyunyu wudumbikanyi. Nani barri marda narrimi karu yalunya kajamuku Kudkanyi wudumbikanyi yalunya Kudkanyi. Birrirrinja yalungka mankunkanyi jangkurranyi Kudkanyi, barrinani nanda yami birrirrinja nangka wudumbikanyi. ");
INSERT INTO wrk_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Jala nyulu waki mambukanyi, jala nyulu wudumba kingkirr yami, baki wajbangka dungalanyi mambukawanyi. Wajbangka yalunya dungalanyi, waki jala nanganginyina barrikina. Nani barri jala narri waki Kudkanyi, jala narri karu yalunya yingkamuku ngakinkanyi, baki yalu kuyu nganyi jangkurr. Jala narri waki Kudkanyi, miku narrinyiyi wajba dungalanyi, ngala janyulu wankamba narrinya yurrngumba Kudwanyi. Janarri jungku maruka muwa. ");
INSERT INTO wrk_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Nanda kingkirr, yingkawanyi yarrijbangka yami jambana. Jala jardijba walkurra ngala yingkawanyi wudumbaka yami. ");
INSERT INTO wrk_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Nani barri yingka nyuli waki Kudkanyi karuyi yalunya Kudkanyi, ngala narri, wudumba janarri yalunya. Miku narriya waki waluwa, ngala janarri wudumba yalunya Kudkanyi.” Barriwa yanybayi Jisus nani kandimukuyngka. ");
INSERT INTO wrk_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Karuyi jibarriwanyi nangangi mungkijimuku Jisuskanyi. Karuyi yalunya, jungku jali nanaba Samariya. Yanyba nyuli, “Nyuli karu ngana bayankalijbanyi ngaki. Bayankalijbanyi ngaki karuyi.” Barriwa. Kajamuku nangangi mungkiji, yali kuyu jangkurr nangangi Jisuskanyi. ");
INSERT INTO wrk_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Kaja yali jila Jisusyurri. Yali ngajaka Jisus jungunkanyi yalundu barndana. Baki jungku nyuli yalundu kujarrana kambana. ");
INSERT INTO wrk_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Kajamuku yali kuyu jangkurr Jisuskanyi, kajamuku. ");
INSERT INTO wrk_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Yanyba yali jibarrinyi, “Waluwa nurri kuyu nganyi jangkurr nangangi Jisuskanyi, ngala nanijba nurri manku nangangi jangkurr. Manku nurri nangangi jangkurr, baki jingkijba nurri, nyuli badajba marrimbikanyi ngamanya bukambiju mardarda, kuyu jala nangangi jangkurr.” Barriwa. ");
INSERT INTO wrk_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Barlbayi Jisus nanamunanyi yajinanyi Samariyananyi. Barlba nyuli kujarrana kambana bayngkani, baki jilajba nyuli langki. Langki nyuli jila yingkayurri yajiyurri, niji Kalili. ");
INSERT INTO wrk_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Yanybayi Jisus, “Yurlwa yalu nangangi, nanda jali manjijba Kudwanyi. Yurlwa yalu nangangi nananyina yajina, jardijba jali nyulu.” Barriwa. ");
INSERT INTO wrk_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Jila yali langki Jisus baki nangangimuku kandimuku. Wanbiya yali Kalili. Yalu jali jungku nanaba, kandimba yali Jisus. Wabula yali jilajba kularriji Jirusalimyurri wangarranyi niji ‘Kangandijbayi Barrawuna Yajinyi.’ Najba yali Jisus nanaba, baki najba yali nangangi yaji ngiruka. Najba yali nanda ngiruka yaji, yabimba jali nyulu nanaba Jirusalim. Barriwa. ");
INSERT INTO wrk_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Wijbayi Jisus Kayinayurri, nanankurri yajiyurri jali wabula nyulu yangkalamba nanda wabuda. Yangkalamba nyuli nanda wabuda ngarrkinyi. Nananyina yajina Kayina, nyuli yabimba nanda ngiruka yaji. Juju karriya nangandu, nanda barrawuyabarrawuya barrawuya, niji Kabirnayum. Jungkuyi mambuka nananyina yajina karru. Jandanyi nangangi lunjiyi kudanyu. ");
INSERT INTO wrk_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Karu yali nanda mambuka Jisuskanyi, nyulu jungkuka nanaba bayangarri Kayina. Jala nyuli jingkijba Jisus nanaba bayangarri, baki barlba nyuli bayungu Jisusyurri. Wanbiya nyuli baki ngajakayi Jisus, “Jilajba kuna janinji ngakinkurri jandanyiyurri. Lunji nyulu kudanyu. Yiningki janangka janyba. Jilajba kuna janinji nangandurri baki kunymamba janinji ngaki jandanyi.” Ngajaka nyuli Jisus kudanyu barri. ");
INSERT INTO wrk_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Jananganjayi Jisuswanyi, “Ninji. Miku ninjiyi kuyu ngaki jangkurr, jala muningka ngayu yanyba nganyi. Ngala jaliyi ninji najba ngiruka yaji ngaki, baki janinji kuyu ngaki jangkurr. Jaliyi miku ninji najba ngiruka yaji, baki miku ninjiyi kuyu ngaki jangkurr.” Nani jananganjayi Jisuswanyi. ");
INSERT INTO wrk_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Yanybayi nanda mambuka nangangi, “Mambuka. Barlba kuna janinji ngakindu karri, ngakinkurri jandanyiyurri, bakiyi nangka janyba.” ");
INSERT INTO wrk_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Yanybayi Jisus nangangi, “Wijba janinji karri, wankijbangangi nganyi jandanyi. Yuku barri janyulu kunybijba mili.” Kuyuyi nanda jangkurr Jisuskanyi mambukawanyi baki barlba nyuli. ");
INSERT INTO wrk_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Wijba nyuli karri, nanda mambuka. Munganawa barri, ngala nyuli jilijbawa, najba nyuli yalunya nanganginmuku wakiwarrmuku. Najbayi yalunya badaykurri karrina nangandurri. Karu yali mambuka, “Nanda juka nganyi wankijbayi. Kunybijba nyuli nganyi jandanyi.” Barriwa. ");
INSERT INTO wrk_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Baki ngajakayi yalunya mambukawanyi, “Wanyimbala kunybijbayi. Wanyimbala.” Jananganja yali, “Wulani mukunjana nyuli kunybijba. Waluwa nyuli jungku ngarrangarra mankanyi, ngala mukunjana mardumardujbayi nangangi mankanyi. Kunybijbayi.” Barriwa. ");
INSERT INTO wrk_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Nanangini mambukawanyi, jingkijba nyuli, duja nanda jangkurr Jisuskanyi. Wulani mukunjana yanybayi Jisus nangangi “Wankijbayi nganyi jandanyi.” Nanamanji mardumardujbayi nangangi mankanyi. Kunybijba nyuli mankanyi. Baki kuyu nyuli jangkurr Jisuskanyi nanangini mambukawanyi baki nanamukunyi, jungku jalili yalu nanganginyina barndana. Durrijba yali nanda jangkurr nangangi Jisuskanyi. ");
INSERT INTO wrk_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Kujarra yaji ngiruka yabimbayi Jisuswanyi. Waluku yangkalamba nyuli wabuda ngarrkinyi, bayngkani nyuli jila kula Jirusalimyurri nananyina yajina Judiya. Wijba nyuli langki Kaliliyurri. Nayimanji kunybijba nyuli juka. Kujarra yaji ngiruka yabimba nyuli nanaba Kalili. Barriwa. ");
INSERT INTO wrk_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Baku barri jilajbayi Jisus kula Jirusalimyurri. Jilajba nyuli yingkanyi wangarranyi Jukanyi. ");
INSERT INTO wrk_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Nanaba Jirusalim, barriki lukuluku nanaba barrawuyabarrawuyana. Marda murrku bardawa barrikina jilaykanyi danbiyurri. Yingamali bardawa niji nangangi, “Bardawa Jibkanyi.” Marda jiwirl nanaba, bundu nanda bardawa. Yabimba yali ngarndu jiwirlina. Kujarra baki kujarra yingamali ngarndu yali yabimba lukuluku jiwirlina. Nijarrijba yali nanda yaji Ju yanyi, “Bidsada.” ");
INSERT INTO wrk_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Kudukudu jali balkijba, jungku yalili ngarnduna kambana, kudukudu. Kudiya yali kabuji yami. Kudiya yali balki nukami marda nguli. Kudiya miku yaliyi jilajba nukamina, kuluka yali yurrngumba. Jungku yalili nanaba kambana, yukumba yali wabudanyi bulbulmbikanyi nyulu wabuda kudiyana. ");
INSERT INTO wrk_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Kudiyana jilajbayi Yanjil Kudkanyi kingkarrinya. Jilajbayi Yanjil nanankurri jiwirlyurri. Jidamba nyuli nanda wabuda, baki bulbulmbayi nanda wabuda. Yinarramba nanda lirrka jali ngankijba wabudana bayngkani, kunybijba nyuli mankanyi. Kunybijbayi nanda lirrka wabudana. ");
INSERT INTO wrk_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Jungku nyulili nanaba nganinyi. Yurrngumba nyuli jungku nanaba, kajana 38 kindilkurrinyina. Jungku nyuli yurrngumba, balkingangi nangangi mankanyi. ");
INSERT INTO wrk_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Jilajbayi Jisus jiwirlyurri. Najba nyuli nanda nganinyi. Jingkijba nyuli nanda jali balkijba mankanyi yurrngumba, baki ngajakayi nganinyi Jisuswanyi, “Nulijba kuna ninji kunybanyi mankanyi.” ");
INSERT INTO wrk_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Jananganjayi nganinyiwanyi, “Mambuka. Miku yingka nayiba ngakindu yarriykanyi ngana kalawuyngkurru wabudana. Jali bulbulmba nanda wabuda, yingka nyuli ngankijba wabudana waluwa ngaki. Miku ngayiyi jilajba dulu. Yingka nyuli ngankijba wabudana ngala ngayu jilijba walajba. Yurrngumba yingka ngaki ngankijbayi.” Barriwa. ");
INSERT INTO wrk_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Yanybayi Jisus nangangi, “Walajbakiyi. Wudumbakiyi nganyi jalyu, baki jilajbakiyi.” ");
INSERT INTO wrk_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Yinarramba nyuli walajba baki kunybijbayi mankanyi. Walajba nyuli, wudumbayi nangangi jalyu baki jilajbayi. Nanda kambana jali kunybijbayi nganinyi, nanda Sadidi. Kunymambayi nanda nganinyi Jisuswanyi Sadidi. ");
INSERT INTO wrk_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Najba yali nanda nganinyi mambukamukunyi jurjkanyi. Najba yali, baki karu yali nanda, “Jala Sadidi, baki yanybaka yuwa Jumukuyngka marda ngambalimi miku kuyu yaji Sadidi. Kuyu ninji nganyi jalyu. Nani ninji waki. Yanybaka yuwa, marda ninjimi miku waki Sadidi. Barimba ninji yaji. Jala Sadidi.” Barriwa. ");
INSERT INTO wrk_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Jananganja nyuli yalunya nanangini nganinyiwanyi, “Nanda jali ngana kunymamba, karu nyuli ngana, ‘Wudumbakiyi nganyi jalyu, baki jilajbakiyi.’” ");
INSERT INTO wrk_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Ngajaka yali, “Wanyi nanda. Wanyingi ninya kunymambayi. Wanyi nanda yanybayi nganyi. Wanyi nanda.” ");
INSERT INTO wrk_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Ngala miku nyuliya jingkijba nanda jali kunymamba. Miku nyuliya jingkijba Jisus. Kunymambayi nganinyi Jisuswanyi, baki yinarramba karrinjayi Jisus burrandi yalundu murana, karrinja jali yalu lukuluku nangandu. Barriwa. ");
INSERT INTO wrk_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Kamu barri wakarambayi nanda nganinyi Jisuswanyi. Wakaramba nyuli nganinyi walkurranyina jurjina. Yanybayi Jisus nangangi, “Kunybijba ninji mankanyi nanijba. Kunybijba. Jungkukiyi kunybana yuwana Kudkanyi. Wijbakiyi jungku balkina yuwana Kudkanyi, bakiyi ninji mili jungku, balkijba ninjiyi mili mankanyi. Balkimirra.” Barriwa. ");
INSERT INTO wrk_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Jilajbayi nanda nganinyi yalundurri mambukarri jurjkanyi. Karuyi yalunya Jisuskanyi, Jisuswanyi kunymambayi nangangi mankanyi. ");
INSERT INTO wrk_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Jali yalu jingkijba Jisus, nyuli kunymamba nanda nganinyi Sadidi, baki manku yali kiji nangangi. Kiji yali manku nangangi, wakingangi nyuli Sadidi. ");
INSERT INTO wrk_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Yanybayi Jisus yalungi, “Wanyingkanyi narri manku ngaki kiji. Wanyingkanyi. Yurrngumba nyulili waki ngaki Buwakanya, marda nanijba nyuluwa waki. Marda ngayu, marda ngayimi waki barrinani nyulu.” Barriwa. ");
INSERT INTO wrk_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Jali yalu manku nanda jangkurr Jisuskanyi, baki nulijba yali kurdanbikanyi Jisus. Nulijba yali kurdanbikanyi Jisus, wakingangi nyuli Sadidi, baki kuyungangi nyuli Kud nanganginkanyi Buwakaya, marda yarrijbangangi nangki walkurra mambuka barrinani Kud. ");
INSERT INTO wrk_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Mili yanybayi Jisus yalungi, “Yanyba ngayu duja jangkurr. Nanda Jandanyi Kudkanyi, miku nyulimi yabimba yaji nyuluma. Najba nyulili Buwakanya yabimbikurri yaji, baki yabimba nyulu nanamannga yaji, najba jala nyuli. Marda Buwakanya nangangi, marda Jandanyi nangangi, waki bula malumba. Nanda yaji, yabimba jala Buwakayu, nanamannga yaji yabimbaka Jandanyiwanyi. ");
INSERT INTO wrk_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Maruka nyulu muwa Buwakanya. Maruka nyulu muwa nanganginkanyi Jandayngkanyi. Minimbaka nangangi Jandanyi, yabimba jala nyulu nani Buwakayu. Minimbaka Jandanyi bukambijuyngka yajinyi. Minimbaka ngirukanyi yajinyi kajanyi. Ngala baku barri, janyulu minimba yingkanyi yajinyi kajanyi. Minimbaja Jandanyi mili ngirukanyi yajinyi. Manmala janarri kudanyu, jalija narri najba nanda, yabimba jalija Jandanyiwanyi. Jalija narri najba nanda yaji nangangi, manmala janarri kudanyu. ");
INSERT INTO wrk_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Kudwanyi, janyulu wankamba yalunya yurrngumba jalija yalungka janyba. Janyulu wankamba yalunya yurrngumba. Nani barri Jandanyiwanyi wankamba yalunya jala nyulu yarrijba yalunya. ");
INSERT INTO wrk_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Karuyi ngana Kudwanyi, ‘Karrinjarrijba janinji yalunya walu nganyindu. Karrinjarrijba janinji yalunya barrinani Kurdusnyina, baki yanyba janinji yalungi, wanyimuku janinji kuyu ngakindurri.’ Nani barri yanybayi ngaki Buwakanya ngaki. Miku janyulu karrinjarrijba yalunya Buwakayu, Miku. Ngana karuyi Buwakayu karrinjarriykanyi yalunya. ");
INSERT INTO wrk_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","Baki jingkijba jayalu nangangi Jandanyi, nyulu walkurra mambuka, barrinani nangangi Buwakanya. Ngala jaliyi yalu kalalajba nangangi Jandanyi, baki nanamannga yalu kalalajba nangangi, Buwakaya manjijba jali Jandanyi.” ");
INSERT INTO wrk_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","Mili yanybayi Jisus yalungi, mambukanyi jurjkanyi, “Karungka ngayu narrinya duja jangkurranyi. Nanda jala manku ngaki jangkurr, baki kuyu ngaki jangkurr, karu jalija ngayu narrinya Buwakaya, janyulu wanka jungku nangandu Buwakayu yurrngumba. Miku ngayiyi karrinjarrijba nanda waluwa ngakindu. Miku. ");
INSERT INTO wrk_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Nayinda ngaki jangkurr duja. Nanamuku jala miku jungku kunybana yuwana Kudkanyi, manku, jayalu ngaki jangkurr. Kudiyawanyi, jayalu manku jayalu kuyu ngaki jangkurr. Kuyu jayalu ngaki jangkurr, jingkijbangangi jayalu, ngayu Jandanyi Kudkanyi. Baki jayalu jungku Kudnyina yurrngumba. ");
INSERT INTO wrk_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Nanda Kud, nyuli jungku yurrngumba nanaba yajina, baki yuwajiwa jungkuka nanaba yajina nanganginyina. Mikuwali yingkawanyi wankamba Kud. Miku. Ngala miku nangkiyi nganinyi wankiykunumba. Miku. Ngawamba Kudwanyi wankiykunumba nganinyi. Marda karuyi ngana, nangangi Jandanyi, yuku ngayu wankiykunumba nganinyi. ");
INSERT INTO wrk_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Karuyi ngana Kudwanyi, jangayu karrinjarriykanyi yalunya, baki jangayu yanyba yalungi, manjiykanyi yalunya. Jangayu manjijba yalunya, Buwanyangangi ngayu Bukambijuyngka. ");
INSERT INTO wrk_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Mikujiyi manmala nanginkanyi jangkurranyi ngakinkanyi. Baku barri nanamuku nganinyiyurru baki jibarriyurru, jayalu manku ngaki jangkurr. ");
INSERT INTO wrk_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","Baki walajba jayalu. Walajba jayalu jambananyi jali yalunjalu makaba. Nanamuku jungku jali kunybana yuwana Kudkanyi, walajba jayalu nanankardi jambananyi, wankijbaja mili. Ngala nanamuku jungku jali balkina yuwana Kudkanyi, walajba jayalu marda, ngala miku jayalu wankijba mili Kudnyina. Miku. Jungku jayalu yingkana yajina. Jayalu jungku balkina yajina juju Kudnanyi. ");
INSERT INTO wrk_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Miku ngayimi waki ngayuma. Ngaki Buwakanya Kud, jungku nyulu ngakindu. Manku ngayu nangangi jangkurr, baki yabimba ngayu nanda jala nyulu yanyba ngaki. Karrinjarrijba ngayu yalunya walu ngakindu, baki yanyba ngayu yalungi. Yanyba ngayu yarriykanyi yalunya. Nanda jangkurr yarriykanyi, yanyba ngayu nanda jangkurr, karu jala ngana Kudwanyi. ");
INSERT INTO wrk_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Jaliyi ngayuma yanyba ngaki, baki yiningki miku narriyi kuyu ngaki jangkurr, baki yiningki mikuwali jangkurr ngaki duja. ");
INSERT INTO wrk_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Ngala Kudwanyi, nyulu karu ngaki. Jingkijba ngayu nangangi jangkurr duja. Nanda jangkurr nangangi ngaki, duja jangkurr. ");
INSERT INTO wrk_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Manjijba narri yingkamuku nangandurri Junyurri. Karu nyuli yalunya duja jangkurranyi ngaki. ");
INSERT INTO wrk_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Ngala miku ngayimi nulijba yingkanyi karunkanyi narrinya ngaki. Karu ngayu narrinya nanankanyi jangkurranyi Junkanyi. Miku narriyi mamanumba nanda jangkurr nangangi Junkanyi. Jaliyi narri durrijba nanda jangkurr, baki marrimba mardarda janyulu narrinya Kudwanyi. ");
INSERT INTO wrk_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Nanda Jun, nyuli barrinani mirnbi. Mungana minimba narrinya yubarlanyi nanangini mirnbiwanyi. Nani barri, Junwanyi minimbayi narrinya yuwanyi Kudkanyi. Ngawanji narri durrijba Jun mankunki nangangi jangkurr. Mirnarrijba narri muwa nanganginkanyi jangkurranyi. Mirnarrijba narri muwa ngawanji, ngala miku yurrngumba. Ngawamba nayinji narri mirnarrijba muwa nanganginkanyi jangkurranyi. ");
INSERT INTO wrk_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Nanangini Junwanyi, nyuli yabimba kaja kunyba yaji. Ngala nanda yaji kaja yabimba jala ngayu, nanda walkurra yaji, ngiruka. Yabimba ngayu nanda ngiruka yaji, manjijbangangi nyuli ngana ngakinyi Buwakayu. Manjijbayi ngana yabimbiji kaja ngiruka yaji. Jala narri najba nanda ngiruka yaji, marda narrimi jingkijba Kud, nyulu manjijbayi ngana. ");
INSERT INTO wrk_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Karu nyuli narrinya ngakinyi Buwakayu. Nanamukunyi wankalawanyi yali yarrijba nangangi jangkurr najana Kudkanyi, ngala miku narriyi manku Kud yanybikurri. Miku narriyi najba nangangi wali. ");
INSERT INTO wrk_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Ngala miku narrimi kuyu nangangi jangkurr jala yanyba ngaki. Miku narrimi kuyu nanda jangkurr nangangi, manjijba jali ngana Kudwanyi. Barriwa. ");
INSERT INTO wrk_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Najba narri nanda jangkurr najana Kudkanyi yurrngumba. Kudanyu narri najba nanda jangkurr, ngala miku narrimi jingkijba nanda jangkurr, karu jala ngaki. Ngamu janarri jungku wanka nangandu Kudnyina yurrngumba, najbangangi narri jangkurr Kudkanyi najana yurrngumba. ");
INSERT INTO wrk_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Ngala miku narriyi nulijba jilaykanyi ngakindurri. Yuku ngayu wankamba narrinya, ngala miku narriyi jilajba ngakindurri. Barriwa. ");
INSERT INTO wrk_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","Miku ngayiyi nulijba yalungi barrarrakiykanyi ngaki. Miku ngayiyi nulijba waykanyi ngana kunybanyi jangkurranyi. ");
INSERT INTO wrk_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Ngala ngayu jingkijba narrinya. Miku narrimi maruka muwa nangangi Kudkanyi. Miku. ");
INSERT INTO wrk_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Ngakinyi Buwakayu, nyuli manjijba ngana. Manjijba ngani yanybiji nangangi jangkurr, baki karunki narrinya nangangi Buwakaya. Ngala miku narrimi manku ngaki jangkurr karu jala narrinya nangangi. Miku. Miku narriyi kuyu nanda jangkurr. Ngala jaliyi yingka nganinyi jilajba narrindurri, jaliyi muningka jilajba narrindurri, janangka yanyba, baki kuyu janarri nangangi jangkurr. Nangangi jangkurr janarri kuyu, yanyba jalija nangka. Ngala miku narrimi kuyu Buwakaya jangkurr manjijba jali ngana Buwakuya karunki narrinya. ");
INSERT INTO wrk_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Narri nulijba yalungi barrarrakiykanyi narringi, ngala miku narringkiyi mankumanku Kudkanyi. Miku narriyi nulijba Kudkanyi barrarrakiykanyi narringi. Ngawamba nyulu duja Kud. Jala narri nani nulijba, baki yanka janarri kuyu nanda jangkurr Kudkanyi. Yanka janarri maruka muwa Kudkanyi kudanyu. ");
INSERT INTO wrk_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Miku ngayu karu nanda Buwakanya narringinkanyi balkinyi yajinyi, yabimba jala narri. Miku. Nanda wankalanyi Musis, kudanyu kuyu narri nangangi jangkurr, ngala nanangini jangkurrwanyi nanganginyi minimbaka Buwakanya narringinkanyi balkinyi yajinyi. ");
INSERT INTO wrk_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Yarrijba nyuli nanda jangkurr ngaki Musiswanyi. Yarrijba nyuli jangkurr ngaki, ngala miku narriyi kuyu nanda jangkurr nangangi. Miku. Ngala jalimi narri kuyu nangangi jangkurr, baki yuku narri kuyu ngaki jangkurr. ");
INSERT INTO wrk_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Baki yanka janarri kuyu ngaki jangkurr, jala miku narriyi kuyu nangangi jangkurr Musiskanyi.” Barriwa yanybayi Jisus yalungi mambukamukuyngka jurjkanyi. ");
INSERT INTO wrk_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","5","Baku barri jali winyurruwa janyulu wangarr niji ‘Kangandijbayi Barrawuna Yajinyi’ wangarr yalungi Jumukuyngka, nanamanji burrijbayi Jisus karri kanjana. Kujarra niji nanankanyi kanjanyi, Kalili, baki Dayibiriyas. Burrijba nyuli karrurrinybarri, ngala kudukudu yali jila bayunguna bayngkani nangandu. Juju bijal jila yali lukuluku nukamina, najbangangi yali Jisus yabimbikurri ngiruka yaji, jali nyulu kunymamba yalunya jali lunji. Najba yali nangangi ngiruka yaji, baki jilajba yali bayngkani nangandu. Kirrijbayi Jisus kingkarri kulawirana. Jungku nyuli nanaba marda kandimuku nangandu. Najbayi yaji Jisuswanyi. Najba nyuli kudukudu jilaykurri nangandurri. Yanybayi Jisus kandinyi niji Bilib. Ngajakayi Jisuswanyi, “Yanka jangambala wudumba mama dungalana nanginmukuyngka, baki jayalungka wardamba. Yanka jangambala wudumba mama.” ");
INSERT INTO wrk_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Jingkijbayi Jisuswanyi nanda jalija nyulu yabimba mama. Jingkijba nyuli. Ngala balanjayi Bilibkanyi. Nulijbayi Jisus jingkiykanyi Bilibkanyi, yanka janyulu wajba yalunya muran mamanyi Jisuswanyi. ");
INSERT INTO wrk_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Jananganjayi Bilibwanyi, “Jaliyi nurru wudumba mama 200 dungalana, ngawamba nurru wajba yalunya kardarda mamanyi. Ngala kudiya yalu munjijba mamanyi kujajarrangangi mama.” Barriwa. ");
INSERT INTO wrk_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Yingka kandi nanaba, niji Yandru, buwanganja nangangi Sayimin Bida. Yanybayi Yandru nangangi Jisuskanyi, ");
INSERT INTO wrk_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","“Juka nayiba jungkuka. Nayinda nangandu kujarra kaku, baki bayakarda damba kujajarra, kujarra, baki kujarra yingamali. Nayinda mama ngawamba kujajarra, ngala kajamuku yalu nayinda, walkurra muran.” Barriwa. ");
INSERT INTO wrk_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Yanybayi Jisus yalungi kandimukuyngka, “Jungkurrijbakiyi yalunya wayka.” Kaja karnba nanaba. Jungku yali karnbana walkurra muran, 5,000 barri. ");
INSERT INTO wrk_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Marrimbayi damba Jisuswanyi, yanyba nyuli mududu Kudkanyi mamanyi, baki nyuli wajba yalunya jali yalu jungku jambana. Kakunyi nani marda wajbayi. Jarrba yali baki wardijba yali junu. ");
INSERT INTO wrk_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Jali bukambijunyi yalu jarrba, baki karuyi kandimuku Jisuswanyi, “Wudumba narri nanda mama jali yalu miku jarrba. Wudumba narri mama baki kaku junu jali kili yandarra.” ");
INSERT INTO wrk_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Nyalimba yali kandimukunyi bukamba mama baki kaku jali yalu yingijba. Yarrijba yali bindawarrana, 12 bindawarra walbinyi. Waluwa nyuli 5 damba baki kujarra kaku, ngala nanda jali yalu yingijba murawanyi, nanda kudukudu mama. ");
INSERT INTO wrk_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Najba yali Jisus yabimbikurri nanda ngiruka yaji mamanyi. Jali yalu najba Jisus walkurrambikurri kaja mama, yanyba yali, “Nayinda nyulu jali manjijba Kudwanyi. Walajba nyuli jungunkanyi ngambalandu.” ");
INSERT INTO wrk_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Jingkijba yalunyi Jisuswanyi, jayalu yarrijba Jisus mambuka yalungi. Walkurra mambuka Kubaminkanyi jayalu yarrijba Jisus. Ngala Jisus miku nyuliya karijba yalungi, yalu yarriykanyi mambuka. Miku nyuliya karijba. Barlbayi Jisus nanarrinyaba. Barlbayi nyuluma dungalarri. Barriwa. ");
INSERT INTO wrk_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Kamu barri mungarri, jilajba yali kandimuku kanjarri. ");
INSERT INTO wrk_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Ngankijba yali muwardana, yalu jilaykanyi bayungu yajiyurri, niji Kabirnayum. Yingijba yali bijal. Wajanganja yali bayungu. Ngala nyuli mungijba yaji, jilajbayi Jisus. Jilajbayi yalundurri. ");
INSERT INTO wrk_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Karnungkumba yalunyi yunkurrwanyi barri. Bayunguna walajbayi lakululu. ");
INSERT INTO wrk_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Wajanganja yali juju 4 mils, baki najba yali Jisus jilaykurri nukamina yundu wabudana baki bunundujbayi Jisus muwardarri. Marrala yali nanamuku kandimuku. ");
INSERT INTO wrk_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Ngala yanybayi Jisus yalungi, “Nayinda ngayu. Mikujiyi narri marrala.” ");
INSERT INTO wrk_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Kudanyu yali maruka muwa baki kuyu yali Jisus muwardarri. Yinarramba yali wanbiya bayungu Kabirnayum. Barriwa. ");
INSERT INTO wrk_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Jawuda yali jungku dungalana nananyina yajina jali yalunya wajba mamanyi Jisuswanyi. Munganawa barri yali jala jungku dungalana, miku yaliya jingkijba wanjawa Jisus. Wulani yali najba ngawamba yingamali muwarda nanaba karriya. Yali najba kandimuku Jisuskanyi wajanganjankurri bayungu nananyina muwardana. Mikuyaji Jisuskanyi yalundu jali yalu jila muwardana. Wambu nyuli jungku dungalana. ");
INSERT INTO wrk_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Jawuda yali jila muwardana. Jila yali kulani Dayibiriyasnanyi. Wijba yali nanankurri yajiyurri jala wulani yalunyi wajba mamanyi Jisuswanyi, waluwa nyuli yanyba mududu Kudkanyi nanankanyi mamanyi. Wijba yali nanankurri yajiyurri. ");
INSERT INTO wrk_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Ngala miku yaliyanyi wakaramba Jisus nanaba, marda kandimuku nangangi. Miku yalunjaliya wakaramba. Baki mili yali ngankijba muwardana. Barlba yali bayungu Kabirnayumyurri kuykanyi Jisuskanyi. ");
INSERT INTO wrk_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Wakaramba yali Jisus bayangarrinybana. Yanyba yali nangangi, “Mambuka. Ninji milidimbawarr. Wanyimbala ninji jilajbayi nanginkurri.” ");
INSERT INTO wrk_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Yanybayi Jisus yalungi, “Ngayu karungka narrinya duja. Miku narriya kujba ngaki, yabimbangangi ngayu ngiruka yaji, ngala narri kujbayi ngaki, ngala mili narri nulijba mamanyi. ");
INSERT INTO wrk_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Mikujiyi kujba mamanyi jarrkanyi. Jaliyi narri dalburrijba mama, miku narriyi jarrba bukamba, bakiyi ngujbulijba. Yuku ngayu wajba narrinya yinini mamanyi. Jalija narri jarrba nanda yinini mama, janarri jungku yurrngumba Kudnyina. Ngayu Buwanya Bukambijuyngka. Yuku ngayu wajba narrinya nanankanyi yinini mamanyi, narri jungunkanyi wanka yurrngumba. Ngakinyi Buwakayu nyuli manjijba ngana waykanyi narrinya nanginkanyi yinini mamanyi.” Barriwa. ");
INSERT INTO wrk_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Baki yali ngajaka Jisus, “Wanyimba janurru. Wanyi yaji janurru yabimba Kudkanyi.” ");
INSERT INTO wrk_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Jananganjayi Jisuswanyi, “Nayinda janarri yabimba Kudkanyi. Janarri kuyu ngaki jangkurr Kudkanyi, manjijbangangi ngani Kudwanyi milidimbikanyi narrinya.” ");
INSERT INTO wrk_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Ngajaka yali Jisus, “Wanyi ngiruka yaji janinji yabimba nurrungi, baki ninya nurruja jingkijba, manjijbayi ninya Kudwanyi. Wanyi ngiruka yaji janinji yabimba.” ");
INSERT INTO wrk_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Mili yali yanyba Jisuskanyi, “Juju wabula nanamukunyi wankalamukunyi yali jarrba mama niji mana. Jarrba yali mama, jali yalunya wajba Kudwanyi, nanamanji jali yalu jungku mangkurruna, jali Musis nyuli yalungi mambuka. Yingkawanyi wankalawanyi yarrijba nyuli jangkurr najana Kudkanyi. Yarrijba nyuli nayinda, “Nyuli wajba yalunya mamanyi Kudwanyi, manjijba jali nyulu nanda mama kingkarrinya yalundurri. Nyuli wajba yalunya nanankanyi mamanyi kingkarrinya jarrkanyi.” Barriwa. ");
INSERT INTO wrk_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Baki yanybayi Jisus yalungi, “Ngayu karungka narrinya duja. Mikukiya Musiswanyi yalunya wajba mamanyi wankalana kingkarrinya. Miku nyuliya wajba yalunya mamanyi. Ngala ngakinyi Buwakayu, nyuli wajba yalunya nanankanyi mamanyi. Baki nani barri ngakinyi Buwakayu, nyulu wajbangka narrinya duja mamanyi kingkarrinya. ");
INSERT INTO wrk_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Nanda mama jala manjijbaka Kudwanyi narrindurri kingkarrinya, nanda mama wankambikanyi narrinya.” Barriwa. ");
INSERT INTO wrk_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Yanyba yali Jisuskanyi, “Mambuka. Wajbakiyi nurrunya nanginkanyi mamanyi yurrngumba. Wajbakiyi nurrunya mamanyi.” ");
INSERT INTO wrk_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Yanybayi Jisus yalungi, “Barrinani mamawanyi baki wabudawanyi wankamba mankanyi, nani ngayu wankamba narrinya yurrngumba. Ngayu barrinani mama narringinkanyi ngarndunyi. Ngayu barrinani wabuda narringinkanyi ngarndunyi. Nanda jala kuyu ngaki jangkurr, miku nyuliyi warinjijba mili, miku nyuliyi birrkalanyi mili. ");
INSERT INTO wrk_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Ngala ngayu karungka narrinya, najba nganarri, manku nganarri, ngala miku narriyi kuyu ngaki jangkurr. ");
INSERT INTO wrk_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Nanamuku nganinyimuku jala yalunya manjijba ngakindurri Buwakayu Kingkarri, jayalu jila ngakindurri. Jayalu jila ngakindurri, jala manjijba yalunya ngakindurri Buwakayu. Nanamuku jala yalu jila ngakindurri, miku ngayiyi manjijba yalunya ngakinbunanyi. Miku ngayiyi manjijba yalunya. Maruka ngayu muwa yalungi jalija yalu jila ngakindurri. ");
INSERT INTO wrk_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Badajba ngayi kingkarrinya. Badajba ngayi kingkarrinya, manjijbangangi ngani Buwakayu. Waki ngayu nangangi Buwakaya. Miku ngayiyi waki ngayuma. Waki ngayu nanda jala ngana karu Buwakayu. ");
INSERT INTO wrk_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Nanamuku, jala jila ngakindurri, jala kuyu ngaki jangkurr, jangayu marrimba yalunya mardarda. Miku ngayiyi mamanumba yalunya. Jangayu wankamba yalunya baku. Manjijba ngani Buwakayu, ngayu lalanbiji yalunya. ");
INSERT INTO wrk_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Ngaki Buwakanya nulijbangka yajinyi. Nulijba nyulu nayi. Nanda jala najba nangangi Jandanyi, baki kuyu nangangi jangkurr, janyulu wankijba mili yurrngumba. Jangayu wankamba baku. Nani nulijbangka ngaki Buwakanya.” Barriwa. Nani yanybayi Jisus yalungi. ");
INSERT INTO wrk_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Nanamuku Jumuku, jala yali manku Jisus yanybikurri, baki jurlwa yali nanganginkanyi jangkurranyi. Yanyba yalungki, “Nanda balki jangkurr jala Jisus yanyba, ‘Ngayu wankambikanyi yurrngumba, barrinani mama wankambikanyi mankanyi. Ngayu badajbayi kingkarrinya.’ Balki nanda jangkurr jala yanybayi Jisus.” Nani yalungki yanyba. ");
INSERT INTO wrk_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Miku yaliya kuyu nangangi jangkurr wankambikanyi yurrngumba. Miku yaliya kuyu nangangi jangkurr badaykanyi nyulu kingkarrinya. Yali yanyba, “Nayinda nganinyi nyulu Jisus. Nyulu jandanyi nangangi Jusibkanyi. Jingkijba ngambala baki nijanganjinyi baki yarrijinyi nangangi. Yanka nyuli yanyba jali nyulu badajba kingkarrinya.” Barriwa. ");
INSERT INTO wrk_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Yanybayi Jisus yalungi, “Mikujiyi jurlwa ngaki jangkurr nani. Nayinda duja ngaki jangkurr. ");
INSERT INTO wrk_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Jala nganinyi jilajba ngakindurri, jala nyulu kuyu ngaki jangkurr, miku nyuliyi jilajba ngakindurri nyuluman. Jilajba nyulu ngakindurri, ngawamba manjijbangangi nanda ngakindurri Buwakayu, baki jangayu wankamba baku. Buwakayu manjijba ngani kingkarrinya nanginkurri. Nyulu manjijba yalunya ngakindurri Buwakayu, yalu kuyunkanyi ngaki jangkurr. ");
INSERT INTO wrk_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Yarrijbayi jangkurr Kudkanyi najana wankalawanyi. Nayinda nyuli yarrijba, ‘Milidimba jayalunya Kudwanyi. Janyulu milidimba yalunya.’ Nanda jala manku jangkurr Kudkanyi, nanda jala jingkijba jangkurr Kudkanyi janyulu jilajba ngakindurri. ");
INSERT INTO wrk_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Miku yaliyi najba Buwakanya, ngala nanda jali manjijba Kudwanyi, ngawamba nyulu najbayi Buwakanya. Ngawamba nyulu najbayi. ");
INSERT INTO wrk_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Ngayu karungka narrinya duja. Nanda jala durrijba ngaki jangkurr, janyulu wankijba yurrngumba. ");
INSERT INTO wrk_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Ngayu barrinani mama wankambikanyi. Nanda jala durrijba ngaki jangkurr, janyulu wankijba yurrngumba. ");
INSERT INTO wrk_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Narringi wankalanyi mungkijimuku jungku yali mangkurruna. Kuyuyi yalunya Musiswanyi kulani Yijibnanyi, baki jungku yali mangkurruna. Nanaba yali jarrba nanda mama niji mana. Jarrba yali nanda mama, manjijba jali Kudwanyi yalundurri kingkarrinya. Jarrba yali nanda mama, baki janyba yalungki barri bukambiju. ");
INSERT INTO wrk_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Nanda mama jali badajba kingkarrinya, ngayu barrinani nanda mama. Nanda jala jarrba ngaki mama, baki miku nangkiyi janyba mili. Janyulu wankijba yurrngumba. ");
INSERT INTO wrk_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Ngayu wankamba narrinya yurrngumba. Ngayu barrinani nanda mama wankambikanyi narrinya yurrngumba. Ngayi badajba kingkarrinya. Nanda mama jala ngayu wajba narrinya wankambikanyi, nanda mama ngaki barnyi.” Barriwa. ");
INSERT INTO wrk_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Nanamuku Jumuku, mili yalungki yanyba. Yilikajba yalungki, “Mili yanka nangini nganinyiwanyi ngamanya wajba nanganginkanyi barnyinyi jarrkanyi. Mili yanka nayi. Yanka.” Barriwa. ");
INSERT INTO wrk_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Mili yanybayi Jisus yalungi, “Ngayu karungka narrinya duja. Jaliyi narri miku jarrba barnyi nangangi, Buwaya Bukambijuyngka, jaliyi narri miku ngaraba ngulya nangangi, baki narriyi miku wankijba yurrngumba. ");
INSERT INTO wrk_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Nanda jala jarrba ngaki barnyi, baki ngaraba ngaki ngulya, janyulu wankijba yurrngumba. Jangayu wankamba baku. ");
INSERT INTO wrk_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Ngaki barnyi barrinani mama jarrkanyi. Ngaki ngulya barrinani wabuda ngaraykanyi. ");
INSERT INTO wrk_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Nanda jala jarrba ngaki barnyi, baki ngaraba ngaki ngulya, janyulu jungku ngakindu kurduluna yurrngumba, baki jangayu jungku nangandu kurduluna yurrngumba. ");
INSERT INTO wrk_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Buwakanya Kingkarri, nyulu jungkuka wanka yurrngumba. Ngana nyuli manjijba kingkarrinya. Ngayu jungku wanka nayiba Buwakanyangangi. Nyulu wankamba ngani. Nani barri nanda jala ngana jarrba, janyulu jungku wanka yurrngumba ngakingangi. Ngayuja wankamba nanda. ");
INSERT INTO wrk_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Nayinda barri, nanda mama jali badajba kingkarrinya. Nanda mama miku barrinani nanda yingka mama nanda mana, jali wankalawanyi mungkijimukunyi yalu jarrba mangkurruna. Jarrba yali nanda mana, baki yuwaji janyba yalungki. Ngala nanda jala jarrba ngaki mama, janyulu wankijba yurrngumba.” ");
INSERT INTO wrk_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Yanybayi Jisus bukamba nayinda jangkurr jurjina. Milidimba nyuli yalunya jurjina, yaji niji Kabirnayum. ");
INSERT INTO wrk_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Kajamuku yali kandimuku Jisuskanyi. Jali yalu manku nayinda jangkurr Jisuskanyi, yalungki yanyba, “Miku nayinda kunyba jangkurr nangangi. Nayinda jardibirri jangkurr. Miku ngambaliyi kuyu nayinda jangkurr nangangi.” Barriwa. ");
INSERT INTO wrk_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Ngala jingkijbayi yaji Jisuswanyi. Miku nyuliyanyi manku yalungi jangkurr, ngala muningka nyuli jingkijba nanda jangkurr, jali yalu yanyba, miku kuyunkanyi nangangi jangkurr. Yanybayi Jisus yalungi, “Ngamu ngayu yanyba balki jangkurr narringi. ");
INSERT INTO wrk_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Ngala jaliyi narri najba Buwanya Bukambijuyngka kirriykurri kingkarri, jaliyi narri najba kirriykurri nanankurri, nanda jali waluwa badajba kingkarrinya, jaliyi narri najba Buwanya Bukambijuyngka kirriykurri nanankurri, baki yiningki janarri kuyu ngaki jangkurr. ");
INSERT INTO wrk_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Miku nangkiyi nganinyi wankamba mankanyi yurrngumba. Miku. Ngawamba Ngarnduwanyi Kudkanyi, yuku nyulu wankamba nganinyi. Nayinda jangkurr jala ngayi karu narrinya, jalija narri kuyu nayinda jangkurr, janarri jungku wanka yurrngumba. Marda jungkuja Ngarndu Kudkanyi narrindu yurrngumba. ");
INSERT INTO wrk_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Jawuda narri, yuwaji narrimi miku kuyu ngaki jangkurr.” Barriwa. Wabula wankalana jingkijbayi bukamba yaji Jisuswanyi. Jingkijba nyuli yalunya jali yalu miku kuyu nangangi jangkurr. Jingkijba nyuli yalunya, waluwa nyuli yanyba. Jingkijbayi yalunya jala yalu miku kuyu nangangi jangkurr. Nanda barrinani nyuli jingkijba nanda nganinyi jali waluku nyuli kandi Jisuskanyi, ngala baku yangkalamba nangki Jisusnanyi. Nanangini nganinyiwanyi jali nangka yangkalamba Jisusnanyi, karu nyuli mambuka jurjkanyi nangangi Jisuskanyi, baki wakaramba yali Jisus kurdanbikanyi. Jingkijbayi nanda nganinyi jali yangkalamba nangka Jisusnanyi. Jingkijba nyuli bukamba yaji. ");
INSERT INTO wrk_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Mili yanybayi Jisus, “Ngayu karu narrinya. Ngawamba nanamuku jala manjijba Buwakayu ngakindurri, ngawamba yalu badajba ngakindurri. Jayalu badajba ngakindurri, manjijbangangi yalunya ngakindurri Buwakayu. Ngawamba jayalu kuyu ngaki jangkurr.” ");
INSERT INTO wrk_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Yanybayi Jisus nayinda jangkurr waluwa. Bayngkani jawuda nanganginmuku kandimuku, yingijba yali Jisus. Miku yaliyi mili kandi nangangi. Miku yaliya kuyu nangangi jangkurr barnyinyi, baki ngulyanyi, baki wankiykanyi mili. Miku yaliya mili kuyu nangangi jangkurr. Miku yaliyi mili kandi nangangi. ");
INSERT INTO wrk_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Ngajakayi Jisuswanyi nanganginmuku kandimuku, jali yalu yuwaji nangandu, 12 barri. Ngajaka nyuli yalunya, “Marda janganarri yingijba kuna.” ");
INSERT INTO wrk_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Jananganjayi yalkunyiwanyi kandiwanyi, niji Sayimin Bida. Jananganjayi, “Mambuka, wanjakurri nurruja jila. Ninji yanybayi nanda kunyba jangkurr wankiykanyi yurrngumba. ");
INSERT INTO wrk_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Nurru kuyu nganyi jangkurr. Jingkijba ninya nurru, ninji nanda kudukudu nganinyi jala manjijbayi Kudwanyi.” Barriwa. ");
INSERT INTO wrk_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Yanybayi Jisus yalungi, “Ngayu yarrijba narrinya ngakinmuku kandimuku. Ngayu yarrijba narrinya, kajamuku 12 ngakinmuku kandimuku. Janarri jilalajba ngakindu yurrngumba. Ngala warriyaluku, yingamali nanda narrindu wuwarryudi.” Nani yanybayi Jisus yalungi. ");
INSERT INTO wrk_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Nanda jali wuwarryudi, nyuli Judas, nijanganjinyi nangangi Sayimin Yiskariud. Jingkijbayi Judas Jisuswanyi, janangka yangkalamba Jisusnanyi. Janyulu karu mambuka jurjkanyi nangangi Jisuskanyi baki jayalu wakaramba Jisus kurdanbikanyi. Barriwa barri. ");
INSERT INTO wrk_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Baku barri jilajbayi Jisus nananyina yajina niji Kalili. Miku nyuliyala jilalajba yingkana kulaya yajina Judiya. Yaliyanyi kurdanba Jisus mambukamukunyi Jukanyi nanaba Judiya. Yaliyanyi kurdanba Jisus, baki jilalajba nyuli langkiya Kalili. ");
INSERT INTO wrk_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Nanamanji winyurruwa janyulu wangarr yalungi, nijarrijba jalili yalu “Wangarr Jurjkanyi.” ");
INSERT INTO wrk_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Kanyiyamuku nangangi Jisuskanyi, yanyba yali nangangi, “Marda ninjimi barlba nanginbunanyi yajinanyi. Marda ninjimi barlba kula Judiyayurri, baki kandimukunyi nganyinmukunyi, jayalu najba kunyba yaji nganyi. Jayalu najba nanda jala ninji yabimba. ");
INSERT INTO wrk_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Jaliyi nganyingka mankumanku ninji walkurra mambuka, baki marda ninjimi miku waki kardarda. Marda ninjimi waki nanayina yajina jalija ninyalu najba kajamukunyi. Marda ninyalimi najba yabimbikurri nanda walkurra yaji. Barriwa.” ");
INSERT INTO wrk_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Nani yanybayi kanyiyamuku nangangi Jisuskanyi, ngala miku yaliya kuyu nangangi jangkurr. ");
INSERT INTO wrk_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Yanybayi Jisus yalungi, “Jilijba jangayu jilajba wangarranyi Jirusalimyurri. Jilijba. Jaliyi narri nulijba jilaykanyi nanankanyi wangarranyi, baki yuku narri jila. Ngala miku ngayiyi jilajba nanijba. ");
INSERT INTO wrk_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","8","Miku yaliyi ngirra narrinya. Miku narrinjaliyi linjumba mankanyi. Ngala nganjalu ngirra, karungangi ngayi yalunya, yalu jungku balkina yuwana. Nani nganjalu ngirra. Yanyba ngayu yalungi nayinda yurlurr jangkurr, baki nulijba yalu ngaki, linjumbikanyi nganjalu. Miku ngayiyi ngayu jilajba wangarranyi, ngala yuku narri jilajba. Barriwa.” ");
INSERT INTO wrk_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Nani yanybayi Jisus, baki wambu nyuli jungku nanaba Kalili. Barriwa. ");
INSERT INTO wrk_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Barlba yali kula kanyiyamuku nanganginmuku Jisuskanyi. Barlba yali kula Jirusalimyurri. Baku barri barlbayi Jisus yalundu bayngkani. Ngala miku nangkiya minimba yingkamukuyngka. Miku yaliya jingkijba nyuli wanbiya. ");
INSERT INTO wrk_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Nanamuku mambukamuku Jukanyi, bayiwujba yali Jisuskanyi wangarrina. Ngajaka yali, “Wanjawa nanda Jisus. Wanjawa nyulu.” Ngala miku yaliyanyi wakaramba Jisus. ");
INSERT INTO wrk_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","13","Kajamuku yalungki yanyba nangangi Jisuskanyi. Yanyba yalungki kardarda nangangi, marralangangi yali mambukamukuyngka Jukanyi. Jingkijba yali nanamuku mambukamuku Jukanyi nulijba yali nangangi linjumbikanyi Jisus. Baki yanyba yalungki kardarda nangangi. Yingkamuku yalungki yanyba, “Nanda, nyulu kunyba nganinyi. Kunyba nyulu nanda nganinyi.” Ngala yingkamuku yalungki yanyba, “Miku nyulimi nanda kunyba nganinyi. Jujambaka nanangi ngamanya. Jujambaka. Jungkuka balki.” Nani kardarda yalungki yanyba yingka jangkurr baki yingka jangkurr. Miku yalungki yanyba kudanyu, ngala kardarda ngawamba. Barriwa. ");
INSERT INTO wrk_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Jilajbayi Jisus walkurrayngkurri jurjyurri. Nanda wangarr nyuli barndaykana wik. Burrandimbijina wiknyina jilajbayi Jisus jurjyurri. Ngankijba nyuli kalawuyngkurru jurjina, baki milidimbayi yalunya. Milidimbayi yalunya nanaba jurjina. ");
INSERT INTO wrk_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Mambukamuku jurjkanyi, manmala yali nanganginkanyi jangkurranyi. Manmala yali baki yanyba yalungki, “Nyulu nayinda jingkijbawarr, ngala miku nyuliya jungku skulina. Yanka nyuli jingkijba yaji kudanyu. Yanka.” ");
INSERT INTO wrk_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Manku nyuli nanda jangkurr yalungi Jisuswanyi. Jananganja nyuli yalunya, “Karu nyuli ngana yajinyi nanangini, manjijba jali ngana. Ngana karuyi yajinyi, baki milidimba ngayu yalunya nanankanyi yajinyi. Nyuli manjijba ngana milidimbiji yalunya, baki milidimba ngayi nanganginkanyi jangkurranyi. ");
INSERT INTO wrk_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Jaliyi nyulu nulijba ngayangayiykanyi Kudkanyi, baki janyulu jingkijba. Jingkijba janyulu nanda jala ngayu maramaramba yalunya. Jingkijba janyulu miku ngayiyi maramaramba ngakinkanyi jangkurranyi. Miku. Maramaramba ngayu ngawamba nanankanyi jangkurranyi Kudkanyi. Maramaramba ngayu nanankanyi jala nyuli karu ngana maramarambikanyi Kudwanyi. Nani barri janyulu jingkijba ngana. ");
INSERT INTO wrk_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Nanda nganinyi, nangkama jala yanyba jangkurr, nulijba nyuli yalungi yingkamukuyngka, yalu barrarrakiykanyi nanda. Nyuli nulijba yalungi ngayangayiykanyi nangangi, barrarrakiykanyi, nanda jala nangkaman yanyba. Ngala nanda jalimi miku nangkama yanyba jangkurr, ngala yanyba nyulu jangkurr nangangi manjijba jali nanda, miku nyulimi nulijba yalungi, yalu barrarrakiykanyi nanda. Miku. Ngala nulijba nyuli yalungi barrarrakiykanyi nanda yingka, jali manjijba yalundurri. Nanda jala nulijba yalungi nani nanankanyi yingkanyi, nanda yurlurr jala jungku. ");
INSERT INTO wrk_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Nanangini wankalawanyi Musiswanyi, wajba nyuli narrinya nanankanyi yuwanyi. Ngala miku narriyi ngayangayijba nanankanyi yuwanyi. Miku narriyi jungku kunybana yuwana Musiskanyi. Wanyingkanyi narri nulijba ngaki, kurdanbikanyi nganarri. Wanyingkanyi. Miku narrimi nani jungku kunybana yuwana Musiskanyi, nulijba jala narri kurdanbikanyi nganarri.” Nani yanybayi Jisus yalungi. ");
INSERT INTO wrk_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Ngala yanyba yali nangangi, “Ninji mudu, wuwarrngangi nganyindu jungkuka mankanyina. Miku nurrimi nulijba nganyi kurdanbikanyi ninya. Miku. Mudu ninji. Mudu.” Barriwa. ");
INSERT INTO wrk_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Jananganjayi Jisuswanyi, “Yabimba ngayi ngiruka yaji nganiyngkanyi, baki manmala narri. Kudanyu narri manmala jali ngayu kunymamba nanda nganinyi balkiyudi mankanyiyudi. Kunymamba ngayi nanda nganinyi Sadidi. Ngala yanyba narri ngaki, ngayi waki, jali ngayu kunymamba nanda Sadidi. Yanyba narri, ngayi jungku balkina yuwana. ");
INSERT INTO wrk_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","23","Nanangini Musiswanyi, jirrinyba nyuli narrinya, narri kaburrmbikanyi bardarda juka. Jalili jungku bardarda yingamali wik, baki munganawa narrili kaburrmba nanda bardarda. Karlba narri bardarda mankanyi nananyina kambana. Ngayangayijba narri nanankanyi yuwanyi, jali yarrijba najana Musiswanyi. Marda nanamuku wankalamuku jungku yali barrabarruji. Jungku yali waluwa Musiskanyi ngala nyuli jilijba. Marda yalili kaburrmba bardarda. Barriwa. Yabimba narri nanda yuwa Musiskanyi. Kaburrmba narri bardarda. Kaburrmba narri bardarda, marda Sadidi. Nani narri waki Sadidi, baki jungku narri balkina nananyina yuwana, miku wakinkanyi Sadidi. Nani ngayi waki marda Sadidi, jali ngayu kunymamba nanda nganinyi mankanyi Sadidi. Wanyingkanyi narri jungku ngarrangarra muwa ngaki. Wanyingkanyi. Marda narringkimi mankumanku kudanyu waluku. ");
INSERT INTO wrk_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Mikujiyi manku kiji wakun. Mikujiyi yanyba, ngayu yabimba balki yaji. Waluku narringki mankumanku kudanyu, baki janarri jingkijba yaji.” Barriwa. ");
INSERT INTO wrk_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Nanamuku jungku jalili yalu Jirusalim, yingkamuku yalungki yanyba, “Nayinda Jisus, nyulu nanda jala yalu nulijba kurdanbikanyi nangangi. ");
INSERT INTO wrk_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Ngala yanybaka nyulu kudanyu nanginkanyi muranyi nayiba jurjina. Kudanyu nyulu yanybaka yalungi, miku kardarda. Miku nangkiyi ngadijba yalungi mambukamukuyngka. Miku nangkiyi ngadijba yalungi. Ngala miku yalimi manku kiji nangangi mambukamukunyi. Yiningki marda yalu jingkijbangka nangangi, nyulu Krayis. ");
INSERT INTO wrk_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Ngala nanda jangkurr yanybaka najana Kudkanyi. Yanybaka nanda jangkurr nangangi Krayiskanyi. Miku yaliyi jingkijba nangangi yaji Krayiskanyi. Miku yaliyi jingkijba nanda yaji nangangi. Ngala nayinda nganinyi Jisus, jingkijba ngambala nangangi yaji. Nangangi yaji Kalili. Jingkijba ngambala nangangi yaji Jisuskanyi, ngala nanda Krayis, miku ngambaliyi jingkijba nangangi yaji.” Barriwa. Nani yalungki yanyba nangangi Jisuskanyi. ");
INSERT INTO wrk_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Mili yalunyi Jisuswanyi milidimba walkurranyina jurjina. Yanyba nyuli kudanyu. “Yi. Nganarri jingkijba. Marda narri jingkijba nanda yaji ngaki langku. Ngala miku ngayiyi badajba narringi ngayuma. Miku. Nanda jali ngana manjijba, nyulu jilalajbangka ngakindu yurrngumba. Ngala miku narrimi jingkijba nanda. Miku narrimi jingkijba Kud. Ngamu narrimi jingkijba Kud, ngala miku. ");
INSERT INTO wrk_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Ngala ngayu, jingkijba ngayu nanda Kud, jungkungangi ngayu nangandu yurrngumba. Ngana nyuli manjijba milidimbiji narrinya. Barriwa.” Nani nyuli milidimba yalunya. ");
INSERT INTO wrk_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Jali yalu manku nangangi jangkurr, baki kudiyamukunyi mambukamukunyi, yaliyanyi wudumba Jisus yarriykanyi brisinyina, ngala miku. Miku yaliyi wudumba Jisus. Jilijba jayalu wudumba, nulijbangangi Kud nangangi Jisuskanyi, nyulu wakinkanyi mili. Miku yaliya wudumba Jisus nanamanji. Jilijbawa. Mili janyulu waki Kudkanyi. ");
INSERT INTO wrk_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Ngala kajamukunyi, jali yalu manku nangangi jangkurr, baki kuyu yali nanda jangkurr nangangi. Yanyba yalungki, “Nani nanda duja. Nyulu Krayis. Yabimba nyulu kaja ngiruka yaji. Mikuyaji nganiyngkanyi yabimba nanda yaji ngiruka. Miku. Mikuwali yingkawanyi yabimba nanda ngiruka yaji. Ngawamba nyulu.” Barriwa. ");
INSERT INTO wrk_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Kudukudumuku yalungki yanyba kardarda Jisuskanyi. Kardarda yalungki yanyba nangangi. Nanamukunyi Barasimukunyi, manku yali nanda kardarda jangkurr. Manku yali nanda jangkurr, baki manjijba yali yilarrmuku wudumbiji Jisus. Manjijba yalunjali Barasimukunyi marda mambukamukunyi jurjkanyi wudumbiji Jisus. ");
INSERT INTO wrk_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Jali yalu wanbiya nanganda Jisusnyina, nanamuku yilarrmuku, baki yanybayi Jisus yalungi, “Marndakaja jangayu jungku nayiba narrindu. Baku barri jangayu wijba nangandurri, jala ngana manjijba narrindurri. Wijba jangayu nangandurri. ");
INSERT INTO wrk_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Bayiwujba janarri ngaki, jungkungangi jangayu yingkana yajina. Miku narriyi jilajba nanankurri yajiyurri. Barriwa.” ");
INSERT INTO wrk_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Nanamukunyi mambukamukunyi, yali manku nanda jangkurr Jisuskanyi. Manku yali, baki yanyba yalungki, “Wanjakurri yajiyurri janyulu barlba, baki bayiwujba jangambala nangangi. Wanjawa janyulu yajina jungku. Barlba kuna janyulu bayangarriji, nanankurri yingkayurri yajiyurri niji Kris. Kajamuku Jumuku jungku yalili nanaba. Yiningki janyulu barlba yalundurri milidimbiji yalunya, jungku jalili yalu nananyina yajina. Milidimba kuna janyulu yalunya. Barriwa.” ");
INSERT INTO wrk_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Yanybayi Jisus ngambalangi, ‘Bayiwujba janarri ngaki,’ baki mili nyuli yanyba, “Miku narriyi jilajba nanankurri yajiyurri jalija ngayu jungku.’ Miku ngambalimi jingkijba nanda jangkurr nangangi. Miku ngambalimi jingkijba.” Nani yalungki yanyba jangkurranyi Jisuskanyi. Barriwa. ");
INSERT INTO wrk_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Jungku yalili nanaba wangarranyi, 8 kambana, baki barndaykana kambana karrinjayi Jisus kalawunyi jurjina. Karrinjayi Jisus, baki yanyba nyuli kudanyu yalungi, “Jala narri warinjijba, baki marda narrimi badajba ngakindurri ngaraji wabuda. ");
INSERT INTO wrk_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Yanybaka nanda naja Kudkanyi nayinda jangkurr, ‘Nanda jala durrijba ngaki jangkurr, jala ngayangayijba ngaki, janyulu maruka muwa bukambijuyngka. Janyulu maruka muwa yalungi, barrinani ngayu marukangka muwa yalungi bukambijuyngka. Janyulu minimba yalunya jungunkanyi kunybana yuwana Kudkanyi. Nani janyulu wanka jungku yurrngumba nangandu Kudnyina. Nanda wabuda dudibangka bundalina, baki jardijbangka kurnda baki karnba ngiruka bijalina wabudana. Nani janyulu jardijba ngiruka Kudkanyi. Janyulu karu yingkamuku nangangi Kudkanyi. Janyulu maruka muwa yalungi. Janyulu maruka muwa yalungi mili kudanyu baki mili kudanyu yurrngumba barri. Barriwa.” ");
INSERT INTO wrk_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Nani yanybayi Jisus. Muningka nyuli karu yalunya wabudanyi, ngala yanyba nyuli nanda jangkurr Kunybanyi Ngarndunyi Kudkanyi. Janyulu manjijba nanda Kunyba Ngarndu Kudwanyi. Janyulu manjijba Kunyba Ngarndu yalundurri jalija yalu durrijba nangangi jangkurr Jisuskanyi. Ngala jilijbawa nyuli manjijba Kunyba Ngarndu. Waluku janangka janyba, janyulu mili wankijba, baki janyulu kirrijba kingkarri nangandurri Kudyurri. Bayngkani janyulu manjijba Kunyba Ngarndu Kudwanyi. Nani milidimbayi yalunya Jisuswanyi. ");
INSERT INTO wrk_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Kajamukunyi yali manku jangkurr nangangi Jisuskanyi. Yingkamuku yalungki yanyba, “Nanda nganinyi, nyulu nanda jali manjijba Kudwanyi, yanybiji nangangi jangkurr. Nyulu nanda jali manjijba Kudwanyi.” ");
INSERT INTO wrk_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Ngala yingkamuku yalungki yanyba, “Nyulu nanda, nyulu Krayis.” Ngala yingkamuku yalungki yanyba, “Miku nyulu nanda Krayis. Jingkijba nurru Krayis, miku nyuliyi jardijba nanaba langkiya, nananyina yajina Kalili, jali nayinda nganinyi Jisus jardijba. Miku. Ngala janyulu jardijba kulaya. ");
INSERT INTO wrk_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Nanda naja Kudkanyi yanybaka nayi, ‘Nanda wankala Dayibid, jungku nyulili nananyina yajina niji Bidliyim. Nyuli barrinani kamambarra buwakanya nangangi Krayiskanyi. Nanda yaji Bidliyim nanda nangangi yaji Dayibidkanyi. Nanda nangangi yaji marda Krayiskanyi. Mikuwali Krayis jardijba langkiya, ngala janyulu jardijba kulaya.’” Nani yalungki yanyba yinini yinini jangkurr nangangi Jisuskanyi. ");
INSERT INTO wrk_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Baki yingkamuku kurranja yalungki marda, baki kuyungangi yali nanda jangkurr Jisuskanyi. Ngala yingkamuku yanyba yalungki Jisuskanyi, miku nyuli nanda Krayis. Marda kurranja yalungki marda. ");
INSERT INTO wrk_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Ngala yingkamuku yali nulijba yalungi yilarrmukuyngka, yalu wudumbikanyi Jisus. Ngala miku yaliya marrimba Jisus yilarrmukunyi. ");
INSERT INTO wrk_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Wijba yali yilarrmuku jurjyurri. Ngajaka yalunjali mambukamukunyi marda Barasimukunyi. Ngajaka yali yilarrmuku, “Wanyinganyi narriyi miku wudumba nanda Jisus. Wanyinganyi narriyi miku kuyu nurrundurri.” ");
INSERT INTO wrk_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Jananganja yali, “Mikuwali yingka yanyba nanda jangkurr barrinani Jisus. Yanyba nyuli ngiruka jangkurr.” ");
INSERT INTO wrk_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Ngajaka yalunjali Barasimukunyi, “Jujambayi kuna narriya marda nanangini Jisuswanyi. ");
INSERT INTO wrk_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Jingkijba kuna narri marda, miku yaliyi kuyu nangangi jangkurr marda mambukamukunyi marda Barasimukunyi. Miku yaliyi kuyu nangangi jangkurr. ");
INSERT INTO wrk_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Ngala nanangini murawanyi, mudumbanyi yalu jungku. Miku yalimi jingkijba nanda yuwa Musiskanyi. Janyulu yabimba balki yaji yalungi Kudwanyi, mikungangi yalu kuyu nangangi jangkurr Jisuskanyi.” Nani yali ngirrwa yalungi yilarrmukuyngka. ");
INSERT INTO wrk_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Nanda mambuka niji Nikidimus, jungku nyuli nanaba yalundu Barasimukunyina. Nyuli nanda malbu jali jilajba waluwa nangandurri Jisusyurri. Jilajba nyuli kardarda nangandurri mungana yanybikanyi Jisuskanyi. Yanybayi nanda mambuka yalungi nayi, ");
INSERT INTO wrk_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","“Yanybaka ngambalangi yuwa, waluwa jangambala karrinjarrijba nganinyi. Jangambala karrinjarrijba nganinyi waluwa Kurdusnyina. Waluku jangambala manku nangangi jangkurr, baki yanyba jangambalaka nanankanyi, wanyimba jangambala nangangi. Waluwa marda ngambalimi jingkijba nanda yaji, yabimba jali nyulu yaji. Nani yanybaka nanda yuwa Musiskanyi. Marda ngambalimi waluku karrinjarrijba nanda Jisus ngamandu, yanybikanyi nangangi.” Barriwa. ");
INSERT INTO wrk_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Jananganja yali nanda Nikidimus, “Nanda yaji Kalili, marda kuna nganyi yaji. Nanda Jisus, nangangi yaji Kalili. Yiningki ninji kandi nangangi. Ningkijba janinji naja nangangi Kudkanyi, baki jingkijba janinji nayi. Mikuyaji yalungi jali yalu jardijba Kalili, miku yalungkiya yanyba jangkurr Kudkanyi.” ");
INSERT INTO wrk_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Baki barriwa yalungki yanyba. Bukamba yalungki yanyba, baki wijba yali yalunginkurri barndarri. ");
INSERT INTO wrk_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Ngala Jisus, kirrijba nyuli kingkarri kulawirarri, yaji niji ‘Yulib.’ Barriwa. ");
INSERT INTO wrk_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Munganawa nyuli wijba walkurrayngkurri jurjyurri. Ngankijba nyuli kalawunyi jurjina. Kaja muran jungku yali lukuluku nangandu. Jungkuyi Jisus, baki milidimbayi yalunya. ");
INSERT INTO wrk_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Nanamuku, milidimba jalili yalu yalungi yuwa jurjina, marda nanamuku Barasimuku, ngankijba yali jurjina. Kuyu yali jibarri yalundu kalawuyngkurru. Wakaramba yali nanda jibarri kulukankurri yingkana nganinyina, ngala nyuli mikuyaji nanganginkanyi nawinganjanyi. Kuyu yali nanda jibarri Jisusyurri, baki karrinjarrijba yali waluwa yalundu murana. ");
INSERT INTO wrk_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Baki yanyba yali Jisuskanyi, “Milidimbawarr. Wakaramba nurri nayinda jibarri. Kuluka nyuli yingkana nganinyina, miku nanganginyina nawinganjana. ");
INSERT INTO wrk_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Nanda yuwa Musiskanyi yanybaka nayi, ‘Jaliyi jibarri kuluka nyulu yingkana nganinyina, miku nanganginyina nawinganjana, baki marda ngambalimi kurdanba. Marda ngambalimi janyba dungala nangandurri, baki janangka janyba.’ Nani barri yanybaka nanda yuwa Musiskanyi. Ngala yanka ninji yanybaja nangangi.” Barriwa. ");
INSERT INTO wrk_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Yanyba yali nanda jangkurr nangangi Jisuskanyi. Nani yali ngajaka Jisus, nulijbangangi yali jujambikanyi Jisus. Nulijba yali Jisuskanyi nyulu yanybikanyi, nanda yuwa Musiskanyi, nanda balki jangkurr. Jaliyi nyulu yanyba nanankanyi yuwanyi Musiskanyi, nanda balki jangkurr, baki jayalu manku kiji nangangi. Ngala miku nyuliyanyi jananganja yalunya wakun. Ngala wududu nyuli wayka, baki ngirrikimbayi jamba marniyudinyi. ");
INSERT INTO wrk_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Ngala nyuli ngirrikimba jamba, baki yali karrinja nangandu, ngala yali ngajakawa nanankanyi jangkurranyi. Baki walajbayi Jisus waykalinya, baki karrinjarrijba nangki, baki yanybayi yalungi, “Nanda jalili jungku kunybana yuwana yurrngumba, miku nyuliya barimba yingamali yuwa, marda nyuluwarri janybaja dungala nangandurri jibarriyurri. Nyuluwarri janybaja dungala jibarriyurri, jala jungku kunybana yuwana yurrngumba. Barriwa.” ");
INSERT INTO wrk_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Baki mili nyuli wududu wayka. Mili ngirrikimbayi jamba. ");
INSERT INTO wrk_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Jali yalu manku nanda jangkurr nangangi, baki mankumanku yalungki kudanyu, baki barriwa barlba yali. Waluwa barlbayi malbumalbu, baki bayngkani yingkamuku, bayngkani yingkamuku. Bukamba yali barlba. Ngawamba bulaman nanaba, Jisus baki nanda jibarri. ");
INSERT INTO wrk_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Mili najbayi jibarri Jisuswanyi waykalinya, baki yanybayi nanankanyi jibarrinyi, “Ninji jibarri. Ngala wanjawa yalu nganyinmuku. Miku yaliyanyi jungku nayiba nganyinbu yanybikanyi nganyi, kurdanbikanyi ninya. Mikuyaji yalungi nayiba kuna.” ");
INSERT INTO wrk_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Jananganja nyuli Jisus, “Mikuyaji yalungi nayiba. Barlba yali bukamba.” Yanybayi Jisus nangangi, “Miku ngayiyi yanyba kurdanbikanyi ninya. Miku. Wijbakiyi nganyingkurri barndarri, ngala jungkukiyi kunybana yuwana. Mikujiyi yabimba mili balki yaji. Ngala barriwakiyi jilajba nganyingkurri barndarri. Barriwa.” ");
INSERT INTO wrk_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Baku barri mili yanybayi Jisus yalungi, “Ngayu barrinani mirnbi. Jala mungijbangka yaji, baki miku yaliyi najba yubarl jilaykanyi. Miku yaliyi najba nanda yubarl jala mungijbangka yaji. Ngala jaliyi nyulu kuyu mirnbi yingkawanyi naykanyi yubarl, baki yuku yalu najba nanda yubarl. Nani ngayu barrinani nanda mirnbi. Minimba jangayu narrinya durriykanyi yuwa Kudkanyi. Jalija yalu durrijba ngaki yuwa, baki wankijba jayalu nangandu Kudnyina yurrngumba, minimbangangi ngayu yalunya yuwanyi Kudkanyi. Ngayu barrinani mirnbi minimbikanyi yalungi. Nani ngayu milidimba narrinya yuwanyi Kudkanyi.” Barriwa. ");
INSERT INTO wrk_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Yanybayi Barasimuku nangangi, “Yanyba nganyingkama. Mikuwali yingkawanyi karu nurrunya nganyi. Yurlwa nurru nanankanyi nganyingkanyi jangkurranyi, yanybangangi nganyingkaman.” Barriwa. ");
INSERT INTO wrk_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Jananganjayi Jisuswanyi, “Jala ngakaman yanyba narringi, baki duja nanda jangkurr ngaki. Jingkijba ngaka, wanjamunanyi yajinanyingangi ngayi badajba, baki wanjakurri yajiyurri ngayuja barlba. Ngala miku narrimi jingkijba nanda yaji ngaki. Miku. Duja ngaki jangkurr, jingkijbangangi ngayu nanda yaji. ");
INSERT INTO wrk_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Miku narringkimi mankumanku kudanyu nanankanyi yajinyi, najba jali nganarri yabimbikurri nanda yaji. Miku. Muningka narringka mankumanku bijal, ngala miku nganarriyi jingkijba kudanyu. Nganarri karuyi, balkina ngayu jungku yajina. Ngala ngayu, miku ngayimi karu yalunya, balkina yalu jungku yajina. Miku. ");
INSERT INTO wrk_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Ngala jalija ngayu karu yalunya jangkurranyi, baki duja nanda jangkurr ngaki yalungi. Mankumanku ngaka duja jangkurranyi yalunginkanyi, mankumankungangi ngalingki Buwakanya. Mikungangi ngayiyi jungku ngayuman. Ngaliya Buwakanya, manjijba jali ngana, malumbangangi ngaliya jungku. ");
INSERT INTO wrk_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Yanybaka nanda yuwa Kudkanyi, jala kujarra nganinyi yanyba bula nanamannga jangkurr yajinyi, baki duja nanda jangkurr. ");
INSERT INTO wrk_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Nani barri kujarra yanyba buli ngaki. Ngayu karungka narrinya ngaki, baki ngaki Buwakanya jali ngana manjijba, baki nyulu karungka narrinya ngaki. Yanyba nyulu nanamannga jangkurr.” Barriwa. ");
INSERT INTO wrk_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Ngajaka yali Jisus, “Wanjawa nganyi Buwakanya. Wanyi nyulu.” Barriwa. Jananganjayi Jisuswanyi, “Miku narrimi jingkijba ngaki Buwakanya, baki miku nganarrimi jingkijba. Jaliyi nganarri jingkijba, baki jingkijba janarri ngaki Buwakanya marda. Barriwa.” ");
INSERT INTO wrk_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Nani yanybayi Jisus, ngala nyuli milidimba yalunya walkurranyina jurjina. Milidimba nyuli yalunya nananyina yajina jalili yalu yarrijba dungala darladarlana Kudkanyi. Ngala miku yaliyi wudumba Jisus nanamukunyi yilarrwanyi. Miku yaliyi wudumba Jisus nanamanji. Jilijbawa. Mili janyulu waki Kudkanyi. Barriwa. ");
INSERT INTO wrk_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Mili yanybayi Jisus yalungi Jumukuyngka. “Barlba jangayu. Bayiwujba janarri ngaki. Miku narriyi barlba nanankurri yajiyurri jalija ngayu barlba. Miku. Janyba janarringka, ngala narri jungkuwa balkina yuwana Kudkanyi. Barriwa.” ");
INSERT INTO wrk_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Yanyba yalungki nanamuku mambukamuku Jukanyi, “Wanyingkanyi nyuli yanyba, ‘Miku narriyi barlba nanankurri yajiyurri, jalija ngayu barlba.’ Wanyingkanyi nyuli yanyba nani. Kurdanba nangkaja kuna.” ");
INSERT INTO wrk_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Jananganjayi yalunya Jisuswanyi, “Nayinda jamba narringi yaji. Jardijba narri nayiba narringinyina yajina. Ngala ngayu, ngaki yaji kingkarri. Badajba ngayi kingkarrinya. Nayinda jamba miku ngaki yaji. ");
INSERT INTO wrk_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Karu ngayi narrinya nanginkanyi jangkurranyi, ‘Janyba janarringka, ngala narri jungkuwa balkina yuwana Kudkanyi.’ Jaliyi narri yurlwa ngakinkanyi jangkurranyi, baki janarringka janyba, ngala narri jungkuwa balkina yuwana. Janarringka janyba, jaliyi narri miku kuyu ngaki jangkurr, yanyba jala ngakaman.” Barriwa. ");
INSERT INTO wrk_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Ngajaka yali Jisus, “Ngala wanyi ninji. Wanyi.” Jananganjayi Jisuswanyi, “Ngayu nanda jali ngayu karu narrinya wabula. ");
INSERT INTO wrk_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Mili jangayu karu narrinya kajamukuyngka jangkurranyi. Karrinja janarri waluwa ngakindu. Karu jangayu kajanyi jangkurranyi narringi. Karu jangayu narringinkanyi kajanyi balkinyi yajinyi, yabimba jala narri. Nanda jali ngana manjijba, yanybawa duja jangkurr, baki karu jangayu bukambiju nanankanyi jangkurranyi jali nyulu karu ngana. Nayinda duja jangkurr. Miku nayinda ngaki jangkurr. Ngana nyuli manjijba karunkanyi nayinda jangkurr narringi. Barriwa.” Nani yanybayi Jisus. ");
INSERT INTO wrk_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Ngala miku yaliya jingkijba nangangi jangkurr Jisuskanyi, jali nyulu karu yalunya nanganginkanyi Buwakaya Kudkanyi. Miku yaliya jingkijba nanda jangkurr. ");
INSERT INTO wrk_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Mili yanybayi Jisus yalungi, “Jalija narri langandaba Buwanya Bukambijuyngka, baki janarri jingkijba ngaki, ngayu Buwanya Bukambijuyngka. Janarri jingkijba ngayu nanda jala ngayu karu narrinya. Janarri jingkijba ngaki jangkurr. Miku nayinda ngakinmirra jangkurr, ngala nayinda jangkurr, ngalingi jangkurr, ngalingi Buwakaya jangkurr. Yabimba ngayu nanda jala nyulu karu ngana yabimbiji. Yanyba ngayu nanda jangkurr, jala nyulu karu ngana yanybikanyi. Nyuli milidimba ngana nanginkanyi jangkurranyi Buwakayu. ");
INSERT INTO wrk_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Miku ngayiyi jungku ngayuman. Nanda jali manjijba ngana, nyulili jungku ngakindu yurrngumba, yabimbangangi ngayili nanda yaji. Yabimba ngayu nanda yaji, jalili nyulu ngana karu. Mirnarrijba nyulu muwa ngaki, yabimbangangi ngayu nanda yaji yurrngumba. Barriwa.” ");
INSERT INTO wrk_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Kajamukunyi yali manku nanda jangkurr Jisuskanyi, baki kuyu yali nangangi jangkurr. Kuyu yali nanda jangkurr nangangi. ");
INSERT INTO wrk_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Baki mili yanybayi Jisus yalungi Jumukuyngka, kuyu jali yalu nangangi jangkurr. Yanybayi Jisus, “Jaliyi narri ngayangayijba nanankanyi jangkurranyi, milidimba jalili ngayu narrinya, baki janarri jungku ngakinmuku mungkijimuku. Duja ngayu yanyba. Janarri jungku ngakinmuku mungkijimuku. ");
INSERT INTO wrk_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Baki janarri jingkijba nanda jangkurr Kudkanyi, nanda jangkurr duja, yurlurr. Baki miku narriyi durrijba nanda balki wuwarr. Miku narriyi durrijba nanda yingka balki mambuka narringi. Mirnarrijba janarri muwa, mikungangi narriyi durrijba nanda balki mambuka. Baki miku narriyi yabimba nanda balki yaji.” Barriwa. ");
INSERT INTO wrk_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Ngala jananganja yali Jisus, “Nanda wankalanyi Yabrayam, nyuli barrinani wankalanyi nijanganjinyi nurrungi. Wanyingkanyi ninji yanyba nanda, ‘Miku nurriyi durrijba nanda balki mambuka nurrungi. Miku nurriyi waki mambukanyi. Wanyingkanyi ninji yanyba nani. Miku nurriyi waki mambukanyi.” ");
INSERT INTO wrk_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Jananganjayi yalunya Jisuswanyi, “Karungka ngayu narrinya duja jangkurranyi. Jala narri jungku balkina yuwana, nanda barrinani narri waki nanankanyi balkinyi mambukanyi. Jala narri waki balkinyi mambukanyi, baki narri yabimba balki yaji yurrngumba. Nanangini balkiwanyi jarrbangka narringi kurdulu. ");
INSERT INTO wrk_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Baki mili nayindakiyi manku. Nanda wakiwarr yiningki miku nyulimi jungku yingamalina mambukana yurrngumba. Yiningki nanganginyi mambukawanyi janyulu manjijba barriwa nanda wakiwarr nanganbunanyi, baki mili nyuliyi miku waki nanankanyi mambukanyi. Ngala jandanyi nangangi nanankanyi mambukanyi, jungka nyulili nangandu yurrngumba. Nanda nyulu jandanyi nangangi yurrngumba nanganginkanyi wulukanjanyi. Barriwa. ");
INSERT INTO wrk_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Nanangini Jandanyiwanyi Kudkanyi, jaliyi nyulu dulaba narrinya balkinanyi mambukananyi, baki yuku janarri barlba nanganbunanyi mambukananyi. Baki miku nyuliyi mili marrimba narrinya mambukawanyi. ");
INSERT INTO wrk_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Jingkijba ngayu narrinya, narri jungkuka barrinani jandanyimuku nanankanyi wankalanyi Yabrayamkanyi, ngala miku janarri kuyu ngaki jangkurr jala ngayu milidimba. Nganarrimi kurdanba. Miku narrimi kuyu ngaki jangkurr. Jungkuka narri barrinani jandanyimuku nangangi Yabrayamkanyi, ngala miku narrimi yabimba yaji barrinani nyuli yabimba Yabrayamwanyi. Ngawamba nyuli yabimba nanda yaji, jali karu Kudwanyi, ngala miku narrimi yabimba yaji Kudkanyi, jala nulijba narri kurdanbikanyi nganarri. ");
INSERT INTO wrk_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Yabimba ngayu nanda yaji kaja, jali nyulu karu ngana ngakinyi Buwakayu. Ngala miku narriyi yabimba nangangi yaji ngakinkanyi Buwakaya. Narri yabimbaka nanda jala nyulu karungka narrinya narringinyi buwakayu. Yabimbaka narri nangangi yaji narringinkanyi buwakaya.” Barriwa. ");
INSERT INTO wrk_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Mili yali jananganja Jisus, “Nanda wankalanyi Yabrayam, nyuli barrinani wankalanyi buwakanya nurrungi. Jungkuka nurru barrinani jandanyimuku nangangi.” Barriwa. Jananganjayi yalunya Jisuswanyi, “Jalimi narri jandanyimuku Yabrayamkanyi, baki narrimi yabimba nanda yaji barrinani nyulu yabimba yaji. Ngala miku narrimi yabimba nanda yaji barrinani nyulu yabimbayi Yabrayamwanyi. Miku narrimi ngayangayijba Kudkanyi, ngala Yabrayam nyuli ngayangayijba Kudkanyi yurrngumba. ");
INSERT INTO wrk_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Yurrngumba ngayi karu narrinya nanankanyi duja jangkurranyi. Karu ngayi narrinya nanganginkanyi jangkurranyi Kudkanyi, ngala nulijba narri ngaki kurdanbikanyi nganarri. Miku nyuliya yabimba balki yaji nani Yabrayamwanyi. Miku nyuliyanyi nulijba kurdanbikanyi nanda yingka, ngala narri nulijba ngaki kurdanbikanyi nganarri. ");
INSERT INTO wrk_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Narri yabimbaka balki yaji barrinani nyulu yabimbaka balki yaji narringinyi buwakayu. Jungkuka nyulu balki, baki nani narri jungkuka balki marda.” Nani yanybayi Jisus yalungi. Jananganja yali Jisus, “Kud, nyulu nurrungi Buwakanya. Jungku nurru jandanyimuku nangangi Kudkanyi. Ngawamba Kud, nyulu nurrungi Buwakanya, nyuluman.” Barriwa. ");
INSERT INTO wrk_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Yanybayi Jisus yalungi, “Jalimi nyulu narringi Buwakanya Kud, baki narrimi maruka muwa ngaki. Marda narrimi maruka muwa ngaki, badajbangangi ngayi kingkarrinya Kudnanyi. Badajba ngayi Kudnanyi nanginkurri. Manjijba ngani Kudwanyi. Miku ngakiya manjijba ngakaman. Manjijba ngani Kudwanyi. ");
INSERT INTO wrk_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Miku narrimi jingkijba ngaki jangkurr, mikungangi narriyi nulijba mankunkanyi ngaki jangkurr. Miku narriyi mirnarrijba muwa ngakinkanyi jangkurranyi. ");
INSERT INTO wrk_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Buwakanya narringi nyulu Sayidin. Narri jandanyimuku nangangi mambukanyi wuwarranyi, Sayidinkanyi. Nulijba narri durriykanyi balkina yuwana Sayidinkanyi. Nyulu kurdanbawarr. Marda barrabarruji marda nanijba nyuli kurdanbawarr. Miku nyuliyala yanyba duja jangkurranyi. Miku nyuliyala manku duja jangkurr. Jujijba nyulili yurrngumba. Miku nyuliyala yanyba duja jangkurr. Ngawamba jujijba nyulili. Nyulu barrinani buwakanya yalungi jala jujijba, karungangi nyulili yingkamuku yalu jujiykanyi yurrngumba. ");
INSERT INTO wrk_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Ngala miku ngayili jujijba. Miku. Yanyba ngayili duja jangkurr. Ngawamba duja jangkurr yurlurr ngayili yanyba. Ngala nanda Sayidin, nyulu narringi buwakanya, baki nanankardi miku narriyi kuyu ngaki jangkurr. Miku narriyi mirnarrijba muwa nanankanyi duja jangkurranyi. ");
INSERT INTO wrk_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Miku narriyi yanyba ngaki, jala ngayu yabimba balki yaji. Miku narriyi yanyba nani ngaki. Miku ngayimi jungku balki. Baki yanybawa ngayu duja jangkurranyi. Miku ngayiyi jujijba. Ngala wanyingkanyi narriyi miku kuyu ngaki jangkurr. ");
INSERT INTO wrk_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Nanamukunyi jandanyiwanyi Kudkanyi, yalu manku nangangi jangkurr Kudkanyi. Ngala miku narriyi nangangi jandanyi Kudkanyi. Miku narrimi manku nangangi jangkurr, mikungangi narrimi badajba Kudnanyi.” Barriwa. ");
INSERT INTO wrk_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Jananganja yali Jumukunyi, “Yanyba nurri duja nganyi. Nganyi yaji langku, niji Samariya. Baki jungkuka wuwarr kalawunyi nganyindu mankanyina. Nani barri nanda jangkurr nurrungi duja. Nanda wuwarr jungkuka nganyindu.” ");
INSERT INTO wrk_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Jananganja yalunyi Jisuswanyi, “Miku ngayimi jungku wuwarryudi. Miku. Jingkijba ngayu ngaki Buwakanya, nyulu walkurra mambuka. Nani ngayu jingkijba nangangi. Ngala narri, miku narringkimi mankumanku ngaki, ngayu walkurra mambuka marda. Miku narringkimi mankumanku nani ngaki. Miku narrimi kuyu ngaki jangkurr. ");
INSERT INTO wrk_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Miku ngayimi nulijba yalungi, yalu barrarrakiykanyi ngana. Ngala yingka nyulu nulijbangka yalungi, yalu barrarrakiykanyi ngana. Nanda yingka, nyulu Kud. Nulijbangka nyulu yalungi nani ngaki, jingkijbangangi nyulu ngaki, ngayu jungkuka kunyba yurrngumba. ");
INSERT INTO wrk_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Narri. Ngayu karungka narrinya duja jangkurranyi. Nanda jala durrijba ngaki jangkurr, miku nangkiyi janyba. Janyulu wanka jungku yurrngumba.” Barriwa. ");
INSERT INTO wrk_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Mili yanyba yali nangangi Jumuku, “Mudu ninji mudu. Jungkuka wuwarr nganyindu mankanyina. Miku nganyi jangkurr duja. Jujijba ninji. Jujijba. Nanda nurrungi walkurra mambuka wankalanyi, nanda Yabrayam janyba nangki. Marda yingkamuku, karu jali yalu jangkurr Kudkanyi, marda yalungki janyba. Ngala yanyba ninji, jaliyi nurru kuyu nganyi jangkurr, baki miku nurrungkiyi janyba mili. Mudu ninji. Mudu. ");
INSERT INTO wrk_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Nanda Yabrayam, marda yingkamuku wankalamuku, bukamba yalungki janyba. Ninji kuna mili walkurra mambuka nangangi Yabrayamkanyi. Miku ninji walkurra mambuka nangangi mili. Ngala wanyi ninji. Wanyi.” Barriwa. ");
INSERT INTO wrk_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Jananganjayi yalunya Jisuswanyi, “Jaliyi ngayu yanyba, ngayu walkurra mambuka bukambijuyngka, baki miku nanda jangkurr kunyba. Ngala yingkawanyi nyulu barrarrakijba ngana ngakinyi Buwakayu. Nyulu yanybaka ngaki, ngayu jungku walkurramirra mambuka bukambijuyngka. Nyulu barrarrakijba ngana. Nganarri karu nangangi, ngakinkanyi Buwakaya, nyulu narringi Kud, ");
INSERT INTO wrk_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","ngala miku narrimi jingkijba nanda Kud. Miku narrimi jingkijba ngaki Buwakanya. Miku. Ngala ngayu, jingkijba ngayu nanda Kud, nyulu ngaki Buwakanya. Jaliyi ngayu yanyba, miku ngayimi jingkijba Kud, baki jujamba ngayimi narrinya. Miku ngayiyi jujijba narringi, ngala narri jujijbangka yajinyi. Miku narrimi jingkijba Kud. Ngala ngayu jingkijba Kud, baki kuyu ngayu nangangi jangkurr. ");
INSERT INTO wrk_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Nanda wankalanyi Yabrayam, jungku nyuli wabula kamambarra, baki nyuli mirnarrijba muwa ngaki nanamanji kamambarra. Mirnarrijba nyuli muwa ngaki, jingkijbangangi nyuli yaji ngaki, jangayu badajba nanginkurri baku bayngkani. Ngala nayimanji mili nyuli mirnarrijba muwa ngaki, najbangangi ngani badaykurri nanginkurri.” Barriwa. ");
INSERT INTO wrk_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Mili yanyba yali Jumuku nangangi, “Miku ninjimi yanyba duja jangkurr nurrungi. Miku ninji malbumirra mankanyi. Miku. Ngala jilijbawa ninji malbumirra. Karu ninji nurrunya nanankanyi wankalanyi Yabrayamkanyi, najba ninji nanda malbu. Ngala jujijba ninji. Jujijba. Nangka janybayi wabulawa kamambarra. Miku ninjiyi najba nanda wankalanyi.” Barriwa. ");
INSERT INTO wrk_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Jananganjayi Jisuswanyi, “Karu ngayu narrinya duja jangkurranyi. Miku ngayiyi jujamba narrinya. Jungku ngayi wanka waluwa Yabrayamkanyi, ngala nyuli mikuyaji nangangi. Barriwa.” ");
INSERT INTO wrk_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Jali yalu manku nanda jangkurr Jisuskanyi Jumukunyi, baki ngarrangarra yali muwa nangangi. Wudumba yali dungala janybikanyi nangandurri. Nulijba yali kurdanbikanyi Jisus. Wudumba yali dungala janybikanyi, ngala miku nyuliya jungku nanaba. Ngala ngadijba nangki Jisus. Barlba nyuli yalunbunanyi. Barlbayi jurjnanyi. Barriwa. ");
INSERT INTO wrk_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Baku barri yali jilajba, Jisus marda nanganginmuku kandimuku. Ngala yali jilajba, baki najba yali nganinyi. Nanda nganinyi kabuji yami. Kabuji nyuli yami ngala nyuli bardardanji. ");
INSERT INTO wrk_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Ngajaka yali Jisus, nanganginyi kandimukunyi, “Milidimbawarr. Wanyi jungkuyi balkina yuwana, baki nanda barri kabujingujbayi yami. Nayinda nganinyi kuna, nangangi nijanganjinyi marda yarrijinyi, bula kuna. Wanyi jungkuyi balkina yuwana, baki nanankardi kabujingujbayi yami.” ");
INSERT INTO wrk_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Jananganjayi yalunya Jisuswanyi, “Nayinda nganinyi, miku nyulimi kabuji yami, jungkungangi nyuli balkina yuwana. Baki miku nyulimi kabuji yami, jungkungangi buli balkina yuwana. Miku. Nyulu jungkuka nanijba kabuji, ngala Kudwanyi yuku nyulu yabimba ngiruka yaji nangangi. Baki yingkamukunyi jayalu najba nanda ngiruka yaji, yabimba jalija Kudwanyi. ");
INSERT INTO wrk_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","5","Marda ngambalimi waki kambana Kudkanyi, manjijba jali ngana. Waki yali ngawamba kambana. Miku yalimi waki jala mungijba yaji. Miku yaliyi waki mungana, mikungangi yaliyi najba yaji. Ngayu barrinani mirnbi. Yuku yalu waki, jala mirnbi nanaba, mirnajijba yaji. Ngala ngayu jungku narrindu, baki yuku narri najba yaji, yuku narri waki. Yuku narri waki ngakindu, ngala ngayu jungku narrindu milidimbiji narrinya. Ngayu milidimba narrinya nanankanyi yajinyi jala nyulu nulijba ngambalangi yabimbikanyi. Ngana nyuli manjijba Kudwanyi, wakinki nangangi. Milidimba ngayu nanda jali nyulu karu ngana Kudwanyi. Ngala ngayu jungku narrindu, baki yuku ngambalaja waki, ngambalaja milidimba yalunya. Ngala winyurru miku jangayu jungku nayiba narrindu, ngala barlba jangayu. Jalija ngayu miku jungku nayiba narrindu, baki miku narriyi waki. Miku narriyi waki, mikungangi ngayiyi nayiba karunkanyi narrinya nanankanyi jala nulijba Kud narringi yabimbikanyi yajinyi. Miku yaliyi waki mungana, mikuyajingangi mirnbinyi, baki nani barri miku narriyi waki, jalija ngayu barlba. Ngayu barrinani mirnbi. Minimba ngayu narrinya nanankanyi yajinyi jalija narri yabimba. Nanda barrinani mirnajijba yaji. Jalija ngayu barlba, nanda barrinani mungijba yaji, baki miku narriyi waki. Jungku ngayu barrinani mirnbi bukambijuyngka. Barriwa.” ");
INSERT INTO wrk_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Ngala yanybayi Jisus nani yalungi kandimukuyngka, baki janyba nyuli jabula wayka jambarri. Baki ngirrikimbayi nanda jabula nangangi. Yabimba nyuli janja. Yarrijba nyuli janja nganinyina yamina jali nyulu kabuji. Nanda kabuji janjayudi yami. ");
INSERT INTO wrk_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Baki karu nyuli nanda kabuji Jisuswanyi, “Barlbakiyi wayka rirrkiyurri, niji Saluyam, baki wakardaba nganyingkiyi yami wabudana. Wakardaba nganyingkiyi yami rirrkina.” Nanda niji Saluyam, Ju yanyi, barrinani, “Manjijbayi.” Barlbayi nanda kabuji rirrkiyurri. Wakardaba nangki yami, baki yuku nyuli najba yaji. Najba nyuli yaji, baki wijbayi nanganginkurri barndarri. Barriwa. ");
INSERT INTO wrk_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Wabula nanda nganinyi jungkukili wilina yubalina, baki yililikajba nyuli yingkamuku jalili yalu jilajba nanganbiyangka. Yililikajba nyuli yalunya dungalanyi, mikungangi nyulili waki dungalanyi, kabujingangi nangangi yami. Barriwa. Yingkamuku jalili jungku bundu nanganginyina barndana, baki yingkamuku jali wabula najba nanda nganinyi yililikaykurri dungalanyi, yanyba yalungki, “Nayinda nganinyi, nyulu nanda jalili jungku wilina yubalina, jalili yililikajba ngambalanya dungalanyi. Nyulu nanda.” ");
INSERT INTO wrk_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Yingkamuku yali yanyba, “Yi. Nyulu barri nanda kabuji. Nyulu nanda barri jalili jungku kabuji.” Ngala yingkamuku yali yanyba, “Miku nyulu nanda kabuji. Nyulu yingka, ngala nyulu barrinani nanda kabuji.” Baki nyuli manku nanda jangkurr yalungi nanangini nganinyiwanyi. Karu nyuli yalunya, “Ngayu nayinda kabuji, jali ngayu jungku waluwa kabuji yami, ngala nanijba kunybijba ngaki yami. Yuku ngayu najba yaji.” ");
INSERT INTO wrk_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Ngajaka yali nanda nganinyi, “Wabula ninji jungku kabuji, ngala nanijba yuku ninji najba yaji. Ngala yanka ninji najba yaji nanijba. Yanka.” ");
INSERT INTO wrk_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Jananganja nyuli yalunya, “Nanangini nganinyiwanyi niji Jisus, nyuli yabimba janja. Baki nyuli yarrijba nanda janja ngakindu yamina. Ngana nyuli jirrinyba, ‘Jilajbakiyi rirrkiyurri, niji Saluyam, baki wakardaba nganyingkiyi yami.’ Nani nyuli jirrinyba ngana. Jilajba ngayi rirrkiyurri, wakardaba ngaki yami, baki yuku ngaki yami. Yuku ngayu najba yaji.” ");
INSERT INTO wrk_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Ngajaka yali nanda nganinyi, “Wanjawa nanda Jisus. Wanjawa nanda jali ninyi kunymamba yami.” Jananganjayi nganinyiwanyi, “Junu barri nanda. Miku ngayiyi jingkijba nanda yaji nangangi.” ");
INSERT INTO wrk_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Baki yali kuyu nanda nganinyi yalundurri Barasimukuyngkurri. ");
INSERT INTO wrk_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Najba yali nanda nganinyi, kabuji yami Sadidi. ");
INSERT INTO wrk_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Marda nanamukunyi Barasimukunyi, marda yali ngajaka nanda nganinyi nanganginkanyi yaminyi. “Yanka ninji najba yaji. Yanka.” Karu nyuli yalunya, “Yarrijba nyuli janja ngakindu yamina. Baki wakardaba ngaki yami wabudana, baki yuku ngayi najba yaji.” ");
INSERT INTO wrk_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Yingkamuku Barasimuku, yanyba yali, “Nyuli kunymamba nganyi yami Sadidi. Nanda balki. Yanybaka nanda yuwa Musiskanyi, miku nyuliyi waki Sadidi. Miku nyulimi jungku kunybana yuwana, jaliyi nyulu waki Sadidi. Mikukiyanyi Kudwanyi manjijba nanda nganinyi Jisus. Miku nyulimi jungku kunybana yuwana.” Barriwa. Ngala yingkamuku Barasimuku yali yanyba nayi, “Yanka barri nyuli barimba yuwa jala nyuli yabimba ngiruka yaji Sadidi. Miku nyuliya jungku balkina yuwana, jali nyulu kunymamba nayinda nganinyi yami Sadidi. Jaliyi jungku nganinyi balkina yuwana, baki miku nyuliyi yabimba ngiruka yaji nani. Miku nyuliyi kunymamba kabuji yami.” Barriwa. Nani yalungki jakakajba. Yingkamuku yali yanyba Jisuskanyi, nyuli jungku balkina yuwana, ngala yingkamuku yali yanyba Jisuskanyi, nyuli jungku kunybana yuwana. Jakakajba yalungi nanganginbunanyi. ");
INSERT INTO wrk_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Baki mili yali ngajaka nanda nganinyi jali kunymamba Jisuswanyi, “Yanyba ninji, miku ninjiyanyi najba yaji wabula, baki kunymamba nyuli nganyi yami, nanangini nganinyiwanyi. Baki wanyi ninji yanyba nangangi. Wanyi nyulu.” Jananganja nyuli yalunya, “Nanda nganinyi manjijbayi Kudwanyi. Nyulu nanda jali manjijba Kudwanyi.” ");
INSERT INTO wrk_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Ngala miku yaliyala kuyu nangangi jangkurr. Baki miku yaliyanyi kuyu nangangi jangkurr, jali nangka yanyba, wabula nyulili jungku kabuji. Baki yali manjijba yingka wudumbiji nangangi nijanganjinyi marda ngardanganja. Badajba buli yalundurri Barasimukuyngkurri. ");
INSERT INTO wrk_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Ngajaka yali bulanya, “Nayinda nganinyi, nyulu nimbalangi jandanyi kuna, jali jungku yurrngumba kabuji, ngala nyuli bardardanji. Ngala yanka nyuli yuku najba yaji nanijba. Yanka barri.” ");
INSERT INTO wrk_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Jananganja buli yalunya, “Nyulu ngalingi jandanyi. Jali nyulu bardarda, baki jungkuyi kabuji yami. Miku nyuliya najba yaji. ");
INSERT INTO wrk_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Ngala miku ngaliyi jingkijba nanijba, yanka nyuli najba yaji. Miku ngalimi jingkijba. Baki miku ngalimi jingkijba nanda jali kuynmamba nangangi yami. Marda narrimi ngajaka nanda. Nyulu walkurra nganinyi. Miku nyulu juka. Yuku nyulu karu narrinya.” Barriwa. ");
INSERT INTO wrk_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","23","Yanyba buli nani, marralangangi buli yalungi mambukamukuyngka Jumukuyngka. Nanamuku mambukamuku, yanyba yali nayi, “Nayinda nganinyi Jisus, miku nyulu Krayis. Miku nyulu nanda jali manjijba Kudwanyi. Nanda jala yanyba, nyulu Krayis, baki janurru manjijba nanda jurjnanyi. Miku nyuliyi mili ngankijba kalawunyi jurjina. Mikujiyi narri kuyu nangangi jangkurr.” Nijanganjinyi marda yarrijinyi nanankanyi kabujinyi, buli marrala yalungi mambukamukuyngka, yanybangangi yali nani. Baki nanankardi buli yanyba, “Marda narrimi ngajaka ngalingi jandanyi. Nyulu walkurra nganinyi. Miku nyuliya juka jungku.” Marrala buli yalungi. ");
INSERT INTO wrk_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Mili yali manjijba yingka wudumbiji nanda kabuji nganinyi. Jala nyuli wanbiya yalundu, yali yanyba nangangi, “Marda ninjimi maruka muwa Kudkanyi. Marda ninjimi wajba Kud kunybanyi jangkurranyi, najbangangi ninji yaji nanijba. Jingkijba nurru nanda Jisus, nyulu jungkuka balkina yuwana. Miku nyulimi jungku kunybana yuwana. Marda ninjimi maruka muwa nangangi Kudkanyi.” Barriwa. ");
INSERT INTO wrk_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Jananganja nyuli yalunya, “Miku ngayimi jingkijba yaji. Yiningki nanda Jisus, nyulu jungkuka balkina yajina, yiningki nyulu jungkuka kunybana yajina. Miku ngayimi jingkijba. Ngala nayi ngayu jingkijba, wabula ngayi jungku kabuji yami, ngala nanijba, yuku ngayu najba yaji.” Barriwa. ");
INSERT INTO wrk_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Ngajaka yali nanda nganinyi, “Wanyimba nyuli nganyi. Wanyimba. Ngala yanka ninji najba yaji nanijba.” ");
INSERT INTO wrk_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Jananganja nyuli, “Barrin ngayi karu narrinya. Karu ngayi barrin, ngala miku narriyala manku ngaki jangkurr. Wanyingkanyi narri nulijba mankunkanyi mili ngaki jangkurr. Nulijba narri kuna nangangi. Marda janarri kuna jungku nangangi kandimuku nanijba.” Barriwa. ");
INSERT INTO wrk_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Kijiwijba yali nangangi kudanyu. Yanyba yali balki jangkurr nangangi. Yanyba yali “Ninjija jungku kandi nangangi Jisuskanyi, ngala nurruja jungku kandimuku nangangi wankalanyi Musiskanyi. Miku nurru kandimuku nangangi Jisuskanyi. ");
INSERT INTO wrk_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Jingkijba nurru Musis. Yanybayi Kud nangangi Musiskanyi, ngala nanda yingka, miku nurrimi jingkijba nangangi yaji.” Barriwa. ");
INSERT INTO wrk_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Jananganjayi nganinyiwanyi, “Manmala ngayu kudanyu barri. Miku narrimi jingkijba nangangi yaji, ngala nyuli kunymamba ngaki yami, baki yuku ngayu najba yaji. Manmala ngayu kudanyu barri. ");
INSERT INTO wrk_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Jingkijba ngambala Kud, miku nyulimi manku jangkurr yalungi jalili yalu jungku balkina yuwana. Miku nyulimi manku yalungi jangkurr. Ngala nyulu mankuka nanda jangkurr yalungi, jalija yalu ngayangayijba nangangi. Nyulu mankuka yalungi jangkurr jalija yalu yabimba nanda jala nyulu nulijba yalungi yabimbikanyi nanda. Mankuka nyulu jangkurr yalungi jala ngayangayijba nangangi, jala yabimba nangangi yaji. ");
INSERT INTO wrk_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Miku ngambaliya manku jangkurr nanankanyi kabujinyi yaminyi, ngala nyuli kabuji bardardanji. Miku ngambaliya manku jangkurr kunymambikanyi yami nanda kabuji. Miku yaliya karu wankalanyi jangkurranyi, marda nanijba nani kunymambikanyi yami. ");
INSERT INTO wrk_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Nanda nganinyi jali kunymamba ngaki yami, jaliyi nyulu badajba Kudnanyi, baki yuku nyulu yabimba ngiruka yaji nani. Ngala jaliyi nyulu miku badajba Kudnanyi, baki miku nyuliyi kunymamba yami.” Nani barri yanybayi nanda nganinyi kabuji. ");
INSERT INTO wrk_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Baki kijiwijba yali nangangi, “Barriwakiyi barlba. Barriwa ninji nurrunbunanyi, balkingangi ninji jungku. Jungku ninji balki bardardanji yurrngumba. Barriwakiyi barlba nurrunbunanyi. Miku ninjiyi milidimba nurrunya. Jungku ninji balkina yajina. Miku ninjiyi milidimba nurrunya.” Baki yali manjijba nanda nganinyi yalunbunanyi, walkurrananyi jurjnanyi. Barriwa. ");
INSERT INTO wrk_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Karu yali Jisus yingkamukunyi, “Nanamukunyi Barasimukunyi, yali manjijba nanda nganinyi jali ninji kunymamba yami. Manjijba yali jurjnanyi.” Baki wankawankijbayi Jisus nangangi. Jala nyuli wakaramba, yanybayi Jisus nangangi, “Kuyu kuna ninji nanda jangkurr nangangi Buwaya Bukambijuyngka. Kuyu kuna ninji nangangi jangkurr.” ");
INSERT INTO wrk_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Jananganjayi Jisus nganinyiwanyi, “Mambuka. Nanda nganinyi Buwanya Bukambijuyngka, wanyi nyulu. Karu janganinji nangangi, baki jangayu ngayangayijba nangangi, jangayu kuyu nangangi jangkurr.” Barriwa. ");
INSERT INTO wrk_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Yanybayi Jisus nangangi, “Barrin ninji najba nanda Buwanya Bukambijuyngka. Nyulu nanda jala yanybaka nganyi nanijba. Ngayu Buwanya Bukambijuyngka.” Barriwa. ");
INSERT INTO wrk_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Yanybayi nganinyi Jisuskanyi, “Mambuka. Kuyu ngayu nganyi jangkurr. Nanijba ninga jingkijba, ninji Buwanya Bukambijuyngka.” Baki maruka nyuli muwa nangangi Jisuskanyi. Yanyba nyuli mududu nangangi marda. ");
INSERT INTO wrk_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Yanybayi Jisus nangangi, “Badajba ngayi karunkanyi yalunya nganinymuku baki jibarrimuku. Jingkijba jangayu yalunya, yingkamuku yali jungku kunyba Kudkanyi, yingkamuku yali jungku balki Kudkanyi. Baki nanamuku jala yalu jungku kabuji, jayalu najba yaji, ngala nanamuku jala yalu najba yaji, jayalu jungku barrinani kabuji.” ");
INSERT INTO wrk_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Kudiyamuku Barasimuku, yali karrinja bundu nangandu. Manku yali nanda jangkurr nangangi, baki ngajaka yali, “Jungku kuna nurru barrinani kabuji yami.” ");
INSERT INTO wrk_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Jananganjayi yalunya Jisuswanyi, “Nanangini kabujiwanyi, miku nyuliyi najba yaji. Ngala nyulu miku naykanyi yaji, baki miku nyulimi jingkijba yaji. Baki miku nyulimi jungku balki, mikungangi nyuliyi jingkijba yaji. Nani nanda kabuji, miku nyuliyi jungku balkina yuwana, mikungangi nyuliyi jingkijba yaji. Jaliyi narri jungku barrinani kabuji, baki miku narriyi jungku balkina yajina, mikungangi narriyi jingkijba yaji. Ngala miku narrimi kuyu ngaki jangkurr. Miku narriyi jingkijba nanda jala ngayi karu narrinya. Ngala miku narrimi jungku barrinani nanda kabuji, yanybangangi narri, narri jingkijba bukamba yaji. Ngala miku narrimi kuyu ngaki jangkurr. Yanyba narri, narri jingkijba bukamba yaji, ngala miku narrimi jingkijba ngaki jangkurr. Miku narrimi kuyu ngaki jangkurr. Jungku narri balkina yajina, yanybangangi narri, narri jingkijba yaji, ngala miku narrimi kuyu ngaki jangkurr. Balkina yajina narri jungku yurrngumba, yurlwangangi narri ngakinkanyi jangkurranyi.” Barriwa. Nani jananganjayi yalunya Jisuswanyi. ");
INSERT INTO wrk_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Baku barri mili yanybayi Jisus yalungi. Muningka nyuli karu yalunya nanginkanyi jangkurranyi, “Mankukiyi nayinda duja jangkurr. Mankumanku narringka jibkanyi. Nanangini lalanbawarranyi jibkanyi mungana nyulu yarrijba nangangi jibmuku. Yarrijba nyulu jibmuku kalawunyi barrikina mungana. Baki nanda maninjaku, miku nyulimi ngankijba kalawuyngkurru bardawana. Miku. Ngankijba nyulu kalawuyngkurru yingkana yajina bayngkani. Yiningki nyulu lukulukumba langkiya wilina barrikina, baki ngankijba kalawuyngkurru barrikina maninjakuykanyi jib. ");
INSERT INTO wrk_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Ngala nanda jala ngankijba nanaba bardawana, nyulu nanda lalanbawarr jibkanyi. ");
INSERT INTO wrk_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Yingka jala jungku barrikina, nyulu lalanbawarr bardawanyi. Jala badajba nanda lalanbawarr jibkanyi, baki nanangini lalanbawarranyi bardawanyi dulaba nyulu bardawa, baki ngankijbangka nanda lalanbawarr jibkanyi kalawuyngkurru barrikina. Ngala jala badajba maninjaku, baki miku nyuliyi dulaba nanda bardawa nangangi maninjakunyi. Miku. Yiningki lukulukumba langkiya wilina barrikina. Nanamukunyi jibwanyi jingkijba yalu nanda yalungi lalanbawarr. Manku yalu nangangi jangkurr, baki jingkijba yalu nangangi jangkurr. Nijarrijba nyulu yalungi niji, ngala nyulu kaya yalungi. Jala yalu manku nangangi jangkurr baki walajba yalu, baki yalilijba nyulu yalunya. ");
INSERT INTO wrk_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Dulaba nyulu yalunya, nanamuku nanganginmuku jibmuku, baki nyulu jilajba waluwalu, ngala yalu nanganginmuku jibmuku bayngkani nangandu. Durrijba yalu nanda lalanbawarr yalungi. Durrijba yalu nanda, jingkijbangangi yalu nanda nangangi jangkurr. ");
INSERT INTO wrk_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Ngala miku yalimi durrijba ngurranyimuku. Miku. Wirlkungka yalu nanganbunanyi ngurranyinanyi, mikungangi yalimi jingkijba nangangi jangkurr. Wirlku yalu nanganbunanyi.” Barriwa. ");
INSERT INTO wrk_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Muningka karuyi yalunya nani Jisuswanyi, milidimbikanyi yalunya, ngala miku yaliya jingkijba nangangi jangkurr jibkanyi. Miku yaliya jingkijba. ");
INSERT INTO wrk_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","9","Mili yanybayi Jisus yalungi, “Karu ngayu narrinya duja jangkurranyi. Ngala nyulu bijal mungijba yaji, baki nanangini lalanbawarranyi, nyulu yarrijbangka nanganginmuku jibmuku kalawuyngkurru barrikina. Yarrijbangka nyulu yalunya kalawuyngkurru barrikina, baki murumbaka nyulu bardawa yalungi. Jala murumba nanda bardawa, baki nanamuku jibmuku mardarda yalu jungku kalawuyngkurru mungana. Mikuwali yingka ngankijba kalawuyngkurru jibyurri, jala nyulu murumbaka nanda bardawa. Mikuwali warrki ngankijba kalawunyi bardawana, marda maninjaku, miku nyuliyi ngankijba kalawunyi bardawana. Ngayu barrinani nanda bardawa. Kurrkunbaka jibmuku kalawunyi nanangini bardawawanyi, baki yalu jungku mardarda. Nganinymuku baki jibarrimuku jala yalu durrijba Kud, yalu barrinani jibmuku. Ngankijba yalu bardawana jala yalu jilajba Kudyurri. Ngayu barrinani nanda bardawa. Ngayu manjijba yalunya Kudyurri, baki yalu jungku mardarda nangandu. Barriwa. Munganawa ngala nyulu kambalingijba yaji, baki walajbangka jibmuku nanankardi barri bardawananyi. Walajba yalu, baki durrijba yalu nanda lalanbawarr yalungi. Durrijba yalu lalanbawarr, baki nyulu kuyungka yalunya karnbarri baki wabudarri. Baki mili yalu wijba ngabungaburri. Ngankijba yalu bardawana, baki jungku yalu muwana kalawunyi barrikina mungana. Jungku yalu mardarda. Miku yalunyiyi wudumba yingkawanyi. Ngayu barrinani nanda bardawa. Ngayu lalanba yalunya nganinymuku baki jibarrimuku Kudkanyi. Lalanba ngayu yalunya yurrngumba, kambana baki mungana, ngala yalu walajba, baki ngala yalu ngankijba. Barriwa. Kudiya nganinymuku, badajba yalu waluwa ngaki. Badajba yali baki milidimba yalunjali. Muningka yali yanyba, ‘Ngayu Krayis. Ngayu nanda jali manjijba Kudwanyi.’ Ngala miku. Jujijba yali. Miku yaliya Krayis. Yalu barrinani maninjaku jibkanyi. Mikukiyanyi jibwanyi durrijba maninjaku, mikungangi yaliya jingkijba nangangi jangkurr. Nanda jali badajba waluwa ngaki, jali yanyba ngayu Krayis, miku yaliyanyi yingkamukunyi kuyu nangangi jangkurr. Miku yaliya durrijba nanda, mikungangi nyuli Krayis. ");
INSERT INTO wrk_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Ngala nanda maninjaku, jilajba nyuli mungana yalundurri jibyurri. Binanyba nyuli yalunya baki kurdanbiji yalunya. Daba jayalunya. Ngala ngayu miku ngayu barrinani nanda maninjaku. Miku ngayiyanyi jilajba nayinda nanginkurri daji yalunya. Jilajba ngayi, marrimbiji yalunya mardarda, lalanbiji yalunya nganinymuku jibarrimuku. Miku ngayiyanyi jilajba kurdanbiji yalunya, ngala ngayi jilajba wankambiji yalunya, maruka jala muwa nangangi Kudkanyi. Jayalu jungku wanka yurrngumba nangandu Kudnyina, baki janyulu yabimba kunyba yaji yalungi Kudwanyi.” ");
INSERT INTO wrk_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Mili yanybayi Jisus yalungi, “Ngayu barrinani nanda lalanbawarr jibkanyi. Nanangini lalanbawarranyi, nyulu yabimbaka kunyba yaji yalungi nanganginmukuyngka jibkanyi. Kurrkunbaka nyulu maninjakunyi wudumbikanyi jib. Marda warrkinyi nyulu kurrkunbaka kurdanbikanyi jib. Mankumanku nangka lalanbawarr, “Nanangini warrkiwanyi miku nyuliyi wudumba ngakinmuku jibmuku. Miku nyuliyi kurdanba yalunya. Jangayu kurrkunba nanankanyi warrkinyi. Waluku jangana nyulu kurdanba, waluwa nyuli wakaramba jib.” Nani nyulu lalanbaka nanganginmuku jibmuku. Nanamuku jibmuku yalu nanganginmirra jibmuku. Nyulu lalanbaka yalunya kudanyu barri. ");
INSERT INTO wrk_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","13","Yiningki nanda mambuka jibkanyi, yiningki nyulu karu yingka lalanbiji nanganginmuku jibmuku. Wajbayi nanda yingka dungalanyi, janyulu lalanba nanda jibmuku nangangi. Jala walajbangka warrki jibkanyi, baki marrala nanda yingka, baki wirlku nyulu. Wirlku nyulu, marralangangi nyulu warrkinyi. Baki bijbawali warrkiwanyi, kurdanbawali. Wirlku nyulu nanamunanyi jibnanyi. Miku janyulu lalanba yalunya kudanyu, mikungangi yalu nanganginmirra jibmuku. Wirlku nyulu, baki kurdanbaka jib warrkiwanyi, baki jarrbalambaka yalunya junu. ");
INSERT INTO wrk_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","15","Ngayu barrinani nanda kunyba lalanbawarr. Ngayu lalanba yalunya, maruka jala muwa nangangi Kudkanyi. Miku ngayiyi wirlku yalunbunanyi. Ngakinyi Buwakayu, ngana nyuli jingkijba, baki ngayu jingkijba ngaki Buwakanya. Nani barri ngayu jingkijba ngakinmuku, baki ngana yalu jingkijba. Jangaka janyba yalungi, maruka jala yalu muwa Kudkanyi. Jangaka janyba, baki nani jangayu marrimba yalunya barri mardarda. ");
INSERT INTO wrk_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Ngala yingkamuku yalu ngaki marda. Jilijba jayalu jungku nayiba mardarda ngakindu. Marda ngayimi wudumba yalunya. Jangayu marrimba yalunya nangangi Kudkanyi, barrinani jayalu mardarda jungku kalawunyi barrikina. Jayalu jingkijba ngaki jangkurr. Janganjalu durrijba. Jayalu jungku barrinani jibmuku ngaki, baki jangayu lalanba yalunya bukambiju. Nani barri jangayu marrimba kudukudu nganinymuku baki jibarrimuku nangangi Kudkanyi. Jayalu jungku Kudkanyi baki jangayu lalanba yalunya. ");
INSERT INTO wrk_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","Ngaki Buwakanya nyulu marukangka muwa ngaki. Marukangka nyulu muwa ngaki, jilajbangangi ngayi kingkarrinya wayka jambarri. Wajba jangaka ngakinkanyi mankankanyi janybikanyi ngaka. Janyba jangaka, ngala miku jangayu jungku kurdan yurrngumba. Miku. Jangayu walajba mili. Baki mili jangayu wankijba. Jangayu jungku nangandu ngakinyina Buwakayu. ");
INSERT INTO wrk_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Miku jangaka janyba, kurdanbangangi janganjalu yingkamukunyi. Jangaka janyba, wajbangangi jangaka mankankanyi yalungi, kurdanbikanyi nganjalu. Narri jala jungku nayiba wayka jambana, miku nganarriyanyi karu jilaykanyi nanginkurri, baki baku barri jangaka janyba. Miku nganarriyanyi karu nani. Ngayuman ngaka yanyba. Mikuwali narri jungku mambuka ngaki. Ngayuman mambuka ngaki. Ngakinyi Buwakayu ngana jirrinybayi yabimbikanyi yaji.” Barriwa. Nani barri yanybayi Jisus. ");
INSERT INTO wrk_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Jali yalu manku nanda jangkurr nangangi Jisuskanyi, jakakajba yalungki Jumuku nanganginbunanyi. ");
INSERT INTO wrk_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Yingkamuku yali yanyba, “Mudu nyulu mudu, wuwarrngangi jungkuka nangandu kalawunyi mankanyina. Nyulu mudu. Wanyingkanyi narri nangangi manku jangkurr. Wanyingkanyi. Mudu nyulu mudu.” ");
INSERT INTO wrk_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Ngala yingkamuku yali yanyba, “Miku nyulu mudu. Mikukimi jungku wuwarr nangandu kalawunyi mankanyina. Mikuwali wuwarr yanyba nanda jangkurr jala nyuli yanyba. Mikuwali wuwarrwanyi kunymamba kabuji, baki yuku nyulu najba yaji. Miku nyulu mudu.” Barriwa. ");
INSERT INTO wrk_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Nanamanji wurarawala, baki yali jilajba nanankurri Jirusalimyurri. Jilajba yali walkurrayngkurri jurjyurri wangarranyi, niji Didikajin. ");
INSERT INTO wrk_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Mardungujbayi yaji nanamanji wurarawala. Jilalajbangka Jisus walkurranyina jurjina. Jilalajbangka nyulu nananyina yajina niji “Sulumun nangangi Ngarndu.” ");
INSERT INTO wrk_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Baki kudiya Jumuku jilajba yali nangandurri. Karrinja yali lukuluku nangandu, baki yanyba yali nangangi, “Karukiyi nurrunya duja. Ninji kuna nayinda Krayis. Kurdadikiyi nurrunya yingijba, nurrungkaja mankumanku. Jaliyi ninji nayinda Krayis jali manjijba Kudwanyi, baki karu janinji nurrunya duja.” Barriwa. ");
INSERT INTO wrk_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Jananganjayi Jisuswanyi, “Wabula ngayi karu narrinya nanda jangkurr, ngajaka jali nganarri. Karu ngayi narrinya wabula, ngala miku narriyanyi kuyu ngaki jangkurr. Waki ngayu ngakinkanyi Buwakaya. Ngana nyuli jirrinyba, ngayu yabimbiji nayinda kaja ngiruka yaji. Baki nganarri najbayi jali ngayu yabimba nayinda ngiruka yaji. Marda miku nganarriya ngajaka nanankanyi jangkurranyi, ngayu kuna Krayis. Jali narri najba nayinda ngiruka yaji ngaki, baki marda nganarrimi jingkijba. Nanangi ngirukawanyi yajiwanyi karuyi narrinya ngaki. ");
INSERT INTO wrk_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","27","Ngala miku narrimi kuyu ngaki jangkurr, mikungangi narri barrinani ngakinmuku jibmuku. Nanangini lalanbawarranyi nyulu jingkijba yalunya nanganginmuku jibmuku, baki nanamuku jibmuku yalu jingkijba nanda jangkurr nangangi. Nani ngayu jingkijba yalunya, ngayu lalanba yalunya, kuyu jala yalu ngaki jangkurr. Ngala miku narrimi kuyu ngaki jangkurr. Nani miku narrimi barrinani ngakinmuku jibmuku, mikungangi narrimi kuyu ngaki jangkurr. Ngakinmukunyi, ngana yalu durrijba, ngala miku nganarrimi durrijba. Miku. ");
INSERT INTO wrk_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Jangayu mili wankamba yalunya bayngkani jalija yalungka janyba. Miku jayalungka mili janyba. Mili jayalu jungku wanka yurrngumba nangandu, ngakinyina Buwakaya. Mikuwali yingkawanyi dulaba yalunya ngakinbunanyi, lalanbangangi ngayu yalunya. Mikuwali yingkawanyi dulaba yalunya. ");
INSERT INTO wrk_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Ngakinyi Buwakayu, ngana nyuli yarrijba yalungi lalanbikanyi. Nyulu walkurra mambuka ngiruka bukambijuyngka, baki mikuwali yingkawanyi dulaba yalunya nanganbunanyi jala yalu jungku kunyba nangandu Buwakayu. Mikuwali yalunya yingkawanyi dulaba jala yalu durrijba Kud. ");
INSERT INTO wrk_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Ngaki Buwakanya marda ngayu, jungku ngali malumba. Ngayu barrinani nyulu, baki nanamannga nyulu barrinani ngayu. Malumba ngali jungku barrinani yingamali mambuka. Barriwa.” Nani yanybayi Jisus yalungi. ");
INSERT INTO wrk_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Ngala nanamukunyi Jumukunyi, miku yaliya kuyu nanda jangkurr nangangi Jisuskanyi. Ngamu yanybayi balki jangkurr nangangi Kudkanyi. Wudumba yali dungala janybiji nangandurri. Kurdanba yaliyanyi nanda Jisus, ngamungangi nyuli yanyba balki jangkurr Kudkanyi. ");
INSERT INTO wrk_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Baki yanybayi Jisus yalungi, “Yabimba ngayi kaja kunyba yaji ngiruka. Ngana nyuli jirrinyba yabimbiji yaji Buwakayu. Nulijba narri janybikanyi dungala ngakindurri, kurdanbikanyi ngana, yabimbangangi ngayi ngiruka yaji, ngala wanyi nayi ngiruka yaji. Janganarri daba, wanyingangi nayi ngiruka yaji jali ngayu yabimba.” Nani barri ngajakayi yalunya Jisuswanyi. ");
INSERT INTO wrk_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Jananganja yali Jisus, “Miku nurrimi nulijba janybikanyi dungala nganyindurri, yabimbangangi ninji kunyba yaji. Miku. Ngala nulijba nurru janybikanyi dungala nganyindurri, yanybangangi ninji balki jangkurr Kudkanyi. Yanyba ninji balki jangkurr, baki nanankardi janinya nurru daba. Ninji nganinyi, ngala yanyba nganyingki, ninji barrinani Kud. Nanankardi nurrimi janyba dungala nganyindurri, yanybangangi nganyingki, ninji barrinani Kud. Nanda balkimirra jangkurr. Barriwa.” ");
INSERT INTO wrk_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Jananganjayi yalunya Jisuswanyi, “Nanangini wankalawanyi, yarrijba nyuli jangkurr najana Kudkanyi. Nayinda jangkurr Kudkanyi nyuli yarrijba, ‘Ngayi yarrijba narrinya, narri walkurra mambuka. Barrinani Kud narri jungku. Narri yabimba nanda jala nyulu karu narrinya Kudwanyi. Nani narri barrinani Kud.’ ");
INSERT INTO wrk_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Nanda jangkurr najana Kudkanyi, nanda duja jangkurr yurrngumba, miku nangkiya yangkalamba. Nanda jali yarrijba jangkurr Kudkanyi, nyuli nijarrijba yalunya barrinani kudmuku. Nani nyuli nijarrijba yalunya, yalu barrinani kudmuku. ");
INSERT INTO wrk_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Ngala ngayu, yarrijba ngana Buwakayu, baki ngana nyuli manjijba wayka jambarri. Nyuli nijarrijba yalunya wankalamuku Kudwanyi, yalu barrinani kudmuku, ngala wanyingkanyi narri yanyba ngaki. Wanyingkanyi narri yanyba ngaki, ngayu jala yanyba balki jangkurr. Yanyba ngaka, ngayu Jandanyi Kudkanyi. Wanyingkanyi narri yanyba ngaki, nanda ngaki jangkurr balkimirra. Wanyingkanyi narri yanyba nani ngaki. ");
INSERT INTO wrk_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Jalimi miku ngayu yabimba ngiruka yaji nangangi, ngakinkanyi Buwakaya, baki marda narrimi miku kuyu ngaki jangkurr. Ngala ngayu yabimba ngiruka yaji nangangi ngakinkanyi Buwakaya. ");
INSERT INTO wrk_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Ngala jaliyi narri miku kuyu ngaki jangkurr, baki marda narrimi manku nanda ngiruka yaji jali ngayu yabimba narringi. Marda narrimi kuyu ngaki ngiruka yaji. Marda nganarrimi jingkijba, ngayu waki Kudkanyi, nyuli ngana manjijba wakinkanyi nangangi. Jaliyi narri jingkijba nyuli manjijba ngana Kudwanyi wakinkanyi nangangi, baki marda nganarrimi jingkijba, ngayu jungkuka nangandu ngakinyina Buwakayu, baki ngaki Buwakanya, nyulu jungkuka ngakindu. Malumba ngali jungku yurrngumba.” Barriwa. ");
INSERT INTO wrk_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Ngala yuwaji barri miku yaliya kuyu nangangi jangkurr. Baki wudumba yaliyanyi Jisus. Wudumba yaliyanyi kurdanbikanyi. Ngala miku yaliyi wudumba Jisus nanamanji. Barlba nyuli, baki miku yaliyi wudumba. ");
INSERT INTO wrk_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Barlba nyuli karri. Baki burrijba nyuli bundalina, niji Jurdan. Barlba nyuli karrurriji nanankurri yajiyurri jalili nyulu ngurrunba yalunya, nanangini Junwanyi Ngurrunbawarranyi. Nanaba nyulili ngurrunba yalunya wabula. Jilajbayi Jisus nanankurri yajiyurri. ");
INSERT INTO wrk_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Baki kajamuku badajba yali nanankurri nangandurri. Badajba yali nangandurri, baki yanyba yalungki, “Nanda Jun Ngurrunbawarr, jungku nyulili nayiba wabula. Miku nyuliyanyi yabimba ngiruka yaji. Miku. Ngala yanyba nyulili kunyba jangkurr nanginkanyi nganiyngkanyi, jali badajba bayngkani nangandu. Wabula nyuli yanyba kunyba jangkurr nangangi. Bukamba nanda jangkurr yanyba jali nyulu nanda ngurrunbawarr, bukamba nanda jangkurr nangangi duja.” Nani barri yalungki yanyba nangangi Jisuskanyi. ");
INSERT INTO wrk_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Marda kudukudu jali yalu jila nangandurri Jisusyurri, kuyu yali jangkurr nangangi. Barriwa. ");
INSERT INTO wrk_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Yingka nganinyi, niji nangangi Lasaris, jungku nyulili nananyina yajina bayangarrinybana. Yaji niji nanda Bidani. Lunji nyuli kudanyu. Jungku nyulili nanaba, marda kanyiyawuya nangangi jibarriwuya. Nanaba bulili jungku nangandu. Niji bulangi, Mari marda Marda. ");
INSERT INTO wrk_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Nanangini Mariwanyi, baku nyuli bindaba nanda yaji barrinani kunyba jirrki, niji nard. Baku nyuli bindaba nanda yaji nangandu nukamina Jisusnyina. Baki nambayi Jisus nukami jibarriwanyi nanganginjudinyi nyungkayudinyi. Waluwa lunjiyi buwanganja nangangi, ngala bayngkani bindabayi yaji nukamina Jisusnyina nanangini jibarriwanyi Mariwanyi. ");
INSERT INTO wrk_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Nanamanji jungkuyi Jisus yingkana yajina karru juju. Baki nanankujarranyi majukulanyi, manjijba buli yingka karrurriji. Manjijba buli yingka nangandurri Jisusyurri karrurri. Jilajbayi nanda yingka nangandurri, baki karuyi Jisus bulanginkanyi jangkurranyi, “Mambuka. Mirnarrijba ninji muwa bulanginkanyi buwaya, ngala nyulu lunjika nanda Lasaris. Lunjika nyulu kudanyu nanaba bayangarri.” ");
INSERT INTO wrk_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Jali nyulu manku nanda jangkurr, baki yanybayi Jisus nanganginmukuyngka kandimukuyngka, “Nanda Lasaris, lunjika nyulu kudanyu, baki janangka janyba. Ngala miku janyulu jungku kurdan yurrngumba. Ngala yingkamukunyi, jayalu jingkijba Kud. Jayalu jingkijba Kud, nyuluja ngiruka kudanyu, nyuluja walkurra mambuka. Yuku nyuluja yabimba bukamba yaji. Bukambijunyi jayalu jingkijba nani Kudkanyi, janybangangi nangkaja nanda Lasaris.” Nani barri yanybayi Jisus yalungi, nanganginmukuyngka kandimukuyngka. ");
INSERT INTO wrk_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Marukayi Jisus muwa yalungi, Lasariskanyi, marda nanankujarrayngka majukulayngka. Maruka nyuli muwa yalungi. ");
INSERT INTO wrk_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Jali yingkawanyi karu Jisus Lasariskanyi, jali nyulu lunji, yuwajiwa jungkuyi Jisus nayiba. Mili nyuli jungku nayiba kujarraka kambana. ");
INSERT INTO wrk_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Baki yanybayi Jisus yalungi nanganginkanyi kandimukuyngka, “Barriwa jangambala wijba bayangarri. Jangambala wijba Judiyayurri.” ");
INSERT INTO wrk_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Ngala nanganginmuku kandimuku marrala yali. Marrala yali baki yanyba yali Jisuskanyi, “Milidimbawarr, wujini yaliyanyi janyba dungala nganyindurri, kurdanbiji ninga. Jingkijba ninji, ninyaliya kurdanba, ngala yuwaji janinji wijba bayangarriji.” ");
INSERT INTO wrk_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","10","Yanybayi Jisus yalungi, “Nanangini kambawanyi, mirnmirnbaka yaji juju kambana, baki yuku ngambala jilalajba kambana. Miku ngambaliyi damalijba nayinda kambana, najbangangi ngambala yaji juju. Ngala jaliyi ngambala jilalajba mungana, baki damalijba ngambaliyi, mikungangi ngambaliyi najba yaji mungana. Mungijbangka yaji ngambalangi. Miku ngambaliyi waki Kudkanyi jala mungijba yaji. Jala ngayu jungku nayiba jambana, nanda barrinani kambana. Yuku ngayu waki Kudkanyi. Jalija ngaka janyba, baki nanda barrinani mungijba yaji, mikungangi ngayiyi waki mili. Nayimanji barrinani kambana yaji ngaki, baki yuku mili ngayu waki Kudkanyi. Jilijba jangaka janyba.” ");
INSERT INTO wrk_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Mili barri yanybayi Jisus yalungi, “Nanda ngambalangi kandi, Lasaris, kuluka nyulu nanijba. Kuluka nyulu, ngala ngayuja barlba nangandurri. Jangayu dulaba waykalinya, baki walajbaja ngakinkurri, baki jungkuja yaminnga.” ");
INSERT INTO wrk_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Jananganja yali Jisus, “Mambuka. Jaliyi nyulu kuluka, baki yuku barri. Janyulu kunybijba. Miku nyuliyi lunji mili.” ");
INSERT INTO wrk_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Miku yaliyanyi jingkijba nanda jangkurr Jisuskanyi kulukankanyi. Ngala Jisuswanyi, nyuli jingkijba nanda Lasaris, janyba nangki. Ngala muningka yanybayi Jisus yalungi, nyulu kulukangka Lasaris, baki nanankanyi barri ngamu nyuliya kulukawa Lasaris. ");
INSERT INTO wrk_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Baki mili yanybayi Jisus yalungi yurlurr, “Nanda kandi ngambalangi Lasaris, janyba nangki. ");
INSERT INTO wrk_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Ngala mirnarrijba ngayu muwa narringi, mikungangi ngayiyanyi jungku nangandu nanda waluwa jali nangka janyba. Mirnarrijba ngayu muwa narringi, najbangangi janarri yingka ngiruka yaji. Baki mili janarri kuyu ngaki jangkurr kudanyu. Barriwa ngambalaja nangandurri bayangarriji.” ");
INSERT INTO wrk_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Yingamali kandi nangangi Jisuskanyi, niji nangangi Dumas, baki yingka niji nangangi Didimus. Yanyba nyuli yalungi yingkamukuyngka kandimukuyngka, “Jangambala jilajba nangandu Jisusnyina, baki jangambala lalanba Jisus. Jaliyi yalu kurdanba Jisus, waluwa ngamanjalu kurdanbaja.” ");
INSERT INTO wrk_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Wijba yali bayangarriji Judiyayurri, Jisus marda nanganginmuku kandimuku. Wanbiya yali Bidani. Ngala janyba nangki nanda Lasaris wujini, kujarra baki kujarra kambana wabula. Yarrijba yali mankanyi nangangi kumayanguna. ");
INSERT INTO wrk_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Nanda yaji Bidani karriya bundu nananyina barrawuyabarrawuyana Jirusalim. Bundu barri, kujarra mil karriya. ");
INSERT INTO wrk_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Baki kudukudu Jumuku yali jilajba nanamunanyi yajinanyi Jirusalimnanyi. Jilajba yali Bidaniyurri. Yidamba yali bulanya majukula nganinyiyurruwa. Yidamba yali bulanya ngindunki bulandu, janybangangi nangki bulangi buwanya. Kudukudu yali jungku bulandu. Ngindu yali bulangi. ");
INSERT INTO wrk_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Ngala badajbayi Jisus nayinda bundu, karuyi yingkawanyi nanda jibarri burrandinyi niji Marda. Karu nyuli Jisuskanyi, badajbangka nayinda. Baki jilajbayi nanda jibarri nangandurri Jisusyurri, ngala nanda kanyiya nangangi niji Mari, yuwaji nyuli jungku barndana. Jungku nyuli nanaba barndana, ngala nanda majunganja nangangi, jilajba nyuli nangandurri Jisusyurri. ");
INSERT INTO wrk_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Jala nyuli wanbiya Jisusnyina, yanybayi nanda jibarri nangangi, “Mambuka. Buwanya ngalingi, janyba nangki. Janyba nangki ngalingi. Warriyaluku. Jaliyanyi ninji badajba wabula, bakiya nangka miku janyba. Jaliyanyi ninji jungku nayiba nurrundu, baki miku nangkiyanyi janyba. Warriyaluku. ");
INSERT INTO wrk_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Ngala ngayu jingkijba Kud. Janyulu yabimba nanda yaji, jalija ninji ngajaka Kud yabimbikanyi yaji. Janyulu yabimba bukamba yaji jalija ninji nulijba nangangi yabimbikanyi yaji. Nani ngayu jingkijba.” Barriwa. ");
INSERT INTO wrk_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Yanybayi Jisus nangangi, “Marda ninjimi miku ngindu mili nganyingkurruwa buwanganjarruwa. Marda ninjimi miku ngindu mili nangangi. Janyulu wankijba mili. Janyulu walajba baki janyulu mili wanka jungku.” Barriwa. ");
INSERT INTO wrk_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Jananganjayi Jisus jibarriwanyi, “Jingkijba ngayu Kud. Janyulu wankamba ngambalanya nanamanji baku barri juju. Janyulu marda walajba nanamanji ngalinginkurru buwanganjarru. Janyulu jungku wanka nangandu Kudnyina yurrngumba nanamanji baku.” ");
INSERT INTO wrk_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Yanybayi Jisus nangangi, “Ngayu, ngayuman jala ngayu wankamba yalunya jala yalungka janyba. Nanda jala kuyu ngaki jangkurr, janyulu wankijba mili. Jalija nangka janyba, janyulu wankijba mili. Janyulu jungku wanka yurrngumba Kudnyina. ");
INSERT INTO wrk_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Baki nanda jala wanka jungku, jala kuyu ngaki jangkurr, miku nangkiyi janyba. Kuyu kuna ninji nayinda jangkurr ngaki wankiykanyi mili.” ");
INSERT INTO wrk_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Jananganjayi Jisus jibarriwanyi, “Mambuka, yuku ngayu kuyu nganyi jangkurr. Jingkijba ninga, ninji nanda Krayis, nanda jandanyi Kudkanyi. Manjijba ninga Kudwanyi. Nanamukunyi wankalawanyi, yarrijba yali jangkurr nganyi najana Kudkanyi. Nanda jangkurr yanybayi, janinji jilajba jambarri. Janinji jilajba Kudnanyi nayiba wayka jambarri. Kuyu ngayu nganyi jangkurr, ninji badajbayi Kudnanyi.” ");
INSERT INTO wrk_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Nani yanybayi nanda jibarri, nanda burrandinyi, baki nyuli wijba nanganginkurri kanyiyarri barndarri. Kuyu nyuli nangangi kanyiya nyubarri, baki yanyba bulangki kardarda. Yanyba nyuli, “Nanda Milidimbawarr, wanbiyayi bundu nayiba, baki nulijba nyulu yanybikanyi nganyi nanaba.” ");
INSERT INTO wrk_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Jali nyulu manku nanda jangkurr kanyiyawanyi, baki walajba nyuli. Walajba nyuli dulu, baki jilajbayi danbiyurri. Jilajba nyuli karri nangandurri Jisusyurri. ");
INSERT INTO wrk_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Jilijba wanbiyayi Jisus barndana. Yuwaji nyuli jungku nananyina yajina jali yanyba yingka jibarri nangangi barrin. Jungku nyuli nananyina yajina. ");
INSERT INTO wrk_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Nanamuku Jumuku jungku jali yalu barndana, ngindu jali yalu bulangi nanankujarrayngka majukulayngka, walajba yali marda. Jilajba yali bayngkani nangandu marda, ngamungangi janyulu jilajba kumayangurri. Ngamu janyulu jilajba nanankurri kumayangurri jali yalu makaba buwayankurru, ngindunki nanaba. Ngala miku. Jilajba nyuli Jisusyurri, baki durrijba yali bulanya, nanankujarra majukula nangandurri Jisusyurri. ");
INSERT INTO wrk_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Jala buli wanbiya nangandu Jisusnyina, jilajbayi nanda kanyiya nangandurri. Mururu nyuli wayka nukamina Jisusnyina. Mururu nyuli wayka baki yanybayi Jisuskanyi, “Mambuka, janyba nangki ngalingi buwanya. Jaliyanyi ninji jungku nayiba wabula, baki miku nangkiyanyi janyba. Jaliyanyi ninji jungku nayiba, ngala nyuli lunji, baki yuwaji nyuliyanyi wanka jungku.” ");
INSERT INTO wrk_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Baki nginduyi nanda jibarri, nanda kanyiya nangangi kudanyu. Ngindu nyuli mirlarryudi. Nanamuku Jumuku badajba jali bayngkani nangandu, marda yali ngindu mirlarryudi. Najba nyuli yalunya ngindunkurri Jisuswanyi, baki ngindu nyuli muwa yalungi. Ngindu nyuli muwa kudanyu yalungi. ");
INSERT INTO wrk_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Baki nyuli ngajaka bulanya majukula, “Wanjawa nanda nganinyiyurruwa mankanyi. Wanjawa nimbali yarrijba nangangi mankanyi.” Jananganja buli Jisus, “Mambuka. Barriwa ngambalaja barlba. Janinya ngali milidimba nanankanyi kumayangunyi, yarrijba jali yalu mankanyi kalawuyngkurru.” Nani buli yanyba nangangi Jisuskanyi, ");
INSERT INTO wrk_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","baki nginduyi Jisus nangangi mirlarryudi. Ngindu nyuli kudanyu nangangi. ");
INSERT INTO wrk_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Baki nanamuku yingkamuku jala yali karrinja nangandu, najba yali Jisus ngindunkurri, baki yanyba yalungki, “Yabijba nyuli muwa nangangi nganinyiyurruwa wabula, baki nanankanyi nanijba barri nyulu nginduka muwa kudanyu barri nangangi. ");
INSERT INTO wrk_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Ngala yingkamuku yanyba yalungki, “Kunymamba nyuli nanda kabuji yami Jisuswanyi. Jaliyanyi jungku Jisus nayiba, baki yiningki nyuliyanyi kurrkunba nanankurru nganinyiyurru janybikanyi nangka.” Nani barri yalungki yanyba Jumuku. ");
INSERT INTO wrk_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Mili nginduyi Jisus kudanyu yalungi, baki jilajba nyuli bulandu kumayangurri. Wujini, jali yalu yarrijba nangangi mankanyi kalawuyngkurru kumayanguna, murumba yali bardawa walkurranyina dungalana. Yarrijba yali nanda walkurra dungala waluwa kumayanguna bardawana. Barriwa. Wanbiya yali kumayanguna. ");
INSERT INTO wrk_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Baki jirrinybayi yalunya Jisuswanyi, “Dulabakiyi nanda dungala bardawananyi.” Ngala jananganjayi nanangini jibarriwanyi burrandinyiwanyi, “Mambuka, buwayankurru ngalingi, kili nyuli kurdan kujarrana kambana baki kujarrana. Ngujbulijbaka mankanyi nangangi. Banjawaka ngujbul kudu nangangi. Warriyaluku.” ");
INSERT INTO wrk_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Yanybayi Jisus nangangi, “Barrin ninga karuyi nayi. Jaliyi ninji kuyu ngaki jangkurr, baki janinji najba nanda walkurra yaji ngiruka, jalija yabimba Kudwanyi. Janyulu yabimba ngiruka yaji, jaliyi ninji kuyu nanda jangkurr ngaki.” Barriwa. ");
INSERT INTO wrk_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Baki dulaba yali nanda dungala kumayangunanyi. Dulaba yali dungala. Dimbilijba nyuli yami Jisus kingkarri lalijiyurri, baki yanybayi Jisus, “Buwakanya kingkarri, mirnarrijba ngayu muwa nganyi, mankungangi ninji ngaki jangkurr. ");
INSERT INTO wrk_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Jingkijba ninga, ninji mankuka ngaki jangkurr yurrngumba. Ngala ngayu yanybaka nayinda jangkurr nanijba, baki nanginmukunyi jungku jala yalu nayiba ngakindu, jayalu manku nayinda jangkurr marda. Yanyba ngayu nayi, baki nanginmukunyi ninya yalu jingkijba, nganinji manjijbayi nanginkurri.” ");
INSERT INTO wrk_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Nani barri yanybayi Jisus, baki yanyba nyuli kudanyu nanankanyi nganinyiyurruwa, “Ninji, Lasaris, walajbakiyi. Walajbakiyi nanankardi kumayangunanyi.” ");
INSERT INTO wrk_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Baki walajbayi nanda nganinyiyurru. Karrinjayi danbina. Waluwa yali kijijba mankanyi lukuluku bukamba wayka nukamiyurruwa rakiyudinyi. Nani barri Jumukunyi, yalili kijijba mankanyi waluwa yali yarrijba kumayanguna. Kijijba yalili mankanyi rakina. Barriwa. Walajbayi nanda Lasaris, ngala nyuli yuwajiwa munburr rakiyudi marniyurru, baki nukamiyurru, baki yingka raki nyuli lukuluku kulajina. Baki jirrinybayi yalunya Jisuswanyi, “Dulabakiyi nanda raki nanganbunanyi walinanyi, marda mankanyinanyi. Dulabakiyi nanda raki baki janyulu jilalajba.” Barriwa. ");
INSERT INTO wrk_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Kajamuku Jumuku, jali jilajba kumayangurri nangandu nanaba kanyiyana, najba yali nanda jali yabimba Jisuswanyi. Najba yali Jisus, wankambikurri nanda nganinyiyurru, baki kuyu yali nangangi jangkurr Jisuskanyi. Kajamukunyi Jumukunyi yali kuyu nangangi jangkurr. Jingkijba yali Jisus, nyuli walkurra mambuka Kudkanyi. ");
INSERT INTO wrk_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Ngala yingkamuku, miku jaliyanyi yalu kuyu nangangi jangkurr, wijba yali bayungu Jirusalimyurri, baki karu yali nanamuku Barasimuku Jisuskanyi. Karu yalunjali nanankanyi yajinyi jali yabimba Jisuswanyi, jali nyulu wankamba nanda nganinyiyurru. Barriwa. ");
INSERT INTO wrk_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Baki nanankardi barri, Barasimukunyi marda walkurrawanyi mambukamukunyi jurjkanyi, karu yalunjali malbumalbu kunsilkanyi, yanybikanyi yalungka malumba. Jungku yali, baki yanyba yalungki malumba, “Wanyimba jangambala. Yabimba nyuli kaja yaji ngiruka ngambalangi. Wanyimba jangambala nangangi Jisuskanyi. ");
INSERT INTO wrk_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Jaliyi nyulu mili yabimba ngiruka yaji ngambalangi, baki kudukuduwanyi jayalu kuyu nangangi jangkurr. Bukambijunyi jayalu kuyu nangangi jangkurr. Ngala ngurranyimuku Rumankanyi yalu mambukamuku ngambalangi. Jayalu dalyamba nayinda ngambalangi walkurra jurj, jaliyi yalu kudukudumukunyi kuyu nangangi jangkurr. Nayinda walkurra jurj ngambalangi, miku ngurranyimukuyngka. Kudukudu yalungi nayinda jurj. Ngala ngurranyimukunyi, jayalu dalyamba nayinda walkurra jurj. Jayalu linjumba ngambalanya. Yiningki jangamanjalu kurdanba jaliyi yalu kudukudumukunyi kuyu jangkurr Jisuskanyi. Marda ngambalimi kurrkunba nanda Jisus, mikuwali yabimba mili ngiruka yaji. Marda ngambalimi kurrkunba.” ");
INSERT INTO wrk_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Nanda walkurramirra mambuka jurjkanyi, nangangi niji Kayabas. Nanamanji nyuli jungku walkurramirra mambuka jurjkanyi. Yanyba nyuli yalungi, “Narri malbumalbumuku, miku narriyi jingkijba nanda jalija ngambala yabimba. Miku narriyi nulijba nanankanyi jangkurranyi yurlurrmba. ");
INSERT INTO wrk_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Marda narrimi jingkijba nayi. Nanda Jisus, marda nangkimi janyba. Jaliyi nangka janyba, baki miku nyuliyi yabimba mili kiji ngambalangi. Baki miku ngamanjaliyi linjumba nanamukunyi mambukamukunyi Rumankanyi. Marda nangkimi janyba, baki miku ngamangkiyi janyba.” Nani yanybayi walkurramirra mambuka jurjkanyi. ");
INSERT INTO wrk_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Ngala miku nyuliya yanyba nani nyuluman. Miku. Kudiyana nanda walkurramirra mambuka jurjkanyi, kudiyana yuku nyuli yanyba jangkurr Kudkanyi. Nanda jangkurr, yanyba jali nyulu nanamanji, nanda jangkurr duja jangkurr nangangi Kudkanyi. Yanyba nyuli Jisuskanyi, janangka janyba, ngala nanganginmuku mungkijimuku jayalu jungku mardarda. ");
INSERT INTO wrk_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Baki yingkamuku bukambiju wandijiyana, maruka jala yalu muwa Kudkanyi, marda jayalu jungku mardarda. Janyulu marrimba yalunya mardarda yurrngumba Kudwanyi. Janangka janyba nanda Jisus, baki bukambiju wandijiyana, jala maruka muwa Kudkanyi, jayalu jungku barrinani mungkijimuku nangangi. Jayalu jungku barrinani jandanyimuku nangangi Kudkanyi. ");
INSERT INTO wrk_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Baki yurrngumba nanankardi jali yanyba walkurra mambuka jurjkanyi nani, yurrngumba nanankardi yaliyanyi kurdanba Jisus mambukamukunyi Jukanyi. Yilikajba yalungki, yanka jayalu kurdanba Jisus. Barriwa. ");
INSERT INTO wrk_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Baki mikukiyanyi jilalajba Jisus mili nananyina yajina Judiya, ngala barlba nyuli nanamunanyi yajinanyi. Barlba nyuli langki yingkayurri yajiyurri, niji Yibrayim. Nanda yaji Yibrayim, bundu mangkurruna yajina. Jungku nyuli nanaba, marda nanganginmuku kandimuku yali nanaba nangandu. ");
INSERT INTO wrk_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Winyurruwa janyulu wangarr yalungi Jumukuyngka niji Kangandijbayi Barrawuna Yajinyi, jalili yalu jarrba nanda bulungu jibkanyi, baki damba ngala nyulu mikuyaji bululunyi. Kajamuku Jumuku yali jilajba Jirusalimyurri. Jilajba yali langina, kulani, karrina bayunguna nanankurri Jirusalimyurri. Jilajba yali nanankanyi wangarranyi jarrkanyi yaji. Baki wakardaba yalungki mankanyi wangarranyi. Nani yalungki birrirrinja mankanyi wangarranyi, jali yalungka wakardaba mankanyi. ");
INSERT INTO wrk_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Jilajba yali Jirusalimyurri wangarranyi, baki bayiwujba yali Jisuskanyi muramuku. Bayiwujba yali nangangi. Yililikajba yalungki, “Yanka janinji ninji yanyba nangangi Jisuskanyi. Miku kunawali jilajba nanginkurri wangarranyi. Marralangka kuna jilaykanyi nanginkurri.” Nani yalungki yililikajba nangangi Jisuskanyi. ");
INSERT INTO wrk_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Jirrinybayi yalunjalu mambukamukunyi jurjkanyi marda Barasimukunyi. Jirrinyba yalunjali, “Narri nayiba Jirusalim. Jaliyi narri najba nanda Jisus, baki karu janarri nurrunya nangangi Jisuskanyi. Janurru jilajba wudumbiji Jisus.” Nani barri jirrinyba yalunya mambukamukunyi jurjkanyi marda Barasimukunyi, wudumbangangi yaliyanyi Jisus kurdanbiji Jisus. Barriwa. ");
INSERT INTO wrk_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Waluwa nanda wangarr, kujarra kambana, baki kujarra baki kujarra waluwa nanda wangarr, nanamanji, jilajbayi Jisus karri Bidaniyurri. Jilajba nyuli nanankurri yajiyurri, jalili jungku Lasaris nanaba yajina. Nanda Lasaris, nyuli nanda, wankamba jali Jisuswanyi bayngkani jali nangka janyba. Jilajbayi Jisus nanganginkurri barndarri Lasariskanyi. ");
INSERT INTO wrk_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Yundijba buli mama nangangi Jisuskanyi majukulanyi Lasariskanyi. Yundijba buli mama. Baki nanangini burrandinyiwanyi, niji Marda, nyuli wajba yalunya mamanyi. Kudukudu yali malumba jungku, Lasaris, marda Jisus, marda nanganginmuku kandimuku. Jungku yali malumba baki jarrba yali nanda mama jali wajba jibarriwanyi Mardawanyi. ");
INSERT INTO wrk_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Ngala nanda kanyiya, niji Mari, wudumba nyuli bujili. Kalawunyi bujilina nanda barrinani jirrki, ngala nanjananja. Banjawayi kunyba kudu. Nijarrijba yalu nanda yaji Nard. Nanamanji yalili yarrijba nard nganinyiyurrunyina mankanyina Jumukunyi, waluwa yalili makaba mankanyi. Wajbayi kajanyi dungalanyi jibarriwanyi, baki wudumba nyuli nanda Nard. Bindabayi nard nukamina Jisusnyina, baki namba nyuli Jisus nukami jibarriwanyi. Namba nyuli Jisus nukami nanganginjudinyi nyungkayudinyi. Banjawayi nanda kunyba kudu lukuluku barrawuna. Kunyba nanda kudu banjawayi. ");
INSERT INTO wrk_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","5","Ngala ngirrwayi jibarri yingamaliwanyi kandiwanyi Jisuskanyi. Yanyba nyuli, “Wanyingkanyi nyuli bindaba nukami nananyina nardnyina. Kunyba nanda nard. Jaliyanyi nanda nurrungi, baki nurriyanyi wajba yalunya nardkanyi dungalanyi. Nurriyanyi wudumba kudukudu dungala 300 dula nanankanyi nardkanyi. Baki nurriyanyi wajba yalunya nanankanyi dungalanyi, yalunya jala mikuyaji yalungi dungalanyi.” Nani yanybayi nanda kandi Jisuskanyi, niji Judas Yiskariyud. Baku barri bijal nanangini Judaswanyi, nyuli wudumba dungala mambukananyi jurjkanyi. Karu nyuli nanda mambuka wanjawa jayalu wakaramba Jisus, baki wudumba nyuli dungala karunkanyi. ");
INSERT INTO wrk_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Yanyba nyuli nanda jangkurr waykanyi yalunya nardkanyi dungalana, ngala miku nyuliyala wajba yingkamuku nanankanyi dungalanyi. Miku. Nulijba nyuli maninjakuykanyi nanda dungala. Nyulili marrimba nanda bindawarra dungalayudi. Nyulili lalanbawarr dungalanyi yalungi. Ngala nyulili maninjaku. Kuyu nyulili jawuda dungala nanganginmirra. Nulijba nyuli maninjakuykanyi nanda dungala. ");
INSERT INTO wrk_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","8","Ngala yanybayi Jisus nangangi Judaskanyi, “Yingijbakiyi nanda jibarri. Mikujiyi ngirrwa nangangi. Mikujiyi yabimba kiji nangangi. Nyulu yabimbaka kunyba yaji ngaki. Jawuda nanda jala mikuyaji yalungi dungalanyi, yurrngumba yalu jungku narrindu. Yurrngumba yuku narri lalanba yalunya, jala mikuyaji dungalanyi yalungi. Yalu narrindu yurrngumba. Ngala miku ngayiyi jungku nayiba narrindu yurrngumba. Mikujiyi ngirrwa nangangi jibarrinyi. Kili nyuli nanda kunyba nard, yarriykanyi ngakinyina mankanyina waluwa jayalu makaba ngaki mankanyi.” Barriwa. ");
INSERT INTO wrk_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Kudiyawanyi yalunjali karu yingkamuku Jumuku nangangi Jisuskanyi, nyuli jungku nanaba barndana Lasariskanyi. Karu yalunjali Jisuskanyi, nanamanji nyuli jungku nanaba Bidani nangandu. Baki kudukudu Jumuku, jilajba yali Bidaniyurri naji bulanya. Yaliyanyi najba bulanya, Jisus marda nanda Lasaris jali wankamba mili Jisuswanyi wujini. ");
INSERT INTO wrk_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","11","Baki kajamukunyi Jumukunyi durrijba yali nanda jangkurr Jisuskanyi, wankambangangi nyuli nanda Lasaris. Ngala nanamuku mambukamuku jurjkanyi, mankumanku yalungki, kurdanbikanyi bulanya, Jisus baki Lasaris. Yaliyanyi kurdanba bulanya, kajamukunyingangi yali durrijba jangkurr Jisuskanyi. Durrijba yali jangkurr Jisuskanyi, wankambangangi nyuli nanda Lasaris. Miku yaliyanyi mili durrijba jangkurr mambukamukuyngka, ngala durrijba yali nanda jangkurr Jisuskanyi. ");
INSERT INTO wrk_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Bindabayi nard nangandu Jisusnyina jibarriwanyi, baki munganawa kajamukunyi Jumukunyi, jilajba jali Jirusalimyurri wangarranyi, manku yali Jisuskanyi, nyulu badajbangka nanankurri Jirusalimyurri, jali yalu jungku. ");
INSERT INTO wrk_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Baki yali dalyamba kaja wanjirr. Kuyu yali danbiyurri barrikiyurri Jirusalimkanyi. Jilajba yali danbiyurri madamadambiji yalungki karru. Kawanyba yali wanjirryudinyi, marda kaya yali Jisuskanyi wanjirryudi. Kaya yali kudanyu, “Yanyba nurru kunyba jangkurr nganyi Kud. Ngajaka ninga, janinji yabimba kunyba yaji nangangi Jisuskanyi. Nyulu walkurramirra mambuka nurrungi Jumukuyngka. Mirnarrijba nurru muwa nangangi Jisuskanyi.” Nani barri yali kaya Jisuskanyi, ngala nyuli jilajba yalunbiyangka. ");
INSERT INTO wrk_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Wudumba nyuli yirrikirri Jisuswanyi, jungku nyuli ngulurrina, baki jilajba nyuli bayungu Jirusalimyurri yirrikirriyudi. Nayi barri yanybayi nanda wankalanyi jangkurr najana Kudkanyi. ");
INSERT INTO wrk_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","“Mikujiyi marrala, narri jala jungku Jirusalim. Mikujiyi marrala. Badajbangka nanginkurri narringi mambuka walkurramirra. Badajbangka nyulu yirrikirriyudi.” Nani barri nyuli yarrijba nanda jangkurr Kudkanyi wankalawanyi. Duja nanda jangkurr. Duja. ");
INSERT INTO wrk_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Ngala miku yaliyanyi jingkijba yaji nanamanji kandimukunyi Jisuskanyi. Miku yaliyanyi jingkijba yaji nanamanji. Ngala baku barri, bayngkani jali nangka janyba Jisus, yali mankuwa jangkurr yirrikirrinyi. Jali wijba Jisus kingkarri Kudyurri, baki yali mankuwa nanda jangkurr yirrikirrinyi najana Kudkanyi, kandimukunyi. Mankuwa yali jali yalu wudumba nanda yirrikirri nangangi Jisuskanyi. Baki mankuwa yali nanda wankalanyi jangkurranyi. Duja nanda jangkurr. ");
INSERT INTO wrk_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","18","Nanamuku Jumuku, najba jali yalu Jisus wankambikurri nanda Lasaris wujini, wijba yali bayangarriji Jirusalimyurri. Karu yali yingkamuku Jisuskanyi jali nyulu wankamba nanda Lasaris. Karu yalunjali mura Jisuskanyi, jali nyulu yabimba nanda yaji ngiruka, baki yaliyanyi najba Jisus marda murawanyi. ");
INSERT INTO wrk_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Nanamuku Barasimuku, jali yalu najba muran durriykurri Jisus, baki yanyba yalungki, “Kajawanyi murawanyi, yalu durrijbangka nanda Jisus. Bukambijunyi yalu durrijbangka Jisus. Miku ngambaliyi kurrkunba yalunya. Bukambijunyi yalu kuyu nanda, mambuka nyulu yalungi. Miku ngambaliyi kurrkunba yalunya.” Barriwa. ");
INSERT INTO wrk_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Kudiyamuku kudu yalungi Krik, badajba yali Jirusalimyurri wangarranyi. Badajba yali yanybiji mududu Kudkanyi, marda briji Kudkanyi. ");
INSERT INTO wrk_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Jilajba yali kandiyurri Jisuskanyi, niji nangangi Bilib. Nanda Bilib, nangangi yaji Bidsayida, nananyina walkurranyina yajina Kalili. Jila yali nangandurri Bilibyurri nanamuku Krikmuku, baki yanyba yali nangangi, “Mambuka. Najba nurrimi nanda Jisus. Yanyba nurrimi nangangi.” Barriwa. ");
INSERT INTO wrk_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Baki jilajbayi Bilib yingkayurri kandiyurri Yandruyurri. Karu nyuli Yandru yalungi Krikmukuyngka, yalimi najba Jisus. Baki jilajba buli Jisusyurri. Karu buli Jisus yalungi Krikmukuyngka, yalimi yanyba nangangi. ");
INSERT INTO wrk_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Jananganjayi bulanya Jisuswanyi, “Nayimanji, bukambijunyi janganjalu najba, ngayu Buwanya Bukambijuyngka, ngayu walkurramirra mambuka. Milidimba janyulu yalunya nayi Kudwanyi, ngayu Buwanya Bukambijuyngka. ");
INSERT INTO wrk_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Yanyba ngayu duja jangkurr. Nanda daburrul yami, yaliyi jungku muningka nanda yami, baki mikuwali jardijba. Mikuwali jungku baku yingkayudi yamiyudi. Ngala jala yalu yarrijba nanda daburrul yami jambana, baki janyba nangka yami kalawuyngkurru jambana. Jala nangka janyba yami, baki walajbangka wuju baku barri bayngkani. Nanda daburrul jardijbangka walkurra, baki baku barri nyulu jungkuka kajayudi yamiyudi. Yalu wudumba nanda yami jarrkanyi. Ngayu barrinani nanda daburrul yami, jala nangka janyba. Jangaka janyba nani barri. Ngala mili jayalu jardijba nganinyimuku baki jibarrimuku Kudkanyi. Jayalu maruka muwa nangangi Kudkanyi. Jayalu durrijba ngaki jangkurr jalija ngaka janyba. Nani ngayu barrinani nanda daburrul yami. ");
INSERT INTO wrk_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Jaliyi maruka nangka muwa nganinyi, baki miku nyulimi maruka muwa yingkamukuyngka, baki miku nyulimi maruka muwa Kudkanyi. Jungkuka nyulu balkina yuwana Kudkanyi, jala nangka maruka muwa. Janangka janyba, ngala miku nyuliyi wankijba mili. Miku. Ngala nanda jala nangka miku maruka muwa, jala maruka muwa Kudkanyi, nyulu jungkuka kunybana yuwana Kudkanyi. Nyulu yabimbaka yaji, nanankanyi jala nulijba Kud. Nyulu durrijbangka Kud, baki janyulu wankamba nanda baku Kudwanyi. Janyulu jungku wanka nangandu Kudnyina, bayngkani jalija nangka janyba. ");
INSERT INTO wrk_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Nanda jala nulijba wakinkanyi ngaki, marda nyulimi durrijba ngana, marda nyulimi jilajba ngakindu yurrngumba. Ngakinyi Buwakayu, janyulu yabimba kunyba yaji nanankanyi jala waki ngaki. Kunyba yaji janyulu yabimba nangangi ngakinyi Buwakayu. ");
INSERT INTO wrk_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","Ngindu ngaka muwa, kijingangi ngakindu. Ngaki Buwakanya, nyulu nulijbangka ngaki, yabimbikanyi wanyi yaji. Wanyingkanyi janga ngakaja ngaki buwakanya. Nayinda kuna. ‘Buwakanya. Janganinji lalanba kuna. Janinji kuna janyba nanda kiji ngakinbunanyi. Janganinji kuna marrimba mardarda.’ Nani kuna jangayu ngajaka. Ngala miku ngayiyi ngajaka nani. Miku, manjijbangangi ngani Kudwanyi. Ngani manjijba nanginkurri yajiyurri. Janganjalu linjumba kudanyu. Janganjalu kurdanba kudanyu. ");
INSERT INTO wrk_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Buwakanya, yabimbakiyi yalunya jingkiykanyi ninyalu, ninji walkurra mambuka, walkurramirra. Buwakanya, yabimbakiyi nanda yaji yalungi.” Nani yanybayi Jisus. Baki yali jala karrinja nangandu, manku yali jangkurr lalijinanyi. Lalijinanyi yali manku nayinda jangkurr Buwakaya. Nayi yali manku kingkarrinya, “Wabula ngayi minimba yalunya walkurra yaji ngiruka. Baki mili jangaka minimba yalungi, ngayu walkurramirra mambuka. Yuku ngayu yabimba bukamba yaji ngiruka.” Nani yali manku jangkurr lalijinanyi. ");
INSERT INTO wrk_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Kajamuku nganinyimuku marda jibarrimuku, karrinja jali yalu nanaba nangandu Jisusnyina, manku yali nanda jangkurr. Yingkamuku yalungki yanyba, “Ngurrwangka yaji. Ngurrwangka.” Ngala yingkamuku yalungki yanyba, “Yanybayi Yanjil nangangi Jisuskanyi. Nanda Yanjil jali waki nangangi Kudkanyi yanybayi nangangi Jisuskanyi.” ");
INSERT INTO wrk_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Ngala yanybayi Jisus yalungi muranyi, “Miku nyuliya yanyba nanda jangkurr ngaki, ngayu mankunkanyi. Miku. Ngala nyuli yanyba nanda jangkurr narringi, narri mankunkanyi nanda jangkurr. ");
INSERT INTO wrk_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Nanijba janyulu karrinjarrijba narrinya Kudwanyi. Janyulu karrinjarrijba narrinya bukambiju wandijiyana walu nangandu, baki janyulu yanyba nanda jalija nyulu yabimba narringi. Yingkamukuyngka janyulu yanyba yalungi, ‘Narri, narri kunyba. Narri durrijba ngakinyina yuwana.’ Ngala yingkamukuyngka janyulu yanyba yalungi, ‘Miku narri durrijba ngakinyina yuwana. Jungka narri balki ngaki’. Nani barri janyulu karrinjarrijba bukambiju. Baki mili janyulu yanyba Kud. Janyulu yanyba wuwarranyi Sayidinkanyi, ‘Miku ninjiyi mili jungku walkurra mambuka. Miku. Jungku janinji bayakarda wuwarr.’ Nani barri Kud janyulu yanyba nangangi Sayidinkanyi, mambukanyi wuwarranyi. Janyulu manjijba Sayidin juju. ");
INSERT INTO wrk_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Janganjalu langandaba. Ngala jayalungka mankumanku ngaki bayngkani jalija ngaka janyba. Jayalungka mankumanku ngaki bukambiju wandijiyana. Jangayu yarrijba ngaki jangkurr yalunginyina ngaluna. Baki jayalungka mankumanku ngaki.” Barriwa. ");
INSERT INTO wrk_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Nani barri yanybayi Jisus, yalu langandaykanyi mankanyi nangangi. Yanyba nyuli nani yalungi, jingkijbangangi nyuli, jayalu langandaba mankanyi nangangi kurndana kurdanbikanyi. Baki nanankardi barri nyuli karu yalunya nani, yalu langandaykanyi nangangi mankanyi. ");
INSERT INTO wrk_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Ngajaka yali nangangi, murawanyi, “Nanda yuwa Musiskanyi yanybayi nayi Krayiskanyi, ‘Janyulu jungku wanka yurrngumba. Miku janangkiyi janyba.’ Ngala ninji yanyba nangangi Buwaya Bukambijuyngka, jayalu langandaba nanda. Wanyi nyuli nanda, Buwanya Bukambijuyngka. Wanyi nyulu.” Nani yali yanyba nangangi nanamuku jali yalu karrinja nanaba nangandu Jisusnyina. ");
INSERT INTO wrk_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","36a","Jananganjayi yalunya Jisuswanyi, “Jala narri jilalajba mungana, miku narriyi najba yaji. Miku narriyi jingkijba nanda yaji jala narri jilalajba. Miku narri jingkijba nanda yaji jilaykanyi jala mungijbangka yaji. Ngala jala mirnmirnbaka yaji mirnbiwanyi, baki yuku narri jingkijba nanda yaji. Jingkijba narri nanda yaji, jilaykanyi. Ngayu barrinani nanda mirnbi. Minimba ngayu narrinya jilaykanyi. Minimba ngayu narrinya yabimbikanyi kunyba yaji, jungungkanyi kunyba Kudkanyi. Mili jangayu jungku narrindu marndakaja. Jala ngayu jungku narrindu, baki nanda barrinani kambana yajina. Yuku narri durrijba ngaki jangkurr. Baku barri, miku ngayiyi jungku narrindu, ngala yuwaji janarri jingkijba ngaki yaji. Yuwaji janarri jingkijba jungunkanyi kunybana ngakinyina yuwana, durriykanyi ngaki jangkurr. Janarri jungku barrinani yalunya jala yalu jilalajba kambana yajina. Marda narrimi durrijba ngaki jangkurr yurrngumba, ngala ngayu jungku narrindu, baki ngala ngayimi miku jungku narrindu. Marda narrimi durrijba ngaki jangkurr yurrngumba.” Nani barri milidimbayi yalunya Jisuswanyi, mirnbinyi. ");
INSERT INTO wrk_vpl VALUES ("JN12_36b","073_12_36b","JHN","12","36b","37","Barriwa barlbayi Jisus yalunbunanyi. Ngadijba nangki, baki miku yaliyi najba Jisus mili nanamanji. Miku yaliyanyi kuyu nangangi jangkurr, ngala yali najba nanda kaja yaji ngiruka jali nyulu yabimba. Kaja walkurra yaji yabimbayi Jisuswanyi, ngala miku yaliyanyi kuyu nangangi jangkurr. Yurlwa yali nanganginkanyi jangkurranyi. ");
INSERT INTO wrk_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Kamambarra yarrijba nyuli jangkurr najana Kudkanyi wankalawanyi, niji nangangi Yayisaya. Nayi nyuli yarrijba “Mambuka, ninji jungku ngiruka yabimbikanyi yaji. Milidimba ninji yalunya kuyunkanyi nurrungi jangkurr. Ngala wanjangini jayalu kuyu nurrungi jangkurr?” Nanda jangkurr, yarrijba jali wankalawanyi, nanda jangkurr duja. ");
INSERT INTO wrk_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","40","Marda yingka jangkurr nyuli yarrijba. Nayi nyuli yarrijba, ‘Yalu jardibirri muwa. Miku nganjaliyanyi jingkijba. Jali yalu najba nanda ngiruka yaji ngaki, miku yaliyala jingkijba nanda yaji. Miku yaliyala jingkijba nanda jali ngayu yabimba. Miku yaliyala jingkijba ngaki. Baki yabimba ngayi yalunya jungunkanyi jardibirri muwa, mikungangi yaliyala jingkijba ngaki mikungangi yaliyala kuyu ngaki jangkurr. Miku yalungkiyala yangkalamba ngaki, jungunkanyi yurlurr ngakinyina yuwana. Yali yurlwa ngaki. Miku yalungkiyala yangkalamba durriykanyi ngana, baki yabimba ngayi yalunya jungunkanyi jardibirri muwa.’ Barriwa. Nani nyuli yarrijba nanda jangkurr Kudkanyi wankalawanyi Yayisayawanyi. Baki miku yaliyi kuyu nanda jangkurr, jungkungangi yalu jardibirri muwa. Nanda jangkurr, yarrijba jali Yayisayawanyi, nanda duja jangkurr. ");
INSERT INTO wrk_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Yarrijba nyuli nanda jangkurr Yayisayawanyi, jingkijbangangi nyuli nanda Krayis. Milidimbayi Kudwanyi nanda wankalanyi nganinyi nangangi Krayiskanyi. Milidimba nyuli Yayisaya Krayiskanyi, janyulu jungku walkurramirra bukambijuyngka. Nani nyuli milidimba Yayisaya Krayiskanyi. Baki nanangini wankalawanyi, nyuli yarrijba nanda jangkurr Krayiskanyi najana Kudkanyi. ");
INSERT INTO wrk_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Nanamanji kudiyawanyi mambukamukunyi Jukanyi, yali kuyu nanda jangkurr Jisuskanyi, ngala miku yaliya karu yingkamuku, marralangangi yali yalungi Barasimukuyngka. Yanybayi Barasimuku, jayalunjalu janyba jurjnanyi nanamuku, kuyu jala jangkurr Jisuskanyi. Baki nanankardi barri marrala yali karunkanyi yingkamuku nangangi Jisuskanyi. ");
INSERT INTO wrk_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Nulijba yali yingkamukuyngka waykanyi yalunya kunybanyi jangkurranyi yalunginkanyi, ngala miku yaliya nulijba Kudkanyi waykanyi yalunya kunybanyi jangkurranyi. Nulijba yali jungunkanyi kunyba yingkamukuyngka, ngala miku yaliya nulijba jungunkanyi kunyba Kudkanyi. ");
INSERT INTO wrk_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Yanybayi Jisus kudanyu, “Jaliyi narri kuyu ngaki jangkurr, baki janarri kuyu nanda jangkurr nangangi Kudkanyi. Janarri kuyu nanda jangkurr Kudkanyi, manjijba jali ngana nanginkurri. Janarri kuyu nangangi jangkurr marda, manjijbangangi nyuli ngana karunki narrinya nanankanyi jangkurranyi. ");
INSERT INTO wrk_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Jaliyi nganarri jingkijba, baki narri jingkijba Kud, manjijba jali ngana. ");
INSERT INTO wrk_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Ngayu barrinani mirnbi. Minimbaka yaji nanangini mirnbiwanyi, baki yuku narri najba yubarl jilaykanyi. Nani barri ngayu minimba narrinya jungunkanyi kunyba Kudkanyi. Jaliyi narri ngayangayijba ngaki, baki janarri ngayangayijba Kudkanyi. Miku janarri jungku balkina yuwana Kudkanyi. Ngala nanda jala yurlwa ngakinkanyi jangkurranyi, yuwaji nyulu jungkuka balkina yuwana. Jungkuka nyulu barrinani mungana yajina. Miku nyuliyi najba yubarl jilaykanyi, mikuyajingangi mirnbinyi nangangi. Ngayu barrinani nanda mirnbi. Ngayu minimba narrinya jungunkanyi kunybana yuwana Kudkanyi. ");
INSERT INTO wrk_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Nanda jala manku ngaki jangkurr, jaliyi nyulu miku ngayangayijba nanankanyi jangkurranyi, ngala miku ngayiyi yanyba nangangi, nyulu jungkuka balki. Miku. Miku ngayiyi yanyba nangangi, mikuwali jungku wanka yurrngumba Kudnyina. Miku ngayiyi yanyba nani nangangi, jaliyi nyulu miku kuyu ngaki jangkurr. Miku ngayiyanyi badajba kingkarrinya yanybiji nani. Ngala badajba ngayi nanginkurri, marrimbikanyi yalunya mardarda. Badajba ngayi marrimbikanyi yalunya. ");
INSERT INTO wrk_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Nanda jala miku durrijba ngaki jangkurr, yingkamukunyi jayalu jingkijba nanda, miku nyulimi jungku kunyba Kudkanyi. Jayalu jingkijba nanda, miku nyulimi durrijba ngaki jangkurr, jungkuka nyulu balki, jungkuka nyulu balkina nanganginyina yuwana Sayidinkanyi. Baki miku janyulu wanka jungku mili Kudnyina. Yingkamukunyi jayalu jingkijba nani nanankanyi, miku jala durrijba ngaki jangkurr. ");
INSERT INTO wrk_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Ngakinyi Buwakayu, nyuli karu ngana yanybiji nayinda jangkurr. Miku ngakiyanyi mankumanku nanginkanyi jangkurranyi ngakaman, karunki narrinya nani. Miku. Jirrinyba nyuli ngana ngakinyi buwakayu, ngayu yanybiji nayinda jangkurr. ");
INSERT INTO wrk_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Nayinda jangkurr yanybaka wankambikanyi narrinya Kudwanyi. Jaliyi narri durrijba ngaki jangkurr, baki janyulu wankamba narrinya mili Kudwanyi. Nayinda jangkurr yanybaka jungunkanyi wanka mili Kudkanyi.” Barriwa. Nani nyuli milidimba yalunya Jisuswanyi. ");
INSERT INTO wrk_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Munganawa janyulu wangarr yalungi niji Kangandijbayi Barrawuna Yajinyi. Baki jingkijbayi yaji Jisuswanyi, winyurruwa janyulu wijba kingkarri nangandurri Kudyurri, nanganginkurri Buwakayarri. Maruka nyuli muwa yalungi nanganginmuku, durrijba jalili yalu nangangi jangkurr. Maruka nyuli muwa yalungi yurrngumba. Yali nanganginmirra kandimuku. Maruka nyuli muwa yalungi kudanyu. ");
INSERT INTO wrk_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Nanamanji, bunundujbangka yaji wangarranyi, ngala nyulu mungijba yaji, jungku yali malumba, Jisus marda nanganginmuku kandimuku. Jungku yali malumba jarrkanyi mama. Ngala waluwa nanangini Sayidinwanyi, karu nyuli nanda kandi Judas Yiskariyud, nijanganjinyi nangangi niji Sayimun. Karu nyuli kandi Judas janyulu wajba mambukamuku jurjkanyi nangangi Jisuskanyi, yaluja kurdanbiji Jisus. Janyulu wajba yalunya dungalanyi nangangi Jisuskanyi. Jingkijba nyuli nanda yaji Jisuswanyi. Jingkijba nyuli, jayalu wudumba Jisus mambukamukunyi. ");
INSERT INTO wrk_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Baki mili jingkijbayi yaji Jisuswanyi. Jingkijba nyuli Kud, nyuli yabimba Jisus ngiruka, yabimbikanyi walkurra yaji ngiruka. Jingkijba nyuli, nyuli jungku ngiruka yabimbikanyi yaji. Baki mili jingkijbayi Jisuswanyi, wabula nyuli badajba kingkarrinya Kudnanyi, baki mili janyulu wijba kingkarri nangandurri Kudyurri. Jingkijba nyuli bukamba yaji nani barri. ");
INSERT INTO wrk_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Ngala yali jarrba nanda mama, baki walajbayi Jisus. Walajba nyuli baki wudumba nyuli raki. Dulaba nyuli nangangi danyan, baki kijijba nyuli nanda raki nangandu muwana. ");
INSERT INTO wrk_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Bindaba nyuli wabuda lujulujuna, baki wakardaba nyuli yalungi nukami kandimukuyngka nanganginmukuyngka. Wakardaba nyuli yalungi nukami, baki dukumba nyuli nukami rakiyudinyi. ");
INSERT INTO wrk_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Nani barri nyuli wakardaba nukami kudiyanymukuyngka kandimukuyngka, baki badajba nyuli yingkayurri nangandurri, Bidayurri. Ngala yanybayi Bida nangangi Jisuskanyi, “Mikujiyi wakardaba ngaki nukami. Miku Mambuka. Mikujiyi ninji wakardaba ngaki nukami.” ");
INSERT INTO wrk_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Jananganjayi Bida Jisuswanyi, “Miku ninjimi jingkijba nanda jala ngayu yabimba. Miku ninjimi jingkijba nanijba, ngala baku barri janinji jingkijba. Janinji jingkijba nayinda jala ngayu yabimbaka narringi.” ");
INSERT INTO wrk_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Baki mili yanybayi Bida Jisuskanyi, “Mikujiyi ninji wakardaba ngaki nukami. Miku. Miku nanijba, baki mili miku baku. Mikujiyi ninji wakardaba ngaki nani barri. Miku.” Jananganjayi Bida Jisuswanyi, “Jaliyi ngayu miku wakardaba nganyi nukami, baki miku ninjiyi jungku ngaki kandi. Miku ninjiyi kandi ngaki.” ");
INSERT INTO wrk_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Baki mili yanybayi Bida Jisuskanyi, “Yuku, mambuka. Yuku barri ninji wakardaba ngaki nukami, ngala janinji wakardaba ngaki marda wali, marda marni.” ");
INSERT INTO wrk_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Ngala yanybayi Jisus nangangi, “Nanda jala wakardaba nangka bukamba nangangi mankanyi, baki likalika nyulu nangangi mankanyi bukamba. Baki jala nyulu jilajba yingkayurri barndarri jarrji mama, ngawamba nangangi nukami nyuli jundurryudi, jilajbangangi nyuli jundurrina yajina. Marda nangkimi wakardaba ngawamba nangangi nukami. Barriwa. Nyuli yabimba narrinya likalika kurdulu Kudwanyi, baki miku narriyi jungku balki nangangi. Ngala yingamali narringi, miku nyulimi likalika, nyulu jungkuka balki kurdulu narrindu.” ");
INSERT INTO wrk_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Jingkijbayi Jisuswanyi nanda jalija karu mambukamuku jurjkanyi nangangi, yalu wudumbikanyi Jisus. Jingkijba nyuli nanda, baki nanankardi barri nyuli yanyba, “Ngala yingamali, miku nyulimi jungku likalika kurdulu.” Yanyba nyuli nanda jangkurr, jingkijbangangi nyuli nanda jalija karu mambukamuku nangangi. Barriwa. ");
INSERT INTO wrk_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Baki nyuli wakardaba bukamba yalungi nukami. Barriwa. Mili nyuli wudumba nangangi danyan, baki nyuli yarrijba nanda danyan nangandu mankanyina, baki jungku nyuli wayka. Ngajaka nyuli yalunya Jisuswanyi, “Jingkijba kuna narri nanda jali ngayu yabimba narringi. Jingkijba kuna narri. ");
INSERT INTO wrk_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","15","Nganarrili nijarrijba ‘Milidimbawarr,’ marda yingka niji ‘Mambuka.’ Nani barri nganarrili nijarrijba. Yuku barri marda nganarrimi nijarrijba nani, jungkungangi ngayu mambuka, marda milidimbawarr narringi. Nani barri ngayu jungkuka narringi bukambijuyngka. Ngala wakardaba ngayi narringi nukami. Nani barri marda narringkimi wakardaba nukami narringi. Marda narrimi yabimba bayakarda yaji narringi, barrinani ngayi yabimba bayakarda yaji narringi. Nanda yaji jala ngayi yabimba narringi, miku nanda walkurra yaji. Nanda bayakarda yaji ngayi yabimba. Marda narrimi yabimba bayakarda yaji narringi. ");
INSERT INTO wrk_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Ngayu karungka narrinya duja jangkurranyi. Nanda wakiwarr, miku nyulu walkurra barrinani nangangi mambuka. Nyulu bayakarda nganinyi. Nani barri narri wakiwarr ngaki. Narri bayakarda. Ngayu manjijbangka narrinya karunkanyi ngakinkanyi jangkurranyi. Miku narringkiyi mankumanku narri walkurra mambuka. Miku narrimi walkurra mambuka barrinani ngaliya Kud. ");
INSERT INTO wrk_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Jaliyi narri durrijba nayinda jangkurr, jaliyi narri jungku barrinani nanda bayakarda nganinyi, barrinani nanda wakiwarr, baki janarri yabijba muwa yurrngumba. Janarri yabijba muwa yurrngumba jaliyi narri yabimba nayinda yaji. Barriwa. ");
INSERT INTO wrk_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","Yanyba ngayu nayinda jangkurr narringi, ngala miku ngayiya yanyba nayinda jangkurr bukambijuyngka narringi. Jingkijba ngayu yingamali narringi. Jingkijba ngayu yingamali narringi, janangka yangkalamba ngakinmunanyi, janyulu karu mambukamuku jurjkanyi ngaki, yalu wudumbikanyi ngana. Nanda jangkurr jali yarrijba wankalawanyi, nanda jangkurr yanybaka duja, ‘Nanda jala jarrba mama ngakindu, janangka yangkalamba ngakinmunanyi.’ Nani yanybayi nanda wankalanyi jangkurr duja. ");
INSERT INTO wrk_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Ngayu karungka narrinya nanginkanyi jangkurranyi, yangkalambikanyi nangka yingamali, baki kamu jalija nangka yangkalamba, janarri jingkijba nayinda jangkurr ngaki duja. Janarri jingkijba ngaki, ngayu nanda Krayis. ");
INSERT INTO wrk_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Ngayu karungka narrinya duja. Janga manjijba narrinya karunki yingkamuku ngaki. Nanamuku, jaliyi yalu kandimba narrinya, nanda barrinani nanamannga ngana yalu kandimba. Jaliyi ngana yalu kandimba, baki nanda barrinani nanamannga yalu kandimba Kud, manjijba jali nyulu ngana.” Barriwa. ");
INSERT INTO wrk_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Jali yanyba Jisus nani, baki ngindu nyuli muwa. Jungku nyuli balki muwa. Baki yanybayi Jisus yurlurrmba jangkurr, “Ngayu karungka narrinya duja jangkurranyi. Yingamali narringi, janangka yangkalamba ngakinbunanyi. Janyulu karu yingkamuku wanjawa janganjalu wudumba. Baki marrimba janganjalu. Warriyaluku.” Barriwa. ");
INSERT INTO wrk_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Ningkijba yalungki nanganginmuku kandimuku. Miku yaliya jingkijba wanyi nanda jalija nangka yangkalamba nanganbunanyi Jisusnanyi. Miku yaliya jingkijba wanyi nyulu. ");
INSERT INTO wrk_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Yingamali yalungi, jungku nyuli bundu nangandu Jisusnyina. Marukayi muwa Jisus nangangi. Jungku nyuli bundu nangandu Jisusnyina. Baki yingka kandi, Sayimin Bida, yanyba nyuli nanankanyi kandinyi jali bundu Jisusnyina. ");
INSERT INTO wrk_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Yanybayi Sayimin Bida, “Janinji ngajaka Jisus, wanyi nanda jalija nangka yangkalamba nanganbunanyi Jisusnanyi. Ngajakakiyi Jisus wanyi nanda.” ");
INSERT INTO wrk_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Baki nanda yingka kandi, yirirdba nyuli mili bundu Jisusyurri. Ngajaka nyuli Jisus, “Mambuka. Wanyi nanda jalija nangka yangkalamba nganyinbunanyi. Wanyi nanda.” ");
INSERT INTO wrk_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Jananganjayi Jisuswanyi, “Najbakiyi nayinda mama. Jangayu yarrijba nayinda mama ngarrkina krayabkanyi. Baki jangayu wajba nanda nanginkanyi mamanyi. Jangayu wajba nanda jalija nangka yangkalamba ngakinbunanyi.” Baki nyuli yarrijba mama ngarrkina krayabkanyi, baki wajbayi Judas nanankanyi mamanyi. Nanda Judas, nyuli jandanyi nangangi Sayimin Yiskariyudkanyi. Wajba nyuli Judas nanankanyi mamanyi Jisuswanyi. ");
INSERT INTO wrk_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Jali nyulu kuyu nanda mama Judaswanyi, baki yinarramba ngankijbayi nanda wuwarr Sayidin nangandu mankanyina Judasnyina. Ngankijbayi Sayidin nangandu mankanyina. Yanybayi Jisus nangangi “Jilajbakiyi dulu. Yabimbakiyi nanda jala ninji nulijba yabimbikanyi. Dulukiyi jila.” Nani barri jirrinybayi Judas Jisuswanyi. ");
INSERT INTO wrk_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","29","Yingkamukunyi kandimukunyi nanaba, miku yaliyanyi jingkijba nanda jangkurr jali yanyba Jisus nangangi. Nanangini Judaswanyi, nyulili lalanba dungala yalungi. Manku yali nanda jangkurr Jisuskanyi, ngala ngamu yiningki Jisuswanyi karuyi Judas wudumbiji mama yalungi dungalana, yiningki karuyi Judas waji yingkamuku dungalanyi. Miku yaliyanyi jingkijba nanda jangkurr Jisuskanyi. ");
INSERT INTO wrk_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Nyuli kuyu nanda mama Judaswanyi. Jarrba nyuli, baki yinarramba nyuli jilajba danbiyurri. Baki mungijbayi yaji nangangi kudanyu. ");
INSERT INTO wrk_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","32","Jali barlbayi Judas yalunbunanyi, baki mili yanybayi Jisus yalungi, “Nanijba janyulu minimba yingkamuku Kudwanyi. Janyulu minimba yalunya ngaki Buwaya Bukambijuyngka, ngayu walkurra mambuka bukambijuyngka. Janganjalu jingkijba, ngayu walkurra, ngirukamirra. Baki jayalu jingkijba Kud, nyulu walkurra mambuka marda. Jungku ngaliya malumba walkurrawuya mambukawuya, ngirukawuya. ");
INSERT INTO wrk_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Narri, jandanyimuku ngaki. Miku jangayu jungku narrindu yurrngumba. Kujba janarri ngaki, ngala miku nganarriyi najba nanaba. Nanijba ngayu karungka narrinya nanamannga jangkurranyi jali wabula ngayi karu nanamuku Jumuku. Nanamannga jangkurranyi ngayu karungka narrinya, ‘Miku narriyi jilajba ngakindu. Jangayu jilajba yingkayurri yajiyurri, jala miku narriyi jila nanankurri. Miku narriyi jila nanankurri yajiyurri.’ Nani ngayi yanyba yalungi baki nanda jangkurr narringi marda. ");
INSERT INTO wrk_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Ngala ngayu jirrinyba narrinya buyingkinyi yuwanyi. Marukakiyi narringka muwa. Maruka ngayu muwa narringi kudanyu. Nani barri marda narringkimi maruka muwa. ");
INSERT INTO wrk_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Jaliyi narringka maruka muwa nani, baki yingkmukunyi, jayalu jingkijba narrinya, narri ngakinmuku kandimuku. Jayalu jingkijba nani narringi, jaliyi narringka maruka muwa.” Barriwa. ");
INSERT INTO wrk_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Ngajakayi Jisus kandiwanyi Bidawanyi, “Mambuka, wanjawa janinji jilajba. Wanjawa.” Jananganjayi Bida Jisuswanyi, “Miku nganinjiyi durrijba nanankurri yajiyurri nanijba. Miku. Ngala baku barri bayngkani yuku nganinjija durrijba. Miku nganinjiyi nanijba durrijba nanankurri yajiyurri, ngala baku barri yuku.” ");
INSERT INTO wrk_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Mili ngajakayi Bidawanyi, “Mambuka, wanyingkanyi miku ningiyi durrijba nanijba. Wanyingkanyi. Birrirrinja ngaka, janybikanyi ngaka nganyi.” ");
INSERT INTO wrk_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Jananganjayi Jisuswanyi, “Nanda jangkurr nganyi, janybikanyi janganyingka ngaki, nanda duja kuna. Karungka ngayu duja jangkurranyi. Kujarraka barndayka janinji yanyba, miku nganinjimi jingkijba. Yanyba janinji yingkamukuyngka kujarraka barndayka, ‘Miku ngayimi jingkijba nanda Jisus.’ Nani barri janinji yanyba waluwa kayaja nanda julaki barrinani dalmurra munganawa kambalingijina.” Nani barri yanybayi Jisus nangangi Bidanyi. Barriwa. ");
INSERT INTO wrk_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Mili yanybayi Jisus yalungi kandimukuyngka, “Barriwa jangayu barlba, ngala mikujiyi marrala. Mikujiyi marrala, barlbangangi jangayu. Narri kuyu nangangi jangkurr Kudkanyi. Maruka narri muwa nangangi. Kuyu narri ngaki jangkurr marda. ");
INSERT INTO wrk_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Nanda yaji nangangi Buwakaya, nanda walkurra yaji. Jangayu jilajba nanankurri, yabimbiji barnda narringi nanaba. Duja ngayu yanyba narringi. ");
INSERT INTO wrk_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Janga jilajba yabimbiji barnda narringi nanaba, baki jangayu wijba. Janarrinya kuyu nanankurri. Janarri jungku nanaba ngakindu yurrngumba. ");
INSERT INTO wrk_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Narri jingkijba nanda yubarl jalija ngayu durrijba. Narri jingkijba nanda yubarl.” Barriwa. ");
INSERT INTO wrk_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Yanybayi kandi, niji nangangi Dumas. Yanyba nyuli, “Mambuka, miku nurrimi jingkijba nanda yaji jalija ninji jilajba nanankurri yajiyurri. Miku nurrimi jingkijba nanda yubarl jilaykanyi nanankurri. Mudumbanyi nurru. Mudumbanyi.” ");
INSERT INTO wrk_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Yanybayi Jisus, “Ngayu barrinani nanda yubarl jilaykanyi kingkarri Buwakayarri. Ngayu nanda duja yaji. Ngayu nayinda jala ngayu wankamba narrinya. Ngawamba nanamuku jala yalu kuyu ngaki jangkurr, jayalu jilajba kingkarri. ");
INSERT INTO wrk_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Jaliyanyi nganarri jingkijba, baki narriyanyi jingkijba Buwakanya ngaki. Nanginkardi janarri jingkijba ngaki Buwakanya, baki janarri najba ngaki Buwakanya.” Barriwa. ");
INSERT INTO wrk_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Yanybayi yingka kandi, niji nangangi Bilib, “Mambuka, minimbakiyi nurrunya nganyinkanyi Buwakaya. Janurru najba mankanyi, baki janurru mirnarrijba muwa, baki miku ninya nurriyi ngajaka mili.” ");
INSERT INTO wrk_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Yanybayi Jisus nangangi, “Bilib, jungku ngayi narrindu yurrngumba, ngala miku kuna nganinjiyi jingkijba. Jala nganarri najba, baki Buwakanya narri najba marda. Wanyingkanyi nganinji ngajaka, ‘Minimbakiyi nurrunya Buwakaya.’ ");
INSERT INTO wrk_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Marda ninjimi kuyu nayinda jangkurr ngaki, ‘Ngayu jungkuka Buwakaya, nanganginyina kurduluna baki nyulu Buwakanya jungkuka ngakindu ngakinyina kurduluna.’ Nayinda jangkurr jala ngayu karungka narrinya, miku nayinda ngaki jangkurr. Ngala karuyi ngana Buwakayu yanybikanyi nayinda jangkurr. Buwakayu jala ngakindu, nyulu yabimbaka yaji. ");
INSERT INTO wrk_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Kuyukiyi nayinda jangkurr. Ngayu jungkuka nangandu Buwakaya nanganginyina kurduluna, baki nyulu Buwakanya jungkuka ngakindu ngakinyina kurduluna. Mankuwakiyi nayinda ngaki jangkurr, baki kuyukiyi ngaki jangkurr. Jaliyi miku narri kuyu nayinda ngaki jangkurr, baki mankuwakiyi nanda yaji jali ngayu yabimba, baki kuyukiyi ngaki jangkurr. ");
INSERT INTO wrk_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Ngayu karu narrinya nanginkanyi duja jangkurranyi. Nanda jala kuyu ngaki jangkurr, janyulu yabimba nanamannga yaji barrinani ngayu yabimbaka. Janyulu mili yabimba ngiruka yaji ngaki, walkurramirra yaji ngaki, jilajbangangi ngayu Buwakayarri. ");
INSERT INTO wrk_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Nanda jala nganarri ngajaka, baki narri nijarrijba ngaki niji, janga yabimba nanda yaji narringi. Baki yingkamukunyi jayalu najba nanda yaji, jalija ngayu yabimba narringi, baki jayalungka mankumanku Buwakaya. Jayalungka mankumanku Buwakaya, jalija yalu najba nanda ngiruka yaji, yabimba jalija ngayu narringi. Jayalungka yanyba kunyba jangkurr nangangi Buwakaya marda. Nyulu nanda walkurra mambuka, manjijba jali ngana. ");
INSERT INTO wrk_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Jalija nganarri ngajaka yajinyi, nijarriykanyi ngaki niji, jangayu yabimba nanda yaji narringi. Ngiruka yaji janga yabimba narringi, jalija nganarri ngajaka nanankanyi ngirukanyi yajinyi. ");
INSERT INTO wrk_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","Jaliyi narri maruka muwa ngaki, janarri kuyu nanda yuwa ngaki, janarri durrijba ngaki yuwa. ");
INSERT INTO wrk_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Baki jangayu yanyba mududu nangangi Buwakaya narringi. Jangayu ngajaka Buwakanya, baki janarrinya wajba kandinyi jungunkanyi narrindu yurrngumba. ");
INSERT INTO wrk_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Janarrinya wajba kandinyi, ngarndunyi nanganginkanyi Kudkanyi. Nyulu yanybaka duja, nanda ngarndu Kudkanyi. Nanamuku miku jalimi yalu kuyu jangkurr ngaki, mikukimi manjijba ngarndu yalundurri Buwakayu. Miku yalimi jingkijba nanda ngarndu Kudkanyi. Ngala narri jingkijbangka nanda ngarndu Kudkanyi, jungkukangangi nyulu narrindu. ");
INSERT INTO wrk_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Barriwa jangayu yingijba narrinya. Ngala miku ngayiyi yingijba narrinya yurrngumba, narriman jungunkanyi nayiba. Jangayu wijba narrindurri. ");
INSERT INTO wrk_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Baku barri bijal, miku janganjalu najba yingkamukunyi, ngala yuku janganarri najba. Yuku janarri wankijba mili baku, wankijbangangi jangayu. Jangayu wanka jungku baki nanankardi barri janarri narri marda wanka jungku. ");
INSERT INTO wrk_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Nanamanji, jalija ngayu wanka jungku, janarri jingkijba nayinda jangkurr, ‘Ngayu nangandu, ngakinyina Buwakaya nanganginyina kurduluna, marda narri ngakindu ngakinyina kurduluna, baki ngayu narrindu narringinyina kurduluna marda.’ Nani janarri jingkijba nanamanji. ");
INSERT INTO wrk_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Nanda jala kuyu ngaki jangkurr, ngaki yuwa, jala jungku kunybana ngakinyina yuwana, nyulu maruka muwa ngaki kudanyu. Nanda jala maruka muwa ngaki, ngaki Buwakanya janyulu maruka muwa nangangi, marda jangayu ngayu maruka muwa nangangi. Jangaka minimba nangandurri.” Barriwa. ");
INSERT INTO wrk_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Yanybayi kandi Jisuskanyi, niji nangangi Judas, ngala miku nyuliya nanda yingka Judas Yiskariyud. Yinini nanda. Ngajaka nyuli Jisus, “Mambuka, yanka barri nganyingka minimba nurrungi, ngala miku nganyingka minimba yalungi jala yalu miku kuyu nganyi jangkurr. Yanka barri.” ");
INSERT INTO wrk_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Jananganjayi Jisuswanyi, “Nanda jala maruka muwa ngaki, nyulu jungkuka kunybana ngakinyina yuwana, baki ngaki Buwakanya nyulu marukangka muwa nangangi. Jangaliya ngaki Buwakanya jilajba nangandurri, jangaliya jungku nangandu kurduluna. ");
INSERT INTO wrk_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Nanda jaliyi miku maruka muwa ngaki, miku nyulimi jungku ngakinyina yuwana. Nayinda yuwa jala narri manku, miku nayinda ngaki jangkurr. Nayinda nangangi jangkurr buwakaya, jali ngana manjijba narrindurri. ");
INSERT INTO wrk_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","Ngayu karungka narrinya nanginkanyi jangkurranyi ngala ngayu yuwaji narrindu. ");
INSERT INTO wrk_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Ngala nanda yingka kandi, nanda Kunyba Ngarndu Kudkanyi, jangayu ngajaka Buwakanya baki janyulu manjijba nanda Ngarndu narrindurri. Janyulu milidimba narrinya bukamba yajinyi nanangini Ngarnduwanyi. Janyulu milidimba narrinya, janarri mankuwa bukamba nayinda jangkurr ngaki. ");
INSERT INTO wrk_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","Jangayu kandimba narrinya, baki janarri jungku mardumardu muwa. Mikuyaji kijinyi narrindu. Nani barri jangayu kandimba narrinya, ngala mikuwali yingkawanyi kandimba narrinya nani. Miku narringkiyi mankumanku. Mikujiyi marrala. ");
INSERT INTO wrk_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Narri mankuyi ngaki jangkurr jali ngayu karu narrinya barrin, ‘Jangayu barlba, baki baku jangayu wijba narrindurri.’ Narri mankuyi nanda jangkurr. Jaliyi narri maruka muwa ngaki, baki janarri yabijba muwa, barlbangangi jangayu ngakinkurri Buwakayarri. Ngaki Buwakanya, nyulu walkurramirra ngaki. ");
INSERT INTO wrk_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Ngayu karungka narrinya nanginkanyi jangkurranyi waluwa jangayu barlba. Baki nanamanji jalija ngayu barlba, janarri jingkijba nayinda jangkurr, janarri kuyu nayinda jangkurr ngaki. Barriwa. ");
INSERT INTO wrk_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Nanda yingka mambuka badajbangka, ngala miku nyulu ngaki mambuka. Mambuka nyulu yalungi jala yalu miku kuyu ngaki jangkurr. Nyulu badajbangka, baki miku janga mili yanyba kaja jangkurr narringi. Nanda mambuka, miku nyulu ngaki mambuka. Miku ngayimi yabimba nanda jala nyulu karu, ");
INSERT INTO wrk_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","ngala yabimba ngayu nanda jala ngana karu Buwakayu, baki bukambijunyi ngananjalu jingkijba, ngayu marukangka muwa nangangi Buwakaya. Marukangka ngayu muwa nangangi. Barriwa jangambala barlba.” ");
INSERT INTO wrk_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","7","Mili yanybayi Jisus yalungi kandimukuyngka, “Mankumanku narringka wanjirranyi krayibkanyi. Karrinjarrijba nyuli jambana wanjirr krayibkanyi. Manjijba yalungki balalawalamuku. Marrimbayi nanda barriki. Jardijba yali walkurra. Kajamuku balalawalamuku, yalu kajayudi mamayudi, ngala kujajarra balalawala, mikuyaji mamanyi yalungi. Nanangini lalanbawarranyi, wudumba nyuli nanda mama balalawalananyi, ngala nyuli karlba nanda balalawala jala mikuyaji mamanyi. Karlba nyuli nanda balki balalawala landurrnanyi. Baki bukamba kunyba nanda wanjirr krayibkanyi. Mikuyaji balkinyi balalawalanyi nangandu. Birrirrinja nanda wanjirr jardiykunumbikanyi mili mama. Ngayu barrinani nanda landurr krayibkanyi, baki ngaki Buwakanya, nyulu barrinani nanda lalanbawarr krayibkanyi, baki narri, narri barrinani nanda balalawala. Ngayu barrinani nanda landurr, ngala narri barrinani nanda kaja balalawala, jala jardijba nanamunanyi yingamalinanyi landurrnanyi. Narri jungku kunyba Kudkanyi, milidimbangangi ngayi narrinya jungunkanyi kunyba yurrngumba. Birrirrinja narringka wakinkanyi kunyba ngaki. Jala narri waki Kudkanyi, jala narri yabimba kunyba yaji Kudkanyi, baki jungku narri barrinani nanda balalawala kajayudi mamayudi. Narri barrinani nanda kaja balalawala. Ngayu barrinani nanda landurr, baki narri kili ngakindu yurrngumba. Jaliyi balalawala dalyamba nangka landurrnanyi, baki janangka janyba. Mikuyaji mamanyi nangandu. Nani barri, jaliyi narri kili ngakindu, jaliyi narri ngayangayijba ngakinkanyi jangkurranyi, baki janarri jungku kunyba Kudkanyi. Jaliyi narri durrijba ngaki jangkurr, baki jangayu wajba narrinya bukamba yajinyi, jala nganarri ngajaka. Jangayu wajba narrinya bukamba yajinyi. Ngala jaliyi narri miku jungku kunybana yuwana kudkanyi, jaliyi narri miku waki Kudkanyi, baki narri barrinani nanda balki balalawala, mikuyaji mamanyi nangandu. Nanangini lalanbawarranyi janyulu karlba nanda balki balalawala landurrnanyi. Janyulu karlba, baki janyulu janyba nanda balki balalawala nanganbunanyi. Baki baku janyulu wudumba nanda balki balalawala jala duku. Janyulu wudumba, baki janyulu janyba jangurri. Yajbaja nanda duku balalawala janguwanyi. Ngaki Buwakanya, nyulu barrinani nanda lalanbawarr krayibkanyi. Janyulu dulaba ngakinbunanyi nanamuku, jungku jala yalu balki nangangi Kudkanyi. Janyulu dulaba yalunya ngakinbunanyi. Miku jayalu jungku wanka nangandu yurrngumba. Nani barri, jaliyi narri miku durrijba ngaki jangkurr, baki janarri jungku barrinani nanda balki balalawala. Janyulu manjijba narrinya ngakinbunanyi Kudwanyi, baki baku janyulu janyba narrinya jangurri. ");
INSERT INTO wrk_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Jaliyi narri waki kudanyu Kudkanyi, jaliyi narri yabimba yaji Kudkanyi, baki yingkamukunyi jayalu jingkijba Buwakanya, nyulu jungkuka walkurra mambuka, walkurramirra. Jaliyi narri waki kudanyu nangangi Kudkanyi, baki janyulu lalanba narrinya, nanganginmuku wakiwarrmuku. Baki yingkamukunyi jayalu jingkijba Buwakanya, nyulu jungkuka walkurra. Nani barri jayalu jingkijba, jalija yalu najba narrinya yabimbikurri ngiruka yaji. Jaliyi narri waki kudanyu, baki janarri jungku ngakinmuku kandimuku. ");
INSERT INTO wrk_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Jingkijba narri ngaki Buwakanya, nyulu marukangka muwa ngaki kudanyu. Nani ngayu marukangka muwa narringi. Mankuwa nganarri yurrngumba, ngayu maruka muwa narringi. Mikujiyi mamanumba. ");
INSERT INTO wrk_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Baki jaliyi narri ngayangayijba ngakinkanyi jangkurranyi, jaliyi narri durrijba ngaki jangkurr, baki jangayu yurrngumba maruka muwa narringi. Nani barri, ngaki Buwakanya nyulu marukangka muwa ngaki yurrngumba. Ngayi yurrngumba ngayangayijba nanganginkanyi jangkurranyi, baki nyulu marukangka muwa yurrngumba ngaki. ");
INSERT INTO wrk_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","Jali ngayu jungka nayiba jambana baki ngayi mirnarrijba muwa. Mirnarrijba ngayi muwa, yabimbangangi ngayi bukamba yaji, jali ngana jirrinyba ngakinyi Buwakayu yabimbikanyi yaji. Yabimba ngayi nanda bukamba yaji, baki ngayi mirnarrijba muwa. Nani barri, jangayu mirnarrijba muwa narringi, jaliyi narri yabimba bukamba yaji, jali ngayu jirrinyba narrinya. Jaliyi narri yabimba nani, baki narri mirnarrijba muwa marda. ");
INSERT INTO wrk_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Barrin ngayi jirrinyba narrinya buyingkiyngkanyi yuwanyi. Jirrinyba ngayi narrinya nani, marda narringkimi maruka muwa. Marda narringkimi maruka muwa, barrinani ngayu marukangka muwa narringi. ");
INSERT INTO wrk_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Jaliyi nganinyi maruka muwa nanganginmukuyngka kandimukuyngka, baki janyulu wajba yalunya yajinyi, janyulu yabimba yaji yalungi. Nanda nganinyi nyulu kunyba. Ngala jaliyi nyulu maruka muwa kudanyu yalungi, baki janangka birrirrinja janybikanyi nangka yalungi. Jaliyi nangka birrirrinja yabimbikanyi yaji nani yalungi, nyulu kunybamirra. ");
INSERT INTO wrk_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Jungku narri ngakinmuku kandimuku, jaliyi narri ngayangayijba ngakinkanyi jangkurranyi. Jaliyi narri yurrngumba durrijba ngaki jangkurr, baki janarri yurrngumba ngakinmuku kandimuku. ");
INSERT INTO wrk_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Miku ngayiyi mili karu narrinya ngakinmuku wakiwarrmuku. Miku. Nanangini mambukawanyi, miku nyulimi karu nangangi wakiwarrmuku nanankanyi jalija nyulu yabimba. Miku nyulimi karu yalunya nanankanyi. Ngawamba nyulu karu kandimuku nangangi nanankanyi jalija nyulu yabimba. Miku narriyi mili jungku ngakinmuku wakiwarrmuku, ngala narri ngakinmuku kandimuku. Narri ngakinmuku kandimuku, karungangi ngayi narrinya bukamba yajinyi. Karu ngayi narrinya bukamba yajinyi jali nyulu karu ngana ngakinyi Buwakayu. Narri ngakinmuku kandimuku, karungangi ngayi narrinya bukamba nani. ");
INSERT INTO wrk_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Miku nganarriyanyi yarrijba, narri jungunkanyi ngakinmuku kandimuku. Miku. Ngala ngayi yarrijba narrinya, narri jungunkanyi ngakinmuku kandimuku. Ngayu karungka narrinya yabimbiji ngiruka yaji. Jalija narri yabimba nanda kaja ngiruka yaji, baki janarri barrinani nanda kaja balalawala krayibkanyi, kajayudi mamayudi. Ngujbulijbangka nanda mama krayibkanyi. Ngala nanda ngiruka yaji jala narri yabimba, nanda barrinani nanda mama jala mikukimi ngujbulijba. Jalija narri karu yingkamuku ngaki, baki kudiyawanyi jayalu kuyu narringi jangkurr ngaki. Jayalu durrijba ngaki jangkurr yurrngumba. Nanda jala yalu yabimba, nanda jungkuja yurrngumba. Jaliyi narri waki kudanyu ngaki, jaliyi narri yabimba ngiruka yaji ngaki, baki yuku narri ngajaka Buwakanya yajinyi, baki janyulu wajba narrinya nanankanyi yajinyi ngakinyi Buwakayu. Janyulu wajba narrinya bukamba yajinyi jalija narri ngajaka. Janyulu wajba yajinyi, yabimbangangi narri yaji ngaki. ");
INSERT INTO wrk_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Mili ngayu jirrinyba narrinya, maruka narringka muwa. Narringka maruka muwa. Marda maruka narri yalungi marda, yingkamukuyngka yurrngumba.” ");
INSERT INTO wrk_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","Mili nyuli milidimba yalunya Jisuswanyi, “Mankuwa narri mili nayinda ngaki jangkurr. Nganjali ngirra yingkamukunyi. Waluwa nganjali ngirra kudanyu. Baki jayalu ngirra narrinya marda, durrijbangangi narri ngaki jangkurr, jungkungangi narri ngakinmuku kandimuku. ");
INSERT INTO wrk_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Jaliyanyi narri yurlwa ngakinkanyi jangkurranyi, baki yaliyanyi mirnarrijba muwa narringi. Ngala miku narriyanyi yurlwa ngakinkanyi jangkurranyi. Ngayangayijba narri ngaki. Yarrijba ngayi narrinya jungunkanyi ngakinmuku kandimuku. Yarrijba ngayi narrinya, baki miku nganarrimi ngirra, ngala narri maruka muwa ngaki. Ngala jayalu ngirra narrinya kudanyu, marukangangi narri muwa ngaki. ");
INSERT INTO wrk_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","21","Mankuwakiyi nanda jangkurr, karu jali ngayu narrinya barrin. Mankuwakiyi nanda jangkurr wakiwarrayngka. ‘Miku nanda wakiwarr mili walkurra nanganginkanyi mambukanyi, ngala nyulu bayakarda. Yurrngumba nanda mambuka jungkuka walkurra nanganginkanyi wakiwarrayngka.’ Nani barri ngayi karu narrinya barrin. Narri wakiwarr ngaki. Miku narri mili walkurra ngaki. Jaliyi yalu ngayangayijba ngakinkanyi jangkurranyi, baki jayalu ngayangayijba narringinkanyi jangkurranyi marda. Ngala jaliyi yalu yabimba kiji ngaki, baki jayalu yabimba kiji narringi marda. Jayalu yabimba kiji narringi, narringangi ngakinmuku kandimuku. Miku yalimi jingkijba Kud, manjijba jali ngana milidimbikanyi yalunya. Miku yalimi jingkijba Kud. Yalu yurlwa nangangi Kudkanyi, baki nani nanankardi jayalu yurlwa narringi marda. Jayalu yabimba kiji narringi. ");
INSERT INTO wrk_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","24","Wabula miku yalungkiyanyi jingkijba jungunkanyi balkina yuwana Kudkanyi. Ngamu yali jungku kunyba Kudkanyi. Miku yalungkiyanyi jingkijba nanankanyi nani wabula. Ngala ngayi milidimba yalunya jungunkanyi kunyba Kudkanyi, baki nanijba marda yalungkimi jingkijba, yalu jungkuka balkina yuwana Kudkanyi. Marda yalungkimi jingkijba nani, milidimbangangi ngayi yalunya. Ngala yuwaji yalu jungkuka balkina yuwana Kudkanyi. Najba yali nanda ngiruka yaji, yabimba jali ngayu. Mikuwali yingkawanyi yabimba ngiruka yaji barrinani ngayu yabimbaka. Miku. Jingkijba nganjalu, nyuli manjijba ngana Kudwanyi, yabimbangangi ngayi nanda ngiruka yaji. Jingkijba nganjalu, manjijba ngani Kudwanyi, ngala yuwaji nganjalu ngirra. Jala nganjalu ngirra, nani yalu ngirra ngaki Buwakanya. Yalu ngirra ngalinya. Baki jaliyi yalu ngirra ngalinya, baki yalu jungku balkina yuwana Kudkanyi. ");
INSERT INTO wrk_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Nanda jangkurr duja, yanyba jali nanda wankalanyi. Barrabarruji nyuli yarrijba jangkurr najana Kudkanyi nayi, ‘Miku ngayiya yabimba yaji, nganjali ngirrankanyi. Ngala muningka nganjali ngirra.’ Duja nanda wankalanyi jangkurr.” ");
INSERT INTO wrk_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","Mili yanybayi Jisus yalungi, “Nanda Kunyba Ngarndu Kudkanyi, janyulu badajba nanginkurri. Jangayu manjijba nanda Kunyba Ngarndu narrindurri. Nyulu duja nanda Ngarndu. Jangayu manjijba nanda Kunyba Ngarndu wayka nanganbunanyi Buwakayananyi. Baki nanangini Kunybawanyi Ngarnduwanyi Kudkanyi, janyulu karu narrinya ngaki. Janyulu karu narrinya ngaki. ");
INSERT INTO wrk_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Baki janarri narri marda karu yingkamuku ngaki. Janyulu karu yalunya ngaki, Kunybawanyi Ngarnduwanyi Kudkanyi, marda janarri karu yalunya ngaki marda. Janarri karu yalunya, jungkungangi narri ngakindu yurrngumba wabulinyi. Jali wabula jalannga ngayu milidimba yalunya, baki narri jungkuyi ngakindu. Yurrngumba narrili jilalajba ngakindu. Yurrngumba narrili najba nanda yaji, jalili ngayu yabimba. Baki janarri marda karu yalunya ngaki.” Barriwa. Nani barri milidimbayi yalunya Jisuswanyi. ");
INSERT INTO wrk_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","Baki mili yanybayi Jisus yalungi, nanganginmukuyngka kandimukuyngka. “Yanyba ngayi bukamba nayinda jangkurr narringi, baki nanankardi barri miku narringkiyi yangkalamba ngakinbunanyi balkinyi nanankanyi yajinyi. Jaliyi narri kuyu nayinda ngaki jangkurr, baki miku narringkiyi yangkalamba. ");
INSERT INTO wrk_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Jayalu manjijba narrinya Jumukunyi. Jayalu manjijba narrinya kajananyi jurjnanyi. Miku jayalu nulijba narringi jungunkanyi yalundu jurjina. Jayalu yabimba kiji narringi. Jayalu nulijba kurdanbikanyi narrinya. Jaliyi nganinyiwanyi kurdanba yingamali narringi, baki ngamu nyulu jungkuka kunyba Kudkanyi. Ngamu nyulu wakingka kunyba Kudkanyi, jaliyi nyulu kurdanba yingamali narringi. ");
INSERT INTO wrk_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Miku yalimi jingkijba Buwakanya, baki miku nganjalimi jingkijba. Jayalu yabimba kiji narringi, mikungangi yalimi jingkijba ngalinya Kud. ");
INSERT INTO wrk_vpl VALUES ("JN16_4a","073_16_4a","JHN","16","4a","4a","Marda narrimi mankuwa nanda yaji bukamba, karu jali ngayu narrinya. Marda narrimi mankuwa nanda yaji. Jalija yalu yabimba kiji narringi, baki marda narrimi miku marrala yajinyi. Janarri miku marrala, jalija narri mankuwa ngaki jangkurr. ");
INSERT INTO wrk_vpl VALUES ("JN16_4b","073_16_4b","JHN","16","4b","5","Miku ngayiyanyi karu narrinya nanginkanyi jangkurranyi wabula ngala ngayi yuwaji jungku narrindu. Miku ngayiyanyi karu narrinya wabula. Ngala nayimanji jangayu barlba nangandurri, manjijba jali ngana nanginkurri. Jangayu barlba nangandurri. Ngala miku nganarriyi ngajaka, ‘Wanjawa janinji barlba. Wanjawa.’ Miku nganarriyi ngajaka nani. ");
INSERT INTO wrk_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Ngala nayimanji barri ngayu karu narrinya, jangayu barlba, baki ngindu narri muwa. Ngindu narri muwa kudanyu, barlbangangi jangayu. ");
INSERT INTO wrk_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Ngala yanyba ngayu duja jangkurranyi. Jangayu barlba, ngala kunyba nanda nani narringi. Nanda kunyba narringi, badajbajangangi Kunyba Ngarndu Kudkanyi narrindurri. Jaliyi ngayu kili narrindu, baki mikuwali badajba Kunyba Ngarndu Kudkanyi. Ngala jangayu barlba, baki jangayu manjijba nanda Ngarndu narrindurri bayngkani jalija ngayu barlba. ");
INSERT INTO wrk_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","11","Jalija nyulu badajba kingkarrinya, nanda Kunyba Ngarndu Kudkanyi, janyulu milidimba yingkamuku yalunginkanyi balkinyi yajinyi. Miku yalimi jingkijba nanda balki yaji yalungi kurdulunyi, ngala janyulu milidimba yalunya yalungi balkinyi yajinyi. Janyulu milidimba yalunya jungunkanyi kunyba Kudkanyi, jungunkanyi yurlurrmba yuwana Kudkanyi. Janyulu milidimba yalunya yalu jungku balkina yuwana, mikungangi yalimi kuyu ngaki jangkurr. Janyulu milidimba yalunya, yuku yaluja jungku yurlurrmba, barlbangangi jangayu Buwakayarri. Janyulu milidimba yalunya Kudkanyi, karrinjarrijba janyulu bukambiju yalunya walu nangandu yanybikanyi yalungi. Ngala wabula nyuli ningkijba Sayidin Kudwanyi, baki yanybayi Kud nanganginkanyi balkinyi yajinyi Sayidinkanyi. Janyulu manku walkurra kiji nangangi Sayidinkanyi. ");
INSERT INTO wrk_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","Mili jangkurr yuku ngayu karu narrinya, ngala miku narriyi jingkijba nanda mili jangkurr nanijba, baki miku ngayiyi karu narrinya. Ngala baku barri janyulu milidimba narrinya mili yajinyi Kunybawanyi Ngarnduwanyi Kudkanyi. Janyulu milidimba narrinya mili baku. ");
INSERT INTO wrk_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","14","Badajbaja nanda Kunyba Ngarndu Kudkanyi narrindurri. Baki janyulu minimba narrinya duja yajinyi. Janyulu milidimba narrinya bukamba duja yajinyi. Janyulu karu narrinya bukamba nanankanyi jangkurranyi, jalija ngayu yanyba nangangi. Janyulu karu narrinya ngakinkanyi jangkurranyi jungunkanyi kunybana yuwana Krayiskanyi. Miku nyuliyi karu narrinya nanganginkanyi jangkurranyi. Janyulu karu narrinya ngawamba ngakinkanyi jangkurranyi. Nani barri janyulu minimba narrinya ngaki, ngayu walkurra mambuka bukambijuyngka. ");
INSERT INTO wrk_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Janyulu karu narrinya ngakinkanyi jangkurranyi. Nanda jangkurr ngaki, nanda barrinani nanamannga jangkurr Kudkanyi. Jangaliya Kud jungku malumba. Jangaliya waki malumba. Jangaliya yabimba yaji bukamba malumbijunyi. Baki nanda jangkurr, yanyba jala ngayu, nanda barrinani nanamannga jangkurr nangangi Buwakaya. ");
INSERT INTO wrk_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","Winyurru barri miku nganarriyi najba, ngala baku barri nganarrija najba.” Nani yanybayi Jisus yalungi kandimukuyngka. ");
INSERT INTO wrk_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","18","Ngala ngajaka yalungki kudiyanymuku nanganginmuku kandimuku, “Wanyi nayi jangkurr yanybaka. Wanyi. ‘Winyurru barri miku nganarriyi najba, ngala baku barri nganarrija najba.’ Wanyi nanda jangkurr. Miku ngambalimi jingkijba nanda jangkurr naykanyi Jisus. Miku ngambalimi jingkijba nangangi jangkurr. Baki mili nanda nyuli yanyba, ‘Barlba jangayu Buwakayarri.’ Miku ngambalimi jingkijba nanda jangkurr marda.” Nani yalungki ngajaka. ");
INSERT INTO wrk_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Jingkijba nyuli yalunya Jisuswanyi. Jingkijba nyuli yalunya ngajakankurri yalungki nani. Baki nyuli ngajaka yalunya, “Yanyba ngayi, ‘Winyurru barri miku nganarriyi najba, ngala baku barri nganarrija najba.’ Ngajaka kuna narringki nanankanyi jangkurranyi. ");
INSERT INTO wrk_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Yanyba ngayu duja jangkurr. Janarri ngindu muwa kudanyu mirlarryudi, ngala yingkamuku jala yalu miku ngakinmuku, jayalu mirnarrijba muwa jalija ngayu miku mili jungku nayiba. Nayimanji jayalu mirnarrijba muwa barlbangangi jangayu, ngala narri janarri ngindu muwa. Nayimanji barri janarri ngindu muwa ngaki, ngala baku barri mili janarri mirnarrijba muwa ngaki. ");
INSERT INTO wrk_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Jalija winyurru barri nangka binandaba jibarri bardardanyi, baki nyulu ngindu. Ngindu nyulu, linjungangi janyulu muwa winyurru. Ngala kamu barri, jalija nangka binandaba bardardanyi, baki mirnarrijbaja muwa bardardanyi. Mirnarrijbaja, jungkungangi janyulu bardardayudi. Janyulu mamanumba nanda biwi. Janyulu mamanumba, jungkungangi janyulu bardardayudi. ");
INSERT INTO wrk_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Jungku janarri barrinani nanda jibarri. Ngindu narri muwa, barlbangangi jangayu. Ngala baku mili janarri mirnarrijba muwa, wijbangangi jangayu narrindurri. Janarri mirnarrijba muwa jalija ngayu wijba. Mikuwali yingkawanyi yabimba narrinya mili ngindunkanyi muwa. Janarri mirnarrijba muwa yurrngumba. Janarri jungku barrinani nanda jibarri bardardayudi, mirnarrijba jala muwa. Janarri mirnarrijba muwa, wijbangangi jangayu narrindurri. ");
INSERT INTO wrk_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Nanamanji jalija ngayu wijba, miku nganarriyi ngajaka yajinyi. Karungka ngayu narrinya duja jangkurranyi. Nanamanji jalija narri yanyba mududu Buwakaya, jalija narri yililikajba Buwakanya yajinyi, baki janyulu jananganja narrinya. Janyulu yabimba nanda jalija narri yililikajba Buwakanya yabimbikanyi yajinyi narringi. Janyulu jananganja narrinya, kuyungangi narri ngaki jangkurr yurrngumba, jungkungangi narri ngakinmuku kandimuku. ");
INSERT INTO wrk_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Wabula nganarri ngajaka yajinyi, marda narri ngajaka Buwakanya yajinyi, jungkungangi narri ngakinmuku kandimuku. Jalija ngayu barlba, marda narrimi yililikajba Buwakanya yajinyi, jungkungangi narri ngakinmuku kandimuku, ngayangayijbangangi narri ngakinkanyi jangkurranyi. Marda narrimi yililikajba Buwakanya nanankanyi yajinyi jala narri nulijba. Jaliyi narri yililikajba Buwakanya, jungkungangi narri ngakinmuku kandimuku, baki janyulu jananganja narrinya. Janyulu yabimba nanda jala narri yililikajba, baki janarri mirnarrijba muwa yurrngumba.” ");
INSERT INTO wrk_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","“Nanijba barri muningka ngayi karu narrinya nayinda jangkurr, ngala miku narriyi jingkijba bukamba nayinda jangkurr. Marda narringkimi mankumanku nanginkanyi jangkurranyi, jardibirringangi nayinda jangkurr jingkiykanyi. Ngala winyurru miku jangayu mili yanyba narringi muningka. Jangayu karu narrinya yurlurrmba nayinda jangkurr Buwakaya, narri jingkiykanyi nayinda jangkurr Buwakaya. ");
INSERT INTO wrk_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Nanamanji janarri ngajaka Buwakanya yajinyi, ngala miku jangayu ngajaka ngaki Buwakanya yajinyi narringi. Janarri narri ngajaka narriman Buwakanya narringinkanyi yajinyi, jungkungangi narri ngakinmuku kandimuku, durrijbangangi narri ngaki jangkurr. ");
INSERT INTO wrk_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Janarri ngajaka Buwakanya yajinyi, marukangangi nyulu muwa narringi. Nyulu maruka muwa narringi, marukangangi narri muwa ngaki, kuyungangi narri nayinda jangkurr ngaki, ‘Manjijbayi ngana Kudwanyi.’ Kuyu narri nayinda jangkurr ngaki, maruka narri muwa ngaki, baki nanankardi barri Kud nyulu maruka muwa narringi. ");
INSERT INTO wrk_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Nanda jangkurr duja. Badajba ngayi nanginkurri yajiyurri nanganbunanyi Buwakayananyi. Badajba ngayi nanganbunanyi. Ngala nayimanji jangayu yingkijba nayinda yaji, baki jangayu wijba Buwakayarri.” Barriwa. Nani yanybayi Jisus yalungi. ");
INSERT INTO wrk_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Baki yanyba yali nanganginmuku kandimuku nangangi Jisuskanyi, “Mambuka. Yuku nurru jingkijba nanda jangkurr nganyi. Miku ninjimi yanyba muningka. ");
INSERT INTO wrk_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Nanijba nurru jingkijba ninya, ninji jingkijbangka bukamba yaji. Jaliyi nurrungka mankumanku jangkurranyi, ngajakankanyi ninya, miku nurriyi ngajaka ninya nanankanyi jangkurranyi. Miku nurriyi ngajaka ninya, jingkijbangangi ninji nanda jangkurr jala ninya nurrimi ngajaka. Jananganja ninji nurrunya waluwa nurri ninya ngajaka. Kuyu nurru nganyi jangkurr, jingkijbangangi ninji nanda jangkurr jala nurrungka mankumanku nganyi. Nanda jangkurr, badajba ninji nanganbunanyi Kudnanyi, nanda duja jangkurr. Manjijba ninyi Kudwanyi.” Barriwa. ");
INSERT INTO wrk_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Jananganjayi yalunya Jisuswanyi, “Kuyu kuna narri ngaki jangkurr nanijba. Yu, narri kuyu ngaki jangkurr. Nanda kunyba barri. ");
INSERT INTO wrk_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Ngala winyurru janarri jarrbalijba. Jarrbalijba janarri. Yingka barlbaja nanganginkurri yajiyurri, baki yingka nanganginkurri yajiyurri. Janarri jungku yinini yinini narringinyina barndana. Nani barri janarri jarrbalijba. Janganarri yingijba. Jangayu jungku nayiba ngayuman. Ngala miku ngayiyi jungku nyubana, jungkukangangi ngaki Buwakanya ngakindu yurrngumba. ");
INSERT INTO wrk_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Jayalu manku kiji narringi, ngala janarri jungku mardumardu muwa, karungangi ngayi narrinya nanginkanyi jangkurranyi. Janarri jungku mardumardu muwa. Jangayu jungku narrindu kurduluna yurrngumba. Yalu mankuka kiji ngaki. Kaja kiji yalu mankuka ngaki, ngala jangayu wakaramba yalunya. Jangayu jungku mambuka yalungi, jala miku yalimi maruka muwa Kudkanyi.” ");
INSERT INTO wrk_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Jali nyulu yanyba Jisus bukamba nanda jangkurr kandimukuyngka, baki ningkijbayi Jisus kingkarri lalijiyurri. Ningkijba nyuli kingkarri, baki yanyba nyuli kingkarri nangangi Kudkanyi, “Buwakanya, ngayu ngajaka ninga, ninjija minimbiji yalunya wandijiyana, ngayu jungku nganyi jandanyi, ngayu walkurra mambuka. Baki jaliyi yalu jingkijba ngana, ngayu walkurra mambuka, baki jayalu jingkijba ninya, ninji walkurra mambuka marda. ");
INSERT INTO wrk_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Baki jangayu wankamba yalunya, jungunkanyi niyandu kingkarri lalijina. Jangayu wankamba yalunya, yarrijbangangi nganinji jungunkanyi walkurra mambuka yalungi wandijiyana. Jangayu wankamba mili yalunya, jalija yalu durrijba ngaki jangkurr. Yurrngumba yalu durrijba ngaki jangkurr, yarrijbangangi ninji yalunya ngaki. Yarrijba ninji yalunya durriykanyi ngaki jangkurr. ");
INSERT INTO wrk_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Jangayu mili wankamba yalunya, baki jayalu jingkijba niyanya. Jayalu jingkijba ninga, ngawamba ninji duja Kud, marda jayalu jingkijba ngana, ngayu Jisus Krayis, nanda jali ninji manjijba. ");
INSERT INTO wrk_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Yabimba ngayi nanda kaja yaji jali nganinji karu nanankanyi yabimbiji. Yabimba ngayi bukamba nani. Barriwa. Baki jayalu jingkijba ninya, ninji walkurra Kud yalungi wandijiyana, wakingangi ngayi nani barri. Barriwa. ");
INSERT INTO wrk_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Jingkijba ngayu nayinda yaji. Winyurruwa jangaka janyba. Baki ngayu ngajaka ninga, jangayu jungku mambuka nganyindu kingkarri. Janungkala jungku malumba, barrinani wabula nungkala jungkuyi malumba mambukawuya, waluwa nganinji manjijbayi wayka jambarri. Ngayu ngajaka ninga, janungkala jungku malumba barrinani wabula kamambarra, jali nungkala yabimba bukamba yaji wandijiyana. Barriwa. ");
INSERT INTO wrk_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","Nanamuku nganinyimuku jali yalu maruka muwa nganyi, ninji yarrijba yalunya ngaki. Yalu ngakinmuku kandimuku. Karu ngayi yalunya nganyi, baki jingkijba yalu ninga, ngayangayijba yalu nganyinkanyi jangkurranyi. ");
INSERT INTO wrk_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Baki nayimanji yalu jingkijba ngaki jangkurr. Nganinji karu nanankanyi jangkurranyi, ngayu karunki yalunya. Bukamba nanankanyi jangkurranyi, karu jala ngayi yalunya, nanda nganyi jangkurr. Yalu jingkijba nanda nganyi jangkurr. ");
INSERT INTO wrk_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Karu ngayi yalunya nanankanyi nganyingkanyi jangkurranyi, baki yali kuyu nganyi jangkurr. Kuyu yali nganyi jangkurr, karu jali ngayu yalunya. Jingkijba yalu nayinda duja jangkurr, ‘Badajba ngayi nganyinbunanyi, nganinji manjijbayi yalundurri.’ Kuyu yali nayinda jangkurr ngaki. ");
INSERT INTO wrk_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","10","Ngayu karungka ninga yalungi. Yalu nganyinmuku jandanyimuku. Yingkamukunyi jala miku yaliyanyi kuyu nganyi jangkurr, miku ningimi karu yalungi. Ngala nanginmuku ngakinmuku kandimuku, yali kuyu nganyi jangkurr, yalu jungku kunyba nganyi nanijba. Ninji walkurra mambuka yalungi, baki ninji yarrijbayi yalunya ngakindurri. Jungku ngayu marda, walkurra mambuka yalungi. Baki ninga ngajaka yalungi, ninjija lalanbiji yalunya. Baki jayalu milidimba yingkamuku ngaki, ngayu mambuka bukambijuyngka wandijiyana. ");
INSERT INTO wrk_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Winyurruwa jangayu barlba nganyindurri. Miku jangayu mili jungku nayiba jambana. Miku jangayu jungku mili yalundu kandimukunyina ngakinyina. Jayalu jungku yaluman. Buwakanya, ninji kudukudu. Baki janinga ngajaka kuna, janinji lalanba ngakinmuku kandimuku. Lalanbakiyi yalunya. Marrimbakiyi yalunya mardarda, jungkungangi ninji ngiruka. Baki jayalu jungku yurrngumba ngiruka marda malumbiju, barrinani nungkala jungku ngiruka malumbiju. ");
INSERT INTO wrk_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Wabula ngayili jungku yalundu. Lalanba ngayili yalunya, yabimbangangi nganinji ngiruka lalanbikanyi yalunya. Kudanyu ngayili lalanba yalunya bukambiju. Ngala yingamali nyuli yingijba ngakindu. Jalija nangka janyba nanda yingamali, baki miku nyuliyi jungku mili wanka nganyindu. Yingkijba nyuli ngakindu. Nani yarrijbayi jangkurr nganyinyina najana wankalawanyi. Barrabarruji nyuli yarrijba nanda duja jangkurr nanankanyi yingamaliyngka, jalija yingijba ngakindu nanijba. ");
INSERT INTO wrk_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","Winyurruwa jangayu barlba nganyindurri, ngala nanijba ngayu yuwaji jungku nayiba jambana. Ngayu yanybaka nganyi, baki nanginmuku kandimuku ngakinmuku, yalu nayiba ngakindu. Yalu mankuka nayinda jangkurr. Ngayu ngakaja ninya, janinji lalanba yalunya, baki jayalu mirnarrijba muwa. Jayalu mirnarrijba muwa, barrinani ngayu mirnarrijba muwa, jingkijbangangi ninyalu, janinji lalanba yalunya yurrngumba. ");
INSERT INTO wrk_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Karu ngayi yalunya nganyingkanyi jangkurranyi. Ngala yingakmukunyi yalunjali ngirra ngakinmuku kandimuku, durrijbangangi yali nganyi jangkurr. Ngala nanamukunyi yingkamukunyi, durrijba yali yalungi balki yuwa. Miku ngayimi durrijba yalungi yuwa, baki ngakinyi kandimukunyi, miku yalimi durrijba nanda balki yuwa yalungi yingkamukuyngka. Baki nanankardi barri yalunjalu ngirra ngakinmuku kandimuku, mikungangi yalimi durrijba nanda balki yuwa. ");
INSERT INTO wrk_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Miku ninyimi ngajaka ninya, ninjija dulaji yalunya yalunbunanyi balkimukunanyi. Miku ninyimi ngajaka nani yalungi. Ngala ngayu ngajaka ninya, ninji lalanbiji yalunya, ninji marrimbiji yalunya mardarda. Baki nanangini balkiwanyi wuwarrwanyi, nanangini Sayidinwanyi, miku yalunyiyi yangkalamba ngakinbunanyi yuwananyi. ");
INSERT INTO wrk_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Miku ngayimi durrijba nanda balki yuwa yingkamukuyngka, baki ngakinyi kandimukunyi, miku yalimi durrijba nanda balki yuwa. Durrijba yalu nganyi yuwa. Nanda yuwa nganyi, nanda yinini kunyba yuwa. ");
INSERT INTO wrk_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","18","Manjijbayi nganinji jambarri milidimbikanyi, baki nani ngayu manjijba yalunya, yalu milidimbikanyi yingkamuku. Ngala janinji marrimba yalunya mardarda, miku yalu yabimbikanyi balki yaji, baki jayalu waki nganyi. Jayalu durrijba nganyi jangkurr, nanda duja jangkurr. ");
INSERT INTO wrk_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Nani jangayu waki nganyi. Jangayu yurlwa yingkamukuyngka, ngala jangayu durrijba nganyi jangkurr yurrngumba. Baki jayalu waki nganyi. Jayalu durrijba nganyi jangkurr, jingkijbangangi nganjalu, ngayu durrijba nganyi jangkurr. Nani barri marda jayalu durrijba nganyi jangkurr yurrngumba. ");
INSERT INTO wrk_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","Miku ngayimi yanybaka nganyi ngawamba nanginmukuyngka, ngakinmukuyngka kandimukuyngka. Ngala yanybaka ngayu nganyi marda yingkamukuyngka. Yanybaka ngayu nganyi yalungi yingkamukuyngka, jalija yalu marda manku nganyi jangkurr. Ngakinmukunyi kandimukunyi jayalunjalu milidimba nganyingkanyi jangkurranyi. Baki kudiyanymukunyi jayalu kuyu nanda nganyi jangkurr. Yanybaka ngayu nganyi marda yalungi marda kudiyanymukuyngka, kuyu jalija nanda nganyi jangkurr baku. ");
INSERT INTO wrk_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Buwakanya, yanyba ngayu nganyi yalungi, baki jayalungka mankumanku nanamannga jangkurr. Nani barri niyangka mankumanku nanamannga jangkurr. Mankumanku nganyingka nanamannga jangkurr, baki mankumanku ngaka nanamannga jangkurr. Nani niyangka mankumanku nanamannga jangkurr. Ngayu yanybaka nganyi yalungi, jayalungka marda mankumanku nanamannga jangkurr. Baki yingkamukunyi, jalija yalunjalu najba mankumankunkurri yalungka nanamannga jangkurr, jayalu jingkijba, nganinji manjijbayi nanginkurri jambarri. ");
INSERT INTO wrk_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Yurrngumba ngayi yabimba nanda yaji jali nganinji karu. Yurrngumba nungkala waki malumbiju. Nani barri ngakinyi kandimukunyi jayalu yabimba nanda yaji jalija ninji karu yalunya. Jayalu waki malumbiju niyandu. Jangambala malumba waki bukambiju. ");
INSERT INTO wrk_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Niyangka mankumankuka nanamannga jangkurr. Ninji jungkuka ngakinyina kurduluna. Ngayu jungkuka nganyinyina kurduluna, marda jangayu jungku yalunginyina kurduluna. Baki jayalungka mankumanku nanamannga jangkurr, jalija ngayu jungku yalunginyina kurduluna. Baki bukambijunyi wandijiyana, janganjalu jingkijba, nganinji manjijba. Baki jayalu jingkijba, ninji maruka muwa yalungi, barrinani ninji maruka muwa ngaki. ");
INSERT INTO wrk_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","Buwakanya, ninji yarrijba yalunyi ngakindurri, yalu durriykanyi ngaki yuwa. Ngajaka ninya, jayalu jungku nananyina yajina, jalija ngayu barlba nanankurri yajiyurri. Baki janganjalu najba jungunkurri kunyba marda walkurra, barrinani ninji jungku kunyba marda walkurra. Maruka ninji muwa ngaki yurrngumba. Maruka ninji muwa ngaki wabula, waluwa nungkala yabimbayi bukamba yaji, laliji marda kanja marda jamba. Maruka ninji muwa ngaki waluwa nungkali yabimba bukamba yaji. Ngayu jungku kunyba marda walkurra, marukangangi ninji muwa ngaki yurrngumba. ");
INSERT INTO wrk_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Buwakanya. Ninji jungku yurlurr yurrngumba. Yingkamukunyi miku yalimi jingkijba ninya, ngala ngayu jingkijba ninya. Ngayu jingkijba ninya, ninji jungku yurlurr, ninji yanyba duja jangkurr. Baki nanginmukunyi kandimukunyi ngakinyi, jingkijba ninyalu marda. Yalu jingkijba ngana, nganinji manjijbayi. ");
INSERT INTO wrk_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Karu ngayi yalunya nganyi. Milidimba ngayi yalunya nganyi, baki mili jangayu milidimba yalunya nganyi. Baki ninji maruka muwa ngaki, baki nani barri marda yalimi marukangka muwa yalungi yingkamukuyngka. Baki jangayu jungku yalundu kurduluna yurrngumba. Barriwa barri ngayu yanyba nganyi nani.” Nani barri yanybayi Jisus nanganginkanyi Buwakaya. ");
INSERT INTO wrk_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Jali yanyba Jisus nani barri mududu Kudkanyi, baki barlba yali barndananyi, Jisus marda nanganginmuku kandimuku. Barlba yali karrurrinybarri balarri, niji nanankanyi balanyi Kidrun barri. Jungku yali nanaba mungana karrurrinybana munjimunji. ");
INSERT INTO wrk_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Jungku yalili nanaba karrurrinybana, Jisus marda nanganginmuku kandimuku. Baki nanangini Judaswanyi, jingkijba nyuli jalili yalu jungku nanaba. Nanamanji yanybayi Judas yalungi mambukamukuyngka jurjkanyi. Karu nyuli yalunya Jisuskanyi, nyuli jungku nanaba karrurrinybana. ");
INSERT INTO wrk_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Mambukamukunyi jurjkanyi marda Barasimukunyi, manjijba yalunjali wudumbiji Jisus. Manjijbayi yalunya, yilarrmuku marda nganinyimuku ngarrkadabawarrmuku. Waluluwijbayi Judas yalungi karrurrinybarri balarri. Barlba yali mirnbiyudi baki janganiyudi. ");
INSERT INTO wrk_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Ngala nyuli jingkijba bukamba yaji Jisuswanyi. Jingkijbayi yalunya Jisuswanyi, yalu daykanyi, marda nyuli muningka jilajba yalundurri, jali yalu kujba nangangi. Jilajba nyuli yalundurri, baki ngajaka nyuli yalunya, “Wanyingkanyi narri kujba. Wanyingkanyi.” ");
INSERT INTO wrk_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Jananganja yali, “Nangangi nurru kujba Jisuskanyi, niji nangangi yaji Nasarid. Nangangi nurru kujba Jisuskanyi.” Yanybayi Jisus yalungi, “Nayinda ngayu.” Nanda Judas, karrinja nyuli nanaba yalundu. Barrin nyuli wudumba dungala karunkanyi mambukamuku jurjkanyi. Karu nyuli yalunya, janyulu waluluwijba yalungi Jisusyurri. Barriwa. ");
INSERT INTO wrk_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Jali yanyba Jisus, “Nayinda ngayu”, baki jilajba yali bayngkani, baki yirrba yali jambarri. ");
INSERT INTO wrk_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Mili nyuli ngajaka yalunya Jisuswanyi, “Wanyingkanyi narri kujba. Wanyingkanyi?” Baki mili yali jananganja Jisus, “Kujbangka nurru Jisuskanyi, nangangi yaji Nasarid.” ");
INSERT INTO wrk_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Yanybayi Jisus yalungi, “Karu ngayi narrinya barrin, nayinda ngayu. Jaliyi narri kujba ngaki, baki manjijbakiyi yalunya ngakindu yalunginkurri barndarri. Manjijbakiyi nanginmuku kandimuku, jungka jala yalu nayiba ngakindu.” ");
INSERT INTO wrk_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Yanybayi Jisus barrin, “Yalu jala jilalajba ngakindu yurrngumba, jangayu lalanba yalunya. Yurrngumba jangayu yalunya lalanba.” Nani barri yanybayi Jisus barrin. Duja nanda jangkurr nangangi. Lalanba nyuli yalunya nanamanji jali yalu jila wudumbiji Jisus. Barriwa. ");
INSERT INTO wrk_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Nanda kandi Bida, nyuli jankunbijinyiyudi wunanybalanjudi. Karrinja nyuli nanaba nangandu Jisusnyina, baki dulaba nyuli kingkarri nangangi jankunbijinyi. Dulaba nyuli, baki jinamba nangki, ngala karlbayi kuwarda jankunbijinyiyudinyi. Karlba nyuli nangangi kuwarda, nanda jalili waki mambukanyi jurjkanyi. Niji nangangi wakiwarr, mikuyaji kuwardanyi, Malkis. ");
INSERT INTO wrk_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Ngala Jisuswanyi nyuli jirrnyba nanda Bida, “Wiykunumbakiyi yarrijba kalawunyi. Wijbakiyi kundula ngaki. Kuyunyi nganjalu. Buwakanya, yanyba nyuli ngaki. Yanyba nyuli, ngayuja jilajba yalundu nanginmukunyina jala jila ngakindurri wudumbiji ngana. Jangana yalu kurdanba. Nani barri nyuli yanyba Buwakanya ngaki, jangayu jila yalundu.” Barriwa. ");
INSERT INTO wrk_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Marrimba yali Jisus baki kijijba yali jaluwuya. Mijimbangu yali nanaba nangandu, nganinyimuku ngarrkadabawarr, marda mambuka yalungi, marda yilarrmuku. Kijijba yali Jisus. Barriwa. ");
INSERT INTO wrk_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Baki waluku yali kuyu Jisus malburri Yanasyurri. Nanda Yanas, kardunganja nyuli nangangi Kayabaskanyi. Nanda Kayabas, nyuli walkurra mambuka jurjkanyi nanamanji jali yalu marrimba Jisus. ");
INSERT INTO wrk_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Nanda Kayabas, wabula nyuli yanyba yalungi kunsilkanyi Jukanyi. Yanyba nyuli, “Nanda Jisus, marda nangkimi janyba. Jaliyi nangka janyba, baki miku nyuliyi yabimba mili kiji ngambalangi. Baki miku ngamanjaliyi linjumba nanamukunyi mambukamukunyi Rumankanyi. Marda nangkimi janyba, baki miku ngambalakiyi janyba.” Nani barri yanybayi nanda Kayabas wabula. Waluku yali kuyu Jisus nanganginkurri barndarri Yanaskanyi. ");
INSERT INTO wrk_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Jilajba buli bayngkani nangandu Jisusnyina, Sayimin Bida, baki yingka kandi Jisuskanyi nangandu. Jilajba buli bayngkani Jisusnyina nanganginkurri barndarri Yanaskanyi. Nanangini Yanaswanyi, jingkijba nyuli nanda yingka kandi Jisuskanyi. Baki ngankijba nyuli kalawuyngkurru barrikina jala nanaba lukuluku mambukanyi barndana. Ngankijbayi nanda yingka kandi kalawuyngkurru nangandu Jisusnyina. ");
INSERT INTO wrk_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Ngala nanda yingka kandi, Bida, yukumba nyuli danbina bardawana. Yukumba nyuli danbina bardawana, ngala nanda yingka kandi ngankijba jali waluwa barrikina, nyuli yanyba nanankanyi jibarrinyi, lalanba jala bardawa. Yanyba nyuli jibarrinyi, baki wijba nyuli danbiyurri wudumbiji Bida. Baki ngankijba buli kalawuyngkurru barrikina. ");
INSERT INTO wrk_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Nanda jibarri jali lalanba bardawa, yanyba nyuli Bidanyi, “Marda ninji kuna kandi nangangi Jisuskanyi.” Jangumba jujambayi Bidawanyi. Yanyba nyuli nangangi, “Miku ngayu kandi nangangi. Miku.” ");
INSERT INTO wrk_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Karrijba yali janguna ngarrkadabawarrmuku baki wakiwarrmuku, baki yilarrmuku. Mardujbayi yaji mungana. Karrijba yali janguna, marda nanda Bida nyuli karrinja marda yalundu janguna. Ngarrijba yali janguna. Barriwa. ");
INSERT INTO wrk_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Baki nanangini mambukawanyi jurjkanyi ngajaka nyuli Jisus. Yililikajbayi Jisus nanganginmukuyngka kandimukuyngka, marda yililikajbayi Jisus nanganginkanyi jangkurranyi, milidimba jalili nyulu yalunya yurrngumba. ");
INSERT INTO wrk_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Jananganjayi Jisuswanyi, “Yanyba ngayi jangkurr, baki bukambijunyi, yali manku nanda jangkurr. Milidimba ngayili yalunya jurjina, marda walkurranyina jurjina jalili yalu bukambiju jungku nanaba. Miku ngayiyanyi yanyba kardarda yingamaliyngka, ngala yanyba ngayili kajanyi, kudanyu bukambijuyngka. ");
INSERT INTO wrk_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Wanyingkanyi nganinji ngajaka ngakinkanyi jangkurranyi. Ngajakakiyi yalunya jali yalu manku ngaki jangkurr. Yalu jingkijba ngaki jangkurr. Marda ninjimi ngajaka yalunya.” ");
INSERT INTO wrk_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Jali yanyba Jisus nayinda jangkurr, baki dabayi Jisus karnkul yingamalinyi yilarrwanyi. Daba nyuli karnkul marniyudinyi balamba. Daba nyuli Jisus karnkul, baki ngirrwayi nangangi Jisuskanyi, “Wijbakiyi jananganja walkurra mambuka nani. Yanybakiyi yabimba nangangi.” ");
INSERT INTO wrk_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Jananganjayi Jisuswanyi, “Jaliyanyi ngayu milidimba yalunya barimba, baki wudumbakiyi yalunya jali yalu manku nanda jangkurr ngaki. Janinya yalu karu ngakinkanyi balkinyi jangkurranyi, jaliyanyi ngayu yanyba barimba. Ngala ngayi yanyba kunyba jangkurr, baki wanyingkanyi nganinji dabayi karnkul. Wanyingkanyi.” Barriwa. ");
INSERT INTO wrk_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Baki nanangini Yanaswanyi, manjijba nyuli Jisus yingkayurri mambukarri jurjkanyi. Manjijba nyuli Jisus nangandurri, niji nangangi Kayabas. Jilajbayi Jisus yuwajiwa jaluwuya kurulyudi. Barriwa. ");
INSERT INTO wrk_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Nanabawa janguna karrinjayi Bida. Ngarrijbayi janguna. Baki yanybayi yingka nganinyi nangangi Bidanyi, “Ninji kuna kandi nangangi Jisuskanyi. Ninji kuna nangangi kandi.” Ngala mili jujijbayi Bida. Jujijba nyuli, “Miku ngayu nangangi kandi. Miku.” ");
INSERT INTO wrk_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Yingka nganinyi nanaba. Mungkiji nyuli nanankanyi jali karlbayi kuwarda Bidawanyi barrin. Jungku nyuli nanaba janguna. Nanda mungkiji nyuli waki walkurrayngka mambukanyi jurjkanyi. Ngajaka nyuli Bida, “Miku kuna ningiyanyi najba marda nangandu Jisusnyina karrurrinybana Kidrunyina. Miku kuna ningiyanyi najba nanaba.” ");
INSERT INTO wrk_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Mili jujijbayi Bida, “Miku. Miku ngayiyanyi nanaba nangandu Jisusnyina karrurrinybana. Miku.” Baki yinarramba kayayi nanda julaki barrinani dalmurra. Kudanyu kayayi nanda julaki. Barriwa. ");
INSERT INTO wrk_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Baki kuyu yali Jisus bayungu Kayabasnanyi Jumukunyi. Kuyu yali Jisus bayungu nangandurri walkurrayngkurri mambukarri Kubaminkanyi. Ngala nyuli kambalingijba yaji karrina. Jilajba yali kalawuyngkurri barrawurri, Jisus marda ngarrkadabarwarrmuku. Ngala nanamuku Jumuku, miku yaliyanyi ngankijba. Miku yaliyanyi ngankijba kalawuyngkurru. Jaliyanyi yalu ngankijba kalawuyngkurru ngurranyina barrawuna, baki jungku yalu balkina yuwana Jukanyi. Jaliyanyi yali ngankijba ngurranyina barrawuna, baki miku yaliyi jarrba mama nanankanyi wangarranyi niji Kangandijbayi Barrawuna Yajinyi. Karrinja yali danbina. ");
INSERT INTO wrk_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Nanda mambuka walkurra Kabaminkanyi, niji nangangi Bilad. Walajba nyuli danbiyurri yalundurri, jala miku yaliyanyi ngankijba kalawuyngkurru nangandurri. Jilajbayi Bilad yalundurri, baki ngajakayi yalunya Jumuku, “Yanka nyulu jungku balkina yuwana nanda Jisus. Yanka barri.” ");
INSERT INTO wrk_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Yali jananganja Bilad, “Jalimi nyulu kunyba jungku, baki miku nurriyi kuyu nganyindurri.” ");
INSERT INTO wrk_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Yanybayi Bilad yalungi, “Janarri kuyu Jisus narriman. Janarri kuyu, baki janarringka jingkijba jaliyi nyulu jungku balkina narringinyina yuwana Jukanyi. Janarringka jingkijba nangangi.” Jananganja yali, “Jungku nyulu balkina nurrunginyina yuwana. Marda nangkimi janyba, ngala mambuka Kubaminkanyi Rumankanyi nyulu yanybaka, miku nurriyi daba kurdanbikanyi nanijba. Jangumba wabula nurrili daba yaji, ngala miku nanijba.” ");
INSERT INTO wrk_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Nanamuku Jumuku, mankumanku yalungki Biladkanyi, marda nyulimi jirrinyba nangangi ngarrkadabawarrmuku, baki jayalu daba Jisus kurdanba. Wabula Jisus yanybayi nayinda jangkurr, “Janganjalu langandaba kurndana kurdanbikanyi.” Duja nanda jangkurr, yanyba jali nyulu wabula. Barriwa. ");
INSERT INTO wrk_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Baki wijbayi Bilad, ngankijba nyuli kalawuyngkurru barrawurri. Karu nyuli ngarrkadabawarr, yalu kuyunkanyi Jisus nangandurri. Kuyu yali Jisus, baki ngajakayi Biladwanyi, “Ninji kuna walkurra mambuka Jukanyi. Ninji kuna yalungi walkurra mambuka.” ");
INSERT INTO wrk_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Ngala ngajakayi Bilad Jisuswanyi, “Nanda jangkurr jali nganinji ngajaka, nanda nganyi jangkurr kuna. Yiningki yingkawanyi ninya karuyi nanankanyi jangkurranyi.” ");
INSERT INTO wrk_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Baki jananganjayi Biladwanyi, “Miku ngayu mungkiji nganyi. Miku ngayu Ju. Ngala yalu kuyuyi ninya ngakindurri, nganyinmukunyi mungkijimukunyi. Ngala ngajaka ningi, yanka ninji jungku balki. Wanyi balki yaji ninji yabimba.” ");
INSERT INTO wrk_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Jananganjayi Bilad Jisuswanyi, “Yi, ngayu walkurra mambuka, ngala miku ngayu mambuka barrinani yingkamuku mambukamuku. Miku ngayu mambuka barrinani nanamuku mambukamuku Jukanyi. Miku ngayu mambuka barrinani yalu, nayiba jala yalu jungku jambana nayiba. Jalimi ngayu mambuka barrinani yalu, baki nganimi nanangajba ngakinmukunyi ngarrkadabawarrmukunyi. Nanangajba nganjalimi. Ngala miku ngayimi mambuka barrinani yingkamuku mambukamuku jala ninji jingkijba. Yinini mambuka ngayu. Yinini.” ");
INSERT INTO wrk_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Baki mili ngajakayi Jisus Biladwanyi, “Ngala ninji kuna walkurra mambuka.” Jananganjayi Jisuswanyi, “Nanda nganyi jangkurr. Ninji yanyba ngaki, ngayu walkurra mambuka. Manjijbayi ngana Kudwanyi. Badajba ngayi kingkarrinya nanginkurri yajiyurri, jungku ngayi nayiba jambana, karunki duja jangkurr. Manjijba nyuli ngana, karunki duja jangkurr. Bukambiju nanamuku nganinyimuku jala yalu nulijba mankunkanyi duja jangkurr, jayalu manku ngaki jangkurr. Jayalu manku ngaki jangkurr. Jayalu kuyu ngaki jangkurr, dujangangi ngaki jangkurr.” ");
INSERT INTO wrk_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Ngajakayi Jisus Biladwanyi, “Ngala wanyi yaji duja. Wanyi.” Baki mili walajbayi Bilad danbiyurri yalundurri Jumukuyngkurri, baki yanybayi yalungi, “Mankumanku ngaka nangangi Jisuskanyi, miku nyulimi jungku balkina yuwana. Miku nyulimi jungku balki. ");
INSERT INTO wrk_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Ngala yurrngumba nayimanji kindilkurrinyi ngurrwayi, jala wangarr niji Kangandijbayi Barrawuna Yajinyi narringi, yurrngumba nayimanji muningka ngayili manjijba yingamali nganinyi, jungku jala brisinyina. Muningka ngayili manjijba yingamali nayimanji. Wanyi nganinyi jangayu manjijba nanijba. Wanyi. Jangayu kuna manjijba narringi mambuka Jukanyi. Jangayu kuna manjijba nayinda Jisus.” ");
INSERT INTO wrk_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Ngala kaya yali Jumuku. Kaya yali kudanyu nangangi, “Mikujiyi manjijba nayinda Jisus. Ngala nanda manjijbakiyi yingka, niji nangangi Barabas. Mikujiyi manjijba Jisus.” Ngala nanda Barabas, nyuli maninjaku, nyuli dabawarr. ");
INSERT INTO wrk_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Baki karuyi nganinyimuku ngarrkadabawarrmuku Biladwanyi. Jirrinyba nyuli yalunya, yalu kuyunki Jisus, yalu wajuji Jisus kurulyudinyi. Yalu wajuji Jisus kudanyu barri. ");
INSERT INTO wrk_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Kuyu yali Jisus. Wudumba yali wardankurrul kurnda nyilanyilayudi, baki kijijba yali bakiri. Yarrijba yali nanda bakiri lukuluku nangandu kulajina Jisusnyina, marda yali yarrijba danyan wunanybala wayka nangandu danyiyurruwa. Nganmarra nanda danyan. Nani barri nanamanji nyulili jungku walkurra mambuka. Jungku nyulili marda danyayudi nganmarranjudi, marda bakiriyudi. Nani barri yali yarrijba bakiri nyilanyilayudi marda nganmarra danyan nangandu Jisusnyina ngirrikimbiji Jisus. ");
INSERT INTO wrk_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Ngirrikimba yali Jisus ngarrkadabawarrmukunyi. Yanyba yali nangangi, “Marda ninji mambuka walkurramirra Jukanyi, ninji barri kuna.” Nani yali ngirrikimba Jisus. Baki yali daba Jisus. Dabayi Jisus wali. Barriwa. ");
INSERT INTO wrk_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Baki mili walajbayi Bilad danbiyurri yalundurri Jumukuyngkurri. Jilajba nyuli yalundurri, baki nyuli yanyba yalungi, “Narri. Ngayu kuyungka Jisus narrindurri. Mankumanku ngaka nangangi Jisuskanyi, miku nyulimi jungku balkina yuwana. Nyulu jungkuka kunybana yuwana. Miku nyulimi jungku balkina yuwana. Miku.” ");
INSERT INTO wrk_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Walajbayi Jisus. Walajba nyuli, yuwajiwa nyuli bakiriyudi marda nganmarranjudi danyayudi. Baki yanybayi Bilad yalungi, “Ningkijbakiyi nayinda Jisus. Nayiba nyulu. Ningkijbakiyi.” ");
INSERT INTO wrk_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Jali yalu najba Jisus, mambukamukunyi jurjkanyi marda wakiwarrmukunyi jurjkanyi, yali kaya nangangi Biladkanyi. Kudanyu yali kaya nangangi, “Langandabakiyi. Langandabakiyi nayinda Jisus kurndana. Langandabakiyi.” Baki yanybayi Bilad yalungi, “Narri. Narri kuyu, narri langandaji kurndana. Narri kuyu kurdanbiji, ngala yuwaji ngayu yanybaka nangangi, nyulu jungkuka kunybana yuwana. Kunybana yuwana nyulu jungkuka.” ");
INSERT INTO wrk_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Yali jananganja Bilad, mambukamukunyi jurjkanyi, “Marda nangkimi janyba nanda, balkijbangkangangi nyulu nurrunginkanyi yuwanyi. Balkijbangka nyulu jali nyulu yanyba nyulu jandanyi nangangi Buwakaya Kudkanyi. Nani nyulu balkijbangka.” ");
INSERT INTO wrk_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Baki marralayi Bilad. Marrala nyuli kudanyu jali nyulu manku nanda jangkurr Jisuskanyi, nyulu jandanyi Kudkanyi. Marrala nyuli kudanyu. ");
INSERT INTO wrk_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Mili buli ngankijba kalawunyi barrawuna, Bilad marda Jisus. Jali bula kalawunyi, ngajakayi Jisus Biladwanyi, “Wanjawa nganyi yaji.” Ngala miku nyuliyanyi jananganja Bilad Jisuswanyi. Miku nyuliyanyi yanyba jangkurr nangangi. ");
INSERT INTO wrk_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Baki mili ngajakayi Jisus Biladwanyi, “Wanyingkanyi ninji miku yanybikanyi ngaki. Ngayu walkurra mambuka Kubaminkanyi nganyi. Marda nganinjimi jingkijba. Yiningki janinga muningka manjijba barndarri, ngala yiningki janinga manjijba yalundurri Jumukuyngkurri, baki janinga yalu daba, langandaba kurndana, janinga yalu kurdanba. Ngayu walkurra mambuka manjiykanyi ninya nani.” ");
INSERT INTO wrk_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Ngala yanybayi Jisus nangangi Biladkanyi, “Jangumba ninji jungkuka mambuka ngaki barri, yanybangangi nyuli Kud ngaki. Yanybayi Kud, ninji mambuka ngaki. Jalimi nganinji kurdanba ninjuma, baki ninji jungku balkina yuwana Kudkanyi. Ngala nanangini mambukawanyi jurjkanyi, Kayabaswanyi, ngana nyuli manjijba nganyindurri, nganinji kurdanbiji. Nanda yingka Kayabas, nyulu jungkuyi balkinamirra Kudkanyi kudanyu.” ");
INSERT INTO wrk_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Jali yanyba Jisus nanda jangkurr, baki Biladwanyi nyuliyanyi muningka manjijba Jisus nanganginkurri barndarri. Miku nyuliyala manjijba Jisus kurdanbikanyi. Ngala kaya yali kudanyu Jumuku nangangi. Kaya yali kudanyu, “Jaliyi ninji muningka manjijba nanganginkurri barndarri, baki miku ninjiyi jungku kandi nangangi nanankanyi walkurrayngka mambukanyi niji Sisa. Miku ninji kandi nangangi jaliyi ninji muningka manjijba Jisus.” Baki mili yali kaya nangangi Biladkanyi, “Jaliyi nganinyi yanyba, ‘Ngayu walkurra mambuka barrinani Sisa mambuka,’ baki nanda Sisa nyulu ngarrangarra muwa nanankanyi.” Barriwa. ");
INSERT INTO wrk_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Jali manku nanda jangkurr Biladwanyi, baki nyuli jilajba nanankurri yajiyurri, niji Ju yanyi Kabada. Kudukudu dungala nanaba yundu bijal kalawuyngkurru barrawuna. Baki darladarla nanaba jungunkanyi yali jalili yalungka yanyba jangkurr kurdanbikanyi nangangi. Baki jungkuyi Bilad nananyina darladarlana. Kuyu yali Jisus nangandurri ngarrkadabawarrmukunyi. ");
INSERT INTO wrk_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Nanamanji jali yalu kuyu Jisus nangandurri Biladyurri, nanamanji munganawa wangarr yalungi niji Kangandijbayi Barrawuna Yajinyi. Baki mukunjana barri yanybayi Bilad yalungi Jumukuyngka, “Narri, nayinda nganinyi nyulu mambuka narringi walkurramirra.” ");
INSERT INTO wrk_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Ngala yali kaya kudanyu, “Kurdanbakiyi. Langandabakiyi nayinda Jisus kingkarri kurndana. Kurdanbakiyi. Kurdanba.” Ngajakayi yalunya Biladwanyi, “Jangayu kuna langandaba nayinda mambuka narringi walkurramirra. Jangayu kuna langandaba.” Jananganja yali Bilad mambukamukunyi jurjkanyi, “Miku nayinda nurrungi mambuka. Miku nyulimi jungku walkurramirra mambuka nurrungi. Nanda Sisa, nyuluma nurrungi walkurramirra mambuka. Nyuluman Sisa. Miku nayinda nganinyi.” ");
INSERT INTO wrk_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Baki yanybayi Bilad yalungi, “Barriwa narri karu yalunya ngarrkadabawarrmuku langandaji Jisus. Barriwa narri kuyu Jisus.” ");
INSERT INTO wrk_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Baki kuyu yali Jisus juju danbiyurri langandaji wabangkarra. Juju danbiyurri yali kuyu bayangarriji. Niji nanankanyi yajinyi bayungu, Ju yanyi Kulkuda, barrinani Kulaji Nguli. Ngala Jisuswanyi nyuli kuyu nanda kurnda nangangi wabangkarra. Bayngkani ngulurrina wayka kuyuyi wabardala. Kuyu nyuli wabangkarra bayangarriji. ");
INSERT INTO wrk_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Nanaba barri langandaba yali Jisus kurndana wabangkarra. Ngarrkadaba yali marni nyilanyilayudinyi. Langandaba yali Jisus nanaba, marda kujarra mili langandaba yali bundu nangandu Jisusnyina. Nyulu Jisus burrandi bulandu. Yingka kurndana wabangkarra karriya, baki yingka kurndana wabangkarra bayinga. Nani barri yalunjali langandaba ngarrkadabawarranyi. ");
INSERT INTO wrk_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","20","Marda Biladwanyi, nyuli karu yalunya ngarrkadabawarrmuku, “Yarrijbakiyi nayinda jangkurr najana, baki kijijbakiyi langandaba kingkarri kurndana Jisuskanyi.” Nayinda jangkurr nyuli yarrijba, ‘Nayinda Jisus, nangangi yaji Nasarid. Nayinda nyulu mambuka walkurramirra Jukanyi.” Yarrijba yali nanda jangkurr kingkarri wabangkarra kurndana. Yarrijba nyuli nanda jangkurr Ju yanyi, baki Rumin yanyi, baki Krik yanyi. Yarrijba yali nanda jangkurr kurndana jali yalu langandaba Jisus. Nanda yaji bayangarriji jali yalu langandaba Jisus, nanda yaji bundu kudukudu barrawuyabarrawuya Jirusalim. Najbayi kajamukunyi Jumukunyi nanda jangkurr kurndana. Najba yali nanda jangkurr. ");
INSERT INTO wrk_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Ngala yanyba yali Biladkanyi mambukamuku jurjkanyi, “Mikujiyi yarrijba nanda jangkurr, ‘Nyulu mambuka walkurramirra Jukanyi.’ Mikujiyi yarrijba nani barri. Miku nyulimi jungku barrinani mambuka nurrungi. Yininikiyi yarrijba. Yinini. Yarrijbakiyi nayinda yinini jangkurr, ‘Muningka nangka yanyba, nyulu mambuka walkurramirra Jukanyi.’” ");
INSERT INTO wrk_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Nani barri yali ngakaja Bilad, ngala jananganjayi yalunya Biladwanyi, “Miku jangayu yarrijba yinini jangkurr. Yarrijba jayalu ngaki jangkurr kingkarri kurndana.” Barriwa. ");
INSERT INTO wrk_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Kujarra baki kujarra ngarrkadabawarr yali jungku nanaba. Dulaba yalu jumbala nangangi Jisuskanyi baki langandaba yali wabangkarra kurndana. Dulaba yali jumbala Jisuskanyi, baki kuyu yali jumbala marda yalungi barri bukambijunyi, nani yingamali jumbala. Ngala yingka jumbala nangangi yingkijba yali. Wunanybala jumbala nukamiyurru wayka barri barrinani danyan. ");
INSERT INTO wrk_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Yanyba yalungki, “Kajamuku ngambala. Miku ngambaliyi bakarramba nayinda jumbala nangangi. Jangambala baja wudumbikanyi jumbala barrinani kard. Jangambala baja wudumbikanyi nanda jumbala.” Wabula kamambarra yanybayi wankalanyi, “Wudumba yali ngaki jumbala, marda yali baja ngakinkanyi jumbalanyi.” Yarrijbayi nanda jangkurr nanangini wankalawanyi. Duja nanda jangkurr. ");
INSERT INTO wrk_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Nani barri ngarrkadabawarrmukunyi, baja yali nanganginkanyi jumbalanyi. Baki kudiya jibarrimuku, karrinja yali nanaba nangandu Jisusnyina wabangkarra. Karrinja yali jibarrimuku, nangangi ngardanganja Jisuskanyi, baki nangangi jujarranganja, marda yingka Mari, nawinganja nangangi niji Klubas, marda yingka, niji nangangi Mari Makdalin. Karrinja yali nanaba nangandu Jisusnyina. Marda yingka yalundu, kandi nyulu nangangi Jisuskanyi. ");
INSERT INTO wrk_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Najbayi bulanya Jisuswanyi, nanganginmirra ngardanganja, baki nanda kandi jala maruka nyuli muwa nangangi kudanyu. Nanda kandi karrinjayi bundu nanganginyina ngardanganjana, baki yanybayi Jisus, “Ngarda, nangini kandiwanyi ngakinyi, janinga yukumba. Kuyukiyi nganyinmirra jandanyi.” ");
INSERT INTO wrk_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Baki yanybayi Jisus nanganginkanyi kandinyi, “Yukumbakiyi, baki lalanbakiyi. Kuyukiyi nganyinmirra ngardanganja.” Kamu barri nanangini kandiwanyi, nyuli kuyu nanda bardibardi nanganginkurri barndarri. Jungku nyulili nanaba nangandu yurrngumba. ");
INSERT INTO wrk_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Ngala langayi Jisus kurndana, mankumanku nangki, “Bukamba barri nanda yaji ngayi yabimba, yanyba jali nyulu ngaki, ngaki Buwakanya. Bukamba barri.” Baki yanybayi Jisus, “Warinjijba ngayu.” Wabula kamambarra yanybayi wankalanyi nayi, “Janyulu warinjijba. Janyulu ngaraba ngarrki krayibkanyi ngujbul.” Duja nanda jangkurr yanyba jali wankalanyi. Wabula nyuli yarrijba nanda jangkurr najana Kudkanyi. Yanybaka nanda jangkurr nangangi Jisuskanyi. ");
INSERT INTO wrk_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Yarangul nanaba, jirdi ngarrkinyi krayibkanyi ngujbulanyi. Kijijba yali karnjal wadiwadina. Yarrijba yali karnjal ngarrkina, baki manjijba yali kingkarri Jisusyurri janyiyurri, warinjijbangangi nyuli. Manjijba yali nanda karnjal ngarrkiyudi nangandurri Jisusyurri janyiyurri. ");
INSERT INTO wrk_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Jali ngaraba nanda ngarrki Jisuswanyi, baki yanybayi, “Barriwa barri.” Nani barri nyuli yanyba, “Barriwa barri”, baki karlwijbayi duka nangangi. Manjijba nangki ngarndu nangangi. Baki barriwa barri, janyba nangki Jisus nani. ");
INSERT INTO wrk_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Ngala nanamukunyi Jumukunyi, yilikajba yali Bilad nyulu karunki ngarrkadabawarrmuku. Yilikajba yali Bilad, nyulu karunki yalunya dalyambiji nguli nganinyimuku jali langa kurndana wabangkarra. Jala yalu dalyawijba nguli, baki dulu yalungkaja janyba. Yaliyanyi dulaba mankanyi Jumukunyi, yaliyanyi dulaba mankanyi waluwa munganyi, munganawangangi Sadidi, walkurra Sadidi Wangarr niji Kangandijbayi Barrawuna Yajinyi. Miku yaliyala yingijba mankanyi langankurri Sadidi. Barriwa. ");
INSERT INTO wrk_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Baki dalyamba yali nguli kujarrawuya, jali langa nangandu Jisusnyina. Dalyamba yali nguli kujarrawuya nganinyiwuya ngarrkadabawarrmukunyi. ");
INSERT INTO wrk_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Ngala yali najba Jisus, nyuli nganinyiyurru, baki miku yaliyanyi dalyamba Jisus nguli. ");
INSERT INTO wrk_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Ngala yingamalinyi ngarrkadabawarranyi, nyuli ngarrkadaba Jisus mankanyi. Ngarrkadaba nyuli Jisus mankanyi wili wuniyudinyi. Jali nyulu dulaba wuni, baki ngulya barlbayi, baki wabuda. Ngulya marda wabuda walajbayi Jisusnanyi mankanyinanyi. ");
INSERT INTO wrk_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Nyuli najba nayinda bukamba barri yingamalinyi nganinyiwanyi, baki nyulu karungka narrinya nanginkanyi jangkurranyi jala ngayu yarrijba. Nayinda jangkurr duja. Nyulu narrinya karungka nanginkanyi jangkurranyi, najbangangi nyuli. Duja nangangi jangkurr. Nyuli najba nayinda bukamba barri. ");
INSERT INTO wrk_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Miku yaliyanyi dalyamba Jisus nguli. Kamambarra yanybayi wankalanyi, “Miku janyulu dalyawijba nguli.” Nanda jangkurr najana Kudkanyi jali yanyba wankalwanyi, nanda duja jangkurr, mikungangi yaliyanyi dalyamba Jisus nguli. ");
INSERT INTO wrk_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Marda mili jangkurr yanybayi wankalanyi kamambarra, “Jayalu ningkijba nanda nganinyimuknyi marda jibarrimukunyi. Jayalu ningkijba nanda jali yalu ngarrkadaba.” Nanda yingka jangkurr duja, yarrijba jali nanangini wankalawanyi najana Kudkanyi. Barriwa. ");
INSERT INTO wrk_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Baki yingka nganinyi, niji Jusib, nangangi yaji Yarimadiya. Jilajba nyuli nangandurri Biladyurri, baki ngajaka nyuli Bilad, “Jangayu kuna kuyu nanda Jisus mankanyi makaykanyi. Yuku kuna ngayu kuyu nanda nangangi mankanyi.” Jananganjayi Biladwanyi, “Yi. Kuyukiyi mankanyi.” Baki kuyuyi mankanyi Jusibwanyi. Nanda Jusib nyuli kandi Jisuskanyi, ngala miku yalunyiya karu, nyuli kandi Jisuskanyi, marralangangi nyuli yalungi Jumukuyngka. Miku yalunyiya karu nyuli kandi nangangi Jisuskanyi. ");
INSERT INTO wrk_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Baki yingka, nangangi niji Nikidimus, jalannga nyuli jilajba nangandurri Jisusyurri mungana yanybiji nangangi wabula. Kuyu nyuli nanda barrinani jirrki, ngala nanjananja, baki banjawayi kunyba kudu. Nanda yarriykanyi mankanyina. Nyuli kuyu kudukudu nanda barrinani jirrki. Kudukudu kuyuyi murrku lujuluju. ");
INSERT INTO wrk_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Baki buli kuyu mankanyi Jisus, Jusibwanyi marda Nikidimuswanyi. Wudumba buli wunanybala raki barrinani kurul. Namba buli nanda raki jirrkiyudinyi baki kijijba buli mankanyi lukuluku bukamba nukamiyurru. Kijijba buli mankanyi rakiyudinyi jirdi nanankanyi barrinani nanjananja jirrki. Kijijba buli mankanyi nanankurru nukamiyurru. Nani barri yalili kijijba mankanyi Jumukunyi. ");
INSERT INTO wrk_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Nanda yaji jali yalu langandaba Jisus, bundu nanda yingka yaji jali yukumba nganinyiwanyi. Nananyina yajina barri kumayangu yarriykanyi mankanyi kalawunyi. Buyingkinyi nanda kumayangu. Jilijbawa nanda kumayangu, miku yaliyanyi yarrijba kalawunyi mankanyi. ");
INSERT INTO wrk_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Nanda kumayangu bundu baki yarrijba yali Jisus mankanyi nananyina kumayanguna. Munganawa Sadidi jalili yalu miku waki. Miku yaliyanyi kuyu Jisus mankanyi juju. Muningka yali yarrijba mankanyi bundu. Yarrijba yali Jisus mankanyi kalawuyngkurru kumayanguna, baki murumba yali bardawa nangangi dungalayudinyi. Walkurra dungala yali lukulukumba bardawarri. Barriwa. ");
INSERT INTO wrk_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Yingkana mungana kambalingijba yaji Sundi barri. Nanda jibarri Mari, nangangi yaji Makdala, nyuli jilajba kumayangurri. Nyuli najba mikuyaji dungalanyi nanaba bardawa. Mikuyaji dungalanyi. Wilina jungkuyi nanda dungala, jali yalu murumba. ");
INSERT INTO wrk_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Baki nyuli wirlku nanda jibarri Mari. Wirlku nyuli bulandurri, Bidayurri marda yingkayurri kandirri. Wirlkuyi bulandurri. Yanyba nyuli bulangi, “Mikuyaji mankankanyi nanaba kumayanguna. Jawudawanyi yali kuyu ngambalangi mambuka. Mikuyaji mankankanyi nanaba. Wanjawa yiningki yali yarrijba mankanyi. Wanjawa. Mudumbanyi ngamabala.” ");
INSERT INTO wrk_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Walajba buli barndananyi. Walajbayi Bida baki yingka nangangi kandi, baki bayungu bula jila kumayangurri yidambiji. ");
INSERT INTO wrk_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Bayungu buli wirlku. Nanda yingka kandi, nyuli waluwa wanbiya kumayanguna. Wanbiya nyuli waluwa. ");
INSERT INTO wrk_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Baki wayngkamba nyuli kalawunyi kumayangu. Najba nyuli nanda raki kijiykanyi mankanyi kilinkurri kalawunyi, ngala miku nyuliyanyi ngankijba kalawunyi. ");
INSERT INTO wrk_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Baki wanbiyayi Bida bayngkani. Ngankijba nyuli kalawunyi kumayanguna. Miku nyuliyanyi karrinja danbina bardawana. Ngankijba nyuli kalawunyi, baki nyuli marda najba nanda raki kilinkurri nanaba. ");
INSERT INTO wrk_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","Ngala nanda yingka raki jala makaba nangki kulaji, miku nanda raki malumba nananyina yingkana rakina. Nanda raki kijiykanyi kulaji kiliyi nyuluman. ");
INSERT INTO wrk_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Baki nanda yingka kandi, jali wanbiya waluwa, marda nyuli ngankijba. Najba nyuli mikuyaji mankankanyi. Mikuyaji. Nanda yingka jala ngankijba bayngkani, nyuli jingkijba jala wankijbayi Jisus. Jingkijba nyuli Jisus, wankijbayi mili. ");
INSERT INTO wrk_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Nanamanji mudumbanyi yali nanankanyi wankalanyi jangkurranyi Kudkanyi. Mudumbanyi yali nanankanyi jangkurranyi, jali nangka janyba Jisus, baki wankijba janyulu mili. Mudumbanyi yali nanamanji. ");
INSERT INTO wrk_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Baki wijba buli karri barndarri. Wijbayi kandiwuya karri. ");
INSERT INTO wrk_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Ngala nanda jibarri Mari, wijba nyuli karrina mili kumayangurri bayngkani bulangi. Karrinja nyuli danbina. Ngindu nyuli, baki nyuli wayngkamba kalawunyi kumayangu, ngala nyuli dadijba ngindu. ");
INSERT INTO wrk_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Baki Mariwanyi najbayi kujarra Yanjil. Nanda Yanjil, yalili waki Kudkanyi. Jumbala bulangi bunyala. Jungku buli kalawunyi kumayanguna. Yingka jungkuyi kulajiyangka, yingka nukamiyangka Jisuswunyinyina yajina jalanyina. ");
INSERT INTO wrk_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Yilikajba buli jibarri Yanjilwuyanyi, “Jibarri, wanyingkanyi ninji ngindu. Wanyingkanyi.” Jananganja nyuli bulanya jibarriwanyi, “Kuyu yali ngaki mambuka jawudawanyi. Mudumbanyi ngayu wanjawa yali yarrijba mankanyi. Mudumbanyi ngayu.” ");
INSERT INTO wrk_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Jali nyulu yanyba nanda jangkurr, baki yangkalamba nangki, baki najbayi Jisus karrinjankurri. Ngala yakanajba nyuli Jisus. Mudumbanyi nyuli. ");
INSERT INTO wrk_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Yanybayi Jisus nangangi, “Jibarri, wanyingkanyi ninji nginduka. Wanyingkanyi. Baki wanyingkanyi ninji kujba.” Ngamu nyuli Jisus jungkayi nanankanyi yajinyi. Ngamu Jisus, nyuli lalanbawarr nanankanyi yajinyi. Baki ngajakayi Mariwanyi, “Jaliyi ninji dulaba mankanyi, baki wanjawa ninji yarrijbayi, baki jangayu jilajba dulaji mankanyi.” ");
INSERT INTO wrk_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Ngala yanybayi Jisus nangangi. Nijarrijbayi nangangi niji Jisuswanyi, “Mari.” Baki kudanyu ningkijbayi Mariwanyi nanda jali yanyba nangangi. Ningkijbayi, baki jingkijbayi Jisus. Yanybayi Mari nangangi Jisuskanyi. “Rabunayi.” Yalili nijarrijba mambuka milidimbawarr “Rabunayi.” Rabunayi, nayinda Ju yanyi. ");
INSERT INTO wrk_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Yanybayi Jisus nangangi, “Mikujiyi nganinjiyi marrimba. Jilijba ngayu kirrijba jila Buwakayarri. Ngala jilajbakiyi ngakinkurri kandimukuyngkurri. Karukiyi yalunya nayinda jangkurr, “Ngayu kirrijbangka nangandurri Kudyurri Buwakayarri. Nyulu ngaki Buwakanya Kud, marda nyulu narringi Buwakanya Kud.” Bukamba nanda jangkurr yanybayi Jisus nangangi Marinyi. Barriwa. ");
INSERT INTO wrk_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Baki nanda jibarri Mari, wijba nyuli karri yalundurri kandimukuyngkurri. Jali nyulu wanbiya yalundu, baki nyuli yanyba yalungi, “Najba ngayi mambuka ngambalangi.” Baki nyuli yanyba yalungi kandimukuyngka bukamba nanda jangkurr jali Jisus yanyba yalungi. Karu nyuli yalunya nanankanyi jangkurranyi Jisuskanyi. Barriwa. ");
INSERT INTO wrk_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Mungana nanamanji Sundi barri, yali jungku malumba barrawuna kandimuku nangangi. Murumba yali bardawa, kijijba yali, marralangangi yali kudanyu mambukamukuyngka Jukanyi, jali yalu wudumba Jisus. Marrala yali kudanyu yalungi. Baki wanbiyayi Jisus karrinjankiwa yalundu. Miku nyuliyanyi ngankijba bardawana. Muningka yalu najba kalawunyi karrinjankurri yalundu. Yanybayi Jisus yalungi, “Nanama narri.” ");
INSERT INTO wrk_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Yanyba nyuli nani “Nanama narri”, baki minimba nangki mawal marnina marda wilina, jali yalu ngarrkadaba. Yabijba yali muwa nangangi kandimuku jala yali jingkijba. ");
INSERT INTO wrk_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Mili nyuli yanyba yalingi, “Janarri jungku mardumardu muwa. Buwakayu ngambalanginyi, nyuli manjijba ngana narrindurri. Nani barri baku jangayu manjijba narrinya karunki yalunya yingkamuku ngaki. Janarri karu yalunya ngaki, nganinymuku marda jibarrimuku.” Barriwa. ");
INSERT INTO wrk_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Yanyba nyuli nanda jangkurr yalungi, baki nyuli wirnngalijbayi yalundu, baki nyuli yanyba, “Ngayu manjijbangka narrindurri Kunyba Ngarndu Kudkanyi.” ");
INSERT INTO wrk_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Baki mili yanybayi Jisus yalungi, “Jaliyi ninji manjamanjamba balki yaji yalungi, baki Kudwanyi janyulu najba yalunya jungunkanyi kunybana yuwana. Jaliyi ninji miku manjamanjamba yalungi balki yaji, baki yuwaji jayalu jungku balkina yuwana.” Barriwa. ");
INSERT INTO wrk_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Yingamali kandi Jisuskanyi, kujarra ninji nangangi, Dumas baki Didimus. Mikuyaji Dumaskanyi nanaba yalundu kandimukunyina marda Jisusnyina. Miku nyuliyanyi najba nanda Jisus nanamanji mungana jali jungku Jisus yalundu. ");
INSERT INTO wrk_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Baki yali karu Dumas yingkamukunyi kandimukunyi. Karu yali, “Najba nurri mambuka ngambalangi. Jungku nyuli nurrundu.” Ngala yanybayi Dumas yalungi, “Waluwa waluka jangayu najba mawal marnina. Jangayu ngankijba marni nanaba mawalina nanganginyina marnina. Jangayu ngankijba ngaki marni mawalina nangandu wilina. Jangayu ngankijba bukamba mawal nangangi, baki bayngkani jangayu kuyu narringi jangkurr, jangayu jingkijba nyulu jungkuja wanka mili. Jaliyi ngayu ngankijba mawalina nanganginyina, baki jangayu jingkijba nyulu wankijba mili.” Barriwa. ");
INSERT INTO wrk_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Baki baku, yingkana wik, nanganginmuku kandimuku, mili yali malumba jungku barrawuna. Marda nyuli nanaba yalundu marda, nanda Dumas. Murumbayi bardawana, kijijbayi kudanyu bardawa, baki wanbiyayi Jisus yalundu. Karrinjayi, baki yanybayi Jisus, “Nanama narri.” ");
INSERT INTO wrk_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Baki yanybayi Jisus nangangi Dumaskanyi, “Ningkijbakiyi mawal ngakinyina marnina. Ngankijbakiyi marni ngakinyina mawalina, baki ngankijbakiyi marni wilina mawalina. Miku ninjiyanyi kuyu yalungi jangkurr ngaki, jala ngayu wanka mili. Kuyukiyi yalungi jangkurr nanijba jala ngayu wanka.” ");
INSERT INTO wrk_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Baki nanangini Dumaswanyi, jananganja nyuli, “Ninji ngaki mambuka. Ninji ngaki Kud, ngakinmirra.” ");
INSERT INTO wrk_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Baki yanybayi Jisus nangangi Dumaskanyi, “Nganinji jingkijba, najbangangi nganinji. Ninji jingkijba jala ngayu Jisus wankijba mili. Ngala nanamuku, jalija yuwaji nganjalu jingkijba jala ngayu wankijba, ngala miku nganjalu najba, baki yabijba jayalu ngaki. Yabijba jayalu muwa ngaki, jalija nganjalu jingkijba ngayu wankijba, ngala miku nganjalu najba.” ");
INSERT INTO wrk_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","31","Nanganginmuku kandimuku, yali nanaba nangandu Jisusnyina yurrngumba. Yali jungku nangandu yurrngumba. Yali manku nangangi jangkurr bukamba. Yali najba Jisus wakinkurri. Miku nanginyina najana bukamba jangkurr jali Jisus yanyba. Miku bukamba jangkurr nangangi nayiba. Marda nanda jala nyuli waki, miku bukamba nayinda. Miku. Ngawamba jawuda jangkurr Jisuskanyi nayiba najana. Ngala bukamba nayinda jangkurr duja jangkurr. Yarrijba ngayi jangkurr najana narringi, narri kuyunkanyi nayinda jangkurr, baki janarri jingkijba Jisus, nyulu mambuka, nyulu Krayis, nyulu jandanyi Kudkanyi, nanda jala manjijbayi Kudwanyi, marda nyulu wankijbangka. Jaliyi narri kuyu nayinda bukamba jangkurr, baki janarri wanka jungku yurrngumba, nangangingangi. Barriwa. ");
INSERT INTO wrk_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Baku barri minimba nangki Jisus kandimukuyngka kanjana wilina. Kujarra nangangi niji, nanankanyi kanjanyi, Kalili baki Dayibiriyas. Nanijba yali najba Jisus. ");
INSERT INTO wrk_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Kaja yali kandimuku nanaba wabudana, nanda Bida baki Dumas, yingka niji nangangi Didimus, baki Nadanyil, nangangi yaji Kayana Kalili, marda buwakula Jayims baki Jun, bulangi buwakanya, niji nangangi Sibidi, marda kujarra mili kandiwuya. Bukamba yali jungku nanaba kanjana kandimuku. ");
INSERT INTO wrk_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Baki yanybayi Bida yalungi, “Barriwa jangayu wajarrijba kaku.” Yali yanyba nangangi, “Nurruja nganyindu marda wajarrijba kaku.” Marda yali ngankijba muwardana, baki wajarrijba yali baralala, ngala miku yaliya wudumba kaku. Mikuyaji kakunyi. Warriyaluku. ");
INSERT INTO wrk_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Kamambawurri barri karrinjayi Jisus wayka wirlina wabudana, ngala kandimuku nangangi, mudumbanyi yali nangangi Jisuskanyi. Yakanajba yali Jisus. ");
INSERT INTO wrk_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Kayayi Jisus yalungi, “Narri. Mikuyaji kakunyi narrindu kuna.” Jananganja yali, “Mikuyaji kakunyi. Mikuyaji.” ");
INSERT INTO wrk_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Kayayi Jisus yalungi, “Janybakiyi lawaka karriya muwardana, baki janarri wakaramba kaku nanaba. Janybakiyi lawaka karriya.” Baki yali janyba nanda lawaka karriya, baki wakaramba yali kaku barri junu. Kudukudu kaku. Ngiruka nyuli kudanyu nanda lawaka jali kaku kudukudu kalawunyi. Miku yaliya winymamba lawaka kingkarri. Ramba yali lawaka kajawanyi kakuwanyi. ");
INSERT INTO wrk_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Nanda kandi jali jungku yurrngumba Jisusnyina, nyuli yanyba Bidanyi, “Nanda, nyulu mambuka ngambalanginmirra. Nyulu Jisus.” Jali manku nanda jangkurr Bidawanyi, baki yawumba nangki jumbala. Mikuyaji nyuli jumbalanyi wakinkanyi, ngawamba jarrawaja. Yawumba nangki jumbala, baki jurrulaba nyuli wayka kanjana bijalina. ");
INSERT INTO wrk_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Ngala yingkamuku kandimuku, yali jilajba muwardana. Wililijba yali lawaka, marda kaku kalawunyi nanaba lawakana, ngala yali bundu bijalina, juju bijal barri. ");
INSERT INTO wrk_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Jali yalu walajba muwardananyi jambarri, baki yali najba jangu nanaba. Marda Jisus nyuli nanaba, karrinjayi janguna. Yundijba nyuli kaku baki damba. ");
INSERT INTO wrk_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Yanybayi Jisus yalungi, “Kuyu narri kaku ngakindurri, jali narri wakaramba.” ");
INSERT INTO wrk_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Baki jilajbayi Bida muwardarri baki wililijbayi lawaka bijalyurri. Nanda lawaka kajayudi kakuyudi. Mikukiya dalyawijba nanda lawaka, ngala kajayudi kakuyudi, wirdikudukudu, 153 kaku. ");
INSERT INTO wrk_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Nanamanji yalungki mankumanku, “Yiningki nanda Jisus, yiningki yingka.” Ngala miku yaliyanyi ngajaka, “Wanyi ninji.” Miku. Manyirru yali nangangi Jisuskanyi. Baki yanybayi Jisus yalungi, “Jungku narri nayiba. Wardamba narringka mamanyi.” Baki yali jingkijba nanda, nyuli Jisus, nyuli yalungi mambuka. ");
INSERT INTO wrk_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Wajba yalunyi Jisuswanyi dambanyi baki kakunyi marda. ");
INSERT INTO wrk_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Nani barri minimba nangki Jisus yalungi kandimukuyngka. Wabula kujarraka yali najba Jisus wanka, bayngkani nangki janyba barri, baki nyuli wankamba Jisus Kudwanyi. ");
INSERT INTO wrk_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Jali yalu wardajba muwa, baki yilikajbayi Bida Jisuswanyi, “Sayimin Bida, maruka ninji wajarriykanyi. Ngala wanyingkanyi ninji maruka kudanyu, wajarriykanyi kuna, ngaki kuna.” Jananganjayi Bidawanyi, “Mambuka, ninji jingkijba jala ngayu maruka muwa nganyi.” Yanybayi Jisus nangangi, “Lalanbakiyi ngakinmuku, barrinani yalu lalanbawarr, barrinani yalu lalanba jibmuku.” ");
INSERT INTO wrk_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Mili nyuli yilikajba Bida Jisuswanyi, “Sayimin Bida, maruka kuna ninji ngaki.” Jananganjayi Bidawanyi, “Yi, mambuka, ninji jingkijba jala ngayu maruka muwa nganyi.” Yanybayi Jisus nangangi, “Lalanbakiyi ngakinmuku barrinani yalu lalanba jibmuku.” ");
INSERT INTO wrk_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Baki mili yilikajbayi Bida Jisuswanyi, “Sayimin Bida, maruka kuna ninji ngaki?” Ngala nginduyi muwa Bida jali mili ngakaja Jisuswanyi nanamannga jangkurr kujarraka barndayka, “Maruka kuna ninji ngaki.” Nginduyi Bida nanankanyi nanamannga jangkurranyi. Baki nyuli jananganja, “Mambuka, ninji jingkijba bukamba yaji. Ninji jingkijba jala ngayu maruka muwa nganyi.” Baki yanybayi Jisus nangangi, “Lalanbakiyi ngakinmuku barrinani yalu lalanba jibmuku.” ");
INSERT INTO wrk_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Mili yanybayi Jisus Bidanyi, “Yanyba ngayu duja jangkurr, jala ninji juka wabula, ninji muningka jila, ngala jalija ninji malbu, baki manjijba janganyingka jalu. Janganyingka manjijba jalu, baki ngurranyiwanyi janinya kijijba jalu, kijijba janinya jalu kudanyu barri, baki kuyuja ninya yingkayurri yajiyurri ngurranyiwanyi, ngala miku ninjiyi nulijba jilaykanyi, jalija ninya kuyu nanankurri.” ");
INSERT INTO wrk_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Nanda jangkurr yanybayi Jisus Bidanyi, karunki nanda Bida jayalu daba kurdanba nganinymukunyi. Nani barri nangkaja janyba. Baki yingkamukunyi jayalu wajba Kud kunybanyi jangkurranyi, jalija nani barri nangka janyba Bida. Nani barri yanybayi Jisus Bidanyi baki mili yanybayi Jisus nangangi Bidanyi, “Jilajbakiyi ngakindu yurrngumba.” Barriwa. ");
INSERT INTO wrk_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Kulwayi Bida, baki najba nyuli nanda yingka kandi, nanda jali jungku Jisusnyina yurrngumba nangandu, nanda jali maruka Jisus muwa nangangi kudanyu, nanda jali jungku wabula bundu Jisusnyina mungana ngala yalungki wardamba mamanyi, nanda jali yanyba nanamanji, “Mambuka, wanyi nanda jalija nangka yangkalamba nganyinbunanyi.” ");
INSERT INTO wrk_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Kulwayi Bida baki najba nyuli nanda yingka kandi nangangi, baki yanybayi Bida Jisuskanyi, “Mambuka, ngala nayinda wanyimbaja.” ");
INSERT INTO wrk_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Jananganjayi Jisuswanyi, “Jalimi ngayu yanyba nangangi, janyulu jungku wanka yurrngumba nanankurri jalija ngayu wijba, ngala miku nanda nganyi yaji. Munyajbakiyi. Ninjikiyi jilajba ngakindu.” ");
INSERT INTO wrk_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Yanyba yalungkili kandimuku nanankanyi jangkurranyi yanyba jali Jisus. Mankumanku yalungki Jisuskanyi jangkurranyi. Ngamu yanybayi Jisus nangangi, “Miku nangkiyi janyba nanda kandi.” Ngala miku yanybayi Jisus miku nangkiyi janyba nanda nangangi kandi. Miku nyuliyi yanyba nani. Yinini jangkurr nyuli yanyba. Muningka nyuli yanyba nayinda jangkurr, “Jalimi ngayu yanyba nangangi, janyulu jungku wanka yurrngumba nanankurri jalija ngayu wijba, ngala miku nanda nganyi yaji.” Barriwa. ");
INSERT INTO wrk_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Ngayu nanda kandi jali najba bukamba nayinda yaji. Ngayu karungka narrinya kudukudunyi jangkurranyi nangangi Jisuskanyi. Ngayu yarrijba nayinda jangkurr najana, narri jingkiykanyi nayinda jangkurr nangangi duja barri. ");
INSERT INTO wrk_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Yanybayi Jisus kudukudu jangkurr. Nyuli kunymamba yalunya kudukudu. Miku bukamba jangkurr jali yanyba Jisus nanginyina najana. Nanda yingkamuku jangkurr Jisuskanyi, jalimi bukamba jangkurr Jisuskanyi yarrijba nganinyiwanyi najana, baki nanamuku najamuku walbinyi, kajamuku najamuku, wirdikudukudu. Barriwa barri. Bukamba nayinda jangkurr. ");
INSERT INTO wrk_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Diyubulu, wabula ngayi yarrijba jangkurr najana. Manjijba ngayi nanama jangkurr nganyindurri. Nanda naja yanybaka Jisuskanyi, jali nyulu milidimba baki kunymamba yalunya kajamuku. ");
INSERT INTO wrk_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","Baku, jali janyba nangka Jisus, wankambayi Jisus Kudwanyi, baki kirrijba nyuli kingkarri jungunki Kudnyina. Waluwa nyuli kirrijba, yanyba nyuli Jisus kandimukuyngka. Jirrinybayi Jisuswanyi kudukudunyi yajinyi. Baki buli manjijba yalunya nanamuku kandimuku. Manjijbayi Jisuswanyi marda Kunybawanyi Ngarnduwanyi Kudkanyi. Waluwa buli yarrijba nanamuku kandimuku wabula. ");
INSERT INTO wrk_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Yingamali yakarl baki bijal mili 40 kambana minimba nangki Jisus yalunburri. Jungku nyuli yalunbu, baki mili jungkuyi, baki mili. Yali jingkijba jali nyulu wanka, najba yali Jisus. Najbayi Jisus, baki yanyba yali nangangi. Yali jingkijba jali nyulu wanka jungku. Baki Jisus, nyuli karu yalunya Kudkanyi, lalanbayi yalunya yurrngumba Kudwanyi. ");
INSERT INTO wrk_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Buyingka barri baku bijal, jali Jisus yalunbu, nyuli jirrinyba yalunya nanginkanyi jangkurranyi, “Wambu narri. Jungku nayiba Jirusalim. Mikujiyi jila nanginbunanyi, nayibakiyi jungku. Janarri yukumba nayiba Jirusalim nanankanyi, manjijba jalija Kudwanyi. Wabula ngayi karu narrinya nanankanyi jalija manjijba Kudwanyi narrindurri. ");
INSERT INTO wrk_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Nanda nganinyi, niji Jun Ngurrunbawarr, nyuli yawumba narrinya wabudana, ngala Kudwanyi, janyulu yawumba nangangi Kunyba Ngarndu Kudkanyi narrindu. Janyulu yawumba Kunyba Ngarndu Kudkanyi narrindu mankanyina. Janyulu manjijba nangangi Kunyba Ngarndu narrindurri Kudwanyi.” ");
INSERT INTO wrk_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Nanamuku jali manjijba Jisuswanyi, yali malumba jungku nangandu Jisusnyina kajamuku. Yali ngajaka Jisus, “Mambuka. Ninjija kuna jungku mambuka. Janinji jungku mambuka kuna Jumukuyngka baki ngurranyimukuyngka lukuluku. Mambuka kuna janinji jungku. Winyurru kuna janinji minimba yalunya, janinji jungka mambuka bukambijuyngka.” ");
INSERT INTO wrk_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Janangajayi Jisuswanyi, “Nanda jangkurr jala ngaki Buwakanya yanybaka, nanda duja jangkurr. Jungku jangayu mambuka bukambijuyngka baku. Ngala miku narrimi jingkijba yaji baku. Ngawamba Kud, ngawamba nyulu jingkijba yaji baku. ");
INSERT INTO wrk_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Ngala janarri jungku mirnarrijba muwa, janarri jungku ngiruka, jalija Kudwanyi yawumba Kunyba Ngarndu Kudkanyi narrindu. Jalija Kudwanyi yawumba Kunyba Ngarndu nangangi Kudkanyi narrindu, baki janarri karu yalunya kudukudu ngaki. Janarri karu ngaki kudukuduna yajina, nanginyina yajina Jirusalim, nananyina yajina Judiya, baki yingkana yajina Samariya, baki yingkana yajina, bukambijina yajina. Janarri karu ngaki bukambijina yajina, wandijiyana.” ");
INSERT INTO wrk_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Jali nyulu yanyba Jisus nanankanyi jangkurranyi barriwa, baki manjijba nyuli Jisus kingkarriji Kudwanyi. Yali najba Jisus kirriykurri kingkarri ngaluna. Kujba yalungki nangangi Jisuskanyi ngaluna, ngala mikuyaji. Bayiwujba yali nangangi. ");
INSERT INTO wrk_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Jali yalu kujba nangangi ngaluna, nganinyiwuya bula karrinja yalundu. Jumbala bulangi bunyala. Buli Yanjilwuya waki jalili Kudkanyi. Karrinja buli yalundu Yanjilwuya. ");
INSERT INTO wrk_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Baki yanyba buli yalungi, “Narri, jalili jungku wabula nananyina yajina Kalili, narri kujbangka yaji lalijina. Wanyingkanyi narri kujba nangangi lalijina. Nanda Jisus, manjijbayi nanda Kudwanyi ngaluna, ngala baku janyulu wijba ngaluna. Nyuluwa wijbaja baku ngaluna.” Nani yanybayi Yanjilwuya. ");
INSERT INTO wrk_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Yali karrinja yundu kulawirana niji Yulib, jali kirrijba Jisus kingkarriji. Wijbayi nganinyiwuya kingkarri lalijiyurri Yanjilwuya, baki wijba yali Jirusalimyurri. Nanda kulawira Yulib bundu Jirusalim. Nanda kulawira bundu karru. ");
INSERT INTO wrk_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Wijba yali karrina Jirusalimyurri, baki ngankijba yali barrawuna, nananyina barrawuna jalili yalu jungku. Jungku yali nanaba, Bida, Jun, Jayims baki Yandru. Marda Bilib, baki Dumas. Bardulumu baki Madiyu, baki yingka Jayims, nangangi nijanganjinyi Yalbayis, baki Sayimin Saludi, baki Judas, nangangi nijanganjinyi Jayims. ");
INSERT INTO wrk_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Jila yalili nanankurri barrawurri yanybiji yurrngumba. Yalili yanyba mududu Kudkanyi nanaba. Marda kudiya jibarri nanaba yalundu. Nanda ngardanganja Jisuskanyi, niji Mari, marda nyuli nanaba jungku yalundu. Baki kanyiya nangangi Jisuskanyi nganinymuku, yali jungku nanaba. Malumba yalili yanyba mududu Kudkanyi nanaba barrawuna. Barriwa. ");
INSERT INTO wrk_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Nanamanji kudukudu jali mirnarrijba yalu muwa Jisuskanyi, yali malumba jungku. Kudukudu nganinymuku baki jibarrimuku, 120 yali jungku malumba. Baki yanybayi Bida yalungi. ");
INSERT INTO wrk_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","Yanyba nyuli, “Mankukiyi narri ngaki. Manku nganarri. Wabula wankala yanybayi Kunyba Ngarndu Kudkanyi. Yanyba nyuli wankalanyi mambukanyi Dayibidkanyi. Baki mambukawanyi nyuli yarrijba nanda jangkurr najana. Yarrijba nyuli jangkurr, nanda jali karu Kunybawanyi Ngarnduwanyi Kudkanyi. Yarrijbayi mambukawanyi Judaskanyi, ‘Janyulu minimba ngarrkadabawarr nanankanyi yajinyi, marrimba jayalu Jisus nanaba. Marrimba jayalu Jisus, minimbajangangi yalunya Judaswanyi nanankanyi yajinyi jalija jungku Jisus.’ ");
INSERT INTO wrk_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Nanda Judas kandi nyulili Jisuskanyi. Kandi nyulili ngambalangi. Nyuli minimba ngarrkadabawarr nananyina yajina, marrimba jayalu Jisus. Baki wudumba nyuli dungala Judaswanyi, kuyunkanyi Judaswanyi ngarrkadabawarr nanganburri.” Barriwa. Nani barri yanybayi Bida yalungi Judaskanyi. ");
INSERT INTO wrk_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Nanangini Judaswanyi nyuli wudumba dungala, kuyungangi nyuli ngarrkadabawarr nangandurri Jisusyurri. Balki. Wudumba nyuli dungala Judaswanyi. Wajba nyuli yingka nanankanyi dungalanyi, baki wudumba nyuli yaji jamba dungalana. Baki janyba nangki Judas nananyina nanganginyina jambana. Yirrba nyuli jambarri, baki dumbayi muwa. Dumbayi muwa baki walajbayi nanda karnal. ");
INSERT INTO wrk_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Bukamba jali jungku nanaba Jirusalim, manku yali nanda jangkurr Judaskanyi, nyuli wudumba dungala jali nyulu yabimba balki yaji. Manku yali Judaskanyi janyba nangki. Baki nijarrijba yali nanda jamba nangangi, nijarrijba yali “Yakildama.” Nanda Yakildama Ju yanyi, barrinani jangkurr “Ngulyayudi Jamba.” ");
INSERT INTO wrk_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Mili yanybayi Bida yalungi. Yanyba nyuli nanda jangkurr jali yarrijba wankalawanyi Dayibidwanyi najana Kudkanyi. Yanybayi Bida, “Yarrijbayi Dayibidwanyi nayinda jangkurr najana Kudkanyi, nayinda barri. ‘Mikuwali yingka nganinyi jungku nananyina jambana. Mikuwali yingkawanyi yabimba nangangi barnda nanaba.’ Baki yingka mili jangkurr yarrijbayi Dayibidwanyi, ‘Mardakimi yingka nyuluja waki nangangi ngala nangki janyba.’” Barriwa. ");
INSERT INTO wrk_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","22","Mili yanybayi Bida, “Marda ngambalimi yarrijba yingka kandi ngamandu. Marda ngambalimi yarrijba yingka, mikungangi Judas ngamandu jungunkanyi. Marda ngambalimi yarrijba yingka, nanda jala jilajbayi lukuluku ngamanbu yurrngumba Jisusnyina, nanda jali jilajba Jisusnyina yurrngumba, yurrngumba nanankardi barri jali ngurrunba yalunya Junwanyi wabudana. Marda ngambalimi yarrijba yingka nani barri, nanda jali ngamanbu yurrngumba jungku, nanda jali najba Jisus janybikurri nangka, baki wankiykurri mili. Nanda jali jila nanganbu Jisusnyina yurrngumba nanankurri barri jali wiykunumbayi Jisus kingkarri Kudwanyi.” Nani barri yanybayi Bida. Barriwa. ");
INSERT INTO wrk_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Baki yanyba yalungki kujarrayngka nganinyiwuyayngka. Yingka niji nangangi Madayis. Yingka niji nangangi Jusib. Nanda Jusib, kujarra yingamali niji nangangi, yingka Jusib, yingka Basabas, yingka Jusdus. Murrku nangangi niji. ");
INSERT INTO wrk_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Yanyba yalungki nganinyiwuyayngka, baki yanyba yali mududu Kudkanyi. Yanyba yali, “Mambuka, ninji jingkijba nanda jala nurrungki mankumanku. Ninya nurru ngajaka, minimbikanyi nurrungi, ninji minimbikanyi nurrungi nanda yingka kandi nurrundu. ");
INSERT INTO wrk_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","Janinji minimba nanda yingka kandi. Bukambaja yingkawanyi nanda jali yingijba Judaswanyi. Jabarri yingkawanyi yabimbaja yaji. Mikuwali waki Judas nani janybangangi nangki Judas, baki barlba nyuli, ngarndu nangangi nanankurri balkiyurri yajiyurri Yilyurri.” Barriwa. ");
INSERT INTO wrk_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Baki baja yali barrinani kard kujarrayngka nganinyiwuyayngka. Baja yali wakarambiji yalu nanda jali yarrijba Kudwanyi. Baki wakarambayi barri Madayiswanyi. Baki nyuli jungku yalundu Kandimukunyina Jisuskanyi. Yali jungku 11 baki nyuli yingka mili yalundu nganinyimukunyina, manjijba jali Jisuswanyi. ");
INSERT INTO wrk_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Nanamuku mungkijimuku Jumuku, yalili jilajba kajamuku nanankurri Jirusalimyurri, jungkukili malumba wurarawala. Yalili jungku malumba nanamanji wurarawala wangarranyi. Nanda wangarr Bindikus. Nanamanji Bindikus nanamuku jali kuyu jangkurr Jisuskanyi yali malumba jungku yingamalina barndana. Jungku yali marda malumba. ");
INSERT INTO wrk_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Baki manku yali kirirr bardaykurri kingkarrinya. Nanda kirirr barrinani kururlwayi walkurra yunkurr. Manku yali kirirr jala yali jungku barndana. ");
INSERT INTO wrk_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Baki najba yali yaji, nanda barrinani jangu lukuluku. Nanda barrinani jangu, nanda jungkuyi yalundu kulajina, bayakarda mirnbi barrinani. ");
INSERT INTO wrk_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Nanamuku kajamuku barndana, yawumbayi Kunyba Ngarndu Kudkanyi kalawunyi yalundu mankanyina Kudwanyi. Yawumbayi nangangi Ngarndu yalundu Kudwanyi, baki minimbayi yalunya Kunybawanyi Ngarnduwanyi Kudkanyi, yalu yanybiji yinini yinini yanyi. Kudiya yali yanyba yingka yanyi, kudiya yanybayi yingka yanyi, kudiya yingka yanyi. Nani barri yali yanyba yinini yinini yanyi, jali yawumba Kunyba Ngarndu Kudkanyi bukamba yalundu Kudwanyi. ");
INSERT INTO wrk_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Nanamanji kajamuku Jumuku yali jungku nanaba Jirusalim. Nanamuku yali mirnarrijba yalu muwa Kudkanyi, yali jilajba nanankurri Jirusalimyurri wangarranyi, Bindikuskanyi. Yali jilajba jujunanyi, langina, kulani, bayunguna, karrina nanankurri barri. ");
INSERT INTO wrk_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Jala yali manku kirirr barrinani walkurra yunkurr, kudukudu yali jilajba nanankurri barndarri. Jilajba yali naji wanyingi ngirringirrimbayi yaji. Yali najba nanamuku jali kuyu jangkurr Jisuskanyi, baki manku yalunjali yanybikurri yinini yinini yanyi. Yali manku nanda yanyi jali yalungkili yanyba nananyina yingkana yajina juju jala yalili jungku. Manku yali nanda yanyi jali yalungkili yanyba. Manku yali yinini yinini yanyi, baki manmala yali kudanyu. ");
INSERT INTO wrk_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Manmala yali kudanyu, baki yanyba yalungki, “Nanginmuku jala yanyba kaja yanyi nani, yalungi yaji Kalili. Ngawamba yali jingkijba nanda Kalili yanyi yalkunyi. Miku yalimi jingkijba nanda jangkurr yanyba jala nurru. ");
INSERT INTO wrk_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Ngala yali yanyba yinini yanyi kaja barri. Ngambala manku jangkurr ngamanginmirra yanyi. Yanka yali yanyba yinini yanyi. ");
INSERT INTO wrk_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Ngambala jingkijba yalungi jangkurr. Ngambala jingkijba ngamanginmirra yanyi, ngala ngambalili jungku kajana yajina lukuluku. Jungku ngambalili kajana yajina, Bardiya, Midiya, Yilam, baki Misubidamiya. Kudiya ngambalili jungku Judiya, Kabadusiya, baki Bundus, Yasiya. ");
INSERT INTO wrk_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","Kudiya ngambalili jungku Brijiya, Bambiliya, Yijib, baki Libiya bundu Sayirin. Kudiya ngambalili jungku Rum. Kudiya ngambala Jumuku. Kudiya ngambala ngurranyimuku, jungkukili yingkana kajana yajina. Bukamba ngambala maruka muwa Kudkanyi. ");
INSERT INTO wrk_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","Kudiya ngambalili jungku Krid, baki Yarabiya. Ngala bukamba ngambala maruka muwa Kudkanyi. Manmala ngambala kudanyu jala ngambala manku nanginmuku nganinyimuku yanybikurri yinini yanyi. Manmala ngambala kudanyu. Yanyba yalu kaja yanyi. Yalu karu ngambalanya kajanyi ngirukanyi yajinyi jali yabimba Kudwanyi. Karu yalu nanamannga jangkurr. Yalu yanyba kaja yanyi.” Barriwa. Nani yalungki yanyba nanamuku jali yalu jilajba nanankurri. Barriwa. ");
INSERT INTO wrk_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Manmala yali kudanyu. Miku yaliyanyi jingkijba yaji. Yililikajba yalungki, yililikajbayi, “Yanka yalu yanyba nanda yinini yinini yanyi. Yanka yalu yanyba.” Barriwa. Nani yalungki yilikajba. ");
INSERT INTO wrk_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Jawuda yali yanyba nani, ngala jawuda yali yanyba, “Wanindijbangka kulaji. Yanyba yalu yinini jangkurr, ngarabangangi yali kaja kamukamu. Wanindijbangka kulaji.” Barriwa. ");
INSERT INTO wrk_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Ngala nanda Bida, jungku nyuli yalundu, manjijba jali Jisuswanyi. Karrinja nyuli, baki kaya nyuli kudanyu muranyi. Kaya nyuli, “Narri mungkiji ngaki, baki bukamba narri jalili jungku Jirusalim. Manku nganarri. Janga karu narrinya nanginkanyi jala narri manku. ");
INSERT INTO wrk_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Nanda jangkurr kamukamunyi, miku nanda duja. Miku nurru wanindijba kulaji. Yuwaji yalibala. Jumuku ngambala. Miku ngambalili ngaraba yalibala. ");
INSERT INTO wrk_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Janga karu narrinya jangkurranyi Kudkanyi. Yarrijbayi jangkurr najana wankalawanyi barri, niji Jul. Mankukiyi nayinda jangkurr nangangi wankalanyi. ");
INSERT INTO wrk_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","Yanybayi Kud wankala, ‘Baku juju janga yabimba kudukudu. Janga yabimba kudukudu ngiruka yaji. Janga yawumba ngaki Kunyba Ngarndu yalundu bukambijunyina. Jandanyi narringi, nganinymuku, jibarrimuku, jayalu yanyba ngaki jangkurr. Kaburrwaburr narringi, jayalu buwarrajimba yaji, baki malbumalbu narringi jayalu buwarrajimba yaji marda. Jayalu buwarrajimba yaji Kudkanyi ngala yalu yamininyi jungku. Jayalu buwarrajimba yaji, yabimba jalija Kudwanyi. ");
INSERT INTO wrk_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Yi. Janga yawumba ngaki Kunyba Ngarndu yalundu wakiwarr marda. Nganinymuku baki jibarrimuku wakiwarr, jayalu yanyba ngaki jangkurr. ");
INSERT INTO wrk_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Janga yabimba ngiruka yaji lalijina, baki jambana. Janga yabimba ngulya, baki jangu, baki walkurra kurnngarr. ");
INSERT INTO wrk_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Mungijbaja yaji bukamba, mikuyaji ngardaranyi. Nanda yakarl, janyulu nganmarra barrinani ngulya. Waluku janyulu yabimba nanda yaji Kudwanyi. Bayngkani jalija nyulu wijba, janyulu yanyba yalungi bukambijuyngka, jali yalu barimba yaji, jali yalu balkijba yaji. ");
INSERT INTO wrk_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Nanamanji barri nanda jala kaya Kudkanyi, nanda jala ngindu jungunkanyi nyulu balki, jalija nyulu kaya Kudkanyi, baki baku marrimbaja nanda mardarda Kudwanyi.’ Bukamba nanda jangkurr yanybayi wankalanyi. ");
INSERT INTO wrk_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","Mili yanybayi Bida yalungi, “Manku nganarri mili. Narri Jumuku. Minimba nyuli Jisuskanyi, nangangi yaji Nasarid. Minimbayi ngambalanya Kudwanyi Jisuskanyi. Nanda Jisus nyuli walkurra mambuka. Narri najba nanda kudukudu yaji ngiruka, jali yabimba Jisuswanyi. Narri najbayi Jisus yabimbikurri nanda ngiruka yaji kudukudu. Narri jingkijba Jisus, nyuli milidimba kajamuku, kunymamba nyuli kajamuku. Narri jingkijba nanda ngiruka yaji kaja, jali nyulu yabimba Jisuswanyi. Kandimbayi Jisus Kudwanyi. Yabimba buli yaji ngiruka. Nani narri jingkijba. ");
INSERT INTO wrk_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Waluwa janyba nangki Jisus, waluwa barri, jingkijbayi narrinya Kudwanyi. Jingkijbayi narrinya nanankanyi jalija narri yabimba, narri kurdanbiji Jisus. Janyba nangkaja Jisus wabangkarra kurndana. Langandaba janarri Jisus kurndana. Ngarrkadaba janarri. Jingkijbayi Kudwanyi waluwa, ngala dadijba manjijba nyuli Jisus. ");
INSERT INTO wrk_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Baku bijal barri jala janyba nangki Jisus, baki wankamba nyuli Jisus Kudwanyi. Nanda Jisus, nyuli walkurra mambuka. Nanamukunyi nganinyimukunyi yali kurdanba Jisus, ngala nyuli wankijba mili. Miku nangkiya janyba yurrngumba, ngala Kud nyuli ngiruka. Ngiruka nyuli wankambikanyi Jisus mili. Wankijbayi Jisus baku bijal. Barriwa. ");
INSERT INTO wrk_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Yarrijbayi jangkurr najana yingkawanyi wankalawanyi, niji nangangi Dayibid. Yarrijba nyuli najana Kudkanyi, ‘Najba niyanya, ngaki mambuka ngakindu. Jungku nungkala malumba. Miku jangana yalu julwamba, jungkungangi nungkala malumba. Miku ngayiyi marrala. ");
INSERT INTO wrk_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Maruka ngayu muwa, mambukangangi nyulu ngakindu. Yanyba ngayu kunyba jangkurr nangangi, jingkijbangangi ngayu nayinda, jalija ngaka janyba, baki jangayu wankijba mili. Jungku jangayu wanka yurrngumba. Nanda ngayu jingkijba baki maruka ngayu muwa. ");
INSERT INTO wrk_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Jingkijba ninya Kud. Jingkijba ngayu, miku janganinji yingijba mankanyi ngujbuliykanyi, jalija ngaka janyba. Mikuwali ngujbulijba ngaki mankanyi, mikuwalingangi ngaki ngarndu barlba karrurriji. Mikuwali ngaki ngarndu barlba karrurriji, baki mikuwali ngujbulijba ngaki mankanyi. ");
INSERT INTO wrk_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Minimbayi ninji ngaki nayinda, janyba jangaka, baki janga wankijba mili. Maruka jangayu muwa, jingkijbangangi ngayu, jangayu jungku nganyindu.’ Nani yanybayi wankala. Barriwa.” ");
INSERT INTO wrk_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","Mili yanybayi Bida, milidimba nyuli muran. Yanybayi Bida. “Mungkijimuku, nayinda jangkurr duja. Janyba nangki nanda wankalanyi Dayibid. Janyba nangki baki yali makaba nangangi mankanyi jambana. Makaba yali jambana bundu nayiba. ");
INSERT INTO wrk_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Nanda wankalanyi Dayibid, nyuli yanyba jangkurr Kudkanyi. Waluwa juju karuyi Dayibid Kudwanyi. Karuyi Kudwanyi nanginkanyi jangkurranyi, baku juju janyulu manjijba mungkiji. Nanda jalija manjijba Kudwanyi janyulu walkurra mambuka bukambijuyngka. Barriwa. Nanda Dayibid, nyuli walkurra mambuka Jumukuyngka. Baki manjijbaja yingka walkurra mambuka Kudwanyi juju bayngkani Dayibidkanyi, ngala nangki janyba wabula.” Barriwa. ");
INSERT INTO wrk_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Mili yanybayi Bida, yanyba nyuli, “Jingkijbayi Dayibidwanyi, yingka mambuka manjijbaja. Yarrijba nyuli nayinda jangkurr Dayibidwanyi. Yarrijba nyuli jangkurr nangangi jingkiykanyi nyuli yingkanyi walkurrayngka mambukanyi. Yarrijba nyuli nayinda jangkurr, ‘Mikuwali nangangi mankanyi kili jambana. Miku nyuliyi yingijba jambana, jalija nangka janyba. Mikuwali ngujbulijba mankanyi nangangi, jalija yalu makaba mankanyi jambana.’ Yarrijba nyuli nanda jangkurr, mambukanyi Dayibidwanyi, jingkijbangangi nyuli mambuka walkurra, wankijba janyulu mili.” Barriwa. ");
INSERT INTO wrk_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Yanybayi Bida yalungi muranyi, “Miku nanda mankanyi Jisuskanyi kiliyi jambana. Wankambayi Jisus mankanyi Kudwanyi. Najba nurri nanda Jisus wankiykurri. Najba nurri wankijbayi. ");
INSERT INTO wrk_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Nanda Jisus, kirrijba nyuli kingkarri lalijiyurri. Jungku nyulu kingkarri Kudnyina nangandu. Wajbayi Jisus Kunybanyi Ngarndunyi nanganginkanyi Kudwanyi. Wajbayi Jisus nanganginkanyi Ngarndunyi Kudwanyi. Baki Kud Buwakanya nangangi Jisuskanyi, wabula juju yanyba nyuli waykanyi Jisus Ngarndunyi. Yanyba nyuli waykanyi Jisus Kunybanyi Ngarndunyi Kudkanyi. Nayimanji barri, yawumbayi Kunyba Ngarndu Kudkanyi nurrundu Kudwanyi. Yawumbayi Kunyba Ngarndu Kudkanyi nurrundu Kudwanyi, baki yuku yanyba nurru yinini yinini yanyi. Nani yuku yanyba nurru, yawumbangangi Jisuswanyi Kunyba Ngarndu Kudkanyi nurrundu. Yabimba nurru kudukudu ngiruka yaji. Yuku yanyba nurru kaja yanyi. Nani yuku yabimba nanijba, baki yuku yanyba nurru yanyi, wajbangangi nurrunya Jisuswanyi Kunybanyi Ngarndunyi Kudkanyi. Barriwa. ");
INSERT INTO wrk_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","35","Nanda mambuka Dayibid, miku nyuliyi yayanyba nanganginmayngka nanda jangkurr, jali ngayunarrinya karu. Miku nyuliyi kirrijba kingkarri barrinani Jisus kirrijbayi. Mili jangkurr yarrijbayi najana Dayibidwanyi. Yarrijba nyuli nayinda jangkurr, ‘Karuyi mambuka ngaki Kudwanyi, bulija jungku malumba kingkarri, Kud baki mambuka. Karu nyuli mambuka ngurrayngkanyi Kudwanyi, miku jayalu yabimba kiji nangangi mambukanyi ngurranyiwanyi. Nyulu ngirukamirra bukambijuyngka. Janyulu mambuka, janyulu mambuka bukambijuyngka nganinymukuyngka baki jibarrimukuyngka.’” Barriwa. Nani yanybayi Bida yalungi. ");
INSERT INTO wrk_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","Baki mili yanybayi Bida yalungi, “Marda narrimi Jumukunyi jingkijba nayinda jangkurr. Nanda Jisus, narri kurdanba nanda. Ngarrkadaba narri kurndana. Kurdanba narri, ngala nyuli yarrijba Jisus Kudwanyi. Yarrijba nyuli Jisus walkurramirra mambuka bukambijuyngka. Nanda Jisus yingka niji nangangi, Krayis. Nanda niji Krayis, barrinani ‘nanda jala yarrijba Kudwanyi.’” Barriwa. ");
INSERT INTO wrk_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Jali manku yalu jangkurr Bidanyi, baki ngindu yali muwa muran. Ngindu yali kudanyu, kurdanbangangi yali Jisus. Yilikajba yali nanamuku jali manjijba Jisuswanyi. Yilikajba yali, “Narri, kandimuku Jisuskanyi. Wanyimba janurru. Wanyimba janurru.” ");
INSERT INTO wrk_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Jananganjayi Bidawanyi, “Marda miku narrimi jungku balkina yuwana Kudkanyi. Marda narrimi waluku ngindu balkinyi yajinyi, nanda jalili narri yabimba, baki marda narrinyimi ngurrunba. Marda narrinyimi ngurrunba, babdayis barri narrinya, durrijba jala jangkurr Jisuskanyi. Baki janyulu manjamanjamba narringi balki yaji Kudwanyi. Baki janyulu yawumba nangangi Kunyba Ngarndu narrindu Kudwanyi. ");
INSERT INTO wrk_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Wabula juju wankala yanybayi Kud, janyulu wajba narrinya nanganginkanyi Kunybanyi Ngarndunyi. Janyulu wajba yalunya marda, jandanyimuku narringinmuku. Nanda jangkurr waykanyi Kunybanyi Ngarndunyi Kudkanyi, yanybayi Kud nanda jangkurr bukambijuyngka jala yalu jungku nanijba, marda jala bayngkani yaluja wanbiya. Yanybayi Kud nanda jangkurr bukambijuyngka jala yarrijba nyulu yalunya, yalu jilaykanyi nangandurri.” Barriwa. ");
INSERT INTO wrk_vpl VALUES ("AC2_40","074_2_40","