﻿USE sofia;
DROP TABLE IF EXISTS sofia.wos_vpl;
CREATE TABLE wos_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES wos_vpl WRITE;
INSERT INTO wos_vpl VALUES ("JH1_1","033_1_1","JON","1","1","1","Nak nukwa Néma Du Got Jonaka dé hundi wa. Jona dé Amitaina nyan dé. ");
INSERT INTO wos_vpl VALUES ("JH1_2","033_1_2","JON","1","2","2","Got déré dé angi wa, “Méni sé raama yi nukwa xalekwa sakuré. Ye méni wun némafwi getéfa Ninifambu xakutaméni. Xaakwa hundi hambukmbu wa, Ninifana du takwaka. Wuni wundé xéwu di haraki saraki sémbut hurundaka.” ");
INSERT INTO wos_vpl VALUES ("JH1_3","033_1_3","JON","1","3","3","Wungi wandéka dé Jona hélék ya. Métaka we? Ninifa di Isrelna mama di. Hélék ye dé Gotré yatakanjoka dé Tarsisré yaange yi. Tarsis afakémbu dé re, nukwa nandikwa sakumbu. Ye dé Jopambu xaku. Xaakwa dé xé gunjambé Tarsisré yinjoka yae téléka. Xétaka dé gunjambéka hatikwa duka yéwa hwe. Hwetaka dé gunjambéré wulayi, di wali Tarsisré yinjoka. Dé Gotré yatakataka yinjoka dé mawuli ya. ");
INSERT INTO wos_vpl VALUES ("JH1_4","033_1_4","JON","1","4","4","Ye di gu nyéndékmbu téndaka dé Néma Du Got némafwi mur takandéka dé ya. Yandéka dé gu némafwimbu dé ramé. Raama dé gunjambéré yafélaménjoka huru. ");
INSERT INTO wos_vpl VALUES ("JH1_5","033_1_5","JON","1","5","5","Wungi hurundéka di gunjambémbu jémba yakwa du di roo. Roota di deka nak nak gotka di wa. Wataka di gunjambémbu rendé jondu héraata di guré yaki gunjambé xéréfweka xalendéte. Wungi huta téndaka Jona gunjambéna biyakombu dé némafwi xéndi dé hwa. ");
INSERT INTO wos_vpl VALUES ("JH1_6","033_1_6","JON","1","6","6","Wungi hwandéka dé gunjambéka hatikwa du Jonaka dé hwaké. Hwaka xétaka dé sérkené. Sérkena dé wa, “Métaka méni xéndi hwae? Sé raama ména gotka mé wa. Wamét nanika saréfa nakéndé wana yingi wana. Nanika saréfa nandét, nani yamba hiyakéme.” Dé wungi wa. ");
INSERT INTO wos_vpl VALUES ("JH1_7","033_1_7","JON","1","7","7","Gunjambémbu jémba yakwa du waréngéna di wa, “Mé yangut nana atéfék xi haaye bu wurmbu lakwakwa. Lakwataka bu yawiwalendotaka tara bu xékwa, héndé du dé haraki hurundéka dé ané xakéngali xaku.” Wungi wataka di wandanéngala nae di xé Jonana xi takumbu rendéka. ");
INSERT INTO wos_vpl VALUES ("JH1_8","033_1_8","JON","1","8","8","Xétaka di Jonaka wa, “Méni naniré mé wa! Méta yaméka dé ané xakéngali xaku? Méta jémba yaméka? Méni yénéna méni ya? Méni yén getéfana méni? Méni yén héméngwal méni?” ");
INSERT INTO wos_vpl VALUES ("JH1_9","033_1_9","JON","1","9","9","Wungi wandaka dé wa, “Wuni Hibruna du wuni. Wuni Néma Du Gotna xi harékéwuka dé. Dé anwarmbu dé re. Dé hafu dé atéfék gu héfa akwi atéfék jondu akwi dé hurataka.” ");
INSERT INTO wos_vpl VALUES ("JH1_10","033_1_10","JON","1","10","10","Wungi we dé wa, “Wuni Gotré yatakataka yaange yinjoka wuni ya.” Wandéka xékétaka di wungi roo. Roota di wa, “Métaka méni wungi huru? Wungi haraki méni huru!” ");
INSERT INTO wos_vpl VALUES ("JH1_11","033_1_11","JON","1","11","11","Wungi wandaka dé gu némafwimbu dé ramé. Raméndéka di Jonaré wa, “Méniré métaki yambet gu jémba tékéndé?” ");
INSERT INTO wos_vpl VALUES ("JH1_12","033_1_12","JON","1","12","12","Wungi wandaka dé wa, “Wuniré hura guré yakingut, gu jémba tétandé. Wuni wuni xékélaki wuni haraki huruwuka dé némafwi xakéngali xaku.” ");
INSERT INTO wos_vpl VALUES ("JH1_13","033_1_13","JON","1","13","13","Wungi wandéka di déré guré yakinjoka di roo. Roota di gu némafwimbu tu. Tuwa hari Jonaré tufwambu takanjoka di hurufatiké. Gu tuwa yindaka dé gu némafwi némafwimbu dé ramé. ");
INSERT INTO wos_vpl VALUES ("JH1_14","033_1_14","JON","1","14","14","Raméndéka di Néma Du Gotka wa, “Néma Du, nani ménika nani we. Nani amba duré guré yakimbet, naniré hasa xiyakéméni. Méni nana sémbutré du xiyana sémbut maki sarékékéméni. Méni mawuli yamékangalambu dé ané xakéngali xaku. Xakundéka déré hura guré yakikwe.” ");
INSERT INTO wos_vpl VALUES ("JH1_15","033_1_15","JON","1","15","15","Wataka di Jonaré hura di guré yaki. Yakindaka dé némafwimbu raméndé gu bari jémba té. ");
INSERT INTO wos_vpl VALUES ("JH1_16","033_1_16","JON","1","16","16","Gu jémba téndéka di gunjambémbu rekwa du némafwimbu di roo, Gotka. Roota di Néma Du Gotka nawulak jondu hweta di dé wali hundi bulésékéréké. ");
INSERT INTO wos_vpl VALUES ("JH1_17","033_1_17","JON","1","17","17","Guré yakindaka dé Néma Du Got némafwi xéri hamwika wandéka dé ya. Yae dé Jonaré nyéréké. Nyérékéndéka dé Jona xéri hamwina biyakombu dé re, nukwa hufuk gan hufuk. ");
INSERT INTO wos_vpl VALUES ("JH2_1","033_2_1","JON","2","1","1","Jona xéri hamwina biyakombu reta dé déka Néma Du Gotka dé wa. ");
INSERT INTO wos_vpl VALUES ("JH2_2","033_2_2","JON","2","2","2","Dé angi wa, “Néma Du Got, wuni némafwi xak héraata reta wuni ménika we. Wawuka méni wambula wuniré wa. Wuni hiyangambana téfambu géraata reta wuni ménika we. Gérawuka méni xéké. ");
INSERT INTO wos_vpl VALUES ("JH2_3","033_2_3","JON","2","3","3","Méni wuniré guré méni yaki, andéla séké nyambaré. Guré yakiméka dé gu wuniré yakitéfi. Ména gu atéfék raama yae dé wuniré yakitéfi. ");
INSERT INTO wos_vpl VALUES ("JH2_4","033_2_4","JON","2","4","4","Yakitéfindéka wuni wuna mawulimbu wuni wa, ‘Néma Du Got wuniré hérekindéka wuni ambu re. Reta wuni déka tempel wambula xétawuni.’ Wungi wuni wa. ");
INSERT INTO wos_vpl VALUES ("JH2_5","033_2_5","JON","2","5","5","Gu wuniré yakitéfindéka wuni yanambi yike ye. Gu wuniré atéfék dé yakitéfi. Gumbu rekwa wara wuna anéngambambu dé gisangwandé. ");
INSERT INTO wos_vpl VALUES ("JH2_6","033_2_6","JON","2","6","6","Wuni naande naande gumbu rekwa némbuna mombu wuni xaku. Wuni séndé ge maki hafwaré wuni naande yi. Nandiwuka méni Néma Du Got, wuna Néma Du Got, wuniré wambula héraméka wuni huli re. ");
INSERT INTO wos_vpl VALUES ("JH2_7","033_2_7","JON","2","7","7","Némafwi Du, wuni angi wuni saréké, ‘Hiyatawuni.’ Saréka wuni ménika saréké. Saréka wuni méniré wawuka méni ména yikafre male némafwi gembu reta méni wuna hundi xéké. ");
INSERT INTO wos_vpl VALUES ("JH2_8","033_2_8","JON","2","8","8","Yénataka gotna xi harékékwa du di ména yikafre sémbut wundé yatakanda. ");
INSERT INTO wos_vpl VALUES ("JH2_9","033_2_9","JON","2","9","9","Yatakandaka wuni gwar waata wuni ména xi haréké. Harékéta wuni wuna jondu ménika hwetawuni. Wawunéngala hurutawuni. Néma Du Got méni natafa male naniré wambula héraméka nani huli té.” ");
INSERT INTO wos_vpl VALUES ("JH2_10","033_2_10","JON","2","10","10","Wungi wandéka dé Néma Du Got xéri hamwika wandéka hari dé xéri tufwambu Jonaré gwiyataka. ");
INSERT INTO wos_vpl VALUES ("JH3_1","033_3_1","JON","3","1","1","Hukémbu Néma Du Got wambula dé hundi wa Jonaka. Dé angi wa, ");
INSERT INTO wos_vpl VALUES ("JH3_2","033_3_2","JON","3","2","2","“Méni sé raama yi wumba némafwi getéfa Ninifaré. Ye méni hambukmbu mé wa wawun hundi Ninifana du takwaka.” ");
INSERT INTO wos_vpl VALUES ("JH3_3","033_3_3","JON","3","3","3","Wandéka dé Néma Du Gotna hundi xéka raama dé yi Ninifaré. Ninifa némafwi getéfa dé. Du nak angé sakuré yinjoka nukwa hufuk yitandé. ");
INSERT INTO wos_vpl VALUES ("JH3_4","033_3_4","JON","3","4","4","Ye Ninifambu xaakwa dé wulayi. Natafa nukwa wulaaye dé hambuk hundimbu dé angi wa, “Nukwa dumi yétiyéti (40) yindét Got Ninifaré haraki hurutandé.” ");
INSERT INTO wos_vpl VALUES ("JH3_5","033_3_5","JON","3","5","5","Wungi wandéka di Ninifana du takwa Gotna hundi xéka di hénoo yakérta di gérémbandé nukwa wur di naki, Gotré deka saréfa na wakwenjoka. Di deka néma du takwa akwi baka du takwa akwi di wungi huru. ");
INSERT INTO wos_vpl VALUES ("JH3_6","033_3_6","JON","3","6","6","Wungi hurundaka dé Ninifana némafwi du akwi dé Gotna hundi xéké. Xékétaka dé déka yikafre jambé yatakataka dé déka yikafre nukwa wur lafwitaka dé gérémbandé nukwa wur sandataka dé bombu re. ");
INSERT INTO wos_vpl VALUES ("JH3_7","033_3_7","JON","3","7","7","Reta dé hundi takandéka dé yi, atéfék Ninifana du takwaka. “Wuni guna némafwi du wuna néma du akwi nani angi we, ‘Atéfék du takwa hénoo yamba sakénguni. Guna bulmakau sipsip hamwi akwi yamba sakéndi. Hélingu hénoo akwi yamba sakénguni! ");
INSERT INTO wos_vpl VALUES ("JH3_8","033_3_8","JON","3","8","8","Atéfék du takwa bulmakau sipsip hamwi akwi gérémbandé nukwa wur mé sandataka. Sandatakataka guni némafwimbu mé guni wa, Gotka. Guni atéfék guna nak maki nak maki haraki saraki sémbut, guna du xiyana sémbut akwi mé guni yataka. ");
INSERT INTO wos_vpl VALUES ("JH3_9","033_3_9","JON","3","9","9","Yatakambet Got déka mawuli wi yatakataka nanika saréfa natandé wana. Nanika saréfa nandét nani yamba hiyakéme.’” Dé wungi wa. ");
INSERT INTO wos_vpl VALUES ("JH3_10","033_3_10","JON","3","10","10","Wungi hurundaka dé Got wundé xéndé di deka haraki saraki sémbut yatakandaka. Xétaka dé dika saréfa nae dé dika déka biya mawuli wihambandé. Dé dika wandén maki huruhambandé. ");
INSERT INTO wos_vpl VALUES ("JH4_1","033_4_1","JON","4","1","1","Huruhafi yandéka dé Jona hélék ya. Hélék ye dé Gotka mawuli wi. ");
INSERT INTO wos_vpl VALUES ("JH4_2","033_4_2","JON","4","2","2","Mawuli wiya dé Gotka wa, “Néma Du, méni wuna hundi mé xéké. Wuni getéfa yatakahafi ye wundé xékélakiwu, méni wungi maki male hurumékandé. Wungi xékélaki wuni Tarsisré yaange yinjoka wundé yiwu. Yiwun mo angi dé, wuni xékélaki méni saréfa naakwa Got méni. Méni bari hari mawuli wihafi méni. Méni nanika saréfa male naméka dé. Méni nanika mawuli mawuli yaméka dé. Mawuli mawuli yaméka di nawulak du deka haraki sémbut yatakandat, dika saréfa nae méni diré haraki huruhafi méni. ");
INSERT INTO wos_vpl VALUES ("JH4_3","033_4_3","JON","4","3","3","Méni wungi maki némbuli diré haraki huruhafi yamét, wuni hiyanjoka wuni mawuli ye. Wuni némbuli hiyawut, wu yikafre dé. Wuni némbuli hiyahafi yawut, wu haraki dé.” Jona dé wungi wa. ");
INSERT INTO wos_vpl VALUES ("JH4_4","033_4_4","JON","4","4","4","Wungi wandéka dé Néma Du Got déré wa, “Méni wungi mawuli wiméka yikafre wana haraki wana?” ");
INSERT INTO wos_vpl VALUES ("JH4_5","033_4_5","JON","4","5","5","Wungi wandéka dé Jona getéfa yatakataka gwande ye dé nukwa xalekwa sakumbu re. Reta dé boro yakitaka dé hakélékombu re. Reta dé haxéta re, joo nak Ninifambu xakundét xénjoka. ");
INSERT INTO wos_vpl VALUES ("JH4_6","033_4_6","JON","4","6","6","Haxéta rendéka dé Néma Du Got wandéka dé bangwi nak wara dé Jonaré wundé takatéfindé. Takatéfindéka dé nukwa Jonaré xéhambandé. Xéhafi yandéka dé Jona wun bangwikombu reta mawuli sawuli dé ya. ");
INSERT INTO wos_vpl VALUES ("JH4_7","033_4_7","JON","4","7","7","Mawuli sawuli yata rendéka dé gan hunyindéka xitélakéndéka dé Got hawe nakéka wandéka dé ya. Yae dé wun bangwina moré dé sa. Sandéka dé bangwi wungi hiya. ");
INSERT INTO wos_vpl VALUES ("JH4_8","033_4_8","JON","4","8","8","Hiyandéka dé nukwa xale. Xalendéka dé Néma Du Got takandéka dé séfi ya xérékékwa mur nukwa xalekwa sakumbu dé ya. Yandéka dé nukwa Jonana anéngambambu dé xé. Xéndéka dé déka anéngamba jinjawe yandéka dé xakrinjoka huru. Xakrinjoka hura dé wa, “Wuni hiyanjoka wuni mawuli mawuli ye. Hiyawut, wu yikafre dé.” ");
INSERT INTO wos_vpl VALUES ("JH4_9","033_4_9","JON","4","9","9","Wandéka dé Got Jonaré dé angi wa, “Wumba bangwi hiyandéka méni biya mawuli wi. Biya mawuli wiméka yikafre wana?” Wandéka dé Jona wambula angi wa, “Yawundu! Wuna mawuli wi wu yikafre dé. Wuni némafwimbu wuni biya mawuli wi. Wuni hiyanjoka wuni we.” ");
INSERT INTO wos_vpl VALUES ("JH4_10","033_4_10","JON","4","10","10","Mawuli windéka dé Néma Du Got déré angi wa, “Wumba bangwi natafa male ganmbu dé bari hari waré. Wara dé nakémba gan dé hiya. Méni déré yalefu huratakahambaméni. Méni huratakaméka waréhambandé. Méni wumba yalefu jooka méni saréfa nae. ");
INSERT INTO wos_vpl VALUES ("JH4_11","033_4_11","JON","4","11","11","Wuni hafu wuni Ninifaka saréfa wuni nae. Ninifa némafwi getéfa dé. Séfélak yikama nyangwal wumbu di re (120,000). Di deka yika tamba aki tambaka yike di ye. Séfélak bulmakau bali akwi wumbu di re.” Néma Du Got wungi dé wa. ");
INSERT INTO wos_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Ané Jisas Kraisna gwal mandékana xi. Jisas Devitna hémémbu dé xaku. Devit Abrahamna hémémbu dé xaku. ");
INSERT INTO wos_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Abraham Aisakna yafa dé. Aisak Jekopna yafa dé. Jekop wun Juda déka nyamangu bandingu wali deka yafa dé. ");
INSERT INTO wos_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Juda dé Peres bér Serana yafa dé. Bérka ayiwa Tamar lé. Peres Hesronéna yafa dé. Hesron Ramna yafa dé. ");
INSERT INTO wos_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Ram Aminadapna yafa dé. Aminadap Nasonéna yafa dé. Nason Salmonéna yafa dé. ");
INSERT INTO wos_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salmon Boasna yafa dé. Boasna ayiwa Rahap lé. Boas Obetna yafa dé. Obetna ayiwa Rut lé. Obet Jesina yafa dé. ");
INSERT INTO wos_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Jesi Israelna du takwa deka néma du Devitna yafa dé. Devit Solomonéna yafa dé. Solomonéna ayiwa tale Uriana takwa lé. ");
INSERT INTO wos_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Solomon Rehoboamna yafa dé. Rehoboam Abiyana yafa dé. Abiya Asana yafa dé. ");
INSERT INTO wos_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asa Jehosafatna yafa dé. Jehosafat Joramna yafa dé. Joram Usiana yafa dé. ");
INSERT INTO wos_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Usia Jotamna yafa dé. Jotam Ahasna yafa dé. Ahas Hesekiana yafa dé. ");
INSERT INTO wos_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Hesekia Manasena yafa dé. Manase Amosna yafa dé. Amos Josaiana yafa dé. ");
INSERT INTO wos_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Josaia Jekonia déka nyama bandi wali deka yafa dé. Wun nukwa Israelna mama du Babilonmbu yae di Israel wali ware. Warendaka Babilonéna hambuk Israelna hambukré sarékéngwandéndéka di Babilonmbu yandé du Israelna du takwaré di hérae hura yi Babilonré. ");
INSERT INTO wos_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Israelna du takwa Babilonmbu rendan nukwa Jekonia Sealtielna yafa dé. Sealtiel Serubabelna yafa dé. ");
INSERT INTO wos_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Serubabel Abiutna yafa dé. Abiut Eliakimna yafa dé. Eliakim Asorna yafa dé. ");
INSERT INTO wos_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Asor Sadokna yafa dé. Sadok Akimna yafa dé. Akim Eliutna yafa dé. ");
INSERT INTO wos_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eliut Eleasarna yafa dé. Eleasar Matanéna yafa dé. Matan Jekopna yafa dé. ");
INSERT INTO wos_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Jekop Josepna yafa dé. Josep Mariana du dé. Maria Jisasré lé héra. Déka nani wa, “God wasékendén du Krais dé.” ");
INSERT INTO wos_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Abrahamré tale handékéné ye ye Devitré hukémbu handékéné angi dé tamba atéfék ye man yétiyéti (14) héméngwal di yi. Devitré tale handékéné ye ye Israel Babilonmbu rendan nukwaré handékéné angi dé tamba atéfék ye man yétiyéti (14) héméngwal di yi. Israel Babilonmbu rendan nukwaré tale handékéné ye ye God wasékendén du Kraisré hukémbu handékéné angi dé tamba atéfék ye man yétiyéti (14) héméngwal di yi. ");
INSERT INTO wos_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Maria Jisas Kraisré héralén hundi angi dé wa. Tale Mariana yafa ayiwa di waséke, lé Josepré humbwiléte. Wasékendaka hukémbu bér natafambu rehambambér. Bér rehafi yambéka dé Godna Hamwinya gaye dé léré hambuk hwendéka lé nyan té. ");
INSERT INTO wos_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Léré hukémbu hérandé du, déka xi Josep, dé yikafre male du dé. Lé nyan téléka dé wun jooka xékéta déka mawulimbu dé wa, “Lé nak du wali lé hwa. Némbuli léré yatakatawuni.” Wungi wataka dé wambula wa, “Wuni léré atéfék du takwana makambu takawut, lé rootalé. Wuni nakélak léré yatakatawuni.” ");
INSERT INTO wos_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Wungi wataka wun jooka sarékéta hwandéka dé janji nak ya. Yandéka Néma Duna ensel nak gaye dé déré wa, “Méni Josep, Devitna mandéka, mé xéké. Méni rookéméni, Mariaré héranjoka. Godna Hamwinya gaye léré hambuk hwendéka lé nyan té. Godna Hamwinya wungi hwendénka méni léré héranjoka yamba rookéméni. ");
INSERT INTO wos_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Lé dunya hératalé. Héralét, méni déka xi angi wataméni, Jisas. Déka xina mo angi dé: dé du takwaré Satanéna tambambu hérae hurundan haraki saraki sémbut hérekitandé.” Wungi dé Josepré wa. ");
INSERT INTO wos_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Wun nukwa profet wandén hundi mwi hundi dé ya. Hanja Néma Du God déka profet ané hundi wandéka dé Godna nyingambu angi hayi: ");
INSERT INTO wos_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“Du wali hwahafi yalé takwa hési nyan tétalé. Te héralét di déka xi Emanuel watandi.” Wungi hayindéka wun nukwa wun hundi mwi hundi dé ya. Wun xi Emanuel angi dé wa: God nani wali dé re. ");
INSERT INTO wos_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Josep janji hwae waréngéna raama dé Néma Duna ensel wandén maki dé ya. Ye dé Mariaré dé héra. ");
INSERT INTO wos_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Hérae dé, wun nukwambu Josep lé wali hwahambambér. Hukémbu nyan héraléka dé déka xi wa, Jisas. ");
INSERT INTO wos_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Herot Judana du takwa deka néma du rendén nukwa Maria lé Jisasré héra, Betlehemémbu. Betlehem Judiana héfambu dé té. Héraléka hukémbu di nyirmbu tékwa hunkwarika xékélakikwa du nukwa xalekwa hafwambu yae di Jerusalemré yi. Ye xaakwa di wa, “Nani nukwa xalekwa sakumbu reta nyirmbu tékwa huli hunkwariré nani xé. Xétaka nani xékélaki. Yikafre male nyan dé xaku. ");
INSERT INTO wos_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Dé Judana du takwa deka néma du retandé. Xékélakita hunkwariré xétaka déka nani ya, déka hwati se wandé danjoka. Dé yimbu dé re?” ");
INSERT INTO wos_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Wungi wandaka néma du Herot xékétaka waréngéna dé wa, “Wafewana wun nyan hukémbu wuna hafwa hératandé?” Wungi wataka wun jooka hélék dé ya. Hélék yandéka Jerusalemémbu rekwa séfélak du takwa di wun jooka saréké waréké. ");
INSERT INTO wos_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Herot hélék yata wandéka di prisna néma du atéfék, xékélelakikwa du atéfék wungi di ya. Yandaka dé diré wakwexéké, “God wasékendén du Krais yimbu xakutandé?” ");
INSERT INTO wos_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Wungi wandéka di déré wa, “Judiambu rekwa getéfa, Betlehemémbu xakutandé. Wun jooka hanja profet nak Godna nyingambu angi dé hayi: ");
INSERT INTO wos_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","Guni Betlehemémbu rekwa du takwa, mé xéké. Guna getéfa baka getéfa yingafwe. Guna getéfa némafwi dé. Hukémbu guna getéfana du nak néma du retandé. Reta dé wuna du takwa Israelka jémba hatitandé. Wungi dé hayi Godna nyingambu.” ");
INSERT INTO wos_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Judana néma du Herot wun hundi xékétaka dé wa, nukwa xalekwa sakumbu yandé du déka yandate. Wandéka xéka yandaka dé di wali nakélak hundi bulé. Buléta dé diré wakwexéké, “Yimba gan dé wun hunkwari nyirmbu tale xaku?” ");
INSERT INTO wos_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Wungi wakwexékéndéka déré wandaka dé wa, “Betlehemré sa guni yi. Ye jémba mé hwaké wun nyanka. Hwaka xétaka wambula yae guni wuniré wa. Wangut wuni akwi ye hwati se déka wandé datawuni.” Wungi wata dé dika yéna dé ya. ");
INSERT INTO wos_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Herot wungi wandéka xékétaka di yi. Ye di nukwa xalekwa sakumbu hanja xéndan hunkwariré di wambula xé. Wun hunkwari nyirmbu tale yindéka di déka hukémbu yi. Yindaka dé wun hunkwari nyan hwandéka ge anwarmbu dé té. ");
INSERT INTO wos_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Téndéka xéta yikafre mawuli yata di némafwi mawuli sawuli ya. ");
INSERT INTO wos_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Mawuli yata di geré wulaaye di xé wun nyan déka ayiwa Maria wali rembéka. Xétaka hwati se di wandé da déka. Yata di deka wurmbu hwandé jondu taré. Tara di yikafre jondu déka hwe. Gol motu, ya xérékéndaka yikafre yama xaakwa joo (frankinsense), yikafre yama xaakwa hulingu déka xi mir, wungi di déka hwe. ");
INSERT INTO wos_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Hwetaka re hwandaka dé janji hwandéka dé God diré wa, “Guni Herotka wambula yamba yikénguni.” Wungi wandéka waréngéna raama di nak yambumbu wambula yi deka getéfaré. ");
INSERT INTO wos_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Wunde du yindaka Josep janji hwandéka Néma Duna ensel nak gaye dé déré wa, “Herot wun nyanka hwakétandé. Hwaka xe déré xiyatandé. Méni sé raama wun nyan déka ayiwa wali hura yaange yi afaké hafwa Isipré. Yaange ye guni Isipmbu re. Hukémbu wuni guniré wawut, guni wambula yatanguni.” ");
INSERT INTO wos_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Wungi wandéka dé Josep bari waréngéna raama wun nyan déka ayiwa wali hura di gan yaange yi. ");
INSERT INTO wos_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Ye xaakwa di Isipmbu re. Re di Herot hiyandéka di deka getéfaré wambula yi. Wungi yindaka profet hayindén hundi mwi hundi dé ya. Wun profet Néma Du Godna hundi xékéta wun hundi Godna nyingambu angi dé hayi: Wuna nyan Isipmbu rendét wuni déré wawut dé Isip yatakataka wambula yatandé. ");
INSERT INTO wos_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Josep déka takwa nyan wali Isipré yaange yindaka dé Judana néma du Herot Jerusalemémbu reta nukwa xalekwa sakumbu yandé du déka wambula yandate dé haxéfatiké. Haxéfatika dé mawuli wita dé wa, “Wunika yéna di ya.” Wungi wataka dé déka mawulimbu wa, “Nukwa xalekwa sakumbu yandé du di wa, ‘Héki hwari yéték yindéka nani wun nyirmbu tékwa hunkwariré tale xé.’ Wungi di wa.” Wungi wandan hundika sarékéta dé déka xi warekwa duré wa, “Guni sa yi Betlehemré. Ye guni Betlehemémbu rekwa hafwaré akwi ye atéfék dunyaré mé guni xiyasanda. Héki hwari yéték yandé dunyaré, héki hwari natafa yandé dunyaré, hérandan wayikana dunyaré akwi, diré atéfék mé guni xiyasanda.” Wungi wandéka ye di wun nyangwalré atéfék di xiyasanda. ");
INSERT INTO wos_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Hanja profet nak, déka xi Jeremaia, dé Godna hundi Godna nyingambu dé hayi. Wun xiyasandandan nukwa déka hayindén hundi mwi hundi dé ya. Déka hayindén hundi angi dé: ");
INSERT INTO wos_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","Ramambu di séfélak du takwa di némafwimbu géra. Wun getéfambu saréfa naata di némafwimbu géra. Reselna mandéka deka nyangwal di bu hiya. Nawulak du takwa yae di deka biya yikafre hurunjoka yandaka deka hiyandé nyangwalka sarékéta di hélék ya. Dika némafwimbu saréfa naata di géra. ");
INSERT INTO wos_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Hukémbu Herot dé hiya. Hiyandéka Josep déka takwa, nyan wali Isipmbu di re. Wumbu re dé Josep janji hwandéka dé Néma Duna ensel gaye dé Josepré wa, ");
INSERT INTO wos_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","“Wun nyanré xiyanjoka mawuli yandé du di bu hiya. Némbuli méni sé raama wun nyan déka ayiwa wali hura Israelna héfaré wambula sa guni yi.” ");
INSERT INTO wos_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Wungi wandéka Josep waréngéna raama wun nyan déka ayiwa wali hura di Israelna héfaré wambula yi. ");
INSERT INTO wos_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Josep Israelna héfa xaakwa dé xéké, Arkelaus déka yafa Herotna hafwa hérae Judiambu rekwa du takwaka néma du rendéka. Xékétaka Judiambu renjoka dé roo. Roondéka nak janji yandéka God déré wandéka dé wun nyan déka ayiwa wali hura di Galilina héfaré yi. ");
INSERT INTO wos_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Ye di Nasaretmbu re. Josep, Maria, Jisas wun getéfambu rendaka profet hanja hayindan hundi mwi hundi dé ya. Jisaska di angi hayi: Déka watandi, dé Nasaretna du dé. ");
INSERT INTO wos_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Hukémbu nukwa nak guré husandakwa du Jon dé du rehafi Judiana hafwambu dé tale Godna hundi wa. Wun hafwaré yandé du takwaré dé angi wa, ");
INSERT INTO wos_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","“God néma du reta gunika hatitendéka nukwa andé yae. Hatitendékaka saréka guna haraki saraki sémbutka mé hu hwe.” Wungi dé Jon wa. ");
INSERT INTO wos_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Hanja profet nak déka xi Aisaia Jonka Godna nyingambu angi dé hayi: Du nak dé wa, du rehafi hafwambu. Wata dé angi wa, “Néma Duna yambu hurutanguni. Hurungut déka yambu jémba retandé.” Wungi dé wa. ");
INSERT INTO wos_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Jon hafu dé yikafre nukwa wur, yikafre hénooka sarékéhambandé. Dé kamelna séfina yuwimbu yatindan nukwa wur dé sanda. Sandataka dé bulmakau bali séfiré rundan yoo dé naki. Dé hawuluki dé sa. Nongérana gék dé jéma sa. ");
INSERT INTO wos_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Dé Godna hundi wandéka di Jerusalemémbu rekwa du takwa, Judiana héfambu rekwa du takwa, Jordan xéri tufwambu rekwa du takwa wungi di séfélak du takwa di déka yi. ");
INSERT INTO wos_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Ye di hurundan haraki saraki sémbutka hélék yata wandaka dé diré Godna ximbu guré husanda, Jordan xérimbu. ");
INSERT INTO wos_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Judana du deka néma du séfélak akwi di yi, Jon diré Godna ximbu guré husandandéte. Farisi, Sadyusi, wungi di yi. Yindaka dé Jon diré haraki hundi wata dé wa, “Guni haraki hambwena nyangwal guni. God guna sémbutka xéta mawuli wiya gunika haraki hurutandé. Héndé gunika wa Godna mawuli wika yaange yingute? ");
INSERT INTO wos_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Tale guni hurungun haraki saraki sémbut yatakataka guni yikafre sémbut male hurutanguni. Hurungut nawulak du takwa xéta watandi, ‘Di haraki saraki sémbut yatakataka némbuli yikafre sémbut di huru.’ Wungi watandi. ");
INSERT INTO wos_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Guni guna mawulimbu guni wa, ‘Nani Abrahamna mandéka nani. Nani jémba retame.’ Wungi wata yéna guni ye. Wungi wakénguni. God mawuli ye wandét ané motu du maki xaakwa ye di Abrahamna mandéka maki xakutandi. ");
INSERT INTO wos_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","“Sataku hundi nak watawuni. Mi nak sék xakéhafi yandét, du nak misange hérae wun miré xélitandé. Xéle yambu tutandé. Némbuli wun sataku hundika mé saréké. Némbuli God déka hundi xékéhafi yakwa du takwaré hurundan haraki saraki sémbut hasa hwetandé. Hasa hwendét di ya yanéta tékwa hafwaré yitandi. ");
INSERT INTO wos_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","“Guni guna haraki saraki mawuli yatakangut, wuni guniré Godna ximbu guré husandatawuni. Wuna hukémbu yate yakwa du wu néma du dé. Wuni baka du wuni. Déka hambuk wuna hambukré dé sarékéngwandé. Wuni baka du re yingi maki déka jémba yatawuni? Wuni baka du rewuka dé néma du rendéka wuni déka jondu hura yinjoka wuni hurufatiké. Wuna hukémbu yate yakwa du Godna Hamwinya gunika hwetandé. Guna haraki saraki jondu hérae yambu tutandé. ");
INSERT INTO wos_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Du wit sék hérae yikafre wit sék héranjoka di lékeki. Lékekitaka di yikafre wit sék gembu taka. Takataka di haraki wit sékna séfi di yaki. Nandaka maki wuna hukémbu yate yakwa du wungi yatandé. Dé déka du takwaré hérae hura ye déka getéfambu takatandé. Haraki saraki joo yandé du takwaré hérae xérékéta tékwa yambu yakitandé.” Wungi dé Jon wa. ");
INSERT INTO wos_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Wun nukwa Jisas Galilina héfa yatakataka dé Jordan xériré dé yi. Jon déré Godna ximbu guré husandandéte dé yi. ");
INSERT INTO wos_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Ye xakundéka Jon hélék yata dé wa, “Méni néma du méni re. Wuni baka du wuni re. Métaka méni wunika ya, wuni méniré guré husandawute? Méni wuniré guré husandamét, wu sékérékétandé.” ");
INSERT INTO wos_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Wungi wandéka dé Jisas wa, “Yinga. Méni wuniré guré husandataméni. Wungi hurumét God wandén maki hurutaani.” Wungi wandéka dé wa, “Yawundu.” ");
INSERT INTO wos_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Yawundu nae dé Jisasré guré husandandéka dé bari gumbu xale. Xalendéka nyir télaméndéka dé xé Godna Hamwinya nyamwe afwi maki déka gayandéka. ");
INSERT INTO wos_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Gayandéka dé Godna getéfambu hundi angi wa, “Ané wuna nyan dé. Déka wuni némafwimbu mawuli ya. Déka wuna mawuli yikafre dé ye.” ");
INSERT INTO wos_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Jon Jisasré guré husandandéka Godna Hamwinya Jisasré dé hérae hura yi, du rehafi hafwaré. Satan Jisasna mawuli hurukwexéndéte Godna Hamwinya déré wun hafwaré dé hérae hura yi. ");
INSERT INTO wos_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Hura yindéka Jisas wun hafwambu reta hénoo hulingu sahambandé. Dumi yétiyéti (40) gan nukwa baka dé re. Re hukémbu hénooka dé hiya. ");
INSERT INTO wos_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Hiyandéka Satan yae dé déré wa, “Méni angi méni wa, ‘Wuni Godna nyan wuni.’ Wungi wata némbuli wun jooka wuniré wakwetaméni. Méni wamét ané séfélak rekwa motu waleka bret xakundé. Wungi wamét bret xakundét wuni ménika xékélakitawuni.” ");
INSERT INTO wos_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Wungi wandéka dé wa, “Yingafwe. Wun jooka Godna nyingambu angi dé wa: Du takwa hénooka male sarékéta di jémba yamba rekéndi, yingafwe. Di Godna hundi xékéndat, deka mawuli jémba téndét, di jémba retandi. Wun hundi xékéta motu bret xakundéte wuni yamba wakéwuni.” ");
INSERT INTO wos_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Jisas wun hundi wandéka Satan dé déré hérae hura yi Jerusalemré. Hura wara dé déré tempelna hanjimbu taka. ");
INSERT INTO wos_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Takataka dé déré wa, “Méni angi méni wa, ‘Wuni Godna nyan wuni.’ Wungi wata méni mé wuréféka naande yi. Wun jooka Godna nyingambu angi dé wa: ‘God déka enselré wandét di ménika jémba hatitandi. Hatindat méni deka tambambu reta ména man motumbu yamba xatukwekéméni.’ Méni wun hundi xékéta wuréféka naande ye jémba remét, atéfék du takwa xéta xékélakitandi. Méni Godna nyan méni.” ");
INSERT INTO wos_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Wungi wandéka dé Jisas wa, “Yingafwe. Wun jooka Godna nyingambu angi dé wa: God dé ména Néma Du dé. Déré yamba hurukwexékéméni. Wun hundi xékéta wuni wuréféka naande yamba yikéwuni.” ");
INSERT INTO wos_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Jisas wun hundi wandéka Satan déré dé hérae hura wari némafwi némburé. Hura wara dé ané héfambu rekwa atéfék getéfa, wun getéfambu rekwa atéfék yikafre jondu akwi dé Jisasré wakwe. ");
INSERT INTO wos_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Wakwetaka dé wa, “Méni hwati se wunika wandé dae wuna ximbu harékémét wuni atéfék getéfa, wumbu rekwa jondu akwi ménika hwetawuni.” ");
INSERT INTO wos_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Wungi wandéka dé wa, “Méni, Satan, méni séléka. Godna nyingambu angi dé wa: Ména néma du dé God male dé. Méni déka wandé dae déré wataméni. Déka ximbu male harékétaméni. Wun hundi xékéta wuni ménika wandé yamba dakéwuni.” ");
INSERT INTO wos_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Wungi wandéka dé Satan déré yatakataka yi. Yindéka di ensel gaye Jisasré yikafre huru. ");
INSERT INTO wos_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Romna néma du dé guré husandakwa du Jon hérae dé déré séndé gembu taka. Takandéka hwandéka wun jooka Jisas hundi xékétaka dé Galilina héfaré yi. ");
INSERT INTO wos_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Ye déka getéfa Nasaret yatakataka dé Kaperneamré yi. Wun getéfa Galilina tukweseke tufwambu dé té. Wun getéfa Sebulun bér Naptalina hafwambu dé té. ");
INSERT INTO wos_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Jisas wun getéfaré ye Godna hundi wandéka hanja reta Godna profet déka xi Aisaia déka hundi mwi hundi dé ya. Aisaia hanja ané hundi Godna nyingambu dé hayi: ");
INSERT INTO wos_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","Sebulunéna hafwa Naptalina hafwa akwi bér némanguré yikwa yambumbu bér té. Jordan xéri angé sakumbu bér té. Galilina héfambu séfélak nak téfambu yandé du takwa di re. ");
INSERT INTO wos_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Halékingambu re di xé, némafwi ya hanyindéka. Hiyangambana héfambu rekwa du takwa di xé, xitélakéndéka nukwa hanyindéka. ");
INSERT INTO wos_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Jisas wun hafwaré ye xaakwa dé tale Godna hundi wa. Wata dé wa, “God néma du reta gunika hatitendéka nukwa andé yae. Yatendékaka sarékéta guni guna haraki saraki mawuli mé yataka.” Wungi dé wa. ");
INSERT INTO wos_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Jisas Galilina tukweseke tufwambu yita dé xé Saimon, déka nak xi Pita, déka bandi Andru wali bérka jémba yambéka. Bér atéfék nukwa yambén maki wun tukwesekembu bér mara yaki, xéri hamwika. ");
INSERT INTO wos_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Xétaka dé bérka wa, “Béni mé ya wuni wali. Yambét wuni béniré nak jémbaka wakwetawuni. Wakwewut béni xéri hamwi hurumbén maki du takwaré hératambéni. Hérambét di wuna hundi xékétandi.” ");
INSERT INTO wos_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Wungi wandéka bari mara yatakataka raama bér dé wali yi. ");
INSERT INTO wos_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Yalefu ye dé xé Sebedina nyan yétékré, Jems wali déka bandi Jon wali. Bérka yafa Sebedi wali di gunjambémbu reta mara yarafuta rendaka dé Jisas bérka wa, dé wali yimbéte. ");
INSERT INTO wos_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Wandéka bér bérka yafa gunjambémbu rendéka yatakataka bér Jisas wali yi. ");
INSERT INTO wos_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Jisas yitaka yatakata dé Galilimbu tékwa atéfék getéfaré yi. Ye xaakwa dé Godna hundi buléndaka gembu reta du takwaré dé wakwe, Godna jémbaka. Atéfék du takwaré dé hundi wa, God néma du reta déka du takwaka jémba hatitendékaka. Bar hiyaakwa du takwa, séfimali haraki yandé du takwaré akwi dé huréhaléké. ");
INSERT INTO wos_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Wungi yandéka di Siriana atéfék héfambu Jisaska hundi wa saafa yi. Wa saafa yindaka di wun hundi xékéta séfélak du takwaré déka hura yi. Bar hiyaakwa du takwa nyangwal, séfimali haraki yandé du takwa nyangwal, haraki hamwinya hura téndé du takwa nyangwal, sayiké hiyaakwa du takwa nyangwal, matamba lékémbandé du takwa nyangwal, wun du takwa nyangwalré di hura yi, Jisaska. Hura yindaka dé diré huréhaléké. ");
INSERT INTO wos_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Huréhalékéndéka séfélak séfélak du takwa di dé wali yi. Galilimbu yandé du takwa, Dekapolismbu yandé du takwa, Jerusalemémbu yandé du takwa, Judiambu yandé du takwa, Jordan xéri angé sakumbu yandé du takwa, wungi di dé wali yi. ");
INSERT INTO wos_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Séfélak du takwa yandaka Jisas xétaka dé némbu nakré wari. Wara rendéka déka du di déka ya. ");
INSERT INTO wos_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Yandaka dé dika Godna jémbaka dé wakwe. Wakweta dé angi wa. ");
INSERT INTO wos_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Du takwa nawulak deka hambukéka sarékéhafi yata Godna hambukéka sarékéta di déka jémba ya. Wunde du takwa Godna hémémbu rendaka dé néma du reta dika dé jémba hati. Hatindét yikafre mawuli yatandi. ");
INSERT INTO wos_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","“Du takwa nawulak di géra. Wunde du takwana mawuliré God yikafre hurutandé. Hurundét, yikafre mawuli yatandi. ");
INSERT INTO wos_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","“Du takwa nawulak deka ximbu harékéhafi yata nak du takwaré haraki hundi wahafi yata jémba di re. Wunde du takwaré God yikafre hurundét, di ané héfambu néma du takwa retandi. Reta yikafre mawuli yatandi. ");
INSERT INTO wos_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","“Du takwa nawulak Godka sarékéta yikafre mawuli yata yikafre jondu male yanjoka di némafwimbu mawuli ya. Hénooka hiyaakwa du hénoo sanjoka némafwimbu mawuli yandaka maki, di yikafre jondu male yanjoka di némafwimbu mawuli ya. Wunde du takwaré God jémba yandét deka mawuli jémba téndét di jémba male retandi. Reta yikafre mawuli yatandi. ");
INSERT INTO wos_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","“Du takwa nawulak di nawulak du takwaka saréfa nae di diré yikafre huru. Wunde du takwaka God saréfa nae yikafre hurutandé. Yikafre hurundét yikafre mawuli yatandi. ");
INSERT INTO wos_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","“Du takwa nawulak deka mawulimbu yikafre mawuli male dé té. Wunde du takwa Godré xéta di dé wali jémba retandi. Reta sarékéta yikafre mawuli yatandi. ");
INSERT INTO wos_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","“Du takwa nawulak nawulak du takwa waru warendaka di nyéndékmbu di té. Téndaka di warehambandi. Wun nyéndékmbu tékwa du takwaka God watandé, ‘Di wuna nyangwal di.’ Wungi wandét sarékéta wun nyéndékmbu tékwa du takwa yikafre mawuli yatandi. ");
INSERT INTO wos_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","“Du takwa nawulak Godna jémba yandaka nawulak du takwa hélék yata diré di haraki huru. Haraki hurundaka di Godna jémba yakwa du takwa Godna hémémbu rendaka God néma du reta dika dé jémba hati. Hatindét yikafre mawuli yatandi. ");
INSERT INTO wos_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","“Mé xéké. Guni wunika yangut, du nawulak wunika hélék yata guniré haraki hundi wata haraki saraki sémbut guniré huruta gunika yénataka hundi wandat, guni yikafre mawuli yatanguni. ");
INSERT INTO wos_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Hanja di séfélak profetré wungi di haraki huru. Diré wungi haraki hurundanka sarékéta di guniré wungi haraki hurundat, guni yikafre mawuli yatanguni. Hukémbu God guniré némafwimbu yikafre hurundét, guni dé wali jémba male retanguni. Jémba retengukaka sarékéta guni yikafre mawuli yata mawuli sawuli yata wungi re wungi re retanguni.” Wungi dé Jisas wa. ");
INSERT INTO wos_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Wun hundi wataka dé Jisas angi wa: “Ané sataku hundi mé xéké. Takwa di hunyi taka, hénoo résék yandéte. Hunyi résék yahafi yandét, yingi maki yandat, résék wambula yatandé? Yingafwe. Résék wambula yamba yakéndé. Résék yahafi yandét, hénoombu yamba takakéndi. Di wun hunyi baka yakitaka di manmbu xakélakitandi. Némbuli wun hundika mé saréké. Guni, wuna du, guni hénoombu takandaka hunyi maki guni. Guni nawulak du takwaré yikafre hurungut, di haraki saraki joo wambula yamba hurukéndi. Guni nawulak du takwaré yikafre huruhafi yangut, résék yahafi yakwa hunyi baka yakitaka manmbu xakélakindakangala, God guniré yakitandé. ");
INSERT INTO wos_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","“Guni, wuna du, guni yanékwa hama ya maki guni re. Renguka nawulak du takwa guniré di xé. Guni némbumbu tékwa getéfa maki guni re. Renguka nawulak du takwa guniré di jémba xé, némbumbu tékwa getéfaré jémba xéndaka maki. ");
INSERT INTO wos_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","“Ané sataku hundi mé xéké. Du hama ya xéréka hura yae aki ekombu di samétaka, o yingafwe? Yingafwe. Di jambé takumbu di taka. Takandaka wumbu rekwa atéfék du takwa di jémba xé. ");
INSERT INTO wos_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Némbuli wun hundika mé saréké. Guni wun hama ya maki guni re. Guni Godka yikafre jémba yatanguni. Wun jémba fakukénguni. Du takwana makambu yatanguni. Yangut di jémba xétandi. Xéta anwarmbu rekwa du guna yafa Godna ximbu harékétandi. ");
INSERT INTO wos_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","“Guni angi wakénguni, ‘Moses wandén hambuk hundika hu hwenjoka Jisas dé ya. Hanja rendé Godna profet deka hundika hu hwenjoka Jisas dé ya.’ Wungi wakénguni. Moses wandén hambuk hundi atéfék Godna profetna hundi atéfék akwi jémba xékéta wandan maki yanjoka wuni ya. Guni wun hundika jémba xékélakingute wuni ya. ");
INSERT INTO wos_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Ané hundi mé xéké. Nyir héfa hényiwata téndét, Moses wandén atéfék hambuk hundi reséketandé. Rendét guni wun hundi xékéta wandéka maki yatanguni. Hukémbu nyir héfa hényitandé. Hényindét, Moses wandén hambuk hundi akwi hényitandé. Mwi hundi wuni guniré we. ");
INSERT INTO wos_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Du nawulak Moses wandén hambuk hundi nakéka angi wandat, ‘Wun hambuk hundi wun yikama hundi male. Nani wun hundi yatakambet, wu yikafre dé.’ Wungi wandat, God néma du reta dika watandé, ‘Di baka du di. Di wuna tambambu baka di re. Deka ximbu yamba harékékéwuni.’ Wungi wandét, di nawulak du wun hambuk hundi xékéta wakwa maki yata angi wandat, ‘Wun hambuk hundi atéfék jémba xékétame. Nak hundi yamba yatakakéme.’ Wungi wandat, God néma du reta dika watandé, ‘Di néma du di. Di wuna tambambu jémba di re. Deka ximbu harékétawuni.’ Wungi watandé. ");
INSERT INTO wos_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Guni Moses wandén hambuk hundika jémba xékélakingute, wuni guniré we. Xékélelakikwa du, Farisi akwi, di Moses wandén hambuk hundi atéfék jémba xékéta wakwa maki yanjoka di hambuk jémba ya. Yandaka nawulak du diré xéta di wa, ‘Di yikafre sémbut hurukwa du di re.’ Wungi wandaka God deka mawuli xékélakita dé dika wa, ‘Wu yingafwe.’ Wungi wandéka guniré wuni we. Guni yikafre mawuli yata yikafre joo yatanguni. Yangut guna yikafre sémbut Farisina sémbut xékélelakikwa duna sémbutré akwi sarékéngwandéndét, guni Godna hémémbu retanguni. Guna yikafre sémbut deka sémbutré sarékéngwandéhafi yandét, guni Godna hémémbu yamba rekénguni.” Wungi dé Jisas wa. ");
INSERT INTO wos_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","Wun hundi wataka dé diré angi wa: “Hanja rendé du ané hundi wandaka guni wundé xékéngu. Angi di wa, ‘Guni du takwaré xiyakénguni. Guni diré xiyangut, di guniré kot xékékwa néma duka hura yindat, dé wun haraki saraki jooka guniré hasa hwetandé.’ ");
INSERT INTO wos_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Wungi wandaka némbuli wuni nak hundi guniré we. Mé xéké. Du nawulak nak duré rékambambu wandat, God wun haraki saraki jooka diré hasa hwetandé. Du nawulak nak duré haraki hundi wata angi wandat, ‘Méni xékélakihafi du méni.’ Wungi wandat, God kot xékékwa néma du reta wun haraki saraki jooka wungi wakwa duré hambukmbu hasa hwetandé. Du nawulak nak duré hambukmbu haraki hundi wata angi wandat, ‘Méni wangété du méni.’ Wungi wandat, God wandét wungi wakwa du ya yanékwa hafwaré yitandi. ");
INSERT INTO wos_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","24","Wun jooka sarékéta guni nak nak angi hurutanguni. Guni Godka joo hwenjoka yata, déka joo hwendaka jambé tékwambu téta, nak du takwaré hurungun haraki saraki jooka sarékéngut, tale guni Godka hwetenguka joo jambé tékwa sakumbu takataka, wun du takwaka bari yitanguni. Ye guni di wali hundi buléta guni di wali natafa mawuli hérae jémba retanguni. Re hukémbu wambula yae takangun joo Godka hwetanguni. ");
INSERT INTO wos_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","“Du nawulak guniré kotka harindat, guni di wali yambumbu yita di wali hundi buléta di wali hundi gitanguni. Guni natafa mawuli hératanguni. Guni di wali wun hundi gihafi yangut, wafewana di guniré kot xékékwa néma duka hura yindat, dé wandét di guniré séndé gembu takatandi? Takandat guni séndé gembu hwatanguni. ");
INSERT INTO wos_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Kot xékékwa néma du wandén atéfék yéwa guniré haraki hundi wandé duka hwengut, wun nukwa male séndé ge yatakataka gwande jémba yitanguni. Mwi hundi wuni guniré we. ");
INSERT INTO wos_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","“Hanja rendé du ané hundi wandaka guni wundé xékéngu. Angi di wa, ‘Guni nak duna takwa wali haraki saraki sémbut yamba hurukénguni.’ ");
INSERT INTO wos_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Wungi wandaka némbuli wuni guniré angi we. Du nak nak duna takwaré xéta léré héranjoka mawuli raméndét, déka mawulimbu lé wali dé hwa. Mawuli raméndéka déka mawuli haraki dé té. Dé wungi léré xéta léré héranjoka mawuli raméndéka dé haraki saraki sémbut huru. ");
INSERT INTO wos_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Guni guna yika tamba sakumbu tékwa dama nak duna takwaré xéta, lé wali haraki saraki sémbut hurunjoka sarékéta mawuli raméndét, wun dama mé hérae yaki. Guna natafa dama male téndét, wun haraki saraki sémbut huruhafi yata hukémbu Godna getéfaré yingut, wu yikafre dé. Guna dama yéték téndét guni wun haraki saraki sémbut hurungut God wandét, guni haraki hafwaré yingut, wu haraki dé. ");
INSERT INTO wos_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Guna yika tamba haraki saraki sémbut hurundét, guni wun tamba mé xatéka yaki. Guna natafa tamba male téndét wun haraki saraki sémbut huruhafi yata hukémbu Godna getéfaré yingut, wu yikafre dé. Guna tamba yéték téndét guni wun haraki saraki sémbut hurutaka hukémbu guni haraki hafwaré yingut, wu haraki dé. ");
INSERT INTO wos_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","“Hanja rendé du ané hundi akwi wandaka guni wundé xékéngu. Angi di wa, ‘Du nak déka takwa déré yatakataka yiléte mawuli yata, dé wun jooka nyinga hayitandé. Hayitaka léka hwendét, lé wun nyinga hura yitalé.’ ");
INSERT INTO wos_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Wungi wandaka némbuli wuni guniré angi we. Takwa hési nak du wali haraki saraki sémbut huruhafi yalét, léka du lé déré yatakataka yiléte wandét, wu haraki dé. Lé déré yatakataka yiléte wandét, lé ye nak du wali relét lé wun du wali haraki saraki sémbut bér huru. Tale relén du haraki saraki sémbut hurundéka bér akwi haraki saraki sémbut bér huru.” Wungi dé Jisas diré wa. ");
INSERT INTO wos_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","Wun hundi wataka dé Jisas angi wa: “Hanja rendé du ané hundi akwi wandaka guni wundé xékéngu. Angi di wa, ‘Guni jémba nak yanjoka yawundu nae hundi giya, guni wun jémba yatanguni. Wun jémba yamba yatakakénguni.’ ");
INSERT INTO wos_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Wungi wandaka némbuli wuni guniré angi we. Guni hundi yamba gikénguni. Guni Godna getéfana ximbu hundi gikénguni, wun God rendéka hafwa dé. ");
INSERT INTO wos_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","God héfambu déka man xakindéka héfana ximbu akwi hundi gikénguni. Jerusalem nana néma Du Godna hafwa dé, Guni Jerusalemna ximbu akwi hundi gikénguni. ");
INSERT INTO wos_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Guni géli némbé wama yandéte wama némbé géli yandéte yanjoka hurufatikéta, guni guna makambu akwi hundi gikénguni. ");
INSERT INTO wos_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Di guniré jémbaka wakwexékéndat, guni yawundu nae guni angi watanguni, ‘Xéxé, wun jémba yatame.’ Wungi yanjoka hélék yata guni angi watanguni, ‘Yingafwe. Wun jémba yamba yakéme.’ Wungi watanguni. Nak hundi wakénguni. Guna hundi ginjoka nawulak jonduna ximbu wakénguni. Guna hundi ginjoka nawulak jonduna ximbu wata guni Satanéna hundi xékéta wakwa maki yatanguni. ");
INSERT INTO wos_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","“Hanja rendé du ané hundi wandaka guni wundé xékéngu. Angi di wa, ‘Du yéték wareta du nak duna dama yafénekéndét, dé hasa déka dama yafénekétandé. Du yéték wareta du nak duna némbi nak tangurundét, dé hasa déka némbi nak tangurutandé.’ ");
INSERT INTO wos_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Wungi wandaka némbuli wuni guniré angi we. Du nawulak guniré haraki saraki sémbut hurundat, guni diré haraki sémbut hasa yamba hwekénguni. Du nawulak guniré guna yika tamba saku hufwimbu xiyandat, guni hasa xiyahafi yata waleka baka tétanguni, di guna aki tamba saku hufwimbu xiyandate. ");
INSERT INTO wos_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Du nawulak guniré kot xékékwa néma duka harindat, dé di guna sanda wur hérandate yawundu nandét, guni guna séményi nukwa wur akwi dika hwetanguni. ");
INSERT INTO wos_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Du nawulak guni di wali yita deka jondu nawulak yambumbu hura yingute wandat, guni di wali yita deka jondu tambéngwa yambumbu hura yitanguni. ");
INSERT INTO wos_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Du nawulak guniré jooka wakwexékéndat, guni wun joo dika hwetanguni. Du nawulak guna jooka mawuli yata gunika wun joo hukémbu hasa hwenjoka wandat, guni wun joo dika hwetanguni. ");
INSERT INTO wos_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","“Hanja rendé du ané hundi wandaka guni wundé xékéngu. Angi di wa, ‘Guni guna nyémayikaka némafwimbu mawuli yata guna mamaka hélék yatanguni.’ ");
INSERT INTO wos_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Wungi wandaka némbuli wuni guniré angi we. Guni guna mamaka némafwimbu mawuli yatanguni. Du nawulak guniré haraki saraki sémbut hurundat, guni Godré wakwexékétanguni, dé diré yikafre hurundéte. ");
INSERT INTO wos_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Guni wungi yata guni anwarmbu rekwa du guna yafa God wali natafa mawuli hératanguni. Héraata guni déka nyangwal retanguni. God natafa jémba dé ya, atéfék du takwaka. God wandéka dé nukwa xé. God wandéka dé wali giya. Nukwa xéndéka wali giyandéka hénoo jémba dé xale, yikafre sémbut hurukwa du takwana héfambu akwi, haraki saraki sémbut hurukwa du takwana héfambu akwi. ");
INSERT INTO wos_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Guni gunika mawuli yakwa du takwaka male guni némafwimbu mawuli yangut, God guniré méta joo hasa hwetandé? Romna yéwa héraakwa du akwi di dika mawuli yakwa du takwaka male di mawuli ye. Guni atéfék du takwaka némafwimbu mawuli yatanguni. ");
INSERT INTO wos_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Godna hundi xékéhafi yakwa du takwa di deka du takwaka male yikafre mawuli yata di wali di hundi bulé. Guni di hurundaka maki, guna du takwaka male yikafre mawuli yata, di wali hundi buléta guni jémba yamba rekénguni. Atéfék du takwaka yikafre mawuli yata, di wali hundi bulétanguni. ");
INSERT INTO wos_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Anwarmbu rekwa du guna yafa dé yikafre sémbut male hurukwa du dé re. Guni dé rendéka maki yikafre sémbut male hurukwa du retanguni.” Wungi dé Jisas wa, déka duré. ");
INSERT INTO wos_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Jisas hundi nawulak akwi dé angi wa: “Guni Godka yikafre jémba yata déka male sarékétanguni. Guni Godka yikafre jémba yanguka nawulak du takwa di xétaka guna ximbu harékéndate mawuli yata deka makambu wun jémba yata, guni gunika guni saréké. Wungi sarékéta deka makambu yangut, anwarmbu rekwa du guna yafa hukémbu guna ximbu yamba harékékéndé. ");
INSERT INTO wos_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","3","“Yéna yakwa du nawulak deka ximbu harékéta di Godna hundi buléndaka geré wulaaye téta yambumbu akwi téta di jambangwe du takwaka jondu hwe. Séfélak du takwa xéta wun yéna yakwa duna ximbu harékéndate, di yéna yakwa du jambangwe du takwaka jondu di hwe. Wungi hwendaka séfélak du takwa xéta wun yéna yakwa duna ximbu di haréké. Séfélak du takwa deka ximbu némbuli harékéndaka hukémbu God wun yéna yakwa duna ximbu yamba harékékéndé. Mwi hundi wuni guniré we. Guni yéna yakwa du hwendaka maki hwekénguni. Guni jambangwe du takwaka jondu hwenjoka yita nak du takwaré wun jooka wakénguni. Nakélak hwetanguni. Wungi hwengut nak du takwa wun jooka xéhafi yandat guni wali rekwa du takwa akwi wun jooka yamba xékéndi. ");
INSERT INTO wos_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Guni wungi nakélak hwengut, anwarmbu rekwa du guna yafa xétandé. Xétaka hukémbu dé hwengun yikafre jondu gunika hasa hwetandé. ");
INSERT INTO wos_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","“Yéna yakwa du Godka wanjoka, di Godna hundi buléndaka geré wulaaye téta yambumbu akwi téta di Godka wa. Séfélak du takwa diré xéta deka xi harékéndate di wumbu téta Godka wa. Wungi wandaka séfélak du takwa deka xi di haréké. Yéna yakwa du wun du takwa yikafre joo di hasa wundé héranda. Hukémbu God yandan yikafre joo hasa yamba hwekéndé. Mwi hundi wuni guniré we. Guni yéna yakwa du Godka wandaka maki wakénguni. ");
INSERT INTO wos_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Guni God wali hundi bulénjoka guni nak nak guna geré wulaaye ge yambu téfitaka hafu reta dé wali hundi bulétanguni. Buléngut guna yafa God guni wungi reta buléngut, xéta guna hundi xékétandé. Déré xéhambanguni. Dé guna hundi xékéta hukémbu dé wangun yikafre joo hasa hwetandé.” ");
INSERT INTO wos_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","“Godka xékélakihafi yakwa du takwa di wa, ‘Nani séfélak hundi buléta nana nak nak godka wambet, di xékétandi.’ Wungi wata séfélak hundi di baka buléta wa. Guni séfélak hundi buléndakangala bulékénguni, God wali. ");
INSERT INTO wos_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Guni déré wakwexékéhafi yangun nukwa guna yafa God bu xékélakindé, wangun jooka. Xékélakindénka sarékéta guni dé wali hundi buléta guni séfélak hundi bulékénguni. ");
INSERT INTO wos_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Guni déré angi watanguni: Nana yafa, méni ména getéfambu méni re. Nani ména ximbu harékénjoka nani mawuli ye. ");
INSERT INTO wos_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Méni néma du reta atéfék du takwaka jémba hatiméte nani mawuli ye. Ména getéfambu rekwa du ména hundi jémba xékéndaka maki, nani ané héfambu rekwa du takwa akwi ména hundi jémba xékénjoka nani mawuli ye. ");
INSERT INTO wos_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Ané nukwa nanika hénoo hweméte me we. ");
INSERT INTO wos_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Du takwa naniré haraki hurundaka nani wun jonduka wambula sarékéhambame. Sarékéhafi yambet, méni hurumben haraki sémbut yakwanyi méni wun jonduka wambula sarékéhafi yaméte mawuli me ye. ");
INSERT INTO wos_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Méni nanika hurukwexé takamét, yakéndé. Naniré haraki hurukwa joo, mé héreki. Méni nani atéfék du takwaka jémba hatita hambuk ye néma du reséketaméni wungi re wungi re. Wungi nani ménika we. ");
INSERT INTO wos_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","“Guni wun hundika mé saréké. Guni nawulak du takwa guniré yandan haraki saraki jooka sarékéhafi yangut, anwarmbu rekwa du guna yafa God yangun haraki jondu yakwanyi wun jonduka wambula yamba sarékékéndé. ");
INSERT INTO wos_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Guni nak du takwa guniré yandan haraki saraki jonduka sarékéta diré hasa hwenangut, guna yafa God yangun haraki saraki jonduka sarékéta wun haraki saraki jondu yakwanyihafi yata guniré hasa hwetandé.” Wungi dé Jisas wa. ");
INSERT INTO wos_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","Wun hundi wataka dé diré wambula wa: “Yéna yakwa du God wali hundi bulénjoka di nak nukwa nak nukwa hénooka yakér. Yakérta nak du takwa hénooka yakérndanka xékélakindate di deka saawimbu wama héfa ya. Yandaka deka saawi wama male dé xaku. Xakundéka nawulak du takwa xéta di wa, ‘Wun du Godka sarékéta di hénooka hiyae. Wu yikafre sémbut hurukwa du di.’ Wungi wata deka ximbu di haréké. Yéna yakwa du wun du takwa yikafre joo di hasa wundé héranda. Hukémbu God yandan yikafre joo hasa yamba hwekéndé. Mwi hundi wuni guniré we. ");
INSERT INTO wos_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Guni di yandakangala yakénguni. Guni God wali hundi bulénjoka mawuli yata, hénooka yakérta guna saawi yakwanyitanguni. Ye gwaaré hulingu blekétaka némbé séférétanguni, atéfék nukwa yanguka maki. ");
INSERT INTO wos_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","Guni wungi yangut, nawulak du takwa guniré xéta yamba xékélakikéndi, guni God wali hundi bulénjoka mawuli yata hénooka yakérngunka. Di wun jooka xékélakihafi yandate guni guna saawi yakwanyitanguni. Wungi yangut, guna yafa God male wun jooka xékélakitandé. Déré nani xéhambame. Guni hénooka yakérta dé wali hundi buléta hafu rengut, dé xéta hukémbu yangun yikafre joo guniré hasa hwetandé.” ");
INSERT INTO wos_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","21","“Guni atéfék nukwa séfélak jondu héranjoka guni saréké waréké. Sarékéta wun jonduka male guni mawuli ye. Mé xéké. Guni wungi yata guni ané héfana séfélak jondu héranjoka sarékékénguni. Ané héfana jondu néma joo yingafwe. Bwiyaak wun jonduré di héréké. Sufu wun jonduré dé we. Sélé héraakwa du nak duna ge héréka wulaaye wun jondu di sélé héra. Wun jondu rehafi yatendékaka sarékéta guni Godna getéfambu jémba retengukaka sarékétanguni. Sarékéta guni yikafre sémbut male hurutanguni. Godna getéfambu reta hurutenguka jondu wu némafwi joo dé. Wun jondu ané héfana jondu maki yingafwe. Godna getéfambu reta hurutenguka jondu wungi retandé. Bwiyaak wun jonduré yamba hérékékéndi. Sufu yamba wekéndé. Sélé héraakwa du yamba hérakéndi. Ané héfambu jondu héraakwa du takwa di ané héfana jonduka male di némafwimbu mawuli ye. Godna getéfambu renjoka sarékékwa du takwa di dé wali jémba renjoka di némafwimbu mawuli ye. ");
INSERT INTO wos_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","“Guna dama guna séfina ya maki dé. Guni yikafre jonduka male xéngut, guna dama larétandé. Laréndét, guna séfi akwi larétandé. ");
INSERT INTO wos_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Guni haraki saraki jonduka male xéngut, guna séfi halékingambu retandé. Guna séfina ya halékingambu rekwa jonduka male xéndét, guna séfi gan hunyitandé. ");
INSERT INTO wos_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","“Du nak néma du yétékéka jémba yanjoka dé hurufatiké. Wungi jémba yandét, dé nak néma duka yikafre mawuli yata nakéka hélék yatandé. Guni wun du maki guni re. Guni néma du Godka jémba yata déka male sarékéta guni déka yikafre mawuli yatanguni. Yata guni yéwa héranjoka sarékékénguni. Guni yéwa héranjoka male sarékéta guni néma du Godka hélék yatanguni.” Wungi dé Jisas wa. ");
INSERT INTO wos_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","Wun hundi wataka dé Jisas diré wambula wa: “Natafa néma duna jémba yatengukaka sarékéta wuni guniré we. Guni roota hénoo, hulingu, nukwa wurka akwi saréké warékékénguni. Hénoo, hulingu, nukwa wur wu baka joo di. Néma joo yingafwe. Guni wun jooka saréké warékékénguni. God wandéka guni re. God guna séfi guna mawuli guna hamwinya xéndéka guni re. Wu néma joo dé. ");
INSERT INTO wos_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Guni afwiré mé xé. Di hénoo sehafindi. Di hénoo héraata handi gembu takahafindi. Yandaka anwarmbu rekwa du guna yafa dé dika hénoo hwe. Afwi wu yikama joo di. Guni du takwa guni némafwi joo guni. God wungi afwika hénoo hwendét xéta guni xékélakitanguni. Gunika akwi hénoo hwetandé. ");
INSERT INTO wos_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Mé xéké. Guna du nak séfélak héki hwari renjoka saréké warékéta, dé wata séfélak héki hwari renjoka hambuk yatandé, o yingafwe? Wu yingafwe. Dé hafu wata séfélak héki hwari renjoka akwi hurufatikétandé. ");
INSERT INTO wos_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","“Métaka guni nukwa wurka guni saréké waréké? Wungi sarékékénguni. Guni maweka mé saréké. Nani wun mawe sehambame. Di baka di xale. Di jémba yahambandi. Di nukwa wur hundafanéhafindi. Hundafanéhafi yandaka God dé dika jémba hati. ");
INSERT INTO wos_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Dika dé yikafre waka dé hwe. Hanja xérénjuwi mama néma du nak déka xi Solomon yikafre nukwa wur dé sanda. Sandata wun mawe maki sandandaka yikafre joo sandahambandé. Mawe sandandaka yikafre joo Solomon sandandén yikafre jooré dé sarékéngwandé. ");
INSERT INTO wos_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","God wun maweka dé jémba hati. Wun mawe nawulak male tétandi. Némbuli te séri réka yatandi. Réka yandat du takwa wun mawe féla yambu tutandi. Wun mawe wun yikama joo di. Guni du takwa guni némafwi joo guni. Guni Godka jémba sarékéhambanguni. Sarékéhafi yata roota guni wa, ‘Nanika jémba hatitandé, o yingafwe?’ Wungi wanguka némbuli wuni guniré we. God mawe wungi sandandét xéta guni xékélakitanguni. Gunika nukwa wur hwetandé. ");
INSERT INTO wos_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Wungi xékélakita guni roohafi yata angi wakénguni, ‘Méta joo satame? Méta hulingu satame? Méta nukwa wur sandatame?’ ");
INSERT INTO wos_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Guni wun joo héranjoka hurufatikénguka anwarmbu rekwa du guna yafa xékélakindéka wungi yamba wakénguni. Godna hundi xékéhafi yakwa du takwa di wun jooka di saréké waréké. Guni di sarékéndaka maki sarékékénguni. ");
INSERT INTO wos_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Sarékéhafi yata guni Godna hémémbu reta déka hundi jémba xékéta wandéka maki yata déka jémba yanjoka némafwimbu mawuli yatanguni. Wungi yangut, dé gunika wun jondu hwetandé. ");
INSERT INTO wos_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Hwetendékaka sarékéta guni sérina jonduka sarékékénguni. Sérina jonduka saréké warékékénguni. Némbulina jonduka male sarékétanguni.” Wungi dé Jisas diré wa. ");
INSERT INTO wos_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","Wun hundi wataka dé Jisas wambula wa: “Nak du takwa yandan jooka sarékéta guni bari angi wakénguni, ‘Wun du takwa wu haraki saraki sémbut hurukwa du takwa di.’ Wungi wakénguni. Guni wungi hundi wangut, God hurungun sémbut xéta guniré watandé, ‘Guni haraki saraki sémbut hurukwa du takwa guni.’ ");
INSERT INTO wos_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Wungi watendékaka sarékéta, guni dika bari angi wakénguni, ‘Wu haraki saraki mawuli xékékwa du takwa di.’ Wungi wakénguni. God nak du takwaka wangun hundi xéka, guniré hasa watandé. ");
INSERT INTO wos_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Nak du takwa yandan haraki joo, wu damambu hwakwa mikulanyi maki dé. Yangun haraki joo wu damambu hwakwa némafwi bangi maki dé. Métaka guni nak du takwana damambu hwakwa mikulanyi xe guni guna damambu hwakwa némafwi bangi xéhambanguni? Guni wungi xe guni nak du takwa yandan yikama haraki jooka wata guni yangun néma haraki jooka sarékéhambanguni. ");
INSERT INTO wos_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Guni némafwi haraki saraki sémbut hurutaka métaka guni yikama haraki sémbut hurundé du takwaka guni angi wa? ‘Guni haraki saraki joo guni huru. Guni jémba rengute wuni guniré yikafre hurutawuni.’ ");
INSERT INTO wos_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Wungi wakénguni. Guni wungi wata guni yéna yakwa du takwa guni re. Tale guni némafwi haraki hurungun jooka yatakatanguni. Yatakataka guni yikama haraki joo yandé du takwaré yikafre hali hurungu. ");
INSERT INTO wos_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","“Guni Godna hundika hélék yakwa du takwaré Godna hundi wakénguni. Guni diré Godna hundi wangut, di duré tikwa wasa du takwaré haraki hurundaka maki guniré haraki hurutandi. Du takwa nawulak di Godna hundika hu hwe. Diré akwi Godna hundi wakénguni. Du waréndaka yéwasé balika hwehafindi. Wungi hwendat, bali wangété reta wun yéwasémbu baka xakélaki sakélakitandi. Godna hundi wu yikafre hundi dé. Guni waréndaka yéwasé balika hwehafi yanguka maki, Godka hu hwekwa du takwaré Godna hundi wakénguni. Guni diré déka hundi wangut, wafewana di bali xakélaki sakélakindaka maki guniré haraki hurutandi? ");
INSERT INTO wos_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","“Guni Godré wakwexékéngut, dé gunika hwetandé. Ané sataku hundi mé xéké. Guni hwaka hwaka xétanguni. Guni gena yambumbu xiyangut, gena yambu nafwitandé. ");
INSERT INTO wos_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Du takwa Godré wakwexékéndat, dé dika hwetandé. Du takwa hwaka hwaka xétandi. Du takwa gena yambumbu xiyandat, gena yambu nafwitandé. Guni wun sataku hundi xékétaka guni Godré wakwexékétanguni. Wakwexékéngut, dé guna hundi xékétandé.” ");
INSERT INTO wos_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","“Ané hundi akwi mé xéké. Guni yafa, guna nyangwal hénoo hwengute wandat, guni motu hwetanguni, o yingafwe? Yingafwe. Guni dika hénoo hwetanguni. ");
INSERT INTO wos_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Di xéri hamwi hwengute wandat, guni hambwe hérae hwetanguni, o yingi maki dé? Wu yingafwe. Guni dika xéri hamwi hwetanguni. ");
INSERT INTO wos_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Némbuli wun hundika mé saréké. Guni haraki saraki mawuli xékékwa du reta guni guna nyangwalka yikafre joo guni hwe. Anwarmbu rekwa du guna yafa yikafre mawuli yakwa du reta guniré sarékéngwanda dé némafwi yikafre joo hwetandé, déré wakwexékéndé du takwaka. ");
INSERT INTO wos_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","“Guni nak du takwa guniré yikafre hurundate mawuli yanguka maki, guni diré yikafre hurutanguni. Moses wandén hambuk hundi Godna profetna hundi akwi guni wungi yangute dé wa. ");
INSERT INTO wos_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","14","“Haraki hafwaré yikwa yambu wu némafwi yambu dé. Wun yambumbu néma ge fété dé té. Du takwa wun néma fétémbu wulayinjoka we yamba hurukéndi. Séfélak du takwa wun néma fétémbu wulaaye di wun yambumbu ye di fakutandi. God wali yamba rekéndi. Guni wun yambumbu yikénguni. Godna getéfaré yikwa yambu wu yikama yambu dé. Wun yambumbu yikama ge fété dé té. Nawulak du takwa male wun yikama fétémbu wulaaye wun yikama yambumbu di yi. Di God wali jémba retandi, wungi re wungi re. Guni wun yikama yambumbu yitanguni.” Wungi dé Jisas wa. ");
INSERT INTO wos_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","Wun hundi wataka dé angi wa: “Guni xékélaki natanguni. Du nawulak gunika yae yéna yata angi watandi, ‘Nani Godna ximbu nani hundi we.’ Wungi wata nak hundi wata guna mawuli haraki hurundat, nawulak du takwa wangété reta dika watandi, ‘Wunde yikafre sémbut hurukwa du di. Sipsip bali jémba rekwa maki di jémba re. Deka hundi xékétame.’ Wungi wata di xékélakihambandi. Haraki wasa haraki mawuli yandaka maki di yéna yakwa du haraki saraki mawuli di xéké. Xékéndaka wungi xékélakihambandi. ");
INSERT INTO wos_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Guni deka jémbaré jémba xétanguni. Xétaka deka mawulika xékélakitanguni. Héfambu tékwa jooka mé saréké. Rami yoombu wana sék xakéhafindé. Hamungwa mimbu mamu sék xakéhafindé. ");
INSERT INTO wos_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Yikafre mimbu yikafre sék dé xaké. Haraki mimbu haraki sék dé xaké. ");
INSERT INTO wos_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Yikafre mimbu haraki sék xakéhafindé. Haraki mimbu yikafre sék xakéhafindé. ");
INSERT INTO wos_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Yikafre sék xakéhafi yakwa mi xéle di yambu tu. ");
INSERT INTO wos_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Guni wun jooka sarékéta mi sékré xéta xékélakitanguni. Nak mi yikafre mi dé. Nak mi haraki mi dé. Némbuli wun duka mé saréké. Guni deka haraki sémbutka xe xékélakitanguni. Wun haraki saraki sémbut huruta yéna yakwa du di.” ");
INSERT INTO wos_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","“Séfélak du takwa yéna yata di wunika watandi, ‘Méni nana Néma Du méni.’ Wungi wata yénataka hundi wata di anwarmbu rekwa du wuna yafa Godna hundi xékéhambandi. Wun du takwa di Godna hémémbu yamba rekéndi. Godna hundi xéka wandén maki yakwa du takwa male di Godna hémémbu retandi. ");
INSERT INTO wos_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Wuni némafwi kot xékékwa néma du retewuka nukwa séfélak du takwa wuniré angi watandi, ‘Nana Néma Du, ména ximbu nani Godna hundi wa. Ména ximbu wambeka di haraki hamwinya yaange yi. Ména ximbu wata nani séfélak hanja xéhafi yandan hambuk jémba nani ya. Nani ména du takwa me.’ ");
INSERT INTO wos_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Wungi wandat wuni diré watawuni: ‘Wu yingafwe. Yéna guni ye. Wuni gunika xékélakihambawuni. Guni wuni wali natafa mawuli hérahambanguni. Guni haraki saraki mawuli xékékwa du takwa. Guni séléka!’ Wungi watawuni.” ");
INSERT INTO wos_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","25","“Ané sataku hundi mé xéké. Xékélelakikwa du nak dé motu takumbu ge to. Tondéka hukémbu némafwi mur hurundéka némafwi wali giyandéka némafwi hwe gwandéndéka wun ge jémba dé hwa, motu takumbu tondén ge. Wun sataku hundika mé saréké. Wuna hundi xékéta wawun maki yatekwa du takwa di motu takumbu yikafre ge tondé du maki di. ");
INSERT INTO wos_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","27","Jémba sarékéhafi yandé du nak dé am héfambu ge to. Tondéka hukémbu némafwi mur hurundéka némafwi wali giyandéka némafwi hwe gwandéndéka wun ge dé xakri. Xakrindéka hwe yae dé wun ge yate hura yi. Wun hundika mé saréké. Wuna hundi baka xékéta wawun maki yahafi yate du takwa, di am héfambu ge tondé du maki di.” Wungi Jisas dé diré wa. ");
INSERT INTO wos_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","29","Jisas wungi wandéka séfélak du takwa di déka hundika waréngéné, dé hambuk yata diré Godna hundi wandéka. Waréngéna di wa, “Owa. Dé Godna jémbaka dé jémba xékélaki. Xékélakita dé naniré wakwe. Hambuk hundika xékélelakikwa du di naniré Godna jémbaka wungi wakwehambandi.” Wungi wata déka hundi xékéta waréngéna di saréké waréké. ");
INSERT INTO wos_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Jisas du takwaré Godna hundika wakweta rendén némbu yatakataka naande yindéka di séfélak du takwa di déka hukémbu yi. ");
INSERT INTO wos_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Yindaka dé walisufu hurundé du nak déka yae hwati se wandé daata dé wa, “Néma Du, wuni yikafre yawute méni mawuli ye hurumét, wuni yikafre yatawuni.” ");
INSERT INTO wos_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Wungi wandéka dé déka tambambu huruta dé wa, “Wuni yikafre yaméte wuni mawuli ye. Méni yikafre yataméni.” Wungi wandéka dé wun walisufu hétékéndéka dé wun du yikafre ya. ");
INSERT INTO wos_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Yandéka dé déré wa, “Mé xéké. Méniré yawun jooka nawulak du takwaré yamba wakéméni. Méni priska ye déka makambu témét, dé ména séfiré xétandé. Xéndét, méni Moses hanja wandén maki Godka hamwi hwetaméni. Hwemét, nak du takwa xéta xékélakitandi, walisufu hétékéndéka méni yikafre yaménka.” Wungi dé Jisas déré wa. ");
INSERT INTO wos_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","6","Jisas Kaperneamré yindéka dé Romna xi warekwa duna néma du nak yae dé déré wa, “Néma Du, mé xéké. Wuna jémba yakwa duna matamba lékémbandéka dé némafwi hangéli héraata dé gembu male dé hwae.” ");
INSERT INTO wos_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Wungi wandéka dé wa, “Wuni yae déré huréhalékétawuni.” ");
INSERT INTO wos_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Wungi wandéka dé wa, “Néma Du, wu yingafwe. Wuni baka du wuni. Méni néma du méni. Wungi reta méni ye wuna geré yamba wulayikéméni. Méni ambu reta baka wamét, dé wuna du wambula yikafre yatandé. ");
INSERT INTO wos_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Nak du wunika dé néma du re. Rendéka wuni wandén maki wuni ya. Wuni xi warekwa duna néma du wuni re. Wuni du nakéka, ‘Méni sa yi,’ nawuka dé yi. Nak duka, ‘Méni mé ya,’ nawuka dé ya. Wuna jémba yakwa duré, ‘Wun jémba mé huru,’ nawuka dé wun jémba ya. Méni yawuka maki yataméni. Méni baka wamét, wuna du wambula yikafre yatandé.” Wungi dé wa. ");
INSERT INTO wos_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Jisas wun hundi xékéta dé waréngéna dé saréké waréké. Sarékéta dé déka hukémbu yandé du takwaré wa, “Ané du dé wunika jémba male saréké. Wuni wawut, du takwa yikafre yatendakaka dé xékélaki. Guni Israelna du takwa nawulak male guni wunika jémba saréké. Dé Romna du rendéka déka yikafre mawuli guni Israelna du takwa guna yikafre mawuli wundé sarékéngwandéndé. Mwi hundi wuni guniré we. ");
INSERT INTO wos_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Mé xéké. Israelna du takwa nawulak di Godna getéfaré wulayitandi. Di male yingafwe. Atéfék getéfambu yandé séfélak du takwa akwi déka getéfaré wulayitandi. Séfélak nukwa xalekwa sakumbu yae séfélak nukwa nandikwa sakumbu yae di séfélak du takwa déka getéfaré wulayitandi. Wulaaye di Godna hémémbu reta nana mandéka Abraham, Aisak, Jekop wali, wungi reta hénoo satandi. ");
INSERT INTO wos_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Israelna séfélak du takwa Godna getéfaré yamba wulayikéndi. Wun du takwaka God hu hwetandé. Hweta wandét di haraki hafwaré yitandi. Wun hafwambu halékinga male dé té. Nukwa xéhambwe. Wun hafwambu rekwa du takwa néma hangéli héraata di némafwimbu géraata némbi titandi.” ");
INSERT INTO wos_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Wungi wataka dé Romna xi warekwa duna néma duré wa, “Ména geré wambula yitaméni. Ye xaakwa wunika jémba sarékéta wuna hundika ‘Mwi hundi dé’ naménka méni wamén jooka xétaméni.” Wungi dé Jisas wa. Némbuli male wandéka dé Romna xi warekwa duna jémba yakwa du dé wambula yikafre ya. ");
INSERT INTO wos_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Jisas ye Pitana geré wulaaye dé xé Pitana nakéma séfi ya xérékéndéka hiyaata hwaléka. ");
INSERT INTO wos_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Xétaka dé léka tambambu hurundéka bar dé hényi. Hényindéka yikafre ye raama lé hénoo humbwe lé Jisaska hwe. ");
INSERT INTO wos_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Gérambu galam di haraki hamwinya hura téndé séfélak du takwa nyangwalré di hura ya, Jisaska. Hura yandaka dé wandéka di haraki hamwinya yaange yi. Bar hiyaakwa du takwa nyangwal, séfimali haraki yandé du takwa nyangwalré akwi di déka hura ya. Hura yandaka dé diré huréhalékéndéka di atéfék wambula yikafre ya. ");
INSERT INTO wos_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Jisas wungi yandéka dé Godna profet Aisaia hanja wandén hundi mwi hundi dé ya. Déka hundi Godna nyingambu angi dé wa: Nanika hiyambar yandéka dé naniré huréhaléké. Nana haraki saraki jondu dé huréhaléké. Séfimali haraki yandéka dé hambuk yata wandéka nani wambula yikafre ya. Wungi dé Aisaia hayi. ");
INSERT INTO wos_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Séfélak du takwa hérangwanda téndaka Jisas xéta dé déka duré wa, “Gunjambémbu wara tukweseke angé sakuré yitame.” ");
INSERT INTO wos_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Wungi wandéka dé xékélelakikwa du nak yae dé déré wa, “Néma Du, méni naniré Godna jémbaka méni wakwe. Wuni méni wali yitaka yatakanjoka wuni mawuli ye. Yiteméka atéfék hafwaré wuni akwi yitawuni.” ");
INSERT INTO wos_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Wungi wandéka dé Jisas wa, “Jémba mé saréké. Haraki wasa dé héfambu tékwa wekwambu dé hwae. Afwi deka wurmbu di hwae. Wuni Duna Nyan hwatewuka ge yingafwe.” ");
INSERT INTO wos_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Wungi wandéka dé déka du nak déré wa, “Néma Du, méni yawundu namét tale wuni ye rewut wuna yafa hiyandét wuni déka fusa hérae rémétawuni. Rémétaka wuni méni wali yitaka yatakatawuni.” ");
INSERT INTO wos_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Wungi wandéka dé wa, “Yinga. Némbuli wuni wali mé ya. Wuna hundi xékéhafi yakwa du takwa di hiyandé du takwa maki di re. Wunde du takwa deka hiyandé du takwaré rémétandi.” ");
INSERT INTO wos_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Wun hundi wataka Jisas gunjambémbu waréndéka di déka du akwi waré. ");
INSERT INTO wos_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Wara yindaka Jisas xéndi hwandéka dé néma mur yandéka dé gu raama wara gunjambémbu gwande dé yasamangunjoka huru. ");
INSERT INTO wos_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Hwandéka déka du ye di déré sérkené. Sérkenéta di wa, “Néma Du, nani hiyatame. Méni sé raama naniré yikafre huru.” ");
INSERT INTO wos_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Wungi wandaka dé diré wa, “Métaka guni roo? Roota wunika jémba sarékéhambanguni.” Wungi wataka dé raama wandéka mur fakénandéka dé gu wambula jémba té. ");
INSERT INTO wos_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Téndéka di atéfék waréngéna di wa, “Owa. Dé wandéka dé mur gu déka hundi xékéta wandén maki dé ya. Wu yingi maki du dé?” Wungi wataka di Jisas wali jémba yi, gunjambémbu. ");
INSERT INTO wos_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Jisas déka du wali gunjambémbu ye di tukweseke angé saku xaku. Gadarana héfambu di xaku. Xakundaka bér du yéték du takwa hiyandaka réméndan hafwambu re bér déré xénjoka yi. Haraki hamwinya di wun du yétékré hura té. Hura téndaka bér wangété yata nawulak duré xiyanjoka hurumbéka nak du takwa wun yambumbu yihambandi. ");
INSERT INTO wos_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Bér ye Jisasré xe bér hambukmbu wakwexéka bér wa, “Méni, Godna nyan, aniré méta yataméni? Aniré hangéli hwetaméni, o yingi maki dé? Kot xékékwa néma du reteméka nukwa wayika xakukéndé. Némbuli aniré hangéli hwekéméni.” Wungi bér déré wa. ");
INSERT INTO wos_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Wun hafwambu séfélak bali di hénoo sata té. ");
INSERT INTO wos_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Sandaka di wun du yétékré hura téndé haraki hamwinya di Jisasré wa, “Méni naniré hélekinjoka mawuli yata méni wamét nani wun balina mawulimbu wulayitame.” ");
INSERT INTO wos_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Wungi wandaka dé diré wa, “Guni wumbére duré mé yatakataka guni yaange yi.” Wungi wandéka di wumbére du yétékré yatakataka ye di wun balina mawulimbu wulaaye té. Téndaka wun bali némbumbu yaange naande ye gumbu xakre hulingu se di hiya. ");
INSERT INTO wos_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Hiyandaka di balika hatikwa du yaange ye néma getéfa xaakwa di wun jooka du takwaré hundi wa. Wata di haraki hamwinya hura téndé du yétékéka akwi hundi wa. ");
INSERT INTO wos_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Wungi wandaka xékétaka di wun getéfambu rekwa du takwa yi, Jisasré xénjoka. Ye déré xe di wa, dé deka héfa yatakataka yindéte. ");
INSERT INTO wos_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Jisas gunjambé nakmbu wara dé tukweseke angé sakuré ye dé déka getéfa xaku. ");
INSERT INTO wos_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Xakundéka di matamba lékémbandé du nakré déka yate hura yi. Dé jambémbu hwandéka di déka yate hura yi. Yindaka Jisas dé xékélaki. Di deka mawulimbu di wa, “Jisas hambuk yata nana duré huréhalékétandé.” Wungi wandaka Jisas xékélakita dé matamba lékémbandé duré wa, “Wuna du, ména mawuli jémba tétandé. Hurumén haraki saraki joo wundé hérekiwu.” ");
INSERT INTO wos_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Wungi wandéka di xékélelakikwa du di hafu buléta di wa, “God hafu dé du hurundan haraki saraki joo yakwanyitandé. Wun du dé wa, ‘Wuni hurumén haraki saraki joo wundé hérekiwu.’ Wungi wata dé Godka haraki hundi wa, dé du male du dé.” ");
INSERT INTO wos_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Wungi wandaka Jisas deka mawuli xékélakita dé diré wa, “Métaka guni guna mawulimbu wun haraki saraki mawuli xéké? Wungi xékékénguni. ");
INSERT INTO wos_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","6","Wuni Duna Nyan ané héfambu reta hurundan haraki saraki sémbut hali hérekiwu. Guni wun jooka xékélakihambanguni. Méta hundi wuni hali wawu, ‘Wuni hurumén haraki saraki joo wundé hérekiwu’ o ‘Sé raama ména jambé hura yi.’ Guni wuna hambukéka jémba xékélakingute wuni ané hundi akwi déré watawuni.” Wungi wataka dé matamba lékémbandé duré dé wa, “Méni sé raama ména jambé hura yi, ména geré.” ");
INSERT INTO wos_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Wungi wandéka dé raama déka geré yi. ");
INSERT INTO wos_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Yindéka wumbu téta xéndé du takwa roota Godna ximbu di haréké. Harékéta di Jisaska wa, “God wun duka hambuk hwendéka dé wungi huru.” Wungi di wa. ");
INSERT INTO wos_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Jisas wun hafwa yatakataka dé yi. Yita dé xé Romka yéwa héraakwa du nak déka xi Matyu yéwa héra gembu rendéka. Xe dé déré wa, “Méni wuni wali mé ya.” Wungi wandéka raama dé Jisas wali yi. ");
INSERT INTO wos_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Jisas déka du wali Matyuna gembu reta hénoo sandaka di yéwa héraakwa séfélak du, séfélak nak maki haraki sémbut hurukwa du akwi wungi di ya. Yae di dé wali reta di hénoo sa. ");
INSERT INTO wos_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Reta sandaka Farisi nawulak xe di Jisasna duré wa, “Métaka dé guna néma du yéwa héraakwa du, haraki sémbut hurukwa du nawulak dé di wali hénoo sa?” ");
INSERT INTO wos_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Wungi wandaka Jisas xéka dé wa, “Yikafre yakwa du takwa doktaka yihafindi. Séfimali haraki yandé du takwa di doktaka yi. Yindaka dokta dé deka séfi huréhaléké. Wuni du takwana haraki saraki mawuli wuni huréhaléké. ");
INSERT INTO wos_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Godna nyingambu angi dé wa: God dé wa, ‘Guni wunika hamwi xiyae hwengute hélék wuni ye. Guni nak du takwaka saréfa naata diré yikafre hurungute wuni mawuli ye.’ God wungi wandéka déka hundi déka nyingambu dé wa. Guni ye wun hundika jémba sarékétanguni. Haraki saraki mawuli yakwa du takwa wunika yae wuna hundi xékéndate wuni gaya. Yikafre mawuli yakwa du takwaka saréka gayahambawuni.” Wungi dé Jisas wa. ");
INSERT INTO wos_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Guré husandakwa du Jonéna du di Jisaska ye déré wa, “Nani, Farisi akwi God wali hundi bulénjoka nani séfélak nukwa hénooka yakér. Métaka di ména du nani hénoo yakérmbekangala di yakérhafi ye?” ");
INSERT INTO wos_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Wungi wandaka dé Jisas diré sataku hundi angi wa: “Du nak takwa hérandét, di hénoo humbwe yikafre mawuli yata hénoo satandi, o yingafwe? Di satandi. Takwa hérandé du di wali rendét, di yikafre mawuli yata satandi. Hukémbu di nawulak du yae wun duré hura yindat, di déka du takwa déka saréfa naata hénoo yamba sakéndi. Wuni wun takwa hérandé du maki wuni re. Wuni wuna du wali wungi rewuka di yikafre mawuli yata hénoo di se. Hukémbu wuni diré yatakawut, di wunika saréfa naata hénoo yamba sakéndi.” ");
INSERT INTO wos_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Wungi wataka dé diré sataku hundi yéték akwi angi wa: “Du takwa huli nukwa wur nak léngae hérae nyo nukwa wurmbu tékwa mofombu hundafanéhambandi. Di huli nukwa wur nak léngae hérae nyo nukwa wurmbu tékwa mofombu hundafanétaka gumbu yakwanyindat huli nukwa wur séméndét nyo nukwa wur munae dé némafwi mofo tétandé. ");
INSERT INTO wos_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Nak héki hwarimbu xiyae rundan meme bali séfimbu huli wain hulingu wukasandahafindi. Wungi wukasandandat, wun meme bali séfi nyo ye télamétandé, hulingu atéfék yitandé. Yisékendéka dé wun meme bali séfi yikafre yamba yakéndé. Huli meme bali séfimbu huli wain hulingu jémba tétandé.” Jisas wungi wandéka déka sataku hundina mo hundi angi dé: Nyo hundi wali huli hundi wali yamba tékémbér. ");
INSERT INTO wos_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Jisas wun hundi wata téndéka dé Judana néma du nak yae Jisaska hwati se wandé dae dé wa, “Wuna takwanya wayika male lé hiya. Méni yae ména tamba léré hurumét, lé wambula ramétalé.” ");
INSERT INTO wos_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Wungi wandéka dé raama déka hukémbu yindéka di déka du akwi di dé wali yi. ");
INSERT INTO wos_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","21","Yindaka lé takwa hési Jisasna hukémbu yi. Tamba atéfék man yéték héki hwari ramu yindéka lé re. Lé Jisaska wandan hundi xékétaka lé saréké, “Déka nukwa wurmbu tamba séngétaka wuni wambula yikafre yatawuni.” Wungi saréka lé yae lé déka nukwa wurna wambumbu huru. ");
INSERT INTO wos_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Huruléka Jisas waleka léré xéta dé wa, “Nyénawa, nyéni yikafre mawuli yatanyéni. Nyéni nyéniré huréhalékétewuka hambukéka sarékéta némbuli yikafre wundé yanyé.” Wungi wandéka lé wule takwa bari yikafre ya. ");
INSERT INTO wos_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Jisas wungi wataka dé néma duna geré yi. Ye dé xé du nawulak hiyalé takwanyaka saréfa naata hama yondaka séfélak du takwa di némafwimbu gérandaka. ");
INSERT INTO wos_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Xéta hafwambu téta dé wa, “Wule takwanya hiyahambalé. Lé baka xéndi lé hwae. Guni atéfék sé gwandi hafwaré.” Wungi wandéka di déka wangi. ");
INSERT INTO wos_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Wangindaka dé wandéka di atéfék du takwa yindaka dé wule takwanya hwalén hafwaré wulayi. Wulaaye dé léka tambambu hurundéka lé ramé. ");
INSERT INTO wos_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Raméléka di séfélak du takwa atéfék getéfaré yita wun jooka di hundi wa saafa yi. ");
INSERT INTO wos_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Jisas wun hafwa yatakataka yindéka bér dama hiyandé du yéték Jisasna hukémbu yi. Yita hambukmbu bér wa, “Ménawa, Devitna mandéka. Méni anika mé saréfa na.” ");
INSERT INTO wos_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Wungi wambéka dé Jisas geré wulayi. Wulayindéka bér déka yi. Yimbéka dé bérré angi wakwexéké, “Yingi béni saréké, wunika? Wuni béna dama hali huréhalékéwu, o yingafwe?” Wungi wakwexékéndéka bér wa, “Xéxé. Néma Du, méni hali huréhalékémé.” ");
INSERT INTO wos_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Wungi wambéka dé déka tamba bérka damambu huruta dé wa, “Béniré huréhalékétewuka hambukéka jémba sarékémbéka béna dama wambula yikafre yatandé.” ");
INSERT INTO wos_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Wungi wandéka bérka dama dé wambula yikafre ya. Yandéka dé Jisas bérré hambukmbu wa, “Béni wun jooka nak duré wakémbéni.” ");
INSERT INTO wos_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Wungi wandéka bér déka hundi xékéhafi yata ye atéfék getéfambu bér wun jooka hundi wa saafa yi. ");
INSERT INTO wos_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Wun du yéték yimbéka di Jisaska du nakré hura yi. Wun du haraki hamwinya déka mawulimbu wulaaye téndéka dé hundi buléhambandé. ");
INSERT INTO wos_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Di wun duré Jisaska hura yindaka dé Jisas wandéka wun haraki hamwinya yaange yindéka dé wun du hundi bulé. Buléndéka di wumbu téndé du takwa saré warékéta di wa, “Owa. Wu yikafre joo dé. Hanja angina joo Israelmbu xakundéka xéhambame.” ");
INSERT INTO wos_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Wungi wandaka di Farisi wa, “Wun yikafre joo yingafwe. Haraki hamwinyana néma du Satan dé déka hambuk hwendéka dé wandéka di atéfék haraki hamwinya yaange yi.” ");
INSERT INTO wos_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Jisas dé atéfék getéfambu yitaka yataka. Yitaka yatakataka nak getéfa xaakwa dé Godna hundi buléndaka geré wulaaye dé Godna hundi dé diré wa. God néma du reta dika jémba hatitendékaka dé hundi wa. Wata dé bar hiyandé du takwa nyangwal, séfimali haraki yandé du takwa nyangwalré akwi dé huréhaléké. ");
INSERT INTO wos_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Séfélak du takwa déka yindaka dé dika saréfa na. Sipsip balika hatikwa du sipsip balika hatihafi yandét, di wun sipsip bali wangété maki tétandi. Jisaska yindé du takwa di wun sipsip bali maki di. Wungi téndaka Jisas dika saréfa na. ");
INSERT INTO wos_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Saréfa naata dé déka duré sataku hundi angi wa, “Hénoo semben yawimbu séfélak hénoo akwe dé té. Téndéka nawulak du male di jémba ya. ");
INSERT INTO wos_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Nawulak male jémba yandaka guni wun yawina yafaré mé wakwexéké. Wakwexékéngut, dé séfélak jémba yakwa duré wandét di yae déka hénoo hératandi.” Wungi dé Jisas sataku hundi wa, séfélak du takwa Godna hundi xékénjoka mawuli yandaka Godna jémba yata déka hundi wakwa du nawulak male rendakaka. ");
INSERT INTO wos_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Jisas déka du tamba atéfék ye man yétékré wandéka yandaka dé dika hambuk hwe, di wandat atéfék haraki hamwinya yaange yindate. Dika nak hambuk akwi dé hwe, di bar hiyandé atéfék du takwa nyangwal, séfimali haraki yandé atéfék du takwa nyangwalré akwi huréhalékéndate. ");
INSERT INTO wos_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Di déka hundi hura yindate dé diré wa. Deka xi angi dé: Saimon, déka nak xi Pita. Déka bandi Andru. Sebedina nyan yéték, Jems déka bandi Jon wali. ");
INSERT INTO wos_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Filip, Bartolomyu, Tomas, Matyu. Tale Matyu Romka yéwa dé héra. Alfiusna nyan Jems. Tertius. ");
INSERT INTO wos_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Nakémba Saimon. Tale atéfék getéfaré yita dé wa, “Nak téfana du nanika néma du rendéte hélék wuni ye.” Nak du déka xi Judas Iskariot. Hukémbu Jisasré dé mama duna tambambu taka. ");
INSERT INTO wos_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Jisas wun duré angi dé hundi wa, “Guni Samariambu tékwa getéfaré yikénguni. Nak héfambu tékwa getéfaré akwi yikénguni. ");
INSERT INTO wos_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Guni Israelmbu tékwa getéfaré male yitanguni. Israelna du takwa deka mawuli yike dé ye. Fakundé sipsip bali deka mawuli yike yakwa maki, Israelna du takwa Godna hundika hu hwendaka deka mawuli yike dé ye. ");
INSERT INTO wos_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Dika yita guni angi diré hundi watanguni, ‘Néma Du God gunika hatitendéka nukwa walémba dé, yatandé.’ ");
INSERT INTO wos_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Wungi wataka guni bar hiyandé du takwa nyangwal, séfimali haraki yandé du takwa nyangwalré akwi huréhalékétanguni. Hiyandé du takwaré wangut, di wambula ramétandi. Walisufu hurundé du takwaré huréhalékétanguni. Du takwana mawulimbu tékwa haraki hamwinyaré wangut, di yaange yitandi. Wuni gunika hambuk baka wuni hwe. Hwewuka guni wun jémba baka yatanguni. Wun jémba yata yéwa hérakénguni. ");
INSERT INTO wos_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Guni yéwa nawulak hérae hura yikénguni. ");
INSERT INTO wos_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Guni yita sandangun joo male hura yitanguni. Wur nak akwi, nukwa wur nawulak akwi, su, séto bangi, wungi hura yikénguni. Guni du takwaré yikafre hurungut, di guniré yikafre hurutandi. ");
INSERT INTO wos_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","“Guni nak getéfaré wulaaye guni jémba xétanguni. Xéngut, yikafre du guni wali hundi buléndét, guni déka gembu male retanguni. Nak geré yikénguni. Déka gembu re yitanguni. ");
INSERT INTO wos_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Guni ge nakmbu wulaaye wumbu rekwa du takwaré angi watanguni, ‘Yikafre mawuli yata retanguni.’ ");
INSERT INTO wos_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Guni wungi wangut wumbu rekwa du takwa gunika yikafre mawuli yandat, God diré yikafre hurundét, di jémba retandi. Wumbu rekwa du takwa gunika yikafre mawuli yahafi yata gunika hu hwendat, God diré yikafre huruhafi yata guniré yikafre hurundét, guni jémba retanguni. ");
INSERT INTO wos_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Guni getéfa nakré wulayingut, wumbu rekwa du takwa guna hundi xékéhafi yata, gunika hu hwendat, guni wun getéfa yatakatanguni. Yatakataka yita guna manmbu tékwa harki létékétaka guni yitanguni.” ");
INSERT INTO wos_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Jisas wungi wata dé angi wa, “Gunika hu hwetekwa du takwaka wuni guniré we. Di gunika wungi hu hweta di haraki saraki sémbut di huru. Hanja Sodom Gomorambu rendé du takwa akwi di haraki sémbut di huru. Hukémbu God némafwi kot xékéta néma du retendéka nukwa dé wandét di Sodom Gomorambu rendé du takwa hangéli hératandi. Du takwa gunika hu hwendat, wun natafa haraki saraki sémbut Sodom Gomorambu rendé du takwa hurundan haraki sémbutré sarékéngwandétandé. Wun nukwa God wandét gunika hu hwetekwa du takwa némafwi hangéli hératandi. God deka haraki sémbut hasa hwetendékaka xékélakindate guni guna manmbu tékwa harki mé létéké.” ");
INSERT INTO wos_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","“Mé xéké. Wawut guni atéfék getéfaré yitanguni. Haraki wasa sipsip baliré haraki hurundaka maki, wun getéfambu rekwa du takwa di guniré haraki hurunjoka mawuli yatandi. Hambwe yita haraki saraki joo déré haraki hurundémboka xékélakindéka maki, guni haraki jooka xékélaki natanguni. Nyamwe afwi warehafi yata yikafre rendaka maki, warehafi yata jémba retanguni. ");
INSERT INTO wos_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Guni xékélaki natanguni. Du nawulak guniré hérae guniré duna makambu takatandi. Du nawulak Godna hundi buléndaka gembu guniré xiyatandi. ");
INSERT INTO wos_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Guni wuna du renguka du nawulak wuna jémbaka hélék yata guniré hura yindat, guni deka néma duna makambu tétanguni. Di wungi yandat guni diré wuna hundi watanguni. Nak téfana du takwaré akwi wuna hundi watanguni. ");
INSERT INTO wos_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Du nawulak guniré duna makambu takandat, guni roohafi yata guna mawulimbu angi wakénguni, ‘Nani méta hundi watame? Dika hundi yingi maki hasa watame?’ Wungi wakénguni, wun nukwa God watenguka hundi gunika hwetandé. ");
INSERT INTO wos_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Wun nukwa guna yafa Godna Hamwinya guna mawulimbu wulaaye téndét, guni déka hundi xékéta watanguni. Guna mawulimbu sarékéta hundi wakénguni. ");
INSERT INTO wos_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","“Hukémbu séfélak du deka nyamangu bandinguré duna makambu takandat, di nyamangu bandinguré xiyatandi. Yafa deka nyangwalré duna makambu takandat, di wun nyangwalré xiyatandi. Nyangwal akwi yafa ayiwaré duna makambu takandat, di yafa ayiwaré xiyatandi. ");
INSERT INTO wos_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Guni wuna du renguka atéfék du takwa gunika hélék yatandi. Guni guna mawulimbu hambuk yata wuna jémba hurungut, hukémbu God guniré hérandét, guni dé wali jémba reséketanguni, wungi re wungi re. ");
INSERT INTO wos_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Nak getéfambu guniré haraki hurundat, guni nak getéfaré yaange yitanguni. Israelna atéfék getéfambu jémba yasékehafi yangut, wuni Duna Nyan wambula yatawuni. Mwi hundi wuni guniré we.” ");
INSERT INTO wos_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","“Ané sataku hundi mé xéké. Nyangwal diré wakwekwa duré sarékéngwandéhambandi. Jémba yakwa du dika jémba hwekwa duré sarékéngwandéhambandi. ");
INSERT INTO wos_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Nyangwal diré wakwekwa du wali sékéré téndat, wu yawundu. Jémba yakwa du dika jémba hwekwa du wali sékéré téndat, wu yawundu. Némbuli wun hundika mé saréké. Nak du wuni guna néma duré yanguka maki, di guni wuna duré akwi yatandi. Nak du wunika haraki saraki hundi wata di wa, ‘Guna néma du dé atéfék haraki hamwinyana néma du dé, déka xi Belsebul dé.’ Di wunika wungi wata guni wuna du gunika haraki hundi watandi.” Wungi dé Jisas déka duré wa. ");
INSERT INTO wos_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","Wun hundi wataka dé Jisas déka duré ané hundi wa, “Du nawulak guniré haraki hurundat, guni dika rookénguni. Hurutaka fakungun joo hukémbu séfélak du takwa xétandi. Nakélak wangun hundi hukémbu séfélak du takwa xékétandi. ");
INSERT INTO wos_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Gan reta wawun hundi guni nukwambu watanguni. Némbuli wuni guni wali reta nakélak wuni hundi wa. Séfélak du wuna hundi xékéhambandi. Guni male guni xéké. Hukémbu guni hafwambu téta wun hundi hambukmbu wangut, di xékétandi. ");
INSERT INTO wos_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Du nawulak di wa, guniré xiyatendakaka. Dika rookénguni. Di guniré xiyaata di guna hamwinyaré xiyanjoka hurufatikétandi. Guni Godka rootanguni. Dé male wun jooka dé hambuk ya. Dé du takwana séfi du takwana hamwinyaré akwi hali xiyandé. Diré ya yanékwa hafwaré hali yakisandandé. ");
INSERT INTO wos_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Ané hundi mé xéké. Du takwa di yikama yéwa hwetaka yikama afwi yéték di héra. Yikama afwi nak héfambu xakriléka guna yafa God wun jooka dé xékélaki. Afwi nak héfambu xakrihafi yaléte wandét, wule afwi yamba xakrikélé. ");
INSERT INTO wos_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Gunika akwi dé xékélaki. Atéfék jooka dé xékélaki. Guna makambu tékwa némbé atéfék handékéna wun jooka akwi dé xékélaki. Xékélakita dé gunika jémba hati. ");
INSERT INTO wos_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Hatindékaka sarékéta guni rookénguni. Afwi yikama joo dé. Du takwa néma joo dé. Guna yafa God yikama afwika wungi jémba hatita gunika jémba male hatitandé. ");
INSERT INTO wos_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","“Du nawulak séfélak du takwana makambu téta nak nak angi wandat, ‘Wuni Jisasna du wuni.’ Wungi wandat, hukémbu wuni wuna yafana getéfambu reta déka makambu téta wuni déré watawuni, ‘Ané du wuna du dé.’ Wungi watawuni. ");
INSERT INTO wos_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Du nawulak séfélak du takwana makambu téta nak nak angi wandat, ‘Wuni Jisasna du yingafwe.’ Wungi wandat wuni wuna yafana getéfambu reta déka makambu téta wuni déré watawuni, ‘Wun du wuna du yingafwe.’ Wungi watawuni Godka. ");
INSERT INTO wos_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","“Yingi guni we? Atéfék héfambu rekwa atéfék du takwa warehafi yata jémba rendate wuni ya, o yingafwe? Wu yingafwe. Yawuka du nawulak wuna hundi jémba xékéndat deka hém rékambambu wata di wali waretandi. ");
INSERT INTO wos_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Yawuka du takwa nawulak wuna hundi jémba xékéndat, du takwa nawulak wuna hundika hu hwetandi. Yata nyangwal deka yafa wali waretandi. Takwanya deka ayiwa wali waretandi. Miyanyingu deka yo wali waretandi. ");
INSERT INTO wos_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Natafa gembu rekwa du takwa di akwi waretandi. ");
INSERT INTO wos_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Guni guna yafa ayiwaka némafwimbu mawuli yata wunika yikamambu mawuli yata guni wuna du takwa yamba rekénguni. Guni guna nyangwalka némafwimbu mawuli yata wunika yikamambu mawuli yata guni wuna du takwa yamba rekénguni. ");
INSERT INTO wos_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Guni angi wangut, ‘Jisasna jémba yata hangéli héraata mimbu hiyambet, wu baka joo dé. Néma joo yingafwe.’ Wungi wata guni wuna jémba yata guni wuna du retanguni. Guni wungi wahafi yata wuna jémba yahafi yata guni wuna du takwa yamba rekénguni. ");
INSERT INTO wos_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Guni wunika sarékéta wuna jémba yangut, di wuna mama guniré xiyandat, guni wuni wali wungi re wungi re jémba retanguni. Guni guna séfika male sarékéta guna jémba male ye guni hiyae fakutanguni. Wuni wali yamba rekénguni.” Wungi dé Jisas déka duré wa. ");
INSERT INTO wos_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","Wun hundi wataka dé Jisas déka duré angi dé wa, “Du takwa guniré yikafre huruta di wuniré akwi yikafre huru. Huruta wunika yawute wandén du Godré akwi di yikafre huru. ");
INSERT INTO wos_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Guni profet nakré xe angi wangut, ‘Wun du dé Godna ximbu hundi wa. Wuni déka retendéka hafwa, hénoo akwi hwetawuni.’ Wungi wata yangut, hukémbu God guniré yikafre hurutandé, déka profetré yikafre hurungun maki. Guni yikafre jémba yakwa du nakré xe angi wangut, ‘Wun du dé yikafre jémba male dé ya. Wuni déka retendéka hafwa, hénoo akwi hwetawuni.’ Wungi wata yangut, hukémbu God guniré yikafre hurutandé, yikafre jémba male yakwa duré yikafre hurungun maki.” ");
INSERT INTO wos_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","“Ané hundi akwi mé xéké. Du takwa wuna duré xéta angi wandat, ‘Wun du di néma du yingafwe. Di baka du di. Reta di Jisasna jémba di ya. Diré yikafre hurutame. Di hulingu hiyae yandat, dika hulingu hwetame.’ Wungi wata di wun yikama jémba yandat, God wun yikama jémbaka yike yamba yakéndé. Hukémbu wun yikafre jémba hasa hwetandé diré. Mwi hundi wuni guniré we.” Wungi dé Jisas déka duré wa. Wandéka di déka jémba yanjoka di yi. ");
INSERT INTO wos_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Jisas Krais déka du tamba yéti man yétékré hundi wataka wun getéfa yatakataka dé wun hafwambu tékwa getéfaré yita dé du takwaré Godna hundi wa. ");
INSERT INTO wos_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Wata Godna jémba yandéka dé guré husandakwa du Jon séndé gembu reta dé yandén jémbaka hundi xéké. Xékéta déka duré wandéka di Jisaska yi. ");
INSERT INTO wos_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","Ye di Jisasré wa, “Hanja Godna nyingambu di hundi hayi, naniré yikafre hurunjoka hukémbu yatekwa duka. Méni wun du méni, o nak duka haxétame? Wun jooka xékélakinjoka dé Jon mawuli ye.” ");
INSERT INTO wos_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Wungi wandaka dé diré wa, “Guni wambula ye guni xéngun jondu xékéngun hundika Jonré watanguni. ");
INSERT INTO wos_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Dama hiyandé du takwa xéndaka man haraki yandé du takwa yikafre ye di yitaka yataka. Walisufu hurundé du takwa yikafre yandaka waan héténdé du takwa di hundi xéké. Wun du takwaré wuni huréhaléké. Wuni wawuka hiyandé du takwa di wambula raama. Jambangwe du takwaré wuni Godna yikafre hundi we. ");
INSERT INTO wos_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Du takwa nawulak di wunika wa, ‘God déré dé waséke, dé naniré yikafre hurundéte. Wu mwi hundi dé.’ Wungi wata di wunika jémba saréké. Wunika wungi sarékékwa du takwa di yikafre mawuli yata jémba retandi. Wungi Jonka watanguni.” Wungi dé Jonéna duré wa. ");
INSERT INTO wos_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Jisas wungi wandéka Jonéna du yindaka dé Jisas wumbu rendé du takwaré Jonka angi wa, “Guni du rehafi hafwaré ye yingi maki duré xénjoka guni yi? Mur yandéka séngénékwa suwa maki yakwa duré xénjoka guni yi, o yingi maki dé? Jon wun joo maki yingafwe. Jon dé hambuk jémba yakwa du dé. ");
INSERT INTO wos_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Yikafre nukwa wur husandandé duré xénjoka guni yi, o yingi maki dé? Jon wun du maki yingafwe. Yikafre nukwa wur husandandé du di néma duna gembu di re. ");
INSERT INTO wos_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Profet nakré xénjoka guni yi, o yingi maki dé? Xéxé, Jon dé profet dé. Dé néma du dé. Godna profetna néma duré sarékéngwanda dé néma du dé re. ");
INSERT INTO wos_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Jonka du nak Godna nyingambu angi dé hayi: Mé xé, ané wuna hundi hura yikwa du dé. Déré watawuni, dé ména makambu yindéte. Dé tale ye ména yambu hurutandé. Nani wun hundi xéta nani xékélaki. Jon dé Godna hundi hura yita tale yambu hurukwa du dé. ");
INSERT INTO wos_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Wungi xékélakita guniré wuni we. Guré husandakwa du Jonéna jémba ané héfambu rekwa takwa hérandan atéfék duna jémbaré dé sarékéngwandé. Sarékéngwanda dé wuni guniré yikafre yatewuka jémbaka xékélakihambandé. Xékélakihafi yandéka dé du takwa wuni guniré yikafre hurutewuka jémbaka xékélakita Godna hémémbu reta di Jonré sarékéngwandétandi. Di Godna hémémbu baka du reta di Jonré sarékéngwandétandi. Wuni guniré mwi hundi wuni we.” ");
INSERT INTO wos_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Wungi wataka Jisas dé angi wa, “Jon yae dé du takwaré Godna hundi wa. Tale wandén nukwa némbuli akwi séfélak du takwa Godna hémré di haraki huru. Haraki hura di wunde di warekwa du di hambuk yata Godna hémré haraki huru. ");
INSERT INTO wos_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Moses wandén hambuk hundi akwi, Godna profet atéfék akwi di God néma du reta du takwaka jémba hatitendékaka di wa. Jon akwi dé wun jooka wa. ");
INSERT INTO wos_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Guni ané hundi xékénangut, wu yikafre dé. Jon hafu dé wambula yatekwa du Elaija dé. ");
INSERT INTO wos_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Guni xékélakinjoka mawuli yata waan take jémba xékétanguni. ");
INSERT INTO wos_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","“Némbuli rekwa du takwa yingi maki di? Guniré watawuni. Némbuli rekwa du takwa di nyéndé amembu rekwa nyangwal maki di. Di reta di nak nyangwalré wa. ");
INSERT INTO wos_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","Wata di wa: ‘Nani hama yombeka guni hétihiyahambanguni. Nani saréfa naata gamba gwar wambeka guni wata gérahambanguni.’ Némbuli rekwa du takwa di wungi wakwa nyangwal maki di. ");
INSERT INTO wos_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Jon yae sambeka hénoo sahafi yata sambeka wain hulingu sahambandé. Sahafi yandéka di déka sémbutka hélék yata di Jonka wa, ‘Haraki hamwinya déka mawulimbu wulaaye téndéka dé wangété ye.’ ");
INSERT INTO wos_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Wungi wandaka wuni Duna Nyan yae sambeka hénoo sata sambeka wain hulingu wuni sa. Sawuka di wunika hélék yata di wa, ‘Mé xé. Wun du séfélak hénoo wain hulingu satéfwa du dé. Dé Romka yéwa héraakwa du wali reta, haraki saraki sémbut hurukwa du takwa wali reta dé deka nyayika dé re.’ Wungi wandaka wuni guniré we. God dé atéfék jonduka xékélaki. Déka jémba yikafre jémba dé. Wu mwi hundi dé. Wun hundika sarékéta guni Godka yandéka jémbaka jémba sarékétanguni.” Wungi dé Jisas wunde du takwaré wa. ");
INSERT INTO wos_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Jisas néma getéfambu nawulak dé hanja xéhafi yandan séfélak hambuk jémba dé ya. Yandéka di wumbu rendé du takwa hurundan haraki saraki sémbut yatakahafi ye Godka sarékéhambandi. ");
INSERT INTO wos_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","Sarékéhafi yandaka Jisas dé diré angi wa, “Haraki du takwa, guni Korasinmbu rekwa du takwa! Haraki du takwa, guni Betsaidambu rekwa du takwa! Wuni guna getéfambu reta wuni hambuk jémba wuni ya. Yawuka guni xé. Xéta guni Godka sarékéhambanguni. Tairmbu hanja rendé du takwa, Saidonmbu hanja rendé du takwa akwi, Godka xékélakihafi ye wun hambuk jémba xe, hanja di hurundan haraki saraki sémbutka hélék yata, wun haraki sémbut yatakatandi. Hurundan haraki saraki sémbutka hélék yata, nak du takwa deka mawulika xékélakindate di nyo nukwa wur naake bombu retandi. ");
INSERT INTO wos_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","“Guni mé xéké. Hukémbu God némafwi kot xékéta néma du retendéka nukwambu dé wandét di Tairmbu hanja rendé du takwa, Saidonmbu hanja rendé du takwa akwi di hangéli hératandi. Guni, Korasinmbu rekwa du takwa, Betsaidambu rekwa du takwa akwi, guni wuna jémba xe guni wunika hu hwe. Hu hwenguka wun natafa haraki saraki sémbut di hurundan atéfék haraki sémbutré dé sarékéngwandé. Wun nukwa God wandét guni némafwi hangéli hératanguni. ");
INSERT INTO wos_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","“Guni Kaperneamémbu rekwa du takwa, guni wambula wambula guni wa, ‘Nani Godna getéfaré waritame.’ Wungi wanguka guniré wuni we. God wandét guni haraki hafwaré nanditanguni. Guni Godna getéfaré yamba warikénguni. Wuni guna getéfambu reta wuni hambuk jémba wuni ya. Yawuka guni xé. Xe guni Godka sarékéhambanguni. Hanja Sodomémbu rendé du takwa séfélak haraki saraki sémbut hura wun hambuk jémba xe deka hurundan haraki sémbut yatakatandi. Wungi yatakandat, God wun getéfaré haraki yamba hurukéndé. ");
INSERT INTO wos_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","“Guni mé xéké. Hukémbu God némafwi kot xékéta néma du retendéka nukwambu dé wandét di Sodomémbu rendé du takwa hangéli hératandi. Guni Kaperneamémbu rekwa du takwa, guni wuna jémbaka wunika akwi guni hu hwe. Hu hwenguka wun natafa haraki saraki sémbut di hurundan atéfék haraki saraki sémbutré dé sarékéngwandé. Wun nukwa God wandét guni némafwi hangéli hératanguni.” Wungi dé Jisas wa. ");
INSERT INTO wos_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Wun hundi wataka Jisas angi dé Godré wa, “Wuna yafa, méni nyir héfaka néma du méni re. Ména jémbaka nawulak fakuméka séfélak jonduka xékélakikwa du ména jémbaka xékélakihambandi. Séfélak jooka xékélakihafi yata nyangwalna mawuli maki tékwa du takwa diré ména jémbaka méni wakwe. Wungi wakweméka, wu yikafre dé. ");
INSERT INTO wos_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Wuna yafa, ména mawuli yamékangalambu méni huru. Wu yawundu.” ");
INSERT INTO wos_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Wun hundi wataka dé angi wa, “Wuna yafa dé déka atéfék jondu wunika dé hwe. Wuni déka nyan rewuka di du takwa wunika xékélakihambandi. Wuna yafa male dé wunika xékélaki. Du takwa déka xékélakihambandi. Wuni male wuni déka xékélaki. Déka wakwewun du takwa akwi di déka xékélaki. ");
INSERT INTO wos_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","“Guni guna mawulimbu saréké warékéta jémba renjoka hambuk jémba yakwa du takwa, guni wunika yangut, wuni wawut guna mawuli jémba tétandé. Wunika yangut wawut resétotanguni. ");
INSERT INTO wos_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Wuni jémba yawuka maki guni jémba yatanguni. Guni wuna jémbambu xalengut, wuni wun jémbaka guniré wakwetawuni. Wakwewut, nani natafa mawuli hérae wun jémba yatame. Wuni nakélak huruta wuna ximbu harékéhafi yakwa du wuni. Guni wuna jémba yangut, guna mawuli jémba tétandé. ");
INSERT INTO wos_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Hwetewuka jémba guni mawuli yatenguka jémba dé. Rootenguka jémba yingafwe. Guni wuna jémba yangut, guna mawuli jémba tétandé. Téndét guni jémba retanguni.” Wungi dé Jisas wa. ");
INSERT INTO wos_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Hukémbu Judana baka hwa nukwa nak Jisas déka du wali di wit tékwa yawimbu di yi. Yindaka déka du hénoo yandéka di wit humbu nawulak tukwee di sa. ");
INSERT INTO wos_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Sandaka di Farisi xéta di Jisasré wa, “Mé xé. Ména du wit humbu di tukwee se, baka hwa nukwambu. Nana hambuk hundi angi dé wa, ‘Guni baka hwa nukwambu jémba yamba yakénguni.’ Wun hambuk hundi ména du xékéhambandi. Di wit humbu tukweta di jémba ya baka hwa nukwambu. Wungi haraki di huru.” ");
INSERT INTO wos_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Wungi wandaka dé diré wa, “Hanja nana mandéka Devit yandén jooka di Godna nyingambu hayi. Wun hundika xékélakihambanguni wana? Hanja Devit déka du wali hénoo yandéka ");
INSERT INTO wos_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","di Godna geré wulaaye wun prisré dé wakwexéké, Godka hweta takandan bret dika hwendéte. Wakwexékéndéka hwendéka Devit déka du wali di wun bret sa. Wungi sata di nana hambuk hundi xékéhambandi. Nana hambuk hundi angi dé wa, ‘Pris male Godka hwendan hénoo satandi. Nak du wun hénoo yamba sakéndi.’ Wungi dé wa. Guni Devit hurundén jooka xékélakihambanguni wana?” ");
INSERT INTO wos_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","“Nak hundika akwi mé saréké. Pris di baka hwa nukwa di tempelmbu jémba ya. Moses wandén hambuk hundi dé angi wa, ‘Pris baka hwa nukwa akwi tempelmbu wun jémba yatandi. Wu yikafre dé.’ Wungi wandéka di baka hwa nukwa wun jémba yandaka guni dika haraki hundi wahambanguni. Wahafi yata métaka guni wuna duka guni haraki hundi wa? ");
INSERT INTO wos_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Mé xéké. Wuni tempelré sarékéngwanda wuni néma du wuni re. Mwi hundi wuni guniré we.” ");
INSERT INTO wos_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","“Godna nyingambu angi dé wa: God dé wa, ‘Guni nawulak du takwaka saréfa naata diré yikafre hurungute, wuni mawuli ye. Guni wunika hamwi xiyae hwengute hélék wuni ye.’ Wungi dé God wa. Wandéka wun hundi déka nyingambu rendéka guni wun hundika xékélakihambanguni. Guni wun hundika jémba xékélakita guni haraki saraki sémbut huruhafi yandé duré haraki hundi yamba wakénguni. ");
INSERT INTO wos_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Wuni Duna Nyan wuni baka hwa nukwaka néma du reta wuni wun hundi we. Wuni du takwana jémbaka yawundu nawut, di yawundu nawun maki hurutandi, baka hwa nukwambu.” Wungi dé Jisas wa. ");
INSERT INTO wos_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Wun hundi wataka dé Jisas wun hafwa yatakataka dé Godna hundi buléndaka geré wulayi. ");
INSERT INTO wos_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Wulayindéka tamba lékémbandé du nak dé wumbu té. Téndéka Jisaska hélék yakwa du deka mawulimbu di wa, “Jisas baka hwa nukwa jémba yandét, nani déré duna makambu takatame.” Wungi wata di Jisasré wa, “Baka hwa nukwambu du nak bar hiyaakwa duré huréhalékéta, dé nana hambuk hundika dé hu hwe, o yingi maki dé? Wun jooka yingi méni wa?” ");
INSERT INTO wos_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Wungi wandaka dé diré wa, “Guna du nak déka sipsip bali baka hwa nukwambu xakre wekwambu téndét, dé wun sipsip baliré husaletandé, o yingi maki dé? Dé déka sipsip baliré husaletandé. Wu mwi hundi dé. ");
INSERT INTO wos_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Sipsip bali wu yikama joo dé. Du takwa wu némafwi joo dé. Baka hwa nukwambu du nak duré yikafre hurundét, nana hambuk hundi wun jooka déré haraki hundi yamba wakéndé. Wuni baka hwa nukwambu duré yikafre huruwut, nana hambuk hundi wun jooka wuniré haraki hundi yamba wakéndé.” ");
INSERT INTO wos_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Wungi wataka dé tamba lékémbandé duré wa, “Ména tamba mé huritéké.” Wungi wandéka dé déka tamba huritékéndéka dé nak tamba téndé maki jémba dé té. ");
INSERT INTO wos_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Téndéka di Farisi mawuli wita wun ge yatakataka di hundi bulé, Jisasré xiyanjoka. ");
INSERT INTO wos_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Jisas wun jooka xékélakita dé wun getéfa yatakataka dé yi. Yindéka di séfélak du takwa déka hukémbu di yi. Yindaka dé wandéka bar hiyandé du takwa atéfék, séfimali haraki yandé du takwa atéfék di yikafre ya. ");
INSERT INTO wos_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Yandaka dé diré hambukmbu wa, di déka jémbaka nawulak du takwaré hundi wandamboka. ");
INSERT INTO wos_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Wungi wandéka Godna profet Aisaiana hundi wun nukwambu mwi hundi dé ya. Hanja Aisaia ané hundi dé Godna nyingambu hayi: ");
INSERT INTO wos_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“God dé wa, ‘Wun wasékewun duré mé xé. Dé wuna jémba yatekwa du dé. Wuni déka némafwimbu mawuli yawuka wuna mawuli yikafre dé ya, déka. Wuni wawut wuna Hamwinya déka mawulimbu wulaaye tétandé. Téndét dé néma kot xékékwa néma du reta wuna hundi nak téfana du takwaré watandé. ");
INSERT INTO wos_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Dé waruhafindé. Dé hambukmbu wahafindé. Dé yambumbu téta diré hambukmbu wahafindé. ");
INSERT INTO wos_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Dé funya hwaakwa suwaré hutukwahafindé. Dé ya yaki mulukéta téndét sékunyihafindé. Dé wungi huruta déka sarékékwa nawulak du takwaré yikafre hurundét, di hambuk yata déka jémba sarékétandi. Dé jémba yandét yikafre jondu male tétandé. Haraki jondu hényitandé. ");
INSERT INTO wos_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Nak téfambu rekwa du takwa déka jémba sarékéta watandi, ‘Dé naniré yikafre hurutandé.’ Wungi wata déka haxétandi.’ Wungi dé God wa.” Wungi dé Aisaia hayi. ");
INSERT INTO wos_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Du nawulak di du nakré Jisaska hura yi. Wun duré haraki hamwinya dé hura té. Téndéka dé déka dama hiyandéka dé hundi buléhambandé. Buléhafi yandéka dé Jisas déré huréhalékéndéka dé hundi buléta dama xé. ");
INSERT INTO wos_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Yandéka di séfélak du takwa xéta waréngénéta di wa, “Owa. Wun du Devitna mandéka, o yingi maki dé?” Wungi di wa. ");
INSERT INTO wos_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Farisi wun jooka xékéta di di hafu hundi buléta di wa, “Wun du dé God wasékendén du yingafwe. Haraki hamwinyana néma du déka xi Belsebul déka mawulimbu dé wulaaye té. Téta hambuk hwendéka wun du wandéka di haraki hamwinya yaange yi.” ");
INSERT INTO wos_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Wungi wandaka Jisas deka mawuliré xékélakita dé diré wa, “Ané hundi mé xéké. Néma getéfambu rekwa du watémbéra hafu hafu reta wareta di jémba yamba rekéndi. Natafa gembu rekwa du takwa watémbéra di hafu wareta di akwi jémba yamba rekéndi. ");
INSERT INTO wos_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Wun hundika mé saréké. Haraki hamwinyana néma du Satan déka du wali wungi di re. Di watémbéra deka du wali wareta di jémba yamba rekéndi. Guni wuniré wangun maki, Satan déka hém yaange yindate wandét, di jémba yamba rekéndi. Satan wungi jémba yahambandé. ");
INSERT INTO wos_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Guni wunika angi guni we, ‘Haraki hamwinyana néma du, Belsebul wuna mawulimbu téta wunika hambuk hwendéka wuni wawuka di haraki hamwinya yaange yi.’ Wu yéna guni ye. Wawuka maki guna du nawulak di akwi wandaka di haraki hamwinya yaange yi. Di wun jémbaka xékélakita di hukémbu wangun yénataka hundika guniré duna makambu takatandi. ");
INSERT INTO wos_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Mé xéké. Godna Hamwinya wuna mawulimbu téta dé wunika hambuk hwe. Hwendéka wuni haraki hamwinyaré wawuka di yaange yi. Guni wun jooré xéta angi xékélakitanguni. God néma du reta du takwaka jémba hatitendéka nukwa wundé yandé gunika. ");
INSERT INTO wos_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Ané hundi mé xéké. Du nak hara duna geré wulaaye déka jondu sélé héranjoka tale dé wun duré hura yoombu gitandé. Gitaka déka geré wulaaye déka jondu sélé hératandé. Wun hundika mé saréké. Satan wun hara du maki dé. Wuni wun duré yoombu gikwa du maki wuni. Wuna hambuk Satanéna hambukré dé sarékéngwandé. ");
INSERT INTO wos_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Wuni wali jémba yahafi yakwa du takwa di wuna mama di. Wuni du takwaré hérawuka di wuni wali di té. Wuni wali sékéré hérahafi yakwa du di wuna du takwaré héle nambwe yakindaka di yi.” ");
INSERT INTO wos_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","“Wun jooka sarékéta wuni guniré we. Du takwa haraki saraki sémbut hurutaka wun haraki saraki sémbutka hélék ye yatakandat, God hurundan haraki saraki sémbut yakwanyitandé. Du takwa haraki hundi wataka wun haraki hundika hélék ye yatakandat, God wun haraki hundi yakwanyitandé. Di Godna Hamwinyaka haraki hundi wandat, God wun haraki saraki sémbut yamba yakwanyikéndé. ");
INSERT INTO wos_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Wuni Duna Nyan wuni re. Du takwa wunika haraki hundi wataka wun haraki hundika hélék ye yatakandat, God wun haraki sémbut yakwanyitandé. Di Godna Hamwinyaka haraki hundi wandat, God wun haraki saraki sémbut yamba yakwanyikéndé. Némbuli yamba yakwanyikéndé. Hukémbu akwi yamba yakwanyikéndé.” Wungi dé Jisas wa. ");
INSERT INTO wos_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Wun hundi wataka dé Jisas diré angi wa, “Yikafre mimbu dé yikafre sék xaké. Haraki mimbu dé haraki sék xaké. Nani misékré xéta nani xékélaki, yikafre mika akwi, haraki mika akwi. ");
INSERT INTO wos_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Guni Farisi, guni duré tikwa hambwe maki guni re. Guni haraki saraki mawuli male guni xéké. Xéka yingi maki guni yikafre hundi watanguni? Du takwa deka mawuli sarékémbu hundi di bulé. ");
INSERT INTO wos_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Yikafre mawuli yakwa du takwa di yikafre sémbut huruta yikafre hundi di bulé. Haraki saraki mawuli xékékwa du takwa di haraki saraki sémbut huruta haraki saraki hundi di bulé. ");
INSERT INTO wos_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Mé xéké. Guniré wuni we. God néma kot xékéta néma du retendéka nukwa atéfék du takwaré God wakwexékéndét, di buléndan néma hundi, buléndan baka hundi, buléndan atéfék hundika déré hasa watandi. ");
INSERT INTO wos_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Hukémbu dé guna hundi atéfék xékétaka dé nawulakéka angi watandé, ‘Guni yikafre sémbut hurukwa du takwa guni.’ Wataka nawulakéka angi watandé, ‘Guni haraki saraki sémbut hurukwa du takwa guni.’ Wungi God watandé.” Wungi dé Jisas Farisiré wa. ");
INSERT INTO wos_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Wun hundi wandéka di xékélelakikwa du nawulak akwi, Farisi nawulak akwi wungi di Jisasré wa, “Néma du, nani hanja xéhafi yamben hambuk jémba nak yamét xénjoka nani mawuli ye. Méni yamét nani xéta xékélakitame. God wandéka méni ya. Wungi xékélakitame.” ");
INSERT INTO wos_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Wungi wandaka dé diré wa, “Ané nukwa rekwa du takwa haraki saraki sémbut di huru. Di hu wundé hwenda, Godka. Wuniré wangun hambuk jémba, hanja xéhafi yangun hambuk jémba, yamba yakéwuni. Godna profet Jona hanja yandén maki male yatawuni. ");
INSERT INTO wos_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Hanja Jona gan hufuk nukwa hufuk wungi némafwi xéri hamwina biyakombu hwandén maki, wuni Duna Nyan réméndat, wekwambu gan hufuk nukwa hufuk wungi hwatawuni. ");
INSERT INTO wos_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Hanja Ninivembu rendé du takwa di Jonana hundi xékétaka hurundan haraki saraki sémbut di yataka. Jona néma du rendéka wuni guna nyéndékmbu tékwa du wuni Jonaré wuni sarékéngwandé. Hukémbu God néma kot xékéta néma du retendéka nukwa Ninivembu rendé du takwa raama Godna makambu téta gunika watandi, ‘Jona naniré Godna hundi wandéka nani xéka hurumben haraki saraki sémbut yatakataka nani Godna hundi jémba xéké. Jisas Jonaré sarékéngwanda guniré Godna hundi wandéka guni hurungun haraki saraki sémbut yatakahafi ye guni Godna hundi xékéhambanguni. Wungi yata guni némafwi haraki saraki sémbut guni huru.’ Wungi watandi gunika. ");
INSERT INTO wos_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","“Hanja néma takwa hési, afaké téfambu yae lé néma du Solomonéna hundi xékénjoka lé afaké yambumbu ya. Dé xékélelakikwa du rendéka wuni guna nyéndékmbu tékwa du Solomonré wuni sarékéngwandé. Hukémbu God néma kot xékéta néma du retendéka nukwa wule néma takwa raama Godna makambu téta lé gunika watalé, ‘Wuni afaké téfambu wuni ya. Yae Solomonéna hundi wuni xéké. Jisasna hundi Solomonéna hundiré dé sarékéngwandé. Guni Jisasna hundi xékéhambanguni. Wungi yata némafwi haraki saraki sémbut guni huru.’ Wungi wule takwa watalé gunika.” Wungi dé Jisas diré wa. ");
INSERT INTO wos_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Wun hundi wataka dé Jisas diré angi wa, “Ané hundi mé xéké. Haraki hamwinya ye dé nak duna mawulimbu wulaaye te yatakataka dé yi. Wali giyahafi yakwa hafwambu yitaka yatakataka retendéka hafwaka dé hwaké. ");
INSERT INTO wos_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","Hwakéfatika dé wa, ‘Wuni hanja rewun geré wambula yitawuni.’ Wungi wataka wambula ye dé xé wun duna mawuli yikafre ye baka téndéka. ");
INSERT INTO wos_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Xétaka ye dé haraki hamwinya angé tamba yétiyéti angé tamba hufukré hura ya. Hura yandén haraki hamwinya hurundan haraki saraki sémbut tale hurundén haraki sémbutré dé sarékéngwandé. Wunde haraki hamwinya atéfék di wun duna mawulimbu wulaaye té. Tale haraki hamwinya nak déka mawulimbu wulaaye téta dé wun duré nawulak haraki sémbut dé huru. Hukémbu séfélak haraki hamwinya déka mawulimbu wulaaye téta di wun duré séfélak haraki saraki sémbut di huru. Wun hundika mé saréké. Séfélak haraki saraki sémbut hurundé du rendén maki, némbuli rekwa du takwa wunika jémba sarékéhafi yata baka reta séfélak haraki saraki sémbut hurukwa du takwa retandi.” Wungi dé diré wa. ");
INSERT INTO wos_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Jisas du takwaré hundi wata téndéka déka ayiwa, déka bandingu akwi yae di hafwambu té. Téta di dé wali hundi bulénjoka di mawuli ye. ");
INSERT INTO wos_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Mawuli yandaka dé du nak wulaaye Jisasré wa, “Mé xéké. Ména ayiwa, ména bandingu yae hafwambu téta di méni wali hundi bulénjoka di we.” ");
INSERT INTO wos_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Wungi wandéka dé Godna hémka diré wakwenjoka mawuli yata dé déré wa, “Wuna ayiwa bandingu héndé?” ");
INSERT INTO wos_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Wungi wataka dé déka duré déka tambaré wakweta dé wa, “Mé xé. Ané wuna ayiwa, wuna bandingu di. ");
INSERT INTO wos_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Anwarmbu rekwa du wuna yafana hundi xékéta wandén maki hurukwa du takwa, wu wuna bandingu, wuna nyangengu, wuna ayiwa di.” Wungi dé Jisas wa. ");
INSERT INTO wos_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Wun nukwa Jisas hundi wataka ge yatakataka dé tukwesekeré yi. Ye dé tukweseke tufwambu re. ");
INSERT INTO wos_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Rendéka di séfélak du takwa yae di dé rendénmbu hérangwandé. Hérangwanda di déka hundi jémba xékénjoka mawuli yandaka dé gunjambéré wara dé re, tukwesekembu. Rendéka di du takwa tukweseke tufwambu di té. ");
INSERT INTO wos_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Téndaka dé diré séfélak sataku hundi wa. Tale dé diré angi wa: “Du nak dé déka yawimbu wit sék yawulalama yakinjoka dé yi. ");
INSERT INTO wos_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Ye yawulalama yakindéka di wit sék nawulak yambumbu di xakri. Xakre baka rendaka di afwi yae hérae di sa. ");
INSERT INTO wos_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Wit sék nawulak di motu takumbu rekwa héfambu xakri. Wun héfa motuna takumbu male dé té. Wungi téndéka xakre di bari takélaka waré. ");
INSERT INTO wos_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Wara di deka méngi jémba huruhafi yandéka némafwi nukwa xéndéka réka ye di hiya. ");
INSERT INTO wos_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Wit sék nawulak di rami wara téndénmbu xakri. Xakre rendaka rami wara wura dé yakétéfindéka di hiya. ");
INSERT INTO wos_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Wit sék nawulak di yikafre héfambu xakri. Xakre wumbu re di jémba takélaka waré. Wara di yikafre sék xaké. Nawulak di nawulak sék xaké (30). Nawulak di séfélak sék xaké (60). Nawulak di séfélak séfélak sék xaké (100).” ");
INSERT INTO wos_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Wungi wataka dé Jisas wa, “Guni xékélakinjoka mawuli yata waan take jémba xékétanguni.” ");
INSERT INTO wos_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Wun hundi wandéka Jisasna du déka yae di wa, “Métaka méni diré sataku hundi wa? Méni diré sataku hundi wamét, di ména hundi jémba xékénjoka di hurufatiké.” ");
INSERT INTO wos_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Wungi wandaka dé diré wa, “Hanja God dé néma du reta du takwaka jémba hatitendékaka dé hundi faku. Fakutaka némbuli dé guni wun hundi xékéngute dé yawundu na. Nawulak du wun hundi xékéndate God yawundu nahambandé. ");
INSERT INTO wos_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Yikafre mawuli yakwa du takwa wuna hundi di xéké. Wuna hundi jémba xékékwa du takwa hukémbu Godna atéfék hundika jémba xékélakitandi. Wuna hundi jémba xékéhafi yakwa du takwa di wa, ‘Nani Godna hundi wundé xékélakikwa.’ Wungi wataka hukémbu Godna hundika yike yata baka retandi. ");
INSERT INTO wos_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Wun du takwa dama xe di xéndan jooka xékélakihambandi. Wun du takwa waan xéka di xékéndan hundika xékélakihambandi. Xékélakihafi yandaka wuni diré sataku hundi wa. ");
INSERT INTO wos_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Dika Godna profet Aisaia hanja Godna nyingambu hayindén hundi némbuli mwi hundi dé ya. God wandéka Aisaia du takwaka déka hundi angi dé hayi: Guni wuna hundi xéka xéka wun hundika yamba xékélakikénguni. Xe xe jémba yamba xékénguni. ");
INSERT INTO wos_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Wungi wataka God dé Aisaiaré wa: Wun du takwa wuna hundika xékélakinjoka hélék yandaka deka mawuli haraki dé té. Deka waan di géféti. Deka dama di hunyi. Deka dama hunyihafi yata di jémba xétandi. Deka waan géfétihafi yata di jémba xékétandi. Wungi xéta wungi xékéta di deka mawulimbu wuna hundi jémba xékélakitandi. Xékélakita di wunika wambula yatandi. Yandat diré huréhalékétawuni. Wungi Aisaia dé hayi, God nyingambu.” ");
INSERT INTO wos_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Wungi wataka Jisas dé déka duré wa, “Guna mawuli deka mawuli maki yingafwe. God guniré dé yikafre huru. Hurundéka guna mawuli yikafre dé ya. Yandéka guni jémba xéta, jémba xékéta, jémba guni xékélaki. ");
INSERT INTO wos_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Ané hundi mé xéké. Godna profet séfélak, Godna du takwa séfélak akwi, hanja reta di yawuka xéngun jémbaré xénjoka némafwimbu mawuli yata di xéhambandi. Di wawuka xékéngun hundi xékénjoka némafwimbu mawuli yata di xékéhambandi. Mwi hundi wuni guniré we.” Wungi dé Jisas wa. ");
INSERT INTO wos_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","Wun hundi wataka dé Jisas angi wa, “Wit sék yawulalama yakikwa duka wawun sataku hundina mo hundika wawut, guni mé xéké. ");
INSERT INTO wos_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","God néma du reta du takwaka jémba hatitendéka hundi, wun hundi du takwa nawulak baka di xéké. Xéka di wun hundika xékélakihambandi. Wunde du takwa di yambumbu xakrindé wit sék maki di. Di tale wun hundi di jémba xéké. Xékéndaka Satan yae dé wun hundi hérae hura yi. Yindéka di wun hundika yike di ye. ");
INSERT INTO wos_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Motu wali rendé héfambu xakrindé wit sék di ande du takwa di. Di wun hundi di bari xéké. Xéka di tale wun hundika yikafre mawuli yata mawuli sawuli di ya. ");
INSERT INTO wos_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Yata di jémba sarékéhambandi. Wun hundi deka mawulimbu naande téhafi yandéka di jémba sarékéhambandi. Sarékéhafi yandaka di nawula du Godna hundika hélék yata diré haraki hurundaka xakéngali nawulak dika yandéka di Godna hundi bari yataka. ");
INSERT INTO wos_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Rami warambu xakrindé wit sék di ande du takwa di. Di Godna hundi tale di jémba xéké. Xéka di ané héfana jonduka male sarékéndaka deka mawuli yéwa héranjoka dé géné. Wun jondu dé Godna hundiré takatéfi. Takatéfindéka di wunde du takwa Godna jémba yahambandi. ");
INSERT INTO wos_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Yikafre héfambu xakrindé wit sék di ande du takwa di. Di Godna hundi jémba xéka, wandén maki huruta, di déka hundika jémba xékélaki. Xékélakita di déka yikafre jémba ya. Nawulak di déka nawulak yikafre jémba yandaka, nawulak di déka séfélak yikafre jémba yandaka, nawulak di déka séfélak séfélak yikafre jémba di ya.” Wungi dé Jisas diré wa. ");
INSERT INTO wos_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Wun hundi wataka dé Jisas sataku hundi nak akwi angi wa, “God néma du reta du takwaka jémba hatitendéka angi dé. Du nak déka yawimbu yikafre wit sék dé yawulalama yaki. ");
INSERT INTO wos_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Yawulalama yakindéka du takwa gan xéndi hwandaka dé wun duna mama yae haraki wara sék yikafre wit sékna nyéndékmbu yawulalama yakitaka dé yi. ");
INSERT INTO wos_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Yindéka hukémbu wit sék takélaka wara sék xakénjoka yandéka di xé haraki wara wun wit wali téndéka. ");
INSERT INTO wos_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Xétaka di jémba yakwa du ye di wun yawina yafaré wa, ‘Néma du, hanja méni yikafre wit sék méni yawulalama yaki. Yingi maki ye wun haraki wara dé waré?’ ");
INSERT INTO wos_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Wungi wandaka dé diré wa, ‘Nana mama nak yae dé wun waranji yaki.’ Wungi wandéka di jémba yakwa du déré wa, ‘Méni mawuli méni ye nani haraki wara félémbete?’ ");
INSERT INTO wos_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Wungi wandaka dé diré wa, ‘Yingafwe. Haraki wara féléta wafewana yikafre wit wali nawulak félétanguni? Haraki wara félékénguni. Baka tékwandé. ");
INSERT INTO wos_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Yikafre wit haraki wara wali yituku warékwambér. Wara sék xakémbét wuni sék xatékékwa duré angi watawuni, Tale guni wun haraki wararé féla guni hatambu gitanguni. Gitaka yambu tutanguni. Tutaka guni wit sék xatéka faata hari wuna handi gembu husola takatanguni. Wungi watawuni wit sék xatékékwa duré.’ Wungi dé yawina yafa wa.” ");
INSERT INTO wos_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","32","Wun hundi wataka dé Jisas hundi nak akwi angi dé wa, “God néma du reta du takwaka jémba hatitendéka, wu miyar sék maki dé. Wun misék wu yikama sék male dé. Nana héfambu tékwa mina sék wu némafwi di. Du nak wun miyar sék hérae dé déka héfambu takandét dé bari hari wara némafwi ye dé wun héfambu tékwa miré sarékéngwandétandé. Némafwi mi téndéka di afwi yae di wun mi galimbu wur yatitaka di re.” ");
INSERT INTO wos_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Wun hundi wataka dé nak hundi angi wa, “God néma du reta du takwaka jémba hatitendéka wu yis maki dé. Takwa hési wun yis hérae flawa wali lé hanjaméneké. Hanjaménekéléka dé wun flawa atéfék dé wula waré.” Wungi dé Jisas diré wa. ");
INSERT INTO wos_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Jisas séfélak sataku hundi dé du takwaré wa. Diré wafuke wahambandé. Sataku hundimbu male dé diré wa. ");
INSERT INTO wos_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Diré sataku hundi wungi wandéka Godna profet nak déka hundi mwi hundi dé ya. Wun du hanja Jisaska angi dé Godna nyingambu hayi: Wuni sataku hundi diré watawuni. Hanja God héfa huratakandén nukwambu déka hundi nawulak dé faku. Fakundéka rendé hundika némbuli wuni watawuni. ");
INSERT INTO wos_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Jisas déka hérangwanda téndé du takwaré yatakataka dé ge nakré wulayi. Wulayindéka déka du déka wulaaye di déré wa, “Wun haraki waraka méni sataku hundi wa. Némbuli wun jooka méni wamét nani jémba xékélakitame.” ");
INSERT INTO wos_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Wungi wandaka dé Jisas diré wa, “Yikafre wit sék yawulalama yakindé du wu wuni wuni. Wuni Duna Nyan wuni. ");
INSERT INTO wos_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Wun héfa wu héfambu tékwa atéfék getéfa dé. Yikafre wit sék wu Godna hémémbu xalendé du takwa di. Haraki wara wun Satanéna du takwa di. ");
INSERT INTO wos_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Haraki wara yawulalama yakindé du dé Satan dé. Wit sék xatékétendaka nukwa dé hukémbu yatewuka nukwa dé, ané héfana hukétéfi nukwa dé. Wit sék xatékékwa du di ensel di. ");
INSERT INTO wos_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Haraki wara féla yambu tundan maki, hukémbu ané héfana hukétéfi nukwa, di haraki saraki sémbut hurukwa du takwaré wungi hurutandi. ");
INSERT INTO wos_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Wuni Duna Nyan wuni wawut, wuna ensel atéfék getéfaré ye Godna du takwa wali reta haraki saraki sémbut hurukwa du takwaré hératandi. Atéfék haraki saraki jondu, du takwana mawuliré haraki hurukwa atéfék jondu akwi hératandi. ");
INSERT INTO wos_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Hérae di wun du takwaré akwi, wun haraki saraki jonduré akwi némafwi yambu yakisandatandi. Yakisandandat haraki saraki sémbut hurundé du takwa wun yambu yanéta di némafwi hangéli hératandi. Héraata di némafwimbu géraata di némbi titandi. ");
INSERT INTO wos_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Wun nukwa Godna du takwa di dé wali retandi, déka getéfambu. Reta di nukwa hanyikwa maki retandi. Guni xékélakinjoka mawuli yata waan take jémba xékétanguni.” Wungi dé Jisas déka duré wa. ");
INSERT INTO wos_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Wun hundi wataka dé angi wa, “God néma du reta du takwaka hatitendéka angi dé. Du nak ye yawi nakmbu dé xé, séfélak yéwa fakundaka rendéka. Xétaka dé yikafre mawuli ye dé wun yéwa wambula fakutaka ye déka jondu atéfék hwetaka yéwa hérae wun yéwa hwetaka séfélak yéwa xéndén yawi dé héra.” ");
INSERT INTO wos_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","Wun hundi wataka dé Jisas angi wa, “God néma du reta du takwaka hatitendéka angi dé. Du nak déka jémba yata warandaka yéwaséka dé hwaké. ");
INSERT INTO wos_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Hwaka yikafre yikafre yéwaséka xétaka wun yéwasé héranjoka dé déka jondu atéfék hwetaka dé séfélak yéwa héra. Hérae wun yéwa atéfék hwetaka dé wun yikafre yéwasé héra.” ");
INSERT INTO wos_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","Wun hundi wataka dé Jisas nak hundi angi wa, “God néma du reta du takwaka hatitendéka angi dé. Du nak mara tukwesekembu husandandéka hwandéka di nak maki nak maki xéri hamwi wulayi. ");
INSERT INTO wos_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Wulayindaka mara sukwekéndéka di tufwaré témbéra hura wari. Hura wara di reta xéri hamwi xarémoni. Xarémone di yikafre xéri hamwi hérae akimbu lakwa. Lakwataka di haraki xéri hamwi yaki. ");
INSERT INTO wos_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","50","Hukémbu ané héfana hukétéfi nukwa God wandét déka ensel wungi hurutandi. Di gaye Godna du takwa wali reta haraki saraki sémbut hurundé du takwaré hérae némafwi yambu yakisandatandi. Yakisandandat haraki sémbut hurundé du takwa wun yambu yanéta némafwi hangéli hératandi. Héraata di némafwimbu géraata di némbi titandi.” ");
INSERT INTO wos_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Wun hundi wataka Jisas dé diré wakwexéké, “Guni wun hundika atéfék jémba guni xékélaki?” Wungi wakwexékéndéka di wa, “Xéxé. Nani xékélaki.” ");
INSERT INTO wos_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Wungi wandaka dé diré wa, “Godna hambuk hundi xékélakikwa du di God néma du reta du takwaka jémba hatitendékaka hundi xéka di gena yafa maki retandi. Gena yafa dé déka geré wulaaye hanja takandén yikafre jondu akwi huli yikafre jondu akwi dé hura ya. Hura yandéka maki, dé déka mawulimbu xékéta hanja xékéndén hundi, God du takwaka jémba hatitendéka huli hundi akwi di wa.” ");
INSERT INTO wos_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Wun hundi wataka dé Jisas wun getéfa yatakataka dé yi. ");
INSERT INTO wos_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Ye déka motéfambu xaakwa dé du takwaré Godna jémbaka wakwe, Godna hundi buléndaka gembu. Wakwendéka di waréngéna di wa, “Owa. Yingi maki dé wun jonduka xékélaki? Yingi maki ye dé hanja xéhafi yamben hambuk jémba ya? ");
INSERT INTO wos_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Dé ge tokwa duna nyan dé. Déka ayiwa wu Maria lé. Déka bandingu wu Jems, Josep, Saimon, Judas di. ");
INSERT INTO wos_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Déka nyangengu atéfék nani wali di re. Dé néma du yingafwe. Wu yalefu nyan dé. Wungi nani xékélaki. Yimbu dé wun hundi héra?” ");
INSERT INTO wos_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Wungi wataka déka hambukéka xékélakihafi yata di déka hélék ya. Hélék yandaka dé Jisas diré wa, “Profetka di nak téfana du takwa wa, ‘Wu néma du dé. Dé yikafre jémba dé ya.’ Wungi wandaka déka hém déka motéfambu rekwa du takwa akwi di déka wa, ‘Wu baka du dé. Nani maki du dé.’ Wungi di wa.” ");
INSERT INTO wos_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Wungi wataka di déka jémba sarékéhafi yandaka dé Jisas hanja xéhafi yandan séfélak hambuk jémba déka motéfambu huruhambandé. ");
INSERT INTO wos_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Wun nukwa Galilina héfambu rekwa du takwa deka néma du déka xi Herot Jisaska hundi wandaka dé xéké. ");
INSERT INTO wos_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Xékéta dé déka jémba yakwa duré wa, “Wun du dé guré husandakwa du Jon dé. Hanja wuni wawuka di déka humbu xatéké. Xatékéndaka hiyae némbuli wambula dé ramé. Raama dé néma hambuk hérae wun hambuk jémba dé ya.” Wungi dé Herot wa. ");
INSERT INTO wos_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","4","Hanja Jon hiyahafi yandén nukwambu Herot dé déka nyama Filipna takwaré héra. Wule takwana xi Herodias lé. Hérandéka dé Jon déré wa, “Ména nyama rendéka déka takwaré héramén, wu haraki méni huru. God wun jooka dé haraki hundi wa.” Wungi wandéka Herodias Jonéna hundika hélék yata waléka Herot léka hundi xékéta wandéka di déka du ye Jonré huluke yoombu giya séndé geré di hari. ");
INSERT INTO wos_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Harindaka séndé gembu hwandéka Herot déré xiyanjoka mawuli dé ya. Judana du takwa di wa, “Jon dé profet dé.” Wungi wandaka Herot dé Jonré xiyanjoka dé roo. ");
INSERT INTO wos_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Nak nukwa di du nawulak yae Herot wali hérangwanda reta Herotna ayiwa déré héralén nukwaka sarékéta di hénoo sa. Sandaka Herodiasna takwanya yae wun duna makambu téta lé hétihiya. Hétihiyaléka Herot xéta dé némafwimbu mawuli ya. ");
INSERT INTO wos_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Yata dé léré wa, “Nyéni nak jooka mawuli yata wanyét, wuni wun joo hwetawuni. Wawun maki hurutawuni. Mwi hundi wuni we.” ");
INSERT INTO wos_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Wungi wandéka ye lé léka ayiwaré wun jooka wakwexékéléka lé léka ayiwa waléka lé wambula yi, Herotka. Ye lé léka ayiwa walén maki lé Herotka wa, “Guré husandakwa du Jonéna humbu xatéka andémbu takataka méni wunika hwetaméni.” ");
INSERT INTO wos_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Wungi waléka dé Herot wungi yanjoka hélék yata dé saréké waréké, mwi hundi wandéka dé wali reta hénoo sandé du di xékéndanka. Sarékéta, nak maki hundi wanjoka hélék yata dé wa, ‘Yawundu.’ ");
INSERT INTO wos_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Yawundu nataka dé wandéka déka du ye séndé geré wulaaye di Jonéna humbu xatéké. ");
INSERT INTO wos_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Xatéka humbu andémbu take di wule takwaka hura yi. Hura yindaka lé léka ayiwaka hwe. ");
INSERT INTO wos_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Wungi hurundaka Jonéna du yae déka fusa hérae hura ye di rémé. Rémétaka ye di Jisasré wun jooka safé. ");
INSERT INTO wos_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Jisas wun hundi xékétaka dé wun getéfa yatakataka gunjambémbu wara dé du rehafi hafwaré yi. Dé hafu dé yi, gunjambémbu. Yindéka du takwa déka hundi xékétaka deka getéfa yatakataka di héfambu dé yindénré di yi. ");
INSERT INTO wos_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Yindaka Jisas tukweseke tufwaré yae gunjambé yatakataka dé xé, séfélak du takwaka. Xéta dika saréfa naata dé bar hiyandé du takwa nyangwal, séfimali haraki yandé du takwa nyangwalré akwi dé huréhaléké. ");
INSERT INTO wos_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Gérambu yandéka di Jisasna du déka yae di déré wa, “Ané gérambu dé. Ané du rehafi hafwa dé. Méni wamét ané du takwa di getéfaré yitandi. Ye di deka hénoo hératandi.” ");
INSERT INTO wos_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Wungi wandaka dé diré wa, “Di yindate wuni yamba wakéwuni. Guni dika hénoo hwetanguni.” ");
INSERT INTO wos_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Wungi wandéka di wa, “Nani séfélak hénoo yingafwe. Yikama bret natamba xéri hamwi yéték wungi male dé re.” ");
INSERT INTO wos_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Wungi wandaka dé wa, “Mé hura ya wunika.” ");
INSERT INTO wos_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Wungi wandéka hura yandaka dé wumbu téndé du takwaré wa, wara takumbu rendate. Wandéka rendaka dé yikama bret natamba xéri hamwi yéték hérae hura téta nyirré yasawara xéta dé Godka diména na. Diména nataka bret fukae dé déka duka hwe. Hwendéka di du takwaka mune hwe. ");
INSERT INTO wos_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Mune hwendaka di atéfék du takwa jémba hura sa. Sandaka bret nawulak rendéka di Jisasna du di wasara tamba atéfék ye man yéték (12) wungi di lakwa sukweké. ");
INSERT INTO wos_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Wun hénoo sandé du séfélak di (5,000). Séfélak takwa nyangwal akwi wumbu di reta sa. ");
INSERT INTO wos_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Jisasna du wungi hurundaka Jisas dé diré wa, “Guni gunjambéré wara guni tale yitanguni, tukweseke angé sakuré.” Wungi wandéka déka du yindaka dé wun du takwaré wa, deka getéfaré yindate. ");
INSERT INTO wos_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Wandéka yindaka God wali hundi bulénjoka dé hafu dé némburé wari. Warindéka nukwa naande yindéka dé hafu dé re némbumbu. ");
INSERT INTO wos_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Rendéka déka du rendé gunjambé ye lé tukweseke nyéndékmbu téléka yinjoka mawuli yandan sakumbu mur yandéka lé gunjambé hambukmbu lé waréngaya. ");
INSERT INTO wos_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Wara gayaléka ye xitélakénjoka yandéka dé Jisas gu takumbu déka duka féta yi. ");
INSERT INTO wos_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Yindéka di déré xéta waréngéné. Waréngéna di wa, “Wu gamba nak dé ya.” Wungi wata némafwimbu roota di hambukmbu wanji. ");
INSERT INTO wos_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Wanjindaka dé Jisas diré bari wa, “Ané wuni wuni ya. Guni rookénguni. Yikafre mawuli yatanguni.” Wungi dé diré wa. ");
INSERT INTO wos_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Wun hundi wandéka dé Pita Jisaska wa, “Néma Du, wu méni xe méni wuniré wamét, wuni gu takumbu ménika yatawuni.” ");
INSERT INTO wos_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Wungi wandéka dé wa, “Méni mé ya.” Wungi wandéka dé gunjambé yatakataka naande ye dé gu takumbu tale féta yita dé Jisas téndénré yinjoka mawuli ya. ");
INSERT INTO wos_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Mawuli yandéka mur hurundéka gu raméndéka xéta dé roo. Roota dé gumbu naande yinjoka yi. Yita hambukmbu dé wa, “Néma Du, wuniré mé huru.” ");
INSERT INTO wos_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Wungi wandéka dé déré bari huruta dé wa, “Métaka méni wuna hambukéka méni sarékéhafi ye? Wunika mé jémba saréké.” ");
INSERT INTO wos_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Wungi wataka déré hura ye gunjambéré warémbéka dé mur fakéna. ");
INSERT INTO wos_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Fakénandéka gunjambémbu rendé du di déka ximbu harékéta di wa, “Méni Godna nyan méni. Wu mwi hundi dé.” Wungi di wa. ");
INSERT INTO wos_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Jisas déka du wali tukweseke angé sakuré gunjambémbu ye di Genesaretna héfa xaku. ");
INSERT INTO wos_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Xakundaka di wun getéfambu rekwa du takwa Jisaska xékélaki. Xékélakita wun héfambu rekwa du takwaré hundi wa saafa yindaka di bar hiyandé du takwa nyangwal akwi, séfimali haraki yandé du takwa nyangwal akwi, diré di hura yi Jisaska. ");
INSERT INTO wos_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Hura yita di Jisaska wa, “Méni yawundu namét, nani ména nukwa wurna wambumbu male séngétakatame.” Wungi wandaka dé yawundu nandéka di déka nukwa wurna wambumbu séngétakata di yikafre ya. ");
INSERT INTO wos_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Wun nukwa di Farisi nawulak, xékélelakikwa du nawulak, wungi di Jerusalem yatakataka Jisas wali hundi bulénjoka di yi. ");
INSERT INTO wos_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","Ye di déré wa, “Nana mandéka wungi di wa, ‘Hénoo sawu nae tale wamben maki guna tamba jémba yakwanyitanguni. Wungi yakwanyitaka guni Godna makambu jémba retanguni.’ Wungi wandaka nani hénoo sawu nae tale nani nana tamba wandan maki jémba yakwanyi. Métaka di ména du nana mandéka wandan hundi xékéhafi ye? Di sawu nae tale deka tamba nana mandéka wandan maki jémba yakwanyihafindi.” ");
INSERT INTO wos_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Wungi wandaka dé diré wa, “Guni yingi maki guni? Métaka guni guna mandékana hundi male xékéta guni Godna hundika hu hwe? ");
INSERT INTO wos_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","God angi dé wa, ‘Guni guna yafa ayiwaré yikafre hurutanguni.’ Wungi wataka angi akwi dé wa, ‘Du nak déka yafa ayiwaka haraki hundi wandét, guni wun duré xiyangut dé hiyatandé.’ ");
INSERT INTO wos_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Wungi wandéka guni Godna hundika hu hweta nak hundi guni wa. Guni angi guni wa, ‘Du nak déka yafa ayiwaré angi wandét, Wuna atéfék jondu Godka hwenjoka wuni waséke. Godka hwehafi yata bénika yamba hwekéwuni. Béniré yikafre hurunjoka wuni hurufatiké. ");
INSERT INTO wos_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Wungi wata dé déka yafa ayiwaré yikafre yamba hurukéndé, Godka hwenjoka wasékendénka.’ Guni wungi wata guna mandékana hundi xékéta guni Godna hundika hu hwe. ");
INSERT INTO wos_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Guni yéna yakwa du guni. Hanja Godna profet Aisaia ané hundi wata dé mwi hundi wa gunika. Angi dé wa: ");
INSERT INTO wos_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","God dé wa, ‘Ané du takwa di wunika yikafre hundi wa. Wungi wata di wunika deka mawulimbu jémba sarékéhambandi. ");
INSERT INTO wos_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Di du wandan hambuk hundi xékéta wandan maki huruta di wun hundika wa: Wu Godna hundi dé. Wungi wata wuna ximbu baka di haréké.’ Wungi God wandéka Aisaia dé hayi.” ");
INSERT INTO wos_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Wun hundi wataka Jisas dé du takwaka wandéka yandaka dé diré angi wa, “Guni wuna hundi mé jémba xéké. Xékéta ané jooka jémba xékélakitanguni. ");
INSERT INTO wos_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Duna hundiré wulayikwa jondu déka mawuliré haraki yamba hurukéndé. Duna hundimbu gwandekwa jondu wun duna mawuliré haraki hurutandé, dé Godna makambu haraki sémbut hurukwa du rendéte.” ");
INSERT INTO wos_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Wungi wandéka déka du déka yae di wa, “Farisi di wamén hundika hélék di ye.” ");
INSERT INTO wos_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Wungi wandaka dé Jisas ané sataku hundi wa, “Anwarmbu rekwa du wuna yafa dé némafwi yawi nak huru. Séfélak mi dé se wun yawimbu. Sehafi yandéka hafu waréndé mi dé méngi wali félétandé.” ");
INSERT INTO wos_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Wataka dé angi wa, “Guni Farisika sarékékénguni. Di dama hiyandé du maki di. Dama hiyandé du nak dé nak dama hiyandé duré yambu wakwenandét, bér ye yituku wekwaré nanditambér. Yimbén maki Farisi nak duré Godka yindaka yambu wakwenjoka di hurufatiké.” Wungi dé wa. ");
INSERT INTO wos_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Wandéka dé Pita déré wa, “Hundiré wulayikwa jonduka wamén sataku hundika naniré wamét, nani wun hundika jémba xékélakitame.” ");
INSERT INTO wos_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Wungi wandéka dé wa, “Guni akwi wun hundika xékélakihambanguni, o yingi maki dé? ");
INSERT INTO wos_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Mé xéké. Du takwa sandaka jondu deka biyaré naande ye di takuré dé yi. Sandaka jondu deka mawuliré haraki yamba hurukéndé. ");
INSERT INTO wos_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Watendaka hundi tale du takwana mawulimbu dé té. Du takwana mawulimbu xalekwa jonduka sarékéta God watandé, ‘Wu haraki saraki sémbut hurukwa du takwa di.’ Wungi watandé, wun jooka. ");
INSERT INTO wos_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Du takwana mawulimbu haraki saraki mawuli dé xale. Xalendéka di haraki saraki mawuli xékéta di du takwaré xiyaata, du nak nak duna takwa wali dé haraki sémbut huruta, takwa hési hési takwana du wali lé haraki sémbut huruta, du wali takwa wali haraki sémbut di huruta, sélé héraata, yénataka hundi wata, nak du takwaka haraki hundi wata, wungi di haraki saraki sémbut huru. ");
INSERT INTO wos_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Wun haraki saraki sémbut hurundaka God dé dika wa, ‘Wu haraki saraki sémbut hurukwa du takwa di.’ Wungi wata dé God xékéndan haraki saraki mawulika dé saréké. Du takwa di mandékana hundi xékéhafi yata deka tamba jémba yakwanyihafi yandat, God deka sémbutka “haraki sémbut dé” yamba nakéndé.” Wungi dé Jisas wa. ");
INSERT INTO wos_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Wun hundi wataka dé Jisas déka du wali wungi di wun getéfa yatakataka di nak hafwaré yi. Tair Saidonéna hafwaré di yi. ");
INSERT INTO wos_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Yindaka lé Kenanmbu yalé takwa hési lé ya. Lé Judana takwa rehafi yata nak téfambu yalé takwa re lé Jisaska ya. Yae lé hambukmbu wakwexéka lé wa, “Néma Du, méni Devitna mandéka méni re. Méni wunika mé saréfa na. Haraki hamwinya nak wuna takwanyana mawulimbu wulaaye téta léré dé haraki huru.” ");
INSERT INTO wos_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Wungi waléka dé Jisas hundi nak wahambandé. Wahafi yandéka déka du di déré wa, “Wule takwa nana hukémbu yata hambukmbu lé we. Méni wamét lé léka geré wambula yilé.” ");
INSERT INTO wos_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Wungi wandaka dé wule takwaré wa, “God wandéka wuni Israelna fakundé sipsip baliré male héranjoka wuni ya. Nyéni nak téfana takwa nyéni. Israelna takwa yingafwe.” ");
INSERT INTO wos_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Wungi wandéka lé yae déka hwati se wandé dae lé wa, “Néma Du, wuniré yikafre hurutaméni.” ");
INSERT INTO wos_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Wungi waléka dé léré wa, “Nani nyangwalna hénoo hérae yikama wasaka hwembet, wu haraki dé.” ");
INSERT INTO wos_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Wungi wandéka lé wa, “Néma Du, wu mwi hundi méni wa. Wuni angi wuni we. Nyangwal hénoo sandaka nawulak héfambu xakrindéka di deka wasa hérae sa. Méni wuniré yikafre hurumét, wu yikafre dé.” ");
INSERT INTO wos_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Wungi waléka dé wa, “Wuni nyéna takwanyaré yikafre hurutewuka hambukéka wata nyéni wunika nyéni jémba male saréké. Wu yikafre dé. Nyéni mawuli yanyékangalambu hurutawuni.” Wungi wandén nukwa lé léka takwanya yikafre ya. ");
INSERT INTO wos_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Jisas wun getéfa yatakataka dé Galilina tukweseke tufwambu dé yi. Ye dé némbu nakmbu wara dé re. ");
INSERT INTO wos_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Rendéka di séfélak du takwa déka ya. Man haraki yandé du takwa nyangwal, dama hiyandé du takwa nyangwal, afa angwa yandé du takwa nyangwal, hundi buléhafi yandé du takwa nyangwal, séfimali haraki yandé séfélak du takwa nyangwal akwi, wun du takwa nyangwalré atéfék hérae yate di Jisaska hura ya. Yae di wun du takwa nyangwalré Jisasna man mombu taka. Takandaka dé diré huréhaléké. ");
INSERT INTO wos_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Huréhalékéndéka di wumbu rendé du takwa di xé. Hundi buléhafi yandé du takwa nyangwal di hundi bulé. Afa angwa yandé du takwa nyangwal deka afa huritékéndéka di jémba té. Man haraki yandé du takwa nyangwal di yitaka yataka. Dama hiyandé du takwa nyangwal di xé. Di wungi yikafre yandaka xe di saréké waréké. Sarékéta di Israelna Godna ximbu haréké. ");
INSERT INTO wos_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Séfélak du takwa wumbu téndaka Jisas déka duré wandéka yandaka dé diré wa, “Wuni wunde du takwaka wuni saréfa nae. Nukwa hufuk di wuni wali re. Deka hénoo bu hényi. Di hénoo wali di re. Di hénoo wali re deka getéfaré yindate wanjoka hélék wuni ye. Hénoo wali ye yambumbu hiyatandi.” ");
INSERT INTO wos_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Wungi wandéka di déka du wa, “Ané hafwa du rehafi hafwa dé. Wunde du takwa séfélak di. Yimbu bret nawulak hérae wunde du takwaka hwembet satandi?” ");
INSERT INTO wos_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Wungi wandaka dé diré wa, “Bret hatika dé re?” Wungi wandéka di wa, “Yikama bret angé yétiyéti angé hufuk di, yikama xéri hamwi nawulak akwi dé re.” ");
INSERT INTO wos_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Wungi wandaka dé wun du takwaka wa, héfambu rendate. ");
INSERT INTO wos_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Wandéka rendaka dé wun yikama bret xéri hamwi akwi hérae dé Godka diména na. Diména nataka wun bret akwi xéri hamwi akwi fukae dé déka duka hwe. Hwendéka di atéfék du takwaka hwe. ");
INSERT INTO wos_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Hwendaka di atéfék jémba hura sa. Sandaka hénoo nawulak rendéka di wasara angé yétiyéti angé hufuk wungi di lakwa sukweké. ");
INSERT INTO wos_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Wun hénoo sandé du séfélak séfélak di (4,000). Séfélak takwa nyangwal akwi di wumbu reta sa. ");
INSERT INTO wos_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Di atéfék wungi sasékendaka dé Jisas du takwaka wandéka di deka getéfaré yi. Yindaka dé gunjambé nakmbu wara dé Magadanéna héfaré yi. ");
INSERT INTO wos_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Farisi nawulak akwi Sadyusi nawulak akwi wungi di yi Jisaska. Ye di déré hurukwexénjoka di déré wa, “Méni hanja xéhafi yamben hambuk jémba nak yamét, nani xétame. Wungi xéta nani xékélakitame. God wandéka méni ya.” ");
INSERT INTO wos_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Wungi wandaka dé diré wa, “Gérambu yandéka nukwa naande yindéka nyirmbu waka hwandéka xéta guni wa, ‘Nyirmbu waka dé hwae. Hwandéka séri yikafre nukwa xétandé.’ ");
INSERT INTO wos_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Wungi wataka guni ganémbambu nyirmbu géli waréndéka xéta guni wa, ‘Nyirmbu géli dé waré. Waréndéka némbuli wali giyatandé.’ Wungi guni wa. Guni nyirré xéta guni xékélaki, nukwaka akwi, walika akwi. Métaka guni wuna huruwun jonduka xékélakihafi ye? Guna mawuli yike dé ye. ");
INSERT INTO wos_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Ané nukwambu rekwa du takwa di haraki saraki sémbut huruta di Godka hu wundé hwenda. Hu hweta di hanja xéhafi yandan hambuk jémba xénjoka di mawuli ya. Mawuli yata di hanja xéhafi yandan jémba nak male xétandi. Di hanja rendé du Jona hurundén maki joo male xétandi.” Wungi wataka dé Jisas diré yatakataka dé yi. ");
INSERT INTO wos_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Jisas déka du wali di tukweseke angé sakuré yi. Ye xaakwa déka du di wa, “Nani bret hurehambame. Yike nani ya.” ");
INSERT INTO wos_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Wungi wandaka Jisas dé diré ané sataku hundi wa, “Guni xékélaki natanguni. Farisi Sadyusi akwi deka yis yamba hurukénguni.” ");
INSERT INTO wos_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Wungi wandéka di di hafu buléta di wa, “Nani bret nawulak hurehambame. Wungi hurehafi yambeka dé bret némafwi yandéte takandaka joo yiska dé wa.” ");
INSERT INTO wos_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Wungi buléndaka dé xékélakita dé wa, “Métaka guni angi wa? ‘Nani bret yingafwe.’ Wuni guniré yikafre hurutewuka hambukéka jémba sarékéhambanguni. ");
INSERT INTO wos_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Guni wuna hambukéka jémba xékélakihambanguni. Hanja séfélak séfélak (5,000) duka yikama bret natamba hwewuka jémba hura sandaka bret nawulak rendéka séfélak wasara lakwangunka guni saréké wana? ");
INSERT INTO wos_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Nak nukwa séfélak séfélak (4,000) duka yikama bret angé yétiyéti angé hufuk hwewuka bret nawulak rendéka séfélak wasara lakwangunka guni saréké wana? Wu yingafwe. ");
INSERT INTO wos_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Jémba sarékéta xékélakitanguni. Wuni bret séfélak xakundéte wuni hambuk ye. Yata wuni yiska wata wuni bretka sarékéhambawuni. Farisi Sadyusi deka yiska xékélaki natanguni.” ");
INSERT INTO wos_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Wungi wandéka di xékélaki. Dé bretmbu takandaka yiska wahambandé. Dé Farisina Sadyusina haraki hundika dé wa. ");
INSERT INTO wos_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Jisas déka du wali di Sisaria Filipaina héfaré yi. Ye dé Jisas déka duré wa, “Wuni Duna Nyan wuni re. Wunika du takwa yingi di we?” ");
INSERT INTO wos_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Wungi wandéka di wa, “Ménika nawulak di wa, ‘Dé guré husandakwa du Jon dé.’ Nawulak di wa, ‘Dé hanja rendé Godna profet Elaija dé.’ Nawulak di wa, ‘Dé Godna profet déka xi Jeremaia dé.’ Nawulak di wa, ‘Jeremaia yingafwe. Godna profet nak dé.’ Wungi di ménika we.” ");
INSERT INTO wos_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Wungi wandaka dé diré wa, “Guni wunika yingi guni we?” ");
INSERT INTO wos_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Wungi wandéka dé Saimon Pita wa, “Méni naniré yikafre huruméte God wasékendén du Krais méni. Méni wungi re wungi re rekwa Godna nyan méni.” ");
INSERT INTO wos_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Wungi wandéka dé wa, “Jonana nyan Saimon, méni yikafre mawuli méni ye. Ané héfambu rekwa du wunika wamén hundi méniré wahambandi. Anwarmbu rekwa du wuna yafa God dé hafu dé méniré wun hundi wa. ");
INSERT INTO wos_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Ané wuni méniré wuni we. Ména xi Pita dé. Nana hundina mo hundi angi dé: Yikama motu dé. Wun némafwi motu takumbu wuna hundika xékékwa du takwaré takatawuni. Takawut Satanéna hambuk diré yamba yasandakéndé. Di jémba retandi, wungi re wungi re. ");
INSERT INTO wos_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Wuni ménika yambu nafwi joo hwetawuni. Hwewut méni Godna getéfana yambu nafwimét nawulak du takwa Godna hémémbu wulayitandi. Méni ané héfambu téta nak jooka gimét, God déka getéfambu reta wun jooka akwi gitandé. Méni ané héfambu téta, nak jooka yatakamét, God déka getéfambu reta, wun jooka akwi yatakatandé.” ");
INSERT INTO wos_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Wungi wataka dé déka duré wa, “Mé xéké. Guni nak duré angi wakénguni, ‘Jisas dé naniré yikafre hurundéte God wasékendén du Krais dé.’ Wungi wakénguni.” Wungi dé Jisas wa. ");
INSERT INTO wos_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Wun nukwa dé Jisas tale ané hundi dé déka duré wa, “Wuni Jerusalemré wariwut, di getéfana néma du, prisna néma du, xékélelakikwa du, di wuniré haraki hurutandi. Hura di wuniré xiyandat hiyatawuni. Hiyae nukwa hufuk yindét God wandét wuni wambula ramétawuni.” ");
INSERT INTO wos_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Wungi wandéka Pita déré hura ye bér hafu téta dé wa, “Néma Du, méni wungi wakéméni. God wun haraki saraki jooka yamba yawundu nakéndé.” ");
INSERT INTO wos_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Wungi wandéka dé waleka dé Pitaré wa, “Méni Satan, méni séléka! Méni wuna yambu méni takatéfi. Méni Godna hundi xékéhambaméni. Méni ané héfambu rekwa duna hundi male méni xéké.” Wungi dé Jisas Pitaré wa. ");
INSERT INTO wos_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Wun hundi wataka Jisas déka duré dé wa, “Guni wuni wali yaata wuna jémba yanjoka mawuli yata angi yatanguni. Guni guna mawuli yangukangala yatakatanguni. Yatakataka guni wunika sarékéta angi watanguni, ‘Nani déka jémba yatame. Yata nani hangéli héraata mimbu hiyambet, wu baka joo dé. Néma joo yingafwe.’ Wungi wata wuna jémba hurutanguni. ");
INSERT INTO wos_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Wunika sarékékwa du takwa wuna jémba yandat, wuna mama diré xiyandat di wuni wali jémba retandi, wungi re wungi re. Wunika sarékéhafi yakwa du takwa deka séfika male sarékéta deka jémba male yata di hiyae fakutandi. Wuni wali yamba rekéndi. ");
INSERT INTO wos_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Du takwa ané héfana jondu atéfék héranjoka sarékéta, deka jémba male yata, hiyae yingi maki di jémba retandi? Yingafwe. Jémba yamba rekéndi. Di Godna getéfaré yinjoka mawuli yata yéwa hwetandi, o yingi maki dé? Yingafwe. Di yamba yikéndi. ");
INSERT INTO wos_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Hukémbu wuna yafa God déka hambuk wunika hweta wandét wuni Duna Nyan nukwa maki haanye gayatawuni. Ensel wali gayatawuni. Gaye atéfék du takwa hurundan jondu hasa hwetawuni. ");
INSERT INTO wos_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Ané hundi mé xéké. Guni ambu tékwa du nawulak hiyahafi re xétanguni, wuni néma du reta hambuk yatewuka. Wuni Duna Nyan yawut xétanguni. Mwi hundi wuni guniré we.” Wungi dé Jisas déka duré wa. ");
INSERT INTO wos_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Nukwa gwongofu yindéka dé Jisas, Pita, Jems, Jemsna bandi Jonré wungi hura di némafwi némbu nakré wari. Wara di di hafu wumbu re. ");
INSERT INTO wos_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Re di xé, Jisasna séfi nak maki xakundéka. Xakundéka déka saawi nukwa maki dé hanyi. Hanyindéka déka nukwa wur wama male ya maki dé hanyi. ");
INSERT INTO wos_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Hanyindéka, owa, mé xé, hanja rendé Godna profet Moses bér Elaija Godna getéfambu gaye Jisas wali hundi buléta téndaka di Jisasna du hufuk xé. ");
INSERT INTO wos_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Pita diré xéta dé Jisasré wa, “Néma Du, nani ambu rembeka, wu yikafre dé. Méni mawuli yamét, wuni wama ge hufuk ambu totawuni. Ménika nak, Moseska nak, Elaijaka nak.” ");
INSERT INTO wos_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Pita wun hundi wata téndéka dé wama hanyikwa buwi nak gaye dé diré takatéfi. Takatéfindéka dé hundi nak buwikombu gwande dé wa, “Ané wuna nyan dé. Déka wuni némafwimbu mawuli ye. Déka wuna mawuli yikafre dé ye. Guni déka hundi male mé xéké.” ");
INSERT INTO wos_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Wun hundi xékétaka Jisasna du di némafwimbu roota xakre di héfambu hwa. ");
INSERT INTO wos_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Hwandaka dé Jisas dika yae diré huruta dé wa, “Guni sé ramé. Rookénguni.” ");
INSERT INTO wos_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Wungi wandéka raama nak duré xéhambandi. Jisasré male di xé. ");
INSERT INTO wos_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Di wun némbu yatakataka naande yita dé Jisas diré wa, “Mé xéké. Guni xéngun jooka nak duré némbuli yamba wakénguni. Wuni Duna Nyan hiyawut God wandét wuni wambula raméwut, guni wun nukwa wun jooka watanguni.” ");
INSERT INTO wos_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Wungi wandéka di déka du déré wa, “Xékélelakikwa du di angi wa, ‘Godna profet Elaija tale yatandé. Yandét God wasékendén du Krais hukémbu yatandé.’ Métaka di wungi wa?” ");
INSERT INTO wos_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Wungi wandaka dé wa, “Wu mwi hundi di wa. Elaija tale yatandé. Yae dé du takwana mawuli huréhalékétandé, di Kraisna hundi xékéndate. ");
INSERT INTO wos_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Guniré wuni we. Elaija wundé yandé. Yandéka du takwa déka xékélakihafi yata di mawuli yandaka maki di déré haraki huru. Déré hurundan maki wuni Duna Nyan wuniré haraki hurutandi.” ");
INSERT INTO wos_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Wungi wandéka di xékélaki dé Elaijaka wata dé guré husandakwa du Jonka dé wa. ");
INSERT INTO wos_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Jisas, Pita, Jems, Jon, wungi naande ye di déka du nawulak akwi séfélak du takwa akwi hérangwanda téndanmbu di xaku. Xakundaka dé du nak Jisaska yae dé déka hwati se wandé da. ");
INSERT INTO wos_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","Wandé dae dé wa, “Néma Du, méni wuna nyanka mé saréfa na. Nak nukwa nak nukwa dé wangété yata dé sayiké hiya. Sayiké hiyae séfélak nukwa dé yambu xakre dé gumbu akwi dé xakri. ");
INSERT INTO wos_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Xakrindéka wuni ména duka hura yiwuka di déré huréhalékénjoka di hurufatiké.” ");
INSERT INTO wos_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Wungi wandéka dé Jisas wa, “Yingi maki dé? Guni wunika jémba sarékéhambaméni. Guna mawuli jémba téhambandé. Hatika bafu wuni guni wali rewut guni wunika jémba sarékétanguni? Guni wun nyanré wunika mé hura ya.” ");
INSERT INTO wos_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Wungi wandéka hura yandaka dé Jisas wun nyanré hura téndé haraki hamwinyaré hambukmbu wandéka dé wun nyanré bari yatakataka yaange yi. Yaange yindéka dé wun nyan yikafre ya. ");
INSERT INTO wos_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Hukémbu Jisas hafu rendéka di déka du déka yae di déré wa, “Nani wun haraki hamwinyaré wambeka dé yaange yihambandé. Métaka nani wun jémba yanjoka nani hurufatiké?” ");
INSERT INTO wos_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","21","Wungi wandaka dé diré wa, “Guni Godka jémba sarékéhafi yata guni wungi yanjoka guni hurufatiké. Mé xéké. Guni Godka jémba sarékéta guni hambuk jémba yatanguni. Ané némburé mé xé. Guni Godka jémba sarékéngut, guna sarékéngun mawuli miyar sék maki yikama male téndét, ané némbu raama yindéte Godré wangut, ané némbu raama yitandé. Guni déka jémba sarékéta déré wangut, guni hanja xéhafi yandan hambuk jémba atéfék akwi yatanguni.” ");
INSERT INTO wos_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Jisas déka du wali Galilina hafwambu yitaka yatakata Jisas dé diré wa, “Hukémbu di wuni Duna Nyanré mamaka hwendat, wuni deka tambambu retawuni. ");
INSERT INTO wos_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Rewut wuniré xiyandat hiyatawuni. Hiyae nukwa hufuk yindét God wandét wuni wambula ramétawuni.” Wungi wandéka deka biya mawuli némafwi xak dé ya. ");
INSERT INTO wos_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Jisas déka du wali di Kaperneamré di yi. Ye xakundaka di tempelka yéwa héraakwa du Pitaka yae di déré wa, “Guna néma du tempelka yéwa nawulak dé hwe, o yingafwe?” ");
INSERT INTO wos_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Wungi wandaka dé Pita wa, “Xéxé. Dé hwe.” Wungi wataka geré wulaaye Jisasré wun hundi wahafi téndéka Jisas dé déré wakwexéké, “Saimon, yingi méni saréké? Ané héfambu rekwa néma du héndéka di yéwa héra? Deka hémna du takwaka di héra, o nak téfana du takwaka di héra?” ");
INSERT INTO wos_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Wungi wandéka dé Pita wa, “Nak téfana du takwaka male di yéwa héra.” Wungi wandéka dé Jisas wa, “Wu mwi hundi dé. Néma du deka du takwana yéwa hérahafindi. Wuni Godna nyan wuni re. Wuni déka geka yéwa hwehafi yata wuni déka nyan rewukaka sarékéta dé God wuniré haraki hundi yamba wakéndé. ");
INSERT INTO wos_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Wuni tempelka hwehafi yawut, di nanika haraki mawuli xékétandi. Deka mawuli jémba téndéte, wuni akwi yéwa hwetawuni. Méni ye méni tukwesekembu xéri hamwi séngwa yaki. Tale hérateméka xéri hamwi hérae taak husene méni xéri hamwina taakmbu yéwa nak xétaméni. Xétaka hérae hura yae méni dika hwetaméni. Hweteméka yéwa wu ana yéwa dé, méni akwi wuni akwi. Ana yéwa hari dika hwe, tempelka.” Wungi dé Jisas Pitaré wa. ");
INSERT INTO wos_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Wun nukwa di Jisasna du déka yae di déré wa, “Héndé atéfék néma duré sarékéngwanda néma du re, Godna hémémbu?” ");
INSERT INTO wos_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Wungi wandaka dé Jisas nyan nakré wandéka yae dé deka nyéndékmbu té. ");
INSERT INTO wos_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","Téndéka dé diré wa, “Mé xéké. Guna haraki saraki mawuli yatakataka guni yikafre mawuli yatanguni. Guna mawuli yikama nyangwalna mawuli maki téhafi yandét, guni Godna hémémbu yamba xakukénguni. ");
INSERT INTO wos_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Ané nyan dé déka ximbu harékéhambandé. Déka mawuli jémba dé té. Déka mawuli téndéka maki deka mawuli jémba tékwa du takwa, di deka ximbu harékéhafi yata Godna hémémbu reta, néma du takwa retandi. Di nawulak néma du takwaré akwi sarékéngwandétandi. ");
INSERT INTO wos_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Du takwa wunika jémba sarékéta ané nyanré yikafre huruta di wuniré akwi yikafre huru.” Wungi dé Jisas wa. ");
INSERT INTO wos_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Wun hundi wataka dé angi wa: “Ané yikama nyangwal di wuna hundi jémba xéké. Du nak wandét wun nyangwal nak déka hundi xékéta wuna hundi yatakandét, God wungi wandé duré hurundén haraki saraki sémbut hasa hwendét, wu némafwi joo dé. Nawulak du di wun duré déka holéméngimbu némafwi motu gitaka déré yakisandandat, dé wun haraki sémbut huruhafi yata tukwesekembu naande ye hulingu se hiyandét, wu yikama joo dé.” ");
INSERT INTO wos_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","“Séfélak du takwa di ané héfana haraki jonduka male sarékéta di wuna hundika yike ye. Wunde du takwaka wuni saréfa nae. Du nawulak wandat, wuna hundi xékékwa du takwa deka hundi xékéta wunika hu hwendat, wungi wun du deka mawuliré di haraki huru. Wu némafwi haraki saraki joo dé. God wungi wakwa duré hurundan haraki saraki sémbut hasa hwetandé. ");
INSERT INTO wos_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","“Guna man tamba haraki saraki joo hurundét, guni wun man tamba xatéka mé yaki. Guna natafa man natafa tamba male téndét wun haraki joo huruhafi yata Godna hémémbu xakungut, wu yikafre dé. Guna man yéték tamba yéték téndét guni wun haraki joo hurutaka hukémbu ya yanékwa hafwaré naande yingut, wu haraki dé. ");
INSERT INTO wos_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Guni guna dama haraki saraki jooré xéta wun haraki joo hurungut, wun dama hurufuneka mé yaki. Guna natafa dama male téndét wun haraki joo huruhafi yata Godna hémémbu xakungut, wu yikafre dé. Guna dama yéték téndét guni wun haraki joo hurutaka hukémbu ya yanékwa hafwaré naande yingut, wu haraki dé. ");
INSERT INTO wos_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","11","“Mé xéké. Guni yikama nyangwalka hu hwekénguni. Dika angi wakénguni, ‘Di yikama nyangwal male di. Dika sarékékéme.’ Anwarmbu rekwa du wuna yafana ensel dika jémba hatindaka guni wungi wakénguni. Wun ensel wuna yafana makambu di re, wungi re wungi re.” ");
INSERT INTO wos_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","“Ané sataku hundika mé saréké. Du nak dé séfélak (100) sipsip balika dé hati. Natafa sipsip bali fakundét, wun du méta yatandé? Dé fakundé sipsip balika hwakétandé, o yingi maki dé? Déka nawulak sipsip bali némbumbu wara sata téndat dé diré yatakataka ye fakundé sipsip balika hwakétandé. ");
INSERT INTO wos_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Hwaka xétaka dé wun natafa sipsip balika némafwimbu mawuli sawuli yatandé. Dé wali rendé sipsip balika mawuli yata fakundé sipsip balika dé némafwimbu mawuli sawuli yatandé. Mwi hundi wuni guniré we. ");
INSERT INTO wos_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Guni wun hundika sarékéta xékélakitanguni. Wun du sipsip balika jémba hatindéka maki, anwarmbu rekwa du wuna yafa dé du takwaka jémba hati. Hatita dé wun yikama nyan faakwa haraki hafwambu rendémboka hélék dé ye.” ");
INSERT INTO wos_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","Wun hundi wataka dé Jisas angi wa: “Ména nyayika nak méniré haraki hurundét, méni déka ye béni hafu reta méni déré wataméni, ‘Méni wuniré haraki méni huru.’ Wungi wataméni déré. Nak du takwaré wun jooka yamba wakéméni. Méni déka ye déré wamét, dé ména hundi xékéta méniré hurundén haraki joo yatakandét, wu yikafre dé. Béni yituku natafa mawuli hérae jémba retambéni. ");
INSERT INTO wos_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Dé ména hundi xékéhafi yandét, méni wuna hundika xékékwa du natafa yétékré akwi hérae guni déka wambula ye déré wambula wataméni, méniré hurundén haraki jooka. Wungi waméte hanja du nak ané hundi Godna nyingambu dé hayi: Du yéték hufuk natafa hundi wandat, guni deka hundika ‘Mwi hundi dé’ natanguni. Nak du wun hundi xékétandi. Hayindén hundika sarékéta méni du yétékré hérae guni atéfék méniré haraki hurundé duna hundi xékétanguni. ");
INSERT INTO wos_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Méni bérré hura méniré haraki hurundé duré hundi wangut, dé guna hundi xékénjoka hélék yandét, méni wuna hundika xékékwa du takwa hérangwanda rendat, diré wataméni, méniré hurundén haraki jooka. Wamét di wun jooka déré wandat, dé deka hundi akwi xékénjoka hélék yandét, guni atéfék déré watanguni, dé guniré yatakataka yindéte. Nak téfana du akwi, yéwa héraata haraki sémbut hurukwa du akwi wuna hundika xékéhafi yata afakémbu rendaka maki, dé akwi guniré yatakataka ye afakémbu retandé.” ");
INSERT INTO wos_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","“Guniré wuni we. Guni ané héfambu téta nak jooka gingut, God déka getéfambu reta wun jooka akwi gitandé. Guni ané héfambu téta, nak jooka yatakangut God déka getéfambu reta, wun jooka akwi yatakatandé. Mwi hundi wuni guniré we. ");
INSERT INTO wos_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Nak hundi akwi guniré wuni we. Guna du yéték natafa mawuli héraata anwarmbu rekwa du wuna yafa Godka wambét, dé bérka hundi xéka wambén maki hurutandé. ");
INSERT INTO wos_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Angi wuni we, du yéték hufuk wunika sarékéta natafa mawuli héraata natafa hafwambu rendat, wuni deka nyéndékmbu retawuni.” Wungi dé Jisas wa. ");
INSERT INTO wos_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Pita Jisaska ye dé déré wa, “Néma Du, wuna nyémayika wuniré haraki hurundét, wuni déré angi watawuni, ‘Wun jooka wambula yamba sarékékéwuni. Reséndé.’ Wun hundi yambu angé yétiyéti angé hufuk watawuni, o hatika yambu dé?” ");
INSERT INTO wos_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Wungi wandéka dé Jisas déré wa, “Wuni yambu angé yétiyéti angé hufuk wungi waméte wahambawuni. Ména du séfélak yambu méniré haraki hurundét, méni wungi re wungi re déré angi wataméni, ‘Wun jooka wambula yamba sarékékéwuni. Reséndé.’ Wungi wata wun hundi yamba yatakakéméni. Wungi wateméka yambu handékénénjoka méni hurufatikétaméni.” ");
INSERT INTO wos_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Wun hundi Pitaré wataka dé ané sataku hundi wa: “God néma du reta déka hémka jémba hatitendéka angi dé. Néma du nak dé wa, ‘Séfélak jémba yakwa duka wuni yéwa hwe. Hwewuka di wunika hasa hwehambandi. Némbuli di wuna yéwa hasa hwendate wuni mawuli ye.’ ");
INSERT INTO wos_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Wungi wataka dé dika wa, wungi hasa hwendate. Wandéka di du nakré déka hura ya. Wun du séfélak séfélak yéwa dé héra (10 milion kina). ");
INSERT INTO wos_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Wun du yéwa nawulak hura yahambandé. Wun yéwa hasa hwenjoka dé hurufatiké. Hurufatikéndéka dé néma du wa, di wun du, déka takwa, déka nyangwal, déka atéfék jondu nak duka hwetaka yéwa hérae déka yéwa hasa hwendate. ");
INSERT INTO wos_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Wungi wandéka dé wun du néma du rendénmbu hwati se wandé dae dé wa, ‘Néma du, méni wunika saréfa naata wunika haxétaméni. Hukémbu wuni ména yéwa atéfék hasa hwetawuni.’ ");
INSERT INTO wos_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Wungi wandéka dé wun jémba yakwa duna néma du déka saréfa naata dé déré wa, ‘Reséndé. Wunika hasa hwekéméni. Méni baka yitaméni.’ Wungi dé néma du wa. ");
INSERT INTO wos_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","“Wun jémba yakwa du hafwaré gwande dé dé wali jémba yakwa du nakré xé. Wun du tale démbu bangi tamba yéti yéwa dé héra. Hérandén yéwa hasa hwehambandé. Xétaka dé déré huluke dé déka holéméngimbu hambukmbu hutukwakéta dé wa, ‘Méni wunimbu héramén yéwa atéfék némbuli hasa hwetaméni.’ ");
INSERT INTO wos_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Wungi wandéka dé wun du hwati se wandé dae dé wa, ‘Méni wunika saréfa naata wunika haxétaméni. Hukémbu wuni ména yéwa hasa hwetawuni.’ ");
INSERT INTO wos_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Wungi wandéka hélék dé ya. Hélék yata dé déré hura ye duna makambu takataka séndé gembu taka. Take dé déré wa, ‘Méni wuna yéwa hasa hwetaka méni séndé ge yatakataka gwandetaméni.’ Wungi wandéka dé séndé gembu hwa. ");
INSERT INTO wos_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","“Dé wali jémba yandé du xe di déka némafwimbu saréfa na. Saréfa naata di deka néma duré wun jooka safé. ");
INSERT INTO wos_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Saféndaka dé néma du wandéka wun du yandéka dé déré wa, ‘Méni haraki sémbut hurukwa du méni. Tale méni wuniré wakwexékéméka wunimbu héramén némafwi yéwaka wuni wa, Reséndé. Wunika hasa yamba hwekéméni. ");
INSERT INTO wos_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Wungi wata ménika wuni saréfa na. Métaka méni wuni huruwun maki méni wali jémba yandé duka saréfa nahafi ya? Méni déka saréfa nahafi ye méni haraki saraki sémbut hurukwa du méni.’ ");
INSERT INTO wos_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Wungi wataka dé biya mawuli wita dé wun duré séndé gembu taka, déka du déré hangéli hwendate. Take dé déré wa, ‘Wuna yéwa atéfék hasa hwetaka, méni séndé ge yatakataka gwandetaméni.’ Wungi dé wa.” ");
INSERT INTO wos_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Wun hundi wataka dé Jisas wa, “Guni wun hundika mé saréké. Du nak guniré haraki hurundét, guni angi watanguni, ‘Reséndé. Wun haraki jooka wambula yamba sarékékéme.’ Guni wungi wahafi yangut, God hurungun haraki saraki sémbutka wungi re wungi re sarékétandé. Sarékéta wun haraki saraki sémbut yamba yakwanyikéndé.” Wungi dé Jisas diré wa. ");
INSERT INTO wos_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Jisas wun hundi wataka dé Galilina héfa yatakataka dé Jordan xérimbu xaake Judiana héfaré dé yi. ");
INSERT INTO wos_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Yindéka séfélak du takwa di déka hukémbu yi. Yindaka dé wun hafwambu bar hiyandé du takwa akwi séfimali haraki yandé du takwaré akwi dé huréhaléké. ");
INSERT INTO wos_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Farisi nawulak di Jisaska ye di déré hurukwexénjoka di déré wa, “Nana hambuk hundi yingi dé wa? Du nak déka takwaré yatakandét, wungi yikafre dé, o haraki dé?” ");
INSERT INTO wos_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Wungi wandaka dé diré wa, “Métaka guni wunika wakwexéké wun jooka? Hanja Godna nyingambu du nak wun jooka hundi hayindéka wundé xéngu. Angi dé hayi: Hanja tale God atéfék jondu huratakataka dé du takwaré akwi dé hurataka. ");
INSERT INTO wos_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Huratakataka dé wa, ‘Du déka yafa ayiwaré yatakataka takwa hérae bér natafambu retambér. Reta natafa séfi retambér.’ ");
INSERT INTO wos_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Wun hundika sarékéta nani xékélaki. Du takwa hérae bér natafambu bér re. Séfi yéték yingafwe. God gindén joo du nak yamba lukukéndé.” Wungi dé Jisas diré wa. ");
INSERT INTO wos_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Wun hundi wandéka di Farisi wa, “Moses nak hundi nanika angi dé wa, ‘Du nak déka takwaré yatakanjoka mawuli ye tale nyinga nak hayitandé, wun jooka. Haaye léka hweta wandét, lé déré yatakataka yitalé.’ Métaka dé Moses wungi wa?” ");
INSERT INTO wos_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Wungi wandaka dé diré wa, “Guni atéfék haraki saraki mawuli xékékwa du takwa renguka dé Moses gunika wun hundi wa. Hanja God du takwaré tale huratakandén nukwa di du wungi huruhambandi. ");
INSERT INTO wos_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Wuni guniré angi wuni we. Duna takwa nak du wali haraki sémbut huruhafi yalét, léka du léré baka yatakataka, dé takwa hésiré hérae, wun du dé hukémbu hérandén takwa wali bér haraki sémbut bér huru.” ");
INSERT INTO wos_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Wun hundi wandéka Jisasna du di déré wa, “Méni wungi waméka nani angi saréké. Du déka takwa yamba yatakakéndé. Du takwa hérahafi baka téndat, wu yikafre dé.” ");
INSERT INTO wos_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Wungi wandaka dé diré wa, “Du nawulak wungi hurunjoka di hambuk ya. Baka téndate God dika dé hambuk hwe. Séfélak du baka ténjoka di hurufatiké. ");
INSERT INTO wos_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Ané du di takwa hérahafi ye. Du nawulak deka ayiwa diré hérandaka deka séfi haraki yandéka di takwa yamba hérakéndé. Du nawulak deka mandé hérekindat, di takwa hérae nyan yamba hérakéndi. Du nawulak Godna jémbaka male sarékéta di takwa hérahambandi. Wun hundi xékéta wungi hurunjoka mawuli yakwa du di wun hundi jémba xékétandi.” Wungi dé Jisas wa. ");
INSERT INTO wos_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Du takwa nawulak di yikama nyangwalré Jisaska hura yi, dé deka anéngambambu tamba take dika Godka wandéte. Hura yindaka di Jisasna du diré haraki hundi wa. ");
INSERT INTO wos_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Haraki hundi wandaka dé Jisas diré wa, “Yikama nyangwal di wunika métaka yanda. Yandat guni diré haraki hundi yamba wakénguni. Godna hémémbu wulayinjoka mawuli yakwa du takwa di wun yikama nyangwal maki retandi.” ");
INSERT INTO wos_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Wungi wata dé deka anéngambambu tamba taka. Takataka dé wun hafwa yatakataka dé yi. ");
INSERT INTO wos_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Wayikana du nak dé Jisaska ye dé wa, “Godna jémbaka wakwekwa du, méta yikafre sémbut hura wuni huli mawuli hérae wungi re wungi re jémba retawuni?” ");
INSERT INTO wos_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Wungi wandéka dé Jisas wa, “Métaka méni yikafre jooka wuniré wakwexéké? God hafu yikafre sémbut hurundékandé. Méni wungi re wungi re jémba renjoka mawuli yata God wandéka Moses wandén hambuk hundi mé xéké.” ");
INSERT INTO wos_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Wungi wandéka dé wun du wa, “Méta hundi?” Wungi wandéka dé Jisas wa, “Ané hundi. Du takwaré xiyakéméni. Nak duna takwa wali haraki sémbut hurukéméni. Sélé hérakéméni. Nak duka yénataka hundi wakéméni. ");
INSERT INTO wos_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Méni ména yafa ayiwaré yikafre hurutaméni. Méni hafuka némafwimbu mawuli yaméka maki, ména nyémayikaka némafwimbu mawuli yataméni. Mawuli yata diré yikafre hurutaméni.” ");
INSERT INTO wos_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Wun hundi xékétaka dé wun wayikana du déré wa, “Wun hundi atéfék xékéta wandéka maki wuni huru. Méta joo nak akwi hurutawuni?” ");
INSERT INTO wos_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Wungi wandéka dé wa, “Angi akwi hurutaméni. Méni yikafre xakuwu nae méni takamén atéfék jondu nak duka hwetaka yéwa hérae méni jambangwe du takwaka hwetaméni. Hwemét God méniré yikafre hurundét, hukémbu méni Godna getéfaré ye wumbu jémba male retaméni. Méni jambangwe du takwaka yéwa hwetaka wambula yae wuna hukémbu yataméni.” ");
INSERT INTO wos_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Wungi wandéka wun wayikana du xékétaka déka séfélak jondu hwenjoka hélék yata déka biya mawuli xak dé ya. Yandéka Jisasré yatakataka dé yi. ");
INSERT INTO wos_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Dé yindéka dé Jisas déka duré wa, “Xérénjuwi mama du Godna héfaré wulayinjoka weséka wulayitandé. Mwi hundi wuni guniré we. ");
INSERT INTO wos_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Ané hundi akwi wuni we: Xérénjuwi mama du Godna héfaré wulayinjoka mawuli ye, dé némafwi jémba yatandé. Némafwi kamel bali nak nukwa wur hundafanéndaka ramina yambumbu wulayinjoka mawuli ye yalefu jémba yatandé.” ");
INSERT INTO wos_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Wun hundi xékétaka Jisasna du saréké warékéta di wa, “Xérénjuwi mama du Godna hémémbu wulayinjoka weséka wulayindat, yingi maki ye jambangwe du takwa Godna hémémbu wulaaye jémba retandi, wungi re wungi re?” ");
INSERT INTO wos_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Wungi wandaka dé diré xéta dé wa, “Du takwa di hafu hambuk yata di Godna hémémbu wulaaye jémba renjoka di hurufatiké. God hafu atéfék jondu hali hurundé.” ");
INSERT INTO wos_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Wun hundi xékétaka dé Pita wa, “Mé xéké. Nani nana jondu atéfék yatakataka nani ména jémba yata méni wali yitaka yataka. Wungi huruta, méta joo hératame?” ");
INSERT INTO wos_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Wungi wandéka dé Jisas déré wa, “Mwi hundi wuni guniré we. Hukémbu nyir héfa atéfék jondu akwi huli xakundét, wuni Duna Nyan néma duna yikafre jambémbu reta du takwaka néma du retawuni. Wun nukwa guni wuna du tamba atéfék ye man yéték, guni néma duna jambémbu reta, Israelna hém tamba atéfék ye man yéték wun hémka guni néma du reta dika hatitanguni. ");
INSERT INTO wos_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Wunika jémba sarékékwa du takwa wuna jémba yanjoka di deka ge, nyamangu, bandingu, ayiwa, yafa, nyangwal, yawi yatakandat, God dika séfélak séfélak wungi maki jondu hweta diré yikafre hurundét, di jémba retandi, wungi re wungi re. ");
INSERT INTO wos_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Némbuli rekwa séfélak néma du takwa hukémbu baka du takwa retandi. Némbuli rekwa séfélak baka du takwa di hukémbu néma du takwa retandi.” Wungi dé Jisas wa. ");
INSERT INTO wos_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Jisas dé diré ané hundi wa: “God néma du reta du takwaka jémba hatitendéka angi dé: Du nak némafwi wain bangwi tékwa yawi nak dé huru. Hurutaka nak ganémba, nukwa xalehafi yandéka ye dé wun yawimbu jémba yatekwa duka dé hwaké. ");
INSERT INTO wos_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Hwaka xétaka dé diré wa, ‘Guni ané atéfék nukwa jémba yangut, wuni guni nak nakéka natafa yéwa hwetawuni.’ Wungi wandéka di wa yawundu. Yawundu nandaka dé wandéka di déka yawiré yi, déka jémba yanjoka. ");
INSERT INTO wos_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Hukémbu nukwa xalendéka dé wun yawimbu jémba yatekwa du nawulakéka akwi hwaka dé du hérangwandéndaka hafwaré yi. Ye dé xé du nawulak baka téndaka. ");
INSERT INTO wos_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Xe dé diré wa, ‘Guni akwi ye wuna yawimbu jémba yatanguni. Yangut wuni guni nak nakéka sékéré yéwa hwetawuni.’ ");
INSERT INTO wos_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Wungi wandéka di déka yawiré yi. Nukwa dawimbu téndéka ye dé déka yawimbu jémba yatekwa du nawulakéka akwi hwaka xé. Xétaka wandéka di akwi déka jémba yandaka nukwa tengura naande yinjoka yandéka dé du nawulakéka akwi hwaka xé. Xétaka wandéka di akwi di déka jémba ya. ");
INSERT INTO wos_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Yandaka gérambu nukwa nandindéka dé du hérangwandéndaka hafwaré wambula ye dé xé du nawulak akwi baka téndaka. Xe dé diré wa, ‘Métaka guni amba nukwa ambu baka té?’ ");
INSERT INTO wos_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Wungi wakwexékéndéka di wa, ‘Naniré du nak jémba yambete wahambandé.’ Wungi wandaka dé diré wa, ‘Guni akwi ye wuna yawimbu jémba yatanguni.’ ");
INSERT INTO wos_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","“Hukémbu gan hunyindéka yawina yafa dé jémba yakwa duka hatikwa duré dé wa, ‘Méni jémba yakwa duré wamét yandat méni dika yéwa hwetaméni. Tale méni hukémbu yae jémba yandé duka hwetaméni. Hwetaka méni nyéndék nukwa yae jémba yandé duka hwetaka, hukémbu méni ganémbambu yae jémba yandé duka hwetaméni.’ ");
INSERT INTO wos_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Wungi wandéka dé wungi hwendéka di gérambu yae jémba yandé du déka yae di nak nak natafa yéwa héra. ");
INSERT INTO wos_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Hérandaka tale yae jémba yandé du yéwa héranjoka yata xétaka di angi saréké, ‘Wafewana nani néma yéwa hératame?’ Wungi sarékéta di akwi di nak nak natafa yéwa héra. ");
INSERT INTO wos_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Hérae di yawina yafa wali waru. ");
INSERT INTO wos_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","Waruta angi di wa, ‘Wunde du gérambu yae yalefu male di jémba ya. Nani tale yae nani ganémbambu jémba tale yataka némafwi jémba yambeka nukwa dé nana séfimbu xé. Métaka méni ména jémba yandé atéfék duka natafa yéwa hwe? Wu haraki méni huru.’ ");
INSERT INTO wos_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Wungi wandaka dé yawina yafa wumbu téndé du nakré wa, ‘Nyayika, mé xéké. Wuni guniré haraki huruhambawuni. Ganémbambu guniré angi wuni wa, Guni wuna jémba yangut, wuni gunika natafa yéwa hwetawuni. Wungi wawuka guni wun yéwaka guni yawundu na. Wawun maki wuni gunika hwe. ");
INSERT INTO wos_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Guni guna yéwa hérae hura getéfaré yitanguni. Wuni wuna mawuli yawukangalambu hukémbu yae jémba yandé duka akwi gunika hwewun yéwa maki male hwetawuni. ");
INSERT INTO wos_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Wu wuna jémba dé. Wu wuna yéwa dé. Guni dika hwewun yéwaka yamba bulékénguni. Wuni diré yikafre huruta yandan yikama jémbaka némafwi yéwa hwenjoka mawuli yawuka, métaka guni wunika haraki hundi we?’ Wungi dé yawina yafa wa.” ");
INSERT INTO wos_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Wungi wataka dé Jisas diré wa, “Wungi maki di hukémbu yaakwa du takwa di tale wulayitandi. Tale yikwa du takwa di hukémbu wulayitandi.” Wungi dé Jisas wa. ");
INSERT INTO wos_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","18","Jisas Jerusalemré warinjoka yita dé déka du tamba atéfék ye man yéték diré male hura dé di wali hundi bulé. Buléta dé diré wa, “Mé xéké. Némbuli Jerusalemré nani wari. Warimbet di Duna Nyanré hérae prisna néma du akwi, xékélelakikwa du akwi wuniré dika hwendat wuni deka tambambu retawuni. Rewut di wuniré xiyandate watandi. ");
INSERT INTO wos_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Wandat nak téfana du wuniré hérae wuniré haraki hundi wata rami yoombu xiyataka wuniré xiyae mimbu hatekandat hiyatawuni. Hiyae nukwa hufuk yindét God wandét wambula ramétawuni.” Wungi dé Jisas déka duré wa. ");
INSERT INTO wos_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Sebedina nyan yéték bérka ayiwa lé bérré hura yi Jisaska. Ye héfambu hwati se wandé dae lé déré wakwexéké, dé léré yikafre hurundéte. ");
INSERT INTO wos_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Wakwexékéléka dé Jisas wa, “Métaka nyéni mawuli ye?” Wungi wandéka lé déré wa, “Hukémbu méni du takwaka néma du reta méni wamét bér wuna nyan yéték nak ména yika tambambu, nak ména aki tambambu retambér. Bér wumbu reta nawulak du takwaka néma du retambér.” ");
INSERT INTO wos_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Wungi waléka dé wa, “Guni wuniré wakwexékénguka jooka xékélakihambanguni. Béni wuna satewuka hanyandémbu hali sambé?” Wungi wata dé déka hératendéka hangélika dé wa. Wungi wandéka bér wa, “Xéxé. Hali sana.” ");
INSERT INTO wos_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Wungi wambéka dé wa, “Wuna hanyandémbu satambéni. Wu mwi hundi dé. Hukémbu héndé wuna yika tamba, héndé wuna aki tambambu rete? Wuni wun jooka yamba wakéwuni. Wuna hundi yingafwe. Wumbu retekwa duka wuna yafa hanja déka mawulimbu dé waséke.” ");
INSERT INTO wos_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Wun hundi wandéka di Jisasna du tamba yéti wun jooka xékéta di bérré rékambambu wa. ");
INSERT INTO wos_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Wandaka dé Jisas wandéka yandaka dé diré wa, “Guni xékélaki. Nak téfana néma du di deka du takwaka hambukmbu yasandata di wa, deka hundi jémba xékéta deka jémba yandate. ");
INSERT INTO wos_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","27","Guni di hurundaka maki yamba hurukénguni. Guni wali rekwa du nak Godna makambu néma du renjoka mawuli yata, dé guna jémba yakwa du retandé. Reta dé guna hundi xékéta wanguka maki yatandé. ");
INSERT INTO wos_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Wuni Duna Nyan wungi wuni ya. Nak du takwaka jémba yata diré yikafre hurunjoka wuni ya. Du takwa wunika jémba yandate yahambawuni. Wuni hiyae séfélak du takwaré Satanéna tambambu hérawut, di God wali jémba rendate wuni ya.” Wungi dé Jisas diré wa. ");
INSERT INTO wos_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Jisas déka du wali Jeriko yatakataka di yi. Yindaka séfélak du takwa di déka hukémbu yi. ");
INSERT INTO wos_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Yindaka bér dama hiyandé du yéték yambumbu bér re. Reta bér hundi xéké, Jisas yambumbu yindéka. Xéka bér wa, “Ménawa, Devitna mandéka. Anika mé saréfa na.” ");
INSERT INTO wos_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Wungi wambéka di wunde du takwa bérka haraki hundi wa, bér nakélak rembéte. Haraki hundi wandaka bér hambukmbu wambula wa, “Ménawa, Devitna mandéka. Anika mé saréfa na.” ");
INSERT INTO wos_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Wungi wambéka wumbu téta dé Jisas wa, déka yambéte. Wandéka déka yambéka dé wa, “Béniré méta yawute béni mawuli ye?” ");
INSERT INTO wos_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Wungi wandéka bér wa, “Néma Du, méni aniré huréhalékémét, ani wambula xénjoka ani mawuli ye.” ");
INSERT INTO wos_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Wungi wambéka dé bérka saréfa naata déka tamba bérka damambu takandéka dé bérka dama bari yikafre yandéka xe bér Jisas wali yi. ");
INSERT INTO wos_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","2","Jisas déka du wali Jerusalemré warinjoka ye di Betfage xaku. Wun getéfa Oliv némbumbu dé té. Jerusalem sakumbu dé té. Di xaakwa dé Jisas déka du yétékré wa, “Béni wun getéfaré wulaaye xétambéni, donki bali yéték témbét. Ayiwa donki bali léka nyan wali mimbu lékindaka bér té. Xétaka béni wumbére donki bali yéték lukwa béni hura yatambéni. ");
INSERT INTO wos_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Lukwambét du nak wun jooka béniré wakwexékéndét, béni angi watambéni, ‘Nana Néma Du dé wumbére donki balika mawuli ye.’ Wungi wambét dé bari yawundu natandé, béni wumbére donki hura yambéte.” ");
INSERT INTO wos_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Jisas wungi wandéka hanja rendé profet Godna nyingambu hayindén hundi mwi hundi dé ya. Angi dé hayi: ");
INSERT INTO wos_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","Guni ye Saionmbu rekwa du takwaré angi watanguni, “Mé xé. Guna néma du gunika dé yae. Dé déka ximbu harékéhafi yata yikafre mawuli yata dé yae. Dé donki bali nyanéna bunungulmbu re dé yae.” Wungi dé hayi. ");
INSERT INTO wos_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Jisasna du yéték déka hundi xékéta bér wandén maki yi. ");
INSERT INTO wos_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Ye bér ayiwa donki bali léka nyan wali lukwa hura yi déka. Ye bér yifa yandéka sama témbén nukwa wur lafe bér donki balina bunungulmbu bér taka. Takambéka dé Jisas donki bali nyanéna bunungulmbu wara re. ");
INSERT INTO wos_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Re yindéka di séfélak du takwa nukwa wur di yambumbu xélitaka di yambumbu taka. Takandaka du nawulak di téfa téménga xatéka di yambumbu taka. ");
INSERT INTO wos_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Takataka di du takwa nawulak tale yindaka di nawulak Jisasna hukémbu yita hambukmbu di wa, “Devitna mandéka nanika dé yae. Wu yikafre dé. Néma Du God wandéka dé yae. Wu yikafre dé. God déré yikafre hurutandé. Anwarmbu rekwa du Godna ximbu harékétame.” ");
INSERT INTO wos_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Wungi wandaka dé Jisas Jerusalemré wulayi. Wulayindéka wun getéfambu rekwa atéfék du takwa déré xe waréngéna di wa, “Wu héndé du dé?” ");
INSERT INTO wos_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Wungi wandaka di dé wali yandé du takwa di wa, “Ané Profet déka xi Jisas dé. Dé Galilina héfambu dé yae. Déka getéfa Nasaret dé.” ");
INSERT INTO wos_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Jisas tempelré wulaaye dé xé du nawulak jondu hweta yéwa hérandaka. Xétaka dé diré héreki. Hérekita dé nak téfana yéwa héraata tempelna yéwa hwekwa duna jambé yanguréka yaki. Yangurékéta dé xiyae Godka hwetendaka nyamwe afwi hwekwa du rendan mi jambé xasémeka yaki. ");
INSERT INTO wos_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Yakita dé diré wa, “Godna nyingambu angi dé wa, ‘Wuna ge dé du takwa wunika yaata hundi buléndaka ge dé.’ Wungi dé God wa. Wun hundika guni sarékéhambanguni. Guni jondu hweta yéwa héranguka ané ge sélé héraakwa duna ge maki dé té.” Wungi dé Jisas diré wa. ");
INSERT INTO wos_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Jisas tempelmbu téndéka di dama hiyandé du takwa nawulak, man haraki yandé du takwa nawulak akwi wungi di déka ya. Yandaka dé diré huréhaléké. ");
INSERT INTO wos_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Huréhalékéndéka di prisna néma du akwi, xékélelakikwa du akwi di xé. Xe di xéké, nyangwal tempelmbu hambukmbu wandaka. Angi di wa, “Devitna mandéka nanika dé yae. Wu yikafre dé.” Wungi wandaka di xékéta Jisas wun du takwaré huréhalékéndéka xétaka di déka mawuli wi. ");
INSERT INTO wos_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Mawuli wita di déré wa, “Ménika wandaka hundi méni xéké, o yingafwe? Wungi wandaka haraki dé.” Wungi wandaka dé Jisas wa, “Xéxé. Wuni xéké. Wu yikafre hundi di we. Wungi watendaka Godna nyingambu angi dé wa: God méni yikama nyangwalka akwi munya sakwa nyangwalka akwi méni wa, di ména ximbu jémba harékéndate. Wun hundika yike guni ye, o yingi maki dé?” ");
INSERT INTO wos_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Wungi wataka Jisas diré yatakataka Jerusalem yatakataka dé Betaniré yi. Ye dé wumbu hwa. ");
INSERT INTO wos_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Jisas wumbu hwae ganémbambu dé Jerusalemré wambula yinjoka yambumbu yindéka dé hénoo ya. ");
INSERT INTO wos_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Yandéka yita dé xé hambingal maki mi nak yambu gambémbu téndéka. Séfélak ganga wun mimbu téndéka xe dé angi saréké, “Séfélak ganga téndéka sék dé xaké wana. Nawulak géle satawuni.” Wungi wataka dé wun misék géle sanjoka yi. Ye wun misék nawulak xaka téndéka xéhambandé. Ganga male téndéka dé xé. Xéta dé wa, “Ané mimbu sék wambula yamba xakékéndé.” Wungi wandéka dé wun mi bari réka ya. ");
INSERT INTO wos_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Yandéka Jisasna du xe waréngéna di wa, “Owa. Yingi maki ye dé wun mi bari réka ya?” ");
INSERT INTO wos_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Wungi wandaka dé Jisas diré wa, “Mwi hundi wuni guniré we. Guni Godka jémba sarékéta watémbéréhafi yata guni wun mika wawun maki watanguni. Guni wangut, mi réka yatandé. Wun joo male hurukénguni. Nawulak joo akwi hurutanguni. Ané némbu ye némangumbu naande yindéte wangut, dé ye némangumbu naande yitandé. ");
INSERT INTO wos_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Guni Godka jémba male sarékéta déré wangut, dé gunika atéfék jonduka wangun maki hwetandé.” Wungi dé déka duré wa. ");
INSERT INTO wos_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Jisas Jerusalemémbu xaakwa dé tempelré wulayi. Wulaaye dé du takwaré Godna jémbaka wakwe. Wakwendéka dé prisna néma du akwi, getéfana néma du akwi yae di Jisaska wa, “Méta hambuk hérae méni wun jémba ya? Héndé hwe ménika wun jémba?” ");
INSERT INTO wos_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Wungi wandaka dé diré wa, “Wuni akwi nak hundi guniré wakwexékétawuni. Wakwexékéwut, guni wuna hundi hasa wangut, wuni guna hundi hasa watawuni. ");
INSERT INTO wos_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Guni mé wa. Héndé wa Jonka dé du takwaré guré husandandéte? God dé wungi wa, o héfambu rekwa du nak dé wungi wa?” Wungi wakwexékéndéka di di hafu buléta waruta di wa, “Nani angi wambet, ‘God dé wungi wa.’ Wungi wambet dé naniré angi watandé, ‘Métaka guni déka hundi xékéhambanguni?’ ");
INSERT INTO wos_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Wafewana nani angi watame? ‘Héfambu rekwa du nak dé wa.’ Nani du takwaka roota wungi wakéme. Séfélak du takwa di Jonka wa, ‘Godna profet nak dé. Wu mwi hundi dé.’ Wungi di we.” ");
INSERT INTO wos_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Wungi bulétaka di yéna yata Jisasré wa, “Nani xékélakihambame. Wun jooka wakéme.” Wungi wandaka dé diré wa, “Wuni akwi gunika yamba wakéwuni, wunika jémba hwendé duka.” ");
INSERT INTO wos_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Wun hundi wataka dé Jisas ané sataku hundi wa: “Yingi guni saréké? Du nak dunya yéték dé héra. Nak nukwa dé maka dunyaka ye dé wa, ‘Wuna nyan, némbuli méni ye wuna wain yawimbu jémba yataméni.’ ");
INSERT INTO wos_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Wungi wandéka dé déka nyan wa, ‘Wuni hélék wuni ye.’ Wungi wataka hukémbu mawuli yata dé wun yawimbu jémba yanjoka dé yi. ");
INSERT INTO wos_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Wun du ye dé maka dunyaré wandén maki dé déka mwi dunyaré wa. Wandéka dé nyan wa, ‘Xéxé. Némbuli yitawuni.’ Wungi wataka yawimbu jémba yanjoka yihambandé. ");
INSERT INTO wos_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Wumbére yéték nyan héndé yafana hundi xéké?” Wungi wandéka di wa, “Maka dunya.” Wungi wandaka dé Jisas diré wa, “Mwi hundi wuni guniré we. Yéwa héraakwa haraki du, yambumbu tékwa takwa, di tale Godna hémémbu wulayitandi. Wulayindat guni hukémbu wulayitanguni, o yingafwe? ");
INSERT INTO wos_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Guré husandakwa du Jon yae dé wa, ‘Guni haraki saraki mawuli yatakataka Godna hundi jémba xékétanguni.’ Wungi wandéka guni déka hundi xékéhambanguni. Xékéhafi yanguka di yéwa héraakwa haraki du, yambumbu tékwa takwa akwi di déka hundi xéké. Xéka hurundan haraki saraki sémbut yatakataka di Godna hundi jémba xéké. Xékéndaka xe guni hurundan maki huruhambanguni. Guni hurungun haraki saraki sémbut yatakahafi ye déka hundi xékéhambanguni.” ");
INSERT INTO wos_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Wun hundi wataka dé Jisas diré angi wa: “Guni ané sataku hundi akwi mé xéké. Du nak dé wain bangwi tékwa yawi nak huru. Séndé gitaka dé wain bangwi se. Setaka dé hukémbu wain hulingu hérae sanjoka wain sék gurikésande akinjinyindate dé wekwa motumbu xa. Xataka dé yawika hatindate séményi ge nak dé to. Totaka dé wun yawika hatita yawimbu jémba yata yéwa héraakwa duka jémba hwe. Hwetaka dé afaké téfaré yi. ");
INSERT INTO wos_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","“Wain sék géli nukwa yandéka dé dé wali reta jémba yakwa duka dé nawulak wa, di yawika hatikwa duka yindate. Dé wain sék nawulak hwendat hura yandate dé mawuli ya. ");
INSERT INTO wos_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Yata wandéka déka jémba yakwa du yindaka di yawika hatikwa du diré xétaka nakré xiyae, nakré xiyandaka hiyandéka, di nakré motumbu naake xiya. ");
INSERT INTO wos_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Xiyandaka hukémbu dé yawina yafa déka jémba yakwa du nawulakré akwi wandéka di yi. Séfélak duré wandéka di yi. Yindaka di yawika hatikwa du diré wungi male di xiya. ");
INSERT INTO wos_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","“Xiyandaka hukémbu dé yafa déka mawulimbu dé wa, ‘Di wuna dunyana hundi xékétandi.’ Wungi wataka dé déka nyanré wandéka dé yawika hatikwa duka yi. ");
INSERT INTO wos_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Yindéka di yawika hatikwa du déka nyanré xe di di hafu hundi bulé. Buléta di angi wa, ‘Yawina yafa hiyandét wun nyan déka yafana atéfék jondu hératandé. Nani déré xiyataka ané yawi hératame.’ ");
INSERT INTO wos_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Wungi wataka di déré huluke di yawi yatakataka hafwaré hura gwande di déré xiyandaka dé hiya.” ");
INSERT INTO wos_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Wun hundi wataka Jisas dé diré wa, “Guni yingi guni saréké? Hukémbu yawina yafa yae yawika hatikwa duré yingi maki yatandé?” ");
INSERT INTO wos_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Wungi wakwexékéndéka di déré wa, “Dé yae wunde haraki saraki sémbut hurundé duré xiyatandé. Wungi hurutandé. Xiyae nawulak duka wun yawi hwetandé, di yawika hatindate. Hwendét hukémbu wain sék géli nukwa di wun wain sék géle déka hwetandi.” Wungi di Jisasré wa. ");
INSERT INTO wos_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Wungi wandaka dé diré angi wa, “Xiyandan nyanka Godna nyingambu angi dé wa: Ge tokwa du yikafre motuka hwaka natafa motuka hélék yandaka dé baka re. Rendéka Néma Du God wun moturé xéta dé wa, ‘Wu yikafre motu dé. Wun motu rendét ge jémba tétandé.’ Wungi wataka wun motu hérae takandéka dé ge jémba té. Téndéka nani xéta nani yikafre mawuli ye. “Wun hundi Godna nyingambu xétaka guni xékélakihambanguni. ");
INSERT INTO wos_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Wun hundika guniré wuni we. Hanja guni Juda Godna hémémbu guni re. Reta guni déka jémbaka hélék ye. Hélék yangut God wandét guni déka hémémbu rehafi yangut nak téfana du takwa déka hémémbu xakutandi. Wunde du takwa déka jémba jémba yatandi. ");
INSERT INTO wos_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Du nak wun motu takumbu xakre dé aki maki també també fikatandé. Wun motu duna séfimbu xakre wun duré yawulalama yakitandé.” Wungi dé Jisas wa. ");
INSERT INTO wos_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Wun hundi wandéka di prisna néma du akwi, Farisi akwi wun sataku hundi yétékéka xéka di xékélaki. Jisas dika dé wun hundi wa. ");
INSERT INTO wos_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Wungi xékélakita di wa, “Nani déré hura séndé gembu takatame.” Wungi wata di angi wa, “Atéfék du takwa di wa, ‘Jisas dé profet nak dé.’ Wungi wandaka nani déré hura séndé gembu takambet, di naniré haraki hurutandi.” Wungi wataka wun du takwa diré wungi haraki hundi wandamboka roota di Jisasré huruhambandi. ");
INSERT INTO wos_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Jisas dé diré sataku hundi nak akwi angi wa. ");
INSERT INTO wos_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“God néma du reta du takwaka jémba hatitendéka angi dé. Néma du nak dé re. Déka dunya takwa héranjoka yandéka dé wandéka di némafwi hénoo humbwe sanjoka ya. Yandaka wun néma du dé séfélak du takwaré wa, di hukémbu yae di wali hénoo sandate. Wandéka déka du takwa di hénoo humbwi. ");
INSERT INTO wos_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Humbwindaka dé déka jémba yakwa duré angi wa, ‘Guni atéfék getéfaré yita wawun du takwaré watanguni, di némbuli yae hénoo sandate.’ Wungi wandéka di ye wandaka wunde du takwa yanjoka hélék di ya. ");
INSERT INTO wos_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Hélék yandaka wun néma du dé déka jémba yakwa du nawulakré akwi wa, ‘Guni ye guni hanja wawun du takwaré angi watanguni: Mé xéké. Nani hénoo bu humbwikwa. Némafwi bulmakau bali wali, mwiwuléndé bulmakau bali nyan wali nani xiyae tu. Atéfék hénoo humbwimbeka dé re. Guni mé yae sa. Wungi diré watanguni.’ Wungi wandéka di wandén maki yi. ");
INSERT INTO wos_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Di ye wandaka di wun hénoo sanjoka hélék di ya. Hélék yata deka jémbaka male di saréké. Nak raama dé déka yawiré yi. Yindéka nak raama yéwa héranjoka jémba yanjoka dé yi. ");
INSERT INTO wos_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Yindéka nawulak raama di néma duna jémba yakwa duré huluke diré haraki huruta di diré xiyandaka di hiya. ");
INSERT INTO wos_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Hiyandaka dé néma du mawuli wita dé déka xi warekwa duré wandéka ye di déka jémba yakwa duré xiyandé duré atéfék xiyasanda. Xiyaata di deka getéfa yambu tusanda. ");
INSERT INTO wos_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Hukémbu dé néma du déka jémba yakwa duré wa, ‘Nani hénoo humbwimbeka dé re. Yandate wawun du takwa di yikafre du takwa yingafwe, nana hénoo satekwa. ");
INSERT INTO wos_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Némbuli sa guni ye atéfék yambumbu téta atéfék xétenguka du takwaré angi watanguni: Mé guni yae humbwimben hénoo sa. Wungi watanguni diré.’ ");
INSERT INTO wos_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Wungi wandéka di jémba yakwa du raama ye yambumbu téta di xéndan du takwaré wa, yandate. Yikafre sémbut hurukwa du takwa akwi, haraki saraki sémbut hurukwa du takwaré akwi di wa. Wandaka yae di takwa hérandé duna yafana gembu re. Rendaka wun ge dé sukweké.” ");
INSERT INTO wos_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","“Wun néma du hénoo satekwa du takwaré xénjoka dé wun geré wulayi. Wulaaye dé yikafre male nukwa wur sandahafi yandé du nak rendéka. Nyo nukwa wur male dé sanda re. ");
INSERT INTO wos_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Rendéka dé néma du déré wa, ‘Nyayika, métaki nae méni yikafre nukwa wur sandahafi ye méni angiré gwande?’ Wungi wandéka wun du hundi hasa wanjoka dé hurufatiké. ");
INSERT INTO wos_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Hurufatikéndéka dé néma du déka jémba yakwa duré wa, ‘Guni wun duré huluke déka man tamba giya guni hafwaré yakisangwandétanguni. Yakisangwandéngut dé halékingambu retandé. Wumbu reta dé néma hangéli héraata hambukmbu géraata némbi titandé.’ ");
INSERT INTO wos_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Wun sataku hundika mé saréké. God séfélak du takwaka dé wa. Wungi wataka dé nak nakré dé waséke.” ");
INSERT INTO wos_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Hukémbu di Farisi nawulak ye di di hafu hundi bulé. Buléta di wa, “Nani Jisasré nawula jooka wakwexékémbet, dé haraki hundi hasa watandé wana? Dé haraki hundi wandét, nani déré hura séndé gembu takatame.” ");
INSERT INTO wos_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Wungi wataka di deka du nawulakré akwi Herotna du nawulakré akwi wandaka di Jisaska ye di wa, “Néma du, méni naniré Godna jémbaka méni wakwe. Méni mwi hundi male wata naniré Godna hundika jémba méni wakwe. Méni natafa hundi male méni wa, néma du takwa, baka du takwaka akwi. Méni dika roohambaméni. Wungi nani xékélaki. ");
INSERT INTO wos_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Méni wungi yata némbuli méni naniré mé wa. Yingi méni saréké? Nana hambuk hundi yingi dé wa? Nani yéwa Romna néma duka hwetame, o yingafwe?” ");
INSERT INTO wos_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Wungi wandaka dé Jisas deka mawuli dé xékélaki. Di deka mawulimbu angi di wa, “Némbuli dé haraki hundi wandét, nani déré séndé gembu takatame.” Wungi wandaka Jisas xékélakita dé diré wa, “Guni yéna yakwa du guni. Métaka guni wunika wungi wakwexéké? ");
INSERT INTO wos_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Guni Romka hwenguka yéwa nak wunika mé hura yangut xéwu.” Wungi wandéka di wun yéwa nak hura ya déka. ");
INSERT INTO wos_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Hura yandaka dé diré wa, “Ané yéwambu rekwa waka héna saawi dé? Héna xi di ané yéwambu hayi?” ");
INSERT INTO wos_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Wungi wakwexékéndéka di wa, “Wu Romna néma duna xi, Sisar dé.” Wungi wandaka dé diré wa, “Wu mwi hundi dé. Sisarna jondu Sisarka mé guni hwe. Godna jondu Godka mé guni hwe.” ");
INSERT INTO wos_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Wungi wandéka di wun hundi xékéta waréngéna di saré waréké. Saré warékéta di déré yatakataka di yi. ");
INSERT INTO wos_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Wun nukwa Sadyusi nawulak di Jisaska ye di déré wakwexéké. Wunde du deka mawulimbu di angi wa, “Hiyandé du takwa wambula yamba ramékéndi.” ");
INSERT INTO wos_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","Jisaska wakwexékéta di angi wa: “Néma du, méni du takwaré Godna jémbaka méni wakwe. Méni ané jooka naniré mé wa. Hanja Moses angi dé wa, ‘Du nak takwaré hérae nyan hérahafi ye hiyandét, déka bandi wule takwaré hératandé. Hérandét nyan héralét wun nyanka watandi, Nyamana nyan dé. Wungi watandi.’ Wungi dé Moses wa. ");
INSERT INTO wos_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Némbuli mé xéké. Hanja nyamangu bandingu angé yétiyéti angé hufuk di nana nyéndékmbu re. Nyama takwaré hérae nyan hérahafi ye dé hiya. Hiyandéka déka bandi dé wule takwaré hérae nyan hérahafi ye dé hiya. Hiyandéka nak bandi akwi wule takwaré hérae nyan hérahafi ye dé akwi hiya. ");
INSERT INTO wos_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Hiyandéka atéfék bandingu wungi male léré hérae di atéfék nyan hérahafi ye di akwi hiya. ");
INSERT INTO wos_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Hiyandaka hukémbu lé wule takwa hiya. ");
INSERT INTO wos_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Némbuli naniré mé wa, hiyandé du takwa ramétendaka nukwaka. Wun nukwa wule takwa héndé wali retalé? Hanja wun nyamangu bandingu atéfék di léré héra.” Wungi di Sadyusi Jisasré wa. ");
INSERT INTO wos_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Jisas deka hundi xékétaka dé diré wa, “Guni Godna nyingambu rendé hundika xékélakihambanguni. Xékélakihafi yata Godna hambukéka akwi xékélakihambanguni. Xékélakihafi yata guni séféla guni we. Mé xéké. ");
INSERT INTO wos_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Hukémbu God wandét hiyandé du takwa raama di Godna getéfambu reta déka ensel maki retandi. Reta du di takwa yamba hérakéndi. Takwa di du yamba humbwikéndi. ");
INSERT INTO wos_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Hundi nawulak akwi watawuni, hiyandé du takwa ramétendakaka. God guniré wandéka déka nyingambu rendé hundi nawulak xétaka guni jémba sarékéhambanguni. ");
INSERT INTO wos_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","God dé wa, ‘Wuni Abrahamna God, Aisakna God, Jekopna God wuni.’ Wungi wandéka nani xékélaki. Dé hiyandé duna God yingafwe. Dé huli rekwa duna God dé. Wunde du di hiyae Godna makambu huli du di re. Wungi nani xékélaki.” ");
INSERT INTO wos_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Wungi wandéka wumbu téndé du takwa wun hundi xékéta déka hundika waréngéna di saré waréké xéké. ");
INSERT INTO wos_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Wun hundi wandéka di Sadyusi hundi buléhafi re. Rendaka Farisi xékétaka yae di di wali hérangwanda re. ");
INSERT INTO wos_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Rendaka dé di wali reta hambuk hundika xékélelakikwa du nak Jisasré hurukwexénjoka dé déré angi wakwexéké, ");
INSERT INTO wos_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","“Néma du, méni Godna hundika méni naniré wakwe. Nana hambuk hundimbu méta néma hundi dé atéfék néma hundiré sarékéngwandé?” ");
INSERT INTO wos_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Wungi wakwexékéndéka dé déré wa, “Guni guna Néma Du Godka némafwimbu mawuli yatanguni. Yata guni déré wangut dé guna mawuli, guna hamwinya, guna mawuli sarékéka dé néma du retandé. ");
INSERT INTO wos_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Wun hundi néma hundi dé. Atéfék néma hundiré dé sarékéngwandé. ");
INSERT INTO wos_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Nak néma hundi akwi wungi male dé. Angi dé wa, ‘Guni guni hafuka némafwimbu mawuli yanguka maki guna nyémayikaka némafwimbu mawuli yatanguni. Yata diré yikafre hurutanguni.’ ");
INSERT INTO wos_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Wumbére hundi néma hundi dé. Atéfék néma hundiré dé sarékéngwandé. Guni wun hundi xékéta wandén maki huruta guni Moses wandén hambuk hundi akwi Godna profet wandan hundika akwi guni xéké.” Wungi dé Jisas wa. ");
INSERT INTO wos_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Farisi yae natafambu hérangwanda téndaka dé Jisas diré wakwexéké, ");
INSERT INTO wos_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“Guniré yikafre hurundéte God wasékendén du Krais, dé yingi maki du dé? Yingi guni déka saréké? Dé héna mandéka dé?” Wungi wakwexékéndéka di déré wa, “Dé Devitna mandéka dé.” ");
INSERT INTO wos_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Wungi wandaka dé diré wa, “Hanja Krais ané héfambu rehafi yandéka Godna Hamwinya Devitna mawulimbu wulaaye téndéka Devit dé Kraiska angi wa, ‘Wuna Néma Du dé.’ Wungi wata dé angi wa: ");
INSERT INTO wos_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","Néma Du God wuna Néma Duré dé wa, ‘Méni néma du reta wuna yika tambambu retaméni. Remét wuni ména mamaré ména man mombu takatawuni.’ Wungi dé God wa. ");
INSERT INTO wos_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Devit God wasékendén du Kraiska ‘Wuna Néma Du dé’ nandéka yingi maki dé Krais Devitna mandéka re? Krais Devitna mandéka reta Devitna néma du akwi dé re, o yingi maki dé?” ");
INSERT INTO wos_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Wungi wandéka di Jisasna hundi hasa wanjoka di hurufatiké. Wun nukwa di déré hundi nawulak akwi wakwexékénjoka di roo. Hukémbu akwi di déka wambula wakwexékéhambandi. ");
INSERT INTO wos_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Jisas dé déka du akwi, séfélak du takwaka akwi dé hundi wa. ");
INSERT INTO wos_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","Angi dé wa: “Xékélelakikwa du akwi, Farisi akwi di Moses hanja wandén hambuk hundika di jémba xékélaki. ");
INSERT INTO wos_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Xékélakindanka sarékéta guni deka hundi xékéta wandan maki hurutanguni. Huruta guni di hurundaka maki hurukénguni. Di séfélak hundi wata di wandan maki huruhambandi. ");
INSERT INTO wos_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Du nak séfélak jondu yatandéka nak du yae nawulak xak akwi takandéka maki, Farisi akwi xékélelakikwa du akwi di hambuk jémba nawulak akwi du takwaka di hwe. Hweta di diré angi wa, ‘Guni ané hambuk hundi atéfék xékéta wandén maki hurutanguni.’ Wungi wandaka di wun hundi xékéta wandén maki hurunjoka némafwi jémba di ya. Yandaka di dika saréfa nahafi yata diré yikafre huruhambandi. ");
INSERT INTO wos_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Atéfék du takwa diré xéta dika ‘Yikafre du dé’ nandate di mawuli ye. Yata Godna hundi nawulak nyingambu haaye di wun nyinga deka makambu akwi deka tambambu akwi di gi. Gitaka di yikafre séményi yoo di deka nukwa wurna wambumbu léki. ");
INSERT INTO wos_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Di nak du wali hénoo sata di yikafre hafwaka hwakéta du takwana makambu renjoka di mawuli ye, di xéta deka ximbu harékéndate. Di Godna hundi buléndaka geré wulaaye néma duna hafwambu renjoka di mawuli ye. ");
INSERT INTO wos_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Di du takwa hérangwandéndaka hafwambu yitaka yatakandat du takwa diré xéta angi wandate di mawuli ye: ‘Nana néma du andé yae. Naniré Godna hundika wakwekwa du di.’ Wungi wandate di mawuli ye. ");
INSERT INTO wos_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","“Guni wuna du reta guni wungi hurukénguni. Guni atéfék wuna hundika xéka nyama bandi guni re. Rengut guna nyama bandi gunika yamba wakéndi, ‘Naniré Godna hundika wakwekwa du di.’ Wungi wakéndi, wuni hafu guniré Godna hundika wakwekwa du wuni. ");
INSERT INTO wos_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Anwarmbu rekwa du guna yafa dé natafa male dé. Rendéka guni ané héfambu rekwa duka ‘Nana yafa dé’ nakénguni. ");
INSERT INTO wos_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Guna néma du wuni God wasékendén du Krais wuni. Wungi xékélakita guni nak duka, ‘Nana néma du dé’ nakénguni. ");
INSERT INTO wos_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Guna du nak néma du renjoka mawuli yata dé guna jémba yakwa du retandé. ");
INSERT INTO wos_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Deka ximbu harékékwa du takwa hukémbu God wandét di baka du takwa retandi. Deka ximbu harékéhafi yakwa du takwa hukémbu God wandét di néma du takwa retandi.” ");
INSERT INTO wos_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","Wun hundi wataka dé Jisas xékélelakikwa duka akwi, Farisika akwi dé angi wa: “Guni xékélelakikwa du akwi, Farisi akwi, xékélakina! Guni yéna yakwa du guni. Séfélak du takwa Godna hémémbu xakunjoka di mawuli ye. Yandaka guni hundi wanguka xékéta di Godna hémémbu xakunjoka di hurufatiké. Guni akwi Godna hémémbu yamba xakukénguni. ");
INSERT INTO wos_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","“Guni xékélelakikwa du akwi, Farisi akwi, xékélakina! Guni yéna yakwa du guni. Guni du hiya takwana jondu atéfék guni héra. Hérae guni yéna yata némafwi hundi Godka wa, nawula du takwa guniré xe guna ximbu harékéndate. Wungi hurungut némafwi xakéngali gunimbu xakutandé. ");
INSERT INTO wos_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","“Guni xékélelakikwa du akwi, Farisi akwi, xékélakina! Guni yéna yakwa du guni. Guni afaké yambumbu yita némangumbu yita guni guna hundi xékétekwa du nakéka guni hwaké. Hwaka xénguka wun du guna jémba yandéte déré wakwenguka dé séfélak haraki saraki sémbut huru. Hurundén haraki saraki sémbut guna hurungun haraki saraki sémbutré dé sarékéngwandé. Guni akwi dé akwi atéfék haraki hafwaré yitanguni. ");
INSERT INTO wos_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","“Dama hiyandé du dé nak duré yambu wakwenjoka hurufatikéndéka maki, guni du takwaré yikafre yambu wakwenjoka hurufatikétanguni. Guni xékélakina! Guni angi guni we, ‘Du nawulak jémba nak yanjoka tempelna ximbu wasékérékéndat, wu baka joo dé. Hukémbu di mawuli yata wun hundi yatakatandi. Di jémba yanjoka tempelmbu takandan gol motumbu wasékérékéndat, wu néma joo dé. Wandan maki hurutandi. Hukémbu di wun hundi yamba yatakakéndi.’ ");
INSERT INTO wos_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Guni wungi wata guni dama hiyandé wangété du guni. Méta joo némafwi joo dé, tempel dé, o wun tempelmbu rekwa gol dé? Wun gol tempelmbu rehafi yata dé baka gol xakutandé. ");
INSERT INTO wos_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Guni angi akwi guni we, ‘Du nawulak jémba nak yanjoka hamwi xiyae Godka hwendaka jambéna ximbu wasékérékéndat, wu baka joo dé. Hukémbu di mawuli yata wun hundi yatakatandi. Di jémba nak yanjoka wun jambémbu hwandé hamwina ximbu wasékérékéndat, wu néma joo dé. Wandan maki hurutandi. Wun hundi yamba yatakakéndi.’ ");
INSERT INTO wos_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Guni wungi wata guni dama hiyandé du guni. Méta joo némafwi joo dé, Godka hwendan hamwi dé, o Godka hwendaka hamwi hwandé jambé dé? ");
INSERT INTO wos_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Hamwi xiyae Godka hwendaka jambé wu Godna dé. Wun jambémbu hwandé hamwi akwi Godna dé. Du wun jambéna ximbu wasékérékéta di wun jambémbu hwandé hamwina ximbu akwi di wasékéréké. ");
INSERT INTO wos_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","God tempelmbu dé re. Du tempelna ximbu wasékérékéta di Godna ximbu akwi di wasékéréké. ");
INSERT INTO wos_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","God déka anwarmbu rekwa getéfambu dé re. Du Godna getéfana ximbu wasékérékéta di God rendéka jambéna ximbu di wasékéréké. Wungi wasékérékéta di Godna ximbu akwi wasékéréké.” ");
INSERT INTO wos_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","“Guni xékélelakikwa du akwi, Farisi akwi, xékélakina! Guni yéna yakwa du guni. Guni atéfék jondu tamba yétékmbu mune guni també Godka hwe. Wungi hweta guni atéfék nyaa akwi wungi male guni nak també Godka hwe. Nyaa néma joo yingafwe. Wu yikama joo dé. Guni wun yikama jooka sarékéta guni Moses wandén hambuk hundimbu rekwa néma jooka sarékéhambanguni. Guni nawula du takwaré yikafre huruhambanguni. Guni nawula du takwaka mawuli yata saréfa nahambanguni. Guni Godka jémba sarékéhafi yata guni hurunjoka wangun maki huruhambanguni. Guni guna jondu tamba yétékmbu mune també Godka hwengut, wu yikafre dé. Wun joo yatakakénguni. Wun yikama joo huruta guni wayika male wawun némafwi joo akwi huruta guni jémba retanguni. ");
INSERT INTO wos_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Guni dama hiyandé du dé du nakré yambu wakwenjoka hurufatikétanguni. Guni yikama joo hurunjoka guni hambukmbu jémba ye. Néma joo hurunjoka guni yike guni ye. Yike yata ané du maki guni huru. Dé hulingu tuwa sanjoka nyéngwi gumbu hwandéka xékélake dé héreki. Hérekindéka dé kamel bali gumbu hwandéka xékélakihafi ye dé atéfék nyéréké. ");
INSERT INTO wos_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","“Guni xékélelakikwa du akwi, Farisi akwi, xékélakina! Guni yéna yakwa du guni. Guni aki yakwanyita taku male guni yakwanyi. Také yakwanyihambanguni. Yakwanyihafi yanguka také haraki dé té. Guni guna séfika male sarékéta guni du takwana séfélak jondu sélé héranguka guna mawuli haraki dé té, wun akina také haraki tékwangala. ");
INSERT INTO wos_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Guni Farisi, guni dama hiyandé du guni. Guni aki yakwanyita tale také yakwanyitanguni. Wungi yakwanyingut, taku akwi yikafre yatandé. ");
INSERT INTO wos_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","“Guni xékélelakikwa du, Farisi akwi, xékélakina! Guni yéna yakwa du guni. Guni fusa réméndan hwandafu maki guni. Du takwa wun hwandafu takumbu di yikafre jondu taka. Takandaka nawula du takwa xe wun jonduka male sarékéta di wa, ‘Wu yikafre dé.’ Wungi wata di andéla hwandafumbu hwaakwa hiyandé duna afa haraki jonduka akwi xékélakihambandi. ");
INSERT INTO wos_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Guni wungi maki guni. Du takwa guniré xéta di wa, ‘Wu yikafre sémbut hurukwa du di.’ Wungi wata di xékélakihambandi, guna mawulimbu haraki tékwaka. Xékélakihafi yandaka guni yéna yata haraki saraki sémbut guni huru. ");
INSERT INTO wos_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","“Guni xékélelakikwa du akwi, Farisi akwi, xékélakina! Guni yéna yakwa du guni. Godna profet, nawula yikafre sémbut hurukwa du akwi hanja re hiyandaka réméndaka guni réméndan hafwambu yikafre jondu taka. ");
INSERT INTO wos_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Takataka guni wa, ‘Nani nana mandéka rendan nukwa reta, nani, di hurundan maki, Godna profetré yamba hali xiyakwa.’ ");
INSERT INTO wos_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Wungi wata guni diré xiyandé duna mandéka nanguka guna mawuli deka mawuli maki dé té. ");
INSERT INTO wos_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Téndéka di haraki saraki sémbut hurundan maki, guni akwi haraki saraki sémbut mé guni huru, wun sémbut sukwekéndéte. ");
INSERT INTO wos_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Guni haraki saraki sémbut hurukwa du guni. Guni du nakré tikwa hambwe maki reta guni haraki saraki sémbut guni huru. God wandét guni haraki hafwaré yitanguni. Nak hafwaré yaange yinjoka hurufatikétanguni. ");
INSERT INTO wos_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","“Wuni wawut profet nawulak, xékélelakikwa du nawulak, Godna hundika wakwekwa du nawulak akwi gunika yatandi. Wuni xékélaki. Di yandat guni nawulakré xiyatanguni. Nawulakré xiyae mimbu hatekatanguni. Nawulakré guni Godna hundi buléndaka gembu rami yoombu xiyatanguni. Nawulakré nambwangut, di nak nak téfaré yitandi. ");
INSERT INTO wos_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Guni wungi hurungut God hurungun haraki saraki sémbut guniré hasa hwetandé. Hanja guna mandéka séfélak yikafre sémbut hurundé duré di xiya. Tale Kein déka bandi Abelré dé xiya. Xiyandéka guna mandéka yikafre sémbut hurukwa duka hélék yata di diré xiya. Xiyae ye di hukémbu Berekiana nyan déka xi Sekaraiaré akwi di xiya. Dé Godna gena nyéndékmbu téndéka di déré xiya. ");
INSERT INTO wos_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Mwi hundi wuni guniré we. God hurundan haraki saraki sémbutka sarékéta guni deka mandékaré hambukmbu hasa hwetandé. Guni ané nukwa rekwa du, hurundan haraki saraki sémbut guniré hambukmbu hasa hwetandé.” ");
INSERT INTO wos_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Jisas wun hundi wataka angi wa, “Jerusalem, Jerusalem, guni Godna profetré guni xiya. God wandéka déka profet gunika yindaka guni diré motumbu xiyanguka di hiya. Gunika wuni saréfa nae. Séra héralén nyanka sarékto reta dika jémba hatiléka maki, wuni séfélak nukwa guniré yikafre huruta gunika jémba hatinjoka wuni mawuli ye. Mawuli yawuka guni wunika hélék ye. ");
INSERT INTO wos_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Mé xéké, hukémbu du nawulak yae guna getéfaré haraki hurutandi. Haraki hurundat guni wumbu yamba rekénguni. Guna getéfa baka hafwa tétandé. ");
INSERT INTO wos_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Wuni guniré angi wuni we. Guni wuniré wambula yamba xékénguni. Hukémbu guni wunika angi watanguni, ‘God wandéka dé wun du ya. Nani déka ximbu harékétame.’ Wungi wangut wuni wambula yawut guni wuniré wambula xétanguni.” Wungi dé Jisas wa. ");
INSERT INTO wos_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Jisas tempel yatakataka yinjoka yindéka di déka du déka ya. Yae di déré wa, “Mé xé. Ané ge yikafre ge dé.” ");
INSERT INTO wos_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Wungi wandaka dé diré wa, “Xéxé, némbuli wun ge yikafre dé. Yikafre moturé takandaka nani xé. Mwi hundi wuni guniré we. Hukémbu du yae ané geré haraki hurutandi. Haraki huruta di wunde motu hérae yakisandandat, wun motu nak motu takumbu yamba hwakéndé.” ");
INSERT INTO wos_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Wun hundi wataka dé Jisas tempel yatakataka ye dé Oliv némburé wari. Wara rendéka déka du male déka ye di déré wakwexéké, “Naniré mé wa. Yimba nukwa tempelré haraki hurutandi? Méta joo tale yandét, xétaka angi watame, ‘Xéxé, némbuli Jisas wambula yatendéka nukwa bari yatandé. Yandét ané héfa bari hényitandé.’ Yimba nukwa nani wungi watame?” ");
INSERT INTO wos_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Wungi wakwexékéndaka dé Jisas wa, “Guni xékélaki natanguni. Xékélaki naata yéna yakwa duna hundi xékékénguni. ");
INSERT INTO wos_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Séfélak du yae di guniré yéna yanjoka mawuli yatendakaka wuni wun hundi wuni we. Yéna yata wuna ximbu wata di nak nak angi watandi, ‘Wuni God wasékendén du Krais wuni.’ Wungi wandat séfélak du takwa yéna yandaka hundi xékétandi. ");
INSERT INTO wos_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Séfélak du waretandi. Warendat nawulak du warendakaka bulétandi. Buléndat xékéta guni rookénguni. Di wungi hurundat, hukétéfi nukwa bari yamba yakéndé. ");
INSERT INTO wos_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Nak héfambu rekwa du takwa di nak héfambu rekwa du takwa wali waretandi. Nak néma duna hém nak néma duna hém wali waretandi. Séfélak héfambu du takwa hénoo wali re hiyatandi. Séfélak héfambu séfélak nukwa némafwi nono yatandé. ");
INSERT INTO wos_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Wun xakéngali wu takwa nyan tale héranjoka yikama hangéli hérandaka maki dé. Détakwa némafwi hangéli hurutendaka maki, hukémbu némafwi xakéngali akwi xakutandé.” ");
INSERT INTO wos_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","“Guni wuna du renguka atéfék héfambu rekwa du takwa gunika hélék yatandi. Yata guniré hérae hura ye guniré haraki huruta xiyatandi. ");
INSERT INTO wos_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Wun nukwa séfélak du takwa wunika hu hwetandi. Séfélak du takwa deka du takwaka hélék yata diré deka mamaka hwetandi. ");
INSERT INTO wos_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Hukémbu séfélak du yae nak nak yéna yata angi watandi, ‘Wuni Profet wuni.’ Wungi wata yéna yandat, séfélak du takwa deka hundi xékétandi. ");
INSERT INTO wos_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Séfélak du takwa séfélak haraki saraki sémbut hurutandi. Huruta di yikafre mawuli yatakataka di nak du takwaka némafwimbu mawuli yamba yakéndi. ");
INSERT INTO wos_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Wun nukwa wuna du takwa deka mawulimbu hambuk yata wuna jémba hurundat, hukémbu God diré hérandét di dé wali jémba retandi, wungi re wungi re. ");
INSERT INTO wos_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Wuna du takwa atéfék getéfaré yita atéfék héfambu rekwa du takwaré wuna hundi angi watandi, ‘God néma du reta du takwaka jémba hatitandé.’ Wungi wandat hukémbu hukétéfi yatekwa nukwa yatandé.” Wungi dé Jisas wa. ");
INSERT INTO wos_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","Wun hundi wataka dé Jisas angi wa: “Hanja Godna profet nak déka xi Daniel dé ané hundi hayi: Hukémbu du nak yae Godna tempel nyéndémbu haraki saraki joo nak takatandé. Takandét tempel haraki ye baka tétandé. Wungi hayindén joo xakundét guni xétanguni. (Guni ané nyinga xéta ané jooka jémba sarékétanguni.) ");
INSERT INTO wos_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Xéta wun nukwa guni Judiambu rekwa du takwa guna getéfa yatakataka némburé bari yaange yitanguni. ");
INSERT INTO wos_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Wun nukwa hafwambu rekwa du takwa bari yaange yitandi. Deka jondu héranjoka deka geré wambula yamba yikéndi. Baka yaange yitandi. ");
INSERT INTO wos_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Yawimbu tékwa du takwa getéfaré wambula ye nukwa wur nawulak akwi yamba hérakéndi. Bari yaange yitandi. ");
INSERT INTO wos_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Wun haraki nukwa nyan tékwa takwa, nyangwalka munya hwekwa takwa bari yaange yinjoka hurufatikétandi. Dika wuni saréfa nae. ");
INSERT INTO wos_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Wun haraki nukwa yifa yakwa nukwambu yandét, yingi maki ye guni bari yaange yitanguni? Wun haraki nukwa baka hwa nukwambu yandét, yingi maki ye guni bari yaange yitanguni? Yitengukaka sarékéta guni Godré watanguni, wun haraki nukwa yifa yakwa nukwambu akwi baka hwa nukwambu akwi yahafi yandéte. ");
INSERT INTO wos_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Wun nukwa némafwi xakéngali xakutandé. Wun xakéngali atéfék néma xakré sarékéngwandétandé. Hanja God atéfék jondu huratakandén nukwa wungi maki xak nawulak xakuhambandi. Némbuli akwi hukémbu akwi wungi maki xak wambula yamba xakukéndé. ");
INSERT INTO wos_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Wun némafwi xakéngali xakundét God dé wasékendén du takwaka saréfa naata wandét wun xakéngali bari hényitandé. Wungi wahafi yandét atéfék du takwa hiyatandi.” ");
INSERT INTO wos_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","“Wun nukwa du nawulak guniré angi wandat, ‘Ané duré mé xé. God wasékendén du Krais wumbu dé re.’ Wungi wandat, guni deka hundi yamba xékékénguni. Di yéna di ye. ");
INSERT INTO wos_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Séfélak yénataka Krais akwi yénataka profet akwi xakutandi. Xaakwa di God wasékendén du takwaré yéna yanjoka di nak maki nak maki hambuk jémba akwi, hanja xéhafi yangun hambuk jémba akwi yatandi. Di God wasékendén du takwaré yéna yanjoka hurufatikétandi. ");
INSERT INTO wos_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Guniré wuni we, hukémbu xakutekwa jonduka. Hukémbu wun jondu xakundét guni xéta xékélakita guni deka hundi xékékénguni.” ");
INSERT INTO wos_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","“Du takwa nawulak guniré watandi, ‘Mé xé. God wasékendén du Krais dé du rehafi hafwambu dé re.’ Wungi wandat, guni wun hafwaré yikénguni. Di guniré watandi, ‘Mé xé. God wasékendén du Krais wun gekombu dé re.’ Wungi wandat, guni deka hundi xékékénguni. ");
INSERT INTO wos_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Wuni Duna Nyan wambula gayawut, atéfék du takwa xétandi. Nyir tulem nandéka atéfék du takwa xéndaka maki, guni atéfék wuni gayawut xétanguni. Wungi xétengukaka sarékéta guni deka yénataka hundi xékékénguni.” ");
INSERT INTO wos_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Wungi wataka dé Jisas ané hundi wa, “Barokwaru jindaka xéta guni xékélaki, hiyandé hamwi nak rendéka. Wun jooka xékélakinguka maki, guni wawun joo xéta xékélakitanguni, wuni wambula yatewukaka.” ");
INSERT INTO wos_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","Wun hundi wataka dé Jisas angi wa: “Wun xakéngali hényindét bari nukwa xéhafi yandét gan hunyitandé. Hunyindét bafu akwi xéhafi yalét, hunkwari nyirmbu xakritandi. Xakrindat nyirmbu tékwa atéfék jondu séngénéta yitaka yatakatandi. ");
INSERT INTO wos_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Yitaka yatakandat, ané héfambu rekwa atéfék du takwa hanja xéhafi yandan hambuk joo xétandi nyirmbu. Xe wunika xékélakita gératandi. Géraata di wuni Duna Nyanré xétandi. Wuni némafwi hambuk wali yaata nukwa hanyikwa maki yaata buwimbu re gayawut xétandi. ");
INSERT INTO wos_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Xéndat wawut nyirmbu rekwa ensel nak fuli némafwimbu yondét, wuna ensel atéfék héfambu tékwa getéfaré ye Godna du takwaré hérae hari natafambu takatandi.” ");
INSERT INTO wos_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","Wun hundi wataka dé Jisas angi wa: “Mika jémba mé saréké. Mi nawulak ganga fiyae huli ganga hunyalandéka xe guni xékélaki. Hénoo naré yakwa nukwa andé yae. ");
INSERT INTO wos_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Wun miré xe nukwaka xékélakinguka maki, guni wawun jonduré xe xékélakitanguni. Wuni bari hari wambula yatawuni. Wungi xékélakitanguni. ");
INSERT INTO wos_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Mwi hundi wuni guniré we. Ané hém hiyahafi re wawun atéfék jondu xétandi. ");
INSERT INTO wos_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Nyir héfa akwi hényitandé. Wuna hundi yamba hényikéndé. Wungi retandé. ");
INSERT INTO wos_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","“Yimba nukwa wambula yatawuni? Ané héfambu rekwa du takwa wun nukwaka xékélakihambandi. Ensel wun nukwaka xékélakihambandi. Wuni Godna nyan reta wuni akwi xékélakihambawuni. Wuna yafa dé hafu dé wambula yatewuka nukwaka xékélaki. ");
INSERT INTO wos_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Hanja Noa rendén nukwa du takwa hurundan maki, wambula yatewuka nukwa du takwa wungi male hurutandi. ");
INSERT INTO wos_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Noa rendén nukwa némafwi hwe gwandéhafi yandéka du takwa di Godka sarékéhafi yata ané héfana jonduka male di saréké. Sarékéta hénoo sata, hulingu sata, takwa héraata, wungi yandaka dé Noa némafwi gunjambé hurutaka dé wun gunjambéré wulayi. ");
INSERT INTO wos_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Wunde du takwa Godka sarékéhafi yata némafwi hwe yatendéka nukwaka sarékéhambandi. Sarékéhafi yandaka némafwi hwe gwandéndéka di hulingu se di atéfék hiya. Wuni Duna Nyan wambula yatewuka nukwa séfélak du takwa wunde du takwa hurundan maki, ané héfana jonduka male sarékétandi. ");
INSERT INTO wos_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Wambula yatewuka nukwa du yéték yawimbu jémba yata témbét, ensel nakré héraata nakré yatakatandi. ");
INSERT INTO wos_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Wun nukwa takwa yéték hénoo humbwita rembét, ensel hésiré héraata hésiré yatakatandi. ");
INSERT INTO wos_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Di wungi hératendakaka guni wunika jémba haxéta re xétanguni. Wuni guna Néma Du yatewuka nukwaka xékélakihambanguni. Xékélakihafi yata guni wunika haxéta re xétanguni. ");
INSERT INTO wos_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Ané sataku hundi mé jémba xéké. Sélé héraakwa du yatendéka nukwaka gena yafa xékélakita dé xéndi hwahafi yata haxéta huli rendét, sélé héraakwa du dé déka ge yamba héréka wulayikéndé. ");
INSERT INTO wos_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Wun hundika sarékéta guni wunika haxéta re xétanguni. Guni xékélakihambanguni. Yimba nukwa wuni Duna Nyan wambula yatawuni? Duna Nyan yatendéka nukwaka guni angi watanguni, “Dé yamba yakéndé.” Wungi wangun nukwambu male wambula yatawuni. Wungi yatewukaka sarékéta guni wunika haxéta re xétanguni.” ");
INSERT INTO wos_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Wun hundi wataka dé Jisas angi wa: “Yikafre mawuli yata yikafre jémba yakwa du angi hurutandé. Déka néma du déré angi watandé, ‘Méni wuna jémba yakwa duka hatitaméni. Hatita méni dika hénoo mune hwetaméni, di satendaka nukwambu.’ Wungi wataka yindét dé wungi hatitandé. ");
INSERT INTO wos_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Hatindét hukémbu déka néma du wambula yae xéta watandé, ‘Méni yikafre jémba méni ya. Wu yikafre dé.’ Wungi wandét yikafre jémba yakwa du yikafre mawuli yata jémba retandé. ");
INSERT INTO wos_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Déka néma du yandén yikafre jémbaré xéta watandé, ‘Méni wambula yatewuka nukwaka xékélakihafi yata, méni yikafre jémba méni ya. Wu yikafre dé. Némbuli méni wuna atéfék jonduka jémba hatitaméni.’ Wungi watandé. ");
INSERT INTO wos_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Haraki saraki mawuli yata haraki saraki jémba yakwa du déka mawulimbu angi watandé, ‘Wuna néma du nak getéfaré ye dé bari wambula yamba yakéndé.’ ");
INSERT INTO wos_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","Wungi wataka dé dé wali jémba yakwa duré xiyatandé. Xiyataka dé wangété yandaka hulingu sakwa du wali reta hénoo sata wangété yandaka hulingu sata dé wangété yatandé. ");
INSERT INTO wos_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Wangété yata déka néma duka sarékéhafi yandét, wun nukwa déka néma du wambula yatandé. Xékélakihafi yatendéka nukwa wambula yatandé. ");
INSERT INTO wos_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Yae wun jémba yakwa du hurundén haraki saraki sémbutré xe déré hambukmbu xiyatandé. Xiyaata wandét dé ye yéna yakwa du wali retandé, haraki hafwambu. Wun hafwambu retekwa du takwa néma hangéli héraata gératandi. Yikafre hafwambu renjoka mawuli yata di hambukmbu gératandi.” Wungi dé Jisas sataku hundi wa. ");
INSERT INTO wos_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Wun hundi wataka dé Jisas angi hundi wa: “Wambula yatewuka nukwa God néma du reta du takwaka hatitendéka angi dé. Du nak takwa héranjoka dé ya. Yandéka wayikana takwa tamba yéti deka lam hérae hura di déré xéta hura ye du takwa hérandét hénoo sanjoka di yambumbu yi. ");
INSERT INTO wos_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Wunde takwa natamba xékélakikwa takwa di. Takwa natamba di wangété takwa di. ");
INSERT INTO wos_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Wangété takwa di deka lam hura yita di ya xéréké hulingu nawulak akwi hura yihambandi. ");
INSERT INTO wos_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Hura yihafi yandaka di xékélakikwa takwa deka lam hura yita ya xéréké hulingu nawulak akwi di hura yi. ");
INSERT INTO wos_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Ye yambumbu rendaka dé takwa hératekwa du bari yahambandé. Yahafi yandéka wunde takwana dama xéndi yandéka di hwa.” ");
INSERT INTO wos_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","“Nyéndé gan du nak dé angi némafwimbu wa, ‘Mé xé. Takwa hératekwa du andé yae. Guni ye yambumbu déré xe guni hura yatanguni.’ ");
INSERT INTO wos_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Wungi wandéka wun hundi xékétaka di wunde takwa atéfék waréngéna raama di deka lamna wik husoré. ");
INSERT INTO wos_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Husoréndaka di wangété takwa di xékélakikwa takwaré wa, ‘Guni nanika ya xéréké hulingu nawulak mé hwe. Nana lam hiyatandé.’ ");
INSERT INTO wos_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Wungi wandaka di xékélakikwa takwa diré wa, ‘Yingafwe! Ané ya xéréké hulingu nawulak male dé té. Nani gunika gu nawulak hwembet, nana lam atéfék hiyatandé. Guni sétoaré sé ye guni nawulak héra.’ ");
INSERT INTO wos_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Wungi wandaka di wun hulingu héranjoka yindaka dé takwa hératekwa du ya. Yandéka di xékélakikwa takwa déré hura ye di hénoo satendaka geré wulayi. Wulayindaka di gena yambu téfi.” ");
INSERT INTO wos_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","“Hukémbu wangété takwa yae di wa, ‘Néma du, néma du, nanika yambu mé nafwimét bu gwandekwa.’ ");
INSERT INTO wos_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Wungi wandaka dé takwa hératekwa du diré wa, ‘Yingafwe. Mwi hundi wuni guniré we. Wuni gunika xékélakihambawuni.’ Wungi dé wangété takwaré wa.” ");
INSERT INTO wos_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Wun hundi wataka Jisas dé diré wa, “Wun hundika sarékéta wunika akwi mé saréké. Wambula yatewuka nukwaka guni xékélakihambanguni. Xékélakihafi yata guni wunika haxéta re xétanguni.” ");
INSERT INTO wos_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Wun hundi wataka dé Jisas ané sataku hundi wa: “Wambula yatewuka nukwa God néma du reta du takwaka hatitendéka angi dé. Néma du nak dé nak getéfaré yinjoka déka jémba yakwa duré wandéka yandaka dé diré wa, di déka yéwa hérae wun yéwa wali jémba yandate. ");
INSERT INTO wos_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Wataka deka hambukéka xékélakita dé dika nak nak yéwa mune hwe. Nakéka dé dumi natamba bangi yéwa hwe (K5,000). Nakéka dé dumi yéték bangi yéwa hwe (K2,000). Nakéka dé dumi natafa bangi yéwa hwe (K1,000). Wungi hwetaka dé yi. ");
INSERT INTO wos_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Yindéka bangi natamba yéwa hérandé du bari ye wun yéwambu jémba ye dé yéwa nawulak akwi héra. ");
INSERT INTO wos_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Bangi yéték yéwa hérandé du dé akwi wun yéwambu jémba ye dé yéwa nawulak akwi héra. ");
INSERT INTO wos_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Bangi natafa yéwa hérandé du dé wun yéwambu jémba yahambandé. Dé hari wun yéwa wekwa xae dé rémétaka. ");
INSERT INTO wos_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","“Hukémbu séfélak bafu yindéka dé néma du wambula ya, déka jémba yakwa duka. Yae dé dika hwendén yéwaka dé di wali hundi bulé. ");
INSERT INTO wos_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Buléndéka dé bangi natamba yéwa hérandé du wun yéwa hura yae hweta dé wa, ‘Néma du, méni wunika bangi natamba yéwa méni hwe. Némbuli mé xé. Wun yéwambu jémba ye wuni bangi natamba akwi héra.’ ");
INSERT INTO wos_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Wungi wataka bangi tamba yéték yéwa hwendéka dé déka néma du wa, ‘Méni yikafre jémba yakwa du méni. Mawuli yawuka makimbu méni jémba ya. Méni yikama jooka méni jémba hati. Hatimékaka wawut méni séfélak jonduka néma du retaméni. Méni wuni wali reta, ani yikafre mawuli yata jémba retaani.’ ");
INSERT INTO wos_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","“Dé wungi wandéka dé bangi yéték yéwa hérandé du yae dé wa, ‘Néma du, méni wunika bangi yéték yéwa méni hwe. Némbuli mé xé. Wun yéwambu jémba ye wuni bangi yéték yéwa akwi héra.’ ");
INSERT INTO wos_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Wungi wataka bangi yétiyéti yéwa (4,000) hwendéka dé déka néma du wa, ‘Méni yikafre jémba yakwa du méni. Mawuli yawuka makimbu méni jémba ya. Méni yikama jooka méni jémba hati. Hatiméka wuni wawut méni séfélak jonduka néma du retaméni. Méni wuni wali reta, ani yikafre mawuli yata jémba retaani.’ ");
INSERT INTO wos_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","“Dé wungi wandéka dé bangi natafa yéwa hérandé du yae dé wa, ‘Néma du, wuni ménika wuni xékélaki. Méni du takwaka saréfa nahafiméni. Méni sehafi yamén yawimbu méni hénoo hérae. Méni jémba yahafi yamén héfambu méni jondu hérae. ");
INSERT INTO wos_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Wuni ménika roota wuni héfambu wekwa xae ména yéwa rémé. Wambula hérae wuni ména yéwa ménika wuni hura ya. Mé héra.’ ");
INSERT INTO wos_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Wungi wandéka dé néma du déka wa, ‘Méni haraki sémbut huruta jémba yahafi du méni. Méni wunika angi méni saréké. Wuni du takwaka saréfa nahafiwuni. Wuni sehafi yawun yawimbu wuni hénoo hérae. Wuni jémba yahafi yawun héfambu wuni jondu hérae. ");
INSERT INTO wos_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Wungi sarékéta métaka méni wuna yéwa hura ye yéwa takandaka gembu takahafi ya? Méni wumbu takamét wuni wambula yae wun yéwa héraata yéwa nawulak akwi hératawuni.’ ");
INSERT INTO wos_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Wungi wataka dé jémba yakwa du nakré wa, ‘Guni déka hwewun yéwa hérae guni bangi tamba yéti yéwa hérandé duka hwetaméni. ");
INSERT INTO wos_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Wuni jondu hérandé duka hwewut, dé séfélak jondu hératandé. Du nak joo hérahafi yandét, wuni déka takandén joo hérawut dé baka retandé.” ");
INSERT INTO wos_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Wumba haraki saraki jémba yandé duré hérae hafwaré yakisangwandétanguni. Yakisangwandéngut dé halékingambu retandé. Wun hafwambu retekwa du takwa néma hangéli héraata némbi tita gératandi.’ Wungi dé néma du wa.” ");
INSERT INTO wos_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Wun hundi wataka dé Jisas angi wa: “Hukémbu Duna Nyan némafwi hambuk héraata nukwa hanyikwa maki hanyita yatandé, déka ensel wali. Yae dé yikafre male jambémbu néma du retandé. ");
INSERT INTO wos_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Dé wandét ané héfambu rekwa atéfék du takwa déka makambu hérangwandéndat dé diré xarémonitandé, sipsip balika hatikwa du xarémonindéka maki. Sipsip balika hatikwa du dé jémba yata sipsip bali meme bali xarémonindéka di sipsip bali nak hafwaré yindaka di meme bali nak hafwaré di yi. ");
INSERT INTO wos_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Wungi xarémonindét di sipsip bali déka yika tambambu téndat, di meme bali déka aki tambambu tétandi. ");
INSERT INTO wos_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Téndat wun néma du déka yika tambambu tétekwa du takwaka angi watandé, ‘Wuna yafa God guniré dé yikafre huru. Hanja ané hafwa huratakataka dé guna jémba retenguka hafwa dé jémba huru. Némbuli wun hafwaré sa guni wulayi. ");
INSERT INTO wos_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Hanja wuni hénoo wali rewuka guni wunika hénoo hwe. Hulinguka hiyawuka guni wunika hulingu hwe. Wuni nak téfambu yawuka guni wunika xékélakihafi yata wuniré yikafre huruta guna geré hura yi. ");
INSERT INTO wos_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Wuni nukwa wur yike baka téwuka guni wunika nukwa wur hwenguka wuni naki. Wuni bar hiyawuka guni wuniré yikafre huru. Wuni séndé gembu hwawuka guni yae guni wuniré xé. Wungi hurungunka némbuli yikafre hafwambu jémba retanguni.’ ");
INSERT INTO wos_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","“Wungi wandét yikafre sémbut hurukwa du takwa angi watandi, ‘Néma Du, yinga nukwa méni hénoo wali reméka nani ménika hénoo hwe? Yinga nukwa méni hulinguka hiyaméka nani ménika hulingu hwe? ");
INSERT INTO wos_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Yinga nukwa méni nak téfambu yaméka nani méniré nana geré hura yi? Yinga nukwa méni nukwa wur yike baka téméka nani ménika nukwa wur hwe? ");
INSERT INTO wos_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Yinga nukwa méni bar hiyaméka nani méniré yikafre huru? Yinga nukwa méni séndé gembu hwaméka nani méniré xénjoka yi?’ ");
INSERT INTO wos_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Wungi wakwexékéndat dé néma du dika angi watandé, ‘Mwi hundi wuni guniré we. Guni wuna hundika xékékwa baka du takwa nakéka yikafre huruta guni wunika akwi yikafre guni huru.’ ");
INSERT INTO wos_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","“Wungi wataka dé déka aki tambambu tétekwa du takwaka angi watandé, ‘God gunika hu wundé hwendé. Némbuli guni wuniré yatakataka ya yanékwa hafwaré yitanguni. Wun ya yamba hiyakéndé. Hanja God wun hafwa hurataka dé wa, Satan déka du wali wun haraki hafwambu rendate. Wandén hafwaré yitanguni. ");
INSERT INTO wos_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Hanja wuni hénoo wali rewuka guni wunika hénoo hwehambanguni. Hulinguka hiyawuka guni wunika hulingu hwehambanguni. ");
INSERT INTO wos_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Wuni nak téfambu yawuka guni wuniré guna geré harihambanguni. Wuni nukwa wur yike baka téwuka guni wunika nukwa wur hwehambanguni. Wuni bar hiyawuka, séndé gembu akwi hwawuka guni wunika yae xéhambanguni.’ ");
INSERT INTO wos_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","“Wungi wandét di akwi watandi, ‘Néma Du, yinga nukwa méni hénoo hulinguka hiyaméka xe nani ménika hénoo hulingu hwehafi ya? Yinga nukwa méni nak téfambu yaméka, nukwa wur yike baka téméka, méni bar hiyaméka, séndé gembu hwaméka, xe nani méniré yikafre huruhafi ya?’ ");
INSERT INTO wos_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Wungi wandat néma du dika angi watandé: ‘Mwi hundi wuni guniré we. Guni wuna hundi xékékwa baka du takwa nakéka yikafre huruhafi yata guni wunika akwi yikafre huruhafi ya. Dika hu hweta wunika akwi guni hu hwe.’ ");
INSERT INTO wos_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","“Dé wungi wandét di haraki hafwaré yitandi. Ye némafwi hangéli héraata di wumbu retandi, wungi re wungi re. Di rendat di yikafre sémbut hurundé du takwa yikafre getéfaré ye wungi re wungi re jémba retandi.” Wungi dé Jisas wa. ");
INSERT INTO wos_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Jisas wun hundi wataka dé déka duré ané hundi wa. ");
INSERT INTO wos_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Guni xékélaki. Nukwa yéték male re nani Juda Pasovana hénoo humbwe satame. Wun nukwa di Duna Nyanré wuna mamaka hwendat di wuniré xiyae mimbu hatekatandi.” Wungi dé diré wa. ");
INSERT INTO wos_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Wun nukwa prisna néma du akwi, getéfana néma du akwi ye atéfék prisna néma duna néma gembu hérangwanda di re. Wun néma duna xi Kaiafas dé. ");
INSERT INTO wos_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Reta hundi di bulé, di nakélak ye Jisasré huluke xiyanjoka. Buléta wungi hurunjoka di hundi gi. ");
INSERT INTO wos_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Reta di angi wa, “Déré xiyatame. Némafwi hénoo humbwe satembeka nukwa déré yamba hulukikéme. Némbuli séfélak du takwa wun hénoo sanjoka ané getéfaré di ya. Némbuli nani Jisasré hulukimbet, di mawuli wita naniré haraki hurutandi. Di yindat nani déré huluke xiyatame.” Wungi di wa. ");
INSERT INTO wos_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Jisas Jerusalem yatakataka dé Betaniré yi. Ye xaakwa dé hanja walisufu hurundé du déka xi Saimon déka gembu dé re. ");
INSERT INTO wos_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Di hénoo sata rendaka lé takwa hési motumbu yatakandan yikama andé hura ya. Wun andémbu yikafre yama xaakwa hulingu dé té. Du wun hulingu héranjoka séfélak yéwa hwetandi. Wule takwa yae lé Jisas rendénmbu téta lé déka anéngambambu wun hulingu bleké. ");
INSERT INTO wos_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Blekéléka di Jisasna du xe di rékambambu wa. Wata di wa, “Métaka lé wun hulingu baka bleké? ");
INSERT INTO wos_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Wun hulingu wu yikafre hulingu dé. Lé wun hulingu hwetaka séfélak yéwa hérae jambangwe du takwaka hwelét, wu yikafre dé.” ");
INSERT INTO wos_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Jisas deka hundi xékétaka dé diré wa, “Métaka guni wule takwaka haraki hundi we? Wungi wakénguni. Lé yikafre joo lé huru, wunika. ");
INSERT INTO wos_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Jambangwe du takwa di guni wali retandi, wungi re wungi re. Guni dika mawuli yata dika yikafre hurutanguni. Wuni guni wali wungi re wungi re yamba rekéwuni. ");
INSERT INTO wos_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Wule takwa wuni hiyawut wekwambu rémétendakaka sarékéta lé wun hulingu wuna séfimbu bleké.” Wungi wata dé Juda fusa réméndaka sémbutka dé wa. ");
INSERT INTO wos_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Wataka dé diré angi wa, “Mwi hundi wuni guniré we. Hukémbu di wuna hundi atéfék héfambu wata ale takwa hurulén jooka akwi watandi. Wata léka sarékétandi.” Wungi dé diré wa. ");
INSERT INTO wos_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Wun nukwa dé Jisasna du nak déka xi Judas Iskariot dé prisna néma duka yi. ");
INSERT INTO wos_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","Ye dé diré wa, “Guni wunika méta hwengut wuni Jisasré gunika hwetawuni?” Wungi wandéka di déka bangi hufuk yéwa (K30) hwe. ");
INSERT INTO wos_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Hwendaka ye dé Jisasré dika hwetendékaka dé saréké. Sarékéta dé wun jooka buléhafi yata déré hwetendéka yambuka dé hwaké. ");
INSERT INTO wos_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Pasovana hénoo humbwe sa nukwa di Juda yis takahafi yandan bret male di sa. Wun nukwa yandéka yis takahafi yandan bret tale humbwindan nukwa Jisasna du déka yae di wa, “Yimbu reta Pasovana hénoo humbwe sambete méni we?” ");
INSERT INTO wos_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Wungi wandaka dé wa, “Guni Jerusalemré wulaaye hanja wawun duré xe déré watanguni, ‘Nana wakwekwa du angi dé wa, Wuni hiyatewuka nukwa andé yae. Wuni wuna du wali ména gembu Pasovana hénoo satame.’ Wungi watanguni, déré.” ");
INSERT INTO wos_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Wungi wandéka di Jisasna du wandén maki ye di hénoo humbwi. ");
INSERT INTO wos_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Nukwa nandindéka dé Jisas yae déka du tamba atéfék ye man yéték wungi di wali reta di hénoo sa. ");
INSERT INTO wos_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Sata dé diré wa, “Mwi hundi wuni guniré we. Nani wali rekwa du nak wuniré wuna mamaka hwetandé.” ");
INSERT INTO wos_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Wungi wandéka xékétaka di biya mawuli xak yandéka waréngéna di nak nak déré wakwexéké, “Néma Du, wu wunika méni we, o héndéka?” ");
INSERT INTO wos_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Wungi wakwexékéndaka dé wa, “Wuni wali andémbu tékwa gumbu bret husandatekwa du wuniré mamaka hwetandé. ");
INSERT INTO wos_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Wuni Duna Nyan hiyatawuni. Godna nyingambu hiyatewukaka hanjambu di hundi hayi. Hiyawut haraki saraki xakéngali xakutandé, wuniré mamaka hwetekwa duka. Wun duré déka ayiwa hérahafi yalét, wu yikafre dé.” ");
INSERT INTO wos_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Wungi wandéka dé Jisasré mamaka hwetekwa du Judas dé wa, “Néma du, wu wunika méni we, o yingi maki dé?” Wungi wandéka dé Jisas déré wa, “Xéxé. Méni hafu wundé wamé.” Wungi dé Jisas wa. ");
INSERT INTO wos_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Jisas déka du wali hénoo sata reta dé bret hérae dé Godka diména nataka bret fukae dé déka duka hweta dé wa, “Guni mé hérae sa. Ané wuna séfi dé.” ");
INSERT INTO wos_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Wungi wataka dé wain hulingu téndé hanyandé nak hérae dé Godka diména nataka dé déka duka hweta dé wa, “Guni atéfék ané wain hulingu mé hérae sa. ");
INSERT INTO wos_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Ané wuna nyéki dé. Di wuniré xiyandat wuna nyéki blekéndét guni xéta xékélakitanguni, God du takwaré yikafre hurunjoka wasékérékéndén hundi mwi hundi yandéka. Wuna nyéki blekéndét God séfélak du takwa hurundan haraki saraki sémbut yakwanyitandé. ");
INSERT INTO wos_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Guniré wuni we. Ané héfambu wayika reta wuni wain hulingu wambula yamba sakéwuni. Hukémbu wuna yafa God du takwaka néma du rendét, nani déka getéfambu dé wali reta wuni guni wali huli wain hulingu satawuni.” ");
INSERT INTO wos_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Wun hundi wandéka di Godna nyingambu rekwa gwar wataka raama gwande di Oliv némburé wari. ");
INSERT INTO wos_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Di yambumbu yita dé Jisas déka duré wa, “Némbuli gan guni atéfék wunika hu hweta yaange yitanguni. Wungi wuni xékélaki. Yaange yitengukaka Godna nyingambu angi dé wa: Wuni sipsip balika hatikwa duré xiyawut, di sipsip bali yaange yitandi. ");
INSERT INTO wos_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Wun hundi wandéka maki yaange yingut, wuni hiyatawuni. Hiyae hukémbu wambula raama wuni Galiliré tale yitawuni. Yiwut guni hukémbu yatanguni.” ");
INSERT INTO wos_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Wungi wandéka dé Pita déré wa, “Wuni ménika yamba hu hwekéwuni. Wuni yamba yaange yikéwuni. Nawulak du ménika hu hweta yaange yindat, wuni wungi yamba yikéwuni.” ");
INSERT INTO wos_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Wungi wandéka dé Jisas wa, “Mwi hundi wuni méniré we. Némbuli gan séra wahafi yandét, méni yambu hufuk angi wataméni, ‘Wuni Jisaska xékélakihambawuni.’ Wungi wamét séra watandé.” ");
INSERT INTO wos_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Wungi wandéka dé Pita wa, “Yingafwe. Wungi yamba wakéwuni. Wuni méni wali hiyanjoka yamba rookéwuni. Wungi yamba wakéwuni.” Wungi wandéka Jisasna du atéfék wungi male di wa. ");
INSERT INTO wos_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Wun hundi wataka Jisas déka du wali wungi di hafwa nakré wulayi. Wun hafwana xi Getsemani dé. Wumbu téta dé diré wa, “Guni ambu re. Wuni ye God wali hundi bulétawuni.” ");
INSERT INTO wos_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Wungi wataka dé Pita, Sebedina nyan yétékré hura di yi. Yindaka dé déka biya mawuli némafwi xak yandéka dé xékélaki. ");
INSERT INTO wos_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Xékélakita dé diré wa, “Wuna biya mawuli xak yandéka hiyawata wuni huru. Guni ambu retanguni. Xéndi hwakénguni.” ");
INSERT INTO wos_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Wungi wandéka di rendaka dé yalefu ye héfambu xakre hwaata dé Godka wa, “Wuna yafa, huruteméka yambu rendét, ané wunika yaakwa hanyandé mé héreki. Wungi ménika wuni we. Méni wuna mawuli yawukangalambu yamba hurukéméni. Méni mawuli yamékangalambu hurutaméni.” ");
INSERT INTO wos_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Wun hundi wataka dé déka duka wambula ye dé xé, di xéndi hwandaka. Xe dé diré sérkena dé Pitaré wa, “Yingi maki dé? Guni yikama nukwa wuni wali renjoka guni hurufatiké. Métaka guni xéndi hwae? ");
INSERT INTO wos_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Guni xéndi hwahafi reta jémba sarékéta Godka mé wa, guniré hurukwexé haraki joo yandémboka. Wuni xékélaki. Guni huli renjoka mawuli yanguka guna séfi hambuk yahafi yandéka guni xéndi hwae.” ");
INSERT INTO wos_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Wungi wataka wambula diré yatakataka yalefu ye dé Godka angi wa, “Wuna yafa, wunika yatekwa haraki hanyandé wunika yandét, yamba talékakéwuni. Wun hanyandémbu satawuni. Méni mawuli yamékangalambu hurutaméni.” ");
INSERT INTO wos_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Wungi wataka déka duka wambula ye dé xé, di wambula xéndi hwandaka. Deka dama xak yandéka di xéndi hwa. ");
INSERT INTO wos_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Déka duré wambula yatakataka ye dé Godka wambula wa. Tale Godka wandén maki dé wambula wa. ");
INSERT INTO wos_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Wataka déka duka wambula yae diré sérkenéta dé wa, “Yingi maki dé? Métaka guni xéndi male hwae? Mé xéké. Wuni Duna Nyan wuniré haraki saraki sémbut hurukwa duka hwetendéka nukwa andé yae. ");
INSERT INTO wos_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Sé raméngut yikwa. Mé xé. Wuniré mamaka hwetekwa du andé yae.” ");
INSERT INTO wos_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Jisas wata téndéka dé déka du nak Judas ya. Séfélak du di xi warendaka yar akwi bangi akwi hura di dé wali ya. Prisna néma du akwi, Israelna getéfana néma du akwi wungi wandaka di ya. ");
INSERT INTO wos_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Jisasré mamaka hwetekwa du Judas dé Jisasré hulukitekwa duré wa, “Wuni du nakré tamaruwut, wun du Jisas dé. Guni déré mé huluki.” ");
INSERT INTO wos_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Judas Jisaska bari yae dé wa, “Néma du, diména!” Wungi wataka dé déré tamaru. ");
INSERT INTO wos_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Tamarundéka dé Jisas déré wa, “Nyayika, méni mena mawuli yamékangalambu yamén joo mé huru.” Wungi wandéka di déka yae déré huluki. ");
INSERT INTO wos_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Hulukindaka dé Jisas wali téndé du nak xi warendaka yar hafute dé prisna néma duna jémba yakwa duré xiyae déka waan xatékéndéka dé xakri. ");
INSERT INTO wos_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Xakrindéka dé Jisas déré wa, “Ména yar mé lakwa, déka wurmbu. Du nak xi warendaka yarmbu du xiyandét nak du déré xi warendaka yarmbu xiyatandé. Xiyandét dé hiyatandé. ");
INSERT INTO wos_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Wuni mawuli yata wuna yafaré wawut dé bari wandét déka séfélak séfélak ensel yae wuniré yikafre hurutandi. Wun jooka méni xékélakihambaméni wana? ");
INSERT INTO wos_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Hanja du nawulak Godna nyingambu di hayi, nak du yae wuniré huluke hura ye xiyatendakaka. Wuna yafa wuniré yikafre hurundéte wawut, hayindan hundi mwi hundi yamba xakukéndé. Wuni wuna yafaré wahafi yawut, wun hundi mwi hundi xakutandé.” ");
INSERT INTO wos_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Wun hundi wataka dé Jisas déré hulukinjoka yandé duré wa, “Guni wuniré hulukinjoka yata métaka guni xi warendaka yar akwi bangi akwi hura ya? Guni sélé héraakwa duré xiyanjoka guni wun joo hura ya, o yingi maki dé? Séfélak nukwa wuni tempelmbu reta wuni du takwaré Godna hundika wakwe. Wumbu rewuka guni wuniré hulukihambanguni. ");
INSERT INTO wos_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Wuniré hurunguka jooka hanja du nawulak Godna nyingambu di hayi. Hayindaka némbuli deka hundi mwi hundi dé ya.” Wungi wandéka déka du atéfék déré yatakataka di yaange yi. ");
INSERT INTO wos_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Jisasré hulukindé du di déré hura yi Kaiafasna geré. Kaiafas dé atéfék prisna néma du dé. Xékélelakikwa du akwi, Israelna getéfana néma du akwi Kaiafasna gembu hérangwanda rendaka di Jisasré wun geré hura yi. ");
INSERT INTO wos_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Yindaka dé Pita Jisasna hukémbu ye dé afakémbu té. Téta dé xé Jisasré hulukindé du déré hura wun gembu wulayindaka. Xe dé gélindu wali hafwambu dé re. Jisasré yatendakangala xénjoka dé re. ");
INSERT INTO wos_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Prisna néma du akwi, Israelna atéfék néma du akwi di Jisasré xiyanjoka di mawuli ya. Yata di wa, “Jisas hurundén haraki saraki sémbutka héndé wate, nani déré duna makambu takanjoka?” Wungi wata di yénataka hundi xékénjoka di mawuli ya. ");
INSERT INTO wos_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Yata wandaka di séfélak yéna yakwa du yae di Jisas hurundén sémbutka wa. Wandaka néma du di wungina hundi xékéhambandi. Xékéhafi yandaka bér du yéték ya. ");
INSERT INTO wos_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","Yae bér wa, “Wun du angi dé wa, ‘Wuni tempelré glarétawuni. Glarétaka nukwa hufuk yindét wuni wambula totawuni.’ Wungi dé wa.” ");
INSERT INTO wos_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Wun hundi wambéka dé prisna néma du raama téta dé Jisasré wa, “Métaka méni bérka hundika hasa wahafi ye? Bérka hundi yingi maki dé?” ");
INSERT INTO wos_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Wungi wandéka Jisas hundi nawulak buléhambandé. Buléhafi yandéka dé prisna néma du déré wa, “Wuni wungi rekwa Godna ximbu wata wuni we, méni wuniré mwi hundi waméte. Méni God wasékendén du Krais méni, o yingi maki dé? Méni Godna nyan méni, o yingafwe?” ");
INSERT INTO wos_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Wun hundi wandéka dé wa, “Xéxé. Wundé wami. Ané hundi guniré atéfék wuni we. Hukémbu guni xétanguni, wuni Duna Nyan néma du reta némafwi hambuk yakwa du Godna yika tambambu re buwi wali nyirmbu gayawut.” ");
INSERT INTO wos_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Jisas wungi wandéka dé prisna néma du mawuli wita dé déka nukwa wur léngaata dé wa, “Dé wungi wata dé Godka haraki hundi we. Guni déka hundi guni xéké. Wu haraki hundi dé. Nak duré yamba wakwexékékéme, hurundén sémbutka. ");
INSERT INTO wos_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Yingi guni wa déka?” Wungi wandéka di wa, “Dé haraki saraki joo dé huru. Métaka hiyandé.” ");
INSERT INTO wos_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Wun hundi wataka Jisasna saawimbu simbar séxandaka di nawulak déré tambambu xiya. ");
INSERT INTO wos_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","Xiyaata déré haraki hundi wata di wa, “Méni God wasékendén du Krais, héndé méniré xiyae?” Wungi di wa. ");
INSERT INTO wos_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Pita hafwambu dé re. Geka séndé gisangwandéndanmbu dé re. Rendéka lé wun gembu jémba yakwa takwa hési yae lé déré wa, “Méni akwi wun Galilimbu yandé du Jisas wali méni té.” ");
INSERT INTO wos_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Wungi waléka dé Pita wumbu rekwa du takwana makambu téta dé wa, “Yingafwe. Wuni wanyéka hundika yike wuni ye.” ");
INSERT INTO wos_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Wungi wataka gwande dé yambumbu re. Rendéka jémba yakwa takwa hési akwi déré xéta lé lé wali téndé du takwaré wa, “Ané du Nasaretna du Jisas wali dé té.” ");
INSERT INTO wos_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Wungi waléka dé hambukmbu wa, “Yingafwe. Wun duka xékélakihambawuni. Mwi hundi wuni we.” ");
INSERT INTO wos_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Wungi wandéka hukémbu di wumbu téndé du nawulak déka yae di wa, “Galilimbu yandé du hundi buléndaka maki méni hundi bulé. Méni akwi Galilimbu yandé du méni. Méni Jisasna du nak méni. Wu mwi hundi dé.” ");
INSERT INTO wos_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Wungi wandaka dé Pita diré hambukmbu wa, “Yingafwe. Wun duka xékélakihambawuni. Mwi hundi wuni we. Mwi hundi wahafi yawut, God wuniré xiyatandé.” Wungi wandéka dé séra wa. ");
INSERT INTO wos_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Wandéka dé Jisas déré wandén hundika dé saréké. Tale Jisas dé wa, “Wuni xékélaki. Séra wahafi yandét méni yambu hufuk angi wataméni, ‘Wuni déka xékélakihambawuni.’ Wungi wamét séra watandé.” Wun hundika sarékéta Pita gwande némafwimbu saréfa naata dé géra, dé Jisaska hu hwendénka. ");
INSERT INTO wos_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Xitélakéndéka di prisna néma du, Israelna getéfana néma du wungi di hundi gi, Jisasré xiyanjoka. ");
INSERT INTO wos_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Hundi gita déré yoombu giya di Romna néma du Pailatka di déré hura yi. ");
INSERT INTO wos_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Jisasré mamaka hwendé du Judas dé hundi xéké, di Jisasré xiyanjoka hundi buléndaka. Xékétaka dé nak mawuli xékéta prisna néma du, Israelna getéfana néma du wungi rendaka dé dika wambula yi. Ye dé déka hwendan yéwa dika wambula hwe. ");
INSERT INTO wos_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Hweta dé wa, “Wuni haraki wuni huru. Wuni haraki sémbut huruhafi duré wuni déka mama duka hwe. Hwewuka di déré xiyandat dé hiyatandé.” Wungi wandéka di wa, “Nana jémba yingafwe. Ména jémba dé.” ");
INSERT INTO wos_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Wungi wandaka dé wun yéwa tempelmbu yakisolotaka dé yi. Ye dé dé hafuré yoombu xalétéka dé hiya. ");
INSERT INTO wos_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Prisna néma du yakisolondén yéwa héraata di wa, “Ané duré xiyandat déka nyéki blekéndéte hwemben yéwa dé. Ané yéwa tempelmbu rekwa yéwa wali takata Moses wandén hambuk hundika hu hwetame. Wun yéwa wali yamba takakéme.” ");
INSERT INTO wos_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Wungi hundi bulétaka di wun yéwa hwetaka di aki yatakakwa duna héfa héra. Hérae di wa, “Nak téfambu yandé du takwa nana getéfambu hiyandat, nani diré ané héfambu rémétame.” ");
INSERT INTO wos_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Wungi wataka wungi hurundaka du takwa wun héfaka ye di angi wa, “Nyéki héfa dé.” Némbuli akwi wun héfaka wungi nani we. ");
INSERT INTO wos_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Prisna néma du wungi hurundaka dé profet Jeremaia hayindén hundi mwi hundi dé ya. Jeremaia Godna nyingambu angi dé hayi: “Israelna du takwa angi di wa, ‘Déré hératame. Bangi hufuk yéwa (30) hwetaka nani déré hératame.’ ");
INSERT INTO wos_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Wungi wataka di wun yéwa aki yatakakwa duka hwetaka déka héfa di héra. Néma Du God wuniré dé wa, wuni wungi huruwute.” Wungi dé Jeremaia hayi. ");
INSERT INTO wos_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Jisasré hura yindaka dé Romna néma du Pailatna makambu té. Téndéka dé Pailat déré wakwexéké, “Méni Judana néma du o yingafwe?” Wungi wakwexékéndéka dé Jisas wa, “Xéxé. Méni hafu wundé wami.” ");
INSERT INTO wos_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Wungi wandéka di prisna néma du akwi, Israelna getéfana néma du akwi di yénataka hundi wa, Jisas hurundén sémbutka. Jisas wun haraki sémbut huruhambandé. Di déka yénataka hundi wandaka dé deka hundi hasa wahambandé. Hundi nawulak buléhambandé. ");
INSERT INTO wos_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Buléhafi yandéka dé Pailat déré wa, “Méni ménika wandaka atéfék hundi nawulak méni xéké, o yingi maki dé? Métaka méni hundi buléhafi té?” ");
INSERT INTO wos_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Wungi wandéka dé Pailatré hundi nawulak wahambandé. Wahafi yandéka dé Pailat saré waréké. ");
INSERT INTO wos_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Atéfék héki hwari Pasova hénoo sa nukwa dé Romna néma du séndé gembu hwaakwa du nakré wandéka dé séndé ge yatakataka gwande dé jémba yi. Jerusalemémbu rekwa du takwa deka mawuli sarékémbu Romna néma duré wandaka dé mawuli yandaka duré wandéka dé séndé ge yatakataka gwande dé jémba yi. ");
INSERT INTO wos_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Wun nukwa haraki saraki sémbut hurundé du nak séndé gembu dé hwa. Déka xi Barabas dé. Séfélak du takwa déka di xékélaki. ");
INSERT INTO wos_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","18","Pailat dé xékélaki. Jisas haraki sémbut nawulak huruhambandé. Séfélak du takwa Jisaska mawuli yandaka di prisna néma du haraki mawuli di Jisasré gitaka hura ya déka. Wungi xékélakita déka mawulimbu dé wa, “Wafewana ambu hérangwanda tékwa du takwa Jisaska mawuli yatandi, o yingi wana?” Wungi wata dé wunde du takwaré wa, “Yingi maki guni mawuli ye? Héndéré wawut dé jémba yitandé? Barabasré wawut dé séndé ge yatakataka gwande jémba yitandé, o Jisasré wawut dé jémba yitandé? Wun du Jisas nawulak du angi di wa, dé God wasékendén du Krais dé.” ");
INSERT INTO wos_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Pailat hundi xékéndéka hafwambu rendéka lé déka takwa hundi déka takata lé wa, “Méni wun yikafre sémbut hurukwa duré haraki hurukéméni. Gan hwae wuni déka janji hwa. Janji hwae némafwi xak wuni héra.” Wungi lé wa. ");
INSERT INTO wos_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Prisna néma du akwi, Israelna getéfana néma du akwi wungi di wumbu téndé du takwaré wa, di Pailatré wandat dé wandét Barabas séndé ge yatakataka gwande jémba yindét di Jisasré xiyandate. ");
INSERT INTO wos_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Wungi wandaka dé néma du Pailat diré wambula dé wakwexéké, “Ambére duka yingi guni saréké? Héndéré wawut dé gunika gwande jémba yitandé?” Wungi wandéka di wa, “Barabas.” ");
INSERT INTO wos_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Wungi wandaka dé Pailat wa, “Krais nandaka du Jisasré yingi maki yatawuni?” Wungi wakwexékéndéka di atéfék wa, “Déré xiyae mimbu mé hateka.” ");
INSERT INTO wos_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Wungi wandaka dé wa, “Métaka we? Méta haraki joo dé huru.” Wungi wandéka di hambukmbu wa, “Déré xiyae mimbu mé hateka.” ");
INSERT INTO wos_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Di wungi wandaka dé Pailat déka mawulimbu wa, “Di wuna hundi xékéhambandi. Wuni deka hundi xékéhafi yawut, di waretandi.” Wungi wataka dé hulingu nawulak hérae dé atéfék du takwana makambu téta déka tamba yakwanyi. Yakwanyita dé wa, “Wuni guna makambu tamba wuni yakwanyi, guni xéta angi xékélakingute. Wuni ané duré xiyanjoka hélék wuni ye. Guni déré xiyangut, wu guna jémba dé. Wuna jémba yingafwe.” ");
INSERT INTO wos_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Wungi wandéka di wumbu téndé du takwa wa, “Nani xéké. Dé hiyandéte nani mawuli ye. God wun jooka ‘Haraki saraki joo dé’ naata dé naniré nana nyangwalré akwi hasa xiyatandé.” ");
INSERT INTO wos_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Wungi wandaka dé Pailat wa, Barabas séndé ge yatakataka gwande jémba yindéte. Wataka déka xi warekwa duré dé wa, di Jisasré rami yoombu hambukmbu xiyataka déré xiyae mimbu hatekandate. ");
INSERT INTO wos_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Pailatna xi warekwa du di déka néma geré di Jisasré hura yi. Hura yindaka di atéfék xi warekwa du di dé téndénmbu hérangwandé. ");
INSERT INTO wos_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Hérangwanda di déka nukwa wur lafitaka néma duna waka nukwa wur sandataka. ");
INSERT INTO wos_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Sandatakataka di rami yoo nak hérae néma du husandandakangala gootuwa di déka anéngambambu sandataka. Sandatakataka bangi nak hérae di déka yika tambambu taka. Take déka hwati se wangita haraki hundi wata di wa, “Diména, Judana néma du.” ");
INSERT INTO wos_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Wungi wata déré simbar séxaata di wun bangi hérae di déka anéngambambu séfélak yambu xiya. ");
INSERT INTO wos_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Wungi hurutaka di sandandan waka nukwa wur lafitaka di déka nukwa wur sandataka. Sandatakataka déré xiyae mimbu hatekanjoka di déré hura yi. ");
INSERT INTO wos_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Yambumbu yita di xi warekwa du Sairinimbu yandé du déka xi Saimonré di xé. Xe di déré wa, dé Jisasré xiyae hatekatendaka mi yatandéte. ");
INSERT INTO wos_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Wandaka yatandéka ye di Golgota nandaka hafwa xaku. Wun Judana hundi. Mo hundi angi dé Anéngambana Afa. ");
INSERT INTO wos_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Wara di marasin wali yandan wain hulingu Jisaska hwe, dé se némafwi hangéli hérahafi yandéte. Hwendaka dé sakwexétaka dé sahambandé. ");
INSERT INTO wos_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Sahafi yandéka di déré xiyae mimbu hateka. Xiyae mimbu hatekataka di reta déka nukwa wur muninjoka di deka xi haaye wurmbu lakwataka hérae di nak duna xi xé. Xétaka wun du Jisasna nukwa wur dé héra. ");
INSERT INTO wos_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Hérandéka di wun hafwambu Jisaska hate re. ");
INSERT INTO wos_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Jisasré xiyae hatekandan mimbu di Pailat hayindén nyinga taka. Pailat dé Jisasré xiyandanéna moka dé angi hayi: “Ané Judana néma du Jisas dé.” ");
INSERT INTO wos_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Jisasré xiyae mimbu hatekataka di yarmbu xiyaata sélé hérandé du yétékré xiyae di mi yétékmbu hateka. Nakré di déka yika tamba sakumbu xiyae mimbu hateka. Nakré di déka aki tamba sakumbu xiyae mimbu hateka. ");
INSERT INTO wos_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Du nawulak yitaka yatakata Jisasré xiyae mimbu hatekandaka téndéka xéta di déka wangita haraki hundi wa. ");
INSERT INTO wos_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","Wangita di wa, “Ménawa. Yingi maki dé? Méni tempel glara nukwa hufuk yindét méni wambula tonjoka méni wa. Némbuli méni méni hafu ména séfiré yikafre hurutaméni. Méni Godna nyan xe méni wun mi yatakataka gayataméni.” ");
INSERT INTO wos_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Wungi wandaka di prisna néma du, xékélelakikwa du, Israelna getéfana néma du wungi di akwi di Jisasré wangita haraki hundi wa. ");
INSERT INTO wos_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","Wangita di wa, “Dé nawulak duré dé yikafre huru. Déka séfiré yikafre hurunjoka dé hurufatiké. Dé Israelna néma du re dé xiyae hatekandan mi yatakataka gayandét nani xéta déka ‘God wasékendén du Krais méni’ natame. ");
INSERT INTO wos_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Dé dé wa, ‘Wuni Godna nyan wuni. God wuniré yikafre hurutandé.’ Wungi dé wa. Némbuli nani xétame. God déka mawuli yata déré yikafre hurutandé, o yingi maki dé?” ");
INSERT INTO wos_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Wungi wandaka bér Jisas wali xiyae mimbu hatekandan du yéték bérka mimbu téta bér akwi wungi male wata déré bér haraki hundi wa. ");
INSERT INTO wos_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Nukwa dawimbu téndéka dé atéfék héfambu gan hunyi. ");
INSERT INTO wos_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Hunyindéka hukémbu nukwa tengura nandinjoka yindéka Jisas Hibruna hundimbu hambukmbu dé angi wa, “Heli, Heli, lama sabaktani.” Wun hundi nana hundimbu angi dé: “Wuna God, wuna God, métaka méni wunika hu hwe?” ");
INSERT INTO wos_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Wungi wandéka wumbu téndé du nawulak wun hundi xékéta di wa, “Wun du dé hanja rendé Godna profet Elaijaka dé we.” ");
INSERT INTO wos_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Wungi wataka dé wumbu téndé du nak bari fétékéra ye nyamba maki joo nak hérae dé nyingi yakwa wain hulingumbu husanda. Husandandéka gufwi yandéka bangimbu take dé Jisas sandéte husawara hwe. ");
INSERT INTO wos_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Hwendéka nawulak téta di wa, “Wayika! Nani xétame. Wafewana Elaija yae déré yikafre hurutandé wana?” ");
INSERT INTO wos_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Wungi wandaka dé Jisas hambukmbu wambula waanje déka hamwinya take dé wungi hiya. ");
INSERT INTO wos_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Jisas hiyandéka tempelmbu lékindan séményi nukwa wur anwarmbu léngae ye dé andélambu xaku. Xaakwa dé hafu hafu té. Téndéka nono yandéka di némafwi motu nyéndékmbu fuka. ");
INSERT INTO wos_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Fukandaka hiyandé du takwaré réméndan hwandafu nafwindéka di hanja hiyandé Godna du takwa séfélak di wambula ramé. ");
INSERT INTO wos_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Hukémbu Jisas raméndéka di Jerusalemré wulayi. Wulayindaka séfélak du takwa di diré xé. ");
INSERT INTO wos_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Xi warekwa du akwi deka néma du akwi wungi di Jisaska hate té. Téndaka nono yandéka xakundé jonduré akwi xe di némafwimbu roo. Roota di wa, “Wun du Godna nyan dé. Wu mwi hundi dé.” ");
INSERT INTO wos_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Séfélak takwa yae afaké makimbu téta di xé. Wunde takwa hanja Jisas Galili yatakataka yandéka di déka hukémbu yaata déré yikafre hurundé takwa di. ");
INSERT INTO wos_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Wule takwa hési wu Makdalambu yalé takwa Maria lé. Hési wu Jems bér Josepna ayiwa Maria lé. Hési Sebedina nyan yétékna ayiwa lé. ");
INSERT INTO wos_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Gérambu yandéka Arimateambu yandé du nak déka xi Josep dé ya. Dé xérénjuwi mama du dé. Dé akwi dé Jisasna du nak dé. ");
INSERT INTO wos_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Yae dé Romna néma du Pailatka yi. Ye dé Jisasna fusa héranjoka dé déré wakwexéké. Wakwexékéndéka wandéka di Josepka hwe. ");
INSERT INTO wos_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Hwendaka dé hérae dé yikafre wama nukwa wurmbu banyitaka. ");
INSERT INTO wos_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Baanye hura ye dé déka motu tékwa wekwambu taka. Tale wun wekwa déka jémba yakwa du di xa. Dé Jisasna fusa wun wekwambu take némafwi motu nak sérmena hari dé yambumbu takatéfi. Takatéfitaka dé yi. ");
INSERT INTO wos_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Yindéka bér Makdalambu yalé takwa Maria, Jems bér Josepna ayiwa Maria Jisasré takandan wekwa téndénmbu bér xéta re. ");
INSERT INTO wos_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Jisas hiyandéka hwae ganémba di prisna néma du akwi, Farisi akwi, wungi di Pailatka yi. ");
INSERT INTO wos_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Ye di déré wa, “Néma du, nani wun yéna yandé duna wandén hundika nani saréké. Angi dé wa, ‘Nukwa hufuk yindét wuni wambula ramétawuni.’ ");
INSERT INTO wos_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Wun hundika sarékéta nani méniré wakwexéké. Méni wamét di xi warekwa du ye déré takandan wekwaka nukwa hufuk jémba hate tétandi. Hatihafi yandat, wafewana déka du ye déka fusa sélé hérae hura yita du takwaré angi watandi? ‘Hiyae dé wambula ramé.’ Wungi wandat, hukémbu watendaka yénataka hundi tale wandan yénataka hundiré sarékéngwandétandé.” ");
INSERT INTO wos_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Wungi wandaka dé Pailat diré wa, “Guni xi warekwa duré hérangut di ye wun hafwaka hatitandi, guni hafwaka jémba hatinguka maki.” ");
INSERT INTO wos_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Wungi wandéka ye di wekwambu takatéfindén motumbu yoo gitaka bi maki joo taka, du nafwindémboka. Takataka xi warekwa duré nawulak wandaka di wun wekwaka hate té. ");
INSERT INTO wos_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Judana baka hwa nukwa yindéka Sande ganémbambu nukwa xalenjoka yandéka lé Makdalambu yalé takwa Maria, Jems bér Josepna ayiwa Maria wali wungi bér Jisasna fusa takandan hafwa xénjoka bér yi. ");
INSERT INTO wos_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Yimbéka dé némafwi nono ya. Yandéka dé Néma Duna ensel nak Godna getéfambu dé gaya. Gaye wekwambu takatéfindan motu sérmena taka dé wun motu takumbu re. ");
INSERT INTO wos_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Déka saawi nyir tulem nandéka maki dé na. Nandéka déka nukwa wur buwi maki wama xaku. ");
INSERT INTO wos_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Xakundéka wumbu téndé xi warekwa du némafwimbu roota héfambu xakre di hiyandé du maki hwa. ");
INSERT INTO wos_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Wumbére takwa ye xémbéka dé ensel bérré wa, “Béni rookémbéni. Wuni xékélaki. Béni xiyae mimbu hatekandan du Jisaska hwaka xénjoka béni ya. ");
INSERT INTO wos_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Dé hanja wandén maki dé wambula ramé. Dé ambu hwahambwe. Mé béni yae xé hwandén hafwa. ");
INSERT INTO wos_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Xétaka béni bari hari ye déka duré angi watambéni, ‘Jisas hiyae némbule wambula wundé raméndé. Raama dé Galiliré dé tale yi. Guni ye déré wumbu xétanguni.’ Wungi watambéni diré. Yak. Béniré wungi wuni we.” ");
INSERT INTO wos_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Wungi wandéka bér roota yikafre mawuli yata mawuli sawuli yata bér wun hafwa yatakataka bér bari hari fétékéré yi, déka duré wun hundi wanjoka. ");
INSERT INTO wos_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Yimbéka dé Jisas bérré yambumbu xe dé wa, “Dimbéna.” Wungi wandéka bér déka yae hwati se déka manmbu huruta bér déka wandé da. ");
INSERT INTO wos_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Wandé dambéka dé Jisas bérré wa, “Béni rookémbéni. Béni ye wuna duré wambét, di Galiliré yitandi. Ye wun hafwambu wuniré xétandi.” Wungi dé Jisas bérré wa. ");
INSERT INTO wos_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Wumbére takwa yimbéka di Jisasna fusa takandan hafwaka hatindé du nawulak Jerusalemré wulaaye di xakundéka xéndan jooka prisna néma duré wa. ");
INSERT INTO wos_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Wandaka di prisna néma du wali Israelna getéfana néma du wali hérangwanda reta hundi bulétaka di hundi nak gi. Gita di hatindé duka séfélak yéwa hwe. ");
INSERT INTO wos_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","Hweta di diré wa, “Guni angi du takwaré watanguni, ‘Gan nani xéndi hwambeka di Jisasna du yae di déka fusa sélé hérae hura yi.’ ");
INSERT INTO wos_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Wungi wangut Romna néma du wun hundi xéka mawuli windét, nani déré hundi wambet dé gunika haraki hundi yamba wakéndé.” ");
INSERT INTO wos_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Wungi wandaka di hatindé du wun yéwa hérae hura ye di prisna néma du wandan maki wa. Wandaka di Judana du takwa wun hundi xéké. Némbuli akwi wun hundi male di xéké. ");
INSERT INTO wos_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Jisasna du tamba atéfék man natafa wungi di Galiliré yi. Ye di Jisas yindate wandén némburé yi. ");
INSERT INTO wos_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Ye Jisasré wumbu xéta di déka hwati se wandé da. Wandé dae di nawulak déka jémba sarékéhafi yata di wa, “Ané du ané hiyae raméndé du Jisas wana?” Wungi di saré waréké xéké. ");
INSERT INTO wos_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Jisas yae dé déka duré wa, “God wunika atéfék hambuk dé hwe. Wunika hwendéka wuni nyir héfaka akwi néma du retawuni. ");
INSERT INTO wos_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Retewukaka sarékéta wuni guniré we. Guni ye atéfék héfambu rekwa du takwaré wangut di wuna hundika xékétandi. Xékéndat guni Godna ximbu akwi wuna ximbu akwi Godna Hamwinyana ximbu akwi diré guré husandatanguni. ");
INSERT INTO wos_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Wuni guniré wawun atéfék hundi diré wangut di wuna hundi jémba xékétandi. Xékéta wawun maki hurutandi. Atéfék gan nukwa wuni guni wali tétawuni. Némbuli akwi, hukétéfi nukwa akwi wuni guni wali tétawuni.” Wungi dé Jisas déka duré wa. 91 ");
INSERT INTO wos_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Ané yikafre hundi Godna nyan Jisas Kraisna mo hundi dé. ");
INSERT INTO wos_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Tale profet Aisaia Godna nyingambu angi dé hayi: “Mé xé, ané wuna hundi hura yikwa du dé. Déré watawuni, dé ména makambu yindéte. Dé ména yambu hurutandé. ");
INSERT INTO wos_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Du nak du rehafi hafwambu dé angi wa, ‘Néma Duna yambu hurutanguni. Hurungut déka yambu jémba retandé.’” ");
INSERT INTO wos_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Wungi hayindéka hukémbu guré husandakwa du Jon dé té du rehafi hafwambu. Te dé déka yandé du takwaré wa, “Guni hurungun haraki saraki mawuli yatakangut wuni Godna ximbu guniré guré husandatawuni. Guni wungi yangut Godna ximbu guré husandawut God guna haraki saraki mawuli yakwanyitandé.” ");
INSERT INTO wos_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Wungi wandéka di Jerusalemémbu rekwa du takwa, Judiana hafwambu rekwa du takwa akwi, wungi di yi déka. Ye hurundan haraki saraki sémbutka hélék ye wafukandaka dé Godna ximbu diré guré husanda jordan xérimbu. ");
INSERT INTO wos_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Jon yikafre nukwa wur yikafre hénooka sarékéhambandé. Dé kamel balina séfina yuwimbu yatindan nukwa wur dé sanda. Sandataka dé bulmakau balina séfi rundan yoo dé naki. Dé hawuluki dé sa. Nongérana gék dé jéma sa. ");
INSERT INTO wos_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Dé du takwaré angi dé hundi wa, “Wuna hukémbu du nak yatandé. Déka hambuk wuna hambukré dé sarékéngwandé. Dé néma du dé. Wuni baka du wuni. Yingi maki déka jémba yakéwuni? Wuni yikafre du yingafwe, déka manéna harki létékétewuka. ");
INSERT INTO wos_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Wuni Godna ximbu wuni guniré guré husande. Dé Godna Hamwinya gunika hwetandé.” Wungi dé Jon wa. ");
INSERT INTO wos_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Wun nukwa Jisas Nasaretmbu dé ya. Wun getéfa Galilimbu dé té. Yandéka dé Jon jordan xérimbu dé déré Godna ximbu guré husanda. ");
INSERT INTO wos_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Husandandéka dé gumbu xale dé xé nyir bari télaméndéka Godna Hamwinya nyamwe afwi maki déka gayandéka. ");
INSERT INTO wos_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Gayandéka dé hundi nak Godna getéfambu dé angi wa, “Méni wuna nyan. Ménika mawuli mawuli wuni ye. Ménika némafwi mawuli wuni ye.” Wungi dé wa. ");
INSERT INTO wos_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Godna Hamwinya bari wandéka dé Jisas du rehafi hafwaré yi. ");
INSERT INTO wos_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Haraki wasa male tékwa hafwaré. Ye xaakwa dé séfélak (40) nukwa wumbu hafu rendéka satan yae dé déka mawuli hurukwexé. Hurukwexéndéka di ensel gayae di Jisasré yikafre huru. ");
INSERT INTO wos_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Hukémbu Romna néma du wandéka dé Jon séndé gembu hwandéka dé Jisas yi Galilina hafwaré. Ye dé Godna hundi angi wa. ");
INSERT INTO wos_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","“Hanja God dé wa, dé néma du re guniré hatitandé. Némbuli God néma du re gunika hatitendéka nukwa andé yae. Yandét saréka guni guna haraki saraki mawuli yatakataka Godna hundi xékétanguni.” Wungi dé wa. ");
INSERT INTO wos_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Jisas Galilina tukweseke nak tufwambu ye dé xé Saimon déka bandi Andru wali bérka jémba yambéka. Bérka jémba ye bér wun tukwesekembu mara yaki xéri hamwika. ");
INSERT INTO wos_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Xétaka dé wa, “Béni mé ya wuni wali. Yambét wuni béniré jémba nak wakwetawuni. Wakwewut béni xéri hamwi hurumbén maki du takwaré hératambéni. Hérambét di wuna hundi xékétandi.” ");
INSERT INTO wos_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Wungi wandéka bér bari mara yatakataka raama bér dé wali yi. ");
INSERT INTO wos_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","20","Di yalefu ye dé Jisas xé du yétékré, Jems wali déka bandi Jon wali. Bér bérka yafa Sebedi wali déka jémba yakwa du wali wungi di bérka gunjambémbu re. Reta mara yarafuta rembéka dé Jisas bérré wa, dé wali yimbéte. Wandéka bér bérka yafa déka du wali gunjambémbu rendaka bari yatakataka bér Jisas wali yi. ");
INSERT INTO wos_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Jisas déka du wali di yi kaperneamré. Ye xaakwa baka hwa nukwa dé Godna hundi buléndaka geré wulaaye dé du takwaré Godna hundi dé wa. ");
INSERT INTO wos_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Wata dé diré Godna hundi hambukmbu dé wa. Wungi wandéka di xékélelakikwa du wungi wahafi yandaka du takwa déka hundi xéka waréngéna di déka saré waréké xéké. ");
INSERT INTO wos_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","24","Sarékéndaka dé haraki hamwinya hura téndé du nak wun Godna hundi buléndaka geré wulayi. Wulaaye dé Jisasré wakwexéké, “Méni Nasaretna du Jisas, méni naniré méta yataméni? Naniré haraki hurunjoka méni ya, o yingi maki dé? Wuni ménika wuni xékélaki. Méni Godna yikafre male du méni.” ");
INSERT INTO wos_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Wungi wandéka dé Jisas haraki hamwinyaré wa, “Méni hundi yamba bulékéméni. Wun duré yatakataka sa yaange yi.” ");
INSERT INTO wos_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Wungi wandéka dé wun duré xasémekitaka waanje dé yaange yi. ");
INSERT INTO wos_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Yaange yindéka di atéfék du takwa xe waréngéna di di hafu buléta di wa, “Owa. Ané du méta huli hundi dé wa? Dé hambuk ye haraki hamwinyaré wandéka dé déka hundi xéké.” ");
INSERT INTO wos_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Wungi wandaka di Galilina hafwambu rekwa atéfék getéfaré Jisas hurundén jooka bari hari wa safé yi. ");
INSERT INTO wos_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Jisas Godna hundi buléndaka ge bari yatakataka dé yi. Jems, déka bandi Jon, du nawulak akwi, di Jisas wali di yi. Ye di Saimon bér Andruna geré di wulayi. ");
INSERT INTO wos_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Saimonéna nakéma baré hiyaata lé hwa. Hwaléka di Jisaska bari di wa, léka. ");
INSERT INTO wos_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Wandaka dé wulaaye dé léka tambambu hurundéka raméléka dé léka baré wungi hényi. Hényindéka lé hénoo humbwe lé dika hwe. ");
INSERT INTO wos_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Nukwa nandindéka gérambu baka hwa nukwa yindéka di baré hiyaakwa du takwa nyangwal, séfimali haraki yandé du takwa nyangwal, haraki hamwinya hura téndén du takwa nyangwalré akwi di Jisaska hura yi. ");
INSERT INTO wos_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Hura ye di wun getéfambu rekwa du takwa wali te di hérangwandé gena fétémbu. ");
INSERT INTO wos_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Hérangwandéndaka dé séfélak du takwa nyangwalré huréhaléké. Wandéka di séfélak haraki hamwinya wun du takwa nyangwalré di yataka. Yatakataka yaange yinjoka yandaka dé haraki hamwinyaré hambuk hundimbu wa, di hundi wandamboka. Diré dé haraki hundi wa. Métaka we? Di wundé xékélakinda déka. ");
INSERT INTO wos_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Ganémbambu xitélakéndéka dé Jisas raama gwande yi, du takwa rehafi hafwaré. Ye dé wumbu God wali hundi bulé. ");
INSERT INTO wos_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Buléndéka Saimon béri di déka hwaké. ");
INSERT INTO wos_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Hwaka xétaka di déré wa, “Atéfék du takwa ménika di hwaké.” ");
INSERT INTO wos_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Wungi wandaka dé wa, “Reséndé. Nani nak getéfaré yitame. Wun getéfambu akwi Godna hundi wanjoka yitawuni. Wun jémba yanjoka wuni ya.” ");
INSERT INTO wos_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Wungi wataka dé yi Galilimbu rekwa atéfék getéfaré. Ye dé Godna hundi wa séfélak Godna hundi buléndaka gembu. Godna hundi we dé hambukmbu wandéka di du takwambu tékwa haraki hamwinya xéka di yaange yi. ");
INSERT INTO wos_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Walisufu hurundé du nak dé yi Jisaska. Ye hwati se wandé dae dé déré wa, “Wuni yikafre ya nawut, méni mawuli yaméka makimbu mé hurumét wuni yikafre xakuwu.” ");
INSERT INTO wos_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Wungi wandéka dé déka saréfa nae déka tamba yaake wun duna séfimbu séngétakéta dé wa, “Wuni mawuli wuni ye méni yikafre xakuméte.” ");
INSERT INTO wos_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Wungi wandéka dé walisufu bari hényi. ");
INSERT INTO wos_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","44","Hényindéka dé déré hambukmbu wa, “Mé xéké. Méniré huruwun jooka nak duré wakéméni. Méni priska bari ye déka makambu témét dé ména séfiré xétandé. Xéndét méni yikafre yaménka Moses hanja wandéngala Godka hamwi hwe. Hwemét nawula du takwa xéta di walisufu hényindéka méni yikafre xakuménka xékétandi.” ");
INSERT INTO wos_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Wungi wandéka dé Jisasna hundi xékéhafi ye dé wun jooka wa safé yi, atéfék getéfambu. Saféndéka séfélak du takwa Jisas wali hérangwandénjoka mawuli yandaka dé Jisas hélék ye deka getéfaré wulayihambandé. Dé du takwa rehafi hafwaré dé yi. Ye rendéka di du takwa deka atéfék getéfa yatakataka déré xénjoka di ya. ");
INSERT INTO wos_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Hukémbu Jisas dé wambula yi kaperneamré. Wambula ye gembu rendéka di séfélak du takwa di xéké dé yae rendéka. ");
INSERT INTO wos_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Xéka di séfélak du takwa di wun geré wulayi. Wulaaye téndaka dé hafwa sukweké. Sukwekéndéka yambu yingafwe. Yandaka dé Jisas Godna hundi wa diré. ");
INSERT INTO wos_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Wandéka di du yétiyéti matamba lékémbandé duré jambé nakmbu yate hura ya. ");
INSERT INTO wos_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Yae di Jisas téndénmbu wulayinjoka di hurufatiké, séfélak du takwa hérangwanda téndaka. Fatika di gembu wara di Jisas téndénmbu male di tawinge féra. Férae di wun du hwandén jambémbu yoo léke di wun yambumbu husanda, du takwana nyéndékmbu. ");
INSERT INTO wos_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Husande di Jisas téndénmbu takandaka dé xe dé xékélaki, wunde duna mawulika. Deka mawulimbu di wa, “Dé wun duré huréhalékétandé.” Wungi xékélakita dé wun duré wa, “Wuna nyan, wuni ména hurumén haraki saraki sémbut bu hérekiwu.” ");
INSERT INTO wos_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Jisas wun hundi wandéka di xékélelakikwa du nawulak wumbu re di deka mawulimbu di angi wa, ");
INSERT INTO wos_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Wun du métakika dé wungi we? God hafu dé du hurundén haraki saraki sémbut hali hérekindé. Wun du dé angi wa, ‘Wuni hurundén haraki saraki sémbut bu hérekiwu.’ Wungi wata dé Godré haraki hundi we. Métaka we, dé du male du dé.” ");
INSERT INTO wos_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Wungi wandaka dé Jisas deka mawuli xékélake dé diré wa, “Métaka guni guna mawulimbu wungi saréké? Wungi sarékékénguni. ");
INSERT INTO wos_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","11","Wuni Duna Nyan ané héfambu reta hurundan haraki sémbut hali hérekiwu. Guni wun jooka xékéhambanguni. Méta hundi wuni hali wawu, ména haraki sémbut bu hérekiwu, o sé raama ména jambé hura yi? Guni wuna hambukéka jémba xékélakingute, ané hundi akwi mé xéké.” Wungi wataka dé matamba lékémbandé duré wa, “Méniré andé wawi. Méni sé raama ména jambé hura sa yi ména geré.” ");
INSERT INTO wos_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Wungi wandéka dé raama dé hwandén jambé bari hérae hura dé atéfék du takwana makambu yi. Yindéka xe di atéfék du takwa waréngéné. Waréngéna di Godna ximbu harékéndaka deka mawuli généndéka di wa, “Owa. Wungina joo hanja xéhambame.” ");
INSERT INTO wos_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Jisas wambula gwande dé tukweseke tufwambu té. Téndéka di séfélak du takwa déka yae hérangwandéndaka dé diré Godna hundi wa. ");
INSERT INTO wos_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Wataka ye dé xé alfiusna nyan déka xi Livai Romka yéwa hwenjoka yéwa hérandéka gembu rendéka. Xétaka dé wa, “Méni mé ya wuni wali.” Wungi wandéka dé raama dé Jisas wali yi. ");
INSERT INTO wos_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Jisas yindéka di séfélak du takwa di dé wali yi. Yindaka di Romka yéwa héraakwa du, haraki saraki sémbut hurukwa du nawulak akwi di dé wali yi. Ye di Jisas déka du akwi Livai wali hénoo sata re, déka gembu. ");
INSERT INTO wos_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Sata rendaka di Farisina xékélelakikwa du nawulak xétaka di Jisasna duré wa, “Métaka dé Romka yéwa héraakwa du, haraki sémbut hurukwa du wali dé hénoo se?” ");
INSERT INTO wos_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Wungi wandaka dé diré sataku hundi angi wa, “Yikafre yakwa du takwa doktaka yihafindi. Baré hiyaakwa du takwa di male di yi doktaka. Yindaka dokta di deka séfi huréhaléké.” Wungi wataka dé wa, “Wuni du takwana haraki saraki mawuli wuni huréhaléké. Haraki mawuli yakwa du takwa wunika yae wuna hundi xékéndate wuni gaya. Yikafre mawuli yakwa du takwaka yahambawuni.” Jisas dé wungi wa. ");
INSERT INTO wos_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Nak nukwa guré husandakwa du Jonéna du Farisina du akwi di God wali hundi bulénjoka ye di hénooka yakér. Yakérndaka du takwa nawulak ye di Jisaska wa, “Jonéna du Farisina du akwi séfélak nukwa di hénooka yakér. Yakéra baka re di God wali hundi bulé. Ména du wungi yahambandi. Di atéfék nukwa hénoo di se. Métaka we di ména du hénooka yakérhafi ye?” ");
INSERT INTO wos_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Wungi wandaka dé Jisas diré sataku hundi angi wa: “Du nak takwa hérandét di hénoo humbwe némafwi mawuli ye hénoo satandi, o yingafwe? Di satandi. Takwa hérandé du di wali rendét di némafwi mawuli ye satandi. ");
INSERT INTO wos_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Hukémbu di nawulak du yae wun duré hura yindat wun nukwambu di déka du takwa déka saréfa naata di hénoo sahafi retandi. Wuni wuna du wali rewuka di némafwi mawuli yata di hénoo di se.” ");
INSERT INTO wos_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Wun hundi wataka dé dika sataku hundi yéték akwi angi wa: “Du takwa huli nukwa wur nak léngae hérae nyo nukwa wurmbu tékwa moforé hundafanéhafindi. Di huli nukwa wur nak léngae hérae nyo nukwa wurmbu tékwa moforé hundafanéndat hukémbu gumbu yakwanyindat huli nukwa wur yalefu maki yatandé nyo nukwa wur munae dé némafwi mofo tétandé. ");
INSERT INTO wos_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Nak héki hwarimbu xiyae rundan meme bali séfimbu huli wain hulingu wukasandahafindi. Wungi wukasandandat wun meme bali séfi nyo ye télamétandé, hulingu atéfék yitandé. Yisékendéka dé wun meme bali séfi yikafre yamba yakéndé. Huli meme bali séfimbu wain hulingu jémba tétandé.” Wungi maki nyo hundi wali huli hundi wali yamba tékémbér. ");
INSERT INTO wos_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Baka hwa nukwa nak dé Jisas déka du wali di wit yawi nyéndékmbu yi. Ye di déka du wit sék sanjoka di wit nawulak hutukwe. ");
INSERT INTO wos_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Hutukwendaka di Farisina du nawulak xe di Jisasré wa, “Mé xé. Di wit di hutukwe baka hwa nukwambu. Godna hambuk hundi angi dé wa. ‘Guni baka hwa nukwambu jémba yamba yakénguni.’ Wun hambuk hundi di xékéhambandi. Di wit hutukweta di jémba di ye, baka hwa nukwambu. Yingi makika di wungi huru?” ");
INSERT INTO wos_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","26","Wungi wandaka dé Jisas diré wa, “Hanja nana mandéka Devit hurundén jooka di Godna nyingambu hayi. Wun hundika guni sarékéhambanguni. Hanja Devit déka du wali hénoo yandéka dé Godna némafwi geré wulayi wun prisré dé wakwexéké, Godka hweta takandan hénoo dika hwendéte. Wun nukwa Abiatar dé prisna néma du dé. Wakwexékéndéka hwendéka Devit wun hénoo déka duka hwendéka di atéfék sa. Wungi ye di Godna hambuk hundi xékéhambandi. Godna hambuk hundi angi dé wa, ‘Pris male di Godka hwendan hénoo satandi. Nawulak du wun hénoo yamba sakéndi.’ Wungi wandéka Devit déka du wali wungi yandaka guni dika angi wahambanguni, ‘Di haraki saraki sémbut di huru.’ Wungi wahafi ye, métaka guni wuna duka haraki hundi we, Godna hambuk hundika xékéhambandi? Guni wungi wata guni jémba xékéhambanguni.” Wungi dé wa. ");
INSERT INTO wos_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Wataka dé diré wa, “God du takwaka yikafre hurunjoka dé diré baka hwa nukwa hwe. God du takwaka haraki hurunjoka dé baka hwa nukwa hwehambandé. ");
INSERT INTO wos_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Wungika we saréka wuni guniré andé wawi. Duna Nyan baka hwa nukwana néma du dé.” Jisas dé wungi wa. ");
INSERT INTO wos_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Nak nukwa baka hwa nukwa dé Jisas Godna hundi buléndaka geré wulayindéka tamba haraki du nak dé wumbu re. ");
INSERT INTO wos_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Rendéka di Jisasna hundika hélék yakwa du nawulak wun gembu re di Jisasré xé. Deka mawulimbu di wa, “Jisas baka hwa nukwambu wun duré huréhalékétandé, o yingafwe? Déré huréhalékéndét dé Godna hambuk hundika hu hwendét nani déré watame.” ");
INSERT INTO wos_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Wungi wandaka dé tamba haraki duré wa, “Sé raama yae méni nyéndékmbu té.” ");
INSERT INTO wos_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Wungi wandéka dé raama wumbu téndéka dé diré wa, “Godna hambuk hundi yingi dé wa? Baka hwa nukwa nani yikafre joo hurutame, o haraki saraki joo hurutame? Baka hwa nukwa hiyawata hurukwa du takwaré yikafre hurutame, o diré haraki hurutame?” Wungi wandéka di hundi buléhambandi. ");
INSERT INTO wos_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Ye déka hundi xékénjoka hélék yandaka dé déka mawuli windéka dé dika dé saréfa na. Saréfa nae dé wun duré wa, “Ména tamba mé huritéké.” Wungi wandéka dé déka tamba huritékéndéka dé wambula yikafre ya. ");
INSERT INTO wos_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Yandéka di Farisina du gwande ye Jisasré xiyanjoka di Herotna du wali hundi bulé. ");
INSERT INTO wos_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Jisas déka du wali di tukweseke tufwaré yi. Yindaka di séfélak Galilina du takwa deka hukémbu yi. Hurundén jooka hundi xékétaka di déka yi. Judiambu rekwa getéfa nawulak akwi, ");
INSERT INTO wos_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Jerusalem, Idumea, jordan xéri angé saku, tairna hafwa, Saidonéna hafwa, wun getéfana séfélak du takwa di Jisasna hurundén jooka xéka di déka ya. ");
INSERT INTO wos_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","10","Yae xakundaka dé baré hiyaakwa séfélak du takwa nyangwal, séfimali haraki yandé séfélak du takwa nyangwalré dé huréhaléké. Huréhalékéndéka di du takwa wambula yikafre yanjoka we di déka séfimbu hurunjoka mawuli ye hérangwandéndaka hafwa dé sukweké. Sukwekéndéka dé déka duré wa, “Retewuka gunjambé nak hura tétanguni, séfélak du takwa hérangwanda tétandi.” Wungi dé wa. ");
INSERT INTO wos_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Haraki hamwinya Jisasré xe di déka makambu xakre hwaata némafwimbu di wa, “Méni Godna nyan méni.” ");
INSERT INTO wos_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Wungi wandaka dé Jisas diré hambuk hundimbu wa, di déka xi wandamboka. ");
INSERT INTO wos_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Jisas dé némburé waré. Wara dé mawuli yandéka duré waséke wandéka di déka ya. ");
INSERT INTO wos_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","15","Yandaka dé du tamba atéfék man yéték wungi diré dé wa, di déka jémba yandate. Wunde duka dé angi wa, aposel dé. Di dé wali yitaka yataka déka hundi xéka di du takwaré Godna hundi wakwe hambuk hérae wandat haraki hamwinya yaange yitandi. ");
INSERT INTO wos_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Déka duna xi angi dé: Saimon, déka nak xi Pita dé. ");
INSERT INTO wos_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Sebedina nyan yéték, Jems akwi déka bandi Jon akwi. Bérka nak xi Boanerges dé. Mo hundi angi dé wa, jar maki hundi hambuk wakwa du. ");
INSERT INTO wos_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Andru, Filip, bartolomyu, Matyu, Tomas, alfiusna nyan Jems, tertius, nak Saimon. Dé hanja atéfék getéfaré ye dé wa, “Romna du nanika néma du rendéte hélék wuni ye.” ");
INSERT INTO wos_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","Judas Iskariot. Hukémbu dé Jisasré mama duka dé hwe. ");
INSERT INTO wos_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Hukémbu Jisas dé wambula yi geré. Ye xaakwa déka du wali hénoo sa nukwa yingafwe, séfélak du takwa di hérangwanda té. ");
INSERT INTO wos_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Téndaka di du takwa nawulak di Jisaska wa, “Dé wangété du dé.” Wungi wandaka di Jisasna hém xékétaka di déré héranjoka we di déka yi. ");
INSERT INTO wos_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Xékélelaki du nawulak Jerusalemmbu hanja di yi. Ye xaakwa Jisasré xe di déka wa, “Déka mawulimbu atéfék haraki hamwinyana néma du déka xi belsebul dé wulaaye té. Téta hambuk hwendéka dé wandéka di haraki hamwinya yaange yi.” ");
INSERT INTO wos_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Wungi wandaka dé diré wa, yandate. Wataka dé diré sataku hundi nak angi dé wa, “Ané hundi mé xéké. Yingi maki ye dé satan dé hafuré hérekikéndé? Yingafwe. ");
INSERT INTO wos_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Natafa téfana du watémbéra hafu hafu warendat, wun getéfana du jémba yamba rekéndi. ");
INSERT INTO wos_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Natafa gena du watémbéra hafu hafu warendat di akwi jémba yamba rekéndi. ");
INSERT INTO wos_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","satan déka du wali wungi di re. Di watémbéra hafu hafu warendat di jémba yamba rekéndi. Di yingafwe yatandi. ");
INSERT INTO wos_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","“Du nak hara duna geré wulaaye déka jondu sélé héranjoka tale dé wun duré hura yoombu gitaka. Gitaka déka geré wulaaye déka jondu sélé hératandé.” Wungi wataka dé wa, “Satan wun hara du maki dé. Wuni wun duré yoombu gikwa du maki dé. Wuna hambuk satanéna hambukré dé sarékéngwandé.” ");
INSERT INTO wos_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Jisas wungi wataka dé wa, “Mwi hundi wuni guniré we. Du takwa haraki saraki joo ye wun haraki saraki jooka hélék ye yatakandat God hurundan haraki saraki joo yakwanyitandé. Du takwa Godré haraki hundi wandat God wun haraki hundi yakwanyitandé. ");
INSERT INTO wos_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Di haraki hundi we haraki hundi Godna Hamwinyaka wandat God wun haraki hundi yamba yakwanyikéndé. Wun haraki saraki joo reséketandé.” ");
INSERT INTO wos_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Wungi dé wa, di Godna Hamwinyaka haraki hundi wa. Métaka we? Di nawulak Godna Hamwinyaka sarékéhafi ye di wa, “Haraki hamwinyana néma du dé Jisasna mawulimbu wulaaye té.” Wungi we di Godna Hamwinyaka haraki hundi wa. ");
INSERT INTO wos_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Wun nukwa Jisasna ayiwa déka bandingu akwi di déka yi. Ye hafwambu téta di Jisaska hundi taka. ");
INSERT INTO wos_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Takandaka di séfélak du takwa Jisas wali re di déré wa, “Ména ayiwa, ména bandingu, ména nyangengu di yae hafwambu téta di méniré xénjoka di we.” ");
INSERT INTO wos_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Wungi wandaka dé wa, “Wuna ayiwa bandingu héndé?” ");
INSERT INTO wos_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Wungi wataka atéfék du takwaré xe dé wa, “Guni andu wuna ayiwa, wuna bandingu. ");
INSERT INTO wos_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Godna hundi xékékwa du takwa wu wuna ayiwa, wuna nyangengu, wuna bandingu maki di re.” Jisas dé wungi wa. ");
INSERT INTO wos_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Jisas wambula dé hundi wa tukweseke tufwambu. Wandéka di séfélak du takwa yae di dé rendénmbu hérangwandé. Hérangwandéndaka dé, di déka hundi jémba xékéndate mawuli ye, dé gunjambémbu wara re tukweseke gumbu dé re. Rendéka di du takwa tukweseke tufwambu re. ");
INSERT INTO wos_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Rendaka dé diré séfélak sataku hundi diré dé wa Godka. We dé diré angi wa: ");
INSERT INTO wos_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","”Mé xéké. Du nak dé déka yawimbu wit sék yawulalama yakinjoka dé yi. ");
INSERT INTO wos_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Ye yawulalama yakindéka di wit sék nawulak yambumbu di xakri. Xakre di baka rendaka di afwi yae hérae di atéfék sa. ");
INSERT INTO wos_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Wit sék nawulak di motu wali rendé héfambu xakri. Xakre di bari takélaka waré. ");
INSERT INTO wos_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Waréndaka dé méngi jémba huruhafi yandéka nukwa xéndéka dé yalinga talinga ye di bari réka ye di hiya. ");
INSERT INTO wos_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Wit sék nawulak di rami wara téndénmbu xakri. Xakre rendaka dé rami wara wura dé yakétéfi. Yakétéfindéka di wit sék nawulak sék xakéhafi ye di hiya. ");
INSERT INTO wos_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Wit sék nawulak di yikafre héfambu xakri. Xakre wumbu re di jémba waré. Wara di yikafre sék xaké. Nawulak di wungi dumi hufuk sék di xaké. Nawulak di dumi gwongofu sék di xaké. Nawulak di dumi tamba yéti sék di xaké.” ");
INSERT INTO wos_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Wungi wataka dé Jisas wa, “Guni xékénjoka mawuli ye waan take jémba xékétanguni.” Wungi dé wa. ");
INSERT INTO wos_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Wun du takwa yindaka di, dé wali yitaka yatakakwa du déka du nawulak akwi di Jisasré wun sataku hundika wakwexéké. ");
INSERT INTO wos_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Wakwexékéndaka dé diré wa, “Hanja God déka jémba yakwa du takwana hundi dé faku. Némbuli wun fakundé hundi guniré dé wakwe. Hafwambu tékwa du takwaré wun jooka sataku hundi male wuni wa. ");
INSERT INTO wos_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Wawuka di Godna nyingambu rekwa hundi wandén maki di ya: Di xe xe jémba yamba xékéndi. Di hundi xéka xéka wun hundika jémba yamba xékékéndi. Xéka di wu Godna hundi xékéndat dé God deka hurundan haraki saraki sémbut yakwanyitandé.” Jisas dé wungi wa. ");
INSERT INTO wos_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Jisas wungi wataka dé diré wa, “Wun sataku hundina mo guni xékéhambanguni wana? Xékéhafi ye yingi maki atéfék sataku hundika xékétanguni? ");
INSERT INTO wos_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","”Némbuli wun sataku hundi wakwetawuni. Wit sék yawulalama yakindé du dé Godna hundi dé yaki. ");
INSERT INTO wos_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Du takwa nawulak Godna hundi di jémba xéké. Xékéndaka satan bari yae dé wun hundi hérae yaki. Yakindéka di wun hundika yike ya. Wunde du takwa di yambumbu xakrindé wit sék maki di. ");
INSERT INTO wos_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Du takwa nawulak di motu wali rendé héfambu xakrindé wit sék maki di. Tale Godna hundi di bari xéké. Xéka di tale wun hundika yikafre mawuli ye mawuli sawuli di ya. ");
INSERT INTO wos_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Ye di sarékéhambandi. Wun hundi deka mawulimbu nandihafi yandéka di sarékéhambandi. Yandaka di nawulak du Godna hundika hélék ye diré haraki hurundaka haraki saraki joo nawulak dika yandéka di Godna hundi bari yataka. ");
INSERT INTO wos_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Du takwa nawulak wu rami wara téndénmbu xakrindé wit sék maki di. Di Godna hundi tale di jémba xéké. ");
INSERT INTO wos_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","Hukémbu di ané héfana jooka male sarékéndaka dé deka mawuli yéwa héranjoka male di saréké. Sarékéta di nawulak jonduka akwi di mawuli ya. Wun jondu dé Godna hundiré takatéfi. Takatéfindéka di wun du takwa Godna jémba yahambandi. ");
INSERT INTO wos_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Du takwa nawulak wu yikafre héfambu xakrindé wit sék maki di. Di Godna hundi jémba di xéké, wandén maki di ya, déka hundi di jémba xéké. Xéka di yikafre jémba ya. Nawulak di déka wungi dumi hufuk yikafre jémba yandaka nawulak déka dumi gwongofu yikafre jémba yandaka nawulak di déka dumi tamba yéti yikafre jémba ya.” Wungi dé wa. ");
INSERT INTO wos_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Wun hundi wataka dé Jisas wa, “Mé xéké. Du hama nyu ya xéréka hura yae samétakandan aki ekombu di taka, o jambé ekombu di taka? Wu yingafwe. Di jambé takumbu di taka. ");
INSERT INTO wos_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Faakwa rekwa jondu hukémbu xétanguni. Nakélak faakwa wandan hundi hukémbu xékétanguni. ");
INSERT INTO wos_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Guni xékénjoka mawuli ye waan nakélak take jémba xékétanguni.” Wungi dé wa. ");
INSERT INTO wos_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Wataka dé diré wa, “Wun hundika mé jémba saréké. Guni jémba saréka wuna hundi xékétanguni. Guni nawula xékéngut nawula akwi xékétanguni. Xékéngut God gunika yikafre mawuli ye nawulak xékélelaki akwi hwetandé. ");
INSERT INTO wos_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Wuna hundi jémba xékékwa du takwa hukémbu Godna hundika jémba xékétandi. Wuna hundi jémba xékéhafi yakwa du takwa di wa, ‘Nani Godna hundi bu xékékwa.’ Wungi wataka di hukémbu déka hundika yike ye baka retandi.” Jisas dé wungi wa. ");
INSERT INTO wos_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Wun hundi wataka dé wa, “Godna jémba yakwa du dé wit sék yawulalama yakikwa du dé. Dé wit sék héfambu yawulalama yakitaka ");
INSERT INTO wos_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","gan hwae ganémba raama dé xé wit sék takélaka waré. Waréndéka dé xékélakihambandé. Yingi maki dé wit sék takélaka waré? ");
INSERT INTO wos_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Héfa dé hafu hurundéka dé wun wit sék takélaka wara ganga wee xaka dé sék xaké. ");
INSERT INTO wos_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Xaka mwi téndéka dé wun du xe dé yarmbu xatéké.” ");
INSERT INTO wos_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Wun hundi wataka dé wa, “Godna jémba yakwa du takwaka yingi maki watawuni? Méta sataku hundi wawut xékétanguni? ");
INSERT INTO wos_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Wuni angi wuni we. Wun du takwa tale yalefu hém retandi. Hukémbu némafwi hém xakutandi. Wun hém wu miyar sék maki di. Wun miyar sék wu yalefu sék male dé. Nana héfambu tékwa atéfék hénoona sék wu némafwi dé. ");
INSERT INTO wos_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Du wun miyar sék fukandéka dé wura wara néma gali fukandéka némafwi mi dé té. Téndéka hakélékombu di séfélak afwi yae wur yatitaka di hwae.” Jisas dé wungi wa. ");
INSERT INTO wos_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Wungi dé séfélak sataku hundi du takwaré wa. Di xékéndakangalambu xe hundi wundé hwendé. ");
INSERT INTO wos_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Sataku hundi male dé diré wa. Wataka dé hukémbu déka du male téndaka dé diré mo hundi wa, di jémba xékéndate. ");
INSERT INTO wos_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Nukwa nandindéka gan hunyindéka dé Jisas déka duré wa, “Mé yangut yikwa tukweseke angé sakuré.” ");
INSERT INTO wos_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Wungi wandéka di wumbu rendé séfélak du takwaré yatakataka di Jisas rendén gunjambémbu waré. Wara di déré hura yi. Yindaka di du nawulak nak gunjambémbu akwi di yi, di wali. ");
INSERT INTO wos_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Yindaka néma mur hurundéka dé gu raama wara gunjambémbu gwande dé sukweké. ");
INSERT INTO wos_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Sukwekéndéka dé Jisas gunjambéna hungalimbu dé xéndi hwa. Ambutékérmbu dé anéngamba hokate hwa. Hwandéka di déré sérkené. Sérkena di wa, “Néma du, nani hiyatame. Nanika méni saréké, o yingi maki dé?” ");
INSERT INTO wos_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Wungi wandaka dé waréngéna raama wandéka dé mur fakénandéka dé gu jémba té. ");
INSERT INTO wos_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Téndéka dé déka duré wa, “Métaka guni roo? Guniré yikafre huruwun hambukka sarékéhambanguni.” ");
INSERT INTO wos_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Wungi wandéka di roo. Roota di hafu bula di wa, “Owa. Dé yingi maki du dé? Dé wandéka dé mur wali gu wali déka hundi xéké.” Di wungi di wa. ");
INSERT INTO wos_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Jisas déka du wali tukweseke angé sakuré yae di Gerasana héfambu xaku. ");
INSERT INTO wos_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Xaakwa dé Jisas gunjambé yatakataka yandéka dé haraki hamwinya hura téndé du nak yae dé Jisasna saawi xéwata dé ya. Wun du dé du takwa hiyandaka réméndan hafwambu re dé Jisaska ya. ");
INSERT INTO wos_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","4","Dé atéfék nukwa duré réméndan hafwambu dé re. Rendéka du nawulak séfélak nukwa déka man tamba yoombu di gi. Gindaka dé wun yoo nékéte yatakataka dé yaange yi. Hambuk yoombu akwi gindaka dé wun yoo nékéte yatakataka dé yaange yi. Yindéka di déré méta maki nae hulukikéndi. Déré yoombu wambula ginjoka di hurufatiké. ");
INSERT INTO wos_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Gan nukwa dé du takwa hiyandaka réméndan hafwambu, némbumbu wata male wata male reta dé dé hafu déka séfi motumbu séké. ");
INSERT INTO wos_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Jisas xakundéka dé wun du Jisasré afakémbu xé. Xe dé déka fétékéré yae hwati se wandé da. ");
INSERT INTO wos_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","8","Yandéka Jisas xe dé wa, “Méni haraki hamwinya wun duna mawuli mé yatakataka gwande yaange yi.” We wandéka dé hambukmbu wa, “Jisas, méni anwarmbu rekwa Godna nyan. Méni wuniré méta yataméni? Godna ximbu wuni méniré we. Méni wuniré hangéli hwekéméni.” ");
INSERT INTO wos_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Wungi wandéka dé Jisas déré wa, “Ména xi yingi dé?” Wungi wandéka dé déré wa, “Wuna xi Xi Warekwa Du me. Nani séfélak me.” ");
INSERT INTO wos_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Wungi wataka dé wa, “Nani nak héfaré yinjoka hélék me ye. Nani yatakataka nak téfaré yimbete wakéméni.” Wungi we dé hambukmbu wa. ");
INSERT INTO wos_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Wun némbumbu séfélak bali hénoo sata téndaka. ");
INSERT INTO wos_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Sandaka di wun duré hura téndé haraki hamwinya Jisasré wa, “Méni naniré hélekinjoka mawuli ye méni wamét nani wun balina mawuliré wulayitame.” ");
INSERT INTO wos_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Wungi wandaka dé diré wa, “Guni mé xaakwa yaange yi.” Wungi wandéka di wun duré yatakataka ye di wun balina mawulimbu wulayi. Wulayindaka wun bali (2,000 maki) néma takumbu yaange naande ye gumbu xakre hulingu se di wungi hiya. ");
INSERT INTO wos_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Wungi yandaka wun balika hatikwa du xétaka di yaange yi. Ye di atéfék getéfambu rendé du takwaré wun jooka safé. Saféndaka di du takwa wun joo xénjoka di yi. ");
INSERT INTO wos_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Ye di Jisas téndén héfambu xaakwa di séfélak haraki hamwinya hura téndé duré di xé. Dé nukwa wur naake yikafre mawuli ye Jisasna man mombu rendéka di xé. Xe di roo. ");
INSERT INTO wos_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Roondaka dé Jisas wun joo hurundéka xéndé du takwa di diré safé, haraki hamwinya hura téndé du yikafre yandéka bali hiyandanka. ");
INSERT INTO wos_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Saféndaka di Jisasré wa, dé deka héfa yatakataka nak hafwaré yindéte. ");
INSERT INTO wos_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Wandaka dé Jisas diré yatakataka yinjoka ye gunjambémbu waréndéka dé haraki hamwinya hura téndéka yikafre yandé du déré wa, “Wuni méni wali yinjoka wuni mawuli ye.” ");
INSERT INTO wos_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Wungi wandéka dé déré wa, “Méni ména getéfana duka wambula ye diré hundi mé safé, Néma Du ménika saréfa nae méniré yikafre hurundénka.” ");
INSERT INTO wos_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Wungi wandéka dé déré yatakataka ye dé hundi safé, Dekapolisna héfambu rekwa séfélak getéfambu. Jisas déré hurundén jooka dé hundi safé. Saféndéka atéfék du takwa xéka di waréngéna di saréké waréké. ");
INSERT INTO wos_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Jisas déka du wali gunjambémbu ye di tukweseke angé sakumbu xakundaka di séfélak du takwa hérangwanda di dé wali té. Dé tukweseke tufwambu dé té. ");
INSERT INTO wos_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","23","Téndéka dé du nak déka xi jairus dé déka yi. Dé wun getéfana Godna hundi buléndaka gena néma du dé. Ye dé hwati se dé Jisaska wandé dae dé déré wa, “Wuna nyan hiyatalé. Méni yae ména tambambu léré hurumét lé wambula yikafre yatalé.” ");
INSERT INTO wos_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Wungi wandéka dé dé wali yi. Jisas yambumbu yindéka di séfélak du takwa déka hukémbu yi. Yindaka yambu haak hwahambandé. ");
INSERT INTO wos_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Yindéka lé takwa hési lé di wali yi. Séfélak (12) héki hwari ramu yindéka lé re. ");
INSERT INTO wos_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Hanja séfélak nukwa lé séfélak doktaka yi, di léré huréhalékéndate. Ye lé léka atéfék yéwa hweléka wun ramu sékéhambandé. Yikafre yahambalé. ");
INSERT INTO wos_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","28","Ye lé Jisaska saféndan hundi xéka lé léka mawulimbu wa, “Wuni déka nukwa wurmbu séngétakéwut wuni wambula yikafre yatawuni.” Wungi wataka lé séfélak du takwa wali ye déka hukémbu ye lé déka nukwa wurmbu séngétaké. ");
INSERT INTO wos_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Séngétakéléka dé ramu bari sékéndéka lé yikafre xaku. ");
INSERT INTO wos_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Xakuléka Jisas bari dé xéké, déka hambuk nawulak yindéka. Xéka waleka dé déka hukémbu yindé du takwaré wa, “Héndé wuna nukwa wurmbu séngétaké?” ");
INSERT INTO wos_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Wungi wandéka déka du di wa, “Séfélak du takwa di méni wali yindaka hafwa sukwekéndéka méni xé. Di nawulak méniré di séngétaké, wana? Métaka méni naniré we, méniré séngétakéndanka?” ");
INSERT INTO wos_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","We wandaka dé deka hundi xékéhafi ye dé déré séngétakéndé duka hwaké. ");
INSERT INTO wos_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Hwakéndéka wule takwa léka hurulén jooka xéka némafwimbu roota lé déka ya hwati se wandé dae lé wun jooka hundi safé. ");
INSERT INTO wos_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Saféléka dé wa, “Takwanya, nyéniré huréhalékéwun hambukka jémba saréka némbuli yikafre andé yanyi. Yikafre mawuli ye yitanyéni.” ");
INSERT INTO wos_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Te dé hundi buléndéka di du nawulak Godna hundi buléndaka gena néma duna gembu di ya. Yae xaakwa di wumba néma duré wa, “Ména takwanya bu hiya. Méni wamét wumba néma du yamba yikéndé. Dé ye déka nawulak jémba yatandé.” ");
INSERT INTO wos_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","We wandaka dé Jisas wun hundi xéka dé Godna hundi buléndaka gena néma duré wa, “Méni rookéméni. Wuni ména takwanyaré yikafre huruwun hambukka sarékétaméni.” ");
INSERT INTO wos_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Wungi wataka dé Pita, Jems, Jemsna bandi Jon diré dé wa, “Guni hafu wuni wali mé ya. Nawulak du takwa yakéndi.” ");
INSERT INTO wos_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Wungi wandéka di dé wali yi, wumba néma duna geré. Ye di xé séfélak du takwa hérangwanda di wule takwanyaka saréfa naata némafwimbu gérandaka. ");
INSERT INTO wos_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Xétaka di geré wulayindaka dé wa, “Métaka guni wungi gérae? Lé hiyahambalé. Baka xéndi lé hwae.” ");
INSERT INTO wos_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Wungi wandéka di déka wangi. Wangindaka dé deka hundi xékétaka wandéka di atéfék gwandi hafwaré. Gwandindaka dé takwanyana yafa ayiwa, déka du hufuk wali wungi di wulayi, takwanya hwalénré. ");
INSERT INTO wos_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Wulaaye dé léka tambambu hura dé déka hundimbu léré wa, “Talita kum.” Wun mo hundi angi dé: “Takwanya, sé ramé.” ");
INSERT INTO wos_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Jisas wandéka lé bari raama lé yitaka yataka. Léka héki hwari tamba atéfék man yéték. Yitaka yatakaléka xe di waréngéné. ");
INSERT INTO wos_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Waréngénéndaka dé wa, “Mé xéké. Wun jooka safékénguni. Nawulak du takwa xékékéndi. Hénoo nawulak hwengut satalé.” Jisas dé wungi wa. ");
INSERT INTO wos_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Jisas wun getéfa yatakataka dé déka motéfaré yi. Yindéka di déka du di dé wali yi. ");
INSERT INTO wos_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Ye xaakwa baka hwa nukwa dé Godna hundi buléndaka geré wulayi. Wulaaye dé Godna hundika du takwaré dé wa. Wandéka di séfélak du takwa xéka waréngéna di wa, “Owa. Wun du yimbu dé wun hundi héra? Yimbu dé wun xékélelaki héra? Dé hanja xéhafi yamben séfélak hambuk jémba dé ya. ");
INSERT INTO wos_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Dé ge tokwa du dé. Maria lé déka ayiwa lé. Jems, Joses, Judas, Saimon di déka bandingu di. Déka nyangengu atéfék ambu di re, nani wali. Dika nani xékélaki. Dé néma du yingafwe. Dé baka du dé. Yingi maki dé wun hundi wa?” Wungi we di hélék ya déka. ");
INSERT INTO wos_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Hélék yandaka dé Jisas wa, “Profet nak déka motéfambu reta hundi wandét déka hém, déka gembu rekwa du takwa akwi, déka motéfambu rekwa du takwa akwi, di déka hundi xékénjoka hélék di ya. Nawulak getéfana du takwa déka hundi xéka di déka xi harékétandi.” ");
INSERT INTO wos_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Wungi wandéka di Jisaska jémba sarékéhafi yandaka dé hanja xéhafi yandan hambuk jémba yahambandé wun getéfambu. Ané jémba male dé ya. Baré hiyaakwa nawula du takwaré déka tamba takandéka di yikafre ya. ");
INSERT INTO wos_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Wun getéfambu rekwa du takwa déka hundi xékéhafi yandaka dé Jisas saré waréké xéké. Hukémbu dé séfélak getéfaré ye dé Godna hundi du takwaré wa saafa yi. ");
INSERT INTO wos_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Jisas déka du tamba atéfék man yéték wandéka yandaka dé dika hambuk hwe, di wandat duna mawulimbu téndé haraki hamwinya yaange yindate. Hwetaka dé diré wa, “Du yéték yéték wungi sa guni yi. ");
INSERT INTO wos_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Hénoo, wur, yéwa hura yikénguni. Séto bangi male mé guni hura yi. ");
INSERT INTO wos_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Su mé sanda. Nukwa wur natafa male guni naki. Yéték yingafwe. ");
INSERT INTO wos_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Guni ye getéfa nak xaakwa ge nakré wulaaye wun gembu male guni re. Wun gembu re hukémbu nak getéfaré yitanguni. ");
INSERT INTO wos_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Guni nak getéfaré wulayingut wun getéfambu rekwa du takwa guna hundi xékéhafi ye, gunika hu hwendat, guni wun getéfa yatakataka yita guna manmbu tékwa harki létékétaka sa guni yi. Guni wungi yangut di xe watandi, ‘Nani dika hu hweta nani Godna hundika nani hu hwe. Hukémbu God hurumben haraki saraki joo naniré hasa hwetandé.’ Wungi watandi.” ");
INSERT INTO wos_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Wungi wandéka di déka du yi. Ye di du takwaré wa, “Hurungun haraki saraki sémbut mé guni yataka.” ");
INSERT INTO wos_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Wungi wataka di duna mawulimbu téndé haraki hamwinyaré wandaka di yaange yi. Baré hiyaakwa du takwa Godka jémba sarékéndate di deka séfimbu di wel taka. Takandaka di yikafre ya. Wungi di Jisasna du huru na hara na yi. ");
INSERT INTO wos_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Jisasna du wungi yandaka néma du Herot dé hundi xéké. Métaka we? Atéfék getéfambu Jisaska wata di hundi bulé. Du takwa nawulak di wa, “Guré husandakwa du Jon hiyae wambula dé ramé. Raama néma hambuk hérae dé wun hambukmbu jémba ya.” ");
INSERT INTO wos_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Wungi wandaka di nawulak wa, “Wu hanja rendé du elaija dé.” Wungi wandaka di nawulak wa, “Wu profet dé, hanja rendé du maki dé.” ");
INSERT INTO wos_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","We wandaka dé Herot wun jooka xéka dé wa, “Hanja wuni wawuka di Jonéna humbu xatéké. Xatékéndaka hiyae némbuli dé wambula wundé raméndé.” ");
INSERT INTO wos_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","18","Hanja Herot dé déka nyama Filipna takwaré héra. Wule takwana xi herodias. Hérandéka dé Jon wa, “Ména nyamana takwaré haraki méni héra. God wun jooka dé haraki hundi wa.” We wandéka dé Herot Jonéna hundika hélék ye wandéka di déka du ye di Jonré huluke yoombu giya di déré séndé geré hura yi. ");
INSERT INTO wos_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Yindaka séndé gembu hwandéka lé herodias haraki mawuli xéka lé Jonré xiyanjoka lé mawuli ya. Mawuli ye lé déré xiyanjoka lé hurufatiké. ");
INSERT INTO wos_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Métaka we? Herot wungi xiyanjoka hélék dé ye. Herot dé xékélaki. Jon dé Godna hundi xékéta yikafre sémbut hurukwa du dé. Wungi xékélakita dé Herot roo dé Jonré xiyahambandé. Déré yikafre dé huru. Hura dé nak nak nukwa Jon wali hundi bula dé déka hundika mawuli ye dé saré waréké xéké. ");
INSERT INTO wos_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Hukémbu lé herodias Jonré xiya yambuka hwaké. Herot wandéka déka du di némafwi hénoo humbwi, déka ayiwa déré héralén nukwa yandéka. Humbwindan hénoo sandate wandéka di déka jémba yakwa duna néma du, xi warekwa duna néma du, Galilimbu rekwa duna néma du, wungi di yi. ");
INSERT INTO wos_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Ye rendaka herodiasna nyan gwande lé hétihiya. Hétihiyaléka Herot wali hénoo sata rendé du xe di atéfék némafwi mawuli ya. Ye dé Herot wule takwaré wakwexéké, “Métaka nyéni mawuli ye? Mawuli yanyéka joo hwetawuni.” ");
INSERT INTO wos_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Wataka dé wambula wa, “Nawulak jooka akwi mawuli yanyét hwetawuni. Wuna héfa, wuna ge, wuna joo nyéndékmbu mune hwetawuni. Wungi maki hurunjoka wuni we. Wuni mwi hundimbu wuni we.” Herot wungi dé wa. ");
INSERT INTO wos_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Dé wungi wandéka lé wule takwa gwande lé léka ayiwaré wakwexéké, “Méta jooka wawut wunika hwekéndé?” Wungi wakwexékéléka lé léka ayiwa wa, “Guré husandakwa du Jonéna humbuka watanyéni. Wataka héranyét dé hiyandét mawuli yatawuni.” ");
INSERT INTO wos_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Wungi waléka lé bari hari néma du rendanré yi. Ye lé wa, “Némbuli guré husandakwa du Jonéna humbu mé xatéka andémbu take méni wuniré hwetaméni.” ");
INSERT INTO wos_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Wungi waléka dé Herot saréfa nae dé léré mwi hundi wandéka di dé wali reta hénoo sandé du di akwi xéké. Saréfa nae dé nak maki hundi wanjoka hélék ye dé wa yawundu. ");
INSERT INTO wos_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Yawundu nae wandéka dé déka du nak ye séndé geré wulaaye dé Jonéna humbu xatéké. ");
INSERT INTO wos_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Xatéka dé humbu andémbu take dé wule takwaka hura yi. Hura ye dé wule takwaka hwendéka lé léka ayiwaka hwe. ");
INSERT INTO wos_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Wungi yandaka Jonéna du xékétaka ye di Jonéna fusa hérae hura ye di rémé. ");
INSERT INTO wos_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Jisasna du di wambula ya déka. Yae di dé wali reta di yandan atéfék jémbaka, wandan atéfék hundika akwi di déré safé. ");
INSERT INTO wos_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Saféndaka di séfélak du takwa yitaka yataka. Yitaka yatakandaka Jisas déka du wali resétota hénoo sahambandi. Wungi yandaka dé diré wa, “Nani hafu du takwa rehafi hafwaré ye resétotame.” ");
INSERT INTO wos_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Wungi wataka di gunjambé hérae hura di du takwa rehafi hafwaré yi. ");
INSERT INTO wos_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Di yindaka séfélak du takwa xe di déka hundi xéké. Xéka di atéfék getéfana du takwa bari fétékéré ye di tale xaku. ");
INSERT INTO wos_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Xakundaka dé Jisas gunjambémbu yae tukweseke tufwambu te dé séfélak du takwaré xé. Xe déka mawulimbu dé wa, “Sipsip balika hatikwa du rehafi yandét di sipsip bali jémba yamba tékéndi. Wunde du takwa di wun sipsip bali maki di.” Wungi we dé dika saréfa na. Saréfa nae dé diré séfélak hundi wa. ");
INSERT INTO wos_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Wandéka gérambu yandéka déka du yae di déré wa, “Ané du rehafi hafwa dé. Nukwa a nanditandé. ");
INSERT INTO wos_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Méni mé wamét ande du takwa atéfék getéfaré ye di deka hénoo hérae sanda.” ");
INSERT INTO wos_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Wungi wandaka dé Jisas diré wa, “Yingafwe. Guni dika hénoo hwetanguni.” Wungi wandéka di wa, “Nani dika bret héranjoka séfélak yéwa hwetame (200 nukwana yéwa dé). Nani ye wun du takwaka atéfék hénoo nawulak hérae dika hwembete méni mawuli ya, o yingi maki dé?” ");
INSERT INTO wos_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Wungi wandaka dé wa, “Bret hatika dé re? Sa guni ye xé.” Wungi wandéka di hwaka xé. Xétaka wambula yae di wa, “Yalefu bret natamba xéri hamwi yéték wungi dé re.” Wungi di wa, Jisaska. ");
INSERT INTO wos_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Wandaka dé atéfék du takwaré wa, “Guni sé naande guni wumbu wara takumbu re.” ");
INSERT INTO wos_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Wungi wandéka di nawulak némafwi hémémbu, nawulak yalefu hémémbu wungi di wumbu wumbu re. ");
INSERT INTO wos_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Rendaka dé wun yalefu bret natamba wali xéri hamwi yéték wungi hérae dé nyirré yasawara xéta dé Godka diména nae dé hwe. Wungi wataka bret fukae dé déka duka hwe, du takwaka mune hwendate. Hwetaka dé wun xéri hamwi yéték akwi dé hwe, mune hwendate. ");
INSERT INTO wos_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Hwendéka mune hwendaka di atéfék du takwa jémba hura sa. ");
INSERT INTO wos_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Sandaka nawulak bret wali nawulak xéri hamwi wali rendéka di Jisasna du wasara tamba yéti manmbu yéték di lakwa sukweké. ");
INSERT INTO wos_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Séfélak (5,000) du di wun bret sa. Séfélak takwa, séfélak nyangwal akwi wumbu di reta sa. ");
INSERT INTO wos_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Jisasna du wungi yandaka dé diré wa, “Guni gunjambémbu wara guni tale yitanguni, tukweseke angé sakuré, Betsaidaré.” Wungi wandéka déka du yindaka dé dé wali téndé du takwaré wa, di deka getéfaré yindate. ");
INSERT INTO wos_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Wandéka yindaka dé God wali hundi bulénjoka dé némburé waré. ");
INSERT INTO wos_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Gan hunyindéka déka du gunjambémbu re tukweseke nyéndékmbu rendaka Jisas hafu dé re némbumbu. ");
INSERT INTO wos_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Re dé xé mur yandéka gunjambé yawiwalekéndéka di déka du gunjambémbu yinjoka hambuk jémba yandaka. Xétaka ye télakénjoka hurundéka dé gu tokumbu dika yi. Ye dé diré tenangérénjoka nae dé yi. ");
INSERT INTO wos_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Ye gu tokumbu yindéka xe di wa, “Wu wali du nak wana.” Wungi wataka di atéfék déré xe némafwimbu roota di wanji. ");
INSERT INTO wos_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Wanjindaka dé bari wa, “Guni rookénguni! Ané wuni wuni yae. Yikafre mawuli mé ya.” ");
INSERT INTO wos_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Wungi wataka dé gunjambémbu waré. Wara dé di wali rendéka mur yahambandé. Yahafi yandéka waréngénéta di wa, “Owa. Wu yingi maki du dé?” Wungi wata di saré waréké xéké. ");
INSERT INTO wos_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Nalikambu Jisas wunde du takwaka bret hwendénka di sarékéhambandi. Wun jooka yike yata waréngénéta di wungi wa. ");
INSERT INTO wos_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Jisas déka du wali di tukweseke angé sakuré gunjambémbu yae di Genesaretna héfambu xaku. Xaakwa di gunjambé hari di mimbu lékitaka. ");
INSERT INTO wos_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Lékitaka yindaka di du takwa Jisasré xé. ");
INSERT INTO wos_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Xétaka di atéfék getéfaré fétékéré ye di baré hiyaakwa du takwa nyangwalré hérae di jambémbu yate hura ya. Yate hura di Jisas téndén hafwaré yi. ");
INSERT INTO wos_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Jisas yindén atéfék getéfaré, di baré hiyaakwa du takwa nyangwal, séfimali haraki yandé du takwa nyangwalré yate hari. Yate hura ye di hérangwanda téndan hafwambu taka. Takataka di déré wa, “Méni yawundu namét di ména nukwa wurna wambumbu male séngétakétandi.” Wungi wandaka di déka nukwa wurmbu séngétaka di yikafre ya. ");
INSERT INTO wos_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Xékélelakikwa du nawulak di Jerusalemémbu re yae di Farisina du wali wungi di hérangwandé Jisas téndénmbu. ");
INSERT INTO wos_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Hérangwanda di xé Jisasna du nawulak tamba gu yakéhafi hénoo sandaka. Di deka tamba gu yakéhafi yandaka di Farisina du diré xe di wa, “Nana hambuk hundi xékéhambandi. Wu haraki saraki sémbut hurukwa du di.” Wungi di wa. ");
INSERT INTO wos_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Farisina du, séfélak Judana du akwi, deka mandéka wandan maki wungi male tamba jémba gu yakétaka di hénoo sa. ");
INSERT INTO wos_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Di jondu hérandaka hafwaré yitaka yae di tamba gu yakéte. Yakétaka di hénoo sate. Deka mandéka wandan maki di aki, andé, hanyandé akwi di wungi male jémba yakwanyi. ");
INSERT INTO wos_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Di wungi yandaka Jisasna du mandéka wandan maki yahafi yandaka di Farisina du xékélelakikwa du akwi di Jisasré wakwexéké, “Métaka di ména du nana mandéka wandan hundi xékéhafi ye deka tamba gu yakéhafi di hénoo sa?” ");
INSERT INTO wos_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Wungi wakwexékéndaka dé Jisas wa, “Wuna du haraki sémbut huruhambandi. Guni hafu yéna yakwa du guni. Hanja Profet Aisaia ané hayindén hundi wu mwi hundi dé hayi gunika. Angi dé hayi: God dé wa, “Ané du takwa di wunika yikafre hundi wa. Wungi we di wunika deka mawulimbu sarékéhambandi. ");
INSERT INTO wos_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Di deka hambuk hundi xéka wandén maki xéka di wun hundika wa, ‘Wu Godna hundi dé.’ Wungi maki di baka haréké wuna xi.” God wandénéngala dé Aisaia dé hayi. ");
INSERT INTO wos_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Guni wun du maki guni re. Guni Godna hundi xékéhafi ye guni duna hundi male guni xéké.” ");
INSERT INTO wos_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Wun hundi wataka dé Jisas wa, “Guni Godna hundi xékéhafi ye nana mandéka wandan hundi male xékéta guni wa, ‘Nani xékélelakikwa du me.’ Wungi wanguka guna mawuli haraki dé re. ");
INSERT INTO wos_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Hanja Moses Godna hundi dé angi wa, ‘Guni guna yafa ayiwaré yikafre mé huru.’ Wungi wataka dé ané hundi akwi dé wa, ‘Du nak déka yafa ayiwaka haraki saraki hundi wandét wun duré mé xiyangut dé hiyandé.’ Wungi wandéka wun hundi Godna nyingambu dé re. ");
INSERT INTO wos_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Guni wun hundi xékéhafi ye guni wa, ‘Du nak déka yafa ayiwaré angi wandét, Wuna atéfék jondu Godka hwenjoka wuni waséke. Godka hwehafi yata wun jondu bénika yamba hwekéwuni. Béniré yikafre hurunjoka wuni hurufatiké. ");
INSERT INTO wos_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Wungi wata déka yafa ayiwaré yikafre yamba hurukéndé.’ ");
INSERT INTO wos_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Guni wungi we guni Godna hundi xékéhafi yata guna mandékana hundi male xékéta hundi wanguka di du takwa akwi wungi haraki di huru. Hurundaka guni haraki saraki sémbut akwi guni huru.” We dé diré wa. ");
INSERT INTO wos_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Jisas wun hundi wataka dé du takwaka wandéka di déka ya. Yandaka dé diré wa, “Guni wuna hundi mé jémba xéké. Xéka ané hundika guni jémba xékétanguni. ");
INSERT INTO wos_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","16","Du takwana biyaré wulayikwa jonduka God dé wa, ‘Wun jondu du takwana hamwinyaré haraki yamba hurukéndé.’ Du takwana mawulimbu xalekwa jooka God dé wa, ‘Wu haraki saraki sémbut hurukwa du takwa di.’ Wungi dé wa. ");
INSERT INTO wos_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Jisas wungi wataka dé du takwaré yatakataka dé déka du wali di geré wulayi. Wulaaye di déka du déré wakwexéké wun hundika. ");
INSERT INTO wos_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","19","Wakwexékéndaka dé diré wa, “Guni akwi wun hundika xékéhambanguni, o yingi maki dé? Mé xéké. Du takwa sandan joo deka biyaré dé naande dé di takuré dé yi. Sandan joo deka mawuliré haraki huruhambandé.” Wungi dé wa. Jisas wungi wandéka nani xéké. Atéfék hénoo hamwi wu yikafre dé. Nani nawulak hénoo hamwika yamba yakérkémé. ");
INSERT INTO wos_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Jisas dé wambula wa, “Du takwana mawulimbu xalekwa jooka God dé wa, ‘Wu haraki sémbut hurukwa du takwa di.’ Wungi wataka dé, wun jooka dé xéké. ");
INSERT INTO wos_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","22","Du takwana mawulimbu haraki saraki mawuli dé xale. Xalendéka di haraki saraki mawuli xékéta di, du wali takwa wali haraki sémbut huruta di, sélé héraata di, du xiyaata di, du nak duna takwa wali haraki sémbut huruta, takwa hési takwana du wali haraki sémbut huruta, mawuli raméta di, nak maki nak maki haraki saraki sémbut huruta di, yénataka hundi wata di, fakumbeka séfi hafwambu wakweta di, mawuli wiya raméta di, yénataka haraki hundi wata di, wasowaso téta di, wangété sangété yata té. ");
INSERT INTO wos_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Wun haraki saraki sémbut atéfék du takwana mawulimbu dé xale. Xalendéka di haraki saraki sémbut huru. Haraki saraki sémbut hurundaka God dika dé wa, ‘Wu haraki saraki sémbut hurukwa du takwa di.’ Dé wungi wa.” ");
INSERT INTO wos_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Wun hundi wataka dé Jisas wun getéfa yatakataka dé tairna héfaré yi. Ye dé getéfa xaakwa dé ge nakré wulayi. Wulaaye dé déka mawulimbu wa, “Wuni ané gembu rewut di du takwa yamba xékéndi.” Wungi wandéka di déré xé. ");
INSERT INTO wos_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","26","Xe di hundi buléndaka lé takwa hési xékétaka lé déka bari yi. Lé Judana takwa yingafwe, lé nak téfambu yalé takwa lé déka yi. Léka motéfa Fonisia Siriana héfambu dé re. Léka takwanyana mawulimbu haraki hamwinya nak wulaaye téndéka lé léka ayiwa Jisaska yi. Ye lé hwati se wandé dae lé déré wa, “Haraki hamwinya dé té, wuna takwanyana mawulimbu. Méni wamét dé yaange yindéte wuni we.” ");
INSERT INTO wos_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Wungi waléka dé wa, “Nani nyangwal sandaka hénoo hérae wasaka hwembet, wu haraki dé. Nani tale nyangwalka hwetame.” ");
INSERT INTO wos_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Wungi wandéka lé wa, “Néma Du, wu mwi hundi méni we. Wuni angi wuni we. Nyangwal hénoo sandaka nawulak héfambu xakrindéka di deka wasa hérae sa. Méni wuniré yikafre hurumét wu yikafre dé.” ");
INSERT INTO wos_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Wungi waléka dé léré wa, “Wungi jémba wataka némbuli nyéna getéfaré yitanyéni. Haraki hamwinya nyéna takwanyana mawuli yatakataka dé yaange yi.” ");
INSERT INTO wos_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Wungi wandéka lé léka getéfaré wambula ye lé xé takwanya yikafre ye jambémbu hwaléka. Xe lé xékélaki haraki hamwinya léré yatakataka yaange yindénka. ");
INSERT INTO wos_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Hukémbu tairna héfa yatakataka Saidonéna héfambu ye dé Dekapolisna héfambu ye dé Jisas Galilina tukwesekembu xaku. ");
INSERT INTO wos_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Ye xakundéka di du nakré hura yi déka. Wun du waan xékéhafindé, hundi akwi buléhafindé. Wun duré hura ye di Jisasré wa, déré tamba takandéte. ");
INSERT INTO wos_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Wandaka dé Jisas wun duré hura dé, wunde du takwaré yatakataka dé ye bér hafu té. Te dé Jisas déka sékétamba yéték wun duna waanéna yambumbu takataka simbar séxae dé déka sékétambambu wun duna tékalimbu taka. ");
INSERT INTO wos_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Takata dé nyirré yasawara xé. Yasawara xe, saréfa nae dé yanambi hérae dé déka hundimbu wa, “Efata.” We dé wa. Mo hundi angi dé: Mé nafwi. ");
INSERT INTO wos_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Jisas wungi wandéka dé jémba xéké. Xékéndéka déka tékali yikafre yandéka dé jémba bulé. ");
INSERT INTO wos_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Buléndéka dé Jisas du takwaré waleka xe dé diré wa, “Wun jooka safékénguni.” Wungi wandéka di déka hundi xékéhafi ye di wun jooka hundi wa saafa yi. ");
INSERT INTO wos_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Wa saafa yindaka xéka waréngéna di wa, “Owa. Wu yingi maki du dé? Yikafre male jémba dé ye. Yandéka di hundi xékéhafi yandé du takwa di jémba xéké. Hundi buléhafi du takwa di hundi bulé.” We di wa. ");
INSERT INTO wos_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","2","Nakémba nukwa séfélak du takwa ye di hérangwandé, Jisas téndénmbu. Hérangwanda re hénooka hiyandaka Jisas wandéka déka du déka yandaka dé diré wa, “Wun du takwa nukwa hufuk wuni wali re deka atéfék hénoo bu sasékenda, némbuli hénoo wali rendaka dika wuni saréfa nae. ");
INSERT INTO wos_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Nawulak di afaké téfambu di ya. Wuni dika hénoo hwehafi yawut di deka getéfaré wambula ye yambumbu hénooka hiyatandi.” ");
INSERT INTO wos_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Wungi wandéka di déka du déré wa, “Ané du rehafi hafwa dé. Yingi maki nani séfélak du takwaka hénoo hwetame?” ");
INSERT INTO wos_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Wungi wandaka dé Jisas diré wakwexéké, “Bret hatika dé re?” Wungi wakwexékéndéka di wa, “Bret angé tamba yétiyéti angé tamba hufuk dé re.” ");
INSERT INTO wos_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Di wungi wandaka dé atéfék du takwaré wa, “Guni sé naande re héfambu.” Wungi wandéka rendaka dé wun yalefu bret hérae dé Godka diména nae dé bret fukae dé déka jémba hurukwa duka hwe, du takwaka mune hwendate. Hwendéka di mune hwe. ");
INSERT INTO wos_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Nawula yalefu xéri hamwi akwi di hura ya. Jisas wun xéri hamwi hérae dé Godka diména nae dé déka jémba hurukwa duka hwe, du takwaka mune hwendate. ");
INSERT INTO wos_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Hwendéka mune hwendaka di atéfék jémba hura sa. Sandaka dé Jisas fukandén bret nawulak wali xéri hamwi nawulak wali rendéka di Jisasna du wasara angé tamba yétiyéti angé tamba hufuk wungi di lakwa sukweké. ");
INSERT INTO wos_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Séfélak (4,000 maki) du takwa di wumbu reta sa. Rendaka Jisas wandéka di du takwa yi deka getéfaré. ");
INSERT INTO wos_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Yisékendaka Jisas déka du wali gunjambémbu wara di Dalmanutana héfaré yi. ");
INSERT INTO wos_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Farisina du nawulak yae di Jisas wali warunjoka nae di ya. Yae di deka mawulimbu di wa, “God wandéka dé Jisas ya, o du male du wana?” Wungi saréka di déré wa, “Méni hanja xéhafi yamben hambuk jémba nak yataméni. Yamét nani xe xékélakitame, God wandéka méni ya.” ");
INSERT INTO wos_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Wungi wandaka dé Jisas hélék ye dé wakwexéké, “Métaka guni némbuli rekwa du takwa guni hanja xéhafi yangun hambuk jémbaka wakwexéké? Wungi yamba xékénguni. Mwi hundi wuni guniré we.” ");
INSERT INTO wos_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Wungi wataka diré yatakataka déka du wali gunjambémbu wambula wara di tukweseke angé sakuré yi. ");
INSERT INTO wos_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Jisasna du bretka yike ye di natafa bret male di hérae hura yi gunjambémbu. ");
INSERT INTO wos_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Yindaka dé Jisas diré ané sataku hundi hambukmbu dé wa, “Mé guni xékélaki na. Farisina du, Herot akwi, deka yis hurukénguni.” ");
INSERT INTO wos_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Wungi wandéka di di hafu bula di wa, “Nani bret nawulak hurehafi yambenka dé we. Wungi yambenka dé bret némafwi yandéte takandaka joo yiska dé wa.” ");
INSERT INTO wos_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Wungi buléndaka dé xéka dé wa, “Guni yingi guni we, ‘Nani bret yingafwe.’ Métaka guni wungi we? Guni wungi wata guni wuna hambukka xékélakihambanguni. Guna mawulimbu yike guni ye, o yingi maki dé? ");
INSERT INTO wos_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Guna dama wundé té. Métaka guni xéhafi ya? Guna waan wundé té. Métaka guni hundi xékéhafi ya? Métaka guni guna mawulimbu jémba sarékéhafi ya? ");
INSERT INTO wos_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Hanja séfélak (5,000) duka bret natamba fukae hwewuka di sa. Sandaka nawulak rendéka wasara hatika guni lakwa?” Wungi wakwexékéndéka di wa, “Wasara tamba atéfék man yéték nani lakwa.” ");
INSERT INTO wos_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Wungi wandaka dé wa, “Hanja nak nukwa séfélak (4,000) du takwaka bret angé tamba yétiyéti angé tamba hufuk fukae hwewuka di sa. Sandaka nawulak rendéka wasara hatika guni lakwa?” Wungi wakwexékéndéka di wa, “Wasara angé tamba yétiyéti angé tambambu hufuk nani lakwa.” ");
INSERT INTO wos_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Wungi wandaka dé diré wa, “Wu mwi hundi dé. Wungi we métaka guni wuna hambukéka xékéhafi ye?” Jisas dé wungi wa. ");
INSERT INTO wos_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Hukémbu Jisas déka du wali yae di Betsaidambu xaku. Xakundaka di dama hiyandé du nakré hura yi Jisaska. Hura ye di Jisasré wa, déka tamba wun duré takandéte. ");
INSERT INTO wos_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Wandaka dé wun duna tambambu hurundéka bér getéfa yatakataka bér yi. Ye yambumbu te dé simbar déka damambu séxataka dé Jisas déka tamba taka déka damambu. Damambu takataka dé wakwexéké, “Némbuli nawulak joo méni xé?” ");
INSERT INTO wos_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Wakwexékéndéka wun du xe dé wa, “Duré mi maki wuni xé. Xéwuka di yitaka yataka.” ");
INSERT INTO wos_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Wungi wandéka dé wambula tamba taka déka damambu. Takandéka dé hambukmbu xéndéka déka dama yikafre yandéka dé jémba xé. ");
INSERT INTO wos_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Jémba xéndéka dé Jisas wa, “Ména geré sa yi. Wun getéfaré wambula yikéméni.” ");
INSERT INTO wos_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Jisas wungi wataka déka du wali wungi di yi, Sisaria Filipaimbu rekwa getéfaré. Yambumbu ye dé diré wakwexéké, “Du takwa wunika yingi di we?” ");
INSERT INTO wos_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Wungi wakwexékéndéka di wa, “Ménika nawulak di wa, ‘Dé guré husandakwa du Jon dé.’ Nawulak di ménika wa, ‘Dé elaija dé.’ Nawulak di ménika wa, ‘Dé hanja rendé profet nak dé.’ Wungi di wa.” ");
INSERT INTO wos_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Wungi wandaka dé diré wakwexéké, “Guni hafu yingi maki guni wunika we?” Wungi wakwexékéndéka dé Pita wa, “Méni naniré yikafre huruméte God wasékendén du Krais méni.” ");
INSERT INTO wos_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Wungi wandéka dé diré wa, “Wun hundi nak du takwaré wakénguni.” ");
INSERT INTO wos_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Jisas wungi wataka dé déka duré angi wa, “Hukémbu getéfana néma du akwi, prisna néma du akwi, xékélelakikwa du akwi di Duna Nyanré haraki saraki sémbut hurutandi. Hura di wungi wunika hu hwetandi. Wunika hu hweta wuniré xiyandat hiyatawuni. Hiyae wuni nukwa hufuk yindét wambula ramétawuni.” ");
INSERT INTO wos_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Wungi we dé sataku hundi wahafi ya. Yandéka di jémba xéké. Xéka dé Pita déré hura ye dé wa, “Wungi wakéméni.” ");
INSERT INTO wos_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","We wandéka dé Jisas waleka déka duré xe dé Pitaré wa, “Méni satan méni, mé yaange yi. Méni Godna hundi xékéhambaméni. Méni ané héfambu rekwa duna hundi méni xéké.” Wungi dé wa. ");
INSERT INTO wos_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Wataka dé wambula wandéka di séfélak du takwa déka du akwi di déka ya. Yandaka dé diré wa, “Guni wuni wali yae wuna jémba yanjoka mawuli ye angi yatanguni. Guni guna mawuli yanguka yatakatanguni. Yatakataka guni wunika saréka angi watanguni, ‘Nani déka jémba yatame. Ye nani hangéli hérae mimbu hiyambet wu méta yakéndé. Néma joo yingafwe.’ Wungi we wuna jémba hurutanguni. ");
INSERT INTO wos_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Wunika sarékékwa du takwa wuna jémba hurusékendat wuna mama du diré xiyandat di wuni wali jémba reséketandi wungi re wungi re. Wunika sarékéhafi yakwa du takwa deka séfika male sarékéta, deka jémba male yata di hiyae fakutandi. Wuni wali yamba rekéndi. ");
INSERT INTO wos_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Du takwa ané héfana joo atéfék héraata, deka jémba male yata hiyae yingi maki nae di jémba reséketandi? Yingafwe. Jémba yamba rekéndi. ");
INSERT INTO wos_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Di Godna getéfaré yinjoka mawuli yata yéwa hwetandi, o yingi maki dé? Yingafwe. Di yamba yikéndi. ");
INSERT INTO wos_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Némbuli rekwa séfélak du takwa di haraki saraki sémbut huruta di Godna hundi xékéhambandi. Hukémbu wuna yafa wunika hambuk hwendét Duna Nyan nukwa larékwa maki gayatawuni. Ensel wali gayatawuni. Gayae wuni hu hwetawuni, wunika hu hwekwa du takwaka.” ");
INSERT INTO wos_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Wungi wataka dé Jisas diré wa, “Mwi hundi wuni guniré we. Guni ambu tékwa du takwa nawulak hiyahafi te guni God ané héfa hatindéka nukwa némafwi hambuk xakundét xétanguni. Wuni guniré mwi hundimbu wuni we.” Dé Jisas wungi wa. ");
INSERT INTO wos_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Nukwa gwongofu yindéka dé Jisas, Pita, Jems, Jonré wungi hérae di némafwi némbu nakré wari. Wara di hafu di wumbu re. Re xéndaka Jisasna séfi waleka dé nak maki xaku. ");
INSERT INTO wos_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Déka nukwa wur dé wama male xaku. Ané héfambu rekwa du nukwa wur yakwanyindat, wungi maki wama yamba xakukéndi. ");
INSERT INTO wos_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Xakundéka hanja rendé profet Moses wali elaija wali Jisas wali hundi buléndaka di Jisasna du hufuk di xé. ");
INSERT INTO wos_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","6","Xétaka di némafwimbu roo. Roondaka dé Pita déka mawulimbu dé wa, “Méta hundi watawuni?” We dé Jisasré wa, “Néma du, nani ambu rembeka yikafre dé. Nani ge hufuk totame. Ménika nak, Moseska nak, elaijaka nak.” ");
INSERT INTO wos_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Wungi wandéka buwi nak gayae dé diré takatéfi. Takatéfindéka dé buwimbu hundi nak xaakwa dé wa, “Ané wuna nyan dé. Déka wuni némafwimbu mawuli ye. Guni déka hundi mé xéké.” ");
INSERT INTO wos_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Wungi wandéka xékétaka di xé Jisas male téndéka. Nak duré xéhambandi. ");
INSERT INTO wos_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Dé wun némbumbu gayae dé Jisas diré wa, “Mé xéké. Némbuli guni xéngun jooka nak duré safékénguni. Duna Nyan hiyawut God wandét raméwut guni wun jooka safétanguni.” ");
INSERT INTO wos_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Wungi wandéka di nak duré saféhambandi wun jooka. Di hafu bula di wakwexéké, “Hiyae raméndét wu méta hundi dé?” ");
INSERT INTO wos_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Jisasna du di déré wakwexéké, “Xékélelakikwa du di angi wa, ‘Hanja rendé profet elaija tale yatandé. Yandét God wasékendén du Krais hukémbu yatandé.’ Métaka di wungi we?” ");
INSERT INTO wos_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Wungi wandaka dé wa, “Wu mwi hundi di wa. elaija tale yatandé. Yae dé Kraisna yambu hurutandé. Wun hundika sarékéta wunika akwi mé saréké. Godna nyingambu rekwa hundi wandé maki Duna Nyanré haraki saraki sémbut huruta wunika hu hwetandi. Métaka we di wun hundi hayi? ");
INSERT INTO wos_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Wuni guniré wuni we. elaija wundé yandé. Yandéka du nawulak di déré haraki huru. Hanja wun jooka akwi di Godna nyingambu hayi.” Jisas dé wungi wa. ");
INSERT INTO wos_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Jisas, Pita, Jems, Jon wali wungi di naande yi Jisasna nawulak duka. Naande ye di xé séfélak du takwa di wali hérangwanda téta xékélelakikwa du di wali warundaka. ");
INSERT INTO wos_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Xéndaka di atéfék du takwa Jisasré xe di waréngéné. Waréngéna di déka fétékéré ye di déré wa, “Ménawa. Méni wundu.” ");
INSERT INTO wos_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Wungi wandaka dé Jisas déka duré wakwexéké, “Méta hundi guni di wali bulé?” ");
INSERT INTO wos_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Wungi wakwexékéndéka dé, du nak dé wa, “Néma du, wuna nyan wuni hura yae ménika. Haraki hamwinya nak dé té déka mawulimbu. Téndéka dé hundi buléhafindé. ");
INSERT INTO wos_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Wun haraki hamwinya déré hambukmbu hura dé héfambu xakri. Xakrindéka dé wama simbar déka hundimbu dé xaku. Xakundéka némbi tita dé déka séfi hambuk dé ya. Talembu ména duré wuni wa, di wandat haraki hamwinya yaange yindéte. Wawuka di wungi hurunjoka di hurufatiké.” Dé wungi wa. ");
INSERT INTO wos_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Wandéka dé Jisas wun du takwaré wa, “Yingi maki dé? Guni wunika jémba sarékéhambanguni. Wuni séfélak bafu guni wali yita téwuka guni wunika jémba sarékéhambanguni. Guni wun nyan wunika mé hura ya.” ");
INSERT INTO wos_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Wungi wandéka déré hura yandaka dé déré hura téndé haraki hamwinya Jisasré xétaka dé wumba nyanré xasémeki. Xasémekindéka dé héfambu xakre yawiwalekéndéka dé wama simbar déka hundimbu xaku. ");
INSERT INTO wos_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Xakundéka dé Jisas déka yafaré wakwexéké, “Hatika héki hwari dé wungi re?” Wungi wakwexékéndéka dé wa, “Yalefu nyan rendéka dé xaku. ");
INSERT INTO wos_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Séfélak nukwa dé wun haraki hamwinya déré gumbu akwi, yambu akwi, yakindéka dé xakre dé hiyanjoka huru. Ména hambukka yawundu nae wamét wuna nyan yikafre yatandé.” ");
INSERT INTO wos_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Wungi wandéka dé Jisas wa, “Métaka méni wungi we? Du takwa Godka jémba sarékéndat di atéfék joo hali hurunda.” ");
INSERT INTO wos_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Wungi wandéka dé wun nyanéna yafa hambukmbu dé wa, “Godka wuni yalefu wuni saréké. Méni wuniré yikafre hurumét wuni Godka némafwimbu sarékétawuni.” ");
INSERT INTO wos_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Wungi wandéka dé Jisas xé séfélak du takwa fétékéra yae hérangwandéndaka. Xe dé wun haraki hamwinyaré wa, “Méni déré hura téméka dé wumba nyan hundi buléhafi yata hundi xékéhambandé. Méni déré yatakataka sa yaange yi. Yaange ye méni wambula déka mawuliré wulayikéméni.” ");
INSERT INTO wos_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Wungi wandéka dé némafwimbu waanje dé wun nyanré dé némafwimbu xasémeka yaki. Xasémekitaka dé déré yatakataka dé yaange yi. Yindéka dé wun nyan hiyandé du maki dé hwa. Hwandéka di du nawulak wa, “Dé bu hiya.” ");
INSERT INTO wos_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Wungi wandaka dé Jisas déka tambambu hura harékéndéka dé raama té. ");
INSERT INTO wos_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Dé yikafre ye raméndéka Jisas déka du wali di gekoré wulayi. Wulaaye di di hafu reta di déka du déré wa, “Nani wun haraki hamwinyaré wambeka dé yaange yihambandé. Métaka nani wun jémba yanjoka hurufatiké?” ");
INSERT INTO wos_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Wungi wakwexékéndaka dé wa, “Wun jooka Godré watanguni. Godré tale wangut, wunde haraki hamwinya yaange yitandi. Guni Godré wahafi yangut haraki hamwinya guna hundi xékéhafi ye yamba yaange yikéndi.” Dé wungi wa. ");
INSERT INTO wos_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Jisas déka du wali wun getéfa yatakataka di Galilina héfambu yitaka yataka. Yitaka yatakata dé déka duré wa, “Nawulak du takwa naniré xéndate hélék wuni ye. Nani nakélak yimbet ");
INSERT INTO wos_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","wuni hundi nawulak gunika watawuni.” Wungi wataka dé dika ané hundi wa, “Hukémbu du nak wuna mama duka Duna Nyan hwetandé. Hwendét wuniré xiyandat hiyatawuni. Hiyae re nukwa hufuk yindét wambula ramétawuni.” ");
INSERT INTO wos_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Wungi wandéka di wun hundi jémba xékéhambandi. Ye wun hundika déré wakwexékénjoka di roo. ");
INSERT INTO wos_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Hukémbu di kaperneamré yi. Ye xaakwa di geré wulayi. Wulaaye dé Jisas déka duré wakwexéké, “Yambumbu yita méta hundika guni bulé?” ");
INSERT INTO wos_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Wungi wakwexékéndéka di hundi buléhambandi. Yambumbu yita di hafu bula di wa, “Héndé naniré sarékéngwanda nanika néma du rete?” Wungi wata di roo di Jisas wali hundi buléhambandi. ");
INSERT INTO wos_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Yandaka dé re dé diré wa, “Guni mé yae xéké. Guni tale yinjoka mawuli ye, guni hukétéfi yitanguni. Guni néma du renjoka mawuli ye, guni atéfék du takwaka jémba yakwa du retanguni.” ");
INSERT INTO wos_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","37","Wungi wataka dé nyan nakré hura wandéka dé deka nyéndékmbu té. Téndéka dé wun nyanré huruta dé diré wa, “Mé xéké. Du takwa wunika sarékéta ané nyanré yikafre hurundat, wuniré akwi yikafre hurutandi. Di wuniré yikafre hurundat wuniré wandéka yawun duré akwi di yikafre hurutandi.” ");
INSERT INTO wos_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Jisas wun hundi wandéka dé Jon déré wa, “Néma du, du nak ména ximbu haraki hamwinyaré wandéka yaange yindaka nani xé. Dé nani wali yitaka yatakahambandé. Yandéka nani déré wa, wun jémba yandémboka.” ");
INSERT INTO wos_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Wungi wandéka dé Jisas déré wa, “Wun jémba yakwa duré haraki hundi wakénguni. Wuna ximbu hambuk jémba yakwa du wunika bari haraki hundi yamba wakéndé. ");
INSERT INTO wos_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Nanika hu hwehafi yakwa du wu nana du di re. ");
INSERT INTO wos_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Mwi hundi wuni guniré we. Du takwa guni wuna duré xe angi wandat, ‘Wun du di Jisasna jémba yakwa du di. Diré yikafre hurutame. Di hulinguka hiyae yandat dika hulingu hwetame.’ Wungi we di wun yalefu jémba yandat God wun yalefu jémbaka yike yamba yakéndé. Hukémbu wun yikafre jémba hasa hurutandé diré. Mwi hundimbu wuni guniré we.” Jisas dé wungi wa déka duré. ");
INSERT INTO wos_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Wun hundi wataka dé angi wa: “Ané yalefu nyangwal di wuna hundi jémba xéké. Du nak wandét wunde nyangwal nak déka hundi xéka wuna hundi yatakandét God wungi wandé duré hasa hangéli hwetandé. Wu némafwi haraki joo dé. Wun duré déka holéméngimbu némafwi motu lékitaka déré yakisandandat, dé tukweseke gumbu naande dé hulingu se dé hiyandét, wu yalefu joo dé. ");
INSERT INTO wos_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","44","Guna tamba haraki saraki sémbut hurundét guni wun tamba mé xatéka yaki. Guna natafa tamba male téndét wun haraki saraki joo yahafi ye Godna hémémbu xakungut wu yikafre dé. Guna tamba yéték téndét guni wun haraki saraki sémbut hurutaka hukémbu haraki hafwaré naande yingut, wu haraki dé. ");
INSERT INTO wos_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","46","Guna man haraki saraki sémbut hurundét guni wun man mé xatéka yaki. Guna natafa man male téndét wun haraki saraki joo yahafi ye Godna hémémbu xakungut, wu yikafre dé. Guna man yéték téndét guni wun haraki saraki sémbut hurutaka hukémbu haraki hafwaré naande yingut wu haraki dé. ");
INSERT INTO wos_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Guni guna dama haraki saraki jooré xe wun haraki saraki sémbut yanjoka mawuli yangut wun dama mé héreki. Guna natafa dama male téndét wun haraki saraki joo yahafi ye Godna hémémbu xalengut wu yikafre dé. Guna dama yéték téndét guni wun haraki saraki sémbut hurutaka hukémbu haraki hafwaré naande yingut wu haraki dé. ");
INSERT INTO wos_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Wumba hafwambu ya yanéta wungi re wungi re dé. Yanéndéka di fusambu sakwa hawe yamba hiyakéndi.” ");
INSERT INTO wos_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Wun hundi wataka dé wa, “Nani hunyi hénoombu takambet, dé yikafre yatandé. Wungi maki God wandét ya maki yanéndét guni atéfék hangéli hura hukémbu yikafre yatanguni. ");
INSERT INTO wos_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Hénoo résék yandéte nani hunyi taka. Hunyi yikafre yahafi yandét yingi maki yambet wambula yikafre yatandé? Yingafwe. Yikafre wambula yamba yakéndé. Hénoombu yikafre hunyi takambet wun hénoo yikafre yatandé. Guni hunyi maki ye guni atéfék du takwaré yikafre yatanguni. Ye guni di wali natafa mawuli hérae jémba retanguni.” Jisas dé wungi wa. ");
INSERT INTO wos_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Wun getéfa yatakataka Judiana héfaré ye yatakataka di Jisas déka du wali jordan xérimbu di xaki. Xaake angé sakumbu téndaka di séfélak du takwa Jisaska ye di hérangwanda. Hérangwandéndaka dé Jisas déka sémbut hurundéngalaka dé wambula diré Godna hundi wa. ");
INSERT INTO wos_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Dé wungi wandéka di Farisina du nawulak di déka yi. Ye deka mawulimbu di wa, “Nani déré nak jooka wakwexékémbet wafewana dé haraki saraki hundi wandét nani déré duna makambu takatame?” Wungi saréka di déré wa, “Godna hambuk hundi yingi dé wa? Du nak déka takwa déré yatakataka yiléte wandét wu yikafre dé, o yingafwe?” ");
INSERT INTO wos_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Wungi wandaka dé diré wa, “Wun jooka nana mandéka Moses yingi dé wa?” ");
INSERT INTO wos_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Wungi wandéka di wa, “Moses dé wa, ‘Du nak déka takwa déré yatakataka yiléte we dé tale nyinga nak hayitandé wun jooka. Nyingambu haaye dé léré hwetaka dé wa lé déré yatakataka yiléte.’ Moses dé wungi wa.” ");
INSERT INTO wos_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Wungi wandaka dé diré wa, “Guni atéfék Godna hundi xékéhafi yakwa du takwa renguka dé Moses gunika wun hundi hayi. ");
INSERT INTO wos_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Hanja God du nawulak deka takwaré yatakandate God wahambandé. ");
INSERT INTO wos_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Wungi hayitaka ané hundi akwi dé hayi: Du déka yafa ayiwa yatakataka dé takwa hérae bér natafambu retambér. ");
INSERT INTO wos_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Reta bér natafa séfi xaakwa retambér. Wun hundika sarékétame. Du takwa hérae ya bér natafambu bér re. Natafa séfi xaakwa bér re. Séfi yéték yingafwe. ");
INSERT INTO wos_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","God bérka dé wa, ‘Natafa séfi xaakwa bér re.’ Wungi wandét dé du nak déka takwaré yamba wakéndé, lé déré yatakataka yiléte.” Jisas diré dé wungi wa. ");
INSERT INTO wos_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Wataka dé déka du wali di geré wulayi. Wulaaye di wun hundika Jisasré wakwexéké. ");
INSERT INTO wos_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Wakwexékéndaka dé diré wa, “Du déka takwaré yatakandét yilét dé hési takwa hérae dé wule takwa wali haraki sémbut dé huru. ");
INSERT INTO wos_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Takwa léka duré yatakataka nak duka ye lé wun du wali haraki sémbut lé huru.” Wungi dé wa. ");
INSERT INTO wos_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Du takwa di yalefu nyangwalré Jisaska hura ya, dé diré tamba séngétakéndéte. Hura yandaka di Jisasna du xe di diré haraki hundi wa. ");
INSERT INTO wos_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Haraki hundi wandaka dé xétaka rékambambu we dé déka duré wa, “Yalefu nyangwal mé taka yanda wunika. Yandat guni diré haraki hundi wakénguni. Godna héfambu rekwa du takwa wu yalefu nyangwal maki di. ");
INSERT INTO wos_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Mwi hundi wuni guniré we. God néma du reta déka du takwaka jémba hatitandé. Dé wungi hatindéka di yalefu nyangwal yikafre mawuli di ya Godka. Nawulak du takwa yalefu nyangwal maki yatandi. God wun du takwaka jémba hatindéka di yikafre mawuli yata, di déka héfambu retandi. Nawulak du takwa yalefu nyangwal maki yahafi yatandi. Wunde du takwaka God hatinjoka wandét, di hélék ye di déka héfaré yamba wulayikéndi.” ");
INSERT INTO wos_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Wungi wataka dé nyangwalré nak nak hérae dé déka tamba dé deka anéngambambu takataka dé wa, “God guniré yikafre hurutandé.” Dé wungi wa. ");
INSERT INTO wos_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Jisas wambula yambumbu yinjoka yandéka dé du nak déka yae dé déka hwati se wandé da. Dae dé wa, “Méni yikafre du méni Godna jémbaka méni naniré wakwe. Méni mé wa. Métaki nae wuni huli hamwinya hérae wungi re wungi re jémba reséketawuni?” ");
INSERT INTO wos_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Wungi wandéka dé Jisas wa, “Métaka méni wunika ‘Yikafre du’ na? God hafu dé yikafre du dé re. ");
INSERT INTO wos_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","God wandéka Moses wandén ané hambuk hundi méni xéké: Du takwaré xiyakéméni. Méni nak duna takwa wali haraki saraki sémbut hurukéméni. Sélé hérakéméni. Nak duka yénataka hundi wakéméni. Yéna yahafi ye nak duna joo hérakéméni. Méni ména yafa ayiwaré yikafre huru. Moses wun hundi wandéka méni xéké.” ");
INSERT INTO wos_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Wungi wandéka dé wa, “Néma du, wuni yalefu nyan te wuni wun hambuk hundi wuni xéké. Ané nukwa akwi wuni xéké.” ");
INSERT INTO wos_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Wungi wandéka dé Jisas wun duka xe dé déka mawuli mawuli ye dé wa, “Méni nakémba jooka yingafwe méni ye. Méni takamén atéfék joo nak duka hwetaka yéwa hérae méni jambangwe du takwaré hwetaméni. Hwemét God méniré yikafre hurundét hukémbu méni Godna getéfaré ye wumbu jémba male reséketaméni. Méni jambangwe du takwaré yéwa hwetaka wambula yae méni wuni wali yite.” ");
INSERT INTO wos_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Wungi wandéka dé wun hundi xékétaka dé déka biya mawuli xak dé ya. Métaka we? Dé séfélak xérénjuwi diré baka hwenjoka hélék dé ye. ");
INSERT INTO wos_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Wun du yindéka Jisas déka duré xe dé wa, “Xérénjuwi mama du takwa nakélak nakélak ye di Godna héfaré yamba wulayikéndi. Di Godna héfaré wulayinjoka mawuli yandat, wu némafwi jémba dé.” ");
INSERT INTO wos_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Wungi wandéka di déka hundi xéka di waréngéné. Waréngénéndaka dé wa, “Gunawa, mé xéké. Du takwa Godna héfaré wulayinjoka di mawuli yandat, wu némafwi jémba dé. ");
INSERT INTO wos_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Kamel bali nak nukwa wur hundafanéndaka ramina yambumbu wulayinjoka mawuli ye, wu yalefu jémba yatandé. Xérénjuwi mama du takwa Godna héfaré wulayinjoka mawuli yandat, wu némafwi jémba dé.” ");
INSERT INTO wos_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Wungi wandéka di waréngéna di di hafu buléta di wa, “Owa. Xérénjuwi mama du takwa Godna héfambu wulayinjoka némafwi hambuk yandat, yingi maki jambangwe du takwa Godna héfambu wulaaye jémba reséketandi, wungi re wungi re? Wu yingafwe. Godna héfambu wulayinjoka di hurufatikétandi.” ");
INSERT INTO wos_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Wungi wandaka dé wa, “Du takwa deka hambukmbu jémba ye, di Godna héfambu yamba wulayikéndi. God hafu dé hambuk dé. God atéfék joo hali hurundé.” ");
INSERT INTO wos_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Wun hundi wandéka dé Pita wa, “Mé xéké. Nana atéfék jondu yatakataka nani ména jémba yata méni wali me yitaka yatake.” ");
INSERT INTO wos_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","30","Wungi wandéka dé wa, “Mwi hundi wuni guniré we. Wunika jémba sarékékwa du takwa Godna hundi wanjoka nae di deka ge, nyamangu, bandingu, nyangengu, heengu, ayiwa, yafa, nyangwal, yawi yatakandat God némbuli diré yikafre hurundét di séfélak ge, nyamangu, bandingu, nyangengu, heengu, ayiwa, nyangwal, yawi akwi hératandi. Di wuna hundi wandat du nawulak diré haraki hurutandi. Hukémbu di jémba retandi wungi re wungi re. Mwi hundimbu wuni guniré we. ");
INSERT INTO wos_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Ané hundi akwi mé xéké. Némbuli rekwa séfélak néma du takwa hukémbu baka du takwa retandi. Némbuli baka rekwa séfélak du takwa di hukémbu néma du takwa retandi.” Jisas dé wungi wa. ");
INSERT INTO wos_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Hukémbu Jisas déka du wali wungi di Jerusalemré yi. Dé yambumbu tale yindéka di Jisasna du xe waréngéna di wa, “Owa. Wun getéfaré wambula yinjoka dé roohambandé.” Wungi wandaka di déka hukémbu yikwa du takwa déré xe di roo. Yambumbu ye Jisas déka duré male dé hundi wa, déka xakutekwa jooka. ");
INSERT INTO wos_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Dé wa, “Mé xéké. Némbuli nani Jerusalemré andé warikwe. Warimbet di Duna Nyanré hérae prisna néma du, xékélelakikwa du akwi deka makambu wuniré takatandi. Takataka di wuniré xiyatendakaka watandi. We di nak téfana duka wuniré hwetandi. ");
INSERT INTO wos_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Hwendaka hérae di wuniré haraki hundi wata wuniré simbar séxatandi. Rami wali yoombu xiyataka wuniré xiyandat, hiyatawuni. Hiyae wuni nukwa hufuk hwae wuni wambula ramétawuni.” Wungi dé Jisas wa. ");
INSERT INTO wos_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Jisas wungi wandéka bér Sebedina nyan yéték Jems bér Jon déka yi. Ye bér wa, “Néma du, ani ménika wanat nak joo méni huruméte ani mawuli ye.” ");
INSERT INTO wos_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Wungi wambéka dé wa, “Méta yawute béni mawuli ya?” ");
INSERT INTO wos_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Wungi wandéka bér wa, “Hukémbu méni némafwi hambuk ye du takwaka néma du re, méni wamét ana nak ména yika tamba sakumbu rendét, nak ména aki tamba sakumbu retandé. Ani wumbu re nawulak du takwaka néma du retaani. Wungi ani mawuli ya.” ");
INSERT INTO wos_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Wungi wambéka dé wa, “Béni wunika wambéka jooka xékélakihambambéni. Béni wuna hanyandémbu satambéni? Béni wuni nandiwun guré nanditambéni?” Jisas dé wungi wa. Mo hundi angi dé, wun hanyandé déka hératendéka hangéli dé. Wun guré nandindén hiyatendékaka dé we. ");
INSERT INTO wos_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Wungi wandéka bér wa, “Xéxé. Hérataani.” Wungi wambéka dé wa, “Béni wuna hanyandémbu satambéni. Béni wuni nandiwun guré nanditambéni. Wu mwi hundi dé. ");
INSERT INTO wos_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Hukémbu héndé wuna yika tamba sakumbu rete, héndé wuna aki tamba sakumbu rete? Wuni wun jooka yamba wakéwuni. Wu wuna hundi yingafwe. Wumbu retekwa duka God hanja déka mawulimbu dé wa.” ");
INSERT INTO wos_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Wun hundi wandéka di Jisasna du tamba atéfék wun jooka xéka di Jems bér Jonré rékambambu wa. ");
INSERT INTO wos_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Wandaka dé Jisas wandéka yandaka dé diré wa, “Guni xéké. Nak téfana néma du nawulak di du takwaka hambuk ye di wa, deka hundi jémba xéka di deka jémba yandate. ");
INSERT INTO wos_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","44","Guni di yandaka maki yakénguni. Guni wali rekwa du nak Godna makambu néma du renjoka mawuli yandét, dé guna jémba yakwa du retandé. Re dé guna hundi xéka dé wangun maki jémba yatandé. ");
INSERT INTO wos_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Duna Nyan wungi wuni ya. Du takwa wunika jémba yandate yahambawuni. Wuni du takwaka jémba ye diré yikafre hurunjoka wuni ya. Wuni hiyae séfélak du takwaré satanéna tambambu hérawut di God wali jémba rendate wuni ya.” Jisas dé wungi wa déka duré. ");
INSERT INTO wos_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Hukémbu Jisas déka du wali Jerikoré di yi. Ye xaakwa Jeriko yatakataka di séfélak du takwa wali di yambumbu yi. Yindaka dé dama hiyandé du nak yambumbu re dé du takwana yéwa héranjoka dé wa. Wun du dé Timeusna nyan Bartimeus dé. ");
INSERT INTO wos_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Wungi wata re dé hundi xéké Nasaretna du Jisas yindéka. Xéka dé Jisasré hambukmbu wakwexéka dé wa, “Ménawa, Devitna mandéka, wunika mé saréfa na.” ");
INSERT INTO wos_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Wungi wandéka séfélak du takwa di déré haraki hundi wa, “Nakélak sé nandé re.” Wungi wandaka dé nakélak rehambandé. Wambula wakwexéka dé wa, “Néma Du, Devitna mandéka, wunika mé saréfa na.” ");
INSERT INTO wos_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Wungi wandéka Jisas xékétaka yambumbu te dé wa, “Wun duré mé wa wunika yandéte.” Wungi wandéka di dama hiyandé duré wa, “Jisas dé we, déka yiméte. Méni sé ramé. Yikafre mawuli yataméni.” ");
INSERT INTO wos_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Wungi wandaka dé yifa yandéka sama rendén nukwa wur yakitaka dé raama yi Jisaska. ");
INSERT INTO wos_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Ye xakundéka dé déré wakwexéké, “Méniré méta yawute méni mawuli ye?” Wungi wakwexékéndéka dé dama hiyandé du wa, “Néma du, dama wambula xénjoka wuni mawuli ye.” ");
INSERT INTO wos_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Wungi wandéka dé wa, “Méni némbuli yitaméni. Méniré huréhalékéwun hambukka jémba sarékéméka némbuli ména dama yikafre wundé yandé.” Wungi wandéka déka dama bari yikafre yandéka dé jémba xé. Xe dé Jisas wali yambumbu yi. ");
INSERT INTO wos_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","2","Jisas déka du wali di Jerusalemré wara di betfagembu xaku. Xaakwa di xé Betani wali Oliv Némbu wali walémba rendéka. Wumbére getéfa yéték Oliv némbu walémbambu bér té. Xe xakunjoka ye Jisas dé déka du yétékré wa, “Béni wun getéfaré wulaaye xétambéni, donki nyan nak téndéka. Mimbu lékindaka dé té. Hanja du déka bunungulmbu rehambandé. Béni déka yoo lukwa hura mé béni ya. ");
INSERT INTO wos_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Yambét du nak béniré angi wakwexékéndét, ‘Méta yanjoka béni wun donki nyan lukwa hura yi?’ Wungi wandét béni angi watambéni, ‘Nana néma Du dé wun donkika mawuli ya. Dé bari hura yitandé.’ Wungi déré watambéni.” ");
INSERT INTO wos_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Wun hundi xékétaka bér ye bér xé donki ge makambu mimbu lékindaka yambumbu téndéka. Xétaka bér wun donkina yoo luku. ");
INSERT INTO wos_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Lukumbéka di du nawulak wumbu te di wa, “Wun donki nyan lukwa méta yatambéni?” ");
INSERT INTO wos_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","7","Wungi wakwexékéndaka bér Jisas wandén maki bér wa. Wambéka di wa, “Yawundu.” Wandaka bér donki nyan hura yi Jisaska. Ye bér bérka nukwa wur nawulak donkina bunungulmbu bér taka. Takambéka dé Jisas wumbu re. ");
INSERT INTO wos_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Re yindéka di séfélak du takwa nukwa wur nawulak di yambumbu taka. Takandaka di du nawulak di téfa téménga yambumbu xélitaka. ");
INSERT INTO wos_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Xélitaka di du takwa nyangwal nawulak tale yindaka di nawulak Jisasna hukémbu yitandi némafwimbu di wa: Néma Du God wandéka dé ya. Wu yikafre dé. God déré yikafre hurutandé. ");
INSERT INTO wos_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Nana mandéka Devit hanja néma du rendén maki, dé néma du re nanika jémba hatitandé. Néma du retendéka nukwa bari dé ya. Wu yikafre dé. Anwarmbu rekwa du Godna xi harékétame. Wungi di wa. ");
INSERT INTO wos_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Wandaka dé Jisas Jerusalemré wulayi. Wulaaye dé tempelré wulayi. Wulaaye dé atéfék jooré xé. Xétaka nukwa nandinjoka yandéka dé wun nukwa jémba yanjoka hélék ye dé déka du wali Jerusalem yatakataka di Betaniré wambula yi. ");
INSERT INTO wos_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Jisas Betanimbu hwae ganémbambu dé Jerusalemré wambula yinjoka nae yambumbu yindéka dé déré hénoo ya. ");
INSERT INTO wos_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Yandéka ye dé xé hambingal maki mi nak afakémbu téndéka. Séfélak ganga wun mimbu téndéka xe déka mawulimbu dé wa, “Séfélak ganga téndéka sék dé xaké wana. Nawulak géle satawuni.” Wungi wataka dé wun misék géle sanjoka yi. Ye wun misék nawulak xaka téndéka xéhambandé. Wun misék xakékwa nukwa yahambandé. Ganga male téndéka dé xé. ");
INSERT INTO wos_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Xe dé wa, “Du takwa ané mimbu wambula sék géle sakéndi.” Wungi wandéka déka du di déka hundi xéké. ");
INSERT INTO wos_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Jisas déka du wali di Jerusalemré yi. Ye xaakwa dé tempelré wulaaye dé xé du nawulak jondu hweta yéwa hérandaka. Xétaka dé diré héreki. Hérekitaka dé yéwa yawulekékwa duna jambé yanguréka yaki. Yakitaka dé xiyae Godka hwendan afwi hwekwa du rendé jambé yasamango yaki. ");
INSERT INTO wos_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Yakitaka dé diré wa, “Guni ané tempelmbu joo nawulak hérae hura yitaka yatakakénguni.” ");
INSERT INTO wos_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Wungi wataka dé wa, “Ané hundi Godna nyingambu dé re: God dé wa, ‘Atéfék héfambu yandé du takwa wuna geré xale wuni wali hundi bulétandi.’ God dé wungi wa. Wun hundika guni sarékéhambanguni. Guni ané gembu God wali hundi buléhambanguni. Guni jondu hweta yéwa héranguka ané ge sélé héraakwa duna ge maki dé.” ");
INSERT INTO wos_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Wungi wandéka di atéfék du takwa déka hundi xéka di waréngéné. Waréngénéndaka di prisna néma du, xékélelakikwa du akwi di wun jooka hundi xéké. Xéka di roo Jisaska. Roo di wa, “Yingi maki déré xiyakéme? Séfélak du takwa déka hundi xéka mawuli ye di waréngéné.” Wungi di wa. ");
INSERT INTO wos_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Nukwa nandindéka Jisas déka du wali di Jerusalem yatakataka di wambula yi. ");
INSERT INTO wos_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Nak getéfambu hwae ganémbambu raama Jisas déka du wali Jerusalemré wambula ye di xé wun mi réka ye téndéka. Nyinga, hambuk, méngi akwi, atéfék dé réka ya. ");
INSERT INTO wos_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Yandéka Pita xétaka dé Jisas wandén hundika saréka dé déré wa, “Néma du, mé xé. Wun mi bu réka ya. Nalika méni wun mika méni wa, ‘Du takwa ané mimbu wambula sék géle sakéndi.’ Wungi waméka némbuli dé bu réka ya.” ");
INSERT INTO wos_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Dé wungi wandéka Jisas dé diré wa, “Guni Godka mé jémba saréké. ");
INSERT INTO wos_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Mwi hundi wuni guniré we. Guni Godka jémba saréka mawuli yéték xékéhafi ye wangut, ‘God wuna hundi xékétandé.’ Wungi wata guni ané némbu ye néma xérimbu naande yindéte wangut dé ye néma xérimbu naande yitandé. ");
INSERT INTO wos_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Wun jooka saréka guniré wuni we. Guni Godré wakwexékéngut guna mawulimbu wangut ‘God hwetandé,’ wu God guniré hwetandé. ");
INSERT INTO wos_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Guni God wali hundi buléta yikafre mawuli yatanguni. Nak du takwa guniré haraki saraki joo yandat guniré yandan haraki saraki joo yatakatanguni. Wungi yatakangut anwarmbu rekwa du guna yafa God yangun haraki saraki joo yakwanyitandé wun jooka wambula yamba sarékékéndé. ");
INSERT INTO wos_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Guni nak du takwa guniré yandan haraki saraki jooka diré hasa hurunjoka mawuli yangut anwarmbu rekwa du guna yafa God yangun haraki saraki jooka guniré hasa hwetandé.” Jisas dé wungi wa. ");
INSERT INTO wos_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Jisas déka du wali di wambula yi Jerusalemré. Ye xaakwa dé tempelré wambula wulayi. Wulaaye yitaka yatakandéka di prisna néma du, xékélelakikwa du, getéfana néma du, wungi di déka yi. ");
INSERT INTO wos_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Ye di déré wa, “Méta hambuk hérae méni wun jémba ya? Héndé hwe ménika wun jémba, nana tempelmbu?” ");
INSERT INTO wos_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Wungi wandaka dé diré wa, “Wuni akwi nak hundi guniré wakwexékétawuni. Wakwexékéwut guni wuna hundi hasa wangut wuni guna hundi hasa watawuni. ");
INSERT INTO wos_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Guni mé wa. Héndé wa Jon du takwaré guré husandandéte? God dé wungi wa, o héfambu rekwa du nak dé wungi wa?” ");
INSERT INTO wos_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Wungi wakwexékéndéka di di hafu buléta di wa, “Nani angi wambet, ‘God dé wungi wa.’ Wungi wambet dé naniré angi watandé, ‘Métaka we guni déka hundi xékéhafi ya?’ ");
INSERT INTO wos_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Nani yingi wakéme? Nani angi wambet, ‘Héfambu rekwa du nak dé wa.’ Nani wungi wambet du takwa nani wali warutandi. Séfélak du takwa Jonka di wa, ‘Dé Godna profet dé. Wu mwi hundi dé.’ Wungi di wa.” ");
INSERT INTO wos_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Wungi bulétaka di yéna ye Jisasré wa, “Nani nawulak xékélakihambame. Wun hundi yamba wakéme.” Wungi wandaka dé diré wa, “Wuni akwi wuniré jémba hwendé duka yamba wakéwuni.” Dé wungi wa diré. ");
INSERT INTO wos_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Jisas dé ané sataku hundi diré wa: “Du nak dé wain bangwi dé se yawimbu. Setaka dé séndé gi. Séndé gitaka dé wekwa xa motumbu. Wun motu wekwa wain sék xakinjinyitendéka dé. Xataka dé yawika hatindate séményi ge nak dé to. Totaka dé wun yawika hatikwa duré jémba hwetaka dé afaké téfaré yi. ");
INSERT INTO wos_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Bangwi sék géli nukwa yandéka dé dé wali re jémba yakwa duré wa, dé déka yawiré yindéte. Dé bangwi sék nawulak hwendat hura yandéte dé mawuli ya. ");
INSERT INTO wos_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Ye wandéka déka du yindéka di yawika hatikwa du déré xiya. Xiyataka di déré wa, dé bangwi sék hérahafi baka yindéte. ");
INSERT INTO wos_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Wandaka yawina yafaka wambula yindéka dé déka du nakéka akwi wandéka dé yi dika. Yindéka di déka makambu xiyae di déré haraki saraki sémbut huru. ");
INSERT INTO wos_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Hurundaka dé yawina yafa déka jémba yakwa du nakéka akwi wandéka dé yi. Yindéka di déré xiyandaka dé hiya. Hiyandéka dé yafa du nawulakéka akwi wandéka di yi. Yindaka di atéfékré xiyandaka di nawulak hiya, nawulak hiyahambandi. ");
INSERT INTO wos_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Hiyandaka hukémbu dé yafa déka mawulimbu dé wa, ‘Wuna nyan male dé re. Déka wuni némafwi mawuli mawuli ye. Déka hundi xékétandi.’ Wungi wataka dé déka nyanré wandéka dé yawika hatikwa duka yi. ");
INSERT INTO wos_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Yindéka di yawika hatikwa du déré xe di di hafu hundi bulé. Bula di angi wa, ‘Yawina yafa hiyandét wumba nyan déka yafana atéfék jondu hératandé. Nani déré xiyataka nani yawi hératame.’ ");
INSERT INTO wos_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Wungi wataka di déré hura xiya. Xiyataka di déka fusa hérae hafwaré yakisangwandé.” ");
INSERT INTO wos_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Jisas wungi wataka dé diré wa, “Guni yingi guni saréké? Yawina yafa yae yawika hatindé duré yingi maki yatandé? Dé yae wun duré xiyatandé. Xiyae dé nawulak duka wun yawi hwetandé. ");
INSERT INTO wos_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","11","Xiyandan nyanka ané hundi Godna nyingambu dé re: Ge tokwa du yikafre motuka hwaka natafa motuka hélék yandaka dé baka re. Rendéka Néma Du God wun moturé xe dé wa, ‘Wun yikafre motu dé. Wun motu rendét ge jémba tétandé.’ Wungi wataka dé wun motu hérae takandéka dé ge jémba té. Téndéka nani xe nani yikafre mawuli ya. Wun hundi Godna nyingambu xétaka guni sarékéhambanguni.” Jisas dé wungi wa. ");
INSERT INTO wos_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Wun hundi wandéka di néma du di xéké. Jisas dika dé wun hundi safé. Wungi xéka di wa, “Nani déré duna makambu takatame.” Wungi wataka di déré huruhambandi. Métaka we? Di du takwaka di roo. Roo di déré yatakataka di yi. ");
INSERT INTO wos_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Néma du nawulak di hafu bula di wa, “Nani Jisasré nak jooka wakwexékémbet wafewana dé haraki saraki hundi hasa watandé, o yingafwe? Dé haraki saraki hundi wandét nani déré duna makambu takatame.” Wungi we di Farisina du nawulak, Herotna du akwi diré wandaka di Jisaska yi. ");
INSERT INTO wos_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Ye di déré wa, “Néma du, méni Godna jémbaka diré méni wakwe. Méni mwi hundi male wata diré Godna hundika jémba méni wakwe. Méni natafa hundi male méni wa, néma du takwa, baka du takwaré akwi. Méni dika roohambaméni. Wungi nani xéké. Méni wungi ye némbuli méni naniré mé wa. Yingi méni saréké? Nana hambuk hundi yingi dé wa? Nani yéwa Sisarka hwetame, o yingafwe? ");
INSERT INTO wos_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Nani Romka yéwa hwembet wu yikafre wana o haraki wana?” Wungi wandaka dé Jisas deka mawuli wundé xékélakindé. Di deka mawulimbu angi di wa, “Némbuli dé haraki saraki hundi wandét nani déré duna makambu takatame.” Wungi wandaka Jisas deka haraki mawuli xéka dé diré wa, “Guni yénataka du guni. Métaka we guni wuniré wungi wa? Guni wunika yéwa nak mé hura yawut xétawuni.” ");
INSERT INTO wos_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Wungi wandéka di déka yéwa nak hura yi. Hura yindaka dé wa, “Ané yéwambu rekwa waka wu héna saawi dé? Héna xi dé re yéwambu?” Wungi wakwexékéndéka di wa, “Wu Satanéna dé.” ");
INSERT INTO wos_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Wungi wandaka dé diré wa, “Wu mwi hundi dé. Sisarna joo guni déka hwetanguni. Godna joo guni Godka hwetanguni.” Wungi wandéka di wun hundi xéka di waréngéna di saré waréké. ");
INSERT INTO wos_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Sadyusina du deka mawulimbu di angi wa, “Hiyandé du takwa wambula yamba ramékéndi.” Di wungi wa. Di nawulak Jisaska yae di déré angi wa. ");
INSERT INTO wos_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","”Néma du, méni du takwaré Godna jémbaka méni wakwe. Méni ané jooka naniré mé wa. Hanja Moses angi dé hayi: Nyama takwa hési hérandéka lé nyan hérahafi yaléka dé hiya. Hiyandéka déka takwa relét déka bandi wule takwaré hératandé. Hérandét nyan héralét wun nyanka watandi, ‘Nyamana nyan dé.’ Wungi watandi. Wungi dé Moses hayi. ");
INSERT INTO wos_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Némbuli mé xéké. Hanja nyama bandi angé tamba yétiyéti angé tamba hufuk di re. Tale nyama nak takwa dé héra. Hérandéka lé nyan hérahafi yaléka dé hiya. ");
INSERT INTO wos_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Hiyandéka lé déka bandiré humbwe lé nyan hérahafi yaléka dé akwi dé hiya. Hiyandéka lé déka nak bandiré humbwe lé nyan hérahafi yaléka dé hiya. ");
INSERT INTO wos_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Hiyandéka lé atéfék bandinguré wungi male humbwe lé nyan hérahafi yaléka di hiya. Hiyandaka hukémbu lé wule takwa lé hiya. ");
INSERT INTO wos_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Némbuli naniré mé wa. Hiyandé du takwa ramétendaka nukwaka mé wa. Wumba nukwambu wule takwa héndé wali retalé? Hanja wunde nyama bandi atéfék diré lé humbwi.” Wungi di Sadyusina du Jisasré wa. ");
INSERT INTO wos_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Jisas deka hundi xéka dé diré wa, “Guni Godna nyingambu rekwa hundi nawulak xékélakihambanguni. Xékélakihafi ye Godna hambukka akwi xékélakihambanguni. Xékélakihafi ye guni du takwa wambula ramétendakaka akwi guni xékélakihambanguni. ");
INSERT INTO wos_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Mé xéké. Hukémbu God wandét hiyandé du takwa raama di Godna getéfambu re déka ensel maki retandi. Reta du dé takwa yamba hérakéndi. Takwa lé du yamba humbwikélé. ");
INSERT INTO wos_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Hundi nak akwi watawuni, hiyandé du takwa ramétendakaka. Hanja yalefu mi nak ya xérékéndéka dé Moses te xéndéka dé God déré hundi wa. Wandén hundi Moses Godna nyingambu angi dé hayi: Wuni Abrahamna néma du. Wuni Aisakna néma du. Wuni Jekopna néma du. Wuni deka néma du God wuni re. Wungi hayindéka guni wun hundi déka nyingambu xétaka guni sarékéhambanguni. ");
INSERT INTO wos_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Wun hundika sarékéta xékétame. Dé hiyandé duna néma du yingafwe. Wun du hanja di hiya. Tale di hiya. Hukémbu God dé wun hundi wa. Di hiyae wambula raama retendakaka dé God wun hundi wa. God hiyae raama huli tékwa duna néma du dé re. God wu huli rekwa duna néma du dé. Wungi nani xéké. Guni nak hundi wanguka guna mawuli haraki dé ya.” Wungi dé Sadyusina duré wa. ");
INSERT INTO wos_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Di hundi buléndaka dé xékélelakikwa du nak dé wumbu te dé xéké. Xékéndéka dé Jisas Sadyusina hundi jémba hasa wandéka dé xékétaka yae dé Jisasré wakwexéké, “Godna hambuk hundimbu méta néma hundi dé atéfék néma hundiré sarékéngwandé?” ");
INSERT INTO wos_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Wungi wakwexékéndéka dé Jisas wa, “Ané hundi dé atéfék néma hundiré sarékéngwandé: ‘Israelna du takwa, guni mé xéké. Nana Néma Du God wu natafa male dé. Dé hafu néma du dé re. ");
INSERT INTO wos_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Guni guna Néma Du Godka némafwimbu mawuli mawuli yatanguni. Ye guni déré wangut dé guna mawuli, guna hamwinya, guna anéngamba, guna hambukka dé néma du retandé.’ ");
INSERT INTO wos_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Nak néma hundi angi dé: ‘Guni hafuka mawuli yanguka maki, guna nyémayikaka némafwimbu mawuli yatanguni. Mawuli ye guni diré yikafre hurutanguni.’ Wumbére hundi yéték wu néma hundi bér. Atéfék néma hundiré yéték hundi bér sarékéngwandé.” ");
INSERT INTO wos_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Dé wungi wandéka dé wa, “Néma du, méni jémba méni we. Nana Néma Du God dé hafu nana néma du dé re. Nak néma du yingafwe. Méni mwi hundimbu méni we. ");
INSERT INTO wos_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Wamén maki, du takwa Godka némafwi mawuli yatandi. Ye di déré wandat dé deka mawuli, deka hamwinya, deka anéngamba, deka hambukéka dé néma du retandé. Rendét di hafuka mawuli yandaka maki, di deka nyémayikaka némafwimbu mawuli yatandi. Nani wun hundi yéték xéka nani jémba tétame. Wun hundi yéték hanja wandan atéfék hundiré wundé sarékéngwandémbé. Hanja wandaka nani hamwi xiyae motu jambémbu takataka nani Godka hwe. Hénoo akwi nani Godka hwe. Ména hundi Godka hamwi hénoo hwemben hundiré dé sarékéngwandé. Wamén hundi wu néma hundi dé.” ");
INSERT INTO wos_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Wun du jémba saréka dé wungi wa. Wandéka dé Jisas xéka dé déré wa, “Méni Godna héfa walémbambu méni té.” Wungi wandéka di nak hundi Jisasré wakwexékénjoka di roo. ");
INSERT INTO wos_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Jisas tempelmbu hundi wakwe dé diré wa, “Xékélelakikwa du di wa, ‘God wasékendén du Krais wu Devitna mandéka dé.’ Métaka di wungi wa? ");
INSERT INTO wos_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Hanja Krais ané héfambu rehafi yandéka Godna Hamwinya Devitna mawulimbu wulayi téndéka Devit dé Kraiska angi wa, ‘Wuna Néma Du dé.’ Wungi we dé angi wa: Néma Du God wuna Néma Du Kraisré dé wa, ‘Méni néma du re wuna yika tamba sakumbu retaméni. Remét wuni ména mama ména man mombu takatawuni.’ God dé wungi wa. ");
INSERT INTO wos_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Devit wun hundi we dé Kraiska ‘Wuna Néma Du dé’ dé na. Métaka dé Devit Kraiska wungi wa? Devit God wasékendén du Kraiska ‘Wuna Néma Du dé’ nandéka yingi maki dé Krais Devitna mandéka re? Krais Devitna mandéka re Devitna néma du akwi dé re, o yingi maki dé?” Wungi Jisas wandéka di séfélak du takwa déka hundi xéka di déka yikafre mawuli ya. ");
INSERT INTO wos_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Jisas ané hundi akwi dé diré wa: “Guni xékélelakikwa duka xékélaki na. Di séményi nukwa wur sandataka du takwa hérangwandéndaka hafwambu yitaka yatakanjoka di mawuli ya. Yitaka yatakandat du takwa diré xe angi wandate di mawuli ye: ‘Wu nana néma du di yi.’ Wungi wandate di mawuli ye. ");
INSERT INTO wos_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Di Godna hundi buléndaka geré wulaaye di néma duna héfambu renjoka di mawuli ya. Di séfélak du wali hénoo sata di yikafre hafwambu du takwana makambu renjoka di mawuli ya, di xe deka xiré harékéndate. ");
INSERT INTO wos_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Di duke takwana atéfék jondu héranjoka di mawuli ya. Di yéna yata di néma hundi Godré wa, nawulak du diré xe deka xiré harékéndate. Yandaka God wandét némafwi haraki saraki joo dika yatandé.” Wungi dé wa. ");
INSERT INTO wos_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Jisas yéwa takandaka hafwa walémbambu dé re, tempelmbu. Re dé xé séfélak du takwa Godka yéwa hwendaka. Xérénjuwi mama du takwa némafwi yéwa hwendaka dé xé. ");
INSERT INTO wos_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Xéndéka lé jambangwe duke takwa hési yae yalefu yéwa yéték Godka hweléka dé xé. ");
INSERT INTO wos_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","44","Xe déka duré wandéka di yandaka dé diré wa, “Xérénjuwi mama du takwa di Godka yéwa nawulak di hwe. Hwendaka deka yéwa nawulak akwi dé re gembu. Wule takwa yalefu yéwa yéték hwe lé hura relén yéwa atéfék lé hwe. Hwetaka lé hénoo hérateléka yéwa yingafwe. Godka hwelén yikafre sémbut, di hwendan sémbutré dé sarékéngwandé. Mwi hundi wuni guniré we.” Jisas dé wungi wa. ");
INSERT INTO wos_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Jisas tempel yatakanjoka yandéka déka du nak dé déré wa, “Néma du, ané yikafre geré mé xé. Yikafre motu male dé.” ");
INSERT INTO wos_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Wungi wandéka dé Jisas déré wa, “Xéxé, némbuli wun yikafre ge dé. Yikafre motu téndéka nani xé. Hukémbu mamawa du yae ané ge atéfékré haraki hurutandi. Haraki hura di ané motu hérae yakisandandat ané motu nak motu tokumbu yamba rekéndé. Yingafwe.” ");
INSERT INTO wos_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","4","Wun hundi wataka Jisas tempel yatakataka ye dé Oliv némburé waré. Wara re dé tempelré xé. Xéndéka di déka du Pita, Jems, Jon, Andru, di male déka yae di déré wa, “Naniré mé wa. Yinga nukwa tempel haraki hurutandi? Méta joo tale yandét xétaka nani angi watame? ‘Némbuli wun haraki saraki joo yatandé.’ Yinga nukwa nani wungi watame?” ");
INSERT INTO wos_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Wungi wakwexékéndaka dé wa, “Guni xékélaki na. Ye yénataka duna hundi xékékénguni. ");
INSERT INTO wos_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Séfélak du yae wuna ximbu yéna yata di watandi, ‘Wuni God wasékendén du Krais wuni.’ Wungi wandat séfélak du takwa yénataka hundi xékétandi. ");
INSERT INTO wos_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Séfélak du waretandi. Warendat guni waretendakana hundi xékétanguni. Xékéta guni rookénguni. Tale wungi yatandi. Hukétéfi nukwa wayika xakukéndé. ");
INSERT INTO wos_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Nak héfambu rekwa du takwa di nak héfambu rekwa du takwa wali waretandi. Nak néma duna hém, nak néma duna hém wali waretandi. Séfélak héfambu, séfélak nukwa nono yatandé. Du takwa hénooka hiyatandi. Nawulak takwa nyan héranjoka hangéli hérandaka maki wungi xaké sérikéma xakutandé.” ");
INSERT INTO wos_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","“Guni xékélaki na. Guni wuna du nawulak wuna jémbaka hélék ye di guniré huluke hari guniré duna makambu takate. Godna hundi buléndaka gembu guniré xiyatandi. Guniré hura yindat guni deka néma duna makambu tétanguni. Métaka we? Guni wuna jémba guni ye. Te guni wuna hundi diré safétanguni. ");
INSERT INTO wos_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Wuna du takwa tale di atéfék héfambu rekwa du takwaré wuna hundi safétandi. Saféndat hukétéfi nukwa yatandé. ");
INSERT INTO wos_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Guniré hura duna makambu takandat guni tale guna mawulimbu angi wakénguni, ‘Nani yingi hasa watame?’ Wungi wakénguni. Métaka we? Godna Hamwinya déka hundi gunika hwetandé. Godna Hamwinya guna mawulimbu te guniré hundi watandé. Wandét guni xéka wun hundi diré safétanguni. Guna mawulimbu saréka hundi wakénguni. ");
INSERT INTO wos_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Wun haraki saraki nukwa séfélak du deka nyamangu bandinguré duna makambu takandat di nyama bandiré xiyandat hiyatandi. Yafa deka nyanré duna makambu takandat di wun nyanré xiyate. Nyangwal akwi deka yafa ayiwaré duna makambu takandat di yafa ayiwaré xiyate. ");
INSERT INTO wos_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Guni wuna duka atéfék du takwa hélék yatandi. Wun jooka rookénguni. Hukémbu wun xak xakundét wuna jémba yakwa du wun jooka roohafi yandat, God wun du takwaré hérandét di dé wali jémba reséketandi, wungi re wungi re.” Jisas dé wungi wa. ");
INSERT INTO wos_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","Wun hundi wataka dé Jisas angi dé wa: “Hanja profet nak dé ané hundi hayi: Hukémbu du nak yae tempelmbu Godka haraki hundi wandén joo nak takatandé. Takandét di wun geka ‘Haraki saraki ge dé’ natandi. (Guni ané nyingambu xe ané jooka jémba sarékétanguni.) Wungi hayindén joo xakundét guni xétanguni. Xe wun nukwa guni Judiambu rekwa du takwa guna getéfa yatakataka yaange némburé yitanguni. ");
INSERT INTO wos_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Wun nukwa taku gembu rekwa du takwa bari yaange yitandi. Deka joo héranjoka deka geré wambula yamba wulayikéndi. Baka yaange yitandi. ");
INSERT INTO wos_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Yawimbu tékwa du takwa deka sanda wur héranjoka getéfaré wambula yamba yikéndi. Bari yaange yitandi. ");
INSERT INTO wos_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Wun haraki saraki nukwa nyan tékwa takwa, nyangwalka munya hwekwa takwa bari yaange yinjoka hurufatikétandi. Dika wuni saréfa nae. ");
INSERT INTO wos_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Guni Godka mé wa, “Wun joo yifa ya nukwambu xakukéndé.” ");
INSERT INTO wos_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Wun nukwa séfélak xakéngali xakutandé. Hanja God atéfék joo huratakandén nukwa wungi maki xakéngali nawulak xakuhambandé. Némbuli akwi hukémbu akwi wungi maki xakéngali wambula yamba xakukéndé. ");
INSERT INTO wos_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Wun xakéngali xakundét God déka du takwaka saréfa nandét wun xakéngali bari hényitandé. Wungi wahafi yandét wu atéfék du takwa hiyatandi. ");
INSERT INTO wos_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Wun nukwa du nawulak gunika angi wandat, ‘Ané duré mé xé. Ané God wasékendén du Krais dé.’ Wungi wandat guni deka hundi xékékénguni. Di angi wandat, ‘Wun duré mé xé. Wu God wasékendén du Krais wumbu dé re.’ Wungi wandat guni deka hundi xékékénguni. Di yéna di ye. ");
INSERT INTO wos_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Séfélak du yae Godna du takwaré yéna ye nak nak angi watandi, ‘Wuni God wasékendén du Krais wuni.’ Wungi wandat nawulak yéna ye nak nak angi watandi, ‘Wuni Godna profet wuni.’ Wungi wataka di yéna yata di nak maki nak maki hambuk jémba, hanja xéhafi yangun hambuk jémba akwi yatandi. Guna mawuli haraki hurunjoka di wungi yatandi. ");
INSERT INTO wos_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Guni xékélaki na. Guniré wuni we, hukémbu xakute yakwa jooka. Hukémbu wun joo yandét guni xe xéka guni deka hundi xékékénguni.” ");
INSERT INTO wos_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","Wun hundi wataka dé Jisas angi dé wa: “Wun némafwi xak hényindét bari nukwa yindét gan hunyitandé. Hunyindét bafu akwi yamba larékélé. ");
INSERT INTO wos_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Atéfék hunkwari nyirmbu te xakritandi. Xakrindat nyirmbu tékwa atéfék joo séngéna yitaka yatakatandi. ");
INSERT INTO wos_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Yitaka yatakandat ané héfambu rekwa du takwa di Duna Nyanré xétandi. Wuni némafwi hambuk ya nukwa xékwa maki wuni ye buwimbu re gayawut xétandi. ");
INSERT INTO wos_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Xéndat wuni wawut wuna ensel atéfék héfambu tékwa atéfék getéfaré ye wuna du takwaré hura yae natafambu takatandi.” ");
INSERT INTO wos_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","Wun hundi wataka dé Jisas angi dé wa: “Mika jémba mé saréké. Mi nawulak ganga xakre huli ganga hunyi yalendéka xe guni xéké. Héki naré yakwa nukwa dé. ");
INSERT INTO wos_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Wun miré xénguka maki, guni saféwun jooka xe xékélakitanguni. Wuni bari hari wambula yatawuni. ");
INSERT INTO wos_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Guniré mwi hundi wuni we. Némbuli rekwa du takwa nawulak hiyahafi ye wuna saféwun hundi xétandi. ");
INSERT INTO wos_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Nyir akwi héfa akwi hényitandé. Wuna hundi yamba hényikéndé. Wungi reséketandé. Mwi hundi wuni guniré we.” ");
INSERT INTO wos_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","“Ané héfambu rekwa du takwa wun nukwaka xékélakihambandi. Ensel akwi wun nukwaka xékélakihambandi. Wuni Godna nyan wuni akwi xékélakihambawuni. Wuna yafa dé hafu dé wambula yatewuka nukwaka dé xékélaki. ");
INSERT INTO wos_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Guni xékélaki na. Guni wunika mé haxéta té. Guni guna Néma Du yatewuka nukwaka xékélakihambanguni. ");
INSERT INTO wos_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Ané hundika mé saréké. Néma du nak getéfaré yinjoka ye tale dé déka jémba yakwa duka nak nak jémba hwe. Hwetaka dé yambuka hatikwa duré wa, ‘Méni wuna geka jémba hatitaméni.’ Wungi wataka dé déka ge yatakataka dé afaké getéfaré yi. Wunde du yikafre jémba ye wambula yatendékaka saréka jémba haxétandi. ");
INSERT INTO wos_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Guni wunde du maki jémba haxétanguni. Guni xékélakihambanguni. Yinga nukwa wuni guna néma du wambula yatawuni? Gérambu yatawuni wana, o gan yatawuni wana, o séra wandét yatawuni wana, o ganémba yatawuni wana? Wun nukwaka xékélakihambanguni. ");
INSERT INTO wos_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Bari yae xétawuni, wunika huli reta haxétanguni wana o xéndi hwatanguni wana. ");
INSERT INTO wos_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Guniré saféwun hundi gunika atéfék wuni we. Guni xékélaki na.” Jisas dé wungi wa déka duré. ");
INSERT INTO wos_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Nukwa yéték yindét yis huruhafi yandé bret hura sa nukwa yatandé. Wun nukwa di Juda némafwi hénoo hura satandi. Wun hénooka di wa Pasova. Wun nukwa di prisna néma du, xékélelakikwa du akwi di mawuli ya, di nakélak ye Jisasré huluke déré xiyanjoka. ");
INSERT INTO wos_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Ye di wa, “Déré xiyatame. Hénoo hura sa nukwa déré yamba hurukéme. Némbuli séfélak du takwa wun hénoo sanjoka ané getéfaré di ya. Némbuli nani Jisasré hurumbet di nani wali waritandi. Di yindat nani déré hura xiyatame.” Di wungi wa. ");
INSERT INTO wos_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Jisas dé Betaniré yi. Ye xaakwa dé hanja walisufu hurundén duna gembu dé re, wun duna xi Saimon. Reta dé di wali hénoo sata rendéka lé takwa hési motuna andémbu hulingu téndéka lé hura ya. Wun hulingu yikafre yama xaakwa hulingu dé. Du wun hulingu héranjoka séfélak yéwa hwetandé. Wule takwa yae lé Jisas rendénmbu te lé andé hutukwe lé déka anéngambambu wun hulingu bleké. ");
INSERT INTO wos_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Blekéléka di du nawulak xe di di hafu bula di léré rékambambu wa. Rékambambu we di wa, “Métaka lé wun hulingu baka bleké? ");
INSERT INTO wos_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Wun hulingu wu yikafre hulingu dé. Lé wun hulingu hwetaka séfélak yéwa hérae jambangwe du takwaka hwelét wu yikafre dé.” Wungi wataka di léré haraki hundi wa. ");
INSERT INTO wos_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Jisas deka hundika hélék ye dé diré wa, “Métaka guni wule takwaré haraki hundi we? Wungi wakénguni. Wu yikafre lé huru wunika. ");
INSERT INTO wos_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Jambangwe du takwa di guni wali reséketandi. Di wungi rendat guni dika mawuli ye guni diré yikafre hurutanguni. Wuni guni wali yamba resékekéwuni. ");
INSERT INTO wos_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Wule takwa lé wuniré jémba lé huru. Wuni hiyawut wekwambu rémétendakaka saréka lé némbuli wun hulingu wuna séfimbu bleké.” Dé wungi wa. Judana sémbut angi dé, du hiyandét yama xaakwa hulingu déka séfimbu blekétandi. ");
INSERT INTO wos_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Wataka dé diré angi wa, “Hukémbu di wuna hundi atéfék héfana du takwaré we, ale takwa hurulén jooka akwi safétandi. Saféta di léka sarékétandi. Mwi hundi wuni guniré we.” Dé wungi wa diré. ");
INSERT INTO wos_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Wun nukwa dé Jisasna du nak, déka xi Judas Iskariot, dé prisna néma duka yi. Ye dé Jisasré dika hwenjoka dé hundi bulé. ");
INSERT INTO wos_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Buléndéka di déka hundi xéka di mawuli sawuli ya. Ye di déka yéwa nawulak hwenjoka di hundi bulé sékéréké. Hundi bulé sékérékéndaka dé Jisasré mama duré hwe yambuka dé hwaké. ");
INSERT INTO wos_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Yis yike bret sa nukwa dé xaku. Tale wun nukwa sipsip bali nyanré di xiya, wun nukwaka di angi wa Pasova God israelka sarékéndén yikafre nukwa dé. Wun nukwa Jisasna du déka yae di wa, “Méni yin hafwaka méni mawuli ye Pasovana hénoo sanjoka?” ");
INSERT INTO wos_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Wungi wakwexékéndaka dé du yétékré wa, “Béni ye Jerusalemré wulaaye hulingu yate yaakwa du nakré xétambéni. Xe béni déka hukémbu yitambéni. ");
INSERT INTO wos_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Ye wulayindéka geré sa béni wulayi. Wulaaye wun gena yafaré angi béni wa, ‘Godna hundika naniré wakwekwa du dé ménika angi dé wa: Wuni wuna du wali Pasovana hénoo satembeka ge yimbu dé té? Wungi dé wa.’ ");
INSERT INTO wos_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Wungi wambét dé anwarmbu tékwa néma ge nak wakwetandé. Wun gembu hénoo sa jambé, re jambé akwi dé té. Béni wun gembu hénoo nanika humbwinjoka yitambéni.” ");
INSERT INTO wos_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Wungi wandéka bér ye Jerusalemré wulaaye Jisas wandén maki bér xé. Xétaka bér Pasovana hénoo humbwi. ");
INSERT INTO wos_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Nukwa nandindéka dé Jisas déka du tamba atéfék man yéték wali wungi di ya. ");
INSERT INTO wos_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Yae reta di hénoo sa. Sata reta dé diré wa, “Nani wali reta sakwa du nak wuniré mama duka hwetandé. Mwi hundi wuni guniré we.” ");
INSERT INTO wos_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Wungi wandéka di haraki mawuli xéka di nak nak déré wakwexéké, “Wu wunika méni wa, o héndéka méni we?” ");
INSERT INTO wos_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Wungi wakwexékéndaka dé wa, “Wuna du nak. Wuni wali andémbu també bret hura sakwa du wuniré mama duka hwetandé. ");
INSERT INTO wos_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Duna Nyan hiyawata wuni ya. Godna nyingambu hiyatewukaka di hanja hundi hayi. Saréfa wuni nae wumba duka, Duna Nyanré mama duka hwetekwa duka. Wun duré déka ayiwa hérahafi yalét wu yikafre dé.” Jisas dé wungi wa. ");
INSERT INTO wos_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Di hénoo sata rendaka dé Jisas bret hérae dé Godka diména nataka dé bret fukae dé déka duka hwe dé wa, “Guni hura satanguni. Ané wuna séfi dé.” ");
INSERT INTO wos_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Wungi wataka dé wain hanyandé wali hulingu hérae dé Godka diména nataka dé dika hwendéka di sa. ");
INSERT INTO wos_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Sandaka dé diré wa, “Ané wuna nyéki dé. Di wuniré xiyandat wuna nyéki yindét guni xe xékétanguni, God du takwaré yikafre hurunjoka wandén hundi mwi hundi dé ya. Wuni hiyae séfélak du takwaré yikafre hurunjoka wuni ya. ");
INSERT INTO wos_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Mwi hundi wuni guniré we. Ané yalefu nukwambu guni wali sataka wuni wain hulingu wambula yamba sakéwuni. Hukémbu wuna yafa God du takwaka néma du rendét nani déka getéfambu dé wali re wuni guni wali huli wain hulingu satawuni.” ");
INSERT INTO wos_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Wungi wandéka di Godna nyingambu rekwa gwar wataka raama gwande di Oliv némburé wari. ");
INSERT INTO wos_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Jisas dé déka duré wa, “Wuni xéké. Guni atéfék wunika hu hwe yaange yitanguni. Yaange yitengukaka Godna hundi déka nyingambu angi dé wa: Wuni sipsip balika hatikwa duré xiyawut di sipsip bali yaange yitandi. ");
INSERT INTO wos_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Wun hundi wandén maki yaange yitanguni. Yingut wuni hiyatawuni. Hiyae hukémbu wambula raama wuni Galiliré tale yitawuni. Yiwut guni hukémbu yatanguni.” ");
INSERT INTO wos_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Wungi wandéka dé Pita déré wa, “Wuni ménika hu yamba hwekéwuni. Wuni yaange yamba yikéwuni. Di ménika hu hwe yaange yindat wuni wungi yamba yikéwuni.” ");
INSERT INTO wos_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Wungi wandéka dé wa, “Mwi hundi wuni ménika we. Némbuli gan yambu hufuk wataméni, ‘Wuni Jisaska yike wuni ye.’ Wungi tale wamét séra yambu yéték watandé.” ");
INSERT INTO wos_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Wungi wandéka dé wa, “Yinga! Wungi yamba wakéwuni. Wuni méni wali hiyatawuni wuni yamba rookéwuni. Wungi yamba wakéwuni.” Wungi wandéka di Jisasna du atéfék wungi male di wa. ");
INSERT INTO wos_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Wun hundi wataka di Jisas wali nak yawiré wulayi. Wun yawina xi Getsemani. Wulaaye dé déka duré wa, “Guni ambu re. Wuni God wali hundi bulénjoka yitawuni.” ");
INSERT INTO wos_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Wungi wataka dé Pita, Jems, Jonré hérae hura di yi. Yindaka dé déka mawuli xak yandéka dé saré waréké. ");
INSERT INTO wos_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Xak yandéka dé diré wa, “Wuna biya mawuli xak yandéka hiyawata wuni huru. Guni ambu re. Guni xéndi hwakénguni.” ");
INSERT INTO wos_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","36","Wungi wandéka rendaka dé wambula ye dé héfambu xakre hwaata dé Godka wa, “Wuna yafa, méni atéfék joo hali hurumé. Mé héreki ané hanyandé. Wunika hwekéméni. Méni wuna mawuli yawukangalambu hurukéméni. Méni ména mawuli yamékangalambu hurutaméni.” ");
INSERT INTO wos_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Wun hundi wataka dé déka duka wambula ye dé xé di xéndi hwandaka. Xéta dé diré sérkena dé Pitaré wa, “Saimon, xéndi méni hwae, o yingi maki dé? Méni yalefu nukwa wuni wali reta hatitaméni, yingafwe? ");
INSERT INTO wos_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Guni xékélaki na. Godka wangut guniré hurukwexé nukwa yamba xakukéndé. Guna hamwinya mawuli dé ye, guna séfimbu xak dé ye.” ");
INSERT INTO wos_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Wungi wataka dé wambula ye dé tale Godka wandéngala hundi male dé wambula wa. ");
INSERT INTO wos_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Wataka dé déka duka wambula yae dé xé di wambula xéndi hwandaka. Deka dama némafwi xéndi yandéka di xéndi hwa. Hwae waréngéna di déré wambula xe di xékéhambandi. Méta hundi déré watandi? Xékéhafi ye di nakélak re. ");
INSERT INTO wos_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Dé wambula ye Godka wataka dé déka duka wambula yae diré sérkena dé wa, “Yingi makika guni xéndi hwae? Yak. Mé xé. Duna Nyanré haraki saraki sémbut hurukwa duka hwendén nukwa andé yae. ");
INSERT INTO wos_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Sé raméngut yikwa. Mé xé. Wuniré mama duré hwete yakwa du bu yae dé té.” ");
INSERT INTO wos_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Jisas wata téndéka dé tamba atéfék ye man yéték jémba yandén du nak Judas bari dé ya. Séfélak du di warendaka yar akwi bangi akwi hura di dé wali ya. Prisna néma du, getéfana néma du, xékélelakikwa du akwi talembu wungi wandaka di ya. ");
INSERT INTO wos_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Talembu Jisasré mama duka hwetekwa du Judas dé Jisasré hurute yakwa duré dé wa, “Wuni du nakré tamaruwut, wumba du wu Jisas dé. Guni déré hura jémba hate hura yitanguni.” ");
INSERT INTO wos_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Judas Jisaska bari yae dé wa, “Néma du.” Wungi wataka dé déré hura tamaru. ");
INSERT INTO wos_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Rundéka di dé wali yandé du di Jisaska yae di déré huru. ");
INSERT INTO wos_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Hurundaka dé wumbu téndén du nak warendaka yar hafute dé prisna néma duka jémba yakwa duna waan xatékéndéka dé xakri. ");
INSERT INTO wos_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Yandéka dé Jisas diré wa, “Guni wuniré hurunjoka yae métaka guni warendaka yar akwi bangi akwi hura ya? Guni sélé héraakwa duré xiyanjoka guni wun joo hura ya, o yingi maki dé? ");
INSERT INTO wos_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Séfélak nukwa wuni tempelmbu reta wuni du takwaré Godna hundika wakwe. Wumbu rewuka guni wuniré huruhambanguni. Wuniré yangun jooka hanja du nawulak Godna nyingambu di hayi. Hanjambu hayindan hundi némbuli mwi hundi dé xaku.” ");
INSERT INTO wos_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Wungi wandéka déka du atéfék déré yatakataka di yaange yi. ");
INSERT INTO wos_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Déka du yaange yindaka di Jisasré hura yi. Hura yindaka natafa wama nukwa wur male nakindé du nak dé Jisasna hukémbu yi. Dé wayikana du dé. Yindéka di déré hurunjoka ye di déka nukwa wurmbu huru. ");
INSERT INTO wos_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","Hurundaka dé nukwa wur lafitaka dé séfi male yaange yi. ");
INSERT INTO wos_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Jisasré hurundé du di déré hura yi, prisna néma duka. Prisna atéfék néma du, getéfana néma du, xékélelakikwa du akwi di prisna néma du déka gembu hérangwanda di re. ");
INSERT INTO wos_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Pita afaké maki Jisasna hukémbu ye dé néma duna geka séndé gisangwandéndan hafwaré wulayi. Wulaaye dé gélindu wali hafwambu re. Yifa yandéka dé di wali yambu re. ");
INSERT INTO wos_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Prisna néma du, israelna nawulak néma du akwi di Jisasré xiyandat hiyandéte di mawuli ya. Wunde du di wa, nawulak duka yae wandate Jisas hurundén sémbutka. Wungi wandaka du nak wungi wahambandé. ");
INSERT INTO wos_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Séfélak yénataka du yae di Jisas hurundén jooka safé. Saféta di natafa hundi wahambandi. ");
INSERT INTO wos_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","58","Du nawulak te yéna ye di Jisaska wa, “Wun du angi dé wa, ‘Du tondan ané ge, tempel wuni glara yakitawuni. Glara yakitaka nukwa hufuk yindét wuni nak maki ge totawuni.’ Wungi wandéka nani xéké.” ");
INSERT INTO wos_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Wungi we di nak maki hundi nak maki hundi di wa. Natafa hundi wahambandi. ");
INSERT INTO wos_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Wun hundi wandaka dé prisna néma du raama te dé Jisasré wa, “Métaka we méni deka hundi hasa wahafi méni? Deka hundi yingi maki dé?” ");
INSERT INTO wos_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Wungi wandéka dé hundi nawulak buléhambandé. Buléhafi yandéka dé prisna néma du déré wa, “Méni God wasékendén du Krais méni? Méni Néma Du Godna nyan méni wana, o yingafwe?” ");
INSERT INTO wos_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Wungi wandéka dé wa, “Xéxé. Hukémbu guni xétanguni, Duna Nyan néma du re némafwi hambuk hérae Godna yika tambambu re buwi wali nyirmbu gayatewuka.” ");
INSERT INTO wos_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Wungi wandéka dé prisna néma du waréngéné nae dé hafu déka nukwa wur haléngataka dé wa, “Wu haraki saraki hundi dé. Nawulak duka yamba wakéme, hurundén haraki saraki jooka. ");
INSERT INTO wos_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Dé Godka haraki hundi wandéka guni déka hundi bu xékéngu. Yingi guni we déka?” Wungi wandéka di wa, “Dé haraki saraki sémbut dé huru. Dé métaka hiyandé.” ");
INSERT INTO wos_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Wun hundi wataka di nawulak Jisasna séfimbu simbar séxa. Séxataka di déka damambu nukwa wur nak gi. Gitaka di déré xiya. Xiyaata déré haraki hundi wata di wa, “Méni Godna profet méni atéfék jooka méni xéké. Xéka, naniré mé wa. Héndé méniré xiyae?” Wungi wandaka di gélindu déré hura di déré xiya. ");
INSERT INTO wos_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Pita andélambu dé re. Geka séndé gindan hafwambu dé re. Rendéka lé prisna néma du déka jémba yakwa takwa hési ya. ");
INSERT INTO wos_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Yae lé xé Pita yambu rendéka. Xe lé déré wa, “Méni akwi Nasaretmbu yandé du Jisas wali méni té.” ");
INSERT INTO wos_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Wungi waléka dé wa, “Yingafwe. Wuni wanyén mo hundika yike wuni ye.” Wungi wataka gwande dé tambumbu re. Rendéka dé séra wa. ");
INSERT INTO wos_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Wandéka wule takwa déré wambula xe lé lé wali téndé du takwaré wa, “Ané du akwi wu déka jémba hurundé du dé.” ");
INSERT INTO wos_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Wungi waléka dé wambula wa, “Yingafwe.” Wungi wandéka nawula re di wumbu téndé du di wambula wa, “Di Galilimbu di ya. Méni akwi Galilina du méni. Méni Jisasna du nak méni. Wu mwi hundi dé.” ");
INSERT INTO wos_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Wungi wandaka dé Pita diré hambukmbu dé wa, “Yingafwe. Wanguka duka yike wuni ye. Mwi hundimbu wuni we. Mwi hundi wahafi yawut God wuniré xiyatandé.” ");
INSERT INTO wos_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Wungi wandéka dé séra wambula wa. Wandéka dé Jisas déré wandén hundika dé saréké. Nalika Jisas dé wa, “Wuni xékélaki. Séra yambu yéték wandét méni yambu hufuk wataméni, ‘Wuni déka yike wuni ye.’ Wungi wamét séra wambula watandé. Wungi wuni xékélaki.” Wun hundika saréka dé Pita némafwimbu saréfa naata dé géra, dé Jisaska hu hwendénka. ");
INSERT INTO wos_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Télakéndéka di prisna néma du, israelna getéfana néma du, xékélelakikwa du, atéfék néma du akwi hérangwanda di hundi bulé. Bulétaka wandaka di Jisasré yoombu gitaka di Romna néma du Pailatka di déré hura yi. ");
INSERT INTO wos_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Hura yindaka dé Pailat Jisasré wakwexéké, “Méni Judana néma du o yingafwe?” Wungi wakwexékéndéka dé wa, “Xéxé. Méni hafu méni wundé wamé.” ");
INSERT INTO wos_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Wungi wandéka di prisna néma du di séfélak yénataka hundi safé, Jisas hurundén jooka. ");
INSERT INTO wos_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Saféndaka dé Pailat déré wa, “Di ménika séfélak hundi di safé, hurumén jooka. Métaka méni deka hundi hasa wahafi ye méni xékéta nakélak té?” ");
INSERT INTO wos_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Wungi wandéka dé Pailatré hundi nawulak akwi wahambandé. Wahafi yandéka dé saré waréké. ");
INSERT INTO wos_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Atéfék héki hwari Pasovana nukwa dé Romna néma du wandéka du takwa mawuli yandan du nak séndé ge yatakataka gwande dé jémba yi. ");
INSERT INTO wos_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Wun nukwa haraki saraki sémbut hurundé du nawulak di séndé gembu hwa. Hanja di Romna duka hélék ye Jerusalemmbu rekwa du takwaré wandaka di Romna du wali ware. Nak nukwa di duré xiya. Wun haraki saraki sémbut hurundé du nak wu Barabas dé. ");
INSERT INTO wos_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Atéfék du takwa yae di Pailatré wakwexéké, atéfék héki hwari wandén maki wambula wandéte. ");
INSERT INTO wos_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","10","Wakwexékéndaka dé Pailat xékélaki, Jisas haraki saraki joo nawulak yahambandé. Prisna néma du di Jisaska hélék ye déré gitaka di hura ya déka. Wungi xéka dé déka mawulimbu dé wa, “Wafewana ambu hérangwanda tékwa du takwa Jisaska mawuli yatandi, o yingafwe?” Wungi we dé wun du takwaré wa, “Judana néma duré wawut dé jémba yindéte guni mawuli ye, o yingafwe?” ");
INSERT INTO wos_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Wungi wandéka di prisna néma du di wumbu téndé du takwaré wandaka di Pailatré wa, “Yinga! Jisasré mé hulukita, Barabasré métaka yindé.” ");
INSERT INTO wos_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Wungi wandaka dé Pailat dé diré wambula wa, “Wangun Judana néma duré yingi maki yakéwuni?” ");
INSERT INTO wos_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Wungi wakwexékéndéka di atéfék di wa, “Déré mé xiyae hateka mimbu.” ");
INSERT INTO wos_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Wungi wandaka dé wa, “Métaka we? Méta haraki saraki sémbut dé huru?” Wungi wandéka di hambukmbu wa, “Déré mé xiyae hateka mimbu.” ");
INSERT INTO wos_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Wungi wandaka Pailat déka mawulimbu dé wa, “Wuni deka hundi xékéwut di wunika mawuli yatandi.” Wungi wataka dé wa, Barabas séndé ge yatakataka gwande jémba yindéte. Wataka dé déka xi warekwa duré dé wa, di Jisasré rami yoombu xiyae déré mimbu hatekandate. ");
INSERT INTO wos_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Pailatna xi warekwa du di déka néma geré di Jisasré hura wulayi. Hura wulaaye amembu téta di wandaka di atéfék xi warekwa du yae di dé téndénmbu hérangwandé. ");
INSERT INTO wos_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Hérangwanda di Jisaska wangita haraki hundi wa, déka nukwa wur lafitaka di néma du gindaka waka nukwa wur sandataka. Sandataka di rami yoo nak hérae di néma du sandandakangala gootuwa di déka anéngambambu sandataka. ");
INSERT INTO wos_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Sandataka di déré wa, “Méni, Judana néma du, jémba retaméni.” ");
INSERT INTO wos_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Wungi we bangi nak hérae di déka anéngambambu xiya. Xiyaata di déré simbar séxata di déré haraki hundi we, déka hwati se di wandé da. ");
INSERT INTO wos_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Wungi hurutaka di sandatakandan waka nukwa wur lafitaka di déka nukwa wur wambula sandataka. Sandataka di déré hura yi mimbu hatekanjoka. ");
INSERT INTO wos_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Yambumbu ye di xi warekwa du Sairinimbu yandé du nakré di xé. Déka xi Saimon dé. Déka nyan yéték Aleksander bér Rufus. Dé nak hafwambu yae Jerusalemré wulayinjoka yandéka di xé. Xe di déré wa, dé Jisasré xiyae hatekate ya mi yatandéte. ");
INSERT INTO wos_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Jisasré hura yae di xaku nakémba hafwambu. Wun hafwana xi Golgota. Mo hundi angi dé: Duna Anéngambana Héfa. ");
INSERT INTO wos_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Xaakwa di marasin wali hurundan wain hulingu Jisaska hwe, dé se némafwi hangéli yahafi yandéte. Hwendaka dé sahambandé. ");
INSERT INTO wos_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Sahafi yandéka di déré xiyae mimbu hateka. Hatekataka di déka nukwa wur mune di di yalefu motu yakisawaré. Yakisawaréndaka wara gaya xakrindéka di wa, “Méta joo hératame?” ");
INSERT INTO wos_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Ganémba di Jisasré xiyae mimbu hateka. ");
INSERT INTO wos_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Déré xiyae hatekandan mi anwarmbu haaye takandan hundi wu angi dé: Ané Judana néma du dé. ");
INSERT INTO wos_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Jisasré xiyae mimbu hatekataka di sélé hérandé du yétékré akwi di xiyae mimbu hateka. Nakré di déka yika tamba sakumbu xiyae hateka. Nakré di déka aki tamba sakumbu xiyae hateka. ");
INSERT INTO wos_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Wungi hurundaka Godna nyingambu hanja hayindan hundi wun nukwa mwi hundi dé ya. Angi di hayi: Déré di xé haraki saraki sémbut hurundé du wali téndéka. ");
INSERT INTO wos_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Du nawulak yitaka yatakata Jisasré xiyae mimbu hatekandaka téndéka xe di déka wangita di haraki hundi wa. Ye di wa, “Ménawa. Yingi maki dé? Méni tempel haraki hura nukwa hufuk yindét méni wambula tonjoka méni wa. ");
INSERT INTO wos_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Némbuli méni hafu ména séfiré yikafre hurutaméni. Méni hambuk ye wun mi yatakataka mé gaya.” ");
INSERT INTO wos_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Wungi wandaka di prisna néma du, xékélelakikwa du akwi di hafu bula di Jisaska wangita di haraki hundi wa. We di wa, “Dé nak duré dé yikafre huru. Déka séfiré yikafre yamba hurukéndé. ");
INSERT INTO wos_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Dé God wasékendén du Krais re israelna néma du rendét déré xiyae hatekandan mi yatakataka gayandét nani xe déka hundika ‘Mwi hundi’ natame.” Wungi wandaka bér Jisas wali mimbu xiyae hatekandan du yéték bérka mimbu te bér akwi bér déka haraki hundi wa. ");
INSERT INTO wos_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Nukwa dawimbu téndéka dé gan hunyi. Hunye téndéka hukémbu nukwa tengura naande nukwa hufuk héra. ");
INSERT INTO wos_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Hérandéka Jisas déka hundimbu hambukmbu dé angi wa, “Eloi, Eloi, lama sabaktani.” Mo hundi angi dé: “Wuna God, wuna God, métaka we méni wuniré yataka?” ");
INSERT INTO wos_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Wungi wandéka wumbu téndén du nawulak wun hundi xéka di wa, “Mé xéké. Wun du dé hanja rendé profet elaijaka dé we.” ");
INSERT INTO wos_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Wungi wandaka dé du nak fétékéré ye nyamba maki joo nawulak hérae dé nyingi yakwa wain hulingumbu husanda. Husandandéka gufwi yandéka bangimbu giya dé Jisas sandéte haréka hwe. Ye dé wa, “Wayika. Yae xémbet. Wafewana elaija yae déré hurundét gayatandé?” ");
INSERT INTO wos_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Wungi wandéka dé Jisas hambukmbu waanje dé hiya. ");
INSERT INTO wos_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Jisas hiyandéka tempelmbu lékindan séményi nukwa wur anwarmbu léngae ye dé andélambu xaku. Léngae dé angé yéték xaku. ");
INSERT INTO wos_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Jisas wungi hiyandéka xi warekwa duna néma du te dé xé. Xe dé wa, “Wun du wu Godna nyan dé. Wu mwi hundi dé.” Wungi dé wa. ");
INSERT INTO wos_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Nawulak takwa yae afakémbu téta di xé. Deka nyéndékmbu télé takwa hési léka xi angi lé, Makdalambu yalé takwa Maria lé. Takwa hési akwi Maria lé, lé wayikana du Jems bér Josesna ayiwa lé. Takwa hési akwi Salome lé. ");
INSERT INTO wos_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Hanja Jisas Galilimbu téndéka wunde takwa di dé wali yitaka yataka. Yitaka yatakata di Jisaska hénoo hwe. Séfélak takwa akwi di Jisasna hukémbu yi Jerusalemré. Yae te di xé Jisas hiyandéka. ");
INSERT INTO wos_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","43","Gérambu arimateana du josep wundé yandé. Wun du israelna néma du nak dé. Dé yikafre du dé, atéfék du takwana makambu. Dé hafu dé God déka du takwaka hatindéka nukwaka haxékwa du dé. Séri baka hwa nukwa xaku wandéka di hénoo jondu husamé. josep Jisasna fusa héranjoka dé Pailatka yi. Ye dé Pailatna makambu roohafi té. Te dé Pailatré wakwexéké, déka fusaka. ");
INSERT INTO wos_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Wakwexékéndéka dé Pailat saréka waréka. Saréka dé déka xi warekwa duna néma duka wakwexéké, “Jisas dé bu hiya, o yingafwe?” ");
INSERT INTO wos_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Wungi wakwexékéndéka dé wa, “Xéxé. Dé bu hiya.” Wungi wandéka dé Pailat josepré wa, “Méni déka fusa sé ye héra.” ");
INSERT INTO wos_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Wungi wandéka dé yikafre wama nukwa wur hérae Jisasna fusa lukwa hura gayae dé nukwa wurmbu samétaka. Samétaka hura ye dé wekwa nakmbu taka. Hanja di jémba yakwa du motumbu wekwa di xa. josep Jisasna fusa wun wekwambu takataka dé motu nak sérmena dé yambu takatéfi. ");
INSERT INTO wos_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Takatéfindéka bér Makdalambu yalé takwa Maria bér Josesna ayiwa Maria bér Jisasré takandén wekwa xé. ");
INSERT INTO wos_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Judana baka hwa nukwa yindéka di takwa hufuk, Makdalambu yalé takwa Maria, Jemsna ayiwa Maria, Salome, wungi di Jisasna fusambu hurunjoka yikafre yama xaakwa hulingu hura yi. ");
INSERT INTO wos_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Hura ye Sande ganémbambu nukwa xalendéka di Jisasna fusa takandén hafwaré yi. ");
INSERT INTO wos_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Yambumbu ye di di hafu bula di wa, “Héndé hérekite wekwambu takatéfindan motu?” ");
INSERT INTO wos_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Wungi di wa, wun motu némafwi motu dé. Wataka di xé wekwambu takatéfindan motu nafwe takandaka rendéka. ");
INSERT INTO wos_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Xétaka wekwambu wulaaye di xé wayikana du nak wama nukwa wur sandataka yika tamba sakumbu rendéka. Xe di waréngéné. ");
INSERT INTO wos_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Waréngénéndaka dé wa, “Guni rookénguni. Wuni xékélaki. Guni Nasaretmbu yandéka xiyae mimbu hatekandan du Jisaska guni hwaké. Dé bu ramé wambula. Dé ambu rehambandé. Guni yae guni takandaka hwandén hafwa xétanguni. ");
INSERT INTO wos_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Némbuli guni ye guni déka du, Pitaré akwi, angi watanguni, ‘Jisas dé Galiliré tale dé yi. Guniré hanja wandén maki déré wumbu xétanguni.’ Wungi diré watanguni.” ");
INSERT INTO wos_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Dé wungi wandéka di waréngéné saréké waréka di wekwa yatakataka gwande yaange yi. Ye némafwimbu roo di wun jooka hundi wahambandi. ");
INSERT INTO wos_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Sande ganémbambu Jisas dé wambula ramé. Raama yandéka lé Makdalambu yalé takwa lé déré tale xé. Hanja haraki hamwinya angé tamba yétiyéti angé tamba hufuk léka mawulimbu wulaaye téndaka Jisas wandéka di léré yatakataka yaange yi. ");
INSERT INTO wos_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Jisas raméndéka lé déré xétaka lé déka duka yi. Yiléka di déka saréfa nae gérandaka lé diré wa, “Jisas dé bu wambula ramé. Raméndéka déré wuni xé.” ");
INSERT INTO wos_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Wungi waléka di xéka di wa, “Yingafwe. Wu yéna nyéni ye.” Wungi di wa. ");
INSERT INTO wos_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Hukémbu Jisasna du yéték Jerusalem yatakataka yambumbu bér yi. Yimbéka Jisas nak maki xaakwa ye dé bérka yandéka bér déré xé. ");
INSERT INTO wos_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Xétaka getéfaré wambula ye bér Jisasna duré wa, “Déré wundé xéna.” Wungi wambéka di wambula wa, “Yingafwe. Wu yéna béni ye.” Wungi di wa. ");
INSERT INTO wos_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Hukémbu Jisasna du tamba atéfék man natafa hénoo sata rendaka dé Jisas dika yi. Ye dé diré wa, “Raméwuka di wuniré xétaka di gunika hundi wa. Métaka guni deka hundi xékéhafi ya? Métaka guni wunika sarékéhafi ya?” ");
INSERT INTO wos_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Wungi wataka dé diré wa, “Guni ye atéfék héfambu rekwa du takwaré wuna hundi safétanguni. ");
INSERT INTO wos_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Wuna hundi xéka di wunika jémba saréka di wunika biya hwe di wuna ximbu guré nandindat God diré satanéna tambambu hérandét di jémba reséketandi. Wunika jémba sarékéhafi yakwa du takwa God wandét di fakutandi. ");
INSERT INTO wos_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Atéfék wuna hundi xéka yikwa du takwa deka tambambu God némafwi jémba yatandé. Di wuna ximbu wandat du takwana mawulimbu wulaaye tékwa haraki hamwinya yaange yitandi. Di hanja xékéhafi yandan huli hundimbu watandi. ");
INSERT INTO wos_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Du takwaré tikwa hambweré hurundat diré tindét yamba hiyakéndi. Di haraki saraki hulingu se di yamba hiyakéndi. Di baré hiyaakwa du takwaré tamba takandat di wambula yikafre yatandi.” Jisas dé wungi wa. ");
INSERT INTO wos_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Néma Du Jisas wungi wandéka hukémbu God wandéka dé Godna getéfaré wara néma du re, déka yika tambambu. ");
INSERT INTO wos_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Déka du atéfék getéfaré ye di déka hundi di safé. Saféndaka Néma Du di wali jémba ye déka hambuk hwendéka di deka hundi xékékwa du, takwa, hanja xéhafi yandan hambuk jémba di xé. Xe di wa, “Deka hundi wu mwi hundi dé.” Wungi di wa. ");
INSERT INTO wos_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Néma du Tiofilas, ménika wuni ané hundi hayi. Méni xékélaki, séfélak du Jisas nana nyéndékmbu yasékendén jémbaka di hayikwe hayikwexé. ");
INSERT INTO wos_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Hanja Jisasna jémba yakwa du akwi Jisas hurundéka xéndén du akwi di hundi safé. Saféndaka xékétaka di hayi. ");
INSERT INTO wos_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Hayindaka xékétaka wuni Jisasna jémba yakwa du akwi Jisas hurundéka xéndé du takwaka akwi wundé wakwexékéwu. Wakwexékétaka wuni wundé xékélakiwu, tale xakundé hundi, nyéndékmbu xakundé hundi, hukémbu xakundé hundika akwi. Xékélake wuni ané hundi ménika hayitawuni. ");
INSERT INTO wos_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Hayiwut méni jémba xékélakitaméni. Wun jooka méniré wandan hundi wu mwi hundi dé. ");
INSERT INTO wos_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Herot Judiana néma du rendén nukwa pris nak dé re. Déka xi Sekaraia dé. Dé Aronéna mandéka Abiyana hémémbu dé re. Déka takwa léka xi Elisabet lé Aronéna hémémbu akwi lé re. ");
INSERT INTO wos_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Bér Néma Du Godna makambu yikafre sémbut hurukwa du takwa bér. Bér déka hambuk hundi jémba xékéta wandén maki huruta bér haraki saraki sémbut huruhafimbér. ");
INSERT INTO wos_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Lé nyan hérahambalé. Hérahafi yaléka bér hafu bér re. Nyangwal yingafwe. Bér gwalefa bér. ");
INSERT INTO wos_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Nukwa nak Sekaraiana hémna jémba ya nukwa dé. Sekaraia akwi Godna makambu dé prisna jémba ya. ");
INSERT INTO wos_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Jémba yandéka di atéfék pris hérangwanda téta di deka sémbut maki di deka atéfék xi hayitaka di wurmbu lakwa. Lakwataka hérae di xé, Sekaraiana xi. Xétaka wandaka dé Sekaraia Néma Du Godna geré wulayi, yikafre yama xaakwa joo xérékéndét yaki muluka waréndéte. ");
INSERT INTO wos_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Wandaka dé wulayindéka yikafre yama xaakwa joo xérékétendéka nukwambu di séfélak du takwa hafwambu hérangwanda téta di Godka wata té. ");
INSERT INTO wos_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Wata téndaka dé Sekaraia awulambu téta dé xé, Néma Duna ensel nak yikafre yama xaakwa yaki tékwa jambéna yika tamba sakumbu téndéka. ");
INSERT INTO wos_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Xétaka waréngéna dé némafwimbu roo. ");
INSERT INTO wos_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Roondéka dé ensel déré wa, “Sekaraia, méni rookéméni. God ména hundi wundé xékéndé. Xékétaka dé wa, ména takwa Elisabet dunya héraléte. Héralét méni déka xi Jon wataméni. ");
INSERT INTO wos_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Ména takwa wumba nyan héralét, méni wun nyanka yikafre mawuli yata mawuli sawuli yataméni. Séfélak du takwa akwi wun nyanka mawuli sawuli yatandi. ");
INSERT INTO wos_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Métaka we? Dé Godna makambu déka xi némafwi yatandé. Dé wain hulingu, sata wangété yandaka hulingu akwi yamba sakéndé. Wun nyan ayiwana biyakombu rendét, dé Godna Hamwinya déka mawulimbu wulaaye tétandé. ");
INSERT INTO wos_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Dé wandét hanja Godka hu hwendé Israelna séfélak du takwa di deka Néma Du Godna hundi wambula xékétandi. ");
INSERT INTO wos_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Dé profet Elaija hurundén maki hurutandé. Dé Elaijambu téndéngala hamwinya hératandé. Wandét yafa deka nyangwal wali wambula yikafre mawuli yatandi. Godna hundi xékéhafi yandé du takwa di Godna hundi xékékwa du takwana hundi xékétandi. Dé tale yita wandét du takwa jémba sarékéta Néma Du yatendékaka haxétandi.” Wungi dé ensel wa. ");
INSERT INTO wos_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Wandéka dé Sekaraia déré wa, “Yingi maki nae xékélakitawuni, ména hundi mwi hundi wana? Ani wuna takwa wali ani gwalefa ani.” ");
INSERT INTO wos_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Wungi wandéka dé ensel wa, “Wuni Godna ensel nak wuni. Wuna xi Gebriel dé. Wuni Godna makambu téwukandé. Téwuka God wuniré wandéka wuni déka hundi hura gaya, méniré wanjoka. ");
INSERT INTO wos_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Némbuli mé xéké. Méni wuna hundi xékéhafi yaménka némbuli méni hundi yamba bulékéméni. Tale wawun atéfék jondu xakundét, wun nukwa wuna hundi mwi hundi yandét méni wambula hundi bulétaméni. God wasékendén nukwambu wun joo xakutandé.” Wungi wataka dé ensel yi. ");
INSERT INTO wos_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Du takwa hafwambu téta di Sekaraiaka haxéndaka dé tempelré bari gwandehafi yandéka di saré waréké. ");
INSERT INTO wos_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Haxéta téndaka dé hukémbu hafwaré gwande dé di wali hundi bulénjoka dé hurufatiké. Hurufatikéndéka di xékélaki, dé tempelmbu janji maki jooré dé xé. Wungi xékélakindaka dé hundi bulénjoka hurufatika dé déka tamba male dé yamanyi. ");
INSERT INTO wos_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Hukémbu déka jémba hényindéka dé déka geré wambula yi. ");
INSERT INTO wos_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Ye rendéka hukémbu déka takwa Elisabet lé nyan té. Te lé bafu natamba lé léka gembu male lé re. ");
INSERT INTO wos_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Reta lé wa, “Hanja wuni nyan hérahafi takwa rewuka du takwa di wunika haraki hundi wa. Wandaka wuni haraki mawuli xéké. Némbuli Néma Du God wunika saréfa naata wuniré dé yikafre huru.” Wungi lé Elisabet wa. ");
INSERT INTO wos_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Elisabet nyan téléka bafu gwongofu yindéka, God wandéka dé déka ensel Gebriel dé Nasaretré yi. Nasaret Galilimbu dé re. ");
INSERT INTO wos_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Wun nukwa takwa hési léka xi Maria lé wumbu re. Hanja lé du nak wali hwahambalé. Hanja léka yafa ayiwa Josepna yafa ayiwa wali hundi di gi, lé hukémbu Josepré humbwiléte. Josep Devitna hémémbu dé re. ");
INSERT INTO wos_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","God wandéka Gebriel ye dé Mariaré wa, “Nyénawa. Néma Du God nyénika mawuli yata nyéni wali dé té.” ");
INSERT INTO wos_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Wungi wandéka wun hundi xékéta roota lé léka mawulimbu wa, “Ané méta maki hundi dé?” ");
INSERT INTO wos_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Sarékéta téléka dé léré wa, “Maria, rookényéni. God nyénika mawuli mawuli dé ye. Mawuli yata nyéniré yikafre hurutandé. ");
INSERT INTO wos_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Mé xéké. Nyéni nyan te dunya nak hératanyéni. Hérae déka xi Jisas watanyéni. ");
INSERT INTO wos_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Dé némafwi du retandé. Anwarmbu rekwa God déka angi watandé, ‘Méni wuna nyan méni.’ Néma Du God wandét déka mandéka Devit néma du reta Judana du takwaka hatindén maki, dé néma du reta dika hatitandé. ");
INSERT INTO wos_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Dé néma du wungi re wungi re reséketandé, Israelna du takwaka. Reta dika jémba hatitandé, wungi re wungi re.” Wungi dé Gebriel wa. ");
INSERT INTO wos_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Wandéka lé Maria déré wa, “Yingi maki nae wuni nyan tétawuni? Wuni du humbwihambawuni?” ");
INSERT INTO wos_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Wungi waléka dé wa, “Godna Hamwinya nyénika gayatandé. Gayandét God nyénika hambuk hwetandé. Hwendét nyan te hératanyéni. Héranyét wun nyanka angi watandi, ‘Dé Godna nyan dé.’ Wungi watandi. ");
INSERT INTO wos_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Ané hundi mé xéké. Hanja nyéna hémna takwa hési Elisabetka di wa, ‘Lé nyan hérahafi takwa lé.’ Wungi wandaka gwalefa yaléka God wandéka lé nyan lé té. Bafu gwongofu lé nyan té. ");
INSERT INTO wos_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","God dé némafwi dé. Atéfék joo hali hurundé.” ");
INSERT INTO wos_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Wungi wandéka lé Maria wa, “Wuni xéké. Wuni Néma Du Godna jémba yakwa takwa wuni. Wuniré wamén maki Néma Du hurutandé. Wu yikafre dé.” Wungi waléka dé wun ensel yi. ");
INSERT INTO wos_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Wun nukwa Maria raama lé Judiana némbumbu rekwa getéfa nakré bari yi. ");
INSERT INTO wos_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Ye lé Sekaraiana geré wulaaye lé Elisabetka dinyéna na. ");
INSERT INTO wos_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Naléka Elisabet Mariana hundi xékéléka léka biyakombu rendé nyan dé waréngéné. Waréngénéndéka dé Godna Hamwinya Elisabetna mawulimbu wulaaye té. ");
INSERT INTO wos_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Téndéka lé némafwimbu wa, “God nyéniré yikafre wundé hurundé. Wu mwi hundi dé. Nyéniré yikafre hurundén joo hési takwaré yikafre hurundén jooré dé sarékéngwandé. God nyéna biyambu rekwa nyanré akwi dé yikafre huru. ");
INSERT INTO wos_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Nyéni wuna Néma Duna ayiwa nyéni. Nyéni wunika yanyén, wu yikafre dé. ");
INSERT INTO wos_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Nyéni yae wunika dinyéna nanyéka wuni nyéna hundi xékéwuka wuna biyakombu rekwa nyan mawuli sawuli yata waréngénéndéka wuni xéké. ");
INSERT INTO wos_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Nyéni Néma Du Godna hundi jémba xékéta nyéni wa, ‘Wandén maki hurutandé. Wu mwi hundi dé.’ Wungi wataka nyéni yikafre mawuli yata jémba retanyéni.” Wungi lé Elisabet wa. ");
INSERT INTO wos_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Maria wun hundi xékétaka lé gwar angi wa: Wuna mawuli Godna ximbu dé haréké. ");
INSERT INTO wos_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Wuna hamwinya wuniré Satanéna tambambu héraakwa Godka dé mawuli sawuli yata dé déka ximbu haréké. ");
INSERT INTO wos_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Wuni néma takwa yingafwe. Wuni baka takwa déka jémba yakwa takwa wuni re. Rewuka dé God wunika dé saréké. Sarékéndéka hukémbu atéfék du takwa akwi watandi, ‘God Mariaré dé yikafre huru. Wu mwi hundi dé.’ ");
INSERT INTO wos_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Dé némafwi hambuk yakwa God dé. Dé wuniré némafwi joo dé huru. Déka xi yikafre male dé. ");
INSERT INTO wos_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Godka rookwa du takwaka God dé saréfa na. Némbuli, hukémbu akwi, God wungi hurukwa du takwaka saréfa natandé. ");
INSERT INTO wos_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Godna tamba hambuk dé. Déka tambambu séfélak némafwi jémba dé ya. Du deka mawulimbu deka xi harékéndaka dé diré déka tambambu yawulalama yaki. ");
INSERT INTO wos_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Dé wandéka nak nak téfambu rendé néma du di baka du di re. Dé wandéka deka hafu ximbu harékéhafi yakwa du takwa di néma du takwa re. ");
INSERT INTO wos_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Hénooka hiyaakwa du takwaka dé yikafre jondu hwendéka dé deka biya sukweké. Xérénjuwi mama du takwaka wandéka di jondu yike baka yi. ");
INSERT INTO wos_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","55","Déka jémba yakwa Israelna du takwaré dé yikafre huru. Hanja God dé Abraham nana mandékanguka akwi dé wa, ‘Guni Israelna du takwa, gunika saréfa naata némbuli, hukémbu akwi, atéfék nukwambu akwi, guniré yikafre hurutawuni.’ Wungi wataka dé wun hundika saréké. ");
INSERT INTO wos_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Wun gwar wungi wataka Maria Elisabet wali lé re. Bafu hufuk re lé léka geré wambula yi. ");
INSERT INTO wos_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Elisabet nyan hérateléka nukwa xakundéka lé dunya héra. ");
INSERT INTO wos_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Héraléka Elisabetna hémna du takwa akwi léka nyémayika akwi xékéta di léka yikafre mawuli yata di mawuli sawuli ya. Mawuli sawuli yata di wa, “Néma Du God yikafre joo dé huru, Elisabetka.” Wungi di wa. ");
INSERT INTO wos_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Nukwa angé yétiyéti angé hufuk yindéka di nukwa nak yae di hérangwanda, déka hémna du wun nyanéna séfi sékénjoka. Hérangwanda di déka séfi séka di wun nyanéna xi Sekaraia wanjoka di saréké, déka yafangala. ");
INSERT INTO wos_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Sarékéndaka lé déka ayiwa lé wa, “Yingafwe. Déka xi Jon watame.” ");
INSERT INTO wos_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Wungi waléka di léré wa, “Hanja béna hém wun xi wahambandi.” ");
INSERT INTO wos_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Wungi wataka di déka yafa Sekaraiaré wakwexéké. Sekaraia hundi buléhafi rendéka di déré tambambu yamanyita di angi wakwexéké, “Méta xi wakéme, déré?” ");
INSERT INTO wos_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Wungi wakwexékéndaka dé tambambu yamanyi, déka nyinga hwendate. Hwendaka dé nyingambu angi hayi, “Déka xi Jon dé.” Wungi hayindéka di atéfék saréké waréké. ");
INSERT INTO wos_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Sarékéndaka déka hundi bari yikafre yandéka dé Sekaraia wambula hundi bulé. Buléta dé Godna ximbu haréké. ");
INSERT INTO wos_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Buléndéka di déka getéfambu rendé du takwa atéfék di némafwimbu roota saré waréké xéka di wun jooka hundi wa saafa yi, Judiana némbumbu rekwa atéfék getéfaré. ");
INSERT INTO wos_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Wa saafa yindaka wun hundi xékéndé du takwa di xékélaki, Néma Du God wun nyanka dé hambuk hwe. Wungi xékélakita saréké waréké xékéta di wa, “Hukémbu wun nyan yingi maki retandé?” ");
INSERT INTO wos_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Godna Hamwinya dé wun nyanéna yafa Sekaraiana mawulimbu wulaaye té. Téndéka dé Godna hundi angi wa: ");
INSERT INTO wos_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","Nani Israelna du takwa, nana Néma Du Godna ximbu harékétame. Naniré yikafre hurunjoka dé gaya. Gaye dé Satanéna tambambu naniré hératandé. ");
INSERT INTO wos_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Godna jémba yakwa du Devitna hémémbu némafwi hambuk du dé taka. Takandéka dé naniré mama duna tambambu hératandé. ");
INSERT INTO wos_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Godna profet wandanéngala dé xaku. ");
INSERT INTO wos_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Wunde profet di angi wa, “Nana mama du, nanika hélék yakwa du akwi, naniré xiyanandat, God naniré hératandé, deka tambambu.” ");
INSERT INTO wos_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","God dé wungi nana mandékanguka saréfa nae. Dé déka yikafre wasékérékéndén hundika sarékéta wandén maki dé huru. ");
INSERT INTO wos_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","74","Wun mwi hundi God dé nana mandéka Abraham déka hémré akwi dé wasékéréké. Wandén maki dé naniré yikafre huruta naniré nana mama duna tambambu hératandé. Hérandét nani déka roohafi yata déka jémba yatame. ");
INSERT INTO wos_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","Jémba yata nani ané héfambu reta atéfék nukwa déka du takwa male reta yikafre sémbut male hurutame. ");
INSERT INTO wos_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Wun hundi wataka dé Sekaraia déka nyanré angi wa: Méni wuna nyan, méni tale ye Néma Duna yambu hurutaméni. Yitemékaka du takwa ménika watandi, “Anwarmbu rekwa Godna profet méni.” Wungi watandi. ");
INSERT INTO wos_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Méni wun Néma Duna du takwaré wataméni, di hurundan haraki saraki sémbut yakwanyi diré hérae Godna tambambu takatendékaka. ");
INSERT INTO wos_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","God nanika némafwimbu saréfa nandénka némbuli male déka yikafre hanyikwa ya déka getéfambu gaye nanika hanyitandé. ");
INSERT INTO wos_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Tale nani halékingambu reta nani du hiyana sémbutna hakimbu nani re. Déka yikafre hanyikwa ya nanika hayindét, nani nakélak huru mawuli hwekwa yamburé xéta wun yambumbu jémba yitame. Wungi dé Sekaraia wa. ");
INSERT INTO wos_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Hukémbu wun nyan Jon némafwi yandéka déka mawuli jémba dé té. Dé du rehafi hafwambu dé re. Reta dé Israelna du takwaré Godna hundi watendéka nukwaka dé haxé. ");
INSERT INTO wos_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Wun nukwa Romna néma du déka xi Ogastus dé déka duré wa, di atéfék Romna héfambu rekwa du takwana xi hayita diré handékénéndate. ");
INSERT INTO wos_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Hanja di atéfék du takwaré handékénéhambandi. Wun jémba tale yandaka dé Kwirinius Romna néma duka jémba yata Siriana héfambu dé néma du re. ");
INSERT INTO wos_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Atéfék du takwa deka motéfaré di yi, di deka xi hayindat, di diré handékénéndate. ");
INSERT INTO wos_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Josep Israelna néma du Devitna hémémbu dé re. Devitna motéfa Betlehem dé. Betlehem Judiambu dé re. Josep Galilimbu rekwa getéfa Nasaretré yatakataka dé déka hémna motéfa Betlehemré yi. ");
INSERT INTO wos_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Déka yafa ayiwa wasékembén takwa wali bér Betlehemré yi, bérka xi hayinjoka. Wule takwa léka xi Maria lé. Lé nyan lé té. ");
INSERT INTO wos_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","7","Ye bér Betlehemémbu xakumbéka séfélak du takwa hwandaka ge wundé sukwekéndé. Bér hwa hafwa yingafwe. Fatika lé nyan héranjoka lé bulmakau bali hwandaka geré wulayi. Wulaaye lé maka du nyan héra. Hérae lé nukwa wurmbu banyitaka. Banyitakataka lé bulmakau bali hénoo sandaka suwangembu takaléka dé hwa. ");
INSERT INTO wos_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Wun gan du nawulak nak hafwambu deka sipsip balika di hate té. Wun hafwa Betlehem rekwambu dé re. ");
INSERT INTO wos_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Hate téndaka dé Néma Duna ensel nak gaye téndéka némafwi ya maki dé hanyi. Hanyindéka xéta di némafwimbu roo. ");
INSERT INTO wos_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Roondaka dé Godna ensel diré wa, “Guni rookénguni. Mé xéké. Yikafre hundi watawuni. Atéfék du takwa ané hundi xékéta yikafre mawuli yata mawuli sawuli yatandi. ");
INSERT INTO wos_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Némbule takwa hési nyan lé héra, Devitna getéfambu. Héralén nyan wu guniré Satanéna tambambu hérae guniré yikafre hurute yakwa du dé. Dé God wasékendén du Krais dé. Wu nana Néma Du dé. ");
INSERT INTO wos_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Némbuli ye wun nyanré xétanguni. Ayiwa nukwa wurmbu banyitaka bulmakau bali hénoo sandaka suwangembu takaléka dé hwae. Ye xétaka xékélakitanguni, wuna hundi mwi hundi dé.” Wungi dé wa. ");
INSERT INTO wos_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Wandéka di séfélak ensel bari gaye di wun ensel wali té. Téta angi di gwar wa: ");
INSERT INTO wos_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“Anwar Godna getéfambu Godna ximbu harékétame. Ané héfambu God mawuli yandéka du takwa nakélak huru mawuli hératandi.” Wungi di wa. ");
INSERT INTO wos_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Wunde ensel wungi gwar wataka di diré yatakataka wambula wari, Godna getéfaré. Warindaka di sipsip balika hatikwa du di hafu buléta di wa, “Betlehemré yitame. Nani ye Néma Du wandén jooka xétame.” ");
INSERT INTO wos_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Wungi wataka di bari hari yi. Ye getéfambu xaakwa di Maria bér Josep, wun nyanré akwi di xé, nyan bulmakau bali hénoo sandaka suwangembu hwandéka. ");
INSERT INTO wos_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Nyanré xétaka di ensel wun nyanka wandén hundika di du takwaré wa saafa yi. ");
INSERT INTO wos_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Wa saafa yindaka di wun hundi xékéndé du takwa atéfék di sipsip balika hatikwa du wandan jonduka di saréké waréké. ");
INSERT INTO wos_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Wungi saréké warékéndaka lé Maria léka mawulimbu wun hundi hulukita wun jonduka lé saréké waréké xéké. ");
INSERT INTO wos_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Sipsip balika hatikwa du wambula yita Godna ximbu harékéta di déka yikafre mawuli ya. Yata di wa, “Néma Du God naniré hundi wandéka xékétaka nani wun joo atéfék nani xé.” Wungi di wa. ");
INSERT INTO wos_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Nukwa angé yétiyéti angé hufuk yindéka nak nukwambu di wun nyanéna séfi séké. Sékétaka di déka xi angi wa, Jisas dé. Hanja Maria nyan téhafi yalén nukwa dé ensel nak wun xika léré wa. ");
INSERT INTO wos_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Maria nyan hérae lé Moses wandén hambuk hundi wandén maki hurunjoka lé mawuli ya, léka séfi Godna makambu wambula yikafre yandéte. Mawuli ye wun hambuk hundimbu wandén maki nukwa yindéka lé Josep wali bér Jerusalemré yi, bér Jisasré Néma Du Godka hwenjoka. ");
INSERT INTO wos_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Néma Du Godna hambuk hundi nak angi dé wa, “Takwa hérandan atéfék maka du nyan Godka hwetandi.” ");
INSERT INTO wos_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Néma Du Godna hambuk hundi nak akwi angi dé wa, “Du wali takwa wali bérka dunya Godka hweta bér nyamwe afwi yéték wali xiyae déka hwetambér. Nyamwe afwika fatika nyamwengala afwi yéték hwetambér.” Maria bér Josep wun hundi wandé maki hurunjoka bér Jerusalemré yi. ");
INSERT INTO wos_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Wun nukwa du nak déka xi Simeon dé Jerusalemémbu re. Dé yikafre sémbut male huruta dé Godka wakwexékékwa du dé re. God Israelna du takwaré yikafre hurutendéka nukwaka dé haxé. Godna Hamwinya déka mawulimbu dé wulaaye té. ");
INSERT INTO wos_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Hanja Godna Hamwinya dé Simeonré wa, “Méni hiyahafi re Néma Du God wasékendén du Kraisré xétaméni.” Wungi wandéka dé wun jooka dé haxé. ");
INSERT INTO wos_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Godna Hamwinya déka mawulimbu wulaaye téta wandéka dé tempelré wulayi. Wulayindéka bér Jisasna yafa ayiwa Jisasré hura wulayi, Godna hambuk hundi wandé maki maka du nyan Godka hwenjoka. ");
INSERT INTO wos_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Hura wulayimbéka dé Simeon wun nyanré hérae déka tambambu hura téta dé Godna ximbu harékéta dé angi wa: ");
INSERT INTO wos_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","30","Néma Du, hanja wamén hundi némbuli mwi hundi dé ya. Némbuli wuni xé, naniré yikafre huruta naniré hérae Godna tambambu takatekwa duré. Némbuli méni ména jémba yakwa du wuniré wamét, wuni yikafre mawuli hérae wuni hiyatawuni. ");
INSERT INTO wos_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Ané nyan méni wasékemén du dé. Dé ména jémba yandét, atéfék héfambu rekwa du takwa xétandi. ");
INSERT INTO wos_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Dé xérékékwa ya maki ané du nak téfana du takwana mawulimbu hanyitandé. Hanyindét di Godka jémba sarékétandi. Sarékéta di Israelna du takwana ximbu harékétandi. Wungi dé wa. ");
INSERT INTO wos_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Jisasna yafa ayiwa Simeon wandén hundika bér saréké waréké xéké. ");
INSERT INTO wos_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Sarékémbéka dé Simeon Godka wakwexéké, dé bérré yikafre hurundéte. Wakwexékétaka dé nyanéna ayiwa Mariaré angi dé wa, “Mé xéké. God dé waséke, ané du jémba yandét, Israelna séfélak du takwa xakrindat, Israelna séfélak du takwa raméndate. Dé Godna jémba yandét séfélak du takwa déka haraki hundi watandi. ");
INSERT INTO wos_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Haraki hundi wata séfélak du takwa deka mawulimbu sarékéndan hundi hafwa hafwa yatandé. Du nawulak déré haraki saraki sémbut hurundat, nyéni xényét, nyéna mawulimbu xi maki joo xiyatandé. Wungi dé Simeon wa. ");
INSERT INTO wos_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Gwalefa takwa hési léka xi Ana, lé wumbu re. Lé Fanuelna takwanya lé. Aserna hémémbu lé re. Lé Godna profet hési lé. Hanja lé du wali lé re. Reléka héki hwari angé tamba yétiyéti angé tamba hufuk yindéka dé léka du hiya. ");
INSERT INTO wos_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Hiyandéka lé séfélak héki hwari lé duke takwa lé hwa. Léka atéfék héki hwari angi dé dumi angé yétiyéti angé yétiyéti ye nak duna tamba yétiyéti (84) wungi héki hwari dé. Godna tempelmbu lé re. Reta lé wun ge yatakahafi lé. Gan nukwa lé Godna ximbu harékéléka dé. Nak nukwa nak nukwa hénooka yakérta lé God wali hundi bulé. ");
INSERT INTO wos_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Simeon hundi Josep bér Mariaré wataka téndaka lé yae wun nyanré xéta lé Godka diména naata lé God Jerusalemré wambula hératendéka nukwaka haxékwa du takwaka lé wa déka. ");
INSERT INTO wos_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Néma Du Godna hambuk hundi wandé maki hurutaka bér Jisasré hura bér Nasaretré wambula yi. Nasaret Galilimbu dé re. ");
INSERT INTO wos_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Wun nyan némafwi ye dé hambuk ye dé yikafre xékélelaki dé hérandéka dé God déré yikafre huru. ");
INSERT INTO wos_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Atéfék héki hwari Jisasna yafa ayiwa bér Jerusalemré wari Pasovana hénoo sanjoka. ");
INSERT INTO wos_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Jisasna héki hwari tamba yéti man yéték (12) yindéka bér déré hura di wari, Pasovana hénoo sanjoka atéfék héki hwarimbu warimbékangala. ");
INSERT INTO wos_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Hukémbu Pasova hénoo sandaka nukwa yindéka di deka getéfaré wambula yinjoka yambumbu yi. Yindaka dé Jisas Jerusalemémbu dé re. Rendéka déka yafa ayiwa xékélakihambambér. ");
INSERT INTO wos_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Bér bérka mawulimbu bér wa, “Jisas ana hém wali dé yi.” Wungi wataka bér nukwa nak yambumbu yi. Ye gérambu bér yambumbu yindé bérka hém bérka nyémayikanguka wakwexéké, déka. ");
INSERT INTO wos_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Wakwexékétaka déré xéhafi yata bér déka hwaké. Hwaka bér hwakéfatiké. Hwakéfatika bér Jerusalemré wambula yi, déka hwakénjoka. ");
INSERT INTO wos_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Ye nukwa hufuk bér déka hwaké. Hwaka hukémbu bér xé, dé tempelmbu rendéka. Dé nawulak du wali Godna hundika wakwekwa néma du wali deka nyéndékmbu reta deka hundi xékéta dé diré nak maki nak maki jonduka wakwexéké. ");
INSERT INTO wos_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Wakwexékéndéka déka hundi xékéndé du di waréngénéta di saréké waréké, dé deka hundi jémba xékélakita deka hundi jémba hasa wandéka. ");
INSERT INTO wos_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Déka yafa ayiwa déré xétaka bér waréngéné. Waréngéna lé déka ayiwa déré wa, “Nyan, métaka méni anika wungi huru? Ani ména yafa wali ana mawuli xak yandéka ani ménika atéfék hafwaka ani hwakéfatiké.” Wungi lé wa. ");
INSERT INTO wos_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Waléka dé bérka wa, “Métaka béni wunika hwaké? Wuni wuna yafana gembu rewuka xékélakihambambéni, o yingi maki dé?” ");
INSERT INTO wos_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Wungi wandéka bér wun mo hundika xékélakihambambér. ");
INSERT INTO wos_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Xékélakihafi yambéka dé bér wali wambula ye di Nasaretmbu xaku. Xaakwa reta dé bérka hundi xékéta dé wambén maki huru. Hurundéka déka ayiwa wun jonduka léka mawulimbu lé saréké waréké xéké. ");
INSERT INTO wos_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Jisas némafwi yandéka déka mawuli laréndéka dé séfélak jonduka dé xékélaki. God akwi du takwa akwi di déka yikafre mawuli ya. ");
INSERT INTO wos_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Taiberius Romémbu néma du Sisar tamba yéti manmbu yétiyéti héki hwarimbu re. Rendéka nak héki hwari Pontius Pailat dé Judiana héfambu néma du dé rendéka Herot Galilina héfambu rekwa du takwaka dé néma du rendéka, déka nyama Filip Ituriana héfambu rekwa du takwaka, Trakonitisna héfambu rekwa du takwaka akwi dé néma du rendéka Lisanias Abilenembu rekwa du takwaka dé néma du re. ");
INSERT INTO wos_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Rendéka Anas bér Kaiafas atéfék prisna néma du bér re. Wun nukwa Sekaraiana nyan Jon du rehafi hafwambu rendéka God dé déré hundi wa. ");
INSERT INTO wos_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Wandéka Jon déka hundi xékéta dé Jordan xéri yikwambu yitaka yataka. Yitaka yatakata dé du takwaré angi wa, “Guni hurungun haraki saraki sémbut yatakangut wuni Godna ximbu guniré guré husandatawuni. Guni wungi yatakataka Godna ximbu guré nandingut, dé guna haraki saraki mawuli yakwanyitandé.” Wungi dé Jon wa. ");
INSERT INTO wos_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Jon wungi hurundéka hanja Godna profet déka xi Aisaia Godna nyingambu angi dé hayi: Du nak dé wa du rehafi hafwambu. Wata dé angi wa, “Néma Duna yambu huréhalékétanguni. Huréhalékéngut déka yambu jémba rendé. ");
INSERT INTO wos_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Atéfék yafékwa yakitéfitanguni, yambu yindéte. Atéfék némafwi némbu atéfék yikama némbu akwi jémba bwatanguni, yambu yindéte. Angwa yandé yambu hurungut yambu huritéké rendé. Yambumbu rekwa motu hérekingut yambu jémba rendé. ");
INSERT INTO wos_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Wungi hurungut atéfék du takwa xétandi, God du takwaré Satanéna tambambu hératendékaka.” Wungi dé Aisaia hanja hayi, Jonka. ");
INSERT INTO wos_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Hayindén maki séfélak du takwa Jon diré guré husandandéte yandaka dé diré angi wa, “Guni haraki hambwena nyangwal guni. God gunika dé némafwimbu mawuli wita dé hukémbu hurungun haraki sémbut hasa hwetandé. Héndé wa, guni déka mawuli wika yaange yingute? ");
INSERT INTO wos_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Tale guni hurungun haraki saraki sémbut yatakataka yikafre joo male hurutanguni. Hurungut du takwa xéta xékélakitandi, guni guna haraki sémbut wundé yatakangu. Guni guna mawulimbu guni wa, ‘Nani Abrahamna mandéka rembeka dé God nanika dé mawuli ye.’ Wungi wakénguni. God mawuli yata wandét ané motu du takwaré xaakwa di Abrahamna mandéka maki retandi. ");
INSERT INTO wos_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Misange mi mombu haxéta dé re. Atéfék yikafre sék xakéhafi yakwa miré xéle yakitaka yambu tutandé.” ");
INSERT INTO wos_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Jon wungi wandéka di déka hundi xékéta di déré wakwexéké, “Nani méta yatame?” ");
INSERT INTO wos_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Wungi wandaka dé diré wa, “Guni nukwa wur yéték héra re, guni nak nukwa wur hafi du takwaka hwetanguni. Guni hénoo hura re, guni hénoo yike du takwaka hwetanguni.” ");
INSERT INTO wos_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Wun hundi wandéka di Romka yéwa héraakwa du nawulak di déka ya, dé diré guré husandandéte. Yae di déré wa, “Wakwekwa du, nani méta yatame?” ");
INSERT INTO wos_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Wungi wandaka dé diré wa, “Guni Romna gavman guniré wandan maki male yéwa hératanguni. Nawulak akwi hérakénguni.” ");
INSERT INTO wos_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Wun hundi wandéka di xi warekwa du nawulak déré wakwexéké, “Nani yingi maki dé? Nani méta yatame?” Wungi wandaka dé diré wa, “Guni du takwaka hambuk yata deka yéwa baka hérakénguni. Guni du takwaka yénataka hundi wata deka yéwa hérakénguni. Guni jémba yata héranguka yéwaka yikafre mawuli yatanguni.” ");
INSERT INTO wos_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Jon wungi huruta wungi wandéka atéfék du takwa saréké waréké xékéta deka mawulimbu di wa, “Jon wun naniré yikafre hurundéte God wasékendén du Krais dé, o yingi maki du dé?” ");
INSERT INTO wos_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Wungi sarékéndaka dé Jon diré wa, “Wuni guniré Godna ximbu guré wuni husanda. Wuna hukémbu yatekwa duna hambuk wuna hambukré dé sarékéngwandé. Yingi maki nae wuni déka jémba yatawuni? Wu yingafwe. Déka jémba yanjoka hurufatikétawuni. Wuna hukémbu yatekwa du Godna Hamwinya gunika hwetandé. Guna haraki saraki sémbut hérae yambu tutandé. ");
INSERT INTO wos_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Du wit hérae yikafre wit sék héranjoka di lékeki. Lékekitaka di yikafre wit sék gembu takataka di séfi yaki. Hurundén maki wuna hukémbu yatekwa du wungi hurutandé. Dé déka du takwaré hérae hura ye déka gembu takataka, haraki saraki sémbut hurukwa du takwaré hérae yambu tutandé.” ");
INSERT INTO wos_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Jon wun hundi du takwaré wata dé Godna hundi nawulak akwi dé wa, deka mawuli jémba téndéte. ");
INSERT INTO wos_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Galilimbu rekwa du takwana néma du Herot dé déka nyama hiyahafi rendéka dé déka takwaré héra. Léka xi Herodias lé. Herot séfélak haraki saraki sémbut akwi dé huru. ");
INSERT INTO wos_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Hurundéka Jon déré haraki hundi wandéka Herot dé ané haraki saraki sémbut akwi dé huru. Dé wandéka déka du di Jonré séndé gembu taka. ");
INSERT INTO wos_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","22","Hanja Herot Jonré séndé gembu takandate wahafi yandén nukwa Jon déka yandé atéfék du takwaré dé guré husanda. Husandataka dé Jisasré akwi guré husanda. Husandandéka téta God wali hundi buléndéka nyir télaméndéka dé Godna Hamwinya nyamwe afwi maki dé Jisaska gaya. Gayandéka hundi nak Godna getéfambu dé wa, “Méni wuna nyan méni. Ménika wuni némafwimbu mawuli ye. Ménika wuna mawuli yikafre dé ye.” ");
INSERT INTO wos_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Jisas déka héki hwari dumi hufuk (30) yandéka dé déka jémba tale ya. Du takwa di déka wa, “Dé Josepna nyan dé.” Wungi di wa. Josep Helina nyan dé. ");
INSERT INTO wos_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Heli Matatna nyan dé. Matat Livaina nyan dé. Livai Melkina nyan dé. Melki Janaina nyan dé. Janai Josepna nyan dé. ");
INSERT INTO wos_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Josep Matatiasna nyan dé. Matatias Amosna nyan dé. Amos Nahumna nyan dé. Nahum Eslina nyan dé. Esli Nagaina nyan dé. ");
INSERT INTO wos_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Nagai Matna nyan dé. Mat Matatiasna nyan dé. Matatias Semenéna nyan dé. Semen Josekna nyan dé. Josek Jodana nyan dé. ");
INSERT INTO wos_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Joda Joananéna nyan dé. Joanan Resana nyan dé. Resa Serubabelna nyan dé. Serubabel Sealtielna nyan dé. Sealtiel Nerina nyan dé. ");
INSERT INTO wos_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Neri Melkina nyan dé. Melki Adina nyan dé. Adi Kosamna nyan dé. Kosam Elmadamna nyan dé. Elmadam Erna nyan dé. ");
INSERT INTO wos_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Er Josuana nyan dé. Josua Elieserna nyan dé. Elieser Jorimna nyan dé. Jorim Matatna nyan dé. Matat Livaina nyan dé. ");
INSERT INTO wos_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Livai Simeonéna nyan dé. Simeon Judana nyan dé. Juda Josepna nyan dé. Josep Jonamna nyan dé. Jonam Eliakimna nyan dé. ");
INSERT INTO wos_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Eliakim Meleana nyan dé. Melea Menana nyan dé. Mena Matatana nyan dé. Matata Natanéna nyan dé. Natan Devitna nyan dé. ");
INSERT INTO wos_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Devit Jesina nyan dé. Jesi Obetna nyan dé. Obet Boasna nyan dé. Boas Salmonéna nyan dé. Salmon Nasonéna nyan dé. ");
INSERT INTO wos_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Nason Aminadapna nyan dé. Aminadap Atminéna nyan dé. Atmin Arnina nyan dé. Arni Hesronéna nyan dé. Hesron Peresna nyan dé. Peres Judana nyan dé. ");
INSERT INTO wos_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Juda Jekopna nyan dé. Jekop Aisakna nyan dé. Aisak Abrahamna nyan dé. Abraham Terana nyan dé. Tera Nahorna nyan dé. ");
INSERT INTO wos_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Nahor Serukna nyan dé. Seruk Reuna nyan dé. Reu Pelekna nyan dé. Pelek Eberna nyan dé. Eber Selana nyan dé. ");
INSERT INTO wos_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Sela Kainanéna nyan dé. Kainan Arpaksatna nyan dé. Arpaksat Siemna nyan dé. Siem Noana nyan dé. Noa Lamekna nyan dé. ");
INSERT INTO wos_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Lamek Metuselana nyan dé. Metusela Enokna nyan dé. Enok Jaretna nyan dé. Jaret Mahalalelna nyan dé. Mahalalel Kenanéna nyan dé. ");
INSERT INTO wos_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Kenan Enosna nyan dé. Enos Setna nyan dé. Set Adamna nyan dé. Adam Godna nyan dé. ");
INSERT INTO wos_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Godna Hamwinya Jisasna mawulimbu wulaaye téta hambuk yata wandéka dé Jordan xéri yatakataka dé yi. Yindéka Godna Hamwinya dé déré hérae hura yi, du rehafi hafwaré. ");
INSERT INTO wos_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Hura yindéka dé wun hafwambu dumi yétiyéti (40) nukwa rendéka dé Satan déka mawuli hurukwexé. Wunde nukwambu dé hénoo nawulak sahambandé. Sahafi yandéka wunde nukwa yindéka hukémbu dé Jisasré hénoo ya. ");
INSERT INTO wos_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Yandéka dé Satan déré wa, “Méni Godna nyan xe méni wamét ané motu waleka bret xakutandé.” ");
INSERT INTO wos_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Wungi wandéka dé wa, “Yingafwe. Wun jooka Godna nyingambu angi dé wa: Du takwa hénooka male sarékéta di jémba yamba rekéndi. Wun hundi xékéta motu bret xakundéte yamba wakéwuni.” ");
INSERT INTO wos_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Jisas wun hundi wandéka Satan déré dé hérae hura wari. Hura wara dé déré ané héfambu tékwa atéfék getéfa bari wakwe. ");
INSERT INTO wos_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Wakweta dé déré wa, “Ané héfambu tékwa atéfék getéfa, wun getéfambu rekwa atéfék du takwa atéfék jondu akwi di wuna tambambu di re. Wuni wun jondu du nakré hwenjoka mawuli ye, wu hwetawuni, wun duka. Hwewut dé dika néma du retandé. ");
INSERT INTO wos_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Méni wunika hwati séta wuna ximbu harékémét, wuni ané jondu ménika hwetawuni. Hwewut méni dika néma du retaméni.” ");
INSERT INTO wos_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Wungi wandéka dé wa, “Yingafwe. Godna nyingambu hayindén hundi angi dé: Ména néma du God male dé. Méni déka hwati séta déka ximbu male harékétaméni. Harékéta déka jémba male yataméni.” ");
INSERT INTO wos_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Jisas wun hundi wandéka Satan déré hérae hura yi Jerusalemré. Hura wara déré dé tempelna dawi gembu taka. Takataka dé déré wa, “Méni Godna nyan xe méni mé wuréféka nandi. ");
INSERT INTO wos_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Wun jooka Godna nyingambu hayindén hundi angi dé wa: “God déka enselré wandét di ménika jémba hatitandi, méni jémba reméte.” ");
INSERT INTO wos_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Ané hundi akwi dé re: “Méni deka tambambu jémba retaméni. Reta ména man motumbu yamba xiyakéméni.” ");
INSERT INTO wos_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Wungi wandéka dé wa, “Yingafwe. Wun jooka Godna hundi angi dé wa: Méni ména néma du Godré yamba hurukwexékéméni.” ");
INSERT INTO wos_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Wungi wandéka dé Satan nak jémba yandéte Jisasré wahambandé. Wahafi yata déré yatakataka dé déré wambula hurukwexétendéka nukwaka dé haxé. ");
INSERT INTO wos_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Godna Hamwinya Jisasna mawulimbu téta hambuk yandéka dé Galiliré wambula yi. Yindéka wun héfambu tékwa atéfék getéfambu di déka wa saafa yi. ");
INSERT INTO wos_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Dé Godna hundi buléndaka geré wulaaye du takwaré dé Godna hundi wa. Wandéka di atéfék Jisasna ximbu haréké. ");
INSERT INTO wos_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Jisas wungi huruna harana ya dé Nasaretmbu xaku. Hanja yikama nyan re dé yafa ayiwa wali wun getéfambu re dé wumbu néma du ya. Wun nukwa Nasaretré wambula ye dé wun getéfambu re. Reta baka hwa nukwa dé Godna hundi buléndaka geré wulayi. Atéfék baka hwa nukwa wulayindéka maki ye dé Godna hundi buléndaka geré wulayi. Wulaaye re dé Godna hundi nyingambu xéta wanjoka dé raama té. ");
INSERT INTO wos_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Téndéka di profet Aisaia hayindén nyinga déka hwe. Hwendaka lae dé xé, ané hundi rendéka. Xéta dé diré angi wa: ");
INSERT INTO wos_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","Néma Du God wuniré dé waséke, wuni déka hundi jambangwe du takwaré wawute. Wataka déka Hamwinya hwendéka dé wuna mawulimbu wulaaye té. God wuniré dé waséke, wuni yae ané hundi diré wawute. Di séndé gembu rekwa du takwa wun ge yatakataka jémba retandi. Di dama hiyandé du takwa némbuli wambula xétandi. Xak héraakwa du takwa wambula xak yamba hérakéndi. ");
INSERT INTO wos_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Néma Du God wuniré dé waséke, wuni dé du takwaré yikafre hurutendéka héki hwarika hambukmbu wawute. ");
INSERT INTO wos_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Jisas wungi wataka wun nyinga gétamétaka dé wun geka hatikwa duka hwe. Hwetaka wun hundina moka diré wakwenjoka dé re. Rendéka wun gembu rekwa atéfék du takwa di déré male xé. ");
INSERT INTO wos_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Xéndaka dé diré wa, “Némbuli Godna nyingambu rekwa hundi mwi hundi dé ya. Yandéka wundé xékéngu.” ");
INSERT INTO wos_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Wungi wandéka di wun hundi xékéta di waréngénéta déka hundika saré sarékéna. Sarékéta di wa, “Owa. Wun yikafre hundi dé wa.” Wungi wataka di wa, “Wun du Josepna nyan dé. Yingi maki nae dé wun yikafre hundi wa?” ");
INSERT INTO wos_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Di wungi wandaka dé Jisas diré wa, “Wafewana guni ané sataku hundika wuniré angi watanguni? ‘Dokta, méni hafu ména séfiré yikafre hurutaméni.’ Wungi wata wafewana guni angi akwi watanguni? ‘Kaperneamémbu yamén jémbaka bu xékékwa. Yamén maki male méni ména motéfambu jémba yataméni.’ Wungi watanguni wana. ");
INSERT INTO wos_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Mwi hundi wuni guniré we. Profet deka motéfambu reta hundi wandaka deka motéfambu rekwa du takwa deka hundi xékénjoka hélék di ya. ");
INSERT INTO wos_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Mé xéké. Hanja profet Elaija rendéka Israelmbu séfélak du hiyandé takwa di re. Wun nukwa héki hwari hufuk bafu nawulak akwi rendaka wali giyahambandé. Giyahafi yandéka atéfék getéfa némafwi hénooka di hiya. ");
INSERT INTO wos_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Hiyandaka God Elaijaré wahambandé, dé ye Israelmbu rekwa du hiyandé takwaré yikafre hurundéte. God Elaijaré dé wa, dé ye nak héfambu rekwa du hiyandé takwa hésiré yikafre hurundéte. Lé Saidonmbu rekwa getéfa déka xi Sarefatmbu lé re. ");
INSERT INTO wos_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Ané hundi akwi mé xéké. Profet nak déka xi Elisa rendéka séfélak walisufu hurundé du Israelmbu di re. Rendaka Elisa diré huréhalékéhambandé. Natafa male duré dé huréhaléké. Wun du dé Siriana héfambu yandé du nak déka xi Naman dé. Wun du Israelna du yingafwe.” ");
INSERT INTO wos_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Godna hundi buléndaka gembu rendé du takwa Jisas wandén hundi xékétaka di xékélaki. Jisas wungi wata diré dé haraki hundi wa. Wungi xékélakita di némafwimbu biya mawuli wi. ");
INSERT INTO wos_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Mawuli wita raama di Jisasré huluke getéfa yatakataka hafwaré témbéra hura gwande di déré deka getéfa tondén némbuna takumbu hura yi. Déré némbumbu yakisandanjoka di déré wungiré hura yi. ");
INSERT INTO wos_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Hura ye wungi hurunjoka di hurufatiké. Dé deka nyéndékmbu ye diré yatakataka dé yi. ");
INSERT INTO wos_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Jisas dé Kaperneamré naande yi. Wun getéfa Galilimbu dé re. Naande ye xaakwa dé re. Reta baka hwa nukwa dé Godna hundi buléndaka geré wulaaye dé du takwaré Godna hundika wakwe. ");
INSERT INTO wos_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Hambuk yata dé diré Godna hundi wa. Wungi wandéka di xékéta waréngéna di déka hundika saréké waréké. ");
INSERT INTO wos_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Haraki hamwinya hura téndé du nak dé re wun gembu. Rendéka dé haraki hamwinya hambukmbu wa. ");
INSERT INTO wos_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","Wata dé wa, “Méni Nasaretna du Jisas. Méni naniré méta yataméni? Naniré haraki hurutaméni, o yingi maki dé? Wuni ménika wuni xékélaki. Méni Godna yikafre male du méni.” ");
INSERT INTO wos_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Wungi wandéka dé wa, “Méni makété. Wun duré yatakataka mé yaange yi.” Wungi wandéka dé wun duré xasémékandéka dé héfambu xakri. Xakrindéka dé déré haraki huruhafi ye déré yatakataka dé yi. ");
INSERT INTO wos_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Yindéka atéfék du takwa xéta waréngénéta di hafu buléta di wa, “Owa. Ané du métakina hundi dé wa? Dé hambuk yata du takwaré hura tékwa haraki hamwinyaré wandéka di wunde du takwaré yatakataka di yi.” ");
INSERT INTO wos_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Wungi wandaka di wun héfambu rekwa atéfék getéfambu Jisaska hundi wa saafa yi. ");
INSERT INTO wos_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Jisas Godna hundi buléndaka ge yatakataka dé Saimonéna geré wulayi. Saimonéna nakémana séfi némafwimbu ya yandéka bar hiyaata lé hwa. Hwaléka di Jisasré wa, dé yae léré huréhalékéndéte. ");
INSERT INTO wos_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Wandaka wulaaye lé hwalén wali téta dé wun barré hambukmbu wandéka dé léka bar hényi. Hényindéka wule takwa bari raama lé hénoo humbwe lé dika hwe. ");
INSERT INTO wos_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Gérambu nukwa nandindéka baka hwa nukwa yindéka di bar hiyaakwa du takwa nyangwal, séfimali haraki yandé du takwa nyangwalré akwi di Jisaska hura yi. Hura yindaka dé déka tambambu wun du takwa nyangwalré hurundéka di wambula yikafre ya. ");
INSERT INTO wos_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Yandaka dé haraki hamwinyaré wandéka di séfélak du takwaré yatakataka yaange yi. Yita di wa, “Méni Godna nyan méni.” Wungi wata di xékélaki, dé God wasékendén du Krais dé. Wungi xékélakindaka dé diré hambukmbu wa, di wun jooka hundi wandamboka. Wandéka di yaange yi. ");
INSERT INTO wos_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Ganémbambu raama dé Jisas wun getéfa yatakataka dé du rehafi hafwaré yi, God wali hundi bulénjoka. Yindéka di du takwa déka hwaké. Hwaka di déré xéta di wa, “Méni nani wali retaméni. Nak getéfaré yamba yikéméni.” ");
INSERT INTO wos_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Wungi wandaka dé diré wa, “Wuni nawulak getéfaré akwi ye Godna hundi watawuni, God néma du reta du takwaka hatitendékaka. God wun jémba yawute wandéka wuni ya.” ");
INSERT INTO wos_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Wungi wataka Galilina héfa yatakataka ye dé Judiana héfambu yitaka yatakata dé Godna hundi buléndaka gembu Godna hundi du takwaré wa. ");
INSERT INTO wos_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Nak nukwa Jisas Genesaretna tukweseke tufwa nakmbu téndéka di séfélak du takwa yae hérangwanda di dé wali walémbambu té, Godna hundi xékénjoka. ");
INSERT INTO wos_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Téndaka dé xé gunjambé yéték tukweseke tufwambu rembéka. Xéri hamwi wurukwa du wun gunjambé takataka di mara yakwanyi. Yakwanyita téndaka deka gunjambé yéték rembéka dé xé. ");
INSERT INTO wos_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Xéta dé gunjambé nakmbu waré. Wun gunjambé Saimonéna gunjambé dé. Wara reta dé Saimonré wa, dé gunjambé xasémekindét yalefu ye nyambambu téléte. Wandéka wungi yandéka dé wule gunjambémbu reta dé tufwambu téndé du takwaré Godna hundika wakwe. ");
INSERT INTO wos_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Hundi wataka dé Saimonré wa, “Gunjambé mé nyamba tukwesekeré hura wulaaye méni ména du wali guni mara yakisande guni xéri hamwi nawulak wurutanguni.” ");
INSERT INTO wos_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Wungi wandéka dé wa, “Néma Du, némbule gan nani hambuk jémba nani ya. Yata nani xéri hamwi nawulak wuruhambame. Waménka sarékéta wuni mara wambula yakisandatawuni.” ");
INSERT INTO wos_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Wungi wataka mara yakisande di séfélak xéri hamwi wuru. Wurundaka mara nékétinjoka dé huru. ");
INSERT INTO wos_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Hurundéka di nak gunjambémbu rendé duka wa, di yae di wali hurundate. Wandaka yandaka di gunjambé yétékmbu xéri hamwi témbéra husale. Husalendaka bér gunjambé yéték guré nandinjoka huru. ");
INSERT INTO wos_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Hurundéka xéta dé Saimon Jisasna man mombu hwati se dé déré wa, “Néma Du, méni wuniré yatakataka yitaméni. Wuni haraki saraki sémbut hurukwa du wuni. Wuni wali yamba tékéméni.” ");
INSERT INTO wos_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Dé séfélak xéri hamwi wurundanka sarékéta waréngéna dé wungi wa. Dé wali gunjambémbu rendé du akwi di waréngéné. ");
INSERT INTO wos_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Sebedina nyan yéték Jems bér Jon bér akwi bér waréngéné. Bér Saimon wali jémba yambékandé. Waréngéna Saimon wungi wandéka dé déré wa, “Rookéméni. Méni xéri hamwi hurumén maki méni wuna jémba yata méni du takwaré hérataméni, di wuna hundi xékéndate.” ");
INSERT INTO wos_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Wungi wandéka di gunjambémbu tufwaré ye tufwambu témbéra husawarétaka di deka atéfék jondu yatakataka di dé wali yi. ");
INSERT INTO wos_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Jisas ye dé getéfa nakmbu re. Wun getéfambu walisufu hurundé du nak dé re. Séfélak wasi dé té déka séfimbu. Wun du Jisasré xéta dé yae hwati se wandé daata dé déré wa, “Néma Du, wuni yikafre yawute méni mawuli yata wamét, wuni yikafre yatawuni.” ");
INSERT INTO wos_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Wungi wandéka dé déré tambambu huruta dé wa, “Wuni yikafre yaméte wuni mawuli ye. Méni yikafre yataméni.” Wungi wandéka dé wun walisufu hétékéndéka dé wun du yikafre ya. ");
INSERT INTO wos_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Yandéka dé déré wa, “Mé xéké. Méniré yawun jooka nak duré yamba wakéméni. Méni priska ye déka makambu témét dé ména séfiré xétandé. Xéndét méni yikafre yaménka méni Moses hanja wandén maki Godka hamwi hwetaméni. Hwemét nak du takwa xéta walisufu hétékéndanka méni yikafre yaménka xékélakitandi.” Wungi wandéka dé yi. ");
INSERT INTO wos_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Jisas wungi yandéka séfélak getéfambu séfélak du takwa di Jisaska hundi bulé. Buléta séfélak du takwa di Jisaska ya, déka hundi xékéta Jisasré wakwexékéndat dé séfimali haraki yandé du takwaré huréhalékéndéte. ");
INSERT INTO wos_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Yandaka dé séfélak nukwa diré yatakataka dé du rehafi hafwaré ye wumbu dé God wali hundi bulé. ");
INSERT INTO wos_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Nak nukwa dé Jisas du takwaré Godna hundika wakwendéka di Farisina du nawulak, hambuk hundi wakwekwa du nawulak, wungi di re. Wunde du Galilina héfambu rekwa atéfék getéfa, Jerusalem, Judiana héfambu rekwa nawulak getéfa akwi, wunde getéfambu di ya. Yae rendaka dé Néma Du Godna hambuk Jisasna mawulimbu wulaaye téndéka dé du takwaré dé huréhaléké. ");
INSERT INTO wos_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Huréhalékéndéka du nawulak di matamba lékémbandé du nakré jambémbu yate hura ya. Yate hura yae di gekoré wulaaye Jisas téndénmbu takanjoka di mawuli ya. ");
INSERT INTO wos_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Yandaka séfélak du takwa téndaka hafwa dé sukweké. Sukwekéndéka déré hura wulayi yambuka di hwakéfatiké. Hwakéfatika di ge dawiré wara di ge nyéndékmbu féra. Férae di wun du hwandén jambémbu yoo léke di wun yambumbu husanda, du takwana nyéndékmbu. Husanda di Jisasna makambu taka. ");
INSERT INTO wos_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Takandaka Jisas dé xékélaki. Di deka mawulimbu di wa, dé wun duré hali huréhalékéndé. Wungi xékélakita dé wun duré wa, “Wuna nyayika, wuni hurumén haraki saraki sémbut wundé yakwanyiwu.” ");
INSERT INTO wos_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Jisas wun hundi wandéka di xékélelakikwa du, Farisina du akwi wungi di di hafu buléta di wa, “Wun du yingi maki du dé? God hafu du hurundan haraki saraki sémbut yakwanyitandé. Wun du dé wa, ‘Wuni hurumén haraki saraki sémbut wundé yakwanyiwu.’ Wungi wata dé Godré haraki hundi wa, dé baka du dé.” ");
INSERT INTO wos_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Wungi wandaka Jisas deka mawuliré xékélakita dé diré wa, “Métaka guni guna mawulimbu wungi saréké? Wungi sarékékénguni. ");
INSERT INTO wos_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Méta hundi hali wawu? Wuni hurumén haraki saraki sémbut wundé yakwanyiwu o méni sé raama féta yi? Méta hundi wawut guni wawun hundika mwi hundi xékélakitanguni? ");
INSERT INTO wos_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Wuni Duna Nyan ané héfambu reta hurundan haraki saraki sémbut hali yakwanyiwu. Guni wun jooka xékélakihambanguni. Guni wuna hambukéka jémba xékélakingute wuni ané hundi némbuli déré watawuni.” Wungi wataka dé matamba lékémbandé duré wa, “Méni sé raama ména jambé hérae hura méni ména geré yi.” ");
INSERT INTO wos_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Wungi wandéka dé atéfék du takwana makambu bari ramé. Raama dé hwandén jambé hérae Godna ximbu harékéta dé déka geré hura yi. ");
INSERT INTO wos_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Yindéka xéta di atéfék du takwa waréngéné. Waréngéna Godna ximbu harékéta némafwimbu roota di wa, “Owa. Némbuli nak maki hambuk jémba nani xé.” ");
INSERT INTO wos_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Hukémbu Jisas ye dé xé Romka yéwa héraakwa du nak yéwa hérandaka gembu rendéka. Wumba duna xi Livai dé. Jisas déré xétaka dé wa, “Méni wuni wali mé ya.” ");
INSERT INTO wos_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Wungi wandéka dé raama atéfék jondu yatakataka dé Jisas wali yi. ");
INSERT INTO wos_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Livai ye dé Jisaska némafwi hénoo huru, déka gembu. Hurutaka wandéka di Romka yéwa héraakwa séfélak du akwi, séfélak du akwi wungi di bér wali hénoo sa. ");
INSERT INTO wos_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Sandaka di Farisina du nawulak, deka xékélelakikwa du nawulak, wungi di Jisasna duré haraki hundi wata di wa, “Métaka guni Romka yéwa héraakwa du wali, haraki saraki sémbut hurukwa du wali, guni hénoo hulingu sa?” ");
INSERT INTO wos_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Wungi wandaka dé Jisas diré sataku hundi angi wa, “Bar hiyahafi yakwa du takwa doktaka yihafindi. Bar hiyaakwa du takwa di doktaka yi.” ");
INSERT INTO wos_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Wungi wataka dé wa, “Wuni du takwana haraki mawuli wuni huréhaléké. Haraki mawuli yakwa du takwa yandan haraki saraki mawuli yatakataka wunika yae wuna hundi xékéndate wuni gaya. Yikafre mawuli yakwa du takwaka saréka gayahambawuni.” Wungi dé Jisas diré wa. ");
INSERT INTO wos_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Du nawulak yae di Jisasré wa, “Guré husandakwa du Jonéna du di God wali hundi bulénjoka séfélak nukwa di hénooka yakér. Yakérta baka reta di God wali hundi bulé. Farisina du akwi wungi male di ya. Ména du wungi yahambandi. Di atéfék nukwa hénoo hulingu sandakandé. Métaka ména du di hénooka yakérhafi ye?” ");
INSERT INTO wos_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Wungi wandaka dé Jisas diré sataku hundi angi wa, “Du nak takwa hérandét, di hénoo humbwe yikafre mawuli yata hénoo satandi, o du nak wandét di hénooka yakértandi? Di satandi. Takwa hérandé du di wali rendét, di yikafre mawuli yata satandi. ");
INSERT INTO wos_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Hukémbu nukwa nawulak xakundat, takwa hérandé du diré yatakataka yindét di hénooka yakértandi.” ");
INSERT INTO wos_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Wun hundi wataka dé diré sataku hundi yéték akwi angi wa, “Du takwa huli nukwa wur nak léngae hérae nyo nukwa wurmbu tékwa moforé hundafanéhafindi. Di huli nukwa wur nak léngae hérae nyo nukwa wurmbu tékwa moforé hundafanétaka hukémbu gumbu yakwanyindat, huli nukwa wur yalefu maki yata dé léngatandé. Yalefu yandéka dé nyo nukwa wurmbu némafwi mofo tétandé. Huli nukwa wur wali nyo nukwa wur wali jémba yamba tékémbér. ");
INSERT INTO wos_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Nak héki hwari xiyae rundan meme balina séfimbu huli wain hulingu wukasandahafindi. Wungi wukasandandat, wun meme balina séfi nyo ye télaméndét wain hulingu atéfék yitandé. Yindét wun meme balina séfi wambula yikafre yamba yakéndé. ");
INSERT INTO wos_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Huli meme balina séfimbu wukasandandat, huli wain hulingu jémba tétandé. ");
INSERT INTO wos_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Talena wain hulingu sakwa du di huli wain hulingu sanjoka hélék yatandi. Hélék yata di wa, ‘Talena yikafre dé.’ Wungi watandi.” ");
INSERT INTO wos_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Baka hwa nukwa nak dé Jisas déka du wali di wit tékwa yawi nakmbu yi. Yita déka duré hénoo yandéka di witna humbu hutukwe di deka tambambu lékekita di wit sék sa. ");
INSERT INTO wos_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Sandaka di Farisina du nawulak xéta di diré wa, “Guni witna humbu hutukwe tambambu lékekita guni jémba ya, baka hwa nukwambu. Nana hambuk hundi angi dé wa, ‘Guni baka hwa nukwa jémba yamba yakénguni.’ Métaka guni jémba ya, baka hwa nukwambu?” ");
INSERT INTO wos_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Wungi wandaka dé diré wa, “Hanja nana mandéka Devit hurundén sémbutka di Godna nyingambu hayi. Wun hundika guni sarékéhambanguni. Hanja Devit déka du wali hénooka hiyandaka dé ");
INSERT INTO wos_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Godna geré wulaaye wun gembu prisré dé wakwexéké, Godka hweta takandan bret dika hwendate. Wakwexékéndéka hwendéka Devit wun bret déka duka hwendéka di atéfék sa. Wungi huruta di nana hambuk hundi xékéhambandi. Nana hambuk hundi angi dé wa, ‘Pris male Godka hwendan hénoo satandi. Nak du wun hénoo yamba sakéndi.’ Wungi dé hambuk hundi wa.” ");
INSERT INTO wos_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Wungi wataka dé diré wa, “Wuni Duna Nyan wuni baka hwa nukwaka wuni néma du re.” Wungi dé Jisas wa. ");
INSERT INTO wos_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Baka hwa nukwa nakmbu Jisas dé Godna hundi buléndaka geré wulaaye dé du takwaré Godna hundika wakwe. Wun gembu yika tamba haraki yandé du nak dé re. ");
INSERT INTO wos_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Rendéka di xékélelakikwa du akwi, Farisina du akwi di wun gembu reta di Jisasré xé. Deka mawulimbu di wa, “Jisas baka hwa nukwambu wun duré huréhalékétandé, o yingafwe? Déré huréhalékéta dé nana hambuk hundika hu hwetandé. Wungi yandét, nani déré duna makambu takatame.” ");
INSERT INTO wos_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Wungi wandaka dé deka mawuli dé xékélaki. Xékélakita dé tamba haraki yandé duré wa, “Sé raama ye deka makambu témét, atéfék méniré xénda.” Wungi wandéka dé raama dé wumbu té. ");
INSERT INTO wos_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Téndéka dé Jisas diré wa, “Wuni guniré hundi nak wakwexékétawuni. Nana hambuk hundi yingi dé wa? Baka hwa nukwambu nani yikafre joo yatame, o haraki sémbut hurutame? Baka hwa nukwambu hiyanjoka hurukwa du takwaré yikafre hurutame, o diré xiyatame?” ");
INSERT INTO wos_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Wungi wataka di nak nakré xétaka dé wun duré wa, “Ména tamba mé huritéké.” Wungi wandéka dé déka tamba huritékéndéka dé wambula yikafre ya. ");
INSERT INTO wos_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Yandéka di némafwimbu mawuli wita di hafu buléta di wa, “Nani Jisasré méta yatame?” Wungi di wa. ");
INSERT INTO wos_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Wun nukwa Jisas God wali hundi bulénjoka dé némburé wari. Ware gan dé God wali hundi bulé. Hundi buléndéka dé xitélaké. ");
INSERT INTO wos_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Xitélakéndéka nukwa xalendéka dé déka duka wandéka di ya. Yandaka dé du tamba yéti manmbu yéték wungi diré dé waséketa dé ané xi dika hwe, aposel dé. ");
INSERT INTO wos_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Deka xi angi dé: Saimon. Déka Jisas dé nak xi hwe, Pita. Saimonéna bandi, Andru. Jems. Jon. Filip. Bartolomyu. ");
INSERT INTO wos_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Matyu. Tomas. Alfiusna nyan, Jems. Saimon. Dé hanja atéfék getéfaré yita dé wa, “Nak téfana du nanika néma du rendémboka hélék wuni ye.” ");
INSERT INTO wos_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Jemsna nyan, Judas. Judas Iskariot. Hukémbu dé Jisasré mama duka hwe. ");
INSERT INTO wos_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Jisas déka du wali naande ye dé bwiyande hafwa nakmbu dé té. Déka séfélak du dé wali téndaka séfélak du takwa di akwi di té. Di Jerusalem, Judiana héfambu rekwa nawulak getéfa, Tair, Saidonmbu akwi di ya. Tair, Saidon akwi némafwi xéri tufwambu bér té. ");
INSERT INTO wos_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Wunde du takwa nawulak Jisasna hundi xékénjoka di ya. Wunde du takwa nawulak bar hiyae di dé diré huréhalékéndéte di ya. Wunde du takwaré nawulak haraki hamwinya hura téndaka di akwi di ya. Yandaka dé wandéka yaange yindaka di wunde du takwa yikafre ya. ");
INSERT INTO wos_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Yandaka dé wandéka di xékélaki. Jisasna hambuk némafwi yandéka dé diré huréhaléké. Wungi xékélakita di atéfék di déka séfiré séngétakanjoka di mawuli ya. ");
INSERT INTO wos_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Jisas déka duré xéta dé diré wa, “Guni jambangwe du takwa, guni Godna hémémbu renguka God néma du reta gunika dé jémba hati. Hatindékaka guni yikafre mawuli yatanguni. ");
INSERT INTO wos_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","“Guni némbuli hénooka hiyaakwa du takwa, hukémbu guni séfélak hénoo satanguni. Satengukaka guni yikafre mawuli yatanguni. “Guni némbuli géraakwa du takwa, hukémbu guni wangitanguni. Wangitengukaka guni yikafre mawuli yatanguni. ");
INSERT INTO wos_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","“Mé xéké. Wuni Duna Nyan rewuka guni wuna hundika guni xéké. Du nawulak wuna mama du reta gunika hélék yata gunika hu hweta guniré haraki hundi wata guniré angi watandi, ‘Guni haraki saraki sémbut hurukwa du takwa guni.’ Wungi wandat, guni yikafre mawuli yatanguni. ");
INSERT INTO wos_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Hanja wunde duna mandéka di Godna profetré wungi di haraki huru. Diré wungi haraki hurundanka sarékéta di guniré wungi haraki hurundat guni yikafre mawuli yatanguni. Hukémbu God déka getéfambu guniré némafwimbu yikafre hurutandé. Hurutendékaka guni yikafre mawuli yata némafwimbu mawuli sawuli yatanguni. ");
INSERT INTO wos_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","“Guni xérénjuwi mama du takwa, guni guna yikafre jondu wundé hérangu. Héraata guni jémba re. Guni xékélaki na. Hukémbu xakéngali gunika yandét, guni jémba yamba rekénguni. ");
INSERT INTO wos_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","“Guni hénoo sata biya sukwekéndéka rekwa du takwa, guni xékélaki na. Hukémbu xakéngali gunika yandét guni hénooka hiyatanguni. “Guni wangikwa du takwa, guni xékélaki na. Hukémbu haraki mawuli xékéta gératanguni. ");
INSERT INTO wos_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","“Atéfék du takwa guna ximbu harékéndat, guni xékélaki natanguni. Hanja guna mandéka yénataka hundi wandé duna ximbu di haréké. Némbuli rekwa du guna ximbu harékéndat, wafewana guni akwi yénataka hundi wakwa du guni re? Némbuli rekwa du guna ximbu harékéndat, xakéngali gunika yatandé.” ");
INSERT INTO wos_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","Wun hundi wataka dé Jisas diré angi wa, “Guni, wuna hundika xékékwa du takwa, guniré wuni we. Guni guna mama duka némafwimbu mawuli yatanguni. Gunika némafwimbu hélék yakwa du takwaré yikafre hurutanguni. ");
INSERT INTO wos_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Gunika haraki hundi wakwa du takwaka guni Godré wakwexékétanguni, dé diré yikafre hurundéte. Guniré haraki saraki sémbut hurukwa du takwaka guni Godré wakwexékétanguni, dé dika yikafre mawuli hwendéte. ");
INSERT INTO wos_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Du nak guna saawimbu yika tamba sakumbu guniré xiyandét, guni waleka baka tétanguni, dé guna saawimbu aki tamba sakumbu xiyandéte. Du nak guna nukwa wur hérandét, guni guna sanda wur akwi déka hwetanguni. ");
INSERT INTO wos_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Du nawulak guniré joo nakéka wakwexékéndat, guni wun joo dika hwetanguni. Di guna joo hérandat, guni wun joo wambula héranjoka diré wakénguni. ");
INSERT INTO wos_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Nak du guniré yikafre hurundate mawuli yanguka maki, guni diré wungi yikafre hurutanguni. ");
INSERT INTO wos_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","“Guni gunika némafwimbu mawuli yakwa du takwaka male némafwimbu mawuli yangut, méta yikafre jémba guni ya? Wu yingafwe. Haraki saraki sémbut hurukwa du takwa akwi di dika némafwimbu mawuli yakwa du takwaka di némafwimbu mawuli ya. ");
INSERT INTO wos_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Guni guniré yikafre hurukwa du takwaré male guni yikafre hurungut, méta yikafre jémba guni ya? Wu yingafwe. Haraki saraki sémbut hurukwa du takwa akwi di wungi huru. ");
INSERT INTO wos_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Guni nawulak du takwa gunika hasa hwendate guni dika joo nak hwengut, méta yikafre jémba guni ya? Wu yingafwe. Haraki sémbut hurukwa du takwa akwi di nawulak du takwaka jondu di hwe, di hasa hwendate. ");
INSERT INTO wos_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Guni guna mama duka némafwimbu mawuli yatanguni. Yata guni diré yikafre hurutanguni. Huruta guni dika joo hweta wun joo hasa hwetendakaka sarékékénguni. Guni wungi hurungut, némafwi hambuk yakwa God gunika watandé, ‘Di wuna nyangwal di.’ Wungi wata guniré yikafre male hurutandé. Hurundét guni jémba retanguni. Guna yafa God dé saréfa na, déka sarékéhafi yata haraki saraki sémbut hurukwa du takwaka. ");
INSERT INTO wos_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Dé dika saréfa nandéka maki, guni akwi dika saréfa natanguni.” ");
INSERT INTO wos_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","Wun hundi wataka dé Jisas angi wa, “Nawulak du takwa hurundan jooka sarékéta guni diré haraki hundi wahafi yata bari angi wakénguni, ‘Wunde du takwa di haraki saraki sémbut hurukwa du takwa di.’ Wungi wahafi yangut, God hurungun jonduka sarékéta dé akwi bari angi yamba wakéndé, ‘Guni haraki saraki sémbut hurukwa du guni.’ Wungi yamba wakéndé. Guni wunde du takwaré bari wahafi yata guni di hurundan haraki saraki sémbutka sarékékénguni. Wungi sarékéhafi yangut God hurungun haraki saraki sémbut yakwanyitaka dé wun jooka wambula yamba sarékékéndé. ");
INSERT INTO wos_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Guni du takwaka jondu hwetanguni. Hwengut God gunika hwetandé. Dé hwengunré sarékéngwanda dé séfélakmbu hwetandé. Guni nawulak du takwaré yikafre hurunguka maki God guniré yikafre hurutandé.” ");
INSERT INTO wos_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Wun hundi wataka dé Jisas diré ané sataku hundi wa, “Dama hiyandé du nak dé nak dama hiyandé duré yambu wakwetandé, o yingafwe? Wungi yingafwe. Déré wakwenjoka ye bér yituku wekwambu xakritambér. ");
INSERT INTO wos_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Skulka yikwa nyangwal di baka du maki di. Diré wakwekwa du dé deka néma du dé. Dé diré wakwendét jémba xékéta hukémbu wunde nyangwal diré wakwendé du maki néma du retandi.” ");
INSERT INTO wos_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","Wun sataku hundi wataka dé Jisas diré angi wa, “Métaka guni guna nyayikana damambu hwakwa yikama mikulanyiré xéta guni guna damambu hwakwa némafwi bangiré xéhafi ye? ");
INSERT INTO wos_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Guna damambu hwakwa bangiré xéhafi ye yingi maki nae guni guna nyayikaka watanguni, ‘Wuni ména damambu hwakwa yikama mikulanyi hérekitawuni.’ Wungi wata guni yéna guni ye. Tale guna damambu hwakwa némafwi bangi hérekitaka jémba xe hukémbu guna nyayikana damambu hwakwa mikulanyi hali hérekingu.” ");
INSERT INTO wos_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","Wun hundi wataka dé Jisas diré angi wa, “Ané sataku hundi mé xéké. Yikafre mimbu haraki sék xakéhafindi. Haraki mimbu yikafre sék xakéhafindi. ");
INSERT INTO wos_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Nani misékré xéta nani xékélaki. Méta mi yikafre mi dé? Méta mi haraki mi dé? Nani xékélaki. Rami yoombu nani jangéra gélihafime. Jufwembu nani wana sék gélihafime. ");
INSERT INTO wos_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Mika xékélakimbeka maki, nani du takwana jémbaré xéta nani deka mawulika nani xékélaki. Yikafre du deka mawulimbu yikafre mawuli male xalendéka di yikafre hundi buléta yikafre sémbut huru. Haraki saraki du deka mawulimbu haraki saraki mawuli male xalendéka di haraki saraki hundi buléta haraki saraki sémbut huru. ");
INSERT INTO wos_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","“Guni wunika guni we, ‘Méni, nana Néma Du méni.’ Wungi wata guni wuna hundi xékéhafi ye. Métaka guni wungi wata wuna hundi xékénjoka hélék ye? ");
INSERT INTO wos_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Wunika yata wuna hundi xékéta wawun maki hurukwa du takwa di ané du maki di. ");
INSERT INTO wos_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Dé yikafre ge tonjoka dé némafwi wekwa xa. Xataka motumbu dé hwaar se. Setaka hambuk yandéka yikafre ge dé to. Tondéka wali giyandéka hwe gwanda wun geré teléka wun ge xakrihambandé. Hambuk ye jémba dé té. ");
INSERT INTO wos_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Wuna hundi baka xékéta wawun maki huruhafi yakwa du takwa di ané du maki di. Dé ge bari tonjoka dé hwaar baka xataka. Xatakataka dé ge jémba téndéte sarékéhafi yata dé wekwa xahambandé. Xahafi yandéka wali giyandéka hwe gwanda wun geré teléka dé wun ge bari xakri. Xakrindéka hwe yae lé wun geré yate hura yi.” Wungi dé Jisas diré wa. ");
INSERT INTO wos_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Jisas du takwaré wun hundi wataka dé Kaperneamré yi. ");
INSERT INTO wos_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Wun getéfambu dé Romna xi warekwa duna néma du nak dé re. Dé déka jémba yakwa du nakéka dé némafwimbu mawuli ya. Yandéka dé déka jémba yakwa du bar hiyae dé hiyanjoka huru. ");
INSERT INTO wos_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Hurundéka wun néma du dé xéké, Jisas wun getéfambu rendéka. Xékétaka dé Judana néma du nawulakré wandéka di Jisaska ya, dé di wali ye déka jémba yakwa duré huréhalékéndéte. ");
INSERT INTO wos_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Yae di déré wa, “Wun du dé yikafre du dé, méni déré yikafre huruméte. ");
INSERT INTO wos_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Dé nani Judaka dé némafwimbu mawuli ye. Dé Godna hundi buléndaka ge dé to, nanika.” ");
INSERT INTO wos_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Wungi wandaka dé Jisas deka hundi xékétaka dé di wali yi. Ye gembu xakunjoka yandéka xi warekwa duna néma du déka nyayika nawulakré wandéka di yae Jisasré déka hundi angi wa, “Néma Du, wuni baka du wuni re. Méni néma du méni re. Wungi reta méni wuna geré yamba xalekéméni. ");
INSERT INTO wos_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Wungi rewuka sarékéta wuni ménika yahambawuni. Méni baka wamét wuna du wambula yikafre yatandé. ");
INSERT INTO wos_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Wuni akwi nak duna ekombu reta, nawulak xi warekwa duka néma du re. Wuni du nakré ‘Sa yi’ wawuka dé yi. Nak duré ‘Mé ya’ wawuka dé yae. Wuna jémba yakwa duré ‘Ané jémba mé ya’ wawuka dé wun jémba ya.” ");
INSERT INTO wos_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Jisas wun hundi xékétaka dé wun duka némafwimbu waréngéné. Waréngéna waleka déka hukémbu yandé séfélak du takwaré dé wa, “Guniré wuni we. Wun du wunika jémba male sarékéndékangala wuni nawulak hafwambu xéhambawuni. Israelmbu akwi xéhambawuni.” ");
INSERT INTO wos_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Wunde hundi hura yindé du di geré wambula ye wulaaye di xé, néma duna jémba yakwa du wambula yikafre ye rendéka. ");
INSERT INTO wos_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Hukémbu dé Jisas nak getéfaré yi. Wun getéfana xi Nain dé. Séfélak du takwa akwi, déka du akwi, di dé wali yi. ");
INSERT INTO wos_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Ye wun getéfana wulayi gwande yambumbu xakunjoka yandaka di hiyandé bweku du nakré yata xale. Déka ayiwa déré male lé héra. Nak nyan akwi yingafwe. Wule takwana du hanjambu dé hiya. Wun getéfambu rendé séfélak du takwa di wule takwa wali yi. ");
INSERT INTO wos_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Yindaka Néma Du xéta dé wule takwaka saréfa naata dé léré wa, “Gérakényéni.” ");
INSERT INTO wos_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Wungi wataka ye dé hiyandé duna jambémbu hura té. Téndéka di jambé yatandé du té. Téndaka dé wa, “Wayikana du, méniré wuni we. Méni sé ramé.” ");
INSERT INTO wos_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Wungi wandéka dé hiyandé du raama reta dé hundi bulé. Buléndéka Jisas dé déré déka ayiwaka hwe. ");
INSERT INTO wos_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Hwendéka di atéfék du takwa waréngéna némafwimbu roota di Godna ximbu haréké. Harékéta di wa, “Némafwi profet nak dé nana nyéndékmbu dé xaku.” Wungi wata di wa, “Némbuli God déka du takwaré yikafre hurunjoka dé ya.” ");
INSERT INTO wos_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Wungi di Jisas hurundén jooka wa saafa yi. Wa saafa yindaka dé deka hundi dé atéfék Judiana hafwambu, walémbambu rekwa hafwambu akwi dé yi. ");
INSERT INTO wos_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Guré husandakwa du Jon séndé gembu hwandéka déka du yae di déré Jisas hurundén atéfék jonduka wa. Wandaka dé Jon wandéka déka du yéték yambéka dé bérré wa, ");
INSERT INTO wos_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","“Béni Jisaska ye béni déré angi wakwexékétambéni, ‘Méni hukémbu yatekwa du méni wana yingafwe wana? Nani nak duka haxétame wana?’ Wungi déré watambéni.” ");
INSERT INTO wos_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Wungi wandéka ye bér Jisas rendénmbu xaakwa bér wa, “Guré husandakwa du Jon aniré wandéka ani ménika ya. Ané hundi méniré wakwexékénjoka ani ya. Méni hukémbu yatekwa du méni wana yingafwe wana? Nani nak duka haxétame wana?” ");
INSERT INTO wos_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Wun nukwa dé Jisas bar hiyaakwa séfélak du takwa akwi, séfimali haraki yandé séfélak du takwaré akwi haraki hamwinya hura téndé séfélak du takwaré akwi dé huréhaléké. Huréhaléka dé dama hiyandé du takwaré wandéka di wambula jémba xé. ");
INSERT INTO wos_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Jisas wungi hura dé Jonéna du yétékré wa, “Béni wambula ye béni xéta xékéngun jonduka Jonré watambéni. Dama hiyandé du takwa wambula xéndaka di man haraki yandé du takwa yikafre ye di yitaka yataka. Walisufu hurundé du takwa yikafre yandaka di waan héténdé du takwa di hundi xéké. Wuni wawuka hiyandé du takwa di wambula raama re. Jambangwe du takwaré wuni Godna hundi wa. ");
INSERT INTO wos_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Wunika yéték mawuli sarékéhafi yakwa du takwa di yikafre mawuli yata jémba retandi.” Wungi dé Jonéna duré wa. ");
INSERT INTO wos_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Jisas wungi wandéka Jonéna du yéték yimbéka dé Jisas wumbu rendé séfélak du takwaré Jonka angi wa, “Guni métakina jooré xénjoka guni du rehafi hafwaré yi? Guni mur yata funyi hwaakwa suwaré xénjoka guni yi wana? ");
INSERT INTO wos_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Guni méta jooré xénjoka guni wungi gwande? Yikafre nukwa wur sandakwa duré xénjoka guni yi? Wu yingafwe. Yikafre nukwa wur sandata yikafre jondu hura tékwa du di néma duna yikafre gembu di re. ");
INSERT INTO wos_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Guni méta jooré xénjoka guni wungi gwande? Profet nakré wana? Xéxé, Jon profet nak dé. Guniré wuni we. Dé profet male yingafwe. ");
INSERT INTO wos_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Jonka ané hundi Godna nyingambu dé re: Mé xé, ané wuna hundi hura yikwa du dé. Déré watawuni, dé ména makambu yindéte. Dé tale ye ména yambu hurutandé. ");
INSERT INTO wos_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Guniré wuni we. Jon atéfék ané héfambu rekwa duré dé sarékéngwandé. Sarékéngwandéndéka dé God néma du rendéka getéfambu yikama nyangwal maki rekwa du takwa di Jonré sarékéngwandé.” ");
INSERT INTO wos_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Wun hundi wandéka di wumbu tékwa atéfék du takwa akwi Romka yéwa héraakwa du akwi di wun hundika yikafre mawuli ya. Hanja wunde du takwa di Jonéna hundi xékéndaka Jon diré guré husanda. Husandandénka di Jisasna hundi xékétaka yikafre mawuli yata di wa, “Godna sémbut yikafre dé.” ");
INSERT INTO wos_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Wungi wandaka di Farisina du akwi, xékélelakikwa du akwi di God mawuli yandéka makimbu hurunjoka hélék di ya. Hanja akwi di Jonéna hundika hu hwendaka Jon diré guré husandahambandé. ");
INSERT INTO wos_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Wun hundi wataka dé Jisas diré angi wa, “Némbuli rekwa du takwaka yingi maki watawuni? Di héndéngala di? ");
INSERT INTO wos_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Di amembu reta nak nakéka wakwa nyangwal maki di. Wunde nyangwal di nak nakéka angi wata re, ‘Nani hama yombeka guni hétihiyahambanguni. Nani saréfa gwar wambeka guni gérahambanguni.’ ");
INSERT INTO wos_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Wunde nyangwal wandaka maki, guré husandakwa du Jon yae dé bret akwi wain hulingu akwi sahafi yandéka guni déka angi wa, ‘Haraki hamwinya déka mawulimbu dé té.’ ");
INSERT INTO wos_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Wungi wanguka Duna Nyan yae dé hénoo akwi wain hulingu akwi sandéka guni déka angi wa, ‘Mé xé. Wun du dé séfélak hénoo séfélak wain hulingu satéfwa du dé. Dé Romka yéwa héraakwa haraki du wali reta, haraki saraki sémbut hurukwa du takwa wali reta dé deka nyayika dé re.’ ");
INSERT INTO wos_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Wu yak. Jémba sarékéta jémba xékélakikwa du takwa God hurundén sémbutka yawundu natandi.” Wungi dé Jisas wa. ");
INSERT INTO wos_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Farisina du nak déka xi Saimon Jisasré dé wa, dé yae dé wali hénoo sandéte. Wandéka yae wun duna geré wulaaye jambémbu hwaata dé hénoo sa. ");
INSERT INTO wos_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Dé wun Farisina gembu sata hwandéka lé haraki saraki sémbut hurukwa takwa hési lé wun getéfambu reta lé xéké. Xékétaka lé motumbu tandan yikama andé hura ya. Wun andémbu yikafre yama xaakwa hulingu dé té. ");
INSERT INTO wos_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Hura yae lé Jisasna hungali sakumbu téta déka man mombu téta géraata lé léka ménengu déka manmbu bleké. Blekétaka lé léka anéngambambu tékwa séményi némbémbu lé déka man létéké. Létékétaka séfélak yambu lé déka manré tamaruta lé yikafre yama xaakwa hulingu lé déka manmbu bleké. ");
INSERT INTO wos_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Blekéléka Jisas yandéte wandé Farisina du xéta dé déka mawulimbu angi wa, “Wun du profet reta dé déré hurukwa takwaka hurulén sémbutka akwi xékélakitandé. Wu, lé haraki saraki sémbut hurukwa takwa lé.” ");
INSERT INTO wos_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Wungi sarékéndéka Jisas dé déré wa, “Saimon, wuni méniré nak hundi wanjoka wuni mawuli ye.” Wungi wandéka dé wa, “Wakwekwa du, méni mé wa.” ");
INSERT INTO wos_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Wungi wandéka dé wa, “Du yéték bér nak dumbu yéwa baka héra. Nak du dé séfélak (500) nukwana yéwa héra. Nak du dé nawulak (50) nukwana yéwa male dé héra. Hérambéka hukémbu dé haxé, wun yéwa hasa hwembéte. ");
INSERT INTO wos_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Wumbére du yéték bér déka yéwa hasa hwenjoka bér hurufatiké. Hurufatikémbéka dé bérré baka yikafre huruta dé wa, ‘Reséndé. Wun yéwaka wambula yamba sarékékéwuni.’ Wungi wandénka yingi méni saréké? Wumbére du yéték héndé yéwa hwendé duka némafwimbu mawuli yatandé?” ");
INSERT INTO wos_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Wungi wandéka dé Saimon wa, “Séfélak yéwa hérandé du. Wungi wuni saréké.” Wungi wandéka dé wa, “Wu mwi hundi méni wa.” ");
INSERT INTO wos_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Wun hundi wataka Jisas wule takwaka waleka dé Saimonré wa, “Ale takwaré méni xé? Wuni ména geré gwandewuka méni hulingu nawulak wunika hwehambaméni, wuna man yakwanyiwute. Ale takwa lé léka ménengumbu wuna man yakwanyita lé léka némbémbu lé létéké. ");
INSERT INTO wos_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Méni wuniré tamaruhambaméni. Wuni ambu xale rewuka wule takwa yae lé wuna manré wambula wambula tamaruta re. ");
INSERT INTO wos_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Méni wuna anéngambambu wel hulingu blekéhambaméni. Lé yikafre yama xaakwa hulingu wuna manmbu lé bleké. ");
INSERT INTO wos_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Wungi maki wuni méniré we. Hurulén séfélak haraki saraki sémbut wundé hérekiwu. Hérekiwunka lé wunika némafwimbu mawuli ya. Déka yalefu haraki saraki sémbut hérekiwun du dé wunika yalefumbu mawuli dé ye.” ");
INSERT INTO wos_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Wungi wataka dé wule takwaré wa, “Hurunyén haraki saraki sémbut bu yakwanyiwu.” ");
INSERT INTO wos_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Wungi wandéka di dé wali hénoo sata rendé du di hafu buléta di wa, “Yingi maki dé? Dé haraki saraki sémbut hali hérekindé wana?” ");
INSERT INTO wos_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Wungi wandaka dé Jisas wun hundi hasa wahafi yata dé wule takwaré wa, “Nyéni wunika jémba sarékényékaka wuni nyéniré yikafre huruta nyéna haraki saraki sémbut héreki. Nyéni sa ye nyéna mawuli nakélak mé téndé.” Wungi dé léré wa. ");
INSERT INTO wos_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Nawulak nukwa yindéka dé Jisas séfélak getéfambu yitaka yataka. Yitaka yatakata dé yikafre hundi du takwaré wa, God néma du reta du takwaka jémba hatitendékaka. Déka du tamba yéti man yéték di dé wali yindaka ");
INSERT INTO wos_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","takwa nawulak akwi di dé wali yi. Hanja wunde takwa nawulak di bar hiyandaka nawulak haraki hamwinya deka mawulimbu téndéka dé Jisas di atéfékré huréhaléké. Wunde takwa hési Maria lé. Léka di wa Makdalambu yalé takwa lé. Hanja haraki hamwinya angé tamba yétiyéti angé tamba hufuk di léka mawulimbu re di léré yatakataka yaange yi. ");
INSERT INTO wos_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Hési takwa akwi léka xi Joana. Lé Kusana takwa lé. Kusa dé Herotna geka hatikwa du dé. Hési takwa Susana lé. Séfélak takwa akwi di di wali yi. Wunde takwa di deka hafu yéwa hénoo hérae di Jisas déka duka akwi hwe. ");
INSERT INTO wos_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Séfélak du takwa di Jisaska yae hérangwanda té. Wunde du takwa séfélak getéfambu di ya. Yandaka dé diré ané sataku hundi wa: ");
INSERT INTO wos_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“Du nak dé déka yawimbu wit sék yawulalama yakinjoka dé yi. Ye yawulalama yakindéka di wit sék nawulak yambumbu di xakri. Xakrindaka du takwa yitaka yatakata di yambumbu rendé wit sékmbu xaki. Xakindaka di afwi yae hérae di sa. ");
INSERT INTO wos_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Wit sék nawulak motu wali rendé héfambu di xakri. Xakre bari takélaka wara di bari yalinga talinga ye di hiya, wun héfambu hulingu téhafi yandénka. ");
INSERT INTO wos_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Wit sék nawulak di rami wara téndénmbu xakri. Xakre rendaka rami wara wura dé yakétéfi. ");
INSERT INTO wos_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Wit sék nawulak di yikafre héfambu xakri. Xakre wumbu re di jémba wara di séfélak yikafre sék xaké.” Wungi wataka dé Jisas wa, “Guna waan téndét, guni wun hundi mé jémba xéké.” ");
INSERT INTO wos_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Jisas wun hundi wandéka di déka du wun sataku hundika déré wakwexéké. ");
INSERT INTO wos_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Wakwexékéndaka dé diré wa, “God dé yawundu na, guni God néma du reta du takwaka jémba hatitendéka hundi jémba xékélakingute. Wun hundi dé faakwa re. Wungi rendéka wuni nawulak du takwaré sataku hundi wa, di ‘xe jémba xéhafi yata, hundi xéka wun hundika xékélakihafi yandate.’ ");
INSERT INTO wos_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","“Némbuli wun sataku hundika watawuni. Wun wit sék Godna hundi dé. ");
INSERT INTO wos_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Yambumbu xakrindé wit sék di Godna hundi xékéndé du takwa di. Di wun hundi xékéndaka Satan yae dé wun hundi deka mawulimbu hérae hura yi, di Godka jémba sarékéhafi yandat, God diré yikafre huruhafi yandéte. ");
INSERT INTO wos_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Wun motu wali rendé héfambu xakrindé wit sék di ande du takwa di. Di tale Godna hundi xéka wun hundika yikafre mawuli ya. Mawuli yandaka wun hundi deka mawulimbu jémba téhafi yandéka di nawulak nukwa male Godka jémba saréké. Wungi sarékéndaka mawuliré hurukwexé joo dika yandét, di Godna hundi bari yataka. ");
INSERT INTO wos_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Wun rami warambu xakrindé wit sék di ande du takwa di. Tale di Godna hundi jémba xéké. Xékéndaka nawulak nukwa yindéka di ané héfana jonduka sarékéta séfélak yéwa yikafre jondu akwi héranjoka di mawuli ya. Wun jondu dé Godna hundiré takatéfindéka di yikafre wit sék xakéhambandi. ");
INSERT INTO wos_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Yikafre héfambu xakrindé wit sék di Godna hundi jémba xékékwa du takwa di. Di yéna yahafi yandaka déka mawuli jémba téndéka di Godna hundi jémba male xéké. Xéka di wun hundi hulukita di wendé nahafi yata di yikafre sék di xaké.” Wungi dé Jisas wa. ");
INSERT INTO wos_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Wun hundi wataka dé Jisas wa, “Du hanyikwa ya xéréka hura yae di wun hanyikwa ya akimbu samétakahambandi. Di wun hanyikwa ya jambé ekombu akwi takahambandi. Di wun hanyikwa ya jambé takumbu takatandi, wun hanyikwa ya xérékéta hanyindét jémba xénjoka. ");
INSERT INTO wos_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Atéfék fakuta rekwa jondu hukémbu hwiya hafwambu tétandi. Nakélak wandan hundi hukémbu larékombu téndét atéfék xékélakitandi. ");
INSERT INTO wos_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Wungi maki wuna hundi xékénjoka xékélaki natanguni. Wuna hundi jémba xékékwa du takwa hukémbu Godna hundika jémba xékélakitandi. Wuna hundi jémba xékéhafi yakwa du takwa di wa, ‘Nani Godna hundika bu xékélakikwa.’ Wungi wataka hukémbu di déka hundika yike yata baka retandi.” Wungi dé Jisas wa. ");
INSERT INTO wos_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Wun nukwa Jisasna ayiwa déka bandingu akwi di déka ya. Yandaka séfélak du takwa gekombu sukweka téndaka di téndénré wulayinjoka di hurufatiké. ");
INSERT INTO wos_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Hurufatikéndaka du nawulak di déré wa, “Ména ayiwa, ména bandingu yae hafwambu téta di méniré xénjoka di mawuli ye.” ");
INSERT INTO wos_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Wungi wandaka dé diré wa, “Godna hundi xékéta wandén maki hurukwa du takwa di wuna ayiwa wuna bandingu di.” Wungi dé Jisas wa. ");
INSERT INTO wos_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Nukwa nak dé Jisas déka du wali di gunjambé nakmbu waré. Wara dé diré wa, “Nani tukweseke angé sakuré yitame.” Wungi wandéka di wungi yi. ");
INSERT INTO wos_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Yita dé Jisas xéndi hwa. Hwandéka néma mur yandéka dé gu raama wara gunjambémbu gwanda dé sukwekénjoka huru. Hurundéka di hiyanjoka huru. ");
INSERT INTO wos_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Huruta di Jisasré sérkena di déré wa, “Néma du, nani hiyatame.” Wungi wandaka waréngéna raama wandéka mur fakénandéka dé gu naande ye dé jémba té. ");
INSERT INTO wos_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Téndéka dé diré wa, “Métaka wuni guniré yikafre hurutewuka hambukéka guni sarékéhambanguni?” Wungi wandéka di roota waréngéna di hafu buléta di wa, “Owa. Dé wandéka dé mur akwi xéri akwi déka hundi xékéta wandén maki bér huru. Dé yingi maki du dé?” ");
INSERT INTO wos_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Jisas déka du wali gunjambémbu ye di Geresana héfambu xaku. Wun hafwa tukweseke angé sakumbu téndéka Galilina héfa angé sakumbu dé té. ");
INSERT INTO wos_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Xaakwa gunjambé yatakataka tukweseke tufwambu yinjoka hurundaka wun getéfana haraki hamwinya huru téndén du nak dé Jisasré xénjoka ya. Hanjambu take dé nukwa wur nakihafi yata dé séfi baka dé re. Dé gembu rehafi yata dé du takwa hiyandaka réméndan hafwambu male dé re. ");
INSERT INTO wos_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","29","Déré hura téndé haraki hamwinya séfélak nukwa di déré huluke haraki huru. Haraki hurundaka dé wangété yandéka du nawulak déka man tamba senmbu di gi. Giya di déka hatita té. Téndaka dé wun sen nékétindéka di haraki hamwinya du rehafi hafwaré déré hura yi. Wun du Jisasré xénjoka yandéka dé Jisas wa, déré hura téndé haraki hamwinya yaange yindate. Wandéka dé déré xétaka wanjita dé Jisasna man mombu xakre hwaata dé wa, “Anwarmbu rekwa Godna nyan, Jisas. Méni wuniré méta yataméni? Wuni méniré wuni wakwexéké, méni wunika hangéli hwemémboka.” ");
INSERT INTO wos_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Wungi wandéka dé déré wa, “Ména xi yingi dé?” Wungi wandéka dé wa, “Wuna xi Séfélak dé.” Séfélak haraki hamwinya hura téndéka dé wungi wa. ");
INSERT INTO wos_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Wunde haraki hamwinya di Jisasré wa, “Nani haraki hafwaré yinjoka hélék nani ye. Méniré nani wakwexéké, méni nani wungiré yimbete wamémboka.” Wungi di wa. ");
INSERT INTO wos_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Wun némbumbu séfélak bali di hénoo sata téndaka di wun duré hura téndé haraki hamwinya Jisasré wa, “Méni yawundu namét, nani wunde balina mawuliré wulayitame.” Wungi wandaka dé diré wa, “Yak. Sa guni yi.” ");
INSERT INTO wos_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Wungi wandéka di wun duré yatakataka ye di wunde baliré wulayi. Wulaaye téndaka wunde bali takumbu yaange ye gumbu xakre hulingu se di hiya. ");
INSERT INTO wos_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Wun balika hatindé du wungi yandaka xétaka di yaange yi. Ye di wun getéfambu rendé du takwaré akwi wun getéfa walémbambu rendé du takwaré akwi wun jooka wa safé. ");
INSERT INTO wos_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Wa saféndaka di du takwa wun jooré xénjoka di yi. Ye Jisas téndénmbu xaakwa di haraki hamwinya yatakataka yindé duré di xé. Dé nukwa wur nakitaka yikafre mawuli yata Jisasna man mombu rendéka di xé. Xéta di némafwimbu roo. ");
INSERT INTO wos_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Roondaka di Jisas hurundén jooré xéndé du takwa di diré hundi wa, haraki hamwinya hura téndé du yikafre yandénka. ");
INSERT INTO wos_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Wandaka di Geresana héfambu rendé atéfék du takwa di némafwimbu roota Jisasré wa, dé diré yatakataka yindéte. Wandaka dé Jisas diré yatakataka yinjoka huruta dé gunjambémbu waré. ");
INSERT INTO wos_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Waréndéka dé haraki hamwinya yatakataka yindén du dé déré wambula wambula wakwexéké, “Wuni méni wali yinjoka wuni mawuli ye.” Wungi wakwexékéndéka dé Jisas yawundu nahafi yata dé déré wa, ");
INSERT INTO wos_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“Méni ména getéfaré wambula ye méni God méniré hurundén jooka hundi wataméni.” Wungi wandéka ye dé déka getéfambu rendé atéfék du takwaré Jisas déré hurundén némafwi yikafre jooka dé hundi wa. ");
INSERT INTO wos_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Jisas tukweseke angé sakuré wambula ye xakundéka atéfék du takwa déré xéta di mawuli sawuli ya, déka haxéndanka. ");
INSERT INTO wos_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","42","Mawuli yandaka du nak déka xi Jairus dé Jisaska ya. Dé wun getéfambu rekwa Godna hundi buléndaka gembu dé néma du re. Déka natafa male takwanya gembu hiyawata huruta hwaléka dé wungi ya. Léka héki hwari tamba yéti man yéték male di. Dé wungi yae Jisasna man mombu xakre hwaata dé déré wa, dé déka geré yindéte. Wungi wandéka dé dé wali yindéka di séfélak du takwa dé wali walémbambu di yi. ");
INSERT INTO wos_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Deka nyéndékmbu takwa hési lé yi. Wule takwa lé tamba yéti man yéték héki hwarimbu ramu yindéka lé re. Séfélak dokta léré huréhalékénjoka di hurufatiké. ");
INSERT INTO wos_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Hurufatikéndaka lé Jisasna hukémbu yae lé déka nukwa wurna wambumbu séngétakaléka léka ramu bari fakénandéka lé yikafre ya. ");
INSERT INTO wos_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Yikafre yaléka dé Jisas wa, “Héndé wuniré séngétaka?” Wungi wandéka di atéfék wa, “Nani yingafwe.” Wungi wata téndaka dé Pita wa, “Néma Du, séfélak du takwa di méni wali walémbambu male di té.” ");
INSERT INTO wos_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Wungi wandéka dé Jisas wa, “Nak dé wuniré séngétaka. Séngétakandéka wuna hambuk nawulak yindéka wuni xékélaki.” ");
INSERT INTO wos_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Wungi wandéka lé wule takwa xékélaki. Jisas dé léka xékélaki. Wungi xékélakita lé généta yae lé Jisasna makambu xakre hwaata lé atéfék du takwana makambu lé déré séngétakalénéna moka akwi, bari yikafre yalénka akwi lé safé. ");
INSERT INTO wos_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Saféléka dé léré wa, “Takwanya, nyéni wunika jémba sarékényénmbu wuni nyéniré huréhaléké. Némbuli nyéna mawuli nakélak téndét, nyéni jémba yitanyéni.” ");
INSERT INTO wos_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Jisas wungi wata téndéka dé du nak Jairusna gembu dé ya. Yae dé wun néma duré wa, “Ména takwanya bu hiya. Méni wamét wun wakwekwa du yahafi yata déka nawulak jémba yatandé.” ");
INSERT INTO wos_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Wungi wandéka dé Jisas wun hundi xékéta dé Jairusré wa, “Méni roohafi yata wunika jémba sarékétaméni. Wungi sarékémét, lé wambula yikafre yatalé.” ");
INSERT INTO wos_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Wungi wataka dé ye wun duna gembu xaakwa dé Pita, Jon, Jems, léka yafa ayiwaré akwi wa, di dé wali wulayindate. Nawulak du takwa dé wali wulayindate dé watéfi. ");
INSERT INTO wos_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Wungi wandéka wumbu téndé atéfék du takwa wule takwanyaka saréfa naata gérandaka dé diré wa, “Gérakénguni. Lé hiyahambalé. Lé baka xéndi lé hwae.” ");
INSERT INTO wos_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Wungi wandéka di déka wangi. Di xékélaki, lé bu hiya. ");
INSERT INTO wos_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Wangindaka dé wulaaye léka tambambu huruta dé léré wa, “Nyan sé ramé.” ");
INSERT INTO wos_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Wungi wandéka léka hamwinya wambula yaléka lé bari ramé. Raméléka dé Jisas diré wa, di léka hénoo hwendat saléte. ");
INSERT INTO wos_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Lé wungi raméléka bér léka yafa ayiwa léré xéta bér waréngéné. Waréngénémbéka dé bérré wa, “Béni nawulak du takwaré wun jooka yamba wakémbéni.” Wungi dé bérré wa. ");
INSERT INTO wos_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Jisas déka duré wandéka yandaka dé dika hambuk hwe, di wandat atéfék haraki hamwinya yaange yindate. Dika nak hambuk akwi dé hwe, di bar hiyandé du takwaré akwi séfi haraki yandé du takwaré akwi huréhalékéndate. ");
INSERT INTO wos_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Hwetaka dé diré wa, di ye du takwaré God néma du reta dika jémba hatitendékaka hundi wata diré huréhalékéndate. ");
INSERT INTO wos_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Wungi wata dé diré angi wa, “Guni yinjoka jondu nawulak hura yamba yikénguni. Guni sandangun jondu male hura yitanguni. Séto bangi, wur, hénoo, yéwa, wun jondu hura yikénguni. Nukwa wur yéték hura yikénguni. ");
INSERT INTO wos_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Guni ge nakré wulaaye wun gembu male retanguni. Re wun getéfambu jémba yataka wun ge yatakataka nak getéfaré yitanguni. ");
INSERT INTO wos_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Guni getéfa nakré yingut, wun getéfambu rekwa du takwa guna hundi xékéhafi yata, gunika hu hwendat, guni wun getéfa yatakatanguni. Yatakanjoka yita guna manmbu hwakwa harki létékétaka guni yitanguni. Guni wungi hurungut di hurundan haraki sémbutka xékélakitandi. ");
INSERT INTO wos_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Wungi wandéka ye di atéfék getéfambu yitaka yataka. Yitaka yatakata Godna hundi wata di atéfék getéfambu du takwaré huréhaléké. ");
INSERT INTO wos_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","8","Galilina héfambu rekwa du takwana néma du Herot dé Jisas yandén atéfék jémbaka hundi xéké. Du takwa nawulak di Jisaska angi wa, “Guré husandakwa du Jon hiyae dé wambula ramé.” Wandaka nawulak di wa, “Elaija wambula dé xaku.” Nawulak di wa, “Hanja rendé profet nak dé wambula ramé.” Wungi wandaka Herot deka hundi xékéta dé saré waréké. ");
INSERT INTO wos_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Saré warékéta dé wa, “Wuni wawuka di Jonéna humbu xatéké. Némbuli nak duka wuni hundi xéké. Wun du héndé?” Wungi wata dé Jisasré xénjoka dé huru. ");
INSERT INTO wos_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Jisasna aposel wambula yae di Jisasré hurundan atéfék jonduka wa safé. Wa saféndaka dé diré hura di wun hafwa yatakataka di di hafu getéfa nakré yi. Wun getéfana xi Betsaida dé. ");
INSERT INTO wos_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Yindaka séfélak du takwa wun jooka hundi xékétaka di déka hukémbu yi. Yindaka dé diré xéta dika yikafre mawuli yata dé diré hundi wa, God néma du reta du takwaka jémba hatitendékaka. Wataka dé bar hiyandé du takwaré huréhaléké. ");
INSERT INTO wos_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Gérambu yandéka di déka du tamba yéti man yéték déka yae di wa, “Ané du rehafi hafwa dé. Méni wamét ande du takwa di walémbambu tékwa getéfaré ye hénoo nawulak hérae sataka bu hwanda.” ");
INSERT INTO wos_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Wungi wandaka dé diré wa, “Guni hafu mé guni hwe, di sandate.” Wungi wandéka di wa, “Nani séfélak hénoo yingafwe. Yikama bret natamba xéri hamwi yéték wungi male dé re. Wafewana, nani wunde du takwaka hénoo héranjoka nani ye yéwa hweta hénoo hérambete méni mawuli ye wana?” ");
INSERT INTO wos_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Séfélak (5,000 maki) du wumbu téndaka di wungi wa. Wungi wandaka dé Jisas diré wa, “Guni diré wangut di dumi natambambu dumi natambambu retandi.” ");
INSERT INTO wos_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Wungi wandéka di wandén maki wa, wunde du takwa atéfék wungi rendate. ");
INSERT INTO wos_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Rendaka dé Jisas bret natamba xéri hamwi yéték wungi hérae nyirré yasawara xéta dé Godka diména nataka dé bret xéri hamwi fukae dé déka duka wambula wambula hwe, di du takwaka mune hwendate. ");
INSERT INTO wos_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Mune hwendaka di atéfék du takwa hura sa, mawuli yandaka maki. Sandaka bret xéri hamwi nawulak rendéka di hérae wasara tamba yéti man yéték wungi di lakwa sukweké. ");
INSERT INTO wos_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Nak nukwa dé Jisas hafu God wali hundi buléta rendéka di déka du dé wali di re. Rendaka dé diré wakwexéké, “Du takwa wunika yingi di wa?” ");
INSERT INTO wos_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Wungi wakwexékéndéka di wa, “Ménika nawulak di wa, ‘Dé guré husandakwa du Jon dé.’ Nawulak di wa, ‘Dé Elaija dé.’ Nawulak di wa, ‘Hanja rendé Godna profet nak wambula dé ramé.’ Wungi di wa.” ");
INSERT INTO wos_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Wungi wandaka dé diré wa, “Guni yingi maki? Guni wunika yingi guni wa?” Wungi wandéka dé Pita déré wa, “Méni naniré yikafre huruméte God wasékendén du Krais méni.” ");
INSERT INTO wos_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Pita wungi wandéka dé Jisas diré wakweta dé hambukmbu wa, di nawulak du takwaré wun jooka wandamboka. ");
INSERT INTO wos_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Wungi wata dé diré wa, “Wuni Duna Nyan séfélak xakéngali hératawuni. Hérawut, Judana néma du akwi, prisna néma du akwi, xékélelakikwa du akwi wunika hu hwendat, wuniré xiyandat, wuni hiyatawuni. Hiyae nukwa hufuk wungi hwawut, God wuniré wambula husaramétandé.” ");
INSERT INTO wos_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Wun hundi wataka dé diré angi wa, “Du nak wuna hukémbu yinjoka mawuli yata dé dé hafuka hu hweta atéfék nukwa déka hangéli hératendéka mi hérae yate dé wungi wuna hukémbu yitandé. ");
INSERT INTO wos_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Ané héfambu male jémba renjoka mawuli yakwa du takwa hiyae fakutandi. Du takwa nawulak di wuna jémba yanjoka mawuli yata ané héfambu rendakaka sarékéhafi yata di jémba retandi, wungi re wungi re. ");
INSERT INTO wos_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Du takwa di ané héfana jondu atéfék héraata, di fakunjoka di hafuré haraki huruta, di yingi maki retandi? Yingafwe. Di hiyae fakutandi. ");
INSERT INTO wos_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Du takwa wuna hundika hélék yata wunika hu hwendat, hukémbu wuni Duna Nyan wambula yae dika hu hwetawuni. Wun nukwa wuni némafwi hambuk yata nukwa hanyikwa maki hanyita wuni wuna yafana némafwi hambuk wali déka yikafre enselna némafwi hambuk wali gayatawuni. ");
INSERT INTO wos_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Guniré wuni mwi hundi we. Guni ambu tékwa du nawulak hiyahafi reta xétanguni, God néma du reta déka du takwaka jémba hatindékaka.” Wungi dé déka duré wa. ");
INSERT INTO wos_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Nukwa angé tamba yétiyéti angé tamba yétiyéti maki yindéka hukémbu nukwa nak dé Jisas Pita, Jon, Jemsré akwi hura dé némburé wari, God wali hundi bulénjoka. ");
INSERT INTO wos_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Dé wumbu God wali hundi buléta rendéka déka saawi yawuleka dé nak maki xaku. Xakundéka déka nukwa wur wama male xaakwa dé hanyi. ");
INSERT INTO wos_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","31","Hanyindéka, yak, du yéték bari xaakwa bér Jisas wali téta hundi bulé. Wumbére du Moses bér Elaija bér. Bér Jisas wali téta Jisas Jerusalemémbu yatendéka jémbaka ané héfa yatakatendékaka bér dé wali bulé. ");
INSERT INTO wos_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Tale Pita dé wali yandé du yéték deka dama xéndi yandéka di xéndi hwataka waréngéna raama di xé, Jisasna séfi nukwa hanyikwa maki hanyindéka wumbére du yéték dé wali témbéka. ");
INSERT INTO wos_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Xéndaka bér yinjoka hurumbéka dé Pita Jisasré wa, “Néma Du, nani ambu rembeka, wu yikafre dé. Nani ge hufuk totame. Ménika nak, Moseska nak, Elaijaka nak.” Wungi wata dé wandén hundika xékélakihambandé. ");
INSERT INTO wos_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Wungi wandéka buwi nak xaakwa dé diré takatéfinjoka dé huru. Hurundéka di roo. ");
INSERT INTO wos_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Roondaka dé hundi nak wun buwimbu xale dé wa, “Ané wuna nyan dé. Dé wasékewun du dé. Guni déka hundi mé xéké.” ");
INSERT INTO wos_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Wun hundi wandéka xékétaka di xé, Jisas hafu téndéka. Xéta hundi nawulak buléhambandi. Buléhafi yata wunde nukwambu di xéndan joo nakéka du nakré wahambandi. ");
INSERT INTO wos_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Nukwa nak yindéka di némbumbu gayandaka di séfélak du takwa Jisaska ya. ");
INSERT INTO wos_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Yandaka dé di wali yandé du nak dé bari hambukmbu wata dé wa, “Wakwekwa du, wuni méniré wuni wakwexéké, méni wuna dunyaré xéméte. Dé wuna natafa male nyan dé. ");
INSERT INTO wos_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Mé xé. Haraki hamwinya nak dé déré huluki, séfélak nukwambu. Hulukindéka dé bari wanjindéka dé déré héfambu yakindéka dé sayiké hiyae dé wama simbar déka hundimbu xale. Wun haraki hamwinya wungi déré némafwimbu haraki huruta dé yalefu nukwa male déré yataka, dé baka rendéte. ");
INSERT INTO wos_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Wungi hurundéka wuni ména duré wakwexéké, di wandat wun haraki hamwinya yaange yindéte. Wakwexékéwuka di wungi wanjoka di hurufatiké.” ");
INSERT INTO wos_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Wungi wandéka dé Jisas wa, “Guni némbuli rekwa du takwa guni atéfék Godka jémba sarékéhafi yata haraki saraki sémbut hurukwa du takwa guni. Hatika nukwa wuni guni wali reta guna sémbutré xétawuni? Wu yak. Méni ména nyanré mé hura ya.” ");
INSERT INTO wos_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Wungi wandéka dé déka nyan hura yae Jisas téndénmbu xakunjoka hurundéka dé wun haraki hamwinya déré huluke héfambu yakindéka dé wungi sayiké hiyae. Jisas wun haraki hamwinyaré hambukmbu wa, dé wun nyanré yatakataka yaange yindéte. Wandéka yaange yindéka dé Jisas wungi wun nyanré huréhalékéta dé déré déka yafaka wambula hwe. ");
INSERT INTO wos_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Hwendéka di wumbu téndé du takwa atéfék xétaka di Godna némafwi hambukéka di waréngéné. Wunde du takwa Jisas yandén atéfék jémbaka wungi saré warékéta téndaka dé Jisas déka duré angi wa, ");
INSERT INTO wos_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“Ané hundi guna waanré mé taka wulayindé, jémba xékéngute. Hukémbu di wuni Duna Nyanré mama duna tambambu takatandi.” ");
INSERT INTO wos_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Wungi wandéka dé God wun hundina mo dé faku, di wun hundina moka xékélakindamboka. Xékélakihafi yata di wun hundika Jisasré wakwexékénjoka di roo. ");
INSERT INTO wos_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Jisasna du di hafu buléta deka nyéndékmbu rendé néma duka di waru. ");
INSERT INTO wos_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Warundaka dé Jisas deka mawuli sarékéka xékélakita dé nyan nakré hura yandéka dé dé wali dé té. ");
INSERT INTO wos_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Téndéka dé diré angi wa, “Mé xéké. Guni wuna ximbu ané nyanré yikafre huruta guni wuniré akwi guni yikafre huru. Guni wuniré yikafre huruta guni wuniré wandéka yawun duré akwi guni yikafre huru. Guna nyéndékmbu reta déka ximbu harékéhafi yakwa du, wu dé némafwi du dé.” ");
INSERT INTO wos_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Jisas wun hundi wandéka dé Jon déré wa, “Néma du, du nak ména ximbu haraki hamwinyaré wandéka di du takwana mawulimbu yaange yindaka nani xé. Dé nani wali yitaka yatakahafi yandéka nani déré watéfi, dé wun jémba yandémboka.” ");
INSERT INTO wos_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Wungi wandéka dé Jisas déré wa, “Guni déré watéfikénguni. Gunika hu hwehafi yakwa du takwa di guna sakumbu tékwa du takwa di.” Wungi dé diré wa. ");
INSERT INTO wos_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","God Jisasré déka getéfaré hura waritendéka nukwa walémbambu yandéka dé Jisas Jerusalemré yinjoka dé némafwimbu mawuli yata dé wungi yi. ");
INSERT INTO wos_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Yita duré nawulak wandéka di tale ye déka hundi hura yi. Ye di Samariana getéfa nakré wulayi, déka jondu huréhalékénjoka. ");
INSERT INTO wos_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Wulayindaka di wun getéfambu rekwa du takwa Jisas Jerusalemré yitendékaka di xékélaki. Xékélakita di dé wumbu rendéte hélék yata di wungi déka hu hwe. ");
INSERT INTO wos_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Hu hwendaka Jisasna du yéték Jems bér Jon xéta bér Jisasré wa, “Néma Du, méni mawuli yamét ani wataani, ya Godna getéfambu gaye wunde du takwaré tusandandéte. Ani wungi wanate méni mawuli ye, o yingafwe?” ");
INSERT INTO wos_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Wungi wambéka dé waleka dé bérré hambukmbu watéfi. ");
INSERT INTO wos_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Wungi wataka dé déka du wali di nak getéfaré yi. ");
INSERT INTO wos_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Jisas déka du wali yambumbu yindaka dé du nak yae déré wa, “Wuni ména hukémbu yitawuni, yiteméka atéfék hafwaré.” ");
INSERT INTO wos_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Wungi wandéka dé déré wa, “Afakana wasa di héfambu tékwa wekwambu di hwae. Afwi deka wurmbu di hwae. Wuni Duna Nyan xéndi hwatewuka ge nak téhambwe.” ");
INSERT INTO wos_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Wungi wataka dé nak duré wa, “Méni wuna hukémbu mé ya.” Wungi wandéka dé wa, “Méni yawundu namét, wuni tale ye wuna yafana fusa rémétaka bu yawu.” ");
INSERT INTO wos_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Wungi wandéka dé déré wa, “Yingafwe. Hiyandé du takwa di deka hiyandé du takwaré rémétandi. Némbuli wuni méniré wuni we. Méni sa ye atéfék getéfaré yita du takwaré wataméni, God néma du reta dika jémba hatitendékaka.” ");
INSERT INTO wos_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Wungi wandéka dé nak du Jisasré wa, “Néma Du, wuni ména hukémbu yitawuni. Méni yawundu namét, wuni tale wuna getéfaré ye wuna hémré tamba hurutaka bu yawu.” ");
INSERT INTO wos_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Wungi wandéka dé déré wa, “Du takwa di Godna jémba yanjoka hurutaka di hanja hurundan maki wambula hurunjoka sarékéta di Godna hémna jémba jémba yamba hali yanda.” Wungi dé Jisas wa. ");
INSERT INTO wos_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Hukémbu dé Jisas dumi angé tamba yétiyéti angé tamba hufuk duré waséketa dé diré wa, di yéték yéték wungi ye déka yitendéka atéfék getéfaré akwi atéfék yitendéka héfaré akwi tale yindate. ");
INSERT INTO wos_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Wungi wataka dé diré wa, “Séfélak hénoo akwe di té. Téndaka jémba yakwa du nawulak male di re. Wungi maki guni wun akwe hénoona Néma Duré wakwexékétanguni, dé wandét séfélak jémba yakwa du ye wun hénoo hérandate. ");
INSERT INTO wos_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Yak, sa guni yi. Mé xéké. Guni wawun maki wungi yita guni haraki wasana nyéndékmbu yikwa sipsip bali maki yitanguni. Di guniré haraki hurunjoka mawuli yatandi. ");
INSERT INTO wos_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Guni yéwa, wur, su akwi hura yamba yikénguni. Guni yambumbu bari yitanguni. Nawulak du takwa wali hundi bulékénguni. ");
INSERT INTO wos_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Guni geré nak wulaaye tale guni angi watanguni, ‘Godna nakélak huru mawuli ané gembu retandé.’ ");
INSERT INTO wos_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Wungi wangut nakélak huru mawuli hurukwa du nak wun gembu rendét, wangun nakélak huru mawuli démbu retandé. Nakélak huru mawuli hurukwa du nak wun gembu rehafi yandét, wangun nakélak huru mawuli gunika wambula yatandé. ");
INSERT INTO wos_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Guni tale wulayingun gembu male retanguni. Nak ge nak geré wulayikénguni. Wun gembu reta guni hwetendaka hénoo hulingu satanguni. Jémba yakwa du wungi jémba yataka deka yéwa hérandat, wu sékérékétandé. ");
INSERT INTO wos_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","“Guni getéfaré nakré wulayingut wumbu rekwa du takwa gunika yikafre mawuli yandat, guni hwetendaka hénoo satanguni. ");
INSERT INTO wos_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Guni wumbu rekwa bar hiyaakwa du takwaré huréhalékéta diré angi watanguni, ‘God néma du reta du takwaka jémba hatitendéka nukwa yae dé guni wali walémbambu dé té.’ ");
INSERT INTO wos_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","“Guni getéfaré nak wulayingut wun getéfambu rekwa du takwa gunika hélék yandat, guni ye wun getéfana yambumbu téta guni angi watanguni, ");
INSERT INTO wos_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘Guna getéfana harki nawulak nana manmbu dé hwae. Némbuli nani wun harki nani létéké, guni xe hurungun haraki saraki sémbutka xékélakingute. Guni ané jooka xékélakitanguni. God néma du reta du takwaka jémba hatitendéka nukwa yae walémbambu téndéka guni déka hu hwe.’ Wungi guni diré watanguni. ");
INSERT INTO wos_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Guniré wuni we. Hukétéfi nukwambu wun getéfambu rekwa du takwa di némafwi hangéli hératandi. Hératendaka hangéli Sodomémbu rendé du takwa hératendaka hangéliré sarékéngwandétandé.” ");
INSERT INTO wos_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","“Guni Korasinmbu rekwa du takwa, gunika saréfa wuni nae. Guni Betsaidambu rekwa du takwa, gunika saréfa wuni nae. Wuni guna getéfambu séfélak hanja xéhafi yandaka hambuk jémba yawuka guni wuna hundi xékéhambanguni. Wun wumbére hanja téndé getéfa yéték Tair bér Saidonmbu wun hambuk jémba yawut, wumbu rendé du takwa di hanjambu deka haraki saraki sémbut yatakatandi. Deka hurundan sémbutka saréfa nandakakaka wakwenjoka di nyo nukwa wur nakita bombu retandi. ");
INSERT INTO wos_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Wungi maki hukémbu God némafwi kot xékéta néma du retendéka nukwambu guni némafwi hangéli hératanguni. Hératenguka hangéli Tairmbu Saidonmbu rendé du takwa hératendaka hangéliré sarékéngwandétandé. ");
INSERT INTO wos_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Guni Kaperneamémbu rekwa du takwa, yingi guni saréké? God guniré déka getéfaré hura waritandé wana? Wu yingafwe. Guni hiyandé du takwana hafwaré nanditanguni.” ");
INSERT INTO wos_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Wun hundi wataka dé déka duré angi wa, “Guna hundi xékétekwa du takwa di wuna hundi xékétandi. Gunika hu hwetekwa du takwa di wunika hu hwetandi. Wunika hu hwekwa du takwa di wuniré wandéka gayawun Godka akwi di hu hwe.” ");
INSERT INTO wos_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Di wungi ye déka hundi wataka hukémbu wunde dumi angé tamba yétiyéti angé tamba hufuk du di wambula yae di yandan jémbaka yikafre mawuli ya. Mawuli yata di Jisasré wa, “Néma Du, nani ména ximbu wambeka di haraki hamwinya akwi nana hundi xéka wamben maki huru.” ");
INSERT INTO wos_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Wungi wandaka dé diré wa, “Guni wungi yinguka wuni xé, Satan nyirmbu gayandéka, nyir tulem nandéka maki. ");
INSERT INTO wos_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Mé xéké. Wuni gunika hambuk wundé hwewu, guni hambweré akwi hularé akwi xakingut, di guniré haraki hurundamboka. Hwewun hambuk Satanéna atéfék hambukré sarékéngwandétandé. Sarékéngwandéndét, joo nak guniré haraki yamba hurukéndé. ");
INSERT INTO wos_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Wun jooka sarékékénguni. Guni atéfék haraki hamwinya guna hundi xékéndakaka yikafre mawuli yamba yakénguni. Guni God guna xi déka getéfambu rekwa nyingambu hayindénka male yikafre mawuli yata mawuli sawuli yatanguni.” Wungi dé Jisas diré wa. ");
INSERT INTO wos_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Wun nukwa dé Jisas Godna Hamwinyambu dé némafwimbu mawuli sawuli yata dé wa, “Wuna yafa, méni nyir akwi héfaka akwi méni néma du re. Méni ané jondu fakuméka di jémba xékélakikwa du takwa akwi xékélelakikwa du takwa akwi di wun jonduka xékélakihambandi. Xékélakihafi yandaka méni ramunya maki du takwaré wun jonduka wakwe. Yafa, méni mawuli yaméka maki méni wungi wakwe. Wakweménka wuni ména ximbu wuni haréké.” ");
INSERT INTO wos_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Wungi Godré wataka dé wa, “Wuna yafa dé atéfék jondu wuna tambambu taka. Wuni déka nyan rewuka di du takwa wunika xékélakihambandi. Dé male dé wunika xékélaki. Du takwa di yafaka xékélakihambandi. Wuni male wuni déka xékélaki. Déka wakwewun du takwa akwi di déka xékélaki.” ");
INSERT INTO wos_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Wun hundi wataka waleka dé déka duré male wa, “Guni séfélak jondu xéngun, guna dama yikafre mawuli yatandi. ");
INSERT INTO wos_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Guniré wuni we. Hanja séfélak profet akwi séfélak néma du akwi di xénguka jonduré xénjoka mawuli yata di xéhambandi. Xéhafi yata di xékénguka hundi xékénjoka mawuli yata di xékéhambandi.” ");
INSERT INTO wos_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Wun hundi wandéka dé hambuk hundika xékélakikwa du nak dé raama téta dé Jisasré hurukwexénjoka dé déré wa, “Wakwekwa du, wuni méta jémba yatawuni, huli mawuli hérae wungi re wungi re jémba renjoka?” ");
INSERT INTO wos_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Wungi wandéka dé déré wa, “Méta hundi Moses wandén hambuk hundimbu dé re? Hayindén hundika yingi méni saréké?” ");
INSERT INTO wos_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Wungi wandéka dé wa, “Guni guna mawulimbu, guna hamwinyambu, guna hambukmbu, guna mawuli sarékémbu guni Néma Du Godka némafwimbu mawuli yatanguni. Mawuli yata guni guna nyémayikaka némafwimbu mawuli yatanguni, guni hafuka némafwimbu mawuli yanguka maki.” ");
INSERT INTO wos_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Wungi wandéka dé déré wa, “Wu yawundu. Jémba méni wa. Méni wungi huruta méni huli mawuli hérae wungi re wungi re jémba retaméni.” ");
INSERT INTO wos_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Jisas wungi wandéka wun du dé du takwana makambu yikafre sémbut hurukwa du renjoka mawuli yata dé Jisasré wakwexéké, “Wuna nyémayika héndé?” ");
INSERT INTO wos_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Jisas déka hundi hasa wanjoka dé ané hundi wa, “Du nak Jerusalem yatakataka dé Jerikoré nandinjoka yambumbu yi. Yindéka di sélé héraakwa du déré yambumbu huluke di déka jondu déka atéfék nukwa wur akwi héraata di déré hambukmbu xiya. Xiyataka yindaka dé yambumbu hiyanjoka huruta dé hwa. ");
INSERT INTO wos_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Hwandéka dé wun nukwa pris nak dé wun yambumbu yi. Ye wun duré xétaka yambuna angé sakumbu yita déré tenangéra dé yi. ");
INSERT INTO wos_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Yindéka dé Livaina hémna du nak ye dé wun du hwandénmbu xaakwa déré xétaka dé akwi angé sakumbu ye déré tenangéra dé yi. ");
INSERT INTO wos_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Yindéka dé Samariana du nak dé afaké téfaré yinjoka dé wun yambumbu ye dé wun du hwandénmbu xaku. Xaakwa wun duré xéta dé déka saréfa na. ");
INSERT INTO wos_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Saréfa naata dé déka ye xiyandan wasiré wain hulingumbu akwi wel hulingumbu akwi yakwanyitaka dé gi. Gitaka dé wun duré hérae déka donkimbu takandéka dé re. Rendéka dé yambumbu yita dé yéwa hweta hwandaka ge nakré déré hura ye dé wumbu déré yikafre huru déka hati. ");
INSERT INTO wos_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Gan hwae ganémba yita yéwa nawulak wun gena yafaka hweta dé déré wa, ‘Méni ané duka jémba mé hati. Hatita wun duka jondu nawulak héranjoka ména yéwa nawulak akwi hwemét, wuni wambula yatewuka nukwambu wuni ména yéwa hasa hwetawuni.’ Wungi wataka dé yi. ");
INSERT INTO wos_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","“Némbuli yingi méni saréké? Du hufuk di wun yambumbu yi. Héndé sélé héraakwa du xiyandan duna nyémayika dé?” ");
INSERT INTO wos_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Wungi wandéka dé wa, “Déka saréfa naata déré yikafre hurundé du dé.” Wungi wandéka dé déré wa, “Méni sa ye wungi male huru.” Wungi dé Jisas wa. ");
INSERT INTO wos_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Nak nukwa Jisas déka du wali yambumbu ye di getéfa nakré wulayi. Wulayindaka lé takwa hési léka xi Marta lé Jisasré wa, dé yae léka gembu hénoo sandéte. ");
INSERT INTO wos_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Waléka wulaaye rendéka lé léka bandi Maria yae lé Néma Du Jisasna man mombu reta lé déka hundi xéké. ");
INSERT INTO wos_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Xékéléka lé Marta séfélak hénoo humbwinjoka lé némafwi jémba yata lé déka hundi xékéhambalé. Xékéhafi yaléka Maria baka reléka lé Marta Jisaska yae lé déré wa, “Néma Du, wuna bandi baka reléka wuni hafu hénoo humbwiwukaka méni saréké wana? Méni léré wamét lé yae wuni wali hénoo humbwitaani.” ");
INSERT INTO wos_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Wungi waléka dé Néma Du léré wa, “Marta, Marta, nyéni séfélak jonduka nyéni saréké waréké. ");
INSERT INTO wos_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Nyéni natafa male joo hurunyét, wu yikafre dé. Maria wun yikafre joo héranjoka lé mawuli ye. Mawuli yaléka joo lémbu téndét, yamba hérekikéndi.” Wungi dé Jisas Martaré wa. ");
INSERT INTO wos_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Nak nukwa Jisas nak hafwambu dé God wali hundi bulé. Hundi buléséketaka rendéka dé déka du nak yae dé déré wa, “Hanja guré husandakwa du Jon dé déka duré wakwe, Godré wakwexékétendakangalaka. Diré wakwendén maki méni naniré wakwetaméni.” ");
INSERT INTO wos_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Wungi wandéka dé déré wa, “Guni Godré wakwexékénjoka mawuli yata angi watanguni: Nana yafa, nani ména yikafre ximbu harékénjoka nani mawuli ye. Méni néma du reta atéfék du takwaka jémba hatiméte nani mawuli ye. ");
INSERT INTO wos_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Atéfék nukwana satembeka hénoo hweméte nani méniré wakwexéké. ");
INSERT INTO wos_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Du takwa naniré haraki saraki sémbut hurundaka nani diré hasa hwehafi yata wun jooka wambula sarékéhambame. Sarékéhafi yambet méni hurumben haraki saraki sémbut yakwanyita wun jooka wambula sarékékéméni. Méni naniré yikafre hurumét naniré hurukwexékwa joo nanika yamba yakéndé. Wungi nani méniré wakwexéké.” ");
INSERT INTO wos_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Wungi wataka dé diré angi wa, “Wafewana guna du nak angi hurutandé? Dé nyéndék gan déka gembu hwandéka déka nyayika nak yae angi watandé, ‘Wuna nyayika, wunika hénoo nawulak hwetaméni. ");
INSERT INTO wos_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","Némbule wuna nyayika nak dé nak getéfaré yinjoka dé wunika yandéka wuni déka hwetewuka hénoo nawulak yingafwe. Méni wunika hénoo nawulak hwemét, wuni hukémbu hasa hwetawuni.’ ");
INSERT INTO wos_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Wungi wandét dé awula gekombu hwandé du watandé, ‘Némbuli wun jooka wuniré yamba wakéméni. Gena yambu wundé téfiwu. Wuna nyangwal wuni wali xéndi di hwae. Némbuli wuni raama ménika hénoo yamba hwekéwuni.’ Wungi watandé. ");
INSERT INTO wos_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Guniré wuni we. Dé ‘Wuna nyayika’ naata male, dé raama hénoo déka yamba hwekéndé. Wun du wumbu téta wambula wambula wandét, dé raama wun du mawuli yandéka hénoo atéfék déka hwetandé. ");
INSERT INTO wos_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","“Guniré wuni we. Guni wakwexékéngut, dé gunika hwetandé. Guni hwaka hwaka xétanguni. Guni gena yambumbu xiyaata téngut, dé gena yambu nafwitandé. ");
INSERT INTO wos_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Atéfék wakwexékékwa du takwa hératandi. Atéfék hwakékwa du takwa xétandi. Atéfék gena yambumbu xiyaakwa du takwaka dé gena yambu nafwitandé. ");
INSERT INTO wos_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","“Ané hundi akwi mé xéké. Guni yafa, guna nyan xéri hamwi hwengute wandét, guni hambwe déka hwetanguni wana? Wu yingafwe. Guni déka xéri hamwi hwetanguni. ");
INSERT INTO wos_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Guna nyan séra gék hwengute wandét guni hula déka hwetanguni wana? Wu yingafwe. Guni séra gék male déka hwetanguni. ");
INSERT INTO wos_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Némbuli mé saréké. Guni haraki saraki sémbut hurukwa du reta guni guna nyangwalka yikafre jondu hwenjoka guni xékélaki. Wungi maki guna anwarmbu rekwa yafa guniré sarékéngwanda dé déka Hamwinya hwetandé, déré wakwexékékwa du takwaka.” Wungi dé diré wa. ");
INSERT INTO wos_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Nukwa nak Jisas dé haraki hamwinya nakré wa, dé hura téndén duré yatakataka yindéte. Wun haraki hamwinya dé hundi buléhafindé. Jisas wungi wandéka dé wun duré yatakataka yaange yindéka dé hundi buléhafi yandé du dé hundi bulé. Buléndéka di du takwa wun jooka saré waréké. ");
INSERT INTO wos_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Saré warékéndaka di du nawulak wa, “Atéfék haraki hamwinyana néma du Belsebul Jisasna mawulimbu téndéka dé Jisas wungi wa, di haraki hamwinya yaange yindate.” ");
INSERT INTO wos_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Wungi wandaka nawulak di déré hurukwexénjoka di déré wa, “Méni hanja xéhafi yamben hambuk jémba nak yamét, nani xéta xékélakitame, God déka jémba yaméte méniré wandénka.” ");
INSERT INTO wos_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Wungi wandaka Jisas deka mawuli xékélakita dé diré wa, “Néma getéfambu rekwa du watémbéra hémémbu hémémbu reta wareta di jémba yamba rekéndi. Deka héfa baka héfa xakutandé. Natafa gembu rekwa du takwa watémbéra di hafu wali wareta di akwi jémba yamba rekéndi. ");
INSERT INTO wos_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Wungi maki Satan déka du wali wungi watémbéra wareta, yingi maki nae di hambuk yata jémba tétandi? Wu yingafwe. Guni wuniré wangun maki Belsebul déka haraki hamwinya yaange yindate wandét, di atéfék jémba yamba tékéndi. ");
INSERT INTO wos_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Wuni haraki hamwinya yaange yindate Belsebulna hambukmbu wawut, méta hambukmbu di guna dunya nawulak wa, haraki hamwinya yaange yindate? Wungi maki di hurungun sémbutka kot xékékwa néma du retandi. ");
INSERT INTO wos_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Mé xéké. God wunika hambuk dé hwe, wuni haraki hamwinyaré wawut di yaange yindate. Hwendénka guni angi xékélakitanguni. God néma du reta du takwaka jémba hatitendéka nukwa gunika wundé yandé. ");
INSERT INTO wos_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","“Ané hundi mé xéké. Hambuk yakwa du xi warekwa jondu hura déka geka hatindét, déka jondu atéfék jémba retandé. ");
INSERT INTO wos_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Wun du angi dé saréké, ‘Wuna xi warekwa jondu wuniré yikafre hali hurundé, wuni jémba rewute.’ Wungi sarékéndéka hukémbu némafwi hambuk yakwa du nak yae wun du wali ware déré sarékéngwanda dé déka xi warekwa jondu atéfék akwi hérae déka jondu akwi hérae dé wun jondu nak duka mune hwetandé. ");
INSERT INTO wos_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","“Wuni wali jémba yahafi yakwa du takwa di wuna mama di. Wuni du takwaré hérawuka di wuni wali di té. Wuni wali sékéré hérahafi yakwa du di wuna du takwaré héle nambwe yakindaka di yi.” ");
INSERT INTO wos_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Wun hundi wataka dé Jisas diré angi wa, “Ané hundi mé xéké. Haraki hamwinya nak duna mawuli yatakataka ye dé wali giyahafi yakwa hafwambu yitaka yatakata reséto hafwaka dé hwaké. Hwakéfatika dé wa, ‘Wuni hanja rewun geré wambula yitawuni.’ ");
INSERT INTO wos_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Wungi wataka wambula yae dé xé, wun ge hafwa yaka hutaféka takandéka téndéka. ");
INSERT INTO wos_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Xétaka ye dé haraki hamwinya angé tamba yétiyéti angé tamba hufukré hura ya. Hura yandén haraki hamwinya di némafwi haraki saraki sémbut hurundaka deka sémbut dé tale yandé haraki hamwinyana haraki sémbutré dé sarékéngwandé. Wunde haraki hamwinya atéfék di wun duna mawuliré wulaaye té. Wun du hukémbu hérandén xak dé tale hérandén xakré sarékéngwandé.” ");
INSERT INTO wos_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Jisas wun hundi wata téndéka di séfélak du takwa dé wali téndaka lé takwa hési deka nyéndékmbu téta lé hambukmbu wata lé angi déré wa, “Hanja méniré hérae ménika munya hwelé takwaré dé God yikafre huru, lé yikafre mawuli yata jémba reléte.” ");
INSERT INTO wos_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Wungi waléka dé Jisas wa, “Wun jooka sarékéhafi yata ané jooka mé saréké. Godna hundi xékéta wandén maki hurukwa du takwaré God némafwimbu yikafre hurutandé, di yikafre mawuli yata jémba male rendate.” Wungi dé Jisas wa. ");
INSERT INTO wos_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Séfélak du takwa akwi yae hérangwandéndaka dé diré angi wa, “Ané nukwambu rekwa du takwa di haraki saraki sémbut hurukwa du takwa di. Wuniré di wakwexéké, wuni hanja xéhafi yandan hambuk jémba yawute. Wakwexékéndaka wuni ané hanja xéhafi yandan hambuk jémba male yatawuni. Hanja Jona dé xéhafi yandan hambuk jémba nak dé ya. Wuni Jona yandén maki male yatawuni. ");
INSERT INTO wos_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Hanja Ninivembu rekwa duna makambu dé Jona hanja xéhafi yandan hambuk jémba maki dé xaku. Wungi male wuni Duna Nyan ané nukwambu rekwa du takwana makambu hanja xéhafi yandan hambuk jémba maki xakutawuni. ");
INSERT INTO wos_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Hanja sautna sakumbu téndé héfana néma takwa lé néma du Solomonéna xékélelaki hundi xékénjoka lé afaké téfambu ya. Mé xéké, némbuli rekwa joo dé Solomonré sarékéngwandé. Wungi maki hukémbu God némafwi kot xékékwa néma du retendéka nukwa wule néma takwa raama Godna makambu téta lé guni némbuli rekwa duré haraki hundi watalé, hurungun haraki saraki sémbutka. ");
INSERT INTO wos_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Hanja Ninivembu rendé du takwa di Jona wandén Godna hundi xékétaka di hurundan haraki saraki sémbut di yataka. Mé xéké. Némbuli rekwa joo dé Jonaré sarékéngwandé. Wungi maki hukémbu God némafwi kot xékékwa néma du retendéka nukwambu di Ninivembu rendé du di Godna makambu téta di guni némbuli rekwa du takwaré haraki hundi watandi, hurungun haraki saraki sémbutka.” ");
INSERT INTO wos_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Wun hundi wataka dé diré angi wa, “Du hanyikwa ya xéréka hura yae di gena fakundén hafwambu takahafindi. Di aki ekombu akwi takahafindi. Di jambé takumbu di taka, wun geré wulayindé du takwa jémba xéndate. ");
INSERT INTO wos_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Guna dama wu guna séfina hanyikwa ya maki dé. Guna dama jémba téndét, guna séfi atéfék larékombu retandé. Guna dama haraki téndét, guna séfi atéfék halékingambu retandé. ");
INSERT INTO wos_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Guni guna séfimbu reta hanyikwa ya haléki maki téndémboka guni xékélaki natanguni. ");
INSERT INTO wos_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Wungi maki wun ya guna séfimbu jémba haanye téndét, guna séfina jondu atéfék halékingambu rehafi yata atéfék larékombu rendat, guna séfi wun larékombu jémba male retandé, guni yikafre hanyikwa yana larékombu jémba renguka maki.” ");
INSERT INTO wos_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Jisas wun hundi wataka téndéka dé Farisina du nak déré wa, dé yae dé wali hénoo sandéte. Wandéka dé yae déka geré wulaaye dé wali sanjoka dé re. ");
INSERT INTO wos_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Wun nukwa Farisina sémbut angi dé, di sanjoka di tale deka tamba yakwanyi. Jisas hénoo sanjoka déka tamba yakwanyihafi yandéka dé Farisina du xe dé waréngéné. ");
INSERT INTO wos_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Waréngénéndéka dé Néma Du Jisas déré wa, “Ané nukwa guni Farisi guni andéna hafwasaku akwi hanyandéna hafwasaku akwi guni yakwanyi. Guna takésakumbu sélé héranguka sémbut akwi haraki saraki sémbut akwi dé gunimbu sukweka té. ");
INSERT INTO wos_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Guni wangété du guni. Guna hafwasakumbu huratakandén God dé guna takésaku akwi dé hurataka. ");
INSERT INTO wos_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Guni wun takésakumbu rekwa jondu jambangwe du takwaka hwetanguni. Hwengut guna jondu atéfék Godna makambu yikafre retandi. ");
INSERT INTO wos_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","“Guni Farisina du, gunika wuni saréfa nae. Guni guna yawimbu hérangun atéfék nyaa mune guni tamba yétina també nak Godka hwe. Guni wungi hweta guni ambére yikafre sémbut yétékéka sarékéhambanguni. Guni du takwaré yikafre sémbut huruhafi yata guni Godka némafwimbu mawuli yahambanguni. Guni Godka jondu hweta wumbére némafwi yikafre sémbut akwi hurungut, wu yikafre dé. ");
INSERT INTO wos_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","“Guni Farisina du, gunika wuni saréfa nae. Guni Godna hundi buléndaka geré wulaaye guni néma duna hafwambu renjoka guni némafwimbu mawuli ye. Guni maketmbu yitaka yatakangut, du takwa guna ximbu harékéta gunika dinguna nandate guni némafwimbu mawuli ye. ");
INSERT INTO wos_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","“Gunika saréfa wuni nae. Guni fakundén hwandafu maki guni. Hukémbu du takwa wun hwandafu takumbu féta ye di andélambu rekwa haraki jooka xékélakihambandi.” ");
INSERT INTO wos_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Jisas wun hundi wandéka dé hambuk hundika xékélakikwa du nak dé déré wa, “Wakwekwa du, méni wungi wata naniré akwi méni haraki hundi we.” ");
INSERT INTO wos_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Wungi wandéka dé angi wa, “Guni hambuk hundika xékélakikwa du, gunika akwi wuni saréfa nae. Guni du takwaka némafwi xak jondu guni hwe, di wun jondu yatandate. Hwenguka di wesékéta yatandaka guni hafu guna sék tambambu wun xak jondu séngétakahafinguni, di wali wun jondu yatanjoka. ");
INSERT INTO wos_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","“Gunika wuni saréfa nae. Hanja guna mandéka di Godna profetré xiyandaka di hiya. Hiyandaka guni réméndan hwandafumbu ge maki joo to. ");
INSERT INTO wos_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Guna mandéka xiyae réméndan duna hafwambu wungi ge maki joo tongunka nani xékélaki. Guni guna mandékanguna sémbutka xékélakita wun sémbutka guni yawundu na. ");
INSERT INTO wos_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Wun moka dé xékélelakikwa God dé wa, ‘Wuni profetré akwi aposelré akwi watawuni, dika yindate. Yindat nawulakré haraki huruta nawulakré xiyandat hiyatandi. ");
INSERT INTO wos_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Wungi hurundat, wuni atéfék profetna blekéndan nyékika sarékéta némafwi kotna néma du reta diré hasa hwetawuni. Ané héfa huratakawun nukwambu blekéndan nyéki akwi hukémbu blekéndan nyéki akwi atéfék diré hasa hwetawuni. ");
INSERT INTO wos_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Tale Kein déka bandi Abelré xiyandéka déka nyéki dé bleké. Xiyandéka di guna mandéka di Sekaraiaré xiyandaka déka nyéki dé bleké. Sekaraia dé Godna gena nyéndékmbu téndéka di déré wungi xiya. Guniré wuni we. God blekéndan nyéki atéfékéka sarékéta guni ané nukwa rekwa du takwaré hambukmbu hasa hwetandé. ");
INSERT INTO wos_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","“Guni hambuk hundi xékélakikwa du, gunika wuni saréfa nae. Guni Godka xékélakindaka yambuna ki guni héreki. Hérekitaka guni hafu wun yambumbu wulayihambanguni. Wulayihafi yata guni wun yambumbu wulayinjoka mawuli yakwa du takwaré guni haraki huru, di wulayindamboka.” Wungi dé Jisas wa. ");
INSERT INTO wos_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","54","Wataka yindéka di xékélelakikwa du akwi Farisina du akwi di déka némafwimbu hélék yata di hafu buléta di wa, “Wafewana dé nana hundi hasa wanjoka dé haraki saraki hundi nawulak watandé? Wandét nani déré duna makambu takatame.” Wungi wata di séfélak xak hundika déré wakwexéké. ");
INSERT INTO wos_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Wun nukwambu séfélak séfélak du takwa yae hérangwanda téndaka dé hafwa sukweké. Sukwekéndéka nawulak di nawulak duna manmbu xaki. Xakindaka dé Jisas déka duré tale ané hundi wa, “Xékélaki natanguni. Farisina duna yis hurukénguni. Deka yiska wata wuni deka yéna yandaka sémbutka wuni wa. ");
INSERT INTO wos_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","God némbuli faakwa téfindan joo atéfék wakwetandé. Atéfék nakélak wandan hundika hukémbu séfélak du takwa xékélakitandi. ");
INSERT INTO wos_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Wungi maki, guni gan reta hundi buléngut, hukémbu du takwa nukwana larékombu téta wun hundi xékétandi. Guni gekombu reta hundi nakélak buléngut, hukémbu di gena takumbu téta wun hundi hambukmbu watandi.” ");
INSERT INTO wos_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","“Wuna nyayikangu, guniré wuni we. Guni hiyangute guna séfiré xiyaakwa duka rookénguni. Di guniré xiyandat guni hiyangut hukémbu di guniré haraki hurunjoka hurufatikétandi. ");
INSERT INTO wos_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Guni ané duka male rootanguni. Guni Godka male rootanguni. Dé guniré xiyandét, guni hiyangut, dé guniré ya yanékwa hafwaré yakisandanjoka dé hali hurundé. Wun jooka sarékéta guni déka rootanguni. ");
INSERT INTO wos_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","“Guni xékélaki. Du takwa yikama yéwa yéték hwetaka di yikama afwi natamba héra. Wun afwi wun yikama joo male rendaka God di atéfékéka dé saréké. ");
INSERT INTO wos_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Wungi maki dé gunika akwi sarékéta dé guna anéngambambu tékwa némbé atéfék handékéna dé di atéfékéka dé xékélaki. Godna makambu di afwi yikama joo rendaka nani du takwa néma joo nani re. Wun jooka sarékéta yamba rookénguni.” ");
INSERT INTO wos_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","“Guniré wuni we. Du nak dé duna makambu téta angi wandét, ‘Wuni Jisasna du wuni.’ Wungi wandét, hukémbu wuni Duna Nyan Godna enselna makambu téta wuni déka angi watawuni, ‘Ané du wuna du dé.’ Wungi watawuni. ");
INSERT INTO wos_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Du nak dé duna makambu téta angi wandét, ‘Wuni Jisasna du yingafwe.’ Wungi wandét wuni Godna enselna makambu téta wuni déka angi watawuni, ‘Wun du wuna du yingafwe.’ Wungi watawuni déka. ");
INSERT INTO wos_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","“Du takwa di duna nyanka haraki hundi wandat, God wun haraki saraki sémbut yakwanyitandé. Di Godna Hamwinyaka haraki hundi wandat, God wun haraki saraki sémbut yamba yakwanyikéndé. ");
INSERT INTO wos_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","“Du nawulak guniré Godna hundi buléndaka gembu rekwa duré akwi, néma duré akwi, gavmanéna duré akwi hura yindat, guni deka makambu téta, guni roohafi yata watenguka hundika akwi deka hundi hasa watenguka hundika akwi yamba sarékékénguni. ");
INSERT INTO wos_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Wun nukwa male Godna Hamwinya watenguka hundi guniré wakwetandé. Wun jooka sarékéta yamba rookénguni.” Wungi dé diré wa. ");
INSERT INTO wos_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Jisas wali séfélak du takwa di té. Di wali téndé du nak dé Jisasré wa, “Wakwekwa du, méni wuna nyamaré wamét dé ana yafana jondu mune dé wunika nawulak hwetandé. Wungi wuni mawuli ye.” ");
INSERT INTO wos_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Wungi wandéka dé Jisas wa, “Héndé wa, wuni bénika kot xékékwa du maki rewute?” ");
INSERT INTO wos_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Wungi wataka dé diré wa, “Guni xékélaki natanguni. Guni nak duna jondu akwi séfélak jondu akwi héranjoka yamba sarékékénguni. Du nak dé séfélak jondu hérandét, wun jondu déka mawuliré yikafre hurunjoka dé hurufatikétandé. Du takwa huli mawuli hérae jémba renjoka, di jondu héranjoka yamba sarékékéndi.” ");
INSERT INTO wos_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Wungi wataka dé diré sataku hundi nak angi wa, “Xérénjuwi mama du nak déka yawimbu dé séfélak yikafre hénoo wara dé té. ");
INSERT INTO wos_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Téndéka dé xérénjuwi mama du déka mawulimbu dé wa, ‘Wuna hénoo taka ge séfélak yingafwe. Némbuli métaki yakéwuni?’ ");
INSERT INTO wos_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Wungi sarékéta dé wa, ‘Némbuli angi hurutawuni. Wuni hénoo taka ge atéfék glarétaka némafwi huli ge totawuni. Totaka atéfék hénoo nawulak jondu akwi wuni wumbu takatawuni. ");
INSERT INTO wos_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Take wuni wuna hamwinyaré watawuni: Hamwinya, méni séfélak yikafre jondu wundé takamé, séfélak héki hwari baka renjoka. Wungi maki némbuli ambu resétota, hénoo hulingu sata mawuli sawuli yataméni. Wungi watawuni. ");
INSERT INTO wos_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Wun du wungi wandéka dé God déré wa, ‘Méni wangété du méni. Némbuli gan hwae hiyataméni. Hiyamét takamén jondu héndé hérate?’ Wungi dé God déré wa. ");
INSERT INTO wos_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Du takwa di ané héfambu séfélak jondu héraata Godna getéfambu yikafre jondu takahafi ye, di wun du maki retandi.” ");
INSERT INTO wos_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Wun hundi wataka dé Jisas déka duré wa, “Wun jooka sarékéta wuni guniré we. Guni ané héfambu rengukaka, guna satenguka hénooka akwi guna séfimbu sandatenguka nukwa wurka akwi yamba saréké warékékénguni. ");
INSERT INTO wos_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Guni wungi renjoka mawuli yata guni hénooka male yamba sarékékénguni. Guni guna séfimbu jémba renjoka mawuli yata guni nukwa wurka male yamba sarékékénguni. ");
INSERT INTO wos_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Guni hwanyi afwika mé xé. Di hénoo sehambandi. Di hénoo hérae takahambandi. Di hénoo takandaka ge yingafwe. Wungi huruhafi yandaka God dé dika hénoo hwe. Godna makambu afwi di yikama joo rendaka guni némafwi joo maki guni re. Wu mwi hundi dé. ");
INSERT INTO wos_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Mé xéké. Guna du nak héki hwari nawulak akwi renjoka saré waréké xékéta dé wataka héki hwari nawulak akwi renjoka hambuk yatandé wana? Wu yingafwe. Dé hafu wataka héki hwari nawulak akwi renjoka hurufatikétandé. ");
INSERT INTO wos_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Guni wun yikama joo hurunjoka hurufatikéta métaka guni nak jooka guni saré waréké xéké? Wungi sarékékénguni. ");
INSERT INTO wos_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","“Guni mawe waréndakangalaka mé saréké. Di jémba yahafi yata nukwa wur hundafanéhambandi. Wungi huruhafi yata deka sandandan nukwa wur dé yikafre male dé. Hanja rendé néma du Solomon dé némafwi hambuk héraata séfélak jondu hérandéka dé déka yikafre nukwa wur dé mawena nukwa wur maki yingafwe. Mawena nukwa wur dé Solomon sandandén yikafre nukwa wurré sarékéngwanda dé yikafre male dé. ");
INSERT INTO wos_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Wunde mawe di nawulak nukwa male retaka bari hiyandaka di du takwa diré hérae yambu tutandi. God wun bari hiyatekwa maweka wungi nukwa wur hweta dé méta yatandé, gunika hatinjoka. Dé gunika akwi nukwa wur hweta gunika jémba hatitandé. Wungi maki métaka guni Godka jémba sarékéhafi ye? ");
INSERT INTO wos_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Guni satenguka hénoo, satenguka hulinguka akwi hwakéhafi yata wun jooka wambula saré warékékénguni. ");
INSERT INTO wos_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Atéfék héfambu rekwa du takwa di wun jondu héranjoka saréké warékéndaka dé guna yafa dé fatikéngun jonduka dé xékélaki. ");
INSERT INTO wos_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Guni wun jonduka sarékéhafi yata guni God néma du reta du takwaka hatitendéka nukwa xakundéte némafwimbu mawuli yatanguni. Wungi mawuli yangut, dé gunika wun jondu hwetandé.” ");
INSERT INTO wos_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","“Guni, wuna du, guni yikama hém sipsip bali maki renguka guna yafa gunika yikafre mawuli yata dé guniré waséke, guni déka hémémbu rengut dé néma du reta gunika jémba hatinjoka. Gunika hatindékaka sarékéta guni yamba rookénguni. ");
INSERT INTO wos_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Guni guna jondu hweta yéwa hérae jambangwe du takwaka hwetanguni. Wungi hweta guni haraki yahafi yakwa jondu héranjoka sarékétanguni. Wun jondu dé Godna getéfambu reta dé haraki yamba yakéndé. Sélé héraakwa du wun jondu yamba hérakéndé. Tétémbér wun jondu yamba sakéndé. ");
INSERT INTO wos_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Guna mawuli guna takangun yikafre jondu rendén hafwambu male tétandé.” ");
INSERT INTO wos_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","“Mé xéké. Guni guna nukwa wur jémba sandataka guna hanyikwa ya jémba hurutanguni, guna néma du wambula yandét, guni jémba ténjoka. ");
INSERT INTO wos_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Guni ande du maki hurutanguni. Deka néma du dé takwa hératekwa du wali némafwi hénoo sanjoka dé yi. Yindéka di jémba yakwa du di jémba haxéta té, deka néma du wambula yae yambumbu xiyandét, di bari yambu nafwinjoka. ");
INSERT INTO wos_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Deka néma du wambula yandét, déka jémba yakwa du di déka haxéta huli re, wu wunde jémba yakwa du yikafre mawuli yata mawuli sawuli yatandi. Mwi hundi wuni guniré we. Deka néma du dika yikafre mawuli yata dé hafu jémba yakwa duna nukwa wur sandataka dé diré watandé, di hénoo sanjoka jambémbu rendate. Wandét rendat dé yae dika hénoo hwetandé, di jémba sandate. ");
INSERT INTO wos_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Dé nyéndék gan néma gan wambula yae di déka jémba haxéndat xéndét, di yikafre mawuli yatandi. ");
INSERT INTO wos_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","“Guni ané hundika mé saréké. Gena yafa sélé héraakwa du yatendéka nukwaka xékélakita dé wun nukwa déka geka jémba hatitandé, di déka geré haféka wulayindamboka. ");
INSERT INTO wos_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Guni akwi, guni jémba haxéta retanguni. Wuni Duna Nyan, wuni xékélakihafi yatenguka nukwambu wambula yatawuni.” ");
INSERT INTO wos_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Jisas wungi wandéka dé Pita wa, “Néma Du, nanika male sarékéta méni wun sataku hundi wa wana atéfék du takwaka méni wa wana?” ");
INSERT INTO wos_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Wungi wandéka dé Néma Du angi wa, “Jémba sarékéta yikafre jémba yata geka hatikwa du angi hurutandé. Déka néma du déré angi watandé, ‘Méni wuna jémba yakwa duka hatita satendaka nukwambu dika hénoo hwetaméni.’ Wungi wataka yindét dé wungi hurutandé. ");
INSERT INTO wos_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Hurundét hukémbu déka néma du wambula yae xéndét, dé yikafre mawuli yata jémba retandé. ");
INSERT INTO wos_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Mwi hundi wuni guniré we. Déka néma du yikafre mawuli yata déré watandé, dé déka atéfék jondu hatindéte. ");
INSERT INTO wos_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Haraki mawuli yata haraki jémba yakwa du déka mawulimbu angi watandé, ‘Wuna néma du nak getéfaré ye séfélak nukwambu wumbu retandé. Dé bari wambula yamba yakéndé.’ Wungi wataka dé jémba yakwa du takwaré xiyae séfélak hénoo sata, wangété yandaka hulingu sata, wangété yatandé. ");
INSERT INTO wos_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Yata déka néma du wambula yatendékaka sarékéhafi yandét wun nukwa déka néma du wambula yatandé. Xékélakihafi yatendéka nukwa wambula yatandé. Yae hurundén sémbutré xe déré tambémbu tambémbu xatékéndét hiyatandé. Hiyae dé Godka sarékéhafi yandé du takwana hafwambu retandé. ");
INSERT INTO wos_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","“Déka néma du mawuli yandéka jémbaka xékélakindé du, dé jémba haxéhafi yata wun jémba yahafi yandét, déka néma du wandét di déré séfélak yambu xiyatandi. ");
INSERT INTO wos_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Déka néma du mawuli yandéka jémbaka xékélakihafi yandé du, dé haraki sémbut nawulak hurundét, déka néma du wandét, di déré yéték hufuk yambu xiyatandi. God séfélak jondu hwendén du takwaré watandé, di séfélak jondu hasa hwendate. God du takwa nawulakéka dé séfélak jondu hwe, di wun jonduka hatindate. God wunde du takwaré watandé, wun jondu nawulak akwi hasa hwendate.” Wungi dé Jisas diré wa. ");
INSERT INTO wos_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Wataka dé diré wa, “Wuni ya ané héfaré yakinjoka wuni ya. Wun ya némbule hénjarandéte wuni mawuli ye. ");
INSERT INTO wos_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Tale nak maki guré nanditawuni. Guré nanditewukaka wuna mawuli némafwimbu xak dé ye. Nanditaka wambula jémba retawuni. ");
INSERT INTO wos_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Yingi guni saréké? Atéfék héfambu rekwa atéfék du takwa warehafi yata jémba rendate wuni ya, o yingafwe? Wu yingafwe. Du takwa watémbéréta hémémbu hémémbu rendate wuni ya. ");
INSERT INTO wos_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Guniré wuni we. Ané nukwa akwi hukémbu akwi natamba du takwa nak gembu reta di watémbéra retandi. Hufuk angé sakumbu téndat, yéték angé sakumbu tétandi. Yéték angé sakumbu téndat, hufuk angé sakumbu tétandi. ");
INSERT INTO wos_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Yafa déka dunya wali waretambér. Nyan déka yafa wali waretambér. Ayiwa léka takwanya wali waretambér. Nyan léka ayiwa wali waretambér. Yo léka miyanyi wali waretambér. Miyanyi léka yo wali waretambér.” Wungi dé Jisas wa. ");
INSERT INTO wos_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Wun hundi wataka dé dé wali téndé séfélak du takwaré wa, “Guni némafwi wali géli waréndéka xéta xékélakita guni wa, ‘Némbuli wali giyatandé.’ Wungi wanguka dé wali giya. ");
INSERT INTO wos_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Guni gan séfélak hunkwariré xéta xékélakita guni wa, ‘Séri némafwi nukwa xétandé.’ Wungi wanguka dé némafwi nukwa xé. ");
INSERT INTO wos_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Guni yéna yakwa du takwa guni. Guni nyirmbu xakukwa jondu héfambu xakukwa jondu xéta guni xékélaki. Wali giyatandé. Nukwa xétandé. Wungi xékélakita métaka guni ané nukwambu xakukwa jonduka xékélakihafi ye? ");
INSERT INTO wos_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","“Métaka we guni hafu yikafre sémbut hurunjoka xékélakihafi ye? ");
INSERT INTO wos_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Du nak méniré majestretna makambu takanjoka méniré hura yindét, méni dé wali yambumbu yita dé wali natafa mawuli héranjoka hurutaméni. Dé wali natafa mawuli hérahafi yamét, wafewana dé méniré kot xékékwa néma duka hura yindét, dé wandét gélindu méniré séndé gembu takatandi? ");
INSERT INTO wos_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Takandat méni wumbu retaméni. Guniré wuni we. Méni wumbu re méni kot xékékwa néma du wandén atéfék yéwa hwengut, wun nukwa male séndé ge yatakataméni.” Wungi dé Jisas wa. ");
INSERT INTO wos_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Wun nukwa du nawulak Jisaska yae di déré wa, “Néma du Pailat wandéka déka du Galilina héfaré yae di Galilina duré nawulak xiya. Wun du Godka hamwi xiyae hweta téndaka di Pailatna du diré xiyandaka deka nyéki dé hwetendaka hamwina nyéki wali dé bleké.” ");
INSERT INTO wos_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Wungi wandaka Jisas dé diré wa, “Galilina du wungi hiyandanka yingi guni saréké? Wunde du séfélak haraki saraki sémbut hurundaka hurundan haraki saraki sémbut nawulak du hurundan haraki saraki sémbutré dé sarékéngwandé wana? ");
INSERT INTO wos_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Wu yingafwe. Guniré wuni we. Guni hurungun haraki saraki sémbut yatakahafi yata guni akwi hiyatanguni, di hiyandan maki. ");
INSERT INTO wos_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Guni xékélaki. Hanja Siloamémbu téndé séményi ge dé tamba yéti angé man yétiyéti angé man yétiyéti dumbu xakre diré xiyandéka di hiya. Némbuli yingi guni saréké? Wungi xiyandén du hurundan haraki saraki sémbut dé Jerusalemémbu rekwa nawulak du hurundan haraki saraki sémbutré dé sarékéngwandé wana? ");
INSERT INTO wos_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Wu yingafwe. Guniré wuni we. Guni hurungun haraki saraki sémbut yatakahafi yata guni akwi hiyatanguni, di hiyandan maki.” ");
INSERT INTO wos_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Wun hundi wataka dé Jisas ané sataku hundi diré wa, “Du nak dé hambingal mi se, déka wain yawimbu. Sendéka wumbu téndéka séfélak nukwa wun du dé ya, sék nawulak gélinjoka. Yae dé hwakéfatiké. ");
INSERT INTO wos_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Hwakéfatika dé wain yawika hatikwa duré wa, ‘Héki hwari hufuk wuni ané mimbu sék nawulak gélinjoka wuni ya. Yae wuni hwakéfatiké. Méni wun mi xélitaméni. Yikafre héfambu baka yamba tékéndé.’ ");
INSERT INTO wos_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Wungi wandéka dé wa, ‘Néma du, métaka téndé, anémba héki hwari akwi. Téndét wuni wun mi mombu héfa xae, héfa yikafre yandéte bulmakau balina di sangwe hura yae takatawuni. ");
INSERT INTO wos_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Takawut wafewana ané héki hwari sék xakétandé wana? Wungi xakéndét, wu yikafre dé. Xakéhafi yandét méni xélitaméni.’ Wungi dé wa.” Wungi dé Jisas diré wa. ");
INSERT INTO wos_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Baka hwa nukwa nak dé Jisas Godna hundi buléndaka gembu reta dé du takwaré wakwe. ");
INSERT INTO wos_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Wakwendéka lé takwa hési lé wumbu re. Haraki hamwinya dé wule takwaré xiyandéka léka bunungul hambuk yahafi yata dé angwa ya. Yandéka lé huritékénjoka lé hurufatiké. Séfélak (18) héki hwari lé wungi re. ");
INSERT INTO wos_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Reléka Jisas léré xéta wandéka yaléka dé léré wa, “Takwa, némbuli wuni nyéniré bu lukwawu, nyéni yikafre yanyéte.” ");
INSERT INTO wos_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Wungi wata déka tambambu wule takwaré hurundéka lé bari huritéka té. Téta lé Godna ximbu haréké. ");
INSERT INTO wos_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Jisas baka hwa nukwa léré wungi huréhalékéndénka dé Godna hundi buléndaka gena néma du rékamba wata dé wumbu téndé du takwaré wa, “Nani gwongofu nukwambu jémba yatame. Wungi maki guni wunde nukwambu yatanguni, dé guniré huréhalékéndéte. Guni baka hwa nukwambu wungi yakénguni.” Wungi dé wa. ");
INSERT INTO wos_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Wun du wungi wandéka dé Jisas wa, “Guni yéna yakwa du guni. Atéfék nukwa guni ye bulmakau bali donki tékwa geré wulaaye yoo lukwa guni diré hura gwandi, hulingu sandate. Baka hwa nukwa akwi guni wun jémba ya. ");
INSERT INTO wos_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Wule takwa lé Abrahamna mandéka akwi lé. Satan dé léré gindéka lé wungi haraki re, tamba yéti angé man yétiyéti angé man yétiyéti (18) héki hwarimbu. Relénka wuni baka hwa nukwambu léré Satanéna tambambu wungi lukwawut, wu yikafre dé.” ");
INSERT INTO wos_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Wungi wandéka di déka mama roota di nakélak re. Rendaka wumbu téndé du takwa yandén atéfék yikafre male jémbaka di yikafre mawuli yata mawuli sawuli ya. ");
INSERT INTO wos_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Du takwa wungi mawuli yandaka dé Jisas diré wa, “God néma du reta du takwaka jémba hatitendéka, wu yingi maki dé? Méta sataku hundi guniré watawuni? ");
INSERT INTO wos_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Dé miyarna sék maki dé. Du nak wun misék hérae déka yawimbu dé yakisanda. Yakisandandéka wara némafwi ye dé wun yawimbu tékwa miré dé sarékéngwandé. Dé némafwi mi téndéka di afwi yae di wun mina galimbu wur yatitaka hwa.” ");
INSERT INTO wos_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Wun hundi wataka dé wambula wa, “God néma du reta du takwaka jémba hatitendékaka méta sataku hundi watawuni? ");
INSERT INTO wos_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Dé yis maki dé. Takwa hési yis hérae lé séfélak flawa wali yanjaménekéléka dé wun flawa atéfék dé wula némafwi ya.” Wungi dé Jisas diré wa. ");
INSERT INTO wos_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Wataka wun getéfa yatakataka dé Jerusalemré yinjoka dé nak getéfaré nak getéfaré yi. Ye dé du takwaré wakwe dé wungi yi. ");
INSERT INTO wos_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Yindéka dé du nak déré wa, “Néma Du, God nawulak du takwaré male yikafre hurutandé wana, di jémba rendate?” Wungi wakwexékéndéka dé wumbu téndé du takwaré dé wa, ");
INSERT INTO wos_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","“Guni wun yikama yambumbu wulayinjoka guni weséka jémba yatanguni. Séfélak du takwa wun gena yambumbu wulayinjoka mawuli yata di hurufatikétandi. ");
INSERT INTO wos_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Wun gena yafa raama wun gena yambu téfindét, guni yae hafwambu téta gena yambumbu xiyaata angi watanguni, ‘Néma Du, nanika gena yambu mé nafwi.’ Wungi wangut guniré angi watandé, ‘Guni yimbu guni ya? Wuni gunika yike wuni ye.’ ");
INSERT INTO wos_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Wungi wandét guni angi watanguni, ‘Nani méni wali hénoo hulingu sékéré nani sa. Méni nana getéfana yambumbu téta méni naniré wakwe.’ ");
INSERT INTO wos_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Wungi wangut dé guniré angi watandé, ‘Guniré wuni we. Wuni gunika akwi yangun getéfaka akwi yike wuni ye. Guni haraki saraki sémbut hurukwa du takwa guni. Guni atéfék wuniré yatakataka sa guni yi.’ ");
INSERT INTO wos_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Wungi wandét guni hafwambu téta xétanguni, Abraham, Aisak, Jekop, Godna profet atéfék akwi Godna getéfambu rendat. Xéta guni dé hafwambu takatendékaka hambukmbu géraata némbi titanguni. ");
INSERT INTO wos_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Guni hafwambu téngut di séfélak du takwa nukwa xalekwa sakumbu akwi, nukwa nandikwa sakumbu akwi, notna sakumbu akwi, sautna sakumbu akwi yae Godna getéfaré wulaaye di dé wali hénoo sanjoka retandi. ");
INSERT INTO wos_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Guniré wuni we. Némbuli hukétéfi yikwa du takwa nawulak di hukémbu tale yitandi. Némbuli tale yikwa du takwa nawulak di hukémbu hukétéfi yitandi.” ");
INSERT INTO wos_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Jisas wungi wata téndéka di Farisina du nawulak yae di Jisasré wa, “Herot méniré xiyanjoka dé mawuli ya. Wungi maki méni ané getéfa yatakataka nak getéfaré yitaméni.” ");
INSERT INTO wos_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Wungi wandaka dé diré wa, “Guni ye wun yéna yakwa baka duré angi watanguni, ‘Mé xéké. Ané nukwa akwi, séri akwi wuni du takwaré huréhalékéta haraki hamwinyaré watawuni, di yaange yindate. Séri hénya wuni yitewuka héfambu xakutawuni. ");
INSERT INTO wos_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Wu yak. Wuni némbuli, séri, hénya wuni yambumbu yitawuni. Godna profet nak Jerusalemémbu hiyahafi yata nak héfambu hiyandét, wu yamba sékérékékéndé.’ Wungi Herotré watanguni.” ");
INSERT INTO wos_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Wungi wataka dé wa, “Jerusalem, Jerusalem, nyéni Godna profetré xiyaakwa getéfa nyéni. God wandéka yindé duré nyéni motumbu xiyanguka di hiya. Séra héralén nyanka léka yék ekombu dika jémba hatiléka maki, wuni séfélak nukwa nyéna nyangwalré yikafre huruta dika jémba hatinjoka wuni mawuli ya. Mawuli yawuka nyéni hélék nyéni ya. ");
INSERT INTO wos_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Mé xé, God guna ge yatakataka dé guna tambambu taka. Guniré wuni we. Guni wuniré bari yamba xékénguni. Hukémbu guni wunika wangut, ‘Dé Néma Duna ximbu yakwa du dé. Nani déka ximbu harékétame.’ Wungi wangut wuni yawut guni wuniré xétanguni.” Wungi dé Jisas wa. ");
INSERT INTO wos_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Baka hwa nukwa nak dé Jisas Farisina duna néma du nakna geré wulayi, wumbu hénoo sanjoka. Wulayindéka di déré xéséfwa di jémba xé. ");
INSERT INTO wos_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Xéndaka man tamba wuléndé du nak dé Jisasna makambu té. ");
INSERT INTO wos_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Di wungi Jisasré xéséfundaka dé wun duré xéta dé hambuk hundika xékélakikwa duré akwi Farisina duré akwi dé wakwexéké, “Nana hambuk hundi yingi dé wa? Nani baka hwa nukwambu du takwaré huréhalékémbet, wu yikafre wana haraki wana?” ");
INSERT INTO wos_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Wungi wakwexékéndéka di hundi nawulak buléhambandi. Buléhafi yandaka dé Jisas wun duré hura huréhalékétaka wandéka dé yi. ");
INSERT INTO wos_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Yindéka dé diré wa, “Guna nyan guna bulmakau bali baka hwa nukwambu hutungumbu xakre nandindét guni déré bari hura xaletanguni, o yingafwe? Xéxé, baka hwa nukwambu wungi hurutanguni.” ");
INSERT INTO wos_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Wungi wandéka di déka hundi hasa wanjoka di hurufatiké. ");
INSERT INTO wos_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Jisas dé xé wun hénoo sanjoka yandé du yae néma duna hafwambu renjoka hurundaka. Xétaka dé diré ané sataku hundi wa, ");
INSERT INTO wos_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“Du nak takwa hérandén hénoo sangute guniré wandét, guni ye néma duna hafwambu yamba rekénguni. Guni néma duna hafwambu rengut, wafewana guniré sarékéngwandéndé néma du nak yandét, ");
INSERT INTO wos_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","guniré wandé du yae guniré angi watandé, ‘Guni wun yikafre hafwa ané duka hwetanguni.’ Dé wungi wandét guni roota néma duna hafwa yatakataka yae hukétéfi hafwambu retanguni. ");
INSERT INTO wos_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Dé guni wun hénoo sangute guniré wandét, guni ye hukétéfi hafwambu retanguni. Wungi rengut guniré wandé du yae guniré watandé, ‘Nyayika, guni yae néma duna hafwambu retanguni.’ Wungi wandét guni ye néma duna hafwambu rengut wun gembu rekwa duna makambu guni néma du retanguni. ");
INSERT INTO wos_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Du takwa deka ximbu harékéndat, God deka xiré husandatandé. Du takwa deka xiré husandandat, God deka ximbu harékétandé.” ");
INSERT INTO wos_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Wun hundi wataka dé dé wali hénoo sandéte wandé duré wa, “Méni hénoo humbwe sanjoka huruta ména nyayika, ména nyamangu bandingu, ména hém, ména getéfambu rekwa xérénjuwi mama duré yamba wakéméni, di yandate. Méni wungi maki duré wamét, hukémbu di humbwe méniré wandat yamét di ménika hénoo hasa hwetandi. ");
INSERT INTO wos_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Méni wungi hurukéméni. Méni némafwi hénoo humbwe sanjoka huruta méni jambangwe du, séfimali haraki yandé du, man haraki yandé du, dama hiyandé duré wataméni, di yandate. ");
INSERT INTO wos_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Wun du di ménika hénoo hasa hwenjoka dé hurufatikétandi. Wungi maki, yikafre sémbut hura hiyandé du takwa wambula ramétendaka nukwambu God méniré hasa hwetandé. Hasa hwendét, méni yikafre mawuli yataméni.” Wungi dé Jisas déré wa. ");
INSERT INTO wos_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Di wali reta hénoo sandé du nak wun hundi xékétaka dé Jisasré wa, “Godna getéfambu reta hénoo satekwa du di yikafre mawuli yatandi.” ");
INSERT INTO wos_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Wungi wandéka dé Jisas wa, “Du nak némafwi hénoo humbwinjoka dé huru. Huruta dé séfélak duré wa, di yae wun hénoo sandate. ");
INSERT INTO wos_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Wandéka hénoo satendaka nukwa yandéka dé déka jémba yakwa duré dé wa, dé hanja wandén duka ye diré ané hundi wandéte, ‘Atéfék jondu huratakambeka dé re. Guni mé ya.’ ");
INSERT INTO wos_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","“Dé dika ye wandéka di atéfék yinjoka hélék yandakaka di nak maki nak maki hundi wa. Du nak dé déré wa, ‘Wuni yéwa hwetaka héfa nak wuni héra. Hérataka némbuli wun héfa xénjoka yitawuni. Méni yawundu namét, wuni yakéwuni. Wungi wuni mawuli ye.’ ");
INSERT INTO wos_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Wungi wandéka dé nak wa, ‘Wuni bulmakau bali tamba yéti wuni héra. Hérataka wuni ye diré hurukwexétawuni. Di wuna jémba jémba yatandi, o yingi maki dé? Méni yawundu namét, wuni yakéwuni. Wungi wuni mawuli ye.’ ");
INSERT INTO wos_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Wungi wandéka dé nak wa, ‘Wuni wayika male takwa hési wuni héra. Wun moka, wuni yakéwuni.’ ");
INSERT INTO wos_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","“Di wungi wandaka dé jémba yakwa du wambula yae dé déka néma duré deka hundika wa. Wandéka dé wun gena yafa mawuli wita dé déka jémba yakwa duré wa, ‘Méni ané getéfambu hwakwa atéfék yambumbu bari hari ye méni jambangwe du, séfimali haraki yandé du, dama hiyandé du, man haraki yandé duré hérae wuna geré hura yataméni.’ ");
INSERT INTO wos_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Wungi wandéka dé jémba yakwa du ye wandén maki hurutaka wambula yae dé wa, ‘Néma du, wuni wamén maki bu huruwu. Huruwuka hafwa nawulak baka dé té.’ ");
INSERT INTO wos_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Wungi wandéka dé néma du déka jémba yakwa duré wa, ‘Méni némafwi yambumbu akwi yikama yambumbu akwi sa ye méni wumbu tékwa du takwaré hérae hura yataméni. Hura yamét wuna ge sukwekéndéte wuni mawuli ye. ");
INSERT INTO wos_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Némbuli guniré wuni we. Hanja wawun atéfék du wuna hénoo yamba sakéndi.’ Wungi dé néma du wa.” ");
INSERT INTO wos_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Séfélak du takwa di Jisas wali yambumbu yindaka dé waleka dé diré wa, ");
INSERT INTO wos_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“Du nak wunika yae wuna hukémbu yinjoka mawuli yata dé angi hurutandé. Dé déka yafa, ayiwa, takwa, nyangwal, nyamangu bandingu nyangenguka némafwimbu hélék yatandé. Dé ané héfambu renjoka akwi némafwimbu hélék yatandé. Dé wungi némafwimbu hélék yahafi yata dé wuna hukémbu yikwa du yamba rekéndé. ");
INSERT INTO wos_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Du takwa di diré xiyae hatekatendaka mi yatahafi yata di wuna hukémbu yikwa du takwa yamba rekéndi. ");
INSERT INTO wos_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","“Ané hundi mé xéké. Guna du nak séményi ge nak tonjoka mawuli yata tale dé reta jémba sarékétandé, wun ge totendéka yéwaka. Wafewana dé hura rendéka yéwaré wun ge sékérékékéndé wana? ");
INSERT INTO wos_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Tale wungi jémba sarékéhafi ye dé hwaar male husandandét yéwa hényindét ge tosékehafi yandét, atéfék du xéta wun duka bangwa wata wangitandi. ");
INSERT INTO wos_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","Wangita di watandi, ‘Wun ge tale tonjoka hurundéka yéwa hényindéka némbuli tosékenjoka dé hurufatiké.’ ");
INSERT INTO wos_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","“Ané hundi akwi mé xéké. Néma du nak dé xéké, nak néma du déka xi warekwa du wali yandéka, di wali warenjoka. Xékéta di wali warenjoka mawuli yata tale reta dé angi watandé, ‘Wuna xi warekwa du séfélak yingafwe. Déka xi warekwa du séfélak di. Yingi maki nae nani diré sarékéngwandétame? Wafewana di naniré sarékéngwandétandi?’ ");
INSERT INTO wos_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Wun néma du wungi sarékéndét, wun yatekwa néma du afaké hafwambu wayika téndét dé duré wandét di dika yae hundi bulétandi, di hundi bulésékéréka xi warehafi yandate. ");
INSERT INTO wos_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Wungi maki deka jondu atéfék hwehafi yandé du takwa di wuna hukémbu yikwa du takwa yamba rekéndi. ");
INSERT INTO wos_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","“Mé xéké. Hunyi yikafre joo dé. Wun hunyi résék yahafi yandét nani méta joo wun hunyimbu takatame, dé wambula résék yandéte? Yingafwe. Résék wambula yamba yakéndé. ");
INSERT INTO wos_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Wun hunyi dé baka joo wundé xakundé. Dé hénooré akwi héfaré akwi yikafre yamba hurukéndé. Du takwa wun hunyi baka yakitandi. Guna waan téndét, wu ané hundi mé guni xéké.” Wungi dé Jisas diré wa. ");
INSERT INTO wos_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Nak nukwa Romka yéwa héraakwa du akwi, nak haraki saraki sémbut hurukwa du takwa akwi di Jisas téndénré yi, déka hundi xékénjoka. ");
INSERT INTO wos_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Yindaka di Farisina du akwi xékélelakikwa du akwi wun jooka hélék yata di wa, “Wun du haraki saraki sémbut hurukwa du takwa wali téta dé di wali hénoo sa.” ");
INSERT INTO wos_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Wungi wandaka dé diré ané sataku hundi wa: ");
INSERT INTO wos_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“Wafewana guna du nak angi hurutandé? Du nak dé dumi tamba yéti (100) sipsip bali dé hura re. Hura rendéka dé nak faku. Fakundéka déka séfélak sipsip bali yikafre hafwambu sata téndaka dé diré yatakataka ye fakundé natafa sipsip balika dé hwaké. ");
INSERT INTO wos_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Hwaka hwaka xétaka hérae déka warafumbu yate hura mawuli sawuli ye dé yi. ");
INSERT INTO wos_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Ye getéfambu xaakwa dé du takwaré wandéka yae hérangwandéndaka dé diré wa, ‘Guni wuni wali yikafre mawuli yata mawuli sawuli yatanguni, wuna sipsip bali nak fakundéka hwaka xétaka hérawunka.’ Wungi dé diré wa.” ");
INSERT INTO wos_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Wungi wataka dé Jisas wa, “Guniré wuni we. Wungi male haraki saraki sémbut hurundé du nak déka haraki saraki sémbut yatakata Godka wambula yindét, Godna getéfambu di mawuli sawuli yatandi. Godna getéfambu di yikafre sémbut huruta hurundan sémbutka yatakanjoka sarékéhafi yakwa séfélak du takwaka wungi yikafre mawuli yahambandi.” ");
INSERT INTO wos_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","“Wafewana guna takwa hési angi hurutalé? Takwa hési silva yéwa tamba yéti hura reléka nak fakundéka lé hanyikwa ya xéréka gena hafwa yakéta lé hwaka hwaka lé wun yéwa xé. ");
INSERT INTO wos_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Xétaka hérae lé nyayikanguré akwi nyémayikanguré akwi waléka yae di hérangwandéndaka lé diré wa, ‘Guni wuni wali mawuli sawuli yatanguni, wuna yéwa nak fakundéka hwaka xétaka wambula hérawunka.’ Wungi lé diré wa.” ");
INSERT INTO wos_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Wungi wataka dé Jisas diré wa, “Guniré wuni we. Wungi male haraki saraki sémbut hurundé du déka haraki saraki sémbut yatakataka Godka wambula yindét, di Godna ensel mawuli sawuli yatandi.” ");
INSERT INTO wos_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Wataka dé Jisas nak sataku hundi angi wa, “Du nak dé nyan yéték héra. ");
INSERT INTO wos_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Hukémbu hérandén nyan dé déka yafaré wa, ‘Yafa, méni hukémbu hiyamét di ména jondu mune hwetandi, wuna nyamaka akwi, wunika akwi. Méni hératewuka jondu némbuli wunika hweméte wuni mawuli ye.’ Wungi wandéka dé yafa déka yéwa jondu bérka mune hwe. ");
INSERT INTO wos_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Hwendéka dé nawulak nukwa male yindéka dé hukémbu hérandén nyan déka jondu atéfék nak duka hwetaka yéwa hérae hura dé afaké getéfaré yi. Ye wun getéfambu reta dé déka yéwa hweséke, hurundén haraki saraki sémbutka. ");
INSERT INTO wos_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Hwendéka déka yéwa atéfék hényindéka hukémbu dé wun hafwambu némafwi hénoo ya. Yandéka déka hénoo dé hényi. ");
INSERT INTO wos_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Hényindéka ye dé wun héfambu rendé du nakéka wa, jémba nak hwendét yanjoka. Wandéka hwendéka ye dé déka bali téndan héfaré yi, dika hénoo hwenjoka. ");
INSERT INTO wos_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Ye dé bali sandaka hénoo sanjoka némafwimbu mawuli yandéka dé nak du déka hénoo hwehambandé. ");
INSERT INTO wos_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","“Wun du wungi hurutaka dé déka mawulimbu jémba saréké. Sarékéta dé wa, ‘Wuna yafaka jémba yakwa séfélak du di séfélak hénoo sandaka hénoo nawulak baka dé re. Rendéka wuni ambu reta hénooka wuni hiyae. ");
INSERT INTO wos_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Némbuli wuni raama wuna yafaka wambula ye déré angi watawuni: Wuni Godré haraki saraki sémbut huruta wuni méniré akwi haraki saraki sémbut huru. ");
INSERT INTO wos_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Huruwunka méni wunika ‘Wuna nyan dé’ namét, wu yamba sékérékékéndé. Méni yawundu namét, wuni ména jémba yakwa du wali ména jémba yatawuni. Wungi watawuni.’ ");
INSERT INTO wos_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Wun nyan wungi wataka déka yafaka wambula yinjoka dé yambumbu yi. “Wun nyan ye afakémbu téndéka dé déka yafa déré xé. Xéta déka némafwimbu saréfa naata dé fétékéra ye déka nyanré rota dé tamaru. ");
INSERT INTO wos_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Tamarundéka dé déka nyan déré wa, ‘Yafa, Wuni Godré haraki saraki sémbut huruta wuni méniré akwi haraki saraki sémbut huru. Huruwunka méni wunika “Wuna nyan dé” namét, wu yamba sékérékékéndé.’ ");
INSERT INTO wos_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Wungi wandéka dé déka yafa déka jémba yakwa duré wandéka yandaka dé diré wa, ‘Guni yikafre nukwa wur bari hérae hura yae guni déré nakitakatanguni. Nakitakataka guni wo déka tambambu sandataka su déka manmbu sandatanguni. ");
INSERT INTO wos_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Sandataka guni mwiwuléndé bulmakau bali nyan nakré hérae hura yae déré xiyatanguni. Xiyae nani sata mawuli sawuli yatame. ");
INSERT INTO wos_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Owa. Hanja wuna nyan dé hiyandé du maki dé re. Némbuli dé wambula ramé. Hanja dé faku. Némbuli wuni déré wambula xé. Wambula yandénka mawuli sawuli yatame.’ Wungi wandéka di déka mawuli sawuli yata hénoo humbwinjoka di huru. ");
INSERT INTO wos_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","“Wun duna makandu nyan yawimbu dé té. Te hukémbu wambula yae gembu xakunjoka yata dé xéké, hangu xiyaata hétihiyandaka. ");
INSERT INTO wos_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Xékéta dé jémba yakwa duré nak wandéka yandéka dé déré wakwexéké, ‘Di méta di ye?’ ");
INSERT INTO wos_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Wungi wakwexékéndéka dé jémba yakwa du wa, ‘Ména bandi wambula yae dé bar hiyahafi yata dé jémba té. Yandéndéka ména yafa déka yikafre mawuli yata wandéka di mwiwuléndé bulmakau bali nyan nak xiyae di hénoo sata mawuli sawuli ye.’ ");
INSERT INTO wos_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Wungi wandéka dé makandu nyan mawuli wita dé wulayinjoka hélék ya. Hélék yandéka déka yafa gwande dé déré wa, gekoré wulayindéte. ");
INSERT INTO wos_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Wandéka dé yafaré wa, ‘Mé xéké. Séfélak héki hwari wuni baka jémba yakwa du maki wuni ména jémba ya. Ye wuni wamén hundi atéfék wuni xéké. Yawunka méni wunika yikafre joo nak meme bali nyan nak hwehambaméni, wuni wuna nyayikangu wali sata mawuli sawuli yambete. ");
INSERT INTO wos_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Yak. Ména amba nyan ye ména séfélak jondu yambumbu tékwa takwaka hweséketaka wambula yae méni déka yikafre mawuli yata mwiwuléndé bulmakau bali nyan méni xiya, di sata mawuli sawuli yandate.’ ");
INSERT INTO wos_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Wungi wandéka dé yafa déré wa, ‘Wuna nyan, atéfék nukwambu méni andé re, wuni wali. Wuna atéfék jondu ména jondu male dé. ");
INSERT INTO wos_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Hanja ména bandi dé hiyandé du maki dé re. Némbuli dé wambula xaku. Hanja dé faku. Némbuli nani déré wambula xé. Wambula yandénka nani yikafre mawuli yata mawuli sawuli yambet, wu yikafre dé.’ Wungi dé yafa déka makandu nyanré wa.” Wungi dé Jisas wa. ");
INSERT INTO wos_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Hukémbu Jisas déka duré ané sataku hundi akwi dé wa, “Du nak dé xérénjuwi mama duna jonduka dé hati. Hatindéka di du nawulak di xérénjuwi mama duka yae di déré wa, ‘Ména jonduka hatikwa du dé yikafre jémba yahambandé. Yahafi yata dé ména jondu baka dé hwe.’ ");
INSERT INTO wos_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Wungi wandaka dé déka jonduka hatikwa duré wandéka yandéka dé déré wa, ‘Ménika xékéwun hundi yingi maki dé? Méni wuna jondu, wuna yéwa atéfék handékéna nyingambu hayitaka wun nyinga wunika mé hura ya. Hura yae méni wuna jémba wambula yamba yakéméni.’ ");
INSERT INTO wos_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Wungi wandéka dé jonduka hatikwa du déka mawulimbu dé wa, ‘Wuna néma du dé wuni déka jonduka wambula hatinjoka hélék dé ye. Wuni méta yakéwuni? Wuni baki xanjoka wuni hambuk yingafwe. Wuni nak du wunika yéwa hwendéte wanjoka wuni roo. ");
INSERT INTO wos_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Némbuli wuni xékélaki. Wuna néma du déka jémba yatakataka yiwute wandét, di wuna néma dumbu jondu hérandé du wuna nyayika reta wandat, wuni deka geré wulaaye di wali renjoka angi hurutawuni.’ ");
INSERT INTO wos_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Wungi wataka dé déka néma dumbu yéwa hérandé duré wandéka di nak nak di ya. Yandaka dé tale yandé duré wa, ‘Méni wuna néma duna jondu hatika hérae méni hasa hwetaméni?’ ");
INSERT INTO wos_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Wungi wandéka dé wa, ‘Dumi tamba yéti (100) oliv wel hulingu tékwa némafwi aki.’ Wungi wandéka dé jonduka hatikwa du déré wa, ‘Wun jondu atéfék hasa yamba hwekéméni. Hasa hweméte hayindén nyinga andé re. Méni reta bari nak hundi wun nyingambu mé hayi. Méni dumi natamba (50) male hayitaméni.’ ");
INSERT INTO wos_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Wungi wataka dé nak duré wa, ‘Méni wuna néma duna jondu hatika hérae hasa hwetaméni?’ Wungi wandéka dé wa, ‘Dumi tamba yéti (100) bek wit.’ Wungi wandéka dé wa, ‘Wun jondu atéfék hasa yamba hwekéméni. Hasa hweméte hayindén nyinga andé re. Méni nak hundi wun nyingambu mé hayi. Méni dumi angé tamba yétiyéti angé tamba yétiyéti (80) male hayitaméni.’ ");
INSERT INTO wos_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Hukémbu wun néma du dé déka jonduka hatikwa du yéna yata hurundénka dé hundi xéké. Xékétaka dé wun duna ximbu haréké, dé jémba sarékéta hurundénka. Wu yak. Ané héfana du takwa di deka du takwa wali jémba yanjoka di jémba saréké. Larékombu rekwa du takwa di deka du takwa wali jémba yanjoka di wungi jémba sarékéhambandi. ");
INSERT INTO wos_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","“Guniré wuni we. Guni ané héfana haraki xérénjuwi hérae du takwaré yikafre hurutanguni, di guna nyayikangu rendate. Rendat guna xérénjuwi hényindét, di guniré yikafre hurutandi, guni wungi re wungi re gembu rengute. ");
INSERT INTO wos_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Yikama jooka jémba hatikwa du takwa di némafwi jooka akwi jémba hatitandi. Yikama jooka séféla hatikwa du takwa di némafwi jooka akwi séféla hatitandi. ");
INSERT INTO wos_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Guni ané héfana haraki xérénjuwika jémba hatihafi yangut, héndé gunika mwi xérénjuwi hwetandé, guni wun jooka hatingute? Yingafwe. ");
INSERT INTO wos_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Guni nak duna jooka jémba hatihafi yangut, héndé gunika mwi joo hwetandé, wun joo guna hafu joo rendéte? Yingafwe. Yamba hwekéndé. ");
INSERT INTO wos_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Du nak néma du yétékéka jémba yanjoka dé hurufatikétandé. Wungi jémba yata dé nak néma duka yikafre mawuli yata nakéka hélék yatandé. Wungi jémba yata dé nak néma duna hundi xékéta nak néma duka hu hwetandé. Guni wun du maki guni. Guni Godka akwi ané héfana xérénjuwika akwi jémba yamba yakénguni.” Wungi dé Jisas diré wa. ");
INSERT INTO wos_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Farisina du di yéwaka némafwimbu mawuli yakwa du reta di wun hundi xékéta di Jisaska bangwa hundi wa. ");
INSERT INTO wos_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Wandaka dé diré wa, “Guni duna makambu guni atéfék nukwambu yikafre sémbut guni huru, di guniré xéta angi wandate, ‘Guni yikafre sémbut hurukwa du guni.’ Wungi wandate guni wungi hurunguka dé God guna mawulika dé xékélaki. Du takwa guna sémbutré xe guna ximbu harékéndaka dé God guna sémbutka némafwimbu hélék ye. ");
INSERT INTO wos_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","“Hanja di Moses wandén hambuk hundi wata Godna profetna hundi akwi wandaka di du takwa wun hundina ekombu di re. Rendaka Jon rendén nukwa yindéka némbuli wuni du takwaré wa, God néma du reta du takwaka jémba hatitendékaka. Wawuka séfélak du takwa déka getéfaré wulayinjoka di hambuk jémba di ye. ");
INSERT INTO wos_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Moses wandén yikama hambuk hundi nak bari hényikéndé. Wandén hundi atéfék wungi retandé. Hukémbu nyir héfa tale hényindét wun hundi hényitandé. ");
INSERT INTO wos_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","“Du déka takwaré yatakataka hési takwa hérae dé hukémbu hérandén takwa wali haraki saraki sémbut bér huru. Du déka takwaré yatakandét nak du wule takwa hérae dé wule takwa wali haraki saraki sémbut bér huru.” ");
INSERT INTO wos_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","“Ané hundi mé xéké. Hanja xérénjuwi mama du nak dé re. Atéfék nukwa dé yikafre nukwa wur akwi waka sanda wur akwi sandandékandé. Sandata atéfék nukwa dé séfélak yikafre hénoo sata dé yikafre mawuli yata re. ");
INSERT INTO wos_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","21","Jambangwe du nak, déka xi Lasarus, dé xérénjuwi duna gena yambumbu hwandéka déka séfimbu séfélak wasi téndéka dé Lasarus xérénjuwi mama duna jambémbu xakrindé mangé hénoo sanjoka dé némafwimbu mawuli ya. Mawuli yandéka séfélak nukwa di wasa yae di déka wasimbu bwiyaké. ");
INSERT INTO wos_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","“Hukémbu wun jambangwe du Lasarus dé hiyandéka di ensel déré hura wara di Abraham wali taka. Takandaka dé xérénjuwi mama du akwi hiyandéka di rémé. ");
INSERT INTO wos_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Réméndaka dé ye ya yanékwa hafwambu reta dé némafwi hangéli héraata yasawara dé xé, Abraham Lasarus wali anwar afakémbu rembéka. ");
INSERT INTO wos_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Xéta dé wanjita wa, ‘Wuna yafa Abraham, wuni ané ya yanékwa hafwambu reta wuni némafwi hangéli hérae. Hérawukaka méni wunika saréfa naata Lasarusré wamét dé déka sékétambambu hulingu nawulak hura yae dé wuna tékalimbu takatandé.’ Wungi dé wa. ");
INSERT INTO wos_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","“Wandéka dé Abraham wa, ‘Nyan, méni mé saréké. Hanja méni héfambu reta séfélak yikafre jondu méni héra. Héraméka Lasarus wungi hérahambandé. Haraki saraki jondu male dé déka ya. Némbuli dé ambu rendéka nani déka mawuliré yikafre hurumbeka méni haraki hafwambu reta hangéli méni héra. ");
INSERT INTO wos_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Ané jooka akwi mé saréké. Ani renakambu méni reméka nyéndékmbu God dé némafwi baki nak taka. Takandéka ambu rekwa du méni reméka hafwaré yinjoka di hurufatiké. Wumbu rekwa du akwi angiré yanjoka di hurufatiké.’ ");
INSERT INTO wos_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","“Wun hundi xékétaka dé hanja xérénjuwi mama hura rendé du wa, ‘Wuna yafa, wuni wun jooka sarékéta wuni méniré wakwexéké, méni Lasarusré wamét, dé wuna yafana geré yindéte. ");
INSERT INTO wos_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","Dé ye wuna bandingu natambaré hambukmbu watandé, di akwi ané hafwaré yae némafwi hangéli hérandamboka.’ ");
INSERT INTO wos_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Wungi wandéka dé Abraham wa, ‘Yingafwe. Moses wandén hambuk hundi, Godna profetna hundi akwi dé Godna nyingambu re. Di wun hundi métaka xékénda.’ ");
INSERT INTO wos_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","“Wun hundi wandéka dé wa, ‘Yafa Abraham, wungi yingafwe. Di deka hundi yamba xékékéndi. Hiyandé du nak raama dika yindét, di déka hundi xékéta hurundan haraki saraki sémbut yatakatandi.’ ");
INSERT INTO wos_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Wungi wandéka dé Abraham wa, ‘Di Mosesna hundi akwi profetna hundi akwi xékéhafi yata di hiyae wambula raméndé duna hundi akwi yamba xékékéndi.’ Wungi dé Abraham wa.” Wungi dé Jisas diré wa. ");
INSERT INTO wos_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Jisas dé déka duré wa, “Wuni xékélaki. Du takwana mawuliré hurukwexé jondu xakutandi, du takwa wun jondumbu xakre haraki saraki sémbut hurundate. Wun jondu hura yatekwa duka wuni saréfa nae. ");
INSERT INTO wos_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Wun jondu hura yatekwa duré di tale deka hwalimbu némafwi motu gitaka diré néma xérimbu yakisandandat, di hulingu se hiyandat, wu yikama joo dé. Wunde du wun jondu hura yandat, wuna yikama nyangwal deka hundi xéka haraki saraki sémbutmbu xakrindat, hukémbu God wun jondu hura yatekwa duré hambukmbu hasa hwendét, wu némafwi haraki joo dé. ");
INSERT INTO wos_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Guni xékélaki natanguni. Guna nyama bandi nak haraki saraki sémbut hurundét, guni déré hambuk hundimbu watanguni. Hambuk hundimbu wangut, dé hurundén haraki saraki sémbut yatakandét, guni wun jooka wambula sarékékénguni. ");
INSERT INTO wos_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Dé natafa nukwambu angé tamba yétiyéti angé tamba hufuk yambumbu guniré haraki saraki sémbut hura dé angé tamba yétiyéti angé tamba hufuk yambumbu gunika yae angi wandét, ‘Guniré huruwun haraki saraki sémbutka hélék ye némbuli wuni wun sémbut yatakatawuni.’ Wungi wandét, guni angé tamba yétiyéti angé tamba hufuk yambumbu guni watanguni, ‘Yak. Hurumén haraki saraki sémbutka wambula sarékékéme.’ Wungi watanguni.” ");
INSERT INTO wos_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Jisasna du di déré wa, “Néma Du, méni naniré yikafre hurumét nana Godka jémba sarékémbeka mawuli némafwi yatandé.” ");
INSERT INTO wos_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Wungi wandaka dé Néma Du Jisas dé wa, “Guni Godka jémba sarékénguka mawuli dé miyar sék maki yalefu male rendét, guni ané miré angi wangut, “Méni ména méngi féla méni hafuré néma xérimbu takataméni.” Wangut ané mi guna hundi xékéta wangun maki hurutandé. ");
INSERT INTO wos_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Wun hundi wataka dé Jisas diré wa, “Guni du, guna be nak déka jémba yakwa du héfa dé wee wana dé sipsip balika dé hati wana? Dé gérambu jémba yaséketaka déka néma duna geré yindét, wafewana déka néma du déré angi watandé? ‘Méni bari mé yae reta sa.’ ");
INSERT INTO wos_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Wu yingafwe. Dé angi watandé, ‘Méni wuna hénoo mé humbwi. Humbwitaka méni yikafre nukwa wur nakitaka wuna hénoo wunika hwetaméni. Hwemét, wuni tale sawut méni hukémbu sataméni.’ ");
INSERT INTO wos_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Wun néma du wungi wandét déka jémba yakwa du wungi hurundét, wun néma du déka jémba yakwa duka diména natandé o yingafwe? Wu yingafwe. Wun jémba yakwa du dé néma du wandén maki male dé jémba ya. ");
INSERT INTO wos_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Guni wun jémba yakwa du maki Godna jémba yatanguni. Godna jémba yata guni nak nakéka angi watanguni, ‘Nani baka jémba yakwa du nani re. God hwendén jémba male nani ya.’ Wungi watanguni.” Wungi dé Jisas diré wa. ");
INSERT INTO wos_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Jisas Jerusalemré yikwa yambumbu dé yi. Samariana héfa angé sakumbu téndéka Galilina héfa angé sakumbu dé té. ");
INSERT INTO wos_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Jisas yambumbu ye getéfa nakmbu xakundéka di walisufu hurundé du tamba yéti wungi di afakémbu téta déré di yambumbu xé. ");
INSERT INTO wos_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","Xéta di hambukmbu wa, “Néma du, Jisas, nanika mé saréfa naata naniré yikafre huru.” ");
INSERT INTO wos_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Wungi wandaka dé diré xéta dé wa, “Guni sa ye guni prisré guna séfi wakwe.” Wungi wandéka di déka hundi xékéta yindaka dé deka séfi wambula yikafre ya. ");
INSERT INTO wos_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Yandéka dé wun du nak déka séfi yikafre yandéka xéta dé wambula ya. Yae hambukmbu wata dé Godna ximbu haréké. ");
INSERT INTO wos_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Harékéta Jisasna man mombu xakre hwaata dé wambula wambula Jisaska diména na. Wun du Samariana héfambu yandé du dé. ");
INSERT INTO wos_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Yandéka Jisas dé wa, “Du tamba yéti deka séfi yikafre dé ya. Du angé tamba natamba angé tamba yétiyéti di yimbu di té? ");
INSERT INTO wos_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Métaka we natafa du male, nak téfambu yandé du dé hafu wambula ya, Godna ximbu harékénjoka?” ");
INSERT INTO wos_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Wungi wataka dé wun duré wa, “Méni wunika jémba sarékéménka méni wambula yikafre xaku. Méni sé raama yi.” Wungi dé Jisas wun duré wa. ");
INSERT INTO wos_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Farisina du nawulak di Jisasré wakwexéké, “God néma du reta du takwaka jémba hatitendéka nukwa yinga nukwa yatandé.” Wakwexékéndaka dé diré wa, “God néma du reta du takwaka jémba hatitendéka nukwa yandét guni yamba xékénguni. ");
INSERT INTO wos_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Wun nukwaka du nawulak angi wakéndi, ‘Mé xé. God ambu dé néma du re.’ Wungi wahafi yandat nawulak du angi wakéndi, ‘Mé xé. God wun hafwambu néma du dé re.’ Wungi wakéndi, God néma du reta du takwaka jémba hatitendéka nukwa guna nyéndékmbu dé xaku.” ");
INSERT INTO wos_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Wun hundi wataka dé Jisas déka duré angi wa, “Hukémbu guni Duna Nyan retendéka nukwaré xénjoka mawuli yatanguni. Mawuli yata guni wun nukwaré yamba xékénguni. ");
INSERT INTO wos_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Wun nukwa du nawulak guniré angi watandi, ‘Wun duré mé xé. Duna Nyan ambu dé re.’ Wungi wandat nawulak watandi, ‘Yingafwe. Wumbu dé re.’ Wungi wandat guni deka hundi xékékénguni. Deka hukémbu yamba yikénguni. ");
INSERT INTO wos_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Nyir tulem nandéka atéfék du takwa xéndaka maki, wuni Duna Nyan wuni wambula yatewuka nukwambu gayawut, guni atéfék wuniré xétanguni. ");
INSERT INTO wos_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Tale némbuli rekwa du takwa wuniré séfélak haraki sémbut huruta wunika hu hwetandi. ");
INSERT INTO wos_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","“Hanja Noa rendén nukwambu du takwa hurundan maki, Duna Nyan wuni wambula yatewuka nukwa du takwa wungi male hurutandi. ");
INSERT INTO wos_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Wun nukwambu du takwa di hénoo sata, hulingu sata, takwa héraata, duré humbwita, di wungi hurundaka dé Noa némafwi gunjambémbu wulayi. Wulayindéka némafwi hwe gwandéléka di atéfék hulingu se di hiya. ");
INSERT INTO wos_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Lot rendén nukwambu Sodomémbu rendé du takwa wungi male di huru. Di hénoo sata, hulingu sata, jondu héraata, yéwa hweta, yawimbu seta, ge tota, wungi di huru. ");
INSERT INTO wos_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Hurundaka dé Lot Sodom yatakandé nukwambu dé ya akwi yanékwa motu akwi bér wali giyaakwa maki nyirmbu xakre bér atéfék du takwaré xiyasanda. ");
INSERT INTO wos_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Wunde du takwa hurundan maki, wuni Duna Nyan gayawut wuniré xétendaka nukwambu du takwa wungi male hurutandi. ");
INSERT INTO wos_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","“Wun nukwa gena hafwambu tékwa du takwa bari yaange yitandi. Deka jondu héranjoka deka geré wambula yamba wulayikéndi. Wungi male yawimbu tékwa du takwa akwi di deka getéfaré wambula yihafi ye di bari yaange yitandi. ");
INSERT INTO wos_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Guni Lotna takwaka mé saréké. ");
INSERT INTO wos_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Wungi maki hiyahafi renjoka mawuli yakwa du takwa di hiyae fakutandi. Hiyanjoka roohafi yakwa du takwa jémba retandi, wungi re wungi re. ");
INSERT INTO wos_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Guniré wuni we. Wambula yatewuka gan du déka takwa wali natafa jambémbu hwambét ensel nakré héraata nakré yatakatandi. ");
INSERT INTO wos_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Wun nukwa takwa yéték hénoo humbwita rembét, ensel hésiré héraata hésiré yatakatandi. ");
INSERT INTO wos_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Wun nukwa du yéték yawimbu jémba yata témbét, ensel nakré héraata nakré yatakatandi.” ");
INSERT INTO wos_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Wun hundi wandéka xékéta déka du di wa, “Néma Du, wun joo yimbu xakutandé?” Wungi wandaka dé Jisas diré wa, “Barokwaru yae hérangwandéndaka xéta guni hiyandé hamwi nak rendékaka guni xékélaki. Wungi maki guni xe xékélakitanguni.” Wungi dé Jisas diré wa. ");
INSERT INTO wos_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Jisas ané sataku hundi dé déka duré wa. Di atéfék nukwambu God wali buléta déré wakwexékénjoka wendé nandamboka dé diré angi wa. ");
INSERT INTO wos_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","“Néma getéfambu dé kot xékékwa néma du nak dé re. Wun du dé Godka roohafi yata, dé du takwaka akwi sarékéhafindé. ");
INSERT INTO wos_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Du hiyandé takwa hési lé wun getéfambu re. Reta lé kot xékékwa néma duka wambula wambula yita lé angi déré wa, ‘Wuna mama wuniré haraki hurunjoka dé huru. Méni hambuk hundimbu déré watéfiméte wuni mawuli ye.’ ");
INSERT INTO wos_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Wungi waléka wun du dé wa, ‘Yingafwe.’ Wataka tale léré yikafre hurunjoka hélék dé ya. Hélék yandéka lé séfélak nukwa yita déré wakwexékéléka hukémbu dé déka mawulimbu wa, ‘Wuni Godka roohafi yata, du takwaka akwi sarékéhambawuni. ");
INSERT INTO wos_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","Sarékéhafi yata wuni wule takwa wunika wambula wambula yaata wuniré wakwexékélét wuni wendé natawuni. Lé wungi huruta wuna mawuliré haraki hurulémboka, wuni léka hundi xékéta léré yikafre hurutawuni.’ Wungi dé kot xékékwa néma du wa.” ");
INSERT INTO wos_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Néma Du Jisas wun hundi wataka dé diré wa, “Guni wun haraki saraki sémbut huruta kot xékékwa néma du wandén hundika mé saréké. ");
INSERT INTO wos_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Wun du wungi hurundénka, God méta yatandé, déka wasékendén du takwa atéfék nukwa atéfék gan dé diré yikafre hurundéte déré wakwexékéndat? Dé deka hundi bari xékétandé o yingi maki dé? ");
INSERT INTO wos_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Guniré wuni we. Dé diré bari yikafre huruta deka mamaré hasa hwetandé. Ané jooka akwi mé saréké. Hukémbu wuni Duna Nyan wambula gayata Godka jémba sarékékwa du takwaré xétawuni wana?” ");
INSERT INTO wos_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Jisas dé xékélaki. Du takwa nawulak deka mawulimbu di wa, “Nani Godna makambu yikafre sémbut hurukwa du takwa nani re. Nawulak du takwa déka makambu haraki sémbut hurukwa du takwa di re.” Wungi wakwa duré dé Jisas ané sataku hundi wa: ");
INSERT INTO wos_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","“Du yéték God wali hundi bulénjoka bér tempelré wari. Wun du nak Farisina du dé. Nak Romka yéwa hérandé du dé. ");
INSERT INTO wos_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Farisina du wumbu téta dé hafuré dé angi wa, ‘Méni God, wuni yikafre du rewukaka, wuni ménika diména nae. Wuni nawulak du takwa maki yingafwe. Di nak duna jondu sélé héraata di yénataka hundi wata, du nak duna takwa wali hwaata wungi huruta di haraki saraki sémbut huru. Wuni ambu tékwa Romka yéwa héraakwa du hurundéka maki huruhafi wuni. ");
INSERT INTO wos_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Wuni atéfék wik wuni nukwa yéték hénoo sahafi wuni re. Reta wuni hérawuka atéfék jondu mune tamba yétina natafa també wuni ménika hwe.’ ");
INSERT INTO wos_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Wungi wandéka dé Romka yéwa hérandé du afakémbu téta dé hurundén haraki saraki sémbutka sarékéta dé nyirré yasawara xénjoka dé roo. Roota dé hurundén sémbutka némafwimbu saréfa naata dé Godré angi wa, ‘Méni God, wuni haraki saraki sémbut hurukwa du wuni. Méni wunika mé saréfa naata wuniré yikafre huru.’ Wungi dé wa.” ");
INSERT INTO wos_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","“Guniré wuni we. Romka yéwa hérandé du wungi wandéka God hurundén haraki saraki sémbut yakwanyindéka dé Godna makambu yikafre du reta dé jémba yi, déka geré. Farisina du dé Godna makambu yikafre du rehambandé. Deka ximbu harékékwa du takwa hukémbu God deka xiré husandatandé. Deka ximbu harékéhafi yakwa du takwa hukémbu God deka ximbu harékétandé.” Wungi dé Jisas diré wa. ");
INSERT INTO wos_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Du takwa di yikama nyangwalré Jisaska hura yi, dé diré séngétakandéte. Hura yindaka di Jisasna du xéta di diré haraki hundi wa. ");
INSERT INTO wos_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Haraki hundi wandaka dé Jisas wun nyangwalré wa, di déka yandate. Wataka dé déka duré wa, “Yikama nyangwal wunika métaka yanda. Yandat guni diré watéfikénguni. Godna getéfaré wulayitekwa du takwa di wunde yikama nyangwal maki di. ");
INSERT INTO wos_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Mwi hundi wuni guniré we. God néma du reta déka du takwaka jémba hatitandé. Yikama nyangwal maki, du takwa dé dika jémba hatitendékaka yikafre mawuli yata di déka getéfaré wulayitandi. Yikama nyangwal mawuli yandaka maki yikafre mawuli yahafi yakwa du takwa di déka getéfaré yamba wulayikéndi.” Wungi dé Jisas diré wa. ");
INSERT INTO wos_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Néma du nak dé Jisasré wa, “Yikafre wakwekwa du, méni mé wa. Wuni huli mawuli hérae wungi re wungi re jémba renjoka méta joo hurutawuni?” ");
INSERT INTO wos_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Wungi wandéka dé Jisas wa, “Métaka méni wunika ‘Yikafre du’ wa? God hafu dé yikafre du dé. ");
INSERT INTO wos_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Méni ané hambuk hundika bu xékélakimé. ‘Méni nak duna takwa wali yamba hwakéméni. Du takwa hiyandate diré yamba xiyakéméni. Sélé yamba hérakéméni. Nak du hurundén jooka yénataka hundi yamba wakéméni. Méni ména yafa ayiwana hundi xékéta béniré yikafre hurutaméni.’ Wungi méni xékélaki.” ");
INSERT INTO wos_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Wungi wandéka dé wa, “Wuni nyan rewun nukwa wuni wun hambuk hundi wuni xéké. Ané nukwa akwi wuni xéké.” ");
INSERT INTO wos_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Wungi wandéka Jisas déka hundi xéka dé wa, “Méni nak joo akwi yataméni. Méni takamén atéfék jondu nak duka hwetaka yéwa hérae méni jambangwe du takwaka hwetaméni. Hweta méni Godna getéfambu yikafre male jondu hérataméni. Wungi hwetaka wambula yae wuna hukémbu yitaméni.” ");
INSERT INTO wos_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Wungi wandéka wun hundi xékéndéka déka mawuli némafwimbu xak dé ya, dé séfélak xérénjuwi hérandénka. ");
INSERT INTO wos_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Jisas wun duré xéta dé déka duré wa, “Xérénjuwi mama du takwa God néma du rendéka getéfaré wulayinjoka mawuli yata, wu weséka jémba yatandi. ");
INSERT INTO wos_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Némafwi kamel bali nak nukwa wur hundafanéndaka ramina yambumbu wulayinjoka mawuli ye, wu yalefu jémba yatandé. Xérénjuwi mama du takwa God néma du rendéka getéfaré wulayinjoka mawuli ye, wu némafwi jémba yatandi.” ");
INSERT INTO wos_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Wungi wandéka di wun hundi xékéndé du di wa, “Xérénjuwi mama du takwa wungi hurundat, héndé huli mawuli hérae wungi re wungi re retandi?” ");
INSERT INTO wos_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Wungi wandaka dé wa, “Du takwa hurufatikéndaka joo God dé hali hurundé.” ");
INSERT INTO wos_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Wun hundi wandéka dé Pita wa, “Mé xéké. Nani nana ge nana jondu akwi yatakataka nani ména hukémbu nani yi.” ");
INSERT INTO wos_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Wungi wandéka dé diré wa, “Mwi hundi wuni guniré we. Du takwa di God néma du reta du takwaka hatitendékaka sarékéta Godna jémba yanjoka di deka ge, deka du, deka takwa, nyamangu, bandingu, yafa, ayiwa, nyangwalré yatakandat, ");
INSERT INTO wos_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","God némbuli dika séfélak yikafre jondu hasa hwetandé. Hukémbu dé diré yikafre hurutandé di jémba rendate, wungi re wungi re.” Wungi dé diré wa. ");
INSERT INTO wos_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Jisas déka du tamba yéti manmbu yéték di wali male hundi buléta dé diré wa, “Mé xéké. Némbuli Jerusalemré nani wari. Warimbet di Godna profet hanja Duna Nyanka hayindan maki atéfék huruséketandi. ");
INSERT INTO wos_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Jerusalemémbu di wuniré nak téfana duka hweta wunika bangwa hundi wata wuniré haraki huruta di wuniré simbar séxatandi. ");
INSERT INTO wos_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Di wuniré rami yoombu xiyataka wuniré xiyatandi. Xiyandat hiyae nukwa hufuk wungi hwataka wuni wambula ramétawuni.” ");
INSERT INTO wos_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Wungi wandéka déka du wun hundi atéfékéka yike di ya. God wun joo fakundéka di Jisas wandén hundika yike di ya. ");
INSERT INTO wos_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Hukémbu Jisas déka du wali di Jerikombu xakunjoka yandaka dé dama hiyandé du nak dé yambumbu reta dé du takwaré wa, yéwa héranjoka. ");
INSERT INTO wos_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Héranjoka wata dé xéké, séfélak du takwa yindaka. Xékéta dé du nawulakré wakwexéké, “Wu méta di ye?” ");
INSERT INTO wos_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Wungi wakwexékéndéka di déré wa, “Nasaretna du Jisas andé yae.” ");
INSERT INTO wos_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Wungi wandaka dé wa, “Devitna mandéka Jisas, wunika mé saréfa naata wuniré yikafre huru.” ");
INSERT INTO wos_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Wungi wandéka di tale yindé du déré hambukmbu wata di wa, “Nakélak sé naande re.” Wungi wandaka dé deka hundi xékéhafi yata dé wambula wambula wanjita dé wa, “Devitna mandéka Jisas, wunika mé saréfa naata wuniré yikafre huru.” ");
INSERT INTO wos_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Wungi wandéka dé Jisas téta dé diré wa, di wun duré hura yandate. Wungi wandéka dé wun du yae Jisas téndénmbu xakundéka dé déré wakwexéké, ");
INSERT INTO wos_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“Wuni méniré méta yawute méni mawuli ye?” Wungi wandéka dé wa, “Néma Du, wuni wambula xénjoka wuni mawuli ye.” ");
INSERT INTO wos_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Wungi wandéka dé déré wa, “Ména damambu wambula mé xé. Méni wunika jémba sarékéménka méni wambula yikafre ya.” ");
INSERT INTO wos_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Wungi wandéka dé déka dama bari hari wambula yikafre yandéka dé xé. Xéta dé Jisasna hukémbu yita dé Godna ximbu haréké. Harékéndéka di wun joo xéndé du takwa akwi di Godna ximbu haréké. ");
INSERT INTO wos_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Jisas dé Jerikoré wulaaye dé nak getéfaré yinjoka dé yambumbu yi. ");
INSERT INTO wos_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Wun getéfambu dé Romka yéwa hérandé du nak déka xi Sakius dé re. Dé Romka yéwa hérandé duna néma du dé. Dé xérénjuwi mama du dé. ");
INSERT INTO wos_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Dé Jisasré xénjoka dé mawuli ya. Mawuli yandéka séfélak du takwa téndaka dé Jisasré xénjoka dé hurufatika, dé fosék du dé. ");
INSERT INTO wos_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Hurufatika dé Jisas yitendéka yambumbu tale fétékéré ye dé mimbu nak waré, Jisasré xénjoka. ");
INSERT INTO wos_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Wara rendéka Jisas yae wun hafwambu xaakwa déré yasawara xéta dé déré wa, “Sakius, méni bari mé gaya. Ané nukwa wuni méni wali ména gembu retawuni.” ");
INSERT INTO wos_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Wungi wandéka dé bari gayata dé mawuli sawuli yata dé Jisasré déka geré hura yi. ");
INSERT INTO wos_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Yindéka di atéfék du takwa xéta di wa, “Jisas dé haraki saraki sémbut hurukwa du wali renjoka dé déka geré yi. Wungi haraki dé.” ");
INSERT INTO wos_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Di wungi wandaka Sakius dé wumbu téta dé Néma Duré angi wa, “Néma Du, mé xéké. Némbuli wuni wuna jondu nyéndékmbu munitawuni. Mune nak també jambangwe du takwaka hwetawuni. Hweta angi akwi hurutawuni. Wuni hanja duré nawulak yéna ye deka jondu hérataka némbuli wuni dika wambula hweta també hufuk akwi hwetawuni.” ");
INSERT INTO wos_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Wungi wandéka dé Jisas wa, “Ané du akwi dé Abrahamna mandéka dé re. Rendékaka némbuli God déré déka gembu rekwa du takwaré akwi Satanéna tambambu démbu héra. ");
INSERT INTO wos_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Wuni Duna Nyan fakundé du takwaka hwaka xéta diré Satanéna tambambu hérae diré yikafre hurunjoka wuni ané héfaré gaya.” Wungi dé diré wa. ");
INSERT INTO wos_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Di déka hundi xékéta rendaka dé Jisas diré sataku hundi nak akwi wa. Wumbu rendé du di angi saréké, “God néma du reta nanika jémba hatitendéka nukwa bari xakutandé.” Jisas deka mawulika sarékéta, Jerusalem walémbambu téndénka akwi sarékéta dé diré ané sataku hundi wa. ");
INSERT INTO wos_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","13","“Néma du nak dé afaké téfaré yinjoka dé tale déka jémba yakwa du tamba yétiré wandéka yandaka dé di nak nakéka dé bangi nak yéwa hwe (20 kina maki). Hweta dé diré wa, ‘Ané yéwa hura jémba yangut, wuni wambula yae hératawuni.’ Wungi wataka dé afaké téfaré yi, wumbu rekwa néma du déré wandét, dé déka hafu getéfambu rekwa du takwaka néma du renjoka. Ye wun hundi xékétaka bari wambula yanjoka dé saréké. ");
INSERT INTO wos_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Dé yindéka di déka getéfambu rendé du takwa nawulak déka hélék yata, di duré nawulak wandaka di déka hukémbu yi. Ye di afaké téfambu rendé néma duré wa, ‘Wun du nanika néma du rendémboka hélék nani ye.’ ");
INSERT INTO wos_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","“Hukémbu wun afaké téfambu rendé néma du dé wun duré wa, dé déka getéfambu rekwa du takwaka néma du rendéte. Wandéka xékétaka re dé wambula ya. Yae dé wa, ‘Hanja yéwa hwewun duré mé wa, di yandate. Hwewun yéwa hura jémba ye yéwa hatika di héra?’ ");
INSERT INTO wos_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Wungi wandéka du nak tale yae dé déré wa, ‘Néma du, wuni ména yéwa hura jémba ye wuni bangi tamba yéti yéwa akwi wuni héra.’ ");
INSERT INTO wos_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Wungi wandéka dé néma du déré wa, ‘Wu jémba méni huru. Méni yikafre jémba yakwa du méni. Méni yikama jooka jémba hatiménka wuni wawut méni getéfa tamba yétika néma du retaméni.’ ");
INSERT INTO wos_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Wungi wandéka dé nak du akwi yae dé wa, ‘Néma du, wuni ména yéwa hura jémba ye wuni bangi natamba yéwa akwi héra.’ ");
INSERT INTO wos_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Wungi wandéka dé néma du wa, ‘Wu yikafre dé. Némbuli wuni wawut méni getéfa natambaka néma du retaméni.’ ");
INSERT INTO wos_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","21","Wungi wandéka nak du yae dé wa, ‘Néma du, wuni ménika wuni xékélaki. Méni du takwaka saréfa nahafiméni. Méni takahafi yamén joo méni hura yi. Méni sehafi yamén héfambu méni hénoo héra. Wungi xékélakita wuni ménika roota wuni hwemén yéwa nukwa wurmbu giya wuni taka. Mé xé. Ména yéwa ambu.’ ");
INSERT INTO wos_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Wungi wandéka dé néma du wa, ‘Méni haraki jémba yakwa du méni. Wamén hundimbu wuni yamén haraki saraki sémbut méniré hasa hwetawuni. Méni angi méni wa. ‘Wuni du takwaka saréfa nahafiwuni. Wuni takahafi yawun joo wuni hura yi. Wuni sehafi yawun héfambu wuni hénoo héra.’ Méni wungi xékélakita ");
INSERT INTO wos_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","métaka wuna yéwa méni yéwa takandaka gembu takahafi ye? Méni wumbu takamét, wuni wambula yae wun yéwa hérae nawulak yéwa akwi hératawuni.’ ");
INSERT INTO wos_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Wungi wataka dé wumbu téndé duré wa, ‘Guni déka hwewun yéwa démbu hérae guni bangi tamba yéti yéwa hérandé duka hwetanguni.’ ");
INSERT INTO wos_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Wungi wandéka di déré wa, ‘Néma du, dé yéwa tamba yéti wundé hérandé.’ ");
INSERT INTO wos_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Wungi wandaka dé diré wa, ‘Yikafre jémba ye séfélak jondu hérandé du takwa hukémbu jondu nawulak akwi hératandi. Yikafre jémba yahafi yata joo hérahafi yandé du takwa hukémbu baka retandi. ");
INSERT INTO wos_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Yak, wuna mama di wuni deka néma du rewumboka hélék di ya. Hélék yandanka guni diré mé hura yae wuna makambu xiyangut hiyanda.’ Wungi dé néma du wa.” ");
INSERT INTO wos_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Jisas wun hundi wataka dé tale ye dé déka du wali Jerusalemré warinjoka dé yi. ");
INSERT INTO wos_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Ware dé Betfage bér Betanimbu xakunjoka dé ya. Wumbére getéfa yéték Oliv némbumbu bér té. Xakunjoka yaata dé déka du yétékré wa, bér tale yimbéte. ");
INSERT INTO wos_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","Dé bérré angi wa, “Béni wun angé sakumbu tékwa getéfaré wulaaye xétambéni, wayikana donki nak mimbu lékindaka téndéka. Hanja du déka bunungulmbu rehambandé. Béni déré mé lukwa béni hura ya. ");
INSERT INTO wos_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Lukwambét du nak béniré angi wakwexékéndéte, ‘Méta yanjoka béni wun wayikana donki luku?’ Wungi wandét béni angi watambéni, ‘Néma Du dé wun donkika mawuli ye.’ Wungi watambéni déré.” ");
INSERT INTO wos_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Wun hundi xékétaka bér ye bér xé, Jisas wandén maki wun donki wumbu téndéka. ");
INSERT INTO wos_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Xétaka wun wayikana donkina yoo lukumbéka di wun donkina yafa yae di bérré wa, “Méta yanjoka béni wun wayikana donki luku?” ");
INSERT INTO wos_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Wungi wandaka bér wa, “Néma Du dé wun donkika mawuli ye.” ");
INSERT INTO wos_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Wungi wambéka yawundu nandaka bér wayikana donki hura yi Jisaska. Ye bér bérka sanda wur donkina bunungulmbu xakétaka, Jisas wumbu rendéte. ");
INSERT INTO wos_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Wun donkimbu reta yindéka di du takwa deka nukwa wurré yambu xéletaka. ");
INSERT INTO wos_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Xéletakandaka dé Oliv némbu yatakataka naande ye Jerusalemémbu xakunjoka yandéka déka jémba sarékékwa séfélak du takwa di déka yikafre mawuli yata mawuli sawuli ya. Yata hanja xéhafi yandan hambuk jémba xéndanka sarékéta di hambukmbu wata di Godna ximbu haréké. Harékéta di wa: ");
INSERT INTO wos_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Néma Du God déka ximbu xaakwa néma duré yikafre hurutandé. Godna getéfambu rekwa du nakélak huru mawuli héraata jémba retandi. Nani anwarmbu rekwa Godna ximbu harékétame. ");
INSERT INTO wos_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Farisina du nawulak wun du takwa wali téta xékéta di Jisasré wa, “Wakwekwa du, ména du takwaré mé watéfi.” ");
INSERT INTO wos_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Wungi wandaka dé diré wa, “Guniré wuni we. Di hundi buléhafi yandat, ande motu hambukmbu wata wuna ximbu harékétandi.” Wungi dé diré wa. ");
INSERT INTO wos_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Jisas ye Jerusalemémbu xakunjoka yata getéfaré xéta saréfa naata dé géra. ");
INSERT INTO wos_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","Géraata dé wa, “Nyéni, nyéni akwi ané nukwa God wali nakélak huru mawuli hératenyéka yambuka xékélakinyét, wu yikafre dé. Wu yak, némbuli wun yambu nyénika faakwa rendéka nyéni wun yamburé yamba xékénguni. ");
INSERT INTO wos_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","44","Guni God guniré yikafre hurutendéka nukwa yandékaka xékélakihambanyéni. Xékélakihafi yanyékaka hukémbu guna mama yae guna getéfa hérangwanda nyéna atéfék sakumbu tétandi. Téta di héfa xae yitenguka atéfék yambu takatéfitandi. Takatéfita di getéfaré wulaaye guniré, guna nyangwalré akwi xiyasandatandi. Xiyasandata atéfék geré glarétandi. Glaréndat ge tondan atéfék motu héfambu xakre hafu hafu retandi.” Wungi dé wa. ");
INSERT INTO wos_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Jisas ye tempelré wulaaye dé xé du nawulak jondu hweta yéwa hérandaka. Xéta dé diré hérekinjoka huruta ");
INSERT INTO wos_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","dé diré angi wa, “Ané hundi Godna nyingambu dé re: God dé wa, ‘Wun gembu du takwa wuni wali hundi bulétandi.’ Wungi dé God wa. Guni wungi huruhambanguni. Guni jondu hweta yéwa héranguka ané ge dé sélé héraakwa duna ge maki dé xaku.” Wungi dé diré wa. ");
INSERT INTO wos_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Atéfék nukwambu dé tempelmbu du takwaré wakwendéka di prisna néma du, xékélelakikwa du, néma du nawulak akwi di déré xiyanjoka huru. ");
INSERT INTO wos_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Hurundaka atéfék du takwa déka yikafre mawuli yata déka hundi xékénjoka mawuli yandaka di wunde néma du déré xiyanjoka di hurufatiké. ");
INSERT INTO wos_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Nukwa nak dé Jisas tempelmbu téta du takwaré wakweta Godna yikafre hundi wata téndéka di prisna néma du, xékélelakikwa du, Israelna néma du, wungi di déka ya. ");
INSERT INTO wos_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Yae di déré wa, “Méta hambuk hérae méni wun jémba ye? Héndé wa méni wun jémba yaméte?” ");
INSERT INTO wos_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Wungi wandaka dé diré wa, “Wuni akwi guniré nak hundi wakwexékétawuni. Guni wuniré mé wa. ");
INSERT INTO wos_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Héndé Jonré wa dé du takwaré guré husandandéte? God dé wungi wa, o du male dé wungi wa?” ");
INSERT INTO wos_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Wungi wakwexékéndéka di di hafu buléta di wa, “Nani angi wambet, ‘God dé wungi wa.’ Wungi wambet dé naniré angi watandé, ‘Métaka guni déka hundi xékéhafi ye?’ ");
INSERT INTO wos_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Nani angi wambet, ‘Du male dé wa.’ Wungi wambet, atéfék du xékéta naniré motumbu naake xiyatandi, di Jonka ‘Godna profet dé’ nandanka.” ");
INSERT INTO wos_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Wungi bulétaka di Jisasré wa, “Nani yike nani ye. Wun jooka yamba wakéme.” ");
INSERT INTO wos_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Wungi wandaka dé diré wa, “Wuni akwi yamba wakéwuni, wuniré wandéka yae ané jémba yawun duka.” ");
INSERT INTO wos_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Wun hundi wataka dé du takwaré ané sataku hundi wa, “Du nak dé wain yawi nak huru. Hukémbu dé yawika hatikwa du nawulakéka wun yawi hwe, di wun yawimbu jémba yata sék gélitendaka nukwambu nawulak sék déka hwendate. Hwetaka dé nak hafwaré ye dé séfélak bafu wumbu re. ");
INSERT INTO wos_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Rendéka wain sék gélitendaka nukwa yandéka dé wali reta déka jémba yakwa duré nak dé wa, dé yawika hatikwa duka yindéte. Di wain sék nawulak hwendat hura yandéte dé mawuli ya. Mawuli yata wandéka déka jémba yakwa du yindéka di yawika hatikwa du déka hundi xékéhambandi. Xékéhafi yata di wun duré xiyaata wandaka dé wain sék nawulak hérahafi yata dé baka wambula ya. ");
INSERT INTO wos_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Yandéka déka jémba yakwa nak duré wandéka, yindéka, déré akwi xiyaata haraki saraki sémbut huruta wandaka dé wain sék nawulak hérahafi yata dé baka wambula ya. ");
INSERT INTO wos_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Yandéka déka jémba yakwa nak duré akwi wandéka, yindéka, déré hambukmbu xiyaata di déré hafwaré yakisangwandé. ");
INSERT INTO wos_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Yakisandandaka wambula yandéka yawina yafa dé wa, ‘Wuni méta yatawuni? Wuni wuna némafwimbu mawuli yawuka nyanré watawuni, dé yindéte. Dé ye wandét, wafewana, di déka hundi xékétandi wana?’ ");
INSERT INTO wos_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Wungi wataka dé déka dunyaré wandéka, yindéka, di yawika hatikwa du déré xéta di hafu buléta angi di wa, ‘Yawina yafa hiyandét, wun nyan déka yafana jondu atéfék hératandé. Nani déré xiyataka ané yawi hératame.’ ");
INSERT INTO wos_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Wungi wataka di déré hura yawi yatakataka hafwaré hura gwandi di déré xiyandaka dé hiya.” Wungi wataka dé Jisas diré wa, “Guni yingi guni saréké? Di wungi hurundanka wun yawina yafa diré méta yatandé? ");
INSERT INTO wos_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Dé yae wun wain yawika hatikwa duré xiyasandatandé. Xiyae nawulak duka wun yawi hwetandé, di yawika hatindate.” Wumbu téndé du wun hundi xékétaka di wa, “Yingafwe. Dé wungi yamba hurukéndé.” ");
INSERT INTO wos_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Wungi wandaka dé diré xéta dé wa, “Guni Godna nyingambu rekwa hundika nak guni yike ye wana. Wun hundi angi dé: Ge tokwa du di motu nakéka hélék yata di wun motu yaki. Yakindaka nak dé wun motu hérae takandéka dé ge jémba té. ");
INSERT INTO wos_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Du nak wun motu takumbu xakre dé aki maki també també fikatandé. Wun motu duna séfimbu xakre dé wun duré fikaséketandé.” Wungi dé Jisas wa. ");
INSERT INTO wos_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Wun hundi wandéka di xékélelakikwa du prisna néma du akwi di xékélaki, Jisas dika dé wun sataku hundi wa. Xékélakita déré bari hulukinjoka mawuli yata di du takwaka roota di déré hulukihambandi. ");
INSERT INTO wos_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Hulukihafi yata di déré hulukitendaka yambuka hwakéta di yéna yakwa du nawulakré wa, di nakélak ye Jisasré nak maki nak maki jooka wakwexékéndate, du nak Jisasré Godna yikafre sémbutka wakwexékéndéka maki. Wungi wata di deka mawulimbu angi wa, “Di wungi déré wakwexékéndat, wafewana dé hasa wata haraki hundi nawulak watandé? Wandét nani déré duna makambu takatame. Duna makambu takataka nani déré ané hafwambu rekwa Romna duka hwetame.” Wungi wandaka ");
INSERT INTO wos_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","wun yéna yakwa du Jisasré ye di wa, “Wakwekwa du, nani xékélaki, méni yikafre hundi wata diré Godna hundika jémba méni wakwe. Méni natafa hundi male méni wa néma du takwa, baka du takwaré akwi. Méni mwi hundi wata Godna yambuka méni wakwe. Wungi xékélakita némbuli nani méniré angi wakwe, ");
INSERT INTO wos_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","nana hambuk hundi yingi dé wa? Nani Romna néma duka yéwa hwetame, o yingafwe?” ");
INSERT INTO wos_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Wungi wandaka dé Jisas deka yéna yakwa mawulika xékélakita dé diré wa, ");
INSERT INTO wos_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","“Guni guna yéwa nak wuniré mé wakwe. Ané yéwambu rekwa waka héna saawi dé? Héna xi di ané yéwambu hayi?” Wungi wakwexékéndéka di wa, “Wu Romna néma duna xi, Sisar dé.” ");
INSERT INTO wos_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Wungi wandaka dé diré wa, “Wu mwi hundi dé. Romna néma duna jondu guni déka hwetanguni. Godna jondu guni Godka hwetanguni.” ");
INSERT INTO wos_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Jisas wungi wandéka di yéna yakwa du di Jisas du takwana makambu wandén hundika haraki hundi wanjoka di hurufatiké. Di wandén hundika déré Romna néma duna makambu takanjoka di hurufatiké. Hurufatikéta di déka hundika saréké warékéta di hundi buléhafi té. ");
INSERT INTO wos_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Nak nukwa Sadyusina du nawulak di Jisaska ya. Sadyusina du di angi saréké, “Hiyandé du takwa wambula yamba ramékéndi.” Wungi di wa. ");
INSERT INTO wos_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","Di nawulak Jisaska yae di déré angi wa, “Wakwekwa du, hanja Moses nanika dé angi hayi, ‘Du nak takwa hérae nyan hérahafi ye hiyandét, déka bandi wule takwaré hératandé. Hérandét nyan héralét wun nyanka watandé, ‘Wuna nyamana nyan dé.’ Wungi watandé.’ Wungi dé Moses hayi. ");
INSERT INTO wos_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Némbuli mé xéké. Hanja nyamangu bandingu angé tamba yétiyéti angé tambambu hufuk di re. Nyama takwaré hérae nyan hérahafi ye dé hiya. ");
INSERT INTO wos_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Hiyandéka déka bandi wule takwaré hérae nyan hérahafi ye dé hiya. ");
INSERT INTO wos_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Hiyandéka nak bandi wule takwaré hérae nyan hérahafi ye dé hiya. Hiyandéka atéfék bandingu wungi male léré hérae di atéfék nyan hérahafi ye di hiya. ");
INSERT INTO wos_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Hiyandaka hukémbu lé wule takwa akwi hiya. ");
INSERT INTO wos_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Némbuli naniré mé wa. Hiyandé du takwa wambula ramétendaka nukwambu wule takwa héndéna takwa retalé? Hanja wunde nyamangu bandingu atéfék di léré héra.” Wungi di Sadyusina du Jisasré wakwexéké. ");
INSERT INTO wos_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Jisas deka hundi xékéta dé diré wa, “Némbuli rekwa du di takwa hérandaka takwa di du humbwi. ");
INSERT INTO wos_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","36","Hukémbu God nawulak du takwana sémbutka sarékéta dé diré waséketandé, di hukémbu xakutekwa nukwambu rendate. Wunde hiyandé du takwa di wambula raama di ensel maki reta di wambula yamba hiyakéndi. Wungi maki wunde du di takwaré yamba hérakéndi. Wunde takwa di du yamba humbwikéndi. Di Godna nyangwal retandi. Di hiyandé du takwa wambula ramétendaka nukwana nyangwal retandi. ");
INSERT INTO wos_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Wu yak, hiyandé du takwa wambula ramétandi. Ramétendakaka hanja Moses dé wakwe. Dé yikama mi ya yanéndén hundimbu Néma Du Godka angi wa: Dé Abrahamna God dé. Dé Aisakna God dé. Dé Jekopna God dé. ");
INSERT INTO wos_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Moses wun hundi hayindéka nani xékélaki. Dé hiyandé duna God yingafwe. Dé huli rekwa duna God dé. Godna makambu atéfék du di huli du di re. Wungi nani xékélaki.” ");
INSERT INTO wos_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Wungi wandéka di xékélelakikwa du nawulak di déré wa, “Wakwekwa du, méni yikafre hundi méni wa.” ");
INSERT INTO wos_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Wungi wandaka di déré nak jooka wambula wakwexékénjoka di roo. ");
INSERT INTO wos_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Wungi wandaka dé Jisas diré wa, “Yingi maki nae God wasékendén du Krais dé Devitna mandéka retandé? ");
INSERT INTO wos_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Hanja Devit hafu dé Godna nyingambu rekwa gwar dé Kraiska angi hayi: “Néma Du God wuna Néma Duré dé wa, ‘Méni néma du reta wuna yika tambambu retaméni. ");
INSERT INTO wos_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","Remét wuni ména mamaré ména man mombu takatawuni.’” ");
INSERT INTO wos_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Devit wun hundi hayita dé Kraiska, ‘Wuna Néma Du,’ nandéka yingi maki dé Krais Devitna mandéka re? Krais Devitna mandéka reta, Devitna néma du akwi dé re, o yingi maki dé?” Wungi dé diré wakwexéké. ");
INSERT INTO wos_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Atéfék du takwa Jisasna hundi xékéta téndaka dé Jisas déka duré dé angi wa, ");
INSERT INTO wos_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“Guni xékélelakikwa duka xékélaki natanguni. Di séményi nukwa wur nakitaka du takwa hérangwandéndaka hafwambu yitaka yatakanjoka di mawuli ye. Yitaka yatakandat, nak du takwa diré xéta deka ximbu harékéta dika dinguna nandate di mawuli ye. Di Godna hundi buléndaka geré wulaaye di néma duna hafwambu renjoka di mawuli ye. Du nak dé némafwi hénoo hurundét, di dé wali sata di atéfék du takwana makambu yikafre hafwambu renjoka di mawuli ye. ");
INSERT INTO wos_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Di du hiyandé takwana jondu atéfék di héra. Di yéna yata némafwi hundi Godré wa, du takwa diré xéta deka ximbu harékéndate. Hurundanka God diré hambukmbu male hasa hwetandé.” Wungi dé Jisas wa. ");
INSERT INTO wos_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Jisas tempelmbu téta dé xé xérénjuwi mama du takwa Godka yéwa hwendaka. ");
INSERT INTO wos_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Xéndéka jambangwe du hiyandé takwa hési yae yikama yéwa yéték Godka hweléka dé xé. ");
INSERT INTO wos_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Xéta dé wa, “Mwi hundi wuni guniré we. Wule jambangwe du hiyandé takwa hwelén yéwa dé atéfék xérénjuwi mama du takwa hwendan yéwaré dé sarékéngwandé. ");
INSERT INTO wos_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Wunde xérénjuwi du takwa di séfélak jondu hura di Godka yéwa nawulak male di hwe. Wule takwa lé séfélak yéwa huruhafi yata lé hura relén yéwa atéfék Godka hwe. Hwetaka lé hénoo hérateléka yéwa yingafwe.” ");
INSERT INTO wos_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Jisasna du nawulak di tempelka buléta di wa, “Ané yikafre ge dé. Yikafre motumbu di to. Du takwa Godka hwendan yikafre jondumbu jémba di yasu.” Wungi wandaka dé Jisas diré wa, ");
INSERT INTO wos_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","“Némbuli xénguka jondu, yak, hukémbu nak nukwa yandét, nawulak du yae ané geré haraki hurutandi. Haraki huruta atéfék motu hérae yakisandandat motu nak nak motu takumbu yamba hwakéndé.” ");
INSERT INTO wos_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Wun hundi wandéka di déré wakwexéké, “Wakwekwa du, yimba nukwa wun ge haraki hurutandi? Méta joo tale yandét nani xéta wun joo yatendékaka xékélakitame?” ");
INSERT INTO wos_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Wungi wandaka dé Jisas wa, “Guni xékélaki natanguni. Naata yéna yakwa duna hundi xékékénguni. Séfélak du yae di guniré yéna yanjoka wuna ximbu wata di nak nak angi watandi, ‘Krais wambula yatendéka nukwa andé yae. Wuni Krais wuni.’ Wungi wandat guni deka hundi xékékénguni. ");
INSERT INTO wos_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Wun nukwa xékétanguni, séfélak du takwa deka héfambu rekwa du takwa wali, nak téfambu rekwa du takwa wali warendat. Xékéta guni rookénguni. Tale wun joo xakutandé. Xakundét, hukétéfi nukwa hukémbu yatandé. Bari yamba yakéndé.” Wungi dé wa. ");
INSERT INTO wos_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Wataka dé diré wa, “Natafa héfambu rekwa du takwa di nak héfambu rekwa du takwa wali waretandi. Nak néma duna hém nak néma duna hém wali waretandi. ");
INSERT INTO wos_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Séfélak nukwa némafwi nono hurutandé. Séfélak héfambu némafwi hénoo yandét némafwi bar akwi hiyatandi. Nyirmbu roonguka jondu akwi hanja xéhafi yangun jondu xakundat guni xétanguni. ");
INSERT INTO wos_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","“Wun jondu wayika xakuhafi yandat, tale du nawulak di guni wuna du rengukaka akwi wuna jémbaka akwi hélék yata, di guniré huluke guniré haraki hurutandi. Huruta di Godna hundi buléndaka gembu guniré duna makambu takatandi. Di guniré séndé gembu takatandi. Guniré hura yindat guni némafwi héfana néma du akwi, yikama héfana néma du akwi deka makambu tétanguni. ");
INSERT INTO wos_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Di wungi hurundat wun nukwa guni diré wuna hundi watanguni. ");
INSERT INTO wos_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Watengukaka sarékéta guni tale guna mawulimbu angi wakénguni, ‘Nani deka hundi yingi maki hasa watame?’ ");
INSERT INTO wos_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Wungi wakénguni. Wun nukwa wuni gunika yikafre xékélaki akwi watenguka hundi akwi gunika hwetawuni. Wuni wungi hwewut watenguka hundi guna mama watendaka hundiré sarékéngwandétandé. Sarékéngwandéndét di guna hundi hasa wanjoka hurufatikétandi. ");
INSERT INTO wos_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Guna yafa ayiwa, guna nyamangu bandingu, guna hémna nawulak du, guna nyayikangu wungi di guniré mamaka hwetandi. Hwendat guna be nawulakré xiyandat hiyatanguni. ");
INSERT INTO wos_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Guni wuna du rengukaka atéfék du takwa gunika némafwimbu hélék yatandi. ");
INSERT INTO wos_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Hélék yata guniré haraki hurundat, guna anéngambambu tékwa némbé nak hiyae yamba fakukéndé. ");
INSERT INTO wos_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Di guniré haraki hurundat, guni wendé nahafi yata wuna jémba yatakahafi yata guni wuni wali wungi re wungi re jémba retanguni.” ");
INSERT INTO wos_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","“Hukémbu xi warekwa du Jerusalemré hérangwanda téndat xéta xékélakitanguni. Jerusalemré haraki hurutendaka nukwa andé yae. ");
INSERT INTO wos_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Xékélakita guni Judiambu rekwa du takwa némburé bari yaange yitanguni. Guni Jerusalemémbu rekwa du takwa wun getéfa yatakataka bari yaange yitanguni. Guni yawimbu tékwa du takwa wun getéfaré wulayikénguni. ");
INSERT INTO wos_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Wungi wuni wa, wun nukwa dé God Jerusalemémbu rekwa du takwa hurundan haraki saraki sémbut diré hasa hwetendéka nukwa dé. Hanja hayindan hundi mwi hundi xakundate di wun jondu wun nukwambu xakutandi. ");
INSERT INTO wos_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Wun nukwa nyan tékwa takwa akwi, nyangwalka munya hwekwa takwa akwi bari yaange yinjoka hurufatikétandi. Dika wuni saréfa nae. Wun nukwa némafwi xakéngali ané héfambu xakutandé. Godna mawuli wi Judana du takwaka yatandé. ");
INSERT INTO wos_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Yandét mama yae di Judana du takwa nawulakré xi warekwa yarmbu xiyandat di hiyatandi. Nawulakré di huluke hura ye di séfélak téfambu takatandi. Wunde mama nak téfambu yae di Jerusalemré haraki huruta di Jerusalemna héfambu xakita yitaka yatakatandi. Yitaka yatakandat, God wandén maki nak téfana duna nukwa hényindét, di wun héfa yatakatandi. ");
INSERT INTO wos_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","“Nukwa, bafu, nyirmbu tékwa hunkwari nak maki nak maki jondu xakundat du takwa xétandi. Néma xéri hambukmbu raméta wilét séfélak héfambu rekwa du takwa xéta roota saré warékétandi. ");
INSERT INTO wos_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Nyirmbu tékwa hambuk jondu séngénéta yitaka yatakatandi. Yitaka yatakandat séfélak du takwa di ané héfambu xakutekwa haraki jonduka sarékéta di némafwimbu roota jinjawe maki yandét xakritandi. ");
INSERT INTO wos_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Wun nukwambu wuni Duna Nyan némafwi hambuk yata nukwa hanyikwa maki haanye buwimbu reta gayawut xétandi. ");
INSERT INTO wos_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Wun joo tale yandét guni xékélakitanguni. Nawulak nukwa male yindét, wuni guniré hérae Godna getéfaré hura yitawuni. Wungi xékélakita guni yikafre mawuli yata raama yasawara xétanguni.” Wungi dé Jisas diré wa. ");
INSERT INTO wos_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Wataka dé diré angi wa, “Hambingal mi akwi atéfék mika akwi mé saréké. ");
INSERT INTO wos_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Mi ganga fiyae huli ganga hunyalandéka xe guni xékélaki. Hénoo naré yakwa nukwa andé yae. ");
INSERT INTO wos_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Wun miré xéta nukwaka xékélakinguka maki, guni wawun jonduré xéta xékélakitanguni. God néma du reta du takwaka jémba hatitendéka nukwa andé yae. Wungi xékélakitanguni. ");
INSERT INTO wos_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Mwi hundi wuni guniré we. Némbuli rekwa du takwa nawulak hiyahafi reta wawun atéfék jonduré xétandi. ");
INSERT INTO wos_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Nyir héfa akwi hényitandé. Wuna hundi yamba hényikéndé. Reséketandé. ");
INSERT INTO wos_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","“Guni xékélaki natanguni. Du nawulak séfélak hénoo sata, wangété yandaka hulingu sata wangété yata, ané héfana jonduka male sarékéta, wungi hurundaka deka mawuli xak yandéka di wunika sarékéhambandi. Guni di hurundaka maki yamba hurukénguni. Guni wungi hurungut, wun hukétéfi nukwa gunika bari yatandé, biyami bari xiyandéka maki. ");
INSERT INTO wos_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Wun nukwa dé ané héfambu rekwa atéfék du takwaka bari yatandé. ");
INSERT INTO wos_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Guni atéfék nukwa wunika haxétanguni. Haxéta guni Godré wakwexékétanguni, dé guniré yikafre hurundét, wun xakéngali xakutendéka nukwambu guni hambuk yata jémba ténjoka. Guni wungi te hukémbu guni wuni Duna Nyanéna makambu jémba tétanguni.” Wungi dé Jisas diré wa. ");
INSERT INTO wos_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Atéfék nukwa Jisas tempelmbu téta dé Godka du takwaré wakwe. Wakwendéka gan yandéka dé Oliv némburé ye dé wumbu hwa. ");
INSERT INTO wos_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Hwandéka atéfék ganémbambu atéfék du takwa di tempelré yi, déka hundi xékénjoka. ");
INSERT INTO wos_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Yis takahafi yandan bret sandaka nukwa, wun nukwana xi Pasova, dé walémbambu dé ya. ");
INSERT INTO wos_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Wun nukwa di prisna néma du, xékélelakikwa du akwi wungi di Jisasré xiyanjoka mawuli yata di du takwaka roota di Jisasré xiyatendaka yambuka di hwaké. ");
INSERT INTO wos_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Hwakéndaka dé Satan Judasna mawulimbu dé wulayi. Judasna nak xi Iskariot dé. Dé wun Jisasna tamba yéti man yéték du nak dé. ");
INSERT INTO wos_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Wulayindéka dé Judas ye dé prisna néma du wali gélindu wali dé hundi bulé, Jisasré dika hwenjoka. ");
INSERT INTO wos_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Buléndéka di mawuli sawuli yata di déka yéwa nawulak hwenjoka hundi gi. ");
INSERT INTO wos_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Gindaka dé Judas yawundu nataka ye dé Jisasré dika nakélak hwetendéka nukwaka dé haxé. Séfélak du takwa Jisas wali rehafi yatendaka nukwaka dé haxé. ");
INSERT INTO wos_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Yis takahafi yandan bret sandaka nukwa dé ya. Wun nukwa di sipsip bali nyanré xiya, Pasova nukwana hénooka. ");
INSERT INTO wos_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Xiyandakaka sarékéta Jisas dé Pita bér Jonré wa, “Béni sa ye Pasova nukwana hénoo humbwimbét nani satame.” ");
INSERT INTO wos_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Wungi wandéka bér déré wa, “Ani yimbu humbwinate méni mawuli ye?” ");
INSERT INTO wos_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Wungi wakwexékémbéka dé wa, “Mé xéké. Béni ye Jerusalemré wulaaye hulingu tékwa aki yate yikwa du nakré xétambéni. Xéta béni déka hukémbu ye wulayitendéka geré wulayitambéni. ");
INSERT INTO wos_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Wulaaye béni wun gena yafaré angi watambéni, ‘Nana wakwekwa du dé méniré angi wa, ‘Wuni wuna du wali Pasova nukwana hénoo satembeka ge yimbu dé té?’ Wungi dé wa.’ ");
INSERT INTO wos_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Wungi wambét dé gena takumbu tékwa néma ge bénika wakwetandé. Wun gembu hénoo satembeka jambé, retembeka jambé akwi dé té. Béni wun gembu hénoo humbwitambéni.” ");
INSERT INTO wos_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Wungi wandéka bér ye bér Jisas wandén maki bér xé. Xétaka bér Pasova nukwana hénoo bér humbwi. ");
INSERT INTO wos_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Hénoo satendaka nukwa yandéka dé Jisas déka aposel wali yae di hénoo sanjoka di re. ");
INSERT INTO wos_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Reta dé Jisas diré wa, “Hukémbu wuni némafwi hangéli hératawuni. Tale wuni ané Pasova nukwana hénoo guni wali sanjoka wuni némafwimbu mawuli wuni ye. ");
INSERT INTO wos_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Guniré wuni we. Wuni wun hénoo bari wambula yamba sakéwuni. Wuni God néma du reta du takwaka hatitendéka nukwambu wun hénoona mo huruséketaka, wuni wun hénoo wambula satawuni.” ");
INSERT INTO wos_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Wungi wataka dé wain hulingu téndé hanyandé nak hérae dé Godka diména nataka dé déka duré wa, “Guni hérae nak nak satanguni. ");
INSERT INTO wos_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Guniré wuni wa. Wuni ané héfambu reta wun wain hulingu wambula yamba sakéwuni. Hukémbu God néma du reta du takwaka hatitendéka nukwa yandét, wuni wain hulingu wambula satawuni.” ");
INSERT INTO wos_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Wungi wataka dé bret hérae dé Godka diména nataka bret fukae dé déka duka hweta dé diré wa, “Ané wuna séfi dé. Guniré yikafre hurunjoka wuni wuna séfi hwe. Guni wunika sarékéta wungi hurutanguni.” ");
INSERT INTO wos_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Wungi wandéka di atéfék sandaka dé Jisas wain hulingu téndé hanyandé hérae wungi male huruta dé wa, “Ané wuna nyéki dé. Wuna nyéki blekéndét, God gunika huli hundi wasékérékétandé.” ");
INSERT INTO wos_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Wun hundi wataka dé Jisas diré wa, “Mé xéké. Wuniré mamaka hwetekwa du némbuli dé wuni wali reta dé hénoo se. ");
INSERT INTO wos_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Wu yak, hanja di Duna Nyanré haraki huruta xiyatendakaka di hayi. Hayindan maki wuniré xiyandat hiyatawuni. Wu mwi hundi dé. Wuniré mamaka hwetekwa duka wuni saréfa nae. Démbu némafwi xakéngali yatandé.” ");
INSERT INTO wos_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Wungi wandéka di hafu buléta di wakwexéké, “Héndé wungi hurute?” ");
INSERT INTO wos_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Jisasna du di hundi buléta waru. Waruta di wa, “Nani wali rekwa du héndé nana néma du rete?” ");
INSERT INTO wos_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Wungi wandaka dé diré wa, “Nak téfambu rekwa du takwana néma du di hambuk yata deka du takwaka di hati. Hatindaka deka du takwa di dika wa, ‘Wu naniré yikafre hurukwa du dé.’ ");
INSERT INTO wos_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Wungi wandaka guni wun néma du maki yamba hurukénguni. Guna nyéndékmbu du nak dé néma du renjoka mawuli yata dé wayikana du maki retandé. Guna makambu tale yikwa du dé guna jémba yakwa du retandé. ");
INSERT INTO wos_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Héndé néma du dé re, jambémbu sanjoka rekwa du wana hénoo humbwita jémba yakwa du wana? Wu jambémbu rekwa du dé. Wuni wungi huruhambawuni. Wuni guni wali reta wuni guna jémba yakwa du wuni re. ");
INSERT INTO wos_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","“Guni wuni wali ténguka xak wunika yandéka guni wuniré yatakahafi yata wuni wali té. ");
INSERT INTO wos_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Wuna yafa wuniré dé waséke, wuni néma du reta du takwaka jémba hatiwute. Wasékendén maki wuni guniré waséke, ");
INSERT INTO wos_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","wuni néma du rewut guni wuna jambémbu wuni wali reta wuni wali hénoo hulingu sangute. Sata guni Israelna hém tamba yéti manmbu yétékéka néma du reta dika hatitanguni.” ");
INSERT INTO wos_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Wungi wataka dé Jisas Saimon Pitaré wa, “Saimon, Saimon, méni mé xéké. Satan dé guniré hurukwexénjoka dé némafwimbu mawuli ye. Yata dé Godré wakwexéké, dé wungi hurunjoka. ");
INSERT INTO wos_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Wungi wakwexékéndéka wuni ménika Godré bu wakwexékéwu, méni wunika jémba sarékémét ména mawuli jémba téndéte. Téndét méni wunika hu hwe hukémbu wambula yae méni wuna duré yikafre hurumét, deka mawuli akwi hambuk tétandé.” ");
INSERT INTO wos_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Wungi wandéka dé Pita déré wa, “Néma Du, wuni méni wali yinjoka wuni mawuli ye. Wuni méni wali ye séndé gembu hwawut, wu yikafre dé. Wuni méni wali ye hiyawut, wu yikafre dé.” ");
INSERT INTO wos_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Wungi wandéka dé Jisas déré wa, “Pita, méniré wuni we. Némbuli gan séra wahafi yandét méni yambu hufuk angi wataméni, ‘Wuni Jisaska xékélakihambawuni.’ Wungi wamét séra watandé.” Wungi dé Jisas Pitaré wa. ");
INSERT INTO wos_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Jisas dé déka duré angi wa, “Hanja guniré wawuka yita guni yéwa, wur, su hura yihambanguni. Wun nukwa guni jondu nawulak fatiké wana?” Wungi wandéka di wa, “Yingafwe.” ");
INSERT INTO wos_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Wungi wandaka dé diré angi wa, “Némbuli wuni guniré angi we. Guni yéwa hura re guni yéwa hura yitanguni. Guni wur hura re guni wur hura yitanguni. Guni xi warendaka yar huruhafi re guni guna nukwa wur nak hwetaka yéwa hérae guni xi warendaka yar hératanguni. ");
INSERT INTO wos_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Guniré wuni we, wunika hayindan maki wuniré huruséketandi. Wun hundi angi dé: ‘Déka di wa, Dé akwi haraki saraki sémbut hurukwa du dé.’ Wunika hayindan maki xakutandé.” ");
INSERT INTO wos_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Wungi wandéka di wa, “Néma du, mé xé. Nani xi warendaka yar yéték nani hura re.” Wungi wandaka dé wa, “Wu yak.” ");
INSERT INTO wos_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Wun hundi wataka Jisas gwande dé Oliv némburé yi, séfélak nukwa hanja yindén maki. Déka du akwi di dé wali yi. ");
INSERT INTO wos_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Ye wun hafwambu xaakwa dé diré wa, “Guni Godré wakwexékétanguni, dé guniré yikafre hurundét guniré hurukwexé joo xakundémboka.” ");
INSERT INTO wos_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Wungi wandéka di rendaka dé motu nakindaka xakrikwa hafwaré maki dé yi. Ye dé hwati se Godré wata ");
INSERT INTO wos_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","dé angi wa, “Wuna yafa, méni mawuli ye, ané wunika yaakwa hanyandé mé héreki. Wungi ménika wuni we. Méni wuna mawuli yawukangalambu yamba hurukéméni. Méni mawuli yamékangalambu hurutaméni.” ");
INSERT INTO wos_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Wungi wandéka dé ensel nak Godna getéfambu gaye dé déré yikafre huru, dé hambuk yata jémba téndéte. ");
INSERT INTO wos_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Jisas déka mawulimbu dé némafwi hangéli hérae dé Godré wambula hambukmbu wakwexéké. Wakwexékéndéka dé wangér nyéki maki ye dé héfambu xakri. ");
INSERT INTO wos_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Jisas Godré wakwexékétaka raama te dé déka duka yi. Ye dé xé, di xéndi hwandaka. Deka mawulimbu némafwi xak yandéka di wungi xéndi hwa. ");
INSERT INTO wos_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Hwandaka xéta diré sérkenéta dé wa, “Guni métaka guni xéndi hwae? Guni sé raama Godré wakwexékétanguni, dé guniré yikafre hurundét guniré hurukwexé joo xakundémboka.” ");
INSERT INTO wos_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Jisas wun hundi wata téndéka, mé xé, séfélak du di ya. Jisasna du nak Judas yambumbu tale yindéka di wunde du ya. Judas Jisasré tamarunjoka dé Jisas téndénmbu xaku. ");
INSERT INTO wos_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Xakundéka dé Jisas déré wa, “Judas, méni Duna Nyan wuniré tamaruta méni mama duka hwetaméni wana?” ");
INSERT INTO wos_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Jisas wali téndé du di wun jooré xe di Jisasré hulukitendakaka xékélakita di Jisasré wa, “Néma Du, nani xi warendaka yarmbu diré xiyambete méni mawuli ye?” ");
INSERT INTO wos_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Wungi wataka deka du nak dé prisna néma duna jémba yakwa duré xiyaata déka yika tamba sakumbu téndé waan xatékéndéka dé xakri. ");
INSERT INTO wos_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Xakrindéka Jisas xéta dé wa, “Yak. Wungi hurukénguni.” Wungi wataka dé wun duna waanmbu hurundéka dé wun duré huréhaléké. ");
INSERT INTO wos_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Prisna néma du akwi, tempelna gélindu akwi, Israelna getéfana néma du akwi, wungi di ya, Jisasré huluke hura yinjoka. Yandaka dé Jisas diré wa, “Guni wuniré hura yinjoka yata métaka guni xi warendaka yar bangi akwi hura ya? Guni sélé héraata duré xiyaakwa duré hulukinjoka guni wun joo hura ya wana? ");
INSERT INTO wos_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Séfélak nukwa wuni tempelmbu guni wali rewuka guni wuniré hulukihambanguni. Wu yak, ané guna nukwa dé. Némbuli halékingambu guni hambuk hérae wungi huru.” ");
INSERT INTO wos_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Jisas wun hundi wandéka di déré huluke hura yi. Hura ye di prisna néma duna geré wulayi. Wulayindaka dé Pita deka hukémbu ye dé afakémbu té. ");
INSERT INTO wos_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Téndéka di Jisasré hura yindé du nawulak geka séndé gisangwandéndanmbu reta di ya xéréké. Xérékétaka rendaka dé Pita deka nyéndékmbu re. ");
INSERT INTO wos_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Rendéka lé jémba yakwa takwa hési déré xé. Xéta déka saawiré xéséfu naata lé wa, “Ané du akwi Jisas wali dé té.” ");
INSERT INTO wos_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Wungi waléka dé Pita wa, “Nyénawa, wuni déka xékélakihambawuni.” ");
INSERT INTO wos_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Wungi wandéka nawulak re hukémbu dé du nak déré xéta dé wa, “Méni akwi Jisasna du nak méni.” Wungi wandéka dé wa, “Ménawa, wuni yingafwe.” ");
INSERT INTO wos_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Wungi wandéka nawulak re hukémbu dé du nak akwi déré xéta dé hambukmbu wa, “Ané du akwi dé Galilimbu yandé du dé. Dé akwi dé Jisas wali té. Wun mwi hundi dé.” ");
INSERT INTO wos_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Wungi wandéka dé Pita wa, “Ménawa, wuni waméka hundika yike wuni ye.” Wungi wata téndéka dé séra nak bari wa. ");
INSERT INTO wos_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Wandéka dé Néma Du Jisas waleka dé Pitaré xé. Xéndéka dé Jisas déré tale wandén hundika wambula saréké. Tale Jisas dé déré wa, “Méni yambu hufuk wataméni, ‘Wuni Jisaska xékélakihambawuni.’ Wungi wamét séra watandé.” ");
INSERT INTO wos_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Wun hundika sarékéta Pita gwande némafwimbu saréfa naata dé géra. ");
INSERT INTO wos_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Jisasré hurundé du di déka bangwa hundi wata di déré xiyaata ");
INSERT INTO wos_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","déka damambu nukwa wurré gitaka di déré wa, “Méni profetna hundi naniré mé wa. Héndé méniré xiya?” ");
INSERT INTO wos_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Wungi wata di séfélak haraki hundi akwi déka wata di déka xiré husanda. ");
INSERT INTO wos_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Nukwa xalendéka di Israelna getéfana néma du, prisna néma du, xékélelakikwa du wungi yae di hérangwanda rendaka di Jisaska hatikwa du déré hura ya dika. Hura yandaka dé deka makambu té. ");
INSERT INTO wos_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Téndéka di déré wa, “Méni naniré mé wa. Méni God wasékendén du Krais, o yingafwe?” Wungi wandaka dé diré wa, “Wuni guniré wawut, guni wunika yamba sarékékénguni. ");
INSERT INTO wos_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Wuni guniré hundi wakwexékéwut, guni wuna hundi hasa yamba wakénguni. ");
INSERT INTO wos_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Némbuli Duna Nyan dé némafwi hambuk yakwa Godna yika tambambu retandé.” ");
INSERT INTO wos_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Wungi wandéka di atéfék wa, “Yingi méni we? Méni Godna nyan méni wana?” Wungi wandaka dé wa, “Xéxé. Wu wuni wuni.” ");
INSERT INTO wos_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Wungi wandéka di wa, “Déka hafu dé haraki hundi wandéka bu xékékwa. Xékétaka nani hurundén jonduka hundi nawulak akwi xékénjoka yamba hurukéme.” Wungi di wa, Jisaska. ");
INSERT INTO wos_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Wunde néma du di atéfék raama di Jisasré hura ye di Pailatna makambu taka. ");
INSERT INTO wos_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Takataka di Jisaska déré angi wa, “Ané du dé haraki sémbutka nana du takwaré wakweta dé diré wa, Romna néma du Sisarka yéwa hwendamboka. Wungi wata dé wa, ‘Wuni néma du wuni re. Wuni God wasékendén du Krais wuni.’ Wungi wandéka nani déré ménika hura ya.” ");
INSERT INTO wos_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Wungi wandaka dé Pailat Jisasré wakwexéké, “Méni Judana néma du méni?” Wungi wandéka dé Jisas wa, “Xéxé. Wamén hundi mwi hundi dé.” ");
INSERT INTO wos_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Wungi wandéka dé Pailat prisna néma duré akwi, wumbu téndé séfélak du takwaré akwi dé wa, “Ané dumbu haraki saraki sémbut nawulak xéhambawuni.” ");
INSERT INTO wos_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Wungi wandéka di hambukmbu wata di wa, “Dé déka hundi Judiambu rekwa atéfék du takwaré wandéka di jémba rehafi yata warenjoka di mawuli ya. Tale Galilimbu hundi wataka némbuli yae dé naniré wungi wa.” ");
INSERT INTO wos_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Pailat wun hundi xékétaka dé diré wakwexéké, “Ané du Galilina du wana?” ");
INSERT INTO wos_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Wungi wandéka di wa, “Yawundu.” Yawundu nandaka Pailat dé xékélaki. Herot dé Galilina héfambu rekwa du takwaka néma du rendéka dé Jisas déka ekombu dé re. Wun nukwa Herot akwi Jerusalemémbu dé re. Wungi xékélakita Pailat wandéka di Jisasré hura yi Herotka. ");
INSERT INTO wos_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Hanja Herot Jisaska hundi xékétaka déré xénjoka dé mawuli ya. Séfélak bafu re Jisasré xéhafi yandéka wun nukwa déré hura yandaka dé Herot xéta dé mawuli sawuli ya. Jisas hanja xéhafi yandén hambuk jémba nak déka makambu yandéte dé mawuli ya. ");
INSERT INTO wos_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Mawuli yata dé Jisasré séfélak jonduka wakwexéké. Wakwexékéndéka Jisas déka hundi nak hasa wahambandé. ");
INSERT INTO wos_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Buléhafi yandéka di prisna néma du akwi, xékélelakikwa du akwi wumbu téta di hambukmbu haraki hundi wa, Jisas hurundén jonduka. ");
INSERT INTO wos_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Wandaka Jisas Herotna hundi hasa wahafi yandéka dé Herot déka du wali di Jisasna xiré husandata di Jisaska bangwa hundi wata dé Herot wandéka di yikafre nukwa wur hérae Jisasré sandataka di déré wambula hura yi Pailatka. ");
INSERT INTO wos_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Hanja Pailat Herotna mama dé re. Pailat Herot hurundén jooré xéta yikafre mawuli yata wun nukwa male dé Herotna nyayika xakundéka dé Herot Pailatna nyayika dé xaku. ");
INSERT INTO wos_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Pailat wandéka di prisna néma du akwi, Israelna néma du akwi séfélak du takwa akwi yae di hérangwandé. ");
INSERT INTO wos_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","Hérangwandéndaka dé diré wa, “Guni ané duré wunika hura yae guni wa, ‘Dé du takwaré dé haraki hundi wa, di Romna gavman wali warendate.’ Wungi wanguka wuni guna makambu téta wuni déré wun jooka wakwexéké. Wakwexékétaka wuni guniré angi wa. Dé wangun haraki saraki sémbut huruhambandé. ");
INSERT INTO wos_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Herot akwi wungi male dé wa. Wungi wandéka di déré wambula hura ya wunika. Mé xéké. Dé haraki saraki sémbut huruhafi yandénka nani déré yamba xiyakéme, dé hiyandéte. ");
INSERT INTO wos_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Wuni wawut wuna du déré baka male xiyandat dé baka yitandé.” ");
INSERT INTO wos_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Atéfék héki hwari Pasovana hénoo sandaka nukwa dé Romna néma du séndé gembu hwakwa duré nak wandéka dé séndé ge yatakataka dé baka yi. ");
INSERT INTO wos_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Pailat wun hundi wandéka di wumbu téndé du takwa di atéfék wanjita di angi wa, “Ané duré hérekitaka méni Barabasré wamét dé séndé ge yatakataka baka yitandé.” ");
INSERT INTO wos_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Hanja wun du Barabas Romna duka hélék yata Jerusalemémbu rekwa du takwaré wandéka di Romna du wali ware. Nak nukwa Barabas du nakré xiyandéka dé hiya. Wungi hurundéka di déré séndé gembu takandaka dé wumbu hwa. ");
INSERT INTO wos_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Wumbu téndé du takwa wungi wandaka dé Pailat Jisas baka yindéte dé mawuli ya. Mawuli yata dé diré wambula wa, Jisas baka yitendékaka. ");
INSERT INTO wos_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Wandéka hélék yata di hambukmbu wata di wa, “Déré mimbu mé xiyae hateka. Déré mimbu mé xiyae hateka.” ");
INSERT INTO wos_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Wungi wandaka dé diré wambula wa, “Métaka we? Méta haraki saraki sémbut dé huru? Wuni démbu haraki saraki sémbut xéhambawuni. Xéhafi yawunka nani déré yamba xiyakéme, dé hiyandéte. Wuni wawut wuna du déré baka male xiyandat dé baka yitandé.” ");
INSERT INTO wos_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Wungi wandéka hélék yata di hambukmbu wata di wambula wambula wa, dé wandét di Jisasré xiyae mimbu hatekandate. Wungi wandaka deka hundi dé Pailatna hundiré sarékéngwandénjoka dé huru. ");
INSERT INTO wos_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Hurundéka dé Pailat yawundu nataka dé déka duré wa, di wunde du takwa wandaka maki hurundate. ");
INSERT INTO wos_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Wata dé wandéka mawuli yandan du Barabas séndé ge yatakataka gwande dé baka yi. Hanja Barabas du takwaré dé wa, di Romna du wali warendate. Nak nukwa Barabas du nakré xiyandéka dé hiya. Wungi hurundéka di déré séndé gembu takandaka dé wumbu hwa. Pailat Barabas jémba yindéte wataka dé wa, di Jisasré xiyae mimbu hatekandate. ");
INSERT INTO wos_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Romna xi warekwa du Jisasré hura yita di xé, Sairinimbu yandé du déka xi Saimon Jerusalemré wulayinjoka yandéka. Xéta déré huluke di wa, dé Jisasré xiyae hatekatendaka mi yate Jisasna hukémbu yindéte. Wandaka yate dé di wali yi. ");
INSERT INTO wos_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Yindaka di séfélak du takwa di Jisasna hukémbu yi. Yita di takwa nawulak saréfa naata di déka hambukmbu géra. ");
INSERT INTO wos_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Gérandaka Jisas waleka dé diré wa, “Guni Jerusalemémbu rekwa takwa, guni wunika gérakénguni. Guni guni hafuka, guna nyangwalka akwi gératanguni. ");
INSERT INTO wos_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Mé xéké. Haraki nukwa nawulak yandat du takwa angi watandi, ‘Nyan hérahafi yakwa takwa, nyangwalka munya hanja hwehafi yakwa takwa akwi yikafre mawuli yatandi, nyangwalka hatihafi yandanka.’ ");
INSERT INTO wos_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Wungi wata di némafwi némburé angi watandi, ‘Nanimbu mé xakri.’ Wungi wata di yalefu némburé angi watandi, ‘Naniré mé samétéfi.’ Wungi watandi. ");
INSERT INTO wos_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Di yikafre miré angina sémbut hurundat, di méta yatandi, réka yandéka miré?” Wungi dé Jisas wunde takwaré wa. ");
INSERT INTO wos_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Haraki saraki sémbut hurundé du yétékré akwi di xi warekwa du hura yi. Bérré Jisas wali xiyanjoka di hura yi. ");
INSERT INTO wos_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Hura ye di Anéngambana Afa wandan hafwambu xaku. Xaakwa wumbu di Jisasré xiyae mimbu hateka. Hatekataka di wun haraki saraki sémbut hurundén du yétékré akwi xiyae mi yétékmbu hateka. Nakré di Jisasna yika sakumbu xiyae hateka. Nakré di déka aki tamba sakumbu xiyae hateka. ");
INSERT INTO wos_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Jisasré xiyae mimbu hatekandaka dé Jisas wa, “Wuna yafa, di hurundaka jooka xékélakihambandi. Wungi maki méni wuniré hurundaka haraki saraki sémbutka sarékéhafi yata méni diré hasa yamba hwekéméni.” Wungi dé wa. Jisasré xiyae mimbu hatekataka di reta déka nukwa wur akwi sanda wur akwi muninjoka di deka xi haaye wurmbu lakwataka hérae di nak duna xi xé. Xétaka wun du Jisasna nukwa wur dé héra. ");
INSERT INTO wos_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Mune hérandaka di du takwa téta di xé. Xéndaka di Israelna néma du Jisasré wangita haraki hundi wata di wa, “Dé nak duré dé yikafre huru. Dé naniré yikafre hurundéte God wasékendén du Krais reta dé dé hafuré métaka yikafre hurundé.” ");
INSERT INTO wos_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Wungi wandaka di xi warekwa du akwi déka wangita haraki hundi wata déka yae nyingi yakwa wain hulingu di hweta ");
INSERT INTO wos_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","di wa, “Méni Judana néma du reta méni méni hafuré mé yikafre huru.” ");
INSERT INTO wos_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Jisasré xiyae hatekandan mi anwarmbu haaye takandan hundi angi dé: Ané du Judana néma du dé. ");
INSERT INTO wos_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Jisas wali xiyae mimbu hatekandan du nak dé Jisasré haraki hundi wata dé wa, “Méni naniré yikafre huruméte God wasékendén du Krais wana? Méni Krais reta méni méni hafuré mé yikafre huruta aniré akwi yikafre huru.” ");
INSERT INTO wos_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Wungi wandéka dé Jisas wali xiyae mimbu hatekandan nak du wun duré haraki hundi wata dé wa, “Jisas hiyandéte wandaka maki di ménika akwi wa, méni hiyaméte. Hiyatemékaka, métaka méni Godka akwi roohafi ye? ");
INSERT INTO wos_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Haraki saraki sémbut hurunanka di aniré xiya. Wungi sékérékétandé. Ané du dé haraki saraki sémbut nawulak huruhambandé.” ");
INSERT INTO wos_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Wungi wataka dé wa, “Jisas, méni du takwaka hatinjoka néma du reta méni wunika wambula mé sarékétaméni.” ");
INSERT INTO wos_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Wungi wandéka dé Jisas wa, “Mwi hundi wuni méniré wa. Ané nukwa male méni wuni wali Godna yikafre hafwambu retaméni.” Wungi dé Jisas déré wa. ");
INSERT INTO wos_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","45","Nukwa dawimbu téndéka dé atéfék héfambu gan hunyi. Hunye téndéka nukwa xéhambandé. Hukémbu nukwa tengura nandinjoka yandéka dé tempelmbu lékitakandan séményi nukwa wur nyéndékmbu léngae dé també yéték xaku. ");
INSERT INTO wos_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Xakundéka dé Jisas hambukmbu wanjita dé angi wa, “Wuna yafa, wuna hamwinya ména tambambu wuni take.” Wungi wataka dé hiya. ");
INSERT INTO wos_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Hiyandéka dé xi warekwa duna néma du xéta Godna ximbu harékéta dé wa, “Wun du yikafre sémbut male hurundé du dé. Wu mwi hundi dé.” Wungi dé wa. ");
INSERT INTO wos_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Wun joo xénjoka yae hérangwanda téndé atéfék du takwa Jisas hiyandéka xéta némafwimbu saréfa naata di deka getéfaré wambula yi. ");
INSERT INTO wos_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Yindaka Jisaska xékélakindé du akwi, takwa nawulak akwi wungi di afaké maki téta di wun jondu yandéka di xé. Hanja Jisas Galili yatakataka yandéka di wunde takwa dé wali di ya. ");
INSERT INTO wos_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","51","Arimateambu yandé du nak déka xi Josep dé re. Déka getéfa Judana getéfa nak dé. Dé yikafre sémbut male hurukwa du reta, dé God néma du reta du takwaka hatitendéka nukwaka dé haxé. Dé Israelna néma du nak reta nawulak néma du wali hérangwanda reta, Jisasré xiyanjoka buléndan hundika yawundu nahambandé. ");
INSERT INTO wos_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Wun du dé Pailatka ye dé Jisasna fusa héranjoka wakwexéké. ");
INSERT INTO wos_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Wakwexékéndéka dé yawundu nandéka ye dé Jisasna fusa lukwa hura gaye dé wama nukwa wurmbu banyitaka dé motumbu xandan wekwa nakmbu taka. Hanja wun wekwambu di hiyandé du nakré takahambandi. ");
INSERT INTO wos_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Gérambu dé Josep Jisasna fusa wekwambu takandéka dé Judana baka hwa nukwa yanjoka ya. ");
INSERT INTO wos_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Galilimbu Jisas wali yandé takwa di Josepna hukémbu ye di xé Jisasna fusa takandénéngala. Takandén hafwa akwi di jémba xé. ");
INSERT INTO wos_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Xétaka getéfaré wambula ye di fusambu takanjoka yikafre yama yakwa joo humbwi. Baka hwa nukwambu di Moses wandén hambuk hundi wandén maki di baka hwa. ");
INSERT INTO wos_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Baka hwa nukwa yindéka Sande ganémbambu nukwa xalenjoka yandéka wunde takwa di humbwindan yikafre yama xaakwa joo hérae hura di yi. Jisasna fusa takandén hafwaré di yi. ");
INSERT INTO wos_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Ye di xé wekwambu takatéfindan motu sérmena takandéka rendéka. ");
INSERT INTO wos_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Xétaka di wekwaré wulaaye di Néma Du Jisasna fusaré xéhambandi. ");
INSERT INTO wos_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Xéhafi yataka wun jooka saré warékéta wumbu téndaka du yéték bari xaakwa bér di wali té. Bérka nukwa wur wama male yata dé némafwimbu hanyi. ");
INSERT INTO wos_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Témbéka di roota di hwati se deka saawi héfambu taka. Takandaka bér wa, “Métaka we guni hiyandé duna hafwambu huli rekwa duka hwaké? ");
INSERT INTO wos_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Dé ambu rehambwe. Dé wambula dé ramé. Dé Galilimbu guniré wandén hundika mé saréké. ");
INSERT INTO wos_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","Dé angi dé wa, ‘Di Duna Nyan wuniré haraki saraki sémbut hurukwa duna tambambu takandat di wuniré xiyae mimbu hatekandat wuni hiyae nukwa hufuk wumbu hwae wambula ramétawuni.’ Wungi dé wa.” ");
INSERT INTO wos_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Di bérka hundi xékétaka di wunde takwa Jisas hanja wandén hundika wambula saréké. ");
INSERT INTO wos_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Sarékéta di fusa takandan wekwa yatakataka di wambula ye di Jisasna du tamba yéti man natafa diré wun jooka wa. Jisasna du takwa nawulakré akwi di wun jooka wa. ");
INSERT INTO wos_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Jisasna duré wun hundi wandé takwa di Makdalambu yalé takwa Maria, Joana, Jemsna ayiwa Maria, takwa nawulak akwi. ");
INSERT INTO wos_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Di wun hundi wandaka di Jisasna du wa, “Wu wangété duna hundi male di bulé.” Wungi wataka di deka hundi xékéhambandi. ");
INSERT INTO wos_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Xékéhafi yandaka dé Pita raama dé Jisasna fusa takandan hafwaré fétékéra yi. Ye hwaséleka yasalo dé xé fusa banyitakandan nukwa wur male rendéka. Xétaka déka geré wambula ye dé wun jooka saré waréké xéké. ");
INSERT INTO wos_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Wun nukwa bér hanja Jisas wali yitaka yatakandé du yéték Emeusré yindaka yambumbu yi. Du Jerusalem yatakataka wun getéfaré yita afaké maki yitandi (11 kilomita). ");
INSERT INTO wos_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Bér yita bér xakundan atéfék jonduka bér hafu hundi bulé. ");
INSERT INTO wos_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Buléta yimbéka dé Jisas hafu yae dé bér wali yi. ");
INSERT INTO wos_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Yindéka déré xéta bér déka xékélakihambambér, God déka saawi bérka damambu fakundénka. ");
INSERT INTO wos_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Xékélakihafi yambéka dé bérré wa, “Béni yita bulémbéka hundi méta maki hundi dé?” Wungi wandéka bér Jisas hiyandénka sarékéta némafwimbu saréfa naata bér té. ");
INSERT INTO wos_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Téta du nak déka xi Kliopas dé déka hundi hasa wata dé wa, “Nak téfambu yandé séfélak du takwa Jerusalemémbu némbuli reta di xékélaki, hurundan jonduka. Méni, nak téfambu yandé du, méni hafu ande nukwambu Jerusalemémbu hurundan jonduka méni xékélakihafi ye wana?” ");
INSERT INTO wos_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Wun hundi wandéka dé Jisas bérré wakwexéké, “Méta jondu?” Wungi wandéka bér déré wa, “Nasaretna du Jisasré di wun jondu huru. Dé wun Godna profet nak reta dé Godna makambu akwi séfélak du takwana makambu akwi téta dé yikafre male hambuk jémba yata némafwi hundi wa. ");
INSERT INTO wos_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Wandéka di prisna néma du akwi, nana néma du akwi déré di hwe Romna duka, di déré xiyandate. Hwendaka di déré xiyae mimbu hatekandaka dé hiya. ");
INSERT INTO wos_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Tale nana mawulimbu angi nani wa, ‘Wun du nani Israelna du takwa naniré hérae naniré yikafre hurutandé.’ Wungi wambeka di déré xiya. Wun jooka hundi buléta ané jooka akwi ani bulé. Nanga di Jisasré xiyandaka nukwa yéték yindéka némbuli nukwa hufuk dé ya. ");
INSERT INTO wos_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Nak jooka akwi ani hundi bulé. Némbuli nani wali Jisasna hukémbu yindé takwa nawulak hundi wandaka nani waréngéné. Ganémbambu di déka fusa takandan hafwaré di yi. ");
INSERT INTO wos_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","Ye di déka fusaré xéhambandi. Xéhafi yataka wambula yae di naniré angi akwi wa, ‘Nani ye janji maki enselré xémbeka bér angi wa, Dé wambula dé ramé. Wungi bér wa.’ ");
INSERT INTO wos_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Wunde takwa yae naniré wungi wandaka di nana du nawulak yi, Jisasna fusa takandan hafwaré. Ye di wunde takwa wandan maki xé. Xéta di Jisasré xéhambandi.” ");
INSERT INTO wos_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Wun hundi wambéka dé Jisas bérré wa, “Béni wangété du béni. Béna mawuli jémba téhafi yandéka béni profet hanja wandan hundi nawulak male béni xéké. ");
INSERT INTO wos_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Wunde du di angi wa, ‘Tale di God wasékendén du Kraisré haraki hurundat dé hangéli hérae hukémbu dé néma du reta nukwa hanyikwa maki hanyitandé.’ Wungi wandan hundi béni xékéhambambéni.” ");
INSERT INTO wos_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Wungi wataka dé tale Moses hayindén hundimbu hukémbu atéfék Godna profet hayindan hundimbu akwi dé bérré Godna nyingambu rendén hundika wakwe, démbu xakundén jooka. ");
INSERT INTO wos_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Yambumbu yita bér yitembéka getéfa di xakunjoka ya. Ye xaakwa dé Jisas nawulak akwi yinjoka dé yi. ");
INSERT INTO wos_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Yindéka bér déré wa, “Wu gérambu dé. Gan bari hunyitandé. Méni ani wali retaméni.” Wungi wambéka dé wulaaye dé bér wali re. ");
INSERT INTO wos_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Reta hénoo sanjoka reta dé bret hérae dé Godka diména nataka dé bret fukae dé bérka hwe. ");
INSERT INTO wos_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Hwendéka bérka dama bari landéka bér déka xékélaki. Xékélakimbéka dé bari faku. Bér déré xéhambambér. ");
INSERT INTO wos_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Xéhafi yata bér hafu hundi buléta angi wa, “Ani yambumbu yinaka dé ani wali buléta Godna nyingambu rekwa hundika aniré wandéka, dé ana mawulimbu ya maki dé yané. Wu mwi hundi dé.” ");
INSERT INTO wos_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Wungi wataka bér bari raama Jerusalemré wambula yi. Ye bér xé Jisasna du tamba yéti manmbu natafa akwi di wali rendé du takwa wali hérangwanda rendaka. ");
INSERT INTO wos_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Xémbéka di bérré wa, “Nana Néma Du wambula dé ramé. Wu mwi hundi dé. Raméndéka Saimon dé déré xé.” ");
INSERT INTO wos_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Wungi wandaka bér yambumbu yita Jisas bérka yandénka bér hundi wa. Jisas bér wali reta bret fukandéka wun nukwa male déka xékélakimbénka akwi bér diré wa. ");
INSERT INTO wos_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Bér wun hundi wata témbéka dé Jisas hafu yae dé deka nyéndékmbu té. Téta dé wa, “Guna mawuli nakélak mé téndé.” ");
INSERT INTO wos_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Wungi wandéka di waréngéna roota di deka mawulimbu wa, “Wu gambaré nani xé.” ");
INSERT INTO wos_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Wungi wandaka dé diré wa, “Métaka guni waréngéné? Métaka guni guna mawulimbu saréké waréké? ");
INSERT INTO wos_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Wuna man tambaré xéta ramimbu xiyandan mé xé. Wuniré huruta xéta xékélakitanguni. Ané wuni wuni té. Wuni gamba yingafwe. Gamba di séfi afa hura téhambandi, wuni hura téwuka maki.” ");
INSERT INTO wos_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Wungi wataka déka man tamba dé diré wakwe, di ramimbu xiyandan xéndate. ");
INSERT INTO wos_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Jisasna du déré xéta di saréké warékéta yikafre mawuli yata mawuli sawuli yata di deka mawulimbu wa, “Yingi maki dé? Ané hiyae raméndé du Jisas, o héndé?” Wungi sarékéndaka dé diré wakwexéké, “Guni ambu hénoo nawulak guni taka?” ");
INSERT INTO wos_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Wungi wakwexékéndéka di tuwa takandan xéri hamwi déka hwe. ");
INSERT INTO wos_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Hwendaka dé hérae deka makambu sandéka di xé. ");
INSERT INTO wos_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Wun xéri hamwi sataka dé diré wa, “Hanja wuni guni wali reta guniré wuni angi wa, ‘Hanja Moses wunika hayindéka, Godna profet akwi wunika di hayi. Godna nyingambu rekwa gwarmbu akwi di wunika hayi. Wunika hayindan maki huruséketandi.’ Wungi wawuka némbuli wun hundi mwi hundi dé ya.” ");
INSERT INTO wos_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Wungi wataka dé deka mawuliré yikafre huru, di Godna nyingambu rekwa hundika jémba xékélakindate. ");
INSERT INTO wos_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Huruta dé diré wa, “Godna nyingambu ané hundi dé re: ‘God wasékendén du Krais némafwi hangéli hérae hiyatandé. Hiyae nukwa hufuk wumbu hwataka wambula ramétandé. ");
INSERT INTO wos_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Raméndét déka du déka ximbu du takwaré watandi, di hurundan haraki saraki sémbutka hélék ye yatakandat, God hurundan haraki saraki sémbut yakwanyindéte. Wun hundi Jerusalemémbu rekwa du takwaré tale wata hukémbu di atéfék héfambu rekwa du takwaré akwi wun hundi watandi. ");
INSERT INTO wos_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Guni hafu wun jondu atéfék wundé xéngu. Xétaka wun jonduka watanguni. ");
INSERT INTO wos_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Mé xéké. Wuni wuna yafa wasékérékéndén Hamwinya gunika hwetawuni. Tale guni Jerusalemémbu déka haxétanguni. Haxéngut Godna Hamwinya anwarmbu gaye gunika hambuk hwendét guni wun jonduka watanguni.” ");
INSERT INTO wos_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Wun hundi wataka dé Jisas diré hura Jerusalem yatakataka di Betaniré yi. Ye Betanimbu xaakwa dé déka tamba harékéta dé Godré wakwexéké, dé diré yikafre hurundéte. ");
INSERT INTO wos_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Dé wakwexékéta téta dé diré yatakandéka dé God déré déka getéfaré hura wari. ");
INSERT INTO wos_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Warindéka di yikafre mawuli yata némafwimbu mawuli sawuli yata di Jerusalemré wambula yi. ");
INSERT INTO wos_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Ye atéfék nukwa tempelmbu téta di Godna ximbu haréké. ");
INSERT INTO wos_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Hanja nyir héfa atéfék jondu xakuhafi yandéka Hundi dé re. Dé God wali dé re. Dé hafu dé God dé. ");
INSERT INTO wos_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Hanja talembu Hundi dé God wali re. ");
INSERT INTO wos_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Rendéka God wandéka dé hafu dé nyir héfa atéfék jonduré hurataka. Nak joo hafu xakuhambandé. Atéfék jonduré Hundi male dé hurataka. ");
INSERT INTO wos_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Dé huli mawuli hwekwa du dé. Wun huli mawuli dé ya hanyindéka maki du takwana mawulimbu dé hanyi, di Godka jémba xékélakindate. ");
INSERT INTO wos_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Wun hanyikwa ya dé halékingambu dé hanyita té. Halékinga wun hanyikwa yaré yamba yasékunyikéndé. ");
INSERT INTO wos_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","God du nakéka wandéka dé ya. Wun duna xi Jon dé. ");
INSERT INTO wos_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Dé du takwaré wun hanyikwa yaka hundi wanjoka dé ya. Du takwa wun hanyikwa ya maki duka jémba sarékéta déka hundika “Mwi hundi dé” nandate dé Jon wun hundi wa. ");
INSERT INTO wos_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Dé wun xéréka hanyikwa ya maki duka dé du takwaré hundi wanjoka ya. Dé wumba hanyikwa ya maki du yingafwe. ");
INSERT INTO wos_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Wun hanyikwa ya dé natafa male dé. Dé atéfék du takwana mawulimbu hanyinjoka dé ané héfaré gaya, di Godka jémba xékélakindate. ");
INSERT INTO wos_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Tale wun hundi dé ané héfaré hurataka. Huratakataka dé ané héfaré gayandéka di ané héfambu rekwa du takwa déka xékélakihambandi. ");
INSERT INTO wos_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Déka motéfaré dé gaya. Gayandéka déka getéfana du takwa déka hundi xékéhafi yata déka hélék di ya. ");
INSERT INTO wos_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Nawulak di déka hundi jémba xéké. Xékéta di wa, “Dé nana néma du dé.” Wungi wandaka dé wandéka di Godna nyangwal di xaku. Déka xina hambukéka jémba sarékékwa du takwa di Godna nyangwal di xaku. ");
INSERT INTO wos_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Deka ayiwa yafa dika mawuli yandaka ayiwa diré hérandaka di Godna nyangwal xaku, wana héfambu rekwa du nak wandéka di Godna nyangwal xaku wana? Wungi yingafwe. God hafu wandéka di déka nyangwal di xaku. ");
INSERT INTO wos_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Hundi du xaakwa dé nana héfaré gaya. Gaye dé nani wali re. Reta naniré yikafre huruta dé mwi hundi male wa. Wandéka déré xéta nani wa, “God dé déré déka hambuk hwe. Hwetaka wandéka dé gaya. Dé hafu dé Godna nyan dé. Du nak dé hurundén maki yamba hurukéndé.” Wungi nani wa. ");
INSERT INTO wos_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Jon wun du yandéka xéta dé wa, “Déré mé xé. Hanja ané duka wuni guniré wa, ‘Wuna hukémbu yatekwa du dé néma du dé. Wuni baka du wuni tale ya. Wuniré ayiwa hérahafi yaléka hanja wun du dé re.’ Wungi wuni déka we.” Jon wungi dé wa. ");
INSERT INTO wos_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Godna saréfana Hundimbu dé sukweka té. Téndéka dé Hundi naniré yikafre huru. Hura dé naniré wambula yikafre huru. ");
INSERT INTO wos_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Hanja God wandéka dé Moses Godna hambuk hundi dé du takwaré wa. Hukémbu Godna saréfana Godna mwi hundi Jisas Kraismbu dé xaku. ");
INSERT INTO wos_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Du nak Godré xéhafi yata déka jémba xékélakihambandé. Déka natafa male nyan Jisas dé wali re xétaka dé déka jémba xékélaki. Xékélake gaye dé naniré yikafre hundi wakwe, déka yafa Godka. Wakwendéka nani Godka jémba xékélaki. ");
INSERT INTO wos_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Jon téndéka di Judana néma du di pris nawulak Livaina duré nawulak wungi wandaka di Jerusalemémbu yae di Jonka wakwexéké, “Méni héndé?” ");
INSERT INTO wos_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Wungi wakwexékéndaka dé Jon wa, “Wuni God wasékendén du Krais yingafwe.” Wungi wata mwi hundi dé wa. Hundi fakuhambandé. ");
INSERT INTO wos_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Wandéka di déré wambula wakwexéké, “Méni héndé méni? Méni elaija wana héndé wana?” Wungi wakwexékéndaka dé Jon wa, “Yinga! Wuni elaija yingafwe.” Wungi wandéka di wambula wa, “Méni nani haxéta témbeka profet méni?” Wungi wakwexékéndaka dé Jon wa, “Yingafwe.” ");
INSERT INTO wos_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Wungi wandéka di déré wambula wakwexéké, “Méni héndé? Du nawulak di naniré wandaka nani ya. Nani wambula ye diré yingi wakéme? Méni hafuka yingi méni we?” ");
INSERT INTO wos_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Wungi wakwexékéndaka dé Jon wa, “Wuni du rehafi hafwambu téta hundi wakwa du wuni. Wuni du rehafi hafwambu téta angi wuni we, ‘Néma Du yatendéka yambu hurutanguni.’ Hanja profet Aisaia wun hundi Godna nyingambu hayindéka némbuli wuni yae wuni wun hundika we.” Jon dé wungi wa. ");
INSERT INTO wos_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Hanja Farisi diré wandaka di ya. ");
INSERT INTO wos_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Yae di Jonéna hundi xékétaka di déré wakwexéké, “Du takwa deka haraki saraki mawuli yatakandaka méni Godna ximbu diré guré husanda. Métaka méni wungi huru? Méni elaija yingafwe. Méni God wasékendén du Krais yingafwe. Méni haxéta témbeka profet yingafwe. Méni baka du méni, métaka méni Godna ximbu diré guré husanda?” ");
INSERT INTO wos_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Wungi wakwexékéndaka dé Jon wa, “Wuni Godna ximbu wuni diré guré husande. Ané yikama jémba male dé. Néma du nak guni wali dé re. Guni déka xékélakihambanguni. ");
INSERT INTO wos_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Dé wuna hukémbu yatandé. Yae dé hambuk jémba yatandé. Dé néma du dé. Wuni baka du wuni, yingi maki nae déka jémba yatawuni? Wuni déka manmbu sandandéka suna yoo yingi nae lukukéwuni?” Wungi dé wa. ");
INSERT INTO wos_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Betanimbu reta dé Jon wun hundi bulé. Wun getéfa jordan xéri angé sakumbu dé té. Wumbu reta dé Godna ximbu du takwaré guré husanda. ");
INSERT INTO wos_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Nukwa nak yindéka Jon téta dé xé, Jisas dé rendén hafwambu yandéka. Yandéka Jon déré xe dé wa, “Guni atéfék ané duré mé xé. Dé Godna sipsip balina nyan dé. Dé ané héfambu rekwa du takwana haraki saraki sémbut hérekinjoka hiyatandé. ");
INSERT INTO wos_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Hanja wun duka guniré angi wuni wa, ‘Wuna hukémbu yatekwa du dé néma du dé. Wuni baka du wuni tale ya. Wuniré ayiwa hérahafi yaléka hanja wun du dé re.’ Wungi wuni wa. ");
INSERT INTO wos_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Hanja déka xékélakihambawuni. Némbuli male déka wuni xékélaki. Déka guniré hundi wata wuni Godna ximbu guniré guré husanda. Guni israel ané duka xékélakingute wuni wungi huru.” ");
INSERT INTO wos_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Jon xéndén jooka wata dé Jisaska angi wa, “Godna hamwinya nyamwe afwi maki dé Godna getéfambu gaye dé wun dumbu té. ");
INSERT INTO wos_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Tale wuni wun duka xékélakihambawuni. Xékélakihafi yawuka God wuniré dé angi wa, ‘Wuna Hamwinya gaye du nak wali téndét xe xékélakitaméni. Wun du wandét wuna Hamwinya du takwana mawulimbu wulayitandé.’ ");
INSERT INTO wos_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Wandén maki wundé xéwu. Xe wuni xékélaki, dé Godna nyan dé. Wuni xékélake wuni guniré hundi we.” Wungi dé Jon wa. ");
INSERT INTO wos_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Nak nukwa yindéka dé Jon wambula téndéka déka du yéték akwi bér dé wali té. ");
INSERT INTO wos_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Témbéka dé Jon xé, Jisas yindéka. Xe dé wa, “Mé xé. Dé Godna sipsip balina nyan dé.” ");
INSERT INTO wos_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Wungi wandéka bér Jisasna hukémbu yi. ");
INSERT INTO wos_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Yimbéka Jisas waleka dé xé, déka hukémbu yimbéka. Xe dé bérka wa, “Métaka béni hwaké?” Wungi wakwexékéndéka bér wa, “Rabai, yén gembu méni re?” (Wun hundi Rabai nana hundimbu angi di wa, “Godna hundika wakwekwa du.”) ");
INSERT INTO wos_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Wungi wambéka dé wa, “Mé yae xétambéni.” Wungi wandéka ye bér xé, dé rendéka ge téndéka. Xétaka wun nukwa bér dé wali re. Gérambu yandéka bér yihambambér. ");
INSERT INTO wos_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Bér Jonéna hundi xékétaka bér Jisasna hukémbu yi. Du nak déka xi Andru dé Saimonéna bandi dé. Saimonéna nak xi Pita dé. ");
INSERT INTO wos_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Andru Jisasré yatakataka bari ye dé Saimonka hwaka xe dé wa, “Ani Mesaiaré wundé xéna.” Wungi dé wa. Wun xi Mesaia nana hundimbu angi dé: God wasékendén du Krais. ");
INSERT INTO wos_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Wataka dé Andru Saimonré hura yi Jisaska. Hura yindéka Jisas Saimonré xe dé wa, “Méni Jonéna nyan Saimon méni. Hukémbu ménika angi watame, Sifas.” Wungi dé Jisas wa. Wun xi, Sifas, Grikna hundimbu angi dé, Pita. Nana hundimbu angi dé, Motu. ");
INSERT INTO wos_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Nak nukwa dé Jisas Galiliré yinjoka dé saréké. Saréka ye Filipré xe dé wa, “Méni wuni wali mé ya.” ");
INSERT INTO wos_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Filip Betsaidambu dé ya. Betsaida Andru bér Pitana motéfa akwi dé. ");
INSERT INTO wos_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Wungi wandéka dé Filip ye dé Natanielka hwaké. Hwaka xe dé déré wa, “Hanja nana mandéka Moses Godna profet nawulak akwi di du nakéka Godna nyingambu hayi. Wun duré wundé xékwa. Wun du Nasaretna du Jisas dé. Dé josepna nyan dé.” ");
INSERT INTO wos_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Wungi wandéka dé Nataniel déré wa, “Nasaret haraki getéfa dé. Yingi maki nae yikafre du Nasaretmbu xaletandé?” Wungi wandéka dé Filip wa, “Méni mé yae xé.” Wungi wandéka dé yi. ");
INSERT INTO wos_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Nataniel yandéka Jisas xéta dé déka angi wa, “Mé xé. israelna yikafre du nak andé yae. Yénataka hundi wahafindé.” ");
INSERT INTO wos_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Wungi wandéka dé Nataniel wa, “Yingi maki ye méni wunika xékélaki?” Wungi wakwexékéndéka dé Jisas déré wa, “Filip ménika wahafi yandéka méni wun hambingal mi mombu afakémbu reméka wuni xe ménika wundé xékélakiwu.” ");
INSERT INTO wos_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Wungi wandéka dé Nataniel wa, “Wakwekwe du, méni Godna nyan méni. Méni nani israelna néma du méni.” ");
INSERT INTO wos_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Wungi wandéka dé wa, “Méniré wun mi mombu reméka xéwunka wuni we. Wawuka némbuli wunika méni jémba saréké. Hukémbu xéteméka joo yae némbuli xéméka jooré sarékéngwandétandé.” ");
INSERT INTO wos_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Wungi wataka dé déré wa, “Mwi hundimbu wuni guniré we. Hukémbu guni xétanguni, Godna getéfa nafwindét déka ensel wari gayandat wuni Duna Nyanka.” Wungi dé Jisas wa. ");
INSERT INTO wos_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Nukwa yéték yindéka dé du nak takwa héra Kanambu. Wun getéfa Galilimbu dé té. Jisasna ayiwa takwa hérandéka xénjoka lé wumbu re. ");
INSERT INTO wos_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Takwa hératekwa du dé Jisaska hundi taka, Jisas déka du wali yandate. ");
INSERT INTO wos_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Yae rendaka hukémbu dé wain hulingu wungi hényi. Hényindéka lé Jisasna ayiwa déré wa, “Di wain hulingu yingafwe.” ");
INSERT INTO wos_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Wungi waléka dé Jisas wa, “Wuna ayiwa, métaka we nyéni wun jooka wuniré wa. Wuna jémba yatewuka nukwa wayika yakéndé.” ");
INSERT INTO wos_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Wungi wandéka lé Jisasna ayiwa jémba yakwa duré wa, “Guniré hundi wandét, guni déka hundi xékéta guni wandén maki hurutanguni.” Wungi lé diré wa. ");
INSERT INTO wos_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Judana du deka hambuk hundi xékéta di man tamba jémba yakwanyi. Wun gembu rekwa du wungi man tamba yakwanyindate di motumbu bérandan aki gwongofu wungi di té. Wun aki némafwi di (100 lita maki di). ");
INSERT INTO wos_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Jisas dé jémba yakwa duré wa, “Wun akimbu hulingu mé guni wukasanda.” Wungi wandéka di hulingu wukasandandaka dé sukweka té. ");
INSERT INTO wos_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Sukwekéndéka dé diré wa, “Nawulak mé tuwa hura yi, hénooka hatikwa duka.” Wungi wandéka di tuwa hura yi. ");
INSERT INTO wos_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Hura yindaka dé hénooka hatikwa du dé wun hulingu sakwexé. Wun hulingu dé wain hulingu xaku. Sakwexe wun wain hulinguka xékélakihafi yandéka di jémba yakwa du di xékélaki, wun wain hulinguka. ");
INSERT INTO wos_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","Xékélakihafi yata dé hénooka hatikwa du dé takwa hérandé duré wandéka yandéka dé déré wa, “Atéfék du yikafre wain hulingu di tale hwe. Hwendaka du séfélak wain hulingu sandaka hukémbu di haraki wain hulingu hwe. Méni yikafre wain hulingu fakutaka tale haraki wain hulingu méni hwe. Hukémbu yikafre wain hulingu hweméka nani jémba sa. Wun yikafre wain hulingu dé.” Wungi dé wa. ");
INSERT INTO wos_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Wun nukwa dé Jisas tale hanja xéhafi yandan hambuk jémba dé ya. Kanambu dé wun hambuk jémba ya. God déka hambuk hwendéka wun hambukmbu jémba yandéka déka du di xé. Xe di déka xékélakita di déka du déka jémba sarékéta di wa, “Wun du Godna nyan dé. Wu mwi hundi dé.” Wungi di wa. ");
INSERT INTO wos_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Wun hénoo sataka dé Jisas, déka ayiwa, déka bandingu, déka du, wungi di yi kaperneamré. Ye nukwa nawulak di wun getéfambu re. ");
INSERT INTO wos_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Judana némafwi nukwa Pasova xakundéka dé Jisas Jerusalemré yi. ");
INSERT INTO wos_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Ye dé tempelré wulaaye dé Jisas xé, du nawulak jémba yandaka. Di yéwa héraata di sipsip bali bulmakau bali afwi hwe, di pris xiyae Godka hwendate. Du nawulak di nak téfana yéwa héraata di wun getéfana yéwa dika hwe. ");
INSERT INTO wos_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Di wungi hurundaka dé Jisas xé. Xétaka hélék yata dé yikama yoo nawulak hérae dé hambuk yoombu léki. Lékitaka hura téta dé wumbu rendé du, sipsip bali, bulmakau bali, atéfékré dé héreki. Hérekita dé yéwa hérandan jambé yanguréka yakita wun yéwa blekéndéka dé xakri. ");
INSERT INTO wos_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Xakrindéka dé afwi hura téndé duré wa, “Wun afwi sa hura yi. Guni wuna yafana ge jondu hérandaka ge maki hurukénguni.” Wungi dé Jisas wa. ");
INSERT INTO wos_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Jisas wungi hurundéka di déka du ané Godna nyingambu rekwa hundika di saréké: “God, wuni ména geka wuni némafwimbu mawuli ye. Yawuka wuna mawulimbu ya maki dé yané. Yanéndéka ména ge jémba téndéte hambuk jémba wuni ya.” Wun hundika di saréké. ");
INSERT INTO wos_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Jisas wungi hurundéka di Judana néma du wun jooré xe di wa, “God ménika hambuk hwendéka méni wungi huru, o yingi maki dé? Méta hanja xéhafi yamben hambuk jémba yamét xe ména hambukéka xékélakitame.” ");
INSERT INTO wos_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Wungi wandaka dé Jisas diré wa, “Guni ané yikafre geré glaréngut nukwa hufuk yindét wuni wambula totawuni.” ");
INSERT INTO wos_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Wungi wandéka di wa, “Séfélak (46) héki hwari di ané tempel to. Yinga maki ye nukwa hufukmbu wambula totaméni?” Wungi di néma du wa Jisasré. ");
INSERT INTO wos_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Jisas wungi wata déka séfika dé sataku hundi wa. Tempelka wahambandé. ");
INSERT INTO wos_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Wataka hukémbu hiyandéka nukwa hufuk yindéka God wandéka dé wambula ramé. Raméndéka di déka du wun nukwa wandén hundika wambula saréké. Sarékéta di Godna nyingambu hanja hayindan hundi akwi Jisas wandén hundika akwi sarékéta di wa, “Wu mwi hundi dé.” Wungi di wa. ");
INSERT INTO wos_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Wun Pasovana nukwa Jisas Jerusalemémbu dé re. Reta hanja xéhafi yandan hambuk jémba yandéka di séfélak du takwa di xé. Xe di wa, “Dé Godna nyan dé.” ");
INSERT INTO wos_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Wungi wandaka dé Jisas deka mawulika dé xékélaki. Deka hundi baka hundi dé. Déka jémba sarékéhambandi. Wungi xékélake dé dé hafuka diré wafuke wahambandé. ");
INSERT INTO wos_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Dé atéfék du takwana mawulika dé xékélaki. Du nak déré wakwehambandé, deka mawulika. Dé hafu dé deka mawulika xékélaki. ");
INSERT INTO wos_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Judana néma du nak dé re. Déka xi Nikodemus dé. Wun du Farisina du dé. ");
INSERT INTO wos_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Nak gan wun du Jisaska ye dé déré wa, “Wakwekwa du, God méniré wandéka méni ya, déka hundika naniré wakwenjoka. Nani wundé xékélakikwa. Baka du méni yamén maki hanja xéhafi yamben hambuk jémba yamba yakéndé. God méni wali téndéka méni wun hambuk jémba ya.” ");
INSERT INTO wos_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Dé wungi wandéka dé Jisas déré wa, “Mwi hundi wuni méniré we. Du takwa huli wambula xakuhafi yandat, dé God néma du reta diré jémba yamba hatikéndé. Hatihafi yandét, di Godna du takwa yamba rekéndi.” ");
INSERT INTO wos_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Wungi wandéka dé wakwexéké, “Du takwa gwalefa ye yingi maki ye di huli wambula xakutandi? Wafewana, di yikama nyangwal maki re ayiwana biyakombu wulayindat ayiwa wambula hératalé, o yingi maki dé?” ");
INSERT INTO wos_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Dé wungi wandéka dé wa, “Mwi hundi wuni méniré we. Du takwa Godna hémémbu xakunjoka mawuli yata tale di hulingumbu akwi Godna Hamwinyambu akwi huli xakutandi. Wungi huruhafi ye di Godna hémémbu yamba xakukéndi. ");
INSERT INTO wos_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Séfimbu xakundé joo, wu séfina dé. Godna Hamwinyambu xakundé joo, wu hamwinyana dé. ");
INSERT INTO wos_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Wungi wataka dé wambula wa, “Ménika wuni we, guni huli du takwa xakungute. Wun hundi xéka waréngénékéméni. ");
INSERT INTO wos_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Mur séta mawuli yandékangalambu dé yi. Yindéka méni déka hamré male méni xéké. Xékéta méni xékélakihambaméni. Yimbu dé ya? Yingiré yitandé? Murka xékélakihafi yaméka maki, méni Godna Hamwinya yandéka jémbaka yamba xékélakikéméni. Godna Hamwinya deka mawulimbu wulayindét di huli du takwa retendakaka yamba xékélakikéméni.” ");
INSERT INTO wos_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Wungi wandéka dé wa, “Wun joo yingi maki xakutandé?” ");
INSERT INTO wos_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Nikodemus wungi wandéka dé wa, “Méni Judana wakwekwa du méni. Métaka méni wun jooka xékélakihafi ye? ");
INSERT INTO wos_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Mwi hundi wuni méniré we. Nani xékélakimben jooka nani ménika we. Xémben jooka akwi nani hundi we. Wambeka guni nana hundi xékénjoka hélék guni ye. ");
INSERT INTO wos_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Wuni ané héfana jonduka ménika wawuka méni wun jonduka jémba xékéhambaméni. Wuni Godna getéfana jonduka ménika wawut, yingi maki ye méni wun hundi xékétaméni? ");
INSERT INTO wos_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Du natafa male dé Godna getéfaré wari. Tale Duna Nyan Godna getéfambu re dé ané héfaré gaya. Gayandéka ané héfana du nak Godna getéfaré warihambandé. ");
INSERT INTO wos_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","“Hanja nana mandékangu du rehafi hafwambu yitaka yatakandaka dé Moses bras ainmbu nandan hambwe nak mimbu haréka dé hateka, di xéta yikafre yandate. Harékéndén maki, di Duna Nyanré wungi harékétandi. ");
INSERT INTO wos_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","Harékéndat di wuniré xéta wunika jémba sarékéta wuna hundika ‘Mwi hundi dé’ nae di huli mawuli hérae God wali wungi re wungi re jémba retandi.” Wungi dé Jisas wa. ");
INSERT INTO wos_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","God ané héfambu rekwa du takwaka némafwimbu mawuli yata dé déka natafa male dunyaré wandéka dé gaya. God wungi dé wa, du takwa déka nyanka jémba sarékéta huli mawuli hérae dé wali jémba rendate, wungi re wungi re. Yamba hiyakéndi. ");
INSERT INTO wos_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","God déka nyanré wandéka dé ané héfaré gaya, du takwa hurundan haraki saraki sémbut hérekinjoka. Hurundan haraki saraki sémbut diré hasa hwendéte, God wahambandé. ");
INSERT INTO wos_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Déka nyanka jémba sarékékwa du takwaré God watandé, “Guni yikafre du takwa guni. Jémba retanguni.” Wataka dé déka nyanka jémba sarékéhafi yakwa du takwaré watandé, “Guni haraki saraki sémbut hurukwa du takwa guni. Wuna nyanka jémba sarékéhafi yanguka wuni hurungun haraki saraki sémbut hasa hwetawuni.” God wungi watandé. ");
INSERT INTO wos_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Jisas yikafre ya maki hanyinjoka dé ané héfaré ya. Yandéka di du takwa haraki saraki sémbut huruta di halékingambu renjoka di mawuli ya. Wun yaka hélék yandat, God diré haraki hundi watandé. ");
INSERT INTO wos_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Haraki saraki sémbut hurukwa du takwa wun yaka hélék yata larékwa hafwaré yamba yikéndi. Ya xérékéta hanyindét, di nawulak du deka hurundan haraki saraki sémbut xéndamboka hélék yata, di larékwa hafwaré yamba yikéndi. ");
INSERT INTO wos_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Mwi hundi xékékwa du takwa wunde du takwa maki yingafwe. God dika hambuk hwendéka di yikafre jémba ye. Yata di larékwa hafwaré yindaka di nawulak du hurundan yikafre jémbaré xé. Xéndaka God dika hambuk hwendéka di xékélaki. ");
INSERT INTO wos_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Hukémbu Jisas déka du wali di Judiaré yi. Ye wun héfambu reta di Godna ximbu diré guré husanda. ");
INSERT INTO wos_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Jon akwi dé Ainonmbu téta dé du takwaré guré husanda, séfélak xéri rekwambu. Wun getéfa Salim wali walémbambu dé té. Wun hafwambu séfélak du takwa yandaka dé Godna ximbu diré guré husanda. ");
INSERT INTO wos_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Wun nukwa néma du Herot Jonré séndé gembu takahambandé. Dé baka téta dé jémba ya. ");
INSERT INTO wos_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Jonéna du di du nak wali waru. Juda deka hambuk hundi xékéta di gu yakéndakaka di waru. ");
INSERT INTO wos_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Warutaka Jonéna du déka ye di déré wa, “Wakwekwa du, hanja du nak méni wali jordan xéri angé sakumbu dé té. Hanja déka jémbaka méni naniré wa. Wun du yae téta Godna ximbu dé du takwaré guré husandandéka di atéfék du takwa naniré yatakataka di déka yi. Di atéfék déka male yindamboka hélék me ye.” ");
INSERT INTO wos_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Wungi wandaka dé Jon diré wa, “God du nakéka nak jémba hwehafi yandét, wun du wun jémba yamba yakéndé. ");
INSERT INTO wos_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Guni hafu wuna hundi xéka wawun hundika guni wa. Tale wuni angi wa, ‘Wuni God wasékendén du Krais yingafwe. God wandéka wuni wun duna yambu hurunjoka wuni tale ya. Dé wuna hukémbu yatandé.’ Wungi wata wuni wun jémba ye, atéfék du takwa wun duna hundi xékéndate. ");
INSERT INTO wos_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Du nak takwa hési héranjoka mawuli yandét déka nyayika téta xéndét wun du wule takwa hérandét dé wali mawuli sawuli yatandé. Wuni wun takwa héraakwa duna nyayika maki wuni. Séfélak du takwa Jisaska yita déka hundi xékéndaka wuni xéta yikafre mawuli yata mawuli sawuli wuni ye. ");
INSERT INTO wos_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Déka jémba métaka némafwi yandé, wuna jémba yikama yandé.” Wungi dé Jon wa. ");
INSERT INTO wos_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Anwarmbu re gayandé du dé atéfék du takwana néma du dé. Ané héfambu rekwa du héfana jonduka male di xékélaki. Anwarmbu gayandé du atéfék jonduka xékélakita dé diré sarékéngwandé. ");
INSERT INTO wos_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Dé xéndén jonduka akwi xékéndén hundika akwi dé diré wa. Wandéka di déka hundi xékénjoka hélék di ya. ");
INSERT INTO wos_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Du nak déka hundi xékéta dé wun hundika angi watandé, “God mwi hundi male dé we.” Wungi watandé. ");
INSERT INTO wos_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","God wandéka yandé du dé Godna hundi wa. God déka Hamwinya atéfék dé hwe, wun duka. Hwendéka dé Godna hundi wa. ");
INSERT INTO wos_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Yafa God déka nyanka dé némafwimbu mawuli ye. Némafwimbu mawuli yata dé déka atéfék jondu hwe, dé wun jonduka jémba hatindéte. ");
INSERT INTO wos_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Godna nyanka jémba sarékékwa du takwa huli mawuli hérae wungi re wungi re jémba retandi. Déka hundi xékéhafi yakwa du takwa huli mawuli yamba hérakéndi. Godna mawuli wi dimbu dé té, wungi té wungi té. ");
INSERT INTO wos_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","2","Wun nukwa du nawulak di wa, “Séfélak du takwa di Jisasna hundi jémba xéké. Xékéndaka dé Jisas Godna ximbu diré guré husanda. Wungi hurundéka déka jémba guré husandakwa du Jonéna jémbaré dé sarékéngwandé.” Wungi wata xékélakihambandi. Jisasna du male di Godna ximbu du takwaré guré husanda. Jisas diré guré husandahambandé. Jisasna jémbaka wungi wandaka di Farisi wun hundi xékéta buléndaka dé Jisas xéké. ");
INSERT INTO wos_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Xékétaka dé Jisas Judia yatakataka dé Galiliré wambula yinjoka dé yi. ");
INSERT INTO wos_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Galiliré yindaka yambu samariana hafwambu dé yi. Jisas wun yambumbu dé yi. ");
INSERT INTO wos_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Ye dé samariana getéfa nakmbu xaku. Wun getéfana xi Sikar dé. Hanja Judana mandéka Jekop dé déka nyan josepka hafwa nak dé hwe. Sikar wun hafwa walémbambu dé té. ");
INSERT INTO wos_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Wun hafwambu Jekopna hutungu dé re. Jisas afakémbu yae wun hutungumbu xakundéka resétonjoka dé wun hutungumbu re, nukwa dawimbu téndéka. ");
INSERT INTO wos_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","8","Jisas wumbu rendéka di déka du getéfaré yi, hénoo nawulak héranjoka. Yindaka rendéka lé samariana takwa hési gu tunjoka ya. Yaléka dé Jisas léré wa, “Hulingu nawulak mé hura yanyét, sawu.” ");
INSERT INTO wos_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Wungi wandéka lé samariana takwa déré wa, “Méni Judana du méni. Wuni samariana takwa wuni. Yingi maki ye hulingu hwewut sanjoka méni we?” Wungi lé wa, Juda samaria wali yitaka yatakahafi di. ");
INSERT INTO wos_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Waléka dé Jisas wa, “Tale wuni nyénika angi wa, ‘Hulingu nawulak mé hura yanyét, sawu.’ Wungi wawuka nyéni God hwendén yikafre jooka xékélakita wunika akwi xékélake, nyéni wunika nak maki hulinguka wakwexékétanyéni. Nyéni wun hulingu sataka nyéni jémba retanyéni.” ");
INSERT INTO wos_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Dé wungi wandéka lé déka hundika xékélakihafi yata lé wa, “Néma du, méni gu tuteméka aki yingafwe. Ané wekwambu hulingu andélambu dé té. Waméka hulingu yimbu héra hwetaméni? ");
INSERT INTO wos_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Nana mandéka Jekop dé nanika ané hutungu hwe. Déka nyangwal akwi, déka sipsip bali akwi, déka bulmakau bali akwi, dé akwi di ané hulingumbu sa. Méni Jekopré sarékéngwandé wana?” ");
INSERT INTO wos_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Wungi waléka dé Jisas wa, “Atéfék du takwa wun hulingu sataka hukémbu hulinguka wambula hiyatandi. ");
INSERT INTO wos_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Di hwetewuka hulingu sataka di hukémbu hulinguka wambula yamba hiyakéndi. Yingafwe. Hwetewuka hulingu deka mawulimbu huli hutungungala xakutandé. Xakuta blekéndét, di huli mawuli hérae jémba retandi, wungi re wungi re.” ");
INSERT INTO wos_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Wungi wandéka lé déré wa, “Yika du, némbuli wunika wun hulingu mé hwe. Wunika hwemét hukémbu wuni wambula hulinguka yamba hiyakéwuni. Wambula yae ané wekwambu hulingu yamba tukéwuni.” ");
INSERT INTO wos_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Wungi waléka dé Jisas angi wa, “Sé ye nyéni nyéna du hura béni ya.” ");
INSERT INTO wos_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Wungi wandéka lé wa, “Wuni du yingafwe.” Wungi waléka dé wa, “Wu mwi hundi nyéni we. ");
INSERT INTO wos_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Hanja du natamba wali nyéni re. Némbuli hura tényéka du nyéna du yingafwe. Nyéna hundi wu mwi hundi dé.” ");
INSERT INTO wos_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Wungi wandéka lé wa, “Néma du, némbuli andé xékélakiwi. Méni profet nak méni. ");
INSERT INTO wos_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Wuna mandékangu ané némbumbu wara di Godna ximbu haréké. Guni Juda guni wa, ‘Godna ximbu harékémbeka hafwa Jerusalemémbu dé té.’ Wungi wangut, yingi Godna ximbu harékékéme?” ");
INSERT INTO wos_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Lé wungi waléka dé léré wa, “Nyéni wuna hundiré jémba mé xéké. Nukwa nak yandét, guni Godna ximbu harékénjoka guni ané némbumbu akwi, Jerusalemémbu akwi renjoka yamba sarékékénguni. ");
INSERT INTO wos_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Guni samaria Godka jémba xékélakihafi yata, guni déka ximbu haréké. Nani Juda Godka xékélakita nani déka ximbu haréké. Du takwana haraki saraki mawuli hérekitekwa du dé Judana hémémbu dé xaku. ");
INSERT INTO wos_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Nukwa nak xakundét Godna ximbu harékékwa du takwa angi hurutandi. Di nana yafa Godka mwi hundi wata deka hamwinyambu déka ximbu harékétandi. Wunde du takwa déka ximbu harékéndate dé mawuli ye. Déka ximbu harékétendaka nukwa andé yae. ");
INSERT INTO wos_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","God dé hamwinya dé. Dé séfi yingafwe. Du takwa Godna ximbu harékénjoka mawuli yata di mwi hundi naata deka hamwinyambu déka ximbu harékétandi.” Wungi dé wa. ");
INSERT INTO wos_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Wandéka lé wa, “God wasékendén du Mesaia déka nak xi Krais yatandé, naniré yikafre hurunjoka. Wungi wuni xékélaki. Dé yae atéfék hundika naniré wakwetandé.” ");
INSERT INTO wos_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Wungi waléka dé Jisas léré wa, “Wun du nyéni wali andé buléndi. Wuni andu.” ");
INSERT INTO wos_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Jisas wungi wandéka di déka du hénoo hérae hura di wambula ya. Yae takwa wali buléta téndéka xétaka di saréké waréké. Sarékéta wahambandi, “Méta héranjoka nyéni mawuli ye? Métaka méni lé wali hundi bulé?” Wungi wahambandi. ");
INSERT INTO wos_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","29","Wahafi yandaka lé wule takwa hulingu tuléka aki yatakataka lé getéfaré wambula yi. Ye lé du takwa nawulakré wa, “Mé yae guni xé, du nakré. Hanja wuniré xéhambandé. Dé hanja huruwun atéfék jonduka dé wuniré wa. Dé God wasékendén du Krais wana?” ");
INSERT INTO wos_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Wungi waléka di getéfa yatakataka di Jisaska ya. ");
INSERT INTO wos_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Di yambumbu yandaka di Jisasna du déré wa, “Wakwekwa du, hénoo mé sa.” ");
INSERT INTO wos_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Wungi wandaka dé wa, “Wuna hénoo wundé re. Wun hénooka xékélakihambanguni.” ");
INSERT INTO wos_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Wungi wandéka di déka du di hafu buléta di wa, “Du nak déka hénoo bu hwendé wana?” ");
INSERT INTO wos_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Di wungi wandaka dé diré wa, “Wuna hénoo angi dé. Wunika wandéka yawun duna hundi xékétawuni. Xékéta wunika hwendén jémba yaséketawuni. Wun jémba wuna hénoo dé. ");
INSERT INTO wos_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Guni hénoo setaka angi guni wa, ‘Hénoo hératembeka bafu yétiyéti dé re.’ Wanguka wuni guniré we: Némbuli male hératanguni. Mé guni xé. Yawina hénoo mwi dé té. ");
INSERT INTO wos_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Némbuli male hénoo séngwaakwa du di jémba yata yéwa hérae. Di wunde du takwaré séngwandat, wunde du takwa jémba retandi wungi re wungi re. Séngwandat, God deka yikafre jémbaka hasa hwendét, tale hénoo sendé du wali hénoo séngwaakwa du wali mawuli sawuli yatandi. ");
INSERT INTO wos_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Hanja ané hundi du nak dé wa, ‘Du nak dé hénoo se. Sendéka nak du dé wun hénoo héra.’ Wandéka némbuli wun hundi mwi hundi dé ya. ");
INSERT INTO wos_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Wuni guniré wuni wa, guni jémba yahafi yangun hénoo hérangute. Hanja du nawulak di wun hénoo sendaka némbuli guni di wali jémba yatanguni.” Wungi dé Jisas diré wa. ");
INSERT INTO wos_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","samariana takwa lé wun getéfambu rekwa du takwaré wa, “Wun du hanja huruwun atéfék jonduka dé wuniré wa.” Wungi waléka di séfélak samariana du takwa di Jisaska jémba saréké. ");
INSERT INTO wos_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Sarékéta Jisaska yae di déré wakwexéké, dé di wali rendéte. Wungi wakwexékéndaka dé di wali nukwa yéték dé re. ");
INSERT INTO wos_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Reta di wali hundi buléndéka di séfélak du takwa déka hundi xékéta di déka jémba saréké. ");
INSERT INTO wos_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Sarékéta di wule takwaré wa, “Tale nyéna hundi nani xéké. Xékétaka nani Jisaska jémba saréké. Sarékéta hukémbu nani Jisasna hundi xéké. Déka hundi xékétaka némbuli nani xékélaki. Dé ané héfambu rekwa du takwaré satanéna tambambu hératekwa du dé. Wu mwi hundi dé.” Wungi di samariana du takwa wa. ");
INSERT INTO wos_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","44","Jisas Samariambu nukwa yéték re nak nukwa dé wa, “Godna profet nak rendét déka motéfana du takwa déka di wa, ‘Dé nani maki du dé. Dé néma du yingafwe. Wu baka du dé.’ Wungi wandaka di nak téfana du takwa déka di wa, ‘Wu néma du dé.’ Wungi di wa.” Jisas wungi wataka dé wun getéfa yatakataka dé déka motéfa Galiliré yi. ");
INSERT INTO wos_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Hanja Pasovana hénoo hura sa nukwa di Galilina du takwa nawulak Jerusalemré yi. Ye di xé Jisas hanja xéhafi yandan hambuk jémba yandéka. Xétaka deka héfaré wambula ye re di xé, Jisas deka getéfaré yandéka. Xéta di déka mawuli yata mawuli sawuli ya. Yata di déka hundi xéké. ");
INSERT INTO wos_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","47","Dé Galilimbu ye dé Kanambu xaku. Hanja Jisas wun getéfambu reta wandéka hulingu dé wain hulingu xaku. Jisas Judia yatakataka Galiliré ye Kanambu xaakwa rendéka dé néma du nak xéké. Wun néma duna nyan bar hiyaata dé kaperneamémbu hwa. Hwandéka dé néma du Jisaska ya. Yae déré dé wa, “Némbuli male wuna nyan hiyatandé. Méni wuni wali yae wuna nyanré yikafre hurumét, dé yikafre yandé.” ");
INSERT INTO wos_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Wungi wandéka dé Jisas wa, “Guni hanja xéhafi yangun hambuk jémba yawuka xéta guni wunika jémba saréké, o yingi maki dé?” ");
INSERT INTO wos_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Wungi wandéka dé néma du wa, “Néma du, bari mé ya. Yahafi yamét wuna nyan hiyatandé.” ");
INSERT INTO wos_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Wungi wandéka dé Jisas wa, “Méni sa yi. Ména nyan yikafre yatandé.” Wungi wandéka dé Jisasna hundi jémba xékétaka dé yi. ");
INSERT INTO wos_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Déka jémba yakwa du yae déré yambumbu xe di wa, “Ména nyan yikafre wundé yandé.” ");
INSERT INTO wos_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Wungi wandaka dé diré wakwexéké, “Méta nukwa dé yikafre ya?” Wakwexékéndéka di wa, “Nalika nukwa dawimbu téndéka déka bar wungi hényi.” ");
INSERT INTO wos_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Wungi wandaka dé yafa xékélaki. Nalika Jisas dé wali hundi buléndén nukwa dé déka nyan yikafre ya. Wungi xékélakita dé déka hém wali atéfék di Jisaska jémba sarékéta déka hundika di “Mwi hundi dé” na. ");
INSERT INTO wos_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Jisas tale Judia yatakataka Galiliré ye wandéka dé wun nyan yikafre ya. Wungi yata dé Jisas hanja xéhafi yandan hambuk jémba yambu yéték dé ya. ");
INSERT INTO wos_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Hukémbu Judana némafwi hénoo hura sandaka nukwa xakundéka dé Jisas Jerusalemré wari. ");
INSERT INTO wos_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Jerusalemna motumbu gindan séndémbu yambu nak dé té. Wun yambuna xi angi dé, sipsip balina yambu dé. Wun yambu tékwambu dé xandan gu nak dé re. Wun xandan gu Hibruna hundimbu angi di wa, Betesda. Wun gumbu hasafwi ge natamba dé té. ");
INSERT INTO wos_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Séfélak du takwa di wun gembu re. Dama hiyandé du takwa, man haraki yandé du takwa, hambuk yahafi du takwa, wungi di re. Wun gu gungan yandét xénjoka di re. ");
INSERT INTO wos_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Hanja nak nukwa nak nukwa Godna ensel nak gaye dé wun hulingumbu nandindéka dé gu gungan ya. Gu gungan yandéka xétaka dé guré tale nandindé du dé yikafre ya. ");
INSERT INTO wos_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Du nak séfélak (38) héki hwari déka séfi haraki dé té. ");
INSERT INTO wos_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Dé wun hasafwi gembu hwandéka Jisas déré xe dé xékélaki, séfélak héki hwari wumbu hwandéka. Wungi xékélake dé Jisas déré wakwexéké, “Méni yikafre yanjoka méni mawuli ye?” ");
INSERT INTO wos_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Wungi wakwexékéndéka dé séfimali haraki yandé du wa, “Néma du, yingi maki yatawuni? Gu gungan yandéka wuniré hérae guré husandatekwa du yingafwe. Wuni hafu nandinjoka yiwuka nak du wuniré tenangéra dé tale nandi.” ");
INSERT INTO wos_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Wungi wandéka dé Jisas wa, “Méni sé raama hwamén be hérae hura yi.” ");
INSERT INTO wos_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Wungi wandéka dé wun du wambula yikafre ye dé déka be hérae hura yi. Wun nukwa baka hwa nukwa dé. ");
INSERT INTO wos_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Wun du yindéka di Judana néma du yikafre yandé duré wa, “Baka hwa nukwa dé. Méni baka hwa nukwambu ména be hura yamba yikéméni.” ");
INSERT INTO wos_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Wungi wandaka dé diré wa, “Du nak wandéka yikafre yawuka dé wuniré wa, ‘Ména be hérae hura yitaméni.’ Wungi wandéka wuni hérae hura yi.” ");
INSERT INTO wos_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Wungi wandéka di wakwexéké, “Ména be hérae hura yiméte héndé wa?” ");
INSERT INTO wos_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Wungi wandaka xékélakihambandé. Wun hafwambu séfélak du takwa téndaka Jisas wundé yindé. ");
INSERT INTO wos_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Hukémbu dé Jisas déré tempelmbu xé. Xe dé wa, “Mé xéké. Némbuli méni wundé yikafre yamé. Haraki saraki sémbut wambula yamba hurukéméni. Wuna hundi xékéhafi yamét némafwi xakéngali ménika yatandé.” ");
INSERT INTO wos_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Wungi wandéka wun du ye dé Judana néma duré wa, “Wunika wandéka yikafre yawun du, wu Jisas dé.” ");
INSERT INTO wos_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Dé wungi wandéka xékétaka di baka hwa nukwambu wungi hurundénka di tale Jisasré haraki hundi wata di haraki hurunjoka saréké. ");
INSERT INTO wos_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Wungi wandaka dé Jisas diré wa, “Wuna yafa atéfék nukwa dé jémba ye. Yandéka wuni akwi wuni jémba ye.” ");
INSERT INTO wos_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Wungi dé déka yafa Godka wata dé dé hafu God maki rendékaka dé wa. Wandéka xékétaka di Judana néma du déré xiyanjoka di mawuli ya, wun duré baka hwa nukwambu huréhalékéndénka akwi God maki rendékaka akwi. ");
INSERT INTO wos_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Di wungi hurundaka dé Jisas diré wa, “Mwi hundimbu wuni guniré we. Wuna yafa jémba yandéka, wuni déka nyan xe wun jémba wuni ye. Wuni hafu wuna mawuli yambu jémba nak yamba yakéwuni. Wuna yafa jémba yandéka maki wuni akwi yatawuni. ");
INSERT INTO wos_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Wuna yafa wunika némafwimbu mawuli yata dé déka jémba wuniré wakwe. Hukémbu wunika wakwetendéka jémba némbuli yawuka jémbaré sarékéngwandétandé. Wuni wun huli jémba yawut guni xe waréngéna sarékétanguni, wun jémbaka. ");
INSERT INTO wos_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Wuna yafa hiyandé du takwaré wandéka di raama jémba di re. Wandéka maki wuni mawuli yawuka du takwaka wawut, di hiyahafi jémba retandi. ");
INSERT INTO wos_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Wuna yafa némafwi kot xékékwa néma du reta, du takwa hurundan sémbutka hundi yamba wakéndé. Wun jémba wunika wundé hwendé. Wuni némafwi kot xékékwa néma du reta hurundan sémbutka hundi watawuni. ");
INSERT INTO wos_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","Atéfék du takwa wuna yafana ximbu harékéndaka maki, wuna ximbu harékéndate dé wun jémba wunika hwe. Wuna ximbu harékéhafi yakwa du takwa di wunika wandéka yawun duna ximbu akwi harékéhambandi. ");
INSERT INTO wos_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","“Mwi hundimbu wuni guniré we. Wuna hundi jémba xéka wuniré wandéka yawun duka jémba sarékékwa du takwa atéfék huli mawuli di hérae. Hérae wungi re wungi re God wali jémba retandi. Hukémbu wuni néma du reta deka hundi xékéta hurundan haraki saraki sémbutka hundi yamba wakéwuni. Haraki hafwaré yamba yikéndi. ");
INSERT INTO wos_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Mwi hundimbu wuni guniré we. Hiyandé du takwa di Godna Nyanéna hundi xékétandi. Xékétaka di huli mawuli hérae jémba retandi. Wun nukwa némbuli andé yae. ");
INSERT INTO wos_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Yafa God dé du takwaka hamwinya dé hwe, di ané héfambu rendate. Hwendén maki, dé déka nyanka dé hambuk hwe, dé akwi du takwaka huli hamwinya hwendéte. Hwendét, di huli mawuli hérae jémba retandi, wungi re wungi re. ");
INSERT INTO wos_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Déka nyan dé Duna Nyan dé re. Rendénka God déka hambuk hwe, hukémbu dé kot xékékwa néma du reta, atéfék du takwa hurundan sémbutka hundi xékéta wandéte. ");
INSERT INTO wos_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Wun jooka waréngénékénguni. Nak nukwa yandét, hiyandé du takwa réméndan hwandafumbu hwaata déka nyanéna hundi xékétandi. ");
INSERT INTO wos_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","Xékétaka ramétandi. Yikafre sémbut hurundé du takwa raama wungi re wungi re jémba retandi. Haraki saraki sémbut hurundé du takwa raméndat, God diré hurundan haraki saraki sémbut hasa hwetandé.” Wungi dé Jisas wa. ");
INSERT INTO wos_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Jisas wungi wataka dé Judana néma duré wambula wa, “Wuni nak joo wuna mawuli sarékémbu yamba hurukéwuni. Wuniré wandéka yawun duna hundi xéka wandén maki wuni du takwa hurundan sémbutka wuni hundi we. Wuna mawuli sarékémbu wahafi yata déka hundi male wawuka dé wawun hundi mwi hundi dé. ");
INSERT INTO wos_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Wuni hafu wuna jémbaka hundi wawut, guni watanguni, ‘Déka hundi yénataka hundi dé.’ Wungi wata guni wunika jémba yamba sarékékénguni. ");
INSERT INTO wos_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Du nak akwi dé wuna jémbaka hundi wa. Wandéka wuni xékélaki. Wuna jémbaka wandéka hundi wu mwi hundi dé. ");
INSERT INTO wos_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Hanja guni nawulak duré wanguka di Jonka ye di wakwexéké. Wakwexékéndaka dé guniré mwi hundi wa wunika. ");
INSERT INTO wos_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Wuni du wunika wandénka sarékéhambawuni. Sarékéhafi yawuka guni wuna hundika jémba xékéngut God guniré yikafre hurundéte wuni Jonka wa. ");
INSERT INTO wos_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Hama ya yanéta hanyindéka di du jémba xé. Jon hama ya maki xéréka hanyindéka guni déka larékombu reta guni mawuli sawuli ya. ");
INSERT INTO wos_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","“Jon wunika hundi wandéka wundé xékéngu. Wuna hambuk jémba déka hundiré dé sarékéngwandé. Wuna yafa yawute hwendén jémba andé yawi. Wuna jémba wunika dé wakwe. Nawulak du takwa wuna jémbaré xe di wa, ‘Déka yafa God wandéka dé ya. Wungi nani xékélaki.’ Wungi di wa. ");
INSERT INTO wos_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Wuna yafa wuniré wandéka yawuka dé akwi dé wunika wa. Guni déka hundi rasi xékéhambanguni. Wu yingafwe. Guni déka saawi akwi xéhambanguni. ");
INSERT INTO wos_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","God wuniré wandéka wuni ya. Guni wunika jémba sarékéhafi yanguka déka hundi guna mawulimbu téhambwe. ");
INSERT INTO wos_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Guni huli mawuli hérae jémba renjoka sarékéta, guni Godna nyingambu hayindan hundika hwaké. Wun hayindan hundi wunika dé wa. ");
INSERT INTO wos_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Wunika yae huli mawuli hérae jémba renjoka hélék guni ye. ");
INSERT INTO wos_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","“Du takwa wuna ximbu harékéndate wahambawuni. ");
INSERT INTO wos_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Guna mawuli wuni xékélaki. Guna mawulimbu Godka mawuli ya téhambwe. ");
INSERT INTO wos_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Wuni wuna yafana ximbu wuni ya. Yawuka guni wuna hundi xékéhafi guni. Nak du yae déka hafu ximbu wandét, guni déka hundi xékétanguni. ");
INSERT INTO wos_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Du takwa guna ximbu harékéndate guni mawuli ye. Natafa male God guna ximbu harékéndéte hélék guni ye. Wungi huruta wunika jémba sarékénjoka guni hurufatiké. ");
INSERT INTO wos_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","“Guni angi sarékékénguni, ‘Jisas hurumben haraki saraki sémbutka Godré hundi watandé.’ Wungi sarékékénguni. Guni nana mandéka Moseska guni angi wa, ‘Nani Moses wandén hundi xékéta wandén maki hurungut, dé naniré yikafre hurutandé.’ Wungi wata guni ané hundi mé xéké. Moses hurungun haraki saraki sémbutka Godré watandé. ");
INSERT INTO wos_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Hanja Moses dé hayi wunika. Guni wun hundi xékéhambanguni. Guni Moses hayindén hundi xékétaka guni wuna hundi xékétanguni. ");
INSERT INTO wos_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Guni hayindén hundi xékéhafi yata yingi maki ye wuna hundi jémba xékétanguni? Wuna hundi jémba xékénjoka guni hurufatiké.” Wungi dé Jisas Judana néma duré wa. ");
INSERT INTO wos_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Wun hundi wataka dé Jisas tukweseke angé sakuré yi. Wun tukwesekena xi Galili dé. Nak xi taiberius dé. ");
INSERT INTO wos_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Hanja séfélak du takwa di xé Jisas séfélak hambuk jémba yandéka. Yandéka di bar hiyaakwa du takwa yikafre ya. Xétaka di déka hukémbu yi. ");
INSERT INTO wos_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Jisas déka du wali némbu nakmbu wara di wumbu re. ");
INSERT INTO wos_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Pasovana nukwa, Judana némafwi hénoo hura sa nukwa xakundéka di wumbu re. ");
INSERT INTO wos_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Rendaka dé Jisas xé, séfélak du takwa déka yandaka. Xétaka dé Filipré wa, “Hénoo yimbu hérae wun du takwaka hwembet sakéndi?” ");
INSERT INTO wos_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Filipna mawuli hurukwexénjoka dé wungi wa. Jisas yatendéka jémbaka dé xékélaki. ");
INSERT INTO wos_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Jisas wungi wandéka dé Filip déré wa, “Nani séfélak séfélak yéwa hwetaka bret nawulak hérambet, di wali yamba sékérékékéndé. Di nak nak du takwa nyangwal yalefu yalefu satandi.” ");
INSERT INTO wos_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Wungi wandéka Jisasna du nak Andru dé wumbu té. Wun du dé Saimon Pitana bandi dé. Téta dé wa, ");
INSERT INTO wos_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","“Nyan nak andé té. Dé yikama bret natamba xéri hamwi yéték wungi dé hura té. Wun yikama bret wali yikama xéri hamwi wali séfélak du takwaré yingi maki hwetame?” ");
INSERT INTO wos_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Wungi wandéka dé Jisas diré wa, “Wun du takwaré mé wa renda.” Wun hafwambu séfélak wara dé té. Wungi wandéka wandaka wara takumbu di re. Séfélak séfélak du takwa di wumbu re (5000 du maki di). ");
INSERT INTO wos_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Rendaka dé Jisas wun bret hérae Godka diména nataka dé du takwaka mune hwendéka di sa. Bret munindén maki male dé xéri hamwi yéték akwi wungi muni. Mawuli yandan makimbu dé mune hwe. ");
INSERT INTO wos_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Mune hwendéka sandaka dé Jisas déka duka wa, “Sandan també hénoo mé héra, baka rendémboka.” ");
INSERT INTO wos_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Wungi wandéka di du takwa sandaka rendé bret wasara tamba atéfék ye man yéték wungi di hérae lakwa. ");
INSERT INTO wos_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Lakwandaka di du takwa Jisas yandén hambuk jémbaré xéta di wa, “Profet nak ané héfaré yatandé. Déka nani haxé. Haxémben du Jisas dé. Wu mwi hundi dé.” ");
INSERT INTO wos_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Wungi wandaka dé Jisas xékélaki. Di déré huluke takandat dé deka néma du rendéte di mawuli ya. Wungi xékélakita wun getéfambu néma du renjoka hélék ye dé dé hafu némburé wambula wari. ");
INSERT INTO wos_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","17","Gérambu yandéka Jisasna du tukwesekeré nandi. Naande gunjambémbu wara di kaperneamré yinjoka mawuli ya. Mawuli yandaka Jisas dika yahambandé. Yahafi yandéka gan hunyindéka di yi. ");
INSERT INTO wos_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Yindaka némafwi mur yandéka dé gu hambukmbu raama waré. ");
INSERT INTO wos_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Waréndéka gunjambé yiléte di gutuwa yi. Wungi gutuwa afakémbu di yi (6 kilomita maki). Ye di xé Jisas gu takumbu yandéka. Xéta di roo. ");
INSERT INTO wos_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Roondaka dé diré wa, “Ané wuni wuni yae. Guni rookénguni.” ");
INSERT INTO wos_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Wungi wandéka di yikafre mawuli ye di gunjambéré xalendéte di mawuli ya. Yandaka dé gunjambéré wari. Wara rendéka di gunjambémbu ye wun getéfambu bari hari xaku. ");
INSERT INTO wos_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Xitélakéndéka di séfélak du takwa tukweseke angé sakumbu di té. Téta di hafu angi wa, “Nalika natafa gunjambé lé re. Reléka Jisasna du wun gunjambémbu wara di yi. Yindaka Jisas di wali yihambandé. Dé ané hafwambu dé re.” ");
INSERT INTO wos_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Wungi wata di Jisaska hwaké. Hwakéfatikéndaka taiberiusmbu di gunjambé nawulak akwi ya. Yae di nalika reta bret sandan hafwambu di re. Nalika Jisas bret hérae Godré wataka dé dika hwe, wun hafwambu. ");
INSERT INTO wos_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Jisas déka du akwi wun hafwambu rehafi yandaka di du takwa hwakéfatika, wun gunjambémbu wara di tukweseke angé sakuré yi, kaperneamré. Jisaska hwaka xénjoka di yi. ");
INSERT INTO wos_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Wunde du takwa ye xaakwa Jisasré xe di déré wakwexéké, “Wakwekwa du, méta nukwa méni angiré ya?” ");
INSERT INTO wos_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Wungi wakwexékéndaka dé Jisas diré wa, “Mwi hundi wuni guniré we. Bret sanguka guna biya bu yata. Yatandéka guni wunika hwaké, bret nawulak akwi hwewute. Hambuk jémba yawuka xéngunka jémba sarékéhambanguni. ");
INSERT INTO wos_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Guni jémba yata guni yama xe gérékéndé xaakwa hénooka yamba sarékékénguni. Guni jémba yata nak maki hénooka sarékétanguni. Wun hénoo wungi retandé. Guni wun hénoo sataka jémba retanguni, wungi re wungi re. Wun hénoo Duna Nyan dika hwetandé. Dé wungi hwendéte dé Yafa God hafu déré waséke.” ");
INSERT INTO wos_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Wungi wandéka di wa, “Méta maki ye Godna jémba yakéme?” ");
INSERT INTO wos_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Wungi wandaka dé wa, “Godna jémba angi dé. Guni God wandéka yandé duka jémba sarékétanguni. Wungi saréka guni Godna jémba yatanguni.” ");
INSERT INTO wos_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Wungi wandéka di wa, “Méta hambuk jémba yamét xe nani ménika jémba sarékétame? Méta yataméni? ");
INSERT INTO wos_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Hanja nana mandékangu du rehafi hafwambu yitaka yatakata di nak maki hénoo sa. Wun hénooka di wa, ‘Mana dé.’ Hanja rendé du di Godna nyingambu wun hénooka angi hayi: Dé du takwaka Godna getéfambu gayandé bret hwendéka di sa. Wungi di hayi.” ");
INSERT INTO wos_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Di wungi wandaka dé Jisas diré wa, “Mwi hundi wuni guniré we. Hanja Moses Godna getéfambu gayandé bret hwehambandé. Wuna yafa male dé Godna getéfambu yikafre male gayandé bret hwe. ");
INSERT INTO wos_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","God hwendén bret dé Godna getéfaré yatakataka dé ané héfaré gaya, du takwaré yikafre hurunjoka. Dé diré yikafre hurundét di jémba retandi, wungi re wungi re.” ");
INSERT INTO wos_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Wungi wandéka di Jisasré wa, “Néma Du, nani wun yikafre bret héranjoka nani mawuli ye. Wungi té wungi té mé hwe naniré.” ");
INSERT INTO wos_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Di wungi wandaka dé Jisas diré wa, “Wuni hafu wuni huli mawuli hwekwa bret wuni. Guni wunika yae guni hénooka wambula yamba hiyakénguni. Guni wunika jémba sarékéta guni hulinguka wambula yamba hiyakénguni. ");
INSERT INTO wos_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Guni wuni hambuk jémba yawuka xe guni wunika jémba sarékéhambanguni. Hanja guniré wungi wuni wa. ");
INSERT INTO wos_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Wuna yafa séfélak du takwa wunika dé hwe. Wunde du takwa atéfék wuna hundi xékéta wunika yatandi. Yandat nakré yamba hérekikéwuni. ");
INSERT INTO wos_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Wuni Godna getéfambu re wuni ané héfaré gaya. Wuna mawuli sarékémbu jémba yanjoka gayahambawuni. Wuna yafa wandéka wuni gaya, dé mawuli yandén jémba yanjoka. ");
INSERT INTO wos_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Wuna yafa wandéka wuni gayawuka déka mawuli ya angi dé. God wunika hwendén du takwa atéfék wunika yatandi. Nak yamba fakukéndé. Hukétéfi yatekwa nukwa wuni diré husaramétawuni. Wungi dé God mawuli ya. ");
INSERT INTO wos_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Wuna yafana mawuli ya angi dé. Godna nyanré xe wunika jémba sarékéta wuna hundika ‘Mwi hundi dé’ naakwa atéfék du takwa huli mawuli hérae wungi re wungi re jémba retandi. Wun hukétéfi nukwa wuni hafu wuni wunde du takwaré husaramétawuni. Wungika dé wuna yafa mawuli ye.” ");
INSERT INTO wos_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Jisas wungi wandéka di Judana néma du wun hundi xékéta di hélék ya. Jisas dé wa, “Wuni hafu Godna getéfambu gayandé bret wuni.” ");
INSERT INTO wos_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Wungi wandéka xékéta hélék di ya. Hélék yata di wa, “Godna getéfambu gayahambandé. Dé josepna nyan dé. Déka xi Jisas dé. Déka yafa ayiwaka nani xékélaki. Dé nana getéfambu rekwa du dé. Dé we, ‘Godna getéfambu wuni gaya.’ Métaka dé wungi wa? Dé yéna dé ye.” Wungi di wa. ");
INSERT INTO wos_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Wandaka dé Jisas diré wa, “Guni wuna hundika hélék yata guni hafu wungi bulékénguni. ");
INSERT INTO wos_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Du takwa deka mawuli yambu wunika yamba yakéndi. Tale God wasékendét di wunika yatandi. Hukétéfi nukwambu wuni diré husaramétawuni. ");
INSERT INTO wos_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Hanja Godna profet déka nyingambu di angi hayi: God atéfék du takwaré déka jémbaka wakwetandé. Wungi di hayi. Du takwa Godna hundi xékéta déka jémbaka xékélake, wunde du takwa atéfék wunika yatandi. ");
INSERT INTO wos_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Du nak yafa Godré xéhambandé. God wali re yandé du male dé yafa Godré wundé xéndé. ");
INSERT INTO wos_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","“Mwi hundi wuni guniré we. Wunika yae jémba sarékéta wuna hundika ‘Mwi hundi dé’ naakwa du takwa di huli mawuli hérae di jémba retandi, wungi re wungi re. ");
INSERT INTO wos_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Wuni hafu wuni huli mawuli hwekwa bret wuni. ");
INSERT INTO wos_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Guna mandékangu du rehafi hafwambu yitaka yatakata di mana se di hiya. ");
INSERT INTO wos_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Godna getéfambu gayandé bret angi dé. Du takwa wun bret sataka yamba hiyakéndi. ");
INSERT INTO wos_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Wuni hafu wuni wungi re Godna getéfambu gayandé bret wuni. Wuni du takwa huli mawuli hérandate wuni gaya. Du takwa wun bret sataka di jémba retandi, wungi re wungi re. Di jémba rendate hwetewuka bret wu wuna séfi dé.” ");
INSERT INTO wos_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Judana néma du wun hundi xékétaka di hafu waruta di wa, “Ané yingina hundi dé? Yingi maki ye wun du déka séfi nanika hwendét satame?” ");
INSERT INTO wos_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Di wungi wandaka dé Jisas diré wa, “Mwi hundi wuni guniré we. Guni Duna Nyanéna séfi wali déka nyéki wali sahafi ye, guni hiyandé du takwa maki retanguni. ");
INSERT INTO wos_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Du takwa wuna séfi wali wuna nyéki wali sataka di huli mawuli hérae jémba retandi, wungi re wungi re. Hukémbu hiyandat hukétéfi nukwambu wuni diré husaramétawuni. ");
INSERT INTO wos_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Wuna séfi wu yikafre hénoo dé. Wuna nyéki akwi wu yikafre hulingu dé. Wu mwi hundi dé. ");
INSERT INTO wos_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Wuna séfi wali wuna nyéki wali sakwa du takwa di wuni wali retandi. Rendat wuni deka mawulimbu tétawuni. ");
INSERT INTO wos_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Wuna wungi re Yafa God wandéka wuni gaya. Gayawuka déka hambuk hwendéka wuni jémba re. Rewuka maki, wuna séfi sakwa du takwaka wuna hambuk hwewut, di jémba retandi, wungi re wungi re. ");
INSERT INTO wos_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Godna getéfambu gayandé bret dé mandékangu hanja sandan bret maki yingafwe. Di wun bret se di hiya. Du takwa Godna getéfambu gayandé bret sataka di jémba retandi, wungi re wungi re.” ");
INSERT INTO wos_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Wungi dé Jisas wa, Godna hundi buléndaka gembu. Wungi wata dé kaperneamémbu dé du takwaré wakwe. ");
INSERT INTO wos_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Jisasna du séfélak déka hundi xékéta di wa, “Jisas wandéka hundi wu xak hundi dé. Héndé xékéte, déka hundi?” ");
INSERT INTO wos_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Wungi wandaka dé Jisas deka mawuli xékélakita dé wakwexéké, “Wuna hundi guna mawuliré haraki dé huru wana? ");
INSERT INTO wos_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Wuni anwarmbu wuni gaya. Wambula waréwut, guni xe yingi sarékékénguni? ");
INSERT INTO wos_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Godna Hamwinya hafu huli mawuli hwendét, du takwa huli mawuli hérae di jémba retandi, wungi re wungi re. Taku séfina joo guniré yikafre yamba hurukéndé. Gunika wawun hundi wu Hamwinyana hundi dé, huli mawuli hwetekwa hundi dé. ");
INSERT INTO wos_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Guni wali tékwa du nawulak wuna hundika jémba xékéhambandi.” Wungi dé Jisas wa. Déka jémba sarékéhafi yakwa duka dé xékélaki. Déré mama duka hwetekwa duka akwi dé xékélaki. Xékélakita dé wungi wa. ");
INSERT INTO wos_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Wungi wataka dé angi wa, “Tale wuni guniré wa, ‘Du takwa deka mawuli yambu wunika yamba yakéndi. Tale God wasékendét di wunika yatandi.’ Guni nawulak wunika jémba sarékéhafi yanguka wuni tale wungi wa.” ");
INSERT INTO wos_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Wungi wandéka di déka du séfélak déré yatakataka di yi. Dé wali wambula yihambandi. ");
INSERT INTO wos_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Yihafi yandaka di déka du tamba atéfék ye man yéték di wumbu té. Téndaka dé Jisas diré wa, “Guni yingi maki dé? Guni akwi wuniré yatakataka yitanguni, o yingafwe?” ");
INSERT INTO wos_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Wungi wakwexékéndéka dé Saimon Pita wa, “Néma Du, méniré yatakataka héndéka yikéme? Méni hafu méni naniré yikafre hundi wa, nani huli mawuli hérae jémba rembete. ");
INSERT INTO wos_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Ménika nani jémba saréké. Nani xékélaki. Méni God wasékendén yikafre du méni.” ");
INSERT INTO wos_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Wungi wandéka dé Jisas diré wa, “Wuni hafu wuni tamba atéfék ye man yéték du guniré wuni waséke. Wasékewuka guna be nak satanéna du dé.” ");
INSERT INTO wos_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Wungi wandén dé Saimon Iskariotna nyan Judaska dé wa. Judas dé déka du nak dé. Hukémbu dé Jisasré déka mama duka hwetandé. Judas wungi hurutendékaka dé Jisas wa. ");
INSERT INTO wos_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Judana néma du Judiambu reta di Jisasré xiyanjoka di huru. Wungi hurundaka deka héfambu yihambandé. Yihafi ye dé Galilimbu yitaka yatakata dé déka jémba ya. ");
INSERT INTO wos_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Judana némafwi hénoo sa nukwa nak walémba dé. Wun nukwa Judana du takwa di deka ge yatakataka yikafre mawuli yata Jerusalemré ye boro yakitaka di re. ");
INSERT INTO wos_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Wun nukwa di Jisasna bandingu déré angi wa, “Ané héfa yatakataka méni Judiaré yitaméni. Wun héfaré yimét di ména hundi xékénjoka mawuli yata wumbu rekwa du takwa di yateméka jémba xétandi. ");
INSERT INTO wos_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Méni du takwana makambu néma du renjoka mawuli yata, méni ye faakwa jémba yamba yakéméni. Méni wun jémba yawu nae sé ye hwiya hafwambu téta jémba yamét bu du takwa atéfék xénda.” ");
INSERT INTO wos_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Jisasna bandingu déka sarékéhafi yata di wungi wa. ");
INSERT INTO wos_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Wandaka dé Jisas diré wa, “Atéfék nukwa guni Judiaré yinjoka mawuli yata yitanguni. Wuni yitewuka nukwa wayika yakéndé. ");
INSERT INTO wos_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Ané héfana du takwa gunika yamba mama wakéndi. Wuni dika wuni wa, ‘Guni haraki saraki sémbut guni huru.’ Wungi wawukaka di wunika mama we. ");
INSERT INTO wos_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Guni hafu wun némafwi hénoo sa nukwaka sa guni yi. Wuni yamba yikéwuni. Wuni yitewuka nukwa wayika xakukéndé.” ");
INSERT INTO wos_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Jisas wungi wataka dé Galilimbu re. ");
INSERT INTO wos_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Jisasna bandingu némafwi hénoo sa nukwaka xénjoka Jerusalemré yindaka hukémbu dé Jisas yi. Jisas faakwa yindéka du takwa nawulak déré xéhambandi. Dé duna makambu yihambandé. ");
INSERT INTO wos_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Némafwi hénoo sa nukwa yandéka di Judana néma du Jisaska hwakéta di wa, “Wun du yimbu dé re?” ");
INSERT INTO wos_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Wungi wandaka di du takwa di hafu buléta di angi wa. Nawulak di wa, “Dé yikafre du dé.” Wungi wandaka nawulak di wa, “Yingafwe. Dé du takwaka yéna yakwa du dé.” ");
INSERT INTO wos_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Wungi wata Judana néma du xékéndamboka hélék yata némafwimbu buléhambandi. ");
INSERT INTO wos_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Hénoo sata rendaka dé Jisas tempelré wulaaye dé du takwaré Godna jémbaka wakwe. ");
INSERT INTO wos_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Wakwendéka di Judana néma du saréké warékéta di wa, “Wun du dé xékélelakikwa du wandaka maki dé wa. Yingi maki ye dé wungi wa? Nana du déré wakwehambandi.” ");
INSERT INTO wos_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Wungi wandaka dé Jisas diré wa, “Guniré wakwewuka hundi wuna hundi yingafwe. Wakwewun hundi wuniré wandéka yawun du Godna hundi dé. ");
INSERT INTO wos_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Guni déka hundi xéka wandén maki hurunjoka mawuli ye wakwewun hundika jémba xékélakitanguni. Wuna mawuli sarékémbu wuni wakwe wana, Godna hundi wuni wakwe wana? Wungi xékélakitanguni. ");
INSERT INTO wos_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Nawulak du deka ximbu harékéndate mawuli yata di du nawulakéka deka mawuli sarékémbu hundi wa. Wuni wungi wahambawuni. Wuna yafa God wandéka wuni ya. Nawulak du Godna ximbu harékéndate mawuli yata wuni God mawuli yandéka maki wuni hundi we. Guni wuna hundi xékéta xékélakitanguni. Mwi hundi male wuni we. Haraki sémbut nawulak wunimbu téhambwe. ");
INSERT INTO wos_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","“Hanja Moses dé gunika hambuk hundi hwe. Hwendéka guni wun hambuk hundi xékéhambanguni. Métaka guni wuniré xiyanjoka huru?” ");
INSERT INTO wos_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Wungi wandéka di wa, “Haraki hamwinya ména mawulimbu dé té. Héndé méniré xiyanda hiyate?” ");
INSERT INTO wos_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Wungi wandaka dé Jisas wa, “Baka hwa nukwa hambuk jémba nak yawuka guni waréngéna guni saré waréké. ");
INSERT INTO wos_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Hanja Moses dé dunyana séfi sékéngute dé gunika wakwe. Wakwendéka xéka guni baka hwa nukwambu dunyana séfi séké. Wun jooka Moses tale wakwehambandé. Nana mandékangu di wun jooka tale wakwe. ");
INSERT INTO wos_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Guni Mosesna hundi jémba xéka guni baka hwa nukwambu dunyana séfi séké. Wungi sékéta métaka guni wunika biya mawuli wi, baka hwa nukwambu duré huréhalékéwuka. ");
INSERT INTO wos_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Guni taku damambu xénguka jooka wakénguni. Guni yikafre sémbutka sarékéta guni huruwun jooka wa.” Wungi dé Jisas wa. ");
INSERT INTO wos_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Jerusalemémbu rekwa du takwa nawulak di wa, “Ané duré mé xé. Xiyatendaka du dé. ");
INSERT INTO wos_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Dé atéfék duna makambu téta dé hundi wa. Wandéka néma du déré hundi nak wahambandi. Dé God wasékendén du Kraiska di xékélaki wana? ");
INSERT INTO wos_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Nani wun duna motéfaka nani xékélaki. Naniré yikafre hurundéte God wasékendén du Krais xakundét, nani déka motéfaka yamba xékélakikéme.” Wungi di wa. ");
INSERT INTO wos_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Wandaka dé Jisas tempelmbu téta dé du takwaré hundi wa. Wata dé wa, “Guni wunika xékélakita wuna yawun téfaka guni xékélaki. Wuna mawuli yambu yahambawuni. Wuna yafa wandéka wuni ya. Déka sémbut yikafre dé. Guni déka xékélakihambanguni. ");
INSERT INTO wos_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Wuni hafu wuni déka xékélaki. Wuni dé wali rewuka dé wandéka wuni ya.” ");
INSERT INTO wos_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Wungi wandéka di déré huluke hura yinjoka di huru. Hura déré hulukihambandi. Métaka we? Déka hiyatendéka nukwa wayika yakéndé. ");
INSERT INTO wos_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Hurundaka séfélak du takwa déka jémba sarékéta di wa, “God wasékendén du Krais hanja xéhafi yamben hambuk jémba yandét, ané du yandéka jémbaré yamba sarékéngwandékéndé. Ané du God wasékendén du Krais dé. Wungi nani xékélaki.” Wungi di wa. ");
INSERT INTO wos_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Jisaska wun hundi buléndaka di Farisi xéké. Xékétaka di prisna néma du wali gélinduré wandaka di yi, Jisasré huluke séndé gembu takanjoka. ");
INSERT INTO wos_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Ye xakundaka dé Jisas wa, “Wuni nawulak nukwa re wuniré wandéka gayawun duka wambula yitawuni. ");
INSERT INTO wos_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Yiwut guni wunika hwaka hwakéfatikétanguni. Hwakéfatika guni rewuka hafwaré yamba yakénguni.” ");
INSERT INTO wos_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Wungi wandéka di Judana néma du di hafu buléta di wa, “Dé yingiré yindét nani déka hwakéfatikétame? Grikna héfambu rekwa Judana du takwaka ye Grikna du takwaré déka jémbaka wakwetandé wana? ");
INSERT INTO wos_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Dé angi dé wa, ‘Guni wunika hwaka hwakéfatikétanguni. Guni wuni rewuka hafwaré yamba yakénguni.’ Ané hundina mo hundi yingi dé?” Wungi di di hafu wa. ");
INSERT INTO wos_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Némafwi hénoo sa nukwana hukétéfi nukwa yandéka di séfélak du takwa re. Rendaka dé Jisas téta hambukmbu wa, “Guni hulinguka hiyae wunika mé yae hulingu sa. ");
INSERT INTO wos_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Guni wunika jémba sarékéngut guna mawulimbu huli mawuli hwekwa hulingu xaakwa sukweka blekétandé. Wun jooka hanja di hayi, Godna nyingambu.” Wungi dé Jisas wa. ");
INSERT INTO wos_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Dé wungi wandén dé Godna Hamwinya déka jémba sarékékwa du takwana mawulimbu wulaaye tétendékaka dé Jisas wa. Jisas wungi wandén nukwa dé Godna getéfaré wambula yihafi yandéka Godna Hamwinya gayahambandé. ");
INSERT INTO wos_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Du takwa nawulak wun hundi xékétaka di wa, “Wu mwi hundi dé. Dé haxémbeka profet dé.” ");
INSERT INTO wos_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Wungi wandaka nawulak di wa, “Yinga. Dé God wasékendén du Krais dé.” Wungi wandaka nawulak di wa, “Yinga. Wun du Galilimbu dé ya. God wasékendén du Krais Galilimbu yamba yakéndé. ");
INSERT INTO wos_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Hanja Godna nyingambu déka angi di hayi: God wasékendén du Krais Devitna hémémbu xakutandé. Dé hanja Devit rendén getéfa Betlehemémbu xakutandé. Wungi di hayi.” Wungi di wa. ");
INSERT INTO wos_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Wun hundi xékétaka watémbéra di hafu hafu re. ");
INSERT INTO wos_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Reta di nawulak Jisasré hura séndé gembu takanjoka di mawuli ya. Mawuli yata déré huruhambandi. ");
INSERT INTO wos_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Wungi hurundaka di gélindu di Farisi, prisna néma duka wambula yi. Yindaka di diré wakwexéké, “Métaka we guni déré hura yahafi ye?” ");
INSERT INTO wos_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Wakwexékéndaka di gélindu wa, “Hanja du nak dé buléndékangala hundi buléhambandé.” ");
INSERT INTO wos_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Wungi wandaka di Farisi wa, “Yingi maki dé gunika akwi yéna ye? ");
INSERT INTO wos_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Nana néma du akwi nani Farisi akwi nani atéfék déka sarékéhambame. ");
INSERT INTO wos_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Nana hambuk hundika xékélakihafi du takwa male di déka hundi xéké. Hukémbu God wandét di haraki hafwaré yitandi.” Wungi di Farisi wa. ");
INSERT INTO wos_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Nikodemus akwi dé Farisi dé, hanja Jisaska yindé du dé. Nikodemus deka hundi xékétaka dé wa, ");
INSERT INTO wos_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","“Nana hambuk hundi xékéta angi nani huru. Duna hundi xékéta hurundén haraki saraki sémbutka akwi xékétaka néma du watandé, ‘Wu haraki sémbut hurukwa du dé. Hurundén haraki sémbut déré hasa hwetame.’ Wungi watandé. Tale dé wun duna hundi xékétandé. Xékétaka déré haraki hundi watandé. Déré baka haraki hundi yamba wakéndé. Wun du wandén maki, nani Jisaska baka haraki hundi yamba wakéme. Tale déka hundi xékétame.” ");
INSERT INTO wos_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Wungi wandéka di déré haraki hundi wata di wa, “Méni akwi Galilina méni? Godna nyingambu mé jémba xe xékélakitaméni. Godna profet Galilimbu yamba xakukéndé.” Wungi di wa. ");
INSERT INTO wos_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Wun hundi wataka di deka geré yi. ");
INSERT INTO wos_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Yindaka dé Jisas Oliv némburé wari. ");
INSERT INTO wos_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Wara re ganémbambu dé naande ye tempelré wambula yi. Yindéka di atéfék du takwa déka ya. Yandaka re dé diré Godka wakwe. ");
INSERT INTO wos_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Wakwendéka di xékélelakikwa du akwi Farisi akwi di takwa hésiré hura ya. Wule takwa lé nak du wali haraki sémbut huruléka di xé. Hura yae di wandaka lé nyéndékmbu té. ");
INSERT INTO wos_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Téléka di Jisaska angi wa, “Wakwekwa du, ale takwa lé nak du wali haraki sémbut huruta hwaléka me xé. ");
INSERT INTO wos_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Hanja Moses Godna nyingambu wungi hurukwa takwaka dé angi hayi, ‘Wungi hurukwa takwaré motumbu naake xiyatanguni. Xiyangut hiyatalé.’ Wungi dé Moses hayi. Méni yingi méni we, wule takwaka?” ");
INSERT INTO wos_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Di Jisaska hurukwexénjoka di wungi wa. Tale di hafu di angi wa, “Nani Jisaska wun jooka wakwexékémbet dé naniré haraki hundi hasa wandét, nani déré duna makambu takatame.” Di Jisaska wungi wandaka dé Jisas wandé dae dé déka sékétambambu héfambu hayi. ");
INSERT INTO wos_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Hayindéka wumbu téta wambula wakwexékéndaka Jisas raama dé diré wa, “Ambu tékwa du nak hanja haraki saraki sémbut huruhafi ye mé tale naki motu léka.” ");
INSERT INTO wos_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Wungi wataka wambula wandé dae dé héfambu hayi. ");
INSERT INTO wos_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Wungi hayita rendéka déka hundi xékétaka di nak nak wun hafwa yatakataka di yi. Gwalefa du tale yindaka di wayikana du deka hukémbu yi. Yindaka dé Jisas hafu rendéka lé wule takwa wumbu té. ");
INSERT INTO wos_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Jisas raama téta dé wule takwaré wa, “Nyénawa, wunde du yindu? Nyénika haraki hundi watekwa du ambu téhambwe, yingafwe?” ");
INSERT INTO wos_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Wungi wandéka lé wa, “Néma du, wunika haraki hundi watekwa du nak yingafwe.” Wungi waléka dé wa, “Wuni akwi haraki hundi nyénika yamba wakéwuni. Nyéni sé ye wambula haraki sémbut hurukényéni.” Wungi wandéka lé wungi yi. ");
INSERT INTO wos_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Jisas tempelmbu téta dé du takwaka wambula wa, “Wuni hafu wuni ané héfambu hanyikwa ya wuni. Du wuna hukémbu ye halékingambu yamba yikéndé. Yingafwe. Dé hanyikwa huli mawuli hératandé.” ");
INSERT INTO wos_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Wungi wandéka di Farisi wa, “Méni hafu ménika méni we. Waméka nani ména hundi yamba xékékéme.” ");
INSERT INTO wos_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Wungi wandaka dé Jisas wa, “Wuni hafu wunika wawuka wuna hundi mwi hundi male dé. Métaka we? Wuni yawun hafwaka akwi yitewuka hafwaka akwi wuni xékélaki. Guni yawun hafwaka akwi yitewuka hafwaka akwi xékélakihambanguni. ");
INSERT INTO wos_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Guni taku séfimbu huruwuka jooka xétaka guni haraki hundi we. Némbuli wuni du takwana hurundan sémbutka haraki hundi wahambwe. ");
INSERT INTO wos_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Wuni hafu jémba yahambawuni. Wunika wandéka yawun yafa dé wuni wali jémba dé ya. Yanaka wuni du takwana hurundan sémbutka wata wuni mwi hundi male watawuni. ");
INSERT INTO wos_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Guna hambuk hundimbu angi dé hayi: Du yéték natafa hundi male wambét, wumbére duna hundi wu mwi hundi dé. ");
INSERT INTO wos_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Wuni hafu wuna sémbutka wuni we. Wuna yafa wuniré wandéka yawuka dé akwi wuna sémbutka dé we. Ana hundi nata maki dé.” ");
INSERT INTO wos_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Dé wungi wandéka di wa, “Ména yafa yimbu dé re?” Wungi wandaka dé wa, “Guni wunika akwi wuna yafaka akwi xékélakihambanguni. Guni wunika xékélake wu wuna yafaka akwi xékélakitanguni.” ");
INSERT INTO wos_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Jisas wun hundi dé diré wa tempelmbu. Yéwa takandaka hafwambu téta dé diré wun hundi wa. Wandéka di déré huluke hura yihambandi, dé hiyatendéka nukwa wayika yakéndé. ");
INSERT INTO wos_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Jisas diré dé wambula wa, “Wuni yitawuni. Yiwut guni wunika hwakéfatikétanguni. Hwakéfatika hiyangut hurungun haraki saraki sémbut wungi tétandé. Guni yitewuka getéfaré yamba yikénguni.” ");
INSERT INTO wos_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Wungi wandéka di Judana néma du wa, “Métaka dé angi we, nani dé yitendéka getéfaré yamba yikéme. Dé dé hafuré xiyae hiyanjoka dé wungi wa, o yingi maki dé?” ");
INSERT INTO wos_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Di wungi wandaka dé wa, “Guni andélana guni. Wuni anwarna wuni. Guni ané héfana du guni. Wuni ané héfana du yingafwe. ");
INSERT INTO wos_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Guni wungi renguka wuni gunika angi wuni we, ‘Guni hiyangut hurungun haraki saraki sémbut wungi tétandé.’ Wuni hafu wuni wungi té. Guni wunika jémba sarékéhafi ye hiyangut, hurungun haraki saraki sémbut wungi tétandé.” ");
INSERT INTO wos_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Wungi wandéka di wa, “Méni héndé?” Di wungi wakwexékéndaka dé Jisas wa, “Hanja wuni guniré wundé wawu. ");
INSERT INTO wos_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Wuni guna hurungun sémbutka séfélak hundi hali wawu. Wunika wandéka yawun duna hundi male watawuni. Déka hundi mwi hundi dé. Déka hundi xékéta wuni ané héfambu rekwa du takwaka we.” ");
INSERT INTO wos_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Wungi wandéka di déka yafaka wandénka xékélakihambandi. ");
INSERT INTO wos_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Xékélakihafi yandaka dé Jisas wa, “Hukémbu Duna Nyanré harékétaka guni wunika xékélakitanguni. Wuni hafu wuni wungi té. Wuna mawuli sarékémbu joo nak yahambawuni. Wuna yafa wun jonduka wuniré wakwendéka wuni wakwendén jonduka male wuni we. Wungi akwi xékélakitanguni. ");
INSERT INTO wos_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Wuna yafa wunika wandéka yawuka dé wuni wali dé té. Wuni déka mawuli yandékangalambu male huruwuka dé wuniré yatakahambandé. Wuni hafu rehambawuni.” ");
INSERT INTO wos_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Wungi wandéka di séfélak du takwa déka jémba sarékéta déka hundika “Mwi hundi dé” di na. ");
INSERT INTO wos_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Wungi sarékéndaka dé Jisas wun jémba sarékékwa Judana du takwaka wa, “Guni wuna hundi xékéta wawun maki huruta guni wuna du takwa guni. Wu mwi hundi dé. ");
INSERT INTO wos_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Wuna du reta guni mwi hundika xékélakitanguni. Xékélakita guni nak duka baka jémba yakwa du maki yamba rekénguni. Guni jémba retanguni.” ");
INSERT INTO wos_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Wungi wandéka di déré wa, “Nani Abrahamna mandéka me. Hanja nani nak duka baka jémba yahambame. Nani jémba me re. Méni angi méni we, ‘Guni nak duka baka jémba yakwa du maki yamba rekénguni. Guni jémba retanguni.’ Métaka méni wungi we?” ");
INSERT INTO wos_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Di wungi wandaka dé Jisas wa, “Mwi hundi wuni guniré we. Du takwa di haraki saraki sémbut huru. Wungi huruta di haraki saraki sémbutna ekombu reta di wun sémbutna jémba yakwa du di re. ");
INSERT INTO wos_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Wunde jémba yakwa du takwa di yafana gembu wungi re wungi re rehafindi. Déka nyan male wungi re wungi re dé re, déka gembu. ");
INSERT INTO wos_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Wun nyan baka jémba yingute wandét, guni jémba yitanguni. Wu mwi hundi dé. ");
INSERT INTO wos_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Wuni xékélaki. Guni Abrahamna mandéka guni. Wungi renguka wuna hundi guna mawulimbu téhambwe. Téhafi yandéka guni wuniré xiyanjoka guni huru. ");
INSERT INTO wos_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Wuni wuna yafa wali reta xéwun jonduka wuni guniré we. Wawuka guni guna yafana hundi male guni xéké.” Wungi dé Jisas wa. ");
INSERT INTO wos_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Jisas wungi wandéka di wa, “Nana yafa Abraham dé.” Wungi wandaka dé Jisas wa, “Guni Abrahamna mandéka guni. Wu mwi hundi dé. Métaka guni hurundén sémbut huruhafi ye? ");
INSERT INTO wos_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","God wunika mwi hundi wandéka xéka wuni gunika wun hundi wa. Wawuka némbuli wuniré xiyanjoka guni huru. Abraham wungi huruhambandé. ");
INSERT INTO wos_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Guni guna yafa hurundén maki male guni huru.” Dé wungi wandéka di wa, “Nana ayiwa yambumbu te naniré hérahambalé. Nana yafa natafa male dé God dé.” ");
INSERT INTO wos_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Wungi wandaka dé Jisas wa, “Wuni God wali re wuni gaya. Wuna mawuli sarékémbu gayahambawuni. God wandéka wuni gaya. God guna yafa xe, guni wunika némafwimbu mawuli yatanguni. ");
INSERT INTO wos_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Métaka we guni wuna hundika xékélakihafi ye? Guni wuna hundi xékénjoka yamba hali xékéngu. ");
INSERT INTO wos_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Guni satanéna nyangwal guni. Wungi reta guni guna yafana mawuli yandéka makimbu guni jémba ye. Hanja akwi némbuli akwi dé du takwaré xiyandéka di hiya. Wungi yata mwi hundi xékéhambandé. Dé yénataka hundi male dé wa. Yénataka hundi wu déka hundi dé. Dé yénataka hundina yafa dé. ");
INSERT INTO wos_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Guni déka nyangwal renguka wuni mwi hundi male wawuka guni wuna hundika hélék yata wuna hundika jémba sarékéhambanguni. ");
INSERT INTO wos_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Wuni haraki saraki sémbut huruhambawuni. Huruwun haraki saraki sémbutka guna du nak wunika haraki hundi wanjoka dé hurufatiké. Wuni mwi hundi wawuka métaka guni wuna hundi xékéhafi ye? ");
INSERT INTO wos_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Godna nyangwal atéfék di déka hundi xéké. Guni Godna nyangwal yingafwe. Wungi reta guni déka hundi jémba xékéhambanguni.” Wungi dé Jisas wa. ");
INSERT INTO wos_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Wandéka di Judana néma du Jisasré haraki hundi wata di wa, “Nani angi wa, ‘Méni samariana du méni. Haraki hamwinya ména mawulimbu dé té.’ Némbuli nani xékélaki wambeka hundi wu mwi hundi dé.” ");
INSERT INTO wos_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Wungi wandaka dé Jisas wa, “Wunimbu haraki hamwinya téhambwe. Wuni wuna yafana ximbu harékéwuka guni wuna ximbu harékéhambanguni. ");
INSERT INTO wos_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Wuni wuna ximbu harékénjoka hélék wuni ye. Nak dé wuna ximbu harékénjoka dé wuna sémbutka xéta watandé. ");
INSERT INTO wos_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Mwi hundi wuni guniré we. Wuna hundi jémba xékékwa du takwa yamba hiyakéndi.” ");
INSERT INTO wos_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Dé wungi wandéka di néma du wa, “Ména mawulimbu haraki hamwinya dé té. Némbuli wungi nani xékélaki. Abraham wundé hiyandé. Hiyandéka Godna profet akwi wundé hiyanda. Hiyandaka méni angi méni we, ‘Wuna hundi jémba xékékwa du takwa yamba hiyakéndi.’ Métaka méni wungi we? ");
INSERT INTO wos_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Nana mandéka Abraham wundé hiyandé. Méni déré méni sarékéngwandé, o yingi maki dé? Godna profet akwi wundé hiyanda. Méni héndé? Ménika yingi méni we?” ");
INSERT INTO wos_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Di wungi wandaka dé Jisas wa, “Wuni wuna ximbu hafu harékéwut, wuna xi wu baka joo dé. Wuna yafa hafu wuna ximbu harékéndéka guni déka angi wa, ‘Dé nana God dé.’ ");
INSERT INTO wos_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Wungi wata guni déka xékélakihambanguni. Wuni déka wuni xékélaki. Wuni angi wawut, ‘Wuni déka yike wuni ye.’ Wungi wata wuni guni maki yéna yakwa du wuni. Wuni déka xékélakita wuni wandén maki huru. ");
INSERT INTO wos_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Guna mandéka Abraham jémba yatewuka nukwaka xékélakita dé mawuli sawuli ya. Yata xéndéka déka mawuli yikafre dé ya.” ");
INSERT INTO wos_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Wungi wandéka di néma du wa, “Ména héki hwari séfélak yingafwe. Yingi maki méni Abrahamré xé?” ");
INSERT INTO wos_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Wungi wandaka dé Jisas wa, “Mwi hundi wuni guniré we. Hanja Abraham xakuhafi yandéka wuni re.” ");
INSERT INTO wos_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Wungi wandéka di mawuli wiya di motu héra, dé hiyandéte déré xiyanjoka. Hérandaka dé Jisas faakwa ye tempel yatakataka dé gwande yi. ");
INSERT INTO wos_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Jisas yambumbu ye dé xé dama hiyandé du nakré. Déka ayiwana biyambu dama hiyae rendéka lé héra. ");
INSERT INTO wos_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Wungi xéndéka Jisasna du déré wakwexéké, “Wakwekwa du, héndé haraki sémbut hurukwa lé déka ayiwa dama hiyae rendéka héra? Wun du haraki sémbut dé huru, o déka yafa ayiwa bér haraki saraki sémbut huru?” ");
INSERT INTO wos_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Wungi wandaka dé Jisas wa, “Wun du akwi déka yafa ayiwa akwi haraki sémbut huruhambandi, dé wungi rendéte. Guni déré God yatendéka hambuk jémba xéngute dé déka dama hiya. ");
INSERT INTO wos_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Némbuli nukwa dé. Nani God hwendén jémba yatame. Dé wandéka wuni ya. Gan hunyindét nak du déka jémba yamba yakéme. ");
INSERT INTO wos_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Wuni ané héfambu reta wuni ané héfana xérékékwa ya wuni.” Wungi dé wa. ");
INSERT INTO wos_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Wataka dé héfambu simbar séxa. Séxataka dé héfa wali nawulak hérae dé wun duna damambu taka. ");
INSERT INTO wos_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Takataka dé déré wa, “Sé ye Siloam hutungumbu yaké.” (Siloamna mo hundi angi dé: Wandaka dé yi.) Wungi wandéka ye dé wun hutungumbu yaké. Yakéndéka déka dama yikafre yandéka jémba xe dé wambula ya. ");
INSERT INTO wos_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Wun du wambula yandéka déka nyémayika akwi déré hanja xéndé du takwa akwi déré xe di wa, “Ané du hanja yambumbu reta yéwa hwendate wandé du wana?” ");
INSERT INTO wos_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Wungi wandaka di nawulak wa, “Xéxé, dé wun du dé.” Nawulak di wa, “Yinga. Dé maki du dé.” Wungi wandaka dé wun du wa, “Xéxé. Ané wuni wuni.” ");
INSERT INTO wos_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Wungi wandéka di déré wa, “Yingi maki yaméka dé ména dama yikafre ya?” ");
INSERT INTO wos_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Wungi wakwexékéndaka dé wa, “Du nak déka xi Jisas dé héfa hérae simbar séxataka dé wuna damambu taka. Takataka dé wuniré wa, ‘Sé ye Siloam hutungumbu yaké.’ Wungi wandéka ye wuni hutungumbu yakéwuka dé wuna dama yikafre yandéka wuni jémba xé.” ");
INSERT INTO wos_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Wungi wandéka di déré wa, “Wun du yindu?” Wungi wakwexékéndaka dé wa, “Wafewana. Yike wuni ye.” Wungi dé wa. ");
INSERT INTO wos_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Di dama hiyae yikafre yandé duré Farisika hura yi. ");
INSERT INTO wos_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Baka hwa nukwa dé Jisas héfa hérae simbar séxataka dé wun duna damambu takandéka dé yikafre ya. ");
INSERT INTO wos_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Hura yindaka Farisi di déré wambula wakwexéké, “Ména dama yingi maki ye dé yikafre ya?” Wungi wakwexékéndaka dé wa, “Héfa hérae simbar séxataka wandéka yakéwuka dé wuna dama yikafre ya.” ");
INSERT INTO wos_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Wungi wandéka di Farisi nawulak wa, “Wun du baka hwa nukwambu jémba yata dé nana hambuk hundi xékéhambandé. Xékéhafi yandéka nani xékélaki. God déré wandéka yahambandé.” Wungi wandaka di nawulak wa, “Haraki sémbut hurukwa du dé yikafre jémba yamba yakéndé.” Wungi wataka di watémbéra di hafu hafu re. ");
INSERT INTO wos_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Wungi reta di dama hiyandé duré wambula wa, “Ména damaré yikafre hurundé duka yingi méni we?” Wungi wakwexékéndaka dé wa, “Dé Godna profet nak dé.” Wungi dé wa. ");
INSERT INTO wos_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Hanja wun duna dama dé hiya. Némbuli déka dama yikafre dé ya. Yandéka di Judana néma du wun jooka “Mwi hundi dé” nahambandi. Nahafi yata di dama hiyandé duna yafa ayiwaka hundi taka. ");
INSERT INTO wos_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Takandaka yambéka di bérré wakwexéké, “Ané béna nyan dé, o yingafwe? Ayiwa héraléka dé dama hiya. Béni wungi béni wa, o yingafwe? Yingi maki ye dé dama xé?” ");
INSERT INTO wos_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Wungi wandaka bér angi wa, “Ani ani xékélaki. Dé ana nyan dé. Dé dama hiyae re dé xaku, ayiwana biyambu. Wunka ani xékélaki. ");
INSERT INTO wos_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Némbuli dama lae xéndéka ani yike ani ye. Méta yandéka wana déka dama landé. Héndé hurukwa wana landé. Wunka yike ani ye. Déré mé guni wakwexéké. Dé néma du dé. Dé hafu watandé.” ");
INSERT INTO wos_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Judana néma du bérré haraki hundi wandamboka bér wungi wa. Tale néma du di angi wa, “Du nak ‘Jisas God wasékendén du Krais dé’ nandét wambet wun du Godna hundi buléndaka ge yatakataka ye wambula yamba wulayikéndé.” Wungi di wa. ");
INSERT INTO wos_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Di bérré wungi wandamboka bér wun duna yafa ayiwa roo. Roota bér wa, “Dé néma du dé. Déré mé guni wakwexéké.” ");
INSERT INTO wos_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Bér wungi wambéka di néma du wun duré wambula wa. Wandaka yandéka di déré wa, “Méni mwi hundi wata Godna ximbu harékétaméni. Nani nani xékélaki. Jisas dé haraki saraki sémbut hurukwa du dé.” ");
INSERT INTO wos_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Wungi wandaka dé diré wa, “Wuni yike wuni ye. Dé yikafre du wana haraki du wana. Angi male wuni xékélaki. Hanja wuna dama dé hiya. Némbuli wuna dama yikafre yandéka wuni jémba xé.” ");
INSERT INTO wos_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Wungi wandéka di wa, “Méniré méta dé ya? Yingi ye hurundéka ména dama yikafre ya?” ");
INSERT INTO wos_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Wungi wakwexékéndaka dé wa, “Tale wundé wawu. Wawuka guni xékéhambanguni. Métaka guni wambula xékénjoka mawuli ya? Guni akwi déka du xakunjoka guni mawuli ye, o yingi maki dé?” ");
INSERT INTO wos_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Wungi wandéka di déré haraki hundi wata di wa, “Méni déka du méni. Nani Mosesna du me. ");
INSERT INTO wos_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Nani angi nani xékélaki God Moses wali dé hundi bulé. Wun duka yike me ye. Yandén hafwaka akwi yike me ye.” ");
INSERT INTO wos_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Wungi wandaka dé wa, “Yingi maki dé? Ané nak maki guni we. Dé wuna dama dé hula. Hulandéka dé yandén hafwaka yike guni ye. ");
INSERT INTO wos_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Nani xékélaki. God haraki saraki sémbut hurukwa duna hundi xékéhafindé. Déka jémba sarékéta déka jémba yakwa duna hundi dé xéké. ");
INSERT INTO wos_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Hanjambu yae némbuli du nak dama hiyae rendéka déka ayiwa héraléka du nak déka dama hulandéka xékéhambame. ");
INSERT INTO wos_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","God wun du takahafi yandét wun du angina joo yamba hurukéndé.” ");
INSERT INTO wos_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Wungi wandéka di mawuli wita di wa, “Ména yafa ayiwa haraki saraki sémbut hura bér méniré héra. Hérambéka méni akwi haraki saraki sémbut hurukwa du méni. Wungi reta yingi maki ye méni naniré wakwetaméni.” Wungi wataka di wa, “Godna hundi buléndaka ge yatakataka gwande wambula yamba wulayikéméni.” Wungi wandaka dé yi. ");
INSERT INTO wos_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Wun du yindéka Jisas xékétaka déka hwaka xe dé déré wa, “Méni Duna Nyanka jémba méni saréké, o yingafwe?” ");
INSERT INTO wos_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Wungi wandéka dé wa, “Néma du, wun du héndé? Méni wuniré wamét wuni déka jémba sarékétawuni.” ");
INSERT INTO wos_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Wungi wandéka dé Jisas wa, “Méni déré wundé xémé. Wun du némbuli méni wali andé buléndi.” ");
INSERT INTO wos_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Wungi wandéka dé wa, “Néma Du, wuni ménika andé sarékéwi.” Wungi wataka dé héfambu hwati se dé Jisasna ximbu haréké. ");
INSERT INTO wos_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Wungi hurundéka dé Jisas wa, “Wuni du takwana sémbutré xe wanjoka wuni ané héfaré gaya. Dama hiyandé du jémba xétandi. Jémba xékwa du dama hiyandé du xakutandi.” ");
INSERT INTO wos_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Wungi wandéka di Farisi nawulak wumbu reta wun hundi xékéta di déré wa, “Yingi méni we? Nani akwi dama hiyandé du me, o yingafwe?” ");
INSERT INTO wos_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Wungi wakwexékéndaka dé wa, “Guni dama hiyandé du reta guni guni haraki sémbut huruhafi yakwa du retanguni. Guni guni wa, ‘Nani jémba me xé.’ Wungi wanguka guna haraki sémbut wungi dé té.” Wungi dé Jisas Farisiré wa. ");
INSERT INTO wos_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Jisas dé wa, “Mwi hundi wuni guniré we. Du nak sipsip bali tékwa hafwaré wulayinjoka mawuli ye, yambuka hélék ye, séndémbu wuréféka wulayindét, wun du sélé héraata jondu nyéngélékwa du dé. ");
INSERT INTO wos_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Yambumbu wulayikwa du dé sipsip balika hatikwa du dé. ");
INSERT INTO wos_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Wun du wulayinjoka yandéka dé yambumbu tékwa du dé yambu nafwi. Nafwindéka wulayindéka di sipsip bali déka hundi xéké. Déka sipsip balina ximbu dé wa. Wataka tale yindéka di déka hundi xékéta di déka hukémbu yi. ");
INSERT INTO wos_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Yindaka dé tale yindéka déka sipsip bali déka hundika xékélakita di déka hukémbu yi. ");
INSERT INTO wos_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Di nak duna hukémbu yamba yikéndi. Di déka hundika xékélakihafi ye déka roo yaange yitandi.” ");
INSERT INTO wos_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Jisas wun sataku hundi wandéka di wun hundina mo hundika xékélakihambandi. ");
INSERT INTO wos_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Xékélakihafi yandaka dé Jisas wambula wa, “Mwi hundi wuni guniré we. Wuni sipsip bali wulayindaka yambu wuni. ");
INSERT INTO wos_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Du nawulak tale yandaka wuni deka hukémbu ya. Tale yandé du di sélé héraata jondu nyéngélékwa du di. Di yandaka sipsip bali deka hundi xékéhambandi. ");
INSERT INTO wos_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Wuni hafu wuni yambu wuni. Du takwa wunimbu wulayindat God diré yikafre hurutandé. Di wulayita yikafre hénoo hérae satandi. ");
INSERT INTO wos_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Sélé héraakwa du sélé héraata sipsip baliré xiyaata sipsip baliré haraki hurunjoka dé ya. Wuni diré yikafre huruta huli mawuli hwenjoka wuni ya. Hwewut huli mawuli dimbu sukwekéndét, di mawuli yata wungi re wungi re jémba retandi. ");
INSERT INTO wos_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","“Wuni hafu wuni sipsip balika hatikwa yikafre du wuni. Sipsip balika hatikwa yikafre du dé déka sipsip baliré yikafre hurunjoka hurundét déka mama déré xiyandat dé hiyatandé. ");
INSERT INTO wos_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Yéwaka jémba yakwa du dé sipsip balika hatikwa du yingafwe. Dé sipsip balina yafa yingafwe. Wungi rendéka haraki wasa yandat, dé sipsip bali yatakataka yaange yitandé. Yaange yindét haraki wasa sipsip baliré tinjoka nambwandat, di sipsip bali yaange yitandi. ");
INSERT INTO wos_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Wun du yéwaka male jémba yata dé sipsip balika saréfa nahafi ye yaange yitandé. ");
INSERT INTO wos_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","15","“Wuni hafu wuni sipsip balika hatikwa yikafre du wuni. Wuna yafa wunika xékélakindéka wuni déka xékélakiwuka maki wuni wuna sipsip balika xékélakiwuka di wunika xékélaki. Wuna sipsip baliré yikafre hurunjoka huruwut, di wuna mama wuniré xiyandat hiyatawuni. ");
INSERT INTO wos_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Wuna sipsip bali nawulak akwi di té, nak séndémbu. Wuni diré akwi hura yatawuni. Hurewut di wuna hundi xékétandi. Hurewut di tale téndé sipsip bali wali sékéré téndat bu natafa male du hati dé. ");
INSERT INTO wos_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","“Wuni diré yikafre hurunjoka hiyae wuni wambula ramétawuni. Wungi yatewukaka wuna yafa dé wunika némafwimbu mawuli ya. ");
INSERT INTO wos_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Wuni hélék yawut di wuniré yamba xiyakéndi. Wuni hafu yawundu nawut di wuniré xiyandat hiyatawuni. Wu wuna jémba dé. Wuni hambuk ye yawundu nawut wuniré xiyandat hiyae hambuk hérae wambula ramétawuni. Wun jémba yawute wuna yafa dé wuniré wa.” Wungi dé wa. ");
INSERT INTO wos_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Wungi wandéka di Judana néma du wun hundi xékétaka watémbéra di hafu hafu re. ");
INSERT INTO wos_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Reta di séfélak du wa, “Haraki hamwinya déka mawulimbu téndéka dé wangété ya. Guni déka hundi xékékénguni.” ");
INSERT INTO wos_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Di wungi wandaka di nawulak wa, “Yingafwe. Haraki hamwinya déka mawulimbu téndét wungina hundi yamba bulékéndé. Hanja dé wandéka dé dama hiyandé du jémba xé. Haraki hamwinya wandét dama hiyandé du wambula yamba xékéndé.” Wungi di wa. ");
INSERT INTO wos_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Jerusalemémbu di némafwi hénoo sanjoka di ya. Wun hénoo sa nukwa di deka mandéka hanja tempel wambula tondanka di saréké. ");
INSERT INTO wos_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Wun nukwa yifa yakwa nukwa dé. Wun nukwa tempelmbu dé Jisas yitaka yataka. Gena tafékambu dé yitaka yataka. Wun tafékaka di wa, Solomonéna taféka dé. ");
INSERT INTO wos_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Wun tafékambu yitaka yatakandéka di Judana néma du yae hérangwanda téta di déré wa, “Méta nukwa méni naniré wamét nani ménika jémba xékélakitame? Méni God wasékendén du Krais xe naniré jémba mé wa.” Wungi di wa. ");
INSERT INTO wos_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Wandaka dé Jisas wa, “Wuni guniré wundé wawu. Wawuka guni jémba xékéhambanguni. Wuna yafa hambuk hwendéka wuni déka jémba ye. Guni yawuka jémbaré jémba xe wunika xékélakitanguni. ");
INSERT INTO wos_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Guni wuna sipsip bali yingafwe. Guni wuna hundi xékéhafi guni. ");
INSERT INTO wos_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Wuna sipsip bali wuna hundi di xéké. Xékéndaka wuni dika xékélakita tale yiwuka di wuna hukémbu yi. ");
INSERT INTO wos_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Yindaka wuni dika huli mawuli hwe, wungi re wungi re jémba rendate. Di yamba hiyakéndi. Wuna tambambu rendat du nak diré yamba hérakéndé. ");
INSERT INTO wos_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Wuna yafa dé diré wunika hwe. Déka hambuk atéfék duna hambukré dé sarékéngwandé. Déka hambuk wungi téndét nak du wuna sipsip baliré yamba hérakéndé, wuna yafana tambambu. ");
INSERT INTO wos_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Ani wuna yafa wali natafa ani.” ");
INSERT INTO wos_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Dé wungi wandéka di Judana néma du motu wambula hérae di dé hiyandéte déré xiyanjoka di huru. ");
INSERT INTO wos_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Hurundaka dé Jisas diré wa, “Wuni wuna yafana séfélak yikafre jémba yawuka guni xé. Guni méta jémbaka sarékéta guni wuniré motumbu xiyanjoka huru?” ");
INSERT INTO wos_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Dé wungi wandéka di néma du wa, “Nani yikafre jémbaka sarékéta nani méniré motumbu xiyanjoka huruhambame. Méni Godka haraki hundi wata méni haraki saraki hundi bulé. Méni du male du méni. Méni baka du reta méni hafuka ‘Wuni God wuni’ naméka nani méniré motumbu xiyanjoka huru.” Wungi di wa. ");
INSERT INTO wos_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Wandaka dé wa, “Yingi maki dé? Guna hambuk hundimbu angi di hayi: ‘Wuni angi wuni we, Guni god guni.’ ");
INSERT INTO wos_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","God déka hundi xékéndé duka dé angi wa, ‘Guni god guni.’ Wungi wandéka wun hundi déka nyingambu rendéka dé déka hundi yamba yatakakéndé. ");
INSERT INTO wos_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","God dika wungi wandéka, wuni wun hundi male wawuka métaka guni wunika haraki hundi we? Wuna yafa dé wuniré wa, du takwaré yikafre huruwute. Wuniré wandéka wuni ané héfaré gaya. Gaye wuni wa, ‘Wuni Godna nyan wuni.’ Wungi wawuka guni wa, ‘Méni wun hundi wata méni Godka haraki hundi méni we.’ Métaka guni wungi we? ");
INSERT INTO wos_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Wuni wuna yafana jémba yahafi yawut, guni wuna hundi yamba xékékénguni. ");
INSERT INTO wos_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Wuni déka jémba yawut, guni wuna hundi xékénjoka hélék yata yawuka jémbaka mé jémba saréké. Guni wungi sarékéta xékélakitanguni. Wuna yafa wunimbu téndéka wuni akwi wuna yafambu wuni té.” ");
INSERT INTO wos_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Wungi wandéka di déré wambula hulukinjoka di huru. Hurundaka dé yindéka di déré hulukihambandi. ");
INSERT INTO wos_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Jisas wambula ye dé jordan xéri angé sakuré yi. Ye dé Jon diré guré husandandén hafwambu xaku. Xaakwa dé wun hafwambu re. ");
INSERT INTO wos_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Rendéka di séfélak du takwa déka ya. Yae xétaka di hafu buléta di wa, “Jon hanja xéhafi yamben hambuk jémba huruhambandé. Huruhafi yata wun duka wata mwi hundi male dé wa.” ");
INSERT INTO wos_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Wungi wataka di wumbu rekwa du takwa séfélak di déka jémba sarékéta di wa, “Jisas Godna nyan dé. Wu mwi hundi dé.” ");
INSERT INTO wos_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Betanimbu rendé du nak, déka xi Lasarus, dé bar hiya. Betani Maria bér léka nyama Martana motéfa dé. ");
INSERT INTO wos_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Wule takwa Maria lé hukémbu yikafre yama xaakwa hulingu blekékwa takwa lé. Hukémbu lé wun hulingu Néma Du Jisasna manmbu blekétalé. Blekétaka lé léka némbémbu létékétalé. Wule takwana hee Lasarus bar dé hiyae. ");
INSERT INTO wos_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Bar hiyandéka dé Jisas afakémbu rendéka bér Lasarusna nyange yéték ané hundi wambéka ye di Jisaska wa: “Néma Du, némafwimbu mawuli yaméka du bar dé hiyae.” ");
INSERT INTO wos_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Jisas wun hundi xékétaka dé wa, “Dé hiyandéte wun bar xakuhambandé. Du takwa Godna ximbu harékéta wuna ximbu akwi harékéndate dé wun bar xaku.” Wungi dé wa. ");
INSERT INTO wos_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Jisas dé Marta akwi, léka bandi akwi, Lasaruska akwi dé némafwimbu mawuli ya. ");
INSERT INTO wos_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Mawuli ye dé Lasarus bar hiyandékaka xékétaka dé rendén getéfambu nukwa yéték akwi re. ");
INSERT INTO wos_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Re dé déka duré wa, “Judiaré wambula yitame.” ");
INSERT INTO wos_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Wungi wandéka di déka du wa, “Néma du, némbule di méniré motumbu xiyanjoka huru. Hurundaka métaka méni wun hafwaré wambula yinjoka we?” ");
INSERT INTO wos_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Wungi wandaka dé Jisas wa, “Ganémbambu take ye gérambumbu nukwa xéta laréta tékwandé. Du nukwambu ye ané héfana hanyikwa yana larékombu ye yamba xakrikéndé. ");
INSERT INTO wos_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Du halékingambu yindét, wun du xakritandé, wun hanyikwa ya déka mawulimbu téhafi yandénka.” ");
INSERT INTO wos_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Wungi wataka dé diré wambula wa, “Nana nyayika Lasarus xéndi dé hwae. Wuni ye déré husaramétawuni.” ");
INSERT INTO wos_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Wungi wandéka di déka du wa, “Néma Du, dé baka xéndi hwandét, déka bar hényitandé.” ");
INSERT INTO wos_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Tale Jisas Lasarus hwandénka wata dé Lasarus hiyandénka dé wa. Wungi wandéka di déka du Lasarus hiyandénka xékélakihambandi. Di angi saréké, “Dé baka xéndi dé hwae.” ");
INSERT INTO wos_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Wungi sarékéndaka dé diré wa, “Lasarus bu hiya. ");
INSERT INTO wos_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Hiyandéka wuni dé wali rehambawuni. Guni wuna hambukéka xékélakingute wuni déka yihafi yawuka dé wuna mawuli yikafre ya. Némbuli déka yitame.” ");
INSERT INTO wos_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Wungi wandéka déka du nak Tomas, déka nak xi Didimas dé Jisasna du nawulakré wa, “Nani akwi ye dé wali hiyatame.” ");
INSERT INTO wos_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Wungi wandéka di Jisas déka du wali yi. Ye xaakwa dé Jisas hundi xéké, Lasaruska. Lasarus nukwa yétiyéti dé réméndan wekwambu hwa. ");
INSERT INTO wos_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Betani Jerusalem wali walémbambu dé té (3 kilomita maki). ");
INSERT INTO wos_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Marta bér Mariana hee hiyandéka di séfélak du takwa Jerusalem yatakataka di Betaniré yi, bér wali reta bérka mawuliré yikafre hurunjoka. ");
INSERT INTO wos_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Jisas yambumbu yandéka lé Marta hundi xéké. Xékétaka Jisasré yambumbu xénjoka lé yi. Yiléka Maria gembu lé re. ");
INSERT INTO wos_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Reléka ye Jisasré xe lé Marta wa, “Néma Du, méni ambu remét wuna hee yamba hali hiyandé. ");
INSERT INTO wos_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Némbuli akwi Godré wakwexékémét, wakwexékémén joo hwetandé. Wungi wuni xékélaki.” ");
INSERT INTO wos_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Wungi waléka dé Jisas wa, “Nyéna hee wambula ramétandé.” ");
INSERT INTO wos_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Wungi wandéka lé Marta wa, “Wuni xékélaki. Hiyandé atéfék du takwa ramétendaka hukétéfi nukwambu ramétandé.” ");
INSERT INTO wos_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Wungi waléka dé Jisas wa, “Wuni hafu hiyandé du takwaré husaraméta huli mawuli hwekwa du wuni. Du takwa wunika jémba saréka hiyandat, wuni wawut di wambula ramétandi. ");
INSERT INTO wos_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Du takwa wunika jémba sarékéta huli mawuli hérae di yamba hiyakéndi. Di jémba retandi. Ané hundika ‘Mwi hundi dé’ nyéni nae, o yingafwe?” ");
INSERT INTO wos_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Wungi wandéka lé wa, “Néma Du, wu mwi hundi dé. Méni God wasékendén du Krais méni. Méni Godna nyan méni. Méni haxémbeka du méni. Wu mwi hundi dé.” Wungi lé wa. ");
INSERT INTO wos_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Marta wungi wataka ye lé léka bandi Mariaré wa. Waléka yaléka hura ye hafwambu téta lé nakélak wa, “Wakwekwa du yae téta nyéniré xénjoka dé we.” ");
INSERT INTO wos_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Wungi waléka lé bari raama lé Jisasré xénjoka yi. ");
INSERT INTO wos_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Jisas wungi ye getéfambu xakuhambandé. Dé Marta déré xélén hafwambu dé té. ");
INSERT INTO wos_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Wumbu téndéka lé Maria déré xénjoka yiléka di lé wali rendé du takwa xé. Tale wunde du takwa Mariana mawuli yikafre yandéte di Jerusalem yatakataka yae di lé wali re gembu. Lé raama hafwaré bari gwandiléka xe di wa, “Lasarusré réméndanmbu géranjoka lé gwandi.” Wungi wataka di léka hukémbu raama yi. ");
INSERT INTO wos_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Wungi ye lé Jisas téndénmbu xaakwa lé Maria Jisasré xé. Xétaka hwati se lé déré wa, “Néma Du, ambu remét wuna hee yamba hali hiyandé.” ");
INSERT INTO wos_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Wungi wata géraléka dé Jisas xé. Jerusalemémbu yandé du takwa akwi lé wali yaata gérandaka dé xé. Xétaka saréfa nandéka déka mawulimbu némafwimbu xak dé ya. ");
INSERT INTO wos_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Xak yandéka dé wa, “Déré yimbu guni rémé?” Wungi wakwexékéndéka di wa, “Néma Du, mé yae xé.” ");
INSERT INTO wos_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Wungi wandaka Jisas dé géra. ");
INSERT INTO wos_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Gérandéka xe di wa, “Mé xé. Dé wun duka némafwimbu dé mawuli ye.” ");
INSERT INTO wos_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Wungi wandaka di nawulak wa, “Hanja wandéka dé dama hiyandé du wambula xé. Dé Jisas wandét Lasarus yamba hiyakéndé wana? Métaka we dé déré huréhalékéhafi ye?” Wungi di nawulak wa. ");
INSERT INTO wos_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Jisasna mawulimbu némafwi xak yandéka ye dé réméndan wekwambu xaku. Wun wekwa motu wekwa dé. Wun wekwana yambumbu di némafwi motu nak gétamétaka. ");
INSERT INTO wos_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Jisas xaakwa dé wa, “Wun motu mé sérmené.” Wungi wandéka lé hiyandé duna nyange Marta lé déré angi wa, “Néma Du, hiyandéka nukwa yétiyéti bu yi. Nani motu rafwimbet haraki yama xatandé.” ");
INSERT INTO wos_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Wungi waléka dé Jisas wa, “Tale nyéniré wundé wawu, ‘Wunika jémba saréka Godna hambuk xétanyéni.’ Wun hundika mé saréké.” ");
INSERT INTO wos_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Wungi wandéka di motu sérmené. Sérmenéndaka Jisas nyirré yasawara xéta dé wa, “Wuna yafa, diména wuni nae, wuna hundi xékémékaka. ");
INSERT INTO wos_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Wuni xékélaki. Atéfék nukwambu méni wuna hundi xékémékandé. Ambu tékwa du takwaka sarékéta wuni méniré we. Di ménika wawuka hundi xékéta watandi, ‘God wandéka dé Jisas gaya. Wu mwi hundi dé.’ Wungi wandate wuni mawuli ye.” ");
INSERT INTO wos_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Wungi wataka dé hambukmbu wa, “Lasarus, méni sé raama gwande.” ");
INSERT INTO wos_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Wungi wandéka dé hiyandé du wambula raama gwande. Hanja nukwa wurmbu di déka man tamba giya giya taka. Déka saawi akwi nukwa wurmbu giya giya takandaka dé wungi hwa. Hwae raama gwandendéka dé Jisas wa, “Nukwa wur mé léfwingu yindé.” Wungi wandéka di léfwi. ");
INSERT INTO wos_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Mariaka yae lé wali rendé séfélak du takwa di xé Jisas wungi hurundéka. Xe di Jisas anwarmbu gayandénka di jémba saréké. ");
INSERT INTO wos_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Wandaka nawulak Farisika ye di Jisas hurundén jooka safé. ");
INSERT INTO wos_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Saféndaka di prisna néma du akwi Farisi akwi wandaka atéfék Judana néma du yae di Jisaska angi wa, “Wun du hanja xéhafi yamben séfélak hambuk jémba dé ya. Méta yatame? ");
INSERT INTO wos_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Nani déka jémbaka déré watéfihafi yambet dé téta wungi male hurundét atéfék du takwa déka ‘Nana néma du dé’ natandi. Nandat néma du reta Romna néma duna hafwa hérandét Romna du hélék yata yae tempelré haraki huruta nana du takwaré akwi xiyatandi.” Wungi di néma du wa. ");
INSERT INTO wos_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Wun héki hwari Kaiafas atéfék prisna néma du dé. Dé wunde néma duna hundi xékétaka dé diré wa, “Guni nawulak xékélakihambanguni. ");
INSERT INTO wos_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Mé xéké. Wun du Jisas atéfék du takwana hafwa hérae hiyandét, wungi sékérékétandé. Dé hafu hiyandét, nani atéfék yamba hiyakéme.” ");
INSERT INTO wos_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Wun hundi wata, déka mawuli sarékémbu wahambandé. Dé wun héki hwari prisna néma du rendéka God déré wandéka dé wun hundi wa, Jisas hiyae Judana du takwaré yikafre hurutendékaka. ");
INSERT INTO wos_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Jisas hiyae Judana du takwaré male yikafre yamba hurukéndé. Jisas atéfék getéfambu rekwa Godna nyangwalré hérae natafambu takanjoka dé hiya. ");
INSERT INTO wos_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Kaiafas wungi wandéka di Judana néma du hundi bulésékéréké, Jisasré xiyanjoka. ");
INSERT INTO wos_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Hundi gindaka Jisas Jerusalemémbu rekwa duna makambu wambula yitaka yatakahambandé. Dé déka du wali Jerusalem yatakataka di Efraimré ye di wun getéfambu re. Wun getéfa du rehafi hafwa wali walémbambu dé té. ");
INSERT INTO wos_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Judana némafwi nukwa Pasova walémba maki yandéka di Judana du takwa séfélak Jerusalemré yi, di deka haraki saraki sémbut huréhaléka re wun nukwana hénoo jémba sanjoka. ");
INSERT INTO wos_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Ye xaakwa di Jisaska hwaké. Hwakéfatika tempelmbu téta di di hafu buléta di wa, “Yingi guni saréké? Pasovana hénoo sanjoka yakéndé wana?” Wungi di wa. ");
INSERT INTO wos_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Hanja prisna néma du akwi Farisi akwi angi di wa, “Jisasré hura ye séndé gembu takatame.” Wungi wataka di wa, “Jisas rendéka hafwa du nak xékélakitaka yae naniré watandé.” Wungi di wa. ");
INSERT INTO wos_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Nukwa gwongofu yindét Pasovana nukwa yatandé. Wun nukwa Jisas Betaniré dé yi. Betani Lasarusna getéfa dé. Hanja wumba du hiyandéka Jisas wandéka dé wambula ramé. ");
INSERT INTO wos_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Lasarusna gembu di hénoo humbwi, Jisaska. Marta lé hénoo munita reléka dé Lasarus Jisas wali déka du wali jambémbu di re, hénoo sanjoka. ");
INSERT INTO wos_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Rendaka lé Maria yikafre yama xaakwa hulingu lé hura yae lé Jisasna manmbu blekétaka lé léka makambu téndé séményi némbémbu létéké. Wungi huruléka wun hulinguna yama xae dé wun geré hunamé. ");
INSERT INTO wos_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Jisasna du nak, déka xi Judas Iskariot, dé Jisasré déka mamaka hwetekwa du dé angi wa, ");
INSERT INTO wos_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","“Métaka lé wungi huru? Nani wun hulingu hwetaka némafwi yéwa hali hérakwa. Hérae jambangwe du takwaka hali hwekwa.” ");
INSERT INTO wos_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Wungi wata dé jambangwe du takwaka sarékéhambandé. Dé sélé héraakwa du dé. Dé Jisasna duna yéwaka hatindékandé. Hatita dé déka jondu héranjoka dé wun yéwa hérandékandé. ");
INSERT INTO wos_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Dé wungi wandéka dé Jisas wa, “Léka haraki hundi wakéméni. Hukémbu hiyawut wekwambu rémétendakaka sarékéta lé wungi huru.” ");
INSERT INTO wos_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Wataka dé wa, “Jambangwe du takwa guni wali wungi té retandi. Wuni guni wali wungi té yamba rekéwuni.” Wungi dé wa. ");
INSERT INTO wos_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Jerusalemémbu rekwa séfélak du takwa di xéké, Jisas déka du wali Betanimbu rendaka. Xékétaka di déré xénjoka yi. Jisasré male xénjoka yihambandi. Lasarusré akwi xénjoka di yi. Lasarus hiyandéka Jisas wandéka dé wambula raméndénka di xékélaki. Wungi xékélake di déré xénjoka yi. ");
INSERT INTO wos_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","11","Wun hafwambu rekwa du takwa di hundi xéké Lasaruska. Xékéta séfélak du di Jisaska jémba saréké. Sarékéta di deka néma duna hundika hélék ya. Hélék yandaka di prisna néma du Lasarusré akwi xiyanjoka di hundi gi. ");
INSERT INTO wos_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Séfélak du takwa di Jerusalemré yi, Pasovana hénoo sanjoka. Ye di re. Ganémbambu di xéké Jisas Jerusalemré yanjoka yandéka. ");
INSERT INTO wos_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Wungi xéka di Jisasré xénjoka di yi. Ye di téméngara hura yita di angi wa, Néma Du, naniré mé yikafre huru. God déka ximbu yaakwa duré yikafre hurutandé. Dé nani israelna néma du dé. ");
INSERT INTO wos_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Jisas wayikana donkiré xétaka wun donkina bunungulmbu re dé yi. Jisas wungi huruta du nak Godna nyingambu hanja hayindén maki dé huru. Angi dé hayi: ");
INSERT INTO wos_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","Guni israelna du takwa rookénguni. Mé xé. Guna néma du andé yae. Donki nyanéna bunungulmbu re dé yae. ");
INSERT INTO wos_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Wungi dé hayi. Wungi wandaka Jisasna du wun jooka xékélakihambandi. Hukémbu Jisas Godna getéfaré warindéka di hurundan jooka, hanja hayindén hundika akwi di saréké. Sarékéta di xékélaki. ");
INSERT INTO wos_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Hanja séfélak du takwa di xé, Jisas wandéka Lasarus wambula raméndéka. Xétaka di hundi wa. ");
INSERT INTO wos_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Wandaka séfélak du takwa di wun hambuk jémba yandénka di xéké. Xékétaka di Jisasré xénjoka yi. ");
INSERT INTO wos_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Ye déka ximbu harékéndaka di Farisi hélék ya. Hélék yata di di hafu buléta di wa, “Nana wambeka hundi baka dé yi. Mé xé. Atéfék du takwa Jisaska di némafwimbu mawuli ye.” Wungi di wa. ");
INSERT INTO wos_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Judana du takwa séfélak di Pasovana hénoo sata Godna ximbu harékénjoka di Jerusalemré yi. Nak téfambu yandé du akwi wungi hurunjoka di Jerusalemré yi. Di Grikna du di. ");
INSERT INTO wos_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Wunde du nawulak yae di Jisasna du nak wali bulé. Wun duna xi Filip dé. Filipna motéfa Betsaida dé. Galilimbu dé té. Wunde du di Filipré wa, “Yika du, nani ye Jisasré xénjoka nani mawuli ye.” ");
INSERT INTO wos_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Wungi wandaka dé Filip ye dé Andruré wandéka bér yi, wun jooka Jisasré wanjoka. ");
INSERT INTO wos_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Ye wambéka dé Jisas bérré wa, “God Duna Nyanéna ximbu harékétendéka nukwa andé yae. ");
INSERT INTO wos_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Mwi hundi wuni guniré we. Wit sék nak héfambu xakre hiyahafi re natafa male tétandé. Wit sék héfambu xakre hiyae takélaka wara séfélak wit sék xakétandé. ");
INSERT INTO wos_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Deka séfika male sarékékwa du takwa hiyatandi. Huli mawuli hérae wungi re wungi re jémba yamba rekéndi. Deka séfika sarékéhafi yata wuna jémbaka male sarékékwa du takwa di huli mawuli hérae wungi re wungi re jémba retandi. ");
INSERT INTO wos_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Du takwa wuna jémba yanjoka mawuli yata di wuna hundi xékétandi. Xékéta di wuni retewuka hafwambu retandi. Wuna yafa wuna jémba yakwa du takwana ximbu harékétandé.” Wungi dé Jisas wa. ");
INSERT INTO wos_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","Wun hundi wataka dé wambula wa, “Némbuli wuna mawuli xak dé ye. Hiyatewuka nukwa andé yae. Yingi watawuni, ‘Yafa, némbuli wunimbu xakute yakwa joo mé héreki. Wungi yamba wakéwuni. Ané jooka we wuni andé héfaré gaya.” ");
INSERT INTO wos_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Wungi wataka dé Godré wa, “Wuna yafa, ména xi métaka némafwi yandé.” Wungi wandéka dé Godna getéfambu ané hundi gaya: “Wuni huruwuka wuna xi némafwi wundé yandé. Wambula hurutawuni, wuna xi némafwi yandéte.” ");
INSERT INTO wos_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Wungi wandéka di wumbu rendé du takwa xékétaka nawulak di wa, “Jar dé yae.” Nawulak di wa, “Godna ensel nak dé Jisas wali hundi bulé.” ");
INSERT INTO wos_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Wungi wandaka dé Jisas diré wa, “Godna getéfambu gayandé hundi guniré yikafre hurunjoka dé gaya. Wunika gayahambandé. ");
INSERT INTO wos_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Némbuli God néma du reta ané héfambu rekwa du takwa hurundan sémbutka watandé. Némbuli dé ané héfana néma du satanré hérekitandé. ");
INSERT INTO wos_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Wuniré haréka hatekandat wuni atéfék héfambu rekwa du takwaré wunika hura yatawuni.” ");
INSERT INTO wos_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Wungi wandén déré xiyae mimbu hatekatendakaka dé wa. Di wun jooka xékélakindate dé wungi wa. ");
INSERT INTO wos_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Jisas wungi wandéka di déré wa, “Nani hanja Godna nyingambu hayindan hundi wundé xékwa. God wasékendén du Kraiska ané hundi di hayi: Dé hiyahafi ye wungi re wungi re reséketandé. Hayindan hundi xémbeka métaka méni angi we, ‘Duna Nyanré haréka hatekatandi.’ Wun Duna Nyan héndé?” ");
INSERT INTO wos_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Di wungi wandaka dé Jisas wa, “Yalefu nukwa male hanyikwa ya guni wali tétandé. Téta hanyindét guni déka larékombu yitanguni, gan hunyi yae guniré takatéfindémboka. Halékingambu yikwa du yitendaka yambuka xékélakihambandi. ");
INSERT INTO wos_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Némbuli wun hanyikwa ya guni wali dé re. Rendét guni wun hanyikwa yaka jémba sarékétanguni. Sarékéta guni hanyikwa yana nyambali retanguni.” Wungi dé Jisas sataku hundi wa. Jisas wungi wataka diré yatakataka ye dé faakwa re. ");
INSERT INTO wos_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Dé hanja xéhafi yandan séfélak hambuk jémba yandéka di xé. Xéta déka sarékéhambandi. Sarékéhafi yata God wandéka Jisas gayandénka xékélakihambandi. Di yike di ya. ");
INSERT INTO wos_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Hanja Godna profet Aisaia dé dika angi hayi, Godna nyingambu: “Néma Du, héndé wamben hundi xéké? Méni hambuk jémba yaméka héndé xé?” Hanja Aisaia wungi hayindéka wunde du takwa Jisaska jémba sarékéhafi yandaka déka hundi mwi hundi dé ya. ");
INSERT INTO wos_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","40","Hanja Aisaia ané hundi akwi dé hayi, Godna nyingambu: God deka dama hurundéka di hiya. Hiyandaka wandéka deka mawuli motu maki dé re. Dé wungi huruhafi yandét di deka damambu jémba xétandi. Dé wungi wahafi yandét deka mawuli jémba téndét di déka hundika xékélakitandi. Wungi xe xékélake yawuleka wunika yandat wuni diré huréhalékétawuni. Wungi dé Aisaia Godna hundi hayi. Du takwana mawulika sarékéta dé wungi hayi. Hanja hayindéka hukémbu di wunde du takwa Jisaska sarékéhambandi. ");
INSERT INTO wos_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Aisaia Jisasna hambukré xétaka xéndénka wata dé wun hundi hayi. ");
INSERT INTO wos_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Judana néma du nawulak di Jisaska jémba saréké. Sarékéta di Farisika roota Jisaska jémba sarékéndakaka hundi wahambandi. Wun hundi wandat, Farisi diré hérekindat, di Godna hundi buléndaka geré yamba wulayikéndi. ");
INSERT INTO wos_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Jisaska jémba sarékéndakaka hundi wahafi yata di nawula du deka ximbu harékéndate di mawuli ya. God deka ximbu harékéndéte sarékéhambandi. ");
INSERT INTO wos_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Jisas hambukmbu dé wa, “Guni wunika jémba sarékéta guni wunika male sarékéhambanguni. Guni wunika jémba sarékéta guni wuniré wandéka gayawun duka akwi guni jémba saréké. ");
INSERT INTO wos_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Guni wuniré xéta guni wuniré wandéka yawun duré akwi guni xé. ");
INSERT INTO wos_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Wuni hanyikwa ya maki wuni ané héfaré gaya. Gayawuka guni wunika jémba sarékéta guni halékingambu yamba rekénguni. ");
INSERT INTO wos_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Du nak wuna hundi xékéta wawun maki huruhafi yandét, wuni déré angi yamba wakéwuni, ‘Méni haraki saraki sémbut hurukwa du méni.’ Wungi yamba wakéwuni. Wuni du takwana sémbutka hundi wanjoka ané héfaré gayahambawuni. Wuni atéfék héfambu rekwa du takwa satanéna tambambu héranjoka wuni gaya. ");
INSERT INTO wos_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Du takwa wunika hu hweta wuna hundika xékéhafi yandat, hukémbu hukétéfi nukwambu wawun hundi deka hurundan haraki sémbutka diré watandé, Godna makambu. ");
INSERT INTO wos_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Wuni wuna mawuli sarékémbu hundi wahambawuni. Wuna yafa wunika wandéka yawuka dé watewuka hundi wunika dé wa. Wandéka wuni guniré wun hundi male wuni wa. ");
INSERT INTO wos_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Wata wuni xékélaki. Guni wun hundi jémba xéka huli mawuli hérae jémba retanguni, wungi re wungi re. Wungi xékélakita wuna yafa wuniré wandén maki wuni guniré we.” Wungi dé Jisas wa. ");
INSERT INTO wos_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Pasovana némafwi hénoo hura sa nukwa yandéka dé Jisas xékélaki. Hiyae ané héfa yatakataka déka yafaka yitendéka nukwa andé yae. Xékélakita dé déka du wali reta dika sarékéta dé dika némafwimbu mawuli ya. ");
INSERT INTO wos_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Gérambu Jisas déka du wali hénoo sata rendaka dé satan yae dé Judas Iskariotna mawulimbu dé déré wa, Jisasré déka mamaka hwendéte. Judas dé Saimon Iskariotna nyan dé. ");
INSERT INTO wos_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Jisas dé xékélaki. Déka yafa atéfék du takwa jondu akwi déka tambambu takataka wandéka dé gaya. Gaye déka jémba yataka dé Godka wambula yitandé. ");
INSERT INTO wos_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Wungi xékélakita dé di wali reta hénoo sataka raama téta déka nukwa wur léfwitaka dé gu létékéndaka nukwa wur hérae dé déka yifwambu naki. ");
INSERT INTO wos_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Nakitaka akimbu hulingu nawulak wukae dé deka man yakwanyi. Yakwanyitaka dé nakindén nukwa wurmbu létéké. ");
INSERT INTO wos_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Wungi hura ye dé Saimon Pita rendénmbu xaku. Xakundéka dé Pita déré wa, “Néma Du, métaka yakwanyitaméni, wuna man? Méni wungi huruméte hélék wuni ye.” ");
INSERT INTO wos_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Wungi wandéka dé Jisas wa, “Némbuli huruwuka jooka xékélakihambaméni. Hukémbu wun jooka xékélakitaméni.” ");
INSERT INTO wos_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Wungi wandéka dé Pita wa, “Yingafwe! Wuna man yamba yakwanyikéméni.” Wungi wandéka dé Jisas wa, “Wuni méniré yakwanyihafi yawut, méni wuna hémémbu yamba rekéméni.” ");
INSERT INTO wos_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Wungi wandéka dé Pita angi wa, “Néma Du, méni wuna man, tamba, anéngamba, atéfék yakwanyitaméni.” ");
INSERT INTO wos_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Wungi wandéka dé Jisas wa, “Méni wundé gu yakémé. Ména manmbu male dé harki té. Wuni ména man yakwanyiwut, méni yikafre retaméni. Guni yikafre guni re. Guni atéfékéka wahambawuni.” ");
INSERT INTO wos_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Wungi wata Jisas dé xékélaki, déré mamaka hwetekwa duka. Wungi xékélakita dé diré wa, “Guni atéfék yikafre rehambanguni.” ");
INSERT INTO wos_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Jisas deka man yakwanyitaka dé déka nukwa wur wambula sandataka dé wambula reta dé diré wakwexéké, “Guni huruwun jooka guni xékélaki wana? ");
INSERT INTO wos_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Guni wunika ‘Néma Du’ akwi ‘Wakwekwa du’ akwi guni nae. Wungi yawundu wangwi. Wuni wungi wuni. ");
INSERT INTO wos_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Wuni guna néma du guna wakwekwe du reta guna man wundé yakwanyiwu. Yakwanyiwun maki guni akwi nawulak duna man yakwanyitanguni. ");
INSERT INTO wos_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Guni huruwun maki hurungute wundé wakwewu. ");
INSERT INTO wos_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Mwi hundi wuni guniré we. Jémba yakwa du dé déka néma duré sarékéngwandéhafindé. Wungi maki hundi harikwa du dé hundi hwendé duré sarékéngwandéhafindé. ");
INSERT INTO wos_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Guni wun hundika xékélakita wawun maki huruta guni yikafre mawuli yata jémba retanguni. ");
INSERT INTO wos_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","“Guni atéfékéka wahambawuni. Wuni wuna wasékewun duka wuni xékélaki. Guna du nak wuniré haraki saraki sémbut hurutandé. Wunka wuni xékélaki. Hanja du nak Godna nyingambu wun duka angi dé hayi: “Du nak wuni wali reta hénoo sataka wuniré haraki hurutandé.” Hayindén hundi bari mwi hundi yatandé. ");
INSERT INTO wos_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Guniré andé wawi. Wawuka joo hukémbu yandét guni xe wuni anwarmbu gayawunka jémba sarékétanguni. ");
INSERT INTO wos_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Mwi hundi wuni guniré we. Wawun du ye wuna hundi wandat guni wun hundi jémba xékéta diré yikafre huruta guni wuniré akwi yikafre guni huru. Wuna hundi xékéta wuniré yikafre huruta guni wunika wandéka yawun duré akwi guni yikafre huru.” Wungi dé Jisas wa. ");
INSERT INTO wos_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Jisas wungi wandéka déka mawuli xak yandéka dé wa, “Mé xéké. Guna du nak wuniré mama duka hwetandé.” ");
INSERT INTO wos_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Wungi wandéka di déka du xékélakihambandi. Héndéka dé Jisas we? Xékélakihafi yata di nak nakré xé. ");
INSERT INTO wos_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Jisas déka du nakéka némafwimbu mawuli yandéka dé wun du dé wali walémbambu re. ");
INSERT INTO wos_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Rendéka dé Saimon Pita humbu yakénakéta dé déré wa, “Méni Jisasré mé wakwexéké. Héndéka dé wa?” ");
INSERT INTO wos_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Wungi wandéka dé Jisas wali sata reta dé déré wakwexéké, “Néma Du, héndéka méni we?” ");
INSERT INTO wos_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Wungi wakwexékéndéka dé Jisas wa, “Bret gumbu tondéréka hwetewuka du dé wun du dé.” Wungi wataka nawulak bret hérae dé gumbu tondéréka dé Saimon Iskariotna nyan Judaska hwe. ");
INSERT INTO wos_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Hwendéka Judas hérandéka dé satan déka mawuliré wulayi. Wulayindéka dé Jisas Judasré wa, “Hurunjoka sarékémén joo bari mé huru.” ");
INSERT INTO wos_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Wungi wandéka di hénoo sata rendé du wun jooka xékélakihambandi. ");
INSERT INTO wos_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Xékélakihafi yata nawulak di deka mawulimbu wa, “Judas dé nana yéwaka hatindéka dé Jisas déré wa, hénoo nawulak hérandéte.” Nawulak di wa, “Judas nana yéwaka hatindéka dé Jisas déré wa, jambangwe du takwaka nawulak hwendéte.” Wungi wata xékélakihambandi, Jisas Judasré wandén hundika. ");
INSERT INTO wos_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Judas Jisas hwendén hénoo hérae sataka dé diré yatakataka dé bari gwandi. Gan hunyindéka dé gwandi. ");
INSERT INTO wos_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Judas raama gwandindéka dé Jisas diré wa, “Némbuli guni Duna Nyanéna hambukré xe déka ximbu harékétanguni. Wungi harékéta wuna yafa God néma du rendékaka xékélake déka ximbu akwi harékétanguni. ");
INSERT INTO wos_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Wuna hambukré xe Godka xékélakingut God bari wandét wuni dé wali néma du retawuni. ");
INSERT INTO wos_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Guni wuna nyangwal guni. Gunika wuni némafwimbu mawuli ye. Wuni guni wali yamba rekéwuni. Wuni bari guniré yatakataka yiwut guni wunika hwakétanguni. Hanja wuni Judana néma duré angi wuni wa, ‘Wuni yitewuka hafwaré guni yamba yikénguni.’ Wungi wawun hundi male wuni guniré we. ");
INSERT INTO wos_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Némbuli guniré huli hambuk hundi watawuni. Guni nak nakéka némafwimbu mawuli yatanguni. Wuni gunika némafwimbu mawuli yawuka maki, guni nak nakéka némafwimbu mawuli yatanguni. ");
INSERT INTO wos_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Guni nak nakéka wungi némafwimbu mawuli yangut, atéfék du xe di guni wuna du rengukaka xékélakitandi. ");
INSERT INTO wos_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Jisas wungi wandéka dé Saimon Pita wa, “Néma Du, nak hafwaré yinjoka méni we. Yingiré yitaméni?” Wungi wakwexékéndéka dé Jisas wa, “Wuni yitewuka hafwaré yamba yikéméni. Hukémbu wuni yitewuka hafwaré yitaméni.” ");
INSERT INTO wos_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Wungi wandéka dé Pita wa, “Néma Du, métaka we méni wali yamba yikéwuni? Wuni méni wali hiyanjoka mawuli wuni ye.” ");
INSERT INTO wos_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Wungi wandéka dé Jisas wa, “Méni wuniré yikafre hurunjoka hiyataméni, o yingafwe? Wu yingafwe. Mwi hundi wuni méniré we. Némbuli gan méni yambu hufuk angi wataméni, ‘Wuni Jisaska xékélakihambawuni.’ Wungi wamét hukémbu séra watandé.” Wungi dé Jisas wa. ");
INSERT INTO wos_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Jisas déka duré dé angi wa, “Guna mawuli xak yakéndé. Guni Godka jémba sarékéta wunika akwi jémba sarékétanguni. ");
INSERT INTO wos_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Hanja guniré wuni wa, ‘Wuni ye retenguka hafwa huréhalékétawuni.’ Wungi wata guniré mwi hundi wuni wa. Wuna yafa rendéka gembu séfélak hafwa dé re. ");
INSERT INTO wos_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Guni retenguka hafwa wumbu dé re. Wuni ye guna hafwa huréhalékétawuni. Huréhalékétaka wuni wambula yae guniré hérawut wuni wali ye wuni wali retanguni. ");
INSERT INTO wos_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Wuni yitewuka yambuka wundé xékélakingu.” ");
INSERT INTO wos_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Wungi wandéka dé Tomas Jisasré wa, “Néma Du, méni yiteméka getéfaka xékélakihambame. Wun getéfaré yiteméka yambuka akwi xékélakihambame.” ");
INSERT INTO wos_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Wungi wandéka dé Jisas wa, “Wuni hafu wun yambu wuni. Wuni hafu mwi hundina mo wuni. Wuni huli mawuli hwekwa du wuni. Du nak nak yambambu yamba yikéndé, wuna yafaka. Yingafwe. Wunimbu yae yitandé. ");
INSERT INTO wos_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Guni wunika xékélake wu wuna yafaka akwi xékélakitanguni. Némbuli déka andé xékélakingwi. Xékélakita déré andé xéngwi.” ");
INSERT INTO wos_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Jisas wungi wandéka dé Filip wa, “Néma Du, naniré yafa mé wakwemét xe bu xékélakikwa. Wungi wakwemét, wu sékérékétandé.” ");
INSERT INTO wos_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Wungi wandéka dé Jisas Filipré angi wa, “Séfélak nukwa wuni guni wali wuni re. Métaka méni wunika xékélakihafi ye? Wuniré xéndé du dé wuna yafaré akwi dé xé. Métaka méni angi wa? ‘Ména yafa mé wakwemét xékwa.’ Wungi wakéméni. Méni déré wundé xémé. ");
INSERT INTO wos_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Wuni wuna yafambu téwuka dé wuna yafa wunimbu dé té. Wun hundika méni xékélaki, o yingafwe? Guniré wawun atéfék hundi wuna mawuli sarékémbu wahambawuni. Yafa wuna mawulimbu téta déka jémba yandéka wuni wun hundi wa. ");
INSERT INTO wos_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Guni wawun hundika jémba sarékéta guna mawulimbu angi watanguni, ‘Jisas déka yafambu téndéka déka yafa démbu dé té. Wu mwi hundi dé.’ Wungi watanguni. Wungi wahafi yata guni yawuka xéngun hambuk jémbaka sarékéta wunika jémba sarékétanguni. ");
INSERT INTO wos_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","“Ané hundi mé xéké. Guni wuna hundi jémba xékékwa du guni akwi wuni yawuka hambuk jémba yatanguni. Wuni wuna yafaka yiwut, guna jémba wuna jémbaré sarékéngwandétandé. ");
INSERT INTO wos_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Guni wunika jémba sarékéta wuna ximbu wuna yafaka wakwexékéngut, wuni wakwexékéngun maki hurutawuni. Wungi huruwut atéfék du takwa xe wuna yafana ximbu harékétandi. ");
INSERT INTO wos_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Guni wuna ximbu wunika wakwexékéngut, wuni wakwexékéngun maki hurutawuni.” Wungi dé wa. ");
INSERT INTO wos_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","Jisas dé wa, “Guni wunika némafwimbu mawuli yata guni wuna hundi jémba xékéta wawuka maki hurutanguni. ");
INSERT INTO wos_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Hurungut wuni wuna yafaré wakwexékéwut nak du yae wuna hafwa hératandé. Dé gaye guniré yikafre huruta guni wali wungi re wungi re retandé. ");
INSERT INTO wos_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Wungi wata wuni Godna Hamwinyaka wuni we. Dé mwi hundi male dé wa. Wuna hundika xékékwa du takwa male déka xékélake déré hératandi, deka mawulimbu. Ané héfana du takwa déré xéta déka xékélakihambandi. Xékélakihafi yata di déré yamba hérakéndi. Dé guni wali re guna mawulimbu téndét guni déka xékélakitanguni. ");
INSERT INTO wos_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","“Wuni guniré yatakawut guni yafa ayiwa hiyae yatakandan nyangwal maki yamba rekénguni. Wuni gunika wambula yatawuni. ");
INSERT INTO wos_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Tale yalefu nukwa yindét ané héfana du takwa wuniré yamba xékéndi. Guni hafu wuniré xétanguni. Wuni huli téwukangala maki, guni akwi huli tétanguni, wungi té wungi té. ");
INSERT INTO wos_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Wun nukwambu guni angi xékélakitanguni. Wuni wuna yafambu téwuka guni wunimbu ténguka wuni gunimbu wuni té. ");
INSERT INTO wos_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Wuna hundi xékéta wawuka maki hurukwa du takwa di wunika némafwimbu mawuli ye. Di wunika némafwimbu mawuli yandat, wuna yafa God dika némafwimbu mawuli yatandé. Wuni akwi wunde du takwaka némafwimbu mawuli yatawuni. Mawuli yata wuni hafuka diré wakwetawuni.” ");
INSERT INTO wos_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Jisas wungi wandéka dé nakémba Judas déré wa. (Dé Judas Iskariot yingafwe.) Dé angi wa, “Néma Du, métaka we méni naniré male wakwetaméni, ané héfana du takwaré wakwehafi yata?” ");
INSERT INTO wos_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Wungi wandéka dé Jisas déré wa, “Wunika némafwimbu mawuli yakwa du takwa di wawun maki hurutandi. Wungi hurutekwa du takwaka wuna yafa némafwimbu mawuli yatandé. Mawuli yandét ani wuna yafa wali ye wunde du takwana mawulimbu wulaaye tétaani. ");
INSERT INTO wos_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Wunika némafwimbu mawuli yahafi yakwa du takwa di wuna hundi xékéhambandi. Wawun hundi wuna hundi yingafwe. Wuna yafa wandéka xékéta wuni guniré we. ");
INSERT INTO wos_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","“Némbuli guni wali reta wuni ané hundi we. ");
INSERT INTO wos_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Hukémbu guniré yikafre hurutekwa du Godna Hamwinya dé wuna ximbu gunika yatandé. Wuna yafa wandét dé yae wuna hafwa hérae dé atéfék jonduka guniré wakwetandé. Yae wakwendét, guni wawun atéfék hundika wambula sarékétanguni. ");
INSERT INTO wos_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","“Wuni guniré yatakataka yita nakélak huru mawuli gunika hwetawuni. Wuna nakélak huru mawuli gunika hwetawuni. Ané héfana duna mawuli maki hwehambawuni. Hwewut guna mawuli xak yahafi yandét yamba rookénguni. ");
INSERT INTO wos_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Guniré angi wuni wa, ‘Wuni guniré yatakataka ye wambula yatawuni.’ Wuni wungi wawuka guni wun hundi wundé xékéngu. Xékéta wunika némafwimbu mawuli yata guni yikafre mawuli yatanguni, wuna yafaka yitewukaka. Wuna yafa néma du reta dé wuniré sarékéngwandé. Sarékéngwandéndéka wuni yi, déré xénjoka. ");
INSERT INTO wos_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Némbuli guniré wundé wawu, wuni yitewukaka. Hukémbu wuni yiwut, guni angi watanguni. ‘Tale Jisas yitendékaka wandéka wundé xékélakikwa. Dé God wali dé re. Wu mwi hundi dé.’ Wungi wangute wuni wun hundi we. ");
INSERT INTO wos_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","“Gunika séfélak hundi yamba wakéwuni. Ané héfana néma du satan andé yae. Yae déka hambuk wuna hambukré yamba sarékéngwandékéndé. ");
INSERT INTO wos_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Sarékéngwandéhafi yandét, ané héfambu rekwa du takwa xékélakitandi, wuna yafaka némafwimbu mawuli yawukaka. Di wungi xékélakindate wuni mawuli ye. Mawuli yata wuna yafa wuniré wandén jémba wuni ye. Yak. Sé raama yikwa.” Wungi dé Jisas wa. ");
INSERT INTO wos_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Jisas dé angi wa, “Wuni yikafre male wain bangwi wuni. Wuna yafa God dé wun bangwika hatikwa du dé. ");
INSERT INTO wos_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Séfélak gali dé fuka, wun bangwimbu. Bangwina gali nawulak sék xakéhafi yandat, wuna yafa wun galiré xatéka yakitandé. Bangwina gali nawulak sék xakéndat, dé wun galina saalé male sénatandé, di séfélak sék xakéndate. ");
INSERT INTO wos_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Wuni gunika wawuka guni wawun hundi xékénguka guna mawuli yikafre dé té. ");
INSERT INTO wos_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Guni wunimbu téngut wuni gunimbu tétawuni. Wungi wuni mawuli ye. Bangwina gali ye bangwi wali téhafi yata sék nawulak yamba xakékéndé. Wungi maki guni wuni wali téhafi ye hénoo yamba xakékénguni. ");
INSERT INTO wos_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","“Wuni hafu wun wain bangwi wuni. Guni wun bangwina gali guni. Du nak wunimbu téndét wuni démbu téwut dé séfélak hénoo xakétandé. Dé wuniré yatakataka ye hafu te yikafre jémba yamba yakéndé. ");
INSERT INTO wos_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Du nawulak galiré xatékéndat, wun gali réka yatandé. Hukémbu wun gali natafambu takataka di yambu tutandi. Wun gali maki, du nak wuniré yatakataka ye hafu téndét, déré héreke yambu tutandi. ");
INSERT INTO wos_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Guni wunimbu téngut, wuna hundi guna mawulimbu téndét, Godré wakwexékéngut dé mawuli yanguka jondu atéfék hwetandé. ");
INSERT INTO wos_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Guni séfélak yikafre jémba yangut séfélak du takwa xéta watandi, ‘Jisasna jémba di ya. Déka du di. Wu mwi hundi dé.’ Wungi wata wuna yafana ximbu harékétandi. ");
INSERT INTO wos_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","“Wuna yafa wunika némafwimbu mawuli yandéka maki wuni gunika némafwimbu mawuli wuni ye. Guni wuna mawuli yawukambu mé wulaaye té. ");
INSERT INTO wos_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Wuni wuna yafana hundi xékéta wandén maki huruta wuni déka mawuli yandékambu wuni té. Téwuka maki guni wuna hundi xékéta wawun maki huruta guni wuna mawuli yawukambu wulaaye tétanguni. ");
INSERT INTO wos_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","Guni yikafre mawuli yata mawuli sawuli yangute wuni guniré wun hundi we. Wuna yikafre mawuli guna mawulimbu sukwekéndéte wuni wungi we. ");
INSERT INTO wos_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","“Wuna hambuk hundi angi dé. Wuni gunika némafwimbu mawuli yawuka maki, guni akwi nak nakéka némafwimbu mawuli yatanguni. ");
INSERT INTO wos_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Du nak déka nyayikaré yikafre hurunjoka hiyandét, nani xékélaki, dé déka nyayikaka dé némafwimbu mawuli ye. Déka mawuli ya atéfékna mawuli yaré dé sarékéngwandé. ");
INSERT INTO wos_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Guni wuna hundi xéka wawun maki huruta guni wuna nyayikangu guni. ");
INSERT INTO wos_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Némbuli wuni gunika wambula angi yamba wakéwuni: Guni wuna jémba yakwa du guni. Wungi yamba wakéwuni. Jémba yakwa du di deka néma duna mawulika xékélakihambandi. Wuna yafa wandén atéfék hundi xékétaka wuni guniré we. Wawuka guni wuna mawulika guni xékélaki. Xékélakinguka wuni we: Guni wuna nyayikangu guni. Wungi wuni guniré we. ");
INSERT INTO wos_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","“Guni wuniré wasékehambanguni. Wuni guniré wuni waséke, guni ye séfélak hénoo xakéngute. Xakéngut, guna hénoo wungi té wungi té tétandé. Téndét guni wuna yafaka wuna ximbu wangut, dé wangun joo hwetandé, gunika. ");
INSERT INTO wos_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Ané hambuk hundi wuni guniré we. Guni nak nakéka némafwimbu mawuli yatanguni.” ");
INSERT INTO wos_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","“Ané héfambu rekwa du takwa gunika hélék yandat, wu baka joo dé. Tale wunika wungi di hélék ya. Wungi guni xékélaki. Wunika hélék yata hukémbu gunika akwi hélék yatandi. ");
INSERT INTO wos_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Guni ané héfana du takwa rengut, ané héfana du takwa gunika mawuli yatandi. Wuni guniré wundé wasékewu, guni ané héfa yatakangute. Guni ané héfana du takwa rehafi yanguka di ané héfana du takwa gunika hélék ye. ");
INSERT INTO wos_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Guni hanja wawunka guni xékélaki? ‘Jémba yakwa du déka néma duré sarékéngwandéhafindé.’ Wawun makika jémba sarékétanguni. Di wuniré haraki hurundanéngala, guniré akwi haraki hurutandi. Di wuna hundi xékétaka wu guna hundi akwi xékétandi. ");
INSERT INTO wos_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Di wunika wandéka yawun Godka xékélakihambandi. Xékélakihafi ye di wunika hélék ye guniré haraki hurutandi, guni wuna du rengukaka. ");
INSERT INTO wos_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","“Wuni yae diré hundi wahafi yawut, di deka haraki saraki sémbutka yamba xékélakikéndi. Wuni yae diré hundi wawuka hurundan haraki saraki sémbutka di xékélaki. Xékélakita angi yamba wakéndi, ‘Nani xékélakihafi ye me haraki saraki sémbut huru.’ Wungi yamba wakéndi. ");
INSERT INTO wos_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Wunika hélék yakwa du takwa di wuna yafaka akwi di hélék ye. ");
INSERT INTO wos_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Hanja du nawulak yae yawun maki jémba yahambandi. Wuni deka nyéndékmbu téta séfélak hanja xéhafi yandan hambuk jémba wuni ya. Wuni wun jémba yahafi yawut, di ané héfambu rekwa du takwa deka haraki saraki sémbutka yamba xékélakikéndi. Wuni wun jémba yawuka di xé. Xétaka deka haraki saraki sémbutka xékélakita di wuna yafa wali anika di hélék ye. ");
INSERT INTO wos_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Wuni haraki saraki sémbut nawulak huruhafi yawuka di wunika baka hélék yandaka Godna nyingambu rekwa hundi nak némbuli mwi hundi dé ya. Hanja du nak angi dé hayi, “Wunika baka nyéndé di hélék ye.” ");
INSERT INTO wos_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","“Hukémbu wawut guniré yikafre hurutekwa du gunika yatandé. Némbuli dé wuna yafa wali dé re. Wuni wuna yafaré wawut, dé wandét yatandé. Wun du Godna Hamwinya dé. Mwi hundi male wata wunika du takwaré wakwetandé. ");
INSERT INTO wos_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Guni akwi wunika diré watanguni. Hanja akwi némbuli akwi guni wuni wali reta wuna jémbaré wundé xéngu. Xéngunka guni diré akwi wakwetanguni.” ");
INSERT INTO wos_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","“Némbuli guni wunika jémba saréké. Guni wuna hundi yatakahafi yangute wuni wun hundi guniré we. ");
INSERT INTO wos_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Hukémbu néma du nawulak watandi, guni Godna hundi buléndaka ge yatakataka wun geré wambula wulayihafi yangute. Yatakangut du nawulak watandi, ‘Di haraki saraki sémbut hurukwa du di. Nani diré xiyaata nani Godna jémba me ye.’ Wungi wata di guniré xiyatandi. ");
INSERT INTO wos_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Wunde du wuna yafa wali anika xékélakihambandi. Xékélakihafi yata di guniré haraki hurutandi. ");
INSERT INTO wos_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Némbuli guniré wuni we, wun jooka. Hukémbu di guniré haraki hurundat guni watanguni, ‘Hanja Jisas dé naniré hundi wa, di naniré haraki hurutendakaka. Wandén maki némbuli wungi di huru.’ Wungi wata wuna hundika sarékétanguni.” Wungi dé Jisas wa. Wun hundi wataka dé wa, “Hanja guni wali téta wuni guniré wun hundi wahambawuni. ");
INSERT INTO wos_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Némbuli guniré yatakanjoka huruta wuni guniré wun hundi we. Nawulak nukwa yindét wunika wandéka gayawun duka wambula yitawuni. Yitewukaka guna be nak wunika wakwexékéhambandé, ‘Méni yingiré yitaméni?’ Wungi wakwexékéhambandé. ");
INSERT INTO wos_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Ané wawuka hundi xékénguka guna mawuli xak dé ye. ");
INSERT INTO wos_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","“Némbuli mwi hundi wuni guniré we. Wuni yiwut, wu yikafre dé. Wuni yihafi yawut, guna mawuliré yikafre hurutekwa du yamba yakéndé. Wuni ye wawut, wun du yatandé. ");
INSERT INTO wos_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Wun du yae dé ané héfambu rekwa du takwaré watandé, deka hurundan haraki saraki sémbutka akwi, yikafre sémbutka akwi, God haraki sémbut hasa hwetendékaka akwi. ");
INSERT INTO wos_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Dé haraki saraki sémbutka angi watandé, ‘Guni Jisaska jémba sarékéhafi yata guni haraki saraki sémbut guni huru.’ ");
INSERT INTO wos_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Wungi wataka dé wuna yikafre sémbutka angi watandé, ‘Jisas yikafre sémbut male hurutaka dé déka yafaka wambula yindéka guni déré xéhambanguni. Jisas déka yafa wali rendéka guni xékélaki, dé yikafre male sémbut hurukwa du dé.’ ");
INSERT INTO wos_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Dé God haraki sémbut hasa hwetendékaka angi watandé, ‘God néma du reta satan hurundén sémbutka déré hasa hwetendékaka wundé wandé. Wandénka dé guna sémbutka akwi watandé.’ Guna mawuliré yikafre hurutekwa du wungi watandé.” ");
INSERT INTO wos_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","“Wuni séfélak hundi akwi guniré wanjoka wuni mawuli ye. Mawuli yawuka guni wuna hundika yamba hali xékékéngu. ");
INSERT INTO wos_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Hukémbu Godna Hamwinya gunika yatandé. Dé mwi hundi male watandé. Yae mwi hundi wata guna mawuliré yikafre hurundét guni atéfék mwi hundika xékélakitanguni. Déka mawuli sarékémbu yamba wakéndé. Wuni ye wawut dé yae wawun hundi guniré watandé. Dé hukémbu xakutekwa jonduka guniré watandé. ");
INSERT INTO wos_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Dé wuna jondu hérae wun jonduka guniré wakweta dé wuna ximbu harékétandé. ");
INSERT INTO wos_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Wuna yafana atéfék jondu wuna dé. Wungi xékélakita wuni guniré we, ‘Godna Hamwinya wuna jondu hérae wun jonduka guniré wakwetandé.’” Wungi dé Jisas wa. ");
INSERT INTO wos_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","Wun hundi wataka dé Jisas angi wa, “Nawulak nukwa yindét guni wuniré yamba xékénguni. Hukémbu nawulak nukwa yindét wuniré wambula xétanguni.” ");
INSERT INTO wos_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Wungi wandéka déka du nawulak di hafu angi bulé, “Jisas wandéka hundina mo hundi yingi dé? Angi dé wa, ‘Nawulak nukwa yindét guni wuniré yamba xékénguni. Hukémbu nawulak nukwa yindét wuniré wambula xétanguni.’ Wungi wataka nak hundi akwi dé wa, ‘Wuni wuna yafaka yitawuni.’” ");
INSERT INTO wos_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Di wungi wataka di angi wa, “Métaka dé nawulak nukwaka dé wa? Nani déka hundina mo hundika yike me ye.” Wungi di wa. ");
INSERT INTO wos_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Jisasré wun hundika wakwexékénjoka mawuli yandaka dé Jisas deka mawuli xékélakita dé diré wa, “Guniré wuni we, ‘Nawulak nukwa yindét guni wuniré yamba xékénguni. Hukémbu nawulak nukwa yindét wuniré wambula xétanguni.’ Wungi wawuka guni wuna hundika xékélakihafi yata, wun hundika guni guna hafu hundi bulé, o yingi maki dé? ");
INSERT INTO wos_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Mwi hundi wuni guniré we. Wuni guniré yatakataka yiwut guni haraki mawuli xékéta gératanguni. Gérangut di ané héfambu rekwa du takwa mawuli sawuli yatandi. Tale guna mawuli xak yatandé. Hukémbu guna mawuli xak yawuleka yikafre mawuli xakutandé. ");
INSERT INTO wos_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Takwa nyan héranjoka tale hangéli lé héra. Héraata mawuli sawuli yahambalé. Yahafi ye lé wun nyan hérataka wun hangélika wambula sarékéhambalé. Héralén nyanré xéta mawuli sawuli lé ya. ");
INSERT INTO wos_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Guna mawuli wule takwana mawuli maki dé. Némbuli guna mawuli xak yandéka guni mawuli sawuli yahambanguni. Hukémbu wuni guniré wambula xéwut, guni yikafre mawuli yata mawuli sawuli yatanguni. Wambula raméwunka mawuli yangut di guna yikafre mawuliré haraki yamba hurukéndi. ");
INSERT INTO wos_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","“Guni yikafre mawuli yata wun nukwa wunika yamba wakwexékékénguni. Mwi hundi wuni guniré we. Guni wuna yafaka wuna ximbu wakwexékéngut dé xékétaka mawuli yanguka jondu hwetandé. ");
INSERT INTO wos_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Hanja Godka wuna ximbu wakwexékéhambanguni. Némbuli wakwexékétanguni. Wakwexékéngut dé mawuli yanguka jondu hwendét guni yikafre mawuli yata némafwimbu mawuli sawuli yatanguni.” ");
INSERT INTO wos_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","Jisas wungi wataka dé wa, “Wuni sataku hundimbu male wuni guniré we. Hukémbu sataku hundi wambula yamba wakéwuni. Wahafi yata guniré wafuke watawuni, wuna yafaka. ");
INSERT INTO wos_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Wungi watewuka nukwambu guni wuna ximbu wuna yafaka wakwexékétanguni, guniré yikafre hurundéte. Wungi wata wuni angi wahambawuni, ‘Wuni déré wakwexékétawuni, dé guniré yikafre hurundéte.’ Yingafwe. Guni hafu déré wakwexékétanguni, ");
INSERT INTO wos_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","dé gunika némafwimbu mawuli yandékaka. Guni wuniré xéta guni wa, ‘Jisas God wali re dé gaya. Wu mwi hundi dé.’ Wungi wata guni wunika némafwimbu mawuli guni ye. Wungi mawuli yanguka wuna yafa gunika dé némafwimbu mawuli ye. ");
INSERT INTO wos_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Hanja wuni wuna yafa wali re wuni ané héfaré gaya. Gaye re ané héfa yatakataka wuna yafaka wambula yitawuni.” ");
INSERT INTO wos_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Dé wungi wandéka di déka du wa, “Méni sataku hundi wahafi yaméka némbuli nani ména hundi xékéta nani xékélaki. ");
INSERT INTO wos_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Méni atéfék jonduka méni xékélaki. Xékélake du takwana hundika akwi xékélakiméka di huli hundi nak méniré yamba wakwexékékéndi. Wungi xékélakita nani ménika jémba saréké. Méni God wali re méni gaya. Wu mwi hundi dé.” Wungi di wa. ");
INSERT INTO wos_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Wungi wandaka dé wa, “Némbuli male wunika guni jémba saréké wana? ");
INSERT INTO wos_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Mé xéké. Naniré haraki hurutendaka nukwa andé yae. Yandét guni nak nak yaange yitanguni, guna geré. Guni wuniré yatakataka yaange yingut, wuni hafu tétawuni. Wuni hafu téhambwe, wuna yafa wuni wali dé té. ");
INSERT INTO wos_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Wun hundi wuni guniré we, guni nakélak huru mawuli yangute. Ané héfambu rekwa du takwa guniré haraki hurutandi. Haraki hurutendakaka sarékéta guni rookénguni. Wuni néma du rewuka wuna hambuk deka hambukré dé sarékéngwandé. Sarékéngwandéndéka guni yikafre mawuli yatanguni.” Wungi dé Jisas wa. ");
INSERT INTO wos_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Jisas wungi wataka Godna getéfaré yasawara xéta dé angi wa, “Yafa, wuni hiyatewuka nukwa andé yae. Némbuli ména nyanka hambuk mé hwemét, du takwa xe bu déka ximbu harékénda. Di ména nyanré xe ména hambukéka akwi xékélakita di ména ximbu harékéte. ");
INSERT INTO wos_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Tale méni ména nyanré waméka dé ané héfambu rekwa du takwaka néma du re. Reta wunika hwemén atéfék du takwaka huli mawuli hwewut, di jémba retandi, wungi re wungi re. ");
INSERT INTO wos_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Di huli mawuli hérae angi xékélakitandi. Méni hafu méni néma du God méni. Méni waméka dé Jisas Krais ya. Wungi xékélakita jémba retandi, wungi re wungi re. ");
INSERT INTO wos_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Ané héfambu yawute wamén jémba wundé yawu. Yata wuni ména ximbu haréké. ");
INSERT INTO wos_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Hanja ané héfa baka téndéka wuni méni wali reta nukwa hanyikwa maki wuni re. Ménika wambula yiwut wamét wuni nukwa hanyikwa maki wambula retawuni.” ");
INSERT INTO wos_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","Jisas wungi wataka dé wa, “Hwemén duré ména xika wundé wakwewu. Wakwewuka di ménika xékélaki. Hanja di ané héfambu rendaka méni diré wunika méni hwe. Tale di ména du rendaka diré wunika hweméka di ména hundi jémba xéké. ");
INSERT INTO wos_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Némbuli di xékélaki, wuna jondu atéfék méni hwemén dé. ");
INSERT INTO wos_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Hwemén hundi wuni diré wuni hwe. Hwewuka di wun hundika jémba xéka xékélakita di wa, ‘Hanja Jisas God wali dé re. Rendéka God wandéka dé Jisas ané héfaré gaya. Wu mwi hundi dé.’ Wungi watandi. ");
INSERT INTO wos_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","“Némbuli méniré wuni wakwexéké, wunde duka. Ané héfana du takwaka wahambawuni. Méni wunika hwemén du takwaré yikafre huruméte wuni méniré wakwexéké. ");
INSERT INTO wos_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Ména du takwa wuna du takwa di. Wuna du takwa ména du takwa di. Di wuna hundi xékétaka wuna jémba yandaka nawula du takwa xéta di wuna ximbu haréké. ");
INSERT INTO wos_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Némbuli wuni ané héfambu yamba resékekéwuni. Rehafi yawut di ané héfambu retandi. Wuni ménika wambula yitawuni. Wuna yafa, méni yikafre du méni. Méniré wuni wakwexéké, wunde duka. Ména hambuk wundé hwemé, wunika. Némbuli méni hambuk yata dika jémba hatitaméni. Hatimét di ani natafa mawuli héranaka maki natafa mawuli hérae jémba retandi. Wungika wuni mawuli ye. ");
INSERT INTO wos_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Méni hambuk hweméka wuni di wali reta wuni dika jémba hati. Jémba hatiwuka nawulak du diré haraki huruhambandi. Di jémba di re. Natafa du male fakutandé. Fakundét Godna nyingambu wun duka hayindan hundi mwi hundi yatandé. ");
INSERT INTO wos_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","“Némbuli ménika yatawuni. Wuni ané héfambu reta wun hundi wuni we, wuna du roohafi yata wuna mawuli hérae yikafre mawuli yandate. ");
INSERT INTO wos_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Ména hundi dika wawuka di xéké. Di ané héfana du yingafwe. Wuni akwi ané héfana du yingafwe. Nani wungi rembeka ané héfana du takwa di nanika hélék ye. ");
INSERT INTO wos_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Wuni diré ané héfambu hérae ména getéfaré hura yaméte, wahambawuni. Méni diré satanéna tambambu rendamboka hatiméte wuni we. ");
INSERT INTO wos_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Di ané héfana du yingafwe. Wungi maki wuni ané héfana du yingafwe. ");
INSERT INTO wos_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Ména hundi mwi hundi dé. Méni wamét wuna du ména mwi hundi male xékéta ména du retandi. ");
INSERT INTO wos_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Hanja méni waméka wuni ané héfambu rekwa du takwaka gaya. Wunika wamén maki wuni dika wa, di ané héfana du takwaka ye wuna hundi wandate. ");
INSERT INTO wos_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Wuni ména hundi xékéta ména jémba male wuni ya. Wuna du xéta ména hundi xékéta ména jémba male yandate wuni wungi ya. ");
INSERT INTO wos_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","“Wuna yafa, wunde duka male ménika wakwexékéhambawuni. Wun du yita wuna hundi watandi, nawulak du takwaka. Watendaka hundi xékétaka wunika jémba sarékétekwa du takwaka akwi méniré wuni wakwexéké. ");
INSERT INTO wos_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Di atéfék natafa mawuli hératandi. Wungi wuni mawuli ye. Yafa, méni wunimbu téméka wuni ménimbu téwuka maki, di animbu tétandi. Wungi téndat, ané héfana du takwa xe watandi, ‘God wandéka dé Jisas gaya. Wu mwi hundi dé.’ Wungi watandi. ");
INSERT INTO wos_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Hanja méni wunika hambuk hwe, wuni jémba yawut nawulak du takwa wuna ximbu harékéndate. Hwemén maki wuni dika hambuk hwe. Di ani natafa mawuli héranaka maki natafa mawuli hérandate, wuni wun hambuk hwe. ");
INSERT INTO wos_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Wuni dimbu téwuka méni wunimbu té. Wungi téta nani atéfék natafambu té. Témbet, ané héfana du takwa diré xéta xékélakita watandi, ‘God wandéka dé Jisas ané héfaré gaya. God Jisaska némafwimbu mawuli yandéka maki, Jisasna du takwaka akwi dé némafwimbu mawuli ye.’ Wungi watandi. ");
INSERT INTO wos_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","“Wuna yafa, wuni hwemén duka wuni méniré wakwexéké. Di wuni wali ména getéfambu sékéré rendate wuni mawuli ye. Hanja ané héfa baka téndéka méni wunika némafwimbu mawuli yata waméka wuni nukwa hanyikwa maki reta wuni ména getéfambu re. Nukwa hanyikwa maki wambula rewut di ména getéfaré yae xéndate wuni mawuli ye. ");
INSERT INTO wos_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Wuna yafa, yikafre jémba male méni ya. Ané héfana du takwa ménika xékélakihambandi. Wuni ménika xékélakiwuka di wuna du akwi ménika di xékélaki. Méni waméka wuni gaya. Wungi di xékélaki. ");
INSERT INTO wos_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Wuni diré ména xika wundé wakwewu. Wakwewuka di ménika xékélaki. Wambula wawut xékélakitandi. Wuni wawut méni wunika némafwimbu mawuli yaméka maki, di deka du nak nakéka némafwimbu mawuli yatandi. Mawuli yandat wuni deka mawulimbu tétawuni.” Wungi dé Jisas Godré wakwexéké. ");
INSERT INTO wos_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Jisas wun hundi wataka déka du wali di Kidron huté angé sakuré yi. Yikafre mi sendan yawi nak wumbu téndéka di Jisas déka du wali wun yawiré wulayi. ");
INSERT INTO wos_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Wun nukwa Jisasré mama duka hwetekwa du Judas di wali yahambandé. Tale séfélak nukwambu Jisas déka du wali di wun yawimbu wulaaye wumbu re. Hanja Judas Jisas wali yitaka yatakata dé wun yawika xékélaki. ");
INSERT INTO wos_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Wungi xékélakitaka dé Romna xi warekwa du nawulak akwi, gélindu du nawulak akwi wungi hura yae di wun hafwaré ya. Prisna néma du akwi, Farisi akwi di wun gélindu duré wandaka di ya. Xi ware jondu akwi, téméngara akwi, hanyikwa ya akwi di hura ya. ");
INSERT INTO wos_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Hura yandaka dé Jisas xékélaki, déré hurutendaka atéfék jonduka. Xékélake ye dé diré wa, “Héndéka guni hwaké?” ");
INSERT INTO wos_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","6","Wungi wakwexékéndéka di wa, “Nasaretna du Jisaska nani hwaké.” Wungi wandaka dé Jisasré mama duka hwekwa du Judas dé di wali té. Téndéka wandaka dé Jisas wa, “Wuni andu.” Wungi wandéka roo hu hu ye di héfambu xakri. ");
INSERT INTO wos_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Xakrindaka dé diré wambula wakwexéké, “Héndéka guni hwaké?” Wungi wakwexékéndéka di wa, “Nasaretna du Jisaska nani hwaké.” ");
INSERT INTO wos_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Wungi wandaka dé Jisas diré wa, “Guniré wundé wawu. Wuni andu, hwakénguka du. Wuna duré mé takangut yinda.” ");
INSERT INTO wos_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Wungi wandéka wandén hundi dé mwi hundi ya: “Wunika hwemén du nakré haraki huruhambandi.” ");
INSERT INTO wos_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Du nak déka xi Malkus dé gélindu wali té. Dé prisna néma duka jémba yakwa du nak dé. Téndéka dé Saimon Pita xi warendaka yarré tara dé déka yika tamba sakumbu téndé waan xatéké. ");
INSERT INTO wos_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Xatékéndéka dé Jisas Pitaré wa, “Wungi hurukéméni. Ména yar mé lakwa wurmbu. Wuni wuna yafa hwendén hanyandémbu satawuni. Wuni wun hanyandémbu sawumboka yamba watéfikéméni.” ");
INSERT INTO wos_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Jisas wungi wandéka di Romna xi warekwa du nawulak, deka néma du, Judana gélindu nawulak wungi di déré huluke di yoombu gi. ");
INSERT INTO wos_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Gitaka di Anaska hura yi. Anas dé Kaiafasna nakéma dé. Wun héki hwari Kaiafas atéfék prisna néma du dé re. ");
INSERT INTO wos_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Hanja Kaiafas dé Judana néma duré angi wa, “Wun du atéfék du takwana hafwa hérae hiyandét, wungi sékérékétandé. Dé hafu hiyandét, nani atéfék yamba hiyakéme.” Wungi dé wa. ");
INSERT INTO wos_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Di Jisasré hura yindaka bér Saimon Pita Jisasna nakémba du wali déka hukémbu yi. Ye bér prisna néma duna gembu xaku. Wun néma du Jisasna nakémba duka dé xékélaki. Xékélakindéka dé Jisasna hukémbu ye dé néma duna gena séndékoré wulayi. ");
INSERT INTO wos_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Wulayindéka Pita hafwambu dé té. Téndéka dé Jisasna nakémba du dé gena séndéna yambuka hatikwa takwaré wa, Pitaka walét wulayindéte. ");
INSERT INTO wos_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Wandéka Pita wulayindéka lé wule takwa Pitaré wakwexéké, “Méni akwi Jisasna du méni?” Wungi wakwexékéléka dé Pita wa, “Wuni yingafwe.” ");
INSERT INTO wos_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Wungi wandéka di jémba yakwa du wali gélindu du wali di wumbu té. Téndaka dé yifa yandéka di ya hénjara, deka séfi tangurénjoka. Pita akwi di wali dé té, déka séfi tangurénjoka. ");
INSERT INTO wos_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Prisna néma du dé Jisasré déka duka wakwexéké. Du takwaka wakwendén hundika akwi dé wakwexéké. ");
INSERT INTO wos_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Wakwexékéndéka dé Jisas wa, “Wuni atéfék du takwana makambu téta wuni diré hundi wa. Godna hundi buléndaka gembu, tempelmbu akwi téta wuni du takwaka hundi wa. Wuni faakwa téta hundi nawulak wahambawuni. ");
INSERT INTO wos_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Métaka méni wunika wakwexéké? Wuna hundi xékéndé du takwaka mé wakwexéké. Wawuka xékéndan hundika méniré watandi.” Wungi dé wa. ");
INSERT INTO wos_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Wandéka dé gélindu nak wumbu te dé Jisasna saawimbu xiyaata dé wa, “Prisna néma duka wungi yamba wakéméni.” ");
INSERT INTO wos_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Wungi wandéka dé Jisas wa, “Wuni haraki hundi wawut, méni wunika wun hundi wataméni. Wuni mwi hundi wawuka métaka méni wuniré xiyae?” ");
INSERT INTO wos_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Wungi wandéka Anas wandéka di Jisasré hura yi, atéfék prisna néma du Kaiafaska. Déré gindan yoo wungi téndéka di hura yi. ");
INSERT INTO wos_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Saimon Pita déka séfi tangurénjoka dé ya walémbambu té. Téndéka xe di wa, “Méni akwi Jisasna du méni?” Wungi wakwexékéndaka dé wa, “Wuni yingafwe.” ");
INSERT INTO wos_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Wungi wandéka dé Pita waan xatékéndén duna hémna du dé xéké. Dé akwi jémba dé ya prisna néma duka. Xékétaka dé wa, “Méni Jisas wali yawimbu téméka wuni xé. Wu mwi hundi dé.” ");
INSERT INTO wos_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Wungi wandéka dé Pita wambula wa, “Yingafwe.” Wungi wandéka dé séra bari wa. ");
INSERT INTO wos_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Ganémbambu Jisasré hura Kaiafas yatakataka di Romna néma duna geré yi. Ye di deka hambuk hundi xékéta Pasovana hénoo sanjoka di Romna néma duna geré wulayihambandi. Judana hambuk hundi angi dé wa, “Guni nak téfana duna geré wulaaye guni haraki saraki sémbut hurutanguni. Hura guni Pasovana hénoo yamba sakénguni.” Wungi dé deka hambuk hundi wa. ");
INSERT INTO wos_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Wulayihafi yata hafwambu téndaka dé Romna néma du Pailat dika ye dé diré wa, “Wun duka méta hundi watanguni?” ");
INSERT INTO wos_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Wungi wandéka di wa, “Ané du haraki saraki sémbut dé huru. Dé haraki saraki sémbut huruhafi yandét, nani ménika déré hura yamba yakéme.” ");
INSERT INTO wos_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Wungi wandaka dé Pailat wa, “Guni déré hura ye guni hafu bulétanguni. Bulétaka guna hambuk hundi wandé maki guni déré duna makambu takatanguni.” Wungi wandéka di wunde Judana du wa, “Hanja guni Rom guni naniré watéfi, nani haraki saraki sémbut hurukwa duré duna makambu takataka déré xiyambemboka. Nani Jisasré xiyandate wanjoka nani hurufatiké.” Wungi di wa. ");
INSERT INTO wos_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Hanja Jisas mimbu hiyatendékaka dé hundi wa. Wunde du Pailatré wungi wandaka dé Jisas wandén hundi mwi hundi dé xaku. ");
INSERT INTO wos_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Wunde du wungi wandaka dé Pailat wambula wulayi geré. Wulaaye gembu reta dé Jisaska wandéka wulayindéka dé déka wakwexéké, “Méni Judana néma du, o yingafwe?” ");
INSERT INTO wos_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Wungi wakwexékéndéka dé wa, “Méni hafu sarékéta méni wungi wa, o nak du dé méniré wa?” ");
INSERT INTO wos_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Wungi wakwexékéndéka dé wa, “Wuni Judana du yingafwe. Wuni ménika xékélakihambawuni. Ména hafu getéfana du akwi prisna néma du akwi di méniré wunika hura ya. Méta méni ya?” ");
INSERT INTO wos_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Wungi wakwexékéndéka dé wa, “Wuni ané getéfambu néma du rewut wuna du warendat nawulak du wuniré hura ye Judana duka yamba hwekéndi. Némbuli wuni ané getéfaka néma du rehambawuni.” ");
INSERT INTO wos_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Wungi wandéka dé wakwexéké, “Méni néma du wana?” Wungi wakwexékéndéka dé wa, “Wu yawundu. Wuni néma du wuni. Wuni angi wuni we. Mwi hundi wanjoka wuni ané héfaré gaya. Mwi hundi wawute lé wuna ayiwa wuniré héra. Mwi hundi xékékwa du takwa di wuna hundi xéké.” ");
INSERT INTO wos_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Wungi wandéka dé wakwexéké, “Mwi hundi méta hundi dé?” Pailat wungi wataka dé Judana duka wambula gwandi. Gwande dé diré wa, “Wun du haraki saraki sémbut huruhambandé. ");
INSERT INTO wos_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Atéfék héki hwari Pasovana hénoo sa nukwa guni wunika wangukandé, séndé gembu rekwa du nakéka wawut dé gwandindéte. Némbuli Judana néma duré wawut dé gwandindéte guni mawuli ye, o yingafwe?” ");
INSERT INTO wos_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Wungi wakwexékéndéka hambukmbu wata di wa, “Yingafwe. Déka hélék me ye. Barabasré wamét gwandindéte nani mawuli ye.” Wungi di wa. Wun du Barabas dé duré xiyaata jondu sélé héraakwa du dé. ");
INSERT INTO wos_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Judana du wungi wandaka dé Pailat wandéka Romna xi warekwa du di Jisasré xiya, rami wali yoombu. ");
INSERT INTO wos_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Xiyataka di rami yoo hérae di anéngambambu sanda joo gootutaka di déka anéngambambu sandataka, néma du sandaka maki. Sandatakataka di néma duna waka nukwa wur déré sandataka. ");
INSERT INTO wos_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Sandatakataka di déré haraki hundi wata di wangi. Wangita di wa, “Judana néma du, jémba retaméni!” Wungi wata di deka tambambu déka saawiré di xiya. ");
INSERT INTO wos_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Xiyandaka Pailat gwande dé Judana duré wa, “Mé xé. Déré wuni gunika hura gwande. Guni xe xékélakitanguni. Dé haraki saraki sémbut huruhambandé.” ");
INSERT INTO wos_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Wungi wandéka dé Jisas gwande. Gootundan rami yoo dé déka anéngambambu té. Sandatakandan waka nukwa wur akwi déka séfimbu dé té. Téndéka dé Pailat diré wa, “Ané duré mé xé.” ");
INSERT INTO wos_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Wungi wandéka déré xéta di prisna néma du akwi gélindu du akwi di hambukmbu angi wa, “Déré mé xiyae mimbu hateka. Déré mé xiyae mimbu hateka.” Wungi wandaka dé Pailat diré wa, “Yingafwe. Wuni hurundén haraki saraki sémbut nawulakéka xékéhambawuni. Guni hafu déré hura ye xiyae mimbu hatekatanguni.” ");
INSERT INTO wos_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Wungi wandéka di Juda déré wa, “Wun du métaka hiyandé. Dé angi dé wa, ‘Wuni Godna nyan wuni.’ Wungi wata dé nana hambuk hundi xékéhambandé. Wun hundi angi dé wa, ‘Du nak Godka haraki hundi wandét, guni déré xiyatanguni.’ Nana hambuk hundi wungi dé wa.” ");
INSERT INTO wos_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Pailat wun hundi xékétaka dé déka mawulimbu wa, “Wun du Godna nyan wana?” Wungi sarékéta dé némafwimbu roo. ");
INSERT INTO wos_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Roota dé geré wambula wulayi. Wulayi wandéka Jisas wambula wulayindéka dé déka wakwexéké, “Méni yimbu méni ya?” Wungi wakwexékéndéka Jisas hundi nak buléhambandé. ");
INSERT INTO wos_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Buléhafi yandéka dé Pailat wa, “Métaka méni wuni wali buléhafi ye? Wuni mawuli ye wawut jémba yitaméni. Wuni mawuli ye wawut, di méniré xiyae mimbu hatekatandi. Wuni ambu wuni néma du re. Wun jooka méni xékélaki, o yingafwe?” ");
INSERT INTO wos_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Wungi wandéka dé Jisas wa, “God ménika hambuk hwehafi yandét méni ambu néma du yamba rekéméni. Wuniré ménika hwendé du némafwi haraki saraki sémbut di huru. Di hurundan haraki saraki sémbut méni huruméka haraki sémbutré dé sarékéngwandé.” ");
INSERT INTO wos_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Pailat wun hundi xékétaka dé Jisas baka takandét yitendéka yambuka dé hwaké. Hwaka dé Judaré wa, Jisasré wandét dé baka yindéte. Wandéka di wa, “Wun du angi dé wa, ‘Wuni néma du wuni.’ Wungi wata dé Romna néma duna hafwa héranjoka dé huru. Wungi huruta dé Romna néma duna mama dé re. Méni dé baka yindéte wamét, méni akwi Romna néma duna mama retaméni.” ");
INSERT INTO wos_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Pailat wun hundi xékétaka wandéka di Jisasré hura gwande. Gwandendaka dé Pailat kot xékékwa néma duna jambémbu re. Wun jambéka di wa, Motumbu yandan jambé dé. Hibruna hundimbu angi di wa, Gabata. ");
INSERT INTO wos_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Wun nukwa Judana du takwa Pasovana hénoo sanjoka di humbwi. Nukwa dawimbu ténjoka hurundéka dé Pailat néma duna jambémbu reta dé Judaka wa, “Guna néma duré mé xé.” ");
INSERT INTO wos_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Wungi wandéka hambukmbu di angi wa, “Déré mé héreki. Déré mé héreki. Déré mé xiyae mimbu hateka.” Wungi wandaka dé Pailat wakwexéké, “Guna néma duré xiyae mimbu hatekawute guni mawuli ye?” Wungi wandéka di prisna néma du wa, “Dé nana néma du yingafwe. Romna néma du dé male nana néma du dé.” ");
INSERT INTO wos_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Wungi wandaka dé Pailat Judana néma duna hundi xékétaka wandéka di Romna xi warekwa du Jisasré hura yi, xiyae mimbu hatekanjoka. ");
INSERT INTO wos_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Jisasré hura yindaka dé Jisas hafu dé déré xiyae hatekatendaka mi dé yata. Yatandéka Judana néma getéfa Jerusalem yatakataka di Anéngambana Afana hafwaré yi. Hibruna hundimbu angi di wa, Golgota. ");
INSERT INTO wos_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Wun hafwambu di Romna xi warekwa du Jisasré xiyae mimbu hateka. Du yétékré akwi di mi yétékmbu xiyae hateka. Nakré di aki tamba sakumbu xiyae hateka. Nakré di yika tamba sakumbu xiyae hateka. Xiyae hatekandaka dé Jisas nyéndékmbu téndé mimbu té. ");
INSERT INTO wos_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Pailat hundi nak haaye dé Jisasré hatekandan mimbu xiyataka. Angi dé hayi: Nasaretna du Jisas. Judana néma du dé. ");
INSERT INTO wos_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Pailat wun hundi Hibruna hundimbu akwi, Romna hundimbu akwi, Grikna hundimbu akwi wungi dé hayi. Jisasré xiyae mimbu hatekandan hafwa Judana néma getéfa walémbambu dé té. Téndéka di séfélak Juda wun hundi di xé. ");
INSERT INTO wos_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Xétaka di Judana prisna néma du di Pailatré wa, “Angi hayikéméni, Judana néma du dé. Wungi hayikéméni. Angi hayitaméni, ‘Ané du angi dé wa, Wuni Judana néma du wuni.’ Wungi hayitaméni.” ");
INSERT INTO wos_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Wungi wandaka dé Pailat wa, “Wuni hayiwun hundi wuni wundé hayiwu. Nak hundi wambula yamba hayikéwuni.” Wungi dé wa. ");
INSERT INTO wos_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Romna xi warekwa du yétiyéti di Jisasré xiyae mimbu hateka. Hatekataka di déka nukwa wur hérae di mune hari. Nak nak héraata di déka yikafre sanda wur munihambandi. Wun sanda wur atéfék natafambu yatindan dé, di hundafanéhambandi. ");
INSERT INTO wos_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Wun yikafre sanda wurré xéta di xi warekwa du wa, “Nani ané sanda wur yamba léngakéme. Nani nana xi haaye bu xékwa héna xi wana xakukéndé wana. Xakundét dé wun sanda wur hératandé.” Wungi wataka hurundaka dé du nak héra. Hérandéka Godna nyingambu rekwa hundi nak mwi hundi dé ya. Wun hundi angi dé: Di wuna nukwa wur nawulak mune di héra. Di wuna yikafre sanda wur héranjoka di deka xi hayindaka xakundéka dé héra. ");
INSERT INTO wos_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Jisas téndénmbu di Jisasna ayiwa Maria akwi, léka bandi akwi, Klopasna takwa Maria akwi, Makdalambu yalé takwa Maria akwi wungi di té. Wunde takwa Jisasré xiyae hatekandan mi walémbambu di té. ");
INSERT INTO wos_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Téndaka dé Jisas déka ayiwa wali déka mawuli mawuli yandéka du wali bér walémbambu témbéka. Xe dé déka ayiwaré wa, “Ayiwa, wun nyéna nyan dé.” ");
INSERT INTO wos_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Wataka dé déka duré wa, “Wule ména ayiwa lé.” Wungi wandéka wun nukwambu dé Mariaré hérae hura yi déka geré. Hura ye dé léré hati. ");
INSERT INTO wos_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Jisas wungi wataka dé xékélaki. Dé déka jémba wundé yasékendé. Xékélake dé Godna nyingambu atéfék hayindan maki hurunjoka dé angi wa, “Wuni hulinguka wuni hiyae.” ");
INSERT INTO wos_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Jisasré xiyae mimbu hatekandanmbu aki nak dé re. Wun akimbu nyingi wain hulingu nawulak dé té. Gumbu hwaakwa nyamba nak hérae di wun hulingumbu husanda. Husandataka bangimbu takataka husora di Jisaska hwe, dé jéma sandét déka holéméngi yikafre yandéte. ");
INSERT INTO wos_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Jisas wun hulingu sataka dé wa, “Yak. Andé hényi.” Wungi wataka dé wandé dae dé hafu déka hamwinya taka. ");
INSERT INTO wos_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Judana néma du Pasovana hénoo sanjoka di angi wa, “Séri baka hwa nukwambu hénoo satame. Wun nukwa néma nukwa dé. Séri deka fusa mimbu yamba tékéndé.” Wungi wata di Pailatré wa, “Méni wamét guna du xiyae mimbu hatekandan duna man yatukwetandi. Yatukwendat hiyandat di deka fusa hura ye rémétandi.” ");
INSERT INTO wos_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Wungi wandaka Pailat wandéka di xi warekwa du ye Jisas wali xiyae mimbu hatekandan du yéték bérka man di yatukwe. ");
INSERT INTO wos_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Yatukwetaka Jisaska ye di xé, dé wundé hiyandé. Xétaka déka man yatukwehambandi. ");
INSERT INTO wos_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Yatukwehafi yandaka dé Romna xi warekwa du nak xi hérae dé Jisasna yikanyambu xaréngériké. Xaréngérikéndéka dé nyéki wali hulingu wali bari dé bleka gaya. ");
INSERT INTO wos_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Gayandéka wuni ané nyinga hayindé du wuni xé. Xéwun jooka wuni gunika hundi hayi, guni akwi Jisaska jémba sarékéngute. Wawun hundi wu mwi hundi dé. Wungi wuni xékélaki. ");
INSERT INTO wos_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Xi warekwa du wungi hurundaka Godna nyingambu rekwa hundi yéték mwi hundi bér xaku. Wun hundi nak angi dé: “Déka afa nak yatukwehambandi.” ");
INSERT INTO wos_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Nak hundi akwi angi dé: “Ximbu xiyandan duré xétandi.” Wun nukwa wun hundi mwi hundi dé xaku. ");
INSERT INTO wos_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Romna xi warekwa du wungi hurundaka dé arimateana du josep ye dé Pailatré wakwexéké, Jisasna fusa héranjoka. josep dé Jisasna du nak dé. Dé Judana néma duka roota faakwa dé wa, “Jisas Godna nyan dé. Wu mwi hundi dé.” Wungi wata dé Jisaska jémba saréké. josep wakwexékéndéka Pailat yawundu nandéka dé josep yi, Jisasna fusa héranjoka. ");
INSERT INTO wos_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Yindéka dé Nikodemus josep wali dé yi. Hanja gan nak wun du dé Jisaska yi, dé wali hundi bulénjoka. Dé yikafre yama xaakwa mina bi yéték, bérka xi mir akwi alos akwi, hérae wukasande hura dé yi. Wun joo xak dé (30 kilo maki). ");
INSERT INTO wos_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Wumbére du ye bér Jisasna fusa héra. Hérae hura ye bér Judana du réméndaka maki, bér yikafre yama xaakwa mina bi fusambu takataka bér nukwa wurmbu barataka. ");
INSERT INTO wos_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Jisasré xiyae mimbu hatekandan hafwambu dé mi sendan yawi nak dé té. Wun hafwambu du hiyandét takatendaka huli wekwa nak dé té. Wun wekwambu hiyandé du nakré hanja takahambandi. ");
INSERT INTO wos_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Wun wekwa afakémbu téhambandé. Téhafi yandéka bér Jisasna fusa hura ye bér wulaaye wun wekwambu taka, Juda Pasovana hénoo sa nukwa bari yatendékaka. Wun nukwa di Juda hiyandé duré wekwambu takahafindi. ");
INSERT INTO wos_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Sande lé Makdalambu yalé takwa Maria raama lé Jisasna fusa takambén hafwaré yi, ganémbambu nukwa xalehafi téndéka. Ye lé xé wun wekwambu takatéfimbén motu wun wekwambu téhafi yandéka. ");
INSERT INTO wos_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Xétaka fétékéra ye lé Saimon Pita wali Jisasna mawuli mawuli yandéka du wali bér yambumbu xé. Xe lé bérré wa, “Nana Néma Du wekwambu rendéka wundé hura yinda. Hura ye takandan hafwaka yike me ye.” Wungi lé wa. ");
INSERT INTO wos_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Wun hundi xékétaka Pita wali Jisasna nakémba du wali getéfa yatakataka bér Jisasna fusa takambén wekwaré fétékéra yi. ");
INSERT INTO wos_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Ye nakémba du ye dé Pitaré tenangérétaka dé tale yi. Tale ye dé Jisasna fusa takambén wekwambu xaku. ");
INSERT INTO wos_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Xaakwa hwaséleka yasalo dé xé fusa baratakambén nukwa wur male rendéka. Xétaka wulayihambandé. ");
INSERT INTO wos_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Saimon Pita hukémbu yae dé Jisasré takambén wekwaré wulayi. Wulaaye dé xé fusa baratakambén nukwa wur rendéka. ");
INSERT INTO wos_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","Jisasna anéngambambu gimbén nukwa wur akwi lamweka takandéka jémba rendéka dé xé. Wun nukwa wur nawulak nukwa wur wali rehambandé. Dé hafu dé re. ");
INSERT INTO wos_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Rendéka xéndéka dé tale yandé du dé akwi wulayi. Wulaaye xe dé xékélaki, “Jisas wundé raméndé.” ");
INSERT INTO wos_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Hanja di Jisas hiyae wambula ramétendékaka hundi hayi, Godna nyingambu. Hanja bér wun hundika xékélakihafi ya. ");
INSERT INTO wos_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Bér wun jonduré xe bér bérka geré wambula yi. ");
INSERT INTO wos_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Maria hafwambu téta lé géra. ");
INSERT INTO wos_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Géraata téta hwaséleka lé wekwaré yasalo xé, Godna ensel yéték wama nukwa wur sandataka rembéka. Jisasna fusa takambén hafwambu bér re. Nak dé humbu sakumbu re. Nak dé man sakumbu re. ");
INSERT INTO wos_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Reta bér Mariaka wa, “Nyénawa, métaka nyéni gérae?” Wungi wakwexékémbéka lé bérré wa, “Wuna Néma Duré wundé hura yinda. Hérae hari takandan hafwaka yike wuni ye.” ");
INSERT INTO wos_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Wungi wataka waleka lé xé, Jisas téndéka. Xe déka xékélakihambalé. ");
INSERT INTO wos_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Xékélakihafi yaléka dé Jisas léré wa, “Nyénawa, métaka nyéni gérae? Héndéka nyéni hwaké?” Wungi wakwexékéndéka lé Maria angi saréké “Dé yawika hatikwa du wana?” Wungi sarékéta lé wa, “Yika du, méni déré hérataka wuniré mé wakwemét wuni ye déré hérae hura yitawuni.” ");
INSERT INTO wos_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Wungi waléka dé Jisas wa, “Maria.” Wungi wandéka lé waleka déka xékélakita lé Hibruna hundimbu angi wa, “Rabonai.” Wun hundi na mo hundi angi dé, “Wakwekwa du.” ");
INSERT INTO wos_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Maria wungi waléka dé Jisas wa, “Nyéni wuniré hurukényéni. Wuni wuna yafaka warihafi wuni té. Nyéni wuna bandinguka ye angi watanyéni, ‘Dé déka yafa guna yafaka dé yi. Dé déka God guna Godka dé yi.’ Wungi watanyéni diré.” ");
INSERT INTO wos_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Wungi wandéka xékétaka lé Makdalambu yalé takwa Maria ye lé déka duré wa, “Wuni nana Néma Duré wundé xéwu.” Wungi wataka lé Jisas wandén maki safé. ");
INSERT INTO wos_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Wun nukwambu Jisasna du di Judana néma duka roota di rendan gena yambu jémba téfi. Sande nukwa nandindéka dé Jisas yae deka nyéndékmbu té. Téta dé diré wa, “Guna mawuli nakélak mé téndé.” ");
INSERT INTO wos_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Wungi wata dika dé tambana haak akwi, yikanyana haak akwi wakwe. Wakwendéka deka Néma Duré xe mawuli ye di mawuli sawuli ya. ");
INSERT INTO wos_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Mawuli yandaka dé Jisas diré wambula wa, “Guna mawuli nakélak mé téndé. Wuna yafa wandéka wuni déka jémba yanjoka wuni ya. Wandén maki wuni wawut guni wuna jémba yanjoka yitanguni.” ");
INSERT INTO wos_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Wungi wataka dé déka yanambi diré yota dé diré wa, “Guni Godna Hamwinya hératanguni. ");
INSERT INTO wos_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Guni haraki saraki sémbut hurukwa du takwaka angi wangut, ‘God hurungun haraki saraki sémbut hérekitandé.’ Wungi wangut God wungi hurutandé. Guni haraki saraki sémbut hurukwa du takwaka angi wangut, ‘God hurungun haraki saraki sémbut yamba hérekikéndé.’ Wungi wangut God hurundan haraki saraki sémbut yamba hérekikéndé.” Wungi wataka dé Jisas yi. ");
INSERT INTO wos_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Jisas dika yandén nukwa déka du nak rehambandé. Déka xi Tomas dé. Déka nak xi Didimas dé. ");
INSERT INTO wos_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Jisasna du déré xe di wa, “Nana Néma Du Jisas hiyae wambula raméndéka wundé xékwa.” Wungi wandaka dé Tomas wa, “Wuni déka tambambu ramimbu xiyandan xe, wuna sékétamba wumbu husolata, wuna tamba déka yikanyambu akwi husolataka, wuni guna hundi jémba xékétawuni. Némbuli guna hundi yamba xékékéwuni.” Wungi dé wa. ");
INSERT INTO wos_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Nukwa angé yétiyéti angé hufuk yindéka di Jisasna du wambula gekombu re. Tomas akwi di wali dé re. Atéfék yambu jémba téfitaka rendaka Jisas yae dé deka nyéndékmbu té. Téta dé wa, “Guna biya nakélak mé téndé.” ");
INSERT INTO wos_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Wataka dé Tomasré wa, “Méni ména sékétamba ambu mé husolataka wuna tambaré xé. Méni ména tamba mé hura yae husolo, wuna yikanyambu. Méni deka hundika yamba hu hwekéméni. Némbulimbu wunika mé jémba saréké.” ");
INSERT INTO wos_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Wungi wandéka dé Tomas Jisaska jémba sarékéta dé wa, “Owa, méni wuna Néma Du God méni.” ");
INSERT INTO wos_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Wungi wandéka dé Jisas wa, “Méni wuniré xe méni wunika jémba saréké. Wuniré xéhafi yata wunika jémba sarékékwa du takwa yikafre mawuli yata jémba retandi.” Wungi dé Jisas Tomasré wa. ");
INSERT INTO wos_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Jisas hanja xéhafi yamben séfélak hambuk jémba nawulak akwi nani déka duna makambu dé ya. Yandén jémba atéfék ané nyingambu hayihambawuni. ");
INSERT INTO wos_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Ané hayiwun hundi xéta Jisaska jémba sarékéngute wuni hayi. Guni watanguni, “Jisas dé God wasékendén du Krais dé. Dé Godna nyan dé.” Guni wungi wata déka jémba sarékéta hwetendéka huli mawuli hérae wungi re wungi re jémba rengute wuni hayi. ");
INSERT INTO wos_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Hukémbu Jisasna du di taiberius tukwesekembu téndaka dé Jisas dika wambula yi, di déré jémba xéndate. Dika yindénéna hundi angi dé. ");
INSERT INTO wos_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Saimon Pita, Tomas, déka nak xi Didimas, Kanambu yandé du Nataniel, Sebedina nyan yéték, Jisasna du yéték akwi wungi di wun tukweseke tufwambu té. Kana Galilimbu dé té. ");
INSERT INTO wos_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Saimon Pita dé diré wa, “Wuni xéri hamwi héranjoka yitawuni.” Wungi wandéka di déré wa, “Nani akwi méni wali yitame.” Wungi wataka di atéfék ye di gunjambé nakmbu wara di yi. Ye di wun gan atéfék di jémba yata xéri hamwi nawulak hérahambandi. ");
INSERT INTO wos_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Xitélakéndéka Jisas yae dé tukweseke tufwambu té. Téndéka di déka du gunjambémbu reta déré xe di déka xékélakihambandi. ");
INSERT INTO wos_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Xékélakihafi yandaka dé diré wakwexéké, “Gunawa, xéri hamwi nawulak guni hérae wana?” Wungi wakwexékéndéka di wa, “Yingafwe.” ");
INSERT INTO wos_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Wungi wandaka dé wa, “Guni guna yika tamba sakumbu mara yakisandataka guni xéri hamwi hératanguni.” Wungi wandéka di mara yakisandandaka di séfélak xéri hamwi marambu wulaaye téndaka di témbéra hura warinjoka di hurufatiké. ");
INSERT INTO wos_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Hurufatikéndaka dé Jisas mawuli mawuli yandén du dé Saimon Pitaré wa, “Dé nana Néma Du dé.” Wandéka xékétaka Pita jémba yanjoka lafindén nukwa wur wambula sandataka dé guré naande dé xéra yi. ");
INSERT INTO wos_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Di gu tufwa walémbambu di té. Afakémbu téhambandi (100 mita maki). Dé yindéka di gunjambémbu yita mara xéri hamwi wali témbéra hura yi. ");
INSERT INTO wos_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Di ye tufwambu xaakwa di xé, ya nak yanéta rendéka. Xéri hamwi, bret wungi dé wun yambu yanéta re. ");
INSERT INTO wos_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Rendéka dé Jisas diré wa, “Wayika male hérangun xéri hamwi nawulak mé hérae hura ya.” ");
INSERT INTO wos_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Wungi wandéka Saimon Pita gunjambémbu wara dé mara lakéra hura ya, tufwaré. Séfélak (153) némafwi xéri hamwi di marakombu hwa. Hwandaka mara nékétihambandé. ");
INSERT INTO wos_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Yandéka dé Jisas diré wa, “Guni mé yae sa.” Wungi wandéka di Jisasré “Méni héndé” naata wakwexékénjoka di roo. Di wundé xékélakinda. Dé deka Néma Du dé. ");
INSERT INTO wos_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Jisas yae dé bret wali xéri hamwi wali hérae dé dika hwe. ");
INSERT INTO wos_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Jisas hiyae raama tale nukwa yéték dé déka duna makambu xaakwa té. Némbuli xakundéka nukwa hufuk dé wa. ");
INSERT INTO wos_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Bret xéri hamwi sataka dé Jisas Saimon Pitaré wa, “Saimon, Jonéna nyan, méni anémbu tékwa duré sarékéngwanda méni wunika némafwimbu mawuli ye?” Wungi wakwexékéndéka dé Pita wa, “Xéxé. Néma Du, méni xékélaki. Wuni ménika némafwimbu mawuli wuni ye.” Wungi wandéka dé Jisas wa, “Méni wuna sipsip bali nyanka hénoo mé hwe.” ");
INSERT INTO wos_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Wungi wataka dé wambula wa, “Saimon, Jonéna nyan, wunika némafwimbu mawuli méni ye?” Wungi wandéka dé wa, “Xéxé. Néma Du, méni xékélaki. Wuni ménika némafwimbu mawuli wuni ye.” Wungi wandéka dé Jisas wa, “Méni wuna sipsip balika jémba mé hati.” ");
INSERT INTO wos_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Wungi wataka dé wambula wa, “Saimon, Jonéna nyan, méni wunika némafwimbu mawuli méni ye?” Wungi wandéka dé déka mawuli xak dé ye, Jisas yambu hufuk wakwexékéndénka. Mawuli xak yandéka dé Jisasré wa, “Néma Du, méni atéfék jonduka méni xékélaki. Wunika akwi méni xékélaki. Wuni ménika némafwimbu mawuli wuni ye.” Wungi wandéka dé Jisas wa, “Méni wuna sipsip balika hénoo mé hwe. ");
INSERT INTO wos_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Mwi hundi wuni méniré we. Hanja méni wayikana du téta méni nukwa wur naake méni mawuli yamén maki yitaka yataka. Hukémbu méni gwalefa xaakwa ména tamba harékémét nak du méniré gitandi. Gitaka yinjoka hélék yaméka hafwaré méniré hura yitandi.” ");
INSERT INTO wos_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Wungi wata dé Pitaré xiyatendakaka dé hundi wa. Pitaré xiyandat hiyae dé Godna ximbu harékétandé. Wungi yatendékaka dé Jisas wun hundi wa. Wungi wataka dé Pitaré wambula wa, “Méni wuna hukémbu mé ya.” Wungi dé Jisas wa. ");
INSERT INTO wos_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Jisas wungi wandéka Pita waleka dé xé, Jisas mawuli mawuli yandéka du bérka hukémbu yandéka. Hanja Jisas wali reta hénoo sata dé déré wakwexéké, “Néma Du, héndé méniré ména mama duka hwetandé?” Wungi dé wa. ");
INSERT INTO wos_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Pita wun duré xe dé Jisaska wa, “Néma Du, wun du méta yatandé?” ");
INSERT INTO wos_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Wungi wakwexékéndéka dé Jisas wa, “Dé rendéte mawuli yata wawut dé wambula yatewuka nukwaka haxétandé. Wungi wawut, wu déka jémba dé. Méni wun jooka yamba sarékékéméni. Méni wuna hukémbu mé ya.” ");
INSERT INTO wos_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Dé wungi wandéka di déka hundi xékékwa du nawulak di wun duka wa, “Wun du yamba hiyakéndé.” Wungi di wa. Wandaka wun du hiyahafi yatendékaka Jisas Pitaré wahambandé. Angi male dé wa, “Dé rendéte mawuli yata wawut, dé wambula yatewuka nukwaka haxétandé. Wu déka jémba dé. Méni wun jooka yamba sarékékéméni.” Wungi male dé Jisas wun duka wa. Wun du wun nukwaka haxéndéte wahambandé. ");
INSERT INTO wos_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Wuni Jisas yandén jémbaka haaye wuni wun du wuni. Wuni ané nyingambu mwi hundi wuni hayi. Nani xékélaki. Hayiwuka hundi wu mwi hundi dé. ");
INSERT INTO wos_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Jisas yandén jémba séfélak dé. Yandén jémbaka atéfék hayihambawuni. Du nawulak yandén jémbaka atéfék hayindat, hayindan nyinga ané héfambu takandat, atéfék héfa sukwekétandé. Hafwa nak yamba rekéndé. Wungi wuni saréké. ");
INSERT INTO wos_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Méni Tiofilaska, wuni ané nyinga hayi. Hanja nak nyingambu Jisas yandén atéfék jémbaka wali wandén atéfék hundika wali wuni hayi. ");
INSERT INTO wos_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","Hanja Jisas déka duré dé waséke, di déka aposel rendate. Hukémbu Godna Hamwinyambu dé déka duré wa, di déka jémba yandate. Wandéka hukémbu God wandéka dé Jisas wari, Godna getéfaré. Wun jonduka wundé hayiwu. ");
INSERT INTO wos_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Guni xékélaki, hanja Jisas hangéli hérae dé hiya. Hiyae hukémbu raama dé déka duka yi. Dumi yétiyéti nukwa dé dika yi. Ye di wali reta nak maki nak maki hambuk jémba yandéka xéndaka hundi wandéka xékéta di wa, “Dé hiyae dé wambula ramé. Wu mwi hundi dé.” Wungi wandaka dé diré hundi wa, God néma du reta du takwaka hatitendékaka. ");
INSERT INTO wos_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Wataka dé di wali reta dé wambula diré wa, “Guni Jerusalem yatakakénguni. Guni wumbu reta guni wuna yafana Hamwinyaka haxétanguni. Hanja wuna yafa dé wa, déka Hamwinya hwetendékaka. Wuni akwi guniré wundé wawu, déka Hamwinya hwetendékaka. Guni haxétanguni. ");
INSERT INTO wos_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Hanja Jon dé du takwaré guré dé husanda, Godna ximbu. Guré husandandéka maki, nawulak nukwa yindét, God wandét, Godna Hamwinya guna mawuliré wulaaye tétandé.” Wungi dé Jisas wa. ");
INSERT INTO wos_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Jisasna du dé wali hundi buléta di déré wakwexéké, “Néma Du, némbuli méni nani israelna du takwaka néma du retaméni, hanja Devit néma du rendén maki?” ");
INSERT INTO wos_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Wungi wakwexékéndaka dé Jisas diré wa, “Yingafwe. Hanja wuna yafa God hafu wundé wetakandéka dé re, hukémbu xakute yakwa joona nukwaka. Wun déka jémba dé. Guni wandén nukwaka yamba xékélakikénguni. ");
INSERT INTO wos_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Godna Hamwinya guna mawulimbu wulaaye téta gunika hambuk hwendét, guni wunika hundi watanguni. Jerusalemémbu rekwa du takwaka, Judiana héfambu samariana héfambu rekwa du takwaka, atéfék héfambu rekwa du takwaka akwi hundi watanguni, wunika.” Wungi dé Jisas wa. ");
INSERT INTO wos_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Jisas wungi wandéka God wandéka dé wari, Godna getéfaré. Warindéka xéta téndaka buwi nak takatéfindéka di déré xéhambandi. ");
INSERT INTO wos_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Xéhafi yandaka yindéka di yasawara xéta hwakéndaka bér wama nukwa wur sandandé du yéték bari hari gwande bér di wali té. ");
INSERT INTO wos_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Téta bér wa, “Gunawa, Galilina du, métaka guni wumbu téta nyirré yasawara xé? God wandéka dé Jisas guniré yatakataka dé Godna getéfaré wari. Warindéka guni xé. Xéngun maki male Jisas wambula gayatandé.” Wungi bér wa. ");
INSERT INTO wos_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Wumbére du wungi wambéka di Jisasna du Oliv némbu yatakataka ye di Jerusalemré wambula wulayi. Wun némbu Jerusalem wali walémbambu dé té. Yindaka yambu afaké yingafwe. ");
INSERT INTO wos_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Jerusalemré wulaaye di rendan gena taku geré wari. Pita, Jon, Jems, Andru, Filip, Tomas, bartolomyu, Matyu, alfiusna nyan Jems, nak Jemsna nyan Judas, Saimon, wungi di wara re. Wumba du Saimon nak héfana du déka getéfana duka néma du rendémboka hélék yandé du dé. ");
INSERT INTO wos_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Wunde du atéfék di du takwa nawulak akwi, Jisasna ayiwa Maria akwi, Jisasna bandingu akwi, wungi di atéfék nukwa hérangwanda God wali hundi bulé. ");
INSERT INTO wos_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Nukwa nawulak yindéka Jisasna hundi xékékwa séfélak (120 maki) du takwa gembu hérangwandéndaka dé Pita deka nyéndékmbu téta dé angi wa, ");
INSERT INTO wos_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","”Wuna nyama bandi, hanja Godna Hamwinya wandéka dé Devit Judaska hundi hayi, Godna nyingambu. Wun hundi mwi hundi yandéte dé Judas Jisasré hura dé wakwe, déka mamaka. ");
INSERT INTO wos_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Wun hundi mwi hundi dé ya, Judas yandén jémbaka. Hanja Jisas wandéka dé wun du Judas nani wali yitaka yatakata dé jémba ya.” Wungi dé Pita wa. ");
INSERT INTO wos_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Judas haraki saraki sémbut hura Jisasré mamaka hwetaka dé yéwa nawulak héra. Hérae hwetaka dé héfa nak héra. Hérae dé wun héfambu dé xakri. Xakre dé déka biya fukandéka dé di jamuneka gwandendéka dé wungi hiya. ");
INSERT INTO wos_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Hiyandéka di Jerusalemémbu rekwa atéfék du takwa di wun hundi xéké. Hibru hundimbu wun héfaka di wa, “Akeldama.” Wun hundina mo hundi angi dé, “Nyéki rekwa héfa dé.” ");
INSERT INTO wos_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Pita Judaska sarékéta dé dé wali rekwa du takwaré angi wa, “Devit hayindén gwar angi dé wa: Déka rendén hafwa baka retandé. Nak du wumbu yamba rekéndé. Wungi dé hayi. Nak hundi akwi angi dé wa: Nak du déka jémba hérae du takwaka hatitandé. Wungi dé hayi Judaska. ");
INSERT INTO wos_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","22","”Wungi maki, némbuli wambet Jisasna jémbaré xéndé du nak nani wali yitaka yatakata dé akwi du takwaka watandé, ‘Néma Du Jisas hiyae dé wambula ramé. Wungi wuni xé.’ Wungi watandé. Hanja guré husandakwa du Jon dé du takwaré yikafre hundi wa. Wandén nukwa du nawulak di nani wali yitaka yataka. Yitaka yatakata di nani wali nana Néma Du Jisas wali jémba ya. Yambeka God wandéka Jisas Godna getéfaré warindéka di nani wali té. Wunde duka sarékétame. Sarékéta wunde du nakré wasékembet, dé nani wali yitaka yatakatandé.” ");
INSERT INTO wos_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Wungi wandéka di du yétékna xi wa, josep, déka nak xi Basabas. Nawulak déka angi di wa, Jastus. Nakémba du akwi, Matias dé. ");
INSERT INTO wos_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","25","Wataka di Jisaska angi wakwexéké, “Nana Néma Du, méni xékélaki. Judas dé ména jémba yatakataka hiyae dé déka hafu hafwaré yi. Yindéka némbuli nani méniré we. Méni atéfék duna mawulika méni xékélaki. Wungi xékélakita némbuli méni ambére du yétékré xe wasékemén duré nanika wakwetaméni. Wakwemét, wun du ména aposel reta ména jémba yatandé. Yata dé Judasna hafwa hératandé.” ");
INSERT INTO wos_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Wungi wakwexékétaka di motumbu bérka xi hayi. Hayitaka motu take di xé Matiasna xi hayindan motu xalendéka. Xéndaka dé Matias Jisasna aposel tamba yéti angé man natafa wali yitaka yatakata dé Jisasna jémba ya. ");
INSERT INTO wos_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Pentikosna néma nukwa xakundéka di Jisasna du atéfék di natafa gembu hérangwanda re. ");
INSERT INTO wos_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Reta di xéké, némafwi ham Godna getéfambu bari gayandéka. Wun ham némafwi hambuk mur maki dé ya. Wun ham rendan geré wulaaye dé sukweka té. ");
INSERT INTO wos_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Xékéta di xé séfélak yalefu ya maki jondu natafambu te mutala ye di nak nak duna anéngambambu xérékéta téndaka. ");
INSERT INTO wos_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Xéndaka dé Godna Hamwinya deka mawulimbu wulaaye téta dika hambuk hwendéka di nak nak téfana hundimbu di bulé. ");
INSERT INTO wos_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Hanja séfélak Judana du di atéfék getéfambu ya. Yae di Jerusalemémbu re. Wunde du di Godna ximbu harékékwa du di. ");
INSERT INTO wos_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Wun ham xékétaka di séfélak du di Jisasna du téndanmbu hérangwanda té. Téta nak nak di xéké Jisasna du nak nak deka getéfana hundimbu buléndaka. Xékéta di saréké waréké xéké. ");
INSERT INTO wos_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Saréka waréngéna nae di wa, “Owa. Wun hundi bulékwa du di Galilina du di wana? ");
INSERT INTO wos_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Wunde du nana hundi yike di ye. Yingi maki nae di nana getéfana hundimbu bulé? Buléndaka nani nak nak nana getéfana hundimbu xéké. ");
INSERT INTO wos_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Nani séfélak héfambu nani ya. Partia, Midia, Elam, Mesopotemia, Judia, Kapadosia, Pontus, Esia, ");
INSERT INTO wos_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","Frigia, Pamfilia, Isip, Libiana hafwa Sairini wali walémbambu tékwa, wun héfambu nani ya. Nani nawulak Romémbu yae nawulak nukwa male ambu re. Nawulak nani Judana du. Nawulak nani nak téfana du nani Judana hambuk hundi xéké. ");
INSERT INTO wos_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","Nawulak nani Kritna héfambu nani ya. Nawulak nani Arebiana héfambu nani ya. Nani atéfék nana getéfana hundimbu nani xéké. Di nana getéfana hundimbu buléta God hurundén hambuk jémbaka wandaka nani xéké. Yingi maki nae di nana hundimbu bulé?” ");
INSERT INTO wos_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Wungi wata di waréngéné. Waréngénéta saréké waréké xékéta di di hafu buléta di wa, “Owa. Ané yingi maki joo dé?” ");
INSERT INTO wos_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Wungi wandaka di nawulak Jisasna duré bangwa hundi wata di wa, “Séfélak huli wain hulingu sataka di wangété ye.” Wungi di wa. ");
INSERT INTO wos_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Wandaka dé Pita Jisasna du tamba yéti angé man natafa di wali téta dé atéfék du takwaré hambukmbu wata dé wa “Gunawa, Judana du takwa, Jerusalemémbu rekwa du takwa, waan mé nakélak take wuna hundi xéké. Xékéta xéngun jooka xékélakitanguni. ");
INSERT INTO wos_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Guni séféla guni we. Némbuli ganémba male dé. Nani Judana du wain hulingu ganémbambu sahafime. Yingafwe. Guni wungi guni xékélaki. Wunde du wangété yandaka hulingu sahambandi. Di wangété yahambandi. ");
INSERT INTO wos_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Hanja Godna profet Joel dé wun huli jémbaka Godna nyingambu angi dé hayi: ");
INSERT INTO wos_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","God dé wa, ‘Hukétéfi nukwa walémba téndét, wuni wuna Hamwinya blekétawuni, atéfék du takwaka. Hwewut guna dunya, takwanya, wuna hundi xékéta, profetna hundi watandi. Guna wayikana du janji maki joo xéndat, di guna gwalefa du janji hwatandi. ");
INSERT INTO wos_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Wun nukwambu wuni wuna Hamwinya blekétawuni, wuna jémba yakwa du takwaka. Blekéwut di profetna hundi watandi. ");
INSERT INTO wos_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Nak maki joo hurutawuni, nyirmbu akwi, héfambu akwi. Huruwut, du takwa xéta waréngénétandi. Nyéki wali, ya wali, yaki wali huruwut xakundét xétandi. ");
INSERT INTO wos_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Wawut nukwa hiyandét gan hunyitandé. Wungi yandét bafu akwi nyéki maki xakutalé. Xakulét hukémbu Néma Duna némafwi nukwa xakutandé. Wun nukwambu Néma Du déka némafwi hambuk wakwetandé. ");
INSERT INTO wos_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Wun nukwa du takwa dika yikafre hurundéte di Godka wandat, dé diré yikafre hura satanéna tambambu hérandét, di jémba retandi.’ Wungi dé God hanja wa. ");
INSERT INTO wos_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","Wun hundi wataka dé Pita wambula wa, “Israelna du, guni mé xéké ané hundi. Nasaretna du Jisaska watawuni. God wandéka dé Jisas nak maki nak maki hanja xéhafi yangun hambuk jémba dé ya, guna nyéndékmbu. Yandéka guni ambu reta wun jémba xétaka guni xékélaki, ‘Dé Godna du dé.’ ");
INSERT INTO wos_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Wun duré du nak dé guna tambambu taka, God hanja sarékéta xékélakindén maki. Takandéka guni déré Godna hundi xékéhafi yandé duna tambambu takanguka di Jisasré xiyae mimbu hatekandaka dé hiya. ");
INSERT INTO wos_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Hiyandéka God du hiyana sémbut hérekindéka dé wambula ramé. Hiya sémbut déré hulukinjoka dé hurufatiké. ");
INSERT INTO wos_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Hanja Devit angi dé wa, déka: Wuni atéfék nukwambu wuni xé, Néma Du wuni wali téndéka. Dé wuna yika tambambu té, wuni roota généwumboka. ");
INSERT INTO wos_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Xéwuka dé wuna mawuli yikafre yandéka wuni mawuli sawuli yata wuna hundimbu wuni déka ximbu haréké. Wuni wamén hundika sarékéta wuni hiyanjoka roohafi yata jémba retawuni. ");
INSERT INTO wos_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Méni God, méni wa, wuna hamwinya hiyandé duna getéfambu rehafi yandéte. Méni wamét ména yikafre duna fusa yamba yama xakéndé. ");
INSERT INTO wos_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Méni wuniré wunde wakwemé, huli hamwinya héra yambu. Wakweméka wuni méni wali téta yikafre mawuli yata mawuli sawuli yatawuni. Wungi dé Devit hanja hayi.” ");
INSERT INTO wos_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","Wun hundi wataka dé Pita wambula wa, “Nyama bandi, guni mé xéké. Wuni wawut, guni jémba xékélakitanguni, ané hundi. Nana mandéka Devit wundé hiyandé. Hiyandéka di déré wundé réménda. Déré réméndan hwandafu ané getéfambu némbuli andé re. ");
INSERT INTO wos_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Devit wun hundi hayita dé hafuka hayihambandé. Wun hundi hayindén wu nak duka dé hayi. Godna hundi wanjoka hukémbu yate yakwa duka dé hayi. Hanja God dé déré wa, ‘Ména mandéka nak ména hafwa hérae dé néma du retandé. Mwi hundi wuni méniré we.’ Wungi God wandéka dé Devit xéké. ");
INSERT INTO wos_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Xékéta God yatendéka jémbaka xékélakita dé wa, ‘God wandét dé hiyandé duna getéfambu yamba rekéndé. Déka fusa yamba yama xakéndé.’ Wungi wata Devit God wasékendén du Krais hiyae ramétendékaka dé hayi. Guni wun hundika sarékéta némbuli ané hundi mé xéké. ");
INSERT INTO wos_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Jisas hiyandéka dé God déré wambula husaraméndéka nani Jisasna du wundé xékwa. Xémbenka guniré wuni we. ");
INSERT INTO wos_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","God wandéka dé Jisas Godna getéfaré wara dé Godna yika tamba sakumbu re. Hanja déka yafa God dé Jisasré wa, ‘Wuna Hamwinya ménika hwetawuni.’ Wungi wataka déka Hamwinya hwendéka hérae dé nanika bleka yakindéka xe xéka andé xékélakingwi. ");
INSERT INTO wos_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Hanja Devit Godna getéfaré warihambandé. Warihafi ye dé hafu dé angi wa: Néma Du God wuna Néma Duré dé wa, ‘Méni wuna yika tambambu retaméni. ");
INSERT INTO wos_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","Remét wuni wawut ména mama ména manéna ekombu retandi. Wun hundi wandén, wu Jisaska dé wa. ");
INSERT INTO wos_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","”Guni, israelna du takwa, mé xéké. Xékéta jémba xékélakitanguni. Wun du Jisaska wuni we. Jisasré guni xiyae mimbu hatekanguka dé hiya. Hiyandéka God wandéka dé Jisas Néma Du dé re. Wun du God wasékendén du Krais dé.” Wungi dé Pita wa. ");
INSERT INTO wos_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Wandéka di du takwa wun hundi xékéndaka xi maki xiyandéka di Pitaré akwi Jisasna aposelré akwi di wakwexéké, “Gunawa, nana du, méta yatame?” ");
INSERT INTO wos_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Wungi wakwexékéndaka dé Pita wa, “Guni nak nak guna haraki saraki sémbut yatakangut nani Jisas Kraisna ximbu guniré guré husandatame. Guni wungi hurungut God guna haraki saraki sémbut yakwanyitaka déka Hamwinya hwetandé, gunika. Hwendét déka Hamwinya guna mawulimbu wulaaye tétandé. ");
INSERT INTO wos_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Hanja God dé wa, ‘Wuni guniré akwi, guna mandékaré akwi yikafre hurutawuni. Mwi hundi wuni we.’ Wungi wataka dé afakémbu rekwa du takwaka akwi déka Hamwinya hwenjoka dé mawuli ye. Nana Néma Du God wasékendén du takwa atéfékéka déka Hamwinya hwenjoka dé mawuli ye.” ");
INSERT INTO wos_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Wun hundi wataka dé Pita wambula hundi nawulak wata dé wa, “Ambu rekwa du takwa séfélak haraki saraki sémbut hurundanka God wun sémbut diré hasa hwendét, di hangéli hératandi. Guni guna haraki saraki sémbut mé yataka. Yatakataka yikafre mawuli yata di wali wun hangéli yamba hérakénguni.” ");
INSERT INTO wos_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Wungi Pita wandéka di séfélak du takwa déka hundi xéké. Xékéta di Jisaska jémba saréké. Sarékéta mawuli yandaka di diré Kraisna ximbu guré husanda. Wun nukwambu 3,000 du takwa di Jisasna du takwa wali re. ");
INSERT INTO wos_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Wungi reta di atéfék nukwambu di Jisasna aposel wakwendan hundi xékéta di Jisasna du takwa wali jémba reta di Jisaska sarékéta bret fukae sata di God wali hundi bulé. ");
INSERT INTO wos_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","God wandéka di Jisasna aposel di nak maki nak maki, hanja xéhafi yandan hambuk jémba di ya. Yandaka di atéfék du takwa xéta waréngéna di roo. ");
INSERT INTO wos_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Jisasna hundi xékékwa du takwa natafa mawuli héraata di atéfék jémba re. Reta di deka jondu hura yae di wa, “Ané Jisaska jémba sarékékwa atéfék du takwana jondu dé. Ané nana jondu male yingafwe.” ");
INSERT INTO wos_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Wungi wataka di nawulak du takwa deka jondu deka héfa akwi hwetaka, yéwa hérae di wun yéwa mune hwe, jondu yike reta Jisasna hundi xékékwa du takwaka. ");
INSERT INTO wos_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Atéfék nukwa tempelmbu hérangwanda reta di God wali hundi bulé. Bulétaka wun ge yatakataka di nak du nak duna geré wulaaye di nata mawuli hérandaka dé deka mawuli yikafre téndéka di hénoo sékéré sa. ");
INSERT INTO wos_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Wungi huruta Godna ximbu harékéndaka di séfélak du takwa xe di wa, “Wunde yikafre du takwa di. Jémba male di re.” Atéfék nukwa Néma Du dé du takwa nawulakré akwi dé wa, déka hundi xékéndate. Wandéka déka hundi xékéta di, di akwi Jisaska jémba saréké. Sarékéta di Jisasna du takwa wali di re. ");
INSERT INTO wos_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Gérambu nak Pita bér Jon tempelré yinjoka bér yambumbu wari, atéfék gérambu yimbéka maki. ");
INSERT INTO wos_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Man haraki yandé duré akwi di nawula du tempelré yate hura yi, yambumbu. Déka ayiwa déré héralén nukwambu dé déka man haraki ye wungi té. Téndéka di atéfék nukwa déré yate hura yi, tempelna wulayi gwande yambumbu takanjoka. Wun yambuna xi angi dé, “Yikafre yambu dé.” Di yate hura yindaka dé wun yambumbu reta dé tempelré wulayikwa du takwaka yéwaka wakwexéké, déka hwendate. ");
INSERT INTO wos_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Pita bér Jon akwi wara wulayinjoka yambéka dé wun man haraki yandé du bérré xétaka dé bérka wakwexéké, bér déka yéwa hwembéte. ");
INSERT INTO wos_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Wandéka Pita bér Jon dama xéféke hambukmbu xe dé Pita wa, “Méni mé yakite xé, aniré.” ");
INSERT INTO wos_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Wungi wandéka dé bérré xéséfu. Xéséfwa xe dé wa déka mawulimbu, “Wafewana yéwa nawulak wuniré hwetambér wana?” ");
INSERT INTO wos_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Wungi wandéka dé Pita déré wa, “Wuni yéwa yingafwe. Hura téwuka joo male méniré hwetawuni. Nasaretna du Jisas Kraisna ximbu wuni méniré we: Méni sé raama féta yi.” ");
INSERT INTO wos_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Wungi wataka dé déka yika tambambu hura dé husaraméndéka dé déka man wali déka wulanyima wali bari hambuk yandéka dé yikafre ya. ");
INSERT INTO wos_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Wun du yikafre ye dé wuréféka xale xayitéka te dé, wungi féta yi. Féta ye dé bér wali tempelré wulayi. Wulaaye dé mawuli sawuli yata dé wuréféka gweréfékéta dé Godna ximbu haréké. ");
INSERT INTO wos_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Atéfék du takwa di xé, wun du wungi féta yita Godna ximbu harékéndéka. ");
INSERT INTO wos_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Xéta di déka xékélaki. Dé yéwa héranjoka wata tempelré wulayindaka yikafre yambumbu rendé du dé. Dé wungi yikafre yandéka xéta di waréngéné. Waréngénéta saréké waréké xékéta di wa, “Owa. Wun man haraki yandé du némbuli yikafre dé ya.” Wungi di wa déka. ");
INSERT INTO wos_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Wun du Pita bér Jonré hulukindéka atéfék du takwa hundi xékéta waréngéna di di téndanré di fétékéré yi. Ye di di wali hérangwanda té, gena tafékambu. Wun tafékana xi angi dé, Solomonéna taféka dé. ");
INSERT INTO wos_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Hérangwanda téndaka dé Pita diré xéta dé wa, “Gunawa, israelna du, métaka guni wun jooré xe waréngéna guni aniré wungi xéséfu? Guni angi guni saréké ani hafu ani wun hambuk jémba ya. Ani Godna makambu yikafre te wanaka dé ané du féta yi. Wungi sarékékénguni. Wun ana jémba yingafwe. ");
INSERT INTO wos_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Abrahamna néma du, Aisakna néma du, Jekopna néma du, nana atéfék mandékana néma du God dé wandéka déka jémba yakwa du Jisas dé néma du re. Guni Jisasré guni hwe, guna néma duka. Hwenguka di Jisasré haraki sémbut hurundate dé néma du Pailat hélék dé ya. Jisas baka téndéte dé Pailat mawuli ya. Mawuli yandéka guni Pailat rendénmbu téta guni Jisaska guni hu hwe. ");
INSERT INTO wos_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Jisas haraki saraki sémbut huruhambandé. Yikafre sémbut huruta Godna hundi xékékwa du dé. Guni déka hu hweta guni Pailatré wa, ‘Méni Jisasré yamba takamét yikéndé. Du nakré xiyandé duré mé takamét yindé.’ ");
INSERT INTO wos_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Wungi wataka guni du takwa jémba resékendate huli hamwinya hwekwa duré guni xiyanguka dé hiya. Hiyandéka God wandéka dé Jisas wambula ramé. Raméndéka ani wundé xéna. ");
INSERT INTO wos_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Jisasna hambukmbu dé wun man haraki yandé du yikafre ya. Wun hambuk wu Jisasna hambuk dé. Ana hambuk yingafwe. Ani Jisaska jémba sarékénaka dé déka hambuk aniré hwendéka ani déka ximbu wanaka dé wun du yikafre ye dé yikafre male té. Yikafre téndéka guni téta xéta guni xékélaki. Ani Jisaska jémba sarékénaka dé Jisas hafu dé wun jémba ya. ");
INSERT INTO wos_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","”Wuna nyama bandi, guni mé xéké. Guni guna néma du wali guni Jisaska jémba xékélakihafi ye guni déré xiyanguka dé hiya. Wungi wuni xékélaki. ");
INSERT INTO wos_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Hanja God wandéka atéfék profet di wa, God wasékendén du Krais hangéli hératendékaka. Wandaka God wandén maki dé Jisas hangéli héra. ");
INSERT INTO wos_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Guni guna haraki saraki sémbut mé yatakataka Godna hundi xékéngut, God guna haraki saraki sémbut hérekitandé. Hérekitaka dé Néma Du God gunika hambuk hweta guni wali téndét, guna mawuli jémba tétandé. ");
INSERT INTO wos_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Téndét God wandét Jisas Krais wambula yatandé. Hanja God dé Jisasré waséke, dé guniré yikafre hurundéte. ");
INSERT INTO wos_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Némbuli Jisas Godna getéfambu dé re. Hanja God atéfék jondu huratakandéka dé atéfék jondu yikafre male dé té. Te dé wun jondu haraki ya. Wun jondu wambula yikafre téndéte God wandét, Jisas wambula yatandé. Hanja God wandéka di déka profet déka hundi xéka di wambula yikafre tétendékaka wa. ");
INSERT INTO wos_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","”Hanja nana mandéka Moses dé wa, ‘Guna Néma Du God wandéka wuni déka profet wuni xaku. God wuniré wandén maki hukémbu wambula wandét guna hémémbu du nak xakutandé. Xakundét guni déka hundi atéfékéka jémba xékétanguni. ");
INSERT INTO wos_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Wun profetna hundi xékéhafi yakwa du takwaré God xiyae haraki hurutandé. Di israelna du takwa wali yamba rekéndi.’ ");
INSERT INTO wos_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Wungi Moses wandéka dé Godna profet Samuel dé ané nukwambu xakundé jooka dé hayi. Samuelna hukémbu yandé profet atéfék akwi di ané nukwambu xakundé jooka di hayi. ");
INSERT INTO wos_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","”Guni God déka profetré wandén hundi akwi, guna mandékanguré wasékérékéndén hundi akwi némbule wundé hérangu. Hanja God guna mandéka Abrahamré dé wa, ‘Wuni ména mandékambu atéfék héfambu rekwa du takwaré yikafre hurutawuni.’ ");
INSERT INTO wos_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Wungi wataka God hukémbu wandéka dé déka jémba yakwa du Jisas tale dé gunika ya, guniré yikafre hurunjoka. Yikafre hurundét guni guna haraki saraki sémbut nak nak yatakatanguni.” Wungi dé Pita wa. ");
INSERT INTO wos_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Pita bér Jon du takwaka wata témbéka di pris, tempelka hatikwa duna néma du, Sadyusina du yae di bér témbénmbu xaku. ");
INSERT INTO wos_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Tale di xéké bér angi wambéka, “Jisas hiyae wambula wundé raméndé. Raméndén maki, hiyandé du takwa ramétandi.” Wungi wambéka xékétaka di bérka hundika hélék yata mawuli wita yae di bér témbénmbu xaku. ");
INSERT INTO wos_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Xakundaka nukwa nandindéka di bérré huluke di hura yi séndé geré. Hura ye di wa, “Séri bérka hundi xékétame, némbuli gan dé.” Wungi di wa. ");
INSERT INTO wos_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Wandaka bér tale tempelmbu téta bér hundi wambéka di séfélak du takwa xéké. Bérka hundi xékétaka di Jisaska jémba saréké. Wun nukwa di 5,000 du takwa di Jisaska jémba saréké. ");
INSERT INTO wos_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Gan hwae ganémbambu di israelna néma du, deka néma du akwi, xékélelakikwa du akwi, wungi di Jerusalemémbu hérangwandé, hundi bulénjoka. ");
INSERT INTO wos_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Hérangwandéndaka dé prisna néma du Anas dé wumbu re. Kaiafas akwi, Jon akwi, Aleksander akwi, atéfék prisna néma duna hémna du akwi wungi di hundi bulénjoka hérangwanda re. ");
INSERT INTO wos_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Reta di Pita, Jon, man haraki ye yikafre yandé duré akwi séndé gembu hura yandaka di deka makambu té. Téndaka di Pita bér Jonré wakwexéké, “Méta yambéka dé wun man haraki yandé du yikafre ya? Yingi maki béni wun hambuk jémba ya? Héna ximbu wambéka dé wun du yikafre ya?” ");
INSERT INTO wos_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Di wungi wakwexékéndaka dé Godna Hamwinya Pitana mawulimbu hambuk ye téndéka dé Pita wa, “Gunawa, israelna néma du, atéfék néma du, ");
INSERT INTO wos_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","némbuli guni aniré wakwexéké, ané man haraki yandé du yikafre yandénka. Aniré guni wakwexéké, yikafre jémba yananka. ");
INSERT INTO wos_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","Guni mé xéké. Guniré némbuli wuni we. Wawut guni akwi israelna atéfék du takwa akwi xékéta xékélakitanguni. Nasaretna du Jisas Kraisna hambuk hwendéka ani déka ximbu wanaka dé ané man haraki yandé du dé yikafre ya. Yikafre ye némbuli dé ané du guna makambu dé té. Guni Jisasré xiyae mimbu hatekanguka dé hiya. Hiyandéka God wandéka dé wambula wundé raméndé. ");
INSERT INTO wos_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Jisaska ané hundi Godna nyingambu dé re: Ge tokwa du di motu nakéka hélék yata di wun motu yaki. Yakindaka nak dé wun motu hérae takandéka dé ge jémba té. ");
INSERT INTO wos_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Wungi rendéka némbuli guniré wuni we déka. Dé hafu dé naniré yikafre hurundét, nani huli mawuli hérae jémba reséketame. Jisas dé hafu naniré wungi yikafre hurutandé. Nak du yingafwe.” ");
INSERT INTO wos_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Pita wungi wandéka di néma du xékétaka di waréngéné. Waréngénéta di wa, “Owa. Wun du yéték roohafi téta bér naniré hundi wa. Bér xékélakikwa du yingafwe. Nana xékélelakikwa du bérré wakwehambandi, nyinga hayimbéte.” Wungi wataka di xékélaki. Bér Jisas wali yitaka yatakandé du bér. ");
INSERT INTO wos_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Xékélakita di xé man haraki yandé du yikafre ye Pita bér Jon wali téndéka. Xéta di bérka hundi hasa wanjoka di hurufatiké. ");
INSERT INTO wos_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Wahafi yata di bérré wa, hafwaré gwandimbéte. Wandaka gwandimbéka di di hafu bulé. ");
INSERT INTO wos_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","Buléta di wa, “Bérré méta yatame? Bér yikafre male hambuk jémba bér ya. Yambéka wun du yikafre yandéka di Jerusalemémbu rekwa atéfék du takwa di xékélaki. Nani yamba wakéme, “Bér wun jémba yahambambér.” Wungi yamba wakéme. ");
INSERT INTO wos_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Du takwa nawulak akwi wun jooka xékéndamboka hélék nani ye. Hélék yata nani bérré hambukmbu watame, Jisasna ximbu wambula wahafi yambéte.” ");
INSERT INTO wos_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Wungi wataka di wandaka bér wambula wulayi. Wambula wulayimbéka di wa, “Béni mé xéké. Jisasna ximbu wambula wakémbéni. Du takwaré Jisaska yamba wakwekémbéni.” ");
INSERT INTO wos_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Di wungi wandaka bér Pita bér Jon wa, “God dé aniré wa, atéfék du takwaré déka hundi wanate. Guni aniré guni watéfi, wun hundi wahafi yanate. Némbuli guni mé wa aniré. God yingika dé mawuli ye? Yingi maki yikafre joo yataani? Guna hundi xékétaani, o Godna hundi xékétaani? ");
INSERT INTO wos_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Ani angi yataani. Jisas yandé jémbaré xétaka ani wun jémbaka wataani. Jisas wandéka xékénan hundika wataani. Wungi male wataani. Ani nakélak yamba rekéani.” ");
INSERT INTO wos_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Bér wungi wambéka di néma du bérré hambukmbu wata di wa, “Mé xéké. Hundi yamba wakéméni, Jisaska. Nana hundi xékéta baka tétambéni.” Wungi di wa. Wun hundi wata di bérré xiyanjoka di roo, du takwaka. Man haraki yandé du yikafre yandénka di atéfék du takwa Godna ximbu di haréké. Harékéndaka di néma du Pita bér Jonré xiyanjoka roo wandaka bér baka yi. ");
INSERT INTO wos_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Wun man haraki yandé du dumi yétiyéti nawulak héki hwari akwi rendéka bér Jisasna ximbu wambéka dé yikafre ya. ");
INSERT INTO wos_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Pita bér Jon bér Jisasna hundi xékékwa du takwaka bari wambula yi. Wambula ye bér prisna néma du israelna néma du bérré wandan atéfék haraki hundika bér safé, diré. ");
INSERT INTO wos_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Wambéka di du takwa xékétaka natafa mawuli héraata di angi Godré wa: “Méni nana Néma Du méni. Hanja tale méni atéfék jondu méni hurataka. Nyir, héfa, gu, méni hurataka. Wumbu rekwa atéfék jondu akwi méni hurataka. ");
INSERT INTO wos_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Hanja méni waméka ména Hamwinya dé nana mandéka Devitré wa. Wandéka dé ména jémba yandé du Devit dé ména nyingambu angi hayi: Métaka di nak téfana du di rékambambu we? Métaka di nana du deka mawuli haraki yandéka di Néma Du wasékendén duré xiyanjoka hundi bulé? ");
INSERT INTO wos_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Néma Du déka wasékendén du wali, bér wali warenjoka di atéfék héfambu rekwa néma du di hérangwanda té. ");
INSERT INTO wos_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","”Devit wungi hayindéka déka hundi mwi hundi dé ya. Néma du Herot bér pontius Pailat bér nak téfana du israelna du akwi bér di wali hérangwanda ané getéfambu té. Di ména yikafre jémba yakwa du Jisasré xiyanjoka di hérangwanda hundi bulé. Hanja méni Jisasré waséke, ména jémba yandéte. ");
INSERT INTO wos_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Wunde du hundi bulétaka di haraki saraki sémbut di huru, Jisasré. Hanja méni hambuk ye mawuli yata méni wa, di wun sémbut hurutendakaka. Talembu xe méni wa, hukémbu di wungi hurundate. ");
INSERT INTO wos_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Néma Du, némbuli wandan haraki hundika sarékéta nanika hambuk mé hwe, nani ména jémba yakwa du takwa dika roohafi yata, ména yikafre hundi jémba wambete. ");
INSERT INTO wos_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Méni hambuk hwemét di bar hiyaakwa du takwa yikafre yatandi. Méni wamét ména yikafre jémba yakwa du Jisas hambuk naniré hwendét, nani déka ximbu wata nak maki nak maki hanja xéhafi yandan hambuk jémba yatame.” Wungi di Godré wakwexéké. ");
INSERT INTO wos_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Wakwexékéndaka dé wun hundi buléta téndan ge huséngéné. Huséngénéndéka Godna Hamwinya deka mawulimbu sukweka téndéka di atéfék, néma duka roohafi yata di Godna hundi wa. ");
INSERT INTO wos_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Jisasna hundi xékékwa du takwa di natafa mawuli héra. Héraata di deka jonduka wa, “Ané jondu atéfék duna jondu dé. Wun nana baté jondu yingafwe.” Wungi wataka di deka jondu mune hweta di atéfék wun jondu taka. ");
INSERT INTO wos_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Séfélak nukwa Jisasna aposel di hambukmbu di wa, “Néma Du Jisas hiyae wundé raméndé. Wu mwi hundi dé.” Wungi wa saafa yindaka dé God Jisasna du takwa atéfékré némafwimbu yikafre huru. ");
INSERT INTO wos_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Yikafre hurundéka di atéfék jémba di re. Jambangwe du yingafwe. Du nawulak deka ge héfa hwetaka yéwa hérae di aposelka wun yéwa hwe, di mune hwendate. ");
INSERT INTO wos_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","Hwendaka di aposel yéwa mune hwe, jonduhafi rendé du takwaka. Wungi huruta di atéfék jémba di re. ");
INSERT INTO wos_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","37","Du nak déka xi josep dé akwi wungi huruta déka héfa hwetaka yéwa hérae dé wun yéwa Jisasna duka hwe, di mune hwendate. Dé Livaina hémémbu yandé du dé. Saiprusna héfambu dé ya. Jisasna du di déka huli xi hwe, Barnabas. Wun deka hundimbu wandaka maki dé. Wun xina mo hundi angi dé: “Deka mawuliré yikafre hurukwa du dé.” ");
INSERT INTO wos_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Du nak déka xi Ananaias dé déka takwa Safaira wali bér re. Bér bérka héfa hwetaka bér yéwa nawulak héra. ");
INSERT INTO wos_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Hérae dé wun yéwa nawulak hura reta dé nawulak hura ye dé Jisasna aposelré wa, “Wuna héfa hwetaka wuni ané yéwa héra. Hérae némbuli atéfék yéwa gunika andé hwewi.” Wungi wataka hura yae yéna yata dé hérandén yéwa nawulak dika hwe, mune hwendate. Hérandén yéwa atéfék hwehambandé. Hwendéka lé déka takwa akwi lé xékélaki, wun yéwaka. ");
INSERT INTO wos_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Ananaias wun yéwa hwendéka dé Pita déré wa, “Yinga maki naméka satan ména mawulimbu wulaaye téndéka méni ména héfa hwetaka héramén yéwa nawulak méni faku? Fakutaka méni wa, ‘Wuni hérawun yéwa atéfék wuni hwe.’ Wungi wata méni Godna Hamwinyaka méni yéna ye. Métaka méni wungi we? ");
INSERT INTO wos_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Tale méni wun héfa hwehafi yaméka wun héfa ména ximbu dé re. Méni wun héfa hwetaka yéwa héramén wu ména yéwa dé. Métaka we méni wungi hurunjoka méni saréké. Wungi huruta méni duka male yéna yahambaméni. Méni Godka akwi méni yéna ya. Wungi haraki sémbut méni huru.” ");
INSERT INTO wos_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Wungi wandéka dé Ananaias xékétaka dé bari xakre dé wungi hiya. Hiyandéka xékéndé du takwa atéfék di roo. ");
INSERT INTO wos_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Wayikana du nawulak yae di Ananaiasna fusa nukwa wur samétaka hérae hura ye di wekwambu rémé. ");
INSERT INTO wos_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Hukémbu lé Ananaiasna takwa gwande. Gwande léka du hiyandénka xékélakihambalé. ");
INSERT INTO wos_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Xékéhafi yaléka dé Pita léré wakwexéké, “Nyéna du wali héfa hwetaka hérambén yéwa atéfék béni nanika hwe, o yingafwe? Wuniré mé wa.” Wungi wakwexékéndéka lé wa, “Xéxé. Wu mwi hundi dé. Wun yéwa atéfék ani wundé hwena.” Wungi wata lé yéna ya. ");
INSERT INTO wos_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Yéna yaléka dé Pita wa, “Nyéna du wali béni béna mawulimbu béni wa, ‘Ani nawulak yéwa fakutaani, Néma Duna Hamwinya yamba xékélakikéndé.’ Wungi wataka déka yéna béni ya. Wungi haraki saraki sémbut béni huru. Mé xéké. Nyéna duré réméndé du fétémbu di té. Nyéniré akwi hura yitandi.” ");
INSERT INTO wos_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Wungi wandéka lé bari téndénmbu xakre lé wungi hiya. Hiyaléka di wayikana du gwande yae di léré xétaka hérae hura ye di léka du wali sékéré rémé. ");
INSERT INTO wos_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Jisasna hundi xékékwa du takwa akwi wun hundi xékéndé du takwa atéfék akwi di némafwimbu roo. ");
INSERT INTO wos_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Jisasna aposel di séfélak nak maki hanja xéhafi yandan hambuk jémba yandaka di du takwa xé. Séfélak nukwa Jisasna hundi xékékwa du takwa atéfék di tempelré wulaaye hérangwanda di Solomonéna tafékambu té. ");
INSERT INTO wos_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Téndaka di atéfék du takwa diré xéta di wa, “Wunde du takwa yikafre di.” Wungi wata Jisaska jémba sarékéhafi yakwa du takwa di di wali yitaka yatakanjoka di roo. ");
INSERT INTO wos_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Séfélak du takwa roohafi yata di akwi Néma Du Jisaska jémba di saréké. Sarékéta di séfélak séfélak du takwa akwi Jisasna hundi xéké. ");
INSERT INTO wos_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Jisasna aposel séfélak nak maki hambuk jémba yandaka di bar hiyaakwa du takwaré jambémbu take di yate hura yi. Yate hura ye di diré yambumbu taka. Takata angi di wa, “Wafewana Pita wandét di yikafre yatandi wana? Wahafi yata yambumbu yindét wafewana déka haki bar hiyaakwa duré hérandét di yikafre yatandi?” Wungi di saréké. ");
INSERT INTO wos_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Atéfék Jerusalem walémbambu rekwa getéfambu séfélak du takwa di yi Jerusalemré. Ye di bar hiyaakwa du takwa, haraki hamwinya hura téndé du takwaré akwi di hérae hura yi. Wungi hurundaka di Jisasna aposel wandaka di atéfék di yikafre ya. ");
INSERT INTO wos_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Jisasna aposel wungi hurundaka dé atéfék prisna néma du déka du wali hélék di ya. Wunde du di Sadyusina du di. Hélék yata haraki mawuli xékéta di hundi bulé. ");
INSERT INTO wos_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Hundi bulétaka wandaka di Jisasna aposelré huluke di hura yi séndé geré. Hura yindaka di wumbu re. ");
INSERT INTO wos_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Gan hunyindéka dé Néma Duna ensel nak dé gaya. Gaye dé séndé gena yambu nafwe dé Jisasna aposelré hura gwande yi hafwaré. ");
INSERT INTO wos_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","Hura gwande dé diré wa, “Guni ye guni tempelré wulayitanguni. Wulaaye guni guni huli mawuli hérae jémba reséketendaka atéfék hundika du takwaré watanguni.” ");
INSERT INTO wos_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Wungi wandéka di Jisasna aposel xékétaka ganémbambu di tempelré wulaaye di du takwaré Godna hundi wa. Wun jooka xékélakihafi yata, atéfék prisna néma du déka du wali wandaka di deka getéfana du, israelna néma du atéfék, wungi di ya. Yae hérangwanda di atéfék di hundi bulé. Bulétaka, di gélinduré wa, di séndé geré ye Jisasna aposelré dika hura yandate. ");
INSERT INTO wos_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Wandaka di deka du ye séndé gembu xaakwa di Jisasna aposelka hwakéfatiké. ");
INSERT INTO wos_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","Hwakéfatika wambula yae di wa, “Nani séndé gembu xaakwa nani xé gena yambu jémba téfindaka séndé geka hatikwa du jémba téndaka. Xétaka gena yambu nafwitaka nani wunde duka hwakéfatiké.” ");
INSERT INTO wos_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Di wungi wandaka dé tempelna gélinduna néma du, prisna néma du wali di xékétaka di Jisasna du yindanka di saréké waréké xéké. ");
INSERT INTO wos_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Sarékéta rendaka dé du nak wulaaye dé diré wa, “Mé xéké. Nalika wanguka di du nawulak di séndé gembu re. Wunde du némbuli di tempelmbu téta di hundi andé we, du takwaka.” ");
INSERT INTO wos_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Wungi wandéka di néma geka hatikwa du deka néma du wali di Jisasna aposelka yi. Ye xaakwa di wumbu tékwa du diré rékambambu wata diré motumbu xiyandamboka di roo. Roota di Jisasna aposelré di nakélak hura yi. Hambukmbu diré hundi wahambandi. ");
INSERT INTO wos_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Diré hura ye wandaka di Jisasna aposel néma duna makambu di wambula té. Téndaka dé atéfék prisna néma du diré wa, ");
INSERT INTO wos_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","”Nani gunika hambukmbu nani watéfi, guni wun duna ximbu wakwengumboka. Guni nana hundi xékéhambanguni. Guni wun duka hundi guni we, Jerusalemémbu rekwa atéfék du takwaré. Nani déré xiyambeka hiyandénka guni we.” ");
INSERT INTO wos_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Wungi wandéka dé Pita wali, Jisasna nawulak du wali di wa, “Nani Godna hundi male xékétame. Nani héfambu rekwa duna hundi yamba xékékéme. ");
INSERT INTO wos_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Hanja guni Jisasré mimbu xiyae hatekanguka dé hiya. Hiyandéka nana mandékana Néma Du God déré dé husaramé. ");
INSERT INTO wos_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Husaraméndéka dé Jisas Godna yika tambambu reta Néma Du re, nani atéfék israel, nana haraki saraki mawuli yatakambet, God nana haraki saraki mawuli yakwanyindéte. ");
INSERT INTO wos_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","God wandéka Jisas wungi yandéka nani atéfék xétaka nani wun jooka hundi we. Godna Hamwinya akwi dé wun hundi we. God dé déka Hamwinya hwe, déka hundi xékékwa du takwaka.” Wungi di wa. ");
INSERT INTO wos_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Wandaka di néma du xékétaka di rékambambu wata di diré xiyanjoka di huru. ");
INSERT INTO wos_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Xiyanjoka hurundaka dé néma du nak déka xi Gamaliel dé té. Dé Farisina du reta dé deka hambuk hundika wakwe sakwe séfélak duré. Dé atéfék du takwana makambu yikafre du dé re. Gamaliel téta wandéka di Jisasna aposelré hura gwandi hafwaré. ");
INSERT INTO wos_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Hura gwandindaka dé Gamaliel néma duré wa, “Guni, nana getéfana du, israel, guni mé jémba saréké. Wunde duré méta yatanguni? ");
INSERT INTO wos_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Hanja du nak déka xi Teudas yae dé wa, ‘Wuni néma du wuni. Guni wuna hukémbu mé guni ya.’ Wungi wandéka di 400 maki du di déka hukémbu yi. Yindaka hukémbu di déré xiyandaka di déka du yaange yi atéfék getéfaré. Yindaka déka jémba yambumbu yihambandé, baka dé xakri. ");
INSERT INTO wos_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Hukémbu gavman di atéfék du takwana xi hayindaka dé nak du déka xi Judas Galilina héfambu dé ya. Yandéka di séfélak du déka hundi xéké. Xékéta di déka jémbambu wulayi. Wulayindaka hukémbu du nawulak di déré xiya. Xiyandaka hiyandéka di déka du di yaange yi atéfék getéfaré. ");
INSERT INTO wos_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Némbuli Jisasna duka guniré watawuni. Wunde duré yamba xiyakénguni. Mé takangut yinda! Di héfambu rekwa duna hundi male xékéta déka jémba yandat, deka jémba baka xakritandé. ");
INSERT INTO wos_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Di Godna hundi xékéta déka jémba yandat, deka jémba reséketandé. Resékendét guni di wali waru diré yamba sarékéngwandékénguni. Wafewana guni God wali warutanguni?” Wungi wandéka di néma du Gamalielna hundi xéké. ");
INSERT INTO wos_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Néma du déka hundi xékétaka wandaka di Jisasna aposelré wambula hura xale. Hura xalendaka wandaka di deka séfimbu témbéré, rami yoombu. Témbéréta di néma du diré wa, “Jisaska wambula yamba wakénguni. Wun duna ximbu wakénguni. Némbuli guni yitanguni.” ");
INSERT INTO wos_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Wungi wandaka di Jisasna aposel wun ge yatakataka di wungi yi. Ye di wa, “God nani Jisasna jémba yambekaka yikafre mawuli yata dé wa, wunde du naniré xiyandat, nani hangéli héraata Jisasna ximbu harékémbete. Wu yikafre dé.” Wungi wataka yandan jooka di mawuli ya. ");
INSERT INTO wos_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Atéfék nukwambu di tempelmbu akwi, du takwana gembu akwi di Godna hundi wambula wa. Wata di wa, “Jisas wu God wasékendén du Krais dé.” Wungi wata di wun jémba yatakahambandi. ");
INSERT INTO wos_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Wun nukwambu séfélak du takwa akwi di Jisaska jémba saréké. Jisaska jémba sarékékwa du nawulak di Grikna hundi xéké. Nawulak di Hibruna hundi xéké. Nak nukwa di Grikna hundi xékékwa Judana du di Hibruna hundi xékékwa Judana du wali di waru. Waruta di Grikna hundi xékékwa du di wa, “Atéfék nukwa guni nawulak jondu male guni mune hwe, nana getéfana du hiyandé takwaka. Guna du hiyandé takwaka guni séfélak jondu mune hwe. Nani wungina sémbutka hélék nani ye.” ");
INSERT INTO wos_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Wungi wandaka di aposel tamba yéti angé man yéték wandaka di Jisasna hundi xékékwa du takwa atéfék di hérangwandé. Hérangwandéndaka di wa, “Mé xéké. Nani Godna hundi wambeka jémba yatakataka hénoo mune hwembet, wungi haraki dé. Jondu mune hwe jémba nana jémba yingafwe. ");
INSERT INTO wos_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Nyama bandi, wungi maki guni wali rekwa du angé tamba yétiyéti angé tamba hufukéka hwakétanguni, jondu mune hwendate. Di xékélakikwa du di. Godna Hamwinya deka mawulimbu hambuk ye tékwa du di. Guni hwaka xétaka wunde duna xi wangut nani diré watame, di wun jémba yandate. ");
INSERT INTO wos_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Di wun jémba yandat, nani God wali hundi buléta Godna hundi wakwetame. Wu nana jémba dé.” ");
INSERT INTO wos_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Di wungi wandaka di atéfék du takwa xékétaka di deka hundika mawuli ya. Mawuli yata di ande duré wa, di jondu mune hwendate: Stiven. Dé Jisaska hambukmbu jémba saréké. Déka mawulimbu Godna Hamwinya hambuk ye dé té. Filip, Prokorus, Nikanor, Timon, Pamenas. Nikolas. Dé nak téfana du reta dé Judana hambuk hundi xékéta dé deka sémbut huru. Dé Antiokmbu dé ya. ");
INSERT INTO wos_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Wunde duna xi wandaka di wunde du angé tamba yétiyéti angé tamba hufuk Jisasna aposelna makambu té. Téndaka di Jisasna du deka anéngambambu nak nak tamba takata di Godka wa, di jondu jémba mune hwendate. ");
INSERT INTO wos_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Wataka di Jisasna aposel di Godna hundi wa saafa yi. Wa saafa yindaka di Jerusalemémbu rekwa séfélak du takwa deka hundika xéka di Jisaska jémba saréké. Sarékéndaka di Jisasna du takwa di séfélak xaku. Séfélak pris akwi di Jisaska jémba saréké. ");
INSERT INTO wos_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","God wun du Stivenré némafwimbu yikafre huruta hambuk hwendéka dé Stiven dé séfélak nak maki hanja xéhafi yandan hambuk jémba dé ya. Yandéka du takwa déka jémbaré xéta di waréngéné. ");
INSERT INTO wos_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Waréngénéndaka di Judana du nawulak di Stivenka hélék ye di mama wa. Wunde du di Godna hundi buléndaka ge nakmbu di ya. Wun gena xi angi dé, “Dé dé hafuka jémba yakwa duna ge dé.” Wunde du di Sairinina héfambu, Aleksandriana héfambu, Silisiana héfambu, Esiana héfambu akwi yae di Jerusalemémbu re. Wunde du atéfék di Stivenka hélék yata di dé wali waru. ");
INSERT INTO wos_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Warundaka dé Godna Hamwinya hambuk hwendéka dé Stiven jémba xékélakita dé diré wa. Wandéka di déka hundi hasa wanjoka di hurufatiké. ");
INSERT INTO wos_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Hurufatikéta di yéna yakwa duka nakélak hwaké. Hwaka xétaka di dika yéwa hwe, yénataka hundi wandate. Hwendaka wun yéna yakwa du di wa, “Wun du Stiven dé nana mandéka Moseska wali, Godka wali dé haraki hundi wa. Haraki hundi wandéka nani xéké.” ");
INSERT INTO wos_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Di wungi wata yéna yandaka di du takwa wali, getéfana du wali, xékélelakikwa du akwi wungi xékéta di rékambambu wata Stivenka ye di déré témbéra hura yi, néma du reta hundi buléndaka geré. ");
INSERT INTO wos_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Hura yindaka Stiven néma duna makambu téndéka wandaka di yéna yakwa du nawulak di wulayi, wun geré. Wulaaye di wa, “Wun du atéfék nukwambu dé Godna tempelka dé haraki hundi wata dé Mosesna hambuk hundika akwi haraki hundi wa. ");
INSERT INTO wos_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Angi dé wa, ‘Nasaretna du Jisas tempelré haraki hurutandé. Haraki hurutaka dé Moses hwendén sémbut yatakataka huli sémbut hérambete dé naniré wa.’ Wungi Stiven wandéka nani xéké.” Wungi di yéna ya. ");
INSERT INTO wos_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Yéna yandaka di atéfék néma du Stivenré xéséfwa xe di xé déka saawi enselna saawi maki xakundéka. ");
INSERT INTO wos_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Atéfék prisna néma du dé Stivenré wakwexéké, “Deka hundi mwi hundi wana yingafwe wana?” ");
INSERT INTO wos_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","3","Dé wungi wakwexékéndéka dé Stiven angi wa, “Yafa, nyama, bandi, wuna hundi mé xéké. Hanja nana mandéka Abraham Mesopotemiana héfambu rendéka dé hambuk yakwa Néma Du God déka yae dé déré wa, ‘Ména hém ména héfa yatakataka méniré wakwetewuka héfaré yitaméni.’ Wungi wandéka dé Abraham Haranré yi. ");
INSERT INTO wos_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Abraham wungi Kaldiana héfa yatakataka ye dé Haranmbu rendéka déka yafa wumbu hiyandéka God wandéka dé Abraham némbuli ané rembeka héfaré dé ya. ");
INSERT INTO wos_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","”Abraham ané héfaré yandéka dé God déka héfa hwehambandé, wun nukwambu. Wun nukwa Abraham nyan hérahafi yandéka dé God déré wa, ‘Hukémbu wuni ané héfa hwetawuni ménika. Hwewut méni ména mandéka guni yafa yatanguni, ané héfaka. Mwi hundi wuni we.’ Wungi dé God wa. ");
INSERT INTO wos_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","God ané hundi akwi dé Abrahamré wa: ‘Ména mandéka nak héfambu retandi. Rendat wun héfana du hambuk yata diré haraki huruta watandi, ména mandéka deka némafwi jémba baka yandate. Yéwa yamba hérakéndi. Séfélak séfélak (400) héki hwari reta wun jémba male yatandi. ");
INSERT INTO wos_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Yandat hukémbu wuni wun némafwi jémba dika hwendé duré hasa hwewut, di némafwi hangéli hératandi. Némafwi hangéli hérandat, di ména mandéka wun héfa yatakataka di yae ané héfambu reta wuna ximbu harékétandi.’ ");
INSERT INTO wos_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Wungi wataka dé God Abrahamré wa, ‘Méni wuna mwi hundi sarékéta méni ména du wali guna séfi sékétanguni.’ Wungi God wandéka dé Abraham xékétaka wungi huruta déka nyan Aisak hérae dé déka séfi akwi dé séké. Aisak angé yétiyéti angé yétiyéti nukwa rendéka dé déka yafa déka séfi séké. Hukémbu dé Aisak Jekopna yafa xaku. Xakundéka Jekop dé tamba yéti angé man yéték duna yafa xaku. Wungi xakundéka di nana mandékangu di re. ");
INSERT INTO wos_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","”Jekopna nyambali deka bandi josepka haraki mawuli xékéta di déré nawulak duka hwetaka di yéwa héra. Hérandaka di wunde du di josepré hura yi, Isipré. Hura yindaka josep wun héfambu rendéka dé God dé wali té wungi té wungi té. ");
INSERT INTO wos_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","Téta dé déré yikafre huruta wandéka hukémbu atéfék haraki saraki joo déka yahambandé. God josepré yikafre huruta yikafre xékélelaki hwendéka dé josep yikafre hundi wa. Wandéka xékétaka dé Isipna néma du Fero déré xéta josepka mawuli yata dé wa, josep néma du reta dé Isipna héfaka akwi Ferona geka akwi dé hati. ");
INSERT INTO wos_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","”Hukémbu dé hénooka hiyatendaka nukwa dé xaku, kenanéna héfambu Isipna héfambu akwi. Xakundéka di séfélak du takwa di hénooka hiya. Hiyae di nana mandéka akwi hénooka hwakéfatiké. ");
INSERT INTO wos_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Hwakéfatika Jekop dé xéké, hénoo Isipmbu rendéka. Xékétaka dé déka nyambali nana mandékaré wandéka di tale wun héfaré yi. ");
INSERT INTO wos_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Hukémbu di wambula Isipré yi. Ye xaakwa josepka xékélakihafi yandaka dé josep diré wa, ‘Guni wuna nyama bandi guni. Wuni josep wuni.’ Wungi wandéka di déka xékélaki. Xékélakindaka dé Fero hundi xéké josepna hémka. ");
INSERT INTO wos_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Xékétaka wandéka dé josep déka nyama bandiré wa, ‘Guni ye wuna yafa Jekop déka hémré akwi watanguni, Isipré yandate.’ ");
INSERT INTO wos_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Wungi wandéka ye déka hundi wandaka dé Jekop déka hém atéfék wungi di Isipré yi. Séfélak (75) du takwa di yi. Hukémbu Jekop, déka nyambali nana mandéka akwi, di Isipmbu hiya. ");
INSERT INTO wos_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Hiyandaka di deka fusa hura yi Sekemna héfaré. Hura ye di diré Abrahamna wekwambu rémé. Hanja deka mandéka Abraham dé yéwa hwe, Hamorna hémka. Hwetaka dé wun wekwa téndé héfa héra.” ");
INSERT INTO wos_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","”God hanja Abrahamré wasékérékéndénéngala hurutendéka nukwa walémbambu téndéka israelna du takwa nana mandéka némafwi hém di xaku, Isipmbu. ");
INSERT INTO wos_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Xakundaka dé nak néma du Fero dé re Isipmbu. Dé josep akwi déka jémbaka akwi xékélakihambandé. ");
INSERT INTO wos_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Wun néma du yéna yata dé nana mandékaré dé haraki huru. Huruta dé wa, di deka huli nyan hérae hafwambu takandat re hiyandate. ");
INSERT INTO wos_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Wun nukwa Mosesna ayiwa lé déré héra. Dé Godna makambu yikafre nyan dé. Héraléka dé déka yafana gekombu male dé munya sata re. Bafu hufuk rendéka lé roo lé déré hafwambu taka. ");
INSERT INTO wos_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Hafwambu takaléka rendéka lé Ferona takwanya déré xétaka hérae hura ye lé déré hati, léka nyan maki. ");
INSERT INTO wos_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Hatiléka di Isipna hambuk hundi di Mosesré wakwe sakwe. Wakwendaka dé xékélaki. Xékélakita hambuk hérae dé yikafre hundi wata dé hambuk jémba ya. ");
INSERT INTO wos_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","”Hukémbu Mosesna héki hwari dumi yétiyéti yandéka dé wa, ‘Wuni wuna nyama bandi israelna duka yitawuni, diré xénjoka.’ ");
INSERT INTO wos_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Wungi wataka ye dé xé, Isipna du nak israelna du nakré xiyandéka. Xéta dé déka hémna du wali téta dé wun haraki sémbut hasa hwenjoka dé Isipna duré xiyandéka dé hiya. ");
INSERT INTO wos_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Moses déka mawulimbu angi dé saréké, ‘Di wun duré xiyawukaka xékélake xékélakitandi, God wuniré dé waséke, wuni diré yikafre huruta ané héfa yatataka yimbete. Wungi xékélakitandi.’ Wungi sarékéndéka di wun jooka xékélakihambandi. ");
INSERT INTO wos_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Wun du hiyandéka nukwa nak yindéka dé Moses wambula yi, israelna duka. Ye dé xé israelna du yéték warembéka. Xétaka bér warehafi yata jémba rembéte dé mawuli ya. Mawuli yata dé bérré wa, ‘Bénawa. Béni nyama bandi béni. Métaka béni ware? Béni warekémbéni.’ ");
INSERT INTO wos_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Wungi wandéka dé warendé du nak Mosesré xasémekindéka dé Moses hu hu yi. Yindéka déré haraki hundi wata dé wakwexéké, ‘Héndé wa méni nana néma du reméte. Héndé wa nanika hatiméte? ");
INSERT INTO wos_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Wafewana wuniré xiyataméni, nalika Isipna duré xiyamén maki?’ ");
INSERT INTO wos_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Wungi wakwexékéndéka dé Moses xékétaka roo dé yaange yi. Yaange ye Isip yatakataka dé Midianmbu dé nak téfambu yandé du maki dé re. Wumbu re takwa hérae dé nyan yéték héra. ");
INSERT INTO wos_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","”Moses dumi yétiyéti héki hwari wumbu re dé nak nukwa Moses du rehafi hafwambu Sainai némbu tékwambu téta dé xé, Godna ensel nak gaye dé ya xérékékwa yikama mi ekombu téndéka. ");
INSERT INTO wos_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Xéta waréngéna dé saréké waréké xéké. Sarékéta dé jémba xe xékélakinjoka dé yi. Yindéka dé Néma Duna hundi dé xaku. ");
INSERT INTO wos_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","Néma Du dé déré wa, ‘Wuni ména mandékana God wuni. Wuni Abrahamna God, Aisakna God, Jekopna God wuni.’ Wungi wandéka xéka dé Moses généta xénjoka dé roo. ");
INSERT INTO wos_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Roondéka dé Néma Du wa, ‘Ména su mé futi. Téméka hafwa wuna héfa dé.’ ");
INSERT INTO wos_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Wungi wataka dé God wambula wa, ‘Wuni xé, wuna du takwa Isipmbu reta némafwi hangéli hérandaka. Wuni wundé xékéwu, némafwi hangéli héraata gérandaka. Xékétaka wuni gaya, diré hura gwandenjoka. Méni mé xéké. Méni wuna jémba yanjoka méni raama wambula yitaméni, Isipré.’ Wungi dé God wa. ");
INSERT INTO wos_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","”Tale israelna du di Moseska hu hweta di déré wakwexéké, ‘Héndé wa méni nana néma du reméte?’ Wungi wakwexékétaka hukémbu God dé hu hwendan du Mosesré dé wa, dé déka jémba yata deka néma du rendéte. Godna ensel gaye ya yanékwa yikama mimbu téndéka dé God Mosesré wa, dé deka néma du reta diré hura gwandendét di jémba rendate. ");
INSERT INTO wos_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Wandéka dé wumba du Moses nak maki nak maki hanja xéhafi yandan hambuk jémba yataka dé diré hura ye di Isip yatakataka di yi. Ye di Moses dé nawulak hambuk jémba akwi dé ya, Waka Xérimbu akwi du rehafi hafwambu akwi. Dé wun du rehafi hafwambu dumi yétiyéti héki hwari dé diré hura yitaka yataka. ");
INSERT INTO wos_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Wun du Moses dé nana mandéka israelna duré wa, ‘God wandéka wuni déka profet wuni xaku. God wuniré wandén maki hukémbu wambula wandét guna hémémbu du nak xakutandé.’ Wungi dé Moses wa. ");
INSERT INTO wos_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Wun du Moses israelna du wali wungi di hérangwanda du rehafi hafwambu. Moses nana mandékangu wali dé re. Re dé Sainai némburé wara dé Godna ensel wali téndéka wun ensel déré hundi wa. Wandéka dé huli mawuli hérae jémba retembeka hundi dé héra, nanika hwenjoka. ");
INSERT INTO wos_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","”Moses wun némbumbu téndéka di nana mandékangu Mosesna hundi xékéhafi yata di Moseska hu hwe. Hu hweta di Isipré wambula yinjoka di mawuli ya. ");
INSERT INTO wos_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Mawuli yata hanja hurundan sémbutka sarékéta di Mosesna nyama aronré wa, ‘Tale wun du Moses naniré dé hura ya, Isipmbu. Hura yandéka nani ambu rembeka dé wun némburé wari. Wara wambula gayahambandé. Wambula gayatandé, o yingafwe? Métaki nae déré xétame? Méni gwalinya nak tataméni nanika. Wun gwalinya nana néma du retandé. Reta dé tali yindét nani déka hukémbu yitame.’ ");
INSERT INTO wos_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Wungi wataka di némafwi yénataka god ta, bulmakau balina nyan maki. Tataka di hamwi xiyae di déka hwe. Hwetaka di némafwi hénoo sata deka tambambu tandan jooré xéta di mawuli sawuli ya. ");
INSERT INTO wos_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Yandaka dé God hu hwe dika. Hu hwendéka di nukwa, bafu, hunkwarina ximbu di haréké. Hukémbu Godna profet nak dé wun jooka angi hayi Godna nyingambu: God dé wa, ‘Gunawa, israelna du, mé xéké. Hanja guni dumi yétiyéti héki hwari du rehafi hafwambu yitaka yatakata guni hamwi xiyae hwe. Hamwi hwengun héndéka guni hwe? Wunika hwehambanguni. Yingafwe. ");
INSERT INTO wos_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Guni yénataka god Molekna ge meme balina séfimbu totaka guni hura yi. Guni yénataka god Refanéna hunkwariré guni hura yi. Guni wumbére yénataka godré guni ta, bérka ximbu harékénjoka. Wungi hurunguka némbuli wawut di guniré Babilonéna angé saku hafwaré hura yitandi.’ Wungi dé God wa. Wandéka wungi dé hayi Godna nyingambu. ");
INSERT INTO wos_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","”Wungi hurundaka dé God Mosesré wakwe, déka ximbu harékéndaka ge meme balina séfimbu totendakangalaka. Wandéka Moses xe wandéka di xéndén maki ge di to. Totaka di hérae hura yitaka yataka, du rehafi hafwambu. Di wun geré xéta di wa, ‘God nani wali dé té.’ ");
INSERT INTO wos_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Hukémbu di wun ge di hwe, deka nyangwalka. Hwendaka di Josuana ekombu reta di wun ge hura ye di deka héfa héra. Hura yandaka dé God nana mandékana makambu dé deka mamaré hérekindéka di ané héfaré ya. Yae di wun ge totaka di ané héfambu re. Hukémbu Devit néma du xakundéka dé wun ge wungi té. ");
INSERT INTO wos_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","God Devitka dé mawuli ya. Mawuli yandéka dé Devit Godré wakwexékéta dé wa, dé Jekopna Godna ge tonjoka. Wakwexékéndéka dé God wa, ‘Yingafwe.’ ");
INSERT INTO wos_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Wandéka hukémbu Devitna nyan Solomon dé yikafre ge to, Godka. ");
INSERT INTO wos_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","”Yandénka mé saréké. Atéfék duna Néma Du God dé du tondan gembu yamba rekéndé. Godna profet nak wun jooka dé angi hayi: ");
INSERT INTO wos_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","Néma Du dé wa, ‘Nyir wuni néma du rewuka jambé dé. Héfa wuna man takawuka jambé dé. Métakina ge wunika totanguni? Méta hafwambu wuni resétotawuni? ");
INSERT INTO wos_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Wu yingafwe. Wuni wun jondu atéfék wuni hafu wuni hurataka.’ God wungi wandéka dé hayi. ");
INSERT INTO wos_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","”Némbuli guni mé xéké. Guni guna waanmbu Néma Duna hundi xékéhafi yata guna mawulimbu guni séfi sékéhafi yandé du guni. Guni mawuli yanguka maki male hurukwa du guni. Guna mandéka hurundan maki huruta guni Godna Hamwinyana hundi xékénjoka hélék guni ye, atéfék nukwambu. ");
INSERT INTO wos_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Guna mandéka di haraki saraki sémbut di huru, Godna profet atéfékré. Hanja Godna profet di wa, Godna yikafre male sémbut hurutekwa du yatendékaka. Wun jooka wandaka guna mandéka di diré xiyandaka di hiya. Hiyandaka hukémbu wun yikafre male sémbut hurukwa du yandéka guni déré déka mamaka hwetaka guni déré xiyanguka dé hiya. ");
INSERT INTO wos_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Godna ensel déka hambuk hundi Mosesré wandéka guni wun hambuk hundi hérae wandén maki huruhambanguni.” Wungi dé Stiven wa. ");
INSERT INTO wos_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Stiven wungi wandéka néma du xékéta di némafwimbu mawuli wita deka némbi ti, déka. ");
INSERT INTO wos_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Némbi tindaka dé Godna Hamwinya Stivenéna mawulimbu hambuk ye téndéka dé Stiven Godna getéfaré yasawara xé. Xéta dé xé God nukwa hanyikwa maki hanyindéka Jisas déka yika tambambu téndéka. ");
INSERT INTO wos_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Xéta dé Stiven wa, “Mé xé. Wuni yasawara wuni xé Godna getéfa nafwe téndéka, Duna Nyan Godna yika tambambu téndéka.” ");
INSERT INTO wos_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Dé wungi wandéka di déka hundi xékénjoka hélék yata hambukmbu wanjita di deka waan géféti. Géféti ye di atéfék déka fétékéra yi. ");
INSERT INTO wos_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","Ye di déré huluke hura getéfa yatakataka di déré hafwaré hura gwandi. Gwande di motumbu naake déré xiya. Stivenka haraki hundi wandé du motumbu nakinjoka di yifa yandéka sandandan nukwa wur lafe di wayikana du nak déka xi Sol déka man mombu taka. Takandaka dé deka nukwa wurka hate té. ");
INSERT INTO wos_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Hate téndéka di Stivenré motumbu naake xiyandaka dé Stiven Néma Duka wa, “Néma Du Jisas, wuna hamwinya mé héra.” ");
INSERT INTO wos_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Wungi wataka dé hwati se dé hambukmbu wanjita dé wa, “Néma Du, wunika hurundan haraki saraki sémbut diré hasa hwekéméni.” Wungi wataka dé Stiven wungi hiya. ");
INSERT INTO wos_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Di Stivenré xiyandaka dé Sol xétaka dé mawuli ya. Wun nukwa di Jerusalemémbu reta Jisasna hundi xékékwa du takwaré tale di haraki huru. Hurundaka di Jisasna hundi xékékwa du takwa atéfék Jerusalem yatakataka di Judiana hafwaré samariana hafwaré akwi di yaange yi. Yindaka di Jisasna aposel male di Jerusalemémbu re. ");
INSERT INTO wos_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Godna hundi jémba xékékwa du nawulak di Stivenré rémé. Réméta di déka némafwimbu géra. ");
INSERT INTO wos_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Gérandaka dé Sol Jisasna hundi xékékwa du takwaré haraki hurunjoka dé mawuli ya. Mawuli yata dé atéfék geré wulaaye dé hambuk yata Jisasna hundi xékékwa du takwaré huluke hura yi. Huluke hura ye séndé gembu takandéka di hwa. ");
INSERT INTO wos_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Jerusalem yatakataka yaange yindé du takwa di atéfék getéfaré yita di Jisasna hundi wa saafa yi. ");
INSERT INTO wos_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Wa saafa yindaka dé deka du nak Filip samariana getéfa nakré ye dé du takwaré hundi wa, God wasékendén du Kraiska. ");
INSERT INTO wos_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Wandéka di séfélak du takwa Filipna hundi xékéta di xé, Filip hanja xéhafi yandan hambuk jémba yandéka. Xéta déka hundika mawuli yata di jémba xéké. ");
INSERT INTO wos_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Séfélak du takwana mawulimbu haraki hamwinya di té. Téndaka Filip wandéka di haraki hamwinya hambukmbu waanje di diré yatakataka di yaange yi. Man haraki yandé séfélak du takwa, man tamba lékémbandé séfélak du takwa akwi di re. Rendaka Filip wandéka di yikafre ya. ");
INSERT INTO wos_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Yikafre yandaka di atéfék du takwa mawuli yata di mawuli sawuli ya, samariambu. ");
INSERT INTO wos_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Du nak déka xi Saimon wun getéfambu dé re. Hanja foo tuta laku yakwa du dé. Yandéka di samariana du takwa xéta di déka saré waréké. Saimon dé wa, “Wuni némafwi du wuni.” ");
INSERT INTO wos_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Wungi wandéka di wun getéfambu rekwa atéfék néma du, baka du akwi, wungi di déka hundi jémba xéké. Xékéta di wa, “Wun du Godna hambuk dé héra. Hérae dé némafwi hambuk yata dé néma du re.” ");
INSERT INTO wos_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Wungi wataka waréngéna di wa, “Owa. Séfélak nukwambu dé laku yaata dé wungi hambuk jémba dé ye.” Wungi wataka di deka mawuli déka takata di déka hundi xéké. ");
INSERT INTO wos_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Hukémbu Filip yae dé diré yikafre hundi wa, God néma du reta du takwaka hatitendékaka. Jisas Kraiska akwi dé wa. Wandéka xékéta di Jisaska jémba saréké. Sarékéndaka dé Jisasna ximbu diré guré husanda, duré akwi takwaré akwi. ");
INSERT INTO wos_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Saimon akwi dé Jisaska jémba saréké. Sarékéndéka dé Jisasna ximbu déré guré husanda. Guré husandandéka dé Filip wali yitaka yatakata dé xé, Filip nak maki hanja xéhafi yandén hambuk jémba akwi yandéka. Xéta waréngénéta dé saré waréké. ");
INSERT INTO wos_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Jisasna aposel Jerusalemémbu reta di xéké, samariana du takwa Godna hundi xékéndaka. Xékétaka wandaka Pita bér Jon bér yi, samariana du takwaka. ");
INSERT INTO wos_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Ye xaakwa bér Godré wakwexéké, dé déka Hamwinya dika hwendéte. ");
INSERT INTO wos_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","Tale wunde du takwa Jisaska jémba sarékéndaka dé Filip Jisasna ximbu diré guré husanda. Guré husandandéka dé Godna Hamwinya dika gayahambandé. ");
INSERT INTO wos_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Hukémbu Pita bér Jon yae Godré wakwexékéta deka anéngambambu 