﻿USE sofia;
DROP TABLE IF EXISTS sofia.wolmbs_vpl;
CREATE TABLE wolmbs_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES wolmbs_vpl WRITE;
INSERT INTO wolmbs_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","1","Ca njàlbéen ga Yàlla sàkk na asamaan ak suuf. ");
INSERT INTO wolmbs_vpl VALUES ("GN1_2","002_1_2","GEN","1","2","2","Suuf nag da ne woon maraas, ne wëyëŋ, lëndëm muur ndox mu xóot mi, lale ca kaw, noowug Yàlla di wër, tiim ndox mi. ");
INSERT INTO wolmbs_vpl VALUES ("GN1_3","002_1_3","GEN","1","3","3","Ba loolu amee Yàlla ne: «Na leer nekk,» leer daldi am. ");
INSERT INTO wolmbs_vpl VALUES ("GN1_4","002_1_4","GEN","1","4","4","Yàlla gis ne leer gi lu baax la, mu xàjjale leer ak lëndëm. ");
INSERT INTO wolmbs_vpl VALUES ("GN1_5","002_1_5","GEN","1","5","5","Yàlla tudde leer gi bëccëg, lëndëm gi guddi. Ngoon jot, suba dugg, muy bés ba njëkk. ");
INSERT INTO wolmbs_vpl VALUES ("GN1_6","002_1_6","GEN","1","6","6","Yàlla ne: «Na aw dénd dox diggante ndox yi, ngir xàjjale leen, yii fii, yii fale.» ");
INSERT INTO wolmbs_vpl VALUES ("GN1_7","002_1_7","GEN","1","7","7","Yàlla nag sàkk dénd wi, xàjjalee ko ndox yi féete dénd wi suuf ak yi ko féete kaw. Mu daldi nekk noona. ");
INSERT INTO wolmbs_vpl VALUES ("GN1_8","002_1_8","GEN","1","8","8","Yàlla tudde dénd wi asamaan. Ngoon jot, suba dugg, muy bésub ñaareel ba. ");
INSERT INTO wolmbs_vpl VALUES ("GN1_9","002_1_9","GEN","1","9","9","Yàlla ne: «Na ndox, mi asamaan tiim, gëndoo benn béreb, ba joor gu wow feeñ.» Mu daldi nekk noona. ");
INSERT INTO wolmbs_vpl VALUES ("GN1_10","002_1_10","GEN","1","10","10","Yàlla tudde joor gu wow gi suuf, ndox mi gëndoo, mu tudde ko géej. Yàlla gis ne baax na. ");
INSERT INTO wolmbs_vpl VALUES ("GN1_11","002_1_11","GEN","1","11","11","Yàlla ne: «Na suuf sax ñax, muy gàncax gu ànd ak jiwoom, ak garab yuy meññ tey jur seeni jiwu, lu ci nekk ak wirgoom ci kaw suuf.» Mu daldi nekk noona. ");
INSERT INTO wolmbs_vpl VALUES ("GN1_12","002_1_12","GEN","1","12","12","Suuf nag sax ñax, muy gàncax gu ànd ak wirgoy jiwoom, ak garab yuy meññ tey jur seeni wirgoy jiwu. Yàlla gis ne baax na. ");
INSERT INTO wolmbs_vpl VALUES ("GN1_13","002_1_13","GEN","1","13","13","Ngoon jot, suba dugg, muy bésub ñetteel ba. ");
INSERT INTO wolmbs_vpl VALUES ("GN1_14","002_1_14","GEN","1","14","14","Yàlla ne: «Na am ay leer ci déndub asamaan, ngir xàjjale guddi ak bëccëg, te doon ay tegtal, yuy ràññale jamono yi, tey takk bés yi ak at yi. ");
INSERT INTO wolmbs_vpl VALUES ("GN1_15","002_1_15","GEN","1","15","15","Nañu nekk ay leer ci déndub asamaan si, di leeral suuf.» Mu daldi nekk noona. ");
INSERT INTO wolmbs_vpl VALUES ("GN1_16","002_1_16","GEN","1","16","16","Yàlla sàkk ñaari leer yu mag, gi gëna mag yilif bëccëg, gi gëna ndaw yilif guddi; mu sàkk it biddiiw yi. ");
INSERT INTO wolmbs_vpl VALUES ("GN1_17","002_1_17","GEN","1","17","17","Yàlla nag teg leen ca déndub asamaan, di ca leeral suuf, ");
INSERT INTO wolmbs_vpl VALUES ("GN1_18","002_1_18","GEN","1","18","18","ñuy yore guddi ak bëccëg, tey xàjjale lëndëm ak leer. Yàlla gis ne baax na. ");
INSERT INTO wolmbs_vpl VALUES ("GN1_19","002_1_19","GEN","1","19","19","Ngoon jot, suba dugg, muy bésub ñeenteel ba. ");
INSERT INTO wolmbs_vpl VALUES ("GN1_20","002_1_20","GEN","1","20","20","Ba loolu amee Yàlla ne: «Na ndox fees ak ay ndiiraani xeeti mbindeef, te ay picc tiim suuf, di naaw ci déndub asamaan.» ");
INSERT INTO wolmbs_vpl VALUES ("GN1_21","002_1_21","GEN","1","21","21","Ci biir loolu Yàlla sàkk rabi géej yu mag yi ak mboolem mbindeef muy féey tey ramm-rammi ci ndox mi, mu ci nekk ak wirgoom, teg ca lépp luy boroomi laaf, lu ci nekk ak wirgoom. Yàlla gis ne baax na. ");
INSERT INTO wolmbs_vpl VALUES ("GN1_22","002_1_22","GEN","1","22","22","Ba mu ko defee Yàlla barkeel leen, daldi ne: «Giirleen te bare, ba fees ndoxi géej.» Mu neeti: «Na picc yi bare ci kaw suuf.» ");
INSERT INTO wolmbs_vpl VALUES ("GN1_23","002_1_23","GEN","1","23","23","Ngoon jot, suba dugg, muy bésub juróomeel ba. ");
INSERT INTO wolmbs_vpl VALUES ("GN1_24","002_1_24","GEN","1","24","24","Yàlla ne: «Na suuf génne ay mbindeef, mu ci nekk ak wirgoom: ag jur, luy raam aki rabi àll, lu ci nekk ak wirgoom.» Mu daldi nekk noona. ");
INSERT INTO wolmbs_vpl VALUES ("GN1_25","002_1_25","GEN","1","25","25","Yàlla dafa bind rabi àll yi, lu ci nekk ak wirgoom, jur gu ci nekk ak wirgoom, ak lépp luy raam ci kaw suuf, lu ci nekk ak wirgoom. Yàlla nag gis ne baax na. ");
INSERT INTO wolmbs_vpl VALUES ("GN1_26","002_1_26","GEN","1","26","26","Yàlla ne: «Nanu bind nit ci sunu melokaan, mu nirook nun, te na yilif jëni géej ak picci asamaan ak jur gépp ak suuf sépp ak lépp lu ciy raam.» ");
INSERT INTO wolmbs_vpl VALUES ("GN1_27","002_1_27","GEN","1","27","27","Yàlla dafa sàkk nit ci melokaanam; ci melokaanu boppam la Yàlla sàkk nit, góor ak jigéen la sàkk. ");
INSERT INTO wolmbs_vpl VALUES ("GN1_28","002_1_28","GEN","1","28","28","Yàlla barkeel leen ne leen: «Giirleen te bare, ba fees àddina, di ko saytu; te it yilifleen jëni géej ak picci asamaan ak mboolem mbindeef muy yëngu ci kaw suuf.» ");
INSERT INTO wolmbs_vpl VALUES ("GN1_29","002_1_29","GEN","1","29","29","Yàlla ne: «Xoolleen, jox naa leen gépp gàncax gu ànd ak jiwoom ci kaw suuf sépp ak gépp garab guy meññ tey jur jiwoom, muy seen dund. ");
INSERT INTO wolmbs_vpl VALUES ("GN1_30","002_1_30","GEN","1","30","30","Naka rabi àll yépp it, ñook picci asamaan yépp ak lépp luy raam ci kaw suuf, te di boroom bakkan, jox naa leen lépp luy ñax mu tooy, ñoom itam, muy seen lekk.» Mu daldi nekk noona. ");
INSERT INTO wolmbs_vpl VALUES ("GN1_31","002_1_31","GEN","1","31","31","Yàlla nag gis li mu def lépp, fekk lépp baax lool. Ngoon jot, suba dugg, muy bésub juróom benneel ba. ");
INSERT INTO wolmbs_vpl VALUES ("GN2_1","002_2_1","GEN","2","1","1","Ci kaw loolu asamaan ak suuf ak li ñu ëmb lépp mat. ");
INSERT INTO wolmbs_vpl VALUES ("GN2_2","002_2_2","GEN","2","2","2","Bésub juróom ñaareel ba fekk na Yàlla matal liggéeyam. Mu dallu nag ca bésub juróom ñaareel ba, gannaaw ba mu liggéeyee loolu lépp. ");
INSERT INTO wolmbs_vpl VALUES ("GN2_3","002_2_3","GEN","2","3","3","Yàlla daldi barkeel bésub juróom ñaareel ba, def ko bés bu sell, ndax da caa dallu woon gannaaw liggéey ba mu sàkke lépp. ");
INSERT INTO wolmbs_vpl VALUES ("GN2_4","002_2_4","GEN","2","4","4","Liy cosaanal asamaan ak suuf, ba ñu leen di sàkk, mooy lii. Bés ba Aji Sax ji Yàlla sàkkee suuf ak asamaan, ");
INSERT INTO wolmbs_vpl VALUES ("GN2_5","002_2_5","GEN","2","5","5","genn garab nekkagul woon ci kaw suuf, te genn gàncax saxagul; ndaxte booba Yàlla Aji Sax ji tawagul, te nit kuy bey amagul. ");
INSERT INTO wolmbs_vpl VALUES ("GN2_6","002_2_6","GEN","2","6","6","Ci biir loolu mbënn di balle ci suuf, di tooyal fépp. ");
INSERT INTO wolmbs_vpl VALUES ("GN2_7","002_2_7","GEN","2","7","7","Yàlla Aji Sax ji nag móol nit ci pëndub suuf, ëf ngelawal dund ci paxi bakkanam, nit daldi doon boroom bakkan. ");
INSERT INTO wolmbs_vpl VALUES ("GN2_8","002_2_8","GEN","2","8","8","Naka noona Yàlla Aji Sax ji jëmbat tool ca biir Àjjana fa féeteek penku ba, tàbbal ca nit ka mu bind. ");
INSERT INTO wolmbs_vpl VALUES ("GN2_9","002_2_9","GEN","2","9","9","Yàlla Aji Sax ji nag saxal ci suuf lépp luy garab gu meññeef ma rafet te neexa lekk; mu def it garab gay taxa dund ca digg tool ba, moom ak garab gay taxa xam lu baax ak lu bon. ");
INSERT INTO wolmbs_vpl VALUES ("GN2_10","002_2_10","GEN","2","10","10","Amoon na dex guy balle Àjjana, di suuxat tool ba, te fa la séddalikoo, def ñeenti wal. ");
INSERT INTO wolmbs_vpl VALUES ("GN2_11","002_2_11","GEN","2","11","11","Turu menn wal ma di dexu Pison, moo wër réewum Awila mépp. Wurus a nga woon ca réew mooma, ");
INSERT INTO wolmbs_vpl VALUES ("GN2_12","002_2_12","GEN","2","12","12","di wurusu ngalam; te it ndàbb lu neex xet lu tudd bedelyum a nga fa woon ak per yu jafe yu ñuy wax onigsë. ");
INSERT INTO wolmbs_vpl VALUES ("GN2_13","002_2_13","GEN","2","13","13","Ñaareelu dex ga di Gixon, wër réewu Kuus mépp; ");
INSERT INTO wolmbs_vpl VALUES ("GN2_14","002_2_14","GEN","2","14","14","turu ñetteelu dex ga di Tiigar, féete réewum Asiri penku; ñeenteelu dex ga di Efraat. ");
INSERT INTO wolmbs_vpl VALUES ("GN2_15","002_2_15","GEN","2","15","15","Yàlla Aji Sax ji nag jël nit ki, tàbbal ko biir toolub Àjjana, mu di ko bey aka sàmm. ");
INSERT INTO wolmbs_vpl VALUES ("GN2_16","002_2_16","GEN","2","16","16","Yàlla Aji Sax ji sant nit ki, ne ko: «Man ngaa lekk ci mboolem garabi tool bi, ");
INSERT INTO wolmbs_vpl VALUES ("GN2_17","002_2_17","GEN","2","17","17","waaye bul lekk ci garab giy taxa xam lu baax ak lu bon, ndaxte bés boo ci lekkee kat, li wér mooy fa ngay doxe dee.» ");
INSERT INTO wolmbs_vpl VALUES ("GN2_18","002_2_18","GEN","2","18","18","Yàlla Aji Sax ji daldi ne: «Wéet baaxul ci nit, kon dinaa ko bindal ku koy taxawu te jekk ci doon wéttalam.» ");
INSERT INTO wolmbs_vpl VALUES ("GN2_19","002_2_19","GEN","2","19","19","Loolu fekk na Yàlla Aji Sax ji sàkk ci suuf nja-àll yépp ak njanaaw yépp, daldi leen indil nit, di seet nu leen nit di tudde; te tur wu mu leen jox, muy moom. ");
INSERT INTO wolmbs_vpl VALUES ("GN2_20","002_2_20","GEN","2","20","20","Ba mu ko defee nit kooku, di Aadama, tudd jur gépp ak picc yépp ak rabi àll yépp, waaye fekku ca ku koy jàppale te jekk ci doon wéttalam. ");
INSERT INTO wolmbs_vpl VALUES ("GN2_21","002_2_21","GEN","2","21","21","Bi loolu amee Yàlla Aji Sax ji nelawloo Aadama nelaw yu xóot. Ba muy nelaw nag, mu rocci genn ciy faaram, fatte pax ma aw suux. ");
INSERT INTO wolmbs_vpl VALUES ("GN2_22","002_2_22","GEN","2","22","22","Yàlla Aji Sax ji bind jigéen ci faar, gi mu jële ci Aadama, indil ko ko. ");
INSERT INTO wolmbs_vpl VALUES ("GN2_23","002_2_23","GEN","2","23","23","Aadama ne tonet, daldi ne: «Waaw kay nag, kii moo bokk ci samay yax ak sama suux! Dees na ko tudde jigéen, ndaxte ci góor lees ko jële.» ");
INSERT INTO wolmbs_vpl VALUES ("GN2_24","002_2_24","GEN","2","24","24","Looloo tax góor di teqalikook ndeyam ak baayam, taqoo ak jabaram, ñuy wenn suux. ");
INSERT INTO wolmbs_vpl VALUES ("GN2_25","002_2_25","GEN","2","25","25","Ku góor ki ak jabaram, ñoom ñaar ñépp, yaramu neen lañu defoon, te amuñu ci woon genn kersa. ");
INSERT INTO wolmbs_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","1","Jaan nag moo gënoona muus ci rabi àll, yi Yàlla Aji Sax ji sàkk yépp. Jaan ja moo ne jigéen ja: «Ndax wóor na ne Yàllaa ne: “Buleen lekk ci doomi genn garabu tool bi”?» ");
INSERT INTO wolmbs_vpl VALUES ("GN3_2","002_3_2","GEN","3","2","2","Jigéen ja wax jaan ja, ne ko: «Man nanoo lekk ci doomi garabi tool bi kay. ");
INSERT INTO wolmbs_vpl VALUES ("GN3_3","002_3_3","GEN","3","3","3","Waaye garab gi ci digg tool bi la Yàlla ne: “Buleen ci lekk, buleen ko laal sax, lu ko moy ngeen dee.”» ");
INSERT INTO wolmbs_vpl VALUES ("GN3_4","002_3_4","GEN","3","4","4","Jaan ja ne jigéen ja: «Déedéet, dungeen dee! ");
INSERT INTO wolmbs_vpl VALUES ("GN3_5","002_3_5","GEN","3","5","5","Waaye Yàlla xam na ne bés bu ngeen ci lekkee, seeni gët dina ubbiku, ngeen mel ni Yàlla, xam lu baax ak lu bon.» ");
INSERT INTO wolmbs_vpl VALUES ("GN3_6","002_3_6","GEN","3","6","6","Jigéen ja dafa gis ne garab gi rafet na, niru na lu neex, te mata bëgg ci kuy wuta am xel, mu witt ci doom yi, lekk; jox ci jëkkëram ji mu àndal, moom it mu lekk. ");
INSERT INTO wolmbs_vpl VALUES ("GN3_7","002_3_7","GEN","3","7","7","Seeni gët daldi ubbiku, ñu xam ne yaramu neen lañu def. Ba mu ko defee ñu ràbb xobi garabu figg, gemboo. ");
INSERT INTO wolmbs_vpl VALUES ("GN3_8","002_3_8","GEN","3","8","8","Gannaaw loolu ñu dégg tànki Yàlla Aji Sax ji, muy doxantu ca tool ba, fekk ker gi sedd, ñu daldi fexee làqu Yàlla Aji Sax ji ci biir garabi tool bi. ");
INSERT INTO wolmbs_vpl VALUES ("GN3_9","002_3_9","GEN","3","9","9","Yàlla Aji Sax ji nag ne Aadama: «Ana nga?» ");
INSERT INTO wolmbs_vpl VALUES ("GN3_10","002_3_10","GEN","3","10","10","Mu ne ko: «Damaa dégg say tànk ci tool bi, tiit, ndax yaramu neen laa def, ma daldi làqu.» ");
INSERT INTO wolmbs_vpl VALUES ("GN3_11","002_3_11","GEN","3","11","11","Yàlla Aji Sax ji ne ko: «Ku la xamal ne dangaa def yaramu neen? Mbaa du dangaa lekk ca garab ga ma la aaye, waay?» ");
INSERT INTO wolmbs_vpl VALUES ("GN3_12","002_3_12","GEN","3","12","12","Aadama ne ko: «Jigéen ji nga ma booleel de, moo ma jox ci garab gi, ma lekk.» ");
INSERT INTO wolmbs_vpl VALUES ("GN3_13","002_3_13","GEN","3","13","13","Yàlla Aji Sax ji ne jigéen ja: «Yaw, li nga def nii mooy lan?» Jigéen ja ne ko: «Aa, jaan de moo ma nax, ba ma lekk ci.» ");
INSERT INTO wolmbs_vpl VALUES ("GN3_14","002_3_14","GEN","3","14","14","Yàlla Aji Sax ji nag ne jaan ja: «Gannaaw def nga loolu, yaw rekk yaay alku ci rabi kër yépp ak rabi àll yépp; dinga watatu, di lekk pënd sa giiru dund gépp. ");
INSERT INTO wolmbs_vpl VALUES ("GN3_15","002_3_15","GEN","3","15","15","Dinaa def mbañeel sa digganteek jigéen ji, ba dëddale sa xeet ak xeetam, muy toj sa bopp, nga di ko màtt ci téstën.» ");
INSERT INTO wolmbs_vpl VALUES ("GN3_16","002_3_16","GEN","3","16","16","Yàlla teg ca ne jigéen ja: «Dinaa taral sa mititu mat, ci mitit ngay wasin. Sa bëgg-bëggu bakkan dina la xiir ci sa jëkkër, te moo lay teg tànk.» ");
INSERT INTO wolmbs_vpl VALUES ("GN3_17","002_3_17","GEN","3","17","17","Mu tegaat ca ne Aadama: «Gannaaw dégg nga sa waxu soxna, ba lekk ci garab gi ma la aaye, dinaa rëbb suuf ndax yaw; coono bu metti nga ciy dunde sa giiru dund gépp. ");
INSERT INTO wolmbs_vpl VALUES ("GN3_18","002_3_18","GEN","3","18","18","Suuf dina la meññalal ay dég aki dagg, doo lekk te beyoo, ");
INSERT INTO wolmbs_vpl VALUES ("GN3_19","002_3_19","GEN","3","19","19","saw ñaq ngay dunde, ba kera ngay dellu ci suuf si ma la jële; ndaxte pënd nga, te dinga dellu di pënd.» ");
INSERT INTO wolmbs_vpl VALUES ("GN3_20","002_3_20","GEN","3","20","20","Aadama nag tudde soxnaam Awa (muy firi Dund), ndax mooy ndeyu képp kuy dund. ");
INSERT INTO wolmbs_vpl VALUES ("GN3_21","002_3_21","GEN","3","21","21","Gannaaw gi, Yàlla Aji Sax ji sàkkal Aadama ak soxnaam ay yérey der, wodde leen. ");
INSERT INTO wolmbs_vpl VALUES ("GN3_22","002_3_22","GEN","3","22","22","Yàlla Aji Sax ji daldi ne: «Léegi nit mel na ni nun, xam lu baax ak lu bon. Kon nag bumu tàllal loxoom, di witt ci doomi garab giy taxa dund, di lekk, bay dund fàww.» ");
INSERT INTO wolmbs_vpl VALUES ("GN3_23","002_3_23","GEN","3","23","23","Ba loolu amee Yàlla Aji Sax ji génne ko toolub Àjjana, muy bey suuf si ñu ko sàkke. ");
INSERT INTO wolmbs_vpl VALUES ("GN3_24","002_3_24","GEN","3","24","24","Da koo dàq, ba noppi teg ca penkub toolu Àjjana ba ay malaakay serub, boole ca saamar buy xuyy-xuyyi, tey dem aka dikk, di wattu yoon, wa jëm ca garab gay taxa dund. ");
INSERT INTO wolmbs_vpl VALUES ("GN4_1","002_4_1","GEN","4","1","1","Gannaaw loolu Aadama ànd ak soxnaam Awa, mu ëmb, am Kayin, mu ne: «Am naa doom ju góor ci ndimbalu Aji Sax ji.» ");
INSERT INTO wolmbs_vpl VALUES ("GN4_2","002_4_2","GEN","4","2","2","Awa teg ca rakkam, Abel. Abel di sàmm, Kayin di bey. ");
INSERT INTO wolmbs_vpl VALUES ("GN4_3","002_4_3","GEN","4","3","3","Ñu dem ba mu yàgg, Kayin sàkk ci mbeyam, jébbal ko Aji Sax ji, màggale ko ko. ");
INSERT INTO wolmbs_vpl VALUES ("GN4_4","002_4_4","GEN","4","4","4","Abel moom jébbal ko nebbonu jur, ga njëkka juddu ca géttam. Aji Sax ji nangul Abel ak saraxam, ");
INSERT INTO wolmbs_vpl VALUES ("GN4_5","002_4_5","GEN","4","5","5","te nangulul Kayin. Kayin nag mer lool, ba ne fóññ. ");
INSERT INTO wolmbs_vpl VALUES ("GN4_6","002_4_6","GEN","4","6","6","Aji Sax ji ne Kayin: «Lu la taxa mer, ba ne fóññ nii? ");
INSERT INTO wolmbs_vpl VALUES ("GN4_7","002_4_7","GEN","4","7","7","Soo defee lu baax, dees na la nangul; soo deful lu baax, bàkkaar a ngi lay yeeru ci sa bunt, di la tërooka wut, waaye yaa ko wara man.» ");
INSERT INTO wolmbs_vpl VALUES ("GN4_8","002_4_8","GEN","4","8","8","Ci kaw loolu Kayin séq ak rakkam Abel wax. Ba mu ko defee ñu dem ca àll ba, Kayin dal ci kaw Abel, bóom ko. ");
INSERT INTO wolmbs_vpl VALUES ("GN4_9","002_4_9","GEN","4","9","9","Aji Sax ji ne Kayin: «Ana sa rakk Abel?» Mu ne ko: «Gisuma ko de; ndax maa wara sàmm sama rakk?» ");
INSERT INTO wolmbs_vpl VALUES ("GN4_10","002_4_10","GEN","4","10","10","Yàlla ne ko: «Loo def? Sa deretu rakk jaa ngi yuuxoo ci suuf, ma di ci dégg. ");
INSERT INTO wolmbs_vpl VALUES ("GN4_11","002_4_11","GEN","4","11","11","Léegi dinga alku, ba suuf dummóoyu la, moom mi ubbi gémmiñam, naan sa deretu rakk, ji nga tuur. ");
INSERT INTO wolmbs_vpl VALUES ("GN4_12","002_4_12","GEN","4","12","12","Boo beyee, dootul nangu. Dinga dëkke daŋ-daŋ, di wëreelu ci àddina.» ");
INSERT INTO wolmbs_vpl VALUES ("GN4_13","002_4_13","GEN","4","13","13","Teewul Kayin wax Aji Sax ji ne ko: «Sama mbugal diis na lool, ba àttanuma ko! ");
INSERT INTO wolmbs_vpl VALUES ("GN4_14","002_4_14","GEN","4","14","14","Ndegam tey jii danga maa dàq, xañ ma sa jataay, dinaa dëkke daŋ-daŋ, di wëreelu ci kaw suuf, te kon ku ma gis rey ma.» ");
INSERT INTO wolmbs_vpl VALUES ("GN4_15","002_4_15","GEN","4","15","15","Aji Sax ji ne ko: «Kon nag ku la rey, yaw Kayin, dina jot juróom ñaari yoon lu ko raw.» Ba loolu amee mu sàkkal Kayin màndarga, ba ku ko gis du ko rey. ");
INSERT INTO wolmbs_vpl VALUES ("GN4_16","002_4_16","GEN","4","16","16","Kayin daldi bàyyikoo ca Aji Sax ji, dem dëkki réewu Nódd, fa féete Àjjana penku. ");
INSERT INTO wolmbs_vpl VALUES ("GN4_17","002_4_17","GEN","4","17","17","Gannaaw loolu Kayin ànd ak soxnaam, mu ëmb, am Enog. Ci biir loolu Kayin sanc ab dëkk, dippee ko doomam ju góor Enog. ");
INSERT INTO wolmbs_vpl VALUES ("GN4_18","002_4_18","GEN","4","18","18","Enog jur Iraat; Iraat jur Mexuyayel; Mexuyayel jur Metusayel; Metusayel jur Lemeg. ");
INSERT INTO wolmbs_vpl VALUES ("GN4_19","002_4_19","GEN","4","19","19","Lemeg nag jël ñaari jabar, aawo bi tudd Ada, ñaareel bi di Cilla. ");
INSERT INTO wolmbs_vpl VALUES ("GN4_20","002_4_20","GEN","4","20","20","Ada taawloo Yabal, miy cosaanu sàmm yiy màngaan, ");
INSERT INTO wolmbs_vpl VALUES ("GN4_21","002_4_21","GEN","4","21","21","teg ca Yubal, miy cosaanu ñi mane xalam ak toxoro. ");
INSERT INTO wolmbs_vpl VALUES ("GN4_22","002_4_22","GEN","4","22","22","Cilla moom jur Tubal Kayin miy tëgg lépp luy jumtukaayu xànjar ak weñ. Tubal Kayin am na jigéen bu tudd Naama. ");
INSERT INTO wolmbs_vpl VALUES ("GN4_23","002_4_23","GEN","4","23","23","Lemeg nag ne ay soxnaam: «Dégluleen maa, yeen soxnay Lemeg; teeyluleen maa, yeen Ada ak Cilla. Nit a ma gaañ, ma bóom, goneg jàmbaar dóor ma, ma faat. ");
INSERT INTO wolmbs_vpl VALUES ("GN4_24","002_4_24","GEN","4","24","24","Kayin kay, lees di feyul juróom ñaari yoon, ne, bu dee Lemeg mii, muy juróom ñaar fukki yoon ak juróom ñaar.» ");
INSERT INTO wolmbs_vpl VALUES ("GN4_25","002_4_25","GEN","4","25","25","Bi loolu wéyee Aadama àndaat ak soxnaam, mu am doom ju góor; tudde ko Set (muy firi May), ndax da ne: «Yàlla may na ma weneen askan, mu wuutu Abel, mi Kayin rey.» ");
INSERT INTO wolmbs_vpl VALUES ("GN4_26","002_4_26","GEN","4","26","26","Set it, am doom ju góor, tudde ko Enos. Fan yooya lañu tàmbalee tudd Aji Sax ji, di ko wormaal. ");
INSERT INTO wolmbs_vpl VALUES ("GN5_1","002_5_1","GEN","5","1","1","Ni téere indee askanu Aadama nii la. Ba Yàlla di sàkk nit, da koo bind ci melokaanam, ");
INSERT INTO wolmbs_vpl VALUES ("GN5_2","002_5_2","GEN","5","2","2","góor ak jigéen la sàkk, barkeel leen, tudde leen Nit, keroog ba mu leen sàkkee. ");
INSERT INTO wolmbs_vpl VALUES ("GN5_3","002_5_3","GEN","5","3","3","Aadama dund téeméeri at ak fanweer (130), jur doom ju góor, mu bindoo melokaanam te nirook moom. Mu tudde ko Set. ");
INSERT INTO wolmbs_vpl VALUES ("GN5_4","002_5_4","GEN","5","4","4","Set juddu na, Aadama dundaat juróom ñetti téeméeri at (800), amaat ay doom yu góor ak yu jigéen. ");
INSERT INTO wolmbs_vpl VALUES ("GN5_5","002_5_5","GEN","5","5","5","Kon Aadama dund na juróom ñeenti téeméeri at ak fanweer (930), doora faatu. ");
INSERT INTO wolmbs_vpl VALUES ("GN5_6","002_5_6","GEN","5","6","6","Set moomee am na téeméeri at ak juróom (105), doora jur Enos. ");
INSERT INTO wolmbs_vpl VALUES ("GN5_7","002_5_7","GEN","5","7","7","Enos juddu na, Set dundaat juróom ñetti téeméeri at ak juróom ñaar (807), amaat doom yu góor ak yu jigéen. ");
INSERT INTO wolmbs_vpl VALUES ("GN5_8","002_5_8","GEN","5","8","8","Kon Set dund na juróom ñeenti téeméeri at ak fukk ak ñaar (912), doora faatu. ");
INSERT INTO wolmbs_vpl VALUES ("GN5_9","002_5_9","GEN","5","9","9","Enos nag am na juróom ñeent fukki at (90), doora jur Kenan. ");
INSERT INTO wolmbs_vpl VALUES ("GN5_10","002_5_10","GEN","5","10","10","Kenan juddu na, Enos dundaat juróom ñetti téeméeri at ak fukk ak juróom (815), amaat doom yu góor ak yu jigéen. ");
INSERT INTO wolmbs_vpl VALUES ("GN5_11","002_5_11","GEN","5","11","11","Kon Enos dund na juróom ñeenti téeméeri at ak juróom (905), doora faatu. ");
INSERT INTO wolmbs_vpl VALUES ("GN5_12","002_5_12","GEN","5","12","12","Kenan moomee am na juróom ñaar fukki at (70), doora jur Maalaleel. ");
INSERT INTO wolmbs_vpl VALUES ("GN5_13","002_5_13","GEN","5","13","13","Maalaleel juddu na, Kenan dundaat juróom ñetti téeméeri at ak ñeent fukk (840), amaat ay doom yu góor ak yu jigéen. ");
INSERT INTO wolmbs_vpl VALUES ("GN5_14","002_5_14","GEN","5","14","14","Kon Kenan dund na juróom ñeenti téeméeri at ak fukk (910), doora faatu. ");
INSERT INTO wolmbs_vpl VALUES ("GN5_15","002_5_15","GEN","5","15","15","Maalaleel nag am na juróom benn fukki at ak juróom (65), doora jur Yeredd. ");
INSERT INTO wolmbs_vpl VALUES ("GN5_16","002_5_16","GEN","5","16","16","Yeredd juddu na, Maalaleel dundaat juróom ñetti téeméeri at ak fanweer (830), amaat ay doom yu góor ak yu jigéen. ");
INSERT INTO wolmbs_vpl VALUES ("GN5_17","002_5_17","GEN","5","17","17","Kon Maalaleel dund na juróom ñetti téeméeri at ak juróom ñeent fukk ak juróom (895), doora faatu. ");
INSERT INTO wolmbs_vpl VALUES ("GN5_18","002_5_18","GEN","5","18","18","Yeredd moomee am na téeméeri at ak juróom benn fukk ak ñaar (162), doora jur Enog. ");
INSERT INTO wolmbs_vpl VALUES ("GN5_19","002_5_19","GEN","5","19","19","Enog juddu na, Yeredd dundaat juróom ñetti téeméeri at (800), amaat ay doom yu góor ak yu jigéen. ");
INSERT INTO wolmbs_vpl VALUES ("GN5_20","002_5_20","GEN","5","20","20","Kon Yeredd dund na juróom ñeenti téeméeri at ak juróom benn fukk ak ñaar (962), doora faatu. ");
INSERT INTO wolmbs_vpl VALUES ("GN5_21","002_5_21","GEN","5","21","21","Enog moomee, am na juróom benn fukki at ak juróom (65), doora jur Matusalem. ");
INSERT INTO wolmbs_vpl VALUES ("GN5_22","002_5_22","GEN","5","22","22","Matusalem juddu na, ba noppi Enog topp Yàlla ñetti téeméeri at (300), amaat ay doom yu góor ak yu jigéen. ");
INSERT INTO wolmbs_vpl VALUES ("GN5_23","002_5_23","GEN","5","23","23","Kon Enog dund na ñetti téeméeri at ak juróom benn fukk ak juróom (365). ");
INSERT INTO wolmbs_vpl VALUES ("GN5_24","002_5_24","GEN","5","24","24","Enog dafa topp Yàlla, ba jekki-jekki giseesatu ko, ndaxte Yàllaa ko yéege fa moom. ");
INSERT INTO wolmbs_vpl VALUES ("GN5_25","002_5_25","GEN","5","25","25","Matusalem moomee am na téeméeri at ak juróom ñett fukk ak juróom ñaar (187), doora jur Lemeg. ");
INSERT INTO wolmbs_vpl VALUES ("GN5_26","002_5_26","GEN","5","26","26","Lemeg juddu na, Matusalem dundaat juróom ñaari téeméeri at ak juróom ñett fukk ak ñaar (782), amaat ay doom yu góor ak yu jigéen. ");
INSERT INTO wolmbs_vpl VALUES ("GN5_27","002_5_27","GEN","5","27","27","Kon Matusalem dund na juróom ñeenti téeméeri at ak juróom benn fukk ak juróom ñeent (969), doora faatu. ");
INSERT INTO wolmbs_vpl VALUES ("GN5_28","002_5_28","GEN","5","28","28","Lemeg nag am na téeméeri at ak juróom ñett fukk ak ñaar (182), doora jur doom ju góor. ");
INSERT INTO wolmbs_vpl VALUES ("GN5_29","002_5_29","GEN","5","29","29","Mu tudde ko Nóoyin (muy firi Noflaay) ndax dafa ne: «Kii moo nuy taxa noyyiwaat, noppal nu ci liggéey yu metti ak coonoy mbeyu suuf, si Aji Sax ji rëbb.» ");
INSERT INTO wolmbs_vpl VALUES ("GN5_30","002_5_30","GEN","5","30","30","Nóoyin juddu na, Lemeg dundaat juróomi téeméeri at ak juróom ñeent fukk ak juróom (595), amaat ay doom yu góor ak yu jigéen. ");
INSERT INTO wolmbs_vpl VALUES ("GN5_31","002_5_31","GEN","5","31","31","Kon Lemeg dund na juróom ñaari téeméeri at ak juróom ñaar fukk ak juróom ñaar (777), doora faatu. ");
INSERT INTO wolmbs_vpl VALUES ("GN5_32","002_5_32","GEN","5","32","32","Nóoyin moomee am na juróomi téeméeri at (500), doora jur Sem ak Xam ak Yafet. ");
INSERT INTO wolmbs_vpl VALUES ("GN6_1","002_6_1","GEN","6","1","1","Bi nga xamee ne nit ñi tàmbali nañoo fulandiwu ci kaw suuf, te am ay doom yu jigéen, ");
INSERT INTO wolmbs_vpl VALUES ("GN6_2","002_6_2","GEN","6","2","2","ay goney Yàlla ñoo gis jigéen ñeek seen taar, ñuy jël ñi ñu bëgg ci ñoom, def leeni jabar. ");
INSERT INTO wolmbs_vpl VALUES ("GN6_3","002_6_3","GEN","6","3","3","Aji Sax ji daldi wax ne: «Manumaa bàyyi nit, muy wéyee dunde noo gi ma ko may, ndax nit du dara lu dul suuxi neen, kon dinaa leen àppal diirub téeméeri at ak ñaar fukk (120).» ");
INSERT INTO wolmbs_vpl VALUES ("GN6_4","002_6_4","GEN","6","4","4","Ca jamono yooya ak itam gannaaw ba goney Yàlla yooyu àndeek jigéeni àddina, ba am ca ay doom, aw xeetu ponkal wu ñuy wax Nefilim moo nekkoon ci àddina. Ñoo doon jàmbaari cosaan, diy góor ñu amoon tur. ");
INSERT INTO wolmbs_vpl VALUES ("GN6_5","002_6_5","GEN","6","5","5","Aji Sax ji dafa gis ne mbonu nit màgg na lool ci biir àddina, te fu mu mana tollu, lu bon rekk lay xinte ci xolam. ");
INSERT INTO wolmbs_vpl VALUES ("GN6_6","002_6_6","GEN","6","6","6","Aji Sax ji nag am tiis ci xolam, ba mititlu li mu sàkkoon nit ci kaw suuf. ");
INSERT INTO wolmbs_vpl VALUES ("GN6_7","002_6_7","GEN","6","7","7","Aji Sax ji daldi ne: «Dinaa far ci kaw suuf doom aadama yi ma sàkk, nit ak jur, luy raam ak luy naaw, ndax mititlu naa li ma leen sàkk.» ");
INSERT INTO wolmbs_vpl VALUES ("GN6_8","002_6_8","GEN","6","8","8","Waaye fekk na Aji Sax ji xool Nóoyin bëti yërmande. ");
INSERT INTO wolmbs_vpl VALUES ("GN6_9","002_6_9","GEN","6","9","9","Askanu Nóoyin mooy lii. Nóoyin nit ku jub la woon, di ku mat ci biir nit ñi mu bokkal jamono, te di ku topp Yàlla. ");
INSERT INTO wolmbs_vpl VALUES ("GN6_10","002_6_10","GEN","6","10","10","Nóoyin nag amoon na ñetti doom yu góor: seeni tur di Sem, Xam ak Yafet. ");
INSERT INTO wolmbs_vpl VALUES ("GN6_11","002_6_11","GEN","6","11","11","Booba fekk na àddina yàqu, te fees ak ay, Yàlla teg ci bëtam. ");
INSERT INTO wolmbs_vpl VALUES ("GN6_12","002_6_12","GEN","6","12","12","Yàlla gis ne àddina yàqu na, ndaxte jëfi ñépp a bokk ñaaw fi kaw suuf. ");
INSERT INTO wolmbs_vpl VALUES ("GN6_13","002_6_13","GEN","6","13","13","Ba mu ko defee Yàlla ne Nóoyin: «Dogal naa ne dinaa boole faat mboolem boroom bakkan, ndaxte ayu nit dajal na kaw suuf. Dinaa leen boole ak li ci àddina, faagaagal. ");
INSERT INTO wolmbs_vpl VALUES ("GN6_14","002_6_14","GEN","6","14","14","«Yaw nag wutal dénku sippar, yattal ci sa bopp gaal gu mag; nga sàkk ci ay néeg, te diw ko koltaar biir ak biti. ");
INSERT INTO wolmbs_vpl VALUES ("GN6_15","002_6_15","GEN","6","15","15","Ni nga koy defare nii la: na guddaayu gaal gi di ñetti téeméeri xasab, yaatuwaay bi di juróom fukki xasab, taxawaay bi di fanweeri xasab. ");
INSERT INTO wolmbs_vpl VALUES ("GN6_16","002_6_16","GEN","6","16","16","Yattal mbaar, mu ko tiim, te nga àggale gaal gi, bàyyi lu tollook xasab diggante kéméj yi ak mbaar mi. Sàkkal ko bunt ci wet gi, te séddale ko ñetti néeg yu tegloo, benn ci suuf, benn ci digg bi ak benn ci kaw. ");
INSERT INTO wolmbs_vpl VALUES ("GN6_17","002_6_17","GEN","6","17","17","«Maa ngi nii di indi mbënnu ndox ci kaw suuf, mu far lépp luy dund lu asamaan tiim; te lépp lu nekk ci kaw suuf dina dee. ");
INSERT INTO wolmbs_vpl VALUES ("GN6_18","002_6_18","GEN","6","18","18","Waaye dinaa fas kóllëre ak yaw, nga dugg ci gaal gi, yaak say doom ak sa soxna ak say soxnay doom. ");
INSERT INTO wolmbs_vpl VALUES ("GN6_19","002_6_19","GEN","6","19","19","Te xeeti rab yépp nanga ci dugal ñaar ci gaal gi, wu ci nekk, nga def ko góor ak jigéen; su ko defee ngeen ànd mucc. ");
INSERT INTO wolmbs_vpl VALUES ("GN6_20","002_6_20","GEN","6","20","20","Xeetu picc wu ci nekk ak xeetu bàyyima wu ci nekk ak wépp xeetu rab wuy raam ci suuf, dina def ñaar, ñëw ci yaw, ba raw. ");
INSERT INTO wolmbs_vpl VALUES ("GN6_21","002_6_21","GEN","6","21","21","Sàkkal ci bépp xeetu dund, denc, ngeen bokk dunde.» ");
INSERT INTO wolmbs_vpl VALUES ("GN6_22","002_6_22","GEN","6","22","22","Noonu la Nóoyin def. Lépp lu ko Yàlla sant, def na ko. ");
INSERT INTO wolmbs_vpl VALUES ("GN7_1","002_7_1","GEN","7","1","1","Gannaaw ba loolu amee Aji Sax ji dafa wax Nóoyin ne ko: «Duggal ci gaal gu mag gi, yaak sa njaboot gépp, ndaxte niti jamono jii, yaw rekk laa ci gis, nga jub ni ma ko bëgge. ");
INSERT INTO wolmbs_vpl VALUES ("GN7_2","002_7_2","GEN","7","2","2","Xeeti rab yu set yépp yóbbaale ci juróom ñaar yu góor ak juróom ñaar yu jigéen, ak ñaar ci xeeti rab yi setul, te ñuy góor ak jigéen. ");
INSERT INTO wolmbs_vpl VALUES ("GN7_3","002_7_3","GEN","7","3","3","Te it xeetu picc mu nekk yóbbaale ci juróom ñaar yu góor ak juróom ñaar yu jigéen, ngir seen xeet baña fey ci kaw suuf. ");
INSERT INTO wolmbs_vpl VALUES ("GN7_4","002_7_4","GEN","7","4","4","Ndax kat li feek juróom ñaari fan dinaa wàcce taw ci kaw suuf diiru ñeent fukki guddi ak ñeent fukki bëccëg, ba far ci àddina mboolem mbindeef mu ma sàkk.» ");
INSERT INTO wolmbs_vpl VALUES ("GN7_5","002_7_5","GEN","7","5","5","Nóoyin daldi def la ko Aji Sax ji sant lépp. ");
INSERT INTO wolmbs_vpl VALUES ("GN7_6","002_7_6","GEN","7","6","6","Bi mbënn miy ñëw ci àddina, booba fekk na Nóoyin am juróom benni téeméeri at. ");
INSERT INTO wolmbs_vpl VALUES ("GN7_7","002_7_7","GEN","7","7","7","Nóoyin dugg na ca gaal ga, ànd ak ay doomam ak soxnaam ak soxnay doomam ya, ngir mucc ca ndoxu mbënn ma. ");
INSERT INTO wolmbs_vpl VALUES ("GN7_8","002_7_8","GEN","7","8","8","Rab yu set yi ak yi setul ak picc yi ak yiy raam ");
INSERT INTO wolmbs_vpl VALUES ("GN7_9","002_7_9","GEN","7","9","9","ànd nañu ak Nóoyin, dugg ca gaal ga, def ñaar-ñaar, góor ak jigéen, ni ko Yàlla sante Nóoyin. ");
INSERT INTO wolmbs_vpl VALUES ("GN7_10","002_7_10","GEN","7","10","10","Ba juróom ñaari fan wéyee nag, ndoxu mbënn ma agsi ci kaw suuf. ");
INSERT INTO wolmbs_vpl VALUES ("GN7_11","002_7_11","GEN","7","11","11","At ma Nóoyin amee juróom benni téeméeri at, ca fukki fan ya ak juróom ñaar ca ñaareelu weer wa, kera la bëti ndox ya ne jàyy, jóge xóotey géej, bunti ndoxi asamaan ne kulbét, mu ne yureet, ");
INSERT INTO wolmbs_vpl VALUES ("GN7_12","002_7_12","GEN","7","12","12","taw biy sottiku ci suuf diiru ñeent fukki guddi ak ñeent fukki bëccëg. ");
INSERT INTO wolmbs_vpl VALUES ("GN7_13","002_7_13","GEN","7","13","13","Keroog bés boobu la Nóoyin ànd aki doomam yu góor, Sem ak Xam ak Yafet, ak soxnaam ak ñetti soxnay doomam yooyu, ñu dugg ca gaal ga, ");
INSERT INTO wolmbs_vpl VALUES ("GN7_14","002_7_14","GEN","7","14","14","àndandook rabu àll yépp, lu ci nekk ak wirgoom, ak jur gépp, lu ci nekk ak wirgoom, ak lépp luy raam ci kaw suuf, lu ci nekk ak wirgoom, ak lépp luy naaw, lu ci nekk ak wirgoom, muy picc mbaa boroomi laaf. ");
INSERT INTO wolmbs_vpl VALUES ("GN7_15","002_7_15","GEN","7","15","15","Lépp luy boroom bakkan def na ñaar-ñaar, ànd ak Nóoyin, dugg ca gaal ga, ");
INSERT INTO wolmbs_vpl VALUES ("GN7_16","002_7_16","GEN","7","16","16","mboolem xeetu mbindeef rekk, di góor ak jigéen, ni ko ko Yàlla sante. Ci kaw loolu Aji Sax ji ne ràpp buntu gaal gi, gannaaw bi Nóoyin duggee. ");
INSERT INTO wolmbs_vpl VALUES ("GN7_17","002_7_17","GEN","7","17","17","Mbënn ma nag di wal ci àddina diiru ñeent fukki fan. Ndox ya di yokku, gaal gay jóg, ba tëmb, tiim suuf lu sore. ");
INSERT INTO wolmbs_vpl VALUES ("GN7_18","002_7_18","GEN","7","18","18","Ma ngay gën di yokku, tey baawaan ci kaw suuf, ba gaal ga tëmb, di dem ca kaw ndox ma. ");
INSERT INTO wolmbs_vpl VALUES ("GN7_19","002_7_19","GEN","7","19","19","Ndox ma di walangaan, ba mëdd tund yu kawe ya fépp fu asamaan tiim. ");
INSERT INTO wolmbs_vpl VALUES ("GN7_20","002_7_20","GEN","7","20","20","Muy yokku, di yokku, ba gëna kawe tund ya lu mat fukki xasab ak juróom. ");
INSERT INTO wolmbs_vpl VALUES ("GN7_21","002_7_21","GEN","7","21","21","Mboolem mbindeef mu daan dox ci kaw suuf dee na ca. Picc yi ak jur gi ak rabi àll yi ak lépp luy raam ci kaw suuf dee na, ñoom ak nit ñépp. ");
INSERT INTO wolmbs_vpl VALUES ("GN7_22","002_7_22","GEN","7","22","22","Mboolem mbindeef muy boroom bakkan ci kaw suuf a bokk dee. ");
INSERT INTO wolmbs_vpl VALUES ("GN7_23","002_7_23","GEN","7","23","23","Luy dund ci àddina daldi sànku, ba nit ak jur ak luy raam ak luy naaw—lépp la Aji Sax ji raafal ci àddina. Nóoyin rekk a des, moom ak ña àndoon ak moom ca gaal ga. ");
INSERT INTO wolmbs_vpl VALUES ("GN7_24","002_7_24","GEN","7","24","24","Ndox mi nag di wal-wali ci kaw suuf diirub téeméeri fan ak juróom fukk. ");
INSERT INTO wolmbs_vpl VALUES ("GN8_1","002_8_1","GEN","8","1","1","Ci biir loolu Yàlla bàyyi xel Nóoyin ak li mu nekkal ci gaal gi, di rabi àll yi ak jur gi. Yàlla daldi yebal ngelaw, mu wal kaw suuf, ba ndox yi wàcc. ");
INSERT INTO wolmbs_vpl VALUES ("GN8_2","002_8_2","GEN","8","2","2","Bëti ndox ya ca xóote ya dafa taxaw, bunti ndoxi asamaan tëju, taw bi dal. ");
INSERT INTO wolmbs_vpl VALUES ("GN8_3","002_8_3","GEN","8","3","3","Ci kaw loolu ndox mi taa ci suuf di wàññiku. Bi téeméeri fan yi ak juróom fukk matee nag, ndox ma gëna néew. ");
INSERT INTO wolmbs_vpl VALUES ("GN8_4","002_8_4","GEN","8","4","4","Ba juróom ñaareelu weer wa amee fukki fan ak juróom ñaar, gaal gaa nga teereji tundi Araraat. ");
INSERT INTO wolmbs_vpl VALUES ("GN8_5","002_8_5","GEN","8","5","5","Ndox may wàññiku rekk ba ca fukkeelu weer wa. Keroog ba fukkeelu weer wa teroo, ca la njobbaxtali tund ya tàmbalee feeñ. ");
INSERT INTO wolmbs_vpl VALUES ("GN8_6","002_8_6","GEN","8","6","6","Teg nañu ca ñeent fukki fan, Nóoyin doora ubbi poroxndoll, ba mu sàkkaloon gaal ga, ");
INSERT INTO wolmbs_vpl VALUES ("GN8_7","002_8_7","GEN","8","7","7","daldi yebal ab baaxoñ, muy naaw, di dem aka dikk, ba ndox mi fendi ci kaw suuf. ");
INSERT INTO wolmbs_vpl VALUES ("GN8_8","002_8_8","GEN","8","8","8","Mu teg ca yebal pitax, ba xam ndax ndox mi ci suuf fer na. ");
INSERT INTO wolmbs_vpl VALUES ("GN8_9","002_8_9","GEN","8","9","9","Teewul pitax ma gisul fenn fu mu tag, ndax ndox mi muur na suuf sépp. Mu délsi nag fa moom ca gaal ga. Nóoyin tàllal loxoom, jàpp ko dugal ci biir fi wetam. ");
INSERT INTO wolmbs_vpl VALUES ("GN8_10","002_8_10","GEN","8","10","10","Négandiku na juróom ñaari fan, doora yebalaat pitax ma. ");
INSERT INTO wolmbs_vpl VALUES ("GN8_11","002_8_11","GEN","8","11","11","Ba mu délsee ca ngoon, indaalewul lu moy xobu oliw wu tooy wu keppe ca sàll wa. Nóoyin xam ne ndox mi taa woon ci suuf, fer na. ");
INSERT INTO wolmbs_vpl VALUES ("GN8_12","002_8_12","GEN","8","12","12","Mu négati juróom ñaari fan, bàyyiwaat pitax ma. Boobu yoon nag délsiwaatul ca moom. ");
INSERT INTO wolmbs_vpl VALUES ("GN8_13","002_8_13","GEN","8","13","13","At ma Nóoyin amee juróom benni téeméeri at ak benn, keroog benn fanu weer wa njëkk, ndox ma taa woon ca suuf daldi fendi. Nóoyin ubbi kubeer ga, xool, ba gis ne kaw suuf wow na. ");
INSERT INTO wolmbs_vpl VALUES ("GN8_14","002_8_14","GEN","8","14","14","Keroog ñaar fukki fan ak juróom ñaar ca ñaareelu weer wa, ca la suuf si doora wow koŋŋ. ");
INSERT INTO wolmbs_vpl VALUES ("GN8_15","002_8_15","GEN","8","15","15","Ba loolu amee Yàlla ne Nóoyin: ");
INSERT INTO wolmbs_vpl VALUES ("GN8_16","002_8_16","GEN","8","16","16","«Génnal gaal gi, yaak sa soxna ak say doom ak say soxnay doom. ");
INSERT INTO wolmbs_vpl VALUES ("GN8_17","002_8_17","GEN","8","17","17","Génnewaaleel lépp luy xeetu mbindeef mu ngeen àndal: picc yi ak bàyyima yi ak luy raam, ñu fulandiwu ci kaw suuf, daldi giir te bare.» ");
INSERT INTO wolmbs_vpl VALUES ("GN8_18","002_8_18","GEN","8","18","18","Nóoyin daldi génn, moom aki doomam ak soxnaam ak soxnay doomam ya. ");
INSERT INTO wolmbs_vpl VALUES ("GN8_19","002_8_19","GEN","8","19","19","Rabi àll yi ak luy raam ak luy naaw ak luy dox ci kaw suuf—lépp génne ca gaal ga, lu ci nekk ak wirgoom. ");
INSERT INTO wolmbs_vpl VALUES ("GN8_20","002_8_20","GEN","8","20","20","Naka la Nóoyin génn, daldi sàkkal Aji Sax ji sarxalukaay, màggale ko ko. Mu sàkk nag ci mboolem rab wu set ak mboolem picc mu set, jébbal Yàlla ca sarxalukaay ba, muy saraxu rendi-dóomal. ");
INSERT INTO wolmbs_vpl VALUES ("GN8_21","002_8_21","GEN","8","21","21","Ci kaw loolu xetug jàmm gillee ca sarax sa, yéeg fa Aji Sax ja. Booba la wax ci xolam ne: «Dootuma rëbb suuf mukk ndax nit, doonte ba muy ndaw lay dale xinte lu ñaaw ci xolam. Dootuma boole faagaagal mukk lépp luy dund, nii ma ko defe. ");
INSERT INTO wolmbs_vpl VALUES ("GN8_22","002_8_22","GEN","8","22","22","Li feek suuf di suuf, muy nji walla ngóob, sedd aku tàngoor, nawet it mbaa noor, mbaa guddeek bëccëg, lenn du ci dakk.» ");
INSERT INTO wolmbs_vpl VALUES ("GN9_1","002_9_1","GEN","9","1","1","Ci kaw loolu Yàlla barkeel Nóoyin aki doomam ne leen: «Giirleen te bare, ba fees àddina. ");
INSERT INTO wolmbs_vpl VALUES ("GN9_2","002_9_2","GEN","9","2","2","Mboolem rabi àll yi ak njanaawi asamaan ak ndëgmeent yi ci suuf, ak jëni géej yépp, dinañu leen ragal lool. Teg naa leen ci seeni loxo. ");
INSERT INTO wolmbs_vpl VALUES ("GN9_3","002_9_3","GEN","9","3","3","Man ngeena dunde boroom bakkan yooyu yépp. Jagleel naa leen mbindeef yooyu yépp, ni ma leen jagleele woon gàncax. ");
INSERT INTO wolmbs_vpl VALUES ("GN9_4","002_9_4","GEN","9","4","4","«Waaye buleen lekk yàpp wu bakkan des, maanaam yàpp wu deret des. ");
INSERT INTO wolmbs_vpl VALUES ("GN9_5","002_9_5","GEN","9","5","5","Seen bakkan itam, mu ngi ci seen deret, kon kat, képp ku tuur seen deret dinaa ko ko topp. Te it mala mu ci rey nit dinaa ko ko topp, ni may toppe nit. Dinaa topp ku nekk deretu moroomam. ");
INSERT INTO wolmbs_vpl VALUES ("GN9_6","002_9_6","GEN","9","6","6","Ku tuur deretu nit, na nit tuur deretam, ndax ci melokaanu boppam la Yàlla sàkke nit. ");
INSERT INTO wolmbs_vpl VALUES ("GN9_7","002_9_7","GEN","9","7","7","Yeen nag, giirleen te bare, fulandiwu ci kaw suuf te fees ko.» ");
INSERT INTO wolmbs_vpl VALUES ("GN9_8","002_9_8","GEN","9","8","8","Yàlla nag wax Nóoyin ak doomam, yi mu àndal, ne leen: ");
INSERT INTO wolmbs_vpl VALUES ("GN9_9","002_9_9","GEN","9","9","9","«Bés niki tey fasal naa sama bopp kóllëre sama diggante ak yeen ak seen askan, ");
INSERT INTO wolmbs_vpl VALUES ("GN9_10","002_9_10","GEN","9","10","10","fas ko it sama diggante ak mboolem mbindeef mu ngeen àndal, muy picc akug jur mbaa rabi àll—lépp daal lu génnandoo ak yeen ci gaal gi, di lépp luy dund ci kaw suuf. ");
INSERT INTO wolmbs_vpl VALUES ("GN9_11","002_9_11","GEN","9","11","11","Ni may faseek yeen kóllëre nii la: Deesatul boole mbindeef yépp, faat ci mbënn mukk. Du menn mbënn mu deeti faxas àddina.» ");
INSERT INTO wolmbs_vpl VALUES ("GN9_12","002_9_12","GEN","9","12","12","Yàlla neeti: «Kóllëre gi may fas ak yeen ak mboolem mbindeef mu ànd ak yeen, day sax ba fàww te liy màndargaam mooy lii. ");
INSERT INTO wolmbs_vpl VALUES ("GN9_13","002_9_13","GEN","9","13","13","Def naa sama xon ci niir yi, muy màndargaal kóllëre gi dox sama diggante ak àddina. ");
INSERT INTO wolmbs_vpl VALUES ("GN9_14","002_9_14","GEN","9","14","14","«Saa su ma dajalee niir yi ci jaww ji, ba xon gi feeñ ci niir yi, ");
INSERT INTO wolmbs_vpl VALUES ("GN9_15","002_9_15","GEN","9","15","15","damay daldi xalaataat kóllëre, gi ma fas sama digganteek yeen ak mboolem xeeti mbindeef, su ko defee ndox dootul sabab mbënn muy faagaagal lépp luy dund. ");
INSERT INTO wolmbs_vpl VALUES ("GN9_16","002_9_16","GEN","9","16","16","Xon gi day nekk ci biir niir yi, ma di ko gis, di xalaat kóllëre, gi ma fas fàww, sama diggante, man Yàlla, ak mboolem xeetu mbindeef mu nekk ci kaw suuf.» ");
INSERT INTO wolmbs_vpl VALUES ("GN9_17","002_9_17","GEN","9","17","17","Ci kaw loolu Yàlla ne Nóoyin: «Xon googu mooy màndargaal sama kóllëre, gi ma fas ak mboolem mbindeef mu nekk ci kaw suuf.» ");
INSERT INTO wolmbs_vpl VALUES ("GN9_18","002_9_18","GEN","9","18","18","Doomi Nóoyin yu góor, yi génne ci gaal gi, ñooy: Sem, Xam ak Yafet; Xam mooy baayu Kanaan. ");
INSERT INTO wolmbs_vpl VALUES ("GN9_19","002_9_19","GEN","9","19","19","Ñooñu ñooy ñetti doomi Nóoyin yu góor, te ci ñoom la àddina sépp soqikoo. ");
INSERT INTO wolmbs_vpl VALUES ("GN9_20","002_9_20","GEN","9","20","20","Nóoyin ab beykat la woon. Mu nekk nag ci njëmbatum reseñ. ");
INSERT INTO wolmbs_vpl VALUES ("GN9_21","002_9_21","GEN","9","21","21","Mu am bés mu naan biiñ, ba màndi, tëdd ci xaymaam, daldi sàgganu. ");
INSERT INTO wolmbs_vpl VALUES ("GN9_22","002_9_22","GEN","9","22","22","Ba loolu amee Xam, baayu Kanaan, gis céri baayam, génn waxi ko Sem ak Yafet ca biti. ");
INSERT INTO wolmbs_vpl VALUES ("GN9_23","002_9_23","GEN","9","23","23","Sem ak Yafet ànd, jël malaan, teg ko ci seeni mbagg, doxe gannaaw ba agsi, doora sàng seen céri baay. Dañoo dummóoyu, ba gisuñu seen céri baay. ");
INSERT INTO wolmbs_vpl VALUES ("GN9_24","002_9_24","GEN","9","24","24","Màndite ma giif, Nóoyin yewwu, daldi yég ni xale bi def ak moom. ");
INSERT INTO wolmbs_vpl VALUES ("GN9_25","002_9_25","GEN","9","25","25","Ba mu ko defee mu ne: «Yal na Kanaan torox, bay jaamu jaami doomi ndeyam.» ");
INSERT INTO wolmbs_vpl VALUES ("GN9_26","002_9_26","GEN","9","26","26","Mu dellu ne: «Cant ñeel na Aji Sax ji, Yàllay Sem, yal na Kanaan dib jaamam. ");
INSERT INTO wolmbs_vpl VALUES ("GN9_27","002_9_27","GEN","9","27","27","Yal na Yàlla lawal askanu Yafet, dëël ko ci xaymay Sem, te Kanaan di seen jaam.» ");
INSERT INTO wolmbs_vpl VALUES ("GN9_28","002_9_28","GEN","9","28","28","Gannaaw ba mbënn ma wéyee, Nóoyin dundaat na ñetti téeméeri at ak juróom fukk (350). ");
INSERT INTO wolmbs_vpl VALUES ("GN9_29","002_9_29","GEN","9","29","29","Nóoyin dund na juróom ñeenti téeméeri at ak juróom fukk (950), doora faatu. ");
INSERT INTO wolmbs_vpl VALUES ("GN10_1","002_10_1","GEN","10","1","1","Askanu doomi Nóoyin mooy lii. Gannaaw ba mbënn ma wéyee, Sem ak Xam ak Yafet am nañu ay doom. ");
INSERT INTO wolmbs_vpl VALUES ("GN10_2","002_10_2","GEN","10","2","2","Doomi Yafet yu góor ñoo di Gomeer ak Magog ak Maday ak Yawaan ak Tubal ak Meseg ak Tiraas. ");
INSERT INTO wolmbs_vpl VALUES ("GN10_3","002_10_3","GEN","10","3","3","Doomi Gomeer yu góor ñoo di Askenas, Rifaat ak Togarma. ");
INSERT INTO wolmbs_vpl VALUES ("GN10_4","002_10_4","GEN","10","4","4","Doomi Yawaan yu góor ñoo di Elisa ak Tarsis ak Kitim ak Dodanim. ");
INSERT INTO wolmbs_vpl VALUES ("GN10_5","002_10_5","GEN","10","5","5","Ñi sosoo ci ñoom ñoo law ca wàllaa géej, meññ nag ay xeet ci seeni suuf, xeet wu ci nekk ak làkkam, def it ay làng ci seen biiri xeet. ");
INSERT INTO wolmbs_vpl VALUES ("GN10_6","002_10_6","GEN","10","6","6","Doomi Xam yu góor ñoo di Kuus ak Misrayim ak Puut ak Kanaan. ");
INSERT INTO wolmbs_vpl VALUES ("GN10_7","002_10_7","GEN","10","7","7","Doomi Kuus yu góor ñoo di Saba ak Awila ak Sabta ak Raama ak Sabteka. Doomi Raama yu góor di Seba ak Dedan. ");
INSERT INTO wolmbs_vpl VALUES ("GN10_8","002_10_8","GEN","10","8","8","Kuus moo jur Nimrodd, ki jëkk di jàmbaar ju siiw ci kaw suuf, ");
INSERT INTO wolmbs_vpl VALUES ("GN10_9","002_10_9","GEN","10","9","9","mu doonoon rëbbkat bu maga mag. Looloo waral ñu naan: «Mbete Nimrodd, rëbbkat bu maga mag ba.» ");
INSERT INTO wolmbs_vpl VALUES ("GN10_10","002_10_10","GEN","10","10","10","Dëkk yiy péeyi nguuram ñoo di Babel ak Ereg ak Akàdd ak Kalne, gi ci réewu Sineyaar. ");
INSERT INTO wolmbs_vpl VALUES ("GN10_11","002_10_11","GEN","10","11","11","Ca réew mooma la Nimrodd jóge dem Asur, sanc Niniw ak dëkk yooyee di Rexobot Ir ak Kala, ");
INSERT INTO wolmbs_vpl VALUES ("GN10_12","002_10_12","GEN","10","12","12","ba Resen gi ci diggante Niniw ak Kala, dëkk bu mag bi. ");
INSERT INTO wolmbs_vpl VALUES ("GN10_13","002_10_13","GEN","10","13","13","Misrayim nag mooy maami Luddeen ñi ak Anameen ñi ak Leyabeen ñi ak Naftuyeen ñi ");
INSERT INTO wolmbs_vpl VALUES ("GN10_14","002_10_14","GEN","10","14","14","ak Pataruseen ñi ak Kasluxeen ñi, ak it Kaftoreen ñi, ñooñee waa Filisti soqikoo. ");
INSERT INTO wolmbs_vpl VALUES ("GN10_15","002_10_15","GEN","10","15","15","Kanaan moo taawloo Sidon, teg ca Ett. ");
INSERT INTO wolmbs_vpl VALUES ("GN10_16","002_10_16","GEN","10","16","16","Kanaan mooy maamu Yebuseen ñi ak Amoreen ñi ak Girgaseen ñi. ");
INSERT INTO wolmbs_vpl VALUES ("GN10_17","002_10_17","GEN","10","17","17","Mooy maamu Eween ñi ak Arkeen ñi ak Sineen ñi. ");
INSERT INTO wolmbs_vpl VALUES ("GN10_18","002_10_18","GEN","10","18","18","Mooy maamu Arwàddeen ñi it ak Cemareen ñi ak Amateen ñi. La ca tegu làngi Kanaan tasaaroo. ");
INSERT INTO wolmbs_vpl VALUES ("GN10_19","002_10_19","GEN","10","19","19","Kemu suufas Kanaaneen ña, mu ngi tàmbalee Sidon, jaar weti Gerar, dem ba Gasa, wuti Sodom ak Gomor ak Adma ak Ceboyim, daldi teeri Lesa. ");
INSERT INTO wolmbs_vpl VALUES ("GN10_20","002_10_20","GEN","10","20","20","Ñooñu ñooy askani Xam, askan wu ci nekk ak làngam ak làkkam, di ay xeet ci seeni réew. ");
INSERT INTO wolmbs_vpl VALUES ("GN10_21","002_10_21","GEN","10","21","21","Sem, miy magu Yafet, jur na moom itam ay doom yu góor. Mooy maami Eber ak askanam. ");
INSERT INTO wolmbs_vpl VALUES ("GN10_22","002_10_22","GEN","10","22","22","Doomi Sem yu góor ñoo di Elam ak Asur ak Arpagsàdd ak Ludd ak Aram. ");
INSERT INTO wolmbs_vpl VALUES ("GN10_23","002_10_23","GEN","10","23","23","Góor ñi Aram jur ñii la: Ucc ak Xuul ak Geter ak Maas. ");
INSERT INTO wolmbs_vpl VALUES ("GN10_24","002_10_24","GEN","10","24","24","Arpagsàdd jur Sela, Sela jur Eber. ");
INSERT INTO wolmbs_vpl VALUES ("GN10_25","002_10_25","GEN","10","25","25","Eber moom, jur ñaari doom yu góor, kenn ki tudd Peleg (muy firi Séddalikoo), ndaxte ci jamonoom àddina dafa séddalikoo woon. Rakku Peleg ju góor mooy Yogtaan. ");
INSERT INTO wolmbs_vpl VALUES ("GN10_26","002_10_26","GEN","10","26","26","Yogtaan a jur Alamodàdd ak Selef ak Asarmawet ak Yerax ");
INSERT INTO wolmbs_vpl VALUES ("GN10_27","002_10_27","GEN","10","27","27","ak Adoram ak Usal ak Digla ");
INSERT INTO wolmbs_vpl VALUES ("GN10_28","002_10_28","GEN","10","28","28","ak Obal ak Abimayel ak Seba ");
INSERT INTO wolmbs_vpl VALUES ("GN10_29","002_10_29","GEN","10","29","29","ak Ofir ak Awila ak Yobab. Ñooñu ñépp di doomi Yogtaan yu góor. ");
INSERT INTO wolmbs_vpl VALUES ("GN10_30","002_10_30","GEN","10","30","30","Ña nga dëkkoon ca wàllu Mesa ga wuti Sefar, di diiwaanu tund ya ca penku. ");
INSERT INTO wolmbs_vpl VALUES ("GN10_31","002_10_31","GEN","10","31","31","Ñooñoo askanoo ci Sem, askan wu ci nekk ak làngam ak làkkam, di ay xeet ci seeni réew. ");
INSERT INTO wolmbs_vpl VALUES ("GN10_32","002_10_32","GEN","10","32","32","Làngi doomi Nóoyin yu góor a ngoogu, làng gu nekk ak askanam, ñu diy xeet. Ci ñoom la xeet yépp jóge tasaaroo ci kaw suuf, gannaaw ba mbënn ma wéyee. ");
INSERT INTO wolmbs_vpl VALUES ("GN11_1","002_11_1","GEN","11","1","1","Ca ndoorte la nag waa àddina sépp a bokkoon wenn làkk, seeni wax di benn. ");
INSERT INTO wolmbs_vpl VALUES ("GN11_2","002_11_2","GEN","11","2","2","Bi nit ñi toxoo, jëm penku, dañoo gis ag joor ci réewu Sineyaar, ñu sanc fa. ");
INSERT INTO wolmbs_vpl VALUES ("GN11_3","002_11_3","GEN","11","3","3","Ñu ne: «Ayca nu defar ay móol yu ñu lakk cib taal, ba mu ñor.» Ci kaw loolu ñu def móol ya doji tabax, taqalee ko koltaar, ");
INSERT INTO wolmbs_vpl VALUES ("GN11_4","002_11_4","GEN","11","4","4","daldi ne: «Ayca nu tabax ab dëkk bu taax ma bëtt asamaan; kon dinanu am woy, te dunu tasaaroo ci kaw suuf.» ");
INSERT INTO wolmbs_vpl VALUES ("GN11_5","002_11_5","GEN","11","5","5","Ba ñu noppee Aji Sax ji wàcc, xoolsi dëkk bi ak taax, mi doom aadama yi tabax. ");
INSERT INTO wolmbs_vpl VALUES ("GN11_6","002_11_6","GEN","11","6","6","Aji Sax ji da ne: «Su ñu tàmbalee nii, di menn mbooloo te bokk wenn làkk, kon dara dootu leen të. ");
INSERT INTO wolmbs_vpl VALUES ("GN11_7","002_11_7","GEN","11","7","7","Ayca nu wàcc, safaan seen làkk, ba dootuñu déggoo.» ");
INSERT INTO wolmbs_vpl VALUES ("GN11_8","002_11_8","GEN","11","8","8","Ba loolu amee Aji Sax ji jële leen foofa, tasaare leen ci kaw suuf sépp, ñu yemale fa dëkk ba ñu doon tabax. ");
INSERT INTO wolmbs_vpl VALUES ("GN11_9","002_11_9","GEN","11","9","9","Looloo tax ñu tudde dëkk ba Babel (muy firi Safaan), ndax foofa la Aji Sax ji safaane làkku àddina sépp, mu jaxasoo, te fa la leen tasaaree ci kaw suuf sépp. ");
INSERT INTO wolmbs_vpl VALUES ("GN11_10","002_11_10","GEN","11","10","10","Askanu Sem mooy lii. Sem am na téeméeri at, doora jur Arpagsàdd, fekk na mbënn ma wees, ba mu am ñaari at. ");
INSERT INTO wolmbs_vpl VALUES ("GN11_11","002_11_11","GEN","11","11","11","Arpagsàdd juddu na, Sem dundaat juróomi téeméeri at (500), juraat ay doom yu góor ak yu jigéen. ");
INSERT INTO wolmbs_vpl VALUES ("GN11_12","002_11_12","GEN","11","12","12","Arpagsàdd am fanweeri at ak juróom, jur Sela. ");
INSERT INTO wolmbs_vpl VALUES ("GN11_13","002_11_13","GEN","11","13","13","Sela juddu na, Arpagsàdd dundaat ñeenti téeméeri at ak ñett (403), juraat ay doom yu góor ak yu jigéen. ");
INSERT INTO wolmbs_vpl VALUES ("GN11_14","002_11_14","GEN","11","14","14","Sela am fanweeri at, jur Eber. ");
INSERT INTO wolmbs_vpl VALUES ("GN11_15","002_11_15","GEN","11","15","15","Eber juddu na, Sela dundaat ñeenti téeméeri at ak ñett (403), juraat ay doom yu góor ak yu jigéen. ");
INSERT INTO wolmbs_vpl VALUES ("GN11_16","002_11_16","GEN","11","16","16","Eber am fanweeri at ak ñeent, jur Peleg. ");
INSERT INTO wolmbs_vpl VALUES ("GN11_17","002_11_17","GEN","11","17","17","Peleg juddu na, Eber dundaat ñeenti téeméeri at ak fanweer (430), juraat ay doom yu góor ak yu jigéen. ");
INSERT INTO wolmbs_vpl VALUES ("GN11_18","002_11_18","GEN","11","18","18","Peleg am fanweeri at, jur Rew. ");
INSERT INTO wolmbs_vpl VALUES ("GN11_19","002_11_19","GEN","11","19","19","Rew juddu na, Peleg dundaat ñaari téeméeri at ak juróom ñeent (209), juraat ay doom yu góor ak yu jigéen. ");
INSERT INTO wolmbs_vpl VALUES ("GN11_20","002_11_20","GEN","11","20","20","Rew am fanweeri at ak ñaar, jur Serug. ");
INSERT INTO wolmbs_vpl VALUES ("GN11_21","002_11_21","GEN","11","21","21","Serug juddu na, Rew dundaat ñaari téeméeri at ak juróom ñaar (207), juraat ay doom yu góor ak yu jigéen. ");
INSERT INTO wolmbs_vpl VALUES ("GN11_22","002_11_22","GEN","11","22","22","Serug am fanweeri at, jur Naxor. ");
INSERT INTO wolmbs_vpl VALUES ("GN11_23","002_11_23","GEN","11","23","23","Naxor juddu na, Serug dundaat ñaari téeméeri at (200), juraat ay doom yu góor ak yu jigéen. ");
INSERT INTO wolmbs_vpl VALUES ("GN11_24","002_11_24","GEN","11","24","24","Naxor am ñaar fukki at ak juróom ñeent, jur Teraa. ");
INSERT INTO wolmbs_vpl VALUES ("GN11_25","002_11_25","GEN","11","25","25","Teraa gane na àddina, Naxor dundaat téeméeri at ak fukk ak juróom ñeent (119), juraat ay doom yu góor ak yu jigéen. ");
INSERT INTO wolmbs_vpl VALUES ("GN11_26","002_11_26","GEN","11","26","26","Gannaaw ba Teraa amee juróom ñaar fukki at, mu jur Ibraam ak Naxor ak Aran. ");
INSERT INTO wolmbs_vpl VALUES ("GN11_27","002_11_27","GEN","11","27","27","Askanu Teraa mooy lii. Teraa mooy baayu Ibraam ak Naxor ak Aran. Aran mooy baayu Lóot. ");
INSERT INTO wolmbs_vpl VALUES ("GN11_28","002_11_28","GEN","11","28","28","Gannaaw loolu Aran faatu na lu jiitu faatug baayam Teraa, ca réew ma mu juddoo, di Ur, dëkku Kaldeen ña. ");
INSERT INTO wolmbs_vpl VALUES ("GN11_29","002_11_29","GEN","11","29","29","Ibraam ak Naxor jël nañu ay soxna; soxnas Ibraam tudd Sarayi, soxnas Naxor di Milka. Milka moomu, moom ak rakkam ju jigéen Yiska, Aran ay seen baay. ");
INSERT INTO wolmbs_vpl VALUES ("GN11_30","002_11_30","GEN","11","30","30","Sarayi moomu masuloona am doom te it manu ko woona am. ");
INSERT INTO wolmbs_vpl VALUES ("GN11_31","002_11_31","GEN","11","31","31","Mu am bés Teraa ànd ak doomam Ibraam ak sëtam Lóot, mi Aran di baayam, ak goroom Sarayi, soxnas Ibraam. Ñu bokk jóge Ur gu Kaldeen ña, jëm réewu Kanaan. Ba ñu demee ba Karan, daldi fay sanc. ");
INSERT INTO wolmbs_vpl VALUES ("GN11_32","002_11_32","GEN","11","32","32","Teraa dund na ñaari téeméeri at ak juróom (205), doora génn àddina, ñu denc ko Karan. ");
INSERT INTO wolmbs_vpl VALUES ("GN12_1","002_12_1","GEN","12","1","1","Aji Sax ji moo waxoon Ibraam, ne ko: «Jógeel sam réew, jóge ci say bokk ak sa kër baay, te nga dem ca réew mi ma lay won, ");
INSERT INTO wolmbs_vpl VALUES ("GN12_2","002_12_2","GEN","12","2","2","ma def la ngay cosaanal xeet wu yaa, barkeel la, màggal sa tur, ngay buntu barke. ");
INSERT INTO wolmbs_vpl VALUES ("GN12_3","002_12_3","GEN","12","3","3","Ku la ñaanal barke, ma barkeel, ku la móolu it, ma alag, te xeeti àddina yépp, ci yaw lañuy barkeele.» ");
INSERT INTO wolmbs_vpl VALUES ("GN12_4","002_12_4","GEN","12","4","4","Ibraam daldi dem, na ko ko Aji Sax ji waxe woon, Lóot topp ca. Ba Ibraam di jóge Karan, booba am na juróom ñaar fukki at ak juróom (75). ");
INSERT INTO wolmbs_vpl VALUES ("GN12_5","002_12_5","GEN","12","5","5","Ibraam ànd ak soxnaam Sarayi ak Lóot, mi muy baay bu ndaw ci moom. Mu yóbbaale nag alal, ja mu dajale jépp, ak jaam, ya mu jënde Karan. Ñu jóge fa, jublu réewu Kanaan. ");
INSERT INTO wolmbs_vpl VALUES ("GN12_6","002_12_6","GEN","12","6","6","Ba ñu agsee Kanaan, Ibraam dafa jàll ca biir réew ma, ba àgg béreb bu sell, ba féete ak Sikem, ca garab gu mag, ga ñuy woowe More. Booba fekk na waa Kanaan a nga woon ca réew ma. ");
INSERT INTO wolmbs_vpl VALUES ("GN12_7","002_12_7","GEN","12","7","7","Ci kaw loolu Aji Sax ji feeñu Ibraam ne ko: «Sa askan wi soqikoo ci yaw laay jox réew mii.» Ibraam nag daldi tabaxal Aji Sax ji ko feeñu, ab sarxalukaay. ");
INSERT INTO wolmbs_vpl VALUES ("GN12_8","002_12_8","GEN","12","8","8","Gannaaw loolu mu jóge fa, jëm tund, wi féete Betel penku, samp fa xaymaam; Betel féete ko sowu, Ayi féete ko penku. Foofa itam Ibraam tabaxal na fa Aji Sax ji sarxalukaay, tudd fa Aji Sax ji, wormaal ko. ");
INSERT INTO wolmbs_vpl VALUES ("GN12_9","002_12_9","GEN","12","9","9","Ibraam bàyyikooti fa, aw yoonam, jublu àllub Negew. ");
INSERT INTO wolmbs_vpl VALUES ("GN12_10","002_12_10","GEN","12","10","10","Ca jamono jooja xiif a amoon ca réew ma, ba tax Ibraam dem réewum Misra, toogi fa, ndax xiif bu metti la woon. ");
INSERT INTO wolmbs_vpl VALUES ("GN12_11","002_12_11","GEN","12","11","11","Naka lay jub Misra, daldi ne soxnaam Sarayi: «Déglu ma, xam naa ne ku rafet nga. ");
INSERT INTO wolmbs_vpl VALUES ("GN12_12","002_12_12","GEN","12","12","12","Bu la waa Misra gisee, dinañu ne sama soxna nga. Te dinañu ma rey, nga des. ");
INSERT INTO wolmbs_vpl VALUES ("GN12_13","002_12_13","GEN","12","13","13","Kon nag ngalla waxal ne sama jigéen nga, ba tax ma am jàmm; su ko defee dees na ma bàyyi, ma dund, te di la ko gërëme.» ");
INSERT INTO wolmbs_vpl VALUES ("GN12_14","002_12_14","GEN","12","14","14","Ba Ibraam àggee Misra, waa Misra gis ne jigéen ji mu àndal rafet na lool. ");
INSERT INTO wolmbs_vpl VALUES ("GN12_15","002_12_15","GEN","12","15","15","Jaraafi Firawna itam gis ko, di ko kañ ca Firawna ndax taar ba, ñu daldi ko yóbbu ca kër Firawna. ");
INSERT INTO wolmbs_vpl VALUES ("GN12_16","002_12_16","GEN","12","16","16","Firawna nag toppatoo Ibraam bu baax ndax moom, ñu may ko ay gàtt ak ay nag, ay mbaam yu góor, ak ay jaam yu góor ak yu jigéen, ak ay mbaam yu jigéen aki giléem. ");
INSERT INTO wolmbs_vpl VALUES ("GN12_17","002_12_17","GEN","12","17","17","Teewul Aji Sax ji wàcce ca Firawna ak waa këram jàngoro yu metti ndax Sarayi, soxnas Ibraam. ");
INSERT INTO wolmbs_vpl VALUES ("GN12_18","002_12_18","GEN","12","18","18","Firawna woolu Ibraam ne ko: «Li nga ma def nag? Lu tax waxoo ma ne kii sa soxna la? ");
INSERT INTO wolmbs_vpl VALUES ("GN12_19","002_12_19","GEN","12","19","19","Lu tax nga ne sa jigéen la, ba tax ma jël ko, bëgg koo def sama jabar? Ayca, sa jabar a ngoog, fabal te ne mott!» ");
INSERT INTO wolmbs_vpl VALUES ("GN12_20","002_12_20","GEN","12","20","20","Naka la Firawna wax loolu ba noppi, daldi sant ay dagam, ñu génne Ibraam réew ma, moom ak soxnaam ak alalam jépp. ");
INSERT INTO wolmbs_vpl VALUES ("GN13_1","002_13_1","GEN","13","1","1","Bi loolu amee Ibraam dafa jóge Misra, moom ak soxnaam, yóbbaale alalam jépp, daldi dem ca àllub Negew, Lóot topp ca. ");
INSERT INTO wolmbs_vpl VALUES ("GN13_2","002_13_2","GEN","13","2","2","Ibraam nag amoon alal ju bare diggante jur, xaalis ak wurus. ");
INSERT INTO wolmbs_vpl VALUES ("GN13_3","002_13_3","GEN","13","3","3","Gannaaw loolu mu awati yoonam, jóge àllub Negew, jëm dëkk ba ñu naa Betel, dem ba àgg ca béreb, ba mu njëkkoona samp xaymaam, ci diggante Betel ak Ayi, ");
INSERT INTO wolmbs_vpl VALUES ("GN13_4","002_13_4","GEN","13","4","4","fa mu tabaxoon ab sarxalukaay. Ibraam nag tudd fa Aji Sax ji, wormaal ko. ");
INSERT INTO wolmbs_vpl VALUES ("GN13_5","002_13_5","GEN","13","5","5","Ci biir loolu Lóot, mi mu àndal, moom it yor jur gu gudd ak gu gàtt aki xayma, ");
INSERT INTO wolmbs_vpl VALUES ("GN13_6","002_13_6","GEN","13","6","6","ba tax xajatuñu ca réew ma, ndax seen alal dafa bare, ba manatuñu faa bokk dëkk. ");
INSERT INTO wolmbs_vpl VALUES ("GN13_7","002_13_7","GEN","13","7","7","Loolu tax sàmmi Ibraam ak sàmmi Lóot di jote. Rax ci dolli Kanaaneen ñi ak Periseen ñi ña nga woon ca réew ma. ");
INSERT INTO wolmbs_vpl VALUES ("GN13_8","002_13_8","GEN","13","8","8","Ba loolu amee Ibraam da ne Lóot: «Waay waay, bu xuloo am sama digganteek yaw mbaa say sàmm ak samay sàmm. Xanaa dunuy bokk nag? ");
INSERT INTO wolmbs_vpl VALUES ("GN13_9","002_13_9","GEN","13","9","9","Xanaa àll bi newul yàmblaŋ ngay gis? Nan teqalikoo, kay; boo demee càmmoñ, ma dem ndijoor; boo demee ndijoor, ma dem càmmoñ.» ");
INSERT INTO wolmbs_vpl VALUES ("GN13_10","002_13_10","GEN","13","10","10","Ba mu waxee ba noppi, Lóot dafa xool, gis joor, gi wër dexu Yurdan gépp, màndi ndox. Ndax laata Aji Sax jiy tas dëkk yu ñuy wax Sodom ak Gomor, àll bi jëm Cowar dafa naatoon, ni réewum Misra naate, ba faf mel ni toolub Aji Sax ja. ");
INSERT INTO wolmbs_vpl VALUES ("GN13_11","002_13_11","GEN","13","11","11","Ba mu ko defee Lóot tànn jooru Yurdan gépp, daldi toxu jëm penku. Noonu lañu teqalikoo. ");
INSERT INTO wolmbs_vpl VALUES ("GN13_12","002_13_12","GEN","13","12","12","Ibraam dëkke réewu Kanaan, Lóot sance dëkk ya ca jooru Yurdan, daldi toxal xaymaam, samp ko Sodom. ");
INSERT INTO wolmbs_vpl VALUES ("GN13_13","002_13_13","GEN","13","13","13","Waaye waa Sodom ñu bon lañu woon, te mana moy Aji Sax ji lool. ");
INSERT INTO wolmbs_vpl VALUES ("GN13_14","002_13_14","GEN","13","14","14","Gannaaw ba Lóot teqalikook Ibraam, Aji Sax ji wax na Ibraam ne ko: «Téenal foofu nga taxaw, te séenu bëj-gànnaar ak bëj-saalum ak penkook sowu, ");
INSERT INTO wolmbs_vpl VALUES ("GN13_15","002_13_15","GEN","13","15","15","ndaxte réew mi ngay gis mépp, yaw laa koy may ba fàww, yaak askan wi soqikoo ci yaw. ");
INSERT INTO wolmbs_vpl VALUES ("GN13_16","002_13_16","GEN","13","16","16","Dinaa leen yokk, ba ñu tollu ni feppi suuf, ba feppi suuf gëna neexa waññ sa askan. ");
INSERT INTO wolmbs_vpl VALUES ("GN13_17","002_13_17","GEN","13","17","17","Jógal wër réew mi mépp ba mu daj, ndax yaw laa koy may.» ");
INSERT INTO wolmbs_vpl VALUES ("GN13_18","002_13_18","GEN","13","18","18","Ba mu ko defee Ibraam sempi xaymaam, ñëw dal Ebron ca garab yu mag ya ca toolub Mamre, daldi fay tabaxal Aji Sax ji sarxalukaay. ");
INSERT INTO wolmbs_vpl VALUES ("GN14_1","002_14_1","GEN","14","1","1","Ca jamonoy Amrafel buurub Sineyaar, ak Aryokk buurub Elasaar, Kedorlamer buurub Elam, ak Tidal buurub Goyim, ");
INSERT INTO wolmbs_vpl VALUES ("GN14_2","002_14_2","GEN","14","2","2","ànd nañu, dal ci kaw ñoom Bera buurub Sodom, ak Birsa buurub Gomor, ak Sineyab buurub Adma, ak Semeber buurub Ceboyim, ak it buuru dëkk ba ñuy wax Bela, mooy Cowar ba tey. ");
INSERT INTO wolmbs_vpl VALUES ("GN14_3","002_14_3","GEN","14","3","3","Ñooñoo booloo woon ca xuru Sidim, mooy géeju Xorom gi léegi. ");
INSERT INTO wolmbs_vpl VALUES ("GN14_4","002_14_4","GEN","14","4","4","Fekk na diiru fukki at ak ñaar Kedorlamer moo leen yilifoon, teewul ca fukkeelu at ma ak ñett ñu fippu. ");
INSERT INTO wolmbs_vpl VALUES ("GN14_5","002_14_5","GEN","14","5","5","Ca déwén sa Kedorlamer ak buur ya faroon ak moom, dem dàq Refayeen ña ca Asterot Karnayim, ak Suseen ña ca Am, ak Emeen ña ca jooru Kiryaatayim, ");
INSERT INTO wolmbs_vpl VALUES ("GN14_6","002_14_6","GEN","14","6","6","ak Oreen ña ca seen tund wa ñuy wax Seyir. Da leena dàq ba ca garabu Paran gu mag ga ca wetu màndiŋ ma. ");
INSERT INTO wolmbs_vpl VALUES ("GN14_7","002_14_7","GEN","14","7","7","Ñu jóge fa nag, waññiku, dem En Mispat, di Kades ba tey, daldi teg mboolem réewum Amalegeen ña tànk, boole ca song Amoreen ña dëkk Acacon Tamar. ");
INSERT INTO wolmbs_vpl VALUES ("GN14_8","002_14_8","GEN","14","8","8","Ci kaw loolu buurub Sodom génn, mook buurub Gomor ak buurub Adma ak buurub Ceboyim ak buuru Bela, di Cowar ba tey, ñoom ñépp daldi làng, nara xare ca xuru Sidim, ");
INSERT INTO wolmbs_vpl VALUES ("GN14_9","002_14_9","GEN","14","9","9","di sot ñoom Kedorlamer buurub Elam, ak Tidal buurub Goyim, ak Amrafel buurub Sineyaar, ak Aryokk buurub Elasaar. Ñeenti buur di xareek juróom. ");
INSERT INTO wolmbs_vpl VALUES ("GN14_10","002_14_10","GEN","14","10","10","Waaye xuru Sidim woowu dafa feesoon dell aki kàmbi koltaar. Ba mu ko defee buuri Sodom ak Gomor di daw, far daanu ca kàmb ya. Ña ca des daw ba ca tund ya. ");
INSERT INTO wolmbs_vpl VALUES ("GN14_11","002_14_11","GEN","14","11","11","Ña leen dàq nag, jël alalu Sodom ak Gomor yépp, nanguwaale seen dund bépp boole ca, daldi dem seen yoon. ");
INSERT INTO wolmbs_vpl VALUES ("GN14_12","002_14_12","GEN","14","12","12","Booba lañu yóbbu Lóot ma dëkk Sodom, te Ibraam di baayam bu ndaw. Ci biir loolu ñu yóbbaale li mu amoon lépp, dem. ");
INSERT INTO wolmbs_vpl VALUES ("GN14_13","002_14_13","GEN","14","13","13","Ba loolu xewee, kenn ci ñi ñu jàppoon rëcc, ñëw ci Ibraam miy ab Ebrë, wax ko ko. Fekk na mu dëkk ca wetu garab yu mag ya woon ca toolub Mamre, ma dib Amoreen, di mbokk mu jege ci Eskol ak Aner, ñoom ñi doon wóllërey Ibraam. ");
INSERT INTO wolmbs_vpl VALUES ("GN14_14","002_14_14","GEN","14","14","14","Ba Ibraam déggee ne jàpp nañu Lóot ma muy baayam bu ndaw, fa saa sa daa dajale dagam, yi juddoo këram te tollu ci ñetti téeméer ak fukk ak juróom ñett (318), ñu dàq buur ya ba dëkk ba ñuy wax Dan. ");
INSERT INTO wolmbs_vpl VALUES ("GN14_15","002_14_15","GEN","14","15","15","Ibraam dafa xàjjale mbooloom, dal ci kaw buur ya guddi, dàq leen, topp ci ñoom ba Oba, ca bëj-gànnaaru Damaas. ");
INSERT INTO wolmbs_vpl VALUES ("GN14_16","002_14_16","GEN","14","16","16","Ibraam nag delloosi alal ja jépp, nangu mbokkam Lóot, mook alalam, ak jigéen ña ak ñeneen ña ñu jàppoon. ");
INSERT INTO wolmbs_vpl VALUES ("GN14_17","002_14_17","GEN","14","17","17","Gannaaw ba Ibraam dàqee Kedorlamer ak buur ya àndoon ak moom, ba délsi, buurub Sodom dafa génn, gatandu ko ca xur wa ñuy wax Sawe, ñu di ko woowe xuru Buur ba tey. ");
INSERT INTO wolmbs_vpl VALUES ("GN14_18","002_14_18","GEN","14","18","18","Ci kaw loolu Melkiccedeg buurub Salem, mi doon sarxalkatub Yàlla Aji Kawe ji, daldi ñëw, indi mburu ak biiñ. ");
INSERT INTO wolmbs_vpl VALUES ("GN14_19","002_14_19","GEN","14","19","19","Mu ñaanal Ibraam ne ko: «Yaw Ibraam, Yàlla na la Yàlla Aji Kawe ji barkeel, moom mi sàkk asamaan ak suuf! ");
INSERT INTO wolmbs_vpl VALUES ("GN14_20","002_14_20","GEN","14","20","20","Waaye jaaraamaa Yàlla Aji Kawe ji, moom mi la dumaal say noon!» Ba loolu amee Ibraam sàkk fukkeelu cérub la mu lël lépp, jox ko. ");
INSERT INTO wolmbs_vpl VALUES ("GN14_21","002_14_21","GEN","14","21","21","Gannaaw loolu buurub Sodom wax Ibraam ne ko: «Jox ma nit, ñi nga jàpp, te nga fab alal ji.» ");
INSERT INTO wolmbs_vpl VALUES ("GN14_22","002_14_22","GEN","14","22","22","Ibraam nag wax buurub Sodom ne ko: «Man yékkati naa sama loxo, Yàlla Aji Sax ju Kawe ji seede, moom mi sàkk asamaan ak suuf, ");
INSERT INTO wolmbs_vpl VALUES ("GN14_23","002_14_23","GEN","14","23","23","nee naa: duma jël ci yaw dara, du puso, bi gëna tuut sax, su ko defee doo mana wax ne yaa ma taxa am alal. ");
INSERT INTO wolmbs_vpl VALUES ("GN14_24","002_14_24","GEN","14","24","24","Duma jël dara, lu wees li sama nit ñi lekk ba noppi ak sama wàllu farandoo yi, di Aner ak Eskol ak Mamre, ñoom it, nañu jot seen wàll.» ");
INSERT INTO wolmbs_vpl VALUES ("GN15_1","002_15_1","GEN","15","1","1","Gannaaw ba loolu wéyee kàddug Aji Sax ji dikke na Ibraam wax jii ci peeñu, ne ko: «Yaw Ibraam, bul ragal dara; man maay sa kiiraay, te sa yool dina màgg lool.» ");
INSERT INTO wolmbs_vpl VALUES ("GN15_2","002_15_2","GEN","15","2","2","Ibraam ne ko: «Boroom bi, yaw Aji Sax ji, ana loo may may nag? Man awma doom sax, te ki wara donn sama alal moo di Elyeser, miy waa Damaas.» ");
INSERT INTO wolmbs_vpl VALUES ("GN15_3","002_15_3","GEN","15","3","3","Ibraam teg ca ne: «Mayoo ma giir, te it jaam bu juddoo sama kër moo may donn.» ");
INSERT INTO wolmbs_vpl VALUES ("GN15_4","002_15_4","GEN","15","4","4","Kàddug Aji Sax ji nag dikkal ko, ne ko: «Du moom moo lay donn, waaye ku sosoo ci sa geño moo lay donn.» ");
INSERT INTO wolmbs_vpl VALUES ("GN15_5","002_15_5","GEN","15","5","5","Loolu wees Aji Sax ji yóbbu ko ci biti ne ko: «Xoolal asamaan, te waññ biddiiw yi, ndegam man nga ko.» Mu dellu ne ko: «Noonu la sa askan di tollu.» ");
INSERT INTO wolmbs_vpl VALUES ("GN15_6","002_15_6","GEN","15","6","6","Ibraam nag gëm Aji Sax ji; Aji Sax ji nangul ko ngëmam, muy àtteb njub bu ñu ko limal. ");
INSERT INTO wolmbs_vpl VALUES ("GN15_7","002_15_7","GEN","15","7","7","Gannaaw loolu Aji Sax ji wax ko ne ko: «Man maay Aji Sax ji la génnee Ur, ga ca Kaldeen ña, ngir may la réew mii, nga moom ko.» ");
INSERT INTO wolmbs_vpl VALUES ("GN15_8","002_15_8","GEN","15","8","8","Ibraam ne ko: «Yaw Aji Sax ji sama Boroom, nan la may wóore ne maa koy moom?» ");
INSERT INTO wolmbs_vpl VALUES ("GN15_9","002_15_9","GEN","15","9","9","Aji Sax ji ne ko: «Indil ma wëlluw ñetti at ak bëyu ñetti at ak kuuyu ñetti at, boole ci pitaxu àll ak xati mu ndaw.» ");
INSERT INTO wolmbs_vpl VALUES ("GN15_10","002_15_10","GEN","15","10","10","Ibraam boole yooyu yépp, rey, lu ci nekk mu dagg ko ci digg bi, dog bu nekk janook moroom ma, waaye daggul picc ya. ");
INSERT INTO wolmbs_vpl VALUES ("GN15_11","002_15_11","GEN","15","11","11","Ba mu ko defee ay tan jóge ca, dal ca kaw yàpp wa, Ibraam nag dàq leen. ");
INSERT INTO wolmbs_vpl VALUES ("GN15_12","002_15_12","GEN","15","12","12","Ba jant bay so, ngëmment lu réy a ko jàpp, tiitaange ju mag, ànd ak lëndëm gu ne këruus, ne milib ci kawam. ");
INSERT INTO wolmbs_vpl VALUES ("GN15_13","002_15_13","GEN","15","13","13","Aji Sax ji wax Ibraam ne ko: «Déglul bu baax li ma lay wax: saw askan dinañu nekk ay doxandéem ci réew mu ñu moomul, te dees na leen def ay jaam, mitital leen diiru ñeenti téeméeri at (400). ");
INSERT INTO wolmbs_vpl VALUES ("GN15_14","002_15_14","GEN","15","14","14","Waaye waa réew moomu leen di def ay jaam, dinaa leen àtte. Gannaaw loolu sa askan dina ca génn, ànd ak alal ju bare. ");
INSERT INTO wolmbs_vpl VALUES ("GN15_15","002_15_15","GEN","15","15","15","Yaw nag dinga gudd fan lool, doora génn àddina, ñu denc la, nga fekki say maam ci jàmm. ");
INSERT INTO wolmbs_vpl VALUES ("GN15_16","002_15_16","GEN","15","16","16","Say sët-sëtaat ay délsi fii bu seen jamono jotee, ndaxte bàkkaaru Amoreen ñi jéggeegul dayo.» ");
INSERT INTO wolmbs_vpl VALUES ("GN15_17","002_15_17","GEN","15","17","17","Ba jant sowee, ba guddi jot, njaq luy saxaar, ànd ak jum buy tàkk, daldi jaar ci diggante dogi yàpp yooyu. ");
INSERT INTO wolmbs_vpl VALUES ("GN15_18","002_15_18","GEN","15","18","18","Keroog Aji Sax ji fas na kóllëre digganteem ak Ibraam, ne ko: «Askan wi soqikoo ci yaw laa jox réew mii dale ci dexu Misra, ba ca dex gu mag googee di Efraat, ");
INSERT INTO wolmbs_vpl VALUES ("GN15_19","002_15_19","GEN","15","19","19","mooy réewu Keneen ñi ak Keniseen ñi ak Kadmoneen ñi ");
INSERT INTO wolmbs_vpl VALUES ("GN15_20","002_15_20","GEN","15","20","20","ak Etteen ñi ak Periseen ñi ak Refayeen ñi, ");
INSERT INTO wolmbs_vpl VALUES ("GN15_21","002_15_21","GEN","15","21","21","boole ci réewum Amoreen ñi ak Kanaaneen ñi ak Girgaseen ñi ak Yebuseen ñi.» ");
INSERT INTO wolmbs_vpl VALUES ("GN16_1","002_16_1","GEN","16","1","1","Sarayi amul woon doom ak boroom këram Ibraam. Waaye fekk na mu am jaam bu juddoo Misra te tudd Ajara. ");
INSERT INTO wolmbs_vpl VALUES ("GN16_2","002_16_2","GEN","16","2","2","Sarayi ne Ibraam: «Li am mooy Aji Sax ji deful ma am doom. Kon ngalla waay, jëlal sama jaam bi, tëdd ak moom ndax Yàlla def, mu amal ma doom ju góor.» Ibraam nag dégg la Sarayi wax. ");
INSERT INTO wolmbs_vpl VALUES ("GN16_3","002_16_3","GEN","16","3","3","Looloo ngi am, gannaaw ba Ibraam dëkkee fukki at ca réewu Kanaan. Sarayi daldi jël Ajara, jaamam bi juddoo Misra, jox ko jëkkëram Ibraam, ngir mu tëdd ak moom. ");
INSERT INTO wolmbs_vpl VALUES ("GN16_4","002_16_4","GEN","16","4","4","Loolu wees Ibraam séy ak Ajara, mu daldi ëmb. Ajara yég ne ëmb na, indi nag yabeel digganteem ak sangam Sarayi. ");
INSERT INTO wolmbs_vpl VALUES ("GN16_5","002_16_5","GEN","16","5","5","Sarayi nag wax Ibraam ne ko: «Tooñ gi ma Ajara di tooñ, yaa ma ko yóbbe! Maa la jox sama jaam, ngir nga tëdd ak moom, naam, waaye moom, naka la yég ne ëmb na rekk, daldi indi yabeel sama digganteek moom. Kon yal na ma Aji Sax ji àtteek yaw!» ");
INSERT INTO wolmbs_vpl VALUES ("GN16_6","002_16_6","GEN","16","6","6","Ibraam wax Sarayi ne ko: «Sa jaam a ngoog ci say loxo, def ko lu la neex.» Sarayi nag di toroxal Ajara, ba mu daw, ba soreek moom. ");
INSERT INTO wolmbs_vpl VALUES ("GN16_7","002_16_7","GEN","16","7","7","Ba mu dawee, malaakam Aji Sax ja gis ko fu dend akub bëtu ndox ca màndiŋ ma, mooy bëtu ndox ba ca yoonu Sur. ");
INSERT INTO wolmbs_vpl VALUES ("GN16_8","002_16_8","GEN","16","8","8","Mu ne ko: «Yaw Ajara, jaamu Sarayi bi, foo bàyyikoo nii? Ak foo jëm?» Mu ne ko: «Damay daw ba fu soreek sama sang Sarayi.» ");
INSERT INTO wolmbs_vpl VALUES ("GN16_9","002_16_9","GEN","16","9","9","Malaakam Aji Sax ja ne ko: «Dellul ca sa sang, te nga yem ciy loxoom.» ");
INSERT INTO wolmbs_vpl VALUES ("GN16_10","002_16_10","GEN","16","10","10","Mu teg ca ne ko: «Dinaa yokk sa askan lool, ba kenn du leen mana waññ,» ");
INSERT INTO wolmbs_vpl VALUES ("GN16_11","002_16_11","GEN","16","11","11","tegaat ca ne ko: «Léegi jigéenu wérul nga, te dinga am doom ju góor; nanga ko tudde Ismayla (muy firi Yàlla dégg na), ndax Aji Sax ji yég na sa naqar. ");
INSERT INTO wolmbs_vpl VALUES ("GN16_12","002_16_12","GEN","16","12","12","Ismaylaay tiiñe, ni mbaamu àll mu deesul noot, di noonoo ñépp, ñépp noonoo ko. Mooy sanc fu muy jàkkaarlook bokkam yépp.» ");
INSERT INTO wolmbs_vpl VALUES ("GN16_13","002_16_13","GEN","16","13","13","Ajara nag tudde Aji Sax ji wax ak moom, Ata El Roy (muy firi Yaa di Yàlla jiy gis), ndaxte da ne: «Moo man! Moona gis naa Yàlla, moom it mu gisal ma boppam de!» ");
INSERT INTO wolmbs_vpl VALUES ("GN16_14","002_16_14","GEN","16","14","14","Loolu moo tax ñu tudde teen booba teenu Laxay Roy (muy firi teenu Aji Dund ji may gis); mu nga nekk diggante Kades ak Beredd. ");
INSERT INTO wolmbs_vpl VALUES ("GN16_15","002_16_15","GEN","16","15","15","Ba loolu weesoo Ajara amal Ibraam doom ju góor. Ibraam tudde doom ji Ismayla. ");
INSERT INTO wolmbs_vpl VALUES ("GN16_16","002_16_16","GEN","16","16","16","Ba Ajaray am Ismayla, Ibraam a ngi tollu woon ci juróom ñett fukki at ak juróom benn (86). ");
INSERT INTO wolmbs_vpl VALUES ("GN17_1","002_17_1","GEN","17","1","1","Ba Ibraam amee juróom ñeent fukki at ak juróom ñeent (99), am na bés Aji Sax ji feeñu ko ne ko: «Man maay Yàlla Aji Man ji. Topp ma te mat sëkk. ");
INSERT INTO wolmbs_vpl VALUES ("GN17_2","002_17_2","GEN","17","2","2","Dinaa feddali sama kóllëre ak yaw, yokk la bu baax.» ");
INSERT INTO wolmbs_vpl VALUES ("GN17_3","002_17_3","GEN","17","3","3","Ibraam dégg loola, daldi sujjóot. Yàlla wax ak moom ne ko: ");
INSERT INTO wolmbs_vpl VALUES ("GN17_4","002_17_4","GEN","17","4","4","«Man ci sama wàllu bopp, kóllëre gi ma fas ak yaw mooy lii. Dinga nekk maamu xeet yu baree bare. ");
INSERT INTO wolmbs_vpl VALUES ("GN17_5","002_17_5","GEN","17","5","5","Te tuddatuloo Ibraam; léegi yaa di Ibraayma (muy firi Maamu ñu bare), ndax maa la def ngay maamu xeet yu baree bare. ");
INSERT INTO wolmbs_vpl VALUES ("GN17_6","002_17_6","GEN","17","6","6","Dinaa la defal njaboot gu ne xas, ay xeet sosoo ci yaw, ba ay buur soqikoo ci yaw. ");
INSERT INTO wolmbs_vpl VALUES ("GN17_7","002_17_7","GEN","17","7","7","Te dinaa feddali sama kóllëre gi ci sama diggante ak yaw, yaak sa askan, muy kóllëre guy sax maasoo maas ba fàww. Maay doon sa Yàlla, yaak sa askan. ");
INSERT INTO wolmbs_vpl VALUES ("GN17_8","002_17_8","GEN","17","8","8","Te réew mi nga doon ab doxandéem léegi, muy réewu Kanaan mépp, jox naa la ko, yaak sa askan, ngeen moom ko fàww. Te dinaa doon seen Yàlla.» ");
INSERT INTO wolmbs_vpl VALUES ("GN17_9","002_17_9","GEN","17","9","9","Gannaaw loolu Yàlla waxaat na Ibraayma ne ko: «Yaw nag, sàmmal sama kóllëre, yaak sa askan ak say sët ak say sëtaat. ");
INSERT INTO wolmbs_vpl VALUES ("GN17_10","002_17_10","GEN","17","10","10","Kóllëre gi ma fas ak yaw, te nga war koo sàmm, yaak sa askan, li mu laaj mooy lii: Góor gu nekk ci yeen, war naa xaraf. ");
INSERT INTO wolmbs_vpl VALUES ("GN17_11","002_17_11","GEN","17","11","11","Xaraf mooy màndargaal kóllëre googu ma fas ak yeen. ");
INSERT INTO wolmbs_vpl VALUES ("GN17_12","002_17_12","GEN","17","12","12","Xale bu góor, bu amee juróom ñetti fan war naa xaraf. Képp kuy góor ci seen maasoo maas, war naa xaraf, ba ci jaam bu juddoo sa kër, mbaa ku ñu jënd ci sa xaalis, ak bépp doomu doxandéem boo jurul. ");
INSERT INTO wolmbs_vpl VALUES ("GN17_13","002_17_13","GEN","17","13","13","Jaam bu juddoo sa kër ak boo jënd, ñoom ñaar ñépp, dees leen wara xarafal. Xaraf ay màndargaal sama kóllëre ci seen yaram, muy kóllëre gu sax ba fàww. ");
INSERT INTO wolmbs_vpl VALUES ("GN17_14","002_17_14","GEN","17","14","14","Góor gu xaraful, ndax nanguwula xaraf, dees na ko dagge ci biir xeetam, ndax sàmmul sama kóllëre.» ");
INSERT INTO wolmbs_vpl VALUES ("GN17_15","002_17_15","GEN","17","15","15","Ba loolu weesoo Yàlla waxaat na Ibraayma, ne ko: «Sa soxna tuddatul Sarayi; léegi moo di Saarata. ");
INSERT INTO wolmbs_vpl VALUES ("GN17_16","002_17_16","GEN","17","16","16","Dinaa ko barkeel, may la ak moom doom ju góor; dinaa ko barkeel moos, ba mu jaboote xeet yu bare, te ay buuri xeet sax dinañu soqikoo ci moom.» ");
INSERT INTO wolmbs_vpl VALUES ("GN17_17","002_17_17","GEN","17","17","17","Bi Ibraayma déggee loolu, daa sujjóot, ree. Booba ma nga naan ci xelam: «Góoru téeméeri at, ndax dina mana am doom waay? Te Saarata, mi am juróom ñeent fukki at (90) sax, manati naa am doom a?» ");
INSERT INTO wolmbs_vpl VALUES ("GN17_18","002_17_18","GEN","17","18","18","Ibraayma ne Yàlla: «Moo, tee ngaa saxal Ismayla rekk te ànd ak moom?» ");
INSERT INTO wolmbs_vpl VALUES ("GN17_19","002_17_19","GEN","17","19","19","Yàlla ne ko: «Waaw, waaye du tere sa soxna Saarata amal la doom ju góor, nga tudde ko nag Isaaxa. Dinaa fas ak moom sama kóllëre, mu wéy ba ciy sëtam ba fàww. ");
INSERT INTO wolmbs_vpl VALUES ("GN17_20","002_17_20","GEN","17","20","20","Bu dee ci wàllu Ismayla, nangul naa la ba tey. Ndax kat dinaa ko barkeel, jox ko njaboot gu yaa, yokk ko bu baax. Dina jur fukki kilifa ak ñaar yu mag, te dinaa ko defal mu sos xeet wu yaa. ");
INSERT INTO wolmbs_vpl VALUES ("GN17_21","002_17_21","GEN","17","21","21","Waaye sama kóllëre nag, Isaaxa laa koy fasool, moom Isaaxa, mi Saarata di am, nëgëni déwén.» ");
INSERT INTO wolmbs_vpl VALUES ("GN17_22","002_17_22","GEN","17","22","22","Loola la Yàlla wax Ibraayma, daldi fay bàyyikoo. ");
INSERT INTO wolmbs_vpl VALUES ("GN17_23","002_17_23","GEN","17","23","23","Ba loolu amee Ibraayma boole doomam Ismayla, ak jaam yi juddoo këram yépp, ak ñi mu jëndoon ci xaalisam ñépp, góori waa këram ñépp, xarafal leen ca bés ba, muy la ko Yàlla waxoon. ");
INSERT INTO wolmbs_vpl VALUES ("GN17_24","002_17_24","GEN","17","24","24","Ibraayma amoon na juróom ñeent fukki at ak juróom ñeent (99), bi muy xaraf; ");
INSERT INTO wolmbs_vpl VALUES ("GN17_25","002_17_25","GEN","17","25","25","doomam Ismayla am fukki at ak ñett, bi ñu koy xarafal. ");
INSERT INTO wolmbs_vpl VALUES ("GN17_26","002_17_26","GEN","17","26","26","Bésub keroog la Ibraayma xaraf, moom ak doomam Ismayla ");
INSERT INTO wolmbs_vpl VALUES ("GN17_27","002_17_27","GEN","17","27","27","ak mboolem góori këram, muy jaam ya fa juddoo mbaa ñu mu jënd ci ay doxandéem, ñoom ñépp a ànd ak moom xaraf. ");
INSERT INTO wolmbs_vpl VALUES ("GN18_1","002_18_1","GEN","18","1","1","Am na bés, Aji Sax ji feeñu Ibraayma ca garabi Mamre yu mag ya. Booba ma nga toogoon ca buntu xaymaam ci digg njolloor. ");
INSERT INTO wolmbs_vpl VALUES ("GN18_2","002_18_2","GEN","18","2","2","Naka la siggi, gis ñetti nit, ñu ne jimeet ci kanamam. Ibraayma gaawtu, gatandu leen, sujjóotal leen. ");
INSERT INTO wolmbs_vpl VALUES ("GN18_3","002_18_3","GEN","18","3","3","Mu daldi ne: «Sang bi, siyaare naa la. Ngalla waay, bu ma romb. ");
INSERT INTO wolmbs_vpl VALUES ("GN18_4","002_18_4","GEN","18","4","4","Xaarleen, ñu indil leen tuuti ndox, ngeen jàngu te noppalu ci ker garab gi. ");
INSERT INTO wolmbs_vpl VALUES ("GN18_5","002_18_5","GEN","18","5","5","Maa ngi leen di indil dogu mburu mu ngeen dëgërloo, ba mana topp seen yoon, gannaaw nangu ngeena toog, ma siyaare leen.» Ñu ne ko: «Waaw, baax na.» ");
INSERT INTO wolmbs_vpl VALUES ("GN18_6","002_18_6","GEN","18","6","6","Ibraayma daldi gaaw, dugg biir xayma ba, ne Saarata: «Gaawal, jël ñetti ndabi sunguf su mucc ayib, noot ko, def ko mburu yu ndaw.» ");
INSERT INTO wolmbs_vpl VALUES ("GN18_7","002_18_7","GEN","18","7","7","Ibraayma nag daw ca gétt ga, sàkk fa sëllu wu duuf te baax, ñëw jox ko jaamam, mu gaaw togg ko. ");
INSERT INTO wolmbs_vpl VALUES ("GN18_8","002_18_8","GEN","18","8","8","Ibraayma taajal leen ndawal, la ñu togg, ba mu sotti, indaaleel leen soow ak meew mu bees. Ma nga taxaw ca seen wet ca ker garab ga, ñuy lekk. ");
INSERT INTO wolmbs_vpl VALUES ("GN18_9","002_18_9","GEN","18","9","9","Ñu daldi ko laaj ne ko: «Ana sa soxna Saarata?» Mu ne leen: «Mu ngi ci biir.» ");
INSERT INTO wolmbs_vpl VALUES ("GN18_10","002_18_10","GEN","18","10","10","Kooka ne ko: «Nëgëni sii déwén déy laay délsi, te sa soxna Saarata dina am doom ju góor moos.» Bi muy wax loolu, Saarataa ngi ci buntu xayma bi ci gannaawam, di déglu. ");
INSERT INTO wolmbs_vpl VALUES ("GN18_11","002_18_11","GEN","18","11","11","Booba fekk na Ibraayma ak Saarata doon mag, ba màggat lool sax, te Saarata weesoon na njurum doom. ");
INSERT INTO wolmbs_vpl VALUES ("GN18_12","002_18_12","GEN","18","12","12","Ci kaw loolu Saarata ree ci suuf, daldi ne: «Man mu ñor xomm mii, ndax man naa amati boobu bànneex, te sama boroom kër it di mag?» ");
INSERT INTO wolmbs_vpl VALUES ("GN18_13","002_18_13","GEN","18","13","13","Aji Sax ji daldi wax Ibraayma ne ko: «Lu Saarata di ree, te naan: “Man mu màggat mii, deeti naa am doom moos?” ");
INSERT INTO wolmbs_vpl VALUES ("GN18_14","002_18_14","GEN","18","14","14","Ana lu të Aji Sax ji? Bu ñu ca àggee nëgëni déwén déy, dinaa fi délsiwaat, te Saarata dina am doom ju góor.» ");
INSERT INTO wolmbs_vpl VALUES ("GN18_15","002_18_15","GEN","18","15","15","Saarata dégg loolu, daldi tiit, miim ko ne: «Reetaanuma de.» Teewul Aji Sax ji ne ko: «Ree nga kay!» ");
INSERT INTO wolmbs_vpl VALUES ("GN18_16","002_18_16","GEN","18","16","16","Gannaaw loolu gan ña jóge foofa, tiim Sodom, di ko séen. Ibraayma ànd ak ñoom, di leen gunge. ");
INSERT INTO wolmbs_vpl VALUES ("GN18_17","002_18_17","GEN","18","17","17","Booba Aji Sax jaa ngi wax naan: «Xanaa duma nëbb Ibraayma li ma nar? ");
INSERT INTO wolmbs_vpl VALUES ("GN18_18","002_18_18","GEN","18","18","18","Ndax kat Ibraayma dina sos xeet wu mag te am doole, te xeeti àddina yépp ci moom lañuy barkeele. ");
INSERT INTO wolmbs_vpl VALUES ("GN18_19","002_18_19","GEN","18","19","19","Moo tax ma tànn ko, ngir mu sant ay doomam ak waa këram, ñuy déggal Aji Sax ji, di jëfe yoon ak njub. Noonu laay defale Ibraayma li ma ko digoon.» ");
INSERT INTO wolmbs_vpl VALUES ("GN18_20","002_18_20","GEN","18","20","20","Aji Sax ji nag àddu ne: «Bàkkaari Sodom ak Gomor bare na lool, ba may dégg yuux, yi sababoo ci seen moy. ");
INSERT INTO wolmbs_vpl VALUES ("GN18_21","002_18_21","GEN","18","21","21","Dinaa wàcc, seede ko, ba mu wóor ne ñoo def lépp li sabab yuux yi, am déet.» ");
INSERT INTO wolmbs_vpl VALUES ("GN18_22","002_18_22","GEN","18","22","22","Gan ña nag dem, jublu Sodom, Ibraayma moom taxaw ba tey, fi kanam Aji Sax ji. ");
INSERT INTO wolmbs_vpl VALUES ("GN18_23","002_18_23","GEN","18","23","23","Naka la Ibraayma jegeñsi, ne ko: «Mbaa doo boole ku jub ak ku jubadi, rey leen? ");
INSERT INTO wolmbs_vpl VALUES ("GN18_24","002_18_24","GEN","18","24","24","Su juróom fukk rekk jubee ca dëkk bi, mbaa doo tas dëkk bi ba tey, tee nga leena jéggal rekk ngir juróom fukk ñu jub ña ca nekk? ");
INSERT INTO wolmbs_vpl VALUES ("GN18_25","002_18_25","GEN","18","25","25","Rikk bul yemale ku jub ak ku jubadi, ba boole leen rey, loolu jomb na la moos! Yaw miy àtte àddina sépp kay, lu jub rekk ngay def!» ");
INSERT INTO wolmbs_vpl VALUES ("GN18_26","002_18_26","GEN","18","26","26","Aji Sax ji ne ko: «Su ma gisee ci Sodom juróom fukk ñu jub, dinaa jéggal waa dëkk bi yépp ngir ñoom.» ");
INSERT INTO wolmbs_vpl VALUES ("GN18_27","002_18_27","GEN","18","27","27","Ibraayma dellu ne: «Ma ñemee wax ak yaw, Boroom bi, te duma dara ba dara booloo jeex. ");
INSERT INTO wolmbs_vpl VALUES ("GN18_28","002_18_28","GEN","18","28","28","Waaye juróom fukk ñooñu jub, su yéesee juróom rekk nag? Mbaa doo tas dëkk bi ndax juróom ñi ci yées?» Aji Sax ji ne ko: «Su ma fa gisee ñeent fukk ak juróom ñu jub, duma ko tas.» ");
INSERT INTO wolmbs_vpl VALUES ("GN18_29","002_18_29","GEN","18","29","29","Ibraayma dellu wax ne: «Su fa ñeent fukk ñu jub rekk amee nag?» Aji Sax ji ne ko: «Duma def dara ngir ñeent fukk ñooñu.» ");
INSERT INTO wolmbs_vpl VALUES ("GN18_30","002_18_30","GEN","18","30","30","Ibraayma dellooti ne: «Rikk Boroom bi, bu ma mere. Dinaa ci teg lii. Su fa fanweer ñu jub rekk amee nag?» Aji Sax ji ne ko: «Su fa fanweer ñu jub amee, kon duma def dara.» ");
INSERT INTO wolmbs_vpl VALUES ("GN18_31","002_18_31","GEN","18","31","31","Ibraayma neeti: «Léegi ma ñemeeti wax ak yaw boog, Boroom bi! Su ñu doon ñaar fukk rekk nag?» Aji Sax ji ne ko: «Kon duma ko tas ngir ñaar fukk ñooñu.» ");
INSERT INTO wolmbs_vpl VALUES ("GN18_32","002_18_32","GEN","18","32","32","Ibraayma dellu neeti: «Ngalla Boroom bi, bul mer, ma wax bii yoon rekk te noppi. Léegi su ñu dee fukk doŋŋ nag?» Aji Sax ji ne ko: «Kon duma tas dëkk bi, ndax fukk ñooñu jub.» ");
INSERT INTO wolmbs_vpl VALUES ("GN18_33","002_18_33","GEN","18","33","33","Loolu la Aji Sax ji wax ak Ibraayma, daldi dëddu. Ibraayma it ñibbi këram. ");
INSERT INTO wolmbs_vpl VALUES ("GN19_1","002_19_1","GEN","19","1","1","Ba loolu amee ñaari malaaka ya dikk Sodom ca ngoon, fekk Lóot toog ca buntu dëkk ba. Lóot séen leen, jóg gatandu leen, daldi leen sujjóotal, ne leen: ");
INSERT INTO wolmbs_vpl VALUES ("GN19_2","002_19_2","GEN","19","2","2","«Dégluleen ma, ngalla sang yi, siyaare naa leen, tee ngeena dal ak man, su ko defee ngeen jàngu, fanaan ba suba, ngeen xëy topp seen yoon?» Ñu ne ko: «Bàyyil, nu fanaan ci mbedd mi.» ");
INSERT INTO wolmbs_vpl VALUES ("GN19_3","002_19_3","GEN","19","3","3","Lóot nag soññ leen, ba ñu dal këram, mu ganale leen. Lóot da leena berndeel, lakkal leen mburu mu amul lawiir, ñu lekk. ");
INSERT INTO wolmbs_vpl VALUES ("GN19_4","002_19_4","GEN","19","4","4","Teewul bala ñoo tëdd, góori Sodom, mag ak ndaw, daldi jóge gox bu nekk, ñëw yéew kër ga. ");
INSERT INTO wolmbs_vpl VALUES ("GN19_5","002_19_5","GEN","19","5","5","Ñu daldi woo Lóot ne ko: «Ana góor ñi fi ñëw tey ci guddi? Génneel nu leen fii, ndax nu mana àgg seen kaw.» ");
INSERT INTO wolmbs_vpl VALUES ("GN19_6","002_19_6","GEN","19","6","6","Lóot génn, fekk leen ca buntu kër ga ca biti, daldi tëj bunt ba. ");
INSERT INTO wolmbs_vpl VALUES ("GN19_7","002_19_7","GEN","19","7","7","Mu ne leen: «Bokk yi, ngalla buleen def lu bon loolu waay! ");
INSERT INTO wolmbs_vpl VALUES ("GN19_8","002_19_8","GEN","19","8","8","Dégluleen, ma wax leen; man, am naa ñaari doom yu jigéen, te xamuñu góor. Mayleen ma, ma yót leen leen, ngeen def leen lu leen neex. Rikk buleen def góor ñii dara, ndaxte samay gan lañu.» ");
INSERT INTO wolmbs_vpl VALUES ("GN19_9","002_19_9","GEN","19","9","9","Ñu ne ko: «Toppal fale!» te naan: «Waay! Waa jii dal ci sunu dëkk bi rekk, bëgg di fi àtte! Léegi nag dinanu la def lu raw li nu bëggoona def say gan.» Ñu song Lóot, ba nara dàjji bunt ba. ");
INSERT INTO wolmbs_vpl VALUES ("GN19_10","002_19_10","GEN","19","10","10","Teewul gan ña yoor seeni loxo, ñoddi Lóot ba ci biir, tëj bunt ba. ");
INSERT INTO wolmbs_vpl VALUES ("GN19_11","002_19_11","GEN","19","11","11","Ba loolu amee ñu gumbaal nit ña nekkoon ca buntu kër ga, mag ak ndaw, ñuy làmbatu bunt ba, ba sonn, bàyyi. ");
INSERT INTO wolmbs_vpl VALUES ("GN19_12","002_19_12","GEN","19","12","12","Ba loolu wéyee gan ña wax Lóot ne ko: «Boo amee mbokk ci dëkk bi, muy sa doom ju góor mbaa ju jigéen, mbaa kuy denc sa doom—koo fi am, génne ko fi, ");
INSERT INTO wolmbs_vpl VALUES ("GN19_13","002_19_13","GEN","19","13","13","ndax dinanu ko tas de. Aji Sax ji dégg na jooytu yu réy, yi niti dëkk bi sabab, ba tax mu yónni nu, ngir nu ñëw tas ko.» ");
INSERT INTO wolmbs_vpl VALUES ("GN19_14","002_19_14","GEN","19","14","14","Lóot daldi génn, wax ak goroom, ya naroona takk ay doomam yu jigéen, ne leen: «Gaawleen gaaw, génn dëkk bi, ndaxte Aji Sax ji dina ko tas.» Teewul ñu defe ne day kaf. ");
INSERT INTO wolmbs_vpl VALUES ("GN19_15","002_19_15","GEN","19","15","15","Fajar a ngay xar, malaaka ya fuug Lóot ne ko: «Gaawal gaaw, ànd ak sa soxna ak sa ñaari doom yu jigéen yii, ba bu Yàlla tasee dëkk bi, dungeen sànku.» ");
INSERT INTO wolmbs_vpl VALUES ("GN19_16","002_19_16","GEN","19","16","16","Lóot di tendeefal, gan ña jàpp ci loxo bi, booleek soxnaam ak ñaari doomam génne, làq leen ca gannaaw dëkk ba, ndax yërmande ju Aji Sax ji am ci Lóot. ");
INSERT INTO wolmbs_vpl VALUES ("GN19_17","002_19_17","GEN","19","17","17","Ba ñu leen génnee, kenn ci ñoom ne Lóot: «Dawal sa xélu bakkan, bul geestu, bul taxaw fenn ci joor gi. Dawal ca tund ya, bala ngaa dee.» ");
INSERT INTO wolmbs_vpl VALUES ("GN19_18","002_19_18","GEN","19","18","18","Lóot nag ne ko: «Déet, sang bi! ");
INSERT INTO wolmbs_vpl VALUES ("GN19_19","002_19_19","GEN","19","19","19","Defal nga ma yiw, yërëm ma lool, ba musal ma. Waaye bala maa daw, ba àgg ca tund ya, musiba mii man naa dal ci sama kaw, ma dee. ");
INSERT INTO wolmbs_vpl VALUES ("GN19_20","002_19_20","GEN","19","20","20","Gisuloo dëkk bale; jege na, te dëkk bu tuut la, am déet? Ma daw, làquji fa boog, ba mucc?» ");
INSERT INTO wolmbs_vpl VALUES ("GN19_21","002_19_21","GEN","19","21","21","Malaaka ma ne ko: «Waaw baax na ba tey, duma tas dëkk boobu ngay wax. ");
INSERT INTO wolmbs_vpl VALUES ("GN19_22","002_19_22","GEN","19","22","22","Nanga gaaw nag, làquji fa, ndax duma mana def dara te àgguloo fa.» Loolu moo tax ñu tudde dëkk boobu Cowar (muy firi Bu tuut). ");
INSERT INTO wolmbs_vpl VALUES ("GN19_23","002_19_23","GEN","19","23","23","Ba jant bay fenk, Lóot dugg na Cowar. ");
INSERT INTO wolmbs_vpl VALUES ("GN19_24","002_19_24","GEN","19","24","24","Aji Sax ji nag yuree ca asamaan tamarax buy tàkk, muy taw ci kaw Sodom ak Gomor, na ko Aji Sax ji dogale. ");
INSERT INTO wolmbs_vpl VALUES ("GN19_25","002_19_25","GEN","19","25","25","Mu daldi tas mboolem dëkki joor ga, boole ca nit ña ak gàncax gépp. ");
INSERT INTO wolmbs_vpl VALUES ("GN19_26","002_19_26","GEN","19","26","26","Ci kaw loolu soxnas Lóot ne gees, jëmm ja far soppaliku xorom. ");
INSERT INTO wolmbs_vpl VALUES ("GN19_27","002_19_27","GEN","19","27","27","Ca ëllëg sa Ibraayma teela jóg, dem fa mu taxawoon jàkkaarlook Aji Sax ji. ");
INSERT INTO wolmbs_vpl VALUES ("GN19_28","002_19_28","GEN","19","28","28","Naka la séen Sodom ak Gomor ak joor ga ba fa mu yem, gis nag saxaar suy gillee ci suuf, mel ni saxaaru taalu ban. ");
INSERT INTO wolmbs_vpl VALUES ("GN19_29","002_19_29","GEN","19","29","29","Ndaxam bi Yàllay tas dëkki joor ga, xalaat na Ibraayma, ba musal Lóot ca dogalam boobee, keroog ba mu tasee dëkk ya Lóot daloon. ");
INSERT INTO wolmbs_vpl VALUES ("GN19_30","002_19_30","GEN","19","30","30","Gannaaw loolu Lóot ragala dëkk Cowar, ba toxoo fa, ànd ak ñaari doomam yu jigéen, sanci ca tund ya. Mu dëkk ci xuntum xeer, moom ak ñaari doomam yu jigéen. ");
INSERT INTO wolmbs_vpl VALUES ("GN19_31","002_19_31","GEN","19","31","31","Mu am bés, taaw bi wax rakk ji, ne ko: «Sunu baay a ngii màggat, te fii fépp amul góor gu nu mana séqal ci wàllu séy, ni ko waa àddina yépp baaxoo defe. ");
INSERT INTO wolmbs_vpl VALUES ("GN19_32","002_19_32","GEN","19","32","32","Kon nanu def nii: danuy nàndal sunu baay biiñ, tëdd ak moom, ngir sunu xeetu baay du fey.» ");
INSERT INTO wolmbs_vpl VALUES ("GN19_33","002_19_33","GEN","19","33","33","Ca guddi ga ñu nàndal seen baay biiñ, taaw ba dugg, tëdd ak baayam, te Lóot yégul ba fa doom jay tëdd ak ba muy jóg. ");
INSERT INTO wolmbs_vpl VALUES ("GN19_34","002_19_34","GEN","19","34","34","Ca ëllëg sa taaw ba wax rakk ji, ne ko: «Man tëdd naa ak sama baay biig; guddig tey it, danu koy nàndalaat biiñ, su ko defee nga dugg tëdd ak moom, ndax sunu xeetu baay du fey.» ");
INSERT INTO wolmbs_vpl VALUES ("GN19_35","002_19_35","GEN","19","35","35","Guddi jot, ñu nàndalaat seen baay biiñ, rakk ja dem tëdd ak baayam, te Lóot yégul ba fa doom jay tëdd ak ba muy jóg. ");
INSERT INTO wolmbs_vpl VALUES ("GN19_36","002_19_36","GEN","19","36","36","Noonu la ñaari doomi Lóot def ak seen baay, daldi cay doxe ëmb. ");
INSERT INTO wolmbs_vpl VALUES ("GN19_37","002_19_37","GEN","19","37","37","Taaw ba am ca doom ju góor, tudde ko Mowab (muy firi Jóge ci baay). Mowab moo sos Mowabeen, ñi fi nekk ba tey. ");
INSERT INTO wolmbs_vpl VALUES ("GN19_38","002_19_38","GEN","19","38","38","Rakk ja moom it am doom ju góor, tudde ko Ben Aami (muy firi Sama doomu mbokk). Ben Aami moo sos Amoneen, ñi fi nekk ba tey. ");
INSERT INTO wolmbs_vpl VALUES ("GN20_1","002_20_1","GEN","20","1","1","Ba loolu amee Ibraayma jóge fa mu nekkoon, jublu àllub Negew, sanci diggante Kades ak Sur, ba noppi ganeji ay fan ca dëkk ba ñu naa Gerar. ");
INSERT INTO wolmbs_vpl VALUES ("GN20_2","002_20_2","GEN","20","2","2","Ba Ibraayma àggee nag, da ne soxnaam Saarata ab jigéenam la. Abimeleg buurub Gerar daldi yónnee jëlsi Saarata. ");
INSERT INTO wolmbs_vpl VALUES ("GN20_3","002_20_3","GEN","20","3","3","Teewul genn guddi Yàlla feeñu Abimeleg ci gént ne ko: «Yaw, dee nga ba noppi, ndax jigéen ji nga nangu, soxnas jàmbur la.» ");
INSERT INTO wolmbs_vpl VALUES ("GN20_4","002_20_4","GEN","20","4","4","Loolu fekk Abimeleg àndagul ak Saarata. Mu wax Yàlla ne ko: «Sama Boroom, mbaa doo bóom réew mi ci mbir mu ñu doonul dara? ");
INSERT INTO wolmbs_vpl VALUES ("GN20_5","002_20_5","GEN","20","5","5","Du góor gi da maa waxoon ne kii jigéenam la? Du jigéen ji it da maa waxoon ne kooku càmmiñam la? Fexewuma dara lu ñaaw te di ko tey de!» ");
INSERT INTO wolmbs_vpl VALUES ("GN20_6","002_20_6","GEN","20","6","6","Yàlla ne ko ca gént ga: «Waaw, xam naa ne li nga def du sa teyeef. Moo tax man it mayuma la nga laal ko, di ma tooñ. ");
INSERT INTO wolmbs_vpl VALUES ("GN20_7","002_20_7","GEN","20","7","7","Léegi nag dellool góor gi soxnaam, ab yonent la de, te dina la ñaanal, nga raw. Waaye soo ko deful, na la bir ne dinga dee, yaak sa waa kër yépp.» ");
INSERT INTO wolmbs_vpl VALUES ("GN20_8","002_20_8","GEN","20","8","8","Abimeleg jóg suba teel, woolu dagam yépp, nettali leen loolu lépp, ñu tiit lool. ");
INSERT INTO wolmbs_vpl VALUES ("GN20_9","002_20_9","GEN","20","9","9","Gannaaw loolu Abimeleg woolu Ibraayma ne ko: «Li nga nu def nag? Ndax dama laa tooñ, ba nga yóbbe ma tooñ gu réye nii, man ak sama réew mi mépp? Lii nga ma def de, waroo ko woona def.» ");
INSERT INTO wolmbs_vpl VALUES ("GN20_10","002_20_10","GEN","20","10","10","Abimeleg teg ca ne ko: «Te li nga def sax, lu la ci xiir?» ");
INSERT INTO wolmbs_vpl VALUES ("GN20_11","002_20_11","GEN","20","11","11","Ibraayma ne ko: «Da di dama noon, amul kenn ci réew mii ku ragal Yàlla, te dees na ma rey ndax sama soxna. ");
INSERT INTO wolmbs_vpl VALUES ("GN20_12","002_20_12","GEN","20","12","12","Te moona dëgg la sax, sama jigéen a, ndaxte danoo bokk baay te bokkunu yaay, ma jël ko. ");
INSERT INTO wolmbs_vpl VALUES ("GN20_13","002_20_13","GEN","20","13","13","Te bés, ba ma Yàlla génnee sama kër baay, may wëndeelu, dama koo waxoon ne ko: “Déglul, baaxe ma ci lii: Fépp fu nu dem, nanga wax ne sa càmmiñ laa.”» ");
INSERT INTO wolmbs_vpl VALUES ("GN20_14","002_20_14","GEN","20","14","14","Ba mu waxee ba noppi, Abimeleg jël ay xar aki nag ak ay jaam yu góor ak yu jigéen, jox ko Ibraayma, daldi ko delloo soxnaam Saarata. ");
INSERT INTO wolmbs_vpl VALUES ("GN20_15","002_20_15","GEN","20","15","15","Abimeleg ne ko: «Sama réew mépp a ngi noonu, dëkkal fu la neex.» ");
INSERT INTO wolmbs_vpl VALUES ("GN20_16","002_20_16","GEN","20","16","16","Gannaaw loolu mu wax Saarata ne ko: «Déglu ma fii, jox naa sa càmmiñ limu junniy dogi xaalis. Loolu dama koo def, ngir setal sa der ci kanam ñi nga dëkkal ñépp. Léegi nag ñépp xam nañu ne set nga wecc.» ");
INSERT INTO wolmbs_vpl VALUES ("GN20_17","002_20_17","GEN","20","17","18","Fekkoon na Aji Sax ji um jigéeni waa kër Abimeleg, ba kenn du ci am doom, du soxnaam, du ay jaamam, te li ko waral di Saarata soxnas Ibraayma. Ibraayma nag ñaan Yàlla; Yàlla def ñu wér, ba mana am doom. ");
INSERT INTO wolmbs_vpl VALUES ("GN21_1","002_21_1","GEN","21","1","1","Gannaaw loolu Aji Sax ji yéwéne na Saarata, ni mu ko waxe woon, defal ko li mu ko digoon. ");
INSERT INTO wolmbs_vpl VALUES ("GN21_2","002_21_2","GEN","21","2","2","Saarata ëmb, amal Ibraayma doom ju góor ci jamono, ji ko Yàlla waxoon, te fekk góor gi di màggat. ");
INSERT INTO wolmbs_vpl VALUES ("GN21_3","002_21_3","GEN","21","3","3","Ibraayma tudde doomu Saarata jaak moom, Isaaxa. ");
INSERT INTO wolmbs_vpl VALUES ("GN21_4","002_21_4","GEN","21","4","4","Ba bés ba délsee, Ibraayma xarafal doomam Isaaxa, ni ko ko Yàlla digale woon. ");
INSERT INTO wolmbs_vpl VALUES ("GN21_5","002_21_5","GEN","21","5","5","Ba Isaaxa di juddu, booba Ibraaymaa ngi woon ci téeméeri atam. ");
INSERT INTO wolmbs_vpl VALUES ("GN21_6","002_21_6","GEN","21","6","6","Saarata ne: «Yàllaaka maa bégal, may ree, ànd ak ku yég, nuy ree.» ");
INSERT INTO wolmbs_vpl VALUES ("GN21_7","002_21_7","GEN","21","7","7","Mu neeti: «Éy, ku noon Ibraayma, Saarataa ngay nàmpal! Teewul ma jural ko góor, te muy mag.» ");
INSERT INTO wolmbs_vpl VALUES ("GN21_8","002_21_8","GEN","21","8","8","Ba loolu amee doom ja màgg, ba bés, ba ñu ko feralee. Keroog Ibraayma def na bernde ju mag. ");
INSERT INTO wolmbs_vpl VALUES ("GN21_9","002_21_9","GEN","21","9","9","Saarata nag gis doomu Ajara mu Misra, doom ji Ajara am ak Ibraayma, muy ree. ");
INSERT INTO wolmbs_vpl VALUES ("GN21_10","002_21_10","GEN","21","10","10","Saarata ne Ibraayma: «Dàqal jaam bii, mook doomam, ndax doomu jaam bii du bokk ak sama doom ndono.» ");
INSERT INTO wolmbs_vpl VALUES ("GN21_11","002_21_11","GEN","21","11","11","Loolu Saarata wax naqari Ibraayma lool ndax li Ismayla di doomam, moom it. ");
INSERT INTO wolmbs_vpl VALUES ("GN21_12","002_21_12","GEN","21","12","12","Teewul Yàlla ne Ibraayma: «Bu la dara naqari ci xale bu góor bii, mook sa jaam bi. Defalal Saarata li mu la wax rekk, ndax ci Isaaxa lees di tudde saw askan. ");
INSERT INTO wolmbs_vpl VALUES ("GN21_13","002_21_13","GEN","21","13","13","Doomu jaam bi it, dinaa ci lawale aw xeet nag, ndaxte yaa ko jur.» ");
INSERT INTO wolmbs_vpl VALUES ("GN21_14","002_21_14","GEN","21","14","14","Ca ëllëg sa Ibraayma jóg suba teel, sàkk mburu, booleek mbuusu ndox, jox Ajara, mu gàddu. Mu daldi ko dénk Ismayla, yebal ko, mu dem. Ci kaw loolu muy wëndeelu ca màndiŋu Beerseba. ");
INSERT INTO wolmbs_vpl VALUES ("GN21_15","002_21_15","GEN","21","15","15","Ba ñu demee, ba ndox ma jeex, Ajara daa bàyyi xale bu góor bi ci taatu ngarab su ndaw, ");
INSERT INTO wolmbs_vpl VALUES ("GN21_16","002_21_16","GEN","21","16","16","dox, ba dànd ko lu tollook saanu fitt, toog nag jàkkaarlook moom te naa ci xelam: «Duma fekke mukk sama deewu doom.» Naka la toog foofa janook moom, ne yikkét jooy. ");
INSERT INTO wolmbs_vpl VALUES ("GN21_17","002_21_17","GEN","21","17","17","Ba mu ko defee Yàlla dégg baatu xale bu góor ba. Malaakam Yàlla ma àddoo asamaan, ne Ajara: «Ajara, lan la? Bul ragal dara, ndaxte Yàlla dégg na sa baatu doom ci diggante bii mu tollu. ");
INSERT INTO wolmbs_vpl VALUES ("GN21_18","002_21_18","GEN","21","18","18","Demal yékkati ko, may ko loxo, mu jóg. Dinaa def mu law, ba doon xeet wu yaa.» ");
INSERT INTO wolmbs_vpl VALUES ("GN21_19","002_21_19","GEN","21","19","19","Ci kaw loolu Yàlla muri ay bëtam, mu gis ab seyaan, daldi cay dem, duy mbuusam, ba mu fees, jox ca doomam, mu naan. ");
INSERT INTO wolmbs_vpl VALUES ("GN21_20","002_21_20","GEN","21","20","20","Yàlla nag ànd ak Ismayla, muy màgg, dëkk ca màndiŋ ma, di fittkat. ");
INSERT INTO wolmbs_vpl VALUES ("GN21_21","002_21_21","GEN","21","21","21","Ca àllub Paran la dëkkoon, yaayam wutali ko soxna ca réewum Misra. ");
INSERT INTO wolmbs_vpl VALUES ("GN21_22","002_21_22","GEN","21","22","22","Jamono yooyu Abimeleg àndoon na ak Pikol kilifay xarekatam, dem ci Ibraayma ne ko: «Gis naa ne Yàlla ànd na ak yaw, di àntal li ngay def lépp. ");
INSERT INTO wolmbs_vpl VALUES ("GN21_23","002_21_23","GEN","21","23","23","Léegi nag waatal ma fii ci Yàlla ne doo ma wor mukk, man ak samay doom, ba ci samay sët. Waatal ma ne noonee ma rafetoo woon ak yaw, ni ngay rafetoo ak man, maak waa réew mi nga dal.» ");
INSERT INTO wolmbs_vpl VALUES ("GN21_24","002_21_24","GEN","21","24","24","Ibraayma ne ko: «Waat naa ko.» ");
INSERT INTO wolmbs_vpl VALUES ("GN21_25","002_21_25","GEN","21","25","25","Ci kaw loolu Ibraayma tawat Abimeleg teen bu surgay Abimeleg nangu woon ci moom, aakimoo ko. ");
INSERT INTO wolmbs_vpl VALUES ("GN21_26","002_21_26","GEN","21","26","26","Abimeleg nag ne ko: «Xawma ku la def jooju jëf de, ndax yaw waxoo ma ci dara; guléet ma dégg ko tey.» ");
INSERT INTO wolmbs_vpl VALUES ("GN21_27","002_21_27","GEN","21","27","27","Ba loolu amee Ibraayma jël ay gàtt aki nag, may ko Abimeleg, ñu fasoo kóllëre ñoom ñaar. ");
INSERT INTO wolmbs_vpl VALUES ("GN21_28","002_21_28","GEN","21","28","28","Fekk na Ibraayma ber juróom ñaari xar yu jigéen. ");
INSERT INTO wolmbs_vpl VALUES ("GN21_29","002_21_29","GEN","21","29","29","Abimeleg nag ne Ibraayma: «Lu tax nga ber juróom ñaari xar yooyu?» ");
INSERT INTO wolmbs_vpl VALUES ("GN21_30","002_21_30","GEN","21","30","30","Ibraayma ne ko: «Jëlal xar yii ci sama loxo, muy firnde ne man maa gas teen bii.» ");
INSERT INTO wolmbs_vpl VALUES ("GN21_31","002_21_31","GEN","21","31","31","Looloo tax ñu tudde béreb boobu Beerseba (muy firi Teenu waat ga), ndaxte fa lañu waatoo woon ñoom ñaar. ");
INSERT INTO wolmbs_vpl VALUES ("GN21_32","002_21_32","GEN","21","32","32","Naka lañu fasoo kóllëre ca Beerseba, Abimeleg jóg ànd ak Pikol kilifay xarekatam, ñu ñibbi réewu Filisti. ");
INSERT INTO wolmbs_vpl VALUES ("GN21_33","002_21_33","GEN","21","33","33","Ibraayma nag jëmbat na garabu tamaris foofa ca Beerseba, tudd fa Aji Sax ji, Yàlla ji nekk ba fàww, ngir wormaal ko. ");
INSERT INTO wolmbs_vpl VALUES ("GN21_34","002_21_34","GEN","21","34","34","Ibraayma gane na réewu Filisti lu yàgg. ");
INSERT INTO wolmbs_vpl VALUES ("GN22_1","002_22_1","GEN","22","1","1","Gannaaw loolu am na bés Yàlla di nattu Ibraayma ne ko: «Ibraayma!» Mu ne ko: «Naam.» ");
INSERT INTO wolmbs_vpl VALUES ("GN22_2","002_22_2","GEN","22","2","2","Yàlla ne ko: «Ngalla jëlal sa jenn doom jii di Isaaxa, muy koo bëgg, nga dem ca réewu Morya ca tund wa ma lay wax, joxe ko fa, mu nekk saraxu rendi-dóomal.» ");
INSERT INTO wolmbs_vpl VALUES ("GN22_3","002_22_3","GEN","22","3","3","Ibraayma nag teela xëy, takk mbaamam, ànd ak ñaari surgaam ak doomam Isaaxa, daldi xar matt, mi muy lakke sarax bi. Ma nga jëm fa ko Yàlla wax. ");
INSERT INTO wolmbs_vpl VALUES ("GN22_4","002_22_4","GEN","22","4","4","Ca gannaaw ëllëg sa, Ibraayma daa dawal bëtam, séen béreb ba fu sore. ");
INSERT INTO wolmbs_vpl VALUES ("GN22_5","002_22_5","GEN","22","5","5","Mu ne surga ya: «Négleen fii, mbaam mi taxaw. Man ak xale bi nu dem ba fale, màggali Yàlla te ñëw.» ");
INSERT INTO wolmbs_vpl VALUES ("GN22_6","002_22_6","GEN","22","6","6","Ba loolu amee Ibraayma jël mattum saraxu rendi-dóomal ba, yen ko doomam Isaaxa; moom mu ŋàbb la muy taale ak paaka ba ci loxoom, ñu ànd ñoom ñaar. ");
INSERT INTO wolmbs_vpl VALUES ("GN22_7","002_22_7","GEN","22","7","7","Isaaxa ne baayam Ibraayma: «Baay!» Mu ne ko: «Naam, doom sama.» Isaaxa ne ko: «Sawara saa ngi, matt maa ngi, waaye ana gàtt, bi nuy sarxal?» ");
INSERT INTO wolmbs_vpl VALUES ("GN22_8","002_22_8","GEN","22","8","8","Ibraayma ne ko: «Yàlla moom ci boppam dina dikk ak gàtt bi nuy def sarax, doom,» ñu daldi ànd dem, ñoom ñaar. ");
INSERT INTO wolmbs_vpl VALUES ("GN22_9","002_22_9","GEN","22","9","9","Ba ñu àggee fa ko Yàlla wax, Ibraayma sàkk fa ab sarxalukaay, teg ca matt ma, yeew Isaaxa doomam, teg ko ca kaw matt ma ca sarxalukaay ba. ");
INSERT INTO wolmbs_vpl VALUES ("GN22_10","002_22_10","GEN","22","10","10","Ibraaymaa nga tàllal loxoom, ŋëb paaka ba, ngir rendi doom ja. ");
INSERT INTO wolmbs_vpl VALUES ("GN22_11","002_22_11","GEN","22","11","11","Teewul malaakam Aji Sax ja àddoo asamaan, ne ko: «Ibraayma! Ibraayma!» Mu ne ko: «Ãa!» ");
INSERT INTO wolmbs_vpl VALUES ("GN22_12","002_22_12","GEN","22","12","12","Malaaka ma ne ko: «Bu sa loxo laal xale bi; bu ko def dara, ndaxte léegi xam naa ne ragal nga Yàlla, ndax gàntaloo ma sa jenn doom ji.» ");
INSERT INTO wolmbs_vpl VALUES ("GN22_13","002_22_13","GEN","22","13","13","Naka la Ibraayma siggi rekk, yem ci menn kuuy mu béjjén ya lonke ci as ngarab. Ibraayma dem, jël kuuy ma, rendi, mu wuutu doom ja, di ab saraxu rendi-dóomal. ");
INSERT INTO wolmbs_vpl VALUES ("GN22_14","002_22_14","GEN","22","14","14","Ibraayma nag tudde béreb boobu Yawe Yire (muy firi Aji Sax ji dina dikk). Moo tax ñuy wax ba tey, naan: «Aji Sax jaa ngay dikke ca tundam.» ");
INSERT INTO wolmbs_vpl VALUES ("GN22_15","002_22_15","GEN","22","15","15","Ci kaw loolu malaakam Yàlla ma dellu àddoo asamaan ne Ibraayma: ");
INSERT INTO wolmbs_vpl VALUES ("GN22_16","002_22_16","GEN","22","16","16","«Déglul lii Aji Sax ji wax: “Giñ naa ci man mii, gannaaw yaa def lii, te gàntaloo ma sa jenn doom ji, ");
INSERT INTO wolmbs_vpl VALUES ("GN22_17","002_22_17","GEN","22","17","17","maa lay barkeel a barkeel, ful a ful saw askan ni biddiiwi asamaan, mbaa feppi suufi géej. Sa askan dina teg ay bañam tànk, ");
INSERT INTO wolmbs_vpl VALUES ("GN22_18","002_22_18","GEN","22","18","18","te xeeti àddina yépp ci saw askan lañuy barkeele, ndax déggal nga ma.”» ");
INSERT INTO wolmbs_vpl VALUES ("GN22_19","002_22_19","GEN","22","19","19","Ba loolu wéyee Ibraayma waññiku, fekki surga ya, ñu daldi ànd ñoom ñépp, jëm Beerseba, ndax fa la Ibraayma dëkkoon. ");
INSERT INTO wolmbs_vpl VALUES ("GN22_20","002_22_20","GEN","22","20","20","Gannaaw gi, dañoo yégal Ibraayma ne ko: «Milka nag am na ay doom moom it, moom ak sa mbokk Naxor: ");
INSERT INTO wolmbs_vpl VALUES ("GN22_21","002_22_21","GEN","22","21","21","Ucc lañu taawloo, teg ca Bus, teg ca Kemwel, miy baayu Aram, ");
INSERT INTO wolmbs_vpl VALUES ("GN22_22","002_22_22","GEN","22","22","22","teg ca Keset ak Aso ak Pildas ak Yidlaf ak Betuwel.» ");
INSERT INTO wolmbs_vpl VALUES ("GN22_23","002_22_23","GEN","22","23","23","Betuwel ay baayu Rebeka. Ñooñu ñooy juróom ñetti doom yu góor, yi Milka am ak Naxor, mi bokk ak Ibraayma ndey ak baay. ");
INSERT INTO wolmbs_vpl VALUES ("GN22_24","002_22_24","GEN","22","24","24","Rewma it nekkaaleem la woon, doom ya mu ca am di Teba ak Gaxam ak Taxas ak Maaka. ");
INSERT INTO wolmbs_vpl VALUES ("GN23_1","002_23_1","GEN","23","1","1","Saarata dund na, ba am téeméeri at ak ñaar fukk ak juróom ñaar (127), ");
INSERT INTO wolmbs_vpl VALUES ("GN23_2","002_23_2","GEN","23","2","2","doora faatu ca Kiryaat Arba, mooy Ebron, ca réewu Kanaan. Ibraayma nag dëj Saarata, jooy ko lool. ");
INSERT INTO wolmbs_vpl VALUES ("GN23_3","002_23_3","GEN","23","3","3","Gannaaw loolu Ibraayma bàyyi fa néew ba, dem ca Etteen ña, ne leen: ");
INSERT INTO wolmbs_vpl VALUES ("GN23_4","002_23_4","GEN","23","4","4","«Dama di doxandéem ci seen biir, tey gan; moo tax ma di leen ñaan, ngeen sédd ma bàmmeel bu ma suul sama néew, ba mu làqu ma.» ");
INSERT INTO wolmbs_vpl VALUES ("GN23_5","002_23_5","GEN","23","5","5","Kenn ci Etteen ñi wax Ibraayma ne ko: ");
INSERT INTO wolmbs_vpl VALUES ("GN23_6","002_23_6","GEN","23","6","6","«Déglul rekk, kilifa gi. Kilifa gu mag nga ci sunu biir. Dangay tànn ci sunuy bàmmeel, bi la neex, suul fa néew bi; kenn ci nun du la tere, nga suul sa néew ci bàmmeelam.» ");
INSERT INTO wolmbs_vpl VALUES ("GN23_7","002_23_7","GEN","23","7","7","Naka la Ibraayma dégg loolu, daldi jóg sujjóotal waa réew ma, maanaam Etteen ña. ");
INSERT INTO wolmbs_vpl VALUES ("GN23_8","002_23_8","GEN","23","8","8","Mu ne leen: «Gannaaw nangu ngeen, ma suul fi sama néew, ba mu làqu ma, dégluleen, ma wax leen li ma bëgg ngeen ñaanal ma Efron doomu Cowar. ");
INSERT INTO wolmbs_vpl VALUES ("GN23_9","002_23_9","GEN","23","9","9","Damaa bëgg, mu bàyyee ma xuntum xeer, mi ñuy wax Magpela te muy boroom béreb bi. Mu ngi ci catu toolam. Na ma ko jaay lu mat njëgam sëkk, dinaa ko jënd, muy sama bàmmeel ci seen biir.» ");
INSERT INTO wolmbs_vpl VALUES ("GN23_10","002_23_10","GEN","23","10","10","Booba Efron a ngi teew ci biir Etteen ñi. Efron, miy Etteen nag, wax ak Ibraayma ci kanam bokkam yi séq pénc mi, ne ko: ");
INSERT INTO wolmbs_vpl VALUES ("GN23_11","002_23_11","GEN","23","11","11","«Déglul, ma wax la, kilifa gi, fabal tool bi, booleek xuntum xeer mi ci nekk far. Maa la ko jox ci sama kanami bokk; jëlal, denc fa sa néew.» ");
INSERT INTO wolmbs_vpl VALUES ("GN23_12","002_23_12","GEN","23","12","12","Ba mu ko defee Ibraayma sujjóotal waa réew ma, ");
INSERT INTO wolmbs_vpl VALUES ("GN23_13","002_23_13","GEN","23","13","13","daldi wax Efron ci seen kanam ne ko: «Ngalla déglu ma, dama lay jox njëgu tool bi, nga jël rekk, ndax ma man faa suul sama néew.» ");
INSERT INTO wolmbs_vpl VALUES ("GN23_14","002_23_14","GEN","23","14","14","Efron wax Ibraayma ne ko: ");
INSERT INTO wolmbs_vpl VALUES ("GN23_15","002_23_15","GEN","23","15","15","«Déglu ma, kilifa gi, suuf suy jar ñeenti téeméeri dogi xaalis doŋŋ du dara ci sama diggante ak yaw; tee nga faa denc sa néew rekk?» ");
INSERT INTO wolmbs_vpl VALUES ("GN23_16","002_23_16","GEN","23","16","16","Ibraayma dégg li ko Efron wax, daldi waññal Efron limu xaalis bi mu wax ci kanam Etteen ñi, maanaam ñeenti téeméeri dogi xaalis yu dëppook nattu jaaykat ya. ");
INSERT INTO wolmbs_vpl VALUES ("GN23_17","002_23_17","GEN","23","17","18","Noonu la Ibraayma jënde toolub Efron ba nekk ca Magpela te janook Mamre, muy moomeelam. Dafa jënd tool ba bépp, jëndaale xuntum xeer ma ca biir, ak garab ya ca sax yépp, ba fa tool ba yem. Mboolem Etteen ña séqoon pénc ma, seede ne Ibraayma moo ko moom. ");
INSERT INTO wolmbs_vpl VALUES ("GN23_19","002_23_19","GEN","23","19","19","Ibraayma daldi suul soxnaam Saarata ca xuntum xeer ma ca biir toolub Magpela, booba janook Mamre, di Ebron léegi, ca réewu Kanaan. ");
INSERT INTO wolmbs_vpl VALUES ("GN23_20","002_23_20","GEN","23","20","20","Nii la Etteen ña dogalale Ibraayma njaayum tool ba ak xunt ma ca nekk, mu def ko bàmmeel. ");
INSERT INTO wolmbs_vpl VALUES ("GN24_1","002_24_1","GEN","24","1","1","Ibraayma guddoon na fan, ba màggat lool, te Aji Sax ji barkeel ko ci lépp. ");
INSERT INTO wolmbs_vpl VALUES ("GN24_2","002_24_2","GEN","24","2","2","Mu am bés Ibraayma wax surgaam, bi gëna yàgg ci këram, tey saytu alalam jépp, ne ko: «Dugalal sa loxo ci sama suufu lupp, ");
INSERT INTO wolmbs_vpl VALUES ("GN24_3","002_24_3","GEN","24","3","3","ma giñloo la ci Aji Sax jiy Yàllay asamaan ak suuf ne doo jëlal sama doom soxna ci biir jigéeni waa Kanaan, gi ma dëkk ci seen biir. ");
INSERT INTO wolmbs_vpl VALUES ("GN24_4","002_24_4","GEN","24","4","4","Waaye dinga dem sama réew ma ma cosaanoo, jëlal fa sama doom Isaaxa soxna.» ");
INSERT INTO wolmbs_vpl VALUES ("GN24_5","002_24_5","GEN","24","5","5","Surga ba ne ko: «Su ndaw sa nanguwula ànd ak man ci réew mii nag? Ndax kon damaa wara yóbbu sa doom ba ca réew ma nga jóge?» ");
INSERT INTO wolmbs_vpl VALUES ("GN24_6","002_24_6","GEN","24","6","6","Ibraayma itam ne ko: «Bu fa yóbbu sama doom mukk. ");
INSERT INTO wolmbs_vpl VALUES ("GN24_7","002_24_7","GEN","24","7","7","Aji Sax ji, Yàllay asamaan, moom mi ma jële sama kër baay ak fa ma juddoo, te wax ak man, giñal ma, ne ma, dina jox sama askan réew mii, moom ci boppam dina yebal malaakaam, mu jiitu la. Foofa ngay jëlale sama doom soxna. ");
INSERT INTO wolmbs_vpl VALUES ("GN24_8","002_24_8","GEN","24","8","8","Su la ndaw si bëggula topp, kon wàccoo nga ak man. Waaye rikk bul yóbbu sama doom foofa.» ");
INSERT INTO wolmbs_vpl VALUES ("GN24_9","002_24_9","GEN","24","9","9","Surga ba dugal loxoom ca suufu luppu Ibraayma sangam ba, daldi giñ ca loola. ");
INSERT INTO wolmbs_vpl VALUES ("GN24_10","002_24_10","GEN","24","10","10","Ba loolu amee surga ba jële fukki giléem ca giléemi sangam, dem, yóbbaale li gën ci mboolem xeeti alalu sangam. Ma nga jëm réewu Mesopotami, ca dëkk ba Naxor dëkk. ");
INSERT INTO wolmbs_vpl VALUES ("GN24_11","002_24_11","GEN","24","11","11","Ba muy jub dëkk ba, daa yësal giléem ya fu dend akub seyaan waxtuw ngoon, fekk jigéen ñay génn di rootsi. ");
INSERT INTO wolmbs_vpl VALUES ("GN24_12","002_24_12","GEN","24","12","12","Mu daldi ne: «Yaw Aji Sax ji, sama Yàllay sang Ibraayma, ngalla nangul ma tey jii te laaye biir sama sang Ibraayma. ");
INSERT INTO wolmbs_vpl VALUES ("GN24_13","002_24_13","GEN","24","13","13","Maa ngi nii taxaw ci bëtu ndox mi, janqi dëkk bi di rootsi. ");
INSERT INTO wolmbs_vpl VALUES ("GN24_14","002_24_14","GEN","24","14","14","Janq bu ma wax ne ko: “Doo yenniku sa njaq, may ma, ma naan,” mu ne ma: “Naanal ba noppi, ma wëggal la say giléem,” na kooka di ki nga jagleel sa jaam Isaaxa. Noonu laay xame ne laaye nga biir sama sang.» ");
INSERT INTO wolmbs_vpl VALUES ("GN24_15","002_24_15","GEN","24","15","15","Laata muy ñaan ba noppi sax, gis na Rebeka gàddu njaqam, di ñëw. Rebeka moomu di doomu Betuwel te di sëtu Milka ak Naxor, miy doomu ndeyu Ibraayma. ");
INSERT INTO wolmbs_vpl VALUES ("GN24_16","002_24_16","GEN","24","16","16","Ndaw su taaru la woon, di ab janq. Naka la wàcc ba ca seyaan ba, duy njaqam, yéegaat. ");
INSERT INTO wolmbs_vpl VALUES ("GN24_17","002_24_17","GEN","24","17","17","Surga ba daw, daje ak moom ne ko: «Doo ma may tuuti ci sa njaq li, ma naan.» ");
INSERT INTO wolmbs_vpl VALUES ("GN24_18","002_24_18","GEN","24","18","18","Mu ne ko: «Ahakay, sang bi,» daldi gaaw, yenniku njaq la, may ko mu naan. ");
INSERT INTO wolmbs_vpl VALUES ("GN24_19","002_24_19","GEN","24","19","19","Ba ko ndaw si mayee, mu naan ba noppi, da ne ko: «Xaaral, ma wëggal la giléem yi, ñu naan ba noppi.» ");
INSERT INTO wolmbs_vpl VALUES ("GN24_20","002_24_20","GEN","24","20","20","Mu daldi gaaw, sotti njaq la ca mbalka ma, dawaat rootali giléem yi ca seyaan ba. ");
INSERT INTO wolmbs_vpl VALUES ("GN24_21","002_24_21","GEN","24","21","21","Waa ja ne ko jàkk, ne tekk, di seet, ba xam ndax Aji Sax ji àntal na yoonam am déet. ");
INSERT INTO wolmbs_vpl VALUES ("GN24_22","002_24_22","GEN","24","22","22","Ba giléem ya naanee ba sottal, waa ji jël jaarob bakkan bu wurus bu tollook juróom benni garaam, ak ñaari lami wurus yu tolloo ci téeméeri garaam, takkal ko. ");
INSERT INTO wolmbs_vpl VALUES ("GN24_23","002_24_23","GEN","24","23","23","Mu ne ko: «Wax ma, kan moo la jur?» Ak itam: «Ndax man nanoo dal sa kër baay?» ");
INSERT INTO wolmbs_vpl VALUES ("GN24_24","002_24_24","GEN","24","24","24","Mu ne ko: «Betuwel a ma jur, doomu Naxor ak Milka,» ");
INSERT INTO wolmbs_vpl VALUES ("GN24_25","002_24_25","GEN","24","25","25","teg ca ne ko: «Waawaaw, ñax maak ngooñ maa nga fa, ne gàññ, te it manees na faa dal.» ");
INSERT INTO wolmbs_vpl VALUES ("GN24_26","002_24_26","GEN","24","26","26","Waa ji nag sujjóot, sant Aji Sax ji, ");
INSERT INTO wolmbs_vpl VALUES ("GN24_27","002_24_27","GEN","24","27","27","daldi ne: «Cant ñeel na Aji Sax ji, sama Yàllay sang, Ibraayma, moom mi masula noppee laaye biir sama sang, te masu koo ñàkke worma. Man it, Aji Sax ji wommat na ma ba sama kër bokki sang!» ");
INSERT INTO wolmbs_vpl VALUES ("GN24_28","002_24_28","GEN","24","28","28","Janq bi nag daw dem, nettali waa kër yaayam la xew lépp. ");
INSERT INTO wolmbs_vpl VALUES ("GN24_29","002_24_29","GEN","24","29","29","Rebeka amoon na càmmiñ lu tudd Laban. Laban daldi gaawtu génn, fekki waa ja ca seyaan ba. ");
INSERT INTO wolmbs_vpl VALUES ("GN24_30","002_24_30","GEN","24","30","30","Booba gis na jaaro ba ak lam, ya ca loxol jigéenam Rebeka, te dégg na jigéenam di nettali la ko waa ja wax. Loolu tax mu dem ca waa ja, fekk ko ca giléem ya ca seyaan ba. ");
INSERT INTO wolmbs_vpl VALUES ("GN24_31","002_24_31","GEN","24","31","31","Mu ne ko: «Yaw mi Aji Sax ji barkeel, agsil boog! Looy toog ci àll bi; waajalal naa la ab dal, te giléem yi am nañu fu ñu nekk.» ");
INSERT INTO wolmbs_vpl VALUES ("GN24_32","002_24_32","GEN","24","32","32","Waa ja daldi àgg ca kër ga, ñu sippi giléem ya, may leen ñax ak ngooñ, may waa ja ndox, mu jàngu, moom ak ñi mu àndal, ");
INSERT INTO wolmbs_vpl VALUES ("GN24_33","002_24_33","GEN","24","33","33","ba noppi ñu taajal ko lu mu lekk. Mu ne: «Déedéet, duma lekk mukk kay, te waxuma li ma taxa jóg.» Laban ne ko: «Kon nag waxal.» ");
INSERT INTO wolmbs_vpl VALUES ("GN24_34","002_24_34","GEN","24","34","34","Mu ne: «Man surgab Ibraayma laa. ");
INSERT INTO wolmbs_vpl VALUES ("GN24_35","002_24_35","GEN","24","35","35","Aji Sax ji dafa barkeel sama sang lool, ba muy boroom daraja. May na ko jur gu gàtt ak gu gudd, xaalis ak wurus ak ay surga yu góor ak yu jigéen ak ay giléem aki mbaam. ");
INSERT INTO wolmbs_vpl VALUES ("GN24_36","002_24_36","GEN","24","36","36","Sama soxnas sang Saarata nag dem na ba màggat, doora amal sama sang doom ju góor. Doomam jooju la jox li mu moom lépp. ");
INSERT INTO wolmbs_vpl VALUES ("GN24_37","002_24_37","GEN","24","37","37","Sama sang nag giñloo ma ne: “Bul jëlal mukk sama doom soxna ci biir jigéeni waa réewu Kanaan, gi ma dëkk. ");
INSERT INTO wolmbs_vpl VALUES ("GN24_38","002_24_38","GEN","24","38","38","Waaye demal ca sama kër baay, ca samay bokk, nga jëlal fa sama doom soxna.” ");
INSERT INTO wolmbs_vpl VALUES ("GN24_39","002_24_39","GEN","24","39","39","Ma ne sama sang: “Bu ndaw sa nanguwula ànd ak man nag?” ");
INSERT INTO wolmbs_vpl VALUES ("GN24_40","002_24_40","GEN","24","40","40","Mu ne ma: “Aji Sax ji ma topp, dina yónni malaakaam, mu ànd ak yaw, ba àntalal la sa yoon, nga jëlal sama doom soxna ca sama kër baay, ca sama biiri bokk. ");
INSERT INTO wolmbs_vpl VALUES ("GN24_41","002_24_41","GEN","24","41","41","Boo demee ba ca samay bokk, wàcc nga, ndax bu ñu la mayul soxna, wàccoo nga ak man.” ");
INSERT INTO wolmbs_vpl VALUES ("GN24_42","002_24_42","GEN","24","42","42","Ba ma agsee tey jii ca seyaan ba, damaa wax ne: “Aji Sax ji, sama Yàllay sang Ibraayma, ndegam nar ngaa àntal yoon wi may dox, ngalla may ma lii: ");
INSERT INTO wolmbs_vpl VALUES ("GN24_43","002_24_43","GEN","24","43","43","maa ngii taxaw ci seyaan bi; janq bay ñëw rootsi, ma ne ko: ‘Doo ma may tuuti ci sa njaq li, ma naan,’ ");
INSERT INTO wolmbs_vpl VALUES ("GN24_44","002_24_44","GEN","24","44","44","mu ne ma: ‘Naanal ba noppi, ma wëggal la say giléem,’ kooku na di soxna si Aji Sax ji jagleel sama doomu sang.” ");
INSERT INTO wolmbs_vpl VALUES ("GN24_45","002_24_45","GEN","24","45","45","«Bala maa ñaan ba noppi, Rebeka ne jimeet, gàddu njaqam, wàcc ca seyaan ba, di root. Ma ne ko: “May ma, ma naan.” ");
INSERT INTO wolmbs_vpl VALUES ("GN24_46","002_24_46","GEN","24","46","46","Mu gaaw yenniku njaq li, daldi ne ma: “Naanal ba noppi ma wëggal la say giléem.” Ma naan ba noppi, mu wëggal ma giléem yi. ");
INSERT INTO wolmbs_vpl VALUES ("GN24_47","002_24_47","GEN","24","47","47","Ma laaj ko ne ko: “Kan moo la jur?” Mu ne: “Betuwel, doomu Naxor ak Milka.” «Ca laa ko takkal jaaro bi ci bakkanam, ak lam yi ciy loxoom. ");
INSERT INTO wolmbs_vpl VALUES ("GN24_48","002_24_48","GEN","24","48","48","Ba mu ko defee ma sujjóotal Aji Sax ji, sant Aji Sax jiy sama Yàllay sang Ibraayma, ndax jubal na sama yoon, ba ma jëlal doomam soxna ciy bokkam. ");
INSERT INTO wolmbs_vpl VALUES ("GN24_49","002_24_49","GEN","24","49","49","Léegi nag ndegam nar ngeena rafetoo ak sama sang tey sàmm kóllëre, xamalleen ma ko, ba mu leer. Su ngeen ko narul it, waxleen ma, ma xam nu may def.» ");
INSERT INTO wolmbs_vpl VALUES ("GN24_50","002_24_50","GEN","24","50","50","Laban ak Betuwel ne ko: «Mbir moomu de ci Aji Sax ji la jóge, te amunu ci dara lu nuy wax. ");
INSERT INTO wolmbs_vpl VALUES ("GN24_51","002_24_51","GEN","24","51","51","Rebekaa ngoogu, jëlal te dem, muy sa soxnas doomu sang, ni la ko Aji Sax ji tegtale.» ");
INSERT INTO wolmbs_vpl VALUES ("GN24_52","002_24_52","GEN","24","52","52","Naka la surgab Ibraayma dégg yooyu kàddu, daldi sujjóotal Aji Sax ji. ");
INSERT INTO wolmbs_vpl VALUES ("GN24_53","002_24_53","GEN","24","53","53","Surga ba nag génne ay gànjari xaalis ak yu wurus booleek ay yére, jox Rebeka. Càmmiñ la ak yaay ja itam, mu may leen alal ju takku. ");
INSERT INTO wolmbs_vpl VALUES ("GN24_54","002_24_54","GEN","24","54","54","Ba loolu weesoo mu doora lekk, daldi naan, moom ak ñi mu àndal. Ñu fanaan fa keroog. Ba ñu yewwoo ca ëllëg sa, surga ba ne: «Bàyyileen ma nag, ma dellu ca sama sang.» ");
INSERT INTO wolmbs_vpl VALUES ("GN24_55","002_24_55","GEN","24","55","55","Càmmiñal ndaw sa ak yaay ja daldi ne ko: «Xanaa kay janq bi dina toogaat ak nun ab diir boog, maanaam fii ak sibir, doora dem.» ");
INSERT INTO wolmbs_vpl VALUES ("GN24_56","002_24_56","GEN","24","56","56","Mu ne leen: «Gannaaw Aji Sax ji àntal na sama yoon, tee ngeen ma baña yeexal, te bàyyi ma rekk, ma dellu ca sama sang?» ");
INSERT INTO wolmbs_vpl VALUES ("GN24_57","002_24_57","GEN","24","57","57","Ñu ne ko: «Kon nag nanu woo janq bi, laaj ko moom ci boppam.» ");
INSERT INTO wolmbs_vpl VALUES ("GN24_58","002_24_58","GEN","24","58","58","Ci kaw loolu ñu woo Rebeka, ne ko: «Ndax dangay ànd ak waa ji léegi?» Mu ne: «Waaw.» ");
INSERT INTO wolmbs_vpl VALUES ("GN24_59","002_24_59","GEN","24","59","59","Ba loolu amee càmmiñ ya bàyyi seen jigéen Rebeka, moom ak surga, bi ko yar te daan ko nàmpal, ñu ànd ak surgab Ibraayma ak ñi ko topp, ñu dem. ");
INSERT INTO wolmbs_vpl VALUES ("GN24_60","002_24_60","GEN","24","60","60","Ña ngay ñaanal Rebeka, mu barkeel, te naan: «Éy jigéen sunu! Giiral, ba sos ay junniy junni, te sa askan teg ay bañam tànk.» ");
INSERT INTO wolmbs_vpl VALUES ("GN24_61","002_24_61","GEN","24","61","61","Gannaaw loolu Rebeka ànd ak xale yu jigéen, yiy jaamam, ñu war ay giléem, topp waa ja. Surga ba daldi dem, yóbbu Rebeka. ");
INSERT INTO wolmbs_vpl VALUES ("GN24_62","002_24_62","GEN","24","62","62","Loolu fekk na Isaaxa dëkk ca àllub Negew. Mu demoon nag teenu Laxay Roy, ba ñibbisi. ");
INSERT INTO wolmbs_vpl VALUES ("GN24_63","002_24_63","GEN","24","63","63","Genn ngoon Isaaxa génn, di doxantu ca àll ba. Naka la ne siggét xool, séen giléem yuy ñëw. ");
INSERT INTO wolmbs_vpl VALUES ("GN24_64","002_24_64","GEN","24","64","64","Rebeka it ne siggét, gis Isaaxa. Mu ne cëpp nag, wàcc giléem ga, ");
INSERT INTO wolmbs_vpl VALUES ("GN24_65","002_24_65","GEN","24","65","65","daldi ne surga ba: «Waa jee ci àll biy ñëw, jëm ci nun, kan a?» Surga ba ne ko: «Sama sang la de.» Rebeka daldi jël muuraay ba, muuroo. ");
INSERT INTO wolmbs_vpl VALUES ("GN24_66","002_24_66","GEN","24","66","66","Surga ba nag nettali Isaaxa li mu def lépp. ");
INSERT INTO wolmbs_vpl VALUES ("GN24_67","002_24_67","GEN","24","67","67","Ba loolu wéyee Isaaxa yóbbu Rebeka ca xaymab yaayam Saarata, muy soxnaam, di ku mu bëgg, te di ko muñe yaayam, ndax fekk na mu faatu. ");
INSERT INTO wolmbs_vpl VALUES ("GN25_1","002_25_1","GEN","25","1","1","Ibraayma jëlaat na soxna su tudd Ketura, ");
INSERT INTO wolmbs_vpl VALUES ("GN25_2","002_25_2","GEN","25","2","2","am ca Simran ak Yogsan ak Medan ak Majan ak Yisbag ak Suwa. ");
INSERT INTO wolmbs_vpl VALUES ("GN25_3","002_25_3","GEN","25","3","3","Yogsan jur Seba ak Dedan. Askani Dedan ñooy Asureen ñi, Letuseen ñi ak Lewumeen ñi. ");
INSERT INTO wolmbs_vpl VALUES ("GN25_4","002_25_4","GEN","25","4","4","Doomi Majan yu góor ñoo di Efa ak Efer ak Enog ak Abida ak Elda. Ñooñu ñépp xeetu Ketura lañu. ");
INSERT INTO wolmbs_vpl VALUES ("GN25_5","002_25_5","GEN","25","5","5","Ibraayma nag donale Isaaxa lépp lu mu moom. ");
INSERT INTO wolmbs_vpl VALUES ("GN25_6","002_25_6","GEN","25","6","6","Doom yu góor, ya Ibraayma am aki nekkaaleem, mu may leen alal ca ba muy dund, ba noppi yebal leen penku, ñu sanci ca réewu penku, ba sore doomam Isaaxa. ");
INSERT INTO wolmbs_vpl VALUES ("GN25_7","002_25_7","GEN","25","7","7","Ati Ibraayma téeméer la ak juróom ñaar fukk ak juróom (175). ");
INSERT INTO wolmbs_vpl VALUES ("GN25_8","002_25_8","GEN","25","8","8","Ba loolu weesoo la bakkanu Ibraayma rot, mu nelaw, fekki ay maamam, gannaaw ba mu guddee fan, ba màggat lool te barkeel. ");
INSERT INTO wolmbs_vpl VALUES ("GN25_9","002_25_9","GEN","25","9","9","Isaaxa ak Ismayla, doomam yu góor ya, rob ko ca xuntum xeer ma ca Magpela te jàkkaarloo ak Mamre, ca toolub Efron doomu Cowar, mi bokk ci xeetu Ett. ");
INSERT INTO wolmbs_vpl VALUES ("GN25_10","002_25_10","GEN","25","10","10","Tool ba Ibraayma jëndoon ca Etteen ña, foofa lañu denc Ibraayma ak soxnaam Saarata. ");
INSERT INTO wolmbs_vpl VALUES ("GN25_11","002_25_11","GEN","25","11","11","Gannaaw ba Ibraayma nelawee, Yàlla barkeel na doomam Isaaxa. Isaaxaa ngi dëkkoon ca wetu teenu Laxay Roy. ");
INSERT INTO wolmbs_vpl VALUES ("GN25_12","002_25_12","GEN","25","12","12","Ismayla moomee nag, doomu Ibraayma jaak Ajara mu Misra, ma doon jaamub Saarata, askanam mooy lii. ");
INSERT INTO wolmbs_vpl VALUES ("GN25_13","002_25_13","GEN","25","13","13","Turi doomi Ismayla yu góor ni seen juddu toppante, ñoo di Nebayot, taawub Ismayla, ña ca topp di Kedar ak Adabeel ak Mibsam ");
INSERT INTO wolmbs_vpl VALUES ("GN25_14","002_25_14","GEN","25","14","14","ak Misma ak Duuma ak Maasa ");
INSERT INTO wolmbs_vpl VALUES ("GN25_15","002_25_15","GEN","25","15","15","ak Adàdd ak Tema ak Yetur ak Nafis ak Kedama. ");
INSERT INTO wolmbs_vpl VALUES ("GN25_16","002_25_16","GEN","25","16","16","Ñooñu ñooy doomi Ismayla yu góor, seeni tur a ngoog, ñuy fukki garmi ak ñaar yu jiite seeni làng ci seeni sanc ak seeni dal. ");
INSERT INTO wolmbs_vpl VALUES ("GN25_17","002_25_17","GEN","25","17","17","Ati Ismayla téeméer la ak fanweer ak juróom ñaar (137). Gannaaw loolu la nelaw, fekki ay maamam. ");
INSERT INTO wolmbs_vpl VALUES ("GN25_18","002_25_18","GEN","25","18","18","Ña nga dëkkoon diggante ba dale Awila ba Sur, ga jàkkaarlook Misra, booy jëm Asur. Noonu la fa askanu Ismayla sance, jàkkaarlook doomi baayam yépp. ");
INSERT INTO wolmbs_vpl VALUES ("GN25_19","002_25_19","GEN","25","19","19","Isaaxa doomu Ibraayma ju góor ja, askanam mooy lii. Ibraaymaa jur Isaaxa. ");
INSERT INTO wolmbs_vpl VALUES ("GN25_20","002_25_20","GEN","25","20","20","Isaaxa am ñeent fukki at, jël Rebeka doomu Betuwel, mi bokk ci xeetu Aram, te dëkke diiwaanu Padan Aram, dib jigéenu Laban, mi bokk itam ci xeetu Aram. ");
INSERT INTO wolmbs_vpl VALUES ("GN25_21","002_25_21","GEN","25","21","21","Gannaaw ga, soxnas Isaaxa amul doom, Isaaxa dagaanal ko Aji Sax ji, mu nangul ko, soxna si daldi ëmb. ");
INSERT INTO wolmbs_vpl VALUES ("GN25_22","002_25_22","GEN","25","22","22","Doom yi nag di buuxante ci biiram, ba mu naan: «Ndegam nii la kay, jaru ko woon!» Ci kaw loolu soxna si dem, diis ko Aji Sax ji. ");
INSERT INTO wolmbs_vpl VALUES ("GN25_23","002_25_23","GEN","25","23","23","Aji Sax ji ne ko: «Ñaari giir nga ëmb, nara am ñaari xeet yuy xaajaloo, wenn wi mooy ëpp doole wi ci des, te mag ji mooy surgawu rakk ji.» ");
INSERT INTO wolmbs_vpl VALUES ("GN25_24","002_25_24","GEN","25","24","24","Ba mu demee ba wara mucc, amul lu moy ay seex. ");
INSERT INTO wolmbs_vpl VALUES ("GN25_25","002_25_25","GEN","25","25","25","Naka noona ka njëkka gane àddina xonq, yaram wi sëq lipp, mel ni mbubbum der mu ne sàyy aki kawaram, ñu tudde ko Esawu (muy firi Ku jëxëm). ");
INSERT INTO wolmbs_vpl VALUES ("GN25_26","002_25_26","GEN","25","26","26","Gannaaw ga ka ca des topp ca, loxo ba jàpp ca téstënu Esawu. Ñu tudde ko Yanqóoba (muy firi Jàpp ci téstën). Ba leen Rebeka di am, fekk na Isaaxa am juróom benn fukki at. ");
INSERT INTO wolmbs_vpl VALUES ("GN25_27","002_25_27","GEN","25","27","27","Ba mu ko defee gone ya di màgg, Esawu di rëbbkat bu ñaw, di ku bëgg àll; Yanqóoba moom di nit ku gàtteñlu te bëggoon toogaayu kër. ");
INSERT INTO wolmbs_vpl VALUES ("GN25_28","002_25_28","GEN","25","28","28","Isaaxa nag am cofeel ci Esawu ndax li muy lekk ci am rëbbam, te Rebeka moom gëna sopp Yanqóoba. ");
INSERT INTO wolmbs_vpl VALUES ("GN25_29","002_25_29","GEN","25","29","29","Mu am bés Yanqóoba di togg ndambel ñebbe, yemook Esawu jóge ca tool ya, xiif ba ne ñedd. ");
INSERT INTO wolmbs_vpl VALUES ("GN25_30","002_25_30","GEN","25","30","30","Mu ne Yanqóoba: «Gaawe ma ci ndambe lu xonq lee waay, ba ma duy ci sama biir, ndax xiif a ngi may rey.» Loolu moo tax ñu tudde Esawu, Edom (muy firi Xonqe). ");
INSERT INTO wolmbs_vpl VALUES ("GN25_31","002_25_31","GEN","25","31","31","Yanqóoba ne ko: «Danga ma koy njëkka wecci sa céru ndono bi nga yeyoo ndax li ngay taaw.» ");
INSERT INTO wolmbs_vpl VALUES ("GN25_32","002_25_32","GEN","25","32","32","Esawu ne: «Man miy waaja dee ak xiif, ana lu ma céru taaw di jariñ?» ");
INSERT INTO wolmbs_vpl VALUES ("GN25_33","002_25_33","GEN","25","33","33","Yanqóoba ne ko: «Giñal ma jëkk.» Esawu giñal ko ko, mu jaay Yanqóoba ndono li mu yeyoo ndax li muy taaw. ");
INSERT INTO wolmbs_vpl VALUES ("GN25_34","002_25_34","GEN","25","34","34","Yanqóoba jox Esawu mburu ak ndambe, mu lekk, naan, daldi jóg dem yoonam. Noonu la Esawu sàgganee céru taaw, bi mu yeyoo. ");
INSERT INTO wolmbs_vpl VALUES ("GN26_1","002_26_1","GEN","26","1","1","Ba loolu wéyee xiif am ca réew ma, muy xiif bu wuute ak ba woon ca jamonoy Ibraayma; Isaaxa nag dem Gerar ca Abimeleg, buurub waa Filisti. ");
INSERT INTO wolmbs_vpl VALUES ("GN26_2","002_26_2","GEN","26","2","2","Foofa Aji Sax ji feeñu ko fa ne ko: «Bul dem Misra, waaye nanga toog ci réew mi ma lay wax. ");
INSERT INTO wolmbs_vpl VALUES ("GN26_3","002_26_3","GEN","26","3","3","Dalal ci réew mii; dinaa ànd ak yaw, barkeel la. Yaak sa askan laay jox suuf sii sépp, te dinaa sàmm li ma giñaloon sa baay Ibraayma. ");
INSERT INTO wolmbs_vpl VALUES ("GN26_4","002_26_4","GEN","26","4","4","Dinaa ful sa askan ni biddiiwi asamaan, dinaa jox sa askan suuf sii sépp, te it ci saw askan la xeeti àddina yépp di barkeele, ");
INSERT INTO wolmbs_vpl VALUES ("GN26_5","002_26_5","GEN","26","5","5","ndax Ibraayma déggal na ma, sàmm na sama ndénkaane, ak samay santaane, ak sama dogali yoon, ak samay yoon.» ");
INSERT INTO wolmbs_vpl VALUES ("GN26_6","002_26_6","GEN","26","6","6","Isaaxa nag toog Gerar. ");
INSERT INTO wolmbs_vpl VALUES ("GN26_7","002_26_7","GEN","26","7","7","Góori foofa laaj ko ndaw si mu àndal, lu mu doon ci moom, mu ne: «Sama jigéen la.» Dafa bañoona wax ne soxnaam la, ngir ragal waa foofa rey ko ndax taaru Rebeka. ");
INSERT INTO wolmbs_vpl VALUES ("GN26_8","002_26_8","GEN","26","8","8","Ba ñu fa toogee ba mu yàgg, mu am bés Abimeleg, buurub waa Filisti tollu ci palanteeram, gis leen, fekk yóo Isaaxaa ngay raay soxnaam Rebeka. ");
INSERT INTO wolmbs_vpl VALUES ("GN26_9","002_26_9","GEN","26","9","9","Abimeleg woolu Isaaxa ne ko: «Kii kay ndeke sa soxna la! Noo mana waxe ne sa jigéen la?» Isaaxa ne ko: «Damaa waxe noonu, ngir ñu bañ maa rey ndax moom.» ");
INSERT INTO wolmbs_vpl VALUES ("GN26_10","002_26_10","GEN","26","10","10","Abimeleg ne ko: «Li nga nu def nag? Xaw tuuti kenn ci nit ñi tëdde sa soxna, te kon nga yóbbe nu tooñ.» ");
INSERT INTO wolmbs_vpl VALUES ("GN26_11","002_26_11","GEN","26","11","11","Abimeleg daldi fay doxe artu waa réewam mépp ne leen: «Ku laal waa jii walla soxnaam, dees na ko rey.» ");
INSERT INTO wolmbs_vpl VALUES ("GN26_12","002_26_12","GEN","26","12","12","Gannaaw loolu Isaaxa bey ca réew ma, góob ca at ma lu tollook téeméeri yoon la mu ji woon, ndax Aji Sax ji da koo barkeel. ");
INSERT INTO wolmbs_vpl VALUES ("GN26_13","002_26_13","GEN","26","13","13","Alalam di yokku, muy gëna barele, ba mujj am doole lool, ");
INSERT INTO wolmbs_vpl VALUES ("GN26_14","002_26_14","GEN","26","14","14","am géttu jur gu gudd ak gu gàtt, ak ay surga yu bare, ba tax waa Filisti iñaane ko, ");
INSERT INTO wolmbs_vpl VALUES ("GN26_15","002_26_15","GEN","26","15","15","bay sakk aka sëkk mboolem teen, yi surgay baayam Ibraayma gasoon ca jamonoom. ");
INSERT INTO wolmbs_vpl VALUES ("GN26_16","002_26_16","GEN","26","16","16","Abimeleg daldi ne Isaaxa: «Demal, ba sore nu, ndax danga noo ëpp doole lool.» ");
INSERT INTO wolmbs_vpl VALUES ("GN26_17","002_26_17","GEN","26","17","17","Isaaxa jóge foofa, dali ca xuru Gerar, sanc fa. ");
INSERT INTO wolmbs_vpl VALUES ("GN26_18","002_26_18","GEN","26","18","18","Ba loolu weesoo Isaaxa sikkli teen yi ñu gasoon ca jamonoy baayam Ibraayma, te waa Filisti sakkoon leen gannaaw ba Ibraayma nelawee. Ca la tudde teen yi tur, ya leen baayam tudde woon. ");
INSERT INTO wolmbs_vpl VALUES ("GN26_19","002_26_19","GEN","26","19","19","Surgay Isaaxa gasaat ca xur wa, jot ndox mu neex. ");
INSERT INTO wolmbs_vpl VALUES ("GN26_20","002_26_20","GEN","26","20","20","Teewul sàmmi Gerar di soowook sàmmi Isaaxa naan: «Nun noo moom ndox mi.» Mu tudde teen ba Eseg (muy firi Coow), ndax li ñu soowoo ak moom. ");
INSERT INTO wolmbs_vpl VALUES ("GN26_21","002_26_21","GEN","26","21","21","Ñu gasaat ab teen, xuloo amati ca, mu tudde ko Sitna (muy firi Xuloo). ");
INSERT INTO wolmbs_vpl VALUES ("GN26_22","002_26_22","GEN","26","22","22","Mu jóge foofa, gasati teen, jàmm ne ñoyy, mu tudde ko Rexobot (muy firi Fu yaatu), ndax da ne: «Léegi Aji Sax ji yaatal na nu, te dinanu woomle ci réew mi.» ");
INSERT INTO wolmbs_vpl VALUES ("GN26_23","002_26_23","GEN","26","23","23","Ba mu fa jógee, dafa dellu Beerseba. ");
INSERT INTO wolmbs_vpl VALUES ("GN26_24","002_26_24","GEN","26","24","24","Guddi googu Aji Sax ji feeñu ko ne ko: «Maay Yàllay Ibraayma sa baay; bul ragal dara, ndax maa ngi ànd ak yaw. Dinaa la barkeel, ful sa askan ndax sama jaam Ibraayma.» ");
INSERT INTO wolmbs_vpl VALUES ("GN26_25","002_26_25","GEN","26","25","25","Isaaxa nag sàkk fa sarxalukaay, tudd fa Aji Sax ji, wormaal ko, ba noppi samp fa xaymaam. Te itam ay surgaam bënn nañu fa ab teen. ");
INSERT INTO wolmbs_vpl VALUES ("GN26_26","002_26_26","GEN","26","26","26","Ci diggante boobu Abimeleg dafa jóge Gerar, dem fekki ko, ànd ak Axusat, ma doon wóllëreem, ak Pikol, njiital xarekatam. ");
INSERT INTO wolmbs_vpl VALUES ("GN26_27","002_26_27","GEN","26","27","27","Isaaxa ne leen: «Lu waral ngeen fekksi ma fii, gannaaw dangeen maa bañ, ba dàq ma?» ");
INSERT INTO wolmbs_vpl VALUES ("GN26_28","002_26_28","GEN","26","28","28","Ñu ne ko: «Gis nanu bu baax ne Aji Sax ji ànd na ak yaw; moo tax nu ne ayca nu waatoo ci sunu digganteek yaw te fasanteek yaw kóllëre. ");
INSERT INTO wolmbs_vpl VALUES ("GN26_29","002_26_29","GEN","26","29","29","Su ko defee doo nu def dara lu bon, gannaaw defunu la dara lu bon, xanaa lu baax rekk, ba yebal la, nga dem ci jàmm. Kon léegi yal na la Aji Sax ji barkeel.» ");
INSERT INTO wolmbs_vpl VALUES ("GN26_30","002_26_30","GEN","26","30","30","Isaaxa nag berndeel leen, ñu bokk lekk, ba noppi naan. ");
INSERT INTO wolmbs_vpl VALUES ("GN26_31","002_26_31","GEN","26","31","31","Ca ëllëg sa, ñu xëy suba teel, daldi waatoo, Isaaxa door leena yiwi, ñu dem ci jàmm. ");
INSERT INTO wolmbs_vpl VALUES ("GN26_32","002_26_32","GEN","26","32","32","Ca bés booba ay surgay Isaaxa ñëw nañu, di ko wax lu jëm ci teen, ba ñu doon gas, ne ko: «Gis nanu ndox.» ");
INSERT INTO wolmbs_vpl VALUES ("GN26_33","002_26_33","GEN","26","33","33","Isaaxa tudde teen ba Siba (muy firi Waatoo), moo tax turu dëkk ba, ba fii nu tollu, di Beerseba (muy firi Teenu waat ga). ");
INSERT INTO wolmbs_vpl VALUES ("GN26_34","002_26_34","GEN","26","34","34","Esawu am na ñeent fukki at, jël na soxna ku ñuy wax Yudit, muy doomu Beeri, miy Etteen, jëlaat Basmat doomu Elon, miy Etteen. ");
INSERT INTO wolmbs_vpl VALUES ("GN26_35","002_26_35","GEN","26","35","35","Jigéen ñooñu mu jël nag di naqar wu réy ci Isaaxa ak Rebeka. ");
INSERT INTO wolmbs_vpl VALUES ("GN27_1","002_27_1","GEN","27","1","1","Ba Isaaxa màggatee, te bët yi naqari, ba gisatul, am na bés mu woo taawam Esawu ne ko: «Doom.» Mu ne ko: «Naam.» ");
INSERT INTO wolmbs_vpl VALUES ("GN27_2","002_27_2","GEN","27","2","2","Isaaxa ne ko: «Déglul, ma wax la. Màggat naa te xawma sama bésu dee. ");
INSERT INTO wolmbs_vpl VALUES ("GN27_3","002_27_3","GEN","27","3","3","Kon léegi jëlal say gànnaay: say fitt ak sa xala, nga dem ca àll ba, rëbbali ma. ");
INSERT INTO wolmbs_vpl VALUES ("GN27_4","002_27_4","GEN","27","4","4","Toggal ma ko, ba mu neex, ni ma ko bëgge, indil ma, ma lekk, ndax ma ñaanal la lu ma tibbe ci sama xol, bala may dëddu.» ");
INSERT INTO wolmbs_vpl VALUES ("GN27_5","002_27_5","GEN","27","5","5","Fekk na Rebekaa ngi déglu, ba Isaaxay wax ak doomam Esawu. Esawu daldi dem ca àll ba, rëbbi lu mu toggsi. ");
INSERT INTO wolmbs_vpl VALUES ("GN27_6","002_27_6","GEN","27","6","6","Rebeka moom ne doomam Yanqóoba: «Dégg naa sa baay wax sa mag Esawu ne ko: ");
INSERT INTO wolmbs_vpl VALUES ("GN27_7","002_27_7","GEN","27","7","7","“Demal rëbbi, indil ma, toggal ma ko lu neex, ma lekk, ba ñaanal la, Aji Sax ji seede, bala may dëddu.” ");
INSERT INTO wolmbs_vpl VALUES ("GN27_8","002_27_8","GEN","27","8","8","Kon nag doom, defal lii ma lay wax. ");
INSERT INTO wolmbs_vpl VALUES ("GN27_9","002_27_9","GEN","27","9","9","Demal ca gétt ga, nga jàpp ñaari tef yu duuf, ma defaral ko sa baay, ba mu neex, ni mu ko bëgge, ");
INSERT INTO wolmbs_vpl VALUES ("GN27_10","002_27_10","GEN","27","10","10","nga yóbbul ko, ngir mu ñaanal la, bala moo dee.» ");
INSERT INTO wolmbs_vpl VALUES ("GN27_11","002_27_11","GEN","27","11","11","Yanqóoba ne yaayam: «Waaw, waaye sama mag Esawu dafa jëxëm, te man sama yaram rattax. ");
INSERT INTO wolmbs_vpl VALUES ("GN27_12","002_27_12","GEN","27","12","12","Xëy-na sama baay làmbatu ma de, te kon dina ne njublaŋ laa. Su ko defee ay móolu laay yóbbe sama bopp, waaye du barkeb ñaan.» ");
INSERT INTO wolmbs_vpl VALUES ("GN27_13","002_27_13","GEN","27","13","13","Yaayam ne ko: «Bu la móoloo, Yàlla na ma topp, doom. Defal li ma la wax rekk te dem indil ma gàtt yi.» ");
INSERT INTO wolmbs_vpl VALUES ("GN27_14","002_27_14","GEN","27","14","14","Yanqóoba dem, jël gàtt yi, indil yaayam, mu defar ba mu neex, ni ko baayam bëgge. ");
INSERT INTO wolmbs_vpl VALUES ("GN27_15","002_27_15","GEN","27","15","15","Rebeka daldi seet ca dencam la gën ca yérey Esawu taaw ba, solal Yanqóoba doomam ju ndaw. ");
INSERT INTO wolmbs_vpl VALUES ("GN27_16","002_27_16","GEN","27","16","16","Ba mu noppee, daa sàkk ca deri gàtt ya, sànge loxo ya ak fi rattax ci doq gi, ");
INSERT INTO wolmbs_vpl VALUES ("GN27_17","002_27_17","GEN","27","17","17","doora boole mburu ma ak ñam wa mu togg, jox doomam Yanqóoba. ");
INSERT INTO wolmbs_vpl VALUES ("GN27_18","002_27_18","GEN","27","18","18","Mu dikk ci baayam, ne ko: «Baay.» Mu ne ko: «Naam doom, kooku?» ");
INSERT INTO wolmbs_vpl VALUES ("GN27_19","002_27_19","GEN","27","19","19","Yanqóoba ne baayam: «Mana Esawu sa taaw. Def naa li nga ma wax. Jógal toog te lekk ci li ma la rëbbal, ndax nga ñaanal ma ci sa xol.» ");
INSERT INTO wolmbs_vpl VALUES ("GN27_20","002_27_20","GEN","27","20","20","Isaaxa ne doomam: «Moo doom! Noo def, ba gaawa jàpp nii?» Yanqóoba ne ko: «Aji Sax jiy sa Yàlla, moo ma ko jagleel.» ");
INSERT INTO wolmbs_vpl VALUES ("GN27_21","002_27_21","GEN","27","21","21","Isaaxa ne Yanqóoba: «Jegesil, ma làmb la, ba mu wóor ma ne sama doom Esawoo.» ");
INSERT INTO wolmbs_vpl VALUES ("GN27_22","002_27_22","GEN","27","22","22","Yanqóoba nag jegesi, baayam Isaaxa làmbatu ko ne: «Baat bi de baatu Yanqóobaa, waaye loxo yi, loxoy Esawoo.» ");
INSERT INTO wolmbs_vpl VALUES ("GN27_23","002_27_23","GEN","27","23","23","Xàmmeewu ko, ndax li loxo yi jëxëm ni yuy magam Esawu, ba tax mu ñaanal ko. ");
INSERT INTO wolmbs_vpl VALUES ("GN27_24","002_27_24","GEN","27","24","24","Isaaxa laaj ko ne ko: «Mbaa wóor na ne yaw ay Esawu?» Mu ne ko: «Waawaaw.» ");
INSERT INTO wolmbs_vpl VALUES ("GN27_25","002_27_25","GEN","27","25","25","Isaaxa ne ko: «Jottali ma fii ma lekk ci sam rëbb, doom, ba ñaanal la ci sama xol.» Yanqóoba jottali Isaaxa ndab li, mu lekk, daldi koy may biiñ, mu naan. ");
INSERT INTO wolmbs_vpl VALUES ("GN27_26","002_27_26","GEN","27","26","26","Isaaxa ne ko: «Kaay fii, fóon ma, doom.» ");
INSERT INTO wolmbs_vpl VALUES ("GN27_27","002_27_27","GEN","27","27","27","Yanqóoba jegesi, fóon ko, xetu yére yi mu sol xeeñ Isaaxa, mu door koo ñaanal ne ko: «Sama xetu doom kay xetug tool la, bu Aji Sax ji barkeel. ");
INSERT INTO wolmbs_vpl VALUES ("GN27_28","002_27_28","GEN","27","28","28","Yal na la Yàlla may layub asamaan ak ngëneeli suuf, pepp ne gàññ, biiñ walangaan. ");
INSERT INTO wolmbs_vpl VALUES ("GN27_29","002_27_29","GEN","27","29","29","Yal na la ay giir nangul, ay réew di la sujjóotal, nga yilif say bokk, te say doomi ndey di la sujjóotal. Ku la móolooy alku, te ku la ñaanal barkeel.» ");
INSERT INTO wolmbs_vpl VALUES ("GN27_30","002_27_30","GEN","27","30","30","Naka la Isaaxa noppee ñaanal Yanqóoba, ba mu won baayam Isaaxa gannaaw rekk, Esawu, mag ji, rëbbi ba ñëw, ne jalañ. ");
INSERT INTO wolmbs_vpl VALUES ("GN27_31","002_27_31","GEN","27","31","31","Mu togg moom it, ba mu neex, indil baayam. Mu ne ko: «Jógal baay, lekk ci sa rëbbum doom, ndax nga ñaanal ma ci sa xol.» ");
INSERT INTO wolmbs_vpl VALUES ("GN27_32","002_27_32","GEN","27","32","32","Baayam, Isaaxa ne ko: «Kooku?» Mu ne ko: «Mana sa taaw Esawu.» ");
INSERT INTO wolmbs_vpl VALUES ("GN27_33","002_27_33","GEN","27","33","33","Isaaxaa ngay lox, bay rag-ragi, daldi ne ko: «Kan? Ana ku rëbbi woon nag, indil ma, ba ma lekk ba noppi? Ñaanal naa ko bala ngaa ñëw. Te dina barkeel moos.» ");
INSERT INTO wolmbs_vpl VALUES ("GN27_34","002_27_34","GEN","27","34","34","Esawu dégg li baayam wax rekk, yuuxu yuux gu réy ndax naqar. Mu ne baayam: «Ngalla baay, ñaanal ma, man itam.» ");
INSERT INTO wolmbs_vpl VALUES ("GN27_35","002_27_35","GEN","27","35","35","Isaaxa ne ko: «Sa rakk ñëw na, nax ma, ba yóbbu sa ñaan.» ");
INSERT INTO wolmbs_vpl VALUES ("GN27_36","002_27_36","GEN","27","36","36","Esawu ne: «Moom kay moo yey tudd Yanqóoba, ndax suufu na ma ñaari yoon. Sama céru taaw la njëkka nangu, tey mu nangooti sama ñaanu baay.» Mu teg ca ne: «Ndax desalaloo ma ag ñaan?» ");
INSERT INTO wolmbs_vpl VALUES ("GN27_37","002_27_37","GEN","27","37","37","Isaaxa ne Esawu: «Mbaa am naa lu ma la ñaanalati, doom? Ndax kat xas naa koo def, muy sa kilifa, te bokkam yépp laa def ñuy surgaam, te pepp ak biiñ laa ko woomale it, ba mu ne gàññ.» ");
INSERT INTO wolmbs_vpl VALUES ("GN27_38","002_27_38","GEN","27","38","38","Esawu ne baayam: «Baay, xanaa genn ñaan rekk nga am? Ngalla baay, ñaanal ma, man itam!» Ca la Esawu ne yikkét jooy. ");
INSERT INTO wolmbs_vpl VALUES ("GN27_39","002_27_39","GEN","27","39","39","Baayam Isaaxa ne ko: «Déglul, ma wax la, dinga dëkk fu sore ngëneeli suuf, mbaa fu la layub asamaan tiime. ");
INSERT INTO wolmbs_vpl VALUES ("GN27_40","002_27_40","GEN","27","40","40","Sa saamar ngay dunde, sa rakk di la yilif. Waaye bés a ngi ñëw yaay sigiñu, ba yenniku nootaangeem.» ");
INSERT INTO wolmbs_vpl VALUES ("GN27_41","002_27_41","GEN","27","41","41","Esawu nag bañ Yanqóoba ndax barke ba ko baayam ñaanal. Ma ngay wax ca xolam naan: «Balaa yàgg ñu dëj sama baay, te bu boobaa dinaa rey sama rakk Yanqóoba.» ");
INSERT INTO wolmbs_vpl VALUES ("GN27_42","002_27_42","GEN","27","42","42","Naka lañu nettali Rebeka la taawam Esawu wax, mu woolu Yanqóoba, doomam ju ndaw ja, ne ko: «Sa mag a ngi fexee feyu, di la wuta rey. ");
INSERT INTO wolmbs_vpl VALUES ("GN27_43","002_27_43","GEN","27","43","43","Kon doom, defal lii ma lay wax, demal làquji fa sama càmmiñ Laban ca Karan, ");
INSERT INTO wolmbs_vpl VALUES ("GN27_44","002_27_44","GEN","27","44","44","nga toog fa moom ay fan, ba kera sa meru mag giif. ");
INSERT INTO wolmbs_vpl VALUES ("GN27_45","002_27_45","GEN","27","45","45","Bu sa meru mag giifee, ba mu fàtte li nga ko def, dinaa yónnee, ñu jëlsi la. Duma seetaan mukk, ba boole leen ñàkk, yeen ñaar ñépp, ci benn bés!» ");
INSERT INTO wolmbs_vpl VALUES ("GN27_46","002_27_46","GEN","27","46","46","Gannaaw gi, Rebeka ne Isaaxa: «Àddina soof na ma ndax jigéeni Etteen ñi. Yanqóoba de, bu jëlee ci jigéeni Etteen ñi ci réew mii, sama dund gi, dee a koy gën!» ");
INSERT INTO wolmbs_vpl VALUES ("GN28_1","002_28_1","GEN","28","1","1","Ci kaw loolu Isaaxa woo Yanqóoba, ñaanal ko, jox ko ndigal lii ne ko: «Bul jël ci jigéeni Kanaan, ");
INSERT INTO wolmbs_vpl VALUES ("GN28_2","002_28_2","GEN","28","2","2","waaye demal Padan Aram ca sa kër maam-góor, ji jur sa yaay, nga jël fa jabar ca sa doomi nijaay Laban. ");
INSERT INTO wolmbs_vpl VALUES ("GN28_3","002_28_3","GEN","28","3","3","Yal na la Yàlla Aji Man ji barkeel, nga jaboot lool te sa giir yokku, ba sos ay mboolooy askan. ");
INSERT INTO wolmbs_vpl VALUES ("GN28_4","002_28_4","GEN","28","4","4","Yal na la barkeb Ibraayma dal, yaak askan wi soqikoo ci yaw, ba nga moom réew mii ngay doxandéem tey, te Yàlla mayoon ko Ibraayma.» ");
INSERT INTO wolmbs_vpl VALUES ("GN28_5","002_28_5","GEN","28","5","5","Isaaxa daldi yebal Yanqóoba, mu dem Padan Aram ca Laban doomu Betuwel. Betuwel, Arameen la, te mooy càmmiñu Rebeka, miy yaayu Yanqóoba ak Esawu. ");
INSERT INTO wolmbs_vpl VALUES ("GN28_6","002_28_6","GEN","28","6","6","Esawu nag yég ne Isaaxa ñaanal na Yanqóoba, ba noppi yebal ko Padan Aram, ngir mu jël fa soxna. Te it ba mu koy ñaanal, digal na ko ne ko, bumu jël ca jigéeni Kanaan. ");
INSERT INTO wolmbs_vpl VALUES ("GN28_7","002_28_7","GEN","28","7","7","Mu yég ne Yanqóoba déggal na baayam ak yaayam, ba dem Padan Aram. ");
INSERT INTO wolmbs_vpl VALUES ("GN28_8","002_28_8","GEN","28","8","8","Loolu won Esawu ne jigéeni Kanaan neexuñu baayam. ");
INSERT INTO wolmbs_vpl VALUES ("GN28_9","002_28_9","GEN","28","9","9","Ba mu ko defee Esawu dem ca xeetu Ismayla, doomu Ibraayma, jël fa Maxalat, boole ko ciy soxnaam. Maxalat doomu Ismayla la te di jigéenu Nebayot. ");
INSERT INTO wolmbs_vpl VALUES ("GN28_10","002_28_10","GEN","28","10","10","Ba loolu wéyee Yanqóoba génn Beerseba, wuti Karan. ");
INSERT INTO wolmbs_vpl VALUES ("GN28_11","002_28_11","GEN","28","11","11","Naka la dem, ba àgg fu ko jant bi sowe, daldi fay fanaan. Mu jël ca doj ya fa ne woon, gegenoo. ");
INSERT INTO wolmbs_vpl VALUES ("GN28_12","002_28_12","GEN","28","12","12","Guddi googu Yanqóoba dafa gént, gis raas bu sampu ci suuf, te cat la sar asamaan, malaakay Yàlla yi di ci yéeg aka wàcc. ");
INSERT INTO wolmbs_vpl VALUES ("GN28_13","002_28_13","GEN","28","13","13","Ndeke Aji Sax jaa nga tollu ca wetam. Mu wax ak moom ne ko: «Maay Aji Sax ji, di sa Yàllay maam Ibraayma te di Yàllay Isaaxa. Suuf si nga tëdd dinaa la ko jox, yaak sa askan. ");
INSERT INTO wolmbs_vpl VALUES ("GN28_14","002_28_14","GEN","28","14","14","Saw askan dina ne gàññ ni feppi suuf. Dinga law penku ak sowu, ndijoor ak càmmoñ. Ci yaw ak saw askan la giir yi ci kaw suuf yépp di barkeele. ");
INSERT INTO wolmbs_vpl VALUES ("GN28_15","002_28_15","GEN","28","15","15","Maa ngi nii ànd ak yaw, di la sàmm fépp foo jëm, te itam dinaa la delloosi ci réew mii. Duma la bàyyi mukk, waaye dinaa def li ma la wax lépp.» ");
INSERT INTO wolmbs_vpl VALUES ("GN28_16","002_28_16","GEN","28","16","16","Ci kaw loolu Yanqóoba yewwu ne: «Ndekete Aji Sax ji mu ngi ci béreb bii, te xawma ko woon.» ");
INSERT INTO wolmbs_vpl VALUES ("GN28_17","002_28_17","GEN","28","17","17","Ma nga tiit nag te naan: «Béreb beeka raglu! Fii kay du fenn, fu dul kër Yàlla; te mooy buntu asamaan.» ");
INSERT INTO wolmbs_vpl VALUES ("GN28_18","002_28_18","GEN","28","18","18","Ca suba teel Yanqóoba jóg, jël doj, wi mu gegenoo woon, samp fa, muy xàmmikaay, ba noppi sotti ci ag diw, sellale ko. ");
INSERT INTO wolmbs_vpl VALUES ("GN28_19","002_28_19","GEN","28","19","19","Ca la tudde béreb ba Betel, waaye ca njàlbéen Lus la dëkk ba tuddoon. ");
INSERT INTO wolmbs_vpl VALUES ("GN28_20","002_28_20","GEN","28","20","20","Gannaaw loolu Yanqóoba dogu ne: «Su Yàlla àndee ak man, di ma sàmm ci yoon wi may aw, di ma jox lu ma lekk ak lu ma sol, ");
INSERT INTO wolmbs_vpl VALUES ("GN28_21","002_28_21","GEN","28","21","21","ba kera may dellu sama kër baay ci jàmm, su boobaa, Aji Sax ji dina doon sama Yàlla. ");
INSERT INTO wolmbs_vpl VALUES ("GN28_22","002_28_22","GEN","28","22","22","Doj wii ma samp, muy xàmmikaay, mooy doon kër Yàlla, te lépp lu mu ma wërsëgal, dinaa ko génneel fukkeel ba moos.» ");
INSERT INTO wolmbs_vpl VALUES ("GN29_1","002_29_1","GEN","29","1","1","Ba loolu xewee, Yanqóoba awaat yoonam, ba agsi réewum waa penku. ");
INSERT INTO wolmbs_vpl VALUES ("GN29_2","002_29_2","GEN","29","2","2","Mu yem foofa ca ab teen ca àll ba, ñetti gétti gàtt goor ca wet ga, ndax ca booba teen lañu doon wëgge gétt ya, waaye doj wu réy moo uboon teen ba. ");
INSERT INTO wolmbs_vpl VALUES ("GN29_3","002_29_3","GEN","29","3","3","Bu gétt yépp dajaloo foofa, sàmm yi doora àndandoo béraŋ doj wa, mu moy buntu teen ba, ñu wëgg, ba noppi delloo doj wa, mu ubaat teen ba. ");
INSERT INTO wolmbs_vpl VALUES ("GN29_4","002_29_4","GEN","29","4","4","Yanqóoba ne leen: «Bokki fan?» Ñu ne ko: «Karan.» ");
INSERT INTO wolmbs_vpl VALUES ("GN29_5","002_29_5","GEN","29","5","5","Mu ne leen: «Ndax xam ngeen Laban doomu Naxor?» Ñu ne ko: «Xam nanu ko kay.» ");
INSERT INTO wolmbs_vpl VALUES ("GN29_6","002_29_6","GEN","29","6","6","Mu dellu laaj leen ne leen: «Mbaa mu ngi ci jàmm?» Ñu ne ko: «Jàmm rekk kay. Xoolal ndaw see di ñëw, jiital gàtt yi, mooy Rasel, doomu Laban.» ");
INSERT INTO wolmbs_vpl VALUES ("GN29_7","002_29_7","GEN","29","7","7","Yanqóoba ne leen: «Jant bi demagul fenn, ba ngeen di dajale jur gi. Wëggleen gàtt yi, sàmmi leen kay!» ");
INSERT INTO wolmbs_vpl VALUES ("GN29_8","002_29_8","GEN","29","8","8","Ñu ne ko: «Dunu ko man mbete gétt yépp daje, nu béraŋ doj wi, ubbi teen bi, doora wëgg gàtt yi.» ");
INSERT INTO wolmbs_vpl VALUES ("GN29_9","002_29_9","GEN","29","9","9","Na muy waxe ak ñoom nag, Rasel agsi, indaale gàtti baayam, ndaxte sàmm la woon. ");
INSERT INTO wolmbs_vpl VALUES ("GN29_10","002_29_10","GEN","29","10","10","Ba Yanqóoba gisee Rasel, doomu nijaayam Laban, moom ak gàtti nijaayam ya, mu daagu ba ca teen ba, béraŋ doj wa ko ub, daldi wëgg gàtti Laban. ");
INSERT INTO wolmbs_vpl VALUES ("GN29_11","002_29_11","GEN","29","11","11","Ba loolu amee Yanqóoba fóon Rasel, ne yikkét jooy. ");
INSERT INTO wolmbs_vpl VALUES ("GN29_12","002_29_12","GEN","29","12","12","Ca la Yanqóoba waxe Rasel ne ko: «Maak sa baay a bokk, ndax maay sa doomu bàjjan Rebeka.» Rasel ne wëqét daw, yégal ko baayam. ");
INSERT INTO wolmbs_vpl VALUES ("GN29_13","002_29_13","GEN","29","13","13","Ba Laban déggee ne jarbaatam Yanqóoba ñëw na, mu daw gatandu ko, taf ko ci boppam, fóon ko, yóbbu ko kër ga. Ba Yanqóoba nettalee Laban lépp, ");
INSERT INTO wolmbs_vpl VALUES ("GN29_14","002_29_14","GEN","29","14","14","Laban da ne ko: «Yaw kay sama jarbaat nga lenqe!» Yanqóoba toog fa ak moom lu mat weer. ");
INSERT INTO wolmbs_vpl VALUES ("GN29_15","002_29_15","GEN","29","15","15","Gannaaw loolu Laban ne Yanqóoba: «Li ngay sama mbokk kat, taxul nga war maa liggéeyal ci neen. Wax ma lan mooy sa peyoor.» ");
INSERT INTO wolmbs_vpl VALUES ("GN29_16","002_29_16","GEN","29","16","16","Laban nag amoon na ñaari doom yu jigéen, taaw ba di Leya, rakk ja di Rasel. ");
INSERT INTO wolmbs_vpl VALUES ("GN29_17","002_29_17","GEN","29","17","17","Leya di ku bët ya yànjuloon, te Rasel nekkoon ku jekk te neexa xool. ");
INSERT INTO wolmbs_vpl VALUES ("GN29_18","002_29_18","GEN","29","18","18","Yanqóoba bëgg Rasel lool, ba ne Laban: «Dinaa la liggéeyal juróom ñaari at ngir Rasel sa doom ju ndaw ji.» ");
INSERT INTO wolmbs_vpl VALUES ("GN29_19","002_29_19","GEN","29","19","19","Laban ne ko: «Ma may la ko de moo ma gënal may ko keneen. Kon toogal ci man.» ");
INSERT INTO wolmbs_vpl VALUES ("GN29_20","002_29_20","GEN","29","20","20","Ci kaw loolu Yanqóoba liggéeyal Laban diiru juróom ñaari at ngir Rasel, te mu mel ni ay fan rekk ci moom ndax mbëggeel, gi mu am ci Rasel. ");
INSERT INTO wolmbs_vpl VALUES ("GN29_21","002_29_21","GEN","29","21","21","Loolu wéy, Yanqóoba ne Laban: «Jox ma sama jabar, ma séetal ko, ndax àpp bi jot na.» ");
INSERT INTO wolmbs_vpl VALUES ("GN29_22","002_29_22","GEN","29","22","22","Laban nangu, daldi togglu ay reer, woo ca waa gox ba bépp. ");
INSERT INTO wolmbs_vpl VALUES ("GN29_23","002_29_23","GEN","29","23","23","Timis jot Laban jël doomam Leya, jébbal ko Yanqóoba, mu tëdd ak moom. ");
INSERT INTO wolmbs_vpl VALUES ("GN29_24","002_29_24","GEN","29","24","24","Ci biir loolu Laban jël jaamam bu jigéen bu ñuy wax Silpa, may ko doomam Leya, mu dib jaamam. ");
INSERT INTO wolmbs_vpl VALUES ("GN29_25","002_29_25","GEN","29","25","25","Ba bët setee, Yanqóoba fekk muy Leya. Mu ne Laban: «Waaw, li nga ma def nag? Du Rasel a taxoon ma liggéeyal la? Lu tax nga wor ma?» ");
INSERT INTO wolmbs_vpl VALUES ("GN29_26","002_29_26","GEN","29","26","26","Laban ne ko: «Rakk njëkka séy taaw daal, du aada fii. ");
INSERT INTO wolmbs_vpl VALUES ("GN29_27","002_29_27","GEN","29","27","27","Séetul ak kii, ba ayu bésam mat, ma door laa jox ki ci des, soo ma dee liggéeyaatal diiru juróom ñaari at.» ");
INSERT INTO wolmbs_vpl VALUES ("GN29_28","002_29_28","GEN","29","28","28","Yanqóoba nangu, daldi séetu ak Leya ayu bés, ba noppi Laban jébbal ko doomam Rasel. ");
INSERT INTO wolmbs_vpl VALUES ("GN29_29","002_29_29","GEN","29","29","29","Booba la Laban jël jaamam bu jigéen bu ñuy wax Bilaa, may ko doomam Rasel, mu dib jaamam. ");
INSERT INTO wolmbs_vpl VALUES ("GN29_30","002_29_30","GEN","29","30","30","Yanqóoba nag tëdd ak Rasel, mi mu gënoona bëgg Leya. Ci kaw loolu mu liggéeyaatal Laban juróom ñaari at. ");
INSERT INTO wolmbs_vpl VALUES ("GN29_31","002_29_31","GEN","29","31","31","Ba Aji Sax ji gisee ne Leya fonkeesu ko, mu may ko, mu taawlu, te Rasel moom manula am doom. ");
INSERT INTO wolmbs_vpl VALUES ("GN29_32","002_29_32","GEN","29","32","32","Ba Leya ëmbee, am doom ju góor, da koo tudde Ruben (muy firi Gisleen, doom ju góor a ngi), ndaxte Leya da ne: «Aji Sax ji gis na sama toroxte. Léegi sama jëkkër dina ma bëgg.» ");
INSERT INTO wolmbs_vpl VALUES ("GN29_33","002_29_33","GEN","29","33","33","Mu dellu ëmb, am doom ju góor. Mu ne: «Aji Sax ji yég na ne fonkeesu ma, looloo tax mu mayaat ma doom jii.» Mu tudde ko Simeyon (muy firi Kiy dégg). ");
INSERT INTO wolmbs_vpl VALUES ("GN29_34","002_29_34","GEN","29","34","34","Mu delluwaat ëmb, am doom ju góor, ba noppi waxaat ne: «Bii yoon sama jëkkër dina am cofeel ci man, ndax jural naa ko ñetti doom yu góor,» loolu tax mu tudde ko Lewi (muy firi Boroom cofeel). ");
INSERT INTO wolmbs_vpl VALUES ("GN29_35","002_29_35","GEN","29","35","35","Mu dellooti ëmb, am doom ju góor daldi ne: «Bii yoon dinaa sant Aji Sax ji,» loolu tax mu tudde ko Yuda (muy firi Cant). Gannaaw loolu njuram taxaw. ");
INSERT INTO wolmbs_vpl VALUES ("GN30_1","002_30_1","GEN","30","1","1","Ba Rasel gisee ne amalul Yanqóoba doom, dafa ñee magam, ba tax mu wax Yanqóoba ne ko: «Nanu am ay doom, mbaa ma dee.» ");
INSERT INTO wolmbs_vpl VALUES ("GN30_2","002_30_2","GEN","30","2","2","Yanqóoba mere ca Rasel ne ko: «Ndax maay Yàlla, mi la teree am doom?» ");
INSERT INTO wolmbs_vpl VALUES ("GN30_3","002_30_3","GEN","30","3","3","Mu ne ko: «Xoolal, sama jaam Bilaa ngii; tëddal ak moom, ndax mu amal ma doom, ba jabootal ma.» ");
INSERT INTO wolmbs_vpl VALUES ("GN30_4","002_30_4","GEN","30","4","4","Ci kaw loolu mu may ko jaamam Bilaa, muy soxnaam. Yanqóoba ànd ak Bilaa, ");
INSERT INTO wolmbs_vpl VALUES ("GN30_5","002_30_5","GEN","30","5","5","mu ëmb, amal Yanqóoba doom ju góor. ");
INSERT INTO wolmbs_vpl VALUES ("GN30_6","002_30_6","GEN","30","6","6","Bi loolu amee Rasel ne: «Yàlla àtte na ma; dégg na sama ñaan, ba may ma doom.» Mu tudde ko nag Dan (muy firi Kiy àtte). ");
INSERT INTO wolmbs_vpl VALUES ("GN30_7","002_30_7","GEN","30","7","7","Gannaaw ga, Bilaa, jaamub Rasel, ëmbaat, dellu amal Yanqóoba doom ju góor. ");
INSERT INTO wolmbs_vpl VALUES ("GN30_8","002_30_8","GEN","30","8","8","Rasel ne: «Bëre naa ak sama mag bëre bu réy, ba daan,» daldi ko tudde Neftali (muy firi Kiy bëre). ");
INSERT INTO wolmbs_vpl VALUES ("GN30_9","002_30_9","GEN","30","9","9","Leya moom it xam ne taxawaayam yàgg na, mu fab jaamam Silpa, may ko Yanqóoba. ");
INSERT INTO wolmbs_vpl VALUES ("GN30_10","002_30_10","GEN","30","10","10","Bi loolu amee Silpa, jaamub Leya, amal Yanqóoba doom ju góor. ");
INSERT INTO wolmbs_vpl VALUES ("GN30_11","002_30_11","GEN","30","11","11","Leya ne: «Ndaw wërsëg wu réy!» daldi ko tudde Gàdd (muy firi Wërsëg). ");
INSERT INTO wolmbs_vpl VALUES ("GN30_12","002_30_12","GEN","30","12","12","Silpa jaamub Leya dellu, amal Yanqóoba doom ju góor. ");
INSERT INTO wolmbs_vpl VALUES ("GN30_13","002_30_13","GEN","30","13","13","Leya ne: «Éey waay, maaka bég! Jeeg ji dinañu ma woowe boroom mbégte mi.» Mu tudde ko nag Aser (muy firi Boroom mbégte). ");
INSERT INTO wolmbs_vpl VALUES ("GN30_14","002_30_14","GEN","30","14","14","Mu am bés ñuy góob bele, Ruben dem tool, sàkke ca gàncax gu ñu naan màndaragoor, indil ko yaayam Leya. Rasel ne Leya: «Ngalla may ma ci màndaragoor ji la sa doom indil.» ");
INSERT INTO wolmbs_vpl VALUES ("GN30_15","002_30_15","GEN","30","15","15","Teewul mu ne ko: «Ndax nangu sama jëkkër rekk doyu la, ba nga bëgg cee boole màndaragoor ji ma sama doom indil?» Rasel ne ko: «Kon jox ma ci màndaragoor ji sa doom indi, ma wecci la ko sama ayu tey boog.» ");
INSERT INTO wolmbs_vpl VALUES ("GN30_16","002_30_16","GEN","30","16","16","Yanqóobaa ngay jóge tool ca ngoon, Leya génn, gatandu ko, ne ko: «Fi man nga wara aye tey, ndaxte jënde naa ay gi màndaragoor ji sama doom indi.» Yanqóoba daldi féete ca moom guddi googu. ");
INSERT INTO wolmbs_vpl VALUES ("GN30_17","002_30_17","GEN","30","17","17","Yàlla nangul Leya, mu ëmb, am ak Yanqóoba seen juróomeelu doom ju góor. ");
INSERT INTO wolmbs_vpl VALUES ("GN30_18","002_30_18","GEN","30","18","18","Leya neeti: «Yàlla da maa fey, ndax maa may sama jëkkër sama jaam.» Mu tudde ko Isaakar (muy firi Boroom pey). ");
INSERT INTO wolmbs_vpl VALUES ("GN30_19","002_30_19","GEN","30","19","19","Gannaaw gi, Leya ëmbaat, am ak Yanqóoba seen juróom benneelu doom ju góor. ");
INSERT INTO wolmbs_vpl VALUES ("GN30_20","002_30_20","GEN","30","20","20","Booba la ne: «Yàlla defal na ma teraanga ju réy. Bii yoon sama jëkkër dina ma teral, ndax amal naa ko juróom benni doom yu góor.» Moo tax mu tudde ko Sabulon (muy firi Teraanga). ");
INSERT INTO wolmbs_vpl VALUES ("GN30_21","002_30_21","GEN","30","21","21","Gannaaw ga, mu am doom ju jigéen, tudde ko Diina. ");
INSERT INTO wolmbs_vpl VALUES ("GN30_22","002_30_22","GEN","30","22","22","Ba loolu amee Yàlla geestu Rasel, nangul ko, may ko doom. ");
INSERT INTO wolmbs_vpl VALUES ("GN30_23","002_30_23","GEN","30","23","23","Mu ëmb, am doom ju góor, daldi ne: «Yàlla teggil na ma gàcce.» ");
INSERT INTO wolmbs_vpl VALUES ("GN30_24","002_30_24","GEN","30","24","24","Moo tax mu tudde ko Yuusufa (muy firi Yal na dolli), ndax dafa ne: «Yal na ma Aji Sax ji dollil doom ju góor.» ");
INSERT INTO wolmbs_vpl VALUES ("GN30_25","002_30_25","GEN","30","25","25","Ba Rasel amee Yuusufa, Yanqóoba da ne Laban: «Yiwi ma boog, ma dellu sama réew ca sama kër. ");
INSERT INTO wolmbs_vpl VALUES ("GN30_26","002_30_26","GEN","30","26","26","Su ko defee nga jox ma samay doom ak sama jabar yi taxoon ma di la liggéeyal, te bàyyi ma, ma dem, ndax yaw ci sa bopp xam nga li ma la liggéeyal.» ");
INSERT INTO wolmbs_vpl VALUES ("GN30_27","002_30_27","GEN","30","27","27","Laban ne ko: «Ngalla waay, déglu ma, ngir sama ngisaane won na ma ne Aji Sax ji barkeel na ma ndax yaw. ");
INSERT INTO wolmbs_vpl VALUES ("GN30_28","002_30_28","GEN","30","28","28","Wax ma loo may feyeeku rekk, dinaa la ko fey.» ");
INSERT INTO wolmbs_vpl VALUES ("GN30_29","002_30_29","GEN","30","29","29","Yanqóoba ne ko: «Yaw ci sa bopp xam nga ni ma la liggéeyale ak ni sa gétt mujj mel ndax man; ");
INSERT INTO wolmbs_vpl VALUES ("GN30_30","002_30_30","GEN","30","30","30","ndaxte lu néew nga amoon laata may ñëw, te yokku na, ba bare lool, ngir Aji Sax ji da laa barkeel ndax man. Waaye léegi nag, liggéeyal sama waa kër bopp jot na xanaa?» ");
INSERT INTO wolmbs_vpl VALUES ("GN30_31","002_30_31","GEN","30","31","31","Laban dellu ne ko: «Dama ne, ñaata laa lay fey?» Yanqóoba ne ko: «Doo ma jox dara. Boo nangoo lii ma lay wax, dinaa sàmmaat say gàtt, wattu ko. ");
INSERT INTO wolmbs_vpl VALUES ("GN30_32","002_30_32","GEN","30","32","32","Damay seet tey jii ci biir jur gu gàtt gépp, génne ci xar yu ñuul yépp, ak bëy, yi todde ak yi tippante yépp, ñu doon sama peyoor. ");
INSERT INTO wolmbs_vpl VALUES ("GN30_33","002_30_33","GEN","30","33","33","Ëllëg ak sibir booy seetsi sama peyoor, sama njubtee may layool: lépp lu toddewul te tippantewul ci biir bëy yi ak lu ñuulul ci mburt yi, boo ko gisee ci man, càcc la.» ");
INSERT INTO wolmbs_vpl VALUES ("GN30_34","002_30_34","GEN","30","34","34","Laban ne: «Waaw, kon baax na.» ");
INSERT INTO wolmbs_vpl VALUES ("GN30_35","002_30_35","GEN","30","35","35","Ca bés booba Laban ber sikket, yi seereer te todde, ak bëy, yi tippante te todde, maanaam yi rax, ak xari menn melo yu ñuul yi, daldi leen dénk ay doomam. ");
INSERT INTO wolmbs_vpl VALUES ("GN30_36","002_30_36","GEN","30","36","36","Gannaaw loolu mu doxale digganteem ak Yanqóoba doxu ñetti fan. Yanqóoba nag di sàmm li des ci gàtti Laban. ");
INSERT INTO wolmbs_vpl VALUES ("GN30_37","002_30_37","GEN","30","37","37","Ci kaw loolu Yanqóoba tànn ñetti garab yu ñuy wax pëpalyee, gerte-tubaab ak palataan, gor ci bant yu tooy, xànc-xàncee ko, ba mu defi rëdd yu weex. ");
INSERT INTO wolmbs_vpl VALUES ("GN30_38","002_30_38","GEN","30","38","38","Mu yeb bant ya mu xànc-xàncee, ca naanukaay ya, mu janook jur ga, ca mbalka ya jur gay naane, ndax fa la jur ga daan tëboo. ");
INSERT INTO wolmbs_vpl VALUES ("GN30_39","002_30_39","GEN","30","39","39","Loolu tax bëy yay tëbu ca wetu car ya, di jur doom yu seereer, yu tippante ak yu todde. ");
INSERT INTO wolmbs_vpl VALUES ("GN30_40","002_30_40","GEN","30","40","40","Xar ya, Yanqóoba da leena ber, tey fexe ñuy janook lépp lu seereer ak lu ñuul ci biir juru Laban. Noonu la sàkke juru boppam, bañ koo boole ak juru Laban. ");
INSERT INTO wolmbs_vpl VALUES ("GN30_41","002_30_41","GEN","30","41","41","Saa yu jur gi ëpp doole dee tëbu, Yanqóoba yeb car yi ci naanukaay yi, tiimale ci jur gi, ngir bu ñuy tëbu, ne ci jàkk. ");
INSERT INTO wolmbs_vpl VALUES ("GN30_42","002_30_42","GEN","30","42","42","Bu jur gu xiibon gi dee tëbu, mu bañ leena tegal dara. Muy def noonu ba jur gi xiibon, di gu Laban, gi am doole, di gu Yanqóoba. ");
INSERT INTO wolmbs_vpl VALUES ("GN30_43","002_30_43","GEN","30","43","43","Waa ji mujj na barele lool, am gàtt yu ne gàññ ak ay jaam yu góor ak yu jigéen ak ay giléem aki mbaam-sëf. ");
INSERT INTO wolmbs_vpl VALUES ("GN31_1","002_31_1","GEN","31","1","1","Ba loolu amee mu am bés Yanqóoba dégg doomi Laban ya naan, Yanqóoba nangu na li seen baay amoon lépp, te ci seen alalu baay la sàkkoo alalam jooju jépp. ");
INSERT INTO wolmbs_vpl VALUES ("GN31_2","002_31_2","GEN","31","2","2","Naka la Yanqóoba gis kanamu Laban, daldi xam ne melatul, na mu meloon ci moom. ");
INSERT INTO wolmbs_vpl VALUES ("GN31_3","002_31_3","GEN","31","3","3","Aji Sax ji wax Yanqóoba ne ko: «Dellul ca sa réewu maam ya, ca say bokk. Dinaa ànd ak yaw.» ");
INSERT INTO wolmbs_vpl VALUES ("GN31_4","002_31_4","GEN","31","4","4","Yanqóoba woolu Rasel ak Leya ca tool ya, fa gàttam ya nekk. ");
INSERT INTO wolmbs_vpl VALUES ("GN31_5","002_31_5","GEN","31","5","5","Mu ne leen: «Gis naa seen kanamu baay. Xam naa ne melatul na mu meloon ci man. Waaye sama Yàllay baay ay ànd ak man. ");
INSERT INTO wolmbs_vpl VALUES ("GN31_6","002_31_6","GEN","31","6","6","Yeen ci seen bopp xam ngeen ne liggéeyal naa seen baay sama kem kàttan. ");
INSERT INTO wolmbs_vpl VALUES ("GN31_7","002_31_7","GEN","31","7","7","Teewul seen baay wor ma, soppi sama peyoor fukki yoon ak juróom, waaye Yàlla seetaanu ko, mu di ma lor. ");
INSERT INTO wolmbs_vpl VALUES ("GN31_8","002_31_8","GEN","31","8","8","Bu nee: “Yi tippanteey sa peyoor,” jur gépp jur lu tippante; mbaa mu ne: “Yi seereer ay sa peyoor,” jur gépp jur lu seereer. ");
INSERT INTO wolmbs_vpl VALUES ("GN31_9","002_31_9","GEN","31","9","9","Nii la Yàlla nangoo seen juru baay, jox ma. ");
INSERT INTO wolmbs_vpl VALUES ("GN31_10","002_31_10","GEN","31","10","10","«Ba ñu demee ba jur giy wara tëbu, damaa jeneer sikket yiy tëb bëy yi yépp di lu seereer ak lu tippante mbaa ñu raxe. ");
INSERT INTO wolmbs_vpl VALUES ("GN31_11","002_31_11","GEN","31","11","11","Ca la ma malaakam Yàlla ma wax ci biir gént gi ne ma: “Yanqóoba,” ma ne ko: “Naam.” ");
INSERT INTO wolmbs_vpl VALUES ("GN31_12","002_31_12","GEN","31","12","12","Mu ne ma: “Siggil, xool sikket yiy tëb bëy yi yépp, yii dañoo seereer, yee todde, yi ci des tippante, ndaxte gis naa li la Laban di def lépp. ");
INSERT INTO wolmbs_vpl VALUES ("GN31_13","002_31_13","GEN","31","13","13","Maay Yàlla, ja la feeñu woon Betel, fa nga samp doj, sotti ci diw, sellale ko, te dogu woon fa ci man. Léegi nag jógal, génn réew mii, dellu ca réew ma nga juddoo.”» ");
INSERT INTO wolmbs_vpl VALUES ("GN31_14","002_31_14","GEN","31","14","14","Rasel ak Leya ne ko: «Ndax amati nanu benn cér walla ndono sunu kër baay? ");
INSERT INTO wolmbs_vpl VALUES ("GN31_15","002_31_15","GEN","31","15","15","Doonunu lu moy ay doxandéem ci moom de! Nde da noo jaay, lekk sunu njëg, ba mu jeex tàkk. ");
INSERT INTO wolmbs_vpl VALUES ("GN31_16","002_31_16","GEN","31","16","16","Te mboolem alal, ji Yàlla nangoo ci sunu baay, noo ko moom, nun ak sunuy doom. Kon nag léegi lu la Yàlla wax rekk, def ko.» ");
INSERT INTO wolmbs_vpl VALUES ("GN31_17","002_31_17","GEN","31","17","17","Yanqóoba daldi dajale ay doomam ak ay soxnaam, waral leen giléem, ");
INSERT INTO wolmbs_vpl VALUES ("GN31_18","002_31_18","GEN","31","18","18","ñu ànd tegu ca yoon wa, yóbbaale géttam gépp ak mboolem alal ju mu liggéey. Mooy gétt, ga mu sàkkoo Padan Aram. Ña ngay ñibbi kër baayam Isaaxa ca réewu Kanaan. ");
INSERT INTO wolmbs_vpl VALUES ("GN31_19","002_31_19","GEN","31","19","19","Fekk na Laban dem wati ay xaram. Ci biir loolu Rasel sàcc gàllaaji kër yu baayam. ");
INSERT INTO wolmbs_vpl VALUES ("GN31_20","002_31_20","GEN","31","20","20","Noonu la Yanqóoba nëbboo Laban, Arameen ba, bañ koo yégal ne day dem. ");
INSERT INTO wolmbs_vpl VALUES ("GN31_21","002_31_21","GEN","31","21","21","Ba mu demee, dafa yóbbaale la mu amoon lépp, jóge fa, jàll dexu Efraat, wuti tundi Galàdd. ");
INSERT INTO wolmbs_vpl VALUES ("GN31_22","002_31_22","GEN","31","22","22","Yanqóoba daw na, ba mu am ñetti fan, ñu soog koo yégal Laban. ");
INSERT INTO wolmbs_vpl VALUES ("GN31_23","002_31_23","GEN","31","23","23","Mu ànd nag ak ay bokkam, topp ko juróom ñaari fan, door koo dab ca tundi Galàdd. ");
INSERT INTO wolmbs_vpl VALUES ("GN31_24","002_31_24","GEN","31","24","24","Ci kaw loolu Yàlla feeñu Laban, Arameen ba, ci géntu guddi ne ko: «Moytula wax Yanqóoba lenn lu koy gaar.» ");
INSERT INTO wolmbs_vpl VALUES ("GN31_25","002_31_25","GEN","31","25","25","Ba Laban dabee Yanqóoba, dafa fekk mu samp xaymaam ca tund wa. Laban it samp bosam ca kaw tundi Galàdd, moom aki bokkam. ");
INSERT INTO wolmbs_vpl VALUES ("GN31_26","002_31_26","GEN","31","26","26","Laban ne Yanqóoba: «Looy def nii, yaw, danga maa njublaŋ, yóbbaale sama doom yu jigéen, ñu mel ni ñu ñu jàppe ci xare? ");
INSERT INTO wolmbs_vpl VALUES ("GN31_27","002_31_27","GEN","31","27","27","Lu waral nga di ma nëbbuy daw, di ma njublaŋ, te bañ maa tàggu? Nde kon jombul ma yiwi la ci xol bu sedd, bu ànd aki woy, boole ci xalam aki sabar. ");
INSERT INTO wolmbs_vpl VALUES ("GN31_28","002_31_28","GEN","31","28","28","Mayoo ma sax, ma fóon samay sët ak samay doom yu jigéen, tàggatook ñoom; yëfi dof de nga def nii! ");
INSERT INTO wolmbs_vpl VALUES ("GN31_29","002_31_29","GEN","31","29","29","Manoon naa laa def lu bon, waaye sa Yàllay baay da maa feeñu biig ne ma: “Moytula wax Yanqóoba lenn lu koy gaar.” ");
INSERT INTO wolmbs_vpl VALUES ("GN31_30","002_31_30","GEN","31","30","30","Bu la neexee, nga namm sa kër baay, ba dogu caa dem, waaye lu tax nga sàcc sama gàllaaji kër, teg ci?» ");
INSERT INTO wolmbs_vpl VALUES ("GN31_31","002_31_31","GEN","31","31","31","Yanqóoba tontu Laban ne ko: «Xanaa ragaloon rekk ne jombul dinga téye say doom yu jigéen. ");
INSERT INTO wolmbs_vpl VALUES ("GN31_32","002_31_32","GEN","31","32","32","Waaye képp koo gis mu yor sa gàllaaji kër, boo yeboo reyal. Seetal fii ci sunu kanami bokk lépp lu ma fi yor, loo ci moom fabal, yóbbu.» Booba Yanqóoba xamul woon ne Rasel a ko jël. ");
INSERT INTO wolmbs_vpl VALUES ("GN31_33","002_31_33","GEN","31","33","33","Laban dugg ci xaymab Yanqóoba, teg ca xaymab Leya ak yosi ñaari jaamam yu jigéen ya, te gisul dara. Mu génne xaymab Leya, dugg ci bu Rasel. ");
INSERT INTO wolmbs_vpl VALUES ("GN31_34","002_31_34","GEN","31","34","34","Fekk na Rasel fab gàllaaji kër ya, làq ca ron tegu giléem ga, toog ca. Laban tëcc, tëcc ca biir xayma ba, gisul dara. ");
INSERT INTO wolmbs_vpl VALUES ("GN31_35","002_31_35","GEN","31","35","35","Rasel wax baayam ne ko: «Baay, baal ma de, damaa manula jóg ci sa kanam, ndaxte damaa ànd ak mbaax.» Laban seet na fu ne, waaye gisul gàllaaji këram ya. ");
INSERT INTO wolmbs_vpl VALUES ("GN31_36","002_31_36","GEN","31","36","36","Yanqóoba mer lool, daldi gëdd Laban ne ko: «Ndax damaa tooñ walla damaa moy, ba nga sambal ma, di ma topp nii? ");
INSERT INTO wolmbs_vpl VALUES ("GN31_37","002_31_37","GEN","31","37","37","Bi nga jéexee sama yëf yépp ba noppi, ana loo gis lu bokk ci sa yëfi kër? Teg ko fii ci sama kanami bokk ak say bokk, ñu àtte nu. ");
INSERT INTO wolmbs_vpl VALUES ("GN31_38","002_31_38","GEN","31","38","38","Xanaa du ñaar fukki at a ngii ma nekk ak yaw? Say xar ak say bëy ëmbuñu sax, mu yàqu, te masumaa lekk sa kuuyi gétt. ");
INSERT INTO wolmbs_vpl VALUES ("GN31_39","002_31_39","GEN","31","39","39","Jur gu rab fàdd sax ma féetewoo, waaye masuma la koo indil. Mboolem lu ñu sàcc guddi ak lu ñu sàcc bëccëg, danga ma ko daa feyu. ");
INSERT INTO wolmbs_vpl VALUES ("GN31_40","002_31_40","GEN","31","40","40","Naaj wi laa daan yendoo yenu bëccëg, di fanaanoo sedd guddi, mu xaw maa rey, ba duma gëmm bët. ");
INSERT INTO wolmbs_vpl VALUES ("GN31_41","002_31_41","GEN","31","41","41","Ñaar fukki at a ngii, ma di la jaamu ci kër gi, liggéeyal naa la fukki at ak ñeent ngir sa ñaari doom yu jigéen ñii, teg ci juróom benni at yu ma la sàmmal say gàtt, nga soppi sama peyoor fukki yoon ak juróom. ");
INSERT INTO wolmbs_vpl VALUES ("GN31_42","002_31_42","GEN","31","42","42","Su dul woon ak sama Yàllay baay, ji ànd ak man, di Yàllay Ibraayma ji Isaaxa wormaaloon, doon nga ma dàq tey, ma deme loxoy neen. Waaye sama toskare ak sama àqu ñaq la Yàlla gis, ba tax mu àtte ma ak yaw biig.» ");
INSERT INTO wolmbs_vpl VALUES ("GN31_43","002_31_43","GEN","31","43","43","Ba mu ko waxee loolu, Laban ne ko: «Jigéen ñii samay doom lañu, xale yii di samay sët, te gétt gii sama gétt a; lu fi nekk maa ko moom. Ñii di sama doom yu jigéen, nu ma leen di def tey, ñoom ak seeni doom? ");
INSERT INTO wolmbs_vpl VALUES ("GN31_44","002_31_44","GEN","31","44","44","Léegi ñëwal rekk, ñu fasante kóllëre maak yaw, te seede dox sunu diggante maak yaw.» ");
INSERT INTO wolmbs_vpl VALUES ("GN31_45","002_31_45","GEN","31","45","45","Ba loolu amee Yanqóoba jël aw doj, samp ko, muy doju xàmmikaay. ");
INSERT INTO wolmbs_vpl VALUES ("GN31_46","002_31_46","GEN","31","46","46","Yanqóoba ne ay bokkam: «Forleen ay doj.» Ñu for ay doj, def ko ab jal, daldi bokk lekk foofa ca wetu jal ba. ");
INSERT INTO wolmbs_vpl VALUES ("GN31_47","002_31_47","GEN","31","47","47","Laban tudde béreb ba Yegar Saaduta (muy firi Jalub seede); Yanqóoba tudde ko Galet. ");
INSERT INTO wolmbs_vpl VALUES ("GN31_48","002_31_48","GEN","31","48","48","Booba la Laban ne: «Jal bii tey, mooy sunu seede sama diggante ak yaw.» Moo tax ñu tudde ko Galet (muy firi Jalub seede). ");
INSERT INTO wolmbs_vpl VALUES ("GN31_49","002_31_49","GEN","31","49","49","Ñu di ko tudde itam Mispa (muy firi Tatay wattukaay), ndax Laban da ne: «Yal na Aji Sax ji wattu sunu diggante, keroog bu ñu soree. ");
INSERT INTO wolmbs_vpl VALUES ("GN31_50","002_31_50","GEN","31","50","50","Soo soxoree samay doom yu jigéen, mbaa nga takk yeneen jabar, bu fa kenn nekkul sax, moytul, ndax Yàllaa nuy seede.» ");
INSERT INTO wolmbs_vpl VALUES ("GN31_51","002_31_51","GEN","31","51","51","Laban neeti Yanqóoba: «Xoolal ci jal bii ak doju xàmmikaay, wi ci sama digganteek yaw. ");
INSERT INTO wolmbs_vpl VALUES ("GN31_52","002_31_52","GEN","31","52","52","Jal bi seede la, doj wi di seede ne duma jéggi jal bi, jublu ci yaw, te yaw itam doo jéggi jal bi mbaa doj wi, jublu ci man, te naraluloo ma jàmm. ");
INSERT INTO wolmbs_vpl VALUES ("GN31_53","002_31_53","GEN","31","53","53","Yàllay Ibraayma ak Yàllay Naxor, ñoom ñooñee di seen Yàllay baay, yal nañu àtte sunu diggante.» Yanqóoba daldi giñ ci Yàlla ji baayam Isaaxa wormaaloon. ");
INSERT INTO wolmbs_vpl VALUES ("GN31_54","002_31_54","GEN","31","54","54","Gannaaw loolu Yanqóoba sàkk sarax ca kaw tund wa, woo ay bokkam, ñu bokk lekk. Ba ñu lekkee ba noppi, fanaan ca tund wa. ");
INSERT INTO wolmbs_vpl VALUES ("GN32_1","002_32_1","GEN","32","1","1","Ca ëllëg sa, Laban xëy suba teel, tàggoo aki sëtam ak doomam yu jigéen ya, ñaanal leen, ba noppi waññiku ñibbi. ");
INSERT INTO wolmbs_vpl VALUES ("GN32_2","002_32_2","GEN","32","2","2","Yanqóoba moom topp yoonam. Ci kaw loolu ay malaakay Yàlla feeñu ko. ");
INSERT INTO wolmbs_vpl VALUES ("GN32_3","002_32_3","GEN","32","3","3","Ba leen Yanqóoba gisee, da ne dalub Yàllaa ngii, ba tax mu tudde béreb ba Maxanayim (muy firi Ñaari dal). ");
INSERT INTO wolmbs_vpl VALUES ("GN32_4","002_32_4","GEN","32","4","4","Ba loolu amee Yanqóoba dafa yónni ay ndaw, ñu jiitu ko ca magam Esawu, ca réewu Seyir, di diiwaanu Edom. ");
INSERT INTO wolmbs_vpl VALUES ("GN32_5","002_32_5","GEN","32","5","5","Mu sant leen ne leen: «Bu ngeen demee ca sama sang Esawu, neleen ko: Sa surga Yanqóoba nee na: “Maa nga woon ca kër Laban bu yàgg ba tey, ");
INSERT INTO wolmbs_vpl VALUES ("GN32_6","002_32_6","GEN","32","6","6","ma doora ñëw, ànd ak ay nag ak ay mbaam ak ay gàtt ak ay jaam yu góor ak yu jigéen; may yónnee ci yaw, di la siyaare tey sàkku nga dalal ma jàmm.”» ");
INSERT INTO wolmbs_vpl VALUES ("GN32_7","002_32_7","GEN","32","7","7","Ndaw ya daldi dem ba délsi ca Yanqóoba, ne ko: «Dem nanu ca sa mag Esawu, waaye moom ci boppam mu ngi ci yoon wi di ñëw, fekksi la fii, te ma nga ànd ak ñeenti téeméeri góor.» ");
INSERT INTO wolmbs_vpl VALUES ("GN32_8","002_32_8","GEN","32","8","8","Yanqóoba dégg loolu, tiit lool te ànd ak njàqare, ba tax mu séddale mbooloo, ma mu àndal, gàtt ya ak jur gu gudd ga ak giléem ya itam, mu xaaj leen ñaar. ");
INSERT INTO wolmbs_vpl VALUES ("GN32_9","002_32_9","GEN","32","9","9","Booba mu ngi naan, bu Esawu songee benn dal bi, dal bi ci des mana raw. ");
INSERT INTO wolmbs_vpl VALUES ("GN32_10","002_32_10","GEN","32","10","10","Ci kaw loolu Yanqóoba ñaan Yàlla, ne ko: «Yaw Aji Sax ji, sama Yàllay maam Ibraayma, di sama Yàllay baay Isaaxa itam, yaa ma ne woon: “Dellul réew ma nga cosaanoo, ca say bokk; dinaa la baaxe.” ");
INSERT INTO wolmbs_vpl VALUES ("GN32_11","002_32_11","GEN","32","11","11","Yelloowuma lu gëna tuuti ci sa ngor ak sa worma, gi nga ma won, man sa jaam. Aw yet doŋŋ laa yoroon, ba ma jàllee dexu Yurdan, te yokku naa tey, ba doon ñaari dal. ");
INSERT INTO wolmbs_vpl VALUES ("GN32_12","002_32_12","GEN","32","12","12","Maa ngi lay ñaan, nga musal ma ci sama loxol mag Esawu, ndaxte ragal naa, mu ñëw bóom ma, bóomaale jigéen ñi ak seeni doom. ");
INSERT INTO wolmbs_vpl VALUES ("GN32_13","002_32_13","GEN","32","13","13","Te yaw yaa ma ne: “Dinaa la baaxe moos, yokk saw askan, ba mu tollu ni suufas géej si kenn manula lim ndax bare.”» ");
INSERT INTO wolmbs_vpl VALUES ("GN32_14","002_32_14","GEN","32","14","14","Yanqóoba fanaan na fa guddig keroog, doora sàkk ca alalam, sédd magam Esawu, ");
INSERT INTO wolmbs_vpl VALUES ("GN32_15","002_32_15","GEN","32","15","15","lépp di ñaari téeméeri bëy ak ñaar fukki sikket ak ñaari téeméeri xar ak ñaar fukki kuuy ");
INSERT INTO wolmbs_vpl VALUES ("GN32_16","002_32_16","GEN","32","16","16","ak fanweeri giléem yu seeni doom di nàmp, ak ñeent fukki nag ak fukki yëkk ak ñaar fukki mbaam yu jigéen ak fukki mbaam yu góor. ");
INSERT INTO wolmbs_vpl VALUES ("GN32_17","002_32_17","GEN","32","17","17","Mu ber gétt yi, gu ci nekk mu jox ay surgaam, ne leen: «Jiituleen ma, te na gétt yi dàndante.» ");
INSERT INTO wolmbs_vpl VALUES ("GN32_18","002_32_18","GEN","32","18","18","Ci biir loolu mu sant ki jiitu, ne ko: «Boo dajeek sama mag, mu laaj la ne la: “Kuy sa njaatige?” ak “Ku moom li nga jiital?” ak “Foo jëm?” ");
INSERT INTO wolmbs_vpl VALUES ("GN32_19","002_32_19","GEN","32","19","19","nee ko: “Lii de sang bi, lu la Yanqóoba may la, di la ko siyaaree, yaw Esawu, te moom ci boppam mu ngi topp ci sunu gannaaw.”» ");
INSERT INTO wolmbs_vpl VALUES ("GN32_20","002_32_20","GEN","32","20","20","Ndigal loolu la joxaat ñaareelu surga ba ak ñetteel ba ak mboolem ña topp ca gétt ya, ku ci nekk mu wax ko ne ko loolu lay wax Esawu, bu ko gisee, ");
INSERT INTO wolmbs_vpl VALUES ("GN32_21","002_32_21","GEN","32","21","21","tegati ca ne ko: «Te nee ko itam: “Sa surga Yanqóobaa ngi topp ci sunu gannaaw.”» Booba Yanqóobaa ngi naa ci xelam: «Bu ma jiitalee li ma ko may, neexale ko ko, bala maa janook moom, jombul mu dalal ma jàmm.» ");
INSERT INTO wolmbs_vpl VALUES ("GN32_22","002_32_22","GEN","32","22","22","Neexal ba da koo jiitu, moom mu fanaan guddig keroog ca dal ba. ");
INSERT INTO wolmbs_vpl VALUES ("GN32_23","002_32_23","GEN","32","23","23","Gannaaw loolu Yanqóoba jóg ca guddi ga, ànd ak ñaari soxnaam, ñaari jaamam yu jigéen ak fukki doomam yu góor ak benn, daldi jàll dexu Yabog. ");
INSERT INTO wolmbs_vpl VALUES ("GN32_24","002_32_24","GEN","32","24","24","Yanqóoba da leena jàllale, jàllewaale alalam jépp itam. ");
INSERT INTO wolmbs_vpl VALUES ("GN32_25","002_32_25","GEN","32","25","25","Mu des fa nag moom doŋŋ. Kera la genn góor fanaane bëre ak moom, ba bët set. ");
INSERT INTO wolmbs_vpl VALUES ("GN32_26","002_32_26","GEN","32","26","26","Ba nit ka xamee ne manalu ko dara, dafa dóor Yanqóoba ci yaxu mooco bi, mu summikoo ca bëre ba. ");
INSERT INTO wolmbs_vpl VALUES ("GN32_27","002_32_27","GEN","32","27","27","Nit ka ne ko: «Bàyyi ma, ma dem, ndax bët a ngi bëgga set.» Teewul Yanqóoba ne ko: «Duma la bàyyi, nga dem, li feek ñaanaloo ma.» ");
INSERT INTO wolmbs_vpl VALUES ("GN32_28","002_32_28","GEN","32","28","28","Nit ka ne ko: «Na nga tudd?» Mu ne ko: «Yanqóoba.» ");
INSERT INTO wolmbs_vpl VALUES ("GN32_29","002_32_29","GEN","32","29","29","Nit ka ne ko: «Tuddatuloo Yanqóoba, léegi Israayil nga tudd, ndaxte bëre nga ak nit, bëre ak Yàlla, ba génn ci ak jàmm.» ");
INSERT INTO wolmbs_vpl VALUES ("GN32_30","002_32_30","GEN","32","30","30","Yanqóoba ne ko: «Waaw, yaw nag noo tudd?» Mu wax ko ne ko: «Loo may laaje sama tur?» ba noppi barkeel ko foofa. ");
INSERT INTO wolmbs_vpl VALUES ("GN32_31","002_32_31","GEN","32","31","31","Ci kaw loolu Yanqóoba tudde béreb ba Peniyel (muy firi Xar-kanamu Yàlla), ndaxte da ne: «Ne naa Yàlla jàkk, te maa ngi dund ba tey.» ");
INSERT INTO wolmbs_vpl VALUES ("GN32_32","002_32_32","GEN","32","32","32","Ba jant bay fenk, Yanqóobaa ngi soox tànk bi, di bàyyikoo Penuwel. ");
INSERT INTO wolmbs_vpl VALUES ("GN32_33","002_32_33","GEN","32","33","33","Looloo tax ba tey jii bànni Israayil duñu lekk yàpp wi jàpp ci tenqob mooco, ndax li moocob Yanqóoba summikoo woon ca suuxu tenqo ba. ");
INSERT INTO wolmbs_vpl VALUES ("GN33_1","002_33_1","GEN","33","1","1","Gannaaw loolu Yanqóoba séen Esawu di ñëw, ànd ak ñeenti téeméeri góor, mu séddale xale yi, diggante Leya, Rasel ak ñaari jaam ya. ");
INSERT INTO wolmbs_vpl VALUES ("GN33_2","002_33_2","GEN","33","2","2","Dafa jiital jaam ya ak seeni doom, tofal ca Leya ak ay doomam, Rasel ak Yuusufa féete gannaaw. ");
INSERT INTO wolmbs_vpl VALUES ("GN33_3","002_33_3","GEN","33","3","3","Moom ci boppam nag, mu jiitu leen, wutali magam, di dox tey sujjóot, ba muy juróom ñaari yoon. ");
INSERT INTO wolmbs_vpl VALUES ("GN33_4","002_33_4","GEN","33","4","4","Teewul Esawu daw gatandu ko, taf ko ci boppam, langaamu ko, di ko fóon. Ñu daldi jooy! ");
INSERT INTO wolmbs_vpl VALUES ("GN33_5","002_33_5","GEN","33","5","5","Naka la Esawu siggi, gis jigéen ñi ak xale yi, mu ne: «Ñii ànd ak yaw ñooy ñan?» Yanqóoba ne ko: «Xanaa njaboot, gi ma Yàlla baaxe, sang bi.» ");
INSERT INTO wolmbs_vpl VALUES ("GN33_6","002_33_6","GEN","33","6","6","Jaam ya ak seeni doom daldi jegesi, sujjóotal ko. ");
INSERT INTO wolmbs_vpl VALUES ("GN33_7","002_33_7","GEN","33","7","7","Leya it topp ca, moom aki doomam, jegesi ñoom itam, sujjóot. Yuusufa ak Rasel doora jegesi sujjóot. ");
INSERT INTO wolmbs_vpl VALUES ("GN33_8","002_33_8","GEN","33","8","8","Esawu ne ko: «Waaw, dal bu réy bii ma dajeel, loo ci namm?» Yanqóoba ne ko: «Xanaa di sàkku nga dalal ma jàmm rekk, sang bi.» ");
INSERT INTO wolmbs_vpl VALUES ("GN33_9","002_33_9","GEN","33","9","9","Esawu ne ko: «Am naa lu ne gàññ, sama rakk, fabal sa alal.» ");
INSERT INTO wolmbs_vpl VALUES ("GN33_10","002_33_10","GEN","33","10","10","Yanqóoba ne ko: «Ngalla waay déet, dimbali ma rekk te jël li ma la may. Ndaxte bi ma nee jàkk ci sa kanam, gis naa ni nga ma laaye biir, ba mu mel ni Yàllaa ma geestoo yërmandeem. ");
INSERT INTO wolmbs_vpl VALUES ("GN33_11","002_33_11","GEN","33","11","11","Kon jëlal lii ma la may, ndax Yàlla baaxe na ma, ba ma barele.» Mu tinu ko, ba Esawu mujj nangu. ");
INSERT INTO wolmbs_vpl VALUES ("GN33_12","002_33_12","GEN","33","12","12","Gannaaw loolu Esawu ne: «Tee noo ànd dem boog, ma jiitu la?» ");
INSERT INTO wolmbs_vpl VALUES ("GN33_13","002_33_13","GEN","33","13","13","Yanqóoba ne ko: «Sang bi, xam nga, xale yi dañoo néew doole, te it gàtt yi ak nag yiy nàmpal laay xalaat. Su nu leen sëqatalee benn bés rekk, gàtt yépp dee. ");
INSERT INTO wolmbs_vpl VALUES ("GN33_14","002_33_14","GEN","33","14","14","Jiitu ma rekk, sang bi, man ma topp ndànk ci wewu jur gi, jiital leen, te baña raw xale yi, ba kera ma lay fekksi Seyir.» ");
INSERT INTO wolmbs_vpl VALUES ("GN33_15","002_33_15","GEN","33","15","15","Esawu ne ko: «Xaaral ma bàyyee la ñenn ci góor ñi ma àndal.» Yanqóoba ne ko: «Matu ko. Boobu teraanga ëpp na, sang bi. Jàmm ji nga ma dalal rekk doy na.» ");
INSERT INTO wolmbs_vpl VALUES ("GN33_16","002_33_16","GEN","33","16","16","Booba la Esawu dellu, jubal yoonu Seyir. ");
INSERT INTO wolmbs_vpl VALUES ("GN33_17","002_33_17","GEN","33","17","17","Yanqóoba moom jubal gox bu ñu naan Sukkót, tabax fa kër, mbaaral géttam, moo tax ñu tudde béreb boobu Sukkót (muy firi ay Mbaar). ");
INSERT INTO wolmbs_vpl VALUES ("GN33_18","002_33_18","GEN","33","18","18","Gannaaw ga, Yanqóoba agsi Sikem, ga ca réewu Kanaan, ci jàmm. Fekk na mu bàyyikoo Padan Aram, ba dal fa jàkkaarlook dëkk ba. ");
INSERT INTO wolmbs_vpl VALUES ("GN33_19","002_33_19","GEN","33","19","19","Booba la jënde ca sëti Amor, baayu Sikem, pàkk, ba mu sampoon xaymaam, ci téeméeri kesita. ");
INSERT INTO wolmbs_vpl VALUES ("GN33_20","002_33_20","GEN","33","20","20","Mu daldi fay sàkk sarxalukaay, tudde ko El Elowe Israayil (muy firi Yàllay Israayil mooy Yàlla). ");
INSERT INTO wolmbs_vpl VALUES ("GN34_1","002_34_1","GEN","34","1","1","Am na bés Diina, ku jigéen ki Leya am ak Yanqóoba, génn di seeti moroom ya ca dëkk ba. ");
INSERT INTO wolmbs_vpl VALUES ("GN34_2","002_34_2","GEN","34","2","2","Ci kaw loolu Sikem doomu Amor, miy Eween te di kilifa ca dëkk ba, daldi koy gis, jàpp ko, tëdde ko, toroxal ko. ");
INSERT INTO wolmbs_vpl VALUES ("GN34_3","002_34_3","GEN","34","3","3","Gannaaw bi, Sikem xemmem na Diina doomu Yanqóoba lool te bëgg ko, ba tax mu di ko naxtaan. ");
INSERT INTO wolmbs_vpl VALUES ("GN34_4","002_34_4","GEN","34","4","4","Loolu waral mu ne baayam Amor: «Ñaanal ma janq bi jabar.» ");
INSERT INTO wolmbs_vpl VALUES ("GN34_5","002_34_5","GEN","34","5","5","Yanqóoba nag dégg ne Sikem toroxal na Diina, doomam ju jigéen, fekk booba doomam yu góor yaa nga woon ca àll ba, fa jur ga nekk. Yanqóoba ne cell, ba ñu ñibbisi. ");
INSERT INTO wolmbs_vpl VALUES ("GN34_6","002_34_6","GEN","34","6","6","Ci diggante boobu Amor, baayu Sikem, ñëw ci Yanqóoba, ngir gise ak moom. ");
INSERT INTO wolmbs_vpl VALUES ("GN34_7","002_34_7","GEN","34","7","7","Ca la doomi Yanqóoba agsee, jóge ca tool ya. Ba ñu déggee la xew, dañoo am naqar wu réy, mer lool ndax gàcce, ga Sikem teg waa Israayil, ba mu tëddee doomu Yanqóoba ja, te loolu di lu defuwul. ");
INSERT INTO wolmbs_vpl VALUES ("GN34_8","002_34_8","GEN","34","8","8","Amor wax ak ñoom ne leen: «Sama doom Sikem dafa bëgg seen jigéen ci xolam. Dama leen di ñaan, ngeen may ko ko jabar. ");
INSERT INTO wolmbs_vpl VALUES ("GN34_9","002_34_9","GEN","34","9","9","Tee noo séyante, ngeen may nu seeni janq, te jël ci sunuy janq? ");
INSERT INTO wolmbs_vpl VALUES ("GN34_10","002_34_10","GEN","34","10","10","Su ko defee ngeen dëkk ak nun te réew mi di seen réew. Man ngeen fee sanc, dem fu leen neex, sàkku fi alal.» ");
INSERT INTO wolmbs_vpl VALUES ("GN34_11","002_34_11","GEN","34","11","11","Sikem it wax ak baayu Diina ak càmmiñ ya ne leen: «Su ngeen ma nangulee, lépp lu ngeen ma wax dinaa ko joxe. ");
INSERT INTO wolmbs_vpl VALUES ("GN34_12","002_34_12","GEN","34","12","12","Limalleen ma warugar yi ak nu mu mana tollu, boole ci may gi; dinaa joxe lu ngeen ma sas; mayleen ma janq bi rekk.» ");
INSERT INTO wolmbs_vpl VALUES ("GN34_13","002_34_13","GEN","34","13","13","Waaye doomi Yanqóoba ya, ay nax lañu tontoo Sikem ak baayam Amor, ndax li Sikem toroxal seen jigéen Diina. ");
INSERT INTO wolmbs_vpl VALUES ("GN34_14","002_34_14","GEN","34","14","14","Dañu ne leen: «Manunu loolu, ndax may sunu jigéen góor gu xaraful, loolu gàcce la ci nun. ");
INSERT INTO wolmbs_vpl VALUES ("GN34_15","002_34_15","GEN","34","15","15","Dunu leen mana nangul mbete ngeen melee ni nun ci kaw seeni góor ñépp xaraf. ");
INSERT INTO wolmbs_vpl VALUES ("GN34_16","002_34_16","GEN","34","16","16","Su ko defee dinanu leen may sunuy janq, te dinanu jël ci seeni janq, dëkk ak yeen, nuy ay bokk. ");
INSERT INTO wolmbs_vpl VALUES ("GN34_17","002_34_17","GEN","34","17","17","Waaye su ngeen nu déggalul, ba xarafuleen, danuy jël sunu jigéen, dem.» ");
INSERT INTO wolmbs_vpl VALUES ("GN34_18","002_34_18","GEN","34","18","18","Seen wax jooju neex Amor ak Sikem doomu Amor. ");
INSERT INTO wolmbs_vpl VALUES ("GN34_19","002_34_19","GEN","34","19","19","Xale bu góor bi daldi gaawtu def li ñu ko sant ndax mbëggeelam ca doomu Yanqóoba. Booba Sikem lañu gënoona weg ca waa kër baayam yépp. ");
INSERT INTO wolmbs_vpl VALUES ("GN34_20","002_34_20","GEN","34","20","20","Amor nag ànd ak doomam Sikem, dem ba ca pénc ma, wax ak waa dëkk ba ne leen: ");
INSERT INTO wolmbs_vpl VALUES ("GN34_21","002_34_21","GEN","34","21","21","«Ñii sunuy am-di-jàmm lañu, te gannaaw réew maa ngi ne yàmblaŋ, bàyyileen leen, ñu sanc te dem fu leen neex. Man nanoo jël seen doomi janq te di leen may sunuy doom. ");
INSERT INTO wolmbs_vpl VALUES ("GN34_22","002_34_22","GEN","34","22","22","Waaye li ci nekk mooy, seeni góor duñu nangoo dëkk ak nun, nuy ay bokk, ndare sunu góor ñépp xaraf ni ñoom. ");
INSERT INTO wolmbs_vpl VALUES ("GN34_23","002_34_23","GEN","34","23","23","Bu nu leen nangulee, ba ñu dëkk ci sunu biir, kon seeni jur ak seen alal ak seen mala yépp, ndax du nooy doon boroom?» ");
INSERT INTO wolmbs_vpl VALUES ("GN34_24","002_34_24","GEN","34","24","24","Ba mu ko defee mboolem góori dëkk ba déggal Amor ak doomam Sikem, ba ñoom ñépp xaraf. ");
INSERT INTO wolmbs_vpl VALUES ("GN34_25","002_34_25","GEN","34","25","25","Ca gannaaw ëllëg sa, fekk waa dëkk ba nekk ci mititu xarafal ba, ñaari doomi Yanqóoba ya, Simeyon ak Lewi, càmmiñi Diina, jël seeni saamar, dugg ca dëkk ba, bett leen, rey góor ñépp. ");
INSERT INTO wolmbs_vpl VALUES ("GN34_26","002_34_26","GEN","34","26","26","Ca lañu leel ñawkay saamar Amor ak doomam Sikem, ñu dee, ñu jële Diina kër Sikem, ànd ak moom, dem. ");
INSERT INTO wolmbs_vpl VALUES ("GN34_27","002_34_27","GEN","34","27","27","La ca tegu doomi Yanqóoba ya ca des futti néew ya, jëlaale alalu waa dëkk ba, ndax li ñu toroxal seen jigéen. ");
INSERT INTO wolmbs_vpl VALUES ("GN34_28","002_34_28","GEN","34","28","28","Ñu daldi jël seen jur gu gàtt ak gu gudd, seeni mbaam ak mboolem la ca biir dëkk ba ak la ko wër. ");
INSERT INTO wolmbs_vpl VALUES ("GN34_29","002_34_29","GEN","34","29","29","Noonu lañu jële seen alal jépp ak seeni doom ak seeni jabar, boole ca jël mboolem lu nekkoon ca biir kër ya. ");
INSERT INTO wolmbs_vpl VALUES ("GN34_30","002_34_30","GEN","34","30","30","Yanqóoba nag wax ak Simeyon ak Lewi ne leen: «Indil ngeen ma musiba, ndax dingeen tax waa réew mépp jéppi ma, muy Kanaaneen ñi, di Periseen ñi. Te itam awma lu dul góor ñu néew, te bu ñu booloo dal ci sama kaw, dañu may booleek sama waa kër faagaagal.» ");
INSERT INTO wolmbs_vpl VALUES ("GN34_31","002_34_31","GEN","34","31","31","Ñu ne ko: «Danuy seetaan sunu jigéen daal, ñu di ko def ab gànc?» ");
INSERT INTO wolmbs_vpl VALUES ("GN35_1","002_35_1","GEN","35","1","1","Ba loolu wéyee Yàlla ne Yanqóoba: «Jógal dem Betel, toog fa te nga sàkkal fa sarxalukaay Yàlla, ji la feeñu, ba ngay daw sa mag Esawu.» ");
INSERT INTO wolmbs_vpl VALUES ("GN35_2","002_35_2","GEN","35","2","2","Yanqóoba wax ak waa këram ak ñi ànd ak moom ñépp ne leen: «Jëleleen ci seen biir tuuri doxandéem yi, te ngeen sangu-set te solu. ");
INSERT INTO wolmbs_vpl VALUES ("GN35_3","002_35_3","GEN","35","3","3","Danuy dem Betel, ma sàkkal fa sarxalukaay Yàlla ji ma wallu, ba ma nekkee ci njàqare, te ànd ak man fépp fu ma jaar.» ");
INSERT INTO wolmbs_vpl VALUES ("GN35_4","002_35_4","GEN","35","4","4","Ñu daldi jox Yanqóoba mboolem tuuri doxandéem, yi ñu yor, ak seen jaaroy nopp, Yanqóoba boole suul ca taatu garab gu mag ga nekkoon ca wetu dëkk, ba ñu naan Sikem. ");
INSERT INTO wolmbs_vpl VALUES ("GN35_5","002_35_5","GEN","35","5","5","Gannaaw loolu ñu sàqi, Yàlla nag wàcce tiitaange ju réy ca kaw dëkk ya leen wër, ba taluñoo dabi doomi Yanqóoba ya. ");
INSERT INTO wolmbs_vpl VALUES ("GN35_6","002_35_6","GEN","35","6","6","Ba mu ko defee Yanqóoba ak ñi mu àndal ñépp agsi Lus, di Betel ba tey, foofa ca réewu Kanaan. ");
INSERT INTO wolmbs_vpl VALUES ("GN35_7","002_35_7","GEN","35","7","7","Mu sàkk fa nag sarxalukaay, tudde béreb ba El Betel, ndax foofa la ko Yàlla feeñoo, bi muy daw magam. ");
INSERT INTO wolmbs_vpl VALUES ("GN35_8","002_35_8","GEN","35","8","8","Foofa itam la Debora, ma daa nàmpal Rebeka, faatoo, ñu suul ko ca taatu garab gu mag ga ca wetu Betel. Ñu tudde garab ga Alon Bakut (muy firi Garabu jooyoo). ");
INSERT INTO wolmbs_vpl VALUES ("GN35_9","002_35_9","GEN","35","9","9","Ba Yanqóoba jógee Padan Aram, Yàlla feeñuwaat na ko, barkeel ko ");
INSERT INTO wolmbs_vpl VALUES ("GN35_10","002_35_10","GEN","35","10","10","ne ko: «Yaa di Yanqóoba, waaye deesatu la woowe Yanqóoba; léegi yaa di Israayil.» Mu tudde ko nag Israayil. ");
INSERT INTO wolmbs_vpl VALUES ("GN35_11","002_35_11","GEN","35","11","11","Yàlla neeti ko: «Man maay Yàlla Aji Man ji. Giiral te yokku, ba aw xeet ak mboolooy xeet sosoo ci yaw, te ay buur askanoo ci sa geño. ");
INSERT INTO wolmbs_vpl VALUES ("GN35_12","002_35_12","GEN","35","12","12","Réew mi ma sédd Ibraayma ak Isaaxa, yaw laa koy sédd, yaak askan wi soqikoo ci yaw.» ");
INSERT INTO wolmbs_vpl VALUES ("GN35_13","002_35_13","GEN","35","13","13","Naka la Yàlla wax ak Yanqóoba loolu, daldi teqalikoo ak moom. ");
INSERT INTO wolmbs_vpl VALUES ("GN35_14","002_35_14","GEN","35","14","14","Yanqóoba samp doju xàmmikaay ca béreb, ba Yàlla waxe ak moom, tuural ko fa biiñ, sotti fa diw, sellale. ");
INSERT INTO wolmbs_vpl VALUES ("GN35_15","002_35_15","GEN","35","15","15","Yanqóoba ma nga tudde béreb ba Yàlla waxeek moom, Betel. ");
INSERT INTO wolmbs_vpl VALUES ("GN35_16","002_35_16","GEN","35","16","16","Ba loolu wéyee ñu jóge Betel, dem bay bëgga jub Efrata. Rasel tollu ciw mat, te mat wi metti. ");
INSERT INTO wolmbs_vpl VALUES ("GN35_17","002_35_17","GEN","35","17","17","Ba mu demee ba mat wa gëna metti, rewlikat ba ne ko: «Muñal nag, ndax góor laati de!» ");
INSERT INTO wolmbs_vpl VALUES ("GN35_18","002_35_18","GEN","35","18","18","Booba Rasel a ngi waaja faatu. Terewul bala bakkanam a rot tudde na xale bi Benoni (muy firi Sama doomu coono). Teewul baay bi tudde ko Beñamin (muy firi Sama doomu njiglaay). ");
INSERT INTO wolmbs_vpl VALUES ("GN35_19","002_35_19","GEN","35","19","19","Ci kaw loolu Rasel faatu, ñu denc ko ca yoonu Efrata, ga ñuy wax Betleyem ba tey. ");
INSERT INTO wolmbs_vpl VALUES ("GN35_20","002_35_20","GEN","35","20","20","Yanqóoba nag samp aw doj ca bàmmeel ba, te mooy xàmmikaayu bàmmeelu Rasel ba tey jii. ");
INSERT INTO wolmbs_vpl VALUES ("GN35_21","002_35_21","GEN","35","21","21","Ba mu ko defee Israayil jóge fa, samp xaymaam ca gannaaw Migdal Eder. ");
INSERT INTO wolmbs_vpl VALUES ("GN35_22","002_35_22","GEN","35","22","22","Ba Israayil dëkkee ca réew ma, am na bés Ruben dem tëdd ak Bilaa, nekkaaleb baayam; Israayil yég ko. Doomi Yanqóoba yu góor fukk lañu ak ñaar. ");
INSERT INTO wolmbs_vpl VALUES ("GN35_23","002_35_23","GEN","35","23","23","Doomi Leya ñooy: Ruben, taawub Yanqóoba, ak Simeyon ak Lewi ak Yuda ak Isaakar ak Sabulon. ");
INSERT INTO wolmbs_vpl VALUES ("GN35_24","002_35_24","GEN","35","24","24","Doomi Rasel di Yuusufa ak Beñamin. ");
INSERT INTO wolmbs_vpl VALUES ("GN35_25","002_35_25","GEN","35","25","25","Doomi Bilaa, jaamub Rasel, di Dan ak Neftali. ");
INSERT INTO wolmbs_vpl VALUES ("GN35_26","002_35_26","GEN","35","26","26","Doomi Silpa, jaamub Leya, di Gàdd ak Aser. Ñooñooy doomi Yanqóoba, te mu ame leen ca Padan Aram. ");
INSERT INTO wolmbs_vpl VALUES ("GN35_27","002_35_27","GEN","35","27","27","Yanqóoba dellu na kër baayam Isaaxa fa Mamre, ca Kiryaat Arba, gay Ebron ba tey, fa Ibraayma ak Isaaxa daloon. ");
INSERT INTO wolmbs_vpl VALUES ("GN35_28","002_35_28","GEN","35","28","28","Isaaxa dund na téeméeri at ak juróom ñett fukk (180). ");
INSERT INTO wolmbs_vpl VALUES ("GN35_29","002_35_29","GEN","35","29","29","Foofa la bakkanam rote, mu faatu, fekki ay maamam, gannaaw ba mu màggatee, ba ñor xomm. Ba loolu amee ay doomam Esawu ak Yanqóoba rob ko. ");
INSERT INTO wolmbs_vpl VALUES ("GN36_1","002_36_1","GEN","36","1","1","Askanu Esawu, mi ñuy wax Edom, mooy lii. ");
INSERT INTO wolmbs_vpl VALUES ("GN36_2","002_36_2","GEN","36","2","2","Esawu jël na janqi Kanaaneen jabar. Ñooñoo di Ada doomu Elon, Etteen ba, ak Olibama doomu Ana, miy doomu Cibeyon, Eween ba, ");
INSERT INTO wolmbs_vpl VALUES ("GN36_3","002_36_3","GEN","36","3","3","ak Basmat doomu Ismayla, di jigéenub Nebayot. ");
INSERT INTO wolmbs_vpl VALUES ("GN36_4","002_36_4","GEN","36","4","4","Ada am ak Esawu Elifas; Basmat am ca Rewel. ");
INSERT INTO wolmbs_vpl VALUES ("GN36_5","002_36_5","GEN","36","5","5","Olibama am ca Yewus, Yalam ak Kore. Ñooñu ñooy doomi Esawu yu góor, te mu am leen ca réewu Kanaan. ");
INSERT INTO wolmbs_vpl VALUES ("GN36_6","002_36_6","GEN","36","6","6","Ba loolu amee Esawu ànd aki soxnaam, aki doomam yu góor ak yu jigéen, ak waa këram ñépp, jiital géttam ak juram gépp, yóbbaale mboolem alal ju mu amoon ca réewu Kanaan, daldi sanci meneen réew ngir sore rakkam Yanqóoba. ");
INSERT INTO wolmbs_vpl VALUES ("GN36_7","002_36_7","GEN","36","7","7","Li ko waral mooy, seen alal dafa bare woon lool, ba manuñoo dëkk ñoom ñaar, te réew mi ñu daloon, àttanu leen ndax seen gétt yu bare. ");
INSERT INTO wolmbs_vpl VALUES ("GN36_8","002_36_8","GEN","36","8","8","Esawu nag dëkk ca tundu Seyir: Esawu moomu mooy Edom. ");
INSERT INTO wolmbs_vpl VALUES ("GN36_9","002_36_9","GEN","36","9","9","Askanu Esawu, di maami Edomeen ña ca tundi Seyir, mooy lii. ");
INSERT INTO wolmbs_vpl VALUES ("GN36_10","002_36_10","GEN","36","10","10","Doomi Esawu yu góor ñooy: Elifas, mi mu am ak soxnaam Ada; ak Rewel, mi mu am ak soxnaam Basmat. ");
INSERT INTO wolmbs_vpl VALUES ("GN36_11","002_36_11","GEN","36","11","11","Doomi Elifas yu góor yi di Teman ak Omar ak Cefo ak Gatam ak Kenas. ");
INSERT INTO wolmbs_vpl VALUES ("GN36_12","002_36_12","GEN","36","12","12","Elifas amoon na it nekkaale bu ñuy wax Timna. Mu am caak moom Amaleg. Ñooñoo xeetoo ci Ada, soxnas Esawu. ");
INSERT INTO wolmbs_vpl VALUES ("GN36_13","002_36_13","GEN","36","13","13","Doomi Rewel yu góor ñoo di Naxat ak Sera ak Saama ak Misa. Ñooñoo xeetoo ca Basmat, soxnas Esawu. ");
INSERT INTO wolmbs_vpl VALUES ("GN36_14","002_36_14","GEN","36","14","14","Soxnas Esawu, si ñu naa Olibama, tey doomu Ana miy doomu Cibeyon, moo am ak Esawu doom yu góor yii: Yewus ak Yalam ak Kore. ");
INSERT INTO wolmbs_vpl VALUES ("GN36_15","002_36_15","GEN","36","15","15","Làngi doomi Esawu yu góor nag, ñooy ñii. Ñi askanoo ci Elifas taawub Esawu, ñuy Teman ak Omar ak Cefo ak Kenas ");
INSERT INTO wolmbs_vpl VALUES ("GN36_16","002_36_16","GEN","36","16","16","ak Kore ak Gatam ak Amaleg, ku ci nekk ak làngam. Làngi Elifas, ya ca réewum Edom a ngi noonu; ñooy sëti Ada. ");
INSERT INTO wolmbs_vpl VALUES ("GN36_17","002_36_17","GEN","36","17","17","Ñi askanoo ci Rewel doomu Esawu, ñooy Naxat ak Sera ak Saama ak Misa, ku ci nekk ak làngam. Làngi Rewel, ya ca réewum Edom a ngi noonu; ñooy sëti Basmat, soxnas Esawu. ");
INSERT INTO wolmbs_vpl VALUES ("GN36_18","002_36_18","GEN","36","18","18","Ñi xeetoo ci Olibama soxnas Esawu, ñooy Yewus, Yalam ak Kore, ku ci nekk ak làngam. Ñooñooy làngi Olibama, soxnas Esawu siy doomu Ana. ");
INSERT INTO wolmbs_vpl VALUES ("GN36_19","002_36_19","GEN","36","19","19","Ñooñooy doomi Esawu, mi ñuy wax Edom, ñooñooy doomam yu góor, ñook seeni làng. ");
INSERT INTO wolmbs_vpl VALUES ("GN36_20","002_36_20","GEN","36","20","20","Doomi Seyir yu góor, ya bokk ca waa Or te sancoon ca réew ma, ñooy Lotan ak Sobal ak Cibeyon ak Ana ");
INSERT INTO wolmbs_vpl VALUES ("GN36_21","002_36_21","GEN","36","21","21","ak Dison ak Eccer ak Disan. Ñooñooy làngi waa Or, di sëti Seyir ya ca réewum Edom. ");
INSERT INTO wolmbs_vpl VALUES ("GN36_22","002_36_22","GEN","36","22","22","Doomi Lotan yu góor ñoo di Ori ak Emam. Jigéenub Lotan di Timna. ");
INSERT INTO wolmbs_vpl VALUES ("GN36_23","002_36_23","GEN","36","23","23","Doomi Sobal yu góor ñoo di Alwan ak Manaxat ak Ebal ak Sefo ak Onam. ");
INSERT INTO wolmbs_vpl VALUES ("GN36_24","002_36_24","GEN","36","24","24","Doomi Cibeyon yu góor di Aya ak Ana. Te Ana moomu moo feeñal bëti ndox yu tàng ya ca màndiŋ ma, ba muy sàmm mbaami baayam Cibeyon. ");
INSERT INTO wolmbs_vpl VALUES ("GN36_25","002_36_25","GEN","36","25","25","Doomu Ana ju góor mooy Dison, ak Olibama, doomam ju jigéen. ");
INSERT INTO wolmbs_vpl VALUES ("GN36_26","002_36_26","GEN","36","26","26","Doomi Dison yu góor di Emdan ak Esban ak Yittran ak Keran. ");
INSERT INTO wolmbs_vpl VALUES ("GN36_27","002_36_27","GEN","36","27","27","Doomi Eccer yu góor ñoo di Bilan ak Saawan ak Akan. ");
INSERT INTO wolmbs_vpl VALUES ("GN36_28","002_36_28","GEN","36","28","28","Doomi Disan yu góor di Ucc ak Aran. ");
INSERT INTO wolmbs_vpl VALUES ("GN36_29","002_36_29","GEN","36","29","29","Làngi waa Or ñooy ñi askanoo ci Lotan ak Sobal ak Cibeyon ak Ana ");
INSERT INTO wolmbs_vpl VALUES ("GN36_30","002_36_30","GEN","36","30","30","ak Dison ak Eccer ak Disan, ku ci nekk ak làngam. Ñooñooy làngi waa Or, na ñu xàjjalikoo kenn-kenn ca réewu Seyir. ");
INSERT INTO wolmbs_vpl VALUES ("GN36_31","002_36_31","GEN","36","31","31","Buur ya falu woon ca réewum Edom, lu jiitu benn buuru bànni Israayil di falu ñii la: ");
INSERT INTO wolmbs_vpl VALUES ("GN36_32","002_36_32","GEN","36","32","32","Bela doomu Bewor ju góor falu na ca Edom. Dinaba moo doon péeyam. ");
INSERT INTO wolmbs_vpl VALUES ("GN36_33","002_36_33","GEN","36","33","33","Ba Bela faatoo, Yobab doomu Sera, ma dëkk Boccara, moo falu buur, wuutu ko. ");
INSERT INTO wolmbs_vpl VALUES ("GN36_34","002_36_34","GEN","36","34","34","Ba Yobab faatoo, Usam ma bokk ci diiwaanu waa Teman falu buur, wuutu ko. ");
INSERT INTO wolmbs_vpl VALUES ("GN36_35","002_36_35","GEN","36","35","35","Ba Usam faatoo, Adàdd, doomu Bedàdd ju góor, ja duma woon waa Majan ca réewu Mowab, daldi falu buur, wuutu ko. Péeyam moo doon Awit. ");
INSERT INTO wolmbs_vpl VALUES ("GN36_36","002_36_36","GEN","36","36","36","Ba Adàdd faatoo, Samla ma dëkk Masreka moo falu buur, wuutu ko. ");
INSERT INTO wolmbs_vpl VALUES ("GN36_37","002_36_37","GEN","36","37","37","Ba Samla faatoo, Sawul mu Rexobot Efraat moo falu buur, wuutu ko. ");
INSERT INTO wolmbs_vpl VALUES ("GN36_38","002_36_38","GEN","36","38","38","Ba Sawul faatoo, Baal Anan doomu Agbor ju góor moo falu buur, wuutu ko. ");
INSERT INTO wolmbs_vpl VALUES ("GN36_39","002_36_39","GEN","36","39","39","Ba Baal Anan doomu Agbor faatoo, Adar falu buur, wuutu ko. Pawu moo doon péeyam, soxnaam di Metabeel ma Mataredd doomu Mesaab di yaayam. ");
INSERT INTO wolmbs_vpl VALUES ("GN36_40","002_36_40","GEN","36","40","40","Làng yi sosoo ci Esawu nag, làng gu ci nekk ak turam ak njaboot, ya mu ëmb, ak gox, ba mu dëkke, ñoo di ñii: ñi askanoo ci Timna ak Alwa ak Yetet ");
INSERT INTO wolmbs_vpl VALUES ("GN36_41","002_36_41","GEN","36","41","41","ak Olibama ak Ela ak Pinon ");
INSERT INTO wolmbs_vpl VALUES ("GN36_42","002_36_42","GEN","36","42","42","ak Kenas ak Teman ak Mibcar ");
INSERT INTO wolmbs_vpl VALUES ("GN36_43","002_36_43","GEN","36","43","43","ak Magdiyel ak Iram, ku ci nekk ak làngam. Ñooñoo doon kilifay Edom, ma ñu naa Esawu, moom ma giir Edomeen ñi, làng gu ci nekk ak gox, ba nga dëkke te moom ko. ");
INSERT INTO wolmbs_vpl VALUES ("GN37_1","002_37_1","GEN","37","1","1","Yanqóoba ma nga dëkkoon réewu Kanaan, fa baayam daloon. ");
INSERT INTO wolmbs_vpl VALUES ("GN37_2","002_37_2","GEN","37","2","2","Askanu Yanqóoba mooy lii. Yuusufa tollu na ci waxambaane, am fukki at ak juróom ñaar, di sàmmle jur gi doomi baayam, yi nga xam ne soxnay baayam Bilaa ak Silpa ñoo leen jur. Yuusufa nag di leen boole ak seen baay. ");
INSERT INTO wolmbs_vpl VALUES ("GN37_3","002_37_3","GEN","37","3","3","Booba Yanqóoba, Yuusufa la gëna bëgg ci ay doomam, ndax li mu màggat door koo am. Mu ràbblul ko mbubb mu yànj. ");
INSERT INTO wolmbs_vpl VALUES ("GN37_4","002_37_4","GEN","37","4","4","Mag ya nag gis ne Yuusufa la seen baay gëna bëgg ci ay doomam. Loolu tax ñu bañ ko, ba manuñoo séq ak moom kàddu gu rafet. ");
INSERT INTO wolmbs_vpl VALUES ("GN37_5","002_37_5","GEN","37","5","5","Mu am bés Yuusufa gént, nettali ko ay magam, ba tax ñu gënati koo bañ. ");
INSERT INTO wolmbs_vpl VALUES ("GN37_6","002_37_6","GEN","37","6","6","Da ne leen: «Dégluleen li ma gént. ");
INSERT INTO wolmbs_vpl VALUES ("GN37_7","002_37_7","GEN","37","7","7","Danoo nekk ca tool ya, di góob. Ba nu takkee, sama takk jekki-jekki ne sàtt, taxaw, seen takk wër sama takk, di ko sujjóotal.» ");
INSERT INTO wolmbs_vpl VALUES ("GN37_8","002_37_8","GEN","37","8","8","Mag ya ne ko: «Dangaa nara falu ci sunu kaw? Danga noo nara jiite?» Ñu gënati koo bañ nag ndax géntam ya ak la mu leen ca wax. ");
INSERT INTO wolmbs_vpl VALUES ("GN37_9","002_37_9","GEN","37","9","9","Gannaaw gi, geneen gént dikkal ko, mu nettali ko ay magam ne leen: «Dégluleen, géntaat naa. Gis naa jant bi ak weer wi ak fukki biddiiw ak benn di ma sujjóotal.» ");
INSERT INTO wolmbs_vpl VALUES ("GN37_10","002_37_10","GEN","37","10","10","Ba mu ko nettalee ay magam, ba nettali ko baayam, baayam da koo soow ne ko: «Yaw, li nga gént, lu mu doon? Xanaa du maak sa yaay ak say mag noo lay sujjóotal?» ");
INSERT INTO wolmbs_vpl VALUES ("GN37_11","002_37_11","GEN","37","11","11","Mag ya nag iñaane ko. Teewul baayam moom bàyyi xel ci mbir moomu. ");
INSERT INTO wolmbs_vpl VALUES ("GN37_12","002_37_12","GEN","37","12","12","Mu am bés ay magam dem dëkk ba ñuy wax Sikem, sàmmi seen juru baay. ");
INSERT INTO wolmbs_vpl VALUES ("GN37_13","002_37_13","GEN","37","13","13","Israayil ne Yuusufa: «Xam nga ne say mag sàmmi nañu Sikem. Kaay, ma yónni la ci ñoom.» Yuusufa ne ko: «Waaw.» ");
INSERT INTO wolmbs_vpl VALUES ("GN37_14","002_37_14","GEN","37","14","14","Yanqóoba ne ko: «Demal seeti say mag, ba xam ndax ñu ngi ci jàmm, ñoom ak jur ga, te nga ñëw, wax ma.» Mu yebal ko, mu jóge xuru Ebron, jubal Sikem. ");
INSERT INTO wolmbs_vpl VALUES ("GN37_15","002_37_15","GEN","37","15","15","Naka la jenn waay dajeek moom foofa, fekk muy wëreelu ca àll ba. Waa ja ne ko: «Looy seet?» ");
INSERT INTO wolmbs_vpl VALUES ("GN37_16","002_37_16","GEN","37","16","16","Yuusufa ne ko: «Samay mag laay seet. Xamoo fu ñu tollu, di sàmm?» ");
INSERT INTO wolmbs_vpl VALUES ("GN37_17","002_37_17","GEN","37","17","17","Waa ja ne ko: «Jóge nañu fii de, ndax dégg naa ñu naan: “Nanu dem Dotan.”» Yuusufa toppi magam ya ba Dotan, fekk leen fa. ");
INSERT INTO wolmbs_vpl VALUES ("GN37_18","002_37_18","GEN","37","18","18","Naka la ko mag ya séen fu sore, daldi mànkoo bala moo agsi, ci pexem rey ko. ");
INSERT INTO wolmbs_vpl VALUES ("GN37_19","002_37_19","GEN","37","19","19","Ña nga naan: «Boroom gént gaa ngee di ñëw! ");
INSERT INTO wolmbs_vpl VALUES ("GN37_20","002_37_20","GEN","37","20","20","Nanu ko rey gaaw, sànni ko ca kàmb yee, su ko defee danu naan, rabu àll a ko fàdd. Nu seet ba xam fu muy mujj aki géntam?» ");
INSERT INTO wolmbs_vpl VALUES ("GN37_21","002_37_21","GEN","37","21","21","Ruben nag dégg ca, di ko fexee xettali. Mu ne leen: «Bunu ko rey.» ");
INSERT INTO wolmbs_vpl VALUES ("GN37_22","002_37_22","GEN","37","22","22","Ruben teg ca ne leen: «Buleen tuur deret. Sànnileen ko ca kàmb gee ca àll ba, waaye bu ko loxo dal.» Booba ma ngay wut nu mu xettalee Yuusufa ci ñoom, ba delloo ko baayam. ");
INSERT INTO wolmbs_vpl VALUES ("GN37_23","002_37_23","GEN","37","23","23","Ba Yuusufa agsee ca magam ya, dañoo futti mbubbam, mooy mbubb mu yànj, ma mu soloon. ");
INSERT INTO wolmbs_vpl VALUES ("GN37_24","002_37_24","GEN","37","24","24","Ñu jàpp ko, tàbbal ca biir kàmb ga, fekk mu déy, ba wow koŋŋ. ");
INSERT INTO wolmbs_vpl VALUES ("GN37_25","002_37_25","GEN","37","25","25","Loolu wees ñu toog, di lekk. Nes tuut ñu siggi, séen am njëggum giléem, muy ay julay Ismayleen, yu sëf cuuraayu ndàbb ak diwu yaram ak cuuraayu xas, jële ko réewu Galàdd, jëme Misra. ");
INSERT INTO wolmbs_vpl VALUES ("GN37_26","002_37_26","GEN","37","26","26","Yuda ne doomi baayam ya: «Bu nu reyee sunu rakk jii, nëbb deret ji, lu nu ciy jële? ");
INSERT INTO wolmbs_vpl VALUES ("GN37_27","002_37_27","GEN","37","27","27","Tee nu koo jaay Ismayleen ñi, te bañ koo sàkkal pexe nun ci sunu bopp? Ndax kat sunu rakk a, di sunu deret.» Doomi baay ya déggal ko. ");
INSERT INTO wolmbs_vpl VALUES ("GN37_28","002_37_28","GEN","37","28","28","Julay Majan ya nag jaare fa, magi Yuusufa yóotu ko, génne ko kàmb ga, jaay ko Ismayleen ña ci ñaar fukki dogi xaalis. Ñu yóbbu Yuusufa Misra. ");
INSERT INTO wolmbs_vpl VALUES ("GN37_29","002_37_29","GEN","37","29","29","Ba mu ko defee Ruben dellu ca kàmb ga, gis ne Yuusufa nekkatul ca biir, mu mititlu ko, ba xotti ay yéreem. ");
INSERT INTO wolmbs_vpl VALUES ("GN37_30","002_37_30","GEN","37","30","30","Ba loolu amee mu jóge ca, dem ca ay rakkam ne leen: «Xale ba nekkatu fa de! Te man xawma nu may def léegi.» ");
INSERT INTO wolmbs_vpl VALUES ("GN37_31","002_37_31","GEN","37","31","31","Ñu jël nag mbubbu Yuusufa, rendi ab sikket, taqal mbubb ma ca deret ja. ");
INSERT INTO wolmbs_vpl VALUES ("GN37_32","002_37_32","GEN","37","32","32","Gannaaw loolu ñu yóti seen baay mbubb ma, ne ko: «Lii lanu gis de, xoolal bu baax ndax du sa mbubbu doom?» ");
INSERT INTO wolmbs_vpl VALUES ("GN37_33","002_37_33","GEN","37","33","33","Yanqóoba xàmmee ko, daldi ne: «Sama mbubbu doom a moos! Éey waay, rabu àll kay moo daggate Yuusufa, yàpp ko!» ");
INSERT INTO wolmbs_vpl VALUES ("GN37_34","002_37_34","GEN","37","34","34","Ci kaw loolu Yanqóoba mititlu ko, ba xotti ay yéreem, taraxlaayoo ab saaku, di jooy doomam ay fan. ");
INSERT INTO wolmbs_vpl VALUES ("GN37_35","002_37_35","GEN","37","35","35","Doomam yépp, góor ak jigéen ñëw, di ko dëfal, te noppiwul, xanaa naan: «Damay jooy, ba dem njaniiw, fekki sama doom.» Baayam di ko jooy, ");
INSERT INTO wolmbs_vpl VALUES ("GN37_36","002_37_36","GEN","37","36","36","fekk waa Majan yóbbu nañu ko Misra, jaay ko Potifaar, jawriñu Firawna mi jiite ay dagam. ");
INSERT INTO wolmbs_vpl VALUES ("GN38_1","002_38_1","GEN","38","1","1","Ca jamono yooyu Yuda dafa teqalikoo ak ay doomi baayam, dal ca waa ju dëkk Adulam te tudd Ira. ");
INSERT INTO wolmbs_vpl VALUES ("GN38_2","002_38_2","GEN","38","2","2","Foofa nag Yuda gis fa sennas ndaw, su doon doomu ab Kanaaneen bu tudd Suwa, mu jël ko soxna. ");
INSERT INTO wolmbs_vpl VALUES ("GN38_3","002_38_3","GEN","38","3","3","Suwa ëmb, am doom ju góor, tudde ko Er. ");
INSERT INTO wolmbs_vpl VALUES ("GN38_4","002_38_4","GEN","38","4","4","Mu dellu ëmb, am doom ju góor, tudde ko Onan. ");
INSERT INTO wolmbs_vpl VALUES ("GN38_5","002_38_5","GEN","38","5","5","Mu amati doom ju góor, tudde ko Sela. Ba Sela di juddu, fekk na Yuda nekk ci béreb bu ñu naan Kesib. ");
INSERT INTO wolmbs_vpl VALUES ("GN38_6","002_38_6","GEN","38","6","6","Gannaaw gi, Yuda jëlal taawam Er jabar ju tudd Tamar. ");
INSERT INTO wolmbs_vpl VALUES ("GN38_7","002_38_7","GEN","38","7","7","Er, taawub Yuda boobee, doonoon ku Aji Sax ji seede coxoram; Aji Sax ji nag rey ko. ");
INSERT INTO wolmbs_vpl VALUES ("GN38_8","002_38_8","GEN","38","8","8","Yuda ne Onan: «Demal ci sa jabaru mag, donn ko, ndax nga giiral sa mag aw askan.» ");
INSERT INTO wolmbs_vpl VALUES ("GN38_9","002_38_9","GEN","38","9","9","Teewul Onan xam ne du doon askan wu muy moom, ba tax saa yuy séy ak jabaru magam, bay wara àgg rekk, tuur maniyu wi ci suuf, ngir baña giiral magam. ");
INSERT INTO wolmbs_vpl VALUES ("GN38_10","002_38_10","GEN","38","10","10","Aji Sax ji ñaawlu li muy def, ba tax mu faat ko, moom itam. ");
INSERT INTO wolmbs_vpl VALUES ("GN38_11","002_38_11","GEN","38","11","11","Yuda daldi wax Tamar jabaru doomam ne ko: «Demal sa kër baay, ténjeji fa, ba sama doom Sela màgg.» Booba Yuda dafa ragal Sela faatu moom itam ni ay magam. Tamar nag dem, toog kër baayam. ");
INSERT INTO wolmbs_vpl VALUES ("GN38_12","002_38_12","GEN","38","12","12","Ba ñu demee ba mu yàgg, doomu Suwa, soxnas Yuda faatu. Ba dëj ba wéyee, Yuda dem fekki watkati xaram ca Timna. Ira, xaritam bi dëkk Adulam a nga ànd ak moom. ");
INSERT INTO wolmbs_vpl VALUES ("GN38_13","002_38_13","GEN","38","13","13","Ñu yégal Tamar ne ko: «Sa goroo ngii jëm Timna, di wati ay xaram.» ");
INSERT INTO wolmbs_vpl VALUES ("GN38_14","002_38_14","GEN","38","14","14","Ba loolu amee mu summi yérey jëtun ya, muuru, sàngu, toog ca selebe yoon wa jëm Enayim ca yoonu Timna, ndax booba gis na ne Sela màgg na te mayuñu ko ko, muy jabaram. ");
INSERT INTO wolmbs_vpl VALUES ("GN38_15","002_38_15","GEN","38","15","15","Yuda gis ko, yaakaar ne gànc la, ndax li mu muuru. ");
INSERT INTO wolmbs_vpl VALUES ("GN38_16","002_38_16","GEN","38","16","16","Mu jàdd, ñëw ba ca moom, ne ko: «Ndax man naa la tëdde?» Fekk na xamul woon ne goroom la. Mu ne ko: «Loo may fey, ngir ànd ak man?» ");
INSERT INTO wolmbs_vpl VALUES ("GN38_17","002_38_17","GEN","38","17","17","Mu ne ko: «Dinaa jël bëy wu ndaw ca sama gétt, yónnee la.» Mu ne ko: «Jox ma lenn looy tayle, ba kera ngay yónnee.» ");
INSERT INTO wolmbs_vpl VALUES ("GN38_18","002_38_18","GEN","38","18","18","Mu ne ko: «Lu ma lay tayle?» Ndaw si ne ko: «Xanaa sa jaarob màndargaal, ak buum gi mu àndal ak yet wi ci sa loxo.» Mu jox ko nag, ba noppi ànd ak moom. Fa la doxe ëmb. ");
INSERT INTO wolmbs_vpl VALUES ("GN38_19","002_38_19","GEN","38","19","19","Ndaw sa dem yoonam, dindi muuraay ba, solaat yérey jëtun ya. ");
INSERT INTO wolmbs_vpl VALUES ("GN38_20","002_38_20","GEN","38","20","20","Ba loolu wéyee Yuda yebal xaritam, ba dëkk Adulam, mu yóti ndaw sa bëy wu ndaw wa, ba mana jotaat la mu tayle woon ca ndaw sa. Xarit ba nag gisu ko. ");
INSERT INTO wolmbs_vpl VALUES ("GN38_21","002_38_21","GEN","38","21","21","Mu laaj waa gox ba, ne leen: «Ana gànc biy toog Enayim ci yoon wi?» Ñu ne ko: «Fii de ab gànc nekku fi.» ");
INSERT INTO wolmbs_vpl VALUES ("GN38_22","002_38_22","GEN","38","22","22","Mu dellu ca Yuda ne ko: «Gisuma ko de, te it waa gox ba nee nañu, foofa gànc nekku fa.» ");
INSERT INTO wolmbs_vpl VALUES ("GN38_23","002_38_23","GEN","38","23","23","Yuda ne ko: «Nanu ko ko wacce, mu jël, lu ko moy ñu ree nu, gannaaw maa ngi nii yónnee bëy wu ndaw wii, te yaw gisoo ko kay.» ");
INSERT INTO wolmbs_vpl VALUES ("GN38_24","002_38_24","GEN","38","24","24","Ba ñu ca tegee lu tollook ñetti weer, ñu xamal Yuda ne ko, Tamar goroom ba, da doon jaay boppam, ba jaare ca ëmb. Yuda ne: «Nañu ko yóbbu, lakk ko, ba mu dee.» ");
INSERT INTO wolmbs_vpl VALUES ("GN38_25","002_38_25","GEN","38","25","25","Naka lañu koy yóbbu, mu yóbbante goroom ba ay kàddu. Da koo wax ne ko: «Ki moom lii moo ma ëmbal.» Mu teg ca ne ko: «Xoolal bu baax te wax ma ku moom jaarob màndargaal bi ànd ak buum gi, ak yet wi.» ");
INSERT INTO wolmbs_vpl VALUES ("GN38_26","002_38_26","GEN","38","26","26","Yuda xàmmee yëf ya nag, ne: «Moo ma gëna nekk ci dëgg de, gannaaw mayuma ko sama doom Sela.» Gannaaw ba loolu wéyee, àndatul ak moom. ");
INSERT INTO wolmbs_vpl VALUES ("GN38_27","002_38_27","GEN","38","27","27","Tamar dem, ba wara wasin, ndekete ay seex la ëmb. ");
INSERT INTO wolmbs_vpl VALUES ("GN38_28","002_38_28","GEN","38","28","28","Ba muy mucc, kenn ca doom ya daa tàllal loxo ba, rewlikat ba jàpp ca, takk ca wëñ gu xonq curr. Mu ne: «Kii moo njëkka génn.» ");
INSERT INTO wolmbs_vpl VALUES ("GN38_29","002_38_29","GEN","38","29","29","Naka la delloo loxoom, seexam juddu, mu ne ko: «Yaw foo bëtte, ba génn?» Ñu daldi ko tudde Peres (muy firi Bëtt). ");
INSERT INTO wolmbs_vpl VALUES ("GN38_30","002_38_30","GEN","38","30","30","Nes tuut seex, bi wëñ gi takke ci loxo li, door caa topp, ñu tudde ko Sera (muy firi Jant fenk na). ");
INSERT INTO wolmbs_vpl VALUES ("GN39_1","002_39_1","GEN","39","1","1","Ba ñu yóbboo Yuusufa Misra, Potifaar, jawriñu Firawna, ma jiite ay dagam, da koo jënd ca Ismayleen ña ko fa indi. ");
INSERT INTO wolmbs_vpl VALUES ("GN39_2","002_39_2","GEN","39","2","2","Ci kaw loolu Aji Sax ji ànd ak Yuusufa, may ko ndam, mu dëkk ca kër sangub waa Misraam ba. ");
INSERT INTO wolmbs_vpl VALUES ("GN39_3","002_39_3","GEN","39","3","3","Sang ba nag gis ne Aji Sax jaa ngi ànd ak Yuusufa, di ko may ndam ci lépp lu mu sabablu. ");
INSERT INTO wolmbs_vpl VALUES ("GN39_4","002_39_4","GEN","39","4","4","Sang ba am cofeel ci Yuusufa, def ko fara biir këram, dénk ko saytub kër ga, ba teg ciy loxoom lépp lu mu moom. ");
INSERT INTO wolmbs_vpl VALUES ("GN39_5","002_39_5","GEN","39","5","5","Boobee waayi Misra ja dénkee Yuusufa këram ak lépp lu mu moom, mu di ko saytu, ca la Aji Sax ji dale barkeel këram, barkeelaale mboolem lu mu moom, kër ak tool. ");
INSERT INTO wolmbs_vpl VALUES ("GN39_6","002_39_6","GEN","39","6","6","Mu daldi bàyyi lépp ci loxol Yuusufa, te li mu fa nekk tax ba toppatootul dara ciy mbiram, lu moy li muy lekk rekk. Booba Yuusufa ku jekkoon bind la te góorayiw. ");
INSERT INTO wolmbs_vpl VALUES ("GN39_7","002_39_7","GEN","39","7","7","Mu am bés nag soxnas sangub Yuusufa ba xemmem Yuusufa, daldi ne ko: «Kaay tëdd ak man.» ");
INSERT INTO wolmbs_vpl VALUES ("GN39_8","002_39_8","GEN","39","8","8","Teewul Yuusufa bañ, ne soxnas sang ba: «Déglul, sama sang da maa jébbal lépp, ba toppatootul dara ci kër gi. ");
INSERT INTO wolmbs_vpl VALUES ("GN39_9","002_39_9","GEN","39","9","9","Ëpplewu ma sañ-sañ ci biir kër gi, te aayewu ma lenn xanaa yaw, ndax soxnaam nga. Kon léegi nu may mana defe ñaawtéef wu réy wu ni tollu, di moy Yàlla?» ");
INSERT INTO wolmbs_vpl VALUES ("GN39_10","002_39_10","GEN","39","10","10","Ba loolu amee bés bu Yàlla sàkk mu di ko wax Yuusufa, te dégluwu ko, wéetul ak moom sax, bay tëdd ak moom. ");
INSERT INTO wolmbs_vpl VALUES ("GN39_11","002_39_11","GEN","39","11","11","Mu am bés Yuusufa dugg ca kër ga, di def liggéeyam, te kenn ci surga yu góor ya nekku fa. ");
INSERT INTO wolmbs_vpl VALUES ("GN39_12","002_39_12","GEN","39","12","12","Ndaw si jàpp ci mbubb mi, ne ko: «Kaay tëdd ak man.» Yuusufa nag wacc mbubb ma cay loxoom, daw génn kër ga. ");
INSERT INTO wolmbs_vpl VALUES ("GN39_13","002_39_13","GEN","39","13","13","Ndaw si gis mbubb, mi mu ko wacce, ba daw génn, ");
INSERT INTO wolmbs_vpl VALUES ("GN39_14","002_39_14","GEN","39","14","14","mu woo surgay kër ga, ne leen: «Xoolleen, Ebrë sii sama jëkkër indi ci kër gi, mu di nu yab. Dafa ñëw, bëgg maa tëdde, ma yuuxu ca kaw. ");
INSERT INTO wolmbs_vpl VALUES ("GN39_15","002_39_15","GEN","39","15","15","Naka laa yuuxu ca kaw, mu wacce ma mbubbam, daw génn.» ");
INSERT INTO wolmbs_vpl VALUES ("GN39_16","002_39_16","GEN","39","16","16","Ba mu ko defee ndaw si denc mbubb ma, ba sangub Yuusufa ba ñibbisi, ");
INSERT INTO wolmbs_vpl VALUES ("GN39_17","002_39_17","GEN","39","17","17","mu nettalee ko ko noonu ne ko: «Jaamu ebrë, bi nga indi ci kër gi de, da maa fekksi, di ma sàkku. ");
INSERT INTO wolmbs_vpl VALUES ("GN39_18","002_39_18","GEN","39","18","18","Naka laa yuuxu ca kaw, mu daw génn, wacce ma mbubbam.» ");
INSERT INTO wolmbs_vpl VALUES ("GN39_19","002_39_19","GEN","39","19","19","Sang bi dégg li ko soxnaam wax ne moom la ko jaamam def, mu mer lool, ");
INSERT INTO wolmbs_vpl VALUES ("GN39_20","002_39_20","GEN","39","20","20","ba jàpp Yuusufa, tëj ko kaso ba ñuy denc ñi buur jàpp. Yuusufa nekk foofa ca kaso ba. ");
INSERT INTO wolmbs_vpl VALUES ("GN39_21","002_39_21","GEN","39","21","21","Teewul Aji Sax ji ànd ak Yuusufa, laaye ko biir, daldi xiir wattukatu kaso ba ca moom, mu yéwéne ko. ");
INSERT INTO wolmbs_vpl VALUES ("GN39_22","002_39_22","GEN","39","22","22","Ci kaw loolu mu may Yuusufa, mu yilif ñi ñu tëj ñépp, te mboolem lu ñu fay def, mu di ko jiite. ");
INSERT INTO wolmbs_vpl VALUES ("GN39_23","002_39_23","GEN","39","23","23","Wattukat ba seetatuloon dara lu Yuusufa jiite, ndax Aji Sax jee ànd ak moom, te lu mu sabablu, Aji Sax ji may ko ca ndam. ");
INSERT INTO wolmbs_vpl VALUES ("GN40_1","002_40_1","GEN","40","1","1","Ba loolu wéyee kiy toppatoo naani buuru Misra ak kiy lakki mburoom dañoo tooñ buuru Misra, seen sang. ");
INSERT INTO wolmbs_vpl VALUES ("GN40_2","002_40_2","GEN","40","2","2","Firawna nag mere lool ñaari jawriñ yooya, kenn ka di kilifay ñay toppatoo naani buur, ka ca des di kilifay ñiy lakk mburu ya, ");
INSERT INTO wolmbs_vpl VALUES ("GN40_3","002_40_3","GEN","40","3","3","ba tax mu tëj leen ca kër kilifag wattukat ba, ca kaso ba ñu tëj Yuusufa. ");
INSERT INTO wolmbs_vpl VALUES ("GN40_4","002_40_4","GEN","40","4","4","Kilifag wattukat ya teg leen ca loxol Yuusufa, mu di leen toppatoo. Ba ñu nekkee ab diir ca kaso ba, ");
INSERT INTO wolmbs_vpl VALUES ("GN40_5","002_40_5","GEN","40","5","5","jawriñi buuru Misra, ya ñu tëj, muy ñaar ña féetewoo naani buur ak mburoom, dañoo géntandoo ci genn guddi, gént gu ci nekk ak li muy firi. ");
INSERT INTO wolmbs_vpl VALUES ("GN40_6","002_40_6","GEN","40","6","6","Yuusufa xëy, fekk leen ñu jaaxle. ");
INSERT INTO wolmbs_vpl VALUES ("GN40_7","002_40_7","GEN","40","7","7","Mu laaj jawriñi Firawna, yooyee ñu tëjandoo woon ak moom ca kër sangam, ne leen: «Lu leen tax ne yogg tey?» ");
INSERT INTO wolmbs_vpl VALUES ("GN40_8","002_40_8","GEN","40","8","8","Ñu ne ko: «Ay gént daal a nu dikkal, te amunu ku nu koy firil.» Yuusufa ne leen: «Xanaa du Yàllaa moom piri? Nettalileen ma seeni gént rekk kay.» ");
INSERT INTO wolmbs_vpl VALUES ("GN40_9","002_40_9","GEN","40","9","9","Jawriñ bay toppatoo naanu buur daldi nettali géntam Yuusufa, ne ko: «Ci gént gi, garabu reseñ laa gis ci sama kanam, ");
INSERT INTO wolmbs_vpl VALUES ("GN40_10","002_40_10","GEN","40","10","10","mu def ñetti car. Naka la focci rekk, gaawa tóor, cëgg ya meññ reseñ ju ñor. ");
INSERT INTO wolmbs_vpl VALUES ("GN40_11","002_40_11","GEN","40","11","11","Maa ngi téye nii kaasu Firawna ci sama loxo, jël reseñ ji nag, nal ko ci kaasu Firawna, ba noppi teg kaas bi ci loxol Firawna.» ");
INSERT INTO wolmbs_vpl VALUES ("GN40_12","002_40_12","GEN","40","12","12","Yuusufa ne ko: «Piri mi mooy lii: Ñetti car yi, ñetti fan la. ");
INSERT INTO wolmbs_vpl VALUES ("GN40_13","002_40_13","GEN","40","13","13","Fii ak ñetti fan Firawna dina la siggil, delloo la sa liggéey, ngay teg kaasu Firawna ci loxoom, ni nga ko daa defe naka jekk, ba nga yoree naanam. ");
INSERT INTO wolmbs_vpl VALUES ("GN40_14","002_40_14","GEN","40","14","14","Waaye ngalla boo delloo ca sa teraanga, nanga ma geestu te dimbali ma, waxal ma Firawna lu jëm ci man, ba man maa génne fii. ");
INSERT INTO wolmbs_vpl VALUES ("GN40_15","002_40_15","GEN","40","15","15","Ndax man kat dañu maa sàcce ca réewum Ebrë ya, te fii itam, defuma fi lu tax, ñu war maa tëj.» ");
INSERT INTO wolmbs_vpl VALUES ("GN40_16","002_40_16","GEN","40","16","16","Kilifag ñiy lakk mburu ya nag gis ne piri mi neex na, mu ne Yuusufa: «Man it sama gént gi, xam nga lu ma ci gis? Ñetti pañey mburu mu weex laa yenu, ");
INSERT INTO wolmbs_vpl VALUES ("GN40_17","002_40_17","GEN","40","17","17","ba féete kaw a nga yeb mboolem xeeti mburu yu ñuy lakkal Firawna, picc yaa nga koy for ca pañe, ba ma yenu.» ");
INSERT INTO wolmbs_vpl VALUES ("GN40_18","002_40_18","GEN","40","18","18","Yuusufa ne ko: «Piri mi mooy lii: Ñetti pañe yi, ñetti fan la. ");
INSERT INTO wolmbs_vpl VALUES ("GN40_19","002_40_19","GEN","40","19","19","Fii ak ñetti fan Firawna dina la siggil, ba noppi wékk la ci bant, picc yi ñëw, di for sa suux.» ");
INSERT INTO wolmbs_vpl VALUES ("GN40_20","002_40_20","GEN","40","20","20","Ñu teg ca ñetti fan, Firawna di baaxantal bésu juddoom. Mu dajale jawriñam yépp, di leen berndeel, daldi cay seppee kilifa gay toppatoo ay naanam, ak kilifag ñiy lakk mburu ya, siggil leen. ");
INSERT INTO wolmbs_vpl VALUES ("GN40_21","002_40_21","GEN","40","21","21","Mu delloo nag kilifa gay toppatoo ay naanam ca liggéeyam, mu teg kaas ba ca loxol Firawna. ");
INSERT INTO wolmbs_vpl VALUES ("GN40_22","002_40_22","GEN","40","22","22","Kilifag ñiy lakk mburu ya moom, da koo wékk ci bant, na leen ko Yuusufa firile woon. ");
INSERT INTO wolmbs_vpl VALUES ("GN40_23","002_40_23","GEN","40","23","23","Waaye kilifa, ga yore naani Firawna, xalaatul sax Yuusufa, da koo fàtte. ");
INSERT INTO wolmbs_vpl VALUES ("GN41_1","002_41_1","GEN","41","1","1","Ñaari ati lëmm wees na gannaaw loolu, gént dikkal Firawna, mu jeneer taxaw ca wetu dexu Niil. ");
INSERT INTO wolmbs_vpl VALUES ("GN41_2","002_41_2","GEN","41","2","2","Mu gis juróom ñaari nag yu rafet te suur génne ca dex ga, di for baraxi tàkk ga. ");
INSERT INTO wolmbs_vpl VALUES ("GN41_3","002_41_3","GEN","41","3","3","Mu dellu gis juróom ñaari nag yu ñaaw te yooy topp ca ñoom, génne ca dex ga, làng ak ñoom ca tàkk ga. ");
INSERT INTO wolmbs_vpl VALUES ("GN41_4","002_41_4","GEN","41","4","4","Nag yu ñaaw ya te yooy daldi lekk juróom ñaari nag yu rafet ya te suur. Firawna yewwu, ");
INSERT INTO wolmbs_vpl VALUES ("GN41_5","002_41_5","GEN","41","5","5","ba noppi nelawaat, dellu gént, gis juróom ñaari gub yu nangu te baax sax ci benn gattax. ");
INSERT INTO wolmbs_vpl VALUES ("GN41_6","002_41_6","GEN","41","6","6","Gannaaw ga, juróom ñaari gub yu gooy yu ngelaw li lakk sax, tegu ca ya jiitu. ");
INSERT INTO wolmbs_vpl VALUES ("GN41_7","002_41_7","GEN","41","7","7","Ca la gub yu gooy ya wann juróom ñaari gub yu nangu ya te baax. Gannaaw loolu Firawna yewwu, xam ne gént la woon. ");
INSERT INTO wolmbs_vpl VALUES ("GN41_8","002_41_8","GEN","41","8","8","Ba bët setee, Firawna jaaxle lool, ba woolu jabarkat yaak boroom xam-xami Misra yépp, nettali leen la mu gént, te kenn manu koo firil Firawna. ");
INSERT INTO wolmbs_vpl VALUES ("GN41_9","002_41_9","GEN","41","9","9","Ba loolu amee kilifa gay toppatoo naani Firawna ne ko: «Man de tooñ naa te dinaa la ko wax tey. ");
INSERT INTO wolmbs_vpl VALUES ("GN41_10","002_41_10","GEN","41","10","10","Sang bi, ba nga nu meree, yaw Firawna, ba tëj ma kaso ca kër njiitu dag ya, man ak kilifag ñiy lakk mburu ya, ");
INSERT INTO wolmbs_vpl VALUES ("GN41_11","002_41_11","GEN","41","11","11","genn guddi danoo géntandoo, man ak moom, gént gu ci nekk ak la muy firi. ");
INSERT INTO wolmbs_vpl VALUES ("GN41_12","002_41_12","GEN","41","12","12","Fekk amoon na waxambaanew ebrë wu fa nekkoon ak nun, te doonoon jaamub njiital dag ya. Nu nettali ko sunuy gént, muy firil nu ko, wax nu, ku nekk la sa gént di tekki. ");
INSERT INTO wolmbs_vpl VALUES ("GN41_13","002_41_13","GEN","41","13","13","Te na mu nu ko firile woon, na la ame: delloo nañu ma sama liggéey, ka ca des ñu wékk ko ci bant.» ");
INSERT INTO wolmbs_vpl VALUES ("GN41_14","002_41_14","GEN","41","14","14","Ba Firawna déggee loolu, dafa woolu Yuusufa. Ñu gaaw tijji ko, mu watu, solu, doora wuyuji Firawna. ");
INSERT INTO wolmbs_vpl VALUES ("GN41_15","002_41_15","GEN","41","15","15","Firawna ne Yuusufa: «Damaa gént, te kenn manu koo firi, te ma dégg ñuy wax ci yaw naan, gént goo dégg rekk, xam ko, ba man koo firi.» ");
INSERT INTO wolmbs_vpl VALUES ("GN41_16","002_41_16","GEN","41","16","16","Yuusufa ne ko: «Du ci man de, waaye Yàlla mooy baaxe Firawna pirim jàmm.» ");
INSERT INTO wolmbs_vpl VALUES ("GN41_17","002_41_17","GEN","41","17","17","Firawna ne Yuusufa: «Damaa gént, taxaw ci tàkkal dexu Niil, ");
INSERT INTO wolmbs_vpl VALUES ("GN41_18","002_41_18","GEN","41","18","18","ma gis juróom ñaari nag yu suur te rafet génne ca dex ga, di for baraxu tàkk ga. ");
INSERT INTO wolmbs_vpl VALUES ("GN41_19","002_41_19","GEN","41","19","19","Ma dellu gis yeneen juróom ñaari nag yu ràgg, ñaaw te yooy génne ca dex ga, topp ci ñoom, di yu ñaaw, ba masumaa gis lu ni mel ci Misra. ");
INSERT INTO wolmbs_vpl VALUES ("GN41_20","002_41_20","GEN","41","20","20","Noonu yu yooy ya te ñaaw daldi lekk juróom ñaari nag, ya njëkkoona feeñ te suur. ");
INSERT INTO wolmbs_vpl VALUES ("GN41_21","002_41_21","GEN","41","21","21","Waaye bi ñu leen lekkee ba noppi, itam dafa mel ni lekkuñu leen, ndax terewuleena mel na woon. Booba laa yewwu, ");
INSERT INTO wolmbs_vpl VALUES ("GN41_22","002_41_22","GEN","41","22","22","ba noppi dellu gént, gis juróom ñaari gub yu fees te baax sax ci benn gattax. ");
INSERT INTO wolmbs_vpl VALUES ("GN41_23","002_41_23","GEN","41","23","23","Gannaaw ga, ma gis juróom ñaari gub yu gooy yu ngelaw li lakk, sax tegu ca ya jiitu. ");
INSERT INTO wolmbs_vpl VALUES ("GN41_24","002_41_24","GEN","41","24","24","Gub yu gooy ya nag wann juróom ñaari gub yu baax ya. Nettali naa ko jabarkat yi, waaye kenn ci ñoom manu ma koo firil.» ");
INSERT INTO wolmbs_vpl VALUES ("GN41_25","002_41_25","GEN","41","25","25","Yuusufa ne Firawna: «Sa ñaari gént yi de, sang bi, ñoo bokk piri. Sang bi, Yàlla da laa xamal li muy def ëllëg. ");
INSERT INTO wolmbs_vpl VALUES ("GN41_26","002_41_26","GEN","41","26","26","Juróom ñaari nag yu baax yi, juróom ñaari at la. Te it juróom ñaari gub yu baax yi, juróom ñaari at la. Muy genn gént gi. ");
INSERT INTO wolmbs_vpl VALUES ("GN41_27","002_41_27","GEN","41","27","27","Te itam juróom ñaari nag yu yooy, yi ci topp te ñaaw, juróom ñaari at la. Naka noonu juróom ñaari gub yu gooy yi ngelaw li lakk, juróom ñaari ati xiif lay firi. ");
INSERT INTO wolmbs_vpl VALUES ("GN41_28","002_41_28","GEN","41","28","28","Mooy li ma la wax rekk, sang bu tedd bi: li Yàlla di defi ëllëg la la won. ");
INSERT INTO wolmbs_vpl VALUES ("GN41_29","002_41_29","GEN","41","29","29","Nu ngi dëgmal juróom ñaari ati naataange yu réy ci mboolem réewum Misra. ");
INSERT INTO wolmbs_vpl VALUES ("GN41_30","002_41_30","GEN","41","30","30","Te juróom ñaari ati xiif a ciy topp, ba ñu fàtte naataange gu réy ga amoon réewum Misra. Xiif ba cay topp dina yàq réew mi. ");
INSERT INTO wolmbs_vpl VALUES ("GN41_31","002_41_31","GEN","41","31","31","Xiif bi dina tax lenn luy nirook naataange dootul des ci réew mi, ndax dina metti lool. ");
INSERT INTO wolmbs_vpl VALUES ("GN41_32","002_41_32","GEN","41","32","32","Te nag, sang bi, gannaaw gént nga ko ñaari yoon, kon Yàlla dogal na mbir mi, te dina ko amal balaa yàgg.» ");
INSERT INTO wolmbs_vpl VALUES ("GN41_33","002_41_33","GEN","41","33","33","Yuusufa teg ca ne Firawna: «Kon léegi sang bi, wutal nit ku muus te rafet xel, jiital ko ci réewum Misra. ");
INSERT INTO wolmbs_vpl VALUES ("GN41_34","002_41_34","GEN","41","34","34","Te itam sang bi, dangay fal ay ndaw ci réew mi, ñuy sàkku juróomi natt yu ne benn ci mboolem lu ñu góobe réewum Misra diiru juróom ñaari ati naataange yiy ñëw. ");
INSERT INTO wolmbs_vpl VALUES ("GN41_35","002_41_35","GEN","41","35","35","Ñoom nañu dajale mboolem dundi at yu baax yi, te boole pepp mi ci sa ndigalu bopp, yaw Firawna, muy dund bu ñuy denc ci dëkk yi. ");
INSERT INTO wolmbs_vpl VALUES ("GN41_36","002_41_36","GEN","41","36","36","Dund boobooy doon sàqu réew mi diiru juróom ñaari ati xiif yiy dal ci réewum Misra; su ko defee waa réew mi duñu loru ci xiif bi.» ");
INSERT INTO wolmbs_vpl VALUES ("GN41_37","002_41_37","GEN","41","37","37","Pexe moomu nag doon lu Firawna aki jawriñam yépp njort ne baax na. ");
INSERT INTO wolmbs_vpl VALUES ("GN41_38","002_41_38","GEN","41","38","38","Firawna daldi ne jawriñ ya: «Ndax masees naa gis ku mel ni kii a waay, nit ku Yàlla sol xelum boppam?» ");
INSERT INTO wolmbs_vpl VALUES ("GN41_39","002_41_39","GEN","41","39","39","Firawna wax ak Yuusufa ne ko: «Ndegam Yàlla xamal na la lii lépp kay, leer na ne amul kenn ku muus te rafet xel ni yaw. ");
INSERT INTO wolmbs_vpl VALUES ("GN41_40","002_41_40","GEN","41","40","40","Kon dinaa la may, nga jiite kër buur, te waa réew mépp ci sa waaw lañuy wéy; jal bi ma toog doŋŋ laa lay sute.» ");
INSERT INTO wolmbs_vpl VALUES ("GN41_41","002_41_41","GEN","41","41","41","Gannaaw loolu Firawna neeti Yuusufa: «Bés niki tey, dénk naa la réewum Misra gépp.» ");
INSERT INTO wolmbs_vpl VALUES ("GN41_42","002_41_42","GEN","41","42","42","Ba loolu amee Firawna tekkee jaarob màndargaal ba ca loxoom, takkal ko Yuusufa, solal ko yérey tànnéef, takkal ko caqu wurus, ");
INSERT INTO wolmbs_vpl VALUES ("GN41_43","002_41_43","GEN","41","43","43","ba noppi waral ko watiiru ku sës rëkk ci moom Firawna, te fu mu ware ñu jiitu ko, di yéene naan: «Sujjóotleen!» Noonu la ko Firawna fale, mu yilif Misra gépp. ");
INSERT INTO wolmbs_vpl VALUES ("GN41_44","002_41_44","GEN","41","44","44","Ci kaw loolu Firawna ne Yuusufa: «Man maay Firawna, waaye gannaaw-si-tey mboolem waa réewum Misra, kenn du ci sañatee yékkati loxo mbaa muy séqi jéego, te àndoo ci.» ");
INSERT INTO wolmbs_vpl VALUES ("GN41_45","002_41_45","GEN","41","45","45","Firawna nag tudde Yuusufa Cafnat Paneya, may ko jabar Asnat doomu Potifera ma doon sarxalkat ca dëkk ba ñuy wax Oon. Yuusufa doxe ca tegoo kilifteefu Misra gépp. ");
INSERT INTO wolmbs_vpl VALUES ("GN41_46","002_41_46","GEN","41","46","46","Ba Yuusufay tàmbalee liggéeyal Firawna buuru Misra, mu ngi tollu ci fanweeri at. Yuusufa daldi bàyyikoo ca Firawna, wër réew ma mépp. ");
INSERT INTO wolmbs_vpl VALUES ("GN41_47","002_41_47","GEN","41","47","47","Diiru juróom ñaari ati naataange ya suuf sa nangu, ba meññeef ma tuuru. ");
INSERT INTO wolmbs_vpl VALUES ("GN41_48","002_41_48","GEN","41","48","48","Mu dajale mboolem dundub réewum Misra diiru juróom ñaari at yooyee, dëkk bu nekk mu denc fa dund, ba jóge ca tool ya ko wër. ");
INSERT INTO wolmbs_vpl VALUES ("GN41_49","002_41_49","GEN","41","49","49","Fa la Yuusufa jaare dajale pepp, mu ne gàññ, ni suufas géej, ba tàyyeeti koo waññ, ndax mujj na wees ab lim. ");
INSERT INTO wolmbs_vpl VALUES ("GN41_50","002_41_50","GEN","41","50","50","Laata ati xiif yay agsi, Yuusufa am na ñaari doom yu góor ak Asnat doomu Potifera, sarxalkat ba ca Oon. ");
INSERT INTO wolmbs_vpl VALUES ("GN41_51","002_41_51","GEN","41","51","51","Yuusufa tudde taaw ba Manase (muy firi Ki ma taxa fàtte), ndaxte da ne: «Li ma sonn ak li ma sore sama kër baay lépp, Yàlla fàtteloo na ma ko.» ");
INSERT INTO wolmbs_vpl VALUES ("GN41_52","002_41_52","GEN","41","52","52","Doomam ja ca topp mu tudde ko Efrayim (muy firi Giir), ndaxte da ne: «Yàllaa ma giiral ca réew ma ma sonne.» ");
INSERT INTO wolmbs_vpl VALUES ("GN41_53","002_41_53","GEN","41","53","53","Ci kaw loolu juróom ñaari ati naataange ya jeex ca réewum Misra, ");
INSERT INTO wolmbs_vpl VALUES ("GN41_54","002_41_54","GEN","41","54","54","juróom ñaari ati xiif ya tàmbali, na ko Yuusufa waxe woon. Réew yépp nag nekk ci xiif, waaye amul fu ñàkk dund ca Misra. ");
INSERT INTO wolmbs_vpl VALUES ("GN41_55","002_41_55","GEN","41","55","55","Ba waa Misra xiifee, dañoo dem jooytuji dund ca Firawna. Mu wax ak ñépp ne leen: «Demleen ca Yuusufa; lu mu leen wax, defleen ko.» ");
INSERT INTO wolmbs_vpl VALUES ("GN41_56","002_41_56","GEN","41","56","56","Ba ñu demee, ba mititu xiif bi dajal réew mépp, Yuusufa dafa ubbi denc yépp, di jaay pepp mi waa Misra, ");
INSERT INTO wolmbs_vpl VALUES ("GN41_57","002_41_57","GEN","41","57","57","ba nit ñiy jóge fu nekk ci àddina, di wutsi njël ci Yuusufa ndax xiif bu mettee fépp ca àddina. ");
INSERT INTO wolmbs_vpl VALUES ("GN42_1","002_42_1","GEN","42","1","1","Ba Yanqóoba yégee ne pepp am na Misra, daa wax ay doomam yu góor, ne leen: «Lu ngeen di toog, di xoolante rekk?» ");
INSERT INTO wolmbs_vpl VALUES ("GN42_2","002_42_2","GEN","42","2","2","Mu ne leen: «Dégg naa ne pepp am na ca Misra. Demleen jëndali nu ca, ndax nu mana dund, ba xiif bañ noo rey kay!» ");
INSERT INTO wolmbs_vpl VALUES ("GN42_3","002_42_3","GEN","42","3","3","Ci kaw loolu fukki magi Yuusufa ya dem Misra, jëndi pepp. ");
INSERT INTO wolmbs_vpl VALUES ("GN42_4","002_42_4","GEN","42","4","4","Waaye Yanqóoba yebalul Beñamin, rakku Yuusufa, ndax dafa ragal ne musiba man na koo dab. ");
INSERT INTO wolmbs_vpl VALUES ("GN42_5","002_42_5","GEN","42","5","5","Doomi Israayil ñëw nag ci biir ñiy jëndsi pepp, ndax xiif bi lawoon na ba Kanaan. ");
INSERT INTO wolmbs_vpl VALUES ("GN42_6","002_42_6","GEN","42","6","6","Fekk booba Yuusufa mooy dogal ca réew ma, di jaay pepp waa réew mépp. Magi Yuusufa ya ñëw, sujjóotal Yuusufa. ");
INSERT INTO wolmbs_vpl VALUES ("GN42_7","002_42_7","GEN","42","7","7","Naka la Yuusufa gis magam ya, xàmmee leen, te mel ni ku leen xamul, di wax ak ñoom kàddu yu dëgër ne leen: «Fu ngeen jóge?» Ñu ne ko: «Réewu Kanaan lañu jóge, di jëndsi ab dund.» ");
INSERT INTO wolmbs_vpl VALUES ("GN42_8","002_42_8","GEN","42","8","8","Yuusufa xàmmee na ay magam, waaye ñoom xàmmeewuñu ko. ");
INSERT INTO wolmbs_vpl VALUES ("GN42_9","002_42_9","GEN","42","9","9","Xelum Yuusufa ne yarr ca la mu géntoon ca ñoom, daldi ne leen: «Yeen ay yëddukat ngeen, yuy nemmikusi mbóoti réew mi.» ");
INSERT INTO wolmbs_vpl VALUES ("GN42_10","002_42_10","GEN","42","10","10","Ñu ne ko: «Mukk sang bi, danu lay siyaare, di wutsi ab dund rekk, ");
INSERT INTO wolmbs_vpl VALUES ("GN42_11","002_42_11","GEN","42","11","11","te nun ñépp a bokk baay, di nit ñu màndu; nun kay, sang bi, dunu ay yëddukat.» ");
INSERT INTO wolmbs_vpl VALUES ("GN42_12","002_42_12","GEN","42","12","12","Mu ne leen: «Ahakay, nemmikusi mbóoti réew mi moo leen taxa jóg.» ");
INSERT INTO wolmbs_vpl VALUES ("GN42_13","002_42_13","GEN","42","13","13","Ñu ne ko: «Nun ñii di la siyaare de, fukki góor ak ñaar lanu woon, bokk sunu baay, ba ca Kanaan. Ka ca gën di xalee nga ca sunu baay, te ka ca des nekkatul.» ");
INSERT INTO wolmbs_vpl VALUES ("GN42_14","002_42_14","GEN","42","14","14","Yuusufa ne leen: «Li ma leen wax moo am, ay yëddukat doŋŋ ngeen. ");
INSERT INTO wolmbs_vpl VALUES ("GN42_15","002_42_15","GEN","42","15","15","Waaye nii laa leen di seetloo: bu seen rakk ñëwul, giñ naa ci bakkanu Firawna ne, dungeen fi jóge. ");
INSERT INTO wolmbs_vpl VALUES ("GN42_16","002_42_16","GEN","42","16","16","Na kenn ci yeen jëli seen rakk, ñu tëj ñi ci des te topp seen wax, ba xam ndax yeena ngi ci dëgg. Su dul dëgg, giñ naa ci Firawna ne ay yëddukat doŋŋ ngeen.» ");
INSERT INTO wolmbs_vpl VALUES ("GN42_17","002_42_17","GEN","42","17","17","Mu tëj leen ñetti fan. ");
INSERT INTO wolmbs_vpl VALUES ("GN42_18","002_42_18","GEN","42","18","18","Ca gannaaw ëllëg sa Yuusufa ne leen: «Bu ngeen defee lii may wax, dingeen dund, ndax man ragal naa Yàlla. ");
INSERT INTO wolmbs_vpl VALUES ("GN42_19","002_42_19","GEN","42","19","19","Ndegam ñu màndu ngeen, na leen kenn ci seen doomi baay wuutu fii, ñi ci des dem yóbbul pepp seen waa kër, yi nekk ci xiif. ");
INSERT INTO wolmbs_vpl VALUES ("GN42_20","002_42_20","GEN","42","20","20","Waaye nangeen ma indil seen rakk, ba ma xam ne li ngeen wax dëgg la; su ko defee dungeen dee.» Ñu daldi ne: «Waaw,» ");
INSERT INTO wolmbs_vpl VALUES ("GN42_21","002_42_21","GEN","42","21","21","te naa ci seen biir: «Céy su nu yégoon, sunu àqu rakk a nu topp nii, ndax danu koo seetaanoon, mu nekk ci njàqarey xol, di nu tinu, te faalewunu ko; looloo waral sunu njàqarey tey jii.» ");
INSERT INTO wolmbs_vpl VALUES ("GN42_22","002_42_22","GEN","42","22","22","Ruben nag àddu ne leen: «Ndax newuma leen woon: “Buleen gàddu bakkanu xale bi,” waaye faalewuleen ma; tey rekk la nu Yàlla doon xaare bakkanam, bi nu gàddu.» ");
INSERT INTO wolmbs_vpl VALUES ("GN42_23","002_42_23","GEN","42","23","23","Ba ñuy wax loolu, foogoon nañu ne Yuusufa déggul seen làkk, ndax làppato, ba doxoon seen diggante, di tekki. ");
INSERT INTO wolmbs_vpl VALUES ("GN42_24","002_42_24","GEN","42","24","24","Ci biir loolu mu dummóoyu leen, di jooy. Bi mu jooyee ba noppi, mu walbatiku, wax ak ñoom, doora jël Simeyon, jéng ko ci seen kanam. ");
INSERT INTO wolmbs_vpl VALUES ("GN42_25","002_42_25","GEN","42","25","25","Gannaaw loolu Yuusufa joxe ndigal, ñu sol seeni saaku pepp, te ku nekk ca ñoom, ñu yebal ko xaalisam ca saakoom, ba noppi mayaale leen lu ñu lekk ca yoon wa. Ñu defal leen noonu. ");
INSERT INTO wolmbs_vpl VALUES ("GN42_26","002_42_26","GEN","42","26","26","Ba mu ko defee ñu sëf seeni mbaam pepp ma, daldi fay bàyyikoo. ");
INSERT INTO wolmbs_vpl VALUES ("GN42_27","002_42_27","GEN","42","27","27","Fa ñu dal ca guddi, kenn ci ñoom bëgga xont mbaamam, ubbi saakoom rekk, ne pemm ci xaalisam. ");
INSERT INTO wolmbs_vpl VALUES ("GN42_28","002_42_28","GEN","42","28","28","Mu ne doomi baay ya: «Delloo nañu ma sama xaalis, mu ngi nii ci sama saaku.» Seen fit ne tërit, ñuy rag-ragi, ku ne xool sa moroom, naan: «Lu nu Yàlla nattoo nii?» ");
INSERT INTO wolmbs_vpl VALUES ("GN42_29","002_42_29","GEN","42","29","29","Ba ñu yeggee ca seen baay Yanqóoba ca réewu Kanaan, daldi koy nettali li leen dal lépp, ne ko: ");
INSERT INTO wolmbs_vpl VALUES ("GN42_30","002_42_30","GEN","42","30","30","«Waa ja yilif réew ma dafa noo résëti, foog ne danuy yëddusi réew ma. ");
INSERT INTO wolmbs_vpl VALUES ("GN42_31","002_42_31","GEN","42","31","31","Nu ne ko: “Nun ay nit ñu màndu lanu, dunu ay yëddukat; ");
INSERT INTO wolmbs_vpl VALUES ("GN42_32","002_42_32","GEN","42","32","32","fukki góor ak ñaar lanu woon yu bokk sunu baay, waaye kenn ka nekkatul, te ka gën di xalee nga fa sunu baay, ba ca réewu Kanaan.” ");
INSERT INTO wolmbs_vpl VALUES ("GN42_33","002_42_33","GEN","42","33","33","Waa ja yilif réew ma ne nu: “Ni may xame ne ñu màndu ngeen, nii la: dangeen may bàyyeek kenn ci yeen, te dem yóbbul dund seen waa kër, yi nekk ci xiif; ");
INSERT INTO wolmbs_vpl VALUES ("GN42_34","002_42_34","GEN","42","34","34","su ko defee ngeen indil ma seen rakk ju ndaw, kon dinaa xam ne dungeen ay yëddukat waaye nit ñu màndu ngeen, te dinaa leen delloo seen mbokk, ngeen mana dem fu leen neex ci réew mi.”» ");
INSERT INTO wolmbs_vpl VALUES ("GN42_35","002_42_35","GEN","42","35","35","Naka la ku nekk sotti saakoom, ne jàkk ca mbuusu xaalisam. Ba ñu gisee mbuusi xaalis ya, ñoom ak seen baay, dañoo tiit. ");
INSERT INTO wolmbs_vpl VALUES ("GN42_36","002_42_36","GEN","42","36","36","Seen baay Yanqóoba ne leen: «Xañ ngeen ma ay doom: Yuusufa nekkatul, Simeyon nekkatul, léegi ngeen bëgga jël Beñamin, yóbbu. Loolu lépp ci sama kaw; ngalla man!» ");
INSERT INTO wolmbs_vpl VALUES ("GN42_37","002_42_37","GEN","42","37","37","Ruben wax ak baayam ne ko: «Su ma la ko delloosilul, boo yeboo reyal sama ñaari doom yu góor yi. Tegal Beñamin ci sama loxo rekk, man dinaa la ko delloosil.» ");
INSERT INTO wolmbs_vpl VALUES ("GN42_38","002_42_38","GEN","42","38","38","Ci kaw loolu Yanqóoba ne: «Sama doom daal, du ànd ak yeen, ndax magam faatu na, te moom rekk a des. Su ko musiba dabee ci yoon wi ngeen jëm, dingeen ma yóbbe naqar wu may jàpp, ba kera may ànd ak sama bijjaaw, tàbbi njaniiw.» ");
INSERT INTO wolmbs_vpl VALUES ("GN43_1","002_43_1","GEN","43","1","1","Gannaaw loolu xiif bi metti ca réew ma. ");
INSERT INTO wolmbs_vpl VALUES ("GN43_2","002_43_2","GEN","43","2","2","Ba ñu lekkee pepp mi ñu jële woon Misra, ba mu jeex, seen baay ne leen: «Delluleen, wutali nu dund.» ");
INSERT INTO wolmbs_vpl VALUES ("GN43_3","002_43_3","GEN","43","3","3","Yuda ne ko: «Waa ja da noo artu woon de, wax na nu ne: “Dootuleen jàkkaarlook man te ànduleen ak seen rakk.” ");
INSERT INTO wolmbs_vpl VALUES ("GN43_4","002_43_4","GEN","43","4","4","Boo bàyyee sunu rakk, mu ànd ak nun nag, dinanu dem jëndali la dund. ");
INSERT INTO wolmbs_vpl VALUES ("GN43_5","002_43_5","GEN","43","5","5","Waaye boo ko bàyyiwul kat, dunu dem, ndax waa ja waxoon na nu ne: “Dungeen jàkkaarlook man te seen rakk àndul ak yeen.”» ");
INSERT INTO wolmbs_vpl VALUES ("GN43_6","002_43_6","GEN","43","6","6","Israayil ne leen: «Ana lu waral ngeen di ma lor, naan waa ja am ngeen jeneen rakk?» ");
INSERT INTO wolmbs_vpl VALUES ("GN43_7","002_43_7","GEN","43","7","7","Ñu ne ko: «Waa ja kat da nu doon laaj aka laajaat ci nun ak sunuy bokk, ba naa nu ndax sunu baay mu ngi dund ba tey, ak ndax am nanu rakk. Nun itam nu wax ko li mu nu laaj. Géntunu woon moos ne dina nu sant, nu indil ko sunu rakk!» ");
INSERT INTO wolmbs_vpl VALUES ("GN43_8","002_43_8","GEN","43","8","8","La ca tegu Yuda ne Israayil: «Baay, tegal ngóor si ci sama loxo, nu daldi dem, ndax nu dund, baña dee, nook yaw ak sunuy doom. ");
INSERT INTO wolmbs_vpl VALUES ("GN43_9","002_43_9","GEN","43","9","9","Dige naa sama bakkan; boo yeboo laaj ma ko. Bu ma la ko delloosilul, ba teg ko fi sa kanam, maa koy gàlloo ba kera may dee. ");
INSERT INTO wolmbs_vpl VALUES ("GN43_10","002_43_10","GEN","43","10","10","Bu nu yeexuloon ba léegi, manoon nanoo dem ba délsi ñaari yoon sax.» ");
INSERT INTO wolmbs_vpl VALUES ("GN43_11","002_43_11","GEN","43","11","11","Seen baay Israayil nag ne leen: «Ndegam manula ñàkk, dangeen di def nii: Sàkkleen ci ngëneeli réew mi, yeb ci seeni saaku, yóbbul waa ja lu mel ni tuuti diwu yaram ak lem ak cuuraayu xas ak cuuraayu ndàbb ak ay xeeti saal. ");
INSERT INTO wolmbs_vpl VALUES ("GN43_12","002_43_12","GEN","43","12","12","Te ngeen yóbbaale ci xaalis lu tollook ñaar-cay la ngeen jënde woon, ngir feyaale loola, ndax jombul njuumte la woon. ");
INSERT INTO wolmbs_vpl VALUES ("GN43_13","002_43_13","GEN","43","13","13","Su ko defee ngeen ànd ak seen rakk, fabu dellu ca waa ja. ");
INSERT INTO wolmbs_vpl VALUES ("GN43_14","002_43_14","GEN","43","14","14","Yal na Yàlla Aji Man ji def waa ja yërëm leen, ba bàyyi seen doomu baay ba, moom ak Beñamin itam. Man nag, su ma naree ñàkk ay doom—aa! Naa leen ñàkk rekk.» ");
INSERT INTO wolmbs_vpl VALUES ("GN43_15","002_43_15","GEN","43","15","15","Gaa ña jël nañu sarica booba, yóbbaale nañu it ñaar-cay xaalis ba, daldi ànd ak Beñamin, ñu dem Misra, teewi ca kanam Yuusufa. ");
INSERT INTO wolmbs_vpl VALUES ("GN43_16","002_43_16","GEN","43","16","16","Ba Yuusufa gisee Beñamin ànd ak ñoom, dafa wax fara biir këram, ne ko: «Yóbbul gaa ñi ca kër ga, te nga rey gàtt, defar ko, ndax maak ñoom nooy bokk añ tey.» ");
INSERT INTO wolmbs_vpl VALUES ("GN43_17","002_43_17","GEN","43","17","17","Waa ja def la ko Yuusufa wax, yóbbu gaa ña kër Yuusufa. ");
INSERT INTO wolmbs_vpl VALUES ("GN43_18","002_43_18","GEN","43","18","18","Ñu am nag tiitaange ndax li ñu leen yóbbu kër Yuusufa. Ña ngay xalaat naan: «Boo demee, xaalis bi ñu yeboon ci sunuy saaku yoon wu njëkk wa, moom lañu bëgga taafantoo, dugal nu fii, ba song nu, jàpp nu jaam, nangu sunuy mbaam, boole ci.» ");
INSERT INTO wolmbs_vpl VALUES ("GN43_19","002_43_19","GEN","43","19","19","Ba ñu demee ba ca buntu kër Yuusufa, wax nañu ak fara biir këram. ");
INSERT INTO wolmbs_vpl VALUES ("GN43_20","002_43_20","GEN","43","20","20","Ñu ne ko: «Sang bi baal nu, nun de ñëwoon nanu fi lu jiitu ngir jëndsi dund, ");
INSERT INTO wolmbs_vpl VALUES ("GN43_21","002_43_21","GEN","43","21","21","waaye ba nu dalee ca yoon wa, danoo ubbi sunuy saaku, ku nekk ci nun fekk xaalisam ca kaw, mu tollu na mu tollu woon, te indiwaat nanu ko. ");
INSERT INTO wolmbs_vpl VALUES ("GN43_22","002_43_22","GEN","43","22","22","Te it indaale nanu xaalis bu nu jënde dund. Waaye xamunu ku delloo xaalis ba ci sunuy saaku.» ");
INSERT INTO wolmbs_vpl VALUES ("GN43_23","002_43_23","GEN","43","23","23","Mu ne leen: «Jàmm rekk la; buleen tiit, seen Yàlla, jiy seen Yàllay baay, moo leen defal alal ci seeni saaku. Seen xaalis jot naa ci.» Ci kaw loolu mu génne Simeyon, indil leen ko. ");
INSERT INTO wolmbs_vpl VALUES ("GN43_24","002_43_24","GEN","43","24","24","Waa ja dugal leen kër Yuusufa, may leen ndox ñu jàngu, ba noppi xont seeni mbaam. ");
INSERT INTO wolmbs_vpl VALUES ("GN43_25","002_43_25","GEN","43","25","25","Ba mu ko defee ñu yebbi seeni sarica, bala Yuusufaa agsi ca digg bëccëg, ndaxte dégg nañu ne foofa lañuy añe. ");
INSERT INTO wolmbs_vpl VALUES ("GN43_26","002_43_26","GEN","43","26","26","Ba Yuusufa wàccsee, ñu jébbal ko foofa ca biir kër ga sarica, ba ñu ko indaaleel, daldi koy sujjóotal. ");
INSERT INTO wolmbs_vpl VALUES ("GN43_27","002_43_27","GEN","43","27","27","Mu nuyoo ak ñoom, ba noppi laaj leen ne leen: «Seen baay bu màggat, ba ngeen doon wax, mbaa mu ngi dund? Mbaa mu ngi ci jàmm?» ");
INSERT INTO wolmbs_vpl VALUES ("GN43_28","002_43_28","GEN","43","28","28","Ñu ne ko: «Sunu baay mu ngi dund, sang bi, te mu ngi ci jàmm.» Ña nga koy sukkal tey sujjóotati. ");
INSERT INTO wolmbs_vpl VALUES ("GN43_29","002_43_29","GEN","43","29","29","Naka la Yuusufa ne gees, gis Beñamin rakku doomu ndeyam ja. Mu laaj leen ne leen: «Ndax kii mooy seen rakk, ji ngeen ma doon wax?» La ca tegu mu ne rakkam ja: «Sama ngóor si, yal na la Yàlla defal yiw waay!» ");
INSERT INTO wolmbs_vpl VALUES ("GN43_30","002_43_30","GEN","43","30","30","Ci kaw loolu Yuusufa gaaw génn ndax yaram wu daw, te manatula téye ay rongooñam ndax rakkam ja, mu dugg néegu biiram, di jooy. ");
INSERT INTO wolmbs_vpl VALUES ("GN43_31","002_43_31","GEN","43","31","31","Ba mu noppee, sëlmu, génn, doora ànd ak sagoom, daldi joxe ndigal, ne: «Taajleen añ bi.» ");
INSERT INTO wolmbs_vpl VALUES ("GN43_32","002_43_32","GEN","43","32","32","Loolu wees ñu may Yuusufa moom rekk; ber doomi baayam ya. Waa Misra ña fa doon lekke it, ñu beral leen seen ndab, ngir waa Misra daawuñu bokk ak Ebrë yi lekk, ndax mbañ la fa woon. ");
INSERT INTO wolmbs_vpl VALUES ("GN43_33","002_43_33","GEN","43","33","33","Ña nga toog, na mu leen ko sante, taaw ba fegge wet, ni ko ko céru taaw maye, ñu sësaloo, na ñu toppantee ciy at, ba ca caat ma. Gaa ñaa nga yéemu, di xoolante. ");
INSERT INTO wolmbs_vpl VALUES ("GN43_34","002_43_34","GEN","43","34","34","Mu sàkkal leen ca ndabam, te Beñamin ëpple ku ci nekk juróomi yoon. Ñu bokk nag naan a naan, ba seen xol sedd. ");
INSERT INTO wolmbs_vpl VALUES ("GN44_1","002_44_1","GEN","44","1","1","Ba loolu wéyee mu sant fara biir këram, ne ko: «Solal seeni saaku pepp lu ñu mana àttan, te nga delloo ku nekk xaalisam, tegal ko ko ca buntu saakoom. ");
INSERT INTO wolmbs_vpl VALUES ("GN44_2","002_44_2","GEN","44","2","2","Waaye sama kaasu xaalis boobee, yebal ko ki gën di xale ci saakoom, boole ko ak xaalisu peppam.» Mu def la Yuusufa wax. ");
INSERT INTO wolmbs_vpl VALUES ("GN44_3","002_44_3","GEN","44","3","3","Ca ëllëg sa, ba jant bay fenk, yiwi nañu gaa ña, ñu sëf seeni mbaam, dem. ");
INSERT INTO wolmbs_vpl VALUES ("GN44_4","002_44_4","GEN","44","4","4","Naka lañu génn dëkk ba, te soreeguñu sax, Yuusufa sant fara biir këram, ne ko: «Gaawal dab gaa ña, te boo leen dabee, wax leen ne leen: “Lu tax ñu ji leen ngor, ngeen feye ngoreedi? ");
INSERT INTO wolmbs_vpl VALUES ("GN44_5","002_44_5","GEN","44","5","5","Ndax li ngeen jël du sama kaasu sang, bi muy naane, rawatina di ko gisaanee? Lu ñaaw ngeen def nii!”» ");
INSERT INTO wolmbs_vpl VALUES ("GN44_6","002_44_6","GEN","44","6","6","Mu daldi leen dab, wax leen loolu. ");
INSERT INTO wolmbs_vpl VALUES ("GN44_7","002_44_7","GEN","44","7","7","Ñu ne ko: «Kilifa gi, looy wax nii? Nun de, sang bi, jomb nanu loolu! ");
INSERT INTO wolmbs_vpl VALUES ("GN44_8","002_44_8","GEN","44","8","8","Xaalis bi nu fekkoon ci sunu bunti saaku sax, danoo àndaat ak moom, jóge ba Kanaan, delloosil la ko, kon nan lanu mana sàcce sa kër sang xaalis mbaa wurus? ");
INSERT INTO wolmbs_vpl VALUES ("GN44_9","002_44_9","GEN","44","9","9","Ngalla kilifa gi, yaay sunu sang; koo ko fekke ci nun rekk, boo yeboo reyal, ñi des ci nun doxe fa, di say jaam.» ");
INSERT INTO wolmbs_vpl VALUES ("GN44_10","002_44_10","GEN","44","10","10","Mu ne leen: «Li ngeen wax yoon la sax, waaye na ki ma ko fekke doŋŋ di sama jaam, su ko defee ñi ci des wàcc.» ");
INSERT INTO wolmbs_vpl VALUES ("GN44_11","002_44_11","GEN","44","11","11","Ñu gaaw nag, wàcce seeni saaku ci suuf, ku nekk ubbi saakoom. ");
INSERT INTO wolmbs_vpl VALUES ("GN44_12","002_44_12","GEN","44","12","12","Ma ngay seet, tàmbalee ca taaw ba, ba ca caat ma, doora fekk kaas ba ca saaku Beñamin. ");
INSERT INTO wolmbs_vpl VALUES ("GN44_13","002_44_13","GEN","44","13","13","Ba loolu amee dañoo torox, ba xotti seeni yére, ku nekk sëfaat mbaamam, ñu dellu ca dëkk ba. ");
INSERT INTO wolmbs_vpl VALUES ("GN44_14","002_44_14","GEN","44","14","14","Yuda aki doomi baayam nag délsi kër Yuusufa, fekk demagul. Ñu daldi ne nërëm, dëpp seen jë fi suuf. ");
INSERT INTO wolmbs_vpl VALUES ("GN44_15","002_44_15","GEN","44","15","15","Yuusufa ne leen: «Li ngeen def nag? Xanaa xamuleen ne nit ku mel ni man day gisaane?» ");
INSERT INTO wolmbs_vpl VALUES ("GN44_16","002_44_16","GEN","44","16","16","Yuda ne: «Sang bi, lu nuy waxati? Lu nu mana lay, ba setal sunu bopp? Yàllaa nu feeñal, sang bi. Nanu bokk nun ñépp di say jaam, yem ci kepp ak ki ñu fekk kaas bi ci loxoom.» ");
INSERT INTO wolmbs_vpl VALUES ("GN44_17","002_44_17","GEN","44","17","17","Mu ne leen: «Jomb naa loolu. Ki ñu fekk kaas bi ci loxoom mooy doon sama jaam; ñi ci des dellu ca seen baay ci jàmm.» ");
INSERT INTO wolmbs_vpl VALUES ("GN44_18","002_44_18","GEN","44","18","18","Yuda jegesi ne ko: «Ngalla sang bi, ma ñeme laa diis lenn rekk, te sa xol baña tàng ci man, doonte yaak Firawnaa tolloo. ");
INSERT INTO wolmbs_vpl VALUES ("GN44_19","002_44_19","GEN","44","19","19","Sang bi, danga noo laajoon ne nu: “Ndax am ngeen baay walla rakk?” ");
INSERT INTO wolmbs_vpl VALUES ("GN44_20","002_44_20","GEN","44","20","20","Ba mu ko defee nu ne la: “Am nanu baay bu màggat. Sunu rakk, ji mu jur te fekk ko di màggat nag, moo ci gën di ndaw. Magam dafa dee, mu des moom doŋŋ ci ndeyam, baayam sopp ko lool.” ");
INSERT INTO wolmbs_vpl VALUES ("GN44_21","002_44_21","GEN","44","21","21","Nga waxoon nu ne nu: “Indilleen ma ko, ngir ma gisal ko sama bopp.” ");
INSERT INTO wolmbs_vpl VALUES ("GN44_22","002_44_22","GEN","44","22","22","Ci kaw loolu, sang bi, nu wax la ne: “Xale bu góor bi manula tàggook baayam. Bu tàggoo ak moom, kon baayam dina dee.” ");
INSERT INTO wolmbs_vpl VALUES ("GN44_23","002_44_23","GEN","44","23","23","Nga wax nu ne nu: “Bu seen rakk àndul ak yeen, dungeen jàkkaarlook man.” ");
INSERT INTO wolmbs_vpl VALUES ("GN44_24","002_44_24","GEN","44","24","24","Booba lanu dem ca sunu baay ba lay siyaare, daldi koy jottali say kàddu. ");
INSERT INTO wolmbs_vpl VALUES ("GN44_25","002_44_25","GEN","44","25","25","«Ba nu demee ba mu yàgg, sunu baay ne: “Delluleen, jëndali nu tuuti dund.” ");
INSERT INTO wolmbs_vpl VALUES ("GN44_26","002_44_26","GEN","44","26","26","Teewul nu ne: “Dunu mana dem te sunu rakk àndul ak nun, ndaxte bu nu àndul ak moom, dunu gis kilifa ga.” ");
INSERT INTO wolmbs_vpl VALUES ("GN44_27","002_44_27","GEN","44","27","27","Sunu baay ba lay siyaare, ne nu: “Xam ngeen ne damaa amul ak sama soxna lu dul ñaari doom. ");
INSERT INTO wolmbs_vpl VALUES ("GN44_28","002_44_28","GEN","44","28","28","Kenn ki dem, wacc ma, ma ne moom kay, aw rabu àll a ko daggate! Gisaatuma ko ba tey jii. ");
INSERT INTO wolmbs_vpl VALUES ("GN44_29","002_44_29","GEN","44","29","29","Te bu ngeen ma fi jëlalee kii itam, ba musiba dab ko, dingeen ma yóbbe naqar wu may jàpp, ba kera may ànd ak sama bijjaaw, tàbbi njaniiw.” ");
INSERT INTO wolmbs_vpl VALUES ("GN44_30","002_44_30","GEN","44","30","30","«Léegi nag, bu ma ñibbee ca sama baay ba lay siyaare, te àndunook xale bii muy noyyee, ");
INSERT INTO wolmbs_vpl VALUES ("GN44_31","002_44_31","GEN","44","31","31","bu gisul xale bu góor bi ànd ak nun ñibbisi—aa! Kon de dina dee, te dinanu yóbbe sunu baay naqar, wu koy topp, ba kera muy ànd ak bijjaawam, tàbbi njaniiw. ");
INSERT INTO wolmbs_vpl VALUES ("GN44_32","002_44_32","GEN","44","32","32","Gannaaw loolu it xasoon naa dige sama bakkan, ndax damaa waxoon ne: “Bu ma la ko delloosilul, maa koy gàlloo ba kera may dee.” ");
INSERT INTO wolmbs_vpl VALUES ("GN44_33","002_44_33","GEN","44","33","33","Kon ngalla sang bi, bàyyi ma man ma des fi di sa jaam, wuutu xale bi, te moom mu dellu ànd aki magam ñibbi. ");
INSERT INTO wolmbs_vpl VALUES ("GN44_34","002_44_34","GEN","44","34","34","Ndax xawma nan laay delloo ca sama baay te ànduma ak xale bi. Yàlla buma fekke njekkar li ciy dal sama baay!» ");
INSERT INTO wolmbs_vpl VALUES ("GN45_1","002_45_1","GEN","45","1","1","Ba loolu amee Yuusufa manatula téye boppam, te surgaam yépp a nga teew. Mu daldi àddu ne: «Xiddileen ma, yeen ñépp!» Ñépp dem, ba benn jàmbur nekku fa, ba Yuusufa di xàmmiku ay bokkam. ");
INSERT INTO wolmbs_vpl VALUES ("GN45_2","002_45_2","GEN","45","2","2","Mu ne yikkét, jooy jooy yu metti, waa Misra di ca dégg, ba ca kër Firawna sax. ");
INSERT INTO wolmbs_vpl VALUES ("GN45_3","002_45_3","GEN","45","3","3","Yuusufa nag ne magam ya: «Man mii maay Yuusufa! Mbaa sama baay a ngi dund?» Magam ya nag manuñu koo tontu, ndax booba njàqare jàpp na leen. ");
INSERT INTO wolmbs_vpl VALUES ("GN45_4","002_45_4","GEN","45","4","4","Yuusufa dellu ne ay magam: «Jegeñsileen.» Ñu jegeñsi. Mu ne leen: «Man maay Yuusufa, seen rakk, ji ngeen jaayoon, ñu indi ma Misra. ");
INSERT INTO wolmbs_vpl VALUES ("GN45_5","002_45_5","GEN","45","5","5","Waaye buleen jaaxle tey, mbaa ngeen di sikk seen bopp ndax li ngeen ma jaay, ñu indi ma fi. Rawale ay bakkan moo tax Yàlla yebal ma fi, ma jiitusi leen. ");
INSERT INTO wolmbs_vpl VALUES ("GN45_6","002_45_6","GEN","45","6","6","Ñaari at a ngii xiif baa ngi ci réew mi, te fii ak juróomi at ci kanam, kenn du bey, kenn du góob. ");
INSERT INTO wolmbs_vpl VALUES ("GN45_7","002_45_7","GEN","45","7","7","Yàlla da maa yebal, ma jiitusi leen, ba rawale seen bakkan, dikke leen xettal gu mag, ba seen askan baña fey. ");
INSERT INTO wolmbs_vpl VALUES ("GN45_8","002_45_8","GEN","45","8","8","Kon nag du yeena ma yebal fii, waaye Yàllaa. Te moo ma jagleel, ma doon cëslaayal Firawna, mel ni baay ci moom, jiite këram gépp, boole ci yilif mboolem réewum Misra. ");
INSERT INTO wolmbs_vpl VALUES ("GN45_9","002_45_9","GEN","45","9","9","«Gaawleen dellu ci sama baay te ne ko: “Sa doom Yuusufa nee na: Yàlla fal na ma kilifag Misra gépp; ñëwal fi man, nu mu gëna gaawe. ");
INSERT INTO wolmbs_vpl VALUES ("GN45_10","002_45_10","GEN","45","10","10","Su ko defee nga dëkksi diiwaanu Gosen, nekk ci sama wet, yaak say doom ak say sët ak say gàtt ak say gétt ak mboolem loo moom, ");
INSERT INTO wolmbs_vpl VALUES ("GN45_11","002_45_11","GEN","45","11","11","ndaxte des na juróomi ati xiif. Waaye dinaa la fi yore, ba doo ñàkk dara, yaak sa waa kër ak mboolem lu bokk ci yaw.” ");
INSERT INTO wolmbs_vpl VALUES ("GN45_12","002_45_12","GEN","45","12","12","Yeena gisal seen bopp, yeen ak sama rakk Beñamin, ne man Yuusufa mii, maay wax ak yeen. ");
INSERT INTO wolmbs_vpl VALUES ("GN45_13","002_45_13","GEN","45","13","13","Nettalileen sama baay ndam li ma am ci Misra ak li ngeen gis lépp, te ngeen indi sama baay, nu mu gëna gaawe.» ");
INSERT INTO wolmbs_vpl VALUES ("GN45_14","002_45_14","GEN","45","14","14","Mu laxasu Beñamin rakkam, daldi jooy, Beñamin it laxasu ko, jooy. ");
INSERT INTO wolmbs_vpl VALUES ("GN45_15","002_45_15","GEN","45","15","15","Magam ña itam, mu fóon leen tey jooy. Booba la magi Yuusufa ya doora wax ak moom. ");
INSERT INTO wolmbs_vpl VALUES ("GN45_16","002_45_16","GEN","45","16","16","Ba xibaar ba àggee kër Firawna, ñu naan magi Yuusufa ñëw nañu, doonoon na lu neex Firawna, moom aki dagam. ");
INSERT INTO wolmbs_vpl VALUES ("GN45_17","002_45_17","GEN","45","17","17","Firawna ne Yuusufa: «Waxal say mag, ne leen: “Ni ngeen di def mooy nii: Sëfleen seeni mbaam te dem réewu Kanaan, ");
INSERT INTO wolmbs_vpl VALUES ("GN45_18","002_45_18","GEN","45","18","18","jëli seen baay ak seeni njaboot, ngeen ñëw fi sama wet. Dinaa leen jox suuf si gën ci réewum Misra, ngeen di lekk li fi gëna duuf.”» ");
INSERT INTO wolmbs_vpl VALUES ("GN45_19","002_45_19","GEN","45","19","19","Firawna dellu ne Yuusufa: «Am nga ndigal itam ci wax leen ne leen: “Ni ngeen koy defe nii la: Dangeen di jële ay watiir ci réew mi, dem yeb ci seeni doom ak seeni soxna, te ànd ak seen baay, ngeen ñëw. ");
INSERT INTO wolmbs_vpl VALUES ("GN45_20","002_45_20","GEN","45","20","20","Te buleen réccu alal ji ngeen di bàyyi seen gannaaw, ndax li gën ci réewum Misra yeena koy moom.”» ");
INSERT INTO wolmbs_vpl VALUES ("GN45_21","002_45_21","GEN","45","21","21","Ba loolu amee doomi Israayil def noona. Yuusufa jox leen ay watiir ci ndigalu Firawna, ak lu ñu lekk ca yoon wa, ");
INSERT INTO wolmbs_vpl VALUES ("GN45_22","002_45_22","GEN","45","22","22","mayaale leen ku ne mbubb mu rafet. Waaye Beñamin moom, ñetti téeméeri dogi xaalis la ko may, tegal ko ca juróomi mbubb yu rafet. ");
INSERT INTO wolmbs_vpl VALUES ("GN45_23","002_45_23","GEN","45","23","23","Baayam nag, mu yóbbante ko fukki mbaam yu góor yu sëf lay tànnéef ca Misra, ak fukki mbaam yu jigéen yu sëf pepp ak mburu, tegal ko ca lu mu dunde ca yoon wa, buy ñëw. ");
INSERT INTO wolmbs_vpl VALUES ("GN45_24","002_45_24","GEN","45","24","24","Gannaaw loolu mu yiwi ay magam ne leen: «Ngalla buleen xuloo ci yoon wi.» Ñu daldi dem. ");
INSERT INTO wolmbs_vpl VALUES ("GN45_25","002_45_25","GEN","45","25","25","Booba lañu bàyyikoo Misra, dellu réewu Kanaan ca seen baay Yanqóoba. ");
INSERT INTO wolmbs_vpl VALUES ("GN45_26","002_45_26","GEN","45","26","26","Ñu wax ko ne ko: «Ndekete Yuusufaa ngi dund! Te sax mooy kilifag réewum Misra gépp.» Ba Yanqóoba déggee loolu, yaramam dafa dee goyy ca saa sa, ndaxte gëmu leen. ");
INSERT INTO wolmbs_vpl VALUES ("GN45_27","002_45_27","GEN","45","27","27","Waaye ba ñu nettalee seen baay Yanqóoba li Yuusufa wax lépp, te mu gis watiir, yi Yuusufa yónnee, ngir jëlsi ko, ca la xelam délsi. ");
INSERT INTO wolmbs_vpl VALUES ("GN45_28","002_45_28","GEN","45","28","28","Israayil daldi ne: «Moom kay na dund rekk! Sama doom Yuusufaa ngi dund. Man kay dinaa dem ba gis ko, bala ma fee jóge.» ");
INSERT INTO wolmbs_vpl VALUES ("GN46_1","002_46_1","GEN","46","1","1","Israayil nag dem, yóbbaale mboolem lu bokk ci moom. Ba mu agsee Beerseba, dafa sarxal Yàllay baayam Isaaxa. ");
INSERT INTO wolmbs_vpl VALUES ("GN46_2","002_46_2","GEN","46","2","2","Yàlla wax ak Israayil foofa ca guddi ci biir gént ne ko: «Yanqóoba, Yanqóoba!» Israayil ne ko: «Naam.» ");
INSERT INTO wolmbs_vpl VALUES ("GN46_3","002_46_3","GEN","46","3","3","Yàlla ne ko: «Man maay Yàlla, di sa Yàllay baay. Bul ragala dem Misra, ndaxte xeet wu réy laa fay sose ci yaw. ");
INSERT INTO wolmbs_vpl VALUES ("GN46_4","002_46_4","GEN","46","4","4","Man ci sama bopp maay ànd ak yaw Misra, te na la wóor ne dinaa la delloosi, te it Yuusufa moo lay doggali.» ");
INSERT INTO wolmbs_vpl VALUES ("GN46_5","002_46_5","GEN","46","5","5","Ba loolu amee Yanqóoba jóge Beerseba; doomi Israayil boole seen baay ak seeni doom ak seeni soxna, yeb leen ci watiir, yi Firawna yónnee woon, ngir yóbbu leen. ");
INSERT INTO wolmbs_vpl VALUES ("GN46_6","002_46_6","GEN","46","6","6","Ña nga jiital seeni jur, daldi yóbbaale seen alal, ja ñu ame réewu Kanaan. Noonu la Yanqóoba deme Misra ànd ak njabootam gépp, ");
INSERT INTO wolmbs_vpl VALUES ("GN46_7","002_46_7","GEN","46","7","7","yóbbaale doomam yu góor ya ak sëtam yu góor ya ak doomam yu jigéen ya it, ñook sëtam yu jigéen ya, ak mboolem ña askanoo ca moom. ");
INSERT INTO wolmbs_vpl VALUES ("GN46_8","002_46_8","GEN","46","8","8","Waa kër Israayil, yi ñëw Misra te di Yanqóoba aki doomam, seeni tur a di: Ruben, taawub Yanqóoba. ");
INSERT INTO wolmbs_vpl VALUES ("GN46_9","002_46_9","GEN","46","9","9","Doomi Ruben yu góor di Enog ak Palu ak Esron ak Karmi. ");
INSERT INTO wolmbs_vpl VALUES ("GN46_10","002_46_10","GEN","46","10","10","Doomi Simeyon yu góor di Yemuwel ak Yamin ak Owàdd ak Yakin ak Cowar ak Sawul, mi ndeyam di Kanaaneen. ");
INSERT INTO wolmbs_vpl VALUES ("GN46_11","002_46_11","GEN","46","11","11","Doomi Lewi yu góor di Gerson, Keyat ak Merari. ");
INSERT INTO wolmbs_vpl VALUES ("GN46_12","002_46_12","GEN","46","12","12","Doomi Yuda yu góor di Er ak Onan ak Sela ak Peres ak Sera, te Er ak Onan faatu ca réewu Kanaan. Doomi Peres yu góor di Esron ak Amul. ");
INSERT INTO wolmbs_vpl VALUES ("GN46_13","002_46_13","GEN","46","13","13","Doomi Isaakar yu góor di Tola ak Puwa ak Yasub ak Simron. ");
INSERT INTO wolmbs_vpl VALUES ("GN46_14","002_46_14","GEN","46","14","14","Doomi Sabulon yu góor di Seredd, Elon ak Yaxleel. ");
INSERT INTO wolmbs_vpl VALUES ("GN46_15","002_46_15","GEN","46","15","15","Góor ñooñoo xeetoo ci Leya, te askanoo ci Yanqóoba ca Padan Aram, gannaaw Diina miy doomam ju jigéen. Boo boolee doomam yépp, góor ak jigéen, ñuy fanweer ak ñett. ");
INSERT INTO wolmbs_vpl VALUES ("GN46_16","002_46_16","GEN","46","16","16","Doomi Gàdd yu góor ñoo di Cefon ak Agi ak Suni ak Eccbon ak Eri ak Arodi ak Areli. ");
INSERT INTO wolmbs_vpl VALUES ("GN46_17","002_46_17","GEN","46","17","17","Doomi Aser yu góor di Imna ak Yiswa ak Iswi ak Berya, Sera di seen jigéen. Doomi Berya yu góor di Eber ak Malkiyel. ");
INSERT INTO wolmbs_vpl VALUES ("GN46_18","002_46_18","GEN","46","18","18","Góor ñooñoo xeetoo ci Silpa, mi Laban may Leya, doomam ju jigéen, te ñu askanoo ci Yanqóoba, ñuy fukki bakkan ak juróom benn. ");
INSERT INTO wolmbs_vpl VALUES ("GN46_19","002_46_19","GEN","46","19","19","Doom yu góor yi Rasel, soxnas Yanqóoba, am nag ñoo di Yuusufa ak Beñamin. ");
INSERT INTO wolmbs_vpl VALUES ("GN46_20","002_46_20","GEN","46","20","20","Yuusufa itam am Manase ak Efrayim ca réewum Misra, seen yaay di Asnat doomu Potifera, may sarxalkat ca dëkk ba ñu naan Oon. ");
INSERT INTO wolmbs_vpl VALUES ("GN46_21","002_46_21","GEN","46","21","21","Doomi Beñamin yu góor ñoo di Bela ak Beker ak Asbel ak Gera ak Naaman ak Exi ak Ros ak Muppim ak Uppim ak Àrd. ");
INSERT INTO wolmbs_vpl VALUES ("GN46_22","002_46_22","GEN","46","22","22","Góor ñooñoo xeetoo ci Rasel, te askanoo ci Yanqóoba, ñépp di fukki bakkan ak ñeent. ");
INSERT INTO wolmbs_vpl VALUES ("GN46_23","002_46_23","GEN","46","23","23","Doomu Dan ju góor di Usim. ");
INSERT INTO wolmbs_vpl VALUES ("GN46_24","002_46_24","GEN","46","24","24","Doomi Neftali yu góor di Yàcceel ak Gunni ak Yeccer ak Silem. ");
INSERT INTO wolmbs_vpl VALUES ("GN46_25","002_46_25","GEN","46","25","25","Góor ñooñoo xeetoo ci Bilaa, mi Laban may doomam Rasel, te ñu askanoo ci Yanqóoba, ñoom ñépp di juróom ñaari bakkan. ");
INSERT INTO wolmbs_vpl VALUES ("GN46_26","002_46_26","GEN","46","26","26","Mboolem ñi ànd ak Yanqóoba, ñëw Misra, muy ñi mu giir, te limaaleesul soxnay doomi Yanqóoba ya, tollu nañu ci juróom benn fukki bakkan ak juróom benn. ");
INSERT INTO wolmbs_vpl VALUES ("GN46_27","002_46_27","GEN","46","27","27","Doomi Yuusufa yu góor, ya mu am Misra, tollu ci ñaar. Kon mboolem ña dem Misra te di waa kër Yanqóoba, tollu nañu ci juróom ñaar fukk. ");
INSERT INTO wolmbs_vpl VALUES ("GN46_28","002_46_28","GEN","46","28","28","Yanqóoba dafa yebal Yuda, mu ànd ak Yuusufa, jiituji ko diiwaanu Gosen, mu fekki leen fa. Ñu daldi agsi Gosen. ");
INSERT INTO wolmbs_vpl VALUES ("GN46_29","002_46_29","GEN","46","29","29","Yuusufa nag waajal waruwaayam, dajeji ak baayam Israayil ca Gosen. Ba Yuusufa àggee ba ca moom, da koo laxasu, ne ñàpp ci kawam, jooy lu yàgg. ");
INSERT INTO wolmbs_vpl VALUES ("GN46_30","002_46_30","GEN","46","30","30","Israayil ne Yuusufa: «Léegi de, bu ma yeboo dee, gannaaw gisaat naa la, ngay dund.» ");
INSERT INTO wolmbs_vpl VALUES ("GN46_31","002_46_31","GEN","46","31","31","Ba mu ko defee Yuusufa wax ak doomi baayam ya ak waa kër baayam ne leen: «Maa ngi dellu yégali Firawna ne ko: “Samay bokk ak sama waa kër baay, ña nekkoon ca réewu Kanaan, ñëw nañu fi man. ");
INSERT INTO wolmbs_vpl VALUES ("GN46_32","002_46_32","GEN","46","32","32","Dafa di seeni góor ay sàmm lañu, ag jur lañu masa yar, te indaale nañu seen jur gu gàtt ak gu gudd ak mboolem lu ñu moom.” ");
INSERT INTO wolmbs_vpl VALUES ("GN46_33","002_46_33","GEN","46","33","33","Kon bu leen Firawna woowee, ne leen: ");
INSERT INTO wolmbs_vpl VALUES ("GN46_34","002_46_34","GEN","46","34","34","“Lan mooy seen liggéey?” ngeen ne ko: “Nun de sang bi, ag jur lanu masa yar, ba nuy gone ba tey, te noonu la ko sunuy maam daan defe.” Su boobaa, ngeen mana féetewoo diiwaanu Gosen, ndaxte waa Misra dañuy xof sàmm.» ");
INSERT INTO wolmbs_vpl VALUES ("GN47_1","002_47_1","GEN","47","1","1","Yuusufa daa dem ca Firawna, wax ko ne ko: «Sama baay ak samay bokk, jóge nañu Kanaan, ànd ak seen jur gu gàtt ak gu gudd ak mboolem lu ñu moom. Ña nga léegi ca diiwaanu Gosen.» ");
INSERT INTO wolmbs_vpl VALUES ("GN47_2","002_47_2","GEN","47","2","2","Fekk na Yuusufa tànn juróom ciy doomi baayam. Mu nuyole leen ak Firawna. ");
INSERT INTO wolmbs_vpl VALUES ("GN47_3","002_47_3","GEN","47","3","3","Firawna laaj doomi baay ya, ne leen: «Lan mooy seen liggéey?» Ñu ne ko: «Nun de sang bi, ay sàmm lanu naka jekk ca sunuy maam ba tey.» ");
INSERT INTO wolmbs_vpl VALUES ("GN47_4","002_47_4","GEN","47","4","4","Ñu teg ca ne ko: «Danoo ñëw ngir dal ci réew mi, ndaxte amalatunu sunu jur parlu, te xiif bi metti na ca réewu Kanaan. Moo tax sang bi, nu di la ñaan, nga may nu, nu dal foofa ca diiwaanu Gosen.» ");
INSERT INTO wolmbs_vpl VALUES ("GN47_5","002_47_5","GEN","47","5","5","Firawna wax ak Yuusufa ne ko: «Gannaaw sa baay ak say bokk ñëw nañu fi yaw, ");
INSERT INTO wolmbs_vpl VALUES ("GN47_6","002_47_6","GEN","47","6","6","réewum Misraa ngii ci sa kanam. Seetal fi gën ci réew mi, nga jox sa baay ak say bokk, ñu sanc. Bàyyi leen, ñu sanc Gosen, te bu ci amee ñu xareñ ci ñoom, nga dénk leen samay gétt.» ");
INSERT INTO wolmbs_vpl VALUES ("GN47_7","002_47_7","GEN","47","7","7","Gannaaw loolu Yuusufa ànd ak baayam ba fa Firawna, nuyole ko ak moom. Yanqóoba nuyu Firawna. ");
INSERT INTO wolmbs_vpl VALUES ("GN47_8","002_47_8","GEN","47","8","8","Firawna laaj Yanqóoba ne ko: «Aa, góor gi, xanaa war ngaa doon mag de!» ");
INSERT INTO wolmbs_vpl VALUES ("GN47_9","002_47_9","GEN","47","9","9","Yanqóoba wax Firawna ne ko: «Samay ati màngaan, ba ma ganee àddina ba tey de, mu ngi tollu ci téeméer ak fanweer (130), muy at yu gàtt te naqari, te it demuma bay tolloo ay at ak samay maam, ba ñuy màngaan ci àddina.» ");
INSERT INTO wolmbs_vpl VALUES ("GN47_10","002_47_10","GEN","47","10","10","Ba mu ko defee Yanqóoba ñaanal Firawna, bàyyikoo fa, daldi dem. ");
INSERT INTO wolmbs_vpl VALUES ("GN47_11","002_47_11","GEN","47","11","11","Yuusufa nag dalal baayam aki bokkam, dogal leen suuf sa gën ca réewum Misra ca diiwaanu Ramses, ni ko ko Firawna sante woon. ");
INSERT INTO wolmbs_vpl VALUES ("GN47_12","002_47_12","GEN","47","12","12","Ba loolu amee Yuusufa di dundal baayam aki bokkam, ak mboolem waa kër baayam, boole ca ña bootu ca ñoom. ");
INSERT INTO wolmbs_vpl VALUES ("GN47_13","002_47_13","GEN","47","13","13","Ab dund amuloon fenn ca réew ma mépp, ndax xiif bu metti lool. Waa réewum Misra ak réewu Kanaan jeex tàkk ndax xiif ba. ");
INSERT INTO wolmbs_vpl VALUES ("GN47_14","002_47_14","GEN","47","14","14","Yuusufa nag dajalee ca pepp, ma mu jaay waa Misra ak waa Kanaan, mboolem xaalisu ñaari réew ya, yóbbu nag xaalis ba kër Firawna. ");
INSERT INTO wolmbs_vpl VALUES ("GN47_15","002_47_15","GEN","47","15","15","Ba ñu demee, ba xaalis amatul ca Misra ak ca Kanaan, waa Misra gépp ñëw fa Yuusufa ne ko: «Jox nu ab dund kay! Mbaa du danga nuy seetaan, nuy dee? Ndax xaalis amatul.» ");
INSERT INTO wolmbs_vpl VALUES ("GN47_16","002_47_16","GEN","47","16","16","Yuusufa ne leen: «Indileen seeni jur, ma wecci leen ko dund, ndegam amatuleen xaalis.» ");
INSERT INTO wolmbs_vpl VALUES ("GN47_17","002_47_17","GEN","47","17","17","Gannaaw loolu ñu indil Yuusufa seeni jur, Yuusufa jox leen ko pepp, wecci leen ko seeni fas ak seeni gétti jur gu gàtt ak gu gudd ak seeni mbaam. At mooma jox na leen ab dund, mu wecci seen gétt gépp. ");
INSERT INTO wolmbs_vpl VALUES ("GN47_18","002_47_18","GEN","47","18","18","Ba at ma jeexee, ñu ñëwaat ca moom ca déwén sa ne ko: «Sang bi, dunu la nëbb ne amatunu dara, ndax xaalis bi jeex na, te jur gaa ngi ci yaw, dara nekkatu fi lu nu la mana jox lu moy sunuy jëmm ak sunuy tool. ");
INSERT INTO wolmbs_vpl VALUES ("GN47_19","002_47_19","GEN","47","19","19","Mbaa du danga nuy seetaan, nu bokk sànku ci sa kanam, nook sunu suuf? Ngalla boole nu jënde ab dund, nun ak sunuy suuf. Su ko defee nuy moomeeli Firawna, nun ak sunuy suuf. Te nga jox nu pepp mu nu dunde, lu ko moy kat nun dinanu dee, suuf si it dina booy.» ");
INSERT INTO wolmbs_vpl VALUES ("GN47_20","002_47_20","GEN","47","20","20","Yuusufa nag jëndal Firawna suufas Misra gépp, ngir waa Misra ya jaay ku ci nekk sa tool ndax xiif, ba leen jiital, ba Firawna mujj moom suuf si. ");
INSERT INTO wolmbs_vpl VALUES ("GN47_21","002_47_21","GEN","47","21","21","Waa réew ma ñoom, Yuusufa da leena def ay jaam ca Misra, gii wet ba gaa. ");
INSERT INTO wolmbs_vpl VALUES ("GN47_22","002_47_22","GEN","47","22","22","Bàyyiwul lu moy suufu sarxalkat ya, ndax Firawna jotoon na leena dogal ay cér, jagleel leen. Moo tax jaayuñu seeni suuf. ");
INSERT INTO wolmbs_vpl VALUES ("GN47_23","002_47_23","GEN","47","23","23","Yuusufa ne waa réew ma: «Léegi gannaaw jënd naa leen, ba Firawna moom leen, yeen ak seeni suuf, jiwoo ngii, demleen jiwi. ");
INSERT INTO wolmbs_vpl VALUES ("GN47_24","002_47_24","GEN","47","24","24","Bu nu àggee ci ngóob, juróom yu ngeen am dingeen ci jox Firawna benn, te féetewoo ñeenti cér yi des. Su ko defee ngeen génne ci jiwuy tool yi, li ci des ngeen dunde, yeen ak seen waa kër ak seeni doom.» ");
INSERT INTO wolmbs_vpl VALUES ("GN47_25","002_47_25","GEN","47","25","25","Ñu ne ko: «Sang bi, rawale nga nu! Te gannaaw laaye nga nu biir, nangu nanoo doon jaami Firawna.» ");
INSERT INTO wolmbs_vpl VALUES ("GN47_26","002_47_26","GEN","47","26","26","Noonu la Yuusufa tërale loola, def ko dogalu yoon ca suufu Misra, te loolooy wéy ba tey jii, juróomi céri meññeef mu ne, Firawnaay moom benn ba. Waaye suufi sarxalkat ya ca bokkul, Firawna amu ca dara. ");
INSERT INTO wolmbs_vpl VALUES ("GN47_27","002_47_27","GEN","47","27","27","Bànni Israayil sanc nañu réewum Misra ca diiwaanu Gosen. Am nañu fa alal, giir fa, ba yokku lool. ");
INSERT INTO wolmbs_vpl VALUES ("GN47_28","002_47_28","GEN","47","28","28","Yanqóoba nag nekk na fukki at ak juróom ñaar ca réewum Misra, ay atam yépp tollu ci téeméer ak ñeent fukk ak juróom ñaar (147). ");
INSERT INTO wolmbs_vpl VALUES ("GN47_29","002_47_29","GEN","47","29","29","Ba nga xamee ne àppu Israayil a ngay bëgga mat, dafa woolu doomam Yuusufa ne ko: «Ngalla waay dugalal sa loxo, mu ron sama lupp, muy ngiñ ci yaw ne dinga jëflanteek man ci ngor ak worma: rikk, bu ma denc Misra. ");
INSERT INTO wolmbs_vpl VALUES ("GN47_30","002_47_30","GEN","47","30","30","Bés bu ma fekkijee samay maam, nanga ma jële Misra, denci ma ca seen xuntum bàmmeel.» Yuusufa ne ko: «Dinaa la defal li nga wax.» ");
INSERT INTO wolmbs_vpl VALUES ("GN47_31","002_47_31","GEN","47","31","31","Mu ne ko: «Giñal ma ko.» Yuusufa giñ ko, Israayil daldi sujjóot ca bopp lal ba. ");
INSERT INTO wolmbs_vpl VALUES ("GN48_1","002_48_1","GEN","48","1","1","Ba loolu wéyee ñu ne Yuusufa baayam dafa tawat, mu ànd ak ñaari doomam Manase ak Efrayim, seeti ko. ");
INSERT INTO wolmbs_vpl VALUES ("GN48_2","002_48_2","GEN","48","2","2","Ba ñu yégalee Yanqóoba ne doomam Yuusufaa koy seetsi, Israayil dafa dëgërlu, toog ca lal ba. ");
INSERT INTO wolmbs_vpl VALUES ("GN48_3","002_48_3","GEN","48","3","3","Yanqóoba ne Yuusufa: «Yàlla Buur bi feeñu woon na ma ca Lus ca réewu Kanaan, barkeel ma, ");
INSERT INTO wolmbs_vpl VALUES ("GN48_4","002_48_4","GEN","48","4","4","te wax na ma ne ma: “Dinaa la giiral, fulandi la, def la nga sos mbooloom xeet, te réew mii laay may ñi askanoo ci yaw, ñu moom ko fàww.” ");
INSERT INTO wolmbs_vpl VALUES ("GN48_5","002_48_5","GEN","48","5","5","Léegi nag sa ñaari doom yi nga am Misra, laata ma di la fekksi Misra, maa leen séddoo. Maay séddoo Efrayim ak Manase, ñuy samay doom, ni ma jure Ruben ak Simeyon. ");
INSERT INTO wolmbs_vpl VALUES ("GN48_6","002_48_6","GEN","48","6","6","Waaye doom yi nga am seen gannaaw yaa leen di féetewoo, ñuy wuyoo seen turi mag ci wàllu ndono. ");
INSERT INTO wolmbs_vpl VALUES ("GN48_7","002_48_7","GEN","48","7","7","Li tax ma def loolu mooy, bi ma jógee Padan di ñibbi, Rasel dafa faatu ca yoon wa ci sama kanam, ba nuy tollu ca réewu Kanaan, booba nu ngay dem, bay jub Efrata. Ma suul ko foofa, ca yoonu Efrata.» Efrata mooy Betleyem tey. ");
INSERT INTO wolmbs_vpl VALUES ("GN48_8","002_48_8","GEN","48","8","8","Ci kaw loolu Israayil gis doomi Yuusufa ya. Mu ne: «Ñii ñooy ñan?» ");
INSERT INTO wolmbs_vpl VALUES ("GN48_9","002_48_9","GEN","48","9","9","Yuusufa ne baayam: «Ñii ñooy sama doom, yi ma Yàlla jox fii.» Baayam ne ko: «Nañu jegesi, ma ñaanal leen.» ");
INSERT INTO wolmbs_vpl VALUES ("GN48_10","002_48_10","GEN","48","10","10","Booba bëti Israayil dafa lëndëm, ba gisatul ndax li muy mag. Yuusufa jegeñal leen seen maam, mu fóon leen, taf leen ci boppam. ");
INSERT INTO wolmbs_vpl VALUES ("GN48_11","002_48_11","GEN","48","11","11","Israayil nag ne Yuusufa: «Yaakaaruma la woona gisati, ndeke Yàlla dina ma may lu raw gis la, ndax gis naa say doom.» ");
INSERT INTO wolmbs_vpl VALUES ("GN48_12","002_48_12","GEN","48","12","12","Ca la leen Yuusufa wàccee fi ñu uufoo ci seen maam, daldi dëpp jëëm ci suuf, ");
INSERT INTO wolmbs_vpl VALUES ("GN48_13","002_48_13","GEN","48","13","13","ba noppi Yuusufa taxawal leen ñoom ñaar, ñu séq ko janook Israayil; loxol ndijooram jàpp ci Efrayim, mu féete ak càmmoñu Israayil, loxol càmmoñam jàpp ci Manase, mu féete ak ndijooru Israayil. Ñu ànd jegesi. ");
INSERT INTO wolmbs_vpl VALUES ("GN48_14","002_48_14","GEN","48","14","14","Israayil nag jàllawle ay loxoom, tàllal ndijooram, teg ko ca kaw boppu Efrayim, mi gën di ndaw; càmmoñam tege ca boppu Manase, doonte mooy taaw. ");
INSERT INTO wolmbs_vpl VALUES ("GN48_15","002_48_15","GEN","48","15","15","Ma ngay ñaanal Yuusufa te naan: «Yàlla ji samay waajur Ibraayma ak Isaaxa toppoon, moom Yàlla ji ma sàmm, ba ma juddoo ba tey jii, ");
INSERT INTO wolmbs_vpl VALUES ("GN48_16","002_48_16","GEN","48","16","16","moom Malaaka mi ma musal ci bépp loraange— yal na barkeel xale yi, ba ñu saxal sama tur ak samay turi waajur, Ibraayma ak Isaaxa, te giir, ba ne gàññ ci kaw suuf.» ");
INSERT INTO wolmbs_vpl VALUES ("GN48_17","002_48_17","GEN","48","17","17","Ba Yuusufa gisee ne baayam ca boppu Efrayim la teg loxol ndijooram, mu naqari ko, mu daldi jàpp loxol baayam, bëgg koo jële ca boppu Efrayim, teg ko ca boppu Manase. ");
INSERT INTO wolmbs_vpl VALUES ("GN48_18","002_48_18","GEN","48","18","18","Yuusufa ne baayam: «Déet, baay, ndax kii mooy taaw, tegal sa ndijoor ci boppam.» ");
INSERT INTO wolmbs_vpl VALUES ("GN48_19","002_48_19","GEN","48","19","19","Teewul baayam lànk, ne ko: «Xam naa ko, doom, xam naa ko. Moom itam dina doon aw xeet tey doon ku màgg, waaye rakkam a koy sut, te askanam dina law, ba di ay xeet.» ");
INSERT INTO wolmbs_vpl VALUES ("GN48_20","002_48_20","GEN","48","20","20","Gannaaw loolu mu ñaanal leen keroog ne leen: «Yal na Israayil di ñaane seeni tur naan: “Yal na la Yàlla def ni Efrayim ak Manase.”» Noonu la jiitale Efrayim, door caa teg Manase. ");
INSERT INTO wolmbs_vpl VALUES ("GN48_21","002_48_21","GEN","48","21","21","Ba mu ko defee Israayil ne Yuusufa: «Léegi man dinaa dee, waaye Yàlla dina ànd ak yeen, ba delloo leen ca seen réewu maam. ");
INSERT INTO wolmbs_vpl VALUES ("GN48_22","002_48_22","GEN","48","22","22","Man nag dinaa la may cér booy ëpple say doomi baay, muy suuf su ma nangoo sama saamar ak sama fitt ca Amoreen ña.» ");
INSERT INTO wolmbs_vpl VALUES ("GN49_1","002_49_1","GEN","49","1","1","Gannaaw loolu Yanqóoba woo ay doomam ne leen: «Bokkleen daje, ma xamal leen li leen di dikkal ëllëg. ");
INSERT INTO wolmbs_vpl VALUES ("GN49_2","002_49_2","GEN","49","2","2","Dajeleen te déglu ma, man Yanqóoba seen baay; teewluleen seen baay Israayil. ");
INSERT INTO wolmbs_vpl VALUES ("GN49_3","002_49_3","GEN","49","3","3","«Ruben, yaw mi ma taawloo, nga sosoo sama digg doole, sama ndoortel kàttan, yaa ëpp moos ci fulla, sut ci doole. ");
INSERT INTO wolmbs_vpl VALUES ("GN49_4","002_49_4","GEN","49","4","4","Yaa toogadi it ni ndox muy wal-wali, doo mujje sut, nde yaa tëdd sa lalu baay, ba teddadi, kera ba nga ca tëddee. ");
INSERT INTO wolmbs_vpl VALUES ("GN49_5","002_49_5","GEN","49","5","5","«Simeyon ak Lewi ñooy déeyoo yéene, ñooy nas pexey ay. ");
INSERT INTO wolmbs_vpl VALUES ("GN49_6","002_49_6","GEN","49","6","6","Yàlla bu sama xol ànd ci seeni pexe, mbaa sama xel di nangu seeni diisoo, ndax fu ñu mere, xal faa bóome, te làggal ay yëkk lañuy fowe. ");
INSERT INTO wolmbs_vpl VALUES ("GN49_7","002_49_7","GEN","49","7","7","Mbas ma seen xadar gu tar, ak seen mer mi dul meddi. Maa leen di wasaare ci kër Yanqóoba, tasaare leen ci Israayil. ");
INSERT INTO wolmbs_vpl VALUES ("GN49_8","002_49_8","GEN","49","8","8","«Yaw Yuda, mi say doomi baay di taggeji, ngay sëqi sa ndoddi noon, sëggloo leen, sa doomi baay a lay sujjóotal. ");
INSERT INTO wolmbs_vpl VALUES ("GN49_9","002_49_9","GEN","49","9","9","Yuda yaa di gaynde gu mat, doom, doora jóge nii ci pàdd, tey yuug aka goor ni gayndeg sibi. Yaa di gaynde gu deesul yee. ");
INSERT INTO wolmbs_vpl VALUES ("GN49_10","002_49_10","GEN","49","10","10","Nguur gi du jóge ci loxol njabootug Yuda, te yetu buur ay wéye sampe ciy tànkam, li feek boroom di ñëw, ba xeet yi déggal ko. ");
INSERT INTO wolmbs_vpl VALUES ("GN49_11","002_49_11","GEN","49","11","11","Mooy yeew mbaamam cig reseñ, cumbur ma féeteek car, ba ca gën; muy fóote ay yéreem biiñ, di sumb mbubbam ci ndoxum reseñ. ");
INSERT INTO wolmbs_vpl VALUES ("GN49_12","002_49_12","GEN","49","12","12","Bët yaa ngay nes-nesi ndax biiñ, bëñ ya weex furr nim soow. ");
INSERT INTO wolmbs_vpl VALUES ("GN49_13","002_49_13","GEN","49","13","13","«Sabulon ay dëkke tefesi géej, di teerub gaal yi, am réewam digalook Sidon. ");
INSERT INTO wolmbs_vpl VALUES ("GN49_14","002_49_14","GEN","49","14","14","«Isaakar mbaam ngonk la, muy goor diggante ñaari sëf. ");
INSERT INTO wolmbs_vpl VALUES ("GN49_15","002_49_15","GEN","49","15","15","Bu gisee ni mbaaram neexe, ak ni réew mi naate, day waaf, gàddu ngaaxam, daldi féetewoo coonob njaam. ");
INSERT INTO wolmbs_vpl VALUES ("GN49_16","002_49_16","GEN","49","16","16","«Dan ay àtteji xeetam, ni ko giiri Israayil baaxoo. ");
INSERT INTO wolmbs_vpl VALUES ("GN49_17","002_49_17","GEN","49","17","17","Waaye Dan ay jaan ju dog aw yoon, mbaa céebi ciw ñall, mooy màtt tànki fas, gawar jullootu. ");
INSERT INTO wolmbs_vpl VALUES ("GN49_18","002_49_18","GEN","49","18","18","«Céy Aji Sax ji, maa ngi séentu sa xettal! ");
INSERT INTO wolmbs_vpl VALUES ("GN49_19","002_49_19","GEN","49","19","19","«Gàdd la gàngoor di gaw, mu téqtal leen, ba daan. ");
INSERT INTO wolmbs_vpl VALUES ("GN49_20","002_49_20","GEN","49","20","20","«Aser ay boroom dund bu duun, mooy maye ngëneeli ñami buur. ");
INSERT INTO wolmbs_vpl VALUES ("GN49_21","002_49_21","GEN","49","21","21","«Neftalee di kéwél gu fëx, te mooy jur doom yu taaru. ");
INSERT INTO wolmbs_vpl VALUES ("GN49_22","002_49_22","GEN","49","22","22","«Yuusufaay bànqaasu garab, garab guy meññ, feggook bëtu ndox, car yaa nga law, tiim digu tool ba. ");
INSERT INTO wolmbs_vpl VALUES ("GN49_23","002_49_23","GEN","49","23","23","Ay fittkat a ko toŋal, di ko song aka fitt. ");
INSERT INTO wolmbs_vpl VALUES ("GN49_24","002_49_24","GEN","49","24","24","Teewul xalaam ga di wéye daŋ, te la loxo yay dëgërloo mooy loxoy Jàmbaar ju Yanqóoba, kookooy Sàmm bi, Doju cëslaayal Israayil, ");
INSERT INTO wolmbs_vpl VALUES ("GN49_25","002_49_25","GEN","49","25","25","mooy sa Yàllay baay, ji lay wallu, mooy Aji Man ji lay barkeele ca barkey asamaan ya fa kaw, ak barke ya ne leww ca suuf xóote ya, teg ca barkeb njur ak nàmpal. ");
INSERT INTO wolmbs_vpl VALUES ("GN49_26","002_49_26","GEN","49","26","26","Sa ñaani baay ya romb xéewali tund ya sax fàww, rombati ngëneeli jànji cosaan ya, yal na dal ci boppu Yuusufa, ca kaw ndaal boppam, moom sangub doomi baayam ya. ");
INSERT INTO wolmbs_vpl VALUES ("GN49_27","002_49_27","GEN","49","27","27","«Beñamin ay till guy yeeroo, di xëye yàpp rëbbam, tey gonloo séddale am lëlam.» ");
INSERT INTO wolmbs_vpl VALUES ("GN49_28","002_49_28","GEN","49","28","28","Ñooñu ñoo sos mboolem giiri Israayil, ñu tollu ci fukk ak ñaar, te loolu la leen seen baay wax, ba mu leen di tàggu. Ku ci nekk mu tàggoo ko kàdduy tàggatoo, ya war ca moom. ");
INSERT INTO wolmbs_vpl VALUES ("GN49_29","002_49_29","GEN","49","29","29","Gannaaw loolu da leena dénk ne leen: «Maa ngi waaja fekki samay maam; dencleen ma fa samay maam ca xuntum bàmmeel ba ca toolub Efron, Etteen ba. ");
INSERT INTO wolmbs_vpl VALUES ("GN49_30","002_49_30","GEN","49","30","30","Mooy xuntum bàmmeel ba ca biir tool ba ca Magpela, te jàkkaarloo ak Mamre ca réewu Kanaan, di tool ba Ibraayma jëndoon ca Efron, Etteen ba, ngir def ko bàmmeel. ");
INSERT INTO wolmbs_vpl VALUES ("GN49_31","002_49_31","GEN","49","31","31","Foofa lañu denc Ibraayma ak soxnaam Saarata, te foofa lañu denc Isaaxa ak soxnaam Rebeka, te fa laa denc Leya it. ");
INSERT INTO wolmbs_vpl VALUES ("GN49_32","002_49_32","GEN","49","32","32","Tool ba ak xuntum bàmmeel ba ca nekk, ñu nga ko jënde ca Etteen ña.» ");
INSERT INTO wolmbs_vpl VALUES ("GN49_33","002_49_33","GEN","49","33","33","Naka la Yanqóoba dénku doomam yu góor ya noona, daldi delloo ay tànkam ca lal ba, bakkan ba rot, mu fekki ay maamam. ");
INSERT INTO wolmbs_vpl VALUES ("GN50_1","002_50_1","GEN","50","1","1","Ba mu ko defee Yuusufa daanu ci kaw baayam. Ma ngay jooy te di ko fóon. ");
INSERT INTO wolmbs_vpl VALUES ("GN50_2","002_50_2","GEN","50","2","2","Ba loolu weesoo Yuusufa jox ay fajkatam ndigal, ñu waajal baayam. Fajkat ya waajal Israayil. ");
INSERT INTO wolmbs_vpl VALUES ("GN50_3","002_50_3","GEN","50","3","3","Waaj ma am na ñeent fukki fan, ndaxte loolooy waajal bu mat sëkk cib néew. Waa Misra nag dëjal ko juróom ñaar fukki fan. ");
INSERT INTO wolmbs_vpl VALUES ("GN50_4","002_50_4","GEN","50","4","4","Ba dëj ba weesoo, Yuusufa dafa wax ak waa kër Firawna, ñaan leen ñu dimbali ko, waxal ko Firawna ne ko, ");
INSERT INTO wolmbs_vpl VALUES ("GN50_5","002_50_5","GEN","50","5","5","baayam da ne woon, mu ngi waaja dee, waaye bàmmeel ba mu yattaloon boppam ca xunt ma ca réewu Kanaan, na ko giñal ne dina ko denc foofa. Mu ne kon, na ko Firawna may, mu robi baayam te délsi. ");
INSERT INTO wolmbs_vpl VALUES ("GN50_6","002_50_6","GEN","50","6","6","Firawna may ko, mu robi baayam, na mu ko ko giñloo woon. ");
INSERT INTO wolmbs_vpl VALUES ("GN50_7","002_50_7","GEN","50","7","7","Yuusufaa ngay dem robi baayam, moom ak mboolem jawriñi Firawna ak magi këram ak mboolem kàngami Misra. ");
INSERT INTO wolmbs_vpl VALUES ("GN50_8","002_50_8","GEN","50","8","8","Ña nga ànd ak waa kër Yuusufa gépp ak ay doomi baayam ak waa kër baayam, bàyyiwuñu diiwaanu Gosen lu moy xale ya ak gàtt ya ak jur gu gudd ga, ");
INSERT INTO wolmbs_vpl VALUES ("GN50_9","002_50_9","GEN","50","9","9","ay watiir aki gawar topp ca, ñu def gàngoor gu réy. ");
INSERT INTO wolmbs_vpl VALUES ("GN50_10","002_50_10","GEN","50","10","10","Ba ñu agsee ca dàggay Ataat ja ca wàllaa dexu Yurdan, dañu koo jooy jooy yu réy te metti. Yuusufa dëjal fa baayam diiru juróom ñaari fan. ");
INSERT INTO wolmbs_vpl VALUES ("GN50_11","002_50_11","GEN","50","11","11","Waa réewu Kanaan, gis dëj ba ca dàggay Ataat, naan: «Dëju waa Misra bii aka réy!» Moo tax ñu tudde béreb booba ca wàllaa dexu Yurdan, Abel Misra (muy firi Dëju waa Misra). ");
INSERT INTO wolmbs_vpl VALUES ("GN50_12","002_50_12","GEN","50","12","12","Doomi Yanqóoba nag def la leen seen baay dénkoon, ");
INSERT INTO wolmbs_vpl VALUES ("GN50_13","002_50_13","GEN","50","13","13","yóbbu ko ca réewu Kanaan, daldi koy rob ca xunt ma ca toolub Magpela, te Ibraayma jëndoon ko ca Efron, Etteen ba, ngir def ko bàmmeel. Mooy tool ba jàkkaarloo ak Mamre. ");
INSERT INTO wolmbs_vpl VALUES ("GN50_14","002_50_14","GEN","50","14","14","Ba Yuusufa dencee baayam ba noppi, dafa dellu Misra, moom ak doomi baayam ya ak mboolem, ña mu àndaloon ca robu baayam. ");
INSERT INTO wolmbs_vpl VALUES ("GN50_15","002_50_15","GEN","50","15","15","Magi Yuusufa ya xam nañu ne seen baay nelaw na. Ña ngay wax ca seen biir naan: «Waaw, mbaa Yuusufa dencalu nu mer, nar noo fey sunu bor ndax lu bon li nu ko ji woon lépp?» ");
INSERT INTO wolmbs_vpl VALUES ("GN50_16","002_50_16","GEN","50","16","16","Boobu lañu yóbbante Yuusufa kàddu yii, di ko wax ne ko: «Sa baay dafa noo dénkoon, bala moo nelaw, ne nu: ");
INSERT INTO wolmbs_vpl VALUES ("GN50_17","002_50_17","GEN","50","17","17","Waxleen Yuusufa ne ko, sa baay nee: “Say mag def nañu la lu bon moos, waaye ngalla baal leen seeni tooñ ak àq ji ñu la ameel.” Kon rikk waay, baal nu àq, ndax nun nook sa baay a bokk jenn Yàlla ju nuy jaamu.» Ba ñu waxee Yuusufa loolu, mu daldi jooy. ");
INSERT INTO wolmbs_vpl VALUES ("GN50_18","002_50_18","GEN","50","18","18","Ci kaw loolu magam ya ñëwal seen bopp ba ca moom, sujjóotal ko ne ko: «Sang bi, nu ngi nii, di la siyaare.» ");
INSERT INTO wolmbs_vpl VALUES ("GN50_19","002_50_19","GEN","50","19","19","Yuusufa nag ne leen: «Buleen am dara lu ngeen di ragal. Xanaa maay Yàlla? ");
INSERT INTO wolmbs_vpl VALUES ("GN50_20","002_50_20","GEN","50","20","20","Dëgg la, fexeel ngeen ma lu bon, waaye Yàllaa ko walbati, def ko lu baax, ba dogal li am tey jii, muy bakkan yu bare yi mucc. ");
INSERT INTO wolmbs_vpl VALUES ("GN50_21","002_50_21","GEN","50","21","21","Kon nag buleen tiit, dinaa leen yor, yeen ak seeni doom.» Yooyu kàddu la dalale seen xol, ba ñu am jàmm. ");
INSERT INTO wolmbs_vpl VALUES ("GN50_22","002_50_22","GEN","50","22","22","Yuusufa dëkk na Misra, moom ak waa kër baayam ñépp, ba tollu ci téeméeri atam ak fukk, ");
INSERT INTO wolmbs_vpl VALUES ("GN50_23","002_50_23","GEN","50","23","23","te gis na doomi Efrayim, ba gis sëti Efrayim sax; gis na it doomi Makir, mi Manase di baayam, te mu uuf leen bi ñu juddoo, ngir wone ne bokk nañu ci askanam. ");
INSERT INTO wolmbs_vpl VALUES ("GN50_24","002_50_24","GEN","50","24","24","Mu am bés Yuusufa ne ay bokkam: «Sama waxtu jege na, waaye Yàlla dina dikk, yéwéne leen moos, ba jële leen ci réew mii, yóbbu leen ca réew ma mu dige woon, ba giñal ko Ibraayma, Isaaxa ak Yanqóoba.» ");
INSERT INTO wolmbs_vpl VALUES ("GN50_25","002_50_25","GEN","50","25","25","Booba la Yuusufa wax doomi Israayil, ne leen: «Giñalleen ma ne bés bu Yàlla dikkee ba yéwéne leen, dingeen yóbbaale samay yax, waaye dungeen ma fi bàyyi.» ");
INSERT INTO wolmbs_vpl VALUES ("GN50_26","002_50_26","GEN","50","26","26","Gannaaw loolu Yuusufa nelaw ci téeméeri atam ak fukk. Ñu waajal néew ba, ba du yàqu, daldi koy yeb cib tàdd, denc ko foofa ca Misra. ");
INSERT INTO wolmbs_vpl VALUES ("EX1_1","003_1_1","EXO","1","1","1","Góor ñi seen baay di Yanqóoba, mi ñu dippee Israayil, ñu àndoon ak moom, dem Misra, te ku nekk yóbbaale waa këram, seeni tur a di: ");
INSERT INTO wolmbs_vpl VALUES ("EX1_2","003_1_2","EXO","1","2","2","Ruben ak Simeyon ak Lewi ak Yuda ");
INSERT INTO wolmbs_vpl VALUES ("EX1_3","003_1_3","EXO","1","3","3","ak Isaakar ak Sabulon, ak itam Beñamin; ");
INSERT INTO wolmbs_vpl VALUES ("EX1_4","003_1_4","EXO","1","4","4","ak Dan ak Neftali ak Gàdd ak Aser. ");
INSERT INTO wolmbs_vpl VALUES ("EX1_5","003_1_5","EXO","1","5","5","Góor ñi soqikoo ci Yanqóoba ñépp juróom ñaar fukk lañu (70), bu ñu ci boolee doomam, ji ñuy wax Yuusufa, moom ma ñu fekk Misra. ");
INSERT INTO wolmbs_vpl VALUES ("EX1_6","003_1_6","EXO","1","6","6","Gannaaw ga, Yuusufaaki doomi baayam yu góor yépp nelaw, ñook maas googu gépp. ");
INSERT INTO wolmbs_vpl VALUES ("EX1_7","003_1_7","EXO","1","7","7","Bànni Israayil nag giir fa, law, di fulandiwu, ba yokku lool, fees réew ma. ");
INSERT INTO wolmbs_vpl VALUES ("EX1_8","003_1_8","EXO","1","8","8","Ñu dem ba jëmmi jamono, beneen buur bu xamul Yuusufa falu ca Misra. ");
INSERT INTO wolmbs_vpl VALUES ("EX1_9","003_1_9","EXO","1","9","9","Mu wax ak waa réewam, ne leen: «Giirug bànni Israayil kat ñu ngi nuy gëna bare, ba ëpp nu doole. ");
INSERT INTO wolmbs_vpl VALUES ("EX1_10","003_1_10","EXO","1","10","10","Nanu ci sàkk pexe, ngir ñu bañatee yokku. Lu ko moy bu xare amee, man nañoo far ak sunuy noon, xeex ak nun, ba rëcc, génn réew mi.» ");
INSERT INTO wolmbs_vpl VALUES ("EX1_11","003_1_11","EXO","1","11","11","Ba loolu amee ñu fal ay nit ñu leen di ga ca seeni sas, di leen ca fitnaal lool. Noonu la bànni Israayil tabaxale Firawna buuru Misra dëkk ya ñu naa Pitom ak Ramses, mu def ko ay dencukaayi dund. ");
INSERT INTO wolmbs_vpl VALUES ("EX1_12","003_1_12","EXO","1","12","12","Terewul lu ñu leen gëna fitnaal, ñuy gën di fulandiwu, yokku, ba waa Misra am njàqare ca bànni Israayil. ");
INSERT INTO wolmbs_vpl VALUES ("EX1_13","003_1_13","EXO","1","13","13","Waa Misra dañoo mujj di duggal bànni Israayil ci njaam gu metti, ");
INSERT INTO wolmbs_vpl VALUES ("EX1_14","003_1_14","EXO","1","14","14","yen leen toskarey àddina ndax liggéey yu metti. Ñuy móol ban, di tabax, waa Misra teg ca sëf leen mboolem liggéeyu tool ya. Néegoon nañu ca ñoom lool ca mboolem liggéeyu njaam bu ñu leen sas. ");
INSERT INTO wolmbs_vpl VALUES ("EX1_15","003_1_15","EXO","1","15","15","Firawna buuru Misra teg ca wax ak rewlikati Ebrë ya, te kenn ka tuddoon Sifra, ka ca des di Puwa. ");
INSERT INTO wolmbs_vpl VALUES ("EX1_16","003_1_16","EXO","1","16","16","Mu ne leen: «Bu ngeen dee rewli jigéeni Ebrë yi, nangeen xool lu xale bi doon. Su dee góor, reyleen, su dee jigéen, bàyyileen, mu dund.» ");
INSERT INTO wolmbs_vpl VALUES ("EX1_17","003_1_17","EXO","1","17","17","Teewul rewlikat ya ragal Yàlla, ba defuñu la leen buur ba sant; xanaa ñu bàyyi liir yu góor ya, ñu dund. ");
INSERT INTO wolmbs_vpl VALUES ("EX1_18","003_1_18","EXO","1","18","18","Buuru Misra woolu rewlikat ya, ne leen: «Ana lu tax ngeen def lii, di bàyyi liir yu góor yi, ñu dund?» ");
INSERT INTO wolmbs_vpl VALUES ("EX1_19","003_1_19","EXO","1","19","19","Rewlikat ya ne ko: «Li tax kay mooy, jigéeni Ebrë yi dañoo niroowul ak jigéeni waa Misra; ndax dañoo njaxlaf, ba bu rewlikat yiy laata agsi, fekk ñu mucc ba noppi.» ");
INSERT INTO wolmbs_vpl VALUES ("EX1_20","003_1_20","EXO","1","20","20","Bànni Israayil nag di fulandiwu, gëna yokku, Yàlla defal rewlikat ya aw yiw, ");
INSERT INTO wolmbs_vpl VALUES ("EX1_21","003_1_21","EXO","1","21","21","may leen giir ndax seenug ragal Yàlla. ");
INSERT INTO wolmbs_vpl VALUES ("EX1_22","003_1_22","EXO","1","22","22","Gannaaw loolu Firawna sant waa réew ma yépp, ne leen: «Mboolem doom ju juddu ci Ebrë yi, di góor, sànnileen ca dex ga, waaye lu ciy jigéen, bàyyileen, mu dund.» ");
INSERT INTO wolmbs_vpl VALUES ("EX2_1","003_2_1","EXO","2","1","1","Jenn waay ju bokk ci giirug Lewi nag moo jëloon janq bu mu bokkal giir. ");
INSERT INTO wolmbs_vpl VALUES ("EX2_2","003_2_2","EXO","2","2","2","Ndaw sa ëmb, ba mujj am doom ju góor. Ba mu gisee taar ba liir ba àndal, mu nëbb ko lu mat ñetti weer. ");
INSERT INTO wolmbs_vpl VALUES ("EX2_3","003_2_3","EXO","2","3","3","Ba mu demee nag ba manatu koo nëbb, mu wut pañe bu ñu ràbbe barax, fatte ko godoroŋ ak ndàbb, yeb ca liir ba, daldi dem, teg ko ca biir barax ba ca tàkkal dex ga ñu naan Niil. ");
INSERT INTO wolmbs_vpl VALUES ("EX2_4","003_2_4","EXO","2","4","4","Xale bu jigéen bay magu liir ba ma nga taxaw fu soreyaatoo ak liir ba, di xool, ba xam nu muy mujje. ");
INSERT INTO wolmbs_vpl VALUES ("EX2_5","003_2_5","EXO","2","5","5","Ba mu ko defee doomu Firawna ju jigéen dikk, di sangusi ca dexu Niil ga, mbindaanam yay doxantu ca tàkk ga. Noonu mu séen pañe ba ca biir barax ba, daldi yónni mbindaanam, mu yót ko ko. ");
INSERT INTO wolmbs_vpl VALUES ("EX2_6","003_2_6","EXO","2","6","6","Naka la ko ne ubbet, yem ca xale ba, muy liir bu góor, xale bay jooy; yaram wa daw, mu ne: «Kii de ndeysaan, ci doomi Ebrë yi la!» ");
INSERT INTO wolmbs_vpl VALUES ("EX2_7","003_2_7","EXO","2","7","7","Magu liir ba daldi ne ko: «Ndax ma dem wutali la ku koy nàmpal ci Ebrë yi?» ");
INSERT INTO wolmbs_vpl VALUES ("EX2_8","003_2_8","EXO","2","8","8","Mu ne ko: «Waaw, demal.» Xale ba dem, indil ko yaayu liir ba. ");
INSERT INTO wolmbs_vpl VALUES ("EX2_9","003_2_9","EXO","2","9","9","Doomu Firawna ne ko: «Yóbbul xale bii te nàmpalal ma ko, maa lay fey.» Ndaw sa jël liir ba, di ko nàmpal. ");
INSERT INTO wolmbs_vpl VALUES ("EX2_10","003_2_10","EXO","2","10","10","Ba xale ba màggee, mu yót ko doomu Firawna, mu def ko muy doomam, tudde ko Musaa (muy firi Ki ñu génne), ndax la mu ko génnee ca ndox ma. ");
INSERT INTO wolmbs_vpl VALUES ("EX2_11","003_2_11","EXO","2","11","11","Ba ñu demee ba Musaa màgg, dafa am bés, mu seeti bokkam ya, gis leen ca liggéey yu metti ya ñu leen sas. Mu gis jenn waayu Misra di dóor kenn ca bokki Ebrë ya. ");
INSERT INTO wolmbs_vpl VALUES ("EX2_12","003_2_12","EXO","2","12","12","Musaa geestu wet gu nekk, gisul kenn, mu rey waa Misra ja, daldi gas, suul ko. ");
INSERT INTO wolmbs_vpl VALUES ("EX2_13","003_2_13","EXO","2","13","13","Ca ëllëg sa mu dellu génn, yem ci ñaari Ebrë yuy xeex. Musaa wax ak ka tooñ, ne ko: «Lu tax ngay dóor sa moroom mii?» ");
INSERT INTO wolmbs_vpl VALUES ("EX2_14","003_2_14","EXO","2","14","14","Waa ja ne ko: «Ku la def kilifa mbaa àttekat ci sunu kaw? Xanaa danga maa nara rey, na nga reye woon waayi Misra ja?» Musaa nag tiit, naan ca xelam: «Ndeke mbir mi kay siiw na.» ");
INSERT INTO wolmbs_vpl VALUES ("EX2_15","003_2_15","EXO","2","15","15","Ba loolu amee Firawna dégg mbir ma, di wuta reylu Musaa. Musaa daw, ba sore Firawna, dem dali fu dend ak ab teen, ca réewu Majan. ");
INSERT INTO wolmbs_vpl VALUES ("EX2_16","003_2_16","EXO","2","16","16","Yettro, sarxalkatu Majan ba nag, amoon na juróom ñaari doom yu jigéen. Ñu ñëw di rootsi, di duy mbalka ya ñuy wëgge seen juru baay. ");
INSERT INTO wolmbs_vpl VALUES ("EX2_17","003_2_17","EXO","2","17","17","Ay sàmm agsi, dàq leen. Musaa wallu jigéen ña, wëggal leen seen jur. ");
INSERT INTO wolmbs_vpl VALUES ("EX2_18","003_2_18","EXO","2","18","18","Ba ñu delloo ca seen baay Ruwel, mu laaj leen ne leen: «Lu tax ngeen teela ñibbisi tey?» ");
INSERT INTO wolmbs_vpl VALUES ("EX2_19","003_2_19","EXO","2","19","19","Ñu ne ko: «Ab waa Misra daal, moo nu xettali ca sàmm ya; rootal na nu sax, ba wëgg jur gi.» ");
INSERT INTO wolmbs_vpl VALUES ("EX2_20","003_2_20","EXO","2","20","20","Ruwel ne leen: «Ana waa ja? Lu tax ngeen bàyyi ko fa? Woowileen ko, mu añsi kay!» ");
INSERT INTO wolmbs_vpl VALUES ("EX2_21","003_2_21","EXO","2","21","21","Musaa far dal ca kër waa ja. Mu mujj ko may doomam ju ñuy wax Cipora. ");
INSERT INTO wolmbs_vpl VALUES ("EX2_22","003_2_22","EXO","2","22","22","Mu am doom ju góor, Musaa tudde ko Gersom (muy firi Doxandéem fii), ndaxte dafa ne: «Doxandéem laa fii.» ");
INSERT INTO wolmbs_vpl VALUES ("EX2_23","003_2_23","EXO","2","23","23","Ba ñu demee ba mu yàgg, Firawna buuru Misra dee. Fekk na bànni Israayil a ngay binni rekk ndax seen njaam ga. Ñuy woote wall, ba seen jooy ya sababoo ca seen toroxteg njaam ga, àgg fa Yàlla. ");
INSERT INTO wolmbs_vpl VALUES ("EX2_24","003_2_24","EXO","2","24","24","Booba Yàllaa ngay dégg seeni yuux, te fàttewul kóllëre ga mu fasoon ak Ibraayma ak Isaaxa ak Yanqóoba. ");
INSERT INTO wolmbs_vpl VALUES ("EX2_25","003_2_25","EXO","2","25","25","Yàlla nag geesu bànni Israayil, ñeewante leen. ");
INSERT INTO wolmbs_vpl VALUES ("EX3_1","003_3_1","EXO","3","1","1","Aji Sax ji yónni na Musaa ca Yettro, sarxalkatu Majan ba. Mu yóbbu jur ga fu sore ca màndiŋ ma, daldi agsi ca suufu tundu Yàlla wa ca Xoreb. ");
INSERT INTO wolmbs_vpl VALUES ("EX3_2","003_3_2","EXO","3","2","2","Malaakam Aji Sax ja feeñoo ko foofa, melow sawara wuy tàkk, jafal fa ab gajj. Musaa xool, ndeke gajj ba bépp jàpp na, ba ne jippét, waaye lakkul. ");
INSERT INTO wolmbs_vpl VALUES ("EX3_3","003_3_3","EXO","3","3","3","Musaa ne: «Mbir mu yéeme mii daal, naa jàdd xool ko, ba xam lu tax gajj bi lakkul.» ");
INSERT INTO wolmbs_vpl VALUES ("EX3_4","003_3_4","EXO","3","4","4","Ba Aji Sax ji Yàlla gisee Musaa jàdd, di xoolsi, mu àddoo ca gajj ba, ne ko: «Musaa, Musaa!» Mu ne ko: «Maa ngii.» ");
INSERT INTO wolmbs_vpl VALUES ("EX3_5","003_3_5","EXO","3","5","5","Yàlla ne ko: «Bul jegesi, summil say dàll, ndax fii nga taxaw suuf su sell la.» ");
INSERT INTO wolmbs_vpl VALUES ("EX3_6","003_3_6","EXO","3","6","6","Mu teg ca ne: «Man maay sa Yàllay baay, di Yàllay Ibraayma, di Yàllay Isaaxa te di Yàllay Yanqóoba.» Ca la Musaa nëbb kanam ga, ndax ragala xool Yàlla. ");
INSERT INTO wolmbs_vpl VALUES ("EX3_7","003_3_7","EXO","3","7","7","Aji Sax ji tegaat ca ne ko: «Gis naa bu baax fitna ji sama ñoñ nekke Misra. Dégg naa itam seen jooy ndax kilifay saskat yi leen di gétën ci liggéey, te ñeewante naa leen ngir seen coono. ");
INSERT INTO wolmbs_vpl VALUES ("EX3_8","003_3_8","EXO","3","8","8","Damaa wàcc, xettalisi leen ci waa Misra; génne leen réew moomu, ba yóbbu leen réew mu baax te yaatu, réew mu meew maak lem ja tuuroo, foofa ca diiwaanu Kanaaneen ña ak Etteen ña ak Amoreen ña ak Periseen ña ak Eween ña ak Yebuseen ña. ");
INSERT INTO wolmbs_vpl VALUES ("EX3_9","003_3_9","EXO","3","9","9","Yuux, yi bànni Israayil nekke nii, agsi na ba ci man, te gis naa it ni leen waa Misra di noote. ");
INSERT INTO wolmbs_vpl VALUES ("EX3_10","003_3_10","EXO","3","10","10","Kon nag kaay, ma yónni la ca Firawna. Demal yiwiji bànni Israayil, sama ñoñ, ñu génn Misra.» ");
INSERT INTO wolmbs_vpl VALUES ("EX3_11","003_3_11","EXO","3","11","11","Musaa ne Yàlla: «Waaw, waaye man tekkiwuma dara, bay dem ca Firawna, di génne bànni Israayil Misra.» ");
INSERT INTO wolmbs_vpl VALUES ("EX3_12","003_3_12","EXO","3","12","12","Mu ne ko: «Man déy, maay ànd ak yaw, te boo génnee mbooloo ma Misra, dingeen ma jaamusi ci tund wii. Loolooy firndeel ne, maa la yónni.» ");
INSERT INTO wolmbs_vpl VALUES ("EX3_13","003_3_13","EXO","3","13","13","Musaa ne Yàlla: «Su ma demee ca bànni Israayil, ne leen seen Yàllay maam ya moo ma yónni ca ñoom bànni Israayil de, dinañu ma laaj nu mu tudd. Lu ma leen di wax nag?» ");
INSERT INTO wolmbs_vpl VALUES ("EX3_14","003_3_14","EXO","3","14","14","Yàlla ne Musaa: «Maay Ki nekk. Kon waxal bànni Israayil ne leen: “Aji Nekk ji moo ma yónni ci yeen.”» ");
INSERT INTO wolmbs_vpl VALUES ("EX3_15","003_3_15","EXO","3","15","15","Yàlla dellu ne Musaa: «Dangay wax bànni Israayil, ne leen: “Aji Sax ji, seen Yàllay maam ya, di Yàllay Ibraayma, di Yàllay Isaaxa te di Yàllay Yanqóoba, moo ma yónni ci yeen.” Aji Sax jee di sama tur wu sax dàkk, ñu di ma ko fàttalikoo ba fàww. ");
INSERT INTO wolmbs_vpl VALUES ("EX3_16","003_3_16","EXO","3","16","16","Demal woo magi Israayil, ñu daje, nga ne leen: “Aji Sax ji, seen Yàllay maam ya, di Yàllay Ibraayma ak Isaaxa ak Yanqóoba, moo ma feeñu, ne ma: ‘Gis naa leen, te yég naa li ñu leen di teg ci Misra.’ ");
INSERT INTO wolmbs_vpl VALUES ("EX3_17","003_3_17","EXO","3","17","17","Nee leen: ‘Dogu naa leena jële ci seen nootaange gii ngeen nekke ci Misra, yóbbu leen ca réewum Kanaaneen ña ak Etteen ña ak Amoreen ña ak Periseen ña ak Eween ña ak Yebuseen ña, réew mu meew maak lem ja tuuroo.’” ");
INSERT INTO wolmbs_vpl VALUES ("EX3_18","003_3_18","EXO","3","18","18","«Magi Israayil dinañu la déggal, su ko defee nga ànd ak ñoom, dem ca buuru Misra. Waxleen ko ne ko: “Aji Sax ji Yàllay Ebrë yi moo nu feeñu. Kon nag ngalla may nu, nu dem topp màndiŋ mi lu mat doxub ñetti fan, ngir rendili sunu Yàlla Aji Sax ji ay sarax.” ");
INSERT INTO wolmbs_vpl VALUES ("EX3_19","003_3_19","EXO","3","19","19","Waaye man xam naa ne buuru Misra du leen bàyyi, ngeen dem, mbete mu taseek doole ju ko tiiñ. ");
INSERT INTO wolmbs_vpl VALUES ("EX3_20","003_3_20","EXO","3","20","20","Moo tax maay xàcc sama loxo, ba dumaa waa Misra ay mbugali mbugal yu kéemaane yu may def ci seen biir. Su ko defee dina leen bàyyi, ngeen dem. ");
INSERT INTO wolmbs_vpl VALUES ("EX3_21","003_3_21","EXO","3","21","21","Maay dogal sax waa Misra yéwéne mbooloo mii, ba keroog bu ngeen di dem, dungeen deme loxoy neen. ");
INSERT INTO wolmbs_vpl VALUES ("EX3_22","003_3_22","EXO","3","22","22","Képp kuy jigéen ci bànni Israayil, na laaj dëkkandoom, laajaale ku dëkk ak dëkkandoom, ay gànjari xaalis, ak gànjari wurus, ak yére yu ngeen di solal seen doom yu góor ak yu jigéen, ba waa Misra ne duŋŋ.» ");
INSERT INTO wolmbs_vpl VALUES ("EX4_1","003_4_1","EXO","4","1","1","Gannaaw loolu Musaa dellu wax Aji Sax ji, ne ko: «Waaw, su ñu ma dégluwul te gëmuñu ma, xanaa ne ma: “Aji Sax ji feeñuwu la” nag?» ");
INSERT INTO wolmbs_vpl VALUES ("EX4_2","003_4_2","EXO","4","2","2","Aji Sax ji ne ko: «Li ci sa loxo lu mu doon?» Mu ne ko: «Aw yet.» ");
INSERT INTO wolmbs_vpl VALUES ("EX4_3","003_4_3","EXO","4","3","3","Aji Sax ji ne ko: «Sànni ko ci suuf.» Mu sànni yet wa ca suuf, mu soppaliku jaan. Musaa dellu gannaaw. ");
INSERT INTO wolmbs_vpl VALUES ("EX4_4","003_4_4","EXO","4","4","4","Aji Sax ji ne ko: «Tàllalal sa loxo, jàpp ci geen gi.» Musaa tàllal loxo ba, ne nikk jaan ja, mu dellu di aw yet ca loxoom. ");
INSERT INTO wolmbs_vpl VALUES ("EX4_5","003_4_5","EXO","4","5","5","Aji Sax ji ne ko: «Loolu ngay def, ngir ñu gëm ne Aji Sax ji seen Yàllay maam ya, di Yàllay Ibraayma, di Yàllay Isaaxa te di Yàllay Yanqóoba, moo la feeñu ci lu wér.» ");
INSERT INTO wolmbs_vpl VALUES ("EX4_6","003_4_6","EXO","4","6","6","Aji Sax ji dellooti ne ko: «Léegi dugalal sa loxo ci sa biir mbubb, teg ko ci sa dënn.» Musaa dugal loxoom, teg ko ca dënnam; ba mu ko génnee, mu defi àkk, xobbiku. ");
INSERT INTO wolmbs_vpl VALUES ("EX4_7","003_4_7","EXO","4","7","7","Aji Sax ji ne ko: «Dellool sa loxo ci sa dënn.» Musaa delloo loxo ba ca dënn ba, génnewaat ko, mu dellu mel ni yaramam. ");
INSERT INTO wolmbs_vpl VALUES ("EX4_8","003_4_8","EXO","4","8","8","Mu ne ko: «Bu ñu la gëmul mbaa ñu baña seet ci firnde ju njëkk ji, dinañu gëm ndax firnde ji ci topp. ");
INSERT INTO wolmbs_vpl VALUES ("EX4_9","003_4_9","EXO","4","9","9","Waaye su lenn ci ñaari firnde yi taxul ñu gëm, te déggaluñu la, nanga tanqe ndox ci dexu Niil gi, tuur ko ci suuf su wow si, su ko defee ndox, ma nga tanqe ca dex ga, day soppaliku deret ci suuf si.» ");
INSERT INTO wolmbs_vpl VALUES ("EX4_10","003_4_10","EXO","4","10","10","Musaa nag ne Aji Sax ji: «Da di, Boroom bi, man naka jekk duma nitu waxkat, du démb, du tey jii ngay wax ak man. Dama di ku leeb, Sang bi, te tëlee wax.» ");
INSERT INTO wolmbs_vpl VALUES ("EX4_11","003_4_11","EXO","4","11","11","Aji Sax ji ne ko: «Ku sàkkal nit gémmiñ? Kan mooy luuwal, di tëxal, di gisal mbaa muy gumbaal? Xanaa du man Aji Sax ji? ");
INSERT INTO wolmbs_vpl VALUES ("EX4_12","003_4_12","EXO","4","12","12","Demal rekk, man maay ànd ak yaw booy wax, di la xamal li ngay wax.» ");
INSERT INTO wolmbs_vpl VALUES ("EX4_13","003_4_13","EXO","4","13","13","Teewul Musaa ne ko: «Ngalla waay, yónnil keneen ku la soob rekk, sama Boroom.» ");
INSERT INTO wolmbs_vpl VALUES ("EX4_14","003_4_14","EXO","4","14","14","Aji Sax ji nag mer ba fees ndax Musaa. Mu ne ko: «Sa mag Aaróona, Leween bi, da fee nekkul? Moom, xam naa ne ku mana wax la. Mu ngi lay gatandusi sax, te bu la gisee, bég. ");
INSERT INTO wolmbs_vpl VALUES ("EX4_15","003_4_15","EXO","4","15","15","Nanga wax ak moom, digal ko li mu wara wax. Man maay ànd ak yeen, yaak moom, saa yu ngeen dee wax, te maa leen di xamal, yeen ñaar, li ngeen wara def. ");
INSERT INTO wolmbs_vpl VALUES ("EX4_16","003_4_16","EXO","4","16","16","Na lay waxal ak mbooloo mi; su ko defee sa kàddu di kàddoom, te yaw nga mel ci moom ni Yàlla. ");
INSERT INTO wolmbs_vpl VALUES ("EX4_17","003_4_17","EXO","4","17","17","Yóbbaaleel yet wii nag, ndax ci ngay defe firnde yi.» ");
INSERT INTO wolmbs_vpl VALUES ("EX4_18","003_4_18","EXO","4","18","18","Musaa nag dellu ca goroom Yettro, ne ko: «May ma, ma dellu Misra, seeti samay bokk, ba xam nu ñu def.» Yettro ne ko: «Demal ak jàmm.» ");
INSERT INTO wolmbs_vpl VALUES ("EX4_19","003_4_19","EXO","4","19","19","Ci biir loolu Aji Sax ji wax ak Musaa ca Majan, ne ko: «Dellul Misra, ndaxte ña la doon wuta rey ñépp dee nañu.» ");
INSERT INTO wolmbs_vpl VALUES ("EX4_20","003_4_20","EXO","4","20","20","Musaa ànd ak soxnaam ak doomam yu góor, waral leen mbaam. Ma ngay dellu Misra, jàpp yetu Yàlla wa ca loxo ba, yóbbaale. ");
INSERT INTO wolmbs_vpl VALUES ("EX4_21","003_4_21","EXO","4","21","21","Aji Sax ji ne ko: «Keroog boo delloo Misra, nanga taxaw temm, te def ca kanam Firawna kéemaan yi ma teg ci sa loxo yépp. Man maay dëgëral boppam, mu të ba du bàyyi mbooloo mi, ñu dem. ");
INSERT INTO wolmbs_vpl VALUES ("EX4_22","003_4_22","EXO","4","22","22","Su ko defee nga wax Firawna, ne ko: “Aji Sax ji dafa wax ne: Israayil mooy sama taaw bu góor. ");
INSERT INTO wolmbs_vpl VALUES ("EX4_23","003_4_23","EXO","4","23","23","Te wax naa la ne la, nga bàyyi sama doom, ndax mu man maa jaamu, nga bañ. Kon nag dinaa rey sa taaw bu góor.”» ");
INSERT INTO wolmbs_vpl VALUES ("EX4_24","003_4_24","EXO","4","24","24","Ba ñu lalee panaan ca yoon wa, Aji Sax ji dafa dogale Musaa, nar koo rey. ");
INSERT INTO wolmbs_vpl VALUES ("EX4_25","003_4_25","EXO","4","25","25","Soxnaam Cipora jël paaka bu ñu yatte doj, dog mbuñukam doomam, laalale ko ca tànkam, ne ko: «Jëkkër ju ñuy jote deret de laa am.» ");
INSERT INTO wolmbs_vpl VALUES ("EX4_26","003_4_26","EXO","4","26","26","Ba loolu amee Aji Sax ji bàyyi Musaa. Ba Cipora di wax lu jëm ci jëkkër ju ñuy jote deret, aaday xarafal gaa taxoon. ");
INSERT INTO wolmbs_vpl VALUES ("EX4_27","003_4_27","EXO","4","27","27","Ci biir loolu Aji Sax ji wax Aaróona ne ko: «Demal gatanduji Musaa ca màndiŋ ma.» Aaróona dem seeti ko ca tundu Yàlla wa, fekk ko fa, taf ko ca kawam. ");
INSERT INTO wolmbs_vpl VALUES ("EX4_28","003_4_28","EXO","4","28","28","Musaa xamal ko la ko Aji Sax ji dénk lépp, ak mboolem firnde, ya mu ko sant mu def ko. ");
INSERT INTO wolmbs_vpl VALUES ("EX4_29","003_4_29","EXO","4","29","29","Ci kaw loolu Musaa ak Aaróona agsi Misra. Ñu woo magi bànni Israayil yépp, ñu daje. ");
INSERT INTO wolmbs_vpl VALUES ("EX4_30","003_4_30","EXO","4","30","30","Aaróona jottali leen kàddu ya Aji Sax ji wax Musaa yépp, ba noppi mu wone firnde ya ca kanam mbooloo ma, ");
INSERT INTO wolmbs_vpl VALUES ("EX4_31","003_4_31","EXO","4","31","31","ba mbooloo ma gëm. Ba magi Israayil déggee ne Aji Sax ji nemmiku na bànni Israayil te gis na nootaange gi ñu nekke, dañoo sujjóot, màggal Aji Sax ji. ");
INSERT INTO wolmbs_vpl VALUES ("EX5_1","003_5_1","EXO","5","1","1","Gannaaw loolu Musaa ak Aaróona dem ca Firawna, ne ko: «Aji Sax ji Yàllay Israayil dafa wax ne: Bàyyil sama ñoñ, ñu dem màggali ma ca màndiŋ ma.» ");
INSERT INTO wolmbs_vpl VALUES ("EX5_2","003_5_2","EXO","5","2","2","Firawna ne: «Kan mooy Aji Sax ji, ba ma di ko déggal, di bàyyi Israayil, ñuy dem? Xawma sax kuy Aji Sax ji, waxumalaa may bàyyi Israayil, ñuy dem.» ");
INSERT INTO wolmbs_vpl VALUES ("EX5_3","003_5_3","EXO","5","3","3","Ñu ne ko: «Sunu Yàlla, nun Ebrë yi, moo nu feeñu. Ngalla may nu, nu dem topp màndiŋ mi lu mat doxub ñetti fan, ngir rendili sunu Yàlla Aji Sax ji sarax, lu ko moy mu dumaa nu jàngoro mbaa ab xare.» ");
INSERT INTO wolmbs_vpl VALUES ("EX5_4","003_5_4","EXO","5","4","4","Buuru Misra ne leen: «Yeen Musaa ak Aaróona, lu waral ngeen di jële mbooloo mi ci seeni liggéey? Laggleen ca seeni sas waay!» ");
INSERT INTO wolmbs_vpl VALUES ("EX5_5","003_5_5","EXO","5","5","5","Firawna dellu ne: «Baadoolo yi ne xas tey ci réew mi, ngeen nar leena dëdduloo seeni sas!» ");
INSERT INTO wolmbs_vpl VALUES ("EX5_6","003_5_6","EXO","5","6","6","Keroog ca bés ba la Firawna sant saskati liggéey yaak farbay ngàllo ga jiite jaam ya, ne leen: ");
INSERT INTO wolmbs_vpl VALUES ("EX5_7","003_5_7","EXO","5","7","7","«Buleen defati na woon, di jox mbooloo mi boob bu ñuy móole. Gannaaw-si-tey nañu dem wutal seen bopp boob. ");
INSERT INTO wolmbs_vpl VALUES ("EX5_8","003_5_8","EXO","5","8","8","Waaye sasleen leen limu móol, ya ñu daan móol naka jekk. Buleen ko wàññi, ndax ay yaafus lañu; moo leen tax di dee-deeluy waxéey naan: “May nu, nu dem rendili sunu Yàlla sarax!” ");
INSERT INTO wolmbs_vpl VALUES ("EX5_9","003_5_9","EXO","5","9","9","Nañu leen yen liggéey bu gëna metti, te ñu dëkke ko, ba duñu tala déglu ay feni neen.» ");
INSERT INTO wolmbs_vpl VALUES ("EX5_10","003_5_10","EXO","5","10","10","Ba mu ko defee saskati liggéey ya ak farbay ngàllo ga génn, wax ak mbooloo ma, ne leen: «Firawna nee na, du moo leen di jox boob. ");
INSERT INTO wolmbs_vpl VALUES ("EX5_11","003_5_11","EXO","5","11","11","Yeena wara wutal seen bopp boob ak fu ngeen ko mana ame, te du tax lenn teggiku ci seen liggéey.» ");
INSERT INTO wolmbs_vpl VALUES ("EX5_12","003_5_12","EXO","5","12","12","Fa la mbooloo ma tasaaroo ca biir réewum Misra, di wut boob. ");
INSERT INTO wolmbs_vpl VALUES ("EX5_13","003_5_13","EXO","5","13","13","Saskati liggéey ya nag di leen soññ, naan leen: «Matalleen seen sasu bëccëg bu nekk, ni ngeen ko daan matale, ba boob amee.» ");
INSERT INTO wolmbs_vpl VALUES ("EX5_14","003_5_14","EXO","5","14","14","Ñuy dóor farbay ngàllo, ga bokk ca bànni Israayil, te saskati liggéey yu Firawna fal leen ngir ñuy jiite bànni Israayil ca liggéey ba. Ña nga leen naan: «Lu waral démb ak tey yépp mataluleen limu móol yi ñu leen sas, te ngeen daan ko matal?» ");
INSERT INTO wolmbs_vpl VALUES ("EX5_15","003_5_15","EXO","5","15","15","Booba la farbay ngàllog Israayil, dem jooytuji ca Firawna, ne ko: «Sang bi, lu tax nga def nu nii? ");
INSERT INTO wolmbs_vpl VALUES ("EX5_16","003_5_16","EXO","5","16","16","Du menn mboob mu ñu nu joxati, te teewul ñu di nu sant nuy móol, di nu ci dóor. Te kat sang bi, sa waa réew a tooñ.» ");
INSERT INTO wolmbs_vpl VALUES ("EX5_17","003_5_17","EXO","5","17","17","Firawna ne leen: «Yaafus yi ngeen doon! Yaafus a leen tax di wax naan: “May nu, nu dem rendili Aji Sax ji sarax.” ");
INSERT INTO wolmbs_vpl VALUES ("EX5_18","003_5_18","EXO","5","18","18","Neleen mott, liggéeyi! Du menn mboob mu ñu leen di jox. Te du tee ngeen matal seen limu móol.» ");
INSERT INTO wolmbs_vpl VALUES ("EX5_19","003_5_19","EXO","5","19","19","Farbay ngàllo ga bokk ca bànni Israayil nag xam ne dal nañu aw sas, ndax la ñu leen ne duñu wàññi lenn ca limu móol ya leen war bés bu nekk. ");
INSERT INTO wolmbs_vpl VALUES ("EX5_20","003_5_20","EXO","5","20","20","Ba loolu amee ñu bàyyikoo ca Firawna, daldi yem ca Musaak Aaróona, fa ñu leen doon xaar. ");
INSERT INTO wolmbs_vpl VALUES ("EX5_21","003_5_21","EXO","5","21","21","Farba ya ne leen: «Yal na leen Aji Sax ji gis ba mbugal leen, ndax tax ngeen Firawnaaki dagam jéppi nu, te mel na ni yeena teg ci seeni loxo saamar, bi ñu nuy reye.» ");
INSERT INTO wolmbs_vpl VALUES ("EX5_22","003_5_22","EXO","5","22","22","Musaa dégg loolu, dellu ci Aji Sax ji, ne ko: «Éey Boroom bi, loraange gi nga yóbbe mbooloo mii nag? Loo ma doon yónnee? ");
INSERT INTO wolmbs_vpl VALUES ("EX5_23","003_5_23","EXO","5","23","23","Ba ma demee ca Firawna, di wax ci sa tur ba tey, mu ngi lor bànni Israayil, sa ñoñ, te xettaliwoo leen sax!» ");
INSERT INTO wolmbs_vpl VALUES ("EX6_1","003_6_1","EXO","6","1","1","Aji Sax ji wax Musaa ne ko: «Dinga gis léegi ni may def Firawna: loxo bu ko ëpp dooleey tax mu bàyyi leen ñu dem. Bir na ne, loxo bu ko ëpp doole mooy tax mu dàq leen réewam.» ");
INSERT INTO wolmbs_vpl VALUES ("EX6_2","003_6_2","EXO","6","2","2","Yàlla dellu wax Musaa ne ko: «Man maay Aji Sax ji. ");
INSERT INTO wolmbs_vpl VALUES ("EX6_3","003_6_3","EXO","6","3","3","Yàlla Aji Man ji, mooy ni ma feeñoo woon Ibraayma, te ni laa feeñoo Isaaxa ak Yanqóoba it, waaye sama tur, Aji Sax ji, leeraluma leen ko woon. ");
INSERT INTO wolmbs_vpl VALUES ("EX6_4","003_6_4","EXO","6","4","4","Te itam damaa fasoon ak ñoom kóllëre, ngir jox leen réewum Kanaan, réew ma ñu nekkoon ay doxandéem. ");
INSERT INTO wolmbs_vpl VALUES ("EX6_5","003_6_5","EXO","6","5","5","Maa déggal sama bopp yuuxi bànni Israayil gi waa Misra def ay jaam, te fàttewuma sama kóllëre ga. ");
INSERT INTO wolmbs_vpl VALUES ("EX6_6","003_6_6","EXO","6","6","6","Kon nag waxal bànni Israayil ne leen: “Man maay Aji Sax ji. Maa leen di sippil, yeen bànni Israayil, li leen waa Misra sëf, te maa leen di teggil njaam gi ñu leen teg. Maay tàllal sama loxo, dogal mbugal yu kéemaane, ba jot leen. ");
INSERT INTO wolmbs_vpl VALUES ("EX6_7","003_6_7","EXO","6","7","7","Maa leen di def sama ñoñ, di seen Yàlla. Dingeen xam ne man Aji Sax ji maay seen Yàlla ji leen di teggil sas yi leen waa Misra teg. ");
INSERT INTO wolmbs_vpl VALUES ("EX6_8","003_6_8","EXO","6","8","8","Maa leen di yóbbu ba ngeen dugg réew ma ma giñoon ne maa koy jox Ibraayma ak Isaaxa ak Yanqóoba, te maa leen koy moomale, man Aji Sax ji.”» ");
INSERT INTO wolmbs_vpl VALUES ("EX6_9","003_6_9","EXO","6","9","9","Ba Musaa waxee loolu bànni Israayil, dégluwuñu ko sax ndax xol bu jeex ak njaam gu metti. ");
INSERT INTO wolmbs_vpl VALUES ("EX6_10","003_6_10","EXO","6","10","10","Aji Sax ji wax Musaa ne ko: ");
INSERT INTO wolmbs_vpl VALUES ("EX6_11","003_6_11","EXO","6","11","11","«Demal wax Firawna buuru Misra, mu bàyyi bànni Israayil, ñu génn réewam.» ");
INSERT INTO wolmbs_vpl VALUES ("EX6_12","003_6_12","EXO","6","12","12","Musaa tinu Aji Sax ji ne ko: «Waaw, ndegam bànni Israayil sax nanguwuñu maa déglu, nu ma Firawna di déggale, man mii tëlee wax?» ");
INSERT INTO wolmbs_vpl VALUES ("EX6_13","003_6_13","EXO","6","13","13","Aji Sax ji nag wax ak Musaa ak Aaróona, jox leen ay ndigal ci mbirum bànni Israayil ak Firawna buuru Misra, ngir ñu yiwi bànni Israayil, ba ñu génn Misra. ");
INSERT INTO wolmbs_vpl VALUES ("EX6_14","003_6_14","EXO","6","14","14","Bànni Israayil ya yilifoon seen kër baay, ñoo di ñii: Góor ña Ruben, taawu Israayil, jur, di Enog ak Palu ak Esron ak Karmi. Ñooñoo sos làngi Ruben. ");
INSERT INTO wolmbs_vpl VALUES ("EX6_15","003_6_15","EXO","6","15","15","Doomi Simeyon yu góor di Yemuwel ak Yamin ak Owàdd ak Yakin ak Cowar ak Sawul, mi ndeyam dib Kanaaneen. Ñooñoo sos làngi Simeyon. ");
INSERT INTO wolmbs_vpl VALUES ("EX6_16","003_6_16","EXO","6","16","16","Doomi Lewi yu góor ñoo di Gerson ak Keyat ak Merari, ku nekk ak askanam. At ya Lewi dund, téeméer la ak fanweer ak juróom ñaar (137). ");
INSERT INTO wolmbs_vpl VALUES ("EX6_17","003_6_17","EXO","6","17","17","Doomi Gerson yu góor ñoo di Libni ak Simey, ñook seeni làng. ");
INSERT INTO wolmbs_vpl VALUES ("EX6_18","003_6_18","EXO","6","18","18","Doomi Keyat yu góor ñoo di Amram ak Iccar ak Ebron ak Usyel; te at ya Keyat dund, téeméer la ak fanweer ak ñett (133). ");
INSERT INTO wolmbs_vpl VALUES ("EX6_19","003_6_19","EXO","6","19","19","Doomi Merari yu góor ñoo di Maxli ak Musi. Ñooñoo sos làngi Lewi ak seeni giir. ");
INSERT INTO wolmbs_vpl VALUES ("EX6_20","003_6_20","EXO","6","20","20","Amram moo jël bàjjanam Yokebedd soxna, kooku am ak moom Aaróona ak Musaa. At, ya Amram dund, téeméer la ak fanweer ak juróom ñaar (137). ");
INSERT INTO wolmbs_vpl VALUES ("EX6_21","003_6_21","EXO","6","21","21","Doomi Iccar yu góor ñoo di Kore ak Nefeg ak Sikkri. ");
INSERT INTO wolmbs_vpl VALUES ("EX6_22","003_6_22","EXO","6","22","22","Doomi Usyel yu góor di Misayel ak Elcafan ak Sitiri. ");
INSERT INTO wolmbs_vpl VALUES ("EX6_23","003_6_23","EXO","6","23","23","Aaróona moo jël Eliseba doomu Aminadab, jigéenub Naason. Kooku am ak moom Nadab ak Abiyu ak Elasar ak Itamar. ");
INSERT INTO wolmbs_vpl VALUES ("EX6_24","003_6_24","EXO","6","24","24","Doomi Kore yu góor ñoo di Asir ak Elkana ak Abyasaf. Ñooñoo sos làngi Kore. ");
INSERT INTO wolmbs_vpl VALUES ("EX6_25","003_6_25","EXO","6","25","25","Elasar doomu Aaróona moom, moo jël soxna kenn ca doomi Putiyel, kooku am ak moom Fineyas. Ñooñoo yilif seeni kër baay ca Leween ña, ku nekk sos làngam. ");
INSERT INTO wolmbs_vpl VALUES ("EX6_26","003_6_26","EXO","6","26","26","Aaróona moomu nag, mook Musaa, la Aji Sax ji wax, ne leen: «Génneleen bànni Israayil Misra, kuréel ci kaw kuréel.» ");
INSERT INTO wolmbs_vpl VALUES ("EX6_27","003_6_27","EXO","6","27","27","Ñoom ñooñu ñoo wax ak Firawna buuru Misra, ngir génne bànni Israayil Misra; du keneen ku dul Musaa ak Aaróona. ");
INSERT INTO wolmbs_vpl VALUES ("EX6_28","003_6_28","EXO","6","28","28","Keroog ba Aji Sax ji waxee ak Musaa ca réewum Misra, ");
INSERT INTO wolmbs_vpl VALUES ("EX6_29","003_6_29","EXO","6","29","29","da koo wax, ne ko: «Man maay Aji Sax ji. Nanga wax Firawna buuru Misra, li ma lay wax lépp.» ");
INSERT INTO wolmbs_vpl VALUES ("EX6_30","003_6_30","EXO","6","30","30","Teewul Musaa tinu Aji Sax ji, ne ko: «Waaw, waaye man, damaa tëlee wax. Mbaa Firawna dina ma déggal yee?» ");
INSERT INTO wolmbs_vpl VALUES ("EX7_1","003_7_1","EXO","7","1","1","Aji Sax ji ne Musaa: «Dama ne, def naa nga féete Firawna fi ko Yàlla féete, sa mag Aaróona di sa yonent. ");
INSERT INTO wolmbs_vpl VALUES ("EX7_2","003_7_2","EXO","7","2","2","Su ko defee yaw nga wax ko li ma la sant lépp, sa mag Aaróona wax ko Firawna, ngir mu bàyyi bànni Israayil, ñu génn réewam. ");
INSERT INTO wolmbs_vpl VALUES ("EX7_3","003_7_3","EXO","7","3","3","Waaye man maay dëgëral boppu Firawna, ba fulandi samay firnde ak samay kéemaan ci biir réewum Misra. ");
INSERT INTO wolmbs_vpl VALUES ("EX7_4","003_7_4","EXO","7","4","4","Firawna du leen déggal. Su ko defee nag maay tàllal sama loxo, tiimale Misra, te maay dogal mbugal yu kéemaane, ba goreel bànni Israayil, sama ñoñ, ñu génn Misra, kuréel ci kaw kuréel. ");
INSERT INTO wolmbs_vpl VALUES ("EX7_5","003_7_5","EXO","7","5","5","Keroog bu ma tàllalee sama loxo, tiimale ko Misra, ba génnee bànni Israayil ca seen biir, waa Misra dinañu xam ne maay Aji Sax ji.» ");
INSERT INTO wolmbs_vpl VALUES ("EX7_6","003_7_6","EXO","7","6","6","La Aji Sax ji santoon Musaak Aaróona, noonu rekk lañu ko defe. ");
INSERT INTO wolmbs_vpl VALUES ("EX7_7","003_7_7","EXO","7","7","7","Musaa nga tollu woon ci juróom ñett fukki at (80); Aaróona moom am juróom ñett fukki at ak ñett (83); ca jamono, ya ñuy wax ak Firawna. ");
INSERT INTO wolmbs_vpl VALUES ("EX7_8","003_7_8","EXO","7","8","8","Aji Sax ji dafa wax Musaa ak Aaróona ne leen: ");
INSERT INTO wolmbs_vpl VALUES ("EX7_9","003_7_9","EXO","7","9","9","«Bu leen Firawna waxee ne leen: “Defleen seeni kéemaan boog!” danga naan Aaróona: “Jëlal yet wi, sànni ci suuf ci kanam Firawna.” Su ko defee yet wi dina soppaliku jaan.» ");
INSERT INTO wolmbs_vpl VALUES ("EX7_10","003_7_10","EXO","7","10","10","Ci kaw loolu Musaa ak Aaróona àgg ba ca Firawna. Ñu def la leen Aji Sax ji santoon. Aaróona jël yetam, sànni ca suuf ca kanam Firawnaaki dagam; yet wa soppaliku jaan. ");
INSERT INTO wolmbs_vpl VALUES ("EX7_11","003_7_11","EXO","7","11","11","Ba mu ko defee Firawna moom itam woo boroom xam-xam yaak ñeengokat ya. Jabarkati Misra ya ñoom it fexe ca seeni xarfafuufa, ba def lu mel noona. ");
INSERT INTO wolmbs_vpl VALUES ("EX7_12","003_7_12","EXO","7","12","12","Ku nekk ca ñoom sànni yetam, mu soppaliku jaan, yetu Aaróona nag wann seeni yet. ");
INSERT INTO wolmbs_vpl VALUES ("EX7_13","003_7_13","EXO","7","13","13","Terewul Firawna të, faalewu leen, muy la Aji Sax ji waxoon. ");
INSERT INTO wolmbs_vpl VALUES ("EX7_14","003_7_14","EXO","7","14","14","Gannaaw loolu Aji Sax ji wax na Musaa ne ko: «Firawna daa dëgër bopp. Bañ naa bàyyi mbooloo mi, ñu dem. ");
INSERT INTO wolmbs_vpl VALUES ("EX7_15","003_7_15","EXO","7","15","15","Dangay teela xëy ca Firawna ëllëg, buy génn jëm ca ndox ma, nga dogale ko ca tàkkal dexu Niil, te yóbbaale yet wa soppaliku woon jaan. ");
INSERT INTO wolmbs_vpl VALUES ("EX7_16","003_7_16","EXO","7","16","16","Wax ko ne ko: “Aji Sax ji Yàllay Ebrë yi, moo ma yónni ci yaw. Mu di la wax, ne la: Bàyyil sama ñoñ, ñu jaamuji ma ca màndiŋ ma. Yaw nag booba ba tey yaa ngi tanqamlu. ");
INSERT INTO wolmbs_vpl VALUES ("EX7_17","003_7_17","EXO","7","17","17","Aji Sax ji dafa wax ne: Ni ngay xame ne man maay Aji Sax ji nii la: dama ne, dinaa dóor ci ndoxum Niil mi yet wi ci sama loxo, ndox mi soppaliku deret; ");
INSERT INTO wolmbs_vpl VALUES ("EX7_18","003_7_18","EXO","7","18","18","su ko defee jën yi ci dex gi dee, dexu Niil gi mujj xasaw, ba waa Misra dootuñu mana naan ci ndox mi.”» ");
INSERT INTO wolmbs_vpl VALUES ("EX7_19","003_7_19","EXO","7","19","19","Ci kaw loolu Aji Sax ji ne Musaa: «Waxal Aaróona ne ko: “Jëlal saw yet, te tàllal sa loxo tiimale ko ndoxi Misra, muy seeni dex ak seen yooni ndox ak seeni déeg ak fépp fu ndox taa, mu ànd soppaliku deret.” Deret ja dina daj Misra gépp, ba ca këll yaak njaq ya.» ");
INSERT INTO wolmbs_vpl VALUES ("EX7_20","003_7_20","EXO","7","20","20","Musaa ak Aaróona def loolu lépp, na leen ko Aji Sax ji sante. Naka la ne xaas yet wa, ne ko tàrr ca ndoxum Niil ma, ca kanam Firawnaaki dagam, ndoxum Niil ma mépp di deret, ");
INSERT INTO wolmbs_vpl VALUES ("EX7_21","003_7_21","EXO","7","21","21","jën ya ca dexu Niil ga dee, dexu Niil ga xasaw, ba waa Misra manatuñoo caa naan. Misra gépp di deret. ");
INSERT INTO wolmbs_vpl VALUES ("EX7_22","003_7_22","EXO","7","22","22","Jabarkati Misra itam fexe ca seeni xarfafuufa, ba def lu mel noona. Firawna të rekk, tanqamlu Musaak Aaróona, muy la Aji Sax ji waxoon. ");
INSERT INTO wolmbs_vpl VALUES ("EX7_23","003_7_23","EXO","7","23","23","Ba loolu amee Firawna ne wërëñ, dellu këram, te bàyyiwul xel ca mbir ma. ");
INSERT INTO wolmbs_vpl VALUES ("EX7_24","003_7_24","EXO","7","24","24","Waa Misra gépp di gas la wër dexu Niil, ngir am ndoxum naan, ndax manuñu woona naan ca dex ga. ");
INSERT INTO wolmbs_vpl VALUES ("EX7_25","003_7_25","EXO","7","25","25","Ba Aji Sax ji dalee ca kaw dexu Niil, ba ñu teg ca juróom ñaari fan, ");
INSERT INTO wolmbs_vpl VALUES ("EX7_26","003_7_26","EXO","7","26","26","Aji Sax ji da ne Musaa: «Demal ca Firawna, ne ko: “Aji Sax ji dafa wax ne: Bàyyil sama ñoñ, ñu dem jaamuji ma. ");
INSERT INTO wolmbs_vpl VALUES ("EX7_27","003_7_27","EXO","7","27","27","Soo leen bañee bàyyi, ñu dem kat, maa leen di mbugale ay mbott yu daj sam réew. ");
INSERT INTO wolmbs_vpl VALUES ("EX7_28","003_7_28","EXO","7","28","28","Dexu Niil gi day ramm-rammeeki mbott, te dinañu ñëw, duggsi sa biir kër, ak sa néegu biir, ak sa kaw lal, ak sa këri dag, ak sa waa réew, ba ca lakkukaay yaak nootukaayi mburu ya. ");
INSERT INTO wolmbs_vpl VALUES ("EX7_29","003_7_29","EXO","7","29","29","Mbott yi dinañu yéeg ci sa kaw, yéeg ci kaw waa réew mi, ak sa dag yépp.”» ");
INSERT INTO wolmbs_vpl VALUES ("EX8_1","003_8_1","EXO","8","1","1","Ba loolu weesoo Aji Sax ji ne Musaa: «Waxal Aaróona, ne ko mu jël yet wi, tàllal loxoom, tiimale ko dex yi, ak yooni ndox yeek déeg yi, ngir indi mbott yi ci biir réewum Misra.» ");
INSERT INTO wolmbs_vpl VALUES ("EX8_2","003_8_2","EXO","8","2","2","Aaróona tàllal loxoom, mu tiim ndoxi Misra, mbott ya jóg, lal réewum Misra. ");
INSERT INTO wolmbs_vpl VALUES ("EX8_3","003_8_3","EXO","8","3","3","Jabarkat ya it fexe ca seeni xarfafuufa, ba indi ay mbott ca réewum Misra. ");
INSERT INTO wolmbs_vpl VALUES ("EX8_4","003_8_4","EXO","8","4","4","Ba mu ko defee Firawna woo Musaak Aaróona, ne leen: «Ñaanleen Aji Sax ji, ngir mu teqale nook mbott yi, man ak sama waa réew. Kon dinaa bàyyi mbooloo mi, ñu dem rendili Aji Sax ji sarax.» ");
INSERT INTO wolmbs_vpl VALUES ("EX8_5","003_8_5","EXO","8","5","5","Musaa ne Firawna: «Saa yu la neexee rekk, sang bi. Wax ma kañ laa lay ñaanal, yaw ak say dag ak sa waa réew, ngir jële fi mbott yi, ñu tàggook yeen, génn seeni kër, ca dexu Niil ga doŋŋ lañuy des.» ");
INSERT INTO wolmbs_vpl VALUES ("EX8_6","003_8_6","EXO","8","6","6","Mu ne ko: «Nay ëllëg.» Musaa ne ko: «Baax na, ndax nga xam ne sunu Yàlla Aji Sax ji amul moroom. ");
INSERT INTO wolmbs_vpl VALUES ("EX8_7","003_8_7","EXO","8","7","7","Mbott yi dinañu jóge sa kër, teqalikook yeen, yaak say dag ak sa waa réew, ca dexu Niil ga doŋŋ lañuy des.» ");
INSERT INTO wolmbs_vpl VALUES ("EX8_8","003_8_8","EXO","8","8","8","Musaa ak Aaróona nag jóge ca Firawna, Musaa tinu Aji Sax ji ca mbirum mbott ya mu yare Firawna. ");
INSERT INTO wolmbs_vpl VALUES ("EX8_9","003_8_9","EXO","8","9","9","Aji Sax ji def la ko Musaa ñaan, mbott ya dee, ba jeex ca kër yaak ca ëtt yaak tool ya. ");
INSERT INTO wolmbs_vpl VALUES ("EX8_10","003_8_10","EXO","8","10","10","Ñu jal koo jal, ba xet ga ubale ca réew ma. ");
INSERT INTO wolmbs_vpl VALUES ("EX8_11","003_8_11","EXO","8","11","11","Teewul, ba Firawna gisee ca mbir ma ag tan, daa wéye të, tanqamlu leen, muy la Aji Sax ji waxoon. ");
INSERT INTO wolmbs_vpl VALUES ("EX8_12","003_8_12","EXO","8","12","12","Ba loolu amee Aji Sax ji ne Musaa: «Waxal Aaróona ne ko mu tàllal yetam, dóor ci pëndub suuf si, mu doon ay yoo ci réewum Misra gépp.» ");
INSERT INTO wolmbs_vpl VALUES ("EX8_13","003_8_13","EXO","8","13","13","Ñu def loola, Aaróona tàllal loxoom ba mu yore yet wa, dóor ca pënd ba, mu doon ay yoo yu song nit ak rab; pëndub suuf sépp a defi yoo ca réewum Misra gépp. ");
INSERT INTO wolmbs_vpl VALUES ("EX8_14","003_8_14","EXO","8","14","14","Jabarkat ya fexe ca seeni xarfafuufa, nu ñu defe ay yoo, waaye manuñu. Yoo ya nag song nit ñaak rab ya. ");
INSERT INTO wolmbs_vpl VALUES ("EX8_15","003_8_15","EXO","8","15","15","Jabarkat ya ne Firawna: «Lii de Yàlla rekk a ko man!» Teewul Firawna wéye të rekk, tanqamlu leen, muy la Aji Sax ji waxoon. ");
INSERT INTO wolmbs_vpl VALUES ("EX8_16","003_8_16","EXO","8","16","16","Aji Sax ji waxati Musaa, ne ko: «Teelala xëy ëllëg ca Firawna, buy génn jëm ca ndox ma, nga wax ko ne ko: “Aji Sax ji dafa wax ne: Bàyyil sama ñoñ, ñu dem jaamuji ma. ");
INSERT INTO wolmbs_vpl VALUES ("EX8_17","003_8_17","EXO","8","17","17","Ndaxte soo bàyyiwul sama ñoñ, ñu dem kat, dinaa yuri ay ndiiraani weñ yuy màtte ci seen kaw, yaak say dag ak sa waa réew, te dinañu àgg ci sa biir kër. Këri waa Misra dina fees ak weñ yuy màtte, ba suuf, si ñu taxaw sax, weñ yee koy muur. ");
INSERT INTO wolmbs_vpl VALUES ("EX8_18","003_8_18","EXO","8","18","18","Waaye bu keroogee dinaa ci musal diiwaanu Gosen, ga sama ñoñ dëkke, ba ay weñ du fa same, ndax nga xam ne, man Aji Sax ji maa ngi ci digg réew mii, ");
INSERT INTO wolmbs_vpl VALUES ("EX8_19","003_8_19","EXO","8","19","19","te maay musal sama ñoñ ci musiba moomuy dal saw askan. Ëllëg firnde jooju dina am.”» ");
INSERT INTO wolmbs_vpl VALUES ("EX8_20","003_8_20","EXO","8","20","20","Aji Sax ji def loola, weñ yi def ndiiraan yu réy, song kër Firawna ak kër dagam ya, dajal réewum Misra, ba réew ma yàqu ndax ndiiraani weñ ya. ");
INSERT INTO wolmbs_vpl VALUES ("EX8_21","003_8_21","EXO","8","21","21","Firawna daldi woolu Musaak Aaróona, ne leen: «Demleen rendili seen Yàlla sarax, te nay ci biir réew mi nag.» ");
INSERT INTO wolmbs_vpl VALUES ("EX8_22","003_8_22","EXO","8","22","22","Musaa ne ko: «Loolu du yoon, ndax li nuy rendil sunu Yàlla Aji Sax ji, waa Misra dañu koy xof. Te bu nu sarxalee lenn lu waa Misra xof, ñuy gis, dinañu nu dóor ay doj, ba nu dee. ");
INSERT INTO wolmbs_vpl VALUES ("EX8_23","003_8_23","EXO","8","23","23","Kon kay danoo wara génn, topp màndiŋ mi lu mat doxub ñetti fan, rendili fa sunu Yàlla Aji Sax ji sarax, ni mu nu ko sante.» ");
INSERT INTO wolmbs_vpl VALUES ("EX8_24","003_8_24","EXO","8","24","24","Firawna àddu ne: «Dinaa leen may, ngeen dem ca màndiŋ ma, rendili seen Yàlla Aji Sax ji sarax, waaye buleen sore lool. Ñaanalleen ma nag.» ");
INSERT INTO wolmbs_vpl VALUES ("EX8_25","003_8_25","EXO","8","25","25","Musaa ne ko: «Bu ma bàyyikoo ci yaw rekk Firawna, dinaa tinu Aji Sax ji, ngir ëllëg ndiiraani weñ yi teqalikook yaw, ak say dag ak sa waa réew, waaye kat Firawna, bu nu naxati, di baña bàyyi mbooloo mi, ñu rendili Aji Sax ji sarax.» ");
INSERT INTO wolmbs_vpl VALUES ("EX8_26","003_8_26","EXO","8","26","26","Musaa bàyyikoo fa Firawna, daldi tinu Aji Sax ji. ");
INSERT INTO wolmbs_vpl VALUES ("EX8_27","003_8_27","EXO","8","27","27","Aji Sax ji defal Musaa la mu ñaan, jële ndiiraani weñ ya ca Firawnaaki dagam ak waa réewam, ba weñ desatu fa. ");
INSERT INTO wolmbs_vpl VALUES ("EX8_28","003_8_28","EXO","8","28","28","Teewul Firawna të rekk, baña bàyyi mbooloo ma, ñu dem. ");
INSERT INTO wolmbs_vpl VALUES ("EX9_1","003_9_1","EXO","9","1","1","Ba loolu wéyee Aji Sax ji da ne Musaa: «Demal ca Firawna, nga ne ko: “Aji Sax ji Yàllay Ebrë yi dafa wax ne: Bàyyil sama ñoñ, ñu dem màggali ma. ");
INSERT INTO wolmbs_vpl VALUES ("EX9_2","003_9_2","EXO","9","2","3","Ndax boo leen bañee bàyyi kat, xanaa di leen téye ba tey, loxol Aji Sax ji dina dal ci sa kaw jur gi ci tool yi, muy fas ak mbaam ak giléem, jur gu gudd ak gu gàtt, te jàngoro ju aaytal lool lay doon. ");
INSERT INTO wolmbs_vpl VALUES ("EX9_4","003_9_4","EXO","9","4","4","Waaye man Aji Sax ji maay ràññaatle juru bànni Israayil ak juru waa Misra, ba lenn du dee ci mboolem lu bànni Israayil moom.”» ");
INSERT INTO wolmbs_vpl VALUES ("EX9_5","003_9_5","EXO","9","5","5","Aji Sax ji nag jàpp na bés, nee na: «Ëllëg maay def loolu ci réew mi.» ");
INSERT INTO wolmbs_vpl VALUES ("EX9_6","003_9_6","EXO","9","6","6","Ca ëllëg sa Aji Sax ji def ko: jurug waa Misra gépp dee, te jurug bànni Israayil, lenn deewu ca. ");
INSERT INTO wolmbs_vpl VALUES ("EX9_7","003_9_7","EXO","9","7","7","Ba Firawna yónnee, ba nemmiku mbir ma, xam na ne lenn deewul ca juru bànni Israayil. Teewul mu të ticc ba tey, baña bàyyi mbooloo ma, ñu dem. ");
INSERT INTO wolmbs_vpl VALUES ("EX9_8","003_9_8","EXO","9","8","8","Ba loolu amee Aji Sax ji wax Musaa ak Aaróona ne leen: «Tibbleen seeni loxo dóomu puuru ban, ba mu fees, Musaa suy ko, mu jëm asamaan, Firawna di ci gis. ");
INSERT INTO wolmbs_vpl VALUES ("EX9_9","003_9_9","EXO","9","9","9","Su ko defee dóom bi doon pënd bu sew ci kaw réewum Misra gépp, daldi def ay taab yuy sotti dëtt ci réewum Misra gépp, ci nit ak mala.» ");
INSERT INTO wolmbs_vpl VALUES ("EX9_10","003_9_10","EXO","9","10","10","Ñu sàkk dóom, àgg ca kanam Firawna, Musaa suy dóom ba, mu jëm ca kaw, ba mu def ay taab yuy sotti dëtt ca nit ñaak mala ya. ");
INSERT INTO wolmbs_vpl VALUES ("EX9_11","003_9_11","EXO","9","11","11","Ci kaw loolu jabarkat ya taluñoo janook Musaa ndax ay taab, ñoom ak waa Misra gépp. ");
INSERT INTO wolmbs_vpl VALUES ("EX9_12","003_9_12","EXO","9","12","12","Teewul Aji Sax ji dëgëral boppu Firawna, mu të, tanqamlu leen, muy la Aji Sax ji waxoon Musaa. ");
INSERT INTO wolmbs_vpl VALUES ("EX9_13","003_9_13","EXO","9","13","13","Aji Sax ji waxati Musaa, ne ko: «Teelala xëy ca Firawna ëllëg, nga wax ko ne ko: “Aji Sax ji, Yàllay Ebrë yi, dafa wax ne: Bàyyil sama ñoñ, ñu dem màggali ma. ");
INSERT INTO wolmbs_vpl VALUES ("EX9_14","003_9_14","EXO","9","14","14","Ndax kat bii yoon maa ngii di yebal sama mbugal yépp ci yaw ci sa bopp, ak say dag ak sa waa réew, ngir nga xam ne awma moroom ci àddina wërngal këpp. ");
INSERT INTO wolmbs_vpl VALUES ("EX9_15","003_9_15","EXO","9","15","15","Nëgëni tey doon naa xàcc sama loxo xaat, dumaa leen mbas mu leen di fare ci kaw suuf, yaw yaak sa waa réew. ");
INSERT INTO wolmbs_vpl VALUES ("EX9_16","003_9_16","EXO","9","16","16","Waaye maa la musal, te li ma ci jublu moo di won la sama doole, ba sama riirum tur dajal àddina. ");
INSERT INTO wolmbs_vpl VALUES ("EX9_17","003_9_17","EXO","9","17","17","Ndaxam yaa ngi réy-réylu ci sama kaw ñoñ ba tey, bañ leena bàyyi, ñu dem. ");
INSERT INTO wolmbs_vpl VALUES ("EX9_18","003_9_18","EXO","9","18","18","Te kat nëgëni ëllëg dinaa taw yuur bu réy, bu masula am Misra, ba mu sosoo ba tey jii. ");
INSERT INTO wolmbs_vpl VALUES ("EX9_19","003_9_19","EXO","9","19","19","Kon nag sa jur ak mboolem loo am, te mu nekk ci biti, joxeel ndigal ñu boole fat fu wóor, ndax lu nekk ci biti te fateesu ko, su tawtee dee, muy nit mbaa mala.”» ");
INSERT INTO wolmbs_vpl VALUES ("EX9_20","003_9_20","EXO","9","20","20","Ba mu ko defee ña ragal kàddug Aji Sax ji ca dagi Firawna fat seeni jaam ak seeni jur fu wóor. ");
INSERT INTO wolmbs_vpl VALUES ("EX9_21","003_9_21","EXO","9","21","21","Ña faalewul kàddug Aji Sax ji, ñoom, wacc seeni jaam ak seeni jur ca biti. ");
INSERT INTO wolmbs_vpl VALUES ("EX9_22","003_9_22","EXO","9","22","22","Aji Sax ji ne Musaa: «Yékkatil sa loxo ca kaw, mu jublu asamaan, ngir tawub yuur bi dal ci réewum Misra mépp, nit ak mala, ba ci lépp luy gàncax ci réewum Misra.» ");
INSERT INTO wolmbs_vpl VALUES ("EX9_23","003_9_23","EXO","9","23","23","Musaa ne yékkét yet wa, mu jublu asamaan, Aji Sax ji yebal dënu baak tawub yuur ba, sawara wa ne yureet fi suuf, ànd ak tawub yuur, ba Aji Sax ji sóob ca réewum Misra. ");
INSERT INTO wolmbs_vpl VALUES ("EX9_24","003_9_24","EXO","9","24","24","Tawub yuur ba réy lool, ànd ak sawara, wa jaxasook yuur ba, di xuyy-xuyyi, muy guléet ca cosaanu réewum Misra ba bésub keroog. ");
INSERT INTO wolmbs_vpl VALUES ("EX9_25","003_9_25","EXO","9","25","25","Tawub yuur ba dal ca mboolem réewum Misra, daaneel lépp lu ne woon ca biti, nit ak mala, daaneel gàncax gépp, dammat garab ya ca àll ba yépp. ");
INSERT INTO wolmbs_vpl VALUES ("EX9_26","003_9_26","EXO","9","26","26","Diiwaanu Gosen, ga bànni Israayil dëkkoon doŋŋ, moo mucc ca tawub yuur ba. ");
INSERT INTO wolmbs_vpl VALUES ("EX9_27","003_9_27","EXO","9","27","27","Firawna nag yónnee, woolu Musaak Aaróona. Mu wax leen ne leen: «Bii yoon de, maa tooñ. Aji Sax ji moo nekk ci dëgg, te maak sama waa réew ñoo sikk. ");
INSERT INTO wolmbs_vpl VALUES ("EX9_28","003_9_28","EXO","9","28","28","Tinuleen Aji Sax ji, ndax dënu yu màgg yeek tawub yuur bi dakk. Dinaa leen bàyyi, ngeen dem. Deesu leen fi téyeeti.» ");
INSERT INTO wolmbs_vpl VALUES ("EX9_29","003_9_29","EXO","9","29","29","Musaa ne ko: «Bu may génn dëkk bi rekk, di tàllal Aji Sax ji samay loxo, dënu yi dakk, tawub yuur bi sewet, ngir nga xam ne àddina, Aji Sax jeey boroom. ");
INSERT INTO wolmbs_vpl VALUES ("EX9_30","003_9_30","EXO","9","30","30","Waaye xam naa ne, loolu du tax ba tey, nga ragal Yàlla Aji Sax ji, yaw, yaak say dag.» ");
INSERT INTO wolmbs_vpl VALUES ("EX9_31","003_9_31","EXO","9","31","31","Fekk na gàncax ga ñuy defare wëñu lẽe yàqu na, mook peppum lors ba, ndax lors baa nga tollu woon ci waaja focci, gàncax ga ñuy defare lẽe di tóor. ");
INSERT INTO wolmbs_vpl VALUES ("EX9_32","003_9_32","EXO","9","32","32","Waaye xeeti peppi bele ya, lenn yàquwu ca, ndax yooyooy mujja ñor. ");
INSERT INTO wolmbs_vpl VALUES ("EX9_33","003_9_33","EXO","9","33","33","Naka la Musaa bàyyikoo ca Firawna, ba génn dëkk ba rekk, daldi tàllal Aji Sax ji ay loxoom. Dënu yaak tawub yuur ba ne tekk, taw ba sewet. ");
INSERT INTO wolmbs_vpl VALUES ("EX9_34","003_9_34","EXO","9","34","34","Ba mu ko defee Firawna gis ne tawub yuur baak dënu ya dakk na, mu tëëti ticc, mooki dagam, dellu cig tooñam. ");
INSERT INTO wolmbs_vpl VALUES ("EX9_35","003_9_35","EXO","9","35","35","Firawna të rekk, baña bàyyi bànni Israayil, ñu dem, muy la Aji Sax ji waxoon, Musaa jottali. ");
INSERT INTO wolmbs_vpl VALUES ("EX10_1","003_10_1","EXO","10","1","1","Ba loolu weesoo Aji Sax ji dafa wax Musaa ne ko: «Demal ca Firawna. Maa dëgëral boppam, mooki dagam, ngir jëfe samay firnde fi seen biir. ");
INSERT INTO wolmbs_vpl VALUES ("EX10_2","003_10_2","EXO","10","2","2","Su ko defee ngeen mana nettali seeni doom ak seeni sët ni ma toroxale waa Misra, ak sama firnde yi ma def fi seen biir, ndax ngeen xam ne man maay Aji Sax ji.» ");
INSERT INTO wolmbs_vpl VALUES ("EX10_3","003_10_3","EXO","10","3","3","Musaa ak Aaróona nag dem ca Firawna, wax ko ne ko: «Aji Sax ji Yàllay Ebrë yi dafa wax ne: Siide nga maa nangul daal? Waaw, foo àpp sa ngàntal ak man? Bàyyil sama ñoñ, ñu dem màggali ma. ");
INSERT INTO wolmbs_vpl VALUES ("EX10_4","003_10_4","EXO","10","4","4","Soo bañee bàyyi sama ñoñ, ñu dem kat, ëllëg dinaa wàcce ay njéeréer ci sam réew. ");
INSERT INTO wolmbs_vpl VALUES ("EX10_5","003_10_5","EXO","10","5","5","Dinañu lal déndu réew mi, ba kenn dootul gis suuf. Dinañu lekk lu fi tawub yuur bi ba woon, te garab yi ci seeni tool yépp lañuy lekk. ");
INSERT INTO wolmbs_vpl VALUES ("EX10_6","003_10_6","EXO","10","6","6","Te itam dinañu fees say biir kër ak sa këri dag yépp ak këri waa Misra gépp, muy mbir mu say maam ak say maamaat masula gis, ba ñu ganee àddina ba bésub tey jii.» Ba loolu amee Musaa walbatiku, bàyyikoo ca Firawna. ");
INSERT INTO wolmbs_vpl VALUES ("EX10_7","003_10_7","EXO","10","7","7","Dagi Firawna ya wax Firawna ne ko: «Lu nuy seetaanati, waa jii di nu yóbbe aw ay? Bàyyil bànni Israayil ñii kay, ñu màggali seen Yàlla Aji Sax ji! Xanaa yéguloo ne Misra tas na?» ");
INSERT INTO wolmbs_vpl VALUES ("EX10_8","003_10_8","EXO","10","8","8","Ñu delloosi nag Musaak Aaróona ca Firawna, mu ne leen: «Demleen màggali seen Yàlla Aji Sax ji! Waaw, ñiy dem sax, ñan la?» ");
INSERT INTO wolmbs_vpl VALUES ("EX10_9","003_10_9","EXO","10","9","9","Musaa ne ko: «Nun ñépp ay dem kay, mag ak ndaw; danuy dem, ànd ak sunuy doom, góor ak jigéen, ak sunuy jur, gu gudd ak gu gàtt, ndax màggalug Aji Sax ji la ci nun.» ");
INSERT INTO wolmbs_vpl VALUES ("EX10_10","003_10_10","EXO","10","10","10","Firawna ne leen: «Ãa, yal na leen Aji Sax ji saxoo taxawu walla, ndegam maa leen di bàyyi moos, ngeen dem, yóbbaale seen njaboot! Xam ngeen ne naruleen njub de. ");
INSERT INTO wolmbs_vpl VALUES ("EX10_11","003_10_11","EXO","10","11","11","Mukk laa wax! Du dangeen di màggal Aji Sax ji? Demleen boog, yeen ñiy góor!» Ba loolu amee ñu dàq leen, ñu jóge ca Firawna. ");
INSERT INTO wolmbs_vpl VALUES ("EX10_12","003_10_12","EXO","10","12","12","Aji Sax ji ne Musaa: «Tàllalal sa loxo, mu tiim réewum Misra, ngir njéeréer yi ñëw, song réewum Misra, ba lekk gàncax gi ci réew mi, lekk lépp lu fi tawub yuur bi bàyyi woon.» ");
INSERT INTO wolmbs_vpl VALUES ("EX10_13","003_10_13","EXO","10","13","13","Ba mu ko defee Musaa tàllal yetam, mu tiim réewum Misra, Aji Sax ji yékkati ngelaw ca réew ma, mu jóge penku, yendoo gelaw, fanaanoo ko. Bët set, ngelawal penku la indi njéeréer ya. ");
INSERT INTO wolmbs_vpl VALUES ("EX10_14","003_10_14","EXO","10","14","14","Njéeréer ya song réewum Misra mépp, sam déndu Misra wépp, ba mu fatt taraj. Lu ni tollu masula am, te dootul amati. ");
INSERT INTO wolmbs_vpl VALUES ("EX10_15","003_10_15","EXO","10","15","15","Njéeréer ya daa muur suuf sa sépp, ba giseesu ko. Suuf sa ñuul kukk. Njéeréer ya lekk lépp luy gàncax mbaa meññeefi garab gu tawub yuur ba jotuloona yàq, ba lenn lu naat desatul, du xobi garab, du gàncax, ca mboolem réewum Misra. ");
INSERT INTO wolmbs_vpl VALUES ("EX10_16","003_10_16","EXO","10","16","16","Firawna nag gaaw woolu Musaak Aaróona, ne leen: «Tooñ naa seen Yàlla Aji Sax ji, tooñ leen. ");
INSERT INTO wolmbs_vpl VALUES ("EX10_17","003_10_17","EXO","10","17","17","Baal ma àq bii yoon rekk, te ngeen ñaanal ma seen Yàlla Aji Sax ji, ngir mu teggil ma rekk, wii ay wu rey.» ");
INSERT INTO wolmbs_vpl VALUES ("EX10_18","003_10_18","EXO","10","18","18","Musaa bàyyikoo ca Firawna, tinu Aji Sax ji. ");
INSERT INTO wolmbs_vpl VALUES ("EX10_19","003_10_19","EXO","10","19","19","Aji Sax ji walbati ngelaw la, mu jóge sowu, am doole lool, daldi fél njéeréer ya, sànni ca géeju Barax ya, ba luy niru njéeréer desatul ca déndu Misra. ");
INSERT INTO wolmbs_vpl VALUES ("EX10_20","003_10_20","EXO","10","20","20","Teewul Aji Sax ji dëgëral boppu Firawna, mu të rekk, baña bàyyi bànni Israayil ñu dem. ");
INSERT INTO wolmbs_vpl VALUES ("EX10_21","003_10_21","EXO","10","21","21","Gannaaw loolu Aji Sax ji ne Musaa: «Tàllalal sa loxo, mu jublu asamaan, lëndëm wàcc ci kaw réewum Misra, lëndëm gu nit mana daj, ndax fatt.» ");
INSERT INTO wolmbs_vpl VALUES ("EX10_22","003_10_22","EXO","10","22","22","Musaa tàllal loxoom, mu jublu asamaan, lëndëm gu fatt wàcc ca kaw réewum Misra gépp, diiru ñetti fan. ");
INSERT INTO wolmbs_vpl VALUES ("EX10_23","003_10_23","EXO","10","23","23","Kenn gisul sa moroom, kenn manula jóge fa nga nekk, diiru ñetti fan. Teewul këri bànni Israayil gépp di leer. ");
INSERT INTO wolmbs_vpl VALUES ("EX10_24","003_10_24","EXO","10","24","24","Firawna nag woolu Musaa, ne ko: «Demleen màggali Aji Sax ji. Seen jur gu gudd ak gu gàtt rekk a fiy des, seeni doom sax man nañoo ànd ak yeen.» ");
INSERT INTO wolmbs_vpl VALUES ("EX10_25","003_10_25","EXO","10","25","25","Musaa ne ko: «Danga noo wara bàyyee lu nuy sarxalal sunu Yàlla Aji Sax ji, ak yu ñu koy defal saraxu rendi-dóomal. ");
INSERT INTO wolmbs_vpl VALUES ("EX10_26","003_10_26","EXO","10","26","26","Sunuy gétt dina nu topp moos, luy nirook we sax du des gannaaw, ndax ci lanuy tànne lu nuy màggale sunu Yàlla Aji Sax ji, te itam li feek nuy àgg foofa, manunoo xam lan lanu ciy def sarax, màggale Aji Sax ji.» ");
INSERT INTO wolmbs_vpl VALUES ("EX10_27","003_10_27","EXO","10","27","27","Teewul Aji Sax ji dëgëral boppu Firawna, mu të rekk, bañ leena bàyyi ñu dem. ");
INSERT INTO wolmbs_vpl VALUES ("EX10_28","003_10_28","EXO","10","28","28","Firawna nag ne Musaa: «Neel mott! Bul fexe ba taxawati sama kanam! Ndax bés boo jàkkaarlooteek man, kera ngay dee.» ");
INSERT INTO wolmbs_vpl VALUES ("EX10_29","003_10_29","EXO","10","29","29","Musaa ne ko: «Noonu la sax de. Duma jàkkaarlooteek yaw moos!» ");
INSERT INTO wolmbs_vpl VALUES ("EX11_1","003_11_1","EXO","11","1","1","Ba loolu wéyee Aji Sax ji waxati Musaa ne ko: «Benn yarub mujjantal laay dellu wàcce ci kaw Firawna ak waa Misra. Su ko defee du leen bàyyi ngeen dem, yem ca. Da leen fiy far dàqe, ba fàww. ");
INSERT INTO wolmbs_vpl VALUES ("EX11_2","003_11_2","EXO","11","2","2","Te neel mbooloo mi, góor gu nekk ak jigéen ju nekk ci ñoom na sàkkoo ci dëkkandoob waa Misraam, ay gànjari xaalis ak wurus.» ");
INSERT INTO wolmbs_vpl VALUES ("EX11_3","003_11_3","EXO","11","3","3","Ci biir loolu Aji Sax ji def waa Misra yéwéne leen. Musaa sax ci boppam ku ñu naw la woon ca réewum Misra, ca dagi Firawna ya, ba ca baadoolo ya. ");
INSERT INTO wolmbs_vpl VALUES ("EX11_4","003_11_4","EXO","11","4","4","Musaa daldi wax Firawna ne ko: «Aji Sax ji dafa wax ne: “Bu guddi gi xaajee, maay wër Misra gépp, ");
INSERT INTO wolmbs_vpl VALUES ("EX11_5","003_11_5","EXO","11","5","5","te lépp luy taaw bu góor ci réewum Misra, dina dee, dale ko ci taaw bu góoru Firawna, mi toog ci jal bi, ba ci taaw bu góoru jaam bu jigéen bu féetewoo wol, boole ci luy taaw bu góor ci jur gépp. ");
INSERT INTO wolmbs_vpl VALUES ("EX11_6","003_11_6","EXO","11","6","6","Dees na dégg yuux yu réy jibe Misra gépp, lu masula am, te dootul am mukk. ");
INSERT INTO wolmbs_vpl VALUES ("EX11_7","003_11_7","EXO","11","7","7","Waaye fépp fu bànni Israayil dëkke, dara du fa wokk nit ak mala.” Su boobaa dingeen xam ne, Aji Sax jee ràññaatle waa Misra ak bànni Israayil. ");
INSERT INTO wolmbs_vpl VALUES ("EX11_8","003_11_8","EXO","11","8","8","Bu loolu amee mboolem sa dag yii dinañu ma sujjóotalsi te naan ma: “Demal, yaak mbooloo, mi la topp yépp!” Su ko defee ma doora dem.» Musaa nag won Firawna gannaaw, mer ba fees. ");
INSERT INTO wolmbs_vpl VALUES ("EX11_9","003_11_9","EXO","11","9","9","Fekk na Aji Sax ji wax Musaa ne ko: «Li waral Firawna du leen déglu, mooy sama kéemaan yi wara fulandiwu ci réewum Misra.» ");
INSERT INTO wolmbs_vpl VALUES ("EX11_10","003_11_10","EXO","11","10","10","Musaa ak Aaróona def nañu yooyu kéemaan yépp ca kanam Firawna, waaye fekk na Aji Sax ji dëgëral boppu Firawna, ba mu të, baña bàyyi bànni Israayil, ñu génn réew ma. ");
INSERT INTO wolmbs_vpl VALUES ("EX12_1","003_12_1","EXO","12","1","1","Aji Sax ji wax na ak Musaa ak Aaróona ca réewum Misra, ne leen: ");
INSERT INTO wolmbs_vpl VALUES ("EX12_2","003_12_2","EXO","12","2","2","«Weer wii mooy doon ci yeen wi jiitu ci weer yi, te na doon ci yeen weer wi njëkk ci at mi. ");
INSERT INTO wolmbs_vpl VALUES ("EX12_3","003_12_3","EXO","12","3","3","Waxleen ak mbooloom Israayil mépp ne leen, bésub fukkeel ba ci weer wii, na ku nekk jëlal njabootam ab gàtt, kër gu nekk ak gàttam. ");
INSERT INTO wolmbs_vpl VALUES ("EX12_4","003_12_4","EXO","12","4","4","Waaye su dee gàtt bu ëpp waa kër ga, dañu koy bokk ak kër gi leen gëna jege, te nañu seet nu nit ña tollu, doora tànn gàtt bu dëppook la ñu mana lekk. ");
INSERT INTO wolmbs_vpl VALUES ("EX12_5","003_12_5","EXO","12","5","5","Gàtt ba bumu am sikk te na di kuuyu menn at. Man naa doon xar mbaa sikket. ");
INSERT INTO wolmbs_vpl VALUES ("EX12_6","003_12_6","EXO","12","6","6","Dangeen koy denc ba fukkeelu bés ba ak ñeent ci weer wii. Bu bés baa ci diggante ngoon ak jant bu so, na mbooloom Israayil mépp bokk rendi seeni gàtt. ");
INSERT INTO wolmbs_vpl VALUES ("EX12_7","003_12_7","EXO","12","7","7","Su ko defee ñu sàkk ca deret ja, taqal ca buntu kër ga ñu ko nara lekke, taqal ca ñaari jëni bunt ba ak njëël bunt ba ca kaw. ");
INSERT INTO wolmbs_vpl VALUES ("EX12_8","003_12_8","EXO","12","8","8","Dañuy lakk yàpp wa cib taal, lekk ko guddig keroog, boole kook mburu mu amul lawiir ak xob yu wex. ");
INSERT INTO wolmbs_vpl VALUES ("EX12_9","003_12_9","EXO","12","9","9","Nañu ko wàjj, mu ne ñumm, bopp bi ak tànk yi ak yérey biir yi. Buleen ci lekk dara lu ñorul, mbaa lu ñu baxal. ");
INSERT INTO wolmbs_vpl VALUES ("EX12_10","003_12_10","EXO","12","10","10","Buleen ci wacc dara mu fanaan, te lépp lu ci des bu bët setee, lakkleen ba mu jeex tàkk. ");
INSERT INTO wolmbs_vpl VALUES ("EX12_11","003_12_11","EXO","12","11","11","Ni ngeen koy lekke nag nii la: bu ngeen koy lekk, dangeen di takku, sol seeni dàll, yor seen yet, te ngeen lekk ko ci lu gaaw. Loolu gàttu saraxu bésub Mucc ba lay doon, ñeel Aji Sax ji. ");
INSERT INTO wolmbs_vpl VALUES ("EX12_12","003_12_12","EXO","12","12","12","«Guddig keroog maay wër réewum Misra te maay faat lépp luy taaw bu góor ci réewum Misra, nit ak mala, te itam maay mbugal mboolem tuuri Misra. Man maay Aji Sax ji. ");
INSERT INTO wolmbs_vpl VALUES ("EX12_13","003_12_13","EXO","12","13","13","Deret ji ci kër yi ngeen dëkke nag, mooy doon seen xàmmikaay, ba tax bu ma gisee deret ji, musal leen. Su ko defee bu may dal ci kaw réewum Misra, menn musiba du leen lor. ");
INSERT INTO wolmbs_vpl VALUES ("EX12_14","003_12_14","EXO","12","14","14","«Bésub keroog bésub baaxantal lay doon ci yeen, ngeen war koo màggal ngir Aji Sax ji, muy dogal bu leen war fàww, yeen ak seen askan. ");
INSERT INTO wolmbs_vpl VALUES ("EX12_15","003_12_15","EXO","12","15","15","«Diiru juróom ñaari fan ngeen di lekk mburu mu amul lawiir; te bés bu njëkk bi ci boppam nangeen jële seeni kër luy lawiir, ndaxte képp ku ci lekk mburu mu am lawiir, li ko dale bés bi njëkk, ba kera bésub juróom ñaareel ba, dees na ko dagge ci askanu Israayil. ");
INSERT INTO wolmbs_vpl VALUES ("EX12_16","003_12_16","EXO","12","16","16","Bés bi njëkk nangeen ci amal woote bu sell. Juróom ñaareelu bés ba itam nangeen ca amal ndaje mu sell; deesul liggéey lenn ci yooyu bés, lu moy ngeen togg ñam wu ñépp lekk. Loolu doŋŋ lees ciy mana def. ");
INSERT INTO wolmbs_vpl VALUES ("EX12_17","003_12_17","EXO","12","17","17","«Nangeen wormaal ayu bésu Mburu mu amul lawiir, ndaxte ci bés boobu tembe laa leen génnee réewum Misra, kuréel ci kaw kuréel. Kon nag nangeen wormaal bés bii, muy dogal bu leen war fàww, yeen ak seen askan. ");
INSERT INTO wolmbs_vpl VALUES ("EX12_18","003_12_18","EXO","12","18","18","Li ko dale ngoonu fukki fan ak ñeent ci weer wu njëkk wi, ba ca ngoonu ñaar fukki fan ak benn ci weer woowu, nangeen ci lekk mburu mu amul lawiir. ");
INSERT INTO wolmbs_vpl VALUES ("EX12_19","003_12_19","EXO","12","19","19","Diiru juróom ñaari fan, bu dara ci lawiir am fenn ci seeni kër, ndax képp ku lekk lu am lawiir, dees na ko dagge ci askanu Israayil, muy doxandéem mbaa doomu réew mi. ");
INSERT INTO wolmbs_vpl VALUES ("EX12_20","003_12_20","EXO","12","20","20","Buleen ci lekk lenn lu am lawiir, te fépp fu ngeen dal, na mburu mu ngeen mana lekk di mu amul lawiir.» ");
INSERT INTO wolmbs_vpl VALUES ("EX12_21","003_12_21","EXO","12","21","21","Ba loolu amee Musaa woo magi Israayil ñépp, ne leen: «Demleen tànnali seeni njaboot ay gàtt, te ngeen rendi gàtt yooyu, def ko saraxu bésub Mucc ba. ");
INSERT INTO wolmbs_vpl VALUES ("EX12_22","003_12_22","EXO","12","22","22","Dangeen di jël ab takku cari isob, capp ci deret ji ci ndab li, diw ci seen njëël bunt ak seen ñaari jëni bunt, te bu kenn ci yeen wees buntu këram ba bët set. ");
INSERT INTO wolmbs_vpl VALUES ("EX12_23","003_12_23","EXO","12","23","23","Su ko defee, bu Aji Sax jiy wër ci biir réew mi, di faat waa Misra, ba gis deret ji taq ci seen njëël bunt ak seen ñaari jëni bunt, day teggi bunt ba, te du bàyyi malaakam reykat bi, mu dugg seeni kër, di reye. ");
INSERT INTO wolmbs_vpl VALUES ("EX12_24","003_12_24","EXO","12","24","24","«Nangeen sàmmonteek loolu, muy dogal bu leen war fàww, yeen ak seen askan. ");
INSERT INTO wolmbs_vpl VALUES ("EX12_25","003_12_25","EXO","12","25","25","Keroog bu ngeen duggee nag ca réew ma leen Aji Sax ji jox, na mu leen ko dige woon, nangeen sàmmonteek jooju aada. ");
INSERT INTO wolmbs_vpl VALUES ("EX12_26","003_12_26","EXO","12","26","26","Te bu leen seeni doom laajee ne leen: “Lu aada jii di wund?” ");
INSERT INTO wolmbs_vpl VALUES ("EX12_27","003_12_27","EXO","12","27","27","waxleen ne leen: “Loolu sarax la ñeel Aji Sax ji ngir bésub Mucc ba, ndax la mu teggi woon këri bànni Israayil ca Misra, kera ba muy faat waa Misra te musal ca sunuy kër.”» Ba mu waxee loolu ba noppi, mbooloo ma sujjóot, màggal Yàlla. ");
INSERT INTO wolmbs_vpl VALUES ("EX12_28","003_12_28","EXO","12","28","28","La Aji Sax ji santoon Musaa ak Aaróona, noonu rekk la ko bànni Israayil defe. ");
INSERT INTO wolmbs_vpl VALUES ("EX12_29","003_12_29","EXO","12","29","29","Ca xaaju guddi la Aji Sax ji faat mboolem taawi réewum Misra yu góor, dale ko ca taaw bu góor bu Firawna, ma toog ca jal ba, ba ca taaw yu góor yu nit ña ñu tëj kaso, boole ca lépp luy taaw bu góor ca jur ga. ");
INSERT INTO wolmbs_vpl VALUES ("EX12_30","003_12_30","EXO","12","30","30","Firawna nag jóg ca guddi ga, moom ak dagam yépp ak waa Misra gépp, yuux gu réy jibe ca Misra, ndax këroo kër, du genn gu nit deewul. ");
INSERT INTO wolmbs_vpl VALUES ("EX12_31","003_12_31","EXO","12","31","31","Ba loolu amee Firawna woolu Musaak Aaróona ca guddi googu, ne leen: «Ayca! Mott! Soreleen sama waa réew, yeen ak seeni bokk! Laggleen, jaamuji Aji Sax ji, li ngeen bëgg. ");
INSERT INTO wolmbs_vpl VALUES ("EX12_32","003_12_32","EXO","12","32","32","Te itam yóbbaaleleen seen juroo jur, gu gudd ak gu gàtt, li ngeen bëgg rekk, te ne mott! Waaye ñaanaaleleen ma seen Yàlla nag, mu barkeel ma.» ");
INSERT INTO wolmbs_vpl VALUES ("EX12_33","003_12_33","EXO","12","33","33","Ba mu ko defee waa Misra soññ bànni Israayil, ngir ñu gaaw génn réew ma, ndax booba ña nga naan: «Nun ñépp ay dee!» ");
INSERT INTO wolmbs_vpl VALUES ("EX12_34","003_12_34","EXO","12","34","34","Loolu tax mbooloom Israayil roñ seen xiiwi sunguf yu amagul lawiir. Ñu ëmb seen ndabi nootukaay ca seeni malaan, gàddu. ");
INSERT INTO wolmbs_vpl VALUES ("EX12_35","003_12_35","EXO","12","35","35","Fekk na bànni Israayil def la leen Musaa santoon ca waa Misra. Sàkku nañu ca ñoom ay gànjari xaalis ak wurus aki yére. ");
INSERT INTO wolmbs_vpl VALUES ("EX12_36","003_12_36","EXO","12","36","36","Aji Sax ji nag def waa Misra nangul bànni Israayil, ba jox leen la ñu sàkku; noonu lañu futtee waa Misra. ");
INSERT INTO wolmbs_vpl VALUES ("EX12_37","003_12_37","EXO","12","37","37","Ci kaw loolu bànni Israayil jóge dëkk ba ñuy wax Ramses, jëm Sukkót. Ña nga tollu ci juróom benni téeméeri junniy góor (600 000) te limaaleesul jigéen ñaak xale ya. ");
INSERT INTO wolmbs_vpl VALUES ("EX12_38","003_12_38","EXO","12","38","38","Amoon na it mbooloom nit ñu ànd ak ñoom, te di askan yu raxe, ak jur gu bare, gu gudd ak gu gàtt. ");
INSERT INTO wolmbs_vpl VALUES ("EX12_39","003_12_39","EXO","12","39","39","Ñu daldi lakk mburu mu tàppandaar ca xiiw wu amul lawiir, wa ñu jële Misra. La taxoon xiiw wa ñàkk lawiir mooy dañu leena dàqe Misra, ba taluñu woona fàggu lu ñu lekk. ");
INSERT INTO wolmbs_vpl VALUES ("EX12_40","003_12_40","EXO","12","40","40","Diir ba bànni Israayil nekk Misra tollu na ci ñeenti téeméeri at ak fanweer (430). ");
INSERT INTO wolmbs_vpl VALUES ("EX12_41","003_12_41","EXO","12","41","41","Keroog ca bés, ba ñeenti téeméeri at ya ak fanweer matee sëkk, ca la ñoñi Aji Sax ji génn réewum Misra, kuréel ci kaw kuréel. ");
INSERT INTO wolmbs_vpl VALUES ("EX12_42","003_12_42","EXO","12","42","42","Guddig keroog guddig teewlu la, ñeel Aji Sax ji, ngir moo leen ca génne réewum Misra, moo tax guddi googu di gu ñu jagleel Aji Sax ji, bànni Israayil gépp war cee fanaanee teewlu, ñeel Aji Sax ji, ba fàww. ");
INSERT INTO wolmbs_vpl VALUES ("EX12_43","003_12_43","EXO","12","43","43","Gannaaw loolu Aji Sax ji dafa wax ak Musaa ak Aaróona, ne leen: «Li ma dogal ci saraxu bésub Mucc bi mooy lii. Benn doxandéem du ci lekk. ");
INSERT INTO wolmbs_vpl VALUES ("EX12_44","003_12_44","EXO","12","44","44","Waaye bépp jaam bu ñu jënd te mu xasa xaraf, man na cee lekk. ");
INSERT INTO wolmbs_vpl VALUES ("EX12_45","003_12_45","EXO","12","45","45","Benn màngaan mbaa liggéeykat bu ñu bind it du ci lekk. ");
INSERT INTO wolmbs_vpl VALUES ("EX12_46","003_12_46","EXO","12","46","46","Genn kër lees koy lekke; bu lenn ci yàpp wi génn kër gi, te deesu ci damm benn yax sax. ");
INSERT INTO wolmbs_vpl VALUES ("EX12_47","003_12_47","EXO","12","47","47","Mboolem ku bokk ci bànni Israayil, na def sarax bi. ");
INSERT INTO wolmbs_vpl VALUES ("EX12_48","003_12_48","EXO","12","48","48","Su fekkee ne ab doxandéem bu ngeen dëkkal dafa bëgga wormaal màggalu bésub Mucc ngir Aji Sax ji, xaraf war na ko, te war na gépp góor gu bootu ci moom; su loolu amee, dees na ko may, mu def ko, ndax kon day mel ni doomu réew mi. Waaye kenn ku xaraful du ci lekk. ");
INSERT INTO wolmbs_vpl VALUES ("EX12_49","003_12_49","EXO","12","49","49","Dogal bi benn lay doon, doomu réew mi ak doxandéem bi dëkk ci seen biir, bokk ci yem kepp.» ");
INSERT INTO wolmbs_vpl VALUES ("EX12_50","003_12_50","EXO","12","50","50","La Aji Sax ji santoon Musaak Aaróona, noonu rekk la ko bànni Israayil defe. ");
INSERT INTO wolmbs_vpl VALUES ("EX12_51","003_12_51","EXO","12","51","51","Bésub keroog boobee la Aji Sax ji yiwi bànni Israayil, ñu def kuréel ci kaw kuréel, génn réewum Misra. ");
INSERT INTO wolmbs_vpl VALUES ("EX13_1","003_13_1","EXO","13","1","1","Aji Sax ji waxaat Musaa, ne ko: ");
INSERT INTO wolmbs_vpl VALUES ("EX13_2","003_13_2","EXO","13","2","2","«Nanga ma sédde bépp taaw bu góor, nit ak mala, lépp lu njëkka juddu ci bànni Israayil, maa moom.» ");
INSERT INTO wolmbs_vpl VALUES ("EX13_3","003_13_3","EXO","13","3","3","Musaa ne mbooloo ma: «Fàttalikuleen bésub tey jii ngeen génne Misra, kërug njaam gi, ak ni leen Aji Sax ji yiwee dooley loxoom. Bu ci kenn lekk mburu mu am lawiir. ");
INSERT INTO wolmbs_vpl VALUES ("EX13_4","003_13_4","EXO","13","4","4","Yeena ngii tey di dem seen yoon ci weeru Abiib. ");
INSERT INTO wolmbs_vpl VALUES ("EX13_5","003_13_5","EXO","13","5","5","Kon keroog bu leen Aji Sax ji yóbboo réewum Kanaaneen ña ak Etteen ña ak Amoreen ña ak Eween ña ak Yebuseen ña, fa mu giñaloon seeni maam, ne dina leen ko jox, réew mu meew maak lem ja tuuroo, nangeen wormaal màggal gi ci wii weer te ngeen di ko defe nii. ");
INSERT INTO wolmbs_vpl VALUES ("EX13_6","003_13_6","EXO","13","6","6","«Diiru juróom ñaari fan ngeen di lekk mburu mu amul lawiir, te na bésub juróom ñaareel ba di bésu màggalug Aji Sax ji. ");
INSERT INTO wolmbs_vpl VALUES ("EX13_7","003_13_7","EXO","13","7","7","Mburu mu amul lawiir ngeen di lekk diiru juróom ñaari fan; te it bu lenn lu am lawiir mbaa lawiir sax am fenn ci seen biir réew. ");
INSERT INTO wolmbs_vpl VALUES ("EX13_8","003_13_8","EXO","13","8","8","Bu keroogee na ku nekk xamal doomam, ne ko: “La ma Aji Sax ji defaloon, ba ma génnee Misra, moo waral lii tey.” ");
INSERT INTO wolmbs_vpl VALUES ("EX13_9","003_13_9","EXO","13","9","9","«Na màggal googu di pàttaliku ci yeen. Na mel ni màndarga mu nekk ci seen loxo ak seen jë. Su ko defee ngeen saxoo jàngale yoonu Aji Sax ji, ndax ci dooley loxoom la leen Aji Sax ji génnee Misra. ");
INSERT INTO wolmbs_vpl VALUES ("EX13_10","003_13_10","EXO","13","10","10","Nangeen sàmmonteek bii dogal ci bésam, at mu nekk. ");
INSERT INTO wolmbs_vpl VALUES ("EX13_11","003_13_11","EXO","13","11","11","«Bu leen Aji Sax ji yóbboo nag réewum Kanaaneen ña, noonee mu leen ko giñale woon, yeen ak seeni maam, ba jox leen ko, ");
INSERT INTO wolmbs_vpl VALUES ("EX13_12","003_13_12","EXO","13","12","12","nangeen sédde Aji Sax ji lépp lu njëkka juddu, rendil ko ko: lépp luy góor lu seen jur taawloo, Aji Sax jeey boroom. ");
INSERT INTO wolmbs_vpl VALUES ("EX13_13","003_13_13","EXO","13","13","13","Waaye lépp lu mbaam-sëf taawloo, nangeen ko jote ab gàtt, mu wuutu ko. Bu ngeen ko jotul, nangeen damm loos wi. Te itam jotleen képp kuy taaw bu góor ci seeni doom. ");
INSERT INTO wolmbs_vpl VALUES ("EX13_14","003_13_14","EXO","13","14","14","Su ko defee, bu leen seen doom laajee ëllëg, ne leen: “Lii lu muy tekki?” ngeen wax ko ne ko: “Dooley loxol Aji Sax jee nu génne Misra, kërug njaam ga. ");
INSERT INTO wolmbs_vpl VALUES ("EX13_15","003_13_15","EXO","13","15","15","Ba Firawna tëwee, bañ noo bàyyi, nu dem, Aji Sax jee rey mboolem lu doon taaw bu góor ca réewum Misra, taawu nit ba ci taawu mala. Looloo waral nuy rendil Aji Sax ji mépp mala mu njëkka juddu, di góor, sunu bépp taaw bu góor it, ñu war koo jote sarax su nu koy rendil.” ");
INSERT INTO wolmbs_vpl VALUES ("EX13_16","003_13_16","EXO","13","16","16","Na yooyu sarax mel ni màndarga mu nekk ci seen loxo ak seen jë, di leen fàttali ni nu Aji Sax ji génnee Misra ci dooley loxoom.» ");
INSERT INTO wolmbs_vpl VALUES ("EX13_17","003_13_17","EXO","13","17","17","Firawna bàyyi na mbooloo ma, ñu dem, waaye Yàlla jaaralewu leen ca yoon wa jëm réewu Filisti, doonte moo gënoona gàtt. Booba Yàlla dafa xam ne, su mbooloo ma sóoboo ci ay xare ci woowu yoon, dañuy yoqi, bay xalaata dëpp, dellu Misra. ");
INSERT INTO wolmbs_vpl VALUES ("EX13_18","003_13_18","EXO","13","18","18","Moo tax Yàlla wiiriloo mbooloo ma, ñu jaare ca màndiŋ ma, jëm ca géeju Barax ya. Ba mu ko defee bànni Israayil fagaru ba jekk, daldi génn Misra. ");
INSERT INTO wolmbs_vpl VALUES ("EX13_19","003_13_19","EXO","13","19","19","Musaa nag yóbbaale yaxi Yuusufa, ma giñloo woon bànni Israayil, ne leen: «Yàlla dina leen geesu moos, te bu keroogee nangeen fi jële samay yax, yóbbaale.» ");
INSERT INTO wolmbs_vpl VALUES ("EX13_20","003_13_20","EXO","13","20","20","Ñu bàyyikoo Sukkót, dal Etam ca wetu màndiŋ ma. ");
INSERT INTO wolmbs_vpl VALUES ("EX13_21","003_13_21","EXO","13","21","21","Bu bëccëgee nag Aji Sax ji nekk ci seen kanam ci biir taxaaru niir, di leen jiite ca yoon wa, te bu guddee mu nekk ci biir taxaaru sawara, di leen leeral, ba ñu mana dem guddi ak bëccëg. ");
INSERT INTO wolmbs_vpl VALUES ("EX13_22","003_13_22","EXO","13","22","22","Du bëccëg bu niir wa jóge ca kanam mbooloo ma, te du guddi it gu sawara wa masa wuute. ");
INSERT INTO wolmbs_vpl VALUES ("EX14_1","003_14_1","EXO","14","1","1","Aji Sax ji waxati Musaa, ne ko: ");
INSERT INTO wolmbs_vpl VALUES ("EX14_2","003_14_2","EXO","14","2","2","«Waxal bànni Israayil, ne leen ñu walbatiku dali fa jàkkaarlook Pi Axirot, ca diggante Migdol ak géeju Barax ya. Dalleen foofa jàkkaarlook Baal Cefon ca tefes ga. ");
INSERT INTO wolmbs_vpl VALUES ("EX14_3","003_14_3","EXO","14","3","3","Su ko defee Firawna da naan: “Bànni Israayil de dañoo réer ci àll bi, ba faf keppu ci màndiŋ mi.” ");
INSERT INTO wolmbs_vpl VALUES ("EX14_4","003_14_4","EXO","14","4","4","Gannaaw loolu maay dëgëral boppu Firawna, mu topp leen, ba ma jaare ca siiwal sama ndam, ndax maay daan Firawnaaki xarekatam yépp, te waa Misra dinañu xam ne, man maay Aji Sax ji.» Musaa jottali leen ko, ñu def noona. ");
INSERT INTO wolmbs_vpl VALUES ("EX14_5","003_14_5","EXO","14","5","5","Ba ñu yégalee Firawna buuru Misra, ne mbooloo ma daw na, mooki dagam dañoo soppi xalaat ca mbirum bànni Israayil. Ñu ne: «Waaw nun, li nu def nag? Ana luy ndeyi yiwi bànni Israayil, ba dootuñu nu surgawu?» ");
INSERT INTO wolmbs_vpl VALUES ("EX14_6","003_14_6","EXO","14","6","6","Firawna takklu watiiru xareem, ànd aki jàmbaaram. ");
INSERT INTO wolmbs_vpl VALUES ("EX14_7","003_14_7","EXO","14","7","7","Mboolem watiiri xarey Misra la yóbbu, jiital juróom benni téeméer (600), ya ca gën, bu ci nekk yeb ay kilifay xarekat. ");
INSERT INTO wolmbs_vpl VALUES ("EX14_8","003_14_8","EXO","14","8","8","Aji Sax jee dëgëral boppu Firawna buuru Misra, mu toppi bànni Israayil, fekk bànni Israayil ñoom, ña ngay génn réew ma ci seen teeyug bakkan. ");
INSERT INTO wolmbs_vpl VALUES ("EX14_9","003_14_9","EXO","14","9","9","Waa Misra topp leen, ñook fasi Firawna yépp, ak watiiri xareem ak dawalkatam yaak xarekatam ya, ba dab leen fa ñu dal ca tefesu géeju Barax ya, fa jàkkaarlook Baal Cefon ca wetu Pi Axirot. ");
INSERT INTO wolmbs_vpl VALUES ("EX14_10","003_14_10","EXO","14","10","10","Firawnaa ngay jubsi, bànni Israayil séentu, yemuñu ci ñu moy waa Misra, ñu dikk, jubsi leen. Tiitaange ju réy jàpp bànni Israayil. Ñu woo Aji Sax ji wall. ");
INSERT INTO wolmbs_vpl VALUES ("EX14_11","003_14_11","EXO","14","11","11","Ci biir loolu ñu ne Musaa: «Xanaa Misra dafa amul ay sëg, ba nga di nu indi ci màndiŋ mi, nu deesi fi? Loo nu doon génnee Misra? ");
INSERT INTO wolmbs_vpl VALUES ("EX14_12","003_14_12","EXO","14","12","12","Xanaa du lii lanu la waxoon ca Misra? Noon nanu la, nga bàyyi nu, nu surgawu waa Misra, ndax surgawu waa Misra moo nu gënal nu dee ci màndiŋ mi!» ");
INSERT INTO wolmbs_vpl VALUES ("EX14_13","003_14_13","EXO","14","13","13","Musaa nag ne mbooloo ma: «Buleen tiit, neleen tekk te xool li Aji Sax jiy def, ba xettali leen tey jii. Ndax kat waa Misra yii ngeen di gis nii tey, dootuleen leen gis mukk. ");
INSERT INTO wolmbs_vpl VALUES ("EX14_14","003_14_14","EXO","14","14","14","Aji Sax ji moo leen di xeexal, yeen kay neleen tekk rekk.» ");
INSERT INTO wolmbs_vpl VALUES ("EX14_15","003_14_15","EXO","14","15","15","Ci kaw loolu Aji Sax ji wax Musaa ne ko: «Loo may woowe wall? Waxal bànni Israayil, ne leen ñu dem rekk, ");
INSERT INTO wolmbs_vpl VALUES ("EX14_16","003_14_16","EXO","14","16","16","te yaw nanga yékkati saw yet, tàllal sa loxo mu tiim géej gi, ba xàll ko, ndax bànni Israayil mana dox ci suuf su wow, jàll géej gi. ");
INSERT INTO wolmbs_vpl VALUES ("EX14_17","003_14_17","EXO","14","17","17","Man nag maay dëgëral boppu waa Misra, ba ñu dugg, topp leen. Su ko defee ma siiwal sama ndam, ndax dinaa yar Firawnaaki xarekatam yépp, boole ci watiiri xareem aki gawaram. ");
INSERT INTO wolmbs_vpl VALUES ("EX14_18","003_14_18","EXO","14","18","18","Bu ma dumaa Firawna, boole kooki watiiram aki gawaram, ba doxe fa siiwal sama ndam, waa Misra dinañu xam ne man maay Aji Sax ji.» ");
INSERT INTO wolmbs_vpl VALUES ("EX14_19","003_14_19","EXO","14","19","19","Ci kaw loolu malaakam Yàlla, ma féete woon xarekati Israayil kanam naka jekk te di leen jiite, daldi toxu, féete leen gannaaw. Niir wa leen jiitu woon it walbatiku, taxaw ca seen gannaaw, ");
INSERT INTO wolmbs_vpl VALUES ("EX14_20","003_14_20","EXO","14","20","20","dox diggante dalu waa Misra ak dalu bànni Israayil. Niir waa nga lëndëme genn wet, wet ga ca des di leer ca guddi ga, ba tax guddi ga gépp benn dal manula fekki moroom ma. ");
INSERT INTO wolmbs_vpl VALUES ("EX14_21","003_14_21","EXO","14","21","21","Gannaaw ga, Musaa tàllal loxoom, mu tiim géej ga, Aji Sax ji yebal ngelawal penku lu réy guddi ga gépp, jañaxe ko géej ga, ndox ya xàjjalikoo, ba suuf su wow feeñ. ");
INSERT INTO wolmbs_vpl VALUES ("EX14_22","003_14_22","EXO","14","22","22","Bànni Israayil nag dugg ca biir géej ga, di dox ci kaw suuf su wow, ndox ya ne sàtt, ñagal leen ndijoor ak càmmoñ. ");
INSERT INTO wolmbs_vpl VALUES ("EX14_23","003_14_23","EXO","14","23","23","Ba mu ko defee waa Misra daw topp ca ñoom, fasi Firawna ak watiiri xareem aki gawaram ànd, ñoom ñépp ne yentem ca biir géej ga. ");
INSERT INTO wolmbs_vpl VALUES ("EX14_24","003_14_24","EXO","14","24","24","Ba njël jotee Aji Sax ji dafa tollu ci biir taxaaru sawara wu ànd aku niir, di xool xarekati Misra, tiital leen, ñu fëlxoo. ");
INSERT INTO wolmbs_vpl VALUES ("EX14_25","003_14_25","EXO","14","25","25","Mu boole ca téye mbegey watiir ya, ba neexatuñoo dawal. Waa Misra ne: «Nan daw gaaw, ba rëcc bànni Israayil, ndax kat Aji Sax ji moo leen di xeexal, te moo dal ci sunu kaw!» ");
INSERT INTO wolmbs_vpl VALUES ("EX14_26","003_14_26","EXO","14","26","26","Aji Sax ji nag wax Musaa ne ko: «Tàllalal sa loxo, mu tiim géej gi, ndax ndox mi délsi, ba sottiku ci kaw waa Misra, ñook seen watiiri xare ak seeni gawar.» ");
INSERT INTO wolmbs_vpl VALUES ("EX14_27","003_14_27","EXO","14","27","27","Musaa tàllal loxoom, mu tiim géej ga. Ba bët di set géej ga dellu na, mel na mu meloon. Waa Misra di daw, géej ga wal, dogale leen, Aji Sax ji fél leen, ñu ne ca menteñ. ");
INSERT INTO wolmbs_vpl VALUES ("EX14_28","003_14_28","EXO","14","28","28","Ndox ma daa délsi, boole mëdd watiiri xare yaak gawar ya, mboolem xarekati Firawna ya leen toppoon ca biir géej ga rekk. Kenn rëccul. ");
INSERT INTO wolmbs_vpl VALUES ("EX14_29","003_14_29","EXO","14","29","29","Waaye bànni Israayil ñoom, ci suuf su wow lañu jaare ca digg géej ga, jàll, ndox ya ne sàtt, ñagal leen ndijoor ak càmmoñ. ");
INSERT INTO wolmbs_vpl VALUES ("EX14_30","003_14_30","EXO","14","30","30","Noona la Aji Sax ji xettalee bànni Israayil bésub keroog ca waa Misra, ñu gis néewi waa Misra ya ne wetar ca tefes ga. ");
INSERT INTO wolmbs_vpl VALUES ("EX14_31","003_14_31","EXO","14","31","31","Ba Israayil gisee ni Aji Sax ji jowe loxoom bu baax ca xareem baak waa Misra, dañu daldi ragal Aji Sax ji, teg ca am kóolute ci Aji Sax ji ak ci Musaa, jaamam ba. ");
INSERT INTO wolmbs_vpl VALUES ("EX15_1","003_15_1","EXO","15","1","1","Ba loolu amee nag Musaa ak bànni Israayil woy Aji Sax ji, màggal ko. Ña nga naan: «Ma woy Aji Sax ji, ngir ndamam li kawee kawe. Fas ak gawaram la fab, xalab géej. ");
INSERT INTO wolmbs_vpl VALUES ("EX15_2","003_15_2","EXO","15","2","2","Sama doole, sama kaaraange, Ki Sax a; te mooy sama wall tey. Mooy sama Yàlla, ji may tagge, sama Yàllay maam, ji may joobe. ");
INSERT INTO wolmbs_vpl VALUES ("EX15_3","003_15_3","EXO","15","3","3","«Aji Sax ji jàmbaari xare ji, Aji Sax jeey turam! ");
INSERT INTO wolmbs_vpl VALUES ("EX15_4","003_15_4","EXO","15","4","4","Watiiri Firawnaaki xarekatam la fab sànni géej; ñeyi xareem ya labandoo ca géeju Barax ya, ");
INSERT INTO wolmbs_vpl VALUES ("EX15_5","003_15_5","EXO","15","5","5","xóote ya boole sàng, ñu ne ca biir menteñ niw doj. ");
INSERT INTO wolmbs_vpl VALUES ("EX15_6","003_15_6","EXO","15","6","6","«Aji Sax ji, sa kàttanu ndijoor a yéeme! Aji Sax ji, sa ndijoor a ne noon ba rajax. ");
INSERT INTO wolmbs_vpl VALUES ("EX15_7","003_15_7","EXO","15","7","7","Sa màggaay gu yéemee nërmeel say noon. Yaa yebal sa mer, mu ne jippét, xoyom leen ni boob. ");
INSERT INTO wolmbs_vpl VALUES ("EX15_8","003_15_8","EXO","15","8","8","Nga wal sag noo, ndox ya tegloo, wal ma ne sàtt, jaloo jalu, ndoxi xóotey géej way deeŋ! ");
INSERT INTO wolmbs_vpl VALUES ("EX15_9","003_15_9","EXO","15","9","9","«Noon baa nga naa: “Maay dàqe, dabe, lël alal ja, séddale, séddu, ba xol sedd, ne saamar boset, teg leen loxo.” ");
INSERT INTO wolmbs_vpl VALUES ("EX15_10","003_15_10","EXO","15","10","10","Waaye sa ngelaw nga wal, géej mëdd leen, ñu diigandoo ni betteex biir géej mbàmbulaan! ");
INSERT INTO wolmbs_vpl VALUES ("EX15_11","003_15_11","EXO","15","11","11","«Ana kuy sa moroom ci tuur yi, yaw Aji Sax ji? Kuy sa dend, yaak sa sellaay bu yéeme, sa yànjaay bu raglook sa jëf yu yéeme? ");
INSERT INTO wolmbs_vpl VALUES ("EX15_12","003_15_12","EXO","15","12","12","Yaa tàllal sa ndijoor, suuf wann leen. ");
INSERT INTO wolmbs_vpl VALUES ("EX15_13","003_15_13","EXO","15","13","13","«Sa ngor nga jiitee mbooloo, mi nga jot, te sa kàttan nga leen di yóbboo ca sa kër gu sell. ");
INSERT INTO wolmbs_vpl VALUES ("EX15_14","003_15_14","EXO","15","14","14","Jàmbur ñay dégg, di rag-ragi, tiitaange ne taral waa Filisti, ");
INSERT INTO wolmbs_vpl VALUES ("EX15_15","003_15_15","EXO","15","15","15","kilifay waa Edom jàq, njiiti Mowab di kat-kati, mboolem waa Kanaan tiit, ne yasar; ");
INSERT INTO wolmbs_vpl VALUES ("EX15_16","003_15_16","EXO","15","16","16","tiitaangeek njàqaree ne milib ca seen kaw. Sa kàttan a tax ñu mel niw doj, ne yàcc, ba kera sa ñoñ jàll, Aji Sax ji, ba kera askan wa nga goreel, jàll, ");
INSERT INTO wolmbs_vpl VALUES ("EX15_17","003_15_17","EXO","15","17","17","te yaa leen di sampi ca sa tund wa nga séddoo, fa nga waajal sa dëkkuwaay, Aji Sax ji, béreb bu sell ba nga sàkke sa loxol bopp, Boroom bi. ");
INSERT INTO wolmbs_vpl VALUES ("EX15_18","003_15_18","EXO","15","18","18","Aji Sax jeey Buur, tey ak ëllëg ba fàww.» ");
INSERT INTO wolmbs_vpl VALUES ("EX15_19","003_15_19","EXO","15","19","19","Ci kaw loolu fasi Firawna ànd ak watiiri xareem aki gawaram, tàbbi géej, Aji Sax ji delloo ndoxi géej ga ca seen kaw, bànni Israayil ñoom, jaare joor gu wow ca digg géej ga. ");
INSERT INTO wolmbs_vpl VALUES ("EX15_20","003_15_20","EXO","15","20","20","Yonent Yàlla Maryaama, jigéenub Aaróona nag yore tabala, jigéen ñépp topp ko, génn di fecc, tabala ya jiin. ");
INSERT INTO wolmbs_vpl VALUES ("EX15_21","003_15_21","EXO","15","21","21","Maryaamaa nga leen di dëbbeel, naa: «Woyleen Aji Sax ji, ngir ndamam li kawee kawe. Fas ak gawaram la fab, xalab géej.» ");
INSERT INTO wolmbs_vpl VALUES ("EX15_22","003_15_22","EXO","15","22","22","Gannaaw loolu Musaa jële bànni Israayil géeju Barax ya, ñu wéy, wuti màndiŋ, ma ñuy wax Sur. Dox nañu ñetti fan ca màndiŋ ma, gisuñu ndox. ");
INSERT INTO wolmbs_vpl VALUES ("EX15_23","003_15_23","EXO","15","23","23","Ñu dem, ba àgg fu ñu naan Maara, waaye manuñoo naan ca ndoxum Maara, ndax wex. Looloo waral ñu tudde béreb ba Maara (muy firi Fu wex). ");
INSERT INTO wolmbs_vpl VALUES ("EX15_24","003_15_24","EXO","15","24","24","Mbooloo ma nag di diiŋat Musaa, naan: «Ana ndox mu nuy naan nag?» ");
INSERT INTO wolmbs_vpl VALUES ("EX15_25","003_15_25","EXO","15","25","25","Musaa woo Aji Sax ji wall, Aji Sax ji won ko dammitu bant, mu sànni ko ca ndox ma, ndox ma neex. Foofa la Aji Sax ji dogalal bànni Israayil ay sàrti yoon ak ndigal, te fa la leen nattoo itam. ");
INSERT INTO wolmbs_vpl VALUES ("EX15_26","003_15_26","EXO","15","26","26","Da ne leen: «Bu ngeen farloo ci déggal seen Yàlla Aji Sax ji, di def li mu rafetlu, di teewlu tey jëfe ay santaaneem, di sàmm bépp dogali yoonam, su boobaa duma leen teg lenn ci jàngoro yi ma tegoon waa Misra, ndax man maay Aji Sax ji leen di wérloo.» ");
INSERT INTO wolmbs_vpl VALUES ("EX15_27","003_15_27","EXO","15","27","27","Ci kaw loolu ñu dem ba Elim, fekk fa fukki bëti ndox ak ñaar, ak juróom ñaar fukki garabi tàndarma. Ñu dal foofa ca wetu ndox ma. ");
INSERT INTO wolmbs_vpl VALUES ("EX16_1","003_16_1","EXO","16","1","1","Gannaaw gi, mbooloom bànni Israayil gépp bàyyikoo fa Elim, dem, ba keroog fukki fan ak juróom, ca weer wa topp ca wa ñu génne réewum Misra, ñu doora agsi màndiŋu Sin diggante Elim ak Sinayi. ");
INSERT INTO wolmbs_vpl VALUES ("EX16_2","003_16_2","EXO","16","2","2","Mbooloom bànni Israayil gépp nag di diiŋat Musaa ak Aaróona ca màndiŋ ma. ");
INSERT INTO wolmbs_vpl VALUES ("EX16_3","003_16_3","EXO","16","3","3","Ña nga naa leen: «Céy ngalla nun, su nu sañoon dee, Yàlla moom nu ca réewum Misra, fa nu daan uufe cini yàpp, ñam wa ne gàññ, nu suur këll. Yeena nu indi ba ci màndiŋ mii, ngeen nara xiifloo mbooloo mii mépp, ba ñu dee.» ");
INSERT INTO wolmbs_vpl VALUES ("EX16_4","003_16_4","EXO","16","4","4","Ba loolu amee Aji Sax ji wax Musaa ne ko: «Maa ngi nii di tawal bànni Israayil ñam wu jóge asamaan, te na mbooloo mi dem bés bu set, fori njëlu bés ak bés. Ma nattu leen ci, ba xam ndax dinañu doxe sama ndigalu yoon am déet. ");
INSERT INTO wolmbs_vpl VALUES ("EX16_5","003_16_5","EXO","16","5","5","Waaye bu ñu demee ba bésub juróom benneel ba, ba togg la ñu ca indi, day tollook ñaar-cay dayo ba ñuy for bés bu set.» ");
INSERT INTO wolmbs_vpl VALUES ("EX16_6","003_16_6","EXO","16","6","6","Musaa ak Aaróona nag xamal bànni Israayil ne leen: «Bu ngoonee dingeen xam ne, Aji Sax ji moo leen génne réewum Misra, ");
INSERT INTO wolmbs_vpl VALUES ("EX16_7","003_16_7","EXO","16","7","7","te bu bët setee dingeen gis manoorey Aji Sax ji, ndaxte dégg na ngeen di diiŋat Aji Sax ji, ndax nun kat tekkiwunu dara, ba ngeen di nu diiŋat.» ");
INSERT INTO wolmbs_vpl VALUES ("EX16_8","003_16_8","EXO","16","8","8","Musaa teg ca ne: «Moo tax Aji Sax ji dina leen jox yàpp wu ngeen lekk ngoon, te bu bët setee mu jox leen ñam wu leen reggal, ndax Aji Sax jee dégg ngeen di ko diiŋat. Nun lu nu ci? Du nun ngeen di diiŋat waaye yeen ak Aji Sax ji la.» ");
INSERT INTO wolmbs_vpl VALUES ("EX16_9","003_16_9","EXO","16","9","9","Ba loolu wéyee Musaa ne Aaróona: «Waxal mbooloom bànni Israayil gépp, ne leen ñu dem ba ca kanam Aji Sax ji, ndaxte dégg na seeni diiŋat.» ");
INSERT INTO wolmbs_vpl VALUES ("EX16_10","003_16_10","EXO","16","10","10","Naka la Aaróona di wax ak mbooloom Israayil mépp, ñu jekki ne gees ca màndiŋ ma, daldi yem ci aw niir, leeru Aji Sax ji di ca feeñ. ");
INSERT INTO wolmbs_vpl VALUES ("EX16_11","003_16_11","EXO","16","11","11","Aji Sax ji wax Musaa ne ko: ");
INSERT INTO wolmbs_vpl VALUES ("EX16_12","003_16_12","EXO","16","12","12","«Dégg naa diiŋati bànni Israayil. Wax leen ne leen, diggante ngoon ak jant bu so, dinañu lekk yàpp, te bu bët setee ñu lekk aw ñam, ba regg, ndax ñu xam ne man Aji Sax ji, maay seen Yàlla.» ");
INSERT INTO wolmbs_vpl VALUES ("EX16_13","003_16_13","EXO","16","13","13","Ba ngoon jotee ay picci përëntaan dikk, fees dal ba. Ba bët setee lay bay wàcc ca dal ba. ");
INSERT INTO wolmbs_vpl VALUES ("EX16_14","003_16_14","EXO","16","14","14","Naka la lay ba bàcc, ñu jekki gis lu sew lale ca màndiŋ ma, def fepp yu sew ca biir, te mel ni tawub yuur, tege ca suuf. ");
INSERT INTO wolmbs_vpl VALUES ("EX16_15","003_16_15","EXO","16","15","15","Bànni Israayil gis ko, di wax ca seen biir naan: «Lii lu mu?» ndax xamuñu woon lu mu doon. Musaa ne leen: «Lii mooy ñam wi leen Aji Sax ji jox, ngeen lekk. ");
INSERT INTO wolmbs_vpl VALUES ("EX16_16","003_16_16","EXO","16","16","16","Aji Sax ji dafa santaane ne: “Na ku nekk for lu mat njëlam, bopp bu ne andaar, te mu natt ko ci limu nit, ñi mu bokkal xayma.”» ");
INSERT INTO wolmbs_vpl VALUES ("EX16_17","003_16_17","EXO","16","17","17","Bànni Israayil def noona, ñii for lu bare, ñee lu néew. ");
INSERT INTO wolmbs_vpl VALUES ("EX16_18","003_16_18","EXO","16","18","18","Waaye ba ñu ko nattee ci andaar, ña sàkkoon lu bare amuñu lu ëpp, te ña sàkkoon lu néew yéeslewuñu. La ñu for dafa tolloo tembe ak seen njël. ");
INSERT INTO wolmbs_vpl VALUES ("EX16_19","003_16_19","EXO","16","19","19","Musaa ne leen: «Bu ci kenn wacc dara, mu fanaan.» ");
INSERT INTO wolmbs_vpl VALUES ("EX16_20","003_16_20","EXO","16","20","20","Waaye dégluwuñu Musaa, am na ñenn ca ñoom ñu ca wàññi, fanaanal, mu def ay sax, xasaw xunn. Musaa nag mere leen. ");
INSERT INTO wolmbs_vpl VALUES ("EX16_21","003_16_21","EXO","16","21","21","Suba su ñu xëyaan nag, ku nekk for ca njëlam, ndax bu naaj wa tàngaan, mu seey. ");
INSERT INTO wolmbs_vpl VALUES ("EX16_22","003_16_22","EXO","16","22","22","Ba bésu juróom benneel ba jotee, dañoo for lu mat ñaari njël, ku nekk am ñaari andaar, njiiti mbooloo ma nag dem yeggeji ko Musaa, ");
INSERT INTO wolmbs_vpl VALUES ("EX16_23","003_16_23","EXO","16","23","23","mu ne leen: «Loolu la Aji Sax ji wax, te li muy tekki mooy: ëllëg bésu dallu la, di bésub Noflaay bu sell ñeel Aji Sax ji. Lakkleen li ngeen di lakk, baxal li ngeen di baxal, te lu ci des, ngeen denc ba suba.» ");
INSERT INTO wolmbs_vpl VALUES ("EX16_24","003_16_24","EXO","16","24","24","Ba ñu dencee la ca des ba ca ëllëg sa, na ko Musaa santaanee, xasawul, saxewul. ");
INSERT INTO wolmbs_vpl VALUES ("EX16_25","003_16_25","EXO","16","25","25","Musaa wax leen ne leen: «Lekkleen li des tey, ndax tey jii bésub Noflaay la, ñeel Aji Sax ji, te dungeen ko gis tey ci àll bi. ");
INSERT INTO wolmbs_vpl VALUES ("EX16_26","003_16_26","EXO","16","26","26","Juróom benni fan ngeen koy for, waaye bésub juróom ñaareel bay bésub Noflaay, kenn du ko gis.» ");
INSERT INTO wolmbs_vpl VALUES ("EX16_27","003_16_27","EXO","16","27","27","Terewul mu am ñu fori ca bésub juróom ñaareel ba, waaye gisuñu dara. ");
INSERT INTO wolmbs_vpl VALUES ("EX16_28","003_16_28","EXO","16","28","28","Ca la Aji Sax ji wax Musaa ne ko: «Waaw yeen nag, dungeen ma noppee gàntalal samay santaaneek samay ndigali yoon mukk? ");
INSERT INTO wolmbs_vpl VALUES ("EX16_29","003_16_29","EXO","16","29","29","Nangeen xam xéll ne, man Aji Sax ji, maa leen may bésub Noflaay ngir ngeen noppalu, te looloo tax ma may leen dundub ñaari fan ci bésub juróom benneel bi. Kon nag bésub juróom ñaareel ba, na ku nekk toog fi mu nekk, bu ci kenn génnati fi mu dëkk.» ");
INSERT INTO wolmbs_vpl VALUES ("EX16_30","003_16_30","EXO","16","30","30","Ba loolu amee bànni Israayil di noppalu bésub juróom ñaareel ba. ");
INSERT INTO wolmbs_vpl VALUES ("EX16_31","003_16_31","EXO","16","31","31","Waa kër Israayil nag tudde ñam wa mànn (muy firi Lii lu mu?). Dafa meloon ni pepp mi ñuy wax koryanda, te weex, di saf lu mel ni nàkk bu ànd ak lem. ");
INSERT INTO wolmbs_vpl VALUES ("EX16_32","003_16_32","EXO","16","32","32","Ci biir loolu Musaa ne: «Aji Sax ji dafa santaane ne: “Sàkkleen ci andaar, denc ngir seeni sët ak seeni sëtaat. Su ko defee ñu gis ñam wi ma leen daan leel ca màndiŋ ma, gannaaw ba ma leen génnee réewum Misra.”» ");
INSERT INTO wolmbs_vpl VALUES ("EX16_33","003_16_33","EXO","16","33","33","Musaa wax Aaróona ne ko: «Fabal ndab, def ci andaaru mànn, teg ko fi kanam Aji Sax ji, dencal ko seeni sët ak seeni sëtaat.» ");
INSERT INTO wolmbs_vpl VALUES ("EX16_34","003_16_34","EXO","16","34","34","La Aji Sax ji santoon Musaa la Aaróona def, daldi koy teg ca kanam gaal gay def àlluway kóllëre ga, ñu denc ko fa. ");
INSERT INTO wolmbs_vpl VALUES ("EX16_35","003_16_35","EXO","16","35","35","Bànni Israayil dunde nañu mànn diiru ñeent fukki at, ba kera ñu agsee réew mu ay nit dëkke, gannaaw ba ñu jéggee kemu réewum Kanaan. ");
INSERT INTO wolmbs_vpl VALUES ("EX16_36","003_16_36","EXO","16","36","36","Ñu jàpp ne andaar, boo ci amee fukk, mooy benn efa. ");
INSERT INTO wolmbs_vpl VALUES ("EX17_1","003_17_1","EXO","17","1","1","Gannaaw loolu mbooloom bànni Israayil gépp bàyyikoo màndiŋu Sin, di dox aka taxaw, ci ndigalal Aji Sax ji. Ñu dem ba Refidim, dal fa. Foofa nag mbooloo ma amuñu woon ndox mu ñu naan. ");
INSERT INTO wolmbs_vpl VALUES ("EX17_2","003_17_2","EXO","17","2","2","Ñu jote faak Musaa, naan ko: «Joxleen nu nag ndox mu nu naan!» Musaa ne leen: «Ana lu ngeen joteek man? Aji Sax ji ngeen di seetlu nag?» ");
INSERT INTO wolmbs_vpl VALUES ("EX17_3","003_17_3","EXO","17","3","3","Mbooloo ma mar na fa, bay xultu ci kaw Musaa, naan: «Loo nu doon jële Misra nag, xanaa du boole nu rey ndax mar, nook sunuy doom ak sunuy gétt?» ");
INSERT INTO wolmbs_vpl VALUES ("EX17_4","003_17_4","EXO","17","4","4","Ba mu ko defee Musaa woo Aji Sax ji wall, ne ko: «Nu may def ak mbooloo mii? Des na tuuti de, ñu dóor ma ay doj, ba ma dee.» ");
INSERT INTO wolmbs_vpl VALUES ("EX17_5","003_17_5","EXO","17","5","5","Aji Sax ji ne Musaa «Àndal ak ñenn ci magi Israayil, nga jaar ci kanam mbooloo mi, yóbbaale yet, wa nga dóoroon ca dexu Niil ga. Jël ko te dem. ");
INSERT INTO wolmbs_vpl VALUES ("EX17_6","003_17_6","EXO","17","6","6","Man dinaa taxaw ci sa kanam ci doj woowu ca tundu Xoreb. Dóoral ci doj wi, su ko defee ndox dina ci génne, mbooloo mi naan.» Musaa def noona ca kanam magi Israayil ña. ");
INSERT INTO wolmbs_vpl VALUES ("EX17_7","003_17_7","EXO","17","7","7","Béreb boobu la Musaa woowe Maasa (muy firi Seetlu). Mu woowe ko itam Meriba (muy firi ab Jote), ndax joteb bànni Israayil ba fa amoon, ak na ñu fa seetloo Aji Sax ji, naan: «Moo, ndax Aji Sax ji mu ngi ci sunu biir, am déet?» ");
INSERT INTO wolmbs_vpl VALUES ("EX17_8","003_17_8","EXO","17","8","8","Ba loolu weesoo Amalegeen ña dikk, xareek bànni Israayil ca Refidim. ");
INSERT INTO wolmbs_vpl VALUES ("EX17_9","003_17_9","EXO","17","9","9","Musaa ne Yosuwe: «Tànnal nu ay xarekat te nga dem xeex ak Amaleg. Ëllëg dinaa taxaw ca kaw tund wa, yor yetu Yàlla wi ci sama loxo.» ");
INSERT INTO wolmbs_vpl VALUES ("EX17_10","003_17_10","EXO","17","10","10","Yosuwe def la ko Musaa wax, di xeex ak Amaleg. Musaa ak Aaróona ak Ur nag ànd yéeg ba ca kaw tund wa. ");
INSERT INTO wolmbs_vpl VALUES ("EX17_11","003_17_11","EXO","17","11","11","Ci kaw loolu saa yu Musaa yékkatee loxoom, Israayil man, saa yu wàccee loxo ba, Amaleg man. ");
INSERT INTO wolmbs_vpl VALUES ("EX17_12","003_17_12","EXO","17","12","12","Musaa nag mujj sonn ndax loxo yu toqi; ñu jël aw doj, tegal ko, mu toog ca, Aaróona ak Ur séq ko, ku ci nekk taawu benn loxo, loxoom ya ne sàtt taxaw, ba jant so. ");
INSERT INTO wolmbs_vpl VALUES ("EX17_13","003_17_13","EXO","17","13","13","Ba mu ko defee Yosuwe duma Amaleg ak mbooloom, leel leen ñawkay saamar. ");
INSERT INTO wolmbs_vpl VALUES ("EX17_14","003_17_14","EXO","17","14","14","Ba loolu amee Aji Sax ji wax Musaa ne ko: «Bindal lii xew cib téere, muy pàttali, te nga xamal Yosuwe ne ko, raafal laay def askanu Amaleg, ba ñu jeex tàkk, ba deesatu leen fàttaliku fu asamaan tiim.» ");
INSERT INTO wolmbs_vpl VALUES ("EX17_15","003_17_15","EXO","17","15","15","Musaa nag sàkk fa sarxalukaay, tudde ko tur wuy tekki «Aji Sax jeey sama raaya». ");
INSERT INTO wolmbs_vpl VALUES ("EX17_16","003_17_16","EXO","17","16","16","Booba la wax ne, gannaaw loxoo ñemee xàcc, jëm ci ngànguney Aji Sax ji, Aji Sax ji dootul noppee xareek Amaleg ba fàww. ");
INSERT INTO wolmbs_vpl VALUES ("EX18_1","003_18_1","EXO","18","1","1","Yettro sarxalkatu réewum Majan ba, baayu soxnas Musaa, dafa dégg mboolem la Yàlla defal Musaa ak bànni Israayil ñoñam ak ni Aji Sax ji génnee Israayil Misra. ");
INSERT INTO wolmbs_vpl VALUES ("EX18_2","003_18_2","EXO","18","2","2","Ci kaw loolu Yettro gorob Musaa, ànd ak Cipora soxnas Musaa, sa Musaa yebaloon ca kër baayam, ");
INSERT INTO wolmbs_vpl VALUES ("EX18_3","003_18_3","EXO","18","3","3","boole kook ñaari doomi Musaa yu góor ya, kenn ka di Gersom (muy firi Doxandéem fii), ndaxte Musaa da ne woon: «Doxandéem laa fii.» ");
INSERT INTO wolmbs_vpl VALUES ("EX18_4","003_18_4","EXO","18","4","4","Ka ca des mu tudde ko Elyeser (muy firi Yàlla dimbali na ma), ndax da ne woon: «Sama Yàllay baay mooy sama ndimbal te moo ma musal ci saamaru Firawna.» ");
INSERT INTO wolmbs_vpl VALUES ("EX18_5","003_18_5","EXO","18","5","5","Yettro, gorob Musaa nag yóbbul Musaa soxnaam aki doomam ba ca màndiŋ ma, fa Musaa dal ca wetu tundu Yàlla wa. ");
INSERT INTO wolmbs_vpl VALUES ("EX18_6","003_18_6","EXO","18","6","6","Mu yónnee ca Musaa, ne ko: «Man Yettro, sa goro, maa ñëw fi yaw, ànd ak sa soxna ak sa ñaari doom yu góor.» ");
INSERT INTO wolmbs_vpl VALUES ("EX18_7","003_18_7","EXO","18","7","7","Musaa génn gatandu ko, sujjóotal ko, fóon ko; ñu jàmmante ba noppi, doora dugg ca xayma ba. ");
INSERT INTO wolmbs_vpl VALUES ("EX18_8","003_18_8","EXO","18","8","8","Musaa nag nettali goroom mboolem li Aji Sax ji def Firawna ak waa Misra ndax Israayil, ak jafe-jafe, ya leen dab ca yoon wa yépp, ak na leen ca Aji Sax ji xettalee. ");
INSERT INTO wolmbs_vpl VALUES ("EX18_9","003_18_9","EXO","18","9","9","Yettro bég lool ca la Aji Sax ji def lépp, ba baaxe Israayil, xettali leen ca nooteelu waa Misra. ");
INSERT INTO wolmbs_vpl VALUES ("EX18_10","003_18_10","EXO","18","10","10","Yettro nag ne: «Cant ñeel na Aji Sax ji leen xettali ci nootaangey waa Misra ak nootaangey Firawna, xettaliwaale mbooloo mi ci nootaangey waa Misra. ");
INSERT INTO wolmbs_vpl VALUES ("EX18_11","003_18_11","EXO","18","11","11","Léegi nag xam naa ne, Aji Sax jee sut mboolem tuur yi, ndax la mu def, ba leen waa Misra toroxalee.» ");
INSERT INTO wolmbs_vpl VALUES ("EX18_12","003_18_12","EXO","18","12","12","Yettro, gorob Musaa, daldi sàkk saraxu rendi-dóomal ak yeneen sarax, jagleel ko Yàlla. Aaróona ak magi Israayil ñépp dikk, ñu bokk lekk ñook gorob Musaa fa kanam Yàlla. ");
INSERT INTO wolmbs_vpl VALUES ("EX18_13","003_18_13","EXO","18","13","13","Ca ëllëg sa Musaa toog, di àtte mbooloo ma, ñu wër ko suba ba ngoon. ");
INSERT INTO wolmbs_vpl VALUES ("EX18_14","003_18_14","EXO","18","14","14","Gorob Musaa gis mboolem la Musaa di defal mbooloo ma. Mu ne ko: «Waaw, ni ngay jëflanteek nit ñi nag? Lu tax ngay toog, di àtte yaw rekk, mbooloo mépp wër la, suba ba ngoon?» ");
INSERT INTO wolmbs_vpl VALUES ("EX18_15","003_18_15","EXO","18","15","15","Musaa ne goroom: «Li ko waral mooy nit ñi dañuy dikk, di laaj li dëppook àttey Yàlla. ");
INSERT INTO wolmbs_vpl VALUES ("EX18_16","003_18_16","EXO","18","16","16","Bu ñu jotee, dañuy ñëw diis ma ko, su ko defee ma àtte leen ci mbir mi leen jotale, ba noppi xamal leen santaaney Yàlla ak ndigali yoonam.» ");
INSERT INTO wolmbs_vpl VALUES ("EX18_17","003_18_17","EXO","18","17","17","Goro ba ne ko: «Ni ngay doxale gënul de! ");
INSERT INTO wolmbs_vpl VALUES ("EX18_18","003_18_18","EXO","18","18","18","Dangay dàjji sa bopp doŋŋ, dàjji mbooloo mi, ndax yen bee diis, ba ëpp ci sa kaw; doo ko àttan yaw rekk. ");
INSERT INTO wolmbs_vpl VALUES ("EX18_19","003_18_19","EXO","18","19","19","Déglu ma fii, ma digal la, tey ñaan Yàlla ànd ceek yaw. Danga fee toogal mbooloo mi ci kanam Yàlla, di diis Yàlla jotey nit ñi, ");
INSERT INTO wolmbs_vpl VALUES ("EX18_20","003_18_20","EXO","18","20","20","di leen xamal ay santaane aki ndigali yoon, di leen won fi ñu wara jaare ak li ñu wara def. ");
INSERT INTO wolmbs_vpl VALUES ("EX18_21","003_18_21","EXO","18","21","21","Kon nag dangay tànn ci biir mbooloo mi mépp ay góor ñu mat, ñu ragal Yàlla te dëggu, boole ci sib alalu ger. Su ko defee nga tabb leen, ñu yilif ay kuréel yu mat junniy nit ak yu tollu ci téeméeri nit, ba ci juróom fukki nit mbaa fukki nit. ");
INSERT INTO wolmbs_vpl VALUES ("EX18_22","003_18_22","EXO","18","22","22","Nga bàyyi leen nag, ñuy àtteel mbooloo mi bés bu nekk seeni jote. Su ko defee, mboolem réeroo bu mag, ñu indil la ko; mboolem réeroo bu sew nag, ñoom ñu àtteel ko seen bopp. Noonu ngay woyofale sab yen, ñu jàppale la ci. ");
INSERT INTO wolmbs_vpl VALUES ("EX18_23","003_18_23","EXO","18","23","23","Boo defee noonu, te Yàlla ànd ci, dinga ko mana dékku, mbooloo mii mépp it mana dellook jàmm ca seeni kër.» ");
INSERT INTO wolmbs_vpl VALUES ("EX18_24","003_18_24","EXO","18","24","24","Musaa nag topp ndigalu goroom, daldi def mboolem la mu ko wax. ");
INSERT INTO wolmbs_vpl VALUES ("EX18_25","003_18_25","EXO","18","25","25","Mu seet ca bànni Israayil gépp, tànn ca góor ñu mat, fal leen, ñu yilif mbooloo ma: ñii jiite kuréeli junniy nit; ñii, téeméer; ñii, juróom fukk; ñii fukk. ");
INSERT INTO wolmbs_vpl VALUES ("EX18_26","003_18_26","EXO","18","26","26","Ñuy àtte nag mbooloo ma saa su nekk. Su dee mbir mu lëj, ñu indil Musaa; mboolem mbir yu sew-sewaan ya, ñoom ñu àtte ko. ");
INSERT INTO wolmbs_vpl VALUES ("EX18_27","003_18_27","EXO","18","27","27","Ba loolu weesoo Musaa tàggatook goroom, mu dellu réewam. ");
INSERT INTO wolmbs_vpl VALUES ("EX19_1","003_19_1","EXO","19","1","1","Keroog benn fan ca ñetteelu weer wa, gannaaw ba ñu génnee Misra, ca lañu agsi màndiŋu Sinayi. ");
INSERT INTO wolmbs_vpl VALUES ("EX19_2","003_19_2","EXO","19","2","2","Fekk na ñu bàyyikoo Refidim, doora duggsi màndiŋu Sinayi, daldi dal ca màndiŋ ma. Israayil a nga daloon foofa janook tund wa. ");
INSERT INTO wolmbs_vpl VALUES ("EX19_3","003_19_3","EXO","19","3","3","Ba loolu amee Musaa yéeg, jëm ca Yàlla. Aji Sax ji jaar ci turu Musaa foofa ca kaw, ne ko: «Nanga wax ak waa kër Yanqóoba te nanga ma siiwtaaneel ci bànni Israayil googu, lii ma lay wax: ");
INSERT INTO wolmbs_vpl VALUES ("EX19_4","003_19_4","EXO","19","4","4","“Yeena gisal seen bopp ni ma def waa Misra, te yeen, ma boot leen, ni jaxaay di fireey laafam, boot ay doomam, ba ngeen jegesi ma fii. ");
INSERT INTO wolmbs_vpl VALUES ("EX19_5","003_19_5","EXO","19","5","5","Léegi nag su ngeen ma déggalee bu baax, di sàmm sama kóllëre ak yeen, yeenay doon sama moomeelu bopp ci mboolem askan yi. Dëgg la, àddina wërngal këpp maay Boroom, ");
INSERT INTO wolmbs_vpl VALUES ("EX19_6","003_19_6","EXO","19","6","6","waaye yeenay doon nguuru sarxalkati Yàlla, te di xeet wu sell.” Kàddu yooyu ngay wax bànni Israayil.» ");
INSERT INTO wolmbs_vpl VALUES ("EX19_7","003_19_7","EXO","19","7","7","Musaa dellu, woolu magi mbooloo ma. Mu jottali leen mboolem wax jooju ko Aji Sax ji dénk. ");
INSERT INTO wolmbs_vpl VALUES ("EX19_8","003_19_8","EXO","19","8","8","Mbooloo ma mépp bokk benn baat, àddu ne: «Li Aji Sax ji wax lépp dinanu ko def.» Ci kaw loolu Musaa dem yegge Aji Sax ji tontal mbooloo ma. ");
INSERT INTO wolmbs_vpl VALUES ("EX19_9","003_19_9","EXO","19","9","9","Aji Sax ji wax Musaa ne ko: «Ma ne, dinaa yiiroo niir wu fatt, dikk ba agsi fi yaw, ngir bu may wax ak yaw, mbooloo mi di ci dégg, ndax ñu wóolu la ba fàww.» Ba loolu amee Musaa baamtul Aji Sax ji tontal mbooloo ma. ");
INSERT INTO wolmbs_vpl VALUES ("EX19_10","003_19_10","EXO","19","10","10","Gannaaw loolu Aji Sax ji waxaat Musaa ne ko: «Dellul ca mbooloo ma, ne leen ñu sangu-set tey ak ëllëg. Nañu fóot seeni yére, ");
INSERT INTO wolmbs_vpl VALUES ("EX19_11","003_19_11","EXO","19","11","11","te waajal gannaaw ëllëg, ndax gannaaw ëllëg man Aji Sax ji maay wàcc ci kaw tundu Sinayi ci kanam mbooloo mépp. ");
INSERT INTO wolmbs_vpl VALUES ("EX19_12","003_19_12","EXO","19","12","12","Sàkkalal mbooloo mi ag kemu fi wër tund wi, te nga wax leen ne leen: “Moytuleena yéeg ci kaw tund wi, mbaa ngeen di laal tund wi fenn. Képp ku laal tund wi, dees na ko rey. ");
INSERT INTO wolmbs_vpl VALUES ("EX19_13","003_19_13","EXO","19","13","13","Bu loxo laal kooka, waaye dóorleen koy doj ba mu dee, mbaa ngeen jam ko. Su dee nit, su dee mala, bumu dundati.” Bu liit gi jibee doŋŋ nag lañuy doora mana dem ba ca tund wa.» ");
INSERT INTO wolmbs_vpl VALUES ("EX19_14","003_19_14","EXO","19","14","14","Ba loolu amee Musaa wàcc tund wa, dellu ca mbooloo ma, ne leen ñu sangu-set, fóot seeni yére ");
INSERT INTO wolmbs_vpl VALUES ("EX19_15","003_19_15","EXO","19","15","15","ba noppi, mu wax leen ne leen: «Waajalleen gannaaw ëllëg, te li feek booba, buleen fi ànd ak jigéen.» ");
INSERT INTO wolmbs_vpl VALUES ("EX19_16","003_19_16","EXO","19","16","16","Keroog ca gannaaw ëllëg sa, naka la njël jot, muy dënooka melax, ànd ak aw niir wu fatt ca kaw tund wa, ak coowal bufta bu xumb. Waa dal ba bépp a nga tiit, bay lox. ");
INSERT INTO wolmbs_vpl VALUES ("EX19_17","003_19_17","EXO","19","17","17","Musaa daldi jiite mbooloo ma, ñu génn dal ba, ngir dajejeek Yàlla. Ñu dem ba ca suufu tund wa, taxaw fa. ");
INSERT INTO wolmbs_vpl VALUES ("EX19_18","003_19_18","EXO","19","18","18","Fekk na tundu Sinayi wa wépp di sël-sëleeku saxaar, ndax Aji Sax ja fa wàcc ci biir sawara. Saxaar saa ngay gilli ni saxaaru puuru ban, tund wépp di yëngook doole, ");
INSERT INTO wolmbs_vpl VALUES ("EX19_19","003_19_19","EXO","19","19","19","bufta ba gëna jolli. Musaa ngay wax, Yàlla di ko tontoo kàddug dënu. ");
INSERT INTO wolmbs_vpl VALUES ("EX19_20","003_19_20","EXO","19","20","20","Ba mu ko defee Aji Sax ji wàcc ca tundu Sinayi wa, ca njobbaxtalu tund wa. Aji Sax ji nag woo Musaa foofa, ca njobbaxtal ga, Musaa dellu yéeg. ");
INSERT INTO wolmbs_vpl VALUES ("EX19_21","003_19_21","EXO","19","21","21","Aji Sax ji ne ko: «Wàccal, artu mbooloo mi, ndax ñu baña bëtt, di ma deñsi kumpa; lu ko moy ñu bare ci ñoom dinañu dee. ");
INSERT INTO wolmbs_vpl VALUES ("EX19_22","003_19_22","EXO","19","22","22","Te it sarxalkat yi may jege, man Aji Sax ji, dañoo wara sellal, bala may dal ci seen kaw.» ");
INSERT INTO wolmbs_vpl VALUES ("EX19_23","003_19_23","EXO","19","23","23","Musaa wax Aji Sax ji ne ko: «Mbooloo mi kat manuñoo yéeg tundu Sinayi, ndax yaw ci sa bopp artu nga nu, ne nu, nu sàkk ag kemu fi wër tund wi, te nu xam ne tund wu sell la.» ");
INSERT INTO wolmbs_vpl VALUES ("EX19_24","003_19_24","EXO","19","24","24","Aji Sax ji ne ko: «Wàccal te délsi, ànd ak Aaróona. Waaye muy sarxalkat yi, di mbooloo mi, bu kenn bëtt, jëm ci man Aji Sax ji, lu ko moy ma dal ci seen kaw.» ");
INSERT INTO wolmbs_vpl VALUES ("EX19_25","003_19_25","EXO","19","25","25","Ba loolu amee Musaa wàcc, fekki mbooloo ma, wax ak ñoom. ");
INSERT INTO wolmbs_vpl VALUES ("EX20_1","003_20_1","EXO","20","1","1","Yàlla wax na bànni Israayil kàddu yii yépp, ne leen: ");
INSERT INTO wolmbs_vpl VALUES ("EX20_2","003_20_2","EXO","20","2","2","«Man Aji Sax ji, maay seen Yàlla ji leen génne réewum Misra, kërug njaam ga. ");
INSERT INTO wolmbs_vpl VALUES ("EX20_3","003_20_3","EXO","20","3","3","«Buleen am yeneen yàlla ci sama kanam. ");
INSERT INTO wolmbs_vpl VALUES ("EX20_4","003_20_4","EXO","20","4","4","«Buleen sàkkal seen bopp tuur muy jëmmal lenn lu nekk ci kaw asamaan, mbaa ci kaw suuf, mbaa lu nekk ci ndox mu suuf tiim. ");
INSERT INTO wolmbs_vpl VALUES ("EX20_5","003_20_5","EXO","20","5","5","Buleen ci sujjóotal lenn, buleen ci jaamu lenn, ndax man seen Yàlla Aji Sax ji, Yàlla ju fiir laa. Maay topp doom tooñu waajur, ba ca seen maasi sët, ba ca maasug sëtaati nit ñi ma bañ. ");
INSERT INTO wolmbs_vpl VALUES ("EX20_6","003_20_6","EXO","20","6","6","Waaye maay baaxe ñi ma sopp, di sàmm samay santaane, ba ci junniy maas ya toppante. ");
INSERT INTO wolmbs_vpl VALUES ("EX20_7","003_20_7","EXO","20","7","7","«Buleen tudd seen turu Yàlla Aji Sax ji ci neen, ndax Aji Sax ji du ñàkka topp kuy tudd aw turam ci neen. ");
INSERT INTO wolmbs_vpl VALUES ("EX20_8","003_20_8","EXO","20","8","8","«Deeleen baaxantal bésub Noflaay, ngir sellal ko. ");
INSERT INTO wolmbs_vpl VALUES ("EX20_9","003_20_9","EXO","20","9","9","Juróom benni fan ngeen wara liggéey, def ci seen soxla yépp. ");
INSERT INTO wolmbs_vpl VALUES ("EX20_10","003_20_10","EXO","20","10","10","Waaye bésub juróom ñaareel ba, Noflaay lay doon, ñeel seen Yàlla Aji Sax ji. Buleen ci liggéey lenn; du yeen, du seen doom ju góor ak ju jigéen, du seen jaam bu góor ak bu jigéen, du seenug jur, te du seen gan gu nekk ci seen biir dëkk. ");
INSERT INTO wolmbs_vpl VALUES ("EX20_11","003_20_11","EXO","20","11","11","Ndax man Aji Sax ji, juróom benni fan laa sàkk asamaan ak suuf ak géej ak lépp li ci biir, bésub juróom ñaareel ba, ma dallu. Moo tax man Aji Sax ji ma barkeel bésub Noflaay, sellal ko. ");
INSERT INTO wolmbs_vpl VALUES ("EX20_12","003_20_12","EXO","20","12","12","«Teralleen seen ndey ak seen baay, ndax ngeen gudd fan ca suuf sa leen seen Yàlla Aji Sax ji jox. ");
INSERT INTO wolmbs_vpl VALUES ("EX20_13","003_20_13","EXO","20","13","13","«Buleen bóom. ");
INSERT INTO wolmbs_vpl VALUES ("EX20_14","003_20_14","EXO","20","14","14","«Buleen njaaloo. ");
INSERT INTO wolmbs_vpl VALUES ("EX20_15","003_20_15","EXO","20","15","15","«Buleen sàcc. ");
INSERT INTO wolmbs_vpl VALUES ("EX20_16","003_20_16","EXO","20","16","16","«Buleen seedeel seen moroom lu dul dëgg. ");
INSERT INTO wolmbs_vpl VALUES ("EX20_17","003_20_17","EXO","20","17","17","«Buleen xemmem seen lennu moroom: du këram, du jabaram, du jaamam bu góor, du jaamam bu jigéen, du nagam, du mbaamam.» ");
INSERT INTO wolmbs_vpl VALUES ("EX20_18","003_20_18","EXO","20","18","18","Mbooloo mépp a nga teew, ba muy dënooka melax, ànd ak coowal bufta baak tund way saxaar. Ñu gis loolu, di kat-kati, dànd fu sore. ");
INSERT INTO wolmbs_vpl VALUES ("EX20_19","003_20_19","EXO","20","19","19","Ci kaw loolu ñu ne Musaa: «Yaw, waxal ak nun, nu dégg, waaye bu Yàlla ci boppam wax ak nun, lu ko moy nu dee.» ");
INSERT INTO wolmbs_vpl VALUES ("EX20_20","003_20_20","EXO","20","20","20","Musaa ne mbooloo ma: «Buleen ragal, ndax nattu leen moo tax Yàlla ñëw, ngir ngeen ragal ko, ba dungeen moy.» ");
INSERT INTO wolmbs_vpl VALUES ("EX20_21","003_20_21","EXO","20","21","21","Noonu la mbooloo ma taxawe, dànd tund wa. Mennam Musaa moo jegeji niir wu fatt wa Yàlla nekkoon. ");
INSERT INTO wolmbs_vpl VALUES ("EX20_22","003_20_22","EXO","20","22","22","Aji Sax ji waxati Musaa ne ko: «Li ngay wax bànni Israayil mooy lii: “Yeena ko gisal seen bopp. Ca asamaan sax laa àddoo, wax ak yeen. ");
INSERT INTO wolmbs_vpl VALUES ("EX20_23","003_20_23","EXO","20","23","23","Buleen sàkkal seen bopp ay tuuri xaalis, mbaa ay tuuri wurus, di ma bokkaale, bumu am mukk. ");
INSERT INTO wolmbs_vpl VALUES ("EX20_24","003_20_24","EXO","20","24","24","Sarxalukaay bu ñu defare suuf ngeen may sàkkal, di ci sarxal seeni gàtt ak seeni nag, muy seen saraxu rendi-dóomal, mbaa seen saraxi cant ci biir jàmm. Ci mboolem béreb bu may fàttalee sama tur laay dikk fi yeen, barkeel leen. ");
INSERT INTO wolmbs_vpl VALUES ("EX20_25","003_20_25","EXO","20","25","25","Su ngeen ma dee sàkkal sarxalukaayu xeer, buleen ko defare xeer yu ñu yatt, ndaxte bu ngeen ko laalalee ab jumtukaay, teddadil ngeen ko. ");
INSERT INTO wolmbs_vpl VALUES ("EX20_26","003_20_26","EXO","20","26","26","Buleen yéeg ci ay dëggastal, doora mana àgg ca sama sarxalukaay, ndax loolu day tax ngeen di fa sàgganu.”» ");
INSERT INTO wolmbs_vpl VALUES ("EX21_1","003_21_1","EXO","21","1","1","Aji Sax ji teg ca ne: «Àttey yoon yii, nanga leen ko jox. ");
INSERT INTO wolmbs_vpl VALUES ("EX21_2","003_21_2","EXO","21","2","2","«Su ngeen jëndee jaam bu góor bu dib Ebrë, na liggéey juróom benni at. Juróom ñaareel ba lay moom boppam te du ameel kenn dara. ");
INSERT INTO wolmbs_vpl VALUES ("EX21_3","003_21_3","EXO","21","3","3","Su fekkee ne ba muy dugg cig njaam, moom doŋŋ la woon, moom doŋŋ ay moom boppam bu ca génnee; su ko fekkee mu am jabar, na jabaram ànd ak moom, ñu moom seen bopp. ");
INSERT INTO wolmbs_vpl VALUES ("EX21_4","003_21_4","EXO","21","4","4","Su fekkee ne sangam a ko may jabar, ndaw si am ak moom ay doom, jabar jeek doomam yu góor mbaa yu jigéen, sang bee leen di moom. Moom ci boppam doŋŋ ay moom boppam. ");
INSERT INTO wolmbs_vpl VALUES ("EX21_5","003_21_5","EXO","21","5","5","Waaye su jaam bi biralee ne: “Maa bëgg sama sang, maak sama jabar ak samay doom, te bëggumaa moom sama bopp”, ");
INSERT INTO wolmbs_vpl VALUES ("EX21_6","003_21_6","EXO","21","6","6","su boobaa na ci sang bi sàkku seede àttekat yi. Su ko defee mu sësal waa ji ci lafu bunt bi mbaa jënu bunt bi. Foofa lay bënne noppu waa ji ab puso, mu daldi doon ab jaamam giiru dundam. ");
INSERT INTO wolmbs_vpl VALUES ("EX21_7","003_21_7","EXO","21","7","7","«Su fekkee ne góor dafa jaay doomam ju jigéen njaam, deesu ko mana goreel ni bu doon góor. ");
INSERT INTO wolmbs_vpl VALUES ("EX21_8","003_21_8","EXO","21","8","8","Su ko sangam jëndee, def ko jabar, ba noppi bëggatu ko, na fexe ñu feyal ndaw si ag njotam, waaye amul sañ-sañu jaay ko ay doxandéem, ndax loolu wor la. ");
INSERT INTO wolmbs_vpl VALUES ("EX21_9","003_21_9","EXO","21","9","9","Su fekkee ne da koo jëndal doomam ju góor, na jëfeek moom, na mu dëppook wareefu doom ju jigéen. ");
INSERT INTO wolmbs_vpl VALUES ("EX21_10","003_21_10","EXO","21","10","10","Ki jënd as ndaw, def ko jabar nag, su takkee keneen it, warula wàññi la mu warlook jaam ba mu def jabar ci wàllu dund ak koddaay ak séy ak moom. ");
INSERT INTO wolmbs_vpl VALUES ("EX21_11","003_21_11","EXO","21","11","11","Su ko sang ba matalul ñett yooyii nag, day moom boppam, dem te du fey dara. ");
INSERT INTO wolmbs_vpl VALUES ("EX21_12","003_21_12","EXO","21","12","12","«Ku dóor nit, rey ko, dee rekk mooy àtteem. ");
INSERT INTO wolmbs_vpl VALUES ("EX21_13","003_21_13","EXO","21","13","13","Su dul woon pexe mu mu lal, xanaa mu fekk Yàlla yemale nit ki ciy loxoom, dinaa leen won béreb bu muy daw, làquji fa. ");
INSERT INTO wolmbs_vpl VALUES ("EX21_14","003_21_14","EXO","21","14","14","«Waaye nag, su nit fexeelee moroomam, nax ko, ba rey ko, su làqoo woon sama sarxalukaay sax, jàppleen ko, rey. ");
INSERT INTO wolmbs_vpl VALUES ("EX21_15","003_21_15","EXO","21","15","15","«Ku dóor baayam mbaa ndeyam, dee rekk mooy àtteem. ");
INSERT INTO wolmbs_vpl VALUES ("EX21_16","003_21_16","EXO","21","16","16","«Ku sàcc nit, dee rekk mooy àtteem, moo xam da koo jaay, mbaa ñu fekk ko ci ay loxoom. ");
INSERT INTO wolmbs_vpl VALUES ("EX21_17","003_21_17","EXO","21","17","17","«Ku saaga baayam mbaa ndeyam, dee rekk mooy àtteem. ");
INSERT INTO wolmbs_vpl VALUES ("EX21_18","003_21_18","EXO","21","18","18","«Su ay nit jàppantee, kenn ki dóor moroom ma loxoom mbaa aw doj, su ca deewul, te ab tëraayam sababoo ca, ");
INSERT INTO wolmbs_vpl VALUES ("EX21_19","003_21_19","EXO","21","19","19","su ci jógee mana génn ci biti, jàpp ciw yet sax, di dox, deesul daan ki ko dóor, waaye dina dàmp ki mu dóor ngir li mu tëdd liggéeyul, ak li pajam laaj. ");
INSERT INTO wolmbs_vpl VALUES ("EX21_20","003_21_20","EXO","21","20","20","«Ku dóor yet jaamam bu góor mbaa bu jigéen, ba mu dee ciy loxoom, dees na ko feyul moos. ");
INSERT INTO wolmbs_vpl VALUES ("EX21_21","003_21_21","EXO","21","21","21","Waaye su jaam ba dundee ba ca ëllëg sa, mbaa gannaaw ëllëg sa, deesu ko feyul ndaxte moomeelu sangam la. ");
INSERT INTO wolmbs_vpl VALUES ("EX21_22","003_21_22","EXO","21","22","22","«Su ay góor dee jàppante, ba kenn ci ñoom dal ci jigéenu wérul, ba liir bi génn, bu ci genn loraange toppul, dees na feyloo moos ki dal ci kawam, ndàmpaay li jëkkër ji laaj, te ña leen di àtte juboo ca limu pey ga. ");
INSERT INTO wolmbs_vpl VALUES ("EX21_23","003_21_23","EXO","21","23","23","«Waaye su ci loraange sababoo nag, na bakkan fey bakkan, ");
INSERT INTO wolmbs_vpl VALUES ("EX21_24","003_21_24","EXO","21","24","24","bët fey bët, bëñ fey bëñ, loxo fey loxo; tànk fey tànk, ");
INSERT INTO wolmbs_vpl VALUES ("EX21_25","003_21_25","EXO","21","25","25","lakk-lakk fey lakk-lakk, tëccu-tëccu fey tëccu-tëccu, góom fey góom. ");
INSERT INTO wolmbs_vpl VALUES ("EX21_26","003_21_26","EXO","21","26","26","«Ku dóor ab jaamam bu góor mbaa bu jigéen, ba tuur bëtam, na ko goreel ndax bët ba. ");
INSERT INTO wolmbs_vpl VALUES ("EX21_27","003_21_27","EXO","21","27","27","Su foqee bëñu jaamam bu góor mbaa bu jigéen, na ko goreel ndax bëñ ba. ");
INSERT INTO wolmbs_vpl VALUES ("EX21_28","003_21_28","EXO","21","28","28","«Su aw nag dañee góor mbaa jigéen, ba rey ko, dóorleen nag wi ay xeer ba mu dee, te buleen lekk yàpp wi, waaye boroom nag wi, yoon toppu ko. ");
INSERT INTO wolmbs_vpl VALUES ("EX21_29","003_21_29","EXO","21","29","29","Su fekkee ne nag wi da daan dañe, ñu yégaloon ko boroom, wattuwu ko, ba nag wi rey góor mbaa jigéen, dóorleen nag wi ay xeer, ba mu dee, te teg ci rey boroom nag wi. ");
INSERT INTO wolmbs_vpl VALUES ("EX21_30","003_21_30","EXO","21","30","30","Su fekkee ne dees koo sas ndàmpaay, na fey lim bu ñu ko mana sas, muy njot-gi-bakkanam. ");
INSERT INTO wolmbs_vpl VALUES ("EX21_31","003_21_31","EXO","21","31","31","Ba tey itam, su nag wi dañee xale, ba mu dee, muy góor mbaa jigéen, na àtte biy benn rekk ci boroom nag wi. ");
INSERT INTO wolmbs_vpl VALUES ("EX21_32","003_21_32","EXO","21","32","32","Su nag wi dañee ab jaam ba mu dee, muy góor mbaa jigéen, na boroom nag wi fey boroom jaam bi fanweeri dogi xaalis, te nañu dóor nag wi ay xeer, ba mu dee. ");
INSERT INTO wolmbs_vpl VALUES ("EX21_33","003_21_33","EXO","21","33","33","«Su fekkee ne nit dafa ubbi kàmb gu ube woon, mbaa mu gas kàmb, wacc ko mu ne ŋàpp, ba nag mbaa mbaam daanu ci, ");
INSERT INTO wolmbs_vpl VALUES ("EX21_34","003_21_34","EXO","21","34","34","na boroom kàmb gi fey; day delloo boroom mala mi njëgu mala mi, daldi féetewoo mala mi ci dee. ");
INSERT INTO wolmbs_vpl VALUES ("EX21_35","003_21_35","EXO","21","35","35","«Su nagu nit jamee nagu moroomam, ba mu dee, nañu bokk jaay nag wiy dund, séddoo njëg gi, te séddoo nag wi dee. ");
INSERT INTO wolmbs_vpl VALUES ("EX21_36","003_21_36","EXO","21","36","36","«Waaye su fekkee muy nag wu ñu xam ne da daan dañe, te boroomam ñàkk koo wattu, boroomam day feye nag wi dee aw nag wuy dund, daldi féetewoo wi dee. ");
INSERT INTO wolmbs_vpl VALUES ("EX21_37","003_21_37","EXO","21","37","37","«Ku sàcc aw nag mbaa ab gàtt, rey ko mbaa mu jaay ko, na feye wenn nag, juróomi nag; benn gàtt, mu feye ko ñeenti gàtt. ");
INSERT INTO wolmbs_vpl VALUES ("EX22_1","003_22_1","EXO","22","1","1","«Su fekkee dañoo jàpp ab sàcc guddi, muy toj kër jàmbur, bu ñu ko dóoree, ba mu dee, deesul topp ki dóor, bakkanu sàcc bi, ");
INSERT INTO wolmbs_vpl VALUES ("EX22_2","003_22_2","EXO","22","2","2","waaye su jant xasee fenk, dees na ko topp bakkanam. «Ab sàcc nag, bu ñu ko jàppee, na delloo li mu sàcc rekk. Su fekkee amu ko, dees koy jaay njaam, ndax càcc gi. ");
INSERT INTO wolmbs_vpl VALUES ("EX22_3","003_22_3","EXO","22","3","3","«Su dee ku sàcc mala, muy nag mbaa mbaam mbaa ab gàtt, te ñu fekk ko ciy loxoom, muy dund, na fey ñaaram. ");
INSERT INTO wolmbs_vpl VALUES ("EX22_4","003_22_4","EXO","22","4","4","«Ku wacc sag jur, mu ruur toolub jàmbur, ba lekk toolam mbaa tóokëru reseñam, na tànn li gën ci meññeefum toolu boppam mbaa tóokëru reseñam, dàmpe ko boroom tool bi mu lor. ");
INSERT INTO wolmbs_vpl VALUES ("EX22_5","003_22_5","EXO","22","5","5","«Su fekkee ne dañoo taal sawara, mu jàpp cib ñag, lakkaale pepp mu jóore, mbaa pepp mu ñor mu ñu góobagul, mbaa mu ñoragul, ka taal sawara wa mooy xala fey li lakk. ");
INSERT INTO wolmbs_vpl VALUES ("EX22_6","003_22_6","EXO","22","6","6","«Su nit dénkee moroomam xaalis, mbaa alal, ñu sàcce ko ci kër ki denc, te ñu jàpp sàcc bi, na sàcc bi fey ñaari yoon la mu sàcc. ");
INSERT INTO wolmbs_vpl VALUES ("EX22_7","003_22_7","EXO","22","7","7","Su ñu ko jàppul nag, na boroom kër gi sàkku seede àttekat yi, te waat ne, du moom ci boppam moo aakimoo alalu moroomam. ");
INSERT INTO wolmbs_vpl VALUES ("EX22_8","003_22_8","EXO","22","8","8","Saa yu ay nit jotee ci mbirum nag mbaa mbaam mbaa gàtt mbaa yére, mbaa lu réer lu mu doon, ñaar ñi solowoo alal ji, muy mala mbaa leneen, nañu yóbbu mbir mi fi kanam àttekat yi. Ku ci àttekat yi teg tooñ, na fey moroom mi ñaari yoon. ");
INSERT INTO wolmbs_vpl VALUES ("EX22_9","003_22_9","EXO","22","9","9","«Su nit dénkee moroomam mbaam mbaa nag mbaa gàtt mbaa mala mu mu mana doon, su jur gi deewee mbaa mu damm, mbaa ñu sàcce ko àll te amul seede, ");
INSERT INTO wolmbs_vpl VALUES ("EX22_10","003_22_10","EXO","22","10","10","li leen di àtte ngiñ lay doon ci Aji Sax ji. Na ka dencoon mala ma giñ ne jëlu ko. Na boroom mala mi it nangu ngiñ li. Ki dencoon du ko fey dara. ");
INSERT INTO wolmbs_vpl VALUES ("EX22_11","003_22_11","EXO","22","11","11","Waaye su ñu sàccee mala mi ci këram, moom mi dencoon mooy delloo boroom. ");
INSERT INTO wolmbs_vpl VALUES ("EX22_12","003_22_12","EXO","22","12","12","Su fekkee ne rabu àll a fàdd mala mi, na indi li ci des, muy firnde. Su boobaa du fey dara. ");
INSERT INTO wolmbs_vpl VALUES ("EX22_13","003_22_13","EXO","22","13","13","Su nit àbbee juru moroomam, jur ga damm mbaa mu dee fu boroom nekkul, na ki àbboon fey. ");
INSERT INTO wolmbs_vpl VALUES ("EX22_14","003_22_14","EXO","22","14","14","Waaye su ko boroomam fekkee, du laaj muy fey. Su fekkee ne dafa bindoon mala mi ci boroom, di ko fey, na boroom féetewoo njëg, ga ñu binde woon mala mi, muy peyam. ");
INSERT INTO wolmbs_vpl VALUES ("EX22_15","003_22_15","EXO","22","15","15","«Su góor naxee ab janq bu kenn joxagul warugar, ba tëdde ko, na fey warugaram, muy jabaram. ");
INSERT INTO wolmbs_vpl VALUES ("EX22_16","003_22_16","EXO","22","16","16","Su fekkee ne baayam dafa lànk, ne du ko ko may it, du tere mu wara fey ci xaalis lu tollook warugaru janq. ");
INSERT INTO wolmbs_vpl VALUES ("EX22_17","003_22_17","EXO","22","17","17","«Ab xërëmkat bu jigéen, buleen ko bàyyi, mu dund. ");
INSERT INTO wolmbs_vpl VALUES ("EX22_18","003_22_18","EXO","22","18","18","«Képp ku tëdde mala, dee rekk mooy àtteem. ");
INSERT INTO wolmbs_vpl VALUES ("EX22_19","003_22_19","EXO","22","19","19","«Kuy sarxeel jeneen yàlla ju dul Aji Sax ji moom rekk, dees koy faagaagal. ");
INSERT INTO wolmbs_vpl VALUES ("EX22_20","003_22_20","EXO","22","20","20","«Ab doxandéem, buleen ko lor, buleen ko noot, ndaxte yeen itam ay doxandéem ngeen woon fa réewum Misra. ");
INSERT INTO wolmbs_vpl VALUES ("EX22_21","003_22_21","EXO","22","21","21","«Képp ku dib jëtun akub jirim, buleen ko néewal. ");
INSERT INTO wolmbs_vpl VALUES ("EX22_22","003_22_22","EXO","22","22","22","Bu ngeen leen néewalee déy, bu ñu yuuxoo, woo ma wall, dinaa dégg seen yuux moos. ");
INSERT INTO wolmbs_vpl VALUES ("EX22_23","003_22_23","EXO","22","23","23","Su boobaa sama mer dina tàng, ma reye leen saamar, seeni jabar diy jëtun, seeni doom diy jirim. ");
INSERT INTO wolmbs_vpl VALUES ("EX22_24","003_22_24","EXO","22","24","24","«Bu ngeen dee lebal ku bokk ci sama ñoñ, di néew-ji-doole ju ngeen dëkkal, buleen def ni ab leblekat, di ko sas ab tegandaay. ");
INSERT INTO wolmbs_vpl VALUES ("EX22_25","003_22_25","EXO","22","25","25","«Su ngeen nangoo mbubbam tayle ci seen dëkkandoo, dellooleen ko ko bala jant a so. ");
INSERT INTO wolmbs_vpl VALUES ("EX22_26","003_22_26","EXO","22","26","26","Moom doŋŋ la am ci yére, di ko sànge yaramam; su ko ñàkkee, lu muy sàngoo ba tëdd? Te su ma woowee wall kat, dinaa ci dégg, ndax man Boroom Yërmande laa. ");
INSERT INTO wolmbs_vpl VALUES ("EX22_27","003_22_27","EXO","22","27","27","«Man Yàlla, buleen wax lu ñaaw ci man, te seen kilifag askan, buleen wax lu bon ci moom. ");
INSERT INTO wolmbs_vpl VALUES ("EX22_28","003_22_28","EXO","22","28","28","«Li tuuroo ci seen sàq yu fees, ak li wale ci seen nalukaay yu rembat, sama cér la; buleen ko yeexe, te seen taaw yu góor it, man ngeen leen di sédde. ");
INSERT INTO wolmbs_vpl VALUES ("EX22_29","003_22_29","EXO","22","29","29","Seen jur gu gudd ak gu gàtt itam, naka noonu. Juróom ñaari fan lay nekk ak ndeyam, bésub juróom ñetteel ba, ngeen jox ma ko. ");
INSERT INTO wolmbs_vpl VALUES ("EX22_30","003_22_30","EXO","22","30","30","Te itam nit ñu sell ngeen wara doon, ñeel ma, kon nag yàppu mala mu ñu fàdde ci àll bi, buleen ko lekk; sànnileen ko xaj yi. ");
INSERT INTO wolmbs_vpl VALUES ("EX23_1","003_23_1","EXO","23","1","1","«Buleen siiwal ay fen; buleen lëngoo ak tooñkat, ngir doon seedeb naaféqam. ");
INSERT INTO wolmbs_vpl VALUES ("EX23_2","003_23_2","EXO","23","2","2","Buleen seet fi mbooloo gëna baree, ngeen topp leen ci jëf ju bon; te it buleen jeng, di topp mbooloo mu gëna bare ci ab layoo, di leen seedeel lu toxal dëgg. ");
INSERT INTO wolmbs_vpl VALUES ("EX23_3","003_23_3","EXO","23","3","3","Néew-doole bi it, buleen ko far cib layoo. ");
INSERT INTO wolmbs_vpl VALUES ("EX23_4","003_23_4","EXO","23","4","4","«Su ngeen dajeek seen nagu noon mbaa mbaamam mu réer, fexeleen ba delloosil ko ko. ");
INSERT INTO wolmbs_vpl VALUES ("EX23_5","003_23_5","EXO","23","5","5","Su ngeen gisee seen mbaamu noon mu ab sëf daaneel, buleen ko romb; dimbalileen seen noon, yékkatilleen ko ko. ");
INSERT INTO wolmbs_vpl VALUES ("EX23_6","003_23_6","EXO","23","6","6","«Buleen jalgati àqu néew-ji-doole cib layoom. ");
INSERT INTO wolmbs_vpl VALUES ("EX23_7","003_23_7","EXO","23","7","7","Kàddu gu dëgguwul, soreleen ko, te ku deful dara ak ku jub, buleen ko reylu, ndax nit ku bon, duma ko àtte mukk àtteb ku jub. ");
INSERT INTO wolmbs_vpl VALUES ("EX23_8","003_23_8","EXO","23","8","8","Alali ger nag buleen ko nangu, ndax ger day gumbaal njàccaar, di xañ aji jub dëgg. ");
INSERT INTO wolmbs_vpl VALUES ("EX23_9","003_23_9","EXO","23","9","9","«Ab doxandéem, buleen ko noot; yeen ci seen bopp, jaar ngeen ci ndoxandéem, ndax ay doxandéem ngeen woon ca réewum Misra. ");
INSERT INTO wolmbs_vpl VALUES ("EX23_10","003_23_10","EXO","23","10","10","«Diiru juróom benni at ngeen di ji seen tool, for li ci meññe; ");
INSERT INTO wolmbs_vpl VALUES ("EX23_11","003_23_11","EXO","23","11","11","waaye atum juróom ñaareel ma, booyalleen tool bi, noppal ko; seen néew-dooley askan wi man cee lekk, li ci des, rabi àll yi for ko. Seen toolub reseñ ak seen tóokëru oliw itam, naka noonu. ");
INSERT INTO wolmbs_vpl VALUES ("EX23_12","003_23_12","EXO","23","12","12","«Diiru juróom benni fan ngeen di liggéey, waaye bésub juróom ñaareel ba, noppalu leen, ndax seen nag ak seen mbaam mana noppalu, seen jaam bu juddu ci kër ga akub doxandéem it mana astandiku. ");
INSERT INTO wolmbs_vpl VALUES ("EX23_13","003_23_13","EXO","23","13","13","«Li ma leen wax lépp sàmmleen ko, te turi yeneen yàlla, buleen ko tudd; bumu jibe sax seen gémmiñ. ");
INSERT INTO wolmbs_vpl VALUES ("EX23_14","003_23_14","EXO","23","14","14","«Ñetti yoon cim at ngeen may jagleel màggal. ");
INSERT INTO wolmbs_vpl VALUES ("EX23_15","003_23_15","EXO","23","15","15","Màggalu Mburu mu amul lawiir, wormaalleen ko. Diiru juróom ñaari fan ngeen ciy lekk mburu mu amul lawiir ni ma leen ko sante, saa yu jamonoom jotee ci weeru Abiib, ndaxte ci ngeen génn Misra. Te itam buleen taxawe loxoy neen ci sama kanam. ");
INSERT INTO wolmbs_vpl VALUES ("EX23_16","003_23_16","EXO","23","16","16","Wormaalleen màggalu ayu bésu Ngóob mi njëkka ñore ci tool yi ngeen di bey, ak màggalu Farmàngu mi ci ndeetel at mi, gannaaw bu ngeen dajalee seen meññeef ba noppi. ");
INSERT INTO wolmbs_vpl VALUES ("EX23_17","003_23_17","EXO","23","17","17","Ñetti yoon cim at la seen góor ñépp di teew fi kanam Boroom bi Aji Sax ji. ");
INSERT INTO wolmbs_vpl VALUES ("EX23_18","003_23_18","EXO","23","18","18","«Buleen ma rendil benn sarax, di boole deret jeek lu am lawiir, te nebbonu gàtt bu ngeen ma sarxal ci sama màggal, bumu fanaan ba bët set. ");
INSERT INTO wolmbs_vpl VALUES ("EX23_19","003_23_19","EXO","23","19","19","«Ngëneeli meññeef ma njëkka ñore ca seen suuf, moom ngeen di yóbbu seen kër Yàlla Aji Sax ji. «Ab tef, buleen ko togge soowum yaayam. ");
INSERT INTO wolmbs_vpl VALUES ("EX23_20","003_23_20","EXO","23","20","20","«Te nag man ci sama bopp, maay yebal malaaka, mu di leen sàmm ci yoon wi, ba yóbbu leen béreb ba ma waajal. ");
INSERT INTO wolmbs_vpl VALUES ("EX23_21","003_23_21","EXO","23","21","21","Bàyyileen ko xel bu baax, déggal ko te bañ koo merloo, ndax du leen baal seen moy, ngir sama tur la taxawe. ");
INSERT INTO wolmbs_vpl VALUES ("EX23_22","003_23_22","EXO","23","22","22","Waaye su ngeen ko déggalee ba déggal ko, di jëfe li ma leen wax lépp, su boobaa ma noonoo seeni noon, bañ seeni bañaale. ");
INSERT INTO wolmbs_vpl VALUES ("EX23_23","003_23_23","EXO","23","23","23","«Bu leen sama malaaka jiitoo, ba yóbbu leen ca réewum Amoreen ña ak Etteen ña ak Periseen ña ak Kanaaneen ña ak Eween ña ak Yebuseen ña, ba ma faxas leen ñoom ñépp, ");
INSERT INTO wolmbs_vpl VALUES ("EX23_24","003_23_24","EXO","23","24","24","su boobaa buleen sujjóotal mukk seeni tuur, di leen jaamu, mbaa ngeen di roy seeni aada, waaye yàqateleen seeni tuur te toj tasar seen tuuri doj ya fa sampe. ");
INSERT INTO wolmbs_vpl VALUES ("EX23_25","003_23_25","EXO","23","25","25","Jaamuleen ma, man seen Yàlla Aji Sax ji, ma barkeel seen dugub ak seen ndox, boole ci jële wopp ci seen biir. ");
INSERT INTO wolmbs_vpl VALUES ("EX23_26","003_23_26","EXO","23","26","26","Su ko defee du kenn ku ëmbam di yàqu, mbaa mu tëlee am doom ci seenum réew, te maay matal sëkk seen limu fan. ");
INSERT INTO wolmbs_vpl VALUES ("EX23_27","003_23_27","EXO","23","27","27","«Tiitaange laay yebal, mu jiitu leen. Maay tiital mboolem xeet wu ngeen fekki, te maay def seen noon yépp won leen gannaaw. ");
INSERT INTO wolmbs_vpl VALUES ("EX23_28","003_23_28","EXO","23","28","28","Maay yebal mbas mu leen jiitu, dàqal leen Eween ñi ak Kanaaneen ñi ak Etteen ñi. ");
INSERT INTO wolmbs_vpl VALUES ("EX23_29","003_23_29","EXO","23","29","29","Waaye duma leen dàqandoo ci menn at, lu ko moy réew mi gent, rabi àll yi mujj bare lool ci seen kaw. ");
INSERT INTO wolmbs_vpl VALUES ("EX23_30","003_23_30","EXO","23","30","30","Ndànk-ndànk laa leen leen di dàqal, ba kera ngeen di yokku, ba nangu réew mi. ");
INSERT INTO wolmbs_vpl VALUES ("EX23_31","003_23_31","EXO","23","31","31","«Maa leen di dogal kemug suuf gu dale géeju Barax yi, ba géeju waa Filisti, daleeti ca màndiŋ ma, ba ca dexu Efraat, ndax maay teg waa réew mi ci seeni loxo, ngeen dàq leen. ");
INSERT INTO wolmbs_vpl VALUES ("EX23_32","003_23_32","EXO","23","32","32","Buleen wóllëranteek ñoom, buleen wóllëranteek seeni tuur. ");
INSERT INTO wolmbs_vpl VALUES ("EX23_33","003_23_33","EXO","23","33","33","Buñu dëkke seenum réew, lu ko moy muy seen ndëgg-sërëx; ndax dañu leen di xiir ci moy ma, ba ngeen jaamu seeni tuur.» ");
INSERT INTO wolmbs_vpl VALUES ("EX24_1","003_24_1","EXO","24","1","1","Mu neeti Musaa: «Yéegal ñëw fi Aji Sax ji, yaw ak Aaróona ak Nadab ak Abiyu ak juróom ñaar fukki magi Israayil, te ngeen sujjóote nee, dànd ma. ");
INSERT INTO wolmbs_vpl VALUES ("EX24_2","003_24_2","EXO","24","2","2","Su ko defee yaw rekk yaay dikk, ba jege ma, man Aji Sax ji, waaye ñi ci des buñu jegesi, te it bu mbooloo mi yéegandoo ak yaw.» ");
INSERT INTO wolmbs_vpl VALUES ("EX24_3","003_24_3","EXO","24","3","3","Musaa dem, yeggeji mbooloo ma kàdduy Aji Sax ji yépp, ak àttey yoonam yépp. Mbooloo ma mépp bokk benn baat, ne ko: «Li Aji Sax ji wax lépp dinanu ko def.» ");
INSERT INTO wolmbs_vpl VALUES ("EX24_4","003_24_4","EXO","24","4","4","Ba loolu weesoo Musaa bind na mboolem kàdduy Aji Sax ji. Mu xëy nag suba teel, daldi sàkk ab sarxalukaay ca suufu tund wa, sampaale fa fukki doj ak ñaar, ñeel fukki giiri Israayil yaak ñaar. ");
INSERT INTO wolmbs_vpl VALUES ("EX24_5","003_24_5","EXO","24","5","5","Ba mu ko defee mu yebal ay ndawi bànni Israayil, ñu def ay saraxi rendi-dóomal, boole ci rendi yëkk yu ndaw yu ñu def saraxi cant ci biir jàmm, ñeel Aji Sax ji. ");
INSERT INTO wolmbs_vpl VALUES ("EX24_6","003_24_6","EXO","24","6","6","Musaa jël genn-wàllu deret ja, sotti ci ay ndab, la des ca deret ja, mu xëpp ko ca sarxalukaay ba. ");
INSERT INTO wolmbs_vpl VALUES ("EX24_7","003_24_7","EXO","24","7","7","Ba loolu amee mu jël téere ba ñu bind kóllëre ga, jàngal ko mbooloo ma, ñuy dégg. Mbooloo ma ne ko: «Li Aji Sax ji wax lépp dinanu ko def, ba mu mat sëkk.» ");
INSERT INTO wolmbs_vpl VALUES ("EX24_8","003_24_8","EXO","24","8","8","Musaa jël deret ja, wis-wisal ca kaw mbooloo ma, ne leen: «Lii nag mooy deret ji Yàlla fase kóllëre gi mu séq ak yeen te mu aju ci mboolem kàddoom yii.» ");
INSERT INTO wolmbs_vpl VALUES ("EX24_9","003_24_9","EXO","24","9","9","Ba loolu amee Musaa yéeg, ànd ak Aaróona ak Nadab ak Abiyu ak juróom ñaar fukki magi Israayil. ");
INSERT INTO wolmbs_vpl VALUES ("EX24_10","003_24_10","EXO","24","10","10","Ñu daldi gis Yàllay bànni Israayil. Lu mel ni dëru per bu safiir a nga lal tànkam ya, mel ni asamaan, ndax na mu sete wecc. ");
INSERT INTO wolmbs_vpl VALUES ("EX24_11","003_24_11","EXO","24","11","11","Waaye njiiti bànni Israayil ña, loxol Yàlla dalu leen. Ñoo gis Yàlla, te gannaaw loolu lekk nañu, naan nañu. ");
INSERT INTO wolmbs_vpl VALUES ("EX24_12","003_24_12","EXO","24","12","12","Aji Sax ji waxati Musaa ne ko: «Yéegal ba ci man ci kaw tund wi te négandiku fa, ma jox la àlluway doj yi ak yoon wi, ak santaane yi ma ci bind ngir jàngale ko.» ");
INSERT INTO wolmbs_vpl VALUES ("EX24_13","003_24_13","EXO","24","13","13","Musaa daldi jóg, mook Yosuwe, bëkk-néegam. Musaa nag yéeg ca tundu Yàlla wa. ");
INSERT INTO wolmbs_vpl VALUES ("EX24_14","003_24_14","EXO","24","14","14","Fekk na mu wax mag ña ne leen: «Xaarleen nu fii, ba nu délsi. Aaróona ak Ur a ngi nii ak yeen; ku ci am mbir mooy àttelu, demal ci ñoom.» ");
INSERT INTO wolmbs_vpl VALUES ("EX24_15","003_24_15","EXO","24","15","15","Ba Musaa yéegee ca kaw tund wa, niir wa daa yiir tund wa, ");
INSERT INTO wolmbs_vpl VALUES ("EX24_16","003_24_16","EXO","24","16","16","leeru Aji Sax ja dal ca kaw tundu Sinayi, niir wa yiir tund wa diiru juróom benni fan. Bésub juróom ñaareel ba Aji Sax ji àddoo ca digg niir wa, woo Musaa. ");
INSERT INTO wolmbs_vpl VALUES ("EX24_17","003_24_17","EXO","24","17","17","Melow leeru Aji Sax jaa ngay nirook sawara wuy tàkk ca njobbaxtalu tund wa, bànni Israayil di gis. ");
INSERT INTO wolmbs_vpl VALUES ("EX24_18","003_24_18","EXO","24","18","18","Musaa yéeg ca kaw tund wa ba tàbbi ca biir niir wa, di wéy. Musaa nekk na ca kaw tund wa ñeent fukki guddi ak ñeent fukki bëccëg. ");
INSERT INTO wolmbs_vpl VALUES ("EX25_1","003_25_1","EXO","25","1","1","Aji Sax ji waxati Musaa ne ko: ");
INSERT INTO wolmbs_vpl VALUES ("EX25_2","003_25_2","EXO","25","2","2","«Waxal bànni Israayil ne leen, ñu indil ma ab saraxu njébbal. Ci képp ku am yéene ji, ngeen di jële li ñu may jébbal, indil ma ko. ");
INSERT INTO wolmbs_vpl VALUES ("EX25_3","003_25_3","EXO","25","3","3","Li ngeen di jële ci ñoom di wurus ak xaalis ak xànjar, ");
INSERT INTO wolmbs_vpl VALUES ("EX25_4","003_25_4","EXO","25","4","4","ak wëñ gu baxa te laal yolet ak wëñ gu xewar ak gu xonq curr ak wëñu lẽe, ak kawari bëy ");
INSERT INTO wolmbs_vpl VALUES ("EX25_5","003_25_5","EXO","25","5","5","ak deri kuuy yu ñu wulli, sóob ko xonqal, ak deri piipi ak banti séng, ");
INSERT INTO wolmbs_vpl VALUES ("EX25_6","003_25_6","EXO","25","6","6","ak diwu oliw gu ñuy taaloo, ak ndàbb luy xeeñal diwug pal, di xeeñal cuuraay, ");
INSERT INTO wolmbs_vpl VALUES ("EX25_7","003_25_7","EXO","25","7","7","ak ay peri onigsë, ak yeneen per yu ñuy tapp ci xar-sànnim sarxalkat bu mag ba ak kiiraayal dënnam. ");
INSERT INTO wolmbs_vpl VALUES ("EX25_8","003_25_8","EXO","25","8","8","Na ma bànni Israayil defaral béreb bu sell, ndax ma dëkk ci seen biir. ");
INSERT INTO wolmbs_vpl VALUES ("EX25_9","003_25_9","EXO","25","9","9","Na lépp dëppoo ak li ma lay won. Muy misaalu xaymab jaamookaay bi, di misaalu mboolem ay jumtukaayam, lépp defeleen ko noonu. ");
INSERT INTO wolmbs_vpl VALUES ("EX25_10","003_25_10","EXO","25","10","10","«Defarleen gaalu dénku séng, guddaay bi di ñaari xasab ak genn-wàll, yaatuwaay bi di xasab ak genn-wàll; taxawaay bi di xasab ak genn-wàll. ");
INSERT INTO wolmbs_vpl VALUES ("EX25_11","003_25_11","EXO","25","11","11","Nañu ko xoobe wurusu ngalam. Biir ak biti lañu koy xoobe wurus, sàkkal ko kéméju wurus gu ko wër. ");
INSERT INTO wolmbs_vpl VALUES ("EX25_12","003_25_12","EXO","25","12","12","Móolalal gaal gi ñeenti lami wurus yu ñuy takk ci ñeenti tànk yi; ñaari lam ci genn wet gi, ñaar, wet gi ci des. ");
INSERT INTO wolmbs_vpl VALUES ("EX25_13","003_25_13","EXO","25","13","13","Yattlul ay njàppuy bantu séng te nga xoob bu ci nekk wurus. ");
INSERT INTO wolmbs_vpl VALUES ("EX25_14","003_25_14","EXO","25","14","14","Su ko defee nga roof njàppu yi ci lam yi ci weti gaal gi, ngir ñu di ko yóbboo gaal gi. ");
INSERT INTO wolmbs_vpl VALUES ("EX25_15","003_25_15","EXO","25","15","15","Ci lami gaal gi la njàppu yiy des te bañ cee jógeeti. ");
INSERT INTO wolmbs_vpl VALUES ("EX25_16","003_25_16","EXO","25","16","16","Yebal ci gaal gi àlluway seede si ma lay jox. ");
INSERT INTO wolmbs_vpl VALUES ("EX25_17","003_25_17","EXO","25","17","17","«Defarlul kubeer gu ñuy awale njotlaay gu wurusu ngalam ngir gaal gi. Na guddaay bi di ñaari xasab ak genn-wàll, yaatuwaay bi di xasab ak genn-wàll. ");
INSERT INTO wolmbs_vpl VALUES ("EX25_18","003_25_18","EXO","25","18","18","Tëgglul ñaari jëmmi malaakay serub yu wurus te nga féetale leen ak ñaari cati kubeeru njotlaay ga. ");
INSERT INTO wolmbs_vpl VALUES ("EX25_19","003_25_19","EXO","25","19","19","Defal cat lii ab serub, cat lee ab serub te nanga móolaale kubeer gi ak serub yi ci ñaari cat yi, ñu ànd di benn. ");
INSERT INTO wolmbs_vpl VALUES ("EX25_20","003_25_20","EXO","25","20","20","Na serub yi tàllal seeni laaf, jëme kaw te nañu yiire kubeeru njotlaay gi seeni laaf. Nañu janoo, te na seeni kanam jublook kubeeru njotlaay gi. ");
INSERT INTO wolmbs_vpl VALUES ("EX25_21","003_25_21","EXO","25","21","21","Tegal kubeeru njotlaay gi ci kaw gaal gi, gannaaw boo ci yebee àlluway seede si ma lay jox. ");
INSERT INTO wolmbs_vpl VALUES ("EX25_22","003_25_22","EXO","25","22","22","Foofa laay dajeek yaw; fa tiim kubeeru njotlaay ga, ca diggante ñaari serub ya ca kaw gaalu seede sa, fa laa lay waxe mboolem lu ma lay sant, ñeel bànni Israayil. ");
INSERT INTO wolmbs_vpl VALUES ("EX25_23","003_25_23","EXO","25","23","23","«Defarlul taabalu bantu séng, guddaay bi di ñaari xasab, yaatuwaay bi di xasab, taxawaay bi di xasab ak genn-wàll. ");
INSERT INTO wolmbs_vpl VALUES ("EX25_24","003_25_24","EXO","25","24","24","Xoob ko wurusu ngalam te defal ko kéméju wurus gu ko wër. ");
INSERT INTO wolmbs_vpl VALUES ("EX25_25","003_25_25","EXO","25","25","25","Defal ko pegg bu ko wër bu tollu ci ñeenti baaraam, te sàkkal pegg ba kéméju wurus, wërale ko. ");
INSERT INTO wolmbs_vpl VALUES ("EX25_26","003_25_26","EXO","25","26","26","Defarlul ko ñeenti lami wurus te we lam ya ca ñeenti wet ya, fa fareek ñeenti tànk ya. ");
INSERT INTO wolmbs_vpl VALUES ("EX25_27","003_25_27","EXO","25","27","27","Na lam yi dendeek pegg ngir mana téye njàppu yi ñuy yóbboo taabal ji. ");
INSERT INTO wolmbs_vpl VALUES ("EX25_28","003_25_28","EXO","25","28","28","Yattlul ay njàppu yu bantu séng, nga xoob njàppu yi wurus, ñu di ko yóbboo taabal ji. ");
INSERT INTO wolmbs_vpl VALUES ("EX25_29","003_25_29","EXO","25","29","29","Sàkkal ko ay ndabam yu tell aki mbàttoom aki njaqam, ak këllam yi ñuy tuural Yàlla. Te wurusu ngalam ngay def lu ci nekk. ");
INSERT INTO wolmbs_vpl VALUES ("EX25_30","003_25_30","EXO","25","30","30","Tegal mburum teewal mi ci kaw taabal ji, mu nekk ci sama kanam ba fàww. ");
INSERT INTO wolmbs_vpl VALUES ("EX25_31","003_25_31","EXO","25","31","31","«Defarlul tegukaayu làmp bu wurusu ngalam. Tegukaay ba, dees koy tëgg. Na taatu tegukaay ba ak per ba ànd aki kaasam aki kàmbóotam aki mbaram, lépp di benn. ");
INSERT INTO wolmbs_vpl VALUES ("EX25_32","003_25_32","EXO","25","32","32","Juróom benni car a soqikoo ci weti tegukaayu làmp bi, ñetti car ci gii wet, ñett ci gi ci des. ");
INSERT INTO wolmbs_vpl VALUES ("EX25_33","003_25_33","EXO","25","33","33","Benn car day am ñetti kaas yu bindoo ni tóor-tóori garabu amànd, kaas bu ci nekk ànd ak ay kàmbóotam aki mbaram, car ba ca topp am ñetti kaas yu bindoo ni tóor-tóori garabu amànd, kaas bu ci nekk ànd aki kàmbóotam aki mbaram, ba juróom benni car ya soqikoo ca per ba, daj. ");
INSERT INTO wolmbs_vpl VALUES ("EX25_34","003_25_34","EXO","25","34","34","Gannaaw loolu peru tegukaayu làmp ba itam day am ñeenti kaas yu bindoo ni tóor-tóori garabu amànd, ànd ak ay kàmbóotam aki mbaram. ");
INSERT INTO wolmbs_vpl VALUES ("EX25_35","003_25_35","EXO","25","35","35","Ab kàmbóot ay ronu yii ñaari car, jàpp ca; beneen kàmbóot ronu ñaari car ya ca topp, jàpp ca, ab kàmbóot ronu ñaari car ya mujj, jàpp ca, juróom benni car ya soqikoo ca peru làmp ba, daj. ");
INSERT INTO wolmbs_vpl VALUES ("EX25_36","003_25_36","EXO","25","36","36","Kàmbóot ya ak car ya dañuy ànd ak tegukaay ba, di wenn donju wurusu ngalam wu ñu tëgg ba mu jekk. ");
INSERT INTO wolmbs_vpl VALUES ("EX25_37","003_25_37","EXO","25","37","37","Defarlul juróom ñaari làmpam. Te na làmp ya tege tegin wuy leeral ca kanam tegukaay ba. ");
INSERT INTO wolmbs_vpl VALUES ("EX25_38","003_25_38","EXO","25","38","38","Ñiimi feyukaayu làmp yi ak andi làmp yi na doon wurusu ngalam. ");
INSERT INTO wolmbs_vpl VALUES ("EX25_39","003_25_39","EXO","25","39","39","Fanweeri kiloy wurusu ngalam ak juróom, ci lees di sàkk tegukaayu làmp bi, ak mboolem ay jumtukaayam. ");
INSERT INTO wolmbs_vpl VALUES ("EX25_40","003_25_40","EXO","25","40","40","Nanga xool te def leen mu dëppook misaal yi ñu la ciy won ci kaw tund wi. ");
INSERT INTO wolmbs_vpl VALUES ("EX26_1","003_26_1","EXO","26","1","1","«Xaymab jaamookaay bi nag, defare ko fukki sori rabali lẽe, mu ànd ak wëñ gu baxa te laal yolet ak wëñ gu xewar ak gu xonq curr, te nga ñawaale ca nataali serub. ");
INSERT INTO wolmbs_vpl VALUES ("EX26_2","003_26_2","EXO","26","2","2","Guddaayu sor bu nekk na doon ñaar fukki xasab ak juróom ñett, yaatuwaay ba di ñeenti xasab, te sor yépp ay tolloo. ");
INSERT INTO wolmbs_vpl VALUES ("EX26_3","003_26_3","EXO","26","3","3","Yii juróomi sor day taqaloo ca guddaay ba, juróomi sor ya ca des taqaloo noonu. ");
INSERT INTO wolmbs_vpl VALUES ("EX26_4","003_26_4","EXO","26","4","4","Ñawlul ay takku yu baxa te laal yolet ca catal sor, ba mujj ca benn taqalante ba, te ñawe ko noonu itam ca catal sor ba jeexal taqalante ba ca des. ");
INSERT INTO wolmbs_vpl VALUES ("EX26_5","003_26_5","EXO","26","5","5","Juróom fukki takku ngay def ci catal benn sor bi, ak juróom fukki takku ci catal sor, bi jeexal taqalante bi ci des, te na takku yi yemoo. ");
INSERT INTO wolmbs_vpl VALUES ("EX26_6","003_26_6","EXO","26","6","6","Su ko defee nga defarlu juróom fukki lonku yu wurus yu ñuy jokkalee sor yi, ba xaymab jaamookaay bi doon benn. ");
INSERT INTO wolmbs_vpl VALUES ("EX26_7","003_26_7","EXO","26","7","7","«Te itam ràbblul ay sori kawari bëy, ngir def ko ab xayma, muy kiiraay ci kaw jaamookaay bi. Fukk ak benn la sor yiy doon. ");
INSERT INTO wolmbs_vpl VALUES ("EX26_8","003_26_8","EXO","26","8","8","Guddaayu sor bu nekk di fanweeri xasab, yaatuwaay bi di ñeenti xasab, te fukki sor yeek benn yépp ay tolloo dayo. ");
INSERT INTO wolmbs_vpl VALUES ("EX26_9","003_26_9","EXO","26","9","9","Taqleel yii juróomi sor, juróom benni sor yi ci des it noonu, te juróom benneelu sor bi, nanga ko lem, fi féeteek kanam xayma bi. ");
INSERT INTO wolmbs_vpl VALUES ("EX26_10","003_26_10","EXO","26","10","10","Sàkkal juróom fukki takku ci catal sor bi mujj ci benn taqalante bi, ak juróom fukki takku ci catal sor bi jeexal taqalante bi ci des. ");
INSERT INTO wolmbs_vpl VALUES ("EX26_11","003_26_11","EXO","26","11","11","Sàkkal juróom fukki lonku yu xànjar te nga we lonku yi ci takku yi, daldi jokkale ñaari taqalante yi, muy benn xayma. ");
INSERT INTO wolmbs_vpl VALUES ("EX26_12","003_26_12","EXO","26","12","12","Liy lang te ëppe ci sori xayma bi nag, di beneen genn-wàllu sor bi, na lange ci gannaaw xaymab jaamookaay bi. ");
INSERT INTO wolmbs_vpl VALUES ("EX26_13","003_26_13","EXO","26","13","13","Waaye benn xasab bi ëppe wet gu nekk ci guddaayu sori xayma bi, na lange ci ñaari weti jaamookaay bi, ngir yiire ko ko. ");
INSERT INTO wolmbs_vpl VALUES ("EX26_14","003_26_14","EXO","26","14","14","Nanga defarlul xayma bi malaanum deri kuuy yu ñu sóob xonq, ak meneen malaanum deri piipi muy tege ca kawam. ");
INSERT INTO wolmbs_vpl VALUES ("EX26_15","003_26_15","EXO","26","15","17","«Sàkkalal xaymab jaamookaay bi ay làcci bantu séng yuy sampe. Na làcc wu nekk am ñaari kenu yu ñu lëkkalee galan yu ndaw, te nga def làcci jaamookaay bi yépp noonu. Na taxawaayu làcc wu nekk di fukki xasab, yaatuwaay bi di xasab ak genn-wàll. ");
INSERT INTO wolmbs_vpl VALUES ("EX26_18","003_26_18","EXO","26","18","18","Ci wàllu làcci jaamookaay bi, sësaleel ñaar fukki làcc fi féete bëj-saalum, ");
INSERT INTO wolmbs_vpl VALUES ("EX26_19","003_26_19","EXO","26","19","19","boole kook ñeent fukki tegukaayi xaalis yuy ronu kenuy ñaar fukki làcc yi, ñaari tegukaay ay ronu làcc wi jiitu ngir ñaari kenoom yi muy àndal, ñaari tegu topp ci, ronu wépp làcc wu ci topp, ngir ñaari kenoom yi muy àndal. ");
INSERT INTO wolmbs_vpl VALUES ("EX26_20","003_26_20","EXO","26","20","20","Geneen wetu jaamookaay gi féete bëj-gànnaar itam, na doon ñaar fukki làcc ");
INSERT INTO wolmbs_vpl VALUES ("EX26_21","003_26_21","EXO","26","21","21","ak seeni ñeent fukki teguy xaalis, ñaari tegu ronu làcc wi jiitu, ñaari tegu topp ci, ronu wépp làcc wu ci topp. ");
INSERT INTO wolmbs_vpl VALUES ("EX26_22","003_26_22","EXO","26","22","22","Gannaawu jaamookaay gi féete sowu, sàkkal ko juróom benni làcc; ");
INSERT INTO wolmbs_vpl VALUES ("EX26_23","003_26_23","EXO","26","23","23","nga teg ci ñaari làcc ngir colli jaamookaay bi ci gannaaw. ");
INSERT INTO wolmbs_vpl VALUES ("EX26_24","003_26_24","EXO","26","24","24","Nañu àndandoo ci suuf te lëkkoo ca kaw ci benn lam kepp. Noonu lañuy bindoo ñoom ñaar; ñooy doon ñaari coll yi. ");
INSERT INTO wolmbs_vpl VALUES ("EX26_25","003_26_25","EXO","26","25","25","Muy juróom ñetti làcc ak seeni teguy xaalis, di fukki tegu ak juróom benn, ñaari tegu ronu làcc wi jiitu, ñaari tegu topp ci, ronu wépp làcc wu ci topp. ");
INSERT INTO wolmbs_vpl VALUES ("EX26_26","003_26_26","EXO","26","26","26","«Nanga sàkk itam ay galani bantu séng: juróomi galan yuy ànd ak làcc yi ci genn wetu jaamookaay bi, ");
INSERT INTO wolmbs_vpl VALUES ("EX26_27","003_26_27","EXO","26","27","27","ak juróomi galan ngir làcci wet gi ci des, ak juróomi galan ngir làcc, yi ci gannaaw jaamookaay bi, fi féete sowu. ");
INSERT INTO wolmbs_vpl VALUES ("EX26_28","003_26_28","EXO","26","28","28","Galanu digg bi, ci digg làcc yi lay nekk, dale ko cat ba cat. ");
INSERT INTO wolmbs_vpl VALUES ("EX26_29","003_26_29","EXO","26","29","29","Xoobal làcc yi wurus te nga sàkkal làcc wu ci nekk ay lami wurus yuy téye galan yi, te nga xoob galan yi it wurus. ");
INSERT INTO wolmbs_vpl VALUES ("EX26_30","003_26_30","EXO","26","30","30","Su ko defee nga taxawal xaymab jaamookaay bi, ni ñu la ko wone ci kaw tund wi. ");
INSERT INTO wolmbs_vpl VALUES ("EX26_31","003_26_31","EXO","26","31","31","«Sàkkal rido bu ñu ràbbe wëñ gu baxa te laal yolet, ak wëñ gu xewar ak gu xonq curr, ak wëñu lẽe, ñu ñawaale ca nataali serub, ");
INSERT INTO wolmbs_vpl VALUES ("EX26_32","003_26_32","EXO","26","32","32","te nga wékk ko ci ñeenti jëni séng yu ñu xoobe wurus, jën yi ànd ak seen wékkukaayi wurus, te nga móolal jën yi ñeenti teguy xaalis. ");
INSERT INTO wolmbs_vpl VALUES ("EX26_33","003_26_33","EXO","26","33","33","Wewal rido bi ci ron lonku yi, su ko defee nga yóbbu gaalu àlluway seede si foofu ci gannaaw rido bi, rido bi xàjjaleel leen néeg bu sell bi ak néeg bu sella sell bi. ");
INSERT INTO wolmbs_vpl VALUES ("EX26_34","003_26_34","EXO","26","34","34","Tegal kubeer ga ñuy amale ag njotlaay ca kaw gaal ga àlluway seede sa dence, ca biir néeg bu sella sell bi. ");
INSERT INTO wolmbs_vpl VALUES ("EX26_35","003_26_35","EXO","26","35","35","Tegal taabal ja ca biti, ca kanam rido ba, te nga teg tegukaayu làmp ba ca wetu bëj-saalumu jaamookaay ba, mu jàkkaarlook taabal ja, taabal ja nag, nga tege ko wetu bëj-gànnaar. ");
INSERT INTO wolmbs_vpl VALUES ("EX26_36","003_26_36","EXO","26","36","36","«Sàkkalal buntu xayma bi kiiraay lu ñu ràbbe wëñ gu baxa te laal yolet, ak wëñ gu xewar ak gu xonq curr ak wëñu lẽe, muy liggéeyu ràbb bu rafet. ");
INSERT INTO wolmbs_vpl VALUES ("EX26_37","003_26_37","EXO","26","37","37","Nga sàkkal nag kiiraay li juróomi jëni séng, xoob wu ci nekk wurus, seeni wékkukaay di wurus, te nga móolal jën yi juróomi teguy xànjar. ");
INSERT INTO wolmbs_vpl VALUES ("EX27_1","003_27_1","EXO","27","1","1","«Nanga defare sarxalukaay bi bantu séng, guddaay bi di juróomi xasab, yaatuwaay bi di juróomi xasab; ab kaare la sarxalukaay biy doon, taxawaayam di ñetti xasab. ");
INSERT INTO wolmbs_vpl VALUES ("EX27_2","003_27_2","EXO","27","2","2","Defaral ko ay béjjénam ci ñeenti coll yi ci kaw. Béjjén yi, dees koy liggéeyaaleek sarxalukaay ba, ñu ànd di benn, te nanga xoob sarxalukaay bi xànjar. ");
INSERT INTO wolmbs_vpl VALUES ("EX27_3","003_27_3","EXO","27","3","3","Sàkkal ay ndabi tibbukaayu dóomam, ak ay ñiitukaayam, ak ay këllam, ak ay seppikaayi yàpp aki andam. Defal jumtukaayam yépp xànjar. ");
INSERT INTO wolmbs_vpl VALUES ("EX27_4","003_27_4","EXO","27","4","4","Sàkkal ko caax bu ñu tëgge xànjar te nga sàkkal caaxu xànjar bi ñeenti nopp ci ñeenti collam. ");
INSERT INTO wolmbs_vpl VALUES ("EX27_5","003_27_5","EXO","27","5","5","Tegal caax bi, mu ronu peggu sarxalukaay bi, te dale ci suuf ba ci digg sarxalukaay bi. ");
INSERT INTO wolmbs_vpl VALUES ("EX27_6","003_27_6","EXO","27","6","6","Sàkkalal sarxalukaay bi ay njàppuy bantu séng, te nga xoob lu ci nekk xànjar, ");
INSERT INTO wolmbs_vpl VALUES ("EX27_7","003_27_7","EXO","27","7","7","te nga roof njàppu yi ci nopp yi, su ko defee njàppu yi des ci ñaari weti sarxalukaay bi, ngir bu ñu koy yóbbu. ");
INSERT INTO wolmbs_vpl VALUES ("EX27_8","003_27_8","EXO","27","8","8","Am pax ngay def sarxalukaay bi ci biir; nga defare ko ay xànq yu tàppandaar. Na ñu la ko wone ca kaw tund wa rekk lañu koy defe. ");
INSERT INTO wolmbs_vpl VALUES ("EX27_9","003_27_9","EXO","27","9","9","«Nanga sàkkalal jaamookaay bi ab ëtt: guddaayu ëtt bi ci wetu bëj-saalum, téeméeri xasabi sori rabal yu ñu ràbbe wëñu lẽe moo koy ub, ci genn wet googu. ");
INSERT INTO wolmbs_vpl VALUES ("EX27_10","003_27_10","EXO","27","10","10","Jëni jaamookaay bi ñaar fukk lay doon, seen ñaar fukki tegu di xànjar, wékkukaay yeek galani jën yi di xaalis. ");
INSERT INTO wolmbs_vpl VALUES ("EX27_11","003_27_11","EXO","27","11","11","«Naka noonu it ci wetu bëj-gànnaar, guddaay bi di téeméeri xasabi sori rabal, ak seen ñaar fukki jën yu seen ñaar fukki teguy xànjar ronu, wékkukaay yeek galani jën yi di xaalis. ");
INSERT INTO wolmbs_vpl VALUES ("EX27_12","003_27_12","EXO","27","12","12","«Yaatuwaayu ëtt bi, fi féete sowu, juróom fukki xasabi sori rabal a koy ub, seeni jën di fukk, seeni tegu di fukk. ");
INSERT INTO wolmbs_vpl VALUES ("EX27_13","003_27_13","EXO","27","13","13","«Yaatuwaayu ëtt bi, fi féete penku ci kanam, juróom fukki xasab la: ");
INSERT INTO wolmbs_vpl VALUES ("EX27_14","003_27_14","EXO","27","14","14","fukki xasabi sori rabal ak juróom moo ub ëtt bi ci googu wet, seeni jën di ñett, seeni tegu di ñett. ");
INSERT INTO wolmbs_vpl VALUES ("EX27_15","003_27_15","EXO","27","15","15","Wet gi ci des it, fukki xasabi sori rabal ak juróom, seeni jën di ñett, seeni tegu di ñett. ");
INSERT INTO wolmbs_vpl VALUES ("EX27_16","003_27_16","EXO","27","16","16","Buntu ëtt bi nag, na doon lafu ñaar fukki xasab, wu ñu defare wëñ gu baxa te laal yolet, ak wëñ gu xewar ak gu xonq curr ak wëñu lẽe, muy liggéeyu ràbb bu rafet, ay jënam di ñeent, seeni tegu di ñeent. ");
INSERT INTO wolmbs_vpl VALUES ("EX27_17","003_27_17","EXO","27","17","17","«Jën ya wër ëtt ba yépp, dees koy lëkkalee galan yu xaalis, wékkukaayi jën yi di xaalis, seeni tegu di xànjar. ");
INSERT INTO wolmbs_vpl VALUES ("EX27_18","003_27_18","EXO","27","18","18","«Guddaayu ëtt bi téeméeri xasab lay doon, yaatuwaay bi di juróom fukk, taxawaayu wet yi di juróomi xasab, sor yi ñu ràbbe lépp di wëñu lẽe, tegu yi di xànjar. ");
INSERT INTO wolmbs_vpl VALUES ("EX27_19","003_27_19","EXO","27","19","19","Mboolem jumtukaay yi ñuy liggéeye ci jaamookaay bi, ba ci mboolem xeri xaymaam, ak mboolem xeri wërmbalu ëtt bi, lépp xànjar lay doon. ");
INSERT INTO wolmbs_vpl VALUES ("EX27_20","003_27_20","EXO","27","20","20","«Yaw nag, santal bànni Israayil, ñu indil la diwu segalu oliw gu raxul ngir leerlu, ñu di ko taale làmp yi guddi gu nekk. ");
INSERT INTO wolmbs_vpl VALUES ("EX27_21","003_27_21","EXO","27","21","21","Ci biir xaymab ndaje mi la Aaróona ak doomam yu góor di teg làmp yi, ci kanam rido bi làq gaalu àlluway seede si, ñuy fanaanee tàkk ngoon ba bët set, fi kanam Aji Sax ji. Dogal a ngoogu, war bànni Israayil fàww, ñoom ak seen askan. ");
INSERT INTO wolmbs_vpl VALUES ("EX28_1","003_28_1","EXO","28","1","1","«Léegi nag yaw, nanga seppee ci bànni Israayil sa mag Aaróona, ak doomam yu góor, nga woo leen fi yaw, ñu di ma sarxalal: Aaróona ak doomam yu góor, Nadab ak Abiyu ak Elasar ak Itamar. ");
INSERT INTO wolmbs_vpl VALUES ("EX28_2","003_28_2","EXO","28","2","2","Sàkkalal sa mag Aaróona yérey cellte ngir daraja, ak teraanga bu sarxalkat wara yelloo. ");
INSERT INTO wolmbs_vpl VALUES ("EX28_3","003_28_3","EXO","28","3","3","Dangay sant mboolem liggéeykat yu xareñ, yi ma feesal xelum xareñte, ñu defar yérey Aaróona, ngir fal ko, mu di ma sarxalal. ");
INSERT INTO wolmbs_vpl VALUES ("EX28_4","003_28_4","EXO","28","4","4","Yii yére nag lañu koy defaral: kiiraayal dënn ak ab xar-sànni ak mbubb, ak jàllaabi bu ñu ràbb, ak kaala ak laxasaay. Yérey cellte lañuy defal sa mag Aaróona ak doomam yu góor, ngir ñu di ma sarxalal. ");
INSERT INTO wolmbs_vpl VALUES ("EX28_5","003_28_5","EXO","28","5","5","Liggéeykat yooyu ñooy jël wëñi wurus, ak wëñ gu baxa te laal yolet, ak wëñ gu xewar, ak gu xonq curr, ak wëñu lẽe ngir liggéeye ko. ");
INSERT INTO wolmbs_vpl VALUES ("EX28_6","003_28_6","EXO","28","6","6","«Nañu ràbbe xar-sànni mi wëñu wurus, ak wëñ gu baxa te laal yolet, ak wëñ gu xewar ak gu xonq curr ak wëñu lẽe, ñu ñawaale ci ay nataal. ");
INSERT INTO wolmbs_vpl VALUES ("EX28_7","003_28_7","EXO","28","7","7","Ñaari ngàlli mbagg yu ñuy faste la xar-sànni miy am, ñu di leen fastee ci ñaari cat yi. ");
INSERT INTO wolmbs_vpl VALUES ("EX28_8","003_28_8","EXO","28","8","8","Ngañaayu taaral liy tege ci kaw xar-sànni mi, ni xar-sànni mi lees ko defare, liggéeyaale kook moom, ñu ànd di benn, di wëñu wurus, ak wëñ gu baxa te laal yolet, ak wëñ gu xewar, ak gu xonq curr, ak wëñu lẽe. ");
INSERT INTO wolmbs_vpl VALUES ("EX28_9","003_28_9","EXO","28","9","9","Nanga jël ñaari peri onigsë, nga ñaas ci turi doomi Israayil yu góor: ");
INSERT INTO wolmbs_vpl VALUES ("EX28_10","003_28_10","EXO","28","10","10","yii juróom benni tur ci benn per, juróom benni tur yi ci des ci beneen per bi, tur yi toppante, ni boroom tur yi toppantee ci juddu. ");
INSERT INTO wolmbs_vpl VALUES ("EX28_11","003_28_11","EXO","28","11","11","Ni ko ab liggéeykat bu farewoo mbindum doj di defe, ni lañuy ñaase turi doomi Israayil yu góor ci kaw ñaari per yi, mu mel ni ni ñuy ñaase xàmmikaay yi ñuy torloo, te nañu we per yi ci ay ŋankukaayi wurus. ");
INSERT INTO wolmbs_vpl VALUES ("EX28_12","003_28_12","EXO","28","12","12","Tappal ñaari per yi ci kaw ngàlli waggi xar-sànni mi, per yi taxawe taxawaayu bànni Israayil, Aaróona gàddu seeni tur ci kaw ñaari ngàlli waggam, fi kanam Aji Sax ji, ngir saxal ag pàttaliku. ");
INSERT INTO wolmbs_vpl VALUES ("EX28_13","003_28_13","EXO","28","13","13","«Sàkkal ay ŋankukaayi wurus, ");
INSERT INTO wolmbs_vpl VALUES ("EX28_14","003_28_14","EXO","28","14","14","ak ñaari caqi wurusu ngalam, bu ci nekk nga rawaase ko nig buum, ba noppi nga we caq yu rawaasoo yooyu ci ŋankukaay yi. ");
INSERT INTO wolmbs_vpl VALUES ("EX28_15","003_28_15","EXO","28","15","15","«Nanga sàkk kiiraayal dënn bi ñuy jëfoo cib àtte, ñu liggéeyaale ko ay nataal ni xar-sànni mi, te nañu ko ràbbe wëñu wurus, ak wëñ gu baxa te laal yolet, ak wëñ gu xewar, ak gu xonq curr, ak wëñu lẽe. ");
INSERT INTO wolmbs_vpl VALUES ("EX28_16","003_28_16","EXO","28","16","16","Ab kaare bu ñu lem lay doon, guddaay bi di ŋaraleb baaraamu déy ak bu digg, yaatuwaay bi di ŋaraleb baaraamu déy ak digg. ");
INSERT INTO wolmbs_vpl VALUES ("EX28_17","003_28_17","EXO","28","17","17","Nanga we ay per ci kaw kiiraayal dënn bi, nga def ko ñeenti làngi per. Làng gi jiitu, peru sarduwan ak peru topaas ak peru eskarbukal moo cay nekk; ");
INSERT INTO wolmbs_vpl VALUES ("EX28_18","003_28_18","EXO","28","18","18","ñaareelu làng gi di peru emëródd ak peru safiir ak peru jamaa; ");
INSERT INTO wolmbs_vpl VALUES ("EX28_19","003_28_19","EXO","28","19","19","ñetteelu làng gi di peru yasent ak peru agaat ak peru ametistë; ");
INSERT INTO wolmbs_vpl VALUES ("EX28_20","003_28_20","EXO","28","20","20","ñeenteelu làng gi di peru kirsolit ak peru onigsë ak peru jàspë, te per bu ci nekk, ŋankukaayu wurus lees koy wewe. ");
INSERT INTO wolmbs_vpl VALUES ("EX28_21","003_28_21","EXO","28","21","21","Per yeek turi doomi Israayil yu góor ñooy tolloo ab lim: muy fukk ak ñaar, ni tur yi tollu. Dees ciy ñaas tur yi ni xàmmikaayi torlu, ku nekk ak turam, ba fukki giir yeek ñaar daj. ");
INSERT INTO wolmbs_vpl VALUES ("EX28_22","003_28_22","EXO","28","22","22","«Nanga sàkkal kiiraayal dënn bi ñaari caqi wurusu ngalam yu ciy tege, te rawaasoo ni ay buum, ");
INSERT INTO wolmbs_vpl VALUES ("EX28_23","003_28_23","EXO","28","23","23","ak ñaari jaaroy wurus yu ñuy takk ci ñaari cati kiiraayal dënn bi ci kaw, ");
INSERT INTO wolmbs_vpl VALUES ("EX28_24","003_28_24","EXO","28","24","24","te nga nas ñaari buumi wurus yi ci ñaari jaaro yi ci cati kiiraay li. ");
INSERT INTO wolmbs_vpl VALUES ("EX28_25","003_28_25","EXO","28","25","25","Yeneen ñaari cati buumi wurus yi, nga we leen ci ñaari ŋankukaay yi ci kaw ngàlli waggi xar-sànni mi, ci kanam. ");
INSERT INTO wolmbs_vpl VALUES ("EX28_26","003_28_26","EXO","28","26","26","Sàkkal ko it ñaari jaaroy wurus yu ñuy we ci ñaari cati suufi kiiraay li, fi féete biir, wet gi tafu ci xar-sànni mi. ");
INSERT INTO wolmbs_vpl VALUES ("EX28_27","003_28_27","EXO","28","27","27","Nga sàkkalaat ko yeneen ñaari jaaroy wurus yooy we ci suufu ngàlli xar-sànni mi, fi féete kanam, dendeek sofu ngàll yi, te tiim ngañaayu xar-sànni mi. ");
INSERT INTO wolmbs_vpl VALUES ("EX28_28","003_28_28","EXO","28","28","28","Kiiraayal dënn bi, buum gu sew gu baxa te laal yolet, moom lees koy téyee, lëkkalee ko jaaroy kiiraay leek jaaroy xar-sànni mi, su ko defee kiiraay li dëkke tiim ngañaay li, ba du teqalikook xar-sànni mi. ");
INSERT INTO wolmbs_vpl VALUES ("EX28_29","003_28_29","EXO","28","29","29","Aaróona nag nay tegoo turi bànni Israayil ci kaw kiiraayal dënn bi ñuy àttee, tur yi tafu ci xolam, saa yuy dugg ci néeg bu sell bi, ngir saxal pàttaliku ba fàww fi kanam Aji Sax ji. ");
INSERT INTO wolmbs_vpl VALUES ("EX28_30","003_28_30","EXO","28","30","30","Nanga yeb ci biir kiiraayal dënn bi ñuy àttee, jumtukaayi tegtal yooyu di Urim ak Tumim, ngir ñu tafu ci xolu Aaróona, saa yuy taxawi fi kanam Aji Sax ji. Noonu la Aaróona di dëkke yóbbaale ci kaw xolam jumtukaayi àtte yu bànni Israayil, saa suy taxawi fi kanam Aji Sax ji, ba fàww. ");
INSERT INTO wolmbs_vpl VALUES ("EX28_31","003_28_31","EXO","28","31","31","«Mbubb mi xar-sànni miy tege, lépp, wëñ gu baxa te laal yolet nga koy liggéeye ba mu daj. ");
INSERT INTO wolmbs_vpl VALUES ("EX28_32","003_28_32","EXO","28","32","32","Na baatu mbubb mi nekk ci digg bi, mel ni baatu mbubbam xare, te nañu ko ombe omb bu dëgër ba mu daj, ngir du xottiku. ");
INSERT INTO wolmbs_vpl VALUES ("EX28_33","003_28_33","EXO","28","33","33","Nanga takk ci ombu mbubb mi ba mu daj, ay doomi gërënaat yu ñu defare wëñ gu baxa te laal yolet, ak wëñ gu xewar ak gu xonq curr, te diggante gërënaat yi, nga doxale ci ay jóolóoli yu wurus ba omb bi daj. ");
INSERT INTO wolmbs_vpl VALUES ("EX28_34","003_28_34","EXO","28","34","34","Ab jóolóolib wurus, ab doomu gërënaat, ab jóolóolib wurus, ab doomu gërënaat, ba ombu mbubb mi daj. ");
INSERT INTO wolmbs_vpl VALUES ("EX28_35","003_28_35","EXO","28","35","35","Na ko Aaróona sol bu nekkee ci liggéeyu sarxaleem. Su ko defee coowal jóolóoli yi di jib, ba buy jàll ci biir néeg bu sell bi, jëm fi kanam Aji Sax ji, mbaa mu di ci génne, du tax mu dee. ");
INSERT INTO wolmbs_vpl VALUES ("EX28_36","003_28_36","EXO","28","36","36","«Sàkkal dogu wurusu ngalam wu tell, nga ñaas ci mbind mii ni ñuy ñaase mbindum torlu: “Sell na, ñeel Aji Sax ji.” ");
INSERT INTO wolmbs_vpl VALUES ("EX28_37","003_28_37","EXO","28","37","37","Takke ko buum gu baxa te laal yolet ci kaw kaala gi, mu féete kanam. ");
INSERT INTO wolmbs_vpl VALUES ("EX28_38","003_28_38","EXO","28","38","38","Na tafu ci jëwu Aaróona, mu gàddoo ko ay wu tukkee ci lu bànni Israayil moy ci wàllu yëf yu sell yi ñu wara sellal ci seen mboolem sarax yu sell. Na nekk fàww ci jëëm, ndax Aji Sax ji nangul leen. ");
INSERT INTO wolmbs_vpl VALUES ("EX28_39","003_28_39","EXO","28","39","39","«Mbubb mu gudd mi nag, nanga ko ràbbe wëñu lẽe, kaala gi itam di wëñu lẽe. Te laxasaay gi, liggéeyu ràbb bu rafet lay doon. ");
INSERT INTO wolmbs_vpl VALUES ("EX28_40","003_28_40","EXO","28","40","40","«Doomi Aaróona yu góor yi itam, sàkkal leen ay jàllaabi. Sàkkal leen ay laxasaay. Ay mbaxana it, sàkkal leen ko ngir daraja ak teraanga bu sarxalkat wara yelloo. ");
INSERT INTO wolmbs_vpl VALUES ("EX28_41","003_28_41","EXO","28","41","41","Nanga solal yooyii sa mag Aaróona, mook ay doomam yu góor, te nga sotti leen diwu pal gi, dénk leen seen sas. Noonu nga leen di sédde céru cellte, ñu di ma sarxalal. ");
INSERT INTO wolmbs_vpl VALUES ("EX28_42","003_28_42","EXO","28","42","42","«Sàkkal leen ay tubéyi njiitlaayi lẽe, ñu sànge ko seeni cér, dale ko ci ndigg li ba ci lupp yi. ");
INSERT INTO wolmbs_vpl VALUES ("EX28_43","003_28_43","EXO","28","43","43","Na Aaróona aki doomam jiitloo loolu, bu ñuy dugg ci xaymab ndaje mi, mbaa ñuy jegeji sarxalukaay bi, ngir liggéey ci néeg bu sell bi, ndax ñu baña yóbbe seen bopp mbugal, muy seen dee. Na Aaróona ak askanam sàrtoo loolu fàww. ");
INSERT INTO wolmbs_vpl VALUES ("EX29_1","003_29_1","EXO","29","1","1","«Lii nag mooy li nga leen di defal, ngir sédd leen céru cellte, ngir ñu di ma sarxalal: dangay jël yëkk wu ndaw ak ñaari kuuy yu amul sikk, ");
INSERT INTO wolmbs_vpl VALUES ("EX29_2","003_29_2","EXO","29","2","2","ak mburu yu mag yu amul lawiir, ak kàmp yu sew yu amul lawiir yu ñu xiiwaale diw, ak mburu yu tàppandaar yu amul lawiir, ñu wis diw ca kaw, te sungufu bele su mucc ayib ngay defare yooyu. ");
INSERT INTO wolmbs_vpl VALUES ("EX29_3","003_29_3","EXO","29","3","3","Yebal lépp ci benn pañe te jébbale ko, mook yëkk wu ndaw wi ak ñaari kuuy yi. ");
INSERT INTO wolmbs_vpl VALUES ("EX29_4","003_29_4","EXO","29","4","4","Yóbbul Aaróona ak doomam yu góor, ba ca bunt xaymab ndaje ma, nga sang leen. ");
INSERT INTO wolmbs_vpl VALUES ("EX29_5","003_29_5","EXO","29","5","5","Nga jël yére yi nag, solal Aaróona jàllaabi bi ak mbubbam xar-sànni mi, teg ci xar-sànni mi, tegaat ci kiiraayal dënn bi, daldi koy takkal ngañaay liy tege ci xar-sànni mi. ");
INSERT INTO wolmbs_vpl VALUES ("EX29_6","003_29_6","EXO","29","6","6","Su ko defee nga kaala ko, takkal ko meeteel gu sell gi, fi kanam kaala gi. ");
INSERT INTO wolmbs_vpl VALUES ("EX29_7","003_29_7","EXO","29","7","7","Te nga jël diwu pal gi, sotti ko ci kaw boppam, diw ko. ");
INSERT INTO wolmbs_vpl VALUES ("EX29_8","003_29_8","EXO","29","8","8","Bu loolu weesoo, nga ne doomi Aaróona ñu jegesi, nga solal leen seeni jàllaabi, ");
INSERT INTO wolmbs_vpl VALUES ("EX29_9","003_29_9","EXO","29","9","9","te takkal Aaróona ak doomam yu góor ay laxasaay, solal leen mbaxana. Su ko defee ñu féetewoo céru sarxalkat, muy dogal bu sax dàkk. «Noonu ngay sase Aaróona ak doomam yu góor. ");
INSERT INTO wolmbs_vpl VALUES ("EX29_10","003_29_10","EXO","29","10","10","Nanga yóbbu yëkk wu ndaw wi ba ci bunt xaymab ndaje mi, Aaróona aki doomam teg seeni loxo ci kaw boppu yëkk wi, ");
INSERT INTO wolmbs_vpl VALUES ("EX29_11","003_29_11","EXO","29","11","11","nga daldi rendi yëkk wi fi kanam Aji Sax ji, fi bunt xaymab ndaje mi. ");
INSERT INTO wolmbs_vpl VALUES ("EX29_12","003_29_12","EXO","29","12","12","Sàkkal ci deretu yëkk wu ndaw wi, nga capp ci sa baaraam, diw ci ñeenti béjjéni sarxalukaay bi, te nga tuur li des ci deret ji ci taatu sarxalukaay bi. ");
INSERT INTO wolmbs_vpl VALUES ("EX29_13","003_29_13","EXO","29","13","13","Jëlal mboolem nebbon bi sàng yérey biir yi, ak bàjjo bi ci res wi, ak ñaari dëmbéen yi ànd ak nebbon bi ci kaw dëmbéen yi, nga boole lépp lakk ko ci kaw sarxalukaay bi. ");
INSERT INTO wolmbs_vpl VALUES ("EX29_14","003_29_14","EXO","29","14","14","Seen saraxu póotum bàkkaar a ngoogu. Li des ci yàppu yëkk wi, boole kook der bi, ak sébbriit mi, nga génne ko dal bi, lakk ko ca biti. ");
INSERT INTO wolmbs_vpl VALUES ("EX29_15","003_29_15","EXO","29","15","15","«Menn kuuy mi, jël ko, Aaróona ak doomam yu góor teg seeni loxo ci boppu kuuy mi, ");
INSERT INTO wolmbs_vpl VALUES ("EX29_16","003_29_16","EXO","29","16","16","ba noppi, nga rendi kuuy mi, jël deret ji, xëpp ko ci mboolem weti sarxalukaay bi. ");
INSERT INTO wolmbs_vpl VALUES ("EX29_17","003_29_17","EXO","29","17","17","Kuuy mi, nga def ko ay dog, daldi raxas yérey biir yi ak yeel yi, teg ci kaw dog yi ak bopp bi. ");
INSERT INTO wolmbs_vpl VALUES ("EX29_18","003_29_18","EXO","29","18","18","Lakkal kuuy mépp ci kaw sarxalukaay bi. Saraxu rendi-dóomal la, ñeel Aji Sax ji ngir xetug jàmm; saraxu sawara la, ñeel Aji Sax ji. ");
INSERT INTO wolmbs_vpl VALUES ("EX29_19","003_29_19","EXO","29","19","19","«Jëlal kuuy mi ci des, Aaróona ak doomam yu góor teg seeni loxo ci boppu kuuy mi. ");
INSERT INTO wolmbs_vpl VALUES ("EX29_20","003_29_20","EXO","29","20","20","Su ko defee nga rendi kuuy mi, sàkk ci deret ji, taqal ci tabanum noppu ndijooru Aaróona ak tabanum noppu ndijooru doomam yi, te nga taqal ci seen baaraamu déyu ndijoor, ak seen baaraamu déyu tànki ndijoor. Boo noppee, nga xëpp li des ci deret ji ci mboolem weti sarxalukaay bi. ");
INSERT INTO wolmbs_vpl VALUES ("EX29_21","003_29_21","EXO","29","21","21","Sàkkal ci deret ji ci sarxalukaay bi, ak ci diwu pal gi, nga wis-wisal ko ci kaw yaramu Aaróona ak ci kawi yéreem, wis-wisal ko ci kaw yarami doomam ak ci seen kawi yére. Su ko defee Aaróona sell, mooki yéreem, ay doomam it sell, ñook seeni yére. ");
INSERT INTO wolmbs_vpl VALUES ("EX29_22","003_29_22","EXO","29","22","22","«Kuuyum ñaareel mii, kuuyum xewu colug sarxalkat yi la. Nanga ci génne nebbon bi, muy calgeen bi ak nebbon bi sàng yérey biir yi, ak bàjjo bi ci res wi ak ñaari dëmbéen yeek nebbon bi ci seen kaw, ak tànku ndijoor bi. ");
INSERT INTO wolmbs_vpl VALUES ("EX29_23","003_29_23","EXO","29","23","23","Pañe biy taaje fi kanam Aji Sax ji te def mburu yu amul lawiir nag, nanga ci sàkke menn mburu mu wërngalu te tàppandaar wu amul lawiir, ak menn mburu mu ñu xiiwe diwu oliw, ak menn mburu mu ndaw te gëna sew. ");
INSERT INTO wolmbs_vpl VALUES ("EX29_24","003_29_24","EXO","29","24","24","Nga boole lépp, teg ko ci loxoy Aaróona aki doomam yu góor, ñu def ko sarax bu ñuy yékkati jébbal Aji Sax ji. ");
INSERT INTO wolmbs_vpl VALUES ("EX29_25","003_29_25","EXO","29","25","25","Nga daldi koy nangoo ci seeni loxo, lakk ko ci kaw sarxalukaay bi, boole kook saraxu rendi-dóomal bi, muy xeeñ xetug jàmm fi kanam Aji Sax ji. Saraxu sawaraa ngoogu, ñeel Aji Sax ji. ");
INSERT INTO wolmbs_vpl VALUES ("EX29_26","003_29_26","EXO","29","26","26","«Nanga jël dënn bi bokk ci kuuyum xewu colug Aaróona, nga def ko saraxu yékkati-jébbale, ñeel Aji Sax ji. Loolu moo cay sa wàll. ");
INSERT INTO wolmbs_vpl VALUES ("EX29_27","003_29_27","EXO","29","27","27","Nanga ber dënn bi ñu def saraxu yékkati-jébbale, beraale tànk bi ñu def saraxu yékkati-jébbale, te ñu jële ko ci kuuyu xewu colu gi, ñeel Aaróona aki doomam. ");
INSERT INTO wolmbs_vpl VALUES ("EX29_28","003_29_28","EXO","29","28","28","Aaróona aki sëtam la loolu di doon seen cér bu bànni Israayil di warlook ñoom ba fàww, ndax ab cér la, ci sarax yi bànni Israayil di génnee ci seen saraxi cant ci biir jàmm, muy seenub cér, ñeel Aji Sax ji. ");
INSERT INTO wolmbs_vpl VALUES ("EX29_29","003_29_29","EXO","29","29","29","«Yérey Aaróona yu sell yi nag, gannaaw bu dëddoo, dees koy féetale ay doomam, ñu fale leen ko ci seen xewu colug carxal. ");
INSERT INTO wolmbs_vpl VALUES ("EX29_30","003_29_30","EXO","29","30","30","Diiru juróom ñaari fan, ci la sarxalkat bi koy wuutu ci doomam yu góor, di sol yére yooyu, moom miy dugg ci biir xaymab ndaje mi, ci biir néeg bu sell bi. ");
INSERT INTO wolmbs_vpl VALUES ("EX29_31","003_29_31","EXO","29","31","31","«Nanga jël kuuyu xewu colu gi, nga baxal yàpp wi ci béreb bu sell. ");
INSERT INTO wolmbs_vpl VALUES ("EX29_32","003_29_32","EXO","29","32","32","Aaróona aki doomam ñooy lekk yàppu kuuy mi ci bunt xaymab ndaje mi, boole kook mburu mi ci pañe bi. ");
INSERT INTO wolmbs_vpl VALUES ("EX29_33","003_29_33","EXO","29","33","33","Ñam yooyu, ña koy lekk mooy ña muy seen saraxu njotlaay, keroog ca seen xewu colu, ga ñu leen tabbe ngir sellal leen. Waaye keneen du ci lekk, ndaxte ñam wu sell la. ");
INSERT INTO wolmbs_vpl VALUES ("EX29_34","003_29_34","EXO","29","34","34","Bu lenn ci yàppu xewu colu gi mbaa lenn ci mburu mi fanaanee ba bët set, nañu lakk loola ca fanaan ba mu jeex. Deesu ko lekk, ndaxte ñam wu sell la. ");
INSERT INTO wolmbs_vpl VALUES ("EX29_35","003_29_35","EXO","29","35","35","«Noonu ngay def ak Aaróona aki doomam, ni ma la ko sante rekk. Diiru juróom ñaari fan ci nga leen di sas, ");
INSERT INTO wolmbs_vpl VALUES ("EX29_36","003_29_36","EXO","29","36","36","te aw yëkk ngay def saraxu póotum bàkkaar bés bu nekk, muy seen njotlaay, di njotlaay liy setal sarxalukaay bi. Te itam nanga diw sarxalukaay bi ag diw, sellale ko ko. ");
INSERT INTO wolmbs_vpl VALUES ("EX29_37","003_29_37","EXO","29","37","37","Diiru juróom ñaari fan ngay defal sarxalukaay bi saraxu njotlaayam, sellale ko ko, ba sarxalukaay bi doon lu sella sell. Lépp lu laal sarxalukaay bi day séddu ci sellaayam. ");
INSERT INTO wolmbs_vpl VALUES ("EX29_38","003_29_38","EXO","29","38","38","«Lii mooy li ngay rendi ci kaw sarxalukaay bi: ñaari kuuyu menn at, bés bu nekk ba fàww. ");
INSERT INTO wolmbs_vpl VALUES ("EX29_39","003_29_39","EXO","29","39","39","Menn kuuy mi, ngeen sarxal ko ci suba, ñaareel bi, ngeen sarxal ko diggante ngoon ak jant bu so ");
INSERT INTO wolmbs_vpl VALUES ("EX29_40","003_29_40","EXO","29","40","40","Sàkkal ñetti kilo, yemook benn fukkeelu nattub sunguf su mucc ayib su ñu xiiwe benn liitar, yemook xaajaatub natt bi ñuy wax xiin ci diwu segalu oliw, ak saraxu tuurub benn liitaru biiñ, yemook xaajaatub xiin. Loolu yépp ànd ak menn kuuy mi. ");
INSERT INTO wolmbs_vpl VALUES ("EX29_41","003_29_41","EXO","29","41","41","Meneen kuuy mi, sarxeleen ko diggante ngoon ak jant bu so, mu ànd ak saraxu pepp ak saraxu tuuru bi, ni woon ci suba, muy xeeñ xetug jàmm, di saraxu sawara, ñeel Aji Sax ji. ");
INSERT INTO wolmbs_vpl VALUES ("EX29_42","003_29_42","EXO","29","42","42","Saraxu rendi-dóomal lay doon bu sax, te war seen maasoo maas fi bunt xaymab ndaje mi, ci kanam Aji Sax ji. Foofu laay dajeek yeen, te fa laay waxe ak yaw. ");
INSERT INTO wolmbs_vpl VALUES ("EX29_43","003_29_43","EXO","29","43","43","Foofa laay dajeek bànni Israayil, béreb ba doxe fa sell ndax samag leer. ");
INSERT INTO wolmbs_vpl VALUES ("EX29_44","003_29_44","EXO","29","44","44","Maay sellal xaymab ndaje mi ak sarxalukaay bi, te Aaróona aki doomam, maa leen di sellal, ngir ñu doon samay sarxalkat. ");
INSERT INTO wolmbs_vpl VALUES ("EX29_45","003_29_45","EXO","29","45","45","Maay dëkk fi digg bànni Israayil te maay nekk seen Yàlla. ");
INSERT INTO wolmbs_vpl VALUES ("EX29_46","003_29_46","EXO","29","46","46","Su boobaa bànni Israayil xam ne, man Aji Sax ji maay seen Yàlla, ji leen génnee réewum Misra, ngir dëkk fi seen biir. Man maay seen Yàlla Aji Sax ji. ");
INSERT INTO wolmbs_vpl VALUES ("EX30_1","003_30_1","EXO","30","1","1","«Sàkkal ab sarxalukaay bu ñuy taal cuuraay ci kawam. Bantu séng nga koy defare. ");
INSERT INTO wolmbs_vpl VALUES ("EX30_2","003_30_2","EXO","30","2","2","Guddaay bi di xasab, yaatuwaay bi di xasab; ab kaare lay doon, taxawaay bi di ñaari xasab, ay béjjénam ànd ak moom di benn bant bi. ");
INSERT INTO wolmbs_vpl VALUES ("EX30_3","003_30_3","EXO","30","3","3","Xoobal ko wurusu ngalam ci kaw gi ak ci wet yi ba mu daj, ak ci béjjén yi, te nga sàkkal ko kéméju wurus mu wër ko. ");
INSERT INTO wolmbs_vpl VALUES ("EX30_4","003_30_4","EXO","30","4","4","Ñaari noppi wurus nga koy sàkkal ci ron kéméj gi. Féetaleel nopp yi ci ñaari wetam, ñu jàkkaarloo, di téye banti njàppu yi ñu koy yóbboo. ");
INSERT INTO wolmbs_vpl VALUES ("EX30_5","003_30_5","EXO","30","5","5","Defal njàppu yi bantu séng te nga xoob njàppu yi wurus. ");
INSERT INTO wolmbs_vpl VALUES ("EX30_6","003_30_6","EXO","30","6","6","«Tegal sarxalukaayu cuuraay bi ci kanam rido bi làq gaalu àlluway seede si ak kubeeru njotlaay gi ci kaw gaalu àlluway seede si, foofu may dajejeek yaw. ");
INSERT INTO wolmbs_vpl VALUES ("EX30_7","003_30_7","EXO","30","7","7","Na fa Aaróona taal cuuraay suba su nekk. Buy toppatoo làmp yi lay taal cuuraay lu xeeñ li. ");
INSERT INTO wolmbs_vpl VALUES ("EX30_8","003_30_8","EXO","30","8","8","Bu Aaróona di taal làmp yi diggante ngoon ak jant bu so itam, na taal cuuraay lu xeeñ li. Cuuraay la su ñuy taal ba fàww, ci seen gépp maas fi kanam Aji Sax ji. ");
INSERT INTO wolmbs_vpl VALUES ("EX30_9","003_30_9","EXO","30","9","9","Deesu ci sarxal cuuraay lu ñu diglewul, deesu ci rendi saraxu dóomal, deesu ci def saraxu pepp mbaa saraxu tuuru. ");
INSERT INTO wolmbs_vpl VALUES ("EX30_10","003_30_10","EXO","30","10","10","Na Aaróona di sàkk ci deretu saraxu póotum bàkkaar bi, taqal ci béjjéni sarxalukaayu cuuraay bi, ngir def ko njotlaayal sarxalukaay bi benn yoon cim at. Benn yoon cim at lañu koy defal njotlaayam ci seen gépp maas. Sarxalukaay bu sella sell la, ñeel Aji Sax ji.» ");
INSERT INTO wolmbs_vpl VALUES ("EX30_11","003_30_11","EXO","30","11","11","Aji Sax ji waxati Musaa ne ko: ");
INSERT INTO wolmbs_vpl VALUES ("EX30_12","003_30_12","EXO","30","12","12","«Boo tolloo ci taxawal limeefu boppi bànni Israayil, na ku nekk ci ñoom fey Aji Sax ji njot-gi-bakkanam ba nga koy lim, ndax menn musiba bañ leena dikkal ci biir lim bi. ");
INSERT INTO wolmbs_vpl VALUES ("EX30_13","003_30_13","EXO","30","13","13","«Lii nag mooy li képp ku ñu bind ci limeef yi wara fey: dogu xaalis bu diisaay bi di genn-wàllu siikal, bi ñuy natte ci jaamookaay bi, dayo siikal boobu tollook ñaar fukki gera. Genn-wàllu siikal mu dib galag, ñeel Aji Sax ji. ");
INSERT INTO wolmbs_vpl VALUES ("EX30_14","003_30_14","EXO","30","14","14","Képp ku bindu ci limeef bi, te am ñaar fukki at, jëm kaw, na fey galag gi, ñeel Aji Sax ji. ");
INSERT INTO wolmbs_vpl VALUES ("EX30_15","003_30_15","EXO","30","15","15","Ki woomle du fey lu ëpp, ki néewle du fey lu yées genn-wàllu siikal, buy fey galagu Aji Sax ji ngir njot-gi-bakkanam. ");
INSERT INTO wolmbs_vpl VALUES ("EX30_16","003_30_16","EXO","30","16","16","Nanga nangoo xaalisu njot-gi-bakkan bi ci bànni Israayil, te nga féetale ko liggéeyu xaymab ndaje mi. Loolu pàttaliku lay doon, ñeel bànni Israayil fi kanam Aji Sax ji, ngir seen njot-gi-bakkan.» ");
INSERT INTO wolmbs_vpl VALUES ("EX30_17","003_30_17","EXO","30","17","17","Aji Sax ji waxati Musaa ne ko: ");
INSERT INTO wolmbs_vpl VALUES ("EX30_18","003_30_18","EXO","30","18","18","«Sàkkal mbalkam njàpp mu xànjar, ak tegub xànjaram ngir ñu di ko jàppe. Teg ko ci diggante xaymab ndaje mi ak sarxalukaay bi, te nga duy ko ndox. ");
INSERT INTO wolmbs_vpl VALUES ("EX30_19","003_30_19","EXO","30","19","19","Aaróona aki doomam di ci tanq, raxase seeni loxo ak seeni tànk. ");
INSERT INTO wolmbs_vpl VALUES ("EX30_20","003_30_20","EXO","30","20","20","Bu ñuy duggsi ci xaymab ndaje mi, nañu jàpp, ndax ñu baña dee, nañu jàpp itam, bu ñuy liggéeysi fi sarxalukaay bi, di saxaaral saraxu sawara, ñeel Aji Sax ji. ");
INSERT INTO wolmbs_vpl VALUES ("EX30_21","003_30_21","EXO","30","21","21","Nañu raxas seeni loxo ak seeni tànk, ndax ñu baña dee. Na loolu di dogal bu sax dàkk, ñeel Aaróona ak askanam ci seen gépp maas.» ");
INSERT INTO wolmbs_vpl VALUES ("EX30_22","003_30_22","EXO","30","22","22","Aji Sax ji waxati Musaa ne ko: ");
INSERT INTO wolmbs_vpl VALUES ("EX30_23","003_30_23","EXO","30","23","23","«Yaw nag, tànnal ngën-gi-xeeñal: xeetu ndàbb li ñuy wax miir bu ndoxe, sàkk ci juróomi kilo; xasum kanel mu xeeñ, ñaari kilo ak genn-wàll; yuuru gattax gu xeeñ, ñaari kilo ak genn-wàll; ");
INSERT INTO wolmbs_vpl VALUES ("EX30_24","003_30_24","EXO","30","24","24","ak xasum kaas, juróomi kilo, yemook juróomi téeméeri siikal, ci siikalu jaamookaay bi; ak ñeenti liitari diwu oliw, yemook benn natt bu ñuy wax xiin. ");
INSERT INTO wolmbs_vpl VALUES ("EX30_25","003_30_25","EXO","30","25","25","Loolu ngay def diwu pal gu sell gi, te na doon njafaan lu njafaan-kat waajal ba mu baax. Diwu pal gu sell lay doon. ");
INSERT INTO wolmbs_vpl VALUES ("EX30_26","003_30_26","EXO","30","26","26","«Nanga ci diw xaymab ndaje mi, diw ci gaal gi àlluway seede si dence, ");
INSERT INTO wolmbs_vpl VALUES ("EX30_27","003_30_27","EXO","30","27","27","ak taabal ji aki ndabam, ak tegukaayu làmp bi, ak jumtukaayam yépp, ak sarxalukaayu cuuraay bi. ");
INSERT INTO wolmbs_vpl VALUES ("EX30_28","003_30_28","EXO","30","28","28","Nanga ci diw itam sarxalukaayu saraxu rendi-dóomal bi, ak ndabam yépp, ak mbalkam njàpp mi akub tegoom. ");
INSERT INTO wolmbs_vpl VALUES ("EX30_29","003_30_29","EXO","30","29","29","Noonu ngay sellale yooyii, mu daldi doon lu sella sell. Lépp lu laal yooyii day doon lu sell. ");
INSERT INTO wolmbs_vpl VALUES ("EX30_30","003_30_30","EXO","30","30","30","Aaróona aki doomam itam, nanga leen diw. Noonu nga leen di sellale, ngir ñu doon samay sarxalkat. ");
INSERT INTO wolmbs_vpl VALUES ("EX30_31","003_30_31","EXO","30","31","31","«Nanga wax nag bànni Israayil ne leen: “Googu diw sama diwu pal gu sell lay doon, ci seen gépp maas. ");
INSERT INTO wolmbs_vpl VALUES ("EX30_32","003_30_32","EXO","30","32","32","Doom aadama ju ko jagoowul, deesu ko ko diw, te buleen njafaan lenn lu ni mel, lu ngeen yemale dayoy xeeñal ya ak dayoy diw gu sell gi. Deesu ko def ci yaramu kenn ku ko jagoowul, te buleen njafaan xeeñal yi ciy dem, ci dayo yu tollook dayoy diw gu sell gi, ngir defar lenn lu ni mel. Lu sell la, lu ngeen wara wormaal sellaayam. ");
INSERT INTO wolmbs_vpl VALUES ("EX30_33","003_30_33","EXO","30","33","33","Képp ku njafaan lu ni mel, mbaa mu taqal ci yaramu ku ci bokkul, dees koy dagge ci biir bànni Israayil.”» ");
INSERT INTO wolmbs_vpl VALUES ("EX30_34","003_30_34","EXO","30","34","34","Aji Sax ji waxati Musaa ne ko: «Wutal nag xeeñal yii: ndàbbu estaagte, ak ndàbbi galbanom, ak xori onigsë yu xeeñ, ak cuuraay-libaŋ lu raxul, te yooyu yépp tolloo dayo. ");
INSERT INTO wolmbs_vpl VALUES ("EX30_35","003_30_35","EXO","30","35","35","Def ko njafaan lu njafaan-kat waajal ba mu baax, xorom ko, mu set, sell. ");
INSERT INTO wolmbs_vpl VALUES ("EX30_36","003_30_36","EXO","30","36","36","Sàkk ci, wol ko ba mu mokk, nga teg ko fi kanam gaal gi àlluway seede si dence, fi biir xaymab ndaje mi, fi may dajeek yaw. Loolu lu sella sell la lu ngeen wara wormaal. ");
INSERT INTO wolmbs_vpl VALUES ("EX30_37","003_30_37","EXO","30","37","37","Waaye cuuraay loolu ngay njafaanlu nag, bu ci njafaanal sa bopp ci dayoy xeeñal yu ni tollu. Lu sell la lu ngeen wara wormaal, ñeel Aji Sax ji. ");
INSERT INTO wolmbs_vpl VALUES ("EX30_38","003_30_38","EXO","30","38","38","Képp ku defar lenn lu ni mel, ngir di ko xeeñoo, dees koy dagge ci bànni Israayil.» ");
INSERT INTO wolmbs_vpl VALUES ("EX31_1","003_31_1","EXO","31","1","1","Aji Sax ji waxati Musaa ne ko: ");
INSERT INTO wolmbs_vpl VALUES ("EX31_2","003_31_2","EXO","31","2","2","«Gisal, maa woo Beccalel ci turam. Beccalel, Uri mooy baayam; Uri, Ur Yudeen bi di baayam. ");
INSERT INTO wolmbs_vpl VALUES ("EX31_3","003_31_3","EXO","31","3","3","Maa ko feesale sama xel, xareñte ak déggin ak xam-xam ak manoorey bépp xeetu liggéey, ");
INSERT INTO wolmbs_vpl VALUES ("EX31_4","003_31_4","EXO","31","4","4","ngir muy nas ay liggéeyi wurus ak xaalis ak xànjar, ");
INSERT INTO wolmbs_vpl VALUES ("EX31_5","003_31_5","EXO","31","5","5","di yatt per yu muy tapp, di yatt bant, di liggéey lu nekk. ");
INSERT INTO wolmbs_vpl VALUES ("EX31_6","003_31_6","EXO","31","6","6","Maa ngii di ko tofal Oliyab doomu Axisamaag Daneen bi, te itam mboolem ñi xarala, may naa leen xelum xarala, ngir ñu ànd def mboolem lii ma la sant: ");
INSERT INTO wolmbs_vpl VALUES ("EX31_7","003_31_7","EXO","31","7","7","muy xaymab ndaje mi, ak gaalu àlluway seede si, ak kubeeru njotlaay gi ci kawam, ak mboolem jumtukaayi xayma bi— ");
INSERT INTO wolmbs_vpl VALUES ("EX31_8","003_31_8","EXO","31","8","8","taabal ji, ak ndab yi, ak tegukaayu làmpu wurusu ngalam beek yëfam yépp, ak sarxalukaayu cuuraay bi, ");
INSERT INTO wolmbs_vpl VALUES ("EX31_9","003_31_9","EXO","31","9","9","ak sarxalukaayu rendi-dóomal bi, ak ndabam yépp, ak mbalkam njàpp mi akub tegoom— ");
INSERT INTO wolmbs_vpl VALUES ("EX31_10","003_31_10","EXO","31","10","10","ak itam yére yu yànj yi, yére yu sell yi ñeel Aaróona sarxalkat bi ak yérey doomam, yi ñuy sol, di sarxale, ");
INSERT INTO wolmbs_vpl VALUES ("EX31_11","003_31_11","EXO","31","11","11","ak diwu pal gu sell gi, ak cuuraay lu xeeñ li ñeel néeg bu sell bi. Loolu ma la sant lépp, nañu ko defe noonu.» ");
INSERT INTO wolmbs_vpl VALUES ("EX31_12","003_31_12","EXO","31","12","12","Aji Sax ji waxati Musaa ne ko: ");
INSERT INTO wolmbs_vpl VALUES ("EX31_13","003_31_13","EXO","31","13","13","«Waxal bànni Israayil ne leen: “Fexeleen rekk ba sama bési Noflaay, ngeen di ko wormaal, ndax bésub Noflaay da di firnde sama digganteek yeen ak seen askan, ngir ngeen xam ne man Aji Sax ji maa leen ber, sellal leen. ");
INSERT INTO wolmbs_vpl VALUES ("EX31_14","003_31_14","EXO","31","14","14","Wormaalleen bésub Noflaay ndax lu sell la, ñeel leen. Ku ko teddadil, dee rekk mooy àtteem. Képp ku ci liggéey, kooku dees na ko dagge ci biiri bokkam. ");
INSERT INTO wolmbs_vpl VALUES ("EX31_15","003_31_15","EXO","31","15","15","Juróom benni fan lees wara liggéey, waaye bésub Noflaay bay juróom ñaareel ba, bés bu sell la, bésub Noflaay bu mat sëkk, ñeel Aji Sax ji. Képp ku liggéey bésub Noflaay, dee rekk mooy àtteem. ");
INSERT INTO wolmbs_vpl VALUES ("EX31_16","003_31_16","EXO","31","16","16","Na bànni Israayil wormaal bésub Noflaay, nañu sàmm bésub Noflaay, ñook seen askan. Kóllëre la gu sax dàkk. ");
INSERT INTO wolmbs_vpl VALUES ("EX31_17","003_31_17","EXO","31","17","17","Sama diggante laak bànni Israayil, te firnde la ju sax dàkk, ndax ci juróom benni fan la Aji Sax ji sàkk asamaan ak suuf, bésub juróom ñaareel ba, mu dallu, daldi yeeslu.”» ");
INSERT INTO wolmbs_vpl VALUES ("EX31_18","003_31_18","EXO","31","18","18","Ba Yàlla noppee wax ak Musaa ca kaw tundu Sinayi, da koo jox ñaari àlluway doj yu mu binde loxol boppam. ");
INSERT INTO wolmbs_vpl VALUES ("EX32_1","003_32_1","EXO","32","1","1","Ba mbooloo ma gisee Musaa yàgg lool te wàccul tund wa, dañoo songandoo Aaróona, ne ko: «Ayca, sàkkal nu ay yàlla yu nu jiite, ndax Musaa mii nu génne réewum Misra kat, xamunu lu ko dal.» ");
INSERT INTO wolmbs_vpl VALUES ("EX32_2","003_32_2","EXO","32","2","2","Aaróona ne leen: «Tekkileen boog, indil ma seen jaaroy wurusi nopp, yi ci seeni jabar ak seeni doom, góor ak jigéen.» ");
INSERT INTO wolmbs_vpl VALUES ("EX32_3","003_32_3","EXO","32","3","3","Ba loolu amee mbooloo mépp tekki seen jaaroy wurusi nopp, indil Aaróona. ");
INSERT INTO wolmbs_vpl VALUES ("EX32_4","003_32_4","EXO","32","4","4","Mu nangoo ko ci seeni loxo, liggéey ko ba sàkk ci sëllu wu ñu móol. Ci kaw loolu ñu naan: «Bànni Israayiloo, seen Yàllaa ngii, moo leen génne réewum Misra!» ");
INSERT INTO wolmbs_vpl VALUES ("EX32_5","003_32_5","EXO","32","5","5","Aaróona gis la xew, daldi tabax ci kanam sëllu wi ab sarxalukaay. Mu daldi yéene, ne: «Ëllëg màggal la, ñeel Aji Sax ji.» ");
INSERT INTO wolmbs_vpl VALUES ("EX32_6","003_32_6","EXO","32","6","6","Ca ëllëg sa mbooloo ma teela xëy, ñu def ay saraxi rendi-dóomal, ak ay saraxi cant ci biir jàmm. Ba mu ko defee ñu toog, di lekk aka naan, nes tuut ñu jóg, di mbumbaay. ");
INSERT INTO wolmbs_vpl VALUES ("EX32_7","003_32_7","EXO","32","7","7","Aji Sax ji nag waxati Musaa ne ko: «Gaawal wàcc, ndax sa mbooloo ma nga génne réewum Misra def nañu yàqute. ");
INSERT INTO wolmbs_vpl VALUES ("EX32_8","003_32_8","EXO","32","8","8","Jàdd nañu xaat yoon wa ma leen tegoon. Dañoo sàkkal seen bopp sëllu wu ñu móol, di ko sujjóotal aka sarxalal, naan: “Israayiloo, seen yàllaa ngii, moo leen génne réewum Misra!”» ");
INSERT INTO wolmbs_vpl VALUES ("EX32_9","003_32_9","EXO","32","9","9","Aji Sax ji dellu ne Musaa: «Maa gis askan wii, askan wu dëgër bopp a ngii! ");
INSERT INTO wolmbs_vpl VALUES ("EX32_10","003_32_10","EXO","32","10","10","Léegi seetaan ma rekk, sama sànj tàkkal leen, ba ma faagaagal leen, te du tee ma def la askan wu mag.» ");
INSERT INTO wolmbs_vpl VALUES ("EX32_11","003_32_11","EXO","32","11","11","Musaa nag tinu Yàllaam Aji Sax ji ne ko: «Aji Sax ji, ana lu waral sam sànj di tàkkal sa ñoñ ñi nga génne réewum Misra ci sa kàttan gu màgg ak sa dooley loxo? ");
INSERT INTO wolmbs_vpl VALUES ("EX32_12","003_32_12","EXO","32","12","12","Ana lu jar Misra di wax naan: “Musiba mi mu leen naraloon, ba mu leen di yiwi de, du lenn lu moy rey leen ba ñu jeex ca tund ya, ba fare leen kaw suuf sépp.” Ngalla dëddul sa sawaras sànj te nga fomm musiba mi nga naral sa ñoñ. ");
INSERT INTO wolmbs_vpl VALUES ("EX32_13","003_32_13","EXO","32","13","13","Bàyyil xel Ibraayma ak Isaaxa ak Israayil, sa jaam ñi nga giñaloon ci sa bopp, ne leen: “Maay yokk seen askan ni biddiiwi asamaan, te mboolem réew mii ma waxoon, maa koy jox seen askan, ñu moom ko fàww.”» ");
INSERT INTO wolmbs_vpl VALUES ("EX32_14","003_32_14","EXO","32","14","14","Ba loolu amee Aji Sax ji fomm musiba ma mu waxoon ne dina ko teg ñoñam. ");
INSERT INTO wolmbs_vpl VALUES ("EX32_15","003_32_15","EXO","32","15","15","Ba mu ko defee Musaa walbatiku, wàcce ca tund wa, mook ñaari àlluway seede ya ca loxoom, àlluwa yu ñu bind ñaari wet yépp, biir ak biti. ");
INSERT INTO wolmbs_vpl VALUES ("EX32_16","003_32_16","EXO","32","16","16","Àlluwa ya, liggéeyu Yàllaa, mbind ma di mbindum Yàlla mu ñaase ca kaw àlluwa ya. ");
INSERT INTO wolmbs_vpl VALUES ("EX32_17","003_32_17","EXO","32","17","17","Ci kaw loolu Yosuwe dégg coowal mbooloo may xaacu. Mu ne Musaa: «Coowal xaree ngoog ca dal ba!» ");
INSERT INTO wolmbs_vpl VALUES ("EX32_18","003_32_18","EXO","32","18","18","Musaa ne ko: «Coow loolu de du bàkku yu njàmbaar waral, du jooytu yu jéll sabab, woyi mbumbaay daal laa dégg.» ");
INSERT INTO wolmbs_vpl VALUES ("EX32_19","003_32_19","EXO","32","19","19","Ba Musaa jubee dal ba, ba gis sëllu wa ak pecc ma, mer mu ne jippét tàkk la ko def, mu sànni àlluwa ya mu ŋàbboon, mu ne tasar ca suufu tund wa. ");
INSERT INTO wolmbs_vpl VALUES ("EX32_20","003_32_20","EXO","32","20","20","Ci kaw loolu mu jël sëllu, wa ñu sàkk, lakk ko, wol ko ba mu mokk, mu suy cim ndox, daldi koy naanloo bànni Israayil. ");
INSERT INTO wolmbs_vpl VALUES ("EX32_21","003_32_21","EXO","32","21","21","Musaa nag ne Aaróona: «Lan la la mbooloo mii def, ba nga yóbbe leen gii moy gu réy?» ");
INSERT INTO wolmbs_vpl VALUES ("EX32_22","003_32_22","EXO","32","22","22","Aaróona ne ko: «Sang bi, rikk bul mer, yaw ci sa bopp xam nga ni mbooloo mii yeboo ci mbon. ");
INSERT INTO wolmbs_vpl VALUES ("EX32_23","003_32_23","EXO","32","23","23","Dañu ma ne: “Sàkkal nu ay yàlla yu nu jiite, ndax Musaa mii nu génne réewum Misra kat, xamunu lu ko dal.” ");
INSERT INTO wolmbs_vpl VALUES ("EX32_24","003_32_24","EXO","32","24","24","Ma ne leen: “Ku takk wurus, tekkil, indi!” Ñu jox ma, ma sànni ci sawara wi, sëllu wii génne ci!» ");
INSERT INTO wolmbs_vpl VALUES ("EX32_25","003_32_25","EXO","32","25","25","Musaa nag gis ni mbooloo mi ràkkaajoo, ndax fekk na Aaróona bay-bayal leen, ba ñu ràkkaaju, ba ku leen doon fexeel man leena ree. ");
INSERT INTO wolmbs_vpl VALUES ("EX32_26","003_32_26","EXO","32","26","26","Musaa taxaw ca bunt dal ba, ne: «Ku ànd ak Aji Sax ji, fii ci man!» Leween ñépp dikk, yéew ko. ");
INSERT INTO wolmbs_vpl VALUES ("EX32_27","003_32_27","EXO","32","27","27","Mu ne leen: «Aji Sax ji Yàllay Israayil dafa wax ne: Na ku nekk teg saamaram ci luppam, te ngeen wër dal bi bépp buntoo bunt, ba mu daj. Reyleen ñépp; doomu ndey, xarit ak jegeñaale.» ");
INSERT INTO wolmbs_vpl VALUES ("EX32_28","003_32_28","EXO","32","28","28","Ba loolu amee Leween ña def la leen Musaa sant. Ñi daanu ci bànni Israayil bésub keroog tollu na ci ñetti junniy góor. ");
INSERT INTO wolmbs_vpl VALUES ("EX32_29","003_32_29","EXO","32","29","29","Musaa nag ne: «Bés niki tey sasoo ngeen Aji Sax ji, gannaaw yeena dal ci kaw doom, dal ci kaw doomu ndey. Kon bésub tey tegoo ngeen barkeb Aji Sax ji.» ");
INSERT INTO wolmbs_vpl VALUES ("EX32_30","003_32_30","EXO","32","30","30","Ca ëllëg sa Musaa ne mbooloo ma: «Yeen de bàkkaar ngeen bàkkaar bu réy, waaye maa ngi nii di yéeg, jëm ci Aji Sax ji. Jombul ma jotul leen seen bàkkaar.» ");
INSERT INTO wolmbs_vpl VALUES ("EX32_31","003_32_31","EXO","32","31","31","Ba mu ko defee Musaa dellu ci Aji Sax ji, ne ko: «Éey Aji Sax ji, mbooloo mii de moy nañu la lool, ba ñu sàkkalee seen bopp ay yàllay wurus. ");
INSERT INTO wolmbs_vpl VALUES ("EX32_32","003_32_32","EXO","32","32","32","Léegi nag, soo leen dee baal seen bàkkaar, aa... Lu ko moy kat, far ma rekk ci téere bi nga bind.» ");
INSERT INTO wolmbs_vpl VALUES ("EX32_33","003_32_33","EXO","32","33","33","Aji Sax ji ne Musaa: «Ki ma moy, kooku doŋŋ laay far ci sama téere. ");
INSERT INTO wolmbs_vpl VALUES ("EX32_34","003_32_34","EXO","32","34","34","Yaw daal demal rekk, yóbbu mbooloo mi fa ma la waxoon, te sama malaakaa ngii di la jiituji. Waaye keroog sama bésu mbugal, maay mbugal mbooloo mi ndax seen bàkkaar.» ");
INSERT INTO wolmbs_vpl VALUES ("EX32_35","003_32_35","EXO","32","35","35","Gannaaw gi, Aji Sax ji mbugal na mbooloo ma ndax la ñu sàkkloo woon Aaróona aw sëllu. ");
INSERT INTO wolmbs_vpl VALUES ("EX33_1","003_33_1","EXO","33","1","1","Aji Sax ji waxati Musaa ne ko: «Doxal jóge fii, yaak mbooloo mi nga génne réewum Misra, ngeen dem ca réew ma ma giñaloon Ibraayma ak Isaaxa ak Yanqóoba, ne leen seen askan laa koy jox. ");
INSERT INTO wolmbs_vpl VALUES ("EX33_2","003_33_2","EXO","33","2","2","Maay yebal malaaka mu jiitu la, te maa fay dàqe Kanaaneen ña ak Amoreen ña ak Etteen ña ak Periseen ña ak Eween ña ak Yebuseen ña, ");
INSERT INTO wolmbs_vpl VALUES ("EX33_3","003_33_3","EXO","33","3","3","ba ngeen dugg ca réew mooma meew maak lem ja tuuroo. Waaye duma ànd ak yeen, lu ko moy dinaa leen faagaagal ci yoon wi, ndax askan wu dëgër bopp ngeen.» ");
INSERT INTO wolmbs_vpl VALUES ("EX33_4","003_33_4","EXO","33","4","4","Ba mbooloo ma déggee kàddu yu dëgër yooyu, dañoo daldi toroxlu, ba kenn takkootul gànjaram. ");
INSERT INTO wolmbs_vpl VALUES ("EX33_5","003_33_5","EXO","33","5","5","Fekk na Aji Sax ji wax Musaa ne ko: «Waxal bànni Israayil ne leen, ñoom askan wu dëgër bopp lañu. Su ma àndoon ak ñoom ab diir rekk, dinaa leen faagaagal. Kon nag nañu tàggook seeni gànjar, ba ma seet nu may def ak ñoom.» ");
INSERT INTO wolmbs_vpl VALUES ("EX33_6","003_33_6","EXO","33","6","6","Bànni Israayil a nga dale teqalikook seeni gànjar ca tundu Xoreb. ");
INSERT INTO wolmbs_vpl VALUES ("EX33_7","003_33_7","EXO","33","7","7","Musaa da daan toxal ab xayma, samp ko fu sorewaatook dal bi, ca biti. Mu di ko woowe xaymab ndaje mi. Ku amaan lu muy diis Aji Sax ji, da daan génn dal bi, dem ba ca xaymab ndaje mooma ca biti. ");
INSERT INTO wolmbs_vpl VALUES ("EX33_8","003_33_8","EXO","33","8","8","Bu Musaa jëmaan ca xayma ba, mbooloo mépp ay daldi taxaw, ku nekk tollu ci sa bunt xayma, di ko seetaan, ba mu dugg ca biir xayma ba. ");
INSERT INTO wolmbs_vpl VALUES ("EX33_9","003_33_9","EXO","33","9","9","Te bu Musaa duggaan ca xayma ba, taxaaru niir wa day wàcc, ne tekk ca bunt xayma ba, fekk Aji Sax jaa ngay wax ak Musaa. ");
INSERT INTO wolmbs_vpl VALUES ("EX33_10","003_33_10","EXO","33","10","10","Su ko defee bu mbooloo ma mépp gisee taxaaru niir wa taxaw ca bunt xayma ba, ñoom ñépp ay daldi sujjóot, ku nekk ca sa bunt xayma. ");
INSERT INTO wolmbs_vpl VALUES ("EX33_11","003_33_11","EXO","33","11","11","Aji Sax ji da daan wax ak Musaa ne ko jàkk. Mu ne ko jàkk, ni nit di waxe ak moroomam rekk. Bu ca Musaa jógee, daldi dellu ca dal ba, waaye bëkk-néegu Musaa, ngóor sa Yosuwe doomu Nuun, daawul génn biir xayma ba. ");
INSERT INTO wolmbs_vpl VALUES ("EX33_12","003_33_12","EXO","33","12","12","Musaa nag ne Aji Sax ji: «Waaw, yaw de yaa ngi ma naa ma yóbbu mbooloo mii, waaye xamaloo ma kan ngay yebal, mu ànd ak man. Yaa ma waxoon it ne ma: “Maa la xam ci saw tur, te it daj nga sama yiw.” ");
INSERT INTO wolmbs_vpl VALUES ("EX33_13","003_33_13","EXO","33","13","13","Gannaaw daj naa saw yiw nag, rikk xamal ma li nga namm, ba ma xam la. Su ko defee ma man di daj saw yiw. Te ngalla jàppal ne xeet wii kat, ñoo di sa ñoñ.» ");
INSERT INTO wolmbs_vpl VALUES ("EX33_14","003_33_14","EXO","33","14","14","Aji Sax ji ne ko: «Man ci sama bopp maay ànd ak yaw te maa lay noppal.» ");
INSERT INTO wolmbs_vpl VALUES ("EX33_15","003_33_15","EXO","33","15","15","Musaa ne ko: «Soo demul yaw ci sa bopp kay, bu nu jële fii! ");
INSERT INTO wolmbs_vpl VALUES ("EX33_16","003_33_16","EXO","33","16","16","Nees di xame ne daj naa saw yiw, maak sa ñoñ, te fekk ànduloo ak nun, ba nu doon, maak sa ñoñ, ñu ràññiku ci biir mboolem xeet yi ci kaw suuf?» ");
INSERT INTO wolmbs_vpl VALUES ("EX33_17","003_33_17","EXO","33","17","17","Aji Sax ji ne Musaa: «Loolu nga wax, moom laa lay defal, ndax daj nga samaw yiw, te it maa la xam ci saw tur.» ");
INSERT INTO wolmbs_vpl VALUES ("EX33_18","003_33_18","EXO","33","18","18","Musaa teg ca ne ko: «Ngalla may ma nag ma niir sag leer!» ");
INSERT INTO wolmbs_vpl VALUES ("EX33_19","003_33_19","EXO","33","19","19","Aji Sax ji ne ko: «Dinaa rombale sama gépp mbaax fi sa kanam, tey biralaale turu Aji Sax ji fi sa kanam. Maay baaxe ku ma neex, te maay ñeewante ku ma neex.» ");
INSERT INTO wolmbs_vpl VALUES ("EX33_20","003_33_20","EXO","33","20","20","Mu teg ca ne ko: «Doo mana gis sama kanam nag, ndax doom aadama du ma gis ba noppi di dund.» ");
INSERT INTO wolmbs_vpl VALUES ("EX33_21","003_33_21","EXO","33","21","21","Ci kaw loolu Aji Sax ji ne ko: «Xoolal fii ci sama wet, taxaweel ci kaw doj wi. ");
INSERT INTO wolmbs_vpl VALUES ("EX33_22","003_33_22","EXO","33","22","22","Bu sama leer di romb, maa lay làq fi xar-xaru doj wi, yiiraale la sama loxo, ba jàll, ");
INSERT INTO wolmbs_vpl VALUES ("EX33_23","003_33_23","EXO","33","23","23","doora dindi sama loxo, nga gis sama gannaaw, waaye sama kanam, maneesu koo gis.» ");
INSERT INTO wolmbs_vpl VALUES ("EX34_1","003_34_1","EXO","34","1","1","Aji Sax ji waxati Musaa ne ko: «Yattal ñaari àlluway doj yu mel ni yu njëkk ya, ma bind ci kàddu ya woon ca àlluwa yu njëkk ya nga toj. ");
INSERT INTO wolmbs_vpl VALUES ("EX34_2","003_34_2","EXO","34","2","2","Nanga waajal ëllëg, te nga teela yéegsi kaw tundu Sinayi wii, ba teewsi fi man ci njobbaxtalu tund wi. ");
INSERT INTO wolmbs_vpl VALUES ("EX34_3","003_34_3","EXO","34","3","3","Bu kenn ànd ak yaw, te bu kenn xand fenn kaw tund wi. Jur gi sax bumu forsi ci suufu tund wi, du gu gudd, du gu gàtt.» ");
INSERT INTO wolmbs_vpl VALUES ("EX34_4","003_34_4","EXO","34","4","4","Musaa nag yatt ñaari àlluway doj yu mel ni yu njëkk ya, ba noppi teela xëy, yéegi ca tundu Sinayi, na ko ko Aji Sax ji sante. Ma nga ŋàbb ñaari àlluway doj ya. ");
INSERT INTO wolmbs_vpl VALUES ("EX34_5","003_34_5","EXO","34","5","5","Aji Sax ji nag wàcc ci biir aw niir, taxaw ak Musaa foofa, daldi biral turam, ne: «Aji Sax ji.» ");
INSERT INTO wolmbs_vpl VALUES ("EX34_6","003_34_6","EXO","34","6","6","Ci kaw loolu Aji Sax ji romb fa kanam Musaa, di biral naan: «Aji Sax jee, Aji Sax ji, Yàlla jiy yërëme, di yéwéne, di muñ mer, boroom ngor gu bare gaak kóllëre ga. ");
INSERT INTO wolmbs_vpl VALUES ("EX34_7","003_34_7","EXO","34","7","7","Keey saxal ngor ba ci junniy maas yu toppante, di baale tooñ ak moy ak bàkkaar, te du ñàkka topp ku tooñ, ag tooñaangeem, xanaa di topp doom tooñu waajur, ba ca sët yaak sëtaat ya.» ");
INSERT INTO wolmbs_vpl VALUES ("EX34_8","003_34_8","EXO","34","8","8","Ba loolu amee Musaa ne gurub fa suuf, sujjóot, ");
INSERT INTO wolmbs_vpl VALUES ("EX34_9","003_34_9","EXO","34","9","9","ne ko: «Éey Boroom bi, ndegam daj naa saw yiw, rikk àndal ak nun rekk, Boroom bi, ak li mbooloo miy dëgër bopp lépp! Jéggal nu sunu ñaawtéef ak sunu bàkkaar rekk, te nga séddoo nu.» ");
INSERT INTO wolmbs_vpl VALUES ("EX34_10","003_34_10","EXO","34","10","10","Aji Sax ji ne ko: «Maa ngi nii di fas kóllëre ak yeen. Ci sa kanam mbooloo mépp laay def ay jaloore yu kenn masula amal ci àddina sépp, ak ci askan yépp, te mbooloo, mi nga nekk ci seen biir mépp ay gis jaloorey Aji Sax ji, jaloore ju raglu ji ma lay defal. ");
INSERT INTO wolmbs_vpl VALUES ("EX34_11","003_34_11","EXO","34","11","11","Bàyyileen xel bu baax li ma leen sant bésub tey jii. Maa ngii di leen dàqal Amoreen ñi ak Kanaaneen ñi ak Etteen ñi ak Periseen ñi ak Eween ñi ak Yebuseen ñi. ");
INSERT INTO wolmbs_vpl VALUES ("EX34_12","003_34_12","EXO","34","12","12","Moytuleena fas kóllëre ak niti réew ma ngeen jëm, bala ñoo doon ndëgg-sërëx ci seen biir. ");
INSERT INTO wolmbs_vpl VALUES ("EX34_13","003_34_13","EXO","34","13","13","Seeni sarxalukaay kay ngeen di màbb; seen tuuri doj, ngeen rajaxe; seen xer yi ñuy jaamoo Asera tuur mi, ngeen gor, ");
INSERT INTO wolmbs_vpl VALUES ("EX34_14","003_34_14","EXO","34","14","14","ndax waruleena jaamu jeneen yàlla, ngir Aji Sax ji, turu “Ku fiir ki” lay wuyoo, te Yàlla ju fiir la. ");
INSERT INTO wolmbs_vpl VALUES ("EX34_15","003_34_15","EXO","34","15","15","Buleen fas kóllëre ak niti réew ma, lu ko moy dinañu gànctook seeni tuur, rendil seeni tuur ay sarax, woo leen ca, ngeen lekk ca seeni sarax. ");
INSERT INTO wolmbs_vpl VALUES ("EX34_16","003_34_16","EXO","34","16","16","Te it bu ngeen jëlalee seeni doom jabar ca seen doom yu jigéen, seen jigéen ñooña dinañu gànctook seeni tuur, ba xiir seen doom yu góor ci gànctook seen tuur yooyu. ");
INSERT INTO wolmbs_vpl VALUES ("EX34_17","003_34_17","EXO","34","17","17","«Ay tuur yu ñu móole weñ, buleen ko móol. ");
INSERT INTO wolmbs_vpl VALUES ("EX34_18","003_34_18","EXO","34","18","18","«Màggalug ayu bésu Mburu mu amul lawiir, wormaalleen ko. Diiru juróom ñaari fan ngeen ciy lekk mburu mu amul lawiir, ni ma la ko sante bu àppam taxawee ci weeru Abiib, ndaxte weeru Abiib ngeen génne fa Misra. ");
INSERT INTO wolmbs_vpl VALUES ("EX34_19","003_34_19","EXO","34","19","19","«Bépp taaw bu góor maay boroom, ba ci lépp lu góor lu jur taawloo, muy nag mbaa gàtt. ");
INSERT INTO wolmbs_vpl VALUES ("EX34_20","003_34_20","EXO","34","20","20","Waaye lu góor lu mbaam taawloo, joteleen ko ab gàtt, mu wuutu ko. Su ngeen ko jotewul lu ko wuutu, dammleen loos wi. Képp kuy taaw bu góor ci seeni doom it, nangeen ko jot. Te itam bu kenn taxawe loxoy neen fi sama kanam. ");
INSERT INTO wolmbs_vpl VALUES ("EX34_21","003_34_21","EXO","34","21","21","«Juróom benni fan nag ngeen di liggéey, waaye bésub juróom ñaareel ba, dalluleen. Bu ngeen doon bey, bu ngeen doon góob, dalluleen. ");
INSERT INTO wolmbs_vpl VALUES ("EX34_22","003_34_22","EXO","34","22","22","«Màggalu ayu bésu Ngóob mi, nangeen ko wormaal, bu ngeen di góob gubi bele yi njëkka ñor, màggalu Farmàngu mi ci ndeetel at mi itam, màggalleen ko. ");
INSERT INTO wolmbs_vpl VALUES ("EX34_23","003_34_23","EXO","34","23","23","Ñetti yoon cim at la seen góor ñépp di teew fi kanam Boroom bi Aji Sax ji Yàllay Israayil. ");
INSERT INTO wolmbs_vpl VALUES ("EX34_24","003_34_24","EXO","34","24","24","Maa leen di dàqal ay xeet, ba yaatal seen suuf, te diiru ñetti yoon yi ngeen di teewi cim at fi kanam Yàlla Aji Sax ji, kenn du ci wuta nangu seenum réew. ");
INSERT INTO wolmbs_vpl VALUES ("EX34_25","003_34_25","EXO","34","25","25","«Buleen ma rendil benn sarax, di boole deret jeek lu am lawiir, te gàttu saraxu bésub Mucc, bumu fanaan ba bët set. ");
INSERT INTO wolmbs_vpl VALUES ("EX34_26","003_34_26","EXO","34","26","26","«Ngëneeli meññeef ma njëkka ñore ca seen suuf, moom ngeen di yóbbu seen kër Yàlla Aji Sax ji. «Ab tef, buleen ko togge soowum yaayam.» ");
INSERT INTO wolmbs_vpl VALUES ("EX34_27","003_34_27","EXO","34","27","27","Aji Sax ji teg ca ne ko: «Nanga bind yii santaane, ndax ci kaw santaane yii laa fasook yaw kóllëre, yaak bànni Israayil.» ");
INSERT INTO wolmbs_vpl VALUES ("EX34_28","003_34_28","EXO","34","28","28","Foofa la Musaa des ak Aji Sax ji diiru ñeent fukki guddi ak ñeent fukki bëccëg te lekkul, naanul. Aji Sax ji nag bind ci àlluwa yi, fukki santaane yi lal kóllëre gi. ");
INSERT INTO wolmbs_vpl VALUES ("EX34_29","003_34_29","EXO","34","29","29","Ci kaw loolu Musaa wàcc tundu Sinayi, ŋàbb ñaari àlluway seede sa. Naka la Musaa di wàcce ca tund wa, deru kanam ga di lerxat te yégu ko. Booba ñaaroom baak Yàlla moo waral loola. ");
INSERT INTO wolmbs_vpl VALUES ("EX34_30","003_34_30","EXO","34","30","30","Naka la Aaróona ak bànni Israayil gépp xoolaat Musaa, gisuñu lu moy deru kanam gay lerxat, ñu daldi koy ragala jege. ");
INSERT INTO wolmbs_vpl VALUES ("EX34_31","003_34_31","EXO","34","31","31","Musaa nag woo leen, Aaróona ak njiiti mbooloo ma yépp dikk, mu wax ak ñoom. ");
INSERT INTO wolmbs_vpl VALUES ("EX34_32","003_34_32","EXO","34","32","32","Gannaaw loolu bànni Israayil ga ca des gépp doora jegesi, mu dénk leen mboolem la Aji Sax ji waxoon ak moom ca kaw tundu Sinayi. ");
INSERT INTO wolmbs_vpl VALUES ("EX34_33","003_34_33","EXO","34","33","33","Musaa wax ak ñoom ba noppi, daldi muuroo kaala, làqe ko kanamam. ");
INSERT INTO wolmbs_vpl VALUES ("EX34_34","003_34_34","EXO","34","34","34","Saa yu Musaa teewiwaan fa kanam Aji Sax ji, ngir wax ak moom, day muri kaala gi ba ba muy génn; bu génnee, yegge bànni Israayil la ñu ko sant. ");
INSERT INTO wolmbs_vpl VALUES ("EX34_35","003_34_35","EXO","34","35","35","Bànni Israayil nag di gis kanamu Musaa ak na deru kanam gay lerxate. Su ko defee Musaa dellu muuruwaat, làq kanamam, ba ba muy demaat, ngir wax ak Aji Sax ji. ");
INSERT INTO wolmbs_vpl VALUES ("EX35_1","003_35_1","EXO","35","1","1","Musaa nag dajale mbooloom bànni Israayil mépp. Mu wax leen ne leen: «Lii mooy li Aji Sax ji santaane, ngir ñu def ko: ");
INSERT INTO wolmbs_vpl VALUES ("EX35_2","003_35_2","EXO","35","2","2","juróom benni fan lees di liggéey, waaye bésub juróom ñaareel ba, seen bésub Noflaay bu sell bu mat sëkk la, ñeel Aji Sax ji. Képp ku ci liggéey lenn, dees koy rey. ");
INSERT INTO wolmbs_vpl VALUES ("EX35_3","003_35_3","EXO","35","3","3","Buleen jafal sax sawara fenn ci seeni dëkkuwaay, ci bésub Noflaay.» ");
INSERT INTO wolmbs_vpl VALUES ("EX35_4","003_35_4","EXO","35","4","4","Musaa dellu wax ak mbooloom bànni Israayil mépp ne leen: «Lii mooy li Aji Sax ji santaane. ");
INSERT INTO wolmbs_vpl VALUES ("EX35_5","003_35_5","EXO","35","5","5","«Génneleen ci seen alal saraxu njébbal bu ñeel Aji Sax ji. Képp ku am yéene ji, na indil Aji Sax ji ab saraxu njébbal: wurus ak xaalis ak xànjar, ");
INSERT INTO wolmbs_vpl VALUES ("EX35_6","003_35_6","EXO","35","6","6","ak wëñ gu baxa te laal yolet, ak wëñ gu xewar, ak gu xonq curr, ak wëñu lẽe, ak kawari bëy ");
INSERT INTO wolmbs_vpl VALUES ("EX35_7","003_35_7","EXO","35","7","7","ak deri kuuy yu ñu wulli, suub xonq, ak deri piipi ak banti séng, ");
INSERT INTO wolmbs_vpl VALUES ("EX35_8","003_35_8","EXO","35","8","8","ak diwu oliw gu ñuy taaloo, ak ndàbb luy xeeñal diwug pal, di xeeñal cuuraay, ");
INSERT INTO wolmbs_vpl VALUES ("EX35_9","003_35_9","EXO","35","9","9","ak ay peri onigsë, ak yeneen per yu ñuy tapp ci xar-sànni meek kiiraayal dënn bi. ");
INSERT INTO wolmbs_vpl VALUES ("EX35_10","003_35_10","EXO","35","10","10","«Mboolem ku xareñ ci yeen, na ñëw, ngeen def li Aji Sax ji santaane lépp: ");
INSERT INTO wolmbs_vpl VALUES ("EX35_11","003_35_11","EXO","35","11","11","jaamookaay bi ak xaymaam ak kiiraayam aki keppoom aki làccam, ak galan yeek jën yeek tegu yi, ");
INSERT INTO wolmbs_vpl VALUES ("EX35_12","003_35_12","EXO","35","12","12","ak gaal geek ay njàppoom ak kubeer gi ñuy amale ag njotlaay, ak rido bi ko làq, ");
INSERT INTO wolmbs_vpl VALUES ("EX35_13","003_35_13","EXO","35","13","13","ak taabal jeeki njàppoom ak ndabam yépp ak mburum teewal mi, ");
INSERT INTO wolmbs_vpl VALUES ("EX35_14","003_35_14","EXO","35","14","14","ak tegukaayu làmp bi, aki jumtukaayam aki làmpam ak diwu làmp bi, ");
INSERT INTO wolmbs_vpl VALUES ("EX35_15","003_35_15","EXO","35","15","15","ak sarxalukaayu cuuraay bi aki njàppoom, ak diwu pal gu sell gi, ak cuuraay lu xeeñ li; ak kiiraayal buntu jaamookaay bi, ");
INSERT INTO wolmbs_vpl VALUES ("EX35_16","003_35_16","EXO","35","16","16","ak sarxalukaayu rendi-dóomal bi, ak caaxub xànjaram aki njàppoom ak li muy àndal lépp; mbalkam njàpp mi akub tegoom, ");
INSERT INTO wolmbs_vpl VALUES ("EX35_17","003_35_17","EXO","35","17","17","ak sor yi yéew jaamookaay bi aki jënam aki tegoom, ak lafu buntu ëtt bi, ");
INSERT INTO wolmbs_vpl VALUES ("EX35_18","003_35_18","EXO","35","18","18","ak xeri jaamookaay bi, ak jën yi yéew ëtt bi ak seeni buum, ");
INSERT INTO wolmbs_vpl VALUES ("EX35_19","003_35_19","EXO","35","19","19","ak yére yu yànj yi ñuy liggéeye ci néeg bu sell bi, yére yu sell yu Aaróona, sarxalkat bi, ak yérey doomam, yi ñuy sol bu ñuy sarxal.» ");
INSERT INTO wolmbs_vpl VALUES ("EX35_20","003_35_20","EXO","35","20","20","Ci kaw loolu mbooloom bànni Israayil gépp bàyyikoo fa Musaa. ");
INSERT INTO wolmbs_vpl VALUES ("EX35_21","003_35_21","EXO","35","21","21","Ba mu ko defee mboolem ña ca am pastéefu xol ak mboolem ña ca seen xel xiir, ñépp dikk, indil Aji Sax ji saraxu njébbal ngir defar xaymab ndaje mi, yékkati ko, tey def màggal gi mu laaj, ngir itam defar yére yu sell yi. ");
INSERT INTO wolmbs_vpl VALUES ("EX35_22","003_35_22","EXO","35","22","22","Góor ak jigéen bokk dikk, mboolem ñi am yéeney xolam, mboolem ñi bëgga indi wurus, defal ko Aji Sax ji saraxu yékkati-jébbale; ñii indi ay lam, ñii jaaroy nopp, ñii jaaroy loxo, ñii ay caq, ñii ay gànjari wurus yu nekk rekk. ");
INSERT INTO wolmbs_vpl VALUES ("EX35_23","003_35_23","EXO","35","23","23","Te it mboolem ñi dencoon wëñ gu baxa te laal yolet, ak wëñ gu xewar, ak gu xonq curr ak wëñu lẽe, ak kawari bëy mbaa deri kuuy yu ñu suub xonq, mbaa deri piipi, ñoom ñépp a indi la ñu dencoon. ");
INSERT INTO wolmbs_vpl VALUES ("EX35_24","003_35_24","EXO","35","24","24","Képp ku namma jébbal xaalis mbaa xànjar, jébbal nga ko Aji Sax ji, te itam képp ku dencoon bantu séng bu jëm ci mboolem liggéeyu sarxal bi, indi nga bant bi. ");
INSERT INTO wolmbs_vpl VALUES ("EX35_25","003_35_25","EXO","35","25","25","Ci biir loolu jigéen ñu xareñ ñépp ëcce seeni loxo, ngir waajal wëñ gu baxa te laal yolet, ak wëñ gu xewar, ak gu xonq curr ak wëñu lẽe, ñu boole, indi. ");
INSERT INTO wolmbs_vpl VALUES ("EX35_26","003_35_26","EXO","35","26","26","Mboolem jigéen ñi ko mane te am yéeneem itam, daldi ëcc kawari bëy. ");
INSERT INTO wolmbs_vpl VALUES ("EX35_27","003_35_27","EXO","35","27","27","Njiit yi nag indi ay peri onigsë ak yeneen per yiy tappe ci xar-sànni meek kiiraayal dënn bi, ");
INSERT INTO wolmbs_vpl VALUES ("EX35_28","003_35_28","EXO","35","28","28","aki xeeñal, akug diw ngir làmp beek diwu pal geek cuuraay lu xeeñ li. ");
INSERT INTO wolmbs_vpl VALUES ("EX35_29","003_35_29","EXO","35","29","29","Mboolem bànni Israayil, góor ñeek jigéen ñi am yéeney indi lu jëm ci liggéey bi Aji Sax ji santaane, Musaa jottali, ñoom ñépp a indil Aji Sax ji ay saraxi yéene. ");
INSERT INTO wolmbs_vpl VALUES ("EX35_30","003_35_30","EXO","35","30","30","Musaa nag ne bànni Israayil: «Gisleen, Aji Sax ji moo woo Beccalel ci turam. Beccalel, Uri mooy baayam; Uri, Ur Yudeen bi di baayam. ");
INSERT INTO wolmbs_vpl VALUES ("EX35_31","003_35_31","EXO","35","31","31","Moo ko feesale xelum Yàlla ak xareñte ak déggin ak xam-xam ak manoorey bépp xeetu liggéey, ");
INSERT INTO wolmbs_vpl VALUES ("EX35_32","003_35_32","EXO","35","32","32","ngir muy nas ay liggéeyi wurus ak xaalis ak xànjar, ");
INSERT INTO wolmbs_vpl VALUES ("EX35_33","003_35_33","EXO","35","33","33","di yatt per yu muy tapp, di yatt bant, di liggéey lu nekk. ");
INSERT INTO wolmbs_vpl VALUES ("EX35_34","003_35_34","EXO","35","34","34","Mayu jàngale itam Aji Sax ji yeb na ko cib dënnam, moom ak Oliyab, Daneen bi, doomu Axisamaag; ");
INSERT INTO wolmbs_vpl VALUES ("EX35_35","003_35_35","EXO","35","35","35","te moo leen feesal xareñte, ngir bépp liggéey, ci wàllu yatt ak nataal, ak liggéeyu wëñ gu baxa te laal yolet, ak wëñ gu xewar, ak gu xonq curr ak wëñu lẽe. Mane nañoo ràbb te itam dañuy sos seen taarali bopp. ");
INSERT INTO wolmbs_vpl VALUES ("EX36_1","003_36_1","EXO","36","1","1","«Kon nag Beccalel ak Oliyab ak mboolem ñu xareñ ñi Aji Sax ji may xareñte ak déggin ngir ñu mana jëfe mboolem sas yi jëm ci liggéeyu néeg bu sell bi, ñoom ñépp nañu sottal lépp li Aji Sax ji santaane.» ");
INSERT INTO wolmbs_vpl VALUES ("EX36_2","003_36_2","EXO","36","2","2","Ba loolu amee Musaa woo Beccalel ak Oliyab ak mboolem ñi xareñ ñi Aji Sax ji xareñal, mboolem ñi am yéeney wàllsi ci liggéey bi, ngir sottal ko. ");
INSERT INTO wolmbs_vpl VALUES ("EX36_3","003_36_3","EXO","36","3","3","Ba mu ko defee ñu nangoo ci Musaa mboolem saraxu njébbal bu bànni Israayil indi, ngir sottal liggéeyu néeg bu sell bi. Bànni Israayil nag jàppoo suba gu jot di indil Musaa ay saraxi yéene, ");
INSERT INTO wolmbs_vpl VALUES ("EX36_4","003_36_4","EXO","36","4","4","ba mboolem liggéeykat yu xareñ yi nekkoon ci mboolem liggéeyu néeg bu sell bi, kenn ku ci nekk bàyyi la nga jàppoon, daldi dikk. ");
INSERT INTO wolmbs_vpl VALUES ("EX36_5","003_36_5","EXO","36","5","5","Ñu ne Musaa: «Li mbooloo mi indi wees na dayob liggéey bi Aji Sax ji santaane.» ");
INSERT INTO wolmbs_vpl VALUES ("EX36_6","003_36_6","EXO","36","6","6","Musaa nag yéenelu ca dal ba bépp, ñu ne, ñépp, góor ak jigéen, bu ci kenn waajalati saraxu njébbal, ñeel néeg bu sell bi. Fa la mbooloo ma noppee indi. ");
INSERT INTO wolmbs_vpl VALUES ("EX36_7","003_36_7","EXO","36","7","7","Booba jumtukaay ya doyoon na sëkk, ba ëpp sax la ñu cay liggéey lépp. ");
INSERT INTO wolmbs_vpl VALUES ("EX36_8","003_36_8","EXO","36","8","8","Ba loolu amee mboolem ñu xareñ ñi bokk ci liggéey bi daldi defar xaymab jaamookaay bi. Ñu def ko fukki sori rabali lẽe, yu ànd ak wëñ gu baxa te laal yolet, ak wëñ gu xewar ak gu xonq curr. Ñu ñawaale ci ay nataali serub. ");
INSERT INTO wolmbs_vpl VALUES ("EX36_9","003_36_9","EXO","36","9","9","Guddaayu sor bu nekk di ñaar fukki xasab ak juróom ñett, yaatuwaay bi di ñeenti xasab, sor yépp tolloo. ");
INSERT INTO wolmbs_vpl VALUES ("EX36_10","003_36_10","EXO","36","10","10","Ñu taqale yii juróomi sor, taqale juróomi sor yi ci des. ");
INSERT INTO wolmbs_vpl VALUES ("EX36_11","003_36_11","EXO","36","11","11","Ci kaw loolu ñu ñaw ay takku yu baxa te laal yolet ci catal sor bi mujj ci benn taqalante bi, sor bi jeexal taqalante bi ci des it, ñu def ko noonu. ");
INSERT INTO wolmbs_vpl VALUES ("EX36_12","003_36_12","EXO","36","12","12","Juróom fukki takku lañu ñaw ci benn sor bi, ak juróom fukki takku ci catal sor bi jeexal taqalante bi ci des, takku yi yemoo. ");
INSERT INTO wolmbs_vpl VALUES ("EX36_13","003_36_13","EXO","36","13","13","Ñu defar juróom fukki lonkuy wurus, daldi jokkalantee sor yi lonku yi, ba xaymab jaamookaay bi di benn. ");
INSERT INTO wolmbs_vpl VALUES ("EX36_14","003_36_14","EXO","36","14","14","Ba loolu weesoo ñu ràbb ay sori kawari bëy, ngir def ko ab xayma, muy kiiraay ci kaw jaamookaay bi. Fukk ak benn lañu def sor yi. ");
INSERT INTO wolmbs_vpl VALUES ("EX36_15","003_36_15","EXO","36","15","15","Guddaayu sor bu nekk fanweeri xasab la, yaatuwaay bi di ñeenti xasab, te fukki sor yeek benn yépp a tolloo dayo. ");
INSERT INTO wolmbs_vpl VALUES ("EX36_16","003_36_16","EXO","36","16","16","Ñu taqale yii juróomi sor, juróom benni sor yi ci des it noonu. ");
INSERT INTO wolmbs_vpl VALUES ("EX36_17","003_36_17","EXO","36","17","17","Ñu sàkk juróom fukki takku ci catal sor bi jeexal benn taqalante bi, daldi sàkk juróom fukki takku itam ci catal sor bi jeexal taqalante bi ci des. ");
INSERT INTO wolmbs_vpl VALUES ("EX36_18","003_36_18","EXO","36","18","18","Ñu sàkk nag juróom fukki lonkuy xànjar yu ñu jokkalantee ñaari taqalante yi, muy benn xayma. ");
INSERT INTO wolmbs_vpl VALUES ("EX36_19","003_36_19","EXO","36","19","19","Ñu defaral xayma bi malaanum deri kuuy yu ñu sóob xonq, ak meneen malaanum deri piipi muy tege ci kawam. ");
INSERT INTO wolmbs_vpl VALUES ("EX36_20","003_36_20","EXO","36","20","22","Gannaaw gi, ñu sàkkal xaymab jaamookaay bi ay làcci bantu séng yu sampe. Làcc wu nekk am ñaari kenu yu ñu lëkkalee galan yu ndaw, te noonu lañu def làcci jaamookaay bi yépp. Fukki xasab lañu def taxawaayu làcc wu nekk, def yaatuwaay bi xasab ak genn-wàll. ");
INSERT INTO wolmbs_vpl VALUES ("EX36_23","003_36_23","EXO","36","23","23","Ci wàllu làcci jaamookaay bi, ñu sësale ñaar fukki làcc fi féete bëj-saalum, ");
INSERT INTO wolmbs_vpl VALUES ("EX36_24","003_36_24","EXO","36","24","24","boole kook ñeent fukki tegukaayi xaalis yu ronu kenuy ñaar fukki làcc yi, ñaari tegukaay ronu làcc wi jiitu ngir ñaari kenoom yi mu àndal, ñaari tegu topp ci, ronu wépp làcc wu ci topp, ngir ñaari kenoom yi mu àndal. ");
INSERT INTO wolmbs_vpl VALUES ("EX36_25","003_36_25","EXO","36","25","25","Geneen wetu jaamookaay gi féete bëj-gànnaar itam, ñu def ko ñaar fukki làcc, ");
INSERT INTO wolmbs_vpl VALUES ("EX36_26","003_36_26","EXO","36","26","26","ak seen ñeent fukki teguy xaalis, ñaari tegu ronu làcc wi jiitu, ñaari tegu topp ci, ronu wépp làcc wu ci topp. ");
INSERT INTO wolmbs_vpl VALUES ("EX36_27","003_36_27","EXO","36","27","27","Wetu gannaaw jaamookaay gi féete sowu, ñu sàkkal ko juróom benni làcc, ");
INSERT INTO wolmbs_vpl VALUES ("EX36_28","003_36_28","EXO","36","28","28","teg ci ñaari làcc ngir colli jaamookaay bi ci gannaaw, ");
INSERT INTO wolmbs_vpl VALUES ("EX36_29","003_36_29","EXO","36","29","29","ñu àndandoo di benn ci suuf te lëkkaloo ci kaw ci benn lam kepp. Noonu lañu leen def ñoom ñaar, ñuy ñaari coll yi. ");
INSERT INTO wolmbs_vpl VALUES ("EX36_30","003_36_30","EXO","36","30","30","Muy juróom ñetti làcc ak seeni teguy xaalis; di fukki tegu ak juróom benn, ñaari tegu ronu làcc wu nekk. ");
INSERT INTO wolmbs_vpl VALUES ("EX36_31","003_36_31","EXO","36","31","31","Gannaaw loolu ñu sàkk ay galani bantu séng, juróomi galan yiy ànd ak làcc yi ci genn wetu jaamookaay bi, ");
INSERT INTO wolmbs_vpl VALUES ("EX36_32","003_36_32","EXO","36","32","32","ak juróomi galan ngir làcci wet gi ci des, ak juróomi galan ngir làcc yi ci gannaaw jaamookaay bi, fi féete sowu. ");
INSERT INTO wolmbs_vpl VALUES ("EX36_33","003_36_33","EXO","36","33","33","Ñu def galanu digg bi ci digg làcc yi, dale ko cat ba cat. ");
INSERT INTO wolmbs_vpl VALUES ("EX36_34","003_36_34","EXO","36","34","34","Ci biir loolu ñu xoob làcc yi wurus, sàkkal leen ay lami wurus yuy téye galan yi, daldi xoob galan yi it wurus. ");
INSERT INTO wolmbs_vpl VALUES ("EX36_35","003_36_35","EXO","36","35","35","Ñu sàkk itam rido bi, ràbbe ko wëñ gu baxa te laal yolet, ak wëñ gu xewar, ak gu xonq curr ak wëñu lẽe, ñawaale ci ay nataali serub. ");
INSERT INTO wolmbs_vpl VALUES ("EX36_36","003_36_36","EXO","36","36","36","Ñu sàkkal rido bi ñeenti jëni séng yu ñu xoobe wurus, jën yi ànd ak wékkukaayi wurus, ñu móolal jën yi ñeenti teguy xaalis. ");
INSERT INTO wolmbs_vpl VALUES ("EX36_37","003_36_37","EXO","36","37","37","Ñu sàkkal buntu xayma bi kiiraay lu ñu ràbbe wëñ gu baxa te laal yolet, ak wëñ gu xewar, ak gu xonq curr ak wëñu lẽe, mu doon liggéeyu ràbb bu rafet, ");
INSERT INTO wolmbs_vpl VALUES ("EX36_38","003_36_38","EXO","36","38","38","ak juróomi jënam yu ànd ak seeni wékkukaay. Ñu xoob nag wurus boppi jën yi ak seeni galan, juróomi teguy jën yi di xànjar. ");
INSERT INTO wolmbs_vpl VALUES ("EX37_1","003_37_1","EXO","37","1","1","Beccalel nag defare gaalu kóllëre gi dénku séng, guddaay bi di ñaari xasab ak genn-wàll, yaatuwaay bi di xasab ak genn-wàll, taxawaay bi di xasab ak genn-wàll. ");
INSERT INTO wolmbs_vpl VALUES ("EX37_2","003_37_2","EXO","37","2","2","Mu xoob ko wurusu ngalam biir ak biti, sàkkal ko kéméju wurus gu ko wër. ");
INSERT INTO wolmbs_vpl VALUES ("EX37_3","003_37_3","EXO","37","3","3","Mu daldi koy móolal ñeenti lami wurus ci ñeenti tànkam, ñaari lam ci genn wet gi, ñaar, wet gi ci des. ");
INSERT INTO wolmbs_vpl VALUES ("EX37_4","003_37_4","EXO","37","4","4","Mu sàkk nag ay njàppuy bantu séng, xoob bu ci nekk wurus, ");
INSERT INTO wolmbs_vpl VALUES ("EX37_5","003_37_5","EXO","37","5","5","daldi roof njàppu yi ci lam yi ci weti gaal gi, ngir ñu di ko yóbboo gaal gi. ");
INSERT INTO wolmbs_vpl VALUES ("EX37_6","003_37_6","EXO","37","6","6","Ci kaw loolu mu sàkk kubeer ga ñuy awale njotlaay gu wurusu ngalam, guddaay bi di ñaari xasab ak genn-wàll, yaatuwaay bi di xasab ak genn-wàll. ");
INSERT INTO wolmbs_vpl VALUES ("EX37_7","003_37_7","EXO","37","7","7","Mu sàkk itam ñaari malaakay serub yu wurus. Liggéeyu tëgg bu jekk la def serub yi ci ñaari cati kubeeru njotlaay gi, ");
INSERT INTO wolmbs_vpl VALUES ("EX37_8","003_37_8","EXO","37","8","8","cat lii ab serub, cat lee ab serub, mu móolaale kubeer gi ak serub yi ci ñaari cat yi, ñu ànd di benn. ");
INSERT INTO wolmbs_vpl VALUES ("EX37_9","003_37_9","EXO","37","9","9","Serub yaa ngi tàllal seeni laaf, jëme kaw, yiire kubeer gi seeni laaf te janoo, seeni kanam jublook kubeeru njotlaay gi. ");
INSERT INTO wolmbs_vpl VALUES ("EX37_10","003_37_10","EXO","37","10","10","Ci biir loolu Beccalel sàkk taabalu bantu séng, guddaay bi di ñaari xasab, yaatuwaay bi di xasab, taxawaay bi di xasab ak genn-wàll. ");
INSERT INTO wolmbs_vpl VALUES ("EX37_11","003_37_11","EXO","37","11","11","Mu xoob ko wurusu ngalam, defal ko kéméju wurus bu ko wër. ");
INSERT INTO wolmbs_vpl VALUES ("EX37_12","003_37_12","EXO","37","12","12","Mu defal ko it pegg bu ko wër bu tollu ci yaatuwaayu ñeenti baaraam, ba noppi sàkkal pegg bi kéméju wurus, wëralee ko ko. ");
INSERT INTO wolmbs_vpl VALUES ("EX37_13","003_37_13","EXO","37","13","13","Mu móolal taabal ji ñeenti lami wurus, daldi we lam yi ci ñeenti wet yi, fi fareek ñeenti tànk yi, ");
INSERT INTO wolmbs_vpl VALUES ("EX37_14","003_37_14","EXO","37","14","14","lam yi dendeek pegg bi, di téye njàppu, yi ñuy yóbboo taabal ji. ");
INSERT INTO wolmbs_vpl VALUES ("EX37_15","003_37_15","EXO","37","15","15","Mu sàkk ay njàppuy bantu séng, xoob ko wurus, ñu di ko yóbboo taabal ji. ");
INSERT INTO wolmbs_vpl VALUES ("EX37_16","003_37_16","EXO","37","16","16","Ci kaw loolu mu sàkk jumtukaay yiy tege ci taabal ji; ndabam yu tell aki mbàttoom aki njaqam, ak këllam yi ñuy tuural Yàlla, lépp di wurusu ngalam. ");
INSERT INTO wolmbs_vpl VALUES ("EX37_17","003_37_17","EXO","37","17","17","Beccalel sàkk itam tegukaayu làmp bu wurusu ngalam. Liggéeyu tëgg bu jekk la def tegukaayu làmp bi, ak taatu tegukaay bi, ak peru tegukaay bi, ay kaasam aki kàmbóotam aki mbaram, lépp ànd ak tegukaay bi, di benn. ");
INSERT INTO wolmbs_vpl VALUES ("EX37_18","003_37_18","EXO","37","18","18","Juróom benni car a soqikoo ci weti tegukaayu làmp bi, ñetti car ci gii wet, ñett ci gi ci des. ");
INSERT INTO wolmbs_vpl VALUES ("EX37_19","003_37_19","EXO","37","19","19","Ñetti kaas yu bindoo ni tóor-tóori garabu amànd ñoo nekk ci benn car bi, kaas bu ci nekk ànd ak ay kàmbóotam aki mbaram, ñetti kaas yu bindoo ni tóor-tóori garabu amànd nekk ci car bi ci topp, kaas bu ci nekk ànd aki kàmbóotam aki mbaram, ba juróom benni car yi soqikoo ci per bi, daj. ");
INSERT INTO wolmbs_vpl VALUES ("EX37_20","003_37_20","EXO","37","20","20","Peru tegukaayu làmp bi itam am na ñeenti kaas yu bindoo ni tóor-tóori garabu amànd, ànd ak ay kàmbóotam aki mbaram. ");
INSERT INTO wolmbs_vpl VALUES ("EX37_21","003_37_21","EXO","37","21","21","Ab kàmbóot a ronu ñaari car, jàpp ci, beneen kàmbóot ronu ñaari car yi ci topp, jàpp ci, ab kàmbóot ronu ñaari car yi mujj, jàpp ci, juróom benni car yi soqikoo ci weti per bi, daj. ");
INSERT INTO wolmbs_vpl VALUES ("EX37_22","003_37_22","EXO","37","22","22","Kàmbóot yi ak car yi nag ànd ak tegukaay bi, di wenn donju wurusu ngalam wu ñu tëgg ba mu jekk. ");
INSERT INTO wolmbs_vpl VALUES ("EX37_23","003_37_23","EXO","37","23","23","Mu sàkk juróom ñaari làmpam ak ay ñiimi feyukaayam ak ay andam, lépp di wurusu ngalam. ");
INSERT INTO wolmbs_vpl VALUES ("EX37_24","003_37_24","EXO","37","24","24","Benn talaŋu wurusu ngalam, yemook fanweeri kilo, ci la sàkk tegukaayu làmp bi ak mboolem ay jumtukaayam. ");
INSERT INTO wolmbs_vpl VALUES ("EX37_25","003_37_25","EXO","37","25","25","Ci kaw loolu Beccalel sàkk ci bantu séng sarxalukaayu cuuraay bu kaare, guddaay bi di xasab, yaatuwaay bi di xasab, taxawaay bi di ñaari xasab, ay béjjénam ànd ak moom di benn bant bi. ");
INSERT INTO wolmbs_vpl VALUES ("EX37_26","003_37_26","EXO","37","26","26","Mu xoob ko wurusu ngalam ci kaw ak ci wet yi ba mu daj, ak béjjén yi, daldi koy sàkkal kéméju wurus gu ko wër. ");
INSERT INTO wolmbs_vpl VALUES ("EX37_27","003_37_27","EXO","37","27","27","Ñaari noppi wurus la ko sàkkal ci ron kéméj gi, ci ñaari wetam, ñu jàkkaarloo, di téye banti njàppu yi ñu koy yóbboo. ");
INSERT INTO wolmbs_vpl VALUES ("EX37_28","003_37_28","EXO","37","28","28","Ci biir loolu mu sàkk ay njàppuy bantu séng, xoob lu ci nekk wurus. ");
INSERT INTO wolmbs_vpl VALUES ("EX37_29","003_37_29","EXO","37","29","29","Mu sàkk nag diwu pal gu sell gi, sàkk cuuraay lu xeeñ li raxul, def ko njafaan lu njafaan-kat waajal ba mu baax. ");
INSERT INTO wolmbs_vpl VALUES ("EX38_1","003_38_1","EXO","38","1","1","Ba tey Beccalel sàkk ci bantu séng sarxalukaayu rendi-dóomal bu kaare, guddaay bi di juróomi xasab, yaatuwaay bi di juróomi xasab, taxawaay bi di ñetti xasab. ");
INSERT INTO wolmbs_vpl VALUES ("EX38_2","003_38_2","EXO","38","2","2","Mu sàkkal ko ay béjjénam ci ñeenti collam, mu ànd aki béjjénam, di benn. Mu xoob nag lépp xànjar. ");
INSERT INTO wolmbs_vpl VALUES ("EX38_3","003_38_3","EXO","38","3","3","Mu sàkk jumtukaayi sarxalukaay bi yépp: ndabi tibbukaayu dóom yi ak ñiitukaay yi ak këll yi, ak seppikaayi yàpp yi, ak and yi, jumtukaay yépp di xànjar. ");
INSERT INTO wolmbs_vpl VALUES ("EX38_4","003_38_4","EXO","38","4","4","Mu sàkkal sarxalukaay bi caax bu ñu tëgge xànjar, mu ronu peggu sarxalukaay bi, dale ci suuf ba ci digg sarxalukaay bi. ");
INSERT INTO wolmbs_vpl VALUES ("EX38_5","003_38_5","EXO","38","5","5","Mu daldi koy móolal ñeenti nopp ci ñeenti colli caaxu xànjar bi, ñuy téye njàppu yi. ");
INSERT INTO wolmbs_vpl VALUES ("EX38_6","003_38_6","EXO","38","6","6","Mu sàkk njàppuy bantu séng, xoob lu ci nekk xànjar, ");
INSERT INTO wolmbs_vpl VALUES ("EX38_7","003_38_7","EXO","38","7","7","daldi roof njàppu yi ci nopp yi ci weti sarxalukaay bi, ngir bu ñu koy yóbbu. Am pax mu def sarxalukaay bi ci biir; mu defare ko ay xànq yu tàppandaar. ");
INSERT INTO wolmbs_vpl VALUES ("EX38_8","003_38_8","EXO","38","8","8","Mu sàkk itam mbalkam njàpp mu ànd ak tegoom, di xànjar ju jóge ci seetuy jigéen, ñi doon liggéey ci bunt xaymab ndaje mi. ");
INSERT INTO wolmbs_vpl VALUES ("EX38_9","003_38_9","EXO","38","9","9","Beccalel nag sàkk wërmbalu ëttu jaamookaay bi. Wetam, gi fare bëj-saalum di téeméeri xasabi sori rabal yu ñu ràbbe wëñu lẽe, ");
INSERT INTO wolmbs_vpl VALUES ("EX38_10","003_38_10","EXO","38","10","10","seen ñaar fukki jën ànd ak seen ñaar fukki tegu, di xànjar, wékkukaay yeek galani jën yi di xaalis. ");
INSERT INTO wolmbs_vpl VALUES ("EX38_11","003_38_11","EXO","38","11","11","Wetu bëj-gànnaar it di téeméeri xasabi sori rabal, seen ñaar fukki jën ànd ak seen ñaar fukki tegu, di xànjar, wékkukaay yeek galani jën yi di xaalis. ");
INSERT INTO wolmbs_vpl VALUES ("EX38_12","003_38_12","EXO","38","12","12","Wetu sowu di juróom fukki xasabi sori rabal, ak seen fukki jën yu ànd ak seen fukki tegu, wékkukaay yeek galani jën yi di xaalis. ");
INSERT INTO wolmbs_vpl VALUES ("EX38_13","003_38_13","EXO","38","13","13","Wetu penku bi ci kanam di juróom fukki xasab; ");
INSERT INTO wolmbs_vpl VALUES ("EX38_14","003_38_14","EXO","38","14","15","fukki xasabi sori rabal ak juróom fi làng ak buntu ëtt bi ci genn wetam, ak seen ñetti jën yu ànd ak seen ñetti tegu, ak fukki xasabi sori rabal ak juróom, wet gi ci des, ak seen ñetti jën yu ànd ak seen ñetti tegu. ");
INSERT INTO wolmbs_vpl VALUES ("EX38_16","003_38_16","EXO","38","16","16","Mboolem sori wërmbalu ëtt bi ba mu daj, wëñu lẽe la. ");
INSERT INTO wolmbs_vpl VALUES ("EX38_17","003_38_17","EXO","38","17","17","Teguy jën yi xànjar la, wékkukaayi jën yeek ay galanam di xaalis, ñu xoob boppi jën yi xaalis; jëni ëtt bi yépp nag, galani xaalis lañu leen lëkkalee. ");
INSERT INTO wolmbs_vpl VALUES ("EX38_18","003_38_18","EXO","38","18","18","Lafu buntu ëtt bi, liggéeyu ràbb bu rafet la, bu ñu ràbbe wëñ gu baxa te laal yolet, ak wëñ gu xewar, ak gu xonq curr ak wëñu lẽe. Guddaayu laf bi ñaar fukki xasab la, taxawaay bi yemook yaatuwaay bi, di juróomi xasab, tollook sori wërmbalu ëtt bi. ");
INSERT INTO wolmbs_vpl VALUES ("EX38_19","003_38_19","EXO","38","19","19","Jëni lafu bunt bi ñeent la, seen ñeenti tegu di xànjar, seeni wékkukaay di xaalis, ñu xoob kaw jën yi xaalis, galan yi di xaalis. ");
INSERT INTO wolmbs_vpl VALUES ("EX38_20","003_38_20","EXO","38","20","20","Mboolem xeri jaamookaay bi ak xeri wërmbalu ëtt bi ba mu daj, lépp xànjar la. ");
INSERT INTO wolmbs_vpl VALUES ("EX38_21","003_38_21","EXO","38","21","21","Lii nag moo di tënkub dayoy gànjar yi ñu jëfandikoo ci liggéeyu jaamookaay bi, jaamookaay bi ñu denc àlluway seede si. Tënkees na ko ci ndigalu Musaa, te Leween ñi sasoo tënk bi ci njiital Itamar doomu Aaróona sarxalkat bi. ");
INSERT INTO wolmbs_vpl VALUES ("EX38_22","003_38_22","EXO","38","22","22","Fekk na Yudeen bi Beccalel doomu Uri, miy doomu Ur, sottal na mboolem li Aji Sax ji santoon Musaa. ");
INSERT INTO wolmbs_vpl VALUES ("EX38_23","003_38_23","EXO","38","23","23","Mu àndoon ci ak Daneen bi, doomu Axisamaag, Oliyab, mu dib yattkat, dib taaralkat te di liggéeykatu wëñ gu baxa te laal yolet, ak wëñ gu xewar ak gu xonq curr ak wëñu lẽe. ");
INSERT INTO wolmbs_vpl VALUES ("EX38_24","003_38_24","EXO","38","24","24","Wurus wi dem ci liggéey bi bépp, mboolem liggéeyu jaamookaay bu sell bi, te muy wurus wu ñu def saraxu yékkati-jébbal Yàlla, muy juróom ñetti téeméeri kilo ak juróom ñaar fukk ak juróom ñaar (877), yemook ñaar fukki talaŋ ak juróom ñeent (29), ak ñetti téeméeri garaam (300), muy juróom ñaari téeméer ak fanweeri (730) siikal, ci siikal bi ñu yoonal ci néeg bu sell bi. ");
INSERT INTO wolmbs_vpl VALUES ("EX38_25","003_38_25","EXO","38","25","25","Xaalis bi tukkee ci limeefu askan wi, ñetti junniy kilo ak ñeenti téeméer ak ñeent fukk (3 440), yemook téeméeri (100) talaŋ ak junneek juróom ñaari téeméer ak juróom ñaar fukk ak juróomi (1 775) siikal, ci siikal bi ñu yoonal ci néeg bu sell bi, ");
INSERT INTO wolmbs_vpl VALUES ("EX38_26","003_38_26","EXO","38","26","26","mu xawa tollu ci juróomi garaami xaalis ak genn wall bopp bu nekk, yemook genn-wàllu siikal, ci siikal bi ñu yoonal ci néeg bu sell bi, ñeel képp ku bindu ci limeef bi, dale ko ci ñi am ñaar fukki at jëm kaw, ñépp di juróom benni téeméeri junniy góor ak ñetti junneek juróomi téeméer ak juróom fukk (603 550). ");
INSERT INTO wolmbs_vpl VALUES ("EX38_27","003_38_27","EXO","38","27","27","Ñetti junniy ak ñeenti téeméer ak ñaar fukki (3 420) kiloy xaalis, di téeméeri talaŋ, ñeel móolub teguy néeg bu sell bi, ak teguy rido bi. Muy téeméeri tegu ci téeméeri talaŋ, benn talaŋ ci benn tegu. ");
INSERT INTO wolmbs_vpl VALUES ("EX38_28","003_38_28","EXO","38","28","28","Ñaar fukki kilo yi des, yemook fukki kilook juróom ñaar yeek juróom ñaari téeméeri garaam yeek juróom fukk (17 kilo 750 garaam), muy junneek juróom ñaari téeméer ak juróom ñaar fukk ak juróomi (1 775) siikali xaalis, def na ci ay wékkukaay ngir jën yi, xoob ci boppi jën yi, xoob ci it galan yi boole jën yi. ");
INSERT INTO wolmbs_vpl VALUES ("EX38_29","003_38_29","EXO","38","29","29","Xànjar bi ñu def saraxu yékkati-jébbal Yàlla, ñaari junniy kilo ak ñeenti téeméer ak ñaar fukk ak benn la (2 421), yemook juróom ñaar fukki (70) talaŋ ak ñaari junneek ñeenti téeméeri (2 400) siikal. ");
INSERT INTO wolmbs_vpl VALUES ("EX38_30","003_38_30","EXO","38","30","30","Mu sàkk ci teguy buntu xaymab ndaje mi, ak sarxalukaayu xànjar bi, ak caaxub xànjaram, ak mboolem jumtukaayi sarxalukaay bi, ");
INSERT INTO wolmbs_vpl VALUES ("EX38_31","003_38_31","EXO","38","31","31","ak teguy wërmbalu ëtt bi, ak teguy buntu ëtt bi, ak xeri jaamookaay bi yépp, ak xeri wërmbalu ëtt bi. ");
INSERT INTO wolmbs_vpl VALUES ("EX39_1","003_39_1","EXO","39","1","1","Wëñ gu baxa gi te laal yolet nag ak wëñ gu xewar gi ak gu xonq gi curr, ci lañu sàkk yére yu yànj yi ñuy liggéeye ci néeg bu sell bi. Ñu daldi defar yére yu sell, yi ñeel Aaróona noonee ko Aji Sax ji sante woon Musaa. ");
INSERT INTO wolmbs_vpl VALUES ("EX39_2","003_39_2","EXO","39","2","2","Xar-sànni mi, wëñu wurus lees ko ràbbe, ak wëñ gu baxa te laal yolet, ak wëñ gu xewar, ak gu xonq curr ak wëñu lẽe. ");
INSERT INTO wolmbs_vpl VALUES ("EX39_3","003_39_3","EXO","39","3","3","Ay xobi wurus lañu tëgg ba mu jekk, ñu dagg ko ay wëñ yu ñu ràbbaaleek wëñ gu baxa gi te laal yolet, ak wëñ gu xewar gi, ak gu xonq gi curr, ak wëñu lẽe gi. Ñu daldi ciy ñawaale ay nataal. ");
INSERT INTO wolmbs_vpl VALUES ("EX39_4","003_39_4","EXO","39","4","4","Ñaari ngàlli mbagg lañu ko defal, daldi faste wu ci nekk ci ñaari cati xar-sànni mi. ");
INSERT INTO wolmbs_vpl VALUES ("EX39_5","003_39_5","EXO","39","5","5","Ngañaayu taaral li tege ci kaw, ni xar-sànni mi lees ko defare, liggéeyaale kook moom, ñu ànd di benn. Ñu ràbbe ko wëñu wurus, ak wëñ gu baxa te laal yolet, ak wëñ gu xewar, ak gu xonq curr, ak wëñu lẽe, noonee ko Aji Sax ji sante woon Musaa. ");
INSERT INTO wolmbs_vpl VALUES ("EX39_6","003_39_6","EXO","39","6","6","Ci kaw loolu ñu we peri onigsë yi, fege per yi ŋankukaayi wurus, daldi ciy ñaas turi doomi Israayil yu góor, noonu ñuy ñaase xàmmikaay yi ñuy torloo. ");
INSERT INTO wolmbs_vpl VALUES ("EX39_7","003_39_7","EXO","39","7","7","Ñu tapp per yi ci kaw ngàlli waggi xar-sànni mi, per yi nag taxawe taxawaayu bànni Israayil, noonu ko Aji Sax ji sante woon Musaa. ");
INSERT INTO wolmbs_vpl VALUES ("EX39_8","003_39_8","EXO","39","8","8","Ñu sàkk kiiraayal dënn bi, liggéeyaale ko ay nataal ni xar-sànni mi, ràbbe ko wëñu wurus, ak wëñ gu baxa te laal yolet, ak wëñ gu xewar, ak gu xonq curr, ak wëñu lẽe. ");
INSERT INTO wolmbs_vpl VALUES ("EX39_9","003_39_9","EXO","39","9","9","Ab kaare bu ñu lem lañu ko def, guddaay bi, gannaaw bu ñu ko lemee, di ŋaraleb baaraamu déy ak bu digg, yaatuwaay bi di ŋaraleb baaraamu déy ak digg. ");
INSERT INTO wolmbs_vpl VALUES ("EX39_10","003_39_10","EXO","39","10","10","Ñu we nag ay per ci kaw kiiraayal dënn bi, def ko ñeenti làngi per. Làng gi jiitu, peru sarduwan ak peru topaas ak peru eskarbukal moo ca nekk; ");
INSERT INTO wolmbs_vpl VALUES ("EX39_11","003_39_11","EXO","39","11","11","ñaareelu làng gi di peru emëródd ak peru safiir ak peru jamaa, ");
INSERT INTO wolmbs_vpl VALUES ("EX39_12","003_39_12","EXO","39","12","12","ñetteelu làng gi di peru yasent ak peru agaat ak peru ametistë, ");
INSERT INTO wolmbs_vpl VALUES ("EX39_13","003_39_13","EXO","39","13","13","ñeenteelu làng gi di peru kirsolit ak peru onigsë ak peru jàspë, te per bu ci nekk ŋankukaayu wurus lees ko wewe. ");
INSERT INTO wolmbs_vpl VALUES ("EX39_14","003_39_14","EXO","39","14","14","Per yeek turi doomi Israayil yu góor ñoo tolloo ab lim: muy fukk ak ñaar, ni tur yi tollu. Ñu ñaas ci tur yi ni xàmmikaayi torlu, ku nekk ak turam, ba fukki giir yeek ñaar daj. ");
INSERT INTO wolmbs_vpl VALUES ("EX39_15","003_39_15","EXO","39","15","15","Ci biir loolu ñu sàkkal kiiraayal dënn bi ñaari caqi wurusu ngalam yu ci tege, te rawaasoo ni ay buum. ");
INSERT INTO wolmbs_vpl VALUES ("EX39_16","003_39_16","EXO","39","16","16","Ñu sàkk itam ñaari ŋankukaayi wurus ak ñaari jaaroy wurus yu ñu takk ci ñaari cati kiiraayal dënn bi ci kaw. ");
INSERT INTO wolmbs_vpl VALUES ("EX39_17","003_39_17","EXO","39","17","17","Ñu nas nag ñaari buumi wurus yi ci ñaari jaaro yi ci cati kiiraay li. ");
INSERT INTO wolmbs_vpl VALUES ("EX39_18","003_39_18","EXO","39","18","18","Yeneen ñaari cati buumi wurus yi, ñu we leen ci ñaari ŋankukaay yi ci kaw ngàlli waggi xar-sànni mi, ci kanam. ");
INSERT INTO wolmbs_vpl VALUES ("EX39_19","003_39_19","EXO","39","19","19","Ñu sàkkal ko itam ñaari jaaroy wurus, yu ñu we ci ñaari cati suufi kiiraay li, fi féete biir, wet gi tafu ci xar-sànni mi. ");
INSERT INTO wolmbs_vpl VALUES ("EX39_20","003_39_20","EXO","39","20","20","Ñu sàkkalaat kiiraay li yeneen ñaari jaaroy wurus, yu ñu we ci suufu ngàlli xar-sànni mi, fi féete kanam, dendeek sofu ngàll yi, te tiim ngañaayu xar-sànni mi. ");
INSERT INTO wolmbs_vpl VALUES ("EX39_21","003_39_21","EXO","39","21","21","Kiiraayal dënn bi, buum gu sew gu baxa te laal yolet, moom lees ko téyee, lëkkalee ko jaaroy kiiraay leek jaaroy xar-sànni mi, kiiraay li dëkke tiim ngañaay li, ba du teqalikook xar-sànni mi, noonee ko Aji Sax ji sante woon Musaa. ");
INSERT INTO wolmbs_vpl VALUES ("EX39_22","003_39_22","EXO","39","22","22","Mbubb mi xar-sànni miy tege, lépp, wëñ gu baxa te laal yolet lees ko ràbbe ba mu daj. ");
INSERT INTO wolmbs_vpl VALUES ("EX39_23","003_39_23","EXO","39","23","23","Baatu mbubb maa ngi ci digg bi, mel ni baatu mbubbam xare, ñu ombe ko omb bu dëgër, ba mu daj, ngir du xottiku. ");
INSERT INTO wolmbs_vpl VALUES ("EX39_24","003_39_24","EXO","39","24","24","Ci biir loolu ñu takk ci ombu mbubb mi, ay doomi gërënaat yu ñu defare wëñ gu baxa te laal yolet, ak wëñ gu xewar, ak gu xonq curr, ak wëñu lẽe. ");
INSERT INTO wolmbs_vpl VALUES ("EX39_25","003_39_25","EXO","39","25","25","Ñu def itam ay jóolóoliy wurusu ngalam, ba takk jóolóoli yi ci diggante doomi gërënaat yi, wërale ko ombu mbubb mi, ba mu daj, jóolóoli yi dox diggante doomi gërënaat yi. ");
INSERT INTO wolmbs_vpl VALUES ("EX39_26","003_39_26","EXO","39","26","26","Ab jóolóoli, ab gërënaat, ab jóolóoli, ab gërënaat ba ombu mbubb mi ñuy sol di sarxal daj, noonee ko Aji Sax ji sante woon Musaa. ");
INSERT INTO wolmbs_vpl VALUES ("EX39_27","003_39_27","EXO","39","27","27","Ñu sàkkal nag Aaróona aki doomam jàllaabi yu ñu ràbbe wëñu lẽe, ");
INSERT INTO wolmbs_vpl VALUES ("EX39_28","003_39_28","EXO","39","28","28","ak kaalag lẽe, ak mbaxanay lẽe, ak tubéyi njiitlaay yu lẽe, ");
INSERT INTO wolmbs_vpl VALUES ("EX39_29","003_39_29","EXO","39","29","29","ak laxasaay giy liggéeyu ràbb bu rafet, bu ñu ràbbe wëñu lẽe gu ëccu ba sew, ak wëñ gu baxa te laal yolet, ak wëñ gu xewar, ak gu xonq curr, noonee ko Aji Sax ji sante woon Musaa. ");
INSERT INTO wolmbs_vpl VALUES ("EX39_30","003_39_30","EXO","39","30","30","Ñu sàkk nag meeteel gu sell gu wurusu ngalam, muy dogu wurus wu tell, ñu ñaas ci kawam mii mbind, ni ñuy ñaase mbindum torlu: «Sell na, ñeel Aji Sax ji». ");
INSERT INTO wolmbs_vpl VALUES ("EX39_31","003_39_31","EXO","39","31","31","Ñu daldi koy takke buum gu baxa te laal yolet, téyee ko ko ci kaw kaala gi, na ko Aji Sax ji sante woon Musaa. ");
INSERT INTO wolmbs_vpl VALUES ("EX39_32","003_39_32","EXO","39","32","32","Noonu la mboolem liggéeyu màkkaanu jaamookaay bi, maanaam xaymab ndaje mi mate. Noonee ko Aji Sax ji sante woon Musaa rekk, ni la ko bànni Israayil defe. ");
INSERT INTO wolmbs_vpl VALUES ("EX39_33","003_39_33","EXO","39","33","33","Ba loolu amee ñu indil Musaa jaamookaay bi: xayma bi ak yëfam yépp; lonku yi ak làcc yi ak galan yi ak jën yeek tegu yi, ");
INSERT INTO wolmbs_vpl VALUES ("EX39_34","003_39_34","EXO","39","34","34","ak kiiraayal deri kuuy yi ñu sóob xonq, ak kiiraayal deri piipi yi, ak ridob xàjjatle bi, ");
INSERT INTO wolmbs_vpl VALUES ("EX39_35","003_39_35","EXO","39","35","35","ak gaal gi àlluway seede si dence, aki njàppoom, ak kubeeru njotlaay gi, ");
INSERT INTO wolmbs_vpl VALUES ("EX39_36","003_39_36","EXO","39","36","36","ak taabal jeek ndabam yépp, ak mburum teewal mi ciy tege, ");
INSERT INTO wolmbs_vpl VALUES ("EX39_37","003_39_37","EXO","39","37","37","ak tegukaayu làmp bu wurusu ngalam bi aki làmpam, làmp yi sësaloo ba jekk ak mboolemi jumtukaayam, ak diw gi ñuy taaloo, ");
INSERT INTO wolmbs_vpl VALUES ("EX39_38","003_39_38","EXO","39","38","38","ak sarxalukaay bu wurus bi, ak diwu pal gi, ak cuuraay lu xeeñ li, ak kiiraayal buntu xayma bi, ");
INSERT INTO wolmbs_vpl VALUES ("EX39_39","003_39_39","EXO","39","39","39","ak sarxalukaayu xànjar beek caaxub xànjaram, aki njàppoom ak ndabam yépp, ak mbalkam njàpp mi akub tegoom, ");
INSERT INTO wolmbs_vpl VALUES ("EX39_40","003_39_40","EXO","39","40","40","ak sori wërmbalu ëtt bi aki jënam aki tegoom, ak kiiraayal lafu buntu ëtt bi, aki buumam aki xeram; mboolem jumtukaay yi ñuy liggéeye ci màkkaanu jaamookaay bi, xaymab ndaje mi rekk, ");
INSERT INTO wolmbs_vpl VALUES ("EX39_41","003_39_41","EXO","39","41","41","ak yére yu yànj yi ñuy liggéeye ci néeg bu sell bi; yére yu sell yu Aaróona sarxalkat bi, ak yérey doomam yi ñuy sol, di sarxale. ");
INSERT INTO wolmbs_vpl VALUES ("EX39_42","003_39_42","EXO","39","42","42","Noonee ko Aji Sax ji sante woon Musaa rekk, ni la bànni Israayil sottale liggéey bi bépp. ");
INSERT INTO wolmbs_vpl VALUES ("EX39_43","003_39_43","EXO","39","43","43","Musaa nag nemmiku mboolem liggéey bi, ba gis ne sottal nañu ko; noonee ko Aji Sax ji santaanee woon, ni lañu ko defe. Musaa daldi leen ñaanal. ");
INSERT INTO wolmbs_vpl VALUES ("EX40_1","003_40_1","EXO","40","1","1","Aji Sax ji waxati Musaa ne ko: ");
INSERT INTO wolmbs_vpl VALUES ("EX40_2","003_40_2","EXO","40","2","2","«Bu keroogee benn fanu weer wi jiitu, nanga samp màkkaanu xaymab ndaje mi. ");
INSERT INTO wolmbs_vpl VALUES ("EX40_3","003_40_3","EXO","40","3","3","Nanga yeb ci biir, gaal gi àlluway seede si dence, te nga làqe gaal gi rido bi. ");
INSERT INTO wolmbs_vpl VALUES ("EX40_4","003_40_4","EXO","40","4","4","Dugalal taabal ji te taaj ci li muy àndal; dugalal tegukaayu làmp bi, nga taal ay làmpam, ");
INSERT INTO wolmbs_vpl VALUES ("EX40_5","003_40_5","EXO","40","5","5","te nga teg sarxalukaayu cuuraay bu wurus bi ci kanam gaal gi àlluway seede si dence, ba noppi nga samp lafu buntu jaamookaay bi. ");
INSERT INTO wolmbs_vpl VALUES ("EX40_6","003_40_6","EXO","40","6","6","«Tegal sarxalukaayu rendi-dóomal bi fi kanam buntu màkkaanu xaymab ndaje mi. ");
INSERT INTO wolmbs_vpl VALUES ("EX40_7","003_40_7","EXO","40","7","7","Tegal mbalkam njàpp mi ci diggante xaymab ndaje mi ak sarxalukaay bi, te nga duy ko ndox. ");
INSERT INTO wolmbs_vpl VALUES ("EX40_8","003_40_8","EXO","40","8","8","Sampal nag wërmbalu ëtt bi bépp, te nga we lafu buntu wërmbal bi. ");
INSERT INTO wolmbs_vpl VALUES ("EX40_9","003_40_9","EXO","40","9","9","«Jëlal nag diwu pal gi, nga diw ci jaamookaay bi ak li ci biiram lépp, sellale ko ko, mook yëfam yépp, mu daldi sell. ");
INSERT INTO wolmbs_vpl VALUES ("EX40_10","003_40_10","EXO","40","10","10","Boo noppee, diwal sarxalukaayu rendi-dóomal bi, mook ndabam yépp, nga sellale ko sarxalukaay bi, sarxalukaay bi daldi sella sell. ");
INSERT INTO wolmbs_vpl VALUES ("EX40_11","003_40_11","EXO","40","11","11","Nanga diw mbalkam njàpp mi akub tegoom, nga sellale ko ko. ");
INSERT INTO wolmbs_vpl VALUES ("EX40_12","003_40_12","EXO","40","12","12","«Indil Aaróona aki doomam ba ci bunt xaymab ndaje mi, nga sang leen ci ndox mi. ");
INSERT INTO wolmbs_vpl VALUES ("EX40_13","003_40_13","EXO","40","13","13","Nga daldi solal Aaróona yére yu sell yi, diw ko, sellale ko ko, mu doon sama sarxalkat. ");
INSERT INTO wolmbs_vpl VALUES ("EX40_14","003_40_14","EXO","40","14","14","Su ko defee nga indi ay doomam, solal leen ay jàllaabi. ");
INSERT INTO wolmbs_vpl VALUES ("EX40_15","003_40_15","EXO","40","15","15","Nga diw leen, ni nga diwe seen baay, ñu doon samay sarxalkat. Seen diwu googu moo leen sédd sasu carxal bu sax dàkk, maasoo maas.» ");
INSERT INTO wolmbs_vpl VALUES ("EX40_16","003_40_16","EXO","40","16","16","Musaa nag def loola. Mboolem noonee ko ko Aji Sax ji sante, na la ko defe. ");
INSERT INTO wolmbs_vpl VALUES ("EX40_17","003_40_17","EXO","40","17","17","Keroog at ma topp ca at ma ñu génne Misra, ca benn fanu weer wa njëkk, ca lañu samp jaamookaay ba. ");
INSERT INTO wolmbs_vpl VALUES ("EX40_18","003_40_18","EXO","40","18","18","Musaa nag samplu jaamookaay bi; ñu jiital tegu yi, samp làcc yi, we galan yi, daldi samp jën yi. ");
INSERT INTO wolmbs_vpl VALUES ("EX40_19","003_40_19","EXO","40","19","19","Ci kaw loolu, ñu firi malaan mi ci kaw jaamookaay bi, daldi lal kiiraay li ci kawam, na ko Aji Sax ji sante woon Musaa. ");
INSERT INTO wolmbs_vpl VALUES ("EX40_20","003_40_20","EXO","40","20","20","Gannaaw loolu ñu jël àlluway seede si, yeb ko ci gaal gi, ba noppi roof njàppu yi ci gaal gi. Ñu daldi teg kubeeru njotlaay gi ci kaw gaal gi. ");
INSERT INTO wolmbs_vpl VALUES ("EX40_21","003_40_21","EXO","40","21","21","Ba mu ko defee ñu fat gaal gi ci biir jaamookaay bi, doora firi ridob xàjjatle bi, làqe ko ko, na ko Aji Sax ji sante woon Musaa. ");
INSERT INTO wolmbs_vpl VALUES ("EX40_22","003_40_22","EXO","40","22","22","Ba loolu amee ñu dugal taabal ji ci biir xaymab ndaje mi, ci wetu bëj-gànnaaru jaamookaay bi, ci kanam rido bi. ");
INSERT INTO wolmbs_vpl VALUES ("EX40_23","003_40_23","EXO","40","23","23","Ñu daldi teg ci kaw taabal ji, tegin wu jekk, mburu mi fi kanam Aji Sax ji, na ko Aji Sax ji sante woon Musaa. ");
INSERT INTO wolmbs_vpl VALUES ("EX40_24","003_40_24","EXO","40","24","24","Ñu dugal nag tegukaayu làmp bi ci biir xaymab ndaje mi, fi janook taabal ji, ci wetu bëj-saalumu jaamookaay bi, ");
INSERT INTO wolmbs_vpl VALUES ("EX40_25","003_40_25","EXO","40","25","25","daldi taal làmp yi fi kanam Aji Sax ji, na ko Aji Sax ji sante woon Musaa. ");
INSERT INTO wolmbs_vpl VALUES ("EX40_26","003_40_26","EXO","40","26","26","Ba mu ko defee ñu dugal sarxalukaayu wurus bi ci biir xaymab ndaje mi, ci kanam rido bi, ");
INSERT INTO wolmbs_vpl VALUES ("EX40_27","003_40_27","EXO","40","27","27","daldi taal cuuraay lu xeeñ li ci kawam, na ko Aji Sax ji sante woon Musaa. ");
INSERT INTO wolmbs_vpl VALUES ("EX40_28","003_40_28","EXO","40","28","28","Noonu ñu samp lafu buntu jaamookaay bi. ");
INSERT INTO wolmbs_vpl VALUES ("EX40_29","003_40_29","EXO","40","29","29","Sarxalukaayu rendi-dóomal bi nag, ñu teg ko ci bunt màkkaanu xaymab ndaje mi, daldi def ci kawam saraxu rendi-dóomal bi, ak saraxi pepp mi, na ko Aji Sax ji sante woon Musaa. ");
INSERT INTO wolmbs_vpl VALUES ("EX40_30","003_40_30","EXO","40","30","30","Ba loolu amee ñu teg mbalkam njàpp mi ci diggante xaymab ndaje mi ak sarxalukaay bi, ba noppi duy ko ndoxum njàpp. ");
INSERT INTO wolmbs_vpl VALUES ("EX40_31","003_40_31","EXO","40","31","31","Ci la Musaa ak Aaróona aki doomam di raxas seeni loxo ak seeni tànk, ");
INSERT INTO wolmbs_vpl VALUES ("EX40_32","003_40_32","EXO","40","32","32","ndax bu ñuy dugg ci xaymab ndaje mi, ak bu ñuy jegeji sarxalukaay bi, dañuy jàpp, na ko Aji Sax ji sante woon Musaa. ");
INSERT INTO wolmbs_vpl VALUES ("EX40_33","003_40_33","EXO","40","33","33","Gannaaw loolu ñu samp wërmbal bi yéew jaamookaay beek sarxalukaay bi, daldi samp lafu buntu ëtt bi. Noonu la Musaa sottale liggéey bi. ");
INSERT INTO wolmbs_vpl VALUES ("EX40_34","003_40_34","EXO","40","34","34","Ba loolu amee niir wa yiir xaymab ndaje ma, leeru Aji Sax ji fees jaamookaay ba, ");
INSERT INTO wolmbs_vpl VALUES ("EX40_35","003_40_35","EXO","40","35","35","ba Musaa tëlee dugg ca xaymab ndaje ma, ndax niir wa màkkaanoo kaw xayma ba, ak leeru Aji Sax ji fees jaamookaay ba. ");
INSERT INTO wolmbs_vpl VALUES ("EX40_36","003_40_36","EXO","40","36","36","Saa yu niir wa yékkatikoo fa tiim jaamookaay ba nag, bànni Israayil daldi tegu ca seen yooni tukki ya. ");
INSERT INTO wolmbs_vpl VALUES ("EX40_37","003_40_37","EXO","40","37","37","Waaye bu niir wa yékkatikuwul, duñu dem, ba keroog muy yékkatiku. ");
INSERT INTO wolmbs_vpl VALUES ("EX40_38","003_40_38","EXO","40","38","38","Ndax booba niiru Aji Sax jaa nga ca kaw jaamookaay ba, ag bëccëg, te sawara waa nga ca biir niir wa, ag guddi, waa kër Israayil gépp di ci gis, seen diiru yooni tukki ya. ");
INSERT INTO wolmbs_vpl VALUES ("LV1_1","004_1_1","LEV","1","1","1","Aji Sax ji woo na Musaa, wax ak moom ca xaymab ndaje ma ne ko: ");
INSERT INTO wolmbs_vpl VALUES ("LV1_2","004_1_2","LEV","1","2","2","«Waxal bànni Israayil ne leen: Bu kenn ci yeen dee sàkkal Aji Sax ji sarax, na indi ag jur, muy gu gudd mbaa gu gàtt. ");
INSERT INTO wolmbs_vpl VALUES ("LV1_3","004_1_3","LEV","1","3","3","«Bu saraxam dee saraxu jur gu gudd gu ñuy def rendi-dóomal, na sarxal aw yëkk wu amul sikk. Na ko yóbbu ci bunt xaymab ndaje mi ci kanam Aji Sax ji, ngir mu nangul ko ko. ");
INSERT INTO wolmbs_vpl VALUES ("LV1_4","004_1_4","LEV","1","4","4","Na teg loxoom ci kaw boppu juru saraxu rendi-dóomal bi, ndax ñu nangul ko ko, muy njotlaayam. ");
INSERT INTO wolmbs_vpl VALUES ("LV1_5","004_1_5","LEV","1","5","5","Na rendi yëkk wi ci kanam Aji Sax ji, te doomi Aaróona yu góor yiy sarxalkat yi ñooy indi deret ji, xëpp ko ci mboolem weti sarxalukaay bi ci bunt xaymab ndaje mi. ");
INSERT INTO wolmbs_vpl VALUES ("LV1_6","004_1_6","LEV","1","6","6","Juru saraxu rendi-dóomal bi, na ko boroom sarax bi fees, daggat ko. ");
INSERT INTO wolmbs_vpl VALUES ("LV1_7","004_1_7","LEV","1","7","7","Doomi Aaróona, sarxalkat bi, ñooy jafal ab taal ci kaw sarxalukaay bi, teg matt mi ci taal bi. ");
INSERT INTO wolmbs_vpl VALUES ("LV1_8","004_1_8","LEV","1","8","8","Su ko defee doomi Aaróona yu góor yiy sarxalkat yi, jël dog yi, booleek bopp bi ak nebbon bi, teg ko ci kaw mattum taal bi ci sarxalukaay bi. ");
INSERT INTO wolmbs_vpl VALUES ("LV1_9","004_1_9","LEV","1","9","9","Nañu raxas yérey biir yi ak yeel yi, sarxalkat bi boole lépp lakk ci kaw sarxalukaay bi. Saraxu rendi-dóomal la, saraxu sawara ngir xetug jàmm, ñeel Aji Sax ji. ");
INSERT INTO wolmbs_vpl VALUES ("LV1_10","004_1_10","LEV","1","10","10","«Bu saraxam dee ab gàtt bu ñuy def rendi-dóomal, muy xar mbaa bëy, na sarxal bu góor bu amul sikk. ");
INSERT INTO wolmbs_vpl VALUES ("LV1_11","004_1_11","LEV","1","11","11","Na rendi sarax si ci kanam Aji Sax ji, fa féete sarxalukaay bi bëj-gànnaar. Na doomi Aaróona yu góor yiy sarxalkat yi xëpp deret ji ci mboolem weti sarxalukaay bi. ");
INSERT INTO wolmbs_vpl VALUES ("LV1_12","004_1_12","LEV","1","12","12","Bu ko boroom sarax bi daggatee ba noppi, sarxalkat bi day boole dog yeek bopp bi ak nebbon bi, teg ko ci kaw mattum taal bi ci kaw sarxalukaay bi. ");
INSERT INTO wolmbs_vpl VALUES ("LV1_13","004_1_13","LEV","1","13","13","Na boroom sarax bi raxas yérey biir yi ak yeel yi, sarxalkat bi boole lépp lakk ci kaw sarxalukaay bi. Saraxu rendi-dóomal la, saraxu sawara ngir xetug jàmm, ñeel Aji Sax ji. ");
INSERT INTO wolmbs_vpl VALUES ("LV1_14","004_1_14","LEV","1","14","14","«Bu nit ki dee sarxalal Aji Sax ji njanaaw luy doon rendi-dóomal, na sarxe pitax mbaa xati mu ndaw. ");
INSERT INTO wolmbs_vpl VALUES ("LV1_15","004_1_15","LEV","1","15","15","Na ko sarxalkat bi yóbbu ca sarxalukaay ba, kutt baat bi, lakk ko ci kaw sarxalukaay bi. Deret ji dees koy siital ci wetu sarxalukaay bi, ba mu jeex. ");
INSERT INTO wolmbs_vpl VALUES ("LV1_16","004_1_16","LEV","1","16","16","Na indi gag bi ak li ci nekk te wetti ko fa ñuy def dóomu-taal ba, fa féete sarxalukaay bi penku. ");
INSERT INTO wolmbs_vpl VALUES ("LV1_17","004_1_17","LEV","1","17","17","Sarxalkat bi day jàpp ci laaf yi, xotti te bañ koo teqale, daldi koy lakk ci sarxalukaay bi, ci kaw mattum taal bi. Saraxu rendi-dóomal la, saraxu sawara ngir xetug jàmm, ñeel Aji Sax ji. ");
INSERT INTO wolmbs_vpl VALUES ("LV2_1","004_2_1","LEV","2","1","1","«Bu nit dee indil Aji Sax ji saraxu pepp, sunguf su mucc ayib la saraxam wara doon, mu sotti ci diw, def ci cuuraay, ");
INSERT INTO wolmbs_vpl VALUES ("LV2_2","004_2_2","LEV","2","2","2","te yót ko doomi Aaróona yu góor yiy sarxalkat yi. Na sarxalkat bi sàkk barci-loxob sunguf su mucc ayib soosu ànd ak diw gi, te boole kook cuuraay li lépp. Na sarxalkat bi def cér boobu saraxu baaxantal, lakk ko ca kaw sarxalukaay ba, muy saraxu sawara ngir xetug jàmm, ñeel Aji Sax ji. ");
INSERT INTO wolmbs_vpl VALUES ("LV2_3","004_2_3","LEV","2","3","3","Li des ci saraxu pepp mi, Aaróona aki doomam ñoo koy féetewoo, muy cér bu sella sell, bawoo ci saraxi sawara yi ñeel Aji Sax ji. ");
INSERT INTO wolmbs_vpl VALUES ("LV2_4","004_2_4","LEV","2","4","4","«Su dee sarxal lu ñu defare pepp, di lu ñu lakk cib taal ba mu ñor, na doon sunguf su mucc ayib, di mburu yu amul lawiir yu ñu xiiwaale diw, mbaa mburu yu sew yu amul lawiir, ñu sotti diw ca kawam. ");
INSERT INTO wolmbs_vpl VALUES ("LV2_5","004_2_5","LEV","2","5","5","«Bu saraxam dee lu ñu defare pepp, lakke ko ci saafukaayu weñ, na doon sunguf su mucc ayib su ñu xiiwaale diw te bumu am lawiir. ");
INSERT INTO wolmbs_vpl VALUES ("LV2_6","004_2_6","LEV","2","6","6","Na ko dammat te sotti diw ca kaw dog ya. Saraxu pepp la. ");
INSERT INTO wolmbs_vpl VALUES ("LV2_7","004_2_7","LEV","2","7","7","«Bu saraxam dee lu ñu defare pepp, di lu ñu saaf ci cin ba mu ñor, na doon sunguf su mucc ayib su ñu xiiwaale diw. ");
INSERT INTO wolmbs_vpl VALUES ("LV2_8","004_2_8","LEV","2","8","8","«Na yóbbul Aji Sax ji saraxu pepp su ñu defar ci tegtal yooyu, yót ko sarxalkat bi, mu yóbbu ko ca sarxalukaay ba. ");
INSERT INTO wolmbs_vpl VALUES ("LV2_9","004_2_9","LEV","2","9","9","Su ko defee sarxalkat bi génne ci saraxu pepp mi, ab saraxu baaxantal, daldi koy lakk ci kaw sarxalukaay bi, muy saraxu sawara ngir xetug jàmm, ñeel Aji Sax ji. ");
INSERT INTO wolmbs_vpl VALUES ("LV2_10","004_2_10","LEV","2","10","10","Li des ci saraxu pepp mi, Aaróona aki doomam ñoo koy féetewoo, muy cér bu sella sell, bawoo ci saraxi sawara yi ñeel Aji Sax ji. ");
INSERT INTO wolmbs_vpl VALUES ("LV2_11","004_2_11","LEV","2","11","11","«Du benn saraxu pepp bu ñuy defal Aji Sax ji muy am lawiir, ndax du lenn ci lawiir mbaa lem, lu ñu wara lakk, ngir saraxu sawara su ñeel Aji Sax ji. ");
INSERT INTO wolmbs_vpl VALUES ("LV2_12","004_2_12","LEV","2","12","12","Saraxi ndoortel meññeef man naa ànd ak yooyu, waaye du bokk ci sarax su jëm ca sarxalukaay ba, ñu di ko taal, ngir xetug jàmm. ");
INSERT INTO wolmbs_vpl VALUES ("LV2_13","004_2_13","LEV","2","13","13","Seen mboolem saraxu pepp nangeen ko xorom. Bu seen saraxu pepp ñàkk mukk xorom, ndax mooy màndargaal seen kóllëreek seen Yàlla. Seen sarax yépp ngeen di xorom. ");
INSERT INTO wolmbs_vpl VALUES ("LV2_14","004_2_14","LEV","2","14","14","«Bu nit dee indil Aji Sax ji saraxu ndoortel meññeef, na ko indil mbool mu ñu séndal, def ko sànqal, muy saraxu ndoortel meññeefam. ");
INSERT INTO wolmbs_vpl VALUES ("LV2_15","004_2_15","LEV","2","15","15","Na ci sotti diw ak cuuraay. Saraxu pepp la. ");
INSERT INTO wolmbs_vpl VALUES ("LV2_16","004_2_16","LEV","2","16","16","Na sarxalkat bi lakk lenn ci mbool mu mokk mi ànd ak diw, boole kook cuuraay li lépp, muy saraxu baaxantal, te di saraxu sawara ñeel Aji Sax ji. ");
INSERT INTO wolmbs_vpl VALUES ("LV3_1","004_3_1","LEV","3","1","1","«Su fekkee ne li nit kiy sarxe saraxu cant la ci biir jàmm, mu di ko jële ci nag wu góor mbaa wu jigéen, na indil Aji Sax ji lu amul sikk. ");
INSERT INTO wolmbs_vpl VALUES ("LV3_2","004_3_2","LEV","3","2","2","Day teg loxoom ci kaw boppu jur gi muy sarxal, te rendi ko ca bunt xaymab ndaje ma. Doomi Aaróona yu góor yiy sarxalkat yi daldi xëpp deret ji ci mboolem weti sarxalukaay bi. ");
INSERT INTO wolmbs_vpl VALUES ("LV3_3","004_3_3","LEV","3","3","3","Li muy génne ci saraxu cant gi ci biir jàmm, ñu war koo taalal Aji Sax ji mooy nebbon bi sàng yérey biir yi, ak lépp luy nebbon te jàpp ci yérey biir yi, ");
INSERT INTO wolmbs_vpl VALUES ("LV3_4","004_3_4","LEV","3","4","4","ak ñaari dëmbéen yi ànd ak seen nebbon ca kaw, jàpp ca fàllare ja, ak bàjjo bi ci res wi te mu di ko booleek dëmbéen yi, génne ko. ");
INSERT INTO wolmbs_vpl VALUES ("LV3_5","004_3_5","LEV","3","5","5","Na doomi Aaróona yi boole yooyu lakk ci kaw sarxalukaay bi, mu tege ci kaw saraxu rendi-dóomal bi ci kaw mattum taal bi. Saraxu sawara la ngir xetug jàmm, ñeel Aji Sax ji. ");
INSERT INTO wolmbs_vpl VALUES ("LV3_6","004_3_6","LEV","3","6","6","«Su fekkee ne li nit kiy sarxalal Aji Sax ji saraxu cant la ci biir jàmm, te mu di ko jële ci jur gu gàtt, gu góor mbaa gu jigéen, na sarxal lu amul sikk. ");
INSERT INTO wolmbs_vpl VALUES ("LV3_7","004_3_7","LEV","3","7","7","Su dee sarxal xar, na ko indil Aji Sax ji ");
INSERT INTO wolmbs_vpl VALUES ("LV3_8","004_3_8","LEV","3","8","8","te teg loxoom ci boppu xar mi muy sarxe, ñu rendi ko ci bunt xaymab ndaje mi, doomi Aaróona yu góor yi xëpp deret ji ci mboolem weti sarxalukaay bi. ");
INSERT INTO wolmbs_vpl VALUES ("LV3_9","004_3_9","LEV","3","9","9","Li muy génne ci saraxu cant ci biir jàmm bi, muy saraxu sawara ngir xetug jàmm, ñeel Aji Sax ji, mooy nebbon bi, ak calgeen bi yépp, ñu doge ko fa sës ca fàllare ja, ak nebbon bi sàng yérey biir yi, ak lépp luy nebbon te jàpp ci yérey biir yi, ");
INSERT INTO wolmbs_vpl VALUES ("LV3_10","004_3_10","LEV","3","10","10","ak ñaari dëmbéen yi ànd ak seen nebbon ca kaw, jàpp ca fàllare ja, ak bàjjo bi ci res wi te mu di ko booleek dëmbéen yi, génne ko. ");
INSERT INTO wolmbs_vpl VALUES ("LV3_11","004_3_11","LEV","3","11","11","Na sarxalkat bi boole loolu lakk ci kaw sarxalukaay bi, muy ñam wu ñu lakke sawara, ñeel Aji Sax ji. ");
INSERT INTO wolmbs_vpl VALUES ("LV3_12","004_3_12","LEV","3","12","12","«Bu saraxu nit ki dee bëy, na ko indil Aji Sax ji ");
INSERT INTO wolmbs_vpl VALUES ("LV3_13","004_3_13","LEV","3","13","13","te teg loxoom ci bopp bi, ñu rendi ko ci bunt xaymab ndaje mi. Na doomi Aaróona yu góor yi xëpp deret ji ci mboolem weti sarxalukaay bi. ");
INSERT INTO wolmbs_vpl VALUES ("LV3_14","004_3_14","LEV","3","14","14","La mu cay génnee muy saraxu sawara, ñeel Aji Sax ji mooy nebbon bi sàng yérey biir yi yépp, ak lépp luy nebbon te jàpp ci yérey biir yi, ");
INSERT INTO wolmbs_vpl VALUES ("LV3_15","004_3_15","LEV","3","15","15","ak ñaari dëmbéen yi ànd ak seen nebbon ca kaw, jàpp ca fàllare ja, ak bàjjo bi ci res wi te mu di ko booleek dëmbéen yi, génne ko. ");
INSERT INTO wolmbs_vpl VALUES ("LV3_16","004_3_16","LEV","3","16","16","Na sarxalkat bi boole loolu lakk ci kaw sarxalukaay bi, muy ñam wu ñu lakke sawara, muy xeeñ xetug jàmm gu neex Aji Sax ji. Mboolem luy nebbon, Aji Sax jeey boroom. ");
INSERT INTO wolmbs_vpl VALUES ("LV3_17","004_3_17","LEV","3","17","17","Dogal a ngii, di lu leen war fàww, ak fépp fu ngeen dëkk: lépp luy nebbon mbaa deret, buleen ko lekk.» ");
INSERT INTO wolmbs_vpl VALUES ("LV4_1","004_4_1","LEV","4","1","1","Aji Sax ji wax na itam Musaa ne ko: ");
INSERT INTO wolmbs_vpl VALUES ("LV4_2","004_4_2","LEV","4","2","2","«Waxal bànni Israayil ne leen: Su fekkee ne nit ki dafa moy lenn ci santaaney Aji Sax ji, ba def lenn lu warul te du teyeefam, li ci war lii la. ");
INSERT INTO wolmbs_vpl VALUES ("LV4_3","004_4_3","LEV","4","3","3","«Ndegam sarxalkat bi ñu diw, fal ko, moo moy, ba yóbbe mbooloo mi tooñ, na indil Aji Sax ji yëkk wu ndaw wu amul sikk, muy saraxu póotum bàkkaar ndax bàkkaar ba mu def. ");
INSERT INTO wolmbs_vpl VALUES ("LV4_4","004_4_4","LEV","4","4","4","Day yóbbu yëkk wi ci bunt xaymab ndaje mi, ci kanam Aji Sax ji, daldi teg loxoom ci boppu yëkk wi, ñu rendi yëkk wi ci kanam Aji Sax ji. ");
INSERT INTO wolmbs_vpl VALUES ("LV4_5","004_4_5","LEV","4","5","5","Sarxalkat bi ñu diw, fal ko, na sàkk ci deretu yëkk wi, yóbbu ci biir xaymab ndaje mi. ");
INSERT INTO wolmbs_vpl VALUES ("LV4_6","004_4_6","LEV","4","6","6","Su ko defee sarxalkat bi capp baaraamam ci deret ji, wis-wisal deret ji juróom ñaari yoon fi kanam Aji Sax ji, fa janook ridob néeg bu sell ba. ");
INSERT INTO wolmbs_vpl VALUES ("LV4_7","004_4_7","LEV","4","7","7","Na sarxalkat bi sàkk ci deret ji, taqal ci béjjéni sarxalukaayu cuuraay lu xeeñ la ca biir xaymab ndaje ma ca kanam Aji Sax ji. Li des ci deretu yëkk wi, na ko tuur ci taatu sarxalukaay bi ñuy lakk saraxu rendi-dóomal, foofa ca bunt xaymab ndaje ma. ");
INSERT INTO wolmbs_vpl VALUES ("LV4_8","004_4_8","LEV","4","8","8","Na génne lépp luy nebbon ci yëkk wi ñuy sarxal muy póotum bàkkaar: nebbon bi sàng yérey biir yi, ak lépp luy nebbon te jàpp ci yérey biir yi, ");
INSERT INTO wolmbs_vpl VALUES ("LV4_9","004_4_9","LEV","4","9","9","ak ñaari dëmbéen yi ànd ak seen nebbon ca kaw, jàpp ca fàllare ja, ak bàjjo bi ci res wi te mu di ko booleek dëmbéen yi, génne ko. ");
INSERT INTO wolmbs_vpl VALUES ("LV4_10","004_4_10","LEV","4","10","10","Mooy ni ñu koy génnee rekk ci yëkku saraxu cant ci biir jàmm. Sarxalkat bi da koy boole lakk ca kaw sarxalukaayu rendi-dóomal ba. ");
INSERT INTO wolmbs_vpl VALUES ("LV4_11","004_4_11","LEV","4","11","11","Waaye deru yëkk wi ak yàppam wépp dees koy booleek bopp bi ak yeel yi ak yérey biir yi ak sébbriit mi; ");
INSERT INTO wolmbs_vpl VALUES ("LV4_12","004_4_12","LEV","4","12","12","mboolem li des ci yëkk wi daal lay génne dal bi, yóbbu ko ci béreb bu mucc sobe, ca jalub dóom ba, daldi taal matt, lakk ko ca, ba mu dib dóom. Foofa dóom ba jale lees koy lakke. ");
INSERT INTO wolmbs_vpl VALUES ("LV4_13","004_4_13","LEV","4","13","13","«Ndegam mbooloom Israayil mépp a moy lenn ci santaaney Aji Sax ji, ba def lenn lu warul te du seen teyeef, muy seenug tooñ te seetluwuñu ko, ");
INSERT INTO wolmbs_vpl VALUES ("LV4_14","004_4_14","LEV","4","14","14","bu mbooloo mi nemmikoo moy gi rekk, war nañoo génne ci jur gu gudd gi yëkk wu ndaw wuy doon saraxu póotum bàkkaar, yóbbu ko ca bunt xaymab ndaje ma. ");
INSERT INTO wolmbs_vpl VALUES ("LV4_15","004_4_15","LEV","4","15","15","Magi mbooloo mi dañuy teg seeni loxo ci boppu yëkk wi, fi kanam Aji Sax ji, ba noppi ñu rendi yëkk wi fi kanam Aji Sax ji. ");
INSERT INTO wolmbs_vpl VALUES ("LV4_16","004_4_16","LEV","4","16","16","Gannaaw loolu na sarxalkat bi ñu diw, fal ko, sàkk ci deretu yëkk wi, yóbbu ci biir xaymab ndaje mi. ");
INSERT INTO wolmbs_vpl VALUES ("LV4_17","004_4_17","LEV","4","17","17","Na capp baaraamam ci deret ji, wis-wisal deret ji juróom ñaari yoon fi kanam Aji Sax ji, foofu ci kanam rido bi. ");
INSERT INTO wolmbs_vpl VALUES ("LV4_18","004_4_18","LEV","4","18","18","Bu noppee na sàkk ci deret ji, taqal ci béjjéni sarxalukaayu cuuraay lu xeeñ la ci kanam Aji Sax ji, ci biir xaymab ndaje mi. Li des ci deret ji, na ko tuur ca taatu sarxalukaayu rendi-dóomal ba, ca bunt xaymab ndaje ma. ");
INSERT INTO wolmbs_vpl VALUES ("LV4_19","004_4_19","LEV","4","19","19","Na génne lépp li ciy nebbon, lakk ko ci kaw sarxalukaay bi. ");
INSERT INTO wolmbs_vpl VALUES ("LV4_20","004_4_20","LEV","4","20","20","Na def ak yëkk woowu na muy def ak yëkku saraxu póotum bàkkaar rekk. Noonu lay def ak moom. Ni la ko sarxalkat biy defale seen njotlaay, ñu am njéggal. ");
INSERT INTO wolmbs_vpl VALUES ("LV4_21","004_4_21","LEV","4","21","21","Na génne yëkk wi dal bi, taal ko, na muy taale yëkk wi ñu njëkka wax. Saraxu póotum bàkkaaru mbooloo mi la. ");
INSERT INTO wolmbs_vpl VALUES ("LV4_22","004_4_22","LEV","4","22","22","«Su fekkee ne kilifa moo moy lenn ci santaaney Yàllaam Aji Sax ji, ba def lenn lu warul te du teyeefam, mu dig tooñam, ");
INSERT INTO wolmbs_vpl VALUES ("LV4_23","004_4_23","LEV","4","23","23","bu nemmikoo bàkkaar bi mu def rekk, na sarxe sikket bu amul sikk. ");
INSERT INTO wolmbs_vpl VALUES ("LV4_24","004_4_24","LEV","4","24","24","Day teg loxoom ci boppu sikket bi, rendi ko fa ñuy rendi saraxu rendi-dóomal, fa kanam Aji Sax ji. Saraxu póotum bàkkaar la. ");
INSERT INTO wolmbs_vpl VALUES ("LV4_25","004_4_25","LEV","4","25","25","Na sarxalkat bi capp baaraamam ci deretu sarax siy póotum bàkkaar, taqal ko ci béjjéni sarxalukaayu rendi-dóomal bi, ba noppi tuur deret ji ci taatu sarxalukaayu rendi-dóomal bi. ");
INSERT INTO wolmbs_vpl VALUES ("LV4_26","004_4_26","LEV","4","26","26","Na lakk nebbon bi yépp ci kaw sarxalukaay bi, def ko ni nebbonu saraxu cant ci biir jàmm. Noonu la ko sarxalkat biy defale njotlaayal bàkkaaram, mu am njéggal. ");
INSERT INTO wolmbs_vpl VALUES ("LV4_27","004_4_27","LEV","4","27","27","«Su dee kenn ci baadoolo yee moy lenn ci santaaney Aji Sax ji, ba def lenn lu warul te du teyeefam, mu dig tooñam, ");
INSERT INTO wolmbs_vpl VALUES ("LV4_28","004_4_28","LEV","4","28","28","bu nemmikoo bàkkaar bi mu def rekk, na sarxe aw bëy wu jigéen wu amul sikk, ndax bàkkaar bi mu def. ");
INSERT INTO wolmbs_vpl VALUES ("LV4_29","004_4_29","LEV","4","29","29","Day teg loxoom ci boppu gàttu sarax soosu di póotum bàkkaar, rendi ko fa ñuy lakke saraxu rendi-dóomal. ");
INSERT INTO wolmbs_vpl VALUES ("LV4_30","004_4_30","LEV","4","30","30","Na sarxalkat bi capp baaraamam ci deret ji, taqal ci béjjéni sarxalukaayu rendi-dóomal bi; li des ci deret ji da koy tuur ci taatu sarxalukaay bi. ");
INSERT INTO wolmbs_vpl VALUES ("LV4_31","004_4_31","LEV","4","31","31","Te it na génne nebbon bi yépp ni muy génnee nebbonu jur gu ñu def saraxu cant ci biir jàmm. Na ko sarxalkat bi lakkal Aji Sax ji ci kaw sarxalukaay bi, muy xeeñ xetug jàmm gu neex Aji Sax ji. Noonu la ko sarxalkat biy defale njotlaayal bàkkaaram, mu am njéggal. ");
INSERT INTO wolmbs_vpl VALUES ("LV4_32","004_4_32","LEV","4","32","32","«Su fekkee ne am xar lay sarxe, muy saraxu póotum bàkkaaram, na doon xar mu jigéen, mu amul sikk. ");
INSERT INTO wolmbs_vpl VALUES ("LV4_33","004_4_33","LEV","4","33","33","Day teg loxoom ci boppu xar moomu di saraxu póotum bàkkaar, rendi ko fa ñuy rendee saraxu rendi-dóomal, muy saraxu póotum bàkkaar. ");
INSERT INTO wolmbs_vpl VALUES ("LV4_34","004_4_34","LEV","4","34","34","Na sarxalkat bi capp baaraamam ci deretu xar miy saraxu póotum bàkkaar, te taqal ci béjjéni sarxalukaayu rendi-dóomal bi; li des ci deret ji da koy tuur ci taatu sarxalukaay bi. ");
INSERT INTO wolmbs_vpl VALUES ("LV4_35","004_4_35","LEV","4","35","35","Te itam na génne nebbon bi yépp, ni muy génnee nebbonu xar mu ñuy def saraxu cant ci biir jàmm. Na sarxalkat bi lakk loolu ci kaw sarxalukaay bi, mu dolliku ci saraxu sawara yi ñeel Aji Sax ji. Noonu la sarxalkat biy defale nit ki njotlaayal bàkkaar bi mu def, mu am njéggal. ");
INSERT INTO wolmbs_vpl VALUES ("LV5_1","004_5_1","LEV","5","1","1","«Bu nit bàkkaaree ndax lu mu dégg wooteb seede cib àtte, ba noppi baña wax la mu gis mbaa mu xam ko ca mbir ma, dees na ko ko topp. ");
INSERT INTO wolmbs_vpl VALUES ("LV5_2","004_5_2","LEV","5","2","2","«Su fekkee ne nit ki dafa laal lu sobewu, te seetluwu ko, lu mel ni rab wu daganul te médd, muy rabu àll mbaa ag jur, mbaa luy raam, kon sobewu na, tooñ na. ");
INSERT INTO wolmbs_vpl VALUES ("LV5_3","004_5_3","LEV","5","3","3","Su fekkee ne nit ki dafa laal sobey nit ak su mu mana doon, te teyu ko, ba mu wees, saa yu ko xamee, tooñ na. ");
INSERT INTO wolmbs_vpl VALUES ("LV5_4","004_5_4","LEV","5","4","4","Su sàgganee it ba giñ ne dina def nàngam, muy lu baax mbaa lu bon, muy mboolem ngiñ lu ko rëcc te ba mu koy wax teyu ko, ba mu wees, saa yu ko xamee, tooñ na. ");
INSERT INTO wolmbs_vpl VALUES ("LV5_5","004_5_5","LEV","5","5","5","Ci tooñin yooyu ñu lim war naa wax na mu tooñe. ");
INSERT INTO wolmbs_vpl VALUES ("LV5_6","004_5_6","LEV","5","6","6","Na indil Aji Sax ji gàtt bu jigéen, xar mbaa bëy, muy daanam ndax bàkkaar bi mu def. Saraxu póotum bàkkaar lay doon, sarxalkat bi defal ko ko njotlaayal bàkkaar bi mu def. ");
INSERT INTO wolmbs_vpl VALUES ("LV5_7","004_5_7","LEV","5","7","7","«Nit ki amul lu mat njëgu gàtt, na indil Aji Sax ji ñaari pitax mbaa ñaari xati yu ndaw, muy daanam ndax bàkkaar bi mu def; benn bi di saraxu póotum bàkkaar, bi ci des di sarax rendi-dóomal. ");
INSERT INTO wolmbs_vpl VALUES ("LV5_8","004_5_8","LEV","5","8","8","Da koy yót sarxalkat bi, kooku njëkka rey benn bi, muy saraxu póotum bàkkaar; na kutt baat bi te bumu teqale bopp beek baat bi. ");
INSERT INTO wolmbs_vpl VALUES ("LV5_9","004_5_9","LEV","5","9","9","Day xëpp ci wetu sarxalukaay bi deretu njanaaw liy saraxu póotum bàkkaar. Li des ci deret ji dees koy tuur ci taatu sarxalukaay bi. Saraxu póotum bàkkaar la. ");
INSERT INTO wolmbs_vpl VALUES ("LV5_10","004_5_10","LEV","5","10","10","Ñaareel bi na ko def saraxu rendi-dóomal, muy li ñu santaane. Noonu la ko sarxalkat biy defale njotlaayal bàkkaar bi mu def, mu am njéggal. ");
INSERT INTO wolmbs_vpl VALUES ("LV5_11","004_5_11","LEV","5","11","11","«Su amul lu mat njëgu ñaari pitax mbaa ñaari xati yu ndaw, li muy indi, sarxal ko ngir bàkkaar bi mu def, ñetti kiloy sunguf su mucc ayib lay doon, muy saraxu póotum bàkkaar. Du ci def diw, te du ci sotti cuuraay, ndax li mu di saraxu póotum bàkkaar. ");
INSERT INTO wolmbs_vpl VALUES ("LV5_12","004_5_12","LEV","5","12","12","Da koy yót sarxalkat bi, sarxalkat bi sàkk ci barci-loxo, muy saraxu baaxantal, mu daldi koy lakk ca kaw sarxalukaay bi, mu dolliku ci saraxi sawara yi. Saraxu póotum bàkkaar la. ");
INSERT INTO wolmbs_vpl VALUES ("LV5_13","004_5_13","LEV","5","13","13","Noonu la ko sarxalkat biy defale njotlaayal bàkkaar bi mu def te mu bokk ci xeeti bàkkaar yooyu ñu lim. Su ko defee mu am njéggal. Li des ci sarax bi sarxalkat bee koy moom, mu mel ni bu doon saraxu pepp rekk.» ");
INSERT INTO wolmbs_vpl VALUES ("LV5_14","004_5_14","LEV","5","14","14","Bu loolu weesoo, Aji Sax ji wax na Musaa ne ko: ");
INSERT INTO wolmbs_vpl VALUES ("LV5_15","004_5_15","LEV","5","15","15","«Ku ñàkka wormaal lenn lu ñu sellalal Aji Sax ji te du teyeefam, daan ba ko war, mu di ko indil Aji Sax ji, am kuuy mu amul sikk lay doon, ñuy xayma njëgam, dëppale dayob xaalis baak natt ba ñu yoonal ca néeg bu sell ba. Saraxu peyug tooñ la. ");
INSERT INTO wolmbs_vpl VALUES ("LV5_16","004_5_16","LEV","5","16","16","La mu sàggane woon ca yooyu ñu sellalal Aji Sax ji da koy fey, ba dolli ci juróomeelu céru njëg ga mu fey, jox ko sarxalkat bi. Sarxalkat bi da koy defal kuuy mi njotlaayam, muy saraxu peyug tooñ, ngir mu am njéggal. ");
INSERT INTO wolmbs_vpl VALUES ("LV5_17","004_5_17","LEV","5","17","17","«Su fekkee ne nit ki dafa moy lenn ci santaaney Aji Sax ji ci lu warul lu mu def, su ko xamul it, tooñ na, te dees na ko ko topp. ");
INSERT INTO wolmbs_vpl VALUES ("LV5_18","004_5_18","LEV","5","18","18","Na indi kuuy mu amul sikk, ñu xayma njëgam, yót ko sarxalkat bi, muy saraxu peyug tooñ. Na ko ko sarxalkat bi defal njotlaayal bàkkaar bi mu def te xamu ko woon. Su ko defee mu am njéggal. ");
INSERT INTO wolmbs_vpl VALUES ("LV5_19","004_5_19","LEV","5","19","19","Loolu saraxu peyug tooñ la, ndax kooka kat tooñ na Aji Sax ji.» ");
INSERT INTO wolmbs_vpl VALUES ("LV5_20","004_5_20","LEV","5","20","20","Aji Sax ji wax na Musaa ba tey ne ko: ");
INSERT INTO wolmbs_vpl VALUES ("LV5_21","004_5_21","LEV","5","21","21","«Su nit ñàkkee wormaal Aji Sax ji ci waxi fen yu mu wax moroomam, ci alal ju ñu ko tayle mbaa ñu abal ko ko, mbaa muy lu mu jële ci càcc mbaa àq ju mu lekke ci moroomam, ");
INSERT INTO wolmbs_vpl VALUES ("LV5_22","004_5_22","LEV","5","22","22","mbaa muy lu réer boroom, mu for ko, di ko miim, mbaa mu giñ te du dëgg ci mbir mu mu mana doon, ");
INSERT INTO wolmbs_vpl VALUES ("LV5_23","004_5_23","LEV","5","23","23","ku bàkkaare noonu ñu ko waxe, tooñ na, te na delloo alal ji mu ame ci càcc, mbaa njublaŋ mbaa tayle ñu ko dénkoon, mbaa muy lu réer, mu for ko. ");
INSERT INTO wolmbs_vpl VALUES ("LV5_24","004_5_24","LEV","5","24","24","Su dee leneen lu ko taxoona giñ te du dëgg itam naka noonu, na ko delloo ba mu mat sëkk, te saa yu ci nekk da cay dolli juróomeelu céru njëg ga, jox ko boroom alal ja, keroog ba muy génne saraxu peyug tooñam. ");
INSERT INTO wolmbs_vpl VALUES ("LV5_25","004_5_25","LEV","5","25","25","Na yóbbul Aji Sax ji li ñu koy daan, muy am kuuy mu amul sikk, ñu xayma njëgam, muy saraxas peyug tooñ su muy yót sarxalkat bi. ");
INSERT INTO wolmbs_vpl VALUES ("LV5_26","004_5_26","LEV","5","26","26","Noonu la ko sarxalkat biy defale njotlaayam fa kanam Aji Sax ji, mu am njéggal ci mboolem lu mu defoon te mu dig tooñam.» ");
INSERT INTO wolmbs_vpl VALUES ("LV6_1","004_6_1","LEV","6","1","1","Aji Sax ji waxaat Musaa ne ko: ");
INSERT INTO wolmbs_vpl VALUES ("LV6_2","004_6_2","LEV","6","2","2","«Santal Aaróona ak doomam yu góor, ne leen li ñu dogal ci saraxu rendi-dóomal mooy lii: Ab saraxu rendi-dóomal day fanaan fi ñu koy lakke ci kaw sarxalukaay bi, ba bët set, sawara way wéye tàkk ca kaw sarxalukaay ba. ");
INSERT INTO wolmbs_vpl VALUES ("LV6_3","004_6_3","LEV","6","3","3","Sarxalkat bi day sol mbubbam mi ñu ràbbe lẽe, ak tubéyi njiitlaayam ji ñu ràbbe lẽe. Na tonnee ca sarxalukaay ba dóomu saraxu rendi-dóomal bi, daldi teg dóom bi ci wetu sarxalukaay bi. ");
INSERT INTO wolmbs_vpl VALUES ("LV6_4","004_6_4","LEV","6","4","4","Su ko defee mu summi yéreem yooyu, sol yeneen te génne dóom bi dal bi, yóbbu ko fu mucc sobe. ");
INSERT INTO wolmbs_vpl VALUES ("LV6_5","004_6_5","LEV","6","5","5","Na sawaras sarxalukaay bi wéye tàkk te du fey. Suba su nekk na ko sarxalkat bi xamb, ba noppi teg ci saraxu rendi-dóomal bi, te na lakk nebboni saraxi cant gi ci biir jàmm. ");
INSERT INTO wolmbs_vpl VALUES ("LV6_6","004_6_6","LEV","6","6","6","Na sawara wéye tàkk fàww ci kaw sarxalukaay bi, te bumu fey. ");
INSERT INTO wolmbs_vpl VALUES ("LV6_7","004_6_7","LEV","6","7","7","«Li ñu dogal ci saraxi pepp mooy lii: Na ko doomi Aaróona yu góor joxe fa kanam Aji Sax ji ca sarxalukaay ba. ");
INSERT INTO wolmbs_vpl VALUES ("LV6_8","004_6_8","LEV","6","8","8","Barci-loxob sunguf su mucc ayib ànd ak diwam lees ciy tibbe, boole kook mboolem cuuraay la ca kaw saraxu pepp ma, daldi koy lakk ci kaw sarxalukaay bi, muy xeeñ xetug jàmm gu neex Aji Sax ji, di saraxu baaxantal. ");
INSERT INTO wolmbs_vpl VALUES ("LV6_9","004_6_9","LEV","6","9","9","La ca des Aaróona aki doomam yu góor ñoo koy lekk, te buñu ci boole lawiir. Nañu ko lekke ci béreb bu sell. Ci biir ëttu xaymab ndaje mi lañu koy lekke. ");
INSERT INTO wolmbs_vpl VALUES ("LV6_10","004_6_10","LEV","6","10","10","Deesu ko lakkaaleek lawiir. Seen cér la bu leen Aji Sax ji sédd ci saraxi sawaraam. Lu sella sell la, mel ni saraxu póotum bàkkaar ak saraxu peyug tooñ. ");
INSERT INTO wolmbs_vpl VALUES ("LV6_11","004_6_11","LEV","6","11","11","Képp kuy góor ci doomi Aaróona yi man na cee lekk. Seen cér la bu ñu leen sédde ci saraxi sawara yi ñeel Aji Sax ji, te dogalal leen ko fàww. Lépp lu ci laal day doon lu sella sell.» ");
INSERT INTO wolmbs_vpl VALUES ("LV6_12","004_6_12","LEV","6","12","12","Aji Sax ji wax na Musaa ba tey ne ko: ");
INSERT INTO wolmbs_vpl VALUES ("LV6_13","004_6_13","LEV","6","13","13","«Li Aaróona aki doomam yu góor di sarxalal Aji Sax ji, keroog bu ñu koy diw, fal ko, mooy lii: ñetti kiloy sunguf su mucc ayib, tollook saraxu pepp bi ñu saxoo bés bu nekk, te genn-wàll gi di suba, genn-wàll gi ngoon. ");
INSERT INTO wolmbs_vpl VALUES ("LV6_14","004_6_14","LEV","6","14","14","Saafukaayu weñ lañu koy lakke, xiiwaale ko diw, indi xiiw ba, muy saraxu pepp. Nañu ko def ay dog yu ñuy lakk, muy xeeñ xetug jàmm gu neex Aji Sax ji. ");
INSERT INTO wolmbs_vpl VALUES ("LV6_15","004_6_15","LEV","6","15","15","Sarxalkat bi ñuy fal ci doomi Aaróona yu góor yi, mu war koo wuutu, da koy def moom itam. Aji Sax ji moo jagoo sarax boobu fàww, te dañu koy lakk ba mu jeex. ");
INSERT INTO wolmbs_vpl VALUES ("LV6_16","004_6_16","LEV","6","16","16","Te it mboolem saraxu pepp bu sarxalkat di defal boppam, dees koy lakk ba mu jeex. Deesu ci lekk.» ");
INSERT INTO wolmbs_vpl VALUES ("LV6_17","004_6_17","LEV","6","17","17","Aji Sax ji waxati Musaa ne ko: ");
INSERT INTO wolmbs_vpl VALUES ("LV6_18","004_6_18","LEV","6","18","18","«Waxal Aaróona ak doomam yu góor ne leen: Dogal bi ci saraxu póotum bàkkaar mooy lii: Juru saraxas póotum bàkkaar dañu koy rendi fa ñu wara rendi juru saraxu dóomal, fi kanam Aji Sax ji. Lu sella sell la. ");
INSERT INTO wolmbs_vpl VALUES ("LV6_19","004_6_19","LEV","6","19","19","Sarxalkat bi koy rendi, muy saraxu póotum bàkkaar, da ciy lekk, te fu sell lañu koy lekke, ci biir ëttu xaymab ndaje mi. ");
INSERT INTO wolmbs_vpl VALUES ("LV6_20","004_6_20","LEV","6","20","20","Lépp lu laal ci yàpp wi, day doon lu sell, te bu lenn ci deretu sarax si tisee ci kawi yére, dees koy xaj fa mu tis, ci béreb bu sell. ");
INSERT INTO wolmbs_vpl VALUES ("LV6_21","004_6_21","LEV","6","21","21","Su fekkee ne ndabal xandeer lañu togge woon yàppu sarax sa, nañu ko toj. Bu doon ndabal xànjar, ñu jonj ko, raxas ko. ");
INSERT INTO wolmbs_vpl VALUES ("LV6_22","004_6_22","LEV","6","22","22","Képp kuy góor ci askanu sarxalkat sañ na cee lekk. Lu sella sell la. ");
INSERT INTO wolmbs_vpl VALUES ("LV6_23","004_6_23","LEV","6","23","23","Waaye juru saraxas póotum bàkkaar deesu ci lekk lenn te fekk deretam dugg ca biir xaymab ndaje ma, ñu di ca amal ag njotlaay ca biir néeg bu sell ba. Loolu du lu ñuy lekk. Dees koy lakk, ba mu dib dóom. ");
INSERT INTO wolmbs_vpl VALUES ("LV7_1","004_7_1","LEV","7","1","1","«Liy dogal bi ci saraxas peyug tooñ mooy lii: Lu sella sell la. ");
INSERT INTO wolmbs_vpl VALUES ("LV7_2","004_7_2","LEV","7","2","2","Fa ñuy rendee juru saraxu dóomal, fa lañu wara rendee juru saraxas peyug tooñ. Deret ji dees koy xëpp ci mboolem weti sarxalukaay bi. ");
INSERT INTO wolmbs_vpl VALUES ("LV7_3","004_7_3","LEV","7","3","3","Nebbon ji jépp lañuy sarxal: calgeen bi, nebbon bi sàng yérey biir yi, ");
INSERT INTO wolmbs_vpl VALUES ("LV7_4","004_7_4","LEV","7","4","4","ak ñaari dëmbéen yi ànd ak seen nebbon ca kaw, jàpp ca fàllare ja, ak bàjjo bi ci res wi te ñu di ko booleek dëmbéen yi, génne ko. ");
INSERT INTO wolmbs_vpl VALUES ("LV7_5","004_7_5","LEV","7","5","5","Sarxalkat bi da koy boole lakk ci kaw sarxalukaay bi, muy saraxu sawara, ñeel Aji Sax ji, te di saraxu peyug tooñ. ");
INSERT INTO wolmbs_vpl VALUES ("LV7_6","004_7_6","LEV","7","6","6","Képp kuy góor te bokk ci askanu sarxalkat yi sañ na cee lekk. Béreb bu sell lees koy lekke. Lu sella sell la. ");
INSERT INTO wolmbs_vpl VALUES ("LV7_7","004_7_7","LEV","7","7","7","«Li ci saraxu póotum bàkkaar moo nekk ci saraxu peyug tooñ, dogal bi di benn ci yooyu ñaar. Sarxalkat bi def gàtt bi njotlaay moo koy moom. ");
INSERT INTO wolmbs_vpl VALUES ("LV7_8","004_7_8","LEV","7","8","8","Su nit joxee ab saraxu rendi-dóomal, sarxalkat bi mooy féetewoo deru jur gi mu sarxal. ");
INSERT INTO wolmbs_vpl VALUES ("LV7_9","004_7_9","LEV","7","9","9","Ci biir loolu bépp saraxu pepp mu ñu lakk cib taal, mbaa ñu saaf ko ci cin mbaa ci saafukaayu weñ, sarxalkat bi koy joxe moo koy moom. ");
INSERT INTO wolmbs_vpl VALUES ("LV7_10","004_7_10","LEV","7","10","10","Waaye weneen xeetu saraxu pepp mu mu mana doon, su dee saraxu pepp mu ñuy xiiwaale diw mbaa muy mu wow, doomi Aaróona yu góor yépp a koy moom, ku nekk tollook sa moroom cér. ");
INSERT INTO wolmbs_vpl VALUES ("LV7_11","004_7_11","LEV","7","11","11","«Li yoon dogal ci saraxu cant ci biir jàmm, te nit sañ koo sarxalal Aji Sax ji mooy lii: ");
INSERT INTO wolmbs_vpl VALUES ("LV7_12","004_7_12","LEV","7","12","12","Bu ci nit ki jubloo ag njukkal gu muy delloo Aji Sax ji, day boole ci saraxu cant gi ay mburu yu ndaw yu amul lawiir yu ñu xiiwaale diw ak ay mburu yu tàppandaar yu amul lawiir, ñu wis diw ca kaw, ak ay mburu yu ñu lakke sunguf su mucc ayib, xiiwaale ko diw, noot ko bu baax. ");
INSERT INTO wolmbs_vpl VALUES ("LV7_13","004_7_13","LEV","7","13","13","Sarax boobu da ciy dolli mburu yu am lawiir, boole kook saraxu cant googu ci biir jàmm te mu jublu ci njukkal Aji Sax ji. ");
INSERT INTO wolmbs_vpl VALUES ("LV7_14","004_7_14","LEV","7","14","14","Nañu jébbal Aji Sax ji ab cér ci sarax yooyu yépp, muy moomeelu sarxalkat bi xëpp deretu juru saraxas cant gi ci biir jàmm ci mboolem weti sarxalukaay bi. ");
INSERT INTO wolmbs_vpl VALUES ("LV7_15","004_7_15","LEV","7","15","15","Yàppu saraxas cant googu ci biir jàmm te ñu jublu ci njukkal Aji Sax ji, dees koy lekk bés bi ñu ko rendee. Du lenn lees ciy wacc, mu fanaan. ");
INSERT INTO wolmbs_vpl VALUES ("LV7_16","004_7_16","LEV","7","16","16","«Su sarax si nit kiy génne dee sarax su ñuy wàccoo ngiñ mbaa saraxu yéene, dees na ko lekk bés bi ko nit ki joxee, te lu ca des ba ca ëllëg sa, ñu man koo lekk. ");
INSERT INTO wolmbs_vpl VALUES ("LV7_17","004_7_17","LEV","7","17","17","Lu des ci yàppu sarax si ba ca gannaaw ëllëg sa dees koy lakk, ba mu dib dóom. ");
INSERT INTO wolmbs_vpl VALUES ("LV7_18","004_7_18","LEV","7","18","18","Waaye kat bu nit lekkee lenn ci yàpp wu ñu def saraxu cant ci biir jàmm te fekk mu am ñetti fan, deesul nangul boroom sarax bi te du ko jariñ dara. Lu seexluwu la te ku ca lekk mooy gàddu bàkkaaram. ");
INSERT INTO wolmbs_vpl VALUES ("LV7_19","004_7_19","LEV","7","19","19","Yàpp wu ci laal lenn lu sobewu it deesu ko lekk. Dees koy lakk. Ci biir loolu yàppu sarax, képp ku set sañ nga cee lekk. ");
INSERT INTO wolmbs_vpl VALUES ("LV7_20","004_7_20","LEV","7","20","20","Waaye ku sobewu ku lekk ci yàppu jur gu ñu defal Aji Sax ji saraxu cant ci biir jàmm, kooku nañu ko dagge ci askanam. ");
INSERT INTO wolmbs_vpl VALUES ("LV7_21","004_7_21","LEV","7","21","21","Sobe su mu mana doon, muy lu jóge ci nit mbaa mala mu daganul mbaa mboolem lu daganul te seexluwu, ku ci laal ba noppi, lekk ci lu ñu defal Aji Sax ji saraxu cant ci biir jàmm, kooku dees koo wara dagge ci askanam.» ");
INSERT INTO wolmbs_vpl VALUES ("LV7_22","004_7_22","LEV","7","22","22","Aji Sax ji dellu wax Musaa ne ko: ");
INSERT INTO wolmbs_vpl VALUES ("LV7_23","004_7_23","LEV","7","23","23","«Waxal bànni Israayil ne leen: Buleen lekk lenn luy nebbonu nag mbaa xar mbaa bëy. ");
INSERT INTO wolmbs_vpl VALUES ("LV7_24","004_7_24","LEV","7","24","24","Nebbonu jur gu dee mbaa lu rabu àll fàdd, manees na koo jëfandikoo neneen nu mu mana doon, waaye deesu ko lekk mukk. ");
INSERT INTO wolmbs_vpl VALUES ("LV7_25","004_7_25","LEV","7","25","25","Képp ku lekk ci nebbonu jur gu ñu def saraxu sawara, ñeel Aji Sax ji, kooku ko lekk, dees koy dagge ci askanam. ");
INSERT INTO wolmbs_vpl VALUES ("LV7_26","004_7_26","LEV","7","26","26","Te itam du lenn luy deret lu ngeen di lekke fenn fu ngeen dëkk, mu jóge ci njanaaw mbaa ag jur. ");
INSERT INTO wolmbs_vpl VALUES ("LV7_27","004_7_27","LEV","7","27","27","Képp ku lekk lenn luy deret, dees na ko dagge ci askanam.» ");
INSERT INTO wolmbs_vpl VALUES ("LV7_28","004_7_28","LEV","7","28","28","Aji Sax ji dellooti wax Musaa ne ko: ");
INSERT INTO wolmbs_vpl VALUES ("LV7_29","004_7_29","LEV","7","29","29","«Waxal bànni Israayil ne leen: Képp kuy jox Aji Sax ji saraxu cantam ci biir jàmm na indi cér bi Aji Sax ji séddoo ci saraxu cant googu ci biir jàmm. ");
INSERT INTO wolmbs_vpl VALUES ("LV7_30","004_7_30","LEV","7","30","30","Ci loxol boppam lay dindee sarax bi ñuy def saraxu sawara, ñeel Aji Sax ji. Day indi nebbon bi, boole kook dënn bi, dënn bi di sarax bu ñuy yékkati, jébbal Aji Sax ji. ");
INSERT INTO wolmbs_vpl VALUES ("LV7_31","004_7_31","LEV","7","31","31","Sarxalkat bi day lakk nebbon bi ci kaw sarxalukaay bi, waaye dënn bi, Aaróona aki doomam yu góor ñoo ko moom. ");
INSERT INTO wolmbs_vpl VALUES ("LV7_32","004_7_32","LEV","7","32","32","Tànkub ndijoor bi jóge ci seen saraxi cant ci biir jàmm, dees koy jébbal sarxalkat bi. ");
INSERT INTO wolmbs_vpl VALUES ("LV7_33","004_7_33","LEV","7","33","33","Doomu Aaróona ji joxe deretu sarax beek nebbon bi jóge ci saraxu cant gi ci biir jàmm, kookoo jagoo tànkub ndijoor bi, muy céram. ");
INSERT INTO wolmbs_vpl VALUES ("LV7_34","004_7_34","LEV","7","34","34","Li ko waral mooy, man Aji Sax ji damaa jële ci seen saraxi cant ci biir jàmm, dënn bi ñuy def saraxu yékkati-jébbale, ak tànk bi ñu jébbal, jox ko Aaróona, sarxalkat bi mook doomam yu góor. Seen cér la ba fàww ci biir bànni Israayil.» ");
INSERT INTO wolmbs_vpl VALUES ("LV7_35","004_7_35","LEV","7","35","35","Loolooy céri pal yi Aaróona ak askanam di am ci saraxi sawara yi ñeel Aji Sax ji, dale ko keroog bu ñu leen teewalee fi kanam Aji Sax ji, ñu doon ay sarxalkat. ");
INSERT INTO wolmbs_vpl VALUES ("LV7_36","004_7_36","LEV","7","36","36","Loolu la Aji Sax ji santaane ñu jox leen ko. Bés bu ñu leen xasee diw, fal leen, mu daldi doon seen cér ci biir bànni Israayil ak seen askan ba fàww. ");
INSERT INTO wolmbs_vpl VALUES ("LV7_37","004_7_37","LEV","7","37","37","Loolu la yoon digle ci wàllu saraxu rendi-dóomal, ak saraxu pepp ak saraxu póotum bàkkaar ak saraxu peyug tooñ ak saraxu xewu colu ak saraxu cant ci biir jàmm. ");
INSERT INTO wolmbs_vpl VALUES ("LV7_38","004_7_38","LEV","7","38","38","Loolu it la Aji Sax ji dénkoon Musaa ca kaw tundu Sinayi, bés ba mu santee bànni Israayil ca màndiŋu Sinayi ñu di ko génneel ay sarax. ");
INSERT INTO wolmbs_vpl VALUES ("LV8_1","004_8_1","LEV","8","1","1","Aji Sax ji waxati Musaa ne ko: ");
INSERT INTO wolmbs_vpl VALUES ("LV8_2","004_8_2","LEV","8","2","2","«Indil Aaróona aki doomam yu góor te indaale yére yi ak diw gi ñuy fale ak yëkk wiy saraxu póotum bàkkaar ak ñaari kuuy yi, boole ca pañeb mburu ya amul lawiir, ");
INSERT INTO wolmbs_vpl VALUES ("LV8_3","004_8_3","LEV","8","3","3","te nga woo mbooloo mi mépp, ñu daje ci bunt xaymab ndaje mi.» ");
INSERT INTO wolmbs_vpl VALUES ("LV8_4","004_8_4","LEV","8","4","4","Musaa def la ko Aji Sax ji sant, mbooloo ma daje ca bunt xaymab ndaje ma. ");
INSERT INTO wolmbs_vpl VALUES ("LV8_5","004_8_5","LEV","8","5","5","Musaa wax mbooloo ma ne leen: «Lii laay waajal muy li Aji Sax ji santaane woon ñu def ko.» ");
INSERT INTO wolmbs_vpl VALUES ("LV8_6","004_8_6","LEV","8","6","6","Ci kaw loolu Musaa indi Aaróona aki doomam yu góor, ñu sangu, ");
INSERT INTO wolmbs_vpl VALUES ("LV8_7","004_8_7","LEV","8","7","7","solal Aaróona jàllaabi ba, takkal ko laxasaay ga, solal ko mbubb ma, tegal ko ca xar-sànni ma, takkal ko ngañaay la ca kawam, jàppe ko ko, mu tafu ca kawam. ");
INSERT INTO wolmbs_vpl VALUES ("LV8_8","004_8_8","LEV","8","8","8","Mu solal ko nag kiiraayal dënn ba, daldi yeb ca biir kiiraay la jumtukaayi tegtal ya, di Urim ba ak Tumim ba, ");
INSERT INTO wolmbs_vpl VALUES ("LV8_9","004_8_9","LEV","8","9","9","la ca tegu mu tegal ko kaala ga ca bopp ba, takkal ko dogu wurus wu tell wa, mooy meeteel gu sell ga, mu nekk ca kaw kaala ga, féete kanam, muy la Aji Sax ji santoon Musaa. ");
INSERT INTO wolmbs_vpl VALUES ("LV8_10","004_8_10","LEV","8","10","10","Ba loolu wéyee Musaa jël diwu pal ga, diw ca jaamookaay baak ya ca biir yépp, sellale ko yooya, ");
INSERT INTO wolmbs_vpl VALUES ("LV8_11","004_8_11","LEV","8","11","11","ba noppi wis-wisal ca juróom ñaari yoon ca kaw sarxalukaay ba, diwe ko sarxalukaay ba ak mboolem ay ndabam, boole ca mbalkam njàpp ma, mookub tegoom ngir yooyu it sell. ");
INSERT INTO wolmbs_vpl VALUES ("LV8_12","004_8_12","LEV","8","12","12","Mu sotti nag tuuti ci diw gi ñuy fale ci boppu Aaróona, diw ko, sellale ko ko. ");
INSERT INTO wolmbs_vpl VALUES ("LV8_13","004_8_13","LEV","8","13","13","Ba mu ko defee Musaa indi doomi Aaróona yu góor ya, solal leen seeni jàllaabi, takkal leen ay laxasaay, solal leen mbaxana, muy la Aji Sax ji santoon Musaa. ");
INSERT INTO wolmbs_vpl VALUES ("LV8_14","004_8_14","LEV","8","14","14","Musaa teg ca indi yëkku sarax siy póotum bàkkaar, Aaróona aki doomam teg seeni loxo ci kaw boppu yëkku sarax siy póotum bàkkaar, ");
INSERT INTO wolmbs_vpl VALUES ("LV8_15","004_8_15","LEV","8","15","15","Musaa rendi ko, sàkk ci deret ji, capp ci baaraamam, diw ci ñeenti béjjéni sarxalukaay bi yépp, setale ko sarxalukaay bi. Mu daldi tuur li des ci deret ji ci taatu sarxalukaay bi, sellale ko noonu, muy njotlaayal sarxalukaay bi. ");
INSERT INTO wolmbs_vpl VALUES ("LV8_16","004_8_16","LEV","8","16","16","Ba loolu amee mu jël nebbon bi sàng yérey biir yi, ak bàjjo bi ci res wi ak ñaari dëmbéen yi ànd ak seen nebbon, lakk ko ci kaw sarxalukaay bi. ");
INSERT INTO wolmbs_vpl VALUES ("LV8_17","004_8_17","LEV","8","17","17","Li des ci yëkk wi, di der beek yàpp week sébbriit mi, mu génne ko dal bi, lakk ko ca biti, muy la Aji Sax ji santoon Musaa. ");
INSERT INTO wolmbs_vpl VALUES ("LV8_18","004_8_18","LEV","8","18","18","La ca tegu mu indi kuuyu saraxu rendi-dóomal bi. Aaróona ak doomam yu góor teg seeni loxo ca boppu kuuy ma. ");
INSERT INTO wolmbs_vpl VALUES ("LV8_19","004_8_19","LEV","8","19","19","Musaa rendi ko, xëpp deret ji ci mboolem weti sarxalukaay bi, ");
INSERT INTO wolmbs_vpl VALUES ("LV8_20","004_8_20","LEV","8","20","20","daldi daggat kuuy mi, def ko ay dog, boole bopp beek dog yeek nebbon bi, lakk ko, ba mu dib dóom. ");
INSERT INTO wolmbs_vpl VALUES ("LV8_21","004_8_21","LEV","8","21","21","Ba loolu weesoo Musaa boole yérey biir yi, ak yeel yi, raxas, ba noppi lakk kuuy mi yépp ca sarxalukaay ba. Loolu saraxu rendi-dóomal la, ngir xetug jàmm. Saraxu sawara la, ñeel Aji Sax ji, na ko Aji Sax ji sante woon Musaa. ");
INSERT INTO wolmbs_vpl VALUES ("LV8_22","004_8_22","LEV","8","22","22","Gannaaw loolu Musaa indi kuuy ma ca des, di kuuyu xewu colu. Aaróona aki doomam teg seeni loxo ci boppu kuuy mi, ");
INSERT INTO wolmbs_vpl VALUES ("LV8_23","004_8_23","LEV","8","23","23","Musaa rendi ko, sàkk ca deret ja, taqal ca tabanum noppu ndijooru Aaróona, taqal ca baaraamu déyu ndijooram ak baaraamu déyu tànku ndijooram. ");
INSERT INTO wolmbs_vpl VALUES ("LV8_24","004_8_24","LEV","8","24","24","Musaa doora indi doomi Aaróona yu góor ya, sàkk ca deret ja, taqal ca seen tabani noppi ndijoor ak seen baaraamu déyu ndijoor ak seen baaraamu déyu tànki ndijoor. La des ca deret ja, Musaa xëpp ko ca mboolem weti sarxalukaay bi. ");
INSERT INTO wolmbs_vpl VALUES ("LV8_25","004_8_25","LEV","8","25","25","Ba mu ko defee mu génne nebbon bi, muy calgeen bi ak nebbon bi sàng yérey biir yépp, ak bàjjo bi ci res wi ak ñaari dëmbéen yi ànd ak seen nebbon, ak tànkub ndijoor bi. ");
INSERT INTO wolmbs_vpl VALUES ("LV8_26","004_8_26","LEV","8","26","26","Pañe bi def mburu yi amul lawiir, taaje fi kanam Aji Sax ji, mu sàkke ca menn mburu mu wërngalu te tàppandaar wu amul lawiir, ak menn mburu mu ñu xiiwe diwu oliw, ak menn mburu mu ndaw te gëna sew, boole ko teg ca kaw nebbon ba ak tànku ndijoor ba. ");
INSERT INTO wolmbs_vpl VALUES ("LV8_27","004_8_27","LEV","8","27","27","Mu boole yooyu yépp teg ci loxol Aaróona ak loxoy doomam yu góor, ngir ñu def ko sarax bu ñuy yékkati jébbal Aji Sax ji. ");
INSERT INTO wolmbs_vpl VALUES ("LV8_28","004_8_28","LEV","8","28","28","Ba loolu amee Musaa nangoo ko ca seeni loxo, teg ko ca kaw saraxu rendi-dóomal ba, lakk ko ca sarxalukaay ba. Loolu saraxas xewu colu la woon, ngir xetug jàmm. Saraxu sawara la, ñeel Aji Sax ji. ");
INSERT INTO wolmbs_vpl VALUES ("LV8_29","004_8_29","LEV","8","29","29","Musaa daldi jël dënn biy céram ci kuuyum xewu colu gi, yékkati ko, jébbal Aji Sax ji, muy saraxu yékkati-jébbale, di la Aji Sax ji santoon Musaa. ");
INSERT INTO wolmbs_vpl VALUES ("LV8_30","004_8_30","LEV","8","30","30","Musaa teg ca sàkk ca diwu pal ga, ak deret ji ci sarxalukaay bi, wis-wisal ko ci kaw yaramu Aaróona ak ca kawi yéreem, wis-wisaale ko ca kaw yarami doomam yu góor ak ca seen kawi yére. Mu sellal Aaróona ak ay yéreem, bokk sellalaale ay doomam ak seeni yére. ");
INSERT INTO wolmbs_vpl VALUES ("LV8_31","004_8_31","LEV","8","31","31","Musaa wax ak Aaróona aki doomam yu góor ne leen: «Toggleen yàpp wi ci bunt xaymab ndaje mi te lekke ko foofa, boole kook mburu mi ci pañeb saraxi xewu colu gi, muy la ma santaane woon ne yaw Aaróona yaak say doom yu góor yeena koy lekk. ");
INSERT INTO wolmbs_vpl VALUES ("LV8_32","004_8_32","LEV","8","32","32","Li des ci yàpp wi ak mburu mi, lakkleen ko, ba mu dib dóom. ");
INSERT INTO wolmbs_vpl VALUES ("LV8_33","004_8_33","LEV","8","33","33","Waaye bunt xaymab ndaje mi buleen ko wees diiru juróom ñaari fan, ba bésub keroog ba seen xewu colu di mat, ndax juróom ñaari fan lay mat. ");
INSERT INTO wolmbs_vpl VALUES ("LV8_34","004_8_34","LEV","8","34","34","Lépp lu ñu def tey, Aji Sax ji daa santaane ñu def ko, mu daldi matal seen njotlaay. ");
INSERT INTO wolmbs_vpl VALUES ("LV8_35","004_8_35","LEV","8","35","35","Ci bunt xaymab ndaje mi ngeen di yem guddeek bëccëg diiru juróom ñaari fan, boole ci di sàmm ndénkaaneb Aji Sax ji, ndax ngeen baña dee, ndaxte loolu moo di li ñu ma santoon.» ");
INSERT INTO wolmbs_vpl VALUES ("LV8_36","004_8_36","LEV","8","36","36","Aaróona ak doomam yu góor nag def lépp lu Aji Sax ji santaane woon, Musaa jottali. ");
INSERT INTO wolmbs_vpl VALUES ("LV9_1","004_9_1","LEV","9","1","1","Keroog bésub juróom ñetteel ba, Musaa woolu na Aaróona ak doomam yu góor, ñook magi Israayil ña. ");
INSERT INTO wolmbs_vpl VALUES ("LV9_2","004_9_2","LEV","9","2","2","Mu ne Aaróona: «Sàkkal aw sëllu, muy saraxas póotum bàkkaar akum kuuy, muy saraxu rendi-dóomal, te bu ci lenn am sikk, nga boole indil Aji Sax ji. ");
INSERT INTO wolmbs_vpl VALUES ("LV9_3","004_9_3","LEV","9","3","3","Te nga wax bànni Israayil ne leen ñu jël ab sikket, mu doon saraxu póotum bàkkaar, ak aw sëllu ak am kuuy mu ndaw, lu ci nekk am at te mucc sikk, ngir saraxu rendi-dóomal, ");
INSERT INTO wolmbs_vpl VALUES ("LV9_4","004_9_4","LEV","9","4","4","ak itam aw nag ak am kuuy mu mag, muy saraxu cant ci biir jàmm, di lu ñuy rendi fi kanam Aji Sax ji. Nañu defaale saraxu pepp mu am diw, ndax tey jii Aji Sax ji dina leen feeñu.» ");
INSERT INTO wolmbs_vpl VALUES ("LV9_5","004_9_5","LEV","9","5","5","Ba mu ko defee ñu yóbbu ca bunt xaymab ndaje ma la Musaa santaane woon, mbooloo ma mépp ñëw, taxaw fa kanam Aji Sax ji. ");
INSERT INTO wolmbs_vpl VALUES ("LV9_6","004_9_6","LEV","9","6","6","Musaa ne: «Lii mooy li Aji Sax ji santaane ne, moom ngeen wara def ngir leeram feeñu leen.» ");
INSERT INTO wolmbs_vpl VALUES ("LV9_7","004_9_7","LEV","9","7","7","Musaa wax ak Aaróona ne ko: «Dikkal fii ci sarxalukaay bi te joxe sa saraxu póotum bàkkaar ak sa saraxu rendi-dóomal, nga jotoo ko, yaw yaak mbooloo mi, boo noppee joxe saraxu mbooloo mi, jote leen ko, muy li Aji Sax ji santaane.» ");
INSERT INTO wolmbs_vpl VALUES ("LV9_8","004_9_8","LEV","9","8","8","Aaróona dikk ba ci sarxalukaay bi, rendi sëllu wi, muy saraxu póotum bàkkaaram. ");
INSERT INTO wolmbs_vpl VALUES ("LV9_9","004_9_9","LEV","9","9","9","Gannaaw loolu doomi Aaróona yu góor ya indil ko deret ja, mu capp ca baaraamam, taqal ca béjjéni sarxalukaay ba; la des ca deret ja mu tuur ko ca taatu sarxalukaay ba. ");
INSERT INTO wolmbs_vpl VALUES ("LV9_10","004_9_10","LEV","9","10","10","Aaróona jël nebbon bi jóge ci sarax biy póotum bàkkaar, aki dëmbéenam ak bàjjo bi ci res wi, mu boole ko lakk ci kaw sarxalukaay bi, muy la Aji Sax ji santoon Musaa. ");
INSERT INTO wolmbs_vpl VALUES ("LV9_11","004_9_11","LEV","9","11","11","Yàpp wi ak der bi, mu génne ko dal ba, lakk ko, ba mu dib dóom. ");
INSERT INTO wolmbs_vpl VALUES ("LV9_12","004_9_12","LEV","9","12","12","La ca tegu Aaróona rendi juru rendi-dóomal bi. Ba loolu amee doomam yu góor ya jox ko deret ja, mu xëpp ko ci mboolem weti sarxalukaay bi. ");
INSERT INTO wolmbs_vpl VALUES ("LV9_13","004_9_13","LEV","9","13","13","Ñu jox ko saraxu rendi-dóomal bi ñu def dog yu ànd ak bopp ba, mu boole lakk ca sarxalukaay ba. ");
INSERT INTO wolmbs_vpl VALUES ("LV9_14","004_9_14","LEV","9","14","14","Loolu wéy, mu raxas yérey biir yi, ak yeel yi, teg ko ca kaw saraxu rendi-dóomal ba, lakkaale ko ca sarxalukaay ba. ");
INSERT INTO wolmbs_vpl VALUES ("LV9_15","004_9_15","LEV","9","15","15","Gannaaw gi, Aaróona indi saraxi mbooloo mi, jël sikketu mbooloo miy doon seen saraxu póotum bàkkaar, rendi ko, sarxal ko, na mu sarxale la jiitu. ");
INSERT INTO wolmbs_vpl VALUES ("LV9_16","004_9_16","LEV","9","16","16","Ci kaw loolu mu indi saraxu rendi-dóomal ba, sarxal ko, na ñu ko diglee. ");
INSERT INTO wolmbs_vpl VALUES ("LV9_17","004_9_17","LEV","9","17","17","Mu doora indi saraxu pepp mi, sàkk ci ab tib, lakk ko ca kaw sarxalukaay ba, dolli ko ca saraxu rendi-dóomalu suba sa. ");
INSERT INTO wolmbs_vpl VALUES ("LV9_18","004_9_18","LEV","9","18","18","Mu sooga rendi nag wi ak kuuy mi, defal ko mbooloo mi saraxu cant ci biir jàmm. Doomam yu góor ya jox ko deret ja, mu xëpp ko ca wet gu nekk ca sarxalukaay ba. ");
INSERT INTO wolmbs_vpl VALUES ("LV9_19","004_9_19","LEV","9","19","19","Waaye lay nebbon ca nag wa ak kuuy ma, di calgeen ba ak nebbon bi sàng yérey biir yi, ak dëmbéen yi ak bàjjo bi ci res wi, ");
INSERT INTO wolmbs_vpl VALUES ("LV9_20","004_9_20","LEV","9","20","20","nebbon yooyu lañu teg ca kaw dënni nag wa ak kuuy ma, Aaróona lakk ko ca kaw sarxalukaay ba. ");
INSERT INTO wolmbs_vpl VALUES ("LV9_21","004_9_21","LEV","9","21","21","Ba mu ko defee Aaróona yékkati dënn yaak tànku ndijoor ba, defal ko Aji Sax ji saraxu yékkati-jébbale, muy la Musaa santaane woon. ");
INSERT INTO wolmbs_vpl VALUES ("LV9_22","004_9_22","LEV","9","22","22","Ba Aaróona noppee, yékkati na ay loxoom ca mbooloo ma, ñaanal leen, doora wàcc. Fekk na mu joxe saraxu póotum bàkkaar ba, ak saraxu rendi-dóomal ba, ak saraxu cant ga ci biir jàmm. ");
INSERT INTO wolmbs_vpl VALUES ("LV9_23","004_9_23","LEV","9","23","23","Musaa ak Aaróona ànd dugg ca biir xaymab ndaje ma; ba ñu génnee, ñaanal mbooloo ma, leeru Aji Sax ji feeñu mbooloo ma mépp. ");
INSERT INTO wolmbs_vpl VALUES ("LV9_24","004_9_24","LEV","9","24","24","Ci kaw loolu sawara bawoo fi Aji Sax ji, tàkk ca kaw sarxalukaay ba, xoyom saraxu rendi-dóomal ba ak nebbon ba. Naka la mbooloo ma mépp gis loola, daldi sarxolle, ba noppi dëpp seen jë fa suuf. ");
INSERT INTO wolmbs_vpl VALUES ("LV10_1","004_10_1","LEV","10","1","1","Ci kaw loolu doomi Aaróona yu góor yi tudd Nadab ak Abiyu jël ku ci nekk ab andam, def cay xal, def ca cuuraay, indil ko Aji Sax ji, muy taal bu dul ndigal te santu leen ko woon. ");
INSERT INTO wolmbs_vpl VALUES ("LV10_2","004_10_2","LEV","10","2","2","Sawara ne jippét, bawoo fi Aji Sax ji, lakk leen ba ñu dee fa kanam Aji Sax ji. ");
INSERT INTO wolmbs_vpl VALUES ("LV10_3","004_10_3","LEV","10","3","3","Musaa ne Aaróona: «Lii la Aji Sax ji doon wax ba mu nee: “Ci biir ñi may jegeñ laay feeñal samag sellaay, te ci kanam mbooloo mi mépp lees may terale.”» Aaróonaa nga ne cell. ");
INSERT INTO wolmbs_vpl VALUES ("LV10_4","004_10_4","LEV","10","4","4","Ba mu ko defee Musaa woolu Misayel ak Elcafan, góor ñiy doomi Usyel, baayu Aaróona bu ndaw. Mu ne leen: «Kaayleen jële fi seen bokk yii ci kanamu xaymab ndaje bi, te ngeen génne leen dal bi.» ");
INSERT INTO wolmbs_vpl VALUES ("LV10_5","004_10_5","LEV","10","5","5","Ñu jàpp ca seeni jàllaabi, génne leen dal ba, muy la Musaa santaane woon. ");
INSERT INTO wolmbs_vpl VALUES ("LV10_6","004_10_6","LEV","10","6","6","Musaa wax Aaróona ak doomam yu góor yi tudd Elasar ak Itamar ne leen: «Buleen njañu te buleen ñaawlu di xotti seeni yére, lu ko moy dingeen dee, te sànjum Yàlla dina dal ci kaw mbooloo mi mépp. Waaye seen bokki bànni Israayil gépp sañ nañoo jooy ñi Aji Sax ji lakk. ");
INSERT INTO wolmbs_vpl VALUES ("LV10_7","004_10_7","LEV","10","7","7","Bunt xaymab ndaje mi, buleen ko wees, lu ko moy dingeen dee, ndax diwu palu Aji Sax jaa ngi ci seen kaw.» Ñu def la leen Musaa sant. ");
INSERT INTO wolmbs_vpl VALUES ("LV10_8","004_10_8","LEV","10","8","8","Aji Sax ji wax Aaróona itam ne ko: ");
INSERT INTO wolmbs_vpl VALUES ("LV10_9","004_10_9","LEV","10","9","9","«Biiñ mbaa naan guy màndal bu ko kenn ci yeen naan buy duggsi ci biir xaymab ndaje mi, du yaw, du say doom yu góor, lu ko moy dingeen dee. Dogal a ngoogu, di lu leen war fàww, yeen ak seen askan. ");
INSERT INTO wolmbs_vpl VALUES ("LV10_10","004_10_10","LEV","10","10","10","Dangeen wara mana ràññee lu sell ak lu ñu sellalul, dangeen wara ràññee itam lu set ak lu setul. ");
INSERT INTO wolmbs_vpl VALUES ("LV10_11","004_10_11","LEV","10","11","11","Nangeen jàngal bànni Israayil mboolem dogal yi leen Aji Sax ji dénk, te Musaa jottali leen ko.» ");
INSERT INTO wolmbs_vpl VALUES ("LV10_12","004_10_12","LEV","10","12","12","Ci kaw loolu Musaa wax ak Aaróona ak doomam yu góor yi des, di Elasar ak Itamar, ne leen: «Jëlleen saraxu pepp mi des ci saraxi sawara yi ñeel Aji Sax ji, ngeen lekk ko, bañ cee boole lawiir, ci wetu sarxalukaay bi, ndax lu sella sell la. ");
INSERT INTO wolmbs_vpl VALUES ("LV10_13","004_10_13","LEV","10","13","13","Lekkleen ko ci béreb bu sell. Sa cér la, yaw ak say doom yu góor, ci saraxi sawara yi ñeel Aji Sax ji. Loolu lañu ma sant. ");
INSERT INTO wolmbs_vpl VALUES ("LV10_14","004_10_14","LEV","10","14","14","Waaye dënnu saraxu yékkati-jébbale bi ak tànk bi ñu jébbal, lekkleen ko ci béreb bu mucc sobe, yaak say doom yu góor ak say doom yu jigéen, ndax seen cér la, ci saraxi canti bànni Israayil ci biir jàmm, nga moom ko yaak say doom. ");
INSERT INTO wolmbs_vpl VALUES ("LV10_15","004_10_15","LEV","10","15","15","Tànk bi ñu jébbal ak dënnu saraxu yékkati-jébbale bi, mook nebbon bi ñuy def saraxu sawara, dees koy boole indi yékkati ko, def ko sarax bu ñuy yékkati, jébbal Aji Sax ji. Yeena moom yooyu, yaak say doom, muy seen cér bu ñu leen dogalal fàww, te di la Aji Sax ji santaane woon.» ");
INSERT INTO wolmbs_vpl VALUES ("LV10_16","004_10_16","LEV","10","16","16","Gannaaw loolu Musaa laajte, ba am lu leer ci mbirum sikketu saraxas póotum bàkkaar bi, ndekete lakk nañu ko, ba mu dib dóom. Mu mere ca doomi Aaróona yu góor ya des, di Elasar ak Itamar, ne leen: ");
INSERT INTO wolmbs_vpl VALUES ("LV10_17","004_10_17","LEV","10","17","17","«Lu waral lekkuleen sarax biy póotum bàkkaar ci béreb bu sell? Lu sella sell la, ñu jox leen ko, ngeen war koo yenniku bàkkaaru mbooloo mi, ba defal leen seen njotlaay fi kanam Aji Sax ji. ");
INSERT INTO wolmbs_vpl VALUES ("LV10_18","004_10_18","LEV","10","18","18","Gannaaw dugaleesul deret ji ca biir néeg bu sell ba, waroon ngeena lekk sikket bi ci béreb bu sell, muy li ma santaane woon.» ");
INSERT INTO wolmbs_vpl VALUES ("LV10_19","004_10_19","LEV","10","19","19","Aaróona ne Musaa: «Xoolal rekk tey ni bànni Israayil indile Aji Sax ji seen saraxu póotum bàkkaar ak seen saraxu rendi-dóomal, te teewul lii dal ci sama kaw! Bu ma lekkoon tey ci yàppu saraxas póotum bàkkaar bi, ndax dina neex Aji Sax ji?» ");
INSERT INTO wolmbs_vpl VALUES ("LV10_20","004_10_20","LEV","10","20","20","Musaa dégg kàddu yooyu, rafetlu ko. ");
INSERT INTO wolmbs_vpl VALUES ("LV11_1","004_11_1","LEV","11","1","1","Aji Sax ji wax Musaa ak Aaróona ne leen: ");
INSERT INTO wolmbs_vpl VALUES ("LV11_2","004_11_2","LEV","11","2","2","«Waxleen bànni Israayil ne leen: Boroom bakkan yi ngeen di lekk seen yàpp, ci mboolem mala yiy dox ci suuf moo di yii: ");
INSERT INTO wolmbs_vpl VALUES ("LV11_3","004_11_3","LEV","11","3","3","Mboolem mala mu we wa xar, séddalikoo ñaar, te muy duññi, moom ngeen di lekk aw yàppam. ");
INSERT INTO wolmbs_vpl VALUES ("LV11_4","004_11_4","LEV","11","4","4","Yii ñuy lim, buleen ko lekk: mala muy duññi te we wi xarul, mbaa we wi xar te du duññi. Lu mel ni giléem, buleen ko lekk ndax day duññi, waaye we wi xarul. Daganul ci yeen. ");
INSERT INTO wolmbs_vpl VALUES ("LV11_5","004_11_5","LEV","11","5","5","Daman day duññi waaye we wi xarul, kon daganul ci yeen. ");
INSERT INTO wolmbs_vpl VALUES ("LV11_6","004_11_6","LEV","11","6","6","Lëg day duññi waaye we wi xarul, kon daganul ci yeen. ");
INSERT INTO wolmbs_vpl VALUES ("LV11_7","004_11_7","LEV","11","7","7","Mbaam-xuux, moom, we wi xar na waaye du duññi. Kon daganul ci yeen. ");
INSERT INTO wolmbs_vpl VALUES ("LV11_8","004_11_8","LEV","11","8","8","Aw yàppam, buleen ko lekk, te méddam buleen ko laal, ci yeen, lenn daganu ci. ");
INSERT INTO wolmbs_vpl VALUES ("LV11_9","004_11_9","LEV","11","9","9","«Lii nag, sañ ngeen koo lekk, ci mboolem lu dëkke ndox: mboolem lu ci am ciiriir aki waasintóor tey nekk ci ndoxum géej mbaa dex, sañ ngeen koo lekk. ");
INSERT INTO wolmbs_vpl VALUES ("LV11_10","004_11_10","LEV","11","10","10","Waaye mboolem luy nekk ci géej mbaa dex, di lépp luy ramm-rammi cim ndox mbaa mboolem yeneen mbindeef yuy nekk ci ndox, su amul ciiriir aki waasintóor, sibleen ko. ");
INSERT INTO wolmbs_vpl VALUES ("LV11_11","004_11_11","LEV","11","11","11","Lu ngeen seexlu lay doon, kon buleen ci lekk yàppu lenn te seexluleen méddam. ");
INSERT INTO wolmbs_vpl VALUES ("LV11_12","004_11_12","LEV","11","12","12","Mboolem luy nekk ci ndox te amul ciiriir ak waasintóor, seexluleen ko. ");
INSERT INTO wolmbs_vpl VALUES ("LV11_13","004_11_13","LEV","11","13","18","«Li ngeen wara seexlu ci njanaaw yi te deesu ko lekk moo di jaxaay ak tan, ba ca mu ñuul ma; ak céeli, bu xonq baak bu ñuul ba, bu mu mana doon, ak lépp luy baaxoñ ak lu mu xeetool, ak bànjóoli, ak mboolem xeeti looy, muy looy mu ndaw ak looy muy napp ak looy mu gudd nopp ak looyu màndiŋ, ba ci xar-jéjj ak tiiwi. Nangeen seexlu maf itam, ak kirigéej ak mboolem xeeti liccin; ");
INSERT INTO wolmbs_vpl VALUES ("LV11_19","004_11_19","LEV","11","19","19","ak yébb ak lu xeetook xodd, ak musejubru ak njugub. ");
INSERT INTO wolmbs_vpl VALUES ("LV11_20","004_11_20","LEV","11","20","20","«Mboolem gunóor guy naaw tey doxe ñeenti tànk sibleen ko. ");
INSERT INTO wolmbs_vpl VALUES ("LV11_21","004_11_21","LEV","11","21","21","Yi ngeen saña lekk daal ci mboolem gunóor guy naaw tey doxe ñeenti tànk moo di lépp lu tànk yi ànd aki yeel, mu man caa tëb-tëbe ci suuf. ");
INSERT INTO wolmbs_vpl VALUES ("LV11_22","004_11_22","LEV","11","22","22","Li ngeen mana lekk ci yooyu moo di mboolem xeetu njéeréer ak mboolem xeetu salleer ak mboolem xeetu soccet ak yeneen yu ñu xeetool yépp. ");
INSERT INTO wolmbs_vpl VALUES ("LV11_23","004_11_23","LEV","11","23","23","Waaye mboolem yeneen gunóor yuy naaw tey doxe ñeenti tànk sibleen ko. ");
INSERT INTO wolmbs_vpl VALUES ("LV11_24","004_11_24","LEV","11","24","24","«Yii nag da leen di sobeel te képp ku laal lu ci dee dina yendoo sobe ba jant so. ");
INSERT INTO wolmbs_vpl VALUES ("LV11_25","004_11_25","LEV","11","25","25","Te itam képp ku for lenn lu dee ci yii, na fóot ay yéreem, waaye dina yendoo sobe ba jant so. ");
INSERT INTO wolmbs_vpl VALUES ("LV11_26","004_11_26","LEV","11","26","26","Mboolem mala mu we wa xar te séddalikoowul ñaar mbaa du duññi daganul ci yeen, ku ci laal lenn it sobewu na. ");
INSERT INTO wolmbs_vpl VALUES ("LV11_27","004_11_27","LEV","11","27","27","Ba tey lépp luy doxe ndëgguy tànkam ci mboolem boroom ñeenti tànk, daganul ci yeen te ku laal méddam dina yendoo sobe ba jant so. ");
INSERT INTO wolmbs_vpl VALUES ("LV11_28","004_11_28","LEV","11","28","28","Ku for méddam, na fóot ay yéreem te dina yendoo sobe ba jant so. Yooyu daganul ci yeen. ");
INSERT INTO wolmbs_vpl VALUES ("LV11_29","004_11_29","LEV","11","29","29","«Bu loolu weesoo, leneen lu daganul ci yeen ci rab yu sew-sewaan yiy dox ne ñàpp ci suuf, mooy kaña ak janax ak xeeti mbëtt yépp; ");
INSERT INTO wolmbs_vpl VALUES ("LV11_30","004_11_30","LEV","11","30","30","ak unk ak bar ak sindax buy yéeg, ak sindax buy dox ci suuf, ak kàkkatar. ");
INSERT INTO wolmbs_vpl VALUES ("LV11_31","004_11_31","LEV","11","31","31","Yooyoo daganul ci yeen ci mboolem rab yu sew-sewaan yiy dox ne ñàpp ci suuf. Képp ku laal lenn lu ci dee dina yendoo sobe ba jant so. ");
INSERT INTO wolmbs_vpl VALUES ("LV11_32","004_11_32","LEV","11","32","32","Te it lu ci dee ba wadd ci kaw lenn, loola day sobewu, nay ndabal bant, mbaa ndimo, der mbaa ab saaku, mbaa jumtukaay bu mu mana doon. Nañu sóob loola ci ndox te du tee mu yendoo sobe ba jant so, mu doora set. ");
INSERT INTO wolmbs_vpl VALUES ("LV11_33","004_11_33","LEV","11","33","33","Su fekkee ne lenn a dee ci yooyu, wadd ci biir ndabal xandeer, lu woon ca biir sobewu na, te nañu toj ndab la. ");
INSERT INTO wolmbs_vpl VALUES ("LV11_34","004_11_34","LEV","11","34","34","Ndox mu jóge ci ndab loolu, bu dalee ci ñam wu dagan, ñam woowu dal nay sobewu moom itam; bu doon ag naan gu dagan moo ca nekk it, sobewu na, ak bépp ndab bu naan ga mana nekk. ");
INSERT INTO wolmbs_vpl VALUES ("LV11_35","004_11_35","LEV","11","35","35","Lépp lu lenn ci yooyu dee, ba dal ca, la mu dal sobewu na. Su dee ab puuru ban mbaa cin, dees koy toj ndax sobewu na te lu setul la ci yeen. ");
INSERT INTO wolmbs_vpl VALUES ("LV11_36","004_11_36","LEV","11","36","36","Su fekkee ne loola dee daa wadd ci biir bëtu ndox mbaa kàmb gu def ndox, du tee ndox ma laab, waaye ku laal la dee ca biir sobewu nga. ");
INSERT INTO wolmbs_vpl VALUES ("LV11_37","004_11_37","LEV","11","37","37","Su la dee waddee ci peppum jiwu, du tee peppum jiwu ma set; ");
INSERT INTO wolmbs_vpl VALUES ("LV11_38","004_11_38","LEV","11","38","38","waaye su fekkee ñu kaas pepp ma te lenn lu dee lu bokk ci yooyu dal ca, pepp ma daganul ci yeen. ");
INSERT INTO wolmbs_vpl VALUES ("LV11_39","004_11_39","LEV","11","39","39","«Su mala mu dagan méddee, ku laal médd ma dina yendoo sobe ba jant so. ");
INSERT INTO wolmbs_vpl VALUES ("LV11_40","004_11_40","LEV","11","40","40","Képp ku lekk ca médd ma, na fóot ay yéreem, te du tee mu yendoo sobe ba jant so. Képp ku for médd ma, na fóot ay yéreem te du tee mu yendoo sobe ba jant so. ");
INSERT INTO wolmbs_vpl VALUES ("LV11_41","004_11_41","LEV","11","41","41","«Mboolem mbindeef yu sew-sewaan yiy dox ne ñàpp ci suuf, sibleen ko. Deesu ko lekk. ");
INSERT INTO wolmbs_vpl VALUES ("LV11_42","004_11_42","LEV","11","42","42","Lépp luy watatu, mbaa lu sew di boroom ñeenti tànk, mbaa mu bare ay tànk ci mboolem mbindeef yu sew-sewaan yiy dox ne ñàpp ci suuf, waruleen koo lekk, ndax lu ñu wara seexlu la. ");
INSERT INTO wolmbs_vpl VALUES ("LV11_43","004_11_43","LEV","11","43","43","Bu leen tax ba ñu seexlu leen ndax lenn ci yu sew-sewaan yooyu; buleen ci taq, di ci sobeel seen bopp, ");
INSERT INTO wolmbs_vpl VALUES ("LV11_44","004_11_44","LEV","11","44","44","ndaxte man Aji Sax ji maay seen Yàlla. Kon nag doxleen ci lu sell te sell, ndax man Ku sell laa. Kon buleen sobeel mukk seen bopp ci mboolem mbindeef yu sew-sewaan yiy dox ci suuf. ");
INSERT INTO wolmbs_vpl VALUES ("LV11_45","004_11_45","LEV","11","45","45","Ndaxte kat man Aji Sax ji maay ki leen génne woon réewum Misra, di seen Yàlla. Nangeen sell boog, ndax man Ku sell laa.» ");
INSERT INTO wolmbs_vpl VALUES ("LV11_46","004_11_46","LEV","11","46","46","Loolu la yoon digle ci wàllu mala ak njanaaw ak mbindeef yi nekk ci ndox, ak mboolem mbindeef yu sew-sewaan yiy dox ne ñàpp ci suuf. ");
INSERT INTO wolmbs_vpl VALUES ("LV11_47","004_11_47","LEV","11","47","47","Dina taxa ràññaatle lu set ak lu setul. Dina taxa ràññaatle boroom bakkan yi dagana lekk ñook boroom bakkan yi daganula lekk. ");
INSERT INTO wolmbs_vpl VALUES ("LV12_1","004_12_1","LEV","12","1","1","Aji Sax ji wax na Musaa ne ko: ");
INSERT INTO wolmbs_vpl VALUES ("LV12_2","004_12_2","LEV","12","2","2","«Waxal bànni Israayil ne leen: Ku ëmb ba wasin, am doom ju góor, dina sobewu diiru juróom ñaari fan. Day sobewu ni bu tolloo ci fan yi muy gis baax. ");
INSERT INTO wolmbs_vpl VALUES ("LV12_3","004_12_3","LEV","12","3","3","Bu bés ba délsee, nañu xarafal xale bi. ");
INSERT INTO wolmbs_vpl VALUES ("LV12_4","004_12_4","LEV","12","4","4","Dina ca teg fanweeri fan ak ñett, ngir setlu ca meret ma. Ci diir booba warula laal lenn lu ñu sellal, mbaa mu dem ca xaymab ndaje ma li feek àppu setloom matul. ");
INSERT INTO wolmbs_vpl VALUES ("LV12_5","004_12_5","LEV","12","5","5","Su amee doom ju jigéen, dina sobewu diiru ñaari ayi bés, mu mel ni ku gis baax. Dina ca teg juróom benn fukki fan ak juróom benn, doora tàggook sobey meret ma. ");
INSERT INTO wolmbs_vpl VALUES ("LV12_6","004_12_6","LEV","12","6","6","«Keroog bu àppu setloom matee, bu doom ja dee góor, bu dee jigéen, na dem ca bunt xaymab ndaje ma te yóbbul sarxalkat bi am kuuy mu am at, muy saraxu rendi-dóomal, ak xati mu ndaw mbaa pitax, mu doon saraxu póotum bàkkaar. ");
INSERT INTO wolmbs_vpl VALUES ("LV12_7","004_12_7","LEV","12","7","7","Na ko sarxalkat bi sarxal fi kanam Aji Sax ji, def ko njotlaayal wasin-bees wi, mu doora tàggook sobey meret ma.» Loolu la yoon digle ci wasin-bees, mu am doom ju góor mbaa ju jigéen. ");
INSERT INTO wolmbs_vpl VALUES ("LV12_8","004_12_8","LEV","12","8","8","«Su fekkee ne wasin-bees wi amul njëgu kuuy, na indi ñaari pitax mbaa ñaari xati yu ndaw, benn bi di saraxu rendi-dóomal, bi ci des di saraxu póotum bàkkaar. Sarxalkat bi defal ko ku jigéen ki njotlaayam, mu daldi set.» ");
INSERT INTO wolmbs_vpl VALUES ("LV13_1","004_13_1","LEV","13","1","1","Aji Sax ji wax na Musaa ak Aaróona ne leen: ");
INSERT INTO wolmbs_vpl VALUES ("LV13_2","004_13_2","LEV","13","2","2","«Su nit amee ab tërgën ci yaramam mbaa ab ër, mbaa ab gàkk bu weex bu mana doon jàngoroy der juy law ci yaramam, nañu ko yóbbu ci Aaróona sarxalkat bi mbaa kenn ciy doomam yu góor yiy sarxalkat yi. ");
INSERT INTO wolmbs_vpl VALUES ("LV13_3","004_13_3","LEV","13","3","3","Na sarxalkat bi seet gàkk bi ci yaramu nit ki; su fekkee ne kawar gi ci gàkk bi dafa soppiku weex, te mu mel ni lu def pax ci der bi, jàngoroy der juy law la. Bu sarxalkat bi gisee loolu, na biral ne nit ki sobewu na. ");
INSERT INTO wolmbs_vpl VALUES ("LV13_4","004_13_4","LEV","13","4","4","Waaye su dee ab gàkk bu weex ci yaram wi te melul ni lu def pax ci der bi, taxul itam kawar gi ci nekk soppiku weex, na sarxalkat bi ber nit ki ame gàkk bi diiru juróom ñaari fan. ");
INSERT INTO wolmbs_vpl VALUES ("LV13_5","004_13_5","LEV","13","5","5","Na ko sarxalkat bi xoolaat bésub juróom ñaareel ba. Bu sarxalkat bi seetloo ne gàkk bi soppikuwul mbaa mu law ci yaramam, na ko beraat juróom ñaari fan. ");
INSERT INTO wolmbs_vpl VALUES ("LV13_6","004_13_6","LEV","13","6","6","Na ko sarxalkat bi xoolaat ca bésub juróom ñaareel ba. Su fekkee gàkk bi di raaf te lawul ci kaw deru yaram wi, na sarxalkat bi biral ne nit ki set na; ab ër doŋŋ la. Day fóot ay yéreem rekk daldi set. ");
INSERT INTO wolmbs_vpl VALUES ("LV13_7","004_13_7","LEV","13","7","7","Su fekkee ne wóor na ne ër bi law na ci deru yaramu nit ki, gannaaw ba mu ko wonee sarxalkat bi, ba mu biral ne set na, day dellu ca sarxalkat ba. ");
INSERT INTO wolmbs_vpl VALUES ("LV13_8","004_13_8","LEV","13","8","8","Su boobaa na ko sarxalkat bi xoolaat ba gis ër bi law ci deru yaram wi, mu doora biral ne nit ki sobewu na te jàngoroy der juy law la. ");
INSERT INTO wolmbs_vpl VALUES ("LV13_9","004_13_9","LEV","13","9","9","«Képp ku ame jàngoroy der juy law, nañu ko yóbbu ca sarxalkat ba. ");
INSERT INTO wolmbs_vpl VALUES ("LV13_10","004_13_10","LEV","13","10","10","Na ko sarxalkat bi seet. Su dee ab tërgën bu weex te kawar gi ci nekk soppiku weex, boole ci def góom ca biir, ");
INSERT INTO wolmbs_vpl VALUES ("LV13_11","004_13_11","LEV","13","11","11","kon jàngoroy der juy law la te xas naa law ci yaram wi. Na sarxalkat bi biral ne nit ki sobewu na. Du jar mu di ko ber ndax taq na sobe ba noppi. ");
INSERT INTO wolmbs_vpl VALUES ("LV13_12","004_13_12","LEV","13","12","12","Su fekkee ne nag jàngoro ji génn naa génn ci yaramu nit ki, sarxalkat bi gis ko fépp, li ko dale ci bopp bi ba ci tànk yi, ");
INSERT INTO wolmbs_vpl VALUES ("LV13_13","004_13_13","LEV","13","13","13","na ko sarxalkat bi seet bu baax. Bu gisee ne li génn ci yaramam daj na yaram wi yépp, na biral ne nit ki mu dal set na; gannaaw léppam a soppiku weex, set na. ");
INSERT INTO wolmbs_vpl VALUES ("LV13_14","004_13_14","LEV","13","14","14","Ba tey bés bu ay góom génnaatee ci yaram wi, nit ki sobewu na. ");
INSERT INTO wolmbs_vpl VALUES ("LV13_15","004_13_15","LEV","13","15","15","Su sarxalkat bi gisee yaramu nit ki def góom rekk, na biral ne sobewu na. Góom boobu génn ci yaram wi sobe la. Jàngoroy der juy law la. ");
INSERT INTO wolmbs_vpl VALUES ("LV13_16","004_13_16","LEV","13","16","16","Te it bu góom bi soppikoo weex, na dem ca sarxalkat ba. ");
INSERT INTO wolmbs_vpl VALUES ("LV13_17","004_13_17","LEV","13","17","17","Na ko sarxalkat bi seet, ba gis ne weexaat na, mu biral ne ki jàngoro ji dal set na te kon it set na. ");
INSERT INTO wolmbs_vpl VALUES ("LV13_18","004_13_18","LEV","13","18","18","«Su nit taabee ba wér, ");
INSERT INTO wolmbs_vpl VALUES ("LV13_19","004_13_19","LEV","13","19","19","ab tërgën bu weex mbaa gàkk bu weex bu rax xonq feeñ fa taab ba nekkoon, na dem ca sarxalkat ba. ");
INSERT INTO wolmbs_vpl VALUES ("LV13_20","004_13_20","LEV","13","20","20","Su ko sarxalkat bi seetee ba gis fa taab ba nekkoon mel ni lu def pax, te kawar gi ci nekk soppiku weex, na sarxalkat bi biral ne nit ki sobewu na. Jàngoroy der juy law la, ju juddoo ca taab ba. ");
INSERT INTO wolmbs_vpl VALUES ("LV13_21","004_13_21","LEV","13","21","21","Waaye su ko sarxalkat bi seetee te gisu ca kawar gu weex, deful pax it te raaf na, na ber nit ki juróom ñaari fan. ");
INSERT INTO wolmbs_vpl VALUES ("LV13_22","004_13_22","LEV","13","22","22","Su wéree ne jàngoro ji law na ci yaram wi, na sarxalkat bi biral ne nit ki sobewu na. Jàngoroy der juy law la. ");
INSERT INTO wolmbs_vpl VALUES ("LV13_23","004_13_23","LEV","13","23","23","Su gàkk bi yemee foofu, baña law, légétub taab ba la, te na sarxalkat bi biral ne nit ki set na. ");
INSERT INTO wolmbs_vpl VALUES ("LV13_24","004_13_24","LEV","13","24","24","«Su nit lakkee, ab gàkk bu weex mbaa bu weex te rax xonq feeñ ca kaw suux wu xonq wa lakk, ");
INSERT INTO wolmbs_vpl VALUES ("LV13_25","004_13_25","LEV","13","25","25","na ko sarxalkat bi seet. Su kawar gi ci nekk soppikoo weex te gàkk bi mel ni lu def pax, kon jàngoroy der juy law la, ju juddoo ca lakk-lakk ba. Na sarxalkat bi biral ne nit ki sobewu na, ndax jàngoroy der juy law la. ");
INSERT INTO wolmbs_vpl VALUES ("LV13_26","004_13_26","LEV","13","26","26","Waaye su ko sarxalkat bi seetee, gisul kawar gu weex ci gàkk bi, deful pax it te raaf na, na ber nit ki juróom ñaari fan. ");
INSERT INTO wolmbs_vpl VALUES ("LV13_27","004_13_27","LEV","13","27","27","Sarxalkat bi da koy seet ca bésub juróom ñaareel ba. Su wéree ne jàngoro ji law na ci yaram wi, na biral ne nit ki sobewu na. Jàngoroy der juy law la. ");
INSERT INTO wolmbs_vpl VALUES ("LV13_28","004_13_28","LEV","13","28","28","Su gàkk bi yemee foofu te lawul ci yaram wi te raaf na, ab tut la bu juddoo ca lakk-lakk ba. Na sarxalkat bi biral ne nit ki set na, ndax légétub lakk-lakk ba la. ");
INSERT INTO wolmbs_vpl VALUES ("LV13_29","004_13_29","LEV","13","29","29","«Su fekkee ne góor mbaa jigéen dafa ame jàngoro ci bopp mbaa ci sikkim, ");
INSERT INTO wolmbs_vpl VALUES ("LV13_30","004_13_30","LEV","13","30","30","na sarxalkat bi seet fi jàngoro ji nekk. Su melee ni lu def pax ci der bi, kawar gu xall te sew nekk ca, na sarxalkat bi biral ne nit ki sobewu na. Loolu wat-wataan la, di ër yuy génn ci bopp mbaa sikkim. ");
INSERT INTO wolmbs_vpl VALUES ("LV13_31","004_13_31","LEV","13","31","31","Ndegam sarxalkat bi seet na ër wi te niruwul lu def pax, amul it kawar gu ñuul ca biir, day ber nit ki ame ër wi diiru juróom ñaari fan. ");
INSERT INTO wolmbs_vpl VALUES ("LV13_32","004_13_32","LEV","13","32","32","Sarxalkat bi day seetaat ër wi ca bésub juróom ñaareel ba. Su wat-wataan ji lawul, kawar gu xall nekku ca, te melul ni lu def pax, ");
INSERT INTO wolmbs_vpl VALUES ("LV13_33","004_13_33","LEV","13","33","33","na nit ki watu waaye du wataale wat-wataan ji. Sarxalkat bi da koy beraat juróom ñaari fan. ");
INSERT INTO wolmbs_vpl VALUES ("LV13_34","004_13_34","LEV","13","34","34","Na sarxalkat bi seetaat wat-wataan ji ca bésub juróom ñaareel ba. Su wat-wataan ji lawul ci yaram wi te niruwul lu def pax, sarxalkat bi day biral ne nit ki sobewuwul. Nit ki day fóot ay yéreem daldi set. ");
INSERT INTO wolmbs_vpl VALUES ("LV13_35","004_13_35","LEV","13","35","35","Waaye su wéree ne wat-wataan ji law na ci yaram wi gannaaw ba ñu biralee ne set na, ");
INSERT INTO wolmbs_vpl VALUES ("LV13_36","004_13_36","LEV","13","36","36","na ko sarxalkat bi dellu seet ba gis ne wat-wataan ji law na ci yaram wi. Su boobaa soxlaatul mu di ca seet kawar gu xall, ndax nit ki sobewu na. ");
INSERT INTO wolmbs_vpl VALUES ("LV13_37","004_13_37","LEV","13","37","37","Waaye su seetloo ne wat-wataan ji soppikuwul te kawar gu ñuul sax ca, wat-wataan ja wér na, nit ki it set na. Na sarxalkat bi biral ne nit ki set na. ");
INSERT INTO wolmbs_vpl VALUES ("LV13_38","004_13_38","LEV","13","38","38","«Su góor mbaa jigéen amee ay gàkk-gàkk yu weex ci yaram wi, ");
INSERT INTO wolmbs_vpl VALUES ("LV13_39","004_13_39","LEV","13","39","39","sarxalkat bi seet ko, gàkk yooyu ci yaram wi di lu weex, xawa xall, xam rekk la, ju feeñ ci yaram wi waaye nit ki set na. ");
INSERT INTO wolmbs_vpl VALUES ("LV13_40","004_13_40","LEV","13","40","40","«Góor gu bopp ba amatul kawar dafa leel waaye set na. ");
INSERT INTO wolmbs_vpl VALUES ("LV13_41","004_13_41","LEV","13","41","41","Bu bopp bi ñàkkee kawar fi féeteek kanam gi, jë baa leel waaye set na. ");
INSERT INTO wolmbs_vpl VALUES ("LV13_42","004_13_42","LEV","13","42","42","Waaye su amee gàkk bu weex bu feeñ te rax xonq ci leelub ndaal bopp mbaa jë, jàngoroy der la juy màgg tey génn ci leelub ndaal bopp mbaa jë. ");
INSERT INTO wolmbs_vpl VALUES ("LV13_43","004_13_43","LEV","13","43","43","Sarxalkat bi da koy seet. Ndegam ay tërgën yu weex te rax xonq a ngi ci leelub ndaal bopp bi mbaa jë bi, mu mel ni jàngoroy der juy law ci yaram wi, ");
INSERT INTO wolmbs_vpl VALUES ("LV13_44","004_13_44","LEV","13","44","44","nit ki ànd naak jàngoro te taq na sobe. Na sarxalkat bi biral ci lu leer ne nit ki sobewu na ndax jàngoro ji ci bopp bi. ");
INSERT INTO wolmbs_vpl VALUES ("LV13_45","004_13_45","LEV","13","45","45","«Ku ànd ak jàngoroy der juy law nag yére yu xottiku lay sol te day njañu. Na muur li ko dale ci tuñum kaw mi ba ci sikkim bi, te nay jàppoo àddu ca kaw naan: “Setuma de, setuma!” ");
INSERT INTO wolmbs_vpl VALUES ("LV13_46","004_13_46","LEV","13","46","46","Fii ak jàngoro jaa ngi ci moom, day sobewu te gannaaw daa sobewu, na dëkk moom doŋŋ te na dëkkuwaayam génn dal bi. ");
INSERT INTO wolmbs_vpl VALUES ("LV13_47","004_13_47","LEV","13","47","47","«Su ndimo xuuree, teg aw liir, muy ndimol kawaru gàtt gu ñu ëcc mbaa ndimol lẽe, ");
INSERT INTO wolmbs_vpl VALUES ("LV13_48","004_13_48","LEV","13","48","48","mu tegu ci li ñu ràbbe ak lẽe walla ak kawar gu ëccu walla der bu ñu wulli walla mboolem lu ñu defare der, ");
INSERT INTO wolmbs_vpl VALUES ("LV13_49","004_13_49","LEV","13","49","49","su liir wi nëtëxee mbaa mu xonq, tege ci yére mbaa der mbaa lu ñu ràbb mbaa lu ñu defare der, liir wuy law la. Dees koy won sarxalkat bi. ");
INSERT INTO wolmbs_vpl VALUES ("LV13_50","004_13_50","LEV","13","50","50","Na sarxalkat bi nemmiku liir wi, ba noppi ber këf ki teg liir wi diiru juróom ñaari fan. ");
INSERT INTO wolmbs_vpl VALUES ("LV13_51","004_13_51","LEV","13","51","51","Bésub juróom ñaareel ba na seet liir wa. Su liir wa lawee ca kaw këf ka, muy ndimo mbaa lu ñu ràbb mbaa der mbaa jumtukaayu der, kon liir wu aaytal la te këf ka sobewu na. ");
INSERT INTO wolmbs_vpl VALUES ("LV13_52","004_13_52","LEV","13","52","52","Da koy lakk, ndax liir wu aaytal la, muy ndimo mbaa lu ñu ràbb mbaa kawaru gàtt gu ñu ëcc mbaa lẽe mbaa lu ñu defare der te liir wa tegu ca. Dees koy lakk, ba mu dib dóom. ");
INSERT INTO wolmbs_vpl VALUES ("LV13_53","004_13_53","LEV","13","53","53","Waaye kat bu sarxalkat bi seetloo ne liir wi lawul ci këf ki, muy ndimo mbaa bàgg mbaa poqe mbaa jumtukaayu der, ");
INSERT INTO wolmbs_vpl VALUES ("LV13_54","004_13_54","LEV","13","54","54","na santaane ñu fóot ko, mu daldi koy beraat juróom ñaari fan. ");
INSERT INTO wolmbs_vpl VALUES ("LV13_55","004_13_55","LEV","13","55","55","Ndegam nag gannaaw ba ñu fóotee këf ka teg liir, sarxalkat bi seet ko, te liir wi soppiwul melo, bu lawul it setul. Dees koy lakk, ba mu dib dóom, su yàqoo biir ak su yàqoo biti yépp. ");
INSERT INTO wolmbs_vpl VALUES ("LV13_56","004_13_56","LEV","13","56","56","Su sarxalkat bi gisee gannaaw ba ñu fóotee këf ka ne, liir wi raaf na, na dagg sànni fa tegoon liir ca këf ka, muy ndimo mbaa der mbaa bàgg mbaa poqe. ");
INSERT INTO wolmbs_vpl VALUES ("LV13_57","004_13_57","LEV","13","57","57","Su liir wa génnaatee ca këf ka, muy ndimo mbaa lu ñu ràbb mbaa lu ñu defare der, kon liir wuy màgg la. Këf ka teg liir dees koy lakk, ba mu dib dóom. ");
INSERT INTO wolmbs_vpl VALUES ("LV13_58","004_13_58","LEV","13","58","58","Ndegam liir wa deñ na, gannaaw ba ñu fóotee këf ka, muy ndimo mbaa lu ñu ràbb mbaa lu ñu defare der, dees koy fóotaat, mu doora set.» ");
INSERT INTO wolmbs_vpl VALUES ("LV13_59","004_13_59","LEV","13","59","59","Loolu la yoon digle ci liir wuy law wu tegu ci ndimol kawar gu ëccu mbaa ci ndimol lẽe mbaa ci yére yu ñu ràbb mbaa lu ñu defare der. Ci digle yooyu lañuy tegu, ba mana biral ne këf ka set na am setul. ");
INSERT INTO wolmbs_vpl VALUES ("LV14_1","004_14_1","LEV","14","1","1","Aji Sax ji teg na ca ne Musaa: ");
INSERT INTO wolmbs_vpl VALUES ("LV14_2","004_14_2","LEV","14","2","2","«Li yoon digle ci mbirum nit ku ame jàngoroy der juy law, keroog bés ba ñuy laabal nit ki, mooy lii: Nañu ko yegge sarxalkat bi. ");
INSERT INTO wolmbs_vpl VALUES ("LV14_3","004_14_3","LEV","14","3","3","Sarxalkat bi day génn dal bi, bu koy seet. Su nit ki demee ba jàngoroy der ji ko daloon wér, ");
INSERT INTO wolmbs_vpl VALUES ("LV14_4","004_14_4","LEV","14","4","4","sarxalkat bi day santaane, ñu indil nit kooku ñuy laabal ñaari picc yu dagan tey dund, ak bantu garabu seedar, ak wëñ gu xonq curr, ak caru garabu isob. ");
INSERT INTO wolmbs_vpl VALUES ("LV14_5","004_14_5","LEV","14","5","5","Na sarxalkat bi santaane, ñu rendi menn picc mi, tiimale ko ndabal xandeer lu def ndox mu balle ci bëtu ndox. ");
INSERT INTO wolmbs_vpl VALUES ("LV14_6","004_14_6","LEV","14","6","6","Picc miy dund da koy booleek bantu seedar bi ak wëñ gu xonq curr gi ak caru isob bi, boole lépp sóob ci deretu picc ma ñu rendi woon tiimale ko ndox mi balle ci bëtu ndox. ");
INSERT INTO wolmbs_vpl VALUES ("LV14_7","004_14_7","LEV","14","7","7","Bu loolu amee sarxalkat bi wis-wisal juróom ñaari yoon ci kaw ki ñuy laabal, ngir mu tàggook sobey jàngoro ji. Su ko defee sarxalkat bi biral ne set na. Bu noppee na bàyyi picc miy dund mu naaw ca àll ba. ");
INSERT INTO wolmbs_vpl VALUES ("LV14_8","004_14_8","LEV","14","8","8","Ku ñuy laabal day fóot ay yéreem, watu ba set te sangu, doora set. Gannaaw loolu man naa dugg ci dal bi, waaye na yem ca bunt xaymaam ca biti diiru juróom ñaari fan. ");
INSERT INTO wolmbs_vpl VALUES ("LV14_9","004_14_9","LEV","14","9","9","Bésub juróom ñaareel ba na watu ba set, bopp beek sikkim beek yeen yi ak kawar gi ci des yépp lay wat, fóot ay yéreem, sangu, daldi set. ");
INSERT INTO wolmbs_vpl VALUES ("LV14_10","004_14_10","LEV","14","10","10","Bésub juróom ñetteel ba na indi ñaari kuuy yu amul sikk, ak menn xar mu jigéen mu am at te amul sikk ak juróom ñeenti kiloy sunguf su mucc ayib su ñu xiiwe diw, muy saraxu pepp. Mu indaale genn-wàllu liitaru diw. ");
INSERT INTO wolmbs_vpl VALUES ("LV14_11","004_14_11","LEV","14","11","11","Sarxalkat biy laabal nit ki day indi nit ki, mu ànd ak loolu lépp, taxaw fi kanam Aji Sax ji, ci bunt xaymab ndaje mi. ");
INSERT INTO wolmbs_vpl VALUES ("LV14_12","004_14_12","LEV","14","12","12","«Sarxalkat bi teg ca jël menn kuuy mi, rendi ko, muy saraxu peyug tooñ, boole kook genn-wàll liitaru diw ga, def ko sarax bu ñuy yékkati, jébbal Aji Sax ji. ");
INSERT INTO wolmbs_vpl VALUES ("LV14_13","004_14_13","LEV","14","13","13","Nañu rendi kuuy mi ci béreb bu sell, fi ñuy rendee juru saraxu póotum bàkkaar ak saraxu rendi-dóomal, ndax li nekk ci saraxu peyug tooñ moo nekk ci saraxu póotum bàkkaar, sarxalkat bee ko moom; lu sella sell la. ");
INSERT INTO wolmbs_vpl VALUES ("LV14_14","004_14_14","LEV","14","14","14","Na sarxalkat bi sàkk ci deretu jur giy saraxu peyug tooñ, taqal ko ci tabanu noppu ndijooru nit ki ñuy laabal ak baaraamu déyu ndijooram ak baaraamu déyu tànku ndijooram. ");
INSERT INTO wolmbs_vpl VALUES ("LV14_15","004_14_15","LEV","14","15","15","Bu sarxalkat bi noppee, na sàkk ci genn-wàll liitaru diw gi, sotti ko ci biir loxol càmmoñu boppam. ");
INSERT INTO wolmbs_vpl VALUES ("LV14_16","004_14_16","LEV","14","16","16","Na sarxalkat bi capp baaraamu joxoñu ndijooram ci diw gi ci loxol càmmoñam, daldi wis-wisale diw gi baaraamam, ba mu mat juróom ñaari yoon fi kanam Aji Sax ji. ");
INSERT INTO wolmbs_vpl VALUES ("LV14_17","004_14_17","LEV","14","17","17","Na sarxalkat bi sàkk ci diw gi des ci loxoom, tooyal ci tabanu noppu ndijooru nit ki ñuy laabal ak baaraamu déyu ndijooram ak baaraamu déyu tànku ndijooram; nañu ko laalal ci diw gi fa ñu ko njëkkoona taqal ci deretu sarax siy peyug tooñ. ");
INSERT INTO wolmbs_vpl VALUES ("LV14_18","004_14_18","LEV","14","18","18","Li des ci diw gi ci loxol sarxalkat bi, na ko diw ci boppu nit ki ñuy laabal. Noonu la ko sarxalkat bi defale njotlaayam fi kanam Aji Sax ji. Ba loolu amee sarxalkat bi rendi sarax biy póotum bàkkaar, ");
INSERT INTO wolmbs_vpl VALUES ("LV14_19","004_14_19","LEV","14","19","19","defal ko ki ñuy laabal njotlaayam ngir mu tàggook sobeem. Te itam na sarxalkat bi rendi saraxu dóomal bi, ");
INSERT INTO wolmbs_vpl VALUES ("LV14_20","004_14_20","LEV","14","20","20","boole saraxu rendi-dóomal ak saraxu pepp mi, joxe lépp ci kaw sarxalukaay bi, defal ko nit ki njotlaayam, mu set. ");
INSERT INTO wolmbs_vpl VALUES ("LV14_21","004_14_21","LEV","14","21","21","«Su fekkee ne nit ki dafa ñàkk ba dooleem matewu ko, na wut menn kuuy, muy saraxu peyug tooñ, di saraxu yékkati-jébbale, ngir njotlaayam, boole kook ñetti kiloy sunguf su mucc ayib, xiiwe ko diw, muy saraxu pepp. Na indaale genn-wàll liitaru diw, ");
INSERT INTO wolmbs_vpl VALUES ("LV14_22","004_14_22","LEV","14","22","22","ak ñaari pitax mbaa ñaari xati yu ndaw, lu mu ci gëna jekku rekk. Menn mi saraxu póotum bàkkaar la, mi ci des di saraxu rendi-dóomal. ");
INSERT INTO wolmbs_vpl VALUES ("LV14_23","004_14_23","LEV","14","23","23","Da koy indil sarxalkat bi, ngir mu laabal ko bu bés ba délsee, ca bunt xaymab ndaje ma, fi kanam Aji Sax ji. ");
INSERT INTO wolmbs_vpl VALUES ("LV14_24","004_14_24","LEV","14","24","24","Sarxalkat bi day jël kuuyu sarax siy peyug tooñ ak genn-wàll liitaru diw gi, boole ko, muy sarax bu ñuy yékkati, jébbal Aji Sax ji. ");
INSERT INTO wolmbs_vpl VALUES ("LV14_25","004_14_25","LEV","14","25","25","Gannaaw gi, ñu rendi kuuy miy saraxu peyug tooñ, sarxalkat bi sàkk ci deret ji, taqal ci tabanu noppu ndijooru nit ki ñuy laabal ak baaraamu déyu ndijooram ak baaraamu déyu tànku ndijooram. ");
INSERT INTO wolmbs_vpl VALUES ("LV14_26","004_14_26","LEV","14","26","26","Bu sarxalkat bi noppee, na sotti tuuti ci diw gi ci loxol càmmoñu boppam. ");
INSERT INTO wolmbs_vpl VALUES ("LV14_27","004_14_27","LEV","14","27","27","Baaraamu joxoñu ndijooram lay wis-wisale diw gi ci loxol càmmoñam ba muy juróom ñaari yoon fi kanam Aji Sax ji. ");
INSERT INTO wolmbs_vpl VALUES ("LV14_28","004_14_28","LEV","14","28","28","Loolu wéy sarxalkat bi wara sàkk ci diw gi ci loxoom, tooyal ca tabanu noppu ndijooru ki ñuy laabal ak baaraamu déyu ndijooram ak baaraamu déyu tànku ndijooram; na ko def ca béreb boobu mu taaj deretu sarax siy peyug tooñ. ");
INSERT INTO wolmbs_vpl VALUES ("LV14_29","004_14_29","LEV","14","29","29","Li des ci diw gi ci loxol sarxalkat bi na ko diw ci boppu ki ñuy laabal, defal ko ko njotlaay fi kanam Aji Sax ji. ");
INSERT INTO wolmbs_vpl VALUES ("LV14_30","004_14_30","LEV","14","30","30","Bu noppee na rendi menn pitax mi mbaa menn xati mu ndaw mi, lu mu ci gëna jekku rekk, ");
INSERT INTO wolmbs_vpl VALUES ("LV14_31","004_14_31","LEV","14","31","31","menn mi di saraxas peyug tooñ, mi ci des di saraxu rendi-dóomal, te mu boole kook saraxu pepp mi. Noonu la sarxalkat biy defale ki ñuy laabal njotlaayam fi kanam Aji Sax ji.» ");
INSERT INTO wolmbs_vpl VALUES ("LV14_32","004_14_32","LEV","14","32","32","Loolu la yoon digle ci mbirum nit ku ànd ak jàngoroy der juy law te dooleem matewul sarax yi ñu koy laabale. ");
INSERT INTO wolmbs_vpl VALUES ("LV14_33","004_14_33","LEV","14","33","33","Aji Sax ji wax na Musaa ak Aaróona ne leen: ");
INSERT INTO wolmbs_vpl VALUES ("LV14_34","004_14_34","LEV","14","34","34","«Bu ngeen demee ca réewu Kanaan ga ma leen jox muy seen moomeel, bu ma tegee liir wuy law ba xuural ab néeg foofa ca seen réewum bopp, ");
INSERT INTO wolmbs_vpl VALUES ("LV14_35","004_14_35","LEV","14","35","35","boroom néeg bi dafa wara dem ca sarxalkat ba ne ko: “Lu mel ni aw liir laa gis sama néeg.” ");
INSERT INTO wolmbs_vpl VALUES ("LV14_36","004_14_36","LEV","14","36","36","Su boobaa na sarxalkat bi santaane, ñu génne lépp lu nekk ca néeg ba, bala muy dugg di seet liir wi. Su ko defee du am lenn lu nekk ca néeg ba, lu muy biral ne sobe topp na ko. Gannaaw loolu sarxalkat bi dugg, seet néeg bi. ");
INSERT INTO wolmbs_vpl VALUES ("LV14_37","004_14_37","LEV","14","37","37","Bu sarxalkat bi seetee liir wi ci miiri néeg bi ca biir, muy ay xóot-xóot yu xawa nëtëx, mbaa mu xawa xonq, mel ni lu def pax ci miir bi, ");
INSERT INTO wolmbs_vpl VALUES ("LV14_38","004_14_38","LEV","14","38","38","na génn néeg bi te tëj néeg bi diiru juróom ñaari fan. ");
INSERT INTO wolmbs_vpl VALUES ("LV14_39","004_14_39","LEV","14","39","39","Bésub juróom ñaareel ba na sarxalkat bi délsi seet néeg bi. Bu liir wi lawee ci miiri néeg bi, ");
INSERT INTO wolmbs_vpl VALUES ("LV14_40","004_14_40","LEV","14","40","40","na sarxalkat bi santaane, ñu teggi doj yi liir wi xuural, boole ko génne dëkk bi, sànni ko fu setul. ");
INSERT INTO wolmbs_vpl VALUES ("LV14_41","004_14_41","LEV","14","41","41","Na xeetlu biir néeg bi ba mu daj, te pënd ba ñu ca xeete dees koy génne dëkk ba, tuur ko fu setul. ");
INSERT INTO wolmbs_vpl VALUES ("LV14_42","004_14_42","LEV","14","42","42","Dañoo wara sàkkaat ay doj, wuutale ko doj yooyu te sàkk ban bu bees, raaxe ko néeg bi. ");
INSERT INTO wolmbs_vpl VALUES ("LV14_43","004_14_43","LEV","14","43","43","«Su liir wi delloo tegu ci biir néeg bi gannaaw bu ñu teggee doj yi, xeet biir néeg bi, ba raax ko, ");
INSERT INTO wolmbs_vpl VALUES ("LV14_44","004_14_44","LEV","14","44","44","sarxalkat bi day dikk seet ko. Su liir wi lawee ci néeg bi, liir wu aaytal la wu xuural biir néeg bi, di sobe. ");
INSERT INTO wolmbs_vpl VALUES ("LV14_45","004_14_45","LEV","14","45","45","Néeg ba dees koy daane, boole doj yaak bant yaak banu raax ba bépp, génne ko dëkk bi, tuur ko fu setul. ");
INSERT INTO wolmbs_vpl VALUES ("LV14_46","004_14_46","LEV","14","46","46","«Ku dugg biir néeg bi diiru fan yi mu tëje dina yendoo sobe ba jant so. ");
INSERT INTO wolmbs_vpl VALUES ("LV14_47","004_14_47","LEV","14","47","47","Ku tëdd ca biir néeg ba war naa fóot ay yéreem te ku fa lekke it war naa fóot ay yéreem. ");
INSERT INTO wolmbs_vpl VALUES ("LV14_48","004_14_48","LEV","14","48","48","«Su sarxalkat ba delloo ca néeg ba, seet ko, fekk liir wa lawul ca néeg ba, gannaaw ba ñu ko raaxee, na biral ne néeg bi set na, ndax kon liir wa raaf na. ");
INSERT INTO wolmbs_vpl VALUES ("LV14_49","004_14_49","LEV","14","49","49","Liy laabal néeg bi moo di mu sàkk ñaari picc ak bantu garabu seedar ak wëñ gu xonq curr ak caru isob. ");
INSERT INTO wolmbs_vpl VALUES ("LV14_50","004_14_50","LEV","14","50","50","Day rendi menn picc mi, tiimale ko ndabal xandeer mu def ndox mu balle ci bëtu ndox. ");
INSERT INTO wolmbs_vpl VALUES ("LV14_51","004_14_51","LEV","14","51","51","Bu noppee na jaxase deretu picc mi ñu rendi ak ndox mu balle ci bëtu ndox, daldi jël bantu seedar bi ak caru isob bi ak wëñ gi xonq curr ak picc miy dund, boole lépp sóob ca. Su ko defee mu wis-wisal ca juróom ñaari yoon ci néeg bi. ");
INSERT INTO wolmbs_vpl VALUES ("LV14_52","004_14_52","LEV","14","52","52","Kon li muy laabale néeg bi moo di deretu picc mi ak ndox moomu ak picc miy dund ak bantu seedar bi ak caru isob bi ak wëñ gi xonq curr. ");
INSERT INTO wolmbs_vpl VALUES ("LV14_53","004_14_53","LEV","14","53","53","Na bàyyi picc miy dund fu génn dëkk ba, mu naaw ca àll ba. Noonu lay defe njotlaayal néeg bi, mu set.» ");
INSERT INTO wolmbs_vpl VALUES ("LV14_54","004_14_54","LEV","14","54","54","Loolu la yoon digle ci lépp luy jàngoroy der juy law ak wat-wataan, ");
INSERT INTO wolmbs_vpl VALUES ("LV14_55","004_14_55","LEV","14","55","55","mbaa liir wu tegu ci ndimo mbaa ci néeg, ");
INSERT INTO wolmbs_vpl VALUES ("LV14_56","004_14_56","LEV","14","56","56","ak ci wàllu tërgën itam mbaa mu diy ër mbaa gàkk bu weex; ");
INSERT INTO wolmbs_vpl VALUES ("LV14_57","004_14_57","LEV","14","57","57","mooy tegtal biy xamle lu set ak lu setul. Loolu la yoon digle ci jàngoroy der juy law mbaa liir. ");
INSERT INTO wolmbs_vpl VALUES ("LV15_1","004_15_1","LEV","15","1","1","Aji Sax ji wax na it Musaa ak Aaróona ne leen: ");
INSERT INTO wolmbs_vpl VALUES ("LV15_2","004_15_2","LEV","15","2","2","«Waxleen ak bànni Israayil ne leen: Góor gu ànd ak jàngoro ju sabab ngóoraam di xelli mbér, kooku sobewu na. ");
INSERT INTO wolmbs_vpl VALUES ("LV15_3","004_15_3","LEV","15","3","3","Mbér mi muy xelli moo ko sobeel; su ngóora liy xelli mbér mbaa su ko mbér mi fattee, waa ji sobewu na. ");
INSERT INTO wolmbs_vpl VALUES ("LV15_4","004_15_4","LEV","15","4","4","Lal ba mu tëdd sobewu na, te lépp lu mu toog loola sobewu na. ");
INSERT INTO wolmbs_vpl VALUES ("LV15_5","004_15_5","LEV","15","5","5","Képp ku laal lalam, na fóot ay yéreem, sangu, te du tee mu yendoo sobe ba jant so. ");
INSERT INTO wolmbs_vpl VALUES ("LV15_6","004_15_6","LEV","15","6","6","Ku toog ci lenn lu boroom jàngoroy xelli toogoon, na fóot ay yéreem, sangu, te du tee mu yendoo sobe ba jant so. ");
INSERT INTO wolmbs_vpl VALUES ("LV15_7","004_15_7","LEV","15","7","7","Ku laal boroom jàngoroy xelli war naa fóot ay yéreem, sangu, te du tee mu ànd ak sobe ba jant so. ");
INSERT INTO wolmbs_vpl VALUES ("LV15_8","004_15_8","LEV","15","8","8","Su ku ànd ak jàngoroy xelli tiflee ku taqul sobe, na kooku fóot ay yéreem, sangu, te du tere mu yendoo sobe ba jant so. ");
INSERT INTO wolmbs_vpl VALUES ("LV15_9","004_15_9","LEV","15","9","9","Gépp tegu daamar gu boroom jàngoroy xelli waroon, sobewu na. ");
INSERT INTO wolmbs_vpl VALUES ("LV15_10","004_15_10","LEV","15","10","10","Ku laal lenn lu mu toogoon lu ko féete woon suuf dina yendoo sobe ba jant so, te képp ku yékkati loola na fóot ay yéreem, sangu, te du tere mu yendoo sobe ba jant so. ");
INSERT INTO wolmbs_vpl VALUES ("LV15_11","004_15_11","LEV","15","11","11","Boroom jàngoroy xelli bu raxasul ay loxoom, ku mu laal, kooku, na fóot ay yéreem, sangu, te du tere mu yendoo sobe ba jant so. ");
INSERT INTO wolmbs_vpl VALUES ("LV15_12","004_15_12","LEV","15","12","12","Ndabal xandeer lu boroom jàngoroy xelli laal, dees koo wara toj. Su dee mboolem ndabal bant, dees koy raxas. ");
INSERT INTO wolmbs_vpl VALUES ("LV15_13","004_15_13","LEV","15","13","13","«Gannaaw loolu bu boroom jàngoroy xelli ji tàggook sobey jàngoro ja, dafa wara waññ juróom ñaari fan ngir setlu, ba noppi fóot ay yéreem, sangoo ndox mu balle ci bëtu ndox, doora set. ");
INSERT INTO wolmbs_vpl VALUES ("LV15_14","004_15_14","LEV","15","14","14","Bésub juróom ñetteel ba, na wut ñaari pitax mbaa ñaari xati yu ndaw te teewi fi kanam Aji Sax ji ca bunt xaymab ndaje ma, daldi koy jox sarxalkat bi. ");
INSERT INTO wolmbs_vpl VALUES ("LV15_15","004_15_15","LEV","15","15","15","Sarxalkat bi day rendi yooyu, menn mi di saraxu póotum bàkkaar, mi ci des di saraxu rendi-dóomal. Noonu la ko sarxalkat biy defale njotlaayam fi kanam Aji Sax ji ndax jàngoroy xelleem jooju. ");
INSERT INTO wolmbs_vpl VALUES ("LV15_16","004_15_16","LEV","15","16","16","«Su góor génnee maniyu, war naa ragg yaramam wépp, te du tere mu yendoo sobe ba jant so. ");
INSERT INTO wolmbs_vpl VALUES ("LV15_17","004_15_17","LEV","15","17","17","Lépp luy yére mbaa der bu maniyu taq, dees koy fóot te du tere mu yendoo sobe ba jant so. ");
INSERT INTO wolmbs_vpl VALUES ("LV15_18","004_15_18","LEV","15","18","18","Su dee jigéen ju góor àndal, te maniyu génn, nañu sangu, te du tere ñu yendoo sobe ba jant so. ");
INSERT INTO wolmbs_vpl VALUES ("LV15_19","004_15_19","LEV","15","19","19","«Su jigéen gisee baax, sobey baaxu jigéen day ànd ak moom juróom ñaari fan te képp ku laal ku jigéen ka dina yendoo sobe ba jant so. ");
INSERT INTO wolmbs_vpl VALUES ("LV15_20","004_15_20","LEV","15","20","20","Lépp lu mu tëdd te fekk mu gis baax, loola sobewu na te lépp lu mu toog, loola sobewu na. ");
INSERT INTO wolmbs_vpl VALUES ("LV15_21","004_15_21","LEV","15","21","21","Te it képp ku laal ab lalam, war naa fóot ay yéreem, sangu, te du tere mu yendoo sobe ba jant so. ");
INSERT INTO wolmbs_vpl VALUES ("LV15_22","004_15_22","LEV","15","22","22","Képp ku laal lenn lu mu toogoon war naa fóot ay yéreem, sangu, te du tee mu yendoo sobe ba jant so. ");
INSERT INTO wolmbs_vpl VALUES ("LV15_23","004_15_23","LEV","15","23","23","Su toogoon ci lal mbaa leneen lu mu toogoon, ku laal loola dina yendoo sobe ba jant so, ");
INSERT INTO wolmbs_vpl VALUES ("LV15_24","004_15_24","LEV","15","24","24","te ku tëdde jigéen te mu sooga gis baax, kooka sobewu na diiru juróom ñaari fan, te bépp lal bu mu tëdd sobewu na. ");
INSERT INTO wolmbs_vpl VALUES ("LV15_25","004_15_25","LEV","15","25","25","«Kuy xëpp deret ay fan yu bare te du jamonoy baaxam, mbaa mu gis baax te fekk mu wees àpp bi mu ko doon gis, kooka sobewu na diiru fan yi muy xëpp. Day mel ni bu nekkee ci jamonoy baaxam. ");
INSERT INTO wolmbs_vpl VALUES ("LV15_26","004_15_26","LEV","15","26","26","Lal bu mu tëdd ci diir bi muy xëpp yépp, day mel ni lalam bu ko fekk ci jamonoy baax te lépp lu mu toog day sobewu, ni bu nekkoon ci jamonoy baaxam. ");
INSERT INTO wolmbs_vpl VALUES ("LV15_27","004_15_27","LEV","15","27","27","Ku laal lenn ci yooyu yëf, kooka sobewu na. War naa fóot ay yéreem, sangu, te du tere mu yendoo sobe ba jant so. ");
INSERT INTO wolmbs_vpl VALUES ("LV15_28","004_15_28","LEV","15","28","28","«Bu xëppee ba jeexal, dina waññ juróom ñaari fan, doora tàggook sobe sa. ");
INSERT INTO wolmbs_vpl VALUES ("LV15_29","004_15_29","LEV","15","29","29","Bésub juróom ñetteel ba na wut ñaari pitax mbaa ñaari xati yu ndaw, yóbbu ca sarxalkat ba, ca bunt xaymab ndaje ma. ");
INSERT INTO wolmbs_vpl VALUES ("LV15_30","004_15_30","LEV","15","30","30","Sarxalkat bi day rendi menn mi muy saraxu póotum bàkkaar, mi ci des doon saraxu rendi-dóomal. Su ko defee sarxalkat bi defal ko ko njotlaay fi kanam Aji Sax ji ndax sobey xëpp ja. ");
INSERT INTO wolmbs_vpl VALUES ("LV15_31","004_15_31","LEV","15","31","31","«Fexeleen ba bànni Israayil di tàggook seeni sobe, lu ko moy dinañu dee ndax seen sobe, ngir dañuy taqal sama màkkaan mi ci seen biir.» ");
INSERT INTO wolmbs_vpl VALUES ("LV15_32","004_15_32","LEV","15","32","32","Loolu la yoon digle ci mbiri góor gu ànd ak jàngoroy xelli mbaa mu génne maniyu, ba sobewu; ");
INSERT INTO wolmbs_vpl VALUES ("LV15_33","004_15_33","LEV","15","33","33","ak jigéen ju nekk ci jamonoy baaxam; ci gàttal, képp ku taq sobe suy génne ci moom, muy góor mbaa jigéen, ak itam góor gu tëdde jigéen ju sobewu. ");
INSERT INTO wolmbs_vpl VALUES ("LV16_1","004_16_1","LEV","16","1","1","Ba loolu weesoo Aji Sax ji wax naak Musaa gannaaw ba ñaari doomi Aaróona yu góor ya deewee, ba ñu taxawsee fa kanam Aji Sax ji. ");
INSERT INTO wolmbs_vpl VALUES ("LV16_2","004_16_2","LEV","16","2","2","Aji Sax ji dafa wax Musaa ne ko: «Waxal sa mag Aaróona ne ko du saa yu nekk lay àgg ci biir néeg bu sella sell ba, ci gannaaw rido bi, di janook kubeeru saraxu njotlaay gi ub gaal gi àlluway kóllëre gi dence, lu ko moy dina dee, ndax ci niir wi tiim kubeeru gaal gi laay feeñe. ");
INSERT INTO wolmbs_vpl VALUES ("LV16_3","004_16_3","LEV","16","3","3","«Ni Aaróona di dugge ci biir néeg bu sella sell bi nii la: Day indaale aw yëkk wu ndaw ngir ab saraxu póotum bàkkaar, akum kuuy ngir ab saraxu rendi-dóomal. ");
INSERT INTO wolmbs_vpl VALUES ("LV16_4","004_16_4","LEV","16","4","4","Mbubb mu sell lay sol, mu ñu ràbbe lẽe, ak tubéyi njiitlaay ju ñu ràbbe lẽe itam. Na takkoo laxasaay gu ñu ràbbe lẽe, te kaalag lẽe lay takk. Yére yu sell a ngoogu; kon nag na sangu bala mu koy sol. ");
INSERT INTO wolmbs_vpl VALUES ("LV16_5","004_16_5","LEV","16","5","5","Na jële ci mbooloom bànni Israayil ñaari sikket, sikket yuy doon saraxu póotum bàkkaar, ak menn kuuyum rendi-dóomal. ");
INSERT INTO wolmbs_vpl VALUES ("LV16_6","004_16_6","LEV","16","6","6","«Aaróona day sarxal yëkk wi, muy saraxu póotum bàkkaaram, di njotlaayal boppam, mook waa këram. ");
INSERT INTO wolmbs_vpl VALUES ("LV16_7","004_16_7","LEV","16","7","7","Gannaaw loolu na Aaróona indi ñaari sikket yi, taxawal leen fi kanam Aji Sax ji, ci bunt xaymab ndaje mi. ");
INSERT INTO wolmbs_vpl VALUES ("LV16_8","004_16_8","LEV","16","8","8","Na Aaróona tegal ñaari sikket yi bant, ngir xam bu ñuy rendil Aji Sax ji ak bu ñu jagleel Asasel. ");
INSERT INTO wolmbs_vpl VALUES ("LV16_9","004_16_9","LEV","16","9","9","Su ko defee Aaróona indi sikketu tànnéef bi, ñu sarxalal ko Aji Sax ji, rendi ko, muy saraxu póotum bàkkaar. ");
INSERT INTO wolmbs_vpl VALUES ("LV16_10","004_16_10","LEV","16","10","10","Waaye sikket bi ñu jagleel Asasel, dees koy taxawal muy dund fi kanam Aji Sax ji, te ñu def ko njotlaayu bàkkaar, di ko dàq mu dem ca màndiŋ ma, ca Asasel. ");
INSERT INTO wolmbs_vpl VALUES ("LV16_11","004_16_11","LEV","16","11","11","«Bu Aaróona noppee, na indi yëkku saraxas póotum bàkkaaram, def ko njotlaayam mook waa këram. Na rendi yëkku saraxas póotum bàkkaaram, ");
INSERT INTO wolmbs_vpl VALUES ("LV16_12","004_16_12","LEV","16","12","12","te na sàkk andu xal bu fees, tibbe ko ca sarxalukaay ba, fi kanam Aji Sax ji, ak ñaari barci-loxoy cuuraay lu mokk te xeeñ, boole ko yóbbu ca gannaaw rido ba. ");
INSERT INTO wolmbs_vpl VALUES ("LV16_13","004_16_13","LEV","16","13","13","Na def cuuraay li ci taal bi, foofa ca kanam Aji Sax ji, saxaaru cuuraay si di làq kubeeru saraxu njotlaay gi ub gaalu àlluway seede si, ndax mu baña dee. ");
INSERT INTO wolmbs_vpl VALUES ("LV16_14","004_16_14","LEV","16","14","14","Na sàkk ci deretu yëkk wi, wis-wisale ko baaraamam ci kaw kubeeru gaal gi, ci wetam gi féete penku, te it na wis-wisale baaraamam deret ji lu mat juróom ñaari yoon ci kanam kubeeru gaal gi. ");
INSERT INTO wolmbs_vpl VALUES ("LV16_15","004_16_15","LEV","16","15","15","Bu noppee na rendi sikket biy saraxas póotum bàkkaaru mbooloo mi, te yóbbu deret ji ca gannaaw rido ba. Na def deret ji na mu defoon ak deretu yëkk wa, wis-wisal ko ca kaw kubeeru gaal gi ak ci kanam kubeer gi. ");
INSERT INTO wolmbs_vpl VALUES ("LV16_16","004_16_16","LEV","16","16","16","Mu daldi matale loolu njotlaayal néeg bu sella sell bi, tàggale kook sobey bànni Israayil ak seeni tooñ, ak lu seen bàkkaar mana doon. Noonu lay defal mboolem xaymab ndaje mi dëkk ci seen biir ci seen biiri sobe. ");
INSERT INTO wolmbs_vpl VALUES ("LV16_17","004_16_17","LEV","16","17","17","Du kenn ku saña nekk ci biir xaymab ndaje mi, bu Aaróona duggee ci biir néeg bu sella sell bi, di matal ag njotlaay, ba keroog muy génn, gannaaw bu jotoo moom ci boppam, mook waa këram, ba jotaale mbooloom bànni Israayil mépp. ");
INSERT INTO wolmbs_vpl VALUES ("LV16_18","004_16_18","LEV","16","18","18","«Bu sottalee, na génn jëm ca sarxalukaay ba ca kanam Aji Sax ji, ba noppi defal sarxalukaay bi njotlaayal boppam. Day sàkk ci deretu yëkk wi ak ju sikket bi, taqal béjjéni sarxalukaay bi yépp. ");
INSERT INTO wolmbs_vpl VALUES ("LV16_19","004_16_19","LEV","16","19","19","Te itam day wis-wisale baaraamam deret ji lu mat juróom ñaari yoon ci kaw sarxalukaay bi, setal ko, sellal ko, mu tàggook sobey bànni Israayil. ");
INSERT INTO wolmbs_vpl VALUES ("LV16_20","004_16_20","LEV","16","20","20","«Bu Aaróona matalee njotlaayal néeg bu sella sell ba ak xaymab ndaje ma ak sarxalukaay ba, na indi sikket biy dund. ");
INSERT INTO wolmbs_vpl VALUES ("LV16_21","004_16_21","LEV","16","21","21","Aaróona day teg ay loxoom ci kaw boppu sikket biy dund te tudd ci kawam mboolem ñaawtéefi bànni Israayil ak seeni tooñ, ak seeni bàkkaar yépp, boole ko yen sikket bi, teg ko ci loxol nit ku ñu yónni, mu dàq ko ca màndiŋ ma. ");
INSERT INTO wolmbs_vpl VALUES ("LV16_22","004_16_22","LEV","16","22","22","Sikket bi day yenu seeni ñaawtéef yépp, yóbbaale ca ndànd-foyfoy ga, ñu wacc ko ca màndiŋ ma. ");
INSERT INTO wolmbs_vpl VALUES ("LV16_23","004_16_23","LEV","16","23","23","«Na Aaróona dellu ca xaymab ndaje ma, summi yére ya ñu ràbbe lẽe, di ya mu soloon bala moo dugg ca néeg bu sella sell ba, te na fa wacc yére ya. ");
INSERT INTO wolmbs_vpl VALUES ("LV16_24","004_16_24","LEV","16","24","24","Bu loolu weesoo mu sangoo fu sell, sol yérey boppam, génn, joxeel boppam ab saraxu rendi-dóomal, joxeel mbooloo mi seen saraxu rendi-dóomal, ngir njotlaayal boppam ak njotlaayal mbooloo mi. ");
INSERT INTO wolmbs_vpl VALUES ("LV16_25","004_16_25","LEV","16","25","25","Nebbonu jur giy saraxu póotum bàkkaar, na ko lakk ci kaw sarxalukaay bi. ");
INSERT INTO wolmbs_vpl VALUES ("LV16_26","004_16_26","LEV","16","26","26","«Ka wacci woon sikketu Asasel, na fóot ay yéreem, sangu, doora mana duggaat ci dal bi. ");
INSERT INTO wolmbs_vpl VALUES ("LV16_27","004_16_27","LEV","16","27","27","Muy yëkk wiy saraxu póotum bàkkaar, muy sikket biy saraxu póotum bàkkaar te ñu yóbbu woon seen deret ca biir néeg bu sella sell bi ngir defe ko njotlaay, lépp lañuy génne dal bi. Der yaak yàpp waak sébbriit ma, dees koy boole lakk, ba mu dib dóom. ");
INSERT INTO wolmbs_vpl VALUES ("LV16_28","004_16_28","LEV","16","28","28","Ki ko lakk bu noppee, na fóot ay yéreem, sangu, doora mana duggaat ci dal bi. ");
INSERT INTO wolmbs_vpl VALUES ("LV16_29","004_16_29","LEV","16","29","29","«Te itam dogal a ngii, di lu leen war fàww. Bésub fukki fan ci juróom ñaareelu weeru at mi, nangeen ci toroxlu te du lenn lu ngeen ci mana liggéey, du njuddu-ji-réew, du doxandéem bi ci seen biir; ");
INSERT INTO wolmbs_vpl VALUES ("LV16_30","004_16_30","LEV","16","30","30","ndaxte ci bés boobu lañu leen di joxeel njotlaay ngir fóot seen mboolem bàkkaar, ba ngeen set fi kanam Aji Sax ji. ");
INSERT INTO wolmbs_vpl VALUES ("LV16_31","004_16_31","LEV","16","31","31","Na doon seen bés bu ngeen di noppalu doŋŋ, ngeen war cee toroxlu. Dogal la bu sax dàkk. ");
INSERT INTO wolmbs_vpl VALUES ("LV16_32","004_16_32","LEV","16","32","32","«Sarxalkat bi ñu diw, fal ko nag, solal ko, jox ko sañ-sañu sarxalkat bu mag, mu wuutu baayam, na def saraxu njotlaay gi. Na sol yére yu sell yooyu di yi ñu ràbbe lẽe, ");
INSERT INTO wolmbs_vpl VALUES ("LV16_33","004_16_33","LEV","16","33","33","te it na def njotlaayal néeg bu sella sell bi ak xaymab ndaje mi ak sarxalukaay bi, boole ci defal sarxalkat yi seen njotlaay, ñook mbooloom Israayil mépp. ");
INSERT INTO wolmbs_vpl VALUES ("LV16_34","004_16_34","LEV","16","34","34","«Dogal a ngoogu, di lu leen war fàww, te mooy ñuy joxeel bànni Israayil njotlaay benn yoon cim at ngir seen bàkkaar yépp.» Ñu daldi def li Aji Sax ji santoon Musaa. ");
INSERT INTO wolmbs_vpl VALUES ("LV17_1","004_17_1","LEV","17","1","1","Aji Sax ji wax na Musaa ne ko: ");
INSERT INTO wolmbs_vpl VALUES ("LV17_2","004_17_2","LEV","17","2","2","«Waxal Aaróona aki doomam yu góor ak bànni Israayil gépp ne leen li Aji Sax ji santaane mooy lii: ");
INSERT INTO wolmbs_vpl VALUES ("LV17_3","004_17_3","LEV","17","3","3","Képp kuy góor ci waa kër Israayil, bu rendee aw nag mbaa xar mbaa bëy ci biir dal bi, ak fu génn dal bi, ");
INSERT INTO wolmbs_vpl VALUES ("LV17_4","004_17_4","LEV","17","4","4","te indiwu ko ci bunt xaymab ndaje mi, teewalal ko Aji Sax ji, muy sarax ca buntu jaamookaayu Aji Sax ji, kooku dees na ko topp àqu deret. Dafa tuur deret. Kon dees koy dagge ci biir bànni Israayil. ");
INSERT INTO wolmbs_vpl VALUES ("LV17_5","004_17_5","LEV","17","5","5","Su ko defee bànni Israayil dinañu indil Aji Sax ji juri sarax yi ñuy rendi ci àll bi. Dañu koo wara yóbbu ca sarxalkat ba, fi Aji Sax ji, ca bunt xaymab ndaje ma, defal ko Aji Sax ji saraxi cant ci biir jàmm. ");
INSERT INTO wolmbs_vpl VALUES ("LV17_6","004_17_6","LEV","17","6","6","Sarxalkat bi day xëpp deret ji ci sarxalukaayu Aji Sax ji, ci bunt xaymab ndaje mi, ba noppi, lakkal Aji Sax ji nebbon bi, muy xeeñ xetug jàmm gu neex Aji Sax ji. ");
INSERT INTO wolmbs_vpl VALUES ("LV17_7","004_17_7","LEV","17","7","7","Buñu di sarxalatil tuur, yi ñuy jëmmale sikket, di ko bokkaalee. Na loolu di dogal bu leen war fàww, ñoom ak seen askan. ");
INSERT INTO wolmbs_vpl VALUES ("LV17_8","004_17_8","LEV","17","8","8","Wax leen boog ne leen: Képp kuy góor, ku bokk ci waa kër Israayil, mbaa mu bokk ci doxandéem yi ci seen biir, buy génne ab saraxu rendi-dóomal mbaa beneen sarax, ");
INSERT INTO wolmbs_vpl VALUES ("LV17_9","004_17_9","LEV","17","9","9","te indiwu ko ci bunt xaymab ndaje mi, sarxalal ko Aji Sax ji, kooku dees koo wara dagge ci biir bànni Israayil. ");
INSERT INTO wolmbs_vpl VALUES ("LV17_10","004_17_10","LEV","17","10","10","«Te it képp ku bokk ci waa kër Israayil mbaa doxandéem yi ci seen biir, bu lekkee lenn luy deret, kooku lekk deret, man Aji Sax ji, dinaa ko noonoo te dinaa ko dagge ci biir bànni Israayil. ");
INSERT INTO wolmbs_vpl VALUES ("LV17_11","004_17_11","LEV","17","11","11","Ndaxte dundu mbindeef ci deret la nekk, te man maa leen sédde deret, ngeen di ko jotoo seen bakkan ci kaw sarxalukaay bi. Ndax kat bakkanu mbindeef deretam la taxawe. Moo tax deret mana defal nit njotlaayam. ");
INSERT INTO wolmbs_vpl VALUES ("LV17_12","004_17_12","LEV","17","12","12","Looloo waral ma ne bànni Israayil, bu kenn ci ñoom lekk deret, te doxandéem bi ci seen biir it bumu lekk deret. ");
INSERT INTO wolmbs_vpl VALUES ("LV17_13","004_17_13","LEV","17","13","13","«Képp ku bokk ci bànni Israayil mbaa ci doxandéem yi ci seen biir, bu rëbbee ba jàpp mala mbaa njanaaw, mu di lu dagana lekk, na tuur deret ji, suul, ");
INSERT INTO wolmbs_vpl VALUES ("LV17_14","004_17_14","LEV","17","14","14","ndax deret dafay jëmmal bépp dundu mbindeef bu Yàlla sàkk. Moo waral, man Aji Sax ji, ma ne bànni Israayil buñu lekk deretu menn mbindeef ngir dundu mboolem mbindeef mooy deretam. Képp ku lekk deret, dees koy dagge ci askan wi. ");
INSERT INTO wolmbs_vpl VALUES ("LV17_15","004_17_15","LEV","17","15","15","«Te itam képp ku lekk médd mbaa lu rab fàdd, muy njuddu-ji-réew mbaa doxandéem, na fóot ay yéreem, sangu, te du tere mu yendoo sobe ba jant so, mu doora set. ");
INSERT INTO wolmbs_vpl VALUES ("LV17_16","004_17_16","LEV","17","16","16","Waaye su fóotul, sanguwul, mooy gàddu bàkkaaram.» ");
INSERT INTO wolmbs_vpl VALUES ("LV18_1","004_18_1","LEV","18","1","1","Aji Sax ji wax na Musaa ba tey ne ko: ");
INSERT INTO wolmbs_vpl VALUES ("LV18_2","004_18_2","LEV","18","2","2","«Waxal bànni Israayil ne leen: Man Aji Sax ji maay seen Yàlla. ");
INSERT INTO wolmbs_vpl VALUES ("LV18_3","004_18_3","LEV","18","3","3","Defini waa réewam Misra ga ngeen dëkkoon, buleen ko roy, te defini waa réewu Kanaan ga ma leen jëme, buleen ko roy te it buleen leen topp ci seeni aada. ");
INSERT INTO wolmbs_vpl VALUES ("LV18_4","004_18_4","LEV","18","4","4","Samay santaane ngeen wara dégg tey topp samay dogal. Man Aji Sax ji maay seen Yàlla. ");
INSERT INTO wolmbs_vpl VALUES ("LV18_5","004_18_5","LEV","18","5","5","Nangeen sàmm samay dogal ak samay santaane, ndax ngeen jëfe yooyu moo leen di taxa dund. Man maay Aji Sax ji. ");
INSERT INTO wolmbs_vpl VALUES ("LV18_6","004_18_6","LEV","18","6","6","«Bu kenn ci yeen tëdde ku mu jegewool lool cig bokk. Maay Aji Sax ji. ");
INSERT INTO wolmbs_vpl VALUES ("LV18_7","004_18_7","LEV","18","7","7","Bul toroxal sa baay, di tëdde sa yaay. Sa yaay la, kon bu ko toroxal moom it. ");
INSERT INTO wolmbs_vpl VALUES ("LV18_8","004_18_8","LEV","18","8","8","«Bul tëdde sa soxnas baay, di toroxal sa baay. ");
INSERT INTO wolmbs_vpl VALUES ("LV18_9","004_18_9","LEV","18","9","9","«Bul tëdde sab jigéen, te muy koo bokkal benn baay mbaa koo bokkal jenn ndey, muy ku juddoo ci kër gi mbaa feneen. ");
INSERT INTO wolmbs_vpl VALUES ("LV18_10","004_18_10","LEV","18","10","10","«Bul tëdde sab sët bu jigéen bu sa doom ju góor jur mbaa sa doom ju jigéen, ndax kon toroxal nga sa bopp. ");
INSERT INTO wolmbs_vpl VALUES ("LV18_11","004_18_11","LEV","18","11","11","«Bul tëdde ku sa soxnas baay am ak sa baay, ndax sab jigéen la. ");
INSERT INTO wolmbs_vpl VALUES ("LV18_12","004_18_12","LEV","18","12","12","«Bul tëdde sa bàjjan, ndax daa jegewook sa baay lool cig bokk. ");
INSERT INTO wolmbs_vpl VALUES ("LV18_13","004_18_13","LEV","18","13","13","«Bul tëdde sa ndey ju ndaw, ndax daa jegewook sa yaay lool cig bokk. ");
INSERT INTO wolmbs_vpl VALUES ("LV18_14","004_18_14","LEV","18","14","14","«Bul toroxal sa baay bu ndaw di tëdde soxnaam. Sa ndey la. ");
INSERT INTO wolmbs_vpl VALUES ("LV18_15","004_18_15","LEV","18","15","15","«Bul tëdde sa soxnas doom. Sa soxnas doom la. Bu ko tëdde mukk. ");
INSERT INTO wolmbs_vpl VALUES ("LV18_16","004_18_16","LEV","18","16","16","«Bul tëdde soxnas koo bokkal benn baay mbaa jenn ndey, ndax kon nga toroxal sa doomu baay mbaa sa doomu ndey. ");
INSERT INTO wolmbs_vpl VALUES ("LV18_17","004_18_17","LEV","18","17","17","«Bul boole tëdde jigéen, tëdde doom ja mbaa sëtam bu doomam ju góor jur mbaa doomam ju jigéen jur ko, ndax dañoo jegewoo lool cig bokk. Loolu ñaawtéef la. ");
INSERT INTO wolmbs_vpl VALUES ("LV18_18","004_18_18","LEV","18","18","18","«Bul jël jigéen di séq ak moom séy, muy wujjeek doomu ndeyam mbaa doomu baayam joo njëkka jël, li feek kookoo ngi dund. ");
INSERT INTO wolmbs_vpl VALUES ("LV18_19","004_18_19","LEV","18","19","19","«Bul tëdde jigéen ju gis baax, ndax daa sobewu. ");
INSERT INTO wolmbs_vpl VALUES ("LV18_20","004_18_20","LEV","18","20","20","«Bul ànd ak jabaru jàmbur, di sobeel sa bopp. ");
INSERT INTO wolmbs_vpl VALUES ("LV18_21","004_18_21","LEV","18","21","21","«Bul jébbal kenn ci say doom tuur mi ñuy wax Moleg, ndax waruloo teddadil sa turu Yàlla. Man maay Aji Sax ji. ");
INSERT INTO wolmbs_vpl VALUES ("LV18_22","004_18_22","LEV","18","22","22","«Bu góor tëdde góor, ni bu doon jigéen. Lu ñaawa ñaaw la. ");
INSERT INTO wolmbs_vpl VALUES ("LV18_23","004_18_23","LEV","18","23","23","«Bu góor tëdde menn mala, di sobeel boppam, te bu jigéen jox boppam mala, di ànd ak moom. Loolu yàqute la. ");
INSERT INTO wolmbs_vpl VALUES ("LV18_24","004_18_24","LEV","18","24","24","«Buleen sobeel seen bopp ci mboolem defin yooyu, ndax xeet yi ma leen dàqal, noonu lañu daan jëfe, ba sobeel seen bopp. ");
INSERT INTO wolmbs_vpl VALUES ("LV18_25","004_18_25","LEV","18","25","25","Réew ma sax mujj na daj ak sobe, ma wàcce mbugal ca kaw réew ma, ba mu gëq ay nitam. ");
INSERT INTO wolmbs_vpl VALUES ("LV18_26","004_18_26","LEV","18","26","26","«Yeen nag sàmmleen samay dogal ak samay santaane te bu kenn def lenn ci yooyu ñaawtéef, du njuddu-ji-réew, du doxandéem bi ci seen biir, ");
INSERT INTO wolmbs_vpl VALUES ("LV18_27","004_18_27","LEV","18","27","27","ndax kat mboolem ñaawtéef yooyu la waa réew ma leen fa jiitu daan def, ba réew ma mujj daj ak sobe. ");
INSERT INTO wolmbs_vpl VALUES ("LV18_28","004_18_28","LEV","18","28","28","Su ngeen sobeelee réew ma, dinaa leen gëq, na ma gëqe woon xeet ya leen fa jiitu woon. ");
INSERT INTO wolmbs_vpl VALUES ("LV18_29","004_18_29","LEV","18","29","29","Képp ku def lenn ci yooyu ñaawtéef déy, kooku dees koy dagge ci biir bànni Israayil. ");
INSERT INTO wolmbs_vpl VALUES ("LV18_30","004_18_30","LEV","18","30","30","Sàmmleen sama ndénkaane ngir baña roy lenn ci aada yu ñaaw yi ñu fi doon topp lu leen jiitu, te buleen sobeel seen bopp ci yooyu. Man Aji Sax ji maay seen Yàlla.» ");
INSERT INTO wolmbs_vpl VALUES ("LV19_1","004_19_1","LEV","19","1","1","Aji Sax ji wax na Musaa ne ko: ");
INSERT INTO wolmbs_vpl VALUES ("LV19_2","004_19_2","LEV","19","2","2","«Waxal mbooloom bànni Israayil gépp ne leen: Ñu sell ngeen wara doon, ndax Ku sell laa, man seen Yàlla Aji Sax ji. ");
INSERT INTO wolmbs_vpl VALUES ("LV19_3","004_19_3","LEV","19","3","3","«Na ku nekk weg ndeyam ak baayam te wormaal sama bési Noflaay. Man Aji Sax ji, maay seen Yàlla. ");
INSERT INTO wolmbs_vpl VALUES ("LV19_4","004_19_4","LEV","19","4","4","«Buleen walbatiku di jaamu ay yàllantu mbaa ngeen di sàkkal seen bopp ay tuur yu ñu móole weñ. Man Aji Sax ji maay seen Yàlla. ");
INSERT INTO wolmbs_vpl VALUES ("LV19_5","004_19_5","LEV","19","5","5","«Bu ngeen dee rendil Aji Sax ji saraxas cant ci biir jàmm, sarxalleen ko ni mu ware, ndax ñu nangul leen. ");
INSERT INTO wolmbs_vpl VALUES ("LV19_6","004_19_6","LEV","19","6","6","Ca bés ba ñu ko sarxale lees koy lekk, mbaa ca ëllëg sa; lu ca des ba ca gannaaw ëllëg sa dees koy lakk, ba mu dib dóom. ");
INSERT INTO wolmbs_vpl VALUES ("LV19_7","004_19_7","LEV","19","7","7","Bu ñu ci lekkee déy te fekk mu am ñetti fan, day doon lu ñu seexlu, te deesu ko nangu. ");
INSERT INTO wolmbs_vpl VALUES ("LV19_8","004_19_8","LEV","19","8","8","Ku ci lekk mooy gàddu bàkkaar bi, ndaxte lu ñu sellalal Aji Sax ji la teddadil, te kooku dees koy dagge ci biir bànni Israayil. ");
INSERT INTO wolmbs_vpl VALUES ("LV19_9","004_19_9","LEV","19","9","9","«Bu ngeen dee góob seen tool, buleen góob ba fa tool ba yem te buleen ca toppaat, di foraatu. ");
INSERT INTO wolmbs_vpl VALUES ("LV19_10","004_19_10","LEV","19","10","10","Seen tóokëri reseñ it buleen ko witt ñaari yoon te buleen foraatu doom yu wadde ca witt ma. Aji ñàkk akub doxandéem ngeen koy bàyyee. Maay seen Yàlla, man Aji Sax ji. ");
INSERT INTO wolmbs_vpl VALUES ("LV19_11","004_19_11","LEV","19","11","11","«Buleen sàcc, buleen fen te buleen di worante. ");
INSERT INTO wolmbs_vpl VALUES ("LV19_12","004_19_12","LEV","19","12","12","«Buleen giñe sama tur lu dul dëgg, di teddadil seen turu Yàlla. Maay Aji Sax ji. ");
INSERT INTO wolmbs_vpl VALUES ("LV19_13","004_19_13","LEV","19","13","13","«Buleen lekk seen àqu moroom, buleen sàcc. Buleen wacc peyu liggéeykat, muy fanaan ci seeni loxo. ");
INSERT INTO wolmbs_vpl VALUES ("LV19_14","004_19_14","LEV","19","14","14","«Buleen saaga ab tëx te buleen fakkastal silmaxa. Ragalleen seen Yàlla. Maay Aji Sax ji. ");
INSERT INTO wolmbs_vpl VALUES ("LV19_15","004_19_15","LEV","19","15","15","«Buleen safaan dëgg cib àtte. Buleen far néew-ji-doole te buleen far boroom doole. Àtteleen seen moroom ci dëgg. ");
INSERT INTO wolmbs_vpl VALUES ("LV19_16","004_19_16","LEV","19","16","16","Buleen wër di yàq deru nit ci seen bokki waa réew. Buleen def dara lu mana reylu seen moroom. Maay Aji Sax ji. ");
INSERT INTO wolmbs_vpl VALUES ("LV19_17","004_19_17","LEV","19","17","17","«Buleen tong seen mbokk, te artuleen seen moroom bu baax bala ngeena bokk ak moom gàddu bàkkaar. ");
INSERT INTO wolmbs_vpl VALUES ("LV19_18","004_19_18","LEV","19","18","18","Buleen di feyantook seen mbokkum waa réew te buleen ko dencal mer. Ni ngeen soppe seen bopp nag, nangeen ko soppe seen moroom. Maay Aji Sax ji. ");
INSERT INTO wolmbs_vpl VALUES ("LV19_19","004_19_19","LEV","19","19","19","«Te it sama dogali yoon yii nangeen ko sàmm: Buleen boole ñaar yu bokkul wirgo ci seenug jur, ñuy jaxasoo; seen tool it buleen ci ji ñaari wirgoy jiwu te buleen sol yére yu ñu ràbbe ñaari xeeti wëñ yu bokkul. ");
INSERT INTO wolmbs_vpl VALUES ("LV19_20","004_19_20","LEV","19","20","20","«Ku tëdde ab jaam bu wara séy ak keneen te fekk joteesu ko, goreeleesu ko, ndàmpaay war na ca, waaye deesu leen boole rey, ndax li ndaw si dib jaam ba tey. ");
INSERT INTO wolmbs_vpl VALUES ("LV19_21","004_19_21","LEV","19","21","21","Waa ji day yóbbu am kuuyu peyug tooñ ca bunt xaymab ndaje ma, muy peyug tooñ gi muy sarxalal Aji Sax ji. ");
INSERT INTO wolmbs_vpl VALUES ("LV19_22","004_19_22","LEV","19","22","22","Na ko sarxalkat bi defal kuuy miy saraxas peyug tooñ muy njotlaayam fi kanam Aji Sax ji, ndax bàkkaar bi mu def. Kon dees na ko jéggal bàkkaar bi mu def. ");
INSERT INTO wolmbs_vpl VALUES ("LV19_23","004_19_23","LEV","19","23","23","«Bu ngeen duggee ca réew ma, ba jëmbat fa mboolem xeetu garab guy meññ ay doom, nangeen aayal doom ya. Diiru ñetti at ngeen di aayal doom ya. Dungeen ko lekk ci diir boobu. ");
INSERT INTO wolmbs_vpl VALUES ("LV19_24","004_19_24","LEV","19","24","24","Atum ñeenteel ba doom ya yépp lañuy sellalal Aji Sax ji, te di ko bége ci biir cant. ");
INSERT INTO wolmbs_vpl VALUES ("LV19_25","004_19_25","LEV","19","25","25","Juróomeelu at ma doŋŋ ngeen di saña lekk doom ya. Su ko defee meññeef ma barkeelal leen. Man Aji Sax ji maay seen Yàlla. ");
INSERT INTO wolmbs_vpl VALUES ("LV19_26","004_19_26","LEV","19","26","26","«Buleen lekk lu am deret. Buleen di gisaane mbaa ngeen di jabar. ");
INSERT INTO wolmbs_vpl VALUES ("LV19_27","004_19_27","LEV","19","27","27","Buleen wat seen peggu kawaru bopp te buleen dagg seen peggu sikkim, ");
INSERT INTO wolmbs_vpl VALUES ("LV19_28","004_19_28","LEV","19","28","28","mbaa ngeen di dagg seen yaram, di ko mititloo ku dee, te buleen ñaasu fenn ci seen yaram. Maay Aji Sax ji. ");
INSERT INTO wolmbs_vpl VALUES ("LV19_29","004_19_29","LEV","19","29","29","«Buleen toroxal seen doom ju jigéen, di ko def ab gànc; lu ko moy réew mi sóobu ci gànctu ba ne lijj ci ñaawtéef. ");
INSERT INTO wolmbs_vpl VALUES ("LV19_30","004_19_30","LEV","19","30","30","«Samay bési Noflaay nag wormaalleen ko te sama béreb bu sell teralleen ko. Maay Aji Sax ji. ");
INSERT INTO wolmbs_vpl VALUES ("LV19_31","004_19_31","LEV","19","31","31","«Buleen jublu ci ñiy gisaane nit ñu dee te buleen jublu ci boroom rawaan yiy seet, ndax kon ñu sobeel leen. Man maay seen Yàlla Aji Sax ji. ");
INSERT INTO wolmbs_vpl VALUES ("LV19_32","004_19_32","LEV","19","32","32","«Bu boroom bijjaaw teewee, jógleen wormaal ko. Deeleen rus mag te ragalleen seen Yàlla. Maay Aji Sax ji. ");
INSERT INTO wolmbs_vpl VALUES ("LV19_33","004_19_33","LEV","19","33","33","«Bu ab doxandéem daleek yeen ci seenum réew, buleen ko lor. ");
INSERT INTO wolmbs_vpl VALUES ("LV19_34","004_19_34","LEV","19","34","34","Njuddu-ji-réew ji nangeen ko yemaleek doxandéem bi ngeen dëkkal. Soppleen ko ni ngeen soppe seen bopp, ndaxte ay doxandéem ngeen woon ca réewum Misra. Man Aji Sax ji maay seen Yàlla. ");
INSERT INTO wolmbs_vpl VALUES ("LV19_35","004_19_35","LEV","19","35","35","«Buleen def njubadi ci lu ñuy natte guddaay mbaa diisaay mbaa lu ñuy sol, sotti. ");
INSERT INTO wolmbs_vpl VALUES ("LV19_36","004_19_36","LEV","19","36","36","Na seen nattukaayu diisaay jub, doom ya ngeen cay natte jub, te na nattukaayi sol-sotti yi jub. Maay seen Yàlla Aji Sax ji leen génne réewum Misra. ");
INSERT INTO wolmbs_vpl VALUES ("LV19_37","004_19_37","LEV","19","37","37","«Nangeen sàmm sama dogali yoon yépp ak sama santaane yépp te di ko jëfe. Maay Aji Sax ji.» ");
INSERT INTO wolmbs_vpl VALUES ("LV20_1","004_20_1","LEV","20","1","1","Aji Sax ji wax na Musaa ba tey ne ko: ");
INSERT INTO wolmbs_vpl VALUES ("LV20_2","004_20_2","LEV","20","2","2","«Waxal bànni Israayil ne leen: Muy bànni Israayil muy doxandéem ci Israayil, képp ku ci jël ciy doomam, jébbal tuur mi ñuy wax Moleg, dee rekk mooy àtteem. Na ko waa réew mi dóor ay doj, ba mu dee. ");
INSERT INTO wolmbs_vpl VALUES ("LV20_3","004_20_3","LEV","20","3","3","Man ci sama bopp dinaa noonoo nit kooku te dinaa ko dagge ci biir bànni Israayil, ndax li mu jël ciy doomam jox Moleg, di sobeel sama béreb bu sell tey teddadil sama tur wu sell. ");
INSERT INTO wolmbs_vpl VALUES ("LV20_4","004_20_4","LEV","20","4","4","Su fekkee ne waa réew mi dañu koo seetaan ba seetaan ko, muy jox Moleg ku bokk ciy doomam te taxul ñu rey ko, ");
INSERT INTO wolmbs_vpl VALUES ("LV20_5","004_20_5","LEV","20","5","5","man ci sama bopp maay noonoo nit kooku mook ay bokkam; dinaa dàq nit kooku ci biir bànni Israayil, génne ko, mook mboolem ñi mu àndal topp Moleg di bokkaale. ");
INSERT INTO wolmbs_vpl VALUES ("LV20_6","004_20_6","LEV","20","6","6","Ku jublu ci ñiy gisaane nit ñu dee mbaa mu jublu ci boroom rawaan yiy seet, topp leen, di ma leen bokkaalee, dinaa ko noonoo moom itam te dinaa ko dagge ci biir bànni Israayil. ");
INSERT INTO wolmbs_vpl VALUES ("LV20_7","004_20_7","LEV","20","7","7","Doxleen ci lu sell te sell, ngir man Aji Sax ji maay seen Yàlla. ");
INSERT INTO wolmbs_vpl VALUES ("LV20_8","004_20_8","LEV","20","8","8","Nangeen sàmm samay dogali yoon te di ko jëfe. Man Aji Sax ji maay ki leen sellal. ");
INSERT INTO wolmbs_vpl VALUES ("LV20_9","004_20_9","LEV","20","9","9","«Képp ku saaga baayam mbaa ndeyam, dee rekk mooy àtteem. Gannaaw baayam la saaga mbaa ndeyam, mooy gàddu bakkanu boppam. ");
INSERT INTO wolmbs_vpl VALUES ("LV20_10","004_20_10","LEV","20","10","10","«Góor gu njaaloo, mook jabaru moroomam ji muy njaalool, dee rekk mooy seen àtte. ");
INSERT INTO wolmbs_vpl VALUES ("LV20_11","004_20_11","LEV","20","11","11","«Ku tëdde sa soxnas baay, sa baay nga toroxal. Ñoom ñaar ñépp dee rekk mooy seen àtte, te ñooy gàddu seen bakkanu bopp. ");
INSERT INTO wolmbs_vpl VALUES ("LV20_12","004_20_12","LEV","20","12","12","Ku tëdde sa soxnas doom, mook soxnas doomam ñoom ñaar ñépp dee mooy seen àtte. Jëfu yàqute lañu def, kon ñooy gàddu seen bakkanu bopp. ");
INSERT INTO wolmbs_vpl VALUES ("LV20_13","004_20_13","LEV","20","13","13","«Su góor tëddee góor ni ñuy tëddee jigéen, ñaawtéef lañu def ñoom ñaar. Dee rekk mooy seen àtte, te ñooy gàddu seen bakkanu bopp. ");
INSERT INTO wolmbs_vpl VALUES ("LV20_14","004_20_14","LEV","20","14","14","Ku boole jigéen ak ndeyam jël leen jabar, def na lu bona bon. Dees leen di boole taal, lakk leen, moom ak jigéen ña, ndax mbon gu ni mel baña am ci seen biir. ");
INSERT INTO wolmbs_vpl VALUES ("LV20_15","004_20_15","LEV","20","15","15","Góor gu tëdde mala dee rekk mooy àtteem, te mala ma it dees koy rey. ");
INSERT INTO wolmbs_vpl VALUES ("LV20_16","004_20_16","LEV","20","16","16","Su jigéen jëmee ci mala mu mu doon, ba jaxasook moom, booleleen ku jigéen kaak mala ma, rey. Dee rekk mooy seen àtte, te ñooy gàddu seen bakkanu bopp. ");
INSERT INTO wolmbs_vpl VALUES ("LV20_17","004_20_17","LEV","20","17","17","«Su nit jëlee jabar ab jigéenam bu mu bokkal jenn ndey mbaa benn baay, ñu séq lalu séy, loolu gàcce la. Nañu leen dagge ci biir bànni Israayil, ñooñuy gis. Gannaaw moo tëdde ab jigéenam, na wéetoo añu ñaawtéefam. ");
INSERT INTO wolmbs_vpl VALUES ("LV20_18","004_20_18","LEV","20","18","18","«Ku tëdde jigéen ju gis baax, toroxal na ko, xàwwi na suturaam ci biir póotam te ku jigéen ki itam xàwwi na suturas boppam. Dees leen wara dagge ñoom ñaar ñépp ci biir bànni Israayil. ");
INSERT INTO wolmbs_vpl VALUES ("LV20_19","004_20_19","LEV","20","19","19","«Buleen tëdde seen yaay ju ndaw mbaa seen bàjjan, ndax kon toroxal ngeen ku ngeen jegewool lool cig bokk, te yeen ñaar ñépp ay wéetoo seen añu ñaawtéef. ");
INSERT INTO wolmbs_vpl VALUES ("LV20_20","004_20_20","LEV","20","20","20","«Ku tëdde soxnas baayam bu ndaw, baayam bu ndaw la toroxal. Ñooy wéetoo seen añu ñaawtéef. Duñu am takkndeer ba keroog ñuy dee. ");
INSERT INTO wolmbs_vpl VALUES ("LV20_21","004_20_21","LEV","20","21","21","«Bu nit nangoo jabaru ku mu bokkal waajur, loolu gàcce la. Toroxal na ka mu bokkal waajur te duñu am takkndeer. ");
INSERT INTO wolmbs_vpl VALUES ("LV20_22","004_20_22","LEV","20","22","22","«Sàmmleen sama dogali yoon yépp ak sama santaane yépp te jëfe ko, ngir réew ma ma leen jëme, ngeen dëkki fa, bañ leena gëq. ");
INSERT INTO wolmbs_vpl VALUES ("LV20_23","004_20_23","LEV","20","23","23","Buleen roy defini xeet wi ma leen di dàqal, ndax yooyu yépp lañu doon def, ba ma seexlu leen. ");
INSERT INTO wolmbs_vpl VALUES ("LV20_24","004_20_24","LEV","20","24","24","Yeen nag ma ne leen yeenay nangu seen réew ñoom, ndax maa leen ko jox, ngeen moom ko, muy réew mu meew maak lem ja tuuroo. Man maay seen Yàlla Aji Sax ji leen ràññaatleek yeneen xeet yi. ");
INSERT INTO wolmbs_vpl VALUES ("LV20_25","004_20_25","LEV","20","25","25","Kon nangeen ràññee mala mu dagan ak mu daganul, ak itam njanaaw lu dagan ak lu daganul, te bu leen tax ba ñu seexlu leen ndax mala mbaa njanaaw mbaa mboolem mbindeef yu sew-sewaan yiy dox ci suuf te ma limal leen ne setuñu. ");
INSERT INTO wolmbs_vpl VALUES ("LV20_26","004_20_26","LEV","20","26","26","«Nangeen nekk ñu sell ci man, ndaxte Ku sell laa, man Aji Sax ji, te dama leena ràññaatleek yeneen xeet yi, ngeen di sama ñoñ. ");
INSERT INTO wolmbs_vpl VALUES ("LV20_27","004_20_27","LEV","20","27","27","«Góor gu bokk ci yeen mbaa jigéen, di gisaane nit ñu dee mbaa muy boroom rawaan buy gisaane, dee rekk mooy àtteem. Dees koy dóor ay doj, mu dee, gàddu bakkanu boppam.» ");
INSERT INTO wolmbs_vpl VALUES ("LV21_1","004_21_1","LEV","21","1","1","Gannaaw loolu Aji Sax ji wax na Musaa ne ko: «Waxal sarxalkat yiy doomi Aaróona ne leen: Bu ci kenn sobeel boppam, di laal mbokkam mu dee, ");
INSERT INTO wolmbs_vpl VALUES ("LV21_2","004_21_2","LEV","21","2","2","su dul ñi ko gëna jege ci wàllu mbokk, muy ndeyam mbaa baayam mbaa doomam ju góor ak doomam ju jigéen, mbaa ku góor ku mu bokkal waajur, ");
INSERT INTO wolmbs_vpl VALUES ("LV21_3","004_21_3","LEV","21","3","3","mbaa ab jigéenam bu séyagul te bootu ci moom ndax amul jëkkër—ku mu bokkal noonu, sañ naa sobewu ndax moom. ");
INSERT INTO wolmbs_vpl VALUES ("LV21_4","004_21_4","LEV","21","4","4","Warula sobeel boppam, di boppam, ndax kilifa la ciw xeetam. ");
INSERT INTO wolmbs_vpl VALUES ("LV21_5","004_21_5","LEV","21","5","5","«Buñu wat fenn ci seen bopp te buñu wat seen peggi sikkim, buñu dagg seen yaram it, di ko mititloo ku dee. ");
INSERT INTO wolmbs_vpl VALUES ("LV21_6","004_21_6","LEV","21","6","6","Nañu nekkal seen Yàlla ay nit ñu sell, te baña teddadil seen turu Yàlla, ndax saraxi sawara yi ñeel Aji Sax ji, te di seen ñamu Yàlla, ñoo koy joxe. Kon nag dañoo wara sell. ");
INSERT INTO wolmbs_vpl VALUES ("LV21_7","004_21_7","LEV","21","7","7","«Ab gànc mbaa ku ñu toroxal, tëdde ko, ñoom duñu ko jël soxna. Ku jëkkëram baal it duñu ko jël soxna, ndax dañoo sellalal seen bopp seen Yàlla. ");
INSERT INTO wolmbs_vpl VALUES ("LV21_8","004_21_8","LEV","21","8","8","Te itam nangeen ràññee ne ñu sell lañu, ndax seen ñamu Yàlla, ñoo koy joxe. Nangeen leen jox céru nit ñu sell, ndax Ku sell laa, man Aji Sax ji leen sellal, yeen. ");
INSERT INTO wolmbs_vpl VALUES ("LV21_9","004_21_9","LEV","21","9","9","«Su fekkee ne doomu sarxalkat da di jigéen juy teddadil boppam, di gànctu, kooku baayam lay toroxal. Dees koy taal, lakk ko. ");
INSERT INTO wolmbs_vpl VALUES ("LV21_10","004_21_10","LEV","21","10","10","«Sarxalkat bi gëna màgg ci bokkam yiy sarxalkat, te ñu sotti diw gi ñuy fale ci boppam, sellal ko, muy sol yére yu sell yi, kooku du njañu te du xotti ay yéreem, di ko ñaawloo ku dee. ");
INSERT INTO wolmbs_vpl VALUES ("LV21_11","004_21_11","LEV","21","11","11","Fu ab néew nekk du fa dem, bu doon ndeyam mbaa baayam sax, du ko taxa sobeel boppam. ");
INSERT INTO wolmbs_vpl VALUES ("LV21_12","004_21_12","LEV","21","12","12","Du génn béreb bu sell bi ndax deele, lu moy dina teddadil bérebu Yàllaam bu sell bi, ndax Yàllaam sellale na ko diwug palam. Maay Aji Sax ji. ");
INSERT INTO wolmbs_vpl VALUES ("LV21_13","004_21_13","LEV","21","13","13","«Sarxalkat bu mag bi, ku xamul góor lay jël soxna. ");
INSERT INTO wolmbs_vpl VALUES ("LV21_14","004_21_14","LEV","21","14","14","Ku jëkkëram faatu mbaa ku ñu baal mbaa ku ñu toroxal, tëdde ko, mbaa ab gànc, du ko mana jël soxna. Ab janq bu mu bokkal doŋŋ la mana jël soxna. ");
INSERT INTO wolmbs_vpl VALUES ("LV21_15","004_21_15","LEV","21","15","15","Su ko defee du teddadil aw askanam ci biir bànni Israayil, ndax man Aji Sax ji maa ko sellal.» ");
INSERT INTO wolmbs_vpl VALUES ("LV21_16","004_21_16","LEV","21","16","16","Aji Sax ji wax na Musaa ne ko: ");
INSERT INTO wolmbs_vpl VALUES ("LV21_17","004_21_17","LEV","21","17","17","«Waxal Aaróona ne ko: Muy tey muy ëllëg ba fàww, góor gu askanoo ci yaw ak maas gu mu mana bokk, su amee sikk du mana agsi ba ci sarxalukaay bi, di joxe ñamu Yàllaam. ");
INSERT INTO wolmbs_vpl VALUES ("LV21_18","004_21_18","LEV","21","18","18","Du kenn sax ku am sikk kuy agsi ba fii, du gumba, du kuy soox, du ku xar-kanamam am sikk mbaa ku cér yi sutaate. ");
INSERT INTO wolmbs_vpl VALUES ("LV21_19","004_21_19","LEV","21","19","19","Du it ku tànk bi làggi mbaa loxo bi, ");
INSERT INTO wolmbs_vpl VALUES ("LV21_20","004_21_20","LEV","21","20","20","mbaa ab xuuge mbaa ab tungune; du it ku bëtam am sikk mbaa ku ràmm mbaa ku am góom yu sol dëtt, mbaa ku ñu tàpp. ");
INSERT INTO wolmbs_vpl VALUES ("LV21_21","004_21_21","LEV","21","21","21","Askanu Aaróona sarxalkat bi, du kenn ku ci am sikk kuy agsi ba fii, di joxe saraxi sawara yi ñeel Aji Sax ji. Sikk si ci moom a tax du mana agsi ba fii, di joxe ñamu Yàllaam. ");
INSERT INTO wolmbs_vpl VALUES ("LV21_22","004_21_22","LEV","21","22","22","Du tere mu saña lekk ci ñamu Yàllaam, muy ñam wu sell ak wu sella sell. ");
INSERT INTO wolmbs_vpl VALUES ("LV21_23","004_21_23","LEV","21","23","23","Waaye warula jege rido bi, mbaa muy dem ba ca sarxalukaay ba, ndax sikk si ci moom. Bumu teddadil sama béreb yu sell, ngir man Aji Sax ji maa sellal béreb yooyu.» ");
INSERT INTO wolmbs_vpl VALUES ("LV21_24","004_21_24","LEV","21","24","24","Musaa jottali na Aaróona aki doomam kàddu yooyu, ñoom ak mboolem bànni Israayil. ");
INSERT INTO wolmbs_vpl VALUES ("LV22_1","004_22_1","LEV","22","1","1","Aji Sax ji dellu wax Musaa ne ko: ");
INSERT INTO wolmbs_vpl VALUES ("LV22_2","004_22_2","LEV","22","2","2","«Waxal Aaróona aki doomam yu góor ne leen, lii mooy li mana tax ñu sore yu sell yi ma bànni Israayil sellalal, ngir baña teddadil sama tur wu sell. Maay Aji Sax ji. ");
INSERT INTO wolmbs_vpl VALUES ("LV22_3","004_22_3","LEV","22","3","3","Wax leen ne leen: Muy tey, muy ëllëg, ba fàww, képp ku sobewu, di góor gu bokk ci seen askan, bu jegee lenn luy sarax su sell su ma bànni Israayil jagleel, kooku dootu ma liggéeyal. Maay Aji Sax ji. ");
INSERT INTO wolmbs_vpl VALUES ("LV22_4","004_22_4","LEV","22","4","4","Askanu Aaróona, genn góor gu ci bokk du lekk ci sarax yu sell yi, li feek muy ànd ak jàngoroy der juy law mbaa jàngoroy xelli, ba keroog muy set. Ku ci laal lenn lu laal ab néew ba sobewu, mbaa mu tuur maniyu moom ci boppam, ");
INSERT INTO wolmbs_vpl VALUES ("LV22_5","004_22_5","LEV","22","5","5","mbaa mu laal yu sew-sewaan yiy dox ci suuf te di ko sobeel, mbaa mu laal nit ku ko sobeel ak lu sobe sa mana doon, ");
INSERT INTO wolmbs_vpl VALUES ("LV22_6","004_22_6","LEV","22","6","6","Képp ku def loolee mbaa mu laal mbir yooyu dina yendoo sobe sa ba jant so, te du lekk ci sarax yu sell yi ndare du dafa sangu. ");
INSERT INTO wolmbs_vpl VALUES ("LV22_7","004_22_7","LEV","22","7","7","Bu jant sowee nag set na, te man naa lekk ci sarax yu sell yi, ndax ñamam la. ");
INSERT INTO wolmbs_vpl VALUES ("LV22_8","004_22_8","LEV","22","8","8","Lu médd mbaa lu rab fàdd waru koo lekk, mu di ko sobeel. Maay Aji Sax ji. ");
INSERT INTO wolmbs_vpl VALUES ("LV22_9","004_22_9","LEV","22","9","9","Sarxalkat yi dañoo wara sàmm sama ndénkaane bala ñoo gàddu bàkkaar, di dee ndax seenug néewal ci yooyu. Maay Aji Sax ji leen sellal. ");
INSERT INTO wolmbs_vpl VALUES ("LV22_10","004_22_10","LEV","22","10","10","«Kenn ku bokkul ci waa kër sarxalkat yi du lekk ci sarax yu sell yi. Muy ku dal ak ab sarxalkat, muy ku koy liggéeyal di feyeeku, kenn du ci lekk ci sarax yu sell yi. ");
INSERT INTO wolmbs_vpl VALUES ("LV22_11","004_22_11","LEV","22","11","11","Waaye su sarxalkat bi jëndee ab jaam ci xaalisam, jaam ba man na caa lekk. Jaam bu juddoo ci kër sarxalkat bi it man naa lekk ci ñamam woowu. ");
INSERT INTO wolmbs_vpl VALUES ("LV22_12","004_22_12","LEV","22","12","12","Doomu sarxalkat, bu séyeek góor gu bokkul ci waa kër sarxalkat yi, dootul saña lekk saraxu njébbal yu sell yi. ");
INSERT INTO wolmbs_vpl VALUES ("LV22_13","004_22_13","LEV","22","13","13","Waaye doomu sarxalkat, bu boroom këram faatoo mbaa mu tàggook moom, te amu ca doom, bu delloo kër baayam na mu fa nekke woon ba muy gone, sañ naa lekk ci ñamu baayam. Waaye kenn ku ci bokkul sañu cee lekk. ");
INSERT INTO wolmbs_vpl VALUES ("LV22_14","004_22_14","LEV","22","14","14","Gannaaw loolu képp ku bokkul ci waa kër sarxalkat yi, bu lekkee ci sarax su sell te du teyeefam, na dolli ca njëgu sarax sa juróomeelu céru njëg ga, delloo ko sarxalkat bi. ");
INSERT INTO wolmbs_vpl VALUES ("LV22_15","004_22_15","LEV","22","15","15","Te itam bu sarxalkat yi bàyyi bànni Israayil di teddadil sarax yu sell yi ñu jagleel Aji Sax ji. ");
INSERT INTO wolmbs_vpl VALUES ("LV22_16","004_22_16","LEV","22","16","16","Buñu leen di bàyyi it ñuy gàddu bàkkaar buy laaj peyug tooñ, ngir lenn lu ñu lekk ci sarax yu sell yooyu. Man Aji Sax ji maa sellal yooyu sarax.» ");
INSERT INTO wolmbs_vpl VALUES ("LV22_17","004_22_17","LEV","22","17","17","Aji Sax ji waxati Musaa ne ko: ");
INSERT INTO wolmbs_vpl VALUES ("LV22_18","004_22_18","LEV","22","18","18","«Waxal Aaróona aki doomam yu góor ak bànni Israayil gépp ne leen: Képp ku bokk ci waa kër Israayil, mbaa ci doxandéem yi ci Israayil, di joxeel Aji Sax ji ab saraxu rendi-dóomal, muy sarax su ñuy wàccoo ngiñ mbaa saraxu yéene, ");
INSERT INTO wolmbs_vpl VALUES ("LV22_19","004_22_19","LEV","22","19","19","liy tax ñu nangul ko ko mooy muy jur gu amul sikk, di góor; man naa doon aw yëkk mbaa kuuy mbaa sikket. ");
INSERT INTO wolmbs_vpl VALUES ("LV22_20","004_22_20","LEV","22","20","20","Lenn lu ci am sikk buleen ko sarxal, ndax deesu leen ko nangul. ");
INSERT INTO wolmbs_vpl VALUES ("LV22_21","004_22_21","LEV","22","21","21","«Su nit dee joxsi Aji Sax ji aw nag mbaa gàtt, muy saraxu cant ci biir jàmm, mu di ko wàccoo ngiñ mbaa muy saraxu yéene, na doon lu amul sikk, ndax ñu nangul ko ko. Lenn luy sikk du nekk ci jur gi. ");
INSERT INTO wolmbs_vpl VALUES ("LV22_22","004_22_22","LEV","22","22","22","Du doon lu gumba, du doon lu làggi, du doon lu kuuñ, du doon lu ami góom, mbaa lu ràmm, mbaa lu xas. Buleen sarxalal Aji Sax ji yu mel noonu. Ab saraxu sawara, buleen ko jële ci lu mel noonu, di ko joxe ci kaw sarxalukaay bi, ñeel Aji Sax ji. ");
INSERT INTO wolmbs_vpl VALUES ("LV22_23","004_22_23","LEV","22","23","23","Waaye su dee nag mbaa gàtt bu ab céram ëpp mbaa mu yées, saraxu yéene la mana doon; su dee sarax su ñuy wàccoo ngiñ, deesu ko nangu. ");
INSERT INTO wolmbs_vpl VALUES ("LV22_24","004_22_24","LEV","22","24","24","Te it jur gu ñu motoxal ngóoraam mbaa ñu toj ko mbaa ñu xuuf ko mbaa ñu dog ko, deesu ko sarxalal Aji Sax ji. Buleen def loolu mukk ci seenum réew. ");
INSERT INTO wolmbs_vpl VALUES ("LV22_25","004_22_25","LEV","22","25","25","Buleen nangoo lenn lu ni mel ci loxol doxandéem it, di ko jébbal seen Yàlla, muy saraxu ñamam. Deesu leen ko nangul, ndax la matadi ca moom mooy sikk sa.» ");
INSERT INTO wolmbs_vpl VALUES ("LV22_26","004_22_26","LEV","22","26","26","Aji Sax ji wax na Musaa itam ne ko: ");
INSERT INTO wolmbs_vpl VALUES ("LV22_27","004_22_27","LEV","22","27","27","«Barmol mbaa mbote mbaa tef wu doora juddu, na toog ci yaayam juróom ñaari fan; bu xasee am juróom ñetti fan, manees naa nangu mu doon saraxu sawara, ñeel Aji Sax ji. ");
INSERT INTO wolmbs_vpl VALUES ("LV22_28","004_22_28","LEV","22","28","28","Waaye su dee aw nag mbaa ab gàtt, deesu ko booleek doom ji rendi ci benn bés. ");
INSERT INTO wolmbs_vpl VALUES ("LV22_29","004_22_29","LEV","22","29","29","«Bu ngeen dee defal Aji Sax ji saraxu cant, sarxalleen ko na ñu leen koy nangule. ");
INSERT INTO wolmbs_vpl VALUES ("LV22_30","004_22_30","LEV","22","30","30","Ci bés bi lees koy lekk, buleen ci fanaanal dara. Maay Aji Sax ji. ");
INSERT INTO wolmbs_vpl VALUES ("LV22_31","004_22_31","LEV","22","31","31","«Kon sàmmleen samay santaane te di ko jëfe. Maay Aji Sax ji. ");
INSERT INTO wolmbs_vpl VALUES ("LV22_32","004_22_32","LEV","22","32","32","Te buleen teddadil sama tur wu sell. Na bànni Israayil wormaal sama sellaay. Maay Aji Sax ji leen sellal, ");
INSERT INTO wolmbs_vpl VALUES ("LV22_33","004_22_33","LEV","22","33","33","génne leen réewum Misra, di seen Yàlla. Maay Aji Sax ji.» ");
INSERT INTO wolmbs_vpl VALUES ("LV23_1","004_23_1","LEV","23","1","1","Aji Sax ji dellooti wax Musaa ne ko: ");
INSERT INTO wolmbs_vpl VALUES ("LV23_2","004_23_2","LEV","23","2","2","«Samay màggal, man Aji Sax ji, dangeen koo wara siiwal, muy ndaje yu sell. Samay màggal yii la. ");
INSERT INTO wolmbs_vpl VALUES ("LV23_3","004_23_3","LEV","23","3","3","«Juróom benni fan lees di liggéey, bésub juróom ñaareel ba bésub Noflaay doŋŋ lay doon, di bésub ndaje mu sell. Du lenn lu ngeen ciy liggéey. Bésub Noflaay la bu ñuy jagleel Aji Sax ji, ak fépp fu ngeen dëkk. ");
INSERT INTO wolmbs_vpl VALUES ("LV23_4","004_23_4","LEV","23","4","4","«Aji Sax ji, deeleen yégle ay màggalam, muy ay ndaje yu sell yu ngeen di wormaal saa yu jotee. Màggal yii la. ");
INSERT INTO wolmbs_vpl VALUES ("LV23_5","004_23_5","LEV","23","5","5","«Fukki fan ak ñeent ci weer wi njëkk, diggante ngoon ak jant bu so, mooy màggalu bésub Mucc ba, ñeel Aji Sax ji. ");
INSERT INTO wolmbs_vpl VALUES ("LV23_6","004_23_6","LEV","23","6","6","«Ëllëg sa, fukki fan ak juróom ci weer woowu la ayu bésu Mburu mu amul lawiir di tàmbali, ñeel Aji Sax ji. Diiru juróom ñaari fan mburu mu amul lawiir ngeen wara lekk. ");
INSERT INTO wolmbs_vpl VALUES ("LV23_7","004_23_7","LEV","23","7","7","Bés bu jëkk boobu, woote bu sell lees cay amal. Mboolem lees baaxoo liggéey, deesu ko ci liggéey. ");
INSERT INTO wolmbs_vpl VALUES ("LV23_8","004_23_8","LEV","23","8","8","Defleen ci saraxu sawara, ñeel Aji Sax ji diiru juróom ñaari fan. Bésub juróom ñaareel ba di bésub woote bu sell. Mboolem lees baaxoo liggéey, deesu ko ci liggéey.» ");
INSERT INTO wolmbs_vpl VALUES ("LV23_9","004_23_9","LEV","23","9","9","Aji Sax ji wax na Musaa ne ko: ");
INSERT INTO wolmbs_vpl VALUES ("LV23_10","004_23_10","LEV","23","10","10","«Waxal bànni Israayil ne leen: Bu ngeen duggee ca réew ma ma leen jox, ba dajale la ngeen jële ca suufam, yóbbuleen ci sarxalkat bi takku peppum lors bi ngeen njëkka góob. ");
INSERT INTO wolmbs_vpl VALUES ("LV23_11","004_23_11","LEV","23","11","11","Sarxalkat bi day yékkati takk bi, jébbal ko Aji Sax ji, ngir mu nangul leen ko. Bés bi topp ci bésub Noflaay bi lay yékkati takk bi, jébbal ko ko. ");
INSERT INTO wolmbs_vpl VALUES ("LV23_12","004_23_12","LEV","23","12","12","Bés bi ñuy yékkati takk bi, jébbale ko, nangeen ci sarxal kuuy mu amul sikk, tollu ci menn at, ñu defal ko Aji Sax ji saraxu rendi-dóomal. ");
INSERT INTO wolmbs_vpl VALUES ("LV23_13","004_23_13","LEV","23","13","13","Saraxu pepp mi muy àndal juróom benni kiloy sunguf su mucc ayib lay doon, ñu xiiwe ko diw, muy saraxu sawara, ñeel Aji Sax ji, ngir xetug jàmm. Sarax si ñuy tuural Aji Sax ji, liitaru biiñ la. ");
INSERT INTO wolmbs_vpl VALUES ("LV23_14","004_23_14","LEV","23","14","14","Du mburu, du pepp mu ñu séndal, du pepp mu bees mu ngeen wara lekk, ba keroog bés boobu ngeen di indi seen saraxu Yàlla. Dogal a ngoogu, di lu leen war fàww, yeen ak seen askan, ak fépp fu ngeen dëkk. ");
INSERT INTO wolmbs_vpl VALUES ("LV23_15","004_23_15","LEV","23","15","15","«Bésub Noflaay ba ngeen di indi takku bele biy saraxu yékkati-jébbale, bés ba ca topp ngeen di dale waññ juróom ñaari ayi bés yu mat sëkk. ");
INSERT INTO wolmbs_vpl VALUES ("LV23_16","004_23_16","LEV","23","16","16","Waññleen ba ca bés ba topp ci juróom ñaareelu bésub Noflaay ba, muy juróom fukki fan, ngeen indil ca Aji Sax ji saraxu pepp mu bees. ");
INSERT INTO wolmbs_vpl VALUES ("LV23_17","004_23_17","LEV","23","17","17","Seeni kër ngeen di jële ñaari mburu yuy doon saraxu yékkati-jébbale, mu ci nekk di lu ñu lakke juróom benni kiloy sunguf su mucc ayib; dees ciy def lawiir, lakkaale ko ko, muy saraxu ndoortel meññeef, ñeel Aji Sax ji. ");
INSERT INTO wolmbs_vpl VALUES ("LV23_18","004_23_18","LEV","23","18","18","Na mbooloo mi booleek mburu mi juróom ñaari kuuy yu amul sikk te tollu ci menn at, ak yëkk ak ñaari kuuy yu mag, mu doon saraxu rendi-dóomal, ñeel Aji Sax ji. Na ànd ak saraxu pepp ak sarax si ñuy tuur. Loolu sarax la ngir xetug jàmm gu neex Aji Sax ji. ");
INSERT INTO wolmbs_vpl VALUES ("LV23_19","004_23_19","LEV","23","19","19","Te itam ngeen sarxal ab sikket buy doon saraxu póotum bàkkaar ak ñaari kuuyu menn at, muy saraxu cant ci biir jàmm. ");
INSERT INTO wolmbs_vpl VALUES ("LV23_20","004_23_20","LEV","23","20","20","Sarxalkat bi day yékkati ñaari kuuy yooyu, boole kook mburum ndoortel meññeef mi, def ko sarax bu ñuy yékkati, jébbal Aji Sax ji. Yooyu sarax di lu sell ñeel Aji Sax ji, sarxalkat bee ko moom. ");
INSERT INTO wolmbs_vpl VALUES ("LV23_21","004_23_21","LEV","23","21","21","Wooteleen ci bés boobu woote bu sell, seen bésub woote bu sell lay doon te mboolem lees baaxoo liggéey, deesu ko ci liggéey. Dogal a ngoogu, di lu leen war fàww, yeen ak seen askan, ak fépp fu ngeen dëkk. ");
INSERT INTO wolmbs_vpl VALUES ("LV23_22","004_23_22","LEV","23","22","22","«Bu ngeen dee góob seen tool, buleen góob ba fa tool ba yem te buleen ci toppaat, di foraatu. Aji ñàkk akub doxandéem ngeen koy bàyyee. Maay seen Yàlla Aji Sax ji.» ");
INSERT INTO wolmbs_vpl VALUES ("LV23_23","004_23_23","LEV","23","23","23","Gannaaw loolu Aji Sax ji wax na Musaa ne ko: ");
INSERT INTO wolmbs_vpl VALUES ("LV23_24","004_23_24","LEV","23","24","24","«Waxal bànni Israayil ne leen: Bu juróom ñaareelu weer taxawee, bés bi njëkk ci weer wi, na doon seen bésub Noflaay bu ngeen di amal ndaje mu sell. Deeleen fàttalee bés bi liit yu xumb. ");
INSERT INTO wolmbs_vpl VALUES ("LV23_25","004_23_25","LEV","23","25","25","Mboolem lu ngeen faral di liggéey buleen ko ci liggéey, waaye nangeen ci indi saraxu sawara, ñeel Aji Sax ji.» ");
INSERT INTO wolmbs_vpl VALUES ("LV23_26","004_23_26","LEV","23","26","26","Aji Sax ji teg ca wax Musaa ne ko: ");
INSERT INTO wolmbs_vpl VALUES ("LV23_27","004_23_27","LEV","23","27","27","«Te itam fukki fan ci juróom ñaareelu weer woowu, bésub Njotlaay ba lay doon. Ndaje mu sell ngeen ciy amal. Nangeen ci toroxlu te indi saraxu sawara, ñeel Aji Sax ji. ");
INSERT INTO wolmbs_vpl VALUES ("LV23_28","004_23_28","LEV","23","28","28","Du lenn lu ngeen di liggéey ci boobu bés, ndax bésub Njotlaay la bu ngeen di jotoo fi seen kanam Yàlla, Aji Sax ji. ");
INSERT INTO wolmbs_vpl VALUES ("LV23_29","004_23_29","LEV","23","29","29","Te kat, képp ku toroxluwul boobu bés, dees koy dagge ci biir bànni Israayil. ");
INSERT INTO wolmbs_vpl VALUES ("LV23_30","004_23_30","LEV","23","30","30","Képp ku liggéey lenn ci boobu bés, su boobaa dinaa far kooku ci biir bànni Israayil, sànk ko. ");
INSERT INTO wolmbs_vpl VALUES ("LV23_31","004_23_31","LEV","23","31","31","Buleen ci liggéey dara. Dogal a ngoogu, di lu leen war fàww, yeen ak seen askan ak fépp fu ngeen dëkk. ");
INSERT INTO wolmbs_vpl VALUES ("LV23_32","004_23_32","LEV","23","32","32","Seen bésub Noflaay la bu ngeen di noppalu doŋŋ te war cee toroxlu. Li ko dale ci ngoonug juróom ñeenti fan ci weer wi ba ca ëllëg sa, ba jant so, ci ngeen di wormaal seen bésub Noflaay.» ");
INSERT INTO wolmbs_vpl VALUES ("LV23_33","004_23_33","LEV","23","33","33","Su loolu wéyee Aji Sax ji wax na Musaa ne ko: ");
INSERT INTO wolmbs_vpl VALUES ("LV23_34","004_23_34","LEV","23","34","34","«Waxal bànni Israayil ne leen: Ñu waññ dale ko ci fukki fan ak juróom ci weeru juróom ñaareel woowu ba mu am juróom ñaari fan. Diir boobu mooy màggalu ayu bésu Mbaar yi, ñeel Aji Sax ji. ");
INSERT INTO wolmbs_vpl VALUES ("LV23_35","004_23_35","LEV","23","35","35","Bés bu njëkk bi bésub ndaje mu sell la. Mboolem lu ngeen faral di liggéey buleen ko ci liggéey. ");
INSERT INTO wolmbs_vpl VALUES ("LV23_36","004_23_36","LEV","23","36","36","Diiru juróom ñaari fan ngeen di indi saraxu sawara, ñeel Aji Sax ji. Bésub juróom ñetteel ba wara doon seen ndaje mu sell, nangeen ci indi saraxu sawara, ñeel Aji Sax ji. Ndajem mujjantal ba la. Mboolem lu ngeen faral di liggéey buleen ko ci liggéey. ");
INSERT INTO wolmbs_vpl VALUES ("LV23_37","004_23_37","LEV","23","37","37","«Yooyoo di màggali Aji Sax ji, yi ñu wara yégle, di ndaje yu sell yu ñuy indi ay saraxi sawara, ñeel Aji Sax ji, muy saraxu rendi-dóomal, ak saraxu pepp, ak yeneen saraxi jur gu ñuy rendi, ak sarax yi ñuy tuural Aji Sax ji, bés bu nekk ak la ca war. ");
INSERT INTO wolmbs_vpl VALUES ("LV23_38","004_23_38","LEV","23","38","38","Yooyu sarax jotewul dara ak saraxi bési Noflaay yu Aji Sax ji. Jotewul dara it ak yi ngeen di joxeel Aji Sax ji mbaa mboolem sarax yi ngeen di wàccoo ngiñ, ak mboolem saraxi yéene yi ngeen di defal Aji Sax ji. ");
INSERT INTO wolmbs_vpl VALUES ("LV23_39","004_23_39","LEV","23","39","39","«Ci biir loolu, fukki fan ak juróom ci juróom ñaareelu weer wi, gannaaw bu ngeen dajalee meññeefum réew mi, amalleen màggalug Aji Sax ji diiru juróom ñaari fan. Na bés bu njëkk ba di bésub Noflaay, bésub juróom ñetteel ba di bésub Noflaay. ");
INSERT INTO wolmbs_vpl VALUES ("LV23_40","004_23_40","LEV","23","40","40","Bés bu njëkk ba wittleen doomi garab yu rafet ak cari tàndarma ak cari garab yu sëq ak cari garab yu ñuy wax sóol, tey saxe tàkkal dex. Nangeen bànneexu fi seen kanam Yàlla Aji Sax ji diiru juróom ñaari fan. ");
INSERT INTO wolmbs_vpl VALUES ("LV23_41","004_23_41","LEV","23","41","41","Wormaalleen màggalug Aji Sax jooju, di juróom ñaari fan cim at, te wormaalleen ko ci juróom ñaareelu weer wi. Dogal a ngoogu, di lu leen war fàww, yeen ak seen askan. ");
INSERT INTO wolmbs_vpl VALUES ("LV23_42","004_23_42","LEV","23","42","42","Ci ay mbaar ngeen di dëkk diiru juróom ñaari fan yooyu. Mboolem njuddu-ji-réew ci Israayil na ci dëkke mbaar, ");
INSERT INTO wolmbs_vpl VALUES ("LV23_43","004_23_43","LEV","23","43","43","su ko defee seeni sët xam ne ciy mbaar laa dëkkaloon bànni Israayil, ba ma leen génnee réewum Misra. Maay seen Yàlla Aji Sax ji.» ");
INSERT INTO wolmbs_vpl VALUES ("LV23_44","004_23_44","LEV","23","44","44","Noonu la Musaa xamale bànni Israayil bési màggalug Aji Sax ji. ");
INSERT INTO wolmbs_vpl VALUES ("LV24_1","004_24_1","LEV","24","1","1","Ba loolu amee Aji Sax ji wax na Musaa ne ko: ");
INSERT INTO wolmbs_vpl VALUES ("LV24_2","004_24_2","LEV","24","2","2","«Santal bànni Israayil, ñu indil la diwu segalu oliw gu raxul ngir leerlu, ñu di ko taale làmp yi guddi gu nekk. ");
INSERT INTO wolmbs_vpl VALUES ("LV24_3","004_24_3","LEV","24","3","3","Ci kanam rido bi làq gaalu àlluway seede si, ci biir xaymab ndaje mi la Aaróona di teg làmp yi, muy fanaanee tàkk ngoon ba bët set, fi kanam Aji Sax ji. Dogal a ngoogu, di lu leen war fàww, yeen ak seen askan. ");
INSERT INTO wolmbs_vpl VALUES ("LV24_4","004_24_4","LEV","24","4","4","Na teg làmp yi ci kaw tegukaayu làmp ba ñuy tëgge wurusu ngalam, muy fanaanee tàkk fi kanam Aji Sax ji. ");
INSERT INTO wolmbs_vpl VALUES ("LV24_5","004_24_5","LEV","24","5","5","«Sàkkal sunguf su mucc ayib, lakk ci fukki mburu ak ñaar, mburu mu nekk di juróom benni kiloy sunguf. ");
INSERT INTO wolmbs_vpl VALUES ("LV24_6","004_24_6","LEV","24","6","6","Tegal mburu yi ci kaw taabalu wurusu ngalam bi, fi kanam Aji Sax ji, te def ko ñaari jal, jal bu ne juróom benni mburu. ");
INSERT INTO wolmbs_vpl VALUES ("LV24_7","004_24_7","LEV","24","7","7","Jal bu nekk teg ca cuuraay lu raxul, di saraxu sawara, ñu lakk ko mu wuutu mburu mi, ñeel Aji Sax ji, muy saraxu baaxantal. ");
INSERT INTO wolmbs_vpl VALUES ("LV24_8","004_24_8","LEV","24","8","8","Bésub Noflaay bu nekk nañu saxoo taaj mburu yooyu fi kanam Aji Sax ji. Loolu sas la bu bànni Israayil di tegoo fàww. ");
INSERT INTO wolmbs_vpl VALUES ("LV24_9","004_24_9","LEV","24","9","9","Mburu yooyu Aaróona aki doomam yu góor ñoo koy féetewoo, te nañu ko lekke fu sell, ndaxte lu sella sell la, di lu ñu séddoo fàww ci saraxi sawara yi ñeel Aji Sax ji.» ");
INSERT INTO wolmbs_vpl VALUES ("LV24_10","004_24_10","LEV","24","10","11","Ba loolu wéyee amoon na ci biir bànni Israayil jenn waay ju yaayam di doomu Israayil te tuddoon Selomit doomu Dibbri, Daneen ba. Baayam di waa Misra. Mu am bés xeex jib ci biir dal bi, ci diggante waa jooju ak jenn waayi Israayil ju raxul. Ci biir loolu waa ji yaayam di doomu Israayil wax Yàlla lu ñaaw, tudd ko jaar fu bon. Ñu yóbbu ko ca Musaa. ");
INSERT INTO wolmbs_vpl VALUES ("LV24_12","004_24_12","LEV","24","12","12","Ñu tëj waa ja, ba xam lu Aji Sax ji namm ci moom. ");
INSERT INTO wolmbs_vpl VALUES ("LV24_13","004_24_13","LEV","24","13","13","Ci kaw loolu Aji Sax ji wax Musaa ne ko: ");
INSERT INTO wolmbs_vpl VALUES ("LV24_14","004_24_14","LEV","24","14","14","«Génneel dal bi ki may wax lu ñaaw, man Yàlla, te na mboolem ku ci dégg teg loxoom ci kaw boppam, ba noppi mbooloo mépp dóor koy doj, ba mu dee. ");
INSERT INTO wolmbs_vpl VALUES ("LV24_15","004_24_15","LEV","24","15","15","Bànni Israayil nag nangeen leen wax ne leen: Képp ku wax Yàllaam lu ñaaw, jaar fu bon, na wéetoo añam. ");
INSERT INTO wolmbs_vpl VALUES ("LV24_16","004_24_16","LEV","24","16","16","Ku ñàkke kersa turu Aji Sax ji, dee rekk mooy àtteem. Mbooloo mi mépp a ko wara dóor ay doj, ba mu dee. Muy doxandéem muy njuddu-ji-réew, ku ci ñàkke kersa turu Aji Sax ji, dee mooy àtteem. ");
INSERT INTO wolmbs_vpl VALUES ("LV24_17","004_24_17","LEV","24","17","17","«Bu loolu weesoo képp ku faat bakkanu nit, dee rekk mooy àtteem. ");
INSERT INTO wolmbs_vpl VALUES ("LV24_18","004_24_18","LEV","24","18","18","Ku faat bakkanu mala, na fey boroom. Bakkan, bakkan a koy fey. ");
INSERT INTO wolmbs_vpl VALUES ("LV24_19","004_24_19","LEV","24","19","19","Képp ku gaañ moroomam, la mu ko def rekk lañu koy def. ");
INSERT INTO wolmbs_vpl VALUES ("LV24_20","004_24_20","LEV","24","20","20","Damm-damm, damm-damm a koy fey; bët, bët a koy fey; bëñ it bëñ a koy fey. Ni mu gaañe moroomam rekk, ni lañu koy gaañe. ");
INSERT INTO wolmbs_vpl VALUES ("LV24_21","004_24_21","LEV","24","21","21","«Ku rey ag jur na fey boroom, waaye ku rey nit dee mooy àtteem. ");
INSERT INTO wolmbs_vpl VALUES ("LV24_22","004_24_22","LEV","24","22","22","Na àtte bi di benn ci doxandéem ak njuddu-ji-réew, ndax man Aji Sax ji maay seen Yàlla.» ");
INSERT INTO wolmbs_vpl VALUES ("LV24_23","004_24_23","LEV","24","23","23","Ci kaw loolu Musaa wax ko bànni Israayil, ñu génne dal ba waa ja ñàkke Yàlla kersa, dóor ko ay doj, ba mu dee. Kon li bànni Israayil def mooy li Aji Sax ji santoon Musaa rekk. ");
INSERT INTO wolmbs_vpl VALUES ("LV25_1","004_25_1","LEV","25","1","1","Gannaaw loolu Aji Sax ji wax na Musaa ca tundu Sinayi ne ko: ");
INSERT INTO wolmbs_vpl VALUES ("LV25_2","004_25_2","LEV","25","2","2","«Waxal bànni Israayil ne leen: Bu ngeen duggee ca réew ma ma leen jox, suuf sa ca boppam war naa am àppu noflaayam ngir Aji Sax ji. ");
INSERT INTO wolmbs_vpl VALUES ("LV25_3","004_25_3","LEV","25","3","3","Diiru juróom benni at ngeen di ji seen tool; juróom benni at yooyu itam ngeen di wolli seen tóokëru reseñ, dajale meññeef ma. ");
INSERT INTO wolmbs_vpl VALUES ("LV25_4","004_25_4","LEV","25","4","4","Waaye atum juróom ñaareel ba Atum Noflaay la wara doon, suuf sa ca boppam day noppalu doŋŋ ngir Aji Sax ji. Buleen ci ji seen tool, buleen ci wolli seen tóokëru reseñ. ");
INSERT INTO wolmbs_vpl VALUES ("LV25_5","004_25_5","LEV","25","5","5","La saxe ca seenum ngóob sax, buleen ko góobaat te it reseñ gu ñu wolliwuloon buleen ko raasaatu. Atum Noflaay la wara doon, suuf sa ca boppam na noppalu atum lëmm. ");
INSERT INTO wolmbs_vpl VALUES ("LV25_6","004_25_6","LEV","25","6","6","Waaye lépp luy saxyaay ci Atum Noflaay sañ ngeen koo lekk, yeen ak seen jaam yu góor ak yu jigéen, ak seeni surga ak doxandéem bu dal ak yeen. ");
INSERT INTO wolmbs_vpl VALUES ("LV25_7","004_25_7","LEV","25","7","7","Seen jur it ca la, ba ca rabi àll ya ca seen réew. Mboolem lu suuf sa meññ, manees na koo lekk. ");
INSERT INTO wolmbs_vpl VALUES ("LV25_8","004_25_8","LEV","25","8","8","«Gannaaw loolu nangeen waññ ba ci juróom ñaari Ati Noflaay, loolu di juróom ñaari at ba muy juróom ñaari yoon. Mu doon seen juróom ñaari Ati Noflaay, tollu ci ñeent fukki at ak juróom ñeent. ");
INSERT INTO wolmbs_vpl VALUES ("LV25_9","004_25_9","LEV","25","9","9","Su boobaa ci fukki fan ca juróom ñaareelu weer wa nangeen wallu ab bufta fépp. Bésub Njotlaay boobu nangeen wal ab bufta ci seenum réew ba mu daj. ");
INSERT INTO wolmbs_vpl VALUES ("LV25_10","004_25_10","LEV","25","10","10","Te nangeen sellal at ma ca topp di juróom fukkeelu at ma, ngeen yéene ca mboolem waa réew ma ba mu daj, ne ngoreel taxaw na. Seen atum Yiwiku la, ku nekk war cee dellu ca suufu waa këram, ku nekk it wara dellu ca làng ga mu bokk. ");
INSERT INTO wolmbs_vpl VALUES ("LV25_11","004_25_11","LEV","25","11","11","Seen atum Yiwiku la atum juróom fukkeel boobu di doon. Dungeen ci ji, dungeen ci góobaat lu saxe ca seenum ngóob te dungeen ci wolli ag reseñ, di ko witt. ");
INSERT INTO wolmbs_vpl VALUES ("LV25_12","004_25_12","LEV","25","12","12","Gannaaw atum Yiwiku la, na doon at mu ngeen sellal. Saxyaayub tool ngeen saña lekk. ");
INSERT INTO wolmbs_vpl VALUES ("LV25_13","004_25_13","LEV","25","13","13","«Atum Yiwiku moomu ci ngeen di delloo ku nekk suufam. ");
INSERT INTO wolmbs_vpl VALUES ("LV25_14","004_25_14","LEV","25","14","14","Bu ngeen di jaay seen waa réew suuf nag mbaa ngeen di jënde suuf ci seen waa réew, buleen di naxante. ");
INSERT INTO wolmbs_vpl VALUES ("LV25_15","004_25_15","LEV","25","15","15","Limu at yi dox seen digganteek atum Yiwiku ma mujj, na dëppook njëg gi ngeen di jënde suuf ci seen waa réew. Limu ati mbey yi dox seen digganteek atum Yiwiku ma ca toppaat it, war naa dëppook njëg ga ñu leen jaaye. ");
INSERT INTO wolmbs_vpl VALUES ("LV25_16","004_25_16","LEV","25","16","16","Lu at yooya gëna bare, njëg ga gëna jafe; lu at ya gëna néew, njëg ga gëna yomb, ndaxte limu meññeefum suuf sa lees leen koy jaaye. ");
INSERT INTO wolmbs_vpl VALUES ("LV25_17","004_25_17","LEV","25","17","17","Buleen di naxante, waaye ragalleen seen Yàlla, ndax man Aji Sax ji maay seen Yàlla. ");
INSERT INTO wolmbs_vpl VALUES ("LV25_18","004_25_18","LEV","25","18","18","«Saxleen ci samay dogal, sàmm samay ndigali yoon, di ko jëfe, ndax ngeen dëkk ak jàmm ci réew mi. ");
INSERT INTO wolmbs_vpl VALUES ("LV25_19","004_25_19","LEV","25","19","19","Kon suuf si dina nangu, ngeen di lekk ba suur te dëkk fa ci jàmm. ");
INSERT INTO wolmbs_vpl VALUES ("LV25_20","004_25_20","LEV","25","20","20","Jombul ngeen di wax naan: “Lu nuy lekk nag ci atum juróom ñaareel ba, gannaaw dunu ci ji te dunu ci dajale sunu meññeef?” ");
INSERT INTO wolmbs_vpl VALUES ("LV25_21","004_25_21","LEV","25","21","21","Waaye dinaa leen yónnee sama barke ca atum juróom benneel ba, suuf si nangul leen meññeefum ñetti at. ");
INSERT INTO wolmbs_vpl VALUES ("LV25_22","004_25_22","LEV","25","22","22","Bu ngeen tolloo ci ji ci atum juróom ñetteel ba, dina leen fekk ngeen di lekk meññeefum daaw-jéeg, te meññeefum atum juróom ñeenteel ba dina agsi, fekk ngeen di lekk ca mu daaw-jéeg ma. ");
INSERT INTO wolmbs_vpl VALUES ("LV25_23","004_25_23","LEV","25","23","23","«Suuf si deesu ko jaay, mu wel fàww, ndax maay Boroom suuf si, yeen ay doxandéem ngeen fi, yu ma fi dëkkal. ");
INSERT INTO wolmbs_vpl VALUES ("LV25_24","004_25_24","LEV","25","24","24","Fépp fu bokk ci seenum réew, nangeen fa yoonal sañ-sañu jotaat ca suuf sa. ");
INSERT INTO wolmbs_vpl VALUES ("LV25_25","004_25_25","LEV","25","25","25","«Bu sa mbokk demee ba ñàkk tax koo jaay ci suufam, mbokkam mi ko gëna jege te am sañ-sañu jotaat suufam, na jëndaat la mbokk ma jaayoon. ");
INSERT INTO wolmbs_vpl VALUES ("LV25_26","004_25_26","LEV","25","26","26","Ku amul ku ko ko jotaatal te moom ci boppam mu mujj woomle, ba am lu mu ko jotaate, ");
INSERT INTO wolmbs_vpl VALUES ("LV25_27","004_25_27","LEV","25","27","27","day waññ at ya njaay ma am, delloo ki mu jaayoon ati mbey ya ca kooka dese, daldi mana jotaat ci suufam. ");
INSERT INTO wolmbs_vpl VALUES ("LV25_28","004_25_28","LEV","25","28","28","Waaye su amul lu mu jëndaate suufam, suuf sa day des ca loxol ka mu jaayoon, ba keroog atum Yiwiku ma délsi. Bu atum Yiwiku ma délsee, sañ naa dellu ca suufam. ");
INSERT INTO wolmbs_vpl VALUES ("LV25_29","004_25_29","LEV","25","29","29","«Su dee waa ju jaay ab dëkkuwaay bu nekk ci dëkk bu mag bu ñu tabax tata wëralee ko ko, dina ko saña jotaat li feek njaay mi amul at. Ci diir boobu la ko saña jotaate. ");
INSERT INTO wolmbs_vpl VALUES ("LV25_30","004_25_30","LEV","25","30","30","Su ñu ko jotaatul ba njaay ma am atum lëmm, dëkkuwaay boobu ci biir dëkk bu mag ba ñu wëralee tata day wel fàww, ñeel ka ko jënd, mook ku askanoo ci moom. Du lees di delloo ci atum Yiwiku. ");
INSERT INTO wolmbs_vpl VALUES ("LV25_31","004_25_31","LEV","25","31","31","Su dee ay dëkkuwaay ci dëkk yu ndaw yu ñu tabaxul tata, wëralee ko ko, dees koy yemaleek alali suuf. Sañees na koo jotaat te dees koy delloo ci atum Yiwiku. ");
INSERT INTO wolmbs_vpl VALUES ("LV25_32","004_25_32","LEV","25","32","32","«Su dee dëkki Leween ñi ak seen dëkkuwaay ya ca biir nag, Leween ñi sañ nañu cee jotaat fàww. ");
INSERT INTO wolmbs_vpl VALUES ("LV25_33","004_25_33","LEV","25","33","33","Kon alalu Leween manees na koo jotaat—dëkkuwaay lay doon bu ñu jaay ci dëkki Leween ñi—dees koy delloo bu atum Yiwiku dikkee, ndax dëkkuwaay yi ci dëkki Leween ñi, seen alal la ju leen lew fàww ci seen biir bokki bànni Israayil. ");
INSERT INTO wolmbs_vpl VALUES ("LV25_34","004_25_34","LEV","25","34","34","Waaye suufas parlu yi bokk ci dëkki Leween ñi, deesu ko jaay, ndax ñoo koy moom fàww. ");
INSERT INTO wolmbs_vpl VALUES ("LV25_35","004_25_35","LEV","25","35","35","«Bu seen mbokkum bànni Israayil ñàkkee ba manatula fey lu mu leen ameel, nangeen ko dimbali, ni bu doon doxandéem mbaa màngaan, ndax mu mana dund ci seen biir. ");
INSERT INTO wolmbs_vpl VALUES ("LV25_36","004_25_36","LEV","25","36","36","Buleen teg lenn lu mu mana doon ci bor bu leen seen mbokk moomu ameel, waaye ragalleen ci seen Yàlla, ndax mu mana dund ci seen biir. ");
INSERT INTO wolmbs_vpl VALUES ("LV25_37","004_25_37","LEV","25","37","37","Buleen ko lebal seen xaalis, di ca teg lenn, te buleen ko jox dund, di sàkku lu mu ca yokk ngir delloo leen ko. ");
INSERT INTO wolmbs_vpl VALUES ("LV25_38","004_25_38","LEV","25","38","38","Man Aji Sax ji maay seen Yàlla ji leen génne réewum Misra, jox leen réewu Kanaan, te di seen Yàlla. ");
INSERT INTO wolmbs_vpl VALUES ("LV25_39","004_25_39","LEV","25","39","39","«Bu seen mbokk ñàkkee ci seen biir, ba jaay leen boppam, buleen ko duggal cig njaam. ");
INSERT INTO wolmbs_vpl VALUES ("LV25_40","004_25_40","LEV","25","40","40","Defleen ko ni liggéeykat buy feyeeku mbaa màngaan bu ngeen dëkkal. Na leen liggéeyal ba keroog atum Yiwiku ma, ");
INSERT INTO wolmbs_vpl VALUES ("LV25_41","004_25_41","LEV","25","41","41","mu génn ci seeni loxo, mook ay doomam, daldi dellu ci làngu boppam, fa ay maamam séddoo. ");
INSERT INTO wolmbs_vpl VALUES ("LV25_42","004_25_42","LEV","25","42","42","Li waral loolu moo di bànni Israayil dañu di sama jaam yi ma génne réewum Misra. Deesu leen jaay njaam. ");
INSERT INTO wolmbs_vpl VALUES ("LV25_43","004_25_43","LEV","25","43","43","Buleen leen soxore ci biir kilifteef, waaye ragalleen ci seen Yàlla. ");
INSERT INTO wolmbs_vpl VALUES ("LV25_44","004_25_44","LEV","25","44","44","Seen jaam yu góor ak seen jaam yu jigéen, nangeen leen jële ci xeet yi leen wër. Ci ñooñu ngeen di jënde ay jaam, góor ak jigéen. ");
INSERT INTO wolmbs_vpl VALUES ("LV25_45","004_25_45","LEV","25","45","45","Walla ngeen jënde ba tey ci doxandéem yi ci seen biir, mbaa ci njaboot yi doxandéem yi am ci réew mi te ñu nekk ci seen biir. Su ko defee ñu doon seen ngàllo. ");
INSERT INTO wolmbs_vpl VALUES ("LV25_46","004_25_46","LEV","25","46","46","Sañ ngeen leena donale seen doom yi leen di wuutu, ñu doon seen ngàllo seen giiru dund. Ñooñu sañ ngeen leena def ay jaam, waaye su dee ci seen diggante, yeen bànni Israayil, buleen di soxorante ci biir kilifteef. ");
INSERT INTO wolmbs_vpl VALUES ("LV25_47","004_25_47","LEV","25","47","47","«Su fekkee ne ab doxandéem bu ngeen dëkkal mbaa ab màngaan dafa woomle te kenn ci seeni bokk ñàkk, ba jaay boppam doxandéem bi ngeen dëkkal mbaa kenn ku bokk ak doxandéem bi, ");
INSERT INTO wolmbs_vpl VALUES ("LV25_48","004_25_48","LEV","25","48","48","gannaaw bu jaayee boppam, manees na koo jotaat ba tey. Kenn ciy bokkam sañ na koo jotaat, ");
INSERT INTO wolmbs_vpl VALUES ("LV25_49","004_25_49","LEV","25","49","49","yaar muy baayam bu ndaw mbaa doomu baayam bu ndaw. Ku mu bokkal làng di mbokkam lenqe sax man na koo jotaat, te moom ci boppam man naa woomle ba jotaat boppam. ");
INSERT INTO wolmbs_vpl VALUES ("LV25_50","004_25_50","LEV","25","50","50","Na bokk ak ka ko jënd waññ, la dale ca at ma mu jaaye boppam, ba ca atum Yiwiku may ñëw, muy njëgu goreelam, dëppook at yooya. Te it nañu ci seet àqu ñaqu liggéeykat. ");
INSERT INTO wolmbs_vpl VALUES ("LV25_51","004_25_51","LEV","25","51","51","Su desee ay at, lu at ya gëna baree, njëg ga muy jotaate boppam gëna sore ci njëg ga ñu ko jënde woon. ");
INSERT INTO wolmbs_vpl VALUES ("LV25_52","004_25_52","LEV","25","52","52","Te su at yu néew doxee seen digganteek atum Yiwiku ma, na ko waññ te fey lu ni néewe, ngir jotaat boppam. ");
INSERT INTO wolmbs_vpl VALUES ("LV25_53","004_25_53","LEV","25","53","53","Ab surga lay doon ci njaatigeem at mu nekk, waaye waru koo soxore ci biir kilifteef, ngeen di seetaan. ");
INSERT INTO wolmbs_vpl VALUES ("LV25_54","004_25_54","LEV","25","54","54","Su fekkee ne jotaatuñu ko ci jotin yooyu sax, war naa moom boppam mooki doomam ca atum Yiwiku ma. ");
INSERT INTO wolmbs_vpl VALUES ("LV25_55","004_25_55","LEV","25","55","55","Ndax kat man la bànni Israayil di samay jaam. Ñoo di sama jaam ya ma génne réewum Misra; yeen, maay seen Yàlla Aji Sax ji. ");
INSERT INTO wolmbs_vpl VALUES ("LV26_1","004_26_1","LEV","26","1","1","«Buleen sàkkal seen bopp ay yàllantu, du lenn luy jëmmu tuur mbaa tuuru doj wu ngeen sampal seen bopp, te doj wu ñu ñaas ay nataal it, buleen ko sàkkal béreb ci seen réew, di ko sujjóotal, ndax man Aji Sax ji maay seen Yàlla. ");
INSERT INTO wolmbs_vpl VALUES ("LV26_2","004_26_2","LEV","26","2","2","Samay bési Noflaay nag wormaalleen ko, te sama béreb bu sell teralleen ko. Maay Aji Sax ji. ");
INSERT INTO wolmbs_vpl VALUES ("LV26_3","004_26_3","LEV","26","3","3","«Su ngeen dee topp samay dogal, fonk samay santaane te di ko jëfe, ");
INSERT INTO wolmbs_vpl VALUES ("LV26_4","004_26_4","LEV","26","4","4","kon maa leen di tawal ci waxtoom, suuf si nangu, garab yi meññ. ");
INSERT INTO wolmbs_vpl VALUES ("LV26_5","004_26_5","LEV","26","5","5","Dingeen bàcc ba keroog wittum reseñ jot te dingeen witt reseñ ba jamonoy ji jot. Dingeen lekk seenum pepp ba suur këll te dingeen dëkk ak jàmm ci seenum réew. ");
INSERT INTO wolmbs_vpl VALUES ("LV26_6","004_26_6","LEV","26","6","6","«Maay baaxee réew mi jàmm it, ba bu ngeen tëddee kenn du leen tiital. Maay jële rab wu aay ci réew mi, te saamar du jóg, dal ci seenum réew. ");
INSERT INTO wolmbs_vpl VALUES ("LV26_7","004_26_7","LEV","26","7","7","Kon dingeen dàq seeni noon, saamar ba dal, ñu daanu fi seen kanam. ");
INSERT INTO wolmbs_vpl VALUES ("LV26_8","004_26_8","LEV","26","8","8","Seen juróomi nit ay dàq téeméer (100), seen téeméeri nit dàq fukki junni (10 000). Seeni noon la saamar di dal, ñu daanu fi seen kanam. ");
INSERT INTO wolmbs_vpl VALUES ("LV26_9","004_26_9","LEV","26","9","9","«Te itam maa leen di baaxe, giiral leen, yokk leen. Dinaa sàmm sama kóllëreek yeen. ");
INSERT INTO wolmbs_vpl VALUES ("LV26_10","004_26_10","LEV","26","10","10","Dingeen lekk ngóob mu yàgg, dence lu yàgg, ba far génne mu yàgg ma, wuutal fa mu bees. ");
INSERT INTO wolmbs_vpl VALUES ("LV26_11","004_26_11","LEV","26","11","11","«Maay samp sama kër ci seen biir te duma leen seexlu. ");
INSERT INTO wolmbs_vpl VALUES ("LV26_12","004_26_12","LEV","26","12","12","Maay ànd ak yeen, di seen Yàlla, ngeen di sama ñoñ. ");
INSERT INTO wolmbs_vpl VALUES ("LV26_13","004_26_13","LEV","26","13","13","Man Aji Sax ji maay seen Yàlla ji leen génne réewum Misra, ngeen noppee doon seeni jaam; maa dog seen buumi njaam, siggil leen. ");
INSERT INTO wolmbs_vpl VALUES ("LV26_14","004_26_14","LEV","26","14","14","«Waaye bu ngeen ma déggalul te baña jëfe sama santaane yooyu yépp, ");
INSERT INTO wolmbs_vpl VALUES ("LV26_15","004_26_15","LEV","26","15","15","su ngeen teddadilee samay dogal, dëddu samay ndigal, ba jëfewuleen sama santaane yépp, xanaa di fecci sama kóllëreek yeen, ");
INSERT INTO wolmbs_vpl VALUES ("LV26_16","004_26_16","LEV","26","16","16","su boobaa li may def ak yeen mooy lii: Maay jekki wàcce njàqare ci seen kaw, mu ànd ak woppi ràgg, yaram wu tàng jérr ak bët yu lëndëm, ngeen gën di wopp. Dingeen ji seenum pepp ci neen, ndax seeni noon a koy lekk. ");
INSERT INTO wolmbs_vpl VALUES ("LV26_17","004_26_17","LEV","26","17","17","Maa leen di noonoo ba seeni noon duma leen, seeni bañ yilif leen. Dingeen daw te kenn dàqu leen. ");
INSERT INTO wolmbs_vpl VALUES ("LV26_18","004_26_18","LEV","26","18","18","«Bu loolu taxul ngeen déggal ma, maa leen di mbugal lu ko ëpp, fukki yoon ak juróom, feye leen ko seeni bàkkaar. ");
INSERT INTO wolmbs_vpl VALUES ("LV26_19","004_26_19","LEV","26","19","19","Maay sàggi seen sag bu réy. Maay def asamaan si leen tiim ne sereŋ nig weñ, suuf si wow koŋŋ ni xànjar. ");
INSERT INTO wolmbs_vpl VALUES ("LV26_20","004_26_20","LEV","26","20","20","Seen doole dina kasara, ndax suuf si ngeen di bey du leen nangul te garabi réew mi du meññ. ");
INSERT INTO wolmbs_vpl VALUES ("LV26_21","004_26_21","LEV","26","21","21","«Su ngeen saxee ci noonoo ma, bañ maa déggal, maay fulaat seen mbugal fukki yoon ak juróom, feye leen ko seeni bàkkaar. ");
INSERT INTO wolmbs_vpl VALUES ("LV26_22","004_26_22","LEV","26","22","22","Maay xabtal rabi àll yi ci seen kaw, ñu xañ leen seeni doom, seeni gétt ñu tas, seeni nit ñu néewal, ba seeni mbedd ne wëyëŋ. ");
INSERT INTO wolmbs_vpl VALUES ("LV26_23","004_26_23","LEV","26","23","23","«Su ma leen loolu yaralul ba tey, xanaa ngeen sax ci noonoo ma, ");
INSERT INTO wolmbs_vpl VALUES ("LV26_24","004_26_24","LEV","26","24","24","su boobaa man itam maa leen di noonoo, te it man ci sama bopp maa leen di mbugalaat lu ko ëpp, fukki yoon ak juróom, feye leen ko seeni bàkkaar. ");
INSERT INTO wolmbs_vpl VALUES ("LV26_25","004_26_25","LEV","26","25","25","Maay dalal saamar ci seen kaw, feye leen ko kóllëre gi ngeen fecci. Bu ngeen làqoo ci seeni biir dëkk yu mag sax, maay wàcce mbas ci seen biir, seeni noon jekku leen. ");
INSERT INTO wolmbs_vpl VALUES ("LV26_26","004_26_26","LEV","26","26","26","Bu ma téyee loxo bi ma leen di leele, fukki jigéen dinañu bokk lakk seen mburum njël ci benn taal doŋŋ, natt ko ay somp, séddale, ngeen lekk, te dungeen suur. ");
INSERT INTO wolmbs_vpl VALUES ("LV26_27","004_26_27","LEV","26","27","27","«Waaye bu loolu weesoo te déggaluleen ma, xanaa di ma noonoo ba tey, ");
INSERT INTO wolmbs_vpl VALUES ("LV26_28","004_26_28","LEV","26","28","28","su boobaa ma gën leena mereeti, noonoo leen, te man ci sama bopp maa leen di mbugalati lu ko ëpp, fukki yoon ak juróom, feye leen ko seen bàkkaar. ");
INSERT INTO wolmbs_vpl VALUES ("LV26_29","004_26_29","LEV","26","29","29","Dingeen yàpp seeni doom yu góor, yàpp seen doom yu jigéen ndax xiif. ");
INSERT INTO wolmbs_vpl VALUES ("LV26_30","004_26_30","LEV","26","30","30","Dinaa tas seen bérebi jaamookaay, toj seeni suurukaay. Seen kasaray tuur yi ne làcc, ma jal ca seeni néew. Maa leen di seexlu, ");
INSERT INTO wolmbs_vpl VALUES ("LV26_31","004_26_31","LEV","26","31","31","gental seen dëkk yu mag, tas seen béreb yu sell, te dootuma faale xetug jàmm ca seeni sarax. ");
INSERT INTO wolmbs_vpl VALUES ("LV26_32","004_26_32","LEV","26","32","32","Maay tas seenum réew, ba seen noon ya ko nangu yéemu ca. ");
INSERT INTO wolmbs_vpl VALUES ("LV26_33","004_26_33","LEV","26","33","33","Yeen nag maa leen di tasaare ci biir xeet yi, ndax maay génne saamar mbaram, mu dal ci seen kaw. Seenum réew dina wéet, seen dëkk yu mag gent. ");
INSERT INTO wolmbs_vpl VALUES ("LV26_34","004_26_34","LEV","26","34","34","«Su boobaa mboolem diir ba suuf di wéet moom lay daboo Ati Noflaayam, fekk yeen ngeen nekk ca seen réewu noon ya. Su ko defee suuf si dina noppalu moos, ba daboo ko Ati Noflaayam. ");
INSERT INTO wolmbs_vpl VALUES ("LV26_35","004_26_35","LEV","26","35","35","Mboolem diir bi suuf siy wéet, moom lay noppaloo la mu noppaluwuloon, ba leen ay Ati Noflaay fekkee ngeen dëkk fa. ");
INSERT INTO wolmbs_vpl VALUES ("LV26_36","004_26_36","LEV","26","36","36","«Ñi des ci yeen, dinaa indi njàqare ci seen xol, foofa ngeen nekk ca seen réewu noon ya, ba xob wu ne foyfoy ngeen daw. Dingeen xélu ni ku ñuy dàqe saamar, bay daanu, te dàqeesu leen. ");
INSERT INTO wolmbs_vpl VALUES ("LV26_37","004_26_37","LEV","26","37","37","Dingeen fakkastalante di daw, ni ñu ñuy dàqe saamar, te dàqeesu leen, ba dungeen mana taxaw ci seen kanami noon. ");
INSERT INTO wolmbs_vpl VALUES ("LV26_38","004_26_38","LEV","26","38","38","Dingeen deewe àll, te seen suufu noon yaa leen di lekk. ");
INSERT INTO wolmbs_vpl VALUES ("LV26_39","004_26_39","LEV","26","39","39","Ñi des ci yeen dinañu ràgg ca seen réewi noon ndax seeni bàkkaar ak seen bàkkaari maam. ");
INSERT INTO wolmbs_vpl VALUES ("LV26_40","004_26_40","LEV","26","40","40","«Su ko defee ñoom dinañu tudd seen bàkkaar ak seen bàkkaaru maam ya, ndax dañu maa wor te dëkke maa noonoo, ");
INSERT INTO wolmbs_vpl VALUES ("LV26_41","004_26_41","LEV","26","41","41","ba man itam ma noonoo leen, toxal leen seen réewu noon. Bu ñu tuubee seen xol bu dëgër nag, ba matal seen mbugal yi sababoo ci seeni ñaawtéef, ");
INSERT INTO wolmbs_vpl VALUES ("LV26_42","004_26_42","LEV","26","42","42","su boobaa maay bàyyi xel ci sama kóllëre gaak Yanqóoba ak sama kóllëre gaak Isaaxa ak sama kóllëre gaak Ibraayma, te duma fàtte li ma dige ci wàllu réew mi. ");
INSERT INTO wolmbs_vpl VALUES ("LV26_43","004_26_43","LEV","26","43","43","«Waaye réew mi dinañu ko gental, mu daboo Ati Noflaayam diir ba ñu ko dëddoo, wéetal ko, te fekk ñoom ñuy fey seen boru tooñ; ndax kat dañoo sofental samay santaane, xalab samay dogal. ");
INSERT INTO wolmbs_vpl VALUES ("LV26_44","004_26_44","LEV","26","44","44","Ndaxam du tax ma sofental leen ca seen réewu noon, mbaa ma di leen xalab, di leen faagaagal, nde kon ma fecci sama kóllëreek ñoom. Ndax man Aji Sax ji maay seen Yàlla. ");
INSERT INTO wolmbs_vpl VALUES ("LV26_45","004_26_45","LEV","26","45","45","Maa leen di bàyyil xel ci sama kóllëre gaak seen maam ya ma génne réewum Misra, jàmbur ñi seede, ngir doon seen Yàlla. Maay Aji Sax ji.» ");
INSERT INTO wolmbs_vpl VALUES ("LV26_46","004_26_46","LEV","26","46","46","Looloo di dogal yaak santaane yaak ndigali yoon ya Aji Sax ji tëral ca digganteem ak bànni Israayil ca kaw tundu Sinayi, Musaa jottali leen ko. ");
INSERT INTO wolmbs_vpl VALUES ("LV27_1","004_27_1","LEV","27","1","1","Ba loolu weesoo Aji Sax ji wax na Musaa ne ko: ");
INSERT INTO wolmbs_vpl VALUES ("LV27_2","004_27_2","LEV","27","2","2","«Waxal bànni Israayil ne leen: Képp ku dogoo jagleel Aji Sax ji nit, man naa wàccook kàddoom ci kaw nii ñu ko xaymaa. ");
INSERT INTO wolmbs_vpl VALUES ("LV27_3","004_27_3","LEV","27","3","3","Su dee góor gu am ñaar fukki at ba juróom benn fukki at, nanga ko xayma ci juróom fukki dogi xaalis, ci xaalisu béreb bu sell bi. ");
INSERT INTO wolmbs_vpl VALUES ("LV27_4","004_27_4","LEV","27","4","4","Su dee jigéen, nanga ko xayma ci fanweeri dogi xaalis. ");
INSERT INTO wolmbs_vpl VALUES ("LV27_5","004_27_5","LEV","27","5","5","Su amee juróomi at ba ñaar fukki at, danga koy xayma ci ñaar fukki dogi xaalis, su dee góor, mbaa fukki dogi xaalis, su dee jigéen. ");
INSERT INTO wolmbs_vpl VALUES ("LV27_6","004_27_6","LEV","27","6","6","Su dee ku am weer jàpp juróomi at, nanga ko xayma ci juróomi dogi xaalis su dee góor; mbaa ñetti dogi xaalis su dee jigéen. ");
INSERT INTO wolmbs_vpl VALUES ("LV27_7","004_27_7","LEV","27","7","7","Su dee ku am juróom benn fukki at ak lu ko ëpp, nanga ko xayma ci fukki dogi xaalis ak juróom su dee góor; mbaa fukki dogi xaalis su dee jigéen. ");
INSERT INTO wolmbs_vpl VALUES ("LV27_8","004_27_8","LEV","27","8","8","Su fekkee ne ki dogu woona jagleel nit ki Aji Sax ji da di ku am-amam yées sa xayma, na kooku yóbbu nit ki ba ca sarxalkat ba, sarxalkat bi xaymaal ko nit ki ci lu dëppook am-amam, moom mi dogu woon. ");
INSERT INTO wolmbs_vpl VALUES ("LV27_9","004_27_9","LEV","27","9","9","«Su fekkee ne la ñu dogu woona joxe ag jur la gu dagana sarxalal Aji Sax ji, day daldi sell. ");
INSERT INTO wolmbs_vpl VALUES ("LV27_10","004_27_10","LEV","27","10","10","Deesu ko weccee. Du jur gu baax gu ñu ko mana wuutoo, doonte jur gu bon la, te du jur gu bon gu ñu ko mana wuutoo, te fekk muy gu baax. Ci biir jagleel googu ku xasa wuutoo ag jur moroom ma, jur gu njëkk gaak kuutaay la dañuy bokk doon lu sell. ");
INSERT INTO wolmbs_vpl VALUES ("LV27_11","004_27_11","LEV","27","11","11","Su fekkee ne la ñu dogu woona joxe mala mu daganul la te daganula sarxalal Aji Sax ji, na nit ki yóbbu jur ga ba ca sarxalkat ba, ");
INSERT INTO wolmbs_vpl VALUES ("LV27_12","004_27_12","LEV","27","12","12","sarxalkat ba xayma ko. Su baaxee su bonee, lu mu ci dogal mooy wéy. ");
INSERT INTO wolmbs_vpl VALUES ("LV27_13","004_27_13","LEV","27","13","13","Su ko boroom bëggee jotaat, day fey njëg ga, yokk ca xaajub juróomeelu njëg ga. ");
INSERT INTO wolmbs_vpl VALUES ("LV27_14","004_27_14","LEV","27","14","14","«Su nit jagleelee Aji Sax ji dëkkuwaayam, sellalal ko ko, na sarxalkat bi xayma dëkkuwaay bi. Su baaxee su bonee, lu mu ci dogal mooy wéy. ");
INSERT INTO wolmbs_vpl VALUES ("LV27_15","004_27_15","LEV","27","15","15","Su fekkee ne ki dogu woona joxe dëkkuwaayam da koo bëgga jotaat, day fey njëg ga ñu ko xaymaa, yokk ca xaajub juróomeelam, mu doonaat alalam. ");
INSERT INTO wolmbs_vpl VALUES ("LV27_16","004_27_16","LEV","27","16","16","«Su nit jagleelee Aji Sax ji suuf su mu moom ci suufas ndonoom, na ñuy xaymaa suuf sa, na dëppook dayob pepp bay mat jiwum suuf sa. Ñetti barigoy peppum lors yu ne juróom fukki dogi xaalis a koy wecci. ");
INSERT INTO wolmbs_vpl VALUES ("LV27_17","004_27_17","LEV","27","17","17","Su fekkee ne ci atum Yiwiku la joxe suuf si, xaymab suuf si day mat sëkk ànd ak moom. ");
INSERT INTO wolmbs_vpl VALUES ("LV27_18","004_27_18","LEV","27","18","18","Waaye su fekkee ne gannaaw atum Yiwiku la joxe suuf si, sarxalkat bi da koy nattal njëg gi ci at yi dox seen digganteek atum Yiwiku ma ca topp, génne ca at ya wees. ");
INSERT INTO wolmbs_vpl VALUES ("LV27_19","004_27_19","LEV","27","19","19","Su fekkee ne ki dogu woona joxe tool bi da koo bëgga jotaat, day fey njëg ga ñu ko xaymaa, yokk ca xaajub juróomeelam, mu doonaat alalam. ");
INSERT INTO wolmbs_vpl VALUES ("LV27_20","004_27_20","LEV","27","20","20","Su jotaatul tool bi, ba ñu jaay tool bi keneen, deesu ko mana jotaat. ");
INSERT INTO wolmbs_vpl VALUES ("LV27_21","004_27_21","LEV","27","21","21","Bu tool bi yiwikoo ci atum Yiwiku nag, day daldi doon lu ñu sellalal Aji Sax ji, mel ni tool bu ñu aaye, mu doon alalu sarxalkat. ");
INSERT INTO wolmbs_vpl VALUES ("LV27_22","004_27_22","LEV","27","22","22","«Su fekkee ne nit ki dafa jagleel Aji Sax ji tool bu mu jënd, te donnu ko, ");
INSERT INTO wolmbs_vpl VALUES ("LV27_23","004_27_23","LEV","27","23","23","sarxalkat bi da koy xaymaal njëg gi, méngale kook at yi dox seen digganteek atum Yiwiku may ñëw. Na nit ki fey la ñu xayma ca bés ba, xaalis ba di lu ñuy sellalal Aji Sax ji. ");
INSERT INTO wolmbs_vpl VALUES ("LV27_24","004_27_24","LEV","27","24","24","Bu atum Yiwiku dikkee, tool bi day dellu ca ka ñu ko jënde woon te mu di alalu ndonoom. ");
INSERT INTO wolmbs_vpl VALUES ("LV27_25","004_27_25","LEV","27","25","25","Mboolem lu ngeen xayma, na dëppook natt ba ñu yoonal ci béreb bu sell bi, maanaam li ñuy wax siikal te mu tollu ci ñaar fukki gera. ");
INSERT INTO wolmbs_vpl VALUES ("LV27_26","004_27_26","LEV","27","26","26","«Waaye kat luy taaw cig jur, Aji Sax jee ko moom jeeg. Du lu kenn di dogoo jagleel Aji Sax ji. Muy barmol, muy mbote, muy tef, Aji Sax jeey boroom. ");
INSERT INTO wolmbs_vpl VALUES ("LV27_27","004_27_27","LEV","27","27","27","Su dee lu mala mu daganul taawloo, ka ko moomoon man na koo jotaat ndegam fey na njëgam, ba dolli ca xaajub juróomeelu njëg ga. Bu ñu ko jotaatul, dees koy jaay ci njëg gi ñu ko xaymaa. ");
INSERT INTO wolmbs_vpl VALUES ("LV27_28","004_27_28","LEV","27","28","28","Mboolem lu ñu aaye ngir Aji Sax ji, lu sella sell la ñeel Aji Sax ji. Lépp lu nit moom, su dee nit mbaa jur mbaa suuf su mu donn, amu ci lenn lu nit aaye ngir Aji Sax ji te ñu sañ koo jaay mbaa mu di ko jotaat. ");
INSERT INTO wolmbs_vpl VALUES ("LV27_29","004_27_29","LEV","27","29","29","Ba tey du kenn nit ku ñu aaye bakkanam ngir Aji Sax ji, mu wara sànku, ba noppi ñu di ko jotaat. Dees koy rey rekk. ");
INSERT INTO wolmbs_vpl VALUES ("LV27_30","004_27_30","LEV","27","30","30","«Bu loolu weesoo mboolem lu jóge ci suuf, muy pepp mbaa doomi garab, cérub fukkeel ba Aji Sax jeey boroom. Dees koy sellalal Aji Sax ji. ");
INSERT INTO wolmbs_vpl VALUES ("LV27_31","004_27_31","LEV","27","31","31","Su fekkee ne nit ki dafa namma jotaat lenn ca céru fukkeelu meññeefam ma muy génne, day yokk ca njëg ga xaajub juróomeelam. ");
INSERT INTO wolmbs_vpl VALUES ("LV27_32","004_27_32","LEV","27","32","32","Mboolem céru fukkeel bu ñu génnee cig jur, gu gudd gaak gu gàtt ga, muy lépp lu sàmm waññe bantam, cérub fukkeel la bu ñuy sellalal Aji Sax ji. ");
INSERT INTO wolmbs_vpl VALUES ("LV27_33","004_27_33","LEV","27","33","33","Deesu ci seet jur gu baax ak gu bon te deesu ci wuutal lenn. Bu ci nit xasee wuutal lenn, la njëkk ak la ko wuutu lépp day daldi doon lu sell. Deesu ko mana jotaat.» ");
INSERT INTO wolmbs_vpl VALUES ("LV27_34","004_27_34","LEV","27","34","34","Yooyu santaane la Aji Sax ji dénkoon Musaa ca tundu Sinayi, ngir mu jottali ko bànni Israayil. ");
INSERT INTO wolmbs_vpl VALUES ("NU1_1","005_1_1","NUM","1","1","1","Aji Sax ji moo wax ak Musaa ca màndiŋu Sinayi ca biir xaymab ndaje ma, keroog benn fanu ñaareelu weer wu ñaareelu at, ma topp ca gàddaay ga bawoo Misra. Mu ne ko: ");
INSERT INTO wolmbs_vpl VALUES ("NU1_2","005_1_2","NUM","1","2","2","«Limleen mbooloom bànni Israayil gépp, na ñu bokke seeni làng ak seen këri maam. Waññleen góor ñépp, bopp ak bopp, ku nekk ak turam. ");
INSERT INTO wolmbs_vpl VALUES ("NU1_3","005_1_3","NUM","1","3","3","Li ko dale ñaar fukki at, jëm kaw, mboolem ñi xare war ci Israayil daal, nangeen leen lim, gàngoor ak gàngoor, yaw ak Aaróona. ");
INSERT INTO wolmbs_vpl VALUES ("NU1_4","005_1_4","NUM","1","4","4","Giir gu ci nekk, àndleen ceek kilifa yi jiite seen këri maam, ñu jàppale leen ci. ");
INSERT INTO wolmbs_vpl VALUES ("NU1_5","005_1_5","NUM","1","5","5","Ñiy wuyoo tur yii nag, ñoo leen ciy taxawu: Ci wàllu Rubeneen ñi, Elicur doomu Sedeyur. ");
INSERT INTO wolmbs_vpl VALUES ("NU1_6","005_1_6","NUM","1","6","6","Wàllu Cimyoneen ñi, Selumyel doomu Curisadaay. ");
INSERT INTO wolmbs_vpl VALUES ("NU1_7","005_1_7","NUM","1","7","7","Wàllu Yudeen ñi, Naason doomu Aminadab. ");
INSERT INTO wolmbs_vpl VALUES ("NU1_8","005_1_8","NUM","1","8","8","Wàllu Isakareen ñi, Netaneel doomu Cuwar. ");
INSERT INTO wolmbs_vpl VALUES ("NU1_9","005_1_9","NUM","1","9","9","Wàllu Cabuloneen ñi, Elyab doomu Elon. ");
INSERT INTO wolmbs_vpl VALUES ("NU1_10","005_1_10","NUM","1","10","10","Ñi ciy askanu Yuusufa ñii la: Ci wàllu Efraymeen ñi, Elisama doomu Amiyudd. Wàllu Manaseen ñi, Gamliyel doomu Pedacur. ");
INSERT INTO wolmbs_vpl VALUES ("NU1_11","005_1_11","NUM","1","11","11","Wàllu Beñamineen ñi, Abidan doomu Gidoni. ");
INSERT INTO wolmbs_vpl VALUES ("NU1_12","005_1_12","NUM","1","12","12","Wàllu Daneen ñi, Axyeser doomu Amisadaay. ");
INSERT INTO wolmbs_vpl VALUES ("NU1_13","005_1_13","NUM","1","13","13","Wàllu Asereen ñi, Pagyel doomu Okkran. ");
INSERT INTO wolmbs_vpl VALUES ("NU1_14","005_1_14","NUM","1","14","14","Wàllu Gàddeen ñi, Elyasaf doomu Dewel. ");
INSERT INTO wolmbs_vpl VALUES ("NU1_15","005_1_15","NUM","1","15","15","Wàllu Neftaleen ñi, Axira doomu Enan.» ");
INSERT INTO wolmbs_vpl VALUES ("NU1_16","005_1_16","NUM","1","16","16","Ñooñu lañu woo ci mbooloo mi, muy ñi jiite seen giiri maam. Ñooy njiiti gàngoori Israayil. ");
INSERT INTO wolmbs_vpl VALUES ("NU1_17","005_1_17","NUM","1","17","17","Ba loolu amee Musaa ak Aaróona tofloo ñooñu ñu tudd seeni tur, ");
INSERT INTO wolmbs_vpl VALUES ("NU1_18","005_1_18","NUM","1","18","18","ñu dajale mbooloo ma mépp, keroog ca benn fanu ñaareelu weer wa. La ko dale ca ña am ñaar fukki at, jëm kaw, ñoom ñépp daldi bindu ca limeefu tur ya, ku nekk ak kër maamam, giir ak giir, làng ak làng, bopp ak bopp. ");
INSERT INTO wolmbs_vpl VALUES ("NU1_19","005_1_19","NUM","1","19","19","Noonee ko Aji Sax ji sante woon Musaa, na la Musaa takke seen lim ca màndiŋu Sinayi. ");
INSERT INTO wolmbs_vpl VALUES ("NU1_20","005_1_20","NUM","1","20","20","Ñu lim bopp ak bopp, turi sëti Ruben taawub Israayil seen maam, ku nekk ak làngu cosaanam ak kër maamam, mboolem góor ñi xare war, te ñu am ñaar fukki at, jëm kaw. ");
INSERT INTO wolmbs_vpl VALUES ("NU1_21","005_1_21","NUM","1","21","21","Limub Rubeneen ñi di ñeent fukki junni ak juróom benn ak juróomi téeméer (46 500). ");
INSERT INTO wolmbs_vpl VALUES ("NU1_22","005_1_22","NUM","1","22","22","Ñu lim bopp ak bopp, turi sëti Simeyon, ku nekk ak làngu cosaanam ak kër maamam, mboolem góor ñi xare war, te ñu am ñaar fukki at, jëm kaw. ");
INSERT INTO wolmbs_vpl VALUES ("NU1_23","005_1_23","NUM","1","23","23","Limub Cimyoneen ñi di juróom fukki junneek juróom ñeent ak ñetti téeméer (59 300). ");
INSERT INTO wolmbs_vpl VALUES ("NU1_24","005_1_24","NUM","1","24","24","Ñu lim turi sëti Gàdd, ku nekk ak làngu cosaanam ak kër maamam, mboolem góor ñi xare war, te ñu am ñaar fukki at, jëm kaw. ");
INSERT INTO wolmbs_vpl VALUES ("NU1_25","005_1_25","NUM","1","25","25","Limub Gàddeen ñi di ñeent fukki junneek juróom ak juróom benni téeméer ak juróom fukk (45 650). ");
INSERT INTO wolmbs_vpl VALUES ("NU1_26","005_1_26","NUM","1","26","26","Ñu lim turi sëti Yuda, ku nekk ak làngu cosaanam ak kër maamam, mboolem góor ñi xare war, te ñu am ñaar fukki at, jëm kaw. ");
INSERT INTO wolmbs_vpl VALUES ("NU1_27","005_1_27","NUM","1","27","27","Limub Yudeen ñi di juróom ñaar fukki junneek ñeent, ak juróom benni téeméer (74 600). ");
INSERT INTO wolmbs_vpl VALUES ("NU1_28","005_1_28","NUM","1","28","28","Ñu lim turi sëti Isaakar, ku nekk ak làngu cosaanam ak kër maamam, mboolem góor ñi xare war, te ñu am ñaar fukki at, jëm kaw. ");
INSERT INTO wolmbs_vpl VALUES ("NU1_29","005_1_29","NUM","1","29","29","Limub Isakareen ñi di juróom fukki junneek ñeent ak ñeenti téeméer (54 400). ");
INSERT INTO wolmbs_vpl VALUES ("NU1_30","005_1_30","NUM","1","30","30","Ñu lim turi sëti Sabulon, ku nekk ak làngu cosaanam ak kër maamam, mboolem góor ñi xare war, te ñu am ñaar fukki at, jëm kaw. ");
INSERT INTO wolmbs_vpl VALUES ("NU1_31","005_1_31","NUM","1","31","31","Limub Cabuloneen ñi di juróom fukki junneek juróom ñaar ak ñeenti téeméer (57 400). ");
INSERT INTO wolmbs_vpl VALUES ("NU1_32","005_1_32","NUM","1","32","32","Ñu lim turi sëti Yuusufa yi askanoo ci doomam Efrayim, ku nekk ak làngu cosaanam ak kër maamam, mboolem góor ñi xare war, te ñu am ñaar fukki at, jëm kaw. ");
INSERT INTO wolmbs_vpl VALUES ("NU1_33","005_1_33","NUM","1","33","33","Limub Efraymeen ñi di ñeent fukki junni ak juróomi téeméer (40 500). ");
INSERT INTO wolmbs_vpl VALUES ("NU1_34","005_1_34","NUM","1","34","34","Ñu lim turi sëti Yuusufa yi askanoo ci doomam Manase, ku nekk ak làngu cosaanam ak kër maamam, mboolem góor ñi xare war, te ñu am ñaar fukki at, jëm kaw. ");
INSERT INTO wolmbs_vpl VALUES ("NU1_35","005_1_35","NUM","1","35","35","Limub Manaseen ñi di fanweeri junneek ñaar ak ñaari téeméer (32 200). ");
INSERT INTO wolmbs_vpl VALUES ("NU1_36","005_1_36","NUM","1","36","36","Ñu lim turi sëti Beñamin, ku nekk ak làngu cosaanam ak kër maamam, mboolem góor ñi xare war, te ñu am ñaar fukki at, jëm kaw. ");
INSERT INTO wolmbs_vpl VALUES ("NU1_37","005_1_37","NUM","1","37","37","Limub Beñamineen ñi di fanweeri junneek juróom ak ñeenti téeméer (35 400). ");
INSERT INTO wolmbs_vpl VALUES ("NU1_38","005_1_38","NUM","1","38","38","Ñu lim turi sëti Dan, ku nekk ak làngu cosaanam ak kër maamam, mboolem góor ñi xare war, te ñu am ñaar fukki at, jëm kaw. ");
INSERT INTO wolmbs_vpl VALUES ("NU1_39","005_1_39","NUM","1","39","39","Limub Daneen ñi di juróom benn fukki junneek ñaar ak juróom ñaari téeméer (62 700). ");
INSERT INTO wolmbs_vpl VALUES ("NU1_40","005_1_40","NUM","1","40","40","Ñu lim turi sëti Aser, ku nekk ak làngam ak kër maamam, mboolem góor ñi xare war, te ñu am ñaar fukki at, jëm kaw. ");
INSERT INTO wolmbs_vpl VALUES ("NU1_41","005_1_41","NUM","1","41","41","Limub Asereen ñi di ñeent fukki junneek benn ak juróomi téeméer (41 500). ");
INSERT INTO wolmbs_vpl VALUES ("NU1_42","005_1_42","NUM","1","42","42","Ñu lim turi sëti Neftali, ku nekk ak làngu cosaanam ak kër maamam, mboolem ñi xare war, te ñu am ñaar fukki at, jëm kaw. ");
INSERT INTO wolmbs_vpl VALUES ("NU1_43","005_1_43","NUM","1","43","43","Limub Neftaleen ñi di juróom fukki junneek ñett ak ñeenti téeméer (53 400). ");
INSERT INTO wolmbs_vpl VALUES ("NU1_44","005_1_44","NUM","1","44","44","Yooyu limeef la Musaa ak Aaróona tënk, ña leen ca jàppale di fukki kilifay Israayil ak ñaar, ku ci nekk taxawal kër maamam. ");
INSERT INTO wolmbs_vpl VALUES ("NU1_45","005_1_45","NUM","1","45","45","Mboolem bànni Israayil yi xare war, te ñu am ñaar fukki at, jëm kaw, limees na leen, ku ci nekk ak kër maamam. ");
INSERT INTO wolmbs_vpl VALUES ("NU1_46","005_1_46","NUM","1","46","46","Ña ñu lim ñépp di juróom benn téeméeri junneek ñett ak juróomi téeméer ak juróom fukk (603 550). ");
INSERT INTO wolmbs_vpl VALUES ("NU1_47","005_1_47","NUM","1","47","47","Giirug Leween ñi nag ci bànni Israayil lañu bokk, waaye limaaleesu leen ak ñoom. ");
INSERT INTO wolmbs_vpl VALUES ("NU1_48","005_1_48","NUM","1","48","48","Aji Sax ji moo waxoon Musaa, ne ko: ");
INSERT INTO wolmbs_vpl VALUES ("NU1_49","005_1_49","NUM","1","49","49","«Giirug Lewi ñoom, bu leen lim, bu leen waññaaleek bànni Israayil. ");
INSERT INTO wolmbs_vpl VALUES ("NU1_50","005_1_50","NUM","1","50","50","Waaye yaw ci sa bopp nanga sas Leween ñi jaamookaay bi seedes kóllëre gi dence, mook la muy àndal lépp, ak mboolem lu ca bokk. Ñooy gàddu jaamookaay bi, ak la muy àndal lépp, di ko toppatoo, te it fi wër jaamookaay bi lañuy dal. ");
INSERT INTO wolmbs_vpl VALUES ("NU1_51","005_1_51","NUM","1","51","51","Bu jaamookaay bi dee dem, Leween ñee koy wékki, bu jaamookaay bi dee dale béreb, Leween ñee koy we. Ku ci bokkul ba laal ci nag, dees koy rey. ");
INSERT INTO wolmbs_vpl VALUES ("NU1_52","005_1_52","NUM","1","52","52","Bànni Israayil gi ci des, na ku ci nekk topp dalam, ak raayaam ak kuréelam. ");
INSERT INTO wolmbs_vpl VALUES ("NU1_53","005_1_53","NUM","1","53","53","Leween ñi nag nañu dal fi wër jaamookaay bi seedes kóllëre gi dence. Su ko defee sama sànj du dal ci kaw mbooloom bànni Israayil. Te itam na Leween ñi sàmm ndénkaaneb jaamookaay bi seedes kóllëre gi dence.» ");
INSERT INTO wolmbs_vpl VALUES ("NU1_54","005_1_54","NUM","1","54","54","Bànni Israayil daldi def noonu. Mboolem lu Aji Sax ji santoon Musaa, noonee lañu ko defe. ");
INSERT INTO wolmbs_vpl VALUES ("NU2_1","005_2_1","NUM","2","1","1","Ba loolu wéyee Aji Sax ji wax Musaa ak Aaróona, ne leen: ");
INSERT INTO wolmbs_vpl VALUES ("NU2_2","005_2_2","NUM","2","2","2","«Na bànni Israayil di dal, ku nekk ak raayaam ak xàmmikaayu kër maamam. Fi wër xaymab ndaje mi te dànd ko as lëf, fi lañuy dale: ");
INSERT INTO wolmbs_vpl VALUES ("NU2_3","005_2_3","NUM","2","3","3","«Ñay dale ca kanam, fa féete penku, ñooy waa raayab Yuda ak seeni gàngoor, kilifag Yudeen ñi di Naason doomu Aminadab. ");
INSERT INTO wolmbs_vpl VALUES ("NU2_4","005_2_4","NUM","2","4","4","Ña ñu lim ci gàngooram di juróom ñaar fukki junneek ñeent ak juróom benni téeméer (74 600). ");
INSERT INTO wolmbs_vpl VALUES ("NU2_5","005_2_5","NUM","2","5","5","«Ñay dale fa feggook ñoom ñooy giirug Isakareen ñi, kilifag askanu Isaakar di Netaneel doomu Cuwar. ");
INSERT INTO wolmbs_vpl VALUES ("NU2_6","005_2_6","NUM","2","6","6","Ña ñu lim ci gàngooram di juróom fukki junneek ñeent ak ñeenti téeméer (54 400). ");
INSERT INTO wolmbs_vpl VALUES ("NU2_7","005_2_7","NUM","2","7","7","«Giirug Cabuloneen ñeey feggook ñoom, kilifag askanu Sabulon di Elyab doomu Elon. ");
INSERT INTO wolmbs_vpl VALUES ("NU2_8","005_2_8","NUM","2","8","8","Ña ñu limal gàngooram di juróom fukki junneek juróom ñaar ak ñeenti téeméer (57 400). ");
INSERT INTO wolmbs_vpl VALUES ("NU2_9","005_2_9","NUM","2","9","9","«Mboolem ña ñu limal dalub Yuda aki gàngooram daldi doon téeméeri junneek juróom ñett fukk ak juróom benn ak ñeenti téeméer (186 400). Bu ñuy dem, ñooñooy dox, jiitu. ");
INSERT INTO wolmbs_vpl VALUES ("NU2_10","005_2_10","NUM","2","10","10","«Waa raayab Ruben ñooy dale bëj-saalum, ñook seeni gàngoor, kilifag askanu Ruben di Elicur doomu Sedeyur. ");
INSERT INTO wolmbs_vpl VALUES ("NU2_11","005_2_11","NUM","2","11","11","Ña ñu limal gàngooram di ñeent fukki junneek juróom benn ak juróomi téeméer (46 500). ");
INSERT INTO wolmbs_vpl VALUES ("NU2_12","005_2_12","NUM","2","12","12","«Ñay dale fa feggook ñoom ñooy giirug Cimyoneen ñi, kilifag askanu Simeyon di Selumyel doomu Curisadaay. ");
INSERT INTO wolmbs_vpl VALUES ("NU2_13","005_2_13","NUM","2","13","13","Ña ñu limal gàngooram di juróom fukki junneek juróom ñeent ak ñetti téeméer (59 300). ");
INSERT INTO wolmbs_vpl VALUES ("NU2_14","005_2_14","NUM","2","14","14","«Giiru Gàddeen ñeey feggook ñoom, kilifag askanu Gàdd di Elyasaf doomu Rewel. ");
INSERT INTO wolmbs_vpl VALUES ("NU2_15","005_2_15","NUM","2","15","15","Ña ñu limal gàngooram di ñeent fukki junneek juróom ak juróom benni téeméer ak juróom fukk (45 650). ");
INSERT INTO wolmbs_vpl VALUES ("NU2_16","005_2_16","NUM","2","16","16","«Mboolem ña ñu limal dalub Ruben aki gàngooram doon téeméeri junneek juróom fukk ak benn, ak ñeenti téeméer ak juróom fukk (151 450). Bu ñuy dem, ñooñooy doon ñaareelu kuréel, dox, topp ca. ");
INSERT INTO wolmbs_vpl VALUES ("NU2_17","005_2_17","NUM","2","17","17","«Su ko defee xaymab ndaje mi jóg topp ca, ànd ak Leween ñi koy gàddu, te seen dal nekk ci digg dal yi. Noonee kuréel yiy dale daal, ni lañuy jóge dem, ku nekk topp ayam ak raayaam. ");
INSERT INTO wolmbs_vpl VALUES ("NU2_18","005_2_18","NUM","2","18","18","«Waa raayab Efrayim ñooy dale wetu sowu, ñook seeni gàngoor, kilifag askanu Efrayim di Elisama doomu Amiyudd. ");
INSERT INTO wolmbs_vpl VALUES ("NU2_19","005_2_19","NUM","2","19","19","Ña ñu limal gàngooram di ñeent fukki junni ak juróomi téeméer (40 500). ");
INSERT INTO wolmbs_vpl VALUES ("NU2_20","005_2_20","NUM","2","20","20","«Ñay dale fa feggook ñoom ñooy giirug Manaseen ñi, kilifag askanu Manase di Gamliyel doomu Pedacur. ");
INSERT INTO wolmbs_vpl VALUES ("NU2_21","005_2_21","NUM","2","21","21","Ña ñu limal gàngooram di fanweeri junneek ñaar ak ñaari téeméer (32 200). ");
INSERT INTO wolmbs_vpl VALUES ("NU2_22","005_2_22","NUM","2","22","22","«Giirug Beñamineen ñeey feggook ñoom, kilifag askanu Beñamin di Abidan doomu Gidoni. ");
INSERT INTO wolmbs_vpl VALUES ("NU2_23","005_2_23","NUM","2","23","23","Ña ñu limal gàngooram di fanweeri junneek juróom ak ñeenti téeméer (35 400). ");
INSERT INTO wolmbs_vpl VALUES ("NU2_24","005_2_24","NUM","2","24","24","«Mboolem ña ñu limal dalub Efrayim aki gàngooram daldi doon téeméeri junneek juróom ñett ak téeméer (108 100). Bu ñuy dem, ñooñoo di ñetteelu kuréel, dox topp ca. ");
INSERT INTO wolmbs_vpl VALUES ("NU2_25","005_2_25","NUM","2","25","25","«Waa raayab Dan ñooy dale bëj-gànnaar, ñook seeni gàngoor, kilifag askanu Dan di Axyeser doomu Amisadaay. ");
INSERT INTO wolmbs_vpl VALUES ("NU2_26","005_2_26","NUM","2","26","26","Ña ñu limal gàngooram di juróom benn fukki junneek ñaar ak juróom ñaari téeméer (62 700). ");
INSERT INTO wolmbs_vpl VALUES ("NU2_27","005_2_27","NUM","2","27","27","«Ñay dale fa feggook ñoom ñooy giirug Asereen ñi, kilifag askanu Aser di Pagyel doomu Okkran. ");
INSERT INTO wolmbs_vpl VALUES ("NU2_28","005_2_28","NUM","2","28","28","Ña ñu limal gàngooram di ñeent fukki junneek benn ak juróomi téeméer (41 500). ");
INSERT INTO wolmbs_vpl VALUES ("NU2_29","005_2_29","NUM","2","29","29","«Giirug Neftaleen ñeey feggook ñoom, kilifag askanu Neftali di Axira doomu Enan. ");
INSERT INTO wolmbs_vpl VALUES ("NU2_30","005_2_30","NUM","2","30","30","Ña ñu limal gàngooram di juróom fukki junneek ñett ak ñeenti téeméer (53 400). ");
INSERT INTO wolmbs_vpl VALUES ("NU2_31","005_2_31","NUM","2","31","31","«Mboolem ña ñu limal dalub Dan daldi doon téeméer ak juróom fukki junneek juróom ñaar ak juróom benni téeméer (157 600). Ñooñooy mujja jóg, topp seeni raaya.» ");
INSERT INTO wolmbs_vpl VALUES ("NU2_32","005_2_32","NUM","2","32","32","Ñooñu lañu limal bànni Israayil na ñu bokke seen këri maam. Mboolem ña ñu limal dal ya ak seeni gàngoor doon juróom benni téeméeri junneek ñett ak juróomi téeméer ak juróom fukk (603 550). ");
INSERT INTO wolmbs_vpl VALUES ("NU2_33","005_2_33","NUM","2","33","33","Leween ñi nag limaaleesu leen ci bànni Israayil, te noonu la ko Aji Sax ji sante woon Musaa. ");
INSERT INTO wolmbs_vpl VALUES ("NU2_34","005_2_34","NUM","2","34","34","Bànni Israayil daldi def noonu. Mboolem noonee ko Aji Sax ji sante woon Musaa, na lañu daan dale, topp seeni raaya, na lañu daan jóge, ku nekk ak làngam ak kër maamam. ");
INSERT INTO wolmbs_vpl VALUES ("NU3_1","005_3_1","NUM","3","1","1","Ñii ñoo di askani Aaróona ak Musaa, jant ba Aji Sax jiy wax, mook Musaa ca kaw tundu Sinayi. ");
INSERT INTO wolmbs_vpl VALUES ("NU3_2","005_3_2","NUM","3","2","2","Doomi Aaróona yu góor ñoo di Nadab, taaw ba, ak Abiyu ak Elasar ak Itamar. ");
INSERT INTO wolmbs_vpl VALUES ("NU3_3","005_3_3","NUM","3","3","3","Turi doomi Aaróona yu góor, sarxalkat yaa ngi noonu; ñu faloon leen, sédd leen céru carxal. ");
INSERT INTO wolmbs_vpl VALUES ("NU3_4","005_3_4","NUM","3","4","4","Nadab ak Abiyu nag mujj dee fi kanam Aji Sax ji, ba ñu taalalee Aji Sax ji cuuraay lu warul ca màndiŋu Sinayi. Gannaaw amuñu woon doom yu góor, Elasar ak Itamar daldi féetewoo liggéeyu carxal ba, ca seen kanamu baay Aaróona. ");
INSERT INTO wolmbs_vpl VALUES ("NU3_5","005_3_5","NUM","3","5","5","Ci kaw loolu Aji Sax ji ne Musaa: ");
INSERT INTO wolmbs_vpl VALUES ("NU3_6","005_3_6","NUM","3","6","6","«Indil Leween ñi, tegleen ci kilifteefu Aaróona sarxalkat bi, ngir ñu di ko jàppale; ");
INSERT INTO wolmbs_vpl VALUES ("NU3_7","005_3_7","NUM","3","7","7","ñooy sàmm ndénkaaneem, di sàmm ndénkaaneb mbooloo mépp fi kanam xaymab ndaje mi, ndax ñooy sasoo liggéeyu jaamookaay bi. ");
INSERT INTO wolmbs_vpl VALUES ("NU3_8","005_3_8","NUM","3","8","8","Ñooy sàmm mboolem jumtukaayi xaymab ndaje mi, ñooy sàmm ndénkaaneb bànni Israayil, ndax ñooy sasoo liggéeyu jaamookaay bi. ");
INSERT INTO wolmbs_vpl VALUES ("NU3_9","005_3_9","NUM","3","9","9","Noonu ngay jële Leween ñi, sédd leen Aaróona ak doomam yu góor. Ñoom ñoo di cér bu mat sëkk bu ñu koy sédde ci bànni Israayil. ");
INSERT INTO wolmbs_vpl VALUES ("NU3_10","005_3_10","NUM","3","10","10","Aaróona ak doomam yu góor nag ngay tabb ngir ñu sasoo seenug carxal, waaye képp ku ci laal te bokku ci, dees koy rey.» ");
INSERT INTO wolmbs_vpl VALUES ("NU3_11","005_3_11","NUM","3","11","11","Aji Sax ji waxati Musaa, ne ko: ");
INSERT INTO wolmbs_vpl VALUES ("NU3_12","005_3_12","NUM","3","12","12","«Man mii nag, maa seppee Leween ñi ci bànni Israayil, maa leen weccoo mboolem taaw bu góor bu njëkka juddoo ci ndeyam, ci biir bànni Israayil. Kon nag Leween ñi, sama cér lañuy doon. ");
INSERT INTO wolmbs_vpl VALUES ("NU3_13","005_3_13","NUM","3","13","13","Ndax lépp luy taaw bu góor, sama cér la. Keroog ba ma reyee lépp luy taaw bu góor ca réewum Misra, ca laa sellalal sama bopp lépp luy taaw ci Israayil, dale ci nit ba ci jur. Maa leen séddoo. Maay Aji Sax ji.» ");
INSERT INTO wolmbs_vpl VALUES ("NU3_14","005_3_14","NUM","3","14","14","Aji Sax ji waxati Musaa ca màndiŋu Sinayi, ne ko: ");
INSERT INTO wolmbs_vpl VALUES ("NU3_15","005_3_15","NUM","3","15","15","«Limal askanu Leween ñi, ni ñu bokke seen këri maam ak seeni làng. Mboolem góor ñi am weer, jëm kaw, ngay lim.» ");
INSERT INTO wolmbs_vpl VALUES ("NU3_16","005_3_16","NUM","3","16","16","Musaa daldi leen lim ci ndigalal Aji Sax ji, na ñu ko ko sante. ");
INSERT INTO wolmbs_vpl VALUES ("NU3_17","005_3_17","NUM","3","17","17","Gerson ak Keyat ak Merari ñoo soqikoo ci Lewi. ");
INSERT INTO wolmbs_vpl VALUES ("NU3_18","005_3_18","NUM","3","18","18","Doomi Gerson yu góor ñoo di Libni ak Simey, ku ci nekk ak làngam. ");
INSERT INTO wolmbs_vpl VALUES ("NU3_19","005_3_19","NUM","3","19","19","Doomi Keyat yu góor ñoo di Amram ak Iccar ak Ebron ak Usyel, ku ci nekk ak làngam. ");
INSERT INTO wolmbs_vpl VALUES ("NU3_20","005_3_20","NUM","3","20","20","Doomi Merari yu góor ñoo di Maxli ak Musi, ku ci nekk ak làngam. Làngi Leween ñaa ngoogu, na ñu bokke seen këri maam. ");
INSERT INTO wolmbs_vpl VALUES ("NU3_21","005_3_21","NUM","3","21","21","Ci Gerson la làngu Libneen ñi, ak làngu Cimeyeen ñi soqikoo. Làngi Gersoneen ñaa ngoogu. ");
INSERT INTO wolmbs_vpl VALUES ("NU3_22","005_3_22","NUM","3","22","22","Ña ñu leen limal, ba ñu waññee mboolem góor ña am weer, jëm kaw, juróom ñaari junni ak juróomi téeméer (7 500) lañu. ");
INSERT INTO wolmbs_vpl VALUES ("NU3_23","005_3_23","NUM","3","23","23","Làngi Gersoneen ña, ca gannaaw jaamookaay ba lañu daan dale, fa féete sowu. ");
INSERT INTO wolmbs_vpl VALUES ("NU3_24","005_3_24","NUM","3","24","24","Gersoneen ñi, seen kilifag kër maam moo doon Elyasaf doomu Layel. ");
INSERT INTO wolmbs_vpl VALUES ("NU3_25","005_3_25","NUM","3","25","25","Askanu Gerson nag, seen sas ci wàllu xaymab ndaje mi, jaamookaay bi la woon ak xayma bi, ak malaan mi koy ub, ak ridob bunt xaymab ndaje mi, ");
INSERT INTO wolmbs_vpl VALUES ("NU3_26","005_3_26","NUM","3","26","26","ak kiiraayi ëtt beek ridob bunt ëtt bi wër jaamookaay beek sarxalukaay bi, ak buum yeek mboolem liggéey bu ci war. ");
INSERT INTO wolmbs_vpl VALUES ("NU3_27","005_3_27","NUM","3","27","27","Keyat nag, ci moom la làngu Amrameen ñi soqikoo, ak làngu Iccareen ñi, ak làngu Ebroneen ñi, ak làngu Usyeleen ñi. Làngi Keyateen ñaa ngoogu. ");
INSERT INTO wolmbs_vpl VALUES ("NU3_28","005_3_28","NUM","3","28","28","Ba ñu waññee mboolem góor ña ca am weer, jëm kaw, juróom ñetti junni ak juróom benni téeméer (8 600) lañu. Ñoo sàmmoon ndénkaaneb béreb bu sell bi. ");
INSERT INTO wolmbs_vpl VALUES ("NU3_29","005_3_29","NUM","3","29","29","Làngi Keyateen ñi, wet ga féete jaamookaay ba bëj-saalum, fa lañu daan dale. ");
INSERT INTO wolmbs_vpl VALUES ("NU3_30","005_3_30","NUM","3","30","30","Keyateen ñi, seen kilifag kër maam moo doon Elicafan doomu Usyel. ");
INSERT INTO wolmbs_vpl VALUES ("NU3_31","005_3_31","NUM","3","31","31","Seen sas nag moo doon gaal gi, ak taabal ji, ak tegukaayu làmp bi, ak sarxalukaay yi, ak ndabi sarxal ya ñu ca daa jëfandikoo, ak ridob biir bi, ak mboolem liggéey bu ci war. ");
INSERT INTO wolmbs_vpl VALUES ("NU3_32","005_3_32","NUM","3","32","32","Njiiti Leween ñi nag, seen kilifa gu mag moo doon Elasar doomu Aaróona sarxalkat ba. Moo doon saytu ña sàmmoon ndénkaaneb béreb bu sell ba. ");
INSERT INTO wolmbs_vpl VALUES ("NU3_33","005_3_33","NUM","3","33","33","Ci Merari la làngu Maxleen ñi ak làngi Museen ñi soqikoo. Làngi Merareen ñaa ngoogu. ");
INSERT INTO wolmbs_vpl VALUES ("NU3_34","005_3_34","NUM","3","34","34","Ña ñu leen limal, ba ñu waññee mboolem góor ña am weer, jëm kaw, juróom benni junni ak ñaari téeméer (6 200) lañu. ");
INSERT INTO wolmbs_vpl VALUES ("NU3_35","005_3_35","NUM","3","35","35","Merareen ñi, seen kilifag kër maam moo doon Curyel doomu Abixayil. Ca wet ga féete jaamookaay ba bëj-gànnaar, fa lañu daan dale. ");
INSERT INTO wolmbs_vpl VALUES ("NU3_36","005_3_36","NUM","3","36","36","Askanu Merari, seen sas moo doon xànqi jaamookaay bi aki galanam ak jën yi ak tegu yi, ak mboolem jumtukaay ya muy àndal, ak liggéey bu ca war, ");
INSERT INTO wolmbs_vpl VALUES ("NU3_37","005_3_37","NUM","3","37","37","ak jën yi wër ëtt bi, ak seeni tegu, ak seen xeri sampukaay, ak seeni buum. ");
INSERT INTO wolmbs_vpl VALUES ("NU3_38","005_3_38","NUM","3","38","38","Ña daan dale nag fa jàkkaarlook jaamookaay bi, ca kanam, janlook xaymab ndaje mi, ca wetu penku, ñoo doon Musaa ak Aaróona ak doomam yu góor. Ñoo sàmmoon ndénkaaneb xayma bu sell bi, sasool ko bànni Israayil, te ku ci laal te bokku ci, dees koy rey. ");
INSERT INTO wolmbs_vpl VALUES ("NU3_39","005_3_39","NUM","3","39","39","Mboolem ña ñu limal Leween ñi, te Musaa ak Aaróona lim leen na ñu bokke seeni làng ci ndigalal Aji Sax ji, ñuy mboolem góor ñi am weer, jëm kaw, ñaar fukki junneek ñaar (22 000) lañu. ");
INSERT INTO wolmbs_vpl VALUES ("NU3_40","005_3_40","NUM","3","40","40","Aji Sax ji waxaat Musaa, ne ko: «Limal taawi bànni Israayil yu góor yépp, dale ko ci ñi am weer, jëm kaw, nga waññ te bind seeni tur. ");
INSERT INTO wolmbs_vpl VALUES ("NU3_41","005_3_41","NUM","3","41","41","Su ko defee nga beral ma Leween ñi, man Aji Sax ji, ñu wecci mboolem taawi bànni Israayil gi ci des, juri Leween ñi itam wecci mboolem luy taaw ci juri bànni Israayil gi ci des.» ");
INSERT INTO wolmbs_vpl VALUES ("NU3_42","005_3_42","NUM","3","42","42","Ci kaw loolu Musaa lim taawi bànni Israayil yépp, na ko ko Aji Sax ji sante. ");
INSERT INTO wolmbs_vpl VALUES ("NU3_43","005_3_43","NUM","3","43","43","Ba ñu waññee mboolem taaw yu góor ya, bind seeni tur, dale ci ñi am weer, jëm kaw, seenub lim nekk na ñaar fukki junneek ñaar ak ñaari téeméer ak juróom ñaar fukk ak ñett (22 273). ");
INSERT INTO wolmbs_vpl VALUES ("NU3_44","005_3_44","NUM","3","44","44","Aji Sax ji waxati Musaa, ne ko: ");
INSERT INTO wolmbs_vpl VALUES ("NU3_45","005_3_45","NUM","3","45","45","«Beral Leween ñi, ñu wecci mboolem taawi bànni Israayil, juri Leween ñi it wecci seenug jur, ma daldi séddoo Leween ñi, man Aji Sax ji. ");
INSERT INTO wolmbs_vpl VALUES ("NU3_46","005_3_46","NUM","3","46","46","Njotlaay nag dina war ci ñaari téeméer ak juróom ñaar fukk ak ñetti (273) bopp, yi taawi bànni Israayil ëppe Leween ñi. ");
INSERT INTO wolmbs_vpl VALUES ("NU3_47","005_3_47","NUM","3","47","47","Su ko defee nga sàkku bopp bu ci nekk juróomi siikal; ci siikal bi ñu yoonal ci néeg bu sell bi nga koy sàkkoo, siikal bu ci nekk wecci ñaar fukki gera. ");
INSERT INTO wolmbs_vpl VALUES ("NU3_48","005_3_48","NUM","3","48","48","Nanga jox xaalis boobu Aaróona ak doomam yu góor, muy njotlaayal taaw yi ci tegu.» ");
INSERT INTO wolmbs_vpl VALUES ("NU3_49","005_3_49","NUM","3","49","49","Ba loolu amee Musaa feyeeku xaalisu njotlaayal taaw yooyu tegu ca taaw, ya jotoo Leween ña. ");
INSERT INTO wolmbs_vpl VALUES ("NU3_50","005_3_50","NUM","3","50","50","Xaalis ba mu nangoo ca taawi bànni Israayil di junniy siikal ak ñetti téeméer ak juróom benn fukk ak juróom (1 365), ci siikal bi ñu yoonal ci néeg bu sell bi, xawa tollu ci fukki kilo ak juróom ak genn-wàll. ");
INSERT INTO wolmbs_vpl VALUES ("NU3_51","005_3_51","NUM","3","51","51","Ci kaw loolu Musaa jox Aaróona ak doomam yu góor xaalisu njotlaay ba, ci ndigalal Aji Sax ji, na ko ko Aji Sax ji sante. ");
INSERT INTO wolmbs_vpl VALUES ("NU4_1","005_4_1","NUM","4","1","1","Aji Sax ji waxati Musaa ak Aaróona, ne: ");
INSERT INTO wolmbs_vpl VALUES ("NU4_2","005_4_2","NUM","4","2","2","«Leween ñi askanoo ci Keyat, waññleen leen bopp ak bopp, na ñu bokke seeni làng, ak seen këri maam. ");
INSERT INTO wolmbs_vpl VALUES ("NU4_3","005_4_3","NUM","4","3","3","Daleleen ci góor ñi am fanweeri at, ba juróom fukki at, muy mboolem ñi yelloo bokk ci kuréel, gi liggéeyu biir xaymab ndaje mi war. ");
INSERT INTO wolmbs_vpl VALUES ("NU4_4","005_4_4","NUM","4","4","4","Liggéeyu Keyateen ñi ci biir xaymab ndaje mi moo di wàllu jumtukaay yu sell yee sell. ");
INSERT INTO wolmbs_vpl VALUES ("NU4_5","005_4_5","NUM","4","5","5","«Bu dal bi dee jóg, na Aaróona ak doomam yu góor dugg, wékki kiiraay li, di ridob biir bi, te ñu muure ko gaalu seedes kóllëre gi. ");
INSERT INTO wolmbs_vpl VALUES ("NU4_6","005_4_6","NUM","4","6","6","Nañu lalaat ca kaw kiiraayal deru piipi, te ñu lalati ca kaw, ndimo lu lépp baxa, doora roof njàppuy gaal gi. ");
INSERT INTO wolmbs_vpl VALUES ("NU4_7","005_4_7","NUM","4","7","7","«Taabalu mburum teewal mi, nañu ci lal ndimo lu baxa, teg ci ndab yeek bàttu yeek njaq yeek tax yi ñuy sottee saraxi tuuru, door cee teg mburu moomu dul wuute. ");
INSERT INTO wolmbs_vpl VALUES ("NU4_8","005_4_8","NUM","4","8","8","Nañu muure yooyu ndimo lu xonq curr, te ñu lalaat ca kaw malaanum deru piipi, doora roof njàppuy taabal ji. ");
INSERT INTO wolmbs_vpl VALUES ("NU4_9","005_4_9","NUM","4","9","9","«Su ko defee ñu jël ndimo lu baxa, muure ko tegukaayu làmp bi, aki làmpam aki ñiimam aki andam, ak mboolem ndabi diwam ya ñu cay jëfoo. ");
INSERT INTO wolmbs_vpl VALUES ("NU4_10","005_4_10","NUM","4","10","10","Nañu boole tegukaayu làmp beek mboolem la muy àndal, ñu ëmbe lépp malaanum deru piipi, te teg ko ci kaw tagar bi ñu koy gàddoo. ");
INSERT INTO wolmbs_vpl VALUES ("NU4_11","005_4_11","NUM","4","11","11","Sarxalukaay bu ñu xoobe wurus, nañu lal ci kawam ndimo lu baxa, lalaat ca kaw malaanum deru piipi, doora roof njàppuy sarxalukaay bi. ");
INSERT INTO wolmbs_vpl VALUES ("NU4_12","005_4_12","NUM","4","12","12","Nañu jël mboolem jumtukaay yi ñuy liggéeye ci biir béreb bu sell bi, ñu ëmbe ko ndimo lu baxa, muure ko malaanum deru piipi, door koo teg ci kaw tagar bi ñu koy gàddoo. ");
INSERT INTO wolmbs_vpl VALUES ("NU4_13","005_4_13","NUM","4","13","13","Nañu dindi niiniti sarxalukaayu xànjar bi, te ñu lal ci kaw sarxalukaay bi, ndimo lu xonq curr. ");
INSERT INTO wolmbs_vpl VALUES ("NU4_14","005_4_14","NUM","4","14","14","Nañu teg ca kaw ndimo la mboolem ndab, ya ñuy liggéeye ca sarxalukaay ba: and yeek cappukaayi yàpp yeek ñiitukaay yeek këll yi; jumtukaayi sarxalukaay bi yépp daal, te ñu lal ca kaw, malaanum deru piipi, doora roof njàppuy sarxalukaay bi. ");
INSERT INTO wolmbs_vpl VALUES ("NU4_15","005_4_15","NUM","4","15","15","«Bu dal bi waree jóg, na Aaróona ak doomam yu góor muur yëf yu sell yi, ak mboolem jumtukaayi xaymab ndaje mi ba noppi. Gannaaw loolu la askanu Keyat di dikk, ngir gàddu ko. Su ko defee duñu laal dara lu sell, bay dee. Loolu la Keyateen ñi di gàddu ci wàllu xaymab ndaje mi. ");
INSERT INTO wolmbs_vpl VALUES ("NU4_16","005_4_16","NUM","4","16","16","«Elasar doomu Aaróona sarxalkat bi nag, ab saytoom moo di diwu làmp bi, ak cuuraay li, ak saraxu pepp bi dul jaas, ak diwu pal gi. Mooy féetewoo jaamookaay bi bépp, ak mboolem li ci biiram, ba ci yëf yu sell yi, aki jumtukaayam.» ");
INSERT INTO wolmbs_vpl VALUES ("NU4_17","005_4_17","NUM","4","17","17","Aji Sax ji waxati ba tey ak Musaa ak Aaróona, ne leen: ");
INSERT INTO wolmbs_vpl VALUES ("NU4_18","005_4_18","NUM","4","18","18","«Buleen yóbbe Keyateen ñeek seeni làng, lu ñu leen di dagge ci biir Leween ñi. ");
INSERT INTO wolmbs_vpl VALUES ("NU4_19","005_4_19","NUM","4","19","19","Nii ngeen di def ak ñoom, ba bu ñu jegee yëf yu sell yee sell, di dund te duñu ca dee: Aaróona aki doomam ñooy dugg, daldi sédd ku nekk ci ñoom liggéeyam ak la muy gàddu. ");
INSERT INTO wolmbs_vpl VALUES ("NU4_20","005_4_20","NUM","4","20","20","Bu Keyateen ñi dugg, di xool lu mu gàtt gàtt, yëf yu sell yi. Lu ko moy ñu dee.» ");
INSERT INTO wolmbs_vpl VALUES ("NU4_21","005_4_21","NUM","4","21","21","Gannaaw loolu Aji Sax ji wax Musaa, ne ko: ");
INSERT INTO wolmbs_vpl VALUES ("NU4_22","005_4_22","NUM","4","22","22","«Ñi askanoo ci Gerson itam, nanga leen waññ bopp ak bopp, na ñu bokke seen këri maam ak seeni làng. ");
INSERT INTO wolmbs_vpl VALUES ("NU4_23","005_4_23","NUM","4","23","23","Li dale ci góor ñi am fanweeri at, ba juróom fukki at ngay lim, ñuy mboolem ñi liggéeyu xaymab ndaje mi war. ");
INSERT INTO wolmbs_vpl VALUES ("NU4_24","005_4_24","NUM","4","24","24","Gersoneen ñi nag, lii moo di seen cér ci wàllu liggéey bi, ak li ñu wara gàddu: ");
INSERT INTO wolmbs_vpl VALUES ("NU4_25","005_4_25","NUM","4","25","25","ñooy gàddu kiiraayi jaamookaay bi, ak xaymab ndaje meek malaanam, ak malaanum deru piipi bi ci kaw, ak ridob bunt xaymab ndaje mi; ");
INSERT INTO wolmbs_vpl VALUES ("NU4_26","005_4_26","NUM","4","26","26","ak sori ëtt bi, ak kiiraayal bunt ëtt bi wër jaamookaay beek sarxalukaay bi, ak seeni buum ak mboolem jumtukaay ya ñu cay liggéeye. Mboolem lees cay def, ñoo koy liggéey. ");
INSERT INTO wolmbs_vpl VALUES ("NU4_27","005_4_27","NUM","4","27","27","Mboolem sasu Gersoneen ñi ci mboolem lu ñuy gàddu ak mboolem lu ñuy liggéey, ci ndigalal Aaróona aki doomam lay doon. Ñoo leen di sas mboolem lu ñu wara gàddu. ");
INSERT INTO wolmbs_vpl VALUES ("NU4_28","005_4_28","NUM","4","28","28","Loolooy céru Gersoneen ñi, ci wàllu xaymab ndaje mi, te loolu lañu leen dénk, Itamar doomu Aaróona sarxalkat bi di leen ca saytu. ");
INSERT INTO wolmbs_vpl VALUES ("NU4_29","005_4_29","NUM","4","29","29","«Ñi askanoo ci Merari itam, na ñu bokke seeni làng ak seen këri maam, noonu nga leen di lime, ");
INSERT INTO wolmbs_vpl VALUES ("NU4_30","005_4_30","NUM","4","30","30","dale ko ci ñi am fanweeri at, ba juróom fukki at, ñuy mboolem ñi yelloo bokk ci kuréel, gi liggéeyu xaymab ndaje mi war. ");
INSERT INTO wolmbs_vpl VALUES ("NU4_31","005_4_31","NUM","4","31","31","Lii mooy li ñu sasoo gàddu ci seen mboolem liggéey ci xaymab ndaje mi: xànqi jaamookaay bi aki galanam aki jënam aki tegoom; ");
INSERT INTO wolmbs_vpl VALUES ("NU4_32","005_4_32","NUM","4","32","32","muy jën yi wër ëtt bi, ak seeni tegu ak seeni buum, mboolem seen jumtukaay yu ñu cay liggéeye. Limalleen leen jumtukaay yi ñu wara gàddu. ");
INSERT INTO wolmbs_vpl VALUES ("NU4_33","005_4_33","NUM","4","33","33","Loolooy céru Merareen ñi, ci wàllu xaymab ndaje mi ci njiital sarxalkat bi Itamar doomu Aaróona.» ");
INSERT INTO wolmbs_vpl VALUES ("NU4_34","005_4_34","NUM","4","34","34","Ci kaw loolu Musaa ak Aaróona ak kilifag mbooloo ma lim Keyateen ña, na ñu bokke seeni làng ak seen këri maam. ");
INSERT INTO wolmbs_vpl VALUES ("NU4_35","005_4_35","NUM","4","35","35","Ñu dale ko ci ñi am fanweeri at, ba juróom fukki at, ñuy mboolem ñi yelloo bokk ci kuréel, gi liggéeyu xaymab ndaje mi war. ");
INSERT INTO wolmbs_vpl VALUES ("NU4_36","005_4_36","NUM","4","36","36","Ña ñu limal seeni làng di ñaari junni ak juróom ñaari téeméer ak juróom fukki góor (2 750). ");
INSERT INTO wolmbs_vpl VALUES ("NU4_37","005_4_37","NUM","4","37","37","Ñooñu lañu limal làngi Keyateen ñi, ñoom ñépp la liggéeyu xaymab ndaje mi war. Musaa ak Aaróona ñoo leen limoon, na ko Aji Sax ji santaanee, Musaa jottali. ");
INSERT INTO wolmbs_vpl VALUES ("NU4_38","005_4_38","NUM","4","38","38","Ña ñu limal Gersoneen ñi, na ñu bokke seeni làng ak seen këri maam, ");
INSERT INTO wolmbs_vpl VALUES ("NU4_39","005_4_39","NUM","4","39","39","dale ko ci ñi am fanweeri at, ba juróom fukki at, mboolem ña yelloo bokk ci kuréel, gi liggéeyu xaymab ndaje mi war, ");
INSERT INTO wolmbs_vpl VALUES ("NU4_40","005_4_40","NUM","4","40","40","te ñu limal leen seeni làng ak seen këri maam, ñaari junneek juróom benni téeméer ak fanweeri góor lañu (2 630). ");
INSERT INTO wolmbs_vpl VALUES ("NU4_41","005_4_41","NUM","4","41","41","Ñooñu lañu limal làngi Gersoneen ñi, te ñoom ñépp la liggéeyu xaymab ndaje mi war. Musaa ak Aaróona ñoo leen limoon ci ndigalal Aji Sax ji. ");
INSERT INTO wolmbs_vpl VALUES ("NU4_42","005_4_42","NUM","4","42","42","Ña ñu limal làngi Merareen ñi, na ñu bokke seeni làng, ak seen këri maam, ");
INSERT INTO wolmbs_vpl VALUES ("NU4_43","005_4_43","NUM","4","43","43","dale ko ci ñi am fanweeri at, ba juróom fukki at, mboolem ña yelloo bokk ci kuréel, gi liggéeyu xaymab ndaje mi war, ");
INSERT INTO wolmbs_vpl VALUES ("NU4_44","005_4_44","NUM","4","44","44","te ñu limal leen seeni làng, ñetti junni ak ñaari téeméeri góor (3 200) lañu. ");
INSERT INTO wolmbs_vpl VALUES ("NU4_45","005_4_45","NUM","4","45","45","Ñooñu lañu limal làngi Merareen ñi, Musaa ak Aaróona ñoo leen limoon, na ko Aji Sax ji santaanee, Musaa jottali. ");
INSERT INTO wolmbs_vpl VALUES ("NU4_46","005_4_46","NUM","4","46","46","Mboolem Leween ña Musaa ak Aaróona, ak kilifay Israayil limoon, na ñu bokke seeni làng, ak seen këri maam, ");
INSERT INTO wolmbs_vpl VALUES ("NU4_47","005_4_47","NUM","4","47","47","dale ko ci ñi am fanweeri at, ba juróom fukki at, ñuy mboolem ña yelloo bokk ci kuréel, gi liggéeyu xaymab ndaje mi war, ");
INSERT INTO wolmbs_vpl VALUES ("NU4_48","005_4_48","NUM","4","48","48","seenub lim nekk na juróom ñetti junni ak juróomi téeméer ak juróom ñett fukki góor (8 580). ");
INSERT INTO wolmbs_vpl VALUES ("NU4_49","005_4_49","NUM","4","49","49","Ci ndigalal Aji Sax ji Musaa jottali, lañu leen lim, ba sas ku ci nekk ab liggéeyam ak la muy gàddu. Na ko Aji Sax ji sante Musaa, na lañu leen lime. ");
INSERT INTO wolmbs_vpl VALUES ("NU5_1","005_5_1","NUM","5","1","1","Aji Sax ji waxati Musaa, ne ko: ");
INSERT INTO wolmbs_vpl VALUES ("NU5_2","005_5_2","NUM","5","2","2","«Santal bànni Israayil ñu génne dal bi képp ku ànd ak jàngoroy der juy law, mbaa jàngoroy xelli, ak képp ku sobeb néew bu mu laal, topp. ");
INSERT INTO wolmbs_vpl VALUES ("NU5_3","005_5_3","NUM","5","3","3","Muy góor, di jigéen, génneleen leen. Bitib dal bi ngeen leen di génne. Buñu sobeel dali bànni Israayil yi ma màkkaanoo ci seen biir.» ");
INSERT INTO wolmbs_vpl VALUES ("NU5_4","005_5_4","NUM","5","4","4","Bànni Israayil def noonu, daldi leen génne dal bi, dàq leen ca biti. Ni ko Aji Sax ji waxe Musaa, noonu lañu ko defe. ");
INSERT INTO wolmbs_vpl VALUES ("NU5_5","005_5_5","NUM","5","5","5","Aji Sax ji waxati Musaa, ");
INSERT INTO wolmbs_vpl VALUES ("NU5_6","005_5_6","NUM","5","6","6","ne ko mu wax bànni Israayil, ne leen: «Muy góor, di jigéen, bu tooñee moroomam, ba fecci wormay Aji Sax ji, nit kooku tooñ na. ");
INSERT INTO wolmbs_vpl VALUES ("NU5_7","005_5_7","NUM","5","7","7","Day tuub bàkkaaram, ba noppi fey dayo ba mu ameel ka mu tooñ. Te juróomeelu xaajam la cay teg, jox ko ko. ");
INSERT INTO wolmbs_vpl VALUES ("NU5_8","005_5_8","NUM","5","8","8","Bu ki ñu tooñ wuutee, te amul mbokk mu koy jotaat, pey ga ñeel na Aji Sax ji, sarxalkat bee koy jagoo, te bokkul ak kuuyum njotlaay mi sarxalkat biy defale ki tooñ njotlaayam. ");
INSERT INTO wolmbs_vpl VALUES ("NU5_9","005_5_9","NUM","5","9","9","Te itam bépp saraxu njébbal bu bokk ci mboolem sarax yu sell yi bànni Israayil indil sarxalkat bi, sarxalkat bee koy moom. ");
INSERT INTO wolmbs_vpl VALUES ("NU5_10","005_5_10","NUM","5","10","10","Ku nekk ci sarxalkat yi, sa sarax yu sell, yaa ko moom. Ku ci nekk, lu ñu la jox, yaay boroom.» ");
INSERT INTO wolmbs_vpl VALUES ("NU5_11","005_5_11","NUM","5","11","11","Aji Sax ji waxati Musaa, ");
INSERT INTO wolmbs_vpl VALUES ("NU5_12","005_5_12","NUM","5","12","12","ne mu wax bànni Israayil, ne leen: «Képp ku jabaram moy, fecci ko worma, ");
INSERT INTO wolmbs_vpl VALUES ("NU5_13","005_5_13","NUM","5","13","13","bu ñu àndee ak ndaw si, te moom miy jëkkëram yégu ko; te ba ndaw say sobeel boppam, fekkeesu ko fa ba di ko seede; ");
INSERT INTO wolmbs_vpl VALUES ("NU5_14","005_5_14","NUM","5","14","14","ndegam xelum fiiraangee dikkal waa ji, ba mu fiire jabaram, te fekk jabar jaa sobeel boppam ci njaaloo, mbaa muy fiiraange gu dikkal waa ji rekk, mu fiire jabaram, te fekk ndaw si sobeelul boppam ci njaaloo; ");
INSERT INTO wolmbs_vpl VALUES ("NU5_15","005_5_15","NUM","5","15","15","na waa ji yóbbu jabaram ca sarxalkat ba, te yóbbaleel ko saraxu ñetti kiloy sungufu lors. Du ci sotti diw, du ci def cuuraay, ndax saraxu pepp boobu saraxu fiiraange la, saraxu toppukaay la bu ñuy toppe ñaawtéef. ");
INSERT INTO wolmbs_vpl VALUES ("NU5_16","005_5_16","NUM","5","16","16","«Na sarxalkat bi indi ndaw si, taxawal ko fi kanam Aji Sax ji. ");
INSERT INTO wolmbs_vpl VALUES ("NU5_17","005_5_17","NUM","5","17","17","Su ko defee sarxalkat bi day fab ndabal xandeer, duy ko ndox mu sell mi ñuy setloo, te na sàkk ci suufas jaamookaay bi, def ko ci ndox mi. ");
INSERT INTO wolmbs_vpl VALUES ("NU5_18","005_5_18","NUM","5","18","18","Bu taxawloo ndaw si fi kanam Aji Sax ji, na muri boppu ndaw si, te teg ciy loxoom, saraxu pepp boobu di toppukaayu ñaawtéef te di saraxu fiiraange. Na fekk sarxalkat bi yore ciy loxoom ndoxum wextan, miy alage. ");
INSERT INTO wolmbs_vpl VALUES ("NU5_19","005_5_19","NUM","5","19","19","Su ko defee sarxalkat bi waatloo ndaw si, ne ko: “Ndegam góor àndul ak yaw, moyuloo, sobeel sa bopp te fekk la ci buum, muccal ci loraangey ndoxum wextan mii, di alage. ");
INSERT INTO wolmbs_vpl VALUES ("NU5_20","005_5_20","NUM","5","20","20","Waaye su dee yaa moy te fekk la ci sa buumu jëkkër, su dee yaa sobeel sa bopp ak geneen góor gu ànd ak yaw te du sa jëkkër nag...” ");
INSERT INTO wolmbs_vpl VALUES ("NU5_21","005_5_21","NUM","5","21","21","Fii la sarxalkat biy waatloo ndaw si waatu alkànde gi, wax ko ne ko: “...yal na la Aji Sax ji def ku alku ku ñuy móoloo ci sa biir askan. Yal na laxal sa njurukaay, wal sab koll. ");
INSERT INTO wolmbs_vpl VALUES ("NU5_22","005_5_22","NUM","5","22","22","Yal na ndoxum alkànde mii tàbbi ci say butit, laxal sa njurukaay, wal sab koll.” Su ko defee ndaw si ne: “Amiin, Amiin.” ");
INSERT INTO wolmbs_vpl VALUES ("NU5_23","005_5_23","NUM","5","23","23","«Na sarxalkat bi bind kàdduy alkànde yooyu ci téere bu ñu taxañ, te na raxas mbind mi ci ndoxum wextan mi. ");
INSERT INTO wolmbs_vpl VALUES ("NU5_24","005_5_24","NUM","5","24","24","Sarxalkat bi day naanloo ndaw si ndoxum wextan, miy alage, ndox miy alage tàbbi ci biiram, man koo wex xàtt. ");
INSERT INTO wolmbs_vpl VALUES ("NU5_25","005_5_25","NUM","5","25","25","Waaye na njëkka nangoo ci loxol ndaw si, peppum saraxu fiiraange bi, daldi yékkati saraxas pepp mi, jébbale ko fi kanam Aji Sax ji, doora indi sarax bi ci sarxalukaay bi. ");
INSERT INTO wolmbs_vpl VALUES ("NU5_26","005_5_26","NUM","5","26","26","Na sarxalkat bi sàkk ci saraxu pepp bi, ab ŋëb buy fàttalee, daldi koy lakk ci kaw sarxalukaay bi. Gannaaw loolu mu naanloo ndaw si ndox mi. ");
INSERT INTO wolmbs_vpl VALUES ("NU5_27","005_5_27","NUM","5","27","27","«Bu ko xasee naanloo ndox mi, ndegam ndaw see sobeel boppam, wor jëkkëram, ndoxum alkànde mi day tàbbi ci biiram, jural ko wextan, koll bi newi, njurukaayam lax, mu mujj doon ku ñuy móoloo ci biir askanam. ");
INSERT INTO wolmbs_vpl VALUES ("NU5_28","005_5_28","NUM","5","28","28","Waaye su ndaw si sobeelul boppam, xanaa di ku set, dina mucc, te dina mana am doom. ");
INSERT INTO wolmbs_vpl VALUES ("NU5_29","005_5_29","NUM","5","29","29","«Loolooy dogalu yoon ci mbirum fiiraange, bu jigéen moyee, sobeel boppam te fekk buum ci baatam, ");
INSERT INTO wolmbs_vpl VALUES ("NU5_30","005_5_30","NUM","5","30","30","mbaa jëkkër ju xelum fiiraange dikkal, mu fiire jabaram. Jabar ji lay taxawloo fi kanam Aji Sax ji, sarxalkat bi defal ko mboolem dogalu yoon boobu. ");
INSERT INTO wolmbs_vpl VALUES ("NU5_31","005_5_31","NUM","5","31","31","Deesul topp jëkkër ji genn tooñ, waaye jabar jeey gàddu ñaawtéefu boppam.» ");
INSERT INTO wolmbs_vpl VALUES ("NU6_1","005_6_1","NUM","6","1","1","Aji Sax ji waxati Musaa, ");
INSERT INTO wolmbs_vpl VALUES ("NU6_2","005_6_2","NUM","6","2","2","ne ko mu wax bànni Israayil ne leen: «Góor ak jigéen, képp ku ci dogu ba xas ngir nekk ab Nasireen, ngir sédd boppam Aji Sax ji, ");
INSERT INTO wolmbs_vpl VALUES ("NU6_3","005_6_3","NUM","6","3","3","muy biiñ, di ñoll wu mu mana doon, na moytu di ko jëfandikoo. Bineegaru biiñ ak bineegaru ñoll wu mu mana doon it, du ko naan. Mboolem luy ndoxum reseñ, du ko naan, te reseñ ju tooy ak ju wow it, du ko lekk. ");
INSERT INTO wolmbs_vpl VALUES ("NU6_4","005_6_4","NUM","6","4","4","Mboolem diiru fani céddoom, mboolem lu jóge ci doomu garabu reseñ, dale ci xoox ba ci der, du ci lekk lenn. ");
INSERT INTO wolmbs_vpl VALUES ("NU6_5","005_6_5","NUM","6","5","5","«Kemu fani céddoo yi mu xas ne dina ko nasireenal, saatus watukaay du laal boppam ba keroog fani nasireenal, yi mu séddoo Aji Sax ji matee. Ku sell lay doon te day jañu. ");
INSERT INTO wolmbs_vpl VALUES ("NU6_6","005_6_6","NUM","6","6","6","Kemu fan yi muy nasireenal, séddoo Aji Sax ji, ab néew, bumu ko jege. ");
INSERT INTO wolmbs_vpl VALUES ("NU6_7","005_6_7","NUM","6","7","7","Baayam ak ndeyam, mbaa góor mbaa jigéen ju mu bokkal waajur sax, bu deewee, du sobeel boppam ngir ñoom, ndax moo yenu ci kaw boppam, njañu nasireen gi mu séddoo Yàllaam. ");
INSERT INTO wolmbs_vpl VALUES ("NU6_8","005_6_8","NUM","6","8","8","Kemu fani céddoom, ku sell lay doon, ñeel Aji Sax ji. ");
INSERT INTO wolmbs_vpl VALUES ("NU6_9","005_6_9","NUM","6","9","9","«Su nit jekkee dee ci wetam, ba sobeel njañu céddoom, keroog bés buy setlu ca lay watu, te keroog bésub juróom ñaareel ba lay watu. ");
INSERT INTO wolmbs_vpl VALUES ("NU6_10","005_6_10","NUM","6","10","10","Bés ba ca topp, di juróom ñetteel ba, na yóbbu ca sarxalkat ba, ñaari pitax mbaa ñaari xati yu ndaw, ca bunt xaymab ndaje ma. ");
INSERT INTO wolmbs_vpl VALUES ("NU6_11","005_6_11","NUM","6","11","11","Sarxalkat bi day def menn mi saraxu póotum bàkkaar, mi ci des saraxu rendi-dóomal, mu jote ko boroom céddoo gi, bàkkaaram ba ko néew ba yóbbe. Bésub keroog lay sellalaat boppam ba yenu woon njañam. ");
INSERT INTO wolmbs_vpl VALUES ("NU6_12","005_6_12","NUM","6","12","12","Day yeesalal Aji Sax ji nasireenam ga mu ko séddoo woon, kemu fan ya mu xasoona nasireenal. Su ko defee day indi kuuyu menn at, def ko saraxas peyug tooñ. Fan yi mu njëkkoona nasireenal day neen, ndax nasireen googa moo sobewu. ");
INSERT INTO wolmbs_vpl VALUES ("NU6_13","005_6_13","NUM","6","13","13","«Dogalu yoon wi ci ab nasireen nag mooy lii: Bés bi ag céddoom matee, dees koy yóbbu ca bunt xaymab ndaje ma. ");
INSERT INTO wolmbs_vpl VALUES ("NU6_14","005_6_14","NUM","6","14","14","Sarax si muy sarxalsi Aji Sax ji di menn kuuyu menn at mu amul sikk, ngir rendi-dóomal, ak menn xarum menn at mu jigéen mu amul sikk, ngir póotum bàkkaar, ak menn kuuy mu mag mu amul sikk, ngir saraxas cant ci biir jàmm, ");
INSERT INTO wolmbs_vpl VALUES ("NU6_15","005_6_15","NUM","6","15","15","ak pañeb mburu yu amul lawiir, yu ñu lakke sunguf su mucc ayib su ñu xiiwaale ag diw, ak mburu yu sew yu amul lawiir yu ñu wis ag diw, ak saraxi pepp ak saraxi tuuru ya muy àndal. ");
INSERT INTO wolmbs_vpl VALUES ("NU6_16","005_6_16","NUM","6","16","16","«Su ko defee sarxalkat bi boole ko indi fi kanam Aji Sax ji, daldi joxe póotum bàkkaar bi, ak rendi-dóomal bi. ");
INSERT INTO wolmbs_vpl VALUES ("NU6_17","005_6_17","NUM","6","17","17","Kuuy mi, na ko sarxalkat bi def saraxas cant ci biir jàmm, ñeel Aji Sax ji, boole kook pañeb mburu mi amul lawiir, doora joxe saraxi pepp yeek saraxi tuuru yi. ");
INSERT INTO wolmbs_vpl VALUES ("NU6_18","005_6_18","NUM","6","18","18","Su ko defee nasireen bi watu ci bunt xaymab ndaje mi te for kawari céddoom googu, def ko ci taal bi ci suufu saraxas cantu biir jàmm bi. ");
INSERT INTO wolmbs_vpl VALUES ("NU6_19","005_6_19","NUM","6","19","19","«Na sarxalkat bi jël tànku kanamu kuuy mi, gannaaw bu ñoree, te sàkk ci pañe bi menn mburu mu amul lawiir, ak menn mburu mu ndaw, daldi boole loola teg ci loxol nasireen bi, gannaaw bu watoo ba noppi. ");
INSERT INTO wolmbs_vpl VALUES ("NU6_20","005_6_20","NUM","6","20","20","«Na sarxalkat bi jébbale loola, defal ko Aji Sax ji saraxu yékkati-jébbal. Cér yu sell a ngoogu ñeel sarxalkat bi, mu boole kook dënn biy saraxu yékkati-jébbal, ak tànkub kanam bi ñu jébbale. Gannaaw loolu nasireen bi sañ naa naan biiñ. ");
INSERT INTO wolmbs_vpl VALUES ("NU6_21","005_6_21","NUM","6","21","21","«Loolooy wartéef ci ab nasireen bu xas. Loolooy saraxam bi mu warlook Aji Sax ji cig céddoom, te bokkewul ak leneen lu mu ci àttan; waaye kàdduy xas wa mu xasoon daal, na sàmmonteek moom ni ko yoon diglee ci céddoom googu.» ");
INSERT INTO wolmbs_vpl VALUES ("NU6_22","005_6_22","NUM","6","22","22","Gannaaw loolu Aji Sax ji waxati Musaa, ne: ");
INSERT INTO wolmbs_vpl VALUES ("NU6_23","005_6_23","NUM","6","23","23","«Waxal Aaróona aki doomam ne leen ni ñuy ñaanale bànni Israayil, nii la; nañu leen wax ne leen: ");
INSERT INTO wolmbs_vpl VALUES ("NU6_24","005_6_24","NUM","6","24","24","«“Yal na la Aji Sax ji barkeel, sàmm la. ");
INSERT INTO wolmbs_vpl VALUES ("NU6_25","005_6_25","NUM","6","25","25","«“Yal na la Aji Sax ji geesoo leeram, baaxe la. ");
INSERT INTO wolmbs_vpl VALUES ("NU6_26","005_6_26","NUM","6","26","26","«“Yal na la Aji Sax ji siggil, jàmmal la.” ");
INSERT INTO wolmbs_vpl VALUES ("NU6_27","005_6_27","NUM","6","27","27","Bu ñu tuddalee noonu bànni Israayil sama tur, man, maa leen di barkeel.» ");
INSERT INTO wolmbs_vpl VALUES ("NU7_1","005_7_1","NUM","7","1","1","Keroog ba Musaa sampee jaamookaay bi ba noppi, diw na ko ngir sellal ko, mook mboolem ay jumtukaayam, sarxalukaay beek mboolem ndabam it, mu boole diw, sellale ko. ");
INSERT INTO wolmbs_vpl VALUES ("NU7_2","005_7_2","NUM","7","2","2","Ba loolu amee kilifay Israayil yi jiite seeni kër maam dikk. Ñooñoo doon njiiti giir yi te ñoo doon saytu limeefu nit ñi. ");
INSERT INTO wolmbs_vpl VALUES ("NU7_3","005_7_3","NUM","7","3","3","Ñu indil Aji Sax ji seen sarax, muy juróom benni watiir ak fukki nag ak ñaar; ñaari kilifa yu nekk, benn watiir; kilifa gu nekk, wenn nag, ñu yóbbu lépp fa kanam jaamookaay ba. ");
INSERT INTO wolmbs_vpl VALUES ("NU7_4","005_7_4","NUM","7","4","4","Aji Sax ji wax Musaa, ");
INSERT INTO wolmbs_vpl VALUES ("NU7_5","005_7_5","NUM","7","5","5","ne ko: «Nangul lii, mu jëm ci liggéeyu xaymab ndaje mi, te nga jox ko Leween ñi, ku ci nekk ak li liggéeyam laaj.» ");
INSERT INTO wolmbs_vpl VALUES ("NU7_6","005_7_6","NUM","7","6","6","Musaa nangu watiir yaak nag ya, jox Leween ñi. ");
INSERT INTO wolmbs_vpl VALUES ("NU7_7","005_7_7","NUM","7","7","7","Yii ñaari watiir ak ñeenti nag, mu jox Gersoneen ña, na ko seen liggéey laaje, ");
INSERT INTO wolmbs_vpl VALUES ("NU7_8","005_7_8","NUM","7","8","8","yee ñeent, mu booleek juróom ñetti nag, jox Merareen ña, na ko seen liggéey laaje, ci njiital sarxalkat ba Itamar doomu Aaróona. ");
INSERT INTO wolmbs_vpl VALUES ("NU7_9","005_7_9","NUM","7","9","9","Keyateen ña nag, joxu leen, ndax yu sell ya lañu sasoo woona gàddu. ");
INSERT INTO wolmbs_vpl VALUES ("NU7_10","005_7_10","NUM","7","10","10","Ci biir loolu kilifa yi indi itam saraxu daloob sarxalukaay bi, keroog bés ba ñu koy diw. Ñu daldi joxe seeni sarax fi kanam sarxalukaay bi. ");
INSERT INTO wolmbs_vpl VALUES ("NU7_11","005_7_11","NUM","7","11","11","Teewul Aji Sax ji wax Musaa, ne ko: «Kilifa yiy joxesi seen sarax, yi jëm ci daloob sarxalukaay bi, nañu ko def bés bu nekk, kenn.» ");
INSERT INTO wolmbs_vpl VALUES ("NU7_12","005_7_12","NUM","7","12","12","Ki joxe saraxam ci bés bu njëkk bi, ñeel giirug Yuda, mooy Naason doomu Aminadab. ");
INSERT INTO wolmbs_vpl VALUES ("NU7_13","005_7_13","NUM","7","13","13","Ab saraxam di benn ndabu xaalis bu diise téeméeri siikal ak fanweer, muy kilook liibar, ak benn këllu xaalis bu diise juróom ñaar fukki siikal, ci siikal bi ñu yoonal ci néeg bu sell bi, muy juróom ñetti téeméeri garaam, lu ci nekk fees ak sunguf su mucc ayib su ñu xiiwaale ag diw, ngir saraxu pepp bi, ");
INSERT INTO wolmbs_vpl VALUES ("NU7_14","005_7_14","NUM","7","14","14","ak senn mbàttus wurus su fees ak cuuraay te diise fukki siikal, di téeméeri garaam ak fukk ak juróom, ");
INSERT INTO wolmbs_vpl VALUES ("NU7_15","005_7_15","NUM","7","15","15","ak wenn yëkk wu ndaw, ak menn kuuy mu mag, ak menn kuuyu menn at, ngir saraxu rendi-dóomal, ");
INSERT INTO wolmbs_vpl VALUES ("NU7_16","005_7_16","NUM","7","16","16","ak wenn sikket ngir saraxu póotum bàkkaar, ");
INSERT INTO wolmbs_vpl VALUES ("NU7_17","005_7_17","NUM","7","17","17","ak saraxas cant gi ci biir jàmm, di ñaari yëkk ak juróomi kuuy yu mag ak juróomi sikket, ak juróomi kuuyu menn at. Looloo doon saraxu Naason doomu Aminadab. ");
INSERT INTO wolmbs_vpl VALUES ("NU7_18","005_7_18","NUM","7","18","18","Bésub ñaareel ba, kilifag Isakareen ña, Netaneel doomu Cuwar moo indi saraxam, ");
INSERT INTO wolmbs_vpl VALUES ("NU7_19","005_7_19","NUM","7","19","19","sarax ba mu indi di benn ndabu xaalis bu diise téeméeri siikal ak fanweer, di kilook liibar, ak benn këllu xaalis bu diise juróom ñaar fukki siikal, ci siikal bi ñu yoonal ci néeg bu sell bi, muy juróom ñetti téeméeri garaam, lu ci nekk fees ak sunguf su mucc ayib su ñu xiiwaale ag diw, ngir saraxu pepp, ");
INSERT INTO wolmbs_vpl VALUES ("NU7_20","005_7_20","NUM","7","20","20","ak senn mbàttus wurus su fees ak cuuraay te diise fukki siikal, di téeméeri garaam ak fukk ak juróom, ");
INSERT INTO wolmbs_vpl VALUES ("NU7_21","005_7_21","NUM","7","21","21","ak wenn yëkk wu ndaw, ak menn kuuy mu mag, ak menn kuuyu menn at, ngir saraxu rendi-dóomal, ");
INSERT INTO wolmbs_vpl VALUES ("NU7_22","005_7_22","NUM","7","22","22","ak wenn sikket ngir saraxu póotum bàkkaar, ");
INSERT INTO wolmbs_vpl VALUES ("NU7_23","005_7_23","NUM","7","23","23","ak saraxas cant gi ci biir jàmm, di ñaari yëkk ak juróomi kuuy yu mag ak juróomi sikket, ak juróomi kuuyu menn at. Looloo doon saraxu Netaneel doomu Cuwar. ");
INSERT INTO wolmbs_vpl VALUES ("NU7_24","005_7_24","NUM","7","24","24","Bésub ñetteel ba, kilifag Cabuloneen ña, Elyab doomu Elon moo aye, ");
INSERT INTO wolmbs_vpl VALUES ("NU7_25","005_7_25","NUM","7","25","25","ab saraxam di benn ndabu xaalis bu diise téeméeri siikal ak fanweer, muy kilook liibar, ak benn këllu xaalis bu diise juróom ñaar fukki siikal, ci siikal bi ñu yoonal ci néeg bu sell bi, di juróom ñetti téeméeri garaam, lu ci nekk fees ak sunguf su mucc ayib su ñu xiiwaale ag diw, ngir saraxu pepp, ");
INSERT INTO wolmbs_vpl VALUES ("NU7_26","005_7_26","NUM","7","26","26","ak senn mbàttus wurus su fees ak cuuraay te diise fukki siikal, muy téeméeri garaam ak fukk ak juróom, ");
INSERT INTO wolmbs_vpl VALUES ("NU7_27","005_7_27","NUM","7","27","27","ak wenn yëkk wu ndaw, ak menn kuuy mu mag, ak menn kuuyu menn at, ngir saraxu rendi-dóomal, ");
INSERT INTO wolmbs_vpl VALUES ("NU7_28","005_7_28","NUM","7","28","28","ak wenn sikket ngir saraxu póotum bàkkaar, ");
INSERT INTO wolmbs_vpl VALUES ("NU7_29","005_7_29","NUM","7","29","29","ak saraxas cant ci biir jàmm, di ñaari yëkk ak juróomi kuuy yu mag ak juróomi sikket, ak juróomi kuuyu menn at. Looloo doon saraxu Elyab doomu Elon. ");
INSERT INTO wolmbs_vpl VALUES ("NU7_30","005_7_30","NUM","7","30","30","Bésub ñeenteel ba kilifag Rubeneen ña, Elicur doomu Sedeyur moo aye, ");
INSERT INTO wolmbs_vpl VALUES ("NU7_31","005_7_31","NUM","7","31","31","ab saraxam di benn ndabu xaalis bu diise téeméeri siikal ak fanweer, di kilook liibar, ak benn këllu xaalis bu diise juróom ñaar fukki siikal, ci siikal bi ñu yoonal ci néeg bu sell bi, di juróom ñetti téeméeri garaam, lu ci nekk fees ak sunguf su mucc ayib su ñu xiiwaale ag diw, ngir saraxu pepp, ");
INSERT INTO wolmbs_vpl VALUES ("NU7_32","005_7_32","NUM","7","32","32","ak senn mbàttus wurus su fees ak cuuraay te diise fukki siikal, muy téeméeri garaam ak fukk ak juróom, ");
INSERT INTO wolmbs_vpl VALUES ("NU7_33","005_7_33","NUM","7","33","33","ak wenn yëkk wu ndaw, ak menn kuuy mu mag, ak menn kuuyu menn at, ngir saraxu rendi-dóomal, ");
INSERT INTO wolmbs_vpl VALUES ("NU7_34","005_7_34","NUM","7","34","34","ak wenn sikket ngir saraxu póotum bàkkaar, ");
INSERT INTO wolmbs_vpl VALUES ("NU7_35","005_7_35","NUM","7","35","35","ak saraxas cant gi ci biir jàmm, di ñaari yëkk ak juróomi kuuy yu mag ak juróomi sikket, ak juróomi kuuyu menn at. Looloo doon saraxu Elicur doomu Sedeyur. ");
INSERT INTO wolmbs_vpl VALUES ("NU7_36","005_7_36","NUM","7","36","36","Bésub juróomeel ba kilifag Cimyoneen ña, Selumyel doomu Curisadaay moo aye, ");
INSERT INTO wolmbs_vpl VALUES ("NU7_37","005_7_37","NUM","7","37","37","ab saraxam di benn ndabu xaalis bu diise téeméeri siikal ak fanweer, di kilook liibar, ak benn këllu xaalis bu diise juróom ñaar fukki siikal, ci siikal bi ñu yoonal ci néeg bu sell bi, muy juróom ñetti téeméeri garaam, lu ci nekk fees ak sunguf su mucc ayib su ñu xiiwaale ag diw, ngir saraxu pepp, ");
INSERT INTO wolmbs_vpl VALUES ("NU7_38","005_7_38","NUM","7","38","38","ak senn mbàttus wurus su fees ak cuuraay te diise fukki siikal, muy téeméeri garaam ak fukk ak juróom, ");
INSERT INTO wolmbs_vpl VALUES ("NU7_39","005_7_39","NUM","7","39","39","ak wenn yëkk wu ndaw, ak menn kuuy mu mag, ak menn kuuyu menn at, ngir saraxu rendi-dóomal, ");
INSERT INTO wolmbs_vpl VALUES ("NU7_40","005_7_40","NUM","7","40","40","ak wenn sikket ngir saraxu póotum bàkkaar, ");
INSERT INTO wolmbs_vpl VALUES ("NU7_41","005_7_41","NUM","7","41","41","ak saraxas cant gi ci biir jàmm, di ñaari yëkk ak juróomi kuuy yu mag ak juróomi sikket, ak juróomi kuuyu menn at. Looloo doon saraxu Selumyel doomu Curisadaay. ");
INSERT INTO wolmbs_vpl VALUES ("NU7_42","005_7_42","NUM","7","42","42","Bésub juróom benneel ba kilifag Gàddeen ña, Elyasaf doomu Dewel moo aye, ");
INSERT INTO wolmbs_vpl VALUES ("NU7_43","005_7_43","NUM","7","43","43","ab saraxam di benn ndabu xaalis bu diise téeméeri siikal ak fanweer, muy kilook liibar, ak benn këllu xaalis bu diise juróom ñaar fukki siikal, ci siikal bi ñu yoonal ci néeg bu sell bi, muy juróom ñetti téeméeri garaam, lu ci nekk fees ak sunguf su mucc ayib su ñu xiiwaale ag diw, ngir saraxu pepp, ");
INSERT INTO wolmbs_vpl VALUES ("NU7_44","005_7_44","NUM","7","44","44","ak senn mbàttus wurus su fees ak cuuraay te diise fukki siikal, muy téeméeri garaam ak fukk ak juróom, ");
INSERT INTO wolmbs_vpl VALUES ("NU7_45","005_7_45","NUM","7","45","45","ak wenn yëkk wu ndaw, ak menn kuuy mu mag, ak menn kuuyu menn at, ngir saraxu rendi-dóomal, ");
INSERT INTO wolmbs_vpl VALUES ("NU7_46","005_7_46","NUM","7","46","46","ak wenn sikket ngir saraxu póotum bàkkaar, ");
INSERT INTO wolmbs_vpl VALUES ("NU7_47","005_7_47","NUM","7","47","47","ak saraxas cant gi ci biir jàmm, di ñaari yëkk ak juróomi kuuy yu mag ak juróomi sikket, ak juróomi kuuyu menn at. Looloo doon saraxu Elyasaf doomu Dewel. ");
INSERT INTO wolmbs_vpl VALUES ("NU7_48","005_7_48","NUM","7","48","48","Bésub juróom ñaareel ba kilifag Efraymeen ña, Elisama doomu Amiyudd moo aye, ");
INSERT INTO wolmbs_vpl VALUES ("NU7_49","005_7_49","NUM","7","49","49","ab saraxam di benn ndabu xaalis bu diise téeméeri siikal ak fanweer, muy kilook liibar, ak benn këllu xaalis bu diise juróom ñaar fukki siikal, ci siikal bi ñu yoonal ci néeg bu sell bi, muy juróom ñetti téeméeri garaam, lu ci nekk fees ak sunguf su mucc ayib su ñu xiiwaale ag diw, ngir saraxu pepp, ");
INSERT INTO wolmbs_vpl VALUES ("NU7_50","005_7_50","NUM","7","50","50","ak senn mbàttus wurus su fees ak cuuraay te diise fukki siikal, muy téeméeri garaam ak fukk ak juróom, ");
INSERT INTO wolmbs_vpl VALUES ("NU7_51","005_7_51","NUM","7","51","51","ak wenn yëkk wu ndaw, ak menn kuuy mu mag, ak menn kuuyu menn at, ngir saraxu rendi-dóomal, ");
INSERT INTO wolmbs_vpl VALUES ("NU7_52","005_7_52","NUM","7","52","52","ak wenn sikket ngir saraxu póotum bàkkaar, ");
INSERT INTO wolmbs_vpl VALUES ("NU7_53","005_7_53","NUM","7","53","53","ak saraxas cant gi ci biir jàmm, di ñaari yëkk ak juróomi kuuy yu mag ak juróomi sikket, ak juróomi kuuyu menn at. Looloo doon saraxu Elisama doomu Amiyudd. ");
INSERT INTO wolmbs_vpl VALUES ("NU7_54","005_7_54","NUM","7","54","54","Bésub juróom ñetteel ba kilifag Manaseen ña, Gamliyel doomu Pedacur moo aye, ");
INSERT INTO wolmbs_vpl VALUES ("NU7_55","005_7_55","NUM","7","55","55","ab saraxam di benn ndabu xaalis bu diise téeméeri siikal ak fanweer, muy kilook liibar, ak benn këllu xaalis bu diise juróom ñaar fukki siikal, ci siikal bi ñu yoonal ci néeg bu sell bi, muy juróom ñetti téeméeri garaam, lu ci nekk fees ak sunguf su mucc ayib su ñu xiiwaale ag diw, ngir saraxu pepp, ");
INSERT INTO wolmbs_vpl VALUES ("NU7_56","005_7_56","NUM","7","56","56","ak senn mbàttus wurus su fees ak cuuraay te diise fukki siikal, di téeméeri garaam ak fukk ak juróom, ");
INSERT INTO wolmbs_vpl VALUES ("NU7_57","005_7_57","NUM","7","57","57","ak wenn yëkk wu ndaw, ak menn kuuy mu mag, ak menn kuuyu menn at, ngir saraxu rendi-dóomal, ");
INSERT INTO wolmbs_vpl VALUES ("NU7_58","005_7_58","NUM","7","58","58","ak wenn sikket ngir saraxu póotum bàkkaar, ");
INSERT INTO wolmbs_vpl VALUES ("NU7_59","005_7_59","NUM","7","59","59","ak saraxu cant gi ci biir jàmm, di ñaari yëkk ak juróomi kuuy yu mag ak juróomi sikket, ak juróomi kuuyu menn at. Looloo doon saraxu Gamliyel doomu Pedacur. ");
INSERT INTO wolmbs_vpl VALUES ("NU7_60","005_7_60","NUM","7","60","60","Bésub juróom ñeenteel ba kilifag Beñamineen ña, Abidan doomu Gidoni moo aye, ");
INSERT INTO wolmbs_vpl VALUES ("NU7_61","005_7_61","NUM","7","61","61","ab saraxam di benn ndabu xaalis bu diise téeméeri siikal ak fanweer, muy kilook liibar, ak benn këllu xaalis bu diise juróom ñaar fukki siikal, ci siikal bi ñu yoonal ci néeg bu sell bi, muy juróom ñetti téeméeri garaam, lu ci nekk fees ak sunguf su mucc ayib su ñu xiiwaale ag diw, ngir saraxu pepp, ");
INSERT INTO wolmbs_vpl VALUES ("NU7_62","005_7_62","NUM","7","62","62","ak senn mbàttus wurus su fees ak cuuraay te diise fukki siikal, di téeméeri garaam ak fukk ak juróom, ");
INSERT INTO wolmbs_vpl VALUES ("NU7_63","005_7_63","NUM","7","63","63","ak wenn yëkk wu ndaw, ak menn kuuy mu mag, ak menn kuuyu menn at, ngir saraxu rendi-dóomal, ");
INSERT INTO wolmbs_vpl VALUES ("NU7_64","005_7_64","NUM","7","64","64","ak wenn sikket ngir saraxu póotum bàkkaar, ");
INSERT INTO wolmbs_vpl VALUES ("NU7_65","005_7_65","NUM","7","65","65","ak saraxu cant gi ci biir jàmm, di ñaari yëkk ak juróomi kuuy yu mag ak juróomi sikket, ak juróomi kuuyu menn at. Looloo doon saraxu Abidan doomu Gidoni. ");
INSERT INTO wolmbs_vpl VALUES ("NU7_66","005_7_66","NUM","7","66","66","Bésub fukkeel ba kilifag Daneen ña, Axyeser doomu Amisadaay moo aye, ");
INSERT INTO wolmbs_vpl VALUES ("NU7_67","005_7_67","NUM","7","67","67","ab saraxam di benn ndabu xaalis bu diise téeméeri siikal ak fanweer, muy kilook liibar, ak benn këllu xaalis bu diise juróom ñaar fukki siikal, ci siikal bi ñu yoonal ci néeg bu sell bi, muy juróom ñetti téeméeri garaam, lu ci nekk fees ak sunguf su mucc ayib su ñu xiiwaale ag diw, ngir saraxu pepp, ");
INSERT INTO wolmbs_vpl VALUES ("NU7_68","005_7_68","NUM","7","68","68","ak senn mbàttus wurus su fees ak cuuraay te diise fukki siikal, di téeméeri garaam ak fukk ak juróom, ");
INSERT INTO wolmbs_vpl VALUES ("NU7_69","005_7_69","NUM","7","69","69","ak wenn yëkk wu ndaw, ak menn kuuy mu mag, ak menn kuuyu menn at, ngir saraxu rendi-dóomal, ");
INSERT INTO wolmbs_vpl VALUES ("NU7_70","005_7_70","NUM","7","70","70","ak wenn sikket ngir saraxu póotum bàkkaar, ");
INSERT INTO wolmbs_vpl VALUES ("NU7_71","005_7_71","NUM","7","71","71","ak saraxu cant gi ci biir jàmm, di ñaari yëkk ak juróomi kuuy yu mag ak juróomi sikket, ak juróomi kuuyu menn at. Looloo doon saraxu Axyeser doomu Amisadaay. ");
INSERT INTO wolmbs_vpl VALUES ("NU7_72","005_7_72","NUM","7","72","72","Bésub fukkeel baak benn, kilifag Asereen ña, Pagyel doomu Okkran moo aye, ");
INSERT INTO wolmbs_vpl VALUES ("NU7_73","005_7_73","NUM","7","73","73","ab saraxam di benn ndabu xaalis bu diise téeméeri siikal ak fanweer, muy kilook liibar, ak benn këllu xaalis bu juróom ñaar fukki siikal, ci siikal bi ñu yoonal ci néeg bu sell bi, muy juróom ñetti téeméeri garaam, lu ci nekk fees ak sunguf su mucc ayib su ñu xiiwaale ag diw, ngir saraxu pepp, ");
INSERT INTO wolmbs_vpl VALUES ("NU7_74","005_7_74","NUM","7","74","74","ak senn mbàttus wurus su fees ak cuuraay te diise fukki siikal, di téeméeri garaam ak fukk ak juróom, ");
INSERT INTO wolmbs_vpl VALUES ("NU7_75","005_7_75","NUM","7","75","75","ak wenn yëkk wu ndaw, ak menn kuuy mu mag, ak menn kuuyu menn at, ngir saraxu rendi-dóomal, ");
INSERT INTO wolmbs_vpl VALUES ("NU7_76","005_7_76","NUM","7","76","76","ak wenn sikket ngir saraxu póotum bàkkaar, ");
INSERT INTO wolmbs_vpl VALUES ("NU7_77","005_7_77","NUM","7","77","77","ak saraxu cant gi ci biir jàmm, di ñaari yëkk ak juróomi kuuy yu mag ak juróomi sikket, ak juróomi kuuyu menn at. Looloo doon saraxu Pagyel doomu Okkran. ");
INSERT INTO wolmbs_vpl VALUES ("NU7_78","005_7_78","NUM","7","78","78","Bésub fukkeel baak ñaar kilifag Neftaleen ña, Axira doomu Enan moo aye, ");
INSERT INTO wolmbs_vpl VALUES ("NU7_79","005_7_79","NUM","7","79","79","ab saraxam di benn ndabu xaalis bu diise téeméeri siikal ak fanweer, muy kilook liibar, ak benn këllu xaalis bu diise juróom ñaar fukki siikal, ci siikal bi ñu yoonal ci néeg bu sell bi, muy juróom ñetti téeméeri garaam, lu ci nekk fees ak sunguf su mucc ayib su ñu xiiwaale ag diw, ngir saraxu pepp, ");
INSERT INTO wolmbs_vpl VALUES ("NU7_80","005_7_80","NUM","7","80","80","ak senn mbàttus wurus su fees ak cuuraay te diise fukki siikal, di téeméeri garaam ak fukk ak juróom, ");
INSERT INTO wolmbs_vpl VALUES ("NU7_81","005_7_81","NUM","7","81","81","ak wenn yëkk wu ndaw, ak menn kuuy mu mag, ak menn kuuyu menn at, ngir saraxu rendi-dóomal, ");
INSERT INTO wolmbs_vpl VALUES ("NU7_82","005_7_82","NUM","7","82","82","ak wenn sikket ngir saraxu póotum bàkkaar, ");
INSERT INTO wolmbs_vpl VALUES ("NU7_83","005_7_83","NUM","7","83","83","ak saraxu cant gi ci biir jàmm, di ñaari yëkk ak juróomi kuuy yu mag ak juróomi sikket, ak juróomi kuuyu menn at. Looloo doon saraxu Axira doomu Enan. ");
INSERT INTO wolmbs_vpl VALUES ("NU7_84","005_7_84","NUM","7","84","84","Loolooy saraxi daloob sarxalukaay ba, ca bés ba ñu koy diw, sellal ko, lépp bawoo ca kilifay Israayil. Ndabi xaalis ya fukk laak ñaar, këlli xaalis ya di fukk ak ñaar, bàttuy wurus ya di fukk ak ñaar, ");
INSERT INTO wolmbs_vpl VALUES ("NU7_85","005_7_85","NUM","7","85","85","ndabal xaalis lu nekk di téeméeri siikal ak fanweer, di kilook liibar, këll bu nekk di juróom ñaar fukki siikal, di juróom ñetti téeméeri garaam, mboolem xaalisu jumtukaay yi di ñaari junniy siikal, ci siikal bi ñu yoonal ci néeg bu sell bi, ak ñeenti téeméer (2 400), di ñaar fukki kilook juróom ñaar ak juróom benni téeméeri garaam (27 600). ");
INSERT INTO wolmbs_vpl VALUES ("NU7_86","005_7_86","NUM","7","86","86","Fukki bàttuy wurus yi feese cuuraay, mbàttu su ci nekk fukki siikal la, ci siikal bi ñu yoonal ci néeg bu sell bi, di téeméeri garaam ak fukk ak juróom (115), mboolem wurusu bàttu yi di téeméeri siikal ak ñaar fukk (120), muy kilo ak ñetti téeméeri garaam ak juróom ñett fukk (1 380). ");
INSERT INTO wolmbs_vpl VALUES ("NU7_87","005_7_87","NUM","7","87","87","Mboolem nagi saraxu rendi-dóomal yi, fukki yëkk yu ndaw ak ñaar la, kuuy yu mag yi di fukk ak ñaar, kuuyi menn at yi di fukk ak ñaar, ànd ak seen saraxi pepp, sikketi saraxu póotum bàkkaar bi di fukk ak ñaar. ");
INSERT INTO wolmbs_vpl VALUES ("NU7_88","005_7_88","NUM","7","88","88","Mboolem nagi saraxu cantu biir jàmm yi, ñaar fukki yëkk yu ndaw ak ñeent la, kuuy yu mag yi di juróom benn fukk, sikket yi di juróom benn fukk, kuuyi menn at yi di juróom benn fukk. Loolooy saraxi daloob sarxalukaay ba, gannaaw ba ñu ko diwee, sellal ko. ");
INSERT INTO wolmbs_vpl VALUES ("NU7_89","005_7_89","NUM","7","89","89","Bu Musaa duggaan ca biir xaymab ndaje ma, ngir wax ak Aji Sax ji, day dégg baat ba di wax ak moom, bawoo fa tiim kubeeru gaalu seedes kóllëre ga, ca diggante ñaari serub ya. Noonu la daan waxeek moom. ");
INSERT INTO wolmbs_vpl VALUES ("NU8_1","005_8_1","NUM","8","1","1","Aji Sax ji waxati Musaa ne ko, ");
INSERT INTO wolmbs_vpl VALUES ("NU8_2","005_8_2","NUM","8","2","2","mu wax Aaróona, ne ko: «Buy teg làmp yi, fa féete tegukaayu làmp ba kanam, fa la juróom ñaari làmp ya wara niite.» ");
INSERT INTO wolmbs_vpl VALUES ("NU8_3","005_8_3","NUM","8","3","3","Noonu la Aaróona def. Fa féete tegukaay ba kanam, fa la féetale ay làmpam, muy la Aji Sax ji santoon Musaa. ");
INSERT INTO wolmbs_vpl VALUES ("NU8_4","005_8_4","NUM","8","4","4","Tegukaayu làmp bi nag, ni ñu ko liggéeye nii la. Wurus lañu ko tëgge ba mu jekk, dale ko ci tànk bi, ba ci mbar mi. Noonee ko Aji Sax ji wone woon Musaa, na lañu liggéeye tegukaayu làmp ba. ");
INSERT INTO wolmbs_vpl VALUES ("NU8_5","005_8_5","NUM","8","5","5","Aji Sax ji waxati Musaa ne ko, ");
INSERT INTO wolmbs_vpl VALUES ("NU8_6","005_8_6","NUM","8","6","6","«Nanga jële Leween ñi ci biir bànni Israayil te nga setluloo leen. ");
INSERT INTO wolmbs_vpl VALUES ("NU8_7","005_8_7","NUM","8","7","7","Ni ngay def ngir setluloo leen nii la: Danga leen di wis ndoxum setlu, ba noppi ñu wat seen yaram wépp, fóot seeni yére, daldi set. ");
INSERT INTO wolmbs_vpl VALUES ("NU8_8","005_8_8","NUM","8","8","8","Su ko defee ñu jël aw yëkk wu ndaw, booleek saraxu peppam, di sunguf su mucc ayib su ñu xiiwaale ag diw, ak weneen yëkk wu ndaw wooy jël ngir saraxu póotum bàkkaar. ");
INSERT INTO wolmbs_vpl VALUES ("NU8_9","005_8_9","NUM","8","9","9","Indil Leween ñi ci kanam xaymab ndaje mi, te nga dajale mbooloom bànni Israayil mépp. ");
INSERT INTO wolmbs_vpl VALUES ("NU8_10","005_8_10","NUM","8","10","10","Boo indee Leween ñi fi kanam Aji Sax ji, bànni Israayil daldi teg seeni loxo ci kaw Leween ñi. ");
INSERT INTO wolmbs_vpl VALUES ("NU8_11","005_8_11","NUM","8","11","11","Su ko defee Aaróona taxawal Leween ñi taxawaayu saraxu yékkati-jébbal fi kanam Aji Sax ji, muy sarax bu bawoo ci bànni Israayil, Leween ñi daldi sasoo di liggéey liggéeyu Aji Sax ji. ");
INSERT INTO wolmbs_vpl VALUES ("NU8_12","005_8_12","NUM","8","12","12","Leween ñi ñoom, nañu teg seeni loxo ci kaw boppi yëkk yi, ñu def wenn wi saraxu póotum bàkkaar, te def wi ci des ab rendi-dóomal, ñeel Aji Sax ji, ngir njotlaayal Leween ñi. ");
INSERT INTO wolmbs_vpl VALUES ("NU8_13","005_8_13","NUM","8","13","13","Gannaaw loolu ngay taxawal Leween ñi fi kanam Aaróona ak doomam yu góor, daldi leen def saraxu yékkati-jébbal, ñeel Aji Sax ji. ");
INSERT INTO wolmbs_vpl VALUES ("NU8_14","005_8_14","NUM","8","14","14","Noonu ngay seppee Leween ñi ci biir bànni Israayil, Leween ñi doon sama cér. ");
INSERT INTO wolmbs_vpl VALUES ("NU8_15","005_8_15","NUM","8","15","15","Gannaaw loolu la Leween ñiy doora dugg ci liggéeyu xaymab ndaje mi. Danga leen di njëkka setluloo, ba noppi def leen saraxu yékkati-jébbal. ");
INSERT INTO wolmbs_vpl VALUES ("NU8_16","005_8_16","NUM","8","16","16","Ñoom déy lañu ma sédd ba mu mat sëkk ci biir bànni Israayil, ñu wuutu mboolem luy ubbiteg njur, di taawi mboolem bànni Israayil. Maa leen sédd sama bopp. ");
INSERT INTO wolmbs_vpl VALUES ("NU8_17","005_8_17","NUM","8","17","17","Ndax man maa séddoo mboolem taaw ci biir bànni Israayil, nit ak mala. Keroog ba ma reyee mboolem taaw ca réewum Misra, ca laa leen sellalal sama bopp. ");
INSERT INTO wolmbs_vpl VALUES ("NU8_18","005_8_18","NUM","8","18","18","«Maa jël Leween ñi, weccikoo leen bépp taaw ci biir bànni Israayil, ");
INSERT INTO wolmbs_vpl VALUES ("NU8_19","005_8_19","NUM","8","19","19","te itam maa jukkee Leween ñi ci bànni Israayil, maa leen yékkati, jox leen Aaróona aki doomam, ngir ñu liggéey liggéeyu bànni Israayil ci wàllu xaymab ndaje mi, di defal bànni Israayil seenug njotlaay, ngir bu bànni Israayil jegee béreb bu sell bi it, du tax menn mbas am ci seen biir.» ");
INSERT INTO wolmbs_vpl VALUES ("NU8_20","005_8_20","NUM","8","20","20","Ba loolu amee Musaa ak Aaróona ak mbooloom bànni Israayil mépp daldi defal Leween ñi noonu. Mboolem lu Aji Sax ji santoon Musaa ci Leween ñi, noona la ko bànni Israayil defe ak ñoom. ");
INSERT INTO wolmbs_vpl VALUES ("NU8_21","005_8_21","NUM","8","21","21","Leween ñi setlu, fóot seeni yére, Aaróona def leen ni saraxu yékkati-jébbal, ñeel Aji Sax ji. Mu defal leen nag seen njotlaay ngir setal leen. ");
INSERT INTO wolmbs_vpl VALUES ("NU8_22","005_8_22","NUM","8","22","22","Gannaaw loolu Leween ñi doora liggéeyi seen liggéey ci wàllu xaymab ndaje mi, ci kilifteefu Aaróona aki doomam. Noonee ko Aji Sax ji sante woon Musaa ci Leween ñi, na lañu def ak ñoom. ");
INSERT INTO wolmbs_vpl VALUES ("NU8_23","005_8_23","NUM","8","23","23","Aji Sax ji waxati Musaa, ne: ");
INSERT INTO wolmbs_vpl VALUES ("NU8_24","005_8_24","NUM","8","24","24","«Lii nag moo war ci Leween ñi: Ku ci am ñaar fukki at ak juróom, jëm kaw, yelloo naa bokk ci kuréel gi liggéeyu xaymab ndaje mi war. ");
INSERT INTO wolmbs_vpl VALUES ("NU8_25","005_8_25","NUM","8","25","25","Waaye ku xasa am juróom fukki at, na génn kuréel gi boobu liggéey war, te bumu ca liggéeyati. ");
INSERT INTO wolmbs_vpl VALUES ("NU8_26","005_8_26","NUM","8","26","26","Sañ naa jàppale bokki Leweenam ñi sàmm ndénkaaneb xaymab ndaje mi, waaye dootu ci liggéey lenn. Noonu ngay def ak Leween ñi, ci seen wàllu ndénkaane.» ");
INSERT INTO wolmbs_vpl VALUES ("NU9_1","005_9_1","NUM","9","1","1","Aji Sax ji wax na Musaa ca màndiŋu Sinayi, ca seen atum ñaareel, gannaaw ba ñu génnee réewum Misra ca weer wa njëkk. Mu ne ko: ");
INSERT INTO wolmbs_vpl VALUES ("NU9_2","005_9_2","NUM","9","2","2","«Na bànni Israayil di màggal bésub Mucc ba, saa yu jotee. ");
INSERT INTO wolmbs_vpl VALUES ("NU9_3","005_9_3","NUM","9","3","3","«Fukki fan ak ñeent ci weer wii, diggante ngoon ak jant bu so, ci ngeen koy màggal, saa yu jotee. Na mu dëppook mboolem dogali yoonam ak àttey yoonam, nangeen ko màggale noonu.» ");
INSERT INTO wolmbs_vpl VALUES ("NU9_4","005_9_4","NUM","9","4","4","Musaa nag sant bànni Israayil ne leen ñu màggal bésub Mucc bi. ");
INSERT INTO wolmbs_vpl VALUES ("NU9_5","005_9_5","NUM","9","5","5","Ñu daldi màggal bésub Mucc bi ci weer wi njëkk, fukki fanam ak ñeent, diggante ngoon ak jant bu so, ca màndiŋu Sinayi. Noonee ko Aji Sax ji sante woon Musaa, na la ko bànni Israayil defe. ");
INSERT INTO wolmbs_vpl VALUES ("NU9_6","005_9_6","NUM","9","6","6","Ci biir loolu mu am ay nit ñu ab néew tax ñu sobewu, ba manuñoo màggal bésub Mucc bi bésub keroog. Ñu dikk ba ci Musaa ak Aaróona ca bés ba. ");
INSERT INTO wolmbs_vpl VALUES ("NU9_7","005_9_7","NUM","9","7","7","Ñooñu nag ne Musaa: «Nun de, danoo sobewu ndax ab néew, waaye lu nu teree joxesi saraxu Aji Sax ji ci waxtoom, ci digg bànni Israayil?» ");
INSERT INTO wolmbs_vpl VALUES ("NU9_8","005_9_8","NUM","9","8","8","Musaa ne leen: «Taxawleen, ba ma dégg lu Aji Sax ji di santaane ci seen mbir.» ");
INSERT INTO wolmbs_vpl VALUES ("NU9_9","005_9_9","NUM","9","9","9","Aji Sax ji ne Musaa: ");
INSERT INTO wolmbs_vpl VALUES ("NU9_10","005_9_10","NUM","9","10","10","«Waxal bànni Israayil ne leen, képp ku bokk ci yeen tey, mbaa mu bokk ci seen kuutaay ëllëg, su sobewoo ndax ab néew, mbaa mu nekk ci yoon wu sore, du tere mu màggal bésub Mucc bi ngir Aji Sax ji. ");
INSERT INTO wolmbs_vpl VALUES ("NU9_11","005_9_11","NUM","9","11","11","Waaye ñaareelu weer wa, ca fukki fanam ak ñeent, diggante ngoon ak jant bu so, ca la koy màggal. Mburu mu amul lawiir ak xob yu wex lay booleek gàttu sarax bi, lekk ko. ");
INSERT INTO wolmbs_vpl VALUES ("NU9_12","005_9_12","NUM","9","12","12","Bumu ci wacc dara mu fanaan, te benn yax, bumu ko ci damm. Na mu dëppook mboolem dogali yooni bésub Mucc, na ko màggale noonu. ");
INSERT INTO wolmbs_vpl VALUES ("NU9_13","005_9_13","NUM","9","13","13","Ku set nag te nekkul ciw yoon, su ñàkkee màggal bésub Mucc bi, kooku dees koy dagge ciw askanam, ndax saraxu Aji Sax ji mu joxewul ci bésam. Kooku moo gàddu bàkkaaru boppam. ");
INSERT INTO wolmbs_vpl VALUES ("NU9_14","005_9_14","NUM","9","14","14","«Su dee ab doxandéem bu ngeen dëkkal, sañ naa màggal bésub Mucc bi ñeel Aji Sax ji. Na mu dëppook mboolem dogali yooni bésub Mucc, ak àttey yoonam, ni la koy màggale; benn dogal bi lay doon ci yeen, muy doxandéem bi, di njuddu-ji-réew.» ");
INSERT INTO wolmbs_vpl VALUES ("NU9_15","005_9_15","NUM","9","15","15","Keroog bés ba ñu sampee màkkaan ma, niir wa daa muur màkkaanu xayma ba seedes kóllëre gi dence. Ca ngoon sa lu mel ni sawara tiim màkkaan ma, ba ca ëllëg sa. ");
INSERT INTO wolmbs_vpl VALUES ("NU9_16","005_9_16","NUM","9","16","16","Noonu la ko niir wa jàppoo muure, bu guddee mu mel ni sawara. ");
INSERT INTO wolmbs_vpl VALUES ("NU9_17","005_9_17","NUM","9","17","17","Fu niir wa masa yékkatikoo fa tiim xayma ba, bànni Israayil day fabu topp ko, te fépp fu niir wa masa dale, fa la bànni Israayil di fàkk ab dal. ");
INSERT INTO wolmbs_vpl VALUES ("NU9_18","005_9_18","NUM","9","18","18","Ci kàddug Aji Sax ji la bànni Israayil daan faboo, ci kàddug Aji Sax ji lañu daan dale, te mboolem fan ya niir way dal, tiim màkkaan ma, ñoom it dañuy dal. ");
INSERT INTO wolmbs_vpl VALUES ("NU9_19","005_9_19","NUM","9","19","19","Su niir wa yàggee ca kaw màkkaan ma it, ak lu fan ya baree bare, bànni Israayil a ngay sàmm ndénkaaneb Aji Sax ji, waaye duñu dem. ");
INSERT INTO wolmbs_vpl VALUES ("NU9_20","005_9_20","NUM","9","20","20","Léeg-léegaa fan yu néew la niir way dallu fa tiim màkkaan ma. Waaye ci kàddug Aji Sax ji daal, lañuy dale te ci kàddug Aji Sax ji lañuy faboo. ");
INSERT INTO wolmbs_vpl VALUES ("NU9_21","005_9_21","NUM","9","21","21","Léeg-léegaa it niir wa dallu ag ngoon, fanaan, ba bët set, mu sàqi, ñu fabu ànd ak moom. Muy guddi, di bëccëg, bu niir wa jógaa, rekk, ñu fabu. ");
INSERT INTO wolmbs_vpl VALUES ("NU9_22","005_9_22","NUM","9","22","22","Su doon ñaari fan, su doon weer, mbaa ay fani fan la niir wa taxaw tiim màkkaan ma, des fa it, bànni Israayil dañuy dal, waaye duñu dem. Bu jógee rekk lañuy fabu. ");
INSERT INTO wolmbs_vpl VALUES ("NU9_23","005_9_23","NUM","9","23","23","Ci kàddug Aji Sax ji lañu daa dale, ci kàddug Aji Sax ji lañu daa faboo. Ndénkaaneb Aji Sax ji daal lañuy sàmm, ci kàddug Aji Sax ji, Musaa di jottali. ");
INSERT INTO wolmbs_vpl VALUES ("NU10_1","005_10_1","NUM","10","1","1","Aji Sax ji waxati Musaa, ne: ");
INSERT INTO wolmbs_vpl VALUES ("NU10_2","005_10_2","NUM","10","2","2","«Sàkklul ñaari liiti xaalis. Lu ñu tëgglu ba mu jekk nga koy def. Liit yi ngay wootee am ndaje, di ko yékkatee dal yi. ");
INSERT INTO wolmbs_vpl VALUES ("NU10_3","005_10_3","NUM","10","3","3","Bu ñu liitee ñaar yépp, mbooloo mépp ay dajesi fi yaw, ci bunt xaymab ndaje mi. ");
INSERT INTO wolmbs_vpl VALUES ("NU10_4","005_10_4","NUM","10","4","4","Bu ñu liitee benn nag, kilifa yi jiite gàngoori Israayil ñooy dajesi fi yaw. ");
INSERT INTO wolmbs_vpl VALUES ("NU10_5","005_10_5","NUM","10","5","5","Su ñu liitee menn riirum liit mu xumb, dal yi dale penku ñooy fabu. ");
INSERT INTO wolmbs_vpl VALUES ("NU10_6","005_10_6","NUM","10","6","6","Su ñu liitee riirum liit mu xumb, ñaareel bi yoon, dal yi dale bëj-saalum ñooy fabu. Riirum liit mu xumb mooy tegtale seeni fabu. ");
INSERT INTO wolmbs_vpl VALUES ("NU10_7","005_10_7","NUM","10","7","7","Bu dee wooteb ndaje nag, dees koy liit waaye du doon riir mu xumb. ");
INSERT INTO wolmbs_vpl VALUES ("NU10_8","005_10_8","NUM","10","8","8","Na doomi Aaróona sarxalkat yi di wal liit yi, te mu doon dogal bu leen saxal dàkk, ci seen maasoo maas. ");
INSERT INTO wolmbs_vpl VALUES ("NU10_9","005_10_9","NUM","10","9","9","«Bu loolu wéyee, bu ngeen dee xare ci seenum réew, ak noon bu leen songsi, nangeen riiral liit yi riir mu xumb, su boobaa dees na leen bàyyi xel fa seen kanam Yàlla Aji Sax ji, ba wallu leen ak seeni noon. ");
INSERT INTO wolmbs_vpl VALUES ("NU10_10","005_10_10","NUM","10","10","10","Seen bési mbég itam, muy seen bési màggal, di seen ndoortel weer, nangeen ciy riiral liit yi riir mu xumb, yéenee ko seen saraxi rendi-dóomal, ak seen saraxi cant ci biir jàmm. Riirum liit yooyu mooy doon seen baaxantal fa seen kanam Yàlla. Maay seen Yàlla, Aji Sax ji.» ");
INSERT INTO wolmbs_vpl VALUES ("NU10_11","005_10_11","NUM","10","11","11","Ca ñaareelu at ma, gannaaw ba bànni Israayil génnee Misra, ca ñaareelu weer wa, keroog ñaar fukkeelu fanam, ca la niir wa bàyyikoo fa tiim màkkaanu seedes kóllëre ga. ");
INSERT INTO wolmbs_vpl VALUES ("NU10_12","005_10_12","NUM","10","12","12","Bànni Israayil daldi sumb seen yooni tukki ya, bàyyikoo màndiŋu Sinayi. Ci kaw loolu niir wa daleji ca màndiŋu Paran. ");
INSERT INTO wolmbs_vpl VALUES ("NU10_13","005_10_13","NUM","10","13","13","Booba lañu njëkka fabu ci kàddug Aji Sax ji, Musaa jottali. ");
INSERT INTO wolmbs_vpl VALUES ("NU10_14","005_10_14","NUM","10","14","14","Raayab dalu Yudeen ña moo njëkka jóg, ànd aki gàngooram, njiital gàngooru Yuda di Naason doomu Aminadab, ");
INSERT INTO wolmbs_vpl VALUES ("NU10_15","005_10_15","NUM","10","15","15","njiital gàngooru Isakareen ña di Netaneel doomu Cuwar, ");
INSERT INTO wolmbs_vpl VALUES ("NU10_16","005_10_16","NUM","10","16","16","njiital gàngooru Cabuloneen ña di Elyab doomu Elon. ");
INSERT INTO wolmbs_vpl VALUES ("NU10_17","005_10_17","NUM","10","17","17","Ci biir loolu ñu wékki jaamookaay ba, Gersoneen ñaak Merareen ñay gàddu jaamookaay ba daldi dem. ");
INSERT INTO wolmbs_vpl VALUES ("NU10_18","005_10_18","NUM","10","18","18","Raayab dalu Rubeneen ña jóg ànd aki gàngooram, topp ca, njiital gàngooru Rubeneen ña di Elicur doomu Sedeyur, ");
INSERT INTO wolmbs_vpl VALUES ("NU10_19","005_10_19","NUM","10","19","19","njiital gàngooru Cimyoneen ña di Selumyel doomu Curisadaay, ");
INSERT INTO wolmbs_vpl VALUES ("NU10_20","005_10_20","NUM","10","20","20","njiital gàngooru Gàddeen ña di Elyasaf doomu Dewel. ");
INSERT INTO wolmbs_vpl VALUES ("NU10_21","005_10_21","NUM","10","21","21","Gannaaw loolu Keyateen ñay gàddu yëf yu sell ya, ñoo fabu, topp ca. Bala ñoo àgg fa ñuy dalewaat nag, day fekk jaamookaay ba sampewaat. ");
INSERT INTO wolmbs_vpl VALUES ("NU10_22","005_10_22","NUM","10","22","22","Ci kaw loolu raayab dalu Efraymeen ña jóg, ànd ak seeni gàngoor, topp ca, njiital gàngooru Efraymeen ña di Elisama doomu Amiyudd, ");
INSERT INTO wolmbs_vpl VALUES ("NU10_23","005_10_23","NUM","10","23","23","njiital gàngooru Manaseen ña di Gamliyel doomu Pedacur, ");
INSERT INTO wolmbs_vpl VALUES ("NU10_24","005_10_24","NUM","10","24","24","njiital gàngooru Beñamineen ña di Abidan doomu Gidoni. ");
INSERT INTO wolmbs_vpl VALUES ("NU10_25","005_10_25","NUM","10","25","25","Ba mu ko defee raayab dalu Daneen ña doora jóg, topp ca gannaaw kuréel yépp, ànd aki gàngooram, njiital gàngooru Daneen ña di Axyeser doomu Amisadaay, ");
INSERT INTO wolmbs_vpl VALUES ("NU10_26","005_10_26","NUM","10","26","26","njiital gàngooru Asereen ña di Pagyel doomu Okkran, ");
INSERT INTO wolmbs_vpl VALUES ("NU10_27","005_10_27","NUM","10","27","27","njiital gàngooru Neftaleen ña di Axira doomu Enan. ");
INSERT INTO wolmbs_vpl VALUES ("NU10_28","005_10_28","NUM","10","28","28","Noonu la bànni Israayil topplantee, ànd ak seeni gàngoor, tegu ca yoon wa. ");
INSERT INTO wolmbs_vpl VALUES ("NU10_29","005_10_29","NUM","10","29","29","Ba loolu amee Musaa wax ak Obab doomu Ruwel waa Majan ba, baayu soxnaam, ne ko: «Nu ngi nii jëm fa nu Aji Sax ji wax ne moom lanuy jox. Kaay nu ànd, dem, nu baaxe la, ndax Aji Sax ji moo digee baaxe Israayil.» ");
INSERT INTO wolmbs_vpl VALUES ("NU10_30","005_10_30","NUM","10","30","30","Mu ne ko: «Déedéet, duma dem, samam réew kay laa jëm, ca saay bokk.» ");
INSERT INTO wolmbs_vpl VALUES ("NU10_31","005_10_31","NUM","10","31","31","Mu ne ko: «Bu nu wacc kay, ndax gannaaw yaa xam fu nu wara dal ci màndiŋ mi, yaa nu wara jiite. ");
INSERT INTO wolmbs_vpl VALUES ("NU10_32","005_10_32","NUM","10","32","32","Soo àndeek nun déy, xéewal googa nu Aji Sax jiy baaxeji, dinanu la ci baaxe.» ");
INSERT INTO wolmbs_vpl VALUES ("NU10_33","005_10_33","NUM","10","33","33","Ci kaw loolu ñu bàyyikoo ca tundu Aji Sax ja, doxe fa doxub ñetti fan. Gaalu kóllërey Aji Sax jaa nga leen jiitu diiru ñetti fan ña, di leen wutal dalluwaay. ");
INSERT INTO wolmbs_vpl VALUES ("NU10_34","005_10_34","NUM","10","34","34","Niiru Aji Sax ji nag di leen yiir bëccëg bu nekk, saa yu ñu bàyyikoo ab dal. ");
INSERT INTO wolmbs_vpl VALUES ("NU10_35","005_10_35","NUM","10","35","35","Bu gaal ga jógaan, Musaa da naan: «Jógaloo, Aji Sax ji, say noon fëlxoo, say bañ daw la.» ");
INSERT INTO wolmbs_vpl VALUES ("NU10_36","005_10_36","NUM","10","36","36","Bu gaal ga dalee, Musaa ne: «Dikkaloo Aji Sax ji boroom ndiiraani junniy Israayil.» ");
INSERT INTO wolmbs_vpl VALUES ("NU11_1","005_11_1","NUM","11","1","1","Mbooloo ma nag mujj di tawat ab coono fi kanam Aji Sax ji. Aji Sax ji dégg ci, am sànjam tàkk, sawaras Aji Sax ji tàkkal leen, ba xoyom la wër dal ba. ");
INSERT INTO wolmbs_vpl VALUES ("NU11_2","005_11_2","NUM","11","2","2","Mbooloo ma jooy ko Musaa, Musaa tinu Aji Sax ji, sawara wa fey. ");
INSERT INTO wolmbs_vpl VALUES ("NU11_3","005_11_3","NUM","11","3","3","Ñu tudde béreb boobu Tabera (mu neexook Tàkkaan), ndax sawaras Aji Sax ji leen fa tàkkal. ");
INSERT INTO wolmbs_vpl VALUES ("NU11_4","005_11_4","NUM","11","4","4","Ci biir loolu genn gàngooru njaxasaan mu nekkoon ca seen biir jiital seen bakkan, di ŋaf-ŋafi, ba tax bànni Israayil itam dellu di jàmbat. Ña nga naan: «Éy ku nuy leelatiw yàpp! ");
INSERT INTO wolmbs_vpl VALUES ("NU11_5","005_11_5","NUM","11","5","5","Namm nan jën ya nu daa ndawaloo ca Misra, te dikkewu nu tus! Ak yomb jaak xaal jaak pooro baak soble saak laaj ja! ");
INSERT INTO wolmbs_vpl VALUES ("NU11_6","005_11_6","NUM","11","6","6","Tey jii sunu put yaa ngi wow koŋŋ, gisunu lenn lu moy mànn!» ");
INSERT INTO wolmbs_vpl VALUES ("NU11_7","005_11_7","NUM","11","7","7","Mànn ma nag daa meloon ni pepp mi ñuy wax koryanda, te nirook ndàbbu garab gi ñuy wax bedelyum. ");
INSERT INTO wolmbs_vpl VALUES ("NU11_8","005_11_8","NUM","11","8","8","Mbooloo ma da daan wër, di ko for, di ko wole doji wolukaay, mbaa ñu di ko dëbb ciy gënn, ba noppi baxal ko ci cin, def ko ay mburu yu cafkaam mel ni cafkay nàkk yu am niw. ");
INSERT INTO wolmbs_vpl VALUES ("NU11_9","005_11_9","NUM","11","9","9","Bu layaa ca dal ba ag guddi, mànn ma day wàccaale ak moom. ");
INSERT INTO wolmbs_vpl VALUES ("NU11_10","005_11_10","NUM","11","10","10","Ci biir loolu Musaa dégg mbooloo miy ñaxtu, làng ak làng, ku nekk ci sa bunt xayma. Ba loolu amee sànjum Aji Sax ji tàkk jippét, Musaa nag ñaawlu ko. ");
INSERT INTO wolmbs_vpl VALUES ("NU11_11","005_11_11","NUM","11","11","11","Ba mu ko defee Musaa ne Aji Sax ji: «Aji Sax ji, loo may mititale, Sang bi? Lu tee nga baaxe ma, xanaa ngay teg sëfub mii mbooloo mépp ci sama kaw? ");
INSERT INTO wolmbs_vpl VALUES ("NU11_12","005_11_12","NUM","11","12","12","Xanaa maa ëmb mii mbooloo mépp, am maa leen jur, ba nga di ma leen bootloo fàpp, ni jaboot di boote luy nàmp, jëme leen réew ma nga giñaloon seeni maam? ");
INSERT INTO wolmbs_vpl VALUES ("NU11_13","005_11_13","NUM","11","13","13","Ana fu may jële yàpp wu ma jox mii mbooloo mépp, ba ñuy jooy nii ci sama kaw, naa ma: “Jox nu yàpp wu nu lekk”? ");
INSERT INTO wolmbs_vpl VALUES ("NU11_14","005_11_14","NUM","11","14","14","Manumaa boot mii mbooloo mépp, man doŋŋ, ndax àttanuma ko. ");
INSERT INTO wolmbs_vpl VALUES ("NU11_15","005_11_15","NUM","11","15","15","Su dee nii ngay def ak man nag, dimbali ma rekk, rey ma ba ma dee, ndax ma baña gis sama toskare.» ");
INSERT INTO wolmbs_vpl VALUES ("NU11_16","005_11_16","NUM","11","16","16","Ba mu ko defee Aji Sax ji wax Musaa, ne ko: «Dajaleel ma juróom ñaar fukki magi Israayil, ñoo xamal sa bopp ne ñooy magi mbooloo mi, di seeni njiit, nga indi leen ci xaymab ndaje mi, ñu teew faak yaw. ");
INSERT INTO wolmbs_vpl VALUES ("NU11_17","005_11_17","NUM","11","17","17","Maay wàcc wax ak yaw foofa te maay sàkk ci leer gi ci yaw, def ko ci ñoom, ñu yenule la yenu mbooloo mi, ba dootuloo ko yenu yaw doŋŋ. ");
INSERT INTO wolmbs_vpl VALUES ("NU11_18","005_11_18","NUM","11","18","18","«Mbooloo mi nag, ne leen ñu sangu-set ngir ëllëg, te ne leen dinañu yàpp moos, gannaaw ñooy jooy ci kaw Aji Sax ji, naan “Éy ku nuy leelatiw yàpp, nooka neexle woon ca Misra!” Kon nag Aji Sax jee leen di jox yàpp wu ñu lekk. ");
INSERT INTO wolmbs_vpl VALUES ("NU11_19","005_11_19","NUM","11","19","19","Du benn fan lañuy yàpp, du ñaar, du juróomi fan, du fukk, te du ñaar fukki fan. ");
INSERT INTO wolmbs_vpl VALUES ("NU11_20","005_11_20","NUM","11","20","20","Weeru lëmm kay lañuy yàpp, ba yàpp wiy génne ci seen paxi bakkan, ba mujj génnliku leen, gannaaw ñoo xarab Aji Sax ji ci seen biir, di jooy ci kawam, naan: “Moo, lu nu taxoona jóge Misra!”» ");
INSERT INTO wolmbs_vpl VALUES ("NU11_21","005_11_21","NUM","11","21","21","Ci kaw loolu Musaa ne: «Ãa! Juróom benni téeméeri junniy (600 000) góor a ngi ci mbooloo mii ma ne ci seen biir. Yaw nga ne aw yàpp nga leen di jox, ñu yàpp weeru lëmm! ");
INSERT INTO wolmbs_vpl VALUES ("NU11_22","005_11_22","NUM","11","22","22","Diggante jur gu gudd ak gu gàtt, manees na leen cee rendil lu leen doy a? Am mboolem jëni géej lees leen di dajaleel, mu doy leen?» ");
INSERT INTO wolmbs_vpl VALUES ("NU11_23","005_11_23","NUM","11","23","23","Aji Sax ji ne Musaa: «Loxol Aji Sax ji da koo jotewul? Léegi nag dinga gis ndax sama kàddu dina la sottil, am déet!» ");
INSERT INTO wolmbs_vpl VALUES ("NU11_24","005_11_24","NUM","11","24","24","Ci kaw loolu Musaa génn, jottali mbooloo ma kàdduy Aji Sax ji, daldi dajale juróom ñaar fukki góor ñu bokk ca magi mbooloo ma, taxawal leen, ñu wër xayma ba. ");
INSERT INTO wolmbs_vpl VALUES ("NU11_25","005_11_25","NUM","11","25","25","Aji Sax ji nag wàcc ca biir niir wa, wax ak moom, daldi sàkk ca leer ga ca Musaa, sédd ca juróom ñaar fukki mag ña. Naka la leer ga dal ca seen kaw, ñu tàmbali di jottali ay kàdduy waxyu, benn yoon bu ñu tóllantiwul. ");
INSERT INTO wolmbs_vpl VALUES ("NU11_26","005_11_26","NUM","11","26","26","Fekk na ñaari góor a nga desoon ca dal ba, kenn ka di Eldàdd, ka ca des di Medàdd, te teewul leer ga dal ca seen kaw, ndax dees leena limaale woon ca mag ña, doonte demuñu ca xayma ba. Ñoom it ñuy jottali ay kàdduy waxyu ca dal ba. ");
INSERT INTO wolmbs_vpl VALUES ("NU11_27","005_11_27","NUM","11","27","27","Ab xale dawe ca, àgge ko Musaa, ne ko: «Eldàdd ak Medàdd déy a ngay jottali ay kàdduy waxyu ca dal ba!» ");
INSERT INTO wolmbs_vpl VALUES ("NU11_28","005_11_28","NUM","11","28","28","Yosuwe doomu Nuun ja dale doon bëkk-néegu Musaa cag ndawam, daldi cay àddu, ne: «Sang Musaa, aaye leen!» ");
INSERT INTO wolmbs_vpl VALUES ("NU11_29","005_11_29","NUM","11","29","29","Musaa ne ko: «Fiiraangee la jàpp ndax man, am? Éy bu niti mbooloom Aji Sax ji mépp doon ay yonent, Aji Sax ji sang leen ag leeram!» ");
INSERT INTO wolmbs_vpl VALUES ("NU11_30","005_11_30","NUM","11","30","30","Ba loolu amee Musaa dellu ca dal ba, moom ak magi Israayil ña. ");
INSERT INTO wolmbs_vpl VALUES ("NU11_31","005_11_31","NUM","11","31","31","Ba loolu amee ngelaw wale ci Aji Sax ji, daldi bàbbee ca géej ga ay picci përëntaan, wàcce leen ca dal ba lu tollook doxub benn fan ci gii wet, ak doxub benn fan ca gee, ñu dajal dal ba bépp, jale ci suuf ba xawa mat ñaari xasab. ");
INSERT INTO wolmbs_vpl VALUES ("NU11_32","005_11_32","NUM","11","32","32","Ci kaw loolu mbooloo ma taxaw di for, bëccëgub keroog bépp, ak guddi ga gépp, ak bëccëgub ëllëg sa sépp, ba ka gëna néewle, for lu mat fukki barigo. Ñu weer përëntaan ya fa wër dal ba. ");
INSERT INTO wolmbs_vpl VALUES ("NU11_33","005_11_33","NUM","11","33","33","Suux waa nga ca seeni gëñ, sàqameeguñu sax, sànjum Aji Sax ji tàkkal mbooloo ma. Aji Sax ji dumaa mbooloo ma mbas mu metti lool. ");
INSERT INTO wolmbs_vpl VALUES ("NU11_34","005_11_34","NUM","11","34","34","Moo tax ñu tudde béreb booba Kibbrot Taawa (muy firi Bàmmeeli Ŋaf-ŋaf), ndax fa lañu denc néewi mbooloo ma doon ŋaf-ŋafi. ");
INSERT INTO wolmbs_vpl VALUES ("NU11_35","005_11_35","NUM","11","35","35","Kibbrot Taawa la mbooloo ma bàyyikoo, jëm Àccerot. Ñu dal nag ca Àccerot. ");
INSERT INTO wolmbs_vpl VALUES ("NU12_1","005_12_1","NUM","12","1","1","Maryaama ak Aaróona ñoo doon ŋàññ Musaa, ci ndawas Kuuseen su mu takkoon, te ab Kuuseen it la takkoon. ");
INSERT INTO wolmbs_vpl VALUES ("NU12_2","005_12_2","NUM","12","2","2","Ñu ne: «Ndax mennum Musaa doŋŋ la Aji Sax jiy waxe ci moom? Xanaa daa waxewul ci nun itam?» Aji Sax ji dégg ca. ");
INSERT INTO wolmbs_vpl VALUES ("NU12_3","005_12_3","NUM","12","3","3","Góor ga Musaa nag defoon ku woyof lool, ba raw mboolem doom aadama ci kaw suuf. ");
INSERT INTO wolmbs_vpl VALUES ("NU12_4","005_12_4","NUM","12","4","4","Ci kaw loolu Aji Sax ji jekki wax ak Musaa ak Aaróona ak Maryaama, ne leen: «Dikkleen, yeen ñett, ci xaymab ndaje mi!» Ñu dem, ñoom ñett. ");
INSERT INTO wolmbs_vpl VALUES ("NU12_5","005_12_5","NUM","12","5","5","Aji Sax ji wàcc ci biir niir wu def aw taxaar. Mu taxaw ca bunt xayma ba, daldi woo Aaróona ak Maryaama, ñu bokk dikk. ");
INSERT INTO wolmbs_vpl VALUES ("NU12_6","005_12_6","NUM","12","6","6","Mu ne leen: «Dégluleen bu baax samay kàddu: Su ngeen feeñlee ab yonentu Aji Sax ji, ci am peeñu laa koy xamale maay kan, te ci gént laay waxeek moom, ");
INSERT INTO wolmbs_vpl VALUES ("NU12_7","005_12_7","NUM","12","7","7","waaye du Musaa sama jaam bii. Moom mooy ki wóor ci mboolem sama kër gii. ");
INSERT INTO wolmbs_vpl VALUES ("NU12_8","005_12_8","NUM","12","8","8","Gémmiñ ak gémmiñ laay waxeek moom wax ju leer nàññ ju ñu léebul, te jëmmu Aji Sax ji lay gis. Kon lu leen may fitu ŋàññ Musaa sama jaam bi?» ");
INSERT INTO wolmbs_vpl VALUES ("NU12_9","005_12_9","NUM","12","9","9","Sànjum Aji Sax ji nag tàkkal leen. Ci kaw loolu mu dem. ");
INSERT INTO wolmbs_vpl VALUES ("NU12_10","005_12_10","NUM","12","10","10","Naka la niir wa jóge ca xayma ba, Maryaama jekki ne fureet ak jàngoroy ngaana, weex furr! Aaróona ne Maryaama gees, yem ca ngaana ga. ");
INSERT INTO wolmbs_vpl VALUES ("NU12_11","005_12_11","NUM","12","11","11","Aaróona ne Musaa: «Ngalla sang bi, bu nu topp bàkkaar bi nu bàkkaar ndax ñàkk xel! ");
INSERT INTO wolmbs_vpl VALUES ("NU12_12","005_12_12","NUM","12","12","12","Ngalla bul seetaan kii mel ni ku dee te indaalewul bakkan ba mu juddoo ca ndeyam, xaaju yaram wi lekku!» ");
INSERT INTO wolmbs_vpl VALUES ("NU12_13","005_12_13","NUM","12","13","13","Musaa nag jooy Aji Sax ji, ne ko: «Yàlla, ngalla wéral ko!» ");
INSERT INTO wolmbs_vpl VALUES ("NU12_14","005_12_14","NUM","12","14","14","Aji Sax ji ne Musaa: «Xanaa baayam sax su ko jéppi woon, ba tifli ko ci kanam, muy gàcceem diiru juróom ñaari fan? Nañu ko génne dal bi diiru juróom ñaari fan, door koo delloosi ci biir.» ");
INSERT INTO wolmbs_vpl VALUES ("NU12_15","005_12_15","NUM","12","15","15","Ba loolu amee ñu génne Maryaama dal ba diiru juróom ñaari fan. Mbooloo ma demul, ba keroog ba ñu delloosee Maryaama ca biir dal ba. ");
INSERT INTO wolmbs_vpl VALUES ("NU12_16","005_12_16","NUM","12","16","16","Gannaaw loolu mbooloo ma bàyyikoo Àccerot, ñu dali ca màndiŋu Paran. ");
INSERT INTO wolmbs_vpl VALUES ("NU13_1","005_13_1","NUM","13","1","1","Aji Sax ji waxati Musaa, ne: ");
INSERT INTO wolmbs_vpl VALUES ("NU13_2","005_13_2","NUM","13","2","2","«Yebalal ay ndaw, ñu dem yëri réewum Kanaan, gi may jox bànni Israayil. Kenn ngay yebal ci seen giiri maam yi, giir gu ci nekk, kenn, te ku ci nekk di kilifa ci ñoom.» ");
INSERT INTO wolmbs_vpl VALUES ("NU13_3","005_13_3","NUM","13","3","3","Ci kaw loolu Musaa yebal ndaw ña ci ndigalal Aji Sax ji, ñu bàyyikoo ca màndiŋu Paran. Ñoom ñépp ay njiiti bànni Israayil lañu woon. ");
INSERT INTO wolmbs_vpl VALUES ("NU13_4","005_13_4","NUM","13","4","4","Ñooñu ñoo di: Samwa doomu Sakur, ci giirug Rubeneen ñi, ");
INSERT INTO wolmbs_vpl VALUES ("NU13_5","005_13_5","NUM","13","5","5","ak Safat doomu Ori, ci giirug Cimyoneen ñi, ");
INSERT INTO wolmbs_vpl VALUES ("NU13_6","005_13_6","NUM","13","6","6","ak Kaleb doomu Yefune, ci giirug Yudeen ñi, ");
INSERT INTO wolmbs_vpl VALUES ("NU13_7","005_13_7","NUM","13","7","7","ak Igal doomu Yuusufa, ci giirug Isakareen ñi, ");
INSERT INTO wolmbs_vpl VALUES ("NU13_8","005_13_8","NUM","13","8","8","ak Ose doomu Nuun, ci giirug Efraymeen ñi, ");
INSERT INTO wolmbs_vpl VALUES ("NU13_9","005_13_9","NUM","13","9","9","ak Palti doomu Rafu, ci giirug Beñamineen ñi, ");
INSERT INTO wolmbs_vpl VALUES ("NU13_10","005_13_10","NUM","13","10","10","ak Gadyel doomu Sodi, ci giirug Cabuloneen ñi, ");
INSERT INTO wolmbs_vpl VALUES ("NU13_11","005_13_11","NUM","13","11","11","ak Gadi doomu Susi, mi taxawal làngu Manase ci biir giirug Yuusufeen ñi, ");
INSERT INTO wolmbs_vpl VALUES ("NU13_12","005_13_12","NUM","13","12","12","ak Amyel doomu Gemali, ci giirug Daneen ñi, ");
INSERT INTO wolmbs_vpl VALUES ("NU13_13","005_13_13","NUM","13","13","13","ak Setur doomu Mikayel, ci giirug Asereen ñi, ");
INSERT INTO wolmbs_vpl VALUES ("NU13_14","005_13_14","NUM","13","14","14","ak Nabi doomu Wofsi, ci giirug Neftaleen ñi, ");
INSERT INTO wolmbs_vpl VALUES ("NU13_15","005_13_15","NUM","13","15","15","ak Gewuyel doomu Maki, ci giiru Gàddeen ñi. ");
INSERT INTO wolmbs_vpl VALUES ("NU13_16","005_13_16","NUM","13","16","16","Ñooñu la Musaa yónni woon, ngir ñu yëri réew ma. Ose doomu Nuun nag, Musaa tudde ko Yosuwe. ");
INSERT INTO wolmbs_vpl VALUES ("NU13_17","005_13_17","NUM","13","17","17","Ba leen Musaa yebalee ngir ñu yëri réewum Kanaan, da ne leen: «Ci Negew gi di diiwaan bi ci bëj-saalum ngeen di jaare, yéegi ca diiwaanu tund ya, ");
INSERT INTO wolmbs_vpl VALUES ("NU13_18","005_13_18","NUM","13","18","18","ba gis nu réew ma mel: ndax waa réew ma, ñu am doole lañu, walla ñu néew doole; ñu néew lañu, walla ñu bare; ");
INSERT INTO wolmbs_vpl VALUES ("NU13_19","005_13_19","NUM","13","19","19","ak ndax réew ma baax na, walla baaxul; ak nu seeni dëkk mel: ndax ay dal rekk la, walla ay dëkk yu ñu dàbbali la; ");
INSERT INTO wolmbs_vpl VALUES ("NU13_20","005_13_20","NUM","13","20","20","ak suuf sa: ndax nangu na, am nanguwul; ak itam ndax am nay garab, am déet. Te ngeen góor-góorlu ba sàkkaale ca meññeefi réew ma.» Fan yooyu nag yemook reseñ di meññ ndoortel meññeef. ");
INSERT INTO wolmbs_vpl VALUES ("NU13_21","005_13_21","NUM","13","21","21","Ci kaw loolu ndaw ya dem yëri réew ma, dale ko ca màndiŋu Ciin, ba àgg Rexob, ga ca wetu Amat. ");
INSERT INTO wolmbs_vpl VALUES ("NU13_22","005_13_22","NUM","13","22","22","Ña nga jaare Negew ca bëj-saalum, dem ba Ebron, fa Anageen ña, Aximan ak Sesay ak Talmay dëkkoon. Ebron googee, tabaxees na ko juróom ñaari at lu jiitu Cowan ga ca Misra. ");
INSERT INTO wolmbs_vpl VALUES ("NU13_23","005_13_23","NUM","13","23","23","Ñu dem ba ca xuru Eskol, daldi fay dagge ab car bu def benn cëggub reseñ, ñaar ca ñoom gàddoo ko bant, ñu sàkkaale fa gërënaat ak figg. ");
INSERT INTO wolmbs_vpl VALUES ("NU13_24","005_13_24","NUM","13","24","24","Béreb boobu lañu dippee xuru Eskol, (muy firi xuru Cëgg) ndax cëgg ba fa bànni Israayil dagge woon. ");
INSERT INTO wolmbs_vpl VALUES ("NU13_25","005_13_25","NUM","13","25","25","Ndaw ya nag ñibbisi, gannaaw ba ñu nemmikoo réew ma lu mat ñeent fukki fan. ");
INSERT INTO wolmbs_vpl VALUES ("NU13_26","005_13_26","NUM","13","26","26","Ñu dikk ba ci Musaa ak Aaróona, ak mbooloom bànni Israayil gépp, ca màndiŋu Paran, ca Kades. Ñu àgge leen xibaar yi, ñoom ak mbooloo ma mépp, ba noppi won leen meññeefum réew ma. ");
INSERT INTO wolmbs_vpl VALUES ("NU13_27","005_13_27","NUM","13","27","27","Ci kaw loolu ñu nettali Musaa, ne: «Dem nanu réew ma nga nu yebaloon, te it foofa la meew maak lem ja tuuroo! Lii ca meññeef maa. ");
INSERT INTO wolmbs_vpl VALUES ("NU13_28","005_13_28","NUM","13","28","28","Xanaa kay, kàttan gu askanu réew ma am, péey ya dàbbaliku te yaa lool. Te it ponkal yooyu cosaanoo ci Anageen ñi lanu fa gis. ");
INSERT INTO wolmbs_vpl VALUES ("NU13_29","005_13_29","NUM","13","29","29","Amalegeen ñaa dëkke bëj-saalumu réew ma, Etteen ñaak Yebuseen ñaak Amoreen ña dëkke diiwaanu tund ya, Kanaaneen ña dëkke wetu géej, feggook dexu Yurdan.» ");
INSERT INTO wolmbs_vpl VALUES ("NU13_30","005_13_30","NUM","13","30","30","Ci kaw loolu Kaleb noppiloo mbooloo ma, fekk leen tàmbalee diiŋat Musaa. Mu ne leen: «Nooy dem ba demaatoo, nanguji réew ma, ndax bir na ne noo leen mana duma.» ");
INSERT INTO wolmbs_vpl VALUES ("NU13_31","005_13_31","NUM","13","31","31","Ndaw ya àndoon ak moom daldi ne: «Manunoo songi waa réew ma, ndax ñoo nu ëpp doole.» ");
INSERT INTO wolmbs_vpl VALUES ("NU13_32","005_13_32","NUM","13","32","32","Ci biir loolu ñuy baatal ca kanam bànni Israayil, réew ma ñu nemmikuji woon. Ñu naan: «Réew moomee ñu wëri woon ngir nemmiku ko déy, réew la muy mëdd ay sancaanam, te mboolem askan wa nu fa gis, ay boroom jëmm lañu. ");
INSERT INTO wolmbs_vpl VALUES ("NU13_33","005_13_33","NUM","13","33","33","Fa lanu gis xeetu Nefilim ya, ponkali Anageen ña bokk ca xeetu Nefilim ya, nuy niru sunu bopp ay soccet fi seen kanam, di leen ko niru, ñoom it.» ");
INSERT INTO wolmbs_vpl VALUES ("NU14_1","005_14_1","NUM","14","1","1","Ba loolu amee mbooloo mépp tàmbalee yuuxu. Askan wa daa fanaanee jooy guddig keroog. ");
INSERT INTO wolmbs_vpl VALUES ("NU14_2","005_14_2","NUM","14","2","2","Bànni Israayil gépp nag di ñaxtu ci kaw Musaa ak Aaróona, mbooloo ma mépp naa leen: «Waay lu nu tee woona dee ca réewum Misra, mbaa sax nu dee ci màndiŋ mii! ");
INSERT INTO wolmbs_vpl VALUES ("NU14_3","005_14_3","NUM","14","3","3","Ana lu nu Aji Sax jiy indee ci réew mii ñu nara reye saamar, sunuy jabar ak sunuy tuut-tànk doon alalu sëxëtooy xare! Tee noo dellu Misra yee?» ");
INSERT INTO wolmbs_vpl VALUES ("NU14_4","005_14_4","NUM","14","4","4","Ci kaw loolu ñu naan ca seen biir: «Nan fal njiit te dellu Misra.» ");
INSERT INTO wolmbs_vpl VALUES ("NU14_5","005_14_5","NUM","14","5","5","Ba loolu amee Musaa ne gurub, moom ak Aaróona, ñu dëpp seen jë fa suuf, fa kanam mbooloom bànni Israayil ma fa daje mépp. ");
INSERT INTO wolmbs_vpl VALUES ("NU14_6","005_14_6","NUM","14","6","6","Yosuwe doomu Nuun, ak Kaleb doomu Yefune, ñoom ña bokk ca ña seeti woon réew ma, daldi xotti seeni yére ndaxu tiis. ");
INSERT INTO wolmbs_vpl VALUES ("NU14_7","005_14_7","NUM","14","7","7","Ñu wax nag mbooloom bànni Israayil mépp, ne leen: «Réew ma nu wëri woon, ba nemmiku ko, réew mu baaxa baax la. ");
INSERT INTO wolmbs_vpl VALUES ("NU14_8","005_14_8","NUM","14","8","8","Bu nu Aji Sax ji nangulee, moo nuy dugal réew moomu, moo nuy jox réew ma meew maak lem ja tuuroo. ");
INSERT INTO wolmbs_vpl VALUES ("NU14_9","005_14_9","NUM","14","9","9","Fexeleen rekk ba Aji Sax ji, buleen ko gàntal, te yeen nag ngeen baña ragal waa réew ma, ndax ab lanc doŋŋ lañu nuy mat. Seen kiiraay dëddu na leen, te Aji Sax jaa ngeek nun. Buleen leen ragal.» ");
INSERT INTO wolmbs_vpl VALUES ("NU14_10","005_14_10","NUM","14","10","10","Ba mu ko defee mbooloo ma mépp ne dañu leen di dóori xeer ba ñu dee. Leeru Aji Sax ji nag feeñ ca xaymab ndaje ma, ci kanam bànni Israayil gépp. ");
INSERT INTO wolmbs_vpl VALUES ("NU14_11","005_14_11","NUM","14","11","11","Ba loolu amee Aji Sax ji ne Musaa: «Ba kañ la ma askan wii nara xarab? Ba kañ lañu may gëmadi, ak firnde yi ma def ci seen biir yépp? ");
INSERT INTO wolmbs_vpl VALUES ("NU14_12","005_14_12","NUM","14","12","12","Maa leen di dumaa mbas, nangu seen cér, ba noppi sose ci yaw askan wu leen ëpp, ëpp leen doole.» ");
INSERT INTO wolmbs_vpl VALUES ("NU14_13","005_14_13","NUM","14","13","13","Musaa ne Aji Sax ji: «Kon de, waa Misra ga nga jële mbooloo mii, génnee leen sa doole ca seen biir, dinañu ko dégg, ");
INSERT INTO wolmbs_vpl VALUES ("NU14_14","005_14_14","NUM","14","14","14","te dinañu ko nettali waa réew mii. Waa réew mii dégg nañu ne yaw Aji Sax ji ci sa bopp yaa nekk ci digg mbooloo mii ngay feeñu bët ak bët, yaw Aji Sax ji, saw niir taxaw, tiim leen, te aw taxaaru niir nga leen di jiitoo bëccëg, jiitoo leen aw taxaaru sawara, guddi. ");
INSERT INTO wolmbs_vpl VALUES ("NU14_15","005_14_15","NUM","14","15","15","Nga nara boole mbooloo mii mépp, bóom benn yoon? Kon de xeet yi dégg sa jaloore dinañu wax ne: ");
INSERT INTO wolmbs_vpl VALUES ("NU14_16","005_14_16","NUM","14","16","16","“Ñàkka mana yóbbu mbooloo mii ca réew ma mu leen giñaloon, moo waral Aji Sax ji rey leen ci màndiŋ mi!” ");
INSERT INTO wolmbs_vpl VALUES ("NU14_17","005_14_17","NUM","14","17","17","Kon nag ngalla Boroom bi, na sa doole màgg rekk, noonee nga noon: ");
INSERT INTO wolmbs_vpl VALUES ("NU14_18","005_14_18","NUM","14","18","18","“Aji Sax ji! Kiy muñ mer, te bare ngor, di baale tooñ aki moy te du ñàkka topp mukk doom, tooñu waajuram, ba ca sët yaak sëtaat ya.” ");
INSERT INTO wolmbs_vpl VALUES ("NU14_19","005_14_19","NUM","14","19","19","Ngalla jéggalal mbooloo mii seenug tooñ ci sag bare ngor, noonee nga leen masa baale, ca Misra ba tey jii.» ");
INSERT INTO wolmbs_vpl VALUES ("NU14_20","005_14_20","NUM","14","20","20","Ba loolu amee Aji Sax ji ne: «Jéggal naa leen noonu nga ko waxe. ");
INSERT INTO wolmbs_vpl VALUES ("NU14_21","005_14_21","NUM","14","21","21","Waaye ndegam maay Kiy dund, te leeru Aji Sax ji mooy fees àddina sépp, ");
INSERT INTO wolmbs_vpl VALUES ("NU14_22","005_14_22","NUM","14","22","22","gannaaw mboolem nit ñi gis samag leer, gis firnde yi ma def ci digg Misra ak ci màndiŋ mi, ñoo ma seetlu woon nii fukki yoon, bañ maa déggal, ");
INSERT INTO wolmbs_vpl VALUES ("NU14_23","005_14_23","NUM","14","23","23","kenn ci ñoom déy du gis réew mi ma giñaloon seeni maam. Mboolem ñi ma xarab, kenn du ko ci gis. ");
INSERT INTO wolmbs_vpl VALUES ("NU14_24","005_14_24","NUM","14","24","24","Sama jaam Kaleb nag, gannaaw meneen xel lay wéye, te moo topp sama gannaaw, ba mu mat sëkk, maa koy yóbbu ba ca réew ma mu demoon, te aw askanam a koy moom. ");
INSERT INTO wolmbs_vpl VALUES ("NU14_25","005_14_25","NUM","14","25","25","Gannaaw Amalegeen ñaak Kanaaneen ña dëkke xur wi nag, bu ëllëgee walbatikuleen, toppaat màndiŋ mi, te jaareji ko géeju Barax ya.» ");
INSERT INTO wolmbs_vpl VALUES ("NU14_26","005_14_26","NUM","14","26","26","Aji Sax ji waxati Musaak Aaróona, ne: ");
INSERT INTO wolmbs_vpl VALUES ("NU14_27","005_14_27","NUM","14","27","27","«Ba kañ la mbooloo mu bon mii di ñaxtu ci sama kaw? Ñaxtu yi bànni Israayil di ñaxtu ci sama kaw, dégg naa ci. ");
INSERT INTO wolmbs_vpl VALUES ("NU14_28","005_14_28","NUM","14","28","28","Ne leen: Ndegam maay Kiy dund déy, kàddug Aji Sax jee, noonu ngeen waxe, may dégg, ni laa leen di def. ");
INSERT INTO wolmbs_vpl VALUES ("NU14_29","005_14_29","NUM","14","29","29","Ci màndiŋ mii kay la seeni néew di tëdd. Mboolem ñi ñu leen limal, mboolem ñi ñu leen waññal, ñu dale ci ñaar fukki at, jëm kaw te doon ñaxtu ci sama kaw, ");
INSERT INTO wolmbs_vpl VALUES ("NU14_30","005_14_30","NUM","14","30","30","kenn ku moy Kaleb doomu Yefune ak Yosuwe doomu Nuun, du kenn ku ciy dugg ca réew ma ma leen giñoona dëël. ");
INSERT INTO wolmbs_vpl VALUES ("NU14_31","005_14_31","NUM","14","31","31","Seen tuut-tànk yi ngeen ne alalu sëxëtooy xare lañuy doon, ñoom laay yóbbu, ba ñu xam réew ma ngeen xarab. ");
INSERT INTO wolmbs_vpl VALUES ("NU14_32","005_14_32","NUM","14","32","32","Waaye yeen, seeni néew ci màndiŋ mii lay tëdd, ");
INSERT INTO wolmbs_vpl VALUES ("NU14_33","005_14_33","NUM","14","33","33","seeni doom di màngaan ñeent fukki at ci màndiŋ mi, gàddoo ko seen ñàkk worma, yeen ñi leen jur, ba keroog seeni néew tëdd ba jeex ci màndiŋ mi. ");
INSERT INTO wolmbs_vpl VALUES ("NU14_34","005_14_34","NUM","14","34","34","Limu fan yi ngeen nemmikuji woon réew ma, ñeent fukki fan, benn fan bu ci nekk day wecci menn at, ngeen gàddoo ko seen mbugali bàkkaar, ñeent fukki at, ba ngeen xam li jànkoonteek man di jur. ");
INSERT INTO wolmbs_vpl VALUES ("NU14_35","005_14_35","NUM","14","35","35","Man Aji Sax ji, maa ko wax. Noonu déy laay def mboolem mbooloo mu bon mii booloo ci sama kaw. Ci màndiŋ mii lañuy raafe, fii lañuy deewe.» ");
INSERT INTO wolmbs_vpl VALUES ("NU14_36","005_14_36","NUM","14","36","36","Ndaw ya Musaa yebaloon, ñu nemmikuji réew ma nag, te ñu délsi, di baatal réew ma, ba tax mbooloo mépp di ñaxtu ci kawam, ");
INSERT INTO wolmbs_vpl VALUES ("NU14_37","005_14_37","NUM","14","37","37","ñooña doon baatal réew ma, am mbas a leen rey fi kanam Aji Sax ji. ");
INSERT INTO wolmbs_vpl VALUES ("NU14_38","005_14_38","NUM","14","38","38","Mennum Yosuwe doomu Nuun ak mennum Kaleb doomu Yefune doŋŋ, ñoo mucc ca ndaw yooya nemmikuji woon réew ma. ");
INSERT INTO wolmbs_vpl VALUES ("NU14_39","005_14_39","NUM","14","39","39","Ba Musaa jottalee bànni Israayil gépp kàddu yooyu, mbooloo ma mititlu nañu ko lool. ");
INSERT INTO wolmbs_vpl VALUES ("NU14_40","005_14_40","NUM","14","40","40","Ca ëllëg sa ñu teela xëy, yéegi kaw tund ya, te naan: «Nu ngi nii di yéeg, jëm fa nu Aji Sax ji wax, ndax noo tooñ.» ");
INSERT INTO wolmbs_vpl VALUES ("NU14_41","005_14_41","NUM","14","41","41","Musaa ne leen: «Lii nag? Yeena ngi tebbi waxi Aji Sax ji, waaye loolu de du sotti! ");
INSERT INTO wolmbs_vpl VALUES ("NU14_42","005_14_42","NUM","14","42","42","Buleen dem, te Aji Sax ji àndul ak yeen. Lu ko moy dingeen daanu ci seen kanami noon. ");
INSERT INTO wolmbs_vpl VALUES ("NU14_43","005_14_43","NUM","14","43","43","Te kat Amalegeen ñi ak Kanaaneen ñaa ngi fuu ci seen kanam. Yeen rekk yeenay daanoo saamar. Gannaaw yeena dëddu Aji Sax ji nag, Aji Sax ji du ànd ak yeen.» ");
INSERT INTO wolmbs_vpl VALUES ("NU14_44","005_14_44","NUM","14","44","44","Teewul ñu të ticc, ne dañuy yéegi kaw tund ya, te gaalu kóllërey Aji Sax ji ak Musaa génnuñu dal ba. ");
INSERT INTO wolmbs_vpl VALUES ("NU14_45","005_14_45","NUM","14","45","45","Ba mu ko defee Amalegeen ña ak Kanaaneen ña dëkke woon diiwaanu tund woowa wàccsi, duma leen, tasaare leen ba ca gox ba ñuy wax Xorma. ");
INSERT INTO wolmbs_vpl VALUES ("NU15_1","005_15_1","NUM","15","1","1","Aji Sax ji waxati Musaa, ne: ");
INSERT INTO wolmbs_vpl VALUES ("NU15_2","005_15_2","NUM","15","2","2","«Waxal bànni Israayil ne leen: Bu ngeen demee ca réew ma ngeen di sanci, réew ma ma leen jox, ");
INSERT INTO wolmbs_vpl VALUES ("NU15_3","005_15_3","NUM","15","3","3","bu ngeen di defal Aji Sax ji saraxu sawara, muy saraxu rendi-dóomal, mbaa sarax su nit di wàccoo aw xas, mbaa saraxu yéene, mbaa seen saraxi màggal, ngir xeeñal xetug jàmm ñeel Aji Sax ji, te muy lu jóge ci jur gu gudd mbaa gu gàtt, defe leen ko nii: ");
INSERT INTO wolmbs_vpl VALUES ("NU15_4","005_15_4","NUM","15","4","4","«Kiy sarxal Aji Sax ji ab saraxam, na sarxewaale saraxu pepp bu benn fukkeelu efab sunguf su mucc ayib, di ñetti kilo, su ñu xiiwe ñeenteelu xaajub xiinu diw, di liitar, ");
INSERT INTO wolmbs_vpl VALUES ("NU15_5","005_15_5","NUM","15","5","5","ak biiñ ngir saraxu tuuru, ñeenteelu xaajub xiin, di liitar, mu ànd ak saraxu rendi-dóomal mbaa beneen sarax, su dee kuuy mu ndaw. ");
INSERT INTO wolmbs_vpl VALUES ("NU15_6","005_15_6","NUM","15","6","6","«Su dee am kuuy mu mag, saraxu pepp bi muy àndal, ñaari fukkeeli efay sunguf su mucc ayib lay doon, di juróom benni kilo, ñu xiiwe ko ñetteelu xaajub xiinu diw, di liitaru diw ak genn-wàll, ");
INSERT INTO wolmbs_vpl VALUES ("NU15_7","005_15_7","NUM","15","7","7","ak biiñ ngir saraxu tuuru, ñetteelu xaajub xiin, di liitar ak genn-wàll. Na joxe loolu, def ko xetug jàmm, ñeel Aji Sax ji. ");
INSERT INTO wolmbs_vpl VALUES ("NU15_8","005_15_8","NUM","15","8","8","«Su dee sarxe jur gu gudd, muy saraxu rendi-dóomal, mbaa sarax bu muy wàccoo aw xas, mbaa saraxu cant ci biir jàmm, ñeel Aji Sax ji, ");
INSERT INTO wolmbs_vpl VALUES ("NU15_9","005_15_9","NUM","15","9","9","na sarxewaaleek jur gu gudd gi, ab saraxu pepp bu ñetti fukkeeli efay sunguf su mucc ayib, di juróom ñeenti kilo, ñu xiiwe ko genn-wàllu xiinu diw, di ñaari liitar, ");
INSERT INTO wolmbs_vpl VALUES ("NU15_10","005_15_10","NUM","15","10","10","ak biiñ bu muy joxewaale, ngir saraxu tuuru, di genn-wàllu xiin, muy ñaari liitar. Loolu saraxu sawara la, di xetug jàmm, ñeel Aji Sax ji. ");
INSERT INTO wolmbs_vpl VALUES ("NU15_11","005_15_11","NUM","15","11","11","«Noonu lees di def bu dee saraxu yëkk, mbaa am kuuy mu mag, mbaa am kuuy mu ndaw, mbaa bëy. ");
INSERT INTO wolmbs_vpl VALUES ("NU15_12","005_15_12","NUM","15","12","12","Nu limu juri sarax yi tollu rekk, ngeen def mu ci nekk noonu, ànd ak lim ba. ");
INSERT INTO wolmbs_vpl VALUES ("NU15_13","005_15_13","NUM","15","13","13","Mboolem njuddu-ji-réew, noonu lay defe sarax yooyii, buy indi saraxu sawara ngir xetug jàmm, ñeel Aji Sax ji. ");
INSERT INTO wolmbs_vpl VALUES ("NU15_14","005_15_14","NUM","15","14","14","«Su dee ab doxandéem bu dal ak yeen, mbaa ku nekk ak yeen ci seen maas yiy ñëw, te muy joxe saraxu sawara ngir xetug jàmm, ñeel Aji Sax ji, ni ngeen koy defe rekk la koy defe. ");
INSERT INTO wolmbs_vpl VALUES ("NU15_15","005_15_15","NUM","15","15","15","Mbooloo mi mépp, dogalu yoon boobu benn la ciy doon, muy yeen, di doxandéem bi. Dogal la buy sax fàww, ñeel seen maasoo maas, te di benn ci yeen ak ci doxandéem bi, fi kanam Aji Sax ji. ");
INSERT INTO wolmbs_vpl VALUES ("NU15_16","005_15_16","NUM","15","16","16","Wenn yoon wee, di benn àtte bi, ñeel leen, ñeel doxandéem bi dal ak yeen.» ");
INSERT INTO wolmbs_vpl VALUES ("NU15_17","005_15_17","NUM","15","17","17","Aji Sax ji waxati Musaa, ne: ");
INSERT INTO wolmbs_vpl VALUES ("NU15_18","005_15_18","NUM","15","18","18","«Waxal bànni Israayil, ne leen, bu ngeen demee ca réew ma ma leen jëme, ");
INSERT INTO wolmbs_vpl VALUES ("NU15_19","005_15_19","NUM","15","19","19","bay lekk ca ñamu réew ma, nangeen ci génne asaka, ñeel Aji Sax ji; ");
INSERT INTO wolmbs_vpl VALUES ("NU15_20","005_15_20","NUM","15","20","20","seen nootu sunguf bu njëkk, ci ngeen di sàkke menn mburu mu ñuy jébbal Aji Sax ji. Ni ngeen di génne asakay njébbal bu jóge ca dàgga ja rekk, ni ngeen koy sàkke. ");
INSERT INTO wolmbs_vpl VALUES ("NU15_21","005_15_21","NUM","15","21","21","Seen nootu sunguf bu njëkk, ci ngeen di génne asakay njébbal, ñeel Aji Sax ji, yeen ak seen askan.» ");
INSERT INTO wolmbs_vpl VALUES ("NU15_22","005_15_22","NUM","15","22","22","Su dul ci teyeef ngeen ñàkka jëfe lenn ci mboolem santaane yii Aji Sax ji dénk Musaa, ");
INSERT INTO wolmbs_vpl VALUES ("NU15_23","005_15_23","NUM","15","23","23","ci mboolem lu leen Aji Sax ji sant, Musaa jottali, dale ko keroog ba Aji Sax ji santaanee loola, ak gannaaw gi, ba ca seen maasoo maas, ");
INSERT INTO wolmbs_vpl VALUES ("NU15_24","005_15_24","NUM","15","24","24","su dee moy gu dul teyeef, te mbooloo mi yégu ko woon, su boobaa mbooloo mépp ay sarxal aw yëkk wu ndaw wuy doon rendi-dóomal, ngir xetug jàmm, ñeel Aji Sax ji, ak saraxu pepp, ak saraxu tuuru yi mu àndal, ni ko yoon àttee, ak benn sikket ngir saraxu póotum bàkkaar. ");
INSERT INTO wolmbs_vpl VALUES ("NU15_25","005_15_25","NUM","15","25","25","Sarxalkat bi day def loolu njotlaayal mbooloom bànni Israayil gépp, njéggal daldi leen ñeel, gannaaw moy ga dug teyeef, te ñoom it indi nañu seen saraxu sawara, ñeel Aji Sax ji, booleek seen saraxu póotum bàkkaar fi kanam Aji Sax ji, ndax seen moy ga dul teyeef. ");
INSERT INTO wolmbs_vpl VALUES ("NU15_26","005_15_26","NUM","15","26","26","Njéggal day daldi ñeel mbooloom bànni Israayil gépp, ak bépp doxandéem bu dal ak ñoom, ndax mbooloo mépp lay seen moy gu dul teyeef. ");
INSERT INTO wolmbs_vpl VALUES ("NU15_27","005_15_27","NUM","15","27","27","Su dee kenn nit a bàkkaar te du teyeefam, na sarxal aw bëy wu jigéen wu menn at, ngir saraxu póotum bàkkaar. ");
INSERT INTO wolmbs_vpl VALUES ("NU15_28","005_15_28","NUM","15","28","28","Sarxalkat bi daldi koy def fi kanam Aji Sax ji, njotlaayal ki moy ci ag ñàkka tey, ca bàkkaaram ba dul teyeef. Loolu la koy jote, njéggal ñeel ko. ");
INSERT INTO wolmbs_vpl VALUES ("NU15_29","005_15_29","NUM","15","29","29","Muy njuddu-ji-réew ju bokk ci bànni Israayil, di doxandéem bu dal ak ñoom, yoon wi wenn lay doon, ñeel ki moy te du teyeefam. ");
INSERT INTO wolmbs_vpl VALUES ("NU15_30","005_15_30","NUM","15","30","30","Nit ki tooñ cig teyeefam nag, muy njuddu-ji-réew, di doxandéem, kooku Aji Sax ji la ñàkke kersa. Nit kooku, dees koy dagge ci biiri bokkam. ");
INSERT INTO wolmbs_vpl VALUES ("NU15_31","005_15_31","NUM","15","31","31","Gannaaw kàddug Aji Sax ji la teddadil te ndigalam la xëtt, nit kooku dees koy dagge rekk, mu gàddu bàkkaaram. ");
INSERT INTO wolmbs_vpl VALUES ("NU15_32","005_15_32","NUM","15","32","32","Ba bànni Israayil nekkee ca màndiŋ ma, dañoo fekk jenn waay, muy taxan bésub Noflaay. ");
INSERT INTO wolmbs_vpl VALUES ("NU15_33","005_15_33","NUM","15","33","33","Ña ko fekk muy taxan, yóbbu ko ba ca Musaa ak Aaróona, ak mbooloo ma mépp. ");
INSERT INTO wolmbs_vpl VALUES ("NU15_34","005_15_34","NUM","15","34","34","Ba loolu amee ñu teg ko ciy loxo, ndax dogaleesagul woon nees di def ak moom. ");
INSERT INTO wolmbs_vpl VALUES ("NU15_35","005_15_35","NUM","15","35","35","Ci kaw loolu Aji Sax ji ne Musaa: «Dee rekk mooy àtteb waa ji. Dees koy génne dal bi, mbooloo mépp dóor koy xeer, ba mu dee.» ");
INSERT INTO wolmbs_vpl VALUES ("NU15_36","005_15_36","NUM","15","36","36","Mbooloo ma mépp daldi koy génne dal bi, dóor koy xeer ba mu dee, na ko Aji Sax ji sante Musaa. ");
INSERT INTO wolmbs_vpl VALUES ("NU15_37","005_15_37","NUM","15","37","37","Aji Sax ji waxati Musaa, ne ko: ");
INSERT INTO wolmbs_vpl VALUES ("NU15_38","005_15_38","NUM","15","38","38","«Waxal bànni Israayil, ne leen, ci seen maasoo maas, nañu def ay langat ci seen cati mbubb, langat wu ci nekk ñu nas ci buum gu baxa. ");
INSERT INTO wolmbs_vpl VALUES ("NU15_39","005_15_39","NUM","15","39","39","Mu doon seen langat yu ngeen di xool, di ko fàttalikoo mboolem santaaney Aji Sax ji, ngir di ko jëfe, te baña topp seen bànneexu bakkan ak seeni gët, bay moy. ");
INSERT INTO wolmbs_vpl VALUES ("NU15_40","005_15_40","NUM","15","40","40","Su ko defee ngeen di bàyyi xel tey jëfe sama santaane yépp, daldi doon ñu sell, ñeel seen Yàlla. ");
INSERT INTO wolmbs_vpl VALUES ("NU15_41","005_15_41","NUM","15","41","41","Man maay Aji Sax ji, seen Yàlla ji leen génnee réewum Misra ngir doon seen Yàlla. Maay seen Yàlla Aji Sax ji.» ");
INSERT INTO wolmbs_vpl VALUES ("NU16_1","005_16_1","NUM","16","1","1","Ku ñuy wax Kore doomu Iccar, mi askanoo ci Keyat doomu Lewi, moo àndoon ak ay Rubeneen, ñuy Datan ak Abiram, doomi Elyab, ak Oon doomu Pelet, ");
INSERT INTO wolmbs_vpl VALUES ("NU16_2","005_16_2","NUM","16","2","2","ñu jógal Musaa, ñook ñaari téeméer ak juróom fukk (250) ci bànni Israayil, diy kilifa ci mbooloo mi, am baat ca pénc ma, te di ñu am aw tur. ");
INSERT INTO wolmbs_vpl VALUES ("NU16_3","005_16_3","NUM","16","3","3","Ci kaw loolu ñu bokk daje fi kaw Musaa ak Aaróona, ne leen: «Doy na sëkk! Mbooloo mi ba mu daj, ñépp a sell, te ci sunu biir la Aji Sax ji nekk. Ana lu ngeen di xoggaliku ci kaw mbooloom Aji Sax ji?» ");
INSERT INTO wolmbs_vpl VALUES ("NU16_4","005_16_4","NUM","16","4","4","Ba Musaa déggee loolu, da ne gurub, dëpp jë bi fi suuf. ");
INSERT INTO wolmbs_vpl VALUES ("NU16_5","005_16_5","NUM","16","5","5","Mu wax Kore ak gàngooram gépp, ne: «Bu ëllëgee, Aji Sax ji mooy xamle kan la séddoo ak kan mooy ki sell, mu jegeñal ko boppam. Ki mu tànn nag, dina ko jegeñal boppam. ");
INSERT INTO wolmbs_vpl VALUES ("NU16_6","005_16_6","NUM","16","6","6","Dangeen di def nii: Jëlleeni and, yaw Kore, yaak sa gàngoor gépp, ");
INSERT INTO wolmbs_vpl VALUES ("NU16_7","005_16_7","NUM","16","7","7","te ngeen def ciy xal, def ci cuuraay fi kanam Aji Sax ji, ëllëg. Su ko defee ku Aji Sax ji tànn, kookooy ki sell. Doy na sëkk, yeen Leween ñi!» ");
INSERT INTO wolmbs_vpl VALUES ("NU16_8","005_16_8","NUM","16","8","8","Musaa teg ca ne Kore: «Yeen Leween ñi, dégluleen nag! ");
INSERT INTO wolmbs_vpl VALUES ("NU16_9","005_16_9","NUM","16","9","9","Xeeb ngeen daal ber gi leen Yàllay Israayil ber ci mbooloom Israayil, jegeñal leen boppam, ngeen di liggéey liggéeyu màkkaanu Aji Sax ji, di taxaw fi kanam mbooloo mi, di leen jaamul Yàlla? ");
INSERT INTO wolmbs_vpl VALUES ("NU16_10","005_16_10","NUM","16","10","10","Yaw mu jegeñal la, yaak sa bokki Leween ñépp, ngeen di xëccu céru carxal, boole ci! ");
INSERT INTO wolmbs_vpl VALUES ("NU16_11","005_16_11","NUM","16","11","11","Kon kay yaw yaak sa gàngoor gépp, ci kaw Aji Sax ji ngeen bokk daje! Ana kuy Aaróona, ba ngeen di ñaxtu ci kawam?» ");
INSERT INTO wolmbs_vpl VALUES ("NU16_12","005_16_12","NUM","16","12","12","Musaa nag woolu Datan ak Abiram, doomi Elyab, ñu ne ko: «Danoo ñëwul! ");
INSERT INTO wolmbs_vpl VALUES ("NU16_13","005_16_13","NUM","16","13","13","Dangaa xeeb li nga nu jële réew mu meew maak lem ja tuuroo, ngir reylu nu ci màndiŋ mi, ba tax ngay buur-buurlu ci sunu kaw teg ci? ");
INSERT INTO wolmbs_vpl VALUES ("NU16_14","005_16_14","NUM","16","14","14","Du réew mu meew maak lem ja tuuroo nga nu yóbbu de, te séddoo nu céri tool mbaa tóokëri reseñ. Mbooloo mii mépp, man nga leena tuur lëndëm? Danoo ñëwul!» ");
INSERT INTO wolmbs_vpl VALUES ("NU16_15","005_16_15","NUM","16","15","15","Ba loolu amee Musaa mer lool. Mu ne Aji Sax ji: «Bul geesu sax seen sarax. Menn mbaam sax, masuma leen koo jëlal te masuma cee tooñ kenn.» ");
INSERT INTO wolmbs_vpl VALUES ("NU16_16","005_16_16","NUM","16","16","16","Musaa nag ne Kore: «Yaw, yaak sa gàngoor gépp, ñëwleen ca kanam Aji Sax ji, yaak ñoom ak Aaróona, ëllëg. ");
INSERT INTO wolmbs_vpl VALUES ("NU16_17","005_16_17","NUM","16","17","17","Na ku nekk jël andam, def ci cuuraay, te na ku ci nekk indi andam fi kanam Aji Sax ji, muy ñaari téeméeri and ak juróom fukk, yaak Aaróona it, ku nekk ak andam.» ");
INSERT INTO wolmbs_vpl VALUES ("NU16_18","005_16_18","NUM","16","18","18","Ba mu ko defee ku nekk jëlub andam, def cay xal, teg ca cuuraay. Ñu taxaw ca bunt xaymab ndaje ma, ñook Musaa ak Aaróona. ");
INSERT INTO wolmbs_vpl VALUES ("NU16_19","005_16_19","NUM","16","19","19","Kore nag dajale gàngoor gépp fa ñoom, ca bunt xaymab ndaje ma. Ci kaw loolu leeru Aji Sax ji feeñu mbooloo ma mépp! ");
INSERT INTO wolmbs_vpl VALUES ("NU16_20","005_16_20","NUM","16","20","20","Aji Sax ji wax Musaa ak Aaróona, ne: ");
INSERT INTO wolmbs_vpl VALUES ("NU16_21","005_16_21","NUM","16","21","21","«Xiddileen mbooloo mii, ma xoyom leen léegi!» ");
INSERT INTO wolmbs_vpl VALUES ("NU16_22","005_16_22","NUM","16","22","22","Musaa ak Aaróona ne gurub, dëpp seen jë fa suuf, daldi ne: «Éy Yàlla, yaw Yàllay bépp boroom bakkan bu bindoo aw suux, xanaa du kenn ay bàkkaar, nga far sànju ci kaw mbooloom lëmm?» ");
INSERT INTO wolmbs_vpl VALUES ("NU16_23","005_16_23","NUM","16","23","23","Ci kaw loolu Aji Sax ji ne Musaa: ");
INSERT INTO wolmbs_vpl VALUES ("NU16_24","005_16_24","NUM","16","24","24","«Waxal mbooloo mi, ne leen ñu jóge fi wër màkkaani Kore ak Datan ak Abiram.» ");
INSERT INTO wolmbs_vpl VALUES ("NU16_25","005_16_25","NUM","16","25","25","Musaa daldi jubal ca Datan ak Abiram, magi Israayil topp ca. ");
INSERT INTO wolmbs_vpl VALUES ("NU16_26","005_16_26","NUM","16","26","26","Ci biir loolu mu wax ak mbooloo ma, ne leen: «Ngalla dàndleen xaymay nit ñu bon ñii, te buleen laal seen lenn, bala ngeen di buuboondook mboolem bàkkaari ñii.» ");
INSERT INTO wolmbs_vpl VALUES ("NU16_27","005_16_27","NUM","16","27","27","Ñu daldi jóge mboolem fa wër màkkaani Kore ak Datan ak Abiram. Datan ak Abiram ñoom, ña nga génn, taxaw ca seen bunti xayma, ñook seeni jabar ak seeni doom, ak seeni tuut-tànk. ");
INSERT INTO wolmbs_vpl VALUES ("NU16_28","005_16_28","NUM","16","28","28","Musaa nag ne: «Lii nag moo leen di xamal ne Aji Sax ji moo ma yebal ngir ma def jëf jii jépp, waaye du sama coobarey bopp: ");
INSERT INTO wolmbs_vpl VALUES ("NU16_29","005_16_29","NUM","16","29","29","Ndegam ni mboolem doom aadama di deewe, ni la ñii deewe, seen demin di deminu mboolem doom aadama, su boobaa du Aji Sax jee ma yebal. ");
INSERT INTO wolmbs_vpl VALUES ("NU16_30","005_16_30","NUM","16","30","30","Waaye ndegam Aji Sax ji moo sàkk ba sàkk tey lu masula am, ba suuf ŋa, mëdd leen, ñook lu bokk ci ñoom, ñu tàbbiwaale bakkan biir njaniiw, su boobaa dingeen xam ne ñoom ñii ñoo xarab Aji Sax ji.» ");
INSERT INTO wolmbs_vpl VALUES ("NU16_31","005_16_31","NUM","16","31","31","Naka la Musaa di daaneel kàddu yooyu yépp, fa ñu taxaw jekki xar, ");
INSERT INTO wolmbs_vpl VALUES ("NU16_32","005_16_32","NUM","16","32","32","suuf ŋa, mëdd leen, ñook seen waa kër, ak mboolem ku bokk ci Kore, ak mboolem alal ja. ");
INSERT INTO wolmbs_vpl VALUES ("NU16_33","005_16_33","NUM","16","33","33","Ñu daldi tàbbiwaale bakkan biir njaniiw, ñook mboolem lu ñu moom, suuf sàng leen, ñu réer mbooloo ma mërr. ");
INSERT INTO wolmbs_vpl VALUES ("NU16_34","005_16_34","NUM","16","34","34","Mboolem Israayil dégg seen yuux ya, daldi daw, te naan: «Nan daw bala noo suuf a mëdd!» ");
INSERT INTO wolmbs_vpl VALUES ("NU16_35","005_16_35","NUM","16","35","35","Ci kaw loolu sawara moo bawoo fa Aji Sax ji, xoyom ñaari téeméeri nit ak juróom fukk ña indi woon saraxu cuuraay ba. ");
INSERT INTO wolmbs_vpl VALUES ("NU17_1","005_17_1","NUM","17","1","1","Aji Sax ji waxati Musaa, ne: ");
INSERT INTO wolmbs_vpl VALUES ("NU17_2","005_17_2","NUM","17","2","2","«Waxal Elasar doomu Aaróona, sarxalkat bi, ne ko mu seppee and yi ci lakk gi, ndax lu sell la, te xal yi, na ko tuur fu sore. ");
INSERT INTO wolmbs_vpl VALUES ("NU17_3","005_17_3","NUM","17","3","3","And yooyii seeni boroom feye seen bakkan seeni bàkkaar, dees koy tëgg, ba mu tàlli, xoobe ko sarxalukaay bi. Gannaaw fi kanam Aji Sax ji lañu indi and yi, ba tax mu doon lu sell, na and yi doon firnde, ñeel bànni Israayil.» ");
INSERT INTO wolmbs_vpl VALUES ("NU17_4","005_17_4","NUM","17","4","4","Ci kaw loolu Elasar sarxalkat bi jël andi xànjar, ya ña dee ca lakk ga indi woon, ñu tëgg ko ba mu tàlli, ngir sarxalukaay ba, ");
INSERT INTO wolmbs_vpl VALUES ("NU17_5","005_17_5","NUM","17","5","5","na ko Aji Sax ji santaanee woon, Musaa jottali. Loolu di fàttali bànni Israayil ne benn jàmbur bu bokkul ci askanu Aaróona sañula dikk di taal cuuraay fi kanam Aji Sax ji, lu ko moy lu mel ni li dal Kore ak gàngooram moo koy dal. ");
INSERT INTO wolmbs_vpl VALUES ("NU17_6","005_17_6","NUM","17","6","6","Ca ëllëg sa mbooloom bànni Israayil gépp a doon ñaxtu ci kaw Musaa ak Aaróona, naan: «Yeen yeena reylu ñoñi Aji Sax ji!» ");
INSERT INTO wolmbs_vpl VALUES ("NU17_7","005_17_7","NUM","17","7","7","Mbooloo maa nga sam Aaróona ak Musaa. Ci biir loolu, ñu ne gees xaymab ndaje ma‎, gisuñu lu moy niir wa muur ko, leerug Aji Sax ji feeñ. ");
INSERT INTO wolmbs_vpl VALUES ("NU17_8","005_17_8","NUM","17","8","8","Ba loolu amee Musaa ak Aaróona dem ba ca kanam xaymab ndaje ma, ");
INSERT INTO wolmbs_vpl VALUES ("NU17_9","005_17_9","NUM","17","9","9","Aji Sax ji wax ak Musaa, ne: ");
INSERT INTO wolmbs_vpl VALUES ("NU17_10","005_17_10","NUM","17","10","10","«Jógeleen biir mbooloo mii, ma sànk leen léegi!» Ñu ne gurub, dëpp seen jë fa suuf. ");
INSERT INTO wolmbs_vpl VALUES ("NU17_11","005_17_11","NUM","17","11","11","Musaa ne Aaróona: «Jëlal and bi, nga sàkke ci sarxalukaay bi ay xal, teg ci cuuraay, yóbbu gaaw ca mbooloo ma, ba defal leen ag njotlaay, ndax sànj mi tàkke na ci Aji Sax ji, mbas mi tàmbali na!» ");
INSERT INTO wolmbs_vpl VALUES ("NU17_12","005_17_12","NUM","17","12","12","Aaróona këf and ba Musaa wax, daw dugg ca biir mbooloo ma. Ndeke mbas ma tàmbali na ca biir mbooloo ma. Mu def ca and ba cuuraay, daldi defal mbooloo ma njotlaay. ");
INSERT INTO wolmbs_vpl VALUES ("NU17_13","005_17_13","NUM","17","13","13","Naka la taxaw ci diggante ñi dee ak ñiy dund, mbas ma dal. ");
INSERT INTO wolmbs_vpl VALUES ("NU17_14","005_17_14","NUM","17","14","14","Ña dee ca mbas ma nag doon fukki junneek ñeent ak juróom ñaari téeméer (14 700), te bokkul ak ña dee woon ca mbirum Kore ma. ");
INSERT INTO wolmbs_vpl VALUES ("NU17_15","005_17_15","NUM","17","15","15","Ba mu ko defee Aaróona dellu ca Musaa, ca bunt xaymab ndaje ma, fekk mbas ma dal. ");
INSERT INTO wolmbs_vpl VALUES ("NU17_16","005_17_16","NUM","17","16","16","Ba loolu amee Aji Sax ji ne Musaa: ");
INSERT INTO wolmbs_vpl VALUES ("NU17_17","005_17_17","NUM","17","17","17","«Waxal ak bànni Israayil, nga nangoo ci mboolem seen kilifay kër maam, aw yet, na wenn yet bawoo ci kër gu ci nekk, muy fukki yet ak ñaar, yet wu ci nekk, nga bind ci turu boroom. ");
INSERT INTO wolmbs_vpl VALUES ("NU17_18","005_17_18","NUM","17","18","18","Turu Aaróona itam, nga bind ko ci yetu giirug Lewi, ndax wenn yet lay doon, ñeel kilifag kër gu ci nekk. ");
INSERT INTO wolmbs_vpl VALUES ("NU17_19","005_17_19","NUM","17","19","19","Nga denc yet yi ca biir xaymab ndaje ma, fa kanam gaalu seedes kóllëre ga, fa may dajeek yeen. ");
INSERT INTO wolmbs_vpl VALUES ("NU17_20","005_17_20","NUM","17","20","20","Su ko defee ki ma tànn, aw yetam dina jebbi, ba ma teqalikoo ak xultuy bànni Israayil yi ñuy xultu ci seen kaw.» ");
INSERT INTO wolmbs_vpl VALUES ("NU17_21","005_17_21","NUM","17","21","21","Musaa àgge ko bànni Israayil, mboolem seen kilifay kër maam jox Musaa aw yet, kilifa gu ci nekk wenn yet, ñeel kër maamam, muy fukki yet ak ñaar, yetu Aaróona bokk ca. ");
INSERT INTO wolmbs_vpl VALUES ("NU17_22","005_17_22","NUM","17","22","22","Musaa teg yet ya fa kanam Aji Sax ji, ca biir xaymab seede sa. ");
INSERT INTO wolmbs_vpl VALUES ("NU17_23","005_17_23","NUM","17","23","23","Ca ëllëg sa, naka la Musaa dugg ca xaymab seede sa rekk, daldi fekk yetu Aaróona wu kër Lewi, jebbi; fekk na mu jebbi, ba tóor, ba meññ ay doomi amànd. ");
INSERT INTO wolmbs_vpl VALUES ("NU17_24","005_17_24","NUM","17","24","24","Ba loolu amee Musaa jële yet yépp ci Aji Sax ji, dem ba ca bànni Israayil gépp, ñépp gis, ku nekk jël yetam. ");
INSERT INTO wolmbs_vpl VALUES ("NU17_25","005_17_25","NUM","17","25","25","Aji Sax ji waxati Musaa, ne: «Dellool yetu Aaróona fa kanam gaalu seede sa, mu dence fa, di firnde ñeel xeetu fippukat wi, ndax nga dakkal seeni xultu ci sama kaw, ba duñu dee.» ");
INSERT INTO wolmbs_vpl VALUES ("NU17_26","005_17_26","NUM","17","26","26","Musaa def noonu. Na ko ko Aji Sax ji sante, na la ko defe. ");
INSERT INTO wolmbs_vpl VALUES ("NU17_27","005_17_27","NUM","17","27","27","Bànni Israayil nag naan Musaa: «Jeexal nanu nag, sànku nanu, nun ñépp ay sànku! ");
INSERT INTO wolmbs_vpl VALUES ("NU17_28","005_17_28","NUM","17","28","28","Gannaaw képp ku jege màkkaanu Aji Sax ji doŋŋ, dangay dee kay, mbaa dunu far jeex tàkk?» ");
INSERT INTO wolmbs_vpl VALUES ("NU18_1","005_18_1","NUM","18","1","1","Aji Sax ji ne Aaróona: «Yaw, yaak say doom ak sa waa kër maam, yeenay gàddu peyug tooñ ci wàllu béreb bu sell bi, te itam yaw, yaak say doom, yeenay gàddu peyug tooñ ci seen wàllu carxal. ");
INSERT INTO wolmbs_vpl VALUES ("NU18_2","005_18_2","NUM","18","2","2","Te itam sa bokki Leween ñi, sa giirug baay, jegeñal leen sa bopp, ñu jokku ci yaw, di la jàppale, te yaw yaak say doom, ngeen féete fi kanam xayma ba seedes kóllëre ga dence. ");
INSERT INTO wolmbs_vpl VALUES ("NU18_3","005_18_3","NUM","18","3","3","Ñooy sàmm sa ndénkaane, ak ndénkaaneb mboolem xayma bi, waaye jumtukaayi béreb bu sell bi, ak sarxalukaay bi, buñu ko jege, lu ko moy dañuy dee, ñoom ak yeen itam. ");
INSERT INTO wolmbs_vpl VALUES ("NU18_4","005_18_4","NUM","18","4","4","Nañu jokku ci yaw, te ñu sàmm ndénkaaneb xaymab ndaje mi, ci mboolem liggéeyu xayma bi. Kenn ku ci bokkul nag du leen jege, yeen. ");
INSERT INTO wolmbs_vpl VALUES ("NU18_5","005_18_5","NUM","18","5","5","Nangeen sàmm ndénkaaneb béreb bu sell bi, ak ndénkaaneb sarxalukaay bi, ngir am sànj baña dalati ci kaw bànni Israayil. ");
INSERT INTO wolmbs_vpl VALUES ("NU18_6","005_18_6","NUM","18","6","6","«Man mii nag maa seppee seen bokki Leween ñi ci biir bànni Israayil. Yeen lañu leen jagleel a jagleel, ñeel Aji Sax ji, ngir ñu liggéey liggéeyu xaymab ndaje mi. ");
INSERT INTO wolmbs_vpl VALUES ("NU18_7","005_18_7","NUM","18","7","7","Yaw nag yaak say doom, dénkooleen seenug carxal ci mboolem mbiru sarxalukaay bi, ak ca wàllaa ridob biir bi, ngeen di ca liggéey. Seen liggéeyu carxal bi, ab sasu teraanga la, maa leen ko terale. Waaye ku bokkul ci yeen, bu ci laalee, dees koy rey.» ");
INSERT INTO wolmbs_vpl VALUES ("NU18_8","005_18_8","NUM","18","8","8","Aji Sax ji neeti Aaróona: «Man mii maa la dénk mboolem saraxi njébbal yu sell yi bànni Israayil di indi, yaw laa ko jagleel, nga jagoo, yaak say doom, ci kaw dogal bu sax dàkk. ");
INSERT INTO wolmbs_vpl VALUES ("NU18_9","005_18_9","NUM","18","9","9","Lii nag, yaa ko moom, ci mboolem sarax yu sell yee sell yi mucc sawara: seen bépp sarax, seen bépp saraxu pepp ak seen bépp saraxu póotum bàkkaar, ak seen bépp saraxu peyug tooñ bu ñu ma indil, lu sella sell la, ñeel la, yaak sa doom yu góor. ");
INSERT INTO wolmbs_vpl VALUES ("NU18_10","005_18_10","NUM","18","10","10","Fu sella sell ngeen koy lekke; képp kuy góor ci yeen, sañ na cee lekk. Lu sell lay doon ci yaw. ");
INSERT INTO wolmbs_vpl VALUES ("NU18_11","005_18_11","NUM","18","11","11","«Leneen liy sa cér moo di bépp saraxu njébbal bu jóge ci saraxi nit ñi, di saraxi yékkati-jébbal yu bànni Israayil. Yaw laa ko sédd, yaak sa doom yu góor, ak sa doom yu jigéen, ci kaw dogalu yoon bu sax dàkk. Képp ku set ci sa waa kër, sañ na cee lekk. ");
INSERT INTO wolmbs_vpl VALUES ("NU18_12","005_18_12","NUM","18","12","12","«Lépp luy ngëneelu diw gu bees, ak ngëneelu biiñ bu bees, ak pepp mu njëkka ñor, mu ñu jox Aji Sax ji, yaw laa ko jox. ");
INSERT INTO wolmbs_vpl VALUES ("NU18_13","005_18_13","NUM","18","13","13","Meññeef mu njëkk mi ñuy indil Aji Sax ji, ci mboolem lu meññee ci seen suuf, yaa koy moom, te képp ku set ci sa waa kër, sañ na cee lekk. ");
INSERT INTO wolmbs_vpl VALUES ("NU18_14","005_18_14","NUM","18","14","14","Mboolem lees aaye ngir Aji Sax ji ci Israayil, yaa koy moom. ");
INSERT INTO wolmbs_vpl VALUES ("NU18_15","005_18_15","NUM","18","15","15","Lépp luy ubbiteg njur gu ñu jagleel Aji Sax ji, ci lépp lu bindoo aw suux, nit ak mala, yaa koy moom. Fexeel rekk ba jotlu taawub nit ki, te taawub mala mu setul it, nanga ko jotlu. ");
INSERT INTO wolmbs_vpl VALUES ("NU18_16","005_18_16","NUM","18","16","16","Njotu xale bu am lu dale ci weer, àpp ko ci juróomi siikali xaalis yu béreb bu sell bi, benn siikal yemook ñaar fukki gera mbaa fukki garaam ak benn ak genn-wàll. ");
INSERT INTO wolmbs_vpl VALUES ("NU18_17","005_18_17","NUM","18","17","17","Waaye lu nag taawloo, ak lu xar taawloo, ak lu bëy taawloo, deesu ko jot. Yooyii yu sell la. Deretam ngay xëpp ci sarxalukaay bi, nebbon bi, nga làkk ko, muy saraxu sawara ngir xetug jàmm, ñeel Aji Sax ji. ");
INSERT INTO wolmbs_vpl VALUES ("NU18_18","005_18_18","NUM","18","18","18","Aw yàppam, yaa koy moom, ni nga moome dënnu saraxu yékkati-jébbal, ak tànkub kanam bu ndijoor ba. ");
INSERT INTO wolmbs_vpl VALUES ("NU18_19","005_18_19","NUM","18","19","19","Mboolem li bànni Israayil di jébbal Aji Sax ji, njébbal yu sell yi, sédd naa la ko, yaak sa doom yu góor, ak sa doom yu jigéen, ci kaw dogalu yoon bu sax dàkk. Kóllëreg xorom a ngoogu, du fecciku, xanaa sax dàkk fi kanam Aji Sax ji, ñeel la yaw, yaak saw askan.» ");
INSERT INTO wolmbs_vpl VALUES ("NU18_20","005_18_20","NUM","18","20","20","Aji Sax ji neeti Aaróona: «Seenum réew nag doo ci am cér, te wàllu suuf, doo ko am ci seen biir. Man maay sa wàll, di sab cér ci biir bànni Israayil.» ");
INSERT INTO wolmbs_vpl VALUES ("NU18_21","005_18_21","NUM","18","21","21","Leween ñi ñoom, maa leen jox bépp céru fukkeel bu génne ci Israayil, muy seen cér, ñu yooloo ko seen liggéey bi ñuy liggéey ci xaymab ndaje mi. ");
INSERT INTO wolmbs_vpl VALUES ("NU18_22","005_18_22","NUM","18","22","22","Bu bànni Israayil juuxati ci xaymab ndaje mi, di gàddu bàkkaar bu dee di àtteem. ");
INSERT INTO wolmbs_vpl VALUES ("NU18_23","005_18_23","NUM","18","23","23","Leween ñi ñooy ñiy liggéey liggéeyi xaymab ndaje mi, te lu ñu ca tooñ, ñooy gàddu pey ga, ci kaw dogal bu sax dàkk, ñeel leen, ñook seen askan. Waaye biir bànni Israayil, Leween ñi duñu ci séddu céru suuf, ");
INSERT INTO wolmbs_vpl VALUES ("NU18_24","005_18_24","NUM","18","24","24","ndax céri fukkeel yi bànni Israayil yékkati, jagleel ko Aji Sax ji, jox naa ko Leween ñi, muy seen cér. Moo tax ma ne leen, biir bànni Israayil, duñu ci séddu céru suuf. ");
INSERT INTO wolmbs_vpl VALUES ("NU18_25","005_18_25","NUM","18","25","25","Aji Sax waxati Musaa ne: ");
INSERT INTO wolmbs_vpl VALUES ("NU18_26","005_18_26","NUM","18","26","26","«Leween ñi, wax leen, ne leen bu ñu jëlee ci bànni Israayil seen céri fukkeel yi ma leen jagleel yeen, muy seen cér, nañu ci jébbal Aji Sax ji fukkeelub céru fukkeel yooyu. ");
INSERT INTO wolmbs_vpl VALUES ("NU18_27","005_18_27","NUM","18","27","27","Nañu leen jàppal loolu, yeen Leween ñi, muy seen njébbalu bopp, ni bu doon pepp mu jóge ci seen dàggay bopp, ak biiñ bu bees bu jóge ci seen nalukaay. ");
INSERT INTO wolmbs_vpl VALUES ("NU18_28","005_18_28","NUM","18","28","28","Su ko defee ngeen génne yeen itam, li ngeen di jébbal Aji Sax ji, ci mboolem seen céri fukkeel yi ngeen jële ci bànni Israayil. Kon nangeen jële coocu, jébbalub Aji Sax ji, jox ko Aaróona sarxalkat bi. ");
INSERT INTO wolmbs_vpl VALUES ("NU18_29","005_18_29","NUM","18","29","29","Lépp lu ñu leen sédd, nangeen ci génne céru Aji Sax ji. Mboolem céri ngëneel yooyu, ci ngeen di génne cér bu sell boobu. ");
INSERT INTO wolmbs_vpl VALUES ("NU18_30","005_18_30","NUM","18","30","30","«Waxal Leween ñi ne leen gannaaw bu ñu ca sàkkee céru ngëneel li, li ci des lew na leen, ni bu doon pepp mu jóge ci seen dàggay bopp, ak biiñ bu jóge ci seen nalukaay. ");
INSERT INTO wolmbs_vpl VALUES ("NU18_31","005_18_31","NUM","18","31","31","Sañ nañu koo lekke fépp, ñoom ak seen waa kër, ndax loolu seen pey la, ñu yooloo ko seen liggéeyu xaymab ndaje mi. ");
INSERT INTO wolmbs_vpl VALUES ("NU18_32","005_18_32","NUM","18","32","32","Duñu ci gàddu benn bàkkaar, gannaaw bu ñu ci jébbalee céru ngëneel li. Waaye njébbal yu sell yu bànni Israayil yooyu, buñu ci teddadil lenn, ba di ci dee.» ");
INSERT INTO wolmbs_vpl VALUES ("NU19_1","005_19_1","NUM","19","1","1","Aji Sax ji waxati Musaa ak Aaróona, ne: ");
INSERT INTO wolmbs_vpl VALUES ("NU19_2","005_19_2","NUM","19","2","2","«Lii mooy dogalu yoon bi Aji Sax ji santaane: Neleen bànni Israayil ñu indil leen nag wu jigéen wu xonq, wu mat, mucc sikk, te kenn masu koo takk, ");
INSERT INTO wolmbs_vpl VALUES ("NU19_3","005_19_3","NUM","19","3","3","ngeen jox ko Elasar sarxalkat bi, ñu génne ko dal bi, te ñu rendi ko fi kanamam. ");
INSERT INTO wolmbs_vpl VALUES ("NU19_4","005_19_4","NUM","19","4","4","Na Elasar sarxalkat bi capp baaraamam ci deret ji, wis-wisal ko juróom ñaari yoon fi féeteek bunt xaymab ndaje mi. ");
INSERT INTO wolmbs_vpl VALUES ("NU19_5","005_19_5","NUM","19","5","5","Nañu lakk nag wi‎ ci kanamam. Der bi ak yàpp wi ak deret ji ak sébbriit mi, lépp lañuy lakk. ");
INSERT INTO wolmbs_vpl VALUES ("NU19_6","005_19_6","NUM","19","6","6","Su ko defee sarxalkat bi sàkk bantu seedar ak caru isob ak ndimo lu xonq curr, boole ko sànni ca sawara wa ñuy lakke nag wa. ");
INSERT INTO wolmbs_vpl VALUES ("NU19_7","005_19_7","NUM","19","7","7","Gannaaw loolu na sarxalkat bi fóot ay yéreem, sangu, doora mana duggaat ci dal bi, te du ko tee yendoo sobe ba ca ngoon. ");
INSERT INTO wolmbs_vpl VALUES ("NU19_8","005_19_8","NUM","19","8","8","Kiy lakk nag wi itam, na fóot ay yéreem, sangu, te du ko tee yendoo sobe ba ca ngoon. ");
INSERT INTO wolmbs_vpl VALUES ("NU19_9","005_19_9","NUM","19","9","9","Na ku set tonni dóomu nag wa ñu lakkoon, te sotti ko ci béreb bu set, foofa ca biti. Dóom ba dencub mbooloom bànni Israayil lay doon, ñu di ko waajale ndoxum setlu, ngir saraxu póotum bàkkaar. ");
INSERT INTO wolmbs_vpl VALUES ("NU19_10","005_19_10","NUM","19","10","10","Ku góor kiy tonni dóomu nag wi itam day fóot ay yéreem, te du tee mu yendoo sobe ba ca ngoon. Na loolu di dogalu yoon bu sax fàww, ñeel bànni Israayil, ak doxandéem bu dëkk ci seen biir. ");
INSERT INTO wolmbs_vpl VALUES ("NU19_11","005_19_11","NUM","19","11","11","«Bu loolu weesoo ku laal nit ku dee, ak néew bu mu mana doon, dina sobewu diiru juróom ñaari fan. ");
INSERT INTO wolmbs_vpl VALUES ("NU19_12","005_19_12","NUM","19","12","12","Na setlu ca ndox moomee ca bésub ñetteel ba, gannaaw ba mu ko laalee, te na setluwaat ca bésub juróom ñaareel ba. Su ko defee mu set. Waaye su setluwul ca bésub ñetteel ba, ak bésub juróom ñaareel ba, du set. ");
INSERT INTO wolmbs_vpl VALUES ("NU19_13","005_19_13","NUM","19","13","13","Képp ku laal nit ku dee, ak néew bu mu mana doon, bu setluwul, màkkaanu Aji Sax ji la sobeel. Kooku dees koy dagge ci bànni Israayil. Gannaaw ndoxum setlu ma, wiseesu ko ko, sobewu lay wéye. ");
INSERT INTO wolmbs_vpl VALUES ("NU19_14","005_19_14","NUM","19","14","14","«Lii la yoon wi tëral: Bu nit deewee ci biir xayma, képp ku dugg ci biir xayma bi, ak képp ku mu fekk ci xayma bi, day sobewu diiru juróom ñaari fan, ");
INSERT INTO wolmbs_vpl VALUES ("NU19_15","005_19_15","NUM","19","15","15","te mboolem ndab lu fa ubbiku woon, kubeer it ubu ko woon ràpp, loola ndab sobewu na. ");
INSERT INTO wolmbs_vpl VALUES ("NU19_16","005_19_16","NUM","19","16","16","Képp ku laal ca àll ba, nit ku ñu bóome saamar, mbaa ku Yàlla moomal boppam, mbaa mu laal yaxi nit ku dee, mbaa mu laal bàmmeel, kooka day sobewu diiru juróom ñaari fan. ");
INSERT INTO wolmbs_vpl VALUES ("NU19_17","005_19_17","NUM","19","17","17","Nañu sàkkal ki sobewu ca dóomu saraxu póotum bàkkaar ba ñu lakkoon, te ñu sotti ndox mu balle ci bëtu ndox ci ndab, ca kaw dóom ba. ");
INSERT INTO wolmbs_vpl VALUES ("NU19_18","005_19_18","NUM","19","18","18","Bu loolu wéyee, na ku set jël caru isob, capp ko ca ndox ma, wis-wisal ko ca kaw xayma ba nit deewe, wis ko ca kaw ndab yépp, ak ca kaw nit ña fa nekkoon. Na ko wis itam ci kaw nit ku laal yaxi ku dee, mbaa mu laal ku ñu bóome saamar, mbaa mu laal ku Yàlla moomal boppam, mbaa mu laal bàmmeel. ");
INSERT INTO wolmbs_vpl VALUES ("NU19_19","005_19_19","NUM","19","19","19","Bésub ñetteel ba nag, ak bésub juróom ñaareel ba, ci la nit ku set di wis-wisal ndox mi ci kaw ki sobewu. Bésub juróom ñaareel ba ca la koy settali. Su ko defee ka sobewu fóot ay yéreem, sangu, bu jant sowee mu daldi set. ");
INSERT INTO wolmbs_vpl VALUES ("NU19_20","005_19_20","NUM","19","20","20","Képp ku sobewu te setluwul, kooku dees koy dagge ci mbooloo mi, ndax béreb bu sell ñeel Aji Sax ji la sobeel. Gannaaw wiseesu ko ndoxum setlu mi, sobewu na. ");
INSERT INTO wolmbs_vpl VALUES ("NU19_21","005_19_21","NUM","19","21","21","«Na leen loolu ñeel ci kaw dogalu yoon bu sax dàkk. Ka doon wis-wisal ndoxum setlu mi nag, na fóot ay yéreem, te ku laal ci ndoxum setlu mi day yendoo sobe ba ca ngoon. ");
INSERT INTO wolmbs_vpl VALUES ("NU19_22","005_19_22","NUM","19","22","22","Nit ki sobewu, mboolem lu mu laal day sobewu, te ku laal ca loola it day yendoo sobe ba ca ngoon.» ");
INSERT INTO wolmbs_vpl VALUES ("NU20_1","005_20_1","NUM","20","1","1","Mbooloom bànni Israayil gépp nag àgg ca màndiŋu Ciin, ci biir weer wi njëkk ci at mi. Ñu daldi dal ca Kades. Fa la Maryaama faatoo, ñu denc ko foofa. ");
INSERT INTO wolmbs_vpl VALUES ("NU20_2","005_20_2","NUM","20","2","2","Ci kaw loolu mbooloo ma dem ba ñàkk ndox. Ñu daje ci kaw Musaa ak Aaróona. ");
INSERT INTO wolmbs_vpl VALUES ("NU20_3","005_20_3","NUM","20","3","3","Mbooloo ma jote faak Musaa, naa ko: «Moo, lu nu tee woona dee keroog ba sunu bokk ya deewee fa kanam Aji Sax ji? ");
INSERT INTO wolmbs_vpl VALUES ("NU20_4","005_20_4","NUM","20","4","4","Ana loo indee mbooloom Aji Sax ji ci màndiŋ mii, nu di fi deesi doŋŋ, nook sunug jur? ");
INSERT INTO wolmbs_vpl VALUES ("NU20_5","005_20_5","NUM","20","5","5","Ana loo nu jële woon Misra, di nu indi fu bon fii? Du béreb bu nangu menn jiwu: du figg, du reseñ, du gërënaat, te du siitum ndox mu ñu naan!» ");
INSERT INTO wolmbs_vpl VALUES ("NU20_6","005_20_6","NUM","20","6","6","Ba loolu amee Musaa ak Aaróona bàyyikoo ca mbooloo ma, dem ba ca bunt xaymab ndaje ma. Ñu ne gurub, dëpp seen jë fa suuf. Leeru Aji Sax ji nag feeñu leen. ");
INSERT INTO wolmbs_vpl VALUES ("NU20_7","005_20_7","NUM","20","7","7","Aji Sax ji wax ak Musaa, ne: ");
INSERT INTO wolmbs_vpl VALUES ("NU20_8","005_20_8","NUM","20","8","8","«Jëlal saw yet, nga dajale mbooloo mi, yaak sa mag Aaróona, ngeen wax ak doj woowu, ñuy gis, mu xelli am ndox. Te nga sottil leen ndox mu jóge ci doj wi, nàndale ko mbooloo mi, ñook seenug jur.» ");
INSERT INTO wolmbs_vpl VALUES ("NU20_9","005_20_9","NUM","20","9","9","Ba mu ko defee Musaa jële yet wa fa kanam Aji Sax ji, na mu ko ko sante. ");
INSERT INTO wolmbs_vpl VALUES ("NU20_10","005_20_10","NUM","20","10","10","Musaa ak Aaróona nag dajale mbooloo ma fa janook doj wa, Musaa ne leen: «Yeen diiŋatkat yi, dégluleen ma fii! Doj wii, tee nu leen cee génneel am ndox boog?» ");
INSERT INTO wolmbs_vpl VALUES ("NU20_11","005_20_11","NUM","20","11","11","Ci kaw loolu Musaa yékkati loxoom, dóor yetam ca doj wa ñaari yoon, ndox mu bare wale ca, mbooloo ma daldi naan, ñook seenug jur. ");
INSERT INTO wolmbs_vpl VALUES ("NU20_12","005_20_12","NUM","20","12","12","Aji Sax ji nag ne Musaa ak Aaróona: «Gannaaw gëmuleen ma, ngir wormaal sama sellaay fi kanam bànni Israayil, loolu tax na dungeen yóbbu mukk mbooloo mii ca réew ma ma leen jox.» ");
INSERT INTO wolmbs_vpl VALUES ("NU20_13","005_20_13","NUM","20","13","13","Loolooy walum Meriba, (muy firi Jote ba). Fa la bànni Israayil jote woon ak Aji Sax ji, ba mu biral sellaayam fa seen biir. ");
INSERT INTO wolmbs_vpl VALUES ("NU20_14","005_20_14","NUM","20","14","14","Gannaaw gi, Musaa moo yebale ay ndaw fa dëkk ba ñuy wax Kades, ñu dem ca buurub Edom, ne ko: «Israayil say bokk dañoo wax ne: Umplewoo mboolem coono bi nu daj. ");
INSERT INTO wolmbs_vpl VALUES ("NU20_15","005_20_15","NUM","20","15","15","Sunuy maam a demoon Misra; dëkk nanu Misra lu yàgg, waa Misra di nu mitital, na woon ca sunuy maam. ");
INSERT INTO wolmbs_vpl VALUES ("NU20_16","005_20_16","NUM","20","16","16","Ci biir loolu nu woo Aji Sax ji wall, mu dégg sunu yuux, daldi yebal malaaka, mu génne nu Misra. Léegi nu ngi nii fi Kades, dëkk bi digalook sam réew. ");
INSERT INTO wolmbs_vpl VALUES ("NU20_17","005_20_17","NUM","20","17","17","Ngalla nag may nu, nu jaare sam réew. Dunu fi jaare benn tool, mbaa ab tóokëru reseñ, dunu fi naane ndoxum benn teen. Mbeddum buur daal lanuy topp, dunu jàdd ndijoor ak càmmoñ, ba keroog nuy génn sam réew.» ");
INSERT INTO wolmbs_vpl VALUES ("NU20_18","005_20_18","NUM","20","18","18","Buurub Edom nag ne leen: «Dungeen jaare fi man de, lu ko moy saamar laay génne, dajeek yeen.» ");
INSERT INTO wolmbs_vpl VALUES ("NU20_19","005_20_19","NUM","20","19","19","Ndawi bànni Israayil ne ko: «Sél wi rekk lanuy topp, te ndox mu nu naan, nook sunug jur, noo la koy fey. Ñaanunu lenn lu moy doxe sunuy tànk, ba jàll.» ");
INSERT INTO wolmbs_vpl VALUES ("NU20_20","005_20_20","NUM","20","20","20","Mu ne leen: «Dungeen fi jaare mukk!» Ci kaw loolu Edom génn ngir dajeek ñoom, ànd ak gàngoor gu réy, gànnaayu ba diis. ");
INSERT INTO wolmbs_vpl VALUES ("NU20_21","005_20_21","NUM","20","21","21","Noonu la Edom lànke, mayul Israayil mu jaare réewam, ba Israayil mujj teggi. ");
INSERT INTO wolmbs_vpl VALUES ("NU20_22","005_20_22","NUM","20","22","22","Ci kaw loolu mbooloom bànni Israayil gépp bàyyikoo Kades, ba ca tundu Or. ");
INSERT INTO wolmbs_vpl VALUES ("NU20_23","005_20_23","NUM","20","23","23","Aji Sax ji wax ak Musaa ak Aaróona, ca Or, tund wa ca kemu réewum Edom. Mu ne: ");
INSERT INTO wolmbs_vpl VALUES ("NU20_24","005_20_24","NUM","20","24","24","«Dees na tërali Aaróona fa ay bokkam. Du dugg déy ca réew ma ma jox bànni Israayil, gannaaw yeena gàntaloon sama ndigal ca walum Meriba. ");
INSERT INTO wolmbs_vpl VALUES ("NU20_25","005_20_25","NUM","20","25","25","Àndal ak Aaróona ak doomam Elasar, nga yéege leen ca kaw tundu Or. ");
INSERT INTO wolmbs_vpl VALUES ("NU20_26","005_20_26","NUM","20","26","26","Te nga summi yérey carxal yu Aaróona, solal ko doomam Elasar. Aaróona moom, dees koy tërali ca ay bokkam. Foofa lay deewe.» ");
INSERT INTO wolmbs_vpl VALUES ("NU20_27","005_20_27","NUM","20","27","27","Ba loolu amee Musaa def la ko Aji Sax ji sant, ñu ànd yéeg kaw tundu Or, mbooloo ma mépp di gis. ");
INSERT INTO wolmbs_vpl VALUES ("NU20_28","005_20_28","NUM","20","28","28","Musaa summi yérey Aaróona, solal ko doomam Elasar, Aaróona dee foofa ca kaw tund wa, Musaa ak Elasar wàcc tund wa. ");
INSERT INTO wolmbs_vpl VALUES ("NU20_29","005_20_29","NUM","20","29","29","Mbooloo ma mépp nag xam ne Aaróona dëddu na. Waa kër Israayil gépp a ko jooy diiru fanweeri fan. ");
INSERT INTO wolmbs_vpl VALUES ("NU21_1","005_21_1","NUM","21","1","1","Kanaaneen ba, buurub Aràdd ba dëkke woon Negew, moo dégg ne Israayil a ngay jaare yoonu Atarim, di dikk. Mu xareek Israayil, jàpp ñenn ca ñoom. ");
INSERT INTO wolmbs_vpl VALUES ("NU21_2","005_21_2","NUM","21","2","2","Ci kaw loolu Israayil xasal Aji Sax ji aw xas, ne ko: «Soo tegee ba teg mbooloo mii ci sunuy loxo déy, dinanu faagaagal seeni dëkk.» ");
INSERT INTO wolmbs_vpl VALUES ("NU21_3","005_21_3","NUM","21","3","3","Aji Sax ji nangul Israayil, jébbal leen Kanaaneen ña, ñu faagaagal leen, ñook seeni dëkk. Ñu daldi woowe gox ba Xorma (muy firi Lu ñu faagaagal). ");
INSERT INTO wolmbs_vpl VALUES ("NU21_4","005_21_4","NUM","21","4","4","Ñu bàyyikoo tundu Or, jubal yoonu géeju Barax ya, ngir teggi réewum Edom. Mbooloo ma nag mujj xàddi ca yoon wa. ");
INSERT INTO wolmbs_vpl VALUES ("NU21_5","005_21_5","NUM","21","5","5","Ña ngay xultu ca kaw Yàlla ak Musaa, naa: «Lu ngeen nu doon jële Misra, ngir nu dee ci màndiŋ mi? Duw ñam, dum ndox, te mànn mii, di ñamu toskare génnliku na nu!» ");
INSERT INTO wolmbs_vpl VALUES ("NU21_6","005_21_6","NUM","21","6","6","Ba loolu amee Aji Sax ji yebal ay jaan yu seen daŋar di lakke ca biir mbooloo ma, ñu màtt leen, ba ñu bare ci bànni Israayil dee. ");
INSERT INTO wolmbs_vpl VALUES ("NU21_7","005_21_7","NUM","21","7","7","Mbooloo ma dikk ba ci Musaa, ne ko: «Noo tooñ, ndax noo xultu ci kaw Aji Sax ji, ak ci sa kaw. Tinul nu Aji Sax ji, mu teggil nu jaan yi!» Musaa daldi tinul mbooloo ma. ");
INSERT INTO wolmbs_vpl VALUES ("NU21_8","005_21_8","NUM","21","8","8","Aji Sax ji ne Musaa: «Defarlul jëmmu jaan ju daŋar ji di lakke, nga wékk ko ci bant. Su ko defee képp ku ñu màtt, boo ca xoolee, mucc.» ");
INSERT INTO wolmbs_vpl VALUES ("NU21_9","005_21_9","NUM","21","9","9","Ci kaw loolu Musaa defarlu jaanu xànjar, wékk ko ci bant, ba képp ku jaan màtt, bu xoolee jaanu xànjar ja, daldi mucc. ");
INSERT INTO wolmbs_vpl VALUES ("NU21_10","005_21_10","NUM","21","10","10","Bànni Israayil fabooti, dem ba dali fa ñuy wax Obot, ");
INSERT INTO wolmbs_vpl VALUES ("NU21_11","005_21_11","NUM","21","11","11","jóge Obot, dali Yee Abarim, ca màndiŋ ma janook Mowab, ca penku ba. ");
INSERT INTO wolmbs_vpl VALUES ("NU21_12","005_21_12","NUM","21","12","12","Foofa lañu faboo, dem ba dali ca walum Seredd, ");
INSERT INTO wolmbs_vpl VALUES ("NU21_13","005_21_13","NUM","21","13","13","bàyyikooti foofa, dem ba dali ca wàllaa dexu Arnon ga wale ca réewum Amoreen ña te jaare ca màndiŋ ma. Dexu Arnon googa, fa la réewum Mowab digalook Amoreen ñi. ");
INSERT INTO wolmbs_vpl VALUES ("NU21_14","005_21_14","NUM","21","14","14","Moo tax téereb Xarey Aji Sax ji indi ko, ne: «Waxeb ga ca Sufa, xuri Arnon yaak ");
INSERT INTO wolmbs_vpl VALUES ("NU21_15","005_21_15","NUM","21","15","15","xur ya bartalu, jëm néegi Ar, leruji suufas Mowab.» ");
INSERT INTO wolmbs_vpl VALUES ("NU21_16","005_21_16","NUM","21","16","16","Fa lañu bàyyikoo, dem Beer, (muy firi ab Teen); teen boobu, fa la Aji Sax ji noon Musaa: «Dajaleel mbooloo mi, ma may leen ndox.» ");
INSERT INTO wolmbs_vpl VALUES ("NU21_17","005_21_17","NUM","21","17","17","Ca la Israayil woy woy wii: «Teen bile walal, nu woy. ");
INSERT INTO wolmbs_vpl VALUES ("NU21_18","005_21_18","NUM","21","18","18","Ay garmee la bënn, kàngami askan wi gase la yeti buur ak seen banti bopp.» Ñu jóge màndiŋ ma, dem ba Matana, ");
INSERT INTO wolmbs_vpl VALUES ("NU21_19","005_21_19","NUM","21","19","19","jóge Matana dem Naxaliyel, jóge Naxaliyel, dem Bamot, ");
INSERT INTO wolmbs_vpl VALUES ("NU21_20","005_21_20","NUM","21","20","20","jóge Bamot ba ca xur wa ca àllub Mowab, àkki nag njobbaxtalu tundu Pisga wa tiim ndànd-foyfoy ga. ");
INSERT INTO wolmbs_vpl VALUES ("NU21_21","005_21_21","NUM","21","21","21","Ba loolu amee Israayil yebal ay ndaw ca Sixon buurub Amoreen ña, ne ko: ");
INSERT INTO wolmbs_vpl VALUES ("NU21_22","005_21_22","NUM","21","22","22","«May nu, nu jaare sam réew. Dunu fi jàdde benn tool mbaa ab tóokëru reseñ, dunu fi naan ndoxum teen. Mbeddum buur lanuy topp, ba keroog nuy jàll sam réew.» ");
INSERT INTO wolmbs_vpl VALUES ("NU21_23","005_21_23","NUM","21","23","23","Sixon nag mayul Israayil, ñu jaarem réewam, xanaa mu dajale gàngooram gépp, sàqi, ngir dajejeek Israayil ca màndiŋ ma. Mu dikk ba Yaxacc, song Israayil, ");
INSERT INTO wolmbs_vpl VALUES ("NU21_24","005_21_24","NUM","21","24","24","Israayil leel ko ñawkay saamar, nangu seenum réew, dale ko Arnon ba Yabog, ba àgg ca Amoneen ña, ndax kemu réewum Amoneen ñaa fegu woon ba kenn manu koo bëtt, jàll. ");
INSERT INTO wolmbs_vpl VALUES ("NU21_25","005_21_25","NUM","21","25","25","Israayil nangu dëkki Amoreen yooyu yépp, daldi sance mboolem seeni dëkk, boole ca Esbon aki dëkk-dëkkaanam. ");
INSERT INTO wolmbs_vpl VALUES ("NU21_26","005_21_26","NUM","21","26","26","Esbon moo doon péeyub Sixon buurub Amoreen ña. Kookoo xare woon ak buuru Mowab ba woon, moo nangu ciy loxoom réewam mépp, ba Arnon. ");
INSERT INTO wolmbs_vpl VALUES ("NU21_27","005_21_27","NUM","21","27","27","Moo tax woykat ya ne: «Ayca ca Esbon, ba tabaxees kooti; na dëkkub Sixon jógati. ");
INSERT INTO wolmbs_vpl VALUES ("NU21_28","005_21_28","NUM","21","28","28","Lakk gaa nga jóge Esbon, sawaraa bawoo dëkkub Sixon ba, xoyomi Ar ga ca Mowab, gor ñooña tiim dexu Arnon. ");
INSERT INTO wolmbs_vpl VALUES ("NU21_29","005_21_29","NUM","21","29","29","Mowabee ngalla yaw! Sànku ngeenee, yeen askanu Kemos, mi wacc doomam yu góor, ñu daw, doomam yu jigéen doon jaami Sixon buurub Amor. ");
INSERT INTO wolmbs_vpl VALUES ("NU21_30","005_21_30","NUM","21","30","30","Noo leen fitt, Esbon ba Dibon rajaxoo, nu rajaxeeti ba Nofa, ba àkki Medeba.» ");
INSERT INTO wolmbs_vpl VALUES ("NU21_31","005_21_31","NUM","21","31","31","Israayil nag dëkke réewum Amoreen ña. ");
INSERT INTO wolmbs_vpl VALUES ("NU21_32","005_21_32","NUM","21","32","32","Ba loolu amee Musaa yebal ay ndaw, ñu yëri dëkk ba ñuy wax Yaser. Gannaaw gi, bànni Israayil nangu dëkk-dëkkaan ya, daldi fay dàqe Amoreen ña. ");
INSERT INTO wolmbs_vpl VALUES ("NU21_33","005_21_33","NUM","21","33","33","Ba mu ko defee ñu walbatiku, awe yoonu Basan, Og buuru Basan ànd ak gàngooram gépp, dajejeek ñoom, song leen xare ca Eddrey. ");
INSERT INTO wolmbs_vpl VALUES ("NU21_34","005_21_34","NUM","21","34","34","Aji Sax ji ne Musaa: «Bu ko ragal, ndax ci say loxo laa ko teg, mook gàngooram gépp akum réewam, nga def ko na nga defoon Sixon buurub Amoreen ba woon fa Esbon.» ");
INSERT INTO wolmbs_vpl VALUES ("NU21_35","005_21_35","NUM","21","35","35","Ci kaw loolu ñu jam Og, mooki doomam ak gàngooram gépp, ba desewul kuy dund, ñu daldi nangu réewam. ");
INSERT INTO wolmbs_vpl VALUES ("NU22_1","005_22_1","NUM","22","1","1","Bànni Israayil demati ba dali ca joori Mowab ca wàllaa dexu Yurdan, janook Yeriko. ");
INSERT INTO wolmbs_vpl VALUES ("NU22_2","005_22_2","NUM","22","2","2","Fekk na Balag doomu Cippor gis mboolem la bànni Israayil def Amoreen ña. ");
INSERT INTO wolmbs_vpl VALUES ("NU22_3","005_22_3","NUM","22","3","3","Mowab nag am tiitaange ju réy ca gàngooru bànni Israayil, ndax bare. Mowab jàq na ba mu gisee bànni Israayil. ");
INSERT INTO wolmbs_vpl VALUES ("NU22_4","005_22_4","NUM","22","4","4","Ci kaw loolu Mowab giseek magi Majan, ne leen: «Ndiiraan wii kat, ni nag di forem parlu ba mu set, ni lañu nara ñédde li nu wër lépp, ba mu set.» Jant yooyu Balag doomu Cippor moo doon buuru Mowab. ");
INSERT INTO wolmbs_vpl VALUES ("NU22_5","005_22_5","NUM","22","5","5","Mu yebal ay ndaw ca Balaam doomu Bewor ngir woowi ko, ca Petor ga Balaam cosaanoo, ca tàkkal dexu Efraat ngir ne ko: «Balaam! Gàngoor a ngii jóge Misra. Ñu ngii lal suuf si ba mu daj, te ñoo sanc, janook man màkk. ");
INSERT INTO wolmbs_vpl VALUES ("NU22_6","005_22_6","NUM","22","6","6","Kon nag dikkal gaaw ñaanal ma yàlla gàngoor gii, ngir ñoo ma ëpp doole. Jombul ma duma leen, ba dàq leen réew mi, ndax xam naa ne koo ñaanal barke, mu barkeel, te koo ñaanal alkànde, mu alku.» ");
INSERT INTO wolmbs_vpl VALUES ("NU22_7","005_22_7","NUM","22","7","7","Ci kaw loolu magi Mowab ànd ak magi Majan, dem, yóbbaale ay weexal. Ba ñu agsee ca Balaam, daldi koy àgge kàdduy Balag. ");
INSERT INTO wolmbs_vpl VALUES ("NU22_8","005_22_8","NUM","22","8","8","Mu ne leen: «Fanaanleen fii guddig tey. Tont lu ma ci Aji Sax ji sant rekk, dinaa leen ko àgge.» Kàngami Mowab dal ak Balaam. ");
INSERT INTO wolmbs_vpl VALUES ("NU22_9","005_22_9","NUM","22","9","9","Yàlla nag dikkal Balaam, ne ko: «Nit ñii fi yaw, ñu mu doon?» ");
INSERT INTO wolmbs_vpl VALUES ("NU22_10","005_22_10","NUM","22","10","10","Balaam ne Yàlla: «Buuru Mowab Balag doomu Cippor moo yónnee ci man, ne ma: ");
INSERT INTO wolmbs_vpl VALUES ("NU22_11","005_22_11","NUM","22","11","11","“Balaam, gàngoor a ngii jóge Misra, lal suuf si ba mu daj. Dikkal gaaw móolul ma leen. Jombul ma mana xareek ñoom, ba dàq leen.”» ");
INSERT INTO wolmbs_vpl VALUES ("NU22_12","005_22_12","NUM","22","12","12","Yàlla ne Balaam: «Bul ànd ak ñoom, te bul ñaan-yàlla mbooloo ma, ndax ñooñu ñu barkeel lañu.» ");
INSERT INTO wolmbs_vpl VALUES ("NU22_13","005_22_13","NUM","22","13","13","Ba Balaam jógee ca suba sa, da ne kàngami Balag ya: «Delluleen seenum réew, ndax Aji Sax ji bañ na; mayu ma ma ànd ak yeen.» ");
INSERT INTO wolmbs_vpl VALUES ("NU22_14","005_22_14","NUM","22","14","14","Kàngami Mowab daldi dellu ca Balag, ne ko: «Balaam de bañ naa ànd ak nun.» ");
INSERT INTO wolmbs_vpl VALUES ("NU22_15","005_22_15","NUM","22","15","15","Balag dellu yebal kàngam yu gëna bare, te gëna kawe. ");
INSERT INTO wolmbs_vpl VALUES ("NU22_16","005_22_16","NUM","22","16","16","Ñooña dem ba ca Balaam, ne ko: «Balag doomu Cippor dafa wax ne: “Ngalla, bu la dara teree dikk, wuyusi ma. ");
INSERT INTO wolmbs_vpl VALUES ("NU22_17","005_22_17","NUM","22","17","17","Maa lay teral teraanga ju réya réy. Loo ma wax, ma def. Dikkal rekk, móolul ma gàngoor gii.”» ");
INSERT INTO wolmbs_vpl VALUES ("NU22_18","005_22_18","NUM","22","18","18","Balaam tontu surgay Balag, ne leen: «Bu ma Balag doon jox këram ba mu fees ak xaalis ak wurus sax, duma mana def lenn lu tuut mbaa lu réy, lu tebbi sama ndigalu Yàlla Aji Sax ji. ");
INSERT INTO wolmbs_vpl VALUES ("NU22_19","005_22_19","NUM","22","19","19","Waaye yeen it dalleen fii guddig tey, ba ma xam lu ma Aji Sax jiy waxaat.» ");
INSERT INTO wolmbs_vpl VALUES ("NU22_20","005_22_20","NUM","22","20","20","Ci kaw loolu Yàlla dikkal Balaam ca guddi ga, ne ko: «Gannaaw woosi la mooy tànki ñii, àndal ak ñoom. Waaye nag lu ma la wax rekk, def ko.» ");
INSERT INTO wolmbs_vpl VALUES ("NU22_21","005_22_21","NUM","22","21","21","Ca ëllëg sa Balaam takk mbaamam, ànd ak kàngami Mowab, dem. ");
INSERT INTO wolmbs_vpl VALUES ("NU22_22","005_22_22","NUM","22","22","22","Ba loolu amee sànjum Yàlla tàkk ndax yoon wa mu sumb. Malaakam Aji Sax ji nag taxaw ca yoon wa, nara jànkoonte ak moom, moom mu war mbaamam, ànd ak ñaari surgaam. ");
INSERT INTO wolmbs_vpl VALUES ("NU22_23","005_22_23","NUM","22","23","23","Ci kaw loolu mbaam ma gis malaakam Aji Sax ji taxaw ca digg yoon wa, xàcc saamaram. Mbaam ma ne walbit, wàcc yoon wa, topp àll ba. Balaam dóor mbaam ma, waññi ko ba ca yoon wa. ");
INSERT INTO wolmbs_vpl VALUES ("NU22_24","005_22_24","NUM","22","24","24","Ba mu ko defee malaakam Aji Sax ji taxawi fu yoon wa def ñall wu sew wu jaare digg tóokëri reseñ, ñaari miir séq ko. ");
INSERT INTO wolmbs_vpl VALUES ("NU22_25","005_22_25","NUM","22","25","25","Mbaam ma gis malaakam Aji Sax ji, daldi tafu ca miir ba, ba tancaale ca tànkub Balaam. Balaam dellu ko dóor. ");
INSERT INTO wolmbs_vpl VALUES ("NU22_26","005_22_26","NUM","22","26","26","Malaakam Aji Sax ja dellu jiitu, ba taxawi fu xat, ba maneesula weesalook moom, du ndijoor, du càmmoñ. ");
INSERT INTO wolmbs_vpl VALUES ("NU22_27","005_22_27","NUM","22","27","27","Mbaam ma gis malaakam Aji Sax ja, daldi ne wàpp goor ca suufu Balaam, xol ba fuddu, mu dóorati mbaam ma yet wa. ");
INSERT INTO wolmbs_vpl VALUES ("NU22_28","005_22_28","NUM","22","28","28","Ba loolu amee Aji Sax ji tijji gémmiñu mbaam mi, mu ne Balaam: «Ana lu ma la def, ba ñetti yoon a ngii nga di ma dóor?» ");
INSERT INTO wolmbs_vpl VALUES ("NU22_29","005_22_29","NUM","22","29","29","Balaam ne mbaam mi: «Yaa may foontoo, su ma yoroon saamar, léegi laa lay rey!» ");
INSERT INTO wolmbs_vpl VALUES ("NU22_30","005_22_30","NUM","22","30","30","Mu ne ko: «Xanaa du maay sa mbaam mi ngay war bu yàgg ba nga ma moomee, ba tey jii? Dama laa masa def nii?» Mu ne ko: «Déedéet.» ");
INSERT INTO wolmbs_vpl VALUES ("NU22_31","005_22_31","NUM","22","31","31","Aji Sax ji nag ubbi bëti Balaam, mu gis malaakam Aji Sax ja, mu taxaw ca yoon wa, xàcc saamaram. Mu ne gurub sukk, dëpp jëëm fa suuf. ");
INSERT INTO wolmbs_vpl VALUES ("NU22_32","005_22_32","NUM","22","32","32","Malaakam Aji Sax ji ne ko: «Lu tax ngay dóor sa mbaam mi ñetti yoon nii? Man mii maa dikk, jànkoonteek yaw, ndax yoonu sànkute laa gis. ");
INSERT INTO wolmbs_vpl VALUES ("NU22_33","005_22_33","NUM","22","33","33","Mbaam mi moo ma gis, teggi ma ba muy ñetti yoon nii. Bu ma teggiwuloon déy, yaw laay rey; moom, ma ba ko, mu dund.» ");
INSERT INTO wolmbs_vpl VALUES ("NU22_34","005_22_34","NUM","22","34","34","Balaam ne malaakam Aji Sax ji: «Maa tooñ, ndax xawma woon ne yaa taxaw, dogale ma ci yoon wi. Léegi nag su la yoon wi neexul, ma daldi dëpp.» ");
INSERT INTO wolmbs_vpl VALUES ("NU22_35","005_22_35","NUM","22","35","35","Malaakam Aji Sax ji ne Balaam: «Àndal ak nit ñi, waaye daal lu ma la waxloo rekk, wax ko.» Balaam nag ànd ak kàngami Balag, dem. ");
INSERT INTO wolmbs_vpl VALUES ("NU22_36","005_22_36","NUM","22","36","36","Ba loolu amee Balag dégg ne Balaam a ngay ñëw, mu gatanduji ko ca dëkku Mowab, ba digalook dexu Arnon, ca catu réew ma. ");
INSERT INTO wolmbs_vpl VALUES ("NU22_37","005_22_37","NUM","22","37","37","Balag ne Balaam: «Xanaa yeblewuma woon, ba yebleeti, di la woolu? Lu la tee woona ñëw? Am dama laa manula teral?» ");
INSERT INTO wolmbs_vpl VALUES ("NU22_38","005_22_38","NUM","22","38","38","Balaam ne Balag: «Maa ngii, wuyusi la, waaye mbaa sañ naa waxal sama bopp lenn? Kàddu gu ma Yàlla waxloo de, moom laay wax.» ");
INSERT INTO wolmbs_vpl VALUES ("NU22_39","005_22_39","NUM","22","39","39","Ci kaw loolu Balaam ànd ak Balag ba Kiryaat Xuccot. ");
INSERT INTO wolmbs_vpl VALUES ("NU22_40","005_22_40","NUM","22","40","40","Balag daldi sarxe ay nag aki gàtt, sédd ca Balaam ak kàngam ya ko dar. ");
INSERT INTO wolmbs_vpl VALUES ("NU22_41","005_22_41","NUM","22","41","41","Ca suba sa Balag ànd ak Balaam, yéeg ba ca kaw bérebi jaamookaay ya ñu dippee tuur ma ñuy wax Baal, mu tollu fa di séen lenni catu mbooloo ma. ");
INSERT INTO wolmbs_vpl VALUES ("NU23_1","005_23_1","NUM","23","1","1","Ba loolu amee Balaam ne Balag: «Tabaxal ma fii juróom ñaari sarxalukaay, te waajalal ma fi juróom ñaari yëkk yu ndaw, ak juróom ñaari kuuy.» ");
INSERT INTO wolmbs_vpl VALUES ("NU23_2","005_23_2","NUM","23","2","2","Balag def na Balaam wax, Balag ak Balaam ku ci nekk sarxal wenn yëkk ak menn kuuy ci sarxalukaay bu nekk. ");
INSERT INTO wolmbs_vpl VALUES ("NU23_3","005_23_3","NUM","23","3","3","Balaam ne Balag: «Taxawal fii ci sa saraxu rendi-dóomal, ma dem ba nee. Jombul Aji Sax ji dikk, dajeek man. Mbir mu mu ma won, dinaa la ko àgge.» Mu daldi dem ba ca kaw tund wu ndaw wu dara saxul. ");
INSERT INTO wolmbs_vpl VALUES ("NU23_4","005_23_4","NUM","23","4","4","Ba loolu amee Yàlla dikk, dajeek Balaam, Balaam ne ko: «Juróom ñaari sarxalukaay yi, yékkati naa leen te sarxalukaay bu ci nekk, sarxal naa ci wenn yëkk ak menn kuuy.» ");
INSERT INTO wolmbs_vpl VALUES ("NU23_5","005_23_5","NUM","23","5","5","Aji Sax ji nag yeb kàddu ci gémmiñu Balaam, daldi ne ko: «Dellul ca Balag, te nga waxe noonu.» ");
INSERT INTO wolmbs_vpl VALUES ("NU23_6","005_23_6","NUM","23","6","6","Balaam dellu ca moom, fekkul lu moy mu taxaw ca saraxu dóomalam, moom ak kàngami Mowab yépp. ");
INSERT INTO wolmbs_vpl VALUES ("NU23_7","005_23_7","NUM","23","7","7","Balaam yékkati kàddug ñaanam, ne: «Fa Aram la ma Balag buuru Mowab jële, foofa ca tundi penku ya, ne ma: “Kaay ñaanal ma yàlla Yanqóoba. Dikkal rëbbal ma Israayil mii.” ");
INSERT INTO wolmbs_vpl VALUES ("NU23_8","005_23_8","NUM","23","8","8","Moo! Nu may móoloo ku Yàlla móoluwul? Ana nu may rëbbe ku Aji Sax ji rëbbul? ");
INSERT INTO wolmbs_vpl VALUES ("NU23_9","005_23_9","NUM","23","9","9","Kaw doj yii laa tollu di leen séen, fi kawte yii laa leen jéere. Aw askan a ngii, dëkke fu beru, te bokkuñu ak xeet yi. ");
INSERT INTO wolmbs_vpl VALUES ("NU23_10","005_23_10","NUM","23","10","10","Ana kuy lim feppi suuf, ba lim askanu Yanqóoba? Ku mana waññ xaajaatub Israayil gii? Man de, yal naa dee deewinu aji jub ñii, yal na sama muj mel ni gu askan wii!» ");
INSERT INTO wolmbs_vpl VALUES ("NU23_11","005_23_11","NUM","23","11","11","Ba loolu amee Balag ne Balaam: «Yaw, li nga ma def nag? Móolu samay noon laa la jële, yaw defoo lenn lu moy ñaanal leen?» ");
INSERT INTO wolmbs_vpl VALUES ("NU23_12","005_23_12","NUM","23","12","12","Mu ne ko: «Xanaa du kàddu gu Aji Sax ji yeb sama gémmiñ, moom laa wara sàmm, ngir wax ko?» ");
INSERT INTO wolmbs_vpl VALUES ("NU23_13","005_23_13","NUM","23","13","13","Balag ne ko: «Kaay rekk, topp ma, ba feneen fooy tollu di leen gis. Seen cat doŋŋ ngay gis nag, waaye doo leen gis ñoom ñépp. Su ko defee nga móolul ma leen foofu.» ");
INSERT INTO wolmbs_vpl VALUES ("NU23_14","005_23_14","NUM","23","14","14","Mu daldi koy yóbbu ba ca toolub Cofim, ca collu tundu Pisga. Ci kaw loolu mu tabax fa juróom ñaari sarxalukaay, sarxalukaay bu nekk, mu sarxalati fa yëkk wu ndaw ak am kuuy. ");
INSERT INTO wolmbs_vpl VALUES ("NU23_15","005_23_15","NUM","23","15","15","Balaam ne Balag: «Taxaweel nii ci sa saraxu rendi-dóomal, man ma séentuji nee.» ");
INSERT INTO wolmbs_vpl VALUES ("NU23_16","005_23_16","NUM","23","16","16","Ba loolu amee Aji Sax ji dajeek Balaam, daldi yeb kàddu ci gémmiñam, ne ko: «Dellul ca Balag, te nga waxe noonu.» ");
INSERT INTO wolmbs_vpl VALUES ("NU23_17","005_23_17","NUM","23","17","17","Mu dem ba ca moom, fekku ko lu moy mu taxaw ca wetu saraxu rendi-dóomalam, mook kàngami Mowab. Balag ne ko: «Lu Aji Sax ji wax?» ");
INSERT INTO wolmbs_vpl VALUES ("NU23_18","005_23_18","NUM","23","18","18","Balaam daldi yékkati kàddug ñaanam, ne: «Jógal dégloo, Balag, teewlu maa, doomi Cippor. ");
INSERT INTO wolmbs_vpl VALUES ("NU23_19","005_23_19","NUM","23","19","19","Yàlla du nit, bay fen, du doom aadama bay tuub. Moom wax na lu mu deful a? Am àddu na lu mu sottalul? ");
INSERT INTO wolmbs_vpl VALUES ("NU23_20","005_23_20","NUM","23","20","20","Kàddug barkeel gii laa jot ndigalam, Yàllaa barkeel, duma ko tebbi. ");
INSERT INTO wolmbs_vpl VALUES ("NU23_21","005_23_21","NUM","23","21","21","Séeneesul aw ay ci askanu Yanqóoba, giseesul aw naqar ci xeetu Israayil wii. Seen Yàlla Aji Sax jee ànd ak ñoom, njiinum buur a jibe fa seen biir. ");
INSERT INTO wolmbs_vpl VALUES ("NU23_22","005_23_22","NUM","23","22","22","Yàllaa leen jële Misra, féete leen fa ay béjjén féete nagu àll. ");
INSERT INTO wolmbs_vpl VALUES ("NU23_23","005_23_23","NUM","23","23","23","Ñeengo jàppul Yanqóoba, gisaane gisul Israayil gii. Lu jot rekk, àggees ko Yanqóoba: ne ko: “Israayiloo, lii la Yàlla def.” ");
INSERT INTO wolmbs_vpl VALUES ("NU23_24","005_23_24","NUM","23","24","24","Wii askan ni gaynde lay jóge, ni gayndeg sibi lay faboo, du goor te yàppul am pàdd, deret ja tuuru, mu xab.» ");
INSERT INTO wolmbs_vpl VALUES ("NU23_25","005_23_25","NUM","23","25","25","Ba loolu amee Balag ne Balaam: «Boo leen móoluwul benn yoon kay, bu leen ñaanal ba doyal boog!» ");
INSERT INTO wolmbs_vpl VALUES ("NU23_26","005_23_26","NUM","23","26","26","Balaam ne ko: «Xanaa waxuma la woon ne la lépp lu Aji Sax ji wax, loolu laay def?» ");
INSERT INTO wolmbs_vpl VALUES ("NU23_27","005_23_27","NUM","23","27","27","Balag ne ko: «Kaay rekk, ma yóbbu la feneen. Jombul Yàlla nangu nga móolool ma leen foofu.» ");
INSERT INTO wolmbs_vpl VALUES ("NU23_28","005_23_28","NUM","23","28","28","Balag yóbbu Balaam ba ca collu tundu Pewor, wa tiim ndànd-foyfoy ga. ");
INSERT INTO wolmbs_vpl VALUES ("NU23_29","005_23_29","NUM","23","29","29","Balaam ne Balag: «Tabaxal ma fii juróom ñaari sarxalukaay, te nga waajalal ma fi juróom ñaari yëkk yu ndaw, ak juróom ñaari kuuy.» ");
INSERT INTO wolmbs_vpl VALUES ("NU23_30","005_23_30","NUM","23","30","30","Balag def na Balaam wax, ba noppi sarxal aw yëkk wu ndaw ak am kuuy ci kaw sarxalukaay bu nekk. ");
INSERT INTO wolmbs_vpl VALUES ("NU24_1","005_24_1","NUM","24","1","1","Balaam nag gis ne Aji Sax ji la neex mu barkeel Israayil, ba tax sàkkootul ay takk na woon, xanaa mu walbatiku, janook màndiŋ ma. ");
INSERT INTO wolmbs_vpl VALUES ("NU24_2","005_24_2","NUM","24","2","2","Ci kaw loolu Balaam dawal bëtam, daldi séen Israayil, na ñu dale topp seeni giir, leerug Yàlla daldi koy dikkal. ");
INSERT INTO wolmbs_vpl VALUES ("NU24_3","005_24_3","NUM","24","3","3","Ba mu ko defee mu yékkati kàddug ñaanam, ne: «Kàddug Balaam a ngi, doomu Bewor, kàddug waa jiy boroom gis, ");
INSERT INTO wolmbs_vpl VALUES ("NU24_4","005_24_4","NUM","24","4","4","kàddug kiy dégg waxi Yàlla, Aji Man ji wonem peeñu, mu gis, kiy daanu leer, te ay gëtam muriku. ");
INSERT INTO wolmbs_vpl VALUES ("NU24_5","005_24_5","NUM","24","5","5","Yanqóobaa, yaaka yànji xayma! Israayil, laa ne, yaaka taaruy màkkaan! ");
INSERT INTO wolmbs_vpl VALUES ("NU24_6","005_24_6","NUM","24","6","6","Ña nga ne màww ni tooli tàndarma, nirooteek tóokëri tàkkal dex, mbaa garabu alowes gu xeeñ gu Aji Sax ji jëmbat, mbaa garabi seedar yu saxe wali ndox. ");
INSERT INTO wolmbs_vpl VALUES ("NU24_7","005_24_7","NUM","24","7","7","Ndox maay wale cay bagaanam, am jiwoom màndim ndox, buuram nara sut Buur Agag, nguuram jóg ba kawe. ");
INSERT INTO wolmbs_vpl VALUES ("NU24_8","005_24_8","NUM","24","8","8","Yàllaay ki ko jële Misra, féete ko fa ay béjjén féete nagu àll. Mooy warax xeet yi ko jógal, dammat leen, jamat leeni fittam. ");
INSERT INTO wolmbs_vpl VALUES ("NU24_9","005_24_9","NUM","24","9","9","Israayil a ngi yuug aka goor ni gaynde, mbete gayndeg sibi, ana ku koy yee? Ku ko ñaanal barke, yaay barkeel; ku ko ñaanal alkànde, yaay alku.» ");
INSERT INTO wolmbs_vpl VALUES ("NU24_10","005_24_10","NUM","24","10","10","Ba loolu amee Balag sànju ci kaw Balaam, daldi fenqey loxoom. Ci kaw loolu Balag ne Balaam: «Móolu samay noon laa la woowe woon, yaw defoo lu moy ñaanal leen a ñaanal, ba muy ñetti yoon nii! ");
INSERT INTO wolmbs_vpl VALUES ("NU24_11","005_24_11","NUM","24","11","11","Léegi nag, laggal ñibbi. Noon naa la dinaa la teral bu baax, waaye mu ngoog, Aji Sax jee la xañ teraanga.» ");
INSERT INTO wolmbs_vpl VALUES ("NU24_12","005_24_12","NUM","24","12","12","Balaam ne Balag: «Xanaa du sa ndaw yi nga yebaloon ci man sax, waxoon naa leen ne leen, ");
INSERT INTO wolmbs_vpl VALUES ("NU24_13","005_24_13","NUM","24","13","13","su ma Balag joxoon këram ba mu fees ak xaalis ak wurus sax, duma mana def ci sama coobarey bopp, lenn lu baax mbaa lu bon, lu tebbi ndigalu Yàlla Aji Sax ji? Li Aji Sax ji wax rekk, moom laay wax. ");
INSERT INTO wolmbs_vpl VALUES ("NU24_14","005_24_14","NUM","24","14","14","Léegi nag maa ngi dellu ca saay bokk, waaye kaay, ma xamal la li xeet wii di def saw xeet, fan yu mujj ya.» ");
INSERT INTO wolmbs_vpl VALUES ("NU24_15","005_24_15","NUM","24","15","15","Ci kaw loolu mu yékkati kàddug ñaanam, ne: «Kàddug Balaam a ngi, doomu Bewor, kàddug waa jiy boroom gis, ");
INSERT INTO wolmbs_vpl VALUES ("NU24_16","005_24_16","NUM","24","16","16","kàddug kiy dégg waxi Yàlla, kiy xame ca xam-xamu Aji Kawe ji, Aji Man ji wonem peeñu, mu gis, kiy daanu leer, te ay gëtam muriku. ");
INSERT INTO wolmbs_vpl VALUES ("NU24_17","005_24_17","NUM","24","17","17","Maa ngi koy gis, te du tey, maa ngi koy niir, te jubseegul; biddiiw a feqe fa Yanqóoba, yetu nguur a yékkatikoo fa Israayil, daldi toj boppi Mowab, toj kaaŋi mboolem askanu Set. ");
INSERT INTO wolmbs_vpl VALUES ("NU24_18","005_24_18","NUM","24","18","18","Edom, mu moom; Seyir, noonam, muy boroom; Israayil def jaloore. ");
INSERT INTO wolmbs_vpl VALUES ("NU24_19","005_24_19","NUM","24","19","19","Fa Yanqóoba la buur di bawoo, dem ñéddi ndesu dëkk ba.» ");
INSERT INTO wolmbs_vpl VALUES ("NU24_20","005_24_20","NUM","24","20","20","Ci kaw loolu Balaam geesu réewum Amaleg, dellu yékkati kàddug ñaanam, ne: «Amaleg moo sutu xeet, te sànku lay mujje.» ");
INSERT INTO wolmbs_vpl VALUES ("NU24_21","005_24_21","NUM","24","21","21","Mu teg ca geesu réewum Keñeen ña, yékkateeti kàddug ñaanam, ne: «Keñeen ñee wér ab dëkkuwaay, seenub tàgg a làqoo biir doj. ");
INSERT INTO wolmbs_vpl VALUES ("NU24_22","005_24_22","NUM","24","22","22","Waaye réewum Keñeen gépp ay xoyomu, ba leen Asur di yóbbuji njaam.» ");
INSERT INTO wolmbs_vpl VALUES ("NU24_23","005_24_23","NUM","24","23","23","Mu dellooti yékkati kàddug ñaanam, ne: «Wóoy kuy dund, keroog bu Yàlla dogalee lii? ");
INSERT INTO wolmbs_vpl VALUES ("NU24_24","005_24_24","NUM","24","24","24","Ay gaal ay jóge tefesu Kitim, néewalsi doole Asur, néewalsi doole Eber. Waaye ñoom it dañuy mujj sànku.» ");
INSERT INTO wolmbs_vpl VALUES ("NU24_25","005_24_25","NUM","24","25","25","Ci kaw loolu Balaam ñibbi am réewam, Balag it demu yoonam. ");
INSERT INTO wolmbs_vpl VALUES ("NU25_1","005_25_1","NUM","25","1","1","Ci kaw loolu Israayil dale fa Sitim. Mbooloo ma nag tàmbali di moy ak jigéeni Mowab. ");
INSERT INTO wolmbs_vpl VALUES ("NU25_2","005_25_2","NUM","25","2","2","Jigéen ña di woo mbooloo ma ca seen saraxi tuur ya, mbooloo ma di lekk aka sujjóotal seeni tuur. ");
INSERT INTO wolmbs_vpl VALUES ("NU25_3","005_25_3","NUM","25","3","3","Israayil nag taqook tuur ma ñuy wax Baal Pewor, ba sànjum Aji Sax ji tàkkal Israayil. ");
INSERT INTO wolmbs_vpl VALUES ("NU25_4","005_25_4","NUM","25","4","4","Aji Sax ji ne Musaa: «Jàppal njiiti mbooloo mi yépp, nga wékk leen ci bant fi kanam Aji Sax ji, bëccëg ndarakàmm, ngir sànjum Aji Sax ji dëddu Israayil.» ");
INSERT INTO wolmbs_vpl VALUES ("NU25_5","005_25_5","NUM","25","5","5","Musaa ne àttekati Israayil: «Na ku nekk ci yeen rey nitam ñi taqook Baal Pewor.» ");
INSERT INTO wolmbs_vpl VALUES ("NU25_6","005_25_6","NUM","25","6","6","Ci biir loolu rekk, jenn waayu bànni Israayil dikk, indaale senn ndawas waa Majan ci biiri bokkam, Musaa ak mbooloom Israayil mépp di gis, fekk ñoom ñuy jooyoo fa bunt xaymab ndaje ma. ");
INSERT INTO wolmbs_vpl VALUES ("NU25_7","005_25_7","NUM","25","7","7","Fineyas, doomu Elasar, doomu sarxalkat ba Aaróona, gis loolu, daldi jóge ca mbooloo ma, jël ab xeej. ");
INSERT INTO wolmbs_vpl VALUES ("NU25_8","005_25_8","NUM","25","8","8","Mu topp waayi Israayil ja ba ca biir néeg ba, daldi leen boole bennub xeej, ñoom ñaar, jam waayi Israayil ji, ba jamaale ndaw si ci biir. Ba mu ko defee mbas ma jotoona dal ca kaw bànni Israayil daldi dakk. ");
INSERT INTO wolmbs_vpl VALUES ("NU25_9","005_25_9","NUM","25","9","9","Ña dee ca mbas ma nag di ñaar fukki junneek ñeent (24 000). ");
INSERT INTO wolmbs_vpl VALUES ("NU25_10","005_25_10","NUM","25","10","10","Ba loolu weesoo Aji Sax ji wax Musaa, ne ko: ");
INSERT INTO wolmbs_vpl VALUES ("NU25_11","005_25_11","NUM","25","11","11","«Fineyas, doomu Elasar, doomu sarxalkat bi Aaróona, moo moyale Israayil sama sànj, ndax sama fiiraange gi mu ma fiirlee ci seen biir, ba sànkuma bànni Israayil ci sama biir fiiraange. ");
INSERT INTO wolmbs_vpl VALUES ("NU25_12","005_25_12","NUM","25","12","12","Kon nag nee ko: Maa ngii di ko baaxe sama kóllëreg jàmm, ");
INSERT INTO wolmbs_vpl VALUES ("NU25_13","005_25_13","NUM","25","13","13","mu ñeel ko, mook askan wi koy wuutu, te di kóllëreg carxal gu sax dàkk, ndax moo fiire Yàllaam, ba jot bànni Israayil.» ");
INSERT INTO wolmbs_vpl VALUES ("NU25_14","005_25_14","NUM","25","14","14","Waayi bànni Israayil ja ñu jamoon, te boole kook ndawas Majan sa jam, mooy Simri doomu Salu. Kilifag kër maamam la woon ca Cimyoneen ña. ");
INSERT INTO wolmbs_vpl VALUES ("NU25_15","005_25_15","NUM","25","15","15","Ndawas Majan sa ñu jam di Kosbi. Baayam Cur doonoon kilifag kër maamam ca giirug Majan ga mu bokk. ");
INSERT INTO wolmbs_vpl VALUES ("NU25_16","005_25_16","NUM","25","16","16","Ci kaw loolu Aji Sax ji wax Musaa, ne ko: ");
INSERT INTO wolmbs_vpl VALUES ("NU25_17","005_25_17","NUM","25","17","17","«Noonooleen waa Majan yii, te rey leen, ");
INSERT INTO wolmbs_vpl VALUES ("NU25_18","005_25_18","NUM","25","18","18","ndax ñoom ñoo leen noonoo woon ba ñu leen woree ca mbirum Pewor ma, ak itam ca mbirum ndaw sa Kosbi, seen mbokk may doomu kilifag Majan ja, te ñu jam ko keroog bésu mbas ma sababoo ca mbirum Baal Pewor, tuur ma.» ");
INSERT INTO wolmbs_vpl VALUES ("NU25_19","005_25_19","NUM","25","19","19","Gannaaw ba mbas ma wéyee, ");
INSERT INTO wolmbs_vpl VALUES ("NU26_1","005_26_1","NUM","26","1","1","Aji Sax ji dafa wax Musaa, ak Elasar doomu Aaróona sarxalkat ba, ne leen: ");
INSERT INTO wolmbs_vpl VALUES ("NU26_2","005_26_2","NUM","26","2","2","«Waññleen mbooloom bànni Israayil gépp, ngeen lim turi góor ñépp, na ñu bokke seen këri maam, dale ko ci ñi am ñaar fukki at, jëm kaw, mboolem ñi xare war ci bànni Israayil.» ");
INSERT INTO wolmbs_vpl VALUES ("NU26_3","005_26_3","NUM","26","3","3","Musaa ak Elasar sarxalkat ba wax ak ñoom ca joori Mowab, fa janook Yeriko ca wetu dexu Yurdan; ñu ne leen ");
INSERT INTO wolmbs_vpl VALUES ("NU26_4","005_26_4","NUM","26","4","4","ñi dale ci ñaar fukki at, jëm kaw lees di lim, na ko Aji Sax ji sante Musaa. Lii moo di limeefu nit ña soqikoo ci bànni Israayil, ña génne woon Misra: ");
INSERT INTO wolmbs_vpl VALUES ("NU26_5","005_26_5","NUM","26","5","5","Ruben moo doon taawub Israayil. Ñi askanoo ci Ruben ñoo di Enog mi sos làngu Enogeen ñi, ak ñoom Palu, Palu mi sos làngu Paluween ñi, ");
INSERT INTO wolmbs_vpl VALUES ("NU26_6","005_26_6","NUM","26","6","6","ak ñoom Esron, Esron mi sos làngu Esroneen ñi, ak ñoom ñi bokk ci Karmi mi sos làngu Karmeen ñi. ");
INSERT INTO wolmbs_vpl VALUES ("NU26_7","005_26_7","NUM","26","7","7","Làngi Rubeneen ñaa ngoogu, ña ñu ca lim di ñeent fukki junneek ñett ak juróom ñaari téeméer ak fanweer (43 730). ");
INSERT INTO wolmbs_vpl VALUES ("NU26_8","005_26_8","NUM","26","8","8","Palu moo meññ Elyab, ");
INSERT INTO wolmbs_vpl VALUES ("NU26_9","005_26_9","NUM","26","9","9","Elyab meññ Nemwel ak Datan ak Abiram. Datan ak Abiram ñooñii doonooni njiit ca mbooloo ma, ñoo doon diiŋat Musaa ak Aaróona. Ña nga bokkoon ca gàngooru Kore, ba ñuy diiŋat Aji Sax ji, ");
INSERT INTO wolmbs_vpl VALUES ("NU26_10","005_26_10","NUM","26","10","10","ba suuf sa xar, boole leen ak Kore, wann, keroog ba gàngoor ga sànkoo, te sawara wa lakk ñaari téeméeri nit ak juróom fukk, ñu daldi doon firnde luy artoo. ");
INSERT INTO wolmbs_vpl VALUES ("NU26_11","005_26_11","NUM","26","11","11","Doomi Kore ya nag deewuñu ca. ");
INSERT INTO wolmbs_vpl VALUES ("NU26_12","005_26_12","NUM","26","12","12","Ñi askanoo ci Simeyon, ñook seeni làng ñoo di ñoom ñi bokk ci Nemwel mi sos làngu Nemweleen ñi, ak ñoom ñi bokk ci Yamin mi sos làngu Yamineen ñi, ak ñoom ñi bokk ci Yakin mi sos làngu Yakineen ñi, ");
INSERT INTO wolmbs_vpl VALUES ("NU26_13","005_26_13","NUM","26","13","13","ak ñoom ñi bokk ci Sera mi sos làngu Ceraxeen ñi, ak ñoom ñi bokk ci Sawul mi sos làngu Cawuleen ñi. ");
INSERT INTO wolmbs_vpl VALUES ("NU26_14","005_26_14","NUM","26","14","14","Làngi Cimyoneen ñaa ngoogu, di ñaar fukki junneek ñaar ak ñaari téeméer (22 200). ");
INSERT INTO wolmbs_vpl VALUES ("NU26_15","005_26_15","NUM","26","15","15","Ñi askanoo ci Gàdd, ñook seeni làng ñoo di ñoom ñi bokk ci Cefon mi sos làngu Cefoneen ñi, ak ñoom ñi bokk ci Agi mi sos làngu Ageen ñi, ak ñoom ñi bokk ci Suni mi sos làngu Cuneen ñi, ");
INSERT INTO wolmbs_vpl VALUES ("NU26_16","005_26_16","NUM","26","16","16","ak ñoom ñi bokk ci Osni mi sos làngu Osneen ñi, ak ñoom ñi bokk ci Eri mi sos làngu Ereen ñi, ");
INSERT INTO wolmbs_vpl VALUES ("NU26_17","005_26_17","NUM","26","17","17","ak ñoom ñi bokk ci Arodd mi sos làngu Aroddeen ñi, ak ñoom ñi bokk ci Areli mi sos làngu Areleen ñi. ");
INSERT INTO wolmbs_vpl VALUES ("NU26_18","005_26_18","NUM","26","18","18","Làngi Gàddeen ñaa ngoogu, ña ñu leen limal di ñeent fukki junneek juróomi téeméer (40 500). ");
INSERT INTO wolmbs_vpl VALUES ("NU26_19","005_26_19","NUM","26","19","19","Am na nag doomi Yuda yu ñuy wax Er ak Onan. Waaye Er ak Onan ca réewum Kanaan lañu faatoo. ");
INSERT INTO wolmbs_vpl VALUES ("NU26_20","005_26_20","NUM","26","20","20","Ñi askanoo ci Yuda, ñook seeni làng ñoo di ñoom ñi bokk ci Sela mi sos làngu Celaneen ñi, ak ñoom ñi bokk ci Peres mi sos làngu Pereseen ñi, ak ñoom ñi bokk ci Sera mi sos làngu Ceraxeen ñi. ");
INSERT INTO wolmbs_vpl VALUES ("NU26_21","005_26_21","NUM","26","21","21","Ñi askanoo ci Peres ñoo di ñoom ñi bokk ci Esron mi sos làngu Esroneen ñi, ak ñoom ñi bokk ci Amul mi sos làngu Amuleen ñi. ");
INSERT INTO wolmbs_vpl VALUES ("NU26_22","005_26_22","NUM","26","22","22","Làngi Yudeen ñaa ngoogu, ña ñu leen limal di juróom ñaar fukki junneek juróom benn ak juróomi téeméer (76 500). ");
INSERT INTO wolmbs_vpl VALUES ("NU26_23","005_26_23","NUM","26","23","23","Ñi askanoo ci Isaakar, ñook seeni làng ñoo di Tola mi sos làngu Toleen ñi, ak ñoom ñi bokk ci Puwa mi sos làngu Puween ñi, ");
INSERT INTO wolmbs_vpl VALUES ("NU26_24","005_26_24","NUM","26","24","24","ak ñoom ñi bokk ci Yasub mi sos làngu Yasubeen ñi, ak ñoom ñi bokk ci Simron mi sos làngu Cimroneen ñi. ");
INSERT INTO wolmbs_vpl VALUES ("NU26_25","005_26_25","NUM","26","25","25","Làngi Isaakar a ngoogu. Ña ñu leen limal di juróom benn fukki junneek ñeent ak ñetti téeméer (64 300). ");
INSERT INTO wolmbs_vpl VALUES ("NU26_26","005_26_26","NUM","26","26","26","Ñi askanoo ci Sabulon, ñook seeni làng ñoo di ñoom ñi bokk ci Seredd mi sos làngu Cereddeen ñi, ak ñoom ñi bokk ci Elon mi sos làngu Eloneen ñi, ak ñoom ñi bokk ci Yaxleel, mi sos làngu Yaxleleen ñi. ");
INSERT INTO wolmbs_vpl VALUES ("NU26_27","005_26_27","NUM","26","27","27","Làngi Cabuloneen ñaa ngoogu, ña ñu leen limal di juróom benn fukki junni ak juróomi téeméer (60 500). ");
INSERT INTO wolmbs_vpl VALUES ("NU26_28","005_26_28","NUM","26","28","28","Ñi askanoo ci Yuusufa nag, ñook seeni làng, ñoo soqikoo ci Manase ak Efrayim. ");
INSERT INTO wolmbs_vpl VALUES ("NU26_29","005_26_29","NUM","26","29","29","Ñi soqikoo ci Manase ñoo di ñoom ñi bokk ci Makir mi sos làngu Makireen ñi. Makir moo jur Galàdd. Ci Galàdd la làngu Galàddeen ñi soqikoo. ");
INSERT INTO wolmbs_vpl VALUES ("NU26_30","005_26_30","NUM","26","30","30","Ñii ñoo askanoo ci Galàdd: Yeser mi sos làngu Yesereen ñi, ak ñoom ñi bokk ci Eleg mi sos làngu Elegeen ñi, ");
INSERT INTO wolmbs_vpl VALUES ("NU26_31","005_26_31","NUM","26","31","31","ak Asriyel mi sos làngu Asriyeleen ñi, ak Sikem mi sos làngu Cikemeen ñi, ");
INSERT INTO wolmbs_vpl VALUES ("NU26_32","005_26_32","NUM","26","32","32","ak Semida mi sos làngu Cemideen ñi, ak Efer mi sos làngu Efereen ñi. ");
INSERT INTO wolmbs_vpl VALUES ("NU26_33","005_26_33","NUM","26","33","33","Celofat doomu Efer nag amuloon doom ju góor, xanaa aw jigéen doŋŋ. Doomi Celofat yu jigéen di Maxla ak Nowa ak Ogla ak Milka ak Tirca. ");
INSERT INTO wolmbs_vpl VALUES ("NU26_34","005_26_34","NUM","26","34","34","Làngi Manasee ngoogu, ña ñu leen limal di juróom fukki junneek ñaar ak juróom ñaari téeméer (52 700). ");
INSERT INTO wolmbs_vpl VALUES ("NU26_35","005_26_35","NUM","26","35","35","Ñii nag ñoo askanoo ci Efrayim, ñook seeni làng: ñoom ñi bokk ci Sutelax mi sos làngu Cutelaxeen ñi, ak ñoom ñi bokk ci Beker mi sos làngu Bekereen ñi, ak ñoom ñi bokk ci Taxan mi sos làngu Taxaneen ñi. ");
INSERT INTO wolmbs_vpl VALUES ("NU26_36","005_26_36","NUM","26","36","36","Ñii nag, askanu Sutelax lañu: ñoom ñi bokk ci Eran, ak làngu Eraneen ñi mu sos. ");
INSERT INTO wolmbs_vpl VALUES ("NU26_37","005_26_37","NUM","26","37","37","Làngi Efrayim a ngoogu, ña ñu leen limal di fanweeri junneek ñaar ak juróomi téeméer (32 500). Ñooñoo askanoo ci Yuusufa, ñook seeni làng. ");
INSERT INTO wolmbs_vpl VALUES ("NU26_38","005_26_38","NUM","26","38","38","Ñi askanoo ci Beñamin, ñook seeni làng ñoo di ñoom ñi bokk ci Bela mi sos làngu Beleen ñi, ak ñoom ñi bokk ci Asbel mi sos làngu Asbeleen ñi, ak ñoom ñi bokk ci Axiram mi sos làngu Axirameen ñi, ");
INSERT INTO wolmbs_vpl VALUES ("NU26_39","005_26_39","NUM","26","39","39","ak ñoom ñi bokk ci Sufam mi sos làngu Cufameen ñi, ak ñoom ñi bokk ci Ufam mi sos làngu Ufameen ñi. ");
INSERT INTO wolmbs_vpl VALUES ("NU26_40","005_26_40","NUM","26","40","40","Askanu Bela wi sosoo ci Àrd ak Naaman ñoo di làngu Àrdeen ñi, ak làngu Naameen ñi sëtoo ci Naaman. ");
INSERT INTO wolmbs_vpl VALUES ("NU26_41","005_26_41","NUM","26","41","41","Ñooñoo askanoo ci Beñamin, ñook seeni làng, ña ñu leen limal di ñeent fukki junneek juróom ak juróom benni téeméer (45 600). ");
INSERT INTO wolmbs_vpl VALUES ("NU26_42","005_26_42","NUM","26","42","42","Ñii nag ñoo askanoo ci Dan, ñook seeni làng: ñoom ñi bokk ci Suxam ak làngu Cuxameen ñi. Daneen ñaa ngoogu, na ñu lime seeni làng. ");
INSERT INTO wolmbs_vpl VALUES ("NU26_43","005_26_43","NUM","26","43","43","Mboolem làngi Cuxameen, ña ñu leen limal juróom benn fukki junneek ñeent la, ak ñeenti téeméer (64 400). ");
INSERT INTO wolmbs_vpl VALUES ("NU26_44","005_26_44","NUM","26","44","44","Ñi askanoo ci Aser, ñook seeni làng ñoo di ñoom ñi bokk ci Imna mi sos làngu Imneen ñi, ak ñoom ñi bokk ci Iswi mi sos làngu Isween ñi, ak ñoom ñi bokk ci Berya mi sos làngu Beryeen ñi. ");
INSERT INTO wolmbs_vpl VALUES ("NU26_45","005_26_45","NUM","26","45","45","Waa askanu Berya ñoo di ñoom ñi bokk ci Eber mi sos làngu Ebereen ñi, ak ñoom ñi bokk ci Malkiyel mi sos làngu Malkiyeleen ñi. ");
INSERT INTO wolmbs_vpl VALUES ("NU26_46","005_26_46","NUM","26","46","46","Doomu Aser ju jigéen nag moo di Sera. ");
INSERT INTO wolmbs_vpl VALUES ("NU26_47","005_26_47","NUM","26","47","47","Làngi Asereen ñaa ngoogu, ña ñu leen limal di juróom fukki junneek ñett ak ñeenti téeméer (53 400). ");
INSERT INTO wolmbs_vpl VALUES ("NU26_48","005_26_48","NUM","26","48","48","Ñi askanoo ci Neftali ñook seeni làng ñoo di ñoom ñi bokk ci Yàcceel, mi sos làngu Yàcceleen ñi, ak ñoom ñi bokk ci Gunni mi sos làngu Guneen ñi, ");
INSERT INTO wolmbs_vpl VALUES ("NU26_49","005_26_49","NUM","26","49","49","ak ñoom ñi bokk ci Yeccer mi sos làngu Yecereen ñi, ak ñoom ñi bokk ci Silem mi sos làngu Cilemeen ñi. ");
INSERT INTO wolmbs_vpl VALUES ("NU26_50","005_26_50","NUM","26","50","50","Neftaleen ñaa ngoogu, ñook seeni làng, ña ñu leen limal di ñeent fukki junneek juróom ak ñeenti téeméer (45 400). ");
INSERT INTO wolmbs_vpl VALUES ("NU26_51","005_26_51","NUM","26","51","51","Limeefu bànni Israayil a ngoogu, di juróom benni téeméeri junneek benn ak juróom ñaari téeméer ak fanweer (601 730). ");
INSERT INTO wolmbs_vpl VALUES ("NU26_52","005_26_52","NUM","26","52","52","Aji Sax ji nag wax Musaa, ne ko: ");
INSERT INTO wolmbs_vpl VALUES ("NU26_53","005_26_53","NUM","26","53","53","«Ñii lees di séddale réew mi, te na cér yi dëppook limu nit ñi. ");
INSERT INTO wolmbs_vpl VALUES ("NU26_54","005_26_54","NUM","26","54","54","Làng gu gëna mag, na am cér bu gëna mag, làng gu gëna tuut, am cér bu gëna tuut, làng gu ci nekk, cér bi dëppook ab limam lees koy jox. ");
INSERT INTO wolmbs_vpl VALUES ("NU26_55","005_26_55","NUM","26","55","55","Ab tegoo bant doŋŋ lees di séddalee réew mi, te seen limu giiri maam ya ñu bokk, na dëppook seenub cér. ");
INSERT INTO wolmbs_vpl VALUES ("NU26_56","005_26_56","NUM","26","56","56","Ci kaw tegoo bant lees di dogale céru giir gu ñu bare séq, ak gu ñu néew séq.» ");
INSERT INTO wolmbs_vpl VALUES ("NU26_57","005_26_57","NUM","26","57","57","Ñii nag lañu limal Leween ñi ak seeni làng: ñoom ñi bokk ci Gerson mi sos làngu Gersoneen ñi, ak ñoom ñi bokk ci Keyat mi sos làngu Keyateen ñi, ak ñoom ñi bokk ci Merari mi sos làngu Merareen ñi. ");
INSERT INTO wolmbs_vpl VALUES ("NU26_58","005_26_58","NUM","26","58","58","Ñii itam ci làngi Leween lañu: làngu Libneen ñi, ak làngu Ebroneen ñi, ak làngu Maxleen ñi, ak làngu Museen ñi, ak làngu Koreen ñi. Keyat nag mooy maamu Amram; ");
INSERT INTO wolmbs_vpl VALUES ("NU26_59","005_26_59","NUM","26","59","59","soxnas Amram di Yokebedd doomu Lewi, ja juddoo Misra. Yokebedd am ak Amram Aaróona ak Musaa ak Maryaama, seenub jigéen. ");
INSERT INTO wolmbs_vpl VALUES ("NU26_60","005_26_60","NUM","26","60","60","Aaróona moo jur Nadab ak Abiyu ak Elasar ak Itamar. ");
INSERT INTO wolmbs_vpl VALUES ("NU26_61","005_26_61","NUM","26","61","61","Nadab ak Abiyu ña nga dee keroog ba ñu taalalee Aji Sax ji cuuraay lu warul. ");
INSERT INTO wolmbs_vpl VALUES ("NU26_62","005_26_62","NUM","26","62","62","Ña ñu limal Leween ñi nag ñaar fukki junneek ñett lañu (23 000), di mboolem góor ña am weer, jëm kaw, te limaaleesu leen ak bànni Israayil ga ca des, ndax joxeesu leen ab cér ci biir bànni Israayil. ");
INSERT INTO wolmbs_vpl VALUES ("NU26_63","005_26_63","NUM","26","63","63","Ñooñu lañu lim ci njiital Musaa ak Elasar sarxalkat ba, ba ñu tënkee limeefu bànni Israayil ca joori Mowab, ga janook Yeriko, ca tàkkal dexu Yurdan. ");
INSERT INTO wolmbs_vpl VALUES ("NU26_64","005_26_64","NUM","26","64","64","Ñooñu, kenn desul ca seen biir, te bokkoon ca limeefu bànni Israayil, ba Musaak Aaróona sarxalkat ba njëkkoona tënke ca màndiŋu Sinayi. ");
INSERT INTO wolmbs_vpl VALUES ("NU26_65","005_26_65","NUM","26","65","65","Ndax ci ñoom ñi bokk ci la Aji Sax ji noon dee rekk lañuy def ba jeex ca màndiŋ ma. Kenn desu ca, ku dul Kaleb doomu Yefune, ak Yosuwe doomu Nuun. ");
INSERT INTO wolmbs_vpl VALUES ("NU27_1","005_27_1","NUM","27","1","1","Ci kaw loolu ay doomi Celofat yu jigéen jóg. Seen baay Celofat, Efer ay baayam, Efer, Galàdd ay baayam, Galàdd, Makir ay baayam, Makir, Manaseey baayam mi bokk ci Manaseen ya, Manase, Yuusufaay baayam. Jigéen ñooñu ñoo di Maxla ak Nowa ak Ogla ak Milka ak Tirca. ");
INSERT INTO wolmbs_vpl VALUES ("NU27_2","005_27_2","NUM","27","2","2","Ñoo taxaw fa kanam Musaa, ak Elasar sarxalkat ba, ak njiit ya, ak mbooloo ma mépp, ca bunt xaymab ndaje ma. Ñu ne: ");
INSERT INTO wolmbs_vpl VALUES ("NU27_3","005_27_3","NUM","27","3","3","«Sunu baay daa dee ca màndiŋ ma. Moom nag bokkuloon ca gàngooru Kore, ga daje woon ci kaw Aji Sax ji, waaye bàkkaaru boppam a ko rey. Bàyyiwul nag doom ju góor. ");
INSERT INTO wolmbs_vpl VALUES ("NU27_4","005_27_4","NUM","27","4","4","Waaye lu tax ñu génne sunu turu baay ci làngam gi mu bokk, ndax ñàkk doom ju góor? Joxleen nu sunub cér ci biir wàll wi sunu bokki baay yu góor bokk ak sunu baay kay!» ");
INSERT INTO wolmbs_vpl VALUES ("NU27_5","005_27_5","NUM","27","5","5","Ci kaw loolu Musaa jébbal Aji Sax ji àtteb jigéen ña. ");
INSERT INTO wolmbs_vpl VALUES ("NU27_6","005_27_6","NUM","27","6","6","Aji Sax ji wax Musaa ne ko: ");
INSERT INTO wolmbs_vpl VALUES ("NU27_7","005_27_7","NUM","27","7","7","«Li doomi Celofat yi wax dëgg la. Danga leen di jox kay, ab cér ci biir wàll wi seen baay bokk ak bokkam yu góor. Su ko defee nga féetale leen seen céru suufu baay. ");
INSERT INTO wolmbs_vpl VALUES ("NU27_8","005_27_8","NUM","27","8","8","«Te nga wax bànni Israayil, ne leen: “Bu ku góor deewee te bàyyiwul doom ju góor, doomam ju jigéen ngeen di jox céru suufam. ");
INSERT INTO wolmbs_vpl VALUES ("NU27_9","005_27_9","NUM","27","9","9","Su amul doom ju jigéen nag, góor ñi mu bokkal waajur ngeen di jox céru suufam. ");
INSERT INTO wolmbs_vpl VALUES ("NU27_10","005_27_10","NUM","27","10","10","Su amul góor gu mu bokkal waajur, góor ña baayam bokkal waajur, ñoom ngeen di jox céru suufam. ");
INSERT INTO wolmbs_vpl VALUES ("NU27_11","005_27_11","NUM","27","11","11","Su baayam amul góor gu mu bokkal waajur, mbokkam mu ko gëna jege ci biir làngam, moom ngeen di jox céru suufam. Kookooy donn cér ba. Na loolu di dogalu yoon, ñeel bànni Israayil, noonu ko Aji Sax ji sante Musaa.”» ");
INSERT INTO wolmbs_vpl VALUES ("NU27_12","005_27_12","NUM","27","12","12","Gannaaw loolu Aji Sax ji ne Musaa: «Yéegil ca kaw tundu Abarim wee, nga séentu réew mi ma jox bànni Israayil. ");
INSERT INTO wolmbs_vpl VALUES ("NU27_13","005_27_13","NUM","27","13","13","Boo ko séentoo ba noppi, yaw itam dees na la tërali ca say bokk, ni sa mag Aaróona, ");
INSERT INTO wolmbs_vpl VALUES ("NU27_14","005_27_14","NUM","27","14","14","gannaaw yeena diiŋat sama ndigal ca màndiŋu Ciin, fa mbooloo ma jote woon ak man. Yeena wormaalul sama sellaay ca kanam mbooloo ma, ca ndox ma. Mooy walum Meriba ma woon ca Kades, ca màndiŋu Ciin.» ");
INSERT INTO wolmbs_vpl VALUES ("NU27_15","005_27_15","NUM","27","15","15","Musaa nag wax Aji Sax ji, ne ko: ");
INSERT INTO wolmbs_vpl VALUES ("NU27_16","005_27_16","NUM","27","16","16","«Aji Sax ji, yaw Yàllay bépp boroom bakkan bu bindoo aw suux, ngalla tabbal nit ku jiite mbooloo mi, ");
INSERT INTO wolmbs_vpl VALUES ("NU27_17","005_27_17","NUM","27","17","17","kuy xareji, jiite leen, délsi, jiite leen, di leen yóbbu, di leen delloosi, ba mbooloom Aji Sax ji baña mel ni xar yu amul sàmm.» ");
INSERT INTO wolmbs_vpl VALUES ("NU27_18","005_27_18","NUM","27","18","18","Aji Sax ji ne Musaa: «Jëlal Yosuwe doomu Nuun. Nit la ku fit fees. Nanga ko teg sa loxo, sase ko noonu. ");
INSERT INTO wolmbs_vpl VALUES ("NU27_19","005_27_19","NUM","27","19","19","Taxawal ko fi kanam Elasar sarxalkat bi, ci kanam mbooloo mépp, te nga sas ko ci seen kanam, ");
INSERT INTO wolmbs_vpl VALUES ("NU27_20","005_27_20","NUM","27","20","20","daldi koy sédd lenn ci sa daraja, ngir mbooloom bànni Israayil mépp déggal ko. ");
INSERT INTO wolmbs_vpl VALUES ("NU27_21","005_27_21","NUM","27","21","21","Ca Elasar sarxalkat bi nag la war di dem, ngir mu di ko seetal fi kanam Aji Sax ji, lu Urim, jumtukaayu tegtal bi, feeñal. Ci ndigalal Elasar nag lañuy génne, te ci ndigalam it lañuy dellusee, moom Yosuwe, ak mboolem bànni Israayil giy ànd ak moom, mbooloo mépp.» ");
INSERT INTO wolmbs_vpl VALUES ("NU27_22","005_27_22","NUM","27","22","22","Ba mu ko defee Musaa def, na ko Aji Sax ji sante. Mu ànd ak Yosuwe, taxawal ko fa kanam Elasar sarxalkat bi, ak mbooloo mépp. ");
INSERT INTO wolmbs_vpl VALUES ("NU27_23","005_27_23","NUM","27","23","23","Musaa nag teg Yosuwe ay loxoom, daldi koy sas, na ko Aji Sax ji santaanee, mu jottali. ");
INSERT INTO wolmbs_vpl VALUES ("NU28_1","005_28_1","NUM","28","1","1","Aji Sax ji waxati Musaa, ne ko: ");
INSERT INTO wolmbs_vpl VALUES ("NU28_2","005_28_2","NUM","28","2","2","«Santal bànni Israayil ne leen sama sarax, sama ñam wi jëm ci sama saraxi sawara ngir xetug jàmm, ñeel ma, nañu farlu ci di ma ko indil saa yu àppam jotee. ");
INSERT INTO wolmbs_vpl VALUES ("NU28_3","005_28_3","NUM","28","3","3","Nga waxleen ne leen, lii moo di saraxu sawara bi ñuy indil Aji Sax ji: ay kuuyu menn at yu mucc sikk, ñaar ci bés bi, muy saraxu rendi-dóomal bi war bés bu nekk. ");
INSERT INTO wolmbs_vpl VALUES ("NU28_4","005_28_4","NUM","28","4","4","Menn kuuy mi, ngeen sarxal ko ci suba, ñaareel bi, ngeen sarxal ko diggante ngoon ak jant bu so. ");
INSERT INTO wolmbs_vpl VALUES ("NU28_5","005_28_5","NUM","28","5","5","Benn fukkeelu efab sunguf su mucc ayib, tollu ci ñetti kilo, mooy saraxu pepp bi kuuy mu nekk di àndal, ñu tooyale ko walaatu xiinu diwu segalu oliw, tollu ci liitar. ");
INSERT INTO wolmbs_vpl VALUES ("NU28_6","005_28_6","NUM","28","6","6","Looloo di rendi-dóomal bi war bés bu nekk, na ñu ko dogale woon ca tundu Sinayi, ngir xetug jàmm, muy saraxu sawara, ñeel Aji Sax ji. ");
INSERT INTO wolmbs_vpl VALUES ("NU28_7","005_28_7","NUM","28","7","7","«Saraxu tuuru si mu àndal, walaatu xiin lay doon, tollu ci liitar ngir kuuy mu ci nekk. Ci ëtt bu sell bi lees di sotti biiñ, muy saraxu tuuru bi ñeel Aji Sax ji. ");
INSERT INTO wolmbs_vpl VALUES ("NU28_8","005_28_8","NUM","28","8","8","Meneen kuuy mi, sarxeleen ko diggante ngoon ak jant bu so, mu ànd ak saraxu pepp ak saraxu tuuru niki ci suba, ngeen def ko saraxu sawara ngir xetug jàmm, ñeel Aji Sax ji. ");
INSERT INTO wolmbs_vpl VALUES ("NU28_9","005_28_9","NUM","28","9","9","«Bésub Noflaay nag ñaari kuuyu menn at yu mucc sikk lay doon, ak saraxu pepp, biy ñaari fukkeeli efay sunguf su mucc ayib, di juróom benni kilo, ñu tooyale ko ag diw, te mu ànd ak saraxu tuuru. ");
INSERT INTO wolmbs_vpl VALUES ("NU28_10","005_28_10","NUM","28","10","10","Loolooy saraxu rendi-dóomalu bésub Noflaay, ci bésub Noflaay bu nekk, te bokkewul ak dóomal bi war bés bu nekk, te ànd ak saraxu tuuru. ");
INSERT INTO wolmbs_vpl VALUES ("NU28_11","005_28_11","NUM","28","11","11","«Te itam seen bési Terutel weer, nangeen sarxe ab rendi-dóomal, ñeel Aji Sax ji. Ñaari yëkk yu ndaw, ak menn kuuy mu mag, ak juróom ñaari kuuyu menn at, te lu ci nekk mucc sikk, ");
INSERT INTO wolmbs_vpl VALUES ("NU28_12","005_28_12","NUM","28","12","12","ak ñetti fukkeeli efay sunguf su mucc ayib, di juróom ñeenti kilo, muy saraxu pepp, ñu tooyale ko ag diw, booleek yëkk wu nekk, ak ñaari fukkeeli efay sunguf su mucc ayib, di juróom benni kilo, muy saraxu pepp, ñu tooyale ko ag diw, booleek kuuy mu mag mi, ");
INSERT INTO wolmbs_vpl VALUES ("NU28_13","005_28_13","NUM","28","13","13","ak benn fukkeelu efab sunguf su mucc ayib, di ñetti kilo, muy saraxu pepp, ñu tooyale ko ag diw, booleek mépp kuuyum menn at. Saraxu rendi-dóomal la, ngir xetug jàmm, di saraxu sawara, ñeel Aji Sax ji. ");
INSERT INTO wolmbs_vpl VALUES ("NU28_14","005_28_14","NUM","28","14","14","«Ay saraxi tuuru lay àndal, genn-wàllu xiinu biiñ la, tollu ci ñaari liitar ci yëkk wu nekk, ak benn ñetteelub xiin, tollu ci liitar ak genn-wàll ci kuuy mu mag mi, ak walaatu xiin, tollu ci liitaru biiñ ci mépp kuuyu menn at. Loolooy saraxu rendi-dóomalu weer wi, weer wu ci nekk, ba weeri at mi daj. ");
INSERT INTO wolmbs_vpl VALUES ("NU28_15","005_28_15","NUM","28","15","15","Ak itam bennub sikket, mu ànd ak saraxu tuuru ngir saraxu póotum bàkkaar, ñeel Aji Sax ji ci bésub Terutel weer wi, te bokkewul ak rendi-dóomal bi ñuy sarxe bés bu nekk. ");
INSERT INTO wolmbs_vpl VALUES ("NU28_16","005_28_16","NUM","28","16","16","«Fukki fan ak ñeent ci weer wi njëkk, mooy màggalu bésub Mucc ba, ñeel Aji Sax ji. ");
INSERT INTO wolmbs_vpl VALUES ("NU28_17","005_28_17","NUM","28","17","17","Ëllëg sa, fukki fan ak juróom ci weer woowu, di màggal; diiru juróom ñaari fan, mburu mu amul lawiir lees cay lekk. ");
INSERT INTO wolmbs_vpl VALUES ("NU28_18","005_28_18","NUM","28","18","18","Bés bu jëkk boobu, woote bu sell lees cay amal. Mboolem lees baaxoo liggéey, deesu ko ci liggéey. ");
INSERT INTO wolmbs_vpl VALUES ("NU28_19","005_28_19","NUM","28","19","19","Nangeen ci def saraxu sawara, mu dib rendi-dóomal, ñeel Aji Sax ji: ñaari yëkk yu ndaw, ak menn kuuy mu mag, ak juróom ñaari kuuyu menn at, te ngeen def lépp di lu mucc sikk. ");
INSERT INTO wolmbs_vpl VALUES ("NU28_20","005_28_20","NUM","28","20","20","Yooyii ànd ak saraxu peppam, di sunguf su mucc ayib, su ñu tooyale ag diw, ñetti fukkeeli efay sunguf, di juróom ñeenti kilo, ciw yëkk, ñaari fukkeeli efay sunguf, di juróom benni kilo, cim kuuy mu mag, ");
INSERT INTO wolmbs_vpl VALUES ("NU28_21","005_28_21","NUM","28","21","21","ak benn fukkeelu efab sunguf, di ñetti kilo, ci mii kuuy, benn fukkeelu efa ca mee, ba juróom ñaari kuuy yu ndaw yi daj, ");
INSERT INTO wolmbs_vpl VALUES ("NU28_22","005_28_22","NUM","28","22","22","ak benn sikketu póotum bàkkaar ngir seen njotlaay. ");
INSERT INTO wolmbs_vpl VALUES ("NU28_23","005_28_23","NUM","28","23","23","Te bokkewul ak rendi-dóomalu suba si, rendi-dóomal boobu war bés bu nekk. ");
INSERT INTO wolmbs_vpl VALUES ("NU28_24","005_28_24","NUM","28","24","24","Sarax yu mel noonu ngeen di sarxal ci bés bi, ak seen saraxu tuuru, diiru juróom ñaari fan, muy ñamu saraxu sawara ngir xetug jàmm, ñeel Aji Sax ji. Ci kaw rendi-dóomal bi war bés bu nekk, ci lees koy dolli. ");
INSERT INTO wolmbs_vpl VALUES ("NU28_25","005_28_25","NUM","28","25","25","Bésub juróom ñaareel ba, seen bésub woote bu sell lay doon. Mboolem lees baaxoo liggéey, deesu ko ci liggéey. ");
INSERT INTO wolmbs_vpl VALUES ("NU28_26","005_28_26","NUM","28","26","26","«Bésub ndoortel meññeef ba ngeen di sarxesi saraxu pepp mu bees, ñeel Aji Sax ji, ci seen biir màggalug Ayi bés nag, seen bésub woote bu sell lay doon. Mboolem lees baaxoo liggéey, deesu ko ci liggéey. ");
INSERT INTO wolmbs_vpl VALUES ("NU28_27","005_28_27","NUM","28","27","27","Nangeen ci sarxal ab rendi-dóomal, ngir xetug jàmm, ñeel Aji Sax ji: ñaari yëkk yu ndaw, ak menn kuuy mu mag, ak juróom ñaari kuuyu menn at. ");
INSERT INTO wolmbs_vpl VALUES ("NU28_28","005_28_28","NUM","28","28","28","Saraxu peppam di sunguf su mucc ayib, su ñu tooyale ag diw. Ñetti fukkeeli efay sunguf, di juróom ñeenti kilo ci yëkk wu nekk, ak ñaari fukkeeli efa, di juróom benni kilo ci kuuy mu mag mi, ");
INSERT INTO wolmbs_vpl VALUES ("NU28_29","005_28_29","NUM","28","29","29","ak fukkeelub efa, di ñetti kilo, ci mii kuuy, fukkeelub efa ca mee, ba juróom ñaari kuuy yu ndaw yi daj, ");
INSERT INTO wolmbs_vpl VALUES ("NU28_30","005_28_30","NUM","28","30","30","ak bennub sikket ngir seen njotlaay. ");
INSERT INTO wolmbs_vpl VALUES ("NU28_31","005_28_31","NUM","28","31","31","Sarxeleen loolu, te bumu bokke ak rendi-dóomal bi war bés bu nekk tey ànd ak saraxu pepp. Lu mucc sikk nag ngeen di def sarax yooyii, te ngeen defaale saraxi tuuru yi ci war. ");
INSERT INTO wolmbs_vpl VALUES ("NU29_1","005_29_1","NUM","29","1","1","«Bu loolu weesoo, benn fanu weeru juróom ñaareel, seen bésu woote bu sell lay doon. Mboolem lees baaxoo liggéey, deesu ko ci liggéey. Bés la bu ngeen di yéenee ay liit. ");
INSERT INTO wolmbs_vpl VALUES ("NU29_2","005_29_2","NUM","29","2","2","Sarxalleen ci ab rendi-dóomal ngir xetug jàmm, ñeel Aji Sax ji: wenn yëkk wu ndaw, ak menn kuuy mu mag, ak juróom ñaari kuuyu menn at, te lu ci nekk mucc sikk. ");
INSERT INTO wolmbs_vpl VALUES ("NU29_3","005_29_3","NUM","29","3","3","Saraxu peppam lay àndal, di sunguf su mucc ayib, su ñu tooyale ag diw; ñetti fukkeeli efay sunguf, di juróom ñeenti kilo ci yëkk wi, ñaari fukkeeli efa, di juróom benni kilo ci kuuy mu mag mi, ");
INSERT INTO wolmbs_vpl VALUES ("NU29_4","005_29_4","NUM","29","4","4","ak benn fukkeelu efab sunguf, di ñetti kilo ci mii kuuy, benn fukkeelu efa ca mee, ba juróom ñaari kuuy yu ndaw yi daj, ");
INSERT INTO wolmbs_vpl VALUES ("NU29_5","005_29_5","NUM","29","5","5","ak benn sikketu póotum bàkkaar, ngir seen njotlaay. ");
INSERT INTO wolmbs_vpl VALUES ("NU29_6","005_29_6","NUM","29","6","6","Bokkewul ak rendi-dóomalu Terutel weer wu nekk, biy ànd ak saraxu pepp, bokkewul it ak rendi-dóomal bi war bés bu nekk, teyu ànd ak saraxu pepp, ak seen saraxi tuuru, ni ko yoon tërale. Dees koy def ngir xetug jàmm, muy saraxu sawara, ñeel Aji Sax ji. ");
INSERT INTO wolmbs_vpl VALUES ("NU29_7","005_29_7","NUM","29","7","7","«Fukki fanu juróom ñaareelu weer woowu it, seen bésub woote bu sell lay doon, te ngeen toroxlu ci. Mboolem lees baaxoo liggéey, deesu ko ci liggéey. ");
INSERT INTO wolmbs_vpl VALUES ("NU29_8","005_29_8","NUM","29","8","8","Sarxalleen ci ab rendi-dóomal, ñeel Aji Sax ji, ngir xetug jàmm: wenn yëkk wu ndaw, ak menn kuuy mu mag, ak juróom ñaari kuuyu menn at, te lu mucc sikk ngeen di def lépp. ");
INSERT INTO wolmbs_vpl VALUES ("NU29_9","005_29_9","NUM","29","9","9","Saraxu pepp lay àndal, di sunguf su mucc ayib su ñu tooyale ag diw; ñetti fukkeeli efay sunguf, di juróom ñeenti kilo ci yëkk wi, ñaari fukkeeli efa, di juróom benni kilo ci kuuy mu mag mi, ");
INSERT INTO wolmbs_vpl VALUES ("NU29_10","005_29_10","NUM","29","10","10","ak benn fukkeelu efab sunguf, di ñetti kilo ci mii kuuy, benn fukkeelu efa ca mee, ba juróom ñaari kuuy yu ndaw yi daj, ");
INSERT INTO wolmbs_vpl VALUES ("NU29_11","005_29_11","NUM","29","11","11","ak benn sikketu póotum bàkkaar, te du bokke ak póotum bàkkaaru njotlaay gi, ak saraxu dóomal bi war bés bu nekk, mook saraxu pepp, ak seen saraxi tuuru yi ci war. ");
INSERT INTO wolmbs_vpl VALUES ("NU29_12","005_29_12","NUM","29","12","12","«Fukki fan yaak juróom ci juróom ñaareelu weer woowu itam, seen bésu woote bu sell lay doon. Mboolem lees baaxoo liggéey, deesu ko ci liggéey. Amalleen ci ag màggal, ñeel Aji Sax ji, diiru juróom ñaari fan, doore ko ca bés ba. ");
INSERT INTO wolmbs_vpl VALUES ("NU29_13","005_29_13","NUM","29","13","13","Nangeen ca sarxal ab rendi-dóomal, muy saraxu sawara ngir xetug jàmm, ñeel Aji Sax ji: fukki yëkk yu ndaw ak ñett, ak ñaari kuuy yu mag, ak fukk ak ñeenti kuuyu menn at, te lépp mucc sikk. ");
INSERT INTO wolmbs_vpl VALUES ("NU29_14","005_29_14","NUM","29","14","14","Seen saraxi pepp di sunguf su mucc sikk su ñu tooyale ag diw, ñetti fukkeeli efay sunguf, di juróom ñeenti kilo ci wenn yëkk wu nekk, ba fukki yëkk yeek ñett daj; ñaari kuuy yu mag yi, kuuy mu ci nekk, ñaari fukkeeli efay sunguf, di juróom benni kilo, ");
INSERT INTO wolmbs_vpl VALUES ("NU29_15","005_29_15","NUM","29","15","15","ak benn fukkeelu efab sunguf, di ñetti kilo ci mii kuuy, benn fukkeelu efa ca mee, ba fukki kuuy yu ndaw yeek ñeent daj, ");
INSERT INTO wolmbs_vpl VALUES ("NU29_16","005_29_16","NUM","29","16","16","ak benn sikketu póotum bàkkaar. Bokkewul ak saraxu dóomal bi war bés bu nekk, ak saraxu pepp si muy àndal, ak saraxu tuuru. ");
INSERT INTO wolmbs_vpl VALUES ("NU29_17","005_29_17","NUM","29","17","17","«Bésub ñaareel ba: fukki yëkk yu ndaw ak ñaar; ak ñaari kuuy yu mag, ak fukk ak ñeenti kuuyu menn at, te lépp mucc sikk. ");
INSERT INTO wolmbs_vpl VALUES ("NU29_18","005_29_18","NUM","29","18","18","Te seen saraxi pepp, ak seen saraxi tuuru yay ànd ak yëkk ya, ak kuuy yu mag ya, ak kuuyu menn at ya, na dayo ya dëppoo ak li yoon tëral. ");
INSERT INTO wolmbs_vpl VALUES ("NU29_19","005_29_19","NUM","29","19","19","Dees na ca teg benn sikketu póotum bàkkaar, te du bokke ak saraxu dóomal bi war bés bu nekk, mook saraxu pepp ak saraxi tuuru yi mu àndal. ");
INSERT INTO wolmbs_vpl VALUES ("NU29_20","005_29_20","NUM","29","20","20","«Bésub ñetteel ba: fukki yëkk yu ndaw ak benn, ak ñaari kuuy yu mag, ak fukk ak ñeenti kuuyu menn at, te lépp mucc sikk. ");
INSERT INTO wolmbs_vpl VALUES ("NU29_21","005_29_21","NUM","29","21","21","Te seen saraxi pepp, ak seen saraxi tuuru yay ànd ak yëkk ya, ak kuuy yu mag ya, ak kuuyu menn at ya, na dayo ya dëppoo ak li yoon tëral. ");
INSERT INTO wolmbs_vpl VALUES ("NU29_22","005_29_22","NUM","29","22","22","Dees na ca teg benn sikketu póotum bàkkaar, te du bokke ak saraxu dóomal bi war bés bu nekk, mook saraxu pepp ak saraxu tuuru yi mu àndal. ");
INSERT INTO wolmbs_vpl VALUES ("NU29_23","005_29_23","NUM","29","23","23","«Bésub ñeenteel ba: fukki yëkk, ak ñaari kuuy yu mag, ak fukk ak ñeenti kuuyu menn at, te lépp mucc sikk. ");
INSERT INTO wolmbs_vpl VALUES ("NU29_24","005_29_24","NUM","29","24","24","Te seen saraxi pepp, ak seen saraxi tuuru yay ànd ak yëkk ya, ak kuuy yu mag ya, ak kuuyu menn at ya, na dayo ya dëppoo ak li yoon tëral. ");
INSERT INTO wolmbs_vpl VALUES ("NU29_25","005_29_25","NUM","29","25","25","Dees na ca teg benn sikketu póotum bàkkaar, te du bokke ak saraxu dóomal bi war bés bu nekk, mook saraxu pepp ak saraxu tuuru ya mu àndal. ");
INSERT INTO wolmbs_vpl VALUES ("NU29_26","005_29_26","NUM","29","26","26","«Bésub juróomeel ba: juróom ñeenti yëkk, ak ñaari kuuy yu mag, ak fukk ak ñeenti kuuyu menn at, te lépp mucc sikk. ");
INSERT INTO wolmbs_vpl VALUES ("NU29_27","005_29_27","NUM","29","27","27","Te seen saraxi pepp, ak seen saraxi tuuru yay ànd ak yëkk ya, ak kuuy ya, ak kuuy yu ndaw ya, na dayo ya dëppoo ak li yoon tëral. ");
INSERT INTO wolmbs_vpl VALUES ("NU29_28","005_29_28","NUM","29","28","28","Dees na ca teg benn sikketu póotum bàkkaar, te du bokke ak saraxu dóomal bi war bés bu nekk, mook saraxu pepp ak saraxu tuuru ya mu àndal. ");
INSERT INTO wolmbs_vpl VALUES ("NU29_29","005_29_29","NUM","29","29","29","«Bésub juróom benneel ba: juróom ñetti yëkk, ak ñaari kuuy yu mag, ak fukk ak ñeenti kuuyu menn at, te lépp mucc sikk. ");
INSERT INTO wolmbs_vpl VALUES ("NU29_30","005_29_30","NUM","29","30","30","Te seen saraxi pepp, ak seen saraxi tuuru yay ànd ak yëkk ya, ak kuuy yu mag ya, ak kuuy yu ndaw ya, na dayo ya dëppoo ak li yoon tëral. ");
INSERT INTO wolmbs_vpl VALUES ("NU29_31","005_29_31","NUM","29","31","31","Dees na ca teg benn sikketu póotum bàkkaar, te du bokke ak saraxu dóomal bi war bés bu nekk, mook saraxu pepp ak saraxu tuuru ya mu àndal. ");
INSERT INTO wolmbs_vpl VALUES ("NU29_32","005_29_32","NUM","29","32","32","«Bésub juróom ñaareel ba: juróom ñaari yëkk, ak ñaari kuuy, ak fukk ak ñeenti kuuyu menn at, te lépp mucc sikk. ");
INSERT INTO wolmbs_vpl VALUES ("NU29_33","005_29_33","NUM","29","33","33","Te seen saraxi pepp, ak seen saraxi tuuru yay ànd ak yëkk ya, ak kuuy yu mag ya, ak kuuy yu ndaw ya, na dayo ya dëppoo ak li yoon tëral. ");
INSERT INTO wolmbs_vpl VALUES ("NU29_34","005_29_34","NUM","29","34","34","Dees na ca teg benn sikketu póotum bàkkaar, te du bokke ak saraxu dóomal bi war bés bu nekk, mook saraxu pepp ak saraxu tuuru ya mu àndal. ");
INSERT INTO wolmbs_vpl VALUES ("NU29_35","005_29_35","NUM","29","35","35","«Bésub juróom ñetteel ba seen bésub ndaje lay doon. Mboolem lees baaxoo liggéey, deesu ko ci liggéey. ");
INSERT INTO wolmbs_vpl VALUES ("NU29_36","005_29_36","NUM","29","36","36","Nangeen ci sarxal ab rendi-dóomal, muy saraxu sawara ngir xetug jàmm, ñeel Aji Sax ji: wenn yëkk, ak menn kuuy yu mag, ak juróom ñaari kuuyu menn at, te lépp mucc sikk. ");
INSERT INTO wolmbs_vpl VALUES ("NU29_37","005_29_37","NUM","29","37","37","Te seen saraxi pepp, ak seen saraxi tuuru yay ànd ak yëkk ya, ak kuuy yu mag ya, ak kuuy yu ndaw ya, na dayo ya dëppoo ak li yoon tëral. ");
INSERT INTO wolmbs_vpl VALUES ("NU29_38","005_29_38","NUM","29","38","38","Dees na ca teg benn sikketu póotum bàkkaar, te du bokke ak saraxu dóomal bi war bés bu nekk, mook saraxu pepp ak saraxu tuuru ya mu àndal. ");
INSERT INTO wolmbs_vpl VALUES ("NU29_39","005_29_39","NUM","29","39","39","«Yooyu sarax ngeen di def, ñeel Aji Sax ji, ci seen bési màggal, te du bokke ak seen sarax yi ngeen xasal seen bopp, ak seen saraxi yéene, ak seen saraxi dóomali bés bu nekk, ak seen saraxi pepp ak seen saraxi tuuru, ak seen saraxi canti biir jàmm.» ");
INSERT INTO wolmbs_vpl VALUES ("NU30_1","005_30_1","NUM","30","1","1","Ba mu ko defee Musaa àgge bànni Israayil mboolem la ko Aji Sax ji sant. ");
INSERT INTO wolmbs_vpl VALUES ("NU30_2","005_30_2","NUM","30","2","2","Ci kaw loolu Musaa wax ak kilifay giiri bànni Israayil, ne leen: «Lii moo di ndigal li Aji Sax ji dénkaane: ");
INSERT INTO wolmbs_vpl VALUES ("NU30_3","005_30_3","NUM","30","3","3","«Góor gu xasal Aji Sax ji aw xas, mbaa mu giñ ngir dogu gu mu tegool boppam, bumu tebbi kàddoom. Noonee ko làmmiñam tudde, na ko ni defe ba mu mat sëkk. ");
INSERT INTO wolmbs_vpl VALUES ("NU30_4","005_30_4","NUM","30","4","4","«Te jigéen ju xasal Aji Sax ji aw xas, ngir dogu gu mu dogu, te fekk ko di ndaw ca biir kër baayam ba tey, ");
INSERT INTO wolmbs_vpl VALUES ("NU30_5","005_30_5","NUM","30","5","5","su baay ba déggee xasu ndaw sa, ak dogu ga mu tegool boppam, te waxu ca doomam dara, su boobaa mboolem xasi ndaw sa day sax, te mboolem dogu gu mu doguloon boppam day sax. ");
INSERT INTO wolmbs_vpl VALUES ("NU30_6","005_30_6","NUM","30","6","6","Waaye su ko baayam aayee, ca bés ba mu ca déggee, su boobaa mboolem xasi ndaw si, ak mboolem dogu ya mu doguloon boppam, du sax, te Aji Sax jee koy jéggal, ndax baayam aaye woon na ko. ");
INSERT INTO wolmbs_vpl VALUES ("NU30_7","005_30_7","NUM","30","7","7","«Su fekkee ne ndaw si dafa am jëkkër gannaaw kàdduy xas yu ko topp, mbaa kàddug rëccle gu mu tegool boppam, ");
INSERT INTO wolmbs_vpl VALUES ("NU30_8","005_30_8","NUM","30","8","8","su ko jëkkër ja déggee, te bés ba mu ko déggee, waxu ko ca dara, su boobaa xasi ndaw si day sax, te kàdduy dogu ya mu tegooloon boppam day sax. ");
INSERT INTO wolmbs_vpl VALUES ("NU30_9","005_30_9","NUM","30","9","9","Waaye su fekkee ne ca bés ba ko jëkkër ja déggee, ca la ko aaye, su boobaa jëkkër ja neenal na xas wa toppoon ndaw si, mbaa kàddug rëccle ga mu tegooloon boppam, te Aji Sax jee koy jéggal. ");
INSERT INTO wolmbs_vpl VALUES ("NU30_10","005_30_10","NUM","30","10","10","«Su dee kàddug xas gu jibe ci ku jëkkëram faatu, mbaa ku ñu baal, mboolem lu mu tegooloon boppam day sax. ");
INSERT INTO wolmbs_vpl VALUES ("NU30_11","005_30_11","NUM","30","11","11","«Su fekkee ne ci biir kër jëkkëram la nit ki xase, mbaa mu dogul fa boppam ab dogu, ci kaw ngiñ, ");
INSERT INTO wolmbs_vpl VALUES ("NU30_12","005_30_12","NUM","30","12","12","jëkkër ji dégg ci, te waxu ko dara, aayewu ko, su boobaa mboolem xasi ndaw si day sax, te mboolem dogu bu ndaw si tegooloon boppam, day sax. ");
INSERT INTO wolmbs_vpl VALUES ("NU30_13","005_30_13","NUM","30","13","13","Su wéree nag ne jëkkër ji neenal na kàdduy jabaram yooyu, ca bés ba mu ko déggee, su boobaa lépp lu làmmiñu ndaw si tuddoon, jëme ci kàdduy xasam, mbaa kàddu gu mu tegooloon boppam, lenn du ci sax. Jëkkëram a ko neenal, te Aji Sax jee koy jéggal. ");
INSERT INTO wolmbs_vpl VALUES ("NU30_14","005_30_14","NUM","30","14","14","Mboolem aw xas nag, ak mboolem ngiñ lu ku jigéen ki dogoo, te jublu ci ag toroxlu, jëkkëram moo koy saxal, jëkkëram moo koy neenal. ");
INSERT INTO wolmbs_vpl VALUES ("NU30_15","005_30_15","NUM","30","15","15","Su jëkkër ji noppee ba noppi, waxu ko dara ca bés ba, ba ca ëllëg sa, su boobaa mboolem kàdduy xasi jabaram, mbaa mboolem kàdduy dogu yu toppoon jabaram, jëkkër jee ko saxal, ndax moo ko waxul dara ca bés ba mu ko déggee. ");
INSERT INTO wolmbs_vpl VALUES ("NU30_16","005_30_16","NUM","30","16","16","Ndegam nag jëkkër ji, beneen bés, gannaaw ba mu déggee kàdduy jabaram, la doora àddu ngir neenal wax ja, su boobaa mooy gàddu bàkkaaru jabaram.» ");
INSERT INTO wolmbs_vpl VALUES ("NU30_17","005_30_17","NUM","30","17","17","Yooyu dogali yoon la Aji Sax ji dénk Musaa, ci diggante nit ak jabaram, ak diggante baay ak doom ju jigéen, ba muy ndaw te nekk kër baayam. ");
INSERT INTO wolmbs_vpl VALUES ("NU31_1","005_31_1","NUM","31","1","1","Aji Sax ji waxati Musaa, ne ko: ");
INSERT INTO wolmbs_vpl VALUES ("NU31_2","005_31_2","NUM","31","2","2","«Fexeel ba feyul bànni Israayil ci waa Majan. Gannaaw loolu dees na la yóbbu, tëral la fa say bokk.» ");
INSERT INTO wolmbs_vpl VALUES ("NU31_3","005_31_3","NUM","31","3","3","Musaa daldi wax ak mbooloo ma, ne leen: «Na ñenn ci yeen gànnaayu, waajal xare, te dal ci kaw waa Majan, ba feyul Aji Sax ji. ");
INSERT INTO wolmbs_vpl VALUES ("NU31_4","005_31_4","NUM","31","4","4","Gii giir, junni, gee giir junni, ba giiri Israayil yépp daj, ngeen yebal leen ñu xareji.» ");
INSERT INTO wolmbs_vpl VALUES ("NU31_5","005_31_5","NUM","31","5","5","Ba mu ko defee ñu tànne ca gàngoori Israayil, junniy góor jóge ci giir gu nekk, ñuy fukki junneek ñaari xarekat (12 000) yu gànnaayu. ");
INSERT INTO wolmbs_vpl VALUES ("NU31_6","005_31_6","NUM","31","6","6","Musaa nag yebal leen, junni jóge ci giir gu nekk, ñu xareji. Ñoom ak sarxalkat bi Fineyas doomu Elasar, ñoo xareji, yóbbaale jumtukaay yu sell yaak liiti xare ya. ");
INSERT INTO wolmbs_vpl VALUES ("NU31_7","005_31_7","NUM","31","7","7","Ñu xareek Majan, na ko Aji Sax ji sante Musaa, ba rey góor ñépp, ");
INSERT INTO wolmbs_vpl VALUES ("NU31_8","005_31_8","NUM","31","8","8","reyaale buuri Majan, Ewi ak Rekem ak Cur ak Ur ak Reba, juróomi buuri Majan ya. Balaam doomu Bewor it, ñu reye ko saamar. ");
INSERT INTO wolmbs_vpl VALUES ("NU31_9","005_31_9","NUM","31","9","9","Ba loolu amee bànni Israayil jàpp jigéeni Majan, ak seeni tuut-tànk, ak seen jur gépp, gu gudd ak gu gàtt, seen alal jépp, ñu sëxëtoo ko. ");
INSERT INTO wolmbs_vpl VALUES ("NU31_10","005_31_10","NUM","31","10","10","Seen dëkk yépp ak seeni dëkkuwaay, ak seen dal yépp, ñu lakk. ");
INSERT INTO wolmbs_vpl VALUES ("NU31_11","005_31_11","NUM","31","11","11","Ba mu ko defee ñu jël mboolem la ñu sëxëtoo, mboolem la ñu ca jàppe, nit ñaak jur ga. ");
INSERT INTO wolmbs_vpl VALUES ("NU31_12","005_31_12","NUM","31","12","12","Ñu daldi yóbbu ca Musaa ak Elasar sarxalkat ba, ak mbooloom bànni Israayil, ña ñu jàppe ca xare ba, ak la ñu ca jàppe, ak la ñu sëxëtoo. Ñu indi lépp ca seen dal ba ca joori Mowab, fa janook Yeriko, te dendeek dexu Yurdan. ");
INSERT INTO wolmbs_vpl VALUES ("NU31_13","005_31_13","NUM","31","13","13","Ci kaw loolu Musaa ak Elasar sarxalkat ba ànd ak mboolem njiiti mbooloo ma, ñu génn dal ba, gatandu leen ca biti. ");
INSERT INTO wolmbs_vpl VALUES ("NU31_14","005_31_14","NUM","31","14","14","Musaa nag sànju ca kaw kilifay xare ya, muy kilifay kuréeli junni yaak kilifay kuréeli téeméer ya jóge xare. ");
INSERT INTO wolmbs_vpl VALUES ("NU31_15","005_31_15","NUM","31","15","15","Musaa ne leen: «Kon jigéeni Majan ñépp ngeen bàyyi, ñu dund! ");
INSERT INTO wolmbs_vpl VALUES ("NU31_16","005_31_16","NUM","31","16","16","Xanaa du ñoom ñoo dëdduloo woon bànni Israayil Aji Sax ji, ci ndigalal Balaam, ca mbir ma woon ca Pewor, ba tax mbas ma dikkal mbooloom Aji Sax ji? ");
INSERT INTO wolmbs_vpl VALUES ("NU31_17","005_31_17","NUM","31","17","17","Kon nag reyleen lépp luy góor ci tuut-tànk yi, mboolem lu ciy jigéen ju xam lalu góor it, rey leen, ");
INSERT INTO wolmbs_vpl VALUES ("NU31_18","005_31_18","NUM","31","18","18","mboolem lu ciy jigéen ju ndaw, te xamul lalu góor, ngeen bàyyi mu dund, ñeel leen. ");
INSERT INTO wolmbs_vpl VALUES ("NU31_19","005_31_19","NUM","31","19","19","«Te yeen nag, dalleen ci biti, buleen dugg ci biir dal bi diiru juróom ñaari fan, mboolem ñi rey ak mboolem ñi laal ku ñu rey. Nangeen setlu bésub ñetteel ba, ak bésub juróom ñaareel ba, yeen ak ñi ngeen jàpp. ");
INSERT INTO wolmbs_vpl VALUES ("NU31_20","005_31_20","NUM","31","20","20","Te itam lépp luy yére, ak bépp jumtukaayu der, ak lépp lees defare kawari bëy, ak bépp jumtukaayu bant, nangeen ko setal.» ");
INSERT INTO wolmbs_vpl VALUES ("NU31_21","005_31_21","NUM","31","21","21","Ba mu ko defee Elasar sarxalkat ba wax ak ña xareji woon, ne leen: «Lii moo di dogalu yoon, bi Aji Sax ji dénk Musaa: ");
INSERT INTO wolmbs_vpl VALUES ("NU31_22","005_31_22","NUM","31","22","22","Luy wurus ak xaalis ak xànjar, ak weñ gu ñuul, ak weñ gu weex, ak betteex, ");
INSERT INTO wolmbs_vpl VALUES ("NU31_23","005_31_23","NUM","31","23","23","mboolem lu dul lakk, rekk, nangeen ko laalale sawara, mu set. Ndoxum setlu mi it, warees na koo dellu setale yooyii. Waaye mboolem luy lakk, ci ndoxum setal mi doŋŋ lees koy dugal, ngir mu set. ");
INSERT INTO wolmbs_vpl VALUES ("NU31_24","005_31_24","NUM","31","24","24","Bésub juróom ñaareel ba, fóotleen seeni yére, daldi set. Gannaaw loolu man ngeena duggsi ci dal bi.» ");
INSERT INTO wolmbs_vpl VALUES ("NU31_25","005_31_25","NUM","31","25","25","Aji Sax ji waxati Musaa ne ko: ");
INSERT INTO wolmbs_vpl VALUES ("NU31_26","005_31_26","NUM","31","26","26","«Yaw ak Elasar sarxalkat bi, ak ñi jiite seeni kër maam ci mbooloo mi, waññleen alal ji ñu nangoo xare, nit aku jur. ");
INSERT INTO wolmbs_vpl VALUES ("NU31_27","005_31_27","NUM","31","27","27","Xaajleen sëxëtoo mi ñaar, te ngeen séddale ko diggante xarekat ya xareji woon, ak mbooloo mi ci des yépp. ");
INSERT INTO wolmbs_vpl VALUES ("NU31_28","005_31_28","NUM","31","28","28","Te ngeen sàkkal Aji Sax ji, ci céru xarekat ya xareji woon, ab galag bu yemook benn bopp ci juróomi téeméer (500) yu nekk, ci aw nit, mbaa ay nag, mbaa ay mbaam, mbaa ay gàtt. ");
INSERT INTO wolmbs_vpl VALUES ("NU31_29","005_31_29","NUM","31","29","29","Ci céru xarekat yi ngeen koy sàkke, jox ko Elasar sarxalkat bi, jagleel ko Aji Sax ji. ");
INSERT INTO wolmbs_vpl VALUES ("NU31_30","005_31_30","NUM","31","30","30","Céru bànni Israayil bi ci des, nangeen ci sàkk benn ci juróom fukk yu nekk (50), ci aw nit, mbaa ay nag, mbaa ay mbaam, mbaa ay gàtt, mbaa gépp jur, te ngeen jox ko Leween ñi sàmm ndénkaaneb màkkaanu Aji Sax ji.» ");
INSERT INTO wolmbs_vpl VALUES ("NU31_31","005_31_31","NUM","31","31","31","Ba loolu amee Musaa ak Elasar sarxalkat bi defe ko noonee ko Aji Sax ji sante Musaa. ");
INSERT INTO wolmbs_vpl VALUES ("NU31_32","005_31_32","NUM","31","32","32","La des ca alalu sëxëtoo ja ña xareji woon indaale, gannaaw ba ñu ca génnee yooyu, nii la tollu: gàtt yi, juróom benni téeméeri junneek juróom ñaar fukk ak juróom (675 000); ");
INSERT INTO wolmbs_vpl VALUES ("NU31_33","005_31_33","NUM","31","33","33","nag yi, juróom ñaar fukki junneek ñaar (72 000); ");
INSERT INTO wolmbs_vpl VALUES ("NU31_34","005_31_34","NUM","31","34","34","mbaam yi, juróom benn fukki junneek benn (61 000), ");
INSERT INTO wolmbs_vpl VALUES ("NU31_35","005_31_35","NUM","31","35","35","aw nit, fanweeri junniy jigéen ak ñaar ñu xamul lalu góor (32 000). ");
INSERT INTO wolmbs_vpl VALUES ("NU31_36","005_31_36","NUM","31","36","36","Genn-wàll giy céru nit ña xareji woon, nii la tëdde: gàtt yi, ñetti téeméeri junneek fanweer ak juróom ñaar ak juróomi téeméer (337 500), ");
INSERT INTO wolmbs_vpl VALUES ("NU31_37","005_31_37","NUM","31","37","37","galagu Aji Sax ji génne ci gàtt yi, di juróom benni téeméer ak juróom ñaar fukk ak juróom (675); ");
INSERT INTO wolmbs_vpl VALUES ("NU31_38","005_31_38","NUM","31","38","38","nag yi, fanweeri junneek juróom benn (36 000), galagu Aji Sax ji génne ci, di juróom ñaar fukk ak ñaar (72); ");
INSERT INTO wolmbs_vpl VALUES ("NU31_39","005_31_39","NUM","31","39","39","mbaam yi, fanweeri junneek juróomi téeméer (30 500), galagu Aji Sax ji génne ci, di juróom benn fukk ak benn (61); ");
INSERT INTO wolmbs_vpl VALUES ("NU31_40","005_31_40","NUM","31","40","40","aw nit, fukki junneek juróom benn (16 000), galagu Aji Sax ji génne ci, di fanweeri bopp ak ñaar (32). ");
INSERT INTO wolmbs_vpl VALUES ("NU31_41","005_31_41","NUM","31","41","41","Ba mu ko defee Musaa jox galag ba Elasar sarxalkat ba, jagleel ko Aji Sax ji, na ko Aji Sax ji sante Musaa. ");
INSERT INTO wolmbs_vpl VALUES ("NU31_42","005_31_42","NUM","31","42","42","Genn-wàll giy céru bànni Israayil, ba Musaa teqale ak cérub ña xareji woon, ");
INSERT INTO wolmbs_vpl VALUES ("NU31_43","005_31_43","NUM","31","43","43","te muy céru mbooloo ma, ci wàllu gàtt yi, ñetti téeméeri junneek fanweer ak juróom ñaar ak juróomi téeméer (337 500) la; ");
INSERT INTO wolmbs_vpl VALUES ("NU31_44","005_31_44","NUM","31","44","44","nag yi di fanweeri junneek juróom benn (36 000); ");
INSERT INTO wolmbs_vpl VALUES ("NU31_45","005_31_45","NUM","31","45","45","mbaam yi, fanweeri junneek juróomi téeméer (30 500); ");
INSERT INTO wolmbs_vpl VALUES ("NU31_46","005_31_46","NUM","31","46","46","aw nit, fukki junneek juróom benn (16 000). ");
INSERT INTO wolmbs_vpl VALUES ("NU31_47","005_31_47","NUM","31","47","47","Musaa daldi sàkk ci céru bànni Israayil boobu, benn ci juróom fukk yu nekk. Musaa jox loola Leween ñi sàmm ndénkaaneb màkkaanu Aji Sax ji, noonee ko ko Aji Sax ji sante woon. ");
INSERT INTO wolmbs_vpl VALUES ("NU31_48","005_31_48","NUM","31","48","48","Ba loolu amee njiiti gàngooru xarekat ya, kilifay kuréeli junni yaak kilifay kuréeli téeméer ya, ñoom ñépp dem ca Musaa. ");
INSERT INTO wolmbs_vpl VALUES ("NU31_49","005_31_49","NUM","31","49","49","Ñu ne Musaa: «Sang bi, nun de, waññ nanu xarekat yi ci sunu kilifteef, waaye kenn wuutewu ci. ");
INSERT INTO wolmbs_vpl VALUES ("NU31_50","005_31_50","NUM","31","50","50","Moo tax nu saraxe ngir Aji Sax ji, ku nekk ak la nga muurloo, ci gànjari wurus: lami përëg, ak takkub jara, ak jaaroy torlukaay, ak jaaroy nopp, aki caq. Noo ko def sunu njotlaayal bakkan, fi kanam Aji Sax ji.» ");
INSERT INTO wolmbs_vpl VALUES ("NU31_51","005_31_51","NUM","31","51","51","Musaa ak Elasar sarxalkat ba nangoo wurus wa ca ñoom, lépp di takkaay yu ñu tëgg. ");
INSERT INTO wolmbs_vpl VALUES ("NU31_52","005_31_52","NUM","31","52","52","Mboolem li ñu jébbal Aji Sax ji ci wurus di fukk ak juróom benni junniy siikal ak juróom ñaari téeméer ak juróom fukk (16 750), yemook barigo ak juróom ñeent fukki kilo (190), te bawoo ci kilifay kuréeli junni yaak kilifay kuréeli téeméer ya. ");
INSERT INTO wolmbs_vpl VALUES ("NU31_53","005_31_53","NUM","31","53","53","Xarekati gàngoor ga ñoom, dañoo féetewoo la ñu sëxëtoo. ");
INSERT INTO wolmbs_vpl VALUES ("NU31_54","005_31_54","NUM","31","54","54","Musaa ak Elasar sarxalkat ba nag jële wurus wa ca kilifay kuréeli junni yaak kuréeli téeméer ya. Ñu yóbbu ko ca biir xaymab ndaje ma, muy seedeel bànni Israayil fi kanam Aji Sax ji. ");
INSERT INTO wolmbs_vpl VALUES ("NU32_1","005_32_1","NUM","32","1","1","Jur gu ne gàññ, bare lool, la Rubeneen ñi ak Gàddeen ñi amoon. Ñu xoolaat diiwaanu Yaser ak diiwaanu Galàdd, gisuñu lu moy àll bu neexa yareg jur. ");
INSERT INTO wolmbs_vpl VALUES ("NU32_2","005_32_2","NUM","32","2","2","Ba mu ko defee Gàddeen ñaak Rubeneen ña dikk, wax ak Musaa ak Elasar sarxalkat ba, ak kilifay mbooloo ma. Ñu ne leen: ");
INSERT INTO wolmbs_vpl VALUES ("NU32_3","005_32_3","NUM","32","3","3","«Gox yii di Atarot ak Dibon ak Yaser ak Nimra ak Esbon ak Elale ak Sebam ak Nebo ak Bewon, ");
INSERT INTO wolmbs_vpl VALUES ("NU32_4","005_32_4","NUM","32","4","4","mboolem réew mii Aji Sax ji daan fi kanam mbooloom Israayil de, réew mu neexa yareg jur la, te nun, sang bi, boroomi jur lanu.» ");
INSERT INTO wolmbs_vpl VALUES ("NU32_5","005_32_5","NUM","32","5","5","Ñu teg ca ne: «Kon nag ngalla sang bi, baaxe nu réew mii, muy sunub cér, te nga bañ noo jàlle dexu Yurdan.» ");
INSERT INTO wolmbs_vpl VALUES ("NU32_6","005_32_6","NUM","32","6","6","Musaa ne Gàddeen ñaak Rubeneen ña: «Xanaa seeni bokk duñu xareji, yeen ngeen toog fii? ");
INSERT INTO wolmbs_vpl VALUES ("NU32_7","005_32_7","NUM","32","7","7","Dangeena nara yoqiloo bànni Israayil, ba tere leena jàlli ca réew ma leen Aji Sax ji jox? ");
INSERT INTO wolmbs_vpl VALUES ("NU32_8","005_32_8","NUM","32","8","8","Lu mel nii de, la seeni baay defoon, ba ma leen yebalee, ñu jóge Kades Barneya, ngir yëri réew ma. ");
INSERT INTO wolmbs_vpl VALUES ("NU32_9","005_32_9","NUM","32","9","9","Dañoo dem ba àgg xuru Eskol, ba gis réew ma, doora délsi, di yoqiloo bànni Israayil, ngir ñu baña duggi ca réew ma leen Aji Sax ji joxoon. ");
INSERT INTO wolmbs_vpl VALUES ("NU32_10","005_32_10","NUM","32","10","10","Sànjum Aji Sax ji tàng na bésub keroog, ba mu giñ, ne: ");
INSERT INTO wolmbs_vpl VALUES ("NU32_11","005_32_11","NUM","32","11","11","“Kenn du gis mukk réew ma ma giñaloon Ibraayma ak Isaaxa ak Yanqóoba, ci góor ñi jóge Misra te am ñaar fukki at, jëm kaw, gannaaw mataluñu kóolute ci man; ");
INSERT INTO wolmbs_vpl VALUES ("NU32_12","005_32_12","NUM","32","12","12","xanaa Kaleb doomu Yefune, Keniseen bi, ak Yosuwe doomu Nuun, ndax ñoo matal kóolute ci Aji Sax ji.” ");
INSERT INTO wolmbs_vpl VALUES ("NU32_13","005_32_13","NUM","32","13","13","Ba loolu amee sànjum Aji Sax ji tàkkal Israayil, mu wërloo leen ca màndiŋ ma diiru ñeent fukki at, ba mboolem maas googa defoon lu Aji Sax ji ñaawlu, ñépp jeex tàkk. ");
INSERT INTO wolmbs_vpl VALUES ("NU32_14","005_32_14","NUM","32","14","14","Yeen nag defuleen lu moy jóg wuutu seeni baay, njurum bàkkaarkat yi ngeen doon, di xamb sànjum Aji Sax ji tàkkal bànni Israayil? ");
INSERT INTO wolmbs_vpl VALUES ("NU32_15","005_32_15","NUM","32","15","15","Su ngeen ko dëddoo it, day dellu wacc bànni Israayil ci màndiŋ mi rekk, ngeen daldi sànklu mii mbooloo mépp.» ");
INSERT INTO wolmbs_vpl VALUES ("NU32_16","005_32_16","NUM","32","16","16","Ba loolu weesoo, ñu dikkaat, ne ko: «Ay gétt lanu bëgga sàkk fii ngir sunuy gàtt, aki dëkk ngir sunuy njaboot. ");
INSERT INTO wolmbs_vpl VALUES ("NU32_17","005_32_17","NUM","32","17","17","Waaye nun kay danuy daldi gànnaayu, jiitu bànni Israayil, ba keroog ñu leen yóbboo ca seen suuf. Sunu njaboot a nuy xaare fii, biir dëkk yu tata wër, ngir ñu mucc ci waa réew mi. ");
INSERT INTO wolmbs_vpl VALUES ("NU32_18","005_32_18","NUM","32","18","18","Dunu dellu mukk sunuy kër, ba keroog bànni Israayil di séddu, ku ci nekk jot céru suufam. ");
INSERT INTO wolmbs_vpl VALUES ("NU32_19","005_32_19","NUM","32","19","19","Waaye nun dunu bokk ak ñoom ab céru suuf ca wàllaa dexu Yurdan, ak la ca topp, ndax day fekk nu jot sunu céru suuf, ci wet gii féete dexu Yurdan penku.» ");
INSERT INTO wolmbs_vpl VALUES ("NU32_20","005_32_20","NUM","32","20","20","Musaa ne leen: «Su ngeen ko defee noonu, gànnaayu fi kanam Aji Sax ji ngir xareji, ");
INSERT INTO wolmbs_vpl VALUES ("NU32_21","005_32_21","NUM","32","21","21","su seen mboolem boroomi gànnaay jàllee dexu Yurdan fi kanam Aji Sax ji, ba keroog mu dàqee ay noonam, ");
INSERT INTO wolmbs_vpl VALUES ("NU32_22","005_32_22","NUM","32","22","22","ba réew ma nangul Aji Sax ji, su boobaa déy, sañ ngeena délsi, te wàccoo ngeen ak Aji Sax ji, wàccoo ak bànni Israayil, te su boobaa it réew mii ñeel leen, di seen moomeel fi kanam Aji Sax ji. ");
INSERT INTO wolmbs_vpl VALUES ("NU32_23","005_32_23","NUM","32","23","23","Waaye su ngeen jëfewul noonu kat, yeena moy Aji Sax ji, te xamleen ne seenug moy dina leen dab. ");
INSERT INTO wolmbs_vpl VALUES ("NU32_24","005_32_24","NUM","32","24","24","Kon nag sàkkleen ay dëkk ngir seeni njaboot, aki gétt ngir seeni gàtt, waaye li ngeen dige daal, defleen ko.» ");
INSERT INTO wolmbs_vpl VALUES ("NU32_25","005_32_25","NUM","32","25","25","Ba loolu amee Gàddeen ñaak Rubeneen ña ne Musaa: «Sang bi, noonu nga ko santaanee, ni lanu koy defe. ");
INSERT INTO wolmbs_vpl VALUES ("NU32_26","005_32_26","NUM","32","26","26","Sunuy goneek sunuy jabar, ak sunuy gàtt, ak sunu jur gépp fii ci dëkki Galàdd lay des. ");
INSERT INTO wolmbs_vpl VALUES ("NU32_27","005_32_27","NUM","32","27","27","Waaye nun, mboolem ñi yor ngànnaay danuy jàll dex gi fi kanam Aji Sax ji, ngir xareji ni nga ko waxe, sang bi.» ");
INSERT INTO wolmbs_vpl VALUES ("NU32_28","005_32_28","NUM","32","28","28","Musaa nag santaane ci seen mbir ca Elasar sarxalkat ba, ak Yosuwe doomu Nuun, ak kilifay bànni Israayil, ya jiite seeni kër maam. ");
INSERT INTO wolmbs_vpl VALUES ("NU32_29","005_32_29","NUM","32","29","29","Musaa ne leen: «Su Rubeneen ñeek Gàddeen ñi àndeek yeen, ñoom ñépp gànnaayu ngir xareji fi kanam Aji Sax ji, ba réew ma nangul leen, nangeen leen jox réewum Galàdd, muy seen moomeel. ");
INSERT INTO wolmbs_vpl VALUES ("NU32_30","005_32_30","NUM","32","30","30","Waaye su ñu àndul ak yeen, gànnaayu jàll, ci seen biir lañuy séddu suuf, ca biir réewum Kanaan.» ");
INSERT INTO wolmbs_vpl VALUES ("NU32_31","005_32_31","NUM","32","31","31","Ba loolu amee Gàddeen ña ak Rubeneen ña dellu ne: «Sang bi, li nu Aji Sax ji wax rekk lanuy def. ");
INSERT INTO wolmbs_vpl VALUES ("NU32_32","005_32_32","NUM","32","32","32","Nooy gànnaayu jàlli réewum Kanaan fi kanam Aji Sax ji, waaye nun, cér bi nuy moom, wàllu dexu Yurdan wii lay doon.» ");
INSERT INTO wolmbs_vpl VALUES ("NU32_33","005_32_33","NUM","32","33","33","Musaa nag tudde cér yii, askanu Gàdd ak askanu Ruben ak genn-wàllu giirug Manase doomu Yuusufa: nguurug Sixon buurub Amoreen ñi la leen jox, ak nguurug Og buuru Basan, réew ma mépp, boole ca dëkk yu mag ya, ak àll ya ko wër. ");
INSERT INTO wolmbs_vpl VALUES ("NU32_34","005_32_34","NUM","32","34","34","Ba mu ko defee Gàddeen ña tabaxaat Dibon ak Atarot ak Arower, ");
INSERT INTO wolmbs_vpl VALUES ("NU32_35","005_32_35","NUM","32","35","35","ak Aterot Sofan, ak Yaser ak Yogbowa, ");
INSERT INTO wolmbs_vpl VALUES ("NU32_36","005_32_36","NUM","32","36","36","ak Bet Nimra, ak Bet Aran, lépp di dëkk yu tata wër. Ñu sàkkaale ay wërmbal ngir seeni gàtt. ");
INSERT INTO wolmbs_vpl VALUES ("NU32_37","005_32_37","NUM","32","37","37","Rubeneen ña it tabaxaat Esbon ak Elale ak Kiryaatayim, ");
INSERT INTO wolmbs_vpl VALUES ("NU32_38","005_32_38","NUM","32","38","38","ak Nebo, ak Baal Mewon, lenn ca turi dëkk ya soppiku, ak Sibma. Ñu tudde dëkk yooyu ñu tabaxaat, seen turi bopp. ");
INSERT INTO wolmbs_vpl VALUES ("NU32_39","005_32_39","NUM","32","39","39","Ci kaw loolu ñi askanoo ci Makir doomu Manase, songi bëj-gànnaaru Galàdd, nangu ko, dàqe fa Amoreen ña. ");
INSERT INTO wolmbs_vpl VALUES ("NU32_40","005_32_40","NUM","32","40","40","Ba mu ko defee Musaa jox Galàdd, askanu Makir, ñu dëkke. ");
INSERT INTO wolmbs_vpl VALUES ("NU32_41","005_32_41","NUM","32","41","41","Ci biir loolu askanu Yayir mi askanoo ci Manase, dem nanguji yeneen dëkki Galàdd yu ndaw. Ñu tudde leen Sanci Yayir. ");
INSERT INTO wolmbs_vpl VALUES ("NU32_42","005_32_42","NUM","32","42","42","Noba it nanguji Kenat ak dëkk ya ko wër, daldi tudde gox ba boppam, muy Noba. ");
INSERT INTO wolmbs_vpl VALUES ("NU33_1","005_33_1","NUM","33","1","1","Lii moo di doxi bànni Israayil, ba ñu génnee réewum Misra, def seeni gàngoor, ca njiital Musaa ak Aaróona. ");
INSERT INTO wolmbs_vpl VALUES ("NU33_2","005_33_2","NUM","33","2","2","Musaa moo bind seeni dalukaay ak seen yoon ya ñu jaare, ci ndigalal Aji Sax ji. Lii moo di seeni jaar-jaar, ak seeni dalukaay: ");
INSERT INTO wolmbs_vpl VALUES ("NU33_3","005_33_3","NUM","33","3","3","Fa Ramses lañu bàyyikoo, fukki fan ak juróom ci weer wi njëkk ci at mi. Keroog bés ba topp ca bésub Mucc ba, ca la bànni Israayil daagu, génn, waa Misra gépp di gis. ");
INSERT INTO wolmbs_vpl VALUES ("NU33_4","005_33_4","NUM","33","4","4","Booba waa Misraa ngay rob ña Aji Sax ji rey ca ñoom, néewi mboolem seen taaw ya. Aji Sax jee mbugale noonu seen yàlla ya. ");
INSERT INTO wolmbs_vpl VALUES ("NU33_5","005_33_5","NUM","33","5","5","Bànni Israayil nag jóge Ramses, dali Sukkót. ");
INSERT INTO wolmbs_vpl VALUES ("NU33_6","005_33_6","NUM","33","6","6","Ñu jóge Sukkót, dali Etam ga ca catu màndiŋ ma. ");
INSERT INTO wolmbs_vpl VALUES ("NU33_7","005_33_7","NUM","33","7","7","Ba ñu bàyyikoo Etam, dañoo walbatiku ba Pi Axirot ga janook Baal Cefon, daldi dal fa kanam Migdol. ");
INSERT INTO wolmbs_vpl VALUES ("NU33_8","005_33_8","NUM","33","8","8","Ñu jóge Pi Axirot, jàll géej ga, wuti màndiŋ ma. Dox nañu yoonu ñetti fan ca biir màndiŋu Etam, doora dal Maara. ");
INSERT INTO wolmbs_vpl VALUES ("NU33_9","005_33_9","NUM","33","9","9","Ñu jóge Maara, dem ba Elim, Elim ga ca fukki bëti ndox yaak ñaar, ak juróom ñaar fukki garabi tàndarma ya. Ñu dal foofa. ");
INSERT INTO wolmbs_vpl VALUES ("NU33_10","005_33_10","NUM","33","10","10","Ba ñu jógee Elim, fa feggook géeju Barax ya la ñu dali. ");
INSERT INTO wolmbs_vpl VALUES ("NU33_11","005_33_11","NUM","33","11","11","Ñu bawoo géeju Barax ya, dali ca màndiŋu Sin, ");
INSERT INTO wolmbs_vpl VALUES ("NU33_12","005_33_12","NUM","33","12","12","bawooti màndiŋu Sin, dali Dofka, ");
INSERT INTO wolmbs_vpl VALUES ("NU33_13","005_33_13","NUM","33","13","13","bawooti Dofka, dali Alus. ");
INSERT INTO wolmbs_vpl VALUES ("NU33_14","005_33_14","NUM","33","14","14","Ba ñu bàyyikoo Alus, Refidim lañu dali. Foofa nag mbooloo ma amuñu fa ndox mu ñu naan. ");
INSERT INTO wolmbs_vpl VALUES ("NU33_15","005_33_15","NUM","33","15","15","Ñu bàyyikoo Refidim, dali ca màndiŋu Sinayi, ");
INSERT INTO wolmbs_vpl VALUES ("NU33_16","005_33_16","NUM","33","16","16","bàyyikoo màndiŋu Sinayi, dali Kibbrot Taawa, ");
INSERT INTO wolmbs_vpl VALUES ("NU33_17","005_33_17","NUM","33","17","17","bàyyikooti Kibbrot Taawa, dali Àccerot. ");
INSERT INTO wolmbs_vpl VALUES ("NU33_18","005_33_18","NUM","33","18","18","Ba ñu jógee Àccerot, Ritma lañu dali. ");
INSERT INTO wolmbs_vpl VALUES ("NU33_19","005_33_19","NUM","33","19","19","Ñu jóge Ritma, dali Rimon Perecc, ");
INSERT INTO wolmbs_vpl VALUES ("NU33_20","005_33_20","NUM","33","20","20","jóge Rimon Perecc, dali Libna, ");
INSERT INTO wolmbs_vpl VALUES ("NU33_21","005_33_21","NUM","33","21","21","jógeeti Libna, dali Risa. ");
INSERT INTO wolmbs_vpl VALUES ("NU33_22","005_33_22","NUM","33","22","22","Ba ñu bawoo Risa, Keyelata lañu dali. ");
INSERT INTO wolmbs_vpl VALUES ("NU33_23","005_33_23","NUM","33","23","23","Ñu bawoo Keyelata, dali tundu Sefer, ");
INSERT INTO wolmbs_vpl VALUES ("NU33_24","005_33_24","NUM","33","24","24","bawoo tundu Sefer, dali Arada, ");
INSERT INTO wolmbs_vpl VALUES ("NU33_25","005_33_25","NUM","33","25","25","bawooti Arada, dali Makeyelot. ");
INSERT INTO wolmbs_vpl VALUES ("NU33_26","005_33_26","NUM","33","26","26","Naka lañu bàyyikoo Makeyelot, dali Taxat, ");
INSERT INTO wolmbs_vpl VALUES ("NU33_27","005_33_27","NUM","33","27","27","bàyyikoo Taxat, dali Tera, ");
INSERT INTO wolmbs_vpl VALUES ("NU33_28","005_33_28","NUM","33","28","28","bàyyikooti Tera, dali Mitka. ");
INSERT INTO wolmbs_vpl VALUES ("NU33_29","005_33_29","NUM","33","29","29","Ba ñu jógee Mitka, Asmona lañu dali. ");
INSERT INTO wolmbs_vpl VALUES ("NU33_30","005_33_30","NUM","33","30","30","Ñu jóge Asmona, dali Moserot; ");
INSERT INTO wolmbs_vpl VALUES ("NU33_31","005_33_31","NUM","33","31","31","jóge Moserot, dali Bene Yaakan, ");
INSERT INTO wolmbs_vpl VALUES ("NU33_32","005_33_32","NUM","33","32","32","jógeeti Bene Yaakan, dali Xor Gitgaat. ");
INSERT INTO wolmbs_vpl VALUES ("NU33_33","005_33_33","NUM","33","33","33","Ba ñu bawoo Xor Gitgaat, Yotbata lañu dali. ");
INSERT INTO wolmbs_vpl VALUES ("NU33_34","005_33_34","NUM","33","34","34","Ñu bawoo Yotbata, dali Abrona, ");
INSERT INTO wolmbs_vpl VALUES ("NU33_35","005_33_35","NUM","33","35","35","bawoo Abrona, dali Eccon Geber, ");
INSERT INTO wolmbs_vpl VALUES ("NU33_36","005_33_36","NUM","33","36","36","bawooti Eccon Geber, dali Kades ca màndiŋu Ciin. ");
INSERT INTO wolmbs_vpl VALUES ("NU33_37","005_33_37","NUM","33","37","37","Ba ñu bàyyikoo Kades, ca tundu Or wa digalook réewum Edom lañu dali. ");
INSERT INTO wolmbs_vpl VALUES ("NU33_38","005_33_38","NUM","33","38","38","Ba mu ko defee Aaróona sarxalkat ba yéeg ca kaw tundu Or, ci ndigalal Aji Sax ji. Mu daldi faatu foofa, ca ñeent fukkeelu at ma, gannaaw ba bànni Israayil génnee réewum Misra, yemook benn fanu juróomeelu weeru at ma. ");
INSERT INTO wolmbs_vpl VALUES ("NU33_39","005_33_39","NUM","33","39","39","Aaróona mu ngi woon ci téeméeri atam, ak ñaar fukk at ñett (123) ba mu faatoo ca kaw tundu Or. ");
INSERT INTO wolmbs_vpl VALUES ("NU33_40","005_33_40","NUM","33","40","40","Ci kaw loolu Kanaaneen ba, buurub Aràdd, ba dëkke woon bëj-saalumu réewum Kanaan, daldi yég ne bànni Israayil a ngay dikk. ");
INSERT INTO wolmbs_vpl VALUES ("NU33_41","005_33_41","NUM","33","41","41","Ba ñu jógee tundu Or, Calmona lañu dali. ");
INSERT INTO wolmbs_vpl VALUES ("NU33_42","005_33_42","NUM","33","42","42","Ñu jóge Calmona, dali Punon, ");
INSERT INTO wolmbs_vpl VALUES ("NU33_43","005_33_43","NUM","33","43","43","jóge Punon, dali Obot, ");
INSERT INTO wolmbs_vpl VALUES ("NU33_44","005_33_44","NUM","33","44","44","jógeeti Obot, dali Yee Abarim, ga digalook réewum Mowab. ");
INSERT INTO wolmbs_vpl VALUES ("NU33_45","005_33_45","NUM","33","45","45","Ba ñu jógee Yee Abarim, Dibon Gàdd lañu dali. ");
INSERT INTO wolmbs_vpl VALUES ("NU33_46","005_33_46","NUM","33","46","46","Ñu jóge Dibon Gàdd, dali Almon Diblatayim, ");
INSERT INTO wolmbs_vpl VALUES ("NU33_47","005_33_47","NUM","33","47","47","jógeeti Almon Diblatayim, dali ca tundi Abarim, janook tundu Nebo. ");
INSERT INTO wolmbs_vpl VALUES ("NU33_48","005_33_48","NUM","33","48","48","Ba ñu bawoo tundi Abarim, ca joori Mowab lañu dali, ca wetu dexu Yurdan, janook Yeriko. ");
INSERT INTO wolmbs_vpl VALUES ("NU33_49","005_33_49","NUM","33","49","49","Wetu dexu Yurdan, ga ca diggante Bet Yesimot ak Abel Sitim, ca joori Mowab, fa lañu dale. ");
INSERT INTO wolmbs_vpl VALUES ("NU33_50","005_33_50","NUM","33","50","50","Ba loolu amee Aji Sax ji waxati ak Musaa ca joori Mowab, ca wetu dexu Yurdan, ga janook Yeriko. Mu ne ko: ");
INSERT INTO wolmbs_vpl VALUES ("NU33_51","005_33_51","NUM","33","51","51","«Waxal bànni Israayil ne leen: Bu ngeen jàllee dexu Yurdan, ba dugg réewum Kanaan, ");
INSERT INTO wolmbs_vpl VALUES ("NU33_52","005_33_52","NUM","33","52","52","nangeen dàq waa réew mépp, nangeen yàqate seen mboolem tuur yu ñu yatt, te seen mboolem jëmm yu ñu móol, yàqateleen ko, seen mboolem bérebi jaamookaay it, tasleen ko. ");
INSERT INTO wolmbs_vpl VALUES ("NU33_53","005_33_53","NUM","33","53","53","Defleen réew mi moomeel, ngeen dëkke ko, ndax yeen laa jox réew mi, ngir ngeen moom ko. ");
INSERT INTO wolmbs_vpl VALUES ("NU33_54","005_33_54","NUM","33","54","54","Tegooleen bant réew mi, séddoo ko ci seeni làng. Làng gu gëna mag, na am cér bu gëna mag, làng gu gëna tuut, am cér bu gëna tuut. Fépp fu tegoo bant génneel ag làng, ñooy doon boroom. Ci seen biir giiri maam ngeen di séddu. ");
INSERT INTO wolmbs_vpl VALUES ("NU33_55","005_33_55","NUM","33","55","55","Waaye su ngeen dàqul waa réew mi, ña ngeen fa bàyyi ñooy mujj diy dég yu leen di luqi, aki dagg yuy cuut seeni wet. Ñoo leen di lëjal witt ca biir réew mooma ngeen sance. ");
INSERT INTO wolmbs_vpl VALUES ("NU33_56","005_33_56","NUM","33","56","56","Su boobaa nag na ma naroona def seen noon yooyu, yeen laa koy def.» ");
INSERT INTO wolmbs_vpl VALUES ("NU34_1","005_34_1","NUM","34","1","1","Aji Sax ji waxati Musaa, ne ko: ");
INSERT INTO wolmbs_vpl VALUES ("NU34_2","005_34_2","NUM","34","2","2","«Santal bànni Israayil, nga ne leen: Bu ngeen duggee réewum Kanaan, lii moo di réew ma ngeen di muurloo, muy seenub cér. Réewum Kanaan a ngi, ak fa suufam yem: ");
INSERT INTO wolmbs_vpl VALUES ("NU34_3","005_34_3","NUM","34","3","3","«Yeen, seen kemu bëj-saalum a ngay dale màndiŋu Ciin, leru réewum Edom, daleeti ca catal géeju Xorom ga ca penku. ");
INSERT INTO wolmbs_vpl VALUES ("NU34_4","005_34_4","NUM","34","4","4","Seen kem daa dënglu, jaare fa féete yéegub Akerabim bëj-saalum, jaare Ciin nag, dem ba bëj-saalumu Kades Barneya, jëm Àccar Adar ba àgg Asmon. ");
INSERT INTO wolmbs_vpl VALUES ("NU34_5","005_34_5","NUM","34","5","5","Asmon la kem gay jàddaate jubal xuru Misra, doora àkki géej. ");
INSERT INTO wolmbs_vpl VALUES ("NU34_6","005_34_6","NUM","34","6","6","«Géej gu mag gi mooy doon seen kemu sowu. Loolooy seen kemu sowu. ");
INSERT INTO wolmbs_vpl VALUES ("NU34_7","005_34_7","NUM","34","7","7","«Lii nag mooy seen kemu bëj-gànnaar. Ca géej gu mag ga ngeen di rëdde, ba ca tundu Or, ");
INSERT INTO wolmbs_vpl VALUES ("NU34_8","005_34_8","NUM","34","8","8","rëdde ko fa tundu Or, mu jëm Buntu Amat, jàll ba Cedàdd, ");
INSERT INTO wolmbs_vpl VALUES ("NU34_9","005_34_9","NUM","34","9","9","wéyeeti fa, jaare Sifron, jëm Àccar Enan. Loolooy seen kemu bëj-gànnaar. ");
INSERT INTO wolmbs_vpl VALUES ("NU34_10","005_34_10","NUM","34","10","10","«Rëddleen seen kemu penku, mu dale Àccar Enan ba Sefam, ");
INSERT INTO wolmbs_vpl VALUES ("NU34_11","005_34_11","NUM","34","11","11","kemu ga wàcce Sefam, jëm Ribla, fa féete Ayin penku, wàccati ba leruji dexu Kineret, ca wet ga ko féete penku, ");
INSERT INTO wolmbs_vpl VALUES ("NU34_12","005_34_12","NUM","34","12","12","kemu ga dellu wàcc ba ca dexu Yurdan, doora àkki géeju Xorom ga. Loolooy doon seenum réew ak kemoom yi ko wër.» ");
INSERT INTO wolmbs_vpl VALUES ("NU34_13","005_34_13","NUM","34","13","13","Ba mu ko defee Musaa sant bànni Israayil, ne leen: «Réew moomu ngeen di tegoo bant, séddoo ko, te moom la Aji Sax ji santaane ñu jox ko juróom ñeenti giir yeek genn-wàll, ");
INSERT INTO wolmbs_vpl VALUES ("NU34_14","005_34_14","NUM","34","14","14","gannaaw giirug Ruben ak seeni kër maam, ak giiru Gàdd ak seeni kër maam séddu nañu, te genn-wàllu giirug Manase itam jot nañu seen cér ba noppi. ");
INSERT INTO wolmbs_vpl VALUES ("NU34_15","005_34_15","NUM","34","15","15","Ñaari giir ya ak genn-wàllu giir googu ñoo séddu suuf ca penkub dexu Yurdan, fa janook Yeriko.» ");
INSERT INTO wolmbs_vpl VALUES ("NU34_16","005_34_16","NUM","34","16","16","Aji Sax ji waxati Musaa, ne ko: ");
INSERT INTO wolmbs_vpl VALUES ("NU34_17","005_34_17","NUM","34","17","17","«Ñii nag ñoo leen di séddale réew mi: Elasar sarxalkat bi, ak Yosuwe doomu Nuun. ");
INSERT INTO wolmbs_vpl VALUES ("NU34_18","005_34_18","NUM","34","18","18","Ay njiit ngay jële kenn-kenn, ci giir gu nekk, ngir ñu jàpp ci séddaleb réew mi. ");
INSERT INTO wolmbs_vpl VALUES ("NU34_19","005_34_19","NUM","34","19","19","Ñooñoo di: ci wàllu giirug Yuda, Kaleb doomu Yefune; ");
INSERT INTO wolmbs_vpl VALUES ("NU34_20","005_34_20","NUM","34","20","20","wàllu giirug Cimyoneen ñi, Samiyel doomu Amiyudd; ");
INSERT INTO wolmbs_vpl VALUES ("NU34_21","005_34_21","NUM","34","21","21","wàllu giirug Beñamin, Elidat doomu Kislon; ");
INSERT INTO wolmbs_vpl VALUES ("NU34_22","005_34_22","NUM","34","22","22","wàllu giirug Daneen ñi, lenn njiit, di Bukki doomu Yogli; ");
INSERT INTO wolmbs_vpl VALUES ("NU34_23","005_34_23","NUM","34","23","23","wàllu Yuusufeen ñi, li féete ak giirug Manaseen ñi, lenn njiit, di Aniyel doomu Efot, ");
INSERT INTO wolmbs_vpl VALUES ("NU34_24","005_34_24","NUM","34","24","24","li féete ak giirug Efraymeen ñi, lenn njiit, di Kemwel doomu Siftan; ");
INSERT INTO wolmbs_vpl VALUES ("NU34_25","005_34_25","NUM","34","25","25","ci wàllu giirug Cabuloneen ñi, lenn njiit, di Elicafan doomu Parnag; ");
INSERT INTO wolmbs_vpl VALUES ("NU34_26","005_34_26","NUM","34","26","26","wàllu giirug Isakareen ñi, lenn njiit, di Paltiyel doomu Asan; ");
INSERT INTO wolmbs_vpl VALUES ("NU34_27","005_34_27","NUM","34","27","27","wàllu giirug Asereen ñi, lenn njiit, di Axiyudd doomu Selomi; ");
INSERT INTO wolmbs_vpl VALUES ("NU34_28","005_34_28","NUM","34","28","28","wàllu giirug Neftaleen ñi, lenn njiit, di Pedayel doomu Amiyudd.» ");
INSERT INTO wolmbs_vpl VALUES ("NU34_29","005_34_29","NUM","34","29","29","Ñooñu la Aji Sax ji sant ñu séddale bànni Israayil, réewum Kanaan. ");
INSERT INTO wolmbs_vpl VALUES ("NU35_1","005_35_1","NUM","35","1","1","Aji Sax ji waxati ak Musaa ca joori Mowab, ca wetu dexu Yurdan, fa jàkkaarlook Yeriko. Mu ne ko: ");
INSERT INTO wolmbs_vpl VALUES ("NU35_2","005_35_2","NUM","35","2","2","«Santal bànni Israayil ñu sàkkal Leween ñi ci seen céru suuf, ay dëkk yu Leween ñi dëkke. Àllu parlu ya wër dëkk ya it, joxleen ko Leween ñi. ");
INSERT INTO wolmbs_vpl VALUES ("NU35_3","005_35_3","NUM","35","3","3","Su ko defee dëkk yooyu ñeel leen, ñu dëkke. Seen àlli parlu it ñeel seenug jur, ak seen alal, ak seen mboolem mala. ");
INSERT INTO wolmbs_vpl VALUES ("NU35_4","005_35_4","NUM","35","4","4","Parluy dëkk yi ngeen di jox Leween ñi, ci tatay dëkk ya lay dale, jëm ci biti lu day ni junniy xasab, yemook juróomi téeméeri meetar, ci wet gu nekk. ");
INSERT INTO wolmbs_vpl VALUES ("NU35_5","005_35_5","NUM","35","5","5","Su ko defee ngeen natte ca biti dig-digal bu gudde ñaari junniy xasab, yemook junniy meetar ci wetu penku; ñaari junniy xasab, yemook junniy meetar, wetu bëj-saalum; ñaari junniy xasab, yemook junniy meetar, wetu sowu; ñaari junniy xasab, yemook junniy meetar, wetu bëj-gànnaar, dëkk bi nekk ci digg bi. Dig-digal boobu day ñeel Leween ñi, di seen parluy dëkk. ");
INSERT INTO wolmbs_vpl VALUES ("NU35_6","005_35_6","NUM","35","6","6","Dëkk yi ngeen di jox Leween ñi, ñoo di juróom benni dëkki rawtu yi nga xam ne ku rey nit man faa raweji, ak yeneen ñeent fukki dëkk ak ñaar yu ngeen leen ciy dollil. ");
INSERT INTO wolmbs_vpl VALUES ("NU35_7","005_35_7","NUM","35","7","7","Kon mboolem dëkk yi ngeen di jox Leween ñi, ñeent fukk ak juróom ñett la, ak seen àlli parlu. ");
INSERT INTO wolmbs_vpl VALUES ("NU35_8","005_35_8","NUM","35","8","8","Dëkk yi ngeen leen di génneel ci céri suufi bànni Israayil nag, la cay génne ca ña ëpple suuf, réyal leen ko, te la cay génne ca ña néewle suuf, ngeen néewal ko. Giir gu nekk daal, dayob céru suufam si mu séddu, moom lay topp, ngir sàkke ci ay dëkkam, jox Leween ñi.» ");
INSERT INTO wolmbs_vpl VALUES ("NU35_9","005_35_9","NUM","35","9","9","Aji Sax ji waxati Musaa, ne ko: ");
INSERT INTO wolmbs_vpl VALUES ("NU35_10","005_35_10","NUM","35","10","10","«Waxal bànni Israayil, ne leen: Bu ngeen jàllee dexu Yurdan ba dugg réewum Kanaan, ");
INSERT INTO wolmbs_vpl VALUES ("NU35_11","005_35_11","NUM","35","11","11","nangeen sàkk ay dëkk yuy doon seen dëkki rawtu, ba ku rey nit te du teyeefam, man faa raweji. ");
INSERT INTO wolmbs_vpl VALUES ("NU35_12","005_35_12","NUM","35","12","12","Mooy doon seen dëkki rawtu yees di mucce ci mbokkum jotkat buy toppe, ba ki rey nit du dee, te taxawagul fa kanam mbooloo mi, ngir ñu àtte ko. ");
INSERT INTO wolmbs_vpl VALUES ("NU35_13","005_35_13","NUM","35","13","13","«Kon dëkk yi ngeen di jox Leween ñi, juróom benn a ciy doon seen dëkki rawtu. ");
INSERT INTO wolmbs_vpl VALUES ("NU35_14","005_35_14","NUM","35","14","14","Ñetti dëkk yu ngeen di joxe ci wàllu dexu Yurdan wii, ak ñetti dëkk yu ngeen di joxe ca réewum Kanaan, lépp di ay dëkki rawtu. ");
INSERT INTO wolmbs_vpl VALUES ("NU35_15","005_35_15","NUM","35","15","15","Waaye muy bànni Israayil, muy doxandéem, muy gan gu nekk ci seen biir, na juróom benni dëkk yooyu doon seen rawtu yeen ñépp, ba képp ku rey nit te du teyeefam, man faa raweji. ");
INSERT INTO wolmbs_vpl VALUES ("NU35_16","005_35_16","NUM","35","16","16","«Su dee ag weñ la ko dóor, mu dee, moo ko rey, te dee rekk mooy àtteb ki rey. ");
INSERT INTO wolmbs_vpl VALUES ("NU35_17","005_35_17","NUM","35","17","17","Su dee aw doj wu mana rey la jël, dóor ko ko, mu dee, moo ko rey, te dee rekk mooy àtteb ki rey. ");
INSERT INTO wolmbs_vpl VALUES ("NU35_18","005_35_18","NUM","35","18","18","Su dee bant bu mana rey la jël, dóor ko ko, mu dee it, moo ko rey, te dee rekk mooy àtteb ki rey. ");
INSERT INTO wolmbs_vpl VALUES ("NU35_19","005_35_19","NUM","35","19","19","Jotkat biy toppe bakkan ba nag, mooy rey ka rey; fu mu dajeek moom, moo koy rey. ");
INSERT INTO wolmbs_vpl VALUES ("NU35_20","005_35_20","NUM","35","20","20","Su dee ci biir mbañeel la dale ci kawam, mbaa mu sànni ko aw saan wu mu ko waajal, ba mu dee, ");
INSERT INTO wolmbs_vpl VALUES ("NU35_21","005_35_21","NUM","35","21","21","mbaa ci biir mbañeel la ko dóore loxoom ba mu dee, su boobaa dee rekk mooy àtteb ka dóore. Moo ko bóom. Jotkat bay toppe bakkan ba nag, bu dajeek ka rey, da koy rey. ");
INSERT INTO wolmbs_vpl VALUES ("NU35_22","005_35_22","NUM","35","22","22","«Ndegam nag du caageenu mbañeel, xanaa mu jekki dal ci kawam, mbaa mu sànni ko këf ku mu mana doon, te du lu mu waajoon, ");
INSERT INTO wolmbs_vpl VALUES ("NU35_23","005_35_23","NUM","35","23","23","mbaa muy doj wu mana rey wu mu waddal ci kaw nit ki, ba nit ki dee, te gisul woon nit ki, te nit ka du woon ab noonam, te fekkul itam muy sàkku loraangey nit ka, ");
INSERT INTO wolmbs_vpl VALUES ("NU35_24","005_35_24","NUM","35","24","24","su boobaa la mbooloo may wéyal diggante ki rey, ak jotkat bay toppe, moo di àtte yii ci yoon tëral: ");
INSERT INTO wolmbs_vpl VALUES ("NU35_25","005_35_25","NUM","35","25","25","Mbooloo mi day musal ki rey ci loxol jotkatu bakkanu ka dee, te mbooloo ma da koy delloo ca dëkkub rawtoom ba mu làquji woon. Fa lay toog, ba kera deewug sarxalkat bu mag ba ñu baaxoo fale diw gu sell. ");
INSERT INTO wolmbs_vpl VALUES ("NU35_26","005_35_26","NUM","35","26","26","Ndegam nag ka rey moo génn a génn, ba wees kemu dëkkub rawtoom ba mu làquji woon, ");
INSERT INTO wolmbs_vpl VALUES ("NU35_27","005_35_27","NUM","35","27","27","ba jotkat bay toppe bakkan fekk ko fu wees kemu dëkkub rawtoom, su boobaa su ko jotkatu bakkan ba reyee, du tax mu gàddu bakkan. ");
INSERT INTO wolmbs_vpl VALUES ("NU35_28","005_35_28","NUM","35","28","28","Ndax kat ci biir dëkkub rawtoom la wara toog, ba kera deewug sarxalkat bu mag bi. Gannaaw bu sarxalkat bu mag bi deewee nag, ki rey sañ naa dellu fa mu bokk. ");
INSERT INTO wolmbs_vpl VALUES ("NU35_29","005_35_29","NUM","35","29","29","«Loolu mooy dogalu yoon bi leen ñeel, yeen ak seen askan, ci seen mboolemi dëkkuwaay. ");
INSERT INTO wolmbs_vpl VALUES ("NU35_30","005_35_30","NUM","35","30","30","«Képp ku faat bakkan nag, ci kaw kàddu gu tukkee ci ay seede doŋŋ lees ko saña reye, moom ma rey, waaye bennub seede du seedeel nit, ngir ñu teg ko àtteb dee. ");
INSERT INTO wolmbs_vpl VALUES ("NU35_31","005_35_31","NUM","35","31","31","«Te it buleen jël benn xaalisu njotug bakkanu kenn ku rey nit ku yelloo dee. Kooku dee rekk mooy àtteem. ");
INSERT INTO wolmbs_vpl VALUES ("NU35_32","005_35_32","NUM","35","32","32","Buleen jël it xaalisu njotug nit ku làquji ca dëkkub rawtoom, ngir may ko mu dellu fa mu dëkk, te sarxalkat bu mag bi deewul. ");
INSERT INTO wolmbs_vpl VALUES ("NU35_33","005_35_33","NUM","35","33","33","Buleen tilimal réew mi ngeen nekk. Deret kat mooy tilimal réew mi, te réew mi deesu ko jote lenn, ci deret ju ñu tuur ci biiram, lu moy deretu ka tuur deret. ");
INSERT INTO wolmbs_vpl VALUES ("NU35_34","005_35_34","NUM","35","34","34","Buleen sobeel réew mi ngeen dëkk, te man ma màkkaanoo ci biiram, ndax man Aji Sax ji maa màkkaanoo ci biir bànni Israayil.» ");
INSERT INTO wolmbs_vpl VALUES ("NU36_1","005_36_1","NUM","36","1","1","Ba loolu wéyee kilifay njaboot yi askanoo ci Yuusufa, te bokk ci làngu Galàdd doomu Makir mi sëtoo ci Manase, ñoo dikk. Ñu wax fa kanam Musaa, ak kilifay njabooti bànni Israayil. ");
INSERT INTO wolmbs_vpl VALUES ("NU36_2","005_36_2","NUM","36","2","2","Ñu ne: «Sang bi, xam nga Aji Sax ji moo digle woon ñu tegal bant bànni Israayil, séddale leen réew mi. Ci biir loolu, sang bi, ndigal ñeel la, tukkee ci Aji Sax ji, ngir nga jël sunu céru doomu baay Celofat, jox ko ay doomam yu jigéen. ");
INSERT INTO wolmbs_vpl VALUES ("NU36_3","005_36_3","NUM","36","3","3","Waaye bu ñu séyee ci yeneen giiri bànni Israayil de, seen céru suuf mooy wàññikoo ci sunu céru maam, dolliku ca céru giir ga ñu séyi ca seen biir, te kon cér ba nu tegoo woon bant moo cay wàññikoo. ");
INSERT INTO wolmbs_vpl VALUES ("NU36_4","005_36_4","NUM","36","4","4","Te it bu atum Yiwiku mu bànni Israayil agsee, seen cér day dolliku ca céru giir ga ñu séyi ca seen biir. Te kon it ci sunu céru giiru maam, la seen cér boobu di wàññikoo.» ");
INSERT INTO wolmbs_vpl VALUES ("NU36_5","005_36_5","NUM","36","5","5","Ba loolu wéyee, Musaa jox bànni Israayil ndigal, ci ndigalal Aji Sax ji, ne: «Dëgg la giirug Yuusufeen ñi wax. ");
INSERT INTO wolmbs_vpl VALUES ("NU36_6","005_36_6","NUM","36","6","6","Kàddu gii nag mooy li Aji Sax ji santaane ci doomi Celofat yu jigéen yooyu: Ku leen neex, nañu séy ak moom, na fekk rekk, ka ñuy séyal askanoo ci làng gu bokk ci seen giirug baay. ");
INSERT INTO wolmbs_vpl VALUES ("NU36_7","005_36_7","NUM","36","7","7","Du benn céru suuf ci biir bànni Israayil, buy jóge ci genn giir, toxu ca geneen, waaye na ku nekk ci bànni Israayil yem kepp ca suufas giiram, ga mu donne cay maamam. ");
INSERT INTO wolmbs_vpl VALUES ("NU36_8","005_36_8","NUM","36","8","8","Mboolem ku jigéen ku donn suuf ci giiri bànni Israayil, ci biir làng gu bokk ci giirug maamam rekk lay séy, ngir ku nekk ci bànni Israayil mana ñoŋal céru maamam. ");
INSERT INTO wolmbs_vpl VALUES ("NU36_9","005_36_9","NUM","36","9","9","Su ko defee du benn céru suuf buy jóge ci genn giir, toxu ca geneen, waaye giirug bànni Israayil gu ci nekk day yem kepp ca céru suufam.» ");
INSERT INTO wolmbs_vpl VALUES ("NU36_10","005_36_10","NUM","36","10","10","Na ko Aji Sax ji sante Musaa nag, na la ko doomi Celofat yu jigéen defe. ");
INSERT INTO wolmbs_vpl VALUES ("NU36_11","005_36_11","NUM","36","11","11","Muy Maxla, di Tirca, di Ogla, di Milka, di Nowa, doomi Celofat yooyu, ñoom ñépp seen bokki baay lañu séyal. ");
INSERT INTO wolmbs_vpl VALUES ("NU36_12","005_36_12","NUM","36","12","12","Ca làngi askanu Manase doomu Yuusufa lañu séy, seen céru suuf daldi des ca giir ga seen làngu baay bokk. ");
INSERT INTO wolmbs_vpl VALUES ("NU36_13","005_36_13","NUM","36","13","13","Loolu mooy santaane yeek àttey yoon yi Aji Sax ji dénkoon bànni Israayil, Musaa jottali leen ko ca joori Mowab, fa feggook dexu Yurdan, te janook Yeriko. ");
INSERT INTO wolmbs_vpl VALUES ("DT1_1","006_1_1","DEU","1","1","1","Lii mooy kàddu yi Musaa wax bànni Israayil gépp, ca wàllaa dexu Yurdan, ca màndiŋ ma, fa joor ga jàkkaarlook Suf, diggante Paran ak Tofel ak Laban ak Àccerot ak Disayab. ");
INSERT INTO wolmbs_vpl VALUES ("DT1_2","006_1_2","DEU","1","2","2","Fukki fan ak benn mooy dox diggante tundu Xoreb ba Kades Barneya, boo ko jaaree yoonu tundu Seyir. ");
INSERT INTO wolmbs_vpl VALUES ("DT1_3","006_1_3","DEU","1","3","3","Waaye ñeent fukkeelu at ma, gannaaw ba bànni Israayil génnee Misra, keroog benn fan ca fukkeelu weer waak benn, ca la Musaa doora wax bànni Israayil mboolem lu ko Aji Sax ji santoon ca ñoom. ");
INSERT INTO wolmbs_vpl VALUES ("DT1_4","006_1_4","DEU","1","4","4","Fekk na Musaa duma Sixon, ma toogoon Esbon, di buurub Amoreen ña, duma it Og buuru Basan ba dëkkoon Astarot ak Eddrey. ");
INSERT INTO wolmbs_vpl VALUES ("DT1_5","006_1_5","DEU","1","5","5","Ca wàllaa dexu Yurdan, ca réewum Mowab la Musaa tàmbalee leeral yoonu Yàlla wii. Mu ne: ");
INSERT INTO wolmbs_vpl VALUES ("DT1_6","006_1_6","DEU","1","6","6","Sunu Yàlla Aji Sax ji da noo waxoon ca Xoreb ne nu: «Seen toogaayub tund wii doy na. ");
INSERT INTO wolmbs_vpl VALUES ("DT1_7","006_1_7","DEU","1","7","7","Walbatikuleen dem, jàll ca biir diiwaanu tundi Amoreen ña, ak mboolem réew ya mu feggool, ca joor ga, ak tund wa, ak suufu tund ya, ak Negew ca bëj-saalum, ba ca tefes ga, ca réewum Kanaaneen ña, ak Libaŋ, ba ca Efraat, dex gu mag ga. ");
INSERT INTO wolmbs_vpl VALUES ("DT1_8","006_1_8","DEU","1","8","8","Mu ngoog, maa leen jox réew moomu. Demleen nangu réew mi Aji Sax ji giñaloon seeni maam Ibraayma ak Isaaxa ak Yanqóoba, ñeel leen ñook seen askan wi leen di wuutu.» ");
INSERT INTO wolmbs_vpl VALUES ("DT1_9","006_1_9","DEU","1","9","9","Musaa teg ca ne leen, jant yooyu laa leen wax, ne leen: «Duma leen àttan yeen ñépp, man doŋŋ. ");
INSERT INTO wolmbs_vpl VALUES ("DT1_10","006_1_10","DEU","1","10","10","Seen Yàlla Aji Sax ji moo leen ful, ba yeena ngii tey, bare ba tollu ni biddiiwi asamaan. ");
INSERT INTO wolmbs_vpl VALUES ("DT1_11","006_1_11","DEU","1","11","11","Yal na leen seen Yàllay maam Aji Sax ji yokkati junniy yoon, te barkeel leen ni mu leen ko waxe! ");
INSERT INTO wolmbs_vpl VALUES ("DT1_12","006_1_12","DEU","1","12","12","Waaye nu ma leen di àttane man doŋŋ, ak seen coono, ak seeni lëj-lëj, ak seeni jote? ");
INSERT INTO wolmbs_vpl VALUES ("DT1_13","006_1_13","DEU","1","13","13","Beralleen seen bopp ay nit ñu rafet xel, amug dégg, te di ñu ràññiku ci seeni giir. Su ko defee ma tabb leen, ñuy seeni njiit.» ");
INSERT INTO wolmbs_vpl VALUES ("DT1_14","006_1_14","DEU","1","14","14","Ba loolu amee ngeen wax ma ne ma: «Loolu nga wax de, xel la.» ");
INSERT INTO wolmbs_vpl VALUES ("DT1_15","006_1_15","DEU","1","15","15","Ci kaw loolu ma jël seen njiit yu rafet xel yu ràññiku yi ngeen jukkee ci seeni giir, daldi leen def seeni njiit, ñii yilif kuréeli junniy nit, ñii téeméer, ñii juróom fukk, ñii fukk, ñii diy jawriñ ci seeni giir. ");
INSERT INTO wolmbs_vpl VALUES ("DT1_16","006_1_16","DEU","1","16","16","Jant yooyu laa sant seeni àttekat ne leen: «Deeleen déglu seeni bokk tey àtte dëgg, diggante bànni Israayil ak mbokkam, akub doxandéem. ");
INSERT INTO wolmbs_vpl VALUES ("DT1_17","006_1_17","DEU","1","17","17","Buleen far-farloo cib àtte, dégluleen ku tuut, ni ngeen di dégloo ku mag, te buleen ragal kenn, ndax àtte bi, Yàllaay boroom. Bu leen mbir mi ëppee loxo nag, ngeen indil ma ko, ma seet ko.» ");
INSERT INTO wolmbs_vpl VALUES ("DT1_18","006_1_18","DEU","1","18","18","Jant yooyu laa leen sant mboolem lu ngeen wara def. ");
INSERT INTO wolmbs_vpl VALUES ("DT1_19","006_1_19","DEU","1","19","19","Gannaaw gi, nu bàyyikoo tundu Xoreb, jaare mboolem màndiŋ mu yaa mu raglu ma ngeen gis. Nu topp yoonu diiwaanu tundi Amoreen ñi, na nu ko sunu Yàlla Aji Sax ji sante woon, ba àgg Kades Barneya. ");
INSERT INTO wolmbs_vpl VALUES ("DT1_20","006_1_20","DEU","1","20","20","Ci kaw loolu ma ne leen: «Agsi ngeen fii ci tundu Amoreen ñi nu sunu Yàlla Aji Sax ji di jox. ");
INSERT INTO wolmbs_vpl VALUES ("DT1_21","006_1_21","DEU","1","21","21","Mu ngoog, seen Yàlla Aji Sax ji moo teg réew mi fi seen kanam. Demleen nangu ko, ni leen ko seen Yàllay maam Aji Sax ji, waxe. Buleen ragal, buleen yoqi.» ");
INSERT INTO wolmbs_vpl VALUES ("DT1_22","006_1_22","DEU","1","22","22","Ci kaw loolu ngeen dikk yeen ñépp fi man, ne ma: «Nan yebal aw nit, ñu jiitu nu, yëral nu réew ma, te délsi wax nu yoon wu nuy jaare, ak dëkk yu mag ya nuy duggeji.» ");
INSERT INTO wolmbs_vpl VALUES ("DT1_23","006_1_23","DEU","1","23","23","Ma rafetlu xel, ma tànn ci yeen fukki góor ak ñaar, giir gu nekk genn góor. ");
INSERT INTO wolmbs_vpl VALUES ("DT1_24","006_1_24","DEU","1","24","24","Ñu walbatiku jubal yoonu diiwaanu tund ya, ba àgg xuru Eskol, daldi seet foofa, ");
INSERT INTO wolmbs_vpl VALUES ("DT1_25","006_1_25","DEU","1","25","25","ba noppi sàkk ca meññeefum réew ma, indaaleel nu. Ñu wax nu nag ne nu: «Réew mu baax la nu sunu Yàlla Aji Sax ji jox.» ");
INSERT INTO wolmbs_vpl VALUES ("DT1_26","006_1_26","DEU","1","26","26","Teewul bëgguleen woona dem, xanaa di gàntal seen ndigalal Yàlla Aji Sax ji. ");
INSERT INTO wolmbs_vpl VALUES ("DT1_27","006_1_27","DEU","1","27","27","Ngeen di ñurumtu ci seen biiri xayma, naan: «Bañ nu kay a tax Aji Sax ji jële nu réewum Misra, teg nu ci loxoy Amoreen ñi, ngir ñu rey nu. ");
INSERT INTO wolmbs_vpl VALUES ("DT1_28","006_1_28","DEU","1","28","28","Ana fu nu jëm? Te sunu bokk ya demoon yoqiloo nu, ne nu waa réew maa nu ëpp, sut nu, dëkk ya réy te dàbbalikoo ay tata yu àkki asamaan. Rax ci dolli, ay ponkal yu bokk ci askanu Anageen ñi lanu fa gis!» ");
INSERT INTO wolmbs_vpl VALUES ("DT1_29","006_1_29","DEU","1","29","29","Ma wax leen yeen ne leen: «Buleen yox-yoxi, buleen leen ragal. ");
INSERT INTO wolmbs_vpl VALUES ("DT1_30","006_1_30","DEU","1","30","30","Seen Yàlla Aji Sax ji leen jiitu, moom moo leen di xeexal, noonee mu defoon ak yeen ca Misra, ngeen gis, ");
INSERT INTO wolmbs_vpl VALUES ("DT1_31","006_1_31","DEU","1","31","31","ca màndiŋ ma it, gis ngeen na leen seen Yàlla Aji Sax ji fabe, ni baay di fabe doomam, ci yoon wi ngeen dox wépp, ba agsi béreb bii.» ");
INSERT INTO wolmbs_vpl VALUES ("DT1_32","006_1_32","DEU","1","32","32","Loolu lépp taxul ngeen am kóolute ci seen Yàlla Aji Sax ji, ");
INSERT INTO wolmbs_vpl VALUES ("DT1_33","006_1_33","DEU","1","33","33","ki leen daan jiitu ci yoon wi, ngir sàkkal leen fu ngeen di dale: guddi, mu nekk ci biir sawara, di leen niital yoon wu ngeen jaare; bëccëg, mu nekkal leen ci biir aw niir. ");
INSERT INTO wolmbs_vpl VALUES ("DT1_34","006_1_34","DEU","1","34","34","Ba Aji Sax ji déggee seeni kàddu, dafa mer ba giñ ne: ");
INSERT INTO wolmbs_vpl VALUES ("DT1_35","006_1_35","DEU","1","35","35","«Du kenn ci nit ñii, maas gu bon gii, kuy gis réew mu baax mi ma giñaloon seeni maam. ");
INSERT INTO wolmbs_vpl VALUES ("DT1_36","006_1_36","DEU","1","36","36","Xanaa Kaleb doomu Yefune moo koy gis, te réew ma mu teg tànkam, moom laa koy jox, mook askanam, ndax moo matal kóolute ci Aji Sax ji.» ");
INSERT INTO wolmbs_vpl VALUES ("DT1_37","006_1_37","DEU","1","37","37","Man itam Aji Sax ji mere na ma ci ndax yeen, ba ne ma: «Yaw itam doo ca dugg. ");
INSERT INTO wolmbs_vpl VALUES ("DT1_38","006_1_38","DEU","1","38","38","Yosuwe doomu Nuun, mi nekk ci sa kilifteef, moo cay dugg. Nanga ko ñaax, ndax moom mooy jox Israayil réew ma. ");
INSERT INTO wolmbs_vpl VALUES ("DT1_39","006_1_39","DEU","1","39","39","Seen tuut-tànk yi ngeen noon dees na leen sëxëtoo, seen doom yii xamagul lu baax ak lu bon, ñooy duggi réew ma. Ñoom laa koy jox, te ñoo koy nangu. ");
INSERT INTO wolmbs_vpl VALUES ("DT1_40","006_1_40","DEU","1","40","40","Yeen nag walbatikuleen dellu màndiŋ ma, topp yoonu géeju Barax ya.» ");
INSERT INTO wolmbs_vpl VALUES ("DT1_41","006_1_41","DEU","1","41","41","Ci kaw loolu ngeen wax ma, ne ma: «Noo tooñ Aji Sax ji. Waaye dinanu dem xareji noonee nu ko sunu Yàlla Aji Sax ji sante woon.» Ku nekk ci yeen daldi ràngoo ngànnaayam, ngeen defe ne yéegi diiwaanu tund wa dina leen yomb. ");
INSERT INTO wolmbs_vpl VALUES ("DT1_42","006_1_42","DEU","1","42","42","Aji Sax ji ne ma: «Wax leen ne leen buñu dem, buñu xeexi ndax man Aji Sax ji àndumaak ñoom. Lu ko moy dinañu daanu ci seen kanami noon.» ");
INSERT INTO wolmbs_vpl VALUES ("DT1_43","006_1_43","DEU","1","43","43","Ma wax leen ko, dégluwuleen, xanaa gàntal ndigalal Aji Sax ji, fétteeral, ba yéegi diiwaanu tund wa. ");
INSERT INTO wolmbs_vpl VALUES ("DT1_44","006_1_44","DEU","1","44","44","Ba loolu amee Amoreen ña dëkke tund woowa dikk, dajeek yeen, ne leen dann niy yamb, yitte leen Seyir, ba Xorma. ");
INSERT INTO wolmbs_vpl VALUES ("DT1_45","006_1_45","DEU","1","45","45","Ngeen walbatiku, jooy ko Aji Sax ji, Aji Sax ji dégluwu leen, faalewu leen. ");
INSERT INTO wolmbs_vpl VALUES ("DT1_46","006_1_46","DEU","1","46","46","Gannaaw gi, ngeen toog Kades, lu yàgg la ngeen fa toog lépp. ");
INSERT INTO wolmbs_vpl VALUES ("DT2_1","006_2_1","DEU","2","1","1","Ba loolu amee nu walbatiku, dellu màndiŋ ma, topp yoonu géeju Barax ya, na ma ko Aji Sax ji waxe woon. Wër nanu diiwaanu tundu Seyir ay fani fan. ");
INSERT INTO wolmbs_vpl VALUES ("DT2_2","006_2_2","DEU","2","2","2","Aji Sax ji wax ma, ne ma: ");
INSERT INTO wolmbs_vpl VALUES ("DT2_3","006_2_3","DEU","2","3","3","«Seen wërub tund wii doy na. Walbatikuleen, jublu bëj-gànnaar. ");
INSERT INTO wolmbs_vpl VALUES ("DT2_4","006_2_4","DEU","2","4","4","Mbooloo mi ngay sant ne leen: “Yeena ngi waaja jéggi seen kemu réewum bokki Esaween, ñi dëkke Seyir. Dinañu leen ragal, waaye nangeen moytu bu baax. ");
INSERT INTO wolmbs_vpl VALUES ("DT2_5","006_2_5","DEU","2","5","5","Buleen xeex ak ñoom, ndax duma leen jox ci seen suuf fu téstën sax tege, ngir Esaween ñi laa sédd diiwaanu tundu Seyir. ");
INSERT INTO wolmbs_vpl VALUES ("DT2_6","006_2_6","DEU","2","6","6","Aw ñam, weccikoo leen kook ñoom xaalis, door koo lekk; am ndox it, nangeen ko jëndeek ñoom, door koo naan. ");
INSERT INTO wolmbs_vpl VALUES ("DT2_7","006_2_7","DEU","2","7","7","Ndax yeen kat seen Yàlla Aji Sax ji moo barkeel seen mboolemu ñaq te moo ràññee seen doxub màndiŋ mu yaa mii. Ñeent fukki at a ngii seen Yàlla Aji Sax jaa ngeek yeen, ñàkkuleen dara.”» ");
INSERT INTO wolmbs_vpl VALUES ("DT2_8","006_2_8","DEU","2","8","8","Ba mu ko defee nu romb sunu bokki Esaween ñi dëkke Seyir. Danoo wacc yoonu joor ga, ak Elat ak Eccon Geber, daldi walbatiku jaareji màndiŋu Mowab. ");
INSERT INTO wolmbs_vpl VALUES ("DT2_9","006_2_9","DEU","2","9","9","Ba loolu amee Aji Sax ji ne ma: «Buleen dal ci kaw Mowabeen ñi, di leen songub xare, ngir duma leen jox benn cér ci seenum réew, ndax askanu Lóot laa sédd réewum Ar.» ");
INSERT INTO wolmbs_vpl VALUES ("DT2_10","006_2_10","DEU","2","10","10","Emeen ñaa fa njëkkoona dëkk, askan wu am kàttan lañu woon, bare, yegg ca kaw ni Anageen ñi. ");
INSERT INTO wolmbs_vpl VALUES ("DT2_11","006_2_11","DEU","2","11","11","Ay Refayeen lañu jàppe woon Emeen ñooñu ak Anageen ñi, teewul Mowabeen ñi di leen woowe ay Emeen. ");
INSERT INTO wolmbs_vpl VALUES ("DT2_12","006_2_12","DEU","2","12","12","Seyir nag la Oreen ña njëkkoona dëkk, waaye Esaween ñaa leen fa dàqe, rey leen, wuutu leen, noonu Israayil def rekk ak céru suufam bi leen Aji Sax ji jox. ");
INSERT INTO wolmbs_vpl VALUES ("DT2_13","006_2_13","DEU","2","13","13","Aji Sax ji neeti: «Nangeen jàll walum Seredd.» Nu jàll walum Seredd. ");
INSERT INTO wolmbs_vpl VALUES ("DT2_14","006_2_14","DEU","2","14","14","Diggante ba nu bàyyikoo Kades Barneya di dox, ba keroog bés ba nu jàllee walum Seredd, fanweeri at ak juróom ñett la. Fekk na mboolem maasu góor ña tollu woon ci xare, ca ndoortel yoon wa, ñoom ñépp a wuute dal ba, dee ba jeex, na leen ko Aji Sax ji giñale woon. ");
INSERT INTO wolmbs_vpl VALUES ("DT2_15","006_2_15","DEU","2","15","15","Aji Sax jee leen toppe diisaayu loxoom, wollee leen ci biir dal bi, ba ñu jeex tàkk. ");
INSERT INTO wolmbs_vpl VALUES ("DT2_16","006_2_16","DEU","2","16","16","Ba mboolem ña tollu woon ci xare deewee ba jeex, ba ñoom ñépp wuute ca mbooloo ma, ");
INSERT INTO wolmbs_vpl VALUES ("DT2_17","006_2_17","DEU","2","17","17","Aji Sax ji wax ma, ne ma: ");
INSERT INTO wolmbs_vpl VALUES ("DT2_18","006_2_18","DEU","2","18","18","«Yaa ngi waaja jéggi kemu réewum Mowab, ca Ar. ");
INSERT INTO wolmbs_vpl VALUES ("DT2_19","006_2_19","DEU","2","19","19","Bu ngeen àggee ca Amoneen ña nag, buleen dal ci seen kaw, buleen xeex ak ñoom, ndax duma leen jox benn cér ci réewum Amoneen ñi, ngir askanu Lóot woowu laa ko sédd.» ");
INSERT INTO wolmbs_vpl VALUES ("DT2_20","006_2_20","DEU","2","20","20","Diiwaan boobu it réewum Refayeen lees ko jàppe woon, te Refayeen ñaa fa njëkkoona dëkk. Teewul Amoneen ñi di leen woowe ay Samsumeen, ");
INSERT INTO wolmbs_vpl VALUES ("DT2_21","006_2_21","DEU","2","21","21","askan wu am kàttan, bare, te yegg ca kaw ni Anageen ñi. Aji Sax jee bóom Amoneen ñi ci seen kanam, Amoneen ñi dàq leen, sanc, wuutu leen. ");
INSERT INTO wolmbs_vpl VALUES ("DT2_22","006_2_22","DEU","2","22","22","Mooy na mu defaloon Esaween ña dëkke Seyir rekk, ba mu bóome Oreen ña ci seen kanam, Esaween ña dàq leen, sanc, wuutu leen, ba bésub tey jii. ");
INSERT INTO wolmbs_vpl VALUES ("DT2_23","006_2_23","DEU","2","23","23","Aween ña dëkke woon dëkk yu ndaw ya dem, ba àkki Gasa nag, Kaftoreen ña bàyyikoo Keret ñoo leen bóom, wuutu leen. ");
INSERT INTO wolmbs_vpl VALUES ("DT2_24","006_2_24","DEU","2","24","24","Aji Sax ji neeti: «Ayca, fabuleen, jàll walum Arnon. Mu ngoog, maa teg ci seen loxo, Sixon Amoreen ba, buurub Esbon, mook réewam. Dalleen di nangu réew mi, song ko xare. ");
INSERT INTO wolmbs_vpl VALUES ("DT2_25","006_2_25","DEU","2","25","25","Bés niki tey maa tàmbalee wàcce njàqareek tiitaange ci kaw mboolem askan yi asamaan tiim, ba bu ñu déggee seenum riir, dañuy jaaxle, di lox.» ");
INSERT INTO wolmbs_vpl VALUES ("DT2_26","006_2_26","DEU","2","26","26","Musaa waxati ak bànni Israayil, ne leen: Ci kaw loolu ma yebal ay ndaw yu bàyyikoo màndiŋu Kedemot, ba ca Sixon buurub Esbon. Ma yóbbante ko kàdduy jàmm, ne ko: ");
INSERT INTO wolmbs_vpl VALUES ("DT2_27","006_2_27","DEU","2","27","27","«May nu, nu jaare sam réew. Yoon wi rekk lanuy topp; dunu jàdd ndijoor, dunu jàdd càmmoñ. ");
INSERT INTO wolmbs_vpl VALUES ("DT2_28","006_2_28","DEU","2","28","28","Aw ñam, xaalis nga nu koy weccee, nu lekk; am ndox sax, xaalis nga nu koy joxe, nu naan. May nu rekk nu dox, ba jàll. ");
INSERT INTO wolmbs_vpl VALUES ("DT2_29","006_2_29","DEU","2","29","29","Noonu nu Esaween ña dëkke Seyir defaloon ñook Mowabeen ña dëkke Ar rekk. Su ko defee nu mana jàll dexu Yurdan, ba àgg ca réew ma nu sunu Yàlla Aji Sax ji jox.» ");
INSERT INTO wolmbs_vpl VALUES ("DT2_30","006_2_30","DEU","2","30","30","Sixon buurub Esbon nag nanguwu noo may nu jaare fa moom, ndax booba seen Yàlla Aji Sax ji moo dëgëral boppam, wowal xolam, ngir teg ko ci seen loxo niki bésub tey jii. ");
INSERT INTO wolmbs_vpl VALUES ("DT2_31","006_2_31","DEU","2","31","31","Aji Sax ji ne ma: «Gis nga, maa ngi nii tàmbalee teg Sixon akum réewam ci seen loxo. Dalleen di nangum réewam.» ");
INSERT INTO wolmbs_vpl VALUES ("DT2_32","006_2_32","DEU","2","32","32","Ba mu ko defee Sixon dikk dajeek nun, mook gàngooram gépp, ngir song nu xare ca Yaxacc. ");
INSERT INTO wolmbs_vpl VALUES ("DT2_33","006_2_33","DEU","2","33","33","Sunu Yàlla Aji Sax ji daane ko fi sunu kanam, nu duma ko, mook ay doomam, ak gàngooram gépp. ");
INSERT INTO wolmbs_vpl VALUES ("DT2_34","006_2_34","DEU","2","34","34","Jant yooyu lanu nangu dëkkam yépp, faagaagal dëkk yépp: góor ak jigéen ba ca tuut-tànk ya, bàyyiwunu kuy dund. ");
INSERT INTO wolmbs_vpl VALUES ("DT2_35","006_2_35","DEU","2","35","35","Xanaa jur ga lanu sëxëtoo, ak mboolem alali dëkk ya nu nangu. ");
INSERT INTO wolmbs_vpl VALUES ("DT2_36","006_2_36","DEU","2","36","36","La ko dale Arower ga tiim walum Arnon, boole ca dëkk ba ca xur wa, ba ca Galàdd, du benn dëkk bu nu të. Foofu fépp la sunu Yàlla Aji Sax ji daane fi sunu kanam. ");
INSERT INTO wolmbs_vpl VALUES ("DT2_37","006_2_37","DEU","2","37","37","Réewum Amoneen ña doŋŋ ngeen jegewul; muy réew ma leru dexu Yabog, ak dëkki tund ya, mboolem daal, fu nu sunu Yàlla Aji Sax ji aaye woon. ");
INSERT INTO wolmbs_vpl VALUES ("DT3_1","006_3_1","DEU","3","1","1","Ba loolu wéyee nu walbatiku, awe yoonu Basan, Og buuru Basan ànd ak gàngooram gépp, dajejeek ñoom, song leen xare ca Eddrey. ");
INSERT INTO wolmbs_vpl VALUES ("DT3_2","006_3_2","DEU","3","2","2","Aji Sax ji ne ma: «Bu ko ragal, ndax ci say loxo laa ko teg, mook gàngooram gépp, akum réewam. Nanga ko def na nga defoon Sixon buurub Amoreen ba woon fa Esbon.» ");
INSERT INTO wolmbs_vpl VALUES ("DT3_3","006_3_3","DEU","3","3","3","Noonu la sunu Yàlla Aji Sax ji tege Og buuru Basan itam ci sunuy loxo, mook gàngooram gépp, nu duma leen ba desewul kuy dund. ");
INSERT INTO wolmbs_vpl VALUES ("DT3_4","006_3_4","DEU","3","4","4","Booba lanu nangu mboolemi dëkkam. Amul benn dëkk bu nu nanguwul ci ñoom: juróom benn fukki dëkk, mboolem diiwaanu Argob, ba bokk ca nguurug Og ca Basan. ");
INSERT INTO wolmbs_vpl VALUES ("DT3_5","006_3_5","DEU","3","5","5","Yooyu yépp di dëkk yu dàbbalikoo tata yu kawe, ak bunt yu tëje ràpp, te limaaleesul dëkk-dëkkaan yu baree bare, yu dara wërul. ");
INSERT INTO wolmbs_vpl VALUES ("DT3_6","006_3_6","DEU","3","6","6","Nu faagaagal leen, na nu defoon ak Sixon buurub Esbon. Dëkk yépp lanu faagaagal: góor ak jigéen ba ca tuut-tànk ya. ");
INSERT INTO wolmbs_vpl VALUES ("DT3_7","006_3_7","DEU","3","7","7","Mboolem jur gaak alali dëkk ya nag, nu sëxëtoo. ");
INSERT INTO wolmbs_vpl VALUES ("DT3_8","006_3_8","DEU","3","8","8","Jant yooyu lanu nangoo ci loxol ñaari buuri Amoreen ñooña ca wàllaa dexu Yurdan, réew ma dale ca xuru Arnon, ba ca tundu Ermon. ");
INSERT INTO wolmbs_vpl VALUES ("DT3_9","006_3_9","DEU","3","9","9","Ermon googu la waa Sidon di woowe Siryoŋ, Amoreen ñi di ko woowe Senir. ");
INSERT INTO wolmbs_vpl VALUES ("DT3_10","006_3_10","DEU","3","10","10","Mboolem dëkki joor ga lanu nangu, ak mboolem diiwaanu Galàdd, ak mboolem Basan, ba ca Salka ak Eddrey, dëkki nguurug Og mu Basan. ");
INSERT INTO wolmbs_vpl VALUES ("DT3_11","006_3_11","DEU","3","11","11","Mennum Og buuru Basan doŋŋ moo muccoon ca ndesu Refayeen ñu ponkale ña. Lalam ba, lalu weñ gu ñuul la. Ma nga noonee ca Raba, dëkkub Amoneen ña. Guddaayu lal ba ci xasabu góor, juróom ñeenti xasab la, di ñeenti meetar ak genn-wàll, yaatuwaay ba, ñeenti xasab, di ñaari meetar. ");
INSERT INTO wolmbs_vpl VALUES ("DT3_12","006_3_12","DEU","3","12","12","Suuf soosu nu nangu ca jant yooya, te dale ca Arower ga ca xuru Arnon ca bëj-saalum, ak ca bëj-gànnaar, genn-wàllu diiwaanu tundi Galàdd, aki dëkkam, maa ko jox Rubeneen ñi, ak Gàddeen ñi. ");
INSERT INTO wolmbs_vpl VALUES ("DT3_13","006_3_13","DEU","3","13","13","Ndesu Galàdd ak mboolem Basan gu nguurug Og, ma jox ko genn-wàllu giirug Manase. Diiwaanu Argob gépp ak Basan googu gépp, lañu daan woowe réewum Refayeen ña. ");
INSERT INTO wolmbs_vpl VALUES ("DT3_14","006_3_14","DEU","3","14","14","Yayir mi askanoo ci Manase moo nangu mboolem diiwaanu Argob, ba ca kemu réewum Gesureen ña ak Maakateen ña. Moo tudde boppam Basan googu, ba tax ñu di ko woowe Sanci Yayir ba tey jii. ");
INSERT INTO wolmbs_vpl VALUES ("DT3_15","006_3_15","DEU","3","15","15","Askanu Makir laa jox diiwaanu Galàdd. ");
INSERT INTO wolmbs_vpl VALUES ("DT3_16","006_3_16","DEU","3","16","16","Rubeneen ñeek Gàddeen ñi laa jox la dale diiwaanu Galàdd ba ca xuru Arnon, diggu xur wa di seen kemu suuf ci genn wet, dexu Yabog di seen kemu ñook Amoneen ña. ");
INSERT INTO wolmbs_vpl VALUES ("DT3_17","006_3_17","DEU","3","17","17","Fa joor ga feggook dexu Yurdan it di kemu, diggante dexu Kineret ca bëj-gànnaar, ak ca bëj-saalumu géeju Xorom ga, ba ba ngay àgg ca suufu tundu Pisga, ca penku. ");
INSERT INTO wolmbs_vpl VALUES ("DT3_18","006_3_18","DEU","3","18","18","Jant yooyu laa sant Rubeneen ñi ak Gàddeen ñi ak genn-wàllu giirug Manase, ne leen: «Seen Yàlla Aji Sax ji moo leen jox réew mii, ngir ngeen nangu ko. Na xarekat yépp gànnaayu, jàll, jiitu seen bokki bànni Israayil. ");
INSERT INTO wolmbs_vpl VALUES ("DT3_19","006_3_19","DEU","3","19","19","Seeni jabar doŋŋ, ak seeni doom ak seenug jur, ndax xam naa ne jur gu takku ngeen am, ñooy des ci seen dëkk yi ma leen jox ca penkub Yurdan. ");
INSERT INTO wolmbs_vpl VALUES ("DT3_20","006_3_20","DEU","3","20","20","Dimbalileen seen bokki bànni Israayil ba keroog Aji Sax ji di leen noppal ni mu leen noppale yeen, fekk seen bokk yi nangu, ñoom it, réew mi leen seen Yàlla Aji Sax ji jox, ca sowu ba ca wàllaa dexu Yurdan. Su ko defee ku nekk ci yeen saña dellu ca céru suufam ba ma ko jox.» ");
INSERT INTO wolmbs_vpl VALUES ("DT3_21","006_3_21","DEU","3","21","21","Yosuwe itam, sant naa ko ci jant yooyu ne ko: «Sa bët moo la may nga gis mboolem ni seen Yàlla Aji Sax ji def ak ñaari buur yii. Noonu rekk la Aji Sax jiy def ak mboolem nguur ya nga jëm. ");
INSERT INTO wolmbs_vpl VALUES ("DT3_22","006_3_22","DEU","3","22","22","Buleen leen ragal, ndax seen Yàlla Aji Sax ji moo leen di xeexal.» ");
INSERT INTO wolmbs_vpl VALUES ("DT3_23","006_3_23","DEU","3","23","23","Jant yooyu laa tinu Aji Sax ji, ne ko: ");
INSERT INTO wolmbs_vpl VALUES ("DT3_24","006_3_24","DEU","3","24","24","«Éy Boroom bi Aji Sax ji, yaa ma wonagum lenn ci sa màggaay ak sa doole, Sang bi. Ana yàlla ju nekk asamaan, mbaa ci kaw suuf ju mana roy say jëf ak say jaloore? ");
INSERT INTO wolmbs_vpl VALUES ("DT3_25","006_3_25","DEU","3","25","25","May ma rekk ma jàll, ba gis réew mu baax, ma ca wàllaa dexu Yurdan, tund wu rafet woowu ba ca Libaŋ!» ");
INSERT INTO wolmbs_vpl VALUES ("DT3_26","006_3_26","DEU","3","26","26","Waaye fekk na Aji Sax ji mere ma lool ndax yeen, ba faalewu ma. Aji Sax ji ne ma: «Na doy. Bu ma waxati lu jëm ci loolu. ");
INSERT INTO wolmbs_vpl VALUES ("DT3_27","006_3_27","DEU","3","27","27","Yéegal ba ca kaw tundu Pisga, nga dawal sa bët, te séenu réew ma wetu sowu, ba bëj-gànnaar, bëj-saalum, ba penku. Xoolal bu baax, ndax doo jàll dexu Yurdan gii. ");
INSERT INTO wolmbs_vpl VALUES ("DT3_28","006_3_28","DEU","3","28","28","Waaye nanga yebal Yosuwe, ñaax ko, soññ ko, ndax moom mooy jàll, jiite mbooloo mii, te moo leen di jox réew moomu ngay séen.» ");
INSERT INTO wolmbs_vpl VALUES ("DT3_29","006_3_29","DEU","3","29","29","Ba mu ko defee nu toog ca xur wa janook Bet Pewor. ");
INSERT INTO wolmbs_vpl VALUES ("DT4_1","006_4_1","DEU","4","1","1","Léegi nag yeen waa Israayil, dégluleen dogali yoon yeek àttey yoon yii ma leen di xamal, ngir ngeen di ko jëfe, ndax ngeen dund ba dugg, nanguji réew ma leen Aji Sax ji seen Yàllay maam, di jox. ");
INSERT INTO wolmbs_vpl VALUES ("DT4_2","006_4_2","DEU","4","2","2","Buleen yokk dara ci kàddu gi ma leen di dénk, te buleen ci wàññi lenn, ndax ngeen sàmm seen santaaney Yàlla Aji Sax ji ma leen di dénk. ");
INSERT INTO wolmbs_vpl VALUES ("DT4_3","006_4_3","DEU","4","3","3","Seen bët moo leen may la Aji Sax ji def ca Baal Pewor. Mboolem ku toppoon tuur ma ñuy wax Baal ca Pewor, seen Yàlla Aji Sax ji moo ko sànke ci seen biir. ");
INSERT INTO wolmbs_vpl VALUES ("DT4_4","006_4_4","DEU","4","4","4","Waaye yeen ñi ŋoyoon ci seen Yàlla Aji Sax ji, yeen ñépp a ngi dund tey jii. ");
INSERT INTO wolmbs_vpl VALUES ("DT4_5","006_4_5","DEU","4","5","5","Mu ngoog, jàngal naa leen ay dogali yoon aki àttey yoon, na ma ko sama Yàlla Aji Sax ji sante, ngir ngeen war koo jëfe ca biir réew ma ngeen di nanguji. ");
INSERT INTO wolmbs_vpl VALUES ("DT4_6","006_4_6","DEU","4","6","6","Sàmmooleen koo jëfe, ndax mooy doon seenug rafet xel, ak seenug ràññee fi kanam xeet yi, ba bu ñu déggee mboolem dogali yoon yii, dinañu ne: «Wii askan wu mag rekk a rafetum xel te ràññee!» ");
INSERT INTO wolmbs_vpl VALUES ("DT4_7","006_4_7","DEU","4","7","7","Ana wan xeet wu mag wu am yàlla ju leen jege ni nu sunu Yàlla Aji Sax jiy jegee saa yu nu ko woowee wall? ");
INSERT INTO wolmbs_vpl VALUES ("DT4_8","006_4_8","DEU","4","8","8","Ana xeet wu ko màgge, ba am dogali yoon ak àttey yoon yu jekke ni yoon wii ma joxe fi seen kanam bésub tey? ");
INSERT INTO wolmbs_vpl VALUES ("DT4_9","006_4_9","DEU","4","9","9","Waaye wattuleen, wattuleen seen bopp bu baax, bala ngeena fàtte mbir yi ngeen teg seen bët, ba du génn seenum xel seen giiru dund gépp. Te nangeen ko xamal seeni doom ak seeni sët. ");
INSERT INTO wolmbs_vpl VALUES ("DT4_10","006_4_10","DEU","4","10","10","Bés ba ngeen taxawee fa seen kanam Yàlla Aji Sax ji, fa tundu Xoreb, Aji Sax jee ma ne: «Dajaleel ma mbooloo mi, ma dégtal leen samay kàddu, ngir ñu tàggatu ci ragal ma, li feek ñuy dund ci kaw suuf, te seeni doom it, ñu tàggat leen ci.» ");
INSERT INTO wolmbs_vpl VALUES ("DT4_11","006_4_11","DEU","4","11","11","Yeena dikk taxaw ca suufu tund wa, tund wa ne jippét, sawara wa jolli ba ca xolu asamaan, ci biir xàmbaari guddi gu ne këruus. ");
INSERT INTO wolmbs_vpl VALUES ("DT4_12","006_4_12","DEU","4","12","12","Aji Sax ji àddoo ca digg sawara wa, wax ak yeen, ngeen di dégg baat, te jëmm, gisuleen ko, xanaa baat doŋŋ. ");
INSERT INTO wolmbs_vpl VALUES ("DT4_13","006_4_13","DEU","4","13","13","Ci kaw loolu mu biralal leen kóllëreem gi mu leen sant ngeen sàmm ko, muy fukki santaane yi. Mu daldi leen bindal santaane yi ci ñaari àlluway doj. ");
INSERT INTO wolmbs_vpl VALUES ("DT4_14","006_4_14","DEU","4","14","14","Man nag la Aji Sax ji sant ca yooya jant, ne ma xamal leen dogali yoon yeek àttey yoon yi ngeen wara jëfe ca réew ma ngeen jëm, ngir nanguji ko. ");
INSERT INTO wolmbs_vpl VALUES ("DT4_15","006_4_15","DEU","4","15","15","Nangeen wattu seen bopp bu baax nag ndax keroog ba Aji Sax jiy àddoo ca digg sawara wa, wax ak yeen ca tundu Xoreb, gisuleen jenn jëmm. ");
INSERT INTO wolmbs_vpl VALUES ("DT4_16","006_4_16","DEU","4","16","16","Kon buleen defug yàqute, di sàkkal seen bopp menn tuur muy jëmmal lenn lu mel ni góor mbaa jigéen, ");
INSERT INTO wolmbs_vpl VALUES ("DT4_17","006_4_17","DEU","4","17","17","mbaa lu mel ni menn malam suuf, mbaa malam kaw mu mel ni njanaaw, ");
INSERT INTO wolmbs_vpl VALUES ("DT4_18","006_4_18","DEU","4","18","18","mbaa lu mel ni ndëgmeent di raam, mbaa lu mel niw jën, nekk ci ndox mu suuf tiim. ");
INSERT INTO wolmbs_vpl VALUES ("DT4_19","006_4_19","DEU","4","19","19","Buleen séentu asamaan, gis jant bi, mbaa weer wi, mbaa biddiiw yi, ak mboolem leeri asamaan, ba mu xiirtal leen ci di leen sujjóotal aka jaamu, te seen Yàlla Aji Sax ji féetale yooyii mboolem xeet yi asamaan tiim. ");
INSERT INTO wolmbs_vpl VALUES ("DT4_20","006_4_20","DEU","4","20","20","Yeen nag Aji Sax jee leen jël, génne leen Misra, taalu xellikaayu weñ gu ñuul ba, ngir ngeen doon ñoñam ñi mu séddoo niki bésub tey. ");
INSERT INTO wolmbs_vpl VALUES ("DT4_21","006_4_21","DEU","4","21","21","Waaye yeena tax Aji Sax ji mere ma ba giñ ne duma jàll dexu Yurdan, te duma dugg ca réew mu baax, ma leen seen Yàlla Aji Sax ji moomale. ");
INSERT INTO wolmbs_vpl VALUES ("DT4_22","006_4_22","DEU","4","22","22","Man nag ci réew mii laay deewe. Du maay jàll dexu Yurdan. Waaye yeen yeenay jàll, ba nanguji réew mu baax moomu. ");
INSERT INTO wolmbs_vpl VALUES ("DT4_23","006_4_23","DEU","4","23","23","Wattuleen seen bopp ba baña fàtte kóllëre gi seen Yàlla Aji Sax ji fas ak yeen, di sàkkal seen bopp tuur muy jëmmal lenn, te seen Yàlla Aji Sax ji aaye leen ko. ");
INSERT INTO wolmbs_vpl VALUES ("DT4_24","006_4_24","DEU","4","24","24","Seen Yàlla Aji Sax ji kat, mooy sawara wuy xoyome, Yàlla ju fiir la. ");
INSERT INTO wolmbs_vpl VALUES ("DT4_25","006_4_25","DEU","4","25","25","Bu ngeen demee ba am ay doom aki sët, fekk leen yàgg ca réew ma, su boobaa su ngeen defee ag yàqute, di sàkk am tuur, ak jëmmu lu mu mana doon, mbaa ngeen def lenn lu seen Yàlla Aji Sax ji ñaawlu, lu koy merloo, ");
INSERT INTO wolmbs_vpl VALUES ("DT4_26","006_4_26","DEU","4","26","26","maa ngi sàkku asamaan ak suuf seedeel maak yeen bésub tey jii ne, su boobaa yeenay sànkoo sànku ci lu gaaw, ba wuute ca réew ma ngeen jàll dexu Yurdan, jëm fa, ngir nanguji ko. Su boobaa dungeen fa yàgge, ndax dees leen di raafal, ba ngeen jeex tàkk. ");
INSERT INTO wolmbs_vpl VALUES ("DT4_27","006_4_27","DEU","4","27","27","Aji Sax ji moo leen di tasaare ci biir xeet yi, te lu néew la seenu ndes di doon ci biir xeeti jàmbur yi leen Aji Sax jiy dàq jëme. ");
INSERT INTO wolmbs_vpl VALUES ("DT4_28","006_4_28","DEU","4","28","28","Foofa ngeen di jaamoo ay yàlla yu loxoy nit sàkke bant, mbaa doj, yàlla yu dul gis, duñu dégg, duñ lekk, duñ xeeñtu. ");
INSERT INTO wolmbs_vpl VALUES ("DT4_29","006_4_29","DEU","4","29","29","Waaye su ngeen fa wëree seen Yàlla Aji Sax ji, dingeen ko gis, ndegam seen léppi xol ak seen léppi jëmm ngeen ko wute. ");
INSERT INTO wolmbs_vpl VALUES ("DT4_30","006_4_30","DEU","4","30","30","Bu leen njàqare dikkalee, fekk mboolem mbir yooyu dab leen, su boobaa dingeen mujj délsi ci seen Yàlla Aji Sax ji te dingeen ko déggal. ");
INSERT INTO wolmbs_vpl VALUES ("DT4_31","006_4_31","DEU","4","31","31","Ndax seen Yàlla Aji Sax ji Yàllay yërmande la. Du leen wacc, du leen yàqate te du fàtte kóllëre ga mu fasoon ak seeni maam ci kaw ngiñ. ");
INSERT INTO wolmbs_vpl VALUES ("DT4_32","006_4_32","DEU","4","32","32","Seetleen rekk ci janti démb yi leen jiitu, la dale bés ba Yàlla sàkke nit fi kaw suuf, mbaa ngeen seet asamaan, cat ba cat. Ndax lu màgge nii mas naa am? Am masees naa dégg lu ni mel? ");
INSERT INTO wolmbs_vpl VALUES ("DT4_33","006_4_33","DEU","4","33","33","Ana askan wu masa dégg baatu Yàlla bu jibe ci sawara, ni ngeen ko dégge te dese bakkan? ");
INSERT INTO wolmbs_vpl VALUES ("DT4_34","006_4_34","DEU","4","34","34","Jan yàlla moo masa fexee dikk foqatil boppam aw xeet, jële leen ci weneen xeet, ci biiri nattu, aki firnde aki kéemaan ak xare yu mu sottale dooley loxoom, ak kàttanu përëgam, ak jëf ju raglu, noonee leen ko seen Yàlla Aji Sax ji defale ca Misra, ngeen teg ci bët? ");
INSERT INTO wolmbs_vpl VALUES ("DT4_35","006_4_35","DEU","4","35","35","Yeen déy lañu won loolu lépp ngir ngeen xam ne Aji Sax ji doŋŋ mooy Yàlla, te jeneen yàlla amul, ju dul moom. ");
INSERT INTO wolmbs_vpl VALUES ("DT4_36","006_4_36","DEU","4","36","36","Fa asamaan la àddoo, dégtal leen baatam, ngir yar leen, ci kaw suuf it la leen wone sawaraam su mag sa, te ay kàddoom ngeen dégg, mu jibe ca diggu sawara sa. ");
INSERT INTO wolmbs_vpl VALUES ("DT4_37","006_4_37","DEU","4","37","37","Sopp seeni maam nag moo tax mu tànn leen, yeen askan wi leen wuutu, génneel leen boppam Misra, ci dooleem ju bare, ");
INSERT INTO wolmbs_vpl VALUES ("DT4_38","006_4_38","DEU","4","38","38","ngir dàqal leen xeet yu leen sut, ëpp leen doole, ba dugal leen seenum réew, sédd leen ko bés niki tey. ");
INSERT INTO wolmbs_vpl VALUES ("DT4_39","006_4_39","DEU","4","39","39","Kon xamleen tey te delloosi ci seen xel, ne Aji Sax ji mooy Yàlla fa kaw asamaan ak fi kaw suuf. Du keneen. ");
INSERT INTO wolmbs_vpl VALUES ("DT4_40","006_4_40","DEU","4","40","40","Sàmmleen dogali yoonam, ak santaaneem yi ma leen dénk bés niki tey, ngir seen njariñal bopp, yeen ak seen doom yi leen di wuutu, te ngeen yàgg ca réew ma leen seen Yàlla Aji Sax ji jox ba fàww. ");
INSERT INTO wolmbs_vpl VALUES ("DT4_41","006_4_41","DEU","4","41","41","Ba loolu wéyee Musaa ber ñetti dëkk ca penkub dexu Yurdan, ");
INSERT INTO wolmbs_vpl VALUES ("DT4_42","006_4_42","DEU","4","42","42","mu diy rawtu ci ku rey moroomu nitam, te reyu ko cig teyeef, wonu ko woon it mbañeel, lu jiitu loola. Kooku sañ naa làquji ci dëkk yooyu benn, ngir rawale bakkanam. ");
INSERT INTO wolmbs_vpl VALUES ("DT4_43","006_4_43","DEU","4","43","43","Dëkk yooyu ñoo doon Beccer ga ca màndiŋ ma, ca kaw joor ga, su dee ab Rubeneen; ak Ramot ga ca Galàdd, su dee ab Gàddeen; ak Golan ga ca diiwaanu Basan, su dee ab Manaseen. ");
INSERT INTO wolmbs_vpl VALUES ("DT4_44","006_4_44","DEU","4","44","44","Lii moo di ndigalu yoon wi Musaa biraloon fi kanam bànni Israayil. ");
INSERT INTO wolmbs_vpl VALUES ("DT4_45","006_4_45","DEU","4","45","45","Lii moo di seedey yoon yi ak dogali yoon yi ak àttey yoon yi Musaa dénkoon bànni Israayil, gannaaw ba ñu bàyyikoo Misra, ");
INSERT INTO wolmbs_vpl VALUES ("DT4_46","006_4_46","DEU","4","46","46","ca wàllaa dexu Yurdan, ca xur wa janook Bet Pewor, ca réewum Sixon buurub Amoreen ba toogoon Esbon, te Musaa ak bànni Israayil duma woon ko, ba ñu génnee Misra. ");
INSERT INTO wolmbs_vpl VALUES ("DT4_47","006_4_47","DEU","4","47","47","Ñoo nangu am réewam, ak réewum Og buuru Basan, ñaari buuri Amoreen ña moomoon wàllaa dexu Yurdan, ca penku. ");
INSERT INTO wolmbs_vpl VALUES ("DT4_48","006_4_48","DEU","4","48","48","Noonu la bànni Israayil nangoo suuf sa dale ca Arower, ga ca catal walum Arnon, ba ca tundu Siyoŋ ga ñuy wax itam Ermon. ");
INSERT INTO wolmbs_vpl VALUES ("DT4_49","006_4_49","DEU","4","49","49","Boole nañu ca itam mboolem joor ga nekk wàllaa dexu Yurdan, ca penku, ba àgg ca géeju Xorom ga, ca suufu tundu Pisga. ");
INSERT INTO wolmbs_vpl VALUES ("DT5_1","006_5_1","DEU","5","1","1","Musaa moo woo bànni Israayil gépp, wax leen ne leen: Yeen, bànni Israayil, dégluleen dogali yoon yi ak àttey yoon yi may wax, ngeen dégg, tey. Jàngleen ko te farlu koo jëfe. ");
INSERT INTO wolmbs_vpl VALUES ("DT5_2","006_5_2","DEU","5","2","2","Sunu Yàlla Aji Sax ji moo fasoon kóllëre ak nun ca tundu Xoreb. ");
INSERT INTO wolmbs_vpl VALUES ("DT5_3","006_5_3","DEU","5","3","3","Du sunuy maam rekk la Aji Sax ji fasoon kóllëre gii ak ñoom; waaye ñook nun ñi fii tey, mboolem nun ñiy dund, ci lanu. ");
INSERT INTO wolmbs_vpl VALUES ("DT5_4","006_5_4","DEU","5","4","4","Ci biir jàkkaarloo la Aji Sax ji waxe woon ak yeen ca kaw tund wa, àddoo ca digg sawara wa. ");
INSERT INTO wolmbs_vpl VALUES ("DT5_5","006_5_5","DEU","5","5","5","Maa taxaw diggante Aji Sax jeek yeen, jant yooyu, di leen jottali kàddug Aji Sax ji, ndax yeena ragaloon sawara wa, ba yéeguleen ca kaw tund wa. Mu ne: ");
INSERT INTO wolmbs_vpl VALUES ("DT5_6","006_5_6","DEU","5","6","6","«Man Aji Sax ji maay seen Yàlla ji leen génne réewum Misra, kërug njaam ga. ");
INSERT INTO wolmbs_vpl VALUES ("DT5_7","006_5_7","DEU","5","7","7","«Buleen am yeneen yàlla ci sama kanam. ");
INSERT INTO wolmbs_vpl VALUES ("DT5_8","006_5_8","DEU","5","8","8","«Buleen sàkkal seen bopp tuur muy jëmmal lenn lu nekk ci kaw asamaan, mbaa ci kaw suuf, mbaa lu nekk ci ndox mu suuf tiim. ");
INSERT INTO wolmbs_vpl VALUES ("DT5_9","006_5_9","DEU","5","9","9","Buleen ci sujjóotal lenn, buleen ci jaamu lenn, ndax man seen Yàlla Aji Sax ji, Yàlla ju fiir laa. Maay topp doom tooñu waajur, ba ca seen maasi sët, ba ca maasug sëtaati nit ñi ma bañ. ");
INSERT INTO wolmbs_vpl VALUES ("DT5_10","006_5_10","DEU","5","10","10","Waaye maay baaxe ñi ma sopp, di sàmm samay santaane, ba ci junniy maas ya toppante. ");
INSERT INTO wolmbs_vpl VALUES ("DT5_11","006_5_11","DEU","5","11","11","«Buleen tudd seen turu Yàlla Aji Sax ji ci neen, ndax Aji Sax ji du ñàkka topp kuy tudd aw turam ci neen. ");
INSERT INTO wolmbs_vpl VALUES ("DT5_12","006_5_12","DEU","5","12","12","«Sàmmleen bésu Noflaay bi, ngir sellal ko, ni leen ko seen Yàlla Aji Sax ji sante. ");
INSERT INTO wolmbs_vpl VALUES ("DT5_13","006_5_13","DEU","5","13","13","Juróom benni fan ngeen wara liggéey, def ci seen soxla yépp. ");
INSERT INTO wolmbs_vpl VALUES ("DT5_14","006_5_14","DEU","5","14","14","Waaye bésub juróom ñaareel ba, Noflaay lay doon, ñeel seen Yàlla Aji Sax ji. Buleen ci liggéey lenn; du yeen, du seen doom ju góor, ak ju jigéen, du seen jaam bu góor, ak bu jigéen, du seen nag, du seen mbaam, du mboolem seenug jur, du seen gan gu nekk ci seen biir dëkk. Su ko defee seen jaam bu góor, ak seen jaam bu jigéen mana dallu ni yeen. ");
INSERT INTO wolmbs_vpl VALUES ("DT5_15","006_5_15","DEU","5","15","15","Fàttalikuleen ne ay jaam ngeen woon ca réewum Misra. Seen Yàlla Aji Sax ji moo leen fa génnee dooley loxoom, ak kàttanu përëgam. Moo tax seen Yàlla Aji Sax ji sant leen ngeen wàccoo ak bésu Noflaay bi. ");
INSERT INTO wolmbs_vpl VALUES ("DT5_16","006_5_16","DEU","5","16","16","«Teralleen seen ndey ak seen baay, ni leen ko seen Yàlla Aji Sax ji sante, ndax ngeen gudd fan, ndax it ngeen baaxle ca suuf sa leen seen Yàlla Aji Sax ji jox. ");
INSERT INTO wolmbs_vpl VALUES ("DT5_17","006_5_17","DEU","5","17","17","«Buleen bóom. ");
INSERT INTO wolmbs_vpl VALUES ("DT5_18","006_5_18","DEU","5","18","18","«Buleen njaaloo. ");
INSERT INTO wolmbs_vpl VALUES ("DT5_19","006_5_19","DEU","5","19","19","«Buleen sàcc. ");
INSERT INTO wolmbs_vpl VALUES ("DT5_20","006_5_20","DEU","5","20","20","«Buleen seedeel seen moroom lu dul dëgg. ");
INSERT INTO wolmbs_vpl VALUES ("DT5_21","006_5_21","DEU","5","21","21","«Buleen xédd seen jabaru dëkkandoo, buleen xemmem këram, mbaa toolam, mbaa jaamam bu góor, mbaa jaamam bu jigéen, mbaa aw nagam, mbaa mbaamam, mbaa mboolem seen alalu dëkkandoo.» ");
INSERT INTO wolmbs_vpl VALUES ("DT5_22","006_5_22","DEU","5","22","22","Kàddu yii la Aji Sax ji wax seen ndaje ma mépp, ca tund wa, ba mu àddoo ca digg sawara wa, kàddu gu xumb, ci biir xàmbaar gu lëndëm këruus. Tegaatu ca dara. Mu daldi bind kàddu yi ci ñaari àlluway doj, jox ma. ");
INSERT INTO wolmbs_vpl VALUES ("DT5_23","006_5_23","DEU","5","23","23","Ba ngeen déggee kàddu gay jibe ca lëndëm ga, tund wa jàpp, di tàkk, yeena dikk, seen mboolem kilifay giir ak seeni mag, ba ci man. ");
INSERT INTO wolmbs_vpl VALUES ("DT5_24","006_5_24","DEU","5","24","24","Ngeen ne ma: «Sunu Yàlla Aji Sax ji kat, moo nu won darajaam ak màggaayam. Kàddoom lanu dégg, mu jibe ca digg sawara wa. Bésub tey noo gis Yàlla wax ak doom aadama, ba noppi, muy wéye bakkanam! ");
INSERT INTO wolmbs_vpl VALUES ("DT5_25","006_5_25","DEU","5","25","25","Waaye lu nuy jaayati nag sunu bakkan, doye? Ndax kat, sawara wu réy wii, su nu déggatee sunu kàddug Yàlla Aji Sax ji, da nuy xoyom. ");
INSERT INTO wolmbs_vpl VALUES ("DT5_26","006_5_26","DEU","5","26","26","Ana ci mboolem boroomu suux, ku ci masa dégg kàddug Yàlla jiy dund, mu jibe ci sawara, nii nu ko dégge, ba noppi di dund? ");
INSERT INTO wolmbs_vpl VALUES ("DT5_27","006_5_27","DEU","5","27","27","Jegejil yaw te déglu mboolem li sunu Yàlla Aji Sax ji wax. Yaw yaa nuy àgge mboolem li la sunu Yàlla Aji Sax ji wax, nu dégg, jëfe.» ");
INSERT INTO wolmbs_vpl VALUES ("DT5_28","006_5_28","DEU","5","28","28","Ci biir loolu Aji Sax ji dégg la ngeen ma wax. Mu ne ma: «Dégg naa li la mbooloo mii wax. Ñoo yey wax yooyu kàddu yépp. ");
INSERT INTO wolmbs_vpl VALUES ("DT5_29","006_5_29","DEU","5","29","29","Waaye céy bu ñu amoon boobu xol ngir ragal ma, di sàmm sama santaane yépp bés bu nekk, ba tax ñu baaxle, ñoom ak seen askan, ba fàww! ");
INSERT INTO wolmbs_vpl VALUES ("DT5_30","006_5_30","DEU","5","30","30","Demal, nga ne leen ñu dellu ca seeni xayma. ");
INSERT INTO wolmbs_vpl VALUES ("DT5_31","006_5_31","DEU","5","31","31","Yaw nag, taxawal fi man, ba ma jox la mboolem santaane bi, dogali yoon yi ak àttey yoon yi nga leen di jàngal, te ñu war koo jëfe ca réew ma ma leen jox, ngir ñu nangu ko.» ");
INSERT INTO wolmbs_vpl VALUES ("DT5_32","006_5_32","DEU","5","32","32","Kon nag sàmmooleen koo jëfe ni leen ko seen Yàlla Aji Sax ji sante. Buleen lajjee ndijoor mbaa càmmoñ. ");
INSERT INTO wolmbs_vpl VALUES ("DT5_33","006_5_33","DEU","5","33","33","Mboolem yoon wi leen seen Yàlla Aji Sax ji teg, toppleen ko, ndax ngeen dund, baaxle te gudd fan ca réew ma ngeen di moom. ");
INSERT INTO wolmbs_vpl VALUES ("DT6_1","006_6_1","DEU","6","1","1","Lii mooy santaane bi ak dogali yoon yeek àttey yoon yi seen Yàlla Aji Sax ji santaane ma jàngal leen ko, ngir ngeen di ko jëfe ca réew ma ngeen jàll jëm, ngir nanguji ko, ");
INSERT INTO wolmbs_vpl VALUES ("DT6_2","006_6_2","DEU","6","2","2","ndax ngeen ragal seen Yàlla Aji Sax ji, di sàmm mboolem dogali yoonam ak santaaneem yi ma leen di dénk, yeen ak seeni doom ak seeni sët, seen giiru dund, su ko defee ngeen gudd fan. ");
INSERT INTO wolmbs_vpl VALUES ("DT6_3","006_6_3","DEU","6","3","3","Kon yeen Israayil, dégluleen te sàmmoo jëfe, ndax ngeen baaxle te yokku bu baax, ni leen ko Aji Sax ji seen Yàllay maam waxe, ca réew ma meew maak lem ja tuuroo. ");
INSERT INTO wolmbs_vpl VALUES ("DT6_4","006_6_4","DEU","6","4","4","Dégluleen, yeen bànni Israayil, Aji Sax ji sunu Yàlla, Aji Sax ji kenn la. ");
INSERT INTO wolmbs_vpl VALUES ("DT6_5","006_6_5","DEU","6","5","5","Seen Yàlla Aji Sax ji, soppeleen ko seen léppi xol ak seen léppi jëmm ak seen léppi doole. ");
INSERT INTO wolmbs_vpl VALUES ("DT6_6","006_6_6","DEU","6","6","6","Kàddu yii ma leen di dénk bésub tey, na dëkk ci seen xol. ");
INSERT INTO wolmbs_vpl VALUES ("DT6_7","006_6_7","DEU","6","7","7","Nangeen ko xamal seeni doom, di ko waxe bu ngeen toogee seen biir néeg, ak bu ngeen di dox ciw yoon, ak bu ngeen tëddee, ak bu ngeen jógee. ");
INSERT INTO wolmbs_vpl VALUES ("DT6_8","006_6_8","DEU","6","8","8","Takkleen ko, muy firnde ci seen loxo, te na doon am mbandal ci seen diggantey gët. ");
INSERT INTO wolmbs_vpl VALUES ("DT6_9","006_6_9","DEU","6","9","9","Te itam bindleen ko ci seen kaw jëni buntu néeg, ak ci seen bunti dëkk. ");
INSERT INTO wolmbs_vpl VALUES ("DT6_10","006_6_10","DEU","6","10","10","Bu ngeen demee ba seen Yàlla Aji Sax ji yóbbu leen ca réew ma mu giñaloon seeni maam Ibraayma ak Isaaxa ak Yanqóoba, ne yeen la koy jox, muy dëkk yu mag yu baax yu ngeen tabaxul, ");
INSERT INTO wolmbs_vpl VALUES ("DT6_11","006_6_11","DEU","6","11","11","kër ya feese mboolem lu baax lu ngeen ko feesaluloon, ak teen yu ngeen gasul, ak garabi reseñ ak oliw yu ngeen jëmbatul; bu ngeen ca lekkee ba regg, ");
INSERT INTO wolmbs_vpl VALUES ("DT6_12","006_6_12","DEU","6","12","12","wattuleen seen bopp bala ngeena fàtte Aji Sax ji leen génnee réewum Misra, kërug njaam ga. ");
INSERT INTO wolmbs_vpl VALUES ("DT6_13","006_6_13","DEU","6","13","13","Seen Yàlla Aji Sax ji, ragalleen ko. Moom ngeen di jaamu, te aw turam ngeen di giñe. ");
INSERT INTO wolmbs_vpl VALUES ("DT6_14","006_6_14","DEU","6","14","14","Buleen topp yeneen yàlla, ci yàllay xeet yi leen séq. ");
INSERT INTO wolmbs_vpl VALUES ("DT6_15","006_6_15","DEU","6","15","15","Ndax kat seen Yàlla Aji Sax ji ci seen biir, ku fiir la. Lu ko moy sànjum Aji Sax ji dina tàkk ci seen kaw, te dina leen sànk, ba raafal leen ci kaw suuf. ");
INSERT INTO wolmbs_vpl VALUES ("DT6_16","006_6_16","DEU","6","16","16","Buleen seetlu seen Yàlla Aji Sax ji, na ngeen ko seetloo woon ca Maasa. ");
INSERT INTO wolmbs_vpl VALUES ("DT6_17","006_6_17","DEU","6","17","17","Sàmmleen a sàmm seen santaaney Yàlla Aji Sax ji, ak seedey yoonam ak dogali yoonam yi mu leen dénk. ");
INSERT INTO wolmbs_vpl VALUES ("DT6_18","006_6_18","DEU","6","18","18","Jëfeleen njub ak mbaax gi Aji Sax ji rafetlu. Su ko defee dingeen baaxle, ba dem, nanguji réew mu baax mi Aji Sax ji giñaloon seeni maam, ");
INSERT INTO wolmbs_vpl VALUES ("DT6_19","006_6_19","DEU","6","19","19","te dingeen fa dàqe seen noon yépp, na ko Aji Sax ji waxe woon. ");
INSERT INTO wolmbs_vpl VALUES ("DT6_20","006_6_20","DEU","6","20","20","Bu leen seen doom laajee ëllëg, ne leen: «Ana lu waral seedey yoon yi ak dogali yoon yeek àttey yoon yi leen sunu Yàlla Aji Sax ji dénk?» ");
INSERT INTO wolmbs_vpl VALUES ("DT6_21","006_6_21","DEU","6","21","21","Su boobaa waxleen seen doom, ne ko: «Ay jaami Firawna lanu woon ca Misra, waaye Aji Sax jee nu génnee Misra ci dooley loxoom. ");
INSERT INTO wolmbs_vpl VALUES ("DT6_22","006_6_22","DEU","6","22","22","Aji Sax jee nu defal ay firnde, ak kéemaan yu mag te metti ci kaw Misra ak ci kaw Firawna ak ci kaw waa këram gépp, nu teg ci sunuy gët. ");
INSERT INTO wolmbs_vpl VALUES ("DT6_23","006_6_23","DEU","6","23","23","Nun nag, moo nu fa jële, ngir indi nu ci réew mi mu giñaloon sunuy maam, ne nun la koy 