﻿USE sofia;
DROP TABLE IF EXISTS sofia.wol2010_vpl;
CREATE TABLE wol2010_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES wol2010_vpl WRITE;
INSERT INTO wol2010_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Lii mooy cosaanu Yeesu Kirist, sëtu Daawuda, sëtu Ibraayma. ");
INSERT INTO wol2010_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Ibraayma moo jur Isaaxa; Isaaxa jur Yanqóoba; Yanqóoba jur Yuda ak i doomi baayam; ");
INSERT INTO wol2010_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Yuda, Peres ak Sara ci Tamar; Peres Esron, miy baayu Aram; ");
INSERT INTO wol2010_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Aram Aminadab; Aminadab Nason; Nason Salmon; ");
INSERT INTO wol2010_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salmon jur ci Raxab doom ju tudd Bowas; Bowas am ak Ruut Obedd; Obedd jur Isayi, ");
INSERT INTO wol2010_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","miy baayu buur bi Daawuda. Daawuda moo jur Suleymaan ci ki nekkoon soxnas Uri; ");
INSERT INTO wol2010_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Suleymaan jur Robowam; Robowam Abiya; Abiya Asaf; ");
INSERT INTO wol2010_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asaf Yosafat; Yosafat Yoram, miy baayu Osiyas; ");
INSERT INTO wol2010_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Osiyas jur Yowatam; Yowatam Akas, miy baayu Esekiya; ");
INSERT INTO wol2010_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Esekiya Manase; Manase Amon; Amon Yosiyas; ");
INSERT INTO wol2010_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Yosiyas jur Yekoñas ak i doomi baayam ca jamono, ja ñu defe Yawut ya jaam, yóbbu leen Babilon. ");
INSERT INTO wol2010_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Ba ñu leen yóbboo ca Babilon, Yekoñas jur Salacel; Salacel Sorobabel, ");
INSERT INTO wol2010_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","miy baayu Abiyudd; Abiyudd Eliyakim; Eliyakim Asor; ");
INSERT INTO wol2010_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Asor Sadog; Sadog Akim; Akim Eliyudd; ");
INSERT INTO wol2010_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eliyudd Eleyasar; Eleyasar Matan, miy baayu Yanqóoba; ");
INSERT INTO wol2010_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Yanqóoba nag moo jur Yuusufa jëkkëru Maryaama; te ci Maryaama la Yeesu, mi ñuy wax Kirist, juddoo. ");
INSERT INTO wol2010_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Mboolem giir googu nag, la dale ca Ibraayma ba ca Daawuda, fukk lañu ak ñeent; la dale ca Daawuda ba ca njaam ga ca Babilon, fukk lañu ak ñeent; la dale njaam ga ca Babilon ba ci Kirist, fukk lañu ak ñeent. ");
INSERT INTO wol2010_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Nii la Yeesu Kirist juddoo. Bi ñu mayee Maryaama ndeyam Yuusufa, waaye laata ñoo ànd, gis nañu ne dafa ëmb ci kàttanu Xel mu Sell mi. ");
INSERT INTO wol2010_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Yuusufa jëkkëram nag, nekkoon na nit ku jub te bëggu ko woona weer. Mu nara xàccook moom ci sutura. ");
INSERT INTO wol2010_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Waaye bi muy xalaat ci loolu, benn malaakam Boroom bi daldi ko feeñu ci gént ne ko: «Yaw Yuusufa, sëtu Daawuda, bul ragala yeggali Maryaama sa jabar, ndaxte doom ji mu ëmb, ci Xel mu Sell mi la jóge. ");
INSERT INTO wol2010_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Dina jur doom ju góor; nanga ko tudde Yeesu, ndaxte moo di kiy musal xeetam ci seeni bàkkaar.» ");
INSERT INTO wol2010_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Loolu lépp xewoon na, ngir amal li Boroom bi wax, jaarale ko cib yonent, bi mu naan: ");
INSERT INTO wol2010_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","«Janq bi dina ëmb, jur doom ju góor, ñu tudde ko Emanuwel,» liy tekki «Yàlla ganesi na nu.» ");
INSERT INTO wol2010_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Noonu Yuusufa yewwu, yeggali soxnaam, na ko ko malaakam Boroom bi sante woon. ");
INSERT INTO wol2010_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Waaye àndul ak moom, ba kera mu mucc, jur doom ju góor; mu tudde ko Yeesu. ");
INSERT INTO wol2010_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Bi nga xamee ne Yeesu juddu na ci Betleyem ci diiwaanu Yude, amoon na ay boroom xam-xam, ñu jóge penku, ñëw Yerusalem. Booba, ci jamonoy buur bi Erodd la woon. ");
INSERT INTO wol2010_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Ñu ne: «Ana buur bi juddul Yawut yi? Ndaxte gis nanu biddiiwam ci penku te ñëw nanu ngir màggal ko.» ");
INSERT INTO wol2010_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Bi ko Erodd buur ba déggee, mu daldi jaaxle, moom ak waa Yerusalem gépp. ");
INSERT INTO wol2010_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Mu woolu nag sarxalkat yu mag yépp ak xutbakati xeet wa, laaj leen fu Almasi bi, maanaam Kirist, wara juddoo. ");
INSERT INTO wol2010_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Ñu ne ko: «Ca Betleyem ci diiwaanu Yude, ndaxte lii lañu bind jaarale ko cib yonent: ");
INSERT INTO wol2010_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","“Yaw Betleyem ci diiwaanu Yude, du yaw yaa yées ci njiiti Yude, ndaxte ci yaw la njiit di génne, kiy sàmm Israyil sama xeet.”» ");
INSERT INTO wol2010_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Ci kaw loolu Erodd woolu ci kumpa boroom xam-xam ya, di leen ceddowu, ngir xam bu wóor kañ la biddiiw bi feq. ");
INSERT INTO wol2010_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Noonu mu yebal leen Betleyem naan: «Demleen fa, seet bu wóor mbirum xale ba. Bu ngeen ci amee lu wóor nag, ngeen xamal ma ko, ngir man itam ma dem màggal ko.» ");
INSERT INTO wol2010_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Ba ñu dégloo buur ba nag, ñu dem. Te biddiiw, ba ñu gisoon ca penku ba, ne tëll jiite leen, ba àgg, tiim fa xale ba nekk. ");
INSERT INTO wol2010_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Ba ñu gisee biddiiw ba nag, ñu am mbég mu réya réy. ");
INSERT INTO wol2010_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Ñu dugg ca kër ga, gis xale ba ak Maryaama ndeyam, ñu daldi sukk, di ko màggal. Ñu ubbi seeni boyetu alal, may ko wurus ak cuuraay ak ndàbb lu xeeñ lu ñuy wax miir. ");
INSERT INTO wol2010_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Bi ñu ko defee Yàlla artu na leen ci biir gént, ñu baña dellu ca Erodd. Noonu ñu jaar weneen yoon, ñibbi seen réew. ");
INSERT INTO wol2010_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Bi nga xamee ne boroom xam-xam ya ñibbi nañu, benn malaakam Boroom bi feeñu Yuusufa ci gént ne ko: «Erodd mu ngi ci tànki wut xale bi, ngir rey ko; jógal nag, jël xale bi ak ndeyam te nga daw jëm Misra, toog fa, ba kera ma koy wax.» ");
INSERT INTO wol2010_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Yuusufa nag jóg, jël xale ba ak ndeyam, làquji Misra ca guddi ga. ");
INSERT INTO wol2010_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Mu toog fa, ba Erodd faatu. Noonu am li Boroom bi waxoon jaarale ko cib yonent, bi mu naan: «Woo naa sama doom, mu génn Misra.» ");
INSERT INTO wol2010_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Bi Erodd gisee nag, ne boroom xam-xam ya nax nañu ko, mu daldi mer lool. Mu santaane ñu dugg ca Betleyem ak la ko wër, rey xale yu góor ya fa am ñaari at jëm suuf, méngook jamono, ja ko boroom xam-xam ya waxoon. ");
INSERT INTO wol2010_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Booba am la ñu waxoon jaarale ko ci yonent Yàlla Yeremi, bi mu naan: ");
INSERT INTO wol2010_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","«Baat jib na ci Rama, ay jooy ak yuux gu réy, Rasel mooy jooy ay doomam te bëggul kenn dëfal ko, ndaxte saay nañu.» ");
INSERT INTO wol2010_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Bi nga xamee ne Erodd faatu na, benn malaakam Boroom bi feeñu Yuusufa ci gént ca Misra, ");
INSERT INTO wol2010_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","ne ko: «Ñi doon wuta rey xale ba dee nañu; jógal nag, jël xale bi ak ndeyam te nga dellu Israyil.» ");
INSERT INTO wol2010_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Yuusufa jóg nag, jël xale ba ak ndeyam, dellu Israyil. ");
INSERT INTO wol2010_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Waaye bi mu déggee ne Arkelawus moo donn Erodd baayam ca nguuru Yude, mu ragal faa dem. Yàlla artu ko nag ci gént, mu daldi dem diiwaanu Galile. ");
INSERT INTO wol2010_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Mu ñëw nag dëkk ci dëkk bu ñuy wax Nasaret. Noonu am la ñu waxoon ca xale ba, jaarale ko ca yonent ya, bi ñu naan: «Dees na ko tudde Nasareen.» ");
INSERT INTO wol2010_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Ca jamono jooja Yaxya feeñoon na, di waare ca màndiŋu Yude. ");
INSERT INTO wol2010_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","Nii la doon waaree: «Tuubleen seeni bàkkaar, ndaxte nguuru Yàlla Aji Kawe ji jege na.» ");
INSERT INTO wol2010_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Yaxya mooy ki ñu doon wax jaarale ko ci yonent Yàlla Esayi, bi mu naan: «Am na baat buy xaacu ca màndiŋ ma ne: “Xàll-leen yoonu Boroom bi, jubal-leen fi muy jaar.”» ");
INSERT INTO wol2010_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Yaxya nag mu ngi soloon mbubb mu ñu ràbbe kawaru giléem, takk geñog der ci ndiggam. Ay njéeréer la doon dunde ak lem. ");
INSERT INTO wol2010_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Noonu ñépp génn jëm ci moom, ñi dëkk Yerusalem ak diiwaanu Yude, ak waa dexu Yurdan. ");
INSERT INTO wol2010_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Ñu nangu seeni bàkkaar, Yaxya sóob leen ca dexu Yurdan. ");
INSERT INTO wol2010_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Noonu ay Farisen ak ay Sadusen yu bare ñëw ci Yaxya, ngir mu sóob leen ñoom itam ca dex ga. Waaye bi leen Yaxya gisee, mu ne leen: «Yéen ñi fees ak daŋar mel ni ay co, ku leen artu, ngeen daw merum Yàlla mi nara wàcc? ");
INSERT INTO wol2010_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Jëfeleen nag ni ñu tuub seeni bàkkaar, ");
INSERT INTO wol2010_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","te buleen wax ci seen xel naan: “Nun daal doomi Ibraayma lanu,” ndaxte maa ngi leen koy wax, Yàlla man na sàkkal Ibraayma ay doom ci doj yii. ");
INSERT INTO wol2010_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Sémmiñ wi tiim na reeni garab yi. Garab nag gu meññul doom yu baax, dees na ko gor, sànni ko ci sawara si. ");
INSERT INTO wol2010_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Man maa ngi leen di sóob ci ndox, ci lu ànd ak tuub seeni bàkkaar. Waaye kiy ñëw sama gannaaw moo ma ëpp kàttan, ba yeyoowuma koo yóbbul sax ay dàllam. Kooku dina leen sóob ci Xel mu Sell mi ak sawara. ");
INSERT INTO wol2010_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Layoom mu ngi ci loxoom, ngir jéri dàgga ja, ba mu set; pepp ma dina ko def ca sàq ma, waaye xatax ba dina ko lakk ci sawara su dul fey mukk.» ");
INSERT INTO wol2010_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Booba Yeesu jóge Galile, ñëw ngir Yaxya sóob ko ca dexu Yurdan. ");
INSERT INTO wol2010_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Waaye Yaxya gàntu ko ne: «Man maa soxla, nga sóob ma ci ndox, te yaa ngi ñëw ci man!» ");
INSERT INTO wol2010_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Yeesu ne ko: «Bàyyil noonu, ndaxte war nanoo mottali lépp lu jub.» Noonu Yaxya nangu. ");
INSERT INTO wol2010_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Bi ko Yaxya sóobee ca dex ga, Yeesu génn. Ca saa sa asamaan yi daldi ubbiku, te Yaxya gis Xelum Yàlla wàcc ci melow pitax, ñëw ci kaw Yeesu. ");
INSERT INTO wol2010_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Te baat bu jóge asamaan dégtu ne: «Kii mooy sama Doom ji ma bëgg; ci moom laa ame bànneex.» ");
INSERT INTO wol2010_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Bi loolu amee Xelum Yàlla yóbbu Yeesu ca màndiŋ ma, ngir mu jànkoonte ak fiiri Seytaane. ");
INSERT INTO wol2010_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Yeesu nekk fa te lekkul ñeent fukki bëccëg ak ñeent fukki guddi, doora xiif. ");
INSERT INTO wol2010_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Noonu fiirkat bi ñëw ci moom ne ko: «Boo dee Doomu Yàlla, santal doj yii, ñu nekk mburu.» ");
INSERT INTO wol2010_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Waaye Yeesu ne ko: «Mbind mi nee na: “Nit du dunde mburu rekk, waaye itam gépp kàddu gu génne ci gémmiñug Yàlla.”» ");
INSERT INTO wol2010_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Bi mu waxee loolu, Seytaane yóbbu ko ca dëkk bu sell ba, teg ko ca njobbaxtalu kër Yàlla ga. ");
INSERT INTO wol2010_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Mu ne ko: «Boo dee Doomu Yàlla, tëbal ci suuf, ndaxte Mbind mi nee na: “Dina jox ay malaakaam ndigal ci sa mbir, ñu leewu la ci seeni loxo, ngir nga baña fakktalu ciw doj.”» ");
INSERT INTO wol2010_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Yeesu ne ko: «Bind nañu it ne: “Bul diiŋat Yàlla, sa Boroom.”» ");
INSERT INTO wol2010_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Gannaaw loolu Seytaane yóbbu ko ci kaw tund wu kawe lool, won ko réewi àddina yépp ak seeni ndam. ");
INSERT INTO wol2010_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Mu ne ko: «Lii lépp dinaa la ko may, boo sukkee màggal ma.» ");
INSERT INTO wol2010_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Waaye Yeesu ne ko: «Sore ma Seytaane, ndaxte Mbind mi nee na: “Nanga màggal Yàlla sa Boroom, te jaamu ko moom rekk.”» ");
INSERT INTO wol2010_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Noonu Seytaane bàyyi ko. Te ay malaaka daldi ñëw fi Yeesu, di ko topptoo. ");
INSERT INTO wol2010_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Am bés Yeesu dégg ne jàpp nañu Yaxya; mu jóg nag, jëm Galile. ");
INSERT INTO wol2010_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Gannaaw gi, mu toxoo dëkku Nasaret, dem dëkk Kapernawum, bi féeteek dex ga ci diiwaani Sabulon ak Neftali. ");
INSERT INTO wol2010_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Noonu am la ñu waxoon, jaarale ko ci yonent Yàlla Esayi, bi mu naan: ");
INSERT INTO wol2010_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","«Yaw réewum Sabulon ak réewum Neftali, di yoonu géej gannaaw dexu Yurdan, yaw Galile, réewum ñi dul Yawut— ");
INSERT INTO wol2010_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","xeet wa nekkoon cig lëndëm, gis na leer gu mag, ña dëkkoon ca réew, ma dee tiim, leer fenkal na leen.» ");
INSERT INTO wol2010_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Booba Yeesu tàmbali di waare naan: «Tuubleen seeni bàkkaar, ndaxte nguuru Yàlla Aji Kawe ji jegesi na.» ");
INSERT INTO wol2010_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Gannaaw loolu Yeesu doon dox ca tefesu dexu Galile, mu gis fa ñaar ñu bokk ndey ak baay, mooy Simoŋ mi ñuy wax Piyeer, ak Andare. Fekk ñuy sànni seen caax ca dex ga, ndaxte ay nappkat lañu woon. ");
INSERT INTO wol2010_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Yeesu ne leen: «Ñëwleen topp ci man, ma def leen nappkati nit.» ");
INSERT INTO wol2010_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Ca saa sa ñu daldi bàyyi seeni mbaal, topp ci moom. ");
INSERT INTO wol2010_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Ba Yeesu demee ba ca kanam, mu gis yeneen ñaar ñu bokk ndey ak baay, ñuy Saag doomu Sebede, ak Yowaana rakkam. Ñu nekk ci seen biir gaal ak Sebede seen baay, di defar seeni mbaal. Noonu Yeesu woo leen. ");
INSERT INTO wol2010_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Ca saa sa ñu daldi bàyyi gaal ga ak seen baay, topp ci moom. ");
INSERT INTO wol2010_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Ba loolu amee Yeesu doon wër Galile gépp, di jàngle ci seeni jàngu tey yégle xibaaru jàmm bi ci nguuru Yàlla; muy faj jàngoro yépp ak wéradi yépp ca nit ña, ");
INSERT INTO wol2010_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","ba tax turam siiw ba ci biir réewu Siri mépp. Ñu di ko indil ñi wopp ñépp, ñi sonn ndax ay jàngoro ak metit yu bare, ñi rab jàpp, ñiy say ak ñi làggi, mu faj leen. ");
INSERT INTO wol2010_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Noonu mbooloo mu bare topp ci moom, jóge ci wàlli Galile ak diiwaan bi ñuy wax Fukki dëkk yi, ci dëkku Yerusalem ak ci diiwaanu Yude, ba ci gannaaw dexu Yurdan. ");
INSERT INTO wol2010_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Bi Yeesu gisee mbooloo ma nag, mu yéeg ca tund wa, toog; taalibeem ya ñëw ci moom. ");
INSERT INTO wol2010_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Mu daldi leen jàngal naan: ");
INSERT INTO wol2010_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","«Yéen ñi xam seen ñàkk doole ngir neex Yàlla, barkeel ngeen, ndaxte nguuru Yàlla Aji Kawe ji, yéena ko yelloo. ");
INSERT INTO wol2010_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Yéen ñi nekk ci naqar, barkeel ngeen, ndax dees na dëfal seen xol. ");
INSERT INTO wol2010_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Yéen ñi lewet, barkeel ngeen, ndax dingeen moomi àddina. ");
INSERT INTO wol2010_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Yéen ñi xiif te mar njub, barkeel ngeen, ndax dingeen regg. ");
INSERT INTO wol2010_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Yéen ñi am yërmande, barkeel ngeen, ndax dees na leen yërëm. ");
INSERT INTO wol2010_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Yéen ñi am xol bu sell, barkeel ngeen, ndax dingeen gis Yàlla. ");
INSERT INTO wol2010_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Yéen ñiy wut jàmm, barkeel ngeen, ndax dees na leen tudde doomi Yàlla. ");
INSERT INTO wol2010_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Yéen ñi ñu fitnaal ndax seen njub, barkeel ngeen, ndaxte nguuru Yàlla Aji Kawe ji, yéena ko yelloo. ");
INSERT INTO wol2010_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","«Barkeel ngeen, bu ñu leen di saaga, di leen fitnaal, di leen sosal lépp lu bon ngir man. ");
INSERT INTO wol2010_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Bégleen te bànneexu, ndax seen yool dina réy ci laaxira. Ndaxte noonu lañu daan fitnaale yonent yi fi jiitu. ");
INSERT INTO wol2010_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","«Yéena di xoromus àddina. Bu xorom sàppee, nan lañu koy delloo cafkaam? Du jariñati dara, lu dul ñu sànni ko ci biti, nit ñi dox ci kawam. ");
INSERT INTO wol2010_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","Yéena di leeru àddina. Dëkk, bu nekk ci kaw tund du mana nëbbu. ");
INSERT INTO wol2010_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Te it duñu taal làmp, dëpp cig leget, waaye dañu koy wékk, ba muy leeral ñi nekk ci kër gi ñépp. ");
INSERT INTO wol2010_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Na seen leer leere noonu ci kanam nit ñi, ngir ñu gis seeni jëf yu rafet, te màggal seen Baay bi ci kaw. ");
INSERT INTO wol2010_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","«Buleen defe ne ñëw naa ngir dindi yoonu Musaa ak waxi yonent yi. Ñëwuma ngir dindi leen, waaye ngir ñu am ci man. ");
INSERT INTO wol2010_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Ndaxte ci dëgg maa ngi leen koy wax, li feek asamaan ak suuf wéyul, benn tomb walla benn rëddu araf du wéy mukk ci yoonu Musaa, ba kera yépp di am. ");
INSERT INTO wol2010_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Ku tebbi nag ba gëna tuuti ci ndigal yii, te ngay jàngal nit ñi noonu, dees na la tudde ki gëna tuuti ci nguuru Yàlla Aji Kawe ji. Waaye ku leen di sàmm, di leen digle, dees na la tudde ku mag ci nguuru Yàlla Aji Kawe ji. ");
INSERT INTO wol2010_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Ndaxte maa ngi leen koy wax, bu seen njubte ëppul njubteg xutbakat ya ak Farisen ya, dungeen tàbbi mukk ci nguuru Yàlla Aji Kawe ji. ");
INSERT INTO wol2010_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","«Dégg ngeen ne waxoon nañu maam ya ne leen: “Bul rey nit; ku rey nit, yoon dina la dab.” ");
INSERT INTO wol2010_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Waaye man maa ngi leen di wax ne képp ku mere sa mbokk, dinañu la àtte. Ku wax sa mbokk: “Amoo bopp,” dinañu la àtte ca kureelu àttekat ya. Ku ko wax: “Alku nga,” dinañu la àtte ci sawara. ");
INSERT INTO wol2010_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Booy yóbbu nag sa sarax ca sarxalukaay ba, te nga fàttaliku foofa ne, sa mbokk am na lu mu la meree, ");
INSERT INTO wol2010_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","nanga fa bàyyi sa sarax ca kanam sarxalukaay ba, nga jëkka dem, juboo ak sa mbokk, ba noppi dellu, joxe sa sarax. ");
INSERT INTO wol2010_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","«Gaawala juboo ak ki lay yóbbu, ngeen layooji, bala ngeena egg; ngir bañ ki ngay layool jébbal la àttekat ba, kooka jox la alkaati ba, ñu tëj la. ");
INSERT INTO wol2010_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Ci dëgg maa ngi la koy wax, doo génn foofa mukk te feyuloo dërëm bi ci mujj. ");
INSERT INTO wol2010_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","«Te it dégg ngeen ne waxoon nañu: “Bul njaaloo.” ");
INSERT INTO wol2010_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Waaye man maa ngi leen di wax ne, képp ku xool jigéen, xédd ko, njaaloo nga ak moom ci sa xel. ");
INSERT INTO wol2010_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Bu la sa bëtu ndijoor bëggee yóbbe bàkkaar, luqi ko, sànni ko fu sore. ");
INSERT INTO wol2010_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Ndaxte ñàkk benn ci say cér moo gën ci yaw, ñu sànni sa yaram wépp ci sawara. Bu la sa loxol ndijoor bëggee yóbbe bàkkaar, dagg ko, sànni ko fu sore. Ndaxte ñàkk benn ci say cér moo gën ci yaw ñu sànni sa yaram wépp ci sawara. ");
INSERT INTO wol2010_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","«Waxoon nañu ne: “Ku fase sa soxna, nga bindal ko kayitu pase.” ");
INSERT INTO wol2010_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Waaye man maa ngi leen di wax ne, ku fase sa soxna te du ci njaaloo, yaa koy tegtal yoonu njaaloo. Te it ku takk jigéen ju ñu fase, njaaloo nga. ");
INSERT INTO wol2010_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","«Dégg ngeen itam ne waxoon nañu maam ya ne leen: “Bul weddi sa ngiñ, waaye li nga giñ def ko ngir Boroom bi.” ");
INSERT INTO wol2010_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Waaye man maa ngi leen di wax ne, buleen giñ dara; bumu doon ci asamaan, ndaxte moo di jalu Buur Yàlla; ");
INSERT INTO wol2010_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","bumu doon ci àddina, ndax moo di tegukaayu tànkam; bumu doon it ci Yerusalem, ndax moo di dëkku Buur bu mag bi. ");
INSERT INTO wol2010_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Bul giñ it ci sa bopp, ndaxte manuloo weexal mbaa ñuulal benn ci say kawar. ");
INSERT INTO wol2010_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Sa waaw na nekk waaw, sa déedéet na nekk déedéet. Loo ci teg, ci Ibliis la jóge. ");
INSERT INTO wol2010_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","«Te it dégg ngeen ne waxoon nañu: “Bët, bët a koy fey; bëñ, bëñ a koy fey.” ");
INSERT INTO wol2010_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Waaye man maa ngi leen di wax ne buleen bañ ku leen def lu bon, waaye ku la pes ci sa lexu ndijoor, jox ko ba ca des. ");
INSERT INTO wol2010_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Ku la bëgga kalaame, ngir jël sa turki, nga boole ca it sa mbubb mu mag. ");
INSERT INTO wol2010_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Ku la ga, nga yenul ko doxub benn kilomet, àndal ak moom ñaar. ");
INSERT INTO wol2010_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Mayal ku lay ñaan, te bul jox gannaaw ku lay leb. ");
INSERT INTO wol2010_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","«Dégg ngeen ne waxoon nañu: “Soppal sa moroom te sib sa bañaale.” ");
INSERT INTO wol2010_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Waaye man maa ngi leen di wax ne, soppleen seeni bañaale te ñaanal ñi leen di fitnaal, ");
INSERT INTO wol2010_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","ngir wone ne yéenay doomi seen Baay bi nekk ci kaw. Ndaxte mu ngi fenkal jantam ci kaw ñu bon ñi ak ñu baax ñi, te muy tawal ñi jub ak ñi jubadi. ");
INSERT INTO wol2010_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Su ngeen soppee ñi leen sopp, ban yool ngeen am? Xanaa juutikat yi duñu def noonu it? ");
INSERT INTO wol2010_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Su ngeen nuyoo seeni bokk rekk, lu ngeen def lu doy waar? Xanaa ñi xamul Yàlla duñu def noonu it? ");
INSERT INTO wol2010_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Nangeen mat nag, ni seen Baay bi ci kaw mate. ");
INSERT INTO wol2010_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","«Wottuleena def seeni jëf yu jub ci kanam nit ñi, muy ngistal. Lu ko moy, dungeen am yool ci seen Baay bi nekk ci kaw. ");
INSERT INTO wol2010_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Booy sàkk sarax nag, bul yeble ci sa kanam, ñu yéene la. Moom la naaféq yi di def ca jàngu ya ak ca mbedd ya, ngir nit ñi màggal leen. Ci dëgg maa ngi leen koy wax, jot nañu seen pey gépp. ");
INSERT INTO wol2010_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Waaye booy sàkk sarax, bu sa loxob càmmoñ xam li sa loxob ndijoor di def, ");
INSERT INTO wol2010_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","ngir sa sarax nekk kumpa. Noonu sa Baay, bi dara umpul, dina la ko delloo. ");
INSERT INTO wol2010_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","«Bu ngeen di ñaan, buleen mel ni naaféq yi, ñoom ñi bëgg di ñaan, taxaw ca jàngu ya ak fa mbedd yay daje, ngir nit ñi gis leen. Ci dëgg maa ngi leen koy wax, jot nañu seen pey gépp. ");
INSERT INTO wol2010_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Yaw nag booy ñaan, duggal ci sa néeg, tëj bunt bi, te nga ñaan sa Baay bi bët manta gis. Noonu sa Baay, bi dara umpul, dina la ko delloo. ");
INSERT INTO wol2010_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","«Te it bu ngeen di ñaan, buleen bareel wax yu amul njariñ, mel ni ñi xamul Yàlla; ñoom defe nañu ne, Yàlla dina leen nangul ndax seen wax ju bare. ");
INSERT INTO wol2010_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Buleen nirook ñoom, ndaxte seen Baay xam na seeni soxla, laata ngeen ko koy wax. ");
INSERT INTO wol2010_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Yéen nag nii ngeen wara ñaane: “Sunu Baay bi nekk ci kaw, yal na sa tur di lu ñu sellal, ");
INSERT INTO wol2010_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","yal na sa nguur ñëw, yal na sa coobare am ci suuf mel ni ci kaw. ");
INSERT INTO wol2010_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Yal nanga nu may tey li nu dunde; ");
INSERT INTO wol2010_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","te baal nu sunuy tooñ, ni nu baale ñi nu tooñ; ");
INSERT INTO wol2010_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Yàlla boo nu teg ci yoonu nattu, waaye yal nanga nu musal ci lu bon. Ndaxte yaw yaa yelloo nguur ak kàttan ak màggaay, ba fàww. Amiin.” ");
INSERT INTO wol2010_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","«Su ngeen baalee ñi leen tooñ, seen Baay bi ci kaw dina leen baal seeni tooñ yéen itam. ");
INSERT INTO wol2010_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Waaye su ngeen baalul ñi leen tooñ, seen Baay it du leen baal seeni tooñ. ");
INSERT INTO wol2010_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","«Su ngeen di woor, buleen mel ni naaféq yi, ñoom ñi yoggoorlu, di ñaawal seeni kanam, ngir seen koor feeñu nit ñi. Ci dëgg maa ngi leen koy wax, jot nañu seen pey gépp. ");
INSERT INTO wol2010_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Yaw nag booy woor, xeeñalal sa bopp te nga sëlmu, ");
INSERT INTO wol2010_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","ngir sa koor baña feeñu nit ñi, waaye mu feeñu sa Baay bi bët manta gis. Noonu sa Baay, bi dara umpul, dina la ko delloo. ");
INSERT INTO wol2010_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","«Buleen dajale alal ci àddina, fu ko max ak xomaag di yàqe, ak fu sàcc di dugg, jot ko. ");
INSERT INTO wol2010_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Waaye dajaleleen alal ci laaxira, fu ko max ak xomaag dul yàqe, ak fu sàcc dul dugg, jot ko. ");
INSERT INTO wol2010_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Ndaxte fu sa alal nekk, fa la sa xol nekk itam. ");
INSERT INTO wol2010_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","«Bët mooy làmpu yaram. Bu sa bët wéree, kon sa yaram wépp leer, ");
INSERT INTO wol2010_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","waaye bu sa bët woppee, kon sa yaram wépp lëndëm. Leer gi nekk ci yaw, bu nekkee lëndëm, naka la lëndëm googu di këruuse! ");
INSERT INTO wol2010_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","«Kenn manula jaamoondoo ñaari sang; fàww nga bañ kii, bëgg ki ci des, walla nga jàpp ci kenn ki, xeeb ki ci des. Manuleena boole jaamu Yàlla ak jaamu Alal. ");
INSERT INTO wol2010_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","«Loolu moo tax maa ngi leen koy wax, buleen seen bakkan jaaxal, ci lu ngeen wara lekk, walla lu ngeen wara naan. Buleen jaaxle it ngir seen yaram, ci lu ngeen wara sol. Xanaa bakkan gënul lekk, te yaram gënul koddaay? ");
INSERT INTO wol2010_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Seetleen picci asamaan: duñu ji, duñu góob, duñu denc ci sàq; teewul seen Baay bi ci kaw moo leen di dundal. Ndax ëppuleen maana picc yi ci lu bare? ");
INSERT INTO wol2010_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Ana kan ci yéen ci kaw njaaxleem moo mana yokk waxtu ci àppam? ");
INSERT INTO wol2010_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","«Te lu tax ngeen di jaaxle ngir koddaay? Seetleen bu baax, ni tóor-tóori ñax mi di saxe ci tool yi. Duñu liggéey, duñu ëcc, ");
INSERT INTO wol2010_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","waaye maa ngi leen di wax ne Suleymaan sax ci ndamam soluwul woon ni benn ci ñoom. ");
INSERT INTO wol2010_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Yéen ñi néew ngëm! Bu Yàlla woddee nii ñaxum tool yi, miy sax tey, te bu subaa ñu def ko ci taal bi, ndax du leen gëna wodd? ");
INSERT INTO wol2010_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Buleen jaaxle nag, di wax ne: “Lu nu wara lekk? Lu nu wara naan?” walla: “Lu nu wara sol?” ");
INSERT INTO wol2010_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Ndaxte loolu lépp, ñi xamul Yàlla ñoo koy wut. Te seen Baay, bi nekk ci kaw, xam na ne am ngeen soxla ci loolu lépp. ");
INSERT INTO wol2010_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Waaye jëkkleena wut nguuram ak njubteem, te loolu lépp dina leen ko ci dollil. ");
INSERT INTO wol2010_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Buleen jaaxle nag ngir ëllëg, ndaxte ëllëg dina topptoo boppam. Bés bu nekk, coonoom doy na ko. ");
INSERT INTO wol2010_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","«Buleen àtte seeni moroom ak ñaaw njort, ngir bañ ñu àtte leen yéen itam. ");
INSERT INTO wol2010_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Ndaxte dees na leen àtte ak ni ngeen di àttee, nattal leen ak li ngeen di nattale. ");
INSERT INTO wol2010_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Lu tax ngay xool ñax gi ci sa bëtu mbokk, te gisuloo gànj gi ci sa bët yaw? ");
INSERT INTO wol2010_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Walla nan ngay waxe sa mbokk: “May ma, ma dindil la ñax gi ci sa bët,” fekk gànj a ngii ci sa bët yaw? ");
INSERT INTO wol2010_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Naaféq, jëkkala dindi gànj gi ci sa bët, te noonu dinga mana gis bu leer, ngir dindi ñax gi ci sa bëtu mbokk. ");
INSERT INTO wol2010_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","«Buleen jox lu sell xaj yi, mbaa sànni seeni per ci kanam mbaam-xuux yi, ngir bañ ñu dëggaate ko te walbatiku, xotti leen. ");
INSERT INTO wol2010_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","«Ñaanleen, ñu may leen; seetleen te dingeen gis; fëggleen, ñu ubbil leen. ");
INSERT INTO wol2010_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Ndaxte képp kuy ñaan, dinga am; kuy seet, dinga gis; kuy fëgg, ñu ubbil la. ");
INSERT INTO wol2010_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Kan ci yéen, bu la sa doom ñaanee mburu, nga jox ko doj? ");
INSERT INTO wol2010_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Walla mu ñaan la jën, nga jox ko jaan? ");
INSERT INTO wol2010_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Ndegam yéen ñi bon yéena mana jox seeni gone lu baax, astamaak seen Baay bi nekk ci kaw dina jox lu baax ñi ko koy ñaan! ");
INSERT INTO wol2010_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","«Kon nag lépp lu ngeen bëgg, nit ñi defal leen ko, yéen itam nangeen leen ko defal; ndaxte loolu moo ëmb yoonu Musaa ak waxi yonent yi. ");
INSERT INTO wol2010_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","«Jaarleen ci bunt bu xat bi, ndaxte bunt bi ak yoon wi jëm sànku yaatu nañu, te ñi ciy jaar bare. ");
INSERT INTO wol2010_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Waaye buntu dund gu wóor xat na, te yoon wi jëm kaw sew na, te ñi ko gis barewul. ");
INSERT INTO wol2010_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","«Moytuleen ñi mbubboo turu yonent. Dañuy ñëw ci yéen, yor melow xar, waaye ci biir ay bukki yu soxor lañu. ");
INSERT INTO wol2010_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Dingeen leen xàmmee ci seeni jëf. Ndax dees na witte reseñ ci dédd, walla figg ci xaaxaam? ");
INSERT INTO wol2010_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Noonu garab gu baax gu nekk dina meññ doom yu neex, waaye garab gu bon dina meññ doom yu bon. ");
INSERT INTO wol2010_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Garab gu baax manula meññ doom yu bon, naka itam garab gu bon manula meññ doom yu neex. ");
INSERT INTO wol2010_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Garab gu nekk gu dul meññ doom yu neex, dees na ko gor, sànni ko ca sawara sa. ");
INSERT INTO wol2010_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Ci seeni jëf nag ngeen leen di xàmmee. ");
INSERT INTO wol2010_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","«Du képp ku may wax: “Boroom bi, Boroom bi,” mooy dugg ca nguuru Yàlla Aji Kawe ji; ka cay dugg mooy kiy def sama coobarey Baay, bi nekk ci kaw. ");
INSERT INTO wol2010_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Bu bés baa, ñu bare dinañu ma wax: “Boroom bi, Boroom bi, ndax du ci saw tur lanu daa waxe ci kàddug Yàlla? Ndax du ci saw tur lanu daa dàqe ay rab? Ndax du ci saw tur lanu daa defe ay kéemaan yu bare?” ");
INSERT INTO wol2010_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Ci kaw loolu dinaa leen wax dëgg ne leen: “Masuma leena xam; soreleen ma, yéen ñiy def bàkkaar.” ");
INSERT INTO wol2010_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","«Képp ku dégg nag lii ma leen wax, te di ko jëfe, dinga mel ni nit ku am xel, ku tabax këram, samp ko ciw doj. ");
INSERT INTO wol2010_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Ba mu noppee, taw bi daldi sóob, wal mi ñëw, ngelaw li jóg, ñu dal ci kaw kër ga; waaye màbbul, ndaxte mu ngi jàpp ca doj wa. ");
INSERT INTO wol2010_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Waaye képp ku dégg lii ma leen wax te jëfewuloo ko, dinga mel ni nit ku ñàkk xel, ku tabax këram ci gannuus bi. ");
INSERT INTO wol2010_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Ba mu noppee, taw bi daldi sóob, wal mi ñëw, ngelaw li jóg, ñu dal ci kaw kër ga; mu màbb, ba ne tasar.» ");
INSERT INTO wol2010_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Bi Yeesu waxee loolu ba noppi, mbooloo ma daldi waaru ca njàngleem, ");
INSERT INTO wol2010_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","ndaxte jàngal na leen ak sañ-sañ bu seeni xutbakat amul. ");
INSERT INTO wol2010_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Bi loolu amee Yeesu wàcc ca tund wa, te mbooloo mu bare topp ko. ");
INSERT INTO wol2010_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Noonu ku gaana ñëw, sukk ci kanamam ne ko: «Sang bi, soo ko bëggee, man nga maa faj.» ");
INSERT INTO wol2010_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Yeesu tàllal loxoom, laal ko naan: «Bëgg naa ko, wéral.» Ca saa sa ngaanaam daldi deñ. ");
INSERT INTO wol2010_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Yeesu ne ko: «Déglul, bu ko wax kenn, waaye demal won sa bopp sarxalkat bi, te nga jébbal Yàlla sarax, si yoonu Musaa santaane, ngir mu nekk seede ci ñoom.» ");
INSERT INTO wol2010_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Gannaaw loolu Yeesu duggoon na Kapernawum. Bi mu fa duggee nag, ab njiitu xare fekksi ko. Mu ñaan ko, ");
INSERT INTO wol2010_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","ne ko: «Sang bi, sama surga dafa làggi, tëdd ca kër ga te sonn lool.» ");
INSERT INTO wol2010_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Yeesu ne ko: «Dinaa ñëw faj ko.» ");
INSERT INTO wol2010_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Waaye njiit la ne ko: «Sang bi, yeyoowuma nga dugg ci sama kër; waxal genn kàddu rekk, te sama surga dina wér. ");
INSERT INTO wol2010_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Ndaxte man itam maa ngi nekk ci ndigal, te ame naa ay xarekat ci sama ndigal. Su ma nee kii: “Demal,” mu dem. Mbaa ma ne keneen ki: “Ñëwal,” mu ñëw. Te su ma nee sama jaam: “Defal lii,” mu def ko.» ");
INSERT INTO wol2010_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Bi ko Yeesu déggee, mu waaru, ne ña topp ci moom: «Ci dëgg maa ngi leen koy wax, masumaa gis ci bànni Israyil ku gëme ni kii. ");
INSERT INTO wol2010_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Maa ngi leen koy wax, ñu bare dinañu ñëw, jóge ci penku ak sowu, bokk lekk ak Ibraayma ak Isaaxa ak Yanqóoba ci nguuru Yàlla Aji Kawe ji. ");
INSERT INTO wol2010_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Waaye ñi waroona bokk ca nguur ga, dees na leen sànni ci biti ci lëndëm gi. Foofa dees na fa jooy tey yéyu.» ");
INSERT INTO wol2010_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Ci kaw loolu Yeesu wax njiit la ne ko: «Ñibbil, na ame, ni nga ko gëme.» Noonu ca waxtu woowa sax surga ba daldi wér. ");
INSERT INTO wol2010_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Gannaaw loolu Yeesu dem kër Piyeer. Ba mu eggee, mu fekk gorob Piyeer bu jigéen tëdd ak yaram wu tàng. ");
INSERT INTO wol2010_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Bi mu ko gisee, Yeesu laal loxoom, tàngoor wa daldi wàcc; soxna sa jóg, di ko topptoo. ");
INSERT INTO wol2010_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Ca ngoon sa ñu indil ko ñu bare ñu rab jàpp. Yeesu dàq rab ya ak kàddoom te faj ñi wopp ñépp. ");
INSERT INTO wol2010_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Loolu mu def, def na ko, ngir la ñu waxoon jaarale ko ci yonent Yàlla Esayi am, bi mu naan: «Fab na sunuy wopp, gàddu sunuy jàngoro.» ");
INSERT INTO wol2010_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Bi Yeesu gisee mbooloo ma ko wër nag, mu sant taalibe ya, ñu jàll dex ga. ");
INSERT INTO wol2010_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Laata ñuy jàll, benn xutbakat daldi ñëw ci moom ne ko: «Kilifa gi, dinaa la topp fépp foo jëm.» ");
INSERT INTO wol2010_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Waaye Yeesu ne ko: «Till yi am nañu seeni kàmb, te picci asamaan am nañu ay tàgg, waaye Doomu nit ki amul fu mu noppal boppam.» ");
INSERT INTO wol2010_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Noonu keneen ca taalibe ya ne ko: «Sang bi, may ma, ma jëkka dem suuli sama baay.» ");
INSERT INTO wol2010_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Yeesu ne ko: «Toppal ci man te bàyyi ñi dee, ñu suul seeni néew.» ");
INSERT INTO wol2010_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Bi mu ko waxee, Yeesu dugg ca gaal ga, ay taalibeem topp ko. ");
INSERT INTO wol2010_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Ca saa sa ngelaw lu bare daldi yëngal dex ga, ba duus ya sàng gaal ga. Fekk booba Yeesu nelaw. ");
INSERT INTO wol2010_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Noonu taalibe ya daldi jegesi, yee ko naan: «Sang bi, musal nu, nu ngiy dee!» ");
INSERT INTO wol2010_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Waaye Yeesu ne leen: «Yéen ñi néew ngëm, lu tax ngeen tiit?» Ci kaw loolu mu jóg, daldi gëdd ngelaw li ak duus yi. Lépp dal, ba ne nemm. ");
INSERT INTO wol2010_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Bi ko nit ña gisee, ñu waaru naan: «Kii kan la ci biir nit ñi, ba ngelaw li ak dex gi di ko déggal?» ");
INSERT INTO wol2010_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Bi Yeesu jàllee nag, ba teer ca diiwaanu waa Gadara, ñaar ñu rab jàpp daldi génn ca sëg ya, ñëw kar ko. Ñaar ñooñu nag, ñu soxor lañu woon, ba kenn ñemewul woona jaar foofa. ");
INSERT INTO wol2010_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Ña rab jàpp daldi xaacu naan: «Yaw Doomu Yàlla ji, loo nuy fexeel? Ndax danga noo bëgga mbugal, bala waxtu way jot?» ");
INSERT INTO wol2010_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Fekk amoon na ca wet ya géttu mbaam-xuux yu bare yuy for. ");
INSERT INTO wol2010_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Rab ya nag ñaan ko ne: «Boo nu dàqee, sànni nu ca géttu mbaam-xuux ya.» ");
INSERT INTO wol2010_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Yeesu ne leen: «Demleen.» Rab ya nag daldi génn, dugg ca mbaam-xuux ya, ñu daldi bartalu, daanu ca dex ga, lab ca ndox ma. ");
INSERT INTO wol2010_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Ba sàmm ya gisee loolu, ñu daw, dem dëkk ba, nettaliji lépp ak la xewoon ca ña rab jàpp. ");
INSERT INTO wol2010_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Noonu dëkk ba bépp génn seeti Yeesu. Ba ñu ko gisee nag, ñu ñaan ko, mu génn seen réew. ");
INSERT INTO wol2010_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Bi loolu amee Yeesu dugg cig gaal, jàll dex ga, dellu dëkkam. ");
INSERT INTO wol2010_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Foofa ñu indil ko ku tëdd ci basaŋ, fekk yaramam wépp làggi. Bi Yeesu gisee seen ngëm, mu ne ku làggi ka: «Na sa xel dal, sama waay, baal nañu la say bàkkaar.» ");
INSERT INTO wol2010_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Bi mu waxee loolu, ay xutbakat daldi ne ci seen biir: «Nit kii mu ngi sosal Yàlla.» ");
INSERT INTO wol2010_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Waaye Yeesu xam seen xalaat ne leen: «Lu tax ngeen am xalaat yu bon ci seen xol? ");
INSERT INTO wol2010_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Ma wax ne: “Baal nañu la say bàkkaar,” walla ma ne: “Jógal te dox,” lan moo ci gëna yomb? ");
INSERT INTO wol2010_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Waaye xamleen ne, Doomu nit ki am na ci àddina sañ-sañu baale bàkkaar yi.» Ci kaw loolu Yeesu ne ku làggi ka: «Jógal, jël sa basaŋ te nga ñibbi.» ");
INSERT INTO wol2010_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Noonu làggi ba daldi jóg, ñibbi. ");
INSERT INTO wol2010_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Ba mbooloo ma gisee loolu, ñu daldi ragal te màggal Yàlla, mi dénk sañ-sañ bu tollu noonu doom Aadama yi. ");
INSERT INTO wol2010_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Bi Yeesu jógee foofa, mu gis nit ku tudd Macë, toog ca juuti ba. Yeesu ne ko: «Kaay topp ma.» Noonu Macë jóg, daldi ko topp. ");
INSERT INTO wol2010_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Gannaaw ga Yeesu doon lekk ca kër ga, te ay juutikat ak i boroom bàkkaar yu bare dikk, bokk lekk ak Yeesu ak taalibeem ya. ");
INSERT INTO wol2010_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Bi ko Farisen ya gisee nag, ñu ne taalibe ya: «Lu tax seen kilifa di lekkandoo ak ay juutikat ak ay boroom bàkkaar?» ");
INSERT INTO wol2010_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Waaye bi ko Yeesu déggee, mu ne: «Ñi wér soxlawuñu fajkat, ñi wéradi ñoo ko soxla. ");
INSERT INTO wol2010_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Mbind mi nee na: “Yërmande laa bëgg, waaye du rendi saraxi mala.” Demleen nag te seet lu wax joojuy tekki. Ndaxte ñëwuma, ngir woo ñi jub, waaye bàkkaarkat yi laay woo.» ");
INSERT INTO wol2010_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Gannaaw loolu taalibey Yaxya ñëw ci Yeesu ne ko: «Lu tax nuy woor, nun ak Farisen yi, te say taalibe duñu woor?» ");
INSERT INTO wol2010_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Yeesu ne leen: «Ndax gan yi ñëw ci céet dinañu naqarlu dara, li feek boroom céet gaa ngi ànd ak ñoom? Waaye bés yaa ngi ñëw yu ñuy jële boroom céet gi ci seen biir; booba nag dinañu woor. ");
INSERT INTO wol2010_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Xam ngeen ne, kenn du daax mbubb mu màggat ak sekkit wu bees; ndaxte sekkit wi day ñoddi mbubb mi, te xottiku bi gëna yaatu. ");
INSERT INTO wol2010_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Te it duñu def biiñ bu bees ci mbuusi der yu màggat. Lu ko moy, mbuus yi dañuy toj, biiñ bi tuuru te mbuus yi yàqu. Waaye biiñ bu bees, dees na ko def ci mbuus yu bees. Noonu ñoom ñaar duñu yàqu.» ");
INSERT INTO wol2010_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Bi leen Yeesu di wax loolu, benn njiitu jàngu daldi ñëw, sukk ci kanamam ne ko: «Sama doom ju jigéen dafa faatu léegi, waaye ñëwal, teg ko say loxo, te dina dundaat.» ");
INSERT INTO wol2010_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Noonu Yeesu jóg, topp ko, moom ak ay taalibeem. ");
INSERT INTO wol2010_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","21","Bi ñuy dem nag, amoon na ca mbooloo ma jigéen juy xëpp deret diirub fukki at ak ñaar. Mu defe ne su laalee mbubbam rekk, dina wér. Mu jegeñsi Yeesu nag, doxe ko gannaaw, laal catu mbubbam. ");
INSERT INTO wol2010_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Bi mu ko defee Yeesu waññiku ne ko: «Na sa xel dal, soxna si, sa ngëm faj na la.» Noonu jigéen ja daldi wér ca saa sa. ");
INSERT INTO wol2010_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Bi Yeesu eggee kër njiit la, mu gis ñiy liit ak toxoro, ak mbooloo may def coow lu bare. ");
INSERT INTO wol2010_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Mu ne leen: «Génnleen, janq bi deewul, day nelaw rekk.» Bi ko mbooloo ma déggee, ñu daldi ko ñaawal. ");
INSERT INTO wol2010_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Waaye ñu génne leen, Yeesu dugg, jàpp loxob janq ba, mu daldi jóg. ");
INSERT INTO wol2010_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Noonu xibaaru li mu def daldi siiw ca réew ma. ");
INSERT INTO wol2010_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Bi Yeesu jógee foofa, ñaari gumba topp ko, di wax ca kaw naan: «Yërëm nu, yaw Sëtu Daawuda bi!» ");
INSERT INTO wol2010_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Noonu Yeesu dugg ca kër ga, gumba ya toppsi ko. Yeesu ne leen: «Ndax gëm ngeen ne man naa def li ngeen ma laaj?» Ñu ne ko: «Waaw, Sang bi.» ");
INSERT INTO wol2010_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Kon Yeesu daldi laal seeni bët ne leen: «Na am, ni ngeen ko gëme.» ");
INSERT INTO wol2010_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Ca saa sa seeni bët daldi ubbiku. Yeesu dénk leen bu wér ne leen: «Moytuleen kenn xam ko.» ");
INSERT INTO wol2010_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Waaye ñu génn rekk, siiwal turam fu nekk. ");
INSERT INTO wol2010_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Bi ñu fa jógee nag, amoon na ñeneen ñu ñëw fi moom, indil ko ku rab jàpp, mu luu. ");
INSERT INTO wol2010_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Yeesu dàq rab wa, luu ba daldi wax. Bi ñu ko gisee, mbooloo ma waaru, ñu ne: «Lu mel nii, masuñu koo gis ci Israyil.» ");
INSERT INTO wol2010_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Waaye Farisen ya ne: «Ci kàttanu buuru rab yi lay dàqe rab yi.» ");
INSERT INTO wol2010_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Noonu Yeesu wër dëkk yu mag ya yépp ak yu ndaw ya, di leen jàngal ci seeni jàngu, tey yégle xibaaru jàmm bi jëm ci nguuru Yàlla, di faj jàngoro yépp ak wéradi yépp. ");
INSERT INTO wol2010_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Bi Yeesu gisee mbooloo ma, mu yërëm leen, ndaxte dañoo sonn ba ne yogg, mel ni xar yu amul sàmm. ");
INSERT INTO wol2010_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Noonu mu ne taalibeem ya: «Ngóob mi yaatu na, waaye liggéeykat yi barewuñu. ");
INSERT INTO wol2010_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Ñaanleen nag Boroom ngóob mi, mu yebal ay liggéeykat, ñu góob toolam.» ");
INSERT INTO wol2010_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Noonu Yeesu woo ca moom fukki taalibeem ya ak ñaar, jox leen sañ-sañu dàq rab yi, tey faj jàngoro yépp ak wéradi yépp. ");
INSERT INTO wol2010_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Fukki ndaw ak ñaar, ya Yeesu yónni woon nag, nii lañu tuddoon: ku jëkk ki mooy Simoŋ mi ñuy wax Piyeer, ak Andare mi bokk ak moom ndey ak baay; Saag doomu Sebede, ak Yowaana rakkam; ");
INSERT INTO wol2010_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Filib ak Bartelemi; Tomaa ak Macë, juutikat ba woon; Saag doomu Alfe, ak Tade; ");
INSERT INTO wol2010_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Simoŋ, mi bokk ca mbooloo, ma ñu tudde Ñi farlu ci moom seen réew; ak Yudaa Iskariyo, mi nara wor Yeesu. ");
INSERT INTO wol2010_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Yeesu yónni fukk ñooñule ak ñaar, jox leen ndigal ne leen: «Buleen dem ci ñi dul Yawut mbaa dugg ci benn dëkku waa Samari. ");
INSERT INTO wol2010_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Waaye demleen ci bànni Israyil, ñoom ñi réer niy xar. ");
INSERT INTO wol2010_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Bu ngeen demee nag, yégleleen naan: “Nguuru Yàlla Aji Kawe ji jegesi na.” ");
INSERT INTO wol2010_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Fajleen ñi wopp, dekkal ñi dee, fajleen gaana yi te dàq rab yi. Cig neen ngeen ame, mayeleen cig neen. ");
INSERT INTO wol2010_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Buleen dajale wurus, xaalis mbaa xànjar ci seeni maxtume. ");
INSERT INTO wol2010_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Buleen wut it mbuus ngir tukki mbaa ñaari turki, ay dàll mbaa aw yet, ndaxte liggéeykat yeyoo na dundam. ");
INSERT INTO wol2010_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","«Bu fekkee ne agsi ngeen ci dëkk bu mag mbaa bu ndaw, nangeen fa seet ku fa am faayda, dal ca moom ba kera ngeen jóge dëkk ba. ");
INSERT INTO wol2010_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Bu ngeen di dugg ci kër nag, nuyooleen. ");
INSERT INTO wol2010_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Bu fekkee ne kër ga yeyoo na ko, na seen jàmm wàcc ci ñoom, waaye bu ko yeyoowul, na seen yéene délsi ci yéen. ");
INSERT INTO wol2010_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Koo xam ne gàntu na leen, mbaa mu tanqamlu seeni wax, génnleen ca kër ga mbaa ca dëkk ba, yëlëb seen pëndu tànk. ");
INSERT INTO wol2010_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Ci dëgg maa ngi leen koy wax, keroog bésub àtte ba, waa réewu Sodom ak Gomor ñooy tane dëkk boobu. ");
INSERT INTO wol2010_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","«Dégluleen, maa ngi leen di yónni, mel ni ay xar ci biir ay bukki. Muusleen nag niy jaan, te lewet niy pitax. ");
INSERT INTO wol2010_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Waaye moytuleen nit ñi, ndaxte dinañu leen jébbal àttekat yi te dóor leen ay yar ci seeni jàngu. ");
INSERT INTO wol2010_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Dees na leen yóbbu ngir man ci kanam i boroom réew ak i buur, ngir ngeen seede ma ci ñoom ak ci ñi dul Yawut. ");
INSERT INTO wol2010_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Boo xamee ne nag jébbale nañu leen, buleen am xel ñaar ci li ngeen di wax, mbaa ni ngeen koy waxe. Ndaxte ca waxtu woowa sax dingeen jot li ngeen wara wax; ");
INSERT INTO wol2010_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","du yéenay wax, waaye Xelum seen Baay mooy wax ci yéen. ");
INSERT INTO wol2010_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","«Mag dina joxe rakkam cig dee, baay joxe doomam; ay doom it dinañu jóg, bañ seeni waajur, di leen reylu. ");
INSERT INTO wol2010_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Te yéen nag, ñépp dinañu leen bañ ndax sama tur; waaye ku muñ ba muj ga, mucc. ");
INSERT INTO wol2010_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Boo xamee ne fitnaal nañu leen ci dëkk bii, demleen ca ba ca kanam. Ci dëgg maa ngi leen koy wax, dungeen mana wër dëkki Israyil yépp, te Doomu nit ki ñëwul.» ");
INSERT INTO wol2010_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","Yeesu teg ca ne: «Taalibe gënul kilifaam, te jaam gënul sangam. ");
INSERT INTO wol2010_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Bu taalibe yemee ak kilifaam demin, doy na; jaam it ni sangam. Ndegam tudde nañu boroom kër gi Beelsebul, astamaak waa kër gi. ");
INSERT INTO wol2010_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","Kon nag buleen leen ragal, ndaxte amul dara lu nëbbu, lu ñu warula biral, mbaa luy kumpa lu ñu warula siiwal. ");
INSERT INTO wol2010_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Li ma leen wax ci biir lëndëm, waxleen ko ci leer; li ma leen déey, yégleleen ko ci kaw taax yi. ");
INSERT INTO wol2010_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Te buleen ragal ñu mana rey yaram, te manuñoo rey ruu, waaye ragal-leen ki mana sànk yaram ak ruu ci sawara. ");
INSERT INTO wol2010_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Ñaari picci ramatu, ndax duñu ko jaay ci dërëm? Waaye benn ci ñoom du daanu ci suuf te soobul seen Baay. ");
INSERT INTO wol2010_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Seen kawari bopp sax, waññees na leen. ");
INSERT INTO wol2010_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Kon buleen ragal dara, yéena gën ndiiraanu ramatu. ");
INSERT INTO wol2010_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","«Koo xam ne nangu nga ma ci kanam nit ñi, man itam dinaa la nangu ci sama kanam Baay, bi nekk ci kaw. ");
INSERT INTO wol2010_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Waaye ku ma gàntu ci kanam nit ñi, man itam dinaa la gàntu ci sama kanam Baay, bi nekk ci kaw. ");
INSERT INTO wol2010_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","«Te it buleen defe ne damaa ñëw ngir indi jàmm ci àddina; ñëwuma ngir indi jàmm, waaye jaasi laa indaale. ");
INSERT INTO wol2010_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Ndaxte ñëw naa ngir féewale doom ak baayam, doom ju jigéen ak ndeyam, jabar ak goroom; ");
INSERT INTO wol2010_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","te nooni nit ñooy waa këram. ");
INSERT INTO wol2010_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Ku ma gënalul sa ndey walla sa baay, yeyoowuloo ma; ku ma gënalul sa doom ju góor walla ju jigéen, yeyoowuloo ma. ");
INSERT INTO wol2010_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Koo xam ne kii nanguwuloo ñàkk sa bakkan, ba mel ni ku ñu daaj ci bant, te nga topp ma, yeyoowuloo ma. ");
INSERT INTO wol2010_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Kuy rawale sa bakkan, ñàkk ko, te ku ñàkk sa bakkan ndax man, jotaat ko. ");
INSERT INTO wol2010_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","«Te lii itam am na, ku leen nangu, nangu na ma, te ku ma nangu, nangu na ki ma yónni. ");
INSERT INTO wol2010_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Ku nangu yonent ndax yónnentam, dina jot ci peyu yonent; te ku nangu ku jub ndax njubteem, dina jot ci peyu ku jub. ");
INSERT INTO wol2010_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Ci dëgg maa ngi leen koy wax, koo xam ne kii may na kaasu ndox mu sedd rekk kenn ci ñi gëna ndaw, ndax sama taalibe la, kooku du ñàkk yoolam mukk.» ");
INSERT INTO wol2010_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Ba Yeesu joxee fukki taalibeem ya ak ñaar ndigal yooyu, mu jóge fa, ngir dem jàngleji ak a waare ci seeni dëkk. ");
INSERT INTO wol2010_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Gannaaw loolu Yaxya dégg ca kaso ba jëfi Almasi bi. Mu yónni ci moom nag ay taalibeem, ");
INSERT INTO wol2010_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","ne ko: «Ndax yaa di Ki wara ñëw, walla danoo wara xaar keneen?» ");
INSERT INTO wol2010_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Yeesu ne leen: «Demleen nettali Yaxya li ngeen dégg te gis ko. ");
INSERT INTO wol2010_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Gumba yaa ngi gis, lafañ yiy dox, gaana yi wér, tëx yiy dégg, ñi dee di dekki, te néew doole ñaa ngi dégg xibaaru jàmm bi. ");
INSERT INTO wol2010_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Yaw mi sa ngëm yolomul ndax man, barkeel nga.» ");
INSERT INTO wol2010_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Bi nga xamee ne taalibe ya Yaxya yónni woon ci Yeesu dem nañu, Yeesu daldi wax ak mbooloo ma ci mbirum Yaxya ne leen: «Lu ngeen seeti woon ca màndiŋ ma? Xanaa barax buy jaayu ci ngelaw li? ");
INSERT INTO wol2010_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Kon lu ngeen seeti woon nag? Nit ku sol yére yu rafet? Waaye ñi sol yére yu rafet ñu ngi dëkk ci këri buur. ");
INSERT INTO wol2010_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Lu tax ngeen génn nag? Ngir gis ab yonent? Waaw, wax naa leen ne ëpp na yonent. ");
INSERT INTO wol2010_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Yaxya male moo di ki ñu waxoon ci Mbind mi naan: “Maa ngi yónni sama ndaw, mu jiitu la, te xàllal la yoon ci sa kanam.” ");
INSERT INTO wol2010_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Ci dëgg maa ngi leen koy wax, ci li jigéen jur, ku sut Yaxya masula feeñ. Waaye ba tey ki gëna ndaw ci nguuru Yàlla Aji Kawe ji moo ko sut. ");
INSERT INTO wol2010_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Ci li dale ci jamonoy Yaxya ba léegi, nit ñaa ngi góor-góorlu ngir dugg ci nguuru Yàlla, te ñi sawar ñoo ci am wàll. ");
INSERT INTO wol2010_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Ndaxte li yonent yi wax ak li yoonu Musaa tëral ñu ngi doon dox, ba kera Yaxya di feeñ. ");
INSERT INTO wol2010_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Te Yaxya moomu, su ngeen bëggee nangu lii, mooy Ilyaas bi waroona ñëw. ");
INSERT INTO wol2010_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Déglul bu baax, yaw mi am ay nopp. ");
INSERT INTO wol2010_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","«Niti jamono jii nag, lan laa leen mana méngaleel? Ñu ngi nirook xale yu toog ca pénc ma, di woo seeni xarit, ");
INSERT INTO wol2010_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","ne leen: “Liital nanu leen ak toxoro, te fecculeen, woyal nanu leen woyi dëj, te jooyuleen.” ");
INSERT INTO wol2010_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Ndaxte Yaxya feeñ na, lekkul, naanul, ngeen daldi ne: “Dafa ànd ak rab.” ");
INSERT INTO wol2010_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Gannaaw gi nag, Doomu nit ki ñëw na, lekk, naan, ngeen daldi ne: “Kii daal bëgg na lekk, di naan biiñ, tey xaritoo ak ay juutikat ak ay boroom bàkkaar.” Waaye li xam-xamu Yàlla di jur, mooy firndeel ne dëgg la.» ");
INSERT INTO wol2010_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Gannaaw loolu Yeesu daldi gëdd dëkk, ya mu defe woon la ëpp cay kéemaanam, ndaxte tuubuñu seeni bàkkaar. ");
INSERT INTO wol2010_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","Mu ne: «Dingeen torox, yéen waa Korasin ak waa Betsayda, ndaxte kéemaan yi ma def ci yéen, bu ñu leen defoon ci dëkku Tir walla ci dëkku Sidon, kon réccu nañu bu yàgg, xëppoo dóom, sol saaku. ");
INSERT INTO wol2010_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Waaye maa ngi leen koy wax, keroog bés pénc ma Tir ak Sidon ñoo leen di tane. ");
INSERT INTO wol2010_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Te yaw dëkku Kapernawum, ndax dees na la yékkati bu kawe? Déedéet, dees na la daane bu suufe. Ndaxte kéemaan yi ma def ci yaw, bu ñu leen defoon ci dëkku Sodom, kon mu nekk ba tey. ");
INSERT INTO wol2010_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Waaye maa ngi leen koy wax, keroog bés pénc ma Sodom moo lay tane.» ");
INSERT INTO wol2010_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Ca jamono joojale Yeesu wax na lii: «Yaw Baay, Boroom asamaan ak suuf, maa ngi lay sant ci li nga nëbb yëf yii ñi am xam-xam ak ñi am xel, te xamal leen gone yi. ");
INSERT INTO wol2010_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Waaw, Baay, ndaxte looloo la neex.» ");
INSERT INTO wol2010_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Yeesu teg ca ne: «Sama Baay jébbal na ma lépp, te kenn manu maa xam, man Doom ji, ku dul Baay bi; kenn it manula xam Baay bi, ku dul man Doom ji, ak ku ma ko bëgga xamal. ");
INSERT INTO wol2010_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","«Ñëwleen ci man, yéen ñépp ñi sonn te diis, dinaa leen may noflaay. ");
INSERT INTO wol2010_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Jébbaluleen ci man te jàng ci man, ndaxte lewet naa te woyof, te dingeen am noflaay ci seen xol. ");
INSERT INTO wol2010_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Ndaxte sama kilifteef lewet na te sama yen diisul.» ");
INSERT INTO wol2010_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Amoon na benn bésub noflaay Yeesu jaar ci ay tool yu ñor, fekk ay taalibeem xiif; ñu daldi fàq ay gub nag, di lekk. ");
INSERT INTO wol2010_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Farisen ya nag gis ko, ne Yeesu: «Gisal, say taalibe ñu ngi def lu jaaduwul ci bésub noflaay bi.» ");
INSERT INTO wol2010_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Noonu Yeesu ne leen: «Ndax jànguleen la Daawuda defoon, ba mu xiifee, moom ak ña mu àndaloon? ");
INSERT INTO wol2010_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Xanaa yéguleen, ni mu dugge woon ca kër Yàlla ga, gis fa mburu, ya ñu teewal ca kanam Yàlla, mu daldi ko lekk. Fekk jaaduwul mu lekk ca, moom walla ña mu àndaloon; sarxalkat rekk a ko sañoona lekk. ");
INSERT INTO wol2010_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Te it ndax jànguleen ci yoonu Musaa, ne sarxalkat ya ca kër Yàlla ga teraluñu bésub noflaay bi, te tooñuñu? ");
INSERT INTO wol2010_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Waaye maa ngi leen koy wax, am na ci seen biir ku sut kër Yàlla ga. ");
INSERT INTO wol2010_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Mbind mi nee na: “Yërmande laa bëgg, waaye du rendi saraxi mala.” Su ngeen xamoon lu wax joojuy tekki, kon dungeen teg tooñ ñi tooñul. ");
INSERT INTO wol2010_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Ndaxte Doomu nit ki mooy boroom bésub noflaay bi.» ");
INSERT INTO wol2010_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Bi loolu amee Yeesu jóge foofa, dugg ci seen jàngu, ");
INSERT INTO wol2010_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","te amoon na fa nit ku loxoom làggi. Noonu Farisen ya laaj ko: «Faj ci bésub noflaay bi, ndax loolu jaadu na?» Fekk ñuy wut buntu tuumaal ko. ");
INSERT INTO wol2010_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Yeesu ne leen: «Ku fi amoon xar, mu daanu ci kàmb ci bésub noflaay bi, ndax doo ko jàpp, génne ko? ");
INSERT INTO wol2010_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Nit nag, ndax ëppul maana xar? Kon def lu baax ci bésub noflaay bi jaadu na.» ");
INSERT INTO wol2010_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Noonu Yeesu ne nit ka: «Tàllalal sa loxo!» Mu tàllal ko nag, loxoom daldi wér, mel ni ba ca des. ");
INSERT INTO wol2010_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Farisen ya génn nag, daldi gise, ngir fexee reylu Yeesu. ");
INSERT INTO wol2010_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Waaye bi ko Yeesu yégee, mu sore foofa; te ñu bare topp ko, mu wéral leen ñoom ñépp. ");
INSERT INTO wol2010_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Te mu dénk leen bu wóor, ñu bañ koo siiwal. ");
INSERT INTO wol2010_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Def na noonu, ngir amal la ñu waxoon jaarale ko ci yonent Yàlla Esayi, bi mu naan: ");
INSERT INTO wol2010_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","«Kii mooy sama Ndaw li ma tànn, di sama Soppe bi neex sama xol. Dinaa def sama Xel ci moom, muy yégal xeet yi yoonu njub. ");
INSERT INTO wol2010_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Du xëccoo mbaa muy wax ci kaw, te kenn du dégg baatam ci mbedd yi. ");
INSERT INTO wol2010_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Du dammte barax bu banku, te mees guy saxar, du ko fey, ba kera mu yégal njub, ba daan. ");
INSERT INTO wol2010_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Ci turam la xeet yi di ame yaakaar.» ");
INSERT INTO wol2010_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Booba ñu indil ko ku rab jàpp, mu gumba te luu. Yeesu faj ko, ba ku luu ki di wax tey gis. ");
INSERT INTO wol2010_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Noonu mbooloo mépp yéemu naan: «Ndax kii du Sëtu Daawuda bi?» ");
INSERT INTO wol2010_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Bi Farisen ya déggee loolu nag, ñu ne: «Kii ci kàttanu Beelsebul, buuru rab yi, lay dàqe rab yi.» ");
INSERT INTO wol2010_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Waaye Yeesu xam seen xalaat ne leen: «Réew mu xeex boppam tas, te dëkk mbaa kër guy xeex boppam du mana yàgg. ");
INSERT INTO wol2010_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Bu Seytaane dàqee Seytaane nag, xeex na boppam; kon naka la nguuram di mana yàgge? ");
INSERT INTO wol2010_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Te it bu fekkee ne man damay dàq ay rab ci kàttanu Beelsebul, seeni taalibe nag, ci gan kàttan lañu leen di dàqe? Kon ñoo leen di àtte. ");
INSERT INTO wol2010_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Waaye bu fekkee ne ci Xelum Yàlla laay dàqe rab, kon nguuru Yàlla agsi na ba ci yéen. ");
INSERT INTO wol2010_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","«Su fi amee nit ku bare doole, te nit bëgga dugg ci këram, nangu alalam, naka la koy defe? Xanaa dafay jëkka yeew ku bare doole ka, ba noppi doora toj këram gépp. ");
INSERT INTO wol2010_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Noonu ku farul ak man, yaa ngi may xeex, ku dajalewul ak man, yaa ngi tasaare.» ");
INSERT INTO wol2010_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Yeesu teg ca ne: «Loolu moo tax maa ngi leen koy wax, bàkkaar walla sos wu mu mana doon, dinañu ko baale, waaye ku sosal Xelum Yàlla, duñu ko baal. ");
INSERT INTO wol2010_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Ku sosal Doomu nit ki, dinañu ko baal, waaye ku sosal Xel mu Sell mi, duñu ko baal mukk, du ci àddina si, du ci àllaaxira. ");
INSERT INTO wol2010_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Neeleen garab gi baax na, moom ak meññeefam, walla ngeen ne garab gi bon na, moom ak meññeefam; ndaxte garab, meññeefam lañu koy xàmmee. ");
INSERT INTO wol2010_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Yéen ñi fees ak daŋar ni ay co, naka ngeen mana waxe lu baax, fekk dangeen bon? Ndaxte gémmiñ, la fees xol lay wax. ");
INSERT INTO wol2010_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Noonu nit ku baax, lu baax lay wax, jële ko ca fa mu denc lu baax, te nit ku bon, lu bon lay wax, jële ko ca fa mu denc lu bon. ");
INSERT INTO wol2010_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Maa ngi leen di wax ne keroog bés pénc, nit ñi dinañu làyyi ndax wax ju nekk ju amul njariñ, ju ñu masa wax. ");
INSERT INTO wol2010_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Ndaxte dees na la àtte ni ku jub ci say wax, walla ñu daan la ci say wax.» ");
INSERT INTO wol2010_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Ci kaw loolu ay xutbakat ak ay Farisen wax ak Yeesu ne ko: «Kilifa gi, danoo bëggoon, nga won nu kéemaan guy firndeel sag yónnent.» ");
INSERT INTO wol2010_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Yeesu ne leen: «Yéenay laaj firnde, yéen niti jamono ju bon jii, yéen ñi fecci seen kóllëre ak Yàlla, waaye dungeen jot jenn firnde ju dul firndey yonent Yàlla Yunus. ");
INSERT INTO wol2010_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Ndaxte ni Yunus nekke woon ñetti guddi ak ñetti bëccëg ci biir rabu géej wu mag, noonu la Doomu nit ki di nekke ñetti guddi ak ñetti bëccëg ci biir suuf. ");
INSERT INTO wol2010_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Keroog bés pénc waa dëkku Niniw dinañu jógandoo ak niti jamono jii, yey leen; ndaxte bi leen Yunus waaree, tuub nañu seeni bàkkaar, te ku sut Yunus a ngi fi. ");
INSERT INTO wol2010_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Te it ca bés pénc buur bu jigéen, ba dëkkoon ca sudd, dina jógandoo ak niti jamono jii, yey leen; ndaxte dafa jóge ca catul àddina, ngir déglu xam-xamu Suleymaan, te ku sut Suleymaan a ngi fi. ");
INSERT INTO wol2010_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","«Boo xamee ne rab wa jàppoon nit génn na ci moom, day wër ay bérab yu wow, di wut fu mu noppaloo, waaye du ko gis. ");
INSERT INTO wol2010_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","Noonu da naan: “Naa dellu ca sama kër, ga ma génne woon.” Bu ñëwee nag, mu fekk kërug neen, ñu bale ko, defar ko ba lépp jekk. ");
INSERT INTO wol2010_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Bu ko gisee nag, mu dem wooyi yeneen juróom ñaari rab yu ko gëna soxor, ñu dugg, sanc fa; ba tax muju nit kooku mooy yées njàlbéenam. Noonu lay nekke ak niti jamono ju bon jii.» ");
INSERT INTO wol2010_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Bi Yeesu nekkee di wax ak mbooloo ma, ndeyam ak ay rakkam daldi ñëw, taxaw ci biti, bëgga wax ak moom. ");
INSERT INTO wol2010_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Noonu kenn nit ne ko: «Sa yaay ak say rakk ñu ngi nii taxaw ci biti, bëgga wax ak yaw.» ");
INSERT INTO wol2010_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Waaye Yeesu ne ko: «Kan mooy sama ndey ak ñan ñooy samay rakk?» ");
INSERT INTO wol2010_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Noonu mu joxoñ ay taalibeem naan: «Ñii ñooy sama ndey ak samay rakk. ");
INSERT INTO wol2010_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Ndaxte ku def sama coobarey Baay bi nekk ci kaw, yaa di sama rakk, sama jigéen ak sama ndey.» ");
INSERT INTO wol2010_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Bés booba Yeesu génnoon na ca kër ga, toog ca wetu dex ga. ");
INSERT INTO wol2010_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Mbooloo mu bare dajaloo ca moom, ba tax mu dugg cig gaal, toog; mbooloo mépp taxaw ca tefes ga. ");
INSERT INTO wol2010_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Noonu Yeesu dégtal leen lu bare ciy léeb ne leen: «Dafa amoon beykat bu demoon jiyi. ");
INSERT INTO wol2010_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Bi muy saaw toolam nag, lenn ci pepp mi wadd ci kaw yoon wi, picc yi daldi ñëw, lekk ko lépp. ");
INSERT INTO wol2010_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Leneen ci pepp mi wadd ci bérab bu bare ay doj te néew suuf, mu daldi sax bu gaaw, ndaxte suuf si barewul. ");
INSERT INTO wol2010_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Waaye bi jant bi naajee, mu lakk, wow, ndaxte amul ay reen. ");
INSERT INTO wol2010_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Leneen nag wadd ci biir ay xaaxaam, xaaxaam yi daldi jóg, tanc ko. ");
INSERT INTO wol2010_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Li ci des dal ci suuf su baax, nangu ba def ay gub; lii àntu ba mat téeméeri yoon lu ëpp la mu ji woon, lii mat juróom benn fukk, li ci des fanweer. ");
INSERT INTO wol2010_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Déglul bu baax, yaw mi am ay nopp.» ");
INSERT INTO wol2010_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Bi Yeesu waxee ba noppi, ay taalibeem jegeñsi, laaj ko lu tax mu di leen wax ciy léeb. ");
INSERT INTO wol2010_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Noonu mu ne leen: «May nañu leen, ngeen xam mbóoti nguuru Yàlla Aji Kawe ji, waaye ñale mayuñu leen ko. ");
INSERT INTO wol2010_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Ndaxte ku am, dinañu la dollil, ba nga barele; waaye ku amul, li nga am as néew, dinañu ko nangu. ");
INSERT INTO wol2010_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","“Dañuy xool te duñu gis, di déglu waaye duñu dégg te duñu xam,” moo tax ma di leen wax ciy léeb. ");
INSERT INTO wol2010_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Li Esayi waxoon ci kàddug Yàlla am na ci ñoom, bi mu naan: “Dingeen déglu bu baax waaye dungeen xam dara; di xool bu baax waaye dungeen gis dara. ");
INSERT INTO wol2010_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Ndaxte xolu xeet wii dafa dërkiis; dañuy déglu ak nopp yu naqari, tey gëmm seeni bët, ngir baña gis ak seeni bët, dégg ak seeni nopp, te xam ci seen xol, ñu waññiku ci man, ma wéral leen.” ");
INSERT INTO wol2010_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","«Waaye yéen barkeel ngeen, ndaxte seeni bët a ngi gis te seeni nopp di dégg! ");
INSERT INTO wol2010_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Ndaxte ci dëgg maa ngi leen koy wax, ay yonent yu bare ak nit ñu jub ñu bare bëggoon nañu gis li ngeen di gis waaye gisuñu ko, te dégg li ngeen di dégg waaye dégguñu ko. ");
INSERT INTO wol2010_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","«Yéen nag dégluleen li léebu beykat biy tekki. ");
INSERT INTO wol2010_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Boo xamee ne nit mu ngi déglu wax ju jëm ci nguuru Yàlla te xamu ko, Ibliis day ñëw, këf li ñu def ci xolam; kooku mooy ki jot ci jiwu wi ci kaw yoon wi. ");
INSERT INTO wol2010_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Ki jot ci jiwu wi ci bérab bu bare ay doj nag, mooy ki dégg wax ji, am ci bànneex bu gaaw; ");
INSERT INTO wol2010_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","waaye du yàgg, ndaxte wax ji saxul ci moom. Bu jaaree ci nattu nag, mbaa ñu fitnaal ko ndax kàddu gi, mu dàggeeku ci saa si. ");
INSERT INTO wol2010_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Ki jot ci jiwu wi ci xaaxaam yi mooy ki dégg wax ji, waaye soxlay àddina ak naxi alal tanc wax ji, ba du jur njariñ. ");
INSERT INTO wol2010_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Ki jot ci jiwu wi ci suuf su baax si nag, mooy ki dégg wax ji te xam ko; mu jural ko njariñ, muy lu mat téeméeri yoon lu ëpp la ñu ji woon, muy juróom benn fukk mbaa fanweer.» ");
INSERT INTO wol2010_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Noonu Yeesu dégtal leen beneen léeb ne leen: «Nguuru Yàlla Aji Kawe ji dafa mel ni nit ku ji jiwu wu baax ci toolam. ");
INSERT INTO wol2010_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Waaye bi nit ñi di nelaw, noonam ñëw, ji jëmb ci biir dugub ji, daldi dem. ");
INSERT INTO wol2010_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Bi dugub ji saxee nag, jëmb bi saxaale ak moom. ");
INSERT INTO wol2010_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","«Noonu surgay boroom kër ga ñëw ci moom ne ko: “Góor gi, xanaa jiwuloo jiwu wu baax ci sa tool? Fu jëmb bi jóge nag?” ");
INSERT INTO wol2010_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Mu ne leen: “Noon a ko def.” Surga ya ne ko: “Ndax nu dem dindi ko?” ");
INSERT INTO wol2010_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Mu ne leen: “Déedéet, ngir baña buddiwaale dugub ji, bu ngeen koy dindi. ");
INSERT INTO wol2010_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Bàyyileen ñoom ñaar, ñu màgg, ba ngóob ma jot. Bu ngóob ma jotee nag, dinaa wax ñi koy góob: ‘Jëkkleena dindi jëmb bi, takk ko ay say, lakk ko, waaye ngeen semb dugub ji ci sama sàq.’ ”» ");
INSERT INTO wol2010_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Yeesu waxaat leen beneen léeb ne leen: «Nguuru Yàlla Aji Kawe ji dafa mel ni doomu fuddën bu nit jël, ji ko ci toolam. ");
INSERT INTO wol2010_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Doomu fuddën moo gëna tuuti ci jiwu yépp, waaye bu saxee, mooy sut ci gàncaxi tóokër yi, di nekk garab, ba picci asamaan ñëw, tàgg ciy caram.» ");
INSERT INTO wol2010_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Yeesu teg ca beneen léeb ne leen: «Nguuru Yàlla Aji Kawe ji dafa mel ni lawiir bu jigéen jël, jaxase ko ak ñetti andaari fariñ, ba kera tooyal bépp di funki.» ");
INSERT INTO wol2010_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Loolu Yeesu wax mbooloo ma, ëmb na ko lépp ciy léeb, te waxuleen dara lu dul ciy léeb. ");
INSERT INTO wol2010_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Noonu am la ñu waxoon jaarale ko cib yonent, bi mu naan: «Dinaa leen wax ciy léeb, di yégle yëf yu nëbbu li dale ca njàlbéen ga ba bésu tey.» ");
INSERT INTO wol2010_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Ci kaw loolu Yeesu bàyyi mbooloo ma, dugg ca kër ga. Taalibeem yi ñëw ci moom ne ko: «Firil nu léebu jëmb, bi sax ci tool bi.» ");
INSERT INTO wol2010_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Noonu Yeesu ne leen: «Doomu nit ki mooy ji jiwu wu baax wi; ");
INSERT INTO wol2010_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","àddina mooy tool bi; ñi bokk ci nguuru Yàlla ñoo di jiwu wu baax wi; ñi bokk ci Ibliis ñooy jëmb bi; ");
INSERT INTO wol2010_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Seytaane mooy noon bi ko ji; tukkitel àddina mooy ngóob mi, te malaaka yi ñooy góobkat yi. ");
INSERT INTO wol2010_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Ni ñu dajalee jëmb ba, lakk ko, noonu lay nekke, bu àddina tukkee. ");
INSERT INTO wol2010_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Doomu nit ki dina yebal ay malaakaam, ñu jële ci nguuram lépp luy yóbbe nit bàkkaar, ak ñiy def bàkkaar, ");
INSERT INTO wol2010_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","sànni leen ci sawara; foofa dees na fa jooy te yéyu. ");
INSERT INTO wol2010_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Booba nag ñu jub ñi dinañu leer ni jant bi ci seen nguuru Baay. Déglul bu baax, yaw mi am ay nopp.» ");
INSERT INTO wol2010_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Yeesu teg ca ne: «Nguuru Yàlla Aji Kawe ji dafa mel ni alal ju nëbbu cib tool. Nit ki ko gis nëbbaat ko; xolam sedd, ba mu dem jaay li mu am lépp, jënd tool ba. ");
INSERT INTO wol2010_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","«Te it nguuru Yàlla Aji Kawe ji dafa mel ni jaaykat buy wut per yu rafet. ");
INSERT INTO wol2010_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Am bés mu gis per buy jar njég lu réy. Mu dem nag, jaay li mu am lépp, jënd ko.» ");
INSERT INTO wol2010_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","Yeesu waxaat ne: «Nguuru Yàlla Aji Kawe ji dafa mel ni mbaal mu ñu wàcce ci géej, mu jàpp jën wu nekk. ");
INSERT INTO wol2010_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Bi mbaal mi feesee nag, ñu ñoddi ko ci tefes gi, ba noppi ñu taxaw, dajale yu baax yi ciy ndab, waaye sànni yi bon. ");
INSERT INTO wol2010_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Noonu lay mel, bu àddina tukkee. Malaaka yi dinañu génn, tànn ñu bon ñi ci biir ñu jub ñi, ");
INSERT INTO wol2010_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","sànni leen ci sawara. Foofa dees na fa jooy te yéyu.» ");
INSERT INTO wol2010_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Noonu Yeesu laaj taalibe ya ne leen: «Loolu lépp, ndax xam ngeen lu muy tekki?» Ñu ne ko: «Waaw.» ");
INSERT INTO wol2010_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Yeesu ne leen: «Kon nag xutbakat bu nekk bu jàng ci nguuru Yàlla Aji Kawe ji, dafa mel ni boroom kër buy génne ci dencukaayam yu bees ak yu màggat.» ");
INSERT INTO wol2010_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Bi nga xamee ne Yeesu dégtal na léeb yooyu ba noppi, mu jóge fa, ");
INSERT INTO wol2010_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","dem fa mu yaroo. Mu di leen jàngal ci seen jàngu, ba ñu waaru ne: «Xam-xam bii ak kéemaan yii, fu mu ko jële? ");
INSERT INTO wol2010_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Ndax kii du doomu minise bi, te ndeyam tudd Maryaama? Ndax rakkam yu góor duñu Saag, Yuusufa, Simoŋ ak Yuda? ");
INSERT INTO wol2010_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Te ay rakkam yu jigéen, ndax nekkuñu fi ak nun? Lii lépp nag, fu mu ko jële?» ");
INSERT INTO wol2010_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Kon ñu daldi koy xeeb. Noonu Yeesu ne leen: «Dees na faaydaal yonent, waaye du ci réewam ak ci këram.» ");
INSERT INTO wol2010_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Te Yeesu defu fa kéemaan yu bare ndax seen ngëmadi. ");
INSERT INTO wol2010_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Ca jamono joojale Erodd boroom diiwaanu Galile dégg na tur, wa Yeesu am. ");
INSERT INTO wol2010_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Noonu mu ne ay surgaam: «Kooku mooy Yaxya mi dekki; moo tax mu ànd ak kàttanu def ay kéemaan.» ");
INSERT INTO wol2010_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Ndaxte Erodd jàppoon na Yaxya, yeew ko, tëj. Ndaxte Erodd takkoon na Erojàdd jabaru Filib magam, ");
INSERT INTO wol2010_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","te Yaxya daan ko wax: «Jaaduwul nga denc ko.» ");
INSERT INTO wol2010_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Erodd nag bëgg koo rey, waaye dafa ragal nit ñi, ci li ñu teg Yaxya ab yonent. ");
INSERT INTO wol2010_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Bi ñu ca tegee ab diir nag, ñuy màggal bés ba Erodd juddu woon, te doomu Erojàdd ju jigéen di fecc ci biir gan ñi. Loolu neex Erodd, ");
INSERT INTO wol2010_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","ba mu dig ko ci kaw ngiñ ne ko: «Loo laaj, dinaa la ko jox.» ");
INSERT INTO wol2010_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Noonu ndaw sa daldi topp la ko ndey ji digaloon, ne Erodd: «Indil ma fii ci biir ndab boppu Yaxya.» ");
INSERT INTO wol2010_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Bi ko buur ba déggee, mu am naqar, waaye ngiñ la ak gan ña tax mu santaane, ñu jox ko ko. ");
INSERT INTO wol2010_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Mu yónnee nag, ngir ñu dagg boppu Yaxya ca kaso ba. ");
INSERT INTO wol2010_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Ñu indi bopp bi ci biir ndab, jox ko janq ba, mu jox ko ndeyam. ");
INSERT INTO wol2010_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Noonu taalibey Yaxya ñëw, fab néew ba, suul ko; ba noppi dem, wax ko Yeesu. ");
INSERT INTO wol2010_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Bi Yeesu déggee deewu Yaxya nag, mu jóge fa, dugg cig gaal, di dem ca bérab bu wéet. Waaye bi ko nit ñi yégee, ñu daldi jóge ci dëkk yi, topp ko ak seeni tànk. ");
INSERT INTO wol2010_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Yeesu génn ci gaal gi nag, gis mbooloo mu réy, mu yërëm leen, ba faj ñi ci wopp. ");
INSERT INTO wol2010_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Ca ngoon sa taalibe yi ñëw ci moom ne ko: «Fii àllub neen la, te léegi mu guddi. Doo yiwi mbooloo mi, ngir ñu dem ci dëkk yu ndaw yi, jënd lu ñu mana lekk?» ");
INSERT INTO wol2010_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Waaye Yeesu ne leen: «Matul ñu dem, yéen joxleen leen lu ñu lekk.» ");
INSERT INTO wol2010_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Ñu ne ko: «Amunu fi lu dul juróomi mburu ak ñaari jën.» ");
INSERT INTO wol2010_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Yeesu ne leen: «Indil-leen ma ko fii.» ");
INSERT INTO wol2010_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Ci kaw loolu Yeesu sant mbooloo ma, ñu toog ca ñax ma. Mu jël juróomi mburu ya ak ñaari jën ya, xool ci kaw, sant Yàlla. Mu damm mburu ma, jox ko taalibe ya, ñu séddale ko nit ña. ");
INSERT INTO wol2010_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Noonu ñépp lekk ba suur. Te ñu dajale dammit ya ca des, mu nekk fukki pañe ak ñaar yu fees. ");
INSERT INTO wol2010_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Gannaaw jigéen ña ak gone ya, góor ña doon lekk matoon nañu juróomi junni. ");
INSERT INTO wol2010_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Bi loolu amee Yeesu sant taalibe ya, ñu dugg gaal ga te jàll dex ga, jiituji ko, muy yiwi mbooloo ma. ");
INSERT INTO wol2010_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Bi mu ko yiwee nag, mu yéeg ca tund wa, ngir wéet ak Yàlla. Noonu guddi jot, fekk mu nekk fa moom rekk. ");
INSERT INTO wol2010_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Bi mu fa nekkee nag, gaal ga sore na tefes ga, te duus ya di ko yëngal bu metti, ndax ngelaw la leen soflu. ");
INSERT INTO wol2010_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Ca njël nag Yeesu jëm ci ñoom, di dox ci kaw dex gi. ");
INSERT INTO wol2010_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Waaye bi ko taalibe yi gisee, muy dox ci kaw dex ga, ñu daldi jommi naan: «Njuuma la!» daldi tiit bay yuuxu. ");
INSERT INTO wol2010_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Waaye ca saa sa Yeesu ne leen: «Takkleen seen fit, man la, buleen tiit!» ");
INSERT INTO wol2010_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Ci kaw loolu Piyeer jël kàddu gi ne ko: «Sang bi, bu dee yaw, sant ma, ma dox ci kaw ndox mi, ñëw ci yaw.» ");
INSERT INTO wol2010_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Yeesu ne ko: «Kaay!» Piyeer nag wàcc ca gaal ga, di dox ci kaw ndox mi, jëm ci Yeesu. ");
INSERT INTO wol2010_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Waaye bi mu gisee ni ngelaw li mettee, mu daldi tiit, tàmbalee suux. Mu woote ne: «Sang bi, wallu ma!» ");
INSERT INTO wol2010_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Ca saa sa Yeesu tàllal loxoom, jàpp ko naan: «Yaw mi néew ngëm, lu tax nga am xel ñaar?» ");
INSERT INTO wol2010_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Noonu ñu dugg ca gaal ga, ngelaw li ne tekk. ");
INSERT INTO wol2010_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Ñi nekk ci gaal gi nag sukk ci kanamam ne ko: «Ci dëgg yaa di Doomu Yàlla ji.» ");
INSERT INTO wol2010_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Bi loolu amee ñu jàll, teer ca diiwaanu Senesaret. ");
INSERT INTO wol2010_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Ña fa dëkk xàmmi Yeesu, yónnee nag ca diiwaan bépp, indil ko ñu wopp ñépp. ");
INSERT INTO wol2010_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Noonu ñu ñaan ko, mu may leen ñu laal cati mbubbam rekk, te ku ko laal daldi wér. ");
INSERT INTO wol2010_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Ca jamono jooja amoon na bés ay Farisen ak ay xutbakat jóge Yerusalem, ñëw ci Yeesu ne ko: ");
INSERT INTO wol2010_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","«Lu tax say taalibe di moy aaday yoon, yi maam yi tëral? Ndaxte duñu raxas seeni loxo, bu ñuy lekk.» ");
INSERT INTO wol2010_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Waaye Yeesu ne leen: «Yéen itam lu tax ngeen di moy li Yàlla santaane, ngir topp seeni aada? ");
INSERT INTO wol2010_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Yàlla nee na: “Teralal sa ndey ak sa baay,” te it: “Ku móolu sa ndey walla sa baay, dees na la rey.” ");
INSERT INTO wol2010_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Waaye yéen dangeen ne: “Ku wax sa ndey walla sa baay: ‘Li ngeen wara jariñoo ci man, jébbal naa ko Yàlla,’ ");
INSERT INTO wol2010_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","kooku amatul warugaru teral baayam.” Noonu tebbi ngeen kàddug Yàlla ndax seen aada. ");
INSERT INTO wol2010_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Yéen ñi naaféq, Esayi waxoon na bu baax ci kàddug Yàlla ci seen mbir, bi mu naan: ");
INSERT INTO wol2010_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","“Xeet wii ñu ngi may teral ci seen gémmiñ, waaye seen xol sore na ma. ");
INSERT INTO wol2010_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Seen màggal amul benn njariñ, ci li ñuy jàngle dénkaaney nit kese.”» ");
INSERT INTO wol2010_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Noonu Yeesu woo mbooloo mi ci moom ne leen: «Dégluleen te xam: ");
INSERT INTO wol2010_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","du li dugg ci gémmiñ mooy indil nit sobe, waaye li ciy génne mooy indil nit sobe.» ");
INSERT INTO wol2010_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Bi taalibeem ya déggee loolu, ñu ñëw ci moom ne ko: «Ndax xam nga ne, Farisen yi dañoo mer ndax loolu nga wax?» ");
INSERT INTO wol2010_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Yeesu ne leen: «Garab gu sama Baay bi ci kaw jiwul, dees na ko buddi. ");
INSERT INTO wol2010_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Bàyyileen leen, ay gumba lañu yuy wommat ay gumba; bu gumba dee wommat moroomam nag, kon dinañu daanu ñoom ñaar ci kàmb.» ");
INSERT INTO wol2010_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Piyeer nag jël kàddu gi, laaj Yeesu: «Firil nu léeb wi.» ");
INSERT INTO wol2010_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Noonu Yeesu ne ko: «Ndax ba tey seen xol dafa tëju, yéen itam? ");
INSERT INTO wol2010_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Xamuleen ne, lépp lu dugg ci gémmiñ, ci biir lay jëm tey génn ca bérab bu làqu? ");
INSERT INTO wol2010_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Waaye li génn ci gémmiñ mu ngi jóge ci xol; loolu mooy indil nit sobe. ");
INSERT INTO wol2010_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Ndaxte ci xol la xalaat yu bon di jóge, ak bóom, njaaloo, ndoxaanu yàqute, càcc, seede lu dul dëgg ak saaga. ");
INSERT INTO wol2010_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Yooyu ñooy indil nit sobe, waaye lekk ak loxo yoo raxasul du tax nit am sobe.» ");
INSERT INTO wol2010_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Gannaaw loolu Yeesu jóge fa, dem ci diiwaanu Tir ak Sidon. ");
INSERT INTO wol2010_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Ba mu fa àggee nag, jigéenu waa Kanaan, ja dëkk ca wàll yooyu, daldi génn, di wax ca kaw ne ko: «Yaw sang bi, Sëtu Daawuda bi, yërëm ma! Rab jàpp na sama doom ju jigéen, te dafa sonn lool.» ");
INSERT INTO wol2010_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Waaye Yeesu waxu ko dara. Ay taalibeem nag ñëw ci moom ne ko: «Doo ko yiwi, mu ngi nuy topp, di yuuxu ci sunu kaw.» ");
INSERT INTO wol2010_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Yeesu ne: «Yónniwuñu ma, lu dul ci xari bànni Israyil yu réer.» ");
INSERT INTO wol2010_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Waaye jigéen ja ñëw, sukk ci kanamam naan: «Sang bi, wallusi ma!» ");
INSERT INTO wol2010_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Yeesu ne ko: «Jël ñamu gone yi, sànni ko xaj yi, rafetul.» ");
INSERT INTO wol2010_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Waaye jigéen ja ne ko: «Waaw, sang bi, teewul xaj yi di lekk ruusit, yi rot ci seen lekkukaayu boroom.» ");
INSERT INTO wol2010_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Ci kaw loolu Yeesu ne ko: «Yaw jigéen ji, sa ngëm réy na; na am, ni nga ko bëgge.» Noonu doomam daldi wér ca saa sa. ");
INSERT INTO wol2010_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Bi loolu amee Yeesu jóge foofa, ñëw ci weti dexu Galile; mu yéeg ca aw tund, toog fa. ");
INSERT INTO wol2010_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Ba mu fa nekkee, nit ñu bare ñëw ci moom, indaale ay lafañ, ay làggi, ay gumba, ay luu ak ñeneen ñu bare. Ñu teg leen ci tànki Yeesu, mu faj leen. ");
INSERT INTO wol2010_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Nit ñépp waaru, ndaxte gis nañu luu yuy wax, làggi yu wér, lafañ yuy dox, ak gumba yuy gis. Ñu daldi màggal Yàlla Buuru Israyil. ");
INSERT INTO wol2010_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Gannaaw loolu Yeesu woo ci moom taalibeem ya ne leen: «Yërëm naa mbooloo mi, ndaxte toog nañu fi man ñetti fan, te amatuñu lu ñu lekk. Bëgguma leena yiwi te lekkuñu, ngir bañ ñu tële ci yoon wi.» ");
INSERT INTO wol2010_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Noonu taalibeem ya laaj ko: «Waaye fu nuy jële ci àll bi mburu mu doy ngir mbooloo mu tollu nii?» ");
INSERT INTO wol2010_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Yeesu ne leen: «Ñaata mburu ngeen am?» Ñu ne ko: «Juróom ñaari mburu ak ay jën yu ndaw.» ");
INSERT INTO wol2010_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Ci kaw loolu Yeesu sant mbooloo mi, ñu toog ci suuf. ");
INSERT INTO wol2010_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Mu fab juróom ñaari mburu yi ak jën yi, sant Yàlla, damm leen, jox leen taalibe yi, ñu séddale leen mbooloo mi. ");
INSERT INTO wol2010_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Noonu ñépp lekk ba suur. Te ñu dajale juróom ñaari dàmba yu fees ak dammit yi ci des. ");
INSERT INTO wol2010_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Gannaaw jigéen ñi ak gone yi, góor ñi ci lekk matoon nañu ñeenti junni. ");
INSERT INTO wol2010_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Noonu Yeesu yiwi mbooloo mi, dugg ci gaal, ñëw ci wàlli Magadan. ");
INSERT INTO wol2010_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Amoon na ay Farisen ak ay Sadusen yu ñëw ci Yeesu. Ñu fexe koo fiir, ba laaj ko ne: «Won nu kéemaan guy firndeel sag yónnent, te mu jóge ci asamaan.» ");
INSERT INTO wol2010_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Noonu Yeesu ne leen: «Ngoon gi dangeen naan: “Du taw suba ndax asamaan si dafa xonq.” ");
INSERT INTO wol2010_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Te suba gi ngeen naan: “Tey daal dina taw, ndax asamaan si dafa xonq te xiin.” Kon man ngeena ràññee melow asamaan, waaye manuleena ràññee firndey jamono ji nu tollu. ");
INSERT INTO wol2010_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Yéenay laaj firnde, yéen niti jamono ju bon jii, yéen ñi fecci seen kóllëre ak Yàlla. Waaye dungeen jot genn firnde gu dul firndeg Yunus.» Bi Yeesu waxee loolu, mu jóge ci ñoom, dem. ");
INSERT INTO wol2010_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Gannaaw loolu taalibe yi jàllaat dex gi, fekk fàtte nañoo yóbbaale mburu. ");
INSERT INTO wol2010_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Noonu Yeesu ne leen: «Wottuleen te moytu lawiiru Farisen ya ak Sadusen ya.» ");
INSERT INTO wol2010_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Bi ko taalibe yi déggee, ñu daldi werante ci seen biir naan: «Nun de indaalewunu mburu.» ");
INSERT INTO wol2010_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Waaye Yeesu yég loolu ne leen: «Yéen ñi néew ngëm, lu tax ngeen di werante ci seen biir, ndaxte indaalewuleen mburu? ");
INSERT INTO wol2010_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Ndax xamaguleen ba tey? Xanaa fàttalikuwuleen juróomi mburu ya ngir juróomi junniy góor ña, ak ñaata pañe ngeen dajale woon ciy dammit? ");
INSERT INTO wol2010_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Te ndax fàttalikuwuleen itam juróom ñaari mburu ya ngir ñeenti junniy góor ña, ak ñaata dàmba ngeen dajale woon ciy dammit? ");
INSERT INTO wol2010_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Kon nag lu tax xamuleen ne waxuma mburu? Waaye damaa bëgg, ngeen moytu lawiiru Farisen ya ak Sadusen ya.» ");
INSERT INTO wol2010_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Noonu ñu xam ne, Yeesu waxul woon lawiiru mburu, waaye ñu moytu njànglem Farisen ya ak Sadusen ya. ");
INSERT INTO wol2010_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Bi ñu fa jógee, Yeesu dem ca diiwaanu Sesare bu Filib. Foofa mu laaj taalibeem ya: «Lu nit ñiy wax ci Doomu nit ki; mooy kan?» ");
INSERT INTO wol2010_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Taalibe yi ne: «Am na ñu naan, Yaxya, ñeneen ñi, Ilyaas; ñi ci des ne, Yeremi walla keneen ci yonent yi.» ");
INSERT INTO wol2010_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Noonu Yeesu ne leen: «Waaye yéen, ku ngeen may teg?» ");
INSERT INTO wol2010_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Ci kaw loolu Simoŋ Piyeer ne: «Yaa di Almasi bi, Doomu Yàlla Aji Dund ji.» ");
INSERT INTO wol2010_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Yeesu ne ko: «Barkeel ñeel na la, Simoŋ doomu Yunus, ndaxte du nit moo la xamal lii, waaye sama Baay bi nekk ci kaw. ");
INSERT INTO wol2010_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Te maa ngi lay wax lii: yaa di Piyeer, te ci kaw doj wu réy woowu laay samp mbooloom ñi ma gëm, te dooley dee du ko manal dara. ");
INSERT INTO wol2010_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Dinaa la jox caabiy nguuru Yàlla Aji Kawe ji; li nga yeew ci àddina, dees na ko yeew ci asamaan; li nga yiwi ci àddina dees na ko yiwi ci asamaan.» ");
INSERT INTO wol2010_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Noonu Yeesu dénk taalibe yi bu wóor ne leen: «Buleen wax kenn ne maay Almasi bi.» ");
INSERT INTO wol2010_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Li dale ci jamono jooja, Yeesu tàmbali na xamal taalibeem yi ne war na dem Yerusalem, daj fa coono yu bare, jóge ca njiit ya, ca sarxalkat yu mag ya ak ca xutbakat ya; ñu rey ko, mu dekki ca ñetteelu fan ba. ");
INSERT INTO wol2010_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Bi mu waxee ba noppi, Piyeer woo ko ci pegg, bëgg koo yedd ne ko: «Yàlla tere, Boroom bi, loolu du la dal.» ");
INSERT INTO wol2010_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Waaye Yeesu waññiku, daldi ne Piyeer: «Sore ma Seytaane, bu ma xatal; yëfi nit ngay fonk, waaye du yëfi Yàlla.» ");
INSERT INTO wol2010_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Gannaaw loolu Yeesu ne taalibeem ya: «Ku bëgga aw ci samay tànk, na bàyyi boppam, te gàddu bant bi ñu ko wara daaj, doora topp ci man. ");
INSERT INTO wol2010_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Ndaxte koo xam ne bëgg ngaa rawale sa bakkan, dinga ko ñàkk, waaye ku ñàkk sa bakkan ngir man, jotaat ko. ");
INSERT INTO wol2010_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Te it moom àddina sépp lu muy jariñ nit, bu ñàkkee bakkanam? Te nit, lu mu wara weccee bakkanam? ");
INSERT INTO wol2010_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Ndaxte Doomu nit ki dina ñëw ci ndamul Baayam, ànd ak ay malaakaam; bés booba dina delloo ku nekk ay jëfam. ");
INSERT INTO wol2010_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Ci dëgg maa ngi leen koy wax, am na ñi fi taxaw, ñoo xam ne duñu dee, te gisuñu Doomu nit ki ñëw ci nguuram.» ");
INSERT INTO wol2010_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Juróom benni fan gannaaw gi, Yeesu àndoon na ak Piyeer, Saag ak Yowaana rakkam, yóbbu leen fu wéet ci tund wu kawe lool. ");
INSERT INTO wol2010_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Mu soppiku fa seen kanam, xar kanamam di melax nib jant, te ay yéreem weex ni leer. ");
INSERT INTO wol2010_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Naka noonu ñu gis yonenti Yàlla Musaa ak Ilyaas, di waxtaan ak Yeesu. ");
INSERT INTO wol2010_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Piyeer nag daldi wax Yeesu ne ko: «Sang bi, bég nanu ci sunu teew fii; soo ko bëggee, dinaa fi defar ñetti mbaar, benn yaw, benn Musaa ak benn Ilyaas.» ");
INSERT INTO wol2010_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Waaye bi muy wax, niir wu leer muur leen, te baat jib ca niir wa naan: «Kii mooy sama Doom ji ma bëgg, ci moom laa ame bànneex; dégluleen ko.» ");
INSERT INTO wol2010_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Bi taalibe yi déggee baat bi, ñu ne nërëm ci suuf, daldi tiit lool. ");
INSERT INTO wol2010_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Waaye Yeesu jegeñsi, laal leen naan: «Jógleen, buleen ragal dara.» ");
INSERT INTO wol2010_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Noonu ñu xool ci kaw, waaye gisatuñu kenn ku dul Yeesu rekk. ");
INSERT INTO wol2010_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Bi loolu amee ñu wàcc ca tund wa. Bi ñuy wàcc nag, Yeesu sant leen ne: «Buleen nettali kenn li ngeen gis, ba kera Doomu nit ki dekki.» ");
INSERT INTO wol2010_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Noonu taalibe ya laaj ko: «Lu tax xutbakat ya nag di wax ne, Ilyaas mooy jëkka ñëw?» ");
INSERT INTO wol2010_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Yeesu ne leen: «Waaw, dëgg la, Ilyaas war na ñëw, jubbanti lépp. ");
INSERT INTO wol2010_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Teewul maa ngi leen di wax ne, Ilyaas ñëw na te xàmmiwuñu ko, waaye def nañu ko la leen neex. Noonu it dañoo nara sonal léegi Doomu nit ki.» ");
INSERT INTO wol2010_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Ndax wax jooju nag, taalibe ya xam ne ci mbirum Yaxya la leen doon wax. ");
INSERT INTO wol2010_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Bi nga xamee ne wàcc nañu, ba ñëw ca mbooloo ma, genn góor ñëw ci moom, sukk ");
INSERT INTO wol2010_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","naan: «Sang bi, yërëmal sama doom, ndaxte mu ngi say, di am coono bu metti; léeg-léeg mu daanu ci sawara, léeg-léeg mu daanu ci ndox. ");
INSERT INTO wol2010_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Indi naa ko ci say taalibe, waaye manuñu koo faj.» ");
INSERT INTO wol2010_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Noonu Yeesu ne: «Yéen niti jamono jii, yéen ñi gëmadi te dëng, ba kañ laa wara nekk ak yéen, ba kañ laa leen di wara muñal?» Mu ne leen: «Indil-leen ma xale bi fii.» ");
INSERT INTO wol2010_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Noonu Yeesu tëkku rab wa, rab wa génn ca xale ba, mu daldi wér ca saa sa. ");
INSERT INTO wol2010_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Bi loolu amee taalibe ya ñëw ci Yeesu, laaj ko ci pegg: «Lu tax nun manunu woona dàq rab wi?» ");
INSERT INTO wol2010_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","21","Yeesu ne leen: «Seen ngëm gu néew a tax. Ci dëgg maa ngi leen koy wax, su ngeen amee ngëm gu tuuti sax niw peppu fuddën, kon dingeen ne tund wii: “Jógeel fii, toxu fale,” te dina fa dem, ba dara du leen të.» ");
INSERT INTO wol2010_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Bi ñuy wër diiwaanu Galile nag, Yeesu ne leen: «Léegi ñu jébbal Doomu nit ki ci loxoy nit ñi; ");
INSERT INTO wol2010_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","dinañu ko rey, mu dekki ca ñetteelu fan ba.» Bi ko taalibe ya déggee, ñu am naqar lool. ");
INSERT INTO wol2010_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Gannaaw loolu Yeesu ak taalibe ya ñëw Kapernawum. Bi ñu fa àggee nag, laajkati warugaru kër Yàlla ga ñëw ci Piyeer ne ko: «Ndax seen kilifa du fey posetu ñaari daraxma ngir warugar wi?» ");
INSERT INTO wol2010_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Piyeer ne leen: «Ahakay!» Ba ñu eggee kër ga nag, Yeesu jëkka wax ne Piyeer: «Waaw, lu ciy sa xalaat, Simoŋ? Buuri àddina si, ñan lañuy laaj juuti walla galag? Seeni doom walla ñi bokkul ci njaboot gi?» ");
INSERT INTO wol2010_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Piyeer ne ko: «Xanaa ñi bokkul ci kër gi.» Yeesu ne ko: «Kon doom yi nag mucc nañu ci. ");
INSERT INTO wol2010_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Waaye bëgguma nu naqaral leen; demal sànni oos ca dex ga te nga génne jën wa jëkka xëcc. Boo ubbee gémmiñam, dinga ca gis posetu estateer. Jël ko nag, jox leen ko ngir man ak yaw.» ");
INSERT INTO wol2010_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Ca waxtu woowu taalibe ya ñëwoon nañu ci Yeesu, laaj ko: «Kan moo gëna màgg ci nguuru Yàlla mi nekk ci kaw?» ");
INSERT INTO wol2010_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Noonu Yeesu woo xale, teg ko ci seen biir, ");
INSERT INTO wol2010_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","ne leen: «Ci dëgg maa ngi leen koy wax, su ngeen waññikuwul ci Yàlla, ba mel niy xale, dungeen dugg mukk ci nguuru Yàlla Aji Kawe ji. ");
INSERT INTO wol2010_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Kuy suufeelu nag, ba mel ni xale bii, kooku mooy ki gëna màgg ci nguuru Yàlla Aji Kawe ji. ");
INSERT INTO wol2010_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Te it ku nangu ci sama tur xale bu mel ni kii, man mii nga nangu. ");
INSERT INTO wol2010_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Waaye ku yóbbe bàkkaar kenn ci ñi gëna tuuti ñi ma gëm, li gën ci moom mooy ñu takk doj wu réy ci baatam, sànni ko ca fa gëna xóot ca géej ga. ");
INSERT INTO wol2010_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","«Yaw àddina, dinga torox ndax say fiir yiy yóbbe nit bàkkaar. Fiir manta ñàkk, waaye toroxte dal na nit ki koy lal. ");
INSERT INTO wol2010_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Boo xamee ne sa loxo mbaa sa tànk mu ngi lay yóbbe bàkkaar, dagg ko, sànni ko fu sore. Ndaxte nga lafañ walla ñàkk loxo te dugg ci dund gu wóor gi, moo gën ci yaw, nga am ñaari loxo walla ñaari tànk, te ñu sànni la ci sawara su dul fey mukk. ");
INSERT INTO wol2010_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Boo xamee ne sa bët mu ngi lay yóbbe bàkkaar, luqi ko, sànni ko fu sore. Ndaxte nga patt te dugg ci dund gu wóor gi, moo gën ci yaw, nga am ñaari bët, te ñu sànni la ci sawara. ");
INSERT INTO wol2010_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","11","«Te it wottuleena xeeb kenn ci ñi gëna tuuti, ndax kat seeni malaakaa ngi sax ci jataayu sama Baay bi nekk ci kaw. Maa leen wax loolu. ");
INSERT INTO wol2010_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","«Luy seen xalaat ci lii? Su fi amoon nit ku am téeméeri xar, te benn ci ñoom réer, lu muy def? Ndax du bàyyi ca parlukaay ba juróom ñeent fukki xar ya ak juróom ñeent, te dem wuti ma réer? ");
INSERT INTO wol2010_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Bu ko gisee, mbég mi mu am ci moom mooy ëpp mbég, mi mu am ci juróom ñeent fukki xar ya ak juróom ñeent ya réerul. ");
INSERT INTO wol2010_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","«Noonu it seen Baay bi nekk ci kaw bëggul kenn ci ñi gëna tuuti sànku. ");
INSERT INTO wol2010_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","«Te lii itam, bu sa mbokk defee bàkkaar, demal yedd ko, yéen ñaar rekk. Bu la dégloo, kon gindi nga sa mbokk. ");
INSERT INTO wol2010_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Waaye bu la dégluwul, àndal ak kenn mbaa ñaar, ngir mbir mi dëggu ci li ko ñaar walla ñett seede. ");
INSERT INTO wol2010_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Bu leen dégluwul ñoom itam, wax ko mbooloom ñi gëm. Bu dégluwul mbooloo ma nag, nga teg ko ni ku gëmul Yàlla mbaa ab juutikat. ");
INSERT INTO wol2010_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Ci dëgg maa ngi leen koy wax, lépp lu ngeen yeew ci àddina, dees na ko yeew ci asamaan, te lépp lu ngeen yiwi ci àddina, dees na ko yiwi ci asamaan. ");
INSERT INTO wol2010_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","«Maa ngi leen koy wax it, bu ñaar ci yéen déggoo ci àddina, ngir ñaan lu mu mana doon, sama Baay bi nekk ci kaw dina leen ko may. ");
INSERT INTO wol2010_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Ndaxte fu ñaar walla ñetti nit booloo ci sama tur, maa ngi ci seen biir.» ");
INSERT INTO wol2010_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Noonu Piyeer ñëw ci Yeesu, laaj ko: «Boroom bi, bu ma sama mbokk tooñee, ñaata yoon laa ko wara baal? Xanaa ba ci juróom ñaari yoon?» ");
INSERT INTO wol2010_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Yeesu ne ko: «Waxuma la ba ci juróom ñaari yoon, waaye ba ci juróom ñaar fukki juróom ñaari yoon. ");
INSERT INTO wol2010_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","«Loolu moo tax nguuru Yàlla Aji Kawe ji dafa mel ni buur bu bëgga waññ alalam ak ay jaraafam. ");
INSERT INTO wol2010_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Ba mu tàmbalee waññ nag, ñu indil buur ba ku ko ameel ay milyoŋ yu baree bare, ");
INSERT INTO wol2010_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","waaye jaraaf ja amul lu mu feye. Kon nag sangam santaane, ñu jaay ko moom ak soxnaam ak ay doomam ak lépp lu mu am, ngir fey bor ba. ");
INSERT INTO wol2010_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Kon jaraaf ja daanu ciy tànkam ne ko: “Muñal ma, dinaa la fey lépp.” ");
INSERT INTO wol2010_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Noonu sangam yërëm ko, bàyyi ko, baal ko bor ba. ");
INSERT INTO wol2010_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","«Bi loolu amee jaraaf ja génn, gis benn moroomu jaraafam bu ko ameel ay junni. Mu daldi ko jàpp, poñe ko ne ko: “Fey ma li nga ma ameel.” ");
INSERT INTO wol2010_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Kon moroomam daanu ci suuf, ñaan ko ne: “Muñal ma, dinaa la fey.” ");
INSERT INTO wol2010_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Waaye moom nanguwu ko, mu dem, tëj ko kaso, ba kera mu fey li mu ko ameel. ");
INSERT INTO wol2010_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","«Bi ay moroomam gisee loolu nag, ñu am naqar wu réy, daldi dem, xamal seen sang li xew lépp. ");
INSERT INTO wol2010_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Sang ba nag woolu jaraaf ba ne ko: “Yaw jaraaf ju soxor nga! Baal naa la sa bor bépp, ndaxte tinu nga ma. ");
INSERT INTO wol2010_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Lu tax yaw itam yërëmoo sa moroom, ni ma la yërëme?” ");
INSERT INTO wol2010_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Noonu sang ba mer, jébbal ko ñiy fitnaale ca kaso ba, ba kera muy fey li mu ko ameel lépp. ");
INSERT INTO wol2010_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","«Noonu la leen sama Baay bi ci kaw di def, bu ngeen baalul ku nekk seen mbokk ak xol bu sedd.» ");
INSERT INTO wol2010_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Bi nga xamee ne Yeesu wax na loolu ba noppi, mu jóge Galile, dem ci wàllu réewu Yawut yi, gi féete ci gannaaw dexu Yurdan. ");
INSERT INTO wol2010_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Mbooloo mu bare topp ko, mu faj leen fa. ");
INSERT INTO wol2010_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Bi mu fa nekkee, ay Farisen ñëw ci moom, bëgg koo fiir; ñu ne ko: «Ndax jaadu na nit fase soxnaam, saa su ko neexee?» ");
INSERT INTO wol2010_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Yeesu ne leen: «Xanaa jànguleen ne, ca njàlbéen ga Aji Bind ji sàkk na leen, kii góor, kii jigéen, ");
INSERT INTO wol2010_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","te mu ne: “Looloo tax góor di teqalikook ndeyam ak baayam, ànd ak soxnaam, ñoom ñaar doon benn.” ");
INSERT INTO wol2010_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Kon nag nekkatuñu ñaar waaye benn lañu. Lu Yàlla takk nag, bu ko nit tas.» ");
INSERT INTO wol2010_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Bi Yeesu waxee loolu, Farisen ya laaj ko ne: «Waaye Musaa santaane na, nit jox soxnaam kayitu pase, tàggook moom. Lu tax mu wax loolu nag?» ");
INSERT INTO wol2010_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Yeesu ne leen: «Musaa may na leen, ngeen fase seen soxna, ndax seen xol dafa dëgër, waaye ca njàlbéen ga demewul woon noonu. ");
INSERT INTO wol2010_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Te it maa ngi leen koy wax, koo xam ne kii fase nga sa soxna te du njaaloo tax, boo séyaatee ak keneen, njaaloo nga.» ");
INSERT INTO wol2010_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Bi ko taalibe ya déggee, ñu ne ko: «Bu dee noonu la digganteb góor ak jigéen mel, baña séy moo gën.» ");
INSERT INTO wol2010_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Yeesu ne leen: «Du ñépp ñoo mana nangu loolu, waaye ñi ko Yàlla jagleel rekk. ");
INSERT INTO wol2010_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Ndaxte am na ñu judduwaale tële, am na ñu tële ci loxoy nit, te am na ñu baña séy ngir nguuru Yàlla Aji Kawe ji. Ku ko mana nangu, nangu ko.» ");
INSERT INTO wol2010_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Gannaaw loolu amoon na ay nit ñuy indil Yeesu ay xale, ngir mu teg leen ay loxoom, ñaanal leen. Waaye taalibe ya gëdd leen. ");
INSERT INTO wol2010_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Bi Yeesu gisee loolu, mu ne leen: «Bàyyileen xale yi, te buleen leen tere, ñu ñëw fi man. Ndaxte ñu mel ni ñoom, ñoo yelloo nguuru Yàlla Aji Kawe ji.» ");
INSERT INTO wol2010_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Noonu Yeesu teg leen ay loxoom, ba noppi jóge fa. ");
INSERT INTO wol2010_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Bi muy dem nag, nit daldi ñëw ci moom ne ko: «Kilifa gi, lan laa wara def ci lu baax, ngir mana am dund gu dul jeex?» ");
INSERT INTO wol2010_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Yeesu ne ko: «Lu tax nga laaj ma ci wàllu lu baax? Kenn kepp moo baax. Boo bëggee dugg ca dund googu ci kaw, nanga sàmm ndigal yi.» ");
INSERT INTO wol2010_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Waxambaane wa laaj ko: «Yan la?» Yeesu ne ko: «Yii: bul bóome, bul njaaloo, bul sàcc, bul seede lu dul dëgg, ");
INSERT INTO wol2010_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","teralal sa ndey ak sa baay, te it: nanga bëgg sa moroom, ni nga bëgge sa bopp.» ");
INSERT INTO wol2010_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Waxambaane wa ne ko: «Sàmm naa yooyu yépp, lu ma deseeti?» ");
INSERT INTO wol2010_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Noonu Yeesu ne ko: «Boo bëggee mat sëkk, demal jaay li nga am, jox ko miskin yi te dinga woomle ca asamaan. Boo noppee, ñëwal topp ci man.» ");
INSERT INTO wol2010_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Waaye bi waxambaane wa déggee loolu, mu jóge fa ak tiis, ndaxte ku bare woon alal la. ");
INSERT INTO wol2010_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Noonu Yeesu wax taalibeem ya ne leen: «Ci dëgg maa ngi leen koy wax, boroom alal dugg ci nguuru Yàlla Aji Kawe ji, lu jafee ngoogu! ");
INSERT INTO wol2010_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Ma waxaat leen ko: giléem jaar ci bën-bënu puso moo gëna yomb boroom alal dugg ci nguuru Yàlla Aji Kawe ji.» ");
INSERT INTO wol2010_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Bi nga xamee ne taalibe ya dégg nañu loolu, ñu daldi waaru lool ne ko: «Kan moo mana mucc nag?» ");
INSERT INTO wol2010_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Noonu Yeesu xool leen ne: «Loolu të na nit, waaye dara tëwul Yàlla.» ");
INSERT INTO wol2010_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Bi ko Piyeer déggee, mu daldi ne: «Waaw, nun nag, dëddu nanu lépp, topp la; kon nu nuy mujje nun?» ");
INSERT INTO wol2010_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Yeesu ne leen: «Ci dëgg maa ngi leen koy wax, bés baa ngi ñëw bu Yàllay yeesalaat lépp, te Doomu nit ki toog ci jalam, bi soloo ndam. Bés boobu nag, yéen ñi ma topp dingeen toog ci fukki jal ak ñaar, di àtte fukki giir ak ñaar yu bànni Israyil. ");
INSERT INTO wol2010_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Koo xam ne kii dëddu nga ngir sama tur ay kër, ay doomi ndey yu góor walla yu jigéen, ndey walla baay, ay doom walla ay tool, dinga ko jotaat téeméeri yoon, ba noppi am dund gu dul jeex. ");
INSERT INTO wol2010_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Waaye ñu bare ci ñi jiitu, ñooy mujji; ñi mujj, ñooy jiituji. ");
INSERT INTO wol2010_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","«Noonu nguuru Yàlla Aji Kawe ji dafa mel ni boroom kër bu génn ci suba teel, ngir jël ay liggéeykat ndax toolu reseñam. ");
INSERT INTO wol2010_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Mu juboo ak liggéeykat ya ci bëccëg posetu denariyon, door leena yebal ca toolam. ");
INSERT INTO wol2010_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Ci yoor-yoor mu génn, gis ñeneen ñu toog ca pénc ma te liggéeyuñu. ");
INSERT INTO wol2010_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Mu ne leen: “Demleen yéen itam ca tool ba, te dinaa leen fey lu jaadu.” ");
INSERT INTO wol2010_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Ñu dem ca. Mu génnaat ci digg bëccëg ak ci tisbaar, defaat noonu. ");
INSERT INTO wol2010_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Mu génnati ci tàkkusaan, gis ñeneen di tendeefal. Mu ne leen: “Lu tax ngeen yendoo tendeefal, te liggéeyiwuleen?” ");
INSERT INTO wol2010_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Ñu ne ko: “Kenn jëlu nu.” Mu ne leen: “Demleen yéen itam ca tool ba.” ");
INSERT INTO wol2010_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","«Bi nga xamee ne timis jot na, boroom tool ba ne jawriñ ja: “Woowal liggéeykat yi te fey leen seen bëccëg, tàmbali ci ñi mujja ñëw, ba ci ñi fi jëkk.” ");
INSERT INTO wol2010_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Noonu ñi mu jël ci tàkkusaan ñëw, ku nekk jot posetu denariyon. ");
INSERT INTO wol2010_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Gannaaw ga nag ñi mu jëkka jël ñëw, yaakaar ne dinañu jot lu ëpp loolu, waaye ñoom itam ñu jot ku nekk benn denariyon. ");
INSERT INTO wol2010_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Bi ñu ko jotee nag, ñu tàmbalee ñaxtu ca boroom kër ga, ");
INSERT INTO wol2010_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","naan: “Ñi mujja ñëw, benn waxtu rekk lañu liggéey, ba noppi nga yemale leen ak nun, ñi yenu coonob bëccëg bi ak naaj wu metti wi.” ");
INSERT INTO wol2010_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Waaye boroom kër ga ne kenn ci ñoom: “Sama waay tooñuma la. Ndax juboowunu woon ci benn denariyon? ");
INSERT INTO wol2010_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Kon fabal li nga moom te dem. Su ma bëggee fey ku mujja ñëw, li ma la fey yaw, ");
INSERT INTO wol2010_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","ndax sañumaa def ak sama alal li ma neex? Walla ndax danga am kiñaan ci li ma yéwén?” ");
INSERT INTO wol2010_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Noonu ñi mujj ñooy jiituji, ñi jiitu ñooy mujj.» ");
INSERT INTO wol2010_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Gannaaw loolu Yeesu di dem Yerusalem, ànd ak fukki taalibe yi ak ñaar. Noonu mu wéetoo ak ñoom, di leen xamal ci yoon wi lii: ");
INSERT INTO wol2010_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","«Nu ngi jëm Yerusalem, te dees na jébbal Doomu nit ki sarxalkat yu mag ya ak xutbakat ya. Dinañu ko àtte, teg ko dee, ");
INSERT INTO wol2010_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","jébbal ko ñi dul Yawut, ngir ñu di ko ñaawal te di ko dóor ay yar, ba noppi daaj ko ci bant. Waaye ca ñetteelu fan ba dina dekki.» ");
INSERT INTO wol2010_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Ci kaw loolu doomi Sebede ya ànd ak seen ndey, ñëw ci Yeesu. Ndey ja sukk, di ko ñaansi lenn. ");
INSERT INTO wol2010_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Yeesu ne ko: «Loo bëggoon?» Mu ne ko: «Damaa bëggoon nga santaane ne, boo nekkee ci sa nguur, sama ñaari doom ñii toog ak yaw, kenn ci sa ndijoor, ki ci des ci sa càmmoñ.» ");
INSERT INTO wol2010_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Yeesu ne ko: «Xamuleen li ngeen di ñaan. Ndax man ngeena naan kaasu naqar, bi may naan?» Ñu ne ko: «Man nañu ko.» ");
INSERT INTO wol2010_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Yeesu ne leen: «Ci dëgg dingeen naan sama kaas, waaye toog ci sama ndijoor mbaa sama càmmoñ, du man maa koy maye, waaye sama Baay moo koy may ñi mu ko waajal.» ");
INSERT INTO wol2010_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Bi nga xamee ne fukki taalibe ya dégg nañu loolu, ñu mere ñaari doomi ndey ya. ");
INSERT INTO wol2010_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Waaye Yeesu woo leen ne leen: «Xam ngeen ne ci xeeti àddina, njiit yi dañu leen di dóor yetu nguur, te kilifa yi dañu leen di not. ");
INSERT INTO wol2010_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Buleen mel ni ñooñu. Waaye ku bëgga nekk kilifa ci yéen, na nekk seen surga, ");
INSERT INTO wol2010_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","te ku bëgga nekk njiit, na nekk seen jaam. ");
INSERT INTO wol2010_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Ndaxte noonu la Doomu nit ki ñëwe, du ngir ñu nekk ay surgaam, waaye muy seen surga, ba joxe bakkanam ngir njotug ñu bare.» ");
INSERT INTO wol2010_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Gannaaw loolu Yeesu génn Yeriko, te mbooloo mu bare topp ko. ");
INSERT INTO wol2010_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Fekk ñaari gumba toog ci wetu yoon wa. Bi gumba ya déggee ne Yeesu di jaar, ñu daldi yuuxu ne ko: «Sang bi, yaw Sëtu Daawuda bi, yërëm nu!» ");
INSERT INTO wol2010_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Waaye nit ña gëdd leen, ngir ñu noppi. Teewul gumba ya gëna yuuxu naan: «Sang bi, yaw Sëtu Daawuda bi, yërëm nu!» ");
INSERT INTO wol2010_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Noonu Yeesu daldi taxaw, woo leen ne: «Lu ngeen bëgg, ma defal leen ko?» ");
INSERT INTO wol2010_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Ñu ne ko: «Sang bi, na sunuy bët ubbiku.» ");
INSERT INTO wol2010_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Noonu Yeesu yërëm leen, laal seeni bët, ñu daldi gis ca saa sa, topp ci moom. ");
INSERT INTO wol2010_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Gannaaw loolu Yeesu ak taalibe ya jege woon nañu Yerusalem, ba agsi dëkku Betfase ci wetu tundu Oliw ya. Noonu Yeesu yebal ñaari taalibe, ");
INSERT INTO wol2010_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","ne leen: «Demleen ci dëkk bi ci seen kanam. Bu ngeen eggee, dingeen gis mbaam mu ñu yeew ak cumburam; yiwileen leen, indil ma leen. ");
INSERT INTO wol2010_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Te bu leen kenn waxee dara, ngeen ne ko: “Boroom bi da leena soxla.” Kon ca saa sa dina leen bàyyi, ñu dem.» ");
INSERT INTO wol2010_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Yeesu def na noonu, ngir la ñu waxoon jaarale ko cib yonent am, bi mu naan: ");
INSERT INTO wol2010_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","«Waxal waa Siyoŋ: “Seen buur a ngi ñëw ci yéen; ku lewet la, te war mbaam-sëf, dig cumbur, doomu mbaam.”» ");
INSERT INTO wol2010_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Noonu taalibe ya dem, def loolu leen Yeesu sant. ");
INSERT INTO wol2010_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Ñu indi mbaam ma, moom ak cumbur ga, lal ci seeni yére, Yeesu toog ca. ");
INSERT INTO wol2010_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Ña ëpp ca mbooloo ma lal seeni yére ca yoon wa, ñenn ña dagg ay cari garab, lal leen it ca yoon wa. ");
INSERT INTO wol2010_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Mbooloom ña ko jiitu ak ña ko topp ñépp di wax ca kaw naan: «Osaana, yaw Sëtu Daawuda bi! Yaw miy ñëw ci turu Boroom bi, ku barkeel nga! Ca bérab yu gëna kawe, nañu ne: “Osaana!”» ");
INSERT INTO wol2010_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Bi nga xamee ne Yeesu dugg na Yerusalem, dëkk ba bépp yëngatu ne: «Kii moo di kan?» ");
INSERT INTO wol2010_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Mbooloo ma ne leen: «Kii moo di yonentu Yàlla Yeesu, bi jóge Nasaret ci Galile.» ");
INSERT INTO wol2010_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Bi loolu amee Yeesu dugg ca kër Yàlla ga, dàq ñépp ña fay jaay ak ña fay jënd. Mu daaneel taabali weccikatu xaalis ya ak tooguy jaaykati pitax ya, ");
INSERT INTO wol2010_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","naan: «Mbind mi nee na: “Sama kër dinañu ko wooye këru ñaan ci Yàlla,” waaye yéen def ngeen ko këru sàcc.» ");
INSERT INTO wol2010_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Noonu ay gumba ak ay lafañ ñëw ci moom ca kër Yàlla ga, mu faj leen. ");
INSERT INTO wol2010_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Bi nga xamee ne sarxalkat yu mag ya ak xutbakat ya gis nañu yëf yu doy waar ya mu def, te dégg xale yu ndaw ya nekk ca kër Yàlla ga, di wax ci kaw naan: «Osaana, yaw Sëtu Daawuda bi!» ñu daldi mer. ");
INSERT INTO wol2010_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Noonu ñu ne Yeesu: «Ndax dégg nga li ñuy wax?» Yeesu ne leen: «Waaw, dégg naa ko. Ndax masuleena jàng lii ci Mbind mi: “Ci gémmiñu perantal ak ñiy nàmp sàkkal nga sa bopp ay cant”?» ");
INSERT INTO wol2010_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Bi Yeesu waxee loolu, mu bàyyi leen, génn dëkk ba, jëm Betani, fanaan fa. ");
INSERT INTO wol2010_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Ci suba teel Yeesu délsi ca dëkk ba, mu xiif. ");
INSERT INTO wol2010_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Noonu mu séen garabu figg ca yoon wa, waaye bi mu fa agsee, gisu ci dara lu dul ay xob rekk. Ci kaw loolu Yeesu ne ko: «Dootuloo meññ mukk!» Ca saa sa figg ga daldi wow. ");
INSERT INTO wol2010_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Bi nga xamee ne taalibe ya gis nañu loolu, ñu waaru naan: «Nan la figg gi daldi wowe ci taxawaay bi?» ");
INSERT INTO wol2010_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Noonu Yeesu ne leen: «Ci dëgg maa ngi leen koy wax, su ngeen gëmee te baña werante, dingeen def li ma def figg gi, rax-ca-dolli bu ngeen nee tund wale: “Jógal tàbbi ca géej ga,” dina ko def. ");
INSERT INTO wol2010_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Te lépp lu ngeen laaj cig ñaan, bu ngeen ci boolee ngëm, dingeen ci jot.» ");
INSERT INTO wol2010_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Gannaaw loolu Yeesu dugg ca kër Yàlla ga, di fa jàngle. Bi muy jàngle nag sarxalkat yu mag ya ak njiiti xeet wa ñëw ci moom ne ko: «Yëf yii ngay def, ci ban sañ-sañ nga koy defe? Ku la may boobu sañ-sañ?» ");
INSERT INTO wol2010_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Yeesu ne leen: «Man itam dinaa leen laaj lenn; bu ngeen ma ko waxee, kon dinaa leen wax ci ban sañ-sañ laay defe yëf yii. ");
INSERT INTO wol2010_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","La Yaxya daan def, di sóob nit ñi ci ndox, fu mu ko jële, ci Yàlla walla ci nit ñi?» Ci kaw loolu ñu daldi werante ci seen biir naan: «Bu nu nee: “Ci Yàlla,” dina nu laaj: “Lu tax gëmuleen ko kon?” ");
INSERT INTO wol2010_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Te bu nu nee: “Ci nit ñi,” kon mbooloo mi dal ci sunu kaw, ndaxte ñépp teg nañu Yaxya ab yonent.» ");
INSERT INTO wol2010_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Ñu ne Yeesu nag: «Loolu xamunu ko.» Noonu Yeesu ne leen: «Kon man itam duma leen wax ci ban sañ-sañ laay defe yëf yii. ");
INSERT INTO wol2010_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","«Lu di seen xalaat ci lii? Kenn nit amoon na ñaari doom. Am bés mu ñëw ca taaw ba ne ko: “Sama doom, demal tey liggéeyi ca sama toolu reseñ.” ");
INSERT INTO wol2010_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Taaw ba ne ko: “Demuma,” waaye gannaaw loolu xelam yedd ko, mu dem. ");
INSERT INTO wol2010_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Gannaaw gi, baay ba ñëw ca tofo ba, wax ko noonu. Mu ne ko: “Waaw,” waaye demul.» ");
INSERT INTO wol2010_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Noonu Yeesu laaj leen: «Kan ci ñaari doom yooyu moo def coobarey baayam?» Ñu ne: «Taaw ba.» Yeesu ne leen: «Ci dëgg maa ngi leen koy wax, juutikat yi ak jigéeni moykat yi ñoo leen jëkka dugg ci nguuru Yàlla Aji Kawe ji. ");
INSERT INTO wol2010_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Ndaxte Yaxya ñëw na ci yéen ci yoonu njub, te gëmuleen ko; waaye juutikat yi ak jigéeni moykat yi gëm nañu ko. Te gannaaw bi ngeen gisee loolu, seen xel soppikuwul sax, ba ngeen gëm ko.» ");
INSERT INTO wol2010_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Yeesu teg ca ne: «Dégluleen beneen léeb. Amoon na fi benn boroom kër bu jëmbët toolu reseñ. Mu ñag tool bi, gas ci biir pax, ngir nal ci reseñ yi. Mu tabax wottukaay, batale ko ay beykat, daldi tukki. ");
INSERT INTO wol2010_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","«Bi nga xamee ne bëgg nañoo witt reseñ yi, mu yónni ay surgaam ci beykat yi, ngir jot wàllam ci meññeef mi. ");
INSERT INTO wol2010_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Waaye beykat yi jàpp surga yi, kenn ki ñu dóor ko ay yar, keneen ki ñu rey ko, ki ci des ñu sànni ko ay doj. ");
INSERT INTO wol2010_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Boroom kër gi nag yónniwaat yeneen surga yu ëpp yu jëkk ya, beykat yi def leen noonu ñoom itam. ");
INSERT INTO wol2010_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Mujj mu yónni doomam naan: “Xëy na ñu weg sama doom.” ");
INSERT INTO wol2010_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Waaye bi beykat yi gisee doom ji, ñu ne ci seen bopp: “Kii moo wara donn tool bi; nan ko rey, moom ndonoom.” ");
INSERT INTO wol2010_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Ñu jàpp ko nag, génne ko tool bi, rey ko.» ");
INSERT INTO wol2010_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Noonu Yeesu laaj leen: «Bu boroom tool bi ñëwee nag, na muy def beykat yi?» ");
INSERT INTO wol2010_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Ñu ne ko: «Dina rey reyin wu ñaaw nit ñu soxor ñooñu, batale tool bi yeneen beykat, yi koy jox wàllam ci jamonoy meññeef.» ");
INSERT INTO wol2010_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Kon Yeesu ne leen: «Xanaa masuleena jàng lii ci Mbind yi? “Doj wi tabaxkat yi sànni; mujj na di doju koñ; ci Boroom bi la loolu jóge, te yéemu nanu ci.” ");
INSERT INTO wol2010_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","«Loolu moo tax maa ngi leen koy wax, dinañu leen xañ nguuru Yàlla, dénk ko xeet wuy def ay jëfam. ");
INSERT INTO wol2010_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Ku dal ci doj wii, dammtoo; ku mu dal ci sa kaw, rajaxe la.» ");
INSERT INTO wol2010_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Bi nga xamee ne sarxalkat yu mag ya ak Farisen ya dégg nañu léebam yooyu, ñu xam ne ñoom lay wax. ");
INSERT INTO wol2010_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Noonu ñu di ko fexee jàpp, waaye ragal nañu nit ña, ndaxte ñépp teg nañu ko ab yonent. ");
INSERT INTO wol2010_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Gannaaw loolu Yeesu nettali leen beneen léeb ne leen: ");
INSERT INTO wol2010_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","«Nguuru Yàlla Aji Kawe ji dafa mel ni buur buy waajal céetu doomam ju góor. ");
INSERT INTO wol2010_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Noonu mu yónni ay surgaam, ngir ñu woo gan yi ca céet ga, waaye gan yi bëgguñoo ñëw. ");
INSERT INTO wol2010_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Kon mu yónneeti yeneen surga ne leen: “Bu ngeen demee, yégal-leen gan yi sama woote bii: ‘Reer yi noppi na, reylu naa samay nag ak samay jur gu duuf; lépp sotti na, ñëwleen ci reer yi.’ ” ");
INSERT INTO wol2010_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Waaye ba tey wuyuwuñu ko; ñu dem, kenn ki ca toolam, kenn ki jaayaani, ");
INSERT INTO wol2010_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","ña ca des jàpp surga ya, toroxal leen, rey leen. ");
INSERT INTO wol2010_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","«Noonu buur mer, daldi yónni ay xarekatam, ngir ñu rey bóomkat yooyule, lakk seen dëkk. ");
INSERT INTO wol2010_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Ci kaw loolu mu ne surga ya: “Reeri céet gi noppi na, waaye ñi ñu woo yeyoowuñu ko. ");
INSERT INTO wol2010_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Demleen nag buntu dëkk ba, woo ku ngeen fa gis ci reeri céet gi.” ");
INSERT INTO wol2010_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Noonu surga ya génn ca yoon ya, boole ña ñu fa gis ñépp, ñu bon ña ak ñu baax ña, ba néegu reer ya fees ak ay gan. ");
INSERT INTO wol2010_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","«Bi nga xamee ne buur bi dugg na nag, ngir seetsi gan yi, mu gis fa nit ku solul mbubb mu ñu wara sol ca céet ga. ");
INSERT INTO wol2010_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Buur ne ko: “Sama waay, naka nga dugge fii, te amuloo mbubbum céet?” Waa ji ne miig. ");
INSERT INTO wol2010_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Noonu buur ba ne ay surgaam: “Yeewleen ko ci tànk yi ak ci loxo yi, sànni ko ci biti ci lëndëm gi. Foofa dees na fa jooy tey yéyu.” ");
INSERT INTO wol2010_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Ndaxte ñi ñu woo bare nañu, waaye ñi ñu tànn barewul.» ");
INSERT INTO wol2010_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Booba Farisen ya dem gise, ba xam lu ñu wara def, ngir fiir Yeesu ci waxam. ");
INSERT INTO wol2010_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Noonu ñu yónni ci moom seeni taalibe ak ñi far ak buur bi Erodd ne ko: «Kilifa gi, xam nanu ne ku wóor nga, te ragaloo kenn, ndaxte seetuloo jëmmi nit, waaye dangay xamle yoonu Yàlla ci bu wóor. ");
INSERT INTO wol2010_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Wax nu nag loo xam ci lii: ndax jaadu na, nu fey buur bi Sesaar galag walla déet?» ");
INSERT INTO wol2010_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Waaye Yeesu xam seen njublaŋ, mu ne leen nag: «Lu tax ngeen bëgg maa fiir, yéen naaféq yi? ");
INSERT INTO wol2010_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Wonleen ma poset, bi ñuy feye galag.» Ñu daldi ko jox nag benn posetu denariyon. ");
INSERT INTO wol2010_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Yeesu ne leen: «Kan lañu ci def nataalam ak turam?» ");
INSERT INTO wol2010_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Ñu ne ko: «Sesaar.» Noonu mu ne leen: «Joxleen nag Sesaar li Sesaar moom, te jox Yàlla li Yàlla moom.» ");
INSERT INTO wol2010_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Bi nga xamee ne dégg nañu loolu, ñu waaru, bàyyi ko, daldi dem. ");
INSERT INTO wol2010_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Bés boobale ay Sadusen ñëw ci moom. Sadusen yi nag ñoom gëmuñu ne ndekkite am na. Noonu ñu laaj ko naan: ");
INSERT INTO wol2010_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","«Kilifa gi, Musaa nee woon na: “Boo xamee ne góor dee na te amul doom, na rakkam donn jabaram, ngir sàkkal magam njaboot.” ");
INSERT INTO wol2010_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Amoon na ci nun nag juróom ñaari góor, ñu bokk ndey ak baay. Taaw ba am jabar ba noppi, faatu; rakk ja donn jabar ja, ndaxte amul woon doom. ");
INSERT INTO wol2010_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Ñaareel ba ak ñetteel ba def noonu, ba ci juróom ñaareel ba. ");
INSERT INTO wol2010_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Gannaaw ñoom ñépp, jigéen ja faatu. ");
INSERT INTO wol2010_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Bu ndekkite taxawee nag, jabaru kan lay doon ci juróom ñaar ñi, ndaxte ñépp jël nañu ko?» ");
INSERT INTO wol2010_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Waaye Yeesu ne leen: «Yéena ngi cig réer, ndaxte xamuleen Mbind mi mbaa kàttanu Yàlla. ");
INSERT INTO wol2010_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Ndaxte keroog ndekkite li kenn du am jabar, kenn du am jëkkër, waaye dinañu mel ni malaaka yi ci kaw. ");
INSERT INTO wol2010_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Te lu jëm ci ndekkitel ñi dee, xanaa masuleena jàng la leen Yàlla waxoon ne: ");
INSERT INTO wol2010_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","“Maay Yàllay Ibraayma ak Yàllay Isaaxa ak Yàllay Yanqóoba”? Li ciy génn mooy, nekkul Yàllay ñi dee waaye Yàllay ñiy dund la.» ");
INSERT INTO wol2010_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Bi nga xamee ne mbooloo ma dégg nañu loolu, ñu waaru ndax li mu jàngle. ");
INSERT INTO wol2010_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Gannaaw gi, Farisen ya yég nañu ne yey na Sadusen ya. Kon nag ñu daldi daje. ");
INSERT INTO wol2010_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Noonu kenn ci ñoom, ka nekk xutbakat, fexe koo fiir. Mu laaj ko: ");
INSERT INTO wol2010_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","«Kilifa gi, ban ndigal moo gëna màgg ci yoonu Musaa?» ");
INSERT INTO wol2010_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Yeesu ne ko: «“Nanga bëgg Yàlla sa Boroom ak sa xol bépp ak sa bakkan bépp ak sa xel mépp.” ");
INSERT INTO wol2010_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Loolu moo di li jëkk te ëpp ci li Yàlla santaane. ");
INSERT INTO wol2010_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Te ñaareel bi noona la mel: “Nanga bëgg sa moroom, ni nga bëgge sa bopp.” ");
INSERT INTO wol2010_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Ñaari ndigal yooyu tënk nañu yoonu Musaa wépp, moom ak waxi yonent yi.» ");
INSERT INTO wol2010_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Bi Farisen ya dajee nag, Yeesu laaj leen: ");
INSERT INTO wol2010_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","«Lu ngeen xalaat ci Almasi bi; kan la nekk sëtam?» Ñu ne ko: «Daawuda.» ");
INSERT INTO wol2010_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Noonu Yeesu ne leen: «Lu tax nag Daawuda, bi muy wax ci kàttanu Xelu Yàlla mi, di ko wooye “Boroom bi” ne: ");
INSERT INTO wol2010_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","“Boroom bi wax na sama Boroom: ‘Toogal ci sama ndijoor, ba kera may daaneel say noon ci sa kanam.’ ” ");
INSERT INTO wol2010_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Gannaaw Daawuda nag wooye na ko: “Boroom bi,” nu muy nekke sëtam?» ");
INSERT INTO wol2010_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Ci kaw loolu kenn manu koo tontu genn kàddu. Te li dale ci bés booba kenn ñemeetu koo laaj dara. ");
INSERT INTO wol2010_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Gannaaw loolu Yeesu waxoon na mbooloo ma ak taalibeem ya ne leen: ");
INSERT INTO wol2010_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","«Xutbakat ya ak Farisen ya ñu ngi toog ci jalu Musaa. ");
INSERT INTO wol2010_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Lépp lu ñu leen wax nag, defleen ko te sàmm ko, waaye buleen roy seeni jëf, ndaxte dañuy wax waaye duñu ko jëfe. ");
INSERT INTO wol2010_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Dañuy takk say yu diis, yen leen ci nit ñi, waaye duñu ko nangoo laal sax ak seen cati baaraam. ");
INSERT INTO wol2010_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Dañuy def seeni jëf yépp, ngir nit ñi gis leen, di takk ay téere yu réy, tey réyal seeni laari mbubb. ");
INSERT INTO wol2010_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Ca reeri xew yi, toogu yu yiw lañuy taamu, tey féete kanam ca jàngu ya. ");
INSERT INTO wol2010_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Dañoo bëgg ñépp nuyoo leen ñaari loxo ca pénc ma, di leen wooye “kilifa gi.” ");
INSERT INTO wol2010_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Waaye yéen buñu leen wooye “kilifa gi,” ndaxte kenn rekk moo di seen Kilifa, te yéen ñépp ay bokk ngeen. ");
INSERT INTO wol2010_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Te buleen tudde kenn seen “baay” ci àddina, ndaxte kenn rekk moo di seen Baay, ki ci kaw. ");
INSERT INTO wol2010_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Buñu leen tudde it ay “njiit,” ndaxte kenn rekk moo di seen Njiit, mooy Kirist. ");
INSERT INTO wol2010_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Ki gëna mag ci yéen mooy ki nangoo nekk seen surga. ");
INSERT INTO wol2010_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Kuy yékkatiku dees na la suufeel; kuy suufeelu, ñu yékkati la. ");
INSERT INTO wol2010_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","14","«Yéen xutbakat yi ak Farisen yi, naaféq yi, dingeen torox! Ndaxte yéena ngi tëj nguuru Yàlla Aji Kawe ji ci kanam nit ñi; yéen dungeen ci dugg, te dungeen bàyyi ku ci bëgga dugg, mu dugg ci. ");
INSERT INTO wol2010_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","«Yéen xutbakat yi ak Farisen yi, naaféq yi, dingeen torox! Ndaxte yéena ngi wër géej ak suuf, ngir sàkku benn taalibe, ba noppi ngeen def ko nitu sawara, ku leen yées ñaari yoon. ");
INSERT INTO wol2010_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","«Yéen njiit yu gumba yi, dingeen torox! Yéena ngi wax ne: “Ku giñe kër Yàlla gi, ngiñ li duggul, waaye ku giñ ci wurusu kër Yàlla gi, dugg na.” ");
INSERT INTO wol2010_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Yéen ñi dof te gumba! Lan moo gëna màgg, wurus wi walla kër Yàlla, gi tax wurus wi sell? ");
INSERT INTO wol2010_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Dangeen ne it: “Ku giñe sarxalukaay bi ci kër Yàlla gi, ngiñ li duggul, waaye ku giñ ci sarax si ci kawam, dugg na.” ");
INSERT INTO wol2010_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Gumba yi! Lan moo gëna màgg, sarax si walla sarxalukaay bi tax sarax si sell? ");
INSERT INTO wol2010_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Ku giñe sarxalukaay bi, giñ nga ci sarxalukaay bi ak li ci kawam lépp. ");
INSERT INTO wol2010_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Ku giñe kër Yàlla gi, giñ nga ci kër Yàlla gi ak ki ci dëkk. ");
INSERT INTO wol2010_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Ku giñ ci asamaan, giñ nga ci jalu Buur Yàlla ak ki ci toog. ");
INSERT INTO wol2010_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","«Yéen xutbakat yi ak Farisen yi, naaféq yi, dingeen torox! Ndaxte yéena ngi sàkk asaka ci naana ak anet ak kumin, te sàggane yi gëna màgg ci yoonu Musaa, maanaam njub, yërmande ak ngëm. Loolu ngeen wara def, waxuma nag ngeen bàyyi la ca des. ");
INSERT INTO wol2010_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Yéen njiit yu gumba yi! Yéena ngi segg wallax-njaan, tey wann giléem. ");
INSERT INTO wol2010_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","«Yéen xutbakat yi ak Farisen yi, naaféq yi, dingeen torox! Ndaxte yéena ngi setal bitib kaas bi ak ndab li, waaye ci biir dafa fees ak càcc ak ëppal. ");
INSERT INTO wol2010_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Farisen yu gumba yi! Jëkkleena setal biir kaas bi ak ndab li, ngir biti bi itam set. ");
INSERT INTO wol2010_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","«Yéen xutbakat yi ak Farisen yi, naaféq yi, dingeen torox! Ndaxte yéena ngi mel ni bàmmeel yu ñu weexal. Ci biti am nañu melo wu rafet, waaye ci biir dañoo fees ak yaxi ñi dee ak tilim ju nekk. ");
INSERT INTO wol2010_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Yéen itam, ci ngistal dangeena mel ni ñu jub, waaye ci seen biir dangeen fees ak naaféq ak lu bon. ");
INSERT INTO wol2010_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","«Yéen xutbakat yi ak Farisen yi, naaféq yi, dingeen torox! Ndaxte yéena ngi tabax xabruy yonent yi, tey rafetal bàmmeeli ñu jub ñi. ");
INSERT INTO wol2010_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Te yéena ngi wax ne: “Bu nu fekke woon sunu jamonoy maam, dunu ànd ak ñoom ciy tuur deretu yonent yi.” ");
INSERT INTO wol2010_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Seede ngeen nii ne yey ngeen seen bopp, te yéenay doomi ñi doon rey yonent yi, ");
INSERT INTO wol2010_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","di aw seen tànki baay, ba yées leen sax. ");
INSERT INTO wol2010_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Yéen ñi mel ni ay jaan, te fees ak daŋar niy co, naka ngeen di mucce mbugalu sawara? ");
INSERT INTO wol2010_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Moo tax maa ngi leen di yónnee ay yonent ak ay boroom xam-xam ak ay xutbakat. Ñenn ñi dingeen leen rey te daaj leen ci bant; ñeneen ñi dingeen leen dóor ay yar ci seeni jàngu, di leen fitnaal ci dëkkoo dëkk. ");
INSERT INTO wol2010_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Noonu deretu ñi jub, ji ñu tuur jépp ci àddina, dina xëppu ci seen kaw, li dale ci deretu Abel mi jub, ba ci deretu Sakari doomu Baraki, mi ngeen rey ci diggante bérab bu sell bi ak sarxalukaay bi. ");
INSERT INTO wol2010_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Ci dëgg maa ngi leen koy wax, loolu lépp dina dal ci niti jamono jii. ");
INSERT INTO wol2010_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","«Yerusalem, Yerusalem, yaw miy rey yonent yi, tey sànni ay doj ndaw yi, ba ñu dee, aka maa bëggoona dajale say doom, ni ginaar di uufe ay cuujam, te nanguwuleen! ");
INSERT INTO wol2010_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Kon nag Yàlla dina bërgël seen kër, ba mu gent. ");
INSERT INTO wol2010_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Ndaxte maa ngi leen koy wax, dungeen ma gisati li dale tey, ba kera ngeen ne: “Yaw miy ñëw ci turu Boroom bi, ku barkeel nga!”» ");
INSERT INTO wol2010_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Bi Yeesu waxee ba noppi, mu génn ca kër Yàlla ga, dem. Noonu ay taalibeem ñëw ci moom, ngir won ko tabaxi kër Yàlla ga. ");
INSERT INTO wol2010_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Mu ne leen: «Du gis ngeen yii yépp? Ci dëgg maa ngi leen koy wax, lii lépp dina daanu, ba doj dootul des ci kaw doj.» ");
INSERT INTO wol2010_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Noonu bi nga xamee ne Yeesu toog na ca tundu Oliw ya, taalibeem ya ñëw ci moom cig wet. Ñu ne ko: «Wax nu kañ la loolu di am, te luy tegtale ne yaa ngi ñëw te àddina di tukki?» ");
INSERT INTO wol2010_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Yeesu ne leen: «Moytuleen, bu leen kenn nax. ");
INSERT INTO wol2010_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Ndaxte ñu bare dinañu ñëw ci sama tur ne: “Maa di Kirist,” te dinañu nax ñu bare. ");
INSERT INTO wol2010_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Dingeen dégg ay xare ak coowi xare; wottuleen, buleen ci tiit, ndaxte loolu war na am, waaye booba mujug jamono ji jotagul. ");
INSERT INTO wol2010_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Xeet dina jóg, xeex ak weneen xeet, réew xeex ak meneen réew. Dina am ay xiif ak ay yëngu-yënguy suuf ci bérab yu bare. ");
INSERT INTO wol2010_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Waaye loolu lépp mooy ndoortel metit yi, mel ni jigéen juy matu. ");
INSERT INTO wol2010_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","Bu boobaa dees na leen jébbale, mitital leen, rey leen; te xeet yépp dinañu leen bañ ndax sama tur. ");
INSERT INTO wol2010_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Bu loolu amee ñu bare dinañu dàggeeku, di booleente tey bañante. ");
INSERT INTO wol2010_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Te it ñu bare ñuy mbubboo turu yonent dinañu feeñ, nax nit ñu bare. ");
INSERT INTO wol2010_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Te gannaaw lu bon day law, mbëggeelug ñi ëpp dina wàññiku. ");
INSERT INTO wol2010_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Waaye ku muñ ba ca muj ga, mucc. ");
INSERT INTO wol2010_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Noonu xibaaru jàmm bii ci nguuru Yàlla, dees na ko yégle ci àddina sépp, ngir mu nekk seede ci xeet yépp. Bu loolu amee mujug jamono ji jot. ");
INSERT INTO wol2010_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","«Dina am bés bu li ñuy wax: “Lu araam luy yàqe” dina tege ca bérab bu sell ba. Mooy li ñu doon wax jaarale ko ci yonent Yàlla Dañeel; ku ko jàng, nanga ko xam. ");
INSERT INTO wol2010_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Bu ngeen gisee loolu nag, ku nekk ci biir diiwaanu Yude, nanga daw ca tund ya; ");
INSERT INTO wol2010_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","ku nekk ci kaw taax ma, bul wàcc ngir fab say yëf, ya nekk ci biir kër ga; ");
INSERT INTO wol2010_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","ku nekk ca tool ba, bul ñibbi ngir fab sa mbubb. ");
INSERT INTO wol2010_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Ngalla jigéen ñi ëmb ca bés yooyu, ngalla it ñiy nàmpal! ");
INSERT INTO wol2010_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Ñaanleen nag seen gàddaay bumu nekk jamonoy seddaayu lolli, walla bésub noflaay bi. ");
INSERT INTO wol2010_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Ndaxte booba dina am metit wu réy wu masula am, ba àddina sosoo ak tey, te dootul am mukk. ");
INSERT INTO wol2010_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Te bu ñu wàññiwul bés yooyu, kenn du mucc, waaye dees na leen wàññi ndax ñi Yàlla tànn. ");
INSERT INTO wol2010_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","«Booba nag, bu leen kenn waxee: “Kaayleen gis, Kirist a ngi fi,” mbaa: “Mu nga fale,” buleen ko gëm. ");
INSERT INTO wol2010_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Ndaxte ñi mbubboo turu Kirist ak ñi mbubboo turu yonent dinañu feeñ, di joxe ay firnde yu réy ak ay kéemaan, ba ciy nax sax ñi Yàlla tànn, su loolu manoona am. ");
INSERT INTO wol2010_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Wax naa leen ko lu jiitu. ");
INSERT INTO wol2010_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","«Bu ñu leen waxee nag: “Seetleen, mu nga nale ca àll ba,” buleen génn, mbaa ñu ne: “Seetleen, mu ngi nii ci biir kër gi,” buleen ko gëm. ");
INSERT INTO wol2010_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Ndaxte ni melax di fàqe penku, te lerax ba sowu, noonu la ñëwug Doomu nit ki di mel. ");
INSERT INTO wol2010_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Fa médd nekk, fa la tan yiy dajee. ");
INSERT INTO wol2010_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","«Gannaaw metitu bés yooyule nag, ca saa sa jant bi dina lëndëm te weer wi dootul leer; biddiiw yi dinañu fàq, daanu ci asamaan, te kàttani asamaan yi yëngu. ");
INSERT INTO wol2010_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Booba firnde ji taxaw, Doomu nit ki feeñ ci asamaan, te xeeti àddina sépp dinañu jooy. Dinañu gis Doomu nit ki di ñëw ci niiri asamaan si, ànd ak kàttan ak ndam lu réy. ");
INSERT INTO wol2010_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Dina yónni ay malaakaam ak baatu liit bu dégtu, ñu dajale ñi mu tànn ci ñeenti xébla yi, fa asamaan dale ba fu mu yem.» ");
INSERT INTO wol2010_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","Yeesu teg ca ne: «Jàngleen misaalu garabu figg ga. Boo xamee ne ay bànqaasam duy nañu, tey xobam sëq, xam ngeen ne nawet jege na. ");
INSERT INTO wol2010_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Noonu yéen itam bu ngeen gisee loolu lépp, xamleen ne jege na, mu ngi ci bunt bi sax. ");
INSERT INTO wol2010_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Ci dëgg maa ngi leen koy wax, niti jamono jii duñu wéy te loolu lépp amul. ");
INSERT INTO wol2010_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Asamaan ak suuf dinañu wéy, waaye samay wax du wéy mukk. ");
INSERT INTO wol2010_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","«Waaye bés booba walla waxtu wa, kenn xamul kañ lay doon; du malaaka yi ci kaw, du sax man Doom ji, waaye Baay bi rekk moo ko xam. ");
INSERT INTO wol2010_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Ni bési Nóoyin ya, noonu lay mel, bu Doomu nit ki di ñëw. ");
INSERT INTO wol2010_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Ndaxte ca bés ya jiitu mbënn ma, nit ñaa ngi doon lekk di naan, góor ñaa ngi doon takk jabar, tey maye seeni doom, ba bés ba Nóoyin duggee ca gaal ga; ");
INSERT INTO wol2010_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","xalaatuñu woon dara, ba kera ndoxum mbënn ma di dikk, yóbbu leen. Noonu lay mel ci ñëwug Doomu nit ki. ");
INSERT INTO wol2010_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","«Bu boobaa ci ñaar ñu nekk cib tool, dinañu jël kenn ki, bàyyi ki ci des. ");
INSERT INTO wol2010_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Ci ñaari jigéen ñuy wol ca ëtt ba, dinañu jël kenn ki, bàyyi ki ci des. ");
INSERT INTO wol2010_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Yewwuleen nag, ndaxte xamuleen bés bu seen Boroom di ñëw. ");
INSERT INTO wol2010_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Waaye xamleen lii: bu boroom kër gi xamoon, ci ban waxtu ci guddi la sàcc bi di ñëw, kon dina yewwu te du ko bàyyi, mu toj këram. ");
INSERT INTO wol2010_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Loolu moo tax yéen itam taxawleen jonn, ndaxte Doomu nit ki dina ñëw ci waxtu wu ngeen ko séenuwul.» ");
INSERT INTO wol2010_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Yeesu teg ca ne: «Kan moo nekk surga bu takku te teey, bu njaatigeem teg ci waa kër gi, ngir mu leen di dundal ca jamono ja? ");
INSERT INTO wol2010_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Bu njaatigeem ñëwee te gis muy def noonu, surga boobu dina am ngërëm. ");
INSERT INTO wol2010_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Ci dëgg maa ngi leen koy wax, njaatige bi dina ko teg ci alalam jépp. ");
INSERT INTO wol2010_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Waaye bu dee surga bu bon bu naan ci xelam: “Sama njaatige day yéexa ñëw,” ");
INSERT INTO wol2010_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","mu tàmbalee dóor ay bokki surgaam, di lekk te naan ak naankat ya, ");
INSERT INTO wol2010_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","kon njaatige ba dina ñëw ci bés bu mu ko séenuwul ak waxtu wu mu xamul. ");
INSERT INTO wol2010_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Dina ko dóor ay yar yu metti, jox ko añub naaféq. Foofa dees na fa jooy tey yéyu. ");
INSERT INTO wol2010_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","«Booba nguuru Yàlla Aji Kawe ji dina mel ni fukki janq, ñu fab seeni làmp, génn, gatanduji boroom séet ba. ");
INSERT INTO wol2010_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Fekk juróom ca janq ya di ñu am xel, juróom ya ca des ñàkk xel. ");
INSERT INTO wol2010_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Ñi ñàkk xel nag fab nañu seeni làmp, waaye fabaalewuñu diw; ");
INSERT INTO wol2010_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","waaye ñi am xel ñoom fab nañu seeni làmp, fabaale diw ciy njaq. ");
INSERT INTO wol2010_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Ni boroom séet bi yéexee ñëw nag, ñépp gëmméentu bay nelaw. ");
INSERT INTO wol2010_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","«Noonu ci xaaju guddi baat jib ne: “Boroom séet baa ngi, génnleen, gatandu ko.” ");
INSERT INTO wol2010_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Bi ko janq ya déggee, ñu jóg, defar seeni làmp. ");
INSERT INTO wol2010_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Ñi ñàkk xel wax ñi am xel: “Mayleen nu ci seen diw, ndaxte sunuy làmp ñu ngi bëgga fey.” ");
INSERT INTO wol2010_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Waaye ñi am xel ne leen: “Li nu yor du doy ngir nun ak yéen. Tee ngeena dem ca jaaykat ya, jënd?” ");
INSERT INTO wol2010_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","«Bi nga xamee ne dem nañu jëndi, boroom séet ba agsi. Ñi amoon diw ci seeni làmp, ànd ak boroom séet ba ca reer ya. Noonu bunt ba tëj. ");
INSERT INTO wol2010_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Gannaaw loolu janq ya ca des agsi naan: “Sang bi, Sang bi, ubbil nu!” ");
INSERT INTO wol2010_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Mu ne leen: “Ci dëgg maa ngi leen koy wax, xawma leen.” ");
INSERT INTO wol2010_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","«Yewwuleen nag, ndaxte xamuleen bés ba mbaa waxtu wa. ");
INSERT INTO wol2010_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","«Te it nguuru Yàlla dafa mel ni kuy tukki bitim réew. Bi muy laata dem, mu woo ay surgaam, batale leen alalam, ku nekk lu mu àttan. ");
INSERT INTO wol2010_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Kenn ka, mu dénk ko juróomi milyoŋ, keneen ka, mu dénk ko ñaar; ka ca des, benn; daldi tukki. ");
INSERT INTO wol2010_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","«Bi mu demee nag, ki jot juróomi milyoŋ ya dem, di ci jula, ba amaat yeneen juróom. ");
INSERT INTO wol2010_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Noonu it ki jot ñaar amaat yeneen ñaar. ");
INSERT INTO wol2010_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Waaye ki jot benn milyoŋ dem, gas pax, nëbb fa xaalisu njaatigeem. ");
INSERT INTO wol2010_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","«Gannaaw diir bu yàgg njaatigeb surga ya délsi, daldi leen laaj alalam. ");
INSERT INTO wol2010_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Noonu ki jot juróomi milyoŋ ya jegeñsi, indi yeneen juróom naan: “Kilifa gi, dénk nga ma juróomi milyoŋ; seetal, ame naa ci yeneen juróom.” ");
INSERT INTO wol2010_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Njaatigeem ne ko: “Def nga lu baax, surga bu baax nga te takku. Gannaaw takku nga ci lu tuuti, dinaa la dénk lu bare. Kaay bokk ci sama mbég.” ");
INSERT INTO wol2010_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Naka noona ki jot ñaari milyoŋ it jegeñsi ne ko: “Kilifa gi, dénk nga ma ñaari milyoŋ, seetal, ame naa ci yeneen ñaar.” ");
INSERT INTO wol2010_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Njaatigeem ne ko: “Def nga lu baax, surga bu baax nga te takku. Gannaaw takku nga ci lu tuuti, dinaa la dénk lu bare. Kaay bokk ci sama mbég.” ");
INSERT INTO wol2010_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","«Gannaaw loolu nag, ki jot benn milyoŋ jegeñsi ne ko: “Kilifa gi, xamoon naa ne, nit ku néeg nga; dangay dajale foo jiwul, tey góob foo faruwul. ");
INSERT INTO wol2010_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Moo tax ma ragaloon la, ba dem, nëbb sa xaalis ci biir suuf; mi ngii, fabal li nga moom.” ");
INSERT INTO wol2010_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Waaye njaatigeem ne ko: “Surga bu bon nga te tayel! Gannaaw xamoon nga ne damay dajale fu ma jiwul, tey góob fu ma faruwul, ");
INSERT INTO wol2010_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","kon waroon ngaa yóbbu sama xaalis ca denckati xaalis ya. Bés bu ma ñëwee nag, ma mana jot li ma moom ak la mu jur.” ");
INSERT INTO wol2010_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Noonu njaatige bi ne: “Nanguleen xaalis bi ci moom, jox ko boroom fukki milyoŋ yi. ");
INSERT INTO wol2010_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Ndaxte ku am dinañu la dolli, ba nga barele, waaye ku amul, li nga am as néew sax, dinañu ko nangu. ");
INSERT INTO wol2010_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Te sànnileen surga bu amul njariñ bi ci biti ci lëndëm gi. Foofa dees na fa jooy te yéyu.” ");
INSERT INTO wol2010_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","«Boo xamee ne Doomu nit ki mu ngi ñëw ci ndamam, ànd ak malaaka yépp, booba dina falu ni buur, toog ci jalam bu soloo ndam. ");
INSERT INTO wol2010_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Bu boobaa dees na dajale xeeti àddina yépp ci kanamam, te dina leen xàjjale, ni sàmm di xàjjalee xar yi ak bëy yi, ");
INSERT INTO wol2010_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","mu teg xar yi ci ndijooram, bëy yi ci càmmoñam. ");
INSERT INTO wol2010_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","«Noonu Buur bi dina wax ñi féete ndijoor: “Agsileen, yéen ñi sama Baay barkeel, jël-leen nguur, gi ñu leen waajal li dale ci njàlbéenug àddina. ");
INSERT INTO wol2010_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Ndaxte xiifoon naa, ngeen jox ma, ma lekk; te mar, ngeen jox ma, ma naan; nekkoon naa ab doxandéem, ngeen fat ma; ");
INSERT INTO wol2010_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","te rafle, ngeen wodd ma; woppoon naa, ngeen seetsi ma; te ñu tëj ma, ngeen ñëw fi man.” ");
INSERT INTO wol2010_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Ci kaw loolu ñi jub dinañu ne: “Boroom bi, kañ lanu la gisoon, nga xiif, nu jox la, nga lekk; mbaa nga mar, nu jox la, nga naan? ");
INSERT INTO wol2010_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Kañ lanu la gisoon, nga nekk ab doxandéem, nu fat la; mbaa nga rafle, nu wodd la? ");
INSERT INTO wol2010_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Kañ lanu la gisoon, nga wopp mbaa ñu tëj la, nu ñëw ci yaw?” ");
INSERT INTO wol2010_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Noonu Buur bi dina leen ne: “Ci dëgg maa ngi leen koy wax, saa yu ngeen defalee loolu kenn ki gëna ndaw ci sama bokk yii, man ngeen ko defal.” ");
INSERT INTO wol2010_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","«Gannaaw loolu dina wax ñi ci càmmoñam: “Soreleen ma yéen ñi alku, te dem ci sawara su dul fey, si ñu sàkkal Seytaane ak ay malaakaam. ");
INSERT INTO wol2010_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Ndaxte xiifoon naa waaye joxuleen ma, ma lekk; te mar waaye joxuleen ma, ma naan. ");
INSERT INTO wol2010_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Nekkoon naa ab doxandéem, waaye fatuleen ma; te rafle, waaye wodduleen ma; woppoon naa te ñu tëj ma, waaye seetsiwuleen ma.” ");
INSERT INTO wol2010_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Ci kaw loolu dinañu ne: “Boroom bi, kañ lanu la gisoon, nga xiif, mbaa nga mar, nga nekk ab doxandéem mbaa rafle, nga wopp mbaa ñu tëj la, te topptoowunu la?” ");
INSERT INTO wol2010_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Kon dina leen ne: “Ci dëgg maa ngi leen koy wax, saa su ngeen ko defalul kenn ci ñi gëna ndaw, man ngeen ko defalul.” ");
INSERT INTO wol2010_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Noonu ñii dinañu sóobu ci mbugal gu dul jeex, waaye ñi jub dinañu tàbbi ci dund gu dul jeex.» ");
INSERT INTO wol2010_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Bi nga xamee ne Yeesu wax na loolu lépp ba noppi, mu ne taalibeem ya: ");
INSERT INTO wol2010_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","«Xam ngeen ne ñaari fan a des ci màggalu bésu Mucc ba, te dinañu wor Doomu nit ki, daaj ko ci bant.» ");
INSERT INTO wol2010_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Booba nag sarxalkat yu mag ya ak njiiti xeet wa dajaloo ca kër gu réy gu sarxalkat bu mag ba, tudd Kayif. ");
INSERT INTO wol2010_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Ñu daldi gise, ba xam lu ñu mana fexe, ba jàpp Yeesu, reylu ko. ");
INSERT INTO wol2010_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Waaye ñu ne: «Bumu doon ci bésu màggal bi, ngir yëngu-yëngu baña am ci nit ñi.» ");
INSERT INTO wol2010_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Bi nga xamee ne Yeesu nekkoon na dëkku Betani ca kër Simoŋ ma gaana woon, ");
INSERT INTO wol2010_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","jenn jigéen ñëw ci moom, yor njaq lu ñu yette doj wu ñuy wax albaatar. Njaq la def latkoloñ ju jar lu baree bare. Noonu bi Yeesu toogee di lekk, jigéen ji tuur ko ci boppu Yeesu. ");
INSERT INTO wol2010_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Waaye bi ko taalibe ya gisee, ñu daldi mer ne: «Yàq gii, lu muy jariñ? ");
INSERT INTO wol2010_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Maneesoon na koo jaay ci lu bare, jox xaalis bi miskin yi.» ");
INSERT INTO wol2010_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Yeesu nag xam la ñu wax, mu ne leen: «Jigéen ji defal na ma jëf ju rafet; lu tax ngeen di ko sonal? ");
INSERT INTO wol2010_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Miskin yaa ngi ak yéen bés bu nekk, waaye dungeen ma gis ba fàww. ");
INSERT INTO wol2010_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Kii, ci li mu tuur latkoloñ jii ci sama yaram, def na ko ngir waajal sama rob. ");
INSERT INTO wol2010_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Ci dëgg maa ngi leen koy wax, fépp fu ñuy yéene xibaaru jàmm bi ci àddina sépp, dinañu fa fàttali it li jigéen jii def.» ");
INSERT INTO wol2010_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Ca waxtu woowu kenn ci fukki taalibe ya ak ñaar, ku tudd Yudaa Iskariyo, dem ca sarxalkat yu mag ya, ");
INSERT INTO wol2010_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","ne leen: «Lan ngeen ma mana jox, ngir ma jébbal leen Yeesu?» Noonu sarxalkat ya daldi ko waññal fanweeri poseti estateer. ");
INSERT INTO wol2010_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Li dale ci saa soosa nag Yudaa di fexe jamono ju mu leen mana jébbal Yeesu. ");
INSERT INTO wol2010_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Bés bu jëkk ca màggal, ga ñuy wax Mburu ma amul lawiir, taalibe yi ñëw ci Yeesu ne ko: «Foo bëggoon nu defaral la reeru bésu Mucc ba?» ");
INSERT INTO wol2010_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Yeesu ne leen: «Demleen ca dëkk ba, jëm ca diw, ngeen ne ko: “Kilifa gi nee na: Sama jamono jege na; ci sa kër laay màggalsi bésu Mucc ba, man ak samay taalibe.”» ");
INSERT INTO wol2010_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Noonu taalibe yi defar reeru bésu Mucc ba, na leen Yeesu waxe woon. ");
INSERT INTO wol2010_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Bi nga xamee ne timis jot na, Yeesu toog di lekk, moom ak fukki taalibe yi ak ñaar. ");
INSERT INTO wol2010_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Bi ñuy lekk, mu ne leen: «Ci dëgg maa ngi leen koy wax, kenn ci yéen dina ma wor.» ");
INSERT INTO wol2010_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Taalibe ya am naqaru xol bu réy; ku nekk daldi ne ko: «Mbaa du man, Boroom bi?» ");
INSERT INTO wol2010_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Yeesu ne leen: «Ki dugal loxoom ak man ci ndab li, kooku moo may wor. ");
INSERT INTO wol2010_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Doomu nit ki mu ngi dem, ni ñu ko waxe ci Mbind mi, waaye ki koy wor dina torox; bañoona juddu moo gënoon ci moom.» ");
INSERT INTO wol2010_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Yudaa, mi ko nara wor, laaj ko: «Mbaa du man, kilifa gi?» Yeesu ne ko: «Wax nga ko.» ");
INSERT INTO wol2010_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Noonu bi ñuy lekk, Yeesu jël mburu, sant Yàlla, damm ko, jox ko taalibe ya. Mu ne leen: «Jël-leen lekk, lii sama yaram la.» ");
INSERT INTO wol2010_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Gannaaw loolu mu jël kaas, sant Yàlla, jox leen ko. Mu ne leen: «Yéen ñépp naanleen ci, ");
INSERT INTO wol2010_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","ndaxte lii mooy sama deret, ji fas kóllëre gi, te mu tuuru, ngir ñu bare jot mbaalug bàkkaar yi. ");
INSERT INTO wol2010_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Maa ngi leen di wax, dootuma naan gannaaw-si-tey ndoxum reseñ mii, ba kera may naan ak yéen ndoxum reseñ mu bees ci sama nguuru Baay.» ");
INSERT INTO wol2010_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Gannaaw loolu ñu woy Yàlla, ba noppi génn, dem ca tundu Oliw ya. ");
INSERT INTO wol2010_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Booba Yeesu ne leen: «Yéen ñépp dingeen ma dàggeeku ci guddi gii, ndaxte bind nañu: “Dinaa dóor sàmm bi, xari jur gi tasaaroo.” ");
INSERT INTO wol2010_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Waaye bu ma dekkee, dinaa leen jiituji Galile.» ");
INSERT INTO wol2010_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Piyeer nag daldi jël kàddu gi naan: «Bu la ñépp dàggeekoo, man duma la dàggeeku mukk.» ");
INSERT INTO wol2010_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Yeesu ne ko: «Ci dëgg maa ngi la koy wax, ci guddi gii, bala ginaar a sab, dinga ma weddi ñetti yoon.» ");
INSERT INTO wol2010_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Piyeer ne ko: «Boo xamee ne sax, damaa wara dee ak yaw, duma la weddi mukk.» Taalibe yépp it waxe noonu. ");
INSERT INTO wol2010_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Bi loolu amee Yeesu ànd ak ñoom ba ca bérab bu tudd Setsemane, mu ne taalibe ya: «Toogleen fii, ma dem fale, ñaan fa.» ");
INSERT INTO wol2010_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Bi mu waxee loolu, mu ànd ak Piyeer ak ñaari doomi Sebede, daldi am tiis ba xonet. ");
INSERT INTO wol2010_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Mu ne leen: «Sama xol dafa tiis, ba may bëgga dee; toogleen fi, xool ak man.» ");
INSERT INTO wol2010_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Bi mu waxee loolu, Yeesu dem ci kanam tuuti, ne nërëm ci suuf, di ñaan ne: «Sama Baay, bu manee am, na ma kaasu naqar bii teggi! Moona, bumuy ci sama coobare, waaye na sa coobare am.» ");
INSERT INTO wol2010_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Noonu mu ñëw ca taalibe ya, fekk leen ñuy nelaw. Mu ne Piyeer: «Amuleen sax dooley xoolandoo ak man benn waxtu? ");
INSERT INTO wol2010_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Xool-leen te ñaan, ngir baña daanu cig fiir. Seen xol jag na, waaye seen bind a woyof.» ");
INSERT INTO wol2010_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Yeesu delluwaat di ñaan ne: «Sama Baay, bu fekkee ne kaasu naqar bii manu maa teggi te naanuma ko, kon na sa coobare am.» ");
INSERT INTO wol2010_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Yeesu ñëwaat ca taalibe ya, fekk leen ñuy nelaw, ndaxte seeni bët dañoo diis. ");
INSERT INTO wol2010_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Mu daldi leen bàyyi, waxaat loolu ñetteel bi yoon. ");
INSERT INTO wol2010_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Noonu mu ñëw ca taalibe ya ne leen: «Nelawleen léegi te noppalu. Waxtu wu ñu ma wara jébbale ci loxoy bàkkaarkat yi, jege na. ");
INSERT INTO wol2010_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Jógleen nu dem; xool-leen, ki may wor a ngi nii, di ñëw.» ");
INSERT INTO wol2010_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Bi muy wax loolu nag, Yudaa, mi bokkoon ca fukki taalibe ya ak ñaar te naroon koo wor, agsi, ànd ak mbooloo mu bare, jóge ca sarxalkat yu mag ya ak ca njiiti xeet wa, te gànnaayoo jaasi ak yet. ");
INSERT INTO wol2010_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Fekk Yudaa moomu joxoon na leen tegtal ne leen: «Ki may fóon, moom la; jàppleen ko.» ");
INSERT INTO wol2010_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Mu daldi ñëw ci Yeesu nag ne ko: «Salaam-maalikum, kilifa gi!» daldi ko fóon bu tàng. ");
INSERT INTO wol2010_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Yeesu ne ko: «Sama xarit, xam naa lu tax nga ñëw.» Noonu ñu daldi jegesi, song ko, jàpp ko. ");
INSERT INTO wol2010_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Ca saa sa kenn ci ñi ànd ak Yeesu bocci jaaseem, dóor surgab sarxalkat bu mag ba, nopp ba dagg. ");
INSERT INTO wol2010_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Waaye Yeesu ne ko: «Roofal sa jaasi ci mbaram, ndaxte ku bocci jaasi, jaasi moo lay rey. ");
INSERT INTO wol2010_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Xanaa xamuloo ne man naa laaj sama Baay, te dina ma may ci taxawaay bi mbooloom malaaka mu xel dajul? ");
INSERT INTO wol2010_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Waaye su ma ko defoon, nan la Mbind mi mana ame? Ndaxte Mbind mi nee na, nii la wara ame.» ");
INSERT INTO wol2010_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Booba Yeesu ne mbooloo mi: «Jóg ngeen ngir jàpp ma, gànnaayoo jaasi ak yet, mel ni ñuy topp sàcc. Moona daa naa toog bés bu nekk ca kër Yàlla ga, di jàngle, te jàppuleen ma. ");
INSERT INTO wol2010_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Waaye lii lépp xew na, ngir amal Mbindi yonent yi.» Ci kaw loolu taalibe yépp dëddu ko, daw. ");
INSERT INTO wol2010_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Ña jàppoon Yeesu yóbbu ko kër Kayif, sarxalkat bu mag ba, fa xutbakat ya ak njiit ya daje. ");
INSERT INTO wol2010_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Piyeer topp ko fu sore, ba ci ëttu sarxalkat bu mag ba; mu dugg, toog ak surga ya, ngir seet nu mbir may mujje. ");
INSERT INTO wol2010_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Noonu sarxalkat yu mag ya ak kureelu àttekat ya di seet naaféq bu mana seede ci Yeesu, ba ñu man koo rey, ");
INSERT INTO wol2010_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","waaye manuñu koo am. Teewul ñu bare ñëwoon nañu, di seede lu dul dëgg. Ba mujj ñaari nit ñëw naan: ");
INSERT INTO wol2010_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","«Kii nee woon na: “Man naa toj kër Yàlla ga, tabaxaat ko ci ñetti fan.”» ");
INSERT INTO wol2010_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Ci kaw loolu sarxalkat bu mag ba jóg ne ko: «Ndax doo wax dara? Loo xam ci li ñii seede ci yaw?» ");
INSERT INTO wol2010_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Waaye Yeesu ne cell. Sarxalkat bu mag ba ne ko: «Giñloo naa la ci Yàlla miy dund, nga wax nu, ndax yaa di Almasi bi, Doomu Yàlla ji.» ");
INSERT INTO wol2010_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Yeesu ne ko: «Wax nga ko. Maa ngi leen koy wax it, li dale fii dingeen gis Doomu nit ki toog ci ndijooru Aji Man ji, di ñëw ci niiri asamaan si.» ");
INSERT INTO wol2010_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Bi mu déggee loolu, sarxalkat bu mag ba daldi mer lool, ba xotti ay yéreem, daldi ne: «Weddi na Yàlla, lu nu doyeeti seede? Dégg ngeen ni mu weddee. ");
INSERT INTO wol2010_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Lu ngeen ci xalaat?» Ñu ne ko: «Yoon teg na ko dee.» ");
INSERT INTO wol2010_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Ci kaw loolu ñu daldi tifli ci xar kanamam, dóor ko ay kurfeñ. Ñeneen talaata ko, ");
INSERT INTO wol2010_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","ne ko: «Yaw Kirist, yonent bi, ndax xam nga ku la dóor?» ");
INSERT INTO wol2010_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Bi looluy xew, Piyeer moom ma nga toogoon ca biti ca ëtt ba. Noonu benn mbindaan ñëw ci moom ne ko: «Yaw itam àndoon nga ak Yeesum Galile.» ");
INSERT INTO wol2010_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Waaye Piyeer weddi ko ci kanam ñépp ne ko: «Xawma li ngay wax.» ");
INSERT INTO wol2010_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Bi mu ko waxee, mu jëm ca bunt ba, te beneen mbindaan gis ko, mu wax ña fa nekkoon: «Kii àndoon na ak Yeesum Nasaret.» ");
INSERT INTO wol2010_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Waaye Piyeer weddiwaat, boole ko ak ay ngiñ ne ko: «Xawma nit kooku.» ");
INSERT INTO wol2010_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Nees-tuut ña fa taxawoon ñëw ci Piyeer ne ko: «Ci lu wóor ne yaw itam bokk nga ci ñoom, ndaxte sa waxin feeñal na la.» ");
INSERT INTO wol2010_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Bi mu ko déggee, Piyeer daldi giñ ak di waat ne: «Xawma nit kooku.» Te ci taxawaay ginaar daldi sab. ");
INSERT INTO wol2010_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Noonu Piyeer fàttaliku la Yeesu waxoon ne: «Bala ginaar a sab, dinga ma weddi ñetti yoon.» Mu daldi génn, di jooy jooy yu metti. ");
INSERT INTO wol2010_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Ci suba teel sarxalkat yu mag yépp ak njiiti xeet wa gise, ngir fexee reylu Yeesu. ");
INSERT INTO wol2010_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Ñu yeew ko, yóbbu ko, jébbal ko Pilaat boroom réew ma. ");
INSERT INTO wol2010_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Bi nga xamee ne Yudaa, mi woroon Yeesu, gis na ne daan nañu ko, mu am naqaru xol. Mu dem nag ca sarxalkat yu mag ya ak njiit ya, delloo leen fanweeri poset yu xaalis, ");
INSERT INTO wol2010_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","ne leen: «Am naa bàkkaar ci li ma wor nit ku tooñul, ngir ñu rey ko.» Ñu ne ko: «Lu ciy sunu yoon? Loolu yaa ko yég.» ");
INSERT INTO wol2010_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Noonu Yudaa sànni xaalis ba ca kër Yàlla ga, jóge fa, dem, takk buum ci baatam, xaru. ");
INSERT INTO wol2010_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Sarxalkat yu mag ya nag fab xaalis ba, naan: «Jaaduwul nu def xaalis bii ci dencukaayu xaalis bi ci kër Yàlla gi, ndaxte njégu deret la.» ");
INSERT INTO wol2010_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Ñu daldi diisoo nag, jënd ca xaalis ba toolu defarkatu ndaa ya, ngir di fa suul doxandéem ya. ");
INSERT INTO wol2010_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Loolu moo tax ñu wooye tool booba ba tey Toolu deret. ");
INSERT INTO wol2010_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Noonu la ñu waxoon jaarale ko ci yonent Yàlla Yeremi am, bi mu naan: «Fab nañu fanweeri poseti xaalis ya, mooy njég li bànni Israyil xayma woon ci nit ki; ");
INSERT INTO wol2010_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","ñu joxe ko ngir toolu defarkatu ndaa ya, ni ma ko Boroom bi sante.» ");
INSERT INTO wol2010_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Gannaaw loolu Yeesu taxaw ca kanam boroom réew ma, boroom réew ma laaj ko: «Ndax yaa di buuru Yawut yi?» ");
INSERT INTO wol2010_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Yeesu ne ko: «Wax nga ko,» waaye waxul dara ca la ko sarxalkat yu mag ya ak njiit ya jiiñ. ");
INSERT INTO wol2010_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Noonu Pilaat ne ko: «Xanaa dégguloo li ñu la jiiñ lépp?» ");
INSERT INTO wol2010_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Waaye Yeesu waxu ko ci dara, ba tax boroom réew ma waaru lool. ");
INSERT INTO wol2010_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Ca màggal gu nekk nag boroom réew ma daan na may mbooloo ma, ñu tànn kenn ca ña ñu tëjoon, mu daldi leen ko bàyyil. ");
INSERT INTO wol2010_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Fekk booba amoon nañu ku ñu tëjoon, ku siiw te tudd Barabas. ");
INSERT INTO wol2010_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Bi nga xamee ne daje nañu nag, Pilaat laaj leen: «Kan ngeen bëgg, ma bàyyi ko, Barabas walla Yeesu mi ñuy wax Kirist?» ");
INSERT INTO wol2010_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Ndaxte xamoon na ne kiñaan rekk a taxoon, ñu jébbal ko ko. ");
INSERT INTO wol2010_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Te it bi mu toogee sax ca jalu àttekaay ba, soxnaam yónnee ci moom ne ko: «Bul dugg ci yëfi ku jub kooku, ndaxte tey gént naa ci moom te sonn naa ci lool.» ");
INSERT INTO wol2010_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Waaye sarxalkat yu mag ya ak njiit ya xiir mbooloo ma, ñu laaj Barabas te reylu Yeesu. ");
INSERT INTO wol2010_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Noonu boroom réew ma laaj leen: «Kan ci ñaar ñii ngeen bëgg, ma bàyyil leen ko?» Ñu ne ko: «Barabas.» ");
INSERT INTO wol2010_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Pilaat ne leen: «Nan laay def nag Yeesu, mi tudd Kirist?» Ñépp ne ko: «Daaj ko ci bant, ba mu dee!» ");
INSERT INTO wol2010_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Boroom réew ma ne leen: «Lu tax? Gan tooñ la def?» Waaye ñu daldi yuuxu bu gëna kawe naan: «Daaj ko ci bant!» ");
INSERT INTO wol2010_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Naka Pilaat xam ne du ci man dara, fekk na sax yëngu-yëngu bi gëna am doole, mu daldi fab ndox, raxas ay loxoom ca kanam mbooloo ma ne leen: «Set naa ci deretu ku jub kii; nu ngeen xam, defleen ko.» ");
INSERT INTO wol2010_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Ñépp ne ko: «Na deretam dal ci sunu kaw ak sunu kaw njaboot.» ");
INSERT INTO wol2010_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Noonu Pilaat bàyyil leen Barabas, mu dóorlu Yeesu ay yar, jébbal ko, ngir ñu daaj ko ci bant. ");
INSERT INTO wol2010_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Bi ñu ko defee xarekati boroom réew ma fab Yeesu, yóbbu ko ci biir kër ga, ñu daldi woo mbooloom xarekat ya yépp ci moom. ");
INSERT INTO wol2010_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Noonu ñu summi ko, solal ko mbubbum xarekat mu xonq curr. ");
INSERT INTO wol2010_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Ñu ràbb kaalag dég, teg ko ci boppam, teg bantu xat ci loxol ndijooram, sukk ci kanamam, di ko ñaawal ne ko: «Nuyu nanu la, yaw buuru Yawut yi!» ");
INSERT INTO wol2010_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Ba noppi ñu daldi tifli ci kawam, fab bantu xat ba, dóor ko ci boppam. ");
INSERT INTO wol2010_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Bi ñu ko ñaawalee ba noppi, ñu summi mbubbum xarekat ma, solaatal ko ay yéreem, yóbbu ko, ngir daaj ko ci bant. ");
INSERT INTO wol2010_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Bi nga xamee ne génn nañu, ñu daje ak nit ku dëkk Siren te tudd Simoŋ; ñu ga ko, ngir mu gàddu bant, ba ñu wara daaj Yeesu. ");
INSERT INTO wol2010_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Ñu ñëw nag fa ñuy wax Golgota, biy tekki «bérabu Kaaŋu bopp.» ");
INSERT INTO wol2010_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Bi ñu fa eggee, ñu jox ko biiñ, ñu def ci lu wex. Waaye bi mu ko mosee, nanguwu koo naan. ");
INSERT INTO wol2010_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Noonu ñu daaj ko ca bant ba, ñu daldi séddoo ay yéreem, tegoo ko ay bant, ");
INSERT INTO wol2010_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","ba noppi toog fa, di ko wottu. ");
INSERT INTO wol2010_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Te it ñu teg ci kaw boppam mbind, mu xamle lu tax ñu rey ko, mu ne: «Kii mooy Yeesu, buuru Yawut yi.» ");
INSERT INTO wol2010_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Booba it ñu daajaale ak moom ñaari taskati réew ma, kenn ci ndijooram, ka ca des ci càmmoñam. ");
INSERT INTO wol2010_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Ña fa doon romb di ko xas, di wëcc seen bopp ndax sib ko, ");
INSERT INTO wol2010_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","naan: «Yaw mi mana toj kër Yàlla ga, tabaxaat ko ci ñetti fan, musalal sa bopp; boo nekkee Doomu Yàlla, wàccal ci bant bi!» ");
INSERT INTO wol2010_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Sarxalkat yu mag ya ak xutbakat ya ak njiit ya it di ko ñaawal naan: ");
INSERT INTO wol2010_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","«Waa jii musal na ñeneen te manula musal boppam! Ndegam mooy buuru Israyil, na wàcc léegi ci bant bi, nu gëm ko. ");
INSERT INTO wol2010_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Gannaaw dénk na boppam Yàlla, kon na ko Yàlla musal, bu ko soppee, ndaxte nee na: “Maay Doomu Yàlla.”» ");
INSERT INTO wol2010_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Taskati réew ma it, ya ñu daajaale ak moom, di ko xas noonule. ");
INSERT INTO wol2010_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","La tàmbalee digg bëccëg, ba ci tisbaar, réew mépp lëndëm. ");
INSERT INTO wol2010_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Noonu ci wetu ñetti waxtu Yeesu daldi wootee kàddu gu dëgër naan: «Eli, Eli, lema sabaktani?» liy tekki «Sama Yàlla, sama Yàlla, lu tax nga dëddu ma?» ");
INSERT INTO wol2010_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Ñenn ña ca ña fa taxaw nag, bi ñu ko déggee, ñu ne: «Mu ngi woo yonent Yàlla Ilyaas.» ");
INSERT INTO wol2010_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Ca saa sa kenn ci ñoom daw, jël aw sagar, capp ko ci bineegar, mu teg ko ci kaw bant, jox ko ko, mu muucu. ");
INSERT INTO wol2010_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Waaye ña ca des ne: «Bàyyil, nu seet ba xam Ilyaas dina ñëw, musal ko.» ");
INSERT INTO wol2010_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Noonu Yeesu wootewaat ak kàddu gu dëgër, delloo ruuwam Yàlla. ");
INSERT INTO wol2010_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Ca saa sa ridob bérab bu sell ba ca kër Yàlla ga xar ñaar, li dale ci kaw ba ci suuf; suuf si yëngu, doj yi toj, bàmmeel yi ubbiku, ");
INSERT INTO wol2010_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","te ñu bare ci jëmmi nit ñu sell ñu dee, dekki. ");
INSERT INTO wol2010_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Te gannaaw ndekkitel Yeesu ñu génn ca bàmmeel ya, dugg ca dëkk bu sell ba, te feeñu ñu bare. ");
INSERT INTO wol2010_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Noonu njiitu xare bi ak ñi ànd ak moom di wottu Yeesu, bi ñu gisee suuf si yëngu ak li xew, ñu daldi tiit lool ne: «Ci dëgg, kii Doomu Yàlla la.» ");
INSERT INTO wol2010_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Amoon na fa it ay jigéen yu bare yu leen dànd, di seetaan. Te ñoo jóge woon Galile, ànd ak Yeesu, di ko topptoo. ");
INSERT INTO wol2010_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Xàmmi nañu ci: Maryaama mi dëkk Magdala, Maryaama ndeyu Saag ak Yuusufa, ak ndeyu doomi Sebede ya. ");
INSERT INTO wol2010_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Ca ngoon amoon na taalibeb Yeesu mu ñëw, tudd Yuusufa te dëkk Arimate; ku bare alal la woon. ");
INSERT INTO wol2010_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Mu dem ca Pilaat, laaj ko néewu Yeesu. Pilaat santaane, ñu jox ko ko. ");
INSERT INTO wol2010_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Noonu Yuusufa fab jëmm ja, laxas ko ci càngaay lu set, ");
INSERT INTO wol2010_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","dugal ko ca bàmmeel bu bees, ba mu yettaloon boppam ciw doj. Mu béraŋ doj wu mag ca buntu bàmmeel ba, dem. ");
INSERT INTO wol2010_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Fekk Maryaamam Magdala ak Maryaama ma ca des ñoo fa toogoon janook bàmmeel ba. ");
INSERT INTO wol2010_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Ba bët setee nag, ca bés ba topp bésu Waajal ba, sarxalkat yu mag ya ak Farisen ya dajaloo, jëm ci Pilaat. ");
INSERT INTO wol2010_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Ñu ne ko: «Boroom réew mi, fàttaliku nanu ne, naxkat booba waxoon na, bi muy dund naan: “Gannaaw ñetti fan dinaa dekki.” ");
INSERT INTO wol2010_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Danoo bëggoon nag, nga santaane, ñu wottu bàmmeel ba, ba am ñetti fan, ngir bañ taalibeem ya ñëw, sàcc néew ba, tey yégle ne dekki na. Bu ko defee nax bu mujj boobu dina yées bu jëkk ba.» ");
INSERT INTO wol2010_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Pilaat ne leen: «Amleen, ay wottukat a ngi nii. Demleen wottuji ko, ni ngeen mane.» ");
INSERT INTO wol2010_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Noonu ñu dem, tëj bàmmeel ba bu wóor, ñu tay ca doj wa màndarga, teg fa wottukat ya. ");
INSERT INTO wol2010_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Gannaaw bésub noflaay ba nag, ca fajar ga, ca bés bu jëkk ca ayu-bés ga, Maryaamam Magdala ak Maryaama ma ca des dem, seeti bàmmeel ba. ");
INSERT INTO wol2010_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Fekk suuf yëngu woon na bu metti, ndaxte benn malaakam Boroom bi wàcc na ci asamaan, ñëw béraŋ doj wa, toog ci kaw. ");
INSERT INTO wol2010_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Meloom mel na ni melax, ay yéreem weex tàll ni perkaal. ");
INSERT INTO wol2010_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Ñi doon wottu tiit bay lox, daldi mel ni ñu dee. ");
INSERT INTO wol2010_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Noonu malaaka ma ne jigéen ña: «Buleen tiit. Xam naa ne yéena ngi wut Yeesu, ma ñu daajoon ca bant ba, ");
INSERT INTO wol2010_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","waaye nekkatu fi, ndaxte dekki na, ni mu ko waxe woon. Ñëwleen seet fi mu tëddoon, ");
INSERT INTO wol2010_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","te ngeen dem bu gaaw, wax ay taalibeem ne dekki na te jiituji na leen Galile; foofa ngeen koy gise. Lii laa leen wax.» ");
INSERT INTO wol2010_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Bi loolu amee nag jigéen ña daldi jóge bu gaaw ca bàmmeel ba, tiit ak mbég mu réy di jax seen xol, ñu daldi daw, ngir yégal ko taalibe ya. ");
INSERT INTO wol2010_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Ba ñuy dem nag, Yeesu taseek ñoom ne leen: «Maa ngi leen di nuyu.» Jigéen ña jegesi, laxasu cay tànkam, di ko màggal. ");
INSERT INTO wol2010_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Yeesu ne leen: «Buleen tiit, waaye demleen yégal samay bokk, ñu dem Galile; foofa lañu may gise.» ");
INSERT INTO wol2010_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Ba ñuy dem, ñenn ca wottukat ya ñëw ca dëkk ba, xamal sarxalkat yu mag ya lépp lu xew. ");
INSERT INTO wol2010_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Noonu sarxalkat ya dajaloo ak njiit ya, ñu diisoo; ba noppi ñu fab xaalis bu bare, jox ko xarekat ya, ");
INSERT INTO wol2010_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","ne leen: «Nangeen wax lii: “Ay taalibeem ñëw nañu ci guddi, sàcc ko, bi nuy nelaw.” ");
INSERT INTO wol2010_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Te bu ko boroom réew mi yégee nag, dinanu ko neexal, ngir rawale leen.» ");
INSERT INTO wol2010_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Wottukat ya nag fab xaalis ba, def la ñu leen santoon. Te nettali boobu siiw na ci Yawut yi ba bésu tey. ");
INSERT INTO wol2010_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Noonu fukki taalibe ya ak benn dem ci biir Galile, ca tund wa leen Yeesu digaloon. ");
INSERT INTO wol2010_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Bi ñu gisee Yeesu, ñu màggal ko, waaye ñenn ñi am xel ñaar. ");
INSERT INTO wol2010_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Yeesu jegesi ne leen: «Sañ-sañ bépp, jox nañu ma ko ci kaw ak ci suuf. ");
INSERT INTO wol2010_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Demleen nag sàkk ay taalibe ci xeet yépp, sóob leen ci ndox ci turu Baay bi ak Doom ji ak Xel mu Sell mi; ");
INSERT INTO wol2010_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","ngeen jàngal leen, ñuy sàmm lépp li ma leen sant. Maa ngi ànd ak yéen bés bu nekk, ba kera àddina di tukki.» ");
INSERT INTO wol2010_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Xibaaru jàmm bu Yeesu Kirist, Doomu Yàlla, nii la tàmbalee. ");
INSERT INTO wol2010_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Bind nañu ci téereb yonent Yàlla Esayi naan: «Maa ngi yónni sama ndaw ci sa kanam, mu xàllal la sa yoon. ");
INSERT INTO wol2010_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Baat a ngi xaacu ca màndiŋ ma naan: “Xàll-leen yoonu Boroom bi, jubal-leen fi muy jaar.”» ");
INSERT INTO wol2010_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Noonu Yaxya feeñ ca màndiŋ ma, di sóob nit ñi ci ndox, tey waaree nii: «Tuubleen seeni bàkkaar, ba noppi ma sóob leen ci ndox, ngir Yàlla baal leen seeni bàkkaar.» ");
INSERT INTO wol2010_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Kon waa diiwaanu Yude ñépp ak waa dëkku Yerusalem ñépp daldi génn jëm ci moom, di nangu seeni bàkkaar fi kanam ñépp, Yaxya sóob leen ca dexu Yurdan. ");
INSERT INTO wol2010_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Yaxya nag mi ngi soloon mbubb mu ñu ràbbe kawaru giléem, takk laxasaayu der ci ndiggam. Ay njéeréer la doon dunde ak lem. ");
INSERT INTO wol2010_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Mu waare ne: «Am na kuy ñëw sama gannaaw koo xam ne kii moo ma ëpp kàttan; yeyoowuma sax sëgg, ngir tekki ay dàllam. ");
INSERT INTO wol2010_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Maa ngi leen di sóob ci ndox, waaye moom dina leen sóob ci Xel mu Sell mi.» ");
INSERT INTO wol2010_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Booba Yeesu jóge na dëkku Nasaret ci diiwaanu Galile, ñëw, Yaxya sóob ko ci dexu Yurdan. ");
INSERT INTO wol2010_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Bi muy génn ndox mi, mu daldi gis asamaan xar, te Xelum Yàlla di wàcc ci melow pitax, ñëw ci moom. ");
INSERT INTO wol2010_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Te baat bu jóge asamaan jib ne: «Yaa di sama Doom, ji ma bëgg; ci yaw laa ame bànneex.» ");
INSERT INTO wol2010_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Ci kaw loolu Xelum Yàlla daldi jéñ Yeesu, mu dem ca màndiŋ ma. ");
INSERT INTO wol2010_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Mu nekk fa ñeent fukki fan, jànkoonte ak fiiri Seytaane; mu dëkk ci biir rabi àll yi, te malaakay Yàlla di ko topptoo. ");
INSERT INTO wol2010_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Bi nga xamee ne jàpp nañu Yaxya, Yeesu dem ca diiwaanu Galile, di waare xibaaru jàmm bu Yàlla bi, ");
INSERT INTO wol2010_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","naan: «Jamono ji mat na, nguuru Yàlla jegesi na; tuubleen seeni bàkkaar te gëm xibaaru jàmm bi.» ");
INSERT INTO wol2010_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Am bés Yeesu doon dox ca tefesu dexu Galile, mu gis fa ñaar ñu bokk ndey ak baay, di Simoŋ ak Andare rakkam, ñuy sànni seeni mbaal ci dex gi, ndaxte ay nappkat lañu woon. ");
INSERT INTO wol2010_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Yeesu ne leen: «Ñëwleen topp ci man, dinaa leen def nappkati nit.» ");
INSERT INTO wol2010_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Ci saa si ñu bàyyi seeni mbaal, topp ci moom. ");
INSERT INTO wol2010_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Bi Yeesu demee ba ca kanam, mu gis Saag doomu Sebede, ak Yowaana, mi mu bokkal ndey ak baay, ñu nekk ci gaal gi, di defar seeni mbaal. ");
INSERT INTO wol2010_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Noonu Yeesu woo leen, ñu daldi bàyyi seen baay Sebede ci gaal gi, moom ak surga ya, tey topp ci moom. ");
INSERT INTO wol2010_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Gannaaw loolu ñu dem Kapernawum. Ca bésub noflaay nag Yeesu daldi dugg ci jàngu bi, di leen jàngal. ");
INSERT INTO wol2010_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Te ñu waaru ca njàngleem, ndaxte jàngal na leen ak sañ-sañ bu seeni xutbakat amul. ");
INSERT INTO wol2010_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Noonu am na ci jàngu bi nit ku rab jàpp. Mu daldi yuuxu naan: ");
INSERT INTO wol2010_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","«Yaw Yeesum Nasaret, loo nuy fexeel? Ndax dangaa ñëw, ngir alag nu? Xam naa la, yaa di Aji Sell, ji jóge ci Yàlla.» ");
INSERT INTO wol2010_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Waaye Yeesu gëdd ko naan: «Noppil te génn ci moom!» ");
INSERT INTO wol2010_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Noonu rab wi daldi sayloo nit ki te génn ci moom ak yuux gu réy. ");
INSERT INTO wol2010_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Bi loolu amee ñépp waaru, ba laajante naan: «Kii mooy kan? Mii njàngle lu bees la te ànd ak sañ-sañ. Day sant rab yi sax, ñu di ko déggal.» ");
INSERT INTO wol2010_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Noonu turam daldi siiw ci diiwaani Galile gépp. ");
INSERT INTO wol2010_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Bi nga xamee ne génn nañu ci jàngu bi, ñu ànd ak Saag ak Yowaana, dem ci kër Simoŋ ak Andare. ");
INSERT INTO wol2010_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Fekk gorob Simoŋ bu jigéen tëdd wopp ak yaram wu tàng; ñu daldi ko yégal Yeesu. ");
INSERT INTO wol2010_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Mu ñëw nag ci moom, jàpp loxoom, yékkati ko. Noonu tàngoor wi daldi wàcc, te soxna si di leen topptoo. ");
INSERT INTO wol2010_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Ca ngoon sa nag, bi jant sowee, ñu indil Yeesu ñi wopp ñépp ak ñi rab jàpp ñépp, ");
INSERT INTO wol2010_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","ba dëkk bi bépp dajaloo ci buntu kër gi. ");
INSERT INTO wol2010_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Noonu mu wéral ñu bare, ñu wopp ak ay jàngoro yu wuute, te dàq ay rab yu bare. Waaye mu tere rab yi, ñu wax dara, ndaxte xam nañu ko. ");
INSERT INTO wol2010_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Ca njël laata bët di set, Yeesu jóg dem ca bérab bu wéet, di fa ñaan Yàlla. ");
INSERT INTO wol2010_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Simoŋ nag ak ñi ànd ak moom di ko seet fu nekk. ");
INSERT INTO wol2010_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Bi ñu ko gisee, ñu ne ko: «Ñépp a ngi lay seet.» ");
INSERT INTO wol2010_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Waaye Yeesu ne leen: «Nanu dem feneen ci dëkk yi nu wër, ma waare fa itam, ndaxte moo tax ma génn.» ");
INSERT INTO wol2010_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Noonu mu wër ci diiwaanu Galile gépp, di waare ci seeni jàngu, tey dàq rab yi. ");
INSERT INTO wol2010_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Am bés ku gaana ñëw ci moom, sukk, ñaan ko ne: «Soo ko bëggee, man nga maa wéral.» ");
INSERT INTO wol2010_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Yeesu yërëm ko, tàllal loxoom, laal ko naan: «Bëgg naa ko, wéral.» ");
INSERT INTO wol2010_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Ca saa sa ngaanaam daldi deñ, mu wér. ");
INSERT INTO wol2010_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Noonu Yeesu yebal ko, dénk ko bu wér naan: ");
INSERT INTO wol2010_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","«Moytula wax kenn dara, waaye demal won sa bopp sarxalkat bi, te nga jébbal Yàlla sarax, si yoonu Musaa santaane, ngir ñu xam ne wér nga, te mu nekk seede ci ñoom.» ");
INSERT INTO wol2010_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Waaye naka la waa ji génn, mu di yéene ci kaw li xewoon, te di ko jéebaane, ba tax Yeesu manatula fàŋŋaaral dugg cib dëkk, waaye mu nekk ci biti ciy bérab yu wéet. Ba tey nit ñi jóge fu nekk, di ko fa fekk. ");
INSERT INTO wol2010_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Bi ay fan weesoo, Yeesu délsi dëkku Kapernawum, mu siiw ne mu ngi ci kër gi. ");
INSERT INTO wol2010_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Noonu nit ñu bare dajaloo fa, ba kenn amatul foo taxaw, du ci bunt bi sax. Te Yeesu di leen yégal kàddu gi. ");
INSERT INTO wol2010_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Noonu, am ñu ko indil ku yaramam wépp làggi, ñeenti nit jàppoo ko. ");
INSERT INTO wol2010_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Waaye manuñu koo jege ndax mbooloo mi. Kon ñu daldi teggi kaw kër gi, di bëtt fa tiim bérab ba Yeesu nekk, daldi yoor basaŋ, ga làggi ba tëdd. ");
INSERT INTO wol2010_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Bi Yeesu gisee seen ngëm, mu ne làggi ba: «Sama waay, baal nañu la say bàkkaar.» ");
INSERT INTO wol2010_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Fekk ay xutbakat toog fa, ñu di werante ci seen xel naan: ");
INSERT INTO wol2010_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","«Kii kan la, ba saña wax lii; mi ngi sosal Yàlla. Ana ku mana baale bàkkaar yi, ku dul Yàlla doŋŋ?» ");
INSERT INTO wol2010_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Waaye Yeesu yég ci xelam li ñuy werante ci seen biir, ne leen: «Lu tax ngeen di werantee nii ci seen xel? ");
INSERT INTO wol2010_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Lan moo gëna yomb, ma wax ku làggi ki: “Baal nañu la say bàkkaar,” walla ma wax ko: “Jógal, jël sa basaŋ, tey dox”? ");
INSERT INTO wol2010_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Waaye xamleen ne, Doomu nit ki am na ci àddina sañ-sañu baale bàkkaar yi.» Ci kaw loolu mu ne làggi ba: ");
INSERT INTO wol2010_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","«Maa ngi la koy sant, jógal, jël sa basaŋ te nga ñibbi.» ");
INSERT INTO wol2010_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Ca saa sa mu jël basaŋam te génn fa kanam ñépp. Noonu ñépp waaru, di màggal Yàlla naan: «Lu mel ni lii, masunu koo gis.» ");
INSERT INTO wol2010_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Gannaaw loolu Yeesu génnaat, aw booru dex ga, mbooloo mépp di ñëw ci moom, mu di leen jàngal. ");
INSERT INTO wol2010_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Bi Yeesu di romb, mu gis ku ñuy wax Lewi, doomu Alfe, toog ca juuti ba. Yeesu ne ko: «Kaay topp ci man.» Mu jóg, daldi topp ci moom. ");
INSERT INTO wol2010_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Bi loolu amee Yeesu ak i taalibeem di lekk ci kër Lewi, fekk ay juutikat ak ay boroom bàkkaar yu bare di lekkandoo ak ñoom, ndaxte ñu bare ci ñoom a ko toppoon. ");
INSERT INTO wol2010_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Waaye xutbakat yi bokk ci Farisen yi, bi ñu gisee ne dafa bokk lekk ak ay juutikat ak ay boroom bàkkaar, ñu daldi laaj taalibe yi: «Lu tax muy lekkandoo ak ay juutikat ak ay boroom bàkkaar?» ");
INSERT INTO wol2010_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Noonu Yeesu dégg ko, mu ne leen: «Ñi wér soxlawuñu fajkat, ñi wéradi ñoo ko soxla; ñëwuma woo ñi jub, waaye bàkkaarkat yi laay woo.» ");
INSERT INTO wol2010_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Taalibey Yaxya nag ak Farisen yi daan nañu woor. Ñu ñëw nag fi Yeesu ne ko: «Lu tax taalibey Yaxya yi ak yu Farisen yi di woor, te say taalibe duñu woor?» ");
INSERT INTO wol2010_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Yeesu ne leen: «Ndax gan, yi ñëw cig céet, dinañu woor, fekk boroom céet gi ànd ak ñoom? Duñu woor, li feek boroom céet gaa ngi ànd ak ñoom. ");
INSERT INTO wol2010_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Waaye bés yaa ngi ñëw, yu ñuy jële boroom céet gi; bés boobaa nag dinañu woor. ");
INSERT INTO wol2010_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","«Kenn du daax mbubb mu màggat ak sekkit wu bees; ndaxte sekkit wi day ñoddi mbubb mi, te xottiku bi gëna yaatu. ");
INSERT INTO wol2010_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Te kenn du def biiñ bu bees ci mbuusi der yu màggat. Lu ko moy, biiñ bi day toj mbuus yi, ba mbuus yi yàqu, biiñ bi tuuru. Waaye biiñ bu bees, ci mbuus yu bees lañu koy def.» ");
INSERT INTO wol2010_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Amoon na benn bésub noflaay Yeesu jaar ciy tool yu ñor. Bi ñuy dem nag, ay taalibeem daldi fàq ay gub. ");
INSERT INTO wol2010_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Noonu Farisen ya ne Yeesu: «Gisal, lu tax say taalibe di def lu jaaduwul ci bésub noflaay bi?» ");
INSERT INTO wol2010_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Yeesu ne leen: «Ndax jànguleen la Daawuda defoon, ba mu amee soxla te xiif, moom ak ña mu àndaloon? ");
INSERT INTO wol2010_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Xanaa yéguleen li amoon ci bési Abiyatar sarxalkat bu mag bi, ni Daawuda dugge woon ca kër Yàlla ga, lekk mburu, ya ñu teewal ca kanam Yàlla, jox ci it ña mu àndaloon; fekk jaaduwul kenn lekk ko, ku dul sarxalkat?» ");
INSERT INTO wol2010_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Yeesu dellu ne leen: «Yàlla sàkkul nit ngir bésub noflaay bi, waaye sàkk na bésub noflaay ngir nit. ");
INSERT INTO wol2010_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Noonu Doomu nit ki mooy boroom bésub noflaay bi.» ");
INSERT INTO wol2010_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Am beneen bés, Yeesu duggaat ci jàngu bi, fekk amoon na fa nit ku loxoom làggi. ");
INSERT INTO wol2010_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Am na fa nag ay Farisen, ñuy xool Yeesu, ba xam ndax dina ko faj ci bésub noflaay bi, ngir ñu man koo tuumaal. ");
INSERT INTO wol2010_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Yeesu ne ku loxoom làggi: «Jógal, taxaw ci kanam ñépp.» ");
INSERT INTO wol2010_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Noonu Yeesu ne leen: «Lan moo jaadu, nu def ko bésub noflaay bi, lu baax mbaa lu bon; nu musal nit mbaa nu rey nit?» Waaye ñu ne cell. ");
INSERT INTO wol2010_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Ci kaw loolu Yeesu xool leen ak mer, am naqar ndax seen xol bu fatt; ba noppi mu ne nit ki: «Tàllalal sa loxo.» Nit ki tàllal ko, loxoom daldi wér péŋŋ. ");
INSERT INTO wol2010_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Ca saa sa nag Farisen ya génn, daldi gise ak ñi far ak buur bi Erodd, ngir fexe koo reylu. ");
INSERT INTO wol2010_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Gannaaw loolu Yeesu ak ay taalibeem jóge fa, jëm dex ga. Fekk mbooloo mu mag mu jóge diiwaanu Galile, topp ko. ");
INSERT INTO wol2010_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Te it nit ñu bare dégg la mu def, ñu ñëw fi moom, jóge diiwaanu Yude ak dëkku Yerusalem, ca diiwaanu Idume, ca gannaaw dexu Yurdan ak ci wàlli Tir ak Sidon. ");
INSERT INTO wol2010_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","10","Booba nag Yeesu faj na ñu bare, ba mboolem ñi am i jàngoro di ko song, ngir laal ko. Noonu Yeesu wax ay taalibeem, ñu wutal ko gaal, ngir mbooloo mi bañ koo buux. ");
INSERT INTO wol2010_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Fekk booba képp ku rab jàpp ku ko gis, daanu fa kanamam di yuuxu naan: «Yaa di Doomu Yàlla.» ");
INSERT INTO wol2010_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Waaye Yeesu gëdd rab yi bu wér, ngir ñu bañ koo siiwal. ");
INSERT INTO wol2010_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Gannaaw loolu Yeesu yéeg ci tund wi, woo ñi ko neex, ñu daldi ñëw ci moom. ");
INSERT INTO wol2010_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Noonu mu tànn ci fukk ak ñaar, tudde leen ay ndawam, ngir ñu ànd ak moom te mu yónni leen, ñu waareji, ");
INSERT INTO wol2010_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","mu joxaale leen sañ-sañu dàq ay rab. ");
INSERT INTO wol2010_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Fukk ak ñaar ñii la tànn: Simoŋ, mi mu tudde Piyeer, ");
INSERT INTO wol2010_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Saag doomu Sebede, ak Yowaana mi mu bokkal ndey ak baay— ñoom ñi mu wooye Bowanerses, maanaam «Ñi aaytal ni dënnu gi»— ");
INSERT INTO wol2010_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Andare ak Filib, Bartelemi ak Macë, Tomaa ak Saag doomu Alfe, Tade ak Simoŋ, mi bokk ca mbooloo, ma ñu tudde Ñi farlu ci moom seen réew; ");
INSERT INTO wol2010_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","ak Yudaa Iskariyo mi nara wor Yeesu. ");
INSERT INTO wol2010_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Am beneen bés Yeesu ñëwaat ca kër ga. Te mbooloo mu bare dajaloowaat fa, ba tax manuñoo lekk sax. ");
INSERT INTO wol2010_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Bi ko ay bokkam déggee nag, ñu ñëw, ngir jàppsi ko naan: «Dafa tàggoo ak sagoom.» ");
INSERT INTO wol2010_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Te it xutbakat ya jóge Yerusalem ne: «Beelsebul jàpp na ko; ci kàttanu buuru rab yi lay dàqe rab yi.» ");
INSERT INTO wol2010_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Noonu Yeesu woo leen, wax ak ñoom ciy léeb ne leen: «Naka la Seytaane mana dàqe Seytaane? ");
INSERT INTO wol2010_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Réew mu xeex boppam, du mana yàgg. ");
INSERT INTO wol2010_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Te kër gu xeex boppam, du mana yàgg. ");
INSERT INTO wol2010_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Bu Seytaane nag jógee, ba xeex boppam, xàjjalikoo dikkal na ko te du mana yàgg, waaye dina tas. ");
INSERT INTO wol2010_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","«Su fi amee nit ku bare doole, naka la kenn mana dugge ci këram, nangu alalam? Xanaa dafay jëkka yeew ku bare doole ka, ba noppi doora toj këram gépp. ");
INSERT INTO wol2010_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Ci dëgg maa ngi leen koy wax, lépp dees na ko baal nit ñi, muy bàkkaar, muy sosal Yàlla wu mu mana doon. ");
INSERT INTO wol2010_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Waaye kuy sosal Xel mu Sell mi deesu ko baal mukk; gàddu na bàkkaar ba fàww.» ");
INSERT INTO wol2010_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Yeesu wax na loolu, ndaxte nee woon nañu, rab jàpp na ko. ");
INSERT INTO wol2010_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Noonu ndeyu Yeesu ak ay rakkam ñëw, ñu taxaw ci biti, yónnee, woo ko. ");
INSERT INTO wol2010_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Fekk booba mbooloo nga toog, wër ko. Ñu ne ko nag: «Sa yaay ak say rakk ñu ngi taxaw ci biti, di la laaj.» ");
INSERT INTO wol2010_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Waaye Yeesu ne leen: «Kan mooy sama ndey? Ñan ñooy samay rakk?» ");
INSERT INTO wol2010_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Noonu mu xool ñi ko wër naan: «Sama yaay ak samay rakk a ngii; ");
INSERT INTO wol2010_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","ndaxte kuy def coobarey Yàlla, kooku mooy sama rakk ak sama jigéen ak sama ndey.» ");
INSERT INTO wol2010_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Am beneen yoon Yeesu nekk ci wetu dex ga, di jànglewaat. Mbooloo mu bare dajaloosi, ba tax mu yéeg cig gaal, dugg ca dex ga; mbooloo mépp taxaw ca tefes ga. ");
INSERT INTO wol2010_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Noonu Yeesu daldi leen jàngal lu bare ciy léeb. Ci njàngleem nag mu ne leen: ");
INSERT INTO wol2010_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","«Dégluleen, dafa amoon beykat bu demoon jiyi. ");
INSERT INTO wol2010_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Bi muy saaw toolam nag, lenn ci pepp mi wadd ci kaw yoon wi, picc yi daldi ñëw, lekk ko lépp. ");
INSERT INTO wol2010_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Leneen ci pepp mi wadd ci bérab bu bare ay doj te néew suuf, mu daldi sax bu gaaw, ndaxte suuf si barewul. ");
INSERT INTO wol2010_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Waaye bi jant bi naajee, mu lakk, wow, ndaxte amul ay reen. ");
INSERT INTO wol2010_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Leneen nag wadd ci biir ay xaaxaam, xaaxaam yi daldi sax, tanc ko, te meññul dara. ");
INSERT INTO wol2010_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Li ci des dal ci suuf su baax, mu jóg, sax, di focci ay gub; lii àntu, ba mat fanweeri yoon lu ëpp la mu ji woon, lii mat juróom benn fukk, lii mat téeméer.» ");
INSERT INTO wol2010_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Noonu Yeesu ne leen: «Déglul bu baax, yaw mi am ay nopp.» ");
INSERT INTO wol2010_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Gannaaw loolu ba Yeesu nekkee fu wéet, fukki taalibe ak ñaar ña, ak ñeneen ñu daan ànd ak ñoom, laaj ko ci mbirum léeb yi. ");
INSERT INTO wol2010_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Mu ne leen: «Yéen may nañu leen, ngeen xam mbóoti nguuru Yàlla, waaye ñi ci biti léeb ay ëmb lépp. ");
INSERT INTO wol2010_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Noonu la, ngir: “Ñuy xool bu baax waaye duñu gis dara, di déglu bu baax waaye duñu xam dara, ngir bañ ñu tuub seeni bàkkaar te Yàlla baal leen.”» ");
INSERT INTO wol2010_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Noonu Yeesu ne leen: «Ndax xamuleen léeb wii? Nu ngeen xame nag léeb yi ci des? ");
INSERT INTO wol2010_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Ki ji nag, kàddu gi lay ji. ");
INSERT INTO wol2010_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Ki féete ci yoon wi mooy ki dégg, Seytaane ñëw ci saa si, këf kàddu, gi ñu def ci moom. ");
INSERT INTO wol2010_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Ki jot kàddu gi ci bérab bu bare ay doj mooy ki dégg kàddu gi, nangu ko ak mbég ci saa si, ");
INSERT INTO wol2010_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","waaye du yàgg, ndaxte wax ji saxul ci moom. Bu jaaree ci nattu nag, mbaa ñu fitnaal ko ndax kàddu gi, mu dàggeeku ci saa si. ");
INSERT INTO wol2010_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Ki jot jiwu wi ci xaaxaam yi mooy ki dégg kàddu gi, ");
INSERT INTO wol2010_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","waaye soxlay àddina ak naxi alal ak bëgge solu ko, tanc kàddu gi, ba du meññ dara. ");
INSERT INTO wol2010_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Ki jot kàddu gi ci suuf su baax si nag, mooy ki ko dégg te nangu ko, ba jariñ; kii mat fanweeri yoon lu ëpp la ñu ji woon, kii mat juróom benn fukk, kii mat téeméer.» ");
INSERT INTO wol2010_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Yeesu ne leen itam: «Ndax nit dina jël làmp, dëpp ci leget walla def ko ci ron lal? Ndax du ko wékk? ");
INSERT INTO wol2010_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Amul dara luy kumpa lu ñu warula siiwal, mbaa mu làqu te warul ne fàŋŋ. ");
INSERT INTO wol2010_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Déglul bu baax, yaw mi am ay nopp.» ");
INSERT INTO wol2010_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Mu ne leen: «Seetleen bu baax li ngeen di dégg. Dees na leen nattal ak natt, bi ngeen di nattale, te dollil leen. ");
INSERT INTO wol2010_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Ku am, dees na la dollil; ku amul, li nga am as néew, dees na ko nangu.» ");
INSERT INTO wol2010_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Yeesu teg ci ne: «Nguuru Yàlla dafa mel ni nit ku ji tool. ");
INSERT INTO wol2010_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Muy nelaw walla muy xool, guddi mbaa bëccëg, jiwu wi sax, di màgg, te xamul naka la ko defe. ");
INSERT INTO wol2010_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Suuf day meññ moom ci boppam, mu sax, focci, def i gub. ");
INSERT INTO wol2010_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Bu gub yi ñoree nag, mu dagg ko, ndaxte ngóob jot na.» ");
INSERT INTO wol2010_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Yeesu ne leen ati: «Lu nu mana méngaleel nguuru Yàlla? Walla ban léeb lanu ko mana misaale? ");
INSERT INTO wol2010_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Dafa mel ni doomu fuddën, bi gëna tuuti ci jiwu yépp; ");
INSERT INTO wol2010_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","waaye boo ko jiyee, day jóg, màgg, ba sut gàncaxi tóokër yépp; mu sax ay bànqaas yu réy, ba picci asamaan tàgg ci keram.» ");
INSERT INTO wol2010_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Noonu Yeesu dégtal leen yeneen léeb yu bare yu mel ni yii, di leen xamal kàddu gi, aju ci lu ñu àttan. ");
INSERT INTO wol2010_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Daawu leen wax dara lu dul ciy léeb. Waaye bu wéetee ak ay taalibe, daan na leen firil lépp. ");
INSERT INTO wol2010_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Bés booba nag ci ngoon Yeesu ne taalibe yi: «Nanu jàll dex gi.» ");
INSERT INTO wol2010_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Mu yiwi mbooloo mi nag, ay taalibeem jël ko ni mu mel ci gaal gi; te yeneen gaal ànd ak moom. ");
INSERT INTO wol2010_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Naka noona ngelaw lu mag daldi jóg, duus yi sàng gaal gi, ba mu bëgga fees. ");
INSERT INTO wol2010_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Fekk Yeesu tëdd di nelaw ci ngegenaay ci taatu gaal gi. Taalibe yi daldi ko yee naan: «Kilifa gi, ndax sunu bakkan soxalu la?» ");
INSERT INTO wol2010_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Ci kaw loolu Yeesu jóg, daldi gëdd ngelaw li, ne dex gi: «Noppil te dal!» Noonu ngelaw li dal, ba lépp ne nemm. ");
INSERT INTO wol2010_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Yeesu ne taalibe ya: «Lu tax ngeen tiit? Ndax gëmaguleen?» ");
INSERT INTO wol2010_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Ñu daldi ragal lool, naan ci seen biir: «Kii moo di kan, ba ngelaw li ak dex gi sax di ko déggal?» ");
INSERT INTO wol2010_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Noonu ñu jàll dex ga, ba teer ci diiwaanu waa Serasa. ");
INSERT INTO wol2010_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Bi Yeesu génnee gaal gi, nit ku rab jàpp jóge ca sëg ya, daldi ñëw kar ko. ");
INSERT INTO wol2010_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Kooku nag ca sëg ya la dëkk, te kenn manu koo yeew, du ak càllala sax. ");
INSERT INTO wol2010_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Ndaxte ay yoon yu bare jéngoon nañu ko te yeew ko ak ay càllala, waaye waa ji daldi dagg càllala yi te damm jéng yi, ba kenn amul woon kàttanu téye ko. ");
INSERT INTO wol2010_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Guddi ak bëccëg mu nga woon ca sëg ya ak ca tund ya, di yuuxu te jam yaramam ak ay xeer. ");
INSERT INTO wol2010_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Bi mu gisee Yeesu fu sore nag, mu daldi dawsi, sukk fa kanamam, ");
INSERT INTO wol2010_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","di xaacu naan: «Yaw Yeesu Doomu Yàlla Aji Kawe ji, loo may fexeel? Ci turu Yàlla, bu ma mbugal.» ");
INSERT INTO wol2010_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Ndaxte Yeesu da ko ne: «Yaw rab wu bon wi, génnal ci nit ki.» ");
INSERT INTO wol2010_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Noonu Yeesu laaj ko: «Noo tudd?» Mu ne ko: «Coggal laa tudd, ndaxte ñu bare lanu.» ");
INSERT INTO wol2010_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Muy ñaan Yeesu lool, ngir mu bañ leena dàq ca réew ma. ");
INSERT INTO wol2010_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Fekk amoon na fa ca tund wa géttu mbaam-xuux yu bare yuy for. ");
INSERT INTO wol2010_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Rab ya ñaan Yeesu: «Jox nu ndigal, nu dugg mbaam-xuux ya.» ");
INSERT INTO wol2010_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Mu may leen ko. Noonu rab ya génn nit ka, dugg mbaam-xuux ya, ñu daldi bartalu, daanu ca dex ga, lab fa. Mbaam-xuux ya nag matoon nañu ñaari junni. ");
INSERT INTO wol2010_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Noonu sàmm ya daw ca dëkk ba ak ca àll ba, nettaliji mbir mi, ba nit ñi ñëw, seet li xew. ");
INSERT INTO wol2010_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Ñu ñëw nag ci Yeesu, gis ka rab ya jàppoon toog, sol ay yére te ànd ak sagoom. Ñu daldi ragal. ");
INSERT INTO wol2010_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Ña fekke woon mbir ma nag nettali leen mbirum nit ka ak mbaam-xuux ya. ");
INSERT INTO wol2010_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Ci kaw loolu ñu daldi ñaan Yeesu, mu sore seen réew. ");
INSERT INTO wol2010_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Bi Yeesu di dugg ci gaal gi, ki rab ya jàppoon ñaan Yeesu, ngir ànd ak moom. ");
INSERT INTO wol2010_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Waaye Yeesu mayu ko ko. Mu ne ko: «Ñibbil ci say bokk, nettali leen ni la Boroom bi yërëme, ba defal la lii lépp.» ");
INSERT INTO wol2010_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Noonu waa ji dem ci diiwaanu Fukki dëkk yi, daldi fa yégle la ko Yeesu defal, ba ñépp waaru. ");
INSERT INTO wol2010_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Noonu Yeesu jàllaat dex ga, taxaw ca tefes ga. Te nit ñu bare dajaloo, wër ko. ");
INSERT INTO wol2010_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Kenn ci njiiti jàngu ba nag, tudd Yayrus, ñëw ci moom. Naka la gis Yeesu, mu daanu ciy tànkam, ");
INSERT INTO wol2010_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","di ko sarxu lu bare naan: «Sama doom ju jigéen mi ngi bëgga faatu; kaay teg ko loxo, ngir mu wér te dund.» ");
INSERT INTO wol2010_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Noonu Yeesu ànd ak moom. Bi muy dem, mbooloo mu réy topp ko, di ko tanc. ");
INSERT INTO wol2010_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Amoon na fa nag jigéen ju doon xëpp deret diirub fukki at ak ñaar. ");
INSERT INTO wol2010_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Sonnoon na lool ci loxoy fajkat yu bare, sànk ci alalam jépp te jëlewu ci genn tan, waaye faf wopp ja yokku. ");
INSERT INTO wol2010_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","28","Noonu mu déggoon turu Yeesu, ne ci boppam: «Su ma laalee ay yéreem rekk, dinaa wér.» Mu jaxasoo ak mbooloo mi nag, doxe ko gannaaw, laal mbubbam. ");
INSERT INTO wol2010_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Ci saa si deret ji taxaw, mu yég ci yaramam ne jàngoroom deñ na. ");
INSERT INTO wol2010_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Yeesu yég ci saa si ne, doole génn na ci moom. Mu walbatiku nag ne mbooloo mi: «Ana ku laal samay yére?» ");
INSERT INTO wol2010_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Ay taalibeem ne ko: «Xanaa gisuloo mbooloo mi lay wër; ngay laaj: “Ku ma laal?”» ");
INSERT INTO wol2010_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Waaye Yeesu di xool li ko wër, ngir gis ku ko def. ");
INSERT INTO wol2010_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Noonu jigéen ja ñëw, daanu ciy tànkam, wax ko dëgg gépp; mu tiit bay lox, ndaxte xam na li xewoon ci yaramam. ");
INSERT INTO wol2010_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Yeesu ne ko: «Soxna si, sa ngëm faj na la; demal ci jàmm, te na sa jàngoro wàcc.» ");
INSERT INTO wol2010_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Bi Yeesu di wax nag, am na ku jóge ca kër njiit la, mu ñëw naan: «Sa doom faatu na; matatul nuy sonal kilifa gi.» ");
INSERT INTO wol2010_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Waaye Yeesu jàppul wax jooju; mu ne njiit la: «Gëmal rekk te baña tiit.» ");
INSERT INTO wol2010_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Noonu Yeesu dem, ànd ak Piyeer, Saag ak Yowaana rekk, ndaxte mayul keneen, mu ànd ak moom. ");
INSERT INTO wol2010_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Naka lañu ñëw ci kër njiit li, Yeesu dégg coow li; ñii di jooy, ñii di yuuxu. ");
INSERT INTO wol2010_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Mu dugg ne leen: «Lu ngeen di soow, tey jooy? Janq bi deewul, day nelaw rekk.» ");
INSERT INTO wol2010_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Waaye ñu di ko ñaawal. Noonu Yeesu génne ñépp, woo baayu janq bi ak yaay ji ak ñi mu àndal, dugg fa janq bi nekk. ");
INSERT INTO wol2010_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Mu jàpp loxoom ne ko: «Talita kumi,» liy tekki: «Janq bi, maa ngi la koy wax, jógal.» ");
INSERT INTO wol2010_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Ca saa sa janq bi jóg, daldi dox, ndaxte amoon na fukki at ak ñaar. Ñépp daldi waaru, ba ne jomm. ");
INSERT INTO wol2010_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Ci kaw loolu Yeesu dénk leen bu wóor, ñu bañ koo siiwal; teg ca naa: «Mayleen janq bi, mu lekk.» ");
INSERT INTO wol2010_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Bi loolu amee Yeesu jóge fa, dellu réewam, ànd ak taalibe yi. ");
INSERT INTO wol2010_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Bésub noflaay bi nag mu jàngal leen ci seen jàngu, ba mbooloom ñi ko dégg waaru naan: «Lii, fu mu ko jële, te xam-xam bii mu yor, lu mu doon, ba muy def kéemaan yii? ");
INSERT INTO wol2010_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Ndax kii du minise bi? Ndax du doomu Maryaama te magu Saag, Yuusufa, Yuda ak Simoŋ? Te ay rakkam yu jigéen ndax nekkuñu fi ak nun?» Kon nag ñu daldi ko xeeb. ");
INSERT INTO wol2010_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Noonu Yeesu ne leen: «Dees na faaydaal yonent, waaye du ci réewam, ciy bokkam mbaa ci këram.» ");
INSERT INTO wol2010_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Yeesu manu faa def ay kéemaan yu bare, lu dul teg loxo yenn jarag, wéral leen. ");
INSERT INTO wol2010_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Mu waaru ndax seen ngëmadi. Bi loolu amee Yeesu di wër dëkk ya, di jàngle. ");
INSERT INTO wol2010_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Noonu mu woo ci moom fukki taalibe ya ak ñaar, jox leen sañ-sañu dàq rab yi, yónni leen, ñu ànd ñaar-ñaar. ");
INSERT INTO wol2010_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Mu digal leen nii: «Bu ngeen di dem, buleen yóbbaale dara; du mburu mbaa mbuus mbaa xaalis ci seeni maxtume, waaye yemleen ci aw yet rekk. ");
INSERT INTO wol2010_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Sol-leen ay dàll te yem ci benn turki.» ");
INSERT INTO wol2010_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Mu ne leen: «Kër gu ngeen dugg, dal-leen fa, ba kera ngeen jóge dëkk ba. ");
INSERT INTO wol2010_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Koo xam ne gàntu na leen, mbaa mu tanqamlu leen, génnleen fa, yëlëb seen pëndu tànk, ngir seede leen seen réer.» ");
INSERT INTO wol2010_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Noonu taalibe ya dem, di waare naan: «Tuubleen seeni bàkkaar.» ");
INSERT INTO wol2010_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Ñu dàq ay rab yu bare, te diw boppi jarag yu bare, wéral leen. ");
INSERT INTO wol2010_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Noonu Erodd buur bi dégg loolu, ndaxte turu Yeesu siiwoon na. Mu ne nag: «Yaxya dekki na, moo tax mu ànd ak kàttanu def ay kéemaan.» ");
INSERT INTO wol2010_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Ñeneen ne: «Kii Ilyaas la.» Ñi ci des ne: «Yonent la, bu mel ni yonent yu jëkk ya.» ");
INSERT INTO wol2010_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Waaye bi ko Erodd déggee, mu ne: «Yaxya male ma dagglu boppam, moom moo dekki.» ");
INSERT INTO wol2010_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Fekk Erodd yónnee woon na, jàpp Yaxya, yeew ko, tëj. Ndaxte Erodd takkoon na Erojàdd jabaru Filib magam. ");
INSERT INTO wol2010_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Te Yaxya ne ko: «Jaaduwul nga denc sa jabaru mag.» ");
INSERT INTO wol2010_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Moo tax Erojàdd ëmbal ko mer, ba bëgg koo rey, waaye manu koo def. ");
INSERT INTO wol2010_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Ndaxte Erodd dafa ragal Yaxya, ba sàmm bakkanam, xam ne ku jub la te sell. Bu ko daan déglu it, day jaaxle lool, teewul mu bég ci déglu ko. ");
INSERT INTO wol2010_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Noonu bés bu yell ñëw, ba Erodd doon màggal bésu juddoom; mu woo ca xew wa ay jaraafam ak kilifay xare ba ak njiiti diiwaanu Galile. ");
INSERT INTO wol2010_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Booba doomu Erojàdd dugg di fecc, mu neex Erodd ak gan ñi, ba buur bi ne janq bi: «Laaj ma loo bëgg, dinaa la ko jox.» ");
INSERT INTO wol2010_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Mu boole ci ngiñ ne ko: «Loo ma mana laaj, dinaa la ko jox, ba ci genn-wàllu réew mi sax.» ");
INSERT INTO wol2010_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Noonu janq bi génn ne ndeyam: «Lu may laaj?» Mu ne ko: «Laajal boppu Yaxya.» ");
INSERT INTO wol2010_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Mu daldi gaawantu dugg nag ci kanam buur bi ne ko: «Damaa bëgg, nga indil ma léegi boppu Yaxya ci biir ndab.» ");
INSERT INTO wol2010_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Bi ko buur ba déggee, mu am naqar wu réy. Waaye bëggu koo gàntu ndax ngiñ li ak gan ñi. ");
INSERT INTO wol2010_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Mu daldi yónni nag xarekat, jox ko ndigal, mu indil ko boppu Yaxya. Waa ji dem, dagg boppu Yaxya ca kaso ba, ");
INSERT INTO wol2010_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","indi bopp bi ci biir ndab, jox ko janq bi, mu daldi ko jox yaayam. ");
INSERT INTO wol2010_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Ba taalibey Yaxya déggee loolu, ñu ñëw, fab néew ba, suul ko ci bàmmeel. ");
INSERT INTO wol2010_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Gannaaw loolu ndaw yi dajaloo ci wetu Yeesu, nettali li ñu def ak li ñu jàngle lépp. ");
INSERT INTO wol2010_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Ci kaw loolu Yeesu ne leen: «Nanu beddeeku, dem ci bérab bu wéet; ngeen noppalu fa tuuti.» Waxoon na loolu, ndaxte amoon na ñu bare ñu doon dem ak a dikk, ba amuñu sax jot ngir lekk. ");
INSERT INTO wol2010_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Noonu ñu dugg cig gaal, dem ca bérab bu wéet. ");
INSERT INTO wol2010_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Bi ñuy dem nag, am ñu leen gis, xàmmi leen, ñu daldi jóge ci dëkk yépp, daw, jiitu leen fa. ");
INSERT INTO wol2010_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Bi Yeesu génnee gaal gi, mu gis mbooloo mu réy, yërëm leen, ndaxte dañoo mel ni xar yu amul sàmm. Kon mu daldi leen jàngal lu bare. ");
INSERT INTO wol2010_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Ca ngoon sa taalibe yi ñëw ci moom ne ko: «Fii àllub neen la, te léegi mu guddi. ");
INSERT INTO wol2010_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Yiwil mbooloo mi nag, ñu dugg ci àll bi ak dëkk yi nu wër, jënd lu ñu lekk.» ");
INSERT INTO wol2010_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Waaye Yeesu ne leen: «Yéen joxleen leen lu ñu lekk.» Ñu ne ko: «Xanaa nu jënd lu tollook peyu juróom ñetti weer ci mburu, jox leen ñu lekk?» ");
INSERT INTO wol2010_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Yeesu laaj leen: «Ñaata mburu ngeen am? Demleen seeti.» Ñu dem seeti ne ko: «Juróomi mburu ak ñaari jën.» ");
INSERT INTO wol2010_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Noonu Yeesu sant mbooloo mi, ñu def ay géew, toog ci ñax mu naat mi. ");
INSERT INTO wol2010_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Ñu toog nag ay géewi juróom fukk ak téeméer. ");
INSERT INTO wol2010_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Bi loolu amee Yeesu jël juróomi mburu yi ak ñaari jën yi, xool ci kaw, sant Yàlla, ba noppi mu damm mburu yi, jox ko taalibe yi, ngir ñu séddale ko mbooloo mi. Ñaari jën yi it mu séddale ko ñépp. ");
INSERT INTO wol2010_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Noonu ñépp lekk ba suur. ");
INSERT INTO wol2010_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Te it ñu dajale la desoon ca dammiti mburu ak jën ya, mu nekk fukki pañe ak ñaar yu fees. ");
INSERT INTO wol2010_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Ñu lekkoon nag matoon na limu juróomi junniy góor. ");
INSERT INTO wol2010_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Ci kaw loolu Yeesu sant ay taalibeem, ñu dugg ci gaal gi, jàll ba Betsayda, bi muy yiwi mbooloo mi. ");
INSERT INTO wol2010_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Bi mu tàggtoo ak mbooloo mi, mu yéeg ca tund wa, ñaan fa Yàlla. ");
INSERT INTO wol2010_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Noonu guddi jot, fekk gaal gi nekk ci diggu dex gi, te Yeesu rekk moo nekk ca tefes ga. ");
INSERT INTO wol2010_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Booba mu gis taalibe yi sonn lool ci joow gaal gi ndax li leen ngelaw li soflu. Ca njël nag mu jëm ci ñoom, di dox ci kaw dex gi, ba xaw leena raw. ");
INSERT INTO wol2010_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Bi ñu ko gisee nag, muy dox ci kaw dex gi, ñu foog ne njuuma la, daldi yuuxu. ");
INSERT INTO wol2010_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Ndaxte ñépp gis ko te jommi ci. Waaye mu wax ak ñoom ci saa si ne leen: «Takkleen seen fit, man la, buleen tiit!» ");
INSERT INTO wol2010_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Noonu mu fekksi leen ci gaal gi, ngelaw daldi ne tekk. ");
INSERT INTO wol2010_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Njàqarey taalibe ya nag weesu dayo, ndaxte seen xol dafa fatt, ba réere mbir kéemaan, gi Yeesu defoon ci mburu yi. ");
INSERT INTO wol2010_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Bi nga xamee ne jàll nañu, ba egg diiwaanu Senesaret, ñu teer fa, ");
INSERT INTO wol2010_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","génn ca gaal ga. Ci saa si nit ñi xàmmi ko, ");
INSERT INTO wol2010_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","ñu daldi daw ca diiwaan ba bépp, te fépp fu ñu ko dégg ñu di ko indil ñu wopp, tëdd ci seeni lal. ");
INSERT INTO wol2010_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Te fu mu mana aw, ci dëkk yu mag mbaa yu ndaw walla ci àll bi, ñu indil ko jarag yi ci pénc yi, ñaan ko, mu may leen ñu laal cati mbubbam rekk. Te képp ku ko laal daldi wér. ");
INSERT INTO wol2010_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Amoon na bés nag, ay Farisen ak ay xutbakat yu jóge Yerusalem ñëw ci Yeesu. ");
INSERT INTO wol2010_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Ñu gis yenn ciy taalibeem di lekk, fekk seeni loxo setul, maanaam raxasuwuñu woon, ni ko aada santaanee. ");
INSERT INTO wol2010_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Farisen yi nag ñoom ak Yawut yi yépp dañuy topp aaday yoon, yi maam yi tëral, te fandee leen gënal lekk ak loxo yu ñu raxasul. ");
INSERT INTO wol2010_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Te it bu ñu jógee pénc ma, su ñu sanguwul set, duñu lekk. Am nañu it yeneen aada yu bare, maanaam ni nga wara raxase ay kaas, ay njaq ak ay satala, ba ñu laab. ");
INSERT INTO wol2010_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Noonu Farisen ya ak xutbakat ya laaj ko ne: «Lu tax say taalibe duñu topp aaday yoon, yi maam yi tëral, waaye ñuy lekk ak loxo yu setul?» ");
INSERT INTO wol2010_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Yeesu ne leen: «Esayi waxoon na bu baax ci kàddug Yàlla ci seen mbir, yéen naaféq yi, bi mu bindee: “Xeet wii, ñu ngi may teral ci seen gémmiñ, waaye seen xol sore na ma. ");
INSERT INTO wol2010_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Seen màggal amul benn njariñ, ci li ñuy jàngle dénkaaney nit kese.”» ");
INSERT INTO wol2010_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Yeesu neeti leen: «Dëddu ngeen ndigali Yàlla, jublu ci aaday nit.» ");
INSERT INTO wol2010_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Mu teg ca ne leen: «Xelu ngeen ci tebbi ndigali Yàlla, ngir sàmm seen aada. ");
INSERT INTO wol2010_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Ndaxte Musaa nee na: “Teralal sa ndey ak sa baay,” teg ca ne: “Ku móolu sa yaay walla sa baay, dees na la rey.” ");
INSERT INTO wol2010_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Waaye yéen dangeen ne: ku ne sa yaay walla sa baay: “Li nga wara jariñoo ci man Korban la,” —maanaam saraxu Yàlla la— ");
INSERT INTO wol2010_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","dootuleen ko bàyyi, mu defal dara ndeyam walla baayam. ");
INSERT INTO wol2010_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Noonu tebbi ngeen kàddug Yàlla ndax seen aada, ji ngeen di donnante. Te it yéena ngi def yeneen yu bon yu mel nii.» ");
INSERT INTO wol2010_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Noonu Yeesu waxaat ak mbooloo mi ne leen: «Yéen ñépp dégluleen ma te xam. ");
INSERT INTO wol2010_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","16","Li ci biti, tey dugg nit, du ko mana indil sobe, waaye li génn ci nit, loolu mooy indil nit sobe.» ");
INSERT INTO wol2010_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Bi nga xamee ne jóge nañu ci mbooloo mi, dugg ci kër gi, taalibe yi laaj Yeesu, mu firil leen wax ju làqu jooju. ");
INSERT INTO wol2010_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Yeesu ne leen: «Ndax yéen itam seen xol dafa tëju? Xanaa xamuleen ne, dara lu jóge biti, dugg ci nit, du ko mana indil sobe, ");
INSERT INTO wol2010_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","ndaxte du dugg ci xol, waaye ci biiram lay jëm, ba noppi daldi génn ca bérab bu làqu?» Ci li mu wax loolu Yeesu daganal na bépp ñam. ");
INSERT INTO wol2010_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Yeesu ne leen ati: «Li génn ci nit, loolu mooy indil nit sobe. ");
INSERT INTO wol2010_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Ndaxte ci biir, ci xolu nit, la xalaat yu bon di jóge ak ndoxaanu yàqute, càcc ak bóom, ");
INSERT INTO wol2010_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","njaaloo ak bëgge, coxor, naaféq, ñaawteef, ñeetaan, saaga, réylu ak jëfi ndof. ");
INSERT INTO wol2010_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Lu bon loolu lépp day génn ci nit, di ko indil sobe.» ");
INSERT INTO wol2010_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Gannaaw loolu Yeesu jóge fa, jëm weti dëkku Tir. Bi mu fa eggee, mu dugg ci kër, te bëggul kenn xam ko, waaye jataayam manula umpe. ");
INSERT INTO wol2010_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Amoon na fa nag jigéen ju rab jàpp doomam ju jigéen. Bi mu déggee ne, Yeesoo nga fa, mu ñëw, daanu ciy tànkam, ");
INSERT INTO wol2010_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","fekk jigéen ja ci xeetu Gereg la bokkoon, juddoo wàlli Fenisi ci diiwaanu Siri. Noonu jigéen ja ñaan ko, mu dàq rab wi ci doomam. ");
INSERT INTO wol2010_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Waaye Yeesu ne ko: «Na gone yi jëkka lekk, ba regg; fab ñamu gone yi, sànni ko xaj yi, rafetul.» ");
INSERT INTO wol2010_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Jigéen ji ne ko: «Waaw, sang bi, teewul xaj yi di lekk ruusit, yi rot ci lekkukaayu gone yi.» ");
INSERT INTO wol2010_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Ci kaw loolu Yeesu ne ko: «Ndax wax jooju demal ci jàmm, rab wa génn na sa doom.» ");
INSERT INTO wol2010_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Noonu mu ñibbi, fekk doom ji tëdd cib lal te mucc ci rab wi. ");
INSERT INTO wol2010_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Bi loolu amee Yeesu jóge na weti Tir, jaar ci wàlli dëkku Sidon, dem dexu Galile, ba noppi dugg ci biir diiwaan, bi ñuy wax Fukki dëkk yi. ");
INSERT INTO wol2010_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Foofa ñu indil ko ku tëx te dër lool, ñaan ko mu teg ko loxo. ");
INSERT INTO wol2010_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Noonu Yeesu yóbbu ko, ba ñu sore mbooloo mi, mu def ay baaraamam ciy noppam, daldi tifli, laal làmmiñam. ");
INSERT INTO wol2010_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Mu yërëm ko, ba binni ci xolam, xool ci asamaan, daldi ne: «Effata,» liy tekki «Ubbikuleen.» ");
INSERT INTO wol2010_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Ci saa si ay noppam daldi dégg te làmmiñam yiwiku, muy wax bu leer. ");
INSERT INTO wol2010_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Bi mu ko defee Yeesu tere leen, ñu wax ko kenn, waaye lu mu leen ko gëna tere, ñu gën ko nee siiwale. ");
INSERT INTO wol2010_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Ñu waaru lool naan: «Lépp lu mu def, lu yéeme la. May na sax tëx yi ñuy dégg, ak luu yi ñuy wax.» ");
INSERT INTO wol2010_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Ca bés yooya mbooloo mu réy amaatoon na, te amuñu woon lu ñu lekk. Noonu Yeesu woo taalibe ya ne leen: ");
INSERT INTO wol2010_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","«Yërëm naa mbooloo mi, ndaxte toog nañu fi man ñetti fan, te amatuñu lu ñu lekk. ");
INSERT INTO wol2010_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Su ma leen yiwee ak seen xiif, dinañu tële ci yoon wi, ndaxte am na ñu jóge fu sore.» ");
INSERT INTO wol2010_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Taalibe yi ne ko: «Waaye fii àllub neen la; fu nuy jële lu doy ngir dundal leen?» ");
INSERT INTO wol2010_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Yeesu laaj leen: «Ñaata mburu ngeen am?» Ñu ne ko: «Juróom ñaar.» ");
INSERT INTO wol2010_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Noonu Yeesu sant mbooloo mi, ñu toog ci suuf. Mu jël juróom ñaari mburu yi, sant Yàlla, damm leen, jox leen taalibe yi, ngir ñu séddale leen mbooloo mi; taalibe yi def ko. ");
INSERT INTO wol2010_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Amoon na fa it tuuti jën yu ndaw. Yeesu jël ko, sant Yàlla, wax taalibe yi, ñu séddale leen itam mbooloo mi. ");
INSERT INTO wol2010_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Noonu nit ñi lekk ba suur, ba noppi taalibe yi dajale juróom ñaari dàmba yu fees ak dammit yi ci des. ");
INSERT INTO wol2010_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Ña ko fekke nag matoon nañu ñeenti junniy góor. ");
INSERT INTO wol2010_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Bi ko Yeesu defee, mu yiwi leen, daldi dugg ak taalibe ya ca gaal ga, dem ca wàlli Dalmanuta. ");
INSERT INTO wol2010_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Noonu Farisen yi ñëw, di werante ak moom; ñu fexe koo fiir, ba laaj ko kéemaan gu jóge ci asamaan tey firndeel yónnentam. ");
INSERT INTO wol2010_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Waaye Yeesu binni ci xolam ne leen: «Lu tax niti jamono jii di laaj kéemaan? Ci dëgg maa ngi leen koy wax, duñu jot genn kéemaan.» ");
INSERT INTO wol2010_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Ci kaw loolu Yeesu bàyyi leen, duggaat ci gaal gi, di jàll dex gi. ");
INSERT INTO wol2010_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Taalibe yi nag fàtte woon nañu yóbbaale mburu, te amuñu woon lu dul benn mburu ci gaal gi. ");
INSERT INTO wol2010_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Noonu Yeesu artu leen ne: «Wottuleen te moytu lawiiru Farisen yi ak ñi far ak buur bi Erodd.» ");
INSERT INTO wol2010_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Taalibe yi nag daldi werante naan: «Nun de indaalewunu mburu.» ");
INSERT INTO wol2010_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Waaye Yeesu yég loolu ne leen: «Lu tax ngeen di werante ci li ngeen indaalewul mburu? Xanaa gisaguleen te xamuleen? Ndax seen xol dafa fatt ba tey? ");
INSERT INTO wol2010_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Ndax ay gumbay njàccaar ngeen, te seeni nopp naqari? Xanaa fàttalikuwuleen; ");
INSERT INTO wol2010_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","bi ma dammee juróomi mburu ya ngir juróomi junni ña, ñaata pañe yu fees ak ay dammit ngeen ca dajale woon?» Ñu ne ko: «Fukk ak ñaar.» ");
INSERT INTO wol2010_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Yeesu neeti leen: «Te bés bi ma dammee juróom ñaari mburu yi ngir ñeenti junni ñi, ñaata dàmba yu fees ak dammit ngeen dajale woon?» Ñu ne ko: «Juróom ñaar.» ");
INSERT INTO wol2010_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Noonu Yeesu ne leen: «Ndax seen xol dafa tëju ba tey?» ");
INSERT INTO wol2010_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Gannaaw loolu ñu ñëw ci Betsayda. Foofa ñu indil Yeesu ku gumba, di ko ñaan, mu laal ko. ");
INSERT INTO wol2010_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Yeesu nag jàpp loxob gumba gi, yóbbu ko, ba génn dëkk bi. Mu def tiflit ciy bëtam, teg ko loxo naan: «Ndax gis nga dara?» ");
INSERT INTO wol2010_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Waa ji xool ne ko: «Gis naa ay nit, ñu mel ni ay garab, te ñu ngi dox.» ");
INSERT INTO wol2010_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Kon Yeesu laalaat bët yi, gumba gi ne xefeet, daldi wér, ba gis lépp bu leer. ");
INSERT INTO wol2010_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Ci kaw loolu Yeesu sant ko mu ñibbi ne ko: «Bul dugg ca dëkk ba.» ");
INSERT INTO wol2010_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Bi loolu amee Yeesu ànd ak ay taalibeem, dem ca dëkk, yi wër Sesare bu Filib. Bi ñuy dem nag, mu laaj taalibe yi: «Nit ñi, lu ñu wax ne man moom laa?» ");
INSERT INTO wol2010_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Ñu ne ko: «Am na ñuy ne yaa di Yaxya; ñeneen ne, Ilyaas; ñi ci des ne yaay kenn ci yonent yi.» ");
INSERT INTO wol2010_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Noonu Yeesu laaj leen: «Yéen nag, ku ngeen wax ne moom laa?» Piyeer ne ko: «Yaa di Almasi bi.» ");
INSERT INTO wol2010_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Ci kaw loolu Yeesu dénk leen bu wóor, ñu bañ koo wax kenn. ");
INSERT INTO wol2010_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Booba Yeesu tàmbali na leena xamal ne, Doomu nit ki war na sonn lu bare; njiit ya, sarxalkat yu mag ya ak xutbakat ya dëddu ko, ñu rey ko, mu dekki ci ñetti fan. ");
INSERT INTO wol2010_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Noonu mu xamal leen mbir mi, ba mu leer nàññ. Bi ko Piyeer déggee, mu woo ko ci pegg, daldi ko yedd. ");
INSERT INTO wol2010_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Waaye Yeesu geestu, gis yeneen taalibe yi, mu daldi yedd Piyeer ne ko: «Sore ma Seytaane; yëfi nit ngay fonk, waaye du yëfi Yàlla.» ");
INSERT INTO wol2010_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Noonu Yeesu woo taalibe yi ak mbooloo mi ne leen: «Ku bëgga topp ci samay tànk, na bàyyi boppam te gàddu bant bi ñu ko wara daaj, doora topp ci man. ");
INSERT INTO wol2010_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Ndaxte koo xam ne bëgg ngaa rawale sa bakkan, dinga ko ñàkk, waaye ku ñàkk sa bakkan ngir man ak ngir xibaaru jàmm bi, dinga ko jotaat. ");
INSERT INTO wol2010_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Ndaxte moom àddina sépp, lu muy jariñ nit, bu ñàkkee bakkanam? ");
INSERT INTO wol2010_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Te nit, lu mu wara weccee bakkanam? ");
INSERT INTO wol2010_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Ku ma rusa faral, te nanguwul samay wax ci kanam niti jamono jii, ñi fecci seen kóllëre ak Yàlla te topp bàkkaar, Doomu nit ki dina la rusa xam, bés bu ñëwee ci ndamu Baayam, ànd ak malaaka yu sell yi.» ");
INSERT INTO wol2010_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Mu ne leen ati: «Ci dëgg maa ngi leen koy wax, am na ñi fi taxaw, ñoo xam ne duñu dee, te gisuñu nguuru Yàlla ñëw ak doole.» ");
INSERT INTO wol2010_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Juróom benni fan gannaaw gi, Yeesu àndoon na ak Piyeer, Saag ak Yowaana, mu yóbbu leen ñoom rekk fu wéet ci tund wu kawe lool. Foofa jëmmam soppiku ci seen kanam; ");
INSERT INTO wol2010_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","ay yéreem di ray-rayi, weex tàll, te fóotukatu àddina manu leen weexale nii. ");
INSERT INTO wol2010_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Noonu ñu gis yonenti Yàlla Ilyaas ak Musaa, di wax ak Yeesu. ");
INSERT INTO wol2010_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Piyeer daldi ne Yeesu: «Kilifa gi, bég nanu ci sunu teew fii; nanu defar ñetti mbaar, benn yaw, benn Musaa ak benn Ilyaas.» ");
INSERT INTO wol2010_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Fekk xamul lu muy wax, ndaxte tiitaange jàpp na leen ñoom ñett ñépp. ");
INSERT INTO wol2010_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Noonu niir muur leen, te baat jibe ca niir wa naan: «Kii mooy sama Doom ji ma bëgg, ci moom laa ame bànneex; dégluleen ko.» ");
INSERT INTO wol2010_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Ci saa si taalibe yi xool, waaye gisatuñu kenn ku dul Yeesu rekk. ");
INSERT INTO wol2010_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Bi loolu amee ñu wàcc ca tund wa. Bi muy wàcc nag, Yeesu sant leen ne: «Buleen nettali kenn li ngeen gis, ba kera Doomu nit ki dekki na.» ");
INSERT INTO wol2010_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Ñu téye wax jooju ci seen biir, di sotteente xel, ba xam lu ndekkite looluy tekki. ");
INSERT INTO wol2010_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Noonu taalibe yi laaj Yeesu: «Lu tax xutbakat yi di naan, Ilyaas moo wara jëkka ñëw?» ");
INSERT INTO wol2010_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Yeesu ne leen: «Waaw, Ilyaas dina jëkka ñëw, jubbanti lépp. Waaye itam lu tax bind nañu ne, Doomu nit ki war na sonn lu bare, ñu xeeb ko, dëddu ko. ");
INSERT INTO wol2010_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Waaye maa ngi leen di wax ne, Ilyaas ñëw na, te def nañu ko la leen neex, ni ko Mbind mi waxe.» ");
INSERT INTO wol2010_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Bi nga xamee ne Yeesu ñëw na, ba jege taalibe yi, mu gis mbooloo mu bare wër leen, te ay xutbakat di werante ak ñoom. ");
INSERT INTO wol2010_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Naka la mbooloo mi gis Yeesu, ñu waaru, daldi daw nuyu ko. ");
INSERT INTO wol2010_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Noonu Yeesu laaj leen: «Ci lan ngeen di werante ak ñoom?» ");
INSERT INTO wol2010_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","18","Kenn ci mbooloo mi ne ko: «Kilifa gi, rab jàpp na sama doom, ba luuloo ko. Saa su ko jàppee, daf koy daaneel ci suuf, gémmiñ gi di fuur, muy yéyu, ne jàdd. Ñaan naa say taalibe, ñu dàq ko, waaye manuñu ko.» ");
INSERT INTO wol2010_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Yeesu ne leen: «Yéen niti jamono jii, yéen ñi gëmadi, ba kañ laa wara nekk ak yéen, ba kañ laa leen wara muñal? Indil-leen ma xale bi.» ");
INSERT INTO wol2010_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Ñu indil ko ko. Bi xale bi gisee Yeesu nag, rab wi sayloo ko ci saa si, mu daanu ci suuf, di xalangu, gémmiñ giy fuur. ");
INSERT INTO wol2010_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Yeesu laaj baay bi: «Lii kañ la ko dal?» Baay bi ne ko: «Li dale ci ngoneem. ");
INSERT INTO wol2010_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Léeg-léeg rab wi bëmëx ko ci sawara, léeg-léeg mu bëmëx ko ci ndox, ngir rey ko. Soo ko manee, yërëm nu te xettali nu.» ");
INSERT INTO wol2010_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Yeesu ne ko: «Nga ne: “Soo ko manee,” ku gëm man na lépp.» ");
INSERT INTO wol2010_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Ci saa si baayu xale bi wax ci kaw naan: «Gëm naa, dàqal ma sama ngëmadi.» ");
INSERT INTO wol2010_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Yeesu gis nag ne, mbooloo maa ngi daw, wërsi ko, mu daldi gëdd rab wi nag ne ko: «Génnal ci moom, yaw rab wu luu te tëx, te bu ko jàppaat; wax naa la ko.» ");
INSERT INTO wol2010_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Noonu rab wa daldi yuuxu, sayloo xale bi, génn. Xale bi ne nemm, mel ni ku dee, ba tax ñu bare ne: «Dee na.» ");
INSERT INTO wol2010_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Waaye Yeesu jàpp loxoom, jógloo ko, xale bi daldi taxaw. ");
INSERT INTO wol2010_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Bi Yeesu duggee ci kër gi, taalibe yi laaj ko ci pegg: «Lu tax manunu ko woona dàq?» ");
INSERT INTO wol2010_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Yeesu ne leen: «Yu mel ni yii, ñaan ci Yàlla rekk a leen di dàq.» ");
INSERT INTO wol2010_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Bi loolu amee ñu jóge fa, jaar ci diiwaanu Galile, Yeesu bëggul kenn yég ko. ");
INSERT INTO wol2010_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","Ndaxte muy jàngal taalibe yi ne leen: «Dees na jébbal Doomu nit ki ci loxoy nit, te dinañu ko rey, mu dekki ci ñetti fan.» ");
INSERT INTO wol2010_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Waaye taalibe yi xamuñu lu wax joojuy tekki, te ñemewuñu ko koo laaj. ");
INSERT INTO wol2010_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Bi nga xamee ne egg nañu dëkku Kapernawum, te dugg ci kër gi, Yeesu laaj leen ne: «Lu ngeen doon waxtaane ci yoon wi?» ");
INSERT INTO wol2010_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Waaye ñu ne cell, ndaxte ñu ngi fa doon werante, ba xam ku gëna màgg ci ñoom. ");
INSERT INTO wol2010_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Noonu Yeesu toog, woo fukki taalibe ya ak ñaar ne leen: «Ku bëgga jiitu, na topp ci gannaaw ñépp te nekk surgab ñépp.» ");
INSERT INTO wol2010_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Bi ko Yeesu waxee, mu jël xale, indi ko ci biir géew bi, ba noppi leewu ko naan: ");
INSERT INTO wol2010_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","«Ku nangu xale bu mel ni bii ci sama tur, man mii nga nangu; te ku ma nangu, du man mii sax nga nangu waaye ki ma yónni.» ");
INSERT INTO wol2010_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Bi loolu amee Yowaana ne ko: «Kilifa gi, danoo gis nit kuy dàq ay rab ci sa tur, nu tere ko ko, ndax li mu bokkul ci nun.» ");
INSERT INTO wol2010_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Waaye Yeesu ne ko: «Buleen ko tere, ndaxte kenn manula def kéemaan ci sama tur, ba noppi di ma xarab. ");
INSERT INTO wol2010_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Ku nu sotul, far na ak nun. ");
INSERT INTO wol2010_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Ci dëgg maa ngi leen koy wax, koo xam ne kii may na leen kaasu ndox rekk, ndax yéena ngi bokk ci man Kirist, kooku du ñàkk yoolam mukk. ");
INSERT INTO wol2010_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","«Waaye ku yóbbe bàkkaar kenn ci ñi gëna tuuti ñi ma gëm, li gën ci moom, moo di ñu takk doj wu réy ci baatam, sànni ko ci géej. ");
INSERT INTO wol2010_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","44","Boo xamee ne sa loxo mu ngi lay yóbbe bàkkaar, dagg ko. Ndaxte ñàkk loxo te tàbbi ci dund gu wóor gi, moo gën ci yaw, nga am ñaari loxo te tàbbi ci sawara su dul fey mukk. ");
INSERT INTO wol2010_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","46","Te bu la sa tànk di yóbbe bàkkaar, dagg ko. Nga lafañ te tàbbi ci dund gu wóor gi moo gën, nga am ñaari tànk, ñu sànni la ci sawara. ");
INSERT INTO wol2010_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Te bu la sa bët di yóbbe bàkkaar, luqi ko. Nga patt te dugg ci nguuru Yàlla, moo gën ci yaw, nga am ñaari bët, ñu sànni la ci sawara. ");
INSERT INTO wol2010_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Foofa: “Sax ya duñu dee mukk, te sawara sa du fey.” ");
INSERT INTO wol2010_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Ñépp sawara lañu leen di xorome. ");
INSERT INTO wol2010_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Xorom lu baax la, waaye bu sàppee, nan lañu koy delloo cafkaam? Amleen xorom te ngeen jàmmoo.» ");
INSERT INTO wol2010_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Gannaaw loolu Yeesu jóge fa, dem ca wàlli réewu Yawut yi, ya ca gannaaw dexu Yurdan. Bi mu fa demee, mbooloo mu bare ñëw fi moom. Yeesu daldi leen jàngal, ni mu ko daan defe. ");
INSERT INTO wol2010_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Noonu ay Farisen ñëw ci moom, lalal ko fiir, ñu laaj ko: «Ndax jaadu na, nit fase soxnaam?» ");
INSERT INTO wol2010_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Yeesu ne leen: «Lu leen yoonu Musaa sant?» ");
INSERT INTO wol2010_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Ñu ne ko: «Musaa maye na, nit bind kayitu pase, tàggook soxnaam.» ");
INSERT INTO wol2010_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Waaye Yeesu ne leen: «Dénkaane boobu mu leen bindal, bind na ko ndax seen xol dafa fatt. ");
INSERT INTO wol2010_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Waaye ca njàlbéen ga “Yàlla sàkk na leen, kii góor, kii jigéen. ");
INSERT INTO wol2010_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Looloo tax góor di teqalikook ndeyam ak baayam, ànd ak soxnaam, ");
INSERT INTO wol2010_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","ñoom ñaar doon benn.” Kon nekkatuñu ñaar waaye benn lañu. ");
INSERT INTO wol2010_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Lu Yàlla takk nag, bu ko nit tas.» ");
INSERT INTO wol2010_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Bi ñu delloo ca kër ga nag, taalibe ya laaj ko ci mbirum loolu. ");
INSERT INTO wol2010_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Noonu Yeesu ne leen: «Ku fase sa soxna, takk jeneen, njaaloo nga, di tooñ ku jëkk ka. ");
INSERT INTO wol2010_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Te jigéen ji tas, séyaat ak keneen, njaaloo nga.» ");
INSERT INTO wol2010_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Bi loolu wéyee ñu indil Yeesu ay xale, ngir mu teg leen ay loxoom. Waaye taalibe ya gëdd nit ñi. ");
INSERT INTO wol2010_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Bi ko Yeesu gisee nag, mu metti ko lool, mu ne leen: «Bàyyileen xale yi, ñu ñëw fi man! Buleen leen tere, ndaxte ñu mel ni ñoom ñoo yelloo nguuru Yàlla. ");
INSERT INTO wol2010_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Ci dëgg maa ngi leen koy wax, ku woyoful ni xale, nangu nguuru Yàlla, doo ci mana dugg.» ");
INSERT INTO wol2010_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Noonu Yeesu leewu leen, teg leen ay loxoom, barkeel leen. ");
INSERT INTO wol2010_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Gannaaw loolu bi Yeesu nekkee ci kaw yoon wi di dem, am ku daw, sukk ci kanamam ne ko: «Kilifa gu baax gi, lu ma wara def, ngir am wàll ci dund gu dul jeex gi?» ");
INSERT INTO wol2010_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Yeesu ne ko: «Lu tax nga wooye ma ku baax ki? Yàlla rekk a baax. ");
INSERT INTO wol2010_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Xam nga ndigal yi: “Bul bóome, bul njaaloo, bul sàcc, bul seede lu dul dëgg, bul nangu alalu jaambur, teralal sa ndey ak sa baay.”» ");
INSERT INTO wol2010_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Waa ji ne ko: «Kilifa gi, loolu lépp sàmm naa ko li dale ci samag ndaw ba tey.» ");
INSERT INTO wol2010_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Noonu Yeesu xool ko, am cofeel ci moom, mu ne ko: «Lenn rekk moo la dese. Demal jaay li nga am, jox ko miskin yi, te dinga woomle ci asamaan; boo noppee, nga ñëw topp ci man.» ");
INSERT INTO wol2010_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Waaye ci wax jooju xar kanamam lëndëm, mu jóge fa ak tiis, ndaxte ku bare woon alal la. ");
INSERT INTO wol2010_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Noonu Yeesu xool taalibe yi ko wër ne leen: «Boroom alal dugg ci nguuru Yàlla, lu jafee ngoogu!» ");
INSERT INTO wol2010_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Wax jooju nag daldi jaaxal taalibe yi lool. Waaye Yeesu neeti leen: «Samay xarit, dugg ci nguuru Yàlla, lu jafee ngoogu! ");
INSERT INTO wol2010_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Giléem jaar ci bën-bënu puso moo gëna yomb boroom alal dugg ci nguuru Yàlla.» ");
INSERT INTO wol2010_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Wax jooju gënatee jaaxal taalibe ya, ñu naan ci seen biir: «Kon nag ku mana mucc?» ");
INSERT INTO wol2010_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Noonu Yeesu xool leen naan: «Loolu të na nit, waaye tëwul Yàlla; Yàlla man na lépp.» ");
INSERT INTO wol2010_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Ci kaw loolu Piyeer daldi ko ne: «Nun de dëddu nanu lépp te topp la!» ");
INSERT INTO wol2010_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Yeesu ne ko: «Ci dëgg maa ngi leen koy wax, képp ku dëddu kër, doomu ndey yu góor walla yu jigéen, ndey walla baay, doom walla suuf ndax man ak xibaaru jàmm bi, ");
INSERT INTO wol2010_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","dinga am tey jii téeméeri yoon ay kër, doomi ndey yu góor ak yu jigéen, ndey, doom ak suuf, ñoom ak ay fitnay noon, te ëllëg nga am dund gu dul jeex. ");
INSERT INTO wol2010_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Waaye ñu bare ci ñi jiitu ñooy mujji; ñi mujj ñooy jiituji.» ");
INSERT INTO wol2010_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Gannaaw loolu ñu ànd jëm Yerusalem, Yeesu jiitu; taalibe yi am njàqare, te ñi ci topp tiit. Noonu Yeesu woowaat fukk ak ñaar ña cig wet, xamal leen li nara xew ci mbiram. ");
INSERT INTO wol2010_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Mu ne leen: «Noo ngi dem Yerusalem, te dees na jébbal Doomu nit ki ci loxoy sarxalkat yu mag ya ak xutbakat ya. Dinañu ko àtte, teg ko dee, jébbal ko ñi dul Yawut, ");
INSERT INTO wol2010_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","ñu ñaawal ko, di tifli ci kawam, dóor ko ay yar, rey ko. Waaye gannaaw ñetti fan dina dekki.» ");
INSERT INTO wol2010_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Gannaaw loolu Saag ak Yowaana, doomi Sebede, ñëw ci Yeesu. Ñu ne ko: «Kilifa gi, danoo bëggoon nga may nu li nu lay ñaan.» ");
INSERT INTO wol2010_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Yeesu ne leen: «Lu ngeen bëggoon, ma may leen ko?» ");
INSERT INTO wol2010_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Ñu ne ko: «Bés boo soloo sa ndam, nga may nu, nu toog, kii ci sa ndijoor, kii ci sa càmmoñ.» ");
INSERT INTO wol2010_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Waaye Yeesu ne leen: «Xamuleen li ngeen di ñaan. Ndax man ngeena naan kaasu naqar, bi may naan? Ndax man ngeena sóobu ci metit, yi ma nara sóobu?» ");
INSERT INTO wol2010_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Ñu ne ko: «Waaw, man nanu ko.» Noonu Yeesu ne leen: «Dingeen naan kaasu naqar, bi may naan, tey sóobu ci metit, yi ma nara sóobu, ");
INSERT INTO wol2010_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","waaye toog ci sama ndijoor mbaa sama càmmoñ, du man maa koy maye. Ñi ñu ko waajal rekk a ko yelloo.» ");
INSERT INTO wol2010_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Bi nga xamee ne fukki taalibe ya ca des dégg nañu loolu, ñu daldi mere Saag ak Yowaana. ");
INSERT INTO wol2010_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Waaye Yeesu woo leen naan: «Xam ngeen ne ci xeeti àddina, ñi ñu teg njiit dañu leen di dóor yetu nguur, te kilifa yi di leen not. ");
INSERT INTO wol2010_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Buleen mel ni ñooñu. Waaye ku bëgga nekk kilifa ci yéen, na nekk seen surga, ");
INSERT INTO wol2010_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","te ku bëgga nekk njiit, na nekk seen jaam. ");
INSERT INTO wol2010_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Ndaxte noonu la Doomu nit ki ñëwe sax, du ngir ñu nekk ay surgaam, waaye ngir muy seen surga, ba joxe bakkanam ngir njotug ñu bare.» ");
INSERT INTO wol2010_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Bi loolu wéyee ñu agsi ca dëkku Yeriko. Bi ko Yeesu di génn, ànd ak taalibe ya ak mbooloo mu xawa bare, am gumba gu tudd Bartime— liy tekki «doomu Time», toog ci wetu yoon wi, di yelwaan. ");
INSERT INTO wol2010_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Noonu mu dégg ne, Yeesum Nasaret moo fay romb; mu daldi yuuxu naan: «Yërëm ma, yaw Sëtu Daawuda bi!» ");
INSERT INTO wol2010_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Ci kaw loolu ñu bare gëdd ko, ngir mu noppi. Teewul mu gëna yuuxu naan: «Yaw Sëtu Daawuda bi, yërëm ma!» ");
INSERT INTO wol2010_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Noonu Yeesu taxaw, daldi ne: «Wooleen ko!» Ñu woo nag gumba gi ne ko: «Na sa xel dal! Jógal! Mu ngi lay woo.» ");
INSERT INTO wol2010_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Bi mu ko déggee, mu sànni malaanam, ne bërét, dem ci Yeesu. ");
INSERT INTO wol2010_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Yeesu ne ko: «Loo bëggoon ma defal la ko?» Gumba gi ne ko: «Kilifa gi, damaa bëgga gis.» ");
INSERT INTO wol2010_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Noonu Yeesu ne ko: «Demal ci jàmm. Sa ngëm faj na la.» Ci saa si gumba gi gis, daldi topp Yeesu ci yoon wi. ");
INSERT INTO wol2010_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Gannaaw loolu Yeesu ak taalibe ya jege nañu Yerusalem, ba agsi dëkki Betfase ak Betani ci wetu tundu Oliw ya. Noonu Yeesu yebal ñaar ciy taalibeem, ");
INSERT INTO wol2010_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","ne leen: «Demleen ci dëkk bi ci kanam. Bu ngeen fa duggee, dingeen fa gis cumbur gu kenn masula war. Yiwileen ko, indi. ");
INSERT INTO wol2010_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Bu leen kenn nee: “Lu ngeen di def?” neleen ko: “Boroom bi da koo soxla, te léegi mu delloosi ko.”» ");
INSERT INTO wol2010_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Taalibe ya dem nag, ñu gis cumbur ga ci mbedd mi, mu yeewe cib buntu kër. ");
INSERT INTO wol2010_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Bi ñu koy yiwi nag, am na ca ña fa taxaw, ñu ne leen: «Lu ngeen nar, bay yiwi cumbur gi?» ");
INSERT INTO wol2010_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Taalibe yi wax leen, ni leen Yeesu digale woon, nit ñi bàyyi leen, ñu dem. ");
INSERT INTO wol2010_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Ñu indi cumbur gi Yeesu nag, lal ci seeni yére, mu toog ci. ");
INSERT INTO wol2010_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Ñu bare lal seeni yére ci yoon wi, ñenn ñi dagg ay cari garab ci tool yi, lal leen it ci yoon wi. ");
INSERT INTO wol2010_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Ñiy jiitu ak ñiy topp ci Yeesu ñépp di wax ci kaw naan: «Osaana! Yaw miy ñëw ci turu Boroom bi, ku barkeel nga! ");
INSERT INTO wol2010_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Nguuru sunu maam Daawuda giy ñëw dina barkeel! Ci bérab yu gëna kawe, nañu ne: “Osaana!”» ");
INSERT INTO wol2010_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Noonu Yeesu dugg Yerusalem, dem kër Yàlla ga, xool lépp, ba noppi génn dem dëkku Betani, moom ak fukki taalibe ya ak ñaar, ndaxte dafa guddi. ");
INSERT INTO wol2010_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Bët set ñu génn Betani, fekk Yeesu xiif. ");
INSERT INTO wol2010_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Noonu mu séen fu sore garabu figg gu sëq, mu dem seeti, ndax am na ay doom. Waaye bi mu fa eggee, gisul lu dul ay xob, ndaxte jamonoy figg duggagul. ");
INSERT INTO wol2010_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Ci kaw loolu mu ne garab gi: «Dootuloo meññ mukk!» Taalibe yi dégg loolu mu wax. ");
INSERT INTO wol2010_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Bi ñu eggee Yerusalem, Yeesu dugg ci kër Yàlla gi, daldi dàq ñi fay jaay ak ñi fay jënd. Mu daaneel taabali weccikatu xaalis yi ak tooguy jaaykati pitax yi, ");
INSERT INTO wol2010_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","te mayul kenn, mu yóbbu am njaay ci kër Yàlla gi. ");
INSERT INTO wol2010_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Mu di leen jàngal ne leen: «Ndax waxuñu ci Mbind mi: “Dees na wooye sama kër këru ñaan ci Yàlla ngir xeet yépp.” Waaye yéen def ngeen ko këru sàcc.» ");
INSERT INTO wol2010_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Bi ko sarxalkat yu mag ya ak xutbakat ya déggee nag, ñu ragal ko, ndaxte mbooloo mépp dañoo waaru ci njàngleem. Noonu ñu seet pexem reylu ko. ");
INSERT INTO wol2010_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Bi timis jotee Yeesu ak taalibe yi génn dëkk bi. ");
INSERT INTO wol2010_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Ci suba si, bi ñuy dem, ñu gis ne garabu figg gi dee na, ba wow koŋŋ. ");
INSERT INTO wol2010_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Noonu Piyeer fàttaliku li xewoon, ne Yeesu: «Kilifa gi, xoolal, figg gi nga rëbb dee na, ba wow!» ");
INSERT INTO wol2010_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Yeesu ne: «Gëmleen Yàlla. ");
INSERT INTO wol2010_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Ci dëgg maa ngi leen koy wax, ku ne tund wale: “Jógal, tàbbi ca géej ga,” te nga gëm ne loolu dina am, bañ cee boole xel ñaar, kon sa ñaan nangu. ");
INSERT INTO wol2010_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Moo tax maa ngi leen koy wax, bu ngeen di ñaan Yàlla, lépp lu ngeen ko mana laaj, gëmleen ne jot ngeen ko, te dingeen ko am. ");
INSERT INTO wol2010_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","26","Te it bu ngeen di ñaan, fekk ngeen jàppal kenn dara, baal-leen ko, ngir seen Baay bi ci kaw baal leen seeni tooñ, yéen itam.» ");
INSERT INTO wol2010_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Gannaaw loolu ñu duggaat Yerusalem, te Yeesu doon doxantu ca ëtti kër Yàlla ga. Noonu sarxalkat yu mag ya ak xutbakat ya ak njiit ya dab ko ");
INSERT INTO wol2010_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","ne ko: «Yëf yii ngay def, ci ban sañ-sañ nga koy defe? Te ku la may sañ-sañu def ko?» ");
INSERT INTO wol2010_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Yeesu ne leen: «Man itam dinaa leen laaj lenn; bu ngeen ma ci tontoo, kon dinaa leen wax ci ban sañ-sañ laay defe yëf yii. ");
INSERT INTO wol2010_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","La Yaxya daan def, di sóob nit ñi ci ndox, fu mu ko jële, ci Yàlla walla ci nit ñi?» ");
INSERT INTO wol2010_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Bi ñu ko déggee, ñuy werante ci seen biir naan: «Bu nu nee: “Ci Yàlla,” kon dina nu laaj: “Lu tax gëmuleen ko kon?” ");
INSERT INTO wol2010_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Waaye bu nu nee: “Ci nit ñi,” kon mbooloo mi dal ci sunu kaw;» ndaxte ñépp teg nañu Yaxya ab yonent. ");
INSERT INTO wol2010_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Ñu wax Yeesu nag ne: «Loolu de xamunu ko.» Noonu Yeesu ne leen: «Kon man itam duma leen wax ci ban sañ-sañ laay defe yëf yii.» ");
INSERT INTO wol2010_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Noonu Yeesu daldi leen wax ciy léeb. Mu ne leen: «Amoon na fi nit ku jëmbët toolu reseñ. Mu ñag tool bi, gas pax ngir nal ci reseñ yi, tabax wottukaay, ba noppi batale ko ay beykat, daldi tukki. ");
INSERT INTO wol2010_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","«Bi tool bi ñoree nag, mu yónni surga ci ñoom, ngir jot wàllam ci meññeef gi. ");
INSERT INTO wol2010_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Waaye ñu jàpp ko, dóor ko ay yar, dàq ko, mu dellu ak loxoy neen. ");
INSERT INTO wol2010_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Mu yónniwaat beneen surga, waaye ñu dóor ko ci bopp, toroxal ko. ");
INSERT INTO wol2010_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Mu yónneeti beneen surga, ñu rey ko. Mu yónni ñeneen ñu bare, ñii ñu dóor leen, ñii ñu rey. ");
INSERT INTO wol2010_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","«Noonu mu dese ko kenn rekk, di doomam ji mu bëgg. Mujj mu yónni ko naan: “Xëy na ñu weg sama doom.” ");
INSERT INTO wol2010_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Waaye beykat yi daldi ne ci seen biir: “Kii moo wara donn tool bi; nan ko rey, moom ndono li.” ");
INSERT INTO wol2010_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Ñu jàpp ko nag, rey, sànni ci biti.» ");
INSERT INTO wol2010_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Noonu Yeesu laaj leen: «Boroom tool bi nag, lu muy def? Xanaa ñëw, rey beykat ya, dénk tool ba ñeneen. ");
INSERT INTO wol2010_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Ndax masuleena jàng wax jii ci Mbind mi? “Doj wi tabaxkat yi sànni, mujj na di doju koñ; ");
INSERT INTO wol2010_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","ci Boroom bi la loolu jóge, te yéemu nanu ci.”» ");
INSERT INTO wol2010_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Noonu kilifa yi di wut pexem jàpp ko, ndaxte xam nañu ne ñoom lay wax. Waaye ragal nañu mbooloo mi, ba ñu bàyyi ko fa, dem. ");
INSERT INTO wol2010_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Bi loolu amee ñu yónni ci Yeesu ay Farisen ak ñu far ak buur bi Erodd, ngir fiir ko ci waxam. ");
INSERT INTO wol2010_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Ñu ñëw ci moom nag ne ko: «Kilifa gi, xam nanu ne ku wóor nga, te ragaloo kenn, ndaxte seetuloo jëmmi nit, waaye dangay xamle yoonu Yàlla ci bu wóor. Wax nu, ndax jaadu na, nu fey buur bi Sesaar galag am déet? Nu fey ko walla nu bañ koo fey?» ");
INSERT INTO wol2010_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Waaye Yeesu xam na seen naaféq, mu ne leen: «Lu tax ngeen bëgg maa fiir? Indil-leen ma posetu denariyon, ma seet.» ");
INSERT INTO wol2010_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Ñu jox ko poset bi. Noonu Yeesu laaj leen: «Kan lañu ci def nataalam ak turam?» Ñu ne ko: «Sesaar.» ");
INSERT INTO wol2010_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Noonu Yeesu ne leen: «Joxleen nag Sesaar li Sesaar moom, te jox Yàlla li Yàlla moom.» Ñu daldi waaru ci mbiram. ");
INSERT INTO wol2010_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Gannaaw loolu ay Sadusen ñëw ci moom, ngir laaj ko lenn. Sadusen yi nag gëmuñu ne ndekkite am na. ");
INSERT INTO wol2010_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","Ñu ne ko: «Kilifa gi, Musaa bindal na nu ne, ku magam faatu, te bàyyiwul doom ak soxnaam, kooku war na donn jigéen ji, ba yékkati giiru magam. ");
INSERT INTO wol2010_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","«Amoon na fi nag juróom ñaari góor, ñu bokk ndey ak baay. Taaw ba takk jabar, faatu, te bàyyiwul doom. ");
INSERT INTO wol2010_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Ñaareel ba takk jigéen ja, faatu moom itam te bàyyiwul doom. Ñetteel bi it noonu. ");
INSERT INTO wol2010_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Mbir mi dem na nag, ba juróom ñaar ñooñu ñépp dem, te kenn bàyyiwu fi doom. Mujj jigéen ja faatu moom itam. ");
INSERT INTO wol2010_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Ci ndekkite li nag kan ci ñoom moo ko wara donn, fekk ku nekk ci juróom ñaar ñi mas na koo takk?» ");
INSERT INTO wol2010_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Yeesu ne leen: «Mbaa du dangeena nekk cig réer, ci li ngeen xamul Mbind mi mbaa kàttanu Yàlla? ");
INSERT INTO wol2010_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Ndaxte keroog ndekkite li kenn du am jabar, kenn du am jëkkër, waaye dinañu mel ni malaaka yi ci kaw. ");
INSERT INTO wol2010_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Te sax li jëm ci mbirum ndekkite, xanaa jànguleen lii Yàlla wax ci Tawreetu Musaa ci saarum ngarab si: “Maay Yàllay Ibraayma, Isaaxa ak Yanqóoba”? ");
INSERT INTO wol2010_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Li ci génn mooy, nekkul Yàllay ñi dee, waaye Yàllay ñiy dund la. Kon sóobu ngeen cig réer.» ");
INSERT INTO wol2010_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Bi ñuy werante, benn xutbakat ñëw, dégg seen waxtaan, gis ne Yeesu tontu na leen tont lu leer. Mu laaj ko nag: «Ci ndigal yi, ban moo ci gëna màgg?» ");
INSERT INTO wol2010_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Noonu Yeesu ne ko: «Bii: “Dégluleen, yéen bànni Israyil! Yàlla sunu Boroom mooy Boroom bi, te kenn la. ");
INSERT INTO wol2010_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Kon nanga bëgg Yàlla sa Boroom ak sa xol bépp ak sa bakkan bépp, sa xel mépp ak sa kàttan gépp.” ");
INSERT INTO wol2010_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Te ñaareel bi, lii la: “Nanga bëgg sa moroom, ni nga bëgge sa bopp.” Ndigal yii ñoo sut yépp.» ");
INSERT INTO wol2010_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Xutbakat bi ne ko: «Waaw, kilifa gi, li nga wax dëgg la: Yàlla kenn la, te amul jeneen Yàlla ju dul moom. ");
INSERT INTO wol2010_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Te nga bëgg ko ak sa xol bépp ak sa xel mépp ak sa kàttan gépp moo dàq bépp sarax bu ñuy yóbbu ngir màggal Yàlla ak bu ñuy lakk ca sarxalukaay ba.» ");
INSERT INTO wol2010_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Bi Yeesu gisee nag ne tontu na ak xel, mu ne ko: «Sorewuloo nguuru Yàlla.» Bi mu waxee loolu, kenn ñemeetu koo laaj dara. ");
INSERT INTO wol2010_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Bi nga xamee ne Yeesu ma nga doon jàngle ca kër Yàlla ga, mu laaj nit ñi: «Lu tax xutbakat yi di wax ne, Almasi bi mooy sëtu Daawuda? ");
INSERT INTO wol2010_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Daawuda moom wax na ci kàttanu Xel mu Sell mi naan: “Boroom bi nee na sama Boroom: ‘Toogal ci sama ndijoor, ba kera may daaneel say noon ci sa kanam.’ ” ");
INSERT INTO wol2010_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Gannaaw Daawuda nag wooye na ko: “Boroom bi,” nu muy nekke sëtam?» Noonu mbooloo mu mag mi di ko déglu ak bànneex. ");
INSERT INTO wol2010_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Bi Yeesu di jàngle nag, mu ne leen: «Moytuleen xutbakat yi; dañoo bëgg di doxantu, sol ay mbubb yu réy, te ñépp di leen nuyoo ñaari loxo ci pénc mi. ");
INSERT INTO wol2010_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Ci jàngu yi, féete kanam lañuy wut, te toogu yu yiw lañuy taamu ci reeri xew yi. ");
INSERT INTO wol2010_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Ñu ngi lekk alalu jigéen ñi seeni jëkkër faatu, di ñaan Yàlla ay ñaani ngistal yu gudd. Seen mbugal dina gëna tar.» ");
INSERT INTO wol2010_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Noonu Yeesu toog ca kër Yàlla ga, janook ndab, yi ñuy def sarax ngir Yàlla, muy xool nit ña cay dugal seen xaalis. Am nag ay boroom alal yu ci di def xaalis bu bare. ");
INSERT INTO wol2010_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Gannaaw ga daal benn jigéen ju jëkkëram faatu, te mu ñàkk, ñëw, def ci ñaari poseti xànjar, yu matul sax dërëm. ");
INSERT INTO wol2010_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Bi ko Yeesu gisee, mu woo taalibe yi ne leen: «Ci dëgg maa ngi leen koy wax, li jigéen ju ñàkk jee dugal ca defukaay ya moo ëpp maana alalu ñeneen ñi ñépp. ");
INSERT INTO wol2010_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Ñoom ñépp dañu sàkk ci seen barele, waaye moom dafa sàkk ci néewleem, ba far ko joxe lépp, toog.» ");
INSERT INTO wol2010_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Bi Yeesu di jóge ca kër Yàlla ga, kenn ca taalibe ya ne ko: «Kilifa gi, xoolal! Ni mu réye ay doj, te rafete ni ay taax!» ");
INSERT INTO wol2010_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Waaye Yeesu ne leen: «Du gis ngeen taax yu réy yii yépp? Lii lépp dina daanu, ba doj dootul des ci kaw doj.» ");
INSERT INTO wol2010_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Gannaaw loolu, bi nga xamee ne Yeesu toog na ci tundu Oliw ya, jàkkaarlook kër Yàlla ga, Piyeer, Saag, Yowaana ak Andare fekki ko cig wet, laaj ko: ");
INSERT INTO wol2010_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","«Wax nu kañ la loolu di am? Te luy tegtal ne, mbir yii yépp a ngi bëgga mat?» ");
INSERT INTO wol2010_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Noonu Yeesu ne leen: «Moytuleen, bu leen kenn nax. ");
INSERT INTO wol2010_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Ñu bare dinañu ñëw ci sama tur naan: “Moom laa,” te dinañu nax ñu bare. ");
INSERT INTO wol2010_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Bu ngeen déggee ay xare ak coowi xare, wottuleena tiit; loolu war na am, waaye mujug jamono ji jotagul. ");
INSERT INTO wol2010_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Xeet dina jóg, xeex ak weneen xeet, réew xeex ak meneen réew. Te yëngu-yënguy suuf dina am ciy bérab yu bare, ak ay xiif. Loolu lépp mooy ndoortel metit yi, mel ni jigéen juy matu. ");
INSERT INTO wol2010_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","«Moytuleen. Dees na leen jébbal àttekat ya, di leen dóor ay yar ca jàngu ya. Dinañu leen dëj ci kanam i boroom réew ak i buur ndax sama tur, ngir ngeen nekk seede ci ñoom. ");
INSERT INTO wol2010_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Fàww xibaaru jàmm bi jëkka jib ci xeet yépp. ");
INSERT INTO wol2010_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Saa su ñu leen jàppee nag, dëj leen ci péncum layoo, buleen jàq ci li ngeen wara wax; li ngeen jot ca waxtu woowa waxleen ko, ndaxte du yéenay wax waaye Xel mu Sell mi. ");
INSERT INTO wol2010_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","«Mag dina joxe rakkam cig dee, baay joxe doomam; ay doom it dinañu jóg, di bañ seeni waajur, di leen reylu. ");
INSERT INTO wol2010_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Te ñépp dinañu leen bañ ndax sama tur; waaye ku muñ ba ca muj ga, mucc. ");
INSERT INTO wol2010_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","«Bés baa ngi ñëw, bu li ñuy wax “Lu araam luy yàqe” tegee ca bérab bu mu yelloowul; kiy jàng, na xam. Bu ngeen gisee loolu nag, ku nekk ci biir diiwaanu Yude, nanga daw ca tund ya. ");
INSERT INTO wol2010_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Ku nekk ci kaw taax mi, bul wàcc ngir dugg kër gi, fab say yëf ya fa nekk. ");
INSERT INTO wol2010_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Ku nekk ci tool bi, bul ñibbi ngir fab sa mbubb. ");
INSERT INTO wol2010_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Ngalla jigéen ñi ëmb ca bés yooya, ngalla it ñiy nàmpal. ");
INSERT INTO wol2010_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Ñaanleen ngir seen gàddaay baña tase ak jamonoy seddaayu lolli. ");
INSERT INTO wol2010_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Ndaxte booba dina am metit wu réy wu masula am, ba àddina sosoo ak tey, te dootul am mukk. ");
INSERT INTO wol2010_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Te bu fekkul woon Boroom bi wàññi bés yooyu, kenn du mucc, waaye fekk na mu wàññi leen ndax gaayam ñi mu tànn. ");
INSERT INTO wol2010_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","«Booba nag, bu leen kenn waxee: “Kaayleen gis, Kirist a ngi fi,” mbaa: “Xool-leen, mu nga fale,” buleen ko gëm. ");
INSERT INTO wol2010_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Ndaxte ñiy mbubboo turu Kirist ak ñiy mbubboo turu yonent, dinañu feeñ, di joxe ay firnde yu réy ak ay kéemaan, ba ciy nax sax ñi Yàlla tànn, su loolu manoona am. ");
INSERT INTO wol2010_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Wax naa leen ko lu jiitu. Kon nag moytuleen. ");
INSERT INTO wol2010_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","«Waaye booba, gannaaw metit yooyu: “Jant bi dina lëndëm te weer dootul leer; ");
INSERT INTO wol2010_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","biddiiw yi di daanoo asamaan, te kàttani asamaan yiy yëngu.” ");
INSERT INTO wol2010_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","«Noonu dees na gis Doomu nit ki ñëw ci niir yi, ànd ak kàttan ak ndam lu réy. ");
INSERT INTO wol2010_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Dina yónni ay malaakaam, ñu dajale ñi mu tànn ci ñeenti xébla yi, fa àddina dale, ba fa asamaan yem.» ");
INSERT INTO wol2010_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","Yeesu teg ca ne: «Jàngleen misaalu garabu figg ga. Boo xamee ne ay bànqaasam duy nañu, tey xobam sëq, xam ngeen ne nawet jege na. ");
INSERT INTO wol2010_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Noonu itam bu ngeen gisee loolu lépp xew, xamleen ne jege na; mu ngi ci bunt bi sax. ");
INSERT INTO wol2010_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Ci dëgg maa ngi leen koy wax, niti jamono jii duñu wéy, te loolu lépp amul. ");
INSERT INTO wol2010_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Asamaan ak suuf dinañu wéy, waaye samay wax du wéy mukk. ");
INSERT INTO wol2010_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","«Waaye bés boobu ak waxtu woowu, kenn xamul kañ lay doon; du malaaka yi ci kaw, du sax Doom ji, waaye Baay bi rekk moo ko xam. ");
INSERT INTO wol2010_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Moytuleen te xool! Xamuleen kañ la waxtu wi di jot. ");
INSERT INTO wol2010_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","«Mi ngi mel ni nit ku tukki, mu dénk këram ay surgaam, ku nekk ak sa sas, te sant bëkk-néeg bi, mu xool. ");
INSERT INTO wol2010_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Yéen nag xool-leen, ndaxte xamuleen kañ la boroom kër gi di délsi, muy ci timis mbaa ci xaaju guddi, muy ci fajar mbaa njël. ");
INSERT INTO wol2010_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Bu nee jalañ, bumu leen bett, ngeen di nelaw. ");
INSERT INTO wol2010_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Li ma leen wax, ñépp laa ko wax: “Xool-leen!”» ");
INSERT INTO wol2010_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Booba nag sarxalkat yu mag ya ak xutbakat ya ñu ngi doon fexeel Yeesu, ngir jàpp ko, reylu. Fekk booba ñaari fan a des ci màggalu bésu Mucc ba ak màggalu Mburu ma amul lawiir. ");
INSERT INTO wol2010_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Kon nag ñu ne: «Bumu doon ci bésu màggal bi, ngir yëngu-yëngu baña am ci nit ñi.» ");
INSERT INTO wol2010_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Bi nga xamee ne Yeesu nekkoon na dëkku Betani, mu dem këru Simoŋ ma gaana woon, di fa lekk. Noonu jigéen ñëw, yor njaq lu ñu defare doj wu tudd albaatar. Njaq li def latkoloñ ju raxul ju ñuy wax nàrd, tey jar lu baree bare. Jigéen ji toj njaq li, tuur latkoloñ ci boppu Yeesu. ");
INSERT INTO wol2010_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Waaye amoon na fa ñu mer, di xultu ci seen biir naan: «Yàq gii, lu muy jariñ? ");
INSERT INTO wol2010_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Maneesoon na jaay latkoloñ jii ci lu tollook peyug atum lëmm, jox ko miskin yi.» Noonu ñu daldi gëdd jigéen ji. ");
INSERT INTO wol2010_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Waaye Yeesu ne leen: «Bàyyileen ko. Defal na ma jëf ju rafet; lu tax ngeen di ko sonal? ");
INSERT INTO wol2010_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Miskin yaa ngi ak yéen bés bu nekk, te man ngeen leena dimbali saa su leen neexee, waaye dungeen ma gis ba fàww. ");
INSERT INTO wol2010_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Jigéen ji def na li mu man; diw na sama yaram ak latkoloñ, ngir waajal sama rob, laata moo jot. ");
INSERT INTO wol2010_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Ci dëgg maa ngi leen koy wax, fépp fu ñuy yéene xibaaru jàmm bi ci àddina sépp, dinañu fa fàttali it li jigéen jii def.» ");
INSERT INTO wol2010_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Ca waxtu woowu kenn ci fukki taalibe ya ak ñaar, ku tudd Yudaa Iskariyo, dem ca sarxalkat yu mag ya, ngir wori Yeesu. ");
INSERT INTO wol2010_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Bi ñu ko déggee, ñu am ca bànneex bu réy, dig ko xaalis. Noonu mu fexe jamono ju mu leen mana jébbal Yeesu. ");
INSERT INTO wol2010_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Bés bu jëkk ca màggal, ga ñuy wax Mburu ma amul lawiir, taalibey Yeesu laaj ko: «Foo bëgg, nu defaral la reeru bési Mucc bi?» Bés bu jëkk booba nag mooy bés, ba ñu farala rendi gàttub bésu Mucc ba. ");
INSERT INTO wol2010_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Noonu Yeesu yebal ñaar ci taalibe yi ne leen: «Demleen ca dëkk ba, foofa góor gu yenu njaq lu def ndox, dina taseek yéen, ngeen topp ko. ");
INSERT INTO wol2010_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Kër gi mu dugg nag, ngeen ne boroom kër gi: “Kilifa gi nee na: Ana néegu gan, bi may lekke reeru bésu Mucc bi, man ak samay taalibe?” ");
INSERT INTO wol2010_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Dina leen won néeg bu féete kaw te yaa, ñu defar ko, ba lépp jekk. Foofa ngeen nuy defarale reer bi.» ");
INSERT INTO wol2010_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Bi mu ko waxee, taalibe ya dem ca dëkk ba, gis lépp, ni leen ko Yeesu waxe woon. Noonu ñu defar reer bi. ");
INSERT INTO wol2010_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Bi nga xamee ne timis jot na, Yeesu ñëw, ànd ak fukki taalibe yi ak ñaar. ");
INSERT INTO wol2010_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Ñu toog, di lekk. Bi ñuy lekk nag, Yeesu ne leen: «Ci dëgg maa ngi leen koy wax, kenn ci yéen, ku bokk ak man di lekk sax, dina ma wor.» ");
INSERT INTO wol2010_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Taalibe yi nag am naqar, ñu daldi ko ne kenn-kenn: «Mbaa du man?» ");
INSERT INTO wol2010_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Mu ne leen: «Kenn ci yéen fukk ak ñaar la, kuy cappandoo ak man ci ndab li. ");
INSERT INTO wol2010_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Doomu nit ki mu ngi dem, ni ñu ko waxe ci Mbind mi, waaye ki koy wor dina torox. Bañoona juddu moo gën ci moom.» ");
INSERT INTO wol2010_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Noonu bi ñuy lekk, Yeesu jël mburu, sant Yàlla, jox leen ko naan: «Jël-leen, lii sama yaram la.» ");
INSERT INTO wol2010_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Gannaaw loolu mu jël kaas, sant Yàlla, jox leen ko, ñépp naan ci. ");
INSERT INTO wol2010_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Mu ne leen: «Lii mooy sama deret, ji fas kóllëre gi, te tuurul ñu bare. ");
INSERT INTO wol2010_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Ci dëgg maa ngi leen koy wax, dootuma naan gannaaw tey ndoxum reseñ mii, ba kera ma ciy naan bu bees ci nguuru Yàlla.» ");
INSERT INTO wol2010_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Noonu ñu woy Yàlla, ba noppi génn, dem ca tundu Oliw ya. ");
INSERT INTO wol2010_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Booba Yeesu ne leen: «Yéen ñépp dingeen ma dàggeeku, ndaxte bind nañu: “Dinaa dóor sàmm bi, xari jur gi tasaaroo.” ");
INSERT INTO wol2010_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Waaye bu ma dekkee, dinaa leen jiituji Galile.» ");
INSERT INTO wol2010_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Kon Piyeer ne ko: «Bu la ñépp dàggeekoo, man duma la bàyyi mukk.» ");
INSERT INTO wol2010_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Waaye Yeesu ne ko: «Ci dëgg maa ngi la koy wax, guddig tey, bala ginaar a sab ñaari yoon, dinga ma weddi ñetti yoon.» ");
INSERT INTO wol2010_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Waaye Piyeer gëna sax ca la mu waxoon naan: «Boo xamee ne sax, damaa wara dee ak yaw, duma la weddi mukk.» Taalibe yépp it waxe noonu. ");
INSERT INTO wol2010_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Noonu ñu dem ca bérab bu tudd Setsemane. Yeesu ne taalibe yi: «Toogleen fii, ma dem ñaani.» ");
INSERT INTO wol2010_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Mu ànd ak Piyeer, Saag ak Yowaana, daldi jàq, ba xonet. ");
INSERT INTO wol2010_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Mu ne leen: «Sama xol dafa tiis, ba ma bëgga dee; toogleen fii, xool.» ");
INSERT INTO wol2010_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Noonu Yeesu dem ci kanam tuuti, daanu ci suuf, di ñaan ne, waxtu wi teggi ko, bu loolu manoona am. ");
INSERT INTO wol2010_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Mu ne: «Abba, Baay, yaw mi dara tëwul, teggil ma kaasu naqar bii. Moona bumu doon sama coobare, waaye na sa coobare am.» ");
INSERT INTO wol2010_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Noonu mu délsi ci taalibe yi, fekk ñuy nelaw. Mu ne Piyeer: «Simoŋ, dangaa nelaw? Amuloo sax dooley xoolandoo ak man benn waxtu? ");
INSERT INTO wol2010_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Xool-leen te ñaan, ngir baña daanu cig fiir. Seen xol jag na, waaye seen bind a woyof.» ");
INSERT INTO wol2010_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Beneen yoon Yeesu dem, di ñaane noonu, ");
INSERT INTO wol2010_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","délsiwaat, fekk leen ñuy nelaw, ndaxte seeni bët dañoo diis. Xamuñu lu ñu koy tontoo. ");
INSERT INTO wol2010_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Ñetteelu yoon mu délsi ci ñoom ne leen: «Yéena ngi nelaw tey noppalu ba tey! Jeex na. Waxtu wi jot na; ñu ngi wor Doomu nit ki ci loxoy bàkkaarkat yi. ");
INSERT INTO wol2010_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Jógleen nu dem; ki may wor a ngi nii, di ñëw.» ");
INSERT INTO wol2010_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Bi Yeesu di wax, Yudaa mi bokkoon ci fukki taalibe ya ak ñaar, agsi, ànd ak mbooloo mu bare, mu jóge ca sarxalkat yu mag ya, ca xutbakat ya ak ca njiiti xeet wa, te gànnaayoo jaasi ak yet. ");
INSERT INTO wol2010_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Fekk ki ko naroona wor joxoon na leen tegtal ne leen: «Ki may fóon, moom la; jàppleen ko, yóbbu ko te wottu ko bu baax.» ");
INSERT INTO wol2010_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Noonu mu ñëw ci Yeesu ne ko: «Kilifa gi,» daldi ko fóon. ");
INSERT INTO wol2010_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Bi mu ko defee nit ñi song Yeesu nag, jàpp ko. ");
INSERT INTO wol2010_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Waaye kenn ci ñi fa taxaw bocci jaaseem, dóor surgab sarxalkat bu mag bi, nopp bi dagg. ");
INSERT INTO wol2010_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Yeesu ne leen: «Jóg ngeen ngir jàpp ma, gànnaayoo jaasi ak yet, mel ni ñuy topp sàcc. ");
INSERT INTO wol2010_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Moona daan naa toog bés bu nekk ca kër Yàlla ga, di jàngle, te jàppuleen ma. Waaye lii am na, ngir Mbind mi am.» ");
INSERT INTO wol2010_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Ci kaw loolu, ñépp dëddu ko, daw. ");
INSERT INTO wol2010_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Fekk amoon na ca waxambaane wu lëkkaayoo woon sér, topp Yeesu, ñu daldi ko jàpp. ");
INSERT INTO wol2010_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","Waaye waxambaane wa wacc fa sér bi, daldi daw, def yaramu neen. ");
INSERT INTO wol2010_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Ñi jàpp Yeesu yóbbu ko ci sarxalkat bu mag bi, te foofa la sarxalkat yu mag yi, njiit yi ak xutbakat yi yépp dajaloo. ");
INSERT INTO wol2010_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Piyeer nag topp ko fu sore, ba ci ëttu sarxalkat bu mag bi, mu toog fa ak alkaati yi, di jaaru ci taal bi. ");
INSERT INTO wol2010_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Noonu sarxalkat yu mag yi ak kureelu àttekat yi yépp di wut ku mana seede lu daan Yeesu, ba ñu man koo reylu, waaye gisuñu kenn. ");
INSERT INTO wol2010_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Teewul sax naaféq ñu bare ñëw, seede ci Yeesu lu dul dëgg, waaye seen seede ànduñu. ");
INSERT INTO wol2010_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Ba mujj naaféq taxaw, seede ci moom naan: ");
INSERT INTO wol2010_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","«Nun daal dégg nanu, mu ne: “Dinaa toj kër Yàlla, gii loxoy nit liggéey, tabax ci ñetti fan geneen gu nit liggéeyul.”» ");
INSERT INTO wol2010_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Waaye ba tey seeni wax ànduñu. ");
INSERT INTO wol2010_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Ci kaw loolu sarxalkat bu mag bi taxaw ci seen kanam ne Yeesu: «Doo tontu? Lu la nit ñi di jiiñ?» ");
INSERT INTO wol2010_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Waaye Yeesu ne cell, waxul dara. Sarxalkat bu mag bi dellu nag ne ko: «Ndax yaa di Almasi bi, Doomu Yàlla ju tedd ji?» ");
INSERT INTO wol2010_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Yeesu ne ko: «Moom laa. Te dingeen gis Doomu nit ki toog ci ndijooru Aji Man ji, di ñëw ci niiri asamaan.» ");
INSERT INTO wol2010_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Bi ko sarxalkat bu mag bi déggee nag, mu daldi mer, ba xotti ay yéreem naan: ");
INSERT INTO wol2010_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","«Weddi na Yàlla, lu nu doyeeti seede? Lu ngeen ci xalaat?» Noonu ñépp teg ko dee. ");
INSERT INTO wol2010_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Ci kaw loolu ñu daldi tifli ci moom, takk ay bëtam, di ko dóor ay kurfeñ, naan ko: «Yaw wax nu ci kàddug Yàlla, ku la dóor?» Ba noppi alkaati yi teeru ko ak ay pes. ");
INSERT INTO wol2010_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Piyeer nag ma nga toogoon ci ëtt bi féete suuf. Noonu benn mbindaanu sarxalkat bu mag ba romb fa. ");
INSERT INTO wol2010_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Mu gis Piyeer di jaaru, xool ko jàkk naan: «Yaw itam àndoon nga ak Yeesum Nasaret moomu.» ");
INSERT INTO wol2010_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Waaye Piyeer weddi ko naan: «Xawma li ngay wax, dégguma ci dara.» Mu daldi génn, dem ca buntu kër ga. ");
INSERT INTO wol2010_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Foofa nag mbindaan mi gisaat ko, mu ne ñi fa taxaw: «Waa jii ci ñoom la bokk.» ");
INSERT INTO wol2010_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Waaye Piyeer weddiwaat ko. Nees-tuut ñi fa taxaw ne Piyeer: «Yaw mi de, ci lu wóor bokk nga ci, nde waa Galile nga.» ");
INSERT INTO wol2010_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Waaye Piyeer daldi giñ ak a waat naan: «Xawma nit ki ngay wax.» ");
INSERT INTO wol2010_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Ci saa si ginaar sab ñaareelu yoon. Noonu Piyeer fàttaliku li ko Yeesu wax: «Bala ginaar a sab ñaari yoon, dinga ma weddi ñetti yoon.» Mu daldi jooy jooy yu metti. ");
INSERT INTO wol2010_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Ci suba teel sarxalkat yu mag yi gise, ñoom ak njiit yi ak xutbakat yi ak kureelu àttekat yi yépp. Ñu yeew nag Yeesu, daldi ko yóbbu, jébbal ko Pilaat. ");
INSERT INTO wol2010_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Noonu Pilaat laaj ko: «Ndax yaa di buuru Yawut yi?» Yeesu ne ko: «Wax nga ko.» ");
INSERT INTO wol2010_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Te sarxalkat yu mag yi di ko jiiñ lu bare. ");
INSERT INTO wol2010_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Kon nag Pilaat laajaat ko: «Déggal lépp li ñu lay jiiñ. Xanaa amoo ci tont?» ");
INSERT INTO wol2010_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Waaye ba tey Yeesu waxul dara, ba tax Pilaat waaru. ");
INSERT INTO wol2010_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Màggal gu nekk nag Pilaat daan na may mbooloo mi, ñu tànn kenn ci ñi ñu tëjoon, mu bàyyil leen ko. ");
INSERT INTO wol2010_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Fekk booba amoon na ku ñu tëj, tudd Barabas, ku bokk ci ña bëggoona tas réew mi, boole ci rey nit. ");
INSERT INTO wol2010_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Noonu mbooloo mi ñëw, laaj Pilaat, mu defal leen la mu daan def. ");
INSERT INTO wol2010_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","10","Pilaat nag xam ne kiñaan rekk a taxoon sarxalkat yu mag yi jébbal ko Yeesu. Kon mu ne mbooloo mi: «Xanaa ma bàyyil leen buuru Yawut yi?» ");
INSERT INTO wol2010_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Waaye sarxalkat yu mag yi xiir mbooloo mi, ñu laaj Pilaat, mu bàyyil leen Barabas. ");
INSERT INTO wol2010_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Kon Pilaat ne leen: «Lan laay def nag ak ki ngeen di wooye buuru Yawut yi?» ");
INSERT INTO wol2010_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Ñu daldi yuuxuwaat naan: «Daaj ko ci bant, ba mu dee!» ");
INSERT INTO wol2010_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Pilaat ne leen: «Lu tax? Gan tooñ la def?» Waaye mbooloo mi di yuuxu bu gëna kawe: «Daaj ko ci bant!» ");
INSERT INTO wol2010_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Noonu Pilaat, mi wuta neex mbooloo mi, bàyyil leen Barabas, ba noppi mu dóorlu Yeesu ay yar, jébbal ko, ngir ñu daaj ko ci bant. ");
INSERT INTO wol2010_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Bi loolu amee ñu dugal Yeesu ci biir kër boroom réew ma, mooy bérab bu ñuy wax Peretoriyum, ñu daldi woo mbooloom xarekat yépp. ");
INSERT INTO wol2010_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Noonu ñu solal ko mbubb mu xonq curr, ràbb kaalag dég, teg ko ci boppam. ");
INSERT INTO wol2010_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Ñu daldi ko wax bu kawe: «Nuyu nanu la, yaw buuru Yawut yi!» ");
INSERT INTO wol2010_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Ñu di ko dóor ci bopp ak bant, di ko tifli, daldi sukk, màggal ko. ");
INSERT INTO wol2010_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Bi ñu ko ñaawalee noonu ba noppi, ñu summi mbubb mu xonq mi, solaatal ko ay yéreem, yóbbu ko, ngir daaj ko ci bant. ");
INSERT INTO wol2010_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Amoon na nag nit ku dëkk Siren, tudd Simoŋ, di baayu Alegsàndar ak Rufus. Fekk booba mu romb fa, jóge ca wet, ga féete ak tool ya, ñu ga ko ngir mu gàddu bant bi. ");
INSERT INTO wol2010_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Noonu ñu yóbbu Yeesu ca bérab bu ñuy wax Golgota, liy tekki «bérabu Kaaŋu bopp.» ");
INSERT INTO wol2010_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Ñu bëgg koo jox biiñ bu ñu boole ak naan gu tudd miir, waaye nanguwu ko. ");
INSERT INTO wol2010_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Foofa ñu daaj Yeesu ci bant, daldi séddoo ay yéreem, tegoo ko ay bant, ba xam ku nekk, looy am; ");
INSERT INTO wol2010_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","booba fekk yoor-yoor di jot. ");
INSERT INTO wol2010_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Mbind mi xamle lu tax ñu rey ko nee na: «Kii mooy buuru Yawut yi.» ");
INSERT INTO wol2010_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","28","Booba it ñu daajaale ak moom ñaari taskati réew mi, kenn ci ndijooram, ki ci des ci càmmoñam. ");
INSERT INTO wol2010_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Ña fa doon romb di ko xas, di wëcc seen bopp ndax sib ko, naan: «Waaw kay, yaw mi bëgga toj kër Yàlla gi, tabaxaat ko ci ñetti fan, ");
INSERT INTO wol2010_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","wàccal ci bant bi te musal sa bopp!» ");
INSERT INTO wol2010_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Noonu it sarxalkat yu mag yi ak xutbakat yi di ko ñaawal ci seen biir naan: «Kii musal na ñeneen waaye manula musal boppam. ");
INSERT INTO wol2010_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Almasi bii, di buuru Israyil, na wàcc léegi ci bant bi, nu gis ko te gëm.» Ñi ñu daajaale ak moom it di ko xarab. ");
INSERT INTO wol2010_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Li tàmbalee digg bëccëg, ba ci tisbaar, réew mépp lëndëm. ");
INSERT INTO wol2010_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Ci tisbaar nag Yeesu wootee kàddu gu dëgër naan: «Elowi, Elowi, lema sabaktani?» liy tekki: «Sama Yàlla, sama Yàlla, lu tax nga dëddu ma?» ");
INSERT INTO wol2010_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Ñenn ci ña fa taxaw nag, bi ñu ko déggee, ñu ne: «Mu ngi woo yonent Yàlla Ilyaas.» ");
INSERT INTO wol2010_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Noonu kenn daw, jël aw sagar, capp ko ci bineegar, mu teg ko ci bant, jox ko ko, mu muucu. Mu ne: «Bàyyileen, nu seet, ba xam Ilyaas dina ñëw, wàcce ko.» ");
INSERT INTO wol2010_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Noonu Yeesu wootewaat ak kàddu gu dëgër, delloo ruuwam Yàlla. ");
INSERT INTO wol2010_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Bi mu ko defee ridob bérab bu sell ba ca kër Yàlla ga xar ñaar, li dale ci kaw ba ci suuf. ");
INSERT INTO wol2010_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Njiitu xare nag, bi taxawoon ci kanam Yeesu, bi mu gisee ni Yeesu deeye, mu ne: «Ci dëgg, nit kii Doomu Yàlla la!» ");
INSERT INTO wol2010_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Amoon na fa nag ay jigéen, ñu leen dànd, di xool. Xàmmi nañu ci: Maryaama mi dëkk Magdala, Maryaama yaayu Saag mu ndaw ak Yuusufa, ak Salome. ");
INSERT INTO wol2010_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Bi Yeesu nekkee Galile, jigéen ñooñu ñoo ko doon topp, di ko topptoo. Amoon na fa it yeneen jigéen yu bare yu àndoon ak moom, ba ñëw Yerusalem. ");
INSERT INTO wol2010_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Booba nag bésu Waajal la woon, maanaam bés bu jiitu bésub noflaay bi. Ca ngoon sa nag, ");
INSERT INTO wol2010_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Yuusufa mi dëkk Arimate takk aw fitam, dem Pilaat, laaj ko néewu Yeesu. Yuusufa moomu nag, ku siiw la woon ci kureelu àttekat yi, te doon séentu moom itam nguuru Yàlla. ");
INSERT INTO wol2010_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Bi Pilaat déggee ne, Yeesu faatu na xaat, mu waaru. Mu woolu nag njiit li, laaj ko, ndax yàgg na faatu. ");
INSERT INTO wol2010_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Bi ko ko njiit li dëggalee, Pilaat jox néew bi Yuusufa. ");
INSERT INTO wol2010_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Noonu Yuusufa jënd càngaay, wàcce néew bi, laxas ko ci, dugal ko cib bàmmeel bu ñu yett ci xeer. Bi mu ko defee mu béraŋ aw doj, ube ko buntu bàmmeel bi. ");
INSERT INTO wol2010_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Maryaamam Magdala nag ak Maryaama yaayu Yuusufa xool fu mu ko denc. ");
INSERT INTO wol2010_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Bi bésub noflaay bi wéyee, Maryaamam Magdala, Maryaama yaayu Saag, ak Salome, jënd cuuraay, ngir dem xeeñal néewu Yeesu. ");
INSERT INTO wol2010_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Kon bés bu jëkk ci ayu-bés gi, ñu njëlu dem ca bàmmeel ba, ");
INSERT INTO wol2010_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","4","di laajante: «Ku nuy béraŋal doj, wiy ub bàmmeel bi?» Doj woowu nag bu réya réy la woon. Noonu ñu xool, gis ne doj wa deñ. ");
INSERT INTO wol2010_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Ñu dugg ci bàmmeel bi, gis ca ndijoor waxambaane wu sol mbubb mu weex, ñu daldi tiit. ");
INSERT INTO wol2010_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Mu ne leen: «Buleen tiit. Yéena ngi seet Yeesum Nasaret, mi ñu daajoon ci bant bi. Nekkatu fi, dekki na; gisleen fi ñu ko tëraloon. ");
INSERT INTO wol2010_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Kon nag demleen, ne Piyeer ak taalibe ya: “Mi ngi leen di jiitu Galile. Foofa ngeen koy gise, ni mu leen ko waxe woon.”» ");
INSERT INTO wol2010_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Noonu jigéen ñi génn, dawe bàmmeel ba, tiit bay lox. Te waxuñu kenn dara ndax seen tiit. ");
INSERT INTO wol2010_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Bi Yeesu dekkee nag ci suba teel ca bés bu jëkk ca ayu-bés ga, mu jëkka feeñu Maryaama mu dëkk Magdala, mi mu dàqe woon juróom ñaari rab. ");
INSERT INTO wol2010_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Maryaama nag dem nettali ko ñi àndoon ak Yeesu, fekk ñuy naqarlu, di jooy. ");
INSERT INTO wol2010_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Bi ñu déggee ne, Yeesoo ngi dund te Maryaama gis na ko, gëmuñu ko. ");
INSERT INTO wol2010_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Gannaaw loolu Yeesu feeñu ñaar ci ñoom ci jeneen jëmm, ñuy jaar ci yoon wi, jëm àll ba. ");
INSERT INTO wol2010_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Ñu waññiku nag, wax ko ña ca des, waaye ba tey gëmuñu leen ñoom it. ");
INSERT INTO wol2010_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Gannaaw ga it Yeesu feeñu fukki taalibe yi ak benn, bi ñuy lekk. Mu yedd leen ndax seen ngëmadi ak seen dëgër bopp, ci li ñu baña gëm ñi ko gisoon, bi mu dekkee. ");
INSERT INTO wol2010_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Mu ne leen: «Demleen ci àddina sépp, yégal xibaaru jàmm bi mbindeef yépp. ");
INSERT INTO wol2010_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Ku gëm te ñu sóob ko ci ndox, dina mucc; ku gëmul, dees na ko daan. ");
INSERT INTO wol2010_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Ñi ma gëm dinañu ànd ak firnde yii: ci sama tur dinañu dàq rab yi, di wax làkk yu bees, ");
INSERT INTO wol2010_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","di jàpp jaan ak seeni loxo; te bu ñu naanee lu ñu tooke, du leen wàññi dara, te jarag ju ñu teg loxo, mu wér.» ");
INSERT INTO wol2010_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Gannaaw bi Boroom bi Yeesu waxee ak ñoom, mu yékkatiku, dem asamaan, toog ci ndijooru Yàlla. ");
INSERT INTO wol2010_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Taalibe ya dem waareji, te loxob Boroom bi ànd ak ñoom, di dëggal kàddu gi ak firnde, yi ci ànd. ");
INSERT INTO wol2010_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Yaw Teyofil mu tedd mi, xam nga ne, nit ñu bare sasoo nañoo bind ab nettali bu jëm ci mbir, yi xewoon ci sunu biir, ");
INSERT INTO wol2010_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","li dëppook waxi seede, yi ko teewe woon li dale ca ndoorte la te ñu mujj nekk jawriñi kàddug Yàlla. ");
INSERT INTO wol2010_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Léegi nag kon man ci sama wàll, gëstu naa ci lépp li ko dale ca njàlbéen ga, te fas naa la ko yéenee bindal, nettali la ni xew-xew yooyu deme woon tembe. ");
INSERT INTO wol2010_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Noonu dinga mana xam ne li ñu la jàngaloon lu wér péŋŋ la. ");
INSERT INTO wol2010_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Ca jamonoy Erodd, mi nekkoon buur ca réewu Yawut ya, amoon na sarxalkat bu ñu tudde Sakari te bokk ca mbootaayu sarxalkat, ya askanoo ci Abiya. Soxnaam Elisabet askanoo moom itam ci Aaróona. ");
INSERT INTO wol2010_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Sakari ak soxnaam ñu jub lañu ca kanam Yàlla, di topp ni mu ware ndigal yi ak dogali Boroom bi yépp. ");
INSERT INTO wol2010_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Waaye amuñu doom, ndaxte Elisabet manula am doom, te it fekk ñoom ñaar ñépp ay màggat lañu. ");
INSERT INTO wol2010_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Benn bés nag Sakari doon def liggéeyu sarxaleem ca Yàlla, ndaxte mbootaayam a aye keroog. ");
INSERT INTO wol2010_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Bi ñuy tegoo bant, ni ko sarxalkat yi daan defe naka-jekk, ngir xam kan mooy dugg ca bérab bu sell ba ca kër Yàlla ga, ngir taal fa cuuraay, bant ba tegu ci Sakari. ");
INSERT INTO wol2010_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Ca waxtu wa ñuy taal cuuraay la, mbooloo maa nga woon ca biti, di ñaan. ");
INSERT INTO wol2010_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Noonu benn malaakam Boroom bi daldi feeñu Sakari, taxaw ca féeteek ndijooru sarxalukaay, ba ñuy taal cuuraay ca kawam. ");
INSERT INTO wol2010_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Naka la ko Sakari gis, fitam daldi dem, mu tiit. ");
INSERT INTO wol2010_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Waaye malaaka ma ne ko: «Bul ragal dara Sakari, ndaxte sa ñaan nangu na. Elisabet sa soxna dina la jural doom, te dinga ko tudde Yaxya. ");
INSERT INTO wol2010_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Sa mbég lay doon, sa xol sedd ci, te ñu bare dinañu bég ci juddoom, ");
INSERT INTO wol2010_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","ndaxte dina nekk ku màgg ca kanam Yàlla. Du naan biiñ walla dara luy màndil, te bu juddoo, Xel mu Sell mi daldi ko solu. ");
INSERT INTO wol2010_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Dina delloosi niti Israyil yu bare ci Yàlla seen Boroom. ");
INSERT INTO wol2010_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Mooy jiitu, di yégle ñëwug Boroom bi, ànd ak xel mi ak doole, ji yonent Yàlla Ilyaas amoon, ngir jubale xoli baay yi ak doom yi, ngir delloo ñi déggadi ci maanduteg ñi jub. Noonu dina waajal mbooloo muy teeru Boroom bi.» ");
INSERT INTO wol2010_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Sakari daldi ne malaaka ma: «Nan laay xame ne loolu dëgg la? Ndaxte mag laa, te sama soxna it màggat na.» ");
INSERT INTO wol2010_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Malaaka ma ne ko: «Man maay Jibril miy taxaw ci kanam Yàlla. Dañu maa yónni ngir ma wax ak yaw te yégal la xibaaru jàmm boobu. ");
INSERT INTO wol2010_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Léegi nag gannaaw gëmuloo li ma wax, dinga luu te dootuloo mana wax, ba kera sama wax di am, bu jamonoom jotee.» ");
INSERT INTO wol2010_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Fekk na booba mbooloo maa ngi xaar, jaaxle lool ci li Sakari yàgg ca bérab bu sell ba. ");
INSERT INTO wol2010_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Waaye bi mu génnee nag, manula wax ak ñoom. Noonu nit ña xam ne dafa am lu ko feeñu ca bérab bu sell ba. Dafa luu, ba di leen liyaar. ");
INSERT INTO wol2010_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Bi Sakari matalee liggéeyu sarxaleem ba noppi, mu daldi ñibbi. ");
INSERT INTO wol2010_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Bi mbir yooyu weesoo, Elisabet soxnaam ëmb, di ko nëbb lu mat juróomi weer ");
INSERT INTO wol2010_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","te naan: «Lii mooy yiw wi ma Boroom bi defal, ba fajal ma li doon sama gàcce ci nit ñi!» ");
INSERT INTO wol2010_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Bi Elisabet nekkee ci juróom benni weeram, Yàlla yónni na malaakaam Jibril ca dëkku Nasaret ca diiwaanu Galile. ");
INSERT INTO wol2010_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Mu yebal ko ca janq bu ñu may waa ju bokk ci askanu Daawuda te ñu koy wax Yuusufa, waaye àndaguñu. Janq baa ngi tudd Maryaama. ");
INSERT INTO wol2010_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Malaaka ma dikk ca moom ne ko: «Jàmm nga am, yaw mi Boroom bi defal aw yiw; mu ngi ak yaw.» ");
INSERT INTO wol2010_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Waxi malaaka ma daldi jaaxal Maryaama, muy xalaat lu nuyoo boobu mana tekki. ");
INSERT INTO wol2010_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Malaaka ma ne ko: «Bul ragal dara Maryaama, ndaxte Yàlla tànn na la ci yiwam. ");
INSERT INTO wol2010_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Dinga ëmb, jur doom ju góor; nanga ko tudde Yeesu. ");
INSERT INTO wol2010_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Ku màgg lay nekki, te dinañu ko wooye Doomu Aji Kawe ji. Boroom bi Yàlla dina ko jébbal nguuru Daawuda maamam. ");
INSERT INTO wol2010_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Noonu dina yilif askanu Yanqóoba ba fàww, te nguuram du am àpp.» ");
INSERT INTO wol2010_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Maryaama laaj malaaka ma ne ko: «Naka la loolu mana ame? Man de, janq laa ba tey.» ");
INSERT INTO wol2010_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Malaaka ma ne ko: «Xel mu Sell mi dina wàcc ci yaw, te Aji Kawe ji dina la yiir ci kàttanam. Moo tax xale biy juddu dinañu ko wooye Ku sell ki, Doomu Yàlla ji. ");
INSERT INTO wol2010_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Elisabet sa mbokk mi it dina am doom ju góor cig màggatam. Ki ñu doon wooye ku manula am doom, mu ngi ci juróom benni weeram. ");
INSERT INTO wol2010_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Ndaxte dara tëwul Yàlla.» ");
INSERT INTO wol2010_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Maryaama ne ko: «Jaamub Boroom bi laa. Na Yàlla def ci man li nga wax.» Ci noonu malaaka ma daldi dem. ");
INSERT INTO wol2010_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Ci jamono jooju Maryaama jóg, gaawantu dem ci benn dëkk bu nekkoon ca tund ya ca diiwaanu Yude. ");
INSERT INTO wol2010_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Mu dugg ca kër Sakari, daldi nuyu Elisabet. ");
INSERT INTO wol2010_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Naka la Elisabet dégg Maryaama di nuyoo, doomam daldi yëngatu ci biiram. Noonu Xelum Yàlla mu Sell mi daldi solu Elisabet. ");
INSERT INTO wol2010_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Elisabet wax ca kaw ne: «Barkeel nañu la ci jigéen ñi, barkeel doom ji nga ëmb! ");
INSERT INTO wol2010_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Man maay kan, ba ndeyu sama Boroom ñëw di ma seetsi? ");
INSERT INTO wol2010_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Maa ngi lay wax ne naka laa la dégg ngay nuyoo rekk, sama doom ji yëngu ci sama biir ndax mbég. ");
INSERT INTO wol2010_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Barke ñeel na la, yaw mi gëm ne li la Boroom bi yégal dina mat!» ");
INSERT INTO wol2010_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Noonu Maryaama daldi ne: ");
INSERT INTO wol2010_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","«Sama xol a ngi màggal Boroom bi, sama xel di bég ci Yàlla sama Musalkat, ");
INSERT INTO wol2010_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","ndaxte fàttaliku na ma, man jaamam bu woyof bi. Gannaaw-si-tey, niti jamono yépp dinañu ma wooye ki ñu barkeel, ");
INSERT INTO wol2010_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","ndaxte Ku Màgg ki defal na ma lu réy. Turam dafa sell. ");
INSERT INTO wol2010_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Day wàcce yërmandeem ci ñi ko ragal, ci seeni sët ba ci seeni sëtaat. ");
INSERT INTO wol2010_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Wone na jëf yu mag ci dooley loxoom, te tas mbooloom ñiy réy-réylu, ");
INSERT INTO wol2010_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","daaneel boroom doole yi ci seen nguur, yékkati baadoolo yi. ");
INSERT INTO wol2010_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Ñi xiif, reggal na leen ak ñam wu neex, te dàq boroom alal yi, ñu daw ak loxoy neen. ");
INSERT INTO wol2010_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Wallu na bànni Israyil giy jaamam, di fàttaliku yërmandeem, ");
INSERT INTO wol2010_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","ni mu ko dige woon sunuy maam, jëmale ko ci Ibraayma ak askanam ba fàww.» ");
INSERT INTO wol2010_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Noonu Maryaama toog fa Elisabet lu wara tollook ñetti weer, sooga ñibbi. ");
INSERT INTO wol2010_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Gannaaw loolu jamono ji Elisabet wara mucc agsi, mu daldi jur doom ju góor. ");
INSERT INTO wol2010_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Dëkkandoom yi ak bokkam yi yég ne, Boroom bi won na ko yërmande ju réy, ñu ànd ak moom bég. ");
INSERT INTO wol2010_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Bi bés ba délsee, ñu ñëw xarafalsi xale ba, bëgg koo dippee baayam Sakari. ");
INSERT INTO wol2010_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Waaye yaayam ne leen: «Déedéet, Yaxya lay tudd.» ");
INSERT INTO wol2010_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Ñu ne ko: «Amoo menn mbokk mu tudd noonu.» ");
INSERT INTO wol2010_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Ñu daldi liyaar baayam, ngir xam nan la bëgg ñu tudde xale ba. ");
INSERT INTO wol2010_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Sakari laaj àlluwa, bind ci ne: «Yaxya la tudd.» Ñépp daldi waaru. ");
INSERT INTO wol2010_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Ca saa sa Yàlla dindi luu gi, Sakari daldi waxaat, di màggal Yàlla. ");
INSERT INTO wol2010_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Waa dëkk ba bépp jaaxle, xew-xew yooyu siiw ca tundi Yude yépp. ");
INSERT INTO wol2010_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Ñi dégg nettali, bi jëm ci mbir yooyu, dañu koo denc ci seen xol te naan: «Nu xale bii di mujje nag?» Ndaxte leeroon na ne dooley Boroom baa ngi ànd ak moom. ");
INSERT INTO wol2010_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Sakari baayu Yaxya daldi fees ak Xel mu Sell mi. Noonu mu wax ci kàddug Yàlla ne: ");
INSERT INTO wol2010_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","«Cant ñeel na Boroom bi, Yàllay Israyil, ndaxte wallusi na mbooloom, ba jot leen! ");
INSERT INTO wol2010_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Feeñal na nu Musalkat bu am doole, bi soqikoo ci askanu Daawuda jaamam, ");
INSERT INTO wol2010_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","ni mu yéglee woon bu yàgg jaarale ko ci yonentam yu sell yi. ");
INSERT INTO wol2010_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Dina nu musal ci sunuy noon, jële nu ci sunu loxoy bañaale. ");
INSERT INTO wol2010_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Yàlla wone na yërmandeem, ji mu digoon sunuy maam, te di fàttaliku kóllëre, gi mu fas ak ñoom, ");
INSERT INTO wol2010_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","di ngiñ, li mu giñaloon sunu maam Ibraayma naan, ");
INSERT INTO wol2010_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","dina nu teqale ak sunuy noon, ngir nu man koo jaamu ci jàmm, ");
INSERT INTO wol2010_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","nu sell te jub ci kanamam sunu giiru dund. ");
INSERT INTO wol2010_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Yaw nag doom, dinañu lay wooye yonentu Aji Kawe ji, ndaxte dinga jiitu, di yégle ñëwug Boroom bi, di ko xàllal yoon wi. ");
INSERT INTO wol2010_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Dinga xamal mbooloom ni leen Boroom bi mana musale, jaare ko ci seen mbaalug bàkkaar, ");
INSERT INTO wol2010_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","ndaxte Yàlla sunu Boroom fees na ak yërmande, ba tax muy wàcce ci nun jant buy fenk, ");
INSERT INTO wol2010_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","ngir leeral ñi toog ci lëndëm, takkandeeru dee tiim leen, ngir jiite nu ci yoonu jàmm.» ");
INSERT INTO wol2010_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Noonu Yaxyaa ngi doon màgg, te xelam di ubbiku. Mu dëkk ca màndiŋ ma, ba bés ba muy feeñu bànni Israyil. ");
INSERT INTO wol2010_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Ca jamono jooja buur bu mag bu ñuy wax Ogust joxe ndigal ne, na ñépp binduji. ");
INSERT INTO wol2010_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Mbindu mooma, di mu jëkk ma, daje na ak jamono, ja Kiriñus nekke boroom réewu Siri. ");
INSERT INTO wol2010_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Noonu ku nekk dem binduji ca sa dëkku cosaan. ");
INSERT INTO wol2010_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Yuusufa nag daldi jóge Nasaret ca diiwaanu Galile, jëm ca diiwaanu Yude ca Betleyem, dëkk ba Daawuda cosaanoo, ndaxte ci askanu Daawuda la bokk. ");
INSERT INTO wol2010_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Mu dem binduji, ànd ak Maryaama soxnaam, fekk booba Maryaama ëmb. ");
INSERT INTO wol2010_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Bi ñu nekkee Betleyem, waxtu wa mu waree mucc agsi. ");
INSERT INTO wol2010_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Mu taawloo doom ju góor, mu laxas ko ci ay laytaay, tëral ko ca lekkukaayu jur ga, ndaxte xajuñu woon ca dalukaay ba. ");
INSERT INTO wol2010_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Fekk booba amoon na ca gox ba ay sàmm yu daan fanaan ca tool ya, di wottu jur ga. ");
INSERT INTO wol2010_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Noonu benn malaakam Boroom bi feeñu leen, ndamu Boroom bi daldi leer, melax, wër leen. Tiitaange ju réy jàpp leen. ");
INSERT INTO wol2010_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Waaye malaaka mi ne leen: «Buleen tiit, ndaxte dama leen di xamal xibaaru jàmm buy indi mbég mu réy ci nit ñépp. ");
INSERT INTO wol2010_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Tey jii ca dëkku Daawuda, ab Musalkat juddul na leen fa, te mooy Almasi bi, di Boroom bi. ");
INSERT INTO wol2010_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Ci firnde jii ngeen koy xàmmee: dingeen gis liir bu ñu laxas ci ay laytaay, tëral ko ci lekkukaayu jur.» ");
INSERT INTO wol2010_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Bi mu waxee loolu, yeneen malaaka yu bare yu jóge asamaan, ànd ak moom, di sant Yàlla naan: ");
INSERT INTO wol2010_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","«Nañu màggal Yàlla ca asamaan su kawe sa, te ci àddina, na jàmm wàcc ci nit, ñi mu nangu ndax yiwam!» ");
INSERT INTO wol2010_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Bi malaaka ya delloo ca asamaan, sàmm yi di waxante naan: «Nanu dem boog Betleyem, seeti la fa xew, li nu Boroom bi xamal.» ");
INSERT INTO wol2010_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Ñu daldi gaawantu dem, gis Maryaama ak Yuusufa, ak liir, ba ñu tëral ca lekkukaayu jur ga. ");
INSERT INTO wol2010_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Bi ñu leen gisee, ñu nettali la ñu leen waxoon ca mbirum xale ba. ");
INSERT INTO wol2010_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Ñi dégg li sàmm yi doon wax ñépp daldi waaru lool. ");
INSERT INTO wol2010_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Waaye Maryaama moom, takkoon na mbir yooyu yépp, di ko xalaat ci xolam. ");
INSERT INTO wol2010_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Noonu sàmm ya dellu ca seen jur, di màggal Yàlla, di ko sant ci li ñu déggoon lépp te gis ko, ndaxte lépp am na, ni ko Boroom bi waxe woon. ");
INSERT INTO wol2010_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Bi bés ba délsee jamonoy xarafal xale ba agsi. Ñu tudde ko Yeesu, ni ko malaaka ma diglee woon, laata ko yaayam di ëmb. ");
INSERT INTO wol2010_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Noonu jamono ji ñu leen waroona sellale agsi, ni ko yoonu Musaa tërale. Waajuri Yeesu yi daldi koy yóbbu ca dëkku Yerusalem, ngir sédde ko Boroom bi. ");
INSERT INTO wol2010_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Ndaxte bind nañu ci yoonu Boroom bi ne: «Bépp taaw bu góor, nañu ko sédde Boroom bi.» ");
INSERT INTO wol2010_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Bi ñu ko yóbboo, def nañu itam sarax, ni ko yoonu Boroom bi santaanee: «ñaari pitaxu àll walla ñaari xati yu ndaw.» ");
INSERT INTO wol2010_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Amoon na ca Yerusalem nit ku tudd Simeyon. Nit ku fonkoon yoonu Yàlla la te déggal ko, doon séentu jamono, ji Yàlla wara dëfal bànni Israyil. Xel mu Sell mi mu ngi ci moom, ");
INSERT INTO wol2010_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","te xamal na ko ne du dee mukk te gisul Almasib Boroom bi. ");
INSERT INTO wol2010_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Noonu Xelum Yàlla daldi yóbbu Simeyon ba ca kër Yàlla ga. Bi waajuri Yeesu indee xale ba, ngir sédde ko Yàlla, ni ko yoon wi santaanee, ");
INSERT INTO wol2010_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Simeyon jël xale bi, leewu ko, daldi sant Yàlla ne: ");
INSERT INTO wol2010_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","«Boroom bi, nanga yiwi sa jaam, mu noppaluji ci jàmm, ni nga ko waxe. ");
INSERT INTO wol2010_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Ndaxte sama bët tegu na ci mucc gi nga lal, ");
INSERT INTO wol2010_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","xeet yépp seede ko. ");
INSERT INTO wol2010_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Muy leer giy leeral xeet yi, di ndamu Israyil say gaa.» ");
INSERT INTO wol2010_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Waajuri Yeesu yi waaru ci li ñu doon wax ci xale bi. ");
INSERT INTO wol2010_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Noonu Simeyon ñaanal leen, ba noppi ne Maryaama: «Xale bii Yàllaa ko yónni, ngir ñu bare ci Israyil daanu te yékkatiku. Def na ko it muy firnde ju ñuy weddi, ");
INSERT INTO wol2010_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","ba naqar dina xar sa xol ni jaasi. Noonu xalaati ñu bare feeñ.» ");
INSERT INTO wol2010_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Amoon na it ca Yerusalem yonent bu ñuy wax Aana. Doomu Fanuwel mi askanoo ci Aser la woon, te Aana màggatoon na lool. Bi mu séyee, dëkk na juróom ñaari at ak jëkkëram. ");
INSERT INTO wol2010_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Jëkkër ja gaañu, te séyaatul. Léegi amoon na juróom ñett fukki at ak ñeent. Mi ngi dëkke woona jaamu Yàlla guddi ak bëccëg ca kër Yàlla ga, di ñaan ak di woor. ");
INSERT INTO wol2010_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Aana yem ca waxi Simeyon ya, daldi gërëm Yàlla tey yégal mbiri liir ba ñépp ñi doon séentu jamono, ji Yàlla wara jot Yerusalem. ");
INSERT INTO wol2010_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Bi waajuri Yeesu yi matalee seen warugar ci lépp lu yoonu Boroom bi santaane woon, ñu dellu seen dëkku Nasaret ca diiwaanu Galile. ");
INSERT INTO wol2010_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Xale baa nga doon màgg, di dëgër, mu fees ak xel te yiwu Yàlla ànd ak moom. ");
INSERT INTO wol2010_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","At mu jot nag waajuri Yeesu yi daan nañu dem Yerusalem, ngir màggali bésu Mucc ba. ");
INSERT INTO wol2010_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Noonu bi Yeesu amee fukki at ak ñaar, ñu dem màggal ga, ni ñu ko daan defe naka-jekk. ");
INSERT INTO wol2010_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Bi màggal ga tasee, ñu dëpp ñibbi, waaye xale ba Yeesu des Yerusalem, te ay waajuram yéguñu ko. ");
INSERT INTO wol2010_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Ñu xalaat ne, Yeesu dafa àndoon ak ñeneen, ñi ñu bokkaloon yoon. Bi ñu doxee bésub lëmm, ñu tàmbali di ko seet ci seen bokk yi ak seen xame yi. ");
INSERT INTO wol2010_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Bi ñu ko gisul nag, ñu daldi dellu Yerusalem, seeti ko. ");
INSERT INTO wol2010_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Ca gannaaw ëllëg sa ñu fekk ko ca kër Yàlla ga, mu toog ci jànglekati Yawut yi, di déglu ak di laajte. ");
INSERT INTO wol2010_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Ñépp ñi dégg li mu wax yéemu ci xel, mi mu àndal, ak ni mu doon tontoo. ");
INSERT INTO wol2010_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Naka la ko waajuram yi gis, ñu daldi waaru. Yaayam ne ko: «Sama doom, lu tax nga def nu lii? Man ak sa baay nu ngi la doon seet, jaaxle lool.» ");
INSERT INTO wol2010_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Mu ne leen: «Lu tax ngeen may seet? Xanaa xamuleen ne damaa wara nekk ci sama kër Baay?» ");
INSERT INTO wol2010_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Waaye xamuñu li kàddoom yi doon tekki. ");
INSERT INTO wol2010_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Noonu Yeesu daldi ànd ak ñoom, dellu Nasaret te déggal ay waajuram. Fekk yaayam moom takk mbir yooyu yépp ci xolam. ");
INSERT INTO wol2010_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Yeesoo ngi doon màgg ci jëmm, tey yokku ci xam-xam te neex Yàlla ak nit ñi. ");
INSERT INTO wol2010_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Fukkeelu at ak juróom ci nguuru Tibeer Sesaar, fekk Poñsë Pilaat yilif diiwaanu Yude, Erodd yilif diiwaanu Galile, Filib magam yilif diiwaanu Iture ak bu Tarakonit, te Lisañas yilif Abilen. ");
INSERT INTO wol2010_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Te it Anas ak Kayif nekkoon sarxalkat yu mag ya. Ca jamono jooja la kàddug Yàlla wàcc ci Yaxya, doomu Sakari, ca màndiŋ ma. ");
INSERT INTO wol2010_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Yaxya daldi dugg àll, bi wër dexu Yurdan gépp, di waaree nii: «Tuubleen seeni bàkkaar, ba noppi ma sóob leen ci ndox, ngir Yàlla baal leen seeni bàkkaar.» ");
INSERT INTO wol2010_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Loolu lañu bind ci téereb waxi yonent Yàlla Esayi naan: «Am na baat buy xaacu ca màndiŋ ma ne: “Xàll-leen yoonu Boroom bi, jubal-leen fi muy jaar. ");
INSERT INTO wol2010_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Nañu sëkk xur yi, maasale tund yi ak jànj yi. Yoon yi dëng ñu jubbanti leen, yi ñagas ñu rataxal leen. ");
INSERT INTO wol2010_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Bu ko defee bépp mbindeef dina gis mucc gi Yàlla tëral.”» ");
INSERT INTO wol2010_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Mbooloo ma daan ñëw ngir mu sóob leen ci ndox, Yaxya daan na leen wax naan: «Yéen ñi fees ak daŋar mel ni ay co! Ku leen artu ngeen daw merum Yàlla mi nara wàcc? ");
INSERT INTO wol2010_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Jëfeleen nag ni ñu tuub seeni bàkkaar, te baña nax seen bopp naan: “Nun daal doomi Ibraayma lanu,” ndaxte maa ngi leen koy wax, Yàlla man na defal Ibraayma ay doom ci doj yii. ");
INSERT INTO wol2010_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Sémmiñ wi tiim na reeni garab yi. Garab nag gu meññul doom yu baax, dees na ko gor, sànni ko ci sawara si.» ");
INSERT INTO wol2010_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Mbooloo ma laaj ko ne: «Lan lanu wara def nag?» ");
INSERT INTO wol2010_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Mu ne leen: «Ku am ñaari mbubb, nga jox menn mi ki amul. Ku am ñam itam, nga bokk ko ak ki amul.» ");
INSERT INTO wol2010_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Ay juutikat itam ñëw ca Yaxya, ngir mu sóob leen ci ndox; ñu ne ko: «Kilifa gi, lu nu wara def?» ");
INSERT INTO wol2010_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Mu ne leen: «Laajleen rekk lu jaadu.» ");
INSERT INTO wol2010_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Ay xarekat laaj nañu ko ne: «Li jëm ci nun nag?» Mu ne leen: «Buleen néewal doole kenn, jël xaalisam ci kaw ay tëkku mbaa ci seede lu dul dëgg. Waaye doylooleen li ñu leen di fey.» ");
INSERT INTO wol2010_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Mbooloo maa ngay xaar, di séentook a laaj ci seen xel, ndax Yaxya mooy Almasi bi. ");
INSERT INTO wol2010_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Noonu Yaxya wax leen ñoom ñépp ne leen: «Man maa ngi leen di sóob ci ndox. Waaye ki ma ëpp kàttan dina ñëw te yeyoowumaa tekki ay dàllam. Kooku dina leen sóob ci Xel mu Sell mi ak sawara. ");
INSERT INTO wol2010_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Layoom mu ngi ci loxoom, ngir jéri dàgga ja, ba mu set; pepp ma dina ko def ca sàqam, waaye xatax ba dina ko lakk ci sawara su dul fey mukk.» ");
INSERT INTO wol2010_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Noonu Yaxya teg ca yeneen dénkaane yu bare, di yégal nit ña xibaaru jàmm ba. ");
INSERT INTO wol2010_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Waaye Yaxya yedd na Erodd boroom diiwaanu Galile, ndaxte dafa takkoon Erojàdd jabaru magam, te it boole woon na ci yeneen ñaawteef, ");
INSERT INTO wol2010_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","ba faf tëj Yaxya kaso. ");
INSERT INTO wol2010_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Noonu Yaxya sóob mbooloo mépp ci ndox, sóobaale it Yeesu. Bi Yeesu di ñaan nag, asamaan daldi ubbiku. ");
INSERT INTO wol2010_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Noonu Xel mu Sell mi daldi wàcc ci moom, yor jëmmu pitax, te baat bu jóge asamaan jib ne: «Yaa di sama Doom, ji ma bëgg; ci yaw laa ame bànneex.» ");
INSERT INTO wol2010_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Bi Yeesu di tàmbali liggéeyam, amoon na lu wara tollu ci fanweeri at, di doomu Yuusufa ci bëti nit ñi. Te Yuusufa mooy doomu Eli, ");
INSERT INTO wol2010_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","miy doomu Matat. Matat, Lewi mooy baayam; Lewi, Melki; Melki, Yanayi; Yanayi, Yuusufa; ");
INSERT INTO wol2010_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Yuusufa, Matacas; Amos; Naxum; Esli; Nagayi. ");
INSERT INTO wol2010_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Nagayi, Maat; Matacas; Semeyin; Yoseg; Yoda. ");
INSERT INTO wol2010_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Yoda, Yowanan mooy baayam; Yowanan, Resa; Resa, Sorobabel. Kooku Salacel a ko jur; Salacel, Neri; ");
INSERT INTO wol2010_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Neri, Melki; Adi; Kosam; Elmadam; Er. ");
INSERT INTO wol2010_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Er, Yeesu; Eliyeser; Yorim; Matat; Lewi; ");
INSERT INTO wol2010_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Simeyon; Yuda; Yuusufa; Yonam; Eliyakim. ");
INSERT INTO wol2010_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Eliyakim, Meleya; Meleya, Mena; Mena, Matata; Matata, Natan; Natan, Daawuda. ");
INSERT INTO wol2010_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Daawuda mooy doomu Isayi; Isayi, Obedd; Bowas; Salmon; Nason. ");
INSERT INTO wol2010_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Nason; Aminadab; Aminadab, Admin; Arni; Esron; Peres; Yuda; ");
INSERT INTO wol2010_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Yanqóoba; Isaaxa; Ibraayma; Teraa; Naxor; ");
INSERT INTO wol2010_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Serug; Rew; Peleg; Eber; Sela. ");
INSERT INTO wol2010_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Sela, Kaynam mooy baayam; Kaynam, Arpagsàdd; Arpagsàdd, Sem; Sem, Nóoyin; Nóoyin, Lemeg; ");
INSERT INTO wol2010_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Lemeg, Matusalem; Enog, Yeredd; Maleleel; Kaynan; ");
INSERT INTO wol2010_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Enos; Set; Set doomu Aadama; Aadama doomu Yàlla. ");
INSERT INTO wol2010_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Noonu Yeesu fees ak Xel mu Sell mi, jóge dexu Yurdan. ");
INSERT INTO wol2010_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Xelum Yàlla mi yóbbu ko ca màndiŋ ma, mu nekk fa ñeent fukki fan, jànkoonte ak fiiri Seytaane. Lekkul woon dara ci fan yooya, te gannaaw gi mu xiif. ");
INSERT INTO wol2010_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Noonu Seytaane ne ko: «Boo dee Doomu Yàlla, santal doj wii mu nekk mburu.» ");
INSERT INTO wol2010_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Yeesu ne ko: «Mbind mi nee na: “Nit du dunde mburu rekk.”» ");
INSERT INTO wol2010_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Seytaane yóbbu na ko fu kawe. Ci xef ak xippi mu won ko réewi àddina sépp, ");
INSERT INTO wol2010_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","ne ko: «Dinaa la jox bépp sañ-sañu nguur yii ak seen ndam ndaxte jébbal nañu ma ko, te ku ma soob laa koy jox. ");
INSERT INTO wol2010_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Kon boo ma màggalee, dinga moom lépp.» ");
INSERT INTO wol2010_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Yeesu ne ko: «Mbind mi nee na: “Nanga màggal Yàlla sa Boroom te jaamu ko moom rekk.”» ");
INSERT INTO wol2010_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Seytaane yóbbu na ko Yerusalem, teg ko ca njobbaxtalu kër Yàlla ga ne ko: «Boo dee Doomu Yàlla, tëbal jëm ci suuf, ");
INSERT INTO wol2010_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","ndaxte Mbind mi nee na: “Dina jox ay malaakaam ndigal ci sa mbir, ñu sàmm la, ");
INSERT INTO wol2010_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","dinañu la leewu ci seeni loxo, ngir nga baña fakktalu ciw doj.”» ");
INSERT INTO wol2010_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Yeesu ne ko: «Bind nañu ne: “Bul diiŋat Yàlla, sa Boroom.”» ");
INSERT INTO wol2010_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Bi mu ko lalalee fiiram yi mu am yépp, Seytaane daldi sore Yeesu, di xaar yeneen jamono. ");
INSERT INTO wol2010_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Yeesu dellu diiwaanu Galile, fees ak dooley Xelum Yàlla, te turam siiw ca diiwaan booba bépp. ");
INSERT INTO wol2010_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Muy jàngle ca seeni jàngu, te ñépp di ko tagg. ");
INSERT INTO wol2010_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Yeesu dem Nasaret fa mu yaroo, te ca bésub noflaay ba, mu dugg ca jàngu ba, ni mu ko daan defe. Noonu mu taxaw ngir jàngal mbooloo mi. ");
INSERT INTO wol2010_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Ñu jox ko téereb yonent Yàlla Esayi. Bi mu ko ubbee, mu gis bérab, ba ñu bind aaya yii: ");
INSERT INTO wol2010_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","«Xelum Boroom baa ngi ci man, ndaxte moo ma tànn, ngir ma yégal néew doole yi xibaaru jàmm bi. Dafa maa yónni, ngir ma yégal jaam ñi ne dinañu leen goreel, yégal gumba yi ne dinañu gis, te jot ñi ñu not, ");
INSERT INTO wol2010_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","tey yégle atum yiw, mi jóge ci Boroom bi.» ");
INSERT INTO wol2010_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Bi mu jàngee aaya yooyu ba noppi, mu ub téere bi, delloo ko ki koy denc, toog. Ñépp ña nekkoon ca jàngu ba dékk koy bët. ");
INSERT INTO wol2010_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Noonu mu daldi ne: «Tey jii, loolu Mbind mi wax mat na, bi ngeen koy déglu.» ");
INSERT INTO wol2010_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Ñépp di seede lu rafet ci Yeesu, di waaru ci wax ju neex, ji mu doon yégle, ñu naan: «Ndax kii du doomu Yuusufa?» ");
INSERT INTO wol2010_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Mu daldi leen ne: «Xam naa ne dingeen ma ne: “Fajkat bi, fajal sa bopp. Yég nanu li xew Kapernawum, defal lu ni mel fii ci réew mi nga dëkk.”» ");
INSERT INTO wol2010_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Mu tegaat ca ne: «Ci dëgg maa ngi leen koy wax, ab yonent kenn du ko teral ca réewam. ");
INSERT INTO wol2010_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Ci dëgg maa ngi leen koy wax, ca jamonoy Ilyaas, bi mu tawul lu mat ñetti at ak genn-wàll, te xiif bu metti am ca réew mépp, amoon na ca Israyil jigéen yu bare yu seen jëkkër faatu. ");
INSERT INTO wol2010_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Moona Yàlla yónniwul Ilyaas ci kenn ci ñoom, waaye mu yebal ko ci jigéen ju jëkkëram faatu, ju dëkk Sarebta, ca wetu Sidon. ");
INSERT INTO wol2010_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Te it amoon na ca Israyil, ca jamonoy yonent Yàlla Alyaasa, ay nit ñu bare ñu gaana. Waaye fajul ci kenn ku dul Naamaan, mi dëkkoon réewu Siri.» ");
INSERT INTO wol2010_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Bi ñu déggee wax yooya, ñépp ña nekkoon ca jàngu ba daldi fees ak mer. ");
INSERT INTO wol2010_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Noonu ñu jóg, génne ko dëkk ba, yóbbu ko ca mbartalum tund, wa ñu sanc seen dëkk, ngir bëmëx ko ci suuf. ");
INSERT INTO wol2010_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Waaye moom mu jaar ci seen biir, dem yoonam. ");
INSERT INTO wol2010_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Gannaaw loolu Yeesu dem Kapernawum, ab dëkk ca diiwaanu Galile. ");
INSERT INTO wol2010_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Mu jàngal leen ca bésub noflaay ba, ñu waaru ca njàngleem, ndaxte dafa wax ak sañ-sañ. ");
INSERT INTO wol2010_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Noonu am na ci jàngu bi nit ku rab jàpp. Mu daldi xaacu ne: ");
INSERT INTO wol2010_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","«Moo! Yaw Yeesum Nasaret, loo nuy fexeel? Ndax dangaa ñëw ngir alag nu? Xam naa la, yaa di Aji Sell ji jóge ci Yàlla!» ");
INSERT INTO wol2010_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Waaye Yeesu gëdd ko naan: «Noppil te génn ci moom!» Noonu rab wi daaneel nit ki ci suuf ci kanam ñépp, daldi génn ci moom te gaañu ko. ");
INSERT INTO wol2010_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Bi loolu amee ñépp waaru, ñuy waxante ci seen biir naan: «Céy jii wax! Ci sañ-sañ ak doole lay sant rab yi, ñu daldi génn.» ");
INSERT INTO wol2010_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Noonu turam siiw ca diiwaan bépp. ");
INSERT INTO wol2010_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Bi mu jógee ci jàngu bi, Yeesu dafa dem kër Simoŋ. Gorob Simoŋ bu jigéen dafa feebar, ba yaram wi tàng lool. Ñu ñaan Yeesu, mu dimbali leen ci. ");
INSERT INTO wol2010_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Mu randusi, tiim ko, gëdd tàngoor wi, mu dem. Noonu tàngoor wi wàcc, soxna si jóg ca saa sa, di leen topptoo. ");
INSERT INTO wol2010_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Bi jant sowee, ñu indil Yeesu ñi wopp ñépp ak ay jàngoro yu wuute. Kenn ku nekk mu teg la loxo, wéral la. ");
INSERT INTO wol2010_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Te it ay rab di génn ca nit ña te di yuuxu naan: «Yaay Doomu Yàlla!» Noonu mu gëdd leen, te mayu leen, ñu wax dara, ndaxte xam nañu ne mooy Almasi bi. ");
INSERT INTO wol2010_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Ca njël gu jëkk Yeesu génn, dem ca bérab bu wéet. Mbooloo ma di ko seet. Bi ñu ko gisee, ñu koy wuta téye, ngir bañ mu dem. ");
INSERT INTO wol2010_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Mu ne leen: «Damaa wara dem ci yeneen dëkk yi, ngir yégle xibaaru jàmm bi ci nguuru Yàlla, ndaxte looloo tax ñu yónni ma.» ");
INSERT INTO wol2010_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Noonu mu dem di waare ca jàngu ya ca réewu Yawut ya. ");
INSERT INTO wol2010_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Benn bés Yeesu taxaw ca tefesu dexu Senesaret. Mbooloo ma wër ko, di buuxante ngir déglu kàddug Yàlla. ");
INSERT INTO wol2010_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Noonu mu gis ñaari gaal yu teer ca tefes ga, nappkat ya ca wàcce, di raxas seeni mbaal. ");
INSERT INTO wol2010_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Mu dugg ci genn gaal, fekk muy gu Simoŋ, mu ne ko, mu joow ba sore tuuti. Noonu Yeesu toog ca gaal ga, di jàngal mbooloo ma. ");
INSERT INTO wol2010_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Bi mu jànglee ba noppi, mu ne Simoŋ: «Joowal gaal gi, ba fa ndox ma gëna xóote, ngeen sànni fa seeni mbaal ngir napp.» ");
INSERT INTO wol2010_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Simoŋ ne ko: «Kilifa gi, coono lanu fanaane biig te jàppunu dara. Waaye nag dinaa ko sànni ci sa ndigal.» ");
INSERT INTO wol2010_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Naka lañu sànni mbaal yi, jàpp jën yu bare, ba mbaal yay tàmbalee xëtt. ");
INSERT INTO wol2010_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Noonu ñu daldi liyaar seen àndandoo, yi nekk ca geneen gaal ga, ngir ñu ñëw dimbali leen. Ñooñu agsi, ñu feesal ñaari gaal yi, ba ñuy bëgga suux. ");
INSERT INTO wol2010_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Naka la Simoŋ Piyeer gis loolu, daldi sukk ci kanam Yeesu ne ko: «Sore ma Boroom bi, ndaxte nitu bàkkaar laa!» ");
INSERT INTO wol2010_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Wax na loolu nag, ndax jën yu bare ya ñu mbaaloon daf koo jaaxal, moom ak ña mu àndaloon ");
INSERT INTO wol2010_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","ak ña mu bokkaloon liggéey ba, maanaam ñaari doomi Sebede yi di Saag ak Yowaana. Yeesu ne Simoŋ: «Bul ragal dara; gannaaw-si-tey, ay nit ngay mbaal jëme ci man.» ");
INSERT INTO wol2010_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Noonu ñu teer ca tefes ga, bàyyi lépp, di topp ci moom. ");
INSERT INTO wol2010_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Ni Yeesu nekke woon ci ab dëkk, am fa ku gaana ba daj. Bi mu gisee Yeesu, mu daldi dëpp jëëm ci suuf, ñaan ko: «Sang bi, soo ko bëggee, man nga maa wéral.» ");
INSERT INTO wol2010_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Yeesu tàllal loxoom, laal ko naan: «Bëgg naa ko, wéral.» Ca saa sa ngaanaam daldi deñ. ");
INSERT INTO wol2010_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Yeesu sant ko ne: «Bu ko wax kenn, waaye demal won sa bopp sarxalkat bi, te nga jébbal Yàlla sarax si yoonu Musaa santaane, ngir ñu xam ne wér nga, te mu nekk seede ci ñoom.» ");
INSERT INTO wol2010_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Noonu turu Yeesu di gëna siiw. Mbooloo mu bare di ñëw ci moom, ngir déglu ko te mu faj seeni jàngoro. ");
INSERT INTO wol2010_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Waaye Yeesu moom di beddeeku ci bérab yu wéet ya, di ñaan. ");
INSERT INTO wol2010_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Am na bés Yeesu doon jàngle. Amoon na ca mbooloo, ma teewoon, ñu bokkoon ca Farisen ya ak ay xutbakat yu jóge ca dëkk yépp, ya ca Galile ak ya ca Yude ak Yerusalem. Yeesu àndoon na ak dooley Boroom bi, ba muy faj ay jarag. ");
INSERT INTO wol2010_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Noonu ay nit ñëw, jàppoo basaŋ, ga ñu tëral nit ku yaram wépp làggi. Ñu di ko wuta dugal ca kër ga, ngir indi ko ca Yeesu. ");
INSERT INTO wol2010_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Waaye gisuñu fu ñu koy awale ndax mbooloo ma. Ñu daldi yéeg ca kaw kër ga nag, xeddi tiwiil ya, yoor waa ja ak basaŋ ga, wàcce ko ca kanam Yeesu ca biir mbooloo ma. ");
INSERT INTO wol2010_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Bi Yeesu gisee seen ngëm, mu ne làggi ba: «Sama waay, baal nañu la say bàkkaar.» ");
INSERT INTO wol2010_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Xutbakat yi ak Farisen yi di werante ci seen xel naan: «Kii mooy kan bay sosal Yàlla? Ana ku mana baale bàkkaar yi, ku dul Yàlla doŋŋ?» ");
INSERT INTO wol2010_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Waaye Yeesu xam seen xalaat, ne leen: «Lu tax ngeen di werante ci seen xel? ");
INSERT INTO wol2010_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Ma wax ne: “Baal nañu la say bàkkaar,” walla ma ne: “Jógal te dox,” lan moo ci gëna yomb? ");
INSERT INTO wol2010_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Waaye xamleen ne, Doomu nit ki am na ci àddina sañ-sañu baale bàkkaar yi.» Ci kaw loolu Yeesu ne ku làggi ba: «Maa ngi la koy sant, jógal, jël sa basaŋ te nga ñibbi.» ");
INSERT INTO wol2010_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Nit ka jóg ca saa sa ci kanam ñépp, jël basaŋ, ga ñu ko tëraloon, ñibbi tey màggal Yàlla. ");
INSERT INTO wol2010_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Mbooloo mépp waaru, di màggal Yàlla. Ñu ragal tey wax naan: «Gis nanu tey ay mbir yu ëpp xel.» ");
INSERT INTO wol2010_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Gannaaw loolu Yeesu génn, gis ab juutikat bu tudd Lewi, mu toog ca juuti ba. Mu ne ko: «Kaay topp ci man.» ");
INSERT INTO wol2010_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Lewi jóg, bàyyi lépp, daldi ko topp. ");
INSERT INTO wol2010_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Noonu Lewi togglu ay ñam yu bare ci këram, ngir teral Yeesu. Juutikat yu bare ak yeneen gan ñu nga fa woon, di lekkandoo ak ñoom. ");
INSERT INTO wol2010_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Farisen yi ak seeni xutbakat di xultu taalibey Yeesu yi ne leen: «Lu tax ngeen di lekkandoo ak di naanandoo ak ay juutikat ak ay boroom bàkkaar?» ");
INSERT INTO wol2010_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Yeesu ne leen: «Ñi wér soxlawuñu fajkat, ñi wéradi ñoo ko soxla. ");
INSERT INTO wol2010_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Ñëwuma ngir woo ñi jub, waaye ngir woo bàkkaarkat yi, ñu tuub seeni bàkkaar.» ");
INSERT INTO wol2010_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Noonu ñu ne Yeesu: «Taalibey Yaxya yi ak yu Farisen yi dinañu faral di woor ak di ñaan ci Yàlla, waaye say taalibe ñu ngiy lekk ak di naan.» ");
INSERT INTO wol2010_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Yeesu ne leen: «Ndax man ngeena woorloo gan, yi ñëw cig céet, li feek boroom céet gaa ngi ànd ak ñoom? ");
INSERT INTO wol2010_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Waaye bés yaa ngi ñëw, yu ñuy jële boroom céet gi ci seen biir. Bés yooyu nag, dinañu woor.» ");
INSERT INTO wol2010_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Te it Yeesu wax leen léeb wii: «Kenn du jël mbubb mu bees, xotti ci sekkit, daaxe ko mbubb mu màggat. Lu ko moy, dina xotti mbubb mu bees mi, te sekkit, wi mu ci jële, du ànd ak mbubb mu màggat mi. ");
INSERT INTO wol2010_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Te kenn du def biiñ bu bees ci mbuusi der yu màggat. Lu ko moy, biiñ bu bees bi day toj mbuus yi, biiñ bi tuuru, mbuus yi yàqu. ");
INSERT INTO wol2010_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Waaye dañoo wara def biiñ bu bees ci mbuus yu bees. ");
INSERT INTO wol2010_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Ku naan biiñ bu màggat du bëgg bu bees bi, ndax day wax ne: “Bu màggat bi baax na.”» ");
INSERT INTO wol2010_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Amoon na benn bésub noflaay Yeesu di dem, jaar ci ay tool yu ñor. Taalibeem ya di fàq ay cëgg, di leen boxom ci seeni loxo tey lekk. ");
INSERT INTO wol2010_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Am ay Farisen yu ne: «Lu tax ngeen di def lu jaaduwul ci bésub noflaay bi?» ");
INSERT INTO wol2010_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Yeesu ne leen: «Ndax jànguleen la Daawuda defoon, ba mu xiifee, moom ak ña mu àndaloon? ");
INSERT INTO wol2010_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Xanaa yéguleen, ni mu dugge woon ca kër Yàlla ga, jël mburu, ya ñu teewal ca kanam Yàlla, lekk ca, jox ca ña mu àndaloon? Fekk jaaduwul kenn lekk ko, ku dul sarxalkat.» ");
INSERT INTO wol2010_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Yeesu dellu ne leen: «Doomu nit ki mooy boroom bésub noflaay bi.» ");
INSERT INTO wol2010_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Beneen bésub noflaay, Yeesu dugg ci jàngu bi, di fa jàngle. Amoon na fa nit ku loxol ndijooram làggi. ");
INSERT INTO wol2010_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Xutbakat yi ak Farisen yi ñu ngi ko doon xool, ba xam ndax dina ko faj ci bésub noflaay bi, ngir ñu am lu ñu ko tuumaale. ");
INSERT INTO wol2010_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Waaye Yeesu xam seen xalaat, daldi ne ku loxoom làggi: «Jógal taxaw ci kanam ñépp.» Nit ka daldi jóg taxaw. ");
INSERT INTO wol2010_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Yeesu ne leen: «Ma laaj leen, lan moo jaadu, nu def ko bésub noflaay bi, lu baax mbaa lu bon; nu musal nit mbaa nu lor nit?» ");
INSERT INTO wol2010_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Ci kaw loolu mu xool leen ñoom ñépp, ba noppi ne nit ka: «Tàllalal sa loxo.» Mu tàllal ko, loxoom daldi wér péŋŋ. ");
INSERT INTO wol2010_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Waaye nit ña mer ba fees, di rabat pexe yu jëm ca Yeesu. ");
INSERT INTO wol2010_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Ca bés yooya Yeesu yéeg ca tund wa ngir ñaan, mu fanaan fa, di ñaan ci Yàlla. ");
INSERT INTO wol2010_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Bi bët setee, Yeesu woo taalibeem yi, tànn ci fukk ak ñaar, tudde leen ay ndawam: ");
INSERT INTO wol2010_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Simoŋ, mi Yeesu tudde Piyeer, ak Andare, mi bokk ak Piyeer ndey ak baay; Saag ak Yowaana, Filib ak Bartelemi, ");
INSERT INTO wol2010_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Macë ak Tomaa, Saag doomu Alfe, ak Simoŋ mi bokk ci mbooloo, ma ñu tudde Ñi farlu ci moom seen réew; ");
INSERT INTO wol2010_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Yudaa doomu Saag, ak Yudaa Iskariyo, mi mujja wor. ");
INSERT INTO wol2010_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Yeesu ànd ak ndaw ya, wàcc tund ya, daldi taxaw ca joor ga, fa mbooloom taalibe mu takku nekkoon. Amoon na fa it ay nit ñu bare ñu jóge ca réewu Yawut ya mépp ak ca dëkku Yerusalem ak dëkk yi nekk ca wetu géej ga, maanaam Tir ak Sidon. ");
INSERT INTO wol2010_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Dañoo ñëw ngir déglu ko, te it ngir mu faj leen. Ñi rab jàpp it faju nañu. ");
INSERT INTO wol2010_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Ñépp a ngi ko doon wuta laal ndax doole jiy jóge ci moom, di faj ñépp. ");
INSERT INTO wol2010_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Yeesu xool ay taalibeem, ne leen: «Yéen ñi néew doole, barkeel ngeen, ndaxte nguuru Yàlla, yéena ko yelloo. ");
INSERT INTO wol2010_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Yéen ñi xiif léegi, barkeel ngeen, ndax dingeen regg. Yéen ñiy naqarlu léegi, barkeel ngeen, ndax dingeen ree. ");
INSERT INTO wol2010_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Barkeel ngeen, bu leen nit ñi bañee, di leen dàq ak a saaga, di sib seen tur ngir Doomu nit ki. ");
INSERT INTO wol2010_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Bu boobaa bégleen te bànneexu, ndax seen yool dina réy ci laaxira. Ndaxte noonu la maami seeni bañ daan fitnaale yonent yi. ");
INSERT INTO wol2010_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Waaye nag yéen boroom alal yi, torox ngeen, ndaxte jot ngeen ba noppi seen bànneex. ");
INSERT INTO wol2010_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Yéen ñiy lekk ba suur léegi, torox ngeen, ndax ëllëg dingeen xiif. Yéen ñiy ree léegi, torox ngeen, ndax dingeen am aw naqar, ba jooy xàcc. ");
INSERT INTO wol2010_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Torox ngeen bu leen ñépp dee waxal lu baax, ndaxte noonu la seeni maam daan jëfe ak ña doon mbubboo yonent. ");
INSERT INTO wol2010_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","«Waaye maa ngi leen koy wax, yéen ñi may déglu, soppleen seeni bañaale tey defal lu baax ñi leen bañ. ");
INSERT INTO wol2010_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Yéeneleen lu baax ñi leen di móolu, te ñaanal ñi leen di sonal. ");
INSERT INTO wol2010_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Ku la talaata cib lex, jox ko ba ca des. Kuy nangu sa mbubb mu mag, bul téye sa turki. ");
INSERT INTO wol2010_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Képp ku la ñaan, may ko, te ku nangu say yëf, bu ko ko laaj. ");
INSERT INTO wol2010_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Defal-leen nit ñi li ngeen bëgg, ñu defal leen ko. ");
INSERT INTO wol2010_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","«Su ngeen soppee ñi leen sopp, ban ngërëm ngeen ciy am? Ndaxte bàkkaarkat yi sax sopp nañu ñi leen sopp. ");
INSERT INTO wol2010_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Te bu ngeen defalee lu baax ñi leen koy defal, ban ngërëm ngeen ciy am? Bàkkaarkat yi it dañuy def noonu. ");
INSERT INTO wol2010_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Te bu ngeen dee leble te yaakaar ci ndelloo, ban ngërëm ngeen ciy am? Bàkkaarkat yi it dañuy lebal seeni moroom, ngir ñu delloo leen ko. ");
INSERT INTO wol2010_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Waaye soppleen seeni noon, di leen defal lu baax, tey leble, baña yaakaar ñu delloo leen ko. Noonu seen yool dina mag te dingeen wone ne yéenay doomi Aji Kawe ji, ndaxte Yàlla day wone mbaaxam ci ñu goreedi ñi ak ñu soxor ñi. ");
INSERT INTO wol2010_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Nangeen am yërmande, ni seen Baay ame yërmande. ");
INSERT INTO wol2010_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","«Buleen àtte seeni moroom ak ñaaw njort, te deesu leen àtte. Buleen daan kenn, te deesu leen daan. Baal-leen ñi ci des, te dinañu leen baal. ");
INSERT INTO wol2010_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Mayeleen te dinañu leen may. Dinañu leen ëmbal natt bu baax bu ñu rokkos te yëngal ko, mu fees bay tuuru. Ndaxte dees na leen nattal ak natt, bi ngeen di nattale.» ");
INSERT INTO wol2010_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Noonu Yeesu wax na leen beneen léeb ne leen: «Ndax gumba man na wommat moroomam? Mbaa duñu daanu ñoom ñaar ci kàmb? ");
INSERT INTO wol2010_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Taalibe gënul kilifaam, waaye taalibe bu jàng ba wàcc, dina yem ak kilifaam demin. ");
INSERT INTO wol2010_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","«Lu tax ngay xool ñax gi ci sa bëtu mbokk, te gisuloo gànj gi ci sa bët yaw? ");
INSERT INTO wol2010_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Nan nga mana waxe sa mbokk: “Sama xarit, may ma, ma dindil la ñax gi ci sa bët,” yaw mi gisul gànj gi nekk ci sa bët? Naaféq! Jëkkala dindi gànj gi ci sa bët, te noonu dinga mana gis bu leer, ngir dindi ñax gi ci sa bëtu mbokk. ");
INSERT INTO wol2010_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","«Garab gu baax du meññ doom yu bon, te garab gu bon du meññ doom yu baax. ");
INSERT INTO wol2010_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Ndaxte garab, meññeefam lañu koy xàmmee. Deesul witte figg ci dédd, walla reseñ ci xaaxaam. ");
INSERT INTO wol2010_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Noonu nit ku baax, lu baax lay wax, ndax loolu la denc ci xolam, te nit ku bon, lu bon lay wax, ndaxte denc na lu bon ci xolam. Ndaxte gémmiñ, la fees xolam lay wax. ");
INSERT INTO wol2010_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","«Lu tax ngeen may wooye “Boroom bi, Boroom bi,” te dungeen def li may wax? ");
INSERT INTO wol2010_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Képp ku ñëw ci man, di dégg samay wax te di ko jëfe, ma won leen nu muy mel. ");
INSERT INTO wol2010_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Dafa mel ni nit kuy tabax kër, mu gas fu xóot, jot doj wu réy, samp fa kër ga. Bi mbënn ma ñëwee, wal ma dafa dal ca kër ga te yënguwul, ndaxte nit ka dafa tabax kër ga tabax bu dëgër. ");
INSERT INTO wol2010_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Waaye képp ku dégg samay wax te jëfewuloo ko, dinga mel ni nit ku tabax këram ci suuf, bañ koo defal fondamaa. Bi wal ma dalee ca kër googa, dafa màbb ca saa sa, lépp yàqu yaxeet.» ");
INSERT INTO wol2010_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Bi Yeesu waxee la mu naroona wax lépp ca kanam mbooloo ma, mu daldi dem Kapernawum. ");
INSERT INTO wol2010_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Amoon na fa njiitu xare. Njiit la nag, surgaam bu mu bëggoon lool dafa feebaroon, bay bëgga dee. ");
INSERT INTO wol2010_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Bi mu déggee mbiri Yeesu, mu yónni ca moom ay Yawut, di magi dëkk ba, ngir ñaan ko, mu ñëw faj surga ba. ");
INSERT INTO wol2010_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Bi magi dëkk ba agsee ca Yeesu, ñu sàkku ci moom ndimbal, ñaan ko: «Ki nu yónni ci yaw de, yelloo na ndimbal, ");
INSERT INTO wol2010_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","ndaxte sopp na sunu xeet te moo nu tabaxal sax sunu jàngu.» ");
INSERT INTO wol2010_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Noonu Yeesu daldi ànd ak ñoom. Waaye bi ñuy bëgga agsi ca kër ga, njiit la yebal ay xaritam ngir ñu wax Yeesu ne: «Sang bi, bul sonal sa bopp, ndaxte yeyoowuma nga dugg sama kër. ");
INSERT INTO wol2010_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Looloo tax it ma xalaat ne awma darajay gatandu la. Waxal genn kàddu rekk, te sama surga dina wér. ");
INSERT INTO wol2010_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Ndaxte man itam maa ngi nekk ci ndigal, te ame naa ay xarekat ci sama ndigal. Su ma nee kii: “Demal,” mu dem. Mbaa ma ne keneen ki: “Ñëwal,” mu ñëw. Te su ma nee sama jaam: “Defal lii,” mu def ko.» ");
INSERT INTO wol2010_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Bi ko Yeesu déggee, mu waaru. Noonu mu walbatiku ca mbooloo, ma topp ci moom, ne leen: «Maa ngi leen koy wax, ci bànni Israyil sax, masuma cee gis ku gëme nii.» ");
INSERT INTO wol2010_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Noonu ndaw ya daldi dellu ca kër ga. Bi ñu agsee, ñu gis ne surga ba wér na. ");
INSERT INTO wol2010_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Yàggul dara Yeesu dem ci dëkk bu ñuy wax Nayin. Taalibeem yi ak mbooloo mu bare ànd ak moom. ");
INSERT INTO wol2010_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Bi muy agsi ca buntu dëkk ba, fekk ñuy rob néew boo xam ne kenn rekk la woon ci ndeyam, ji jëkkëram faatu woon. Te mbooloo mu bare ca dëkk ba di gunge soxna sa. ");
INSERT INTO wol2010_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Bi ko Boroom ba gisee, mu daldi koy yërëm ne ko: «Bul jooyati.» ");
INSERT INTO wol2010_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Mu jegeñsi, laal jaat ga, ñi ko jàppoo taxaw. Mu ne: «Waxambaane wi, jógal, ndigal la.» ");
INSERT INTO wol2010_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Noonu nit ka dee woon jóg toog, tàmbalee wax. Yeesu delloo ko yaay ja. ");
INSERT INTO wol2010_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Ñépp tiit, bay màggal Yàlla, di wax naan: «Yonent bu mag feeñ na ci sunu biir! Yàlla wallusi na mbooloom!» ");
INSERT INTO wol2010_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","La ñu wax ci mbiri Yeesu daldi siiw ca réewu Yawut ya ak la ko wër yépp. ");
INSERT INTO wol2010_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Taalibey Yaxya ya nettali mbir yooyu yépp seen kilifa. Noonu Yaxya woo ñaar ci ay taalibeem, ");
INSERT INTO wol2010_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","yónni leen ci Boroom bi, ngir laaj ko: «Ndax yaw yaa di Ki wara ñëw, walla danoo wara xaar keneen?» ");
INSERT INTO wol2010_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Bi taalibe ya agsee ca Yeesu, ñu ne ko: «Yaxya moo nu yebal, nu laaj ndax yaa di Ki waroona ñëw, walla danuy xaar keneen?» ");
INSERT INTO wol2010_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Ca waxtu woowa Yeesu wéral nit ñu bare ci seeni feebar ak ci seeni metit, di dàq ay rab tey gisloo ay gumba. ");
INSERT INTO wol2010_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Noonu mu wax ndaw ya ne leen: «Demleen nettali Yaxya li ngeen gis te dégg ko. Gumba yaa ngi gis, lafañ yiy dox, gaana yi wér, tëx yiy dégg, ñi dee di dekki, te néew doole ñaa ngi dégg xibaaru jàmm bi. ");
INSERT INTO wol2010_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Yaw mi sa ngëm yolomul ndax man, barkeel nga.» ");
INSERT INTO wol2010_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Bi ndawi Yaxya yi demee, Yeesu daldi wax ak mbooloo ma ci mbirum Yaxya ne leen: «Lu ngeen seeti woon ca màndiŋ ma? Xanaa barax buy jaayu ci ngelaw li? ");
INSERT INTO wol2010_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Kon lu ngeen seeti woon nag? Nit ku sol yére yu rafet? Waaye ñiy soloo noonu, tey dund dund gu neex ñu ngi dëkk ci këri buur. ");
INSERT INTO wol2010_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Kon lu ngeen seeti woon? Yonent? Waaw, wax naa leen ne ëpp na yonent. ");
INSERT INTO wol2010_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Yaxya male moo di ki ñu waxoon ci Mbind mi naan: “Maa ngi yónni sama ndaw, mu jiitu la, te xàllal la yoon ci sa kanam.” ");
INSERT INTO wol2010_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Maa ngi leen koy wax, ci li jigéen jur, ku sut Yaxya masula feeñ. Waaye ba tey ki gëna ndaw ci nguuru Yàlla moo ko sut.» ");
INSERT INTO wol2010_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Nit ñépp ñi doon déglu Yeesu, ba ci juutikat yi sax, dëggal nañu ne Yàlla ku jub la, ndaxte nangu nañu Yaxya sóob leen ci ndox. ");
INSERT INTO wol2010_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Waaye Farisen ya ak xutbakat ya dañoo bañ, mu sóob leen ci ndox, di wone noonu ne gàntu nañu li leen Yàlla bëggaloon. ");
INSERT INTO wol2010_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Yeesu tegaat ca ne: «Kon lan laa mana méngaleel niti jamono jii? Lan lañuy nirool? ");
INSERT INTO wol2010_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Ñu ngi nirook xale yu toog ca pénc ma tey woowante naan: “Liital nanu leen ak toxoro, te fecculeen, woyal nanu leen woyi dëj, te jooyuleen.” ");
INSERT INTO wol2010_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Ndaxte Yaxya feeñ na, lekkul mburu, naanul biiñ, ngeen daldi ne: “Dafa ànd ak rab.” ");
INSERT INTO wol2010_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Gannaaw gi nag Doomu nit ki ñëw na, lekk, naan, ngeen daldi ne: “Kii daal bëgg na lekk, di naan biiñ, tey xaritoo ak ay juutikat ak ay boroom bàkkaar.” ");
INSERT INTO wol2010_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Waaye li xam-xamu Yàlla di jur, mooy firndeel ne dëgg la.» ");
INSERT INTO wol2010_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Amoon na ab Farisen bu ñaan Yeesu, mu ñëw lekkandoo ak moom. Yeesu dem kër waa ja, toog ca lekkukaay. ");
INSERT INTO wol2010_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Fekk amoon na ca dëkk ba jigéen juy moy Yàlla. Bi mu yégee ne, Yeesoo ngay lekk ca kër Farisen ba, mu dem, yóbbaale njaq lu ñu defare doj wu ñuy wax albaatar te def latkoloñ. ");
INSERT INTO wol2010_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Bi jigéen ja agsee, mu taxaw ca gannaaw tànki Yeesu, di jooy. Noonu ay rongooñam tooyal tànki Yeesu, jigéen ja di leen fomp ak kawaram, di leen fóon te ciy sotti latkoloñ ja. ");
INSERT INTO wol2010_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Naka la Farisen, bi woo woon Yeesu ci këram, gis loolu, mu wax ci xelam naan: «Bu nit kii doonoon yonent, kon dina xam kuy jigéen ji koy laal ak ni mu nekke bàkkaarkat.» ");
INSERT INTO wol2010_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Yeesu ne ca tonn, daldi ne Farisen ba: «Simoŋ, am na lu ma la wara wax.» Simoŋ ne ko: «Waxal, kilifa gi.» ");
INSERT INTO wol2010_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Yeesu ne ko: «Da fee amoon ñaari nit ñu ameel bor benn leblekat. Kenn kaa ngi ko ameel téeméeri junni ci xaalis, ki ci des fukki junni. ");
INSERT INTO wol2010_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Waaye kenn ci ñoom manu koo fey. Noonu mu baal leen bor ya. Ci ñaar ñooñu nag kan moo ko ciy gëna bëgg?» ");
INSERT INTO wol2010_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Simoŋ ne ko: «Xanaa ki ñu baal bor bi gëna bare.» Yeesu ne ko: «Àtte nga dëgg,» ");
INSERT INTO wol2010_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","daldi walbatiku ca jigéen ja, ne Simoŋ: «Ndax gis nga jigéen jii? Dugg naa sa kër, te joxewuloo ndox, ngir raxas samay tànk. Waaye moom, raxas na samay tànk ak ay rongooñam, ba noppi fomp leen ak kawaram. ");
INSERT INTO wol2010_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Bi ma agsee, fóonuloo ma, waaye moom, bi ma duggee ba léegi tàyyiwul ci di fóon samay tànk. ");
INSERT INTO wol2010_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Defuloo diw ci sama bopp, waaye moom, sotti na latkoloñ ci samay tànk. ");
INSERT INTO wol2010_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Moo tax ma di la wax ne, su wonee mbëggeel gu réye nii, dafa fekk ñu baal ko bàkkaaram yu bare. Waaye ki mbëggeelam néew dafa fekk ñu baal ko lu tuuti.» ");
INSERT INTO wol2010_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Yeesu daldi ne jigéen ja: «Baal nañu la say bàkkaar.» ");
INSERT INTO wol2010_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Noonu ñi doon lekkandoo ak moom di wax ci seen xel naan: «Kii am sañ-sañu baale bàkkaar mooy kan?» ");
INSERT INTO wol2010_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Waaye Yeesu ne jigéen ja: «Sa ngëm musal na la. Demal ci jàmm.» ");
INSERT INTO wol2010_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Gannaaw loolu Yeesu di dem ca ay dëkk yu mag ak yu ndaw, di waaraate ak di yégle xibaaru jàmm bi jëm ci nguuru Yàlla. Fukki taalibe ya ak ñaar ànd ak moom, ");
INSERT INTO wol2010_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","ak ay jigéen yu mu teqale woon ak rab te jële leen ci seeni wopp, ñu di: Maryaama, mi ñuy wooye Maryaamam Magdala, mi Yeesu tàggale woon ak juróom ñaari rab; ");
INSERT INTO wol2010_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Sànn, soxnas ku ñuy wax Kusa, mi doon wottu alalu Erodd; ak Susànn ak ñeneen jigéen. Jigéen ñooñu ñoo doon joxe seen alal, ngir dimbali Yeesu ak ay taalibeem. ");
INSERT INTO wol2010_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Dëkk ak dëkk nit ña di fa jóge jëm ca Yeesu, ba mbooloo mu bare dajaloo, mu wax leen léeb wii: ");
INSERT INTO wol2010_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","«Dafa amoon beykat bu demoon jiyi. Bi muy saaw toolam nag, lenn ci pepp mi wadd ci kaw yoon wi, nit ñi joggi ci, picci asamaan lekk ko lépp. ");
INSERT INTO wol2010_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Leneen wadd ci bérab bu bare ay doj. Naka la sax rekk, daldi wow, ndaxte suuf si tooyul woon. ");
INSERT INTO wol2010_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Leneen nag wadd ci biir ay xaaxaam, ñu saxandoo, xaaxaam ya tanc ko. ");
INSERT INTO wol2010_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Li ci des dal ci suuf su baax, sax, nangu ba meññ téeméeri yoon lu ëpp la mu ji woon.» Gannaaw loolu Yeesu wax ak kàddu gu dëgër ne: «Déglul bu baax, yaw mi am ay nopp.» ");
INSERT INTO wol2010_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Taalibey Yeesu yi laaj ko lu léeb woowu di tekki. ");
INSERT INTO wol2010_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Mu ne leen: «May nañu leen, ngeen xam mbóoti nguuru Yàlla, waaye ñi ci des, dama leen di wax ci ay léeb. Noonu la, ngir: “Ñuy xool te duñu mana gis, di dégg te duñu mana xam.” ");
INSERT INTO wol2010_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","«Lii la léebu beykat bi di tekki. Kàddug Yàlla mooy jiwu wi. ");
INSERT INTO wol2010_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Ki féete ci yoon wi mooy ki dégg. Gannaaw gi, Seytaane dafay ñëw, këf kàddu, gi ñu def ci xolam, ngir mu baña gëm te Yàlla musal ko. ");
INSERT INTO wol2010_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Ki nekk ci bérab bu bare ay doj, mooy ki dégg kàddu gi, ba noppi nangu ko ak mbég. Waaye wax ji saxul ci moom. Dina gëm ab diir, waaye bu nattu yi agsee, mu daldi dàggeeku. ");
INSERT INTO wol2010_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Ki jot ci jiwu wi ci xaaxaam yi mooy ki dégg kàddu gi, waaye nees-tuut soxla yi ak alal ak bànneexi àddina tanc ko, ba du àgg cig mat. ");
INSERT INTO wol2010_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Ki jot ci jiwu wi ci suuf su baax si nag, mooy ki dégg kàddu gi te denc ko ci xol bu baax bu gore, te muñ ba jur njariñ. ");
INSERT INTO wol2010_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","«Kenn du taal làmp, dëpp ci leget, walla mu di ko def ci ron lal. Daf koy wékk, ngir mu leeral ñiy dugg. ");
INSERT INTO wol2010_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Amul dara luy kumpa lu ñu dul siiwal bés, walla lu làqu lu ñu dul feeñal, ba mu ne fàŋŋ. ");
INSERT INTO wol2010_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Seetleen bu baax, ni ngeen di dégloo kàddu gi. Ku am, dees na la dollil, waaye ku amul, dees na nangu sax li nga xalaatoon ne am nga ko ba noppi.» ");
INSERT INTO wol2010_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Noonu ndeyu Yeesu ak ay rakkam ñëw seetsi ko, waaye manuñu woona agsi ci moom, ndaxte nit ña dañoo bare. ");
INSERT INTO wol2010_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Am ku ko yégal ne: «Sa yaay ak say rakk ñu ngi nii taxaw ci biti, bëgg laa gis.» ");
INSERT INTO wol2010_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Waaye mu daldi leen ne: «Sama yaay ak samay rakk, ñooy ñiy déglu kàddug Yàlla, te di ko topp.» ");
INSERT INTO wol2010_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Benn bés Yeesu àndoon na ak ay taalibeem, dugg ci gaal. Mu ne leen: «Nanu jàll dex gi.» Noonu ñu dem. ");
INSERT INTO wol2010_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Bi ñuy dem nag, Yeesu daldi nelaw. Ngelaw lu am doole daldi ñëw, yëngal dex gi, gaal gi fees ak ndox, ba ñu bëgga suux. ");
INSERT INTO wol2010_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Noonu taalibe yi jegesi Yeesu, yee ko ne: «Kilifa gi, kilifa gi, nu ngiy dee!» Ci kaw loolu Yeesu jóg, daldi gëdd ngelaw li ak duus yi. Lépp dal, ba ne nemm. ");
INSERT INTO wol2010_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Yeesu ne taalibe yi: «Ana seen ngëm?» Ñu daldi tiit te waaru, naan ci seen biir: «Kii moo di kan? Mi ngi jox ndigal ngelaw li ak ndox mi, ñu koy déggal.» ");
INSERT INTO wol2010_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Noonu ñu teer ca diiwaanu waa Serasa, fa jàkkaarloo ak diiwaanu Galile. ");
INSERT INTO wol2010_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Bi Yeesu di wàcc ca gaal ga, ku rab jàpp ca waa dëkk ba ñëw, kar ko. Yàgg na def yaramu neen te dëkkul ca kër, waaye ca sëg ya lay nekk. ");
INSERT INTO wol2010_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Bi mu gisee Yeesu, mu yuuxu, daanu ciy tànkam, daldi xaacu ne: «Yaw Yeesu Doomu Yàlla Aji Kawe ji, loo may fexeel? Maa ngi lay ñaan, nga bañ maa mbugal.» ");
INSERT INTO wol2010_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Dafa wax loolu, ndaxte Yeesu santoon na rab wi, mu génn ci moom. Rab wa dafa ko doon farala jàpp. Nit ñi daan nañu ko wottu, di ko yeew ak ay càllala, ak di ko jéng, mu di leen dagg, rab wi di ko xiir ca bérab yu wéet. ");
INSERT INTO wol2010_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Noonu Yeesu laaj ko: «Noo tudd?» Mu ne ko: «Coggal laa tudd.» Dafa wax loolu, ndaxte rab yu baree ko jàppoon. ");
INSERT INTO wol2010_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Rab yooyoo ngi ko doon ñaan, ngir mu bañ leena sant, ñu dem ca kàmb gu xóot gi. ");
INSERT INTO wol2010_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Fekk amoon na fa géttu mbaam-xuux yu bare, yuy for ca tund wa. Rab ya ñaan Yeesu, mu may leen, ñu dugg mbaam-xuux ya. Mu may leen ko. ");
INSERT INTO wol2010_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Noonu rab ya génn nit ka, dugg mbaam-xuux ya, ñu daldi bartalu, daanu ca dex ga, lab. ");
INSERT INTO wol2010_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Sàmm ya gis li xew, daw nettaliji mbir mi ca dëkk ba ak ca àll ba. ");
INSERT INTO wol2010_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Nit ñi génn, ngir seet li xew. Bi ñu agsee ca Yeesu, ñu fekk fa nit, ka rab ya bàyyi woon, toog ca kanam Yeesu, sol ay yére te ànd ak sagoom. Ñu daldi ragal. ");
INSERT INTO wol2010_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Ña fekke woon mbir ma nag, nettali leen naka la Yeesu wérale ki rab ya jàppoon. ");
INSERT INTO wol2010_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Ci kaw loolu waa diiwaanu Serasa bépp ragal, ba ñaan Yeesu mu jóge fa. Noonu Yeesu dugg ci gaal gi, di bëgga dem. ");
INSERT INTO wol2010_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Nit ki Yeesu tàggale woon ak rab ya ñaan ko, ngir ànd ak moom. Waaye Yeesu waññi ko ne ko: ");
INSERT INTO wol2010_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","«Ñibbil, nettali li la Yàlla defal lépp.» Noonu waa ji dem di wër dëkk ba yépp, di fa yégle la ko Yeesu defal. ");
INSERT INTO wol2010_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Bi Yeesu dëppee dellu, mbooloo ma di ko teeru, ndaxte ñépp a ngi ko doon xaar. ");
INSERT INTO wol2010_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Noonu nit ñëw, tuddoon Yayrus te nekk njiitu jàngu ba. Bi mu agsee, mu daanu ci tànki Yeesu, sarxu ko mu ñëw këram, ");
INSERT INTO wol2010_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","ndaxte jenn doomam ju jigéen, ji mu amoon kepp te muy tollu ci fukki at ak ñaar, ma nga doon waaja dee. Bi Yeesuy dem, nit ñaa ngi doon buuxante, di ko tanc. ");
INSERT INTO wol2010_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Amoon na nag ca mbooloo ma jigéen ju doon xëpp deret diirub fukki at ak ñaar, te kenn manu ko woona faj. ");
INSERT INTO wol2010_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Jigéen ja jegeñsi Yeesu nag, doxe ko gannaaw, laal catu mbubbam. Ca saa sa deret ji dal. ");
INSERT INTO wol2010_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Yeesu laaj nit ña ne: «Ana ku ma laal?» Ku nekk di miim. Noonu Piyeer ne ko: «Kilifa gi, nit ñépp a ngi lay wër, di la tanc wet gu nekk.» ");
INSERT INTO wol2010_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Waaye Yeesu ne: «Am na ku ma laal, ndaxte yég naa ne am na doole ju génn ci man.» ");
INSERT INTO wol2010_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Te jigéen ja xam ne manul woona nëbb li mu def. Mu daldi daanu ci tànki Yeesu, di lox. Noonu mu nettali ci kanam ñépp li taxoon mu laal Yeesu, ak ni mu wére ca saa sa. ");
INSERT INTO wol2010_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Yeesu ne ko: «Soxna si, sa ngëm faj na la. Demal ci jàmm.» ");
INSERT INTO wol2010_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Bi Yeesu di wax nag, am na ku jóge ca kër njiit la, mu ñëw naan: «Sa doom faatu na; matatul ngay sonal kilifa gi.» ");
INSERT INTO wol2010_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Yeesu dégg kàddu yooyu, daldi ne njiit la: «Bul tiit. Gëmal rekk te dina dundaat.» ");
INSERT INTO wol2010_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Bi Yeesu agsee ca kër ga, nanguwul kenn duggaaleek moom, ñu dul Piyeer, Yowaana, Saag ak waajuri xale ba. ");
INSERT INTO wol2010_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Ña fa nekk ñépp di yuuxu ak di jooy xale bi. Noonu Yeesu ne leen: «Bàyyileen seen jooy yi. Janq bi deewul, day nelaw rekk.» ");
INSERT INTO wol2010_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Waaye ñu di ko ñaawal, ndaxte xamoon nañu ne dee na. ");
INSERT INTO wol2010_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Waaye Yeesu jàpp loxob janq ba, woo ko ne ko: «Xale bi, jógal.» ");
INSERT INTO wol2010_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Noonu ruuwu xale ba délsiwaat, mu daldi jóg ca saa sa. Yeesu santaane ñu may ko, mu lekk. ");
INSERT INTO wol2010_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Waajuri xale bi daldi waaru. Waaye Yeesu tere leen, ñu wax kenn li xew. ");
INSERT INTO wol2010_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Benn bés Yeesu dajale fukki taalibe ya ak ñaar, jox leen doole ak sañ-sañu dàq rab yépp ak di faj jàngoro yi. ");
INSERT INTO wol2010_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Noonu mu yónni leen ñuy yégle nguuru Yàlla ak di faj jarag yi. ");
INSERT INTO wol2010_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Mu ne leen: «Bu ngeen di dem, buleen yóbbaale dara, du yet mbaa mbuus mbaa mburu mbaa xaalis. Buleen yor it ñaari turki. ");
INSERT INTO wol2010_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Kër gu ngeen dugg, dal-leen fa, ba kera ngeen di fa jóge. ");
INSERT INTO wol2010_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Fépp fu leen nit ñi gàntoo, génnleen ca dëkk booba te ngeen yëlëb seen pëndu tànk, ngir seede leen seen réer.» ");
INSERT INTO wol2010_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Noonu ñu dem dëkk ak dëkk, di fa yégle xibaaru jàmm bi, tey wéral jarag yi. ");
INSERT INTO wol2010_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Bi Erodd boroom diiwaanu Galile déggee li Yeesu ak ay taalibeem doon def lépp, mu jaaxle, ndaxte amoon na, ñu doon wax ci mbiri Yeesu naan: «Yaxya moo dekki.» ");
INSERT INTO wol2010_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Am it ñuy wax naan: Ilyaas moo délsi. Ñeneen naan: «Kenn ci yonent yu jëkk yaa dekki.» ");
INSERT INTO wol2010_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Waaye Erodd ne: «Yaxya, man mii maa dagglu boppam. Kon kii ma dégg ay jalooreem, mooy kan?» Noonu mu koy fexee gis. ");
INSERT INTO wol2010_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Bi ndaw ya délsee, ñu nettali Yeesu la ñu defoon lépp. Noonu mu yóbbaale leen, ñu sore nit ñi, jëm ca dëkk bu ñuy wax Betsayda. ");
INSERT INTO wol2010_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Bi ko nit ña yégee, ñu toppi ko. Yeesu teeru leen, di leen wax ci mbirum nguuru Yàlla, te di wéral ñi ko aajowoo. ");
INSERT INTO wol2010_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Ca ngoon sa fukki taalibe ya ak ñaar ñëw ci Yeesu ne ko: «Yiwil mbooloo mi, ñu dugg ci dëkk yi ak àll bi ko wër, ngir am lu ñu lekk ak fu ñu fanaan, ndaxte fii àllub neen la.» ");
INSERT INTO wol2010_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Waaye Yeesu ne leen: «Joxleen leen lu ñu lekk.» Ñu ne ko: «Amunu lu dul juróomi mburu ak ñaari jën. Xanaa ndax nu dem jëndal mbooloo mii lu ñu lekk?» ");
INSERT INTO wol2010_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Ndaxte lu wara mat juróomi junniy góor a nga fa teewoon. Yeesu ne taalibe ya: «Neeleen mbooloo mi ñu toog def ay géewi juróom fukki nit.» ");
INSERT INTO wol2010_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Taalibe ya def ko, toogloo nit ña. ");
INSERT INTO wol2010_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Bi loolu amee Yeesu jël juróomi mburu yi ak ñaari jën yi, xool ci kaw, gërëm Yàlla, ba noppi mu damm leen, jox taalibe yi, ngir ñu séddale ko mbooloo mi. ");
INSERT INTO wol2010_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Noonu ñépp lekk ba suur. Bi ñu dajalee desit ya, ñu feesal fukki pañe ak ñaar. ");
INSERT INTO wol2010_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Benn bés Yeesu beddeeku mbooloo ma, di ñaan; taalibe yi nekk ci wetam. Mu laaj leen ne: «Nit ñi, ku ñu wax ne moom laa?» ");
INSERT INTO wol2010_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Ñu ne ko: «Am na ñu naan, yaa di Yaxya; ñeneen ne, Ilyaas; ñi ci des ne yaay kenn ci yonent yu jëkk yaa dekki.» ");
INSERT INTO wol2010_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Yeesu ne leen: «Yéen nag ku ngeen ne moom laa?» Piyeer ne ko: «Yaa di Almasi, bi Yàlla yónni.» ");
INSERT INTO wol2010_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Noonu Yeesu daldi leen dénk, tere leen ñu wax ko kenn, ");
INSERT INTO wol2010_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","teg ca ne: «Doomu nit ki war na sonn lu bare; sarxalkat yu mag ya ak xutbakat ya dëddu ko, ñu rey ko, mu dekki ca ñetteelu fan ba.» ");
INSERT INTO wol2010_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Noonu Yeesu ne leen ñoom ñépp: «Ku bëgga aw ci samay tànk, na bàyyi boppam, gàddu bés bu nekk bant, bi ñu ko wara daaj, doora topp ci man. ");
INSERT INTO wol2010_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Ndaxte koo xam ne bëgg ngaa rawale sa bakkan, dinga ko ñàkk, waaye ku ñàkk sa bakkan ngir man, dinga ko jotaat. ");
INSERT INTO wol2010_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Ndaxte moom àddina sépp, lu muy jariñ nit, su fekkee ne dafay ñàkk bakkanam walla mu loru? ");
INSERT INTO wol2010_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Ku ma rusa faral, te nanguwul samay wax, Doomu nit ki dina la rusa xam, bés bu ñëwee ci ndamam ak ci ndamu Baay bi ak lu malaaka yu sell yi. ");
INSERT INTO wol2010_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Ci dëgg maa ngi leen koy wax, am na ñi fi taxaw ñoo xam ne duñu dee te gisuñu nguuru Yàlla gi.» ");
INSERT INTO wol2010_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Bi ñu ca tegee luy tollook ayu-bés gannaaw bi Yeesu waxee loolu, mu ànd ak Piyeer, Yowaana ak Saag, yéeg ca kaw tund wa ngir ñaan. ");
INSERT INTO wol2010_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Bi muy ñaan, xar kanamam daldi soppiku, ay yéreem weex tàll bay melax. ");
INSERT INTO wol2010_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Am ñaari nit di waxtaan ak moom, muy yonenti Yàlla Musaa ak Ilyaas. ");
INSERT INTO wol2010_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Ñoo feeñ ci ndamu Yàlla, di waxtaane ci demug Yeesu, gi muy àggalee yenam ci Yerusalem. ");
INSERT INTO wol2010_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Fekk Piyeer ak ñi mu àndal doon gëmméentu, waaye bi ñu yewwoo bu baax, ñu gis ndamu Yeesu, ak ñaari nit ñu taxaw ci wetam. ");
INSERT INTO wol2010_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Bi nit ñooñu di sore Yeesu, Piyeer ne ko: «Kilifa gi, bég nanu ci sunu teew fii; nanu defar ñetti mbaar, benn yaw, benn Musaa ak benn Ilyaas.» Fekk xamul la mu doon wax. ");
INSERT INTO wol2010_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Bi mu koy wax, niir ñëw muur leen, taalibe yi daldi tiit, bi leen niir wa ëmbee. ");
INSERT INTO wol2010_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Noonu baat jibe ca niir wa naan: «Kii mooy sama Doom ji ma fal; dégluleen ko.» ");
INSERT INTO wol2010_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Bi baat ba waxee ba noppi, Yeesu rekk des fa. Taalibe ya noppi, baña nettali kenn ca jamono jooja la ñu gisoon. ");
INSERT INTO wol2010_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Ca suba sa Yeesu ak taalibe ya wàcce ca tund wa, mbooloo mu bare ñëw, di ko gatandu. ");
INSERT INTO wol2010_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Nit xaacu ci biir mbooloo mi naan: «Kilifa gi, maa ngi lay ñaan, nga seet sama doom, ndaxte moom kepp laa am. ");
INSERT INTO wol2010_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Léeg-léeg rab jàpp ko, mu daldi yuuxu ca saa sa, rab wi di ko sayloo, gémmiñ gi di fuur. Du faral di génn ci moom te dina ko sonal. ");
INSERT INTO wol2010_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Ñaan naa say taalibe, ñu dàq ko, waaye manuñu ko.» ");
INSERT INTO wol2010_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Yeesu ne leen: «Yéen niti jamono jii, yéen ñi gëmadi te dëng, ba kañ laa wara nekk ak yéen te di leen muñal? Indil ma sa doom.» ");
INSERT INTO wol2010_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Bi xale biy agsi, rab wi di ko daaneel ci suuf, muy say. Waaye Yeesu daldi gëdd rab wa, wéral xale ba, daldi ko delloo baayam. ");
INSERT INTO wol2010_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Ku nekk waaru na ndax màggug Yàlla. Bi ñuy yéemu ci li mu doon def, Yeesu ne taalibeem ya: ");
INSERT INTO wol2010_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","«Dégluleen bu baax lii ma leen di wax: dinañu jébbal Doomu nit ki ci loxoy nit ñi.» ");
INSERT INTO wol2010_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Waaye taalibe ya xamuñu kàddu googu. Yàlla dafa leen nëbb li muy tekki, ba ñu bañ koo xam, te ñemewuñu koo laaj Yeesu. ");
INSERT INTO wol2010_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Werante am ci biir taalibe yi, ñuy laajante kan moo gëna màgg ci ñoom. ");
INSERT INTO wol2010_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Yeesu mi xam seen xalaat, jël ab xale, teg ci wetam ne leen: ");
INSERT INTO wol2010_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","«Ku nangu xale bii ci sama tur, man mii nga nangu; te ku ma nangu, nangu nga ki ma yónni; ndaxte ki gëna woyof ci yéen ñépp, kooku moo gëna màgg.» ");
INSERT INTO wol2010_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Bi loolu amee Yowaana jël kàddu gi ne: «Kilifa gi, danoo gis nit kuy dàq ay rab ci sa tur, nu tere ko ko, ndaxte bokkul ci nun.» ");
INSERT INTO wol2010_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Waaye Yeesu ne ko: «Buleen ko tere, ndaxte ku la sotul, far na ak yaw.» ");
INSERT INTO wol2010_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Bi jamono ji jegeñsee, ji Yeesu waree jóge àddina dem asamaan, mu sigiñu ci dem Yerusalem. ");
INSERT INTO wol2010_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Noonu mu yebal ay ndaw, ñu jiitu ko. Ñu dem nag, dugg ci ab dëkk ci diiwaanu Samari, ngir wutal ko fa fu mu dal. ");
INSERT INTO wol2010_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Waaye waa dëkk ba nanguwuñu ko, ndaxte mi ngi jublu woon Yerusalem. ");
INSERT INTO wol2010_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Bi taalibe yi tudd Saag ak Yowaana gisee loolu, ñu ne: «Boroom bi, ndax dangaa bëgg nu ne, na sawaras asamaan dal ci seen kaw, faagaagal leen?» ");
INSERT INTO wol2010_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Waaye Yeesu walbatiku, yedd taalibe ya, ");
INSERT INTO wol2010_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","ba noppi ñu daldi dem wuti beneen dëkk. ");
INSERT INTO wol2010_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Bi ñuy dem, am ci yoon wi ku ne Yeesu: «Dinaa la topp fépp foo jëm.» ");
INSERT INTO wol2010_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Waaye Yeesu ne ko: «Till yi am nañu seeni kàmb, te picci asamaan am nañu ay tàgg, waaye Doomu nit ki amul fu mu noppal boppam.» ");
INSERT INTO wol2010_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Yeesu ne keneen: «Toppal ci man.» Waaye kooku ne ko: «Sang bi, may ma, ma jëkka dem suuli sama baay.» ");
INSERT INTO wol2010_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Mu ne ko: «Bàyyil ñi dee, ñu suul seeni néew. Yaw demal, yégle nguuru Yàlla.» ");
INSERT INTO wol2010_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Keneen ne ko: «Sang bi, dinaa la topp, waaye may ma, ma jëkka tàgguji sama waa kër.» ");
INSERT INTO wol2010_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Yeesu ne ko: «Kuy ji, di geestu, yeyoowula liggéey ci nguuru Yàlla.» ");
INSERT INTO wol2010_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Gannaaw loolu Boroom bi tànn na yeneen juróom ñaar fukki taalibe ak ñaar, yebal leen, ñu ànd ñaar ak ñaar, jiituji ko ca dëkk yépp ak ca bérab yépp, ya mu naroona dem moom ci boppam. ");
INSERT INTO wol2010_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Mu ne leen: «Ngóob mi yaatu na, waaye liggéeykat yi barewuñu. Ñaanleen nag Boroom ngóob mi, mu yebal ay liggéeykat, ñu góob toolam. ");
INSERT INTO wol2010_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Demleen! Maa ngi leen di yónni, mel ni ay mbote ci biir ay bukki. ");
INSERT INTO wol2010_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Buleen yor xaalis walla mbuus walla ay dàll. Buleen nuyu kenn ci yoon wi. ");
INSERT INTO wol2010_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","«Kër gu ngeen mana dugg, nangeen jëkk ne: “Na jàmm wàcc ci kër gi.” ");
INSERT INTO wol2010_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Bu fa nitu jàmm nekkee, seen yéene dina ko indil jàmm. Lu ko moy, seen yéene dina délsi ci yéen. ");
INSERT INTO wol2010_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Dal-leen ca kër googa, tey lekk ak a naan lu ñu leen di jox, ndaxte liggéeykat yelloo na jot peyam. Buleen dem nag kër ak kër. ");
INSERT INTO wol2010_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","«Dëkk bu ngeen mana dugg, te waa dëkk ba teeru leen, lu ñu leen jox, lekkleen ko. ");
INSERT INTO wol2010_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Nangeen wéral jaragi dëkk ba, te ngeen ne leen: “Nguuru Yàlla jegesi na leen.” ");
INSERT INTO wol2010_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Waaye bu ngeen duggee ci dëkk te teeruwuñu leen, demleen ca mbedd ya te ne leen: ");
INSERT INTO wol2010_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","“Seen pëndu dëkk, bi taq ci sunuy tànk sax, noo ngi koy faxas, ngir seede leen seen réer. Waaye nag xamleen ne nguuru Yàlla jegesi na.” ");
INSERT INTO wol2010_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Maa ngi leen koy wax, bu bés baa, waa Sodom ñooy tane dëkk boobu. ");
INSERT INTO wol2010_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","«Dingeen torox, yéen waa Korasin ak waa Betsayda, ndaxte kéemaan yi ma def ci yéen, bu ñu leen defoon ci dëkku Tir walla ci dëkku Sidon, kon tuub nañu seeni bàkkaar bu yàgg, xëppoo dóom, sol saaku. ");
INSERT INTO wol2010_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Moona ca bés pénc ba, Tir ak Sidon ñoo leen di tane. ");
INSERT INTO wol2010_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Te yaw dëkku Kapernawum, ndax dees na la yékkati bu kawe? Déedéet, dees na la daane bu suufe. ");
INSERT INTO wol2010_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","«Ku leen déglu, déglu na ma; ku leen bañ, bañ na ma. Te ku ma bañ, bañ na ki ma yónni.» ");
INSERT INTO wol2010_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Juróom ñaar fukki taalibe yi ak ñaar délsi, fees ak mbég te naan: «Boroom bi, rab yi sax déggal nañu nu ndax sa tur.» ");
INSERT INTO wol2010_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Yeesu ne leen: «Maa ngi doon séen Seytaane wàcce asamaan ni sawaras melax. ");
INSERT INTO wol2010_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Gis ngeen, jox naa leen sañ-sañu joggi ci jaan yi ak ci jiit yi, daan dooley bañaale bi, te dara du leen mana gaañ. ");
INSERT INTO wol2010_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Moona li leen rab yi déggal, bumu tax ngeen bég, waaye bégleen ndax li ñu bind seen tur ci asamaan.» ");
INSERT INTO wol2010_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Ca saa soosu Xel mu Sell mi feesal Yeesu ak mbég, mu daldi ne: «Yaw Baay, Boroom asamaan ak suuf, maa ngi lay sant ci li nga nëbb yëf yii ñi am xam-xam ak ñi am xel, te xamal leen gone yi. Waaw, Baay, ndaxte looloo la neex.» ");
INSERT INTO wol2010_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Yeesu teg ca ne: «Sama Baay jébbal na ma lépp, te kenn manula xam, man Doom ji, maay kan, ku dul Baay bi; kenn manula xam it kan mooy Baay bi, ku dul man Doom ji, ak ku ma ko bëgga xamal.» ");
INSERT INTO wol2010_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Gannaaw bi mu waxee loolu, Yeesu walbatiku ca taalibe ya ne leen ñoom rekk: «Ñi seeni bët di gis li ngeen di gis, am nañu mbég. ");
INSERT INTO wol2010_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Ndaxte maa ngi leen koy wax, yonent yu bare ak buur yu bare bëggoon nañoo gis li ngeen di gis, waaye gisuñu ko, te dégg li ngeen di dégg, waaye dégguñu ko.» ");
INSERT INTO wol2010_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Noonu benn xutbakat daldi jóg, ngir fexee fiir Yeesu ne ko: «Kilifa gi, lan laa wara def, ba am dund gu dul jeex?» ");
INSERT INTO wol2010_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Yeesu ne ko: «Lu ñu bind ci yoonu Musaa? Lan nga ciy jàng?» ");
INSERT INTO wol2010_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Nit ka ne ko: «“Nanga bëgg Yàlla sa Boroom ak sa xol bépp ak sa bakkan bépp, sa kàttan gépp ak sa xel mépp,” te it: “Nanga bëgg sa moroom, ni nga bëgge sa bopp.”» ");
INSERT INTO wol2010_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Yeesu ne ko nag: «Li nga wax dëgg la. Boo defee loolu, dinga dund ba fàww.» ");
INSERT INTO wol2010_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Waaye xutbakat ba bëggoona am aw lay, ne Yeesu: «Kan mooy sama moroom nag?» ");
INSERT INTO wol2010_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Yeesu ne ko: «Dafa amoon nit ku jóge woon Yerusalem, jëm Yeriko. Ay sàcc dogale ko, futti ko, dóor ko ba muy bëgga dee, dem bàyyi ko fa. ");
INSERT INTO wol2010_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Faf ab sarxalkat jaar ca yoon wa, séen nit ka, teggi. ");
INSERT INTO wol2010_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Benn waay it bu soqikoo ci giiru Lewi, aw ca bérab booba, séen waa ja, teggi. ");
INSERT INTO wol2010_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Waaye benn waay bu dëkk Samari bu doon tukki, ñëw ba jege waa ja, gis ko, yërëm ko. ");
INSERT INTO wol2010_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Noonu mu ñëw, sotti diw ak biiñ ca gaañu-gaañu ya, lëmës ko. Gannaaw loolu mu teg ko ci mbaamam, yóbbu ko ci fanaanukaay, di ko topptoo. ");
INSERT INTO wol2010_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Bi bët setee, mu génne ñaari poseti xaalis, jox ko boroom kër ga ne ko: “Nanga topptoo nit kooku. Bés bu ma fi jaaraatee, dinaa la fey, man ci sama bopp, lépp loo ci dolli ci xaalis.”» ");
INSERT INTO wol2010_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Yeesu teg ca ne: «Lu ciy sa xalaat? Kan ci ñett ñooñu moo jëfe ni kuy jëf jëme ci moroomam, ba ñu gisee nit, ka sàcc ya dogale woon?» ");
INSERT INTO wol2010_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Xutbakat ba ne ko: «Xanaa ki ko won yërmandeem.» Yeesu ne ko nag: «Demal tey def ni moom.» ");
INSERT INTO wol2010_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Bi Yeesu ak ay taalibeem nekkee ci yoon wi, mu dugg ci benn dëkk, fekk fa jigéen ju tudd Màrt, ganale ko. ");
INSERT INTO wol2010_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Màrt nag amoon rakk ju tudd Maryaama, ma nga toog ci tànki Boroom bi, di déglu ay kàddoom. ");
INSERT INTO wol2010_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Fekk Màrt jàpp lool ca waañ wa. Noonu mu ñëw ci wetu Yeesu ne ko: «Boroom bi, doo ci wax dara, boo gisee sama rakk ji bàyyi ma ak liggéey bi yépp? Ne ko mu jàpple ma.» ");
INSERT INTO wol2010_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Boroom bi ne ko: «Màrt, Màrt, yu baree ngi fees sa xol, nga am ay téq-téq ndax loolu. ");
INSERT INTO wol2010_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Moona de, lenn rekk a am solo. Maryaama dafa tànn cér bi gën, te kenn du ko nangu ci moom.» ");
INSERT INTO wol2010_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Am bés Yeesu di ñaan ci benn bérab. Bi mu noppee, kenn ci taalibeem yi ne ko: «Boroom bi, jàngal nu, nan lanu wara ñaane, ni ko Yaxya jàngle ay taalibeem.» ");
INSERT INTO wol2010_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Yeesu ne leen: «Bu ngeen dee ñaan, nangeen ne: Baay, yal na sa tur di lu ñu sellal, yal na sa nguur ñëw. ");
INSERT INTO wol2010_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Yal nanga nu may bés bu nekk lu nu dunde. ");
INSERT INTO wol2010_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Yal nanga nu baal sunuy bàkkaar, ndaxte nun itam danuy baal ñépp ñi nu tooñ. Yàlla boo nu teg ci yoonu nattu.» ");
INSERT INTO wol2010_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Yeesu teg ca ne leen: «Mi ngi mel ni, nga dem seeti sa xarit ci xaaju guddi ne ko: “Xarit, lebal ma ñetti mburu. ");
INSERT INTO wol2010_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","Dafa am sama xarit bu ma ganesi, te awma dara lu ma ko jox.” ");
INSERT INTO wol2010_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","«Waaye kooku nekk ci biir néegam, dina ko ne: “Bu ma lakkal, tëj naa bunt bi ba noppi te tëdd naa maak sama njaboot; manumaa jóg di la jox dara.” ");
INSERT INTO wol2010_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Maa ngi leen koy wax, su jógul jox ko li muy laaj ndax li ñu xaritoo it, ndax la kee ñàkk jom dina tax mu jox ko lépp li mu soxla. ");
INSERT INTO wol2010_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Moo tax ma ne, ñaanleen, ñu may leen; seetleen, te dingeen gis; fëggleen, ñu ubbil leen. ");
INSERT INTO wol2010_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Ndaxte képp kuy ñaan, dinga am; kuy seet, dinga gis; kuy fëgg, ñu ubbil la. ");
INSERT INTO wol2010_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Bu la sa doom ñaanee jën, yaw miy baayam, ndax dinga ko baña jox jën, jox ko jaan? ");
INSERT INTO wol2010_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Walla mu ñaan la nen, nga jox ko jiit? ");
INSERT INTO wol2010_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Ndegam yéen ñi bon yéena mana jox seeni gone lu baax, astamaak Baay bi nekk ci kaw dina jox Xel mu Sell mi ñi ko koy ñaan!» ");
INSERT INTO wol2010_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Am bés Yeesu dàq rab wu luu. Naka la rab wa génn, luu ba daldi wax, ba mbooloo may yéemu. ");
INSERT INTO wol2010_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Waaye am ca mbooloo ma ay nit, ñu doon wax naan: «Ci kàttanu Beelsebul, buuru rab yi, lay dàqe rab yi.» ");
INSERT INTO wol2010_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Am ñeneen ñu fexe koo fiir, ba laaj ko kéemaan gu jóge ci asamaan tey firndeel yónnentam. ");
INSERT INTO wol2010_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Waaye Yeesu xam seen xalaat ne leen: «Réew mu xeex boppam tas, kër gu xeex boppam gent. ");
INSERT INTO wol2010_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Te it bu Seytaane xeexee boppam, naka la nguuram di mana yàgge? Damay wax loolu, ndaxte nee ngeen, damay dàq rab jaarale ko ci kàttanu Beelsebul. ");
INSERT INTO wol2010_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Te it bu fekkee ne man damay dàq ay rab ci kàttanu Beelsebul, seeni taalibe nag ci gan kàttan lañu leen di dàqe? Kon ñoo leen di àtte. ");
INSERT INTO wol2010_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Waaye bu fekkee ne ci baaraamu Yàlla laay dàqe rab, kon nguuru Yàlla agsi na ba ci yéen. ");
INSERT INTO wol2010_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","«Su nit ku bare doole gànnaayoo, di wottu këram, alalam dina raw. ");
INSERT INTO wol2010_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Waaye bu ku ko ëpp doole ñëwee, daan ko, dafay nangu gànnaay ya mu yaakaaroon, ba noppi séddale alal ja. ");
INSERT INTO wol2010_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Ku farul ak man, yaa ngi may xeex, ku dajalewul ak man, yaa ngi tasaare. ");
INSERT INTO wol2010_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","«Boo xamee ne rab, wa jàppoon nit, génn na ci moom, day wër ay bérab yu wow, di wut fu mu noppaloo, waaye du ko gis. Noonu da naan: “Naa dellu ca sama kër, ga ma jóge.” ");
INSERT INTO wol2010_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Bu ñëwee nag, mu fekk këram, ñu bale ko, defar ko ba lépp jekk. ");
INSERT INTO wol2010_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Bu ko gisee nag, mu dem wooyi yeneen juróom ñaari rab yu ko gëna soxor. Ñu dugg, sanc fa; ba tax mujug nit kooku mooy yées njàlbéenam.» ");
INSERT INTO wol2010_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Bi Yeesu di wax loolu, jenn jigéen yékkati baatam ca biir mbooloo ma ne: «Céy jigéen ji la ëmb te nàmpal la moo barkeel!» ");
INSERT INTO wol2010_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Waaye Yeesu ne ko: «Neel kay, ki barkeel mooy kiy déglu kàddug Yàlla te di ko topp.» ");
INSERT INTO wol2010_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Naka la mbooloo may gëna takku, Yeesu ne: «Niti jamono jii dañoo bon. Ñu ngi laaj firnde, waaye duñu jot genn firnde gu dul firndeg Yunus. ");
INSERT INTO wol2010_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Ndaxte ni Yunus nekke woon firnde ci waa dëkku Niniw, noonu la Doomu nit kiy nekke firnde ci niti jamono jii. ");
INSERT INTO wol2010_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Keroog bés pénc buur bu jigéen, ba dëkkoon ca sudd, dina jógandoo ak niti jamono jii, yey leen; ndaxte dafa jóge ca catul àddina, ngir déglu xam-xamu Suleymaan, te ku sut Suleymaan a ngi fi. ");
INSERT INTO wol2010_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Te it ca bés pénc, waa dëkku Niniw dinañu jógandoo ak niti jamono jii, yey leen, ndaxte bi leen Yunus waaree, tuub nañu seeni bàkkaar, te ku sut Yunus a ngi fii. ");
INSERT INTO wol2010_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","«Kenn du taal làmp, ba noppi di ko dugal cig kàmb, walla di ci këpp leget. Daf koy wékk, ngir mu leeral ñiy dugg. ");
INSERT INTO wol2010_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Bët mooy làmpu yaram. Bu sa bët wéree, kon sa yaram wépp leer. Waaye bu sa bët woppee, kon sa yaram wépp lëndëm. ");
INSERT INTO wol2010_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Moytul ndax leer gi nekk ci yaw du lëndëm. ");
INSERT INTO wol2010_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Kon bu sa yaram wépp nekkee ci leer te amul genn wet gu laal ci lëndëm, dina leer nàññ, mel ni leeraayu làmp ne ràyy ci sa kaw.» ");
INSERT INTO wol2010_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Bi Yeesu waxee ba noppi, benn Farisen wax ko, mu ñëw lekke këram. Yeesu dugg ca kër ga, toog ca lekkukaay ba. ");
INSERT INTO wol2010_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Farisen bi nag daldi jaaxle, bi mu gisee ne Yeesu raxasuwul, laata muy lekk. ");
INSERT INTO wol2010_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Noonu Boroom bi ne ko: «Waaw, yéen Farisen yi, yéena ngi setal bitib kaas bi ak ndab li, waaye ci biir dangeena fees ak càcc ak mbon! ");
INSERT INTO wol2010_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Yéena ñàkk xel! Xanaa du ki defar biti moo defar biir itam? ");
INSERT INTO wol2010_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Sarxeleen li nekk ci biir te seen lépp dina sell. ");
INSERT INTO wol2010_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","Yéen Farisen yi dingeen torox! Ndaxte yéena ngi sàkk asaka ci naana ak ru ak léjum bu nekk, waaye sàggane ngeen njubte ak mbëggeel ci Yàlla. Loolu ngeen wara def, waxuma nag ngeen sàggane la ca des. ");
INSERT INTO wol2010_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","Yéen Farisen yi, dingeen torox! Ndaxte ca jàngu ya, toogu ya féete kanam ngeen di taamu te bëgg ñépp di leen nuyoo ñaari loxo ca pénc ma. ");
INSERT INTO wol2010_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Dingeen torox, ndaxte dangeena mel ni ay bàmmeel yu raaf, ba nit ñi di ci dox te teyuñu ko.» ");
INSERT INTO wol2010_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Kenn ci xutbakat yi ne ca tonn ne: «Kilifa gi, boo waxee loolu, yaa ngi nuy xas, nun itam.» ");
INSERT INTO wol2010_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Noonu Yeesu neeti leen: «Yéen itam xutbakat yi, dingeen torox! Ndaxte dangeen di sëf nit ñi say yu diis, waaye dungeen nangoo laal sëf bi sax ak seen cati baaraam. ");
INSERT INTO wol2010_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Dingeen torox, ndaxte yéena ngi tabax xabruy yonent, yi seeni maam reyoon. ");
INSERT INTO wol2010_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Dangeen di seede noonu ne ànd ngeen ak li seen maam defoon, ndaxte ñoo rey yonent yi, yéen ngeen tabax xabru yi. ");
INSERT INTO wol2010_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Looloo tax Yàlla mi xam lépp ne: “Dinaa leen yónnee ay yonent ak ay ndaw. Ñenn ñi dinañu leen fitnaal, rey leen.” ");
INSERT INTO wol2010_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Kon nag Yàlla dina mbugal niti jamono jii ndax dereti yonent yi ñu tuur, ba àddina sosoo ak léegi, ");
INSERT INTO wol2010_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","la dale ca Abel ba ci Sakari, moom mi ñu rey ci diggante sarxalukaay bi ak bérab bu sell bi. Waaw, maa ngi leen koy wax, Yàlla dina mbugal niti jamono jii ndax loolu. ");
INSERT INTO wol2010_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","Yéen xutbakat yi, dingeen torox, ndaxte yéena yóbbu caabiy xam-xam; dugguleen ci, te ku ci bëgga dugg, ngeen tere ko ko.» ");
INSERT INTO wol2010_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Bi Yeesu génnee bérab boobu, Farisen ya ak xutbakat ya ëmbal ko mer te di ko seetlu ci fànn gu nekk, ");
INSERT INTO wol2010_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","di ko yeeru, bëgga këf waxam bu awul yoon. ");
INSERT INTO wol2010_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Gannaaw loolu, naka la mbooloo ma dajaloo ba mat ay junniy junniy nit, di tancante, Yeesu tàmbalee wax jëmale ca taalibeem ya ne leen: «Moytuleen lawiiru Farisen ya, li di naaféq. ");
INSERT INTO wol2010_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Amul dara lu nëbbu lu ñu warula biral, mbaa lu kumpa lu ñu warula siiwal. ");
INSERT INTO wol2010_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Looloo tax lu ngeen wax ci biir lëndëm, dees na ko dégg ci leer. Lu ngeen déey nit ci biir néeg, dees na ko yégle ci kaw taax yi. ");
INSERT INTO wol2010_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","«Maa ngi leen koy wax, samay xarit, buleen ragal ñu mana rey yaram, ba noppi dootuñu mana def dara. ");
INSERT INTO wol2010_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Dinaa leen wax nag ki ngeen wara ragal: ragal-leen ki nga xam ne bu reyee ba noppi, am sañ-sañu sànni ca sawara. Waaw, maa ngi leen koy wax, ragal-leen kooku. ");
INSERT INTO wol2010_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Juróomi picci ramatu, ndax duñu ko jaay ci ñaari dërëm? Moona Yàlla fàttewul benn ci ñoom. ");
INSERT INTO wol2010_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Seen kawari bopp sax waññees na leen. Kon buleen ragal dara, yéena gën ndiiraanu ramatu. ");
INSERT INTO wol2010_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","«Te maa ngi leen koy wax, képp ku ma nangu ci kanam nit ñi, Doomu nit ki dina la nangu ci kanam malaakay Yàlla yi. ");
INSERT INTO wol2010_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Waaye ku ma gàntu ci kanam nit ñi, dinañu la gàntu ci kanam malaakay Yàlla yi. ");
INSERT INTO wol2010_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Ku sosal Doomu nit ki, dinañu la baal, waaye kuy sosal Xel mu Sell mi, duñu la ko baal. ");
INSERT INTO wol2010_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","«Bu ñu leen yóbboo ca jàngu ya, ca kanam kilifa ya ak àttekat ya, buleen am xel ñaar ci li ngeen wara tontu ak nan ngeen wara tontoo, walla lu ngeen wara wax, ");
INSERT INTO wol2010_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","ndaxte Xel mu Sell mi dina leen xamal ca waxtu woowa li ngeen wara wax.» ");
INSERT INTO wol2010_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Am ca mbooloo ma ku ne Yeesu: «Kilifa gi, joxal ndigal sama mag, mu sédd ma ci sunu ndono.» ");
INSERT INTO wol2010_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Yeesu ne ko: «Sama waay, kan moo ma fal àttekat ci seen kaw, walla mu teg ma fi, ma di leen séddaleel seen alal?» ");
INSERT INTO wol2010_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Noonu mu ne leen ñoom ñépp: «Moytuleen bëgge, ndaxte bakkanu nit ajuwul ci alalam, ak lu mu baree bare.» ");
INSERT INTO wol2010_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Noonu mu dégtal leen wii léeb ne: «Dafa amoon waa ju bare alal, te ay toolam nangu lool, ");
INSERT INTO wol2010_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","muy werante ci xelam naan: “Nu ma wara def? Ndaxte amatuma fu ma dajale sama ngóob mi.” ");
INSERT INTO wol2010_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Noonu mu ne: “Nii laay def: daaneel sama sàq yi, defaraat yu gëna réy, ba man cee dajale sama dugub ji ak sama am-am bépp. ");
INSERT INTO wol2010_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Te dinaa kañ sama bopp ne: ‘Yaw mii, am nga alal ju bare ju mana dem ay ati at; noppalal sa yaram, di lekk, di naan, tey bég.’ ” ");
INSERT INTO wol2010_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Waaye Yàlla ne ko: “Ñàkk xel! Guddig tey, dees na jël sa bakkan. Kon li nga dajale lépp, ku koy moom?” ");
INSERT INTO wol2010_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","«Kiy dajale alal ngir boppam nag te amul dara ca kanam Yàlla, lu mel nii moo lay dal.» ");
INSERT INTO wol2010_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Noonu Yeesu daldi ne taalibeem yi: «Loolu moo tax maa ngi leen koy wax, buleen seen bakkan jaaxal, ci lu ngeen wara lekk. Buleen jaaxle it ngir seen yaram ci lu ngeen wara sol, ");
INSERT INTO wol2010_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","ndaxte bakkan moo gën lekk, te yaram a gën koddaay. ");
INSERT INTO wol2010_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Seetleen baaxoñ yi: duñu ji, duñu góob, amuñu dencukaay, amuñu sàq, teewul Yàllaa ngi leen di dundal. Céy ni ngeen ëppe maana picc yi! ");
INSERT INTO wol2010_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Ana kan ci yéen ci kaw njaaxleem, moo mana yokk waxtu ci àppam? ");
INSERT INTO wol2010_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Su fekkee lu tuuti loolu rekk manuleen koo def, kon lu tax ngeen di jaaxle ci li ci des? ");
INSERT INTO wol2010_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","«Seetleen ni tóor-tóori ñax mi di saxe. Duñu liggéey, duñu ëcc, waaye maa ngi leen di wax ne Suleymaan sax ci ndamam soluwul woon ni benn ci ñoom. ");
INSERT INTO wol2010_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Yéen ñi néew ngëm! Bu Yàlla woddee nii ñaxum tool yi, miy sax tey, te bu subaa ñu def ko ci taal bi, ndax du leen gëna wodd? ");
INSERT INTO wol2010_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Buleen di wut lu ngeen di lekk walla lu ngeen di naan; te buleen ci jaaxle. ");
INSERT INTO wol2010_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Ndaxte loolu lépp, ñi xamul Yàlla ñoo koy wut. Te seen Baay xam na ne soxla ngeen ko. ");
INSERT INTO wol2010_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Waaye wutleen nguuram, te loolu lépp dina leen ko ci dollil. ");
INSERT INTO wol2010_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","«Buleen ragal dara, yéen coggal ju ndaw ji, ndaxte dafa soob seen Baay, mu jagleel leen nguuram. ");
INSERT INTO wol2010_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Jaayleen seen alal, sarxe ko, ngir sàkku ay mbuusi xaalis yu dul bënn, maanaam alal ju dul jeex ca laaxira; foofa sàcc du ko jege te max du ko yàq. ");
INSERT INTO wol2010_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Ndaxte fu sa alal nekk, fa la sa xol nekk itam. ");
INSERT INTO wol2010_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","«Takkuleen bu dëgër te bàyyi làmp yi tàkk. ");
INSERT INTO wol2010_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Mel-leen ni ay surga yuy xaar seen njaatige buy jóge ca céet ga, ndax bu fëggee bunt ba, ñu ubbil ko ca saa sa. ");
INSERT INTO wol2010_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Surga yooyee seen njaatige fekkul ñuy nelaw, ba mu agsee, ñoo gëna yeyoo ngërëm. Ci dëgg maa ngi leen koy wax, njaatige bi dina sol yérey waañ, wax leen ñu toog lekk, ba noppi indil leen ñam wi. ");
INSERT INTO wol2010_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Su fekkee seen njaatige ci xaaju guddi lay ñëw sax, walla bu suuf seddee, te fekk leen noonu, surga yooyu ñoo gëna yeyoo ngërëm. ");
INSERT INTO wol2010_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Waaye xamleen lii: bu boroom kër gi xamoon ban waxtu la sàcc bi di ñëw, du ko bàyyi, mu toj këram. ");
INSERT INTO wol2010_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Yéen itam taxawleen jonn, ndaxte Doomu nit ki dina ñëw ci waxtu wu ngeen ko séenuwul.» ");
INSERT INTO wol2010_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Piyeer ne Yeesu: «Boroom bi, ndax dangay dégtal léeb wii ngir nun rekk walla ngir mbooloo mépp?» ");
INSERT INTO wol2010_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Boroom bi ne ko: «Kan moo nekk surga bu takku te teey, bu njaatigeem teg ci waa kër gi, ngir mu leen di dundal ci jamono ji? ");
INSERT INTO wol2010_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Bu njaatigeem ñëwee te gis mu def noonu, surga boobu dina am ngërëm. ");
INSERT INTO wol2010_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Ci dëgg maa ngi leen koy wax, njaatige bi dina ko teg ci alalam jépp. ");
INSERT INTO wol2010_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Waaye su fekkee surga ba da ne ci xelam: “Sama njaatige day yéexa ñëw,” ba tax mu tàmbalee dóor surga ya ca des ak mbindaan ya, di lekk te di naan, di màndi, ");
INSERT INTO wol2010_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","kon njaatige ba dina ñëw ci bés bu mu ko séenuwul ak waxtu wu mu xamul. Dina ko dóor ay dóor yu metti, jox ko añub ñi gëmul Yàlla. ");
INSERT INTO wol2010_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","«Surga bi xam bëgg-bëggu njaatigeem, te waajul mbaa mu takku def ko, dinañu ko dóor dóor yu metti. ");
INSERT INTO wol2010_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Waaye surga bi xamul bëgg-bëggu njaatigeem, te def lu yelloo ay dóor, dinañu ko dóor dóor yu néew. Ku ñu jox lu bare dees na la feyeeku lu bare. Ku ñu dénk lu bare, dees na la laajaat lu ko ëpp. ");
INSERT INTO wol2010_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","«Damaa ñëw ngir indi sawara si ci àddina, te bëgg naa xaat taal bi tàkk. ");
INSERT INTO wol2010_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Fàww ñu sóob ma ci metit, te ba looluy mat, duma noppalu. ");
INSERT INTO wol2010_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Ndax dangeena xalaat ne damaa ñëw ngir indi jàmm ci àddina? Déedéet. Maa ngi leen koy wax, damaa ñëw ngir indi féewaloo. ");
INSERT INTO wol2010_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Gannaaw-si-tey, bu juróomi nit bokkee genn kër, dinañu féewaloo. Ñett dinañu féewaloo ak ñaar ñi ci des, ñaar ñi féewaloo ak ñett ñooñu. ");
INSERT INTO wol2010_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Baay dina féewaloo ak doom, doom ak baayam. Ndey dina féewaloo ak doomam ju jigéen; doom ju jigéen ji ak ndeyam. Goro dina féewaloo ak soxnas doomam; soxnas nit ak goroom.» ");
INSERT INTO wol2010_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Yeesu neeti mbooloo ma: «Bu ngeen gisee mu xiin ci sowu, dangeen naan ca saa sa: “Dina taw,” te mooy am. ");
INSERT INTO wol2010_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Te bu ngeen yégee ngelaw liy uppe sudd, ngeen ne: “Dina tàng tàngaay wu metti,” te mooy am. ");
INSERT INTO wol2010_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Naaféq yi ngeen doon! Man ngeena ràññee melow asamaan ak suuf, waaye lu tax manuleena ràññee li jamonoy léegi ji di tekki? ");
INSERT INTO wol2010_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","«Lu tax it dungeen àtteel seen bopp liy jëf ju jub? ");
INSERT INTO wol2010_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Bu la nit jiiñee dara, ba ngeen ànd di dem ca àttekat ba, nanga fexee juboo ak moom ci yoon wi. Lu ko moy, dina la yóbbu ci yoon, yoon jébbal la ca loxoy alkaati ba, mu tëj la. ");
INSERT INTO wol2010_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Maa ngi la koy wax, doo génn foofa mukk te feyuloo fiftin bi ci mujj.» ");
INSERT INTO wol2010_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Ca jamono jooju ay nit ñëw ca Yeesu, nettali mbirum waa Galile, ya Pilaat reylu woon, jaxase seen deret ak dereti mala, yi ñu rendi woon, jébbal leen Yàlla. ");
INSERT INTO wol2010_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Mu ne leen: «Mbaa du dangeena xalaat ne, waa Galile yooyu dañoo gëna nekk bàkkaarkat ña ca des, ndax coono bi ñu daj? ");
INSERT INTO wol2010_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Maa ngi leen di wax ne du dëgg. Waaye su ngeen tuubul seeni bàkkaar, dingeen sànku noonu, yéen ñépp itam. ");
INSERT INTO wol2010_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Te fukki nit ak juróom ñett ñooñu dee, bi taaxum kaw ma ca goxu Silowe daanoo ci seen kaw, ndax dangeena yaakaar ne ñoo gëna nekk ay tooñkat ñeneen ñi dëkk Yerusalem yépp? ");
INSERT INTO wol2010_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Maa ngi leen di wax ne du dëgg. Waaye su ngeen tuubul seeni bàkkaar, dingeen sànku noonu, yéen ñépp itam.» ");
INSERT INTO wol2010_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Noonu mu daldi leen wax léeb wii: «Nit amoon na ci toolam garab gu ñu naan figg. Benn bés mu ñëw di ko raas-si, fekku fa benn doom. ");
INSERT INTO wol2010_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Noonu mu ne surga ba: “Ñetti at a ngii may ñëw di raas-si garab gii te duma ci fekk dara. Gor ko. Lu tax muy xatal tool bi?” ");
INSERT INTO wol2010_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Surga ba ne ko: “Sang bi, bàyyiwaat ko fi at mii. Dinaa wàqi taat wi, def ci tos. ");
INSERT INTO wol2010_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Xëy na dina meññi. Bu ko deful, nga gor ko.”» ");
INSERT INTO wol2010_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Benn bésub noflaay Yeesoo ngi doon jàngle ci ab jàngu. ");
INSERT INTO wol2010_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Amoon na fa jigéen ju rab jàppoon, ba feebarloo ko lu wara mat fukki at ak juróom ñett; dafa xuuge woon te manul woona siggi dara. ");
INSERT INTO wol2010_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Bi ko Yeesu gisee, mu woo ko ne ko: «Soxna si, sa feebar deñ na.» ");
INSERT INTO wol2010_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Noonu mu teg ko ay loxoom, soxna sa siggi ca saa sa, di màggal Yàlla. ");
INSERT INTO wol2010_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Waaye njiitu jàngu ba mer, ndax li Yeesu fajoon nit ca bésub noflaay ba, mu ne mbooloo ma: «Am na juróom benni fan yu nit ñi wara liggéey. Kon war ngeena ñëw faju ci bés yooyu, waaye du ci bésub noflaay bi.» ");
INSERT INTO wol2010_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Boroom bi ne ko: «Naaféq yi! Ndax bésub noflaay bi, kenn ku nekk ci yéen du yiwee ca gétt ga yëkkam walla mbaamam ngir wëggi ko? ");
INSERT INTO wol2010_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Jigéen jii nag bokk ci askanu Ibraayma te Seytaane tënk ko fukki at ak juróom ñett, ndax kenn waru koo yiwi ci bésub noflaay bi?» ");
INSERT INTO wol2010_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Naka la wax loolu, noonam yépp daldi rus, waaye mbooloo mi di bég ci jëf yu yéeme, yi mu doon def yépp. ");
INSERT INTO wol2010_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Noonu Yeesu neeti: «Lan la nguuru Yàlla di nirool? Lan laa ko mana méngaleel? ");
INSERT INTO wol2010_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Mi ngi mel ni doomu fuddën gu nit jël, ji ko ci toolam. Mu sax, nekk garab, ba picci asamaan ñëw, tàgg ciy caram.» ");
INSERT INTO wol2010_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Mu neeti: «Lan laa mana méngaleek nguuru Yàlla? ");
INSERT INTO wol2010_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Mi ngi mel ni lawiir bu jigéen jël, jaxase ko ak ñetti andaari fariñ, ba kera tooyal bépp di funki.» ");
INSERT INTO wol2010_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Yeesoo ngi doon jaar ci ay dëkk yu mag ak yu ndaw, di jàngle te jublu Yerusalem. ");
INSERT INTO wol2010_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Am ku ko ne: «Boroom bi, ndax ñiy mucc ñu néew lay doon?» Yeesu ne leen: ");
INSERT INTO wol2010_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","«Defleen seen kem kàttan, ngir dugg ci bunt bu xat bi, ndaxte maa ngi leen koy wax, ñu bare dinañu jéema dugg, waaye duñu ko man. ");
INSERT INTO wol2010_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Jamono dina ñëw, ju boroom kër gi di jóg, tëj buntam. Dingeen nekk ci biti di fëgg naan: “Boroom bi, ubbil nu!” Mu ne leen: “Xawma fu ngeen bokk.” ");
INSERT INTO wol2010_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Bu ko defee ngeen naan: “Noo doon bokk di lekk ak a naan, te jàngle nga ci sunuy pénc.” ");
INSERT INTO wol2010_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Mu ne leen: “Nee naa leen xawma fu ngeen bokk. Yéen ñépp soreleen ma, defkati lu bon yi!” ");
INSERT INTO wol2010_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Foofa dingeen jooy, di yéyu, bu ngeen gisee seeni maam Ibraayma, Isaaxa, Yanqóoba ak yonent yépp ci nguuru Yàlla, te ñu dàq leen ca biti. ");
INSERT INTO wol2010_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Ay nit dinañu jóge penku ak sowu, nor ak sudd, ñëw, bokk lekk ci ñam, yi Yàlla di joxe ci nguuram. ");
INSERT INTO wol2010_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Noonu ñenn ci ñi mujj ñooy jiituji; te ci ñi jiitu, ñooy mujji.» ");
INSERT INTO wol2010_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Ca jamono jooja ay Farisen ñëw ca Yeesu ne ko: «Jógeel fii, dem feneen, ndaxte Erodd a ngi lay wuta rey.» ");
INSERT INTO wol2010_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Noonu mu ne leen: «Demleen ne bukki boobu ne ko: “Xoolal, maa ngi dàq rab yi tey wéral nit ñi tey ak suba. Ca ñetteelu fan ba, ma àgg fa ma Yàlla jëmale.” ");
INSERT INTO wol2010_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Waaye fàww ma dox sama itte tey, suba ak gannaaw suba, ndaxte wareesula reye ab yonent feneen fu dul Yerusalem. ");
INSERT INTO wol2010_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","«Yerusalem, Yerusalem, yaw miy rey yonent yi, tey sànni ay doj ndaw yi, ba ñu dee, aka maa bëggoona dajale say doom, ni ginaar di uufe ay cuujam te nanguwuleen! ");
INSERT INTO wol2010_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Kon nag Yàlla dina bërgël seen kër. Te maa ngi leen koy wax, dungeen ma gisati, ba kera ngeen ne: “Yaw miy ñëw ci turu Boroom bi, ku barkeel nga!”» ");
INSERT INTO wol2010_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Benn bésub noflaay Yeesu dem ci këru benn kilifag Farisen yi, ngir lekke fa. Nit ñaa ngi ko doon xool bu baax. ");
INSERT INTO wol2010_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Faf am ca kanamam nit ku feebaroon, ay tànkam newi. ");
INSERT INTO wol2010_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Yeesu yékkati baatam, ne xutbakat ya ak Farisen ya: «Ndax jaadu na, nu faj ci bésub noflaay bi?» ");
INSERT INTO wol2010_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Waaye ñépp ne cell. Yeesu daldi laal jarag ja, faj ko, ba noppi ne ko mu ñibbi. ");
INSERT INTO wol2010_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Gannaaw loolu mu ne leen: «Ku sa doom walla sa yëkk daanu ci teen, ndax doo dem génneji ko ca saa sa, fekk sax bésub noflaay la?» ");
INSERT INTO wol2010_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Amuñu woon dara lu ñu ciy teg. ");
INSERT INTO wol2010_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Yeesu gis ni gan yi doon tànne toogu yu yiw yi, mu daldi leen wax léeb wii: ");
INSERT INTO wol2010_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","«Bu ñu la wooyee ci xewu céet, bul jël toogu bu yiw. Man na am woo nañu it nit ku la ëpp daraja. ");
INSERT INTO wol2010_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Kon ki leen woo yéen ñaar ñépp man na ñëw ci yaw ne la: “Joxal toogu bi nit kii.” Noonu dinga rusa dem ca toogu bu gannaawe ba. ");
INSERT INTO wol2010_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Waaye bu ñu la wooyee, demal ca toogu bu gannaawe ba. Bu ko defee ki la woo, bu agsee ne la: “Sama xarit, àggal ca kaw.” Loolu dina la sagal ci ñi nga toogandool ci lekkukaay bi. ");
INSERT INTO wol2010_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Ndaxte képp kuy yékkatiku dees na la suufeel, te kuy suufeelu, ñu yékkati la.» ");
INSERT INTO wol2010_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Noonu Yeesu ne ki ko woo woon lekk: «Boo dee woote añ walla reer, bul woo rekk say xarit, say doomi ndey, say bokk, walla say dëkkandoo yu am alal. Lu ko moy ñooñu itam dinañu la woo, fey la bor bi. ");
INSERT INTO wol2010_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Waaye boo dee woote lekk, wool néew doole yi, làggi yi, lafañ yi ak gumba yi. ");
INSERT INTO wol2010_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Soo ko defee, dinga barkeel, ndaxte duñu la ko mana fey, waaye dinga jot sag pey, bés bi ñi jub di dekki.» ");
INSERT INTO wol2010_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Bi mu déggee wax yooyu, kenn ca gan ya ne Yeesu: «Kiy lekk ci ñam, yi Yàlla di joxe ci nguuram, barkeel nga!» ");
INSERT INTO wol2010_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Yeesu ne ko: «Dafa amoon nit ku togglu ay ñam, woo ay nit ñu bare. ");
INSERT INTO wol2010_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Bi waxtuw lekk jotee mu yónni surga ca ña muy ganale, fàttali leen: “Man ngeena ñëw, ndaxte lépp sotti na léegi.” ");
INSERT INTO wol2010_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","«Waaye ñu tàmbali di jégglu ci ngan gi ñoom ñépp. Ku jëkk ka ne ko: “Damaa jënd tool léegi, te fàww ma dem seeti ko. Maa ngi lay ñaan, nga jéggal ma.” ");
INSERT INTO wol2010_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Keneen ne: “Damaa jënd léegi fukki yëkk, te damay dem nii, jéem leena beyloo ba xam. Maa ngi lay ñaan, nga jéggal ma.” ");
INSERT INTO wol2010_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Keneen ne ko: “Damay sooga takk jabar, looloo tax duma mana ñëw.” ");
INSERT INTO wol2010_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","«Surga ba dellu ca njaatigeem nettali ko loolu lépp. Noonu boroom kër ga mer, daldi ne surga ba: “Demal gaaw ca pénc ya ak ca mbedd ya ca dëkk ba, te indil ma fii néew doole yi, ñu làggi ñi, gumba yi ak lafañ yi.” ");
INSERT INTO wol2010_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","«Surga ba ñëwaat ne ko: “Sang bi, def naa li nga ma sant, waaye bérab bi feesul.” ");
INSERT INTO wol2010_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Noonu njaatige ba ne ko: “Génnal dëkk bi te dem ca yoon ya ak ca tool ya, xiir nit ñi, ñu duggsi, ngir sama kër fees. ");
INSERT INTO wol2010_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Maa ngi leen koy wax, ci ñi ma woo woon ci sama reer bi, kenn du ci ñam.”» ");
INSERT INTO wol2010_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Am mbooloo yu réy yu toppoon ci Yeesu, ba muy dem ca yoon wa. Mu geestu ne leen: ");
INSERT INTO wol2010_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","«Képp ku ñëw ci man te gënalu ma ko baayam, yaayam, soxnaam, ay doomam, ay magam ak ay rakkam, walla sax bakkanam, du mana nekk sama taalibe. ");
INSERT INTO wol2010_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Képp koo xam ne nanguwuloo ñàkk sa bakkan, ba mel ni ku ñu daaj ci bant, te nga topp ma, doo mana nekk sama taalibe. ");
INSERT INTO wol2010_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Su kenn ci yéen bëggee tabax taaxum kaw, ndax du jëkka toog, xalaat ñaata la ko wara dikke, ngir seet ba xam ndax am na xaalis bu mana àggale liggéey bi? ");
INSERT INTO wol2010_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Lu ko moy, su yékkatee fondamaa bi te manu koo àggale, ñi koy gis dinañu ko ñaawal, naan ko: ");
INSERT INTO wol2010_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","“Waa jii dafa tàmbalee tabax, waaye manu koo àggale.” ");
INSERT INTO wol2010_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Walla boog ban buur mooy dugg ci xare ak beneen buur te jëkkula toog, seet ba xam moom ak fukki junniy xarekat man na xeex ak kiy ñëw ak ñaar fukki junniy xarekat? ");
INSERT INTO wol2010_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Su ko manul, dafay yónni ndaw ca beneen buur ba, fi ak ma ngay sore, ngir ñu juboo. ");
INSERT INTO wol2010_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Naka noonu itam ku nekk ci yéen, bu dëdduwul li mu am lépp, du mana nekk sama taalibe. ");
INSERT INTO wol2010_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","«Xam ngeen nag ne xorom lu baax la, waaye bu sàppee, nan lañu koy delloo cafkaam? ");
INSERT INTO wol2010_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Du jariñ suuf, te du nekk tos. Dañu koy sànni ca biti. Déglul bu baax, yaw mi am ay nopp.» ");
INSERT INTO wol2010_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Ay juutikat ak ay boroom bàkkaar daan jegesi Yeesu ngir déglu ko. ");
INSERT INTO wol2010_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Farisen ya ak xutbakat ya di ñurumtu naan: «Waa jii mi ngi nangoo nekk ak ay boroom bàkkaar ak a lekkandook ñoom!» ");
INSERT INTO wol2010_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Noonu Yeesu daldi leen wax léeb wii ne leen: ");
INSERT INTO wol2010_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","«Kan ci yéen soo amoon téeméeri xar, te benn réer ci, nooy def? Ndax doo bàyyi ca parlukaay ba juróom ñeent fukki xar ya ak juróom ñeent, toppi ma réer, ba gis ko? ");
INSERT INTO wol2010_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Te boo ko gisee, dinga ko gàddu ak bànneex, yóbbu ko kër ga. ");
INSERT INTO wol2010_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Boo àggee ca kër ga, dinga woo say xarit ak say dëkkandoo ne leen: “Kaayleen bànneexu ak man, ndaxte gis naa sama xar ma réeroon.” ");
INSERT INTO wol2010_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","«Maa ngi leen di wax lii: ci noonule, dina am mbég ci asamaan, bu benn bàkkaarkat tuubee ay bàkkaaram. Te mbég moomu mooy ëpp mbég, mi fay am, ngir juróom ñeent fukk ak juróom ñeent ñu jub, te soxlawuñoo tuub seeni bàkkaar. ");
INSERT INTO wol2010_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","«Te it bu jigéen dencoon fukki libidoor, benn réer ca, nu muy def? Ndax du taal ab làmp, bale kër ga, seet fu nekk, ba gis ko? ");
INSERT INTO wol2010_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Bu ko gisee, dina woo ay xaritam ak ay dëkkandoom ne leen: “Kaayleen bànneexu ak man, ndaxte gis naa sama alal ja réeroon.” ");
INSERT INTO wol2010_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Maa ngi leen di wax lii: ci noonule la malaakay Yàlla yi di ame mbég ci benn bàkkaarkat bu tuubee ay bàkkaaram.» ");
INSERT INTO wol2010_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Yeesu dellu ne leen: «Dafa amoon góor gu am ñaari doom. ");
INSERT INTO wol2010_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Benn bés caat ma ne baay ba: “Baay, damaa bëggoon, nga jox ma li may wara féetewoo ci ndono li.” Noonu baay ba daldi leen séddale alalam. ");
INSERT INTO wol2010_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Ay fan yu néew gannaaw gi, caat ma fab yëfam yépp, dem ca réew mu sore, yàq fa alalam ci topp nafsoom. ");
INSERT INTO wol2010_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Bi mu sànkee alalam jépp, xiif bu metti dal ca réew ma, mu tàmbalee ñàkk. ");
INSERT INTO wol2010_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Mu dem nag, di liggéeyal ku dëkk ca réew ma, kooku yebal ko ca ay toolam ngir mu sàmm mbaam-xuux ya. ");
INSERT INTO wol2010_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Mu xiif ba bëgga lekk ca ñamu mbaam-xuux ya, ndaxte kenn mayu ko dara. ");
INSERT INTO wol2010_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Mujj xelam délsi, mu ne: “Sama baay am na ay surga yu bare, te dañuy lekk ba suur. Man nag maa ngi fii di bëgga dee ak xiif! ");
INSERT INTO wol2010_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Damay jóg, dem ca sama baay ne ko: ‘Baay, tooñ naa Yàlla, tooñ naa la; ");
INSERT INTO wol2010_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","yeyootumaa nekk sa doom; boole ma ci say surga.’ ” ");
INSERT INTO wol2010_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","«Mu daldi jóg, jëm kër baayam. Waaye bi muy soreendi kër ga, baayam séen ko, yërëm ko, daldi daw laxasu ko, fóon ko. ");
INSERT INTO wol2010_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Doom ja ne ko: “Baay, tooñ naa Yàlla, tooñ naa la; yeyootumaa nekk sa doom.” ");
INSERT INTO wol2010_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Waaye baay ba ne ay surgaam: “Gaawleen indi mbubb, mi gëna rafet, solal ko ko. Te ngeen roof ab jaaro ci loxoom te solal ko ay dàll. ");
INSERT INTO wol2010_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Indileen sëllu wu duuf wa te rey ko, nu lekk te bànneexu; ");
INSERT INTO wol2010_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","ndaxte sama doom jii dafa dee woon te dundaat na, dafa réeroon te feeñ na.” Noonu ñu tàmbalee bànneexu. ");
INSERT INTO wol2010_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","«Fekk booba taaw baa nga woon ca tool ya. Bi mu ñëwee, ba jub kër ga, mu dégg ñuy tëgg, di fecc. ");
INSERT INTO wol2010_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Mu daldi woo kenn ca surga ya nag, laaj ko lu xew. ");
INSERT INTO wol2010_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Mu ne ko: “Sa rakk moo délsi, te sa baay rey na sëllu wu duuf wa, ndaxte ñibsi na ci jàmm.” ");
INSERT INTO wol2010_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","«Ci kaw loolu taaw ba daldi mer, baña dugg ca kër ga. Baayam daldi génn, ngir ñaan ko mu dugg. ");
INSERT INTO wol2010_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Waaye taaw ba wax baayam ne ko: “Seetal ñaata at laa la liggéeyal, mel ni jaam, te masumaa moy sa ndigal, waaye yaw, masuloo ma may sax tef, ngir ma bànneexu, man ak samay xarit. ");
INSERT INTO wol2010_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Waaye bi sa doom jii dikkee, moom mi yàq sa alal ci ndoxaan, reyal nga ko sëllu wu duuf wi.” ");
INSERT INTO wol2010_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Noonu baay bi ne ko: “Sama doom, yaa ngi ak man bés bu nekk, te li ma am lépp, yaa ko moom. ");
INSERT INTO wol2010_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Waaye war nanoo bànneexu te bég, ndaxte sa rakk jii dafa dee woon te dundaat na, dafa réeroon te feeñ na.”» ");
INSERT INTO wol2010_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Yeesu neeti ay taalibeem: «Benn boroom alal moo amoon bëkk-néeg bu ñu jiiñ ne dafay pasar-pasaree alal ji. ");
INSERT INTO wol2010_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Waa ja woo ko ne ko: “Li may dégg ci yaw mooy lan? Leeralal ma ni nga liggéeye ak sama alal, ndaxte dootoo nekkati sama bëkk-néeg.” ");
INSERT INTO wol2010_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","«Bëkk-néeg bi di xalaat naan: “Nu may def nag, segam sama njaatige dafa may dàq ci liggéey bi mu ma joxoon? Dem beyi? Awma kàttanam. Yelwaani? Rus naa ko. ");
INSERT INTO wol2010_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Xam naa ni may def, ba su ma ñàkkee sama liggéey, ay nit fat ma.” ");
INSERT INTO wol2010_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Noonu mu daldi woolu kenn ku nekk ca ña ameeloon njaatigeem bor. Ka jëkka ñëw, mu ne ko: “Ñaata nga ameel sama njaatige?” ");
INSERT INTO wol2010_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Mu ne ko: “Téeméeri bidoŋi diwu oliw.” Bëkk-néeg ba ne ko: “Sa kayit a ngii. Toogal fii gaaw te bind juróom fukk.” ");
INSERT INTO wol2010_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Mu neeti keneen: “Yaw nag, ñaata nga ko ameel?” Mu ne ko: “Téeméeri saakuy pepp.” Bëkk-néeg ba ne ko: “Sa kayit a ngii. Bindal juróom ñett fukk.” ");
INSERT INTO wol2010_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Njaatige ba nag daldi naw ni bëkk-néeg bu njublaŋ boobu muuse woon. Ndaxte ñi bokk ci àddina ñoo gëna muus ci li ñu jote ci seen diggante ak seen moroom, ba raw ñi bokk ci leeru Yàlla.» ");
INSERT INTO wol2010_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Yeesu teg ca ne: «Maa ngi leen di wax lii: sàkkuleen ay xarit jaare ko ci alalu àddina, ngir bu alal nekkatul, ñu man leena fat ca dal yu sax ya. ");
INSERT INTO wol2010_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Nit ku maandu ci yëf yu néew, dina maandu itam ci yu bare. Ku jubadi ci yëf yu néew, du jub ci yu bare. ");
INSERT INTO wol2010_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Su fekkeente ne nag jubuleen ci alalu àddina, kon ku leen di dénk alal ju wóor ji? ");
INSERT INTO wol2010_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Te su ngeen maanduwul ci alal ji ngeen moomul, kon ku leen di jox alal ji ngeen moom? ");
INSERT INTO wol2010_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","«Benn jaam manula jaamoondoo ñaari sang; fàww nga bañ kii, bëgg ki ci des, walla nga jàpp ci kenn ki, xeeb ki ci des. Manuleena boole jaamu Yàlla ak jaamu Alal.» ");
INSERT INTO wol2010_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Farisen yi déglu li Yeesu doon wax lépp, tàmbali di ko reetaan, ndaxte ñu bëggoon xaalis lañu. ");
INSERT INTO wol2010_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Waaye Yeesu ne leen: «Yéen yéena ngi fexee jub ci kanam nit ñi waaye Yàlla xam na seen xol. Ndaxte li nit ñiy fonk, Yàlla sib na ko. ");
INSERT INTO wol2010_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","«Yoonu Musaa wi ak waxi yonent yi ñu ngi fi woon ba kera Yaxya di ñëw. La ko dale foofa nag, yégle nañu xibaaru jàmm bi ci nguuru Yàlla, te ñépp a ngi góor-góorlu, ngir dugg ci. ");
INSERT INTO wol2010_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Waaye nag asamaan ak suuf jóge fi moo gëna yomb randal wenn rëdd ci arafu yoonu Musaa. ");
INSERT INTO wol2010_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","«Ku fase sa soxna, ba noppi takk keneen, njaaloo nga, te ku takk jigéen ju jëkkëram fase, njaaloo nga. ");
INSERT INTO wol2010_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","«Dafa amoon boroom alal juy sol yére yu rafet te jafe, tey dund bés bu set dund gu neex. ");
INSERT INTO wol2010_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Fekk miskin mu ñuy wax Lasaar daan tëdd ca buntu këram, fees dell ak ay góom, ");
INSERT INTO wol2010_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","te bu sañoon, di lekk ci desiti ñam wiy rot ci lekkukaayu boroom alal ji. Xaj yi sax daan nañu ñëw, di mar ay góomam. ");
INSERT INTO wol2010_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","«Noonu miskin ma dee, malaaka yi yóbbu ko ca wetu Ibraayma. Boroom alal ja itam dee, ñu suul ko. ");
INSERT INTO wol2010_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Bi ñu koy mbugal ca sawara, mu téen, séen fu sore Ibraayma ak Lasaar ci wetam. ");
INSERT INTO wol2010_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Noonu mu yuuxu ne: “Maam Ibraayma, yërëm ma! Yebalal Lasaar, mu sëpp catul baaraamam ci ndox, seralal ma sama làmmiñ, ndaxte maa ngi sonn lool ci sawara sii!” ");
INSERT INTO wol2010_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Ibraayma ne ko: “Sama doom, fàttalikul ne jot nga sa bànneex ci àddina, fekk Lasaar dëkk ci tiis. Looloo tax xolam sedd fii, yaw nag, ngay sonn. ");
INSERT INTO wol2010_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Rax-ca-dolli it am na kàmb gu xóot sunu diggante ak yéen, ba tax ñi bëgga jóge fii jëm ci yéen, walla ñi bëgga jóge foofu jëmsi ci nun, duñu ko man.” ");
INSERT INTO wol2010_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","«Noonu boroom alal ja ne: “Kon nag maam, maa ngi lay ñaan, nga yebal Lasaar ca sama kër baay, ");
INSERT INTO wol2010_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","ndaxte am naa fa juróomi rakk. Na leen artu, ngir ñu baña ñëw ñoom itam ci bérabu metit wii.” ");
INSERT INTO wol2010_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Ibraayma ne ko: “Say doomu baay, ñu ngeek yoonu Musaa ak téerey yonent yi. Nañu leen déggal.” ");
INSERT INTO wol2010_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Boroom alal ja ne ko: “Déedéet, maam Ibraayma, waaye su kenn dekkee, dem ca ñoom, dinañu tuub seeni bàkkaar.” ");
INSERT INTO wol2010_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Waaye Ibraayma ne ko: “Su ñu dégluwul Musaa ak yonent yi, kon ku dekki sax, du tax ñu gëm.”» ");
INSERT INTO wol2010_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Yeesu waxaat ay taalibeem ne leen: «Fiir yuy yóbbe nit bàkkaar manta ñàkk, waaye toroxte dal na ki koy lal. ");
INSERT INTO wol2010_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Ñu takk doj wu réy ci baatam, sànni ko ci géej moo gën ci moom muy daaneel ci bàkkaar kenn ci ñi gëna tuuti ci ñii. ");
INSERT INTO wol2010_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Wottuleen seen bopp. «Bu sa mbokk tooñee, yedd ko. Bu réccoo, baal ko. ");
INSERT INTO wol2010_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Te su la tooñee juróom ñaari yoon ci bés bi, te ñëw ci yaw juróom ñaari yoon ne la: “Tuub naa ko,” nanga ko baal.» ");
INSERT INTO wol2010_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Ndaw ya wax Boroom bi ne ko: «Yokkal sunu ngëm.» ");
INSERT INTO wol2010_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Boroom bi ne leen: «Su ngeen amee ngëm gu tuuti sax niw peppu fuddën, kon dingeen mana ne garab gii: “Buddeekul, dem jëmbëtu ca géej ga,” te dina def li ngeen wax. ");
INSERT INTO wol2010_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","«Kan ci yéen bu amoon surga bu beyi walla bu sàmmi ba ñëw, ndax dafa ko naa: “Kaay lekk”? ");
INSERT INTO wol2010_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Déedéet. Xanaa kay da ko naan: “Defaral ma reer bi. Takkul te tibbal ma, ba ma lekk te naan, ba noppi nga doora lekk te naan.” ");
INSERT INTO wol2010_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Li surga ba topp ndigal, ndax tax na mu yelloo ngërëm? Déedéet. ");
INSERT INTO wol2010_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Noonu yéen itam bu ngeen toppee li ñu leen sant lépp ba noppi, dangeena war ne: “Ay surga rekk lanu. Sunu warugar lanu def.”» ");
INSERT INTO wol2010_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Bi muy dem Yerusalem ba tey, Yeesu jaar ci dig wiy xàjjale Samari ak Galile. ");
INSERT INTO wol2010_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Bi muy jub benn dëkk, fukki gaana ñëw, dogale ko. Ñu taxaw dànd ko, di wax ca kaw naan: ");
INSERT INTO wol2010_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","«Yeesu, kilifa gi, yërëm nu!» ");
INSERT INTO wol2010_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Naka la leen Yeesu di gis, naan leen: «Demleen won seen bopp sarxalkat ya.» Bi ñuy dem, ñu daldi set. ");
INSERT INTO wol2010_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Kenn ci ñoom gis ne wér na, daldi dëpp, di màggal Yàlla ak baat bu xumb. ");
INSERT INTO wol2010_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Mu dëpp jëëm ca tànki Yeesu, di ko gërëm. Fekk nitu Samari la woon. ");
INSERT INTO wol2010_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Noonu Yeesu daldi ne: «Xanaa du fukk yépp a wér? Ana juróom ñeent ña nag? ");
INSERT INTO wol2010_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Amul kenn ci ñoom ku ñëw gërëm Yàlla ku dul doxandéem bii!» ");
INSERT INTO wol2010_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Noonu Yeesu ne ko: «Jógal dem; sa ngëm faj na la.» ");
INSERT INTO wol2010_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Farisen yi laaj Yeesu ne ko: «Kañ la Yàlla di tëral nguuram?» Mu ne leen: «Bu Yàlla di wàcce nguuram ci nit ñi, kenn du ko mana teg bët. ");
INSERT INTO wol2010_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Duñu mana wax it ne: “Xool-leen, mi ngi fii,” walla: “Ma nga fale,” ndaxte nguuru Yàlla wàcc na ci seen biir.» ");
INSERT INTO wol2010_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Noonu mu ne taalibe ya: «Jamono dina ñëw, fu ngeen di bëgga gis su doon sax benn fan ci jamono ju Doomu nit ki di ñëw, waaye dungeen ko gis. ");
INSERT INTO wol2010_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Dees na leen ne: “Mi ngi fii!” walla: “Ma nga fale!” Buleen dem, mbaa ngeen di leen topp. ");
INSERT INTO wol2010_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Ndaxte ni melax naan ràyye ci asamaan, di leeral gii wet, ba ca gee, noonu it la Doomu nit ki di mel ci bésam. ");
INSERT INTO wol2010_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Waaye balaa booba fàww mu sonn lool te niti jamono jii dëddu ko. ");
INSERT INTO wol2010_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","«La xewoon ca bési Nóoyin, dina xewaat ci bési Doomu nit ki. ");
INSERT INTO wol2010_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Nit ñaa ngi doon lekk ak di naan, di jël jabar ak a séyi, ba bés ba Nóoyin duggee ca gaal ga. Noonu mbënn ma ñëw, rey leen ñoom ñépp. ");
INSERT INTO wol2010_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","«Dina mel it ni la xewoon ca bési Lóot. Nit ñaa ngi doon lekk ak di naan, di jënd ak di jaay, di ji ak di tabax. ");
INSERT INTO wol2010_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Waaye bés ba Lóot génnee Sodom, Yàlla tawloo sawara ak tamarax, rey leen ñoom ñépp. ");
INSERT INTO wol2010_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Noonu lay mel, bés bu Doomu nit kiy feeñ. ");
INSERT INTO wol2010_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","«Ca bés boobee ku nekk ca kaw kër ga te ay bagaasam nekk ca biir, bumu wàcc jëli leen. Te it ku nekk ca tool ya, bu mu ñibbi. ");
INSERT INTO wol2010_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Fàttalikuleen soxnas Lóot! ");
INSERT INTO wol2010_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Kuy wuta rawale sa bakkan, dinga ko ñàkk, waaye ku ko ñàkk, dinga dund. ");
INSERT INTO wol2010_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Maa ngi leen koy wax: ca jamono jooju, ñaar dinañu bokka tëdd guddi, dees na yóbbu kenn ki, bàyyi ka ca des. ");
INSERT INTO wol2010_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","36","Ñaari jigéen dinañu wolandoo, dees na yóbbu kenn ci, bàyyi ka ca des.» ");
INSERT INTO wol2010_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Taalibe yi ne Yeesu: «Fu loolu di xewe, Boroom bi?» Yeesu ne leen: «Fa médd nekk, la tan yiy dajee.» ");
INSERT INTO wol2010_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Noonu Yeesu wax leen itam léeb wii ngir xamal leen ne war nañoo sax ci ñaan te baña xàddi. ");
INSERT INTO wol2010_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Nee na: «Dafa amoon cib dëkk, benn àttekat bu ragalul Yàlla te faalewul mbindeef. ");
INSERT INTO wol2010_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Amoon na itam ca dëkk ba jigéen ju jëkkëram faatu ju daan faral di ñëw ci moom, naan ko: “Àtte ma ak sama noon!” ");
INSERT INTO wol2010_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Àttekat ba bañ lu yàgg, waaye am bés mu ne ci xelam: “Ragaluma Yàlla te faalewuma mbindeef, ");
INSERT INTO wol2010_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","waaye jigéen jii lakkal na ma; kon dinaa ko àtte, ngir mu bañatee ñëw sonal ma. Dina rey ak ay wax.”» ");
INSERT INTO wol2010_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Boroom bi tegaat ca ne: «Dégluleen bu baax li àttekat bu bon boobu wax; ");
INSERT INTO wol2010_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","ndax Yàlla du àtte jub mbooloom mi mu tànn te ñu koy ñaan wall guddi ak bëccëg? Ndax dina leen xaarloo? ");
INSERT INTO wol2010_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Maa ngi leen koy wax, dina leen àtte jub ci lu gaaw. Waaye bu Doomu nit ki ñëwee, ndax dina fekk ngëm ci àddina?» ");
INSERT INTO wol2010_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Yeesu waxaat léeb wii nit, ñi foog ne jub nañu tey xeeb ñi ci des. ");
INSERT INTO wol2010_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","Mu ne: «Dafa amoon ñaari nit ñu dem ca kër Yàlla ga, di ñaan. Kenn ki ab Farisen la, ki ci des juutikat. ");
INSERT INTO wol2010_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Farisen baa nga taxaw di ñaan ci xelam naan: “Yaw Yàlla, maa ngi lay sant ci li ma melul ni ñeneen ñiy sàcc, di def lu jubadi te di njaaloo, rawatina juutikat bii. ");
INSERT INTO wol2010_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Ayu-bés gu nekk damay woor ñaari yoon, di joxe asaka ci lépp lu ma wut.” ");
INSERT INTO wol2010_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","«Juutikat ba moom, ma nga taxaw fu sore te bëggula siggi sax, xool ca asamaan. Waaye ma ngay fëgg dënnam te naan: “Yaw Yàlla, yërëm ma, man miy bàkkaarkat.”» ");
INSERT INTO wol2010_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Yeesu teg ca ne: «Maa ngi leen koy wax, nit kooku, ba muy ñibbi këram, moom la Yàlla àtte ni ku jub, waaye du Farisen ba. Ndaxte képp kuy yékkatiku dees na la suufeel, te kuy suufeelu, ñu yékkati la.» ");
INSERT INTO wol2010_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Amoon na ay nit, ñuy indil Yeesu ay liir, ngir mu teg leen ay loxoom. Bi taalibe ya gisee loolu, ñu gëdd leen. ");
INSERT INTO wol2010_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Waaye Yeesu woo leen ne: «Bàyyileen xale yi, ñu ñëw ci man, te buleen leen tere, ndaxte ñu mel ni ñoom ñoo yelloo nguuru Yàlla. ");
INSERT INTO wol2010_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Ci dëgg, maa ngi leen koy wax, ku woyoful ni xale, nangu nguuru Yàlla, doo ci mana dugg.» ");
INSERT INTO wol2010_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Benn njiitu Yawut laaj Yeesu ne ko: «Kilifa gu baax gi, lu ma wara def, ba am wàll ci dund gu dul jeex?» ");
INSERT INTO wol2010_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Yeesu ne ko: «Lu tax nga wooye ma ku baax? Yàlla rekk a baax. ");
INSERT INTO wol2010_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Xam nga ndigal yi: “Bul njaaloo, bul bóome, bul sàcc, bul seede lu dul dëgg, teralal sa ndey ak sa baay.”» ");
INSERT INTO wol2010_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Njiit la ne ko: «Loolu lépp sàmm naa ko li dale ci sama ndaw ba tey.» ");
INSERT INTO wol2010_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Bi Yeesu déggee loolu, mu ne ko: «Lenn rekk moo la dese. Jaayal li nga am lépp, séddale ko miskin yi te dinga woomle ca asamaan; boo noppee, nga ñëw topp ci man.» ");
INSERT INTO wol2010_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Bi nit ka déggee loolu, mu am tiis, ndaxte ku bare woon alal la. ");
INSERT INTO wol2010_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Yeesu xool ko, daldi ne: «Boroom alal, dugg ci nguuru Yàlla, lu jafee ngoogu! ");
INSERT INTO wol2010_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Giléem jaar ci bën-bënu puso moo gëna yomb boroom alal dugg ci nguuru Yàlla.» ");
INSERT INTO wol2010_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Ñi doon déglu daldi ne: «Kon nag ku mana mucc?» ");
INSERT INTO wol2010_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Yeesu ne leen: «Li të nit ñi, tëwul Yàlla.» ");
INSERT INTO wol2010_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Noonu Piyeer ne: «Nun de, dëddu nanu li nu am lépp, topp la.» ");
INSERT INTO wol2010_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Yeesu ne leen: «Ci dëgg maa ngi leen koy wax, képp ku dëddu kër walla soxna walla ay doomi ndey walla ay waajur walla ay doom ngir nguuru Yàlla, ");
INSERT INTO wol2010_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","dinga am tey jii ay yooni yoon, ak dund gu dul jeex ëllëg.» ");
INSERT INTO wol2010_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Yeesu wéetoo ak fukki taalibe yi ak ñaar ne leen: «Nu ngi dem Yerusalem, te li yonent yi bindoon lépp ci mbirum Doomu nit ki dina mat. ");
INSERT INTO wol2010_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Dinañu ko jébbal ñi dul Yawut, ñu ñaawal ko, saaga ko, tifli ci kawam. ");
INSERT INTO wol2010_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Gannaaw bu ñu ko dóoree ay yar ba noppi, dinañu ko rey, waaye ca ñetteelu fan ba dina dekki.» ");
INSERT INTO wol2010_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Waaye taalibe ya dégguñu li mu leen doon wax; kàddu yooyu ump na leen, te xamuñu li waxi Yeesu yooyu tekki. ");
INSERT INTO wol2010_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Bi Yeesu di agsi dëkku Yeriko, am gumba gu toogoon ca wetu yoon wa, di yelwaan. ");
INSERT INTO wol2010_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Naka la gumba ga dégg mbooloo di jàll, mu laaj lan moo xew. ");
INSERT INTO wol2010_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Ñu wax ko ne: «Yeesum Nasaret moo fay jaar.» ");
INSERT INTO wol2010_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Noonu mu yuuxu ne: «Yeesu, Sëtu Daawuda, yërëm ma!» ");
INSERT INTO wol2010_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Ñi jiitu woon gëdd ko, ngir mu noppi. Waaye muy gëna yuuxu naan: «Sëtu Daawuda, yërëm ma!» ");
INSERT INTO wol2010_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Noonu Yeesu taxaw, santaane ñu indil ko ko. Bi mu jegesee, Yeesu laaj ko ne: ");
INSERT INTO wol2010_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","«Loo bëggoon ma defal la ko?» Mu ne ko: «Sang bi, damaa bëgga gis.» ");
INSERT INTO wol2010_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Noonu Yeesu ne ko: «Na say bët gis! Sa ngëm faj na la.» ");
INSERT INTO wol2010_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Ca saa sa mu daldi gis. Noonu mu topp ci Yeesu, di màggal Yàlla. Mbooloo mépp gis loolu, di sant Yàlla. ");
INSERT INTO wol2010_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Yeesu dugg na Yeriko, jaar ca dëkk ba, di dem. ");
INSERT INTO wol2010_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Waaye amoon na fa waa ju ñuy wax Sase. Njiitu juutikat la, te di ku bare alal. ");
INSERT INTO wol2010_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Bëgg na gis kan mooy Yeesu, waaye dafa gàtt lool, ba manu koo gis ndax mbooloo ma. ");
INSERT INTO wol2010_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Noonu mu daw, jiituji ca yoon wa, yéeg ci genn garab ngir gis Yeesu, ndaxte foofa la naroona jaar. ");
INSERT INTO wol2010_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Bi Yeesu dikkee ba tollook garab ga nag, mu téen ne ko: «Sase, wàccal gaaw, ndax tey sa kër laa wara dal.» ");
INSERT INTO wol2010_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Sase daldi gaawantu wàcc, ganale ko ak mbég. ");
INSERT INTO wol2010_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Ñépp gis loolu, di ñurum-ñurumi naan: «Mi ngi dal cig këru boroom bàkkaar.» ");
INSERT INTO wol2010_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Waaye Sase taxaw ne Boroom bi: «Déglul Boroom bi, dogu naa may sama genn-wàllu alal miskin yi, te lu ma masa njublaŋ nit, jël alalam, dinaa ko fey ñeenti yoon lu ni tollu.» ");
INSERT INTO wol2010_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Yeesu ne ko: «Mucc gi wàcc na tey ci kër gii, ndaxte nit kii, ci askanu Ibraayma la bokk itam. ");
INSERT INTO wol2010_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Ndaxte Doomu nit ki ñëw na, ngir seet te musal ñi réer.» ");
INSERT INTO wol2010_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Bi nit ñi doon déglu kàddu yooyu, Yeesu teg ca léeb, ndaxte jege woon na Yerusalem, te ñoom foogoon nañu ne nguuru Yàlla dafay daldi feeñ ca saa sa. ");
INSERT INTO wol2010_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Mu ne nag: «Dafa amoon boroom juddu bu rafet bu demoon ci réew mu sore, ngir ñu fal ko buur te mu délsiwaat. ");
INSERT INTO wol2010_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Noonu mu woo fukk ci ay surgaam, jox ku nekk benn libidoor, ne leen: “Liggéeyleen ci, ba may ñibsi.” ");
INSERT INTO wol2010_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Waaye waa réewam bëgguñu ko. Noonu ñu yónni ndaw ci gannaawam ne: “Bëggunu nit kii yilif nu.” ");
INSERT INTO wol2010_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","«Bi ñu ko falee buur nag, ba mu délsi, mu woolu surga, ya mu joxoon wurus wa, ngir xam nan lañu ci liggéeye. ");
INSERT INTO wol2010_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Ku jëkk ka ñëw ne ko: “Sang bi, sa libidoor bii jur na fukki libidoor.” ");
INSERT INTO wol2010_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Buur ba ne ko: “Def nga lu baax, surga bu baax nga. Segam wone nga ne takku nga ci lu tuuti, falul ci fukki dëkk.” ");
INSERT INTO wol2010_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Surga ba ca topp ñëw ne: “Sang bi, sa libidoor ba indi na juróomi libidoor.” ");
INSERT INTO wol2010_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Buur ba ne ko: “Yaw, falul ci juróomi dëkk.” ");
INSERT INTO wol2010_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Keneen ñëw ne: “Sang bi, sa libidoor baa ngi nii. Dama koo fasoon ci sekkit, denc ko. ");
INSERT INTO wol2010_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Dama laa ragaloon, ndaxte ku néeg nga. Dangay nangu loo dénkaanewul, di dajale loo jiwul.” ");
INSERT INTO wol2010_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Buur ba ne ko: “Ci say wax laa lay àtte, surga bu bon bi! Xamoon nga ne, nit ku néeg laa, di nangu lu ma dénkaanewul, te dajale lu ma jiwul. ");
INSERT INTO wol2010_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Lu tax nag yóbbuwoo sama xaalis ca denckati xaalis ya? Bés bu ma ñëwee nag, ma mana jot sama xaalis ak la mu jur.” ");
INSERT INTO wol2010_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","«Ci kaw loolu mu ne ña taxawoon ca wetam: “Nanguleen libidoor bi ci moom, jox ko boroom fukki libidoor yi.” ");
INSERT INTO wol2010_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Ñu ne ko: “Sang bi, am na fukki libidoor ba noppi.” ");
INSERT INTO wol2010_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Buur ba ne leen: “Maa ngi leen koy wax, ku am, dinañu la dolli, waaye ku amul, li nga am as néew sax, dinañu ko nangu. ");
INSERT INTO wol2010_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Waaye sama noon yi, ñi bëggul woon ma doon seen buur, indileen fii, rey leen ci sama kanam.”» ");
INSERT INTO wol2010_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Bi mu waxee loolu ba noppi, Yeesu dafa daldi jiitu, jëm Yerusalem. ");
INSERT INTO wol2010_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Bi muy jege dëkki Betfase ak Betani, ci wetu tund wu ñuy wax tundu Oliw ya, Yeesu yebal ñaar ci ay taalibeem, ");
INSERT INTO wol2010_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","ne leen: «Demleen ci dëkk bi ci kanam. Bu ngeen fa duggee, dingeen fa gis cumbur gu kenn masula war. Yiwileen ko, indi. ");
INSERT INTO wol2010_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Bu leen kenn laajee: “Lu tax ngeen koy yiwi?” neleen ko: “Boroom bi da koo soxla.”» ");
INSERT INTO wol2010_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Ñaari ndaw ya dem, fekk mbir ya deme, na leen ko Yeesu waxe woon. ");
INSERT INTO wol2010_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Bi ñuy yiwi cumbur ga nag, ay boroomam ne leen: «Lu tax ngeen di yiwi cumbur gi?» ");
INSERT INTO wol2010_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Ñu ne: «Ndaxte Boroom bi da koo soxla.» ");
INSERT INTO wol2010_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Noonu ñu indil cumbur gi Yeesu, daldi lal seeni yére ca kaw, yéegal ca Yeesu. ");
INSERT INTO wol2010_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Bi muy dem, nit ñi di lalal Yeesu seeni yére ci yoon wi. ");
INSERT INTO wol2010_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Bi ñu agsee fa mbartalum tundu Oliw ya doore, taalibeem yépp fees ak mbég, tàmbalee màggal Yàlla ca kaw ndax kéemaan yu bare yi ñu gis. ");
INSERT INTO wol2010_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Ñu ngi naan: «Yaw buur biy ñëw ci turu Boroom bi, ku barkeel nga! Na jàmm am ca asamaan, te ndam li féete ca bérab yu gëna kawe!» ");
INSERT INTO wol2010_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Waaye ay Farisen yu nekkoon ca mbooloo ma ne Yeesu: «Kilifa gi, yeddal sa taalibe yi!» ");
INSERT INTO wol2010_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Noonu mu ne: «Maa ngi leen koy wax, bu ñu noppee ñoom, doj yiy xaacu.» ");
INSERT INTO wol2010_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Bi Yeesu jegee dëkk ba, ba séen ko, mu jooy ko ");
INSERT INTO wol2010_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","naan: «Céy yaw itam, boo xamoon bésub tey yi la mana indil jàmm! Waaye fi mu ne manuloo koo gis. ");
INSERT INTO wol2010_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Bés dina ñëwi yu say noon di jal, wërale la. Dinañu la tëj ci biir, tanc la. ");
INSERT INTO wol2010_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Dinañu la yàqate, yaw ak sa waa dëkk. Doj dootul des ci kaw doj ci yaw, ndaxte ràññeewoo jamono ji Yàlla ñëwe, wallusi la.» ");
INSERT INTO wol2010_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Gannaaw loolu Yeesu dugg ca kër Yàlla ga, daldi dàq ña fay jaay, ");
INSERT INTO wol2010_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","naan leen: «Mbind mi nee na: “Sama kër këru ñaan ci Yàlla lay doon; waaye yéen def ngeen ko këru sàcc.”» ");
INSERT INTO wol2010_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Bés bu nekk Yeesu di jàngle ca kër Yàlla ga. Sarxalkat yu mag ya ak xutbakat ya, ñoom ak njiiti xeet wa, ñu ngi ko doon wuta reylu. ");
INSERT INTO wol2010_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Waaye xamuñu woon lan lañu mana def, ndaxte nit ñépp a ngi ko doon déglu, bañ benn baat raw leen. ");
INSERT INTO wol2010_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Benn bés Yeesu doon jàngal nit ña ca kër Yàlla ga, di leen yégal xibaaru jàmm bi. Sarxalkat yu mag ya ak xutbakat ya ak njiit ya ñëw ne ko: ");
INSERT INTO wol2010_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","«Wax nu ci ban sañ-sañ ngay defe yëf yii, walla kan moo la may boobu sañ-sañ.» ");
INSERT INTO wol2010_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Yeesu ne leen: «Man itam dinaa leen laaj lenn: waxleen ma, ");
INSERT INTO wol2010_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","la Yaxya daan def, di sóob nit ñi ci ndox, fu mu ko jële, ci Yàlla walla ci nit ñi?» ");
INSERT INTO wol2010_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Ñu waxtaan ci seen biir naan: «Bu nu nee: “Ci Yàlla,” dina laaj: “Lu tax gëmuleen ko kon?” ");
INSERT INTO wol2010_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Te bu nu nee: “Ci nit ñi,” mbooloo mépp dinañu nu sànni ay xeer, ndaxte gëm nañu ne Yaxya yonent la woon.» ");
INSERT INTO wol2010_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Noonu ñu ne ko xamuñu fu mu ko jële. ");
INSERT INTO wol2010_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Yeesu ne leen: «Kon man itam duma leen wax ci ban sañ-sañ laay defe yëf yii.» ");
INSERT INTO wol2010_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Noonu Yeesu daldi wax nit ña léeb wii: «Amoon na nit ku jëmbët toolu reseñ, batale ko ay beykat, dem tukki tukki bu yàgg. ");
INSERT INTO wol2010_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Bi tool bi ñoree nag, mu yónni surga ci ñoom, ngir jot wàllam ci meññeef gi. Waaye beykat yi dóor ko ay yar, dàq ko, mu dellu ak loxoy neen. ");
INSERT INTO wol2010_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Mu yónniwaat beneen surga, ñu dóor ko moom itam, toroxal ko, dàq ko, mu dellu ak loxoy neen. ");
INSERT INTO wol2010_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Mu yónneeti ñetteelu surga, ñu gaañ ko, dàq ko. ");
INSERT INTO wol2010_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","«Boroom tool ba daldi ne: “Nan laay def nag? Dinaa yónni sama doom, sama reeni xol. Xëy na ñu weg ko, moom.” ");
INSERT INTO wol2010_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Waaye bi beykat yi gisee doom ji, ñu ne ci seen biir: “Kii moo wara donn tool bi; nan ko rey, moom ndono li.” ");
INSERT INTO wol2010_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Ñu génne ko tool bi nag, rey ko.» Noonu Yeesu laaj leen: «Nu leen boroom tool bi di def, nag? ");
INSERT INTO wol2010_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Xanaa ñëw, rey beykat yooyu, dénk tool ba ñeneen.» Bi Yeesu waxee loolu, nit ña ne ko: «Yàlla tere!» ");
INSERT INTO wol2010_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Waaye Yeesu ne leen jàkk, daldi ne: «Kon nag lu baat yii ci Mbind mi di tekki: “Doj wa tabaxkat ya sànni, mujj na di doju koñ.” ");
INSERT INTO wol2010_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Képp ku dal ci doj woowu, dammtoo, te ku mu dal ci sa kaw, rajaxe la.» ");
INSERT INTO wol2010_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Xutbakat ya ak sarxalkat yu mag ya ñu ngi doon wuta jàpp Yeesu ca taxawaay ba, ndaxte xam nañu ne ñoo tax mu wax léeb woowu. Waaye ragal nañu mbooloo ma. ");
INSERT INTO wol2010_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Noonu ñu koy yeeru, daldi yónni ay nit ñu mbubboo njub, sas leen ñu fexe koo jàpp ci ay waxam, ngir jébbal ko boroom réew, ma yor kilifteef ak sañ-sañ. ");
INSERT INTO wol2010_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Ñu daldi ñëw ci Yeesu ne ko: «Kilifa gi, xam nanu ne li ngay wax te di ko jàngle lu jub la. Amuloo parlàqu, waaye dangay xamle yoonu Yàlla ci bu wóor. ");
INSERT INTO wol2010_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Wax nu, ndax jaadu na, nu fey buur bi Sesaar galag walla déet.» ");
INSERT INTO wol2010_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Waaye Yeesu xam na seen pexe ne leen: ");
INSERT INTO wol2010_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","«Wonleen ma posetu denariyon. Kan lañu ci def nataalam ak turam?» Ñu ne ko: «Sesaar.» ");
INSERT INTO wol2010_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Noonu mu ne leen: «Joxleen nag Sesaar li Sesaar moom, te jox Yàlla li Yàlla moom.» ");
INSERT INTO wol2010_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Noonu manuñu ko woona jàpp ciy waxam ci kanam mbooloo ma; ñu waaru ci tontam, ba wedam. ");
INSERT INTO wol2010_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Noonu ay nit, ñu bokk ci Sadusen yi, ñëw ci moom. Sadusen yi nag ñoom weddi nañu ndekkite li. Noonu ñu laaj ko ne: ");
INSERT INTO wol2010_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","«Kilifa gi, Musaa bindal na nu ne, ku magam faatu te bàyyiwul doom ak soxnaam, kooku war na donn jigéen ji, ba yékkati giiru magam. ");
INSERT INTO wol2010_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Amoon na fi nag juróom ñaari góor ñu bokk ndey ak baay. Taaw ba takk jabar, faatu, te bàyyiwul doom. ");
INSERT INTO wol2010_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","31","Ñaareel ba takk jigéen ja, def noonu; ak ñetteel ba, ba juróom ñaar ñépp faatu te bàyyiwuñu doom. ");
INSERT INTO wol2010_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Gannaaw ga nag jigéen ja it faatu. ");
INSERT INTO wol2010_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Ci ndekkite li nag, kan ci ñoom moo wara donn jigéen ja, fekk ku nekk ci juróom ñaar ñi mas na koo takk?» ");
INSERT INTO wol2010_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Yeesu ne leen: «Ci àddina sii, góor ñi ak jigéen ñi dañuy séy. ");
INSERT INTO wol2010_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Waaye ña ñu àtte ne yeyoo nañoo bokk ci dundu ëllëg ak ci ndekkite li, kenn du am jabar, kenn du am jëkkër. ");
INSERT INTO wol2010_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Dafa fekk ne manatuñoo dee, ndaxte dañuy mel ni malaaka yi. Ay doomi Yàlla lañu ndaxte doomi ndekkite lañu. ");
INSERT INTO wol2010_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Te Musaa sax wone na ne, néew yi dinañu dekki, ci saarum ngarab si. Foofa Musaa wooye na fa Boroom bi: “Yàllay Ibraayma, Yàllay Isaaxa, di Yàllay Yanqóoba.” ");
INSERT INTO wol2010_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Kon nag nekkul Yàllay ñi dee waaye Yàllay ñiy dund la, ndaxte Yàllaa tax ñépp di dund.» ");
INSERT INTO wol2010_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Ci kaw loolu ay xutbakat ne ko: «Li nga wax dëgg la, kilifa gi!» ");
INSERT INTO wol2010_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Ndaxte kenn ci ñoom ñemeetu koo laaj dara. ");
INSERT INTO wol2010_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Noonu Yeesu ne leen: «Lu tax nit ñi di wax ne, Almasi bi mooy sëtu Daawuda? ");
INSERT INTO wol2010_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Ndaxte Daawuda moom ci boppam moo ne ci Sabóor: “Boroom bi nee na sama Boroom: ‘Toogal ci sama ndijoor, ");
INSERT INTO wol2010_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","ba kera may daaneel say noon ci sa kanam.’ ” ");
INSERT INTO wol2010_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Gannaaw Daawuda nag wooye na ko “Boroom bi,” nu muy nekke sëtam?» ");
INSERT INTO wol2010_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Bi ko nit ña fa nekkoon ñépp doon déglu, Yeesu ne ay taalibeem: ");
INSERT INTO wol2010_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","«Moytuleen xutbakat yi; dañoo bëgg di doxantu, sol ay mbubb yu réy, te ñépp di leen nuyoo ñaari loxo ci pénc mi. Ci jàngu yi, toogu yu féete kanam lañuy wut, te toogu yu yiw lañuy taamu ci reeri xew yi. ");
INSERT INTO wol2010_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Ñu ngi lekk alalu jigéen ñi seen jëkkër faatu, di ñaan Yàlla ay ñaani ngistal yu gudd. Seen mbugal dina gëna tar.» ");
INSERT INTO wol2010_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Noonu Yeesu siggi, séen ay boroom alal ñuy dugal seen sarax ca ndab ya ca kër Yàlla ga. ");
INSERT INTO wol2010_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Mu gis itam jenn jigéen ju jëkkëram faatu te mu ñàkk, ju fa def ñaari poseti xànjar. ");
INSERT INTO wol2010_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Noonu mu daldi ne: «Ci dëgg, maa ngi leen koy wax, jigéen ju ñàkk jee moo ëpp ñeneen ñépp lu mu joxe. ");
INSERT INTO wol2010_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Ñoom ñépp dañu sàkk ci seen barele, waaye moom dafa sàkk ci néewleem, ba joxe xaalis bi mu waroona dunde.» ");
INSERT INTO wol2010_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Noonu ay nit doon wax ci lu jëm ca kër Yàlla ga, ak ni ñu ko rafetale ak ay doj yu jafe ak alal ju ñu jébbal Yàlla. Waaye Yeesu ne leen: ");
INSERT INTO wol2010_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","«Li ngeen gis fii lépp, jamono dina ñëw joo xam ne dina daanu, ba doj dootul des ci kaw doj.» ");
INSERT INTO wol2010_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Ñu laaj ko ne: «Kilifa gi, kañ la loolu di am? Ak luy tegtal ne looloo ngi waaja xew?» ");
INSERT INTO wol2010_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Yeesu ne: «Moytuleen, bu leen kenn nax. Ndaxte ñu bare dinañu ñëw ci sama tur ne: “Moom laa,” walla ñu naan: “Jamono ji jegesi na.” Buleen topp ñooñu. ");
INSERT INTO wol2010_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Bu ngeen déggee ay xare ak ay réew yu jóg, wottuleena tiit, ndaxte fàww yooyule jëkka am. Waaye taxul mujug jamono daldi taxaw.» ");
INSERT INTO wol2010_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Noonu mu teg ca ne: «Xeet dina jóg, xeex ak weneen xeet, réew dina xeex ak meneen réew. ");
INSERT INTO wol2010_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Suuf dina yëngu yëngu yu réy, te wopp ak xiif dina am ci bérab yu bare. Dina am it ay xew-xew yu raglu ak ay firnde yu mag yuy jóge asamaan. ");
INSERT INTO wol2010_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Waaye bala looloo xew, dees na leen jàpp, fitnaal leen, di leen jébbal àttekat yi ca jàngu ya, tëj leen kaso. Dees na leen yóbbu ci kanam i buur ak i boroom réew ndax sama tur. ");
INSERT INTO wol2010_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Loolu dina leen ubbil bunt, ba ngeen man maa seedeel. ");
INSERT INTO wol2010_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Fasleen yéenee baña wut lay ngir musal seen bopp. ");
INSERT INTO wol2010_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Ndaxte man ci sama bopp maa leen di jox kàddu ak xel moo xam ne seeni noon duñu ko mana teggi, mbaa ñu di ko weddi. ");
INSERT INTO wol2010_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Seeni waajur sax ak seeni doomi ndey, seeni bokk ak seeni xarit, dinañu leen jébbal àttekat yi, ba ñu rey ñenn ci yéen. ");
INSERT INTO wol2010_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Te ñépp dinañu leen bañ ndax sama tur. ");
INSERT INTO wol2010_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Waaye seen genn kawar sax du neen. ");
INSERT INTO wol2010_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Seen muñ moo leen di musal. ");
INSERT INTO wol2010_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","«Bu ngeen gisee ay xarekat wër dëkku Yerusalem, xamleen ne jamono, ji ñu koy yàq, agsi na. ");
INSERT INTO wol2010_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Kon nag ku nekk ci biir diiwaanu Yude, nanga daw ca tund ya; ku nekk ci biir dëkk bi, nanga ko génn; te ku nekk ca tool ya, bul dugg ca dëkk ba! ");
INSERT INTO wol2010_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Ndaxte ci bés yooyu Yàlla dina fey jëf yi, te li ñu bindoon ci téereb Yàlla dina mat. ");
INSERT INTO wol2010_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Ngalla jigéen ñi ëmb ca bés yooya, ngalla it ñiy nàmpal! Ndaxte tiis wu metti dina am ci réew mi, te Yàlla dina wàcce meram ci waa réew mii. ");
INSERT INTO wol2010_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Dees na leen reye ak i jaasi, jàpp leen jaam, yóbbu leen ci réewi àddina sépp. Te ñi dul Yawut dinañu nappaaje Yerusalem, ba kera jamonoy ñi dul Yawut mat. ");
INSERT INTO wol2010_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","«Ay firnde dinañu feeñ ci jant bi, ci weer wi ak ci biddiiw yi. Ci kaw suuf xeet yi dinañu tiit, jaaxle ndax riiru géej gi ak yëngu-yëngub duus yi. ");
INSERT INTO wol2010_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Bu boobaa nit ñiy xëm ndax tiitaange, bu ñuy xalaat musiba, yi nara wàcc ci àddina, ndaxte dees na yëngal kàttani asamaan. ");
INSERT INTO wol2010_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Noonu dinañu gis Doomu nit ki di ñëw ciw niir, ànd ak kàttan ak ndam lu réy. ");
INSERT INTO wol2010_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Bu mbir yooyu di tàmbalee xew nag, boo yaboo ngeen siggi, téen, ndaxte seen njot jubsi na.» ");
INSERT INTO wol2010_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Noonu Yeesu misaal leen lii: «Xool-leen garabu figg ak yeneen garab yi. ");
INSERT INTO wol2010_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Bu ñu gisee ñu sëq, soxlawuleen kenn wax leen ne, nawet bi jubsi na xaat. ");
INSERT INTO wol2010_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Noonu itam bu ngeen gisee loolu lépp xew, xamleen ne nguuru Yàlla jege na. ");
INSERT INTO wol2010_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","«Ci dëgg maa ngi leen koy wax, niti jamono jii duñu wéy, te loolu lépp amul. ");
INSERT INTO wol2010_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Asamaan ak suuf dinañu wéy, waaye samay wax du wéy mukk. ");
INSERT INTO wol2010_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","«Moytuleen seen nafsu diigal leen ci yàqute ak ci màndite ak ittey àddina, ba bés boobu bett leen ni mbaal. ");
INSERT INTO wol2010_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Ndaxte dina dal ci ñépp ñi nekk ci kaw suuf. ");
INSERT INTO wol2010_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Yewwuleen, di sax ci ñaan, ngir ngeen mana mucc ci loolu lépp wara xew, te mana taxaw ak kóolute ci kanam Doomu nit ki.» ");
INSERT INTO wol2010_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Yeesoo ngi daan yendoo jàngle ca kër Yàlla ga, te bu guddee mu dem ca tund wu ñuy wax tundu Oliw ya, fanaan fa. ");
INSERT INTO wol2010_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Te nit ñépp dañu daan teela xëy ca kër Yàlla ga, di ko déglu. ");
INSERT INTO wol2010_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Màggalu Mburu ma amul lawiir jege woon na, te ñu di ko wax bésu Mucc ba. ");
INSERT INTO wol2010_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Sarxalkat yu mag ya ak xutbakat ya di wut pexem reylu Yeesu, ndaxte dañoo ragaloon nit ña. ");
INSERT INTO wol2010_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Noonu Seytaane daldi solu Yudaa, mi ñuy wooye Iskariyo te mu bokkoon ca fukki taalibe ya ak ñaar. ");
INSERT INTO wol2010_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Noonu Yudaa dem waxtaani ak sarxalkat yu mag ya ak kilifay wottukati kër Yàlla ga, ba xam nan la leen di jébbale Yeesu. ");
INSERT INTO wol2010_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Ñu am ca bànneex bu réy, dig ko xaalis. ");
INSERT INTO wol2010_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Yudaa nangu, di fexe jamono ju mu leen mana jébbal Yeesu, fu mbooloo ma nekkul. ");
INSERT INTO wol2010_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Bésu màggalu Mburu ma amul lawiir agsi, ca bés boobu lañu waroona rendi gàttub bésu Mucc ba. ");
INSERT INTO wol2010_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Noonu Yeesu yebal Piyeer ak Yowaana ne leen: «Demleen, defaral nu reeru bésu Mucc ba.» ");
INSERT INTO wol2010_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Ñu ne ko: «Fan nga bëggoon, nu defare ko fa?» ");
INSERT INTO wol2010_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Mu ne leen: «Bu ngeen duggee ca dëkk ba, góor gu yenu njaq lu def ndox, dina taseek yéen. Toppleen ci moom ba ca kër ga muy dugg, ");
INSERT INTO wol2010_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","te ngeen ne boroom kër ga: “Kilifa gi nee na: Ana néegu gan, bi may lekke reeru bésu Mucc ba, man ak samay taalibe?” ");
INSERT INTO wol2010_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Noonu dina leen won néeg bu féete kaw, te yaa, ñu defar ko ba noppi. Foofa ngeen koy defare.» ");
INSERT INTO wol2010_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Ñu dem, gis lépp, ni leen ko Yeesu waxe woon. Noonu ñu defar reer bi. ");
INSERT INTO wol2010_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Bi waxtu wi jotee Yeesu toog ak ndaw yi, ");
INSERT INTO wol2010_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","ne leen: «Yàkkamti woon naa lool lekk ak yéen reeru bésu Mucc bii, laata ñu may sonal. ");
INSERT INTO wol2010_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Ndaxte maa ngi leen koy wax, dootuma ko lekk mukk, lu dul ba kera mu mat ci nguuru Yàlla.» ");
INSERT INTO wol2010_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Noonu mu fab kaas, daldi sant Yàlla ne: «Jël-leen kaas bii, séddoo ko. ");
INSERT INTO wol2010_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Ndaxte maa ngi leen koy wax, dootuma naan ndoxum reseñ mi, ba kera Yàlla di tëral nguuram.» ");
INSERT INTO wol2010_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Gannaaw loolu mu jël mburu, sant Yàlla, damm ko, joxleen ko ne: «Lii sama yaram la, wi ma joxe ngir yéen. Defleen lii, ngir fàttaliku ma.» ");
INSERT INTO wol2010_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Noonu itam bi ñu lekkee ba noppi, mu jël kaas bi ne leen: «Kaas bii mooy misaal kóllëre gu bees gi Yàlla fas jaarale ko ci sama deret, ji tuuru ngir yéen. ");
INSERT INTO wol2010_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Waaye nag loxob ki may wor a ngi nekk ak man ci ndab li. ");
INSERT INTO wol2010_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Doomu nit ki mu ngi dem, ni ñu ko dogale. Waaye ki koy wor dina torox.» ");
INSERT INTO wol2010_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Noonu taalibe yi di laajante ci seen biir, kan ci ñoom mooy nara def loolu. ");
INSERT INTO wol2010_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Taalibe ya it di werante, ngir xam kan ci ñoom moo gëna màgg. ");
INSERT INTO wol2010_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Yeesu ne leen: «Buuri xeeti àddina dañu leen di dóor yetu nguur, te kilifa yi dañuy sàkku ngërëm. ");
INSERT INTO wol2010_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Waaye yéen buleen def noonu. Ki gëna màgg ci yéen, na nekk ni ki gëna ndaw, te njiit mel ni surga. ");
INSERT INTO wol2010_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Ki toog ca lekkukaay ba, moom ak surgaam, ñoom ñaar kan moo ci gëna màgg? Xanaa du ki toog ci lekkukaay bi? Waaye man maa ngi ci seen biir ni surga. ");
INSERT INTO wol2010_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Yéen nag yéenay ñi ànd ak man ci samay fitna. ");
INSERT INTO wol2010_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Man nag jox naa leen sañ-sañu nguuru, ni ma ko sama Baay joxe. ");
INSERT INTO wol2010_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Dingeen lekkandoo te naanandoo ak man ci sama nguur. Te dingeen toog ci jal yi, di àtte fukki giir ak ñaar yu bànni Israyil.» ");
INSERT INTO wol2010_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Yeesu teg ca ne: «Simoŋ, Simoŋ! Seytaane ñaan na, ñu jébbal leen ko, ngir mu teqale leen ni ñu teqalee dugub ak xatax. ");
INSERT INTO wol2010_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Waaye man ñaanal naa la, ngir sa ngëm dëgër. Te yaw, boo délsee, nanga dëgëral sa bokki taalibe yi.» ");
INSERT INTO wol2010_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Piyeer ne ko: «Boroom bi, àttan naa ànd ak yaw ca kaso, ba ci dee sax.» ");
INSERT INTO wol2010_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Yeesu ne ko: «Piyeer, maa ngi la koy wax, bala ginaar a sab tey jii, dinga weddi ñetti yoon ne xam nga ma.» ");
INSERT INTO wol2010_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Noonu Yeesu ne leen: «Ba ma leen yebalee te yóbbaalewuleen woon xaalis, mbuus, walla dàll, ndax ñàkkoon ngeen dara?» Ñu ne ko: «Déedéet.» ");
INSERT INTO wol2010_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Mu ne leen: «Léegi nag képp ku am xaalis, na ko jël; te ku am mbuus, na ko jël; ku amul jaasi, na jaay mbubbam, jënde ko jaasi. ");
INSERT INTO wol2010_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Ndaxte maa ngi leen koy wax, lii Mbind mi wax fàww mu am ci man, bi mu nee: “Boole nañu ko ak ñu bon ña.” Ndaxte loolu jëm ci man mi ngi mat.» ");
INSERT INTO wol2010_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Noonu taalibe ya ne ko: «Boroom bi, ñaari jaasee ngii.» Mu ne leen: «Doy na.» ");
INSERT INTO wol2010_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Noonu Yeesu génn, dem ca tundu Oliw ya, ni mu ko daan defe naka-jekk. Taalibeem ya topp ci moom. ");
INSERT INTO wol2010_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Bi mu agsee ca bérab ba, mu ne leen: «Ñaanleen, ngir baña daanu cig fiir.» ");
INSERT INTO wol2010_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Noonu mu dànd leen, ba fu aw saan mana tollu, daldi sukk di ñaan ne: ");
INSERT INTO wol2010_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","«Baay, soo ko bëggee, teggil ma kaasu naqar bii. Moona bumu doon sama coobare, waaye na sa coobare am.» ");
INSERT INTO wol2010_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Noonu malaakam Yàlla daldi koy feeñu, may ko doole. ");
INSERT INTO wol2010_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Ci biir tiis, Yeesu gëna sawar ci ñaan gi, ñaqam mel ni lumbi deret dal ci suuf. ");
INSERT INTO wol2010_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Bi mu ñaanee ba noppi, mu jóg, délsi ci taalibe yi, fekk leen ñuy nelaw, ndaxte seen xol dafa sonnoon ak tiis. ");
INSERT INTO wol2010_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Noonu mu ne leen: «Lu tax ngeen di nelaw? Jógleen ñaan, ngir baña daanu cig fiir.» ");
INSERT INTO wol2010_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Bi Yeesu di wax, mbooloo mu bare agsi; ku ñuy wax Yudaa te mu bokkoon ci fukki ndaw yi ak ñaar jiite leen. Yudaa jegeñsi Yeesu, bëgg koo fóon. ");
INSERT INTO wol2010_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Waaye Yeesu ne ko: «Ci fóon ngay jébbale Doomu nit ki ay noonam!» ");
INSERT INTO wol2010_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Bi ñi àndoon ak Yeesu gisee liy bëgga xew, ñu ne: «Boroom bi, ndax nu dóore jaasi?» ");
INSERT INTO wol2010_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Kenn ci ñoom nag dóor surgab sarxalkat bu mag ba, noppu ndijooram dagg. ");
INSERT INTO wol2010_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Waaye Yeesu daldi ne: «Bàyyileen.» Mu laal noppu waa ja, wéral ko. ");
INSERT INTO wol2010_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Noonu Yeesu ne sarxalkat yu mag ya ak kilifay wottukati kër Yàlla ga ak njiiti xeet, wa ko jàppsi woon: «Jóg ngeen, gànnaayoo jaasi ak yet, mel ni ñuy topp sàcc. ");
INSERT INTO wol2010_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Moona maa nga woon ak yéen bés bu nekk ca kër Yàlla ga, te jàppuleen ma. Waaye léegi seen waxtu la, di jamonoy lëndëm.» ");
INSERT INTO wol2010_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Ñu jàpp Yeesu, yóbbu ko ca kër sarxalkat bu mag ba. Piyeer topp fu sore. ");
INSERT INTO wol2010_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Amoon na taal ca diggu ëtt ba, ay nit toog, wër ko, Piyeer itam toog ci seen biir. ");
INSERT INTO wol2010_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Ab mbindaan gis ko, mu toog, taal bi di ko leeral, mu ne ko jàkk ne: «Nit kii itam àndoon na ak moom.» ");
INSERT INTO wol2010_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Waaye Piyeer weddi ko ne: «Soxna si, xawma kooku.» ");
INSERT INTO wol2010_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Nees-tuut keneen gis ko ne: «Yaw itam ci ñoom nga bokk.» Piyeer ne ko: «Sama waay, bokkuma ci.» ");
INSERT INTO wol2010_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Bi ñu tegee lu mat waxtu, keneen dikkaat ca wax ja ne: «Ci lu wóor nit kii àndoon na ak moom, nde Galile la jóge.» ");
INSERT INTO wol2010_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Waaye Piyeer ne ko: «Sama waay, xawma li ngay wax!» Bi kàddoom di daanu, faf ginaar daldi sab. ");
INSERT INTO wol2010_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Noonu Boroom bi geestu, xool Piyeer. Te Piyeer fàttaliku la ko Boroom bi waxoon ne: «Bala ginaar a sab tey jii, dinga ma weddi ñetti yoon.» ");
INSERT INTO wol2010_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Piyeer daldi génn, di jooy jooy yu metti. ");
INSERT INTO wol2010_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Nit ñaa nga jàppoon Yeesu, di ko ñaawal ak di ko dóor. ");
INSERT INTO wol2010_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Ñu ngi takkoon ay bëtam, di ko laaj, naan ko: «Yaw, wax nu ci kàddug Yàlla, ku la dóor?» ");
INSERT INTO wol2010_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Ñu ngi ko doon tifaar it yeneen saaga. ");
INSERT INTO wol2010_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Bi bët setee, kureelu njiiti xeet wa, maanaam sarxalkat yu mag ya ak xutbakat ya, daldi daje, indi Yeesu ci seen kanam. ");
INSERT INTO wol2010_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Ñu ne ko: «Soo dee Almasi bi, wax nu ko.» Mu ne leen: «Su ma leen ko waxee, dungeen ma gëm. ");
INSERT INTO wol2010_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Te su ma leen laajee, dungeen tontu. ");
INSERT INTO wol2010_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Waaye gannaaw-si-tey, Doomu nit ki dina toog ci ndijooru Yàlla, Aji Man ji.» ");
INSERT INTO wol2010_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Noonu ñépp ne: «Kon nag yaay Doomu Yàlla ji?» Mu ne leen: «Yéen ci seen bopp wax ngeen ne moom laa.» ");
INSERT INTO wol2010_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Ñu daldi ne nag: «Lu nuy doyeeti seede léegi, ndegam nun ci sunu bopp noo ko nangoo ci gémmiñam!» ");
INSERT INTO wol2010_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Gannaaw loolu kureelu àttekat ya yépp daldi jóg, yóbbu Yeesu ca Pilaat. ");
INSERT INTO wol2010_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Foofa ñu tàmbali di ko sosal naan: «Fekk nanu nit kii, muy fàbbi sunu réew, di leen teree fey galag Sesaar, te mi ngi teg boppam Almasi, maanaam buur.» ");
INSERT INTO wol2010_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Noonu Pilaat laaj ko: «Ndax yaa di buuru Yawut yi?» Yeesu ne ko: «Wax nga ko.» ");
INSERT INTO wol2010_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Pilaat ne sarxalkat yu mag ya ak mbooloo ma: «Gisuma genn tooñ ci nit kii.» ");
INSERT INTO wol2010_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Waaye ñu sax ci seeni wax naan: «Mi ngi jógloo mbooloo mi, di jàngle ci réewu Yawut ya mépp, li dale ci Galile ba fii.» ");
INSERT INTO wol2010_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Bi Pilaat yégee baat yooyu, mu laajte ne: «Ndax nit kii Galile la dëkk?» ");
INSERT INTO wol2010_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Bi mu yégee ne Yeesoo ngi nekk ci diiwaan bi Erodd yilif, mu yónnee ko Erodd, mi nekkoon ci jamono jooju ci Yerusalem. ");
INSERT INTO wol2010_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Bi Erodd gisee Yeesu, mu am mbég mu réy. Bu yàgg ba tey dafa koo bëggoona gis, ndaxte déggoon na ñuy wax ci ay mbiram te yaakaaroon na ne dina ko gis mu def kéemaan. ");
INSERT INTO wol2010_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Noonu mu laaj ko ay laaj yu bare, waaye Yeesu waxul dara. ");
INSERT INTO wol2010_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Sarxalkat yu mag ya ak xutbakat yaa nga fa woon, di ko jiiñ bu metti. ");
INSERT INTO wol2010_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Noonu Erodd ak ay xarekatam toroxal Yeesu, di ko ñaawal. Gannaaw loolu mu solal ko mbubb mu rafet, delloo ko Pilaat. ");
INSERT INTO wol2010_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Erodd ak Pilaat dañoo ñi bañante woon bu jëkk, waaye ca bés booba doon nañu ay xarit. ");
INSERT INTO wol2010_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Pilaat daldi woo sarxalkat yu mag ya, njiit ya ak mbooloom Yawut ya ne leen: ");
INSERT INTO wol2010_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","«Indil ngeen ma nit kii, ne ma day jàddloo yoon mbooloo mi. Léegi nag man mii laaj naa ko ci seen kanam, waaye gisuma tooñ ci moom ak li ngeen koy jiiñ lépp. ");
INSERT INTO wol2010_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Erodd itam gisul tooñ gu mu def, ndegam mu yónneewaat nu ko. Nit kii deful genn tooñ gu jar ñu koy rey. ");
INSERT INTO wol2010_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","17","Kon nag dinaa ko dóorlu ay yar te bàyyi ko.» ");
INSERT INTO wol2010_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Waaye ñu bokk di yuuxu, ñoom ñépp naan: «Reyal kii te bàyyi Barabas!» ");
INSERT INTO wol2010_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Dañoo tëjoon Barabas, ndaxte dafa jéema tas dëkk ba, te rey nit. ");
INSERT INTO wol2010_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Pilaat waxaat ak mbooloo ma, ndaxte dafa bëggoona bàyyi Yeesu. ");
INSERT INTO wol2010_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Waaye ñuy yuuxu naan: «Daaj ko ci bant! Daaj ko ci bant, ba mu dee!» ");
INSERT INTO wol2010_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Pilaat ne leen ñetteel bi yoon: «Lu tax? Gan tooñ la def? Gisuma ci moom dara lu jar dee. Kon dinaa ko dóorlu ay yar te bàyyi ko.» ");
INSERT INTO wol2010_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Waaye ñoom ñu sax ca la ñu waxoon, di gëna yuuxu naan, ñu daaj ko ci bant. Coow la yey Pilaat. ");
INSERT INTO wol2010_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Muj gi Pilaat dogal, ñu defal leen li ñu bëgg. ");
INSERT INTO wol2010_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Mu bàyyil leen ki ñu ko ñaanoon, kooku ñu tëjoon kaso, ndax tas réew ma ak rey nit. Waaye mu jébbal leen Yeesu ci seeni loxo. ");
INSERT INTO wol2010_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Bi ñuy yóbbu Yeesu, ñu jàpp ku ñuy wax Simoŋ te mu dëkk Siren, ku jóge ca wet, ga féete ak tool ya, sëf ko bant, ba ñuy wara daaj Yeesu, ngir mu gàddu ko, topp ci moom. ");
INSERT INTO wol2010_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Mbooloo mu baree nga ko toppoon, te jigéen ñu baree ngi doon yuuxu, di ko jooy. ");
INSERT INTO wol2010_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Yeesu daldi walbatiku ca ñoom ne: «Yéen jigéeni Yerusalem, buleen ma jooy! Jooyleen seen bopp ak seeni doom. ");
INSERT INTO wol2010_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Ndaxte jamono dina ñëw, ju ñu naan: “Jigéen ñi masula jur ak ñi masula nàmpal, barkeel ngeen!” ");
INSERT INTO wol2010_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Bu keroogee, “Nit ñi dinañu ne tund yi: ‘Daanuleen ci sunu kaw!’ te naan jànj yi: ‘Suul-leen nu!’ ” ");
INSERT INTO wol2010_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Ndaxte su ñu defee nii garab gu tooy gi, lu ñuy def garab gu wow gi?» ");
INSERT INTO wol2010_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Yóbbaale nañu itam ñeneen, ñuy ñaari defkati lu bon, ngir rey leen. ");
INSERT INTO wol2010_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Bi xarekat ya agsee ba ca bérab, ba ñuy wooye Kaaŋu bopp, ñu daaj fa Yeesu ca bant, daajaale ñaari defkati lu bon ya, kenn ca ndijooram, ka ca des ca càmmoñam. ");
INSERT INTO wol2010_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Ci kaw loolu Yeesu ne: «Baay, baal leen, ndaxte xamuñu li ñuy def.» Xarekat ya tegoo ay bant yéreem, ngir séddoo ko. ");
INSERT INTO wol2010_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Mbooloo maa nga fa taxaw di seetaan. Njiit ya di ko reetaan naan: «Musal na ñeneen; na musal boppam, su fekkee mooy Almasi bi, ki Yàlla fal!» ");
INSERT INTO wol2010_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Xarekat ya it di ko ñaawal. Ñu jegesi, jox ko bineegar te naan: ");
INSERT INTO wol2010_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","«Su fekkee ne yaay buuru Yawut yi, musalal sa bopp!» ");
INSERT INTO wol2010_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Ñu daaj mbind, mu tiim ko naan: «Kii mooy buuru Yawut yi.» ");
INSERT INTO wol2010_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Kenn ca defkatu lu bon ya ñu wékkoon ci bant, di ko xas, naan ko: «Xanaa du yaw yaay Almasi bi? Musalal sa bopp te musal nu!» ");
INSERT INTO wol2010_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Waaye ka ca des yedd moroom ma, naan ko: «Xanaa ragaloo Yàlla, yaw mi ñuy mbugal ni moom? ");
INSERT INTO wol2010_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Nun yelloo nanu sunu mbugal, waaye moom deful dara.» ");
INSERT INTO wol2010_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Noonu mu ne: «Yeesu, fàttaliku ma, boo délsee ci sa nguur.» ");
INSERT INTO wol2010_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Yeesu ne ko: «Ci dëgg maa ngi la koy wax, tey jii dinga texe ak man ca jataayu Yàlla.» ");
INSERT INTO wol2010_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","45","Noonu digg bëccëg daldi jot, jant ba nëbbu, réew mépp daldi lëndëm këruus lu mat ñetti waxtu. Ridob bérab bu sell ba ca kër Yàlla ga daldi xar ñaar. ");
INSERT INTO wol2010_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Yeesu woote ak kàddu gu dëgër naan: «Baay, jébbal naa la sama ruu!» Bi mu waxee loolu, mu delloo ruuwam Yàlla. ");
INSERT INTO wol2010_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Bi njiitu xare ba gisee li xewoon, mu màggal Yàlla ne: «Dëgg-dëgg nit kii ku jub la woon.» ");
INSERT INTO wol2010_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Nit ña fa dajaloo woon ñépp, di seetaan li xew, ba ñu gisee loolu, ñu dellu seen kër, fëgg seen dënn, di jooy. ");
INSERT INTO wol2010_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Xamey Yeesu yépp ak jigéen, ña ko toppe woon Galile, dànd leen, di xool li xew. ");
INSERT INTO wol2010_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","51","Nit ku ñuy wax Yuusufa dem ca Pilaat. Mi ngi dëkk Arimate ca diiwaanu Yude. Yuusufaa nga bokkoon ca kureelu àttekat yi. Nit ku baax la woon te jub, te àndul woon ci li ñu dogaloon te jëf ko. Da doon séentu nguuru Yàlla. ");
INSERT INTO wol2010_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Mu dem ca Pilaat, laaj ko néewu Yeesu. ");
INSERT INTO wol2010_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Gannaaw loolu mu wàcce ko ca bant ba, laxas ko ci càngaay, dugal ko cib bàmmeel bu ñu yett ciw doj te masuñu caa def kenn. ");
INSERT INTO wol2010_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Fekk bésu Waajal la woon, te bésub noflaay baa ngi doon tàmbali. ");
INSERT INTO wol2010_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Jigéen ña gungee woon Yeesu Galile, ànd ak Yuusufa, gis bàmmeel ba ak na ñu ca dence néewu Yeesu ba. ");
INSERT INTO wol2010_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Noonu ñu dellu defari cuuraay ak latkoloñ ngir néew ba. Ca bésub noflaay ba ñu noppalu, ni ko yoon wi santaanee. ");
INSERT INTO wol2010_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Bés bu jëkk ca ayu-bés ga, jigéen ña jóg ca fajar, dem ca bàmmeel ba. Ñu ngi yoroon cuuraay lu ñu defaroon. ");
INSERT INTO wol2010_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Bi ñu agsee, ñu fekk ñu béraŋ doj, wa uboon bàmmeel ba. ");
INSERT INTO wol2010_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Ñu dugg ca bàmmeel ba, waaye fekkuñu fa néewu Boroom bi Yeesu. ");
INSERT INTO wol2010_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Noonu ba ñu nekkee ak seen njaaxle, am na ñaar ñu leen feeñu, sol yére yuy melax. ");
INSERT INTO wol2010_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Jigéen ña am tiitaange ju mag, daldi dëpp seen jë ci suuf. Waaye ñu ne leen: «Lu tax ngeen di seet kiy dund ci biir néew yi? ");
INSERT INTO wol2010_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Nekkatu fi; dekki na. Fàttalikuleen la mu leen waxoon, ba mu nekkee Galile. ");
INSERT INTO wol2010_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","Nee woon na: “Fàww ñu jébbal Doomu nit ki bàkkaarkat yi, ñu rey ko ci bant, mu dekki ca ñetteelu fan ba.”» ");
INSERT INTO wol2010_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Noonu ñu daldi fàttaliku kàdduy Yeesu ya. ");
INSERT INTO wol2010_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Bi ñu jógee bàmmeel ba, ñu dem nettaliji loolu lépp fukki ndaw ya ak benn, ak ña ca des ñépp. ");
INSERT INTO wol2010_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Jigéen ña ñoo doon Maryaamam Magdala, Sànn, ak Maryaama yaayu Saag. Yeneen jigéen yi leen gunge woon itam nettali loolu ndaw ya. ");
INSERT INTO wol2010_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Waaye ñu teg wax jooju ay jeneer, ba gëmuñu jigéen ñooñu. ");
INSERT INTO wol2010_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Waaye Piyeer daldi jóg, daw, dem ca bàmmeel ba. Bi mu àggee, mu sëgg, yër, gisul lu dul càngaay la. Noonu mu dëpp ñibbi, jaaxle lool ci li xew. ");
INSERT INTO wol2010_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Ca bés boobu ñaar ci taalibe yi di dem ci dëkku Emayus, te mu sore Yerusalem ci lu mat fukki kilomet. ");
INSERT INTO wol2010_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Ñu waxtaane li xewoon lépp. ");
INSERT INTO wol2010_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Bi ñuy waxtaan ak a sotteente xalaat, Yeesu ci boppam dab leen, ànd ak ñoom, ");
INSERT INTO wol2010_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","fekk seeni bët muuru, ba manu ko woona xàmmi. ");
INSERT INTO wol2010_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Yeesu ne leen: «Lan ngeen di waxtaane nii ci yoon wi?» Noonu ñu taxaw, seen xol jeex. ");
INSERT INTO wol2010_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Kenn ci ñoom, ki tudd Këleyopas ne ko: «Xanaa yaw rekk yaa ñëw Yerusalem te umple li fi xewoon bés yii?» ");
INSERT INTO wol2010_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Yeesu ne leen: «Lu fi xew?» Ñu ne ko: «Mbirum Yeesum Nasaret. Ab yonent la woon bu doon def ay jëf yu mag, di wax ay kàddu yu am doole, ci kanam nit ñi ak ca kanam Yàlla. ");
INSERT INTO wol2010_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Waaye sunuy sarxalkat yu mag ak sunuy njiit ñoo ko jébbal nguur gi ngir ñu àtte ko, teg ko dee, ba daaj ko ci bant. ");
INSERT INTO wol2010_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Nun nag danoo yaakaaroon ne mooy kiy nara jot Israyil. Waaye bi loolu xewee ak léegi, tey la ñetteelu fan bi. ");
INSERT INTO wol2010_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Teewul nag am na ay jigéen yu bokk ci nun yu nu jaaxal. Dañoo fajaru ca bàmmeel ba, ");
INSERT INTO wol2010_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","waaye fekkuñu fa néewam. Ñu délsi, nettali nu ne, ay malaaka feeñu nañu leen, yégal leen ne mi ngi dund. ");
INSERT INTO wol2010_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Ñenn ci sunu àndandoo yi dem nañu ca bàmmeel ba, fekk lépp mel, na ko jigéen ña waxe woon. Waaye moom gisuñu ko.» ");
INSERT INTO wol2010_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Noonu Yeesu ne leen: «Yéen daal, yéena ñàkk xel, te seen xol yéexa gëm li yonent yi yégle woon! ");
INSERT INTO wol2010_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Xanaa du Almasi bi dafa waroona daj boobu coono te dugg ci ndamam?» ");
INSERT INTO wol2010_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Noonu mu tàmbalee ci yonent Yàlla Musaa ba ci yonent yépp, tekkil leen li Mbind mi wax lépp ci ay mbiram. ");
INSERT INTO wol2010_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Bi ñuy jub dëkk, ba ñu jëmoon nag, Yeesu def ni kuy jubal yoonam. ");
INSERT INTO wol2010_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Waaye ñu téye ko ne ko: «Toogal fii ci nun, ndaxte jant baa ngi so, te léegi mu guddi.» Noonu mu dugg, toog ca ñoom. ");
INSERT INTO wol2010_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Bi ñu tàmbali di reer, Yeesu jël mburu ma, gërëm Yàlla, ba noppi damm ko, jox leen ko. ");
INSERT INTO wol2010_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Bi mu defee loolu, lépp leer ci seeni bët, ñu daldi ko xàmmi. Waaye Yeesu ne mes, gisatuñu ko. ");
INSERT INTO wol2010_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Noonu ku nekk naan sa moroom: «Ndax sa xol seddul woon, bi muy wax ak nun ci yoon wi, te muy tekki Mbind mi?» ");
INSERT INTO wol2010_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Ñu daldi jóg ca saa sa, dellu Yerusalem, fekk fa fukki ndaw ya ak benn, ak yeneen taalibe. ");
INSERT INTO wol2010_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Ñooñu ne leen: «Dëgg la, Boroom bi dekki na, te feeñu na Simoŋ!» ");
INSERT INTO wol2010_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Ñaari taalibe ya ñoom it daldi leen nettali la xewoon ca yoon wa ak ni ñu xàmmee Yeesu, bi mu dammee mburu ma. ");
INSERT INTO wol2010_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Bi ñaari taalibe ya dee wax noonu, Yeesu taxaw moom ci boppam ci seen biir ne leen: «Na jàmm wàcc ci yéen.» ");
INSERT INTO wol2010_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Ñu daldi tiit, foog ne dañoo gis njuuma. ");
INSERT INTO wol2010_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Waaye Yeesu ne leen: «Lu tax ngeen jaaxle, ak lu tax ngeen di xel ñaar ci seen xol? ");
INSERT INTO wol2010_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Xool-leen samay loxo ak samay tànk. Man mii la. Laal-leen ma te xam, njuuma amul yaram walla ay yax, ni ngeen gise, ma am ko.» ");
INSERT INTO wol2010_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Bi mu leen waxee loolu, mu won leen ay loxoom ak ay tànkam. ");
INSERT INTO wol2010_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Waaye ba tey manuñu woona gëm ndax seen mbég ak jaaxle. Noonu Yeesu laaj leen ne: «Ndax am ngeen fii lu ñu lekk?» ");
INSERT INTO wol2010_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Ñu jox ko dogu jën wu ñu lakk. ");
INSERT INTO wol2010_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Mu jël ko, lekk ci seen kanam. ");
INSERT INTO wol2010_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Noonu mu ne leen: «Bi ma nekkee ak yéen, waxoon naa leen baat yii: li ñu bind lépp ci samay mbir ci yoonu Musaa ak ci téerey yonent yi ak ci Sabóor dafa wara am.» ");
INSERT INTO wol2010_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Noonu mu ubbi seen xel, ngir ñu xam li Mbind mi di wax. ");
INSERT INTO wol2010_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Mu ne leen: «Fàww Almasi bi sonn, mu dee te dekki ca ñetteelu fan ba, ni ñu ko binde, ");
INSERT INTO wol2010_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","te it ñuy yégle xeet yépp ci turam, dale ko ci Yerusalem ne war nañoo tuub seeni bàkkaar, Yàlla baal leen. ");
INSERT INTO wol2010_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Yéenay samay seede. ");
INSERT INTO wol2010_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Te man dinaa leen yónnee li sama Baay dige. Yéen nag toogleen ci dëkk bi, ba ñu sol leen doole ji jóge ci kaw.» ");
INSERT INTO wol2010_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Gannaaw loolu Yeesu yóbbu leen ca wetu Betani. Foofa mu yékkati ay loxoom, barkeel leen. ");
INSERT INTO wol2010_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Bi mu leen dee barkeel, mu tàggoo ak ñoom, Yàlla yéege ko asamaan. ");
INSERT INTO wol2010_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Taalibe ya màggal ko, daldi dellu Yerusalem, fees ak mbég. ");
INSERT INTO wol2010_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Foofa daawuñu jóg ca kër Yàlla ga, di gërëm Yàlla. ");
INSERT INTO wol2010_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Ca njàlbéen ga fekk na Kàddu gi am, te Kàddu gi ma nga woon ak Yàlla, te Kàddu gi Yàlla la woon. ");
INSERT INTO wol2010_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Moo di ki nekkoon ak Yàlla ca njàlbéen ga. ");
INSERT INTO wol2010_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Ci moom lañu sàkke lépp. Amul dara lu ñu sàkk lu jaarul ci moom. ");
INSERT INTO wol2010_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Ci moom la dund nekk, te dund googu mooy leeral nit ñi. ");
INSERT INTO wol2010_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Leer gi feeñ na ci biir lëndëm, te lëndëm gi jàppu ko. ");
INSERT INTO wol2010_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Yàlla yónni woon na nit ku ñu naan Yaxya. ");
INSERT INTO wol2010_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Kooku ñëw na, doon ab seede, ngir wax ci mbirum leer gi. Ñëw na ngir ñépp dégg li mu wax te gëm. ");
INSERT INTO wol2010_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Moom ci boppam du woon leer gi, waaye ñëw na ngir seedeel leer gi. ");
INSERT INTO wol2010_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Kàddu googu mooy leer gu wóor, giy ñëw ci àddina te di leeral nit ku nekk. ");
INSERT INTO wol2010_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Ci àddina la nekkoon, àddina si ñu sàkk jaarale ko ci moom, te àddina xamu ko. ");
INSERT INTO wol2010_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Ñëw na ci réewam, te ay ñoñam nanguwuñu ko. ");
INSERT INTO wol2010_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Teewul ñi ko nangu te gëm ci turam, may na leen, ñu am sañ-sañu nekk doomi Yàlla. ");
INSERT INTO wol2010_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Ñooñu judduwuñu ci deret walla ci bëgg-bëggu yaram, walla ci coobarey nit. Ñu ngi juddu ci Yàlla. ");
INSERT INTO wol2010_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Kàddu gi ñëw, doon nit, dëkk ci sunu biir. Gis nañu ndamam, mu fees ak yiw ak dëgg, ndam li Baay bi jox jenn Doomam ji mu am kepp. ");
INSERT INTO wol2010_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Yaxyaa ngi koy seedeel te yégle na lii; nee na: «Moo taxoon ma wax ne: “Dina ñëw sama gannaaw waaye moo ma gëna màgg, ndaxte nekk na laata may juddu.”» ");
INSERT INTO wol2010_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Kàddu gi fees na ak yiw, te nun ñépp jot nanu ci sunu wàll, mu barkeel nu ay yooni yoon. ");
INSERT INTO wol2010_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Ndigali Yàlla yi, ci gémmiñu Musaa lañu leen jaarale; yiw wi ak dëgg gi, Yeesu Kirist moo ko indaale. ");
INSERT INTO wol2010_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Kenn masula gis Yàlla, waaye Bàjjo bi, di Yàlla te nekk ak Baay bi, moo ko xamle. ");
INSERT INTO wol2010_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Lii mooy seedes Yaxya. Amoon na bés Yawut ya yónni ay sarxalkat ca Yaxya, ñu ànd ak ñu soqikoo ci giiru Lewi. Ñu nga jóge Yerusalem, ñëw ci moom, di ko laaj mooy kan. ");
INSERT INTO wol2010_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Yaxya tontu na leen te nëbbu ci dara, wóoral na leen ne moom du Almasi bi. ");
INSERT INTO wol2010_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Ñu laaj ko ne: «Kon yaay kan? Ndax yaa di Ilyaas?» Mu ne leen: «Déedéet, duma Ilyaas.» Ñu ne ko: «Ndax yaa di Yonent, bi wara ñëw?» Mu ne leen: «Déedéet.» ");
INSERT INTO wol2010_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Noonu ñu laaj ko ne: «Wax nu yaay kan, ngir nu mana tontu ñi nu yónni. Nga ne yaa di kan?» ");
INSERT INTO wol2010_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Yaxya wax leen li yonent Yàlla Esayi waxoon ne: «Man maa di baat biy yégle ci màndiŋ mi ne: “Xàll-leen yoonu Boroom bi!”» ");
INSERT INTO wol2010_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Amoon na ñu bokk ca Farisen ya, yu àndoon ca mbooloo, ma ñu yónni woon ca Yaxya. ");
INSERT INTO wol2010_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Ñooñu laaj ko ne: «Gannaaw doo Almasi bi, doo Ilyaas, doo Yonent bi wara ñëw, lu tax ngay sóob nit ñi ci ndox?» ");
INSERT INTO wol2010_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Yaxya ne leen: «Man maa ngi sóobe ci ndox, waaye am na ci seen biir ku ngeen xamul. ");
INSERT INTO wol2010_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Kookooy ñëw sama gannaaw, te man sax yeyoowumaa tekki ay dàllam.» ");
INSERT INTO wol2010_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Lii xewoon na ci dëkku Betani, ca gannaaw dexu Yurdan, fa Yaxya doon sóobe. ");
INSERT INTO wol2010_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Ca ëllëg sa, bi Yaxya gisee Yeesu, muy ñëw ci moom, mu ne: «Xool-leen! Kii mooy Gàttub Yàlla, bi ñu nara rendi, ngir dindi bàkkaaru àddina. ");
INSERT INTO wol2010_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Moo taxoon ma wax ne: “Am na kuy ñëw sama gannaaw, waaye moo ma gëna màgg, ndaxte nekk na laata may juddu.” ");
INSERT INTO wol2010_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Xawma woon kooku kan la waroona doon, waaye xamal ko bànni Israyil moo tax ma ñëw, di sóob nit ñi ci ndox.» ");
INSERT INTO wol2010_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Ci kaw loolu Yaxya seede na lii: «Gis naa Xelu Yàlla mi ci melow pitax, mu jóge ci asamaan, tegu ci moom. ");
INSERT INTO wol2010_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Bi loola laata am, xawma woon mooy kan, waaye Yàlla, mi ma yebal may sóobe ci ndox, nee woon na ma: “Dinga gis Xel mu Sell mi wàcc, tegu ci kaw nit. Kooku moo di ki leen di sóob ci Xel mu Sell mi.”» ");
INSERT INTO wol2010_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Yaxya teg ca ne: «Gis naa loolu te seede naa ne moom moo di Doomu Yàlla ji.» ");
INSERT INTO wol2010_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Ca ëllëg sa Yaxya taxawaatoon na ca bérab booba, ànd ak ñaari taalibeem. ");
INSERT INTO wol2010_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Bi mu gisee Yeesu muy romb, mu daldi ne: «Kii mooy Gàttub Yàlla bi!» ");
INSERT INTO wol2010_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Ñaari taalibe ya dégg li mu wax, daldi dem toppi Yeesu. ");
INSERT INTO wol2010_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Yeesu geestu, gis ne ñoo ngi koy topp. Mu ne leen: «Lu ngeen soxla woon?» Ñu ne ko: «Foo dëkk, Ràbbi?» Ràbbi mi ngi tekki «Kilifa gi». ");
INSERT INTO wol2010_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Yeesu ne leen: «Kaayleen gis.» Noonu ñu dem, seeti fa mu daloon, ngoonalal ko. Ci tàkkusaani kaw la woon. ");
INSERT INTO wol2010_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Kenn ci ñoom ñaar, ñi déggoon li Yaxya wax te topp Yeesu, ma nga tuddoon Andare, mi bokkoon ak Simoŋ Piyeer ndey ak baay. ");
INSERT INTO wol2010_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Andare dafa daldi dem seeti Simoŋ ne ko: «Gis nanu Almasi bi.» Baat boobu mi ngi tekki «Kirist». ");
INSERT INTO wol2010_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Noonu mu yóbbu ko ci Yeesu. Yeesu xool ko ne ko: «Yaa di Simoŋ, doomu Yowaana. Dinañu la wooye Sefas.» Sefas mi ngi tekki «Piyeer», maanaam «xeer». ");
INSERT INTO wol2010_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Ca ëllëg sa mu fas yéenee dem diiwaanu Galile te mu gis Filib. Yeesu ne ko: «Toppal ci man.» ");
INSERT INTO wol2010_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Filib mu nga dëkkoon Betsayda, dëkku Andare ak Piyeer. ");
INSERT INTO wol2010_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Filib dajeek Nataneel ne ko: «Gis nanu ki yoonu Musaa wi ak yonent yi doon wax. Mu ngi tudd Yeesu, doomu Yuusufa, te dëkk Nasaret.» ");
INSERT INTO wol2010_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Nataneel ne ko: «Aa! Ndax dara lu baax man na jóge Nasaret?» Filib ne ko: «Ñëwal gis.» ");
INSERT INTO wol2010_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Naka la Yeesu gis Nataneel jëmsi ci moom, mu daldi ne ci mbiram: «Xool-leen, nitu Israyil dëgg a ngee di ñëw; du dox benn tànku caaxaan.» ");
INSERT INTO wol2010_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Nataneel ne ko: «Noo ma xame?» Yeesu ne ko: «Bi la Filib di laata woo, gis naa la, bi nga nekkee ca ker garabu figg ga.» ");
INSERT INTO wol2010_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Nataneel wax ko ne: «Kilifa gi, yaay Doomu Yàlla ji, yaa di buuru Israyil!» ");
INSERT INTO wol2010_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Yeesu ne ko: «Ndax li ma ne, gis naa la ca ker garab ga, moo tax nga gëm? Dinga gis mbir yu gëna réy yii.» ");
INSERT INTO wol2010_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Noonu mu teg ca ne: «Ci dëgg-dëgg maa ngi leen koy wax, dingeen gis asamaan ubbiku, malaaka yiy baagante kaw ak suuf, di wàcc ci Doomu nit ki.» ");
INSERT INTO wol2010_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Ñaari fan gannaaw loolu ag céet am ca dëkku Kana ca diiwaanu Galile. Yaayu Yeesu teewe woon na ko. ");
INSERT INTO wol2010_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Woo woon nañu it Yeesu ca céet ga ak ay taalibeem. ");
INSERT INTO wol2010_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Ca biir xew wa, biiñ ba daldi jeex. Yaayu Yeesu ne ko: «Amatuñu biiñ.» ");
INSERT INTO wol2010_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Yeesu ne: «Soxna si, loo ma bëggal? Ndaxte sama waxtu jotagul.» ");
INSERT INTO wol2010_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Yaayam daldi ne surga ya: «Defleen lépp lu mu leen wax.» ");
INSERT INTO wol2010_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Foofa amoon na fa juróom benni ndaa yu ñu yett ci doj, yu Yawut ya daan jëfandikoo ngir seen sangu set. Ndaa lu nekk man na def daanaka téeméeri liitar. ");
INSERT INTO wol2010_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Yeesu ne surga ya: «Duyleen ndaa yi.» Ñu duy leen, ba ñu fees bay rembat. ");
INSERT INTO wol2010_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Noonu Yeesu ne leen: «Tanqleen ci léegi, yót ko njiitu xew wi.» Ñu daldi ko ciy yót. ");
INSERT INTO wol2010_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Ki jiite xew wa ñam ndox, ma Yeesu soppi biiñ. Xamul woon fu biiñ booba jóge, waaye surga ya tanqoon ndox ma, ñoom xamoon nañu ko. Naka noonu mu woo boroom céet ga ne ko: ");
INSERT INTO wol2010_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","«Ci xew yépp, naan gu neex gi lañuy jëkke. Bu nit ñi doyalee, ñu sooga génne ga ca des. Waaye yaw dangaa dencoon gi gëna neex ba nëgëni.» ");
INSERT INTO wol2010_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Firnde jii ame ca Kana, ca diiwaanu Galile, moo doon kéemaan gi Yeesu jëkka def. Ci noonu la wonee màggaayam te ay taalibeem gëm nañu ko. ");
INSERT INTO wol2010_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Bi loolu weesoo, mu ànd ak yaayam, ay rakkam ak i taalibeem, dem dëkku Kapernawum. Waaye yàgguñu fa. ");
INSERT INTO wol2010_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Màggalu Yawut, gi ñuy wax bésu Mucc ba, mu ngi doon jubsi. Yeesu dem Yerusalem, ");
INSERT INTO wol2010_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","dugg ca kër Yàlla ga. Bi mu fa demee, fekk na ca ëtt ba ay jaaykati nag ak yu xar ak yu pitax, ak weccikatu xaalis ya toog. ");
INSERT INTO wol2010_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Noonu Yeesu ràbb ab yar, daldi leen koy dàqe, ngir ñu génn ëttu kër Yàlla ga, ñoom ak xar ya ak nag ya. Mu tasaare xaalisu weccikat ya, daaneel taabal ya, ");
INSERT INTO wol2010_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","daldi ne jaaykati pitax ya: «Jëleleen fi lii! Sama kër Baay, buleen ko def marse!» ");
INSERT INTO wol2010_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Taalibeem ya fàttaliku Mbind mii: «Cawarte gi ma am ci sa kër, mu ngi mel ni taal buy tàkk ci sama biir.» ");
INSERT INTO wol2010_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Noonu Yawut ya ne ko: «Ban firnde nga nuy won ngir dëggal ne am nga sañ-sañu def lii nga def?» ");
INSERT INTO wol2010_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Yeesu ne leen: «Daaneel-leen kër Yàlla gii, ma daldi koy yékkati ci ñetti fan.» ");
INSERT INTO wol2010_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Ñu ne ko: «Nga ne kër Yàlla, gii ñu tabax ci ñeent fukki at ak juróom benn, man nga koo yékkati ci ñetti fan!» ");
INSERT INTO wol2010_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Waaye kër Yàlla, gi Yeesu doon wax, nekkul woon ab tabax, aw yaramam ci boppam moo ko taxoon di wax. ");
INSERT INTO wol2010_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Gannaaw ga nag, bi Yeesu deeyee ba dekki, la taalibeem ya fàttaliku li mu waxoon, daldi gëm Mbind mi ak wax, ja leen Yeesu waxoon. ");
INSERT INTO wol2010_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Bi Yeesu nekkee Yerusalem ci màggalu bésu Mucc ba, ñu bare gis kéemaan, yi mu doon def, daldi gëm ci turam. ");
INSERT INTO wol2010_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Waaye Yeesu wóoluwu leen woon, ndaxte xamoon na leen ñoom ñépp, ");
INSERT INTO wol2010_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","te it soxlawul ñu koy xamal dara ci nit, ndaxte moom ci boppam xam na xolu nit. ");
INSERT INTO wol2010_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Amoon na ca Farisen ya nit ku ñu naan Nikodem te mu bokk ca kilifay Yawut ya. ");
INSERT INTO wol2010_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Genn guddi mu ñëw ca Yeesu ne ko: «Kilifa gi, xam nanu ne Yàllaa la yónni ngir nga jàngal nu, ndaxte kenn manula def firnde yii ngay wone te Yàlla àndul ak moom.» ");
INSERT INTO wol2010_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Yeesu ne ko: «Ci dëgg-dëgg maa ngi la koy wax, képp ku judduwaatul doo mana seede nguuru Yàlla.» ");
INSERT INTO wol2010_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Nikodem ne ko: «Nit ku xas ba màggat, nan lay mana judduwaate? Ndax day dellu ci biiru yaayam ngir judduwaat?» ");
INSERT INTO wol2010_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Yeesu ne ko: «Ci dëgg-dëgg maa ngi la koy wax, ku judduwul ci ndox ak ci Xelum Yàlla, doo mana bokk ci nguuru Yàlla. ");
INSERT INTO wol2010_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Lu juddoo ci nit, nit la; waaye lu juddoo ci Xelum Yàlla, xel la. ");
INSERT INTO wol2010_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Li ma ne: “Fàww ngeen judduwaat,” bumu la jaaxal. ");
INSERT INTO wol2010_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Ngelaw fu ko neex lay jublu. Yaa ngi koy dégg waaye xamuloo fu mu jóge, xamuloo fu mu jëm. Noonu la mel it ci képp ku juddoo ci Xelum Yàlla.» ");
INSERT INTO wol2010_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Ci baat yooyu Nikodem ne ko: «Nu loolu mana ame?» ");
INSERT INTO wol2010_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Yeesu ne ko: «Yaw yaay jàngal bànni Israyil te xamuloo mbir yii? ");
INSERT INTO wol2010_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Ci dëgg-dëgg maa ngi la koy wax, noo ngi wax li nu xam, di nettali li nu gis, waaye nanguwuleena gëm li nu seede. ");
INSERT INTO wol2010_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Gannaaw gëmuleen li ma leen di wax ci mbiri àddina, naka ngeen mana gëme, bu ma leen waxee ci mbiri asamaan? ");
INSERT INTO wol2010_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Kenn masula yéeg ci asamaan su dul ki fa jóge, muy Doomu nit ki. ");
INSERT INTO wol2010_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Te itam na Musaa sampe woon ab bant ca diggu màndiŋ ma, takk ca jaan, ja mu defare woon xànjar, fàww ñu yékkatee noonu Doomu nit ki, ");
INSERT INTO wol2010_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","ngir képp ku ko gëm am ci moom dund gu dul jeex.» ");
INSERT INTO wol2010_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Ndaxte Yàlla dafa bëgg àddina, ba joxe jenn Doomam ji mu am kepp, ngir képp ku ko gëm am dund gu dul jeex te doo sànku mukk. ");
INSERT INTO wol2010_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Yàlla yónniwul Doomam ci àddina ngir mu daan nit ñi, waaye ngir musal leen. ");
INSERT INTO wol2010_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Képp ku ko gëm deesu la daan, waaye ku ko gëmul daan nañu la ba noppi, ndaxte gëmuloo ci turu Doom ji Yàlla am kepp. ");
INSERT INTO wol2010_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Ci nii la àtte bi ame: leer gi ñëw na ci àddina, waaye nit lëndëm gi lañu taamu ndax seeni jëf yu bon. ");
INSERT INTO wol2010_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Képp kuy def lu bon day bañ leer gi te du ci ñëw, ndax ragal ay jëfam di feeñ bëccëg ndarakàmm. ");
INSERT INTO wol2010_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Waaye ku def lu jub day ñëw ci leer gi, ngir ñu xam ne def na ay jëfam ci kanam Yàlla. ");
INSERT INTO wol2010_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Gannaaw loolu Yeesu ànd ak ay taalibeem, dem ca biir diiwaanu Yude, toog fa ak ñoom ab diir, di sóob nit ñi ci ndox. ");
INSERT INTO wol2010_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Yaxya moom itam doon na sóobe ci ndox ci dëkku Aynon, ca wetu dëkku Salim, ndaxte diiwaan booba bare woon na ndox. Nit ñi daan nañu ñëw ci moom, mu di leen sóob. ");
INSERT INTO wol2010_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Booba tëjaguñu Yaxya ci kaso. ");
INSERT INTO wol2010_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Foofa ay taalibey Yaxya tàmbalee werante ak benn Yawut ci mbirum sangu set. ");
INSERT INTO wol2010_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Ci kaw loolu ñu dem ca Yaxya ne ko: «Kilifa gi, ndax fàttaliku nga kooka nga seede woon te mu nekkoon ak yaw ca gannaaw dexu Yurdan? Moom de, ma ngay sóobe ci ndox léegi te ñépp a ngay dem ca moom!» ");
INSERT INTO wol2010_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Yaxya ne leen: «Kenn manula am dara lu ko Yàlla joxul. ");
INSERT INTO wol2010_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Yéen ci seen bopp man ngeena seede ne waxoon naa ne duma Almasi bi waaye dañu maa yónni ma jiitusi ko. ");
INSERT INTO wol2010_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Kiy céetal moo moom séetam. Waaye xaritu kiy céetal dafay taxaw di ko déglu, tey bég, bu déggee baatam. Mbég moomu moo di sama bos tey, te fi mu nekk mat na sëkk. ");
INSERT INTO wol2010_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Li war moo di moom, mu gëna màgg te man, ma gëna féete suuf.» ");
INSERT INTO wol2010_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Ki jóge ci kaw moo féete kaw ñépp; ki jóge ci suuf nag, ci suuf rekk la mana bokk, te ni niti àddina lay waxe. Ki jóge asamaan ");
INSERT INTO wol2010_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","day wax li mu gis ak li mu dégg, waaye kenn nanguwul li mu seede. ");
INSERT INTO wol2010_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Képp ku nangu seedeem nangu nga ne Yàlla, dëgg lay wax. ");
INSERT INTO wol2010_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Ndaw li Yàlla yónni, kàddug Yàlla lay wax, ndaxte mayu Xel mu Sell, mi Yàlla sol ci moom, amul dayo. ");
INSERT INTO wol2010_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Baay bi dafa bëgg Doom ji, te jox na ko sañ-sañ ci lépp. ");
INSERT INTO wol2010_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Ku gëm Doom ji, am nga dund gu dul jeex; ku déggadil Doom ji, amuloo dund, waaye merum Yàllaa ngi la tiim. ");
INSERT INTO wol2010_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Amoon na benn bés Farisen yi dégg ne, ñiy topp Yeesu ñoo ëpp ñiy topp Yaxya, te ñi Yeesu sóob ci ndox ñoo ëpp ñi Yaxya sóob. ");
INSERT INTO wol2010_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","Fekk Yeesu moom ci boppam daawul sóob kenn ci ndox, waaye ay taalibeem ñoo daan sóobe. ");
INSERT INTO wol2010_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Bi Yeesu yégee loolu nag, mu jóge Yude, dellu diiwaanu Galile. ");
INSERT INTO wol2010_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Bi muy dem Galile, waroon na jaar ci diiwaanu Samari. ");
INSERT INTO wol2010_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Noonu mu agsi ci wetu dëkku Sikar ci tool, bi Yanqóoba mayoon doomam Yuusufa. ");
INSERT INTO wol2010_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Foofa la teenu Yanqóoba nekkoon. Yeesu toog ca pindu teen ba, di noppalu ndax coonob tukki ba. Ca digg bëccëg la woon. ");
INSERT INTO wol2010_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Noonu jigéenu waa Samari ñëw fa di root. Yeesu ne ko: «May ma ndox, ma naan.» ");
INSERT INTO wol2010_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","Fekk booba nag, taalibey Yeesu ya dañoo demoon ca biir dëkk ba, di jënd lu ñu lekk. ");
INSERT INTO wol2010_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Jigéen ja ne ko: «Yaw, ngay Yawut, man maay jigéen ju dëkk Samari; nan nga ma mana ñaane ndox?» Jigéen ja wax na loolu, ndaxte Yawut ya bokkuñu woon ak waa Samari ndab yu ñuy lekke. ");
INSERT INTO wol2010_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Noonu nag Yeesu ne ko: «Soo xamoon li Yàlla maye, xam ki lay ñaan ndox, kon yaw ci sa bopp, yaa koy ñaan, te moom dina la may ndoxum dund.» ");
INSERT INTO wol2010_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Jigéen ja ne ko: «Sang bi, teen bi xóot na te amuloo baag, kon fooy jële ndoxum dund? ");
INSERT INTO wol2010_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Xanaa kay xalaatuloo ne yaa gëna màgg sunu maam Yanqóoba, moom mi nu gasal teen bii, mu naan ci moom ak i doomam, wëgg cig juram?» ");
INSERT INTO wol2010_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Yeesu wax ko ne: «Ku naan ci ndoxum teen bii, balaa yàgg mu maraat, ");
INSERT INTO wol2010_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","waaye ndox mi may joxe, ku ci naan du marati mukk, ndaxte day nekk ci moom bëtu ndox buy ball, di joxe dund gu dul jeex.» ");
INSERT INTO wol2010_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Noonu jigéen ja daldi ko ne: «Sang bi, may ma ci ndox moomu, ngir ma bañatee mar, bay ñëw ba fii di rootsi.» ");
INSERT INTO wol2010_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Yeesu ne ko: «Demal wooyi sa jëkkër te ñëw.» ");
INSERT INTO wol2010_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Jigéen ja ne ko: «Awma jëkkër de.» Yeesu ne ko: «Wax nga dëgg ne amuloo jëkkër, ");
INSERT INTO wol2010_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","ndaxte amoon nga juróomi jëkkër, te ki nga nekkal léegi du sa jëkkër. Li nga wax dëgg la.» ");
INSERT INTO wol2010_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Jigéen ja ne ko: «Sang bi, gis naa ne ab yonent nga. ");
INSERT INTO wol2010_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Nun nag, naka-jekk sunuy maam ca tund wee ngay séen lañu daan jaamoo Yàlla, waaye yéen Yawut yi, dangeen ne Yerusalem lañu wara jaamoo Yàlla.» ");
INSERT INTO wol2010_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Yeesu ne ko: «Jigéen ji, gëmal lii ma lay wax: dina am jamono joo xam ne du ci tund wale te du ci Yerusalem ngeen di jaamoo Baay bi. ");
INSERT INTO wol2010_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Yéen waa Samari, xamuleen li ngeen di jaamu. Nun Yawut yi, xam nanu li nuy jaamu, ndaxte kiy musal àddina ci Yawut yi la jóge. ");
INSERT INTO wol2010_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Waaye jamono dina ñëw, te agsi na ba noppi, jamono joo xam ne jaamukat yi dëgg dinañu jaamu Baay bi ci xel ak ci dëgg. Ñooñu nag, ñooy jaamu Baay bi, ni mu ko bëgge. ");
INSERT INTO wol2010_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Yàlla xel la, kon ñi koy jaamu war nañu koo jaamu ci xel ak ci dëgg.» ");
INSERT INTO wol2010_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Jigéen ja ne ko: «Xam naa ne Almasi bi —maanaam Kirist— dina ñëw te bu ñëwee, dina nu leeralal lépp.» ");
INSERT INTO wol2010_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Yeesu ne ko: «Maa di Almasi bi, man miy wax ak yaw.» ");
INSERT INTO wol2010_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Noonu nag taalibey Yeesu ya délsi, gis muy wax ak ab jigéen. Ñu daldi jaaxle lool. Waaye kenn ñemewu ko woon ne: «Looy laaj?» walla: «Lu tax ngay wax ak moom?» ");
INSERT INTO wol2010_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Noonu jigéen ja wacc fa njaqam, daldi dem ca dëkk ba ne leen: ");
INSERT INTO wol2010_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","«Kaayleen gis; nit a nga fee ku ma wax lépp lu ma masa def. Ndax kooku du Almasi bi?» ");
INSERT INTO wol2010_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Noonu waa dëkk ba jóg, jëm ca Yeesu. ");
INSERT INTO wol2010_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Fekk taalibey Yeesu ya di ko gétën ne: «Kilifa gi, lekkal.» ");
INSERT INTO wol2010_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Waaye Yeesu ne leen: «Am na ñam wu may lekk, te xamuleen ko.» ");
INSERT INTO wol2010_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Taalibe ya nag di laajante naan: «Ndax dafa am ku ko indil lekk?» ");
INSERT INTO wol2010_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Yeesu ne leen: «Sama ñam moo di def coobarey ki ma yónni te àggale liggéey, bi mu ma sant. ");
INSERT INTO wol2010_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Du dangeen naan: “Fii ak ñeenti weer ñu góob”? Waaye man, dama leen naan: xool-leen tool yi, ñoo ngi ñor ba weex tàll, di xaar ku leen góob. ");
INSERT INTO wol2010_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Kiy góob tool yi mu ngi jot xaat peyam; day dajale nit ñi ngir dund gu dul jeex, ni ñuy dajalee pepp. Kon boog kiy ji dina bégandoo ak kiy góob. ");
INSERT INTO wol2010_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Wax ji ñu wax ne: “Kenn dina ji, keneen góob,” dëgg la. ");
INSERT INTO wol2010_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Yebal naa leen, ngeen góob tool bu ngeen beyul. Ñeneen a ko bey, te yéena ko jariñoo.» ");
INSERT INTO wol2010_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Bi jigéen ja nee waa dëkk ba: «Wax na ma li ma def lépp,» ñu bare gëm nañu Yeesu. ");
INSERT INTO wol2010_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Ñu daldi dikk ñaan Yeesu, mu dal ak ñoom. Yeesu toog fa ñaari fan. ");
INSERT INTO wol2010_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Ñu bare gëm ko ndax li mu doon wax. ");
INSERT INTO wol2010_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Ñu ne jigéen ja: «Léegi gëm nanu, te du li nga wax moo tax waaye li nu gisal sunu bopp. Te xam nanu ne dëgg-dëgg kii moo di Musalkatu àddina si.» ");
INSERT INTO wol2010_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Bi Yeesu amee ñaari fan ca dëkk ba, mu jóge fa, jëm diiwaanu Galile, ");
INSERT INTO wol2010_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","ndaxte moom ci boppam nee woon na: «Ab yonent, kenn du ko faaydaal ca réewam.» ");
INSERT INTO wol2010_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Bi mu agsee Galile, nit ñi teeru ko, ndaxte ñoom itam teewoon nañu ca màggalu bésu Mucc ba ca Yerusalem, te gisoon nañu la mu fa defoon lépp. ");
INSERT INTO wol2010_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Noonu kon mu délsi Kana ci Galile, dëkk ba mu soppee woon ndox ma biiñ. Amoon na benn dagu buur bu dëkkoon Kapernawum te doomam feebar. ");
INSERT INTO wol2010_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Bi mu déggee ne, Yeesu jóge na Yude, ñëw Galile, mu dikk ci moom, ñaan ko mu ñëw këram, wéral doomam, ji wopp bay bëgga dee. ");
INSERT INTO wol2010_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Yeesu ne ko: «Yéen daal, dungeen gëm mukk, fi ak gisuleen ay firnde walla ay kéemaan.» ");
INSERT INTO wol2010_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Dagu buur ba neeti ko: «Sang bi, ñëwal, bala sama doom di dee.» ");
INSERT INTO wol2010_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Yeesu ne ko: «Demal, sa doom dina dund.» Kilifa ga gëm la ko Yeesu wax, daldi dem. ");
INSERT INTO wol2010_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Bi muy dellu këram nag, ay surgaam gatandu ko. Ñu daldi ne ko: «Xale bi dina dund!» ");
INSERT INTO wol2010_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Mu laaj leen ci ban waxtu la tàmbalee tane, ñu ne ko: «Démb ca njolloor la am ag féex.» ");
INSERT INTO wol2010_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Noonu baayu xale ba daldi seetlu ne, ca waxtu woowa la ko Yeesu ne woon: «Sa doom dina dund.» Moom ak njabootam gépp, ñu daldi gëm Yeesu. ");
INSERT INTO wol2010_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Lii mooy ñaareelu firnde, bi Yeesu def ci Galile, gannaaw bi mu jógee Yude. ");
INSERT INTO wol2010_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Gannaaw loolu Yawut ya amoon nañu genn màggal, moo tax Yeesu demoon Yerusalem. ");
INSERT INTO wol2010_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Ca wetu benn ci bunti dëkk ba nag, maanaam ca Buntu xar ya, am na fa bët bu tudd Betesda ci làkku yawut, te ñu wërale ko ak juróomi mbaar. ");
INSERT INTO wol2010_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Ca suufu mbaar yooyu la jarag yu bare, yu deme niki ay gumba, ay lafañ ak ay làggi, daan tëdd, di xaar ndox mi yëngatu; ");
INSERT INTO wol2010_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","ndaxte, ci ni ñu ko nettalee, benn malaakam Boroom bi da daan wàcc léeg-léeg di jax ndox mi. Bu ndox mi masaa yëngu ba noppi, jarag ju ca jiitu, wopp joo amaan, daldi wér ca saa sa. ");
INSERT INTO wol2010_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Amoon na fa benn waay bu feebaroon lu mat fanweeri at ak juróom ñett. ");
INSERT INTO wol2010_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Bi ko Yeesu séenee mu tëdd, te mu xam ne woppam ji yàggoon na lool, mu laaj ko ne: «Ndax bëgg ngaa wér?» ");
INSERT INTO wol2010_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Jarag ja ne ko: «Sang bi, duma am ku ma sóob ci ndox mi, bu yëngoo; su ma ciy fexee dem, ñu jëkk ma ci.» ");
INSERT INTO wol2010_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Yeesu ne ko: «Jógal, jël sa basaŋ te dox.» ");
INSERT INTO wol2010_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Ca saa sa mu daldi wér, jël basaŋam, daldi dox. Mbir moomu dafa daje woon ak bésub noflaay ba, ");
INSERT INTO wol2010_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","looloo tax ba Yawut ya daldi ne nit ku wér ka: «Tey bésub noflaay la, te sunu yoon aaye na, ngay yor sa basaŋ.» ");
INSERT INTO wol2010_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Mu ne leen: «Ki ma faj moo ma ne: “Jëlal sa basaŋ te dox.”» ");
INSERT INTO wol2010_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Ñu ne ko nag: «Ku la ne: “Jëlal sa basaŋ te dox”?» ");
INSERT INTO wol2010_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Waaye waa ji xamul ki ko wéral, fekk booba Yeesu dem na, te nit ñu bare teewoon nañu ca bérab ba. ");
INSERT INTO wol2010_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Bi ñu ca tegee ab diir, Yeesu dajeek moom ca kër Yàlla ga ne ko: «Déglul, fii mu ne, wér nga; bul defati bàkkaar, ngir ragal lu yées lii dal la.» ");
INSERT INTO wol2010_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Noonu nit ka dellu ne Yawut ya, Yeesu moo ko fajoon. ");
INSERT INTO wol2010_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Looloo tax Yawut ya di wuta sonal Yeesu, ndaxte daan na jëfe noonu ca bésub noflaay ba. ");
INSERT INTO wol2010_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Waaye Yeesu wax na leen ne: «Sama Baay nekk na ba tey ci liggéey, kon man itam damay liggéey.» ");
INSERT INTO wol2010_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Baat boobu moo tax ba Yawut yi gën koo wuta rey, ndaxte yemul woon rekk ci baña topp ndigalu bésub noflaay ba, waaye dafa wax it ne, Yàlla Baayam la, ba teg boppam Yàlla. ");
INSERT INTO wol2010_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Noonu Yeesu ne leen: «Ci dëgg-dëgg maa ngi leen koy wax, Doom ji manula def dara moom ci boppam; li mu gis Baay bi di def rekk lay def. Li Baay bi di jëf la Doom ji itam di jëf. ");
INSERT INTO wol2010_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Ndaxte Baay bi bëgg na Doom ji, ba di ko won lépp lu muy def, te dina ko won jëf yu ëpp kéemaan yii, ngir ngeen gëna waaru. ");
INSERT INTO wol2010_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Maanaam, ni Baay bi di dekkale ñu dee ñi, di leen jox dund, noonu la Doom ji di joxe dund ñi mu ko bëgga jox. ");
INSERT INTO wol2010_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Baay bi du àtte kenn; àtte bi yépp, jox na ko Doom ji, ");
INSERT INTO wol2010_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","ngir ñépp di teral Doom ji, ni ñuy terale Baay bi. Ku teralul Doom ji, teraloo Baay, bi ko yónni. ");
INSERT INTO wol2010_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","«Ci dëgg-dëgg maa ngi leen koy wax, ku dégg sama kàddu te gëm ki ma yónni, am nga dund gu dul jeex te doo jaar ca àtte ba, ndaxte génn nga ci dee, tàbbi ci dund. ");
INSERT INTO wol2010_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Ci dëgg-dëgg maa ngi leen koy wax, jamono dina ñëw te agsi na ba noppi, mooy jamono, ji ñu dee ñi di dégg baatu Doomu Yàlla ji, te ku ko dégg dinga dund. ");
INSERT INTO wol2010_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Ndaxte ni Baay bi ame dund moom ci boppam, noonu it la ko maye Doom ji, mu am ko ci boppam. ");
INSERT INTO wol2010_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Jox na Doom ji itam sañ-sañu àtte, ndaxte mooy Doomu nit ki. ");
INSERT INTO wol2010_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","«Bu leen ci dara jaaxal; ndaxte jamonoo ngi ñëw ju néew yépp, yi nekk ci seen bàmmeel, di dégg baatam tey génn. ");
INSERT INTO wol2010_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","Ñi daan jëf lu baax dinañu dekki, dund ba fàww, waaye ñi daan jëf lu bon, dinañu dekki, ñu daan leen. ");
INSERT INTO wol2010_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Manumaa def dara man ci sama bopp. Ni ma Baay bi di digale rekk laay àttee, te sama àtte bu jub la, ndaxte defuma sama bëgg-bëgg, ci waawi ki ma yónni doŋŋ laay aw. ");
INSERT INTO wol2010_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","«Su ma seedeelee sama bopp, sama wax du am maana. ");
INSERT INTO wol2010_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Waaye keneen moo may seedeel, te bir na ma ne la muy wax ci man dëgg la. ");
INSERT INTO wol2010_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","«Yéen yónni ngeen ay ndaw ci Yaxya, te seede na dëgg. ");
INSERT INTO wol2010_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Man ci sama bopp soxlawuma seedes nit; waaye nag damay wax loolu rekk, ngir ngeen mucc. ");
INSERT INTO wol2010_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Yaxya meloon na ni làmp buy tàkk tey leeral, te nangu ngeena bànneexu ab diir ci leeram. ");
INSERT INTO wol2010_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","«Waaye yor naa ci man seede su gëna mag si ma Yaxya di seedeel: maa ngi def jëf, yi ma Baay biy sant. Jëf yooyu may def nag ñooy seede ne, Baay bi moo ma yónni. ");
INSERT INTO wol2010_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Te Baay bi ma yónni, moom itam seede na ma. Masuleena dégg baatam te masuleena gis xar kanamam, ");
INSERT INTO wol2010_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","te kàddoom saxul ci yéen, ndaxte gëmuleen ki mu yónni. ");
INSERT INTO wol2010_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Yéena ngi gëstu Mbind yi, ndaxte dangeen cee yaakaar dund gu dul jeex. Mbind yooyu nag far, ci sama mbir lañuy wax; ");
INSERT INTO wol2010_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","te bëgguleena ñëw ci man ngir am dund! ");
INSERT INTO wol2010_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","«Wutuma tagg yu jóge ci nit. ");
INSERT INTO wol2010_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Waaye yéen, xam naa leen; leer na ma ne amuleen ci seen xol benn mbëggeel ci Yàlla. ");
INSERT INTO wol2010_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Man ñëw naa ci sama turu Baay, te nanguwuleen ma, waaye bu keneen dikkee ci turu boppam, ngeen nangu ko. ");
INSERT INTO wol2010_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Bëgg ngeen ku leen di tagg, te wutuleen ngërëm, li jóge ci jenn Yàlla rekk ji am. Kon nan ngeen mana gëme? ");
INSERT INTO wol2010_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","«Buleen xalaat ne maa leen di jiiñ dara ci sama kanam Baay. Musaa, mi ngeen yaakaar, moo leen di booleek moom. ");
INSERT INTO wol2010_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Bu ngeen gëmoon Musaa, dingeen ma gëm man itam, ndaxte seedeel na ma. ");
INSERT INTO wol2010_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Waaye su fekkee gëmuleen li Musaa bind, kon nu ngeen mana gëme samay wax?» ");
INSERT INTO wol2010_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Gannaaw loolu Yeesu dafa jàll dexu Galile, maanaam dexu Tiberyàdd. ");
INSERT INTO wol2010_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Mbooloo mu bare topp ci moom, ndaxte gisoon nañu firnde yooyee mu wone, bi mu wéralee jarag ya. ");
INSERT INTO wol2010_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Yeesu daldi yéeg ca kaw tund wa, toog fa ak ay taalibeem. ");
INSERT INTO wol2010_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Fekk na booba bésu Mucc ba, di màggalu Yawut ya, jubsi. ");
INSERT INTO wol2010_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Bi Yeesu xoolee, gis mbooloo mu réy di ñëw ci moom, mu ne Filib: «Fu nuy jële mburu, mu nu leen mana dundale?» ");
INSERT INTO wol2010_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Bi muy wax loolu it, da doon seetlu Filib, ndaxte xamoon na booba li mu nara def. ");
INSERT INTO wol2010_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Filib ne ko: «Peyug juróom ñetti weer sax, bu nu ko amoon, du leen mana doy ci mburu, ba kenn ku nekk ci ñoom am ci dog wu ndaw.» ");
INSERT INTO wol2010_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Keneen ca taalibe ya di Andare, mi bokk ak Simoŋ Piyeer ndey ak baay, ne ko: ");
INSERT INTO wol2010_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","«Am na fi ci mbooloo mi ab xale bu yor juróomi mburu ak ñaari jën, waaye loolu lu muy jariñ mbooloo mu tollu nii?» ");
INSERT INTO wol2010_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Yeesu daldi ne taalibe ya: «Na ñépp toog.» Fekk ñax mu bare amoon ca bérab ba. Noonu góor ñépp àgg suuf. Waroon nañoo mat juróomi junni. ");
INSERT INTO wol2010_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Yeesu daldi jël mburu ya, gërëm Yàlla, ba noppi séddale ko ña fa toogoon. Mu jox leen itam jën, ba ñu doyal sëkk. ");
INSERT INTO wol2010_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Bi ñu lekkee ba regg, Yeesu ne taalibe ya: «Dajaleleen desitu mburu mi, ba dara du ci réer.» ");
INSERT INTO wol2010_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Ñu dajale ko, daldi feesal fukki pañe ak ñaar ak desiti juróomi mburu, yi ñu doon lekk. ");
INSERT INTO wol2010_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Bi nit ña gisee firnde jooju Yeesu wone, ñu ne: «Dëgg-dëgg kii mooy Yonent, bi wara ñëw ci àddina!» ");
INSERT INTO wol2010_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Yeesu gis ne dañu koo nara jëlsi, fal ko buur. Mu bàyyi leen fa, dellu moom rekk ca tund wa. ");
INSERT INTO wol2010_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Bi timis jotee taalibeem ya wàcc ca tefes ga, ");
INSERT INTO wol2010_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","dugg ci gaal, di jàll dex gi, jëm dëkku Kapernawum. Booba guddi woon na, te Yeesu agseegul ci ñoom. ");
INSERT INTO wol2010_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Dex gi yëngu na lool, ndaxte da doon ngelaw ak doole. ");
INSERT INTO wol2010_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Bi ñu joowee lu wara tollook juróom benni kilomet, ñu séen Yeesu, muy dox ci kaw dex gi, jëm ci ñoom, ñu daldi tiit. ");
INSERT INTO wol2010_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Waaye Yeesu ne leen: «Man la, buleen tiit!» ");
INSERT INTO wol2010_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Noonu ñu nangu koo dugal ca gaal ga, gaal ga daldi teer ca saa sa ca fa ñu bëggoona wàcc. ");
INSERT INTO wol2010_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Ca ëllëg sa mbooloo, ma des ca geneen wàllu dex ga, gis ne genn gaal ga fa nekkoon rekk dem na. Xam nañu ne Yeesu bokku ko woon ak taalibe ya, ndaxte ñoom rekk a àndoon. ");
INSERT INTO wol2010_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Waaye yeneen gaal yu jóge dëkku Tiberyàdd ñëw, teer ca wetu fa ñu lekke woon mburu ma, gannaaw bi Boroom bi santee Yàlla ba noppi. ");
INSERT INTO wol2010_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Bi mbooloo ma gisee ne Yeesu walla taalibe ya kenn nekkatu fa, ñu dugg ca gaal yooyu, dem seeti ko Kapernawum. ");
INSERT INTO wol2010_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Bi ñu fekkee Yeesu ca geneen wàllu dex ga, ñu ne ko: «Kilifa gi, kañ nga fi ñëw?» ");
INSERT INTO wol2010_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Yeesu ne leen: «Ci dëgg-dëgg maa ngi leen koy wax, firnde yi ngeen gis taxul ngeen may seet. Yéena ngi may wër ndax mburu, mi ngeen lekk ba suur. ");
INSERT INTO wol2010_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Buleen liggéeyal ñam wuy yàqu; li gën mooy ñam wu sax abadan tey joxe dund gu dul jeex. Ñam woowule, Doomu nit ki dina leen ko jox, ndaxte moom la Yàlla Baay bi tànn, mu nekk ndawam.» ");
INSERT INTO wol2010_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Noonu ñu laaj ko ne: «Lu nu wara liggéey, ngir matal jëf yi neex Yàlla?» ");
INSERT INTO wol2010_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Yeesu ne leen: «Jëf ji neex Yàlla, moo di gëm ki mu yónni.» ");
INSERT INTO wol2010_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Ñu ne ko: «Ban firnde nga nu mana won, ngir nu gëm la? Ban liggéey nga nara def? ");
INSERT INTO wol2010_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Sunuy maam dunde nañu mànn ca màndiŋ ma, ndaxte Mbind mi nee na: “Jox na leen, ñu lekk ñam wu wàcce ca asamaan.”» ");
INSERT INTO wol2010_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Yeesu waxaat ne: «Ci dëgg-dëgg maa ngi leen koy wax, du Musaa moo leen jox ñam woowu wàcce ca asamaan; sama Baay ci boppam, moo leen di jox ñam wu wóor, wi wàcce ca asamaan. ");
INSERT INTO wol2010_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Ndaxte ñam, wi Yàlla di joxe, mooy ñam wiy wàcce ci asamaan tey jox àddina si dund.» ");
INSERT INTO wol2010_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Ñu ne ko nag: «Sang bi, kon dee nu faral di jox ci ñam woowe!» ");
INSERT INTO wol2010_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Yeesu ne leen: «Man maay ñam wiy joxe dund. Ku ñëw ci man, doo xiif mukk; te ku ma gëm, doo mar. ");
INSERT INTO wol2010_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Waaye wax naa leen ko ba noppi; gis ngeen ma te taxul ngeen gëm! ");
INSERT INTO wol2010_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Képp ku ma Baay bi jox dina ñëw ci man, te duma dàq mukk ki may fekksi. ");
INSERT INTO wol2010_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Ndaxte wàccewuma ci asamaan ngir def sama bëgg-bëgg, waaye damay matal bëgg-bëggu ki ma yónni. ");
INSERT INTO wol2010_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Lii mooy bëgg-bëggu ki ma yónni: bu ma ñàkk kenn ci ñi mu ma may, te dafa bëgg it ma dekkal leen keroog bés bu mujj ba. ");
INSERT INTO wol2010_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Ndaxte lii mooy bëgg-bëggu Baay bi: képp ku gis Doom ji te gëm ko, am dund gu dul jeex, te bés bu mujj ba, dinaa ko dekkal!» ");
INSERT INTO wol2010_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Yawut ya tàmbali di ñurumtoo Yeesu, ndaxte dafa ne: «Maay ñam wi wàcce ci asamaan.» ");
INSERT INTO wol2010_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Ñu naan: «Ndax kii du Yeesu, doomu Yuusufa? Xam nanu ndeyam ak baayam. Kon nag lu tax léegi mu naan, mi ngi jóge asamaan?» ");
INSERT INTO wol2010_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Yeesu ne leen: «Bàyyileen seen ñurumtu bi. ");
INSERT INTO wol2010_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Kenn manula ñëw ci man te Baay, bi ma yónni, xiirtalu la ci; te man dinaa la dekkal keroog bés bu mujj ba. ");
INSERT INTO wol2010_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Yonent yi bind nañu kàddu gii: “Yàlla dina leen jàngal ñoom ñépp.” Kon nag ku déglu te nangu waxi Baay bi, dina ñëw ci man. ");
INSERT INTO wol2010_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Tekkiwul ne kenn mas na gis Baay bi. Ki jóge ci Yàlla doŋŋ a ko gis. ");
INSERT INTO wol2010_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Ci dëgg-dëgg maa ngi leen koy wax, ku gëm am nga dund gu dul jeex. ");
INSERT INTO wol2010_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Maay ñam wiy joxe dund. ");
INSERT INTO wol2010_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Seeni maam lekk nañu mànn ca màndiŋ ma, teewul dee nañu. ");
INSERT INTO wol2010_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Waaye ñam wiy wàcce ci asamaan, ku ko lekk, doo dee. ");
INSERT INTO wol2010_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Man maay ñam wiy dund te wàcce ci asamaan. Ku lekk ci ñam wii, dinga dund ba fàww. Te it ñam wi may joxeji, sama yaram la; dama koy joxe ngir àddina mana dund.» ");
INSERT INTO wol2010_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Noonu Yawut ya werante werante wu tàng ci seen biir naan: «Naka la nu waa jii mana joxe yaramam, ngir nu lekk ko?» ");
INSERT INTO wol2010_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Yeesu ne leen: «Dëgg-dëgg maa ngi leen koy wax, bu ngeen lekkul yaramu Doomu nit ki te naanuleen deretam, dungeen am dund ci yéen. ");
INSERT INTO wol2010_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Ku lekk sama yaram te naan sama deret, am nga dund gu dul jeex, te dinaa la dekkal keroog bés bu mujj ba. ");
INSERT INTO wol2010_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Ndaxte sama yaram mooy ñam wu wóor wi, te sama deret mooy naan gu wóor gi. ");
INSERT INTO wol2010_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Kiy lekk sama yaram tey naan sama deret dina sax ci man, ma dëkk ci moom. ");
INSERT INTO wol2010_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Baay bi ma yónni mu ngi dund, te maa ngi dund jaarale ko ci moom; noonu itam ku may lekk dina dund jaarale ko ci man. ");
INSERT INTO wol2010_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Kon nag ñam wi wàcce ci asamaan a ngi noonu; bokkul ak ñam wa seeni maam lekkoon te faatu. Ku lekk ñam wii may wax dinga dund ba fàww.» ");
INSERT INTO wol2010_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Baat yooyu la Yeesu wax, bi mu doon jàngle ca jàngu ba ca Kapernawum. ");
INSERT INTO wol2010_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Bi ñu dégloo Yeesu ba noppi, taalibeem yu bare nee nañu: «Njàngle mii de, jafe na! Kan moo ko mana déglu?» ");
INSERT INTO wol2010_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Yeesu gis ne taalibeem yaa ngi ñurumtoo loolu, mu ne leen: «Ndax li ma wax da leena jaaxal? ");
INSERT INTO wol2010_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Lan mooy am nag, bu fekkee gis ngeen Doomu nit ki dellu, yéeg fa mu jëkkoona nekk? ");
INSERT INTO wol2010_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Xelu Yàlla mi mooy joxe dund; ñam wi jariñul dara. Kàddu yi ma leen wax, ci Xelum Yàlla lañu jóge te ñooy joxe dund. ");
INSERT INTO wol2010_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Waaye am na ci seen biir ñu ko gëmul.» Ndaxte Yeesu xamoon na ca njàlbéen ga ñan ñoo ko waroona gëmadi ak kan moo ko waroona wor. ");
INSERT INTO wol2010_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Mu dolli ca it ne: «Looloo tax ma ne, kenn manula ñëw ci man te Baay bi mayu la, nga agsi.» ");
INSERT INTO wol2010_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Ci loolu taalibeem yu bare dëpp, bañatee ànd ak moom. ");
INSERT INTO wol2010_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Yeesu daldi wax ak fukki taalibe yi ak ñaar ne leen: «Mbaa bëgguleena dem, yéen itam?» ");
INSERT INTO wol2010_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Simoŋ Piyeer ne ko: «Boroom bi, ci kan lanuy dem? Yaa yor kàddu yiy joxe dund gu dul jeex. ");
INSERT INTO wol2010_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Léegi nun gëm nanu te xam nanu ne yaa di Aji Sell, ji jóge ci Yàlla.» ");
INSERT INTO wol2010_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Yeesu ne leen: «Xanaa du maa leen tànn, yéen fukk yi ak ñaar? Moona, am na ci yéen koo xam ne seytaane la!» ");
INSERT INTO wol2010_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Yudaa miy doomu Simoŋ Iskariyo la doon wax. Ndeke Yudaa, la muy bokk lépp ca fukki taalibe ya ak ñaar, moo ko naroona wor. ");
INSERT INTO wol2010_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Gannaaw loolu Yeesu doon na wër diiwaanu Galile. ");
INSERT INTO wol2010_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Bëggul woona dem diiwaanu Yude, ndaxte Yawut ya dañu ko doon wuta rey. Fekk na bésu xewu Yawut ya, ñu koy wax màggalu Mbaar ya, mu ngi doon jubsi. ");
INSERT INTO wol2010_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Noonu rakki Yeesu yu góor ya ne ko: «Jóge fi te dem diiwaanu Yude, ngir say taalibe gis, ñoom itam, jaloore yi ngay def. ");
INSERT INTO wol2010_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Ku bëgga siiw, doo nëbb say jëf. Boo demee bay wone jaloore yu mel ni, fexeel ba ñépp gis la.» ");
INSERT INTO wol2010_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Rakkam yi dañu doon wax loolu, ndaxte ñoom itam gëmuñu ko woon. ");
INSERT INTO wol2010_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Yeesu ne leen: «Sama waxtu jotagul. Ci yéen nag, waxtu yépp a baax. ");
INSERT INTO wol2010_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Àddina du leen bañ waaye bañ na ma, man, ndaxte maa wax ne seeni jëf baaxul. ");
INSERT INTO wol2010_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Yéen nag demleen màggal ga. Demaguma màggal googu, ndaxte sama waxtu jotagul.» ");
INSERT INTO wol2010_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Bi mu leen waxee loolu ba noppi, moom mu des Galile. ");
INSERT INTO wol2010_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Bi rakkam ya demee ca màggal ga, Yeesu itam sooga dem te kenn yégu ko; siiwalul demam. ");
INSERT INTO wol2010_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Fekk Yawut yaa nga ko doon seet ca màggal ga te naan: «Ana waa ji?» ");
INSERT INTO wol2010_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Ca biir mbooloo ma ñu ngi doon déeyante, di wax ci ay mbiram. Ñii naan: «Nit ku baax la.» Ñee naan: «Déedéet, day nax nit ñi.» ");
INSERT INTO wol2010_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Waaye kenn ñemewu koo tudd ca kaw, ndaxte dañoo ragaloon Yawut ya. ");
INSERT INTO wol2010_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Bi ñu demee ba ca diggu màggal ga, Yeesu dem di jàngle ca kër Yàlla ga. ");
INSERT INTO wol2010_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Yawut ya nag jaaxle, daldi ne: «Nu waa jii def ba xam lii lépp, moom mi jàngul?» ");
INSERT INTO wol2010_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Yeesu daldi leen wax ne: «Li may jàngle, jógewul ci man, waaye ci ki ma yónni la jóge. ");
INSERT INTO wol2010_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Ku fas yéenee wéy ci bëgg-bëggu Yàlla, dina xam ndax sama njàngle ci Yàlla la jóge, walla ci sama coobare. ");
INSERT INTO wol2010_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Nit kiy wax ci coobareem nag, day wuta màggal boppam, waaye kiy wuta màggal ki ko yónni, dëgg rekk lay wax te jubadiwul fenn. ");
INSERT INTO wol2010_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Xanaa du Musaa moo leen jox ndigali Yàlla yi? Waaye kenn ci yéen sàmmu ko! Lu tax ngeen bëgg maa rey?» ");
INSERT INTO wol2010_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Mbooloo ma ne ko: «Xanaa dangaa am ay rab! Ku lay wuta rey?» ");
INSERT INTO wol2010_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Yeesu ne leen: «Benn jaloore rekk laa def, te yéen ñépp ngeen jaaxle! ");
INSERT INTO wol2010_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Li leen Musaa jox ndigalu xarafal gone yi —jógewul kat ci Musaa; mi ngi tàmbalee ci seen maami cosaan— moo tax ba ngeen nangoo xarafal nit ci bésub noflaay bi. ");
INSERT INTO wol2010_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Bu ngeen manee xarafal nit ci bésub noflaay bi, ngir baña wàcc yoonu Musaa, lu tax nag ngeen mere ma, ndax li ma ci wéral nitu lëmm? ");
INSERT INTO wol2010_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Bàyyileen di àtte ci ni ngeen di gise, te di àtte dëgg.» ");
INSERT INTO wol2010_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Am na ci waa Yerusalem ñu doon wax naan: «Xanaa du nit kii lañuy wuta rey? ");
INSERT INTO wol2010_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Xool-leen, mi ngi waaraate ci biir nit ñi, te kenn du ko wax dara. Ndax sunu kilifa yi dañoo xam ne mooy Almasi bi? ");
INSERT INTO wol2010_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Waaye waa ji, xam nanu fu mu jóge, te saa su Almasi bi dee dikk, kenn du xam fu mu bàyyikoo.» ");
INSERT INTO wol2010_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Yeesu di jàngle ca kër Yàlla ga, daldi wax ca kaw ne: «Ndax xam ngeen ma te xam fi ma jóge? Ñëwaluma sama bopp, waaye ki ma yónni, ku wóor la. Yéen xamuleen ko. ");
INSERT INTO wol2010_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Man xam naa ko, ndaxte ca moom laa jóge, te itam moo ma yónni.» ");
INSERT INTO wol2010_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Noonu ñu koy wuta jàpp, waaye kenn manalu ko woon dara, ndaxte waxtoom jotagul woon. ");
INSERT INTO wol2010_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Moona nag, ñu bare ca mbooloo ma gëm nañu ko. Ñu nga naan: «Ndax bés bu Almasi bi dikkee, ay firndeem dina ëpp yu nit kii?» ");
INSERT INTO wol2010_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Farisen ya daldi dégg la mbooloo ma doon déeyante ci mbirum Yeesu. Sarxalkat yu mag ya ak Farisen ya yebal ay alkaati yu daan wottu kër Yàlla ga, ngir ñu jàppi ko. ");
INSERT INTO wol2010_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Yeesu wax ne: «Dinaa nekk ak yéen fi ak ab diir, sooga dem ci ki ma yónni. ");
INSERT INTO wol2010_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Dingeen ma seet, waaye dungeen ma gis; te dungeen mana dem fa may nekk.» ");
INSERT INTO wol2010_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Yawut ya di laajante ci seen biir naan: «Fu muy dem fu nu ko dul fekk? Mbaa du dafa nara dem ca Yawut, ya gàddaaye ca Gereg ya, te jàngali Gereg ya? ");
INSERT INTO wol2010_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Lan la baat yii mu wax di tekki: “Dingeen ma seet waaye dungeen ma gis,” ak: “Dungeen mana dem fa may nekk”?» ");
INSERT INTO wol2010_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","38","Bés ba mujjoon ca màggal ga moo ca ëpp solo; keroog Yeesu taxaw, wax ca kaw ne: «Ku mar, na ñëw ci man; ku gëm, na naan! Ndaxte Mbind mi nee na: “Ndox mu bare muy dundale dina xellee ci dënnam.”» ");
INSERT INTO wol2010_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Booba li ko taxoon di wax mooy Xelu Yàlla, mi ñi ko gëm naroona jot. Fekk na joxeeguñu woon Xelu Yàlla mi, ndaxte ndamu Yeesu feeñagul woon. ");
INSERT INTO wol2010_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Bi ñu déggee wax jooja, am ay nit ca mbooloo ma ñu naan: «Dëgg-dëgg kii mooy Yonent bi wara ñëw.» ");
INSERT INTO wol2010_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Ñeneen naan: «Mooy Almasi bi.» Ña ca des it ne: «Waaye nan la Almasi bi mana jógee Galile? ");
INSERT INTO wol2010_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Mbind mi wax na ne, Almasi bi ci xeetu Daawuda lay wàcce te Betleyem, dëkku Daawuda, lay jóge.» ");
INSERT INTO wol2010_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Noonu féewaloo daldi am ca biir mbooloo ma ndax Yeesu. ");
INSERT INTO wol2010_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Am na ca ñoom ñu ko bëggoona jàpp, waaye kenn manalu ko woon dara. ");
INSERT INTO wol2010_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Bi alkaati ya delloo, sarxalkat yu mag ya ak Farisen ya laaj leen ne: «Lu tax indiwuleen ko?» ");
INSERT INTO wol2010_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Alkaati ya ne leen: «Kenn masula waxe ni nit kooku!» ");
INSERT INTO wol2010_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Noonu Farisen ya laaj leen: «Mbaa naxuñu leen, yéen itam? ");
INSERT INTO wol2010_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Ndax am na kenn ci sarxalkat yi walla ci Farisen yi ku ko gëm? Déedéet. ");
INSERT INTO wol2010_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Waaye mbooloo mi xamuñu yoonu Musaa; ñu alku lañu!» ");
INSERT INTO wol2010_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Nikodem bokkoon na ca Farisen ya fa nekkoon. Fekk moo seeti woon Yeesu lu jiitu. Mu ne leen: ");
INSERT INTO wol2010_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","«Ndax ci sunu yoon, man nañoo daan kenn te dégluwuñu ko, mbaa ñu xam lu mu def?» ");
INSERT INTO wol2010_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Ñu ne ko: «Mbaa du yaw itam dangaa bokk ci diiwaanu Galile? Gëstul, kon dinga xam ne benn yonent masula jóge Galile.» ");
INSERT INTO wol2010_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Gannaaw loolu ku ci nekk dellu sa kër. ");
INSERT INTO wol2010_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Yeesu moom, dem ca tundu Oliw ya. ");
INSERT INTO wol2010_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Ca ëllëg sa ca fajar, mu dellu ca kër Yàlla ga, mbooloo ma fa teewoon wër ko. Mu toog, tàmbali di leen jàngal. ");
INSERT INTO wol2010_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Xutbakat ya ak Farisen ya indi jenn jigéen ju ñu bettoon muy njaaloo, ñu taxawal ko ca diggu mbooloo ma. ");
INSERT INTO wol2010_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Noonu ñu ne Yeesu: «Kilifa gi, jigéen jii de, dañu koo bett muy njaaloo. ");
INSERT INTO wol2010_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Ci ndigali Yàlla yi, jigéen ju njaaloo, Musaa dafa santaane ñu sànni ko ay xeer, ba mu dee. Yaw nag, lu ciy sa xalaat?» ");
INSERT INTO wol2010_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Loolu nag, dañu ko doon wax ngir seetlu ko, ndaxte bëggoon nañoo tiiñal Yeesu. Yeesu sëgg, di bind ak baaraamam ci suuf. ");
INSERT INTO wol2010_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Bi laaj ya baree, mu siggi ne leen: «Ku masula def bàkkaar ci yéen, na ko jëkka sànniy xeer.» ");
INSERT INTO wol2010_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Noonu mu sëggaat, dellu di bind ci suuf. ");
INSERT INTO wol2010_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Bi ñu déggee loolu, ñuy rocceeku kenn-kenn, mag ña jiitu. Yeesu rekk des fa, jigéen ja taxaw ca kanamam. ");
INSERT INTO wol2010_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Mu daldi siggi ne ko: «Jigéen ji, ana ñi la doon jiiñ njaaloo? Ndax kenn tegu la tooñ?» ");
INSERT INTO wol2010_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Mu ne ko: «Kenn, Sang bi.» Yeesu ne ko: «Man it ci sama wàll, duma la daan. Demal, waaye bul defati bàkkaar.» ");
INSERT INTO wol2010_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Yeesu jubluwaat ca mbooloo ma ne leen: «Man maay leeru àddina si. Ku ma topp doo dox cig lëndëm, waaye dinga am leeru dund.» ");
INSERT INTO wol2010_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Farisen ya ne ko: «Yaw yaay seedeel sa bopp, kon li ngay wax du dëgg.» ");
INSERT INTO wol2010_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Yeesu ne leen: «Maa ngi seedeel sama bopp, teewul li may wax di dëgg, ndaxte xam naa fa ma bàyyikoo, xam fa ma jëm. Waaye yéen xamuleen fa ma bàyyikoo ak fa ma jëm. ");
INSERT INTO wol2010_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Ci gis-gisu àddina ngeen di àttee; man duma àtte kenn. ");
INSERT INTO wol2010_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Teewul nag, su ma demee bay àtte, bu jub lay doon, ndaxte du man rekk ay àtte, waaye Baay, bi ma yónni, daf ciy ànd ak man. ");
INSERT INTO wol2010_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Seen yoon dafa wax ne seedes ñaari nit a gëna wóor. ");
INSERT INTO wol2010_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Man maa ngi seedeel sama bopp, te Baay bi ma yónni mi ngi may seedeel itam.» ");
INSERT INTO wol2010_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Ñu laaj ko ne: «Kuy sa baay?» Yeesu ne leen: «Xamuleen ma, xamuleen sama Baay. Bu ngeen ma xamoon, xam ko.» ");
INSERT INTO wol2010_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Bi muy wax loolu, Yeesoo nga doon jànglee ca kër Yàlla ga, ca wetu fa ñu doon denc asaka ya. Kenn manu ko woona jàpp, ndaxte waxtoom jotagul. ");
INSERT INTO wol2010_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Yeesu dellu ne leen: «Maa ngi dem; dingeen ma seet, waaye seen bàkkaar ngeen di deeyaale. Fa ma jëm, dungeen fa mana dem.» ");
INSERT INTO wol2010_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Yawut yay waxante naan: «Nee na kat, fa mu jëm, dunu fa mana dem. Mbaa du day xaruji?» ");
INSERT INTO wol2010_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Yeesu ne leen: «Yéen, fii ngeen bawoo, ci suuf, waaye man ca kaw laa jóge. Àddina ngeen soqikoo, waaye man bokkuma ci. ");
INSERT INTO wol2010_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Looloo tax ma ne, ci seeni bàkkaar ngeen di dee. Bu ngeen gëmul ki ma nekk, dingeen dee ci seeni bàkkaar.» ");
INSERT INTO wol2010_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Ñu ne ko: «Yaay kan?» Mu ne leen: «Li ma leen waxoon ca njàlbéen ga. ");
INSERT INTO wol2010_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Li ma mana wax ci yéen ba àtte leen, bare na. Waaye ki ma yónni, ku wóor la, te li mu ma wax rekk laay jottali àddina.» ");
INSERT INTO wol2010_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Xamuñu woon ne, Yàlla Baay bee tax muy wax. ");
INSERT INTO wol2010_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Yeesu nag ne leen: «Bu ngeen yékkatee Doomu nit ki, dingeen xam ne Maay ki Nekk. Dingeen xam ne it, duma def dara man ci sama bopp. Li ma Baay biy jàngal rekk laay wax. ");
INSERT INTO wol2010_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Te it ki ma yónnee ngi ànd ak man; masu maa bàyyi ma wéet, ndaxte li ko neex rekk laay def.» ");
INSERT INTO wol2010_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Bi ñuy dégg Yeesu di wax loolu, ñu bare daldi koy gëm. ");
INSERT INTO wol2010_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Yeesu ne Yawut ya ko gëmoon: «Bu ngeen saxee ci li ma wax, nekk ngeen samay taalibe ci lu wóor. ");
INSERT INTO wol2010_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Te it dingeen xam dëgg gi, te dëgg gi dina leen goreel.» ");
INSERT INTO wol2010_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Ñu ne ko: «Nun ci Ibraayma lanu soqikoo te masunoo nekk jaamu kenn. Nan nga nu mana waxe ne dinañu leen goreel?» ");
INSERT INTO wol2010_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Yeesu ne leen: «Ci dëgg-dëgg maa ngi leen koy wax, képp kuy bàkkaar, jaamu bàkkaar la. ");
INSERT INTO wol2010_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Te jaam du bokk ci kër gi ba fàww, waaye doom, moom, ci kër gi la bokk ba fàww. ");
INSERT INTO wol2010_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Kon nag bu leen Doom ji defee gor, dingeen doon ay gor tigi. ");
INSERT INTO wol2010_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Xam naa ne askanu Ibraayma ngeen. Waaye yéena ngi may wuta rey, ndaxte li may jàngle xajul ci yéen. ");
INSERT INTO wol2010_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Li ma sama Baay won laay wax; waaye yéen, li leen seen baay di wax ngeen di def.» ");
INSERT INTO wol2010_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Ñu ne ko: «Ibraayma mooy sunu baay.» Yeesu ne leen: «Bu ngeen dee waa kër Ibraayma, dingeen jëfe ni moom. ");
INSERT INTO wol2010_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Léegi nag yéena ngi may wuta rey, man mi leen jottali dëgg, gi ma jële ca Yàlla. Ibraayma deful lu ni mel. ");
INSERT INTO wol2010_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Li ngeen donne ci seen baay rekk ngeen di def.» Ñu ne ko: «Nun de, dunu doomi araam. Benn baay rekk lanu am, mooy Yàlla.» ");
INSERT INTO wol2010_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Yeesu ne leen: «Bu Yàlla doon seen baay, dingeen ma bëgg, ndaxte ca moom laa jóge, ñëw ci ndigalam. Ñëwaluma sama bopp, waaye moo ma yónni. ");
INSERT INTO wol2010_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Lu tax dégguleen li ma leen wax? Li ko waral moo di manuleen koo déglu. ");
INSERT INTO wol2010_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Seytaane mooy seen baay, te bëgg-bëggam ngeen di bëgg di def. Bóomkat la masa doon. Du taxaw mukk ci dëgg, ndaxte dëgg nekkul ci moom. Buy fen, dëppoo na ak jikkoom, ndaxte fenkat la, te ci moom la fen soqikoo. ");
INSERT INTO wol2010_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Waaye man damay wax dëgg, moo tax gëmuleen ma. ");
INSERT INTO wol2010_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Kan ci yéen moo mana seede ne bàkkaar naa? Su ma waxee dëgg nag, lu tax dungeen ma gëm? ");
INSERT INTO wol2010_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Ku nekk doomu Yàlla dina déglu ay waxam. Waaye nekkuleen doomi Yàlla, looloo tax dungeen déglu.» ");
INSERT INTO wol2010_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Yawut ya ne ko: «Ndax danoo waxul dëgg, bu nu nee, nitu Samari nga te dangaa am ay rab?» ");
INSERT INTO wol2010_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Yeesu ne leen: «Awma rab; waaye sama Baay laay teral, te yéen dangeen may toroxal. ");
INSERT INTO wol2010_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Wutumaa màggal sama bopp. Keneen a ma koy wutal te mooy àtte. ");
INSERT INTO wol2010_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Ci dëgg-dëgg maa ngi leen koy wax, kuy sàmm sama wax doo dee mukk.» ");
INSERT INTO wol2010_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Yawut ya ne ko: «Léegi wóor nanu ne dangaa am ay rab! Ibraayma faatu na, yonent yépp faatu, yaw nga naan: “Kuy sàmm sama wax doo ñam dee.” ");
INSERT INTO wol2010_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Sunu baay Ibraayma faatu na; mbaa du dangaa defe ne yaa ko gëna màgg? Yonent yi itam faatu nañu. Waaw, loo teg sa bopp?» ");
INSERT INTO wol2010_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Yeesu ne leen: «Su ma dee màggal sama bopp, du am maana. Sama Baay a may màggal, moom mi ngeen naan, mooy seen Yàlla. ");
INSERT INTO wol2010_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Xamuleen ko nag; man maa ko xam. Su ma ne woon xawma ko, ab fenkat laay doon ni yéen. Waaye xam naa ko te maa ngi sàmm waxam. ");
INSERT INTO wol2010_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Seen baay Ibraayma bég na, bi mu yégee sama ngan. Bi mu ko gisee it, bég na ci lool.» ");
INSERT INTO wol2010_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Yawut ya ne ko: «Amaguloo juróom fukki at, ba noppi naan gis nga Ibraayma?» ");
INSERT INTO wol2010_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Yeesu ne leen: «Ci dëgg-dëgg maa ngi leen koy wax, laata ñuy sàkk Ibraayma, fekk na ma doon ki ñuy wax Maay ki Nekk.» ");
INSERT INTO wol2010_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Noonu ñu for ay xeer, bëgg ko koo sànni ngir rey ko. Waaye Yeesu nëbbu, génn kër Yàlla ga. ");
INSERT INTO wol2010_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Amoon na fu Yeesu jaaroon, gis fa waa ju judduwaale gumba. ");
INSERT INTO wol2010_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Taalibeem ya laaj ko ne: «Kilifa gi, lu tax waa jii judduwaale gumba? Ndax bàkkaaram a ko waral, walla bu waajuram?» ");
INSERT INTO wol2010_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Yeesu ne leen: «Ajuwul ci bàkkaaram walla ci bu waajuram. Waaye loolu dafa am, ngir jëfi Yàlla yi feeñ ci moom. ");
INSERT INTO wol2010_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Bëccëg lanu wara matal jëfi ki ma yónni; guddi dina ñëwi, goo xam ne kenn du ci mana liggéey. ");
INSERT INTO wol2010_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Ci bi may nekk àddina, maay leeru àddina.» ");
INSERT INTO wol2010_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Bi Yeesu waxee loolu ba noppi, dafa daldi tifli, jaxase lor wa ak ban, tay ko ci bëti gumba ga ne ko: ");
INSERT INTO wol2010_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","«Demal sëlmu ci bëtu Silowe.» Silowe mi ngi tekki «Yónni nañu ko.» Gumba ga daldi dem sëlmuji, délsi di gis. ");
INSERT INTO wol2010_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Dëkkandoom yi ak ñi ko xame woon bu jëkk ci yelwaan naan: «Xanaa du kii moo daan toog, di yelwaan?» ");
INSERT INTO wol2010_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Ñii naan: «Moom la de!» Ñee naan: «Du moom! Dañoo niroo rekk.» Mu daldi leen ne: «Man la de!» ");
INSERT INTO wol2010_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Ñu ne ko: «Lu ubbi say bët?» ");
INSERT INTO wol2010_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Mu ne leen: «Ku ñuy wax Yeesu moo tooyal ban, tay ko ci samay bët, ne ma: “Demal sëlmu ci bëtu Silowe.” Ma dem nag sëlmuji, daldi gis.» ");
INSERT INTO wol2010_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Ñu ne ko: «Ana waa ji?» Mu ne leen: «Xawma fu mu nekk.» ");
INSERT INTO wol2010_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Noonu ñu daldi indil Farisen yi nit ki gumba woon. ");
INSERT INTO wol2010_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Ndekete Yeesu, bés bi mu tooyale ban, ubbi bëti gumba ga, bésub noflaay la woon. ");
INSERT INTO wol2010_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Looloo tax Farisen ya di laajaat waa ja fi mu jaar bay gis léegi. Mu ne leen: «Dafa tay ban ci samay bët, ma sëlmuji, ba fi ma nekk maa ngi gis.» ");
INSERT INTO wol2010_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Ci noonu am ca Farisen ya ñu naan: «Ki def lii, manula jóge ca Yàlla, ndaxte toppul ndigalu bésub noflaay bi.» Ñeneen it di wax ne: «Nan la boroom bàkkaar mana wonee yii firnde?» Noonu ñu daldi féewaloo ci seen biir. ");
INSERT INTO wol2010_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Farisen ya laajaat ka gumba woon ne ko: «Yaw, loo wax ci moom? Yaw de la ubbil say bët.» Mu ne leen: «Yonent la.» ");
INSERT INTO wol2010_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Yawut ya manuñu woona nangu ne, nit ka dafa gumba woon tey gis léegi, ñu daldi wooluji ay waajuram, ");
INSERT INTO wol2010_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","laaj leen ne: «Ndax kii mooy seen doom, ji ngeen ne gumba judduwaale la? Kon fu mu jaar, bay gis léegi?» ");
INSERT INTO wol2010_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Waajur ya ne leen: «Xam nanu ne daal, sunu doom la te dafa judduwaale gumba. ");
INSERT INTO wol2010_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Waaye ni mu def léegi bay gis, xamunu ko, te xamunu it ki ko ubbil ay bëtam. Laajleen ko; magum jëmm la, te man na tontul boppam.» ");
INSERT INTO wol2010_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Ragal Yawut ya nag moo taxoon waajuri nit ka waxe noonu, ndaxte Yawut ya dañoo mànkoo woon ne, képp ku seede ne Yeesu mooy Almasi bi, ñu dàq la ca jàngu ba. ");
INSERT INTO wol2010_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Looloo tax waajur ya ne: «Laajleen ko; magum jëmm la.» ");
INSERT INTO wol2010_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Farisen ya dellu woowaat ka gumba woon ne ko: «Waxal sa digganteek Yàlla. Xam nanu ne waa joojee boroom bàkkaar la.» ");
INSERT INTO wol2010_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Mu ne: «Xawma ndax boroom bàkkaar la am déet. Li ma xam daal mooy gumba woon naa, te léegi maa ngi gis.» ");
INSERT INTO wol2010_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Ñu laaj ko ne: «Lu mu la def? Nu mu la ubbile say bët?» ");
INSERT INTO wol2010_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Mu ne leen: «Wax naa leen ko ba noppi, waaye dégluwuleen ma. Lu ngeen bëgg ci ma di ko wax, di waxaat? Xanaa dangeena bëgga nekk yéen itam ay taalibeem?» ");
INSERT INTO wol2010_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Ci kaw loolu ñu daldi ko saaga ne ko: «Yaw yaay taalibeem. Nun, taalibey Musaa lanu. ");
INSERT INTO wol2010_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Xam nanu ne Yàlla wax na ak Musaa; waaye kii, xamunu sax fu mu jóge.» ");
INSERT INTO wol2010_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Waa ja ne leen: «Loolu de, doy na waar! Xamuleen fu mu jóge, te moo ubbi samay bët! ");
INSERT INTO wol2010_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Xam nanu ne Yàlla du déglu boroom bàkkaar. Waaye nag, dina déglu ki koy ragal tey def coobareem. ");
INSERT INTO wol2010_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Bi àddina sosoo ba tey, masuñoo dégg nit ku ubbi bëti gumbag judduwaale. ");
INSERT INTO wol2010_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Kon nit kookee nag, bu jógewul woon ca Yàlla, du mana def dara.» ");
INSERT INTO wol2010_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Ñu ne ko: «Yaw, ci biir bàkkaar nga juddoo, ba noppi di nu jàngal?» Noonu ñu dàq ko ca jàngu ba. ");
INSERT INTO wol2010_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Yeesu daldi yég ne dàq nañu nit ka. Bi mu dajeek moom, mu ne ko: «Ndax gëm nga Doomu nit ki?» ");
INSERT INTO wol2010_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Waa ja ne ko: «Wax ma mooy kan, Sang bi, ba ma man koo gëm.» ");
INSERT INTO wol2010_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Yeesu ne ko: «Gis nga ko ba noppi, te mooy kiy wax ak yaw.» ");
INSERT INTO wol2010_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Waa ja ne: «Boroom bi, gëm naa la.» Noonu mu jaamu Yeesu. ");
INSERT INTO wol2010_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Yeesu ne ko: «Àttee ma taxa ñëw àddina, ngir ñi gumba gis, ñiy gis gumba.» ");
INSERT INTO wol2010_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Bi Farisen ya nekkoon ak moom déggee loolu, ñu ne ko: «Xanaa kon nun it danoo gumba?» ");
INSERT INTO wol2010_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Yeesu ne leen: «Bu ngeen gumba woon, dungeen am bàkkaar, waaye fi ak yéena ngi naan: “Nu ngi gis,” ci bàkkaar ngeen di dëkk. ");
INSERT INTO wol2010_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","«Ci dëgg-dëgg maa ngi leen koy wax, ku jaar feneen fu dul ci buntu gétt gi, kooku sàcc la, saay-saay la. ");
INSERT INTO wol2010_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Waaye ki jaar ci bunt bi, mooy sàmmu xar yi. ");
INSERT INTO wol2010_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Wottukat bi dina ko ubbil bunt bi, xar yiy dégg baatam. Xar yi mu moom nag, bu ci nekk dina la woo ci sa tur, ba noppi nga topp ko ci biti. ");
INSERT INTO wol2010_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Sàmm bi, bu génnee yi mu moom yépp, dina leen jiitu, ñu topp ko, ndaxte xam nañu baatam. ");
INSERT INTO wol2010_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Waaye duñu topp jaambur; dañu koy daw, ndaxte miinuñu baatam.» ");
INSERT INTO wol2010_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Yeesu misaaloon na leen loolu, waaye xamuñu lu mu leen doon wax. ");
INSERT INTO wol2010_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Noonu Yeesu newaat: «Ci dëgg-dëgg maa ngi leen koy wax, man maay buntu gétt gi. ");
INSERT INTO wol2010_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Ñi ma fi jiitu ñépp ay sàcc lañu, ak ay saay-saay; waaye xar yi dégluwuñu leen. ");
INSERT INTO wol2010_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Man maay bunt bi; ku jaar ci man, dinga mucc, dinga mana dugg ak a génn, dinga am it mbooy goo mana fore. ");
INSERT INTO wol2010_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Sàcc bi moom, day sàccsi rekk, di rey ak a yàq. Man damaa ñëw, ngir nit ñi am dund, ba nekk ci naataange. ");
INSERT INTO wol2010_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","«Man maay sàmm bu baax bi. Sàmm bu baax bi day joxe bakkanam ngir ay xaram. ");
INSERT INTO wol2010_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Ki dul sàmm bi tey liggéeyal xaalis rekk waaye moomul xar yi, bu séenee bukki, day daw, bàyyi fa xar ya. Bu ko defee bukki ba dal ca coggal ja, jàpp ca, tasaare ya ca des. ");
INSERT INTO wol2010_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Booba surga day daw, ndaxte xaalis rekk lay liggéeyal, faalewul xar ya. ");
INSERT INTO wol2010_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","15","«Man maay sàmm bu baax bi. Ni ma xame Baay bi te Baay bi xame ma ni, noonu laa xame samay xar, te ñoom it ni lañu ma xame. Te it kat dinaa joxe sama bakkan ngir xar yi. ");
INSERT INTO wol2010_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Am naa yeneen xar yu bokkul ci gétt gii. War naa leena indi, ñoom it, te dinañu déglu sama baat. Benn coggal ay am ak benn sàmm. ");
INSERT INTO wol2010_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","Baay bi bëgg na ma, ndaxte damay joxe sama bakkan ngir jëlaat ko. ");
INSERT INTO wol2010_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Kenn du ko jële ci man; maa koy joxe ci sama coobarey bopp. Am naa it sañ-sañu joxe ko te am naa sañ-sañu jëlaat ko. Loolu la ma sama Baay sant.» ");
INSERT INTO wol2010_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Kàddu yooyee ñoo féewalewaat Yawut yi. ");
INSERT INTO wol2010_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Ñu bare ca ñoom naan: «Dafa ànd ak rab! Dafa dof! Lu tax ngeen koy déglu?» ");
INSERT INTO wol2010_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Waaye ñeneen naan: «Nit ku am ay rab du waxe nii. Ndax rab man na ubbi bëti gumba?» ");
INSERT INTO wol2010_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Am bés ñu doon màggal ca Yerusalem Bés ba ñu sellale woon kër Yàlla ga; ci jamonoy sedd la woon. ");
INSERT INTO wol2010_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Yeesoo nga woon ca kër Yàlla ga, di doxantu ca biir Werandaa bu Suleymaan. ");
INSERT INTO wol2010_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Yawut ya wër ko ne ko: «Kañ nga nuy dindi ci kumpa? Boo dee Almasi bi, wax ko mu leer.» ");
INSERT INTO wol2010_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Yeesu ne leen: «Wax naa leen ko ba noppi, waaye gëmuleen. Jëf yi may def ci sama turu Baay ñoo may seede. ");
INSERT INTO wol2010_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Waaye gëmuleen ndaxte bokkuleen ci samay xar. ");
INSERT INTO wol2010_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Samay xar dinañu dégg sama baat; xam naa leen te ñu ngi may topp. ");
INSERT INTO wol2010_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Dama leen di jox dund gu dul jeex; duñu sànku mukk, te kenn du leen jële ci sama loxo. ");
INSERT INTO wol2010_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Baay bi ma leen jox, moo gëna màgg lépp, te kenn manula jële dara ci loxob Baay bi. ");
INSERT INTO wol2010_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Man ak Baay bi benn lanu.» ");
INSERT INTO wol2010_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Yawut ya daldi foraat ay xeer, bëgg koo sànni, ngir rey ko. ");
INSERT INTO wol2010_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Noonu Yeesu ne leen: «Def naa ci seen kanam jëf yu baax yu bare ci ndigalu Baay bi. Ban ci jëf yooyu moo tax ba ngeen bëgg maa sànni ay doj?» ");
INSERT INTO wol2010_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Yawut ya ne ko: «Jëf ju baax taxul nu bëgg laa sànniy xeer, waaye dangay suufeel turu Yàlla; yaw, nit rekk nga, ba noppi di def sa bopp Yàlla!» ");
INSERT INTO wol2010_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Yeesu ne leen: «Bind nañu ci seen téereb yoon ne: “Yàlla nee na: Ay yàlla ngeen.” ");
INSERT INTO wol2010_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Yàlla wooye na “ay yàlla” ñi mu yónnee kàddoom, te xam nanu ne kenn manula randal waxi Yàlla. ");
INSERT INTO wol2010_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Kon nu ngeen mana waxe ne damay suufeel turu Yàlla ndax li ma ne Doomam laa, man mi Yàlla tànn, yónni ma ci àddina? ");
INSERT INTO wol2010_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Su ma deful sama jëfi Baay, buleen ma gëm; ");
INSERT INTO wol2010_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","waaye su ma ko defee, bu ngeen ma gëmul sax, gëmleen boog samay jëf, ngir ngeen xam te nangu ne maa ngi nekk ci Baay bi te Baay bi nekk na ci man.» ");
INSERT INTO wol2010_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Ñu di ko wuta jàppaat, waaye mu bàyyi leen fa, dem. ");
INSERT INTO wol2010_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Yeesu génn, jàllaat dexu Yurdan, toog fa Yaxya daan sóobe ci ndox bu jëkk. ");
INSERT INTO wol2010_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Nit ñu bare ñëw ci moom, te naan: «Yaxya deful benn kéemaan, waaye li mu wax ci kii yépp, dëgg la.» ");
INSERT INTO wol2010_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Noonu ñu bare gëm ko. ");
INSERT INTO wol2010_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Amoon na benn waay bu woppoon, ñu koy wax Lasaar. Ma nga dëkkoon Betani, moom ak Maryaama ak Màrt, mi mu bokkaloon ndey ak baay. ");
INSERT INTO wol2010_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Maryaama mooy jigéen jiy sottiji latkoloñ ci tànki Boroom bi, fompe ko kawaram. Moom la càmmiñam Lasaar woppoon. ");
INSERT INTO wol2010_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Ñaari jigéeni Lasaar yónnee ca Yeesu ne ko: «Boroom bi, sa xarit wopp na.» ");
INSERT INTO wol2010_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Bi Yeesu déggee xibaar boobu, mu ne: «Lasaar de, woppam jooju du ko mujje; day wone ndamu Yàlla, tey màggal Doomu Yàlla ji.» ");
INSERT INTO wol2010_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Yeesu soppoon na Màrt ak Maryaama ak Lasaar. ");
INSERT INTO wol2010_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Bi mu yégee nag ne Lasaar wopp na, mu toogaat yeneen ñaari fan ca bérab, ba mu nekkoon. ");
INSERT INTO wol2010_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Gannaaw loolu mu ne taalibe ya: «Nanu dellu Yude.» ");
INSERT INTO wol2010_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Taalibe ya ne ko: «Kilifa gi, yàggul dara waa Yude doon nañu la wuta rey ak i xeer, nga di fa dellu?» ");
INSERT INTO wol2010_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Yeesu ne leen: «Xanaa du bëccëg fukki waxtook ñaar la? Kuy dox bëccëg, du fakktalu, ndaxte day gis leeru àddina si. ");
INSERT INTO wol2010_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Waaye kuy dox guddi, dina fakktalu, ndaxte leer nekkul ci moom.» ");
INSERT INTO wol2010_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Yeesu wax loolu, teg ca ne: «Sunu xarit Lasaar nelaw na, waaye maa ngi dem yee ko.» ");
INSERT INTO wol2010_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Taalibe ya ne ko: «Boroom bi, bu nelawee kay, kon dina wér.» ");
INSERT INTO wol2010_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Yeesu dafa bëggoona wax ne, Lasaar dee na, waaye taalibe yi dañoo xalaatoon ne mbiri nelaw rekk lay wax. ");
INSERT INTO wol2010_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Ci kaw loolu Yeesu wax ci lu leer ne: «Lasaar dee na. ");
INSERT INTO wol2010_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Bég naa ngir yéen ndax li ma fa nekkul, ngir seen ngëm gëna dëgër. Waaye nanu ko seeti.» ");
INSERT INTO wol2010_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Noonu Tomaa, ki turam di tekki «Séex bi», daldi ne yeneen taalibe ya: «Nanu dem nun itam, deeyandoo ak moom!» ");
INSERT INTO wol2010_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Bi Yeesu agsee, mu fekk ne bi ñu dencee Lasaar ak léegi, mat na ñeenti fan. ");
INSERT INTO wol2010_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Betani ma nga woon ca wetu Yerusalem, diggante bi matul woon sax ñetti kilomet. ");
INSERT INTO wol2010_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Yawut yu bare ñëwoon nañu kër Màrt ak Maryaama, ngir dëfal leen ci seen deewu càmmiñ. ");
INSERT INTO wol2010_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Bi Yeesu ñëwee, Màrt yég ko, dem di dajeek moom; fekk booba Maryaamaa nga toogoon ca kër ga. ");
INSERT INTO wol2010_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Màrt ne Yeesu: «Boroom bi, boo fi nekkoon de, sama càmmiñ li du dee. ");
INSERT INTO wol2010_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Waaye xam naa ne fii nu tollu sax, loo ñaan Yàlla, mu may la ko.» ");
INSERT INTO wol2010_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Yeesu ne ko: «Sa càmmiñ dina dekki.» ");
INSERT INTO wol2010_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Màrt ne ko: «Xam naa ne dina jóg bésu ndekkite la, keroog bés bu mujj ba.» ");
INSERT INTO wol2010_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Yeesu ne ko: «Man maay ndekkite li, maay dund gi. Ku ma gëm, boo deeyee it, dinga dund. ");
INSERT INTO wol2010_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Rax-ca-dolli kuy dund te gëm ma, doo dee mukk. Ndax gëm nga loolu?» ");
INSERT INTO wol2010_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Mu ne ko: «Waaw, Boroom bi. Gëm naa ne yaay Almasi bi, di Doomu Yàlla, ji wara ñëw àddina.» ");
INSERT INTO wol2010_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Bi Màrt waxee loolu, mu daldi dem wooyi Maryaama ne ko ci pett: «Kilifa gaa ngi fi; mi ngi lay laaj.» ");
INSERT INTO wol2010_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Bi Maryaama déggee loolu, mu daldi jóg, gaawantu dem ca Yeesu. ");
INSERT INTO wol2010_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Te fekk duggagul woon ca dëkk ba, waaye ma nga woon ba tey ca bérab, ba mu daje woon ak Màrt. ");
INSERT INTO wol2010_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Noonu Yawut, ya nekkoon ca kër ga di dëfal Maryaama, gis ko mu ne bërét génn, ñu daldi koy topp, defe ne day jooyi ca bàmmeel ba. ");
INSERT INTO wol2010_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Bi Maryaama agsee nag ca Yeesu, ba gis ko, mu daanu ciy tànkam ne ko: «Boroom bi, boo fi nekkoon, sama càmmiñ du dee.» ");
INSERT INTO wol2010_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Yeesu gis ne mi ngi jooy te Yawut yi ànd ak moom itam ñu ngi jooy. Mu daldi jàq, am naqar wu réy. ");
INSERT INTO wol2010_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Mu ne leen: «Fu ngeen ko denc?» Ñu ne ko: «Kaay gis, Sang bi.» ");
INSERT INTO wol2010_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Yeesu jooy. ");
INSERT INTO wol2010_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Noonu nag, Yawut ya ne: «Gis ngeen ni mu ko bëgge woon!» ");
INSERT INTO wol2010_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Waaye am na ca ñoom ñu doon wax naan: «Moom mi ubbi bëti gumba gi, ndax manul woona fexe ba Lasaar du dee?» ");
INSERT INTO wol2010_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Yeesu dellu am naqar wu réy, daldi dem ca bàmmeel ba. Pax la mu ñu yett ci doj, ube ko xeer. ");
INSERT INTO wol2010_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Yeesu ne: «Dindileen xeer wi!» Màrt, jigéenu ku dee ki ne ko: «Boroom bi, dina xasaw xunn fii mu nekk, ndaxte am na ci bàmmeel bi ñeenti fan.» ");
INSERT INTO wol2010_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Yeesu ne ko: «Ndax waxuma la ne boo gëmee, dinga gis ndamu Yàlla?» ");
INSERT INTO wol2010_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Ñu daldi dindi xeer wa. Yeesu xool ci kaw, ne jàkk asamaan, ñaan Yàlla ne: «Baay, sant naa la ci li nga ma déglu ba noppi. ");
INSERT INTO wol2010_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Xam naa ne doo jóg ci di ma déglu, waaye dama koy wax, ngir nit ñi ma wër gëm ne yaa ma yónni.» ");
INSERT INTO wol2010_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Bi mu waxee loolu, Yeesu woote ak baat bu dëgër ne: «Lasaar, ñëwal ci biti!» ");
INSERT INTO wol2010_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Néew bi daldi génn, ñu gis càngaay, li ñu takke woon tànk yi ak loxo yi, ak kaala, gi ñu muure woon kanam gi. Yeesu ne leen: «Tekkileen ko, bàyyi ko mu dem.» ");
INSERT INTO wol2010_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Yawut yu bare ca ña ñëwoon kër Maryaama te gis li Yeesu defoon, daldi koy gëm. ");
INSERT INTO wol2010_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Waaye amoon na it ñu demoon ci Farisen ya, nettali leen la Yeesu defoon. ");
INSERT INTO wol2010_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Farisen ya ak sarxalkat yu mag ya woo kureelu àttekat ya ne: «Nit kii kat, kéemaan yi muy def a ngi bëgga bare. Lu nuy def nag? ");
INSERT INTO wol2010_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Ndaxte su nu ko bàyyee mu jàppoo nii, ñépp dinañu ko gëm, te kilifay Room yi dinañu ñëw, daaneel sunu kër Yàlla gi, tas sunu réew!» ");
INSERT INTO wol2010_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Amoon na ca ñoom ku ñuy wax Kayif te mu nekkoon sarxalkat bu mag ba at mooma; mu ne leen: «Xamuleen ci mbir mi dara. ");
INSERT INTO wol2010_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Xanaa xamuleen ne, kenn nit rekk dee ngir ñépp, mooy li gën ci yéen? Bu ko defee réew mi du tas.» ");
INSERT INTO wol2010_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Loolu Kayif waxu ko woon ci sagoom, waaye li mu nekkoon sarxalkat bu mag ba at mooma, moo tax Yàlla xiirtal ko mu ne, Yeesu dina dee ngir réew mi. ");
INSERT INTO wol2010_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Du woon rekk ngir xeet woowu, waaye ngir itam doomi Yàlla, yi tasaaroo yépp, dajaloo nekk benn. ");
INSERT INTO wol2010_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Keroog la njiiti Yawut ya dogu ci rey Yeesu. ");
INSERT INTO wol2010_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Taxoon na ba Yeesu dootul doxantu ci biir Yawut ya. Noonu mu dem ca gox bu jege màndiŋ ma, ca dëkku Efrayim. Foofa nag la toog ak ay taalibeem. ");
INSERT INTO wol2010_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Bésu Mucc baa ngi doon jubsi, mu doonoon ag màggal ci Yawut yi, ba ñu bare ca waa àll ba di dem Yerusalem balaa booba, ngir sanguji set. ");
INSERT INTO wol2010_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Ñu ngi doon wut Yeesu tey waxante ca kër Yàlla ga naan: «Lu ngeen ci xam? Ndax dina ñëw ci màggal gi walla déet?» ");
INSERT INTO wol2010_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Sarxalkat yu mag ya ak Farisen ya daldi santaane ne, bu kenn xamee fu Yeesu nekk, mu yégle ko, ngir ñu man koo jàpp. ");
INSERT INTO wol2010_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Juróom benni fan laata ñuy màggal bésu Mucc ba, Yeesu dem na Betani, dëkku Lasaar, mi mu dekkal. ");
INSERT INTO wol2010_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Foofa ñu defaral ko fa reer. Màrt moo ko doon séddale, te Lasaar bokkoon na ca gan ña. ");
INSERT INTO wol2010_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Noonu Maryaama daldi jël liibaru latkoloñ ju raxul ju ñuy wax nàrd, tey jar lu baree bare. Mu sotti ko ci tànki Yeesu, ba noppi fomp ko ak kawaram. Xetu latkoloñ gi gilli ci kër gi yépp. ");
INSERT INTO wol2010_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Kenn ca taalibey Yeesu ya, muy Yudaa Iskariyo, mi ko nara wor, daldi ne: ");
INSERT INTO wol2010_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","«Lu tax jaayewuñu latkoloñ jii peyu atum lëmm, jox ko miskin yi?» ");
INSERT INTO wol2010_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Waaye bi muy wax loolu, xalaatul woon miskin yi, ndaxte sàcc la woon; moo yoroon boyetu xaalis bi, te daan ci sàkk. ");
INSERT INTO wol2010_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Waaye Yeesu ne ko: «Bàyyi ko! Jekkoon na mu denc ko ngir bés bu ñu may suul. ");
INSERT INTO wol2010_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Miskin yaa ngi ak yéen bés bu nekk, waaye dungeen ma gis ba fàww.» ");
INSERT INTO wol2010_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Bi ñu yégee ne Yeesoo nga fa, mbooloom Yawut mu bare daldi dem Betani. Yeesu rekk yóbbuwu leen fa woon, waaye dañoo bëggoona gisaale Lasaar, mi Yeesu dekkaloon. ");
INSERT INTO wol2010_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Sarxalkat yu mag ya dogu ci ne dañuy reyaale Lasaar, ");
INSERT INTO wol2010_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","ndaxte moo waral Yawut yu bare dëddu leen, gëm Yeesu. ");
INSERT INTO wol2010_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Ca ëllëg sa mbooloo mu bare, ma ñëwoon ca màggalu bésu Mucc ba, yég ne Yeesoo ngi jëmsi Yerusalem. ");
INSERT INTO wol2010_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Ñu daldi jël cari garab, génn di ko teeru. Ñuy xaacu naan: «Osaana! Yaw miy ñëw ci turu Boroom bi, ku barkeel nga! Na Yàlla barkeel buuru Israyil!» ");
INSERT INTO wol2010_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Yeesu wut cumbur, war ko; ndaxte Mbind mi nee na: ");
INSERT INTO wol2010_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","«Buleen ragal, waa Siyoŋ. Gis ngeen, seen buur a ngi ñëw, war mbaam mu ndaw.» ");
INSERT INTO wol2010_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Yooyu yépp, taalibe ya xamuñu woon ca saa sa lu muy tekki; waaye gannaaw bi ndamu Yeesu feeñee, ñu fàttaliku ne, Mbind mi yégle woon na loolu ci moom, te amal nañu ko. ");
INSERT INTO wol2010_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Ña nekkoon ak Yeesu ñépp, bi muy wooyee Lasaar mu génn ca bàmmeel ba te mu dekkal ko, demoon nañu, nettali la ñu gis. ");
INSERT INTO wol2010_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Looloo tax mbooloo ma teeru ko, ndaxte yégoon nañu firnde jooju. ");
INSERT INTO wol2010_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Farisen yi nag di waxante naan: «Gis ngeen, manuleen ci dara; ñépp a ngi koy topp!» ");
INSERT INTO wol2010_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Ca mbooloo ma, amoon na ca ay Gereg yu bokk ca ña ñëwoon Yerusalem ngir jaamu Yàlla diirub màggal ga. ");
INSERT INTO wol2010_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Ñëw nañu ci Filib, mi dëkk Betsayda ci diiwaanu Galile, ne ko: «Sang bi, danoo bëggoona gis Yeesu.» ");
INSERT INTO wol2010_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Filib dem wax ko Andare; ñu ànd, waxi ko Yeesu. ");
INSERT INTO wol2010_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Mu ne leen: «Waxtu wi ñu wara feeñale ndamu Doomu nit ki jot na. ");
INSERT INTO wol2010_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Ci dëgg-dëgg maa ngi leen koy wax, fi ak peppu dugub ji wadd ci suuf jaarul ci dee, du mana weesu li mu doon: pepp doŋŋ. Waaye bu deeyee, dina jur pepp yu bare. ");
INSERT INTO wol2010_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Ku bëgg bakkanam dina ko ñàkk, waaye ku ko bañ ci àddina sii, dina ko denc ngir dund gu dul jeex gi. ");
INSERT INTO wol2010_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Ku bëgga doon sama surga, na ma topp. Bu ko defee, fu ma nekk, fa lay nekk moom itam. Ku may liggéeyal, sama Baay dina ko teral. ");
INSERT INTO wol2010_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","«Léegi nag damaa jàq. Lu may wara wax? Mbaa du dama naan: “Baay, musal ma ci li nara xew waxtu wiy ñëw?” Déedéet, ñëw naa sax ngir jaar ci waxtu woowu. ");
INSERT INTO wol2010_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Baay, màggalal sa tur!» Noonu ñu dégg baat bu jóge asamaan naan: «Màggal naa ko ba noppi, te dinaa ko màggalaat.» ");
INSERT INTO wol2010_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Mbooloo ma fa teewoon te dégg baat ba daldi ne: «Dënnu la woon!» Ñeneen naan: «Malaakaa doon wax ak moom.» ");
INSERT INTO wol2010_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Waaye Yeesu ne leen: «Taxuma baat boobu jolli, waaye yéena tax. ");
INSERT INTO wol2010_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Àtteb àddina si jot na: léegi ñu dàq malaaka mu bon, mi jiite àddina si. ");
INSERT INTO wol2010_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Te man, bu ñu ma yékkatee, ma tiim suuf, dinaa xiirtal nit ñépp ci man.» ");
INSERT INTO wol2010_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Ci baat yooyu la doon misaale ni mu wara faatoo. ");
INSERT INTO wol2010_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Mbooloo ma ne ko: «Jàng nanu ci sunu téereb yoon ne, Almasi bi dina sax ba fàww. Kon yaw, nan nga mana waxe ne: “Doomu nit ki dina yékkatiku?” Kuy Doomu nit kooku?» ");
INSERT INTO wol2010_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Yeesu ne leen: «Leer gi dootul yàgg ak yéen. Doxleen, ci bi ngeen dee am leer, ngir lëndëm bañ leena bett. Ndaxte kuy dox ci lëndëm doo xam foo jëm. ");
INSERT INTO wol2010_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Kon ci bi ngeen dee am leer gi, gëmleen ko, ngir ngeen doon doomi leer.» Bi mu waxee loolu ba noppi, Yeesu dafa dem, nëbbatuji leen. ");
INSERT INTO wol2010_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Firnde yi mu leen won yépp taxul ñu gëm ko, ");
INSERT INTO wol2010_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","ngir li yonent Yàlla Esayi waxoon am: «Boroom bi, ana ku gëm sunu waare? Kan la Boroom bi won dooleem?» ");
INSERT INTO wol2010_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Manuñu woona gëm, ndaxte Esayi dafa waxaat ne: ");
INSERT INTO wol2010_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","«Yàlla dafa gumbaal seeni bët, def ba ñu dëgër bopp, ngir seeni bët baña gis, seen xel baña xam, ñu baña waññiku ci man ngir ma wéral leen.» ");
INSERT INTO wol2010_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Esayi dafa wax loolu, ndaxte gisoon na ndamu Yeesu te mi ngi doon wax ci ay mbiram. ");
INSERT INTO wol2010_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Fekk na ci biir njiit yi sax, ñu bare gëmoon nañu Yeesu, waaye Farisen yee tax fésaluñu ko, ndaxte dañoo ragaloon, ñu dàq leen ca jàngu ba. ");
INSERT INTO wol2010_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Ngërëmu nit a leen gënaloon ngërëmu Yàlla. ");
INSERT INTO wol2010_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Yeesu yégle ne: «Ku ma gëm, gëmuloo ma waaye gëm nga ki ma yónni. ");
INSERT INTO wol2010_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Ku ma gis, gis nga ki ma yónni. ");
INSERT INTO wol2010_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Ni ag leer laa wàcce ci àddina, ngir ku ma gëm du des ci lëndëm. ");
INSERT INTO wol2010_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Ku dégg samay wax te toppu leen, du man maa koy daan, ndaxte wàccuma ngir daan àddina, waaye damaa ñëw ngir musal ko. ");
INSERT INTO wol2010_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Ku ma beddeeku te nanguwul samay wax, dina fekk fii li koy daan: sama njànglee koy daan keroog bés bu mujj ba. ");
INSERT INTO wol2010_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Ndaxte waxuma ci sama coobare, waaye Baay bi ma yónni ci boppam, moo ma sant li ma wara wax ak li ma wara jàngle. ");
INSERT INTO wol2010_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Te xam naa ne li muy santaane day joxe dund gu dul jeex. Kon li ma wax, dama koy wax, ni ma ko Baay bi sante.» ");
INSERT INTO wol2010_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Laata màggalu bésu Mucc ba la woon. Yeesu xamoon na ne waxtu wi mu wara génne àddina, dem ca wetu Baay ba, jot na. Ku bëgg ñoñam yi nekk ci àddina la, te bëgg na leen ba fa mbëggeel mana yem. ");
INSERT INTO wol2010_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Yeesu ak taalibe yaa ngi doon reer. Fekk na booba Seytaane xiirtal Yudaa, doomu Simoŋ Iskariyo, ngir mu wori Yeesu. ");
INSERT INTO wol2010_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Yeesu xamoon na ne Yàlla joxoon na ko sañ-sañ ci lépp, xam it ne ca Yàlla la jóge te ca moom lay delluwaat. ");
INSERT INTO wol2010_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Mu daldi jóge ca reer ba, summi mbubbam, daldi jël ab sarbet, laxas ko ci ndiggam. ");
INSERT INTO wol2010_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Noonu mu sotti ndox ci ab këll, daldi tàmbali di raxas tànki taalibe ya, di leen fomp ak sarbet, ba mu laxasaayoo. ");
INSERT INTO wol2010_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Bi mu agsee ba ca Simoŋ Piyeer, kooku ne ko: «Boroom bi, ndax yaw dangaa nara raxas samay tànk?» ");
INSERT INTO wol2010_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Yeesu ne ko: «Xamoo fii mu nekk li may def, waaye dinga ko xami.» ");
INSERT INTO wol2010_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Piyeer ne ko: «Déedéet, duma nangu mukk nga raxas samay tànk.» Yeesu ne ko: «Su ma la raxasul, doo bokk ak man dara.» ");
INSERT INTO wol2010_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Simoŋ Piyeer ne ko: «Kon nag Boroom bi, bul yem rekk ci tànk yi, waaye raxasaaleel loxo yi ak bopp bi!» ");
INSERT INTO wol2010_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Yeesu ne ko: «Ku sangu ba noppi, soxlaatula raxas lu dul ay tànkam, ndaxte set na wecc. Yéen nag set ngeen, waaye du ñépp!» ");
INSERT INTO wol2010_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Fekk Yeesu xamoon na ki ko nara wor, looloo tax mu ne: «Setuleen yéen ñépp.» ");
INSERT INTO wol2010_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Bi mu leen raxasalee seeni tànk ba noppi, Yeesu dafa solaat mbubbam, dellu toogaat ne leen: «Ndax xam ngeen li ma leen defal? ");
INSERT INTO wol2010_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Yéena ngi may wooye “Kilifa gi” ak “Boroom bi,” te wax ngeen dëgg, moom laa. ");
INSERT INTO wol2010_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Kon bu fekkee ne man miy Boroom bi tey Kilifa gi, maa leen raxasal seeni tànk, yéen itam war ngeen di raxasalante seeni tànk. ");
INSERT INTO wol2010_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Bàyyil naa leen fi royukaay, ngir ngeen di jëf, nii ma jëfeek yéen. ");
INSERT INTO wol2010_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Ci dëgg-dëgg maa ngi leen koy wax, jaam gënula màgg sangam, mbaa ndaw, ki ko yónni. ");
INSERT INTO wol2010_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Gannaaw xam ngeen loolu, bu ngeen doxalee noonu, dingeen bég. ");
INSERT INTO wol2010_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","«Yéen ñépp taxuleen may wax; xam naa ñi ma tànn. Waaye li Mbind mi wax, fàww mu am, bi ñu naan: “Ki lekk sama dugub wéq na ma.” ");
INSERT INTO wol2010_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Maa ngi leen koy wax ci teel, bala looloo ñëw, ngir bu ñëwee, ngeen gëm ne Maay ki Nekk. ");
INSERT INTO wol2010_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Ci dëgg-dëgg maa ngi leen koy wax, ku nangu kenn ci ñi may yónni, nangu nga ma, man itam; te ku ma nangu, nangu nga ki ma yónni.» ");
INSERT INTO wol2010_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Bi Yeesu waxee loolu ba noppi, mu jàq, biral ne: «Ci dëgg-dëgg maa ngi leen koy wax, kenn ci yéen dina ma wor.» ");
INSERT INTO wol2010_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Taalibe yi di xoolante, te xamuñu kan lay wax. ");
INSERT INTO wol2010_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Ka Yeesu bëggoon te mu bokkoon ca taalibe ya, ma nga sóonu woon ca kaw Yeesu. ");
INSERT INTO wol2010_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Kooku la Simoŋ Piyeer liyaar, ngir mu laaj Yeesu ki ko taxoon di wax. ");
INSERT INTO wol2010_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Taalibe ba daldi walbatiku ca Yeesu, laaj ko ne: «Boroom bi, kooku kan la?» ");
INSERT INTO wol2010_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Yeesu ne ko: «Dinaa capp dogu mburu ci ndab li; ki ma koy jox, kooku la.» Noonu Yeesu jël dogu mburu, capp ko ca ndab la, daldi koy jox Yudaa, doomu Simoŋ Iskariyo. ");
INSERT INTO wol2010_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Naka la Yudaa jël dog wa, Seytaane dugg ci moom. Yeesu ne ko: «Gaawantul ci li ngay def!» ");
INSERT INTO wol2010_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Amul kenn ca ña fa toogoon ku xam lu tax mu wax ko loolu. ");
INSERT INTO wol2010_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Waaye gannaaw Yudaa moo yoroon boyetu xaalis bi, am ñu xalaat ne, Yeesu dafa koo wax, mu dem jëndi li war ci màggal gi, walla mu ne ko mu dem sarax miskin yi. ");
INSERT INTO wol2010_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Yudaa nag jël dogu mburu ma, daldi génn ca saa sa. Booba guddi woon na. ");
INSERT INTO wol2010_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Bi Yudaa génnee, Yeesu ne: «Léegi nag ndamu Doomu nit ki feeñ na, te ndamu Yàlla feeñ na itam ci moom. ");
INSERT INTO wol2010_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Te bu ma feeñalee ndamu Yàlla, Yàlla itam ci teewaayam dina feeñal ndamu Doomu nit ki, te dina ko def léegi. ");
INSERT INTO wol2010_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Samay soppe, sama nekk ak yéen dootul yàgg. Dingeen may seet, waaye maa ngi leen di wax léegi li ma waxoon Yawut ya: fa ma jëm, dungeen fa mana dem. ");
INSERT INTO wol2010_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Maa ngi leen di jox ndigal lu bees: bëgganteleen. Nangeen di bëggante ni ma leen bëgge. ");
INSERT INTO wol2010_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Ni ñuy xame ne samay taalibe ngeen, mooy ngeen bëggante.» ");
INSERT INTO wol2010_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Simoŋ Piyeer laaj ko ne: «Boroom bi, foo jëm?» Yeesu ne ko: «Fa ma jëm, manuloo ma faa topp léegi, waaye dinga ma toppi ca kanam.» ");
INSERT INTO wol2010_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Piyeer ne ko: «Boroom bi, lu tax manuma laa topp léegi? Àttan naa joxe sama bakkan ngir yaw!» ");
INSERT INTO wol2010_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Yeesu ne ko: «Àttan ngaa joxe sa bakkan ngir man? Ci dëgg-dëgg maa ngi la koy wax, bala ginaar a sab, dinga ma weddi ñetti yoon. ");
INSERT INTO wol2010_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","«Buleen jàq. Gëmleen Yàlla te gëm ma. ");
INSERT INTO wol2010_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Am na néeg yu bare ca sama kër Baay, bu dul woon noonu, ma wax leen ko, ndaxte maa ngi dem defaral leen fa ngeen di dëkk. ");
INSERT INTO wol2010_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Te su ma leen defaralee bérab booba ba noppi, dinaa délsi, yóbbaale leen, ba fu ma nekk, ngeen nekk fa, yéen itam. ");
INSERT INTO wol2010_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Te fa ma jëm, xam ngeen yoon wi.» ");
INSERT INTO wol2010_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Tomaa ne ko: «Boroom bi, xamunu fa nga jëm. Kon nan lanuy mana xame yoon wi?» ");
INSERT INTO wol2010_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Yeesu ne ko: «Man maay yoon wi, maay dëgg te dund it man la. Kenn du ñëw ci Baay bi te jaarul ci man. ");
INSERT INTO wol2010_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Ndegam xam ngeen ma, dingeen xam itam sama Baay. Lu weesu tey, xam ngeen ko te gis ngeen ko.» ");
INSERT INTO wol2010_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Filib ne ko: «Boroom bi, won nu Baay bi; loolu doy na nu.» ");
INSERT INTO wol2010_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Yeesu ne ko: «Ni ma yàggeek yéen te ba tey Filib, xamuloo ma? Ku ma gis, gis nga Baay bi. Kon nag nan ngay mana laaje naan: “Won nu Baay bi”? ");
INSERT INTO wol2010_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Xamuloo ne maa ngi nekk ci Baay bi te Baay baa ngi ci man? Kàddu yi ma leen di wax jógewuñu ci man, waaye Baay bi nekk ci man mooy matal ay jëfam. ");
INSERT INTO wol2010_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Gëmleen li ma leen wax ne maa ngi ci Baay bi te Baay baa ngi ci man; walla boog, gëmleen ndax jëf yi. ");
INSERT INTO wol2010_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Ci dëgg-dëgg maa ngi leen koy wax: képp ku ma gëm dina def, moom itam, jëf yi may def. Dina def sax yu gëna màgg, ndaxte maa ngi dem ci Baay bi. ");
INSERT INTO wol2010_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Te it lu ngeen ñaan ci sama tur dinaa ko def, ngir Doom ji feeñal ndamu Baay bi. ");
INSERT INTO wol2010_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Lu ngeen ñaan ci sama tur, maa koy def. ");
INSERT INTO wol2010_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","«Bu ngeen ma bëggee, dingeen topp sama ndigal. ");
INSERT INTO wol2010_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Te dinaa ñaan Baay bi, mu jox leen beneen Dimbalikat, buy nekk ak yéen ba abadan. ");
INSERT INTO wol2010_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Kooku mooy Xelu Yàlla, mi yor dëgg. Àddina du ko mana nangu, ndaxte gisu ko te xamu ko. Yéen xam ngeen ko, ndaxte mi ngi dëkk ak yéen te dina nekk ci yéen. ");
INSERT INTO wol2010_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Duma leen bàyyi ngeen wéet. Dinaa délsi ci yéen. ");
INSERT INTO wol2010_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Des na tuuti ci kanam, àddina du ma gisati; waaye yéen dingeen ma gis. Dinaa dund, moo tax yéen itam dingeen dund. ");
INSERT INTO wol2010_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Bu keroogee, dingeen xam nag ne nekk naa ci sama Baay, yéen it nekk ngeen ci man, te maa ngi nekk ci yéen. ");
INSERT INTO wol2010_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Ki ma bëgg, mooy kiy nangu samay ndigal te di ko topp. Ku ma bëgg, Baay bi bëgg la, te man dinaa la bëgg, di la feeñu.» ");
INSERT INTO wol2010_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Yudaa —du Yudaa Iskariyo de, beneen la woon— ne ko: «Boroom bi, lu xew, ba nga nar noo feeñu nun rekk, te doo feeñu àddina sépp?» ");
INSERT INTO wol2010_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Yeesu ne ko: «Ku ma bëgg dina sàmm sama kàddu. Sama Baay dina ko bëgg te nun dinanu ñëw ci moom te dëkk ci moom. ");
INSERT INTO wol2010_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Ku ma bëggul doo sàmm sama kàddu. Li may wax nag, jógewul ci man, waaye mi ngi soqikoo ci ki ma yónni. ");
INSERT INTO wol2010_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","«Lii dama leen koy wax ci bi may nekk ak yéen. ");
INSERT INTO wol2010_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Waaye Dimbalikat, bi leen Baay bi di yónnee ci sama tur, muy Xelam mu Sell, dina leen jàngal lépp, di leen fàttali li ma leen waxoon lépp. ");
INSERT INTO wol2010_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","Jàmm laa leen bàyyeel, sama jàmm laa leen jox, jàmm ju àddina manula joxe. Buleen jàq, buleen tiit. ");
INSERT INTO wol2010_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","«Dégg ngeen li ma leen wax: “Dinaa dem, waaye dinaa délsi ci yéen.” Bu ngeen ma bëggoon, dingeen bég ci li may dem ca Baay ba, ndaxte Baay bee ma gëna màgg. ");
INSERT INTO wol2010_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Wax naa leen ko nag léegi, bala looloo ñëw, ngir bu waxtu wa agsee, ngeen gëm. ");
INSERT INTO wol2010_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Lu weesu tey duma amati jotu waxtaan ak yéen, ndaxte malaaka mu bon mi jiite àddina saa ngi ñëw. Kooku manalu ma dara. ");
INSERT INTO wol2010_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Waaye àddina si war na xam ne bëgg naa Baay bi te ni ma ko Baay bi sante, ni laay jëfe. Jógleen, nu dem! ");
INSERT INTO wol2010_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","«Man maay garab gu wóor gi, te sama Baay mooy beykat bi. ");
INSERT INTO wol2010_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Car bu soqikoo ci man te meññul, dina ko dog, sànni. Waaye car bu ci meññ, dina ko tenqi, ngir mu gëna meññ. ");
INSERT INTO wol2010_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Yéen nag, Baay bi setal na leen jaarale ko ci kàddu gi ma leen wax, ni beykat di tenqee garabam. ");
INSERT INTO wol2010_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Saxleen ci man; ma sax, man itam, ci yéen. Ni car manula ame ay doom, bu saxul ci garab, noonu itam dungeen mana meññ li may jëfe ci yéen, bu ngeen saxul ci man. ");
INSERT INTO wol2010_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","«Man maay garab gi; yéen yéenay car yi. Ki sax ci man te ma sax ci moom, dina meññ, ndaxte bu ngeen saxul ci man, dungeen man dara. ");
INSERT INTO wol2010_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Ku saxul ci man dinañu ko sànni ci biti, mu mel ni car bu ñu dagg, ba mu wow. Car yu wow nag, dañu leen di buub, sànni ci sawara, ñu lakk. ");
INSERT INTO wol2010_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Bu ngeen saxee ci man te saxal samay wax ci seen xol, lu ngeen ñaan mu nangu. ");
INSERT INTO wol2010_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Liy feeñal sama ndamu Baay moo di, ngeen di gëna meññ tey wone noonu ne samay taalibe ngeen. ");
INSERT INTO wol2010_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","«Ni ma Baay bi bëggee, noonu itam laa leen bëgge. Saxleen ci mbëggeel googu ma am ci yéen. ");
INSERT INTO wol2010_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Bu ngeen toppee samay ndigal, dingeen sax ci sama mbëggeel, ni ma toppe sama ndigali Baay, ba tax ma sax ci mbëggeelam. ");
INSERT INTO wol2010_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","Wax naa leen loolu, ngir ngeen bokk ci sama mbég, te seen bos mat sëkk. ");
INSERT INTO wol2010_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Sama ndigal mooy ngeen bëggante, ni ma leen bëgge. ");
INSERT INTO wol2010_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Genn mbëggeel manula weesu joxe sa bakkan ngir say xarit. ");
INSERT INTO wol2010_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Samay xarit ngeen, ci kaw ngeen def li ma santaane. ");
INSERT INTO wol2010_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Dootuma leen wooye jaam, ndaxte jaam du xam li sangam di def. Xarit laa leen wooye, ndaxte xamal naa leen li ma jële lépp ci sama Baay. ");
INSERT INTO wol2010_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Du yéen yéena ma tànn, waaye man maa leen tànn, sas leen ngeen dem, meññ meññeef gu sax, ngir Baay bi def lu ngeen ko ñaan ci sama tur. ");
INSERT INTO wol2010_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Li may santaane nag, mooy ngeen bëggante. ");
INSERT INTO wol2010_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","«Bu leen àddina bañee, xamleen ne man lañu jëkka bañ. ");
INSERT INTO wol2010_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Ñi bokk ci ñoom lañu bëgg. Bu ngeen bokkoon ci ñoom, dinañu leen bëgg, ni ñu bëgge seeni ñoñ. Waaye bokkuleen ci àddina, ndaxte maa leen tànn, ber leen. Looloo tax ñu bañ leen. ");
INSERT INTO wol2010_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Fàttalikuleen li ma leen wax: “Jaam gënula màgg sangam.” Bu ñu ma sonalee, dinañu leen sonal yéen itam. Bu ñu toppee sama wax, dinañu topp seen wax yéen itam. ");
INSERT INTO wol2010_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Waaye loolu lépp dinañu leen ko def ndax man, ndaxte xamuñu ki ma yónni. ");
INSERT INTO wol2010_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Su ma ñëwul woon, ne leen dara, duñu am bàkkaar. Waaye léegi amuñu lay ngir seeni bàkkaar. ");
INSERT INTO wol2010_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Ku ma bañ, bañ nga itam sama Baay. ");
INSERT INTO wol2010_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Su ma deful woon ci seen biir jëf yu kenn deful, kon duñu am bàkkaar. Waaye léegi nag gis nañu samay jëf te teewul ñu bañ nu, man ak sama Baay. ");
INSERT INTO wol2010_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Waaye loolu am na ngir kàddu gi am, kàddu gii ñu bind ci seen yoon: “Bañ nañu ma ci dara.” ");
INSERT INTO wol2010_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","«Dimbalikat bi dina ñëw, mooy Xel mi jóge ci Baay bi tey yor dëgg gi. Dina jóge ci Baay bi, ma yebal ko ci yéen. Moom nag, moo may seedeeli. ");
INSERT INTO wol2010_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Te yéen itam dingeen seede samay mbir, ndaxte yéena nekkoon ak man ca njàlbéen ga. ");
INSERT INTO wol2010_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","«Loolu dama leen koo wax ngir seen ngëm baña wàññiku. ");
INSERT INTO wol2010_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Dinañu leen dàq ca jàngu ya, te dinañu dem ba jamono joo xam ne ñi leen di rey dañuy xalaat ne ñu ngi màggal turu Yàlla. ");
INSERT INTO wol2010_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Dinañu agsi foofu, ndaxte xamuñu Baay bi te xamuñu ma. ");
INSERT INTO wol2010_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Loolu nag, wax naa leen ko, ngir bu waxtu wi jotee ngeen fàttaliku ne yégal naa leen ko. Waxuma leen ko ca njàlbéen ga, ndaxte maa ngi nekkoon ak yéen. ");
INSERT INTO wol2010_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","«Léegi nag maa ngi dem ca ka ma yónni, te kenn ci yéen laaju ma fi ma jëm. ");
INSERT INTO wol2010_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Seen xol dafa jeex ndax li ma leen wax. ");
INSERT INTO wol2010_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Moona de, ci sama wàll, dëgg laa leen di wax. Li gën ci yéen mooy ma dem, ndaxte su dul loolu, Dimbalikat bi du ñëw ci yéen; waaye su ma demee, dinaa leen ko yónnee. ");
INSERT INTO wol2010_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Te bu dikkee, dina yey niti àddina ci lu jëm ci seen bàkkaar, ci lu jëm ci sama njubte ak ci lu jëm ci àtte ba. ");
INSERT INTO wol2010_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Ci mbiri seen bàkkaar, dina leen yey ci li ñu ma gëmul. ");
INSERT INTO wol2010_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Ci mbiri sama njubte, dina leen yey ndaxte maa ngi dem ci Baay bi te dungeen ma gisati. ");
INSERT INTO wol2010_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Ci mbiri àtte ba, dina leen yey ndaxte àtte nañu malaaka mu bon mi jiite àddina si, ba daan ko. ");
INSERT INTO wol2010_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","«Li ma leen wara wax bare na, waaye dungeen ko mana dékku. ");
INSERT INTO wol2010_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Bu Xelum Yàlla mi yor dëgg gi dikkee nag, dina leen gindi ci lépp li jëm ci yoonu dëgg, ndaxte du wax ci coobarey boppam, waaye lu ko Baay bi wax, mu jottali leen ko. Dina leen yégal mbir yu ñëwagul. ");
INSERT INTO wol2010_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Dina ma màggal, ndaxte lu mu leen wax, ci man la ko jële. ");
INSERT INTO wol2010_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Lépp lu Baay bi am, maa ko moom. Looloo tax ma ne leen, lu mu leen jottali, ci man la ko jële. ");
INSERT INTO wol2010_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","«Ci kanam tuuti dungeen ma gisati. Bu ñu ci tegee ab diir, ngeen gisaat ma.» ");
INSERT INTO wol2010_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Loolu Yeesu wax, tax na ba am ca taalibe ya, ñu waxante ne: «Lu muy wax nii: “Ci kanam tuuti dungeen ma gisati; bu ñu ci tegee ab diir, ngeen gisaat ma,” ak naan: “Ndaxte maa ngi dem ca Baay ba”?» ");
INSERT INTO wol2010_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Ñu ne: «“Teg cab diir,” lu muy tekki? Xamunu li muy bëgga wax.» ");
INSERT INTO wol2010_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Yeesu gis ne am na lu ñu ko bëgga laaj, mu ne leen: «Dama ne: “Ca kanam tuuti, dungeen ma gis, te bu ñu ca tegee ab diir, ngeen gisaat ma.” Ndax loolu ngeen di laajante ci seen biir? ");
INSERT INTO wol2010_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Ci dëgg-dëgg maa ngi leen koy wax, dingeen jooy xàcc, waaye àddina dina bég; dingeen jàq, waaye seen njàqare dina soppaliku bànneex. ");
INSERT INTO wol2010_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Jigéen ju nekk ci mat, dafay jàq, ndaxte waxtu wi mu wara jur jot na. Waaye bu doom ji juddoo, dina fàtte coonoom ndaxte day bég ci li doom ji gane àddina. ");
INSERT INTO wol2010_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Noonu nag ngeen di jàqe, yéen itam. Waaye dinaa leen gisaat, seeni xol sedd, te seen mbég moomu, kenn du ko mana dindi. ");
INSERT INTO wol2010_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Bés boobu dootuleen ma laaj dara. Ci dëgg-dëgg maa ngi leen koy wax, Baay bi dina leen may lu ngeen ko ñaan ci sama tur. ");
INSERT INTO wol2010_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Ba léegi ñaanaguleen dara ci sama tur. Ñaanleen, mu nangu. Bu ko defee seen mbég mat sëkk. ");
INSERT INTO wol2010_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","«Loolu lépp, dama leen koo wax ci ay misaal. Jamono dina ñëw, ju ma dootul wax ak yéen ci ay misaal, waaye ju ma leen dee wax lu leer ci Baay bi. ");
INSERT INTO wol2010_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Bu keroogee dingeen ñaan ci sama tur. Neewuma dinaa leen ñaanal Baay bi, ");
INSERT INTO wol2010_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","ndaxte Baay bi ci boppam bëgg na leen. Bëgg na leen ndaxte bëgg ngeen ma te gëm ngeen ne ci Yàlla laa jóge. ");
INSERT INTO wol2010_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Jóge naa ca Baay bi, ñëw àddina. Léegi maa ngi génn àddina, fekki Baay bi.» ");
INSERT INTO wol2010_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Taalibe yi ne ko: «Léegi yaa ngi wax lu leer te misaaloo! ");
INSERT INTO wol2010_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Léegi gis nanu ne xam nga lépp, te soxlawul kenn di la laaj dara. Looloo tax nu xam ne yaa ngi jóge ci Yàlla.» ");
INSERT INTO wol2010_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Yeesu ne leen: «Ndax gëm ngeen léegi? ");
INSERT INTO wol2010_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Waxtu waa ngi ñëw te agsi na ba noppi, dingeen tasaaroo, ku nekk ñibbi, ma des man rekk. ");
INSERT INTO wol2010_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Waaye nag déedéet, wéetuma, ndaxte Baay baa ngi may wéttali. Dama leen wax loolu, ngir ngeen am jàmm ci man. Dingeen am nattu ci àddina, waaye takkleen fit yi; not naa àddina.» ");
INSERT INTO wol2010_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Bi mu waxee loolu ba noppi, Yeesu dafa xool ci kaw, ne jàkk asamaan, ñaan Yàlla ne: «Baay, waxtu wi tax ma ñëw ci àddina agsi na. Feeñalal ndamu Doom ji, ngir moom itam mu mana feeñal sa ndam. ");
INSERT INTO wol2010_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Ndaxte jox nga ko sañ-sañ ci bépp mbindeef, ngir mu may dund gu dul jeex gi ñi nga ko dénk. ");
INSERT INTO wol2010_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Dund gu dul jeex gi nag, mooy ñu xam la, yaw jenn Yàlla ju wóor ji am, te ñu xam it ki nga yónni, muy Yeesu Kirist. ");
INSERT INTO wol2010_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Wone naa sa ndam ci àddina, ndax li ma matal liggéey, bi nga ma santoon. ");
INSERT INTO wol2010_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Léegi nag Baay, ci sa teewaay, feeñalal ci man ndam, li ma amoon ci sa wet, laata àddina di sosu. ");
INSERT INTO wol2010_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","«Xamal naa sa tur nit, ñi nga tànne ci àddina te dénk ma leen. Bokkoon nañu ci yaw, nga dénk ma leen, te sàmm nañu sa kàddu. ");
INSERT INTO wol2010_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Xam nañu léegi ne loo ma joxaan, ci yaw la jóge, ");
INSERT INTO wol2010_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","ndaxte xamal naa leen kàddu yi nga ma jox, te nangu nañu ko. Wóor na leen ne ci yaw laa jóge, te gëm nañu ne yaa ma yónni. ");
INSERT INTO wol2010_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","Ñoom laay ñaanal. Ñaanaluma waa àddina, waaye maa ngi ñaanal ñi nga ma dénk, ndaxte ci yaw lañu bokk. ");
INSERT INTO wol2010_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Lu ma am, yaa ko moom, te loo am, maa ko moom; te ñoom ñoo feeñal sama ndam. ");
INSERT INTO wol2010_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Nekkatuma ci àddina, waaye ñoom ñu ngi ci; man, ci yaw laa jëm. Baay bu sell bi, sàmm leen ci sa dooley tur woowu nga ma jox, ngir ñu nekk benn, ni nu nekke benn, man ak yaw. ");
INSERT INTO wol2010_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Bi ma nekkee ak ñoom, daan naa leen sàmm ci sa dooley tur, tur wi nga ma jox. Wottu naa leen, ba kenn ci ñoom sànkuwul, lu dul kiy aji réer ji, ngir li Mbind mi waxoon am. ");
INSERT INTO wol2010_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","«Waaye léegi maa ngi jëmsi ci yaw, te maa ngi wax nii ci bi may nekk àddina, ngir ñu fees ak sama mbég. ");
INSERT INTO wol2010_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Jottali naa leen sa kàddu, te àddina bañ leen, ndax li ñu mel ni man, baña bokk ci àddina soosu. ");
INSERT INTO wol2010_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Ñaanuma nga jële leen àddina, waaye nga yiir leen ci Ibliis. ");
INSERT INTO wol2010_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Dañoo mel ni man; bokkuñu ci àddina. ");
INSERT INTO wol2010_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Samp leen ci dëgg, ngir ñu sell. Sa kàddu mooy dëgg. ");
INSERT INTO wol2010_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Ni nga ma yónnee àddina, noonu laa leen yónnee ci nit ñi. ");
INSERT INTO wol2010_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Sellal naa sama bopp ngir ñoom, ngir ñu sampu ci dëgg te sell. ");
INSERT INTO wol2010_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","«Ñaanaluma leen ñoom rekk, waaye itam ñi may gëm ëllëg ndax seen wax. ");
INSERT INTO wol2010_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Damay ñaan ngir ñépp doon benn. Baay, na ñooñu nekk benn ci nun, ni nga nekke ci man te ma nekke ko ci yaw. Nañu ànd, ba àddina gëm ne yaa ma yónni. ");
INSERT INTO wol2010_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Boole naa leen ci ndam, li nga ma sol, ngir ñu àndandoo, ni nu ànde man ak yaw. ");
INSERT INTO wol2010_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Man ci ñoom, yaw it ci man, ngir ñu gëna ànd, nekk benn, ba àddina xam ne yaa ma yónni, xam ne bëgg nga leen, ni nga ma bëgge. ");
INSERT INTO wol2010_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","«Baay, bëgg naa, ñi nga ma dénk nekk ak man fa ma jëm, ngir ñu gis sama ndam, li nga ma sol, ndaxte bëgg nga ma, laata àddina di sosu. ");
INSERT INTO wol2010_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","«Baay, yaw ku jub ki, waa àddina xamuñu la, waaye man xam naa la, te ñii xam nañu ne yaa ma yónni. ");
INSERT INTO wol2010_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Xamal naa leen sa tur te dinaa ko gëna xamle, ngir mbëggeel, gi nga am ci man, nekk ci ñoom, te man it ma nekk ci ñoom.» ");
INSERT INTO wol2010_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Bi mu waxee noonu ba noppi, Yeesu jóge fa ak i taalibeem, jàll xuru Sedoron, dugg cib tool. ");
INSERT INTO wol2010_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Yudaa mi ko naroona wor xamoon na it bérab ba, ndaxte Yeesu daan na fa dem ak ay taalibeem. ");
INSERT INTO wol2010_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Yudaa daldi fa dem, yóbbaale mbooloom xarekat ak ay alkaati yu ko sarxalkat yu mag ya ak Farisen ya jox. Ñu yor ay jum ak ay làmp ak it gànnaay. ");
INSERT INTO wol2010_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Noonu Yeesu, mi xamoon li ko waroona dal lépp, jubsi leen ne leen: «Ku ngeen di seet?» ");
INSERT INTO wol2010_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Ñu ne ko: «Yeesum Nasaret.» Yeesu ne: «Man la.» Fekk Yudaa mi ko nara wor a nga ànd ak ñoom. ");
INSERT INTO wol2010_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Bi leen Yeesu nee: «Man la,» ñu daldi dellu gannaaw, ba daanu. ");
INSERT INTO wol2010_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Yeesu laajaat leen ne: «Ku ngeen di seet?» Ñu ne ko: «Yeesum Nasaret.» ");
INSERT INTO wol2010_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Mu ne leen: «Wax naa leen ne man la. Bu fekkee ne nag man ngeen di seet, bàyyileen ñii ma àndal, ñu dem.» ");
INSERT INTO wol2010_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Noonu la baat boobu mu waxoon ame: «Baay, kenn sànkuwul ci ñi nga ma dénk.» ");
INSERT INTO wol2010_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Bi Yeesu waxee loolu ba noppi, Simoŋ Piyeer bocci jaasi, ji mu yoroon, daldi dóor surgab sarxalkat bu mag ba, noppu ndijooram dagg. Surga boobu mi ngi tuddoon Malkus. ");
INSERT INTO wol2010_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Waaye Yeesu ne Piyeer: «Roofal jaasi ji ci mbaram. Ndax warumaa naan kaasu naqar, bi ma Baay bi sédd?» ");
INSERT INTO wol2010_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Mbooloom xarekat ya ak seen kilifa ak alkaatiy Yawut ya jàpp Yeesu, daldi yeew, ");
INSERT INTO wol2010_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","jëkk koo yóbbu ca Anas, ndaxte Anas mooy gorob Kayif, mi doon sarxalkat bu mag ba at mooma. ");
INSERT INTO wol2010_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Kayif moo digaloon Yawut ya ne: «Li gën moo di kenn rekk dee, ngir mbooloo mi mucc.» ");
INSERT INTO wol2010_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Bi ñuy yóbbu Yeesu, Simoŋ Piyeer ak keneen ca taalibe ya toppoon nañu ko. Keneen kooku nag, xamante na ak sarxalkat bu mag ba, moo waral mu duggaaleek Yeesu ca biir kër kilifa ga. ");
INSERT INTO wol2010_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Waaye Piyeer, moom, des ca buntu kër ga. Noonu taalibe boobu xamante woon ak sarxalkat bu mag ba génn, wax ak jigéen, ja doon wottu buntu kër ga, fexe Piyeer dugg ci biir. ");
INSERT INTO wol2010_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Mbindaan mi doon wottu bunt bi ne Piyeer: «Mbaa yaw it bokkuloo ci taalibey waa ji?» Mu ne ko: «Déedéet, bokkuma ci.» ");
INSERT INTO wol2010_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Booba dafa seddoon, ba surga ya ak alkaati ya boyal ab taal, di ca jaaru. Piyeer itam taxaw, di jaaru ak ñoom. ");
INSERT INTO wol2010_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Sarxalkat bu mag ba daldi laaj Yeesu ci lu jëm ci taalibeem yi ak ci njàngleem mi. ");
INSERT INTO wol2010_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Yeesu ne ko: «Ci mbooloo laa doon waxe. Ci kër Yàlla ga ak ci ay jàngu, fa Yawut yépp di daje, laa mas di jànglee. Masumaa wax dara di ko nëbb. ");
INSERT INTO wol2010_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Lu tax nga may laaj? Laajal ñi doon déglu li ma leen wax. Ñoom xam nañu li ma doon wax.» ");
INSERT INTO wol2010_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Bi Yeesu waxee loolu, kenn ci alkaati yi nekkoon ci wetam daldi koy pes ne ko: «Ndax nii ngay tontoo sarxalkat bu mag bi?» ");
INSERT INTO wol2010_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Yeesu ne ko: «Su ma waxee lu jaaduwul, wone ko; waaye su ma waxee lu jub, lu tax nga may dóor?» ");
INSERT INTO wol2010_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Anas daldi koy yebal ca Kayif, sarxalkat bu mag ba, ñu yeew ko ba tey. ");
INSERT INTO wol2010_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Fekk na booba Simoŋ Piyeer, moom, ma nga taxaw di jaaru rekk. Ñu laaj ko ne: «Mbaa yaw it bokkuloo ci taalibey waa ji?» Waaye Piyeer weddi ko ne: «Déedéet, bokkuma ci.» ");
INSERT INTO wol2010_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Kenn ci surgay sarxalkat bu mag ba, di mbokku ka Piyeer coroon noppam, ne Piyeer: «Xanaa du yaw laa gisoon ak moom ca tool ba?» ");
INSERT INTO wol2010_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Waaye Piyeer dellu weddi ko. Noonu ginaar daldi sab. ");
INSERT INTO wol2010_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Bi loolu wéyee ñu jële Yeesu ca Kayif, yóbbu ko ca kër boroom réew ma. Ci waxtuw njël la woon. Waaye Yawut ya yéeguñu ca taaxum kaw ma. Dañoo bañoona taq sobe, ngir mana lekk ca ñamu bésu Mucc ba. ");
INSERT INTO wol2010_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Looloo tax Pilaat boroom réew ma génn, dajeek ñoom. Mu laaj leen ne: «Lu ngeen di jiiñ waa jii?» ");
INSERT INTO wol2010_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Ñu ne ko: «Bu deful woon lu bon, duñu la ko jébbalsi.» ");
INSERT INTO wol2010_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Pilaat ne leen: «Jël-leen ko, yéen, te àtte ko ci seen yoon.» Yawut yi ne ko: «Yoon mayu nu, nu àtte nit, teg ko dee.» ");
INSERT INTO wol2010_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Noonu la kàddug Yeesu gi ame, ci li mu misaaloon ni mu wara faatoo. ");
INSERT INTO wol2010_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Gannaaw loolu Pilaat duggaat ca taaxum kaw ma, woo Yeesu ne ko: «Ndax yaa di buuru Yawut yi?» ");
INSERT INTO wol2010_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Yeesu ne ko: «Ndax yaa ko xalaat, wax ko, am dañu la koo xelal ci man?» ");
INSERT INTO wol2010_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Pilaat ne ko: «Mbaa xalaatoo ne man Yawut laa? Sa xeet ak sarxalkat yu mag yi ñoo ma la jébbal. Lan nga def?» ");
INSERT INTO wol2010_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Yeesu ne ko: «Sama kilifteef nekkul ci àddina. Bu sama kilifteef nekkoon àddina, sama surga yi dinañu xeex, ngir bañ ñu jébbal ma Yawut yi. Waaye sama kilifteef nekkul àddina.» ");
INSERT INTO wol2010_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Pilaat ne ko: «Kon yaw buur nga?» Yeesu ne ko: «Wax nga ko; buur laa. Lii moo tax ma juddu, ñëw àddina: ngir wax dëgg gi. Ku bokk ci dëgg dina nangu li ma wax.» ");
INSERT INTO wol2010_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Pilaat laaj ko ne: «Luy dëgg?» Bi mu waxee loolu ba noppi, Pilaat daldi génnaat, jëm ca Yawut ya ne leen: «Gisuma ci moom genn tooñ. ");
INSERT INTO wol2010_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Seen aada laaj na, ma bàyyil leen kenn, saa su ñuy def màggalu bésu Mucc bi. Xanaa ma bàyyil leen “buuru Yawut yi”?» ");
INSERT INTO wol2010_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Noonu ñu daldi yuuxuwaat: «Déedéet, waxunu kii; Barabas lanu wax!» Fekk Barabas moomu taskatu réew la woon. ");
INSERT INTO wol2010_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Noonu Pilaat joxe ndigal, ñu dóor Yeesu ay yar. ");
INSERT INTO wol2010_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Xarekat ya ràbb kaalag dég, teg ko ci boppu Yeesu, solal ko mbubbum xarekat mu xonq curr. ");
INSERT INTO wol2010_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Ñu di ko jegeñsi, di ko pes, naan ko: «Nuyu nanu la, yaw buuru Yawut yi!» ");
INSERT INTO wol2010_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Pilaat génnaat ne leen: «Gis ngeen, maa ngi leen koy indil ci biti, ngir ngeen xam ne waa jii, gisuma ci moom genn tooñ.» ");
INSERT INTO wol2010_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Yeesu nag génn, tegoo mbubbum xarekat mu xonq mi ak kaalag dég gi. Pilaat it ne leen: «Waa jaa ngii!» ");
INSERT INTO wol2010_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Waaye bi ñu ko gisee, sarxalkat yu mag ya ak alkaati ya di yuuxoo naan: «Daaj ko ci bant! Daaj ko ci bant, ba mu dee!» Pilaat ne leen: «Jël-leen ko, yéen, daaj ko ci bant, ndaxte gisuma ci moom genn tooñ.» ");
INSERT INTO wol2010_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Yawut yi ne ko: «Am nanu aw yoon, te ci yoon woowu, war na dee ndaxte teg na boppam Doomu Yàlla.» ");
INSERT INTO wol2010_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Bi Pilaat déggee wax jooju, dafa gëna tiit, ");
INSERT INTO wol2010_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","dugg ca taax ma, daldi ne Yeesu: «Foo jóge?» Waaye Yeesu tontuwu ko. ");
INSERT INTO wol2010_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Pilaat ne ko: «Man ngay baña waxal? Xanaa xamuloo ne am naa sañ-sañu bàyyi la, te am naa itam sañ-sañu daaj la ci bant?» ");
INSERT INTO wol2010_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Yeesu ne ko: «Amuloo benn sañ-sañ ci man su dul bi la Yàlla jox. Looloo tax ba ki ma jébbal ci say loxo am na bàkkaar, bi gëna réy.» ");
INSERT INTO wol2010_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Booba nag la Pilaat doon fexee bàyyi Yeesu. Waaye Yawut ya di yuuxoo naan: «Boo bàyyee kii, doo xaritu buur bi Sesaar. Nit ku teg boppam buur, noonub Sesaar la!» ");
INSERT INTO wol2010_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Bi Pilaat déggee loolu, mu daldi génne Yeesu ca biti, dem toog ca jalub àttekaay ba, ca fu ñuy wax Bérabu doj ya. Ci làkku yawut ñu naan ko Gabata. ");
INSERT INTO wol2010_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Booba ñu ngi waajal màggalu bésu Mucc ba, ca weti digg bëccëg. Pilaat ne Yawut ya: «Seen buur a ngii!» ");
INSERT INTO wol2010_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Waaye ñuy yuuxoo naan: «Na dee! Na dee! Daaj ko ci bant!» Pilaat ne leen: «Ndax seen buur bi, dama koo wara daaj ci bant?» Sarxalkat yu mag ya ne ko: «Amunu benn buur bu dul Sesaar!» ");
INSERT INTO wol2010_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Noonu Pilaat jébbal leen Yeesu, ngir ñu daaj ko ci bant. Bi leen ko Pilaat jébbalee, ñu jël ko, yóbbu. ");
INSERT INTO wol2010_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Yeesu ci boppam gàddu bant ba, génn ngir dem ca fa ñuy wax bérabu Kaaŋu bopp; ñu koy wooye Golgota ci làkku yawut. ");
INSERT INTO wol2010_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Foofa la xarekat ya daaje Yeesu ca bant ba. Ci noonu it ñu daajaale ñaari nit ci wetam, mu nekk ca digg ba. ");
INSERT INTO wol2010_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Pilaat santaane itam ñu bind, teg ko ca kaw bant, ba ñu ko daajoon. Mbind ma lii la wax: «Kii mooy Yeesum Nasaret, buuru Yawut yi.» ");
INSERT INTO wol2010_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Mbind mooma, Yawut yu bare jàng nañu ko, ndaxte fa ñu daajoon Yeesu ca bant ba jege woon na dëkk ba, te mbind ma ci làkku yawut la woon, ci làkku waa Room ak ci gereg. ");
INSERT INTO wol2010_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Noonu sarxalkat yu mag yu Yawut ya ne Pilaat: «Bul bind: “Buuru Yawut,” bindal rekk: “Kii moo ne mooy buuru Yawut yi.”» ");
INSERT INTO wol2010_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Pilaat ne leen: «Xas naa koo bind, du deñ.» ");
INSERT INTO wol2010_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Xarekat ya, bi ñu daajee Yeesu ca bant ba, ba noppi dañoo jël ay yéreem, séddale ko ñeenti cér, ku nekk benn. Jël nañu it mbubbam bu ñu ràbb ca kaw ba ci suuf te amul benn ñaw. ");
INSERT INTO wol2010_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Xarekat ya di waxante naan: «Mbubb mi, bunu ko xotti, waaye nanu ko tegoo ay bant, ngir xam ku koy moom.» Noonu la Mbind mi waroona ame, bi mu naan: «Séddoo nañu samay yére, tegoo ay bant sama mbubb.» Loolu nag la xarekat ya def. ");
INSERT INTO wol2010_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Ca wetu bant, ba ñu daajoon Yeesu, yaayam a nga fa taxawoon, moom ak doomu ndeyam ju jigéen, Maryaama soxnas Këlópas, ak Maryaama mi dëkk Magdala. ");
INSERT INTO wol2010_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Bi Yeesu gisee yaayam taxaw ci wetu taalibe, bi mu bëggoon, mu ne ko: «Soxna si, sa doom a ngi,» ");
INSERT INTO wol2010_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","neeti taalibe ba: «Sa yaay a ngi nii.» Booba la ko taalibe ba yóbbu këram, yor ko. ");
INSERT INTO wol2010_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Bi loolu wéyee, gannaaw Yeesu xam na ne lépp mat na léegi, mu ne nag, ngir amal Mbind mi: «Damaa mar.» ");
INSERT INTO wol2010_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Amoon na foofa gutt bu fees ak bineegar. Noonu ñu jël sagar, tooyal ko ca, takk ko ci caru garab gu ñuy wax isob, teg ko ci gémmiñu Yeesu. ");
INSERT INTO wol2010_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Bi Yeesu muucoo bineegar bi, mu ne: «Lépp mat na!» Noonu mu sëgg, delloo ruuwam Yàlla. ");
INSERT INTO wol2010_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Keroog ba ñu dee waajal bésub noflaay ba la woon, te Yawut ya bëgguñu néew ya des ca bant ya, ndaxte bésub noflaay boobu fonkoon nañu ko lool. Ñu ñaan Pilaat, mu dammlu tànki ña ñu daajoon, te jële leen fa. ");
INSERT INTO wol2010_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Noonu xarekat ya dem, damm tànki ku jëkk ka, teg ca ka ca des, ca ña ñu daajaale woon ak Yeesu. ");
INSERT INTO wol2010_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Bi ñu agsee ci Yeesu, dammuñu ay tànkam, ndaxte gis nañu ne booba faatu na. ");
INSERT INTO wol2010_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Waaye kenn ca xarekat ya daldi jël xeej, jam ko ko ci wet, ca saa sa deret ak ndox di tuuru. ");
INSERT INTO wol2010_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Kiy nettali mbir yooyu, da cee teg bëtam, te li muy wax dëgg la. Moom ci boppam xam na ne li muy wax dëgg la, ngir yéen itam ngeen gëm, ");
INSERT INTO wol2010_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","ndaxte loolu dafa xew ngir Mbind mi am: «Benn yaxam du damm.» ");
INSERT INTO wol2010_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Leneen it Mbind mi wax na ko: «Dinañu gis ki ñu jamoon.» ");
INSERT INTO wol2010_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Gannaaw loolu Yuusufa mi dëkk Arimate ñaan Pilaat ngir yóbbu néewu Yeesu. Yuusufa taalibe Yeesu la woon ci lu kenn yégul, ndaxte dafa ragaloon Yawut ya. Pilaat may ko ko. Yuusufa daldi dem, yóbbu néewu Yeesu. ");
INSERT INTO wol2010_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Nikodem itam ñëw, moom mi masoona seeti Yeesu guddi. Mu indaale lu wara tollook fanweeri kiloy cuuraay lu ñu defare ndàbbi miir ak banti alowes. ");
INSERT INTO wol2010_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Ñu jël néewu Yeesu, laxas ko ci càngaay, boole ko ak cuuraay li, ni ko Yawut yi tàmmoo def, bu ñuy waajal néew. ");
INSERT INTO wol2010_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Tool a nga woon ca wetu bérab, ba ñu daajoon Yeesu, te ca tool booba amoon na fa bàmmeel bu ñu masula suul kenn. ");
INSERT INTO wol2010_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Ca bésu Waajal la woon, ba Yawut ya doon waajal bésub noflaay ba, te bàmmeel ba jege woon na. Foofa lañu denc Yeesu. ");
INSERT INTO wol2010_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Bés ba jiitu ca ayu-bés ga, Maryaamam Magdala jóg ca fajar, dem ca bàmmeel ba. Bi mu agsee, mu gis ne dindi nañu xeer, wa ñu ko ube woon. ");
INSERT INTO wol2010_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Mu daw, dem ca Simoŋ Piyeer ak ca beneen taalibe ba, maanaam ka Yeesu bëggoon, ne leen: «Jële nañu néewu Boroom ba ca bàmmeel ba, te xamunu fu ñu ko yóbbu.» ");
INSERT INTO wol2010_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Piyeer ak beneen taalibe ba daw, dem ca bàmmeel ba. ");
INSERT INTO wol2010_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Ñoom ñaar ñépp a ngi doon daw, waaye beneen taalibe ba raw Piyeer, jëkk ko ca bàmmeel ba. ");
INSERT INTO wol2010_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Duggul nag, dafa sëgg, yër, séen càngaay la ca suuf. ");
INSERT INTO wol2010_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Noonu Simoŋ Piyeer, mi ko toppoon, agsi, daldi dugg. Mu séen càngaay la ci suuf, ");
INSERT INTO wol2010_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","ak kaala ga muuroon boppu Yeesu. Waaye kaala googu àndul ak càngaay la; dañu ko laxas, teg ko ci wet. ");
INSERT INTO wol2010_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Noonu keneen ka jiitu woon ca bàmmeel ba, duggsi moom itam. Naka la gis, daldi gëm. ");
INSERT INTO wol2010_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Taalibe yi xamaguñu woon Mbind mi doon wone ne Yeesu dafa wara dekki. ");
INSERT INTO wol2010_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Noonu taalibe ya dëpp, ñibbi. ");
INSERT INTO wol2010_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Maryaama nag moom, ma nga desoon ca biti, ca wetu bàmmeel ba, di jooy. Bi muy jooy, mu sëgg, yër ci biir, ");
INSERT INTO wol2010_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","séen ñaari malaaka yu sol mbubb yu weex, toog ca bérab, ba ñu dencoon Yeesu; kenn ka féeteek bopp bi, ki ci des ca tànk ya. ");
INSERT INTO wol2010_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Malaaka ya laaj ko ne: «Jigéen ji, looy jooy?» Mu ne leen: «Dañoo jël sama Boroom, te xawma fu ñu ko yóbbu.» ");
INSERT INTO wol2010_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Bi mu waxee loolu, mu geestu, séen Yeesu mu taxaw, waaye xamul woon ne moom la. ");
INSERT INTO wol2010_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Yeesu laaj ko ne: «Jigéen ji, looy jooy? Kooy seet?» Mu foog ne boroom tool ba la, ne ko: «Sëriñ bi, bu fekkee yaa ko yóbbu, wax ma foo ko denc, ma jëli ko.» ");
INSERT INTO wol2010_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Noonu Yeesu ne ko: «Maryaama.» Mu walbatiku, làkk ko ci yawut ne ko: «Ràbbuni!» Ràbbuni mooy tekki «Kilifa gi». ");
INSERT INTO wol2010_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Yeesu ne ko: «Bu ma téye, ndaxte yéegaguma ca Baay ba. Waaye demal, ne samay bokk, maa ngi yéeg ca sama Baay biy seen Baay, ca sama Yàlla jiy seen Yàlla.» ");
INSERT INTO wol2010_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Noonu Maryaamam Magdala dem, yégali ko taalibe ya ne leen: «Gis naa Boroom bi!» Mu daldi leen nettali li mu ko wax. ");
INSERT INTO wol2010_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Bés boobu ca ngoon sa, taalibe yaa nga daje woon ca genn kër, tëju ca biir ndax ragal Yawut ya. Yeesu ne tëll ci seen biir ne leen: «Na jàmm wàcc ci yéen!» ");
INSERT INTO wol2010_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Mu daldi leen won ay loxoom ak wetam. Bi ñu gisee Boroom bi, taalibe ya daldi bég lool. ");
INSERT INTO wol2010_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Yeesu dellu ne leen: «Na jàmm wàcc ci yéen! Ni ma Baay bi yónnee, noonu laa leen di yónnee, man itam.» ");
INSERT INTO wol2010_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Bi mu waxee loolu, mu ëf leen ne leen: «Sol naa leen Xelu Yàlla mu Sell mi. ");
INSERT INTO wol2010_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Ñi ngeen di baal seeni bàkkaar, baal nañu leen ba noppi; ñi ngeen baalul, baaluñu leen.» ");
INSERT INTO wol2010_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Fekk na Tomaa, mi bokk ci fukki taalibe yi ak ñaar, te turam di tekki «Séex bi», nekku fa woon, bi Yeesu ñëwee. ");
INSERT INTO wol2010_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Yeneen taalibe yi ne ko: «Gis nanu Boroom bi!» Mu ne leen: «Su ma gisul fa ñu daajoon pont ya ci ay loxoom, te defuma ca sama baaraam, su ma tegul it sama loxo ci wetam, duma ko gëm mukk.» ");
INSERT INTO wol2010_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Bi ñu ca tegee ayu-bés, taalibe Yeesu ya dajewaat ca biir kër ga, Tomaa itam a nga fa woon. Bunt yépp tëju woon nañu, waaye Yeesu ne tëll ci seen biir ne leen: «Na jàmm wàcc ci yéen!» ");
INSERT INTO wol2010_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Noonu mu ne Tomaa: «Indil sa baaraam fii te seet sama loxo; indil sa loxo, teg ko ci sama wet. Bàyyil di weddi te nga gëm.» ");
INSERT INTO wol2010_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Tomaa ne ko: «Sama Boroom, sama Yàlla!» ");
INSERT INTO wol2010_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Yeesu ne ko: «Li nga ma gis a tax nga gëm? Ki bég mooy ki gëm te gisu ma!» ");
INSERT INTO wol2010_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Yeesu wone na it ci kanam taalibe ya yeneen firnde yu ñu nettaliwul ci téere bii. ");
INSERT INTO wol2010_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Waaye li ci nekk, bind nañu ko ngir ngeen gëm ne Yeesu mooy Almasi bi, Doomu Yàlla ji, te seen ngëm may leen, ngeen am ci moom dund. ");
INSERT INTO wol2010_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Bi ñu ca tegee ab diir, Yeesu feeñuwaat na ay taalibeem ca tefesu dex gu ñuy wax Tiberyàdd. Nii la deme woon: ");
INSERT INTO wol2010_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Taalibey Yeesu yii àndoon nañu: Simoŋ Piyeer; Tomaa, ki turam di tekki «Séex bi»; Nataneel, mi dëkk Kana ca diiwaanu Galile; doomi Sebede ak yeneen ñaari taalibe. ");
INSERT INTO wol2010_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Simoŋ Piyeer ne leen: «Maa ngi nappi.» Ñu ne ko: «Nun it danuy ànd ak yaw.» Ñu dugg gaal, daldi dem. Waaye guddi googu jàppuñu dara. ");
INSERT INTO wol2010_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Ci fajar gi Yeesu taxaw ca tefes ga, waaye taalibe yi xàmmiwuñu ko. ");
INSERT INTO wol2010_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Yeesu ne leen nag: «Bokk yi, xanaa jàppuleen jën?» Ñu ne ko: «Déedéet.» ");
INSERT INTO wol2010_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Mu ne leen: «Sànnileen mbaal mi ci ndijooru gaal gi, bu ko defee ngeen jàpp.» Ñu sànni fa mbaal ma, mu fees ak jën, ba manuñu ko woona génne ndox mi. ");
INSERT INTO wol2010_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Taalibe ba Yeesu bëggoon, ne Piyeer: «Boroom bi la!» Bi Simoŋ Piyeer déggee loolu, dafa woddoo mbubbam, ndaxte dafa summiku woon, daldi sóobu ci dex gi. ");
INSERT INTO wol2010_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Yeneen taalibe ya xëcc mbaal, mi fees dell ak jën, jëme ko ca tefes ga, ndaxte gaal ga sorewul woon; diggante bi waroon na tollook téeméeri meetar. ");
INSERT INTO wol2010_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Bi ñu teeree, ñu gis ab taal, ñu ciy lakk ay jën, teg mburu ca wet ga. ");
INSERT INTO wol2010_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Yeesu ne leen: «Indileen ci jën, yi ngeen jàpp.» ");
INSERT INTO wol2010_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Simoŋ Piyeer yéeg ca gaal ga, daldi xëcc mbaal ma ca tefes ga, mu fees dell ak jën yu mag; matoon na téeméeri jën ak juróom fukk ak ñett. Te li muy baree bare lépp, taxul mbaal ma dog. ");
INSERT INTO wol2010_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Yeesu ne leen: «Ñëwleen ndékki.» Kenn ci taalibe yi ñemewu koo laaj ki mu doon, ndaxte xam nañu ne Boroom bi la. ");
INSERT INTO wol2010_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Yeesu jegeñsi, jël mburu mi, jox leen, jox leen it jën. ");
INSERT INTO wol2010_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Bi Yeesu dekkee ba tey, bii mooy ñetteelu yoon, bi mu feeñoo ay taalibeem. ");
INSERT INTO wol2010_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Bi ñu ndékkee ba noppi, Yeesu ne Simoŋ Piyeer: «Simoŋ doomu Yowaana, ndax gën nga maa bëgg, ni ma ñii bëgge?» Mu ne ko: «Ahakay, Boroom bi, xam nga ne bëgg naa la.» Yeesu ne ko: «Topptool ma sama mbote yi.» ");
INSERT INTO wol2010_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Noonu mu waxaat ko ne: «Simoŋ doomu Yowaana, ndax bëgg nga ma?» Mu ne ko: «Ahakay, Boroom bi, xam nga ne bëgg naa la.» Yeesu ne ko: «Sàmmal ma sama xar yi.» ");
INSERT INTO wol2010_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Mu neeti ko ñetteel bi yoon: «Simoŋ doomu Yowaana, bëgg nga maam?» Piyeer am naqar ci li mu ko laaj ñetti yoon: «Ndax bëgg nga ma?» Mu ne ko: «Boroom bi, xam nga lépp; xam nga ne bëgg naa la.» Yeesu ne ko: «Topptool ma sama xar yi. ");
INSERT INTO wol2010_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Ci dëgg-dëgg Piyeer, maa ngi la koy wax, bi nga dee ndaw yaa doon takk sa geño, di dem fu la neex. Waaye boo màggatee, dinga tàllal say loxo, keneen takkal la sa geño, yóbbu la foo bëggul.» ");
INSERT INTO wol2010_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Ci baat yooyu la Yeesu doon misaale nan la Piyeer wara faatoo ngir jollil ndamu Yàlla. Noonu Yeesu ne ko: «Toppal ci man!» ");
INSERT INTO wol2010_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Piyeer geestu, gis taalibe bi Yeesu bëggoon, di ñëw ci seen gannaaw. Taalibe boobu mooy ki sóonu woon ca Yeesu, ba ñuy lekk, te laajoon ko ne: «Boroom bi, kan moo lay wori?» ");
INSERT INTO wol2010_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Piyeer gis ko, daldi ne Yeesu: «Kii nag, Boroom bi, nu muy mujje?» ");
INSERT INTO wol2010_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Yeesu ne ko: «Su ma neexoon mu dund, ba ma délsi, lu ciy sa yoon? Yaw toppal ci man.» ");
INSERT INTO wol2010_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Noonu am, ci bokki taalibe yi, ñu xalaat ne, taalibe boobu du dee. Moona Yeesu masul ne Piyeer, du dee; waaye li mu wax mooy: «Su ma neexoon mu dund, ba ma délsi, lu ciy sa yoon?» ");
INSERT INTO wol2010_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Taalibe boobu mooy seede mbir yooyu, bind leen, te xam nanu ne li muy wax dëgg la. ");
INSERT INTO wol2010_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Yeesu def na yeneen jëf yu bare. Su ñu ko doon nettali, bind lépp, xalaat naa ne téere yi duñu xaj ci àddina. ");
INSERT INTO wol2010_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Yaw Teyofil, téere bu jëkk, ba ma bindoon, ëmb na lépp li Yeesu tàmbali woona jëf ak a jàngle, ");
INSERT INTO wol2010_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","ba ci bés, ba ko Yàlla yéege ci asamaan. Lu ko jiitu joxoon na ay ndigal, jaare ci Xel mu Sell mi, jëm ci ndaw ya mu tànnoon. ");
INSERT INTO wol2010_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Gannaaw ay coonoom, ñëw na ci ñoom, di leen won ay firnde yu bare te wér ne mu ngi dund; mu feeñu leen diirub ñeent fukki fan, di diisoo ak ñoom ci lu jëm ci nguuru Yàlla. ");
INSERT INTO wol2010_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Am bés muy lekk ak ñoom, mu sant leen ne: «Buleen sore Yerusalem, waaye ngeen xaar li Baay bi dige woon te ma waxoon leen ko. ");
INSERT INTO wol2010_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Ndaxte Yaxya daa na sóob nit ñi ci ndox, waaye yéen dees na leen sóob ci Xel mu Sell mi fi ak ay fan yu néew.» ");
INSERT INTO wol2010_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Bi ñu dajaloo ak moom nag, ñu laaj ko: «Boroom bi, ndax ci jamono jii ngay yékkatiwaat nguuru Israyil?» ");
INSERT INTO wol2010_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Mu ne leen: «Ngeen xam jamono yi ak saa, yi Baay bi dogal ci sañ-sañam, loolu mayuñu leen ko. ");
INSERT INTO wol2010_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Waaye bu Xel mu Sell mi ñëwee ci yéen, dingeen jot kàttan te nekk samay seede ci dëkku Yerusalem, ca diiwaani Yude ak Samari yépp ak ba fa àddina yem.» ");
INSERT INTO wol2010_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Bi mu waxee loolu, te ñu di ko xool, Yàlla yéege na ko, te aw niir jël ko, làq ko seeni bët. ");
INSERT INTO wol2010_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Bi muy dem nag, te ñu ne jàkk asamaan, ñaar ñu sol yu weex daldi ne seef, taxaw ci seen wet. ");
INSERT INTO wol2010_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Ñu ne leen: «Yéen waa Galile, lu tax ngeen taxaw, di xool ci asamaan? Yeesu male ñu jële ci seen biir, yéege ko asamaan, dina délsi ni ngeen ko gise, muy dem asamaan.» ");
INSERT INTO wol2010_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Bi loolu amee ñu jóge ca tund, woowu ñuy wax tundu Oliw ya, te mu dend ak Yerusalem lu tollu ak kilomet, ñu daldi dellu Yerusalem. ");
INSERT INTO wol2010_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Bi ñu dikkee, ñu yéeg ca néeg, ba sut ca taax ma, fa ñuy dal. Ñoo doon Piyeer ak Yowaana, Saag ak Andare, Filib ak Tomaa, Bartelemi ak Macë, Saag doomu Alfe, ak Simoŋ mi bokkoon ci mbooloo mi ñuy wax Ñi farlu ci moom seen réew; ak Yudaa doomu Saag. ");
INSERT INTO wol2010_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Ñoom ñépp ñoo bokk menn xel, di wéy ci ñaan ci Yàlla, ànd ak jigéen ñi ak Maryaama, ndeyu Yeesu, ak rakki Yeesu yu góor. ");
INSERT INTO wol2010_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Ca bés yooya nag Piyeer taxaw ca digg bokk ya, di mbooloo mu tollu ni téeméer ak ñaar fukk. ");
INSERT INTO wol2010_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","Mu ne leen: «Bokk yi, li Xel mu Sell mi waxoon ci Mbind mi jaarale ko ci gémmiñu Daawuda, fàww mu am. Waxoon na ci mbirum Yudaa, mi wommat ñi jàpp Yeesu ");
INSERT INTO wol2010_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","te mu bokkoon ci nun, ba am cér ci liggéey bi.» ");
INSERT INTO wol2010_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","—Pey gi Yudaa jotoon ci ñaawteefam, mu jënd ci tool, daanu fa, ba fàcc, ay butitam tuuru. ");
INSERT INTO wol2010_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Loolu siiwoon na ci waa Yerusalem, moo tax ci seen làkk ñuy tudde tool ba Akeldama, maanaam «Toolu deret».— ");
INSERT INTO wol2010_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Piyeer teg ca ne: «Ndaxte lii lañu bind ci téereb Sabóor: “Na këram gental, bu fa kenn dëkk.” Te it: “Na keneen bey sasam.” ");
INSERT INTO wol2010_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","Kon ñeel na nu, nu tànn kenn ci ñi bokk ak nun, diir bi Yeesu doon dem ak a dikk ci sunu biir, ");
INSERT INTO wol2010_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","li dale ci bi ko Yaxya sóobee ci ndox, ba bés ba ko Yàlla jële ci sunu biir, yéege ko. Kooku war na ànd ak nun, di seedeel ndekkitel Yeesu.» ");
INSERT INTO wol2010_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Bi ko Piyeer waxee, ñu tudd ñaar: Yuusufa, mi ñu dippee Barsabas te di ko dàkkentale Yustus, moom ak Macas. ");
INSERT INTO wol2010_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Ñu ñaan ci Yàlla ne: «Boroom bi, yaw mi xam xolu nit ñépp, won nu ki nga tànn ci ñaar ñii, ");
INSERT INTO wol2010_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","mu yenu liggéeyu nekk sa ndaw, wuutu Yudaa, mi ko bàyyi, dem bérabam.» ");
INSERT INTO wol2010_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Noonu ñu boole leen, tegoo ay bant, bant ba dal ca Macas, mu fekki fukki ndaw ya ak benn. ");
INSERT INTO wol2010_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Bi bésu màggalu Pàntakot agsee, ñoom ñépp booloo nañu ci benn bérab. ");
INSERT INTO wol2010_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Ca saa sa riir jollee asamaan, mel ni ngelaw lu gaaw te bare doole, daldi fees dell kër, ga ñu toog. ");
INSERT INTO wol2010_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Te ay làmmiñ yu mel ni sawara feeñu leen, ñu tasaaroo ci seen biir, toŋ ca kaw kenn ku nekk. ");
INSERT INTO wol2010_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Noonu ñu fees ak Xel mu Sell mi ñoom ñépp, ñu daldi wax yeneen làkk, ni leen Xel mu Sell mi maye, ñu wax ko. ");
INSERT INTO wol2010_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Fekk booba amoon na ay Yawut yu daloon Yerusalem, doon ay nit ñu ragal Yàlla te bokk ci xeeti àddina yépp. ");
INSERT INTO wol2010_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Bi nit ñi déggee riir ma nag, ñépp dajaloo, daldi waaru ci li ñu leen dégg, ñuy wax ku nekk sa làkk. ");
INSERT INTO wol2010_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Ñu waaru te yéemu naa: «Gisleen, ñiy wax ñépp, ndax duñu waa diiwaanu Galile? ");
INSERT INTO wol2010_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Naka la mana ame nag, nu di leen dégg, kenn ku nekk ci nun, ñuy wax ci sa làmmiñ, wi nga nàmp? ");
INSERT INTO wol2010_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Nun ñi ay Pàrt, waa Medi ak waa Elam, nun ñi dëkk Mesopotami, réewu Yawut yi, Kapados, Pont ak Asi, ");
INSERT INTO wol2010_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","di waa Firisi, Pamfili, Misra ak weti Libi, yi dend ak Siren, nun ak gan ñi jóge Room, ");
INSERT INTO wol2010_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","Yawut yi ak ñi tuub ci yoonu Yawut yi, waa Keret ak waa Arabi, nun ñépp nu ngi leen di dégg, ñuy yégle màggaayi Yàlla ci sunuy làkk!» ");
INSERT INTO wol2010_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Noonu ñépp waaru, ba jaaxle lool, ñuy waxante ci seen biir ne: «Lii lu muy tekki?» ");
INSERT INTO wol2010_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Waaye ñenn ñi di leen ñaawal ne: «Waay! Ñii dañoo màndi ak biiñ.» ");
INSERT INTO wol2010_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Ci kaw loolu Piyeer taxaw, ànd ak fukki ndaw ya ak benn, mu wax ci kaw, di yégal mbooloo ma ne: «Bokki Yawut yi ak yéen ñépp ñi dëkk Yerusalem, dégluleen bu baax te xam lii ma leen di wax! ");
INSERT INTO wol2010_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Nit ñii màndiwuñu, ci ni ngeen ko fooge, ndaxte nu ngi ci yoor-yoor rekk. ");
INSERT INTO wol2010_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Waaye lii mooy li Yàlla waxoon, jaarale ko ci yonentam Yowel ne: ");
INSERT INTO wol2010_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","“Yàlla nee na: Ci bés yu mujj yi, dinaa tuur ci sama Xel ci kaw nit ñépp; seen xeet wu góor ak wu jigéen dinañu wax ci kàddug Yàlla; waxambaane yi dinañu gis ay peeñu te màggat yi di gént ay gént. ");
INSERT INTO wol2010_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Waaw, ci bés yooyu dinaa tuur ci sama Xel ci sama kaw jaam yu góor ak yu jigéen, te dinañu wax ci kàddug Yàlla. ");
INSERT INTO wol2010_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Dinaa wone ay kéemaan ci kaw ci asamaan ak ay firnde ci suuf ci àddina, muy deret, sawara ak ay niiri saxar. ");
INSERT INTO wol2010_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Jant bi dina daldi lëndëm, weer wi deretal, bala bésu Boroom biy ñëw, di bés bu mag, bi ànd ak ndam. ");
INSERT INTO wol2010_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Booba nag ku woo Boroom bi ci aw turam, dinga mucc.” ");
INSERT INTO wol2010_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","«Yéen bokki Israyil, dégluleen wax jii! Yeesu mi dëkk Nasaret, nit la woon, ku Yàlla dëggal ci seen kanam ciy kéemaan, ay jaloore ak firnde, ya Yàlla defoon jaarale ko ci moom ci seen biir; yéen xam ngeen ko. ");
INSERT INTO wol2010_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Moom nag jébbale nañu ko, jaar ci nas, bi Yàlla dogaloon te xam ko lu jiitu; te yéen rey ngeen ko ci daaj ko ci bant, jaarale ko ci loxoy bàkkaarkat. ");
INSERT INTO wol2010_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Waaye Yàlla dekkal na ko, daggal ko buumi dee, ndaxte dee manu koo téye. ");
INSERT INTO wol2010_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Daawuda wax na ci mbiram ne: “Saa su ne gis naa Boroom bi ci sama kanam; gannaaw mu ngi ci sama ndijoor, duma raf. ");
INSERT INTO wol2010_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Moo tax sama xol sedd, may woy sama bànneex, te it sama yaram di tëdd ci yaakaar. ");
INSERT INTO wol2010_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Ndaxte doo bàyyi sama ruu ci barsàq, te doo seetaan sa waa ju sell, mu yàqu. ");
INSERT INTO wol2010_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Xamal nga ma yoonu dund; dinga ma béglooji ci sa kanam.” ");
INSERT INTO wol2010_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","«Bokk yi, man naa leena wax lu wóor ci mbirum maam Daawuda, ne dee na te suul nañu ko; bàmmeelam mu ngi ci nun ba tey. ");
INSERT INTO wol2010_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Waaye yonent la woon, te xamoon na ne Yàlla digoon na ko ci ngiñ ne dina teg ci nguuram kenn ci askanam. ");
INSERT INTO wol2010_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Kon gis na lu ñëwagul, di wax ci mbirum ndekkitel Kirist ne bàyyiwuñu ko ci barsàq, te yaramam yàquwul. ");
INSERT INTO wol2010_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Yeesu moomu nag, Yàlla dekkal na ko; nun ñépp seede nanu ko. ");
INSERT INTO wol2010_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Yàlla yéege na ko ak ndijooram, te jot na ci Baay bi Xel mu Sell mi ñu dige woon, ba tuur lii ngeen gis te dégg ko. ");
INSERT INTO wol2010_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Ndaxte du Daawudaa yéeg ci asamaan, waaye moom ci boppam nee na: “Boroom bi wax na sama Boroom: ‘Toogal ci sama ndijoor, ");
INSERT INTO wol2010_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","ba kera may daaneel say noon ci sa kanam.’ ” ");
INSERT INTO wol2010_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","«Na bànni Israyil gépp xam bu wóor nag ne Yeesu moomu ngeen daajoon ci bant, Yàlla def na ko Boroom ak Almasi bi.» ");
INSERT INTO wol2010_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Bi ko mbooloo ma déggee, naqaru xol wu metti jàpp leen; ñu daldi ne Piyeer ak ndaw ya ca des: «Bokk yi, lu nu wara def?» ");
INSERT INTO wol2010_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Piyeer ne leen: «Tuubleen seeni bàkkaar, te kenn ku nekk ci yéen, ñu sóob ko ci ndox ci turu Yeesu Kirist. Noonu Yàlla dina leen baal seeni bàkkaar te may leen Xel mu Sell mi. ");
INSERT INTO wol2010_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Ndaxte li Yàlla dige woon, yéena ko moom ak seeni doom ak ñu sore ñépp, di ñépp ñi Yàlla sunu Boroom di woo ci moom.» ");
INSERT INTO wol2010_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Noonu mu artu leen ak yeneen wax yu bare, di leen dénk ne: «Rëccleen ci niti jamono ju dëng jii.» ");
INSERT INTO wol2010_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Ñi nangu ay waxam nag, ñu sóob leen ci ndox, te ca bés booba lu mat limub ñetti junniy nit yokku nañu ci ñoom. ");
INSERT INTO wol2010_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Ñoom nag ñuy wéy ci njànglem ndaw yi ak cig bokk, ci damm mburu ak ñaan ci Yàlla. ");
INSERT INTO wol2010_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Ragal jàpp ñépp, te ndaw yi di def ay kéemaan ak ay firnde yu bare. ");
INSERT INTO wol2010_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Ñi gëm nag dañoo booloo te bokk lépp. ");
INSERT INTO wol2010_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Ñu jaay seeni suuf ak seen alal, séddoo ko, ku nekk ak la ngay soxla. ");
INSERT INTO wol2010_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Te bés bu nekk ñu saxoo teew ak benn xalaat ca kër Yàlla ga, tey damm mburu ca kër ya; ñuy lekk seen ñam ak xol bu laab tey bég, ");
INSERT INTO wol2010_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","di màggal Yàlla te am yiw ci wetu nit ñépp. Noonu bés bu nekk Boroom bi di yokk ca mbooloo ma ñi mucc. ");
INSERT INTO wol2010_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Am bés Piyeer ak Yowaana dem, ba bëgga dugg ca kër Yàlla ga ca waxtuw ñaan, maanaam tisbaar. ");
INSERT INTO wol2010_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Fekk ñu indi fa nit ku judduwaale lafañ, ñu di ko teg bés bu nekk ca bunt, ba ñuy wooye Bunt bu rafet ba, ca kër Yàlla ga, ngir muy yelwaan ña fay dugg. ");
INSERT INTO wol2010_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Bi mu gisee Piyeer ak Yowaana nag, ñuy dugg ca kër Yàlla ga, mu dékk leen loxo. ");
INSERT INTO wol2010_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Ci kaw loolu Piyeer ak Yowaana ne ko jàkk, te Piyeer ne ko: «Xool nu.» ");
INSERT INTO wol2010_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Lafañ bi xool leen, yaakaar ne dina jot dara ci ñoom. ");
INSERT INTO wol2010_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Noonu Piyeer ne ko: «Awma xaalis, awma wurus, waaye li ma am, dinaa la ko jox: ci turu Yeesu Kirist mu Nasaret doxal!» ");
INSERT INTO wol2010_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Mu jàpp ci loxol ndijooram, yékkati ko. Ci saa si ay tànkam ak ay kostanam dëgër. ");
INSERT INTO wol2010_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Mu tëb, daldi taxaw, di dox. Mu dugg ak ñoom ca kër Yàlla ga, muy dox, di tëb tey sant Yàlla. ");
INSERT INTO wol2010_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Noonu ñépp gis ko, muy dox, di sant Yàlla. ");
INSERT INTO wol2010_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Te ñu xàmmi ko, ne moo daan toog, di yelwaan ca Bunt bu rafet ba ca kër Yàlla ga. Ñu daldi waaru lool te yéemu ci li ko dikkal. ");
INSERT INTO wol2010_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Naka waa ji taq ci Piyeer ak Yowaana, ñépp waaru; ñu daldi daw, fekksi leen ca bérab ba ñuy wax Werandaa bu Suleymaan. ");
INSERT INTO wol2010_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Bi Piyeer gisee loolu nag, mu ne mbooloo mi: «Yéen waa Israyil, lu tax ngeen waaru ci lii? Lu tax ngeen di nu xool jàkk, mel ni ci sunu kàttan, mbaa ci sunu ragal Yàlla lanu doxloo kii? ");
INSERT INTO wol2010_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Yàllay Ibraayma ak Isaaxa ak Yanqóoba, di Yàllay sunuy maam, màggal na Ndawam Yeesu; yéena xàcceek moom, ba jébbal ko Pilaat, fekk naroon na koo bàyyi. ");
INSERT INTO wol2010_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Yéen xeeb ngeen Aji Sell ji te Jub, te tinul ab reykat. ");
INSERT INTO wol2010_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Bóom ngeen Aji Dundal ji, waaye Yàlla dekkal na ko; seede nanu ko nun ñépp. ");
INSERT INTO wol2010_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Ci gëm turam la nit, kii ngeen di gis te xam ko, dëgëre; waaw, turu Yeesu ak ngëm gi jóge ci moom, moo tax mu wér péŋŋ ci seen kanam, yéen ñépp. ");
INSERT INTO wol2010_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","«Léegi nag bokk yi, xam naa ne ñàkka xam a tax ngeen def ko, yéen ak seeni kilifa. ");
INSERT INTO wol2010_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Waaye noonu la Yàlla amale li mu yégle woon lu jiitu jaarale ko ci gémmiñug yonent yépp naan, Almaseem dina sonn. ");
INSERT INTO wol2010_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Tuubleen seeni bàkkaar nag te waññiku ci Yàlla, ngir seeni bàkkaar far. ");
INSERT INTO wol2010_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Noonu jamonoy péex dina bawoo ci Boroom bi, te muy yebal Almasi bi mu leen jagleel, maanaam Yeesu. ");
INSERT INTO wol2010_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Asamaan war na koo yor, ba jamono ju ñuy defaraat lépp, di jamono ji Yàlla waxoon jaarale ko ci gémmiñug yonentam yu sell yépp, li dale ci njàlbéenug àddina. ");
INSERT INTO wol2010_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Ndaxte Musaa nee woon na: “Boroom bi seen Yàlla dina leen feeñalal ci seen xeet Yonent ni man; nangeen ko déggal ci lépp lu mu leen wax. ");
INSERT INTO wol2010_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Képp ku déggalul Yonent boobu, dees na la far ci xeet wi.” ");
INSERT INTO wol2010_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","«Li dale sax ci Samiyel ak ñi ci topp, bépp yonent bu wax yégle na bés yii. ");
INSERT INTO wol2010_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Yéen nag yéenay donn yonent yi ak kóllëre, gi Yàlla fasoon ak seeni maam, bi mu naan Ibraayma: “Xeeti àddina yépp dinañu barkeel ci ki soqikoo ci yaw.” ");
INSERT INTO wol2010_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Yàlla feeñal na Ndawam, jëkk koo yebal ci yéen, ngir barkeel leen, ci waññi leen kenn ku nekk ci say bàkkaar.» ");
INSERT INTO wol2010_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Bi ñuy wax ak mbooloo ma, sarxalkat ya ak kilifag ñiy wottu kër Yàlla ga ak Sadusen ya daanu ci seen kaw. ");
INSERT INTO wol2010_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Ñu mer lool ci li ñuy waar nit ñi, di yégle ndekkitel ñi dee, sukkandikoo ko ci ndekkitel Yeesu. ");
INSERT INTO wol2010_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Noonu ñu jàpp leen, tëj leen ba ca ëllëg sa, ndaxte mu nga doon tàmbalee guddi. ");
INSERT INTO wol2010_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Waaye ñu bare ca ña dégg wax ja gëm nañu, te limu góor ñi gëm yokku na, ba mat juróomi junni. ");
INSERT INTO wol2010_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Ca ëllëg sa nag kilifay Yawut yi ak njiit yi ak xutbakat yi dajaloo ci Yerusalem. ");
INSERT INTO wol2010_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Ràññee nañu ci: Anas, miy sarxalkat bu mag bi, Kayif, Yowaana, Alegsàndar ak bokki sarxalkat bu mag bi. ");
INSERT INTO wol2010_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Ñu dëj Piyeer ak Yowaana ca digg ba, laaj leen ne: «Lii ngeen def, ci gan kàttan, mbaa ci turu kan, ngeen ko defe?» ");
INSERT INTO wol2010_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Ci kaw loolu Piyeer daldi fees ak Xel mu Sell mi, ne leen: «Yéen kilifay xeet wi ak njiit yi, ");
INSERT INTO wol2010_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","bu fekkee ne xettali nit ku wopp, ba mu wér, moo tax ngeen dëj nu ci pénc mi tey, ");
INSERT INTO wol2010_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","nangeen xam lii, yéen ñépp ak bànni Israyil gépp: ci turu Yeesu Kirist mu Nasaret, mi ngeen daajoon ca bant te Yàlla dekkal ko, ci tur woowu la nit kii jële ag wér, ba taxaw ci seen kanam. ");
INSERT INTO wol2010_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Yeesu moomu mooy: “Doj wi ngeen xeeboon, yéen tabaxkat yi, te moo doon doju koñ.” ");
INSERT INTO wol2010_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Te mucc amul ci keneen, ndaxte ci ron asamaan amul weneen tur wu ñu maye ci nit ñi, wu nu wara mucce.» ");
INSERT INTO wol2010_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Kon bi ñu gisee fit, wi Piyeer ak Yowaana àndal, te ñu xam ne masuñoo jàng mbaa ñuy gëstu ci diine, ñu daldi waaru, ràññee ne daa nañu ànd ak Yeesu. ");
INSERT INTO wol2010_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Te bi ñu gisee nit, ka ñu fajoon, taxaw ak ñoom, manuñu caa teg dara. ");
INSERT INTO wol2010_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Noonu ñu santaane, ñu génne leen, ñu daldi gise ci seen biir, ");
INSERT INTO wol2010_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","ne: «Lu nuy def ak ñii? Ndaxte def nañu kéemaan gu siiw; loolu leer na ñi dëkk Yerusalem ñépp, te manunu koo weddi. ");
INSERT INTO wol2010_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Waaye ngir mbir mi baña law ci xeet wi, nanu leen aaye, ñu baña waxati ak kenn ci tur woowu.» ");
INSERT INTO wol2010_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Noonu ñu woo leen, ñu tere leen bu wóor, ñu waxati mbaa waare dara ci turu Yeesu. ");
INSERT INTO wol2010_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Waaye Piyeer ak Yowaana ne leen: «Bu fekkee ne déggal leen te bàyyi Yàlla mooy li jub ci kanam Yàlla, seetleen. ");
INSERT INTO wol2010_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Waaye nun manunoo baña wax li nu gis te dégg ko.» ");
INSERT INTO wol2010_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Noonu kilifa yi tëkkuwaat leen, yiwi leen, ñu dem. Ndaxte amuñu benn bunt ci ñoom ngir mbugal leen, fekk ñépp di màggal Yàlla ci li xewoon. ");
INSERT INTO wol2010_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Ndaxte nit, ka ñu fajoon ci kéemaan googu, weesoon na ñeent fukki at. ");
INSERT INTO wol2010_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Bi ñu leen yiwee nag, ñu dem ci seeni bokk, nettali leen li sarxalkat yu mag ya ak njiit ya waxoon lépp. ");
INSERT INTO wol2010_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Bi ko bokk ya déggee nag, ñu mànkoo, diis seen kàddu Yàlla ne: «Boroom bi, yaa sàkk asamaan, suuf, géej ak lépp li nekk ci seen biir. ");
INSERT INTO wol2010_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Yaa wax, jaar ci sunu maam Daawuda sa jaam, mi doon gémmiñu Xel mu Sell mi, ne: “Lu tax xeeti àddina di bax? Lu tax ñuy fexe lu manula am? ");
INSERT INTO wol2010_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Buuri àddina dañoo booloo, te kilifa yi dajaloo, di bañ Boroom bi ak Almaseem.” ");
INSERT INTO wol2010_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","Ndaxte ci dëgg ci dëkk bii, Erodd ak Poñsë Pilaat ànd ak xeeti àddina ak bànni Israyil, likkoo nañu, ngir daaneel sa Ndaw lu sell li nga fal, di Yeesu, ");
INSERT INTO wol2010_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","te def lépp, li sa kàttan ak sa ndigal tëraloon. ");
INSERT INTO wol2010_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Léegi nag Boroom bi, seetal seeni tëkku te may nu, nun say jaam, nuy wax sa kàddu ak fit. ");
INSERT INTO wol2010_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Tàllalal sa loxo, ci wéral ak ci wone ay kéemaan ak ay firnde, jaarale ko ci turu Yeesu, sa Ndaw lu sell li.» ");
INSERT INTO wol2010_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Bi ñu ñaanee ba noppi, bérab ba ñu booloo woon daldi yëngatu; te ñoom ñépp fees ak Xel mu Sell mi, ñuy wax kàddug Yàlla ak fit wu dëgër. ");
INSERT INTO wol2010_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Noonu mbooloom ñu gëm ñi bokk menn xel ak benn xalaat. Kenn daawul aakimoo dara ci alalam, waaye ñoo bokkoon lépp. ");
INSERT INTO wol2010_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Te ndaw yi di seedeel ndekkitel Yeesu Boroom bi ak kàttan gu réy. Te yiw wu yaatu ëmb leen, ñoom ñépp. ");
INSERT INTO wol2010_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Kenn ci ñoom ñàkkul dara, ndaxte képp ku nekk boroom suuf mbaa am ay kër, jaay na ko, indi njég li, ");
INSERT INTO wol2010_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","teg ko ci loxoy ndaw ya; ñu di ci sédd, kenn ku nekk li mu soxla. ");
INSERT INTO wol2010_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Noonu amoon na fa ku tudd Yuusufa, te ndaw yi dàkkentale ko Barnabas, miy tekki «Kiy dëgëral fit yi,» mu soqikoo ci giiru Lewi, te juddoo dunu Sipar. ");
INSERT INTO wol2010_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Moom nag jaay na tool, ba mu moom, indi xaalis ba, teg ko ci loxoy ndaw ya. ");
INSERT INTO wol2010_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Naka noonu nit ku tudd Anañas, ànd ak Safira jabaram, jaay làccu suuf. ");
INSERT INTO wol2010_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Mu dencal boppam benn cér ca njég la, ànd ca ak jabaram; ba noppi mu indi cér ba ca des, teg ko ci loxoy ndaw ya. ");
INSERT INTO wol2010_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Bi mu ko defee Piyeer ne ko: «Anañas, lu tax nga bàyyi Seytaane dugg la, ba fees sa xol, ngay wor Xel mu Sell mi, ci li nga dencal sa bopp benn cér ci njég li? ");
INSERT INTO wol2010_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Bi mu jaragul, ndax moomuloo ko woon? Te bi mu jaree, ndax yilifuloo woon njég li? Lu tax nga fas ci sa xol def nii? Woruloo nit ñi, waaye Yàlla nga wor.» ");
INSERT INTO wol2010_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Bi Anañas déggee baat yooyu, mu daanu dee. Ñi ko dégg ñépp tiit, ba ne nërëm. ");
INSERT INTO wol2010_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Noonu waxambaane ya jóg, ñu sàng ko, yóbbu ko, jébbal Yàlla. ");
INSERT INTO wol2010_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Ñetti waxtu gannaaw ga, jabaram duggsi, fekk xamul la fa xew. ");
INSERT INTO wol2010_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Piyeer daldi ko ne: «Wax ma, ndax lii mooy njégu tool bi?» Mu ne ko: «Waawaaw, lii la.» ");
INSERT INTO wol2010_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Ci kaw loolu Piyeer ne ko: «Lu tax ngeen ànd, di diiŋat Xelu Boroom bi? Ñi denci woon sa jëkkër ñu ngi nii ci bunt bi, te dinañu la yóbbu.» ");
INSERT INTO wol2010_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Ca saa sa mu daanu ciy tànkam, dee. Bi waxambaane ya agsee nag, ñu fekk ko, mu faatu; ñu yóbbu ko, def ko ci wetu jëkkëram. ");
INSERT INTO wol2010_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Noonu tiitaange ju mag tàbbi ci mbooloom ñi gëm ñépp ak ñi ko dégg ñépp. ");
INSERT INTO wol2010_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Bi loolu amee ay kéemaan ak ay firnde yu bare di xew ci nit ñi, jaare ca loxoy ndaw ya. Ñépp di booloo ca Werandaa bu Suleymaan ca kër Yàlla ga. ");
INSERT INTO wol2010_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Te kenn ci ña ca des ñemewula booloo ak ñoom, waaye nit ñépp di leen màggal. ");
INSERT INTO wol2010_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Moona ay nit ñu gëna bare, góor ak jigéen, di gëm Boroom bi, tey taq ci ñoom. ");
INSERT INTO wol2010_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Nit ñi indi sax ñu wopp ca mbedd ya, teg leen ca ay lal yu ndaw ak ay leeso, ngir bu Piyeer di jaar, doonte takkandeeram sax yiir ñenn ci ñoom. ");
INSERT INTO wol2010_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Te it nit ñu bare dajaloo, jóge ca dëkk ya wër Yerusalem, ñu indi ay jarag ak ñu rab yu bon sadd; te ñoom ñépp daldi wér. ");
INSERT INTO wol2010_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Booba sarxalkat bu mag ba jóg ak gàngooram gépp, maanaam kureelu Sadusen ga fa dëkk. Kiñaan gu mag jàpp leen, ");
INSERT INTO wol2010_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","ba ñu jàpp ndaw ya, tëj leen ca kaso ba. ");
INSERT INTO wol2010_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Waaye ci guddi malaakam Boroom bi ubbi buntu kaso ba, génne leen ci biti naan: ");
INSERT INTO wol2010_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","«Demleen taxaw ca kër Yàlla ga, te xamal nit ñi lépp lu jëm ci dund gu wóor gii.» ");
INSERT INTO wol2010_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Bi ñu déggee loolu, ñu dugg ca kër Yàlla ga ci suba teel, daldi waare. Bi ñu koy def, sarxalkat bu mag ba ak gàngooram ñëw, woolu kureelu àttekat ya, maanaam mbooloom njiiti bànni Israyil gépp; ñu yónnee, ngir jëli ndaw ya ca kaso ba. ");
INSERT INTO wol2010_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Waaye bi wottukati kër Yàlla ga agsee ca kaso ba, gisuñu leen fa; ñu daldi délsi, yégle ko ");
INSERT INTO wol2010_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","ne: «Fekk nanu kaso ba tëju bu wóor ak wottukat ya taxaw ca bunt ya, waaye bi nu ko tijjee, fekkunu kenn ci biir.» ");
INSERT INTO wol2010_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Bi kilifag wottukati kër Yàlla ga ak sarxalkat yu mag ya déggee loolu, ñu daldi ciy jaaxle lool, ñuy laajante, fu lii di mujj. ");
INSERT INTO wol2010_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Noonu benn waay ñëw, yégal leen ne: «Nit ñi ngeen tëjoon ñu ngi taxaw ca kër Yàlla ga, di jàngal nit ñi.» ");
INSERT INTO wol2010_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Ci kaw loolu kilifa ga ak wottukat ya dem jëli leen; waaye boolewuñu ci fitna, ngir ragal nit ñi sànni leen ay xeer. ");
INSERT INTO wol2010_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Bi ñu leen indee, ñu dëj leen ci kanam mbooloo ma. Sarxalkat bu mag ba laaj leen ");
INSERT INTO wol2010_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","ne: «Ndax terewunu leen ci lu wér, ngeen waare ci tur woowu, te fi mu ne dajal ngeen Yerusalem ak seeni waare, rax-ca-dolli yéena ngi nuy fexee taqal deretu nit kooku.» ");
INSERT INTO wol2010_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Waaye Piyeer ak ndaw ya ne leen: «Déggal Yàlla moo gën déggal nit. ");
INSERT INTO wol2010_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Yàllay sunuy maam dekkal na Yeesu, mi ngeen bóomoon ci wékk ko ca bant ba. ");
INSERT INTO wol2010_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Te Yàlla yékkati na ko ci ndijooram, mu nekk Buur ak Musalkat, ngir may bànni Israyil réccu, ba mu baal leen seeni bàkkaar. ");
INSERT INTO wol2010_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Seede nanu loolu, nun ak Xel mu Sell, mi Yàlla may ñi koy déggal.» ");
INSERT INTO wol2010_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Bi ñu déggee loolu, ñu mer ba seen xol di dagg, ñu bëgg leena rey. ");
INSERT INTO wol2010_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Waaye amoon na fa nit ku tudd Gamaleel, bokk ci tariixab Farisen ya, di xutbakat bu tedd ci yoonu Musaa, mu jóg ca mbooloo ma, santaane ñu génne leen tuuti. ");
INSERT INTO wol2010_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Bi ñu ko defee mu ne leen: «Yéen bokki Israyil, moytuleen li ngeen di def nit ñooñu. ");
INSERT INTO wol2010_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Ndaxte bu yàggul Tëdas jógoon na, mbubboo daraja, ba lu mat ñeenti téeméeri nit takktoo ak moom. Tëdas moomu nag reyees na ko, te ñi ko toppoon ñépp tasaaroo, ba seen pexe nasax. ");
INSERT INTO wol2010_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Gannaawam it Yudaa mu Galile jóg, ca jamono ja ñu doon bind waa réew ma, mu jógloo nit ñu bare, ñu ànd ak moom. Moom itam dee na, te ay nitam ñépp tasaaroo. ");
INSERT INTO wol2010_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Léegi maa ngi leen di wax, génnleen ci mbirum ñooñu te bàyyi leen ñu dem. Ndaxte bu seen pas-pas mbaa seen jëf dee pexem nit, dina yàqu. ");
INSERT INTO wol2010_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Waaye bu fekkee ne ndogalu Yàlla la, dungeen ko mana fanq, ngir ragala jànkoonte ak Yàlla.» ");
INSERT INTO wol2010_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Bi mu waxee loolu, ñu fekk ko ci xalaatam; ñu woo ndaw ya, daldi leen dóor ay yar, tere leen, ñu waxati dara ci turu Yeesu, ba noppi bàyyi leen, ñu dem. ");
INSERT INTO wol2010_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Ndaw ya nag jóge ca kanam kureelu àttekat ya, bég ci li leen Yàlla jàppe, ñu yeyoo yenu toroxte ngir Tur wa. ");
INSERT INTO wol2010_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Noonu bés bu nekk ca kër Yàlla ga ak ca kër ya, daawuñu noppee jàngle ak a xamle xibaaru jàmm bi, ne Yeesu mooy Almasi bi. ");
INSERT INTO wol2010_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Ca bés yooyu, naka taalibe yi di gëna bare, Yawut yiy làkk gereg tàmbalee ñaxtu ci mbirum Yawut tigi yi, te lii a ko waral: jigéen ñi seen jëkkër dee, te ñu bokk ci ñoom, naraalewuñu leen ca ndimbal, la ñuy séddale bés bu nekk. ");
INSERT INTO wol2010_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Noonu fukki ndaw ya ak ñaar woo mbooloom taalibe ya ne leen: «Nu bàyyi kàddug Yàlla, di topptoo mbirum séddale, loolu jekkul ci nun. ");
INSERT INTO wol2010_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Kon nag bokk yi, tànnleen juróom ñaari nit ci seen biir, ñu am seede su rafet te fees ak Xel mu Sell mi ak sago, nu dénk leen liggéey bii. ");
INSERT INTO wol2010_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Waaye nun dinanu wéy ci ñaan ci Yàlla ak ci yenub xamle kàddu gi.» ");
INSERT INTO wol2010_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Lii ñu wax nag neex na mbooloo mépp. Noonu ñu tànn Ecen, di nit ku fees ak ngëm ak Xel mu Sell mi, boole ci Filib ak Porokor, teg ca Nikanor, Timon, Parmenas ak Nikolas, mi juddoo Ancos te tuub ci yoonu Yawut ya. ");
INSERT INTO wol2010_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Ñu jébbal leen ndaw ya, ñaanal leen, teg leen loxo. ");
INSERT INTO wol2010_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Noonu kàddug Yàlla di law, ba mbooloom taalibe yi di yokku bu bare ci Yerusalem; te sarxalkat yu bare déggal Yàlla ci topp yoonu ngëm wi. ");
INSERT INTO wol2010_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Naka noona Ecen, mi fees ak yiw ak kàttan, di def ay kéemaan yu mag ak ay firnde ca nit ña. ");
INSERT INTO wol2010_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Waaye ay nit jóg, bokk ci jàngu, bi ñuy wax Jàngub ñi ñu goreel, di ay niti dëkki Siren ak Alegsàndiri, ak it waa diiwaani Silisi ak Asi. Ñuy werante ak Ecen, ");
INSERT INTO wol2010_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","waaye àttanuñu sagoom ak Xel mi muy waxe. ");
INSERT INTO wol2010_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Kon ñu daldi jënd ay nit, ñu ne: «Dégg nanu ko, muy sosal Musaa ak Yàlla.» ");
INSERT INTO wol2010_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Noonu ñu jógloo nit ñi ak njiit yi ak xutbakat yi, ñu dal ci kawam, jàpp ko, yóbbu ko ca kureelu àttekat ya. ");
INSERT INTO wol2010_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Te ñu sàkk ay naaféq yuy seede ne: «Kii du bàyyee wax lu juuyoo ak bérab bu sell ba ak yoonu Musaa. ");
INSERT INTO wol2010_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Ndaxte dégg nanu, muy wax ne, Yeesum Nasaret moomu dina daaneel bérab bii te soppi aada, yi nu Musaa batale woon.» ");
INSERT INTO wol2010_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Bi ñu ko waxee, ña toogoon ñépp ca mbooloo ma xool ko jàkk, gis xar kanamam, mu mel ni xar kanam malaaka. ");
INSERT INTO wol2010_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Noonu sarxalkat bu mag ba ne ko: «Ndax loolu dëgg la?» ");
INSERT INTO wol2010_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Ecen ne ko: «Yéen samay bokk ak samay baay, dégluleen! Yàlla, miy Boroom ndam, feeñu woon na sunu maam Ibraayma, bi mu nekkee réewu Mesopotami, te dëkkagul woon Karan. ");
INSERT INTO wol2010_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","Mu ne ko: “Toxul sa réew, bàyyi say bokk, te ñëw ci réew, mi ma lay won.” ");
INSERT INTO wol2010_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","«Ci kaw loolu mu génn réewu niti Kalde, dëkksi Karan. Te bi baayam faatoo, Yàlla toxale ko foofa, dëël ko ci réew, mi ngeen dëkk léegi. ");
INSERT INTO wol2010_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Waaye mayu ko fa genn moomeel gu mu wara donale, du sax fu mu mana teg tànkam; waaye dig na ko ne dina ko may réew mi, mu yilif ko moom ak askanam, fekk booba amagul doom. ");
INSERT INTO wol2010_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Yàlla ne ko: “Ñi soqikoo ci yaw dinañu ganeyaan ci réew mu ñu dëkkul; dees na leen def ay jaam, di leen fitnaal diirub ñeenti téeméeri at.” ");
INSERT INTO wol2010_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Waaye Yàlla nee na: “Xeet wi leen jaamloo, man maa leen di àtte te gannaaw loolu dinañu génn, di ma jaamu ci bérab bii.” ");
INSERT INTO wol2010_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Yàlla nag tëral kóllëre seen diggante, fas ko ci màndargam xaraf. Noonu Ibraayma jur Isaaxa, xarafal ko ca juróom ñetteelu fan ba; Isaaxa def noonu Yanqóoba, Yanqóoba it def noonu fukki maam ya ak ñaar, ñi sos xeet wi. ");
INSERT INTO wol2010_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","«Naka maam yooyu, dañoo iñaane Yuusufa, ba jaay ko, mu jëm réewu Misra. Waaye Yàlla taxawu ko, ");
INSERT INTO wol2010_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","génne ko ci coonoom yépp, defal ko yiw ak xel ci kanam Firawna, buuru Misra, mu def ko kilifag Misra ak këram gépp. ");
INSERT INTO wol2010_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","«Bi loolu amee xiif tàbbi ci biir Misra ak réewu Kanaan mépp, ba toskare ja metti lool, te sunuy maam amatuñu lu ñu lekk. ");
INSERT INTO wol2010_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Yanqóoba nag dégg ne Misra am na dugub, mu yebal ca sunuy maam, ñu dem fa yoon wu jëkk. ");
INSERT INTO wol2010_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Bi fa ay doomi baayam delloo nag, Yuusufa xàmmiku leen, te Firawna xamante ak njabootam. ");
INSERT INTO wol2010_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Ci kaw loolu Yuusufa yeble, woo baayam ak bokkam yépp, ñuy juróom ñaar fukki nit ak juróom. ");
INSERT INTO wol2010_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Noonu Yanqóoba dem Misra, faatu fa, moom ak sunuy maam. ");
INSERT INTO wol2010_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Gannaaw loolu ñu yóbbu seeni néew Sisem, dugal leen ca bàmmeel, ba Ibraayma jëndoon ak xaalis ca doomi Amor ca Sisem. ");
INSERT INTO wol2010_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","«Bi loolu wéyee jamono ji jege woon na, ngir Yàlla amal li mu digoon Ibraayma ci ngiñ; fekk xeet wa di law tey gëna bare ci Misra, ");
INSERT INTO wol2010_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","ba keroog beneen buur bu xamul Yuusufa di falu ci Misra. ");
INSERT INTO wol2010_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Buur boobu nag dafa daan nax sunu xeet, di fitnaal sunuy maam, ba di leen sànniloo seeni doom, ngir ñu dee. ");
INSERT INTO wol2010_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","«Booba nag la Musaa juddu, di ku rafet ci kanam Yàlla; ñu yor ko ñetti weer ci biir kër baayam, ");
INSERT INTO wol2010_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","ba noppi sànni ko. Noonu doom ju jigéen ju Firawna for ko, yar ko ni doomam. ");
INSERT INTO wol2010_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Musaa nag di ku yewwu ci xam-xamu waa Misra bépp, di jàmbaar ci wax ak jëf. ");
INSERT INTO wol2010_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","«Bi mu demee ba am ñeent fukki at, mu fas yéeney seeti ay bokkam, maanaam bànni Israyil. ");
INSERT INTO wol2010_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Noonu mu gis ca ku ñuy néewal doole, mu sotle ko, feyul ko, ba dóor waayi Misra ja. ");
INSERT INTO wol2010_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Mu defe ne, ay bokkam dinañu xam ne ciy loxoom la leen Yàllay musale, waaye xamuñu ko. ");
INSERT INTO wol2010_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Ca ëllëg sa mu juux ci ay Yawut yuy xeex, mu di leen jéema jubale ne leen: “Yéen ay bokk ngeen, lu tax ngeen di xeex?” ");
INSERT INTO wol2010_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Waaye kiy néewal doole moroomam bëmëx ko ne: “Ku la teg kilifa ak àttekat ci sunu kaw? ");
INSERT INTO wol2010_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Ndax danga maa bëgga rey, ni nga defoon démb waayi Misra ja?” ");
INSERT INTO wol2010_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Bi Musaa déggee wax jooju, mu daldi daw, dem réewu Majan, di fa ab doxandéem; mu séy fa, ba am ñaari doom. ");
INSERT INTO wol2010_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","«Lu ko wees ñeent fukki at nag, bi mu nekkee ca màndiŋu tundu Sinayi, malaaka feeñu ko ci takk-takku sawara ci biir as ngarab. ");
INSERT INTO wol2010_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Bi ko Musaa gisee, mu daldi waaru ci li mu gis; mu jegesi ngir niir ko, dégg baatu Boroom bi ne ko: ");
INSERT INTO wol2010_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","“Man maay sa Yàllay maam, di Yàllay Ibraayma, Isaaxa ak Yanqóoba.” Ci kaw loolu Musaa tiit bay lox, te ñemeetula xool. ");
INSERT INTO wol2010_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Noonu Boroom bi ne ko: “Summil say dàll, ndaxte bérab bi nga taxaw, bérab bu sell la. ");
INSERT INTO wol2010_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Gis naa bu baax fitnay sama xeet ci Misra te dégg naa seeni tawat, kon wàcc naa ngir musal leen. Léegi nag ñëwal, dinaa la yebal Misra.” ");
INSERT INTO wol2010_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","«Musaa moomu bañoon nañu ko, ba ne ko: “Ku la teg kilifa ak àttekat?” Waaye moom la Yàlla yebal, jaarale ko ci malaaka mi ko feeñu ca ngarab sa, ngir mu nekk kilifa gu leen di goreel. ");
INSERT INTO wol2010_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Moo leen génne réewu Misra, di def ay kéemaan ak ay firnde ca réew ma, ca géeju Barax ya ak ca màndiŋ ma diirub ñeent fukki at. ");
INSERT INTO wol2010_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Musaa moomu moo ne woon bànni Israyil: “Yàlla dina leen feeñalal ci seeni bokk Yonent bu mel ni man.” ");
INSERT INTO wol2010_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Te moo nekkoon ak mbooloo ma ca màndiŋ ma, ànd ak sunuy maam, wéttalikoo malaaka, mi waxoon ak moom ci tundu Sinayi. Te mu jote ci Yàlla kàddu yiy dund, ngir jottali nu ko. ");
INSERT INTO wol2010_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","Waaye sunuy maam nanguwuñu koo déggal; dañu koo bañ te seeni xel dëpp, dellu Misra. ");
INSERT INTO wol2010_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Ñu sant Aaróona ne: “Sàkkal nu ay yàlla yuy jiitu ci sunu kanam, ndaxte Musaa male nu génne ci réewu Misra, xamunu lu ko dal.” ");
INSERT INTO wol2010_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Booba nag ñu tëgglu aw sëllu, muy xërëm, ñu di ko tuuru, di bànneexu ci seeni jëfi loxo. ");
INSERT INTO wol2010_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Waaye bi ñu ko defee Yàlla dëddu leen, bërgël leen, ñuy jaamu biddiiwi asamaan. Moom lañu bind ci téereb yonent yi ne: “Yéen bànni Israyil, ndax rendi ngeen jur, jébbal ma, boole ko ak i sarax, diirub ñeent fukki at ca màndiŋ ma? ");
INSERT INTO wol2010_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Yóbbu ngeen sax fu nekk xayma, biy màggalukaayu Molog, ak biddiiwub Refan, bi ñu daan bokkaaleel Yàlla, di ay nataal, yi ngeen defoon ngir màggal leen! Kon nag dinaa leen toxal, yóbbu leen ci gannaaw réewu Babilon.” ");
INSERT INTO wol2010_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","«Sunuy maam amoon nañu ca màndiŋ ma xaymab màggalukaay, bi ëmboon li Yàlla seede. Xayma boobu nag defoon nañu ko, roye ko ci bi Musaa gisoon, ni ko ko Yàlla sante woon. ");
INSERT INTO wol2010_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Te gannaaw ga, bi Yosuwe nekkee kilifag sunuy maam, ñu jot xayma ba ñoom it, yóbbu ko ca réew, ma ñu nangu ca xeet ya Yàlla dàq ci seen kanam. Xayma ba nekk fa, ba ci jamonoy Daawuda. ");
INSERT INTO wol2010_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Moom yiw na fa kanam Yàlla, mu ñaan ko, mu sàkkal ko kër ngir askanu Yanqóoba. ");
INSERT INTO wol2010_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Waaye Suleymaan moo tabaxal Yàlla kër ga. ");
INSERT INTO wol2010_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","«Moona Aji Kawe ji du dëkk ci fu loxol nit defar; moom la ab yonent wax ne: ");
INSERT INTO wol2010_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","“Asamaan mooy sama jal, te suuf mooy sama tegukaayu tànk. Kon gan kër ngeen may tabaxal, mbaa fan mooy sama bérabu noppalukaay? ");
INSERT INTO wol2010_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Ndax du sama loxo moo defar yëf yooyu yépp? —Moom la Boroom bi doon wax.” ");
INSERT INTO wol2010_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","«Yéen ñi dëgër bopp, ànd ak xol buy bañ ak ay nopp yuy fatt, mel ni ñi xamul Yàlla. Dungeen noppeek a diiroo ak Xel mu Sell mi; ni ko seen baay yi daan defe, noonu ngeen di def, yéen itam. ");
INSERT INTO wol2010_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Kan ca yonent ya la seeni maam tegul woon ay fitna? Rey nañu ñi doon yégle ñëwug Aji Jub ji, moom mi ngeen jébbale léegi, ba ñu rey ko. ");
INSERT INTO wol2010_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Jot ngeen yoonu Musaa, wi Yàlla wàcce jaarale ko ci ay malaaka, te sàggane ngeen ko.» ");
INSERT INTO wol2010_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Bi ñu déggee loolu nag, seeni xol di dagg, ñuy yéyu, jëm ci kawam. ");
INSERT INTO wol2010_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Waaye Ecen, mi fees ak Xel mu Sell mi, ne jàkk ci asamaan, gis ndamu Yàlla, te gis Yeesu mi taxaw ci ndijooru Yàlla. ");
INSERT INTO wol2010_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Mu ne: «Seetleen, maa ngi gis asamaan yi ubbiku, te Doomu nit kaa ngii taxaw ci ndijooru Yàlla.» ");
INSERT INTO wol2010_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Bi ñu déggee loolu, ñu daldi xaacu ca kaw, tey dar seeni nopp; ñu ànd, ne milib ci kawam; ");
INSERT INTO wol2010_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","ñu wat-wate ko, génne ko dëkk ba, dóor ko ay doj, ba mu dee. Seede ya tegoon nañu seeni yére ci tànki waxambaane wu tudd Sóol. ");
INSERT INTO wol2010_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Noonu ñu dóor Ecen ay doj, muy ñaan Yàlla ne: «Boroom bi Yeesu, nangul sama ruu!» ");
INSERT INTO wol2010_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Bi mu ko waxee, mu sukk, wax ak baat bu kawe: «Boroom bi, bu leen bindal bàkkaar bii,» ba noppi mu nelaw. ");
INSERT INTO wol2010_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Sóol moom ànd na ci ñi doon rey Ecen. Bés booba nag fitna ju metti dal na ci mbooloom ñi gëm, mi nekk Yerusalem, ba ñépp, ñu moy ndaw ya, tasaaroo ci diiwaani Yude ak Samari. ");
INSERT INTO wol2010_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Ay nit ñu ragal Yàlla fab Ecen, jébbal ko Boroom bi, di ko jooy bu wér. ");
INSERT INTO wol2010_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Waaye naka Sóol, mu ngay tas mbooloom ñi gëm, di tàbbi ca kër ya, tey jàpp góor ak jigéen, di leen tëj kaso. ");
INSERT INTO wol2010_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Ñi tasaaroo nag dem fu nekk, di fa xamle xibaaru jàmm bu kàddug Yàlla. ");
INSERT INTO wol2010_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Naka Filib mu dem ca benn dëkk ca Samari, di leen yégal Kirist. ");
INSERT INTO wol2010_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Bi ko mbooloo mi déggee te gis kéemaan yi muy def, ñu bokk benn xalaat, fekki ko ci li mu wax. ");
INSERT INTO wol2010_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Ndaxte ay rab yu bon bàyyi nañu nit ñu bare, ña ñu jàppoon, di yuuxu ci kaw; te ñu bare ñu làggi ak ñu lafañ daldi wér. ");
INSERT INTO wol2010_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Noonu mbég mu réy tàbbi ca dëkk ba. ");
INSERT INTO wol2010_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Amoon na nag nit ku tudd Simoŋ, di luxuskat bu yàgg ca dëkk ba, te daan yéem waa Samari gépp, ci naan: «Ku màgg laa.» ");
INSERT INTO wol2010_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Kon ñépp, mag ak ndaw, taq ci moom ne: «Kii mooy dooley Yàlla ji tudd “Màgg”.» ");
INSERT INTO wol2010_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Ñu taq ci moom, ndax li mu leen yàgga waar ci ay luxus. ");
INSERT INTO wol2010_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Waaye bi ñu gëmee xibaaru jàmm, bi Filib yégle jëm ci nguurug Yàlla ak turu Yeesu Kirist, góor ak jigéen daldi nangu, ñu sóob leen ci ndox. ");
INSERT INTO wol2010_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Simoŋ sax gëm, ñu sóob ko ci ndox; mu wéy nag ci topp Filib, di waaru ci kéemaan yi ak firnde yu mag yiy am. ");
INSERT INTO wol2010_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Bi nga xamee ne ndaw yi nekk Yerusalem yég nañu ne, waa Samari nangu nañu kàddug Yàlla; ñu yónni fa Piyeer ak Yowaana. ");
INSERT INTO wol2010_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Ñu dem fa nag, ñaanal leen, ngir ñu jot Xel mu Sell mi. ");
INSERT INTO wol2010_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","Ndaxte wàccagul ci kenn ci ñoom, waaye sóoboon nañu leen rekk ci ndox ci turu Boroom bi Yeesu. ");
INSERT INTO wol2010_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Noonu Piyeer ak Yowaana teg leen loxo, ñu jot Xel mu Sell mi. ");
INSERT INTO wol2010_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Bi Simoŋ gisee nag ne Yàlla may na Xel mi jaarale ko ci loxoy ndaw ya, mu indil leen xaalis, ");
INSERT INTO wol2010_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","ne leen: «Mayleen ma sañ-sañ boobu, ba ku ma teg samay loxo, nga jot Xel mu Sell mi.» ");
INSERT INTO wol2010_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Waaye Piyeer ne ko: «Asarul ak sa xaalis, yaw mi yaakaar ne man ngaa jënd mayu Yàlla ak xaalis. ");
INSERT INTO wol2010_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Amuloo benn wàll mbaa cér ci lii, ndaxte sa xol laabul ci kanam Yàlla. ");
INSERT INTO wol2010_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Réccul nag sa coxor te ñaan Boroom bi, mu baal la sa xalaatu xol, su manee am. ");
INSERT INTO wol2010_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Ndaxte gis naa ne sóobu nga ci lu wex xat ci kanam Yàlla, te bàkkaar not na la.» ");
INSERT INTO wol2010_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Simoŋ nag ne leen: «Ñaanal-leen ma ci Boroom bi, ngir mu fegal ma li ngeen wax.» ");
INSERT INTO wol2010_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Noonu bi ñu seedeelee Yàlla te wax ci kàddoom, ñu dellu Yerusalem, di xamle xibaaru jàmm bi ci dëkk yu bare yu waa Samari. ");
INSERT INTO wol2010_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Naka noonu benn malaakam Boroom bi ne Filib: «Jógal te jublu Misra, jaar ci yoon wi jóge Yerusalem, jëm Gasa, di màndiŋ.» ");
INSERT INTO wol2010_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Filib jóg dem. Noonu mu gis fa nitu Ecópi ku yoom, di jaraaf ju mag ci Kandas, buur bu jigéen bu Ecópi, te di ko wottul xaalisam bépp. Fekk mu ñëwoon Yerusalem, ngir màggalsi Yàlla, bay dellu; ");
INSERT INTO wol2010_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","mu toog ci watiiram, di jàng téereb yonent Yàlla Esayi. ");
INSERT INTO wol2010_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Xel mi nag ne Filib: «Dabal watiir wale.» ");
INSERT INTO wol2010_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Noonu Filib dawsi, mu dégg waayi Ecópi ja, di jàng téereb yonent Yàlla Esayi. Mu laaj ko: «Ndax xam nga li ngay jàng?» ");
INSERT INTO wol2010_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Mu ne ko: «Nu ma ko mana xame, su ma ko kenn firilul?» Mu woo Filib nag, mu yéeg, toog ak moom. ");
INSERT INTO wol2010_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Fekk aaya yii la doon jàng ci Mbind mi: «Yóbbu nañu ko ni xar mu ñuy rendiji; ni mburt mu luu ci kanam i watkat, mu ne cell. ");
INSERT INTO wol2010_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Ci toroxteem nangu nañu dëggam; ñi mu tollool jamono, ku ci xalaat lii? Jële nañu bakkanam ci àddina.» ");
INSERT INTO wol2010_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Jaraaf ja nag ne Filib: «Maa ngi lay laaj, ci mbirum kan la yonent bi jëmale wax ji? Ndax mbirum boppam lay wax mbaa mu keneen?» ");
INSERT INTO wol2010_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Noonu Filib tàmbali ci aaya yooyu, xamal ko xibaaru jàmm bi ci mbirum Yeesu. ");
INSERT INTO wol2010_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","37","Bi ñuy jaar ci yoon wi, ñu agsi ci ndox. Jaraaf ja ne ko: «Ndox a ngi nii, ana lu tere, nga sóob ma ci?» ");
INSERT INTO wol2010_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Mu santaane nag, ñu taxawal watiir wa; Filib ak jaraaf ja wàcc ñoom ñaar ci biir ndox ma, mu sóob ko ca. ");
INSERT INTO wol2010_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Ba noppi ñu génn ca ndox ma, te ca saa sa Xelu Boroom bi fëkk Filib, ba jaraaf ja gisatu ko, waaye mu toppaat yoonam, ànd ak mbég. ");
INSERT INTO wol2010_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Filib moom teeri dëkku Asot, muy jaar ci dëkk yépp, di fa xamle xibaaru jàmm bi, ba kera muy ñëw dëkku Sesare. ");
INSERT INTO wol2010_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Naka Sóol, muy tëkkoo rey taalibey Boroom bi, ba di ko noyyee far. Mu dem nag ca sarxalkat bu mag ba, ");
INSERT INTO wol2010_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","laaj ko ay bataaxal yu muy yóbbul jànguy dëkku Damaas. Noonu ñu mu fa fekk, te ñu bokk ci yoon wi, góor mbaa jigéen, mu am dogalu yeew leen, indi leen Yerusalem. ");
INSERT INTO wol2010_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Waaye bi muy jub Damaas, ca saa sa leer gu jóge asamaan melax, ba ëmb ko. ");
INSERT INTO wol2010_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Mu daanu ci suuf, dégg baat bu ko ne: «Sóol, Sóol, lu tax nga di ma fitnaal?» ");
INSERT INTO wol2010_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Mu wuyu ne: «Yaay kan Boroom bi?» Boroom bi ne ko: «Maay Yeesu, mi ngay fitnaal. ");
INSERT INTO wol2010_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Waaye jógal, dugg ca dëkk ba, te dinañu la wax li nga wara def.» ");
INSERT INTO wol2010_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Nit ñi ànd ak moom nag taxaw, waaru ba luu, ci li ñu dégg baat bi te gisuñu kenn. ");
INSERT INTO wol2010_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Noonu Sóol jóg, xippi, waaye gisul dara; kon ñu wommat ko, yóbbu ko Damaas. ");
INSERT INTO wol2010_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Diirub ñetti fan gisul dara, lekkul, naanul. ");
INSERT INTO wol2010_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Amoon na nag ci Damaas taalibe bu tudd Anañas. Bi loolu amee nag Boroom bi feeñu ko ne: «Anañas!» Mu wuyu: «Maa ngi nii Boroom bi.» ");
INSERT INTO wol2010_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Boroom bi ne ko: «Jógal, nga jaar ci mbedd, mi ñuy wax Mbedd mu jub mi, te seet ci kër Yudaa nit ku tudd Sóol te dëkk Tars, ndaxte mu ngay ñaan. ");
INSERT INTO wol2010_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","Te gis na cim peeñu nit ku tudd Anañas, mu dugg, teg ko ay loxo, ba muy gisaat.» ");
INSERT INTO wol2010_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Waaye Anañas ne ko: «Boroom bi, dégg naa ci nit ñu bare ci mbirum kooku, ñu seede lu bare lu bon lu mu def say gaay ci Yerusalem. ");
INSERT INTO wol2010_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Te indaale na fii sax sañ-sañ bu jóge ci sarxalkat yu mag ya, ngir yeew képp kuy tudd saw tur.» ");
INSERT INTO wol2010_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Waaye Boroom bi ne ko: «Demal, ndaxte maa ko tànn, muy sama jëfandukaay, ngir yóbbu sama tur fa kanam ñi nekkul Yawut ak fa kanam buur yi ak bànni Israyil. ");
INSERT INTO wol2010_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Te dinaa ko won coono yu bare yu mu wara dékku ngir sama tur.» ");
INSERT INTO wol2010_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Ci kaw loolu Anañas dem, dugg ca kër ga, teg ay loxoom Sóol. Mu ne ko: «Sóol sama mbokk, Boroom bi Yeesu, mi la feeñu woon ci kaw yoon wi, bi ngay dikk, moo ma yónni, ngir nga dellu di gis te fees ak Xel mu Sell mi.» ");
INSERT INTO wol2010_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Ca saa sa lu mel ni ay waasintóor génne ci ay bëtam, mu daldi gisaat. Noonu mu jóg, ñu sóob ko ci ndox; ");
INSERT INTO wol2010_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","ba noppi mu lekk, amaat doole. Bi mu ko defee mu toog ay fan ak taalibe, ya nekk Damaas. ");
INSERT INTO wol2010_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Ca saa sa muy yégle ca jàngu ya ne, Yeesu mooy Doomu Yàlla. ");
INSERT INTO wol2010_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Ñi ko dégg ñépp waaru naan: «Ndax du kii moo daan tas ñiy tudd tur woowu ci Yerusalem, te mu ñëw fii, ngir yeew leen, yóbbu ci kanam sarxalkat yu mag ya?» ");
INSERT INTO wol2010_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Moona Sóol di gëna am kàttan, bay jaaxal Yawut yi dëkk Damaas, ci di leen wax ay firnde, ne Yeesu mooy Almasi bi. ");
INSERT INTO wol2010_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Ba ñu ca tegee ay fani fan, Yawut yi daldi gise, ngir reylu ko. ");
INSERT INTO wol2010_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Waaye Sóol yég seen pexe. Fekk guddi ak bëccëg ñu doon wottu bunt yi yépp, ngir man koo bóom. ");
INSERT INTO wol2010_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Noonu taalibe yi jël ko ci guddi, def ko ci dàmba gu réy, jaarale ko ci miir bi, yoor ko ci suuf. ");
INSERT INTO wol2010_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Bi Sóol agsee Yerusalem, mu jéema ànd ak taalibe yi, waaye ñépp ragal ko, ndax gëmuñu woon ag taalibeem. ");
INSERT INTO wol2010_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Ci kaw loolu Barnabas jël ko, yóbbu ko ca ndaw ya, nettali leen, ni Sóol gise Boroom bi ci kaw yoon wi, ak li mu ko wax, rax-ca-dolli fit wi mu doon waxe ci turu Yeesu ci Damaas. ");
INSERT INTO wol2010_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Noonu mu nekk ak ñoom ci Yerusalem, di dugg ak a génn, di wax ak fit ci turu Boroom bi. ");
INSERT INTO wol2010_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Muy wax ak di werante ak Yawut yiy làkk gereg, waaye ñu di ko wuta rey. ");
INSERT INTO wol2010_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Bi ko bokk yi yégee nag, ñu yóbbu ko dëkku Sesare, yebal ko dëkku Tars. ");
INSERT INTO wol2010_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Noonu mbooloom ñi gëm nekk ci jàmm ci biir diiwaani Yude gépp ak Galile ak Samari; ñuy gëna dëgër, di wéy ci ragal Yàlla, tey yokku ci ndimbalu Xel mu Sell mi. ");
INSERT INTO wol2010_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Piyeer nag di wër, di jaar fu nekk, tey dem ci gaayi Yàlla yi dëkk Lidd, ");
INSERT INTO wol2010_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","mu gis fa nit ku làggi, tudd Ene, tëdd ci basaŋ diirub juróom ñetti at. ");
INSERT INTO wol2010_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Piyeer ne ko: «Ene, Yeesu Kirist faj na la; jógal te defar sa lal.» Noonu mu daldi jóg ca saa sa. ");
INSERT INTO wol2010_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Bi ko waa diiwaani Lidd ak Saron gépp gisee, ñu daldi waññiku ci Boroom bi. ");
INSERT INTO wol2010_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Amoon na nag ci dëkku Yope taalibe bu jigéen bu tudd Tabita, liy tekki «Dorkas», maanaam «kéwél», te muy wéy ci jëf yu baax ak sarxe. ");
INSERT INTO wol2010_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Ca fan yooyu mu daanu wopp, ba faatu; noonu ñu sang ko, teg ko ca néeg, ba sut ca taax ma. ");
INSERT INTO wol2010_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Gannaaw Lidd sorewul ak Yope nag, te taalibe yi dégg ne Piyeer a nga fa, ñu yónnee ko ñaari nit, ñaan ko mu ñëw ci ñoom ci saa si. ");
INSERT INTO wol2010_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Bi ko Piyeer déggee, mu jóg, ànd ak ñoom. Bi mu ñëwee, ñu yóbbu ko ca néeg bu kawe ba. Fekk fa ay jigéen ñi seeni jëkkër faatu, ñu daldi wër Piyeer, ñépp di jooy, di ko won kamisol ya ak mbubb, ya Dorkas daan defar cig dundam. ");
INSERT INTO wol2010_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Ci kaw loolu Piyeer génne ñépp ci biti, mu sukk, ñaan ci Yàlla, ba noppi walbatiku ca néew ba ne ko: «Tabita, jógal!» Noonu mu xippi, gis Piyeer, daldi toog. ");
INSERT INTO wol2010_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Piyeer may ko loxo, yékkati ko. Mu woo gaayi Yàlla ya ak jigéen ña, won leen ko, muy dund. ");
INSERT INTO wol2010_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Mbir ma siiw ca Yope gépp, ba ñu bare gëm Boroom bi. ");
INSERT INTO wol2010_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Gannaaw loolu Piyeer toog ay fan ci Yope, ci këru ku tudd Simoŋ, miy wullikat. ");
INSERT INTO wol2010_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Amoon na ci Sesare nit ku tudd Korney, nekk njiitu xare, mu bokk ci mbooloom xare, mi ñuy wax mu Itali. ");
INSERT INTO wol2010_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Moom nag ku farlu woon ci Yàlla la, te ragal ko, moom ak waa këram gépp; muy sarax ñu bare ci bànni Israyil, tey saxoo ci ñaan ci Yàlla. ");
INSERT INTO wol2010_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Am bés ci tisbaar nag mu am peeñu, gis bu leer malaakam Yàlla feeñu ko ne ko: «Korney!» ");
INSERT INTO wol2010_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Noonu Korney ne ko jàkk, daldi tiit ne ko: «Kilifa gi, lu mu doon?» Malaaka ma ne ko: «Say ñaan ak say sarax yéeg na fa kanam Yàlla, te nangul na la. ");
INSERT INTO wol2010_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Yónnil léegi nag ay nit ci dëkku Yope, ñu woo ku tudd Simoŋ, mi ñu dàkkentale Piyeer. ");
INSERT INTO wol2010_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Mu nga dal fa Simoŋ wullikat, bi këram nekk ci wetu géej.» ");
INSERT INTO wol2010_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Bi malaaka mi doon wax ak moom demee, Korney woo ñaar ci ay surgaam ak benn xarekat bu farlu ci Yàlla ci ñi koy topptoo; ");
INSERT INTO wol2010_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","mu nettali leen lépp, yebal leen Yope. ");
INSERT INTO wol2010_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Ca ëllëg sa, ba ñuy jaar ca yoon wa, ba jub dëkk ba, Piyeer yéeg ca kaw taax ma ci digg bëccëg ngir ñaan ci Yàlla. ");
INSERT INTO wol2010_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Noonu xiif dab ko fa, mu bëgga lekk. Waaye bi ñu koy toggal, Yàlla feeñu ko. ");
INSERT INTO wol2010_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","Mu xool asamaan ubbiku, gis lu mel ni sér bu mag bu ñu téye ci ñeenti laf ya, yoor ko, mu jëm suuf. ");
INSERT INTO wol2010_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Boroom ñeenti tànk yépp ñu nga ca, ak yiy raam ci suuf, ak picci asamaan. ");
INSERT INTO wol2010_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Te baat ne ko: «Jógal, Piyeer, rey te lekk.» ");
INSERT INTO wol2010_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Waaye Piyeer ne ko: «Mukk, Boroom bi, ndaxte masumaa lekk dara lu daganul mbaa lu araam.» ");
INSERT INTO wol2010_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Waaye baat bi wax ak moom ñaareelu yoon ne ko: «Lu Yàlla sellal, bu ko araamal.» ");
INSERT INTO wol2010_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Ñu def ko nag, ba muy ñetti yoon, ba noppi ñu ne cas sér ba, jëme asamaan. ");
INSERT INTO wol2010_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Bi loolu amee Piyeer jaaxle lool ci lu peeñu miy tekki; fekk booba nit ñi Korney yebal, laajte woon nañu kër Simoŋ, ba agsi ci bunt bi. ");
INSERT INTO wol2010_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Ñu woote nag naan: «Simoŋ, mi ñu dàkkentale Piyeer, ndax fi la dëkk?» ");
INSERT INTO wol2010_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Bi Piyeer di rabal xelam ci peeñu ma, Xel mi ne ko: «Ñetti nit a ngi nii, di la wut. ");
INSERT INTO wol2010_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Jógal, nga wàcc te ànd ak ñoom; bul werante, ndaxte maa leen yebal.» ");
INSERT INTO wol2010_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Piyeer wàcc nag ne nit ñi: «Maa ngi nii, man mi ngeen di wut; lu doon seeni tànk?» ");
INSERT INTO wol2010_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Ñu ne ko: «Korney, njiitu xare ba, nit ku jub la te ragal Yàlla, ba am seede su rafet ci bànni Israyil gépp. Malaaka mu sell nag sant na ko, mu woolu la ci këram te déglu li ngay wax.» ");
INSERT INTO wol2010_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Ci kaw loolu Piyeer dugal leen, dalal leen. Ba bët setee, Piyeer jóg, dem ak ñoom, ànd ak ñenn ci bokk yi dëkk Yope, ");
INSERT INTO wol2010_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","te bés ba ca topp mu dikk Sesare. Fekk Korney woo na këram ay bokkam ak i xaritam yi ko gëna jege, di xaar Piyeer. ");
INSERT INTO wol2010_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Bi Piyeer duggee nag, Korney daje ak moom, daanu ciy tànkam, sargal ko. ");
INSERT INTO wol2010_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Waaye Piyeer yékkati ko ne: «Jógal, man it nit rekk laa.» ");
INSERT INTO wol2010_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Noonu muy waxtaan ak moom, duggsi, fekk fa ndajem nit ñu bare. ");
INSERT INTO wol2010_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Mu ne leen: «Xam ngeen ne aaye nañu Yawut, mu jaxasoo ak ku mu bokkalul xeet, mbaa mu dugg ci këram. Waaye Yàlla won na ma ne warumaa ne kenn setul mbaa araam na. ");
INSERT INTO wol2010_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Looloo tax, bi ngeen ma wooloo, ñëw naa ci lu àndul ak werante. Maa ngi leen di laaj nag, lu ngeen may doye?» ");
INSERT INTO wol2010_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Ci kaw loolu Korney ne: «Ñetti fan a ngii may ñaan ci sama biir kër ci waxtu wii, maanaam tisbaar. Ci saa si ku sol yére yuy melax taxaw ci sama kanam, ");
INSERT INTO wol2010_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","mu ne ma: “Korney, say ñaan nangu na, te say sarax egg nañu fa kanam Yàlla. ");
INSERT INTO wol2010_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Yónneel nag ci Yope, woolu Simoŋ, mi ñu dàkkentale Piyeer; mu nga dal ci kër Simoŋ miy wullikat ca wetu géej ga.” ");
INSERT INTO wol2010_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Yónnee naa nag ci ni mu gëna gaawe, woolu la; te maa ngi lay sant ci li nga ñëw. Léegi nag nun ñépp nu ngi fi ci kanam Yàlla, ngir déglu lépp li la Boroom bi sant.» ");
INSERT INTO wol2010_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Noonu Piyeer jël kàddu ga ne leen: «Ci dëgg gis naa ne Yàlla du gënale, ");
INSERT INTO wol2010_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","waaye ci xeet yépp, ku ko ragal tey def lu jub, moom la nangu. ");
INSERT INTO wol2010_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Yónnee na kàddoom bànni Israyil, di leen xibaar jàmm, jaarale ko ci Yeesu Kirist, miy Boroom lépp. ");
INSERT INTO wol2010_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Xam ngeen li xewoon ci réewum Yawut yépp, li ko tàmbalee ci diiwaanu Galile, topp ci waareb Yaxya, mu naan nit ñi, mu sóob leen ci ndox. ");
INSERT INTO wol2010_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Xam ngeen ne Yàlla fal na Yeesum Nasaret, sol ko Xel mu Sell mi ak kàttan; muy wër, di def lu baax ak di faj ñépp ñi nekkoon ci kilifteefu Seytaane, ndaxte Yàlla ànd na ak moom. ");
INSERT INTO wol2010_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","«Seede nanu li mu def lépp ci biir réewu Yawut ya ak Yerusalem. Moona rey nañu ko ci wékk ko ci bant. ");
INSERT INTO wol2010_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Waaye Yàlla dekkal na ko ci ñetteelu fan ba te biral ko, ");
INSERT INTO wol2010_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","waxuma xeet wépp, waaye seede yi Yàlla tànn lu jiitu, maanaam nun ñi daan lekk di naan ak moom gannaaw ndekkiteem. ");
INSERT INTO wol2010_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Te Yeesu sant na nu, nu yégal xeet wa, di seede ne moom la Yàlla jagleel àtteb ñiy dund ak ñi dee. ");
INSERT INTO wol2010_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Yonent yépp seedeel nañu ko ne, ku ko gëm, Yàlla dina la baal say bàkkaar ci turam.» ");
INSERT INTO wol2010_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Bi Piyeer di wax loolu, Xel mu Sell mi wàcc ci kaw ñépp ñiy déglu kàddu ga. ");
INSERT INTO wol2010_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Yawut yi gëm yépp nag, ñi ànd ak Piyeer, daldi waaru ci li Yàlla tuur Xel mu Sell, mi mu maye, ci ñi dul Yawut itam. ");
INSERT INTO wol2010_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","Ndaxte dégg nañu leen, ñuy wax yeneen làkk ak di màggal Yàlla. ");
INSERT INTO wol2010_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","Booba Piyeer daldi wax ne: «Ñii jot Xel mu Sell mi ni nun, ndax manees na leena baña sóob ci ndox?» ");
INSERT INTO wol2010_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Noonu mu santaane, ñu sóob leen ci ndox ci turu Yeesu Kirist. Gannaaw loolu ñu ñaan ko, mu toog ci ñoom ay fan. ");
INSERT INTO wol2010_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Bi loolu amee ndaw yi ak bokk yi nekk ci diiwaanu Yude, dégg nañu ne, ñi dul Yawut nangu nañu kàddug Yàlla. ");
INSERT INTO wol2010_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Bi Piyeer demee Yerusalem nag, kureelu Yawut gi farataal xaraf, di werante ak moom ne ko: ");
INSERT INTO wol2010_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","«Lu tax nga dem ca këru ñu xaraful, bay lekk sax ak ñoom?» ");
INSERT INTO wol2010_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Noonu Piyeer daldi leen benn-bennal mbir mi, nettali leen ko ");
INSERT INTO wol2010_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","ne: «Nekkoon naa ca dëkku Yope, di fa ñaan ci Yàlla, ba far sama xol seey ci moom; noonu ma am peeñu: lu mel ni sér bu mag wàcc, jóge ci asamaan, ñu yoor ko ca ñeenti laf ya, mu ñëw ba ci man. ");
INSERT INTO wol2010_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Ma xool ko jàkk, seetlu ko bu baax, ma gis ca boroom ñeenti tànk yu nekk ci kaw suuf, di rabi àll yi, yiy raam ak picci asamaan. ");
INSERT INTO wol2010_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Te dégg naa baat bu ma ne: “Jógal Piyeer, rey te lekk.” ");
INSERT INTO wol2010_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","Waaye ma ne: “Mukk Boroom bi, ndax dara lu daganul mbaa lu araam masula dugg ci sama gémmiñ.” ");
INSERT INTO wol2010_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","Waaye ñaareel bi yoon baat bi dellu ne ma: “Lu Yàlla sellal, bu ko araamal.” ");
INSERT INTO wol2010_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Loolu am ba muy ñetti yoon, ba noppi ñu ne cas lépp, jëme asamaan. ");
INSERT INTO wol2010_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","«Ca saa sa ñetti góor, ña ñu yebal ci man, jóge Sesare, agsi ca kër ga ma dal. ");
INSERT INTO wol2010_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Te Xel mi ne ma: “Àndal ak ñoom, te bu ci werante.” Juróom benni bokk, yi fi teew, gunge woon nañu ma, ba nu dugg ca kër góor googu. ");
INSERT INTO wol2010_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Mu nettali nu ne gis na malaaka, feeñu ko ca këram ne ko: “Yónneel ca dëkku Yope, woolu Simoŋ, mi ñu dàkkentale Piyeer. ");
INSERT INTO wol2010_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Dina la xamal ay wax yu lay musal, yaw ak sa waa kër gépp.” ");
INSERT INTO wol2010_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","«Bi ma tàmbalee wax nag, Xel mu Sell mi wàcc ci ñoom, ni mu wàcce woon ci nun bu jëkk. ");
INSERT INTO wol2010_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Bi loolu amee ma fàttaliku li Boroom bi wax ne: “Yaxya ci ndox la daan sóobe, waaye yéen dees na leen sóob ci Xel mu Sell mi.” ");
INSERT INTO wol2010_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Gannaaw nag Yàlla jagleel na leen may, gi mu nu mayoon, bi nu gëmee Yeesu Kirist Boroom bi, man maay kan, bay tebbi àtteb Yàlla?» ");
INSERT INTO wol2010_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Bi ñu déggee loolu, amuñu dara lu ñu ca teg, ñu daldi màggal Yàlla ne: «Yàlla nag may na ñi dul Yawut it ñu tuub seeni bàkkaar, ba am dund gu wóor gi.» ");
INSERT INTO wol2010_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Ñi tasoon nag ndax fitna, ji amoon gannaaw Ecen, ñu dem ba diiwaanu Fenisi, ci dunu Sipar ak ca dëkku Ancos, di wax kàddu gi, waaye yemale ko ci Yawut yi. ");
INSERT INTO wol2010_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Moona amoon na ci ñoom ay niti Sipar ak dëkku Siren, ñu ñëw ci Ancos, ba seen wax law ci Gereg yi it, ñu di leen xamal xibaaru jàmm bu Yeesu Boroom bi. ");
INSERT INTO wol2010_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Te loxob Boroom bi ànd ak ñoom, ba mbooloo mu mag gëm te waññiku ci Boroom bi. ");
INSERT INTO wol2010_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Ba mbir ma siiwee, ba àgg ci noppi mbooloom ñi gëm ci Yerusalem, ñu yebal Barnabas ba Ancos. ");
INSERT INTO wol2010_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Bi mu agsee nag, ba gis yiw, wi leen Yàlla may, mu bég ci te di leen xiir, ñu wàkkirlu ci Boroom bi te dogu ci. ");
INSERT INTO wol2010_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Ndaxte nit ku baax la woon te fees ak Xel mu Sell mi ak ngëm; noonu mbooloo mu bare dolliku ci Boroom bi. ");
INSERT INTO wol2010_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Gannaaw loolu Barnabas dem ca dëkku Tars, di wut Sóol. ");
INSERT INTO wol2010_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Bi mu ko gisee, mu indi ko Ancos. Noonu atum lëmm ñu bokk ak mbooloom ñi gëm, di jàngal nit ñu bare. Te ci Ancos lañu jëkka tudde taalibe ya Gaayi Kirist. ");
INSERT INTO wol2010_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Ca fan yooyu ay yonent jóge Yerusalem, ñëw Ancos. ");
INSERT INTO wol2010_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Kenn ci ñoom tudd Agabus jóg, mu yégle jaarale ko ci Xelu Yàlla mi ne xiif bu metti dina daj àddina sépp. Loolu nag amoon na ca ayug buur bu ñuy wax Këlódd. ");
INSERT INTO wol2010_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Kon taalibe ya fas yéenee sàkk ndimbal, jëme ca bokk ya dëkk diiwaanu Yude, ku nekk ak sa kem kàttan. ");
INSERT INTO wol2010_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Noonu lañu def nag, teg ko ci loxoy Barnabas ak Sóol, yónnee ko njiit ya. ");
INSERT INTO wol2010_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Ca jamono jooja Erodd buur ba jàppoon na ay nit ci mbooloom ñi gëm, ngir fitnaal leen. ");
INSERT INTO wol2010_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Noonu mu daldi jàpp Saag, doomu ndeyu Yowaana, mu reylu ko ci jaasi. ");
INSERT INTO wol2010_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Bi mu gisee nag ne mbir moomu neex na Yawut ya, mu daldi jàpp it Piyeer; fekk loolu daje ak bési màggalu Yawut, ga ñuy wax Mburu ma amul lawiir. ");
INSERT INTO wol2010_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Bi mu ko jàppee, mu tëj ko kaso, teg ko ci loxoy ñeenti mboolooy xarekat, ngir ñu wottu ko, fekk mbooloo mu ci nekk di ñeenti nit; amoon na yéeney yóbbu ko ci kanam Yawut ya gannaaw màggalu bésu Mucc ba. ");
INSERT INTO wol2010_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Noonu ñuy wottu Piyeer ca kaso ba, waaye mbooloom ñi gëm di ko ñaanal Yàlla ak seen xol bépp. ");
INSERT INTO wol2010_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Bi Erodd nekkee ci tànki indilu ko, ca guddi googa yeewoon nañu Piyeer ak ñaari càllala, muy nelaw diggante ñaari xarekat, te ay xarekat di wottu buntu kaso ba. ");
INSERT INTO wol2010_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Ca saa sa malaakam Boroom bi ñëw, te leer ne ràyy ca néeg ba. Malaaka ma dóor Piyeer ci wetam, yee ko ne ko: «Jógal bu gaaw!» Noonu jéng ya rot ciy loxoom. ");
INSERT INTO wol2010_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Malaaka ma ne ko: «Takkal sa geño te sol say dàll.» Mu def ko. Malaaka ma ne ko: «Solal sa mbubb te topp ci man.» ");
INSERT INTO wol2010_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Piyeer génn, topp ca malaaka ma, fekk gëmul sax ne lu am la, waaye mu yaakaar ne peeñu la. ");
INSERT INTO wol2010_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Noonu ñu weesu wottukat bu jëkk ba ak ba ca tegu, ñu agsi ca buntu weñ, ba jëm ca dëkk ba, mu daldi ubbikul boppam ci seen kanam. Ñu génn nag, jaar ci benn mbedd, malaaka ma daldi ko bàyyi. ");
INSERT INTO wol2010_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Bi xelam délsee ci moom Piyeer ne: «Léegi xam naa ci lu wóor ne, Boroom bi yónni na malaakaam, musal ma ci loxoy Erodd ak li ma Yawut ya yéene woon lépp.» ");
INSERT INTO wol2010_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Mu rabal xelam ci loolu, daldi dem kër Maryaama, ndeyu Yowaana, mi ñuy wax it Màrk, fekk ñu bare booloo fa, di ñaan ci Yàlla. ");
INSERT INTO wol2010_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Noonu Piyeer fëgg buntu kër ga, te mbindaan mu tudd Rodd wuyusi ko. ");
INSERT INTO wol2010_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Mu xàmmi baatu Piyeer, bég ci, ba fàtte koo ubbil, waaye mu daw ci biir, xamle ne Piyeer a nga ca bunt ba. ");
INSERT INTO wol2010_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Ñu ne ko: «Xanaa dangaa dof.» Waaye mu dëgër ci li mu wax. Noonu ñu ne ko: «Xanaa malaakaam la.» ");
INSERT INTO wol2010_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Fekk Piyeer di gëna fëgg. Noonu ñu tijji, gis ko, daldi waaru. ");
INSERT INTO wol2010_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Piyeer taf loxoom ci gémmiñam, ngir ñu noppi, daldi leen nettali, ni ko Boroom bi génnee ca kaso ba. Mu ne leen: «Tee ngeen jottali ko Saag ak bokk ya.» Bi mu ko waxee, mu jóge fa, dem feneen. ");
INSERT INTO wol2010_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Bi bët setee nag, yëngu-yëngu bu réy am na ca xarekat ya, ñu ne: «Ana Piyeer?» ");
INSERT INTO wol2010_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Noonu Erodd wutlu ko, waaye gisu ko. Kon mu àtte wottukat ya, joxe ndigalu rey leen. Bi loolu amee Erodd jóge ci diiwaanu Yude, dem dëkku Sesare, toog fa. ");
INSERT INTO wol2010_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Fekk mu nekk ci xëccoo bu tàng ak waa dëkki Tir ak Sidon. Naka noona ñu ànd, bëgg koo gis. Ñu neexal Balastus, bëkk-néegu buur ba, di ñaan jàmm, ndaxte réewu buur ba moo doon dundal seen bos. ");
INSERT INTO wol2010_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Ca bés ba ñu jàpp nag Erodd sol mbubbi buuram, toog ca jal ba ca àttekaay ba, di leen yedd ak a dénk. ");
INSERT INTO wol2010_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Noonu mbooloo mi di yuuxu naan: «Lii baatu Yàlla la, du baatu nit!» ");
INSERT INTO wol2010_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Ca saa sa nag, gannaaw màggalul Yàlla, malaakam Boroom bi fàdd ko te ay sax dugg ko, ba mu dee. ");
INSERT INTO wol2010_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Moona kàddug Boroom bi di gëna màgg tey law. ");
INSERT INTO wol2010_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Naka Barnabas ak Sóol, bi ñu matalee seen liggéey, ñu jóge Yerusalem, ñibbi, ànd ak Yowaana mi tudd Màrk. ");
INSERT INTO wol2010_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Amoon na ci mbooloom ñi gëm, mi nekk dëkku Ancos, ay yonent ak ay jànglekat: maanaam Barnabas, Simeyon ku ñu dàkkentale Ñuul, Lusiyus mi dëkk Siren, Manayen mi yaroondoo ak Erodd boroom diiwaan ba, ak Sóol. ");
INSERT INTO wol2010_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Am bés nag, bi ñuy jaamu Boroom bi ak di woor, Xel mu Sell mi ne: «Beral-leen ma Barnabas ak Sóol ngir liggéey, bi ma leen wooye.» ");
INSERT INTO wol2010_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Bi ñu ko déggee, ñu daldi woor ak a ñaan, teg leen ay loxo, ba noppi bàyyi leen ñu dem. ");
INSERT INTO wol2010_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Noonu Xel mu Sell mi yónni leen. Ñu dem nag ci dëkku Selusi, dugg fa gaal, jëm ci dun bu ñuy wax Sipar. ");
INSERT INTO wol2010_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Bi ñu teeree ca dëkku Salamin nag, ñu yégle fa kàddug Yàlla ca jàngub Yawut ya. Ku tudd Yowaana ànd ak ñoom, di leen jàpple ci liggéey bi. ");
INSERT INTO wol2010_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Noonu ñu jaar ci dun bépp, ba egg dëkku Pafos. Foofa ñu gis luxuskat bu tudd Bar-Yeesu, di Yawut bu mbubboo turu yonent. ");
INSERT INTO wol2010_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Mu bokk ci gàngooru boroom réew ma tudd Sersiyus Poolus, di nit ku neex xel. Moom nag mu woolu Barnabas ak Sóol, ngir bëgga dégg kàddug Yàlla. ");
INSERT INTO wol2010_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Waaye Elimas, boroom xam-xam bu ñuul bi —ndaxte loolu la turam di tekki— di leen dogale, ngir bañ boroom réew ma gëm. ");
INSERT INTO wol2010_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Ci kaw loolu Sóol, mi tudd it Pool, daldi fees ak Xel mu Sell mi; mu xool ko jàkk, ");
INSERT INTO wol2010_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","ne ko: «Yaw mi fees ak fen ak lu bon, di doomu Ibliis, tey noonu lépp lu jub, ndax doo bàyyee dëngal yoon yu jub yu Boroom bi? ");
INSERT INTO wol2010_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Léegi loxob Boroom bi dina dal sa kaw, te dinga gumba, ba dootuloo gis jant bi ab diir.» Ca saa sa nag ay bëtam muuru, mu daldi tàbbi cig lëndëm, muy làmbatu, di wut ku ko wommat. ");
INSERT INTO wol2010_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Ba boroom réew ma gisee li xew nag, mu daldi gëm, di yéemu ci yoonu Boroom bi. ");
INSERT INTO wol2010_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Naka noona Pool ak ñi mu àndal jóge Pafos, jaar ci géej, jëm dëkku Peers ci réewu Pamfili. Yowaana nag tàggoo ak ñoom, dellu Yerusalem. ");
INSERT INTO wol2010_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Waaye ñoom ñu jóge Peers, aw ca yoon wa, ba ñëw dëkku Ancos ci diiwaanu Pisidi. Bésub noflaay ba nag ñu dugg ca jàngu ba, toog. ");
INSERT INTO wol2010_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Bi ñu jàngee yoonu Musaa ak yonent ya, njiiti jàngu ba yónnee ca ñoom ne leen: «Bokk yi, bu ngeen amee lu ngeen di dénk mbooloo mi, waxleen ko.» ");
INSERT INTO wol2010_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Noonu Pool jóg, tàllal loxoom ne leen: «Yéen bokki Israyil ak yéen ñi ragal Yàlla, dégluleen! ");
INSERT INTO wol2010_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Yàllay bànni Israyil tànn na sunuy maam, di yokk xeet wa, bi ñuy ganeyaan ci Misra; ba noppi mu génne leen fa ak kàttanu loxoom. ");
INSERT INTO wol2010_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","Diirub ñeent fukki at mu di leen muñal ca màndiŋ ma. ");
INSERT INTO wol2010_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Gannaaw loolu faagal na juróom ñaari xeet ci réewu Kanaan, ba sunuy maam donn réew ma. ");
INSERT INTO wol2010_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Loolu lépp xew na ci diirub ñeenti téeméeri at ak juróom fukk. «Gannaaw loolu mu jox leen ay njiit, ba ci yonent Yàlla Samiyel. ");
INSERT INTO wol2010_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Booba ñuy ñaan buur, te Yàlla jox leen Sóol, doomu Kis ci giiru Beñamin, muy seen buur diirub ñeent fukki at. Gannaaw ga mu jële ko fa, ");
INSERT INTO wol2010_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","dellu falal leen buur bu tudd Daawuda, mu seedee ko nii: “Gis naa Daawuda, doomu Isayi, ku ma neex ci sama xol, te dina def lépp luy sama coobare.” ");
INSERT INTO wol2010_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","«Noonu ci askanam Yàlla indil na bànni Israyil Musalkat bi Yeesu, ci ni mu ko dige woon. ");
INSERT INTO wol2010_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Laata muy ñëw nag, Yaxya daan na waare, ne bànni Israyil gépp, ñu tuub seeni bàkkaar, te mu sóob leen ci ndox. ");
INSERT INTO wol2010_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Te ba Yaxyay jeexal sasam, mu ne: “Ku ngeen may teg? Duma Ki wara ñëw; waaye am na kuy ñëw sama gannaaw, koo xam ne kii yeyoowumaa tekki ay dàllam.” ");
INSERT INTO wol2010_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","«Bokk yi, yéen askanu Ibraayma ak yéen ñi ragal Yàlla, kàddug mucc gi ci nun la wàcc. ");
INSERT INTO wol2010_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Waa Yerusalem ak seeni kilifa xàmmiwuñu woon Yeesu te xamuñu woon waxu yonent, yi ñuy jàng bésub noflaay bu nekk; teewul ñu amal waxu yonent yi, ci li ñu àtte Yeesu, ba daan ko. ");
INSERT INTO wol2010_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Yoon dabu ko fenn, moona ñaan nañu Pilaat, mu reylu ko. ");
INSERT INTO wol2010_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Noonu ñu def lépp lu yonent yi bindoon ci mbiram, ba noppi ñu wàcce ko ca bant ba, tàbbal ko ci bàmmeel. ");
INSERT INTO wol2010_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Waaye Yàlla dekkal na ko, ");
INSERT INTO wol2010_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","te diirub ay fan yu bare feeñu na ñi àndoon ak moom, jóge diiwaanu Galile, dem Yerusalem; léegi nag ñooy ay seedeem ci wetu xeet wi, ");
INSERT INTO wol2010_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","te nu ngi leen di xamal xibaaru jàmm bi ne leen, li Yàlla digoon sunuy maam, ");
INSERT INTO wol2010_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","def na ko ngir nun seeni sët, ci li mu dekkal Yeesu. Moom lañu bindoon ci ñaareelu saaru Sabóor ne: “Yaa di sama Doom, maa di sa Baay tey.” ");
INSERT INTO wol2010_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","Te it li ko Yàlla dekkal, ba mu bañatee jaar ci dee, te suuf du ko lekk mukk, moom la Yàlla wax ne: “Dinaa la may barke yu sell te wóor, yi ma digoon Daawuda.” ");
INSERT INTO wol2010_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Moo tax mu waxaat feneen ne: “Doo bàyyi sa Waa ju sell, mu yàqu.” ");
INSERT INTO wol2010_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","Ndaxte bi Daawuda defee coobarey Yàlla ci jamonoom, mu faatu, ñu suul ko, mu fekki ay maamam, suuf lekk ko. ");
INSERT INTO wol2010_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Waaye ki Yàlla dekkal, yaramam seeyul. ");
INSERT INTO wol2010_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","«Kon nag bokk yi, nangeen xam ne ci moom Yeesu nu ngi leen di yégal mbaalug bàkkaar yi. Te fépp fu yoonu Musaa tële woona àttee nit ni ku jub, ");
INSERT INTO wol2010_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","fa la Yeesu di àttee ni ku jub képp ku ko gëm. ");
INSERT INTO wol2010_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Wottuleen nag ba li yonent yi bindoon bañ leena dal, ci li ñu ne: ");
INSERT INTO wol2010_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","“Yéen ñiy xeebaate, gisleen lii, ngeen yéemu ba far; ndaxte dinaa def ci seen jamono jëf, joo xam ne su ngeen ko déggee sax, dungeen ko gëm.”» ");
INSERT INTO wol2010_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Bi ñuy génn nag ca jàngu ba, Yawut ya ñaan leen, ñu baamtu wax ja ca bésub noflaay ba ca tegu. ");
INSERT INTO wol2010_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Te bi mbooloo ma tasee, ay Yawut yu bare ak ñi tuuboon ci yoonu Yawut te ragal Yàlla, topp ci Pool ak Barnabas. Ñuy diisoo ak ñoom, di leen xiir, ñu wàkkirlu ci yiwu Yàlla. ");
INSERT INTO wol2010_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Noonu bésub noflaay ba ca tegu, daanaka waa dëkk bépp daje, ngir déglu kàddug Yàlla. ");
INSERT INTO wol2010_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Waaye bi Yawut yi gisee mbooloo ma, ñu daldi fees ak kiñaan, di weddi li Pool di wax te di ko xas. ");
INSERT INTO wol2010_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Bi loolu amee Pool ak Barnabas ne leen ci lu bir: «Yéen lanu wara jëkka yégal kàddug Yàlla, waaye gannaaw gàntu ngeen ko, ba àtte seen bopp ne yeyoowuleen dund gu dul jeex gi, kon nu ngi waññiku ci ñi dul Yawut. ");
INSERT INTO wol2010_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Ndaxte moom la nu Boroom bi sant ci li mu naan: “Samp naa la, nga nekk leeru ñi dul Yawut, ngir nga yóbbu mucc gi, mu daj cati àddina.”» ");
INSERT INTO wol2010_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Ñi dul Yawut nag, bi ñu déggee loolu, daldi bég tey màggal kàddug Boroom bi; te ñépp ñu jagoo dund gu dul jeex daldi gëm. ");
INSERT INTO wol2010_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Noonu kàddug Boroom bi di law ci diiwaan bépp. ");
INSERT INTO wol2010_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Waaye Yawut ya xiir ay jigéen, ñi woomle te farlu ci diine, ñoom ak magi dëkk ba, ñu fitnaal Pool ak Barnabas, ngir génne leen réew ma. ");
INSERT INTO wol2010_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Waaye Pool ak Barnabas daldi yëlëb seen pëndu tànk, ngir dëggal seen weddi, jëm dëkku Ikoñum. ");
INSERT INTO wol2010_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Naka taalibe yi nag, ñu fees ak mbég ak Xel mu Sell mi. ");
INSERT INTO wol2010_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Bi Pool ak Barnabas nekkee Ikoñum nag, ñu dugg ci jàngub Yawut ya, ni ñu ko daan defe; ñuy waare, ba mbooloom Yawut ak Gereg mu bare gëm. ");
INSERT INTO wol2010_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Waaye Yawut yu nanguwul yi ñoo jógloo ñi dul Yawut, di ñaawal seen njort ci bokki taalibe yi. ");
INSERT INTO wol2010_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Pool ak Barnabas nag sax nañu ci Ikoñum lu yàgg, ñu wéeru ci Boroom bi, bay wax ak fit wu dëgër; te Yàlla dëggal kàddug yiwam, ba may leen, ñu def ay kéemaan ak ay firnde. ");
INSERT INTO wol2010_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Noonu waa dëkk bi xàjjalikoo, ñii far ak Yawut yi, ñale far ak ndaw ya. ");
INSERT INTO wol2010_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Waaye ñi dul Yawut ak Yawut yi, ñoom ak seeni kilifa, lal pexem fitnaal leen ci sànni ay doj. ");
INSERT INTO wol2010_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","Bi ko Pool ak Barnabas yégee nag, ñu daw ca diiwaanu Likawni ca dëkk ya ñuy wax Listar ak Derbë ak wàllaa ya. ");
INSERT INTO wol2010_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","Foofa ñu di fa xamle xibaaru jàmm bi. ");
INSERT INTO wol2010_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Amoon na ca Listar nag nit ku fa toog, ku ay tànkam làggi, ndax li mu judduwaale lafañ te masula dox. ");
INSERT INTO wol2010_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","Moom nag muy déglu Pool miy waare. Noonu Pool xool ko jàkk, gis ne am na ngëm ngir wér. ");
INSERT INTO wol2010_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","Mu ne ko ak baat bu dëgër: «Jógal taxaw bu jub.» Noonu nit ki ne bërét, jóg, daldi dox. ");
INSERT INTO wol2010_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Bi mbooloo ma gisee li Pool def, ñu daldi yuuxu, ne ci làkku waa Likawni: «Yàlla yi soppiku nañu nit, wàcc ci nun.» ");
INSERT INTO wol2010_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Noonu ñu tudde Barnabas, Sës, te tudde Pool, Ermes, ndaxte mooy ki yor wax ji. ");
INSERT INTO wol2010_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Fekk ci buntu dëkk ba amoon na fa kër gu ñuy màggale Sës. Sarxalkat ba nag ànd ak mbooloo ma, daldi indi ca bunt ya ay yëkk ak ay caq, yi ñu defare tóor-tóor, ngir màggal leen ci tuur deretu mala. ");
INSERT INTO wol2010_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Waaye bi ko ndaw yi Barnabas ak Sóol déggee, ñu sib ko ba xotti seeni yére, ñu daldi daw, tàbbi ca mbooloo ma, di wax ci kaw ne: ");
INSERT INTO wol2010_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","«Yéen nit ñi, lu leen xiir ci lii? Nun it ay nit lanu, ñu bokk bind ak yéen. Te nu ngi leen di xamal xibaaru jàmm ne leen, ngeen dëddu yëfi neen yii te waññiku ci Yàlla miy dund te sàkk asamaan, suuf, géej ak li ñu ëmb lépp. ");
INSERT INTO wol2010_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Démb mayoon na xeet yépp, ñu aw seen yoonu bopp. ");
INSERT INTO wol2010_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","Moona noppiwula firndeel aw meloom ci def lu baax, di leen wàcceele ci asamaan taw buy indi naataange, ba ngeen lekk ba suur, te seen xol fees ak mbég.» ");
INSERT INTO wol2010_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Noonu ci lu jafe yey nañu mbooloo ma ak wax jooju, ba tere leen, ñu rendil leen sarax. ");
INSERT INTO wol2010_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Waaye bi loolu wéyee amoon na ay Yawut yu jóge Ancos ak Ikoñum, ñu fàbbi mbooloo ma, sànni Pool ay doj, ba yaakaar ne dee na, ñu diri ko ba ca gannaaw dëkk ba. ");
INSERT INTO wol2010_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Waaye taalibe ya ñëw wër ko, mu daldi jóg, duggaat ca dëkk ba. Ca suba sa nag, mu ànd ak Barnabas, dem Derbë. ");
INSERT INTO wol2010_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Bi ñu fa àggee nag, ñu xamle fa xibaaru jàmm bi, ba sàkk fa ay taalibe yu bare. Gannaaw loolu ñu délsi Listar, Ikoñum ak Ancos, ");
INSERT INTO wol2010_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","di dooleel xeli taalibe ya, xiir leen ñu sax ci yoon wi; ñu ne leen: «Ci kaw nattu yu bare lanu wara dugge ci nguuru Yàlla.» ");
INSERT INTO wol2010_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Ci mbooloom ñi gëm mu nekk nag, ñu tànn ci ay njiit; ba noppi ñu ñaan Yàlla ak di woor, dénk leen Boroom bi ñu gëm. ");
INSERT INTO wol2010_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Gannaaw loolu ñu jaar diiwaanu Pisidi, dikk ci Pamfili. ");
INSERT INTO wol2010_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","Ñu yégle kàddu gi ci dëkku Peers, doora dem dëkku Atali. ");
INSERT INTO wol2010_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","Foofa nag ñu dugg gaal, jëm Ancos, fa ñu leen dénke woon ca yiwu Yàlla, ngir liggéey bi ñu àggale. ");
INSERT INTO wol2010_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Bi ñu agsee, ñu woo mbooloom ñi gëm, nettali leen fi ñu jaar ak Yàlla fépp, ak ni mu ubbee buntu ngëm ci ñi dul Yawut. ");
INSERT INTO wol2010_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Noonu ñu toog ak taalibe ya diir bu yàgg. ");
INSERT INTO wol2010_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Amoon na bés ay nit jóge diiwaanu Yude, ñuy jàngal bokk yi ne leen: «Ku xaraful, ni ko aaday Musaa santaanee, doo mana mucc.» ");
INSERT INTO wol2010_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Pool ak Barnabas nag am ak ñoom diisoo ak werante wu metti; noonu bokk yi jàpp ne, Pool ak Barnabas ak ñeneen ci ñoom war nañoo dem Yerusalem ca ndaw ya ak njiit ya, ngir leeral werante wi. ");
INSERT INTO wol2010_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Kon nag mbooloo mi gunge leen, ñu jaar ci wàlli Fenisi ak Samari, di nettali ni ñi dul Yawut waññikoo ci Yàlla, ba bokk yépp am ca mbég mu réy. ");
INSERT INTO wol2010_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Te bi ñu agsee Yerusalem, mbooloom ñi gëm, ndaw yi ak njiit yi teeru leen, ñu nettali leen fi ñu jaar ak Yàlla fépp. ");
INSERT INTO wol2010_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Ci kaw loolu ñeneen, ñi gëm waaye bokk ci tariixab Farisen ya, daldi jóg ne: «Fàww ñi dul Yawut xaraf, te ñu dénk leen sàmm yoonu Musaa.» ");
INSERT INTO wol2010_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Noonu ndaw yi ak njiit yi dajaloo, ngir seet mbir moomu. ");
INSERT INTO wol2010_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Gannaaw werante wu bare Piyeer jóg ne leen: «Yéen bokk yi, xam ngeen ne ca njàlbéen ga Yàlla tànnoon na ma ci yéen, ngir ma yégal ñi dul Yawut xibaaru jàmm bi, ba ñu gëm. ");
INSERT INTO wol2010_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","Yàlla, mi xam xol yi, seede na leen ci li mu leen may Xel mu Sell mi, ni mu nu ko maye nun itam. ");
INSERT INTO wol2010_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","Gënalantewu nu ak ñoom, ci li mu sellal seen xol ci kaw ngëm. ");
INSERT INTO wol2010_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","Léegi nag lu tax ngeen di diiŋat Yàlla, ciy teg taalibe yi yen bu nu masula àttan, nun mbaa sunuy maam? ");
INSERT INTO wol2010_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Nun daal ci yiwu Yeesu Boroom bi lanu yaakaara mucce, te ñoom itam, ci lañu wékku.» ");
INSERT INTO wol2010_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Bi mu ko waxee, mbooloo mépp ne xerem, di déglu Barnabas ak Pool, ñuy nettali kéemaan ak firnde yépp, yi Yàlla def jaarale ko ci ñoom ci biir ñi dul Yawut. ");
INSERT INTO wol2010_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Bi ñu noppee, Saag jël kàddu ga ne: ");
INSERT INTO wol2010_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","«Bokk yi, dégluleen ma! Simoŋ nettali na, ni Yàlla seetsee bu jëkk ñi dul Yawut, ngir sàkku ci ñoom xeet wu ñu tudde turam. ");
INSERT INTO wol2010_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","Te loolu sax dëppoo na ak li yonent yi tëral; ñu bind ne: ");
INSERT INTO wol2010_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","“Boroom bi nee na: Gannaaw loolu dinaa délsi, te yékkati këru Daawuda, gi ne tasar, dinaa defar gent ya, ba taxawalaat ko. ");
INSERT INTO wol2010_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","Noonu li des ci doom Aadama wut Boroom bi, maanaam xeet yi dul Yawut, ñuy tudd sama tur. ");
INSERT INTO wol2010_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","Man dinaa def loolu, man Boroom bi ko wax, te ca njàlbéen ba tey ma di ko xamle.” ");
INSERT INTO wol2010_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","«Kon nag lii mooy sama ndigal: bunu gétën ñi dul Yawut te waññiku ci Yàlla. ");
INSERT INTO wol2010_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","Waaye nu bind leen, ñu moytu ñam wu araam wu ñu tuuroo xërëm, tey moytu njaaloo, ak jur gu médd, bay naan deret ja. ");
INSERT INTO wol2010_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Ndaxte ca njàlbéen ga ba tey am na ca dëkk bu nekk ñuy waare ci yoonu Musaa; bésub noflaay bu nekk sax dañu ciy xutba ca jàngu ya.» ");
INSERT INTO wol2010_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Bi mu ko waxee, ndaw yi ak njiit yi ak mbooloom ñi gëm mépp fas yéenee tànn ci ñoom ay nit, yónni leen Ancos, ñu ànd ak Pool ak Barnabas. Noonu ñu tànn Yudd, mi ñu dippee Barsabas, ak Silas, di ay njiit ca bokk ya. ");
INSERT INTO wol2010_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","Ñu jox leen bataaxal bu ne: Yéen sunu bokk yi dul Yawut te dëkk Ancos, Siri ak Silisi, nu ngi leen di nuyu, nun seeni bokk, di ndaw yi ak njiit yi. ");
INSERT INTO wol2010_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","Dégg nanu ne am na ay nit ñu bawoo ci nun, ñu di leen lëjal ak seeni wax, di jaxase seeni xol, te fekk sukkandikuwuñu ci lenn ndigal lu jóge ci nun. ");
INSERT INTO wol2010_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","Kon nag mànkoo nanu ci tànn ay nit, yónnee leen ko, ànd ak sunuy soppe Barnabas ak Pool. ");
INSERT INTO wol2010_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","Ñoom jaay nañu seen bakkan ngir turu Yeesu Kirist Boroom bi. ");
INSERT INTO wol2010_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","Yónni nanu nag Yudd ak Silas, ñu di leen xamal xibaar boobu ci seen gémmiñ. ");
INSERT INTO wol2010_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","Ndaxte li neex Xel mu Sell mi te neex nu, mooy nu bañ leena teg beneen yen, lu dul dénkaane yii am njariñ, ");
INSERT INTO wol2010_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","maanaam ngeen moytu ñam wu ñu tuuroo xërëm, deretu jur gu médd ak njaaloo. Bu ngeen moytoo yëf yooyu, dingeen def lu baax. Ci jàmm. ");
INSERT INTO wol2010_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Noonu ñu tàggoo, dem Ancos, ñu dajale mbooloo mi, jébbal leen bataaxal bi. ");
INSERT INTO wol2010_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","Ñu jàng ko nag, seen xol sedd ci doole, ji leen bataaxal bi indil. ");
INSERT INTO wol2010_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Te Yudd ak Silas, ñi doon yonent, ñuy dooleel bokk yi, di dëgëral seen fit ak wax yu bare. ");
INSERT INTO wol2010_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","34","Bi loolu amee ñu toog fa ab diir, ba noppi bokk yi yiwi leen ci jàmm, ñu dellu ca ña leen yónni woon. ");
INSERT INTO wol2010_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","Waaye Pool ak Barnabas des ci Ancos, di jàngle ak di xamle xibaaru jàmm bu kàddug Boroom bi, ñoom ak ñeneen ñu bare. ");
INSERT INTO wol2010_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Gannaaw ay fan Pool ne Barnabas: «Nan dellu seeti bokk ya ca dëkk yépp, fu nu masa yéglee kàddug Boroom bi, ba gis nu ñu def.» ");
INSERT INTO wol2010_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","Barnabas nag bëggoon na yóbbaale Yowaana, mi ñuy wax it Màrk. ");
INSERT INTO wol2010_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","Waaye Pool dafa lànk ne: «Matul nu yóbbu ki nu waccoon ca Pamfili, ba àndul woon ak nun ca liggéey ba.» ");
INSERT INTO wol2010_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Noonu ñu xuloo, ba far tàggoo. Barnabas yóbbaale Màrk, ñu dugg gaal, jëm Sipar. ");
INSERT INTO wol2010_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","Pool tànn Silas, dem; bokk ya dénk leen ci yiwu Boroom bi; ");
INSERT INTO wol2010_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","mu jaar ci diiwaanu Siri ak Silisi, di dëgëral mboolooy ñi gëm. ");
INSERT INTO wol2010_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Naka noona mu dikk dëkki Derbë ak Listar, fekk fa taalibe bu tudd Timote te ndeyam di Yawut bu gëm, waaye baayam di Gereg. ");
INSERT INTO wol2010_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","Te mbokk, yi nekk dëkki Listar ak Ikoñum, seedeel nañu ko lu baax. ");
INSERT INTO wol2010_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","Pool bëgg nag mu ànd ak moom, waaye ndegam Yawut yépp, ya dëkk ca wàllaa ya, xam ne baayam Gereg la woon, mu jël ko, xarafal ko. ");
INSERT INTO wol2010_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Bi loolu amee ñuy jaar ca dëkk ya, jottali leen dénkaane, yi ndaw yi ak njiit yi nekk Yerusalem joxe, te sant leen ñu sàmm ko. ");
INSERT INTO wol2010_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Noonu mboolooy ñi gëm di gëna dëgër ci yoon wi, tey yokku bés bu nekk. ");
INSERT INTO wol2010_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","Bi loolu amee gannaaw Xel mu Sell mi aaye na leen, ñu yégleji kàddu gi ci diiwaanu Asi, ñu daldi jaari wàlli Firisi ak Galasi. ");
INSERT INTO wol2010_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","Bi ñu agsee nag ci wetu diiwaanu Misi, ñuy jéema dugg diiwaanu Bitini, waaye Xelum Yeesu mayu leen ko. ");
INSERT INTO wol2010_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","Ñu romb nag Misi, dem dëkku Torowas. ");
INSERT INTO wol2010_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","Noonu ci guddi Yàlla feeñu Pool ci nii: nitu Maseduwan taxaw, di ko ñaan ne ko: «Ñëwal ci Maseduwan, wallusi nu!» ");
INSERT INTO wol2010_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Bi mu amee peeñu moomu, ca saa sa nu fexee jàll ba Maseduwan, xam ne Boroom bi moo nu woo, ngir nu xamle fa xibaaru jàmm bi. ");
INSERT INTO wol2010_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Noonu nu dugg gaal ca Torowas, jubal dunu Samotaras, jóge fa ca ëllëg sa, nu jëm teerub Neyapolis. ");
INSERT INTO wol2010_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","Bi nu fa teeree, nu jëm Filib, bi nekk dëkk bi ëpp maana ca wàll woowu ci diiwaanu Maseduwan, di it moomeelu Room. Nu toog fa ay fan. ");
INSERT INTO wol2010_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","Bi bésub noflaay agsee nag, génn nanu ci buntu dëkk ba, jublu ci wetu dex ga, yaakaar ne bérabu ñaanukaay la. Nu toog fa nag, di wax ak jigéen ña fa dajaloo. ");
INSERT INTO wol2010_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Fekk am na fa jigéen juy déglu, tudd Lidi, di jaaykatu cuub, bu dëkk Catir, te mu ragal Yàlla. Noonu Boroom bi ubbi na xolam, ba mu nangu li Pool di wax. ");
INSERT INTO wol2010_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","Ci kaw loolu ñu sóob ko ci ndox, moom ak waa këram, ba noppi mu ñaan nu ne: «Bu ngeen ma jàppee ni ku takku ci Boroom bi, ganesileen ma ci sama kër.» Te mu di nu ci xiir. ");
INSERT INTO wol2010_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Am bés, ba nuy dem nag ca ñaanukaay ba, nu daje ak jaam bu jigéen bu rabu gisaane solu, te ay sangam di jariñu lu bare ci gisaaneem. ");
INSERT INTO wol2010_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","Mu daldi topp ci Pool ak nun, di xaacu ne: «Nit ñii jaami Yàlla Aji Kawe ji lañu; ñoo leen di yégal yoonu mucc.» ");
INSERT INTO wol2010_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","Muy def noonu ay fani fan, waaye bi ko Pool xajootul, mu waññiku ne rab wa: «Sant naa la ci turu Yeesu Kirist, génnal ci moom.» Noonu rab wa ne mëll, génn ci moom. ");
INSERT INTO wol2010_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Bi ay sangam gisee nag seen buntu wërsëg tëju, ñu daldi jàpp Pool ak Silas, di leen diri, jëme leen ca pénc ma fa kanam njiit ya. ");
INSERT INTO wol2010_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","Noonu ñu dëj leen fa mbaxanay menne naan: «Yawut yii lëjal nañu sunu dëkk, ");
INSERT INTO wol2010_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","di xamle ay aada yu nu sañula nangu mbaa nu di ko topp, nun ñi bokk ci nguuru Room.» ");
INSERT INTO wol2010_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","Mbooloo ma it ànd ci, dal ci seen kaw; àttekat ya nag summilu seeni yére, santaane ñu dóor leen ay yar. ");
INSERT INTO wol2010_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","Noonu ñu dóor leen ay yar yu bare, tëj leen, sant boroom kaso ba, mu wottu leen bu wér. ");
INSERT INTO wol2010_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Gannaaw jot na ndigal loolu nag, mu sànni leen ca néeg ba gëna ruqu ci biir kaso ba, jéng seeni tànk. ");
INSERT INTO wol2010_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","Ba guddi giy xaaj nag, Pool ak Silas di ñaan ak di sant Yàlla, te ñeneen ñi nekk ca kaso ba di leen déglu. ");
INSERT INTO wol2010_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","Ca saa sa suuf yëngu bu metti, ba fondamaab kaso ba daanu; bunt yépp daldi ne kulbét ubbiku, te jéngi ña ñu tëj ne téll tijjiku. ");
INSERT INTO wol2010_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","Ci kaw loolu boroom kaso ba tiite ci ay nelaw, gis bunt yépp ubbiku. Mu daldi bocci jaaseem, bëgga xaru, yaakaar ne ña ñu tëj dañoo daw. ");
INSERT INTO wol2010_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Waaye Pool wax ci kaw ne: «Bul lor sa bopp, nun ñépp nu ngi fi.» ");
INSERT INTO wol2010_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","Bi ko boroom kaso ba déggee, mu daldi laaj làmp, ne saraax dugg, daanu ci kanam Pool ak Silas, di lox. ");
INSERT INTO wol2010_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","Mu génne leen ci biti ne leen: «Kilifa yi, lu ma wara def, ba mucc?» ");
INSERT INTO wol2010_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","Ñu ne ko: «Gëmal Yeesu Boroom bi, kon dinga mucc, yaw ak sa njaboot.» ");
INSERT INTO wol2010_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","Noonu ñu xamal ko kàddug Boroom bi, moom ak waa këram gépp. ");
INSERT INTO wol2010_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","Mu jël leen nag ci waxtu woowu ci guddi, raxas seeni gaañu-gaañu, ba noppi ñu sóob ko ci ndox, moom ak waa këram gépp. ");
INSERT INTO wol2010_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","Bi ñu ko defee mu yóbbu leen ca këram, jox leen ñu lekk, mu bég lool ci li mu gëm Yàlla, moom ak waa këram gépp. ");
INSERT INTO wol2010_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","Bi bët setee, àttekat ya yónni alkaati ya, ñu ne boroom kaso ba: «Yiwil ñaari nit ñooñu, ñu dem.» ");
INSERT INTO wol2010_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","Kon boroom kaso ba yégal loolu Pool ne ko: «Àttekat ya jox nañu ma ndigal, ngir ma yiwi leen, ngeen dem; léegi nag génnleen te dem ci jàmm.» ");
INSERT INTO wol2010_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","Waaye Pool ne alkaati ya: «Dóor nañu nu ay yar ci kanam ñépp, ci lu ñu wéerul ci benn àtte, rax-ca-dolli tëj nañu nu kaso, nun ñiy jaambur ci nguuru Room. Léegi ndax dañu noo bëgga sànni ci mbedd mi ci kumpa? Mukk! Nañu ñëw, ñoom ci seen bopp, gunge nu ci biti.» ");
INSERT INTO wol2010_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","Bi mu ko waxee, alkaati ya yégal àttekat ya la mu wax. Bi ñu déggee ne jaamburi Room lañu, ñu daldi tiit. ");
INSERT INTO wol2010_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","Ñu ñëw nag di leen dëfal, ñu gunge leen ci biti, di leen ñaan, ñu génn dëkk ba. ");
INSERT INTO wol2010_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","Noonu ñu génn ca kaso ba, dugg ci kër Lidi, ñu gis fa bokk ya, dëgëral leen, daldi dem seen yoon. ");
INSERT INTO wol2010_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","Bi ñu fa jógee, ñu aw yoon wa jaar dëkku Amfipolis ak Apoloni, doora ñëw Tesalonig, fa Yawut ya am jàngu. ");
INSERT INTO wol2010_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","Pool nag dugg ca ñoom, na mu ko daan defe, ba am fa ñetti bésub noflaay, muy werante ak ñoom ci li Mbind mi wax. ");
INSERT INTO wol2010_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","Mu di leen ko tekki, te di leen wax ay firnde yuy wone ne fàww Almasi bi sonn te dekki. Mu ne leen: «Yeesu, mi ma leen di yégal, mooy Almasi bi.» ");
INSERT INTO wol2010_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","Noonu ñenn ci Yawut yi gëm, ànd ak Pool ak Silas, ñoom ak mbooloo mu mag ci Gereg yi ragal Yàlla, ak jigéen ñu am maana ñu bare. ");
INSERT INTO wol2010_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","Waaye kiñaan tàbbi ca Yawut ya, ñu daldi jël ay taxawaalukat ca pénc ma, dajale mbooloo, ñuy yëngal dëkk ba. Ñu daanu ci kër Yason, di wut Pool ak Silas, ngir dëj leen ci kanam waa dëkk ba. ");
INSERT INTO wol2010_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","Bi ñu leen gisul nag, ñu diri Yason ak ñeneen ca bokk ya ci kanam àttekat ya. Ñuy wax ci kaw naan: «Nit ñi dëpp àddina sépp agsi nañu fii léegi, ");
INSERT INTO wol2010_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","te Yason a leen dalal. Ñoom ñépp dañoo bañ ndigali buur Sesaar ne, am na beneen buur bu ñuy wax Yeesu.» ");
INSERT INTO wol2010_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","Bi ko mbooloo mi ak àttekat yi déggee, ñu daldi jaaxle lool. ");
INSERT INTO wol2010_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","Noonu nanguwuñoo yiwi Yason ak ñi ci des, lu dul bi ñu leen bataleelee dara. ");
INSERT INTO wol2010_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","Bi loolu amee bokk yi jàllale Pool ak Silas ci saa si ci guddi, ñu jëm Bere. Ba ñu fa eggee nag, ñu dugg ca jàngub Yawut ya. ");
INSERT INTO wol2010_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","Fekk ña fa nekk ñoo gëna am ay teggin waa Tesalonig, ndaxte nangu nañu kàddu ga te sawar ca, di niir Mbind mi bés bu nekk, ba xam ndax loolu dëgg la am déet. ");
INSERT INTO wol2010_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","Kon nag Yawut yu bare gëm, ak ñu bare ci Gereg yi, di jigéen yu am maana, ak ay góor. ");
INSERT INTO wol2010_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","Waaye bi Yawuti Tesalonig déggee ne Pool mu ngi yégle kàddug Yàlla ci Bere it, ñu daldi fay dikk, di jógloo ak a jaxase mbooloo ma. ");
INSERT INTO wol2010_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","Noonu bokk yi yebal Pool ca saa sa, mu jëm géej, waaye Silas ak Timote des fa. ");
INSERT INTO wol2010_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","Ñi ànd ak Pool nag gunge ko ba dëkku Aten. Bi ñu fa àggee, ñu waññiku, yóbbaale ndigalu Pool ne, Silas ak Timote ñëw fekksi ko ci lu gëna gaaw. ");
INSERT INTO wol2010_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","Bi leen Pool di nég ca Aten, mu am naqaru xol wu réy ci li mu gis dëkk ba fees ak ay nataali bokkaale Yàlla. ");
INSERT INTO wol2010_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","Muy werante nag ca jàngu ba ak Yawut ya ak ña ragal Yàlla, tey werante it bés bu nekk ca pénc ma ak ña fay dajaloo. ");
INSERT INTO wol2010_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","Noonu ay boroom xam-xam ci mbooloo mi ñuy wax Epikuren ak ci mbooloo mi ñuy wax Estowisen, di werante ak moom. Ñenn ci ñoom ne: «Fortukatu xam-xam bii, lu mu bëgga wax?» Te ña ca des, bi ñu déggee Pool di waare xibaaru jàmm bi, aju ci Yeesu ak ci mbirum ndekkite, ñu ne: «Dafa mel ni day waare ay yàlla yu nu xamul.» ");
INSERT INTO wol2010_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","Kon nag ñu jël ko, yóbbu ko ca géew, ba ñuy wax Areyopas. Ñu ne ko: «Danoo bëggoon, nga leeral nu ci sa xam-xam bu bees, bii ngay yégle. ");
INSERT INTO wol2010_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","Ndaxte sol nga ci sunuy nopp lu nu xamul. Danoo bëggoona xam nag léegi, loolu lu muy tekki.» ");
INSERT INTO wol2010_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","Ndaxte waa Aten ñépp ak doxandéem ya fa dëkk, wax ak a déglu lu bees rekk lañu daan xënte. ");
INSERT INTO wol2010_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","Noonu Pool taxaw ci biir mbooloom Areyopas ne leen: «Yéen waa Aten gis naa ne farlu ngeen ci diine lool. ");
INSERT INTO wol2010_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","Ndaxte bi may doxantu di seet seeni màggalukaay, gis naa ci benn bu ñu bind lii: “Yàlla mi nu xamul.” Li ngeen di màggal nag te xamuleen ko, loolu laa leen di xamal. ");
INSERT INTO wol2010_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","«Yàlla mi sàkk àddina ak li mu ëmb lépp, moom miy Boroom asamaan ak suuf, du dëkk ci néegi màggalukaay yu loxoy nit defar. ");
INSERT INTO wol2010_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","Du jariñu it ci loxoy nit, mel ni dafa soxla dara, ndax moom mooy jox ñépp bakkan ak ruu ak lépp. ");
INSERT INTO wol2010_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","Ci kenn nit la sàkke xeeti àddina yépp, ñu dëkk ci ñeenti xébla yi; fekk àppal na xeet wu nekk jamonoom, te rëdd seen diggi réew. ");
INSERT INTO wol2010_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","Yàlla def na loolu, ngir ñu koy wut ci yaakaaru daj ko ci làmbatu, fekk sax sorewul kenn ci nun. ");
INSERT INTO wol2010_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","“Ndaxte ci moom lanuy dunde, di ci jëf te nekk ci,” ni ko ñenn ci seeni taalifkat dëggale naan: “Nun noo di aw xeetam.” ");
INSERT INTO wol2010_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","Kon nag, bu nu nekkee xeetu Yàlla, warunoo gëm ne Yàlla mel na ni nataali wurus, xaalis mbaa doj yu nit defar ci xareñ mbaa xel. ");
INSERT INTO wol2010_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","Ca jamono yu wees ya Yàlla toppul ñàkka xam googa, waaye léegi koo mana doon ak foo mana nekk, Yàlla santaane na, nga tuub say bàkkaar. ");
INSERT INTO wol2010_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","Ndaxte sàkk na bés bu muy àtte àddina ci njub, dénk ko Nit ki mu tànn; te firndeel na loolu bu wóor, ci li mu ko dekkal ca néew ya.» ");
INSERT INTO wol2010_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","Bi ñu déggee nag, muy wax ci mbirum ndekkitel ñi dee, ñii di ko foontoo, ña ca des ne ko: «Dinanu la déglu ci mbir moomu beneen yoon.» ");
INSERT INTO wol2010_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","Noonu Pool génn ci seen biir. ");
INSERT INTO wol2010_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","Moona am na ñenn ñu taq ci moom te gëm: xàmmees na ci Denis, ku bokk ci mbooloom Areyopas, ak jigéen ju tudd Damaris, ak ñeneen. ");
INSERT INTO wol2010_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","Bi loolu wéyee Pool bàyyikoo Aten, dem Korent. ");
INSERT INTO wol2010_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","Mu tase fa ak Yawut bu tudd Akilas te juddoo diiwaanu Pont. Muy sooga jóge réewu Itali ak soxnaam Pirsil, ndaxte buur ba Këlódd sant na Yawut yépp, ñu génn Room. ");
INSERT INTO wol2010_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","Noonu Pool seeti leen, te gannaaw ñoo bokk liggéey, maanaam di defar ay xayma, mu dal fa ñoom, ñuy liggéeyandoo. ");
INSERT INTO wol2010_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","Bésub noflaay bu nekk nag muy diisoo ak ñi nekk ca jàngu ba, di jéema gëmloo ay Yawut ak ay Gereg. ");
INSERT INTO wol2010_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","Waaye bi Silas ak Timote jógee diiwaanu Maseduwan, egg fa, Pool jublu ci xamle kàddu gi, tey dëggal ci Yawut yi naan Yeesu mooy Almasi bi. ");
INSERT INTO wol2010_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","Bi ko Yawut ya gàntoo nag, di ko xas, mu yëlëb ay yéreem ne leen: «Yéena sàkku seen musiba; set naa ci. Léegi maa ngi dem ci ñi dul Yawut.» ");
INSERT INTO wol2010_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","Ci kaw loolu mu jóge fa, dugg ci këru ku tudd Tisiyus Yustus, di ku ragal Yàlla, te kër ga dend ak jàngu ba. ");
INSERT INTO wol2010_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","Kirispus nag, njiitu jàngu ba, gëm na Boroom bi ak waa këram gépp. Te waa Korent ñu bare dégg kàddu gi te gëm ko, ñu sóob leen ci ndox. ");
INSERT INTO wol2010_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","Naka noona Boroom bi feeñu Pool ci guddi ne ko: «Bul tiit dara, waaye deel wax te baña noppi. ");
INSERT INTO wol2010_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","Ndaxte maa ngi ànd ak yaw, te kenn du la jàpp, ba fitnaal la, ndaxte am naa xeet wu bare ci dëkk bii.» ");
INSERT INTO wol2010_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","Noonu Pool des at ak genn-wàll ci seen biir, di fa jàngle kàddug Yàlla. ");
INSERT INTO wol2010_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","Ci nguuru Galyon ci diiwaanu Akayi nag, Yawut ya likkoo, ñu dal ci kaw Pool, yóbbu ko ca àttekaay ba. ");
INSERT INTO wol2010_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","Ñu ne: «Kii day xiir nit ñi ci màggal Yàlla ci lu juuyoo ak yoon wi.» ");
INSERT INTO wol2010_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","Bi Pool bëggee wax nag, Galyon ne Yawut ya: «Yéen Yawut yi, bu aju woon ci jàdd yoon walla ñaawteef wu réy, kon liy yoon mooy ma déglu leen. ");
INSERT INTO wol2010_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","Waaye bu ajoo ci ay werante ciy wax ak ay tur ak seen yoon, loolu seen wàll la; man duma ko àtte.» ");
INSERT INTO wol2010_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","Noonu mu dàq leen ca àttekaay ba. ");
INSERT INTO wol2010_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","Ci kaw loolu nit ñépp jàpp Sosten, njiitu jàngu ba, ñu di ko dóor ca kanam àttekaay ba, waaye Galyon faalewu leen. ");
INSERT INTO wol2010_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","Bi loolu wéyee Pool desati fa fan yu bare. Gannaaw ga mu tàggtoo ak bokk ya, dugg gaal jëm Siri, ànd ak Pirsil ak Akilas. Bi mu jógeegul teerub Señsere, mu watlu boppam, ndaxte am na lu mu dige woon ak Yàlla. ");
INSERT INTO wol2010_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","Noonu ñu teer ci Efes. Pool bàyyi fa ñi mu àndaloon, daldi dugg ca jàngu ba, di diisoo ak Yawut ya. ");
INSERT INTO wol2010_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","Ñu ñaan ko, mu des fa lu gëna yàgg, waaye nanguwul. ");
INSERT INTO wol2010_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","Kon mu tàggtoo ak ñoom naan: «Dinaa délsi ci yéen, bu soobee Yàlla.» Noonu mu dugg gaal, jóge Efes, ");
INSERT INTO wol2010_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","teersi dëkku Sesare, mu dem nuyu mbooloom ñi gëm, ba noppi dem Ancos. ");
INSERT INTO wol2010_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","Bi mu fa desee ay jamono, mu jóge fa, di jaar dëkkoo dëkk ci diiwaanu Galasi ak Firisi, di dooleel xoli taalibe yépp. ");
INSERT INTO wol2010_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","Amoon na nag Yawut bu tudd Apolos te juddoo Alegsàndiri, mu dikk Efes. Nit ku yewwu la woon te am xam-xam bu yaatu ci Mbind mi. ");
INSERT INTO wol2010_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","Jàngoon na ci yoonu Boroom bi, di ku farlu ci xelam, muy xamle ak a jàngle bu wóor ci mbirum Yeesu, waaye fekk xam-xamam yem ci ni Yaxya daan sóobe ci ndox. ");
INSERT INTO wol2010_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","Noonu mu daldi wax ak fit wu dëgër ca jàngu ba. Bi ko Pirsil ak Akilas déggee nag, ñu woo ko fi ñoom, gën ko leeral yoonu Yàlla. ");
INSERT INTO wol2010_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","Naka Apolos bëgga dem Akayi, bokk ya xiir ko ca, ñu bind taalibe ya, ngir ñu teeru ko teeru bu rafet. Noonu mu dikk fa te jariñ lool ñi gëm jaare ko ci yiwu Yàlla. ");
INSERT INTO wol2010_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","Ndaxte mu ngay yey Yawut ya ca kanam ñépp, di firi Mbind yi, ba wone ne Yeesu mooy Almasi bi. ");
INSERT INTO wol2010_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","Ba Apolos nekkee Korent nag, Pool jaar ca teggi ya gëna kawe ca réew ma, doora dikk Efes. Noonu mu gis fa ay taalibe. ");
INSERT INTO wol2010_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","Mu ne leen: «Ndax jot ngeen ci Xel mu Sell mi, bi ngeen gëmee?» Ñu ne ko: «Déggunu sax ne Xel mu Sell mi am na.» ");
INSERT INTO wol2010_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","Mu ne leen: «Kon nag, bi ñu leen sóobee ci ndox, lu ciy maana?» Ñu ne ko: «Xanaa li Yaxya tëral.» ");
INSERT INTO wol2010_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","Pool ne leen: «Yaxya daan na sóob nit ñi ci ndox, ndax bi ñu tuubee seeni bàkkaar; te mu ne bànni Israyil, kiy topp ci moom lañu wara gëm, maanaam Yeesu.» ");
INSERT INTO wol2010_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","Bi ñu déggee loolu nag, sóob nañu leen ci ndox ci turu Yeesu Boroom bi. ");
INSERT INTO wol2010_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","Te bi leen Pool tegee loxo, Xel mu Sell mi ñëw ci ñoom, ñuy wax yeneen làkk, di wax ci kàddug Yàlla. ");
INSERT INTO wol2010_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","Limub nit ñooñu nekk na lu mat fukk ak ñaar. ");
INSERT INTO wol2010_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","Noonu Pool dugg ca jàngu ba, di wax ak fit wu dëgër diirub ñetti weer, di diisoo ak ñoom ci mbirum nguurug Yàlla, di leen jéema gëmloo. ");
INSERT INTO wol2010_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","Waaye bi xolu ñenn ci ñoom fattee, ñu gëmadi, bay suufeel yoon wi ci kanam mbooloo ma, mu jóge ci ñoom, xàjjale taalibe yi ak ñoom, di diisoo bés bu nekk ca jàngukaayu ku ñuy wax Tiranus. ");
INSERT INTO wol2010_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","Mu wéy ci noonu diirub ñaari at, ba ñi dëkk diiwaanu Asi ñépp dégg kàddug Boroom bi, muy Yawut muy Gereg. ");
INSERT INTO wol2010_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","Booba Yàllay def ay kéemaan yu ràññiku yuy jaar ci loxoy Pool. ");
INSERT INTO wol2010_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","Ñu yóbbul sax ñi wopp ay kaala ak ay taraxlaay yu laaloon yaramam, ba jàngoro yi di leen bàyyi, rab yay génn ci ñoom. ");
INSERT INTO wol2010_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","Noonu ay Yawut yuy wëndeelu, di faj ñi rab jàpp, ñu di leen jéema ñaanal ci turu Yeesu Boroom bi naan: «Ci turu Yeesu, mi Pool di yégle, génnleen.» ");
INSERT INTO wol2010_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","Ñi doon def loolu, juróom ñaari doom lañu woon ci Sewa, mi doon sarxalkat bu mag ci Yawut yi. ");
INSERT INTO wol2010_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","Waaye bi ñu ko defee rab wa ne leen: «Xam naa Yeesu, xam naa it kuy Pool, waaye yéenay ñan?» ");
INSERT INTO wol2010_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","Ci kaw loolu nit ka rab jàpp song leen, not leen ñoom ñépp; mu soxore leen lool, ba ñu daw kër ga, def yaramu neen te gaañu bu metti. ");
INSERT INTO wol2010_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","Loolu siiw na ci ñépp, ñi dëkk Efes, di Yawut ak Gereg; tiitaange jàpp leen ñoom ñépp, ba ñu màggal turu Yeesu Boroom bi. ");
INSERT INTO wol2010_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","Bi loolu amee ñu bare ci ñi gëm ñëw, di wesar ci kanam ñépp seeni jati luxus. ");
INSERT INTO wol2010_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","Te ñu bare ci ñi daan luxus, indi seeni téere, lakk leen ci kanam ñépp. Te bi ñu xaymaa njég la, mu tollook juróom fukki junniy poseti daraxma. ");
INSERT INTO wol2010_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","Noonu la kàddu Boroom bi lawe, te not lépp. ");
INSERT INTO wol2010_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","Bi loolu wéyee Pool nas xel jëm Yerusalem, jaar ci diiwaani Maseduwan ak Akayi. Mu ne: «Gannaaw bu ma fa demee, fàww ma seeti Room it.» ");
INSERT INTO wol2010_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","Mu yebal nag ci Maseduwan ñaari jaraafam, di Timote ak Erast, waaye moom mu des ab diir ci Asi. ");
INSERT INTO wol2010_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","Fekk booba amoon na yëngu-yëngu bu réy ci lu aju ci Yoon wi. ");
INSERT INTO wol2010_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","Ndaxte nit ku tudd Demetirus, di tëggu xaalis buy defar nataali xaalis ngir màggal Artemis, daan na ci jariñu lu bare, moom ak ay nawleem. ");
INSERT INTO wol2010_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","Noonu mu dajale leen ak seeni liggéeykat ne leen: «Gaa ñi, xam ngeen ne sunu njariñ mu ngi aju ci liggéey bii. ");
INSERT INTO wol2010_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","Gis ngeen nag te dégg ne Pool male gëmloo na bay fàbbi mbooloo mu bare, waxuma ci Efes rekk, waaye ci biir Asi gépp naan: “Yàlla yu ay loxo defar duñu ay yàlla.” ");
INSERT INTO wol2010_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","Léegi kat loraangee ngi nuy yoot, te du yem ci xañ nu sunu liggéey rekk, waaye it dina daaneel màggalukaayu Artemis sunu yàlla ju mag ji, tey neenal ndamam, moom mi Asi gépp te àddina sépp di màggal.» ");
INSERT INTO wol2010_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","Bi ñu déggee loolu, mer mu réy tàbbi ci ñoom, ñuy yuuxu ne: «Artemis mu Efes màgg na!» ");
INSERT INTO wol2010_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","Noonu dëkk bépp jaxasoo. Ñu bokk benn xalaat, daldi ne milib ca powukaay ba, diri Gayus ak Aristàrk, waa Maseduwan, ñi ànd ak Pool. ");
INSERT INTO wol2010_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","Pool nag bëgga dugg ca mbooloo ma, waaye taalibe ya nanguwuñu ko. ");
INSERT INTO wol2010_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","Ñenn ca jawriñi nguur gi it, ñuy ay xaritam, yónnee ci moom, di ko dénk, mu baña jaay bakkanam ci dugg ca powukaay ba. ");
INSERT INTO wol2010_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","Noonu ndaje ma rëb, ba ñii di yuuxu lii, ñale di yuuxu laa, te ña ca gëna bare xamuñu lu waral ndaje ma. ");
INSERT INTO wol2010_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","Ci kaw loolu Yawut ya jéñ Alegsàndar ci kanam, te mbooloo ma di ko xaacu ay ndigal, mu daldi tàllal loxoom, ngir làyyi ca mbooloo ma. ");
INSERT INTO wol2010_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","Waaye bi ñu xamee ne Yawut la, ñépp a bokk benn baat, yuuxu diirub lu mat ñaari waxtu naan: «Artemis mu Efes màgg na!» ");
INSERT INTO wol2010_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","Gannaaw loolu boroom dëkk ba dalal mbooloo ma ne leen: «Yéen waa Efes, ana ku xamul ne dëkku Efes moo di wottukaayu màggalukaayu Artemis ak nataalam, bi wàcce asamaan? ");
INSERT INTO wol2010_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","Gannaaw nag kenn manta weddi loolu, war ngeena dalal seen xel te baña sañaxu ci dara. ");
INSERT INTO wol2010_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","Ndaxte nit ñii ngeen fi indi sàccuñu ca màggalukaay ya te sosaluñu sunu yàlla. ");
INSERT INTO wol2010_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","Su fekkee ne Demetirus ak ay nawleem jànkoonte nañu ak kenn, am na ay bési layoo ak ñu yilif réew mi; nañu fa woo ku ñu amleenteel. ");
INSERT INTO wol2010_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","Waaye su ngeen di laaj leneen, mbooloom dëgg dina ko àtte. ");
INSERT INTO wol2010_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","Ndaxte fi mu ne man nañu noo jiiñ jógug mbooloo mi ndax li fi xew tey. Te bu loolu amee dunu am aw lay ci mbirum mbooloo mu rëb mii, ndaxte amul dara lu ko waral.» Bi mu waxee loolu nag, mu tas mbooloo ma. ");
INSERT INTO wol2010_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","Bi yëngu-yëngu ba dalee, Pool woo taalibe ya fa moom, dooleel leen. Bi mu ko defee mu tàggoo ak ñoom, jóge fa, dellu diiwaanu Maseduwan. ");
INSERT INTO wol2010_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","Noonu mu jaar ca bérab yooyu, di dooleel nit ñi ak wax yu bare; ba noppi mu dem réewu Geres, ");
INSERT INTO wol2010_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","toog fa ñetti weer. Waaye bi mu nekkee ci kaw tànki dugg gaal jëm diiwaanu Siri, te Yawut yi lalal ko pexe, mu fas yéenee dellu, jaare Maseduwan. ");
INSERT INTO wol2010_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","Booba nag ñii ñoo ànd ak moom: Sopater, doomu Pirus mi dëkk Bere; Aristàrk ak Segond, ñi dëkk Tesalonig; Gayus, mi dëkk Derbë, ak Timote; te it Tisig ak Torofim ñi dëkk Asi. ");
INSERT INTO wol2010_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","Ñooñu nag jiitu, di nu nég dëkku Torowas. ");
INSERT INTO wol2010_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","Waaye naka nun, gannaaw màggalu Yawut, ga ñuy wax Mburu ma amul lawiir, nu dugg gaal ci Filib, def ci juróomi fan, fekksi leen Torowas, nu am fa juróom ñaari fan. ");
INSERT INTO wol2010_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","Ca bés bu jëkk ca ayu-bés ga, booloo nanu ngir damm mburu ma. Te Pool, mi bëggoona dem ca ëllëg sa, di diisoo ak ñoom te waxtaanam law ba ci xaaju guddi. ");
INSERT INTO wol2010_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","Ca néeg bu kawe, ba nu booloo nag, amoon na fa làmp yu bare. ");
INSERT INTO wol2010_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","Noonu waxambaane wu tudd Ëtikus te toog ca palanteer ba, gëmméentu bay jeyaxu. Bi Pool di gëna yaatal waxtaanam nag, nelaw daldi ko jàpp, mu xàwwikoo ca ñetteelu taax ma, daanu, ñu yékkati ko, fekk mu dee. ");
INSERT INTO wol2010_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","Waaye Pool wàcc, daldi sëgg ci kawam, roof ko loxoom ne leen: «Bàyyileen jooy yi, mu ngi dund.» ");
INSERT INTO wol2010_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","Noonu mu yéegaat, damm mburu ma, lekk; ba noppi delluwaat ci waxtaanam, di ko yaatal ba ca njël, doora tàggoo. ");
INSERT INTO wol2010_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","Naka waxambaane wa, ñu indi ko muy dund, ba seen xol sedd guyy. ");
INSERT INTO wol2010_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","Nun nag nu jiitu, dugg gaal jëm Asos, fa nu Pool santoon, nu jële ko fa; fekk moom fas na yéeney dox, ba agsi fa. ");
INSERT INTO wol2010_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","Noonu mu fekksi nu ci Asos, nu jël ko ca gaal ga, dem Mitilen. ");
INSERT INTO wol2010_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","Gannaaw loolu gaal ga jóge fa, nu agsi ca ëllëg sa janook dunu Kiyos. Bés ba ca tegu nag nu jàll ba Samos, te ñetteelu fan ba nu àgg Mile. ");
INSERT INTO wol2010_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","Ndaxte Pool fasoon na yéenee teggi Efes, ngir baña yàgg ci diiwaanu Asi; mu ngi doon gaawantu, ngir màggal, gi ñuy wax Pàntakot fekk ko Yerusalem. ");
INSERT INTO wol2010_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","Bi Pool eggee Mile nag, mu yónnee ca Efes, ngir woo njiiti mbooloom ñi gëm. ");
INSERT INTO wol2010_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","Bi ñu ñëwee, mu ne leen: «Yéen xam ngeen bu baax, ni ma doon doxale diirub sama ngan gépp ci seen biir, li dale ci bés bi ma jëkkee teg tànk ci Asi ba tey. ");
INSERT INTO wol2010_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","Jaamu naa Boroom bi ci woyof gu mat ak ay rongooñ, dékku ay nattu yu ma pexey Yawut yi indil. ");
INSERT INTO wol2010_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","Xam ngeen ne masuma leena nëbb dara lu leen di jariñ, di leen jàngal ci kanam ñépp ak ca kër ya. ");
INSERT INTO wol2010_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","Dénk naa Yawut yi ak Gereg yi ne leen, ñu tuub seeni bàkkaar, ba waññiku ci Yàlla te gëm sunu Boroom Yeesu. ");
INSERT INTO wol2010_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","«Léegi maa ngi nii di dem Yerusalem, ci li ma Xelu Yàlla mi xiirtal, te xawma lu ma fay dal. ");
INSERT INTO wol2010_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","Xam naa rekk ne ci dëkkoo dëkk Xel mu Sell mi xamal na ma ne ay buum ak ay metit ñu ngi may nég. ");
INSERT INTO wol2010_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","Waaye sama bakkan soxalu ma, su fekkee bey naa sama sas, ba matal liggéey, bi ma Boroom bi dénk, maanaam ma seedeel ci ñépp xibaaru jàmm, bi ëmb yiwu Yàlla. ");
INSERT INTO wol2010_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","«Fi mu ne nag xam naa ne dootuleen gis sama kanam, yéen ñépp ñi ma jaaroon ci seen biir, di yégle nguuru Yàlla. ");
INSERT INTO wol2010_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","26","Moo tax may dëggal tey jii ne wàccoo naa ak yéen ñépp bés pénc. ");
INSERT INTO wol2010_vpl VALUES ("AC20_27","074_20_27","ACT","20","27","27","Ndaxte ñeebluwuma leen, ci di leen xamal lépp li Yàlla digle. ");
INSERT INTO wol2010_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","Wottuleen nag seen bopp te wottu coggal jépp, ji leen Xel mu Sell mi def sàmm, ngeen sàmm mbooloo, mi Yàlla jotal boppam ak deretu Doomam. ");
INSERT INTO wol2010_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","Xam naa ne bu ma leen wonee gannaaw, bukki yu soxor dinañu tàbbi ci coggal ji te duñu ci ñeeblu kenn. ");
INSERT INTO wol2010_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","Ay nit dinañu jóg ci seen biir sax, di wax luy sànke, ngir sàkku ay taalibe. ");
INSERT INTO wol2010_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","Foogleen nag, di fàttaliku ne diirub ñetti at, guddi ak bëccëg, masumaa noppi di leen artu kenn ku nekk ci yéen ak ay rongooñ. ");
INSERT INTO wol2010_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","«Léegi nag maa ngi leen di dénk Boroom bi, moom ak kàddug yiwam, gi leen mana dëgëral te may leen cér ci biir gaayi Yàlla yu sell yépp. ");
INSERT INTO wol2010_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","Nammuma xaalisu kenn mbaa wurusam mbaa koddaayam. ");
INSERT INTO wol2010_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","Xam ngeen ne faj naa samay soxla ak soxlay ñi ànd ak man ci sama loxo yii. ");
INSERT INTO wol2010_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","Ci lépp won naa leen royukaay, ci li nu wara dimbali ñi néew doole te fàttaliku li Yeesu Boroom bi wax moom ci boppam ne: “Joxe moo gëna barkeel nangu.”» ");
INSERT INTO wol2010_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","Bi mu waxee loolu, mu sukk ak ñoom ñépp, ñaan ci Yàlla. ");
INSERT INTO wol2010_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","37","Te ñépp jooy bu metti, di laxasu ci baatu Pool, fóon ko bu baax. ");
INSERT INTO wol2010_vpl VALUES ("AC20_38","074_20_38","ACT","20","38","38","Li leen gëna teg aw tiis mooy li mu leen wax: «Dootuleen gis sama kanam.» Noonu ñu gunge ko ba ca gaal ga. ");
INSERT INTO wol2010_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","Bi nga xamee ne tàggoo nanu ak ñoom ci naqar, nu dugg gaal, jubal dunu Kos. Te ca ëllëg sa nu dem ba teer ca Rodd, ba noppi jóge fa, jàll ba Patara. ");
INSERT INTO wol2010_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","Foofa nag nu gis gaal guy jàll ba Fenisi, nu dugg ca, mu daldi teddi. ");
INSERT INTO wol2010_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","Noonu nu séen dunu Sipar, bàyyi ko ci sunu càmmoñ, jublu diiwaanu Siri, nu teersi Tir. Ndaxte foofa la gaal gi wara yebbee la mu yeboon. ");
INSERT INTO wol2010_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","Nu wut taalibe ya, ba gis leen, toog ak ñoom juróom ñaari fan. Ñoom nag ñu ne Pool ci li leen Xelu Yàlla mi may, mu baña dem Yerusalem. ");
INSERT INTO wol2010_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","Moona bi jataayu gaal ga matee, nu awaat ci yoon wi. Te ñépp gunge nu, ñoom ak seeni soxna ak seeni doom; nu génn dëkk ba, sukk ca tefes ga, ñaan ci Yàlla. ");
INSERT INTO wol2010_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","Noonu nu tàggoo ak ñoom, dugg ca gaal ga, ñu dellu seen kër. ");
INSERT INTO wol2010_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","Bi nu jógee Tir nag, nu demaat ci géej, ba teer Patolemayis. Foofa nu nuyu bokk ya, yendu, fanaan. ");
INSERT INTO wol2010_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","Nu jóge fa ca ëllëg sa, ñëw ba ca dëkku Sesare. Nu dugg ca kër Filib, taskatu xibaaru jàmm bi, mi bokk ci Juróom ñaar ña, nu dal fa moom. ");
INSERT INTO wol2010_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","Amoon na ñeenti doom yuy janq, ñuy wax ci kàddug Yàlla. ");
INSERT INTO wol2010_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","Bi nu fa nekkee ay fan nag, yonent bu tudd Agabus jóge Yude, agsi. ");
INSERT INTO wol2010_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","Mu ñëw ci nun, daldi yeew ay loxoom ak i tànkam ak laxasaayu Pool naan: «Nii la Xel mu Sell mi waxe: “Ki moom laxasaay gii, Yawut yi dinañu ko yeewe nii ca Yerusalem, jébbal ko ñi dul Yawut.”» ");
INSERT INTO wol2010_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","Bi nu déggee loolu, nun ak ña fa nekk nu ñaan Pool, mu baña dem Yerusalem. ");
INSERT INTO wol2010_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","Ci kaw loolu Pool ne: «Lu ngeen di jooy, di yàq sama xol? Bañuma ñu yeew ma rekk, waaye nangu naa sax, ñu rey ma ci Yerusalem ngir turu Yeesu Boroom bi.» ");
INSERT INTO wol2010_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","Bi nu ko manula dëpp, nu noppi ne: «Kon na coobarey Boroom bi am!» ");
INSERT INTO wol2010_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","Gannaaw fan yooyu nu defaru, ngir dem Yerusalem. ");
INSERT INTO wol2010_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","Noonu ay taalibe yu dëkk Sesare ànd ak nun, yóbbu nu ca nit ku tudd Manason, fu nu wara dal; moom nag nitu Sipar la woon, di taalibe bu yàgg. ");
INSERT INTO wol2010_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","Bi nu agsee Yerusalem nag, taalibe ya teeru nu ak mbég. ");
INSERT INTO wol2010_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","Ca ëllëg sa Pool ànd ak nun, seeti Saag, fekk njiit yépp teew fa. ");
INSERT INTO wol2010_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","Noonu Pool nuyu leen, nettali leen benn-benn li Yàlla def ci biir ñi dul Yawut, jaarale ko ci liggéeyam. ");
INSERT INTO wol2010_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","Bi ko njiit ya déggee, ñu màggal Yàlla ne ko: «Mbokk mi, gis nga ne am na ay junniy Yawut ñu gëm, te ñépp a sawar ci yoonu Musaa. ");
INSERT INTO wol2010_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","Dégg nañu ci sa mbir nag ne yaa ngi jàngal Yawut yépp, yi dëkk ci biir ñi dul Yawut, ñu bàyyi yoonu Musaa te baña xarafal seeni doom mbaa topp sunuy aada. ");
INSERT INTO wol2010_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","Lu nu ci wara def nag? Ndaxte ci lu wér dinañu xam ne ñëw nga. ");
INSERT INTO wol2010_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","23","Nu ngi lay digal nag, nga def nii: am na ci nun ñeenti góor ñu dige ak Yàlla. ");
INSERT INTO wol2010_vpl VALUES ("AC21_24","074_21_24","ACT","21","24","24","Jël leen, bokk ak ñoom setlu, te nga gàddu seen peyu wateef. Noonu ñépp dinañu xam ne li ñu déggoon ci sa mbir du dëgg, waaye yaa ngi jëf tey sàmm yoonu Musaa. ");
INSERT INTO wol2010_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","Naka ñi dul Yawut ñi gëm, bind nanu leen li nu àtte ne, ñu moytu ñam wu ñu tuuroo xërëm te moytu deretu médd ak njaaloo.» ");
INSERT INTO wol2010_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","Bi ñu ko waxee, Pool jël nit ña te ca ëllëg sa mu bokk setlu ak ñoom, ñu dugg ca kër Yàlla ga. Ñu xamle ban bés la seen setlu di àgg, di bés bu ñuy jébbale sarax ngir kenn ku nekk ci ñoom. ");
INSERT INTO wol2010_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","27","Bi àppu juróom ñaari fan ya di bëgga jeex, Yawut yi jóge diiwaanu Asi gis Pool ca kër Yàlla ga. Ñu daldi jógloo mbooloo mépp, jàpp ko, ");
INSERT INTO wol2010_vpl VALUES ("AC21_28","074_21_28","ACT","21","28","28","di xaacu ne: «Wallee, wallee, yéen bokki Israyil! Waa jaa ngi nii, moom miy waare fépp ak ci ñépp, bay suufeel sunu xeet ak yoonu Musaa ak bérab bii; dugal na sax ay Gereg fii ci kër Yàlla gi, ba indi sobe ci bérab bu sell bii.» ");
INSERT INTO wol2010_vpl VALUES ("AC21_29","074_21_29","ACT","21","29","29","Li tax ñu wax loolu, mooy gisoon nañu Torofim mu Efes, ànd ak moom ca dëkk ba, te ñu yaakaar ne Pool dugal na ko ca kër Yàlla ga. ");
INSERT INTO wol2010_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","Noonu dëkk ba bépp màbb, mbooloo ma ne këpp, ñu jàpp Pool, génne ko ca kër Yàlla ga. Ca saa sa ñu tëj bunt ya. ");
INSERT INTO wol2010_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","31","Bi ñu koy wuta rey, xibaar ba agsi ba ca kilifag mbooloom xarekat ba, naan Yerusalem gépp jaxasoo na. ");
INSERT INTO wol2010_vpl VALUES ("AC21_32","074_21_32","ACT","21","32","32","Ca saa sa mu ànd ak ay xarekat ak ay njiiti xare, ne jaas wàcc ci ñoom. Bi Yawut ya gisee kilifa ga ak xarekat ya nag, ñu daldi bàyyi dóor, ya ñu doon dóor Pool. ");
INSERT INTO wol2010_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","Noonu kilifa ga jegesi jàpp ko, santaane ñu jéng ko ak ñaari càllala. Bi ñu ko defee mu laaj ku mu doon ak lu mu def. ");
INSERT INTO wol2010_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","Waaye ci biir mbooloo ma, bu ñii nee lii, ña ca des ne laa. Kon nag gannaaw manu caa xam dara lu wóor ndax coow li, mu santaane, ñu yóbbu ko ci biir tata ja. ");
INSERT INTO wol2010_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","35","Bi Pool eggee ca yéegukaayu tata ja, aaytalu mbooloo ma réy, ba ay xarekat fab ko. ");
INSERT INTO wol2010_vpl VALUES ("AC21_36","074_21_36","ACT","21","36","36","Ndaxte mbooloo maa nga ko topp, di xaacu ne: «Reyleen ko!» ");
INSERT INTO wol2010_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","37","Bi ñu koy bëgga dugal ca tata ja, Pool ne kilifa ga: «Ndax man naa laa wax dara?» Mu ne ko: «Yaw dégg nga gereg? ");
INSERT INTO wol2010_vpl VALUES ("AC21_38","074_21_38","ACT","21","38","38","Kon nekkuloo waayi Misra, jooju jógloo woon nit ñi keroog te yóbbu woon ñeenti junniy bóomkat ca màndiŋ ma?» ");
INSERT INTO wol2010_vpl VALUES ("AC21_39","074_21_39","ACT","21","39","39","Pool ne ko: «Man Yawut laa, di jaambur ci Tars, dëkk bu am tur ci diiwaanu Silisi. Maa ngi lay ñaan, ma wax ak mbooloo mi.» ");
INSERT INTO wol2010_vpl VALUES ("AC21_40","074_21_40","ACT","21","40","40","Te kilifa ga may ko ko. Noonu Pool taxaw ca yéegukaay ba, tàllal loxoom mbooloo ma, ñu daldi ne tekk. Mu wax ak ñoom ci làkku yawut ne: ");
INSERT INTO wol2010_vpl VALUES ("AC22_1","074_22_1","ACT","22","1","1","«Yéen bokk yi ak baay yi, dégluleen samaw lay.» ");
INSERT INTO wol2010_vpl VALUES ("AC22_2","074_22_2","ACT","22","2","2","Bi ñu déggee, mu di leen wax ci làkku yawut, ñu gën ne xerem. Noonu Pool ne leen: ");
INSERT INTO wol2010_vpl VALUES ("AC22_3","074_22_3","ACT","22","3","3","«Man Yawut laa, juddoo Tars ci diiwaanu Silisi, yaroo ci dëkk bii. Taalibe laa woon ci Gamaleel, mu jàngal ma bu wér yoonu sunuy maam, ba ma sawar ci Yàlla, mel ni yéen ñépp tey. ");
INSERT INTO wol2010_vpl VALUES ("AC22_4","074_22_4","ACT","22","4","4","Daan naa fitnaal ña bokkoon ci yoon wii, ba di ci rey sax; yeew naa góor ak jigéen, tëj leen; ");
INSERT INTO wol2010_vpl VALUES ("AC22_5","074_22_5","ACT","22","5","5","sarxalkat bu mag ba ak mbooloom njiit yi yépp man nañu ma cee seede. Am bés ñu bindal ma ay bataaxal ngir bokki Damaas. Ma doon fa dem, ngir yeew ña fa nekkoon, indi leen Yerusalem, ngir ñu yar leen. ");
INSERT INTO wol2010_vpl VALUES ("AC22_6","074_22_6","ACT","22","6","6","«Waaye ci digg bëccëg, bi ma jaaree ca yoon wa, ba jegesi Damaas, ca saa sa leer gu mag jóge asamaan, melax ba ëmb ma. ");
INSERT INTO wol2010_vpl VALUES ("AC22_7","074_22_7","ACT","22","7","7","Ma daldi ne nërëm ci suuf, dégg baat bu ma ne: “Sóol, Sóol, lu tax nga di ma fitnaal?” ");
INSERT INTO wol2010_vpl VALUES ("AC22_8","074_22_8","ACT","22","8","8","Ma ne ko: “Yaa di kan, Boroom bi?” Mu ne ma: “Maa di Yeesum Nasaret, mi ngay fitnaal.” ");
INSERT INTO wol2010_vpl VALUES ("AC22_9","074_22_9","ACT","22","9","9","Ñi ma àndaloon gis nañu leer ga, waaye dégguñu baatu ka doon wax ak man. ");
INSERT INTO wol2010_vpl VALUES ("AC22_10","074_22_10","ACT","22","10","10","Noonu ma laaj ko: “Lu ma wara def, Boroom bi?” Boroom bi ne ma: “Jógal dem Damaas, foofa dees na la biral lépp, li ma la yen.” ");
INSERT INTO wol2010_vpl VALUES ("AC22_11","074_22_11","ACT","22","11","11","Gannaaw gisuma woon dara ndax leeraayu melxat ga, ña ma àndal wommat ma, ma ñëw Damaas. ");
INSERT INTO wol2010_vpl VALUES ("AC22_12","074_22_12","ACT","22","12","12","«Bi ma ko defee ku tudd Anañas ñëw ci man. Nit ku ragal Yàlla la woon ci sàmm yoonu Musaa, te Yawuti Damaas yépp seedeel ko lu baax. ");
INSERT INTO wol2010_vpl VALUES ("AC22_13","074_22_13","ACT","22","13","13","Mu taxaw ci sama wet ne ma: “Sóol sama mbokk, delluwaatal di gis.” Noonu ma daldi gisaat ca saa sa, xool ko. ");
INSERT INTO wol2010_vpl VALUES ("AC22_14","074_22_14","ACT","22","14","14","Mu ne ma: “Sunu Yàllay maam tànn na la, ba may la, nga xam coobareem te gis Aji Jub ji te nga dégg ay waxam. ");
INSERT INTO wol2010_vpl VALUES ("AC22_15","074_22_15","ACT","22","15","15","Ndaxte li nga gis te dégg ko, dinga ko seede ci ñépp. ");
INSERT INTO wol2010_vpl VALUES ("AC22_16","074_22_16","ACT","22","16","16","Léegi nag, looy nég? Jógal, ñu sóob la ci ndox, nga set ci say bàkkaar ci tudd turu Yeesu.” ");
INSERT INTO wol2010_vpl VALUES ("AC22_17","074_22_17","ACT","22","17","17","«Bi ma délsee Yerusalem nag, di ñaan ca kër Yàlla ga, leer tàbbi ci man. ");
INSERT INTO wol2010_vpl VALUES ("AC22_18","074_22_18","ACT","22","18","18","Ma daldi gis Boroom bi, mu ne ma: “Génnal Yerusalem nu mu gëna gaawe, ndaxte duñu nangu li ngay seede ci man.” ");
INSERT INTO wol2010_vpl VALUES ("AC22_19","074_22_19","ACT","22","19","19","Ma ne ko: “Boroom bi, xam nañu ne dama daan wër jàngoo jàngu, di tëj kaso ak di dóor ay yar ñi la gëm. ");
INSERT INTO wol2010_vpl VALUES ("AC22_20","074_22_20","ACT","22","20","20","Rax-ca-dolli bi ñu tuuree deretu Ecen, mi la doon seedeel, teewe naa ko, ànd ca, bay wottu sax yérey ñi ko doon rey.” ");
INSERT INTO wol2010_vpl VALUES ("AC22_21","074_22_21","ACT","22","21","21","Waaye Boroom bi ne ma: “Demal, dinaa la yebal fu sore, nga jëm ci xeeti ñi dul Yawut.”» ");
INSERT INTO wol2010_vpl VALUES ("AC22_22","074_22_22","ACT","22","22","22","Mbooloo ma déglu ko nag ba ca wax jooju, waaye bi ñu déggee loolu, ñu daldi yuuxu naan: «Farleen ko ci àddina! Yembar mu mel ni moom yeyoowula dund!» ");
INSERT INTO wol2010_vpl VALUES ("AC22_23","074_22_23","ACT","22","23","23","Ñu daldi yuuxu ak di sànni seeni yére, tibb suuf, di callmeeru. ");
INSERT INTO wol2010_vpl VALUES ("AC22_24","074_22_24","ACT","22","24","24","Noonu kilifa ga santaane, ñu dugal Pool ca tata ja te caw ko ay yar yu metti, laaj ko ba xam lu tax ñu di ko yuuxoo nii. ");
INSERT INTO wol2010_vpl VALUES ("AC22_25","074_22_25","ACT","22","25","25","Waaye bi ñu koy joñ ak ay der, Pool ne njiitu xare ba fa taxaw: «Ndax am nga sañ-sañu dóor ay yar jaamburu Room, te fekk yoon dabu ko sax?» ");
INSERT INTO wol2010_vpl VALUES ("AC22_26","074_22_26","ACT","22","26","26","Bi ko njiit la déggee, mu fekki kilifaam, yégal ko ko; mu ne ko: «Ndax xam nga li ngay def? Nit kale jaambur la ci Room.» ");
INSERT INTO wol2010_vpl VALUES ("AC22_27","074_22_27","ACT","22","27","27","Noonu kilifa ga ñëw laaj Pool: «Wax ma, ndax jaambur nga ci Room?» Mu ne ko: «Waaw, moom laa.» ");
INSERT INTO wol2010_vpl VALUES ("AC22_28","074_22_28","ACT","22","28","28","Kilifa ga ne ko: «Man fey naa xaalis bu bare, ngir nekk jaambur ci Room.» Waaye Pool ne ko: «Man de dama koo judduwaale.» ");
INSERT INTO wol2010_vpl VALUES ("AC22_29","074_22_29","ACT","22","29","29","Ñi ko bëggoona dóor ay yar nag randu ko ca saa sa. Te kilifa ga sax tiit ci xam ne Pool jaamburu Room la, te yeewlu na ko. ");
INSERT INTO wol2010_vpl VALUES ("AC22_30","074_22_30","ACT","22","30","30","Ca ëllëg sa kilifa ga bàyyi ko, ndaxte bëggoon na xam bu wóor lu ko Yawut ya jiiñ. Mu santaane ne, sarxalkat yu mag ya dajaloo, ñoom ak kureelu àttekat ya. Gannaaw loolu mu indilu Pool, dëj ko ci seen kanam. ");
INSERT INTO wol2010_vpl VALUES ("AC23_1","074_23_1","ACT","23","1","1","Noonu Pool xool jàkk géew ba ne leen: «Bokk yi, ci xel mu dal laa doxale ci kanam Yàlla ba ci bésu tey bi.» ");
INSERT INTO wol2010_vpl VALUES ("AC23_2","074_23_2","ACT","23","2","2","Ci kaw loolu sarxalkat bu mag ba, di ku ñuy wax Anañas, sant ña taxaw ca wetam, ñu fél gémmiñam. ");
INSERT INTO wol2010_vpl VALUES ("AC23_3","074_23_3","ACT","23","3","3","Pool ne ko: «Yàlla dina la dóor, yaw mi naaféq, bay samandaay miir bu joy bu ñu weexal. Yaa ngi toog di ma àtte, ci li yoon wi digle, ba noppi santaane ñu dóor ma, ci li yoon wi tere!» ");
INSERT INTO wol2010_vpl VALUES ("AC23_4","074_23_4","ACT","23","4","4","Waaye ña taxaw ca wetam ne ko: «Ndax dangay xas sarxalkat bu mag, bi Yàlla fal?» ");
INSERT INTO wol2010_vpl VALUES ("AC23_5","074_23_5","ACT","23","5","5","Pool ne leen: «Bokk yi, xawma woon ne sarxalkat bu mag bi la, ndaxte tëral nañu ci Mbind mi ne: “Bul wax lu bon sa kilifag xeet.”» ");
INSERT INTO wol2010_vpl VALUES ("AC23_6","074_23_6","ACT","23","6","6","Naka noona Pool, mi xam ne genn-wàllu kureel ga bokk nañu ci tariixab Sadusen ya, te ña ca des bokk ci tariixab Farisen ya, mu wax ci kaw ci biir géew ba ne: «Bokk yi, man Farisen laa, te Farisen moo ma jur; li tax ñu may àtte tey mooy sama yaakaar ci ne, ñi dee dinañu dekki.» ");
INSERT INTO wol2010_vpl VALUES ("AC23_7","074_23_7","ACT","23","7","7","Bi mu waxee loolu nag, werante wu metti daldi xew diggante Farisen ya ak Sadusen ya, ba mbooloo ma xàjjalikoo. ");
INSERT INTO wol2010_vpl VALUES ("AC23_8","074_23_8","ACT","23","8","8","Ndaxte Sadusen yi nanguwuñu ne ndekkite mbaa malaaka mbaa rab, dara am na ci, waaye Farisen nangu nañu yooyu yépp. ");
INSERT INTO wol2010_vpl VALUES ("AC23_9","074_23_9","ACT","23","9","9","Ci kaw loolu nag coow lu bare daldi jib. Ñenn ca xutbakat, ya bokk ca Farisen ya, ne bërét, daldi xuloo bu metti ne: «Gisunu dara lu bon ci nit kii. Su fekkeente ne rab a ko wax mbaa malaaka…?» ");
INSERT INTO wol2010_vpl VALUES ("AC23_10","074_23_10","ACT","23","10","10","Noonu xuloo ba daldi gëna tàng, ba kilifa ga ragal ne, nit ñi dinañu daggaate Pool. Kon mu sant xarekat ya, ñu wàcc, nangu Pool ci ñoom, yóbbu ko ca tata ja. ");
INSERT INTO wol2010_vpl VALUES ("AC23_11","074_23_11","ACT","23","11","11","Ca guddi ga nag Boroom bi taxaw ci wetu Pool ne ko: «Takkal sa fit; ni nga ma seedee ci Yerusalem, noonu nga may seedee ca Room.» ");
INSERT INTO wol2010_vpl VALUES ("AC23_12","074_23_12","ACT","23","12","12","Bi bët setee Yawut ya daldi lal pexe; ñu dige ci ngiñ ne duñu lekkati, duñu naanati, ba kera ñuy rey Pool. ");
INSERT INTO wol2010_vpl VALUES ("AC23_13","074_23_13","ACT","23","13","13","Ña lal pexe ma, seen lim ëpp na ñeent fukk. ");
INSERT INTO wol2010_vpl VALUES ("AC23_14","074_23_14","ACT","23","14","14","Noonu ñu dem ca sarxalkat yu mag ya ak njiit ya ne leen: «Giñ nanu ne dunu mos dara, ba kera nuy rey Pool. ");
INSERT INTO wol2010_vpl VALUES ("AC23_15","074_23_15","ACT","23","15","15","Léegi nag yéen ak kureelu àttekat ya, laajleen kilifa ga, mu indi ko ci seen kanam, mel ni dangeena bëgga seet mbiram bu gëna wóor. Bu ko defee nun dinanu fagaru, ngir rey ko, bala moo agsi.» ");
INSERT INTO wol2010_vpl VALUES ("AC23_16","074_23_16","ACT","23","16","16","Waaye jarbaatu Pool yég fiir ga, mu dem, dugg ca tata ja, yégal ko Pool. ");
INSERT INTO wol2010_vpl VALUES ("AC23_17","074_23_17","ACT","23","17","17","Bi ko Pool déggee, mu woo kenn ca njiiti xare ba ne ko: «Yóbbul waxambaane wii ca kilifa ga, ndax am na lu mu ko wara yégal.» ");
INSERT INTO wol2010_vpl VALUES ("AC23_18","074_23_18","ACT","23","18","18","Njiit la jël ko, yóbbu ko ca kilifa ga ne ko: «Pool, mi ñu jàpp, moo ma woo, ñaan ma, ma indil la waxambaane wii, ndaxte am na lu mu lay wax.» ");
INSERT INTO wol2010_vpl VALUES ("AC23_19","074_23_19","ACT","23","19","19","Noonu kilifa ga jàpp ci loxob waxambaane wa, wéetoo ak moom, laaj ko: «Loo ma bëgga yégal?» ");
INSERT INTO wol2010_vpl VALUES ("AC23_20","074_23_20","ACT","23","20","20","Mu ne: «Yawut yi dañoo dige, ngir ñaan la, nga indi Pool ëllëg ca kanam kureelu àttekat ya, mel ni dañoo bëgga seet mbiram bu gëna wóor. ");
INSERT INTO wol2010_vpl VALUES ("AC23_21","074_23_21","ACT","23","21","21","Bu leen ko may, ndaxte lu ëpp ñeent fukk ci ñoom ñu ngi koy lalal fiir. Dige nañu ak ngiñ ne dootuñu lekk, dootuñu naan, li feek reyuñu ko; fi mu ne sax fagaru nañu, di xaar, nga nangu.» ");
INSERT INTO wol2010_vpl VALUES ("AC23_22","074_23_22","ACT","23","22","22","Kilifa ga nag sant waxambaane wa, mu bañ koo àgge kenn, ba noppi mu yiwi ko, mu dem. ");
INSERT INTO wol2010_vpl VALUES ("AC23_23","074_23_23","ACT","23","23","23","Bi mu ko defee mu woo ñaar ci njiiti xare ba ne leen: «Waajal-leen ñaar téeméeri xarekat ak juróom ñaar fukki gawar ak ñaar téeméeri nit ñu gànnaayoo xeej, ngeen dem Sesare ci juróom ñeenti waxtu ci guddi. ");
INSERT INTO wol2010_vpl VALUES ("AC23_24","074_23_24","ACT","23","24","24","Wutal-leen it Pool lu mu war, ngeen yóbbu ko ci jàmm ak salaam ba ca Feligsë, boroom réew mi.» ");
INSERT INTO wol2010_vpl VALUES ("AC23_25","074_23_25","ACT","23","25","25","Noonu mu bind bataaxal bii: ");
INSERT INTO wol2010_vpl VALUES ("AC23_26","074_23_26","ACT","23","26","26","Yaw Feligsë mu tedd mi, di boroom réew mi; man Këlódd Lisiyas maa ngi lay nuyu. ");
INSERT INTO wol2010_vpl VALUES ("AC23_27","074_23_27","ACT","23","27","27","Yawut yi jàpp nañu nit kii, bëgg koo rey, waaye bi ma yégee ne jaambur la ci Room, wallu naa ko ak ay xarekat, ba musal ko. ");
INSERT INTO wol2010_vpl VALUES ("AC23_28","074_23_28","ACT","23","28","28","Bëggoon naa xam lu tax ñu kalaame ko. Moo tax ma yóbbu ko ca kanam seen kureelu àttekat ya. ");
INSERT INTO wol2010_vpl VALUES ("AC23_29","074_23_29","ACT","23","29","29","Gis naa ne li ñu ko jiiñ mu ngi aju ci ay werantey seen yoon, waaye jiiñuñu ko dara lu jar dee mbaa jéng. ");
INSERT INTO wol2010_vpl VALUES ("AC23_30","074_23_30","ACT","23","30","30","Te bi ma déggee ne ñu ngi koy fexeel, yebal naa ko ci yaw ci saa si. Sant naa nag ñi ko kalaame, ñu xamal la seen lay. ");
INSERT INTO wol2010_vpl VALUES ("AC23_31","074_23_31","ACT","23","31","31","Noonu xarekat ya jël Pool ci guddi, indi ko ba ca dëkku Antipataris, ni ñu leen ko sante. ");
INSERT INTO wol2010_vpl VALUES ("AC23_32","074_23_32","ACT","23","32","32","Ca ëllëg sa ñu waññiku, délsi ca tata ja, bàyyi gawar ga, ñu gunge ko. ");
INSERT INTO wol2010_vpl VALUES ("AC23_33","074_23_33","ACT","23","33","33","Bi gawar ga àggee Sesare, ñu jox boroom réew ma bataaxal ba, jébbal ko Pool. ");
INSERT INTO wol2010_vpl VALUES ("AC23_34","074_23_34","ACT","23","34","34","Bi loolu amee boroom réew ma jàng bataaxal ba, laaj ci ban diiwaan la Pool dëkk. Bi mu yégee ne mu ngi dëkk Silisi, ");
INSERT INTO wol2010_vpl VALUES ("AC23_35","074_23_35","ACT","23","35","35","Mu ne ko: «Kon bu ñi la kalaame ñëwee, dinga layoo.» Mu santaane nag, ñu denc ko ca kër buur ba Erodd. ");
INSERT INTO wol2010_vpl VALUES ("AC24_1","074_24_1","ACT","24","1","1","Bi juróomi fan wéyee, Anañas sarxalkat bu mag ba dikk, ànd ak ay njiit ak layookat bu tudd Tertul, ñu woo Pool ci yoon fa kanam boroom réew ma. ");
INSERT INTO wol2010_vpl VALUES ("AC24_2","074_24_2","ACT","24","2","2","Noonu ñu woo Pool, te Tertul daldi ko jiiñ naan: «Yaw Feligsë mu tedd mi, sa nguur jural na nu jàmm ju neex, te sa jàppandil soppi na lu bare ci sunu xeet. ");
INSERT INTO wol2010_vpl VALUES ("AC24_3","074_24_3","ACT","24","3","3","Gis nanu ko fépp ak ci lépp, di la gërëm ak sunu xol bépp. ");
INSERT INTO wol2010_vpl VALUES ("AC24_4","074_24_4","ACT","24","4","4","Waaye ngir baña yàggal jataay bi, maa ngi lay ñaan ci sa lewetaay, nga déglu nu ci lu gàtt. ");
INSERT INTO wol2010_vpl VALUES ("AC24_5","074_24_5","ACT","24","5","5","Ndaxte ci mbirum nit kii teew, gis nanu ne rambaaj la, buy indi xëccoo ci Yawut yi ci àddina sépp, di njiitu mbooloo mu ñuy wax Nasareen. ");
INSERT INTO wol2010_vpl VALUES ("AC24_6","074_24_6","ACT","24","6","7","Dem na ba jéema teddadil sax kër Yàlla ga, waaye jàpp nanu ko. ");
INSERT INTO wol2010_vpl VALUES ("AC24_8","074_24_8","ACT","24","8","8","Soo ko laajee, yaw ci sa bopp, dinga gis ne li nu koy jiiñ dëgg la.» ");
INSERT INTO wol2010_vpl VALUES ("AC24_9","074_24_9","ACT","24","9","9","Ci kaw loolu Yawut ya ànd ca, di dëggal ne loolu wóor na. ");
INSERT INTO wol2010_vpl VALUES ("AC24_10","074_24_10","ACT","24","10","10","Bi loolu amee boroom réew ma jox Pool kàddu gi. Noonu mu làyyi ne: «Xam naa ne yaa ngi àtte xeet wi diirub at yu bare, moo tax maa ngi làyyi ak kóolute. ");
INSERT INTO wol2010_vpl VALUES ("AC24_11","074_24_11","ACT","24","11","11","Man ngaa wóorliku ne ëppagul fukki fan ak ñaar demoon naa Yerusalem ngir màggali. ");
INSERT INTO wol2010_vpl VALUES ("AC24_12","074_24_12","ACT","24","12","12","Te kenn gisu ma, maay werante mbaa di jógloo mbooloo, muy ca kër Yàlla ga mbaa ca jàngu ya mbaa ci biir dëkk ba. ");
INSERT INTO wol2010_vpl VALUES ("AC24_13","074_24_13","ACT","24","13","13","Te manuñoo firndeel dara ci li ñu may jiiñ léegi. ");
INSERT INTO wol2010_vpl VALUES ("AC24_14","074_24_14","ACT","24","14","14","Waaye nangu naa ci sa kanam ne maa ngi jaamu Yàllay sunuy maam, ci topp yoon wi ñu ne mooy tariixa; terewul ne lépp li ñu tëral ci yoonu Musaa ak li yonent yi bind, gëm naa ko. ");
INSERT INTO wol2010_vpl VALUES ("AC24_15","074_24_15","ACT","24","15","15","Te bokk naa ak ñoom yaakaar ci Yàlla, ne ñi jub ak ñi jubadi dinañu dekki keroog yawmelxayaam. ");
INSERT INTO wol2010_vpl VALUES ("AC24_16","074_24_16","ACT","24","16","16","Moo tax fu ma tollu, maa ngi góor-góorlu, ngir am xel mu dal fa kanam Yàlla ak fa kanam nit ñi. ");
INSERT INTO wol2010_vpl VALUES ("AC24_17","074_24_17","ACT","24","17","17","«Noonu gannaaw gëjeb at yu bare ñëw naa, ngir indil sama xeet ndimbal te jébbal Yàlla ay sarax. ");
INSERT INTO wol2010_vpl VALUES ("AC24_18","074_24_18","ACT","24","18","18","Bi ma koy def nag, gis nañu ma ca kër Yàlla ga, ma setlu ba noppi, fekk ànduma ak mbooloo te indiwuma benn coow. ");
INSERT INTO wol2010_vpl VALUES ("AC24_19","074_24_19","ACT","24","19","19","Waaye ay Yawut yu dëkk Asi —xanaa kay ñoo waroona ñëw ci sa kanam, di ma kalaame, bu ñu amee dara lu ñu may topp. ");
INSERT INTO wol2010_vpl VALUES ("AC24_20","074_24_20","ACT","24","20","20","Waaye it na nit ñii wax ci lan laa tooñe ci jataayu géewub àtte ba, ");
INSERT INTO wol2010_vpl VALUES ("AC24_21","074_24_21","ACT","24","21","21","xanaa li ma waxoon ca kaw ci seen biir rekk ne: “Mbirum ndekkitel ñi dee moo tax ngeen dëj ma ci seen kanam tey!”» ");
INSERT INTO wol2010_vpl VALUES ("AC24_22","074_24_22","ACT","24","22","22","Bi mu waxee noonu, Feligsë mi xam bu wóor mbirum yoon wi, yiwi leen ba beneen yoon. Mu ne leen: «Bu Lisiyas kilifag xare bi ñëwee, dinaa àtte seen mbir.» ");
INSERT INTO wol2010_vpl VALUES ("AC24_23","074_24_23","ACT","24","23","23","Noonu mu sant njiitu xare ba ne ko: «Nanga wottu Pool, waaye nga may ko féex, te bàyyi ay xaritam, ñu topptoo ko.» ");
INSERT INTO wol2010_vpl VALUES ("AC24_24","074_24_24","ACT","24","24","24","Bi ay fan wéyee, Feligsë ñëwaat, ànd ak soxnaam Dursil, miy Yawut. Noonu mu woolu Pool, di ko déglu ci mbirum gëm Yeesu Kirist. ");
INSERT INTO wol2010_vpl VALUES ("AC24_25","074_24_25","ACT","24","25","25","Waaye bi Pool di waxtaan ci mbirum njub ak moom sa bopp ak bés pénc, Feligsë daldi tiit, yiwi ko ne ko: «Demal, bu ma amee jot, dinaa la woolu.» ");
INSERT INTO wol2010_vpl VALUES ("AC24_26","074_24_26","ACT","24","26","26","Fekk yaakaaroon na it ne, Pool dina ko jox xaalis; kon mu di ko farala woolu, ngir waxtaan ak moom. ");
INSERT INTO wol2010_vpl VALUES ("AC24_27","074_24_27","ACT","24","27","27","Bi ñaari at weesoo nag, amoon na ku wuutu Feligsë, tudd Porsiyus Festus. Noonu Feligsë, mi bëggoon lu neex Yawut ya, bàyyi Pool ca kaso ba. ");
INSERT INTO wol2010_vpl VALUES ("AC25_1","074_25_1","ACT","25","1","1","Bi Festus teersee ci diiwaanam, mu teg ca ñetti fan, dem Yerusalem. ");
INSERT INTO wol2010_vpl VALUES ("AC25_2","074_25_2","ACT","25","2","2","Noonu sarxalkat yu mag ya ak njiiti Yawut ya kalaame Pool ci moom. ");
INSERT INTO wol2010_vpl VALUES ("AC25_3","074_25_3","ACT","25","3","3","Ñuy sàkku ndimbal ci moom, di ko ñaan bu wér, mu yónni Pool Yerusalem, fekk lal nañu fiiru rey ko ca yoon wa. ");
INSERT INTO wol2010_vpl VALUES ("AC25_4","074_25_4","ACT","25","4","4","Waaye Festus ne leen: «Ñu ngi wottu Pool ca Sesare, te dinaa fa dem fi ak fan yu néew.» ");
INSERT INTO wol2010_vpl VALUES ("AC25_5","074_25_5","ACT","25","5","5","Mu ne leen: «Ñi am maana ci yéen nag, nangeen ànd ak man, layooji ak nit ka, bu dee tooñ na.» ");
INSERT INTO wol2010_vpl VALUES ("AC25_6","074_25_6","ACT","25","6","6","Noonu Festus am fa ñoom juróom ñett ba fukki fan, ba noppi dem Sesare. Ca ëllëg sa mu toog ca àttekaay ba, joxe ndigal, ñu indi Pool. ");
INSERT INTO wol2010_vpl VALUES ("AC25_7","074_25_7","ACT","25","7","7","Bi mu ñëwee nag, Yawut ya jóge Yerusalem wër ko, di ko jiiñ tooñ yu bare te réy, te manuñu leena firndeel. ");
INSERT INTO wol2010_vpl VALUES ("AC25_8","074_25_8","ACT","25","8","8","Noonu Pool làyyi ne: «Tooñuma yoonu Yawut ya, tooñuma kër Yàlla ga, tooñuma buur ba Sesaar.» ");
INSERT INTO wol2010_vpl VALUES ("AC25_9","074_25_9","ACT","25","9","9","Ci kaw loolu Festus, mi bëgg lu neex Yawut ya, wax Pool ne: «Ndax bëgguloo dem Yerusalem, nga layoo fa ci mbir yii ci sama kanam?» ");
INSERT INTO wol2010_vpl VALUES ("AC25_10","074_25_10","ACT","25","10","10","Waaye Pool ne ko: «Maa ngi nii taxaw ci kanam àttekaayu buur Sesaar; te fii lañu ma wara àttee. Te yaw ci sa bopp xam nga bu baax ne tooñuma Yawut yi. ");
INSERT INTO wol2010_vpl VALUES ("AC25_11","074_25_11","ACT","25","11","11","Su ma tooñoon mbaa ma def lu bon lu jar dee, kon duma tinu ngir baña dee. Waaye bu li ñu may jiiñ taxawul, kenn sañu ma leena jébbal. Dénk naa sama mbir Sesaar.» ");
INSERT INTO wol2010_vpl VALUES ("AC25_12","074_25_12","ACT","25","12","12","Bi mu waxee loolu, Festus gise ak ñi ko wër, mu ne ko: «Dénk nga sa mbir Sesaar, kon ci moom ngay dem.» ");
INSERT INTO wol2010_vpl VALUES ("AC25_13","074_25_13","ACT","25","13","13","Ba ñu ca tegee ay fan, buur Agaripa ak Berenis ñëw Sesare, ngir nuyusi Festus. ");
INSERT INTO wol2010_vpl VALUES ("AC25_14","074_25_14","ACT","25","14","14","Bi seen ngan di ruus nag, Festus diis buur ba mbirum Pool ne ko: «Feligsë batale na nu ak kenn ku ñu tëj. ");
INSERT INTO wol2010_vpl VALUES ("AC25_15","074_25_15","ACT","25","15","15","Bi ma nekkee Yerusalem, sarxalkat yu mag ya ak njiiti Yawut ya kalaame nañu ko ci man, ñaan ma, ma daan ko. ");
INSERT INTO wol2010_vpl VALUES ("AC25_16","074_25_16","ACT","25","16","16","Waaye ma ne leen: “Jébbale nit, fekk jàkkaarloowul ak ñi koy jiiñ, ba mana làyyil boppam ci li ñu koy jiiñ, loolu dëppoowul ak aaday nguuru Room.” ");
INSERT INTO wol2010_vpl VALUES ("AC25_17","074_25_17","ACT","25","17","17","Bi ñu àndee ak man ba fii nag, randaluma mbir mi, waaye ca ëllëg sa sax toog naa ca àttekaay ba, joxe ndigal, ñu indi nit kooku. ");
INSERT INTO wol2010_vpl VALUES ("AC25_18","074_25_18","ACT","25","18","18","Ñi koy kalaame nag, bi ñu taxawee, jiiñuñu ko benn ñaawteef ci yi ma yaakaaroon, ");
INSERT INTO wol2010_vpl VALUES ("AC25_19","074_25_19","ACT","25","19","19","waaye ñuy werante rekk ak moom ci seen yoon ak ci mbirum ku tudd Yeesu, mi dee, te Pool sax ci ne mu ngi dund. ");
INSERT INTO wol2010_vpl VALUES ("AC25_20","074_25_20","ACT","25","20","20","Gannaaw lijjanti mbir moomu jafe woon na ma lool nag, ma laaj ko, ndax bëgg na dem Yerusalem, layooji fa ci mbir yooyu. ");
INSERT INTO wol2010_vpl VALUES ("AC25_21","074_25_21","ACT","25","21","21","Waaye Pool ñaan, nu fomm mbiram, ba kera buur bu tedd ba di ko àtte. Noonu santaane naa ñu aj ko, ba keroog ma koy yónnee Sesaar.» ");
INSERT INTO wol2010_vpl VALUES ("AC25_22","074_25_22","ACT","25","22","22","Booba nag Agaripa ne Festus: «Man sax bëgg naa dégg nit kooku.» Festus ne ko: «Bu ëllëgee dinga ko dégg.» ");
INSERT INTO wol2010_vpl VALUES ("AC25_23","074_25_23","ACT","25","23","23","Ca ëllëg sa nag Agaripa ak Berenis ñëw bu xumb, ñu dugg ca néegu àtte ba, ànd ak kilifay xare ba ak ña am maana ca dëkk ba. Noonu Festus joxe ndigal, ñu indi Pool. ");
INSERT INTO wol2010_vpl VALUES ("AC25_24","074_25_24","ACT","25","24","24","Bi mu ñëwee, Festus ne: «Buur Agaripa ak yéen ñépp, ñi fi teew tey, nit kaa ngi nii! Mbiram moo tax mbooloom Yawut yépp, muy ci Yerusalem, muy fii, wër ma di yuuxu ne: “Nit kii waratula dund.” ");
INSERT INTO wol2010_vpl VALUES ("AC25_25","074_25_25","ACT","25","25","25","Waaye gis naa ne deful dara lu jar dee. Moona, gannaaw moom ci boppam dénk na boppam buur bu tedd ba, fas naa yéene yónnee ko ko. ");
INSERT INTO wol2010_vpl VALUES ("AC25_26","074_25_26","ACT","25","26","26","Fekk awma dara lu wóor ci mbiram, lu ma mana bind sang bi. Moo tax ma indi ko ci seen kanam, rawatina ci sa kanam, buur Agaripa, ngir sunu jataay may ma lu ma bind. ");
INSERT INTO wol2010_vpl VALUES ("AC25_27","074_25_27","ACT","25","27","27","Ndaxte yaakaar naa ne yónnee ku ñu tëj, te bañ caa boole lu ko waral, àndul ak xel.» ");
INSERT INTO wol2010_vpl VALUES ("AC26_1","074_26_1","ACT","26","1","1","Bi mu ko waxee, Agaripa ne Pool: «Jëlal kàddu gi.» Noonu Pool tàllal loxoom, daldi làyyi ne: ");
INSERT INTO wol2010_vpl VALUES ("AC26_2","074_26_2","ACT","26","2","2","«Buur Agaripa, ma làyyi ci sa kanam tey ci lépp li ma Yawut yiy jiiñ, xol bu sedd la ci man, ");
INSERT INTO wol2010_vpl VALUES ("AC26_3","074_26_3","ACT","26","3","3","ndaxte xam nga bu baax aaday Yawut yi ak seeni werantey yoon. Kon maa ngi lay ñaan, nga déglu ma ak muñ. ");
INSERT INTO wol2010_vpl VALUES ("AC26_4","074_26_4","ACT","26","4","4","«Ci lu jëm ci Yawut yi, xam nañu sama dund li dale ci samag ndaw, muy ci sama biir xeet, muy ci Yerusalem. ");
INSERT INTO wol2010_vpl VALUES ("AC26_5","074_26_5","ACT","26","5","5","Xam nañu ma bu yàgg te man nañoo seede, su leen neexee, ne daan naa dund ni Farisen, te mooy tariixa bi gëna diis ci sunu diine. ");
INSERT INTO wol2010_vpl VALUES ("AC26_6","074_26_6","ACT","26","6","6","Li ma indi ci kureelu àttekat yii nag, mooy yaakaar ne Yàlla dina amal li mu digoon sunuy maam. ");
INSERT INTO wol2010_vpl VALUES ("AC26_7","074_26_7","ACT","26","7","7","Dige booba la fukki giir ak ñaar yu bànni Israyil di sàkku, ngir jot ko, ci jaamu Yàlla ak cawarte guddi ak bëccëg. Yaw buur, yaakaar joojoo tax ñu may kalaame, ñoom Yawut yi. ");
INSERT INTO wol2010_vpl VALUES ("AC26_8","074_26_8","ACT","26","8","8","Lu tax seen xel dàq ne Yàlla dina dekkal ñi dee? ");
INSERT INTO wol2010_vpl VALUES ("AC26_9","074_26_9","ACT","26","9","9","«Man sax ci sama bopp defe woon naa ne war naa def lu bare, ngir suufeel turu Yeesum Nasaret. ");
INSERT INTO wol2010_vpl VALUES ("AC26_10","074_26_10","ACT","26","10","10","Daan naa ko def ci Yerusalem, ba noppi ma jot sañ-sañ ci sarxalkat yu mag ya, bay tëj gaayi Yàlla yu bare. Rax-ca-dolli ku ñu ci masoona bëgga rey, ànd naa ci. ");
INSERT INTO wol2010_vpl VALUES ("AC26_11","074_26_11","ACT","26","11","11","Daan naa wër jàngoo jàngu, di leen teg toskare te di leen jéema weddiloo. Te sama mer daa na tar, ba ma di leen xañ ba ca dëkk yu sore, ngir fitnaal leen. ");
INSERT INTO wol2010_vpl VALUES ("AC26_12","074_26_12","ACT","26","12","12","«Noonu am bés, may dem dëkku Damaas, yor sañ-sañ ak ndigalu sarxalkat yu mag ya. ");
INSERT INTO wol2010_vpl VALUES ("AC26_13","074_26_13","ACT","26","13","13","Ca njolloor, buur bi, gis naa ca yoon wa leer gu jóge asamaan ne ràyy, ba raw leeru jant, melax ba ëmb ma, man ak ñi ma àndal. ");
INSERT INTO wol2010_vpl VALUES ("AC26_14","074_26_14","ACT","26","14","14","Nu ne nërëm ci suuf, ma dégg baat bu ma wax ci làkku yawut ne: “Sóol, Sóol, lu tax nga di ma fitnaal? Ngay bëre ak man ni fas wuy woŋŋeetu ku koy jam dëgël, metti na ci yaw.” ");
INSERT INTO wol2010_vpl VALUES ("AC26_15","074_26_15","ACT","26","15","15","«Noonu ma ne ko: “Yaa di kan, Boroom bi?” Boroom bi ne ma: “Maa di Yeesu, mi ngay fitnaal. ");
INSERT INTO wol2010_vpl VALUES ("AC26_16","074_26_16","ACT","26","16","16","Waaye jógal taxaw. Lii moo tax ma feeñu la: teg naa la yen, nga di ma seedeel ci lépp li nga gis ci man ak li ma lay feeñuji. ");
INSERT INTO wol2010_vpl VALUES ("AC26_17","074_26_17","ACT","26","17","17","Dinaa la musal ci bànni Israyil ak ci ñi dul Yawut. Ci ñoom laa lay yebal, ");
INSERT INTO wol2010_vpl VALUES ("AC26_18","074_26_18","ACT","26","18","18","ngir ubbi seeni bët, nga jële leen ci lëndëm, tàbbal leen ci leer, nga nangoo leen ci sañ-sañu Seytaane, waññi leen ci Yàlla, ma baal leen seeni bàkkaar te may leen cér ci biir sama gaa yi sell ci kaw ngëm.” ");
INSERT INTO wol2010_vpl VALUES ("AC26_19","074_26_19","ACT","26","19","19","«Kon nag buur Agaripa, woruma li ma Yàlla yen ci peeñu. ");
INSERT INTO wol2010_vpl VALUES ("AC26_20","074_26_20","ACT","26","20","20","Waaye li tàmbali ci Damaas, teg ci dëkku Yerusalem ak réewu Yawut mépp, ba agsi ci ñi dul Yawut, yégal naa leen, ñu tuub seeni bàkkaar te waññiku ci Yàlla, bay jëf lu dëppook réccu. ");
INSERT INTO wol2010_vpl VALUES ("AC26_21","074_26_21","ACT","26","21","21","Loolu nag moo waral Yawut yi jàpp ma ca kër Yàlla ga, di ma fexee rey. ");
INSERT INTO wol2010_vpl VALUES ("AC26_22","074_26_22","ACT","26","22","22","Waaye gannaaw Yàllaa ngi may taxawu ba tey, maa ngi taxaw fi, di ko seedeel ci mag ak ndaw; yokkuma dara ci li yonent yi ak Musaa xamle woon lu jiitu, ");
INSERT INTO wol2010_vpl VALUES ("AC26_23","074_26_23","ACT","26","23","23","maanaam Almasi bi dina dékku ay coono, te mooy jëkka dekki, bay jollil leer ci bànni Israyil ak ñi dul Yawut.» ");
INSERT INTO wol2010_vpl VALUES ("AC26_24","074_26_24","ACT","26","24","24","Bi muy làyyee nii, Festus daldi ko gëdd ak baat bu kawe ne ko: «Dangaa dof, Pool! Xanaa sa njàng mu réy mi da laa xañ sago.» ");
INSERT INTO wol2010_vpl VALUES ("AC26_25","074_26_25","ACT","26","25","25","Waaye Pool ne ko: «Festus mu tedd mi, dofuma; waaye lu dëggu laay wax te ànd ak sago. ");
INSERT INTO wol2010_vpl VALUES ("AC26_26","074_26_26","ACT","26","26","26","Yëf yii leer na buur bi, moo tax maa ngi koy wax ak kóolute. Wóor naa ne dara ci lii may wax umpu ko, ndaxte lii amewul ciy ruq. ");
INSERT INTO wol2010_vpl VALUES ("AC26_27","074_26_27","ACT","26","27","27","Yaw buur Agaripa, ndax gëmuloo yonent yi? Xam naa bu wér ne gëm nga.» ");
INSERT INTO wol2010_vpl VALUES ("AC26_28","074_26_28","ACT","26","28","28","Noonu Agaripa ne Pool: «Xanaa yaw, ci diir bu gàtt bii rekk, nga ma bëgga dugale ci gaayi Kirist!» ");
INSERT INTO wol2010_vpl VALUES ("AC26_29","074_26_29","ACT","26","29","29","Pool ne ko: «Muy tey, muy ëllëg, waxuma yaw rekk waaye it ñi may déglu tey ñépp, na Yàlla def, ba ngeen fekksi ma ci li ma nekk, lu moy jéng yii!» ");
INSERT INTO wol2010_vpl VALUES ("AC26_30","074_26_30","ACT","26","30","30","Ci kaw loolu buur ba daldi jóg, boroom réew ma topp ci, Berenis tegu ca ak mbooloo ma mépp. ");
INSERT INTO wol2010_vpl VALUES ("AC26_31","074_26_31","ACT","26","31","31","Bi ñu génnee nag, ñuy waxante ne: «Nit kii deful dara lu jar dee mbaa kaso.» ");
INSERT INTO wol2010_vpl VALUES ("AC26_32","074_26_32","ACT","26","32","32","Te Agaripa ne Festus: «Manoon nanu koo yiwi, bu dénkuloon mbiram Sesaar.» ");
INSERT INTO wol2010_vpl VALUES ("AC27_1","074_27_1","ACT","27","1","1","Bi loolu wéyee ñu fas yéene noo dugal gaal jëme réewu Itali. Noonu ñu jël Pool ak ñeneen ñi ñu tëjoon, dénk leen njiitu xare bu tudd Yulyus, mi bokk ci mbooloom xare mu buur. ");
INSERT INTO wol2010_vpl VALUES ("AC27_2","074_27_2","ACT","27","2","2","Nu dugg ca gaalu dëkku Adaramit guy taxaw ci teeruy Asi, daldi tàbbi ci biir géej; te Aristàrk, mi dëkk Tesalonig ci diiwaanu Maseduwan, ànd ak nun. ");
INSERT INTO wol2010_vpl VALUES ("AC27_3","074_27_3","ACT","27","3","3","Ca ëllëg sa nu teer Sidon; Yulyus laabiir ci Pool, may ko mu dem ci ay xaritam, ngir ñu ganale ko. ");
INSERT INTO wol2010_vpl VALUES ("AC27_4","074_27_4","ACT","27","4","4","Bi nu fa jógee, nu dem ci biir géej, leru dunu Sipar ci fegu ngelaw li, ndaxte ngelaw li da noo soflu. ");
INSERT INTO wol2010_vpl VALUES ("AC27_5","074_27_5","ACT","27","5","5","Nu jàll géej, gi janook diiwaani Silisi ak Pamfili, teersi Mira ca wàlli Lisi. ");
INSERT INTO wol2010_vpl VALUES ("AC27_6","074_27_6","ACT","27","6","6","Foofa nag njiit la gis gaal gu jóge Alegsàndiri, jëm Itali, mu dugal nu ca. ");
INSERT INTO wol2010_vpl VALUES ("AC27_7","074_27_7","ACT","27","7","7","Noonu nuy dem ndànk diirub fan yu bare, ba janook Kanidd ci kaw coono bu réy; te ndegam ngelaw li mayu nu, nu jëm kanam, nu leru dunu Keret ci fegu ngelaw li, janook Salmon. ");
INSERT INTO wol2010_vpl VALUES ("AC27_8","074_27_8","ACT","27","8","8","Nu romb fa ak coono yu bare, agsi ca bérab bu ñuy wax Teeru yu neex, te dend ak dëkku Lase. ");
INSERT INTO wol2010_vpl VALUES ("AC27_9","074_27_9","ACT","27","9","9","Fekk booba yàggoon nañu ca yoon wa, te dem ci géej daldi aaytal, ndaxte jamonoy Kooru Yawut ya wees na. Moo tax Pool digal leen ne: ");
INSERT INTO wol2010_vpl VALUES ("AC27_10","074_27_10","ACT","27","10","10","«Gaa ñi, gis naa ne tukki bi ëmb na musiba ak kasara ju bare, waxuma gaal gi ak li mu yeb waaye sunuy bakkan sax xaj na ci.» ");
INSERT INTO wol2010_vpl VALUES ("AC27_11","074_27_11","ACT","27","11","11","Waaye njiit la sobental waxi Pool, déggal dawalkat ba ak boroom gaal ga. ");
INSERT INTO wol2010_vpl VALUES ("AC27_12","074_27_12","ACT","27","12","12","Te gannaaw teeru ba neexula lollikoo, ña ca ëpp mànkoo ci jóge fa, dem ci biir géej, ngir wuta agsi Fenigsë, biy teerub dunu Keret te janook sowu suuf ak sowu kaw, nu lollikoo fa. ");
INSERT INTO wol2010_vpl VALUES ("AC27_13","074_27_13","ACT","27","13","13","Noonu bi ngelaw lu woyof liy jóge sudd wolee, ñu defe ne man nañoo sottal seen pexe, ñu wëgg diigal, daldi tafu ci dunu Keret. ");
INSERT INTO wol2010_vpl VALUES ("AC27_14","074_27_14","ACT","27","14","14","Waaye nees-tuut ngelaw lu wole penku, ñu di ko wax «Ërakilon», jóge ca dun ba, ne milib ci sunu kaw. ");
INSERT INTO wol2010_vpl VALUES ("AC27_15","074_27_15","ACT","27","15","15","Mu ëpp doole gaal ga, daldi ko wat, ba nu bayliku, daldi yal. ");
INSERT INTO wol2010_vpl VALUES ("AC27_16","074_27_16","ACT","27","16","16","Nu daldi daw, leru dun bu tuuti bu ñuy wax Kóda ci fegu ngelaw, rawale looco ga ci kaw gaal ga ak coono bu bare. ");
INSERT INTO wol2010_vpl VALUES ("AC27_17","074_27_17","ACT","27","17","17","Bi ñu ko yéegee, ñu fab ay buum, ngir laxas ca taatu gaal ga, ngir ragala daanu ci suuf su nooy su ñuy wax Sirt; ba noppi ñu daldi sànni diigal, ngir wàññi doxub gaal ga, nuy yale noonu. ");
INSERT INTO wol2010_vpl VALUES ("AC27_18","074_27_18","ACT","27","18","18","Waaye bi nu ngelaw li sonalee bu metti, ca ëllëg sa ñu sànni la gaal ga yeboon ca géej ga. ");
INSERT INTO wol2010_vpl VALUES ("AC27_19","074_27_19","ACT","27","19","19","Te ca ñetteelu fan ba, ñu sànni ak seeni loxo jumtukaay, yi ñu yeboon ngir fàggu. ");
INSERT INTO wol2010_vpl VALUES ("AC27_20","074_27_20","ACT","27","20","20","Noonu jant bi ne meŋŋ te biddiiw ne mes ay fan yu bare, fekk ba tey ngelaw li di wol ak doole, ba sunu yaakaaru mucc gépp tas. ");
INSERT INTO wol2010_vpl VALUES ("AC27_21","074_27_21","ACT","27","21","21","Bi loolu di xew, fekk gëj nañoo lekk, Pool daldi taxaw ci seen biir ne leen: «Gaa ñi, li gënoon mooy ngeen déglu ma te baña jóge Keret, ba indil seen bopp musiba ak kasara ju réy jii. ");
INSERT INTO wol2010_vpl VALUES ("AC27_22","074_27_22","ACT","27","22","22","Léegi nag maa ngi leen di dénk, ngeen takk seen fit, ndax gaal gi rekk mooy yàqu, waaye kenn ci yéen du dee. ");
INSERT INTO wol2010_vpl VALUES ("AC27_23","074_27_23","ACT","27","23","23","Ndaxte ci guddi menn malaaka dikkal na ma, jóge ci Yàlla sama Boroom, bi may jaamu. ");
INSERT INTO wol2010_vpl VALUES ("AC27_24","074_27_24","ACT","27","24","24","Mu ne ma: “Pool bul tiit; fàww nga taxaw ci kanam Sesaar, te yaa tax Yàllay aar bakkani ñi nga àndal ñépp.” ");
INSERT INTO wol2010_vpl VALUES ("AC27_25","074_27_25","ACT","27","25","25","Moo tax, gaa ñi, takkleen seen fit, ndax wóolu naa Yàlla ne li mu ma wax dina am. ");
INSERT INTO wol2010_vpl VALUES ("AC27_26","074_27_26","ACT","27","26","26","Waaye war nanoo luf cib dun.» ");
INSERT INTO wol2010_vpl VALUES ("AC27_27","074_27_27","ACT","27","27","27","Ca fukkeelu guddi ga ak ñeent nu nga doon jayaŋ-jayaŋi ca géeju Adiratig; noonu ca xaaju guddi dawalkati gaal ga defe ne danu jegesi suuf. ");
INSERT INTO wol2010_vpl VALUES ("AC27_28","074_27_28","ACT","27","28","28","Ñu sànni nattukaay ba ci biir géej, mu jàpp ñeent fukki meetar, dem ca kanam tuuti, sànniwaat ko, jàpp fanweeri meetar. ");
INSERT INTO wol2010_vpl VALUES ("AC27_29","074_27_29","ACT","27","29","29","Ñu ragal ne dinañu fenqu ci ay xeer, kon ñu daldi sànni ñeenti diigal ci geenu gaal ga, di ñaan bët set. ");
INSERT INTO wol2010_vpl VALUES ("AC27_30","074_27_30","ACT","27","30","30","Waaye ci kaw loolu dawalkati gaal ga taafantaloo ne dañuy sànniji ay diigal ca boppu gaal ga, fekk dañuy fexee jël looco ga, ba raw. ");
INSERT INTO wol2010_vpl VALUES ("AC27_31","074_27_31","ACT","27","31","31","Waaye Pool ne njiit la ak xarekat ya: «Bu ñii desul ci gaal gi, dungeen raw.» ");
INSERT INTO wol2010_vpl VALUES ("AC27_32","074_27_32","ACT","27","32","32","Noonu xarekat ya dagg buum, yay téye looco ga, bàyyi ko mu wéy. ");
INSERT INTO wol2010_vpl VALUES ("AC27_33","074_27_33","ACT","27","33","33","Bi bët setagul, Pool sant leen ñu lekk; mu ne leen: «Tey mooy seen fukki fan ak ñeent yu ngeen ne jonn, lekkuleen, mosuleen dara. ");
INSERT INTO wol2010_vpl VALUES ("AC27_34","074_27_34","ACT","27","34","34","Maa ngi leen di sant nag, ngeen lekk, ndax noonu rekk ngeen mana rawe. Ndax genn kawar du rot ci yéen.» ");
INSERT INTO wol2010_vpl VALUES ("AC27_35","074_27_35","ACT","27","35","35","Bi mu waxee loolu, mu fab mburu, sant Yàlla ci kanam ñépp, damm ko, daldi ko lekk. ");
INSERT INTO wol2010_vpl VALUES ("AC27_36","074_27_36","ACT","27","36","36","Bi ñu gisee loolu, ñépp dëgëraat, ñu daldi lekk ñoom itam. ");
INSERT INTO wol2010_vpl VALUES ("AC27_37","074_27_37","ACT","27","37","37","Mboolem ñi nekkoon ca gaal ga mat na ñaar téeméeri nit ak juróom ñaar fukk ak juróom benn. ");
INSERT INTO wol2010_vpl VALUES ("AC27_38","074_27_38","ACT","27","38","38","Noonu ñu lekk ba suur, daldi sànni pepp ma ca géej ga, ngir woyofal gaal ga. ");
INSERT INTO wol2010_vpl VALUES ("AC27_39","074_27_39","ACT","27","39","39","Bi bët setee nag, xàmmiwuñu réew ma, waaye séen nañu ruqu tefes. Noonu ñu fas yéene caa teeral gaal ga, bu ñu ko manee. ");
INSERT INTO wol2010_vpl VALUES ("AC27_40","074_27_40","ACT","27","40","40","Ñu dagg diigal ya, bàyyi leen ci biir géej, yiwiwaale baar ba; ba noppi firi wiiru kanam ga, jublu ca tefes ga. ");
INSERT INTO wol2010_vpl VALUES ("AC27_41","074_27_41","ACT","27","41","41","Waaye ñu dal ca tundu suuf ca bérab bu ñaari koroŋ daje, gaal ga daldi fa luf. Boppu gaal ga nuur bu baax, ne fa tekk, te dooley duus ya daldi toj geen ba. ");
INSERT INTO wol2010_vpl VALUES ("AC27_42","074_27_42","ACT","27","42","42","Bi loolu amee xarekat ya bëgga rey ñi ñu tëj, ngir ragal ñenn ñi féey, ba raw. ");
INSERT INTO wol2010_vpl VALUES ("AC27_43","074_27_43","ACT","27","43","43","Waaye njiit la bëgga musal Pool, mu tere leen pexe ma. Mu sant ñi mana féey, ñu jëkka sóobu ca ndox ma, ba jot tefes ga. ");
INSERT INTO wol2010_vpl VALUES ("AC27_44","074_27_44","ACT","27","44","44","Mu sant ñi ci des ñu def noonu, langaamu ci ay dénk, mbaa ca tojiti gaal ga. Noonu ñépp jot tefes ga ci jàmm ak salaam. ");
INSERT INTO wol2010_vpl VALUES ("AC28_1","074_28_1","ACT","28","1","1","Bi nu rëccee, nu yég ne dun baa nga tudd Màlt. ");
INSERT INTO wol2010_vpl VALUES ("AC28_2","074_28_2","ACT","28","2","2","Te waa réew ma won nu laabiir gu ràññiku, ndaxte taalal nañu nu sawara, ganale nu ndax taw bi sóob ak sedd bi. ");
INSERT INTO wol2010_vpl VALUES ("AC28_3","074_28_3","ACT","28","3","3","Pool nag di for matt, di ko def ca taal ba, jaan ne ca mëlle ndax tàngoor wa, taq ci loxoom. ");
INSERT INTO wol2010_vpl VALUES ("AC28_4","074_28_4","ACT","28","4","4","Bi waa réew ma gisee rab wa wékku ci loxoom nag, ñuy waxante naan: «Ci lu wóor nit kii reykat la; te bi mu rëccee ca géej ga sax, ndogalu Yàlla mayu ko mu dund.» ");
INSERT INTO wol2010_vpl VALUES ("AC28_5","074_28_5","ACT","28","5","5","Waaye Pool yëlëb rab wa ca sawara sa, te wàññiwu ko dara. ");
INSERT INTO wol2010_vpl VALUES ("AC28_6","074_28_6","ACT","28","6","6","Nit ñi di xaar mu newi, mbaa mu ne dàll, dee; waaye bi ñu négee lu yàgg te gis ne dara jotu ko, ñu soppi xel ne: «Kii yàlla la.» ");
INSERT INTO wol2010_vpl VALUES ("AC28_7","074_28_7","ACT","28","7","7","Amoon na nag ca wet ya ay suuf yu doon moomeelu ku tudd Publiyus, di kilifag dun ba. Mu teeru nu, ganale nu ngan gu réy diirub ñetti fan. ");
INSERT INTO wol2010_vpl VALUES ("AC28_8","074_28_8","ACT","28","8","8","Fekk baayu Publiyus dafa tëdd ndax ay tàngoori yaram yu koy dikkal ak biiru taññ. Pool nag dem seeti ko, ñaan ci Yàlla, teg ko ay loxoom, mu daldi wér. ");
INSERT INTO wol2010_vpl VALUES ("AC28_9","074_28_9","ACT","28","9","9","Ci kaw loolu jarag ya ca des ca dun ba daldi dikk, amaat wér-gi-yaram. ");
INSERT INTO wol2010_vpl VALUES ("AC28_10","074_28_10","ACT","28","10","10","Ñu teral nu ci fànn yu bare, te bi nuy dem, ñu jox nu li nuy soxla lépp. ");
INSERT INTO wol2010_vpl VALUES ("AC28_11","074_28_11","ACT","28","11","11","Bi nu fa amee ñetti weer, nu dugg ca gaal gu lollikoo ca dun ba, daldi tàbbi ca géej ga. Gaalu dëkku Alegsàndiri la woon, te yor xàmmikaay guy nataalu Kastor ak Polugsë. ");
INSERT INTO wol2010_vpl VALUES ("AC28_12","074_28_12","ACT","28","12","12","Noonu nu teer dëkku Sirakus, toog fa ñetti fan. ");
INSERT INTO wol2010_vpl VALUES ("AC28_13","074_28_13","ACT","28","13","13","Nu jóge fa, leru tefes ga, ba agsi Resiyo. Ca ëllëg sa ngelawu sudd daldi jóg, te ca ñaareelu fan ba nu teer Pusol. ");
INSERT INTO wol2010_vpl VALUES ("AC28_14","074_28_14","ACT","28","14","14","Gis nanu fa ay bokk, ñu ñaan nu, nu toog fa ayu-bés. Noonu nu dem Room. ");
INSERT INTO wol2010_vpl VALUES ("AC28_15","074_28_15","ACT","28","15","15","Sunuy xibaar law na, ba egg ca bokk ya fa dëkk, noonu ñu gatandu nu ba ca péncu Apiyus ak bérab bu ñuy wax Ñetti añukaay ya. Bi leen Pool gisee, mu sant Yàlla, daldi takk fitam. ");
INSERT INTO wol2010_vpl VALUES ("AC28_16","074_28_16","ACT","28","16","16","Bi nu dikkee Room nag, ñu may Pool, mu dëkk fa ko lew, moom ak xarekat ba koy wottu. ");
INSERT INTO wol2010_vpl VALUES ("AC28_17","074_28_17","ACT","28","17","17","Bi ñetti fan wéyee, mu woolu njiiti Yawuti dëkk ba. Bi ñu dajaloo nag, mu wax leen lii: «Bokk yi, jàpp nañu ma ci Yerusalem, jébbal ma waa Room, fekk defuma dara luy suufeel sunu xeet, mbaa lu juuyoo ak sunuy aaday maam. ");
INSERT INTO wol2010_vpl VALUES ("AC28_18","074_28_18","ACT","28","18","18","Waa Room nag seet sama mbir, te bëgg maa bàyyi, ndaxte toppuñu ma dara lu jar dee. ");
INSERT INTO wol2010_vpl VALUES ("AC28_19","074_28_19","ACT","28","19","19","Waaye bi ko Yawut ya bañee, fas yéene naa dénk sama mbir Sesaar, fekk ba tey awma dara lu may taqal sama xeet. ");
INSERT INTO wol2010_vpl VALUES ("AC28_20","074_28_20","ACT","28","20","20","Moo tax ma ñaana gise ak yéen, nu diisoo, ndaxte yaakaaru bànni Israyil moo tax ñu jéng ma.» ");
INSERT INTO wol2010_vpl VALUES ("AC28_21","074_28_21","ACT","28","21","21","Bi ñu ko déggee, ñu ne ko: «Jotunu benn bataaxal bu jóge Yude ci sa mbir, te kenn ci bokk, yi fi dikk, jottaliwul mbaa mu seede ci yaw lu bon. ");
INSERT INTO wol2010_vpl VALUES ("AC28_22","074_28_22","ACT","28","22","22","Waaye bëgg nanoo dégg li nga gëm, ndaxte xam nanu ne, tariixa booba, kenn jubluwu ko fenn.» ");
INSERT INTO wol2010_vpl VALUES ("AC28_23","074_28_23","ACT","28","23","23","Noonu ñu jox ko bés, te ñu bare ñëw, fekksi ko ca néegam. Mu di leen jàngal suba ba ngoon, di leen dëggal lu jëm ci nguuru Yàlla ak ci Yeesu, tukkee ci yoonu Musaa ak ci yonent yi, di leen jéema gëmloo. ");
INSERT INTO wol2010_vpl VALUES ("AC28_24","074_28_24","ACT","28","24","24","Ñenn ñi nag gëm li mu wax, ña ca des weddi ko. ");
INSERT INTO wol2010_vpl VALUES ("AC28_25","074_28_25","ACT","28","25","25","Gannaaw manuñoo déggoo, ñu bëgga tas. Waaye bi ñuy laata dem, Pool teg ca wax jii: «Xel mu Sell mi wax na seeni maam dëgg jaarale ko ci yonent Yàlla Esayi. ");
INSERT INTO wol2010_vpl VALUES ("AC28_26","074_28_26","ACT","28","26","26","Nee na: “Demal ci xeet wii ne leen: ‘Dingeen déglu bu baax waaye dungeen xam dara; di xool bu baax waaye dungeen gis dara.’ ");
INSERT INTO wol2010_vpl VALUES ("AC28_27","074_28_27","ACT","28","27","27","Ndaxte xolu xeet wii dafa dërkiis; dañuy déglu ak nopp yu naqari, tey gëmm seeni bët, ngir baña gis ak seeni bët, dégg ak seeni nopp, te xam ci seen xol, ñu waññiku ci man, ma wéral leen.” ");
INSERT INTO wol2010_vpl VALUES ("AC28_28","074_28_28","ACT","28","28","29","«Xamleen nag ne xibaaru mucc gii yégal nañu ko ñi dul Yawut, te ñoom dinañu ko déglu.» ");
INSERT INTO wol2010_vpl VALUES ("AC28_30","074_28_30","ACT","28","30","30","Noonu diirub ñaari at Pool dëkk ca kër gu muy fey, di fa àggale ñépp ñi koy seetsi. ");
INSERT INTO wol2010_vpl VALUES ("AC28_31","074_28_31","ACT","28","31","31","Muy yégle nguuru Yàlla, di jàngle ci mbirum Boroom bi Yeesu Kirist ak fit wu dëgër, te kenn terewu ko ko. ");
INSERT INTO wol2010_vpl VALUES ("RM1_1","075_1_1","ROM","1","1","1","Man Pool, jaamub Kirist Yeesu, maa leen di bind bataaxal bii. Yàlla woo na ma, ma nekk ndawam, sas ma liggéeyu xamle xibaaru jàmmam bi. ");
INSERT INTO wol2010_vpl VALUES ("RM1_2","075_1_2","ROM","1","2","2","Xibaaru jàmm boobu, Yàlla dige woon na ko bu yàgg, jaarale ko ciy yonentam, ñu def ko ci Mbind mu sell mi, ");
INSERT INTO wol2010_vpl VALUES ("RM1_3","075_1_3","ROM","1","3","4","di xamle mbirum Doomam, Yeesu Kirist sunu Boroom. Lu jëm ci meloom ci àddina, ci askanu Daawuda la jóge, waaye lu jëm ci xelam mu sell, Doomu Yàlla la; ndaxte ndekkiteem nekk na firnde ju ràññiku, ne moom la. ");
INSERT INTO wol2010_vpl VALUES ("RM1_5","075_1_5","ROM","1","5","5","Te moom Kirist tàbbal na nu ci yiwu Yàlla, def nu ay ndawam, yónni nu ci biir xeeti àddina sépp, ngir ñu gëm ko te jébbalu, ba màggal turam. ");
INSERT INTO wol2010_vpl VALUES ("RM1_6","075_1_6","ROM","1","6","6","Te ci ngeen bokk, yéen ñi Yàlla woo, ngeen nekk ci Kirist. ");
INSERT INTO wol2010_vpl VALUES ("RM1_7","075_1_7","ROM","1","7","7","Yéen ñi dëkk Room ñépp, yéen ñi Yàlla bëgg te woo leen, ngeen nekk gaayam yu sell, na leen Yàlla sunu Baay ak Boroom bi Yeesu Kirist may yiw ak jàmm. ");
INSERT INTO wol2010_vpl VALUES ("RM1_8","075_1_8","ROM","1","8","8","Kon nag li may jëkka wax mooy lii: sant naa Yàlla sama Boroom, jaarale ko ci Yeesu Kirist, ngir yéen ñépp, ndaxte seen ngëm siiw na ci àddina sépp. ");
INSERT INTO wol2010_vpl VALUES ("RM1_9","075_1_9","ROM","1","9","9","Bët bu set maa ngi leen di boole ci samay ñaan. Yàlla seede na li may wax, Yàlla mi may jaamu ci sama xel, ci xamle xibaaru jàmm bu Doomam. ");
INSERT INTO wol2010_vpl VALUES ("RM1_10","075_1_10","ROM","1","10","10","Te li ma koy faral di ñaan mooy lii: bu soobee Yàlla, na ma ubbil bunt, ba ma mana ñëw ci yéen. ");
INSERT INTO wol2010_vpl VALUES ("RM1_11","075_1_11","ROM","1","11","11","Ndaxte bëgg naa leena gis lool, ba indil leen barke bu jóge ci Xel mu Sell mi, ndax seen ngëm gëna dëgër. ");
INSERT INTO wol2010_vpl VALUES ("RM1_12","075_1_12","ROM","1","12","12","Maanaam ma nekk ci seen biir, te nu dimbaleente ci sunu ngëm, ndax man itam ma gëna am doole. ");
INSERT INTO wol2010_vpl VALUES ("RM1_13","075_1_13","ROM","1","13","13","Bokk yi, damaa bëgg ngeen xam ne xalaat naa leena seetsi ay yooni yoon, ngir meññ njariñ ci yéen, ni ma ko defe ci yeneen xeet yi, waaye ay téq-téq ñoo ma téye ba léegi. ");
INSERT INTO wol2010_vpl VALUES ("RM1_14","075_1_14","ROM","1","14","14","Am naa warugar sama diggante ak ñépp, muy ñi jàng ni Gereg yi, muy ñi jàngul ni Baarbaar yi, ñi bare xam-xam ak ñi barewul xam-xam. ");
INSERT INTO wol2010_vpl VALUES ("RM1_15","075_1_15","ROM","1","15","15","Li aju ci man nag, jekk naa ngir ñëw, xamal leen xibaaru jàmm bi, yéen it waa Room. ");
INSERT INTO wol2010_vpl VALUES ("RM1_16","075_1_16","ROM","1","16","16","Ndaxte awma benn werante ci xibaaru jàmm bi may waare, ndax mbirum Yàlla la, mu làmboo dooleem, ngir musal képp ku ko gëm, muy Yawut ci bu jëkk mbaa ki dul Yawut. ");
INSERT INTO wol2010_vpl VALUES ("RM1_17","075_1_17","ROM","1","17","17","Ndaxte xibaar bii day wone, ni nit mana jube ci kanam Yàlla, sukkandikoo ci ngëm rekk, tàmbali ci ngëm, yem ci ngëm. Moo tax Mbind mi wax ne: «Ku jub ci kaw ngëm, dinga dund.» ");
INSERT INTO wol2010_vpl VALUES ("RM1_18","075_1_18","ROM","1","18","18","Merum Yàllaa ngi feeñe asamaan, wàcc ci nit ñi, ndax seen weddi Yàlla gépp ak seen jubadi gépp, ñoom ñi suul dëgg, di topp lu jubadi. ");
INSERT INTO wol2010_vpl VALUES ("RM1_19","075_1_19","ROM","1","19","19","Ndax li nit mana xam ci Yàlla, leer na ci seen xel, ndax Yàlla won na leen ko. ");
INSERT INTO wol2010_vpl VALUES ("RM1_20","075_1_20","ROM","1","20","20","Ndaxte ba àddina sosoo ba tey, mbiri Yàlla yu nëbbu ya, maanaam dooleem ju sax ja, ak meloom wu kawe wa, feeñ nañu bu leer, te bir ñépp ci yi mu sàkk, ba tax bunti lay yépp tëj nañu. ");
INSERT INTO wol2010_vpl VALUES ("RM1_21","075_1_21","ROM","1","21","21","Ndaxte bi ñu xamee Yàlla, taxul ñu màggal ko ni mu ware, mbaa ñu sant ko. Waaye ñu daldi réer ci seen biiri xalaat yu mujjul fenn, ba tax seen xol gumba, ba lëndëm këruus. ");
INSERT INTO wol2010_vpl VALUES ("RM1_22","075_1_22","ROM","1","22","22","Ñu teg seen bopp ni boroomi xel, fekk ñu ñàkk xel lañu woon. ");
INSERT INTO wol2010_vpl VALUES ("RM1_23","075_1_23","ROM","1","23","23","Toxal nañu ndamu Yàlla Aji Sax ji, wuutal fa nataali nit ku dul sax, moom ak ay picc, ay rabi àll mbaa yuy raam. ");
INSERT INTO wol2010_vpl VALUES ("RM1_24","075_1_24","ROM","1","24","24","Moo tax Yàlla bërgël na leen ci seeni bëgg-bëgg, ñu sóobu ciy ñaawteef, di jëflante lu gàccelu ci seeni cér. ");
INSERT INTO wol2010_vpl VALUES ("RM1_25","075_1_25","ROM","1","25","25","Toxal nañu dëggu Yàlla, tëral fen, di màggal ak a jaamu mbindeef, ba faaleetuñu sax Aji Bind, ji yelloo cant ba fàww. Amiin. ");
INSERT INTO wol2010_vpl VALUES ("RM1_26","075_1_26","ROM","1","26","26","Loolu moo tax nag Yàlla bërgël na leen ci seeni bëgg-bëgg yu ruslu. Seeni jigéen sax dëddu nañu li jekk, sóobu ci lu jekkadi, ñoom ak seeni moroom. ");
INSERT INTO wol2010_vpl VALUES ("RM1_27","075_1_27","ROM","1","27","27","Noonu it góor ñi bàyyi nañu li jekk ci seeni cér, maanaam ànd ak jigéen, bay am ay bëgg-bëgg yu tar ci ànd ak seeni moroom. Góor di defante ak góor li warul, ñu di jot seen peyu réer ci seeni yaram. ");
INSERT INTO wol2010_vpl VALUES ("RM1_28","075_1_28","ROM","1","28","28","Gannaaw xam Yàlla soxalu leen, Yàlla it bërgël na leen ci seen xel mu bon moomu, ñu sax ci jëf yu jekkadi. ");
INSERT INTO wol2010_vpl VALUES ("RM1_29","075_1_29","ROM","1","29","29","Seen xol fees na ak lu jubadi, lu bon, bëgge ak coxor; duñu xalaat lu dul kiñaan, bóome, xuloo, njublaŋ ak ñaaw njort; dañuy jëw, ");
INSERT INTO wol2010_vpl VALUES ("RM1_30","075_1_30","ROM","1","30","30","di yàq der, di ñu bañ Yàlla te ñàkk sutura, di réy-réylu ak a kañu; ay jàmbaar lañu ci fexe lu bon, di bañ seeni waajur. ");
INSERT INTO wol2010_vpl VALUES ("RM1_31","075_1_31","ROM","1","31","31","Amuñu xel, amuñu kóllëre, amuñu cofeel, amuñu yërmande. ");
INSERT INTO wol2010_vpl VALUES ("RM1_32","075_1_32","ROM","1","32","32","Xam nañu ne ñiy jëfe loolu, Yàlla daganal na seen dee, waaye teewul ñu di ko def, boole ko ak di farle ñi ci sax. ");
INSERT INTO wol2010_vpl VALUES ("RM2_1","075_2_1","ROM","2","1","1","Kon nag képp ku mu mana doon, yaw miy àtte sa moroom ak ñaaw njort, amuloo aw lay, ndaxte àtte sa moroom, daan sa bopp la; yaa ngi koy àtte ndax ay jëfam, fekk yaw itam noonu ngay jëfe. ");
INSERT INTO wol2010_vpl VALUES ("RM2_2","075_2_2","ROM","2","2","2","Xam nanu ne ñiy jëfe noonu, Yàlla dina leen àtte, te àtteem jub na. ");
INSERT INTO wol2010_vpl VALUES ("RM2_3","075_2_3","ROM","2","3","3","Yaw nag miy àtte ñiy def loolu, te di ko def, ndax defe nga ne dinga rëcc ci àtteb Yàlla? ");
INSERT INTO wol2010_vpl VALUES ("RM2_4","075_2_4","ROM","2","4","4","Ndax dangaa xeeb mbaaxu Yàlla, mi yéexa mer te di la muñal? Xanaa xamuloo ne Yàllaa ngi lay won baaxaayam, ngir nga réccu say bàkkaar? ");
INSERT INTO wol2010_vpl VALUES ("RM2_5","075_2_5","ROM","2","5","5","Waaye ndegam dëgër nga bopp te bëgguloo réccu, yaa ngi dajale merum Yàlla ci sa bopp. Ndaxte Yàlla sàkk na bés bu muy wone àtteem bu jub bi te meram wàcc ci ñi bon; ");
INSERT INTO wol2010_vpl VALUES ("RM2_6","075_2_6","ROM","2","6","6","bés booba dina delloo ku nekk ay jëfam. ");
INSERT INTO wol2010_vpl VALUES ("RM2_7","075_2_7","ROM","2","7","7","Ñiy góor-góorlu ciy def lu baax, bëgg Yàlla boole leen ca ndamam te sédde leen ngërëm ak dund gu sax, dina leen tàbbal ci dund gu dul jeex. ");
INSERT INTO wol2010_vpl VALUES ("RM2_8","075_2_8","ROM","2","8","8","Waaye ñi dëgër bopp, ba tanqamlu dëgg, di topp lu jubadi, seen pey mooy dooni merum Yàlla ak toroxte. ");
INSERT INTO wol2010_vpl VALUES ("RM2_9","075_2_9","ROM","2","9","9","Ki doon def lu bon, peyam mooy tiis ak metit wu tar, muy Yawut ci bu jëkk, mbaa ki dul Yawut. ");
INSERT INTO wol2010_vpl VALUES ("RM2_10","075_2_10","ROM","2","10","10","Waaye ki doon def lu baax, añam mooy bokk ci ndamu Yàlla, am ngërëm ak jàmm, muy Yawut ci bu jëkk, mbaa ki dul Yawut. ");
INSERT INTO wol2010_vpl VALUES ("RM2_11","075_2_11","ROM","2","11","11","Ndaxte ñépp a yem fa kanam Yàlla. ");
INSERT INTO wol2010_vpl VALUES ("RM2_12","075_2_12","ROM","2","12","12","Képp ku doon bàkkaar nag te nekkuloo woon ci yoonu Musaa, Yàlla dina la àtte ci lu dul yoonu Musaa, nga doora sànku. Te képp ku doon bàkkaar te nga nekkoon ci yoonu Musaa, Yàlla dina la àtte ci yoon woowu. ");
INSERT INTO wol2010_vpl VALUES ("RM2_13","075_2_13","ROM","2","13","13","Kon déglu yoonu Musaa rekk doyul; du loolu mooy tax nit jub ci kanam Yàlla; kiy sàmm yoon wi, moom la Yàlla di àtte ni ku jub. ");
INSERT INTO wol2010_vpl VALUES ("RM2_14","075_2_14","ROM","2","14","14","Ndax ñi dul Yawut te nekkuñu ci yoonu Musaa, ñu ngiy def li yoon woowu tëral, ndaxte Yàlla def na ko ci nit. Te wonee nañu noonu ne man nañoo ràññee lu baax ak lu bon, su ñu nekkul sax ci yoonu Musaa, ");
INSERT INTO wol2010_vpl VALUES ("RM2_15","075_2_15","ROM","2","15","15","di wone it ne Yàlla bind na ci seen xol jëf yi yoonu Musaa santaane. Seen xel it seede na ne noonu la, fekk seeni xalaat ñoo leen di tuumaal, mbaa ñu leen di jéggal. ");
INSERT INTO wol2010_vpl VALUES ("RM2_16","075_2_16","ROM","2","16","16","Ndax bés dina ñëw, bu xalaat yu làqu yi di feeñ, te Yàlla àtte nit ñi jaarale ko ci Yeesu Kirist. Xibaaru jàmm, bi may waare, moo ko wax. ");
INSERT INTO wol2010_vpl VALUES ("RM2_17","075_2_17","ROM","2","17","17","Maa ngi ñëw nag ci yaw mi ne Yawut nga; yaa ngi sukkandiku ci yoonu Musaa ak di damu ci Yàlla. ");
INSERT INTO wol2010_vpl VALUES ("RM2_18","075_2_18","ROM","2","18","18","Xam nga coobareem, ndaxte jàng nga ci yoonu Musaa, ba fonk yëf yi gëna baax. ");
INSERT INTO wol2010_vpl VALUES ("RM2_19","075_2_19","ROM","2","19","19","Yaa ngi teg sa bopp wommatkatu gumba yi ak leeru ñi nekk cig lëndëm. ");
INSERT INTO wol2010_vpl VALUES ("RM2_20","075_2_20","ROM","2","20","20","Yaa di jànglekatu ñi jàngul ak xamlekatu ñi xamul, ndaxte xalaat nga ne Yàlla jagleel na leen ci yoonu Musaa bépp xam-xam ak gépp dëgg. ");
INSERT INTO wol2010_vpl VALUES ("RM2_21","075_2_21","ROM","2","21","21","Kon nag yaw miy jàngal say moroom, xanaa doo jàngal sa bopp? Yaw miy waare di tere sàcc, mbaa doo sàcc yaw itam? Yaw miy tere njaaloo, mbaa doo njaaloo? ");
INSERT INTO wol2010_vpl VALUES ("RM2_22","075_2_22","ROM","2","22","22","Yaw miy araamal xërëm yi, mbaa doo sàcc li nekk ci seeni xàmb? ");
INSERT INTO wol2010_vpl VALUES ("RM2_23","075_2_23","ROM","2","23","23","Yaw miy damoo yoonu Musaa, mbaa doo ko moy, ba indi gàcce ci turu Yàlla? ");
INSERT INTO wol2010_vpl VALUES ("RM2_24","075_2_24","ROM","2","24","24","Moo tax Mbind mi ne: «Yéena tax ñi nekkul Yawut di suufeel turu Yàlla.» ");
INSERT INTO wol2010_vpl VALUES ("RM2_25","075_2_25","ROM","2","25","25","Bëggoon naa ngeen xam ne xaraf am na njariñ, boo ca boolee sàmm yoon. Waaye boo ko ca boolewul, sa xaraf amatul njariñ. ");
INSERT INTO wol2010_vpl VALUES ("RM2_26","075_2_26","ROM","2","26","26","Te itam ku xaraful, tey def jëf yu jub yi yoonu Musaa santaane, ndax Yàlla du ko teg ni ku xaraf? ");
INSERT INTO wol2010_vpl VALUES ("RM2_27","075_2_27","ROM","2","27","27","Ku dul Yawut te xaraful waaye di sàmm yoon wi, kooku dina la mana àtte, yaw Yawut bi. Ndaxte li ngay xam xam yoonu Musaa ci Mbind mi te xaraf, terewul nga koy moy. ");
INSERT INTO wol2010_vpl VALUES ("RM2_28","075_2_28","ROM","2","28","28","Juddu nekk Yawut taxul sag Yawut dëggu, te xaraf ci saw yaram taxul sa xaraf wóor. ");
INSERT INTO wol2010_vpl VALUES ("RM2_29","075_2_29","ROM","2","29","29","Waaye Yawut dëgg, ci xol lay nekk. Te xaraf dëgg itam, ci xol lay nekk. Du ngistal, lu dëggu la. Te képp ku mel noonu, dees na la gërëm, waxuma la nit ñi, waaye Yàlla ci boppam. ");
INSERT INTO wol2010_vpl VALUES ("RM3_1","075_3_1","ROM","3","1","1","Yawut bi nag, ci lan la rawe ku dul Yawut? Te xaraf lu muy njariñ? ");
INSERT INTO wol2010_vpl VALUES ("RM3_2","075_3_2","ROM","3","2","2","Raw na ko fu nekk. Ci bu jëkk Yawut yi la Yàlla dénk waxam. ");
INSERT INTO wol2010_vpl VALUES ("RM3_3","075_3_3","ROM","3","3","3","Bu fekkee ne am na ci ñoom ñu ñàkk kóllëre, ndax loolu man na fanq kóllëreg Yàlla? ");
INSERT INTO wol2010_vpl VALUES ("RM3_4","075_3_4","ROM","3","4","4","Mukk! Su ñépp nekkoon ay naaféq, du tere Yàlla nekk dëgg. Moom la Mbind mi wax ci Yàlla ne: «Loo wax, ñépp ànd ci, te ku layoo ak yaw, nga yey ko.» ");
INSERT INTO wol2010_vpl VALUES ("RM3_5","075_3_5","ROM","3","5","5","Su fekkee nag njubadig nit dina feeñal njubteg Yàlla, lu ciy seen xalaat? Wax ji may bëgga wax nag léegi, waxi nit rekk la, maanaam: ndax kon Yàlla àttewul yoon ci li muy daan ku jubadi? ");
INSERT INTO wol2010_vpl VALUES ("RM3_6","075_3_6","ROM","3","6","6","Mukk! Ndax su Yàlla jubadi woon, naka lay àttee àddina si? ");
INSERT INTO wol2010_vpl VALUES ("RM3_7","075_3_7","ROM","3","7","7","Waaye nag xanaa dina am ku tontu ci loolu ne: «Su fekkee sama ñàkk kóllëre gën na yékkati kóllëreg Yàlla, di yokk it ndamam, lu tax kon Yàlla di ma teg ba tey bàkkaarkat, ba di ma àtte?» ");
INSERT INTO wol2010_vpl VALUES ("RM3_8","075_3_8","ROM","3","8","8","Lu tax manunoo wax ne: «Nanu def lu bon, ngir lu baax génn ca?» Am na sax ñu nuy tuumaal, di wax ne noonu lanuy waaree. Waaye ñiy wax loolu, ndaan gi ñu yelloo dina leen dal. ");
INSERT INTO wol2010_vpl VALUES ("RM3_9","075_3_9","ROM","3","9","9","Kon nag lu nu ci wara wax? Nun Yawut yi, ndax noo gën ñi ci des? Mukk! Ndaxte wone nanu ne, nit ñépp ñu ngi ci notaangeg bàkkaar, muy Yawut yi mbaa Gereg yi. ");
INSERT INTO wol2010_vpl VALUES ("RM3_10","075_3_10","ROM","3","10","10","Moom la Mbind mi wax ne: «Ku jub amul, du kenn sax. ");
INSERT INTO wol2010_vpl VALUES ("RM3_11","075_3_11","ROM","3","11","11","Amul kenn ku xam yëfi Yàlla, mbaa kenn ku koy wut. ");
INSERT INTO wol2010_vpl VALUES ("RM3_12","075_3_12","ROM","3","12","12","Ñépp jeng nañu, ba kenn amalatul Yàlla njariñ. Kenn du def lu baax, du kenn sax! ");
INSERT INTO wol2010_vpl VALUES ("RM3_13","075_3_13","ROM","3","13","13","Seen put a ngi xasaw ni méddum ñetti fan, seen làmmiñ làggi ci njublaŋ, te seeni kàddu aay ni daŋaru ñàngóor. ");
INSERT INTO wol2010_vpl VALUES ("RM3_14","075_3_14","ROM","3","14","14","Duñu génne ci seen gémmiñ lu dul ay móolu ak i xas. ");
INSERT INTO wol2010_vpl VALUES ("RM3_15","075_3_15","ROM","3","15","15","Ñu sawar lañu ci rey nit. ");
INSERT INTO wol2010_vpl VALUES ("RM3_16","075_3_16","ROM","3","16","16","Fu ñu jaar, foofa yàqu ak musiba. ");
INSERT INTO wol2010_vpl VALUES ("RM3_17","075_3_17","ROM","3","17","17","Xamuñu yoonu jàmm, ");
INSERT INTO wol2010_vpl VALUES ("RM3_18","075_3_18","ROM","3","18","18","te ragal Yàlla sore na seen xol.» ");
INSERT INTO wol2010_vpl VALUES ("RM3_19","075_3_19","ROM","3","19","19","Xam nanu nag ne lépp lu yoonu Musaa wax, wax na ko ñi nekk ci yoon woowu, ngir gémmiñ yépp ne miig, te waa àddina sépp jaar ci àtteb Yàlla. ");
INSERT INTO wol2010_vpl VALUES ("RM3_20","075_3_20","ROM","3","20","20","Ndaxte sàmm yoon wi taxul kenn jub ci kanam Yàlla; solob ndigal yi daal mooy wone bàkkaar. ");
INSERT INTO wol2010_vpl VALUES ("RM3_21","075_3_21","ROM","3","21","21","Waaye léegi nag Yàlla feeñal na, ni nit mana jube ci kanamam, ci lu séqul ak yoonu Musaa dara. Waaye ba tey yoonu Musaa ak waxi yonent yi seedeel nañu ko. ");
INSERT INTO wol2010_vpl VALUES ("RM3_22","075_3_22","ROM","3","22","22","Jub ci kanam Yàlla, gëm Yeesu Kirist rekk a koy maye, te képp ku ko gëm bokk nga ci. Ndaxte ñépp a yem fa kanam Yàlla. ");
INSERT INTO wol2010_vpl VALUES ("RM3_23","075_3_23","ROM","3","23","23","Ñépp a bàkkaar, ba joteetuñu ndamu Yàlla. ");
INSERT INTO wol2010_vpl VALUES ("RM3_24","075_3_24","ROM","3","24","24","Waaye gannaaw Kirist Yeesu dee na ngir jot leen, Yàlla ciw yiwam man na leena àtte ni ñu jub ci dara. ");
INSERT INTO wol2010_vpl VALUES ("RM3_25","075_3_25","ROM","3","25","25","Wàcce na Kirist, mu nekk sarax ngir Yàlla baal nu sunuy bàkkaar, jaar ci deretam ji ñu tuur; te ngëm rekk moo nu ciy boole. Noonu Yàlla firndeel na ne ku jub la, doonte sax dafa muñaloon ñi jiitu jamonoy Kirist, ba jéggal leen seeni bàkkaar. ");
INSERT INTO wol2010_vpl VALUES ("RM3_26","075_3_26","ROM","3","26","26","Kon ci jamono jii nu ne, Yàlla wone na bu leer ne ku jub la, di àtte ni ku jub képp ku gëm Yeesu, te ba tey dëkk ci njubteem. ");
INSERT INTO wol2010_vpl VALUES ("RM3_27","075_3_27","ROM","3","27","27","Kan a mana bàkku nag ci kanam Yàlla? Kenn! Lu ko waral nag? Xanaa sàmm yoon? Déedéet! Ngëm rekk. ");
INSERT INTO wol2010_vpl VALUES ("RM3_28","075_3_28","ROM","3","28","28","Ndaxte danoo dëggal ne ngëm rekk a tax Yàlla di àtte nit ni ku jub, waaye du sàmm yoon. ");
INSERT INTO wol2010_vpl VALUES ("RM3_29","075_3_29","ROM","3","29","29","Walla ndax nag Yawut yi rekk la fi nekkal? Ndax nekkalu fi it ñu dul Yawut? Ahakay! ");
INSERT INTO wol2010_vpl VALUES ("RM3_30","075_3_30","ROM","3","30","30","Gannaaw Yàlla kenn la, ñépp la fi nekkal. Ñi xaraf dina leen àtte ni ñu jub ndax seen ngëm, ñi xaraful it dina leen àtte ni ñu jub ndax seen ngëm. ");
INSERT INTO wol2010_vpl VALUES ("RM3_31","075_3_31","ROM","3","31","31","Xanaa kon ngëm day fanq yoonu Musaa? Mukk! Da koy gëna dëgëral sax. ");
INSERT INTO wol2010_vpl VALUES ("RM4_1","075_4_1","ROM","4","1","1","Sunu maam Ibraayma, mi nu soqikoo; nu mbiram tëdde? ");
INSERT INTO wol2010_vpl VALUES ("RM4_2","075_4_2","ROM","4","2","2","Bu fekkoonte ne Ibraayma, ci kaw i jëfam la ko Yàlla àttee ni ku jub, kon am na lu mu ci mana damoo. Waaye demewul noonu ci kanam Yàlla. ");
INSERT INTO wol2010_vpl VALUES ("RM4_3","075_4_3","ROM","4","3","3","Lan la Mbind mi wax ci loolu? Nee na: «Ibraayma gëm na Yàlla, te Yàlla jàppe ngëmam ni njub.» ");
INSERT INTO wol2010_vpl VALUES ("RM4_4","075_4_4","ROM","4","4","4","Képp kuy liggéey dina jot peyam; te pey googu du ag may, ñaqam la. ");
INSERT INTO wol2010_vpl VALUES ("RM4_5","075_4_5","ROM","4","5","5","Waaye Yàlla dina àtte jub sax ki ko weddi woon; kon ku wéeruwul ciy jëfam, waaye mu gëm rekk, Yàlla dina jàppe ngëmam ni njub. ");
INSERT INTO wol2010_vpl VALUES ("RM4_6","075_4_6","ROM","4","6","6","Noonu la Daawuda birale barkeelug nit ki Yàlla jagleel njub, fekk ay jëfam taxul. ");
INSERT INTO wol2010_vpl VALUES ("RM4_7","075_4_7","ROM","4","7","7","Mu ne: «Ñi ñu baal seen jàdd yoon, te seeni bàkkaar far ci kanam Yàlla, ñu barkeel lañu. ");
INSERT INTO wol2010_vpl VALUES ("RM4_8","075_4_8","ROM","4","8","8","Ki Boroom bi sëful ay bàkkaaram, kooka ku barkeel la.» ");
INSERT INTO wol2010_vpl VALUES ("RM4_9","075_4_9","ROM","4","9","9","Kon nag barkeel googu, ndax ñi xaraf rekk ñoo ko yeyoo? Ndax ñi xaraful it bokkuñu ci? Ahakay! Ndaxte wax nanu ne, Yàlla jàppe na ngëmu Ibraayma ni njub. ");
INSERT INTO wol2010_vpl VALUES ("RM4_10","075_4_10","ROM","4","10","10","Kañ la ko jagleel njub nag? Ndax lu jiitu xarafam la woon, am gannaaw ga? Lu ko jiitu la woon. ");
INSERT INTO wol2010_vpl VALUES ("RM4_11","075_4_11","ROM","4","11","11","Ndaxte Ibraayma gëm na, te Yàlla jàppe na ngëmam ni njub, fekk booba xarafagul. Te xarafal gi, màndarga la woon ci yaramam, di firndeel ne ku jub la woon. Noonu la Ibraayma mana nekke baayu ñépp ñi gëm, ba Yàlla man leena àtte ni ñu jub, te xarafuñu sax. ");
INSERT INTO wol2010_vpl VALUES ("RM4_12","075_4_12","ROM","4","12","12","Noonu itam la Ibraayma mana nekke baayu ñi xaraf, bu fekkee yemuñu rekk ci xaraf, waaye ñu am ngëm, ga Ibraayma sunu maam amoon lu jiitu xarafam. ");
INSERT INTO wol2010_vpl VALUES ("RM4_13","075_4_13","ROM","4","13","13","Ndaxte Yàlla dafa digoon Ibraayma ak ñi naroona soqikoo ci moom, ne dinañu moom àddina si. Te dige boobu jógewul ci yoonu Musaa, waaye dafa jóge ci njub, gi Ibraayma amoon ci kanam Yàlla ci kaw ngëmam. ");
INSERT INTO wol2010_vpl VALUES ("RM4_14","075_4_14","ROM","4","14","14","Ndaxte su fekkee ne ñi nekk ci yoonu Musaa rekk ñooy moom àddina, kon ngëm amatul njariñ, te digeb Yàlla toxu na. ");
INSERT INTO wol2010_vpl VALUES ("RM4_15","075_4_15","ROM","4","15","15","Yoonu Musaa daal du def lu dul wàcce merum Yàlla ci sunu bopp; ndax fu yoon amul, jàdd yoon du fa mana am. ");
INSERT INTO wol2010_vpl VALUES ("RM4_16","075_4_16","ROM","4","16","16","Kon nag loolu Yàlla dige, ngëm rekk a koy indi, ngir mu sukkandikoo yiwu Yàlla rekk. Noonu la dige bi wóore ci ñi soqikoo ci Ibraayma ñépp, du ci ñi nekk ci yoonu Musaa rekk, waaye itam ñi gëm ni Ibraayma gëme woon. Kon Ibraayma mooy sunu baay, nun ñépp. ");
INSERT INTO wol2010_vpl VALUES ("RM4_17","075_4_17","ROM","4","17","17","Moom la Yàlla dogal, wax ko ci Mbind mi ne: «Def naa la baayu xeet yu bare.» Ndaxte Ibraayma gëmoon na Yàlla, miy dekkal ñi dee, tey wax ci lu amagul, mel ni dafa am. ");
INSERT INTO wol2010_vpl VALUES ("RM4_18","075_4_18","ROM","4","18","18","Ibraayma dafa jàppoon ci ngëmam, di yaakaar, fekk bunti yaakaar yépp tëju. Moo tax mu nekk baayu xeet yu bare, ni ko Mbind mi waxe ne: «Noonu la sa askan di meli.» ");
INSERT INTO wol2010_vpl VALUES ("RM4_19","075_4_19","ROM","4","19","19","Mu xool yaramam, xam ne dee rekk a ko dese, ndax mi ngi tollu woon ci lu mat téeméeri at, waaye ba tey ngëmam wàññikuwul. Mu xam it ne, Saarata manatula ëmb. ");
INSERT INTO wol2010_vpl VALUES ("RM4_20","075_4_20","ROM","4","20","20","Waaye loolu taxul ngëmadi jàpp ko, ba muy werante ci waxu Yàlla; ngëmam sax di gëna dëgër, mu daldi sant Yàlla, ");
INSERT INTO wol2010_vpl VALUES ("RM4_21","075_4_21","ROM","4","21","21","mu wóor ko ne loolu ko Yàlla dig, Yàlla man na koo def. ");
INSERT INTO wol2010_vpl VALUES ("RM4_22","075_4_22","ROM","4","22","22","Moo tax «Yàlla jagleel na Ibraayma njub.» ");
INSERT INTO wol2010_vpl VALUES ("RM4_23","075_4_23","ROM","4","23","23","Waaye loolu lañu bind ne: «Yàlla jagleel na ko njub,» du Ibraayma rekk a moom wax ji. ");
INSERT INTO wol2010_vpl VALUES ("RM4_24","075_4_24","ROM","4","24","24","Nun itam ci wax jooju lanu bokk, te Yàlla dina nu jagleel njub, nun ñi gëm Yàlla, mi dekkal Yeesu sunu Boroom. ");
INSERT INTO wol2010_vpl VALUES ("RM4_25","075_4_25","ROM","4","25","25","Ndaxte Yàlla jébbale na ko ngir sunuy tooñ, dekkal ko ngir àtte nu jub. ");
INSERT INTO wol2010_vpl VALUES ("RM5_1","075_5_1","ROM","5","1","1","Léegi nag, gannaaw Yàlla àtte na nu jub ci kaw ngëm, nanu jàpp ci jàmm, ji nu am fa kanam Yàlla, jaarale ko ci sunu Boroom Yeesu Kirist. ");
INSERT INTO wol2010_vpl VALUES ("RM5_2","075_5_2","ROM","5","2","2","Moo nu ubbil bunt ci Yàlla, nu taxaw temm ci yiwam, jaar ci ngëm. Te it nu ngi bég ciy négandiku, Yàlla boole nu ci ndamam. ");
INSERT INTO wol2010_vpl VALUES ("RM5_3","075_5_3","ROM","5","3","3","Te du ci loolu rekk, waaye bég nanu it ci sunuy nattu; ndax xam nanu ne nattu day feddali muñ; ");
INSERT INTO wol2010_vpl VALUES ("RM5_4","075_5_4","ROM","5","4","4","te muñ mooy ndeyu jikko ju dëgër; te jikko ju dëgër day jur yaakaar. ");
INSERT INTO wol2010_vpl VALUES ("RM5_5","075_5_5","ROM","5","5","5","Te yaakaar jooju du ay nax, ndax mbëggeelu Yàllaa ngi baawaan ci sunu xol, jaarale ko ci Xelam mu Sell mi mu nu may. ");
INSERT INTO wol2010_vpl VALUES ("RM5_6","075_5_6","ROM","5","6","6","Ndaxte bi nu amul jenn doole, booba la Kirist dee ngir nun, fekk danoo weddi woon Yàlla. ");
INSERT INTO wol2010_vpl VALUES ("RM5_7","075_5_7","ROM","5","7","7","Kuy nangoo deeyal nit ku jub, yombula gis, waaye nag jombul am na ku nangoo deeyal ku baax. ");
INSERT INTO wol2010_vpl VALUES ("RM5_8","075_5_8","ROM","5","8","8","Waaye Yàlla firndeel na mbëggeelam ci nun, ci li Kirist dee ngir nun, bi nu nekkee sax ay bàkkaarkat! ");
INSERT INTO wol2010_vpl VALUES ("RM5_9","075_5_9","ROM","5","9","9","Gannaaw Kirist tuur na deretam nag, ngir Yàlla àtte nu jub, rawatina ne dina nu musal ci merum Yàlla. ");
INSERT INTO wol2010_vpl VALUES ("RM5_10","075_5_10","ROM","5","10","10","Nun ay bañaaley Yàlla lanu woon, waaye Doomam dee na, ngir jubale nu ak moom. Gannaaw léegi nag xariti Yàlla lanu, rawatina ne dinanu mucc ndax dundug Doomam. ");
INSERT INTO wol2010_vpl VALUES ("RM5_11","075_5_11","ROM","5","11","11","Te sax nu ngi bég ci Yàlla, jaarale ko ci sunu Boroom Yeesu Kirist, mi nu jubale ak moom. ");
INSERT INTO wol2010_vpl VALUES ("RM5_12","075_5_12","ROM","5","12","12","Kon nag bàkkaar ci kenn nit la jaar, dugg ci àddina, indaale fi dee, te dee daldi law ci nit ñépp, ndaxte ñépp a bàkkaar. ");
INSERT INTO wol2010_vpl VALUES ("RM5_13","075_5_13","ROM","5","13","13","Bàkkaar kon nekkoon na ci àddina, bi Yàlla di laata wàcce yoonu Musaa. Waaye gannaaw yoonu Musaa tëddagul woon, bàkkaar du woon jàdd yoon. ");
INSERT INTO wol2010_vpl VALUES ("RM5_14","075_5_14","ROM","5","14","14","Teewul nag la dale ca Aadama ba ca Musaa, dee a ngi fi woon ci àddina, di not ñépp, ak sax ñi seen bàkkaar melul woon ni bosu Aadama, maanaam jàdd yoon. Aadama moomu nag moo di takkandeeru Kirist, mi waroona ganesi àddina. ");
INSERT INTO wol2010_vpl VALUES ("RM5_15","075_5_15","ROM","5","15","15","Waaye warunoo yemale tooñu Aadama ak mayu Yàlla. Bàkkaaru kenn nit kooku tax na ñu bare dee; waaye yiwu Yàlla ak may, gi nu keneen nit ka Yeesu Kirist yéwénal, baawaan na ci ñu bare, ba suul tooñ googu. ");
INSERT INTO wol2010_vpl VALUES ("RM5_16","075_5_16","ROM","5","16","16","Te bàkkaaru Aadama niroowul ak mayu Yàlla. Aadama bàkkaar na benn yoon, ba tax Yàlla daan ko, daanaale ñépp; waaye Yàlla jéggle na tooñ yu bare ci dara, ba mu àtte ñu bare ni ñu jub. ");
INSERT INTO wol2010_vpl VALUES ("RM5_17","075_5_17","ROM","5","17","17","Bàkkaaru kenn nit tax na dee tàbbi àddina, yilif ñépp ni buur; waaye jëfu keneen nit ka, maanaam Yeesu Kirist, moo ko suul, ba tax ñu bare tàbbi ci dund gu bees, falu ni ay buur; xanaa ñi Yàlla boole ci yiwam wu bare, te àtte leen jub ci dara fa kanamam. ");
INSERT INTO wol2010_vpl VALUES ("RM5_18","075_5_18","ROM","5","18","18","Kon nag nu gàttal wax ji: jàddug kenn nit ka rekk moo waral Yàlla daan ñépp; noonu itam jëf ju jubu keneen nit ka rekk moo ubbi bunt, ba ñépp mana jub ci kanam Yàlla te am dund gu bees. ");
INSERT INTO wol2010_vpl VALUES ("RM5_19","075_5_19","ROM","5","19","19","Aadama moomu dafa déggadil Yàlla, ba yóbbaale ñu bare, ñu nekk i bàkkaarkat; noonu itam Yeesu Kirist dafa déggal Yàlla, yóbbaale ñu bare itam, ñu jub. ");
INSERT INTO wol2010_vpl VALUES ("RM5_20","075_5_20","ROM","5","20","20","Yoonu Musaa daldi wàcc, ngir bàkkaar gëna bare; waaye fa bàkkaar bare, yiwu Yàlla gën faa bare. ");
INSERT INTO wol2010_vpl VALUES ("RM5_21","075_5_21","ROM","5","21","21","Ba tax, ni bàkkaar doon yilife ñépp ni buur, indaale dee, noonu itam la yiwu Yàlla faloo ni buur, jóge ci njub, jëm ci dund gu dul jeex. Loolu lépp darajay Yeesu Kirist sunu Boroom moo nu ko may. ");
INSERT INTO wol2010_vpl VALUES ("RM6_1","075_6_1","ROM","6","1","1","Lu nu wara wax léegi nag? Xanaa nu sax ci bàkkaar, ngir yiwu Yàlla gëna bare? ");
INSERT INTO wol2010_vpl VALUES ("RM6_2","075_6_2","ROM","6","2","2","Mukk! Nun ñi dee, ba rëcc ci kàttanu bàkkaar, naka lanu manatee sax ci di ko def? ");
INSERT INTO wol2010_vpl VALUES ("RM6_3","075_6_3","ROM","6","3","3","Xanaa dangeena xamul ne, képp ku ñu sóob ci ndox, ngir wone ne mu ngi bokk ci Yeesu Kirist, ci deewu Yeesu la bokk. ");
INSERT INTO wol2010_vpl VALUES ("RM6_4","075_6_4","ROM","6","4","4","Bi ñu nu sóobee ci ndox moomu nag, day misaal ne dañu noo suul ak Kirist, nu dee ni mu deeye woon; ba tax nu dekki it, ni mu dekkee woon ci dooley Yàlla Baay bi, te nu sóobu ci dund gu bees. ");
INSERT INTO wol2010_vpl VALUES ("RM6_5","075_6_5","ROM","6","5","5","Kon nag gannaaw benn lanu ak Kirist, dee ni mu deeye woon, kon dinanu nekk it benn ak moom, dekki ni mu dekkee woon. ");
INSERT INTO wol2010_vpl VALUES ("RM6_6","075_6_6","ROM","6","6","6","Ndegam xam nanu ne daajoon nañu Kirist ca bant ba, xam nanu it ne jikko ju bon ji nu judduwaale, daajaale nañu ko ak Kirist ca bant ba. Yàlla def na loolu, ngir nguuru bàkkaar, gi nekkoon ci sunu yaram tas, nu rëcc ci dooleem. ");
INSERT INTO wol2010_vpl VALUES ("RM6_7","075_6_7","ROM","6","7","7","Ndaxte ku dee, bàkkaar manatul dara ci yaw. ");
INSERT INTO wol2010_vpl VALUES ("RM6_8","075_6_8","ROM","6","8","8","Gannaaw nag dee nanu ak Kirist, gëm nanu ne dinanu dekki it ni moom, ");
INSERT INTO wol2010_vpl VALUES ("RM6_9","075_6_9","ROM","6","9","9","xam ne Kirist mi dekki dootul dee mukk, dee manatul dara ci moom. ");
INSERT INTO wol2010_vpl VALUES ("RM6_10","075_6_10","ROM","6","10","10","Dee na benn yoon, ba bàkkaar manul ci moom dara; mi ngi dund léegi, di ànd ak Yàlla ba fàww. ");
INSERT INTO wol2010_vpl VALUES ("RM6_11","075_6_11","ROM","6","11","11","Ci noonu nag yéen itam tegleen seen bopp ni ñu dee ak Kirist, ba rëcc ci dooley bàkkaar, di dund, ànd ak Yàlla ba fàww ndax seen bokk ci Yeesu Kirist. ");
INSERT INTO wol2010_vpl VALUES ("RM6_12","075_6_12","ROM","6","12","12","Buleen mayati bàkkaar nag, mu yilif seeni yaram yu néew doole, bay topp ay bëgg-bëggam. ");
INSERT INTO wol2010_vpl VALUES ("RM6_13","075_6_13","ROM","6","13","13","Buleen jébbalati seeni cér bàkkaar, mu def leen jumtukaayam ngir jëfam yu jubadi; waaye gannaaw rëcc ngeen ci dooley dee, bay dundaat, jébbaluleen ci Yàlla te jébbal ko seeni cér, mu def leen jumtukaayam ngir jëfam yu jub. ");
INSERT INTO wol2010_vpl VALUES ("RM6_14","075_6_14","ROM","6","14","14","Ndaxte bàkkaar dootu leen manal dara, yéen ñi génn ci yoonu Musaa, dugg ci yiwu Yàlla. ");
INSERT INTO wol2010_vpl VALUES ("RM6_15","075_6_15","ROM","6","15","15","Lan lanu wara wax nag léegi? Gannaaw génn nanu ci yoonu Musaa, dugg ci yiwu Yàlla, ndax danoo wara sax ci def bàkkaar? Mukk! ");
INSERT INTO wol2010_vpl VALUES ("RM6_16","075_6_16","ROM","6","16","16","Ndax dangeena xamul ne koo jébbalu ci moom te déggal ko, jaamam nga? Naka noonu, mbaa ngeen nekk jaami bàkkaar, mu jëme leen ci dee, mbaa ngeen déggal Yàlla, mu sóob leen ci yoonu njub. ");
INSERT INTO wol2010_vpl VALUES ("RM6_17","075_6_17","ROM","6","17","17","Waaye sant naa Yàlla ci lii: yéen ñi doon jaami bàkkaar, bi ngeen déggee mboolem dëgg gi, nangu ngeen ko ak seen xol bépp. ");
INSERT INTO wol2010_vpl VALUES ("RM6_18","075_6_18","ROM","6","18","18","Ci noonu rëcc ngeen ci notaangeg bàkkaar te jébbalu ci Yàlla, sóobu ci njub. ");
INSERT INTO wol2010_vpl VALUES ("RM6_19","075_6_19","ROM","6","19","19","Xam naa ne seen xam-xam ci mbir mii sorewul, moo tax ma yombal wax ji, awale ko ci baat yii. Ni ngeen jële woon seeni cér, jébbal leen, ñu nekk jaami lu selladi ak lu bon, di gëna jur lu bon, noonu itam léegi jébbal-leen seeni cér, ñu nekk jaami njub, ngeen doora sell. ");
INSERT INTO wol2010_vpl VALUES ("RM6_20","075_6_20","ROM","6","20","20","Ndaxte keroog ba ngeen nekkee jaami bàkkaar, séquleen woon dara ak lu jub. ");
INSERT INTO wol2010_vpl VALUES ("RM6_21","075_6_21","ROM","6","21","21","Ban njariñ ngeen ci jële nag? Dara lu dul gàcce, ndaxte ci dee la leen doon jëmale. ");
INSERT INTO wol2010_vpl VALUES ("RM6_22","075_6_22","ROM","6","22","22","Waaye léegi Yàlla goreel na leen ci kilifteefu bàkkaar, def leen ay jaamam, ba jural leen sellaay, jëme leen ci dund gu dul jeex. ");
INSERT INTO wol2010_vpl VALUES ("RM6_23","075_6_23","ROM","6","23","23","Ndaxte peyu bàkkaar mooy dee, waaye mayu Yàlla mooy dund gu dul jeex ci Yeesu Kirist sunu Boroom. ");
INSERT INTO wol2010_vpl VALUES ("RM7_1","075_7_1","ROM","7","1","1","Bokk yi, yéen ñi may waxal xam ngeen luy yoon; xam ngeen kon ne yoon am na doole ci nit diirub dundam. ");
INSERT INTO wol2010_vpl VALUES ("RM7_2","075_7_2","ROM","7","2","2","Ci maanaa, mu ngi mel ni jigéen juy séy; yoon a ngi koy boole ak jëkkëram, ñu ànd seen giiru dund, waaye su jëkkër ji faatoo, buum gi dagg na. ");
INSERT INTO wol2010_vpl VALUES ("RM7_3","075_7_3","ROM","7","3","3","Kon nag su jabar ji àndee ak beneen góor, te fekk jëkkër jiy dund, dees na ko àtte njaaloo. Waaye bu jëkkër ji faatoo, yoon jeexal na seen diggante; man na séy nag ak beneen góor, te du doon njaaloo. ");
INSERT INTO wol2010_vpl VALUES ("RM7_4","075_7_4","ROM","7","4","4","Nii laa leen ko mana misaale, samay bokk; bi Kirist deeyee, dangeena deeyandoo ak moom, te noonu yoonu Musaa wàcc leen. Léegi nag yéena ngi ànd ak keneen, maanaam Kirist mi dekki, ngir nu amal Yàlla njariñ. ");
INSERT INTO wol2010_vpl VALUES ("RM7_5","075_7_5","ROM","7","5","5","Keroog ba nu daan topp sunu nafsu, yoonu Musaa daan na xamb bëgg-bëgg yu bon, yiy yëngal sunuy cér, ba jural nu dee. ");
INSERT INTO wol2010_vpl VALUES ("RM7_6","075_7_6","ROM","7","6","6","Waaye léegi yoon wi wàcc na nu, ci li nu dee, ba rëcc cig buumam. Léegi nag nu ngi jaamu Yàlla, waxuma leen ci sàmm santaane rekk, ndax loolu wees na, waaye ci kàttan gu bees, gi nu Xelum Yàlla di may. ");
INSERT INTO wol2010_vpl VALUES ("RM7_7","075_7_7","ROM","7","7","7","Kon nag lu nu wara wax? Ndax bàkkaar ci yoonu Musaa la jóge? Mukk! Waaye moo ma xamal luy bàkkaar. Ndaxte su ma yoon wi waxul woon: «Bul bëgg yëfi jaambur,» kon duma xam luy xemmem. ");
INSERT INTO wol2010_vpl VALUES ("RM7_8","075_7_8","ROM","7","8","8","Waaye bàkkaar jaare na ci ndigalu Yàlla, daldi ñëw dugg ci man, ba yëngal ci man xemmem yu bare. Ndaxte ba ma xamagul woon yoonu Musaa, bàkkaar da ne woon nemm ci man. ");
INSERT INTO wol2010_vpl VALUES ("RM7_9","075_7_9","ROM","7","9","9","Keroog bi ma xamagul lu yoon wi santaane, maa ngi doon dund dund gu neex; waaye ba ma ko déggee, bàkkaar dafa daldi fuddu ci man, te man ma daldi dee. ");
INSERT INTO wol2010_vpl VALUES ("RM7_10","075_7_10","ROM","7","10","10","Noonu gis naa ne ndigal loolu waroona jëme nit ñi ci dund, daf maa jëme ci dee. ");
INSERT INTO wol2010_vpl VALUES ("RM7_11","075_7_11","ROM","7","11","11","Ndaxte bàkkaar jaar na ci li Yàlla digle, ba nax ma, rey ma. ");
INSERT INTO wol2010_vpl VALUES ("RM7_12","075_7_12","ROM","7","12","12","Kon nag man nanoo wax ne yoonu Musaa yoon wu sell la, te ndigalu Yàlla dafa sell, jub te baax. ");
INSERT INTO wol2010_vpl VALUES ("RM7_13","075_7_13","ROM","7","13","13","Ndax kon lu baax moo ma tàbbal ci dee? Mukk! Bàkkaar a ko def, ngir jikkoom feeñ; dafa gis ci lu baax loolu bunt bu mu mana jaar, ba rey ma. Noonu ndigalu Yàlla tax na, bàkkaar fés, bon ba jéggi dayo. ");
INSERT INTO wol2010_vpl VALUES ("RM7_14","075_7_14","ROM","7","14","14","Xam nanu ne yoonu Musaa ngi jóge ci Yàlla, waaye man yëfi àddina laa fonk, te nekk ci dooley bàkkaar, mel nib jaam. ");
INSERT INTO wol2010_vpl VALUES ("RM7_15","075_7_15","ROM","7","15","15","Ndaxte samay jëf jaaxal na ma; li ma bëgga def, duma ko def, waaye li ma bañ rekk, moom laay def. ");
INSERT INTO wol2010_vpl VALUES ("RM7_16","075_7_16","ROM","7","16","16","Kon nag gannaaw li may def du sama coobare, nangu naa ne yoonu Musaa baax na. ");
INSERT INTO wol2010_vpl VALUES ("RM7_17","075_7_17","ROM","7","17","17","Léegi nag du man maay def lu bon loolu, waaye bàkkaar bi dëkk ci man, moo ma ciy jiiñ. ");
INSERT INTO wol2010_vpl VALUES ("RM7_18","075_7_18","ROM","7","18","18","Ndaxte xam naa ne lu baax dëkkul ci man, maanaam ci sama bindu doom Aadama. Am naa yéeney def lu baax, waaye awma kàttanu yeggale. ");
INSERT INTO wol2010_vpl VALUES ("RM7_19","075_7_19","ROM","7","19","19","Lu baax nag lu may yéene, duma ko def, waaye lu bon lu ma bëggul, moom laay def. ");
INSERT INTO wol2010_vpl VALUES ("RM7_20","075_7_20","ROM","7","20","20","Bu fekkee nag lu ma bëggul, moom laay def, kon dootul sama coobare, waaye bàkkaar bi dëkk ci man, moo ma ci jiiñ. ");
INSERT INTO wol2010_vpl VALUES ("RM7_21","075_7_21","ROM","7","21","21","Gis naa nag lii: saa su ma bëggee def lu baax, lu bon a ngi ma taxawu. ");
INSERT INTO wol2010_vpl VALUES ("RM7_22","075_7_22","ROM","7","22","22","Ndaxte ci sama biir xol yoonu Yàlla wi neex na ma. ");
INSERT INTO wol2010_vpl VALUES ("RM7_23","075_7_23","ROM","7","23","23","Waaye gis naa jeneen doole juy yëngu ci samay céri yaram, di bëre ak li sama xol bëgg; day bëre ba not ma, def ma jaam ci dooley bàkkaar joojuy yëngu ci samay cér. ");
INSERT INTO wol2010_vpl VALUES ("RM7_24","075_7_24","ROM","7","24","24","Céy maaka torox! Ana ku may musal ci sama yaram, wii may jëme ci dee? ");
INSERT INTO wol2010_vpl VALUES ("RM7_25","075_7_25","ROM","7","25","25","Maa ngi sant Yàlla; am na kuy musle, mooy Yeesu Kirist sunu Boroom. Kon nag lii laa gis ci sama bopp: ci sama xel maa ngi topp yoonu Yàlla, waaye ci sama bindu doom Aadama maa ngi topp yoonu bàkkaar. ");
INSERT INTO wol2010_vpl VALUES ("RM8_1","075_8_1","ROM","8","1","1","Léegi nag yoon manula dab ñi bokk ci Yeesu Kirist. ");
INSERT INTO wol2010_vpl VALUES ("RM8_2","075_8_2","ROM","8","2","2","Ndaxte kàttanu Xelum Yàlla, tukkee ci Kirist Yeesu, di may nit dund gu bees, goreel na ma ci notaangeg bàkkaar ak dee. ");
INSERT INTO wol2010_vpl VALUES ("RM8_3","075_8_3","ROM","8","3","3","Lu yoonu Musaa manul woona def, ndax néew dooley nit, Yàlla defe na ko nii: dafa yónni Doomam, ngir mu yor sunu jëmm, nun ñiy nekk ay bàkkaarkat, ba noppi mu jébbale bakkanam, ngir dindi bàkkaar yi. Noonu la Yàlla tase nguuru bàkkaar ci nit. ");
INSERT INTO wol2010_vpl VALUES ("RM8_4","075_8_4","ROM","8","4","4","Ba tax na léegi njub, gi yoonu Musaa di digle, am na ci nun, ñiy déggal Xelu Yàlla mi te baña topp sunu nafsu. ");
INSERT INTO wol2010_vpl VALUES ("RM8_5","075_8_5","ROM","8","5","5","Ñiy topp seen nafsu, seeni bëgg-bëgg rekk lañu fonk, waaye ñiy topp Xelu Yàlla mi, coobareem lañu fonk. ");
INSERT INTO wol2010_vpl VALUES ("RM8_6","075_8_6","ROM","8","6","6","Ndaxte fonk nafsu, ci dee lay jëme; waaye fonk Xelu Yàlla mi, dund ak jàmm lay joxe. ");
INSERT INTO wol2010_vpl VALUES ("RM8_7","075_8_7","ROM","8","7","7","Ndaxte ku fonk sa nafsu, bañaaleb Yàlla nga, ndaxte doo déggal Yàlla, mbaa ngay sàmm ay santaaneem, te manuloo koo def sax. ");
INSERT INTO wol2010_vpl VALUES ("RM8_8","075_8_8","ROM","8","8","8","Kuy topp sa nafsu nag, doo mana neex Yàlla. ");
INSERT INTO wol2010_vpl VALUES ("RM8_9","075_8_9","ROM","8","9","9","Waaye yéen nekkatuleen ci topp seen nafsu, waaye yéena ngi topp Xelu Yàlla mi, bu fekkee ne mu ngi dëkk ci yéen. Ku amul Xelum Kirist nag, bokkuloo ci moom. ");
INSERT INTO wol2010_vpl VALUES ("RM8_10","075_8_10","ROM","8","10","10","Bu fekkee ne Kirist dëkk na ci yéen nag, lii moo am: seen yaram mi ngi ci dooley dee ndax bàkkaar bi nekk ci yéen, waaye seen xel mi ngi dund ndax njub gi leen Yàlla jox. ");
INSERT INTO wol2010_vpl VALUES ("RM8_11","075_8_11","ROM","8","11","11","Kon nag gannaaw Xelum Yàlla, mi dekkal Yeesu ca néew ya, dëkk na ci yéen, dina tax seen yaram wi néew doole dund ci kàttanu Xel moomu dëkk ci yéen. ");
INSERT INTO wol2010_vpl VALUES ("RM8_12","075_8_12","ROM","8","12","12","Kon nag bokk yi, am nanu lu nu war, waaye waxuma leen topp sunu nafsu ak i bëgg-bëggam; ");
INSERT INTO wol2010_vpl VALUES ("RM8_13","075_8_13","ROM","8","13","13","ndaxte kuy topp nafsoom, fàww mu dee, waaye kuy not jëfi yaramam ci dooley Xelu Yàlla mi, dina dund. ");
INSERT INTO wol2010_vpl VALUES ("RM8_14","075_8_14","ROM","8","14","14","Ndaxte ñépp ñiy déggal Xelu Yàlla mi, ay doomi Yàlla lañu. ");
INSERT INTO wol2010_vpl VALUES ("RM8_15","075_8_15","ROM","8","15","15","Nekkatuleen fa kanam Yàlla, ni jaam bu ragal sangam, waaye Xel mi leen Yàlla sol, ay doomi Yàlla la leen def, ba tax nu di wooye Yàlla: «Abba», maanaam «Baay.» ");
INSERT INTO wol2010_vpl VALUES ("RM8_16","075_8_16","ROM","8","16","16","Ndaxte Xelu Yàlla mi, moom ci boppam, day ànd ak sunu xel ci seede ne doomi Yàlla lanu. ");
INSERT INTO wol2010_vpl VALUES ("RM8_17","075_8_17","ROM","8","17","17","Gannaaw ay doomi Yàlla lanu, dinanu moomi lépp li Yàlla jagleel ay doomam, séddu ci ngëneel yi Kirist yelloo. Waaye nag ku bëgga bokk ak Kirist ndamam ëllëg, war ngaa séddu ci ay fitnaam tey. ");
INSERT INTO wol2010_vpl VALUES ("RM8_18","075_8_18","ROM","8","18","18","Xalaat naa ne sunu naqaru tey, wareesu ko tëkkale ak sunu ndamu ëllëg. ");
INSERT INTO wol2010_vpl VALUES ("RM8_19","075_8_19","ROM","8","19","19","Ndax li Yàlla bind lépp a ngi ne seewa gis doomi Yàlla yi feeñ ci seen biir ndam. ");
INSERT INTO wol2010_vpl VALUES ("RM8_20","075_8_20","ROM","8","20","20","Ndaxte dunyaa bi bépp mu ngi ci yoon wu dul mujj fenn; teyu ko, Yàlla moo ko ko teg. Waaye teewul ñu am yaakaar ne, ");
INSERT INTO wol2010_vpl VALUES ("RM8_21","075_8_21","ROM","8","21","21","Yàlla dina rengi seen buumi njaam ci dee, boole leen ci jàmmu doomi Yàlla yi ak seen ndam. ");
INSERT INTO wol2010_vpl VALUES ("RM8_22","075_8_22","ROM","8","22","22","Xam nanu ba fi nu tollu ne li Yàlla bind lépp a ngi mititlu ni jigéen juy matu. ");
INSERT INTO wol2010_vpl VALUES ("RM8_23","075_8_23","ROM","8","23","23","Te du dunyaa bi rekk mooy mititlu, nun it nu ngi mititlu, nun ñi Yàlla sol Xelam, ngir nu ñam añu ëllëg; nu ngi ne seew Yàlla boole nu ci lépp li nu yelloo ni ay doomam, keroog bés bu Yàllay goreel sunu yaram. ");
INSERT INTO wol2010_vpl VALUES ("RM8_24","075_8_24","ROM","8","24","24","Ndaxte sunu mucc ëmb na yaakaar. Li nga gis ba noppi, nekkatul yaakaar; li teew, noo koy yaakaare? ");
INSERT INTO wol2010_vpl VALUES ("RM8_25","075_8_25","ROM","8","25","25","Li feek gisagunu nag li nuy yaakaar, dinanu ko séentu ak muñ. ");
INSERT INTO wol2010_vpl VALUES ("RM8_26","075_8_26","ROM","8","26","26","Te it Xelu Yàlla mi moo nuy xettali ci sunug néew doole. Ndaxte xamunu sax naka lanu wara ñaane Yàlla, waaye Xelu Yàlla maa ngi nuy ñaanal fa moom ak i yéene yu làmmiñ manta takk. ");
INSERT INTO wol2010_vpl VALUES ("RM8_27","075_8_27","ROM","8","27","27","Te Yàlla, miy nattu xol yi, xam na xalaatu Xel mi, ndaxte tinu, gi muy tinul gaayi Yàlla yi, méngoo na ak coobarey Yàlla. ");
INSERT INTO wol2010_vpl VALUES ("RM8_28","075_8_28","ROM","8","28","28","Xam nanu itam ne ñi bëgg Yàlla, maanaam ñi Yàlla woo ci boppam te boole leen ci li mu tëral, Yàlla dina joo loxoom ci lépp lu xew ci seen dund, ngir jural leen lu baax. ");
INSERT INTO wol2010_vpl VALUES ("RM8_29","075_8_29","ROM","8","29","29","Ndaxte ñi mu xamoon lu jiitu, dafa dogaloon ñu nirook Doomam, ngir mu nekk taaw ci biir njaboot gu yaa. ");
INSERT INTO wol2010_vpl VALUES ("RM8_30","075_8_30","ROM","8","30","30","Ñi mu dogaloon loolu ci ñoom, da leena woo; ñooñu mu woo, da leena àtte ni ñu jub; ñooñu mu àtte jub, da leena boole ca ndamam. ");
INSERT INTO wol2010_vpl VALUES ("RM8_31","075_8_31","ROM","8","31","31","Lu nu wara wax nag ci loolu lépp? Gannaaw Yàlla ànd na ak nun, kan moo nu manal dara? ");
INSERT INTO wol2010_vpl VALUES ("RM8_32","075_8_32","ROM","8","32","32","Yàlla mi nu gàntulul Doomam waaye mu joxe ko, mu dee ngir nun, ndax dina nu bañalati dara? ");
INSERT INTO wol2010_vpl VALUES ("RM8_33","075_8_33","ROM","8","33","33","Ñi Yàlla tànnal boppam, kan moo leen di tuumaal? Yàlla moo leen àtte ni ñu jub. ");
INSERT INTO wol2010_vpl VALUES ("RM8_34","075_8_34","ROM","8","34","34","Kan moo leen mana teg tooñ? Yeesu Kirist mi dee, moo dekki itam, te mu nga fa ndijoorul Yàlla, di nu fa ñaanal! ");
INSERT INTO wol2010_vpl VALUES ("RM8_35","075_8_35","ROM","8","35","35","Kan moo nu mana tàggaleek mbëggeelu Kirist? Xanaa duy nattu, te du njàqare, du it fitna, du xiif walla rafle, du it ay ngaañ walla jaasi sax. ");
INSERT INTO wol2010_vpl VALUES ("RM8_36","075_8_36","ROM","8","36","36","Moo tax Mbind mi ne: «Ñu ngi nuy rey ngir yaw, ci suba ba jant so; ñu ngi nuy jàppe ni xar yu ñuy rey.» ");
INSERT INTO wol2010_vpl VALUES ("RM8_37","075_8_37","ROM","8","37","37","Waaye loolu lépp teewul, nu ngi mel niy ñeyi xare ci dooley Kirist mi nu bëgg. ");
INSERT INTO wol2010_vpl VALUES ("RM8_38","075_8_38","ROM","8","38","38","Ndax wóor na ma ne dara manu noo tàggaleek mbëggeelam; du dee, du dund, du malaaka yi, du seeni kilifa, du tey, du ëllëg, du boroom doole yi, ");
INSERT INTO wol2010_vpl VALUES ("RM8_39","075_8_39","ROM","8","39","39","du li ci kaw mbaa li ci suuf, mbaa leneen lu ñu bind; dara manu noo tàggale mukk ak mbëggeel, gi nu Yàlla jox ci Kirist Yeesu sunu Boroom. ");
INSERT INTO wol2010_vpl VALUES ("RM9_1","075_9_1","ROM","9","1","1","Li ma bëgga wax nag, ci kanam Kirist laa koy waxe; dëgg la, du aw fen. Sama xel, mi Xel mu Sell miy leeral, seedeel na ma ne dëgg laay wax. ");
INSERT INTO wol2010_vpl VALUES ("RM9_2","075_9_2","ROM","9","2","2","Maanaam, duma noppee am naqar wu réy ci sama biir xol, ");
INSERT INTO wol2010_vpl VALUES ("RM9_3","075_9_3","ROM","9","3","3","ba xawa bëgga tàggoo ak Kirist te alku, ngir ñi ma bokkal xeet mucc. ");
INSERT INTO wol2010_vpl VALUES ("RM9_4","075_9_4","ROM","9","4","4","Bànni Israyil lañu, te Yàlla def na leen ni ay doomam; dëkkaloon na ndamam ci seen biir, fas ak ñoom kóllëre yi. Ñoom la Yàlla dénk yoonu Musaa, ñoom la xamal ni ñu ko wara jaamoo, ñoom la jox i digam. ");
INSERT INTO wol2010_vpl VALUES ("RM9_5","075_9_5","ROM","9","5","5","Maam ya Yàlla tànnoon, ci ñoom lañu bokk, ci ñoom it la Kirist wàcce, maanaam ci jëmmam, Kirist mi di Yàlla, tiim lépp, te yelloo teraanga ba fàww. Amiin. ");
INSERT INTO wol2010_vpl VALUES ("RM9_6","075_9_6","ROM","9","6","6","Waaye neewuma waxu Yàlla dafa toxu, ndaxte bokk ci bànni Israyil, taxul nga bokk ci Israyil tigi. ");
INSERT INTO wol2010_vpl VALUES ("RM9_7","075_9_7","ROM","9","7","7","Te it du ñi soqikoo ci Ibraayma ñépp, ay doomam dëgg lañu. Ndaxte Yàlla dafa wax Ibraayma ne ko: «Saw askan ci Isaaxa lay jaar.» ");
INSERT INTO wol2010_vpl VALUES ("RM9_8","075_9_8","ROM","9","8","8","Maanaam, soqikoo ci Ibraayma taxula nekk doomu Yàlla, waaye juddu ci biir digeb Yàlla mooy taxa bokk dëgg-dëgg ci askanu Ibraayma. ");
INSERT INTO wol2010_vpl VALUES ("RM9_9","075_9_9","ROM","9","9","9","Ndaxte Yàlla dafa digoon Ibraayma ne ko: «Ci waxtu wii déwén dinaa délsi ci yaw, te Saarata dina am doom ju góor.» ");
INSERT INTO wol2010_vpl VALUES ("RM9_10","075_9_10","ROM","9","10","10","Du ci loolu rekk, waaye noonu la it ci lu jëm ci Rebeka; doom yi mu jur ñoo bokk benn baay, moo di sunu maam Isaaxa. ");
INSERT INTO wol2010_vpl VALUES ("RM9_11","075_9_11","ROM","9","11","12","Waaye Yàlla wax ko ne: «Yanqóoba rakk ji mooy yilif magam Esawu,» fekk xale ya juddooguñu te defaguñu dara, muy lu baax, muy lu bon. Yàlla def na noonu, maanaam tànn kenn ci doom yi, ngir dogalam mana taxaw, te sukkandikuwul ci seeni jëf waaye ci wooteb Yàlla. ");
INSERT INTO wol2010_vpl VALUES ("RM9_13","075_9_13","ROM","9","13","13","Loolu la Mbind mi wax ne: «Bëgg naa Yanqóoba, bañ naa Esawu.» ");
INSERT INTO wol2010_vpl VALUES ("RM9_14","075_9_14","ROM","9","14","14","Kon lu nu ci wara wax? Ndax Yàlla àttewul foofu yoon nag? Mukk! ");
INSERT INTO wol2010_vpl VALUES ("RM9_15","075_9_15","ROM","9","15","15","Dafa wax Musaa sax ne ko: «Su ma neexee yéwéne, su ma soobee yërëm.» ");
INSERT INTO wol2010_vpl VALUES ("RM9_16","075_9_16","ROM","9","16","16","Dama leen di wax nag, dara ajuwul ci coobarey nit, mbaa ci ñaqam, waaye lépp a ngi aju ci yërmandey Yàlla. ");
INSERT INTO wol2010_vpl VALUES ("RM9_17","075_9_17","ROM","9","17","17","Ndax Mbind mi biral na li Yàlla wax Firawna ne ko: «Def naa la buur, ngir feeñal sama kàttan ci say mbir, ngir siiwal sama tur ci àddina si sépp.» ");
INSERT INTO wol2010_vpl VALUES ("RM9_18","075_9_18","ROM","9","18","18","Kon nag Yàlla, la ko neex lay def, muy yërëm nit, mbaa dëgëral xolam ci lu bon. ");
INSERT INTO wol2010_vpl VALUES ("RM9_19","075_9_19","ROM","9","19","19","Waaye xanaa dina am ku may wax ne: «Gannaaw kenn manula bañ coobarey Yàlla, lu tax kon muy teg nit tooñ?» ");
INSERT INTO wol2010_vpl VALUES ("RM9_20","075_9_20","ROM","9","20","20","Yaw nag nit ki, ak koo mana doon, lu tax ngay werante ak Yàlla? Ndax mbindeef dina laaj ki ko bind: «Lu tax nga binde ma nii?» ");
INSERT INTO wol2010_vpl VALUES ("RM9_21","075_9_21","ROM","9","21","21","Ndax tabaxkatu ndaa sañula fab banam, tabax ci ñaari ndaa, benn bi ngir soxla yu am maana, bi ci des ngir soxla yu ndaw? ");
INSERT INTO wol2010_vpl VALUES ("RM9_22","075_9_22","ROM","9","22","22","Kon nag looy wax ci lii: Yàlla bëggoon na wone meram, xamle it dooleem ci àddina; teewul dafa sax ci muñal ñi yelloo meram te taxaw ci sànku. ");
INSERT INTO wol2010_vpl VALUES ("RM9_23","075_9_23","ROM","9","23","23","Bëggoon na it xamle màggaayam mu ëpp xel, ci boole ñi mu yërëm ci ndamam; moo tax mu tànn leen ca njàlbéen. ");
INSERT INTO wol2010_vpl VALUES ("RM9_24","075_9_24","ROM","9","24","24","Wax ji noo ko moom, nun ñi Yàlla woo ci boppam ci biir Yawut yi ak ci biir xeet yi ci des. ");
INSERT INTO wol2010_vpl VALUES ("RM9_25","075_9_25","ROM","9","25","25","Moom la wax ci téereb Ose ne: «Ñi nekkul woon sama xeet dinaa leen ko def, ñi bokkul woon ci sama mbëggeel, dinaa leen ci boole.» ");
INSERT INTO wol2010_vpl VALUES ("RM9_26","075_9_26","ROM","9","26","26","Te: «Fa ñu leen waxe woon: “Dungeen sama xeet,” dees na leen fa wooye “Doomi Yàlla Boroom dund.”» ");
INSERT INTO wol2010_vpl VALUES ("RM9_27","075_9_27","ROM","9","27","27","Esayi wax na ci mbirum Israyil ne: «Lu bànni Israyil baree bare ni suufus géej sax, lu néew rekk a ciy mucc. ");
INSERT INTO wol2010_vpl VALUES ("RM9_28","075_9_28","ROM","9","28","28","Ndaxte li Boroom bi dogal ci àddina, dina ko gaawa def, te dina mat sëkk.» ");
INSERT INTO wol2010_vpl VALUES ("RM9_29","075_9_29","ROM","9","29","29","Esayi it waxoon na lu jiitu loolu ne: «Boroom gàngoori xare yi, su bàyyiwul woon ci nun lu néew, kon ba tey raat nanu ni dëkki Sodom ak Gomor.» ");
INSERT INTO wol2010_vpl VALUES ("RM9_30","075_9_30","ROM","9","30","30","Lu nu ci wara wax nag? Ñi dul Yawut te fonkuñu woon jub ci kanam Yàlla, léegi jub nañu ci kaw ngëm. ");
INSERT INTO wol2010_vpl VALUES ("RM9_31","075_9_31","ROM","9","31","31","Waaye bànni Israyil, mi bëggoona sàmm yoon ngir jub, matalu ko. ");
INSERT INTO wol2010_vpl VALUES ("RM9_32","075_9_32","ROM","9","32","32","Ndax lan? Ndax dañoo sukkandiku ci seeni jëf, bàyyi ngëm. Dañoo daanu ci «doj wuy fakktale.» ");
INSERT INTO wol2010_vpl VALUES ("RM9_33","075_9_33","ROM","9","33","33","Moom la Yàlla wax ci Mbind mi ne: «Dinaa samp ci Siyoŋ doj wuy fakktale, di xeer wuy daaneel nit; waaye ku wéeru ci moom, sa yaakaar du tas.» ");
INSERT INTO wol2010_vpl VALUES ("RM10_1","075_10_1","ROM","10","1","1","Bokk yi, sama coobarey xol ci bànni Israyil ak sama ñaan ci Yàlla, mooy ñu mucc. ");
INSERT INTO wol2010_vpl VALUES ("RM10_2","075_10_2","ROM","10","2","2","Seedeel naa leen ne, ñu farlu lañu ci jaamu Yàlla, waaye seen njaamu àndul ak xam-xam. ");
INSERT INTO wol2010_vpl VALUES ("RM10_3","075_10_3","ROM","10","3","3","Xamuñu yoon, wi Yàlla tëral ngir nit jub ci kanamam, waaye dañoo wéy ci seen pexey bopp; ba tax ñu baña nangu yoonu njub woowu Yàlla tëral. ");
INSERT INTO wol2010_vpl VALUES ("RM10_4","075_10_4","ROM","10","4","4","Ndaxte ci Kirist la yoonu Musaa dëppe, ba tax ku ko gëm, dinga jub fa kanam Yàlla. ");
INSERT INTO wol2010_vpl VALUES ("RM10_5","075_10_5","ROM","10","5","5","Ku bëgga jub ci kanam Yàlla ci kaw sàmm yoon, Musaa daf cee wax ne: «Ku ko manoona matal, dinga dund ba fàww.» ");
INSERT INTO wol2010_vpl VALUES ("RM10_6","075_10_6","ROM","10","6","6","Waaye ku jub ci kanam Yàlla ci kaw ngëm, nii lay waxe: «Bul wax ci sa xol ne: “Kuy yéeg ci kaw?”» mel ni dangaa bëgg Kirist wàcc. ");
INSERT INTO wol2010_vpl VALUES ("RM10_7","075_10_7","ROM","10","7","7","«Bul wax it: “Kuy dem ca barsàq?”» mel ni dangaa bëgg Kirist dekki. ");
INSERT INTO wol2010_vpl VALUES ("RM10_8","075_10_8","ROM","10","8","8","Kon boog lan lay wax? Lii: «Waxu Yàlla mi ngi ci sa wet, ci sa làmmiñ, ci sa xol.» Te wax jooju lal ngëm lanuy waare. ");
INSERT INTO wol2010_vpl VALUES ("RM10_9","075_10_9","ROM","10","9","9","Ndaxte soo waxee ak sa gémmiñ ne, Yeesu mooy Boroom bi, te nga gëm ci sa xol ne, Yàlla dekkal na ko, dinga mucc. ");
INSERT INTO wol2010_vpl VALUES ("RM10_10","075_10_10","ROM","10","10","10","Ndax xol la nit di gëme, ba tax mu jub ci kanam Yàlla; làmmiñ it la nit di waxe ne mi ngi ci Kirist, ba tax Yàlla musal ko. ");
INSERT INTO wol2010_vpl VALUES ("RM10_11","075_10_11","ROM","10","11","11","Mbind mi dafa wax ne: «Képp ku ko gëm, sa yaakaar du tas mukk.» ");
INSERT INTO wol2010_vpl VALUES ("RM10_12","075_10_12","ROM","10","12","12","Ndax ñépp a yem ci kanam Yàlla, muy Yawut mbaa ku dul Yawut, ndax kenn rekk mooy sunu Boroom nun ñépp; ku yéwén la ci képp ku koy ñaan. ");
INSERT INTO wol2010_vpl VALUES ("RM10_13","075_10_13","ROM","10","13","13","Ndaxte bind nañu: «Képp ku woo Boroom bi ciw turam, dinga mucc.» ");
INSERT INTO wol2010_vpl VALUES ("RM10_14","075_10_14","ROM","10","14","14","Waaye nan lañuy wooye ki ñu gëmagul? Naka lañu mana gëme ki ñu déggagul turam? Naka lañu mana dégge turam, te kenn xamalu leen ko? ");
INSERT INTO wol2010_vpl VALUES ("RM10_15","075_10_15","ROM","10","15","15","Nan lañu mana waaree, su leen kenn yónniwul? Looloo tax Mbind mi wax ne: «Ñiy yégle xibaaru jàmm bi, ni seen ñëw di sedde xol!» ");
INSERT INTO wol2010_vpl VALUES ("RM10_16","075_10_16","ROM","10","16","16","Waaye ñépp nanguwuñu xibaaru jàmm bi; moom la Esayi wax ne: «Boroom bi, ana ku gëm sunu waare?» ");
INSERT INTO wol2010_vpl VALUES ("RM10_17","075_10_17","ROM","10","17","17","Kon boog ngëm ci kaw dégg lay juddoo, te dégg sosoo ci xibaaru Kirist. ");
INSERT INTO wol2010_vpl VALUES ("RM10_18","075_10_18","ROM","10","18","18","Waaye ma ne: xanaa ñépp dañoo déggul? Ahakay! Mbind mi wax na ne: «Seen baat jolli na ci ñeenti xébla yépp, seen wax wër na àddina sépp.» ");
INSERT INTO wol2010_vpl VALUES ("RM10_19","075_10_19","ROM","10","19","19","Waaye ma teg ci ne: xanaa bànni Israyil dañoo xamul? Ahakay! Musaa dafa jëkkoona wax ne: «Dinaa leen siisloo xeet wu bokkul ci Yàlla, merloo leen ci ñi xamul dara ci Yàlla.» ");
INSERT INTO wol2010_vpl VALUES ("RM10_20","075_10_20","ROM","10","20","20","Esayi it takk na fitam, ba wax ne: «Ñi ma wutul woon, gis nañu ma, feeñ naa ci ñi ma laajul woon.» ");
INSERT INTO wol2010_vpl VALUES ("RM10_21","075_10_21","ROM","10","21","21","Waaye ci mbirum Israyil dafa wax ne: «Tàllal naa samay loxo, suba ba ngoon, ci xeet wu may bañ tey werante.» ");
INSERT INTO wol2010_vpl VALUES ("RM11_1","075_11_1","ROM","11","1","1","Ma ne kon, ndax Yàlla bërgël na xeetam? Mukk! Ndaxte man itam ci Israyil laa bokk, wàcce ci Ibraayma te bokk ci giiru Beñamin. ");
INSERT INTO wol2010_vpl VALUES ("RM11_2","075_11_2","ROM","11","2","2","Yàlla bërgëlul xeetam, wi mu xamoon lu jiitu. Ndax dangeena xamul li Mbind mi di wax ci mbirum Ilyaas? Dafa doon tawat Israyil ci Yàlla naan: ");
INSERT INTO wol2010_vpl VALUES ("RM11_3","075_11_3","ROM","11","3","3","«Boroom bi, rey nañu say yonent, daaneel say bérab yu sell, ba man kenn maa ci des, te ñu ngi may wuta rey.» ");
INSERT INTO wol2010_vpl VALUES ("RM11_4","075_11_4","ROM","11","4","4","Waaye Yàlla da ko ne: «Dencal naa sama bopp juróom ñaari junniy nit ñu jaamuwul Baal.» ");
INSERT INTO wol2010_vpl VALUES ("RM11_5","075_11_5","ROM","11","5","5","Noonu itam ci jamono ji nu nekk, des na nit ñu néew ñu Yàlla dencal boppam ciw yiwam. ");
INSERT INTO wol2010_vpl VALUES ("RM11_6","075_11_6","ROM","11","6","6","Gannaaw nag yiwu Yàlla rekk a tax mu denc leen, kon du seen peyug ñaq, walla boog yiwu Yàlla dootul yiw. ");
INSERT INTO wol2010_vpl VALUES ("RM11_7","075_11_7","ROM","11","7","7","Kon lu nu ci wara wax? Li bànni Israyil doon wut, gisuñu ko. Waaye ñi Yàlla tànn rekk a ko gis, te ña ca des baña gëm, ba seen xol dërkiis. ");
INSERT INTO wol2010_vpl VALUES ("RM11_8","075_11_8","ROM","11","8","8","Looloo tax Mbind mi ne: «Yàlla daf leena jox xelum nit ku gëmméentu, bët yu gëlëm ak nopp yu tëx, ba ci bésub tey.» ");
INSERT INTO wol2010_vpl VALUES ("RM11_9","075_11_9","ROM","11","9","9","Te Daawuda it daf ci wax naan: «Na seeni ñam sax nekk fiir ak i pakk; nañu ci daanu, te Yàlla mbugal leen. ");
INSERT INTO wol2010_vpl VALUES ("RM11_10","075_11_10","ROM","11","10","10","Nañu gumba ba ne fatuus, nañu tiis te sëgg ba fàww.» ");
INSERT INTO wol2010_vpl VALUES ("RM11_11","075_11_11","ROM","11","11","11","Ndax kon dañoo tarxiis, daanu ba fàww? Mukk! Waaye jéllub Israyil dafa ubbi bunt, ngir xeeti ñi dul Yawut mana mucc, te bànni Israyil siis leen. ");
INSERT INTO wol2010_vpl VALUES ("RM11_12","075_11_12","ROM","11","12","12","Gannaaw seen tooñ nag moo ubbi buntu yiw ci waa àddina si, te seen ñàkk moo meññ barkeb xeet yépp, céy bés bu Israyil gépp delloo ci Yàlla, ndaw barke bu bare! ");
INSERT INTO wol2010_vpl VALUES ("RM11_13","075_11_13","ROM","11","13","13","Yéen ñi dul Yawut, yéen laay waxal. Ndegam Yàlla daf maa def ndawam, yónni ma ci yéen xeeti àddina si, damay matal samab yónnent. ");
INSERT INTO wol2010_vpl VALUES ("RM11_14","075_11_14","ROM","11","14","14","Dama koy def, ngir ñi bokk ak man xeet siis, ba ñenn ñi mucc. ");
INSERT INTO wol2010_vpl VALUES ("RM11_15","075_11_15","ROM","11","15","15","Ndaxte bi Yàlla génnee Israyil, ubbee na noonu bunt, ngir xeeti àddina juboo ak moom; kon su Yàlla dugalaatee Israyil, ndax du mel ni ndekkitel néew ya? ");
INSERT INTO wol2010_vpl VALUES ("RM11_16","075_11_16","ROM","11","16","16","Damay wax ne, mburu mépp sell na, bu ci Yàlla amee wàll. Naka noonu garab gi Yàlla séddoo reen bi, garab gépp sell na. ");
INSERT INTO wol2010_vpl VALUES ("RM11_17","075_11_17","ROM","11","17","17","Bànni Israyil a ngi mel ni garabu oliw gu ñu jëmbët ci kër gi, waaye mu am car yu ci fàq. Yaw mi dul Yawut, yaa ngi mel ni caru garabu oliw gu àll bu ñu jabtal ci garabu kër googu. Noonu nga jariñoo meen, mi jóge ci reen bi. ");
INSERT INTO wol2010_vpl VALUES ("RM11_18","075_11_18","ROM","11","18","18","Kon nag bul bàkku, di xeeb car yooyu Yàlla fàq. Waaye soo bëggee bàkku, xamal ne reen moo lay yenu, te du yaw miy car yaa koy yenu. ");
INSERT INTO wol2010_vpl VALUES ("RM11_19","075_11_19","ROM","11","19","19","Xanaa dinga wax ne: «Car yooyu dañu leena fàq, ngir jabtal ma fa ñu nekkoon.» ");
INSERT INTO wol2010_vpl VALUES ("RM11_20","075_11_20","ROM","11","20","20","Dëgg la; waaye seen ngëmadee tax ñu fàq leen, wuutal la fa ndax sa ngëm. Bumu tax nag ngay bàkku, waaye nanga moytu. ");
INSERT INTO wol2010_vpl VALUES ("RM11_21","075_11_21","ROM","11","21","21","Gannaaw Yàlla baalul car ya cosaanoo ca garab ga, kon boog yéen itam man na leena fàq. ");
INSERT INTO wol2010_vpl VALUES ("RM11_22","075_11_22","ROM","11","22","22","Loolu kon wone na ni Yàlla baaxe ak ni muy meree tooñ. Ci ñi daanu, Yàlla wone na ni meram tànge, wone mbaaxam ci yéen, su fekkee yéena ngi ci wéy; lu ko moy, dees na leen fàq yéen itam. ");
INSERT INTO wol2010_vpl VALUES ("RM11_23","075_11_23","ROM","11","23","23","Te car yooyu fàq, su ñu wéyul ci seen ngëmadi, dees na leen delloo ci garab gi, ndax Yàlla man na leen cee tafaat. ");
INSERT INTO wol2010_vpl VALUES ("RM11_24","075_11_24","ROM","11","24","24","Yaw mi dul Yawut, yaa ngi bokkoon ci garabu oliw gu àll, waaye Yàlla daf la cee jële, ci lu dul farala am, jabtal la ci garabu kër gi. Kon man nanoo gëna wóor ne, Yawut ya judduwaale nekk ci garabu oliw gu kër gi, Yàlla dina leen ci delloo. ");
INSERT INTO wol2010_vpl VALUES ("RM11_25","075_11_25","ROM","11","25","25","Bokk yi, dama leena bëgga dindi kumpa ci lii, ngir ngeen baña yég seen bopp. Dërkiisu xol dab na bànni Israyil ab diir, ba bés ba mboolem waa àddina, ñu wara bokk ci nguuru Yàlla, dugg ca. ");
INSERT INTO wol2010_vpl VALUES ("RM11_26","075_11_26","ROM","11","26","26","Bu loolu amee nag, bànni Israyil gépp dina mucc. Moom la Mbind mi tëral, bi mu naan: «Ab xettalikat dina jóge ci Siyoŋ, dàq weddi ci askanu Yanqóoba. ");
INSERT INTO wol2010_vpl VALUES ("RM11_27","075_11_27","ROM","11","27","27","Loolu mooy kóllëre, gi may fas ak ñoom, bés bu may dindi seeni bàkkaar.» ");
INSERT INTO wol2010_vpl VALUES ("RM11_28","075_11_28","ROM","11","28","28","Gannaaw bañ nañu xibaaru jàmm bi, ay bañaaley Yàlla lañu, ngir ngeen jot barkeem. Waaye gannaaw Yàlla tànn na leen, dafa leen bëgg ba tey ndax seen maam ya. ");
INSERT INTO wol2010_vpl VALUES ("RM11_29","075_11_29","ROM","11","29","29","Ndax li Yàlla maye, dootu ko nangu mukk, te ku mu woo ci boppam, dootu la dàq mukk. ");
INSERT INTO wol2010_vpl VALUES ("RM11_30","075_11_30","ROM","11","30","30","Ñu déggadil Yàlla ngeen woon, waaye ngëmadig Yawut yi tax na, ngeen jot yërmandeem. ");
INSERT INTO wol2010_vpl VALUES ("RM11_31","075_11_31","ROM","11","31","31","Ñoom itam lànk nañu léegi, ngir mana bokk ak yéen yërmandey Yàlla. ");
INSERT INTO wol2010_vpl VALUES ("RM11_32","075_11_32","ROM","11","32","32","Kon Yàlla tëj na ñépp ci ngëmadi, ngir mana yërëm ñépp. ");
INSERT INTO wol2010_vpl VALUES ("RM11_33","075_11_33","ROM","11","33","33","Xelum Yàlla ni mu xóote, ak xam-xamam ni mu baree, ba raw xelum nit! Kan moo muus, ba xam dogalam? Walla nga am xel, ba nànd ay jëfam? ");
INSERT INTO wol2010_vpl VALUES ("RM11_34","075_11_34","ROM","11","34","34","Mbind mi dafa ne: «Ana ku xam xalaatu Boroom bi? Ku ko doon digal?» ");
INSERT INTO wol2010_vpl VALUES ("RM11_35","075_11_35","ROM","11","35","35","Te it: «Ku ko masa jox dara, ba mu war laa delloo?» ");
INSERT INTO wol2010_vpl VALUES ("RM11_36","075_11_36","ROM","11","36","36","Ndaxte ci moom la lépp sosoo, ci moom la lépp di jaar, ci moom la lépp di dellu. Moo yelloo ndam ba fàww! Amiin. ");
INSERT INTO wol2010_vpl VALUES ("RM12_1","075_12_1","ROM","12","1","1","Kon nag bokk yi, gannaaw yërmandey Yàlla baree na noonu, maa ngi leen di ñaan, ngeen jébbal ko seen yaram wépp. Na seen dund mel ni sarax su ñuy defal Yàlla, sarax su sell te neex ko. Loolu mooy njaamu, gi leen war. ");
INSERT INTO wol2010_vpl VALUES ("RM12_2","075_12_2","ROM","12","2","2","Bu leen àddina jay, waaye yeesluleen ci seen xel, ba soppiku, ngeen mana xam bu wér coobarey Yàlla, di lépp lu baax, neex ko te mat sëkk. ");
INSERT INTO wol2010_vpl VALUES ("RM12_3","075_12_3","ROM","12","3","3","Gannaaw Yàlla may na ma ciw yiwam, ma nekk ndawam, maa ngi leen di wax lii, kenn ku nekk ci yéen: buleen yég seen bopp, waaye ngeen am xalaat yu yem, méngook ngëm gi leen Yàlla sédd, ku nekk ak wàllam. ");
INSERT INTO wol2010_vpl VALUES ("RM12_4","075_12_4","ROM","12","4","4","Loolu, ci maanaa, mi ngi mel ni yaramu nit: yaram, lu cér yi baree bare, benn niroowul ak moroomam liggéey. ");
INSERT INTO wol2010_vpl VALUES ("RM12_5","075_12_5","ROM","12","5","5","Noonu itam nun ñi bokk ci Kirist, lu nu baree bare, benn lanu te danoo mànkoo. ");
INSERT INTO wol2010_vpl VALUES ("RM12_6","075_12_6","ROM","12","6","6","Kon gannaaw Yàlla séddale na ay mayam, ku nekk ak sa cér, nanu koy jëfandikoo. Ku Yàlla may, ngay waare kàddoom, nga wax ko kem sa ngëm; ");
INSERT INTO wol2010_vpl VALUES ("RM12_7","075_12_7","ROM","12","7","7","kuy topptoo yëfi mbooloo mi, nga takku ci; ku Yàlla may, ngay jàngle, nekk ci; ");
INSERT INTO wol2010_vpl VALUES ("RM12_8","075_12_8","ROM","12","8","8","kuy feddali ngëmu nit ñi ci Yàlla, nga sax ci; kuy séddoo alalam ak nit ñi, nga def ko ak xol bu laab; kuy jiite mbooloo mi, nga sawar ci; kuy dimbali ñi néew doole, nanga ci bég. ");
INSERT INTO wol2010_vpl VALUES ("RM12_9","075_12_9","ROM","12","9","9","Na seen cofeel di lu dëggu te baña nekk ngistal; araamal-leen lu bon te sax ci lu baax. ");
INSERT INTO wol2010_vpl VALUES ("RM12_10","075_12_10","ROM","12","10","10","Bëgganteleen ak xol bu leer, niy doomi ndey, te farlu ci teralante. ");
INSERT INTO wol2010_vpl VALUES ("RM12_11","075_12_11","ROM","12","11","11","Sawarleen te baña tayel, di jaamu Boroom bi ak seen xol bépp. ");
INSERT INTO wol2010_vpl VALUES ("RM12_12","075_12_12","ROM","12","12","12","Bégleen ci yaakaaru ëllëg te muñ bépp tiis, di sax ci ñaan Yàlla. ");
INSERT INTO wol2010_vpl VALUES ("RM12_13","075_12_13","ROM","12","13","13","Dimbalileen gaayi Yàlla yi ci seeni soxla, te saxoo dalal gan. ");
INSERT INTO wol2010_vpl VALUES ("RM12_14","075_12_14","ROM","12","14","14","Ku leen fitnaal, ñaanal-leen ko yiw, te bañ koo móolu. ");
INSERT INTO wol2010_vpl VALUES ("RM12_15","075_12_15","ROM","12","15","15","Bégandooleen ak ñi bég, te jooyandoo ak ñiy jooy. ");
INSERT INTO wol2010_vpl VALUES ("RM12_16","075_12_16","ROM","12","16","16","Bokkleen menn xel, tey baña yékkatiku, di yóotu daraja, waaye ngeen fonk ñi suufe; buleen teg seen bopp boroomi xel. ");
INSERT INTO wol2010_vpl VALUES ("RM12_17","075_12_17","ROM","12","17","17","Buleen feyante lu bon, waaye sàkkuleen seede su rafet ci kanam ñépp. ");
INSERT INTO wol2010_vpl VALUES ("RM12_18","075_12_18","ROM","12","18","18","Wutleena juboo ak ñépp, ba fa seen kàttan yem. ");
INSERT INTO wol2010_vpl VALUES ("RM12_19","075_12_19","ROM","12","19","19","Samay soppe, buleen di feyantoo, waaye bàyyileen lépp ci loxoy Yàlla, mi yelloo àtte; ndax Yàlla nee na ci Mbind mi: «Man maay àtte, maay fey jëf.» ");
INSERT INTO wol2010_vpl VALUES ("RM12_20","075_12_20","ROM","12","20","20","Waaye defleen lii: «Bu sa noon xiifee, may ko mu lekk; bu maree, may ko mu naan. Ndax boo ko defee, dinga ko rusloo.» ");
INSERT INTO wol2010_vpl VALUES ("RM12_21","075_12_21","ROM","12","21","21","Bu leen lu bon ëpp doole, waaye notleen ko ci def lu baax. ");
INSERT INTO wol2010_vpl VALUES ("RM13_1","075_13_1","ROM","13","1","1","Gannaaw loolu na nit ku nekk déggal ñi yore baat ci kanamam; ndaxte amul njiit lu fi Yàlla sampul. Njiit yépp nag Yàlla moo leen fi teg. ");
INSERT INTO wol2010_vpl VALUES ("RM13_2","075_13_2","ROM","13","2","2","Kon ku leen baña déggal, ndigalu Yàlla nga lànk; ku def loolu, yoon dina la dab. ");
INSERT INTO wol2010_vpl VALUES ("RM13_3","075_13_3","ROM","13","3","3","Kuy def lu baax warula ragal njiit li, kuy def lu bon moo ko wara ragal. Soo ko bëggee baña ragal nag, kon defal lu baax, te dina la tagg. ");
INSERT INTO wol2010_vpl VALUES ("RM13_4","075_13_4","ROM","13","4","4","Ndax Yàllaa ko dénk liggéey boobu ngir sa jàmm. Waaye sooy def lu bon, war ngaa ragal, ndax du cig neen la ame jaasiy àtte; jawriñu Yàlla la ngir wàcce meru Yàlla, ci fey ku def lu bon. ");
INSERT INTO wol2010_vpl VALUES ("RM13_5","075_13_5","ROM","13","5","5","Kon fokk ngeen déggal ko, waxuma sax ndax sañ-sañam boobu, waaye it ngir seen xel dal. ");
INSERT INTO wol2010_vpl VALUES ("RM13_6","075_13_6","ROM","13","6","6","Gannaaw Yàllaa sas njiit yi liggéey boobu, te ñi ngi ci, kon fàww ngeen fey galag. ");
INSERT INTO wol2010_vpl VALUES ("RM13_7","075_13_7","ROM","13","7","7","Joxleen ku nekk céram; ku ngeen wara fey galag, feyleen ko ko; ku ngeen wara fey juuti, feyleen ko ko; ku ngeen wara weg, wegleen ko; ku ngeen wara teral, teral-leen ko. ");
INSERT INTO wol2010_vpl VALUES ("RM13_8","075_13_8","ROM","13","8","8","Buleen ameel kenn dara, lu dul mbëggeel; ndax ku bëgg sa moroom, wàccoo nga ak yoonu Musaa. ");
INSERT INTO wol2010_vpl VALUES ("RM13_9","075_13_9","ROM","13","9","9","Ndaxte ndigali Yàlla yépp, yi deme ni: «Bul njaaloo, bul bóome, bul sàcc, bul bëgge,» walla leneen ndigal lu mu mana doon, wax jii moo leen ëmb: «Nanga bëgg sa moroom, ni nga bëgge sa bopp.» ");
INSERT INTO wol2010_vpl VALUES ("RM13_10","075_13_10","ROM","13","10","10","Ku bëgg sa moroom, doo ko tooñ; kon ku wéy ci mbëggeel matal nga yoonu Musaa. ");
INSERT INTO wol2010_vpl VALUES ("RM13_11","075_13_11","ROM","13","11","11","Te lii itam am na: xam ngeen bu baax jamono ji nu tollu; jamonoy yewwu jot na, ndax léegi sunu mucc gën na noo jege, ca ba nu dooree gëm. ");
INSERT INTO wol2010_vpl VALUES ("RM13_12","075_13_12","ROM","13","12","12","Guddi gi màggat na, bët a ngi bëgga set. Nanu bàyyi nag jëf yu lëndëm te ràngoo gànnaay yi nu Yàlla jox, ngir dund ci leer. ");
INSERT INTO wol2010_vpl VALUES ("RM13_13","075_13_13","ROM","13","13","13","Gannaaw nu ngi ci leer, na sunug dund rafet. Bunu naan sàngara ba màndi tey bànneexu; bunu njaaloo tey def i ñaawteef ak sunuy cér; bunu xuloo mbaa nuy ñeeyante. ");
INSERT INTO wol2010_vpl VALUES ("RM13_14","075_13_14","ROM","13","14","14","Waaye gànnaayooleen Yeesu Kirist Boroom bi, te baña topp seen bakkan ciy bëgg-bëggam yu bon. ");
INSERT INTO wol2010_vpl VALUES ("RM14_1","075_14_1","ROM","14","1","1","Gannaaw loolu ku ngëmam néew nangeen ko nangu, te baña werante ak moom ci lu lënt. ");
INSERT INTO wol2010_vpl VALUES ("RM14_2","075_14_2","ROM","14","2","2","Ndax am na ku xalaat ne man na lekk ñam wu nekk, fekk ku ngëmam néew du lekk yàpp, waaye léjum rekk lay lekk. ");
INSERT INTO wol2010_vpl VALUES ("RM14_3","075_14_3","ROM","14","3","3","Kiy lekk lu nekk, bumu xeeb ki ko dul def. Naka noonu itam ku dul lekk yàpp, bumu teg tooñ ki koy lekk; ndax Yàlla nangu na leen ñoom ñaar. ");
INSERT INTO wol2010_vpl VALUES ("RM14_4","075_14_4","ROM","14","4","4","Koo teg sa bopp, ba di ko teg tooñ? Jaamu jaambur la! Mu taxaw ci liggéeyam, mbaa mu sàggane ko, moom ak sangam la. Waaye dina jub, ndax Boroom bi am na dooley taxawal ko ci njub. ");
INSERT INTO wol2010_vpl VALUES ("RM14_5","075_14_5","ROM","14","5","5","Noonu itam am na ñiy tànn bés ak ñiy yemale bés yépp. Na ku nekk xam bu wér li muy def, te jàpp ci. ");
INSERT INTO wol2010_vpl VALUES ("RM14_6","075_14_6","ROM","14","6","6","Ndaxte kuy tànn bés, mu ngi koy def ngir màggal Boroom bi. Kiy lekk lu nekk it, mu ngi koy def ngir màggal Boroom bi; loolu leer na ndax day sant Yàlla. Te it ki baña lekk yàpp, mu ngi koy def ngir màggal Boroom bi, di ko sant. ");
INSERT INTO wol2010_vpl VALUES ("RM14_7","075_14_7","ROM","14","7","7","Kenn ci nun dundul ngir boppam, kenn deewul it ngir boppam. ");
INSERT INTO wol2010_vpl VALUES ("RM14_8","075_14_8","ROM","14","8","8","Danuy dund ngir màggal Boroom bi, dee it ngir màggal ko. Kon nag nuy dund mbaa nu dee, noo ngi ci Boroom bi. ");
INSERT INTO wol2010_vpl VALUES ("RM14_9","075_14_9","ROM","14","9","9","Loolu sax moo waral Kirist dee te dundaat, ngir mana nekk Boroomu ñi dee ak ñiy dund. ");
INSERT INTO wol2010_vpl VALUES ("RM14_10","075_14_10","ROM","14","10","10","Yaw nag lu tax ngay teg sa moroom tooñ? Lu tax nga koy xeeb? Xanaa nun ñépp, danu dul dajeji fa kanam Yàlla, ngir mu layoo ak nun? ");
INSERT INTO wol2010_vpl VALUES ("RM14_11","075_14_11","ROM","14","11","11","Ndaxte Mbind mi tëral na lii: «Boroom bi nee na: “Ni mu wóore ne maa ngi dund, ni la wóore ne, ñépp dinañu ma sukkal, te ku nekk seede ne maay Yàlla.”» ");
INSERT INTO wol2010_vpl VALUES ("RM14_12","075_14_12","ROM","14","12","12","Noonu ku nekk ci nun dinga làyyi fa Yàlla ci lépp loo masa def. ");
INSERT INTO wol2010_vpl VALUES ("RM14_13","075_14_13","ROM","14","13","13","Kon nanu bàyyee tegante tooñ, waaye nu fas yéenee moytu lépp lu nekk fiir guy yóbbe sunu moroom bàkkaar. ");
INSERT INTO wol2010_vpl VALUES ("RM14_14","075_14_14","ROM","14","14","14","Xam naa ne amul wenn ñam wu sellul, ndax Yeesu Boroom bi xamal na ma loolu. Waaye loo yaakaar ne sellul, ci yaw la sellul. ");
INSERT INTO wol2010_vpl VALUES ("RM14_15","075_14_15","ROM","14","15","15","Soo dee lekk luy indil sa moroom tiis, génn nga ci mbëggeel. Yaw nag bul réeral sa moroom ci sa ñam, ndax Kirist dee na ngir moom. ");
INSERT INTO wol2010_vpl VALUES ("RM14_16","075_14_16","ROM","14","16","16","Bu sa njariñ jur wax ju ñaaw. ");
INSERT INTO wol2010_vpl VALUES ("RM14_17","075_14_17","ROM","14","17","17","Ndaxte bokk ci nguuru Yàlla jotewul dara ak lu nuy lekk mbaa lu nuy naan. Nguuru Yàlla mooy jub ci kanam Yàlla te am mbég ak jàmm ci dooley Xel mu Sell mi. ");
INSERT INTO wol2010_vpl VALUES ("RM14_18","075_14_18","ROM","14","18","18","Kiy jaamoo noonu Kirist moo neex Yàlla ak nit ñi. ");
INSERT INTO wol2010_vpl VALUES ("RM14_19","075_14_19","ROM","14","19","19","Kon nag nanu wut luy indi jàmm, tey yékkati ngëmu sunu moroom. ");
INSERT INTO wol2010_vpl VALUES ("RM14_20","075_14_20","ROM","14","20","20","Bu sa ñam yàq jëfu Yàlla. Bépp ñam sell na ci kanam Yàlla. Ci lu wér! Waaye képp ku lekk luy yàq sa ngëmu moroom, def nga lu bon. ");
INSERT INTO wol2010_vpl VALUES ("RM14_21","075_14_21","ROM","14","21","21","Liy sa warugar mooy nga baña fiir sa moroom ci yàpp mbaa ci biiñ mbaa ci leneen lu mu mana doon. ");
INSERT INTO wol2010_vpl VALUES ("RM14_22","075_14_22","ROM","14","22","22","Su fekkee sa ngëm dëgër na, wone ko ci sa diggante ak Yàlla. Kiy nangu, te du ci sikkal boppam, kooku barkeel na. ");
INSERT INTO wol2010_vpl VALUES ("RM14_23","075_14_23","ROM","14","23","23","Waaye kuy lekk ñam te am ci xel ñaar, def nga bàkkaar, ndax sa ngëm yemu fa. Ndaxte jëf ju àndul ak ngëm, bàkkaar la. ");
INSERT INTO wol2010_vpl VALUES ("RM15_1","075_15_1","ROM","15","1","1","Nun ñi dëgër ci sunu ngëm, war nanoo nangu ñi seen ngëm néew te am ci lu ñuy sikki-sàkka, te baña yem ci wut sunu bànneex. ");
INSERT INTO wol2010_vpl VALUES ("RM15_2","075_15_2","ROM","15","2","2","Na ku nekk ci nun di wut lu neex moroomam ngir jariñ ko, ba mu gëna dëgër ci ngëmam. ");
INSERT INTO wol2010_vpl VALUES ("RM15_3","075_15_3","ROM","15","3","3","Ndaxte Kirist masula wut bànneexu boppam. Loolu la Mbind mi wax ne: «Lor yi ñu la saagaa, ci sama kaw lañu dal.» ");
INSERT INTO wol2010_vpl VALUES ("RM15_4","075_15_4","ROM","15","4","4","Ndaxte lépp lu ñu waxoon ci Mbind mi lu jiitu tey, dañu koo tëraloon, ngir nu sàkku ci xam-xam, xam-xam bu nuy may fit ak muñ, ak di feddali sunu yaakaar. ");
INSERT INTO wol2010_vpl VALUES ("RM15_5","075_15_5","ROM","15","5","5","Kon nag Yàlla miy maye muñ ak fit, na leen may, ngeen déggoo te nekk benn bu yellook li Kirist Yeesu wone. ");
INSERT INTO wol2010_vpl VALUES ("RM15_6","075_15_6","ROM","15","6","6","Ba tax nu bokk benn xalaat ak benn baat ci màggal Yàlla, Baayu Yeesu Kirist sunu Boroom. ");
INSERT INTO wol2010_vpl VALUES ("RM15_7","075_15_7","ROM","15","7","7","Moo tax nangoonteleen, bay màggal Yàlla, ni leen Kirist nangoo. ");
INSERT INTO wol2010_vpl VALUES ("RM15_8","075_15_8","ROM","15","8","8","Lii laay wax: Kirist ñëw na liggéeyal Yawut yi, ngir wone kóllëreg Yàlla ci matal dige, ya mu digoon maam ya. ");
INSERT INTO wol2010_vpl VALUES ("RM15_9","075_15_9","ROM","15","9","9","Ñëw na itam ngir ñi nekkul Yawut mana màggal Yàlla ndax yërmandeem. Moo tax Mbind mi ne: «Dinaa la màggal tey tagg saw tur ci kanam xeet yépp.» ");
INSERT INTO wol2010_vpl VALUES ("RM15_10","075_15_10","ROM","15","10","10","Mbind mi nee na it: «Yéen xeeti àddina, ñëwleen bànneexu ak xeet wi Yàlla tànnal boppam.» ");
INSERT INTO wol2010_vpl VALUES ("RM15_11","075_15_11","ROM","15","11","11","Mu dellooti ne: «Santleen Boroom bi, yéen waa àddina, te ñëw màggal ko, yéen xeet yépp.» ");
INSERT INTO wol2010_vpl VALUES ("RM15_12","075_15_12","ROM","15","12","12","Te it Esayi wax na ne: «Am na sëtu Isayi buy ñëw, dina yilif xeeti ñi dul Yawut, te ci moom lañuy wékk seen yaakaar.» ");
INSERT INTO wol2010_vpl VALUES ("RM15_13","075_15_13","ROM","15","13","13","Kon Yàlla miy maye yaakaar, na def ci seen xol mbég mu réy ak jàmm ju yaa ci seen kaw ngëm, ba ngeen am yaakaar ju mat sëkk ci dooley Xel mu Sell mi. ");
INSERT INTO wol2010_vpl VALUES ("RM15_14","075_15_14","ROM","15","14","14","Bokk yi, wóor na ma ne baax ngeen ba fa mbaax mana yem, fees dell ak xam-xam, ba mana jàngleente mbiri Yàlla ci seen biir. ");
INSERT INTO wol2010_vpl VALUES ("RM15_15","075_15_15","ROM","15","15","15","Bu sama kàddu diisee nag ci bataaxal bii, dara taxul lu dul bëgga yeesal seen xalaat, ndaxte Yàlla ci kaw yiwam daf maa sas, ");
INSERT INTO wol2010_vpl VALUES ("RM15_16","075_15_16","ROM","15","16","16","ma nekk jawriñu Kirist Yeesu, yebal ma ci àddina ci xeeti ñi dul Yawut. Liggéey bu sell laay def ngir Yàlla, ci xamle xibaaru jàmmam bi, ngir xeeti àddina sell ci dooley Xel mu Sell mi, ba neex Yàlla, mel ni sarax su ñu koy jébbal. ");
INSERT INTO wol2010_vpl VALUES ("RM15_17","075_15_17","ROM","15","17","17","Kon nag maa ngi bànneexu ci Kirist Yeesu ngir liggéey boobu ma Yàlla dénk. ");
INSERT INTO wol2010_vpl VALUES ("RM15_18","075_15_18","ROM","15","18","18","Awma fitu wax leneen nag, lu dul li Kirist jëf jaarale ko ci man, ngir xeeti àddina jébbalu ci moom; jëf na jaarale ci samay wax ak samay jëf, ");
INSERT INTO wol2010_vpl VALUES ("RM15_19","075_15_19","ROM","15","19","19","ci ay tegtal ak i kéemaan, sukkandikoo ci dooley Xelu Yàlla mi. Ba fi mu nekk nag yégle naa fu nekk xibaaru Kirist, li dale ci Yerusalem, jaar ci gox yépp, ba àgg diiwaanu Iliri. ");
INSERT INTO wol2010_vpl VALUES ("RM15_20","075_15_20","ROM","15","20","20","Sama yéene mooy xamle xibaaru turu Kirist fa mu eggagul, ndax bëggumaa yeggale sas wu keneen daloon. ");
INSERT INTO wol2010_vpl VALUES ("RM15_21","075_15_21","ROM","15","21","21","Li ma def nag, dëppoo na ak li Mbind mi wax ne: «Ñi yégagul mbiram dinañu ko yég, te ñi ko masula dégg, xam ko.» ");
INSERT INTO wol2010_vpl VALUES ("RM15_22","075_15_22","ROM","15","22","22","Bëggoon naa ñëw seetsi leen, fekk ay téq-téq ñoo ma téye ba tey. ");
INSERT INTO wol2010_vpl VALUES ("RM15_23","075_15_23","ROM","15","23","23","Waaye nag léegi bey naa sama sas ci gox yii. ");
INSERT INTO wol2010_vpl VALUES ("RM15_24","075_15_24","ROM","15","24","24","Bu may dem Espaañ nag, bëgg naa faa jaar, nuyu leen; ndaxte ay at a ngii maa ngi am yéene ju tar ci ñëw seetsi leen. Bëgg na maa nekk ci seen biir, ngir am bànneexu sotteente ak yéen xalaat ab diir, te it ngeen waajalal ma sama yoonu Espaañ. ");
INSERT INTO wol2010_vpl VALUES ("RM15_25","075_15_25","ROM","15","25","25","Waaye nag fi mu nekk maa ngi dem nii Yerusalem, ngir dimbaliji gaayi Yàlla yu sell ya fa nekk. ");
INSERT INTO wol2010_vpl VALUES ("RM15_26","075_15_26","ROM","15","26","26","Ndaxte waa Maseduwan ak waa Akayi ñi gëm, fas nañu yéeney sàkk ci seeni alal, yónnee ko, ngir dimbali ñi néew doole ci gaayi Yàlla yu sell, yi nekk Yerusalem. ");
INSERT INTO wol2010_vpl VALUES ("RM15_27","075_15_27","ROM","15","27","27","Yéene nañu ko, te it ci dëgg-dëgg bor la, bu ñu wara fey. Ndaxte gannaaw ñi gëm ci Yerusalem séddoo nañu ak ñi dul Yawut seen ngëm, kon xeet yooyu itam war nañoo séddoo ak ñoom seen alal. ");
INSERT INTO wol2010_vpl VALUES ("RM15_28","075_15_28","ROM","15","28","28","Kon nag waxtu wu ma noppee ci liggéey boobu, ba teg may gu tedd gii ci loxoy boroom, dinaa dem Espaañ, tey jaar fi yéen. ");
INSERT INTO wol2010_vpl VALUES ("RM15_29","075_15_29","ROM","15","29","29","Te wóor na maa ne bu ma agsee ci yéen, dinaa indaale barkeb Kirist bu mat sëkk. ");
INSERT INTO wol2010_vpl VALUES ("RM15_30","075_15_30","ROM","15","30","30","Gannaaw loolu bokk yi, maa ngi leen di ñaan ci turu sunu Boroom Yeesu Kirist ak ci bëggante, gi Xelu Yàlla mi def ci nun, ngeen defal ma lii: àndleen ak man, nu tuur sunu ñaq ci ñaan Yàlla. ");
INSERT INTO wol2010_vpl VALUES ("RM15_31","075_15_31","ROM","15","31","31","Ñaanal-leen ma, ngir ma mucc ci ñi gëmul ci waa Yude; te it gaayi Yàlla yu sell yu nekk ci Yerusalem nangu ndimbal, li ma leen di yóbbul. ");
INSERT INTO wol2010_vpl VALUES ("RM15_32","075_15_32","ROM","15","32","32","Dolli ci, Yàlla may ma, ma ñëw seetsi leen ak xol bu sedd, nu booloo yeeslu fa kanam Yàlla. ");
INSERT INTO wol2010_vpl VALUES ("RM15_33","075_15_33","ROM","15","33","33","Yal na Yàlla miy Boroom jàmm ànd ak yéen ñépp. Amiin. ");
INSERT INTO wol2010_vpl VALUES ("RM16_1","075_16_1","ROM","16","1","1","Bu nu weesoo loolu, maa ngi leen di dénk sunu jigéen Febe, miy liggéeyal mbooloom ñi gëm ci dëkku Señsere. ");
INSERT INTO wol2010_vpl VALUES ("RM16_2","075_16_2","ROM","16","2","2","Nangeen ko jàpp ci turu Boroom bi, ni ko gaayi Yàlla yi yelloo, te dimbali ko ci lépp lu mu aajowoo, ndaxte moom itam wax dëgg, dimbali na ñu bare, ba ci man mii di wax ak yéen. ");
INSERT INTO wol2010_vpl VALUES ("RM16_3","075_16_3","ROM","16","3","3","Nuyul-leen ma Pirsil ak Akilas, samay nawle ci liggéeyu Kirist Yeesu. ");
INSERT INTO wol2010_vpl VALUES ("RM16_4","075_16_4","ROM","16","4","4","Ñoom ñaar dem nañu, bay bëgga jaay seen bakkan ngir man; maa ngi leen di gërëm ci loolu, du man rekk sax, waaye itam mboolooy ñi gëm ci xeeti àddina sépp. ");
INSERT INTO wol2010_vpl VALUES ("RM16_5","075_16_5","ROM","16","5","5","Nuyul-leen ma it ñiy booloo ci seen kër. Maa ngi nuyu it Epaynet, mi jëkka gëm Kirist ci diiwaanu Asi; ");
INSERT INTO wol2010_vpl VALUES ("RM16_6","075_16_6","ROM","16","6","6","ak Maryaama, mi sonnoon lool ci yéen. ");
INSERT INTO wol2010_vpl VALUES ("RM16_7","075_16_7","ROM","16","7","7","Nuyul-leen ma it Andoronikus ak Yuñas, sama bokk, yi ñu ma booleeloon tëj; am nañu tur ci ndawi Yàlla yi, te ñoo ma jiitu sax ci gëm Kirist. ");
INSERT INTO wol2010_vpl VALUES ("RM16_8","075_16_8","ROM","16","8","8","Te fàttewuma Ampilyaatus, mi ma bëgg ci sama xol ngir Boroom bi. ");
INSERT INTO wol2010_vpl VALUES ("RM16_9","075_16_9","ROM","16","9","9","Nuyul-leen ma it Urban, sunu nawle ci liggéeyu Kirist, ak sama soppe Estakis; ");
INSERT INTO wol2010_vpl VALUES ("RM16_10","075_16_10","ROM","16","10","10","ak it Apeles, mi ngëmam dëggu, ba yelloo kóolute. Nuyul-leen ma it waa kër Aristobul, ");
INSERT INTO wol2010_vpl VALUES ("RM16_11","075_16_11","ROM","16","11","11","ak Erojon sama mbokk, ak waa kër Narsis, ñi ci Boroom bi. ");
INSERT INTO wol2010_vpl VALUES ("RM16_12","075_16_12","ROM","16","12","12","Maa ngi nuyu Tirifen, moom ak Tirifos, jigéen ñi sonn ci liggéeyu Boroom bi, ak it sama soppe Persidd, mi ci jeex tàkk. ");
INSERT INTO wol2010_vpl VALUES ("RM16_13","075_16_13","ROM","16","13","13","Maa ngi nuyu it Rufus, waa ji xolam seey ci Boroom bi, ak yaayam, mi ma féete woon it cérub ndey. ");
INSERT INTO wol2010_vpl VALUES ("RM16_14","075_16_14","ROM","16","14","14","Te fàttewuma Asànkirit, Felegon, Ermes, Patarobas, Ermas, ñoom ak mboolem bokk yépp. ");
INSERT INTO wol2010_vpl VALUES ("RM16_15","075_16_15","ROM","16","15","15","Nuyul-leen ma it Filolog ak Yuli, Nere ak jigéenam. Te fàttewuma Olimpas ak gaayi Yàlla yiy booloo ak ñoom ñépp. ");
INSERT INTO wol2010_vpl VALUES ("RM16_16","075_16_16","ROM","16","16","16","Te yéen bokk yi, saafoonteleen ak xol bu laab. Mboolooy ñi gëm Kirist yépp a ngi leen di nuyu. ");
INSERT INTO wol2010_vpl VALUES ("RM16_17","075_16_17","ROM","16","17","17","Bokk yi, maa ngi leen di dénk, ngeen moytu ñi leen di féewale, ba di leen jàddloo yoon wi, ciy wax lu juuyoo ak dëgg gi ngeen jàng. Dawleen leen ba sore. ");
INSERT INTO wol2010_vpl VALUES ("RM16_18","075_16_18","ROM","16","18","18","Ndax ñu deme noonu liggéeyaluñu Kirist sunu Boroom; seen bopp lañuy liggéeyal. Ñu ngi ñëw ak làmmiñ yu neex, di jay xol yu woyof yi, ba nax leen. ");
INSERT INTO wol2010_vpl VALUES ("RM16_19","075_16_19","ROM","16","19","19","Waaye seen dégg ndigal bir na ñépp, ba sama xol sedd lool ci yéen. Teewul nag damaa bëgg ngeen am xam-xam bu leer ci lu baax, te baña laal dara ci lu bon. ");
INSERT INTO wol2010_vpl VALUES ("RM16_20","075_16_20","ROM","16","20","20","Su ko defee Yàlla Boroom jàmm dina not Seytaane ci seeni tànk léegi. Yal na yiwu Yeesu sunu Boroom ànd ak yéen! ");
INSERT INTO wol2010_vpl VALUES ("RM16_21","075_16_21","ROM","16","21","21","Timote sama nawle bi may jàpple ci liggéey bi, mu ngi leen di nuyu, ak samay bokk Lusiyus, Yason ak Sosipater. ");
INSERT INTO wol2010_vpl VALUES ("RM16_22","075_16_22","ROM","16","22","22","Man Tersiyus mi bind bataaxal bii nag, maa ngi leen di nuyu ci turu Boroom bi. ");
INSERT INTO wol2010_vpl VALUES ("RM16_23","075_16_23","ROM","16","23","23","Gayus mu ngi leen di nuyu; moo may ganale ci këram, te foofa it la mbooloo mi di dajaloo. Erast miy topptoo mbiri xaalisu dëkk bi it, nuyu na leen, ak sunu mbokk Kartus. ");
INSERT INTO wol2010_vpl VALUES ("RM16_24","075_16_24","ROM","16","24","24","Yal na yiwu sunu Boroom Yeesu Kirist ànd ak yéen! Amiin. ");
INSERT INTO wol2010_vpl VALUES ("RM16_25","075_16_25","ROM","16","25","25","Santleen Yàlla, mi leen mana saxal bu wér ci dëggu xibaaru jàmm, bi may waare ci mbirum Yeesu Kirist! Nekkoon na kumpa gu làqu diirub ay ati at, ");
INSERT INTO wol2010_vpl VALUES ("RM16_26","075_16_26","ROM","16","26","26","waaye léegi nag Yàlla dindi na nu ci kumpa. Santaane na, nu yégle xibaar boobu ci xeeti àddina sépp, ci firi Mbindi yonent yi, ngir nit ñi man koo gëm, ba jébbalu. ");
INSERT INTO wol2010_vpl VALUES ("RM16_27","075_16_27","ROM","16","27","27","Yàlla mi jagoo xam-xam bépp, moom rekk moo yelloo ndam ba fàww, jaar ci Yeesu Kirist! Amiin. ");
INSERT INTO wol2010_vpl VALUES ("C11_1","076_1_1","1CO","1","1","1","Man Pool, ndawul Kirist Yeesu ci coobarey Yàlla, man ak Sosten sunu mbokk, ");
INSERT INTO wol2010_vpl VALUES ("C11_2","076_1_2","1CO","1","2","2","noo leen di bind, yéen mbooloom Yàlla, mi dëkk Korent. Nu ngi leen di nuyu, yéen ñi Yàlla sédde boppam jaare ci Kirist Yeesu, yéen ñi Yàlla woo, ngeen sell, boole leen ak ñi nekk ci àddina sépp tey tudd turu sunu Boroom Yeesu Kirist, miy seen Boroom, di sunu bos. ");
INSERT INTO wol2010_vpl VALUES ("C11_3","076_1_3","1CO","1","3","3","Yal na leen Yàlla sunu Baay ak Yeesu Kirist Boroom bi may yiw ak jàmm. ");
INSERT INTO wol2010_vpl VALUES ("C11_4","076_1_4","1CO","1","4","4","Duma jóg ci di sant Yàlla sama Boroom ci seen mbir ndax yiw, wi mu leen may ci seen bokk ci Kirist Yeesu. ");
INSERT INTO wol2010_vpl VALUES ("C11_5","076_1_5","1CO","1","5","5","Ndaxte ci yiwi Yàlla yépp ngeen woomle ci Kirist, muy ci wax, muy ci xam-xam. ");
INSERT INTO wol2010_vpl VALUES ("C11_6","076_1_6","1CO","1","6","6","Ndaxte li nu doon seedeel Kirist, Yàlla dëggal na ko ci yéen. ");
INSERT INTO wol2010_vpl VALUES ("C11_7","076_1_7","1CO","1","7","7","Noonu nag ñàkkuleen genn may léegi bi ngeen di séentu waxtu, wi sunu Boroom Yeesu Kirist di feeñ ci biir ndamam. ");
INSERT INTO wol2010_vpl VALUES ("C11_8","076_1_8","1CO","1","8","8","Kirist dina leen dooleel ba ca muj ga, ngir ngeen baña am wenn ŋàññ bés bu sunu Boroom Yeesu Kirist délsee. ");
INSERT INTO wol2010_vpl VALUES ("C11_9","076_1_9","1CO","1","9","9","Yàlla kuy sàmm kóllëre la, moom mi leen woo, ngir ngeen bokk ak Doomam Yeesu Kirist, sunu Boroom. ");
INSERT INTO wol2010_vpl VALUES ("C11_10","076_1_10","1CO","1","10","10","Waaye bokk yi, maa ngi leen di dénk ci turu sunu Boroom Yeesu Kirist, ngeen juboo te baña féewaloo ci seen biir. Waaye nangeen ànd te booloo, bokk xel, bokk xalaat. ");
INSERT INTO wol2010_vpl VALUES ("C11_11","076_1_11","1CO","1","11","11","Ndaxte bokk yi, waa kër Kelowe xamal nañu ma ne dangeen di xuloo. ");
INSERT INTO wol2010_vpl VALUES ("C11_12","076_1_12","1CO","1","12","12","Maa ngi ñëw ca wax ja: kenn ku nekk ci yéena ngi naan: «Man ci Pool laa bokk!» «Man ci Apolos!» «Man ci Sefas!» «Man ci Kirist!» ");
INSERT INTO wol2010_vpl VALUES ("C11_13","076_1_13","1CO","1","13","13","Ndax Kirist dafa xaajoo? Ndax Pool lañu daajoon ca bant ba, mu dee ngir yéen? Ndax sóob nañu leen ci ndox, ngir wone ne bokk ngeen ci Pool? ");
INSERT INTO wol2010_vpl VALUES ("C11_14","076_1_14","1CO","1","14","14","Maa ngi sant Yàlla ci li ma sóobul kenn ci yéen, ku dul Kirispus ak Gayus, ");
INSERT INTO wol2010_vpl VALUES ("C11_15","076_1_15","1CO","1","15","15","ngir kenn baña wax ne ci sama tur lañu ko sóob. ");
INSERT INTO wol2010_vpl VALUES ("C11_16","076_1_16","1CO","1","16","16","Ahakay! Sóob naa it ci ndox waa kër Estefanas. Waaye ci sama pàttaliku sóobuma keneen. ");
INSERT INTO wol2010_vpl VALUES ("C11_17","076_1_17","1CO","1","17","17","Ndaxte Kirist yebalu ma ngir may sóobe ci ndox, waaye da maa yebal, ngir may yégle xibaaru jàmm bi, te ma bañ koo def ak waxi xam-xamu nit, ngir baña ñàkkal faayda deewu Kirist ca bant ba. ");
INSERT INTO wol2010_vpl VALUES ("C11_18","076_1_18","1CO","1","18","18","Ndaxte yégleb deewu Kirist ca bant ba, ag ndof la ci ñiy sànku. Waaye ci nun ñi aw ci yoonu mucc gi, dooley Yàlla la. ");
INSERT INTO wol2010_vpl VALUES ("C11_19","076_1_19","1CO","1","19","19","Ndaxte Mbind mi nee na: «Dinaa folli xam-xamu boroom xam-xam yi, lem xalaati ñi am xel.» ");
INSERT INTO wol2010_vpl VALUES ("C11_20","076_1_20","1CO","1","20","20","Ana boroom xam-xam bi? Ana kaaŋ mi? Ana boroom làmmiñ wu neex wi ci àddina sii? Xanaa Yàlla wonewul ne xam-xamu àddina si ag ndof la? ");
INSERT INTO wol2010_vpl VALUES ("C11_21","076_1_21","1CO","1","21","21","Gannaaw àddina si ci xam-xamam demul ba xam Yàlla —te Yàllaa dogal loolu ci xam-xamam— soob na Yàlla mu musal ñi gëm, jaar ci yégleb xibaaru Kirist, fekk ag ndof la ci bëti nit. ");
INSERT INTO wol2010_vpl VALUES ("C11_22","076_1_22","1CO","1","22","22","Ndaxte Yawut yi ñu ngi laaj ay firnde; Gereg yi di wut xam-xam. ");
INSERT INTO wol2010_vpl VALUES ("C11_23","076_1_23","1CO","1","23","23","Waaye nun nu ngi yégle Kirist, mi ñu reyoon ca bant ba, te loolooy téq ngëmu Yawut yi, di ag ndof ci ñi dul Yawut. ");
INSERT INTO wol2010_vpl VALUES ("C11_24","076_1_24","1CO","1","24","24","Waaye ci ñi Yàlla woo, ñuy Yawut mbaa di Gereg, Kirist mooy dooley Yàlla, di xam-xamu Yàlla. ");
INSERT INTO wol2010_vpl VALUES ("C11_25","076_1_25","1CO","1","25","25","Li ñuy wax ag ndof ca wàllu Yàlla moo gëna tedd xam-xamu nit. Te li ñuy wax ñàkk dooley Yàlla moo ëpp kàttan dooley nit. ");
INSERT INTO wol2010_vpl VALUES ("C11_26","076_1_26","1CO","1","26","26","Bokk yi, seetleen seen nekkin, bi leen Yàlla di woo. Barewul woon ci yéen, ñi ñuy tudde ay boroom xam-xam mbaa ay boroom doole mbaa ñu rafet ab juddu. ");
INSERT INTO wol2010_vpl VALUES ("C11_27","076_1_27","1CO","1","27","27","Waaye li àddina teg ag ndof, Yàlla tànn na ko, ngir rusloo boroom xam-xam yi; te li àddina teg ag ñàkk doole, Yàlla tànn na ko, ngir rusloo boroom doole yi. ");
INSERT INTO wol2010_vpl VALUES ("C11_28","076_1_28","1CO","1","28","28","Li dul juddu bu rafet te mata xeeb ci àddina, Yàlla tànn na ko; Yàlla tànn na li nekkul, ngir neenal li nekk. ");
INSERT INTO wol2010_vpl VALUES ("C11_29","076_1_29","1CO","1","29","29","Noonu kenn du mana damu ca kanam Yàlla. ");
INSERT INTO wol2010_vpl VALUES ("C11_30","076_1_30","1CO","1","30","30","Waaye Yàlla moo def ba ngeen bokk ci Kirist, moom mi doon ci nun xam-xam bu jóge ca Yàlla, maanaam: sunu njubte, sunu sellaay, sunu njot. ");
INSERT INTO wol2010_vpl VALUES ("C11_31","076_1_31","1CO","1","31","31","Loolu dafa am, ngir li Mbind mi wax am, ne: «Kuy damu, na damu ci Boroom bi.» ");
INSERT INTO wol2010_vpl VALUES ("C12_1","076_2_1","1CO","2","1","1","Man ci sama bopp, bokk yi, bi ma ñëwee ci yéen, ngir yégle mbóoti Yàlla, ñëwuma ci ay wax yu neex ak xam-xam bu réy. ");
INSERT INTO wol2010_vpl VALUES ("C12_2","076_2_2","1CO","2","2","2","Dogu woon naa ci baña xam dara ci seen biir lu dul Yeesu Kirist, te muy ki ñu rey ca bant ba. ");
INSERT INTO wol2010_vpl VALUES ("C12_3","076_2_3","1CO","2","3","3","Bi ma teewee ci yéen, ànd naa ak ñàkk doole, ragal ak njàqare. ");
INSERT INTO wol2010_vpl VALUES ("C12_4","076_2_4","1CO","2","4","4","Li ma wax ak li ma waare, defuma ko ci làmmiñ wu neex, sukkandikoo ko ci xam-xamu nit, waaye ànd na ak ay firnde yu soqikoo ci kàttanu Xelum Yàlla, ");
INSERT INTO wol2010_vpl VALUES ("C12_5","076_2_5","1CO","2","5","5","ngir seen ngëm baña wékku ci xam-xamu nit ñi waaye mu wékku ci dooley Yàlla. ");
INSERT INTO wol2010_vpl VALUES ("C12_6","076_2_6","1CO","2","6","6","Moona am na xam-xam bu nuy yégal ñi mat, xam-xam bu bokkul ci àddina si, te njiiti àddina si xamuñu ko, ñoom ñi nara wéy. ");
INSERT INTO wol2010_vpl VALUES ("C12_7","076_2_7","1CO","2","7","7","Nu ngi yégle mbóotu xam-xamu Yàlla, mu nëbbu woon te Yàlla dogal ko ngir sunu ndam, laata àddina di sosu. ");
INSERT INTO wol2010_vpl VALUES ("C12_8","076_2_8","1CO","2","8","8","Kenn ci njiiti àddina amul woon xam-xam boobu. Su ñu ko amoon, kon duñu rey Boroom ndam li ci bant bi. ");
INSERT INTO wol2010_vpl VALUES ("C12_9","076_2_9","1CO","2","9","9","Waaye Mbind mi nee na: «Lu bët gisul, nopp déggu ko, xel xalaatu ko, loolu la Yàlla dencal ñi ko bëgg.» ");
INSERT INTO wol2010_vpl VALUES ("C12_10","076_2_10","1CO","2","10","10","Fekk nag nun la ko Yàlla won, jaarale ko ci Xelam. Xelum Yàlla mooy leeral lépp, ba ci xalaati Yàlla yi gëna xóot. ");
INSERT INTO wol2010_vpl VALUES ("C12_11","076_2_11","1CO","2","11","11","Kan ci nit ñi moo xam yëfi nit? Xanaa xelum nit mi nekk ci moom rekk a ko xam. Noonu it kenn xamul yëfi Yàlla, ku dul Xelum Yàlla. ");
INSERT INTO wol2010_vpl VALUES ("C12_12","076_2_12","1CO","2","12","12","Nun nag Xel mi nu jot, jógewul ci àddina, waaye Yàllaa nu ko sol. ");
INSERT INTO wol2010_vpl VALUES ("C12_13","076_2_13","1CO","2","13","13","Loolu nu Yàlla may, yéglewunu ko ci ay baat yu soqikoo ci xam-xamu nit, waaye nu ngi koy yégle ci baat, yi soqikoo ci Xelum Yàlla, di tekkantal yëfi Xelum Yàlla ci ay baat yu mu nu sol. ");
INSERT INTO wol2010_vpl VALUES ("C12_14","076_2_14","1CO","2","14","14","Nit kese du nangu yëfi Xelum Yàlla. Ag ndof lay doon ci moom; du ko mana nangu, ndaxte ku yor Xelum Yàlla rekk moo ko mana ràññale. ");
INSERT INTO wol2010_vpl VALUES ("C12_15","076_2_15","1CO","2","15","15","Nit ki yor Xelum Yàlla dafay àtte lépp; moom ci boppam, kenn du ko àtte. ");
INSERT INTO wol2010_vpl VALUES ("C12_16","076_2_16","1CO","2","16","16","Ndaxte Mbind mi nee na: «Ana ku xam xalaatu Boroom bi? Ku ko doon digal?» Waaye nun am nanu xalaatu Kirist. ");
INSERT INTO wol2010_vpl VALUES ("C13_1","076_3_1","1CO","3","1","1","Man nag bokk yi, manuma woona wax ak yéen ni ay nit ñuy déggal Xelum Yàlla, waaye waroon naa wax ak yéen ni ñuy topp seen nafsu, mel ni ay liir ci seen dund ci Kirist. ");
INSERT INTO wol2010_vpl VALUES ("C13_2","076_3_2","1CO","3","2","2","Nàmpaloon naa leen, waaye joxuma leen dugub, ndaxte àttanuleen ko woon, te ba léegi sax àttanuleen ko ");
INSERT INTO wol2010_vpl VALUES ("C13_3","076_3_3","1CO","3","3","3","ci li ngeen di topp seen nafsu. Bu ñeetaan ak xuloo amee ci seen biir, xanaa du loolu mooy wone ne dangeena topp seen nafsu, di doxale ni niti àddina? ");
INSERT INTO wol2010_vpl VALUES ("C13_4","076_3_4","1CO","3","4","4","Bu kenn yéglee ne: «Man ci Pool laa bokk,» keneen ne: «Man ci Apolos,» ndax jëfewuleen ni niti àddina rekk? ");
INSERT INTO wol2010_vpl VALUES ("C13_5","076_3_5","1CO","3","5","5","Kuy Apolos? Ak kuy Pool? Nun ay surga rekk lanu, yu ngeen jaare, ba gëm. Te Boroom bi moo sas ku nekk liggéeyam. ");
INSERT INTO wol2010_vpl VALUES ("C13_6","076_3_6","1CO","3","6","6","Maa jëmbët, Apolos suuxat, waaye Yàlla moo jebbil. ");
INSERT INTO wol2010_vpl VALUES ("C13_7","076_3_7","1CO","3","7","7","Ki jëmbët nag ak ki suuxat, kenn du ci dara, waaye Yàlla miy jebbil rekk moo am solo. ");
INSERT INTO wol2010_vpl VALUES ("C13_8","076_3_8","1CO","3","8","8","Ki jëmbët ak ki suuxat benn lañu. Teewul nag ku nekk dina jot yool bu tollook liggéeyam. ");
INSERT INTO wol2010_vpl VALUES ("C13_9","076_3_9","1CO","3","9","9","Nu ngi liggéeyandoo ci liggéeyu Yàlla; yéenay toolu Yàlla, yéenay taaxum Yàlla. ");
INSERT INTO wol2010_vpl VALUES ("C13_10","076_3_10","1CO","3","10","10","Man nag teg naa fondamaa bi, ni tabaxkat bu man liggéeyam, dëppook sas wi ma Yàlla jagleel ci kaw yiwam. Te keneen a ngi tabax ci kaw; waaye na ku nekk teeylu ci ni muy tabaxe. ");
INSERT INTO wol2010_vpl VALUES ("C13_11","076_3_11","1CO","3","11","11","Ci li jëm ci fondamaa bi, kenn manu fee tëral beneen bu dul bi fi xasa taxaw, muy Yeesu Kirist. ");
INSERT INTO wol2010_vpl VALUES ("C13_12","076_3_12","1CO","3","12","12","Ku tabax ci kaw fondamaa bi, wurus, xaalis, per, dénk, gittax walla boob, ");
INSERT INTO wol2010_vpl VALUES ("C13_13","076_3_13","1CO","3","13","13","sa liggéey dina fés, ndaxte bés baa koy xamle. Bés boobu dina fenk ni sawara, te sawara si dina nattu liggéeyu ku nekk. ");
INSERT INTO wol2010_vpl VALUES ("C13_14","076_3_14","1CO","3","14","14","Ku sa liggéey dëgër, dinga jot yool. ");
INSERT INTO wol2010_vpl VALUES ("C13_15","076_3_15","1CO","3","15","15","Waaye ku sa liggéey lakk, dinga ñàkk. Yaw ci sa bopp dinga mucc, waaye mel ni ku rëcc ci sawara si. ");
INSERT INTO wol2010_vpl VALUES ("C13_16","076_3_16","1CO","3","16","16","Xanaa xamuleen ne yéenay kër Yàlla, te Xelum Yàlla dëkk na ci yéen? ");
INSERT INTO wol2010_vpl VALUES ("C13_17","076_3_17","1CO","3","17","17","Ku yàq kër Yàlla gi, Yàlla dina la yàq, ndaxte kër Yàlla gi dafa sell, te yéenay kër googu. ");
INSERT INTO wol2010_vpl VALUES ("C13_18","076_3_18","1CO","3","18","18","Kon bu kenn nax boppam: su kenn ci yéen tegee boppam boroom xam-xam ci gis-gisu àddina sii, kooku na doon dof, ngir am xam-xam bu wóor. ");
INSERT INTO wol2010_vpl VALUES ("C13_19","076_3_19","1CO","3","19","19","Ndaxte xam-xamu àddina si, ndof la fa Yàlla. Moom la Mbind mi ne: «Yàlla jàpp na ñu muus ñi, ba seen fiir këppu ci seen kaw.» ");
INSERT INTO wol2010_vpl VALUES ("C13_20","076_3_20","1CO","3","20","20","Te it: «Boroom bi xam na xalaati boroom xam-xam yi; xam ne duñu mujj fenn.» ");
INSERT INTO wol2010_vpl VALUES ("C13_21","076_3_21","1CO","3","21","21","Kon nag bu kenn tiitaru ndax nit ñi, ndaxte yéena moom lépp, ");
INSERT INTO wol2010_vpl VALUES ("C13_22","076_3_22","1CO","3","22","22","muy Pool, di Apolos, di Sefas, di àddina, di dund, di dee, di lu am, di luy ñëw; lépp, yéena ko moom. ");
INSERT INTO wol2010_vpl VALUES ("C13_23","076_3_23","1CO","3","23","23","Yéen, Kirist a leen moom; Kirist, Yàllaa ko moom. ");
INSERT INTO wol2010_vpl VALUES ("C14_1","076_4_1","1CO","4","1","1","Nañu nu teg kon ay surgay Kirist, di ay jawriñ yuy xamle mbóoti Yàlla. ");
INSERT INTO wol2010_vpl VALUES ("C14_2","076_4_2","1CO","4","2","2","Li war ci jawriñ mooy mu takku ci liggéeyam. ");
INSERT INTO wol2010_vpl VALUES ("C14_3","076_4_3","1CO","4","3","3","Ngeen àtte ma walla ñeneen àtte ma, amaluma ko solo. Man sax duma àtte sama bopp. ");
INSERT INTO wol2010_vpl VALUES ("C14_4","076_4_4","1CO","4","4","4","Sama xel yeddu ma ci dara, waaye loolu taxul ma jub; ki may àtte mooy Boroom bi. ");
INSERT INTO wol2010_vpl VALUES ("C14_5","076_4_5","1CO","4","5","5","Looloo tax buleen daan kenn ci àtte, bala jamono ji di jot te Boroom bi ñëw. Mooy leeral yi nëbbu ci lëndëm, di làññi mébétu xol yi. Bu ko defee ku nekk dina jot ci Yàlla ngërëm li mu yelloo. ");
INSERT INTO wol2010_vpl VALUES ("C14_6","076_4_6","1CO","4","6","6","Bokk yi, ci loolu ma leen doon wax lépp nag, misaal naa leen ko ci Apolos ak ci man, ngir ngeen xool ci nun, ba xam li wax jii di tekki: «Bu seen xalaat weesu li Mbind mi wax.» Noonu kenn du màggal kii, suufeel ki ci des. ");
INSERT INTO wol2010_vpl VALUES ("C14_7","076_4_7","1CO","4","7","7","Ndaxte yaw, ku la def, ba nga gëna màgg ñi ci des? Loo am lu ñu la mayul? Te bu ñu la ko mayee, lu tax nga di ci tiitaru, mel ni mayuñu la ko? ");
INSERT INTO wol2010_vpl VALUES ("C14_8","076_4_8","1CO","4","8","8","Yéen suur ngeen xaat! Woomle ngeen xaat! Tàmbali ngeen di nguuru te agseegunu! Céy ni ma bëgge, ngeen di nguuru, ba nu mana bokk ak yéen di nguuru! ");
INSERT INTO wol2010_vpl VALUES ("C14_9","076_4_9","1CO","4","9","9","Xalaat naa ne, nun ndawi Kirist yi, Yàlla def na ba nu mel ni nit ñu ñu jàppe ci xare te mujj ci sàppe yi, ñu dogal seen dee, nuy ceetaanum mbindeef yépp, muy nit muy malaaka. ");
INSERT INTO wol2010_vpl VALUES ("C14_10","076_4_10","1CO","4","10","10","Nun teg nañu nu ni ay dof ndax Kirist, waaye yéen am ngeen xel ci Kirist. Néew nanu doole, waaye yéen am ngeen doole. Nawees na leen, waaye nun dañu noo xeeb. ");
INSERT INTO wol2010_vpl VALUES ("C14_11","076_4_11","1CO","4","11","11","Ba fii mu nekk, danoo xiif, mar te rafle; ñu ngi nuy dóor, te dëkkunu fenn; ");
INSERT INTO wol2010_vpl VALUES ("C14_12","076_4_12","1CO","4","12","12","nu ngi ñaq di jariñoo. Ku nu saaga, nu ñaanal la lu baax. Coono bu ñu nu teg, nu tegoo ko. ");
INSERT INTO wol2010_vpl VALUES ("C14_13","076_4_13","1CO","4","13","13","Ku nu ñaawal, nu tontu la tont lu rafet. Fi mu ne noo mujj di mbalitu àddina, di ñu ñàkk njariñ ci lépp. ");
INSERT INTO wol2010_vpl VALUES ("C14_14","076_4_14","1CO","4","14","14","Binduma leen loolu ngir ngeen am yeraange, waaye dama koo def ngir artu leen, ndaxte yéenay samay doom te bëgg naa leen. ");
INSERT INTO wol2010_vpl VALUES ("C14_15","076_4_15","1CO","4","15","15","Su ngeen amee fukki junniy njiit yu leen di sàmm ci Kirist, ba tey benn baay rekk ngeen am, ndaxte maa leen yégal xibaaru jàmm bi, ba jur leen ci Kirist. ");
INSERT INTO wol2010_vpl VALUES ("C14_16","076_4_16","1CO","4","16","16","Kon nag maa ngi leen di ñaan, ngeen roy ci man. ");
INSERT INTO wol2010_vpl VALUES ("C14_17","076_4_17","1CO","4","17","17","Looloo tax ma yebal ci yéen Timote, miy sama doomu diine, di doom ju takku te ma bëgg ko. Dina leen fàttali ni may dunde ci Kirist, te mu dëppook li may jàngle fu nekk ci mboolooy ñi gëm ñépp. ");
INSERT INTO wol2010_vpl VALUES ("C14_18","076_4_18","1CO","4","18","18","Am na ci seen biir ñuy tiitaru, di xalaat ne duma délseeti ci yéen. ");
INSERT INTO wol2010_vpl VALUES ("C14_19","076_4_19","1CO","4","19","19","Waaye bu soobee Boroom bi, léegi ma ñëw ci yéen te seet boroom tiitar yooyu; waxuma seen kàddu, seen doole laay seet. ");
INSERT INTO wol2010_vpl VALUES ("C14_20","076_4_20","1CO","4","20","20","Ndaxte nguuru Yàlla du waxi kese, waaye doole la. ");
INSERT INTO wol2010_vpl VALUES ("C14_21","076_4_21","1CO","4","21","21","Lu leen gënal? Ma ñëw ci yéen, yor ab yar, walla ma ànd ak mbëggeel, te lewet? ");
INSERT INTO wol2010_vpl VALUES ("C15_1","076_5_1","1CO","5","1","1","Dégg nanu sax ñu naan, am na kuy moy Yàlla ci seen biir, moy gu ni tollu, duñu ko gis sax ci ñi xamul Yàlla. Dem na, ba am ci yéen kuy séy ak jabaru baayam. ");
INSERT INTO wol2010_vpl VALUES ("C15_2","076_5_2","1CO","5","2","2","Moona yéen de, yéena ngi tiitaru. Waaye dangeena waroona am naqar, ba dàq kiy def loolu ci seen biir! ");
INSERT INTO wol2010_vpl VALUES ("C15_3","076_5_3","1CO","5","3","3","Man nag, jëmm ji sore na leen, waaye xel mi mu ngi ci yéen, te àtte naa xaat kiy def loolu, ni su ma teewoon ci seen biir. Dogal naa, ");
INSERT INTO wol2010_vpl VALUES ("C15_4","076_5_4","1CO","5","4","4","ngeen daje ci turu Boroom bi Yeesu, te sama xel teewe ko, ànd ak dooley Boroom bi Yeesu, ");
INSERT INTO wol2010_vpl VALUES ("C15_5","076_5_5","1CO","5","5","5","nu jébbal nit kooku Seytaane, yaramam yàqu, ngir ruuwam mucc keroog bésu Boroom bi. ");
INSERT INTO wol2010_vpl VALUES ("C15_6","076_5_6","1CO","5","6","6","Seen tiitar bi jekkul dara. Xanaa xamuleen ne tuuti lawiir day tax tooyalu fariñ bépp funki? ");
INSERT INTO wol2010_vpl VALUES ("C15_7","076_5_7","1CO","5","7","7","Ni ma leen ko mana misaale, jëleleen fi bépp lawiir bu yàgg, ngir ngeen sell ni tooyal bu bees bu amul lawiir, ndax nekk ngeen ko ba noppi. Ndaxte Kirist deeyal na nu ca bant ba, mel ni gàtt bu ñuy rendi, jébbal ko Yàlla ca màggalu bésu Mucc ba. ");
INSERT INTO wol2010_vpl VALUES ("C15_8","076_5_8","1CO","5","8","8","Kon nanu màggal sunu Màggal, waxuma ak lawiir bu màggat biy misaal kiñaan ak lu bon, waaye ak mburu mu amul lawiir, maanaam ci xol bu laab ak ci dëgg. ");
INSERT INTO wol2010_vpl VALUES ("C15_9","076_5_9","1CO","5","9","9","Bindoon naa leen, ngeen baña séq dara ak njaalookat yi. ");
INSERT INTO wol2010_vpl VALUES ("C15_10","076_5_10","1CO","5","10","10","Bëgguma ci woona limaale waa àddina, maanaam njaalookat yi, nay yi, njublaŋ yi ak xërëmkat yi. Su ngeen séqul ak ñooñu dara, kon fàww ngeen génn àddina. ");
INSERT INTO wol2010_vpl VALUES ("C15_11","076_5_11","1CO","5","11","11","Lii laa leen bëggoona wax: buleen séq dara ak ku ñu tudde mbokk mu gëm Kirist, te fekk day njaaloo walla mu nay walla muy xërëm walla muy xas nit walla muy màndi walla muy njublaŋ. Nit ku mel noonu moom, buleen bokk ak moom, sax far di lekk. ");
INSERT INTO wol2010_vpl VALUES ("C15_12","076_5_12","1CO","5","12","12","Ndax man maa wara àtte ñi bokkul ci mbooloom ñi gëm Kirist? Déedéet! Waaye ñi bokk ci seen mbooloo yéena leen wara àtte. ");
INSERT INTO wol2010_vpl VALUES ("C15_13","076_5_13","1CO","5","13","13","Ñi bokkul ci mbooloom ñi gëm, Yàlla moo leen di àtte. Waaye yéen, ni ko Mbind mi waxe: «Dàqleen ci seen biir kiy def lu bon.» ");
INSERT INTO wol2010_vpl VALUES ("C16_1","076_6_1","1CO","6","1","1","Te it bu kenn ci yéen amee lëj-lëj digganteem ak mbokku taalibeem, lu tax muy dem ca àttekaayi ñi xamul Yàlla, te baña dem ca gaayi Yàlla yi, ñu àtte ko? ");
INSERT INTO wol2010_vpl VALUES ("C16_2","076_6_2","1CO","6","2","2","Xanaa dangeena xamul ne, gaayi Yàlla yi ñooy àtteji àddina? Te ndegam yéenay àtteji àddina, lu tere ngeen mana àtte mbir yu ñàkk solo yi? ");
INSERT INTO wol2010_vpl VALUES ("C16_3","076_6_3","1CO","6","3","3","Xanaa xamuleen ne nooy àtteji malaaka yi? Waxatumaak mbiri àddina sii. ");
INSERT INTO wol2010_vpl VALUES ("C16_4","076_6_4","1CO","6","4","4","Bu ngeen amee ay lëj-lëj yu mel noonu, dangeen di wuti ay àttekat ci ay nit, ñi amul wenn yoon ci mbooloom ñi gëm! ");
INSERT INTO wol2010_vpl VALUES ("C16_5","076_6_5","1CO","6","5","5","Ma ne kon, war ngeena rus! Xanaa amul ci seen biir kenn ku am xel, ku mana àtte bokkam yi? ");
INSERT INTO wol2010_vpl VALUES ("C16_6","076_6_6","1CO","6","6","6","Waaye defuleen loolu; mbokk a ngi layoo ak moroomam, rax-ca-dolli ci kanam ñi gëmul lañu koy defe! ");
INSERT INTO wol2010_vpl VALUES ("C16_7","076_6_7","1CO","6","7","7","Layoo bi sax wone na ne bàyyi ngeen seen warugar. Lu tax muñuleen sax tooñ, yi ñu leen di tooñ? Lu tax far nanguwuleen, ñu sàcc leen? ");
INSERT INTO wol2010_vpl VALUES ("C16_8","076_6_8","1CO","6","8","8","Waaye yéen sax yéenay tooñ ak di sàcc, te seeni bokk ngeen koy def! ");
INSERT INTO wol2010_vpl VALUES ("C16_9","076_6_9","1CO","6","9","9","Xanaa xamuleen ne, ñi jubadi duñu bokk ci nguuru Yàlla? Bu leen ci kenn nax: ñiy doxaan walla xërëmkat yi ak njaalookat yi ak góor-jigéen ñi ak ñi ànd ak ñoom, ");
INSERT INTO wol2010_vpl VALUES ("C16_10","076_6_10","1CO","6","10","10","walla sàcc yi ak ñu bëgge ñi ak màndikat yi ak ñiy xaste ak njublaŋ yi, duñu bokk ci nguuru Yàlla. ");
INSERT INTO wol2010_vpl VALUES ("C16_11","076_6_11","1CO","6","11","11","Te am na ñu meloon noonu ci yéen. Waaye Yàlla fóotal na leen seeni bàkkaar, sellal leen, àtte leen ni ñu jub, ci turu Boroom bi Yeesu Kirist ak ci dooley Xelum Yàlla, sunu Boroom. ");
INSERT INTO wol2010_vpl VALUES ("C16_12","076_6_12","1CO","6","12","12","Am na ci yéen ñu naan: «Sañ naa lépp.» Waaw, waaye du lépp a jariñ nit. «Sañ naa lépp,» waaye duma bàyyi dara, mu not ma. ");
INSERT INTO wol2010_vpl VALUES ("C16_13","076_6_13","1CO","6","13","13","Am na ci yéen ñu naan: «Ñam mooy jariñ biir, te biir ay jariñoo ñam.» Waaw, te Yàlla dina leen yàq, ñoom ñaar yépp. Waaye sàkkuñu yaram ngir moy Yàlla; dañu koo sàkk, ngir muy jariñ Boroom bi, Boroom bi di ko jariñoo. ");
INSERT INTO wol2010_vpl VALUES ("C16_14","076_6_14","1CO","6","14","14","Te Yàlla, mi dekkal Boroom bi, dina dekkal it sunu yaram jaare ko ci dooleem. ");
INSERT INTO wol2010_vpl VALUES ("C16_15","076_6_15","1CO","6","15","15","Xanaa xamuleen ne, seen yaram ñooy céri Kirist? Ndax kon damay jël céri Kirist, def ko céri jigéeni moykat? Mukk! ");
INSERT INTO wol2010_vpl VALUES ("C16_16","076_6_16","1CO","6","16","16","Xanaa xamuleen ne, kuy ànd ak jigéen juy moy dafay booloo ak moom, nekk benn? Ndaxte Mbind mi nee na: «Ñoom ñaar dinañu doon benn.» ");
INSERT INTO wol2010_vpl VALUES ("C16_17","076_6_17","1CO","6","17","17","Waaye nag kuy ànd ak Boroom bi, xel yi dañuy booloo, nekk benn. ");
INSERT INTO wol2010_vpl VALUES ("C16_18","076_6_18","1CO","6","18","18","Dawleen njaaloo! Bépp bàkkaar bu nit mana def, du laal yaramam, waaye nag kuy njaaloo, dafay bàkkaar, di lor yaramam. ");
INSERT INTO wol2010_vpl VALUES ("C16_19","076_6_19","1CO","6","19","19","Xanaa xamuleen ne, seen yaram mooy kër Yàlla gi? Gannaaw Xel mu Sell maa ngi ci yéen, te Yàllaa leen ko may, kon moomuleen seen bopp, ");
INSERT INTO wol2010_vpl VALUES ("C16_20","076_6_20","1CO","6","20","20","ndaxte Yàlla jot na leen ak njég lu réy. Kon nag màggal-leen Yàlla ci seen yaram. ");
INSERT INTO wol2010_vpl VALUES ("C17_1","076_7_1","1CO","7","1","1","Nanu jàll nag léegi ci laaj, yi ngeen ma doon bind, ci baña ànd ak jigéen, ndax lu baax la ci góor. ");
INSERT INTO wol2010_vpl VALUES ("C17_2","076_7_2","1CO","7","2","2","Lii mooy sama xalaat: moy gu bare gi tax na ba, na góor gu nekk am jabaram, jigéen ju nekk am jëkkëram. ");
INSERT INTO wol2010_vpl VALUES ("C17_3","076_7_3","1CO","7","3","3","Jëkkër war na def warugaru jëkkër ci jabaram; jabar it def warugaru jabar ci jëkkëram. ");
INSERT INTO wol2010_vpl VALUES ("C17_4","076_7_4","1CO","7","4","4","Jigéen ji amul sañ-sañ ci yaramam moom kenn; jëkkëram moo ko moom. Niki noonu it jëkkër ji amul sañ-sañ ci yaramam; jabaram moo ko moom. ");
INSERT INTO wol2010_vpl VALUES ("C17_5","076_7_5","1CO","7","5","5","Bu kenn tere boppam moroomam, su dul ne dangeena mànkoo ci def noonu ab diir, ngir gëna mana wéetal Yàlla ci ñaan. Waaye su loolu weesoo, nangeen doxal yoonu séy; lu ko moy, Seytaane dina leen fiir ndax seen ñàkk maandute. ");
INSERT INTO wol2010_vpl VALUES ("C17_6","076_7_6","1CO","7","6","6","Li ma leen di wax fii du ndigal, waaye dama leen di xamal li ñu leen may, ngeen def ko. ");
INSERT INTO wol2010_vpl VALUES ("C17_7","076_7_7","1CO","7","7","7","Ndaxte dëgg-dëgg su ma sañoon, kon ñépp mel ni man; waaye ku nekk ak li la Yàlla jagleel, kii ak may gii, kee ak may gale. ");
INSERT INTO wol2010_vpl VALUES ("C17_8","076_7_8","1CO","7","8","8","Lii laay yégal ñi séyul ak it ñi seen jëkkër dee: baax na ci yéen, su fekkee dangeena toog rekk ni man, baña séy. ");
INSERT INTO wol2010_vpl VALUES ("C17_9","076_7_9","1CO","7","9","9","Waaye su ngeen manula téye seen bopp, nangeen séy, ndaxte séy moo gën xemmem di leen gaañ. ");
INSERT INTO wol2010_vpl VALUES ("C17_10","076_7_10","1CO","7","10","10","Ñi séy nag, maa ngi leen di jox ndigal lii —Boroom bi moo ko waxoon, du man— jigéen ju séy warula teqalikoo ak jëkkëram. ");
INSERT INTO wol2010_vpl VALUES ("C17_11","076_7_11","1CO","7","11","11","Te bu teqalikoo ak moom, bumu séyaat, mbaa boog na juboo ak jëkkëram. Te bu jëkkër ji fase jabaram. ");
INSERT INTO wol2010_vpl VALUES ("C17_12","076_7_12","1CO","7","12","12","Ñi ci des nag, lii laa leen di wax —Boroom bi waxu ko woon— su nit ku gëm Kirist amee jabar ju gëmul, te mu nangoo séy ak moom, waru koo fase. ");
INSERT INTO wol2010_vpl VALUES ("C17_13","076_7_13","1CO","7","13","13","Naka noonu it su jigéen ju gëm Kirist amee jëkkër ju gëmul, te mu nangoo nekk ak moom, warula tas. ");
INSERT INTO wol2010_vpl VALUES ("C17_14","076_7_14","1CO","7","14","14","Li tax ma wax ko moo di, jëkkër ji gëmul, Yàlla sellal na ko, ndax li mu ànd ak jabaram. Te it jigéen ji gëmul, Yàlla sellal na ko, ndax li mu ànd ak jëkkëram ji gëm; lu ko moy, seeni doom dinañu am sobe, te fekk dañoo sell. ");
INSERT INTO wol2010_vpl VALUES ("C17_15","076_7_15","1CO","7","15","15","Waaye nag, su fekkee ki gëmul bëgg na dem, na dem. Ci wàll woowu nag, ki gëm Kirist, muy jëkkër ji walla jabar ji, amul benn tënk, ndaxte Yàlla moo leen woo ngir ngeen dund ci jàmm. ");
INSERT INTO wol2010_vpl VALUES ("C17_16","076_7_16","1CO","7","16","16","Loo ci xam, yaw jigéen ji, ndax dinga gëmloo sa jëkkër Musalkat bi walla déet? Loo ci xam yaw jëkkër ji it, ndax dinga gëmloo sa jabar Musalkat bi walla déet? ");
INSERT INTO wol2010_vpl VALUES ("C17_17","076_7_17","1CO","7","17","17","Ku nekk nag na dund, ni ko ko Boroom bi jagleele, mu méngoo ak ni mu meloon, bi ko Yàlla wooyee. Moom laay tëral ci mboolooy ñi gëm yépp. ");
INSERT INTO wol2010_vpl VALUES ("C17_18","076_7_18","1CO","7","18","18","Ki xaraf, bi ko Yàlla wooyee, warula jéema far màndargam xaraf bi. Ki xaraful, bi ko Yàlla wooyee, aajowul mu xaraf. ");
INSERT INTO wol2010_vpl VALUES ("C17_19","076_7_19","1CO","7","19","19","Xaraf ak ñàkka xaraf lépp a yem; li am solo moo di topp ndigali Yàlla. ");
INSERT INTO wol2010_vpl VALUES ("C17_20","076_7_20","1CO","7","20","20","Na kenn ku nekk jàpp ci li mu nekkoon, bi ko Yàlla wooyee. ");
INSERT INTO wol2010_vpl VALUES ("C17_21","076_7_21","1CO","7","21","21","Ndax jaam nga woon, bi la Yàlla wooyee? Na ci sa xel dal. Waaye soo amee bunt, ba yiwiku, nanga ci jaar. ");
INSERT INTO wol2010_vpl VALUES ("C17_22","076_7_22","1CO","7","22","22","Ku nekkoon jaam, bi la Boroom bi wooyee, Boroom bi goreel na la. Ba tey it ku nekkoon gor, bi ñu la wooyee, jaamu Kirist nga. ");
INSERT INTO wol2010_vpl VALUES ("C17_23","076_7_23","1CO","7","23","23","Gannaaw Yàlla jot na leen ak njég lu réy, buleen doon jaamub nit. ");
INSERT INTO wol2010_vpl VALUES ("C17_24","076_7_24","1CO","7","24","24","Bokk yi, fàww ku nekk wéy ca kanam Yàlla ci fànn ga mu nekkoon, bi ko Yàlla wooyee. ");
INSERT INTO wol2010_vpl VALUES ("C17_25","076_7_25","1CO","7","25","25","Ci li jëm ci janq yi, awma ndigalu Boroom bi, waaye maa ngi joxe sama xalaat, ni ku ñu wóolu ndax li ma jot yërmandey Boroom bi. ");
INSERT INTO wol2010_vpl VALUES ("C17_26","076_7_26","1CO","7","26","26","Bu nu seetee tiis wii fi teew nag, defe naa ne li baax ci nit, moo di mu sax ci li mu nekk. ");
INSERT INTO wol2010_vpl VALUES ("C17_27","076_7_27","1CO","7","27","27","Ndax takk nga jabar? Bul wuta tàggook moom. Ndax takkuloo jabar? Bul wut jabar. ");
INSERT INTO wol2010_vpl VALUES ("C17_28","076_7_28","1CO","7","28","28","Waaye nag boo séyee, defoo bàkkaar, te bu janq séyee, deful bàkkaar. Waaye ñi séy dinañu am naqar ci àddina, te naqar woowu dama leen ko bëggoona fanqal, yéen ñi séyagul. ");
INSERT INTO wol2010_vpl VALUES ("C17_29","076_7_29","1CO","7","29","29","Lii laa bëgga wax, bokk yi: diir bu gàtt rekk a fi des. Lu weesu tey, na góor ñi am jabar di def, ni bu ñu ko amul woon; ");
INSERT INTO wol2010_vpl VALUES ("C17_30","076_7_30","1CO","7","30","30","ñiy jooy, mel ni ñu jooyul; ñiy bég, mel ni ñu bégul; ñiy jënd, ni ñu moomul li ñu jënd; ");
INSERT INTO wol2010_vpl VALUES ("C17_31","076_7_31","1CO","7","31","31","ñiy jariñoo àddina, bañ cee xér. Ndaxte àddina sii, ci ni mu mel, dootul yàggati. ");
INSERT INTO wol2010_vpl VALUES ("C17_32","076_7_32","1CO","7","32","32","Bëggoon naa, ngeen baña am benn xalaat. Góor gu takkul jabar dafay bàyyi xel ci mbiri Boroom bi, di wuta neex Boroom bi. ");
INSERT INTO wol2010_vpl VALUES ("C17_33","076_7_33","1CO","7","33","33","Waaye ku takk jabar, fàww mu bàyyi xel ci mbiri àddina si, ak nu mu mana neexe jabaram, ");
INSERT INTO wol2010_vpl VALUES ("C17_34","076_7_34","1CO","7","34","34","te noonu dafay daldi bare soxla. Jigéen ju séyul, walla janq, dafay bàyyi xel ci mbiri Boroom bi— bëgg koo jox yaramam ak xelam. Waaye jigéen ji séy dafay bàyyi xel ci mbiri àddina, ak nu mu mana neexe jëkkëram. ");
INSERT INTO wol2010_vpl VALUES ("C17_35","076_7_35","1CO","7","35","35","Seen njariñ a tax ma wax lii, du ngir teg leen yen bu ngeen àttanul, waaye ngeen mana jàppandil Boroom bi ci njaamu gu rafet gu àndul ak genn njaaxle. ");
INSERT INTO wol2010_vpl VALUES ("C17_36","076_7_36","1CO","7","36","36","Nanu jàll nag ci mbiri kiy takk ngoro te amul pastéefu takk ndaw si. Su fekkee ne waxambaane wi xalaat na ne jëfewul nu jekk ak janq bi, fekk muy wees ag ndawam, te mu xalaat ne dafa koo wara takk, kon na ko takk, ni mu ko bëgge; deful bàkkaar. ");
INSERT INTO wol2010_vpl VALUES ("C17_37","076_7_37","1CO","7","37","37","Waaye nag su dogoo dëgg ci baña takk, fekk sagoom rekk a tax te kenn tegu ko ko, kon ba tey def na lu baax. ");
INSERT INTO wol2010_vpl VALUES ("C17_38","076_7_38","1CO","7","38","38","Noonu ku takk as ndawam def na lu baax, rawatina nag ku takkul. ");
INSERT INTO wol2010_vpl VALUES ("C17_39","076_7_39","1CO","7","39","39","Jigéen ji séy dina ànd ak jëkkëram giiru dundam. Waaye su jëkkër ji faatoo, man na séy ak ku ko neex, su fekkee ne góor gu gëm la. ");
INSERT INTO wol2010_vpl VALUES ("C17_40","076_7_40","1CO","7","40","40","Moona nag dina gëna bég, bu toogee noonu rekk. Loolu mooy sama xalaat, te defe naa ne man it am naa Xelum Yàlla. ");
INSERT INTO wol2010_vpl VALUES ("C18_1","076_8_1","1CO","8","1","1","Léegi nag, ci li jëm ci yàpp wi ñu jébbal xërëm yi: nun ñépp am nanu xam-xam, loolu dëgg la. Xam-xam day tax ba nit yég boppam, waaye mbëggeel day yékkati ngëm. ");
INSERT INTO wol2010_vpl VALUES ("C18_2","076_8_2","1CO","8","2","2","Ku xalaat ne xam nga dara, sa xam-xam bënnagul. ");
INSERT INTO wol2010_vpl VALUES ("C18_3","076_8_3","1CO","8","3","3","Waaye ku bëgg Yàlla, Yàlla xam la. ");
INSERT INTO wol2010_vpl VALUES ("C18_4","076_8_4","1CO","8","4","4","Kon nag ci li jëm ci lekk yàpp wu ñu jébbal xërëm yi, xam nanu ne xërëm du dara ci àddina; xam nanu itam ne Yàlla kenn rekk la. ");
INSERT INTO wol2010_vpl VALUES ("C18_5","076_8_5","1CO","8","5","5","Su fekkee ne am na sax yu ñuy teg Yàlla, muy ci asamaan mbaa ci suuf —ndaxte am na yu bare yu ñu faral di bokkaaleel Yàlla ak Boroom bi— ");
INSERT INTO wol2010_vpl VALUES ("C18_6","076_8_6","1CO","8","6","6","ba tey ci nun, jenn Yàlla rekk a am, muy Baay bi; lépp a ngi jóge ci moom te moom lanu nekkal. Te it benn Boroom rekk a am, muy Yeesu Kirist; lépp a ngi jaare ci moom, te nun it nu ngi dund jaare ci moom. ");
INSERT INTO wol2010_vpl VALUES ("C18_7","076_8_7","1CO","8","7","7","Waaye ñépp xamuñu loolu. Am na ñu tàmmoon xërëm yi, te léegi, bu ñu lekkatee yàppu sarax yi, dañuy xalaat ne xërëm lañu ko jagleel. Seen xel dafa leen di yedd, ndaxte ci seen ñàkka xam dañuy foog ne taq nañu sobe ndax ñam woowu. ");
INSERT INTO wol2010_vpl VALUES ("C18_8","076_8_8","1CO","8","8","8","Waaye ñam manula tax nu neex Yàlla. Su nu ci lekkee, du yokk dara ci nun. Su nu ci lekkul, du nu wàññi dara. ");
INSERT INTO wol2010_vpl VALUES ("C18_9","076_8_9","1CO","8","9","9","Waaye moytuleen, ba sañ-sañ bi ngeen am, baña yóbbe bàkkaar ñi seen ngëm néew. ");
INSERT INTO wol2010_vpl VALUES ("C18_10","076_8_10","1CO","8","10","10","Su amee ku ngëmam néew, mu gis la, yaw mi bare xam-xam, nga toog di lekk ca màggalukaayu xërëm ya, ndax du ko xiir mu lekk yàppu sarax? ");
INSERT INTO wol2010_vpl VALUES ("C18_11","076_8_11","1CO","8","11","11","Noonu sa xam-xam dina lor kooku ngëmam néew, fekk sa mbokk moomu, Kirist dee na ngir moom! ");
INSERT INTO wol2010_vpl VALUES ("C18_12","076_8_12","1CO","8","12","12","Su ngeen bàkkaaree, ba tooñ bokk yi néew ngëm, di nëxal seen xel, bàkkaar ngeen ba tooñ Kirist. ");
INSERT INTO wol2010_vpl VALUES ("C18_13","076_8_13","1CO","8","13","13","Kon bu sama mbokk sóoboo ci bàkkaar ndax ñam wi ma lekk, dootuma lekk mukk yàpp, ngir baña sóob ci bàkkaar sama mbokk mi. ");
INSERT INTO wol2010_vpl VALUES ("C19_1","076_9_1","1CO","9","1","1","Ndax awma ndogal ci li may def? Ndax duma ndawul Kirist? Ndax gisuma Yeesu sunu Boroom? Xanaa du yéena soqikoo ci liggéey bi ma Boroom bi sant? ");
INSERT INTO wol2010_vpl VALUES ("C19_2","076_9_2","1CO","9","2","2","Su ma ñenn ñi tegul ndaw, moom laa ci yéen, ndaxte yéenay firnde jiy wone ne ndawul Boroom bi dëgg laa. ");
INSERT INTO wol2010_vpl VALUES ("C19_3","076_9_3","1CO","9","3","3","Nii laay tontoo ñi may àtte: ");
INSERT INTO wol2010_vpl VALUES ("C19_4","076_9_4","1CO","9","4","4","Xanaa sañunoo lekk ak a naan? ");
INSERT INTO wol2010_vpl VALUES ("C19_5","076_9_5","1CO","9","5","5","Xanaa sañunoo indaale soxna su gëm Kirist, ni yeneen ndawul Kirist ak doomi ndeyu Boroom bi ak Sefas sax? ");
INSERT INTO wol2010_vpl VALUES ("C19_6","076_9_6","1CO","9","6","6","Walla boog man ak Barnabas rekk noo wara daan sunu doole? ");
INSERT INTO wol2010_vpl VALUES ("C19_7","076_9_7","1CO","9","7","7","Kan moo masa solu soldaar ci pexey boppam? Kan mooy bey tool te du ci jariñu? Walla kan mooy sàmm jur te du naan ca soow ma? ");
INSERT INTO wol2010_vpl VALUES ("C19_8","076_9_8","1CO","9","8","8","Lii may wax, du ci yëfi doom Aadama rekk laa ko jukkee; xanaa du yoon wi it moo ko santaane? ");
INSERT INTO wol2010_vpl VALUES ("C19_9","076_9_9","1CO","9","9","9","Ndaxte bind nañu ci yoonu Musaa ne: «Bul sunjuñ gémmiñu nag wu ñu takk ci bojjukaay.» Ndax mooy tekki nag ne, Yàlla dafa bàyyi xel nag yi? ");
INSERT INTO wol2010_vpl VALUES ("C19_10","076_9_10","1CO","9","10","10","Walla boog xanaa nun noo moom wax jooju? Waaw, noo tax ñu bind loolu. Noonu kuy bey war na am yaakaar, te kuy bojj di yaakaara jot wàllam. ");
INSERT INTO wol2010_vpl VALUES ("C19_11","076_9_11","1CO","9","11","11","Nu ji ci yéen yëfi Xelum Yàlla, ba noppi góobe ci yéen yëfi àddina, ndax loolu dafa ëpp li nu wara séentu? ");
INSERT INTO wol2010_vpl VALUES ("C19_12","076_9_12","1CO","9","12","12","Ndegam ñeneen a am sañ-sañ boobu ci yéen, nun kon waxi-noppi. Waaye nag jariñoowunu sañ-sañ boobu. Danuy far muñ lépp, ngir baña indi ndog ci yoonu xibaaru jàmm bu Kirist bi. ");
INSERT INTO wol2010_vpl VALUES ("C19_13","076_9_13","1CO","9","13","13","Xanaa xamuleen ne, ñiy liggéeyal yëf yu sell yi, dañuy lekk ñam, wi ci kër Yàlla gi, te ñiy liggéey ci sarxalukaay bi, dañuy jot seen wàll ci sarax yi? ");
INSERT INTO wol2010_vpl VALUES ("C19_14","076_9_14","1CO","9","14","14","Naka noonu it Boroom bi digle na ne, ñiy yégle xibaaru jàmm bi, nanu ci dund. ");
INSERT INTO wol2010_vpl VALUES ("C19_15","076_9_15","1CO","9","15","15","Waaye man jariñoowuma benn ci sañ-sañ yooyu, te binduma yëf yooyu, ngir ngeen di ma defal yu ni mel. Dee sax moo ma ko gënal— kenn du jële ci man mbir moomu may kañoo! ");
INSERT INTO wol2010_vpl VALUES ("C19_16","076_9_16","1CO","9","16","16","Su may yégle xibaaru jàmm bi, manuma cee kañu. Sas la, wu ñu ma sas. Dinaa torox, su ma yéglewul xibaaru jàmm bi! ");
INSERT INTO wol2010_vpl VALUES ("C19_17","076_9_17","1CO","9","17","17","Su doon ci sama coobare laa yégle xibaaru jàmm bi, man naa ci séentu yool. Waaye defuma ko ci sama coobare, ndaxte sas la, wu ñu ma sas. ");
INSERT INTO wol2010_vpl VALUES ("C19_18","076_9_18","1CO","9","18","18","Kon nag lan mooy sama yool? Xanaa di yégle xibaaru jàmm bi ci dara, te baña jariñoo sañ-sañ boobu ma ci yelloo. ");
INSERT INTO wol2010_vpl VALUES ("C19_19","076_9_19","1CO","9","19","19","Gor laa te kenn moomu ma; teewul def naa sama bopp jaamu ñépp, ngir mana gindi nit ñu bare ci Kirist. ");
INSERT INTO wol2010_vpl VALUES ("C19_20","076_9_20","1CO","9","20","20","Ci biir Yawut yi, sol naa melow Yawut yi, ngir gindi leen. Man ci sama bopp yoonu Musaa jiitalu ma, terewul bi ma nekkee ci biir ñiy sàmm yoonu Musaa, sàmm naa yoon wa, ngir gindi leen. ");
INSERT INTO wol2010_vpl VALUES ("C19_21","076_9_21","1CO","9","21","21","Ci biir ñi nekkul ci yoonu Musaa, faalewuma woon yoon wi, ngir gindi leen; waxuma ne ànduma ak yoonu Yàlla, waaye topp naa yoon ci sama bokk ak Kirist. ");
INSERT INTO wol2010_vpl VALUES ("C19_22","076_9_22","1CO","9","22","22","Ci biir ñi néew ngëm, meloon naa ni ku néew ngëm, ngir gindi leen. Doon naa lépp ci ñépp, ngir def lépp lu ma man, ba ñenn mucc ci. ");
INSERT INTO wol2010_vpl VALUES ("C19_23","076_9_23","1CO","9","23","23","Damaa def loolu lépp ndax xibaaru jàmm bi, ngir man it ma am wàll ci barkeem. ");
INSERT INTO wol2010_vpl VALUES ("C19_24","076_9_24","1CO","9","24","24","Xanaa xamuleen ne, ñépp ñooy daw cib rawante, waaye kenn rekk ay jël ndam li? Dawleen nag ngir jël ko. ");
INSERT INTO wol2010_vpl VALUES ("C19_25","076_9_25","1CO","9","25","25","Ñiy joŋante ci po muy waral tàggat yaram, dañuy xañ seen bopp lu bare. Dañu koy def, ngir am kaalag ndam gu dul yàgg; waaye nun danu koy def, ngir am kaalag ndam gu sax ba fàww. ");
INSERT INTO wol2010_vpl VALUES ("C19_26","076_9_26","1CO","9","26","26","Man nag noonu laay dawe, te duma dawantu. Noonu laay bëree, waaye duma def ni nit kuy dóor ci jaww ji. ");
INSERT INTO wol2010_vpl VALUES ("C19_27","076_9_27","1CO","9","27","27","Waaye damay not sama yaram, ba moom ko, ngir ragala yégal ñi ci des xibaaru jàmm bi, ba noppi Yàlla xañ ma ndam li. ");
INSERT INTO wol2010_vpl VALUES ("C110_1","076_10_1","1CO","10","1","1","Bokk yi, bëgguma ngeen umple li daloon sunu maam ya. Ñoom ñépp niir wa tiimoon na leen, te ñoom ñépp jàll nañu géej. ");
INSERT INTO wol2010_vpl VALUES ("C110_2","076_10_2","1CO","10","2","2","Sóobu nañu ca ndoxu géej ga ak ca niir wa, ba bokk noonu ci Musaa. ");
INSERT INTO wol2010_vpl VALUES ("C110_3","076_10_3","1CO","10","3","3","Ñoom ñépp bokk nañoo lekk ñam wa Yàlla joxe, ");
INSERT INTO wol2010_vpl VALUES ("C110_4","076_10_4","1CO","10","4","4","naan naan ga mu joxe, ndaxte ñu ngi doon naan ca xeer, wa leen doon gunge, te xeer woowa Kirist la woon. ");
INSERT INTO wol2010_vpl VALUES ("C110_5","076_10_5","1CO","10","5","5","Teewul ñi ëpp ci ñoom neexuñu woon Yàlla, ba mu fàddoon leen ca màndiŋ ma. ");
INSERT INTO wol2010_vpl VALUES ("C110_6","076_10_6","1CO","10","6","6","Mbir yooyu ay misaal lañu, yu nuy artu, ngir benn bëgg-bëgg bu bon bañ noo jiital, na mu leen jiitale woon. ");
INSERT INTO wol2010_vpl VALUES ("C110_7","076_10_7","1CO","10","7","7","Buleen jaamu ay xërëm, ni ko ñenn ñi ci ñoom defe woon. Ndaxte Mbind mi nee na: «Mbooloo mi dafa toog, di lekk ak di naan, ba noppi ñu jóg di mbumbaay.» ");
INSERT INTO wol2010_vpl VALUES ("C110_8","076_10_8","1CO","10","8","8","Bunu njaaloo, ni ko ñenn ñi ci ñoom defe woon, ba tax ñaar fukki junni ak ñett ci ñoom dee ci benn bés. ");
INSERT INTO wol2010_vpl VALUES ("C110_9","076_10_9","1CO","10","9","9","Bunu diiŋat Kirist, ni ko ñenn ñi ci ñoom defe, ba ay jaan màtt leen, ñu dee. ");
INSERT INTO wol2010_vpl VALUES ("C110_10","076_10_10","1CO","10","10","10","Buleen xultu, ni ko ñenn ñi ci ñoom defe woon, ba tax Malaakam bóomkat bi rey leen. ");
INSERT INTO wol2010_vpl VALUES ("C110_11","076_10_11","1CO","10","11","11","Mbir yooyu leen daloon misaal la ci nun, te bind nañu ko ngir artu nu, nun ñiy dund ci jamono jii lépp mat. ");
INSERT INTO wol2010_vpl VALUES ("C110_12","076_10_12","1CO","10","12","12","Kon nag kiy naw sa doole, ba yaakaar ne taxaw nga, moytula daanu ci bàkkaar! ");
INSERT INTO wol2010_vpl VALUES ("C110_13","076_10_13","1CO","10","13","13","Benn nattu dabu leen bu wuute ak yi dal nit ñépp. Te sax Yàlla kuy sàmm kóllëre la, te du nangu nattu bi wees seen kàttan, waaye cib nattu dina leen ubbil bunt bu ngeen mana rëcce, ba ngeen man koo dékku. ");
INSERT INTO wol2010_vpl VALUES ("C110_14","076_10_14","1CO","10","14","14","Looloo tax, sama soppe yi, nangeen daw xërëm yi. ");
INSERT INTO wol2010_vpl VALUES ("C110_15","076_10_15","1CO","10","15","15","Maa ngi wax ak yéen ñi am xel. Kon seetleen li ma leen wax. ");
INSERT INTO wol2010_vpl VALUES ("C110_16","076_10_16","1CO","10","16","16","Kaas bu yiw bi tax nuy gërëm Yàlla, ndax du wone sunu booloo ak deretu Kirist? Mburu mi nuy damm, xanaa du dafay wone sunu booloo ak yaramu Kirist? ");
INSERT INTO wol2010_vpl VALUES ("C110_17","076_10_17","1CO","10","17","17","Ndegam benn mburu rekk a am, kon nun ñépp lu nu baree bare, menn mbooloo lanu, ndaxte bokk nanu menn mburu mi. ");
INSERT INTO wol2010_vpl VALUES ("C110_18","076_10_18","1CO","10","18","18","Seetleen ci bànni Israyil. Ñiy lekk sarax si ñu rendi, ndax booloowuñu ak Yàlla ji ñu jagleel sarxalukaay ba? Ahakay! ");
INSERT INTO wol2010_vpl VALUES ("C110_19","076_10_19","1CO","10","19","19","Li may wax, lu muy tekki? Ndax yàpp wi ñu jagleel xërëm yi dafay dara? Walla xërëm yi dañuy dara? ");
INSERT INTO wol2010_vpl VALUES ("C110_20","076_10_20","1CO","10","20","20","Déedéet! Waaye sarax yi xërëmkat yi di rendi, ay rab lañu ko jagleel; jagleeluñu ko Yàlla. Te man bëgguma, ngeen booloo ak rab yi. ");
INSERT INTO wol2010_vpl VALUES ("C110_21","076_10_21","1CO","10","21","21","Manuleena naan ci kaasu Boroom bi, naan ci kaasu rab yi. Manuleena sukk ci reerub Boroom bi, sukk ci reerub rab yi. ");
INSERT INTO wol2010_vpl VALUES ("C110_22","076_10_22","1CO","10","22","22","Walla boog ndax danuy jéema gillil meru Boroom bi? Xanaa noo ko ëpp doole? ");
INSERT INTO wol2010_vpl VALUES ("C110_23","076_10_23","1CO","10","23","23","Dafa am ñu naan: «Lépp lanu sañ.» Waaw, waaye du lépp a baax ci nun. «Lépp lanu sañ,» waaye it lépp du yékkati ngëm. ");
INSERT INTO wol2010_vpl VALUES ("C110_24","076_10_24","1CO","10","24","24","Bu kenn seet njariñam rekk, waaye nay seet njariñul moroomam. ");
INSERT INTO wol2010_vpl VALUES ("C110_25","076_10_25","1CO","10","25","25","Man ngeena lekk lépp lu ñuy jaay ca ja ba, bañ cee boole ay laaj ngir dalal seen xel. ");
INSERT INTO wol2010_vpl VALUES ("C110_26","076_10_26","1CO","10","26","26","Ndaxte Mbind mi nee na: «Àddina ak li ci biiram lépp, Boroom bi moo ko moom.» ");
INSERT INTO wol2010_vpl VALUES ("C110_27","076_10_27","1CO","10","27","27","Ku xamul Yàlla nag, bu leen wooyee aw ñam këram, te ngeen nangoo dem, lekkleen lépp lu ñu leen dëj, baña laajte dara ngir dalal seen xel. ");
INSERT INTO wol2010_vpl VALUES ("C110_28","076_10_28","1CO","10","28","28","Waaye bu leen kenn nee: «Lii sarax la, bu ñu jagleel xërëm yi,» suurleen ko ndax ki leen ko xamal, ngir xel mu dal. ");
INSERT INTO wol2010_vpl VALUES ("C110_29","076_10_29","1CO","10","29","29","Waxuma sa xel yaw, waaye xelu keneen laay wax. Waaye nga ne: «Li ma saña def, lu tax nit ku xelam dalul di am dara lu mu ciy wax? ");
INSERT INTO wol2010_vpl VALUES ("C110_30","076_10_30","1CO","10","30","30","Su ma lekkee dara di ci sant Yàlla, lu tax ñu may wax lu ñaaw, fekk sant naa ci Yàlla?» ");
INSERT INTO wol2010_vpl VALUES ("C110_31","076_10_31","1CO","10","31","31","Kon su ngeen di lekk walla ngeen di naan, walla lu ngeen mana def, defleen lépp ngir màggal Yàlla. ");
INSERT INTO wol2010_vpl VALUES ("C110_32","076_10_32","1CO","10","32","32","Buleen def dara lu mana fanq ngëmu Yawut yi walla ñi dul Yawut walla mbooloom Yàlla. ");
INSERT INTO wol2010_vpl VALUES ("C110_33","076_10_33","1CO","10","33","33","Noonu laay def man ci sama bopp: damay wuta neex ñépp ci lépp. Wutuma lu may jariñ, waaye luy jariñ ñu bare laay wut, ngir ñu mucc. ");
INSERT INTO wol2010_vpl VALUES ("C111_1","076_11_1","1CO","11","1","1","Royleen ma nag, ni may roye Kirist. ");
INSERT INTO wol2010_vpl VALUES ("C111_2","076_11_2","1CO","11","2","2","Maa ngi leen di sant ci li ngeen may fàttaliku ci lépp, ak ci li ngeen di topp dénkaane yi ma leen dénk. ");
INSERT INTO wol2010_vpl VALUES ("C111_3","076_11_3","1CO","11","3","3","Waaye nag bëgg naa ngeen xam lii: Kirist mooy kilifag bépp góor, góor di kilifag jigéen, te Yàlla di kilifag Kirist. ");
INSERT INTO wol2010_vpl VALUES ("C111_4","076_11_4","1CO","11","4","4","Kon nag góor guy ñaan Yàlla, walla muy wax ci kàddug Yàlla, fekk mu teg dara ci boppam, day suufeel Kirist, kilifaam. ");
INSERT INTO wol2010_vpl VALUES ("C111_5","076_11_5","1CO","11","5","5","Waaye bu jigéen musóoruwul, buy ñaan walla buy wax ci kàddug Yàlla, kooku day suufeel jëkkëram jiy kilifaam, ndaxte day mel ni jigéen ju ñu wat. ");
INSERT INTO wol2010_vpl VALUES ("C111_6","076_11_6","1CO","11","6","6","Jigéen ju dul musóoru, bu yaboo, mu watu. Waaye su fekkee ne jigéen dafay am kersa, su wàññee kawaram walla mu watu, fàww kon mu musóoru. ");
INSERT INTO wol2010_vpl VALUES ("C111_7","076_11_7","1CO","11","7","7","Góor nag moom warula teg dara ci boppam, ndaxte mooy melokaanu Yàlla te dafay wone ndamu Yàlla. Jigéen moom dafay wone ndamu góor. ");
INSERT INTO wol2010_vpl VALUES ("C111_8","076_11_8","1CO","11","8","8","Ndaxte jëlewuñu góor ci jigéen, waaye jigéen lañu jële ci góor. ");
INSERT INTO wol2010_vpl VALUES ("C111_9","076_11_9","1CO","11","9","9","Te sàkkuñu góor ngir jigéen, waaye jigéen lañu sàkk ngir góor. ");
INSERT INTO wol2010_vpl VALUES ("C111_10","076_11_10","1CO","11","10","10","Looloo tax jigéen wara teg ci kaw boppam luy màndargaal kilifteef ga, ndax malaaka yi. ");
INSERT INTO wol2010_vpl VALUES ("C111_11","076_11_11","1CO","11","11","11","Teewul nag ci sunu booloo ak Boroom bi, jigéen a ngi wéeru ci góor, te góor a ngi wéeru ci jigéen. ");
INSERT INTO wol2010_vpl VALUES ("C111_12","076_11_12","1CO","11","12","12","Ni ñu sàkke jigéen ci góor, noonu la góor juddoo ci jigéen, te lépp a ngi jóge ca Yàlla. ");
INSERT INTO wol2010_vpl VALUES ("C111_13","076_11_13","1CO","11","13","13","Seetleen mbir mii: ndax jekk na jigéen baña musóoru, buy ñaan Yàlla? ");
INSERT INTO wol2010_vpl VALUES ("C111_14","076_11_14","1CO","11","14","14","Xanaa du àddina ci boppam dafa leen di won ne gàcce la ci góor, ngir muy yar kawar gu bare? ");
INSERT INTO wol2010_vpl VALUES ("C111_15","076_11_15","1CO","11","15","15","Waaye loolu nag ab taar la ci jigéen. Dañoo jagleel jigéen kawar gu gudd, muy muuraay ci moom. ");
INSERT INTO wol2010_vpl VALUES ("C111_16","076_11_16","1CO","11","16","16","Waaye su kenn bëggee werante ci mbir moomu, na xam lii: amunu beneen aada ci njàng mi, du nun walla mboolooy Yàlla. ");
INSERT INTO wol2010_vpl VALUES ("C111_17","076_11_17","1CO","11","17","17","Bi may tollu ci ndigal yi, manuma leena sant, ndaxte seeni ndaje loraange lañuy jur, waaye du njariñ. ");
INSERT INTO wol2010_vpl VALUES ("C111_18","076_11_18","1CO","11","18","18","Ci bu jëkk dégg naa lii: bu ngeen di daje, am na ci yéen ñuy féewaloo, te xaw naa koo gëm. ");
INSERT INTO wol2010_vpl VALUES ("C111_19","076_11_19","1CO","11","19","19","Fàww mu am ay féewaloo ci seen biir, ngir ñu mana xàmmi ñi neex Yàlla ci yéen. ");
INSERT INTO wol2010_vpl VALUES ("C111_20","076_11_20","1CO","11","20","20","Bu ngeen dajee, manuleena wax ne reerub Boroom bi ngeen di lekk. ");
INSERT INTO wol2010_vpl VALUES ("C111_21","076_11_21","1CO","11","21","21","Ndaxte bu ngeen dee lekk, ku nekk dafay gaawantu di lekk reeram, ba tax ñenn ñaa ngi xiif, fekk ñeneen di màndi. ");
INSERT INTO wol2010_vpl VALUES ("C111_22","076_11_22","1CO","11","22","22","Xanaa amuleen kër yu ngeen di lekke ak di naane? Walla ndax dangeena xeeb mbooloom Yàlla? Walla ngeen bëgga rusloo ñi amul dara? Lu ma leen ci wara wax nag? Ma gërëm leen ci loolu? Mukk! Gërëmuma leen. ");
INSERT INTO wol2010_vpl VALUES ("C111_23","076_11_23","1CO","11","23","23","Li ma jële ci Boroom bi, moom laa leen jottali: Boroom bi Yeesu, ci guddi gi ñu ko woree, dafa jël mburu, ");
INSERT INTO wol2010_vpl VALUES ("C111_24","076_11_24","1CO","11","24","24","sant Yàlla, damm ko ne: «Lii sama yaram la, wi ma joxe ngir yéen. Defleen lii, ngir fàttaliku ma.» ");
INSERT INTO wol2010_vpl VALUES ("C111_25","076_11_25","1CO","11","25","25","Noonu itam bi ñu lekkee ba noppi, mu jël kaas bi ne leen: «Kaas bii mooy misaal kóllëre gu bees, gi Yàlla fas jaarale ko ci sama deret. Defleen lii ngir fàttaliku ma.» ");
INSERT INTO wol2010_vpl VALUES ("C111_26","076_11_26","1CO","11","26","26","Ndaxte saa su ngeen di lekk mburu mii, walla ngeen di naan ci kaas bii, yéena ngi yégle deewu Boroom bi, ba kera muy ñëw. ");
INSERT INTO wol2010_vpl VALUES ("C111_27","076_11_27","1CO","11","27","27","Kon nag képp ku jekkadi ni mu lekke ci mburu mi te naane ni ci kaasu Boroom bi, tooñ nga yaramu Boroom bi ak deretam. ");
INSERT INTO wol2010_vpl VALUES ("C111_28","076_11_28","1CO","11","28","28","Na ku nekk seetlu boppam nag, sooga lekk ci mburu mi te naan ci kaas bi. ");
INSERT INTO wol2010_vpl VALUES ("C111_29","076_11_29","1CO","11","29","29","Ku lekk mburu mi, naan ci kaas bi, fekk faalewuloo solos yaramu Kirist wi, sa lekk ak sa naan dina xëcc àtteb Yàlla ci sa kaw. ");
INSERT INTO wol2010_vpl VALUES ("C111_30","076_11_30","1CO","11","30","30","Looloo tax ñu bare ci yéen wopp te ñàkk doole, ba ñenn ñi faatu. ");
INSERT INTO wol2010_vpl VALUES ("C111_31","076_11_31","1CO","11","31","31","Su nu doon seetlu sunu bopp ni mu ware, kon àtte du nu dal. ");
INSERT INTO wol2010_vpl VALUES ("C111_32","076_11_32","1CO","11","32","32","Waaye bu nu Boroom bi dee àtte, da nuy yar ngir bañ noo boole ci mbugalu àddina. ");
INSERT INTO wol2010_vpl VALUES ("C111_33","076_11_33","1CO","11","33","33","Noonu nag bokk yi, bu ngeen dajee, di lekk reerub Boroom bi, nangeen xaarante. ");
INSERT INTO wol2010_vpl VALUES ("C111_34","076_11_34","1CO","11","34","34","Ku xiif, na lekke këram, ngir baña indi ci yéen àtteb Yàlla ndax seen ndaje yi. Yeneen fànn yi ci des nag, bu ma ñëwee ci yéen, dinaa ko seet. ");
INSERT INTO wol2010_vpl VALUES ("C112_1","076_12_1","1CO","12","1","1","Léegi nag bokk yi, ci li jëm ci mayi Xelum Yàlla, bëgguma ngeen umple ci dara. ");
INSERT INTO wol2010_vpl VALUES ("C112_2","076_12_2","1CO","12","2","2","Xam ngeen ne bi ngeen xamagul woon Yàlla, xërëm yi manula wax ñoo leen jiitaloon, di leen wommat. ");
INSERT INTO wol2010_vpl VALUES ("C112_3","076_12_3","1CO","12","3","3","Moo tax ma leen di xamal lii: ku Xelum Yàlla solu du wax ne: «Yeesu dafa araam.» Te it kenn manula wax ne: «Yeesu mooy Boroom bi,» su ko ko Xelum Yàlla waxloowul. ");
INSERT INTO wol2010_vpl VALUES ("C112_4","076_12_4","1CO","12","4","4","Am na fànni may yu bare yu jóge ci Xelum Yàlla, waaye menn Xel moomu moo koy séddale. ");
INSERT INTO wol2010_vpl VALUES ("C112_5","076_12_5","1CO","12","5","5","Am na ay sas yu bare, waaye benn Boroom bi la. ");
INSERT INTO wol2010_vpl VALUES ("C112_6","076_12_6","1CO","12","6","6","Am na ay fànn yu bare yu Yàllay feeñale dooleem, waaye jenn Yàlla ji mooy jëfe doole yooyu yépp ci ñépp. ");
INSERT INTO wol2010_vpl VALUES ("C112_7","076_12_7","1CO","12","7","7","Noonu Yàlla jox na ku nekk fànn gu muy feeñale Xelam mu Sell mi ngir njariñul ñépp. ");
INSERT INTO wol2010_vpl VALUES ("C112_8","076_12_8","1CO","12","8","8","Am na ku Yàlla sédde, jaarale ko ci Xelam, mayu wax ak xel mu leer, keneen am mayu xam-xam, te mu bawoo ci menn Xel mi. ");
INSERT INTO wol2010_vpl VALUES ("C112_9","076_12_9","1CO","12","9","9","Keneen it menn Xel mi jox ko ngëm, keneen di wéral ay jàngoro ci kàttanu Xel moomu, ");
INSERT INTO wol2010_vpl VALUES ("C112_10","076_12_10","1CO","12","10","10","keneen di def ay kéemaan, am kuy wax ci kàddug Yàlla, am keneen kuy ràññee li jóge ci Xelum Yàlla ak li jóge ci yeneen xel yi, keneen it di wax ay xeeti làkk, ak kuy firi làkk yooyu. ");
INSERT INTO wol2010_vpl VALUES ("C112_11","076_12_11","1CO","12","11","11","Loolu lépp, menn Xel moomu moo koy def, ku nekk mu sédd la ci, ni mu ko soobe. ");
INSERT INTO wol2010_vpl VALUES ("C112_12","076_12_12","1CO","12","12","12","Noona la ci yaramu nit. Yaram wenn la, teewul am na cér yu bare. Waaye céri yaram yépp, ak li ñuy baree bare, ñoo bokk, doon wenn yaram. Te noonu la Kirist mel. ");
INSERT INTO wol2010_vpl VALUES ("C112_13","076_12_13","1CO","12","13","13","Yàlla sóob na nu ci menn Xelam mi, ngir nu doon wenn yaram: nuy Yawut walla nu dul Yawut, nuy jaam mbaa gor, nun ñépp Yàlla may na nu, nu naan ci menn Xel mi. ");
INSERT INTO wol2010_vpl VALUES ("C112_14","076_12_14","1CO","12","14","14","Yaram du benn cér, waaye cér yu bare la. ");
INSERT INTO wol2010_vpl VALUES ("C112_15","076_12_15","1CO","12","15","15","Kon bu tànk nee: «Man duma loxo, kon bokkuma ci yaram,» du ko teree bokk ci céri yaram yi. ");
INSERT INTO wol2010_vpl VALUES ("C112_16","076_12_16","1CO","12","16","16","Te bu nopp nee: «Duma bët, kon bokkuma ci yaram,» du ko teree bokk ci céri yaram yi. ");
INSERT INTO wol2010_vpl VALUES ("C112_17","076_12_17","1CO","12","17","17","Bu yaram wépp doon bët, kon nan lay dégge? Walla bu yaram wépp doon nopp, kon nan lay xeeñtoo? ");
INSERT INTO wol2010_vpl VALUES ("C112_18","076_12_18","1CO","12","18","18","Waaye Yàlla dafa riime céri yaram wi, def bu ci nekk fa mu ko soobe. ");
INSERT INTO wol2010_vpl VALUES ("C112_19","076_12_19","1CO","12","19","19","Bu lépp doon benn cér, kon fu yaram di nekk? ");
INSERT INTO wol2010_vpl VALUES ("C112_20","076_12_20","1CO","12","20","20","Cér yi daal bare nañu, waaye wenn yaram rekk a am. ");
INSERT INTO wol2010_vpl VALUES ("C112_21","076_12_21","1CO","12","21","21","Bët nag manul ne loxo: «Soxlawuma la!» Te bopp it manul ne tànk yi: «Soxlawuma leen!» ");
INSERT INTO wol2010_vpl VALUES ("C112_22","076_12_22","1CO","12","22","22","Loolu sax manula am, ndaxte céri yaram, yi gëna néew doole, ñoo gëna am njariñ. ");
INSERT INTO wol2010_vpl VALUES ("C112_23","076_12_23","1CO","12","23","23","Te cér yi gëna ñàkk maana, ñoom lanuy gëna topptoo. Cér yi ci rafetula tudd, ñoom lanuy gëna suturaal, ");
INSERT INTO wol2010_vpl VALUES ("C112_24","076_12_24","1CO","12","24","24","fekk yi gëna rafet, soxlawul nu leen di suturaale noonu. Waaye Yàlla dafa boole sunu céri yaram yi, ngir gëna teral cér yi ko soxla. ");
INSERT INTO wol2010_vpl VALUES ("C112_25","076_12_25","1CO","12","25","25","Noonu yaram du séddaloo, waaye cér bu ci nekk dina dimbali yi ci des. ");
INSERT INTO wol2010_vpl VALUES ("C112_26","076_12_26","1CO","12","26","26","Bu sa benn céru yaram dee metti, yeneen yi ci des yépp dañuy bokk, yég metit wi. Te bu dee dangaa fonk sa benn céru yaram it, ndax du sa yaram wépp a ciy bànneexu? ");
INSERT INTO wol2010_vpl VALUES ("C112_27","076_12_27","1CO","12","27","27","Léegi benn yaram ngeen, muy yaramu Kirist, te kenn ku nekk ci yéen cér nga ci. ");
INSERT INTO wol2010_vpl VALUES ("C112_28","076_12_28","1CO","12","28","28","Te Yàlla teg na ci mbooloom ñi gëm, ku nekk ak sa may: ci bu jëkk ay ndawi Kirist, teg ca ñiy wax ci kàddug Yàlla, teg ca ñiy jàngle, ñiy def ay kéemaan, ñi am mayu wéral ay jàngoro, ñiy dimbalee, ñiy jiite, ñiy wax ay xeeti làkk. ");
INSERT INTO wol2010_vpl VALUES ("C112_29","076_12_29","1CO","12","29","29","Ndax ñépp ay ndawi Kirist lañu? Ndax ñépp dañuy wax ci kàddug Yàlla? Ndax ñépp ay jàngle? Ndax ñépp ay def kéemaan? ");
INSERT INTO wol2010_vpl VALUES ("C112_30","076_12_30","1CO","12","30","30","Ndax ñépp a am mayu wéral ay jàngoro? Ndax ñépp ay wax ay làkk? Ndax ñépp a leen di firi? ");
INSERT INTO wol2010_vpl VALUES ("C112_31","076_12_31","1CO","12","31","31","Waaye fonkleen may yi gën. Léegi nag ma won leen yoon wu gën lépp. ");
INSERT INTO wol2010_vpl VALUES ("C113_1","076_13_1","1CO","13","1","1","Su fekkee ne damay wax làkki nit ñi ak yu malaaka yi sax, te boolewuma ci mbëggeel, duma dara lu dul ndënd muy riir, walla jóolóoli buy kandaŋ-kandaŋi. ");
INSERT INTO wol2010_vpl VALUES ("C113_2","076_13_2","1CO","13","2","2","Su ma yéglee wax ju tukkee ci Yàlla, ma xam lépp luy kumpa, ma yor xam-xam bépp te gëm Yàlla ba mana randal ay tund, fekk boolewuma ci mbëggeel, duma dara. ");
INSERT INTO wol2010_vpl VALUES ("C113_3","076_13_3","1CO","13","3","3","Te it su ma doon sarxe li ma am lépp, di bàyyi ñu lakk sama yaram, ba rey ma, su ma ci boolewul mbëggeel, du ma jariñ dara. ");
INSERT INTO wol2010_vpl VALUES ("C113_4","076_13_4","1CO","13","4","4","Ku bëgg dafay muñ te laabiir. Ku bëgg du iñaan, du kañu, du tiitaru, ");
INSERT INTO wol2010_vpl VALUES ("C113_5","076_13_5","1CO","13","5","5","du def lu jekkadi, du wut njariñu boppam, du naqari deret, du ñaaw njort. ");
INSERT INTO wol2010_vpl VALUES ("C113_6","076_13_6","1CO","13","6","6","Du bég ci lu awul yoon, waaye dina bég ci lépp luy jollil dëgg. ");
INSERT INTO wol2010_vpl VALUES ("C113_7","076_13_7","1CO","13","7","7","Mbëggeel day baale lépp, am gëm ci lépp, yaakaar lépp, muñ lépp. ");
INSERT INTO wol2010_vpl VALUES ("C113_8","076_13_8","1CO","13","8","8","Mbëggeel amul àpp. Ñiy wax ci kàddug Yàlla dinañu noppi, ñiy wax ay làkk dinañu ko bàyyi, ñiy xamle xam-xamu Yàlla wàcc. ");
INSERT INTO wol2010_vpl VALUES ("C113_9","076_13_9","1CO","13","9","9","Xam-xam bi nu am des na, te ni nu jottalee xibaar bi nu Yàlla dénk des na. ");
INSERT INTO wol2010_vpl VALUES ("C113_10","076_13_10","1CO","13","10","10","Waaye li mat, bu dikkee, li matul jóge fi. ");
INSERT INTO wol2010_vpl VALUES ("C113_11","076_13_11","1CO","13","11","11","Bi ma dee xal