﻿USE sofia;
DROP TABLE IF EXISTS sofia.wob_vpl;
CREATE TABLE wob_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES wob_vpl WRITE;
INSERT INTO wob_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Ka Sesi Klisɩ ‑nɩa Dafidɩ 'a \"ju, ɔ nɩa Ablaam 'a \"ju 'a \"ji 'a nɩsʋn 'ka ka : ");
INSERT INTO wob_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Ablaam 'wlʋɛ Isaakɩ, Isaakɩ 'wlʋɛ Sakɔbʋ ‑wɛe Sakɔbʋ 'wlʋ Suida ke ɔɔ' \"dei ‑wi\" ke‑. ");
INSERT INTO wob_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Suida ke ɔɔ' 'nynɔ Tama 'wlʋɛ Farɛsɩ ke Sera ke‑. Farɛsɩ 'wlʋɛ Ɛsirɔm, ‑wɛe Ɛsirɔm 'wlʋ Aram. ");
INSERT INTO wob_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Aram 'wlʋɛ Aminadabʋ ‑wɛe Aminadabʋ 'wlʋ Naasɔn. Naasɔn 'wlʋɛ Salma, ");
INSERT INTO wob_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","‑wɛe Salma ke Raabʋ 'wlʋ Boasɩ. Boasɩ 'wlʋɛ Obɛdɩ, Ruitɩ ‑nɩ ‑mɔ de. ");
INSERT INTO wob_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Obɛdɩ mɔ ‑wlʋ Isai ‑wɛe Isai 'wlʋ Dafidɩ. Ɔmɔ ‑kpa 'beɔ. 'Beɔ Dafidɩ ‑nɔ ‑duɛ\" Uri 'a 'nynɔ 'ʋn 'de ɔ ke ʋ 'wlʋ Salomɔ. ");
INSERT INTO wob_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Salomɔ 'wlʋɛ Roboam ‑wɛe Roboam 'wlʋ Abia. Abia 'wlʋɛ Asafʋ ");
INSERT INTO wob_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","‑wɛe Asafʋ 'wlʋ Sosafa. Sosafa 'wlʋɛ Soram ‑wɛe Soram 'wlʋ Osiasɩ. ");
INSERT INTO wob_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Osiasɩ 'wlʋɛ Soatam ‑wɛe Soatam 'wlʋ Akasɩ. Akasɩ 'wlʋɛ Esekiasɩ, ");
INSERT INTO wob_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","‑wɛe Esekiasɩ 'wlʋ Manase. Manase 'wlʋɛ Amɔ ‑wɛe Amɔ 'wlʋ Sosiasɩ. ");
INSERT INTO wob_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Sosiasɩ 'wlʋɛ Sekoniasɩ ke ɔɔ' de'di ‑wi\" ke‑ 'de ɛɛ' nɔ\" tu 'di mɛ Suifʋ‑wi\" muu kʋɔnkwla' 'de Babilɔnɩ ‑blʋa \"kpei. ");
INSERT INTO wob_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Ʋʋ 'wlʋ kʋɔnkwla' 'sasa la ‑wɛe Sekoniasɩ 'wlʋ Salatiɛlɩ. Salatiɛlɩ 'wlʋɛ Sorobabɛ ");
INSERT INTO wob_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","‑wɛe Sorobabɛ 'wlʋ Abiudɩ. Abiudɩ 'wlʋɛ Eliakim ‑wɛe Eliakim 'wlʋ Asɔɔ. ");
INSERT INTO wob_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Asɔɔ 'wlʋɛ Sadɔkɩ ‑wɛe Sadɔkɩ 'wlʋ Asim. Asim 'wlʋɛ Eliudɩ ");
INSERT INTO wob_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","‑wɛe Eliudɩ 'wlʋ Eleasa. Eleasa 'wlʋɛ Matan ‑wɛe Matan 'wlʋ Sakɔbʋ ");
INSERT INTO wob_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","‑wɛe Sakɔbʋ 'wlʋ Sosɛʋ, Madi 'a kʋan. Madi ‑nʋ, ʋmʋ ‑nɩ Sesi nyʋ a 'daa Klisɩ de. ");
INSERT INTO wob_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Dɛ ‑wlʋa 'e Ablaam \"kpei ‑wɛe ‑ɛ ‑jɛɛa Dafidɩ ɛ, nyʋ a ‑sroɛ' nyiɔ 'ɔ \"ji 'a ‑puue 'jɔ ‑nyiiɛ. Dɛ ‑wlʋa 'e Dafidɩ \"kpei ‑wɛe ‑ɛ ‑jɛɛa Suifʋ‑wi\" 'a kʋɔnkwla' mua' 'de Babilɔnɩ ɛ, ɛ nɩɛ nyiɔ 'ɔ \"ji 'a ‑puue 'jɔ ‑nyiiɛ ‑ke. Dɛ ‑tba' 'o ‑mɔ ‑ɛ ‑jɛɛa Klisɩ 'a 'wlʋa' a, ɛ nɩɛ nyiɔ 'ɔ \"ji 'a ‑puue 'jɔ ‑nyiiɛ ‑ke. ");
INSERT INTO wob_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Ka Sesi nʋa 'wlʋsʋn 'ka ka : Madi ‑nɩa ɔ de ɛ, ʋ ‑teɛ Sosɛʋ 'a 'nynɩ 'ʋn. 'Kaa ʋʋ se srɛ' due' \"kpei ‑te ke 'sʋ Kea 'a ‑Suu 'a \"ikmaa' je ɛ ‑nʋ ʋ 'je \"kwli 'ble. ");
INSERT INTO wob_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","'De Sosɛʋ ‑nɩa ʋa' ‑pɔn' i ɛ, ɔ nɩɛ nyiɔ 'dɔe ‑o. Ɔ se ɛ \"inɩ ɔ 'je ʋa' 'nynɩ dooa‑, ɛmɛ ‑tɩ ɔɔ ‑pɔn ɔ 'je ʋ \"i \"tai wɔɔ‑. ");
INSERT INTO wob_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Ɔ siiɛ ɛɛ' tɔ' i naa' 'sʋ, ɔ 'jeɛ Tʋ\"bo Kea 'a \"soai due' 'de jajri 'ʋn, ‑ɔ ‑wlu ‑ɔ ‑pee ka, ‑ɔ ‑na : Sosɛʋ, Dafidɩ 'a \"ju, ‑ɩn ‑bo tɔ' i pleeɛ 'de Madi 'a ‑tɩ' 'ʋn, dɛ‑nʋɛ' \"ju ‑ɔɔ \"kwli ʋa 'tɩan i ɛ, Kea 'a ‑Suu mɛ ‑ji\" 'e ʋ 'ʋn ‑wɛe ʋ 'ble ɛɛ' \"kwli tu. ");
INSERT INTO wob_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Ʋa muɛ \"junmɔuju 'wlʋa' ‑wɛe ‑ɩn ‑je ɔ Sesi nynɩ ‑tuu\"‑, ɛ 'de mɛ ‑nɩ Nyʋ 'pʋʋi, dɛ‑nʋɛ' ɔmɔ ‑ɔɔ mu ɔɔ' 'cɛ‑wi\" 'pʋʋa' 'de dɛsaʋn 'kwa. ");
INSERT INTO wob_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Ɩa' dɩ tu nʋʋɛ' ‑wɛe wlu Tʋ\"bo Kea 'a wlu 'kwajaai‑ 'tmʋa tɛin\" 'je 'o nyni. ");
INSERT INTO wob_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","Ɔ wlu' ka 'de‑, ɔ 'na : 'Nynɩa ‑tɔo a muɛ \"kwli 'blea' ‑wɛe ʋ 'je \"junmɔuju 'wlʋ 'de nyʋ 'je ɔ Emaniɛ 'daa‑. Ɛɛ' 'nynɩ tu 'de mɛ ‑nɩ Kea ke ‑a ‑na'. ");
INSERT INTO wob_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Sosɛʋ sʋan \"nyɩɔ 'sʋ ka Tʋ\"bo 'a \"soai 'da, 'kamɔ ɔ nʋ, ‑wɛe ɔ \"duo ɔɔ' 'nynɔ Madi 'ʋn. ");
INSERT INTO wob_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","'Kaa ɔ ke ʋ se ba 'a ku \"i bla mamaʋ 'sʋ ʋa' \"ju ‑nɔ je 'wlʋ, ‑wɛe Sosɛʋ ‑tuu\" ɔ Sesi nynɩ‑. ");
INSERT INTO wob_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Sesi 'wlʋʋ 'bo Bɛtelɛm 'de Suida 'de 'beɔ Erodɩ 'a nɔ\" 'di. Sesi 'wlʋa 'sʋ ɛ, dɛ \"ijuoʋn jrʋ' ‑ʋʋa ‑cɩan 'cʋ‑sɩɩn 'a ‑pʋn\" ‑tɩ ɛ, ʋʋ 'wlʋɛ 'e 'jrʋ kwea fɔo ‑wɛe ʋʋ ji 'o Selisalɛm. ");
INSERT INTO wob_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","'Sʋ ʋʋ ‑teeɛ' nyʋ i, ʋʋ 'na : Suifʋ‑wi\" 'a 'beɔ ‑ɔ ‑wlʋa 'de 'wɩ ‑nɩ 'di 'ee ‑ta ka ɔ nɩ ɛ‑ ? ‑A jiɛ ɔ \"juɔi ‑gbɛɛa', dɛ‑nʋɛ' ‑a ‑je ɔɔ' 'cʋ‑sɩɩn 'mɛ 'de 'jrʋ kwea fɔo. ");
INSERT INTO wob_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","'Beɔ Erodɩ 'wɔan wlu ‑nɛ ɛ, ɛ jiɛ ɔ miia, tai' \"maa ɔ ke Selisalɛm ‑kwlɔ ‑wee' 'mɛ. ");
INSERT INTO wob_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","'Sʋ ɔ 'kɩɩɛn 'sraa ‑saʋn klae\" ke kɛ' wɔ‑saʋn \"jrui ‑wɛe ɔ ‑tee' ʋʋpʋ i 'de ‑ta ka Klisɩ, Kea 'a 'o ‑tei 'je 'wlʋʋ 'de ɛ‑. ");
INSERT INTO wob_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Ʋʋ 'na : 'Bo Bɛtelɛm 'de Suide 'bo ɔ 'je 'wlʋʋ‑. 'De dɛ Kea 'a wlu 'kwajaai 'crɩa 'de ɛɛ' ‑tɩ' 'ʋn, ɛ ka : ");
INSERT INTO wob_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","‑Mɔ Bɛtelɛm ‑kwlɔ, ɛ se ‑mɔ se dɛwɔn nɩ 'de Suda 'a ‑kwlɛ ‑wee' \"klu ko‑. 'Kaa 'bo ‑ma ‑kwlɔ tu 'di 'bomɔ 'beɔ ‑jea 'ma 'cɛ Israɛ‑kɔʋn ‑je o po 'je 'wlʋʋ‑. ");
INSERT INTO wob_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","'Sʋ Erodɩ 'da dɛ \"ijuoʋn ‑nʋ 'mɛ wɔɔ‑, ‑wɛe ɔ ‑tee' ʋʋpʋ i 'pepe, ɔ 'na : Dɛɛ nɔ\" ɛɛ' 'cʋ‑sɩɩn ‑tu 'kpa 'e \"jɛi ɛ‑ ? Ʋʋ \"siɛ ɛɛ' nɔ\" 'ɔ 'nynɩ. ");
INSERT INTO wob_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","'Sʋ ɔ 'na : Ao mu Bɛtelɛm ‑wɛe ao 'je \"ju ‑saan\" ‑nɔ 'ɔ ‑pʋn\" ‑tɩ i ‑tee' 'pepe. ‑Bo ao 'je ɔ 'ja a, ‑mɛ ao ji 'ʋn 'tmʋʋ‑, 'de 'ɩn 'je ɔ \"juɔi ‑gbɛɛa' mu ‑ke. ");
INSERT INTO wob_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Ʋʋ ‑kɔa' ɔɔ' wlu doin\" o poa' 'sʋ ɛ, ʋʋ 'kpa ‑jei\". 'Sʋ 'cʋ‑sɩɩn ʋʋ 'jeea \"jriɛ‑ 'de 'jrʋ 'a kwea fɔ o 'de ɛ, ɛ kɔn ʋʋpʋ \"juɔi. Ɛ nynia ‑ta \"ju ‑saan\" nɩa 'sʋ ɛ nyna i. ");
INSERT INTO wob_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Ʋʋ 'jeea 'cʋ‑sɩɩn ‑nɛ \"jriɛ‑ 'sʋ, 'mʋa‑ klaa\" \"ji ʋʋpʋ 'ʋn 'ɛ. ");
INSERT INTO wob_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Ʋʋ pa 'e ‑gbu\" 'di, ʋʋ jɛɛ \"jupliiɛ ke ɔ de Madi 'mɛ 'sʋ ʋʋ \"siiɛ 'kɔi‑ i 'bo ɔ \"juɔi, ‑wɛe ʋʋ ‑gbɛɛ' ɔ. 'De ʋʋpʋ kain ʋʋa' 'bleedɩ \"i ‑wɛe ʋʋ nʋ ɔ ‑paan' \"jrii. Ʋʋ \"nyɩ ɔ 'sani ke ‑dai'klɔ ke tu 'a \"ni jrɛ' ‑ɛɛ 'nʋ nmɔɔa 'e nyʋ 'mlai ɛ, ɛɛ' 'nynɩ ‑nɩ 'mii‑. ");
INSERT INTO wob_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","'Sʋ Kea ‑saa ʋʋpʋ fɛn' 'de jajri 'di ‑wɛe ʋʋ 'bo 'e 'beɔ Erodɩ o de muuɛ, 'sʋ ʋʋ \"duɛ ‑je jrɛ' 'ʋn ‑wɛe ʋʋ mu ʋʋpʋ \"bli de. ");
INSERT INTO wob_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Dɛ \"ijuoʋn ‑nʋ mua de 'sʋ ɛ, Sosɛʋ 'jeɛ Kea 'a \"soa 'a due' 'de \"nyɩɔ' o, ɔ wlu ɔ ‑pee ɔ 'na : ‑Ɩn ‑sɔn 'ʋn, ‑ɩn ‑je \"ju ‑saan\" ke ɔ de 'ʋn \"duo‑ ʋʋ ke ‑ɩn ‑je 'e Esipʋ‑blʋa \"kpei mu. 'Demɔ ao 'je i ‑te mamaʋ ‑bo 'ɩn 'na ‑ɩn ji deɛ 'de ‑ɩn ‑je de ji, dɛ‑nʋɛ' Erodɩ a ‑pɔn \"ju ‑saan\" 'a 'dba ‑kɔ i. ");
INSERT INTO wob_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Sosɛʋ sɔan 'ʋn 'sʋ ɛ, ɔ \"duo \"ju ‑saan\" ke ɔ de 'ʋn 'ɛ \"maʋ\" ‑wɛe ɔ ke ʋʋ mu 'e Esipʋ. ");
INSERT INTO wob_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","'De mɔ ɔ ‑te i mamaʋ 'sʋ Erodɩ je 'mɛ. Ɩa' dɩ tu nʋʋɛ' ‑wɛe dɩ Kea 'a wlu 'kwajaai 'tmʋa tɛin\" ɛ, 'de ɩ 'je 'o nyni. Ɛɛ' wlu tu 'na : 'Ɩn 'da 'ma \"ju 'mɛ, ‑wɛe ɔ 'wlʋ 'e Esipʋ‑blʋa \"kpei. ");
INSERT INTO wob_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Ka dɛ \"ijuoʋn sea 'de ɔ o de muu ‑wɛe ʋʋ kpa ‑jeblʋ jrɛ' Erodɩ 'jea kan' 'sʋ, ɔ 'kpa 'cɛn ‑wɛe ɔ dbo nyʋ 'de Bɛtelɛm ke ‑kwlɛ ‑jiɛ' 'de woi 'dii, 'de ʋʋ 'je \"nynunmainynu mɩɩ\" ‑blea ‑sɩn 'sɔɔn ke \"nynuu pliiɛ 'dba dɛ‑nʋɛ', nɔ\" ‑ɛ 'di 'cʋ‑sɩɩn 'kpaa 'de \"jɛi ‑wɛe dɛ \"ijuoʋn \"sia ɛɛ' 'nynɩ 'de ɔ ‑pee, ɛmɛ ‑nao. ");
INSERT INTO wob_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","'Sʋ dɩ \"klein Kea 'a wlu 'kwajaai Selemi 'tmʋa 'de ɛ, ɩ nyni 'o 'ɛ. ");
INSERT INTO wob_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","Ɔ wlu' ka 'de‑, ɔ 'na : Nyʋ a 'wɔn ‑too\" \"i powlu 'bo Rama. Rasɛlɩ ‑a ‑fɩn\", ‑ʋa kple ʋʋa' \"nynuu‑ dɛ‑nʋɛ', ʋ se ‑tɩ' ‑kwlɩ' i ‑tu\" ‑tɩ 'wɔɔn 'de ʋa' \"nynuu ‑mɛa 'a ‑tɩ' 'ʋn. ");
INSERT INTO wob_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Erodɩ 'mɛ ‑wɛe Sosɛʋ 'je Kea 'a \"soai \"nyɩɔ' o 'de Esipʋ. ");
INSERT INTO wob_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","'De ɛ wlu Sosɛʋ ‑pee ka, ɛ 'na : ‑Ɩn ‑sɔn 'ʋn, ‑ɩn ‑duo\" \"ju ‑saan\" ke ɔ de 'ʋn ao 'je 'e Israɛ‑blʋa \"kpei de mu, dɛ‑nʋɛ' nyʋ ‑ʋʋa ‑pɔan \"ju ‑saan\" 'a 'dba ‑kɔ i 'de ɛ, ʋʋ 'mɛɛ ‑wɛ‑. ");
INSERT INTO wob_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Sosɛʋ sɔan 'ʋn 'sʋ, ɔ \"duo \"ju ‑saan\" ke ɔ de 'ʋn 'ɛ, ‑wɛe ɔ 'kpa 'de Israɛ‑blʋa \"kpei ‑jei\". ");
INSERT INTO wob_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","'Kaa ka Asilaisi \"sia 'bo ɔ \"bo Erodɩ ‑kɔ o, ɔ 'wɔin 'sʋ 'bo 'a mua' 'bleɛ ɔɔ' faʋn‑, ‑wɛe Kea 'tmʋʋ ɔ 'de jajri 'di 'de ɔ mu 'e Galile. ");
INSERT INTO wob_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Ɔ \"tiɛ 'o ‑kwlɔ due' ‑ɛɛ 'nynɩ nɩa Nasarɛtɩ 'di. Ɔ nʋ ɛɛ' dɛ tu 'mɛ ‑wɛe wlu Kea 'a wlu 'kwajaaʋn 'tmʋa tɛin\" ɛ, ɛ 'je 'o nyni. Ɛɛ' wlu tu 'naa : Nyʋ a mu ɔ Nasarɛtɩ ‑i 'daa'. ");
INSERT INTO wob_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","'De ɛɛ' nɔ\" tu 'di ɛ, San Batisɩ nɩɛ 'e ‑pɩɩɔn\" blʋa \"kpei 'de Suide ‑wɛe ‑ɔɔ ‑tmʋ Kea 'a ‑tɩ'. ");
INSERT INTO wob_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","Ɔɔ wlu' ka ɔ 'na : Ao juo aoa' dɛsaʋn \"i, ao \"biie‑ 'e Kea o dɛ‑nʋɛ', Kea 'a nyʋ 'blesʋn ‑teɛ \"jri \"kpae' po‑tɩ. ");
INSERT INTO wob_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","San mɔ ‑ɔɔ ‑tɩ' Kea 'a wlu 'kwajaai Esai 'tmʋ 'de‑ ‑wɛe ɔ 'na : \"Ju ‑nɩa 'e ‑pɩɩɔn\" blʋa \"kpei ɔɔ' weewlu ka : Ao ‑sa 'beɔ 'ɔ ‑jeblʋ, ao tɛɛn ɔɔ' ‑jeblʋ ‑wee' ‑kwlʋ. ");
INSERT INTO wob_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","San 'a 'ʋnpaadɩ ɔ 'blea a, ‑sɛn \"kpei soo\" 'a ku mɛ ‑nʋɩ', ‑wɛe ɔ bla nmikuwlʋ 'di. 'De ɔɔ di 'plaɩn‑too' ke dʋ 'a 'cna ke‑. ");
INSERT INTO wob_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Nyʋ ‑nɩa Selisalɛm o, nyʋ ‑nɩa Suide blʋa ‑wee' \"kpei i o, ɛ ke nyʋ ‑nɩa 'blʋa‑ ‑jia' Sudɛn ‑gbuu ‑kwlɩ' i 'dii ɛ, ʋʋ ‑wee' a jiɛ 'de ɔ o. ");
INSERT INTO wob_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Ʋʋa 'wɔɔn‑ ʋʋpʋ 'a dɩsaɩn \"i 'bo nyʋ ‑wee' \"juɔi, ‑wɛe San a po ʋʋpʋ \"ni \"jru 'de Sudɛn ‑gbuu wɔn. ");
INSERT INTO wob_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","‑Ta San a ‑gbʋan 'emu 'sʋ ‑mɛ Fariseɛn‑wi\" o, Sadiseɛn‑wi\" a jiɛ 'de ɔ o, ‑wɛe ɔ 'je ʋʋpʋ \"ni \"jru po. 'Sʋ ɔ wlu' 'de ʋʋ ‑pee ka, ɔ 'na : Ao jɔe 'a \"nynuu‑, ao 'bo tɔ' inaa ka ‑bo ao pooɛ \"ni \"jru 'sʋ Kea 'a 'cɛn ‑ɛɛ jia 'wlʋ aopʋ \"kpei 'mɛ. ");
INSERT INTO wob_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","‑Bo aoa' 'kmʋ poo fai\" ‑mɛ ao to ɛɛ' sʋn, nyʋ 'je ɛ 'je ! ");
INSERT INTO wob_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Ao 'bo wluɛ foo\" 'ʋn ka : ‑A \"bo ‑nɩ Ablaam. Tɔ' ‑tɩ 'ma 'tmʋʋ aopʋ‑, Kea 'beeɛ' ɛ 'je ao nya ‑fuun ‑wɛe ɛ 'je \"soikpi ‑nɩ Ablaam 'a \"nynuu‑ 'ʋn nʋ. ");
INSERT INTO wob_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","‑Gbo\" ‑pa 'pɛn i ‑wɛ‑ 'bo tu 'a 'sɩn \"kpei sese. Tu \"o tu ‑sea' \"buo 'dɔe po ɛ, ɛɛ muɛ dbaa' ‑wɛe ɛ 'je \"jri pooɛ‑. ");
INSERT INTO wob_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","'Mɔ San, \"ni mɛ 'ma po aopʋ \"jru ‑wɛe ao 'je 'kmʋ fai\" poo. 'Kaa \"ju ‑ɔ jia 'bo 'ʋn 'de ɛ, ɔ kmai\" ɔ je 'ʋn ‑sii. 'Ɩn se ɔɔ' \"kwlaibɩ mɩ 'a 'de ɔ bʋ' ‑sa ‑ka nɩ‑, ‑wɛe ɩa' kwa 'ble‑tɩ. ɔmɔ ‑je ao Kea 'a ‑Suu ke nɛ o jaa. ");
INSERT INTO wob_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Ɔ 'bleɛ ɔɔ' 'daa‑ kwa 'de ɔ 'je ɔɔ' ko 'ʋn ‑fun'. Ɔɔ muɛ ɔɔ' ko bla ‑ta iwuua' 'pepe 'de ɔ 'je ɔɔ' ko 'a 'jɔ ‑cɛɩn' 'bo \"jɛi ‑tu\" ‑wɛe ɔ 'je ɩa' flɩ \"jri po 'de nɛ ‑sea' 'mʋ‑ta 'ble 'ʋn. ");
INSERT INTO wob_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","'Sʋ Sesi 'wlʋɛ 'e Galile ‑wɛe ɔ ji 'e San o 'bo Sudɛn ‑gbuu ‑kwlɩ\" 'de San 'je ɔ \"ni \"jru po. ");
INSERT INTO wob_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","'Kaa San 'na ɔ se 'wɔn \"i‑saa nɔ\". Ɔ wlu' 'de Sesi ‑pee ɔ 'na : 'Mɔ ‑mɔ' ‑mɔ ‑je \"ni \"jru po 'ee, kɛ nʋ 'sʋ ‑mɔ ji 'nɔ 'mɔ o ɛ‑ ? ");
INSERT INTO wob_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","'Sʋ Sesi 'na : ‑Ɩn ‑bo ɛ wlu 'de tbaa, dɩ \"klein Kea \"sia nynɩ, ‑a ‑jɩ nʋ o ‑wɛe ɩ 'je 'o nyni. 'Sʋ San 'wɔɔn‑ 'o 'ɛ. ");
INSERT INTO wob_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Sesi 'a ‑nɛɛ ‑kɔ' \"ni \"jru poa, ‑ɛɛ 'wlʋ 'e \"niɔ‑ 'sʋ jaʋn kaiɛn wɔn ‑wɛe ɔɔ 'je Kea 'a ‑Suu i, ‑ɛɛ \"si i 'bo ɔ \"kpei ka ‑gbɛɛ' nɩa. ");
INSERT INTO wob_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","'Sʋ wlu due' ‑wlʋ 'e jaʋn 'di ‑ɛ ‑na : \"Ju ‑nɔ nɩɛ 'ma ‑tɩ' kmaju ‑o. 'De ɔ 'ʋn 'bo 'ma ‑kwlʋtɩ ‑wee' poo kɩn. ");
INSERT INTO wob_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Ɛ 'wlʋa 'o mu 'sʋ Kea 'a ‑Suu kpa Sesi 'de ‑pɩɩɔn\" blʋa \"kpei ‑wɛe ‑siɔn' 'je ɔ dɛsaʋn nʋa' i ‑tɩn'. ");
INSERT INTO wob_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Sesi 'bɔ wɔn 'de 'jrʋ‑gbaowɩ 'a kwla ‑nyiiɛ ke \"maʋ'wɩ 'a kwla ‑nyiiɛ 'di. 'Sʋ 'mɩɩɛ‑ ɛ nʋɔ'. ");
INSERT INTO wob_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","'Bomɔ nyʋ dɛsaʋn 'dipoi 'kpɔɔ ‑pʋn\" ‑wɛe ɔ wlu ɔ ‑pee ɔ 'na : ‑Bo ‑ɩn ‑nɩ Kea 'a \"Ju ɛ, ‑mɛ ‑ɩn ‑wlu \"soikpi ‑nɩ ‑pee ɩ 'je ‑di'pɛn 'ʋn‑snɛɛ. ");
INSERT INTO wob_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","'Sʋ Sesi wlu' ka 'de ‑siɔn' ‑pee ɔ 'na : Wlu ‑crɩɩa' 'de Kea 'a 'sbɛ 'di kɛ 'da ka, ɛ 'naa : Diidɛ 'ɛ 'sʋ se ɛ 'bɛɛ‑ ‑wɛe ɛ 'je nyiɔ 'kmʋnɩa' \"nyɩ, 'kaa wlu \"klein ‑wlʋa 'e Kea 'wɔn ɛ, ɩa \"nyɩ nyiɔ 'kmʋnɩa' 'mɛ ‑ke. ");
INSERT INTO wob_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","'Bomɔ ‑siɔn' kpa Sesi 'e Selisalɛm ‑kwlɔ 'di la 'de ɔ 'jɔɔ 'e Kea ‑gbu klaa\" \"jru. ");
INSERT INTO wob_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","‑Wɛe ɔ wlu ɔ ‑pee ɔ 'na : ‑Bo ‑ɩn ‑nɩ Kea 'a \"Ju ɛ, ‑mɛ ‑ɩn ‑fi\" e ‑ma ‑cɛ\" 'de ‑sɔn. 'Kaa ɛ 'crɩɩɛ' ka ‑ke : Kea a muɛ ɛɛ' \"soa‑wi\" 'tmʋa' 'de ‑ma ‑tɩ' 'ʋn ‑wɛe ʋʋ 'je ‑ʋn 'sa 'de ‑ma bɩɛ se ‑tiie' i 'de \"soukpo \"jri. ");
INSERT INTO wob_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","'Sʋ Sesi wlu ɔ ‑pee ɔ 'na : Wlu ‑crɩɩa' 'de 'fɔ jrɛ' o ɛ 'naa : ‑Ɩn ‑bo \"jrii 'jeedɩ nʋɛ, ‑ɩn ‑bo ‑ma Tʋ\"bo Kea i ‑tɩɛn'. ");
INSERT INTO wob_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","'Sʋ ‑siɔn' kpɔ 'e crʋ ‑tɛan ja \"kpei ke'wlɛ ‑wɛe ɔ to ɔ 'blʋa‑ 'di 'a ‑pɛe ke ɛɛ' tʋ\"bodɩ ‑wee' \"klein \"i. ");
INSERT INTO wob_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","'De ɔ wlu Sesi ‑pee ɔ 'na : ‑Bo ‑ɩn ‑sii\" 'kɔu‑ i 'bo 'ʋn \"juɔi ‑wɛe ‑ɩn ‑je 'ʋn \"juɔi ‑gbɛɛ' ɛ, 'ma muɛ ‑ʋn dɩ ‑nɩ ‑wee' \"klein \"nyɩa'. ");
INSERT INTO wob_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","'Sʋ Sesi wlu ɔ ‑pee ɔ 'na : ‑Ɩn ‑criiɛ 'ʋn kɩn ‑siɔn' ! 'Kaa wlu ‑crɩɩa' ɛ 'naa : ‑Ma Kea 'a 'sʋ mɛ ‑nɩ Tʋ\"bo, ɛmɛ nyʋ 'je \"juɔi ‑gbɛɛ'‑, ɛɛ' 'sʋ mɛ nyʋ 'je \"juɔi nʋʋ‑. ");
INSERT INTO wob_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Ɛ 'wlʋa 'o mu 'sʋ ‑siɔn' tɛɛn Sesi o. 'Sʋ Kea 'a \"soa‑wi\" 'kpa Sesi ‑pʋn\" ‑wɛe ɩɩa \"nyɩ ɔ diidɛ. ");
INSERT INTO wob_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Sesi 'wɔan San Batisɩ 'a ‑kaso 'dimunynɩ 'sʋ, ɔ muɛ 'e Galile. ");
INSERT INTO wob_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Ɔ 'wlʋ 'o Nasarɛtɩ 'mɛ, ‑wɛe ɔ mu Kapɛnaʋm \"tia', 'bo 'tɔniɛ ‑kwlɩ\" 'de Sabilɔn blʋa ke Nɛfʋtali blʋa \"kpei. ");
INSERT INTO wob_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Ɛ nʋ kan' 'mɛ ‑wɛe dɛ Kea 'a wlu 'kwajaai Esai 'tmʋa tɛin\" 'je 'o nyni. ");
INSERT INTO wob_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","Ɔ wlu' ka 'de‑ ɔ 'naa : Sabilɔnblʋa ke Nɛfʋtaliblʋa ‑ɩ ‑bɔɔa' 'e 'tɔniɛ ‑kwlɩ\" 'de nyʋ ‑sea' Suifʋ nɩ 'a ‑nɩ Galileblʋa 'a 'fɔ o 'de Sudɛn ‑gbuu 'de ! ");
INSERT INTO wob_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Ɩa' 'blʋɩ‑ tu ‑nɩa 'e kwie 'di ɛ, ɩmɩ ‑jee' ‑sɔn' klaa\" \"jriɛ‑, ɛ ‑sɩn' 'de nyʋ ‑ʋʋa pleea 'mɛa' \"kpei. ");
INSERT INTO wob_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Ɛɛ' nɔ\" tu 'di mɛ Sesi ‑tee Kea 'a ‑tɩ' 'tmʋa' ‑pʋn\". Ɔ 'na : Ao juo aoa' dɩsaɩn \"i, ao \"biie‑ 'e Kea o dɛ‑nʋɛ', jaʋn 'di 'a 'bɩɔdɛ ‑teɛ \"jri \"kpae po‑tɩ. ");
INSERT INTO wob_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","‑Ta ɔ nɩɩa 'tɔniɛ‑ ‑nɩa 'e Galile ‑kwlɩ' i plea' 'sʋ ɛ, ɔ 'jeɛ de 'dinynuu 'sɔɔn, Simɔ ʋʋa 'daa Piɛi ke ɔɔ' \"dei Ancre, ‑mɛ ʋʋ nɩɛ 'sai‑ poa' 'de 'tɔniɛ wɔn, dɛ‑nʋɛ' ʋʋ nɩɛ 'saipoʋn ‑o see. ");
INSERT INTO wob_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","'Sʋ ɔ 'da ʋʋpʋ 'mɛ ɔ 'na : Ao ji 'ʋn kɩɩn, ‑wɛe ka aoa ‑sa' ‑smii' ɛ, ao 'je kan' nyiɔpʋ‑ ‑sa, ao 'je 'ʋn ja‑. ");
INSERT INTO wob_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","'Bo ɛ \"sri, ʋʋ je ʋʋa' 'sai‑ 'bɔ, ʋʋ je 'o Sesi 'de bla. ");
INSERT INTO wob_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Ɔ 'kɩɩan 'o nya ka kpɩɩn‑ 'sʋ ɔ jɛɛ de 'dinynuu 'sɔɔn jrʋ', Sakɩ ke ɔɔ' de 'di San ke‑, ʋʋ nɩɛ Sebede 'a \"nynuu ‑o. Ʋʋ ke ʋʋ \"bo Sebede nɩɛ ʋʋa' 'sai \"paa' 'de ‑kwɛɛ\" 'di 'sʋ Sesi 'da ʋʋpʋ 'mɛ. ");
INSERT INTO wob_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","'Bo ɛ \"sri, ʋʋ je ‑kwɛɛ\" ke ʋʋ \"bo sie, ʋʋ ke Sesi je mu. ");
INSERT INTO wob_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Sesi a muɛ Galileblʋa ‑wee' \"klein \"kpei‑ ‑wɛe ɔɔ tɔɔ nyʋ Kea 'a ‑tɩ' 'de Suifʋ‑wi\" 'a \"jrui 'kɩɩn‑gbi 'dii. 'De ɛɛ' 'blʋa 'a 'fɔ tu o ɔɔ 'tmʋɛ Kea 'a ‑pɔia\" ‑tɩ ‑wɛe 'wɛnʋʋn ‑nɩa 'e ʋʋpʋ \"klu ɛ, ɔɔ 'bɔɔ‑ ʋʋ ‑wee' \"klein 'a 'wɛ‑. ");
INSERT INTO wob_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Nyʋ a 'wɔn Sesi 'a 'nynɩ 'mɛ 'de Siriblʋa ‑wee' \"kpei‑ ‑wɛe ʋʋa' jɔ nyʋ ‑ʋʋa ‑jea 'kle 'de 'wɛ‑ 'ɛ kpɛ ‑tuu\"‑tuu 'kwa, ɛ ke nyʋ ‑siisaɩn nɩa 'e 'ʋn o, nyʋ ‑klɔɔa o, nyʋ susu a nʋa o, ‑wɛe ɔɔ 'bɔɔ‑ ʋʋpʋ 'a 'wɛ‑. ");
INSERT INTO wob_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Nyʋ ‑tuu\"‑tuu ‑kaan Sesi 'de, ʋʋa' jrʋ' 'wlʋɛ 'e Galile, jrʋ' 'wlʋɛ ‑kwlɛ ‑puue ‑ɩ ‑nɩa 'e \"ni wɔin\" 'dii, jrʋ' 'wlʋɛ Selisalɛm, jrʋ' 'wlʋɛ 'e Suide, jrʋ' 'wlʋɛ 'e 'blʋa‑ ‑jia' Sudɛn ‑gbuu 'a 'fɔ jrɛ' wɔin \"kpei‑. ");
INSERT INTO wob_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","‑Ta Sesi 'jeea nyʋ ‑tuu\"‑tuu ‑nʋ \"jriɛ‑ 'sʋ ɛ, ɔ 'ja 'o crʋ \"kpei ‑wɛe ɔ ‑te i. 'Sʋ ɔɔ' klai\" nynuu 'kpɔ ‑pʋn\" ");
INSERT INTO wob_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","‑wɛe ɔ ‑te nyʋ dɛ tɔɔa' ‑pʋn\" 'de ɔ wlu ka, ɔ 'na : ");
INSERT INTO wob_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","Nyʋ ka ‑ʋʋ sea dɛwɔn nɩ 'bo Kea \"juɔi ‑ʋʋ ‑jea kan' ʋʋpʋ nʋ 'mʋa‑, dɛ‑nʋɛ' 'beɔdɛ ‑nɩa 'e jaʋn 'di nɩɛ ʋʋpʋ 'a dɛ ‑o. ");
INSERT INTO wob_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Nyʋ ‑ʋʋa ‑fɩn\" a, ʋʋpʋ nʋ 'mʋa‑, dɛ‑nʋɛ' Kea a muɛ ʋʋpʋ ‑tɩ' ‑kwlɩ' i ‑tu\" a'. ");
INSERT INTO wob_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Nyʋ ‑nɩa kupeeɛ' nyʋ ʋʋpʋ nʋ 'mʋa‑, dɛ‑nʋɛ' ʋʋpʋ a muɛ 'blʋa‑ ‑nɛ 'blea'. ");
INSERT INTO wob_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Nyʋ ‑ʋʋa ‑wla \"isrɛa 'a ‑fli i, ʋʋpʋ nʋ 'mʋa‑, dɛ‑nʋɛ' dɛ ʋʋa ‑pɔan ʋʋa muɛ 'jea'. ");
INSERT INTO wob_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Nyʋ ‑ʋʋa ‑jea nyʋ 'a wɛe, ʋʋpʋ nʋ 'mʋa‑, dɛ‑nʋɛ' Kea a muɛ ʋʋ 'a wɛe 'jea' ‑ke. ");
INSERT INTO wob_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Nyʋ ‑nɩa 'pepe 'de pɛe o ʋʋpʋ nʋ 'mʋa‑, dɛ‑nʋɛ' ʋʋa muɛ Kea \"jriɛ‑ 'jeea'. ");
INSERT INTO wob_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Nyʋ ‑ʋʋa ‑pɔan' pɛe 'a blua' i 'bo ʋʋ ke ʋʋ ‑ponyiɔ 'nynɩ nʋ 'mʋa‑, dɛ‑nʋɛ' Kea a muɛ ʋʋ ɛɛ' \"nynuu‑ 'daa'. ");
INSERT INTO wob_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Nyʋ nyʋ a ‑tua\" 'kle 'de \"isrɛ‑tɩ 'ʋn, ʋʋpʋ nʋ 'mʋa‑, dɛ‑nʋɛ' 'beɔdɛ ‑nɩa 'e jaʋn 'di nɩɛ ʋʋpʋ 'a dɛ ‑o. ");
INSERT INTO wob_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","‑Bo nyʋ a sea aopʋ ‑cree\" ‑wɛe nyʋ a sea aopʋ 'kle ‑tu\", 'de nyʋ a sea aopʋ ‑tɩ' \"kpei bla foo\" 'ʋn 'de 'ma 'nynɩ 'a ‑tɩ' 'ʋn ɛ, ao nʋ 'mʋa‑. ");
INSERT INTO wob_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Ao nʋ 'mʋa‑, ao 'di nmɔ wɔn, dɛ‑nʋɛ' aoa' ‑kei\" a muɛ \"i 'bɛɛa' 'de jaʋn 'di. 'Kamɔ nyʋ ‑tu\" Kea 'a wlu 'kwajaaʋn ‑nɩa tɛin\" 'kle ‑ke. ");
INSERT INTO wob_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Aopʋ ‑nɩ 'blʋa 'a 'tɔn. 'Kaa ‑bo 'tɔn ‑kwɛ‑ wɔn 'ee dɛ nyʋ 'je nʋ ‑wɛe ɛ 'je wɔn nɩ ɛ‑ ? Ɛ se nʋʋdbo 'ble, ‑mɛ dɛ ‑sia 'o mu mɛ ‑nɩ nyʋ 'je ɛ 'de \"kpae' 'wla ‑wɛe nyiɔpʋ‑ 'je ɛ \"kpei‑ na‑. ");
INSERT INTO wob_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","Aopʋ ‑nɩ 'blʋa 'a ‑sɔn'. Crʋ \"jru‑kwlɔ se ɛ 'bɛɛ‑ ɛ 'je 'kwla pa. ");
INSERT INTO wob_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Nyɔ 'ɔ tba nɛbi 'de ɔɔ' ‑crii\" ɛ dɛ \"jrui, 'kaa nyʋ a ‑teɛ' ‑ta ‑tɛan ja ‑wɛe ɛɛ wan 'de nyʋ \"klein ‑nɩa 'e ‑gbu\" 'di ‑wee' a 'je i. ");
INSERT INTO wob_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","'Kamɔ aoa' ‑sɔn' 'je ‑sɩn' 'de nyʋ ‑wee' \"klein \"juɔi ‑wɛe ʋʋ 'je aoa' kplɩn 'dɔe 'je 'de ʋʋ 'je ao \"Bo ‑nɩa 'e jaʋn 'di 'a 'nynɩ \"i 'bɛɛ‑. ");
INSERT INTO wob_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","'De Sesi 'na : Ao 'bo tɔ' inaa ka 'ɩn ji' ‑wɛe 'ɩn 'je Moisɩ 'a kɛ' ke dɩ Kea 'a wlu 'kwajaaʋn tɔɔa nyʋ i‑sa. ɛ se kan' ‑mɔ nɩ‑, 'kaa 'ɩn se dɛ i‑saa' ji, 'ɩn jiɛ dɛ nʋa'. ");
INSERT INTO wob_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","'Ma 'tmʋʋɛ aopʋ tɔ' ‑tɩ, ‑ta 'blʋa‑ ke jaʋn sea ‑sii ke ɛ, Kea 'a kɛ' se dɛ‑saan\" ka \"kpei 'wlʋi. Nyʋ se kɛ 'ɛ 'sbɛjri 'a dɛ‑saan\" ka 'bo ‑sai mamaʋ 'sʋ dɛ ɛ \"sia 'nynɩ ɛ 'je 'o nyni. ");
INSERT INTO wob_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Ɛmɛ ‑tɩ nyɔ ‑ɔɔ mua kɛ' 'ɛ dɛ‑saan\" ka i‑saa' ‑wɛe ‑ɔɔ ‑kɔ nyʋ a mua 'o 'de blaa', ‑mɛ ɔ se dɛwɔn nɩi 'de jaʋn 'di 'a 'beɔdɛ 'ʋn. 'Kaa nyɔ ‑ɔɔ mua kɛ' wɔn 'jea' ‑wɛe ‑ɔɔ ‑kɔ nyʋ ‑wee' 'jea 'o 'de bla ɔɔ muɛ dɛwɔn nɩa' 'de jaʋn 'di 'a 'beɔdɛ 'ʋn. ");
INSERT INTO wob_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","'Ma 'tmʋʋ aopʋ‑ 'mɛ, ‑bo aoa' \"isrɛa' se kɛ wɔ ‑saʋn ke Fariseɛn‑wi\" 'a ‑nɩ \"jru 'ja a, ‑mɛ ao se 'e Kea 'a kɛɛma' ‑kwlɔ 'di pai 'de jaʋn 'di. ");
INSERT INTO wob_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","Dɛ ‑tmʋʋa' 'de ao \"bo ‑wi\" ‑pee tɛin\" ‑wɛe ao 'wɔan ɛ 'na : ‑Ɩn ‑bo \"ku 'dbaa. Nyɔ ‑dba \"ku ɛ, nyʋ a mu ɔɔ' 'pee 'jea'. ");
INSERT INTO wob_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","'Kaa 'mɔ ɛ, 'ma ‑a ‑tmʋʋ' aopʋ‑ 'mɛ, nyɔ \"o nyɔ ‑ɔ ‑kpa 'cɛn 'de ɔɔ' de 'di ‑pee, ‑mɛ nyʋ 'je ɔɔ' 'pee 'je ‑o. 'De nyɔ ‑ɔ ‑wlua 'de ɔɔ' de 'di ‑pee ‑wɛe ‑ɔ ‑na : ‑Mɔ kpɛɛn' nyɔ ‑nɔ ! ‑Mɛ ‑mɔ 'ɔ jei tu 'a 'pee nɩɛ 'je ka‑. 'De nyɔ ‑jea ɔɔ' de 'di sɩɩan 'ʋn ɛ, ‑mɛ ‑mɔ nɩɛ 'e nɛ‑gbauo'‑ ‑sea' 'mʋ ‑ta 'ble 'ʋn mu ka‑. ");
INSERT INTO wob_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","‑Bo ‑ma sea ‑ma 'sraa ‑sadɛ 'bo Kea \"juɔi kpa ‑wɛe ka ‑ma de 'di 'bleea ‑ʋn 'dii 'de ‑ɩn ‑je ɛ ‑kwlʋ o po ɛ, ");
INSERT INTO wob_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","‑mɛ ‑ɩn ‑te' ‑ma 'sraa ‑sadɛ i 'bo 'sraa‑sa'ɩn, ‑ɩn ‑je de mu ‑ɩn ‑ke ‑ma de 'di 'je ‑tɩ' \"kpei‑ seea kpɩɩn‑ ‑wɛe ‑ɩn ‑je de ji 'de ‑ɩn ‑je ‑ma 'sraa‑ ‑sa. ");
INSERT INTO wob_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","‑Bo nyɔ poo ‑ʋn \"kuan 'de kpan‑tɩ 'ʋn ‑wɛe ɔ ke ‑ɩn ‑je bʋ' inaa‑ 'de ao 'je ‑gba jeʋn \"juɔi mu ɛ, ‑mɛ ɔ ke ‑ɩn ‑bɛɛ' wlu 'ʋn 'bo ‑jei\" ‑wɛe ɔ je ‑ʋn 'de 'pee 'jei 'kwa ‑tu\", 'de 'pee 'jei je ‑ʋn ‑kasogbu ifuoi kwa 'bɔɔ‑, 'de ‑mɔ je ‑ʋn ‑kaso 'di po. ");
INSERT INTO wob_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","'Ma 'tmʋʋɛ ‑ʋn tɔ' ‑tɩ ‑ɩn se 'e ɛɛ' ‑kaso ‑tu 'di 'wlʋi mamaʋ 'sʋ ‑ɩn ‑je ɔɔ' 'wɛi ‑nɩa ‑ʋn \"kpei ‑wee' 'de to‑. Ɩa' ‑suujɔ due' koʋn ‑gbai' se 'de ‑ʋn \"kpei siei. ");
INSERT INTO wob_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","Ɛ 'wlʋa 'o ‑mɔ ɛ, Sesi wlu' ke'wlɛ, ɔ 'na : Dɛ ao 'wɔan tɛin\" 'de ɛ, ɛmɛ ‑nɩ : ‑Ɩn ‑bo jɛi\" 'jeeɛ. ");
INSERT INTO wob_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","'Kaa 'ma 'tmʋʋ aopʋ 'mɛ : nyɔ \"o nyɔ ‑gbʋan ɔ \"dɛi 'a 'nynɔ jɛi\" jri ja ‑wɛe ʋ pooa pɛe \"i ɛ, ‑mɛ ɔ ‑kɔ' ʋa' jɛi\" nɩa' 'mɛ 'de ɔ pɛe o. ");
INSERT INTO wob_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","‑Bo ‑ma dian o jriɛ nɩɛ \"i ɛ 'je ‑ʋn 'de dɛsaʋn 'di po ɛ, ‑mɛ ‑ɩn ‑sa ɛɛ' \"jriɛ‑ tu 'de ‑ʋn 'kʋn ‑ɩn ‑je ɛ 'kwla po. ‑Ma \"jriɛ‑ due' \"i nɩa' \"paa', ɛ je ‑ma nyiɔjɔ ‑wee' ‑gbai\" ‑wɛe ‑ɩn mu 'e nɛ 'ʋn ‑sii. ");
INSERT INTO wob_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","‑Bo ‑ma diansʋn nɩɛ \"i ɛ 'je ‑ʋn 'de dɛsaʋn 'di po ɛ, ‑mɛ ‑ɩn ‑cɛn ɛɛ' sʋn tu 'bo ‑ʋn ‑pʋn\" ‑ɩn ‑je ɛ 'kwla po. ‑Ma sʋn due' \"i nɩa' \"paa', ɛ je ‑ɩn ‑ble sɩn 'sɔɔn 'de ‑ma nyiɔjɔ ‑wee' ‑gbai\" 'de ɛ mu 'e nɛ 'ʋn ‑sii. ");
INSERT INTO wob_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","Sesi 'na, dɛ ‑tmʋa' 'de ɛ, ɛmɛ ‑nɩ : ‑Bo nyɔ ‑sa 'nynɔ 'kwla ‑mɛ ɔ \"nyɩ ʋ 'kwla ‑sasbɛ. ");
INSERT INTO wob_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","'Kaa 'ma 'tmʋʋ aopʋ 'mɛ, nyɔ \"o nyɔ ‑ɔɔ 'nynɔ sea jɛi\" 'je ‑wɛe ‑ɔ ‑sʋ 'kwla ‑mɛ ɔmɔ ‑pʋ' 'de jɛi\" 'jedɛsaʋn 'di. 'De nyɔ \"o nyɔ ‑dua\" 'nynɔkpao' ‑saa 'kwla 'ʋn ‑wɛe ʋ \"tia \"bli ɛ, ‑mɛ ‑mɔ 'jeɛ jɛi\" ‑ke. ");
INSERT INTO wob_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","Dɛ ‑tmʋʋa' 'de ao \"bo ‑wi\" ‑pee ke'wlɛ ao 'wɔan, ɛmɛ ‑nɩ : ‑Bo ‑ɩn ‑srɛɛn, ‑mɛ ‑ɩn ‑bo wlu fai\" pooɛ, dɛ ‑ɛɛ ‑srɛɛan' ‑ɩn ‑srɛɛan 'bo Tʋ\"bo \"juɔi ɛ, ‑mɛ ‑ɩn nʋ ɛ. ");
INSERT INTO wob_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","'Kaa 'mɔ 'na : ao 'bo ‑srɛɛn mɔ ‑wee', ao 'bo jaʋn 'ʋn ‑srɛɛn, ɛ nɩɛ Kea 'a ‑teɩn ‑o. ");
INSERT INTO wob_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Ao 'bo 'blʋa‑ 'ʋn ‑srɛɛn, ɛ nɩɛ Kea 'a \"kpeinaadɛ ‑o. Ao 'bo Selisalɛm ‑kwlɔ 'ʋn ‑srɛɛn, ɛ nɩɛ 'beɔ klaa\" 'a ‑kwlɔ ‑o. ");
INSERT INTO wob_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","‑Ɩn ‑bo ‑ma \"jru 'ʋn ‑srɛɛn, dɛ‑nʋɛ' ‑ɩn se ɛ 'bɛɛ‑ ‑ma ‑cɛ\" 'kpa 'je ‑ma \"mɩɩjɔ due' koʋn ‑gbai' \"pluu‑ 'de ‑ɩn ‑je ɛ kpee‑. ");
INSERT INTO wob_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Aoa' kɩɩn nɩ kɩɩn ! Aoa' \"ɩɩn‑ nɩ \"ɩɩn‑ ! Dɛ nyʋ a poa 'o ɛ \"kpei ‑mɛ 'wlʋɛ 'e ‑siɔn' 'ʋn. ");
INSERT INTO wob_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","Ɔ 'na : Wlu ao 'wɔan tɛin\" ɛ 'naa : ‑Bo nyɔ wa nyʋ \"jriɛ‑ \"i ɛ, ‑mɛ nyʋ wɔ \"jriɛ‑ \"i ‑ke. 'De ‑bo nyɔ ‑sa nyʋ 'nynɩ 'wɔn ɛ, ‑mɛ nyʋ ‑sɔ 'nynɩ 'wɔn ‑ke. ");
INSERT INTO wob_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","'Kaa 'mɔ 'na ‑bo nyɔ nʋ ao dɛsaʋn \"jrii ɛ, ao 'bo ɛɛ' kpan ‑saa. ‑Bo nyʋ po ‑ma dian o doun\" 'kpa 'ʋn ɛ, ‑ɩn ‑to 'e kʋan o doun\" ɔ 'je 'o 'kpa po. ");
INSERT INTO wob_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","‑Bo nyɔ bla ‑ʋn ‑tɩ' \"kpei ‑wɛe ɔ 'je ‑ma \"bai 'ʋn \"duo ɛ, ‑ɩn ‑bo ɔ ‑je de kaan 'de ‑ma tae' 'a 'ʋn \"duo ‑tɩ 'ʋn ‑ke. ");
INSERT INTO wob_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","‑Bo nyɔ ‑te' ‑ʋn ‑klaan\" \"kpei, 'de ɔ ‑te' ‑ʋn ‑gbɛ \"jru ‑wɛe ɔ ke ‑ʋn ‑je ‑je 'a ‑to due' 'ʋn na ‑mɛ ‑ɩn ‑kuu dɩ i ɔ ke ‑ɩn ‑je ‑je 'a ‑to 'sɔɔn 'ʋn na‑. ");
INSERT INTO wob_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Nyɔ ‑ɔ ‑tee' ‑ʋn dɛ i ‑mɛ ‑ɩn ‑nyɩ\" ɔ. 'de nyɔ ‑ɔ ‑pɔan' ‑ʋn dɛ 'kwa kpʋan 'a ‑kɔ i ɛ, ‑ɩn ‑bo ɔ ‑jriɛ\" i‑saa. ");
INSERT INTO wob_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","Ɔ 'na‑ : Wlu ao 'wɔan ɛ 'na : ‑Ɩn ‑kma ‑ma ‑ponyiɔ 'ɔ ‑tɩ' 'de ‑ɩn ‑je ‑ma tʋnyɔ 'ʋn 'nyɛ. ");
INSERT INTO wob_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","'Kaa 'mɔ 'naa : Ao kma aoa' tʋnyɔ 'ɔ ‑tɩ', ao po nyʋ ‑ʋʋa pooa aopʋ ‑soo' o \"diwan. Ao nʋ nyʋ ‑nyɛa aopʋ 'ʋn dɛ 'dɔe \"jrii. Ao bae nyʋ ‑ʋʋa ‑tua\" aopʋ 'kle 'a Kea. ");
INSERT INTO wob_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","‑Wɛe ao 'je ao \"Bo ‑nɩa 'e jaʋn 'di 'a \"nynuu‑ nɩ‑, dɛ‑nʋɛ' ɛɛ faan ɛɛ' 'jrʋ 'mɛ 'de 'diwɔnyniʋn ke 'diwɔnmɔʋn \"kpei. ɛɛ dbaa \"ni 'mɛ 'de nyʋ ‑ʋʋa nʋa dɛsaʋn o, nyʋ ‑ʋʋa nʋa dɛ 'dɔe ‑wee' \"klein \"kpei. ");
INSERT INTO wob_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Nyʋ ‑kma aoa' ‑tɩ' ‑bo ao kma ‑wi\" ‑mʋ 'a 'sʋ 'a ‑tɩ' 'ee, ‑mɛ dɛ ‑ɛɛ ‑kei\" Kea 'je ao ‑saa ? 'Kamɔ 'wɛi‑sanyʋ a nʋ ‑ke o ! ");
INSERT INTO wob_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","'De ‑bo aoa sea aoa' de'di ‑wi\" 'a 'sʋ 'jewlu o po 'ee, ‑mɛ dɛ ‑pooa fai\" ɛ 'de ɛ‑ ? 'Mɔ 'na 'kamɔ nyʋ ‑sea' Kea juo a nʋ ‑ke o ! ");
INSERT INTO wob_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Ao nɩ 'pepe ka ao \"Bo ‑nɩa 'e jaʋn 'di nɩa 'pepe ɛ. ");
INSERT INTO wob_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Ao 'bo aoa' dɩ 'dɔe nʋa' tooɛ 'bo nyʋ \"juɔi ‑wɛe nyʋ je ɩa' 'kpa po. ‑Bo aoa sɩ nʋ ‑wɛe nyʋ 'je ao ‑tɩ' o poɛ ‑mɛ ao \"Bo ‑nɩa 'e jaʋn 'di se ao ‑kei\" ‑sai 'bode. ");
INSERT INTO wob_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","‑Bo ‑ma sea nyʋ dɛ 'dɔe \"jrii nʋ ɛ, ‑ɩn ‑bo ɛɛ' kɛ' i 'jreeɛ ka \"jridepooʋn a nʋa 'de Suifʋ‑wi\" 'a \"jrui 'kɩɩn‑gbi 'dii ke ‑je woi ɛ. ʋʋa nʋ kan' 'mɛ, ‑wɛe nyʋ 'je ʋʋpʋ ‑tɩ' o po. 'Ma 'tmʋʋɛ aopʋ tɔ' ‑tɩ, ʋʋa' ‑nɩ ‑kei\" mɛ ʋʋa 'jea 'o 'mʋa‑. ");
INSERT INTO wob_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","'Kaa ‑bo ‑ma sea nyɔ dɛ 'dɔe \"jrii nʋ ɛ, ‑mɛ dɛ ‑ma diansʋn a nʋa, ‑ma kʋansʋn 'bo ɛ juuɛ. ");
INSERT INTO wob_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","'De ka dɛ ɛ ‑tua\" 'kwla, ɛ 'je kan' nɩ‑, ‑wɛe ‑ɩn \"Bo ‑bo dɛ nɩ 'e \"sran ‑ɛ ‑juo ɛ, 'de ɛ 'je ‑ʋn ‑kei\" ‑sa. ");
INSERT INTO wob_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","Ɔ 'naa : ‑Bo aoa sea Kea bae ɛ, ka \"jridepooʋn nɩa, ao 'bo kan' nɩɛ. ʋʋa ‑pɔn ʋʋ 'je inyna Kea bae‑gbi 'dii ke ‑je woi ke ‑wɛe nyʋ ‑wee' \"klein 'je ʋʋpʋ 'je. 'Ma 'tmʋʋ‑ aopʋ 'mɛ, ʋʋa' ‑nɩ ‑kei\" mɛ ʋʋa 'jea 'o 'mʋa‑. ");
INSERT INTO wob_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","'Kaa ‑mɔ ɛ, ‑bo ‑ɩn ‑je Kea bae ɛ, ‑mɛ ‑ɩn pa 'e ‑ɩn o ‑gbu\" 'di ‑ɩn kan 'o ‑gbɛin\" ‑wɛe ‑ɩn ‑je ‑ɩn \"Bo 'mʋae‑ ‑ɩn ‑nɩa ‑ɛ ‑nɩa 'o bae‑. ‑Wɛe ‑ɩn \"Bo ‑bo dɛ nɩ 'e \"sran ‑ɛɛ ‑je ɛ i, ɛ 'je ‑ʋn ɛɛ' ‑kei\" ‑sa. ");
INSERT INTO wob_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","‑Bo aoa sea Kea bae ɛ, ao 'bo wlu ‑tuu\" 'tmʋɛ, ka nyʋ ‑sea' Kea juo a nʋa. Ʋʋmʋ a naa tɔ' i ʋʋ 'na ‑bo ʋʋ po baewlu ‑tuu\"‑tuu ɛ, ‑wɛe Kea 'je ʋʋa' baewlu kpʋn. ");
INSERT INTO wob_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Ao 'bo ʋʋpʋ sraan, dɛ‑nʋɛ' dɩ \"klein aoa ‑pɔan i ɛ, ao sɩ ao \"Bo i‑tee' 'sʋ ɛ jɩ juo‑ sese. ");
INSERT INTO wob_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Ka ao 'jea bae sʋn nʋ 'ka ka, ao nʋ : ‑A \"Bo ‑nɩa 'e jaʋn 'di ɛ, ɛɛ' 'nynɩ ‑tee kpɔi\" ‑wɛe nyʋ 'je ɛɛ' ni' ‑te'. ");
INSERT INTO wob_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Ɛɛ' 'beɔdɛ po \"jri \"kpae' ‑wɛe ɛɛ' ‑kwlʋtɩ 'je nʋʋɛ‑ 'nɔ 'blʋa‑ \"kpei ka ɩa nʋʋa 'de jaʋn 'di ɛ. ");
INSERT INTO wob_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Ɛ \"nyɩ ‑aʋn ‑aa ‑sʋn 'di diidɛ 'de ‑sɩanwɩ 'di. ");
INSERT INTO wob_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Ɛ 'wlʋ ‑aa dɩsaɩn 'a ‑kɔ \"kpei ka ‑aa ‑wlʋa nyʋ ‑nʋa ‑a dɩsaɩn \"jrii 'a ‑nɩ \"kpei ɛ. ");
INSERT INTO wob_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Ɛ bo ‑a \"i \"taiɛ ‑wɛe ‑siɔn' 'bo ‑a i ‑tɩɛn' 'de dɛsaʋn nʋa' 'ʋn. 'Kaa ɛ seie ‑aʋn 'de nyɔsaʋn 'kwa. Dɛ‑nʋɛ' 'beɔdɛ ke 'nynɩ 'wlʋa' ke \"ikmaa' nɩɛ ɛɛ' dɛ jeejee, 'kamɔ ɛ nɩ‑. ");
INSERT INTO wob_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","‑Bo ao 'wlʋ nyʋ 'a dɛsaʋn \"kpei ɛ, ao \"Bo ‑nɩa 'e jaʋn 'di a muɛ aoa' dɛsaʋn \"kpei 'wlʋa' ‑ke. ");
INSERT INTO wob_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","'Kaa ‑bo ao se nyʋ 'a dɛsaʋn \"kpei 'wlʋ ɛ, ao \"Bo ‑nɩa 'e jaʋn 'di se aoa' dɛsaʋn \"kpei 'wlʋi ‑ke. ");
INSERT INTO wob_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","Ɔ 'naa : ‑Bo ao 'bɔ wɔn ɛ, ao 'bo \"jrii‑ \"kɩkɩ nɩɛ, ka \"jridepooʋn a nʋa. ʋʋ pooɛ \"jua‑ fai\" ‑wɛe ka ʋʋ 'bɔa wɔn 'de nyʋ ‑wee' 'je ɛ juo‑. 'Ma 'tmʋʋ ao tɔ' ‑tɩ, ʋʋa' ‑nɩ ‑kei\" mɛ ʋʋa 'jea 'o 'mʋa‑. ");
INSERT INTO wob_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","'Kaa ‑bo ‑mɔ ‑bɔ wɔn ɛ, ‑mɛ ‑ɩn ‑gbai' \"jua‑, ‑ɩn ‑nmɔ ‑ma ‑cɛ\" 'kwa. ");
INSERT INTO wob_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","‑Ɩn ‑bo ‑ma ‑cɛ\" ipooɛ ‑wɛe ka ‑ɩn ‑bɔa wɔn, nyʋ ‑wee' je ɛ juo‑. ‑Ɩn \"Bo ‑ta ‑ɩn ‑nɩa ‑ɛ ‑nɩa 'o ɛ, ɛɛ' 'sʋ juuɛ'. 'De dɩ ‑ma nʋa 'de \"sran ‑ɩn \"bo ‑ɛ ‑juɩ ɛ, ɛɛ muɛ ‑ʋn ‑kei\" ‑saa'. ");
INSERT INTO wob_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","'De Sesi wlu' ke'wlɛ ɔ 'na : Ao 'bo aoa' \"wlii‑ \"jrui 'kɩɩɛn 'nɔ 'blʋa‑ \"kpei, kpain\" ke 'kɩn nɩa ɩa dooa dɩ, ‑wɛe \"jriʋn nɩa 'de ‑wi\" ‑mʋ a wa klu ʋʋa \"jria. ");
INSERT INTO wob_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Ao 'kɩɩn‑ aoa' \"wlii‑ \"jrui 'de jaʋn 'di 'demɔ wlɔn ke 'kɩn se ɛ 'bɛɛ‑ ɩ 'je dɛ dooa‑, 'demɔ \"jriʋn se ɛ 'bɛɛ‑ ʋʋ 'je klu wa ‑wɛe ʋʋ 'je \"jri. ");
INSERT INTO wob_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Dɛɛ‑tɩ 'ɩn 'da kan' a, ɛmɛ ‑nɩ ‑ta ‑ma \"wliiɛ‑ nɩa, 'bo ‑ma tɔ' ‑wee' \"klein \"biie‑ ‑ke. ");
INSERT INTO wob_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","\"Jriɛ‑ mɛ ‑nɩ nyiɔ 'ɔ ‑tau. ‑Bo ‑ma \"jriɛ‑ nɩ ka ‑cɔɔn' ka a, ‑mɛ ‑ma kui ‑sɔn i nɩɛ ‑pe' saa. ");
INSERT INTO wob_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","'Kaa ‑bo ‑maa' 'jei ɛ, ‑mɛ ‑ma nyiɔjɔ ‑wee' nɩɛ 'e kwie 'ʋn. 'De ‑bo ‑sɔn' ‑nɩa 'de ‑ɩn 'ʋn ‑srɛɛn kwie 'ʋn ɛ, ‑mɛ \"bɛɛ‑ kwie ‑ɩn ‑nɩ 'e 'ʋn ‑mɛ tai' \"maa ‑ʋn ‑ɛ 'bode. ");
INSERT INTO wob_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","'Bo ‑mɛ 'de ɛ, ɔ 'na : Nyɔ due' se ɛ 'bɛɛ‑ ɔ 'je nyʋ 'sɔɔn \"juɔi nʋʋ‑, ɔɔ muɛ due' 'ʋn 'nyɛa' see ‑wɛe ɔ 'je due' 'a ‑tɩ' kma, ɔɔ muɛ due' ‑flɛɛan' see 'de ɔ 'je due' o ‑si'. Ao se ɛ 'bɛɛ‑ ao 'je Kea 'a 'tʋn nʋ‑tɩ nʋ ‑wɛe ao 'je 'e 'wɛi 'a \"dia 'jea' 'blee‑. ");
INSERT INTO wob_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","Ɛmɛ ‑tɩ 'ma wlu ao ‑pee ka, 'ɩn 'naa : ao 'bo ‑fli i 'wlaa‑ 'de 'bleedɩ 'a ‑tɩ' 'ʋn, dɛ ao 'jea di o, dɛ ao 'jea 'na o, dɛ ao 'jea 'ʋnpaa o, dɛ‑nʋɛ' Kea mɛ ‑ɛ ‑nyɩ\" ao 'kmʋnɩa', 'de 'kmʋnɩa' \"paa', ɛ je diidɛ ‑sii. Ku nɩɛ dɛwɔn ɛ je 'ʋnpaadɛ ‑sii. ‑Aee' ɛ se kan' nɩ‑ ? ");
INSERT INTO wob_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Ao ‑gbʋn nʋʋɩ ‑ɩa ‑wan\" ja kea' ! Ɩa' nʋ dbo, ɩa' ‑tu\", ɩa' ‑sa. Ɩ se ‑gbu\" 'ble ‑wɛe diidɛ \"jɛi ‑tu\" ‑tɩ, 'kaa ao \"Bo ‑nɩa 'e jaʋn 'di a ‑gbaaɩn'. 'De aomɔ nɩɛ dɛwɔn kpɛ ‑puue ao je nʋʋɩ ‑sii‑. ");
INSERT INTO wob_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Nyɔ wɛ‑ ‑nɩ 'e aopʋ \"klu ‑wɛe 'de ‑ɔɔ ‑fli i'wlaa' 'ʋn ‑ɔ ‑beeɛ' ‑ɔ ‑je ɔɔ' 'wɩ ‑pɛ 'mlai\" po ɛ‑ ? ");
INSERT INTO wob_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","'De dɛɛ‑tɩ aoa 'wla 'ʋnpaadɩ 'a ‑fli i ɛ‑ ? Ao ‑gbʋn sii\" ‑nɩa 'e 'kwla 'di 'a ‑fan' sʋn ja, ɩa' nʋ dbo, ɩa' 'cra jee\". ");
INSERT INTO wob_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","'Kaa 'ma 'tmʋʋ aopʋ 'mɛ, ‑ta 'beɔ Salomɔ nɩa ɔɔ' 'beɔdɛ 'ʋn, ɔ se ‑pɛe ‑pʋn\" ‑tu\", ɔ se ɩa' due' koʋn ‑gbai' ‑sii. ");
INSERT INTO wob_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Sii\" ‑nɩa 'e 'kwla 'di ‑sɩan, ‑klae\" 'sʋ ‑ɩ ‑mɛa ‑wɛe nyʋ a poa \"jri ɛ, ‑bo Kea a sea ‑mɩ dɛ ‑pʋn\" ‑tu\" kan' ‑mɔ 'ee, ‑mɛ aopʋ mɔ 'e ! Ɛ seɛ 'bɛɛ ɛ 'je aopʋ‑ mɔ dɩ 'ʋn paa kan' ‑kee ? Ao ‑gbʋn ka aoa' Kea ‑kwlɩ\" ‑tea' sea \"i 'bɛ ɛ ! ");
INSERT INTO wob_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Ao 'bo \"jrii \"kaeɛ ‑wɛe ao 'bo wluɛ ka : Dɛ ‑a ‑je di ɛ‑, 'de dɛ ‑a ‑je 'na a‑, 'de dɛ ‑a ‑je ‑pʋn\" ‑tu\" ɛ‑ ? ");
INSERT INTO wob_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Nyʋ ‑sea' Kea juo ‑a nʋ kan' ‑mɔ. 'Kaa aopʋ mɔ dɛ ‑ɛɛ ‑tɩ' kma aopʋ \"bli ɛ, ao \"Bo ‑nɩa 'e jaʋn 'di juɛ'. ");
INSERT INTO wob_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Dɛ ao 'jea i ‑pɔn \"i‑saa nɔ\" ɛ, ɛmɛ ‑nɩ ao 'wɔɔn‑ Kea 'a ‑kwlʋtɩ ke \"isrɛa' ke, ‑wɛe dɩ \"klein ‑sia 'o mu 'de ɛ 'je ao ‑mɩ \"nyɩ 'bo ‑mɛ 'de. ");
INSERT INTO wob_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Ɛmɛ ‑tɩ ao 'bo ‑sɔɔn ‑tu\" ɛ 'de ‑klae\" wɩ 'a ‑tɩ' 'ʋn, dɛ‑nʋɛ' ‑klae\" wɩ 'a 'sʋ ‑ble ɛɛ' ‑cɛ\" 'ɛ ‑tɩ'. Dɛ ‑sɔn' toa 'o, ɛmɛ ao 'je. ");
INSERT INTO wob_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","Ao 'bo nyʋ 'a 'pee 'jeɛ ‑wɛe Kea je aoa' 'pee 'je. ");
INSERT INTO wob_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Dɛɛ‑tɩ 'ɩn 'da kan' a, ɛmɛ ‑nɩ ka aoa nʋa nyʋ 'a 'pee 'jesʋn ɛ, 'kamɔ Kea 'je aoa' 'pee 'jesʋn nʋ ‑ke. ‑Ta ao dbaa ‑wɛe ao \"nyɩa nyʋ ɛ, 'bomɔ nyʋ 'je dbaa ‑wɛe nyʋ 'je ao \"nyɩ ‑ke. ");
INSERT INTO wob_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Dɛɛ‑tɩ ‑ma ‑je tu 'a ‑fii\" ‑saan\" i 'de ‑ʋn ‑podɛi\" \"jri ‑wɛe tutie ‑nɩa 'e ‑ʋn \"jri ‑maa' 'je mɛ i ɛ‑ ? ");
INSERT INTO wob_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","'De ka ‑ɩn ‑beeɛ' ‑ɩn ‑je nyɔ ‑pee wlu ‑ɩn ‑je nʋ : 'Ma de'di, ‑ɩn ‑bɔ ke, 'ɩn 'je ‑ʋn dɛ‑saan\" ‑nɛ \"jri ‑sa, 'de ‑mɛ 'kamɔ tutie nɩ 'e ‑ma ‑nɛ 'di ɛ‑ ! ");
INSERT INTO wob_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","\"Jridepooi, ‑ɩn ‑sa ‑ma ‑cɛ\" tutie \"jri ke tɛin\" ‑wɛe ‑ɩn ‑je ‑ma de'di tu 'a ‑fii\" \"jri ‑sa ka 'je. ");
INSERT INTO wob_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","Dɩ ‑teea kpɔi\" 'de Kea 'a ‑tɩ' 'ʋn ɛ, ao 'bo ɩ ‑gbe' \"nyɩɛ ‑wɛe ɩ je 'de aopʋ o \"biie‑, 'de ɩ je aopʋ i'fae‑. Ao 'bo aoa' ‑pɛe ipoɛ 'bo be\" \"juɔi ‑wɛe ɩ jɩ \"kpei‑ na‑. ");
INSERT INTO wob_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","Ao ‑tee' dɛ i, nyʋ a muɛ ao \"nyɩa'. Ao ‑pɔn dɛ i, aoa muɛ 'jea'. Ao bla klu, nyʋ a muɛ ao \"wɔin kaian'. ");
INSERT INTO wob_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Dɛ‑nʋɛ' nyɔ \"o nyɔ ‑teea' dɛ i ɛ ɔɔ 'jeeɛ. Nyɔ \"o nyɔ ‑pɔan' dɛ i ɛ, ɔɔ 'jeeɛ'. Nyɔ \"o nyɔ ‑bla' klu ɛ, nyʋ a kaiɛn ɔ \"wɔin. ");
INSERT INTO wob_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","'De nyɔ ‑nɩ 'e aopʋ \"klu ‑bo ‑ɔɔ \"ju ‑tee' ɔ ‑di'pɛn i, 'sʋ ‑ɔɔ ‑nyɩ\" ɔ \"soukpo ɛ‑ ? ");
INSERT INTO wob_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","'De ‑bo ɔ ‑tee' ɔ ‑smii' i 'sʋ ‑ɔɔ \"nyɩ ɔ sɛn ɛ‑ ? ");
INSERT INTO wob_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Aopʋ ‑jɔ ‑nyniia 'di wɔn ɛ, ‑bo ao juo aoa' \"nynuu‑ dɩ 'dɔe 'a \"nyɩ ka 'ee, ‑mɛ ao \"Bo ‑nɩa 'e jaʋn 'di se ɛ 'bɛɛ‑ ɛ 'je ao dɩ 'dɔe \"nyɩ, ɛ 'je 'o ‑mɔ ‑sii ? Nyʋ ‑ʋʋa ‑teeɛ' dɛ i ɛ, ɛɛ mu ʋʋpʋ \"nyɩa' se. ");
INSERT INTO wob_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Dɩ aoa ‑pɔan' nyʋ 'jea aopʋ \"jrii nʋ ɛ, ɩmɩ ao 'je nʋ 'de nyʋ ‑pee. 'Kamɔ Moisɩ 'a kɛ' ke Kea 'a wlu 'kwajaaʋn 'da. ");
INSERT INTO wob_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","Ao paa 'bo ‑gbɛin\" ‑je ‑saan\" \"i, dɛ‑nʋɛ' ‑je mua 'e \"ma‑kwlɔ 'di 'bɛ \"kpei, ɛɛ' kpaa' \"kʋan \"jrii. Nyʋ ‑ʋʋa kpa ɛɛ' ‑je ‑tu ɛ, ʋʋ ‑tiɛi\". ");
INSERT INTO wob_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","'Kaa ‑je mua 'e 'pʋ‑kwlɔ 'di ɛ, ɛ ‑srɛi\" ‑wɛe ɛ 'piie \"i, ɛ se 'wɔn i 'bɛ, ɛɛ' kpaa' nɩɛ 'kle. Nyʋ ‑ʋʋa kpa ɛɛ' ‑je ‑tu se \"i ‑tie. ");
INSERT INTO wob_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","Ao ‑tu\" aoa' ‑cɛ\" 'ɛ ‑tɩ' 'de nyʋ ‑ʋʋa ‑daa' ʋʋa' ‑cɛ\" Kea 'a wlu 'kwajaaʋn 'a ‑tɩ' 'ʋn. ‑Bo ʋʋa sea aopʋ ‑pee ji ɛ, ka ‑ci' a paa 'blaaku 'ʋn, 'kamɔ ʋʋ nɩ‑. ");
INSERT INTO wob_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Aoa muɛ ʋʋpʋ \"ijua' 'de ʋʋa' nʋʋkplɩn 'ʋn. Nyɔ se ɛ 'bɛɛ‑ ɔ 'je 'mawlobuo ke ‑fokabuo ‑sa 'bo \"wi‑gbau'o ja. ");
INSERT INTO wob_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Tu 'dɔe a croɛ \"buo 'dɔe ‑wɛe tu saʋn a cro \"buo saʋn. ");
INSERT INTO wob_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Tu 'dɔe se ɛ 'bɛɛ‑ ɛ 'je \"buo saʋn cro‑, 'de tu saʋn se ɛ 'bɛɛ‑ ɛ 'je \"buo 'dɔe cro‑. ");
INSERT INTO wob_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Tu \"o tu ‑sea' \"buo 'dɔe cro ɛ, ɛɛ muɛ dbaa' ‑wɛe ɛ 'je 'o \"jri pooɛ‑. ");
INSERT INTO wob_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","‑Bo ɛ nɩ kan' 'ja a, ‑mɛ 'de ʋʋpʋ 'a nʋʋdɩ 'ʋn mɔ ao 'je ʋʋa' \"kpei‑ ‑seea' ka juo‑. ");
INSERT INTO wob_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","Sesi 'naa : Nyʋ ‑ʋʋa ‑daa' 'ʋn : Tʋ\"bo, Tʋ\"bo, ʋʋ ‑wee' se kan' 'de Kea 'a kɛɛma' ‑kwlɔ 'di mui, 'kaa nyɔ ‑ɔɔ nʋa 'ɩn \"Bo ‑nɩa 'e jaʋn 'di 'a ‑kwlʋtɩ ɛ, ɔɔ' 'sʋ mɔ ‑je 'emu. ");
INSERT INTO wob_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","'De ɛɛ' 'wɩ tu 'di ɛ, nyʋ ‑tuu\"‑tuu a muɛ 'ʋn ‑pee wlua' ka : Tʋ\"bo, Tʋ\"bo, ‑apʋ ‑ɔ ‑tmʋa ‑ma ‑tɩ' ‑tmʋʋ' ‑tmʋʋ\"‑, ‑a ko ‑taa ? ‑Apʋ Kea jaa wlu 'kwa, ‑ɔ ‑tmʋa ‑mɩ, ‑apʋ ‑nʋa' ‑siisaɩn i 'de ‑ma 'nynɩ 'ʋn, ‑a ko ‑taa ? ‑Apʋ ‑nʋa jrii' ‑tuu\"‑tuu 'de ‑ma 'nynɩ 'ʋn, ‑a ko ‑taa ? ");
INSERT INTO wob_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","'Bo 'ma mu wlua' ka 'de ʋʋ ‑pee, 'ɩn se ao juo due'. Ao tɛɛn 'ʋn kɩn, ao dɛsaʋn nʋ nyʋ. ");
INSERT INTO wob_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","Kamɔ wlu 'ma 'wlʋa 'tmʋa' ‑ta nyɔ \"o nyɔ ‑ɔ poa ɩ doin\" o ‑wɛe kɩ \"sia 'nynɩ ‑ɔ nʋa kan' a, ‑mɛ ɔ ‑kɔ' tɔ'di nɩ i ‑ɔ poa ɔɔ' ‑gbu\" 'bo 'soa‑ \"kpei ɛ. ");
INSERT INTO wob_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","\"Ni klaa\" ‑dba', \"ni‑gbii \"jii', ‑piie klaa\" ji' ‑wɛe ɩ bla ‑gbu\" ‑nɛ \"jri ‑bla ‑bla, 'kaa ɛ se blu, dɛ‑nʋɛ' ɛɛ' ‑gban ‑teeɛ' 'bo 'soa‑ \"kpei. ");
INSERT INTO wob_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","'Kaa nyɔ \"o nyɔ ‑ɔɔ poa wlu ‑nɩ doin\" o 'de kɩ \"sia 'nynɩ ‑ɔɔ' nʋa kan' ‑mɛ ɔ ‑kɔ' \"ju ‑ɔ sea tɔ'di nɩ ‑wɛe ‑ɔ poa ‑gbu\" 'bo ‑pɩɩɔn\" \"kpei ɛ. ");
INSERT INTO wob_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","\"Ni klaa\" dba', \"ni‑gbii \"jii, ‑piie klaa\" ji', ‑wɛe ɛ bla ‑gbu\" ‑nɛ wɔn ‑bla ‑bla, 'sʋ ‑gbu\" ‑nɛ blu' piepie. ");
INSERT INTO wob_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","‑Ta Sesi ‑kɔa' wlu ‑nɛ 'ɛ 'tmʋa' 'sʋ ɛ, ɔɔ' nyʋ dɛtɔɔsʋn \"maa nyʋ ‑kwea de tai', ");
INSERT INTO wob_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","dɛ‑nʋɛ' ɔɔ' nyʋ dɛtɔɔsʋn ke kɛ' wɔ‑saʋn 'a ‑nɛ ‑seea' \"kpei. Ɔɔ' wlu a \"siɛ nyʋ \"i ka ‑cɔɔn' ka. ");
INSERT INTO wob_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Sesi ‑crea' crʋ 'sʋ ɛ, nyʋ ‑tuu\"‑tuu ‑kaan ɔ 'de. ");
INSERT INTO wob_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","'Sʋ 'jrʋwɛ‑nʋi due' 'kpa ɔ ‑pʋn\" ‑wɛe ɔ \"sii‑ 'kɔi‑ i 'bo ɔ \"juɔi 'de ɔ 'na : 'Ma 'blei, ‑bo ‑ɩn ‑nɩɛ \"i ɛ, ‑ɩn ‑beeɛ' ‑ɩn ‑je 'ma 'wɛ‑ 'bɔɔ‑, 'ɩn 'je 'pepe nɩ‑. ");
INSERT INTO wob_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","'Sʋ Sesi sroɛ sʋn, ɔ blɔ \"i 'de ɔ 'na : 'Ɩn ‑nɩɛi\" 'mɛ, ‑ɩn ‑nɩ 'pepe. 'Bo ɛ \"sri 'jrʋwɛ‑ je \"ju ‑nɩa 'mʋa‑ ‑pʋn\" 'wlʋ, ɔ je 'pepe nɩ‑. ");
INSERT INTO wob_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","'Sʋ Sesi wlu ɔ ‑pee ɔ 'na : ‑Ɩn po doin\" i, dɛ ‑nʋʋa ‑ta ‑ɩn ‑bo ɛ nyɔ jrɔ' ‑pee 'tmʋɛ. 'Kaa ‑ɩn mu ‑ɩn ‑je ‑ma nɩsʋn to 'de Kea 'a 'sraa ‑sai o ‑wɛe ‑ɩn ‑je 'sraadɛ ja‑ ka Moisɩ 'a kɛ' 'da, 'de ka ‑ma 'wɛ‑ 'bɔa nyʋ ‑wee' \"klein 'je ɛ juo‑. ");
INSERT INTO wob_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","‑Ta Sesi a paa 'o Kapɛnaʋm 'sʋ ɛ, \"soa‑wi\" 'a \"jruo ‑tei due' 'kpɔ ‑pʋn\" ‑wɛe ɔ ‑tee' Sesi i ɔ 'je ɔ sʋn o po. ");
INSERT INTO wob_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","Ɔ 'na : 'Ma 'blei, 'ma dbonʋi 'pɛn i 'de ‑gbɛin\", ɔɔ' dɩ ‑wee' 'mɛɛ, ɔɔ' ‑suua' i ‑wɛe ɔɔ 'je ɔɔ' ‑cɛ\" wɔn kpleiin. ");
INSERT INTO wob_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","'Sʋ Sesi 'na : 'Ma muɛ mua', 'ɩn 'je ɔɔ' 'wɛ‑ 'bɔɔ‑. ");
INSERT INTO wob_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","'Sʋ jra' jei ‑nɔ 'na : 'Ma 'blei, 'ɩn se ɛɛ' ka nɩ ‑wɛe ‑ɩn ‑je 'de 'ʋn o ‑gbu\" 'di pa, 'kaa ‑bo ‑ɩn ‑tmʋ wlu due' koʋn ‑gbai' ɛ, 'ma dbonʋi a muɛ 'pʋʋa'. ");
INSERT INTO wob_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","'Mɔ ‑nɔ, 'ɩn 'bleɛ \"jru kpɔ' i ‑teʋn ‑wɛe 'ɩn 'ble \"soa jrʋ' ‑ke 'bo 'ʋn ‑sɔn. ‑Bo 'ɩn wlu 'e due' ‑pee, ‑bo 'ɩn 'na : ‑Ɩn ‑mu', 'sʋ ‑mɔɔ' mu'. ‑Bo 'ɩn wlu jrɔ' ‑pee, ‑bo 'ɩn 'na : ‑Ɩn ‑ji, 'sʋ ‑mɔɔ ji'. 'De ‑bo 'ɩn wlu 'de 'ma dbonʋi ‑pee, ‑bo 'ɩn 'na : ‑Ɩn nʋ ‑jɛ, 'sʋ ɔɔ nʋɛ'. ");
INSERT INTO wob_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Sesi 'wɔan wlu ‑nɛ 'sʋ ɛ, ɔɔ 'jraa \"ju ‑nɔ 'mɛ, ‑wɛe ɔ wlu 'e nyʋ ‑ke ɔɔ na ‑pee, ɔ 'na : tɔ' ‑tɩ 'ma 'tmʋʋ aopʋ 'ɩn se Kea ‑kwlɩ\" ‑tea' ‑jɛ ‑bɛa ka ‑mɛ 'je due' 'de Israɛ‑blʋa 'a ‑cɛ\" 'kpa \"kpei. ");
INSERT INTO wob_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","'Ma 'tmʋʋ aopʋ‑ 'mɛ, nyʋ ‑tuu\"‑tuu a mu 'e 'jrʋ kwea ke 'jrʋ ‑sɔɩn 'wlʋa' ‑wɛe ʋʋ 'je o Ablaam ke, Isaakɩ ke, Sakɔbʋ ‑pʋn\" mu 'de ʋʋ 'je sʋn ‑tadue po 'de Kea 'a kɛɛma' ‑kwlɔ 'di. ");
INSERT INTO wob_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","'Kaa nyʋ ‑tea 'beɔdɛ ‑nɛ 'ɛ ‑tea' 'de ɛ, ‑wi\" ‑mʋ a muɛ 'e \"kpae' ‑fii\" 'a ‑ta ‑fɩn\" 'a ke 'nynɩ \"idiia' nɩa 'de kwie 'di. ");
INSERT INTO wob_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","'Sʋ Sesi wlu' 'de jra' jei ‑pee ɔ 'na : ‑Ɩn mu, ka ‑ɩn ‑tea' 'ʋn ‑kwlɩ\" ɛ, ɛ nʋʋɛ kan'. 'Bo ɛ \"sri ɔɔ' dbonʋi 'a 'wɛ‑ je 'bɔ. ");
INSERT INTO wob_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Sesi muɛ 'e Piɛi o ‑gbu\" ɔ jɛɛ Piɛi 'a \"bianynɔ ‑mɛ ʋ 'pɛn i, ʋa' \"jru ‑a ‑bai'. ");
INSERT INTO wob_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Ɔ bla ʋa' sʋn \"i 'sʋ ʋa' \"jru 'bɔɔ ‑wɛe ʋ sɔn 'ʋn 'de ʋ pi ʋʋpʋ ‑pee. ");
INSERT INTO wob_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","‑Kwie\" ka a, ʋʋ ja Sesi nyʋ ‑tuu\"‑tuu ‑siisaɩn nɩa 'e 'ʋn ɛ. Sesi nʋɛ ɔɔ' wlu 'a 'sʋ ɔ je ‑siisaɩn i nʋ, ‑wɛe ɔ je nyʋ ‑wee' \"klein 'a 'wɛ‑ 'bɔɔ ‑ke. ");
INSERT INTO wob_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Ɔ nʋ ɛɛ' dɛ tu 'mɛ ‑wɛe wlu Kea 'a wlu 'kwajaai Esai 'tmʋa tɛin\" sese 'de‑ 'je 'o nyni. Ɛɛ' wlu tu 'na : ɔ \"duo ‑aa 'kle ‑wee' 'ʋn 'ɛ, ‑wɛe ɔ ‑sa ‑aʋn ‑aa dɛsaʋn 'a 'wɛ‑ 'ɛ ‑gbɛ \"jru. ");
INSERT INTO wob_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Sesi ‑gbʋan nyʋ ‑gbae' ɔ 'dei ja 'sʋ, ɔ 'na : ‑A ‑muu 'e 'kpʋʋ 'de. ");
INSERT INTO wob_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","'Sʋ kɛ' wɔ‑sai due' 'kpa ɔ ‑pʋn\" ‑wɛe ɔ wlu ɔ ‑pee ka, ɔ 'na : Nyʋ dɛtɔɔi, ‑ta \"o ‑ta ‑ma mua ‑ɩn ‑ke 'ma muɛ 'o mua'. ");
INSERT INTO wob_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Sesi 'na : Too'wɛ‑ 'bleɛ \"bie, nʋʋɩ 'bleɛ 'jro. 'Kaa nyiɔ 'ɔ \"Ju se \"jru 'wlaa ‑ta 'ble. ");
INSERT INTO wob_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","'Sʋ deejrɔ' ‑wlʋ 'de ɔɔ' klai\" nynuu \"klu, ‑ɔ ‑na : Tʋ\"bo, ‑ɩn ‑nyɩ\" 'ʋn nɔ\" 'ɩn 'je 'ʋn \"bo i ‑tea' mu ke kpɩɩn‑. ");
INSERT INTO wob_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","'Kaa Sesi 'na : ‑Ɩn bla 'bo 'ʋn 'de. ‑Ɩn ‑tai\" 'mɛʋn \"i, ʋʋ 'je ʋʋa' 'mɛʋn inmae‑. ");
INSERT INTO wob_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","'Bo ‑mɛ 'de 'sʋ ɛ, Sesi 'ja 'e ‑kwɛɛ\" 'di ‑wɛe ɔɔ' klai\" nynuu bla 'bo ɔ 'de. ");
INSERT INTO wob_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","‑Ta ʋʋa mua 'sʋ ‑piie cɛn \"jɛi 'bo \"ni \"kpei, \"ni 'a 'plɩ a 'wla 'e ‑kwɛɛ\" 'di, 'kaa Sesi a 'mʋʋ. ");
INSERT INTO wob_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Ɔɔ' klai\" nynuu 'kpɔ ‑pʋn\" ‑wɛe ʋʋ ‑sɔ \"nyɩɔ' 'de ʋʋ 'na : Tʋ\"bo, ‑ɩn ‑pʋʋ' ‑aʋn 'de, ‑aa ‑mɛɛ' ! ");
INSERT INTO wob_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","'Sʋ ɔ sɔn \"nyɩɔ' ‑wɛe ɔ wlu 'de ʋʋ o, ɔ 'na : Dɛɛ‑tɩ faʋn a nʋ aopʋ ɛ‑ ? Ka aoa' dɛ ‑kwlɩ\" ‑tea' nɩ tɔi‑ kan' a‑ ! 'Sʋ ɔ sɔn 'ʋn 'ɛ ‑wɛe ɔ \"wɔɔ‑ ‑piie ke \"ni 'a 'plɩ \"jrui, 'de ‑ta ‑wee' nʋɛ ‑snii'. ");
INSERT INTO wob_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","'Sʋ tai' \"maa ʋʋ ‑wee' \"klein 'mɛ. ʋʋ 'na : Dɛɛ ‑nyɔ ‑nɩ ka ‑mɔ ‑wɛe ‑piie ke \"ni a 'je ɔ wɔn ɛ‑ ? ");
INSERT INTO wob_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","‑Ta Sesi nynia 'e \"ni 'de ɛ, 'de Gadarɛ nyʋ \"bli ɛ 'sʋ nyʋ 'sɔɔn ‑wlʋ 'e ‑gbaɩn' 'di ‑ʋʋ ‑jɔɔ' \"i. ‑Siisaɩn ‑nɩ 'e ʋʋpʋ 'ʋn, ʋʋ nɩɛ wɔn ‑sansan, ‑ta ʋʋ nɩa, nyɔ jrɔ' 'ɔ ‑sii 'o. ");
INSERT INTO wob_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","'Sʋ ʋʋ \"wɔɔ' ʋʋ 'na : Kea 'a \"Ju, dɛ ‑nɩ 'o ‑ɩn ‑ke ‑a 'nynɩ ɛ‑ ? Nɔ\" se nyni 'sʋ ‑ɩn ‑je ‑a 'kle \"kpei ja a‑ ? ");
INSERT INTO wob_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","‑Ta ɛ nɩa kan' a, ‑mɛ be\" 'a ‑gbʋn jrɛ' ‑tɛɛn ʋʋpʋ o, ‑wɛe ‑ɛɛ dii. ");
INSERT INTO wob_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","'Sʋ ‑siisaɩn baeɛ Sesi i ɩ 'na : ‑Bo ‑ɩn nʋ ‑a i ɛ, ‑mɛ ‑ɩn po ‑aʋn 'de be\" 'a ‑gbʋn ‑nɛ 'ʋn. ");
INSERT INTO wob_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Sesi wlu ɩ ‑pee ɔ 'na : Ɩ mu ! Ɩ 'wlʋa 'e nyʋ 'sɔɔn ‑nʋ 'ʋn 'sʋ ɩ pa 'e be\" 'ʋn. 'Sʋ be\" 'a ‑gbʋn ‑nɛ ‑sa plea' 'de crʋ 'a ‑peenai\", 'sʋ ɩ 'wla 'o \"niɔ‑. 'De ɩ blu \"ni ‑tun, ‑wɛe ɩ 'mɛ. ");
INSERT INTO wob_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Nyʋ ‑tea be\" 'dei 'jeea dɛ ‑nʋʋa nyʋ 'sɔɔn ‑siisaɩn 'wlʋa 'e 'ʋn jriɛ‑ 'sʋ ʋʋ ple' ʋʋ muɛ ‑kwlɔ ‑wɛe ʋʋ po ɩa' \"kuan. ");
INSERT INTO wob_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","'Sʋ ‑kwlɔʋn ‑wee' \"klein ‑kwɛ‑ 'e ‑kwlɔ i, ʋʋ 'jaa‑ Sesi \"i, ‑wɛe ʋʋ ‑tee ɔɔ' ibaea' ‑pʋn\" 'de ɔ 'je 'de ʋʋa' 'blʋa‑ \"kpei 'wlʋ. ");
INSERT INTO wob_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Sesi 'ja 'e ‑kwɛɛ\" 'di ɔ cɛan \"ni 'sʋ ɔ muɛ 'de ɔ o ‑kwlɔ. ");
INSERT INTO wob_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","'Sʋ ʋʋ jɔ klɔɔi due' ‑ɔ ‑pɛn i 'de 'sai‑ 'di. Sesi 'jeea nyʋ ‑nʋ 'a ɔɔ' ‑kwlɩ\" ‑tea' 'sʋ ɛ, ɔ wlu' 'de klɔɔi ‑pee ɔ 'na : 'Ma \"ju, ‑ɩn ‑duo\" 'kpɩ 'ʋn, ‑ma dɩsaɩn ‑kwɛ' 'bode. ");
INSERT INTO wob_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","'Bomɔ kɛ' wɔ‑saʋn jrʋ' ‑tee 'mii wlua' ‑pʋn\" ʋʋ 'na : \"Ju ‑nɔ ‑mɔ ɔ to Kea wɔn o kan' ‑mɔ ɛ‑ ! ");
INSERT INTO wob_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Sesi jua tɔ' ʋʋpʋ a naa i 'sʋ ɔ 'na : Dɛɛ‑tɩ aoa' tɔ' nyni \"jrii kan' 'de aopʋ 'ʋn ɛ‑ ? ");
INSERT INTO wob_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Dɛ ‑jɛ ‑kmai\" ɛ‑ ? ‑Ɩn ‑na ‑ma dɩsaɩn ‑kwɛ' ‑ae, ‑aee' ‑ɩn ‑na ‑ɩn ‑sɔn 'ʋn ‑ɩn ‑je na a‑ ? Dɛ aoa naa tɔ' i ɛ‑ ? ");
INSERT INTO wob_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","'Ɩn nɩɛ \"i ao 'je ɛ juo‑ ka 'mɔ nyiɔ 'ɔ \"Ju 'ɩn 'blea \"ikmaa' 'de 'blʋa‑ \"kpei 'ɩn 'jea nyʋ 'a dɩsaɩn ‑kwɛ' ɛ. 'Bomɔ ɔ wluu 'de klɔɔi ‑pee ɔ 'na : ‑Ɩn ‑sɔn 'ʋn ‑ɩn ‑je ‑ma \"kpei 'pɛndɛ 'ʋn \"duo‑, ‑ɩn ‑je 'de ‑ʋn wɔin\" mu. ");
INSERT INTO wob_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","\"Ju ‑nɔ sɔn 'ʋn 'ɛ kan' ‑cɛɛn'‑, 'sʋ ɔ kpʋɛn ‑gbɛin\" ‑je i. ");
INSERT INTO wob_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Faʋn a nʋ nyʋ \"klein ‑jea dɛ ‑nɩa 'mʋa 'a ‑ta 'mɛ, 'sʋ ʋʋa poɛ Kea 'sɛ‑ dɛ ɛ \"nyɩa nyiɔ \"ikmaa' ‑nɛ. ");
INSERT INTO wob_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Sesi 'wlʋa 'mʋa‑ ɔ muɛ 'e nya, ɔ 'jeɛ \"ju due' nyʋ a 'daa Matie \"jriɛ ‑ɔ ‑teɛ i 'de 'wɛi‑sagbu 'di. Sesi wlu ɔ ‑pee ɔ 'na : ‑ɩn bla 'bo 'ʋn 'de. Matie sɔan 'ʋn 'sʋ ɔ bla 'o Sesi 'de. ");
INSERT INTO wob_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Ɛ 'wlʋa 'o mu ɛ, Sesi a diɛ dɛ 'de Matie o ‑gbu\" 'sʋ 'wɛi‑saʋn o, nyiɔpʋ‑ ‑saɩn ji' ‑wɛe ʋʋ ke Sesi ke ɔɔ' klai\" nynuu bee o 'de ʋʋa dii ‑tadue. ");
INSERT INTO wob_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Fariseɛn‑wi\" 'jeea dɛ ‑nɩa 'mʋa‑ \"jriɛ‑ 'sʋ ɛ, ʋʋ wlu' 'de ɔɔ' klai\" nynuu ‑pee ʋʋ 'na : Dɛɛ‑tɩ aoa' dɛtɔɔi ke 'wɛi‑saʋn ke nyiɔpʋ ‑saɩn a dii ‑tadue ɛ‑ ? ");
INSERT INTO wob_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Sesi 'wɔan ʋʋa' wlu ‑nɛ 'sʋ ɔ 'na : Nyʋ ‑ʋʋa kui ‑sɔn flɔan i ɛ, ʋʋa' ‑pɔn ‑dɔ'crɔi, ɛ nɩ nyʋ 'wɛ‑ ɛ nʋa ʋʋpʋ ‑a ‑pɔn ‑dɔ'crɔ i. ");
INSERT INTO wob_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Dɛ wlu ‑crɩɩa' 'tmʋa, ao mu ao 'je ɛ 'cɩan. Ɛ 'naa : Nyʋ 'a wɛe 'jea' mɛ ‑ɛɛ \"dia 'ma 'je, ɛ ‑sii 'sraa‑ ‑saa'. 'Ɩn se \"isrɛnyʋ 'a ‑tɩ' ji, dɩsaɩnʋʋn 'a ‑tɩ' mɛ ‑tɩ 'ɩn ji. ");
INSERT INTO wob_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","San Batisɩ 'a klai\" nynuu jiɛ 'de Sesi o 'sʋ ʋʋ 'na : Dɛɛ‑tɩ ‑a ‑ke Fariseɛn‑wi\" a 'bɔ wɔn 'de ‑ma ‑nɩ klai\" nynuu 'a 'bɔ wɔn ɛ‑ ? ");
INSERT INTO wob_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","'Bomɔ Sesi wluu ʋʋpʋ ‑pee ɔ 'na : Nyʋ nyɔ 'da 'de ba \"blitia 'a ‑kɔ' ‑sɔn 'ee, ʋʋ 'beeɛ' ʋʋ 'je \"jrii \"kae‑, 'de ‑mɛ 'kamɔ ʋʋ ke 'nynɔjei ‑te ii ? \"Ɩɩn‑, ɛ se kan' nɩ‑, 'wɩ jrɛ' ‑ɛɛ mu nynia' ‑wɛe 'nynɔjei 'je 'de ʋʋpʋ \"klu 'wlʋ. 'De ‑mɛ 'ɛ 'wɩ tu 'di ɛ, ʋʋa muɛ wɔn 'bɔa'. ");
INSERT INTO wob_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Nyɔ se ɛ 'bɛɛ‑ ɔ 'je \"wliiɛfɔ dee 'ʋn \"duo‑, ‑wɛe ɔ 'je ɛ 'o \"bai ‑gbau\" 'a 'fae ‑kɔi\" \"paa‑. ‑Bo ɛ nɩ kan' a, \"wliiɛfɔ ‑dee a poɛ \"bai soa 'a 'fae ‑kɔ de sɔɔn‑ sɔɔn‑. ");
INSERT INTO wob_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Nyɔ se ɛ 'bɛɛ‑ ɔ 'je nmɔ dee 'de bi ‑gbai\" 'di po ‑wɛe ɔ 'je ɛ \"wɔin \"sun. ‑Bo ɛ nɩ kan' a, bi ‑gbau\" a muɛ waa' ‑wɛe nmɔ 'je i 'wla, 'de nmɔ ke bi 'je dooa‑. 'Kaa nyɔ ɔ poɛ nmɔ dee 'de bi dee 'di, ‑mɛ nmɔ ke bi se idooai. ");
INSERT INTO wob_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","‑Ta Sesi nɩɩa ʋʋa' wlu ‑pee 'tmʋa' 'sʋ Suifʋ‑wi\" 'a klaa\" due' ‑ji'. Ɔ \"siiɛ 'kɔi‑ i 'bo Sesi \"juɔi ‑wɛe ɔ 'na : 'Ma \"junynɔkpao' 'mɛa, ɛ se 'ʋn ‑kwle ke, ‑ɩn ji ‑ɩn ‑jʋ kwa \"jru ‑te' ‑wɛe ʋ 'je 'kmʋ de ji. ");
INSERT INTO wob_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Sesi sɔan 'ʋn 'sʋ ɔ ke ɔɔ' klai\" nynuu bla 'o ɔ 'de. ");
INSERT INTO wob_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","'De ɛɛ' nɔ\" tu 'di, 'bomɔ 'nynɔkpao' due' nmi‑kwliwɛ‑ nʋa 'de ‑sɩn 'a ‑puue 'jɔ 'sɔɔn 'di ɛ, ʋ 'kpa Sesi ‑pʋn\" 'de ɔ 'de fɔ o ‑wɛe ʋ bla ɔɔ' \"bai 'a wɔn \"i, ");
INSERT INTO wob_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","dɛ‑nʋɛ' ʋ wlu' 'de ʋa' ‑cɛ\" 'ʋn ka ʋ 'na : ‑Bo 'ɩn bla ɔɔ' \"bai mɔ 'ɔ ‑cɛi\" 'de 'ɛ, 'ma 'wɛ‑ ɛ muɛ 'bɔa'. ");
INSERT INTO wob_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Sesi \"biia de 'sʋ ɔ 'jeʋ ‑wɛe ɔ 'na : A \"duo 'kpɩ 'ʋn 'ma \"ju, aa' 'ma ‑kwlɩ\" ‑tea' 'pʋʋ‑ aʋn 'ɛ. 'Bo ɛ \"sri 'nynɔkpao' ‑nʋ 'a 'wɛ‑ je 'bɔ. ");
INSERT INTO wob_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","‑Ta Sesi a nynia 'de \"ju ‑nɔ wɔin\" ɛ, ‑mɛ ‑kweenblaʋn ke nyʋ ‑tuu\"‑tuu 'a ‑fɩn\" ‑cruɛn\" ɛ 'kpaa'. ");
INSERT INTO wob_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","'Sʋ ɔ 'na : Ao ‑saa kɩn ke, \"ju ‑saan\" se 'mɛ, ʋa 'mʋʋ. Ɔ 'da kan' 'sʋ ʋʋa wlɔɔ'. ");
INSERT INTO wob_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Ʋʋ poa nyʋ ‑wee' \"kpae' 'sʋ Sesi pa 'e \"ju ‑saan\" 'a 'pɛn 'ɩn ‑wɛe ɔ kpʋn ʋa' sʋn 'sʋ ʋ sɔn 'ʋn 'ɛ. ");
INSERT INTO wob_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Dɛ ‑nʋʋa 'mʋa‑ ɛɛ' 'nynɩ \"siiɛ 'blʋa‑ ‑wee' \"klein \"i. ");
INSERT INTO wob_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Sesi 'wlʋa 'mʋa‑ ɛ ɔ ‑si' 'e ‑tajrɔ, 'sʋ \"dɔ ʋn‑ 'sɔɔn ‑bla' 'bo ɔ 'de ‑ʋʋa ‑wɔ\". Ʋʋ 'na Dafidɩ 'a \"Ju, ‑ɩn ‑je ‑aa wɛe‑ 'de. ");
INSERT INTO wob_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Sesi nynia ‑gbɛin\" 'sʋ, \"jri 'a waʋn ‑nʋ 'kpɔ ‑pʋn\" ‑wɛe ɔ ‑tee' ʋʋpʋ i, ɔ 'na : Ao 'je ɛ tɔ' 'ʋn 'ɛɛ, 'ɩn 'beeɛ' 'ɩn 'je ɛɛ' dɛ tu nʋʋ ? 'Sʋ ʋʋ 'na : Ɩɩn, Tʋ\"bo. ");
INSERT INTO wob_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","‑Wɛe Sesi bla ʋʋpʋ 'a \"jri \"i 'de ɔ 'na : Ka ao ‑tea' 'ʋn ‑kwlɩ\" ɛ, 'ka ɛ 'je aopʋ \"jrii nʋʋ ɛ. ");
INSERT INTO wob_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","'Sʋ ʋʋa' \"jri 'bai', ‑wɛe Sesi ‑te' ʋʋpʋ kɛ' \"i 'de ɔ 'na : Dɛ ‑nʋʋa ‑ta, ao 'bo ɛ 'tmʋɛ 'de nyɔ jrɔ' ‑pee, ao 'bo 'ma 'nynɩ \"siiɛ. ");
INSERT INTO wob_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","'Kaa ʋʋ mua, ʋʋ ‑teɛ Sesi 'a 'nynɩ 'blʋa‑ ja ‑kɔa' ‑pʋn\". ");
INSERT INTO wob_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","‑Ta ʋʋ nɩɩa mua' 'sʋ ɛ, ʋʋ ja Sesi \"muu‑ due' ‑suusaʋn nɩ 'e 'ʋn. ");
INSERT INTO wob_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Sesi nʋa ‑suusaʋn ‑nɛ i 'sʋ \"ju ‑nɔ ‑teɛ wlua' ‑pʋn\". Nyʋ ‑jea ɛɛ' ‑ta tai' \"maa ʋʋpʋ 'mɛ, 'sʋ ʋʋ 'na : ‑A se dɛ ‑nɛ ‑mɛ 'ɛ dɛ tu 'je due' 'de Israɛ‑blʋa \"kpei. ");
INSERT INTO wob_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","'Kaa Fariseɛn‑wi\" ‑mʋ 'na ‑siisaɩn 'a klaa\" mɛ ‑nyɩ\" ɔ \"ikmaa' ‑wɛe ɔɔ nʋ ‑siisaɩn i kan'. ");
INSERT INTO wob_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Sesi a pleɛ ‑kwlɛ klae\" ke ‑kwlɛ mɩɩ\" 'dii, ‑wɛe ɔɔ tɔɔ nyʋ dɛ 'de Suifʋ‑wi\" 'a \"jrui 'kɩɩn‑gbi 'dii. 'De ɔɔ 'tmʋ Kea 'a 'beɔdɛ 'ɛ ‑pɔia\" ‑tɩ ‑wɛe ɔɔ 'bɔɔ‑ 'wɛ‑ 'ɛ kpɛ ‑wee' \"klein. ");
INSERT INTO wob_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Ɔ 'jeea nyʋ ‑tuu\"‑tuu ‑nʋ \"jriɛ‑ 'sʋ ʋʋa' wɛe a nʋɔ', dɛ‑nʋɛ' ʋʋa sea, ʋʋa' dɩ a cɛn' ka 'blae ‑sea' 'dei ‑tei 'ble nɩa, 'kamɔ ʋʋpʋ nɩ‑. ");
INSERT INTO wob_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","'Sʋ ɔ wlu' 'de ɔɔ' klai\" nynuu o, ɔ 'na : Kea 'a dbo ‑kɔ' ko‑kle klaa\" ‑flu\" 'a ‑wɛe ‑ɛ sea cɛn nyʋ 'ble ɛ. ");
INSERT INTO wob_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Ao bae ‑kle' jei ‑wɛe ɔɔ' ‑cɛ\" 'je dbonʋʋn 'de ɔ o ‑kle' ja‑. ");
INSERT INTO wob_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Sesi 'da ɔɔ' klai\" nynuu ‑nɩa ‑puue 'jɔ 'sɔɔn 'mɛ, ‑wɛe ɔ \"nyɩ ʋʋpʋ \"ikmaa' 'de ʋʋ 'je ‑siisaɩn inʋ, ʋʋ 'je 'wɛ‑ 'ɛ kpɛ ‑wee' \"klein 'bɔɔ‑. ");
INSERT INTO wob_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Dboʋn ‑nɩa ‑puue 'jɔ 'sɔɔn ‑nʋ ʋʋa' 'nynɩ ka : \"i‑saa ‑nɔ ‑nɩ Simɔ ‑ɔɔ \"kpei ‑tenynɩ nɩa Piɛi ke ɔɔ' de'di Ancre ke, Sebede 'a \"nynuu‑ Sakɩ ke ɔɔ' de 'di San ke. ");
INSERT INTO wob_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Filipʋ ke Batelemi ke Toma ke Matie ‑ɔ ‑nɩa 'wɛi‑sai ke Alife 'a \"ju Sakɩ ke Tade ke. ");
INSERT INTO wob_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Simɔ ‑ɔɔ \"kpei ‑tenynɩ nɩa Selɔtɩ ke Suida Isikario ‑ɔ ‑toa 'e Sesi ‑wɛe ʋʋ 'dbɔ ɔ. ");
INSERT INTO wob_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Nyʋ 'a ‑puue 'jɔ 'sɔɔn Sesi dboa ʋʋ ‑nao. Ɔ ‑tuɛ\" ʋʋpʋ wlu ɔ 'na : Ao 'bo 'e nyʋ 'srʋ 'a 'blʋa‑ \"kpei muɛ, ao 'bo 'e Samadi muɛ. ");
INSERT INTO wob_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Nyʋ ‑ma\" 'de Israɛ‑nyʋ \"klu ka 'blae ‑sea' 'dei ‑tei 'ble nɩa, ʋʋpʋ ao 'je i ‑pɔn'. ");
INSERT INTO wob_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Ao mu, ao 'tmʋ Kea 'a ‑tɩ', ao 'na : Kea 'a nyʋ 'blesʋn ‑teɛ \"jri \"kpae' po‑tɩ. ");
INSERT INTO wob_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Ao 'bɔɔ‑ nyʋ 'a 'wɛ‑, ao ‑sa 'mɛʋn ‑klu', ao 'pʋʋ‑ 'jrʋwɛ‑jeʋn, ao nʋ ‑siisaɩn i. Dɛ ao 'jea foo\" 'ʋn ɛ, ao \"nyɩɛ nyʋ foo\" 'ʋn ‑ke. ");
INSERT INTO wob_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Ao 'bo 'sani o, 'wɛi o, 'wɛi 'dipowlʋ 'bleɛ. ");
INSERT INTO wob_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Ao 'bo 'dʋʋa' kpa ‑ke 'bleɛ, ao 'bo \"bai 'sɔɔn 'ʋn \"duɛ, ao 'bo \"kwlai‑ bʋ' ‑tu\" ɛ, ao 'bo itbatu 'bleɛ, dɛ‑nʋɛ' ‑kei\" ‑nɩa dbonʋi 'a 'je ka, mɛ ɔ 'je. ");
INSERT INTO wob_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","‑Kwlɔ \"o ‑kwlɔ aoa mua 'o 'di mua' a, ‑mɛ ao ‑pɔn nyɔ ‑ɔ ‑nɩa aoa' sɩn 'sɔɔn kpʋʋn ka i ‑wɛe ao 'je 'de ɔ o ‑gbu\" koo‑ mamaʋ dɛ ‑jɛɛa aoa' 'bo ɛɛ' ‑kwlɔ tu 'di 'wlʋa' a. ");
INSERT INTO wob_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","‑Bo aoa sea 'e ɛɛ' ‑gbu\" tu 'di pa, ‑mɛ ao po ʋʋpʋ 'jewlu o. Ao po ʋʋpʋ \"diwan. ");
INSERT INTO wob_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","‑Bo ʋʋ kpʋʋn ao sɩn 'sɔɔn, ‑mɛ aoa' \"diwan ‑te 'de ɛ 'di i. 'De ‑bo ʋʋ se aopʋ sɩn 'sɔɔn kpʋʋn ɛ, ‑mɛ aoa' \"diwan ji ao 'kwa de. ");
INSERT INTO wob_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","‑Bo nyɔ se aopʋ sɩn 'sɔɔn kpʋʋn, ‑bo nyɔ se aoa' wlu doin\" o po ɛ, ‑mɛ ao 'wlʋ 'o ɛɛ' ‑gbu\" tu ke‑ ɛɛ' ‑kwlɔ tu 'di ‑wɛe ao 'je ɛɛ' \"puue' bɩ i‑gbao'‑, ɛmɛ ‑nɩ ɛɛ' ‑kwlɔ tu 'a pin \"ipoa'. ");
INSERT INTO wob_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","'Ma 'tmʋʋɛ aopʋ tɔ' ‑tɩ, ‑sɔntɩ Kea a mua nyʋ 'a 'pee 'jea' a, ɛɛ' ‑kwlɔ tu 'a 'pee a muɛ \"ikmaa', ɛ 'je Sodɔm‑kwlɔ ke Gomɔɔ‑kwlɔ ‑sii. ");
INSERT INTO wob_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","Ao po doin\" i 'ma dbo aopʋ 'mɛ ka nyɔ ɔ dboa 'blae 'de ‑ci' \"klu ɛ. Ao 'ble 'srɛ ka sɛn nɩa, ao 'je kupeeɛ' nyʋ nɩ‑ ka ‑gbɛɛ' nɩa. ");
INSERT INTO wob_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Ao ‑tu\" aoa' ‑cɛ\" 'ɛ ‑tɩ', nyiɔpʋ a muɛ ao 'pee 'jeʋn \"juɔi kpaa' ‑wɛe ʋʋ 'je ao klae 'ʋn kpa 'de \"jrui 'kɩɩn‑gbi 'dii. ");
INSERT INTO wob_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Ʋʋa muɛ aopʋ 'blʋajeʋn ke 'beɔ‑wi\" \"juɔi kpaa' 'de 'ma ‑tɩ' 'ʋn, ‑wɛe ka ao 'jea 'ma ‑tɩ' tɔ' 'ʋn ao 'je ɛ to 'de 'blʋa 'dinyʋ \"juɔi. ");
INSERT INTO wob_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","'Kaa ‑bo nyʋ a sea aopʋ 'de 'pee 'jeʋn \"juɔi kpa a, ao 'bo ‑sɔɔn ‑tu\" ɛ 'de ka ao 'jea 'da o, dɛ ao 'jea 'tmʋ 'a ‑tɩ' 'ʋn. Wlu ao 'jea 'tmʋ ɛɛ muɛ 'bo ao ‑kwlɩ\" 'kpaa' 'de ɛɛ' nɔ\" tu 'di, ");
INSERT INTO wob_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","dɛ‑nʋɛ' ɛ se aopʋ 'a ‑cɛ\" 'kpa ‑je wlu nɩ‑, ao \"Bo 'a ‑Suu mɛ ‑je wlu 'de aopʋ 'ʋn. ");
INSERT INTO wob_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","De'di a muɛ ɔɔ' de 'di 'de toa' nyʋ 'jeɔ 'dba. \"Bo a muɛ ɔɔ' \"ju 'de toa' nyʋ 'jeɔ 'dba. \"Nynuu‑ a muɛ ʋʋ \"bo ‑wi\" wɔn o toa' ‑wɛe ʋʋ 'je ʋʋ 'dba. ");
INSERT INTO wob_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Nyʋ ‑wee' \"klein a muɛ ao ‑flɛɛan' 'de 'ma 'nynɩ 'a ‑tɩ' 'ʋn. 'Kaa nyɔ ‑ɔɔ mua 'ma ‑tɩ' 'a naɩ\" 'blea' mamaʋ 'sʋ ‑ɔ ‑jea nyni ɛ, ɔmɔ ‑ɔɔ mu 'pʋʋa'. ");
INSERT INTO wob_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","‑Bo ʋʋa sea ao 'kle ‑tu\" 'bo ‑kwlɔ due' 'di ɛ, ‑mɛ ao mu 'o jrɛ' 'di. 'Ma 'tmʋʋɛ aopʋ tɔ' ‑tɩ, ao se Israɛ 'a ‑kwlɛ ‑wee' \"i \"sii‑ i 'sʋ nyiɔ 'ɔ \"Ju 'e de ji. ");
INSERT INTO wob_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","Klai\" ju se dɛwɔn nɩ, ɔ se ɔɔ' dɛtɔɔi ‑sii. 'De nyʋ \"juɔinʋʋi se dɛwɔn nɩ, ɔ se ɔɔ' 'blei ‑sii. ");
INSERT INTO wob_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Ka nyʋ nʋa klai\" ju 'a dɛtɔɔi ‑bo nyʋ nʋ ɔmɔ kan' ‑ke ɛ, ‑mɛ ɛ ‑kwɛ‑ ja. 'De ka nyʋ nʋa nyʋ 'blei ‑bo nyʋ nʋ kan' ɔɔ' dbonʋi ‑ke ɛ, ‑mɛ ɛ ‑kwɛ‑ ja. ‑Bo ʋʋ 'daa‑ ‑gbu\" jei ‑siisaɩn 'a klaa\" Bɛsebuilɩ ɛ, ʋʋa mu ɔɔ' ‑gbu\" ‑sɔn nyʋ ‑wee' kan' 'daa' see. ");
INSERT INTO wob_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","Ao 'bo nyiɔpʋ pleeɛ. Dɩ \"klein ‑pa' 'kwla a, ɩa muɛ \"kpae' 'pɛɛan'. ‑Wɛe ‑jɩ ‑nɩa 'e \"sran nyʋ 'jɩ 'wɔn. ");
INSERT INTO wob_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Dɩ \"klein 'ɩn 'tmʋʋa aopʋ 'de kwie' ɛ, ao 'tmʋ ɩ 'de ‑sɔn' 'ʋn, dɩ \"klein 'ɩn paa aopʋ \"sɩan a, ao po ɩa' wee 'bo nyʋ ‑kwea. ");
INSERT INTO wob_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Ao 'bo nyʋ ‑ʋʋa ‑dba aoa' 'blʋku 'a 'sʋ 'de ‑ʋʋ seɛ 'bɛɛ‑ ‑ʋʋ ‑jea aoa' ‑suu 'dba pleeɛ. Kea ‑jɛ ‑bɛɛa' ‑ɛ ‑jea aoa' 'blʋku 'dba 'de ‑ɛ ‑jea aoa' ‑suu 'de nɛ 'ʋn po ɛ, ɛmɛ ao 'je plee ka‑. ");
INSERT INTO wob_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","\"Jaejɔ 'sɔɔn mɩ nyʋ a sea ‑suujɔ due' 'ʋn plee‑ ? ‑Aee' ɛ se kan' nɩ‑ ? 'De ‑mɛ 'kamɔ ɩa' due' koun ‑gbai' se ɛ 'bɛɛ‑ ɛ 'je i ‑ka ‑bo ɛ se ao 'Bo 'a ‑kwlʋtɩ nɩ ɛ. ");
INSERT INTO wob_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","'De aopʋ mɔ ɛ, aoa' \"mɩɩ‑ ‑nɩa 'bo aopʋ \"jru ɛ, ɩ ‑wee' ‑srooɛ'. ");
INSERT INTO wob_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Ɛmɛ ‑tɩ faʋn 'bo aopʋ nʋɛ, ao nɩɛ dɛwɔn ao je \"jae ‑tuu\"‑tuu ‑sii. ");
INSERT INTO wob_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","Ɛmɛ ‑tɩ nyɔ \"o nyɔ ‑ɔɔ mua 'ma 'nynɩ \"sia' 'bo nyʋ \"juɔi, 'ma muɛ ɔɔ' 'nynɩ \"sia' 'bo 'ɩn \"Bo ‑nɩa 'e jaʋn 'di \"juɔi ‑ke. ");
INSERT INTO wob_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","'Kaa nyɔ \"o nyɔ ‑ɔɔ mua nʋa' ‑ɔ se 'ʋn juo‑ 'bo nyʋ \"juɔi ɛ, 'ma muɛ nʋa' 'ɩn seɔ juo ‑ke 'bo 'ʋn \"Bo ‑nɩa 'e jaʋn 'di \"juɔi. ");
INSERT INTO wob_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","Ao 'bo tɔ' inaa ka, pɛe 'a blua' mɛ 'ɩn ja 'nɔ 'kmʋ \"kpei. 'Ɩn se pɛe 'a blua' ja‑, tʋ mɛ 'ɩn ja‑, ");
INSERT INTO wob_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","dɛ‑nʋɛ' 'ɩn ji' ‑wɛe \"ju ke \"bo 'je i ‑seea', 'nynɔkpao' ju ke ʋ de 'je i ‑seea', \"ju 'a 'nynɔ ke kʋande 'je i ‑seea', ");
INSERT INTO wob_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","‑wɛe nyiɔ 'ɔ ‑cɛ\" 'kpa 'a ‑gbu\" ‑sɔn nyʋ 'je ɔɔ' tʋnyʋ nɩ‑. ");
INSERT INTO wob_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Nyɔ ‑kma ɔ \"bo ke de 'a ‑tɩ' ɛ ‑sia 'ʋn ɛ, ‑mɛ ɔ ke 'ma se na ka nɩ‑, 'de nyɔ ‑kma ɔɔ' \"junynɔkpao' ke ɔɔ' \"junmɔu 'a ‑tɩ' ‑wɛe ɛ ‑sia 'mɔ ɛ, ‑mɛ ɔ ke 'ma‑ se na ka nɩ‑. ");
INSERT INTO wob_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","'De nyɔ ‑sea' 'kle 'je ‑tɩ ke 'mɛ ‑tɩ 'wɔɔn‑ ‑wɛe ‑ɔ ‑sea' 'bo 'ʋn 'de bla, ‑mɛ ɔ se 'ma klai\" ju nɩ ka nɩ‑. ");
INSERT INTO wob_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Nyɔ ‑ɔɔ mua ɔɔ' 'kmʋ \"kpei‑ 'tʋan' a, ɛɛ mu ɛ ɔ kwa \"maa'. 'Kaa nyɔ ‑ɔɔ mua ɔɔ' 'kmʋ 'de toa' 'de 'ma ‑tɩ' 'ʋn ɛ, ɔmɔ ‑ɔɔ mu ɛ 'jea' de 'bɔɔ‑ nɔ\". ");
INSERT INTO wob_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","Nyɔ ‑kpʋʋan ao sɩn 'sɔɔn ‑mɛ 'mɔ ɔ kpʋʋn sɩn 'sɔɔn. 'De nyɔ ‑kpʋʋan 'mɔ sɩn 'sɔɔn ‑mɛ \"ju ‑dboa' 'ʋn mɔ ɔ kpʋʋan 'o sɩn 'sɔɔn 'mʋa‑. ");
INSERT INTO wob_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Nyɔ ‑jea Kea 'a wlu 'kwajaai ‑wɛe ‑ɔ ‑kpʋʋn ɔ sɩn 'sɔɔn 'de ‑mɛ 'ɛ ‑tɩ' 'ʋn ɛ, ‑mɛ Kea 'a wlu 'kwajaaʋn 'a ‑kei\" mɛ nyʋ 'je ɔ ‑sa ‑ke. 'De nyɔ ‑kpʋʋan \"isrɛi sɩn 'sɔɔn 'de ɔɔ' \"isrɛa 'a ‑tɩ' 'ʋn ɛ, ‑mɛ \"isrɛʋn 'a ‑kei\" mɛ nyʋ 'je ɔ ‑sa ‑ke. ");
INSERT INTO wob_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","'Ma klai\" nynuu nyʋ sea dɛ 'ʋn 'je nyɔ \"o nyɔ ‑nyɩa\" ʋʋa' due' \"ni dee' ‑kaun\" 'a 'sʋ mɔ 'de ɛ, 'ma 'tmʋʋɛ aopʋ tɔ' ‑tɩ ɔɔ muɛ ɛɛ' ‑kei\" 'jea' see, ɛ se ɔ kwa \"maai. ");
INSERT INTO wob_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Sesi ‑kɔa ɔɔ' klai\" nynuu ‑nɩa ‑puue 'jɔ 'sɔɔn wlu ‑pee 'tmʋa' 'sʋ ɛ, ɔ muɛ ‑kwlɛ jrɩ' 'dii ‑wɛe ɔɔ tɔɔ nyʋ dɛ, 'de ɔɔ 'tmʋ Kea 'a ‑tɩ'. ");
INSERT INTO wob_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","‑Ta San Batisɩ nɩɩa 'e ‑kaso 'di 'sʋ ɛ, ɔɔ 'wɔn Sesi 'a nʋʋdɩ 'a 'nynɩ, 'sʋ ɔ dboɛ ɔɔ' ‑nɩ klai\" nynuu 'a jrʋ' Sesi i ‑teea'. ");
INSERT INTO wob_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","ʋʋ 'na : ‑Mɔ ‑nɩ \"ju ‑jea ji ɛ, ‑aee' ‑a ‑je jrɔ' fuo ‑oo ? ");
INSERT INTO wob_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Sesi 'na : Dɩ ao 'wɔan, dɩ ao 'jea, ao mu ao 'jɩ San 'tmʋʋ‑. ");
INSERT INTO wob_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","\"Jri 'a waʋn a 'jeɛ i, klɔɔʋn a na', 'jrʋwɛjeʋn a nɩɛ 'pepe, doin\" 'a waʋn a 'wɔn i, 'mɛʋn a jiɛ 'kmʋ de, ‑pɔia\" ‑tɩ a 'tmʋʋɛ' 'de nɩa\" nyʋ ‑pee. ");
INSERT INTO wob_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Nyɔ ‑ɔɔ \"maa 'mɔ sea nɩ ɛ, ‑mɛ ‑mɔ nʋ 'mʋa‑. ");
INSERT INTO wob_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","‑Ta San 'a klai\" nynuu mua de ɛ, 'bomɔ Sesi ‑tee San 'a ‑tɩ' 'tmʋa 'a ‑pʋn\" 'de nyʋ ‑gbae ɔ 'dei ‑pee, ɔ 'na : Dɛ ao mu i 'jea' 'de ‑pɩɩɔn\" blʋa \"kpei 'de ɛ‑ ? ‑Aee' ‑gblokpau poɔ' ɔ ‑suua' i ɛ ? ");
INSERT INTO wob_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","'De ‑mɛ dɛ ao mu i 'jea' 'ja a‑ ? ‑Aee' \"ju due' ‑ɔ ‑paa dɩ 'dɔe 'ʋn ɛɛ ? \"Ɩɩn‑, nyʋ ‑tua\" dɩ 'dɔe ‑pʋn\" ‑wi\" ‑mʋ nɩɛ 'e 'beɔ‑wi\" o ‑gbu\" 'di. ");
INSERT INTO wob_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Dɛ ao mu i 'jea' ‑gbo' ɛ‑ ? ‑Aee' Kea 'a wlu 'kwajaai ? Ɩɩn, 'ma 'tmʋʋ aopʋ 'mɛ, ɔ ‑sii Kea 'a wlu'kwajaai' ‑mɔ 'mɛ, ");
INSERT INTO wob_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","dɛ‑nʋɛ' ɔmɔ ‑ɔɔ ‑tɩ' 'ʋn dɛ ‑crɩɩa' 'na : 'Ma dboɛ nyɔ 'de ‑ʋn \"juɔi ‑wɛe ɔ 'je ‑ma ‑jeblʋ nmae‑. ");
INSERT INTO wob_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","'Ma 'tmʋʋ aopʋ tɔ' ‑tɩ 'de 'nynʋkpae' 'a \"nynuu‑ \"klu ɛ, nyɔ se dɛ wɔn nɩ ɔ se San Batisɩ ‑sii. 'Kaa nyɔ ‑piia' \"i 'de Kea 'a kɛɛma' ‑kwlɔ 'di ɛ, ɔ nɩɛ dɛwɔn ɔ je San ‑sii. ");
INSERT INTO wob_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Dɛ ‑wlʋa 'e San Batisɩ 'a nɔ\" 'di ‑wɛe ‑ɛ ‑jɛɛa ‑sɩanwɩ ɛ, nyiɔpʋ a ‑pɔn ʋʋ 'je 'e Kea 'a kɛɛma' ‑kwlɔ 'di pa 'de 'kwa i kua' 'ʋn. ");
INSERT INTO wob_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","'De ‑mɛ 'kamɔ Kea 'a wlu 'kwa jaaʋn ke ɛɛ' kɛ' 'tmʋ ɛɛ' dɛ tu 'a ‑tɩ' mamaʋ 'sʋ ɛ jɛɛ San 'a nɔ\". ");
INSERT INTO wob_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","'De ‑bo ao nɩɛ \"i ao 'je ɛ 'mii 'wɔn 'pepe ɛ, ‑mɛ ɔmɔ ‑nɩ Eli ‑ɔ ‑je ji 'de‑. ");
INSERT INTO wob_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Nyɔ doin\" nɩa 'o \"jru ɛ, ‑mɛ ɔ 'wɔn ‑tɩ' 'ɩn 'tmʋa 'mii. ");
INSERT INTO wob_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","'Sʋ Sesi 'na : Nyɔ 'ɩn 'je ‑sɩan nyʋ \"ipoo ɛ‑ ? Ʋʋ ‑kɔ' \"nynumɩɩ\" ‑tea i 'bo ‑kwlɔ ‑kwea ‑wɛe ‑ʋʋa wlua ba ‑pee ka : ");
INSERT INTO wob_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","‑A bla \"kwi‑kweɩn 'mɛ ‑bla ‑bla ao se dee‑, ‑a ble 'kwɛdʋ 'mɛ ‑ble ‑ble ao se kplee‑. ");
INSERT INTO wob_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","‑Ta San jia ‑wɛe ɔɔ' dia dɛ 'de ɔɔ' 'na nmɔ ɛ, ao 'na ‑suusaʋn ‑nɩ 'de ɔ 'ʋn. ");
INSERT INTO wob_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Nyiɔ 'ɔ \"Ju jia ɔɔ di', ɔɔ 'naa 'sʋ ʋʋ 'naa, ɔ ‑kau', ɔ kpa dɛ dia' ke nmɔ 'naa 'a 'sʋ, ɔ ke 'wɛi‑sanyʋ ke nyiɔpʋ‑ 'a \"kwli saɩn 'a 'sʋ ‑a na. 'Kaa Kea 'a ‑nɛ tɔ' 'dinɩa' poɛ \"jri \"kpae' 'de ɛɛ' nʋʋdɩ 'ʋn. ");
INSERT INTO wob_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","'Sʋ Sesi ‑teɛ ‑kwlɛ ‑ɩ 'dii ɔ nʋa' nyʋ 'pʋʋjrii' ‑tuu\"‑tuu 'a \"bli ‑cɛa' ‑pʋn\", dɛ‑nʋɛ' nyʋ ‑nɩa 'o ɩa' ‑kwlɛ ‑tu 'di se 'kmʋ fai\" poo‑tɩ 'wɔɔn‑. ");
INSERT INTO wob_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","Ɔ 'na : ɛ nɩɛ \"nmia‑tɩ ‑o 'de ‑ma ‑tɩ' 'ʋn Korasin‑kwlɔ, ɛ nɩɛ \"nmia‑tɩ ‑o 'de ‑ma ‑tɩ' 'ʋn Besaida‑kwlɔ, dɛ‑nʋɛ' nyʋ 'pʋʋjrii' ‑nʋʋa 'bo ɩ 'di ‑bo ɩ nʋʋɛ 'bo Tii ke Sidɔn‑kwlɛ 'di 'de ɛ, ‑mɛ nyʋ ‑nɩa 'o ɩa' ‑kwlɛ ‑tu 'di paa blɔ 'ʋn, ʋʋ 'wla biun' \"jru sese ʋʋ je ʋʋa' dɩsaɩn \"ijuo 'de‑. ");
INSERT INTO wob_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Ɛmɛ ‑tɩ 'ma 'tmʋʋ aopʋ, 'pee 'a 'wɩ o ɛ, Tii ke Sidɔn 'ɔ 'pee se \"ikmai, ɛ se aoa' ‑nɩ ‑sii i. ");
INSERT INTO wob_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","'De ɛmɛ Kapɛnaʋm‑kwlɔ, ɛ 'e mu ‑o mamaʋ 'sʋ ɛ je jaʋn tbaa ? \"Ɩɩn‑ ɛ se kan' nɩ‑, ɛɛ muɛ ‑sɔn jia' mamaʋ 'sʋ ɛ 'je \"ni ‑tun blu ɛ 'je 'e 'mɛʋn o ‑kwlɔ ‑taan', dɛ‑nʋɛ' nyʋ 'pʋʋjrii' ‑nʋʋa 'bo ɛɛ' ‑kwlɔ ‑tu 'di ‑bo ɩ nʋʋɛ 'bo Sodɔm‑kwlɔ 'di 'de ɛ, ‑mɛ ɛ se isɔin 'de‑. ");
INSERT INTO wob_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Ɛmɛ ‑tɩ 'ma 'tmʋʋ aopʋ, 'pee 'jewɩ o ɛ, ɛɛ' 'pee a muɛ \"ikmaa' ɛ 'je Sodɔm‑kwlɔ 'ɔ ‑nɛ ‑sii. ");
INSERT INTO wob_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","'De ɛɛ' nɔ\" tu 'di Sesi \"duɛ wlu 'ʋn ‑wɛe ɔ 'na : 'Ɩn \"Bo, ɛmɛ ‑nɩa 'blʋa‑ ke jaʋn 'a 'beɔ ɔ, 'ma poɛ ɛ 'sɛ‑, dɛ‑nʋɛ' ɛ ‑tuɛ\" dɩ ‑nɩ 'kwla 'de nyʋ ‑ʋʋa ‑daa' ʋʋa' ‑cɛ\" tɔ' 'dinɩʋn ke dɛ \"ijuoʋn ‑pee ‑wɛe ɛ ‑sɩ 'kwla 'de nyʋ ‑ʋʋa jaa ʋʋa' ‑cɛ\" ja ‑pee. ");
INSERT INTO wob_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Ɩɩn, 'ɩn \"Bo, ‑kai\" 'matɛ dɛ ɛɛ' ‑cɛ\" 'wɔɔan ɛɛ' dɛ tu ɛ. ");
INSERT INTO wob_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","‑Wɛe ɔ wlu ɔ 'na : 'Ɩn \"Bo \"nyɩ 'ʋn dɩ ‑wee' \"klein 'mɛ. Nyɔ jrɔ' se \"Ju juo ‑bo ɛ se \"Bo nɩ ɛ, nyɔ jrɔ' se \"Bo juo ‑bo ɛ se \"Ju nɩ ɛ. ɛ ke nyʋ \"Ju nɩa \"i ɔ 'jea ɔ \"Bo tɔɔ ‑ke ɛ. ");
INSERT INTO wob_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Aopʋ kwaku‑gbɛ ɛ pa 'de ‑ɔ sea, ao ji 'nɔ 'ʋn o ‑wɛe 'ɩn 'je ɛ aopʋ \"jru ‑sa 'de ao 'je fɔn‑. ");
INSERT INTO wob_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Ao \"duo 'ma ‑nɛ ‑gbɛ 'ʋn, ao ke 'ma ‑a ‑je na ‑wɛe ao 'je 'ma nʋʋkplɩn 'cɩan, 'ɩn nɩɛ kupeeɛ' nyɔ ‑wɛe 'ɩn nmɔ 'di wɔn. ‑Bo ao nʋ kan' a, ‑wɛe aoa' pɛe 'je blu, ");
INSERT INTO wob_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","dɛ‑nʋɛ' 'ma ‑nɛ kɛ' se 'kle nɩ‑, 'ma ‑nɛ ‑gbɛ \"feɛ kwa. ");
INSERT INTO wob_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Nɔ\" jrɛ' ‑sia 'o mu 'sʋ ɛ, Sesi a cɛn 'o ‑kle' due' 'di ‑tie\" 'bo Suifʋ‑wi\" 'a ‑kwlewɩ \"kpei. 'Mɩɩɛ‑ ɛ nʋa ɔɔ' klai\" nynuu 'sʋ ʋʋ ‑teɛ diidɛ cɛan' ‑pʋn\" ‑je woi 'de ʋʋa di. ");
INSERT INTO wob_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Fariseɛn‑wi\" 'jea ‑mɛ 'sʋ ʋʋ wluɛ Sesi ‑pee ʋʋ 'na : ‑Ɩn ‑gbʋn 'nɔ, dɛɛ‑tɩ ‑ma klai\" nynuu a nʋ dɩ ‑sea' nʋ ka nɩ 'bo ‑kwlewɩ \"kpei ɛ‑ ? ");
INSERT INTO wob_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Sesi wluɛ ʋʋ ‑pee ɔ 'na : ‑Ta 'mɩɩɛ‑ nʋa Dafidɩ ke ɔɔ' 'cɛ‑wi\" tɛin\" dɛ ʋʋ nʋa 'de 'wɩ jrɛ' 'di, ao se ɛ juoo‑ ? ");
INSERT INTO wob_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Ka ɔ pa 'e Kea ‑gbu klaa\" 'di ‑wɛe ɔ ke ɔɔ' 'cɛ ‑ke ɔ na dia ‑di'pɛn ‑nɩa 'o Kea \"juɔi ɛ ? 'De ‑mɛ 'kamɔ ‑aa kɛ' 'na : 'Sraa ‑saʋn 'a 'sʋ ‑je ɛɛ' ‑di'pɛn tu di, nyɔ jrɔ' se ɛ 'bɛɛ‑ ɔ 'je ɛ di. ");
INSERT INTO wob_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","'De ao se ɛ 'dii nʋ 'de Moisɩ 'a kɛ' 'di ka ‑bo ‑kwlewɩ \"kpei 'sraa ‑saʋn ‑ʋʋa nʋa dbo 'de Kea ‑gbu klaa\" 'di ʋʋa ‑saa Kea 'a kɛ', 'de 'pee a kpʋn ʋʋpʋ ɛɛ ? ");
INSERT INTO wob_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","'Ma 'tmʋʋ aopʋ 'mɛ nyɔ jrɔ' ‑nɩ ‑ta ‑ɔ ‑nɩ dɛwɔn ‑ɔ ‑sii Kea ‑gbu klaa\". ");
INSERT INTO wob_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Wlu ‑ɛ ‑crɩɩa' 'de Kea 'a 'sbɛ 'di ‑ɛ 'naa : 'Diwɔnmɔa' mɛ 'ma ‑pɔn, ɛ ‑sii nmi srae‑ ‑saa'. ‑Bo ao 'wɔn 'e ɛɛ' wlu tu 'dei 'de ɛ, ‑mɛ nyʋ ‑sea' ‑kɔ ‑pʋn\" nɩ ɛ ao se ɛ 'bɛɛ‑ ao 'je ʋʋpʋ 'pee kpʋʋn‑. ");
INSERT INTO wob_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","'Kaa 'mɔ nyiɔ 'ɔ \"Ju, 'ɩn nɩɛ ‑kwlewɩ 'a jei ‑o. ");
INSERT INTO wob_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Sesi 'wlʋa 'mʋa‑ a, ɔ muɛ 'e \"jrui 'kɩɩn‑gbi 'a due' 'di. ");
INSERT INTO wob_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","'Sʋ ɔ jɛɛ 'e \"ju due' ‑ɔɔ kwa jɛa 'sʋɛ. Nyʋ ‑nɩa 'o mu, ʋʋa ‑pɔn Sesi 'a ‑tɩ' \"kpei ‑tuua\" 'a ‑kɔ i, ɛmɛ ‑tɩ ʋʋ ‑tee' ɔ i ka ʋʋ 'na : ‑Aa kɛ' 'na nyʋ 'beeɛ' ɔ 'je 'wɛ‑ 'bɔɔ‑ 'bo ‑kwlewɩ \"kpeii ? ");
INSERT INTO wob_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","'De Sesi ‑tee' ʋʋpʋ i ka ɔ 'na : Nyɔ wɛ‑ ‑nɩ 'de ao \"klu ‑wɛe ‑ɔɔ 'blaa dɛ ɔ ‑tea' ‑kwlɩ\" 'kpa 'e \"ni bie 'di 'bo ‑kwlewɩ \"kpei ‑wɛe ‑ɔ seɛ 'e ‑sa i ɛ‑ ? ");
INSERT INTO wob_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Nyiɔ nɩɛ dɛwɔn kpɛ ‑puue, ɔ je 'blaa ‑sii. 'Mɔ 'na : Nyɔ 'beeɛ' ɔ 'je dɛ 'dɔe nʋ ‑kwlewɩ \"kpei. ");
INSERT INTO wob_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","‑Wɛe ɔ wlu 'e \"ju ‑ɔɔ kwa jɛa 'sʋɛ ‑pee ɔ 'na : ‑Ɩn sro sʋn ! Ɔ sroɛ' 'sʋ ɛ nɩɛ 'pepe ka jrɛ' ‑sia 'o nɩa. ");
INSERT INTO wob_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Fariseɛn‑wi\" \"sia \"kpae' 'sʋ ʋʋ pooɛ Sesi 'a 'kmʋ ‑satɩ. ");
INSERT INTO wob_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","'Kaa Sesi 'jea kan' 'sʋ ɛ, ɔ 'wlʋ 'o ɛɛ' ‑ta ‑tu 'mɛ. Nyʋ ‑tuu\"‑tuu bla 'bo ɔ 'de ‑wɛe ɔ 'pʋʋ‑ nyʋ \"klein 'wɛ‑ nɩa ‑pʋn\" ɛ. ");
INSERT INTO wob_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","'De ɔ ‑te' ʋʋpʋ kɛ' \"i ka ɔ 'na : Ao 'bo 'ma nynɩ \"siɛ‑ 'de nyɔ jrɔ' ‑pee. ");
INSERT INTO wob_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","‑Wɛe dɛ Kea 'a wlu 'kwajaai Esai 'tmʋa, 'de ɛ 'je 'o nyni. ");
INSERT INTO wob_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","Ɔ wlu' ka 'de‑ ɔ 'na : Kea 'naa : 'Ma dbonʋi 'ɩn ‑teea kpɔi\", ɔ ka. 'Ma ‑tɩ' kmai\" ‑ɔ 'ʋn 'ma 'mʋa‑tɩ ‑wee' nɩa, 'ma mu ɔ 'ma ‑Suu 'ʋn \"jia ‑wɛe ɔ 'je 'ma \"isrɛ‑tɩ 'tmʋ 'de nyʋ ‑pee. ");
INSERT INTO wob_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Ɔ ke nyɔ se wɔn ‑siie' i, ɔ se \"wɔi, nyɔ se ɔɔ' 'ʋn ‑sacruɛn\" 'wɔin ‑je woi. ");
INSERT INTO wob_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","‑Bo ɔ \"si ‑gblokpau ‑soɛ \"kpei ɛ, ɔ se ɛ ‑crai, ɔ se nɛbi 'a \"jriɛ dɛ ‑ɛɛ wan mɩ\"mɩ\" 'mʋʋi. 'Kamɔ ɔɔ mu nʋa' mamaʋ 'sʋ \"isrɛ‑tɩ 'a 'sʋ 'je tʋ 'a \"jru kpa 'de 'kmʋ \"kpei. ");
INSERT INTO wob_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","‑Wɛe 'blʋa‑ ‑wee' \"klein 'je ɔ ‑kwlɩ\" ‑te'. ");
INSERT INTO wob_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","'Sʋ ʋʋ jɔ \"jri wai\" due' ‑ɔ ‑nɩa \"muu‑ ‑wɛe ‑suusaʋn ‑nɩa 'de 'ʋn ɛ. Sesi 'pʋɔ' 'sʋ ɔɔ wlu', ɔɔ 'jeɛ i. ");
INSERT INTO wob_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Ɛ \"maa nyʋ ‑wee' \"klein tai', 'sʋ ʋʋ 'na : Dafidɩ 'a \"ju ‑nɔ ko ‑taa ? ");
INSERT INTO wob_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Fariseɛn‑wi\" 'wɔan wlu ‑nɛ 'sʋ ɛ, ʋʋ 'na : Dɛɛ‑tɩ \"ju ‑nɔ ɔ nʋa ‑siisaɩn i ɛ, ɛmɛ ‑nɩ Bɛsebuilɩ ‑nɩa ‑siisaɩn 'a klaa\" ‑nyiɔ\" \"ikmaa'. ");
INSERT INTO wob_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","'Kaa Sesi jua ʋʋa' tɔ' 'sʋ ɔ wlu' 'de ʋʋ ‑pee ɔ 'na : 'Blʋa‑ ‑ɛɛ nyʋ 'a 'sʋ ‑seea'ʋn ɛ, ɛɛ' 'wlʋ dɛ 'ʋn. ‑Kwlɔ \"o ‑kwlɔ ke ‑gbu\" \"o ‑gbu\" ‑ɩa 'bleenyʋ ‑seea'ʋn 'bo ʋʋa' 'sʋ 'nynɩ ɛ, ɩ se dɛ 'ʋn 'wlʋi. ");
INSERT INTO wob_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","‑Bo ‑siɔn' ɔ sea ‑siɔn' o ‑fɔn' 'ee, ‑mɛ ɔɔ sea ɔɔ' ‑cɛ\" 'kpa o ‑fɔn' 'mʋa‑ ? 'De ‑mɛ ka ɔɔ' tʋ\"bodɛ 'je dɛ 'ʋn 'wlʋsʋn nʋ 'ja a‑ ? ");
INSERT INTO wob_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","'De ‑bo 'ma sea ‑siisaɩn inʋ 'de Bɛsebuilɩ 'a 'nynɩ 'ʋn 'ee, aoa' \"nynuu‑ ‑mʋ 'ee, nyɔ ɔɔ 'nynɩ 'ʋn ʋʋa nʋ ‑siisaɩn i ɛ‑ ? Aoa 'jee, ɛ mɛɛ ‑tɩ, ʋʋa muɛ ao 'pee kpʋan'. ");
INSERT INTO wob_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","'Kaa ‑bo ɛ nɩ 'de Kea 'a ‑Suu 'ʋn mɔ 'ma nʋʋ ‑siisaɩn i 'ja a, ‑mɛ ao 'wɔɛn 'mii ka Kea 'a \"ikmaa' mɛ ji 'de aopʋ \"klu ɛ. ");
INSERT INTO wob_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Nyɔ \"o nyɔ se ɛ 'bɛɛ‑ ɔ 'je 'de \"ikmai o ‑gbu\" 'di pa ‑wɛe ɔ 'je ɔɔ' dɩ 'ʋn \"duo ‑bo ɔ se \"ju ‑kmai\" ‑nɔ san ke kpɩɩn‑ ɛ. 'Kaa ‑bo ɔ sɔn ɔ, ‑mɛ ɔ 'beeɛ' ɔ 'je dɩ \"klein ‑nɩa 'de ɔ o ‑gbu\" \"jri. ");
INSERT INTO wob_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Nyɔ ‑ke 'ma ‑a sea na ‑mɛ ɔ 'bleeɛ 'ʋn 'dii, 'de nyɔ ‑sea' nyʋ 'de 'ʋn o ja ‑mɛ ɔɔ ‑gba' dɩ ja. ");
INSERT INTO wob_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","'Ma 'tmʋʋɛ aopʋ tɔ' ‑tɩ, nyiɔpʋ 'a dɩsaɩn ke, ʋʋa' Kea wɔn o toa' 'beeɛ' ɩ 'je ‑kwɛ‑. 'Kaa nyɔ ‑ɔɔ mua Kea 'a ‑Suu wɔn o toa' a, ɔɔ' dɛsaʋn se ‑kwɛi. ");
INSERT INTO wob_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Nyɔ ‑tmʋa wlu saʋn 'de nyiɔ 'ɔ \"Ju ‑pee ɛ, ɔɔ' dɛsaʋn 'beeɛ' ɛ 'je ‑kwɛ‑, 'kaa nyɔ ‑ɔɔ mua Kea 'a ‑Suu wɔn o toa' a, ɔɔ' dɛsaʋn se ‑kwɛi 'de kaanwɩ ke nɔ\" ‑ɔɔ mua jia' 'de nya 'di. ");
INSERT INTO wob_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Ka nyɔ ɔ nʋa tu 'dɔe juosʋn 'ka ka : Ao 'bo dɩ \"jri ibeeɛ, ‑bo tu nɩ tu 'dɔe ɛ, ɛɛ poɛ \"bi 'dɔe, 'de ‑bo tu nɩ tu saʋn ɛ, ɛɛ poɛ \"bi saɩn. Nyʋ juo tu \"o tu 'mɛ 'de ɛɛ' 'jɔ 'ʋn. ");
INSERT INTO wob_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Ao sɛn 'ɛ \"nynuu‑, ao nynia 'di wɔn mɔ kan' a, ka ao 'je dɩ 'dɔe 'a 'tmʋsʋn nʋ mɔ 'de ɛ‑ ? Dɛ‑nʋɛ' dɩ ‑jia\" 'e nyiɔ pɛe o mɩ ‑ɩa jii 'de ɔ 'wɔn. ");
INSERT INTO wob_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Nyɔ 'dɔe a ‑sa' ‑tɩ' 'dɔe 'de ɔɔ' pɛe 'dɔe o ‑wɛe ɔɔ po ɩ ‑sɔn. 'De nyɔ saʋn a ‑sa' ‑tɩ' saɩn 'de ɔɔ' pɛe saʋn o ‑wɛe ɔɔ po ɩ ‑sɔn. ");
INSERT INTO wob_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","'Ma 'tmʋʋ aopʋ 'mɛ, 'peewɩ o ɛ, wlu \"klein ‑ɩ ‑sea' 'tmʋ ka nɩ ‑wɛe nyiɔ 'tmʋa, ɔɔ muɛ ɩa' \"kuan poa', ");
INSERT INTO wob_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","dɛ‑nʋɛ' 'bo ‑ma ‑cɛ\" 'ɛ wlu \"kpei 'bomɔ 'pee 'je ‑ʋn kpʋʋn‑ 'de 'bomɔ 'pee 'je ‑ʋn ‑seea. ");
INSERT INTO wob_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","'Sʋ kɛ' wɔ‑saʋn ke, Fariseɛn‑wi\" 'a jrʋ' wlu' 'de Sesi ‑pee ʋʋ 'na : Nyʋ dɛtɔɔi, ‑a ‑nɩɛi\" ‑ɩn ‑je jrii' nʋ, ‑a ‑je ‑ʋn ‑je. ");
INSERT INTO wob_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","‑Wɛe Sesi wlu ka 'de ʋʋ ‑pee ɔ 'na : 'Diwɔnyniʋn ke nyʋ 'srɛipooʋn ʋʋa ‑tee' 'ʋn jrii' i. 'Kaa jrii' jrɛ' se nʋʋɛi, ‑bo ɛ se ‑jɛ ‑nʋʋa 'de Kea 'a wlu 'kwa jaa i Sonasɩ 'a ‑tɩ' 'ʋn nɩ ɛ. ");
INSERT INTO wob_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Ka Sonasɩ nʋa 'jrʋ‑gbaowɩ taan ke \"maʋ'wɩ taan 'de ‑smiiɛ' klaa\" 'di ɛ, 'kamɔ nyiɔ 'ɔ \"Ju 'je 'jrʋ‑gbaowɩ taan ke \"maʋ'wɩ taan nʋ 'de ‑klu'. ");
INSERT INTO wob_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Nyʋ ‑wlʋa Ninifʋ a muɛ 'ʋnsɔan' 'pee 'wlʋwɩ o ‑wɛe ʋʋ 'je nyʋ ‑nɩa ‑sɩanwɩ 'di 'pee kpʋʋn‑, dɛ‑nʋɛ' ‑ta Sonasɩ 'tmʋʋa ʋʋpʋ Kea 'a ‑tɩ' ‑pee ɛ, ʋʋ pooɛ 'kmʋ fai\". 'De ao ‑gbʋn 'nɔ, ‑jɔ ‑nɩa ‑ta ‑mɔ 'bɛi\" ɔ je Sonasɩ ‑sii. ");
INSERT INTO wob_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Ke'wlɛ ɛ, tʋ\"bo nynɔkpao' ‑wlʋa 'e 'jrʋ' 'a ‑gbɩnfɔ o 'de Sebablʋa \"kpei a muɛ 'ʋnsɔan' 'pee 'wlʋwɩ o ‑wɛe ʋ 'je nyʋ ‑nɩa ‑sɩanwɩ 'di 'pee kpʋʋn‑, dɛ‑nʋɛ' ʋ 'wlʋɛ 'e 'blʋa‑ ‑tɔɔn' ‑tɔɔn \"kpei ‑wɛe ʋ ji 'beɔ Salomɔ 'ɔ tɔ' wlu doin\" o poa'. 'De ao ‑gbʋn 'nɔ, ‑jɔ ‑nɩa ‑ta, ‑mɔ 'bɛi\" ɔ je Salomɔ ‑sii. ");
INSERT INTO wob_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","‑Bo ‑suusaʋn 'wlʋ 'de nyɔ 'ʋn ɛ, ɛ muɛ ‑ta nyɔ jrɔ' sea nɩ 'de ɛɛ ‑pɔn ‑teɩn i. ");
INSERT INTO wob_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","'Kaa ‑bo ɛ se ‑teɩn 'je 'sʋ ɛ, ɛ 'na : 'Ma jiɛ 'de 'ma ‑gbu\" 'di 'ɩn 'wlʋa de mua'. Ɛɛ mua 'e de ɛ, ‑mɛ ‑gbu\" 'dii wuuɛ i 'pepe, dɩ ‑wee' \"klein ‑teeɛ kpɔi\", 'kaa nyɔ se 'de ɛ 'di nɩ‑. ");
INSERT INTO wob_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","'Sʋ ɛ muɛ de ‑wɛe ɛ \"duo ‑siisaɩn ‑mɛ\" 'sɔn ‑kmai\" ‑ɩ ‑sii ɛmɛ 'ʋn, ɩ ji ‑wɛe ɩ bee o ɩ kpʋn ‑teɩn 'de ɔ 'ʋn, ‑mɛ ɔɔ' \"ju tu 'a de 'bɔɔ‑ kplɩn a muɛ \"jrii nynia', ɩ 'je ɔɔ' tɛin\" kplɩn ‑sii. 'Kamɔ ɛɛ mu nɩa' 'de 'diwɔnyniʋn ‑nɩa ‑sɩanwɩ 'di 'a ‑tɩ' 'ʋn. ");
INSERT INTO wob_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Sesi siiɛ nyʋ ‑pee wlua' kan' 'sʋ ɔ de ke ɔɔ' \"dei‑wi\" je ji 'e \"kpae' ‑wɛe ʋʋa ‑pɔn ʋʋ ke ɔ 'je wlu‑. ");
INSERT INTO wob_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","'Sʋ \"ju due' ‑wlu 'e Sesi ‑pee, ɔ 'na : ‑Ɩn ‑gbʋn 'nɔ ke, ‑ɩn de ke ‑ma \"dei‑wi\" ji', ʋʋ nɩɛ 'e \"kpae', ʋʋa ‑pɔn ʋʋ 'je ‑ʋn 'tmʋʋ‑. ");
INSERT INTO wob_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","'Kaa \"ju 'tmʋa dɛ ‑nɛ, Sesi wlu' ɔ 'na : 'Ɩn de ke 'ma \"dei‑wi\" 'de ɛ‑ ? ");
INSERT INTO wob_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","'Bomɔ ɔ too ɔɔ' klai\" nynuu sʋn \"kpe i 'de ɔ 'na : 'Ɩn de ke 'ma \"dei‑wi\" ka. ");
INSERT INTO wob_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Dɛɛ‑tɩ 'ɩn 'da kan' a, ɛmɛ ‑nɩ nyɔ ‑ɔɔ nʋa 'ɩn \"Bo ‑nɩa 'e jaʋn 'di 'a ‑kwlʋtɩ ɛ, ɔmɔ ‑nɩ 'ma \"deinmɔu, ɔmɔ ‑nɩ 'ma \"deinynɔkpao', ɔmɔ ‑nɩ 'ɩn de. ");
INSERT INTO wob_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","'De 'wɩ due' ‑nɩa 'mʋa‑ 'di 'bomɔ Sesi 'wlʋʋ 'e ‑gbu\" 'di ‑wɛe ɔ mu 'o \"ni ‑kwlɩ\" 'de ɔ ‑te i. ");
INSERT INTO wob_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Nyʋ ‑tuu\"‑tuu ‑gbae' ɔ 'dei, 'sʋ ɔ 'ja 'e ‑kwɛɛ\" due' 'di ‑wɛe ɔ ‑te i 'de ʋʋ ‑wee' \"klein ‑gbae' \"ni wɔin. ");
INSERT INTO wob_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","‑Wɛe ɔ poo ‑tɩ' ‑tuu\"‑tuu \"i ɔ 'tmʋʋ ʋʋpʋ ɔ 'na : \"Ju due' mɔ ‑mu' ko ‑gbaa' 'de ‑kle. ");
INSERT INTO wob_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","‑Ta ɔɔ ‑gbaa' ko 'sʋ ɛ, ɩa' 'jɔ jrɩ' blu' 'bo ‑je kpae\", 'sʋ nʋʋɩ ji' ɩ di ‑mɩ 'mɛ. ");
INSERT INTO wob_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Ko 'a 'jɔ jrɩ' blu' 'bo \"soi 'ʋn, ‑ta 'blʋ ‑tuu\" sea nɩ ɛ. 'Blʋ ‑nɩa 'o se 'ʋn tɔ 'sʋ ɩ ‑too\" ɛ 'mɛa'. ");
INSERT INTO wob_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","'Jrʋ ‑tea faan' ‑pʋn\" 'sʋ ɩ ‑wee' \"joo' ‑wɛe ɩ jɛ, dɛ‑nʋɛ' ɩa' 'sɩn se ‑ta ‑tɔɔn nyni. ");
INSERT INTO wob_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Ko 'a 'jɔ jrɩ' blu' 'de \"wi 'ʋn, ɩ ke \"wi mɛ' ‑tadue ‑wɛe \"wi san ɩ i. ");
INSERT INTO wob_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","'Kaa ko 'a 'jɔ jrɩ' ‑kpa 'o 'blʋa 'dɔe 'ʋn ɛ, ‑mɩ 'wlʋɛ dɛ 'ʋn, ɩa' jrɩ' croɛ 'jɔ 'ɔ kmɛ' 'due, jrɩ' croɛ 'jɔ 'ɔ kwla ‑mɛɛo\"‑, ‑wɛe jrɩ' cro 'jɔ 'ɔ kwla taan. ");
INSERT INTO wob_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","'Sʋ Sesi 'na : Nyɔ doin\" nɩa 'o \"jru ‑mɛ ɔ 'wɔn ‑tɩ' 'ɩn 'tmʋa 'mii. ");
INSERT INTO wob_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Klai\" nynuu 'kpa Sesi ‑pʋn\" ‑wɛe ʋʋ ‑tee' ɔ i ʋʋ 'na : Dɛɛ‑tɩ ‑bo ‑ɩn ‑je ʋʋpʋ dɛ ‑pee 'tmʋʋ ‑wɛe ‑ma poo ‑tɩ' \"i ɛ‑ ? ");
INSERT INTO wob_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","'Sʋ ɔ 'na : Aomɔ 'jeɛ 'saaʋn ‑wɛe aoa 'wɔn 'e Kea 'a 'beɔdɛ 'ɛ ‑tɩ' ‑wee' 'dei. 'Kaa ʋʋpʋ mɔ se ɛ 'je. ");
INSERT INTO wob_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Dɛɛ‑tɩ 'ɩn 'da kan' a, ɛmɛ ‑nɩ nyɔ ‑ɔɔ poa Kea 'a wlu doin\" o jeejee ɛ, ɔ ‑kɔ' nyɔ ‑blea dɛ. ɔɔ muɛ dee jrɛ' 'jea' ke'wlɛ ‑wɛe ɩ 'je \"kpei 'kpa ɩ 'je ɔ isiie. 'Kaa nyɔ ‑sea' Kea 'a wlu doin\" o po‑tɩ 'wɔɔn ɛ, ɔ ‑kɔ' nyɔ ‑jɔ sea' dɛ 'ble ɛ. Dɛ‑saan\" ‑jɛ ɔ 'blea a, nyʋ a mu ɔ ‑mɛ 'kwa ‑saa'. ");
INSERT INTO wob_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Ɛmɛ ‑tɩ 'ma poo ‑tɩ' \"i 'de ʋʋ ‑pee, dɛ‑nʋɛ' ʋʋa ‑gbʋʋn' i 'mɛ, 'kaa ʋʋa' 'jei. Ʋʋa po dɛ doin\" o 'mɛ, 'kaa ʋʋa' 'wɔn 'e dɛ 'dei. ");
INSERT INTO wob_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","'Kamɔ ɛ nɩ ‑wɛe dɩ \"klein Kea 'a wlu 'kwajaai Esai 'tmʋa tɛin\" 'je 'o nyni. Ɔ wlu' ka 'de‑ ɔ 'na : Kea 'na : Aoa muɛ dɛ doin\" o poa' 'pepe, 'kaa ao se ɛ 'mii 'wɔin. Aoa muɛ dɛ ja ‑gbʋan' 'pepe, 'kaa ao se ɛ \"jriɛ‑ 'jeei. ");
INSERT INTO wob_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Dɛɛ‑tɩ 'ɩn 'da kan' a, ɛmɛ ‑nɩ nyʋ ‑nʋ ʋʋa' pɛe pa tu, ʋʋ \"sun doin\" 'mɛ ‑wɛe ʋʋ je i 'wɔn, ʋʋ \"mu \"jri 'mɛ ‑wɛe ʋʋ je i 'je ‑wɛe ʋʋa' ‑tɔ' je dɛ 'mii 'wɔn. 'Kamɔ ʋʋa nʋ 'de ʋʋ je 'nɔ 'ʋn o \"biie‑ ‑wɛe 'ɩn je ʋʋpʋ 'pʋʋ‑. ");
INSERT INTO wob_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","'Kaa 'mʋa‑ nʋ aopʋ mɔ, dɛ‑nʋɛ' aoa' \"jri a 'jeɛ i ‑wɛe aoa' doin\" a 'wɔn i. ");
INSERT INTO wob_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","'Ma 'tmʋʋɛ aopʋ tɔ' ‑tɩ : Kea 'a wlu 'kwajaaʋn ‑tuu\"‑tuu ke \"isrɛnyʋ ‑tuu\"‑tuu ‑nɩɛi\" dɩ aoa 'jea \"jriɛ‑ ‑ta ʋʋ 'jɩ 'je 'de‑, 'kaa ʋʋ sɩ 'je. Dɩ aoa 'wɔan ʋʋ 'je ɩ 'wɔn 'de‑, 'kaa ʋʋ sɩ 'wɔn. ");
INSERT INTO wob_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","Ao po doin\" i la, dɛ kodbonʋi 'a ‑tɩ' ‑sa wɔ, ɛ ka : ");
INSERT INTO wob_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","‑Bo nyɔ po Kea 'a tʋ\"bodɛ 'ɛ ‑tɩ' doin\" o ‑wɛe ɔɔ' 'wɔɛn 'mii ɛ, 'sʋ ‑siɔn' ji' ɔ ‑sa wlu ‑nɛ 'de ɔ pɛe o. ‑Mɛ ka kojɔ ‑blua' 'o ‑je kpae\" nɩa, 'kamɔ ‑mɔ 'ɔ jei tu nɩ‑. ");
INSERT INTO wob_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Kojɔ ‑blua' 'o \"soi \"klu ɛ, ɛ ‑kɔ' nyɔ ‑ta ɔ \"sria ‑wɛe ɔ ‑sa 'o Kea 'a wlu, 'bomɔ ɔ \"sri ɔ 'je ɛ tɔ' 'ʋn 'de 'mʋa‑ 'ʋn. ");
INSERT INTO wob_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","'Kaa ɛɛ' po 'sɩn 'de ɔ 'ʋn, ɔɔ nʋɛ ɛɛ' ‑jaja ɔɔ' 'kpa 'de nyna. ‑Bo 'kle ji ɔ \"kpei 'de wlu ɔ 'wɔan 'a ‑tɩ' 'ʋn, 'sʋ ɔ poɛ ɔɔ' Kea ‑kwlɩ\" ‑te' ‑tɩ tɔ' i. ");
INSERT INTO wob_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Kojɔ ‑blua' 'de \"wi 'ʋn ɛ, ‑mɛ ‑kɔ' nyɔ ‑ɔ ‑wɔan Kea 'a wlu kpɩɩn‑, ‑wɛe ‑ɔɔ' \"tai‑ ɛ \"i, ɛɛ' croa 'jɔ 'de ɔ 'ʋn ɛ, ka ɛ \"sia 'nynɩ ɔɔ' nʋ kan', dɛ‑nʋɛ' 'kmʋ 'a dɩ ke \"wliiɛ‑ 'blea' ‑ɩa pooa nyʋ 'srɛ i, ɩmɩ ‑ɩa feeɛ' ɔɔ 'wla i 'de 'wɩ ‑wee' 'di. ");
INSERT INTO wob_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Kojɔ ‑kpa 'o 'blʋa‑ 'dɔe 'ʋn, ‑mɛ ‑kɔ' nyɔ ‑ɔ ‑wɔan Kea 'a wlu ‑wɛe ‑ɔ ‑wɔɛn 'mii ɛ. Wlu ɔ 'wɔan, ɔ ‑teɛ i 'de ɔ 'ʋn ‑wɛe ka ɛ \"sia 'nynɩ ɔɔ nʋ kan', ɔ ‑kɔ' ko ‑ɛɛ 'jɔ jrɛ' ɛ croa 'jɔ 'ɔ kmɛ' 'due, jrɛ' croa kwla ‑mɛɛo\"‑ ‑wɛe jrɛ' croa kwla taan. ");
INSERT INTO wob_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Sesi pooɛ ‑tɩ' jrɩ' \"i ke'wlɛ 'de ʋʋpʋ ‑pee ɔ 'na : Dɛ ‑ɛ ‑ke 'beɔdɛ ‑nɩa 'e jaʋn 'di ‑kɔɔa' \"i ɛ, ɛ ka : \"Ju due' mɔ ‑ɔ po ko 'a \"kwli 'dɔe 'de ɔ o ‑kle. ");
INSERT INTO wob_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","‑Ta nyʋ ‑wee' \"klein a 'mʋʋa \"maʋ 'sʋ ɛ, ɔɔ' tʋnyɔ pa 'de ɔ o ‑kle, ɔ ‑gba' sii\" saɩn 'a 'jɔ 'demu 'sʋ ɔ mu'. ");
INSERT INTO wob_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","‑Ta ko a mɛa ‑wɛe ɩa waa 'sʋ sii\" saɩn ‑nɩ mɛ' ‑ke. ");
INSERT INTO wob_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","'Sʋ \"ju ‑nɔ 'ɔ dbonʋʋn ji' ʋʋ 'na : ‑Aa 'blei, ‑a se ko 'a 'sʋ po 'de ‑kle ‑sɔo 'de‑, ‑ta sii\" saɩn ‑mɩ 'a ‑tɩ' 'wlʋ ɛ‑ ? ");
INSERT INTO wob_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","'De ɔ 'na : 'Ma tʋnyʋ ‑nʋ' dɛ ‑nɛ. 'De ɔɔ' dbonʋʋn 'na : ‑Ɩn ‑nɩɛi\" ‑a ‑je sii\" saɩn ‑nɩ \"cnuan' mu 'jaa ? ");
INSERT INTO wob_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","ɔ 'na : \"Ɩɩn‑, ɩ sie kan', ‑bo aoa sea sii\" saɩn \"crun ao je 'ma ko \"crun ‑ke. ");
INSERT INTO wob_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Ao \"tai‑ ko ke sii\" \"i, ɩ 'je 'boa ‑tadue mamaʋ 'sʋ kocɛn nɔ\" 'je nyni. 'De ɛɛ' nɔ\" tu 'di, 'ma muɛ wlua' 'de kocɛnyʋ ‑pee ka : Ao cɛn sii\" saɩn ke tɛin\", ao sɩn i ‑wɛe ao 'jɩ 'o \"jri po. 'De ao 'je 'ma ko ‑cɛɛn' \"sro ‑tu\" 'bo \"jɛi. ");
INSERT INTO wob_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Sesi pooɛ ‑tɩ' \"i 'de ʋʋpʋ ‑pee ke'wlɛ ɔ 'na : Kea 'a 'beɔdɛ ‑nɩa 'e jaʋn 'di, ɛ ‑kɔ' sii\" jɔ \"ju due' ɔ \"dua 'ʋn ‑wɛe ɔ ‑tua\" 'de ɔ o ‑kle' ɛ. ");
INSERT INTO wob_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Ɛɛ' sii\" tu 'a 'jɔ 'piiɛ \"i 'de sii\" ‑wee' \"klu. 'Kaa ‑bo ɛ mɛ, ɛɛ 'boa ɛɛ 'kpa tu klaa\" 'de nʋʋɩ a ji ɩa' 'jro poa' 'de ɛ ja. ");
INSERT INTO wob_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Sesi wlu' ke'wlɛ ɔ 'na : Kea 'a 'beɔdɛ ‑nɩa 'e jaʋn 'di, ɛ ‑kɔ' ‑di'pɛn ‑puun\" dɛ 'nynɔkpao' due' \"dua 'ʋn ‑wɛe ʋ poa 'de fai' pʋ 'a 'kɛinkɛ taan o. Ɛ nʋɛ' mamaʋ 'sʋ fai' pʋ ‑nɛ 'ɛ 'pɔɔ je ‑pun\", ɛ je dɛ \"ji. ");
INSERT INTO wob_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Dɩ \"klein Sesi a 'tmʋa 'de nyʋ ‑pee ɛ, ɔɔ 'tmʋ ɩ 'de ‑tɩ' \"ipooa' 'ʋn. ");
INSERT INTO wob_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","‑Wɛe dɛ Kea 'a wlu 'kwajaai 'tmʋa sese ɛ, ɛ je 'o nyni. Ɛɛ' wlu tu 'naa : 'Ma muɛ nyʋ ‑pee wlua' 'de ‑tɩ' \"ipooa' 'ʋn. Dɩ ‑tba' 'e 'kmʋ 'a nʋʋa' o ‑wɛe ‑ɩ ‑pa' 'kwla sese 'ma mu ɩ ʋʋpʋ 'tmʋa'. ");
INSERT INTO wob_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","'Bo ‑mɛ 'de ɛ, Sesi \"tai nyʋ ‑gbae ɔ 'dei \"i ‑wɛe ɔ pa ‑gbu\". ɔɔ' klai\" nynuu 'kpɔ ‑pʋn\" 'sʋ ɛ, ʋʋ 'na : ‑Ɩn ‑sa sii\" saɩn ‑nɩa 'e ‑kle' 'a \"ipoo‑tɩ wɔ 'de ‑a ‑pee ke. ");
INSERT INTO wob_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","'Sʋ Sesi ‑sɛ \"kpei ɔ 'na : Nyɔ ‑ɔ poa ko \"kwli 'dɔe 'de ‑kle ɛ, ɔmɔ ‑nɩ nyiɔ 'ɔ \"Ju. ");
INSERT INTO wob_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","‑Kle' mɛ ‑nɩ 'kmʋ, ko \"kwli 'dɔe mɛ ‑nɩ nyʋ ‑ʋʋ ‑tea tʋ\"bodɛ 'ɛ ‑tea' a. 'De sii\" saɩn mɩ ‑nɩ nyʋ ‑ʋʋ ‑tea ‑siɔn' 'ɔ ‑tea' a. ");
INSERT INTO wob_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Tʋnyɔ ‑jɔ ‑doa sii\" saɩn ɛ, ɔmɔ ‑nɩ ‑siɔn'. 'De ko cɛan' mɛ ‑nɩ 'blʋa 'a ‑kwɛ‑ nɔ\". Kocɛʋn mʋ ‑nɩ Kea 'a dboʋn. ");
INSERT INTO wob_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Ka nyɔ ɔ ‑sa' sii\" saɩn 'de ko \"klu ‑wɛe ɔɔ po ɩ \"jri ɛ, 'kamɔ ɛɛ mu nɩa' 'blʋa 'a ‑kwɛ‑ nɔ\". ");
INSERT INTO wob_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Nyiɔ 'ɔ \"Ju a muɛ ɔɔ' \"soa‑wi\" dboa' ‑wɛe ʋʋ 'je nyʋ ‑bluua ʋʋa' ‑ponyiɔ 'de dɛsaʋn 'di ke nyʋ ‑ʋʋa nʋa dɛsaʋn 'tɛn, ");
INSERT INTO wob_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","‑wɛe ʋʋ 'je ʋʋpʋ 'de nɛ 'ʋn po, ‑ta ‑fɩn\" 'a ke 'nynɩ \"idiia' nɩa. ");
INSERT INTO wob_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","'Kaa nyʋ ‑ʋʋa ‑jea Kea wɔn ɛ, ʋʋa muɛ faan' 'de ʋʋ \"Bo 'a tʋ\"bo‑kwlɔ 'di ka 'jrʋ a fan. Nyɔ iwɔn doin\" nɩa 'o \"jru, ‑mɛ ɔ 'wɔn i. ");
INSERT INTO wob_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Dɛ ‑ke jaʋn 'di 'a 'beɔdɛ ‑kɔɔa' \"i ke'wlɛ, ɛ ka : ɛ ‑kɔ' 'sani kpo ‑pa' 'kwla 'de ‑kle' due' 'di. \"Ju due' 'jeɛ 'sʋ, ɔ ‑tuɛ\" 'kwla 'de nyʋ ‑pee. 'Mʋa nʋɔ' 'sʋ ɔ je ɔɔ' 'bleedɩ ‑wee' \"klein ple ‑wɛe ɔ ‑tɩn' ɛɛ' ‑kle' tu‑. ");
INSERT INTO wob_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","Dɛ ‑ke jaʋn 'di 'a 'beɔdɛ ‑kɔɔa' \"i ke'wlɛ ɛ, ɛ ka : ɛ ‑kɔ' 'dɔɔpoi due' ‑ɔɔ ‑pɔan' ‑srɔjɔ 'dɔe 'a ‑tɩan' i ɛ. ");
INSERT INTO wob_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Ɔ 'jea ɛɛ' ‑jɛ ‑ɛɛ sɔɔn' kma 'sʋ ɛ, ɔ muɛ de ‑wɛe ɔ ple ɔɔ' dɩ ‑wee' \"klein 'de ɔ ‑tɩɛn'. ");
INSERT INTO wob_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","Jaʋn 'di 'a 'beɔdɛ ‑kɔ' 'sai nyʋ poa 'de 'tɔniɛ wɔn ‑wɛe ‑ɛ ‑sa ‑smii'a \"kwli ‑wee' ɛ, ");
INSERT INTO wob_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","ɛ \"jia 'sʋ \"nibliʋn ‑criɛ', ‑wɛe ʋʋ jɛ 'o 'kpʋʋ' \"kpei. 'De ʋʋ ‑te i ‑wɛe ʋʋa 'cra ‑smii'‑ 'mii. Ʋʋa po ɩa' ‑jɩ ‑nmɔa \"jrii toe\" 'dii, ‑wɛe ʋʋa po ɩa' ‑jɩ ‑nyniia \"jrii 'kwla. ");
INSERT INTO wob_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","'Kamɔ ɛɛ mu nɩa' 'blʋa 'a ‑kwɛ‑ nɔ\". Kea 'a \"soa‑wi\" a muɛ jia', ʋʋ 'je nyʋ saɩn ke nyʋ 'dɔe i ‑seea'‑. ");
INSERT INTO wob_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","‑Wɛe ʋʋ 'je nyʋ saɩn 'de nɛ 'ʋn po, 'bomɔ ‑fɩan\" ke 'nynɩ \"idiia' nɩ‑. ");
INSERT INTO wob_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","‑Wɛe Sesi ‑tee' ʋʋpʋ i, ɔ 'na : Dɩ \"klein 'ɩn 'tmʋa ‑nɩ ao 'wɔn ɩ 'mii 'mɛɛ ? Ʋʋ 'na : Kɩɩn. ");
INSERT INTO wob_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","'De ɔ 'na : ‑Bo ɛ nɩ kan' a, ‑mɛ ɛ ‑kɔ' ‑na nyɔ ‑nɩa kɛ' wɔ‑sai ‑cɔɔn'‑ ‑wɛe ‑ɔ ‑wɔan dɛ 'mii 'de ‑ɔ ‑kpa tʋ\"bodɛ ‑nɩa 'e jaʋn 'di 'a klai\" ju ɛ, ɔ ‑kɔ' ‑gbu\" jei ‑ɔɔ ‑sa 'e ɔɔ' ‑gbu\" 'di \"wliiɛ‑ dee ke \"wliiɛ‑ soa ke ɛ. ");
INSERT INTO wob_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Sesi ‑kɔa' ‑tɩ' \"ipooa' kan' 'sʋ ɛ, ɔ 'wlʋ 'mʋa‑ 'mɛ ");
INSERT INTO wob_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","‑wɛe ɔ mu 'e ‑kwlɔ ‑ɛ 'di ɔ 'bɛɛa \"i ɛ. Ɔ pa 'e \"jrui 'kɩɩn‑gbu 'di, 'sʋ ɔ ‑teɛ nyʋ dɛ tɔɔa' ‑pʋn\". Nyʋ \"klein ‑jea ɔɔ' nyʋ dɛtɔɔ‑ta a, tai' \"maa ʋʋpʋ 'mɛ, ʋʋ 'na : ‑Taka ɔ ‑sa tɔ' ‑jɛ ‑mɛ 'de ɔɔ nʋ jrii' ɛ‑ ? ");
INSERT INTO wob_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","‑Ɔ ‑nɔ se ‑gbu\" kɔi 'a \"ju nɩ ‑taa ? Madi se ɔ de nɩɩ‑ ? Sakɩ o, Sosɛʋ o, Simɔ ke Suidɩ se ɔɔ' \"dei‑wi\" nɩɩ‑ ? ");
INSERT INTO wob_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","'De ɔɔ' \"deinynʋkpae' se 'de ‑a \"klu nɩ ‑taa ? 'De ‑mɛ ‑ta wɛ‑ ‑ɔ ‑sa \"ikmaa' ‑jɛ ‑mɛ 'ja a‑ ? ");
INSERT INTO wob_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Tɔ' ʋʋa naa i 'sʋ ɛɛ' 'wɔn ʋʋa' 'je ɔɔ' ‑tɩ' tɔ' 'ʋn. 'Bomɔ Sesi wluu ka ɔ 'na : Nyʋ a 'jeɛ Kea 'a wlu 'kwajaai dɛ 'ʋn ‑ta \"o ‑ta, 'kaa ɔɔ' 'blʋa 'dinyʋ ke, ɔɔ' ‑gbu\" ‑sɔn nyʋ 'a 'jeɔ dɛʋn'. ");
INSERT INTO wob_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","'De ɛɛ' ‑tɩ' 'ʋn ʋʋa' \"jrukua' a nʋɛ' 'sʋ ɔ se \"ikmadɩ ‑tuu\"‑tuu nʋ 'bo 'a ‑ta ‑tu. ");
INSERT INTO wob_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","'De ɛɛ' nɔ\" tu 'di ɛ, Erodɩ ‑nɩa Galile 'a 'beɔ 'wɔan Sesi 'a 'nynɩ. ");
INSERT INTO wob_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","'Sʋ ɔ 'tmʋɛ ɔɔ' dboʋn, ɔ 'na : San Batisɩ ‑o. Ɔ jiɛ 'kmʋ de, ɛmɛ ‑tɩ ɔɔ nʋ jrii' ‑nɩ. ");
INSERT INTO wob_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","4","'De ka San Batisɩ ‑mɔ nʋa 'mɛsʋn 'ka ka : Erodɩ ‑sa ɔɔ' \"dei Filipʋ 'nynɔ 'kwa. Ʋa' 'nynɩ ‑nɩ Erodiadɩ. 'Wɩ jrɛ' o San wlu' ɔ ‑pee, ɔ 'na : Ɛ se \"jrii nmɔ ‑wɛe ‑ɩn ‑je ‑ma \"dei 'nynɔ 'kwa ‑sa 'de ʋ 'je ‑ʋn \"bli \"ti. Ɛmɛ ‑tɩ Erodɩ kpʋn San, ɔ sɔn ‑wɛe ɔ po ɔ ‑kaso 'di 'de Erodiadɩ 'a ‑tɩ' 'ʋn. ");
INSERT INTO wob_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Ɔɔ ‑pɔn ɔ 'je San 'dba, 'kaa ɔɔ plee nyʋ 'mɛ, dɛ‑nʋɛ' nyʋ ‑wee' a 'daa San Kea 'a wlu 'kwajaai. ");
INSERT INTO wob_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","'Sʋ nɔ\" ‑ɛ 'di Erodɩ ‑tuu\" a ɔɔ' 'wlʋ‑kɔ ɛ, 'bomɔ Erodiadɩ 'a \"junynɔkpao' dee 'bo nyʋ ɔ 'da ‑kɔ' ‑sɔn \"juɔi. ");
INSERT INTO wob_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Ʋa' deebʋ ‑sɔ pɛe 'di 'sʋ ɔ cɛn wlu ‑tie\" ɔ 'na : Dɛ \"o dɛ a ‑teea' 'mii ɛ, 'ma muɛ aʋn \"nyɩa'. ");
INSERT INTO wob_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","'Sʋ ʋ tʋ de \"jrui 'de ʋ de ‑tuu\" wlu wɔn, ‑wɛe ʋ mu 'de Erodɩ o de 'sʋ ʋ 'na : ‑Ɩn ‑te' San Batisɩ 'a \"jru 'de 'kwlan 'di kaan ‑ta, ‑ɩn ‑je ɛ 'ʋn \"nyɩ. ");
INSERT INTO wob_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","'Sʋ 'beɔ Erodɩ \"kaeɛ \"jrii. 'Kaa dɛ ɔ cɛan wlu ‑tie\" 'bo nyʋ ɔ 'da ‑kɔ' ‑sɔn \"juɔi ɛ, ɛ kpʋn 'ɔ, 'sʋ ɔ cɛn 'o wlu ɔ 'na : Ao \"nyɩʋ dɛ ʋ ‑teea' i ɛ. ");
INSERT INTO wob_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","‑Wɛe ɔ dbo nyʋ 'e ‑kaso 'di ʋʋ ‑sa San Batisɩ \"jru \"i. ");
INSERT INTO wob_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Ʋʋ ‑teɛ' 'e 'kwlan 'di 'de ʋʋ \"nyɩ ɛ \"junynɔkpao' ‑wɛe ‑mʋ kpɛ ʋ de. ");
INSERT INTO wob_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","San 'a klai\" nynuu jia, ʋʋ \"duo ɔɔ' \"ku 'ʋn ‑wɛe ʋʋ ‑te' ɔ i. ‑Wɛe ʋʋ mu ʋʋ po Sesi dɩ ‑nʋʋa 'a \"kuan. ");
INSERT INTO wob_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Sesi 'wɔan ‑tɩ' ‑nɩ 'sʋ, ɔ 'kpa 'e ‑kwɛɛ\" 'di ‑wɛe ɔ mu ‑ta nyɔ jrɔ' sea nɩ ɛ. 'Kaa nyiɔpʋ 'je kan' 'mɛ 'sʋ ʋʋ 'wlʋɛ ‑kwlɛ 'dii ‑wɛe ʋʋ naa 'blʋɔi 'de ʋʋ mu Sesi kɩn. ");
INSERT INTO wob_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","‑Ta Sesi a 'wlʋa 'e ‑kwɛɛ\" 'di ‑wɛe ɔɔ \"sia i, ‑mɛ nyiɔpʋ ‑kooa' i ‑ta ‑wee'. Ɔ 'jea ʋʋpʋ 'sʋ ʋʋa' wɛe a nʋɔ', 'sʋ ɔ ‑teɛ nyʋ 'a 'wɛ‑ 'bɔɔa' ‑pʋn\". ");
INSERT INTO wob_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","‑Ta kwie a kpʋʋan 'sʋ ɛ, ɔɔ' klai\" nynuu 'kpɔ ‑pʋn\" ‑wɛe ʋʋ 'na : Nɔ\" ‑si' ‑wɛ‑, dɛ jrɛ' se ‑ta nɩ‑, ‑ɩn po nyʋ ‑nʋ ‑jei\" ʋʋ 'je ‑kwlɛ 'dii mu ‑wɛe ʋʋ 'je ʋʋa' diidɛ i ‑pɔn. ");
INSERT INTO wob_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","'Sʋ Sesi 'tmʋʋ ʋʋpʋ 'mɛ ɔ 'na : ʋʋ se mui kan'. Aoa' ‑cɛ\" 'kpa \"nyɩ ʋʋpʋ diidɛ. ");
INSERT INTO wob_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","'Kaa ʋʋ 'na : ‑Di'pɛn kplɩ ‑mm\" ke ‑smii' jɔ 'sɔɔn ‑gbai' mɩ ‑a ‑ble ‑ta. ");
INSERT INTO wob_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","'De Sesi 'na : Ao jɩ 'ʋn 'nɔ. ");
INSERT INTO wob_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","‑Wɛe ɔ wlu nyʋ ‑gbaea' ɔ 'de woi ‑pee ɔ 'na : Ao ‑te i 'bo sii\" \"kpei. ‑Wɛe ɔ \"duo ‑di'pɛn kplɩ ‑mm\" ke ‑smii' 'jɔ 'sɔɔn ‑nɩ 'ʋn, 'de ɔ kpa \"jri \"jɛi, ɔ po ɩa' Kea 'sɛ‑ 'de ɔ cɩn tii‑ ‑wɛe ɔ \"nyɩ ɔɔ' klai\" nynuu 'de ʋʋ 'jɩ nyʋ \"jrii ‑gble'. ");
INSERT INTO wob_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Ʋʋ ‑wee' \"klein di' ʋʋ je dbo. Ɩa' tɔo ‑sia 'o mu \"jiɛ toe\" 'a ‑puue 'jɔ 'sɔɔn. ");
INSERT INTO wob_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Nyʋ ‑dia' diiɛ 'mʋa‑ 'bɛɛ‑ \"nynunmai 'a \"wlu ‑mm\" 'mɛ, nyʋ se 'nynʋkpae' ke \"nynumɩɩ\" ‑sro'. ");
INSERT INTO wob_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Ʋʋ ‑kɔai\" 'sʋ ɛ, 'bomɔ Sesi \"sri ɔ je ɔɔ' klai\" nynuu ‑kwɛɛ\" 'di po ‑wɛe ɔ 'na : Ao mu nya 'de \"ni 'de 'ma ji'. ‑Mɛ ɔmɔ ke nyiɔpʋ a pooɛ wlu. ");
INSERT INTO wob_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Ɔ ‑kɔa' nyʋ 'a ‑jei\" pooa' 'sʋ, ɔ muɛ 'e crʋ \"kpei ‑ta nyɔ jrɔ' sea nɩɛ, ‑wɛe ɔ 'je Kea bae‑. 'De ‑ta kwie a kpʋan 'sʋ ɛ, ɔɔ' 'sʋ ‑nɩ 'o mu. ");
INSERT INTO wob_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","‑Mɛ ɔɔ' klai\" nynuu 'a ‑kwɛɛ\" nɩɛ 'e \"ni ‑kwea la 'bode, ‑mɛ poɔ' ɔ ji, ɛɛ bla ʋʋa' ‑kwɛɛ\" \"ni 'a 'plɩ \"jri, dɛ‑nʋɛ' 'nɔ ʋʋa muua 'demɔ poɔ' ɔ 'wlʋʋ. ");
INSERT INTO wob_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","\"I‑saa sʋn\" 'a ‑sro' nɔ\" 'sʋ Sesi ‑teɛ naa' ‑pʋn\" 'bo \"ni \"kpei ‑wɛe ɔɔ mu 'e ɔɔ' klai\" nynuu o fɔ o. ");
INSERT INTO wob_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","‑Ta ʋʋ 'jee ɔ ‑wɛe ɔɔ na 'bo \"ni \"kpei 'sʋ dɛ waa ʋʋpʋ 'dii, ʋʋmʋ 'na \"kwle‑sri\" ‑o 'de‑. 'Sʋ ʋʋa \"wɔɔ'. ");
INSERT INTO wob_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","'Bo ɛ \"sri Sesi wlu ʋʋpʋ ‑pee, ɔ 'na : Ao ‑te ‑tadue i, 'mɔ ‑o, faʋn 'bo ao nʋɛ ! ");
INSERT INTO wob_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","'Sʋ Piɛi \"duɛ wlu 'ʋn, ɔ 'na : Tʋ\"bo, ‑bo ɛ nɩ ‑mɔ ɛ, ‑mɛ ‑ɩn cɛn 'o wlu ‑wɛe 'ɩn 'je 'de ‑ʋn o ji 'bo \"ni \"kpei. ");
INSERT INTO wob_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Sesi 'na : ‑Ɩn ji ! Piɛi 'wlʋa 'e ‑kwɛɛ\" 'di 'sʋ ɔɔ na' 'o \"ni \"kpei ‑wɛe ɔɔ mu 'e Sesi o. ");
INSERT INTO wob_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","'Kaa ɔ kpa poɔɔ' jisʋn \"jriɛ‑ i, ɛ kmai\", 'sʋ faʋn a nʋɔ'. ɔɔ pa \"ni ‑sɔn 'sʋ ɔ \"wɔɔ' ɔ 'na : Tʋ\"bo, ‑ɩn ‑pʋʋ' 'ʋn 'de ! ");
INSERT INTO wob_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","'Bo ɛ \"sri Sesi je sʋn sro. ɔ kpʋn ɔ 'sasa ‑wɛe ɔ wlu ɔ ‑pee ɔ 'na : Ka ‑ma 'ma ‑kwlɩ\" ‑tea' 'piiɛ\"i kan' a‑ ! Dɛɛ‑tɩ ‑ɩn ‑plee tɔ' i ɛ‑ ? ");
INSERT INTO wob_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Ʋʋ 'ja 'e ‑kwɛɛ\" 'di 'sʋ poɔ' 'bɔ ji ‑tɩ 'mɛ. ");
INSERT INTO wob_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","'Sʋ klai\" nynuu ‑nɩa 'e ‑kwɛɛ\" 'di \"siiɛ 'kɔi‑ i 'bo Sesi \"juɔi ‑wɛe ʋʋ 'na : ‑Ɩn ‑nɩɛ Kea 'a \"Ju ‑o ‑cɛɛn'‑. ");
INSERT INTO wob_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Ʋʋ cɛan \"ni 'sʋ ɛ, ʋʋ nyniɛ 'e Senesarɛblʋa 'di. ");
INSERT INTO wob_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Nyʋ ‑nɩa 'e ɛɛ' 'blʋa‑ tu 'di juuɛ Sesi \"i, 'sʋ ʋʋ ‑kɔɔɛ ɔɔ' jinynɩ ‑ta ‑wee' ja, 'sʋ ʋʋ jɔ nyʋ \"klein 'wɛ‑ ɛ nʋa. ");
INSERT INTO wob_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","‑Wɛe ʋʋa bae ɔ i 'de ʋʋ 'je ɔɔ' \"bai 'a wɔn 'ɔ 'sʋ \"ibla. Nyʋ \"klein ‑ʋʋa blɔ \"i ɛ, ʋʋa' 'wɛ‑ ɛ 'bɔɔ. ");
INSERT INTO wob_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","'Sʋ Fariseɛn ke kɛ' wɔ‑saʋn ‑wlʋa Selisalɛm 'kpa Sesi ‑pʋn\" ‑wɛe ʋ ‑tee' ɔ i ka, ");
INSERT INTO wob_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","ʋʋ 'na : Dɛɛ‑tɩ ‑ma klai\" nynuu a ‑saa' tɛin\"nyʋ 'a kɛ' ɛ‑ ? ‑Bo ʋʋ 'je dɛ di ɛ, ʋʋa' jre kwa, ka ‑aa nʋa 'nɔ ‑a \"blikplɩn 'ʋn see ɛ, ʋʋa' nʋ kan'. ");
INSERT INTO wob_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Sesi wlu ʋʋpʋ ‑pee ɔ 'na : 'De aopʋ mɔ 'ee, dɛɛ‑tɩ aoa ‑saa' Kea 'a kɛ' 'de aoa' ‑cɛ\" 'ɛ nyiɔtɔ' 'ʋn ɛ‑ ? ");
INSERT INTO wob_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Kea 'naa : ‑Ɩn ‑je ‑ʋn \"bo ke ‑ɩn de wɔn, 'de nyɔ ‑ɔɔ mua ɔ \"bo ke de ‑soo' o poa' a, ɔɔ muɛ 'mɛa'. ");
INSERT INTO wob_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","'Kaa aopʋ mɔ 'na : Nyɔ ‑ɔɔ mua wlua' 'de ɔ \"bo ke de ‑pee ‑wɛe ‑ɔ ‑na : Dɛ 'ɩn 'blea 'de 'ɩn 'jea ao kwa wɔi ‑te ɛ, ɛ ‑te ɛ kpɔi\", 'ɩn 'je ɛ Kea \"nyɩ. ‑Mɛ ‑mɔ 'ɔ \"ju tu se ɔ \"bo ke de wɔn 'je la 'bode. ");
INSERT INTO wob_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","'Kamɔ aopʋ a nʋ ‑wɛe aoa ‑sa' Kea 'a wlu i 'de aoa' nyʋ dɛtɔɔsʋn 'ʋn. ");
INSERT INTO wob_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Ao \"jridepooʋn, dɛ Kea 'a wlu 'kwajaai Esai 'tmʋa 'de aoa' ‑tɩ' 'ʋn 'de ɛ, ɔ 'bleɛ ‑kɩn. Dɛ ɔ 'crɩa, ɛ ka : ");
INSERT INTO wob_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","Kea 'naa : Nyʋ ‑nʋ 'ma ni ‑tea' nɩɛ 'de ʋʋ 'wɔn foo\" 'ʋn 'kaa ʋʋa' pɛe tɛɛn 'ʋn o fiin. ");
INSERT INTO wob_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Nyʋ ‑nʋ a ‑gbɛɛ' 'ʋn \"juɔi foo\" 'ʋn, dɛ‑nʋɛ' nyiɔ 'ɔ kɛ' mɛ ʋʋa tɔɔ nyʋ ‑wɛe ʋʋa 'daa‑ Kea 'a wlu. ");
INSERT INTO wob_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","'Bomɔ Sesi 'da nyʋ ‑wee' ‑wɛe ɔ wlu 'de ʋʋ ‑pee ɔ 'na : Ao ‑wee' \"klein ‑te doin\" 'de ao 'je dɛ ‑nɛ 'mii 'wɔn. ");
INSERT INTO wob_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Dɛ ‑ɛɛ paa 'e nyiɔ wɔn 'di ɛ, ɛɛ' kpʋʋn nyiɔ ‑flɛn\", 'kaa dɩ ‑a ‑wlʋa 'de ɔ 'wɔn ‑ɩa ‑sia\" \"kpae' ɩmɩ ‑ɩa kpʋʋn nyiɔ ‑flɛn\". ");
INSERT INTO wob_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","'Sʋ Sesi 'a klai\" nynuu 'kpɔ ‑pʋn\", ʋʋ 'na : Ka wlu ‑ɩn ‑tmʋa ‑ta ɛ kpʋan Fariseɛn‑wi\" ‑kwlʋ, ‑ɩn ‑je kan' 'mɛɛ ? ");
INSERT INTO wob_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Sesi 'na : Tu \"o tu 'ɩn \"Bo ‑nɩa 'e jaʋn 'di sea do ɛ, ‑mɛ ɛ muɛ cnun\" 'a. ");
INSERT INTO wob_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Ao \"tai‑ ʋʋpʋ \"i. \"Jri 'a waʋn 'a 'sʋ ‑a po ba ‑je o. 'De ‑bo \"jri 'a wai po \"jri 'a wai ‑je o ɛ, ʋʋ ‑wee' a muɛ i ‑kaa' 'de \"bie 'di see. ");
INSERT INTO wob_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Piɛi \"dua wlu 'ʋn ɔ 'na : ‑Ɩn ‑sa \"ipoo ‑tɩ ‑nɩ wɔ ‑ɩn ‑nyɩ\" ‑aʋn. ");
INSERT INTO wob_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","'De Sesi 'na : Aomɔ ke'wlɛɛ, ao se tɔ'di 'kpa kee ? ");
INSERT INTO wob_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Ka dɛ \"o dɛ ‑ɛɛ pa 'e nyʋ 'wɔn ‑mɛ ɛɛ mua 'e \"kwli 'di ‑wɛe ɛɛ \"sia ‑sɔn 'de nyʋ a poɛ 'kwla, ao se ɛ juoo‑ ? ");
INSERT INTO wob_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","'Kaa dɛ ‑jia' 'e nyʋ 'wɔn ‑mɛ ɛ 'wlʋɛ 'de ɔ pɛe o, ɛmɛ ‑ɛɛ kpʋʋn nyʋ ‑flɛn\", ");
INSERT INTO wob_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","dɛ‑nʋɛ' 'de nyiɔ pɛe o mɔ tɔ' saɩn a 'wlʋ. \"Ku 'dbaa' o, dɛ \"itɩan' o, \"jriia' o, nyʋ ‑tɩ' \"kpei blaa' o, nyʋ cɛan' o, ");
INSERT INTO wob_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","dɩ ‑ɩa kpʋʋan nyiɔ ‑flɛn\" mɩ ‑nao. ‑Ɩn se kwa jre ‑wɛe ‑ɩn di dɛ ‑mɛ 'ɛ kpʋʋn nyiɔ ‑flɛn\". ");
INSERT INTO wob_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Sesi 'wlʋa 'mʋa‑ 'sʋ ɛ, ɔ muɛ 'e Tii ke Sidɔnblʋa \"kpei fɔ o. ");
INSERT INTO wob_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","'Sʋ Kanaan 'nynɔ due' ‑ji' 'de ɔ o ‑wɛe ‑ʋ ‑wɔ\", ‑ʋ ‑na : Tʋ\"bo, Dafidɩ 'a \"Ju, ‑ɩn ‑je 'ma wɛe‑ 'de ! 'Ma \"junynɔkpao' a 'jeɛ kui wɔn 'de ‑suusaʋn 'kwa. ");
INSERT INTO wob_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","'Kaa Sesi se 'e ʋa' wlu wlu jrɛ' \"kpei po mɔ \"pɩ. Ɔɔ' klai\" nynuu mʋ ‑kpɔ ‑pʋn\" ‑wɛe ‑ʋʋ ‑tmʋ ɔ ‑ʋʋ ‑na : ‑Ɩn nʋ 'nynɔkpao' ‑nʋ i ke, dɛ‑nʋɛ' ʋa \"wɔɔ' ‑a 'dei. ");
INSERT INTO wob_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","'De Sesi 'na : Nyʋ ‑ʋʋ ‑ma\" 'de Israɛ‑nyʋ \"klu ka 'blae ‑sia kwla nɩa, ʋʋpʋ 'a 'sʋ 'a jia' 'ɩn ji. ");
INSERT INTO wob_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","'Kaa ɔ 'da kan' 'sʋ 'nynɔkpao' ‑nʋ ji' ʋ \"siiɛ 'kɔi‑ i 'bo ɔ \"juɔi 'de ʋ 'na : Tʋ\"bo ‑ɩn ji 'ʋn o 'de ! ");
INSERT INTO wob_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","'Bomɔ Sesi wluu ɔ 'na : Ɛ se ka ‑cɔɔn'‑ ka‑ nɩ ‑wɛe nyʋ 'je nyiɔ 'ɔ \"nynuu 'a diidɩ 'ʋn \"duo‑ 'de ɔ 'jɩ ‑gbe' nynuu \"nyɩ. ");
INSERT INTO wob_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","'Sʋ ʋ 'na : tɔ' ‑tɩ ‑o ‑cɛɛn'‑ Tʋ\"bo, 'kaa dɩ ‑ɩa blua ɩa' jeʋn ‑sɔn i ɛ, ɩmɩ ‑gbe' a 'tɛn ‑wɛe ɩa di. ");
INSERT INTO wob_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","'Sʋ Sesi 'na : 'Nynɔkpao', ka aa' 'ma ‑kwlɩ\" ‑tea' 'bɛi\" ka‑ ! Ka a nɩai\" ɛ, ɛ nʋ kan'. 'De ɛɛ' nɔ\" ‑nɛ 'di 'bo ʋa' \"junynɔkpao 'a 'wɛ‑ 'bɔɔ‑. ");
INSERT INTO wob_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Sesi 'wlʋ 'mʋa‑ 'mɛ ‑wɛe ɔ mu 'o \"ni klaa\" ‑nɩa 'e Galile ‑kwlɩ\" 'sʋ ɔ 'ja 'o crʋ \"kpei ‑wɛe ɔ ‑te i. ");
INSERT INTO wob_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","'Sʋ nyʋ ‑tuu\"‑tuu ‑kpɔ ‑pʋn\", ʋʋ jɔ klɔɔʋn o, \"jri 'a waʋn o, nɩɩaʋn o, \"muu‑ o, nyʋ 'wɛ‑ 'ɛ \"kwli ‑wee' a nʋa o. Ʋʋ kpʋʋpʋ‑ 'bo Sesi bɩ wɔ ‑wɛe ɔɔ 'bɔɔ‑ ʋʋa' 'wɛ‑. ");
INSERT INTO wob_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Nyʋ ‑kwea de 'jea \"muu 'a wlu ‑ta a, ʋʋ 'jea nɩɩaʋn 'a 'pʋ ‑ta, ʋʋ 'jea klɔɔʋn 'a na ‑ta, ʋʋ 'jea \"jri 'a waʋn 'a i 'je ‑ta 'sʋ tai' \"maa ʋʋpʋ 'mɛ 'sʋ ʋʋ ‑teɛ Israɛ 'a Kea 'a 'nynɩ \"i 'bɛɛ‑ ‑pʋn\". ");
INSERT INTO wob_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","‑Mɛ 'wlʋa 'o ‑jei\" 'sʋ Sesi 'da ɔɔ' klai\" nynuu 'mɛ ‑wɛe ɔ 'na : Nyʋ ‑nʋ ʋʋa' wɛe a nʋ 'ʋn 'ɛ, dɛ‑nʋɛ' ʋʋ nʋɛ 'wɩ taan 'bo 'ʋn ‑pʋn\", 'kaa ʋʋ se dɛ di. 'Mɔ se ɛ \"inɩ 'ɩn 'je ʋʋpʋ ‑jei\" po 'de 'mɩɩɛ‑ 'ʋn, ‑wɛe ‑crigbaa je ʋʋpʋ ‑sa ʋʋa' de mu nɔ\" 'bo ‑jei\". ");
INSERT INTO wob_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","'Sʋ ɔɔ' klai\" nynuu 'na : ‑Ta ‑kwlɔ jrɛ' sea nɩ ‑ta 'ee, ‑taka ‑a ‑je nyʋ ‑tia ka 'a diidɛ ‑saa ? ");
INSERT INTO wob_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","'De Sesi ‑tee' ʋʋpʋ i ɔ 'na : ‑Di'pɛn kplɩ ‑tiiɛ'‑ ao 'ble ɛ‑ ? ʋʋ 'na : ‑A ‑bleɛ ‑di'pɛn kplɩ ‑mɛ\" 'sɔn ke ‑smii' jɔ mɩɩ\" jrɩ' ke‑. ");
INSERT INTO wob_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","'Sʋ ɔ 'tmʋɛ nyʋ ‑wee' \"klein ɔ 'na : Ao ‑te i. ");
INSERT INTO wob_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","‑Wɛe ɔ \"duo ‑di'pɛn kplɩ ‑mɛ\" 'sɔn ke ‑smii' jɔ ‑nɩ 'ʋn 'de ɔ po ɩa' Kea 'sɛ‑, ‑wɛe ɔ cɛɛn ɩ, ɔ \"nyɩ ɩ ɔɔ' klai\" nynuu ‑wɛe ʋʋ ‑gblɩ' nyʋ \"jrii. ");
INSERT INTO wob_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Nyʋ ‑wee' di' ʋʋ je dbo. Ɩa' tɔe ‑sia 'o, ‑wɛe ʋʋ 'tɩan i ɛ, ɩ \"jiɛ toe\" ‑mɛ\" 'sɔn. ");
INSERT INTO wob_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Nyʋ ‑ʋʋ dia dɛ 'mʋa‑ nɩɛ \"nynunmai 'a \"wlu ‑nyiiɛ, nyʋ se 'nynʋkpae' ke \"nynumɩɩ\" ‑sro'. ");
INSERT INTO wob_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Sesi ‑kwea nyʋ ‑nʋ wlu pooa' 'sʋ ɛ, ɔ 'ja 'e ‑kwɛɛ\" 'di ‑wɛe ɔ mu 'e Makadanblʋa \"kpei. ");
INSERT INTO wob_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Fariseɛn ke Sadiseɛn‑wi\" 'kpa Sesi ‑pʋn\" ‑wɛe ʋʋ 'je ɔ wlu 'a \"klɛ ‑pee ‑gba. ʋʋ ‑tee' ɔ i 'de ɔ 'je jrii' ‑wlʋa 'e jaʋn 'di 'a due' nʋ, ‑wɛe ka ɔ 'wlʋa 'de Kea o ɛ, ʋʋ 'je ɛ 'je. ");
INSERT INTO wob_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","'Kaa Sesi wlu' 'de ʋʋ ‑pee ɔ 'na : ‑Bo 'jrʋ a sea i 'pɛn ‑kwie\" ka a ‑wɛe jaʋn 'je ‑sain' ɛ, ‑mɛ ao 'na nɔ\" 'dɔe ‑a mu nɩa' ‑klae\"‑. ");
INSERT INTO wob_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","'De ‑bo ‑klae\" pɛɛn ɛ, ao 'na \"ni 'a ‑sɔugba a muɛ dbaa' ‑sɩan, ‑pie a muɛ jia' dɛ‑nʋɛ', jaʋn 'a ‑sain' 'a kpeɛ ‑sɔn i, ao juo jaʋn 'a nɩsʋn 'a \"kpei ‑seea' ka 'mɛ, 'kaa ao se dɩ ‑ɩa nʋʋa ‑sɩan 'a \"kpei ‑sɩɩa' ka juo‑. ");
INSERT INTO wob_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","‑Sɩanwɩ 'di nyʋ ‑ʋʋ ‑nyniia 'diwɔn, ‑ʋʋa pooa wlu fai\" 'de Kea ‑pee, ʋʋpʋ ‑a ‑tee' jrii' i, 'kaa jrii' jrɛ' se nʋʋɛi ‑bo ɛ se ‑jɛ ‑nʋʋa 'de Sonasɩ 'a ‑tɩ' 'ʋn nɩ ɛ. 'Sʋ ɔ 'wlʋ 'o ʋʋpʋ ‑pʋn\" 'mɛ, ɔ muɛ ‑tajrɔ. ");
INSERT INTO wob_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","‑Ta klai\" nynuu a muua 'de \"ni 'a 'fɔ jrɛ' o ɛ, ʋʋ \"mae' ʋʋ se di 'pɛn 'ʋn \"duo. ");
INSERT INTO wob_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","‑Wɛe Sesi wlu ʋʋ ‑pee ɔ 'na : Ao ‑tu\" aoa' ‑cɛ\" 'ɛ ‑tɩ' 'de Fariseɛn ke Sadiseɛn‑wi\" 'a ‑di'pɛn ‑puun\"dɛ 'ɛ ‑tɩ' 'ʋn. ");
INSERT INTO wob_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","'Sʋ klai\" nynuu ‑teɛ wlua' ‑pʋn\" 'bo ʋʋa' 'sʋ 'nynɩ, ʋʋ 'na : ‑A se ‑di'pɛn 'ʋn \"duo‑, mɛ ‑tɩ ɔɔ 'tmʋ dɛ ‑nɛ. ");
INSERT INTO wob_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Ka ʋʋ 'tmʋa dɛ ‑nɛ Sesi 'je kan' 'mɛ 'sʋ ɔ ‑teeɛ' ʋʋpʋ i ɔ 'na : Dɛɛ‑tɩ aoa naa aoa' ‑ɩn se ‑di'pɛn 'pɛn 'ʋn \"duo ‑mɛ 'ɛ tɔ' i ɛ‑ ? Ao ‑gbʋn ka aoa' Kea ‑kwlɩ\" ‑tea' 'piia \"i ɛ ! ");
INSERT INTO wob_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Ao se tɔ'di 'kpa kee ? Ao se ‑tɩ' ‑kwlɩ\" po kee ? ‑Ta 'ɩn cɛɛan ‑di'pɛn kplɩ ‑mm\" i 'de nyʋ 'a \"wlu ‑mm\" 'a ‑tɩ' 'ʋn 'ee, ɩa' toe\" ‑tiiɛ' ao \"duo 'ʋn ɛ‑ ? ");
INSERT INTO wob_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","'De ‑di'pɛn kplɩ ‑mɛ\" 'sɔn 'ɩn cɛɛan i 'de nyʋ 'a \"wlu ‑nyiiɛ 'ɛ ‑tɩ 'ʋn 'ee, ɩa' toe\" ‑tiiɛ' ao \"duo 'ʋn ɛ‑ ? ");
INSERT INTO wob_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","'De ‑mɛ ka 'ɩn sea ‑di'pɛn ‑tɩ 'tmʋ, dɛɛ‑tɩ ao se ɛ 'mii 'wɔn ɛ‑ ? 'Ɩn 'na ao ‑tu\" aoa' ‑cɛ\" 'ɛ ‑tɩ' 'de Fariseɛn ke Sadiseɛn‑wi\" 'a ‑di'pɛn ‑puun\"dɛ 'ɛ ‑tɩ' 'ʋn. ");
INSERT INTO wob_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","'Sʋ ka ɛ sea 'de ‑di'pɛn ‑puun\"dɛ 'ɛ ‑tɩ' 'ʋn nɩ ‑wɛe ɛ nɩa 'de Fariseɛn ke Sadiseɛn‑wi\" 'a nyʋ dɛtɔɔsʋn 'a ‑tɩ' 'ʋn mɛ ɔ ‑saa ʋʋpʋ fɛn' ʋʋ 'wɔn ɛ 'mii. ");
INSERT INTO wob_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Sesi nynia 'e Filipʋ o ‑kwlɔ 'de Sesare 'a 'blʋa 'a 'fɔ \"kpei 'sʋ ɛ, ɔ ‑teeɛ' ɔɔ' klai\" nynuu i, ɔ 'na : Dɛ nyʋ a 'tmʋ 'de 'mɔ nyiɔ 'ɔ \"ju 'a ‑tɩ' 'ʋn ɛ‑ ? ");
INSERT INTO wob_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","'Sʋ ʋʋ 'na : Nyʋ jrʋ' 'na ‑ɩn ‑nɩɛ San Batisɩ ‑o, jrʋ' 'na ‑ɩn ‑nɩɛ Eli ‑o, jrʋ' 'na : ‑Ɩn ‑nɩɛ Selemi ‑o, ‑wɛe jrʋ' 'na : ‑Ɩn ‑nɩɛ Kea 'a wlu 'kwajaaʋn ‑nɩa tɛin\" 'a due' ‑o. ");
INSERT INTO wob_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","'De Sesi 'na : 'De aopʋ mɔ 'e, nyɔ aoa 'daa‑ 'ʋn ɛ‑ ? ");
INSERT INTO wob_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","'Bomɔ Piɛi wluu‑ ɔ 'na : ‑Ɩn ‑nɩɛ Kea ‑nɩa 'kmʋ 'a \"Ju Klisɩ ‑o. ");
INSERT INTO wob_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Sesi \"dua wlu 'ʋn 'sʋ ɔ 'na : ‑Ɩn 'di nmɔ wɔn Simɔ, Sonasɩ 'a \"ju, dɛ‑nʋɛ' dɩ ‑ma ‑wlʋa 'tmʋa' ‑ta, ɛ se nyiɔ mɔ ‑sɛ 'kwla 'de ‑ʋn ‑pee nɩ‑, ɛ 'ɩn \"Bo ‑nɩa 'e jaʋn 'di ‑o. ");
INSERT INTO wob_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","'De 'mɔ ɛ, 'ɩn 'naa ‑ma 'nynɩ ‑nɩ Piɛi, ɛ 'de mɛ ‑nɩ \"sou, 'bo ɛɛ' \"sou tu \"kpei mɔ, 'ɩn 'je 'ma ‑gbu\" poo‑, ‑wɛe 'mɛa' se ɛ \"wɔin 'bɛɛi. ");
INSERT INTO wob_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","'Ma muɛ ‑ʋn tʋ\"bodɛ ‑nɩa 'e jaʋn 'di 'a ‑da'kle \"nyɩa' ‑wɛe dɩ \"klein ‑ma mua isaan' 'de 'blʋa‑ \"kpei ɩ 'je isaan 'de jaʋn 'di. 'De dɩ \"klein ‑ma mua ikaian' 'de 'blʋa‑ \"kpei ɩ 'je ikaiɛn 'de jaʋn 'di. ");
INSERT INTO wob_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","'Sʋ ɔ ‑tuu\" ɛ ɔɔ' klai\" nynuu wɔn ɔ 'na ka ɔ nɩa Nyʋ'pʋʋi Klisɩ ɛ, ʋʋ 'bo ɛ 'tmʋɛ 'de nyɔ jrɔ' ‑pee. ");
INSERT INTO wob_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Dɛ ‑wlʋa 'mʋa‑ Sesi ‑teɛ wlua' ‑pʋn\" 'pepe 'de ɔɔ' klai\" nynuu ‑pee ɔ 'na ɔ 'je Selisalɛm mu ‑o, ‑wɛe ɔ 'je 'kle 'je 'de nyʋ‑cɔɩn' o, 'sraa ‑saʋn 'a klae\" o, kɛ' wɔ‑saʋn 'kwa. Ʋʋa muɛ ɔ 'dbaa' ‑wɛe ɔ 'je 'kmʋ de ji 'de 'wɩ 'a taan ‑nɛ 'di. ");
INSERT INTO wob_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","'Sʋ Piɛi 'dɔɔ ‑tajrɔ ‑wɛe ɔ ‑cɛ' ɔ \"bli, 'de ɔ 'na : Dɛ ‑nɩa 'mʋa‑ ‑pɛɛ 'de ‑ʋn ‑wɔn de ! Kea a muɛ ‑ʋn o sia', ɛɛ' dɛ tu se ‑ʋn \"jrii nʋʋɛi 'nɔ 'kmʋ ! ");
INSERT INTO wob_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","'Kaa Sesi \"biiɛ i 'de ɔ o, ɔ 'na : ‑Siɔn' ‑koa, ‑ɩn ‑tɛɛn 'ʋn kɩn, ‑ɩn ‑nɩɛ \"i ‑ɩn ‑je 'ʋn 'de dɛsaʋn 'di po, dɛ‑nʋɛ' ‑ma tɔ' ke Kea 'a tɔ' se due' nɩ‑, ‑ɩn ‑bleɛ nyiɔtɔ'. ");
INSERT INTO wob_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","'Sʋ Sesi wlu' 'de ɔɔ' klai\" nynuu ‑pee ɔ 'na : ‑Bo nyɔ ‑nɩɛi\" ɔ ke 'ma ‑a ‑je na ‑mɛ ɔ 'bo ɔɔ' ‑cɛ\" 'kpa 'a 'kmʋ \"kpei 'tɔan, ‑mɛ ɔ 'wɔɔn‑ 'kle 'je ‑tɩ ‑wɛe ɔ 'je 'bo 'ʋn 'de bla, ");
INSERT INTO wob_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","dɛ‑nʋɛ' nyɔ ‑nɩɛi\" ‑ɔ ‑je ɔɔ' 'kmʋ \"kpei 'tɔan‑ a, ‑mɛ ɛɛ mu ɔ kwa \"maa', 'kaa nyɔ ‑ɔɔ mua ɔɔ' 'kmʋ 'bɔa 'de 'ma ‑tɩ' 'ʋn ɛ, ‑mɛ ɔmɔ ‑ɔɔ mu ɔɔ' 'kmʋ 'pʋʋa'. ");
INSERT INTO wob_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","‑Bo nyiɔ 'ble 'kmʋ ‑wee' \"klein ‑wɛe ɔɔ' ‑suu \"ma 'ee ‑mɛ dɛ ɔ 'je 'o mu ɛ‑ ? 'De dɛ nyiɔ 'je ja ‑wɛe ‑ɛ ‑je ɔɔ' ‑suu ‑kɔ o \"sii ɛ‑ ? ");
INSERT INTO wob_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Aoa 'jee, nyiɔ 'ɔ \"Ju a muɛ jia' 'de ɔ 'Bo 'a 'nynɩ 'wlʋa' 'ʋn, ɔ ke ɔɔ' \"soa‑wi\" ke‑, ‑wɛe ka nyʋ 'a dbo nɩa 'de ɔ 'je nyʋ ɛɛ' ‑kei\" ‑sa kan' due 'due. ");
INSERT INTO wob_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","'Ma 'tmʋʋ aopʋ tɔ' ‑tɩ nyʋ ‑nɩa 'kmʋ ‑ta ʋʋa' jrʋ' se 'mɛi 'sʋ ‑ʋʋ ‑je nyiɔ 'ɔ \"ju 'a deji ‑nɛ \"jriɛ‑ 'jee‑ 'de ɔɔ' 'beɔdɛ 'ʋn. ");
INSERT INTO wob_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","'Wɩ ‑mɛɛo\" ‑sia' 'sʋ ɛ, Sesi \"duɛ Piɛi ke Sakɩ ke ɔɔ' \"dei San 'ʋn ‑wɛe ʋʋ ke ɔ ‑saa kɩɩn ʋʋ mu 'e crʋ klaa\" due' \"kpei. ");
INSERT INTO wob_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","'Sʋ ɔ ‑saa \"i 'de ʋʋpʋ \"jri 'de, ɔɔ' \"jua‑ a fan' ka 'jrʋ nɩa, ɔɔ' 'ʋnpaadɩ \"pluu' \"puu' ka ‑sɔn' nɩa. ");
INSERT INTO wob_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Ʋʋa kɔan 'emu 'sʋ ‑mɛ Moisɩ ke Eli ‑taan' ‑wɛe ʋʋ ke Sesi a wlu‑. ");
INSERT INTO wob_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","'Sʋ Piɛi \"duɛ wlu 'ʋn ɔ 'na : Tʋ\"bo, ‑aa ‑ta nɩa' nmɔ \"jrii. ‑Bo ‑ɩn ‑nɩɛi\", 'ɩn 'je poe\" taan \"jɛi po, ‑mɔ ‑je due' 'ble, Moisɩ 'je due' 'ble ‑wɛe Eli 'je due' 'ble. ");
INSERT INTO wob_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Piɛi \"sia wlua' 'sʋ bue\" ‑ɛɛ nʋa blɛblɛ ‑criɛ\" ʋʋpʋ \"jrui, ‑wɛe wlu due' 'wlʋ 'e bue\" 'ʋn 'de ɛ 'na : \"Ju ‑nɔ nɩɛ 'ma ‑tɩ' kmaju ‑o. 'De ɔ 'ʋn 'bomɔ 'ma nyiɔ 'ɔ ‑tɩ' kmaa' ‑wee' nɩ‑, ao po ɔɔ' wlu doin\" o ! ");
INSERT INTO wob_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Klai\" nynuu 'wɔan wlu ‑nɛ 'sʋ ʋʋ ‑criɛ\" \"jrii 'bo 'blʋɔ, faʋn a nʋ ʋʋpʋ 'mɛ. ");
INSERT INTO wob_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","'Sʋ Sesi 'kpa ʋʋpʋ ‑pʋn\", ɔ bla ʋʋpʋ \"i 'de ɔ 'na : Ao sɔn 'ʋn, faʋn 'bo ao nʋɛ ! ");
INSERT INTO wob_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Ʋʋ kpa \"jri \"jɛi 'sʋ ʋʋ se nyɔ jrɔ' i 'je ‑bo ɛ se Sesi 'a 'sʋ nɩ ɛ. ");
INSERT INTO wob_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","‑Ta ʋʋa 'wlʋa 'de crʋ \"kpei ʋʋa \"sia i 'sʋ, Sesi ‑teɛ' ʋʋpʋ kɛ' \"i ɔ 'na : Dɛ ao 'jea \"jriɛ ‑ta ao 'bo ɛ 'tmʋɛ 'de nyɔ jrɔ' ‑pee mamaʋ 'sʋ nyiɔ 'ɔ \"Ju 'je \"kunyɩɔ' sɔn‑. ");
INSERT INTO wob_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","'Sʋ ɔɔ' klai\" nynuu ‑tee' ɔ i ʋʋ 'na : Dɛɛ‑tɩ ‑wɛe kɛ' wɔ‑saʋn 'na : Eli a muɛ de jia' \"i‑saa' nɔ\" ɛ‑ ? ");
INSERT INTO wob_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","'De ɔ 'na : Tɔ' ‑o, Eli a muɛ jia' ‑wɛe ɔ 'je dɩ ‑wee' kpɔi\" po. ");
INSERT INTO wob_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","'Kaa 'ma 'tmʋʋ aopʋ 'mɛ Eli ji' ‑wɛ‑ sese, ‑wɛe ʋʋ se ɔ \"i juo‑ ʋʋ nʋ ɔ ʋʋa' 'tʋn nʋ‑tɩ \"jrii. Ɔ 'jeɛ 'kle 'de ʋʋpʋ 'kwa, 'kamɔ nyiɔ 'ɔ \"Ju a mu 'kle 'jea' 'de ʋʋpʋ 'kwa ‑ke. ");
INSERT INTO wob_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","'Sʋ, ka ɛ nɩ San Batisɩ mɔ ɔɔ \"si 'nynɩ klai\" nynuu 'wɔn ɛ 'mii. ");
INSERT INTO wob_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","‑Ta ʋʋ jɛɛa nyʋ ‑tuu\"‑tuu ‑kɩɩan' \"jrui ɛ, 'bomɔ \"ju due' 'kpa Sesi ‑pʋn\" ‑wɛe ɔ \"sii‑ 'kɔi‑ i 'bo ɔ \"juɔi, ");
INSERT INTO wob_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","'de ɔ wlu ka : 'Ma 'blei, ‑ɩn ‑je 'ma \"ju 'a wɛe‑ 'de ! Susuwɛ‑ ‑ɛɛ nʋ ɔ, ɛɛ criɔ'. ‑Bo ɛɛ' 'cʋ dee 'pɛn \"kpae' 'sʋ, ɛɛ 'wlʋɛ \"blo, 'sʋ ɔɔ ‑ka i. ‑Bo 'wɩ jrɛ' o, ɛɛ blɔ i 'bo \"jri, 'wɩ jrɛ' o, ɛɛ ‑fi\" ɔ 'bo \"niɔ‑. ");
INSERT INTO wob_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","'Ɩn jɔ ‑ma klai\" nynuu 'mɛ, 'kaa ʋʋ se ɛɛ' 'wɛ‑ tu 'a 'bɔɔa' 'bɛɛ‑. ");
INSERT INTO wob_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","'Sʋ Sesi wluɛ ɔɔ' klai\" nynuu ‑pee ɔ 'na : Ao \"jrukuʋn ke 'diwɔnyniʋn 'a ti, 'de nɔ\" ‑tiiɛ' 'di ao ke 'ma ‑a ‑je i ‑te ke'wlɛ ɛ‑ ? 'De kpɛ ‑tiiɛ' 'ɩn 'je ao 'ble ɛ‑ ? Ao ja 'ʋn \"ju ‑saan\" 'nɔ ! ");
INSERT INTO wob_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","‑Wɛe ɔ kmaa wlu \"i, ɔ \"wɔɔ‑ ‑suusaʋn ‑nɛ \"jrui. 'Sʋ ɛ 'wlʋ 'e \"ju ‑saan\" 'ʋn 'ɛ, ɛ \"siɛ \"kpae'. 'Bo ɛ \"sri ɔɔ' 'wɛ‑ je 'bɔ. ");
INSERT INTO wob_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Ɛ nʋa kan' 'sʋ klai\" nynuu 'kpa Sesi ‑pʋn\" ‑wɛe ʋʋ ‑tee' ɔ i ʋʋ 'na : Dɛɛ‑tɩ ‑a se ‑suusaʋn ‑nɛ 'ɛɛ inʋa' 'bɛɛ ? ");
INSERT INTO wob_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","'De Sesi 'na : Aoa' Kea ‑kwlɩ\" ‑tea' se \"i 'bɛ, ɛmɛ ‑tɩ ‑o. 'Ma 'tmʋʋ aopʋ tɔ' ‑tɩ, ‑bo aoa' Kea ‑kwlɩ\" ‑tea' 'piie \"i ka \"ple 'jɔ 'bɛa, ‑bo ɛ 'bɛ kan', aoa muɛ crʋ ‑nɛ ‑pee wlua' ao 'je nʋ : ɛ 'wlʋ ‑ta ! ‑Wɛe ɛ 'je ao wɔn 'je. Dɛ ao sea \"wɔin 'bɛɛ i ‑mɛ se nɩ‑. ");
INSERT INTO wob_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","'Kaa ɛɛ' ‑suusaʋn ‑tu ‑bo ɛ 'je 'e nyʋ 'ʋn 'wlʋ ɛ, ‑mɛ 'de Kea baea' ke wɔn 'bɔa' 'ʋn ‑o. ");
INSERT INTO wob_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","'Wɩ jrɛ' o ‑ta ʋʋ nɩa Galileblʋa \"kpei i plea' 'bomɔ Sesi wluu 'de ɔɔ' klai\" nynuu ‑pee ɔ 'na : Nyiɔ 'ɔ \"Ju 'je 'e tooɛ ‑o 'de nyiɔpʋ 'kwa ");
INSERT INTO wob_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","‑wɛe ʋʋ 'je ɔ 'dba. 'De ɔ 'je \"kunyɩɔ' sɔn 'de 'wɩ 'a taan ‑nɛ 'di. Ɔ 'da kan' 'sʋ klai\" nynuu \"kaeɛ \"jrii. ");
INSERT INTO wob_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Sesi ke ɔɔ' klai\" nynuu nynia Kapɛnaʋm 'sʋ ɛ, ‑dɛinpo'‑ ‑saʋn 'kpa Piɛi ‑pʋn\" ‑wɛe ʋʋ wlu ka : Aoa' dɛtɔɔi a ‑sa' Kea ‑gbu 'a ‑dɛinpo'‑ 'mɛɛ ? ");
INSERT INTO wob_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Piɛi 'na : Kɩɩn, ɔɔ ‑sɛ' ! Piɛi pa ‑gbu\" 'sʋ Sesi \"duɛ wlu 'ʋn tɛin\", ɔ 'na : Simɔ, ka ‑ma nɛɛ tɔ' \"kpei ɛ‑ ? Nyɔ ‑je 'beɔ‑wi\" ‑nɩa 'e 'blʋa‑ ‑nɛ \"kpei 'a ‑dɛinpo'‑ ‑sa a‑ ? Ʋʋa' ‑cɛ\" 'ɛ 'bleenyʋ ‑ae, ‑aee' 'dʋɩ ‑ɩ ? ");
INSERT INTO wob_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","'Sʋ Piɛi 'na : 'Dʋɩ‑ ‑a ‑sɛ'. 'De Sesi 'na : ‑Jɛ ɛ nɩa kan' ‑mɔ ɛ, ‑mɛ ʋʋa' 'bleenyʋ ‑mʋ se ɛ ‑sai. ");
INSERT INTO wob_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","'Kaa ‑a ‑bo ɛ nʋɛ ‑wɛe nyʋ ‑nʋ 'bo ‑a 'cɛn i 'kpaa'. ‑Ɩn mu kwɛn\" po 'de 'tɔniɛ wɔn. \"I‑saa ‑smiiɛ' ‑ɛɛ mua kwɛn\" kpʋan' a, ‑ɩn ‑criɛ' ‑ɩn ‑je ɛɛ' wɔn 'ba 'de ‑ɩn ‑je 'e 'wɛijɔ ‑sa ‑wɛe ‑ɩn ‑je ‑ɩn ke 'ma ‑a ‑saadɛ ja‑. ");
INSERT INTO wob_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","'De ɛɛ' nɔ\" tu 'di ɛ, Sesi 'a klai\" nynuu 'kpɔ ‑pʋn\" ‑wɛe ʋʋ ‑tee' ɔ i, ʋʋ 'na : ‑ɔ ‑nɩ Kea 'a kɛɛma' ‑kwlɔ ‑nɩa 'e jaʋn 'di 'a klaa\" a‑ ? ");
INSERT INTO wob_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","'Bomɔ Sesi 'daa‑ \"ju ‑saan\" due' ‑wɛe ɔ nynɔɔ i 'bo ʋʋa' ‑kwea'‑. ");
INSERT INTO wob_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","'De ɔ 'na : 'Ma 'tmʋʋɛ aopʋ tɔ' ‑tɩ, ‑bo ao se kplɩn fai\" poo ‑wɛe ka \"nynumɩɩ\" nɩa ao se kan' nɩ ɛ, ‑mɛ ao se 'e Kea 'a kɛɛma' ‑kwlɔ ‑nɩa 'e jaʋn 'di 'di pai. ");
INSERT INTO wob_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Ɛmɛ ‑tɩ nyɔ ‑jaa ɔɔ' ‑cɛ\" ja ‑wɛe ka \"ju ‑saan\" nɩa, ‑ɔ ‑nɩa kan' a, ɔmɔ ‑nɩ klaa\". ");
INSERT INTO wob_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","'De nyɔ \"o nyɔ ‑kpʋʋan \"ju ‑saan\" ‑nɩa ka sɩn 'sɔɔn 'de 'ma 'nynɩ 'ʋn ɛ, ‑mɛ 'mɔ ɔ kpʋʋn sɩn 'sɔɔn. ");
INSERT INTO wob_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","'Kaa ‑bo nyɔ jrɔ' 'ɔ nʋʋdɩ bluua 'ma ‑tɩ' tɔ' 'ʋn 'jeʋn 'a ‑saan\"‑ due' 'de dɛsaʋn 'di ɛ, ‑mɛ dɛ ‑jea \"paa' 'de ɔɔ' ‑tɩ' 'ʋn mɛ ‑nɩ nyʋ saan ɔ \"soukpo ‑plun ‑wɛe nyʋ ‑fii\" ɔ 'de 'tɔniɛ wɔn. ");
INSERT INTO wob_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Ɛ nɩɛ \"nmia‑tɩ ‑o 'de nyʋ ‑wee' \"klein 'a ‑tɩ' 'ʋn, dɛ‑nʋɛ' dɩ ‑jea nyʋ 'de dɛsaʋn 'di bluua a, ka \"o ka‑, ɩa' dɩ tu a muɛ jia' see, 'kaa ɛɛ muɛ wɛe ‑tɩ nɩa' 'de nyɔ ɩa mua 'ʋn jiia' 'a ‑tɩ' 'ʋn. ");
INSERT INTO wob_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","‑Bo ‑ma sʋn ke ‑ma bʋ a sea ‑ʋn 'de dɛsaʋn 'dipo ɛ, ‑mɛ ‑ɩn cɩn 'o ‑ɩn ‑jɩ 'kwla po fiin. ‑Ɩn ‑ble sʋn due' ke bʋ due' ‑wɛe ‑ɩn mu 'e 'kmʋ ‑cɛɛn' 'ʋn \"paa', ɛ je ‑ɩn ‑ble sɩn 'sɔɔn ke bɩ 'sɔɔn ‑wɛe ‑ɩn mu 'e nɛ ‑ɛ sea 'mʋ ‑ta 'ble 'ʋn ‑sii. ");
INSERT INTO wob_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","'De ‑bo ‑ma \"jriɛ‑ ɛ sea ‑ʋn 'de dɛsaʋn 'dipo ɛ, ‑mɛ ‑ɩn ‑sɛ 'de ‑ʋn kɔn'. ‑Ma ‑nɩ \"jriɛ‑ due' \"i ‑wɛe ‑ɩn mu 'e 'kmʋ ‑cɛɛn' 'ʋn \"paa', ɛ je ‑ɩn ‑ble \"jri 'sɔɔn ‑wɛe ‑ɩn mu 'e nɛ 'ʋn ‑sii. ");
INSERT INTO wob_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","Ao ‑tu\" aoa' ‑cɛ\" 'ɛ ‑tɩ', ao 'bo \"nynumɩɩ\" ‑nʋ 'a due' koʋn ‑gbai ‑flɩɩɛn, dɛ‑nʋɛ' ʋʋa' \"soa‑wi\" ‑tea ʋʋpʋ 'a ‑tea' 'de jaʋn 'di ɛ, ʋʋa 'jeeɛ 'ɩn \"Bo \"jriɛ‑ 'de 'wɩ \"oo 'wɩ ‑wee' 'di. ");
INSERT INTO wob_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Dɛ‑nʋɛ' nyiɔ 'ɔ \"Ju jiɛ nyʋ ‑ma\" 'pʋʋa'. ");
INSERT INTO wob_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","Ao po doin\" i, ‑bo nyɔ due' 'ble 'blae 'a kmɛ' 'due ‑wɛe ɩa' due' \"ma, ɔɔ' sie ɩa' kwla ‑mɛ\" nyɛ 'jɔ ‑mɛ\" nyɛ 'bo crʋ ‑kwlɩ\" ‑wɛe ɔɔ' mu due' ‑jɛ ‑ma\" i ‑pɔaan' ? ‑Aee' ɛ se kan' nɩɩ ? Ka aoa nɛɛ tɔ' \"kpei‑ ɛ‑ ? ");
INSERT INTO wob_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","'Ma 'tmʋʋɛ ao tɔ' ‑tɩ, ‑bo ɔ ‑sɛ 'kwla a, ɛ 'bleɛ ɔɔ' 'mʋa‑, ɛ je 'blae 'a kwla ‑mɛ\"nyɛ 'jɔ ‑mɛ\"nyɛ ‑jɩ ‑sea' \"ma ‑sii. ");
INSERT INTO wob_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","'Kamɔ ɛ nɩ ‑ke, ao \"Bo ‑nɩa 'e jaʋn 'di se ɛ \"inɩ nyɔ ‑saan\" due' koʋn ‑gbai' 'je \"ma. ");
INSERT INTO wob_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","‑Bo ‑ma de'di nʋ dɛsaʋn ɛ, ‑mɛ ‑ɩn ‑kpɔ ‑pʋn\" ‑wɛe ɔ ke ‑ɩn ‑je 'sɔɔn ‑nɩ 'de ao 'je wlu‑. ‑Bo ɔ po ‑ma wlu doin\" o ɛ, ‑mɛ ‑ɩn ‑pʋʋ' ‑ma de'di 'mɛ. ");
INSERT INTO wob_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","'De ‑bo ɔ se ‑ma wlu doin\" o po ɛ, ‑mɛ ‑ɩn ‑da nyɔ due', nyʋ 'sɔɔn, ‑wɛe nyʋ 'sɔɔn ke taan 'je ɩa' ‑tɩ' 'tmʋ‑ta 'je. ");
INSERT INTO wob_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","'De ‑bo ɔ 'na ɔ se ‑wi\" ‑mʋ 'a wlu doin\" o poi 'jaa, ‑mɛ ‑ɩn ‑toɛ Kea ‑gbu \"i. ‑Bo ɔ 'na ɔ se Kea ‑gbu 'a wlu doin\" o poi ɛ, ‑mɛ ‑ɩn ‑gbʋn ɔ ja ka nyɔ ‑sea' Kea 'a ‑tɩ' tɔ' 'ʋn 'je ke ‑dɛɩnpo' ‑sai nɩa. ");
INSERT INTO wob_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","'Ma 'tmʋʋɛ aopʋ tɔ' ‑tɩ, dɩ \"klein aoa mua isaan' 'nɔ 'blʋa‑ \"kpei ɛ, ɩa muɛ isaan' 'de jaʋn 'di, 'de dɩ \"klein aoa mua ikaian' a, ɩa muɛ ikaian' 'de jaʋn 'di. ");
INSERT INTO wob_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","'De 'ma 'tmʋʋɛ aopʋ 'mɛ ke'wlɛ, ‑bo nyʋ 'sɔɔn 'bɛɛ‑ wlu 'ʋn 'de aopʋ \"klu 'de 'blʋa‑ \"kpei ‑wɛe ʋʋ 'je dɛ i ‑tee' ɛ, 'ɩn \"Bo ‑nɩa 'e jaʋn 'di a muɛ ɛ ʋʋpʋ \"nyɩa' see. ");
INSERT INTO wob_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Dɛ‑nʋɛ' ‑ta nyʋ 'sɔɔn ke nyʋ taan 'kɩɩan \"jrui 'de 'ma 'nynɩ 'ʋn ɛ, 'ɩn nɩ 'bo ʋʋpʋ 'a ‑kwea' 'mɛ. ");
INSERT INTO wob_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","'Sʋ Piɛi 'kpa Sesi ‑pʋn\" ‑wɛe ɔ 'na : ‑Bo 'ma de'di nʋ 'ʋn dɛsaʋn \"jrii 'ee, kpɛ ‑tiiɛ' 'ɩn 'je ɛ o 'bɔ ɛ‑ ? 'Ɩn 'bɔ ɛ o mamaʋ 'sʋ ɛ 'je kpɛ ‑mɛ\" 'sɔn nyni ‑aee ? ");
INSERT INTO wob_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","'De Sesi 'na : 'Ɩn se 'na ‑ɩn nʋ kpɛ ‑mɛ\" 'sɔn, 'kaa ‑ɩn mu mamaʋ 'sʋ ‑ɩn ‑je kpɛ 'ɛ kwla ‑mɛ\" 'sɔn 'ɔ kpɛ ‑mɛ\" 'sɔn nyni. ");
INSERT INTO wob_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","'Ma 'tmʋ aopʋ 'mɛ : Kea ‑nɩa 'e jaʋn 'di 'a 'tʋn nʋ‑tɩ nʋa' ‑kɔ' 'beɔ due' ‑ɔ ‑da ɔɔ' dbonʋʋn 'de 'wɛi ʋʋ 'jea ʋʋ 'je ɩa' \"kuan po. ");
INSERT INTO wob_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","‑Ta ɔ ‑teea 'wɛi ‑sroa' ‑pʋn\" 'sʋ, ʋʋ jɔ \"ju due' ‑ɔ ‑ble ɔɔ' 'wɛi 'a ‑kwlʋtau\". ");
INSERT INTO wob_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","‑Ta \"ju ‑nɔ 'jea dɛ ‑sa ‑wɛe ɔ 'je ɔɔ' 'blei 'a kpan ‑sa 'bo se nɩ‑, 'sʋ ɔɔ' 'blei 'na : Ao ple ɔɔ' ‑cɛ\" ke ɔɔ' 'nynɔ ke ɔɔ' \"nynuu‑ ke ɔɔ' 'bleedɩ ‑wee' \"klein ke ‑wɛe ɔ 'je 'ma kpan ‑sa. ");
INSERT INTO wob_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","'Sʋ \"ju ‑nɔ \"siiɛ 'kɔi‑ i 'bo ɔɔ' 'blei \"juɔi ‑wɛe ɔ bae ɔ i ‑bae ‑bae 'de ɔ 'na : ‑Ɩn ‑kuu tɔ' i 'de 'ma ‑tɩ' 'ʋn, 'ma muɛ ‑ma kpan ‑wee' ‑saa'. ");
INSERT INTO wob_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Dɛ ‑nɩa 'mʋa‑ kpʋn ɔɔ' 'blei ‑kwlʋ 'sʋ ɔ 'jeɛ ɔɔ' wɛe‑, ‑wɛe ɔ 'na : ‑Ɩn mu, 'ɩn 'bɔ 'wɛi ‑nɩa ‑ʋn \"kpei 'mɛ, ‑ɩn se 'ma kpan 'ble 'bode. ");
INSERT INTO wob_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Dbonʋi ‑nɔ \"sia \"kpae' 'sʋ ɔ ke ɔɔ' \"dɛi due' ‑ɔ ‑ke ɔɔ nʋa dbo ‑tadue ‑wɛe ‑ɔ ‑blea ɔɔ' kpan dɛ‑saan\" ‑gbʋʋn'. 'Sʋ ɔ kpʋn ɔ ‑pliɔn', ɔ 'na : ‑Ɩn ‑sa 'ma kpan ! ");
INSERT INTO wob_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Ɔɔ' \"dɛi ‑nɔ \"siiɛ 'kɔi‑ i 'bo 'blʋɔ 'bo ɔ bɩ wɔ ‑wɛe ɔ bae ɔ i ‑bae ‑bae 'de ɔ 'na : ‑Ɩn ‑kuu tɔ' i 'de 'ma ‑tɩ' 'ʋn 'ma muɛ ‑ma kpan ‑saa'. ");
INSERT INTO wob_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","'Kaa \"ju ‑nɔ 'na ɔ se 'wɔn, ‑wɛe ɔ mu 'de ɔ po ɔ \"dɛi ‑kaso 'di, ɔ 'na 'demɔ ɔ 'je nɩ mamaʋ 'sʋ ɔ 'je ɔɔ' kpan ‑sa. ");
INSERT INTO wob_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Dɛ ɔ nʋa 'mʋa‑ ɔɔ' \"dɛi‑wi\" 'je ɛ 'sʋ ʋʋ \"kaeɛ \"jrii \"kɩkɩ. Ʋʋ mu' ‑wɛe dɩ \"klein ‑nʋʋa ʋʋ po ʋʋa' 'blei ɩa' \"kuan. ");
INSERT INTO wob_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","'Sʋ ɔ 'da dbonʋi ‑nɔ 'mɛ ‑wɛe ɔ wlu ɔ ‑pee ɔ 'na : Ka ‑ma dbonʋi tu nyni 'di wɔn kan' a‑ ! 'Ma kpan ‑nɩa ‑ʋn \"kpei ‑ɩn ‑baea 'mii ɛ, 'ɩn 'bɔ ɛ ‑wee' \"klein 'mɛ. ");
INSERT INTO wob_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","‑Ɩn se ɛ 'bɛɛ‑ ‑kee, ‑ɩn ‑je ‑ma \"dɛi 'a wɛe 'je, ka 'ɩn 'jea ‑ma wɛe ɛɛ ? ");
INSERT INTO wob_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","'Sʋ ɔɔ' 'blei 'kpa 'cɛn, ɔ 'na : Ao kpʋn ɔ, ao po ɔ ‑kaso 'di, 'demɔ ɔ 'je nɩ mamaʋ 'sʋ ɔ 'je 'ma kpan ‑wee' \"klein ‑sa. ");
INSERT INTO wob_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","‑Wɛe Sesi poɛ \"kpei ka, ɔ 'na : 'Kamɔ 'ɩn \"Bo ‑nɩa 'e jaʋn 'di a mu ao nʋa' due 'due ‑bo ao se aoa' de'di 'a dɛsaʋn \"kpei 'wlʋ 'de pɛe ‑wee' \"klein 'ʋn ɛ. ");
INSERT INTO wob_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Sesi ‑kɔa' ‑tɩ' 'tmʋa' kan' 'sʋ ɛ, ɔ 'wlʋ 'e Galileblʋa \"kpei 'mɛ ‑wɛe ɔ mu 'e Suideblʋa \"kpei 'de Sudɛn ‑gbuu 'a 'fɔ jrɛ' o. ");
INSERT INTO wob_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Nyʋ ‑tuu\"‑tuu mu ɔ kɩɩn, ‑wɛe ɔɔ 'bɔɔ‑ ʋʋpʋ 'a 'wɛ‑. ");
INSERT INTO wob_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","'Sʋ Fariseɛn‑wi\" 'kpɔ ‑pʋn\" ‑wɛe ʋʋ 'je ɔ wlu 'a \"klɛ ‑pee ‑gba. ʋʋ 'na : 'De ‑aa kɛ' 'di 'dee, \"junmɔu 'beeɛ' ɔ 'je ɔɔ' 'nynɔ 'kwla ‑sa 'de dɛ \"o dɛ 'ɛ ‑tɩ 'ʋʋn ? ");
INSERT INTO wob_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Sesi 'na : \"I‑saa' nɔ\" Kea nʋɛ \"junmɔu ke 'nynɔkpao' ke, ");
INSERT INTO wob_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","‑wɛe ɛ 'naa \"junmɔu a mu ɔ \"bo ke ɔ de ‑pʋn\" 'wlʋa' ‑wɛe ɔ ke ɔɔ' 'nynɔ 'je \"i \"sii‑ 'de ʋʋ ‑nɩa 'sɔɔn ʋʋ 'je nyiɔ due' ma. Ao nʋɛ 'dii 'mɛ, ‑aee' ɛ se kan' nɩ‑ ? ");
INSERT INTO wob_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","‑Bo ɛ nɩ kan' a, ‑mɛ ʋʋ se 'sɔɔn nɩ‑ 'bode, 'kaa ʋʋ ma nyiɔ due'. Dɛ Kea ‑tuu\" a \"i ɛ, nyiɔ 'bo ɛ \"i ‑seea'. ");
INSERT INTO wob_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","'Sʋ ʋʋ 'na : 'De ‑mɛ dɛɛ‑tɩ Moisɩ ‑mɔ 'na ‑bo nyɔ ‑sa 'nynɔ 'kwla ‑mɛ ɔ \"nyɩ ʋ 'sbɛ ‑wɛe ɔ 'je ʋ ‑jei\" po 'ja a‑ ? ");
INSERT INTO wob_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Sesi 'na : 'De aoa' pɛe 'a \"ikmua' 'a ‑tɩ' 'ʋn ‑o, ɛmɛ ‑tɩ Moisɩ 'da kan', 'kaa tɛin\" 'de ɛ, ɛ se kan' nɩ‑. ");
INSERT INTO wob_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","'Ma 'tmʋʋ‑ aopʋ 'mɛ, nyɔ ‑ɔɔ 'nynɔ sea' jɛi\" 'je ‑wɛe ‑ɔ ‑sʋ 'kwla 'de ‑ɔ ‑dua\" 'nynɔ jrɔ' 'ʋn ‑mɛ ɔɔ' jei tu 'kpa 'e jɛi\" 'jea' 'di. ");
INSERT INTO wob_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","'Sʋ ɔɔ' klai\" nynuu 'na : ‑Bo ɛ 'je kan' nɩ 'de \"junmɔu ke ɔɔ' 'nynɔ 'ɔ ‑tɩ' 'ʋn ɛ, ‑mɛ ‑ɩn se 'nynɔ 'ble ‑wɛe ‑ɩn ‑te i ‑mɛ \"paa' 'de ! ");
INSERT INTO wob_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","'Bomɔ Sesi wlu 'de ʋʋ ‑pee ɔ 'na : Dɛ ‑tmʋa', nyʋ ‑tuu\"‑tuu 'a 'wɔɛn 'mii see, ‑bo ɛ se nyʋ ‑ʋʋ ‑pee Kea ‑sɛɛ 'kwla nɩ ɛ, ");
INSERT INTO wob_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","dɛ‑nʋɛ' dɩ ‑tuu\"‑tuu ‑a kaan nyiɔpʋ ‑je de 'de 'nynɔ 'ble ‑tɩ 'ʋn. Deejrʋ' 'wlʋʋ‑ ɛɛ' dɛ tu 'ʋn 'ɛ, nyʋ jrʋ' ‑nɩ 'e nyiɔpʋ wa 'ʋn ‑wɛe ‑ʋʋ se ɛ 'bɛɛ‑ ‑ʋʋ ‑je 'nynɔ 'ble 'de nyʋ jrʋ' ‑nɩ 'emu ke'wlɛ ‑ʋʋa' 'ble 'nynɔ 'de tʋ\"bodɛ ‑nɩa 'e jaʋn 'di 'a ‑tɩ' 'ʋn. Nyɔ ‑bɛɛa' ‑ɔ ‑jea ɛɛ' dɛ tu 'mii 'wɔn ɛ, ‑mɛ ɔ 'wɔɛn 'mii. ");
INSERT INTO wob_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","'Sʋ ʋʋ ja Sesi \"nynumɩɩ\" ‑wɛe ɔ 'je ʋʋpʋ kwa \"jru ‑te' 'de ɔ 'je ʋʋa' Kea bae‑. 'Kaa ɔɔ' klai\" nynuu a kaan ʋʋpʋ ‑je de. ");
INSERT INTO wob_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","‑Wɛe Sesi wlu ka ɔ 'na : Ao \"tai‑ \"nynumɩɩ\" \"i, ʋʋ 'je 'nɔ 'ʋn o ji, ao 'bo ʋʋ ‑je de kaan, dɛ‑nʋɛ' nyʋ ka ʋʋ nɩa ‑ʋʋ ‑nɩa kan' a, ʋʋpʋ ‑je 'de 'kmʋ dee‑ 'ʋn pa. ");
INSERT INTO wob_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Ɔ ‑tea' ʋʋpʋ kwa \"jru 'sʋ ɔ 'wlʋ 'mʋa‑ 'mɛ. ");
INSERT INTO wob_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","\"Ju due' 'kpa Sesi ‑pʋn\" ‑wɛe ɔ ‑tee' ɔ i ɔ 'na : Nyʋ dɛtɔɔi, dɛ 'dɔe ‑jɛ wɛ‑ 'ɩn 'je nʋ ‑wɛe 'ɩn 'je 'kmʋnɩa' ‑sea' ‑kwɛ ‑ta 'ble 'je ɛ‑ ? ");
INSERT INTO wob_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","'Sʋ Sesi 'na : Dɛɛ‑tɩ ‑ma ‑tee' 'mii 'de dɛ 'dɔe 'a ‑tɩ' 'ʋn ɛ‑ ? Nyɔ due' koʋn ‑gbai' mɔ nɩ nyɔ 'dɔe. ‑Bo ‑ɩn ‑nɩɛ \"i ‑ɩn ‑je 'de Kea 'a 'kmʋnɩa' 'ʋn paa, ‑mɛ ‑ɩn nʋ ɛɛ' kɛ'. 'Sʋ \"ju ‑nɔ 'na : Kea 'a kɛ' 'ɩn 'jea nʋ ‑mɛ 'de ɛ‑ ? ");
INSERT INTO wob_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","'Sʋ Sesi ‑teeɛ kɛ' 'wɔn itbaa' ‑pʋn\" ɔ 'na : ‑Ɩn ‑bo \"ku 'dbaa, ‑ɩn ‑bo jɛi\" 'jeɛ, ‑ɩn ‑bo \"jriiɛ, ‑ɩn ‑bo nyʋ sɩ \"kpei ‑tuu\" ɛ, ");
INSERT INTO wob_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","‑ɩn ‑te' ‑ɩn \"bo ke de 'a ni', ‑wɛe ‑ɩn ‑je ‑ʋn ‑ponyiɔ 'ɔ ‑tɩ' kma ka ‑ɩn ‑kma ‑ma ‑cɛ\" 'kpa 'a ‑tɩ' ɛ. ");
INSERT INTO wob_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","'Sʋ ‑kooai\" ‑tɔo ‑nɔ 'na : 'Ɩn 'je kɛ' ‑nɩ ‑wee' \"klein wɔn 'mɛ, dɛ jrɛ' ‑wɛ ‑sie 'o 'ɩn 'je nʋ ke'wlɛ ɛ‑ ? ");
INSERT INTO wob_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Sesi 'na : ‑Bo ‑ɩn ‑nɩɛ \"i ‑ɩn ‑je 'pepe nɩɛ, ‑mɛ ‑ɩn ple' ‑ma dɩ ‑wee', ‑ɩn ‑je ɩa' 'wɛi nɩɩa\" nyʋ \"nyɩ. 'De ‑ɩn ‑je \"wliiɛ‑ 'ble 'de jaʋn 'di. ‑Wɛe ‑ɩn ‑je ji 'de ‑ɩn ‑ke 'ma ‑a ‑je na‑. ");
INSERT INTO wob_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","'Kaa \"ju ‑nɔ 'wɔan wlu ‑nɛ ɛ, ɔ mu' 'de \"jrii \"kaea' 'ʋn, dɛ‑nʋɛ' ɔ nɩɛ \"wliiɛjei klaa\" ‑o. ");
INSERT INTO wob_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","'Bomɔ Sesi wluu 'de ɔɔ' klai\" nynuu ‑pee ɔ 'na : tɔ' ‑tɩ 'a tɔ' ‑tɩ 'ma 'tmʋʋ aopʋ, \"wliiɛjei 'a Kea 'a 'kmʋ dee‑ 'di paa' nɩɛ 'kle. ");
INSERT INTO wob_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","'Ma 'tmʋʋ‑ aopʋ 'mɛ ke'wlɛ, ‑sɛn\"kpei soo\" 'a 'bo \"mɛʋn 'a ‑po\" \"ipaa' \"kʋan \"jri i, ɛ je \"wliiɛjei 'a 'de Kea 'a 'kmʋ dee 'di paa' ‑mɛ ‑sii ke'wlɛ. ");
INSERT INTO wob_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Klai\" nynuu 'wɔan wlu ‑nɛ 'sʋ ɛ, tai' \"maa' ʋʋpʋ 'mɛ, 'sʋ ʋʋ 'na : 'De ‑mɛ nyɔ ‑je 'pʋ 'ja a‑ ? ");
INSERT INTO wob_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Sesi ‑gbʋan ʋʋpʋ ja ‑gbʋn ‑gbʋn 'sʋ ɔ 'na : Dɩ nyiɔpʋ sea 'bɛɛ‑ ʋʋ 'jea nʋ ɛ, Kea 'bɛɛ‑ ɩa' nʋa' 'mɛ. ");
INSERT INTO wob_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Piɛi \"dua wlu 'ʋn 'sʋ ɔ wlu' 'de Sesi ‑pee, ɔ 'na : ‑Ɩn ‑gbʋn 'nɔ, ‑apʋ mɔ 'bɔ ‑aa dɩ ‑wee' \"klein 'mɛ, ‑wɛe ‑a bla 'bo ‑ʋn ‑de, dɛ ‑a ‑e 'je ɛ‑ ? ");
INSERT INTO wob_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Sesi 'na : 'Ma 'tmʋʋ ao tɔ' ‑tɩ, ‑sɔntɩ Nyiɔ 'ɔ \"Ju a mua i‑tea' 'bo ɔɔ' tʋ\"bokpa‑tɛ \"kpei 'de dɩ ‑wee' 'a ‑gbɔdee \"nipo nɔ\" ɛ, aopʋ ‑ɔ ‑ke 'ma ‑a ‑na' aoa muɛ 'beɔkpa‑tɛ 'ɛ ‑puue 'jɔ 'sɔɔn \"kpei ‑tea' ‑ke ‑wɛe ao 'je Israɛ 'ɛ 'blʋa 'a blo'wɔn ‑nɩa ‑puue‑ 'jɔ 'sɔɔn 'ɔ 'pee 'je. ");
INSERT INTO wob_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Nyɔ \"o nyɔ ‑ɔɔ mua ɔɔ' ‑gbi\" o, ɔɔ' de'dinmai o, ɔɔ' de'dinynʋkpae' o, ɔ \"bo ke ɔ de o, ɔɔ' 'nynɔ ke ɔɔ' \"nynuu‑ o, ɔɔ' 'blʋa‑ 'bɔa' 'de 'ma 'nynɩ 'a ‑tɩ' 'ʋn ɛ, ɔɔ muɛ ɩa' \"kpei ‑tea' 'jea' kpɛ 'ɛ kmɛ' 'due ‑wɛe ɔ 'je 'kmʋ ‑sea' ‑kwɛ ‑ta 'ble 'je 'bo ‑mɛ 'de. ");
INSERT INTO wob_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","'Kaa nyʋ ‑saa \"i kaan, ʋʋa' jrʋ' a muɛ de 'bɔɔa' ‑wɛe nyʋ ‑bɔɔa' de ɛ, ʋʋa' jrʋ' 'je nya kɔn‑. ");
INSERT INTO wob_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Sesi 'na : Dɛ ‑ke Kea 'a nyʋ 'blesʋn ‑nɩa 'e jaʋn 'di ‑kɔɔa', ɛ ka : Ɛ ‑kɔ' ‑kle' jei due' ‑ɔ ‑sɔan 'ʋn ‑klae\" pɛɛn ‑wɛe ‑ɔ ‑dua\" dbonʋʋn 'ʋn 'de ʋʋ 'jea 'de ɔ o ‑kle mu ɛ. ");
INSERT INTO wob_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Ɔ ke ʋʋpʋ 'bɛɛ‑ 'wɛijɔ due 'a wlu 'ʋn 'de ‑sɔn' 'di, ‑wɛe ɔ kpa ʋʋpʋ 'de ɔ o ‑kle. ");
INSERT INTO wob_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","‑Klae\" jrʋ‑gbao o 'sʋ ɔ 'jeɛ nyʋ jrʋ' 'bo \"kpae' ‑ʋʋ ‑te i foo\" 'ʋn ‑ʋʋ se nʋʋdbo 'ble. ");
INSERT INTO wob_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","'Sʋ ɔ wlu' 'de ʋʋ ‑pee ɔ 'na : Ao mu dbo nʋ 'de 'ʋn o ‑kle, ‑wɛe dɛ ‑ɛ ‑ke ao ‑kɔɔa' \"i ɛ, 'de 'ɩn 'je ɛ aopʋ \"nyɩ. ");
INSERT INTO wob_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","'Sʋ ‑wi\" ‑mʋ mu'. ‑Kle' jei \"sia \"kpae' 'jrʋ‑gbao ke'wlɛ, ɛ ke ‑kwie\" jrʋ‑gbao ke, ɔ 'jeɛ nyʋ jrʋ' ‑ʋʋ se dbo 'ble, 'sʋ ‑wi\" ‑mʋ muɛ 'de ɔ o ‑kle ‑ke. ");
INSERT INTO wob_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Dɛ ‑mua' ‑kwie\" ka ‑pee ɛ, ɔ jɛɛ nyʋ jrʋ' ‑ʋʋ se dbo 'ble, ‑wɛe ɔ ‑tee' ʋʋpʋ i ɔ 'na : Dɛɛ‑tɩ ao ‑te i ‑ta ‑wɛe ao se dɛ jrɛ' nʋ ‑sɩan a‑ ? ");
INSERT INTO wob_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","ʋʋ 'na : Nyɔ ‑je ‑a dbo \"nyɩ ɔ se nɩ‑. ‑Wɛe ɔ wlu 'de ʋʋ ‑pee ɔ 'na : Ao mu dbo nʋ ‑ke 'de 'ʋn o ‑kle. ");
INSERT INTO wob_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Kwie kpʋʋan 'sʋ ɛ, ‑kle' jei wlu' 'de ɔɔ' ‑gbu\" 'dei ‑tei ‑pee ɔ 'na : ‑Ɩn ‑da dbonʋʋn ‑nʋ ‑wɛe ‑ɩn ‑je ʋʋpʋ ‑kei\" ‑sa, ‑ɩn ‑tee 'de nyʋ ‑bɔɔa' de \"kpei ‑wɛe ‑ɩn ‑je nyʋ ‑kɔan nya jɛɛ‑. ");
INSERT INTO wob_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","'Sʋ nyʋ ‑teea dbo nʋa' ‑kwie\" ka a ji' ‑wɛe ɔ \"nyɩ ʋʋpʋ 'wɛijɔ due 'due do‑ do‑. ");
INSERT INTO wob_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Nyʋ ‑saa \"i ‑ʋʋ mua dbo nʋa' jia, ʋʋpʋ mɔ 'na ‑mɛ ʋʋ 'je dɛ ‑tuu\" 'je 'de‑, 'kaa ɔ \"nyɩ ʋʋpʋ 'wɛijɔ due 'due ‑ke. ");
INSERT INTO wob_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","‑Ta ʋʋa kpʋʋan 'wɛijɔ due 'due ‑nɩ ɛ, ʋʋa wluuɛ 'mii 'de ‑kle' jei ‑pee. ");
INSERT INTO wob_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","Ʋʋ 'na : Nyʋ ‑bɔɔa' de ‑nʋ, ‑ʋʋ sea 'bo dboi\" ‑kwle ɛ, ʋʋpʋ 'a ‑kei\" ke ‑aa ‑kei\" 'bɛɛ‑, 'de ‑mɛ 'kamɔ ‑apʋ mɔ sea ‑sɩan ‑sea ‑sea 'bo ‑tɛnjrʋ ‑nɛ 'ʋn. ");
INSERT INTO wob_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","'Sʋ ‑kle' jei wlu' 'de ʋʋa' due' ‑pee ɔ 'na : 'Ɩn ba, 'ɩn se ‑mii\" 'fa o, ‑ɩn ‑wɔan dbo nʋa' mu‑tɩ 'teɔ, ‑ɩn ‑ke 'ma ‑a se 'wɛijɔ due 'a wlu 'ʋn 'bɛɛ‑ 'de ‑sɔn' 'dii ? ");
INSERT INTO wob_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Dɛ ‑ɛ ‑nɩa ‑ma ‑nɛ ‑kei\" ‑ɩn ‑duɛ\" 'ʋn, ‑ɩn ‑je ‑ta 'ʋn \"juɔi ‑tie\" cɛn. ‑Kei\" 'ɩn ‑sa ‑ʋn ‑ta ɛmɛ 'ma mu nyɔ ‑bɔɔa' de ‑saa' ‑ke. ");
INSERT INTO wob_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","'Mɔ ‑ble 'ma 'wɛi, dɛ 'ɩn nɩa \"i, ɛmɛ 'ɩn nʋʋɛ 'ʋn. ‑Aee' 'dɛ 'ɩn nmɔa 'di wɔn 'de nyʋ ‑pee ɛmɛ ‑ɛɛ \"jriɛ saʋn ‑ma ‑gbʋʋn' 'ʋn jaa ? ");
INSERT INTO wob_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","‑Wɛe Sesi poɛ \"kpei ɔ 'na : 'Kamɔ ɛ nɩ ‑ke, nyʋ ‑bɔɔa' de a muɛ nya kɔan', 'de nyʋ ‑kɔan nya 'je de 'bɔɔ‑. ");
INSERT INTO wob_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","‑Ta Sesi nɩɩa Selisalɛm mua' a, 'bomɔ ɔ 'daa‑ ɔɔ' klai\" nynuu ‑nɩa ‑puue 'jɔ 'sɔɔn 'ɔ 'sʋ, ‑mɛ ʋʋ nɩɛ nabʋ ja, ‑wɛe ɔ wlu 'de ʋʋpʋ ‑pee, ");
INSERT INTO wob_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","ɔ 'na : Ao po doin\" i, ‑aa muɛ Selisalɛm, 'bomɔ nyiɔ 'ɔ \"Ju 'je 'e tooɛ‑ 'de 'sraa ‑saʋn 'a klae\" o, kɛ' wɔ‑saʋn 'kwa ‑wɛe ʋʋ 'je ɔ 'mɛpee' kpʋʋn‑. ");
INSERT INTO wob_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","‑Wɛe ʋʋ 'je ɔ nyʋ ‑sea' Kea juo \"nyɩ, 'de ‑wi\" ‑mʋ 'je ɔ wlaa‑. Ʋʋ 'je ɔ klae 'ʋn kpa, 'de ʋʋ 'je ɔ 'o tu ‑kwlɩ\" kɔ, 'kaa ɔ 'je 'kmʋ de ji ‑o 'de 'wɩ 'a taan ‑nɩ 'di. ");
INSERT INTO wob_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","'Sʋ Sebede 'a \"nynuu‑ ke ʋʋ de 'kpa Sesi ‑pʋn\" ‑wɛe ʋʋ de \"sii‑ 'kɔi‑ i 'bo ɔ \"juɔi 'de ʋ ‑tee' ɔ ‑paan' i. ");
INSERT INTO wob_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Sesi 'na : Dɛ aa ‑pɔn ɛ‑ ? ʋ 'na : ‑Ɩn cɛn ɛɛ' wlu ‑tie\" 'de 'ʋn ‑pee ‑wɛe 'ma \"nynuu‑ 'sɔɔn ‑nʋ 'je i ‑te 'bo ‑ʋn ‑pʋn\" 'de ‑ma 'beɔdɛ 'ʋn, due' 'je 'e ‑ma dian o ‑te', due' 'je 'e ‑ma kʋan o ‑te'. ");
INSERT INTO wob_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","'De Sesi 'na : Dɛ aoa ‑teea i ao se ɛ juo‑, \"kaenmɔ 'ɔ \"pɛ 'ɩn 'jea 'na, ao 'bɛɛ‑ ɛɛ' 'naa' 'mɛɛ ? 'Sʋ ʋʋ 'na : ‑A ‑beeɛ'. ");
INSERT INTO wob_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Sesi 'na : Tɔ' ‑o, ao 'bɛɛ‑ 'ma \"kaenmɔ 'ɔ \"pɛ 'naa' 'mɛ ‑cɛɛn'‑, 'kaa dɛ ‑jɛ ‑nɩa 'e 'ma kʋan o ke dian o 'a ‑tea 'a ‑tɩ' ‑mɛ se 'de 'ʋn 'kwa nɩ‑, ɩa' ‑teɩn tu ‑teeɛ nyʋ ʋʋa ‑tɩ' 'ɩn \"Bo nʋ ɩ dɛ 'ɛ ‑tea'. ");
INSERT INTO wob_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Klai\" nynuu ‑puue ‑sia 'o 'wɔan wlu ‑nɛ 'sʋ ɛ, ʋʋ 'kpa 'cɛn, ʋʋ 'bleeɛ de'dinynu 'sɔɔn ‑nʋ 'dii. ");
INSERT INTO wob_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","'Sʋ Sesi 'da ʋʋ ‑wee' \"klein 'mɛ, ‑wɛe ɔ 'na : Ao 'jee, nyʋ ‑tea nyʋ \"jru kpɔ' i ɛ, ʋʋa criɛ nyʋ bʋ ‑sɔn i ‑wɛe nyʋ klae\" ‑wi\" ‑mʋ a to ʋʋpʋ 'a \"ikmaa' 'de nyʋ \"kpei. ");
INSERT INTO wob_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","'Kaa ɛ 'bo kan' nɩɛ 'bo aopʋ \"klu. ‑Bo aoa' due' nɩɛ \"i ɔ 'je klaa\" nɩ ɛ, ‑mɛ ɔ nʋʋ aopʋ \"juɔi. ");
INSERT INTO wob_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","'De ‑bo aoa' due' nɩɛ \"i ɔ 'je aoa' nya nɩ ɛ, ‑mɛ ɔ 'je ɔɔ' ‑cɛi\" 'piie‑ ‑wɛe ɔ 'je aoa' kʋɔn nɩ‑. ");
INSERT INTO wob_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","'Kamɔ nyiɔ 'ɔ \"Ju nʋ jisʋn. Ɔ se ji 'de nyʋ 'je ɔ \"juɔi nʋʋ‑, 'kaa ɔ ji' ‑wɛe ɔmɔ 'je nyʋ \"juɔi nʋʋ 'de ɔ 'je ɔɔ' 'kmʋ 'e to ‑wɛe ɛ 'je nyʋ ‑tuu\"‑tuu seie‑. ");
INSERT INTO wob_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","‑Ta ʋʋa 'wlʋʋa 'o Seriko ɛ, nyʋ ‑tuu\"‑tuu ‑bla' 'bo Sesi 'de. ");
INSERT INTO wob_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Ʋʋa ‑gbʋan 'e mu 'sʋ ɛ, \"jri 'a waʋn 'sɔɔn ‑te i 'bo je doun\". Ka Sesi a ‑sia, ʋʋ 'wɔɩn 'sʋ ɛ, ʋʋ ‑teɛ \"wɔɔa' ‑pʋn\" ʋʋ 'na : ‑Aa 'blei, Dafidɩ 'a \"Ju, ‑ɩn ‑je ‑aa wɛe‑ ! ");
INSERT INTO wob_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Nyʋ ‑tuu\"‑tuu a 'kaa‑ ʋʋpʋ 'ʋn 'ɛ, ʋʋ 'na : Ao \"mu wɔn ! 'Kaa ʋʋa kpa wlu \"jɛi ke'wlɛ ʋʋa ‑tuɛ\" \"kpei ʋʋ 'na : ‑Aa 'blei, Dafidɩ 'a \"Ju, ‑ɩn ‑je ‑aa wɛe‑ ! ");
INSERT INTO wob_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","'Sʋ Sesi nyna i, ɔ 'da ʋʋpʋ 'mɛ ‑wɛe ɔ ‑tee' ʋʋpʋ i, ɔ 'na : Dɛ aoa ‑pɔn 'ɩn 'je ao \"jrii nʋ ɛ‑ ? ");
INSERT INTO wob_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","ʋʋ 'na : ‑Aa 'blei, ‑ɩn nʋɛ ‑aa \"jri 'je 'bai‑. ");
INSERT INTO wob_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Ʋʋa' wɛe‑ nʋ Sesi 'mɛ, 'sʋ ɔ 'tɔɛn ʋʋpʋ 'a \"jri i. 'Bo ɛ \"sri nyʋ ‑nʋ je i 'jea' ‑pʋn\" ‑te, ʋʋ je 'o Sesi 'de bla. ");
INSERT INTO wob_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","‑Ta ʋʋa \"kʋʋan Selisalɛm i 'sʋ ɛ, ʋʋ nyniɛ 'o Befase ‑kwlɔ ‑pʋn\", ɛ nɩɛ 'o olifɩ‑crʋ \"kpei. 'Sʋ Sesi dboɛ ɔɔ' klai\" nynuu 'a 'sɔɔn nya. ");
INSERT INTO wob_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","Ɔ ‑tu\" ʋʋpʋ wlu ɔ 'na : Ao mu 'o ‑kwlɔ ‑nɩa 'de nya ‑ta 'di, aoa muɛ 'o soofae ju jɛɛa', ɛ ke ɛ de 'je ‑tadue ‑nɩ, ɩ 'je imɔɔɛ‑. Ao kain ka ɩ nɩa 'sɔɔn i ‑wɛe ao 'jɩ 'ʋn ja‑. ");
INSERT INTO wob_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","‑Bo nyɔ ‑tee' aopʋ dɛ jrɛ' i ɛ, ‑mɛ ao 'na : Tʋ\"bo 'na ‑a kpɩ. 'Sʋ ɔɔ mu ɩ \"i \"taia', ɩ ke ao 'je ji kaan. ");
INSERT INTO wob_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Ka wlu Kea 'a wlu 'kwajaai 'tmʋa tɛin\" ɛ nʋa 'o nynisʋn, 'ka ‑nao : ");
INSERT INTO wob_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","Ɔ wlu' ka 'de‑, ɔ 'naa : Ao wlu 'de Selisalɛm‑kwlɔ ‑pee, ao 'na : ‑Ɩn ‑gbʋn 'nɔ, ‑ma 'beɔ ɔ jiɛ ‑ʋn ‑pee, 'diwɔnmɔa' mɛ ‑ji\" 'de ɔ 'ʋn ‑wɛe ɔ 'ja 'o soofae'‑ \"kpei, ɔ 'ja 'o soofae ju \"kpei. ");
INSERT INTO wob_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Klai\" nynuu mu' ‑cɛɛn'‑, ka Sesi \"sia 'nynɩ 'ka ʋʋ nʋ. ");
INSERT INTO wob_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Ʋʋ ja soofae nynɔ ke 'ɛɛ \"ju ke, ‑wɛe ʋʋ sro ʋʋa' 'ʋnpaadɩ 'bo ɩ \"kpei ‑wɛe ʋʋ ‑te ɔ 'o mu. ");
INSERT INTO wob_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Nyʋ ‑tuu\"‑tuu sroɛ ʋʋa' 'ʋnpaadɩ ‑je woi, jrʋ' a cɛn ‑poa\" wɩn ‑wɛe ʋʋa sro ɩ ‑je woi. ");
INSERT INTO wob_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Nyʋ ‑kɔan 'e Sesi \"juɔi ke nyʋ ‑kɔan 'de ɔ 'de ke ʋʋa wee ɔ o, ʋʋ 'na : ‑Kai\" 'matɛ Dafidɩ 'a \"Ju, \"diwan kpʋn nyɔ ‑ɔ jia 'de Tʋ\"bo 'a 'nynɩ 'ʋn ɛ, ‑kai\" 'matɛ 'de jaʋn 'di ! ");
INSERT INTO wob_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","‑Ta Sesi paa 'o Selisalɛm ɛ, ‑kwlɔ ‑wee' ‑suua i 'sʋ ʋʋa ‑teeɛ' ba i 'de ɔɔ' ‑tɩ' 'ʋn, ʋʋ 'na : \"Ju ‑nɔ ‑mɔ 'ɔ 'nynɩ wɛ‑ ‑sɩan ka a‑ ? ");
INSERT INTO wob_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","'Sʋ nyʋ ‑tuu\"‑tuu ke Sesi na ʋʋ 'na : Sesi ‑o, Kea 'a wlu 'kwajaai ‑wlʋa Nasarɛtɩ 'de Galile ɛ. ");
INSERT INTO wob_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Sesi pa 'de Kea ‑gbu klaa\" 'di ‑wɛe nyʋ \"klein ‑ʋʋa plea 'sraadɩ ke nyʋ ‑ʋʋa ‑tɩan' dɩ ɔ nʋ ʋʋpʋ i. Ɔ ‑gba' nyʋ ‑a pooa 'wɛi fai\" 'a 'tablʋ ja ‑wɛe ɔ poo nyʋ ‑a plea \"pai 'a \"kpɩ‑tɩ 'kwlɛ i. ");
INSERT INTO wob_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","‑Wɛe ɔ wlu ka 'de ʋʋ ‑pee ɔ 'na : Wlu ‑ɛ ‑crɩɩa' 'de Kea 'a 'sbɛ 'di ɛ 'naa : 'Ma ‑gbu\" a muɛ Kea bae‑gbu nɩa', 'kaa aomɔ nʋɛ \"jri‑gbu 'ʋn. ");
INSERT INTO wob_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","\"Jri 'a waʋn o, 'tooʋn 'kpɔ ‑pʋn\" ‑wɛe ɔ 'bɔɔ‑ ʋʋpʋ 'a 'wɛ‑. ");
INSERT INTO wob_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","'Kaa 'sraa ‑saʋn 'a klae\" o kɛ' wɔ‑saʋn 'kpa 'cɛn 'de nyʋ'pʋʋjrii' Sesi nʋa 'a ‑tɩ' 'ʋn. Ʋʋ 'kpa 'cɛn ke'wlɛ 'de \"nynumɩɩ\" ‑wlua 'de Kea ‑gbu klaa\" 'di ‑wɛe ‑ʋʋ ‑na : ‑Kai\" 'matɛ Dafidɩ 'a \"Ju. ");
INSERT INTO wob_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","‑Wɛe ʋʋ wlu 'de Sesi ‑pee ʋʋ 'na : Dɩ ʋʋa 'tmʋa ‑ta ‑ma ‑wɔɩn' 'mɛɛ ? 'De Sesi 'na : Ɩɩn, wlu ‑crɩɩa' 'de Kea 'a 'sbɛ 'di ɛ 'na : ‑Ɩn ‑sa \"nynupliiɛ ke \"nynumɩɩ\" wlu 'di ʋʋa jea ‑ma 'nynɩ \"i 'bɛɛ‑. ");
INSERT INTO wob_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Sesi 'tmʋa wlu ‑nɛ 'sʋ ɛ, ɔ 'wlʋ 'o ‑kwlɔ 'mɛ ‑wɛe ɔ mu Betani 'pɛɛan'. ");
INSERT INTO wob_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","‑Klae\" pɛɛn ‑ta Sesi ke ɔɔ' klai\" nynuu a mua Selisalɛm de 'sʋ, 'mɩɩɛ‑ ɛɛ nʋɔ. ");
INSERT INTO wob_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Ɔ 'jeɛ fikɩtu 'bo ‑je doʋn\", ɔ 'kpɛ ‑pʋn\", 'kaa wɩn 'a 'sʋ mɩ ɔ jɛɛ 'de ɛ ja, ‑wɛe ɔ wlu 'de ɛ ‑pee ɔ 'na : 'Jɔ 'bo 'de ɛ ja nɩɛ la 'bode ! 'Bomɔ ɛ \"sri, fikɩtu ‑nɛ je 'soɛ jɛ. ");
INSERT INTO wob_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Klai\" nynuu 'je ɛ 'sʋ tai' \"maa ʋʋpʋ 'mɛ, 'sʋ ʋʋ 'na : Dɛwɛ‑, fikɩtu ‑nɛ \"sri 'o 'ɛ, ɛ je 'soɛ jɛɛ ? ");
INSERT INTO wob_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","'Bomɔ Sesi wluu ʋʋpʋ ‑pee ɔ 'na : 'Ma 'tmʋʋɛ aopʋ tɔ' ‑tɩ, ‑bo ao ‑te' 'ʋn ‑kwlɩ\" ‑wɛe ao se tɔ' iplee ɛ, ‑mɛ ao se dɛ nʋa fikɩtu ‑nɛ \"jrii 'a 'sʋ nʋ ɩ, 'kaa ao 'beeɛ' ao 'je crʋ ‑nɛ ‑pee wlu, ao 'je nʋ : Ɛ 'wlʋ ‑ta, ɛ 'je 'e 'tɔniɛ wɔn 'kpa ! ‑Wɛe ɛɛ' dɛ tu 'je nʋʋɛ. ");
INSERT INTO wob_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Dɛ \"o dɛ aoa mua i ‑teea' 'de Kea ‑kwlɩ\" ‑tea' ke baea' 'ʋn ɛ, aoa muɛ 'jea' see. ");
INSERT INTO wob_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Sesi pa 'e Kea ‑gbu klaa\" 'di. ‑Ta ɔ nɩa nyʋ dɛ tɔɔa' a, 'bomɔ 'sraa ‑saʋn 'a klae\" ke nyʋ‑cɔɩn' ‑wi\" jii‑, ‑wɛe ʋʋ ‑tee' ɔ i, ʋʋ 'na : ‑Ta ka ‑ɩn ‑sa dɩ ‑ma nʋa 'a kpɩ ‑ɛ ? 'De nyɔ ‑tuɩ\" ‑ʋn wɔn ɛ‑ ? ");
INSERT INTO wob_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","'Sʋ Sesi ‑sɛ \"kpei 'de ʋʋpʋ ‑pee ɔ 'na : 'Mɔ ‑ke ɛ, 'ma jiɛ aopʋ ‑tɩ' due' koʋn ‑gbai' i ‑teea'. ‑Bo ao ‑sɛ \"kpei ɛ, ‑wɛe ‑ta 'ma \"ikmaa' 'wlʋa 'de 'ma nʋa dɩ ‑nɩ ɛ, 'de 'ɩn 'je 'o 'a 'nynɩ \"si. ");
INSERT INTO wob_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Nyɔ ‑dbo' San nyʋ \"ni \"jru poa' a‑ ? Ɛ Kea ‑ae, ‑aee' nyiɔpʋ‑ ? ʋʋ ‑teɛ wlua' ‑pʋn\" 'bo ʋʋa' 'sʋ 'nynɩ, ʋʋ 'na : ‑Bo ‑a ‑na Kea ‑dbo' ɔ ɛ, ‑mɛ ɔɔ muɛ ‑a i ‑teea' dɛɛ‑tɩ ao se ɔɔ' ‑tɩ' tɔ' 'ʋn 'je 'ja a‑ ? ");
INSERT INTO wob_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","'De ‑bo ‑a ‑na nyiɔpʋ ‑dbo ɔ ɛ, ‑mɛ ʋʋa muɛ ‑a 'cɛn i 'kpaa', dɛ‑nʋɛ' nyʋ ‑wee' \"klein a naa tɔ' i ʋʋ 'na : San nɩɛ Kea 'a wlu 'kwajaai 'a ‑cɛ\" 'kpa ‑o. ");
INSERT INTO wob_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","'Sʋ ʋʋ wlu' 'e Sesi o, ʋʋ 'na : ‑A se ɛ juo‑. 'Bomɔ ɔmɔ wlu 'de ʋʋpʋ o ‑ke, ɔ 'na : ‑ɛɛ, 'mɔ ‑ke ɛ, ‑ta 'ma \"ikmaa' 'wlʋa ‑wɛe 'ma nʋa dɩ ‑nɩ ɛ, 'ɩn se 'o 'a 'nynɩ \"si i. ");
INSERT INTO wob_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Ao ‑gbʋn 'nɔ, ka aoa naa dɛ ‑nɛ tɔ' i ɛ‑ ? \"Ju due' 'bleɛ \"nynuu‑ 'sɔɔn. Ɔ wluɛ \"i‑saa' ‑nɔ ‑pee ɔ 'na : 'Ma \"ju, ‑ɩn mu dbo nʋ ‑sɩan 'de 'ɩn o ‑kle. ");
INSERT INTO wob_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","'Sʋ ɔ 'na : 'Ɩn se 'wɔn. 'Kaa ɔ fɔan 'o ‑pai 'sʋ ɔɔ' pɛe se ka 'je, ɔ \"dua dɩ 'ʋn 'sʋ ɔ muɛ 'e ‑kle. ");
INSERT INTO wob_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","'Bo ‑mɛ 'de ɛ, dɛ due' ‑nɛ mɛ ɔ 'tmʋ 'de \"ju ‑sia 'o ‑pee. ‑Mɔ 'na : 'Ɩn 'wɔɔn mu ‑tɩ 'mɛ o, 'ɩn \"bo ! 'Kaa ɔ se mu. ");
INSERT INTO wob_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Ka aoa naa tɔ' i ɛ‑ ? 'Bo \"nynuu‑ 'sɔɔn ‑nʋ \"klu 'ee, ‑ɔ nʋ ɔ \"bo 'a 'tʋn nʋ‑tɩ ɛ‑ ? ʋʋ 'na : ‑Jɔ ‑saa \"i ‑o. 'De Sesi 'na : 'Ma 'tmʋʋɛ aopʋ tɔ' ‑tɩ, 'wɛi‑sanyʋ ke ‑kwlɔi ‑tenynʋkpae' a muɛ aopʋ \"juɔi ‑sia' 'de Kea 'a 'kmʋ dee‑ 'ʋn. ");
INSERT INTO wob_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Dɛɛ‑tɩ 'ɩn 'da kan' a, ɛmɛ ‑nɩ, San Batisɩ jia ‑wɛe ɔ tɔɔ aopʋ \"isrɛ‑je ɛ, ao se ɔɔ' ‑tɩ' tɔ' 'ʋn 'je, 'kaa ‑dɛɩnpo' ‑saʋn o, ‑kwlɔi ‑tenynʋkpae' 'je ɔɔ' ‑tɩ' tɔ' 'ʋn 'ɛ. Aomɔ 'jea ‑mɛ \"jriɛ‑ ke'wlɛ ɛ, ao se ɔɔ' wlu tɔ' 'ʋn 'je ao se aoa' dɛsaʋn \"i juo‑. ");
INSERT INTO wob_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Sesi 'na : Ao po doin\" i, 'ma jiɛ \"ipoo‑tɩ jrɛ' 'tmʋa' : \"Ju due' mɔ ‑dba rɛsɛn ‑kle, ɔ poɛ ‑wee' \"klein ‑pin 'dei, ɔ \"blu ‑ta nyʋ 'jea rɛsɛn 'ʋn \"nmuu ɛ, ɔ po ‑gbei\" ‑gbu due', ‑wɛe ɔ siɛ ‑busan dinyʋ o, 'de ɔ mu 'dʋʋa'. ");
INSERT INTO wob_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Rɛsɛn' ‑sa nɔ\" nynia 'sʋ ɔ dboɛ ɔɔ' dbonʋʋn 'de ‑busan dinyʋ o ‑wɛe ʋʋ 'je ɔɔ' ‑nɛ rɛsɛn' \"nyɩ. ");
INSERT INTO wob_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","'Kaa ‑busan dinyʋ kpʋn ɔɔ' dbonʋʋn ‑nʋ 'mɛ, ʋʋ bla due' ʋʋ 'dba due' ‑wɛe ʋʋ tbaa taan ‑nɔ \"soi i. ");
INSERT INTO wob_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","‑Kle' jei dboɛ ɔɔ' dbonʋʋn ‑tuu\"‑tuu jrʋ' ke'wlɛ, ‑wi\" ‑mʋ ‑tiɛi\" ʋʋ je ‑jʋ ‑nɩa tɛin\" ‑sii. 'Kaa dɛ due' ‑nɛ mɛ ‑busan dinyʋ nʋ ʋʋpʋ \"jrii. ");
INSERT INTO wob_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Ɛɛ 'bɔɔa 'o mu ɛ, ɔ dboɛ ɔɔ' \"ju 'de ʋʋpʋ o, ɔ 'na ʋʋa muɛ 'ma \"ju ‑mɔ 'ɔ ni' ‑tea' dɛwɛ‑jɛ. ");
INSERT INTO wob_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","'Kaa ‑busan dinyʋ 'jeea ɔɔ' \"ju \"jriɛ‑, 'sʋ ʋʋ 'tmʋʋɛ ba, ʋʋ 'na : \"Ju ‑ɔ ‑jea ‑kle' ‑nɛ 'ɛ jei 'kpa 'de nya, ɔ ka, ao ji ‑a ‑je ɔ 'dba, ‑wɛe ‑kle' 'je ‑aa dɛ nɩ‑. ");
INSERT INTO wob_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Ʋʋ kpʋɔn', ʋʋ ‑sɔ 'o ‑kle', ‑wɛe ʋʋ 'dbɔ. ");
INSERT INTO wob_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Ɛ nɩa 'mʋa‑ la 'ee, ‑bo ‑kle' jei ji 'ee, ka ɔ 'je ‑busan' dinyʋ ‑nʋ 'a ‑tɩ' nʋ ɛ‑ ? Dɛ aoa naa tɔ' i ɛ‑ ? ");
INSERT INTO wob_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Ʋʋ 'na : ɔɔ muɛ 'diwɔnyniʋn ‑nʋ i‑saa' ‑wɛe ɔ 'je ɔɔ' ‑kle' ‑busan dinyʋ jrʋ' \"nyɩ. ‑Wi\" ‑mʋ a muɛ ɔɔ' ‑nɛ rɛsɛn \"nyɩa' ɛɛ' ‑sa nɔ\". ");
INSERT INTO wob_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","‑Wɛe Sesi wlu 'de ʋʋpʋ o ɔ 'na : Wlu ‑crɩɩa 'de Kea 'a 'sbɛ 'di ao se ɛ 'dii nʋ duee' ? ɛɛ' wlu tu 'naa : \"Soukpo ‑gbu\"poʋn pooa sʋn i ɛ, ɛmɛ ‑snɛɛ \"soukpo ‑cɛɛn' 'ʋn. Tʋ\"bo mɔ ‑nʋ' ɛɛ' dɛ tu ‑wɛe ‑ɛ ‑nmɔ ‑a \"jri 'dei. ");
INSERT INTO wob_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","'De Sesi poɛ \"kpei ka ɔ 'na : Ɛmɛ ‑tɩ 'ma 'tmʋʋ aopʋ, Kea 'a 'beɔdɛ ɛ muɛ aopʋ 'kwa 'wlʋa' ‑wɛe nyʋ ka Kea \"sia 'nynɩ ‑ʋʋa nʋa kan' a, ɛ 'je ɛ ʋʋpʋ \"nyɩ. ");
INSERT INTO wob_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Nyɔ ‑ka i 'bo ɛɛ' \"soukpo tu \"kpei ɛ, ɔɔ muɛ i ‑craa', 'de nyɔ ‑ɔ \"kpei ɛ bluua a, ɛɛ muɛ ɔ iwaa'. ");
INSERT INTO wob_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","'Sraa ‑saʋn 'a klae\" ke Fariseɛn‑wi\" 'wɔan \"ipoo‑tɩ ‑nɩ 'sʋ ɛ, ʋʋ 'je kan' 'mɛ ka Sesi a \"sia ʋʋpʋ 'a 'nynɩ ɛ. ");
INSERT INTO wob_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","'Sʋ ʋʋa ‑pɔn Sesi 'a kpʋn ‑kɔ i, 'kaa ʋʋa plee nyʋ ‑ʋʋa ‑daa' Sesi Kea 'a wlu 'kwajaai 'mɛ. ");
INSERT INTO wob_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Sesi \"dua wlu 'ʋn ke'wlɛ ɛ, ɔ pooɛ ‑tɩ' \"i 'de nyʋ ‑a poa ɔɔ' wlu doun\" o ‑pee, ɔ 'na : ");
INSERT INTO wob_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","Dɛ ‑ɛ ‑ke Kea 'a 'beɔdɛ ‑nɩa 'e jaʋn 'di ‑kɔɔa\"i, ɛ ka : 'Beɔ due' mɔ ‑tu\" ɔɔ' \"ju 'a 'nynɔ 'ble ‑kɔ. ");
INSERT INTO wob_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Ɔ dboɛ ɔɔ' dbonʋʋn nyʋ ɔ 'tmʋʋa see 'daa', 'kaa ʋʋ se ji ‑tɩ 'wɔɔn‑. ");
INSERT INTO wob_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Ɔ dboɛ ɔɔ' dbonʋʋn jrʋ' ke'wlɛ, ‑wɛe ɔ ‑tu\" ʋʋpʋ wlu 'kwa, ɔ 'na : Ao wlu 'e nyʋ 'ɩn 'da ‑pee, 'ɩn nmae ‑kɔ' dɩ ‑wee' \"klein 'mɛ, 'ɩn 'dba 'ma bli' ke 'ma 'ʋn waa ‑nɔ\" dɩ ‑wee' 'mɛ, dɩ ‑wee' ‑kwɛi\", ao ji ‑kɔ' ‑sɔn. ");
INSERT INTO wob_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","'Kaa nyʋ ɔ 'da 'mʋa‑ se ɔɔ' 'dawlu doin\" o po. ‑Ta ‑nʋa jrɔ' 'tʋn 'bo ɔ mu. Jrɔ' muɛ 'de ɔ o ‑kle', jrɔ' muɛ ɔɔ' 'dɔɔ poa'. ");
INSERT INTO wob_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Jrʋ' kpʋn ɔɔ' dbonʋʋn ‑nʋ 'mɛ, ‑wɛe ʋʋ nʋ blati 'a 'sʋ, ʋʋ 'dba ʋʋpʋ. ");
INSERT INTO wob_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","'Beɔ 'kpa 'cɛn 'sʋ ɔ dboɛ ɔɔ' \"soa‑wi\" ‑wɛe ʋʋ 'dba \"ku 'dbaʋn ‑nʋ 'de ʋʋ po ʋʋa' ‑kwlɔ \"jri. ");
INSERT INTO wob_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","'Sʋ ɔ 'tmʋɛ ɔɔ' dbonʋʋn, ɔ 'na : 'Ma ‑kɔ' dɩ ji bae' ‑wɛ‑, 'kaa nyʋ 'ɩn 'da 'de ɛ, ʋʋ se ɩa' di ka nɩ‑. ");
INSERT INTO wob_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Ao mu ‑je woi nyʋ \"klein aoa mua jɛɛa' a, ao 'da ʋʋpʋ ‑wɛe ʋʋ 'je 'ma ‑kɔ' ‑sɔn ji. ");
INSERT INTO wob_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Ɔɔ' dbonʋʋn mu ‑je woi 'mɛ ‑cɛɛn'‑, ‑wɛe nyʋ \"klein ʋʋ jɛɛa ʋʋ 'kɩɩn‑ ʋʋpʋ \"jrui, 'diwɔnyniʋn o, 'diwɔnmɔʋn o, 'sʋ nyiɔ \"ji ‑gbu\" 'mɛ. ");
INSERT INTO wob_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","'Beɔ pa ‑gbu\" ɔ ‑gbʋʋan' nyʋ \"kpei, 'sʋ ɔ 'jeɛ \"ju due' ‑ɔ se ‑kɔ' bai\" 'ʋnpaa‑. ");
INSERT INTO wob_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","'Sʋ ɔ wlu ɔ ‑pee ɔ 'na : 'Ɩn ba, ka ‑mɔ nʋ ‑gbu\" pasʋn ‑wɛe ‑ɩn se ‑kɔ' bai\" 'ʋnpaa‑ ? 'Sʋ \"ju ‑nɔ 'ɔ wɔn \"muu', dɛ ɔ 'jea 'tmʋ ɛ se nɩ‑. ");
INSERT INTO wob_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","‑Wɛe 'beɔ 'tmʋʋ ɔɔ' dbonʋʋn, ɔ 'na : Ao san ɔɔ' bɩ ke sɩn ke‑ ‑wɛe ao 'je ɔ 'de \"kpae' ‑fiie\"‑ 'de kwie 'ʋn 'nɔ 'nynɩ \"idiia' ke ‑fɩn\" 'a nɩa, ");
INSERT INTO wob_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","dɛ‑nʋɛ' nyʋ ‑tuu\"‑tuu 'daa', 'kaa nyʋ ‑jea 'o ‑saa se \"i ‑tie. ");
INSERT INTO wob_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","'Sʋ Fariseɛn‑wi\" muɛ \"sɩan ‑wɛe ka ʋʋ 'jea nʋ 'de ʋʋ 'jea Sesi wlu 'a \"klɛ bʋ 'dei ‑te' ɛ, ‑wɛe ʋʋ 'je ɛ poo‑. ");
INSERT INTO wob_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","'Sʋ ʋʋ dboɛ ʋʋa' klai\" nynuu 'a jrʋ' ke Erodɩ 'a ‑nɩ 'cɛ 'de Sesi o ‑wɛe ʋʋ 'na : Nyʋ dɛtɔɔi, ‑a ‑je kan' 'mɛ, ‑ma ‑tmʋɛ tɔ' ‑tɩ 'a 'sʋ, ‑wɛe ‑ma tɔɔ nyʋ Kea 'a ‑jeblʋ 'a ‑cɛ\" 'kpa, nyɔ jrɔ' 'ɔ faʋn 'a nʋ ‑ʋn, dɛ‑nʋɛ' ‑maa' ‑gbʋn nyiɔ 'ɔ 'bɛsʋn ja. ");
INSERT INTO wob_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Dɛ ‑ma naa tɔ' i 'de dɛ ‑nɛ 'ɛ ‑tɩ' 'ʋn ɛ, ‑ɩn ‑tmʋ ɛ 'de ‑a ‑pee. ‑A ‑bɛɛ' ‑a ‑je ‑dɛɩnpo' ‑sa ‑a ‑je Sesaa \"nyɩɩ ? ‑Aee' ‑a ‑bo ɛ ‑saa ? ");
INSERT INTO wob_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Ka ‑cruun\" nɩa 'de ʋʋ pɛe o Sesi 'jea kan' 'sʋ ɛ, ɔ 'na : Ao \"jridepooʋn, dɛɛ‑tɩ aoa ‑te' 'ʋn wlu 'a \"klɛ bʋ 'dei ɛ‑ ? ");
INSERT INTO wob_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Ao to 'ʋn 'wɛijɔ due' \"i kea', 'ɩn 'je ɛ 'je. 'Sʋ ʋʋ to ɔ 'wɛijɔ due' \"i. ");
INSERT INTO wob_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","‑Wɛe Sesi ‑tee' ʋʋpʋ i, ɔ 'na : Nyɔ ‑ble \"jru ke 'nynɩ ‑crɩɩa' ‑ta a‑ ? ");
INSERT INTO wob_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Ʋʋ 'na : ɛ Sesaa ‑o. 'Sʋ ɔ wlu' 'de ʋʋpʋ ‑pee ɔ 'na : Dɛ ‑nɩa 'blʋajei 'a dɛ ao \"nyɩ ɛ 'blʋajei, ‑wɛe dɛ ‑nɩa Kea 'a dɛ ao 'je ɛ Kea \"nyɩ. ");
INSERT INTO wob_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Ʋʋ 'wɔan wlu ‑nɛ 'sʋ tai' \"maa ʋʋpʋ 'mɛ, ʋʋ \"tai‑ ɔ \"i wɔɔ‑, 'sʋ ʋʋ mu'. ");
INSERT INTO wob_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","'De ɛɛ' 'wɩ tu 'di mɔ Sadiseɛn‑wi\" ‑ʋʋ sea \"kunyɩɔ' sɔn‑tɩ tɔ' 'ʋn 'je 'kpaa' Sesi ‑pʋn\". ‑Wɛe ʋʋ ‑tee' ɔ i ka ");
INSERT INTO wob_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","ʋʋ 'na : Nyʋ dɛtɔɔi, dɛ Moisɩ 'a kɛ' 'crɩa, ɛ ka : ‑Bo \"junmɔu 'ble 'nynɔ ‑wɛe ɔ ke ʋʋ se \"ju 'wlʋ 'sʋ ɔ 'mɛ ɛ, ‑mɛ ɔɔ' de'di \"duo ‑tiɔn\" 'nynɔ ‑nʋ 'ʋn ‑wɛe ɔ ke ʋ 'je \"nynuu‑ 'wlʋ 'de ɔɔ' ‑fɛin' ‑mɛa 'a 'nynɩ 'ʋn. ");
INSERT INTO wob_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","'Kaa de'dinmai ‑mɛ\" 'sɔn ‑nɩ 'e ‑a \"klu, ʋʋa' ‑jɔ ‑saa \"i 'blea 'nynɔ ɔ ke ʋ se \"ju 'ble 'sʋ ɔ je 'mɛ. Ɔɔ' ‑tiɔn\" 'nynɔ siɛ ɔɔ' de'di due' 'kwa. ");
INSERT INTO wob_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Dɛ due' ‑nɛ mɛ ‑nʋʋɛ ʋʋa' 'sɔɔn ‑nɔ ke taan ‑nɔ \"jrii, 'sʋ ka ʋʋ nɩa ‑mɛ\" 'sɔn ʋʋ ‑wee' ‑kwɛ‑ \"jrii. ");
INSERT INTO wob_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Ʋʋ ‑wee' \"klein 'mɛa 'sʋ ɛ, 'nynɔkpao' ‑nʋ 'mɛɛ ‑ke. ");
INSERT INTO wob_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","'Wɩ ‑ɛ 'di nyʋ ‑mɛa a mua 'kmʋ de jia' 'ee, nyɔ 'nynɔkpao' ‑nʋ 'je \"bli \"ti 'bo nyʋ ‑mɛ\" 'sɔn ‑nʋ \"klu ‑gblein' ɛ‑ ? Dɛ‑nʋɛ' ʋ jiiɛ ʋʋ ‑wee' \"klein 'kwai. ");
INSERT INTO wob_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","'Bomɔ Sesi wluu 'de ʋʋ ‑pee, ɔ 'na : Aoa pooɛ aoa' ‑cɛ\" 'srɛ i, dɛ‑nʋɛ' aoa' 'wɔn dɩ ‑crɩɩa ke Kea 'a \"ikmaa' 'mii. ");
INSERT INTO wob_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","‑Sɔntɩ 'mɛʋn a mua 'kmʋ de jia' a, ‑mɛ \"nynunmai ke 'nynʋkpae'a ba \"bli \"tia' ‑kwɛ', ka Kea 'a \"soa‑wi\" ‑nɩa 'de jaʋn 'di nɩa, 'kamɔ ʋʋa mu nɩa'. ");
INSERT INTO wob_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Dɛ ‑jɛ ‑tua\" 'mɛʋn 'a 'kmʋ deji ‑tɩ ɛ, dɛ Kea 'tmʋa 'de ɛɛ' ‑tɩ' 'ʋn ɛ, ao se ɛ 'dii nʋʋ ? ɛ 'naa : ");
INSERT INTO wob_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","'Mɔ ‑nɩ Ablaam 'a Kea, 'mɔ ‑nɩ Isaakɩ 'a Kea, 'mɔ ‑nɩ Sakɔbʋ 'a Kea. ‑Bo ɛ 'da kan' a, ‑mɛ Kea nɩɛ nyʋ ‑nɩa 'kmʋ 'a Kea ‑o, ɛ se 'mɛʋn 'a Kea nɩ. ");
INSERT INTO wob_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Tai' \"maa nyʋ \"klein ‑poa' wlu ‑nɩa 'mʋa‑ doin\" o 'mɛ 'de ɔɔ' nyʋ dɛtɔɔsʋn 'ʋn. ");
INSERT INTO wob_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Fariseɛn‑wi\" 'wɔan ka Sesi \"mua Sadiseɛn‑wi\" 'a wɔn 'sʋ ɛ, ʋʋ 'kɩɩɛn \"jrui. ");
INSERT INTO wob_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","'Sʋ kɛ' wɔ‑sai due' ‑nɩa 'de ʋʋpʋ \"klu ‑nɩɛi\" ɔ 'je Sesi wlu 'a \"klɛ bʋ 'dei ‑te' ɔmɔ ‑tee' ɔ i ka, ");
INSERT INTO wob_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","‑ɔ ‑na : Nyʋ dɛtɔɔi, Kea 'a kɛ'ɛ \"jru o jɔ 'de ɛ‑ ? ");
INSERT INTO wob_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Sesi 'na : ‑Ɩn ‑je ‑ma Tʋ\"bo Kea 'a ‑tɩ' kma 'de ‑ma pɛe ‑wee' \"klein 'ʋn, 'de ma nyiɔ jɔ ‑wee' 'ʋn 'de ‑ma ‑tɔ' ‑wee' \"klein 'ʋn. ");
INSERT INTO wob_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Ɛmɛ ‑nɩ kɛ'ɛ \"jru o jɔ ‑ɛ ‑kɔan ‑tɩ' ɛ. ");
INSERT INTO wob_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","'De ‑jɛ ‑pooɛ 'sɔɔn ‑mɛ ka : ‑Ɩn ‑je ‑ʋn ‑ponyiɔ 'ɔ ‑tɩ' kma ka ‑ɩn ‑kma ‑ma ‑cɛ\" 'kpa 'a ‑tɩ' ɛ. ");
INSERT INTO wob_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","'De kɛ' 'sɔɔn ‑nɩ \"kpei 'bo kɛ' \"klein Moisɩ bla o, dɩ \"klein Kea 'a wlu 'kwajaaʋn 'tmʋa 'bomɔ ɩ tba. ");
INSERT INTO wob_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","‑Ta Fariseɛn‑wi\" 'kɩɩan \"jrui ɛ, 'bomɔ Sesi ‑tee' ʋʋpʋ i ka, ");
INSERT INTO wob_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","ɔ 'naa : Dɛ aoa naa tɔ' i 'de Klisɩ 'a ‑tɩ' 'ʋn ɛ‑ ? Nyɔ ‑ɔɔ \"ju ɔ nɩ ɛ‑ ? 'Sʋ ʋʋ 'na : Ɔ nɩɛ Dafidɩ 'a \"ju ‑o. ");
INSERT INTO wob_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Sesi 'na : 'De ‑mɛ ka Dafidɩ ‑mɔ nʋ ‑wɛe ‑ta Kea 'a ‑Suu po ɔ ‑je o ɔ sie nɔ\" nya ‑wɛe ɔ 'dɔɔ‑ Tʋ\"bo ɛ‑ ? Dɛɛ‑tɩ 'ɩn 'da kan' a, ɛmɛ ‑nɩ Dafidɩ wlu' ka, ɔ 'na : ");
INSERT INTO wob_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","Tʋ\"bo wlu' 'de 'ma Tʋ\"bo ‑pee ɛ 'na : ‑Ɩn ‑te i 'de 'ma dianfɔ o mamaʋ 'sʋ 'ɩn 'je ‑ma tʋnyʋ 'de ‑ʋn bʋ ‑sɔn ‑tu\". ");
INSERT INTO wob_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","‑Bo Dafidɩ ‑mɔɔ sea ɔ Tʋ\"bo 'daa‑ 'ee, ‑mɛ ka ɔ nʋ ɔɔ' \"ju nɩsʋn 'ja a‑ ? ");
INSERT INTO wob_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Dɛ ɔ ‑teea' i 'mʋa‑ nyɔ ‑je ɛ \"kpei ‑sa ɔ se nɩ‑. Dɛ ‑wlʋa 'o ɛɛ' 'wɩ tu 'di ɛ, nyɔ \"o nyɔ jrɔ' se ɔ dɛ jrɛ'ɛ i ‑tee' 'bode. ");
INSERT INTO wob_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","'Sʋ Sesi wlu' 'de nyʋ ‑gbae' ɔ 'dei ke ɔɔ' klai\" nynuu ‑pee, ");
INSERT INTO wob_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","ɔ 'na : Kɛ' wɔ‑saʋn o, Fariseɛn‑wi\" 'na ʋʋ ‑teɛ Moisɩ 'a kɛ' wɔ‑saa 'a ‑tea'. ");
INSERT INTO wob_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Dɩ \"klein ʋʋa mua ao tɔɔa' ao nʋ ɩ, 'kaa ao 'bo 'o ʋʋa' nʋʋkplɩn 'de ‑siɛ, dɛ‑nʋɛ' dɩ ʋʋpʋ a 'tmʋa, ʋʋa' nʋ ɩ. ");
INSERT INTO wob_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Ʋʋa san kwaku ‑gbɛ i keinkein ‑wɛe ʋʋa ‑teɛ' 'o nyiɔpʋ \"jru, 'kaa ʋʋa' ‑cɩɛjɔ 'ɔ blɛ \"i mɔ ‑wɛe ʋʋa' sʋn o po‑tɩ. ");
INSERT INTO wob_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Ʋʋa nʋ ʋʋa' dɩ ‑wee' 'mɛ 'bo nyʋ \"juɔi ‑wɛe nyʋ 'je ʋʋpʋ \"jriɛ‑ 'jee‑. 'De ɛɛ' ‑tɩ' 'ʋn ɛ, ʋʋa 'crɩ Kea 'a wlu 'mɛ 'bo nmiku \"kpei ‑wɛe ʋʋa blɛ \"jru, 'de ʋʋa po jrɛ' sʋn'. ʋʋa poɛ ʋʋa' \"bai 'a 'mla kpo \"i ‑wɛe ɩ ‑pee'‑ ‑wɛe nyʋ ‑wee' \"klein 'a \"jriɛ‑ 'je ɛ ‑pʋn\" nɩ‑. ");
INSERT INTO wob_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","‑Teɩn 'dɔe 'dɔe ‑nɩa ‑kɔ' ‑sɔn i ke‑ \"kpa‑tɩ ‑tea 'e nya 'de \"jrui 'kɩɩn‑gbi 'dii ɩa' 'sʋ mɩ ʋʋa ‑pɔn \"kpei ‑tea' i. ");
INSERT INTO wob_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Ʋʋa ‑pɔn nyʋ 'je ʋʋpʋ 'jewlu o po ‑ta \"o ‑ta, ‑wɛe nyʋ 'je \"jru ja jaa 'de ʋʋpʋ ‑sɔn, 'de nyʋ 'je ʋʋpʋ nyʋ dɛtɔɔʋn 'daa‑ jeejee. ");
INSERT INTO wob_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","'Kaa aopʋ mɔ ɛ, ao 'bo 'wɔɛn nyʋ 'bo ao nyʋ dɛtɔɔʋn 'daa‑, dɛ‑nʋɛ' ao nɩɛ de'dinynu ‑o, nyɔ due' koʋn ‑gbai' mɔ ‑nɩ aoa' dɛtɔɔi. ");
INSERT INTO wob_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Ao 'bo nyɔ \"o nyɔ jrɔ' \"bo 'daa‑ 'de 'blʋa‑ \"kpei, dɛ‑nʋɛ' nyɔ due' koʋn ‑gbai' ‑nɩ ao \"Bo, ɔmɔ ‑nɩ ‑jɔ ‑nɩa 'e jaʋn 'di ɛ. ");
INSERT INTO wob_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Ao 'bo 'wɔɔɛn nyʋ 'bo ao nyʋ 'bleʋn 'daa‑, dɛ‑nʋɛ' nyɔ due' koʋn ‑gbai' mɔ ‑nɩ aoa' 'blei, ɔmɔ ‑nɩ Klisɩ. ");
INSERT INTO wob_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Aoa' klaa\" mɔ ‑je aoa' dbonʋi nɩ‑. ");
INSERT INTO wob_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Nyɔ \"o nyɔ ‑kpa' ɔɔ' ‑cɛ\" \"jɛi a muɛ ‑sɔn jia', ‑wɛe nyɔ \"o nyɔ ‑jaa ɔɔ' ‑cɛ\" ja 'je \"jɛi mu. ");
INSERT INTO wob_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","Ɛ nɩɛ \"nmia‑tɩ ‑o 'de aopʋ kɛ' wɔ‑saʋn ke Fariseɛn‑wi\" 'a ‑tɩ' 'ʋn. Ao nɩɛ \"jridepooʋn, dɛ‑nʋɛ' aoa' 'wɔn nyʋ 'a pa 'de Kea 'a 'kmʋ dee‑ 'ʋn. Aoa' ‑cɛ\" 'kpa a 'wɔn aoa' ‑kwɛɛ 'emu, 'de nyʋ ‑nɩai\" ‑ʋʋ ‑jea 'e pa aoa kaan ‑wi\" ‑mʋ ‑je de. ");
INSERT INTO wob_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","Ɛ nɩɛ \"nmia‑tɩ ‑o 'de aopʋ kɛ' wɔ‑saʋn ke Fariseɛn‑wi\" 'a ‑tɩ' 'ʋn ! Ao nɩɛ \"jridepooʋn, dɛ‑nʋɛ' aoa ‑sa ‑tiɔn\"nynʋkpae' dɩ 'kwai, 'kamɔ aoa nʋ ‑mɩ 'a dɩ tu ‑wɛe baewlu \"ti 'de aopʋ 'wɔn, ‑wɛe nyʋ 'je ao dɛ 'dɔenʋʋn 'daa‑. 'De ɛɛ' ‑tɩ' 'ʋn ɛ, aoa' 'pee a muɛ \"ikmaa'. ");
INSERT INTO wob_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","Ɛ nɩɛ \"nmia‑tɩ ‑o 'de aopʋ kɛ' wɔ‑saʋn ke Fariseɛn‑wi\" 'a ‑tɩ' 'ʋn ! Ao nɩɛ \"jridepooʋn, dɛ‑nʋɛ' aoa poɛ 'e 'blʋa‑ ke 'tɔniɛ 'mɛ, ‑wɛe ‑bo ao 'je nyɔ due' ɛ, aoa nʋ ‑mɔ aoa' klai\" ju 'ʋn. ‑Bo ɔ 'kpɛ la 'sasa 'de ɔ 'cɩan aoa' nʋʋkplɩn ɛ, ‑wɛe ɔ 'di nyni wɔn kpɛ 'sɔɔn, ɔ ‑sii aopʋ 'a ‑cɛ\", 'de ɔ ‑te' nɛ ‑sea' 'mʋ‑ta 'ble 'a ‑tea'. ");
INSERT INTO wob_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","Ɛ nɩɛ \"nmia‑tɩ ‑o 'de aoa' ‑tɩ' 'ʋn, ao ‑ɔɔ poa nyʋ ‑je o ka \"jri 'a waʋn nɩa, ‑wɛe ‑ɔ ‑na ‑bo nyɔ ‑snɛɛ Kea ‑gbu klaa\" 'ʋn ‑mɛ se dɛ jrɛ' nɩ‑, 'kaa ‑bo nyɔ ‑snɛɛ 'sani ‑nɩa 'o Kea ‑gbu klaa\" ‑pʋn\" 'ʋn ɛ, ‑mɛ dɛ ɔ \"sia 'nynɩ ɛ, ɔ 'je ɛ nʋ ‑o. ");
INSERT INTO wob_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Ao ‑gbʋn ka ao sea tɔ'di nɩ ɛ, 'de aoa' 'jea i ɛ ! ‑Jɛ wɛ‑ ‑nɩ dɛwɔn ɛ‑ ? 'Sani ‑ae, ‑aee' Kea ‑gbu klaa\" ‑jɛ 'sani nɩa 'o ‑pʋn\" ɛɛ ? ");
INSERT INTO wob_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Ao wlu' ke'wlɛ ao 'na, ‑bo nyɔ ‑snɛɛ ‑ta nyʋ a ‑saa 'sraa 'a 'nynɩ 'ʋn ɛ, ‑mɛ se dɛ jrɛ' nɩ‑, 'kaa ‑bo nyɔ ‑snɛɛ 'bo 'sraadɛ ‑ɛ ‑nɩa 'o ɛ \"kpei 'ʋn ɛ, ‑mɛ dɛ ɔ \"sia 'nynɩ ɔ 'je ɛ ja ‑o. ");
INSERT INTO wob_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Ao ‑gbʋn ka aoa' 'jea i ɛ ! ‑Jɛ wɛ‑ ‑bɛ\"i ɛ‑ ? 'Sraadɛ ‑ae, ‑aee' ‑ta nyʋ a ‑saa 'sraa‑ ? ‑Ta nyʋ a ‑saa 'sraa‑ mɛ ‑nɩ dɛwɔn ‑ɛ ‑sii 'sraadɛ. ");
INSERT INTO wob_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Nyɔ ‑snɛɛ ‑ta nyʋ a ‑saa 'sraa 'a 'nynɩ 'ʋn ɛ, ‑mɛ ‑mɔ ‑snɛɛ 'sraadɛ ‑nɩa 'bo ɛ \"kpei 'a 'nynɩ 'ʋn ‑ke. ");
INSERT INTO wob_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Nyɔ ‑snɛɛ Kea ‑gbu klaa\" 'ʋn ɛ, ‑mɛ nyɔ ‑tia\" 'de ɛ 'di mɔ ɔ ‑snɛɛ 'ʋn. ");
INSERT INTO wob_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","'De nyɔ ‑ɔ ‑toa jaʋn ‑cɩɛ \"i ɛ, ‑mɛ Kea 'a 'beɔkpa‑tɛ mɛ ɔɔ toa 'o ‑cɩɛ \"i 'mʋa‑, ɛ ke Kea ‑tea i 'bo ɛ \"kpei ke‑. ");
INSERT INTO wob_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","Ɛ nɩɛ \"nmia‑tɩ ‑o 'de aopʋ kɛ' wɔ‑saʋn ke Fariseɛn‑wi\" 'a ‑tɩ' 'ʋn ! Ao nɩɛ \"jridepooʋn, dɛ‑nʋɛ' dɩ mɩ\"mɩ\" aoa plea aoa ja ɩ ‑wee' 'a sɔɔn'ɔ ‑puue ‑nɛ 'mɛ, aoa jea Kea wɔn ‑saa', 'kaa aoa nʋʋɛ dɩ ‑jɩ ‑kɔan ‑tɩ' 'plʋ 'ʋn. Dɩ ‑nɩa 'e Kea 'a kɛ' 'di ao 'bo ɩ 'plʋ 'ʋn nʋʋɛ : \"Isrɛa' o nyʋ 'a wɛe 'jea' o wlu \"kpei‑ kpʋan' o ao sie 'o ‑mɩ 'mɛ 'de ‑mɩ ao 'je nʋ 'de‑, ɛ se ‑jɩ ‑sia 'o ao 'je ‑mɩ 'plʋ 'ʋn nʋʋ ko‑ 'kaa ao 'bo 'wɛi 'a ‑puue ‑nɛ ‑saa' o \"mae ‑ke. ");
INSERT INTO wob_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Ao ‑ɔɔ poa nyʋ ‑je o ka \"jri 'a waʋn nɩa, \"ni ao 'jea 'na aoa 'kple ɛ 'mii ‑wɛe aoa ‑sa 'e kpein \"kpei, 'kaa aoa mla ‑sɛn\"kpei soo\"‑ 'mɛ. ");
INSERT INTO wob_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","Ɛ nɩɛ \"nmia‑tɩ ‑o 'de aopʋ kɛ' wɔ‑saʋn ke Fariseɛn‑wi\" 'a ‑tɩ' 'ʋn ! Ao \"jridepooʋn 'a ti, aoa wɔɔ 'bo ‑kaun\" ke 'kɛinkɛ ku ‑pʋn\" 'a 'sʋ ‑wɛe 'de ɩ 'di \"ji aoa' \"jriidɩ ao ‑sa nyʋ 'kwa i ɛ. Ka aoa' \"jri 'a waa' ke aoa' dɛ pɛe \"ipoa' \"jia ɩa' 'kɛinkɛ tu ɛ, ao se ɛ juo‑. ");
INSERT INTO wob_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Fariseɛn ‑mɔ ‑ɔɔ' 'jea i ɛ, ‑ɩn ‑wɔɔ 'de ‑ma 'kɛinkɛ 'dii ke tɛin\" ‑wɛe ‑ɩn ‑je 'o ɛ ku ‑pʋn\" wɔɔ‑ 'de ɩ ‑wee' 'je 'pepe nɩ. ");
INSERT INTO wob_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","Ɛ nɩɛ \"nmia‑tɩ ‑o 'de aopʋ kɛ' wɔ‑saʋn ke Fariseɛn‑wi\" 'a ‑tɩ' 'ʋn ! Ao nɩɛ \"jridepooʋn, dɛ‑nʋɛ' ao ‑kɔ' ‑gbaɩn' plu ‑ɩa 'nɔ \"kpae' nmɔ \"jrii, ‑wɛe ‑ɩ 'di, \"ku 'a 'kpɩ ke ɩa' plae\" 'a 'sʋ ji\" a. ");
INSERT INTO wob_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Aomɔ ‑ke ɛ, aoa' nyiɔjɔ ‑kɔ' \"isrɛnyʋ 'de nyʋ \"juɔi, 'kaa \"jridepooa' ke 'diwɔnynia' 'a 'sʋ ‑ji\" 'de aopʋ 'ʋn 'ɛ. ");
INSERT INTO wob_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","Ɛ nɩɛ \"nmia‑tɩ ‑o 'de aopʋ kɛ' wɔ‑saʋn ke Fariseɛn‑wi\" 'a ‑tɩ' 'ʋn ! Ao nɩɛ \"jridepooʋn, dɛ‑nʋɛ' aoa ma Kea 'a wlu 'kwajaaʋn ke \"isrɛʋn 'a ‑gbaɩn' 'de aoa 'wlɩ \"ko \"jru. ");
INSERT INTO wob_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","‑Wɛe ao 'na : ‑Bo ‑a ‑nɩ 'kmʋ 'de ‑a \"bo ‑wi\" 'a nɔi\" 'de ɛ, ‑mɛ ‑a ‑ke ʋʋ se obeei, ‑a se Kea 'a wlu 'kwajaaʋn 'dbai. ");
INSERT INTO wob_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Ka ao nɩa nyʋ ‑dba Kea 'a wlu 'kwajaaʋn 'a \"nynuu‑ ɛ, ɩmɩ ao nɩa 'o 'tmʋa' 'mʋa‑. ");
INSERT INTO wob_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Ɛ nmɔi\", dbo ao \"bo ‑wi\" ‑teea ao kpɛ nya, ao 'je ɛ \"i ‑kɔ'. ");
INSERT INTO wob_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Ao sɛn ‑po ‑nyʋ, jɔe 'a \"nynuu‑ aoa naa tɔ' i 'ee, ka ao 'je Kea 'a 'pee wɔin\" 'pʋsʋn nʋ ɛ‑ ? \"Ɩɩn‑, ao se ɛ wɔin\" 'pʋi. ");
INSERT INTO wob_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Ɛmɛ ‑tɩ 'ma mu aopʋ Kea 'a wlu 'kwajaaʋn o, dɛ \"ijuoʋn o, kɛ' wɔ‑saʋn ‑kpʋan' 'snɩ \"idboa'. Aoa muɛ jrʋ' 'dbaa', aoa muɛ jrʋ' kɔa' 'bo tu ‑kwlɩ\", aoa muɛ jrʋ' klae 'ʋn kpaa' 'de aoa' \"jrui 'kɩɩn‑gbi 'dii, aoa muɛ ʋʋpʋ 'kle ‑tua\" ‑kwlɛ 'dii, ");
INSERT INTO wob_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","‑wɛe \"isrɛnyʋ 'a nymɔ 'je i'wla. Dɛ ‑tba' 'o Abɛlɩ \"isrɛi 'a 'mɛa' ‑wɛe ‑ɛ ‑jɛɛa Barasi 'a \"ju Sakali 'a 'dbaa' 'bo Kea ‑gbu klaa\" ke 'sraa‑sa'ɩn 'nynɩ ɛ, \"isrɛnyʋ 'a nymɔ 'wla i 'mɛ 'de aopʋ Suifʋ 'kwa. Dɩ ao nʋa 'mʋa‑ ɩa' ‑kao 'je aopʋ 'ʋn ‑craa ‑o. ");
INSERT INTO wob_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Tɔ' ‑tɩ 'ma 'tmʋ aopʋ, ɩ ‑wee' 'a ‑kao a muɛ nyʋ ‑nɩa ‑sɩanwɩ 'di 'ʋn ‑craa'. ");
INSERT INTO wob_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Selisalɛm, Selisalɛm ɛmɛ ‑ɛ ‑dba Kea 'a wlu 'kwajaaʋn, ‑wɛe ‑ɛɛ tbaa nyʋ Kea dboa 'de ɛ ‑pee \"soi i ɛ, kpɛ ‑tiiɛ' 'ma ‑pɔɛn 'ɩn 'je ɛɛ' \"nynuu‑ \"jrui 'kɩɩn‑ 'bo 'ʋn ‑pʋn\" ka ‑gbaʋnsʋn\" a 'kɩɩan ɛɛ' \"nynuu‑ \"jrui 'bo ɛɛ' nai ‑sɔn ɛ, 'kaa ɛ 'na ɛ se 'wɔn. ");
INSERT INTO wob_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Ao ‑gbʋn 'nɔ, ɛmɛ ‑tɩ aoa' Kea ‑gbu klaa\" a mu wɔn flɔan'. ");
INSERT INTO wob_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","'Ma 'tmʋʋ‑ aopʋ 'mɛ, ao se 'ʋn \"jriɛ‑ 'jeei 'bode mamaʋ 'sʋ ɛ 'je nɔ\" jrɛ' jɛɛ‑. 'De ɛɛ' nɔ\" tu 'di mɛ aoa mu wlua' ka : \"Diwan kpʋn \"ju ‑ɔɔ jia 'de Tʋ\"bo 'a 'nynɩ 'ʋn ! ");
INSERT INTO wob_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","‑Ta Sesi 'wlʋa 'e Kea ‑gbu klaa\" 'di ‑wɛe ɔɔ mua, 'bomɔ ɔɔ' klai\" nynuu 'kpɔ ‑pʋn\" ‑wɛe ʋʋ 'jeɛ nʋ 'de ɔ 'je Kea ‑gbu klaa\" 'a posʋn \"jriɛ‑ o sie. ");
INSERT INTO wob_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","'Sʋ Sesi \"duɛ wlu 'ʋn 'de ʋʋ ‑pee, ɔ 'na : Aoa 'je dɩ \"klein ‑nɩ 'mɛɛ ? 'Ma 'tmʋʋɛ aopʋ tɔ' ‑tɩ, ɩ ‑wee' a muɛ ‑gbuea' ɩa' \"sou se 'o ɛ ‑posou\" \"kpei siei. ");
INSERT INTO wob_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Sesi 'da kan' 'sʋ ɔ muɛ 'e olifɩ‑crʋ \"kpei, ‑wɛe ɔ ‑te i. Ɔɔ' klai\" nynuu 'a 'sʋ ‑kpɔ ‑pʋn\" 'de ‑ʋʋ ‑tee' ɔ i, ʋʋ 'na : Dɛɛ nɔ\" ‑mɩ 'a dɩ tu 'je nʋʋɛ ɛ‑ ? Dɛ ‑a ‑je \"jriɛ‑ o sie ‑wɛe ka ‑ma mua de jia' o, 'de ka 'blʋa 'a ‑kwɛ‑ nɔ\" 'jea nyni ‑wɛe ‑a ‑je ɛ juo ɛ ? ‑Ɩn ‑tmʋ ɛ ‑aʋn. ");
INSERT INTO wob_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Sesi 'na : Ao ‑tu\" aoa' ‑cɛ\" 'ɛ ‑tɩ' ‑wɛe nyɔ je ao 'srɛ ipoo‑, ");
INSERT INTO wob_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","dɛ‑nʋɛ' nyʋ ‑tuu\"‑tuu ‑a mu 'ma 'nynɩ \"jru ‑tea' ‑ʋʋ ‑e ji, 'de ‑ʋʋ ‑je wlu ka : 'Mɔ ‑nɩ Klisɩ ! ‑Wɛe ‑ʋʋ ‑je nyʋ ‑tuu\"‑tuu 'srɛ ipoo‑. ");
INSERT INTO wob_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Aoa muɛ tʋ 'a nynɩ ke tʋ 'a 'kpa ‑cnʋɛn\" 'wɔan, ‑bo ɛ \"kʋʋan aopʋ i o, ‑bo ɛ tɛɛn aopʋ o, dɛ 'bo aopʋ 'dii waa, dɛ‑nʋɛ' ɩa' dɩ tu 'je 'o nyni ‑o see, 'kaa ‑mɛ se 'blʋa 'a ‑kwea' nɩ ke. ");
INSERT INTO wob_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Nyiɔ 'ɔ kpɛ jrɛ' ɛ muɛ 'ʋnsɔan', ɛ 'je kpɛ jrɛ' o ‑fɔn', 'blʋa 'a blo'wɔn due' a muɛ ɛ ‑poblʋa o ‑fɔan'. 'Mɩɩɛ‑ ɛ muɛ jia', 'blʋa‑ a muɛ crɛa' dɩ 'mii‑. ");
INSERT INTO wob_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Ɩa' dɩ tu a muɛ jia', ka \"i‑saa' ‑gbaan ‑di a kpʋan' 'nynɔkpao' ‑kwlʋ ɛ, 'kamɔ ɩa mu nyʋ ‑kwlʋ kpʋan'. ");
INSERT INTO wob_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","Nyʋ a muɛ aopʋ 'kle \"kpei jaa, ʋʋa muɛ ao 'dbaa' ‑wɛe ʋʋ ‑wee' \"klein 'je aopʋ 'ʋn 'nyɛ 'de 'ma ‑tɩ' 'ʋn. ");
INSERT INTO wob_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","'De ɩa' 'wɩ tu 'di ɛ, nyʋ ‑tuu\"‑tuu a muɛ ʋʋa' Kea ‑kwlɩ\" ‑tea' o 'bɔa', ʋʋa muɛ ba 'srɛ ipooa' ‑wɛe ʋʋ 'je ba 'ʋn 'nyɛ. ");
INSERT INTO wob_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Nyʋ ‑ʋʋa ‑daa' ʋʋa' ‑cɛ\" Kea 'a wlu 'kwajaaʋn a muɛ jia' ‑wɛe ʋʋ 'je nyʋ ‑tuu\"‑tuu 'srɛ ipoo‑. ");
INSERT INTO wob_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Dɛsaʋn a muɛ isia', ɛmɛ ‑ɛɛ muɛ nʋa' ‑wɛe nyʋ ‑tuu\"‑tuu 'a ba 'a ‑tɩ' kmaa' 'je \"kpei cɛn‑. ");
INSERT INTO wob_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","'Kaa nyɔ ‑ɔ sea 'ma ‑tɩ' o 'bɔ ‑wɛe ‑ɔ ‑blea nai\" mamaʋ ɛ, ɔɔ muɛ 'pʋʋa'. ");
INSERT INTO wob_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","‑Pɔia\" ‑tɩ ‑tmʋa Kea 'a 'kmʋ dee' a ‑tɩ' ɛ, nyʋ a mu ɛ 'tmʋa' 'de 'blʋa‑ ‑wee' ‑pee, ‑wɛe nyʋ ‑wee' \"klein 'je ɛ 'wɔn, ‑wɛe 'blʋa 'a ‑kwɛ‑ nɔ\" 'je nyni. ");
INSERT INTO wob_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","\"Ju due' ‑ɔɔ ‑tɩ' Kea 'a wlu 'kwajaai Daniɛ 'tmʋa 'de ɛ, aoa mu ɔ 'jea', nyʋ a 'dɔɔ sɩaɩn'‑. ‑Ta ‑kwea i 'bo ɔɔ mu i ‑tea'. Nyɔ ‑nʋ ɛ 'dii ‑mɛ ɔ 'wɔn ɛ 'mii 'pepe. ");
INSERT INTO wob_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","‑Mɛ nyʋ ‑a mua 'e Suideblʋa \"kpei nɩa' a, ʋʋ ple ʋʋ 'je crʋɩ \"kpeii mu. ");
INSERT INTO wob_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Nyɔ ‑ɔɔ mua 'e ‑gbu\" \"kpei nɩa' ɔ 'bo i \"siɛ, ɔ 'bo ɔɔ' dɩ ‑nɩa 'e ‑gbu\" 'di 'ʋn \"duɛ. ");
INSERT INTO wob_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","'De nyɔ ‑ɔɔ mua 'e ‑kle nɩa' ɔ 'bo ɔɔ' \"bai 'ʋn \"dua' de muɛ 'de ‑kwlɔ. ");
INSERT INTO wob_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Ɛɛ muɛ \"nmia‑tɩ nɩa' 'de ɛɛ' 'wɩ tu 'di, 'de 'nynʋkpae' ‑sea' \"i ‑gba' ke 'nynʋkpae' ‑blea \"nynuu‑ ‑kwlɩ\" 'a ‑tɩ' 'ʋn. ");
INSERT INTO wob_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Ao bae Kea i ‑wɛe ɩa' dɩ tu 'bo nʋʋɛ dee 'a ji nɔ\" ke ‑kwlewɩ \"kpei ke‑, ");
INSERT INTO wob_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","‑bo ɛ se ɛ nɩɛ, 'kle ‑a mua jia' 'de ɛɛ' nɔ\" tu 'di a muɛ \"ikmaa' ɛ 'e 'kle ‑wee' ‑sii. Dɛ ‑wlʋa 'e 'blʋa 'a ‑gbɔo ‑tee nɔ\" ‑wɛe ‑ɛ ‑jɛɛa ‑sɩanwɩ 'de ‑ɛɛ mua nya mua' a, nyɔ se ɛ 'bɛɛ‑ ɔ 'je ɛɛ' 'kle tu 'kle jrɛ' \"ipoo‑. ");
INSERT INTO wob_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","‑Bo Kea se ɩa' 'wɩ tu \"i \"kʋʋan‑ 'de ɛ, ‑mɛ nyɔ ‑jea 'pʋ ɔ se nɩ‑, 'kaa 'de nyʋ ɛ ‑sa 'o 'a ‑tɩ' 'ʋn ɛ, ɛ \"kʋʋan‑ ɩa' 'wɩ tu \"i. ");
INSERT INTO wob_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","‑Bo nyɔ jrɔ' wlu ao ‑pee ka, ɔ 'na : Klisɩ nɩɛ ‑ta, 'de ɔ nɩɛ 'nɔ ! Ao 'bo ɛ tɔ' 'ʋn 'jeɛ, ");
INSERT INTO wob_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","dɛ‑nʋɛ' nyʋ ‑ʋʋa ‑daa' ʋʋa' ‑cɛ\" Klisɩ ke nyʋ ‑ʋʋa ‑daa' ʋʋa' ‑cɛ\" Kea 'a wlu 'kwajaaʋn a muɛ jia'. Ʋʋ 'je jrii' klae\" klae\" nʋ, ‑wɛe ‑bo ɛ 'bɛɛ‑ 'de ɛ, ʋʋ 'je nyʋ Kea ‑sa 'o 'srɛ ipoo‑. ");
INSERT INTO wob_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Ao po doin\" i 'pepe, 'ɩn siɛ nɔ\" nya ‑wɛe 'ma 'tmʋʋ aopʋ kaan 'mɔ. ");
INSERT INTO wob_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","‑Bo nyʋ 'na : Ao ‑gbʋn 'nɔ, ɔ nɩɛ 'e ‑pɩɩɔn\" blʋa \"kpei ! Ao 'bo 'e muɛ, 'de ‑bo nyʋ wlu ao ‑pee ʋʋ 'na : Ao ‑gbʋn 'nɔ, ɔ nɩɛ 'e ‑gbu\" 'di ‑ta, ao 'bo ɛ tɔ' 'ʋn 'jeɛ. ");
INSERT INTO wob_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","'Kaa ka \"ni a crɛa \"jrii 'de jaʋn 'di ‑wɛe ɛɛ 'wlʋa 'e 'jrʋ 'a 'wlʋ 'ɩn 'de ɛɛ mua 'e 'jrʋ 'a iblu 'ɩn ɛ, 'ka nyiɔ 'ɔ \"ju 'a dejisʋn a mu nɩa'. ");
INSERT INTO wob_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","‑Mɛ ‑ta \"ku nɩa 'bomɔ ‑tua a ‑kwɛɛ' de. ");
INSERT INTO wob_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","‑Bo 'kle'jewɩ 'wlʋ 'o ‑jei\" ɛ, 'bo ɛ 'je \"sri 'sʋ 'jrʋ 'je \"jri \"mu, 'cʋ 'je fan ‑tɩ 'bɔ, 'cʋ‑sɩɩn 'je 'de \"jɛi 'wlʋ ɩ 'je blu, ‑wɛe \"ikmadɩ ‑nɩa 'de jaʋn 'di, ɩ ‑wee' \"klein 'je i ‑sua'‑. ");
INSERT INTO wob_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","‑Wɛe dɛ ‑ɛ ‑jea nyiɔ 'ɔ \"Ju 'a dejia' to ɛ, ɛ 'je ‑tan 'bo jaʋn ‑kwlʋ. 'Blʋa ‑wee' \"klein a muɛ kpleea' 'de ɩa' 'wɩ tu 'di, dɛ‑nʋɛ' ʋʋa muɛ nyiɔ 'ɔ \"Ju 'jea', ɔ 'je 'bo bue\" \"kpei nɩ 'de ɔɔ' \"ikmaa' klaa\" ke ɔɔ' 'beɔdɛ 'ʋn. ");
INSERT INTO wob_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Dɔ‑kleɛ klaa\" a muɛ wlua', ‑wɛe ɔ 'je ɔɔ' \"soa‑wi\" dbo 'de 'blʋa 'a 'fɔ ‑nɩa ‑nyiiɛ o, 'de ʋʋ 'je nyʋ Kea ‑sa 'o \"jrui 'kɩɩn‑ dɛ ‑mua' ‑ɛ ‑jɛɛa 'blʋa‑ ke jaʋn 'a wɔn ‑klu' poɩn' ɛ. ");
INSERT INTO wob_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","Dɛ fikɩtu 'a \"i poo‑tɩ a tɔɔa nyʋ ɛ, ao 'wɔn ɛ 'mii. ‑Bo ɛɛ' 'dae‑ a sea \"ipeeɛ, ‑bo ɛɛ sea wɩn dee ‑tu\" ɛ, ‑mɛ ‑kua\" se o tɛɛn‑. ");
INSERT INTO wob_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","'Kamɔ ‑bo aoa sea dɩ ‑nɩa 'mʋa‑ 'je ɩa sea nʋʋɛ, ‑mɛ nyiɔ 'ɔ \"Ju 'a deji nɔ\" nyni'. Ɔ nɩɛ 'o ‑gbɛin\" ‑jei\". ");
INSERT INTO wob_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","'Ma 'tmʋʋɛ aopʋ tɔ' ‑tɩ, nyʋ ‑nɩa 'kmʋ 'de kaanwɩ 'di ʋʋa' jrʋ' se 'mɛi 'sʋ dɩ ‑nɩa 'mʋa‑ a jea 'o nyni. ");
INSERT INTO wob_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","'Blʋa‑ ke jaʋn a muɛ isɔan', 'kaa 'ma wlu se isɔin 'nɔ 'kmʋ. ");
INSERT INTO wob_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","Dɛ ‑jɛ ‑tua\" 'ma ji wɩ ke ɛɛ' nɔ\" ɛ, nyɔ jrɔ' se ‑mɩ juo‑. Kea 'a \"soa‑wi\" ‑nɩa 'e jaʋn 'di se ɩ juo‑, \"Ju se ɩ juo‑ ‑ke, \"Bo 'a 'sʋ mɔ ‑juo ɩ. ");
INSERT INTO wob_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","‑Sɔntɩ nyiɔ 'ɔ \"Ju a mua de jia' a, dɩ ‑nʋʋa Noe 'a nɔ\" ɛ, ɩa muɛ nʋʋa' ‑ke. ");
INSERT INTO wob_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","‑Ta \"ni klaa\" 'a dbawɩ sea nyni ke ɛ, nyiɔpʋ a di', ʋʋa 'naa, ʋʋa poɛ 'nynʋkpae' 'a \"flu, ʋʋa ‑tuɛ\" ʋʋa' \"nynuunynʋkpae' jrai mamaʋ 'sʋ ɛ je 'wɩ Noe pa 'e ‑bato' 'di jɛɛ‑. ");
INSERT INTO wob_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Ʋʋ se ɛ tɔ' o sie mamaʋ 'sʋ \"ni klaa\" je ji, ɛ je ʋʋ ‑wee' \"klein kpa, 'kamɔ ɛɛ mu nɩa' nyiɔ 'ɔ \"Ju 'a deji nɔ\" ‑ke. ");
INSERT INTO wob_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","'De ɛɛ' nɔ\" tu 'di, ‑bo nyʋ 'sɔɔn nɩ 'e ‑kle ɛ, due' 'je 'ʋn \"duuɛ‑, ‑wɛe due' 'je 'o sie‑. ");
INSERT INTO wob_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","‑Bo 'nynʋkpae' 'sɔɔn nɩ dɛ dua' 'bo ‑too \"kpei ɛ, ʋʋa' due' 'je 'ʋn \"duuɛ‑, ‑wɛe due' 'je 'o sie‑. ");
INSERT INTO wob_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Ao ‑te' \"jriɛ‑ \"i 'ja, dɛ‑nʋɛ' ao se Tʋ\"bo 'a deji‑sʋn juo‑. ");
INSERT INTO wob_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Ao 'wɔn dɛ ‑nɛ 'mii 'pepe, ‑bo ‑gbu\" jei juo \"maʋ'wɩ ‑ɛ 'di \"jrii 'jea 'de ɔ o ‑gbu\" paa 'de ɛ, ‑mɛ ɔɔ muɛ \"jriɛ‑ \"i ‑tea' mamaʋ 'sʋ ɔ se ɔ \"i \"tai‑ ɔ se ɔɔ' ‑gbu\" wai. ");
INSERT INTO wob_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Ɛmɛ ‑tɩ aomɔ ‑ke ɛ, ao nmae dɩ 'de pɛe o, dɛ‑nʋɛ' nɔ\" ‑ɛ 'di ao se ɛ ‑kwlɩ\" ‑tee ɛ, ɛmɛ nyiɔ 'ɔ \"Ju a mu jia'. ");
INSERT INTO wob_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Ka dbonʋi ‑jɔ ‑nɩa tɔ'di nɩa ao nɩ kan' ! ɔɔ' 'wlʋ wlu \"kpei, ɔmɔ ɔɔ' 'blei a ‑te' dbonʋʋn jrʋ' kwa, ‑wɛe ɔɔ \"nyɩ ʋʋpʋ diidɛ nɔ\" 'dɔe 'di. ");
INSERT INTO wob_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Dbonʋi ‑ɔɔ mua kan' nʋa' mamaʋ 'sʋ ‑ɔɔ 'blei 'je ɔ jɛɛ, 'mʋa‑ nʋ ‑mɔ. ");
INSERT INTO wob_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","'Ma 'tmʋʋɛ aopʋ tɔ' ‑tɩ, ɔɔ' 'blei a muɛ ɔ ɔɔ' dɩ ‑wee' \"klein \"jru kpɔ' i ‑tea'. ");
INSERT INTO wob_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","'Kaa ‑bo ɔɔ' dbonʋi tu nyni 'di wɔn ‑wɛe ɔ 'je wlu 'de ɔɔ' ‑cɛ\" 'kpa 'ʋn, ɔ 'e nʋ : 'Ma 'blei 'a ji nɔ\" se i\"kʋʋan‑ ke. ");
INSERT INTO wob_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","‑Wɛe ɔ 'je ɔɔ' \"dɛi‑wi\" 'a blaa' ‑pʋn\" ‑te, ɔ 'je dɛ dia 'a 'sʋ kpa, 'de ɔ ke nmɔ 'naʋn 'je nmɔ \"jru po‑, ʋʋ 'je 'ʋn ‑sii'‑. ");
INSERT INTO wob_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Ɔɔ' 'blei a muɛ jia' 'de 'wɩ ‑ke nɔ\" ɔ sea ‑kwlɩ\" ‑te 'di, ");
INSERT INTO wob_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","‑wɛe ɔ 'je 'mlʋ cɛn. 'De 'pee ‑kpʋan' \"jridepooʋn ɛ, ɛ 'je ɔ kpʋn ‑ke, 'bomɔ ɔɔ mu ‑fɩn\" 'a ‑wɛe ɔ 'je 'nynɩ \"idii‑. ");
INSERT INTO wob_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Nyiɔ 'ɔ \"Ju 'a deji nɔ\" ɛ, nyʋ ‑a fua Kea 'a 'kmʋ dee ɛ, ʋʋ ‑kɔ' 'nynɩamɩɩ\" ‑puue ‑a fua 'nynɔjei ɛ. Ʋʋ \"duɛ ʋʋa' nɛbi 'ʋn ‑wɛe ʋʋ mu 'nynɔjei \"i 'jaa'. ");
INSERT INTO wob_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Ʋʋa' ‑mm\" se tɔ' 'ble, ‑wɛe ‑mm\" ‑sia 'o nɩ tɔ'di. ");
INSERT INTO wob_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","‑Mm\" ‑sea' tɔ'di ‑nɩ ‑nʋ \"duo ʋʋa' nɛbi 'ʋn 'ɛ kpɩɩn‑, 'kaa ʋʋ se ɛ 'cna 'a tɔo 'dei ‑te'. ");
INSERT INTO wob_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","'De ‑mm\" ‑nɩa tɔ'di ‑wi\" ‑mʋ \"duo ʋʋa' nɛbi 'ʋn 'ɛ ‑ke, 'kaa ʋʋ poɛ 'cna dɛ 'di ‑wɛe ʋʋ ‑tee ɛ 'dei. ");
INSERT INTO wob_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","'Nynɔjei ʋʋa fua se ‑too\"‑ ɔ se ji, 'sʋ \"nyɩɔ' kpʋn ʋʋ ‑wee' ‑a \"jri 'mɛ 'sʋ ʋʋ ‑teɛ 'mʋa' ‑pʋn\". ");
INSERT INTO wob_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","‑Too' ‑kwea 'sʋ ʋʋ 'wɔn nyɔ due' 'a \"wɔwlu ɔ 'na : 'Nynɔjei ji' oo, ao 'jɔɔ \"i oo ! ");
INSERT INTO wob_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","'Nynɩamɩɩ\" ‑puue ‑nʋ ‑gbuɛ 'de \"nyɩɔ' woi, 'sʋ ʋʋ ‑teɛ ʋʋa' nɛbi 'a nmaea' ‑pʋn\". ");
INSERT INTO wob_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Ʋʋa' ‑mm\" ‑sea' tɔ'di nɩ wlu' 'de ‑mm\" ‑nɩa tɔ'di ‑pee, ʋʋ 'na : Ao \"nyɩ ‑aʋn aoa' 'cna 'a dɛ‑saan\" 'dee, ‑aa nɛbi ‑wee' a 'mʋʋ. ");
INSERT INTO wob_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","'Sʋ ʋʋ 'na : \"Ɩɩn‑, ‑a se 'bɛɛ‑, ‑aa 'cna se \"i ‑ti ‑wɛe ao ke ‑a ‑je ɛ 'ʋn ‑seea'‑. Ao mu aoa' ‑nɩ ‑tɩn' 'de nyʋ ‑ʋʋa ple ɛ 'kwa. ");
INSERT INTO wob_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Ʋʋ siiɛ 'cna ‑tɩan' 'sʋ 'nynɔjei je ji. 'Nynɩamɩɩ\" ‑nmaea dɩ ‑wɛe ɔ jɛɛa, ʋʋpʋ ‑ke ɔ pa 'e 'mʋanʋ‑gbu 'di, ‑wɛe ɔ kan 'o ‑gbɛin\" 'de ʋʋa ‑tu\" ɔɔ' 'nynɔ 'ble ‑kɔ. ");
INSERT INTO wob_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Ɛ fɔan 'o ‑paii 'sʋ 'nynɩamɩɩ\" ‑mm\" ‑sea' tɔ'di nɩ ‑nʋ ji', 'sʋ ʋʋ ‑teɛ weea' ‑pʋn\" ʋʋ 'na : Tʋ\"bo, Tʋ\"bo, ‑ɩn ‑kain ‑a \"wɔin 'de ! ");
INSERT INTO wob_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","'Kaa 'nynɔjei 'na : 'Ma 'tmʋʋ aopʋ tɔ' ‑tɩ 'ɩn se ao juo‑. ");
INSERT INTO wob_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","‑Wɛe Sesi poɛ \"kpei ka ɔ 'na : ‑Bo ɛ nɩ kan' 'ja a, ‑mɛ ao ‑te \"jriɛ‑ \"i, dɛ‑nʋɛ' ao se 'wɩ ke nɔ\" juo‑. ");
INSERT INTO wob_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Sesi pooɛ ‑tɩ' \"i ke'wlɛ 'de ɔɔ' dejisʋn 'a ‑tɩ' 'ʋn, ɔ 'na : Ka \"ju due' ‑ɔ ‑jea 'dʋʋa' mu ‑wɛe ‑ɔ ‑da ɔɔ' dbonʋʋn 'de ‑ɔ sia ʋʋpʋ ɔɔ' dɩ o nɩa, 'kamɔ ɛɛ mu nɩa'. ");
INSERT INTO wob_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Ɔ \"nyɩ due' 'sanikpi ‑mm\", ɔ \"nyɩ due' 'sanikpi 'sɔɔn, ‑wɛe ɔ \"nyɩ taan ‑nɔ 'sanikpo 'due, ka ʋʋpʋ 'je ɛ kwai 'bɛɛ‑ due 'due ɛ, 'sʋ ɔ mu'. ");
INSERT INTO wob_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","'Bo ɛ \"sri ‑jɔ ‑jea 'sanikpi ‑mm\" je ɔɔ' ‑nɩ 'dɔɔ 'ʋn poa' ‑pʋn\" ‑te, 'sʋ ɔ 'jeɛ 'sanikpi ‑mm\" deejrɩ'. ");
INSERT INTO wob_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","'Kamɔ ‑jɔ ‑jea 'sanikpi 'sɔɔn nʋ ‑ke 'sʋ ‑mɔ 'jeɛ kpi 'a kmɛ' 'sɔɔn deejrɩ'. ");
INSERT INTO wob_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","'Kaa ‑jɔ ‑jea kpo due' ‑mɔ mua ɔ \"bluɛ ‑klu' ‑wɛe ɔ po 'e ɔɔ' 'blei 'a 'sani kpo. ");
INSERT INTO wob_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","Ɛ nɩa 'o, ɛ nɩa 'o 'sʋ ɛ, dbonʋʋn ‑nʋ 'a 'blei jiɛ de ‑wɛe ɔ 'na : Ao ji, ao 'je dbo ao nʋa 'a \"kuan po. ");
INSERT INTO wob_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","'Sʋ ‑jɔ ‑jea ‑mm\" 'kpa 'o 'ɛ, ‑wɛe ɔ to 'sanikpi ‑mm\" jrɩ' ɔ 'jea ‑nɩ, 'de ɔ 'na : 'Ma 'blei, ‑ɩn siɛ 'ʋn 'sanikpi ‑mm\" o 'de‑, 'kaa ‑ɩn ‑gbʋn 'nɔ, 'ɩn 'jeɛ kpi ‑mm\" jrɩ' 'ɩn je 'o ɩ \"kpei po. ‑Ma dɩ ka. ");
INSERT INTO wob_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Ɔɔ' 'blei 'na : ɛ nmɔi\", ‑ɩn ‑nɩɛ dbonʋi ‑cɔɔn' ‑o, ‑maa' 'wlʋ wlu \"kpei, ‑ɩn ‑bɛɛ' dɩ mɩɩ\" \"wɔin, 'ma muɛ ‑ʋn dɩ ‑tuu\" kwa ‑tea'. ‑Ɩn ji 'de ‑ɩn ‑ke 'ma ‑a ‑je 'mʋa‑ nʋ. ");
INSERT INTO wob_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","‑Jɔ ‑jea 'sanikpi 'sɔɔn ‑mɔ 'kpa 'o 'ɛ ‑ke, ɔ 'na : 'Ma 'blei, ‑ɩn siɛ 'ʋn 'sanikpi 'sɔɔn o 'de‑, 'kaa ‑ɩn ‑gbʋn 'nɔ, 'ɩn 'jeɛ kpi 'sɔɔn deejrɩ' 'de ɩ \"kpei, ɩmɩ ka. ");
INSERT INTO wob_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Ɔɔ' 'blei wlu ɔ ‑pee ɔ 'na : ɛ nmɔi\", ‑ɩn ‑nɩɛ dbonʋi ‑cɔɔn' ‑o, ‑maa' 'wlʋ wlu \"kpei 'de dɩ ‑sea dɛwɔn nɩ 'a ‑tɩ' 'ʋn, 'ma muɛ ‑ʋn dɩ ‑nɩa dɛwɔn kwa ‑tea'. ‑Ɩn ji 'de ‑ɩn ‑ke 'ma ‑a ‑je 'mʋa‑ nʋ. ");
INSERT INTO wob_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","'Sʋ ‑jɔ ‑jea 'sanikpo due' ‑mɔ 'kpa 'o 'ɛ, ‑wɛe ɔ wlu 'de ɔɔ' 'blei ‑pee, ɔ 'na : 'Ma 'blei, 'ɩn 'je kan' 'mɛ, ‑ma dɛ nɩɛ 'kle, ‑ta ‑ɩn sea dɛ po, 'bomɔ ‑ma ‑sa' dɛ. ");
INSERT INTO wob_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Ɛɛ' faʋn a nʋ 'ʋn 'ɛ, ɛmɛ ‑tɩ ‑ma 'sanikpo ‑ɩn ‑nyɩa\" 'ʋn ɛ, 'ɩn \"bluu ‑wɛe 'ɩn poɛ ‑klu'. ‑Ɩn ‑gbʋn 'nɔ, ‑ɩn kpʋn ‑ma dɛ. ");
INSERT INTO wob_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Ɔɔ' 'blei 'na : ‑Mɔ dbonʋi saʋn, ‑flandɛ 'ɛ ‑flandɛ‑ ! Ka ‑ta 'ɩn sea dɛ po 'ma ‑sa 'o dɛ ‑ɩn ‑jea kan' ‑mɔ 'dee, ");
INSERT INTO wob_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","‑mɛ ‑maa' kpa 'ma 'wɛi 'de 'wɛi i ‑teʋn o, ‑wɛe ‑bo 'ɩn ji de, 'de 'maa ‑sɛ 'e mu, ‑mɛ ɛ se 'o crɔn' po dɛwɛ‑jɛɛ ? ");
INSERT INTO wob_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","'De ɔ 'na : 'Sanikpi ‑nɩ ao ‑sɔ ‑mɩ 'kwa, ao 'jɩ \"ju ‑blea 'sanikpi ‑puue \"nyɩ, ");
INSERT INTO wob_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","dɛ‑nʋɛ' nyɔ ‑blea dɛ ‑nyʋ a mu ɔ jrɛ' \"nyɩa' ke'wlɛ, ‑wɛe dɩ 'je ɔ isiie‑. 'Kaa nyɔ sea' dɛ 'ble, dɛ‑saan\" ‑jɛ ɔ 'blea, nyʋ a muɛ ‑mɛ ɔ 'kwa ‑saa'. ");
INSERT INTO wob_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","'De dbonʋi ‑flan' ao \"duo ‑mɔ 'ʋn, ao 'je ɔ 'e \"kpae' ‑fiie\"‑ 'de kwie 'ʋn, 'demɔ ɔ 'e ‑fɩn\"‑ ‑wɛe ɔ 'e 'nynɩ \"idii‑. ");
INSERT INTO wob_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","‑Sɔntɩ nyiɔ 'ɔ \"Ju ke ɔɔ' \"soa‑wi\" a mua de jia' 'de ɔɔ' 'beɔdɛ 'ʋn ɛ, ɔɔ muɛ i ‑tea' 'bo ɔɔ' \"kpa‑tɛ \"kpei, ‑wɛe ɔ 'je nyʋ 'a 'pee 'je. ");
INSERT INTO wob_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","'De 'blʋa‑ ‑wee' \"klein 'je de ‑kwɛ‑ 'bo ɔ \"juɔi, ‑wɛe ɔ 'je nyʋ 'ʋn ‑seea' ɔ 'je jrʋ' 'de ɔɔ' dianfɔ o po, ɔ 'je jrʋ' 'de ɔɔ' kʋanfɔ o po, ka nɔ\"dɩ 'dei ‑tei a ‑seea' 'blae ke ‑gbae' 'ʋn ɛ. ");
INSERT INTO wob_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Ɔ 'je 'blae 'de ɔɔ' dianfɔ o po 'de ɔ 'je ‑gbae' 'de ɔɔ' kʋanfɔ o po. ");
INSERT INTO wob_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","‑Wɛe 'beɔ 'je wlu 'de nyʋ ‑nɩa 'e ɔɔ' dianfɔ o ‑pee ka : Ao ji, aopʋ 'ɩn 'Bo 'a \"diwan kpʋan, 'beɔdɛ 'kmʋ 'kpa 'sʋ ‑ɛ ‑teea 'de aoa' ‑tɩ' 'ʋn ɛ, ao \"duɛ 'ʋn, ");
INSERT INTO wob_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","dɛ‑nʋɛ' ‑ta 'mɩɩɛ‑ nʋʋa 'ʋn, ao \"nyɩɛ 'ʋn dɛ, 'ɩn je di. ‑Ta \"ni 'natʋn a 'dbaa 'ʋn ɛ, ao \"nyɩɛ 'ʋn \"ni, 'ɩn je 'na. ‑Ta 'ɩn nɩɩa 'dʋɩ‑ ɛ, ao kpʋʋɛn 'ʋn sɩn 'sɔɔn. ");
INSERT INTO wob_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","‑Ta 'ɩn cɛɛan kui ɛ, ao paa 'ʋn dɛ 'ʋn. ‑Ta 'wɛ‑ ɛ nʋʋa 'ʋn ɛ, ao ‑tuɛ\" 'ma ‑tɩ'. ‑Ta 'ɩn nɩɩa ‑kaso 'di ɛ, ao jiɛ 'mi \"i ‑teea'. ");
INSERT INTO wob_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","'Bomɔ \"isrɛʋn a mu wlua' ka : Tʋ\"bo, ‑taka 'mɩɩɛ‑ nɩɩ ‑ma nʋʋa' ‑wɛe ‑a ‑nyɩ\" ‑ʋn dɛ ‑ɩn di ɛ‑ ? ‑Ta \"ni 'natʋn nʋʋ ‑ʋn ‑wɛe ‑a ‑nyɩ\" ‑ʋn \"ni, ‑ɩn ‑na a‑ ? ");
INSERT INTO wob_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","‑Taka ‑ɩn ‑nɩɩ 'dʋɩ‑ ‑wɛe ‑a ‑kpʋʋn ‑ʋn sɩn 'sɔɔn ɛ‑ ? ‑Taka ‑ɩn ‑cɛɛn kui ‑wɛe ‑a ‑paa ‑ʋn dɛ 'ʋn ɛ‑ ? ");
INSERT INTO wob_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","‑Taka 'wɛ‑ nɩɩ ‑ʋn nʋʋa' 'de ‑ɩn ‑nɩɩ ‑kaso 'di ‑wɛe ‑a ‑tee' ‑mii\" ɛ‑ ? ");
INSERT INTO wob_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","‑Wɛe Tʋ\"bo 'je ʋʋ ‑pee wlu ka : tɔ' ‑tɩ 'ma 'tmʋʋ aopʋ, dɛ \"o dɛ ao nʋa \"ju ‑saan\" ka \"jrii 'de 'ma de'di ‑wi\" \"klu ɛ, ‑mɛ 'mɔ ao nʋ ɛ \"jrii. ");
INSERT INTO wob_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","‑Wɛe ɔ 'e wlu ke'wlɛ 'de nyʋ ‑nɩa 'e ɔɔ' kʋanfɔ o ‑pee ka : Ao ‑saa 'ʋn kɩn. Aopʋ 'daɩn kpʋan, ao mu 'e nɛ 'ʋn. ɛɛ' nɛ tu ‑tbaa' sese 'de ‑siɔn' ke ɛɛ' 'cɛ‑wi\" 'a ‑tɩ' 'ʋn. ");
INSERT INTO wob_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Dɛ‑nʋɛ' ‑ta 'mɩɩɛ‑ nʋʋa 'ʋn ɛ, ao se 'ʋn dɛ \"nyɩ 'ɩn se di. ‑Ta \"ni 'natʋn nʋʋa 'ʋn ɛ, ao se 'ʋn \"ni \"nyɩ, 'ɩn se 'na. ");
INSERT INTO wob_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","‑Ta 'ɩn nɩɩa 'dʋɩ‑ ɛ, ao se 'ʋn sɩn 'sɔɔn kpʋʋn‑. ‑Ta 'ɩn cɛɛan kui ɛ, ao se 'ʋn dɛ 'ʋnpaa‑. ‑Ta 'ma dɛ ɛ pooa ao se 'ma ‑tɩ' ‑tu\". ‑Ta 'ɩn nɩɩa ‑kaso 'di ao se 'mi \"i ‑tee'‑. ");
INSERT INTO wob_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","'Bomɔ ʋʋ 'je wluu ka ‑ke : Tʋ\"bo, ‑taka 'mɩɩɛ‑ nɩɩ ‑ma nʋʋa' 'de \"ni 'natʋn a nʋʋ ‑ʋn, 'de 'wɛ‑ ɛ nʋʋ ‑ʋn, 'de ‑ɩn ‑cɛɛn kui, 'de ‑ɩn ‑nɩɩ ‑kaso 'di ‑wɛe ‑a se ‑ma ‑tɩ' ‑tu\" ɛ‑ ? ");
INSERT INTO wob_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","‑Wɛe ɔ 'je nʋ : 'Ma 'tmʋʋɛ ao tɔ' ‑tɩ, dɩ \"klein ao ‑sea \"ju ‑saan\" ka due' \"jrii nʋ 'de 'ma de'di ‑wi\" \"klu ɛ, ‑mɛ 'mɔ ao sɩ \"jrii nʋ. ");
INSERT INTO wob_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","‑Wɛe nyʋ ɔ 'tmʋa wlu ‑nɩa 'mʋa‑ ‑pee, ‑wi\" ‑mʋ 'je 'e 'kle sea \"ti ‑ta 'ble 'ʋn mu, 'de \"isrɛʋn‑wi\" ‑mʋ 'je 'e 'kmʋnɩa' ‑sea' ‑kwɛ ‑ta 'ble 'ʋn mu. ");
INSERT INTO wob_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Sesi ‑kɔa' dɩ \"klein ‑nɩ 'a ‑klɩan' 'sʋ, ɔ wlu' 'de ɔɔ' klai\" nynuu ‑pee. ");
INSERT INTO wob_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","Ɔ 'na : Ao 'je kan' 'mɛ kʋɔnkwla' 'wlʋ‑kɔ siɛ 'wɩ 'sɔɔn, 'de nyiɔ 'ɔ \"Ju a muɛ 'e tooa' ‑wɛe ʋʋ 'je ɔ 'o tu ‑kwlɩ\" kɔ. ");
INSERT INTO wob_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","'De ɛɛ' nɔ\" tu 'di 'sʋ, 'sraa ‑saʋn 'a klae\" o, nyʋ‑cɔɩn' ‑wi\" 'kɩɩɛn \"jrui 'de ʋʋa' klaa\" Kaifʋ o ‑gbɛin\", ");
INSERT INTO wob_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","‑wɛe ka ʋʋ 'jea Sesi 'a kpʋnsʋn nʋ 'de 'srɛ 'ʋn ‑wɛe ʋʋ 'je ɔ 'dba a, 'de ʋʋ 'bɛɛ‑ ɛɛ' wlu 'ʋn. ");
INSERT INTO wob_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","'Sʋ ʋʋ 'na : ɛ 'bo ‑kɔ' wɩ o nɩɛ, ‑wɛe nyʋ ‑wee' \"klein je ɛ 'wɔn 'de ‑kli je 'kpa. ");
INSERT INTO wob_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","‑Ta Sesi nɩa Betani 'de Simɔ ɔ ‑sa 'jrʋwɛ‑ ‑pʋn\" tɛin\" o ‑gbu\" 'di ɛ, ");
INSERT INTO wob_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","'bomɔ 'nynɔkpao' due' 'blee‑ -dai'klɔni 'a ‑sooɛ 'dɔe ‑ɛɛ 'nynɩ nɩa albatrɩ ɛ, ‑wɛe ʋ 'kpa Sesi ‑pʋn\". Ɛɛ' -dai'klɔ tu 'a sɔɔn' kma'. Ʋ \"cnii ɛ \"i 'bo Sesi \"jru ‑mɛ ɔ nɩɛ dɛ dia'. ");
INSERT INTO wob_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Ɔɔ' klai\" nynuu 'jeea dɛ ‑nɩa 'mʋa‑ \"jriɛ‑ 'sʋ ʋʋ 'kpa 'cɛn, ʋʋ 'na : Dɛ ‑ble -dai'klɔ ‑nɛ ‑mɛ 'ɛ dooa' kan' ‑mɔ ɛ‑ ? ");
INSERT INTO wob_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Nyʋ 'beeɛ' ɔ 'je ɛ ple 'de‑, ɛ 'je 'wɛi ‑tuu\"‑tuu 'je 'de nyʋ 'je ɩ nɩɩa\" nyʋ \"nyɩ o. ");
INSERT INTO wob_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Ka ʋʋ nɩa dɛ ‑nɛ 'ɛ 'tmʋa' Sesi 'jea kan' 'sʋ ɛ, ɔ wlu' 'de ʋʋpʋ o ka, ɔ 'na : Dɛɛ‑tɩ aoa wa 'nynɔkpao' ‑nʋ 'kpɩ \"i ɛ‑ ? Ʋ nʋɛ dɛ 'dɔe 'de 'ma ‑tɩ' 'ʋn. ");
INSERT INTO wob_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Ao ke nɩɩa\" nyʋ a muɛ i‑tea' jeejee, 'kaa 'mɔ ke ao se i‑tei jeejee. ");
INSERT INTO wob_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","‑Dai'klɔ ʋ 'wla 'ʋn \"jru ‑ta, ʋ nʋ ɛɛ' dɛ tu 'mɛ 'de 'ma ‑gbaɩn' 'di mua' 'a ‑tɩ' 'ʋn. ");
INSERT INTO wob_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","'Ma 'tmʋʋ aopʋ 'mɛ, ‑ta \"o ‑ta nyʋ a mua ‑pɔia\" ‑tɩ ‑nɩ 'tmʋa' 'de 'blʋa‑ \"kpei ɛ, nyʋ a muɛ 'nynɔkpao' ‑nʋ 'a ‑tɩ' ‑kwlʋ o poa', 'de dɛ ʋ nʋa nyʋ 'je ɛ 'tmʋ. ");
INSERT INTO wob_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","'Sʋ klai\" nynuu ‑nɩa ‑puue 'jɔ 'sɔɔn 'ɔ due' Suida Isikario muɛ 'e 'sraa ‑saʋn 'a klae\" ‑wi\" o. ");
INSERT INTO wob_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","‑Wɛe ɔ wlu 'de ʋʋpʋ o ka, ɔ 'na : ‑Bo 'ɩn nʋɛ ‑wɛe Sesi 'je aopʋ 'kwa 'kpa 'ee, dɛ ao 'je 'ʋn \"nyɩ ɛ‑ ? 'Sʋ ʋʋ ‑sroɛ' 'wɛimɩɩ\" 'a kwla taan ʋʋ je ɔ \"nyɩ. ");
INSERT INTO wob_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Dɛ ‑wlʋa 'de ɛɛ' nɔ\" tu 'di ɛ, Suida a ‑pɔn Sesi 'a kpʋn ‑kɔ i, ‑wɛe ɔ 'je ɔ 'de ʋʋpʋ 'kwa ‑tu\". ");
INSERT INTO wob_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","‑Di'pɛn ‑sea ‑puun\"dɛ o nɩ 'a ‑kɔ 'ɔ \"i‑saa' ‑wɩ \"kpei ɛ, Sesi 'a klai\" nynuu 'kpɔ ‑pʋn\" ‑wɛe ʋʋ ‑teeɛ' ɔ i, ʋʋ 'na : ‑Ta ‑ɩn ‑nɩi\" ‑a ‑je Pakɩ 'a diidɛ pii ɛ‑ ? ");
INSERT INTO wob_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","'Sʋ ɔ 'na : Ao mu 'e ‑kwlɔ, 'de \"ju due' o, ao wlu ɔ ‑pee ao 'na : ‑Aa dɛtɔɔi 'naa : Ɔɔ' nɔ\" nyni' ‑wɛ‑, 'de ‑ɩn o ‑gbu\" 'bomɔ ɔ ke ɔɔ' klai\" nynuu 'je Pakɩ 'a diidɛ dii‑. ");
INSERT INTO wob_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Ka Sesi \"sia 'nynɩ ɛ, 'ka ɔɔ' klai\" nynuu nʋ, ‑wɛe ʋʋ pi Pakɩ 'a diidɛ. ");
INSERT INTO wob_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","‑Fli 'wla 'sʋ ɛ, Sesi ke ɔɔ' klai\" nynuu ‑nɩa ‑puue 'jɔ 'sɔɔn muɛ dɛ dia'. ");
INSERT INTO wob_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","‑Ta ʋʋ nɩɩa dɛ dia' a, 'bomɔ Sesi wluu ka ɔ 'na : tɔ' ‑tɩ 'ma 'tmʋʋ aopʋ, nyɔ due' ‑a mu 'de aopʋ \"klu 'wlʋa' ‑ɔ ‑je 'ʋn ple. ");
INSERT INTO wob_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Ɛ poɛ klai\" nynuu ‑wee' \"si 'nynɩ o, 'sʋ ʋʋ ‑teɛ ɔɔ' i ‑teea' ‑pʋn\" due 'due, jrɔ' 'na : ‑Ɩn se 'mɔ 'da o, Tʋ\"bo ? ");
INSERT INTO wob_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","'Sʋ ɔ 'na : Nyɔ ‑ɔ ‑ke 'ma sʋn plaan 'e ‑gblʋ 'di ɛ, ɔmɔ ‑ɔɔ mu 'ʋn plea'. ");
INSERT INTO wob_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Nyiɔ 'ɔ \"Ju a muɛ 'mɛa' ka ɛ 'crɩɩa 'de ɔɔ' ‑tɩ' 'ʋn see ɛ, 'kaa ɛɛ muɛ \"nmia‑tɩ nɩa' 'de nyɔ ‑ɔɔ mu ɔ plea 'a ‑tɩ' 'ʋn, ɔɔ' \"ju tu 'a ‑ɩn se 'wlʋ \"paa'. ");
INSERT INTO wob_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","'Bomɔ Suida, ‑ɔ ‑je ɔɔ' plea' 'ʋn 'bɔɔ‑ \"duo wlu 'ʋn, ɔ 'na : ɛ 'mɔ ‑ma 'daa, Tʋ\"bo ? 'Sʋ Sesi 'na : ɛɛ' wlu mɛ ‑nao 'de ‑ʋn ‑wɔn, ‑mɔ ‑o. ");
INSERT INTO wob_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","‑Ta ʋʋ nɩɩa dɛ dia' a, Sesi \"duɛ ‑di'pɛn 'ʋn ‑wɛe ɔ po ɛɛ' Kea 'sɛ‑ 'de ɔ cɛɛn ɛ i, ‑wɛe ɔ \"nyɩ ɛ ɔɔ' klai\" nynuu, 'de ɔ 'na : Ao \"duɛ 'ʋn ao di ɛ, ɛ 'ma ku ‑o. ");
INSERT INTO wob_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","‑Wɛe ɔ \"duo nmɔ ‑saan 'a ‑fɛɛ' 'ʋn, 'de ɔ po ɛɛ' Kea 'sɛ‑, ‑wɛe ɔ \"nyɩ ɛ ʋʋpʋ 'de ɔ 'na : Ao ‑wee' \"klein 'nɛ‑, ");
INSERT INTO wob_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","dɛ‑nʋɛ' ɛ 'ma nymɔ ‑o. ɛmɛ ‑si\" ii nyiɔ ke Kea \"i 'bo ‑kɔ' o de, ɛ 'wla i 'de nyʋ ‑tuu\"‑tuu 'a dɩsaɩn 'a ‑kwɛ‑ ‑tɩ' 'ʋn. ");
INSERT INTO wob_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","'Ma 'tmʋʋɛ aopʋ 'mɛ, 'ɩn se nmɔ ‑nɛ 'nai 'bode mamaʋ 'sʋ ɛ 'e 'wɩ ‑ɛ 'di ao ke 'ma ‑a ‑jea nmɔ dee 'naa ‑tadue 'de 'ʋn 'Bo 'a kɛɛma' ‑kwlɔ 'di jɛɛ‑. ");
INSERT INTO wob_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","‑Mɛ 'wlʋa 'o ‑jei\" ɛ Sesi ke ɔɔ' klai\" nynuu 'bleɛ Pakɩ 'a ‑kɔ' dʋ‑ ‑wɛe ʋʋ ‑si' 'de ʋʋ mu 'e olifɩ‑crʋ \"kpei. ");
INSERT INTO wob_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","'Sʋ Sesi wlu' 'de ʋʋ ‑pee ɔ 'na : 'De \"maʋ'wɩ ‑nɩ 'di ɛ, ao ‑wee' \"klein a muɛ 'ʋn 'bɔa', dɛ‑nʋɛ' dɛ ‑crɩɩa 'de 'ma ‑tɩ' 'ʋn, ɛ ka : Kea 'na : 'Ma muɛ nɔ\"dɩ 'dei ‑tei 'dbaa' ‑wɛe 'blae 'je 'kwlɩ i ‑gbaa. ");
INSERT INTO wob_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","'Kaa ‑bo 'ɩn sɔn \"kunyɩɔ' 'ja a, ‑mɛ 'ma muɛ ao \"juɔi ‑sia' 'ɩn 'je 'e Galile mu. ");
INSERT INTO wob_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","'Sʋ Piɛi \"duɛ wlu 'ʋn ɔ 'na : ‑Bo nyʋ ‑wee' \"klein 'bɔ ‑ʋn mɔ 'de ɛ, 'mɔ se ‑ʋn 'bɔi 'nɔ 'kmʋ. ");
INSERT INTO wob_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Sesi 'na : 'Ma 'tmʋʋɛ ‑ʋn tɔ' ‑tɩ ‑cɛɛn'‑, 'de \"maʋ'wɩ ‑nɩa ‑sɩan 'di ɛ, nɔ\" ‑tɩ sʋn\" 'e ‑sro' ɛ, ‑ma muɛ 'ʋn wɔn ‑saa' kpɛ taan, ‑ɩn ‑je nʋ ‑ɩn se 'ʋn juo‑. ");
INSERT INTO wob_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","'Sʋ Piɛi ‑sa wlu de ɔ 'na : ‑Bo ɛ nɩ 'e 'mɛa' 'ʋn mɔ 'de ɛ, ‑ɩn ‑ke 'ma muɛ mua', ɛ se 'mɔ ‑je ‑ʋn wɔn ‑sa nɩ‑. Dɛ due' ‑nɛ, ɛmɛ klai\" nynuu ‑wee' 'tmʋ. ");
INSERT INTO wob_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","'Bo ‑mɛ 'de ɛ, Sesi ke ʋʋ muɛ ‑tajrɔ nyʋ a 'daa‑ Sɛsemane ɛ, ‑wɛe ɔ 'tmʋʋ ʋʋpʋ ɔ 'na : Ao ‑te i ‑ta, 'ma muɛ 'e nya ‑ta 'ɩn 'je bae‑. ");
INSERT INTO wob_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","‑Wɛe ɔ \"duo Piɛi ke Sebede 'a \"nynuu‑ ‑nɩa 'sɔɔn 'ʋn, 'de ʋʋ ke ɔ mu. 'Sʋ dɛ ‑teɛ ɔɔ' 'dii waa' ‑pʋn\", faʋn a nʋɔ', ɔ \"kaeɛ \"jrii. ");
INSERT INTO wob_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","'Sʋ ɔ wlu' 'de ʋʋ ‑pee ɔ 'na : 'Ma ‑suu \"kaeɛ \"jrii mamaʋ 'sʋ 'ma jea 'mɛa' ji. Ao sie ‑ta 'de ao ke 'ma ‑a ‑je \"jriɛ‑ \"i ‑te. ");
INSERT INTO wob_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","‑Wɛe ɔ 'kpaa 'o nya dɛ‑saan\" ka, ɔ tba \"jua i 'bo 'blʋɔ, ɔ bae Kea ka ɔ 'na : 'Ɩn \"Bo, ‑bo ɛ 'bɛɛ‑ ɛ 'je nʋʋɛ ɛ, ‑mɛ ɛ ‑tɛɛn 'ʋn \"kaenmɔ 'ɔ \"pɛ ‑nɛ o, 'kaa 'ma 'tʋn nʋ‑tɩ 'bo nʋʋɛ, ɛɛ' ‑nɩ 'tʋn nʋ‑tɩ mɩ ‑je nʋʋɛ‑. ");
INSERT INTO wob_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","'Sʋ ɔ jiɛ ɔɔ' klai\" nynuu \"i‑tea'. ‑Ta ɔɔ jiia ‑mɛ ʋʋa 'mʋʋ, ‑wɛe ɔ wlu Piɛi ‑pee, ɔ 'na : Ao ke 'ma ‑a se \"jriɛ‑ \"i ‑te mɔ kpɛ due' dɛwɛ‑jɛɛ ? ");
INSERT INTO wob_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Ao ‑te' \"jriɛ‑ \"i, ao 'je bae‑ ‑wɛe ao je 'e dɛsaʋn 'di 'kpa, dɛ‑nʋɛ' tɔ' 'dɔe a ji 'e nyiɔ 'ʋn 'ɛ ‑mɔ, 'kaa ɔɔ' 'blʋku se 'kpɩ 'ble. ");
INSERT INTO wob_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","‑Wɛe ɔ tɛɛn o ke'wlɛ, ɔ mu baea', ɔ 'na : 'Ɩn \"Bo, ɛ se 'bɛɛ‑ \"kaenmɔ 'ɔ \"pɛ ‑nɛ 'je 'ʋn o tɛɛn ‑bo 'ɩn se ɛ naa, ‑mɛ ɛɛ' 'tʋn nʋ‑tɩ mɩ je nʋʋɛ‑. ");
INSERT INTO wob_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","‑Ta ɔɔ jia de ke'wlɛ ɛ, ‑mɛ ɔ jɛɛ ɔɔ' klai\" nynuu \"nyɩɔ', dɛ‑nʋɛ' ʋʋa' \"jri kuɛ kwa. ");
INSERT INTO wob_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","'Sʋ Sesi 'wlʋ 'o ʋʋpʋ ‑pʋn\", ɔ tɛɛn kɩn 'de ɔ bae kpɛ 'ɛ taan ‑nɛ, baewlu due' ‑nɛ 'ɛ 'sʋ mɛ ɔ ‑sa de. ");
INSERT INTO wob_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","'Sʋ ɔ muɛ 'de ɔɔ' klai\" nynuu o de ‑wɛe ɔ wlu 'de ʋʋpʋ o, ɔ 'na : Aoa 'mʋʋ laa, ‑wɛe ao ‑kwlee' ? Ao ‑gbʋn 'nɔ, nɔ\" nyni' ‑wɛ‑, nyiɔ 'ɔ \"Ju pleeɛ' 'de dɛsaʋnʋʋn 'kwa. ");
INSERT INTO wob_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Ao sɔn 'ʋn, ‑a ‑je mu ! Ao ‑gbʋn 'nɔ, \"ju ‑plea' 'ʋn \"kʋʋan‑ i. ");
INSERT INTO wob_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Sesi \"siɛ wlua' 'sʋ Suida ‑nɩa klai\" nynuu ‑nɩa ‑puue 'jɔ 'sɔɔn 'ɔ due' je i \"si, ɔ ke nyʋ ‑tuu\"‑tuu ‑blea ‑cnɩ ke titii ji'. 'Sraa ‑saʋn 'a klae\" ke nyʋ‑cɔɩn' ‑wi\" ‑dbo' ʋʋpʋ. ");
INSERT INTO wob_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Suida ‑ɔ plea Sesi tɔɔɛ nyʋ ‑ke ɔ jia dɛ jrɛ', ɔ 'na : \"Ju 'ma mua ‑kwlɩ\" ‑gblea' 'teɔ ɛ, ‑mɛ ɔmɔ ‑nao, ao kpʋn ɔ. ");
INSERT INTO wob_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","'Bo ɛ \"sri ɔ 'kpaa 'o Sesi ‑pʋn\" 'sʋ ɔ 'na : Tʋ\"bo, 'mɔ ‑je ‑ʋn ! 'Sʋ ɔ ‑gbleeɛ ɔ ‑kwlɩ\". ");
INSERT INTO wob_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","'De Sesi 'na : 'Ɩn ba, dɛ ‑ɩn jia nʋa' a, ‑ɩn ‑too\"‑ ‑ɩn ‑je ɛ nʋ ! 'Sʋ nyʋ ‑ke ɔ jia 'wla 'e Sesi \"kpei ‑wɛe ʋʋ kpʋn ɔ. ");
INSERT INTO wob_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Nyʋ ‑ke Sesi nɩa 'mʋa‑ ʋʋa' due' ‑sa ‑cnɛ kpla' 'sʋ ɔ poo ɛ 'sraa ‑sai klaa\" 'a dbonʋi, ‑wɛe ɔ cɛn ɔ doun\" \"jru. ");
INSERT INTO wob_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","'Sʋ Sesi 'na : ‑Ɩn ‑tu\" ‑ma ‑cnɛ 'de ɛɛ' kpla 'di de, dɛ‑nʋɛ' nyʋ \"klein ‑a ‑dbaa' nyʋ ‑cnɛ 'ʋn ɛ, ʋʋa 'mɛɛ ‑cnɛ \"i. ");
INSERT INTO wob_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","‑Maa naa tɔ' i 'dee, 'ɩn se ɛ 'bɛɛ‑ 'ɩn 'je 'ɩn \"Bo ‑too\"‑ \"ipo, ɔ 'je 'ʋn ɔɔ' \"soa‑wi\" ‑tuu\"‑tuu ja ʋʋ 'je 'ʋn sʋn o poo ? ");
INSERT INTO wob_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","'Kaa ‑bo 'ɩn nʋ kan' ‑mɔ 'ee, ‑mɛ ka dɩ ‑crɩɩa' 'de 'ma ‑tɩ' 'ʋn 'je 'o nynisʋn nʋ ɛ‑ ? ɛmɛ ‑tɩ 'mɔ 'na ka dɩ ‑crɩɩa 'da, 'kamɔ ɩ nʋa 'o ‑ta. ");
INSERT INTO wob_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","‑Wɛe Sesi wlu 'de nyʋ ‑ji' ɔ kpʋan' ‑pee ɔ 'na : Ao 'bleɛ ‑cnɩ ke titii ‑wɛe ao ji 'ʋn kpʋan'. Ɛ ‑kɔ' ‑na 'ɩn nɩɛ \"ku 'dbai ‑o. 'De 'wɩ ‑wee' \"klein 'di 'ɩn ke ao nɩɛ ‑tadue, 'ma tɔɔ aopʋ dɛ 'de Kea ‑gbu klaa\" 'di, 'kaa ao se 'ʋn sʋn ‑pʋn\" ‑te' 'bomɔ. ");
INSERT INTO wob_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","'Kaa ɩa' dɩ tu nʋʋɛ' ‑wɛe dɩ Kea 'a wlu 'kwajaaʋn 'tmʋa 'de ɛ, 'de ɩ 'je 'o nyni. 'Sʋ ɔɔ' klai\" nynuu ‑wee' siɔ', ʋʋ 'kpa 'kwla. ");
INSERT INTO wob_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Nyʋ ‑kpʋan' Sesi ɛ, ʋʋ kpɔ 'e Kaifʋ ‑nɩa 'sraa ‑sai klaa\" wɔin\", 'demɔ kɛ' wɔ‑saʋn o, nyʋ‑cɔɩn' ‑wi\" 'kɩɩn‑ \"jrui. ");
INSERT INTO wob_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Piɛi bla ʋʋpʋ bʋ ‑kɔ woi mamaʋ 'sʋ ɔ ke ʋʋ je 'e 'sraa ‑sai klaa\" o ‑gbɛin\" pa, 'de ɔ ‑te i 'bo nyʋ \"klu ‑wɛe ɔ 'je ɛɛ' ja ‑kwɛ ‑sʋn 'a ‑ta 'je. ");
INSERT INTO wob_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","'Sraa ‑saʋn 'a klae\" o, 'pee 'jeʋn klae\" a ‑pɔn Sesi 'a sɩ‑tɩ \"kpei 'nɛɛ ‑kɔ i, ‑wɛe ʋʋ 'je ɔ 'dba. ");
INSERT INTO wob_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","'Kaa ʋʋ se dɛ jrɛ' 'je, 'de ‑mɛ 'kamɔ sɩ 'tmʋʋn ‑tuu\"‑tuu ‑kwɛ‑ de. 'Sʋ ʋʋa' 'sɔɔn ji', ʋʋ 'na : ");
INSERT INTO wob_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","\"Ju ‑nɔ wlu' ɔ 'na : 'Ɩn 'beeɛ' 'ɩn 'je Kea ‑gbu klaa\" \"jɛi ‑gba' ‑wɛe 'ɩn 'je ɛ po 'de 'wɩ taan ‑gbai' 'di. ");
INSERT INTO wob_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","'Sʋ 'sraa ‑sai klaa\" sɔn 'ʋn 'ɛ, ‑wɛe ɔ wlu Sesi ‑pee ɔ 'na : Dɩ nyʋ ‑nʋ a bla ‑ʋn \"kpei ‑ta a, ‑maa' ‑sa 'e wlu mɔ ‑wee'‑ ? ");
INSERT INTO wob_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","'Kaa Sesi \"muɛ wɔn, 'sʋ 'sraa ‑sai klaa\" 'na : 'De Kea ‑nɩa 'kmʋ 'a 'nynɩ 'ʋn 'ma ‑teeɛ ‑mii, ‑bo ‑ɩn ‑nɩ Nyʋ'pʋʋi Klisɩ, Kea 'a \"Ju ɛ, ‑mɛ ‑ɩn ‑tmʋ ɛ 'de ‑a ‑pee. ");
INSERT INTO wob_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","'Sʋ Sesi 'na : ɛmɛ ‑ɩn ‑tmʋa 'o. 'De 'ma 'tmʋʋɛ aopʋ 'mɛ, aoa muɛ nyiɔ 'ɔ \"Ju 'jea' la 'bode, ɔ 'je i ‑te 'de \"ikma Kea 'a dianfɔ o, aoa mu ɔ 'jea' ke'wlɛ ɔ 'e de ji 'bo jaʋn‑kwlʋ 'bo bue\" \"kpei. ");
INSERT INTO wob_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","'Sʋ 'sraa ‑sai klaa\" ‑nɔ 'kpa 'cɛn, ɔ 'faeɛ ɔɔ' ‑cɛ\" 'kpa 'a 'ʋnpaadɩ i, ‑wɛe ɔ wlu 'de nyʋ ‑kwɛa de ‑pee ɔ 'na : ɔ doa Kea 'a 'nynɩ ‑wɛ‑, dɛ ‑ble ‑tɩ 'a ‑ta 'jeʋn i ‑pɔan' 'bode ɛ‑ ? Ka ɔɔ toa Kea wɔn o ɛ, ɛmɛ ‑jia' 'o 'de ɔɔ' ‑cɛ\" 'kpa 'wɔn. Ka aoa 'da a‑ ? ");
INSERT INTO wob_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Ʋʋ ‑wee' \"klein 'na : ɔ nɩɛ 'mɛ ka‑. ");
INSERT INTO wob_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","'Bo ‑mɛ \"kpei 'mʋa‑ 'sʋ ʋʋ ‑teɛ ɔɔ' tɔn \"jri wlaan' ke blaa' ‑pʋn\", ʋʋa tbɔɔ kpiin' i, ‑wɛe ʋʋa wlɔɔ 'de ʋʋ 'na : ");
INSERT INTO wob_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","‑Mɔ ‑na ‑ɔ ‑nɩɛ Nyʋ'pʋʋi ɛ, ‑ɩn ‑si' dɩ, nyɔ tba ‑ʋn kpʋan' ‑ɩn ‑si\" ɔɔ' 'nynɩ. ");
INSERT INTO wob_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","‑Ta ɛɛ nʋa kan' a, ‑mɛ Piɛi ‑teɛ i 'de \"kpae' 'bo nyʋ \"klu. 'Sraa ‑sai klaa\" 'a dbonʋnynɔkpao' due' 'kpɔ ‑pʋn\" 'sʋ ʋ 'na : ‑Mɔ ‑nɔ ‑ɩn ‑ke Sesi ‑wlʋa Galile ‑nɔ na' ‑ke. ");
INSERT INTO wob_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Piɛi ‑Sɔ wɔn 'bo nyʋ \"juɔi. Ɔ 'na : Dɛ a nɩa \"i a 'jea 'tmʋ ‑gblein' 'maa 'wɔn ɛ 'mii. ");
INSERT INTO wob_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Ɔ sɔn 'ʋn 'ɛ 'sʋ ɔ muɛ 'e ‑gbɛin\" ‑jei\" fɔ o. Dbonʋnynɔkpao' jrʋ' 'je ɔ ke'wlɛ 'sʋ ʋ wlu' 'de nyʋ ‑ʋʋ ‑ke ʋ nɩa 'o ‑pee, ʋ 'na : \"Ju ‑nɔ, ɔ ke Sesi ‑wlʋa Nasarɛtɩ na' ‑ke. ");
INSERT INTO wob_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Piɛi ‑too' ke'wlɛ ɔ ‑teɛ ‑snɛɛa' ‑pʋn\" ɔ 'na : Sɩ ‑o. 'Ɩn se \"ju ‑nɔ juo‑. ");
INSERT INTO wob_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Nɔ\" jrɛ' ‑sia' ‑paii 'sʋ nyʋ ‑ke ɔ nɩa 'mʋa‑ 'kpɔ ‑pʋn\" ‑wɛe ʋʋ wlu ɔ ‑pee, 'de ʋʋ 'na : Tɔ' ‑o ‑cɛɛn'‑, ‑ɩn ‑nɩɛ nyʋ ‑nʋ 'a due' ‑o, dɛ‑nʋɛ' ‑ma wlusʋn mɛ ‑sa ‑ʋn 'kwla. ");
INSERT INTO wob_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","'Sʋ Piɛi \"duɛ wlu 'ʋn ɔ 'na : 'Ɩn se \"ju ‑nɔ juo‑, ‑bo 'ɩn 'tmʋ sɩ ɛ, Kea nʋ 'ʋn dɛ \"jrii. 'Bomɔ ɛ \"sri 'sʋ sʋn\" due' ‑sro'. ");
INSERT INTO wob_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","'Sʋ Piɛi poɛ Sesi 'a wlu ‑kwlʋ o ‑ɛ ‑na : nɔ\" ‑tɩ sʋn\" 'e ‑sro' ɛ, ‑ma muɛ wlua' kpɛ taan ‑ɩn ‑je nʋ ‑ɩn se 'ʋn juo‑. 'Sʋ ɔ ke ‑fɩn\" 'a \"siɛ \"kpae'. ɔ ‑fɩɩn\" mamaʋ 'sʋ ɔɔ' wɔn 'di je i \"kae‑. ");
INSERT INTO wob_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","‑Sɔn' ‑sɩan' ‑klae\" pɛɛn 'sʋ 'sraa ‑saʋn klae\" ke nyʋ‑cɔɩn' ‑wi\" 'kɩɩɛn \"jrui ‑wɛe ʋʋ 'bɛɛ‑ Sesi 'a 'mɛ ‑tɩ 'a wlu 'ʋn. ");
INSERT INTO wob_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","‑Wɛe ʋʋ sɔn, ʋʋ kpɔ 'de ʋʋ \"nyɩ ɔ ‑gbʋa'na Pilatɩ 'de ɔ 'je 'o wlu cɛn. ");
INSERT INTO wob_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","‑Ta Suida ‑toa 'e Sesi 'jea ka ʋʋa kpɔ ʋʋ 'je ɔ 'dba 'sʋ, ɔɔ kple' ‑wɛe ɔ kpa 'wɛijɔ mɩɩ\" 'a kwla taan ‑nɩ 'de 'sraa ‑saʋn 'a klae\" ke nyʋ‑cɔɩn' ‑wi\" o de ɔ 'na : ");
INSERT INTO wob_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","'Ma 'cɛ, 'ɩn nʋɛ dɛsaʋn, dɛ 'ɩn toa 'e \"ju ‑sea' 'mɛ ka nɩ ‑ta a. 'De ʋʋ 'na : Dɛ ‑mɛ 'daa ‑apʋ mɔ ɛ‑, ‑ma 'sʋ 'a ‑tɩ' ‑nao. ");
INSERT INTO wob_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Suida kpa 'wɛijɔ ‑nɩ 'sʋ ɔ ‑fii\" ɩ 'de Kea ‑gbu klaa\" 'di, ‑wɛe ɔ mu 'de ɔ po ɔɔ' ‑cɛ\" \"dbu ‑plun, ɔ 'mɛ. ");
INSERT INTO wob_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","'Sraa ‑saʋn 'a klae\" ‑wi\" 'tɛn 'wɛi ‑nɩ 'mɛ, ‑wɛe ʋʋ 'na : ‑Aa kɛ' 'na nyɔ 'ɔ po 'wɛi ‑nɩa ka 'de Kea ‑gbu klaa\" 'a 'wɛi i ‑tedɛ 'di, dɛ‑nʋɛ' ɩ nɩɛ nymɔ 'ɔ sɔɔn' ‑o. ");
INSERT INTO wob_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Ʋʋa' 'sʋ 'bɛɛa ɩa' wlu 'ʋn 'sʋ ɛ, ʋʋ ‑tɩɩn' jaemai 'a ‑kle', ‑wɛe ʋʋ 'je ɛ 'dʋɩ‑ 'a inmae‑ta 'ʋn nʋ. ");
INSERT INTO wob_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Ɛmɛ ‑tɩ ‑kle' ‑nɛ, ʋʋa 'daa‑ ɛɛ' ‑kle' tu nymɔ ‑kle mamaʋ ‑sɩan. ");
INSERT INTO wob_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","'Sʋ dɛ Kea 'a wlu 'kwajaai Selemi 'tmʋa 'de ɛ, ɛ nyni 'o 'ɛ, ɔ 'naa : ʋʋ \"duɛ 'wɛijɔ mɩɩ\" 'a kwla taan 'ʋn, ɩmɩ Israɛ‑nyʋ 'bɛɛ‑ wlu \"kpei 'de ‑ɩ ‑nɩ ɔɔ' sɔɔn', ");
INSERT INTO wob_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","‑wɛe ʋʋ \"duo ɩa' 'wɛi tu 'ʋn 'de ʋʋ ‑tɩɩn' jaemai 'a ‑kle', ka Tʋ\"bo 'tmʋ ɛ 'de ɛ. ");
INSERT INTO wob_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Sesi nɩɛ 'o ‑gbʋa'na \"juɔi ‑wɛe ɔ ‑tee' ɔ i ka ɔ 'na : ‑Ɩn ‑nɩɛ Suifʋ‑wi\" 'a 'beɔ ‑oo ? 'Sʋ Sesi 'na : ɛmɛ ‑ɩn ‑tmʋa 'o. ");
INSERT INTO wob_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","'Kaa sɩ‑tɩ 'sraa ‑saʋn 'a klae\" o, nyʋ‑cɔɩn' ‑wi\" a ‑tu\" ɔ \"kpei ɛ, ɔ se ‑mɩ wɔn \"kpei po. ");
INSERT INTO wob_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","'De Pilatɩ 'na : Dɩ ‑tia ‑ka ʋʋa ‑tua\" ‑ʋn \"kpei i ‑ta ‑maa' 'wɔɩɩn ? ");
INSERT INTO wob_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","'Kaa Sesi se ɔ dɛ jrɛ' ‑pee 'tmʋʋ 'bode. ‑Mɛ \"maa ‑gbʋa'na tai'. ");
INSERT INTO wob_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Pakɩ 'a ‑kɔ' \"o ‑kɔ' ‑sɔn ɛ, ‑gbʋa'na a \"siiɛ ‑kaso'dii due' i see, ‑jɔ nyʋ ‑kwɛa de nɩa \"i ɛ. ");
INSERT INTO wob_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","'De ɛɛ' nɔ\" tu 'di ɛ, ‑kaso'dii due' ‑ɔɔ 'nynɩ nɩ Barabasɩ. ɔɔ' 'nynɩ dooa' 'de ɔɔ' \"ku 'dba‑tɩ 'ʋn. ");
INSERT INTO wob_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","'Sʋ Pilatɩ ‑teeɛ' nyʋ ‑kɩɩan' \"jrui i, ɔ 'na : Nyɔ ao nɩ \"i 'ɩn 'je i \"sii ɛ‑ ? Barabasɩ ‑ae, ‑ɩn\" Sesi ʋʋa 'daa‑ Klisɩ ɛɛ ? ");
INSERT INTO wob_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Ɔ 'je kan' 'mɛ, ka ʋʋa nʋa Sesi \"cɛi o ‑wɛe ʋʋ to ɔ 'e ɛ. ");
INSERT INTO wob_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","‑Ta Pilatɩ ‑tea i 'bo 'pee 'jeɩn' ɛ, 'bomɔ ɔɔ' 'nynɔ dbo ɔ nyʋ \"i, ʋ 'na : Dɛ‑saan\" 'bo 'o ‑ɩn ‑ke \"isrɛi ‑nɔ 'nynɩ nɩɛ, dɛ‑nʋɛ' ɔ ‑srɛi\", 'ɩn 'jeɛ 'kle ‑sɩan 'de ɔɔ' ‑tɩ' 'ʋn 'de jajri 'di. ");
INSERT INTO wob_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","'Sraa ‑saʋn 'a klae\" o, nyʋ‑cɔɩn' ‑wi\" paa nyʋ ‑kwɛa de bʋ ‑sɔn ‑wɛe ʋʋ 'je Barabasɩ 'a i \"sii ‑tɩ i ‑tee'‑, 'de ʋʋ 'je Sesi 'dba. ");
INSERT INTO wob_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","‑Wɛe ‑gbʋa'na \"duo wlu 'ʋn 'de ɔ ‑tee' ʋʋpʋ i ke'wlɛ ɔ 'na : Nyɔ ao nɩ \"i 'ɩn 'je i \"sii ɛ‑ ? 'Sʋ ʋʋ 'na : Barabasɩ. ");
INSERT INTO wob_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","'De ɔ 'na : Ka 'ɩn 'je Sesi nyʋ a 'daa‑ Klisɩ ‑mɔ 'ɔ ‑tɩ' nʋ ɛ‑ ? ʋʋ ‑wee' \"klein 'na : ‑Ɩn kɔ ɔ 'o tu ‑kwlɩ\". ");
INSERT INTO wob_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","'Sʋ Pilatɩ ‑teeɛ' ʋʋpʋ i, ɔ 'na : Dɛsaʋn ‑jɛ wɛ‑ ɔ nʋ ɛ‑ ? 'Kaa ʋʋa \"wɔɔ' ke'wlɛ ɛ je ‑je \"kpei ‑tie\" cɛn, ʋʋ 'na : ‑Ɩn kɔ ɔ 'o tu ‑kwlɩ\" ! ");
INSERT INTO wob_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Dɛ Pilatɩ 'jea 'je 'de ɛɛ' dɛ tu 'a ‑kɔ' 'di sea nɩ ‑wɛe ʋʋa' ‑cruɛn\" ɛ 'kpaa \"kpei 'sʋ ɛ, ɔ \"duɛ \"ni 'ʋn ‑wɛe ɔ jre kwa 'bo nyʋ ‑wee' \"klein \"juɔi, 'de ɔ 'na : \"Isrɛi ‑nɔ 'ɔ nymɔ se 'ʋn kwai nɩ. Aoa' 'sʋ 'a ‑tɩ' ‑o. ");
INSERT INTO wob_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","'Bo ʋʋ ‑wee' \"klein 'na : ‑Bo ɛ nʋ dɛ 'de ɛ, ɔɔ' nymɔ 'ɔ ‑kao ‑craa ‑a ‑ke ‑aa \"nynuu‑ 'ʋn. ");
INSERT INTO wob_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","'Sʋ Pilatɩ \"siiɛ‑ Barabasɩ i. Ɔɔ' \"soa‑wi\" kpa Sesi klae 'ʋn kpɩɩn‑, ‑wɛe ɔ to ɔ 'e 'de ɔ 'je 'o tu ‑kwlɩ\" kɔɔɛ‑. ");
INSERT INTO wob_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","‑Gbʋa'na 'a \"soa‑wi\" kpa Sesi 'de ɔ o ‑gbu\" 'di, 'bo ɔɔ' ‑gbɛin\" 'a ‑kwea'‑, ‑wɛe ʋʋ ‑gbae' ɔ 'dei. ");
INSERT INTO wob_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Ʋʋ ‑sɔ dɩ kui ‑wɛe ʋʋ pɔɔ flae' ‑saan 'ʋn. ");
INSERT INTO wob_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Ʋʋ dba \"wifan ‑wɛe ʋʋ ‑tu\" ɔ \"jru. Ʋʋ ‑tu\" ɔ ‑gblokpau 'kwa, ‑wɛe ‑bo ʋʋ \"sii‑ 'kɔi‑ i 'bo ɔ \"juɔi ɛ, ʋʋa wlɔɔ, ʋʋa nʋ : ‑A 'snɛ, ‑a 'snɛ Suifʋ‑wi\" 'a 'beɔ ! ");
INSERT INTO wob_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","‑Wɛe ʋʋa wlɔn tɔn \"jri, ‑wɛe ‑bo ʋʋ ‑sɔ ‑gblokpau 'kwa a, ʋʋa blɛ 'bo ɔ \"jru. ");
INSERT INTO wob_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Ʋʋ ‑kɔa' ɔɔ' wlaa' kan' 'sʋ ɛ, ʋʋ ‑sɔ flae' 'ʋn, ʋʋ pɔɔ ɔɔ' dɩ 'ʋn 'de ʋʋ kpɔ 'o tu ‑kwlɩ\" kɔɔa'. ");
INSERT INTO wob_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","‑Ta ʋʋa \"sia \"kpae' ɛ, 'bomɔ ʋʋ ke Sirɛnɩi due' ‑gbʋʋn', ɔɔ' 'nynɩ ‑nɩ Simɔ. 'Sʋ ʋʋ kpʋɔn' \"klan ‑klan \"klan ‑wɛe ɔ 'e Sesi 'a 'mɛtu 'ble. ");
INSERT INTO wob_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Ʋʋ nynia 'o ‑ta nyʋ a 'daa‑ Gogota, ɛ 'de mɛ ‑nɩ \"jru 'a 'kpa 'a ‑ta. ");
INSERT INTO wob_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","'Sʋ ʋʋ \"nyɩɛ Sesi nmɔ ʋʋ poa \"kaedɛ o ɛ, 'kaa ɔ ‑tɩn ɛ wɔn 'sʋ ɔ 'na ɔ se ɛ 'nai. ");
INSERT INTO wob_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Ʋʋ kɔ ɔ 'o tu ‑kwlɩ\" la 'sasa ‑wɛe ʋʋ po soa' ʋʋ ‑seea ɔɔ' 'ʋnpaadɩ 'ʋn 'bo ʋʋpʋ 'nynɩ. ");
INSERT INTO wob_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","'Sʋ ʋʋ ‑teɛ i ‑wɛe ʋʋa fuo ɔ i. ");
INSERT INTO wob_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Ʋʋ ‑nɩɛi\" ʋʋ 'jea dɛɛ‑tɩ ɔ 'mɛa 'tmʋ ɛ, dɛ ʋʋ 'crɩa 'bo ɔ \"jru kpɔ', ɛ ka : \"Ju ‑nɔ Suifʋ‑wi\" 'a 'beɔ Sesi ‑o. ");
INSERT INTO wob_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Ɔ ke \"ku 'dbaʋn 'sɔɔn ‑kɔɔɛ 'bo tu ‑kwlɩ\", due' 'bɔɔ‑ 'de ɔɔ' dianfɔ o, ‑wɛe due' 'bɔɔ‑ 'de ɔɔ' kʋaanfɔ o. ");
INSERT INTO wob_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","‑Jesiʋn a ‑fuan\"‑ \"jru ‑wɛe ʋʋa ‑cree\" ɔ. ");
INSERT INTO wob_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","ʋʋ 'na : ‑Mɔ ‑jea Kea ‑gbu klaa\" \"jɛi ‑gba 'de ‑ɔ ‑je ɛ po 'de 'wɩ taan 'di ɛ, ‑ɩn ‑pʋʋ' ‑ma ‑cɛ\" la 'e ! ‑Bo ‑ɩn ‑nɩ Kea 'a \"Ju ɛ, ‑ɩn ‑wlʋ 'o tu ‑kwlɩ\" ‑ɩn ‑je i \"si ! ");
INSERT INTO wob_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","'Sraa ‑saʋn 'a klae\" ke kɛ' wɔ‑saʋn ke nyʋ‑cɔɩn' ‑wi\" a wlɔɔ' ka ‑ke, ʋʋ 'na : ");
INSERT INTO wob_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","Ɔ 'pʋʋ‑ nyʋ jrʋ' 'mɛ, 'kaa ɔ se ɔɔ' ‑cɛ\" 'kpa 'pʋʋa' 'bɛɛ‑ ! ‑Bo ɔ nɩ Israɛ‑kɔʋn 'a 'beɔ ɛ, ‑mɛ ɔ 'wlʋ 'o tu ‑kwlɩ\" ɔ 'je i \"si ‑wɛe ‑a ‑je ɔɔ' ‑tɩ' tɔ' 'ʋn 'je. ");
INSERT INTO wob_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Ɔ ‑teɛ ɔɔ' ‑cɛ\" Kea kwa, ‑bo Kea kma ɔɔ' ‑tɩ' ɛ, ‑mɛ ɛ ‑sei ɔ la ‑a ‑je ɛ 'je, dɛ‑nʋɛ' ɔ 'na : 'Ɩn nɩɛ Kea 'a \"Ju ‑o. ");
INSERT INTO wob_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","\"Ku 'dbaʋn ‑ʋʋ ‑ke ɔ kɔɔa 'bo tu ‑kwlɩ\" ʋʋa ‑cree\" ɔ kan' ‑ke. ");
INSERT INTO wob_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","'Jrʋ‑gbao 'sʋ kwie kpʋn' ‑plipli 'de 'blʋa ‑wee' \"klein \"kpei mamaʋ 'sʋ ɛ je ‑kwie\" jrʋ‑gbao jɛɛ‑. ");
INSERT INTO wob_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","‑Kwie\" jrʋ‑gbao o 'sʋ Sesi kpa wlu \"jɛi, ɔ \"wɔɔ', ɔ 'na : Eli, Eli, lama sabatani ? Ɛ 'de mɛ ‑nɩ : 'Ma Kea, 'ma Kea, dɛɛ ‑tɩ ɛ ‑sa 'ʋn \"jriɛ‑ ‑pʋn\" ɛ‑ ? ");
INSERT INTO wob_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Nyʋ ‑nɩa 'o a jrʋ' 'wɔan ɔɔ' wlu 'sʋ ʋʋ 'na : Ao 'bɔ, ɔɔ 'da Eli. ");
INSERT INTO wob_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","'Bo ɛ \"sri ʋʋa' due' je plea' kpa ɔ je fuu' 'de ‑koonmɔ o ibla ɔ je ɛ ‑gblokpau \"icroo 'sʋ ɔ je Sesi \"nyɩ 'de ɔ 'je ɛ 'na. ");
INSERT INTO wob_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","'Kaa ʋʋa' deejrʋ' 'na : ‑Ɩn ‑tai\" ɔ \"i, 'bomɔ ‑aa ‑gbʋan 'o ‑bo Eli ji ɔ 'o ‑saa' kan' a. ");
INSERT INTO wob_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Sesi \"wɔa kpleiin ke'wlɛ 'sʋ ɔ ‑kwɛ‑ \"i. ");
INSERT INTO wob_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Ɛ nɩa kan' 'sʋ \"wliiɛ fɔ klaa\" ‑peea' 'de Kea ‑gbu klaa\" 'di ‑sa 'faea' 'de \"jɛi mamaʋ 'sʋ ɛ je 'e ‑sɔn nyni, 'blʋa‑ crɛ', \"soi klae\" sɔn 'fɔe. ");
INSERT INTO wob_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","‑Gbɛin\" kaiɛn wɔn, \"isrɛʋn ‑mɛa 'a 'pla sɔn \"kunyɩɔ'. ");
INSERT INTO wob_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Ʋʋ 'wlʋ 'e ‑gbaɩn' 'di 'mɛ, ‑wɛe ‑ta Sesi sɔan \"kunyɩɔ' ɔ, ʋʋ pa 'o Selisalɛm. 'Bomɔ nyʋ ‑tuu\"‑tuu 'jee‑ ʋʋpʋ \"jriɛ‑. ");
INSERT INTO wob_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Rɔmɛ \"soa 'a \"jrukpɔ' i ‑tei due' ‑ɔ ‑ke ɔɔ' \"soa‑wi\" a fua Sesi i ɛ, ʋʋ 'jeea 'blʋa 'a crɛsʋn ke dɩ \"klein ‑nʋʋa \"jriɛ‑ 'sʋ, dɛ waa ʋʋpʋ 'dii, faʋn ‑teɛ ʋʋa' nʋa' ‑pʋn\" 'sʋ ʋʋ 'na : tɔ' ‑tɩ ‑o, \"ju ‑nɔ nɩɛ Kea 'a \"ju 'a ‑cɛ\" 'kpa ‑o ‑cɛɛn'‑. ");
INSERT INTO wob_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","'Nynʋkpae' jrʋ' ‑nɩ 'o, ‑ʋʋ ‑tɛɛn o ‑wɛe ‑ʋʋa ‑gbʋn 'e. ʋʋa' 'nynʋkpae' tu ke Sesi 'wlʋɛ 'e Galile ‑gbɔ, ‑wɛe ʋʋa ‑te' ɔ kwa wɔi. ");
INSERT INTO wob_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","'De ʋʋpʋ \"klu, 'bomɔ Madi ‑wlʋa Madala ke Sakɩ ke Sosɛʋ de Madi ke Sebede 'a \"nynuu‑ de nɩ‑. ");
INSERT INTO wob_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","‑Kwie\" ka 'sʋ ɛ, \"wliiɛjei due' ‑wlʋ Arimate ‑ɔ ji, ɔɔ' 'nynɩ ‑nɩ Sosɛʋ, ɔ nɩɛ Sesi 'a klai\" nynuu 'a due' ‑o ‑ke. ");
INSERT INTO wob_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Ɔ muɛ 'e Pilatɩ o, ‑wɛe ɔ ‑tee' ɔ Sesi 'a \"ku i. 'De Pilatɩ cɛn 'o wlu ‑wɛe ʋʋ 'je ɔ Sesi 'a \"ku \"nyɩ. ");
INSERT INTO wob_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Sosɛʋ \"duo Sesi 'a \"ku 'ʋn 'ɛ, ɔ \"fin ɔ tae' plu \"jrui, ");
INSERT INTO wob_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","‑wɛe ɔ ‑te ɛ i 'de ɔɔ' ‑gbaɩn' dee ‑ɛ ‑blua\" 'de 'soacrʋ 'di 'di, ‑wɛe ɔ klin o \"soukpo klaa\" due' i. Ɔ kaan 'bo ɛ \"wɔin ‑wɛe ɔ mu. ");
INSERT INTO wob_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Madi ‑wlʋa Madala ke Madi jrʋ' nɩ 'o 'wɛ‑, ʋʋ ‑teɛ i ‑wɛe ʋʋa ‑gbʋn 'e ‑gbaɩn' \"jri. ");
INSERT INTO wob_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Dɩ nmaewɩ 'wlʋa 'bo ‑jei\", ɛɛ' ‑sɔn' ‑sɩan' 'sʋ ɛ, 'sraa ‑saʋn 'a klae\" ke Fariseɛn‑wi\" muɛ 'e Pilatɩ o ‑tadue ‑wɛe ʋʋ 'na : ");
INSERT INTO wob_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","‑Gbʋa'na, ‑ta sɩ 'tmʋi ‑nɔ nɩɩa 'kmʋ 'de ɛ, dɛ ɔ 'tmʋa ɛmɛ ‑a po ‑kwlʋ o, ɔ 'na : ‑Bo 'ɩn 'mɛ ɛ, 'wɩ 'a taan ‑nɛ \"kpei ‑mɛ 'ma muɛ 'ʋnsɔan'. ");
INSERT INTO wob_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","‑Ɩn ‑tmʋʋ' nyʋ ʋʋ 'je ɔɔ' ‑gbaɩn' ifuo mamaʋ 'sʋ 'wɩ 'a taan ‑nɛ 'je nyni, ‑wɛe ɔɔ' klai\" nynuu je ɔɔ' \"ku \"jri, 'de ʋʋ je wlu 'de nyʋ ‑pee ka ɔ sɔn \"kunyɩɔ'. ‑Bo ɛ nɩ kan' a, ‑mɛ ɩa' sɩ tu a muɛ ‑jei\" ‑sia', ɩ 'e ‑jɩ ‑nɩa tɛin\" ‑sii. ");
INSERT INTO wob_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","'Sʋ Pilatɩ wluɛ ʋʋ ‑pee ɔ 'na : \"Soa‑wi\" ka, ao mu, ao fuo ɔ i ka aopʋ ‑nɩɛi\" ɛ. ");
INSERT INTO wob_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Ʋʋ mua, ʋʋ \"suɛn \"soukpo ‑kaan 'o ‑gbaɩn' \"wɔin 'dei ‑wɛe ʋʋ ‑piiɛn' \"soa‑wi\" ʋʋa fuo ɛ i. ");
INSERT INTO wob_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","‑Kwlewɩ 'wlʋa 'o ‑jei\" ‑ɛ ‑nɩa 'dɔɔ 'ɔ \"i‑saawɩ o 'sʋ ɛ, Madi ‑wlʋa Madala ke Madi jrʋ' ‑cnuɛn 'e ‑gbaɩn' \"kpei. ");
INSERT INTO wob_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Ʋʋa kɔan 'emu 'sʋ 'blʋa‑ a crɛ', dɛ‑nʋɛ' Tʋ\"bo 'a \"soai due' ‑wlʋ 'e jaʋn 'di ‑ɔ ‑si\" i ‑wɛe ‑ɔ klin ‑o \"soukpo ‑nɩa 'o ‑gbaɩn' \"wɔin ‑ɔ poɛ 'fɔ jrɛ' o, ‑wɛe ‑ɔ ‑ja 'o ɛ \"kpei ‑ɔ ‑te i. ");
INSERT INTO wob_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Ɔ ‑taan' ka \"ni a crɛa \"jrii ɛ, ɔɔ' 'ʋnpaadɩ \"pluu' \"puu'‑ ka jee\" ‑fua\" nɩa. ");
INSERT INTO wob_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Dɛ waa \"soa‑wi\" 'dii ʋʋa' dɩ a crɛ' ka nyɔ ɔ 'mɛa, 'kamɔ ʋʋpʋ nɩ‑. ");
INSERT INTO wob_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","'Sʋ Kea 'a \"soai wlu' 'de 'nynʋkpae' ‑pee ɔ 'na : Aopʋ mɔ ɛ, faʋn 'bo ao nʋɛ, dɛ‑nʋɛ' 'ɩn 'je kan' 'mɛ, Sesi ʋʋ kɔa 'bo tu ‑kwlɩ\" mɔ aoa ‑pɔn i. ");
INSERT INTO wob_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Ɔ se ‑ta nɩ‑, ɔ sɔn \"kunyɩɔ' ka ɔ 'da 'de ɛ. Ao ji 'je, ‑ta ɔ 'pɛan i 'de ɛ, 'bo ka. ");
INSERT INTO wob_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Ka ɔ sɔan \"kunyɩɔ', ao mu ‑too\"‑ ao 'je ɔɔ' klai\" nynuu 'tmʋʋ‑. Ɔ muɛ ao \"juɔi ‑sia' ɔ 'je 'de Galile mu 'demɔ ao 'je ɔ \"jriɛ‑ 'jee‑. Ka 'ma 'wlʋ ɛ 'tmʋa' a, 'kamɔ ɛ 'je nɩ‑. ");
INSERT INTO wob_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Ʋʋ crɛɛ \"kpei ʋʋ je 'o ‑gbaɩn' ‑pʋn\" 'wlʋ, faʋn a nʋ ʋʋpʋ 'mɛ, 'de ‑mɛ 'kamɔ 'mʋa‑ klaa\" nɩ 'de ʋʋa' pɛe o. 'Sʋ ʋʋ kpa plea' ‑wɛe ʋʋ po klai\" nynuu \"kuan. ");
INSERT INTO wob_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Ʋʋa kɔan 'emu 'sʋ Sesi 'jaa ʋʋpʋ \"i ‑wɛe ɔ 'na : 'Mɔ ‑je aopʋ ! ʋʋ 'kpɔ ‑pʋn\" 'sʋ ʋʋ ‑gblee' ɔ bʋ wɔ, ‑wɛe ʋʋ ‑gbɛɛ ɔ \"juɔi. ");
INSERT INTO wob_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","'Sʋ Sesi 'na : Faʋn 'bo aopʋ nʋɛ, ao mu ao 'je 'ma de'di ‑wi\" ‑kwlʋ ‑seea', ʋʋ 'je 'e Galile mu 'demɔ ʋʋ 'je 'ʋn \"jriɛ‑ 'jee‑. ");
INSERT INTO wob_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Ʋʋ siiɛ mua' 'bo ‑jei\" 'sʋ nyʋ ‑fua Sesi 'a ‑gbaɩn' i ʋʋa' jrʋ' je 'e ‑kwlɔ nyni ‑wɛe dɩ \"klein ‑nʋʋa ʋʋ je ɩa' \"kuan po 'de 'sraa ‑saʋn 'a klae\" ‑wi\" o. ");
INSERT INTO wob_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","'Sraa ‑saʋn 'a klae\" ke nyʋ‑cɔɩn' ‑wi\" 'kɩɩɛn \"jrui ‑wɛe ʋʋ 'bɛɛ‑ wlu 'ʋn, 'de ʋʋ \"nyɩ \"soa‑wi\" 'wɛi ‑tuu\"‑tuu. ");
INSERT INTO wob_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","‑Wɛe ʋʋ wlu 'de ʋʋ o, ʋʋ 'na : ‑Bo ao mu ɛ, ‑mɛ ao 'na : ‑ta ‑a ‑nɩa \"nyɩɔ' \"maʋ' 'bomɔ ɔɔ' klai\" nynuu jii ‑wɛe ʋʋ \"jri ɔɔ' \"ku. ");
INSERT INTO wob_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","‑Bo ‑gbʋa'na mɔ'ɔ ‑cɛ\" 'kpa 'wɔn ɩ mɔ 'de ɛ, ‑aa mu ɔ ja jaa', ɔ se aopʋ dɛsaʋn \"jrii nʋi. ");
INSERT INTO wob_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","\"Soa‑wi\" \"duo 'wɛi ‑nɩ 'ʋn 'ɛ, ʋʋ mua, wlu 'sraa ‑saʋn 'a klae\" ‑wi\" ‑tua\" ʋʋ wɔn ɛ, ɩmɩ ʋʋ 'tmʋ. 'Kamɔ ʋʋ ‑kɔ' ɩa' ‑tɩ' tu Suifʋ‑wi\" 'a 'blʋa‑ ja mamaʋ 'sʋ ɛ je 'e ‑sɩanwɩ 'di jɛɛ‑. ");
INSERT INTO wob_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Klai\" nynuu ‑sia ‑puue 'jɔ due' muɛ 'e Galile, 'de crʋ Sesi \"sia 'nynɩ \"kpei. ");
INSERT INTO wob_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Ʋʋ 'jeea Sesi \"jriɛ‑ 'sʋ ʋʋ ‑teɛ ɔɔ' \"juɔi ‑gbɛɛa' ‑pʋn\", 'kaa ʋʋa' jrʋ' a pleɛ pɛe i. ");
INSERT INTO wob_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","‑Wɛe Sesi 'kpa ʋʋpʋ ‑pʋn\" 'de ɔ wlu ka ɔ 'na : \"ikmaa' ‑nɩa 'e jaʋn 'di ke \"ikmaa' ‑nɩa 'e 'blʋa‑ \"kpei ‑wee' \"nyɩɩɛ 'ʋn 'ɛ. ");
INSERT INTO wob_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","ɛmɛ ‑tɩ ao 'je mu, ao 'je nyʋ 'a kpɛ ‑wee' \"klein 'ma klai\" nynuu 'ʋn nʋ, ‑wɛe ao 'je ʋʋpʋ \"ni \"jru po 'de \"Bo 'a 'nynɩ 'ʋn, 'de \"Ju 'a 'nynɩ 'ʋn, 'de ‑Suu 'a 'nynɩ 'ʋn. ");
INSERT INTO wob_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","‑Wɛe dɩ \"klein 'ɩn 'tmʋʋa aopʋ ɛ, ao 'je ʋʋpʋ ɩa' wɔn'je ka tɔɔ‑. Ao ‑gbʋn 'nɔ, dɛ ‑mua' mamaʋ 'sʋ ‑ɛ ‑jɛɛa 'blʋa 'a ‑kwɛ nɔ\" ɛ, ao ke 'ma ‑a muɛ naa' 'wɩ \"o 'wɩ ‑wee' 'di.");
INSERT INTO wob_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","‑Pɔia\" ‑tɩ ‑ɛ ‑tmʋa Kea 'a \"ju Sesi Klisɩ 'a ‑tɩ' ɛɛ' ‑teesʋn. ");
INSERT INTO wob_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Dɛ Kea 'a wlu 'kwajaai Esai 'crɩa 'de ɔɔ' 'sbɛ 'di, ɛmɛ ‑nɩ, Kea wlu' 'de ɛɛ' \"ju ‑pee ɛ 'na : ‑Ɩn ‑gbʋn 'nɔ, 'ma dboɛ 'ma weepoi nya ‑wɛe ɔ 'je ‑ma ‑jeblɩ ‑sa. ");
INSERT INTO wob_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Weepoi due' a muɛ 'e ‑pɩɩɔn\" blʋa \"kpei nɩa' ‑wɛe ‑ɔ ‑je wlu ka : Ao nmae Tʋ\"bo 'a ‑je ! Ao tɛɛn ɔɔ' ‑jeblɩ ‑wee' ‑kwlʋ ! ");
INSERT INTO wob_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Ɔɔ' weepoi tu ‑nɩ San Batisɩ. Ɔ wlu' ka ɔ 'na : Ao juo aoa' dɩsaɩn \"i, ao \"biie 'de Kea o, ‑wɛe ao 'je \"ni \"jru pooɛ‑ 'de kea 'je aoa' dɩsaɩn ‑kɔ'. ");
INSERT INTO wob_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Suideblʋa ‑wee' o, nyʋ klein\" ‑tia\" 'o Selisalɛm o, ʋʋ ‑wee' a muɛ 'e San o ‑wɛe ʋʋa 'tmʋ ʋʋa' dɩsaɩn 'de ɔ ‑pee, ‑wɛe ɔɔ po ʋʋpʋ \"ni \"jru 'bo sudɛn ‑gbuu wɔn. ");
INSERT INTO wob_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Dɩ San paa 'ʋn ɛ, ‑sɛn \"kpei soo\" 'a \"mɩɩ‑ mɩ ‑dbɩ' ‑wɛe ɔ bla nmiku wlʋ 'di. 'Plaɩn ‑too' ke dʋ 'a 'cna mɩ ‑nɩ ɔɔ' diidɛ. ");
INSERT INTO wob_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Ɔ 'na : \"Ju ‑a mua jia' 'de 'ʋn 'de ɛ ɔ kmai\", ɔ nɩɛ dɛwɔn ɔ je 'ʋn ‑sii. 'Ɩn se 'kɔi‑ i \"sii‑ ka nɩ 'bo ɔ \"juɔi ‑wɛe ɔɔ' \"kwlai‑ bɩ' ‑sa ‑tɩ. ");
INSERT INTO wob_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","'Mɔ ɛ, \"ni mɛ 'ma po aopʋ \"jru, 'kaa ɔmɔ ɛ, Kea 'a ‑suu mɛ ɔ 'je nʋ ‑wɛe ɔ 'je ao dɩsaɩn 'a ‑flɛn\" kui ‑sa. ");
INSERT INTO wob_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","'De ɛɛ' nɔ\" tu 'di ɛ, Sesi 'wlʋɛ 'e Nasarɛtɩ 'de Galile, ‑wɛe San po ɔ \"ni \"jru 'de Sudɛn ‑gbuu wɔn. ");
INSERT INTO wob_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Sesi 'wlʋa 'e \"niɔ 'sʋ ɔ 'jeeɛ jaʋn \"jriɛ ɛ kaiɛn wɔn ‑wɛe Kea 'a ‑suu \"si i 'bo ɔ \"kpei ka ‑gbɛɛ' 'ɛ \"siai ɛ. ");
INSERT INTO wob_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","'Sʋ ɔ 'wɔn wlu due' 'bo jaʋn ‑kwlʋ ‑ɛ ‑na : ‑Ɩn ‑nɩɛ 'ma ‑tɩ' kmaju ‑o dɛ‑nʋɛ' ‑ma nʋɛ 'ʋn 'mʋan \"i. ");
INSERT INTO wob_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Sesi 'a ‑nɛɛ ‑wlʋ 'e \"niɔ‑ 'sʋ Kea 'a ‑suu \"tun ɔ 'de ‑pɩɩɔn\" blʋa \"kpei fɔ o. ");
INSERT INTO wob_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","'Demɔ ɔ nʋʋ 'wɩ 'a kwla ‑nyiiɛ' ‑wɛe ‑siɔn' ‑tɩn' ɔ i ‑wɛe ɔɔ ‑pɔn Sesi 'je ɔ wɔn 'je. Sesi nɩɛ 'e 'kwla 'dinmi \"klu ‑wɛe Kea 'a \"soa a nʋʋ ɔ \"juɔi. ");
INSERT INTO wob_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","‑Ta San muua ‑kaso 'di mɛ Sesi mu 'e Galile ‑wɛe ɔ 'tmʋ Kea 'a ‑pɔia\" ‑tɩ. ");
INSERT INTO wob_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","'De ɔ 'naa : Nɔ\" Kea ‑tua\" ɛ nyni' ‑wɛ‑, ɛɛ' tʋ\"bodɛ jɛɛ aopʋ‑ 'mɛ. Ao poo kplɩn fai\" ‑wɛe ao 'je ‑pɔia\" ‑tɩ tɔ' 'ʋn 'je. ");
INSERT INTO wob_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","‑Ta Sesi nɩa \"ni wɔn i naa' 'de Galile ɛ, 'bomɔ ɔ jɛɛ Simɔ ke ɔɔ' \"dei Ancre 'sai‑ poa 'de \"niɔ‑. ");
INSERT INTO wob_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","'Sʋ Sesi wluɛ ʋʋpʋ ‑pee ɔ 'na : Ao bla 'bo 'ʋn 'de ‑wɛe ao 'je nyiɔpʋ ‑cri' ao 'je 'ʋn ja‑. ");
INSERT INTO wob_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","'Bo ɛ \"sri ʋʋ je ʋʋa' 'sai‑ 'bɔ, ʋʋ je 'bo ɔ 'de bla. ");
INSERT INTO wob_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Ɔ 'kpaa 'o nya dɛ‑saan\" 'sʋ ɔ 'jeɛ Sebede 'a \"nynuu‑ Sakɩ ke ɔɔ' \"dei San, ‑mɛ ʋʋ ‑teɛi 'de ʋʋa' ‑kwɛɛ\" 'di ‑wɛe ʋʋa nmae ʋʋa' 'sai‑. ");
INSERT INTO wob_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","'Sʋ Sesi nynai ‑wɛe ɔ 'da ʋʋpʋ, ʋʋ sia ʋʋ \"bo Sebede ke ɔɔ' dbonʋʋn 'de ‑kwɛɛ\" 'di 'sʋ ʋʋ bla 'o Sesi 'de. ");
INSERT INTO wob_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Sesi ke ɔɔ' klai\" nynuu muɛ 'o Kapɛnaʋm. ‑Kwlewɩ o 'sʋ ɛ, Sesi pa 'e Suifʋ‑wi\" 'a \"jrui 'kɩɩn‑gbu 'di ‑wɛe ɔ ‑te nyʋ dɛ tɔɔa' ‑pʋn\". ");
INSERT INTO wob_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Ɔɔ' nyʋ dɛtɔɔsʋn a \"siɛ nyʋ ‑wee' \"i ɛ kuɛ 'e 'dei ɛ ke nyʋ ‑ʋʋa tɔɔa nyʋ kɛ'ɛ ‑nɩ se due' nɩ‑. ");
INSERT INTO wob_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Ɔ siɛ nyʋ dɛ tɔɔa' 'sʋ \"ju due' ‑suusaʋn nɩa 'e 'ʋn je \"wɔ 'de nyʋ \"kwlu, ɔ 'na : ");
INSERT INTO wob_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","Sesi ‑wlʋa Nasarɛtɩ ɛ, ‑ma dɛɛ ‑tɩ ‑sie ‑aa ‑tɩ' 'ʋn ɛ‑ ? ‑Ae' ‑ɩn ji' ‑ɩn ‑je ‑aa ‑ma\" i‑saa ? Ka ‑ɩn ‑wlʋa 'e Kea o ‑wɛe ‑ɩn sea dɛsaʋn 'a ‑kɔ ‑pʋn\" nɩ ɛ, 'ɩn 'je kan' 'mɛ. ");
INSERT INTO wob_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","'Sʋ Sesi \"wɔɔ ‑suusaʋn \"jrui ɔ 'na : Ɛ \"mu wɔn, 'de ɛ 'wlʋ 'e \"ju ‑nɔ 'ʋn ! ");
INSERT INTO wob_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","'Sʋ ‑suusaʋn ‑suua' \"ju ‑nɩa 'mʋa‑ i 'di wɔn nyni ka‑ ‑wɛe ɛ 'wlʋ 'de ɔ 'ʋn 'de \"wɔɔa' 'ʋn. ");
INSERT INTO wob_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","‑Crima kpʋn nyʋ \"klein ‑nɩa 'o mu 'mɛ, 'sʋ ʋʋa ‑teeɛ' ba i due 'due ʋʋ 'na : Dɛ ‑nɩ ka ‑mɔ ɛ‑ ? Nyʋ dɛtɔɔsʋn dee ‑jɛ ‑mɛ kmai\". ‑Bo ɔ wlu ‑siisaɩn ‑pee ‑cɛɛn' ‑nɛ 'sʋ ɩa 'je ɔ wɔn ! ");
INSERT INTO wob_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","'Sʋ Sesi 'a 'nynɩ \"siiɛ Galileblʋa ‑wee' \"kpei \"i. ");
INSERT INTO wob_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Ʋʋ 'wlʋa 'e Suifʋ‑wi\" 'a \"jrui 'kɩɩn‑gbu 'di ʋʋ \"sia \"kpae' ɛ, Sesi ke Sakɩ ke San muɛ 'e Simɔ ke Ancre o ‑gbu\" 'di. ");
INSERT INTO wob_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","‑Ta ʋʋa muua, ‑mɛ Simɔ 'ɔ \"bianynɔ 'pɛn i, ʋa' \"jru ‑a ‑bai' ʋʋa' ku ‑siɛ' nɛ'. Sesi \"sia i 'sʋ ʋʋ 'tmʋ ʋa' ‑tɩ' 'mɛ 'de ɔ o. ");
INSERT INTO wob_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Ɔ 'kpa ʋ ‑pʋn\", ɔ kpʋn ʋa' sʋn ‑wɛe ɔ kpʋ \"jɛi 'sʋ ʋa' \"jru 'bɔɔ ʋʋa' ku peeɛ'. Ʋ piɛ dɛ ʋ je ʋʋpʋ \"nyɩ. ");
INSERT INTO wob_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","'Jrʋ blua i, 'sʋ ʋʋ ja nyʋ \"klein 'wɛ‑ ɛ nʋa ke nyʋ ‑siisaɩn nɩa 'ʋn 'de Sesi o. ");
INSERT INTO wob_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","‑Kwlɔ ‑wee' \"klein ‑kwɛ‑ de 'bo ɔɔ' ‑gbu\" wɔin\". ");
INSERT INTO wob_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Nyʋ \"klein ‑jia' 'mʋa‑, ka ʋʋa' 'wɛ‑ 'ɛ kpɛ ‑tia 'kamɔ Sesi 'bɔɔ ɩ ‑wee'. Ɔ ‑sa nyʋ ‑siisaɩn ‑tuu\" 'ʋn ‑ke. Ɔ se ‑siisaɩn \"i \"tai‑ ɩ se wlu‑, dɛ‑nʋɛ' dɛ ɔ nɩa 'ʋn ɛ, ɩ juɛ'. ");
INSERT INTO wob_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Ɛɛ' ‑sɔn' wɔin\" ‑mɛ ‑sɔn' kwie nɩɛ 'blʋɔi ke, Sesi sɔn 'ʋn 'ɛ, ɔ \"siɛ \"kpae', ‑wɛe ɔ 'wlʋ 'o ‑kwlɔ, ɔ mu Kea baea' ‑ta nyɔ jrɔ' sea nɩɛ. ");
INSERT INTO wob_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Simɔ ke ɔɔ' \"dɛi‑wi\" ‑teɛ ɔɔ' i ‑pɔan' ‑pʋn\". ");
INSERT INTO wob_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Ʋʋ 'jeɔ i 'sʋ, ʋʋ wlu ɔ ‑pee ʋʋ 'na : Nyʋ ‑wee' a ‑pɔn ‑mi i. ");
INSERT INTO wob_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","'De Sesi 'na : ‑A mu ‑tajrɔ ke, ‑a mu ‑kwlɛ ‑nɩa ‑a 'dewei 'dii. 'Ɩn 'je Kea 'a ‑tɩ' 'tmʋ ‑o 'demu ‑ke, ɛmɛ ‑tɩ 'ɩn ji. ");
INSERT INTO wob_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Kɔ nʋa ɔ jea Galileblʋa ‑wee' \"kpei‑ mu, ɔɔ jea Kea 'a ‑tɩ' 'tmʋ 'de Suifʋ‑wi\" 'a \"jrui 'kɩɩn‑gbi 'dii, ɔɔ jea ‑siisaɩn inʋ 'ka ‑nao. ");
INSERT INTO wob_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","'Jrʋwɛ nʋi due' jiɛ 'e Sesi o, ‑wɛe ɔ cniiɛ 'kɔi‑ 'bo ɔ \"juɔi ɔ bae ɔ i ɔ 'na : 'Ma 'blei ‑bo ‑ɩn ‑nɩɛ \"i ɛ, ‑ɩn ‑beeɛ' ‑ɩn ‑je 'ma 'wɛ‑ 'bɔɔ‑ 'ɩn 'je 'pepe nɩ‑. Ɔ 'da kan' 'sʋ, ");
INSERT INTO wob_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","ɔɔ' wɛe nʋ Sesi 'mɛ, ‑wɛe ɔ kpa sʋn, ɔ blɔ \"i, ɔ 'na : 'Ɩn nɩɛ \"i 'mɛ, ‑ma 'wɛ‑ 'bɔ ‑ɩn ‑je 'pepe nɩ‑. ");
INSERT INTO wob_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","'Bo ɛ \"sri 'jrʋwɛ‑ je \"ju ‑nɩa 'mʋa ‑pʋn\" 'wlʋ, ɔ je 'pepe nɩ‑. ");
INSERT INTO wob_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Sesi 'jea \"ju ‑nɔ ‑jei\" poɛ ɔ cri ɛɛ' ‑cɩɛ 'de ɔ ‑pee, ɔ 'na : ‑Bo ‑ɩn mu ɛ, ");
INSERT INTO wob_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","‑ɩn ‑bo dɛ jrɛ' 'tmʋɛ 'de nyɔ jrɔ' ‑pee. 'Kaa ‑ɩn ‑to ‑ma ‑cɛ\" 'de Kea 'a 'sraa ‑sai o, ‑wɛe ‑ɩn ‑je 'sraa ‑sadɛ ja‑, ka Moisɩ bla ɛɛ' kɛ' ɛ, 'de ka ‑ma 'wɛ‑ 'bɔa ʋʋ 'je ɛ juo‑. ");
INSERT INTO wob_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","'Kaa \"ju ‑nɔ mua, dɛ ‑nʋʋa ɔ \"jrii ɛ, ɔ 'jreeɛ ɛɛ' \"kuan i ‑ta ‑wee' \"klein. 'De ɛɛ' ‑tɩ' 'ʋn ɛ, Sesi se ɛ 'bɛɛ‑ 'bode ɔ 'je 'mii wa ɔ 'je ‑kwlɔ jrɛ' 'di i \"si, ɔɔ muɛ dɩ 'mii ‑ta nyʋ sea' \"i ‑ti ɛ, ‑wɛe nyʋ a 'wlʋ ‑ta \"o ‑ta ʋʋa ji 'de ɔ o. ");
INSERT INTO wob_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Ɛ nʋa 'wɩ ɛ, Sesi jiɛ de 'bo Kapɛnaʋm. Ka ɔ nɩa 'de ‑gbu\" jrɛ' 'di ɛ, nyiɔpʋ‑ 'wɔɛn. ");
INSERT INTO wob_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","'Sʋ ʋʋ ‑kwɛ de ‑kwɛ ‑kwɛ, ɛ nʋɛ' 'sʋ ‑tein se 'o ‑gbu\" \"wɔin ‑cɔɔn' ‑nɔ sie‑ 'de \"kpae' ‑wɛe Sesi a tɔɔ ʋʋpʋ Kea 'a wlu. ");
INSERT INTO wob_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","'Sʋ nyʋ ‑nyiiɛ jrʋ' ‑blee' klɔɔi due' 'sai 'di ‑ʋʋ ‑jɔ Sesi. ");
INSERT INTO wob_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","'Kaa 'de nyiɔpʋ‑ 'a \"i ‑tia' 'ʋn ɛ, ka ʋʋ 'jea ɔɔ' Sesi \"itosʋn nʋ, 'ka se nɩ‑. 'Sʋ ʋʋ 'ja 'de ‑gbu\" \"kpei. Ʋʋ ‑sa ‑po\" 'bomɔ ʋʋ jaa klɔɔi ‑nɔ ‑wɛe ʋʋ \"sii ɔ i 'bo Sesi \"juɔi. ");
INSERT INTO wob_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Sesi 'jea nyʋ ‑nɩa 'mʋa 'a dɛ tɔ' \"itbaa' 'sʋ, ɔ wluɛ klɔɔi ‑pee ɔ 'na : 'Ma \"ju, ‑ma dɩsaɩn‑ ‑kwɛ'. ");
INSERT INTO wob_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Kɛ' wɔ‑saʋn jrʋ' ‑jea ɛɛ' ‑ta a, ʋʋ naa tɔ' i 'de ʋʋa' ‑cɛ\" ‑kwlɩ\" ʋʋ 'na : ");
INSERT INTO wob_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","Ka \"ju ‑nɔ ‑mɔɔ' 'tmʋʋ ‑tɩ nɩ kan' ‑a ? Ɔɔ toɛ Kea wɔn o. ‑Ɔ ‑bɛɛ' dɛsaʋn ‑kɔa' ‑bo ɛ se Kea due' koun ‑gba' i nɩ ɛ ? ");
INSERT INTO wob_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","'Sʋ Sesi 'jeɛ 'e ʋʋa' tɔ' 'dei, 'de ɔ 'na : Dɛɛ‑tɩ aoa' tɔ' i naa sʋn nɩ kan' a‑ ? ");
INSERT INTO wob_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","‑Jɛ wɛ‑ ‑kʋan\" \"jrii ɛ‑ ? ‑Ɩn ‑wlu klɔɔi ‑pee, ‑ɩn ‑na ‑ma dɩsaɩn ‑kwɛ' ‑ae, ‑ae' ‑ɩn ‑na ‑ɩn ‑sɔn 'ʋn, ‑ɩn ‑duo\" ‑ma \"kpei 'pɛndɛ 'ʋn ‑ɩn ‑je na a‑ ? ");
INSERT INTO wob_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Ka 'mɔ nyiɔ 'ɔ \"Ju 'bɛɛa 'de 'blʋa \"kpei ‑ta, 'ɩn 'jea nyʋ 'a dɩsaɩn ‑kɔ' ɛ, ka ao 'jea ɛɛ' juo sʋn nʋ 'ka ka ? 'Sʋ ɔ wlu' 'de klɔɔi ‑pee ka, ɔ 'na : ");
INSERT INTO wob_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","'Mɔ ‑ɔɔ ‑tmʋʋ' ‑ʋn, ‑ɩn ‑sɔn 'ʋn, ‑ɩn ‑duo\" ‑ma \"kpei 'pɛndɛ 'ʋn ‑ɩn ‑je 'de ‑ɩn ‑wɔin\" de mu ! ");
INSERT INTO wob_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","'Bo ɛ \"sri ɔ je 'ʋn sɔn 'bo nyʋ ‑wee' \"jri \"kpei, ɔ je ɔɔ' dɩ 'ʋn \"duo‑ ɔ je mu. ‑Crima kpʋn ʋʋpʋ 'mɛ. Ʋʋa 'bɛɛ‑ Kea 'a 'nynɩ \"i ‑wɛe ʋʋ wlu ka : ʋʋ 'na : ‑A se ‑jɛ ‑mɛɛ' dɛ tu 'a ‑ta 'je due'. ");
INSERT INTO wob_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Ɛ 'wlʋa 'o muɛ, Sesi muɛ de 'bo \"ni wɔin\" ke'wlɛ. Nyiɔpʋ ‑tuu\" ‑a ji 'de ɔ o ‑wɛe ɔɔ tɔɔ dɛ. ");
INSERT INTO wob_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","‑Ta ɔɔ ‑sia', 'bo ɔ 'jee Alfe 'a \"ju Lefi ‑mɛ ɔ ‑teɛ i 'bo 'wɛi‑sagbu 'di. Sesi 'na : Lefi, ‑ɩn ‑bla 'bo 'ʋn 'de, ‑ɩn ‑ke 'ma ‑a ‑je na‑. 'Sʋ Lefi sɔn 'ʋn ɛ, ɔ bla 'bo ɔ 'de. ");
INSERT INTO wob_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","‑Ta Sesi nɩa dɛ dɩa' 'de Lefi o ‑gbu\" ɛ, 'wɛi‑sanyʋ ‑tuu\" o, nyiɔpʋ 'a \"kwli saɩn jrʋ' o, ɔɔ' klai\" nynuu o, ʋʋ ‑wee' beeɛ o ʋʋa diiɛ ‑tadue, dɛ‑nʋɛ' nyʋ ‑nɩa 'mʋa‑ ʋʋa' ‑tuu\" ke ɔɔ na'. ");
INSERT INTO wob_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Kɛ' wɔ‑saʋn ‑nɩa 'e Fariseɛn \"klu 'jea Sesi ɔ ke nyiɔpʋ 'a \"kwli saɩn ke 'wɛi‑sanyʋ a diia ‑tadue 'sʋ ɛ, ʋʋ wluɛ ɔɔ' klai\" nynuu ‑pee ʋʋ 'na : Dɛɛ‑tɩ Sesi ke 'wɛi‑sanyʋ ke nyiɔpʋ ‑saɩn a dii ‑tadue ɛ‑ ? ");
INSERT INTO wob_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Sesi 'wɔan ʋʋpʋ 'a wlu 'sʋ ɔ 'na : Nyʋ ‑blea kui ‑sɔn i flɔan' ʋʋa' ‑pɔn ‑dɔ'crɔ i, 'kaa nyʋ ‑a dɛ ɛ pooa ʋʋ ‑a ‑pɔn' ‑dɔ'crɔi i. 'Ɩn se \"isrɛnyʋ 'a ‑tɩ' ji, 'kaa dɩsaɩnʋʋn 'a ‑tɩ' mɛ ‑tɩ 'ɩn ji, ‑wɛe ʋʋ 'je 'pʋʋa' 'je. ");
INSERT INTO wob_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","'Wɩ jrɛ' o ‑ta San Batisɩ 'a klai\" nynuu ke Fariseɛn‑wi\" 'bɔa wɔn ɛ, 'bomɔ nyiɔpʋ ji 'e Sesi o, ‑wɛe ʋʋ ‑tee' ɔ i ka, ʋʋ 'na : Dɛɛ‑tɩ San Batisɩ 'a klai\" nynuu ke Fariseɛn‑wi\" a 'bɔ wɔn ‑wɛe ‑maa ‑nɩ klai\" nynuu 'a 'bɔ wɔn ɛ‑ ? ");
INSERT INTO wob_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","'Bomɔ Sesi ‑sɛɛ \"kpei ɔ 'na : Aoa naa tɔ' i 'ee nyʋ ʋʋ 'da 'de ba \"bliti ‑kɔ ‑sɔn, ʋʋ 'bɛɛ' ʋʋ 'je wɔn 'bɔɔ ? \"Ɩɩn‑, ‑ta 'nynɔjei ke ʋʋpʋ ‑tea i ke ɛ, ʋʋ se ɛ 'bɛɛ‑ ʋʋ 'je wɔn 'bɔ. ");
INSERT INTO wob_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","'Kaa ‑sɔntɩ nyʋ a mua 'nynɔjei 'de ʋʋpʋ \"klu ‑saa' a, 'bomɔ ʋʋ 'je wɔn 'bɔɔ‑. ");
INSERT INTO wob_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Nyɔ se ɛ 'bɛɛ‑ ɔ 'je \"wliiɛfɔ dee 'bo 'ʋnpaadɛ soa ‑pʋn\" \"paa‑. ‑Bo \"wliiɛfɔ dee \"paa‑ 'bo 'ʋnpaadɛ soa 'a ‑kɔi\" ɛ, ‑mɛ ɛɛ' 'faea' a 'kpa \"kpei ke'wlɛ. ");
INSERT INTO wob_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Nyɔ se ɛ 'bɛɛ‑ ɔ 'je nmɔ dee 'de bi ‑gbai\" 'di po. ‑Bo ɛ nɩ kan' a, ‑mɛ nmɔ ɔ muɛ i'wlaa', ‑mɛ nmɔ ke bi a muɛ idooa'. ‑Bo ɛ 'je 'wɔn ɛ, ‑mɛ nyʋ a poɛ nmɔ dee 'de bi dee 'di. ");
INSERT INTO wob_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","'Wɩ jrɛ' o 'bo Suifʋ‑wi\" 'a ‑kwlewɩ \"kpei Sesi ke ɔɔ' klai\" nynuu a cɛn 'o ‑kle' jrɩ' 'di ‑tie\". 'Sʋ dɩ ɔɔ' klai\" nynuu 'jea 'bo ɩ di ɛ, ʋʋ ‑teɛ ɩa' cɛan' ‑pʋn\" ‑wɛe ʋʋa di ‑je wei. ");
INSERT INTO wob_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","'Sʋ Farisiɛn‑wi\" ‑teeɛ' Sesi, ʋʋ 'na : ‑Gbʋn 'nɔ, dɛɛ‑tɩ ‑ma klai\" nynuu a nʋ dɛ ‑sea' nʋ ka nɩ 'bo ‑kwlewɩ \"kpei ɛ‑ ? ");
INSERT INTO wob_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Sesi wluɛ ʋʋ ‑pee ɔ 'na : ‑Ta 'mɩɩɛ‑ nʋa Dafidɩ ke ɔɔ' 'cɛ 'wɩ jrɛ' o, ‑wɛe ʋʋ ‑pɔan' diidɛ ɛ, dɛ ɔ nʋa ao se ɛ 'dii ‑sroo' ? ");
INSERT INTO wob_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Ɔ pa 'e Kea ‑gbu klaa\" 'di, ‑wɛe ɔ di ‑di'pɛn ‑ɛɛ mua 'o Kea \"juɔi ɛ. ‑Mɛ Abiataa ‑nɩ 'sraa ‑sai klaa\" 'de ɛɛ' nɔ\" tu 'di. 'De ‑mɛ ‑aa kɛ' 'na : 'Sraa ‑saʋn klae\" 'a 'sʋ mʋ ‑bɛɛ' ‑ʋʋ ‑je ‑di'pɛn ‑nɩa 'mʋa‑ di. 'Kaa Dafidɩ \"duo ɛɛ' jrɛ' 'ʋn 'ɛ ɔ je ɛ di, ‑wɛe ɔ \"nyɩ ɛɛ' tɔo‑ ɔɔ' 'cɛ ‑ke. ");
INSERT INTO wob_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Sesi wluɛ ʋʋpʋ ‑pee ke'wlɛ ɔ 'na : Kea nʋ ‑kwlewɩ 'mɛ 'de nyiɔ 'ɔ 'dɔe 'a ‑tɩ' 'ʋn. Ɛ se nyiɔ mɔ ‑nʋʋɛ 'de ‑kwlewɩ 'a ‑tɩ' 'ʋn nɩ‑. ");
INSERT INTO wob_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","'De 'mɔ nyiɔ 'ɔ \"Ju 'mɔ nɩɛ ‑kwlewɩ 'a jei ‑o ‑ke. ");
INSERT INTO wob_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Sesi pa 'e Suifʋ‑wi\" 'a \"jrui 'kɩɩn‑gbu 'di de ke'wlɛ. 'De \"ju due' nɩ‑ 'o ‑ɔɔ kwa jɛ 'soɛ. ");
INSERT INTO wob_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","'Sʋ Fariseɛn‑wi\" a ‑gbʋɛn Sesi ja ‑snii' ‑wɛe ‑bo ɔ 'bɛɛ‑ ɔ 'je \"ju ‑nɩa 'mʋa‑ 'pʋʋ 'bo ‑kwlewɩ \"kpei ɛ, ʋʋ 'je kan' 'je 'de ʋʋ 'je ɔ ‑tɩ' \"kpei ‑tuu\"‑. ");
INSERT INTO wob_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Sesi wluɛ \"ju ‑a kwa jɛa 'soɛ ‑pee ɔ 'na : \"Bo, ‑sɔn 'ʋn 'bo nyʋ ‑wee' \"juɔi ‑ta ! ");
INSERT INTO wob_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","‑Wɛe Sesi ‑tee' ʋʋpʋ i, ɔ 'na : Ka kɛ' 'da‑ ? Nyɔ 'beeɛ' ɔ 'je dɛ 'dɔe nʋ 'bo ‑kwlewɩ \"kpei ‑ae, ‑aee' ɔ 'je dɛ saʋn nʋʋ ? Nyɔ 'beeɛ' ɔ 'je nyɔ 'pʋʋ‑ ‑ae, ‑aee' ɔ 'je nyɔ 'dbaa ? 'Kaa dɛ ɔɔ 'tmʋa ʋʋ se ɛ \"kpei ‑sa. ");
INSERT INTO wob_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Sesi pleeɛ ʋʋpʋ 'cɛnjriɛ \"kpei, ‑wɛe ɔ \"kae‑ \"jrii 'de ʋʋa' pɛe 'a \"ikmu‑tɩ 'ʋn. 'Sʋ ɔ wluɛ \"ju ‑nɔ ‑pee ɔ 'na : ‑Sro' sʋn ! Ɔ sroɛ' kan' ‑cɛɛn'‑ 'sʋ ɔɔ' kwa jiɛ 'o tai\" de. ");
INSERT INTO wob_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Fariseɛn‑wi\" 'wlʋ 'a \"jrui 'kɩɛn‑gbu 'di ɛ, 'bo ʋʋ ke Erodɩ 'a 'cɛ \"sri ʋʋ 'kɩɩɛn \"jrui, ‑wɛe ka ʋʋ 'jea nʋ 'de ʋʋ 'jea Sesi 'dba a ʋʋ 'je ɛ poo‑. ");
INSERT INTO wob_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Sesi ke ɔɔ' klai\" nynuu 'kpaa 'de \"ni ‑kwlɩ\" fɔo, 'sʋ nyʋ ‑tuu\"‑tuu ‑wlʋ Galile ‑ʋʋ bla 'o ɔ 'de. ");
INSERT INTO wob_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Ʋʋ 'wlʋɛ Suide ke Selisalɛm ke Edum blʋɩ ‑nɩa 'de Sudɛn ‑gbuu 'de 'dii ke, ɛ ke Tii ke Sidɔn blʋa 'a ‑kwlɛ 'dii ke‑. Dɛ‑nʋɛ' ʋʋ 'wɔn ɔɔ' nʋʋdɩ 'a 'nynɩ ɛmɛ ‑tɩ ʋʋ ji 'de ɔ o. ");
INSERT INTO wob_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","'De nyɔpʋ‑ 'a \"i‑tie ‑tɩ 'ʋn ɛ, Sesi 'tmʋʋɛ ɔɔ' klai\" nynuu ‑wɛe ʋʋ 'je ɔ ‑kwɛɛ\" 'de i ‑tee ɔ 'jeɛ 'di 'ja ‑bo ɛ nɩ kan' a ‑mɛ nyʋ se ɔ i 'tʋn i. ");
INSERT INTO wob_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Dɛ‑nʋɛ' 'de ɔɔ' nyʋ ‑tuu\" 'a 'wɛ‑ 'bɔɔ‑ ‑tɩ 'ʋn ɛ, nyʋ \"klein 'wɛ‑ ɛ kpʋn a ‑kwlʋ ɛ, ʋʋa ‑pɔn ʋʋ ‑wee' 'je ɔ \"i bla. ");
INSERT INTO wob_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Nyʋ ‑siisaɩn nɩa 'e 'ʋn 'je ɔ i 'sʋ ʋʋa \"siiɛ 'kɔu‑ i 'bo ɔ \"juɔi, ‑wɛe ʋʋa \"wɔ ʋʋ 'na : ‑Ɩn ‑nɩɛ Kea 'a \"Ju ‑oo ! ");
INSERT INTO wob_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","'Kaa Sesi ‑teɛ' ʋʋpʋ kɛ' \"i ɔ 'na : dɛ 'ɩn nɩa 'ʋn ɛ, ɛ se aomɔ ‑jeɛ 'tmʋ nɩ‑ ! ");
INSERT INTO wob_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","‑Mɛ 'wlʋa 'o ‑jei\" ɛ, Sesi muɛ 'e crʋ \"kpei ‑wɛe ɔ 'da nyʋ ɔ nɩa \"i, ‑ʋʋ ‑ke ɔ 'jea dbo nʋɛ. ");
INSERT INTO wob_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","‑Wɛe ɔ ‑sa 'o nyʋ 'a ‑puue 'jɔ 'sɔɔn 'de ʋʋpʋ \"kwlu ɔ 'daa‑ ɔɔ' dboʋn ʋʋ ‑ke ɔ 'je na‑. ");
INSERT INTO wob_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Ʋʋpʋ ɔ \"nyɩ \"ikmaa' ‑ʋʋ ‑je Kea 'a ‑tɩ' 'tmʋ 'de ‑ʋʋ ‑je ‑siisaɩn i nʋ. ");
INSERT INTO wob_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Nyʋ 'a ‑puue 'jɔ 'sɔɔn ɔ ‑sa 'o ɛ, ʋʋa' 'nynɩ ka : Simɔ ɔɔ 'daa Piɛi ke ");
INSERT INTO wob_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Sebede 'a \"nynuu‑ Sakɩ ke ɔɔ' \"dei San ɔ ‑tuua\" Boanɛkɛsɩ ‑nynɩ, ɛ 'de mɛ ‑nɩ \"ni 'a \"plaan'. ");
INSERT INTO wob_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Ʋʋ ke Ancre o, Filipʋ o, Batelemi o, Matie o, Toma o, Alfe 'a \"ju Sakɩ o, Tade o, Simɔ 'kpɩ 'blei o. Ɔɔ' Simɔ tu nyʋ ‑ʋʋ ‑nɩɛ \"i Suifʋ‑wi\" 'jea ʋʋa' ‑cɛ\" ‑pee ‑te ɛ, ɔ nɩɛ ʋʋpʋ 'a due' ‑o, ");
INSERT INTO wob_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","ʋʋ ke Suida Isikaio, ‑ɔɔ mua Sesi plea' 'de ɔɔ' tʋnyʋ 'kwa ke‑. ");
INSERT INTO wob_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Sesi jiɛ ‑gbɛin\" de, 'kaa nyʋ ‑kɩɩan' \"jrui 'bomu ʋʋa' \"i ‑tisʋn se \"cra, 'de ɛɛ' ‑tɩ' 'ʋn ɛ, ka Sesi ke ɔɔ' klai\" nynuu 'jea dɛdisʋn nʋ 'ka se nɩ‑. ");
INSERT INTO wob_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Ɔɔ' 'cɛ 'wɔan dɩ ‑nɩa 'mʋa a, ʋʋ sɔn 'ʋn 'ɛ 'sʋ ʋʋ mu ɔ kpʋn 'a, dɛ‑nʋɛ' ʋʋa naa tɔ' i ʋʋ 'na ‑mɛ sɩɩan ‑kpɔ \"jri. ");
INSERT INTO wob_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Kɛ' wɔ‑saʋn ‑wlʋa 'de Selisalɛm ‑ʋʋ jia 'mʋa‑, dɛ ʋʋ 'tmʋa 'de ɔɔ' ‑tɩ' 'ʋn ɛ, ɛ ka : ʋʋ 'na : Bɛsebuilɩ ‑ɛ ‑nɩa ‑siisaɩn 'a klaa\" mɛ ‑nɩ 'de ɔ 'ʋn 'de ‑ɛ ‑nyɩ\" ɔ \"ikmaa' ‑wɛe ɔɔ nʋ ‑siisaɩn i. ");
INSERT INTO wob_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","'Sʋ Sesi 'da ʋʋpʋ 'mɛ ‑wɛe ɔ poo ‑tɩ' \"i, ɔ 'na : Ka ‑siɔn' 'bɛɛ‑ ɔ 'je ɔɔ' ‑cɛ\" i nʋ ɛ‑ ? ");
INSERT INTO wob_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Aoa 'jee, ‑bo tʋ\"bo 'a 'bleenyʋ 'a 'sʋ a sea 'ʋn ‑sa' a, tʋ\"bo ‑kwlɔ ‑nɩa 'mʋa‑ se dɛ 'ʋn 'wlʋ i. ");
INSERT INTO wob_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","‑Bo ‑gbu\" 'dinyʋ 'a 'sʋ a sea 'ʋn ‑sa a, ɛɛ' ‑gbu\" tu se dɛ 'ʋn 'wlʋ i. ");
INSERT INTO wob_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","‑Bo ‑siɔn' a sea ɔɔ' ‑cɛ\" o ‑fɔn' ɛ, ‑bo \"cɛi nɩ 'de ɔɔ' tʋ\"bo‑kwlɔ 'di ɛ, ɔɔ' \"ikmaa' se ‑tajrɔ nynii, ɛ 'je \"ti. ");
INSERT INTO wob_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Nyɔ se ɛ 'bɛɛ‑ ɔ 'je 'de \"ikmai o ‑gbu\" 'di pa ‑wɛe ɔ 'je ɔɔ' dɩ \"jri, ‑bo ɔ se \"ju ‑kmai\" ‑nɔ san kpɩɩn‑ ɛ. 'Kaa ‑bo ɔ sɔn, ‑mɛ ɔ 'bɛɛ‑ ɔ 'je dɩ \"klein ‑nɩa 'de ɔ o ‑gbu\" 'di \"jri. ");
INSERT INTO wob_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","'Ma 'tmʋʋɛ aopʋ tɔ' ‑tɩ 'a tɔ' ‑tɩ, nyiɔpʋ‑ 'a dɩsaɩn o, ʋʋa' Kea ‑soo' opoa' 'beeɛ' ɩ 'je ‑kwɛ‑. ");
INSERT INTO wob_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","'Kaa nyɔ ‑ɔɔ mua Kea 'a ‑Suu ‑kwɛai ‑soo' o poa' a, ɔɔ' dɛsaʋn se ‑kwɛi, ɛɛ muɛ ɔ \"jru nɩa' jeejee. ");
INSERT INTO wob_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Sesi 'wɔan ʋʋ ‑pee wlu ‑tɩ kan' a, ʋʋ wlu' ka, ʋʋ 'na : ‑Suusaʋn ‑nɩ 'de ɔ 'ʋn. ");
INSERT INTO wob_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Sesi de ke ɔɔ' \"dei ‑wi\" ‑jiɔ' 'jea a ʋʋ nynai 'de \"kpae, ‑wɛe ʋʋ dbo nyɔ ɔ mu Sesi 'daa'. ");
INSERT INTO wob_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","‑Ta ɛ nɩa kan' ‑mɛ nyʋ ‑tuu\"‑tuu ‑gbae' ɔ 'de woi 'de ʋʋ wlu ɔ ‑pee ʋʋ 'na ‑ɩn de ke ‑ma \"dei ‑wi\" ‑nɩ 'e \"kpae. Ʋʋa 'da ‑ʋn ‑ɛ. ");
INSERT INTO wob_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","'Sʋ Sesi 'na : ‑ɔ ‑nɩ 'ɩn de ke 'ma \"dei ‑wi\" ɛ‑ ? ");
INSERT INTO wob_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","‑Wɛe ɔ kpa \"jri \"jɛi 'de ɔ ‑gbʋʋn' nyʋ ‑ʋʋ ‑gbae' ɔ 'de woi \"kpe i 'de ɔ 'na : nyʋ ‑nʋ ʋʋpʋ ‑nɩ 'ɩn de ke 'ma \"dei \"wi. ");
INSERT INTO wob_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","'Kaa nyɔ ‑nʋa' Kea 'a 'tʋn nʋ‑tɩ ɛ, ɔmɔ ‑nɩ 'ma de'dinmɔu, ɔmɔ ‑nɩ 'ma de'dinynɔkpao', ɔmɔ ‑nɩ 'ɩn de. ");
INSERT INTO wob_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","'Wɩ jrɛ' o Sesi ‑teɛ Kea 'a ‑tɩ' 'tmʋa' ‑pʋn\" ke'wlɛ 'bo \"ni klaa\" ‑nɩa 'e Galile ‑kwlɩ\". 'De nyiɔpʋ‑ 'a \"i‑tia' 'ʋn ɛ, 'bo ɔ 'jaa‑ 'de ‑kwɛɛ\" 'di 'bo \"ni \"kpei ‑wɛe ɔ ‑te i. Nyʋ ‑wee' \"klein ‑gbae' ɛ \"ni wɔn i. ");
INSERT INTO wob_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Sesi 'wɔan ʋʋpʋ dɛ tɔɔ ‑tɩ ɛ, ɔ pooɛ ‑tɩ' ‑tuu\"‑tuu \"i. ");
INSERT INTO wob_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","Ɔ 'na : Ao po doin\" i ! Nyɔ due' muɛ ko ‑gbaa'. ");
INSERT INTO wob_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","‑Ta ɔɔ ‑gbaa' ko 'sʋ ɛ, ɩa' 'jɔ jrɩ' blu' 'bo ‑jei\". Nʋɩ ji' ɩ di ‑mɩ 'mɛ. ");
INSERT INTO wob_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Ɩa' 'jɔ jrɩ' blu' 'de \"soi 'ʋn ‑ta 'blʋ ‑tuu\" sea nɩ ɛ. Ɩ ‑too\" ɛ 'mɛa'. ");
INSERT INTO wob_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","'Kaa ‑ta 'jrʋ a ‑tea ‑gbao ɛ, ɩa' 'sɩn ‑wee' jɛ 'soɛ, dɛ‑nʋɛ' ɩa' 'sɩn se ‑ta ‑tɔɔn' nyni 'de 'blʋ ‑sɔn. ");
INSERT INTO wob_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Ɩa' 'jɔ jrɩ' blu' 'de \"wi 'ʋn. \"Wi sɩn i, ɩ se dɛ 'ʋn 'wlʋ. ");
INSERT INTO wob_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","'Kaa ɩa' 'jɔ jrɩ' blu' 'de 'blʋa‑ 'dɔe 'ʋn, ‑mɩ mɛ'. Ɩ 'wlʋɛ dɛ 'ʋn, kpau due' croɛ 'jɔ 'ɔ kwla taan, due' croɛ kwla ‑mɛɛo\"‑, due' croɛ kmɛ' 'due. ");
INSERT INTO wob_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","‑Wɛe Sesi 'na : Nyɔ doun\" nɩa 'o \"jru ɛ, ‑mɛ ɔ 'wɔn i. ");
INSERT INTO wob_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","‑Ta Sesi tɛɛan nyiɔpʋ kɩɩn ɛ, 'bomɔ nyʋ pla ‑sia 'o ke ɔɔ' klai\" nynuu ‑nɩa ‑puue 'jɔ 'sɔɔn ‑tee' ɔ i 'de \"i poo‑tɩ 'a ‑tɩ' 'ʋn. ");
INSERT INTO wob_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","'Sʋ Sesi 'na : Aopʋ‑ mɔ ɛ, Kea ‑sa ɛɛ' tʋ\"bo ‑kwlɔ 'ɔ ‑tɩ' 'kwla 'de ao ‑pee, 'kaa ‑bo ɛ ‑tu\" \"kpaenyʋ ‑wi\" ‑mʋ ɛ, ʋʋa 'wɔɩn 'de \"i poo‑tɩ 'a 'sʋ 'ʋn. ");
INSERT INTO wob_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","'De ʋʋa ‑gbʋn ɩ ja 'mɛ 'pepe, 'kaa ʋʋa' 'jee ɩ \"jriɛ‑. Ʋʋa' doin\" a 'wɔɩn 'mɛ, 'kaa ʋʋa' 'wɔɩn 'dei, ‑bo ʋʋa sɩ 'dei 'wɔn 'de ɛ, ‑mɛ ʋʋa muɛ 'e Kea o \"biia', 'de ɛ 'je ʋʋa' dɩsaɩn ‑kɔ' 'de‑. ");
INSERT INTO wob_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","'Sʋ Sesi ‑teeɛ' ʋʋpʋ i ɔ 'na : Ao se \"i poo ‑tɩ ‑nɩ 'mii 'wɔɔn ? 'De ‑mɛ ka ao 'je \"i poo ‑tɩ jrɩ' 'a 'mii 'wɔnsʋn nʋ ɛ‑ ? ");
INSERT INTO wob_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Kodbonʋi ‑ɔɔ ‑tɩ' 'ɩn 'tmʋa, ɔ ‑kɔ' nyɔ ‑tmʋa Kea 'a ‑tɩ'. ");
INSERT INTO wob_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","'De nyʋ jrʋ' pɛe o ɛ, wlu ‑tmʋʋa' ɛ ‑kɔ' kojɔ ‑blua\" 'bo ‑je ‑kpae\" ɛ. ‑Bo ʋʋ 'wɔn wlu 'mʋa‑ kaan 'sʋ ɛ, ‑siɔn' ji' ‑wɛe ɔɔ ‑sɛ 'de ʋʋ 'ʋn. ");
INSERT INTO wob_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Nyʋ jrʋ' 'a pɛe o ke'wlɛ ɛ, wlu ‑tmʋʋa' ‑kɔ' kojɔ ‑blua 'de \"soi \"klu ɛ. ‑Ta ʋʋ \"sria ʋʋ 'wɔan Kea 'a wlu 'bo ʋʋ ‑sɛɛ 'o mu 'de 'mʋa‑ 'ʋn. ");
INSERT INTO wob_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","'Kaa ʋʋa' \"taiɛ \"i ɛɛ' \"ti 'de ʋʋpʋ 'ʋn. Ʋʋa' 'mʋa 'a nɔ\" se \"i tɛn‑. ‑Bo \"ikma ‑tɩ ke 'kle ji ʋʋpʋ \"kpei 'de Kea 'a ‑tɩ' 'ʋn ɛ, 'sʋ ʋʋ 'bɔ Kea ‑kwlɩ\" ‑tea' ‑nɩa 'de ʋʋpʋ 'ʋn o. ");
INSERT INTO wob_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Kea 'a wlu nyʋ deejrʋ' a 'wɔan a, ka kojɔ ‑blua' 'de \"wi 'ʋn nɩa, 'kamɔ ɛ nɩ 'de ʋʋpʋ 'ʋn. Ʋʋa' nyʋ tu a 'wɔn Kea 'a wlu 'mɛ, ");
INSERT INTO wob_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","'kaa ʋʋa naa 'kmʋ \"kpeidɩ 'a tɔ' i 'wɩ \"o 'wɩ. \"Wlii 'a 'tʋn 'a nyʋ 'srɛ i poa', ɛ ke 'tʋn nʋdɩ jrɩ' ‑nɩa 'de ʋʋpʋ 'ʋn a \"fian wlu \"jrui ‑wɛe ɩa' 'wlʋ dɛ 'ʋn. ");
INSERT INTO wob_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","'De nyʋ jrʋ' pɛe o ke'wlɛ ɛ, wlu ‑tmʋʋa' ‑kɔ' kojɔ ‑blua' 'de 'blʋa‑ 'dɔe 'ʋn. Wlu ʋʋ 'wɔan, ʋʋa ‑teɛ' i 'de ʋʋpʋ 'ʋn, ʋʋa kpʋʋn ɛ sɩn 'sɔɔn, ‑wɛe ka ɛ \"sia 'nynɩ ʋʋa nʋ kan'. Ʋʋa' nyʋ tu ɛ, ʋʋ ‑kɔ' ko ‑nmɔa ‑wɛe ‑ɛɛ kpau due' croa 'jɔ 'ɔ kwla taan, due' croa kwla ‑mɛɛo\"‑, due' croa kmɛ' 'due ɛ. ");
INSERT INTO wob_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Sesi pooɛ ‑tɩ' jrɩ' \"i ke'wlɛ 'de Kea 'a wlu 'wɔnsʋn 'a ‑tɩ' 'ʋn, ɔ 'na : Nyɔ 'beeɛ' ɔ 'je nɛbi tba ‑wɛe ɔ 'je ɛ jae \"jrui ‑crii\"‑ 'de ɛ 'je i 'jee ? 'De nyɔ 'beeɛ' ɔ 'je ɛ 'e 'dii ‑sɔn ‑tuu\" ? Nyʋ a se ɛ ja ‑pee' ‑wɛe ɛɛ sea i 'je ‑ta ‑wee' ‑pesaa' ? ");
INSERT INTO wob_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Dɩ \"klein ‑pa' 'kwla a, ɩa muɛ \"kpae' 'pɛɛan'. Dɩ \"o dɩ ‑tuu\" a i ɛ, ɩa muɛ 'e ‑sɔn' 'ʋn jia'. ");
INSERT INTO wob_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Nyɔ doun\" nɩa 'o \"jru ɛ, ‑mɛ ɔ 'wɔn i. ");
INSERT INTO wob_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","'Bo ‑mɛ 'de ɛ, ɔ 'na : Ao ‑tu\" dɩ aoa 'wɔan 'a ‑tɩ'. Dɛ aoa dbaa nyɔ 'ʋn ɛ, mɛ nyɔɔ mu ao dbaa' ‑ke, ‑wɛe nyʋ 'je aoa' ‑nɩ \"kpei ‑tu\". ");
INSERT INTO wob_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","'Kaa nyɔ ‑blea dɛ nyʋ a muɔ jrɛ' nyɩa\" ke'wlɛ, 'de nyɔ ‑sea' dɛ 'ble ɛ, dɛ‑saan\" ɔ 'blea nyʋa muɔ ɛ 'kwa ‑saa'. ");
INSERT INTO wob_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Sesi wlu' ke'wlɛ ɔ 'na : Dɛ ‑ke Kea 'a kɛɛma' ‑kwlɔ 'ɔ ‑tɩ' ‑kɔɔa' \"i ɛ, ɛ ka : ɛ ‑kɔ' nyɔ due' ‑po' ko 'de ɔ o ‑kle. ");
INSERT INTO wob_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","‑Bo ɔ 'mʋ o, ‑bo ɔ ‑te \"jriɛ \"i \"maʋ' o, 'jrʋ ‑gbao o, ka ko a nʋa mɛsʋn, ɩa nʋa 'boasʋn ɔɔ' juɩ. ");
INSERT INTO wob_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","'Blʋa 'a ‑cɛ\" mɛ ‑ɛɛ mɛɛ dɩ. \"I‑saa nɔ\" ko a bla \"mɛɩ', ‑jɛ ‑tba' 'o ɛ, ɩa nʋɛ kpai‑, ‑wɛe de 'bɔɔ‑ nɔ\" ɛ ɩa wa ɩa ku ‑tɩ. ");
INSERT INTO wob_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","‑Bo ko ‑flu\" 'sʋ ɛ, nyʋ \"duɛ ‑cnɛ 'ʋn ‑wɛe nyʋ a cɩn, dɛ‑nʋɛ' ɩa' cɛn nɔ\" ‑nyni'. ");
INSERT INTO wob_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Sesi wlu' ke'wlɛ, ɔ 'na : Ka ‑a ‑je Kea 'a kɛɛma' ‑kwlɔ 'ɔ \"ipoo ɛ‑ ? Dɛ ‑ke ɛ ‑kooɔ' \"i ‑gblein' ɛ‑ ? ");
INSERT INTO wob_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Ɛ ‑kɔ' tu jɔ ‑saan\" due' nyɔɔ do‑ 'de 'blʋ 'ʋn. Ɛɛ' tu jɔ tu 'piiɛ \"i 'de tu jɔ ‑wee' \"klu. ");
INSERT INTO wob_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","'Kaa ‑bo nyɔ do ɛ, ‑wɛe ɛ mɛ, ɛɛ 'booa ɛɛ jea doodɩ ‑wee' \"klein ‑sii'. Ɛɛ ‑sa' 'dae‑ ka nʋʋɩ 'bɛɛ ɩ 'jea 'jro po 'de ɛ ja. ");
INSERT INTO wob_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","\"Ipoo‑tɩ ‑nɩ, mɩ Sesi a nʋ ‑wɛe ɔɔ 'tmʋʋ ʋʋpʋ Kea 'a wlu ka ʋʋ 'je ɛ 'mii 'wɔn ɛ. ");
INSERT INTO wob_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Ɔ se ɛ 'bɛɛ‑ ɔ 'je ʋʋpʋ 'tmʋʋ‑ ‑bo ɔ se ‑tɩ' \"i poo ɛ. 'Kaa ‑bo ɔ ke ɔɔ' klai\" nynuu 'a 'sʋ ‑te i ɛ, ɔɔ ‑sa' dɩ ‑wee' \"klein wɔ 'de ʋʋpʋ ‑pee. ");
INSERT INTO wob_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","'Wɩ due' koʋn ‑nɛ ɛɛ' ‑kwie\" ka a, Sesi 'tmʋʋɛ ɔɔ' klai\" nynuu ɔ 'na : ‑A mu 'e \"ni 'de. ");
INSERT INTO wob_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","'Sʋ ʋʋ \"taiɛ nyiɔ ‑pʋ \"i ‑wɛe ʋʋ mu ‑gbɛin\" woi. ‑Kwɛɛ\" ‑ɛ 'di Sesi nɩa ‑wɛe ɔ 'tmʋa nyʋ ɛ, ɛmɛ ‑kpa' ɔ ke ɔɔ' klai\" nynuu. ‑Kwɛɛ\" jrɩ' ‑nɩ 'o mu ‑ke. ");
INSERT INTO wob_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","'Sʋ ‑piie ‑teɛ jia' ‑pʋn\". \"Ni 'a 'plɩ a 'wla 'de ‑kwɛɛ\" 'di, ɛɛ jea ‑kwɛɛ\" \"ji sɔɔn‑ sɔɔn‑. ");
INSERT INTO wob_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Sesi 'pɛn i 'de ‑kwɛɛ\" 'ɛ ‑gbɔo o ‑wɛe ɔ po dɛ \"jru \"kpei 'de ɔɔ 'mʋ. Ɔɔ' klai\" nynuu ‑sɔ \"nyɩɔ' ‑wɛe ʋʋ 'na : Nyʋ dɛtɔɔi, ka ‑aa jia 'mɛa' a, ɛ se ‑ʋn ka jrɔ' \"i 'daa ? ");
INSERT INTO wob_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Sesi sɔan ‑klu' ɛ, ɔ \"wɔɔɛ ‑piie ke \"ni \"jru i ɔ 'na : Ɩ 'bɔ, ɩ ji ja ! 'Sʋ ‑piie 'bɔ ji ‑tɩ 'mɛ, ‑ta ‑wee' nɩɛ ‑snii'. ");
INSERT INTO wob_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","'Sʋ Sesi wlu' 'de klai\" nynuu ‑pee ɔ 'na : Dɛɛ‑tɩ faʋn a nʋ aopʋ‑ ɛ‑ ? Kea ‑kwlɩ\" ‑tea' se 'de aopʋ‑ 'ʋn nɩ kee ? ");
INSERT INTO wob_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","'Kaa dɛ waa ʋʋpʋ 'dii, ‑wɛe ʋʋ ‑te wlua' ‑pʋn\" 'de ʋʋpʋ 'a 'sʋ 'nynɩ ʋʋ 'na : Ka mɛ ‑nɩ kan' a‑ ? Ɛ dɛ‑ ? ‑Ta \"ju ‑nɔ ‑mɔ 'wlʋ ‑wɛe ‑piie ke \"ni ‑cɛɛn' ‑nɛ ɛ 'je ɔ wɔn ɛ‑ ? ");
INSERT INTO wob_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Sesi ke ɔɔ' klai\" nynuu nyniɛ 'de \"ni 'de 'de Kelasa nyʋ \"bli. ");
INSERT INTO wob_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Sesi 'wlʋa 'e ‑kwɛɛ\" 'di ɔɔ \"siai 'sʋ \"ju due' ‑suusaʋn nɩa 'e 'ʋn 'wlʋɛ 'e ‑gbaɩn' \"klu ‑ɔɔ ‑jɔɔ \"i. ");
INSERT INTO wob_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","'De ‑gbaɩn' 'nynɩ mɔ ɔ \"ti. Nyɔ jrɔ' se ɔɔ' saan' 'bɛɛ‑ ‑bo ɛ nɩ ‑gbaacɩɛ' \"dbu mɔ 'de ɛ, ɛ se ɔɔ' saan' 'bɛɛ‑. ");
INSERT INTO wob_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","'De 'wɩ ‑tuu\"‑tuu 'di ʋʋ poɛ ɔ nɩɩ ‑gbii bʋ' ‑wɛe ʋʋ saan ɔɔ' sɩn ‑gbaacɩɛ' \"dbu, 'kaa ɔɔ cɛn ‑gbaacɩɛ' \"dbu 'mɛ, ‑wɛe ɔɔ wa nɩɩ ‑gbii. Nyɔ ‑jea \"ikma ‑ɔ ‑je ɔ \"wɔin 'bɛɛ‑ ɔ se nɩ‑. ");
INSERT INTO wob_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","'Jrʋ‑gbao o, \"maʋ\" o, ɔ nɩɛ ‑gbaɩn' 'nynɩ woi ke crʋɩ \"kpei‑ ke‑. Ɔɔ \"wɔɔ‑, ɔɔ nʋɛ \"soi ɔɔ jea ɔɔ' ‑cɛ\" pooa. ");
INSERT INTO wob_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Ɔ 'jeea Sesi nya 'sʋ, ɔ mu' ɔ \"siiɛ 'kɔi‑ i 'bo ɔ \"juɔi. ");
INSERT INTO wob_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","‑Wɛe ɔ \"wɔ kpleiin, ɔ 'na : Sesi, Kea ‑nɩa 'e jaʋn 'di 'a \"Ju, dɛ ‑nɩ ‑ɩn ‑ke 'ma ‑a 'nynɩ ɛ‑ ? 'Ma naa ‑ma ‑so\" 'ma kwɛe‑ 'de Kea 'a 'nynɩ 'ʋn, ‑ɩn ‑bo 'ʋn 'kle \"kpei jaa. ");
INSERT INTO wob_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Ɔ 'tmʋa wlu ‑nɩa 'mʋa‑ ɛ, Sesi wluɛ 'e ‑suusaʋn ‑pee ɔ 'na : Ɛ 'wlʋ 'e \"ju ‑nɔ 'ʋn ! ");
INSERT INTO wob_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","‑Wɛe Sesi ‑tee' ɔ i ɔ 'na : ‑Ma 'nynɩ wɛ‑ ? Ɔ wlu' 'e Sesi ‑pee, ɔ 'na : 'Ma 'nynɩ mɩ ‑nɩ ‑pɔn ‑tun, 'kaa ‑a ‑tiɛi\". ");
INSERT INTO wob_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","'Sʋ ɔɔ bae Sesi 'mɛ ɔ 'na : ‑Ɩn ‑bo ‑a 'blʋa‑ ‑nɛ o tɩɩɛn ! ");
INSERT INTO wob_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","‑Ta ɛ nɩa kan' ‑mɛ be\" 'a ‑gbɔn' jrɛ' mɛ ‑ɛɛ dii 'de crʋ ‑kwlɩ\" 'de ʋʋ ‑pʋn\". ");
INSERT INTO wob_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","'Sʋ ‑siisaɩn baeɛ Sesi i, ɩ 'na : ‑Ɩn ‑tun\" ‑aʋn 'de be\" ‑nɩ o, ‑wɛe ‑a ‑je 'de ɩ 'ʋn pa. ");
INSERT INTO wob_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Sesi cɛn 'o wlu 'mɛ. 'Sʋ ‑siisaɩn 'wlʋɛ 'e \"ju ‑nɔ 'ʋn, ɩ \"siɛ \"kpae', ‑wɛe ɩ mu 'e be\" 'ʋn. Be\" 'a ‑gbɔn' ‑nɛ ‑sa plea' 'de crʋ ‑kwlɩ\" ɩ 'wla 'e \"niɔ‑. Ɩ 'bɛɛ‑ be\" 'a \"wlu 'sɔɔn 'mɛ ɩmɩ blu' \"ni ‑tun. ");
INSERT INTO wob_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Nyʋ ‑tea be\" 'dei ‑wee' ‑gbuu\", ʋʋ 'kpaa ‑kwlɔ 'dii ke ‑gbei\" wei, ‑wɛe dɛ ‑nʋʋa 'de ʋʋa po ɛɛ' \"kuan. 'Sʋ nyiɔpʋ‑ a ‑kwɛ‑ i ʋʋa jiɛ dɛ ‑nʋʋa 'jea. ");
INSERT INTO wob_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Ʋʋ nynia 'de Sesi ‑pʋn\" 'sʋ \"ju ‑siisaɩn 'wlʋa 'e 'ʋn ‑nɔ ʋʋ 'jee ɔ \"jriɛ‑ ‑mɛ ɔ ‑teɛ i, ɔ paa dɩ 'ʋn ka ‑cɔɔn' ka, ɔ \"jru 'di ‑teɛ 'tɩɩn. 'Sʋ dɛ waa ʋʋ 'dii. ");
INSERT INTO wob_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","‑Wɛe dɩ \"klein ‑nʋʋa 'de \"ju ‑siisaɩn nɩa 'ʋn 'a ‑kɔ 'di ɛ, ɛ ke dɩ ‑nʋʋa be\" \"jrii ke, nyʋ ‑jea ɩa' ‑ta a, ʋʋ po ʋʋpʋ ɩa' \"kuan. ");
INSERT INTO wob_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","'Sʋ ʋʋ ‑teɛ Sesi 'a i baea' ‑pʋn\", ‑wɛe ɔ 'je 'de ʋʋpʋ 'a 'blʋa‑ 'di 'wlʋ. ");
INSERT INTO wob_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","‑Ta Sesi a 'jaa 'de ‑kwɛɛ\" 'di 'sʋ \"ju ‑siisaɩn nɩa 'ʋn 'de ɛ, ɔ 'na : 'Ma bae ‑ʋn ‑ɛ 'ɩn 'bɛɛ‑ 'ɩn ke ‑ɩn ‑je muu ? ");
INSERT INTO wob_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Sesi se ɔ ke ɔɔ' mu‑tɩ 'wɔɔn‑, 'kaa ɔ wlu ɔ ‑pee ka ɔ 'na : ‑Ɩn mu 'de ‑ɩn o ‑gbu\" ‑sɔn, ‑wɛe dɩ 'dɔe Tʋ\"bo nʋa ‑ʋn \"jrii ke ka ɛ 'jea ‑ma wɛe ‑ɩn ‑je ɛ 'tmʋ 'de ‑ma 'cɛ‑wi\" ‑pee. ");
INSERT INTO wob_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","\"Ju ‑nɔ mu' ‑wɛe ɔ 'tmʋ dɛ Sesi nʋ ɔ \"jrii 'de 'blʋa‑ ‑nɛ 'ɛ ‑kwlɛ ‑ɩ ‑nɩa ‑puue 'dii. 'Sʋ nyʋ ‑wɔan ɩa' dɩ tu ɛ, tai' \"maa ʋʋpʋ 'mɛ. ");
INSERT INTO wob_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Sesi 'ja 'e ‑kwɛɛ\" 'di ‑wɛe ʋʋ mu 'e \"ni 'de de. ‑Ta ɔ nɩɩa 'o \"ni ‑kwlɩ\" ɛ, nyiɔpʋ‑ ‑tuu\" ‑kɩɩɛn' \"jrui 'de ɔ ‑pʋn\". ");
INSERT INTO wob_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Kea ‑gbu klaa\" 'a ‑jeopoi due' ‑ɔɔ 'nynɩ nɩa Sairisɩ ji'. Ɔ 'jeea Sesi ɛ, ɔ ‑gblee ɔ bʋ wɔ. ");
INSERT INTO wob_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","Ɔ ‑teeɛ' ɔɔ' kwa 'di ɔɔ baeɔ', ɔ 'na : 'Ma \"junynɔkpao' ‑saan\" a jiɛ 'mɛa 'de. 'Ma bae ‑ʋn ‑ɛ, ‑ɩn ‑ji\" 'ʋn o, ‑ɩn ‑je ʋ kwa \"jru ‑te', ‑wɛe ʋa' 'wɛ‑ 'je 'bɔ 'de ʋ 'je 'kmʋ nɩ‑. ");
INSERT INTO wob_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","'Sʋ Sesi ke ɔ mu'. Nyiɔpʋ ‑tuu\"‑tuu ‑kaan ʋʋpʋ de, ‑wɛe ʋʋa \"tuun ɔ ‑ta ‑wee'. ");
INSERT INTO wob_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","'Nynɔkpao' due' ‑nɩ 'e nyʋ \"klu ‑ʋa nymɔ ɔ 'wlʋ 'e ʋ 'ʋn 'sʋ. Ɛɛ' 'wɛ‑ tu nʋɛ ‑sɩn 'a ‑puue 'jɔ 'sɔɔn 'bo ʋ ‑pʋn\". ");
INSERT INTO wob_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Ʋa 'jeɛ ʋa' ‑cɛ\" wɔn jeejee 'de ‑dɔ'crɔ‑wi\" 'kwa, ʋ ‑kwɛ‑ 'kwa i. 'Kaa ʋ se kui ‑sɔn i flɔan' 'ble, ʋa' 'wɛ‑ mɛɛ' ‑cɛ\" ɛ 'kpaa \"kpei sɔɔn‑ sɔɔn‑. ");
INSERT INTO wob_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Ʋ 'wɔan dɩ ‑tmʋʋa' 'de Sesi 'a ‑tɩ' 'ʋn 'sʋ ʋ pa 'e nyiɔpʋ \"klu 'de Sesi 'de fɔ o, ‑wɛe ʋ bla ɔɔ' 'ʋnpaadɩ \"i, ");
INSERT INTO wob_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","dɛ‑nʋɛ' ʋ wlu' 'de ʋa' ‑cɛ\" 'ʋn ʋ 'na, ‑bo 'ɩn 'bɛɛ‑ 'ɩn 'je ɔɔ' 'ʋnpaadɩ mɩ 'a ‑cɛ' \"i bla mɔ 'de ɛ, 'ma 'wɛ‑ ɛ muɛ 'bɔa'. ");
INSERT INTO wob_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","'Bo ɛ \"sri ʋa' nymɔ je \"i 'ka. 'Sʋ ka ʋa' 'wɛ‑ 'bɔa 'de ʋ kui' ʋ juɛ'. ");
INSERT INTO wob_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","\"Junynɔkpao' 'a ‑nɛɛ blɔ \"i 'sʋ ka \"ikmaa' jrɛ' 'wlʋa 'e Sesi 'ʋn ɛ, ɔ 'je kan' 'mɛ. Wɛe ɔ \"biie i 'de nyiɔpʋ 'a ‑kwea'‑, ɔ 'na : ‑Ɔ bla 'ma 'ʋnpaadɩ \"i ɛ‑ ? ");
INSERT INTO wob_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Ɔɔ' klai\" nynuu wlu ɔ ‑pee, ʋʋ 'na : Ka nyiɔpʋ‑ a \"tuuan ‑ʋn i ‑ta ‑wee' ‑ɩn se kan' 'jee ‑wɛe ‑ɩn ‑na ‑ɔ bla 'mi \"i ɛ‑ ? ");
INSERT INTO wob_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","'Kaa Sesi a ‑gbʋɛn ɔ 'de woi ‑wɛe nyɔ ‑nʋa' ɛɛ' dɛ tu ɛ ɔ 'je ɔ 'je. ");
INSERT INTO wob_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Dɛ waa \"junynɔkpao' 'dii ʋa jea crɛ, dɛ‑nʋɛ' ka dɛ jrɛ' nʋ ʋ \"jrii ʋ 'je kan' 'mɛ. Ʋ ji' ‑wɛe ʋ \"sii‑ 'kɔi‑ i 'de ɔ \"juɔi 'de ʋ 'tmʋʋ ɔ tɔ' ‑tɩ ‑wee'. ");
INSERT INTO wob_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Sesi wluɛ ʋ ‑pee, ɔ 'na : 'Ma \"ju, aa' 'ma ‑kwlɩ\" ‑tea' mɛ ‑pʋʋ' aʋn. A mu 'de pɛe 'a blua' 'ʋn ‑wɛe a kui ‑sɔn 'je pee nɩ‑. ");
INSERT INTO wob_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","‑Ta Sesi nɩa wlua' a, nyʋ 'wlʋɛ 'e Sairisɩ o ‑gbu\" ʋʋ je ji, ‑wɛe ʋʋ wlu ɔ ‑pee ʋʋ 'na : ‑Ɩn ‑bo nyʋ dɛtɔɔi seea 'bode. ‑Ma \"ju 'mɛɛ. ");
INSERT INTO wob_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","'Kaa Sesi se ʋʋa' wlu ‑nɛ ‑kwlɔ kpa ɔ 'tmʋʋɛ Sairisɩ ɔ 'na : Faʋn 'bo ‑ʋn ‑nʋʋɛ, ‑te' 'ʋn ‑kwlɩ\". ");
INSERT INTO wob_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","'Sʋ ɔ se nyɔ jrɔ' ɔɔ' ‑jei\" kpa‑tɩ 'wɔɔn‑ ‑bo ɛ se Piɛi o, Sakɩ ke ɔɔ' \"dei San nɩ ɛ. ");
INSERT INTO wob_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","‑Ta Sesi ke ʋʋpʋ a nynia 'de Sairisɩ o ‑gbu\" ‑mɛ ‑fɩn\" ‑cruɛn\" ɛ 'kpaa, nyiɔpʋ a kple', ʋʋa bla ʋʋa' ‑cɛ\" i. ");
INSERT INTO wob_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Ɔ pa 'e ‑gbu\" 'di, ‑wɛe ɔ wlu ʋʋpʋ ‑pee ɔ 'na : Dɛ ‑ble ‑tiba ‑ti ka a, 'de dɛ ‑ɛɛ ‑fɩɩn\" aopʋ‑ ɛ‑ ? \"Ju‑saan\" se 'mɛ, ʋa 'mʋʋ. ");
INSERT INTO wob_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","'Sʋ ʋʋa wlɔɔ'. ‑Wɛe ɔ po nyʋ ‑wee' \"kpae'. 'De ɔ \"duo \"ju ‑saan\" \"bo ke ʋ de ke ɔɔ' klai\" nynuu ‑nɩa taan 'ʋn, ‑wɛe ʋʋ pa 'e ‑gbu\" 'a wɔn 'di ‑ta \"ju ‑saan\" 'pɛan i ɛ. ");
INSERT INTO wob_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Ɔ kpʋn ɛ \"ju ‑saan\" 'a sʋn ‑wɛe ɔ wlu 'de ʋ ‑pee 'de ɔ \"bliwlu 'di ɔ 'na : Talita kum, ɛ 'de mɛ ‑nɩ : 'Nynɔkpao' ju 'ma 'tmʋʋ aʋn 'ɛ, a sɔn 'ʋn ! ");
INSERT INTO wob_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","'Bo ɛ \"sri, ʋ je 'ʋn sɔn‑, ʋ je naa' ‑pʋn\" ‑te'. \"Junynɔkpao' ‑saan\" ‑nʋ 'bleɛ ‑sɩn ‑puue 'jɔ 'sɔɔn. ‑Ta ʋʋ 'jeea dɛ ‑nʋʋa 'mʋa‑ \"jriɛ‑ 'sʋ tai' \"maa ʋʋpʋ 'mɛ, ɛ je ‑je \"kpei ‑tie\" cɛn. ");
INSERT INTO wob_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","'Kaa Sesi criɛ ɛɛ' ‑cɩɛ 'de ʋʋ ‑pee ‑wɛe nyɔ jrɔ' je ɛ juo‑. ‑Wɛe ɔ 'tmʋʋ ʋʋpʋ ɔ 'na : Ao \"nyɩ \"ju ‑saan\" dɛ ʋ 'je di. ");
INSERT INTO wob_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Sesi 'wlʋa 'de Sairisɩ o ‑gbu\" 'sʋ ɔ ke ɔɔ' klai\" nynuu muɛ 'de ɔ o ‑kwlɔ. ");
INSERT INTO wob_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Ɔ ‑teɛ nyʋ dɛ tɔɔa' ‑pʋn\" 'bo ‑kwlewɩ \"kpei, 'de \"jrui 'kɩɩn‑gbu 'di. Nyiɔpʋ ‑tuu\" ‑poa' ɔɔ' wlu doin\" o tai' \"maa ʋʋ ‑wee' 'mɛ, ʋʋ 'na : ‑Ta ɔ ‑sa ‑mɛ ɛ‑ ? ‑Ɔ ‑nyɩ\" ɔ ɛɛ' \"ikmaa' tu ɔɔ jea jrii' ‑jɩ ‑mɩ nʋ ɛ‑ ? ");
INSERT INTO wob_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Ɛ se ɔ mɔ ‑nɩ Madi 'a \"ju ‑ɔɔ koa ‑gbu\" nɩ ‑taa ? Ɔɔ' \"dei ‑wi\" se Sakɩ ke, Sosɩ ke, Suidɩ ke, Simɔ nɩɩ‑ ? Ɔɔ' \"deinynʋkpae' ‑wi\" se 'de ‑a \"klu nɩ ‑taa ? Ɛ nʋɛ' 'sʋ ʋʋ se ɔɔ' ‑tɩ' tɔ' 'ʋn 'je. ");
INSERT INTO wob_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","'De Sesi wlu ʋʋ ‑pee ɔ 'na : Nyɔ 'ɔ ‑flɛɛn Kea 'a wlu 'kwajaai ‑bo ɛ se 'bo ɔ o ‑kwlɔ ke ɔ o ‑gbɛin\" ke ɔ o ‑gbu\" ‑sɔn nɩ ɛ. ");
INSERT INTO wob_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","'De ɛɛ' ‑tɩ' 'ʋn ɛ, ɔ se \"ikmadɩ jrɩ' nʋ 'mʋa‑ ‑bo ɛ se ɔ ‑teɛ 'wɛnʋʋn pla kwa \"jru ‑wɛe ʋʋa' 'wɛ‑ 'bɔ nɩ ɛ. ");
INSERT INTO wob_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Dɛ Kea ‑kwlɩ\" ‑tea' sea 'de ʋʋpʋ 'ʋn nɩ ɛ, ɛ \"maa Sesi tai', ɛmɛ ‑tɩ ɔ mu ‑kwlɔ jrɩ' ‑nɩa ɔɔ' ‑kwlɔ 'de woi 'dii, 'de ɔɔ tɔɔ nyʋ Kea 'a wlu. ");
INSERT INTO wob_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Ɔ 'da ɔɔ' klai\" nynuu ‑nɩa ‑puue 'jɔ 'sɔɔn 'mɛ ‑wɛe ɔ dbo ʋʋpʋ 'sɔn 'sɔn. Ɔ \"nyɩ ʋʋpʋ \"ikmaa' ‑wɛe ʋʋ 'je ‑siisaɩn wɔn ‑sii. ");
INSERT INTO wob_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","‑Wɛe ɔ bla kɛ' ɔ \"nyɩ ʋʋpʋ ɔ 'na : Ao 'bo dɛ \"o dɛ 'ʋn \"duɛ ɛ ke ao 'bo muɛ, ‑bo ɛ se itbatu 'a 'sʋ nɩ ɛ. Ao 'bo ‑di'pɛn ke‑ ‑kebou\" 'ʋn \"duɛ 'de ao 'bo 'wɛi 'de aoa' wlʋ 'di poɛ. ");
INSERT INTO wob_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","'Kaa ao paa \"kwlai‑ bɩ', ao 'bo \"bai 'sɔɔn 'ʋn paa‑. ");
INSERT INTO wob_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Ɔ wlu ʋʋpʋ ‑pee ke'wlɛ ɔ 'na : ‑Bo ao nyni 'o ‑kwlɔ due' 'di ɛ, ‑mɛ ‑gbu\" ‑ɛ 'di nyʋ a mu ao sɩn 'sɔɔn kpʋʋn 'a a, ao ‑te 'de ɛ 'di i mamaʋ 'sʋ ao 'je 'o 'wlʋ. ");
INSERT INTO wob_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","'De ‑bo ao nyni 'o ‑kwlɔ jrɛ' 'di ‑wɛe nyʋ se aopʋ sɩn 'sɔɔn kpʋʋn ɛ, 'de ʋʋ se aoa' wlu doin\" o po ɛ, ao 'wlʋ 'o ɛɛ' ‑kwlɔ ‑tu 'di. Ao ‑gbao' ʋʋa' ‑kwlɔ 'ɔ 'blʋ ‑ɛ kpʋn a aoa' bɩ ɛ. Ɛmɛ ‑ɛ ‑je ʋʋpʋ fɛn' ‑saa ka 'pee a mua ʋʋpʋ kpʋn 'a a. ");
INSERT INTO wob_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Klai\" nynuu mu' 'sʋ ʋʋ ‑teɛ nyiɔpʋ‑ 'a 'tmʋa' ‑pʋn\" ʋʋ 'na : Ao juo aoa' dɛsaʋn \"i ‑wɛe ao 'je ɛ kwa ‑sɔn ‑saa. ");
INSERT INTO wob_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Ʋʋa nʋɛ ‑siisaɩn ‑tuu\" i, ‑wɛe ʋʋa po 'wɛnʋʋn ‑tuu\" 'cna \"jru ‑wɛe ʋʋa' 'wɛ‑ ɛ 'bɔ. ");
INSERT INTO wob_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Sesi 'a 'nynɩ ‑gbaa ‑ta ‑wee' \"klein i, ɩ mu' ɩ je 'beɔ Erodɩ jɛɛ ‑ke. Nyʋ jrʋ' wlu' ka ʋʋ 'na : \"Ju ‑nɔ, ɛ San Batisɩ ‑ji\" 'kmʋ de, ɛmɛ ‑tɩ ɔ kmai\", ‑wɛe ɔɔ nʋ jrii' ka. ");
INSERT INTO wob_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Deejrʋ' 'na : Ɛ Kea 'a wlu 'kwajaai Eli ‑o. Nyʋ jrʋ' wlu' ke'wlɛ ʋʋ 'na : Kea 'a wlu 'kwajaaʋn ‑nɩa 'de ɛ, ʋʋa' due' ‑o. ");
INSERT INTO wob_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","‑Ta Erodɩ 'wɔan ɛɛ' dɛ tu ɛ, ɔ 'na : San Batisɩ ‑ɔɔ \"jru 'ɩn cɛan 'o ɛ, ɔmɔ ‑ji\" 'kmʋ de. ");
INSERT INTO wob_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","See 'de ɛ, Erodɩ mɔɔ' ‑cɛ\" dboɛ nyʋ ʋʋ je San kpʋn ʋʋ je ɔ san, ʋʋ je ɔ ‑kaso 'di po. Erodɩ nʋ ɛɛ' dɛ tu 'mɛ 'de ɔɔ' \"dei Filipʋ 'a 'nynɔ Erodiadɩ ɔ ‑sɔ 'kwa 'a ‑tɩ' 'ʋn. ");
INSERT INTO wob_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","San Batisɩ ‑mɔ wluɛ Erodɩ ‑pee 'de‑, ɔ 'na : Ɛ se ka ‑cɔɔn' ka nɩ‑ ‑wɛe ‑ɩn ‑je ‑ma \"dei 'nynɔ 'kwa ‑sa. ");
INSERT INTO wob_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Erodiadɩ 'kpaa' San 'cɛn i. Ʋ nɩɛ \"i ʋ 'je ɔ 'dba. ");
INSERT INTO wob_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","'Kaa ʋ se ɛ 'bɛɛ‑, dɛ‑nʋɛ' Erodɩ ‑mɔɔ plee San 'mɛ. Dɛɛ ‑tɩ Erodɩ a pleea San a, ɛmɛ ‑nɩ ɔ 'srɛi\" ɔ nɩɛ Kea 'a nyɔ ‑o, ɛmɛ ‑ɛɛ ‑tɩ' 'ʋn ɔɔ 'wlʋ ɔ o. ‑Bo Erodɩ a sea San 'a wlu doin\" o po ɛ, 'fɔ ‑jɛ ɔ 'jea 'o ‑sa ɔɔ' 'jeɛ. 'Kaa ɔɔ' wlu 'a doin\" o poa' a nʋ ɔ 'tʋn. ");
INSERT INTO wob_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","'Wɩ 'dɔe jrɛ' 'kpa Erodiadɩ 'kwa. Ʋʋa ‑tu\" ɛ Erodɩ 'a 'wlʋwɩ 'a ‑kɔ'. Ɔ 'da ɔɔ' nyʋ klae\" o, \"soa‑wi\" 'a klae\" o, dɛ \"ijuoʋn ‑nɩa 'de Galile ‑kɔ' ‑sɔn. ");
INSERT INTO wob_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Erodiadɩ 'a \"junynɔkpao' pa ‑gbu\" ‑wɛe ʋ ‑te deea' ‑pʋn\". Ʋa' deebʋ nʋɛ Erodɩ ke ɔɔ' nyʋ ɔ 'da 'tʋn. 'Demɔ ɔ wlu ʋ ‑pee ɔ 'na : Dɛ a nɩa \"i ɛ, a ‑teeɛ' 'mi i 'ɩn 'je ɛ aʋn \"nyɩ. ");
INSERT INTO wob_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","‑Wɛe ɔ cɛn wlu ‑tie\", ɔ 'na : 'Ma ‑snɛɛ' dɛ aa mua i ‑teea' a, 'ma muɛ aʋn \"nyɩa', ‑bo ɛ nɩ 'ma 'blʋa 'a 'fɔ mɔ 'de ɛ. ");
INSERT INTO wob_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","'Sʋ 'nynɩa ‑tɔo ‑nʋ \"siɛ \"kpae' ‑wɛe ʋ to ʋ de \"jru \"i ʋ 'na : Dɛ 'ɩn 'je i ‑tee' ɛ‑ ? Ʋ de 'na : A ‑tee' San Batisɩ 'a \"jru i. ");
INSERT INTO wob_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","'Sʋ ʋ jiɛ de ‑too\"‑ 'de 'beɔ o ‑wɛe ʋ 'na : 'Ɩn nɩɛ \"i ‑ɩn ‑je San Batisɩ \"jru \"i ‑sa ‑wɛe ‑ɩn ‑je ɛ 'sɛti 'di ‑te' ‑ɩn ‑je 'ʋn \"nyɩ ‑ta kaan. ");
INSERT INTO wob_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","'Sʋ 'beɔ \"kaeɛ \"jrii, 'kaa ɔ se ɛ 'bɛɛ‑ ɔ 'je ʋ \"nao‑ 'de wlu ɔ cɛan ‑tie\" 'de nyʋ ɔ 'da \"juɔi 'a ‑tɩ' 'ʋn. ");
INSERT INTO wob_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","'Bo ɛ \"sri ɔ je \"soai due' dbo ɔ je San Batisɩ \"jru \"i cɛan' mu. \"Soai ‑nɔ muɛ 'e ‑kasogbu 'di, ɔ cɛn 'o San 'a \"jru 'mɛ. ");
INSERT INTO wob_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","‑Wɛe ɔ ‑teɛ' 'e 'sɛti 'di 'de ɔ \"nyɩɛ 'nynɩa ‑tɔo ‑nʋ, ‑wɛe ʋmʋ \"duɛ 'ʋn ʋ \"nyɩ ɛ ʋ de. ");
INSERT INTO wob_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","San 'a klai\" nynuu 'wɔan ɔɔ' 'mɛ ‑tɩ ɛ, ʋʋ ji' ʋʋ je ɔɔ' \"ku 'ʋn \"duo‑, ʋʋ je ɔ i ‑te'. ");
INSERT INTO wob_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Sesi 'a dboʋn jiɛ 'de Sesi o de, ‑wɛe dɩ ʋʋ nʋa o, dɩ ʋʋ tɔɔa nyʋ ʋʋ po ɩa' \"kuan 'de ɔ ‑pee. ");
INSERT INTO wob_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Nyiɔpʋ a nʋɛ ‑ɩn mu ‑ɩn ji. 'De ʋʋa' \"i ‑tie ‑tɩ' 'ʋn ɛ, ka Sesi ke ɔɔ' klai\" nynuu 'jea dɛdisʋn nʋ 'ka se nɩ‑. Ɛmɛ ‑tɩ ɔ wlu ʋʋ ‑pee ɔ 'na : Ao ji ‑a ‑je ‑ta nyɔ jrɔ' sea nɩ mu ‑wɛe ao 'je 'o fɔn dɛ‑saan\"‑. ");
INSERT INTO wob_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","‑Wɛe ʋʋ \"duo ‑kwɛɛ\" 'ʋn 'de ʋʋ mu 'de ‑ta ‑nɩa pee ɛ, ");
INSERT INTO wob_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","'kaa nyiɔpʋ‑ ‑tuu\" 'je ʋʋpʋ 'a mu ‑ta 'mɛ. Ʋʋ jua ʋʋpʋ \"i 'sʋ ɛ, ʋʋ 'wlʋɛ ‑kwlɛ 'dii ‑ta ‑wee', ʋʋ pleɛ 'blʋɔi ‑wɛe ʋʋ cɛɛn Sesi ke ɔɔ' klai\" nynuu nya i. 'Sʋ ‑ta ʋʋa muua, ʋʋpʋ ‑nyni' 'o mu tɛin\". ");
INSERT INTO wob_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","‑Ta Sesi 'wlʋa 'de ‑kwɛɛ\" 'di ɛ, ɔ 'jeeɛ nyiɔpʋ ‑tuu\" \"jriɛ‑, ʋʋpʋ 'a wɛe a nʋɔ', dɛ‑nʋɛ' ʋʋ ‑kɔ' 'blae ‑sea' 'dei ‑tei 'ble ɛ. ‑Wɛe ɔ ‑te ʋʋpʋ 'a dɩ ‑tuu\" tɔɔa' ‑pʋn\". ");
INSERT INTO wob_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","‑Ta ‑fli 'wla a 'sʋ ɔɔ' klai\" nynuu 'kpɔ ‑pʋn\", ʋʋ 'na : Nɔ\" ‑wee' ‑si' 'de ‑ta nɩɛ 'kpaa \"kpei. ");
INSERT INTO wob_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","‑Ɩn ‑tai\"‑ ʋʋpʋ \"i ʋʋ 'je ‑gbei\" woi ke ‑kwlɛ ‑kʋʋan\" i 'dii mu, ‑wɛe ʋʋ 'je diidɛ i ‑pɔn. ");
INSERT INTO wob_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","'Sʋ Sesi wluɛ ʋʋ ‑pee ɔ 'na : Aoa' ‑cɛ\" 'kpa \"nyɩ ʋʋ diidɛ. 'Sʋ ʋʋ ‑tee' ɔ i ʋʋ 'na : ‑Ɩn ‑nɩɛ \"i ‑a ‑je 'wɛi 'a kmɛ' 'sɔɔn 'ʋn \"duo‑ ‑a ‑je ɛ ‑di'pɛn 'ʋn ‑tɩan' mu, ‑a ‑je ʋʋpʋ \"nyɩ ʋʋ 'je dii ? ");
INSERT INTO wob_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Sesi ‑teeɛ' ʋʋpʋ i ɔ 'na : ‑Di'pɛn ‑tiiɛ' ao 'ble ɛ‑ ? Ao mu 'e ‑gbʋn. Ʋʋ ‑teeɛ' ba i ʋʋ 'na : ‑A ‑bleɛ ‑di'pɛn kplɩ ‑mm\" ke ‑smii' jɔ 'sɔɔn ke‑. ");
INSERT INTO wob_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","'Sʋ ɔ 'na : Ao 'tmʋʋ ʋʋpʋ ʋʋ 'je kpɔ cɛn ʋʋ 'je i ‑te 'bo sii\" \"kpei. ");
INSERT INTO wob_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","'Sʋ ʋʋpʋ cɛn kpɔ kmɛ' 'due 'due, kwla ‑mm\" ‑mm\" ʋʋ je i ‑te. ");
INSERT INTO wob_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","‑Wɛe Sesi \"duo ‑di'pɛn kplɩ ‑mm\" ‑nɩ ke ‑smii' jɔ 'sɔɔn ‑nɩ 'ʋn ‑wɛe ɔ kpa \"jri \"jɛi ɔ po Kea 'sɛ‑. 'Sʋ ɔ cɩɩɛn ‑di'pɛn i ‑wɛe ɔ \"nyɩ ɔɔ' klai\" nynuu 'de ʋʋ 'je ɩ nyʋ \"jrii ‑gble'. Ɔ ‑seea' ‑smii' jɔ 'sɔɔn ‑nɩa 'mʋa‑ 'ʋn ‑ke ɔ je nyʋ ‑wee' \"klein \"nyɩ. ");
INSERT INTO wob_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Ʋʋ ‑wee' \"klein di', ʋʋ je dbo. ");
INSERT INTO wob_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","‑Di'pɛn 'ɛ tii ke ‑smii' 'a ‑jɩ ‑sia 'e mu ‑wɛe klai\" nynuu 'tɩan i ɛ, ɩ \"jiɛ toe\" 'a ‑puue 'jɔ 'sɔɔn. ");
INSERT INTO wob_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Nyʋ ‑dia' dɩ \"nynunmai 'a \"wlu ‑mm\" ‑nɩ ʋʋpʋ \"klu. ");
INSERT INTO wob_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","‑Ta ʋʋ ‑kɔa' dɛ dia' ‑wɛe Sesi a poa ʋʋpʋ ‑jei\" ɛ, 'bomɔ ɔ poo ɔɔ' klai\" nynuu ‑kwɛɛ\" 'di, ‑wɛe ɔ 'na : Ao mu 'e \"ni 'de, 'de Besaida fɔ o. ");
INSERT INTO wob_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Ɔ ke ʋʋpʋ cɛɛan \"i 'sʋ ɛ, ɔ muɛ Kea baea' 'de crʋ \"kpei. ");
INSERT INTO wob_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","‑Ta kwie a kpʋn a ‑mɛ ‑kwɛɛ\" nɩɛ 'e \"ni pɛʋn klaa\" a ‑kwea'‑ ‑Wɛe Sesi sie due' 'de 'kpʋʋ \"kpei. ");
INSERT INTO wob_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Sesi 'je kan' 'mɛ ka ɔɔ' klai\" nynuu a 'jea 'kle ‑kwɛɛ\" tbaa 'de poɔɔ' ‑ɔ sia' 'a ‑tɩ' 'ʋn ɛ. ‑Ta ‑sɔn' ɔ \"kʋan' i 'sʋ Sesi a na' 'bo \"ni \"kpei ɔɔ jea ʋʋpʋ kɩɩn mu, ɔ nɩɛ \"i ɔ 'je ‑kwɛɛ\" i naa‑. ");
INSERT INTO wob_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","‑Ta ʋʋa 'je ɔ i ɔɔ na 'o \"ni \"kpei ɛ, ʋʋ mu 'na ‑mɛ \"kwle‑sri\" ‑o 'de‑, 'sʋ ʋʋa \"wɔɔ', ");
INSERT INTO wob_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","dɛ‑nʋɛ' ʋʋ ‑wee' ‑a ‑je ɔ i, faʋn a nʋ ʋʋpʋ 'mɛ, ʋʋa dɩ a crɛ'. 'Sʋ Sesi wluɛ ʋʋ ‑pee, ɔ 'na : Ɛ 'mɔ ‑o, faʋn 'bo ao nʋɛ, ao \"duo 'kpɩ 'ʋn ! ");
INSERT INTO wob_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","'Sʋ Sesi 'ja ʋʋpʋ kɩɩn 'de ‑kwɛɛ\" 'di 'sʋ poɔ' 'bɔ ji ‑tɩ 'mɛ. Tai' ‑maa\"‑ klai\" nynuu, ɛ ‑siɛ' ‑jei\". ");
INSERT INTO wob_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","‑Ta Sesi cɛɛan ‑di'pɛn i ‑wɛe ɔ \"nyɩ ɛ nyʋ ɛ, ʋʋ 'je ɛɛ' ‑ta 'mɛ, 'kaa ka ɔ kmai\" ɔ 'bɛɛa ɔ 'jea jrii' nʋ ɛ, ʋʋ se ɛ 'mii 'wɔn ke, dɛ‑nʋɛ' ʋʋa' dɛ 'mii 'wɔan' nɩɛ 'kle. ");
INSERT INTO wob_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Ʋʋ cɛan \"ni 'sʋ ʋʋ nyniɛ 'e Senesarɛtɩ 'bomɔ ʋʋ kpʋʋn 'kpʋʋ. ");
INSERT INTO wob_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Ʋʋ 'wlʋa 'e ‑kwɛɛ\" 'di 'sʋ nyiɔpʋ juuɛ Sesi \"i. ");
INSERT INTO wob_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","‑Wɛe ʋʋ ple 'blʋa‑ ‑wee' \"kpei‑, ʋʋ 'blee 'wɛnʋʋn 'sai‑ 'dii ‑wɛe ‑ta ʋʋ 'wɔɔan Sesi 'a 'nynɩ ʋʋa kpa ʋʋpʋ 'o mu. ");
INSERT INTO wob_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","‑Ta \"o ‑ta Sesi mua, ‑kwlɛ mɩɩ\" 'di o, ‑kwlɛ klae\" 'dii o, ‑gbei\" woi o, nyʋ a ja 'wɛnʋʋn 'bo \"kpae' ‑kwea ‑wɛe ʋʋa bae Sesi i 'de ɔ 'je ʋʋ \"i \"tai‑, ʋʋ 'je ɔɔ' \"bai \"i bla. Nyʋ \"klein ‑blɔ' \"i ɛ, ʋʋa' 'wɛ‑ 'bɔɔ. ");
INSERT INTO wob_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Fariseɛn o, kɛ' wɔ‑saʋn jrʋ' ‑wlʋa Selisalɛm 'kɩɩɛn \"jrui 'bo Sesi ‑pʋn\". ");
INSERT INTO wob_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Ʋʋ 'jeɛ ɔɔ' klai\" nynuu jrʋ' ‑ʋʋ se kwa jre ‑ʋʋa di dɛ. ");
INSERT INTO wob_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","‑Bo Fariseɛn‑wi\" o, Suifʋ‑wi\" 'je dɛ di ʋʋa jreɛ kwa ka ʋʋa' tɛin\" nyʋ \"sia 'nynɩ ɛ. ");
INSERT INTO wob_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Ʋʋ 'bleɛ ʋʋa' \"ni kwa posʋn jrɛ' see 'de ʋʋpʋ \"bli. ‑Bo ʋʋ 'wlʋ \"kpae' woi ‑wɛe ʋʋ 'je dɛ di ɛ, ɛɛ' \"ni kwa posʋn tu mɛ ʋʋa nʋ, ‑wɛe ʋʋ 'je 'pepe nɩ‑. Ʋʋa' tɛin\" nyʋ 'a kplɩn ‑tuu\" ‑nɩ 'e mu ʋʋa nʋ ke'wlɛ, ɛmɛ ‑nɩ ‑kaun\"‑ o, \"tiedɩ o nɩɩjae‑ wɔɔa' ke‑. ");
INSERT INTO wob_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Fariseɛn ke kɛ' wɔ‑saʋn ‑teeɛ' Sesi i ʋʋ 'na : Dɛɛ‑tɩ ‑ma klai\" nynuu 'a 'je tɛin\" nyʋ 'a kɛ' wɔn, ‑wɛe ʋʋa' po \"ni kwa 'sʋ ʋʋa di dɛ ɛ‑ ? ");
INSERT INTO wob_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Sesi wluɛ ʋʋpʋ ‑pee ɔ 'na : Ao \"jridepooʋn ! Dɛ Esai 'tmʋa 'de aopʋ 'a ‑tɩ' 'ʋn, ɔ 'bleɛ ‑kɩn. Ɔ 'naa : Kea 'na : 'Ma ni' ‑tea' nɩɛ 'e nyʋ ‑nʋ wɔn 'di foo\" 'ʋn, 'kaa ʋʋpʋ 'a pɛe tɛɛn 'ʋn o. ");
INSERT INTO wob_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Ʋʋa ‑gbɛɛ' 'ʋn \"juɔi foo\" 'ʋn, nyiɔ 'ɔ kɛ' mɛ ʋʋpʋ a 'daa‑ Kea 'a wlu. ");
INSERT INTO wob_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","'De Sesi 'na : Ao 'bɔ Kea 'a kɛ' 'mɛ ‑wɛe aoa 'je nyiɔ 'ɔ ‑nɩ wɔn. ");
INSERT INTO wob_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Ɔ wlu ʋʋpʋ ‑pee ke'wlɛ ɔ 'na : Aoa' ‑blaa Kea 'a kɛ' wɔin ‑wɛe ao di aoa' ‑cɛ\" 'ɛ kplɩn wɔn 'jea ‑mɛ 'ɛ ‑kla. ");
INSERT INTO wob_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Tɔ' ‑o ‑cɛɛn'‑, Moisɩ 'na ‑ɩn ‑je ‑ɩn \"bo ke ‑ɩn de wɔn, 'de nyɔ ‑ɔɔ mua ɔ \"bo ke de ‑soo' o poa' a, nyʋ a mu ɔ 'dbaa'. ");
INSERT INTO wob_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","'Kaa aopʋ mɔ ɛ, ao 'na ‑bo nyiɔ wlu ɔ \"bo ke ɔ de ‑pee ɔ 'na : Dɛ 'ɩn 'blea ‑wɛe 'ɩn 'je ‑aʋn kwa wɔi ‑te' 'de ɛ, ɛ nɩɛ Kea 'a dɛ ‑o. Ʋʋa 'daa‑ ɛ Korban 'de Suifʋwlu 'di. ");
INSERT INTO wob_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Aoa' 'wɔn ɔɔ' jei tu 'a ‑te' ɔ \"bo ke ɔ de kwa wɔi mɔ \"pɩ. ");
INSERT INTO wob_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","'Kamɔ aopʋ‑ a nʋ 'sʋ aoa ‑sa' Kea 'a wlu i 'de aoa' nyʋ dɛtɔɔsʋn 'ʋn. Aoa nʋ dɩ ‑tuu\"‑tuu jrɩ' ke'wlɛ ‑ɩ ‑ke ‑mɩ ‑koɔ'. ");
INSERT INTO wob_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Sesi 'da nyʋ ‑wee' 'mɛ ke'wlɛ ɔ 'na : Ao ‑wee' \"klein po doin\" i, 'de ao 'je dɛ ‑nɛ 'mii 'wɔn. ");
INSERT INTO wob_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Dɛ ‑ɛɛ ‑wlʋa 'e \"kpae' ‑wɛe ‑ɛɛ pa 'e nyiɔ wɔn 'di ɛ, ɛɛ' kpʋʋn nyiɔ ‑flɛn\", 'kaa dɩ ‑ɩa ‑wlʋa 'e nyiɔ 'ʋn ‑ɩa ‑sia\" \"kpae' ɛ, ɩmɩ ‑ɩa kpʋʋn ɔ ‑flɛn\". ");
INSERT INTO wob_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","‑Bo ao nɩ i'wɔnnyʋ ɛ, ‑mɛ ao po doin\" i 'pepe, ‑wɛe ao 'je i 'wɔn. ");
INSERT INTO wob_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","‑Ta Sesi 'wlʋa 'e nyʋ \"klu ‑wɛe ɔ pa 'e ‑gbu\" jrɛ' 'di ɛ, ɔɔ' klai\" nynuu ‑teeɛ' \"i poo ‑tɩ ɔ pooa \"i 'dei. ");
INSERT INTO wob_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","'Sʋ ɔ 'na : Aopʋ mɔ ‑ke ao se ɛ 'bɛɛ‑ ao 'je ɛ 'mii 'wɔɔn ? Ao se ɛ juo ka dɛ ‑ɛɛ ‑wlʋa 'e \"kpae' ‑wɛe ‑ɛɛ pa 'e nyiɔ wɔn 'di se ɛ 'bɛɛ‑ ɛ 'jea nyiɔ ‑flɛn\" kpʋʋn ɛ ? ");
INSERT INTO wob_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Ɛɛ' dɛ tu 'a pa 'e nyʋ pɛe o, 'kaa 'de ɔɔ' \"kwli 'di 'bo ɛɛ pa, ‑wɛe ɛɛ 'wlʋ ɔ 'ʋn ɛɛ \"si \"kpae' 'de ɛɛ mu 'e 'kwla. ‑Bo Sesi a sea wlu ‑nɛ 'tmʋ ɛ, ‑mɛ ɔ 'na : Nyɔ 'beeɛ' ɔ 'je dɩ ‑wee' di. ");
INSERT INTO wob_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Sesi wlu' ke'wlɛ ɔ 'na : Dɛ ‑wlʋa 'e nyiɔ 'ʋn ɛ, mɛ ‑ɛɛ kpʋʋn ɔ ‑flɛn\". ");
INSERT INTO wob_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","'De nyiɔ 'ʋn, 'de ɔ pɛe o, 'bo tɔ' saʋn a 'wlʋ : Kao' blea o, \"jriia' o, \"ku'dbaa' o, ");
INSERT INTO wob_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","jɛi\" 'jea' o, \"wliiɛ 'ɛ 'tʋn o, 'diwɔnynia' o, nyʋ 'srɛ ipooa' o, dɛ \"ni 'di ‑sia' o, dɛ 'ɛ pɛe \"ipoa' o, nyʋ ‑flɛɛn 'a o, ‑cɛi\" 'bɛɛa' o, ‑ɩn se tɔ' 'ble o, ");
INSERT INTO wob_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","dɩ \"klein ‑nɩa 'mʋa‑, ɩa 'wlʋɛ 'e nyiɔ 'ʋn ɩmɩ ‑ɩa kpʋʋn ɔ ‑flɛn\". ");
INSERT INTO wob_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Sesi 'wlʋa 'mʋa‑ ɔ muɛ 'e Tii ke Sidɔn‑blʋa \"kpei. Ɔ pa 'e ‑gbu\" jrɛ' 'di, ɔ se ɛ \"i nɩ ‑wɛe kɔ nɩa 'o nyʋ 'je ɛ juo‑, 'kaa ɛ se 'bɛɛ‑, ʋʋ 'jeɔ'. ");
INSERT INTO wob_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","'Nynɔkpao' due' ‑ʋa \"junynɔkpao' ‑suusaʋn nɩa 'ʋn ɛ, ʋ 'wɔn Sesi 'a 'nynɩ 'mɛ ‑ke. Ʋ ji' ‑wɛe ʋ ‑gblee ɔ bɩ wɔ. ");
INSERT INTO wob_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","'Nynɔkpao' ‑nʋ nɩɛ 'blʋa‑ 'srʋ 'di nyɔ ‑o. Ʋ 'wlʋɛ Fenisi 'de Siriblʋa \"kpei. Ʋ baeɛ Sesi i, ɔ 'je ʋa' \"junynɔkpao' ‑suusaʋn 'ʋn ‑sa. ");
INSERT INTO wob_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","'Kaa Sesi wlu ʋ ‑pee ɔ 'na : A \"tai‑ \"nynuu‑ \"i ʋʋ 'je dbo ke, nyʋ \"duo \"nynuu 'a diidɛ 'ʋn ‑wɛe ɔ \"nyɩ ‑gbe' nynuu‑, ɛ se \"inmɔ‑. ");
INSERT INTO wob_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","'Sʋ ʋ 'na : tɔ' ‑tɩ ‑o ‑cɛɛn'‑, 'ɩn \"bo, 'kaa dɩ ‑jɩ ‑a blua \"nynuu‑ wɔi, ‑gbe' mɛ ‑ɛɛ di. ");
INSERT INTO wob_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","'Sʋ Sesi wlu ʋ ‑pee ɔ 'na : Dɛ a 'tmʋa ‑nɛ, ɛɛ' ‑tɩ' 'ʋn ɛ, a mu ! ‑Suusaʋn 'wlʋ 'e aa' \"ju 'ʋn 'ɛ. ");
INSERT INTO wob_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","‑Ta ʋa mua 'de ʋ o ‑gbu\" 'di kan' ‑cɛɛn' ɛ, ‑mɛ ʋa' \"ju 'pɛn i 'de ‑gbao\" \"kpei, ‑suusaʋn 'wlʋ 'e ʋ 'ʋn 'ɛ. ");
INSERT INTO wob_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Sesi 'wlʋa 'o Tii‑blʋa \"kpei 'sʋ ɛ, ɔ cɛɛn 'de Sidɔn ‑wɛe ɔ mu 'de 'blʋa‑ ‑blea ‑kwlɛ ‑puue 'di, 'bo \"ni pɛʋn klaa\" ‑nɩa 'e Galile o fɔ o. ");
INSERT INTO wob_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Ʋʋ jɔ \"ju due' ‑ɔɔ' 'wɔan i 'de ‑ɔɔ' wlua, ‑wɛe ɔ 'je ɔ kwa \"jru ‑te'. ");
INSERT INTO wob_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","‑Wɛe Sesi ke ɔ 'wlʋ 'e nyʋ \"klu ʋʋ tɛɛn o kpɩɩn‑ ka, ɔ pɔɔ ‑cɩɛ doun\" 'di, ɔ blaa ɔɔ' mɩɩɔ tɔn. ");
INSERT INTO wob_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","‑Wɛe ɔ kpa \"jri \"jɛi, ɔ 'wla feeɛ' i, 'de ɔ wlu ɔ 'na : Efata ! ɛ 'de mɛ ‑nɩ : ‑Ɩn ‑bai' wɔn ! ");
INSERT INTO wob_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","'Bo ɛ \"sri \"ju 'a doin\" je ‑gbai'‑, ɔɔ' mɩɩɔ je ‑gbai'‑, ɔ je wlua' ‑pʋn\" ‑te' 'pepe. ");
INSERT INTO wob_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","'Bomɔ dɛ ‑nʋʋa 'mʋa‑ nyʋ a 'tmʋ ɛ ‑ta ‑wee', 'de ‑mɛ 'kamɔ Sesi ‑tu\" ʋʋ 'snɩ ɔ 'na : Ao 'bo nyɔ jrɔ' 'tmʋʋɛ ! 'Kaa ʋʋa 'tmʋɛ ʋʋa jea nya mu. ");
INSERT INTO wob_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Tai' ‑maa\" nyʋ ‑wee' \"klein, ɛ ‑siɛ' ‑jei\", 'sʋ ʋʋ 'na ɔɔ' nʋʋdɩ ‑wee' nmɔ \"jrii, ɔɔ nʋɛ' mɔ ‑wee' 'sʋ nyʋ ‑ʋʋ ‑suan\" a jea i 'wɔn, \"muu ‑tei\" ‑wi\" a jea wlu. ");
INSERT INTO wob_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","'De ɛɛ' 'wɩ tu 'di, nyʋ ‑tuu\"‑tuu 'kɩɩɛn \"jrui ke'wlɛ 'bo Sesi ‑pʋn\" 'kaa dɛ ʋʋ 'jea di ɛ se nɩ. ‑Jɛ dɛ ʋʋ 'jea di sea nɩ 'sʋ ɛ, Sesi wluɛ ɔɔ' klai\" nynuu ‑pee ɔ 'na : ");
INSERT INTO wob_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","Nyʋ ‑nʋ 'a wɛe a nʋ 'ʋn 'ɛ, dɛ‑nʋɛ' nyʋ ‑nʋ 'a 'wɩ taan ka ‑sɩan 'bo 'ʋn ‑pʋn\", 'kaa ʋʋ se diidɛ 'ble. ");
INSERT INTO wob_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","‑Bo ʋʋ se dɛ di ‑wɛe 'ɩn 'je ʋʋpʋ ‑jei\" po ɛ, ‑crigba a muɛ ʋʋpʋ ‑saa' ‑je woi 'de ‑mɛ 'kamɔ ʋʋa' jrʋ' 'wlʋ ‑ta ‑tɔɔn'. ");
INSERT INTO wob_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","'Sʋ klai\" nynuu 'na : ‑Ta ‑a ‑nɩa ‑ta tɛɛn o, ‑kwlɔ jrɛ' sea i\"kʋʋan‑ 'ee, ‑ta ka nyʋ 'je diidɛ ‑sa, ‑wɛe nyʋ ‑tia ka 'je di 'de ʋʋ 'je dbo ɛ‑ ? ");
INSERT INTO wob_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","‑Wɛe Sesi ‑tee' ʋʋpʋ i ɔ 'na : ‑Di'pɛn kplɩ ‑tiiɛ' ao 'ble ɛ‑ ? Ʋʋ 'na : ‑Di'pɛn kplɩ ‑mɛ\" 'sɔn. ");
INSERT INTO wob_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","'Sʋ Sesi wluɛ nyʋ ‑wee' \"klein ‑pee ɔ 'na : Ao ‑te i. 'Sʋ ɔ \"duɛ ‑di'pɛn kplɩ ‑mɛ\" 'sɔn ‑nɩ 'ʋn 'ɛ, ɔ poɛ Kea 'sɛ‑, ɔ cɛɛn ɩ i, ɔ \"nyɩ ɔɔ' klai\" nynuu ‑wɛe ʋʋ 'jɩ ‑gble'. 'Sʋ ʋʋ ‑gblɩ' nyʋ \"jrii. ");
INSERT INTO wob_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Ʋʋ 'bleɛ ‑smii' jɔ mɩɩ\" jrɩ' ke'wlɛ. Sesi poɛ ɩa' Kea 'sɛ‑, ‑wɛe ɔ 'tmʋʋ ɔɔ' klai\" nynuu, 'de ʋʋ 'jɩ ‑gble' ‑ke. ");
INSERT INTO wob_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Ʋʋ dia dɛ ʋʋ dboa a, ɩa' tɔe ‑sia 'o ʋʋ 'tɩan i ɩ \"jiɛ toe\" ‑mɛ\" 'sɔn. ");
INSERT INTO wob_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Nyʋ ‑dia' dɛ ʋʋ 'bɛɛ‑ \"wlu ‑nyiiɛ 'mɛ. Ʋʋ ‑kɔ \"i 'sasa ‑wɛe Sesi po ʋʋ ‑jei\". ");
INSERT INTO wob_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","'Bo ‑mɛ 'de ɛ, Sesi ke ɔɔ' klai\" nynuu 'ja ‑kwɛɛ\" 'di ‑wɛe ʋʋ mu 'e Dalmanutablʋa \"kpei. ");
INSERT INTO wob_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Fariseɛn‑wi\" ji' ʋʋ ke Sesi a jea ‑too', ʋʋ 'jeɔ i ‑tɩn' 'sʋ ʋʋ 'na ‑ɩn nʋ jrii' ‑wlʋa 'e jaʋn 'di ‑a ‑jeɛ 'je. ");
INSERT INTO wob_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Sesi 'wla feeɛ' i, ‑wɛe ɔ 'na : Dɛɛ‑tɩ nyiɔ ‑nɩa 'e ‑sɩan wɩ 'di a ‑tee' jrii' i ɛ‑ ? 'Ma 'tmʋʋɛ aopʋ tɔ' ‑tɩ, jrii' jrɛ' se nʋʋɛ i ao se ɛ 'jei. ");
INSERT INTO wob_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","'Sʋ Sesi siɛ ʋʋpʋ 'mʋa‑, ɔ 'ja 'e ‑kwɛɛ\" 'di, ‑wɛe ɔ mu 'e \"ni 'a 'kpʋʋn jrɛ' \"kpei. ");
INSERT INTO wob_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Sesi 'a klai\" nynuu \"mae' ʋʋ se diidɛ 'ʋn \"duo‑, ‑bo ɛ se ‑di'pɛn kpla due' ‑gbai' mɛ ‑ɛ ‑ke ʋʋpʋ 'ja 'e ‑kwɛɛ\" 'di nɩ ɛ. ");
INSERT INTO wob_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Sesi ‑tuɛ\" ɔɔ' klai\" nynuu 'snɩ ɔ 'na : Ao ‑tu\" aoa' ‑cɛ\" 'ɛ ‑tɩ' 'de Fariseɛn ke Erodɩ 'a ‑di'pɛn 'ɛ ‑puun\" dɩ 'a ‑tɩ' 'ʋn. ");
INSERT INTO wob_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","'Sʋ klai\" nynuu wluɛ ba ‑pee ʋʋ 'na : ‑A se ‑di'pɛn 'ble, ɛmɛ ‑tɩ ɔ 'da kan'. ");
INSERT INTO wob_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Ka ʋʋa 'tmʋa dɛ ‑nɛ 'sʋ Sesi 'je kan' 'mɛ 'sʋ ɔ ‑teeɛ' ʋʋpʋ i ɔ 'na : Dɛɛ ‑tɩ ao 'na ao se ‑di'pɛn 'ble mɛ ‑o ɛ‑ ? Aoa' 'wɔn ɛ 'mii ? Ao se tɔ' 'blee ? Aoa' pɛe kmuɛii\" ? ");
INSERT INTO wob_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Ao 'bleɛ \"jri aoa' 'je i, ao 'bleɛ doin\" aoa' 'wɔn ii ? Tɔ' se aopʋ 'di 'kpa kee ? ");
INSERT INTO wob_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","‑Ta 'ɩn cɛɛan ‑di'pɛn kplɩ ‑mm\" i 'de nyʋ 'a \"wlu ‑mm\" 'a ‑tɩ' 'ʋn ɛ, ɩa' tɔe 'a toe\" ‑tiiɛ' ao ‑sa 'o ɛ‑ ? Ʋʋ 'na : Toe\" 'a ‑puue 'jɔ 'sɔɔn. ");
INSERT INTO wob_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","'De ‑ta 'ɩn cɛɛan ‑di'pɛn kplɩ ‑mɛ\" 'sɔn i 'de nyʋ 'a \"wlu ‑nyiiɛ 'nynɩ 'ee, toe\" ‑tiiɛ' ɩa' tii‑ ‑sia 'o mu \"ji ‑wɛe ao kpa ‑a ? Ʋʋ 'na : Toe\" ‑mɛ\" 'sɔn. ");
INSERT INTO wob_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Wɛe Sesi 'na : Ao se dɛ 'mii 'wɔn kee ? ");
INSERT INTO wob_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Sesi ke ɔɔ' klai\" nynuu nyniɛ 'e Besaida, 'bomɔ ʋʋ jɔɔ \"dɔi due'. Ʋʋ bae ɔ i ‑wɛe ɔ 'je ɔ \"i bla. ");
INSERT INTO wob_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Sesi kpʋn ɛ \"dɔi ‑cɩɛi\", ɔ ke ɔ 'wlʋɛ 'o ‑kwlɔ ‑kpae\", ‑wɛe ɔ po ɔ tɔn \"jri. Ɔ ‑teɔ' sʋn \"jru, 'de ɔ 'na : ‑Ma ‑je i 'mɛɛ ? ");
INSERT INTO wob_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","\"Dɔi 'baiɛ \"jri, ɔ 'na : 'Ma 'jeɛ nyʋ i, ʋʋa na', 'kaa ɛ se 'pepe nɩ ke, ka ti nɩa 'ka ʋʋpʋ nɩ‑ 'de 'ʋn \"jri 'de. ");
INSERT INTO wob_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Sesi 'tʋɛn ɔɔ' \"jri i ke'wlɛ 'sʋ ɔɔ' \"jri 'bai, ɔɔ 'jeɛ dɩ ‑wee' \"kpe i 'pepe. ");
INSERT INTO wob_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Sesi 'na : ‑Ɩn mu 'de ‑ɩn o ‑gbu\" 'di, ‑ɩn ‑bo 'e ‑kwlɔ ‑kpae\" muɛ. ");
INSERT INTO wob_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Sesi ke ɔɔ' klai\" nynuu a muɛ 'e Sesare Filipiblʋa \"kpei, ‑wɛe ɔ ‑tee' ʋʋpʋ i 'bo ‑jei\", ɔ 'naa : Nyɔ nyʋ a 'daa‑ 'ʋn ɛ‑ ? ");
INSERT INTO wob_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Ɔɔ' klai\" nynuu 'na : Nyʋ jrʋ' a 'daa‑ ‑ʋn San Batisɩ, jrʋ' a 'daa‑ ‑ʋn Eli, jrʋ' 'na ‑ɩn ‑nɩɛ Kea 'a weepoi due' ‑o. ");
INSERT INTO wob_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","'De Sesi 'na : 'Ɩn 'je ‑mɛ ‑wɛ‑ 'de nyɔ aopʋ mɔɔ 'daa‑ 'ʋn ɛ‑ ? 'Sʋ Piɛi 'na : ‑Ɩn ‑nɩɛ Klisɩ, Kea 'a 'o‑tei ‑o. ");
INSERT INTO wob_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","'De Sesi cri ɛɛ' ‑cɩɛ 'de ʋʋ ‑pee ‑wɛe ʋʋ je dɛ ‑nɩa 'mʋa‑ nyʋ jrʋ' ‑pee 'tmʋʋ‑. ");
INSERT INTO wob_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","'Bo ‑mɛ 'de ɛ, Sesi ‑teɛ ɔɔ' klai\" nynuu dɛ tɔɔa' ‑pʋn\", ɔ 'na : nyiɔ 'ɔ \"Ju a muɛ seaa' ‑gblein'. Nyʋ ‑cɔʋn'‑wi\" o, 'sraa ‑saʋn klae\" o, kɛ' wɔ‑saʋn a muɛ ɔ 'bɔa', ʋʋa muɛ ɔ 'dbaa', ‑wɛe 'bo 'wɩ 'a taan ‑nɛ \"kpei ɔ 'je \"kunyɩɔ' sɔn‑. ");
INSERT INTO wob_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Sesi 'tmʋʋa ʋʋpʋ dɛ ‑nɩa 'mʋa‑, ɔ se ɛ 'kwla ‑tu\". 'Sʋ Piɛi 'dɔɔ 'de ‑tajrɔ, ‑wɛe ɔɔ ‑cɛ' ɔ \"bli, ɔ 'na : ‑Ɩn ‑bo dɩ ‑nɩa kan' 'tmʋɛ. ");
INSERT INTO wob_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","'De Sesi \"biie i, ɔ ‑gbʋn ɔɔ' klai\" nynuu ja, ‑wɛe ɔ ‑cɛ' Piɛi \"bli ɔ 'na : ‑Ɩn ‑tɛɛn 'ʋn kɩn, ‑siɔn', ‑ɩn ‑bleɛ nyiɔtɔ', ‑ma 'a 'wɔn 'e Kea 'a tɔ' 'de i. ");
INSERT INTO wob_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Sesi 'da nyʋ ‑wee' \"klein ke ɔɔ' klai\" nynuu ke‑, ‑wɛe ɔ wlu ʋʋpʋ ‑pee ɔ 'na : ‑Bo nyɔ nɩɛ \"i ‑wɛe ɔ ke 'ma ‑a ‑je na a, ‑mɛ ɔ 'bo ɔɔ' ‑cɛ\" 'ɛ 'tʋn nʋ‑tɩ nʋɛ, ɔ 'wɔɔn‑ ɔɔ' ‑nɛ 'kle 'je ‑tɩ ‑wɛe ɔ 'je 'ʋn 'de bla. ");
INSERT INTO wob_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Nyɔ ‑nɩɛ \"i ‑ɔɔ ‑cɛ\" 'kpa 'je ɔɔ' 'kmʋ \"kpei‑ 'tʋan 'ja a ‑mɛ, ɛɛ mu ɔ kwa \"maa', 'kaa nyɔ ‑ɔɔ mua ɔɔ' 'kmʋ 'bɔa' 'de 'ma ‑tɩ' 'ʋn ke Kea 'a wlu 'a ‑tɩ' 'ʋn ɛ, ɔɔ muɛ 'pʋʋa'. ");
INSERT INTO wob_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","'De ‑bo nyiɔ 'ble 'kmʋ ‑wee' \"klein 'de ɔ 'je ɔɔ' ‑suu \"maa 'dee, dɛ ɔ ‑sa 'o ɛ‑ ? ");
INSERT INTO wob_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Dɛ nyiɔ 'je ja ‑wɛe ɔ 'je 'o ɔɔ' ‑suu ‑kɔ o poo ɛ‑ ? ");
INSERT INTO wob_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Nyʋ ‑ʋʋ sea Kea 'a ‑tɩ' kma ‑wɛe ‑ʋʋa nʋa dɩsaɩn 'de ‑sɩanwɩ 'di ɛ, nyɔ ‑nɩa 'de ʋʋpʋ \"klu ‑wɛe ‑ɔ nʋa 'ma ‑tɩ' ‑tɩn' 'ʋn 'de ‑ɔɔ pleea 'ma wlu 'tmʋa' 'de ʋʋpʋ ‑pee ɛ, ‑sɔntɩ 'mɔ nyiɔ 'ɔ \"Ju a mua de jia' 'de 'ɩn \"Bo 'a kɛɛma' 'ʋn, 'de Kea 'a \"soa‑wi\" \"klu ɛ, 'ma muɛ ɔɔ' ‑tɩ' ‑tɩn' 'ʋn nʋa' ‑ke. ");
INSERT INTO wob_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","'De ɔ wluɛ ʋʋpʋ ‑pee ke'wlɛ ɔ 'na : 'Ma 'tmʋʋɛ aopʋ‑ tɔ' ‑tɩ 'a tɔ' ‑tɩ, nyʋ ‑nɩa ‑ta ʋʋa' jrʋ' se 'mɛi ʋʋ 'je Kea 'a Tʋ\"bodɛ 'ɛɛ deji ‑ta 'je 'de \"ikma' 'ʋn. ");
INSERT INTO wob_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","'Wɩ ‑mɛɛo\"‑ ‑sia', Sesi \"duɛ Piɛi ke Sakɩ ke San 'ʋn ‑wɛe ɔ ke ʋʋpʋ mu 'de crʋ klaa\" jrɛ' \"jru, ‑wɛe ʋʋa' 'sʋ ke ɔ nɩ 'e. 'Sʋ ɔ ‑saa \"i 'de ʋʋpʋ \"jri 'de. ");
INSERT INTO wob_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Ɔɔ' 'ʋnpaadɩ a fan', ‑wɛe ɩa' \"plua ‑si' ‑jei\" ɩa ‑flaan' nyʋ \"jri. Nyɔ \"o nyɔ jrɔ' se ɛ 'bɛɛ‑ 'de 'kmʋ \"kpei ‑ta ɔ 'je dɩ wɔɔ‑ ‑wɛe ɛ 'je i‑kwɛ‑ kan'. ");
INSERT INTO wob_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","‑Wɛe ɔɔ' klai\" nynuu 'jee Eli ke Moisɩ \"jriɛ‑ ʋʋ ke Sesi a 'tmʋʋ. ");
INSERT INTO wob_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","'Sʋ Piɛi wluɛ Sesi ‑pee ɔ 'na : 'Ma dɛtɔɔi, ‑bo ‑a ‑sie ‑ta a, ɛ nmɔ \"jrii, ‑aa muɛ poe\" taan poa', ‑mɔ ‑ble due', Moisɩ 'ble due', Eli 'ble due'. ");
INSERT INTO wob_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Dɛ Piɛi 'tmʋa 'mʋa‑ ɔɔ' ‑cɛ\" 'kpa se ɛ 'mii 'wɔn, dɛ‑nʋɛ' dɛ waa ɔ ke ɔɔ' \"dɛi ‑wi\" 'dii. ");
INSERT INTO wob_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","'Sʋ bue\" ji', ɛ \"muuɛ ʋʋpʋ \"jru i, ‑wɛe 'de bue\" 'di ‑nɔ wlu 'wlʋ 'e, ɛ 'na : \"Ju ‑nɔ, 'ma ‑tɩ' kmaju ‑o, ao po ɔɔ' wlu doun\" o. ");
INSERT INTO wob_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","'Bo ɛ \"sri klai\" nynuu je ʋʋ 'de woi ‑gbʋʋn', 'kaa ʋʋ se nyɔ jrɔ' 'je ‑bo ɛ se Sesi 'a 'sʋ nɩ ɛ. ");
INSERT INTO wob_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","‑Ta ʋʋa 'wlʋa 'e crʋ \"kpei ʋʋa \"sia i ɛ, Sesi ‑teɛ' ʋʋpʋ kɛ' \"i ɔ 'na : Dɛ ao 'jeea \"jriɛ‑ ‑ta, ao 'bo ɛ \"i blaa 'de nyɔ jrɔ' ‑pee mamaʋ 'sʋ nyiɔ 'ɔ \"Ju 'je \"kunyɩɔ' sɔn‑. ");
INSERT INTO wob_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Klai\" nynuu ‑teɛ' ɛɛ' wlu tu i 'de ʋʋa' 'sʋ 'nynɩ ‑wɛe ʋʋa ‑tee' ba i ʋʋ 'na : \"Kunyɩɔ' sɔan' ‑mɛ 'de 'de ɛ‑ ? ");
INSERT INTO wob_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","‑Wɛe ʋʋ ‑tee' Sesi i ʋʋ 'na : Dɛɛ‑tɩ kɛ' wɔ‑sanyʋ a wlu ʋʋ 'na Eli mɔ ‑je \"i‑saa ‑ɔ ‑je ji ɛ‑ ? ");
INSERT INTO wob_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","'Sʋ ɔ 'na : Tɔ' ‑o, Eli ‑je \"i‑saa ɔ ‑je ji ‑cɛɛn'‑ ‑wɛe ‑ɔ ‑e dɩ kpɔ \"i po. 'De 'ma ‑teeɛ' aopʋ‑ i ‑ke, dɛɛ‑tɩ Kea 'a wlu 'na nyiɔ 'ɔ \"Ju 'je 'kle 'je ‑o ‑gblein' ‑wɛe nyʋ 'je ɔ ‑flɛɛn ɛ‑ ? ");
INSERT INTO wob_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","'Kaa 'mɔ 'na Eli mɔ ji' ‑wɛ‑ sese, ‑wɛe nyiɔpʋ ‑tuɔ\" 'kle ʋʋa' ‑kwlʋ ka‑, ka ɛ 'crɩa 'de ɔɔ' ‑tɩ' 'ʋn see ɛ. ");
INSERT INTO wob_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","‑Ta ʋʋpʋ nynia 'e klai\" nynuu jrʋ' ‑sia' 'e mu ‑pʋn\" ɛ, ‑mɛ nyiɔpʋ‑ ‑tuu\" ‑gbae' ʋʋpʋ 'dei, ‑wɛe ʋʋ ke kɛ' wɔ‑sanyʋ a ‑too'. ");
INSERT INTO wob_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Ʋʋpʋ 'jea Sesi i 'sʋ ʋʋ ‑keeɛ' i, 'sʋ ʋʋa 'jaa ɔ \"i ʋʋ 'je ɔ ‑gblee. ");
INSERT INTO wob_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Sesi ‑teeɛ' klai\" nynuu i ɔ 'na : Dɛɛ‑tɩ ao ke ʋʋa ‑too' 'ʋn ɛ‑ ? ");
INSERT INTO wob_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","'Sʋ \"ju due' ‑wlʋ 'e nyʋ \"klu ‑ɔ ‑na : 'Ma dɛtɔɔi, 'ɩn ja ‑ʋn 'ma \"ju. ‑Suusaʋn ‑nɩa 'e ɔ 'ʋn ɛɛ' 'wɔn ɔɔ' wlu‑. ");
INSERT INTO wob_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","‑Ta \"o ‑ta ɛ kpʋn ɔ 'sʋ ɛ blɔ i 'bo 'blʋɔ, tɔn 'ɔ fɩʋn' a ji ɔ wɔn i, ɔɔ diiɛ 'nynɩ \"i, ‑wɛe ɔɔ \"srɛɛ‑ 'ʋn. 'Ɩn ‑teeɛ' ‑ma klai\" nynuu i ʋʋ 'je ɔ ‑suusaʋn 'ʋn ‑sa, 'kaa ʋʋ se ɛ kwa i 'bɛɛ‑. ");
INSERT INTO wob_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Sesi wlu ʋʋpʋ ‑pee ɔ 'na : Ao pɛe \"i \"ikmunyʋ, nɔ\" ‑tiiɛ' ‑sie 'o ao ke 'ma ‑a ‑je i ‑te ɛ‑ ? Kpɛ ‑tiiɛ' 'ɩn 'je pɛe \"wɔin 'bɛɛ‑ 'de aoa' ‑tɩ' 'ʋn ɛ‑ ? ‑Wɛe ɔ 'na : Ao ja 'ʋn \"ju‑saan\"‑ ! ");
INSERT INTO wob_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Ʋʋ jɔ'. ‑Suusaʋn 'jeea Sesi \"jriɛ‑ 'sʋ ɛ ‑suua' \"ju ‑saan\" i. Ɔ ‑ka i 'bo 'blʋɔ, ɔɔ \"mɩɩɛ i, tɔn fɩʋn' croo ɔ wɔin. ");
INSERT INTO wob_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Sesi ‑teeɛ' \"ju ‑saan\" \"bo i ɔ 'na : Ɔ nɩa kan' ɛɛ' 'wɩ ‑tiiɛ'‑ ? Ɔ \"bo 'na : Ɛ ‑sɔ 'e ‑saan\" 'ʋn. ");
INSERT INTO wob_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","‑Bo 'wɩ jrɛ' o ɛ, ‑suusaʋn po ɔ \"jri, 'wɩ jrɛ' o ɛ, ɛ po ɔ \"niɔ‑ ‑wɛe ɛ 'je ɔ 'dba. 'Kaa ‑bo ‑ɩn ‑bɛɛ' dɛ jrɛ' nʋa' a, ‑ɩn ‑je ‑aa wɛe‑, ‑ɩn ‑te' ‑a kwa wɔi 'dee. ");
INSERT INTO wob_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","'De Sesi 'na : ‑Mɔ ‑na, ‑bo 'ɩn 'bɛɛ dɛ jrɛ' nʋa' a‑ ? Nyɔ ‑tea' Kea ‑kwlɩ\" ɛ, dɩ ‑wee' a 'wɔɔn ɔ kwa. ");
INSERT INTO wob_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","'Bo ɛ \"sri \"ju ‑saan\" \"bo kpa wlu \"jɛi, ɔ 'na : 'Ɩn ‑teɛ ‑ʋn ‑kwlɩ\". ‑Ɩn ji 'ʋn o, 'ma dɛ tɔ' 'ʋn 'jea' nɩɛ 'kle. ");
INSERT INTO wob_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Sesi 'jea nyʋ ‑ʋʋa ‑kwea de 'de ʋʋ 'de woi ɔ kmaa wlu \"i 'de ‑suusaʋn ‑pee ɔ 'na : Ɛ \"si \"kpae' ! ɛmɛ ‑suusaʋn ‑a ‑suan\" nyʋ 'a wɔn ‑ɛɛ wa nyʋ 'a doin\" ɛ, 'ma 'tmʋʋɛ', ɛ 'wlʋ 'e \"ju ‑saan\" ‑nɔ 'ʋn, ɛ 'bo 'de ɔ 'ʋn paa 'bode ! ");
INSERT INTO wob_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","‑Suusaʋn \"wɔɔ', ɛ ‑suua' \"ju ‑saan\" i kpleiin, ‑wɛe ɛ \"si \"kpae'. \"Ju‑saan\" 'kpa \"jroa jroa ka nyɔ ɔ 'mɛa. Nyʋ ‑gbaea' ʋʋa' ‑tuu\" 'na : Ɔ 'mɛɛ. ");
INSERT INTO wob_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","'Kaa Sesi kpʋɛn ɔ ‑cɛ\" i, ɔ kpɔ \"jɛi 'sʋ ɔ nyna i. ");
INSERT INTO wob_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","‑Ta Sesi paa 'de ‑gbu\" 'di ‑wɛe ɔɔ' klai\" nynuu 'a 'sʋ ke ɔ nɩa 'emu ɛ, 'bo ʋʋ ‑tee' ɔ i ʋʋ 'na : Dɛɛ‑tɩ ‑a se ‑suusaʋn ‑nɛ 'ɛ inʋa' 'bɛɛ‑ ɛ‑ ? ");
INSERT INTO wob_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","'De Sesi 'na : ‑Suusaʋn ka ‑jɛ ‑mɛ nɩa ‑ɛ ‑nɩa kan' a, dɛ jrɛ' se ɛ 'bɛɛ‑ ɛ 'je ɛ 'e ‑sa, ‑bo ɛ se 'de Kea baea' 'ʋn nɩɛ. ");
INSERT INTO wob_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Ʋʋ 'wlʋa 'mʋa‑ a, ʋʋ cɛn Galileblʋa 'ʋn ‑tie\". Sesi se ɛ \"i nɩ ‑ta ɔ nɩa nyʋ 'je 'o juo‑, ");
INSERT INTO wob_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","dɛ‑nʋɛ' ɔɔ tɔɔ ɔɔ' klai\" nynuu dɛ. Ɔɔ 'tmʋʋ ʋʋpʋ 'mɛ ɔ 'na : Nyʋ a muɛ nyiɔ 'ɔ \"Ju 'de nyiɔpʋ 'kwa ‑tu\" 'a, ʋʋ 'je ɔ 'dba, ‑wɛe 'de 'wɩ taan \"kpei ɔ 'je \"kunyɩɔ' sɔn‑. ");
INSERT INTO wob_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","'Kaa klai\" nynuu se dɛ ‑nɩa 'mʋa‑ 'dei 'wɔn, 'de ʋʋa plee ɔɔ' i ‑tea' 'mɛ. ");
INSERT INTO wob_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Ʋʋ ke Sesi nyniɛ 'o Kapɛnaʋm. ‑Ta ʋʋ pa 'e ‑gbu\" due' 'di 'sʋ ɛ, ɔ ‑teeɛ' ɔɔ' klai\" nynuu i ɔ 'na : Dɛ aoa ‑too' 'ʋn 'bo ‑jei\" 'teɔ 'de ɛ‑ ? ");
INSERT INTO wob_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","'Kaa ʋʋ ‑wee' \"muɛ wɔn, dɛ‑nʋɛ' nyɔ ‑jea ʋʋa' klaa\" nɩ mɔ ‑ɔɔ ‑tɩ' ʋʋa ‑too' 'ʋn ‑je woi ʋʋ 'na. ");
INSERT INTO wob_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","‑Wɛe Sesi ‑te i, ɔ 'da klai\" nynuu ‑nɩa ‑puue 'jɔ 'sɔɔn, 'de ɔ 'na : Nyɔ ‑nɩɛ \"i ‑ɔ ‑jea \"i‑saa ‑mɛ ɔ 'bɔɔ‑ nyʋ ‑wee' \"klein 'a de, ɔ nɩ nyʋ ‑wee' \"klein 'a \"juɔi nʋʋ i. ");
INSERT INTO wob_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","'Sʋ ɔ \"duɛ \"ju ‑saan\" due' 'ʋn, ɔ nynaa ɔ i 'bo ʋʋa' ‑kwɩa'‑, ‑wɛe ɔ \"duɔ 'ʋn 'de ɔ 'na : ");
INSERT INTO wob_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","Nyɔ ‑kpʋʋn ‑a \"nynumɩɩ\" ‑nɩa ka sɩn 'sɔɔn ɔ 'de 'ma 'nynɩ 'ʋn, ‑mɛ 'ma ‑cɛ\" ɔ kpʋʋn sɩn 'sɔn. 'De nyʋ ‑kpʋʋn ‑a 'mɔ sɩn 'sɔɔn ɔ, ‑mɛ ɛ se 'mɔ ɔ kpʋʋn sɩn 'sɔɔn nɩ‑, \"ju ‑dboa' 'ʋn mɔ ɔ kpʋʋn sɩn 'sɔɔn. ");
INSERT INTO wob_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","San wluɛ Sesi ‑pee ɔ 'na : 'Ma dɛtɔɔi, ‑a ‑jeɛ \"ju due' ‑ɔɔ nʋ ‑siisaɩn i 'de ‑ma 'nynɩ 'ʋn, 'kaa ‑a ‑kaan ɔ ‑je de, dɛ‑nʋɛ' ɔ ke ‑aa' na‑. ");
INSERT INTO wob_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","'De Sesi 'na : Ao 'bo ɔ ‑je de kaan. Nyɔ jrɔ' se ɛ 'bɛɛ‑ ɔ 'je jrii' nʋ 'de 'ma 'nynɩ 'ʋn, ‑wɛe ɔ 'je 'o \"si 'de ɔ 'je 'ma ‑tɩ' saɩn 'tmʋ. ");
INSERT INTO wob_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","'Kaa nyɔ ‑sea' ‑a 'dii 'blee ɛ, ‑mɛ ɔ ke ‑a kpa 'fɔ. ");
INSERT INTO wob_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","'De 'ma 'tmʋʋ aopʋ tɔ' ‑tɩ dɛ ao nɩa Klisɩ 'a nyʋ, 'de ɛɛ' ‑tɩ' 'ʋn ɛ, nyɔ \"o nyɔ ‑nyɩa\" ao \"ni ‑kaʋn ɛ, ɔɔ muɛ ɛɛ' ‑kei\" 'jea' see. ");
INSERT INTO wob_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Nyʋ ‑jea 'ma ‑tɩ' tɔ' 'ʋn ‑bo nyɔ po ʋʋa' ‑saan\" due' 'de dɛsaʋn 'di ɛ, ‑mɛ dɛ ‑jea \"paa' 'de ɔɔ' ‑tɩ' 'ʋn mɛ ‑nɩ nyʋ saan ɔ \"soukpo klaa\" ‑plun ‑wɛe nyʋ ‑fii\" ɔ 'tɔniɛ wɔn. ");
INSERT INTO wob_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","‑Bo ‑ma sʋn a sea ‑ʋn 'de dɛsaʋn 'di bluua a, ‑ɩn cɩɛn ɛ 'o. ‑Ɩn ‑ble sʋn due' ‑wɛe ‑ɩn ‑je 'kmʋnɩa' ‑cɛɛn'‑ \"paa' ɛ je ‑ɩn ‑ble sɩn 'sɔɔn ‑wɛe ‑ɩn mu 'e 'kle 'jeɩn' 'de nɛ‑gbauo klaa\" ‑ɛɛ' 'mʋa 'ʋn ‑sii. ");
INSERT INTO wob_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Cɩaɩn\" ‑ɩn ‑a pa nyʋ 'bo 'a ‑ta tu‑ ɩa' 'mɛ, 'de nɛ ‑nɛ 'ɛ 'mʋ. ");
INSERT INTO wob_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","‑Bo ‑ma bʋ a sea ‑ʋn 'de dɛsaʋn 'di bluua a, ‑ɩn cɩɛn ɛ 'o. ‑Ɩn ‑too' bʋ due' \"i ‑wɛe ‑ɩn ‑pʋ \"paa' ɛ je ‑ɩn ‑ble bɩ 'sɔɔn ‑wɛe ‑ɩn mu 'e nɛ sea' 'mʋ‑ta 'ble 'ʋn ‑sii ");
INSERT INTO wob_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","Cɩaɩn\" ‑ɩn ‑a pa nyʋ 'bo 'a ‑ta tu‑ ɩa' 'mɛ, 'de nɛ ‑nɛ 'ɛ 'mʋ. ");
INSERT INTO wob_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","'De ‑bo ‑ma \"jriɛ‑ ɛ sea ‑ʋn 'de dɛsaʋn 'di bluua a, ‑ɩn ‑sɛ 'de ‑ʋn kʋn', ‑ɩn ‑ble \"jriɛjɔ due' ‑wɛe ‑ɩn pa 'de Kea 'a tʋ\"bo ‑kwlɔ 'di, ɛ \"paa' ɛ je ‑ɩn ‑ble \"jri 'sɔɔn ‑wɛe ‑ɩn mu 'de nɛ sea' 'mʋ‑ta 'ble 'ʋn ‑sii ");
INSERT INTO wob_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Cɩaɩn\" ‑ɩn ‑a pa nyʋ 'bo 'a ‑ta tu‑ ɩa' 'mɛ, 'de nɛ ‑nɛ 'ɛ 'mʋ. ");
INSERT INTO wob_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Nɛ ɛ muɛ nyʋ ‑wee' \"kpei mua' ka nyɔ ɔ poa 'tɔn 'de 'sraadɛ o ɛ. ");
INSERT INTO wob_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","'Tɔn nɩɛ dɛ 'dɔe ‑o. 'Kaa ‑bo 'tɔn ‑kwɛ‑ wɔn 'dee, ka nyʋ 'je ɛɛ' ‑tɩ' nʋ ‑wɛe ɛ 'je wɔn nɩ ɛ‑ ? Ao nɩ 'tɔn wɔn. Pɛe 'a blua' nɩ 'bo ao ke ao ‑ponyiɔ 'nynɩ. ");
INSERT INTO wob_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Sesi 'wlʋa 'mʋa‑, ɔ muɛ 'e Suide 'de Sudɛn ‑gbuu 'de fɔ o. Nyʋ ‑tuu\" ‑gbae' ɔ 'de woi ke'wlɛ ‑wɛe ɔ ‑te ʋʋa' dɛ tɔɔa' ‑pʋn\" ka ɔɔ nʋa see ɛ. ");
INSERT INTO wob_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Fariseɛn‑wi\" 'kpɔ ‑pʋn\" ‑wɛe ʋʋ 'je ɔ i ‑tɩn', ʋʋ ‑tee' ɔ i ʋʋ 'na : 'de ‑aa kɛ' ‑nɛ 'di 'ee, \"junmɔu 'beeɛ' 'mɛ ‑ta ɔ 'je ɔɔ' 'nynɔ 'kwla ‑saa ? ");
INSERT INTO wob_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","'De Sesi 'na : Ka Moisɩ bla kɛ' ɔ 'da 'de aopʋ ‑pee ɛ‑ ? ");
INSERT INTO wob_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Ʋʋ 'na : Moisɩ 'na \"junmɔu 'crɩ 'kwla ‑sa 'sbɛ ‑wɛe ɔ 'je ɔɔ' 'nynɔ \"nyɩ 'de ɔ 'je ʋ 'kwla ‑sa. ");
INSERT INTO wob_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","'De Sesi 'na : Aoa' pɛe \"ikmua' mɛ ‑nʋɛ' ‑wɛe Moisɩ je kɛ' ‑nɩa 'mʋa‑ 'crɩ 'de aoa' ‑tɩ' 'ʋn. ");
INSERT INTO wob_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","'Kaa tɛin\" 'de ɛ, ‑ta Kea nʋa dɩ ‑wee' ɛ, ɛ nʋɛ \"junmɔu ke 'nynɔkpao' ke‑. ");
INSERT INTO wob_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Ɛmɛ ‑tɩ \"junmɔu a mu ɔ \"bo ke ɔ de ‑pʋn\" 'wlʋa', ɔ ke ɔɔ' 'nynɔ 'je \"i \"sii‑, ");
INSERT INTO wob_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","‑wɛe ka ʋʋ nɩa 'sɔɔn, ʋʋ 'je nyɔ due' ma. ‑Bo ɛ nɩ kan' a, ‑mɛ ʋʋ se 'sɔɔn nɩ‑, ʋʋ ma dɛ due'. ");
INSERT INTO wob_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Dɛ Kea ‑tu\" 'a \"i ɛ, nyiɔ 'bo ɛ i ‑seea'. ");
INSERT INTO wob_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","‑Ta ʋʋ nɩa 'e ‑gbu\" 'di ɛ, klai\" nynuu ‑teeɛ' Sesi i ke'wlɛ 'de ‑tɩ' ‑nɩa 'mʋa‑ \"kpei. ");
INSERT INTO wob_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","'De Sesi 'na : ‑Bo \"junmɔu ‑sa ɔɔ' 'nynɔ 'kwla ‑wɛe ɔ 'je 'nynɔ jrɔ' 'ble ɛ, ɔ 'kpa 'e jɛi\" 'jea' 'di. ");
INSERT INTO wob_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","'Kamɔ ‑bo 'nynɔkpao' 'wlʋ ‑gbu\" ‑wɛe ʋ \"ti \"junmɔu jrɔ' \"bli ɛ, ʋ 'kpa 'e jɛi\" 'jea' 'di ‑ke. ");
INSERT INTO wob_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Nyʋ jrʋ' ja \"nynumɩɩ\" 'de Sesi o, ‑wɛe ɔ 'je ʋʋ \"diwan po 'kaa klai\" nynuu a ‑fuun ɛ ʋʋpʋ nya. ");
INSERT INTO wob_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Dɛ ʋʋ nʋa ɛ se Sesi 'tʋn nʋ, ‑wɛe ɔ 'tmʋʋ klai\" nynuu ɔ 'na : Ao \"tai \"nynumɩɩ\" \"i ʋʋ 'je 'nɔ 'ʋn o ji. Ao 'bo ʋʋ ‑je de kaan, dɛ‑nʋɛ' ka \"nynumɩɩ\" nɩa nyʋ ‑nɩa kan' a, ʋʋpʋ ‑ble Kea 'a kɛɛma' ‑kwlɔ. ");
INSERT INTO wob_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","'Ma 'tmʋʋɛ aopʋ tɔ' ‑tɩ 'a tɔ' ‑tɩ, nyɔ ‑sea' Kea 'a kɛɛma' ‑kwlɔ 'ɔ ‑tɩ' 'wɔɔn ka \"ju ‑saan\" nɩa, ɔ seɛ 'bɛɛ ɔ 'je 'o ɛ 'di pa. ");
INSERT INTO wob_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Ɔ 'tmʋa wlu ‑nɛ 'sʋ ɛ, ɔ \"duo \"nynumɩɩ\" 'ʋn 'ɛ 'de ɔ ‑gblee ʋʋ ‑kwlɩ\". Ɔ ‑te' ʋʋ sʋn \"jru due 'due, ‑wɛe ɔ po ʋʋpʋ \"diwan. ");
INSERT INTO wob_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","‑Ta Sesi 'kpaa ‑jei\" ɛ, \"ju due' ‑ple' ‑ɔ ‑ji', ‑ɔ ‑sii\" i 'kɔi‑ i 'de ɔ \"juɔi, ‑wɛe ‑ɔ ‑na : Nyʋ dɛtɔɔi 'dɔe, dɛ 'ɩn 'je nʋ ‑wɛe 'ɩn 'je 'kmʋ ‑sea' ‑kwɛ‑ ‑ta 'ble 'je ɛ‑ ? ");
INSERT INTO wob_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Sesi 'na : Dɛɛ‑tɩ ‑ma ‑daa' 'ʋn nyɔ 'dɔe ɛ‑ ? Nyɔ jrɔ' se 'dɔe nɩ ‑bo ɛ se Kea 'a 'sʋ nɩ ɛ. ");
INSERT INTO wob_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","‑Ɩn ‑juo Kea 'a kɛ' 'mɛ : Ɛ 'na : ‑ɩn ‑bo \"ku 'dbaa, ‑ɩn ‑bo jɛi\" 'jeɛ, ‑ɩn ‑bo \"jriiɛ, ‑ɩn ‑bo nyʋ ‑pa \"kpei blaa, ‑ɩn ‑bo nyʋ 'srɛ i pooɛ, ‑wɛe ‑ɩn ‑bo ʋʋ dɩ 'kwa i‑saa, ‑ɩn ‑te' ‑ɩn \"bo ke ‑ɩn de 'a ni'. ");
INSERT INTO wob_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","\"Ju ‑nɔ 'na : Nyʋ dɛtɔɔi, 'ɩn ‑sa kɛ' ‑nɩa 'mʋa 'a wɔn 'jea' ‑saan\" 'ʋn. ");
INSERT INTO wob_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Sesi ‑gbʋn ɔ ‑tɩ' kmajriɛ ja, ɔ 'na : Dɛ due' ‑sie 'o ‑ɩn ‑je nʋ : ‑ɩn mu, ‑ɩn ple ‑ma dɩ ‑wee', ‑ɩn ‑nyɩ\" ɩa' 'wɛi nɩɩa\" nyʋ, ‑wɛe ‑ɩn ‑je \"wliiɛ‑ 'ble 'de jaʋn 'di, ‑wɛe ‑ɩn ‑je ji ‑ɩn ‑ke 'ma ‑a ‑je na‑. ");
INSERT INTO wob_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","'Kaa \"ju ‑nɔ 'wɔan wlu ‑nɩa 'mʋa‑ a, ɔ 'kwlɔn \"jua‑, ɔ \"kaeɛ \"jrii \"kɩkɩ ɔɔ jea mu, dɛ‑nʋɛ' ɔ nɩɛ \"wliiɛjei klaa\" ‑o. ");
INSERT INTO wob_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Sesi ‑gbʋan ɔɔ' klai\" nynuu ‑gbae' ɔ 'de woi ja ɔ 'na : Ka \"wliiɛjei 'a Kea 'a tʋ\"bodɛ 'ʋn 'kpaa' nɩ 'kle kaa‑ ! ");
INSERT INTO wob_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Wlu ‑nɩa 'mʋa‑ \"maa klai\" nynuu tai'. 'Kaa Sesi wluɛ ʋʋ ‑pee ke'wlɛ ɔ 'na : 'Ma \"nynuu‑, ka 'de Kea 'a tʋ\"bodɛ 'ʋn 'kpaa' nɩ 'kle kaa‑ ! ");
INSERT INTO wob_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","‑Sɛn \"kpei soo\" 'a 'bo \"mɛʋn 'a ‑po\" \"i paa' \"feeɛ wɔn ɛ je \"wliɛjei 'a 'de Kea 'a kɛɛma' ‑kwlɔ 'di paa' ‑sii. ");
INSERT INTO wob_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Dɛ ɔ 'tmʋa 'mʋa‑, ɛ \"maa klai\" nynuu tai' ke'wlɛ ɛ je ‑jei\" ‑si'. Ʋʋa ‑teeɛ' ba i due 'due ʋʋ 'na : 'De ‑mɛ nyɔ ‑bɛɛ' ‑ɔ ‑je 'pʋʋa' 'je ɛ‑ ? ");
INSERT INTO wob_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Sesi ‑gbʋn ʋʋpʋ ja ɔ 'na : ‑Bo ɛ ‑tu\" nyiɔpʋ‑wi\" ‑mʋ ɛ, ‑mɛ ɛ kmai\" 'de ʋʋpʋ \"jri 'de, 'kaa ɛ se \"ikma 'de Kea ‑pee, dɛ‑nʋɛ' ɛ 'bɛɛ‑ dɩ ‑wee' \"klein 'a nʋa' 'mɛ. ");
INSERT INTO wob_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","'Sʋ Piɛi 'na : ‑Ɩn ‑gbʋn 'nɔ, ‑apʋ ‑jɔ ‑bɔa ɔɔ' dɩ ‑wee' \"klein ‑wɛe ‑ɔ bla 'bo ‑ʋn 'de 'e ? ");
INSERT INTO wob_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","'De Sesi 'na : 'Ma 'tmʋʋɛ ao tɔ' ‑tɩ, nyɔ \"o nyɔ ‑bɔa ɔɔ' ‑gbu\", ‑ɔ ‑bɔa ɔɔ' de'dinmai, ɔɔ' de'dinynʋkpae', ɔ de, ɔ \"bo, ɔɔ' \"nynuu‑, ɔɔ' ‑kle' 'de 'ma ‑tɩ' 'ʋn ke ‑pɔia\" wlu 'a ‑tɩ' 'ʋn ɛ, ");
INSERT INTO wob_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","ɔɔ muɛ ‑gbi\" o, de'dinmai o, de'dinynʋkpae' o, de‑wi\" o, \"nynuu‑ o, ‑kle' a kmɛ' 'due 'jea', ɩ ke ‑cɛ\" wɔn 'jea' 'de kaanwɩ 'di ke. ‑Wɛe 'de nya, ɔ 'je 'kmʋnɩa' ‑sea' ‑kwɛ ‑ta 'ble 'je ‑ke. ");
INSERT INTO wob_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","'Kaa nyʋ ‑saa \"i kaan a, ʋʋa' ‑ta ‑tuu\" a muɛ de 'bɔɔa', ‑wɛe nyʋ ‑bɔɔa' de ɛ, ʋʋa' ‑ta ‑tuu\" 'je \"i‑saa. ");
INSERT INTO wob_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","‑Ta ʋʋ nɩɩa Selisalɛm muua' a, Sesi ‑kɔn 'e ʋʋa' nya, 'sʋ faʋn nʋ ɔɔ' klai\" nynuu ke nyʋ \"klein ‑bla' 'bo ɔ 'de 'mɛ ‑wɛe Sesi 'kɩɩɛn ɔɔ' klai\" nynuu ‑nɩa ‑puue 'jɔ 'sɔɔn \"jrui, ɔɔ' tai' \"maa ʋʋpʋ 'mɛ. Ɔɔ' klai\" nynuu a ‑tuɛ\" ɔɔ' ‑sɔɔn 'de ɔ 'de. Sesi 'bɔɔ‑ de ke'wlɛ ɔ je ɔɔ' klai\" nynuu ‑nɩa ‑puue 'jɔ 'sɔɔn \"jrui 'kɩɩn‑ 'de dɩ ‑ɩ ‑jeɔ \"jrii nʋʋɛ ɔɔ 'tmʋɩ 'de ʋʋ ‑pee. ");
INSERT INTO wob_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Ɔ 'na : Ao ‑gbʋn 'nɔ, 'de Selisalɛm ‑aa mua, nyiɔ 'ɔ \"Ju a muɛ 'de 'sraa ‑saʋn klae\" ke kɛ' wɔ‑saʋn 'kwa 'kpaa', ʋʋ 'je ɔɔ' 'mɛ ‑tɩ 'a wlu 'ʋn 'bɛɛ‑, ‑wɛe ʋʋ 'je ɔ nyʋ 'srʋ kwa 'bɔɔ‑. ");
INSERT INTO wob_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","'De ‑wi\" ‑mʋ 'je ɔ wlaa‑, ʋʋ 'je ɔ tɔn \"jri wlan, ʋʋ 'je ɔ klae 'ʋn kpa, ‑wɛe ʋʋ 'je ɔ 'dba. 'Kaa 'de 'wɩ taan \"kpei ɛ, ɔɔ muɛ \"kunyɩɔ' sɔan'. ");
INSERT INTO wob_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Ɛ 'wlʋa 'mʋa‑ 'sʋ Sebede 'a \"nynuu‑ Sakɩ ke San 'kpa Sesi ‑pʋn\", ʋʋ 'na : ‑Aa dɛtɔɔi, ‑a ‑nɩɛ \"i dɛ ‑aa mua ‑mi i ‑teea' ‑ɩn ‑je ɛ nʋ. ");
INSERT INTO wob_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Sesi ‑teeɛ' ʋʋpʋ i ɔ 'na : Dɛ ao nɩ \"i 'ɩn 'je ao \"nyɩ ɛ‑ ? ");
INSERT INTO wob_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","'Sʋ ʋʋ 'na : ‑Sɔntɩ ‑ma mua 'nynɩ 'wlʋa' 'de ‑ma tʋ\"bodɛ 'ʋn ɛ, ‑ɩn ‑wɔn ‑a ‑je 'de ‑ʋn ‑pʋn\" ‑te, due' 'je 'de ‑ma dian o ‑te ‑wɛe due' 'je 'de ‑ma kʋan o ‑te. ");
INSERT INTO wob_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","'De Sesi 'na : Dɛ aoa ‑tee' a i ao se ɛ juo‑. \"Nmia ‑pɛ 'ma mua 'naa', ao 'bɛɛ‑ ɛɛ' 'naa' 'mɛɛ ? 'De ‑cɛ\" wɔn 'jea' 'ma mua 'ʋn cɛan', ao 'bɛɛ‑ ɛɛ' 'ʋn cɛɛan 'mɛɛ ? ");
INSERT INTO wob_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","'Sʋ ʋʋ 'na : ‑A ‑bɛɛ' nɛ'. 'De Sesi 'na : Tɔ' ‑o ‑cɛɛn'‑, \"pɛ 'ma mua 'naa' a, ao 'bɛɛ‑ ɛɛ' 'naa' 'mɛ, 'de ‑cɛ\" wɔn 'jea' 'ma mua 'ʋn cɛan', aoa muɛ ɛ 'ʋn cɛan'. ");
INSERT INTO wob_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","'Kaa 'de 'ma dian o ke 'ma kʋan o ‑tetɩ ‑mɛ ɛ, ɩa' ‑tɩ' se 'e 'ma ‑cɛ\" 'kwa nɩ‑. Ɩa' ‑teɩn ‑tu nyʋ ‑a ‑tɩ' Kea nmaɩ ɛ, ʋʋpʋ ‑jɩ 'je. ");
INSERT INTO wob_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Klai\" nynuu ‑puue ‑sia 'o 'wɔan wlu ‑nɩa 'mʋa‑, ʋʋ 'kpaa Sakɩ ke San 'cɛn i. ");
INSERT INTO wob_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","'Sʋ Sesi 'da ʋʋ ‑wee' 'mɛ, ‑wɛe ɔ 'na : Ao juɛ' nyʋ nyiɔ ɔ ‑gbʋn ‑a ja ka \"jrujeʋn nɩa 'de 'kmʋ \"kpei ‑ta ʋʋpʋ ‑a cri nyiɔ bɩ ‑sɔn i, 'de nyʋ ‑nɩa nyʋ klae\" ʋʋpʋ ‑a kmaa nyʋ wɔn \"kpei. ");
INSERT INTO wob_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","'Kaa ɛ 'bo kan' nɩɛ 'de aopʋ \"klu. ‑Bo aoa' due' nɩɛ \"i ɔ 'je klaa\" nɩ ‑mɛ ɔ nɩ aoa' \"jɔi nʋʋi. ");
INSERT INTO wob_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","'De ‑bo aoa' due' 'na ɔ 'je nya kɔn ‑mɛ ɔ nɩ ao ‑wee' 'a kʋɔn. ");
INSERT INTO wob_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Dɛ‑nʋɛ' nyiɔ 'ɔ \"Ju se ji ‑wɛe nyʋ 'je ɔ \"juɔi nʋʋ, 'kaa ɔ ji' ‑wɛe ɔmɔ 'je nyʋ \"juɔi nʋʋ, ‑wɛe ɔ 'je ɔɔ' 'kmʋ 'e to 'de ɛ 'je nyʋ ‑tuu\" seie‑. ");
INSERT INTO wob_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Sesi ke ɔɔ' klai\" nynuu nyniɛ 'o Seriko. ‑Ta ʋʋa 'wlʋa 'demu ɛ, nyiɔ ‑kwɛ‑ de, 'bo mɔ Time 'a \"ju Batime, ‑doa\" a, ɔ ‑teɛ i 'bo ‑je doun\" ɔɔ jea ‑srɔ. ");
INSERT INTO wob_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Ka Sesi ‑wlʋa Nasarɛtɩ a ‑sia' ɔ 'wɔɩn 'sʋ ɔɔ wee' ɔ o, ɔ 'na : Dafidɩ 'a \"Ju Sesi, ‑ɩn ‑je 'ma wɛe‑ 'de ! ");
INSERT INTO wob_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Nyʋ 'a ‑ta ‑tuu\" a 'wlɔ wlu \"jru ‑wɛe ɔ 'e wɔn \"mu. 'Kaa ɔɔ kpa wlu \"jɛi ɔɔ jea \"wɔ ke'wlɛ ɔ 'na : Dafidɩ 'a \"Ju, ‑ɩn ‑je 'ma wɛe‑ ! ");
INSERT INTO wob_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","'Sʋ Sesi nyna i, ɔ 'na : Ao 'dɔ ! 'Sʋ ʋʋ 'da \"dɔi 'mɛ, ʋʋ 'na : ‑Ɩn ‑duo\" 'kpɩ 'ʋn ‑too\"‑, ‑ɩn ‑je mu la ɔɔ 'da ‑ʋn ‑ɛ ! ");
INSERT INTO wob_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","'Sʋ ɔ ‑fii\" ɔɔ' flae'‑ 'mɛ, ɔ ‑pliin\" ɔ sɔn 'ʋn 'ɛ, ɔ jiɛ 'e Sesi o. ");
INSERT INTO wob_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Sesi \"dua wlu 'ʋn ɛ, ɔ 'na : Dɛ ‑ɩn ‑nɩɛ \"i 'ɩn 'je ‑ʋn \"jrii nʋ ɛ‑ ? \"Dɔi 'na : 'Ɩn \"bo, ‑ɩn ‑nʋɛ 'ma \"jri 'je 'bai‑ 'ɩn 'je i 'je. ");
INSERT INTO wob_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","'De Sesi 'na : ‑Ɩn mu, ‑ma dɛ ‑kwlɩ\" ‑tea' 'pʋʋ ‑ʋn ‑ɛ. 'Bo ɛ \"sri ɔɔ' \"jri je 'bai‑, ɔɔ jea i 'je ‑wɛe ɔ bla 'o Sesi 'de. ");
INSERT INTO wob_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","‑Ta ʋʋa \"kʋʋan Selisalɛm ‑kwlɔ i, 'de Befase ke Betani ‑pʋn\", 'de olifɩ‑crʋ \"kpei ɛ, Sesi dboɛ ɔɔ' klai\" nynuu 'sɔɔn, ɔ 'na : ");
INSERT INTO wob_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","Ao mu 'e ‑kwlɔ ‑nɩa 'e nya 'di. ‑Bo aoa sea ‑kwlɔ i \"si ɛ, aoa muɛ soofaeju due' ‑mɔɔa i 'jea'. Nyɔ jrɔ' se ɛ \"kpei ‑te due'. Ao kain ɛ, ao 'je ɛ 'ʋn ja ‑ta. ");
INSERT INTO wob_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","‑Bo nyɔ ‑tee' aopʋ i 'de ɔ 'na dɛɛ‑tɩ aoa nʋ kan' a‑ ? ‑Mɛ ao wlu ao 'na Tʋ\"bo ‑nɩɛ \"i. Ɔɔ mu ɛ ‑jei\" pooa', ɛ 'je 'nɔ ji kaan. ");
INSERT INTO wob_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Ʋʋ mua, ʋʋ jɛɛ soofae' ju 'mɛ 'de ‑gbu\" due' \"wɔin, ɛ mɔɔɛ i 'de \"kpae' 'bo ‑je ‑wɔin\". Ʋʋ kain ɛ'. ");
INSERT INTO wob_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Nyʋ ‑nɩa 'mʋa‑ 'a jrʋ' wlu ʋʋpʋ ‑pee ʋʋ 'na : Dɛɛ aoa nʋ kan' a‑ ? 'De dɛɛ ‑tɩ aoa kain soofae' ju i ɛ‑ ? ");
INSERT INTO wob_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Ka Sesi \"sia 'nynɩ, 'ka klai\" nynuu 'da ʋʋpʋ ‑pee. 'Sʋ ʋʋ \"taiɛ ʋʋpʋ \"i, ʋʋ je mu. ");
INSERT INTO wob_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Ʋʋ ja Sesi soofae' ju, ʋʋ sroɛ ʋʋa' 'ʋnpaadɩ \"kpei, ‑wɛe ɔ 'jɛ \"kpei, ɔ ‑tei. ");
INSERT INTO wob_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Nyʋ ‑tuu\" sroɛ ʋʋa' 'ʋnpaadɩ ‑je woi, nyʋ jrʋ' cɛn ‑pɔa\" wɩn ‑kle' \"kpei‑ ‑wɛe ʋʋ po ɩ ‑je woi. ");
INSERT INTO wob_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Nyʋ ‑kɔan 'e Sesi \"juɔi ke nyʋ ‑kɔan 'e ɔ 'de ke, ʋʋa wee ɔ o, ʋʋ 'na : Osana ! ɛ 'de mɛ ‑nɩ : ‑Kai\" 'matɛ ! \"Diwan kpʋn nyɔ ‑ɔ jia 'de Tʋ\"bo 'a 'nynɩ 'ʋn ɛ ! ");
INSERT INTO wob_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Tʋ\"bodɛ ‑ɛɛ jia, ‑a \"bo Dafidɩ 'a tʋ\"bodɛ, Kea 'a \"diwan kpʋn ɛ ! ‑Kai\" 'matɛ 'de jaʋn 'di ! ");
INSERT INTO wob_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Sesi nynia 'bo Selisalɛm ɛ, ɔ pa 'e Kea ‑gbu klaa\" 'di, ‑wɛe dɩ \"klein ‑ɩa nʋʋa 'de mu, ɔ ‑gbʋn ɩ ‑wee' ja. Kwie a kpʋn a 'sʋ ɛ, ɔ ke ɔɔ' klai\" nynuu a ‑puue 'jɔ 'sɔɔn muɛ 'e Betani. ");
INSERT INTO wob_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Ɛɛ' ‑sɔn' ‑sɩan', ‑ta Sesi ke ɔɔ' klai\" nynuu a 'wlʋa Betani ɛ, 'mɩɩɛ‑ ɛ nʋ Sesi 'mɛ. ");
INSERT INTO wob_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Ɔ tɛɛn o fikɩtu due' wɩn \"jia ja, ɔ je ɛ i 'je. Ɔ mua, ɔmɔ 'na ɔ 'jeɛ \"buo ja 'je ‑o 'de‑, 'kaa ɔ 'kpaa' 'bo ɛ ‑sɔn ɛ, wɩn 'a 'sʋ mɩ ɔ jɛɛ‑, dɛ‑nʋɛ' ɛɛ' \"buo po nɔ\" se nyni. ");
INSERT INTO wob_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","'Sʋ Sesi \"duɛ wlu 'ʋn ɔ 'na : Ɛmɛ fikɩtu ‑nɛ, nyɔ jrɔ' 'bo ɛɛ' \"buo diɛ 'bode ! Dɛ ɔɔ 'tmʋa 'mʋa‑ ɔɔ' klai\" nynuu 'wɔɛn. ");
INSERT INTO wob_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","'Bo ‑mɛ 'de ɛ, ʋʋ nyniɛ Selisalɛm. Sesi pa 'e Kea ‑gbu klaa\" 'di, 'sʋ ɔ ‑teɛ nyʋ ‑a plea dɩ ke nyʋ ‑a ‑tɩan' dɩ 'de ɛ 'di inʋa' ‑pʋn\". 'Wɛi fai\" poonyʋ ke \"pai plenyʋ 'a \"kpa ‑tɩ ke ɔ ‑gbɩ' ‑wee' \"jɛi‑. ");
INSERT INTO wob_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Ɔɔ' 'wɔn nyɔ jrɔ' 'ɔ 'blee dɛ \"jru ɔɔ' cɛn Kea ‑gbu klaa\" 'di ‑tie\". ");
INSERT INTO wob_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","‑Wɛe ɔ ‑te nyʋ dɛ tɔɔa' ‑pʋn\" ɔ 'na : Wlu ‑crɩɩa' 'de Kea 'a 'sbɛ 'di ɛ, ɛ 'naa : 'Ma ‑gbu\" a muɛ nyʋ ‑wee' 'a Keabae‑gbu nɩa', 'kaa aopʋ mɔ nʋ ɛ \"jri‑gbu 'ʋn. ");
INSERT INTO wob_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","'Sraa ‑saʋn klae\" ke kɛ' wɔ‑saʋn 'wɔan dɛ ‑nɩa 'mʋa‑ 'sʋ ɛɛ' faʋn a nʋ ʋʋpʋ 'mɛ. Ʋʋa ‑pɔn Sesi 'a 'dba ‑kɔ i, dɛ‑nʋɛ' wlu ɔ 'tmʋa ke dɩ ɔɔ ‑sa wɔ ɩa \"siɛ nyʋ ‑kwea de \"i. ");
INSERT INTO wob_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","‑Fli bla 'sʋ Sesi ke ɔɔ' klai\" nynuu 'wlʋ 'o ‑kwlɔ 'mɛ. ");
INSERT INTO wob_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","‑Sɔn' ‑sɩan' ‑klae\" pɛɛn ‑ta ʋʋa ‑sia', klai\" nynuu 'jeeɛ fikɩtu ‑nɛ \"jriɛ‑. 'Kaa ɛ ‑sa jɛa' 'de \"jɛi, ɛ je 'de ɛɛ' 'sɩn o nyni. ");
INSERT INTO wob_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Piɛi poɛ dɛ ‑nʋʋa ‑kwlʋ o, 'sʋ ɔ wluɛ Sesi ‑pee ɔ 'na : 'Ma dɛtɔɔi, ‑ɩn ‑gbʋn fikɩtu ‑ɩn ‑pooa ‑soo' o ɛ, ɛ ‑wee' jɛ 'sɔɛ. ");
INSERT INTO wob_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","'Sʋ Sesi \"duɛ wlu 'ʋn, ɔ 'tmʋʋɛ ɔɔ' klai\" nynuu ɔ 'na : Ao ‑te' Kea ‑kwlɩ\" ! ");
INSERT INTO wob_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","'Ma 'tmʋʋɛ aopʋ tɔ' ‑tɩ, ‑bo ao ‑te' Kea ‑kwlɩ\" ɛ, ao 'bɛɛ' ao 'je crʋ ‑nɛ ‑pee wlu, ao 'je nʋ : Ɛ 'wlʋ ‑ta, ɛ 'je 'e 'tɔniɛ wɔn 'kpa ! Dɛ ao ‑teea' i, 'ka ɛɛ mua nʋa' ‑bo ao se ɛɛ' pɛe i plee ‑wɛe ao 'je ɛ ‑kwlɩ\" ‑te' ɛ, aoa muɛ 'jea', ɛ 'je 'o nyni. ");
INSERT INTO wob_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Ɛmɛ ‑tɩ 'ma 'tmʋʋ aopʋ, dɩ \"klein ao baea Kea ‑wɛe ao ‑teea' i ɛ, ka dɛ ɛɛ 'kpa ao 'kwa, ao ‑te' ɛ ‑kwlɩ\" aoa muɛ ɛɛ' dɛ tu 'jea' see ɛ 'e nʋʋɛ‑. ");
INSERT INTO wob_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","'De ‑ta ao nɩɩa baea' ‑bo ao 'blee nyɔ jrɔ' 'dii ‑mɛ ao ‑kɔ' ɔɔ' dɛsaʋn ‑wɛe ao \"Bo ‑nɩa 'e jaʋn 'di 'je aoa' dɩsaɩn ‑kɔ' ‑ke. ");
INSERT INTO wob_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","('Kaa ‑bo ao se nyʋ 'a dɛsaʋn ‑kɔ' ɛ, ao \"Bo ‑nɩa 'e jaʋn 'di se aoa' dɩsaɩn ‑kɔi' ‑ke.) ");
INSERT INTO wob_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Ʋʋ 'bɔɔ‑ de ʋʋ je Selisalɛm mu ke'wlɛ. ‑Ta Sesi a naa i 'de Kea ‑gbu klaa\" 'di ɛ, 'sraa ‑saʋn o, kɛ' wɔ‑saʋn o, nyʋ ‑cɔʋn'‑wi\" 'kpa 'de ɔ ‑pʋn\". ");
INSERT INTO wob_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Ʋʋ ‑tee' ɔ i ʋʋ 'na : ‑Ta ‑ɩn ‑sa \"ikmaa' ‑ma jea dɩ ‑nɩ nʋ ɛ‑ ? ");
INSERT INTO wob_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Sesi wlu ʋʋ ‑pee ɔ 'na : 'Ɩn nɩɛ \"i 'ɩn 'je aopʋ‑ dɛ due' i ‑tee'‑. ‑Bo ao ‑sɛ \"kpei ɛ, ‑ta 'ma \"ikmaa' 'wlʋa 'ma muɛ 'o 'a 'nynɩ \"sia'. ");
INSERT INTO wob_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Nyɔ ‑dbo' San Batisɩ nyʋ \"ni \"jru pooa 'a‑ ? Kea ‑ae, ‑aee' nyiɔ‑ ? Ao ‑sɛ \"kpei. ");
INSERT INTO wob_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Ʋʋa' 'sʋ ‑teɛ ba o ‑tooa' ‑pʋn\" ʋʋ 'na : ‑Bo ‑a ‑wlu ‑a ‑na Kea ‑dbo' ɔ ɛ, ɔɔ muɛ nʋa' dɛɛ‑tɩ ao se dɛ ɔ 'tmʋa tɔ' 'ʋn 'je ɛ‑ ? ");
INSERT INTO wob_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","'De ‑bo ‑a ‑na nyiɔ ‑dbo' ɔ ɛ‑ ? Ʋʋa plee nyiɔpʋ 'mɛ, dɛ‑nʋɛ' nyʋ ‑wee' a naa tɔ' i ʋʋ 'na San nɩɛ Kea 'a weepoi 'a ‑cɛ\" 'kpa ‑o. ");
INSERT INTO wob_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","'Sʋ ʋʋ wluɛ Sesi ‑pee ʋʋ 'na : ‑A se ɛ juo‑. 'De Sesi 'na : 'Mɔ ‑ke ɛ, ‑ta 'ma \"ikmaa' a 'wlʋa ‑wɛe 'ma nʋa dɩ ‑nɩ ɛ, 'ɩn se 'o 'a 'nynɩ \"sii‑ ‑ke. ");
INSERT INTO wob_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Sesi a cɛɛn 'e \"ipoo‑tɩ 'ʋn ‑wɛe ɔɔ 'tmʋʋ ʋʋpʋ wlu ‑pee ɔ 'na : \"Ju due' mɔ ‑dba rɛsɛn' ‑kle ɔ blɛ ‑klɛe 'de woi, ‑ɔ ‑blu\" ‑ta nyʋ 'jea rɛsɛn 'ʋn \"nmuu ɛ, ‑wɛe ɔ po \"miɔ‑gbu due'. 'De ɔ siɛ ‑busan dinyʋ o, ‑wɛe ɔ mu 'dʋʋa'. ");
INSERT INTO wob_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Rɛsɛn' ‑sa nɔ\" nynia, ɔ dboɛ ɔɔ' dbonʋi due' 'de ‑busan dinyʋ o, ‑wɛe ʋʋ 'je ɔɔ' ‑nɩ rɛsɛn' jɔ 'de ‑sa ʋʋ 'je ɔ \"nyɩ. ");
INSERT INTO wob_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","'Kaa ʋʋ kpʋn ɔɔ' dbonʋi ‑nɔ 'mɛ, ʋʋ blɔ' ‑wɛe ʋʋ nʋ ɔ i, ʋʋ se ɔ dɛ jrɛ' \"nyɩ. ");
INSERT INTO wob_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","‑Kle' jei dboɛ ɔɔ' dbonʋi jrɔ' ke'wlɛ. Ʋʋ ‑sa ‑mɔ kpi \"jrui ‑wɛe ʋʋ ‑cree\" ɔ. ");
INSERT INTO wob_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","‑Kle' jei dboɛ taan ‑nɔ, ʋʋ 'dba ‑mɔ 'mɛ. 'Ka ʋʋ nʋ ɔɔ' dbonʋnyʋ ‑tuu\"‑tuu, ʋʋ bla jrʋ', ʋʋ 'dba jrʋ'. ");
INSERT INTO wob_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Nyɔ due' koʋn ‑gbai' ‑sia ‑kle' jei 'kwa a, ɛmɛ ‑nɩ ɔɔ' ‑tɩ kmaju. Ɔmɔ ɔ dbo de 'bɔɔ‑ nɔ\" 'de ʋʋpʋ o. Ɔ naa tɔ' i ɔ 'na : Ʋʋa muɛ 'ma \"ju 'a ni' ‑tea' see. ");
INSERT INTO wob_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","'Kaa ‑busan dinyʋ ‑nʋ 'tmʋʋɛ ba ʋʋ 'na : \"Ju ‑jea 'kɛn kpa 'de nya ɔ ka. Ao \"nyɩ ‑a mu ‑a ‑je ɔ 'dba ‑wɛe ‑kle' 'je ‑a 'kwa sie‑. ");
INSERT INTO wob_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","‑Wɛe ʋʋ kpʋn ɔ ‑cɛɛn'‑, ʋʋ 'dbɔ, 'de ʋʋ ‑sa ɔɔ' \"ku 'bo ‑kle, ʋʋ po ɛ 'kwla. ");
INSERT INTO wob_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","'De Sesi 'na : Aoa naa tɔ' i 'ee, ka ‑kle' jei 'je nyʋ ‑nʋ 'a ‑tɩ' nʋ ɛ‑ ? Ɔɔ muɛ jia', ɔ 'je ‑busan dinyʋ 'dba, ‑wɛe ɔ 'je ɔɔ' ‑kle' dbonʋnyʋ jrʋ' \"nyɩ. ");
INSERT INTO wob_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Wlu ‑crɩɩa' ‑ta, ao seɛ 'dii nʋʋ ? Ɛ 'naa : \"Soukpo ‑gbu\" ponyʋ pooa sʋn i ɛ, ɛmɛ ‑snɛɛ \"soukpo ‑cɛɛn'‑ 'ʋn. ");
INSERT INTO wob_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Dɛ Tʋ\"bo nʋa, ɛmɛ ‑nao. Ɛ nmɔɔ ‑a 'di wɔn. ");
INSERT INTO wob_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","'Sʋ, Suifʋ‑wi\" 'a \"jrujeʋn a ‑pɔn Sesi 'a kpʋn ‑kɔ i, dɛ‑nʋɛ' ʋʋ 'je kan' 'mɛ ‑tɩ' ɔ pooa \"i ɛ, ʋʋpʋ ɔɔ 'da. 'Kaa ʋʋa pleea nyʋ ɛ, ʋʋ siɛ ɔ 'mʋa‑ ʋʋ je mu. ");
INSERT INTO wob_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Ʋʋ dboɛ Fariseɛn jrʋ' ke Erodɩ 'a 'cɛ jrʋ' 'de Sesi o, ‑wɛe ʋʋ 'je ɔɔ' ‑cɛ\" 'ɛ wlu 'a \"klɛ ‑pee ‑gba' 'de ʋʋ 'je ɔ \"kpei kpʋʋn‑. ");
INSERT INTO wob_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Ʋʋ jia, ʋʋ 'na : Nyʋ dɛtɔɔi, ‑a ‑juo ka ‑ma ‑tmʋa tɔ' ‑tɩ 'a 'sʋ 'mɛ. Nyɔ jrɔ' 'ɔ faʋn 'a nʋ ‑ʋn, dɛ‑nʋɛ' ‑maa' ‑gbʋn nyʋ 'a 'bɛsʋn ja, 'kaa ‑ma tɔɔɛ nyʋ Kea 'a ‑jeblʋ 'a ‑cɛ\" 'kpa. ‑Aa ‑teeɛ' ‑mi i nyʋ 'beeɛ' nyʋ 'je ‑dɛɩnpo' ‑sa, nyʋ 'je ɛ 'blʋajei Sesaa \"nyɩɩ ? ‑A ‑sɩ ‑ae, ‑aee' ‑a ‑bo ɩ ‑saa ? ");
INSERT INTO wob_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","'Kaa Sesi juo ka ʋʋ pooa \"jri de 'mɛ, 'sʋ ɔ 'na : Dɛɛ‑tɩ aoa ‑gba' 'ʋn wlu 'a \"klɛ ‑pee ɛ‑ ? Ao ja 'ʋn 'wɛijɔ due' kea' 'ɩn 'je ɛ 'je. ");
INSERT INTO wob_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","'Sʋ ʋʋ jɔ 'wɛijɔ due'. 'De Sesi ‑tee' ʋʋpʋ i ɔ 'na : Nyɔ ‑ble \"jru kpa\" ‑nɛ ke 'nynɩ ‑crɩɩa' ‑taa ? 'Sʋ ʋʋ 'na : 'Blʋajei Sesaa ‑o. ");
INSERT INTO wob_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Sesi wlu ʋʋpʋ ‑pee ɔ 'na : Dɛ ‑nɩa Sesaa 'a dɛ, ao \"nyɩ ɛ Sesaa, 'de dɛ ‑nɩa Kea 'a dɛ, ao \"nyɩ ɛ Kea o. 'Sʋ dɛ ɔ 'tmʋa ɛɛ' tai' \"maa ʋʋpʋ 'mɛ. ");
INSERT INTO wob_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Sadiseɛn jrʋ' jiɛ 'de Sesi o. 'De see ɛ, Sadiseɛn‑wi\" 'na \"kunyɩɔ' sɔn‑tɩ se tɔ' nɩ. Ʋʋ ‑teeɛ' Sesi i ka ʋʋ 'na : ");
INSERT INTO wob_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","Nyʋ dɛtɔɔi, Moisɩ 'crɩɛ kɛ' ‑nɛ ɔ je ‑a ‑nyɩ\", ɛ 'naa : ‑Bo \"junmɔu due' 'ble 'nynɔ ‑wɛe ɔ ke ʋ se \"ju 'wlʋ 'de ɔ 'je 'mɛ ɛ, ɔɔ' \"dei \"duo ‑tiɔn\" 'nynɔ ‑sia 'ʋn, ɔ ke ʋ 'je \"nynuu‑ 'wlʋ 'de ɔɔ' ‑fɛin' ‑mɛa ‑pee. ");
INSERT INTO wob_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","'Kaa ‑a ‑jeɛ de'dinmai ‑mɛ\" 'sɔn. ‑Jɔ ‑saa \"i 'blea 'nynɔ, ɔ se \"ju 'wlʋ, ɔ je 'mɛ. ");
INSERT INTO wob_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Ɔɔ' ‑tiɔn\" 'nynɔ ‑sia ɔɔ' \"dei \"duo ʋ 'ʋn 'ɛ. 'Kaa ɔ ke ʋ se \"ju 'wlʋ ‑ke, ɔ je 'mɛ. Dɛ due' ‑nɛ mɛ ‑nʋʋɛ taan ‑nɔ \"jrii ‑ke. ");
INSERT INTO wob_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Nyʋ ‑nɩa ‑mɛ\" 'sɔn ʋ jiia 'kwa i ɛ, ʋʋa' due' koʋn ‑gbai' ke ʋ se \"ju 'wlʋ ʋʋ ‑wee' je 'mɛ. Ʋʋ ‑wee' 'wlʋ 'kmʋ kpɩɩn‑, ‑wɛe ʋmʋ 'mɛ ‑ke. ");
INSERT INTO wob_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","‑Sɔntɩ nyʋ a mua \"kunyɩɔ' sɔan' a, ‑wɛe nyʋ ‑mɛa ‑wee' 'jea 'kmʋ de ji ɛ, nyɔ ʋ 'je \"bli \"ti ‑gbo' ɛ‑ ? Nyʋ ‑nɩa ‑mɛ\" 'sɔn ‑wee' 'ble ʋ 'nynɔ 'ʋn. ");
INSERT INTO wob_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","'De Sesi 'na : Ka aoa \"maa aoa' ‑cɛ\" tai' ao se ɛ juo‑ ? Aoa' 'wɔn Kea 'a wlu ‑crɩɩa' 'mii, 'de aoa' 'wɔn Kea 'a \"ikmaa' 'dei ? ");
INSERT INTO wob_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","'Kɛ ‑nɛ ‑cɛɛn'‑, ‑bo nyʋ sɔn \"kunyɩɔ', ‑mɛ \"nynunmai ke 'nynʋkpae 'a ba \"blitia' ‑kwɛ', 'kaa ka Kea 'a \"soa‑wi\" nɩa 'de jaʋn 'di ɛ, 'ka ʋʋa mu nɩa'. ");
INSERT INTO wob_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","'De dɛ ‑nɩa ‑ɩn ‑mɛ ‑wɛe ‑ɩn ‑sɔn \"kunyɩɔ' ‑tɩ' 'ʋn ɛ, dɛ ‑crɩɩa' 'de Moisɩ 'a 'sbɛ 'di 'de \"wi‑gbau'o 'a ‑tɩ' 'ʋn, ao se ɛ 'dii nʋ duee' ? Kea wluɛ Moisɩ ‑pee ɛ 'naa : 'Ɩn nɩɛ Ablaam 'a Kea, Isaakɩ 'a Kea, Sakɔbʋ 'a Kea. ");
INSERT INTO wob_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","‑Bo ɛ nɩ kan' a, ‑mɛ Kea nɩɛ nyʋ ‑nɩa 'kmʋ 'a Kea ‑o, ɛ se 'mɛʋn 'a Kea nɩ‑. Dɛ ao ‑sia' \"i ‑gblein' ‑wɛe ‑ɛɛ tai' \"maa aopʋ‑, ɛmɛ ‑nao. ");
INSERT INTO wob_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","‑Ta ʋʋa 'tmʋɛ ɛ, kɛ' wɔ‑sai due' a poɛ doun\" o. ‑Ta ɔ 'jea kan' ka Sesi ‑sa ‑tɩ' ʋʋpʋ ‑tee' ɔ i wɔ ka ‑cɔɔn' ka 'sʋ ɛ, ɔ 'kpa ɔ ‑pʋn\" ‑wɛe ɔ ‑tee' ɔ i ɔ 'na : Kɛ' ‑wee' \"klein 'a \"jruojɔ 'de ɛ‑ ? ");
INSERT INTO wob_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","'De Sesi 'na : Kɛ'ɛ \"jruojɔ 'ɔ \"i‑saa' ‑nɛ ka : ‑Ɩn ‑te' doun\" Israɛ, ‑aa Tʋ\"bo klaa\" Kea 'a 'sʋ mɛ ‑nɩ Tʋ\"bo. ");
INSERT INTO wob_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","‑Ɩn ‑kma ‑ma Tʋ\"bo Kea 'a ‑tɩ' 'de ‑ma pɛe ‑wee' o, 'de ‑ma ‑suu ‑wee' 'ʋn, 'de ‑ma tɔ' ‑wee' 'ʋn, 'de ‑ma 'kpɩ ‑wee' 'ʋn. ");
INSERT INTO wob_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","'De kɛ'ɛ 'sɔɔn ‑nɛ ka : ‑Ɩn ‑kma ‑ma ‑ponyiɔ 'ɔ ‑tɩ' ka ‑ɩn ‑kma ‑ma ‑cɛ\" 'ɛ ‑tɩ' ɛ. Kɛ' ‑jea \"i 'bɛ ‑ɛ ‑jea kɛ' 'sɔɔn ‑nɩa 'mʋa‑ ‑sii ɛ, ɛ se nɩ‑. ");
INSERT INTO wob_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","'Demɔ kɛ' wɔ‑sai \"duo wlu 'ʋn 'de Sesi ‑pee ɔ 'na : 'Kɛ nɩ ‑cɛɛn'‑, nyʋ dɛtɔɔi, ‑ɩn ‑tmʋɛ tɔ' ‑tɩ Tʋ\"bo klaa\" 'a 'sʋ ‑nɩ Kea, ‑kea'‑ jrɛ' se 'e de nɩ‑. ");
INSERT INTO wob_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Nyʋ 'je Kea 'a ‑tɩ' kma ‑o 'de ɔɔ' pɛe ‑wee' \"klein o, 'de ɔɔ' tɔ' ‑wee' \"klein 'ʋn, 'de ɔɔ' 'kpɩ ‑wee' \"klein 'ʋn, ‑wɛe ɔ 'je ɔ ‑ponyiɔ 'ɔ ‑tɩ' kma ka ɔ kma ɔɔ' ‑cɛ\" 'ɛ ‑tɩ' ɛ. Ɛ \"paa' ɛ je nmi \"klein nyʋ a poa \"jri ɔɔ \"nyɩa Kea ke 'sraa‑ \"klein nyʋ a ‑sa' ɔɔ \"nyɩ ɛ ‑sii. ");
INSERT INTO wob_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Sesi 'jea kan' ka ɔ poa ‑tɩ' wɔn o 'de tɔ' 'dinɩa' 'ʋn ɛ, ɔ 'na : ‑Ɩn se Kea 'a tʋ\"bo‑kwlɔ o tɛɛn‑. Ɛ 'wlʋa 'o mu ɛ, nyʋ ‑wee' a plee ɔɔ' i ‑teea' 'mɛ 'bode. ");
INSERT INTO wob_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","‑Ta Sesi a tɔɔa nyʋ dɛ 'de Kea ‑gbu klaa\" 'di ɛ, 'bomɔ ɔ ‑tee' ʋʋpʋ dɛ due' i, ɔ 'na : Kɛ nʋ ‑wɛe kɛ' wɔ‑saʋn a 'daa‑ Kea 'a 'o‑tei Dafidɩ 'a \"ju ɛ‑ ? ");
INSERT INTO wob_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Dafidɩ mɔ 'ɔ ‑cɛ\", Kea 'a ‑Suu po ɔ ‑je o ɛ, ɔ wlu' ka : Tʋ\"bo wluɛ 'ma Tʋ\"bo ‑pee, ɛ 'naa : ‑Ɩn ‑te i 'de 'ma dianfɔ o mamaʋ 'ɩn 'je ‑ma tʋnyʋ 'de ‑ɩn bʋ ‑sɔn ‑tu\". ");
INSERT INTO wob_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Dafidɩ mɔ'ɔ ‑cɛ\" ɛ 'daa‑ Kea 'a 'o‑tei Tʋ\"bo. Ka ɔ nʋ ɔɔ' \"ju nɩsʋn 'ja a‑ ? Sesi 'a wlu doin\" o poa' a nʋɛ nyʋ ‑tuu\" ‑kwea de 'tʋn. ");
INSERT INTO wob_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Nyʋ ɔɔ tɔɔa dɛ, ɔ wluɛ ʋʋpʋ ‑pee ɔ 'na : Ao ‑tu\" aoa' ‑cɛ\" 'ɛ ‑tɩ' 'de kɛ' wɔ‑saʋn 'a ‑tɩ' 'ʋn. ‑Ɩn ‑paa \"bai ‑tɔɔn 'ʋn ‑wɛe ‑ɩn ‑na i 'de nyʋ ‑wee' po ‑ʋn 'jewlu o \"kpae' woi ɛmɛ ʋʋa ‑pɔn. ");
INSERT INTO wob_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","\"Kpa‑tɩ klae\" ‑nɩa Kea ‑gbi 'dii o, ‑tein 'dɔe ‑nɩa ‑kɔ' ‑sɔn i mɩ ʋʋpʋ a ‑pɔn i. ");
INSERT INTO wob_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Ʋʋa ‑sa' ‑tiɔn\" nynʋkpae' dɩ 'kwa i. 'Kaa ʋʋa 'jeɛ nyʋ 'srɛ i pooa' 'a \"dia, baewlu \"tiɛ ʋʋpʋ wɔn 'di foo\" 'ʋn. 'De ɛɛ' ‑tɩ' 'ʋn ɛ, ʋʋa' 'pee a muɛ \"ikmaa'. ");
INSERT INTO wob_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Sesi ‑kɔa' nyʋ dɛ tɔɔa' 'sʋ ɛ, ɔ ‑teɛ i 'bo 'wɛ‑ 'di podɛ ‑pʋn\", ‑wɛe ka nyʋ a nʋa 'e 'wɛi posʋn ɔɔ ‑gbʋn' ɛ ja. \"Wliiɛjeʋn 'a ‑ta ‑tuu\" a poɛ 'e 'wɛi ‑tuu\". ");
INSERT INTO wob_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","'Bomɔ ‑tiɔn\" nynɔkpao' due' ‑sea' dɛ 'ble jii‑, ‑wɛe ʋ po 'e 'wɛijɔ mɩɩ\" 'sɔɔn, ‑bo ɩ bee o ‑wɛe ɩ nʋ ‑suujɔ 'ɔ tɔo 'a tɔo. ");
INSERT INTO wob_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","'Sʋ Sesi 'da ɔɔ' klai\" nynuu ɔ 'na : 'Ma 'tmʋʋɛ aopʋ tɔ' ‑tɩ, ‑tɩɔn\" nynɔkpao' nɩɩa\" a 'dba ‑ta, dɛ ʋ poa 'e 'wɛi 'dipodɛ 'di ɛ, ɛ ‑tiɛi\", ɛ je dɛ ʋʋ ‑wee' \"klein poa 'e ‑sii, ");
INSERT INTO wob_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","dɛ‑nʋɛ' 'wɛi ‑siia ʋʋpʋ i ɛ, ɩmɩ ʋʋ po 'e, 'kaa ʋmʋ se dɛ jrɛ' 'ble ʋa' nɩɩa\" wɛi' jɔ‑ ʋ ‑tea' ‑kwlɩ\" ɛ, ɛmɛ ʋ to 'e. ");
INSERT INTO wob_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","‑Ta Sesi a 'wlʋa 'de Kea ‑gbu klaa\" 'di ɔɔ \"sia \"kpae' ɛ, ɔɔ' klai\" nynuu 'a due' wlu ɔ ‑pee, ɔ 'na : 'Ma dɛtɔɔi, ‑gbʋn 'nɔ, \"soikpi ‑ɩ poa ‑gbu\" klaa\" ‑nɩ ‑ɩn ‑gbʋn ɩa' \"jriinmɔsʋn ja kea' ! ");
INSERT INTO wob_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","'Sʋ Sesi 'na : ‑Ma ‑je ‑gbi\" klae\" ‑nɩ 'mɛɛ, ɩ ‑wee' a muɛ blua' ɩa' \"sou se \"sou \"kpei siei. ");
INSERT INTO wob_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","‑Wɛe ɔ 'ja 'e olifie crʋ \"kpei, ɔ ‑tei 'de ɔ to Kea ‑gbu klaa\" \"jua \"i. 'Sʋ Piɛi o, Sakɩ o, San o, Ancre, blɔ \"jru ‑pʋn\", ‑wɛe ʋʋ ‑tee' ɔ i, ʋʋ 'na : ");
INSERT INTO wob_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","‑Ɩn ‑tmʋʋ' ‑aʋn ke blaa nɔ\" ‑mɩ 'a dɩ tu 'je nʋʋ ɛ‑, dɛ ‑jeɛ ‑to ka ɩa mua 'o nynia' a‑ ? ");
INSERT INTO wob_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","'Sʋ Sesi ‑teɛ ʋʋpʋ 'tmʋa' ‑pʋn\", ɔ 'na : Ao ‑tu\" aoa' ‑cɛ\" 'ɛ ‑tɩ' nyɔ jrɔ' je ao 'srɛ ipoo‑. ");
INSERT INTO wob_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Nyʋ ‑tuu\" a muɛ 'ma 'nynɩ \"jru ‑tea' ʋʋ 'je ji, ʋʋa' jrɔ' 'e nʋ : 'Mɔ ‑nɩ Kea 'a 'o ‑tei, 'mɔ ‑nɩ Kea 'a 'o ‑tei. 'Kamɔ ʋʋa mu nʋa' 'sʋ ʋʋ 'je nyʋ ‑tuu\" 'srɛ ipoo‑. ");
INSERT INTO wob_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","‑Bo aoa sea tʋ 'a 'nynɩ 'wɔn o, ‑bo aoa sea tʋ 'a ‑cruɛn\" 'wɔn o, dɛ 'bo ao 'dii waa. Ɛɛ' dɛ tu 'je nʋʋɛ‑ ‑o see. 'Kaa ‑mɛ se 'blʋa 'a ‑kwɛ‑ nɔ\" nɩ ke. ");
INSERT INTO wob_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","nyiɔ 'ɔ kpɛ jrʋ' a muɛ ʋʋ ‑ponyiɔ o ‑fɔan', 'blʋa 'a blo' wɔn jrɛ' ɛ muɛ ɛ ‑poblʋa o ‑fɔan'. 'Blʋa‑ a muɛ crɛa' dɩ 'mii, 'mɩɩɛ‑ ɛ muɛ jia'. Ka \"i‑saa ‑gbaan ‑di a kpʋn a 'nynɔkpao' ‑kwlʋ ɛ, 'ka ɩa mu nyʋ ‑kwlʋ kpʋn 'a. ");
INSERT INTO wob_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","'Kaa aopʋ mɔ ɛ, ao ‑tu\" aoa' ‑cɛ\" 'ɛ ‑tɩ'. Nyʋ a muɛ ao \"kuan poa' 'de 'pee 'wlʋ ‑gbi 'dii. Nyʋ a muɛ ao blaa' 'de \"jrui 'kɩɩn‑gbi 'dii. Dɛ ao ke 'ma na 'de ɛɛ' ‑tɩ' 'ʋn ɛ, aoa muɛ 'blʋajeʋn ke tʋ\"bo ‑wi\" \"juɔi mua' ‑wɛe ao 'je 'ma ‑tɩ' 'a ‑ta 'jeʋn nɩ‑. ");
INSERT INTO wob_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","'Kaa ‑pɔia\" ‑tɩ 'je 'tmʋʋɛ ‑o tɛin\" 'de nyiɔ 'ɔ kpɛ ‑wee' ‑pee. ");
INSERT INTO wob_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","'De ‑bo nyɔ nynaa aopʋ‑ i ‑wɛe ɔ 'je ao 'pee 'ʋn kpa a, ao 'bo dɛ ao 'jea 'tmʋ 'a ‑sɔɔn ‑tu\" ɛ. ‑Bo ao nyni 'e ɛ, ‑mɛ dɛ ‑ɛɛ mua aopʋ 'ʋn jia' a, ao 'tmʋɛ. Dɛ aoa mua 'tmʋa' ɛ se 'de aoa' ‑cɛ\" 'ʋn 'wlʋi, 'de Kea 'a ‑Suu 'ʋn 'de ɛ 'je 'wlʋ. ");
INSERT INTO wob_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Nyʋ jrʋ' a muɛ ʋʋa' ‑cɛ\" 'kpa 'a de'di 'de toa' ‑wɛe nyʋ 'je ʋʋpʋ 'dba. 'Ka \"nynuu‑ \"bo ‑wi\" a mu ʋʋa' \"nynuu‑ nʋa' ‑ke. \"Nynuu‑ jrʋ' a muɛ ʋʋpʋ \"bo ‑wi\" o ‑fɔan' ‑ke, ʋʋ 'je ʋʋpʋ 'dba. ");
INSERT INTO wob_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Dɛ ao nɩa 'ma 'cɛ 'de ɛɛ' ‑tɩ' 'ʋn ɛ, nyʋ ‑wee' \"klein a muɛ aopʋ 'ʋn 'nyɛa'. 'Kaa nyɔ ‑ɔ sea \"jru ‑jei\" ‑saa mamaʋ, ‑wɛe ‑ɔ mua ‑ɔ nynia, ɔmɔ ‑je 'pʋ. ");
INSERT INTO wob_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","‑Bo ao 'je dɛsaʋn 'a ma\" ‑ɛɛ kpʋʋn a nyʋ sɩaɩn'‑, ‑wɛe ɛ ‑te ‑ta ɛ sea \"i kɔn ɛ, ‑mɛ nyɔ ‑ɔɔ ‑sroa' 'e 'sbɛ 'dii 'wɔn ɛ 'mii‑. 'Sʋ ‑mɛ nyʋ ‑nɩa 'de Suide ple ʋʋ 'je crɩ 'dii mu. ");
INSERT INTO wob_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Nyɔ ‑wlʋa o ‑gbɛin\" ‑wɛe ‑ɔ mua \"kpae, ‑mɛ ɔ 'bo 'de jiɛ ɔ 'bo ɔɔ' 'bleedɩ 'ʋn \"duo ‑kɔ i ‑pɔɛn'. ");
INSERT INTO wob_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","'De nyɔ ‑ɔɔ mua 'de ‑kle nɩa', ɔ 'bo de \"biiɛ, ɔ 'bo ɔɔ' 'ʋnpaadɩ 'ʋn \"dua' muɛ. ");
INSERT INTO wob_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","'Nynʋkpae' ‑a mua \"kwli 'blea' ke ‑jʋ ‑ʋʋa mua \"nynuu‑ ‑kwlɩ\" 'blea' 'de ɛɛ' nɔ\" tu 'di ɛ, ‑wi\" ‑mʋ a muɛ ʋʋa' ‑cɛ\" wɔn 'jea' ! ");
INSERT INTO wob_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Ao bae Kea ‑wɛe ɩa' dɩ tu 'bo nʋʋɛ dee' 'a ji nɔ\", ");
INSERT INTO wob_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","dɛ‑nʋɛ' 'kle ‑a mua jia' 'de ɛɛ' nɔ\" tu 'di ɛ, ɛɛ muɛ \"ikmaa' ɛ 'je 'kle ‑wee' ‑sii. Dɛ ‑wlʋa 'de 'blʋa 'a ‑gbɔo ‑tee nɔ\" o, ‑ta Kea nʋa dɩ ‑wee' \"klein ɛ, ‑wɛe ‑ɛ ‑jɛɛa kaanwɩ ɛ, nyɔ se ɛɛ' 'kle tu 'je ke due' 'de nyɔ se ɛ 'bɛɛ‑ ɔ 'je ɛ 'kle jrɛ' \"i poo‑ 'de nya. ");
INSERT INTO wob_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","‑Bo Tʋ\"bo se ɩa' 'wɩ tu \"i \"kʋʋan‑ 'de ɛ, ‑mɛ nyɔ jrɔ' se 'pʋi. 'Kaa nyʋ ɛ 'da ‑wɛe ‑ʋʋ ‑jea ɛɛ' nyʋ nɩ ɛ, 'de ʋʋa' ‑tɩ' 'ʋn mɔ ɛ \"kʋʋan‑ ɩa' 'wɩ tu \"i. ");
INSERT INTO wob_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","‑Bo nyɔ jrɔ' wlu 'de ao ‑pee ka ɔ 'na : Ao ‑gbʋn 'nɔ, Kea 'a 'o ‑tei nɩɛ ‑ta, 'de ɔ nɩɛ 'nɔ, ao 'bo ɛ tɔ' 'ʋn 'jeɛ, ");
INSERT INTO wob_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","dɛ‑nʋɛ' nyʋ ‑ʋʋa ‑daa' ʋʋa' ‑cɛ\" Kea 'a 'o ‑teʋn ke wlu 'kwajaaʋn a muɛ jia'. Ʋʋa muɛ jrii' klae\" klae nʋa' ‑ɩ ‑bɛɛ' mɔ 'de‑ ‑ɩ ‑je nyʋ ‑ʋʋa naa Kea 'a ‑jei\" ka ‑cɔɔn' ka 'a \"jru ‑jei\" ‑saa. ");
INSERT INTO wob_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Aopʋ‑ mɔ ɛ, ao ‑tu\" aoa' ‑cɛ\" 'ɛ ‑tɩ'. 'Ɩn siɛ nɔ\" nya 'ɩn je ao dɩ ‑nɩa 'mʋa 'a ‑tɩ' 'tmʋʋ‑, ‑wɛe ao 'jɩ juo‑. ");
INSERT INTO wob_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","Ɛɛ' nɔi\" ɛ, ‑bo 'kle 'wlʋ 'o ‑jei\" ɛ, 'jrʋ a muɛ \"jri \"mua', 'cʋ se fain 'bode. ");
INSERT INTO wob_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Cʋ‑sɩɩn a muɛ \"jɛi 'wlʋa' ɩ 'je blu, ‑wɛe \"ikmadɩ ‑nɩa 'e jaʋn 'di 'je i ‑suua'‑ ‑wɛe ɩ 'je ‑teɩn 'wlʋ. ");
INSERT INTO wob_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","‑Wɛe nyʋ 'je nyiɔ 'ɔ \"Ju \"jriɛ‑ 'jee‑, ɔ 'je ji 'bo bue\" \"kpei, ɔ ke ɔɔ' \"ikmaa' ke ɔɔ' 'nynɩ 'wlʋa' ke‑. ");
INSERT INTO wob_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Ɔɔ muɛ ɔɔ' \"soa‑wi\" dboa' 'de 'blʋa 'a 'fɔ ‑nyiiɛ ‑wee' o, ‑wɛe ʋʋ 'je nyʋ Kea ‑sa 'o \"jrui 'kɩɩn‑, dɛ ‑mua' ‑ɛ ‑jɛɛa ‑ta 'blʋa‑ ke jaʋn \"tia a. ");
INSERT INTO wob_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","Dɛ ti a tɔɔa nyʋ ɛ, ao siɛ \"jriɛ‑ o : ‑Bo ti 'a 'dae a sea tɔɔ ɛ ɩ 'je wɩn dee ‑tuu\" ‑ɛ ‑o. ‑Mɛ ka ‑kua\" sea o tɛɛn‑ ao juɛ. ");
INSERT INTO wob_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","'Kamɔ ‑bo aoa sea dɩ ‑nɩa 'mʋa‑ i 'je ɩa sea nʋʋɛ ɛ, ‑mɛ ka nyiɔ 'ɔ \"ju 'a ji nɔ\" \"kʋʋan‑ i ‑wɛe ɔ nɩa 'o ‑gbɛin\" ‑jei\" ɛ, ao 'jɩ juo ‑ke. ");
INSERT INTO wob_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","'Ma 'tmʋʋɛ aopʋ tɔ' ‑tɩ : Nyʋ ‑nɩa 'kmʋ kaan 'a jrʋ' se 'mɛi dɩ ‑nɩa 'mʋa‑ 'je nyni. ");
INSERT INTO wob_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Jaʋn ke 'blʋa‑ a muɛ ‑sia', 'kaa 'ma wlu se ‑sii 'nɔ 'kmʋ. ");
INSERT INTO wob_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","Nyɔ se ɛɛ' 'wɩ ke ɛɛ' nɔ\" juo, Kea 'a \"soa‑wi\" ‑nɩa 'de jaʋn 'di foo\" 'sʋ se ɛ juo‑, Kea 'a \"Ju 'a ‑cɛ\" 'kpa se ɛ juo‑, Kea due' koʋn ‑gbai' mɛ ‑juo ɛ. ");
INSERT INTO wob_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Ao 'bo i \"maɛeɛ ao ‑tu\" aoa' ‑cɛ\" 'ɛ ‑tɩ', dɛ‑nʋɛ' nɔ\" ‑ɛ 'di ɛɛ' dɛ tu a mua nʋʋa' ao seɛ juo‑. ");
INSERT INTO wob_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Ka ‑gbu\" jei 'a 'dʋʋa' mua' nɩa, 'ka ɛɛ mu nɩa'. Ɔ siɛ ɔɔ' ‑gbu\" ɔɔ' dbonʋnyʋ o, ɔ ‑gble' ɛ ʋʋpʋ dbo \"jrii due 'due, ‑wɛe ɔ 'tmʋʋ‑ ‑gbu\" ifuoi ɔ 'na : ‑Ɩn ‑te \"jriɛ‑ \"i. ");
INSERT INTO wob_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Ao ‑te \"jriɛ‑ \"i 'ja, dɛ‑nʋɛ' nɔ\" ‑gbu\" jei 'jea de ji ɛ, ao se ɛ juo‑. Ɛ 'beeɛ' ɛ 'je ‑kwie\" ka nɩ‑, ɛ 'je ‑too' ‑kwea nɩ‑, ɛ 'je sʋn\" 'a ‑sro' nɔ\" nɩ‑, ɛ 'je ‑klae\" pɛɛn nɩ‑. ");
INSERT INTO wob_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Ao ‑tu\" aoa' ‑cɛ\" 'ɛ ‑tɩ', ao je \"nyɩɔ' nɩ ‑wɛe ɔɔ' dejia' je aopʋ \"jru ‑tiie'‑. ");
INSERT INTO wob_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Dɛ 'ma 'tmʋʋa aopʋ‑ ‑ta, 'ma 'tmʋɛ 'de nyʋ ‑wee' \"klein ‑pee : Ao ‑te \"jriɛ‑ \"i ! ");
INSERT INTO wob_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Kʋɔnkwla' 'wlʋ ‑kɔ ke ‑kɔ' jrɛ' nyʋ a 'daa‑ ‑di'pɛn ‑sea' ‑pun\" 'a ‑kɔ' ke ɩa' 'wɩ siɛ 'sɔɔn. 'Sʋ 'sraa ‑saʋn 'a klae\" ke kɛ' wɔ‑saʋn a ‑pɔn Sesi 'a kpʋn ‑kɔ i 'srɛ 'ʋn, ‑wɛe ʋʋ 'je ɔ 'dba. ");
INSERT INTO wob_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Ʋʋ 'tmʋʋɛ ba ʋʋ 'na : ‑A ‑bo ɛ nʋɛ 'bo ‑kɔ' ‑sɔn ‑wɛe ‑kli je 'kpa. ");
INSERT INTO wob_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Sesi nɩɛ 'o Betani, 'de ‑tee' dii Simɔ o ‑gbu\". ‑Ta ɔ ‑teea i ɔ nɩa dɛ dia' a, \"junynɔkpao' due' pa ‑gbu\". Ʋ 'bleɛ kmaa -dai'klɔni 'ɔ ‑sooɛ due'. Ɛɛ' ‑sooɛ tu ɛ, \"sou 'dɔe ‑nʋɛ' ‑ɛɛ 'nynɩ nɩ albatrɩ. ‑Dai'klɔni ‑nɩa 'e ɛ 'di ɛ, ɛɛ' 'nynɩ ‑nɩ naadɩ. ɛ ke dɛ jrɛ' se o bee‑, ɛɛ' sɔɔn' kma'. Ʋ cɩɛn ‑cun\" \"wɔin, ‑wɛe ʋ \"cnii ɛ \"i 'bo Sesi \"jru. ");
INSERT INTO wob_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Nyʋ ‑nɩa 'e ‑gbu\" 'di 'a jrʋ' 'kpa 'cɛn ʋʋ 'na : Dɛ ‑ble ‑dai'klɔ ‑nɛ ‑mɛ 'ɛ i dooa' kan' a‑ ? ");
INSERT INTO wob_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","'De ‑mɛ 'kamɔ nyʋ 'beeɛ' nyʋ 'je ɛ ple 'wɛi 'a kwla mɛɛo\"‑. ‑Wɛe nyʋ 'je ɛ nɩɩa\" nyʋ \"nyɩ. 'Sʋ ʋʋa ‑cɛ' \"junynɔkpao' ‑nʋ \"bli. ");
INSERT INTO wob_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","'Sʋ Sesi wlu' ɔ 'na : Ao 'wlʋ ʋ ‑pʋn\". Dɛɛ ‑tɩ aoa kpʋn ʋ ‑kwlʋ ɛ‑ ? Dɛ ʋ nʋa 'de 'ma ‑tɩ' 'ʋn ɛ, ɛ nmɔ \"i, ɛ nɩɛ 'ma \"jrii nʋ ka‑, ");
INSERT INTO wob_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","dɛ‑nʋɛ' ao ke nɩɩa\" nyʋ ‑wi\" a muɛ i ‑tea' 'wɩ ‑wee' 'di. ‑Sɔntɩ ao nɩɛ \"i ɛ, ao 'beeɛ' ao 'je ʋʋpʋ 'dɔe \"jrii nʋ, 'kaa 'mɔ ke ao se i ‑tei 'de 'wɩ ‑wee' 'di. ");
INSERT INTO wob_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Dɛ ʋ 'bɛɛa kwa i ɛmɛ ʋ nʋa 'o. Ʋ 'wla 'ʋn ‑dai'klɔ \"jru ‑wɛ‑. Ʋ siɛ 'ma inmae nɔ\" nya, ʋ je 'ʋn ‑pɛɛ. ");
INSERT INTO wob_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","'Ma 'tmʋʋɛ aopʋ tɔ' ‑tɩ : ‑ta \"o ‑ta nyʋ a mua ‑pɔia\" wlu 'tmʋa' 'de 'blʋa‑ \"kpei ɛ, nyʋ a muɛ \"junynɔkpao' ‑nʋ 'a ‑tɩ' ‑kwlʋ o poa', dɛ ʋ nʋa nyʋ 'je ɛ 'tmʋ. ");
INSERT INTO wob_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Suida Isikario, ‑ɔ ‑nɩa 'e klai\" nynuu ‑nɩa ‑puue 'jɔ 'sɔɔn \"klu, muɛ 'de 'sraa ‑saʋn 'a klae\" ‑wi\" o, ɔ 'na ɔ 'je Sesi ple 'de ʋʋpʋ 'kwa. ");
INSERT INTO wob_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Ʋʋ 'wɔan wlu ‑nɛ 'de Suida 'wɔn ɛ, ɛ 'bleɛ ʋʋpʋ 'a 'mʋa‑. Ʋʋ cɛn wlu ‑tie\", ʋʋ 'na ʋʋ 'je ɔ 'wɛi \"nyɩ. 'Sʋ Suida a ‑pɔn Sesi 'a kpʋn ‑kɔ i ‑wɛe ɔ 'je ɔ 'de ʋʋpʋ 'kwa ‑tu\". ");
INSERT INTO wob_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","‑Di'pɛn ‑sea' ‑pun\" ɛɛ' ‑kɔ'ɔ \"i‑saawɩ o ɛ, ʋʋa a ‑saa' 'blae‑tɔe ‑sraa ‑wɛe ʋʋa ‑tu\" kʋɔnkwla' 'wlʋ ‑kɔ. Ɛɛ' 'wɩ tu 'di ɛ, Sesi 'a klai\" nynuu ‑tee' ɔ i ʋʋ 'na : ‑Ta ‑ɩn ‑nɩi\" ‑a ‑je ‑ma ‑kɔ' diidɛ pii ɛ‑ ? ");
INSERT INTO wob_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","'Bomɔ Sesi dboo ʋʋa' 'sɔɔn, 'de ɔ 'na : Ao mu 'e ‑kwlɔ. Ao ke \"ju due' ‑a ‑mu ‑gbʋʋan' ɔ 'e \"nibi \"kpei po‑. Ao bla 'bo ɔ 'de. ");
INSERT INTO wob_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","‑Gbu\" ɔɔ mua 'di paa' a, ao 'tmʋʋ ɛɛ' jei ao 'na : ‑Aa dɛtɔɔi 'naa : ‑Gbu\" 'a wɔn ‑jɛwɛ‑ ‑ɛ 'di 'ɩn ke 'ma klai\" nynuu 'je ‑kɔ' diidɛ dii ɛ‑ ? ");
INSERT INTO wob_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","'Sʋ ɔɔ muɛ ao ‑gbu\" 'a wɔn klaa\" due' ‑nɩa 'e \"jɛi tɔɔa'. Dɩ ‑wee' pooɛ kpɔi\" 'de ɛ 'di sese. 'Demɔ ao 'je ‑aa diidɩ pii‑. ");
INSERT INTO wob_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Klai\" nynuu mua 'de ‑kwlɔ ɛ, ʋʋ jɛɛ dɩ ‑wee' 'mɛ ka Sesi \"sia ɩa' 'nynɩ ɛ, ‑wɛe ʋʋ pi ‑kɔ 'ɔ diidɩ. ");
INSERT INTO wob_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","‑Fli 'wlaa 'sʋ, Sesi ke ɔɔ' klai\" nynuu ‑nɩa ‑puue 'jɔ 'sɔɔn ‑wee' ji'. ");
INSERT INTO wob_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","‑Ta ʋʋ nɩɩa dɛ dia' a, Sesi 'na : 'Ma 'tmʋʋɛ aopʋ tɔ' ‑tɩ, aoa' due' ‑ɔ ‑ke 'ma poa sʋn ‑tadue ‑ta a, ɔɔ muɛ 'ʋn plea'. ");
INSERT INTO wob_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Klai\" nynuu ‑wee' \"kaeɛ \"jrii, ʋʋa ‑tee' ɔ i due 'due ʋʋ 'na : Ɛ se 'mɔ nɩ 'de ! ‑Aee' 'mɔ ‑o ? ");
INSERT INTO wob_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","'De Sesi 'na : Ao ‑nɩa ‑puue 'jɔ 'sɔɔn ɛ, aoa' due' ‑ɔ ‑ke 'ɩn nɩa ‑di'pɛn 'smaa' ‑ta ‑due ‑ta ‑o. ");
INSERT INTO wob_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Tɔ' ‑o, 'dɛ ‑crɩɩa' 'de nyiɔ 'ɔ \"Ju 'a 'mɛ ‑tɩ 'ʋn 'je 'o nynia' ‑cɛɛn'‑, 'kaa nyɔ ‑ɔɔ mua ɔ 'e toa' a, ɛ nɩɛ \"nmia‑tɩ ‑o 'de ɔɔ' jei tu 'a ‑tɩ' 'ʋn ! Ɔɔ' se 'kmʋ ji \"paa' 'de‑. ");
INSERT INTO wob_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","‑Ta ʋʋ nɩɩa dɛ dia' a, Sesi \"duɛ ‑di'pɛn 'ʋn, ɔ poɛ ɛɛ' Kea 'sɛ‑ ‑wɛe ɔ cɩɛn ɛ ‑tie\" ɔ \"nyɩ ɛ ɔɔ' klai\" nynuu, 'de ɔ 'na : Ao \"duo ɛ 'ʋn, ao 'je ɛ di, ɛ nɩɛ 'ma ku ‑o. ");
INSERT INTO wob_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","‑Wɛe ɔ \"duo nmɔ ‑saan 'a \"pɛ 'ʋn, ɔ po Kea 'sɛ‑. 'De ɔ \"nyɩ ɛ ʋʋpʋ, ‑wɛe ʋʋ ‑wee' \"klein 'nɛɛ. ");
INSERT INTO wob_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","'De Sesi wlu ʋʋpʋ ‑pee ɔ 'na : Ɛ ‑nɛ nɩɛ 'ma nymɔ ‑o, dbɛɛdɛ 'ɛ nymɔ ‑ɛ ‑wla i nyʋ ‑tuu\" 'a ‑tɩ' ɛ. ");
INSERT INTO wob_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","'Ma 'tmʋʋ aopʋ tɔ' ‑tɩ, 'ɩn se nmɔ ‑saan 'nai 'bode mamaʋ 'sʋ 'ɩn 'je ɛɛ' dee' ‑nɛ 'na 'de Kea 'a kɛɛma' ‑kwlɔ 'di. ");
INSERT INTO wob_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Ɛ 'wlʋa 'mʋa‑ a, ʋʋ ‑kɔ' Kea 'a 'nynɩ \"i 'bɛɛdʋ blea' ‑wɛe ʋʋ mu 'de olifɩ‑crʋ \"kpei. ");
INSERT INTO wob_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Ʋʋ nynia 'e crʋ \"kpei 'sʋ ɛ, Sesi wlu' 'de ɔɔ' klai\" nynuu ‑pee ɔ 'na : Ao ‑wee' \"klein a muɛ 'ʋn 'bɔa', 'kamɔ wlu ‑crɩɩa' 'de 'ma ‑tɩ' 'ʋn 'da, ɛ 'na : 'Ma muɛ nɔ\" dɩ 'dei ‑tei 'dbaa', ‑wɛe 'blae ‑wee' 'je dɩ 'mii ‑gbaa. ");
INSERT INTO wob_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","'De ‑bo 'ɩn sɔn \"kunyɩɔ' ɛ, 'ma muɛ ao \"juɔi ‑sia' 'ɩn 'je 'de Galile mu. ");
INSERT INTO wob_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","'Sʋ Piɛi 'na : ‑Bo nyʋ ‑wee' 'bɔ ‑ʋn mɔ 'de ɛ, 'mɔ se ‑ʋn 'bɔi. ");
INSERT INTO wob_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Sesi 'na : 'Ma 'tmʋʋɛ ‑ʋn tɔ' ‑tɩ, 'de \"maʋ' 'wɩ 'di ‑sɩan a, nɔ\" ‑tɩ sʋn\" 'je ‑sro' kpɛ 'sɔɔn ɛ, ‑ma muɛ 'ʋn wɔn ‑sa 'a kpɛ taan. ");
INSERT INTO wob_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","'Kaa Piɛi 'nyɛ ɛ \"kpei ke'wlɛ ɔ 'na : ‑Bo ‑ɩn ‑ke 'ma ‑a ‑je 'mɛ ‑tadue mɔ 'de ɛ, 'ɩn se ɛ 'bɛɛ‑ 'ɩn 'je ‑ʋn wɔn ‑sa 'nɔ 'kmʋ. 'Kamɔ klai\" nynuu ‑sia 'o ‑wee' \"klein 'da ‑ke. ");
INSERT INTO wob_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Ʋʋ 'wlʋa 'mʋa‑ ʋʋ nynia ‑ta nyʋ a 'daa‑ Sɛsemane ɛ, Sesi 'tmʋʋ ɔɔ' klai\" nynuu ɔ 'na : Ao ‑te i ‑ta, 'ma muɛ baea'. ");
INSERT INTO wob_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","‑Wɛe ɔ \"duo Piɛi ke San ke Sakɩ 'ʋn. ‑Wɛe ɔ ke ʋʋ 'kɩɩn‑ 'o nya dɛ‑saan\"‑ 'sʋ dɛ ‑teɛ ɔɔ' 'dii waa' ‑pʋn\", ɔɔ' pɛe cɛn mlɛun\". ");
INSERT INTO wob_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","'De ɔ wlu ʋʋpʋ ‑pee ɔ 'na : 'Ɩn \"kaeɛ \"jrii \"kɩkɩ. 'Ma pɛe ‑siɛ' sro ɛ e 'mɛɛa' jɛɛ‑. Ao sie ‑ta ao 'je \"jriɛ‑ \"i ‑te. ");
INSERT INTO wob_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","‑Wɛe ɔ 'kpaa' 'de nya dɛ‑saan\" ka, ɔ tba \"jua‑ i 'bo 'blʋɔ, ɔ bae Kea ‑bo ɛ se ɛ 'bɛɛ‑ ɛ 'je ɔ kuiwɔn 'je nɔ\" ‑nɛ o tɛɛn. ");
INSERT INTO wob_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Ɔ 'na : 'Ɩn \"Bo, ɛ 'bɛɛ‑ dɛ ‑wee' 'mɛ, ɛ tɛɛn 'ʋn 'kle 'je nɔ\" ‑nɛ o. 'Kaa 'ma 'tʋn nʋ‑tɩ 'bo nʋʋɛ, ɛɛ' ‑nɩ mɛ ‑je nʋʋɛ‑. ");
INSERT INTO wob_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Ɔɔ jia de ‑mɛ ɔ jɛɛ klai\" nynuu \"nyɩɔ'. 'Sʋ ɔ 'na : Simɔ Piɛi, ‑ma ‑mʋʋ' ? ‑Ɩn se ɛ 'bɛɛ‑ ‑ɩn ‑je \"nyɩɔ' mɛ i kpʋʋn kpɛ due' ‑wee'‑ ? ");
INSERT INTO wob_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Ao ‑te \"jriɛ‑ \"i, ao bae Kea ‑wɛe ao je dɛsaʋn 'di blu. Nyiɔtɔ' ‑teɛ 'dɔe nʋa 'a kein\"ke, 'kaa 'blʋku se 'e 'de i ku‑. ");
INSERT INTO wob_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","‑Wɛe ɔ tɛɛn o ke'wlɛ, ɔ po bae wlu due' ‑nɛ. ");
INSERT INTO wob_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","‑Ta ɔɔ jiia de ‑mɛ ɔ jɛɛ ɔɔ' klai\" nynuu \"nyɩɔ' ke'wlɛ, dɛ‑nʋɛ' ʋʋa' \"jri kuɛ kwa. 'Sʋ dɛ ʋʋ 'je ɔ ‑pee 'tmʋʋ, ɛ se nɩ‑. ");
INSERT INTO wob_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Ɔ jia de kpɛ taan ‑nɛ ɛ, ɔ 'na : Ao ‑teɛ i ke aoa jea 'mʋʋ ? Ɛ sie kan' ! Nɔ\" nyni' ‑wɛ‑. Ao ‑gbʋn 'nɔ, nyiɔ 'ɔ \"Ju a jiɛ 'de dɛsaʋnʋʋn 'kwa ‑tuu\" 'a. ");
INSERT INTO wob_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Ao sɔn 'ʋn, ‑a ‑je mu ! \"Ju plea' 'ʋn, ɔ ka ‑ta ! ");
INSERT INTO wob_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Sesi siɛ wlua' 'sʋ Suida ‑ɔ ‑tuu\" a klai\" nynuu ‑puue 'jɔ 'sɔɔn je i \"si. Ɔ ke nyʋ ‑tuu\" ji' ‑ʋʋ ‑ble ‑cnɩ ke tu tii ke. 'Sraa ‑saʋn klae\" ke kɛ' wɔ‑saʋn ke nyʋ‑cɔɩn' ‑wi\" ‑dbo' ʋʋpʋ ‑wɛe ʋʋ 'je Sesi kpʋn. ");
INSERT INTO wob_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Suida ‑ɔ plea Sesi ɛ, ɔ tɔɔ nyʋ ‑ke ɔ jia dɛ jrɛ' ‑bo ɔ nʋ ‑wɛe ʋʋ 'je Sesi \"jriɛ o sie, ɔ 'na : \"Ju 'ma mua ‑kwlɩ\" ‑gblea' 'teɔ ɛ, ɔmɔ ‑nao. Ao kpʋn ɔ ‑bo aoa se ɔ kpa 'ja a, ‑mɛ ao sie ɔ \"jriɛ‑ o ! ");
INSERT INTO wob_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Suida nynia, ɔ 'kpa Sesi ‑pʋn\" ɔ 'na : 'Ma dɛtɔɔi ! 'Sʋ ɔ blu ɔ \"kpei ɔ ‑gblee ɔ ‑kwlɩ\". ");
INSERT INTO wob_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Nyʋ ‑sia 'o 'wla 'e Sesi \"kpei, ʋʋ kpʋn 'ɔ. ");
INSERT INTO wob_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","'Sʋ ɔɔ' klai\" nynuu ‑nɩa 'mʋa 'a due' ‑sa ɔɔ' ‑cnɛ kpla', ɔ pooɛ 'sraa ‑sai klaa\" 'a dbonʋi, ɔ cɛn ɔ doun\" \"jru. ");
INSERT INTO wob_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Sesi \"dua wlu 'ʋn 'de nyʋ ‑jiɔ' kpʋan' ‑pee ɔ 'na : Ao 'bleɛ ‑cnɩ ke tu tii ‑wɛe aoa ji 'ʋn kpʋan', ɛ ‑kɔ' ‑na 'ɩn nɩɛ \"ku 'dbai ‑o. ");
INSERT INTO wob_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","'Wɩ ‑wee' \"klein 'di 'ɩn ke ao nɩɛ ‑tadue, 'ma jea ao dɛ tɔɔ 'de Kea ‑gbu klaa\" 'di, ao se 'ʋn kpʋn 'bo ‑mɔ. 'Kaa ɛ nʋɛ' kaan ‑wɛe Kea 'a wlu ‑crɩɩa' 'je 'o nyni. ");
INSERT INTO wob_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Ɔ 'da kan' 'sʋ klai\" nynuu ‑wee' 'wlʋ ɔ 'de 'mɛ, ʋʋ ‑wee' 'kpʋa 'kwlɩ 'dii. ");
INSERT INTO wob_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","‑Kooa\" i ‑tɔo due' ‑ɔ ‑wla tae' plu 'a 'sʋ \"kpei, mɔ ‑bla 'o Sesi 'de. Nyʋ a ji ɔ kpʋn 'a ‑ke 'sʋ ɛ, ");
INSERT INTO wob_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","ɔ nyɩa tae' kui ɔɔ' \"kpaan 'kpa 'kwla. ");
INSERT INTO wob_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Ʋʋ kpa Sesi 'de 'sraa ‑saʋn klae\" \"juɔi. 'Bomɔ 'sraa ‑saʋn 'a klae\" ‑wee' ‑ke nyʋ‑cɔɩn' ‑wi\" ke kɛ' wɔ‑saʋn ‑wee' 'kɩɩɛn \"jrui. ");
INSERT INTO wob_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Piɛi a bla Sesi bʋ ‑kɔ o i mamaʋ 'sʋ ɔ ke ɔ je 'e 'sraa ‑sai klaa\" o ‑gbu\" pa. 'Bomɔ ɔ ‑te i 'de \"soa‑wi\" \"klu, ‑wɛe ɔɔ 'wooa nɛ. ");
INSERT INTO wob_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","'Sraa ‑saʋn 'a \"jrujeʋn ke ‑gbajeʋn ‑wee' ‑kɩɩan' \"jrui a ‑pɔn ʋʋ 'je Sesi ‑tɩ' \"kpei bla ‑wɛe ʋʋ 'je ɔɔ' 'mɛ ‑tɩ wlu \"kpei 'bɛɛ‑. 'Kaa ʋʋ se dɛ jrɛ' 'je. ");
INSERT INTO wob_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Nyʋ ‑tuu\"‑tuu a ‑tuu\" ɛ Sesi sɩ ‑tɩ \"kpei‑, 'kaa ʋʋa' 'sʋ 'a wlu 'a kpʋn ba. ");
INSERT INTO wob_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","'Bomɔ ʋʋa' jrʋ' sɔn 'ʋn, ‑wɛe ʋʋ 'nɩɩɔ sɩ ‑tɩ ‑nɛ \"kpei‑ ʋʋ 'na : ");
INSERT INTO wob_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","‑A ‑wɔn ɔɔ' wlu 'mɛ. Ɔ 'na : 'Ma muɛ Kea ‑gbu klaa\" nyiɔ poa ‑ta \"jɛi‑ gbaa', ‑wɛe 'de 'wɩ taan 'di ɛ, 'ɩn 'je ɛɛ' ‑jɛ nyiɔ 'ɔ sʋn sea \"i bla po. ");
INSERT INTO wob_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","'Kaa 'bo ‑mɛ \"kpei ke'wlɛ ɛ, ʋʋpʋ a' wlu 'a kpʋn ba. ");
INSERT INTO wob_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","'Bomɔ 'sraa ‑sai klaa\" sɔɔn 'ʋn 'de nyʋ ‑wee' \"klein \"juɔi, ɔ ‑tee' Sesi i, ɔ 'na : Dɩ ‑tia ka nyʋ ‑nʋ a bla ‑ʋn \"kpei ‑ta ‑ɩn se ɛ 'bɛɛ‑ ‑ɩn ‑je dɛ jrɛ' \"kpei ‑sa mɔ ‑wee' 'sʋʋ ? ");
INSERT INTO wob_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","'Kaa Sesi se dɛ jrɛ' 'tmʋ. 'Sʋ 'sraa ‑sai klaa\" ‑sa de ɔ ‑tee' ɔ i, ɔ 'na : ‑Ɩn ‑nɩɛ Klisɩ \"diwan Kea 'a 'o ‑te ju ‑oo ? ");
INSERT INTO wob_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","'De Sesi 'na : Kɩɩn, ɛmɛ 'ɩn nɩ‑. 'Bo ‑mɛ 'de ɛ, aoa muɛ nyiɔ 'ɔ \"Ju 'jea', ɔ 'je i ‑te 'de \"ikma Kea 'a dianfɔ o. Aoa muɛ ɔ \"jriɛ‑ 'jeea' ke'wlɛ ɔ 'e de ji 'de jaʋn ‑kwlʋ 'bo bue\" \"kpei. ");
INSERT INTO wob_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","'Sʋ 'sraa ‑sai klaa\" 'faeɛ ɔɔ' 'ʋnpaadɩ i, 'de ɔ 'na : Dɛ ‑ɛɛ ‑tɩ' 'a ‑ta 'jeʋn jrʋ' ‑aa ‑pɔn i ke'wlɛ ɛ‑ ? ");
INSERT INTO wob_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Ka ɔ toa Kea wɔn o aoa' ‑cɛ\" 'kpa 'jee ɛ ‑wɛ‑, ka aoa naa tɔ' i ɛ‑ ? Ʋʋ ‑wee' \"klein cɛn ɔ wɔn \"kpei ʋʋ 'na : Ɔ 'je 'mɛ ‑o ! ");
INSERT INTO wob_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Ʋʋa' jrʋ' ‑te ɔ tɔn \"jri wlaan' ‑pʋn\". Ʋʋ blɔ dɛ \"jri, ‑wɛe ʋʋ tbɔ kpiin', 'de ʋʋ 'na : ‑Ɔ nʋ kan' a‑ ? ‑Ɩn ‑si\" ɔɔ' 'nynɩ ! ‑Wɛe \"soa‑wi\" po ɔ 'kpɩ doin\" i. ");
INSERT INTO wob_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","‑Ta Piɛi nɩa 'e ‑gbɛin\" ‑sɔin ɛ, 'bomɔ 'sraa ‑sai klaa\" 'a dbonʋnynɔkpao' due' ji. ");
INSERT INTO wob_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Ʋ jɛɛ Piɛi nɛ 'wooa'. Ʋ ‑gbʋn ɔ ja 'pepe 'sʋ ʋ 'na : ‑Mɔ ‑nɔ, ‑ɩn ‑ke Sesi ‑wlʋa Nasarɛtɩ ‑ta na' ‑ke. ");
INSERT INTO wob_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","'Kaa Piɛi‑ ‑too' ɔ 'na : 'Ɩn se ɔ juo‑ 'de ! Dɛ aa 'tmʋa 'maa 'wɔɛn 'mii. Ɔ 'da kan' 'sʋ ɔ 'wlʋ 'o ‑gbɛin\" 'mɛ, ɔ \"siɛ \"kpae' 'sʋ \"sʋn ‑sro'. ");
INSERT INTO wob_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Dbonʋnynɔkpao' 'jee ɔ \"jriɛ‑ ke'wlɛ, ʋ wluɛ nyʋ ‑nɩa 'de ʋ ‑pʋn\" ‑pee, ʋ 'na : \"Ju ‑nɔ, ʋʋa' due' ‑o. 'Sʋ Piɛi 'na : 'Ɩn se ɔ juo‑. ");
INSERT INTO wob_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Ɛ fɔan 'o mu ‑paii‑ ka 'sʋ, nyʋ ‑nɩa 'mʋa‑ wluɛ Piɛi ‑pee ʋʋ 'na : Tɔ' ‑o, ‑ɩn ‑nɩɛ nyʋ ‑nʋ 'a due' ‑o ‑cɛɛn'‑, dɛ‑nʋɛ' ‑ɩn ‑nɩɛ Galilei ‑o ‑ke. ");
INSERT INTO wob_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","'Sʋ Piɛi ‑teɛ ‑snɛɛa' ‑pʋn\", ɔɔ bla', ɔ 'na : ‑Bo 'ɩn 'tmʋ sɩ ɛ, Kea nʋ 'ʋn dɛ \"jrii. \"Ju aoa \"sia 'nynɩ 'mʋa‑, 'ɩn se ɔ juo‑ ‑cɛɛn'‑. ");
INSERT INTO wob_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Ɛ \"si 'de ɔ 'wɔn mɛ 'sʋ sʋn\" 'a kpɛ 'sɔɔn ‑nɛ je ‑sro'. 'Sʋ Piɛi po ɛ dɛ Sesi 'tmʋa ‑kwlʋ o, ɔ wlu' ka : nɔ\" ‑tɩ sʋn\" 'je ‑sro' kpɛ 'sɔɔn ɛ, ‑ma muɛ wlua' kpɛ taan ‑ɩn ‑je nʋ ‑ɩn se 'ʋn juo‑. Ɔ naa ɛ tɔ' \"kpei 'sʋ ɔ ‑teɛ ‑fɩn\" 'a ‑pʋn\". ");
INSERT INTO wob_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","‑Sɔn' ‑sɩan' ‑klae\" pɛɛn, 'sraa ‑saʋn 'a klae\" o, nyʋ‑cɔɩn' ‑wi\" o, kɛ' wɔ‑saʋn o, ‑gbajeʋn 'kɩɩɛn \"jrui ‑wɛe ʋʋ po wlu ‑tadue. Ʋʋ ‑koa' Sesi saan' 'sʋ, ʋʋ kpɔ' ‑wɛe ʋʋ \"nyɩ ɔ Pilatɩ. ");
INSERT INTO wob_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Pilatɩ ‑tee' ɔ i ɔ 'na : ‑Ɩn ‑nɩɛ Suifʋ‑wi\" 'a 'Beɔ ‑oo ? ‑wɛe Sesi 'na : Ɛ mɛ ‑ɩn ‑tmʋa 'o. ");
INSERT INTO wob_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","'Sraa ‑saʋn 'a klae\" ‑tu\" ɔ sɩ ‑tɩ ‑tuu\"‑tuu \"kpei‑. ");
INSERT INTO wob_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","‑Wɛe Pilatɩ ‑tee' ɔ i ke'wlɛ ɔ 'na : ‑Ɩn se 'bɛɛ‑ ‑ɩn ‑je wluu‑ ? ‑Maa' 'je dɩ \"klein ʋʋa ‑tu\" a ‑ʋn \"kpei‑ ‑taa ? ");
INSERT INTO wob_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","'Kaa Sesi se dɛ jrɛ' 'tmʋ 'bode. ‑Mɛ ɛɛ' dɛ tu \"maa Pilatɩ tai'. ");
INSERT INTO wob_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","'De ‑kɔ' \"o ‑kɔ' ‑sɔn ɛ, Pilatɩ a \"siiɛ ‑kaso 'dii due' i, ‑jɔ nyʋ ‑kwea de nɩai\" ɛ. ");
INSERT INTO wob_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","'De \"ju due' ‑nɩ ‑kaso 'di. Ɔɔ' 'nynɩ ‑nɩ Barabasɩ. Ɔ ke ɔ \"dɛi‑wi\" ‑toa 'blʋajei wɔn o ‑wɛe ‑ʋʋ ‑dba \"ku ‑kli 'a 'kpa nɔ\" ke‑. ");
INSERT INTO wob_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Nyʋ ‑wee' 'kpa 'de Pilatɩ ‑pʋn\" ‑wɛe nyʋ ‑kwea de 'na : Dɛ ‑ma nʋa 'de ‑kɔ' ‑sɔn see ɛ, ɛmɛ ‑aa ‑tee' i ‑ɩn ‑je nʋ. ");
INSERT INTO wob_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Pilatɩ wlu ʋʋpʋ ‑pee ɔ 'na : Ao nɩɛ \"i 'ɩn 'je Suifʋ‑wi\" 'a 'Beɔ i \"sii‑ ? ");
INSERT INTO wob_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","'De ka 'sraa ‑saʋn 'a klae\" a nʋa Sesi \"cɛi o ɛ, ‑wɛe ʋʋ to ɔ 'e 'de ɔ 'jea 'mɛ ɛ, ɔ 'je kan' 'mɛ 'pepe. ");
INSERT INTO wob_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","'Kaa 'sraa ‑saʋn 'a klae\" paa 'blʋa‑ ‑wee' bʋ ‑sɔn ‑wɛe ʋʋ 'je Barabasɩ 'a i \"sia' Pilatɩ i ‑tee'‑. ");
INSERT INTO wob_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Pilatɩ ‑teeɛ' nyʋ ‑gbaea' i ke'wlɛ ɔ 'na : Dɛ ao nɩ \"i 'ɩn 'je \"ju aoa 'daa Suifʋ‑wi\" 'a 'Beɔ \"jrii nʋ 'jaa‑ ? ");
INSERT INTO wob_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Ʋʋ ‑wee' \"wɔɔ' ‑tadue, ʋʋ 'na : ‑Ɩn koɔ 'o tu ‑kwlɩ\". ");
INSERT INTO wob_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","'De Pilatɩ ‑tee' ʋʋpʋ i ɔ 'na : Dɛsaʋn ‑jɛ wɛ‑ ɔ nʋ ɛ‑ ? 'Kaa ʋʋpʋ \"wɔɔ‑ ke'wlɛ ɛ je ɛ \"kpei ‑tie\" cɛn ʋʋ 'na : ‑Ɩn koɔ 'o tu ‑kwlɩ\" ! ");
INSERT INTO wob_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Pilatɩ nɩa \"i ɔ 'jea nyʋ ‑kwea de 'di wɔn nmɔɔ ɛ, ɔ \"siiɛ Barabasɩ i ‑wɛe ɔ 'tmʋʋ‑ \"soa ʋʋ bla Sesi, ‑wɛe ɔ to ɔ 'e, 'de ɔ 'je 'o tu ‑kwlɩ\" kɔɔɛ‑. ");
INSERT INTO wob_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","\"Soa‑wi\" kpa Sesi 'de ‑gbɛin\" 'a ‑kwea'‑, 'de 'blʋajei o ‑gbu\" 'di ‑wɛe ʋʋ 'da \"soa ‑wee' \"klein. ");
INSERT INTO wob_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","\"Soa‑wi\" a wlɔɔ' ‑wɛe ʋʋ pɔɔ 'beɔbai\" ‑saan ‑tɔɔn' ‑tɔɔn 'ʋn, ʋʋ dba \"wifan due' ʋʋ ‑tuɔ\" \"jru. ");
INSERT INTO wob_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","‑Wɛe ʋʋ ‑te ɔɔ' ‑gbleea' ‑pʋn\" ʋʋa nʋ : ‑A 'snɛ ! Suifʋ‑wi\" 'a 'beɔ ! ");
INSERT INTO wob_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","'Sʋ ʋʋ blɔ ‑gblokpau \"jru, ʋʋa wlɔn tɔn \"jri, ʋʋa \"siiɛ 'kɔi‑ i, ʋʋa tba \"jua‑ i 'de ɔ \"juɔi. ");
INSERT INTO wob_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Ʋʋ ‑kɔa' ɔɔ' wlaa' kan' 'sʋ ʋʋ ‑sɔ \"bai ‑saan ‑tɔɔn 'ʋn, ʋʋ pɔɔ ɔɔ' dɩ 'ʋn. ‑Wɛe ʋʋ kpɔ 'de tu ‑kwlɩ\" kɔa' 'de \"kpae'. ");
INSERT INTO wob_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Sirɛnɩi due' nyʋ a 'daa‑ Simɔ ɛ, Alɛsandrɩ ke Rifisɩ \"bo, ‑ɔɔ ‑wlʋa 'de ‑kle ɛ, ɔ cɛɛn 'mʋa‑ de. \"Soa‑wi\" ‑te' ɔ ‑klaan\" \"kpei, ʋʋpʋ ‑tu\" ɔ Sesi 'a 'mɛtu \"kpei. ");
INSERT INTO wob_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","‑Wɛe ʋʋ kpa Sesi 'e ‑tajrɔ nyʋ a 'daa‑ Gogota a. Ɛ 'de mɛ ‑nɩ \"jru kpa\" 'a ‑ta. ");
INSERT INTO wob_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Ʋʋ bee nmɔ ‑saan ke sii\" nyʋa 'daa 'mii‑ 'a \"ni o, ɛmɛ ʋʋ \"nyɩɔ 'na ‑tɩ, 'kaa ɔ se 'wɔn ɔ se ɛ 'na. ");
INSERT INTO wob_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","'Demɔ ʋʋ koɔ 'o tu ‑kwlɩ\". Ʋʋ ‑seea' ɔɔ' 'ʋnpaadɩ 'ʋn 'de ʋʋ po soa' \"jɛi ‑wɛe dɛ jrɔ' 'jea kpa due 'due 'de ʋʋ 'je ɛ juo‑. ");
INSERT INTO wob_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","‑Klae\" jrʋ ‑gbao mɛ ʋʋ kɔ Sesi 'de tu ‑kwlɩ\". ");
INSERT INTO wob_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Dɛ ‑ɛ ‑jea ɔɔ' 'mɛa a, ɛ 'crɩɩɛ' 'bo tufɔ ‑saan\" \"kpei. Dɛ ‑crɩɩa' ɛ ka : Suifʋ‑wi\" 'a Tʋ\"bo. ");
INSERT INTO wob_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Ʋʋ kɔ dɛsaʋnʋʋn 'sɔɔn jrʋ' 'bo tu ‑kwlɩ\" ‑ke, due' 'a tu 'bɔɔ‑ 'de Sesi 'a dianfɔ o, due' 'a tu 'bɔɔ‑ 'de ɔɔ' kʋaanfɔ o. ");
INSERT INTO wob_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","'Kamɔ Kea 'a wlu 'da, ɛ 'naa : Nyʋ ‑sroo ɔ dɛsaʋnʋʋn \"i. ");
INSERT INTO wob_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","‑Je ‑siʋn a ‑fun\" a \"jru ʋʋa ‑cree\" ɔ', ‑wɛe ʋʋa wlu ɔ ‑pee ʋʋ 'na : ‑Ɩɩn'‑ ! ‑Mɔ ‑ɔ ‑na ‑ɔ ‑je Kea ‑gbu klaa\" \"jɛi‑ ‑gba', ‑wɛe ‑ɔ ‑je ɛ po 'de 'wɩ taan 'di ɛ, ");
INSERT INTO wob_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","‑ɩn ‑pʋʋ' ‑ma ‑cɛ\" la 'e, ‑ɩn ‑wlʋ 'o tu ‑kwlɩ\", ‑ɩn ‑je i \"si ! ");
INSERT INTO wob_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","'Kamɔ 'sraa ‑saʋn 'a klae\" ke kɛ' wɔ‑sanyʋ a wlaa Sesi ‑ke ‑wɛe ʋʋa wlu ba ‑pee ka : Ɔ 'pʋʋ nyʋ jrʋ' ‑wɛe ɔ se ɔɔ' ‑cɛ\" 'ɛ 'pʋʋa' 'bɛɛ‑ ! ");
INSERT INTO wob_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Kea 'a 'o ‑tei Israɛ 'ɛ Tʋ\"bo, \"sii la 'ja, ɔ 'je 'o tu ‑kwlɩ\" 'wlʋ ! ‑Bo ‑a ‑jee' ‑mɛ \"jriɛ‑ ‑wɛe ‑a ‑je ɔɔ' ‑tɩ' tɔ' 'ʋn 'je. Nyʋ ‑kɔɔa 'o tu ‑kwlɩ\" 'bo Sesi ‑pʋn\" ɛ, ʋʋa wlɔɔ' ‑ke. ");
INSERT INTO wob_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","'Jrʋ‑gbao 'sʋ kwie kpʋn' 'de 'blʋa‑ ‑wee' \"klein \"kpei mamaʋ 'sʋ ɛ je ‑kwie\" jrʋ‑gbao nyni. ");
INSERT INTO wob_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Dɛ ‑mua' ‑kwie\" jrʋ‑gbao o 'sʋ Sesi \"wɔɔ' 'bo tu ‑kwlɩ\" ɔ 'na : Eloi, Eloi, lama sabatani ? Ɛ 'de mɛ ‑nɩ : 'Ma Kea, 'ma Kea, dɛɛ‑tɩ ɛ ‑sa 'ʋn \"jriɛ‑ ‑pʋn\" ɛ‑ ? ");
INSERT INTO wob_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Nyʋ ‑nɩa 'mʋa 'a jrʋ' 'wɔan ɔɔ' wlu 'sʋ, ʋʋ 'na : Ao po doin\" i, ɔɔ 'da Eli la ! ");
INSERT INTO wob_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","‑Wɛe ʋʋa' due' kpa plea', ɔ crooɛ fuu' ‑gblokpaui\", ɔ blɛɛ 'e ‑koonmɔ o i ɔ \"nyɩɛ Sesi ɔ 'je ɛ 'na. 'De ɔ 'na : Ao 'bɔ, ‑bo Eli 'bɛɛ‑ ɔɔ' tu ‑kwlɩ\" ‑saa' ‑wɛe ɔ 'je ɔ i \"sii‑ ɛ, ‑aa muɛ 'o 'jea' kaan ! ");
INSERT INTO wob_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","'Kaa Sesi \"wɔa kpleiin 'sʋ ɔɔ' feeɛ' blu 'e 'wɛ‑. ");
INSERT INTO wob_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","\"Wliɛfɔ klaa\" ‑peea' 'de Kea ‑gbu klaa\" 'di 'wlʋɛ 'fɔ 'sɔɔn, ɛ je 'de \"jɛi 'wlʋ, ɛ je i \"si 'de ‑sɔn. ");
INSERT INTO wob_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Jra' jei due' ‑nyna i 'de Sesi \"juɔi, ɔ ‑gbʋan ɔɔ' \"wɔsʋn ke 'mɛsʋn ja 'sʋ ɛ, ɔ 'na : \"Ju ‑nɔ, Kea 'a \"Ju 'a ‑cɛ\" 'kpa ‑o ‑cɛɛn'‑. ");
INSERT INTO wob_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","'Nynʋkpae' jrʋ' ‑nɩ 'e ‑ʋʋ ‑tɛɛn o ‑ʋʋa ‑gbʋn 'e ‑ke. 'De ʋʋ \"klu 'demɔ Madi ‑wlʋa Madala nɩ‑, 'demɔ Sakɩ ‑saan\"‑ ke Sosɩ de Madi nɩ‑, 'demɔ Salome nɩ‑. ");
INSERT INTO wob_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","‑Ta Sesi nɩɩa Galile ʋʋ ke ɔɔ na' see, ʋʋa jea ɔ sʋn o po. 'Nynʋkpae' ‑tuu\"‑tuu jrʋ' ‑nɩ 'o ‑ke, ‑wɛe ʋʋ ‑ke ɔ ji Selisalɛm. ");
INSERT INTO wob_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","‑Fli bla a, ɛ nɩɛ dɩnmaewɩ ‑o, ɛ 'de mɛ ‑nɩ ‑kwlewɩ 'a ‑kwie\". ");
INSERT INTO wob_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","'Sʋ Sosɛʋ ‑wlʋa Arimate ji'. Ɔ nɩɛ ‑gbajeʋn 'a due' ‑o ‑ke. Nyʋ ‑wee' \"klein a ‑teɛ' ɔɔ' ni'. Ɔɔ fuɛ Kea 'a tʋ\"bodɛ ‑ke. Ɔ poɛ 'e pɛe‑ ɔ je Sesi 'a \"ku i ‑teea' mu 'de Pilatɩ o. ");
INSERT INTO wob_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Sesi 'a 'mɛa' ‑too\"‑ \"maa Pilatɩ tai'. Ɔ 'da jra' jei 'mɛ ɔ ‑tee' ɔ i ‑wɛe ‑bo Sesi ‑too\"‑ 'mɛa' a, 'de ɔ 'jɩ juo‑. ");
INSERT INTO wob_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Ɔ 'wɔan jra' jei 'a wlu ɛ, ɔ 'na Sosɛʋ \"duo Sesi 'a \"ku 'ʋn. ");
INSERT INTO wob_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Sosɛʋ ‑tɩɛn' tae' plu due' ɛmɛ ɔ \"fian Sesi 'a \"ku ɔ ‑sa 'o tu ‑kwlɩ\" \"jrui, ‑wɛe ɔ ‑teɔ' i 'de 'soa 'a ‑kwlewɔn ʋʋ \"blua 'di. Ɔ klin o \"soukpo klaa\" due', ɔ kaan 'o ‑gbaɩn' \"wɔin. ");
INSERT INTO wob_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Madi ‑wlʋa Madala ke Madi ‑nɩa Sosɩ de ‑gbʋɛn ‑ta Sesi ‑teea i ja. ");
INSERT INTO wob_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","‑Kwlewɩ ‑sia' 'sʋ, Madi ‑wlʋa Madala ke Sakɩ de Madi ke Salome ‑tɩɛn' ‑dai'klɔcna, ʋʋ 'je ɛ Sesi 'a \"ku \"jru 'wla. ");
INSERT INTO wob_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","'Dɔɔ 'ɔ \"i‑saawɩ 'a ‑klae\" pɛɛn, 'jrʋ 'a 'kwlawlʋ nɔ\" ɛ, ʋʋ ‑cnuuɛ 'de ‑gbaɩn' \"kpei. ");
INSERT INTO wob_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Ʋʋa' 'sʋ a ‑teeɛ' ba i, ʋʋ 'na : ‑Ɔ ‑je \"soukpo 'bo ‑gbaɩn' \"wɔin ‑sa ‑ɔ ‑je ‑a ‑nyɩ\" ɛ‑ ? ");
INSERT INTO wob_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","'Kaa ‑ta ʋʋa ‑gbʋan 'e mu ɛ, ‑mɛ \"sou klaa\" ‑nɛ klin 'o, ɛ je 'fɔ due' o ‑te. ");
INSERT INTO wob_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Ʋʋ pa 'de ‑gbaɩn' 'di, 'sʋ ʋʋ jɛɛ ‑kooa\" i ‑tɔo due' ‑ɔ ‑te i 'de dianfɔ o. Ɔ paa \"baiplu \"puu'‑ 'ʋn. 'Sʋ faʋn 'kpa 'e ʋʋpʋ 'ʋn 'ɛ. ");
INSERT INTO wob_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","'De ɔ wlu ʋʋpʋ ‑pee ɔ 'na : Faʋn 'bo ao nʋɛ ! 'Ɩn 'je kan' 'mɛ Sesi ‑wlʋa Nasarɛtɩ ‑wɛe ‑ɔ ‑kɔɔa 'bo tu ‑kwlɩ\" mɔ aoa ‑pɔn i. 'Kaa ɔ sɔn \"kunyɩɔ', ɔ se ‑ta nɩ‑. Ao ‑gbʋn 'nɔ nyʋ po ɔ 'de ɛ. ");
INSERT INTO wob_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Ao mu ao 'je ɔɔ' klai\" nynuu ke Piɛi 'tmʋʋ‑. Ɔɔ fuo aopʋ‑ 'mɛ 'de Galile. 'Bomɔ ao 'je ɔ \"jriɛ‑ 'jee‑ ka ɔ 'tmʋɛ 'de ɛ. ");
INSERT INTO wob_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Ʋʋ 'wɔan wlu ‑nɩ 'sʋ ɛ, ʋʋ ‑ka' wɔn, tai' \"maa ʋʋpʋ 'mɛ, ʋʋa' dɩ a crɛ'. Ʋʋ 'wlʋa 'e ‑gbaɩn' 'di 'sʋ, ʋʋ ‑gbu\" ɛ plea' ʋʋa jea mu, ʋʋ se nyʋ dɛ jrɛ' 'tmʋʋ‑ 'de faʋn ‑a nʋa ʋʋpʋ 'a ‑tɩ' 'ʋn. ");
INSERT INTO wob_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Sesi sɔan \"kunyɩɔ' 'dɔɔ 'ɔ \"i‑saawɩ 'a ‑klae\" pɛɛn, Madi ‑wlʋa Madala ɔ ‑sa ‑siisaɩn ‑mɛ\" 'sɔn 'ʋn ʋmʋ ɔ to ɔɔ' ‑cɛi\" tɛin\". ");
INSERT INTO wob_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Ʋmʋ ‑mu' ‑ʋ po ɔɔ' klai\" nynuu \"kuan. ‑Ta ʋa mua, ‑mɛ ʋʋ ‑wee' \"kaeɛ \"jrii, ɔɔ' 'kwɛ‑ pa ‑tɩ 'ʋn. ");
INSERT INTO wob_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Ka Sesi sɔan ‑klu', ɔ nɩa 'kmʋ ‑wɛe ʋ 'je ɔ, ʋ 'tmʋ ɛ. Ʋʋ ‑wee' 'wɔn ɛ, 'kaa ʋʋ se ɛ tɔ' 'ʋn 'je. ");
INSERT INTO wob_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Ɛ 'wlʋa 'mʋa‑ a, Sesi to ɔɔ' ‑cɛ\" 'mɛ ka jrɔ' ka 'de ɔɔ' klai\" nynuu 'sɔɔn ‑ʋʋa mua ‑gbei\" ‑pee. ");
INSERT INTO wob_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Ʋʋ jia de ʋʋ 'tmʋʋa nyʋ ‑sia 'o ɛ, ʋʋ se ɛ tɔ' 'ʋn 'je ‑ke. ");
INSERT INTO wob_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Ɛ 'wlʋa 'o mu ɛ, Sesi toɛ ɔɔ' ‑cɛ\" klai\" nynuu ‑nɩa ‑puue 'jɔ due' \"i, ‑mɛ ʋʋ nɩɛ dɛ diia'. ‑Wɛe ɔ ‑cɛ' ʋʋpʋ \"bli 'de ʋʋa' ‑maa' ‑te' dɛ ‑kwlɩ\" ke ʋʋa' pɛe 'a \"i \"ikmuu ‑tɩ 'ʋn, dɛ‑nʋɛ' nyʋ ‑ʋʋ poa ʋʋpʋ ɔɔ' \"kunyɩɔ' sɔn ‑tɩ 'a \"kuan a, ʋʋ se ʋʋpʋ 'a wlu tɔ' 'ʋn 'je. ");
INSERT INTO wob_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","‑Wɛe ɔ 'na : Ao mu 'blʋa‑ ‑wee' \"klein \"kpei‑, ao 'je 'ma ‑pɔia\" ‑tɩ 'tmʋ 'de nyiɔ ‑wee' \"klein ‑pee. ");
INSERT INTO wob_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Nyɔ ‑ɔɔ mu ɛ tɔ' 'ʋn 'jea', ‑wɛe ‑ɔɔ mua \"ni \"jru poa 'a, ɔɔ muɛ 'pʋʋa'. 'Kaa nyɔ se ɛ tɔ' 'ʋn 'je ɛ, 'pee a muɛ ɔ kpʋn 'a. ");
INSERT INTO wob_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","'De nyʋ ‑a mua ɛ tɔ' 'ʋn 'jea' a, ka Kea 'a \"ikmaa' ke ʋʋ na dɩ ‑ɩa muɛ toa', ɩ ka : ʋʋa muɛ ‑siisaɩn i nʋa' 'de 'ma 'nynɩ 'ʋn, ʋʋa muɛ wlu dee poa'. ");
INSERT INTO wob_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Ʋʋa muɛ sɛn 'kwa i kpʋan', nyʋa muɛ diɛ dɛ o poa' ʋʋ 'je ʋʋpʋ \"nyɩ, 'kaa dɛ‑saan\" ka se ʋʋpʋ nʋ i. Ʋʋa muɛ 'wɛ‑nʋʋ sʋn \"jru ‑tea' ʋʋa' 'wɛ‑ 'je 'bɔ. ");
INSERT INTO wob_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Tʋ\"bo Sesi ‑kɔa' ʋʋpʋ 'a ‑tɩ' ‑pee 'tmʋa' kan' 'sʋ ɛ, ɔ sɔn 'ʋn 'ɛ, ɔ muɛ jaʋn 'di. ‑Wɛe ɔ ‑te i 'de Kea 'a dianfɔ o. ");
INSERT INTO wob_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Klai\" nynuu muɛ Sesi 'a ‑pɔia\" ‑tɩ 'tmʋa' ‑ta ‑wee' \"klein. Tʋ\"bo a siɛ ʋʋpʋ o 'de dboi\". Ka wlu ʋʋa 'tmʋa nɩa tɔ' ‑tɩ ɛ, ɛɛ jea ɛɛ' sʋn to 'de nyʋ 'pʋʋjrii' ʋʋa nʋa 'ʋn.");
INSERT INTO wob_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Nyʋ ‑tuu\"‑tuu ‑tɩn' dɩ ‑nʋʋa 'de ‑a \"kwlu ‑ta ɩa' 'crɩa' i, ");
INSERT INTO wob_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","dɛ‑nʋɛ' ʋʋ 'wɔn ɩ 'de nyʋ ‑ʋʋa ‑cɛ\" 'kpa 'jee ɩ \"jriɛ‑ sese ‑wɛe ‑ʋʋ ‑tea Kea 'a ‑pɔia\" ‑tɩ 'tmʋa 'a ‑tea' 'wɔn. ");
INSERT INTO wob_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Ɛmɛ‑tɩ 'mɔ ‑ke ɛ, 'ɩn ‑pɔn ɩa' ‑gbɔo ‑tea' i kpɩɩn‑ ‑wɛe 'ɩn ‑tee ɩ wɔ 'ma po ɩ 'de 'sbɛ 'di 'de ‑ma ‑tɩ' 'ʋn Teofi ni' wɔn nɩ i. ");
INSERT INTO wob_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","'Ma nʋ ɛɛ' dɛ tu 'mɛ ‑wɛe ka dɩ \"klein ʋʋ tɔɔa ‑ʋn ɩ nɩa tɔ' ‑tɩ ɛ, ‑ɩn ‑je ɛ juo. ");
INSERT INTO wob_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Nɔ\" ‑ɛ 'di Erodɩ nɩɩa Suide 'a 'beɔ ɛ, ɛmɛ \"ju due' nyʋ a 'daa‑ Sakali nɩɩ Kea 'a 'sraa ‑sai. Ɔ nɩɛ 'sraa ‑sai Abia 'a 'tma ‑o. Ɔɔ' 'nynɔ 'wlʋɛ 'e Aarɔn 'ɔ \"ji 'di, ʋa' 'nynɩ ‑nɩ Elisabɛtɩ. ");
INSERT INTO wob_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Nyʋ 'sɔɔn ‑nʋ, ʋʋa' kplɩn 'srɛi\" 'bo Kea \"juɔi. Ʋʋa 'jeɛ ɛɛ' kɛ' ‑wee' \"klein wɔn ʋʋ se ‑pɩɩɔn\" ‑pʋn\" nɩ‑. ");
INSERT INTO wob_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","'Kaa ʋʋ se \"ju 'ble, dɛ‑nʋɛ' Elisabɛtɩ siɛ ‑sran. 'De ka ʋʋ nɩa 'sɔɔn, ʋʋ ‑wee' 'a ‑sɩn cɛn \"jri \"kpei ‑tie\" \"ju 'wlʋ ‑tɩ. ");
INSERT INTO wob_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","'Wɩ jrɛ' o 'sʋ, Sakali nɩɛ ɔɔ' 'sraa ‑sadbo nʋa' 'bo Kea \"juɔi, dɛ‑nʋɛ' nyʋ ‑ke ɔ nɩa kpɔi\" ɛ, ɔmɔ ‑te' 'o. ");
INSERT INTO wob_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Soa' 'sraa ‑saʋn a poa \"jɛi 'de ʋʋpʋ \"klu see ɛ, ‑wɛe nyɔ ‑jea ‑dai'klɔ \"jri po 'de Kea ‑gbu klaa\" 'di ʋʋa juɔ ɛ, ɛmɛ ʋʋ po \"jɛi. 'Sʋ Sakali mɔ ɛ 'bɔɔ‑ \"i. ");
INSERT INTO wob_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","‑Dai'klɔ \"jri po nɔ\" ɔ, nyiɔpʋ‑ ‑kwɛa de 'de \"kpae ɛ, ʋʋa baeɛ Kea. ");
INSERT INTO wob_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Sakali nɩɩa -dai'klɔ \"jri poa' 'sʋ ɔ 'jeeɛ Kea 'a \"soai due' \"jriɛ‑ ‑ɔ nyna i 'de ‑dai'klɔ \"jri poɩn' 'a dianfɔ o. ");
INSERT INTO wob_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Sakali 'jee ɔ \"jriɛ‑ 'sʋ, dɛ wɔɔ 'dii, faʋn a nʋɔ'. ");
INSERT INTO wob_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","'Kaa Kea 'a \"soai wlu' 'de ɔ ‑pee, ɔ 'na : Sakali, faʋn 'bo ‑ʋn ‑nʋɛ, dɛ‑nʋɛ' Kea kpʋn ‑ma baewlu 'mɛ. ‑Ma 'nynɔ Elisabɛtɩ a muɛ ‑ʋn \"junmɔu ju ‑pee 'wlʋa', ‑wɛe ‑ɩn ‑je ɔ San 'daa‑. ");
INSERT INTO wob_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Ɔɔ' 'wlʋa a muɛ ‑ma 'mʋa‑ ‑tɩ klaa\" nɩa', ‑wɛe nyʋ ‑tuu\"‑tuu 'je ɔɔ' 'wlʋ ‑pɔi po 'de 'mʋa‑ 'ʋn ‑ke. ");
INSERT INTO wob_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Ɔɔ muɛ dɛwɔn nɩa' 'de Kea \"jri 'de. Ɔ se \"kaenmɔ ke 'dɩɩnmɔ 'nai. Ɔ muɛ 'de ɔ de 'a \"kwli 'di sia 'sʋ Kea 'a ‑Suu 'je ɔ 'ʋn \"ji. ");
INSERT INTO wob_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Ɔɔ muɛ Israɛ‑kɔʋn ‑tuu\"‑tuu 'a \"jru 'e ʋʋa' Tʋ\"bo Kea o \"biia'. ");
INSERT INTO wob_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Ɔɔ muɛ Tʋ\"bo 'a weepoi nɩa'. Ka Kea 'a \"ikmaa' ke ɛɛ' ‑Suu nɩa 'e Eli 'ʋn 'de ɛ, 'kamɔ ɩa mu 'de ɔ 'ʋn nɩa' ‑ke, ‑wɛe ɔ 'je ɛ nʋ 'de \"nynuu‑ ke ʋʋ \"bo ‑wi\" 'a wlu 'je due' nɩ, nyʋ ‑kua \"jru 'je tɔ'di 'kpa ka \"i \"isrɛnyʋ nɩa, 'de ɔ 'je Tʋ\"bo 'a 'cɛ‑wi\" kpɔi\" ‑tee. ");
INSERT INTO wob_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","'Sʋ Sakali ‑teeɛ' Kea 'a \"soai i ɔ 'na : Ka 'ɩn 'je dɛ ‑ɩn ‑tmʋa 'mʋa 'a tɔ' 'ʋn 'jesʋn nʋ ɛ‑ ? Dɛ‑nʋɛ' 'mɔ 'kpa ‑kea\", 'de 'ma 'nynɔ foo\" 'sʋ ‑mʋ 'a \"ju 'wlʋ ‑sʋn ‑si'. ");
INSERT INTO wob_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","'Sʋ Kea 'a \"soai ‑sɛ \"kpei ɔ 'na : 'Mɔ ‑nɩ Gabliɛ, 'ɩn nɩɛ 'o Kea ‑pʋn\" ‑wɛe 'ma nʋʋ ɛ \"juɔi, ɛmɛ ‑dbo' 'ʋn ‑wɛe 'ɩn ji ‑ʋn ‑pɔia\" ‑tɩ ‑nɩ 'tmʋa'. ");
INSERT INTO wob_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","'Kaa dɛ 'ɩn 'tmʋa ‑ɩn se ɛ tɔ' 'ʋn 'je. 'De ‑mɛ 'kamɔ ɩa' wlu tu a mu 'o nynia' 'de nɔ\" ‑ɛ ‑tu\" 'a 'di, ɛmɛ ‑tɩ ‑ma mu \"muu nɩa' ‑ɩn se wlu i mamaʋ 'sʋ dɛ ‑jɛɛa ɩa' \"jri \"kpae' poa' a. ");
INSERT INTO wob_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","‑Ta ɛɛ nʋʋa kan' a ‑mɛ tai' \"maa' nyʋ ‑ʋʋa fua Sakali 'mɛ 'de \"kpae, dɛ‑nʋɛ' ɔ ‑kwle 'e -dai'klɔ \"jri po 'ɩn 'mɛ. ");
INSERT INTO wob_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","'Kaa ‑ta ɔɔ \"sia \"kpae', ɔ se wlu 'ble, ɔɔ 'daa‑ ʋʋpʋ \"i, 'sʋ ʋʋ 'wɔɛn 'mii ka dɛ nʋʋɔ \"jrii 'de -dai'klɔ \"jri po 'ɩn ɛ. ");
INSERT INTO wob_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Ɔɔ' ‑nɛ 'sraa ‑sadbo 'a nɔ\" 'wlʋa 'o ‑jei\" 'sʋ ɛ, ɔ muɛ 'de ɔ o ‑kwlɔ de. ");
INSERT INTO wob_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Ɛ nʋa 'wɩ pla 'sʋ, ɔɔ' 'nynɔ Elisabɛtɩ a 'tɛn \"kwli i. Ʋ 'jea kan' 'sʋ, ʋ ‑tuɛ\" ʋa' ‑cɛ\" i 'de 'cɩ ‑mm\" 'di ‑wɛe ʋ wlu 'de ʋa' ‑cɛ\" 'ʋn ʋ 'na : ");
INSERT INTO wob_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","‑Jɛ ‑mɛ Tʋ\"bo 'a nʋʋ ‑tɩ ‑o ! Ɛ 'jeɛ 'ma wɛe‑, ‑wɛe ɛ po 'ma ‑tɩ' ‑kwlʋ o, 'de ɛ ‑sa 'ʋn ‑tɩn' \"juɔi 'de nyʋ ‑wee' \"jri 'de. ");
INSERT INTO wob_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Elisabɛtɩ 'a \"kwli nʋa 'cʋɩ ‑mɛɛo\"‑ 'sʋ, Kea dbo ɛɛ' \"soai Gabliɛ 'mɛ ke'wlɛ 'de Galile 'a ‑kwlɔ due' nyʋ a 'daa‑ Nasarɛtɩ 'di. ");
INSERT INTO wob_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Ɛ dboɔ' 'de 'nynɩa ‑tɔo due' ‑ʋ ‑tea \"ju due' nyʋ a 'daa‑ Soseʋ 'a 'nynɩ 'ʋn o. Ɔ nɩɛ 'beɔ Dafidɩ 'a ‑gbu\" ‑sɔn nyɔ ‑o. 'Nynɩa ‑tɔo ‑nʋ 'a 'nynɩ ‑nɩ Madi. ");
INSERT INTO wob_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Kea 'a \"soai pa 'de ʋ o ‑gbu\" 'di, ‑wɛe ɔ pʋ 'je wlu o ɔ 'na : Madi, 'mɔ ‑je aʋn, amɔ ‑jea 'saaʋn ɛ, Tʋ\"bo Kea ke a na'. ");
INSERT INTO wob_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","'Sʋ tai' \"maa' Madi 'mɛ 'de 'jewlu ‑nɛ 'ɛ ‑tɩ' 'ʋn, ʋa ‑teeɛ' ʋa' ‑cɛ\" i ʋ 'na : 'Jewlu ‑nɛ ‑mɛ 'de 'a 'nynɩ ‑wɛ‑ ‑sɩan ka‑ ? ");
INSERT INTO wob_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","‑Wɛe Kea 'a \"soai 'na : Madi, faʋn 'bɔ aa' nʋ ‑tɩ, dɛ‑nʋɛ' Kea nʋa ʋn 'saa 'ʋn \"jri i. ");
INSERT INTO wob_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","A ‑gbʋn 'nɔ aa muɛ \"kwli 'blea', ‑wɛe a 'je \"junmɔu 'wlʋ 'de a 'je ɔ Sesi‑nynɩ ‑tuu\"‑. ");
INSERT INTO wob_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Ɔɔ muɛ nyɔ klaa\" nɩa' ‑wɛe nyʋ 'je ɔ Kea ‑nɩa 'e jaʋn 'di 'a \"ju 'daa‑. Tʋ\"bo Kea a mu ɔ 'beɔ 'ʋn nʋa' ka ɔ 'mɩa Dafidɩ nɩa tɛin\" 'de ɛ, ");
INSERT INTO wob_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","‑wɛe ɔ 'je 'nynɩ 'wlʋ jeejee 'de Israɛ‑nyʋ \"jru o. Ɔɔ' 'nynɩ 'wlʋa' se \"ti ‑ta 'blei. ");
INSERT INTO wob_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","'Sʋ Madi wlu' 'de Kea 'a \"soai ‑pee, ʋ 'na : Ka ‑mɛ 'ɛ dɛ tu 'je 'o nynisʋn nʋ ɛ‑ ? Dɛ‑nʋɛ' 'ɩn se \"junmɔu juo due'. ");
INSERT INTO wob_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","'Sʋ Kea 'a \"soai 'na : Kea 'a ‑Suu 'a \"ikmaa' a muɛ 'de a 'ʋn jia' 'de Kea ‑nɩa 'e jaʋn 'a 'tee te \"i 'a ‑fli 'je aʋn \"kpei ‑cri\", ɛmɛ ‑tɩ \"ju ‑kwɛai 'pepe aa mua 'wlʋa' a, nyʋ a mu ɔ Kea 'a \"Ju 'daa. ");
INSERT INTO wob_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","A ‑gbʋn 'nɔ, aa' de'di Elisabɛtɩ nyʋ a 'daa ‑sran ‑sie nynɔkpao' ʋmʋ ‑blea 'o ʋʋa' ‑kea\" ‑kwli' ɛɛ' 'cʋɩ ‑mɛɛo\"‑ ‑nɛ ka. ");
INSERT INTO wob_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Dɛ jrɛ' se \"ikma 'de Kea ‑pee. ");
INSERT INTO wob_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","'Sʋ Madi 'na : 'Ɩn nɩɛ Kea 'a \"juɔinʋʋnynɔkpao' ‑o. Ka ‑ɩn ‑daa', ɛ nʋʋɛ 'ʋn \"jrii kan'. 'Sʋ Kea 'a \"soai 'wlʋ 'o ʋ ‑pʋn\" 'mɛ ‑wɛe ɔ mu. ");
INSERT INTO wob_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","'De nɔ\" due' ‑nɛ 'di ɛ, Madi crɛɛ \"kpei‑ ʋ je ‑jei\" 'kpa. 'Kamɔ ʋ nʋ ‑ja crʋɩ ‑blu' crʋɩ 'sʋ ʋ je 'e Suide 'a ‑kwlɔ due' 'di mu' 'de crʋɩ \"kpei fɔo. ");
INSERT INTO wob_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","‑Wɛe ʋ pa 'e Sakali o ‑gbu\" 'di 'de ʋ po Elisabɛtɩ 'jewlu o. ");
INSERT INTO wob_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Elisabɛtɩ 'wɔan Madi 'a 'jewlu 'sʋ ʋa' \"ju ‑suua' i 'de ʋ 'ʋn. 'Bo ɛ \"sri Kea 'a ‑Suu je 'e ʋ 'ʋn \"ji. ");
INSERT INTO wob_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","'Sʋ ʋ kpa wlu \"jɛi ʋ 'na : Kea ‑sa aʋn 'de 'nynʋkpae' ‑wee' \"klu, ‑wɛe ɛ po aʋn \"diwan, a ke aa' \"ju ke‑. ");
INSERT INTO wob_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","‑Ta 'ɩn ‑sa 'saaʋn ‑jɛ ‑mɛ ɛ‑, ‑wɛe 'ma Tʋ\"bo de ji 'mi \"i ‑teea' ? ");
INSERT INTO wob_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","A ‑gbʋn 'nɔ, aa' 'jewlu 'kpa 'ʋn doun\" 'sʋ, \"ju ‑nɩa 'de ʋn ‑suua' i 'de 'mʋa‑ 'ʋn. ");
INSERT INTO wob_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Amɔ nʋ 'mʋa‑, dɛ‑nʋɛ' dɩ Tʋ\"bo 'tmʋa 'de aa' ‑tɩ' 'ʋn ɛ, a 'je ɩa' 'o nyni ‑tɩ tɔ' 'ʋn 'ɛ. ");
INSERT INTO wob_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","'Sʋ Madi 'na : 'Ma 'kmʋ ‑wee' a ‑sa' Kea 'nynɩ. ");
INSERT INTO wob_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","‑Wɛe 'mʋa‑ \"ji 'de 'ʋn pɛe o 'mɛ ‑ke 'de Kea ‑nɩa 'ma 'Pʋʋi 'a ‑tɩ' 'ʋn. ");
INSERT INTO wob_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Dɛ‑nʋɛ', 'mɔ ‑nɩa ɛɛ' \"juɔinʋʋnynɔkpao' ‑ɔ sea dɛ jrɛ' wɔn nɩ ɛ, 'mɔ ɛ sie \"jriɛ‑ o. Dɛ ‑tba' ‑ta ‑ɛ mua nya, nyʋ ‑ʋʋa mua 'wlʋa', ʋʋ ‑wee' a muɛ 'ʋn 'di 'a wɔnmɔnynɔkpao' 'daa', ");
INSERT INTO wob_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","dɛ‑nʋɛ' Kea ‑kmai\", ɛ nʋɛ dɩ klae\" 'de 'ma ‑tɩ' 'ʋn. Ɛɛ' 'nynɩ ‑kwɛ' i 'pepe. ");
INSERT INTO wob_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Ɛɛ' 'di wɔnmɔa' se ‑kwɛ ‑ta 'ble 'de nyʋ ‑ʋʋa pleeɛ ‑pee. ");
INSERT INTO wob_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Ɛɛ to ɛɛ' \"ikmasʋn 'mɛ 'de dɩ \"klein ɛ nʋa 'ʋn. Ɛɛ ‑gba' ‑cɛi\" 'bɛɛʋn ja. ");
INSERT INTO wob_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Ɛɛ ‑saa' 'beɔ‑wi\" \"kpa‑tɩ ‑sɔn, ‑wɛe ɛɛ \"nyɩ nyʋ ‑ʋʋa ‑piia' ʋʋa' ‑cɛi\" ‑teɩn. ");
INSERT INTO wob_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Ɛɛ \"nyɩɛ nyʋ 'mɩɩɛ‑ ɛ nʋa diidɛ, ɛɛ poɛ \"wliiɛjeʋn ‑jei\" 'de 'kwa iflɔan' 'ʋn. ");
INSERT INTO wob_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","55","Ɛɛ 'wlʋɛ Israɛ‑kɔʋn ‑ʋʋ ‑nɩa ɛɛ' \"juɔinʋʋn o. ‑Wɛe ɛɛ to ʋʋpʋ ɛɛ' 'diwɔnmɔa' \"i. 'Kamɔ ɛ cɛn ɛɛ' wlʋ ‑tie\" 'de ‑a \"bo Ablaam ke ɔɔ' \"nynuu‑ ‑pee. ");
INSERT INTO wob_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Nɔ\" Madi nʋa 'o Elisabɛtɩ o ‑gbu\" ‑sɔn 'bɛɛ‑ 'cʋɩ taan 'mɛ ‑wɛe ʋ mu 'de ʋ o ‑kwlɔ de. ");
INSERT INTO wob_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Nɔ\" nynia 'o 'sʋ Elisabɛtɩ ‑gbaan', ʋ 'wlʋɛ \"junmɔu ju‑. ");
INSERT INTO wob_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","'Sʋ nyʋ ‑ʋʋ ‑ke ʋʋ \"kʋʋan i ke ʋa' 'cɛ‑wi\" 'wɔan ka Tʋ\"bo 'a nyʋ 'a wɛe 'jea' 'bɛa \"i 'de ʋa' ‑tɩ' 'ʋn 'sʋ, ʋʋ ke ʋʋ ‑wee' a nʋʋɛ ba 'mʋa i. ");
INSERT INTO wob_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","\"Jupliiɛ nʋa 'wɩ ‑mɛ\" na 'sʋ ʋʋ jiɔ 'klɛn kpaa'. Ʋʋa 'dɔɔ‑ ɔ \"bo Sakali 'a 'nynɩ, ");
INSERT INTO wob_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","'kaa ɔ de \"dua wlu 'ʋn, ʋ 'na : \"Ɩɩn‑, San mɛ ‑je ɔɔ' 'nynɩ ‑nɩ. ");
INSERT INTO wob_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","'Sʋ ʋʋ 'na : Nyɔ jrɔ' se 'nynɩ ‑nɩa 'mʋa‑ 'ble 'de aa' ‑gbu\" ‑sɔn nyʋ \"klu. ");
INSERT INTO wob_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","'Sʋ ʋʋa 'daa Sakali \"i ‑wɛe 'nynɩ ‑jɩ ɔ nɩa \"i ɔ 'jea ɔɔ' \"ju 'daa‑ 'de ʋʋ 'jɩ juo‑. ");
INSERT INTO wob_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","‑Wɛe Sakali ‑tee' tufɔ i 'de ɔ 'crɩ 'o ɛ \"kpei ka : San mɛ ‑nɩ ɔɔ' 'nynɩ. 'Sʋ tai' \"maa ʋʋpʋ ‑wee' 'mɛ. ");
INSERT INTO wob_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","'Bo ɛ \"sri ɔ je wɔn 'bai, ɔɔ' mɩɩɔ je ‑gbai', ɔ je wlua' ‑pʋn\" ‑te 'de Kea 'a 'nynɩ \"i 'bɛɛa' 'ʋn. ");
INSERT INTO wob_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Nyʋ \"klein ‑ʋʋ ‑ke ɔ \"kʋʋan i ɛ, ɛɛ' faʋn a nʋ ʋʋpʋ ‑wee' 'mɛ. Dɛ ‑nʋʋa 'mʋa‑ nyiɔpʋ a 'tmʋ ɛ \"wɔin‑ 'de Suideblʋa 'a 'fɔ ‑nɩa crʋɩ 'dii ‑wee' \"klein \"kpei‑. ");
INSERT INTO wob_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","'Sʋ nyʋ \"klein ‑ʋʋ ‑wɔɩn ʋʋ poɛ ɩ pɛe o, ‑wɛe ʋʋa nɩɩ tɔ' \"kpei‑, ʋʋa ‑teeɛ' ʋʋa' ‑cɛ\" i ʋʋ 'na : Dɛ \"ju ‑saan\" ‑nɔ ‑mɔ 'je 'ʋn 'wlʋ 'de nya 'ja a‑ ? Tʋ\"bo 'a 'saaʋn ‑nɩ ɔ \"kpei. ");
INSERT INTO wob_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Kea 'a ‑Suu ‑kweai jia 'e \"ju ‑saan\" \"bo Sakali 'ʋn 'sʋ, ɔ ‑teɛ Kea 'a ‑tɩ' 'tmʋa' ‑pʋn\" ɔ 'na : ");
INSERT INTO wob_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","\"Diwan kpʋn Tʋ\"bo Israɛ 'ɛ Kea, dɛ‑nʋɛ' ɛ ‑teeɛ', ɛɛ' 'cɛ \"i ‑wɛe ɛ ‑seie ʋʋpʋ. ");
INSERT INTO wob_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Ɛ nʋɛ' ‑wɛe Nyʋ'pʋʋi ‑kmai\" 'wlʋ 'de ɛɛ' dbonʋi Dafidɩ 'a ‑gbu\" 'di. ");
INSERT INTO wob_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Ka ɛɛ' ‑cɛ\" 'ɛ wlu 'kwajaaʋn ‑nɩa tɛin\" 'tmʋ ɛ 'de ɛ, 'kamɔ ɛ nɩ‑. ");
INSERT INTO wob_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Nyʋ'pʋʋi ‑ɔ ‑jea ‑a seie 'de ‑aa tʋnyʋ ke ‑aa 'ʋn 'nyɛʋn ‑wee' \"klein 'kwa ɔmɔ ‑ɔɔ ji. ");
INSERT INTO wob_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","'Kamɔ Kea nʋ ɛɛ' 'diwɔnmɔa' to sʋn 'de ‑a \"bo ‑wi\" ‑pee, ‑wɛe ɛ po ɛɛ' dbɛɛdɛ ‑nɩa 'pepe 'a ‑tɩ' ‑kwlʋ o, ");
INSERT INTO wob_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","ka ɛ cɛan ɛɛ' wlu ‑tie\" 'de ‑a \"bo Ablaam ‑pee see ɛ. ");
INSERT INTO wob_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","Ɛ 'na ɛ 'je ‑a seie 'de ‑aa tʋnyʋ 'kwa, ‑wɛe ‑bo ‑aa se ɛ \"juɔi nʋʋ ɛ, faʋn je ‑a nʋ. ");
INSERT INTO wob_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","'De ‑a ‑je na 'de 'pepe nɩa' ke \"isrɛa 'ʋn 'de ‑aa 'kmʋnɩa' 'ʋn 'de 'wɩ ‑wee' klein\" 'di. ");
INSERT INTO wob_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Sakali wlu' ke'wlɛ ɔ 'na : 'De ‑mɔ 'ma \"ju, nyʋ a muɛ ‑ʋn Kea ‑nɩa 'e jaʋn 'di 'a wlu 'kwajaai 'daa', dɛ‑nʋɛ' ‑ma muɛ naa' 'bo tʋ\"bo \"juɔi ‑wɛe ‑ɩn ‑je ɛɛ' ‑jeblʋ nmaea'. ");
INSERT INTO wob_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Dɛ ‑ɩn ‑jea 'tmʋ 'de ɛɛ' 'cɛ ‑pee ɛ ka Kea 'pʋʋ aopʋ 'mɛ. Ɛ 'wlʋɛ aoa' dɩsaɩn \"kpei. ");
INSERT INTO wob_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Kea kma ‑aa ‑tɩ' kpleiin, ɛ 'jeɛ ‑aa wɛe‑, ɛmɛ ‑tɩ ɛ ‑sɩɩn ‑sɔn' 'de ‑a \"kpei ka ‑klae\" jrʋ a 'wlʋa 'kwla 'de jaʋn 'di ɛ. ");
INSERT INTO wob_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Ɛ ji' ‑wɛe ɛ ‑sɩn' 'de nyʋ ‑tea i 'de kwie 'di ke nyʋ ‑tea 'mɛa 'a ‑tea' \"kpei, 'de ɛ 'je ‑aa \"juua 'de pɛe 'a blu ‑jei\" \"biee‑. ");
INSERT INTO wob_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","\"Ju‑saan\" ‑nɔ, ka ɔɔ 'boa, 'ka ɔɔ' tɔ' 'dinɩa' a 'kpa \"kpei. Ɔ \"tiɛ 'e ‑pɩɩɔn\" blʋa \"kpei mamaʋ 'sʋ ɛ je 'wɩ ‑ɛ 'di ɔ toa ɔɔ' ‑cɛ\" 'de Israɛ‑kɔʋn ‑pee jɛɛ‑. ");
INSERT INTO wob_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Ɛɛ' nɔ\" tu 'di mɛ 'blʋajei Sesaa Okisɩ bla kɛ' ɔ 'na : Nyʋ ‑wee' \"klein 'je ʋʋa' 'nynɩ 'sbɛ 'di po ‑o 'de Rɔmɛ 'ɛ 'blee‑blʋa ‑wee' \"klein \"kpei‑. ");
INSERT INTO wob_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Ɛmɛ ‑nɩ 'nynɩ 'sbɛ 'dipoa' 'a \"i‑saa ‑nɛ. 'De ɛɛ' nɔ\" tu 'di ɛmɛ Kirinisɩ 'blee Siriblʋa. ");
INSERT INTO wob_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Nyʋ ‑wee' \"klein a muɛ ʋʋa' ‑kwlɛ 'dii due 'due, ‑wɛe ʋʋ 'je 'nynɩ 'sbɛ 'di po. ");
INSERT INTO wob_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Soseʋ foo\" 'sʋ 'wlʋ 'o Nasarɛtɩ 'mɛ 'de Galile ‑wɛe ɔ mu 'o Bɛtelɛm 'de Suide 'bo ɔ 'mɩa Dafidɩ o ‑kwlɔ, dɛ‑nʋɛ' ɔ 'wlʋɛ 'e Dafidɩ 'a \"ji 'di. ");
INSERT INTO wob_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Ɔ ke Madi ‑ʋ ‑tea ɔɔ' 'nynɩ 'ʋn mu' ‑ke, ‑wɛe ʋʋ 'je ʋʋa' 'nynɩ 'sbɛ 'di po. Ɛɛ' nɔ\" tu 'di ‑mɛ Madi 'bleɛ \"kwli. ");
INSERT INTO wob_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Ʋʋ nynia 'o Bɛtelɛm 'sʋ ɛ, ‑gbaandi 'kpa Madi 'ʋn 'ɛ, 'sʋ ʋ ‑gbaan'. ");
INSERT INTO wob_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Ʋ 'wlʋ ʋa' \"i‑saaju 'mɛ ‑wɛe ʋ \"fin ɔ tae'fɔ i, ʋ 'pɛɛn ɔ i 'de 'blae 'a 'didiidɛ 'di, dɛ‑nʋɛ' ʋʋ se ‑teɩn 'je 'de 'dʋɩ‑ 'a ‑si' ‑gbu\" 'di. ");
INSERT INTO wob_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","'De ɛɛ' 'blʋa 'a 'fɔ tu o ɛ, \"nɔdɩ 'dei ‑teʋn jrʋ' ‑ʋʋ ‑nɩ 'e ‑gbaa \"kpei ‑wɛe ‑ʋʋa fuo ʋʋa' nɔ\"dɩ 'dei \"maʋ\". ");
INSERT INTO wob_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Ʋʋa ‑gbʋan' 'emu 'sʋ, Tʋ\"bo Kea 'a \"soai due' ‑jɛɛ ʋʋpʋ. 'Sʋ Tʋ\"bo 'a ‑sɔn' ‑sɩn' 'de ʋʋ 'de i ‑ta ‑wee'. Ɛɛ' dɛ waa ʋʋpʋ 'dii, 'sʋ faʋn klaa\" 'kpa 'de ʋʋpʋ 'ʋn 'ɛ. ");
INSERT INTO wob_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Kea 'a \"soai wlu' 'de ʋʋpʋ ‑pee ɔ 'na : Faʋn 'bɔ aoa' nʋ‑tɩ, dɛ‑nʋɛ' 'ɩn ja ao ‑pɔia\" ‑tɩ ‑ɩa mu nyʋ ‑wee' \"klein 'a 'mʋa‑ klaa\" 'blea' ‑ke. ");
INSERT INTO wob_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Ɛ nɩ aoa' 'pʋʋi mɔ ‑wlʋ ‑sɩan 'de Dafidɩ o ‑kwlɔ. Ɔmɔ ‑nɩ Klisɩ, Tʋ\"bo ! ");
INSERT INTO wob_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Ka ao 'jea ɔɔ' juosʋn nʋ 'ka ka : aoa muɛ \"jupliiɛ due' 'jea', ɔ 'je 'e tae'fɔ 'di nɩ‑, ‑wɛe ɔ 'je i'pɛn 'de 'blae 'a 'didiidɛ 'di. ");
INSERT INTO wob_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Ʋʋa kɔan 'emu 'sʋ Kea 'a \"soa‑wi\" ‑tuu\"‑tuu ji' 'bo ‑jɔ ‑ɔɔ ‑tmʋa ‑tɩ' ‑pʋn\" ‑wɛe ʋʋa 'bɛɛ‑ Kea 'a 'nynɩ \"i ʋʋa nʋ : ");
INSERT INTO wob_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","Kea 'a 'nynɩ \"bɛi 'de jaʋn 'di ‑wɛe pɛe 'a blua' 'je 'e 'blʋa \"kpeinyʋ ‑ʋʋa ‑tɩ' Kea kma \"kpei ji. ");
INSERT INTO wob_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Kea 'a \"soa‑wi\" ke ʋʋ cɛɛan \"i ʋʋ mua jaʋn 'di de ɛ, nɔ\"dɩ 'dei ‑teʋn wluɛ ba ‑pee ʋʋ 'na : ‑A mu Bɛtelɛm ‑wɛe dɛ ‑nʋʋa 'demu 'de Kea ‑sa 'kwla 'de ‑a ‑pee ‑ta, ‑a ‑je ɛ \"jriɛ‑ 'jee‑. ");
INSERT INTO wob_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Ʋʋ mu' 'de \"kpei‑ crɛa' 'ʋn ‑wɛe ʋʋ jɛɛ Madi ke Sosɛʋ ke. Ʋʋ jɛɛ \"ju ‑saan\" 'mɛ ‑cɛɛn'‑, ɔ je i'pɛn 'de 'blae 'a 'didiidɛ 'di. ");
INSERT INTO wob_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Ʋʋ ‑kɔ' \"ju ‑saan\" \"jriɛ‑ 'jeea kpɩɩn‑ ‑wɛe ʋʋ po dɩ \"klein ʋʋ 'wɔan 'de ɔɔ' ‑tɩ' 'ʋn 'a \"kwuan. ");
INSERT INTO wob_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Nyʋ \"klein ‑ʋʋ ‑wɔan ɩa' dɩ tu 'de nɔ\"dɩ 'dei ‑teʋn 'wɔn ɛ, tai' \"maa ʋʋpʋ 'mɛ. ");
INSERT INTO wob_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Madi a ‑teɛ' dɩ \"klein ‑nɩa 'mʋa‑ i 'de ʋa' pɛe o, ‑wɛe ʋa naa ɩ tɔ' \"kpei i. ");
INSERT INTO wob_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","'Sʋ 'blae 'dei ‑teʋn ‑nʋ muɛ ‑ta ʋʋ 'wlʋa de. Ʋʋa ble', ʋʋa 'bɛɛ‑ Kea 'a 'nynɩ \"i 'de dɩ \"klein ʋʋ 'wɔan 'de ʋʋ 'jeea \"jriɛ 'ɛ ‑tɩ' 'ʋn, dɛ‑nʋɛ' ka Kea 'a \"soai 'tmʋ ɩ 'de ʋʋ ‑pee ɛ, 'kamɔ ɩ nɩ ‑cɛɛn'‑. ");
INSERT INTO wob_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","'Wɩ ‑mɛ\" na ‑nɛ ‑ɛ 'di ʋʋ 'jea \"ju ‑saan\" 'klɛn kpaa nynia a, 'bomɔ ʋʋ ‑tuu\" ɔ Sesi‑nynɩ. 'Nynɩ ‑nɩa 'mʋa‑ ɛmɛ Kea 'a \"soai \"si 'nynɩ 'de ɔ de ‑pee ‑mɛ ʋ se ɔɔ' \"kwli i 'tɛn ke. ");
INSERT INTO wob_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","'Wɩ ‑ɛ 'di ʋʋ 'jea dɛ Moisɩ 'a kɛ' \"sia 'nynɩ ‑nʋ 'de ‑gbaʋn 'a ‑tɩ' 'ʋn nynia 'o mu 'sʋ ɛ, Soseʋ ke Madi muɛ Selisalɛm ‑wɛe ʋʋ 'je \"ju‑saan\"‑ Tʋ\"bo \"i to‑. ");
INSERT INTO wob_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Dɛ ‑crɩɩa' 'de Tʋ\"bo Kea 'a kɛ' 'di ɛ 'naa : ‑Bo \"junmɔu 'wlʋ ‑wɛe ɔ 'je \"i‑saaju nɩ ɛ, ‑mɛ ɔ 'je kpɔi\" ‑tee ‑o 'de Tʋ\"bo 'a ‑tɩ' 'ʋn. ");
INSERT INTO wob_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Ʋʋ ‑sa ɔɔ' 'sraa‑, 'kamɔ ɛ 'crɩɩɛ 'de Tʋ\"bo Kea 'a kɛ' 'di, ɛ 'na : ‑Ɩn ‑ja 'sɔɔn, 'de ‑bo ‑gbɛɛ se nɩ ‑ɩn ‑ja \"pai nynuu 'sɔɔn. ");
INSERT INTO wob_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","'De \"ju due' ‑nɩ 'o Selisalɛm ɛɛ' nɔ\" tu 'di, ɔɔ' 'nynɩ ‑nɩ Simeɔ. Ɔɔ' \"ju tu ‑srɛi\", ɔɔ 'jeɛ Kea wɔn, ɔɔ fuɛ Israɛ 'ɛ 'Pʋʋi, ‑wɛe Kea 'a ‑Suu nɩ 'de ɔ 'ʋn. ");
INSERT INTO wob_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Kea 'a ‑Suu 'tmʋʋ ɔ sese ɛ 'naa : ‑Ɩn se 'mɛi ke, dɛ‑nʋɛ' ‑ma muɛ Nyʋ'pʋʋi, Tʋ\"bo 'a 'o‑tei \"jriɛ‑ 'jeea'. ");
INSERT INTO wob_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Kea 'a ‑Suu poɛ Simeɔ ‑je o, ɔ muɛ 'e Kea ‑gbu klaa\" 'di, 'demɔ Soseʋ ke Madi kpa \"jupliiɛ ‑wɛe ʋʋ 'je dɛ Kea 'a kɛ' \"sia 'nynɩ nʋ 'de ɔɔ' ‑tɩ' 'ʋn. ");
INSERT INTO wob_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","'Sʋ Simeɔ kpʋn \"jupliiɛ 'mɛ, ɔ po ɔ sɩn 'dii ‑wɛe ɔ po Kea 'sɛ‑. 'De ɔ 'na : ");
INSERT INTO wob_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","Kaan ka la 'jaa‑ Tʋ\"bo, ɛ \"tai ɛɛ' dbonʋi \"i, ɔ 'je mu 'de pɛe 'a blua' 'ʋn, 'kaa dɛ ɛ 'tmʋa ɛ nyni 'o 'ɛ ");
INSERT INTO wob_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","dɛ‑nʋɛ' 'ɩn 'jee‑ nyʋ 'pʋʋi ɛ ja \"jriɛ‑ ‑wɛ‑. ");
INSERT INTO wob_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","'Pʋʋa' ɛ nmaea 'bo nyʋ ‑wee' \"klein \"juɔi ɛ, ");
INSERT INTO wob_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","ɔmɔ ‑nɩ ‑sɔn' ‑ɛ ‑je nyʋ ‑wee' \"klein i 'jee‑, 'de ‑ɔ ‑je ɛɛ' 'cɛ Israɛ‑kɔʋn 'a ‑cian\" nɩ‑. ");
INSERT INTO wob_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Dɩ ʋʋa 'tmʋa 'de Sesi 'a ‑tɩ' 'ʋn ɛ ɩa poɛ ɔ \"bo ke ɔ de 'mlɩ 'mlɩ pɛe o. ");
INSERT INTO wob_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","'Sʋ Simeɔ poɛ ʋʋpʋ \"diwan ‑wɛe ɔ wlu 'de Sesi de Madi ‑pee ɔ 'na : A ‑gbʋn 'nɔ, Kea ‑te' 'o \"ju ‑nɔ 'de Israɛ‑kɔʋn \"klu, nyʋ jrʋ' ‑a muɔ 'de blaa' 'kaa jrʋ' a muɔ o ‑fɔan'. ");
INSERT INTO wob_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","'De ɛɛ' ‑tɩ' 'ʋn ɛ tɔ' saɩn ‑pa' 'kwla 'de nyiɔpʋ‑ ‑tuu\"‑tuu 'ʋn ɛ ɩa muɛ \"kpae 'pɛɛan', amɔ ‑nɩa ɔ de ɛ, ɛɛ muɛ aʋn pɛɛ \"i cɩan'. ");
INSERT INTO wob_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Kea 'a wlu 'kwajaanynɔkpao' due' ‑nɩ 'o mu ‑ke, ʋa' 'nynɩ ‑nɩ Anɩ. Ʋ nɩɛ Fanuɛlɩ 'a \"ju ‑o 'de Asɛɛ 'ɛ \"ji 'di, ʋ 'kpa ‑kea\". Ʋ \"tia jra ɛ nʋɛ ‑sɩn ‑mɛ\" 'sɔn 'sʋ ʋa' kʋan 'mɛɛ. ");
INSERT INTO wob_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Ʋ siiɛ ‑tiɔn\" 'nynɔ dɛ 'ʋn mamaʋ 'sʋ ʋ je ‑sɩn 'a kwla ‑mɛ\" na 'jɔ ‑nyiiɛ 'ble. Ʋa' tɛɛn Kea ‑gbu klaa\" o, ʋa nʋʋɛ Kea \"juɔi 'jrʋ‑gbao o \"maʋ' o 'de wɔn 'bɔa' ke Kea baea' 'ʋn. ");
INSERT INTO wob_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Ʋmʋ ‑ji' ‑ke 'de ɛɛ' nɔ\" tu 'di, ‑wɛe ‑ʋa po Kea 'sɛ‑. 'Sʋ ʋ ‑teɛ \"ju ‑saan\" 'a ‑tɩ' 'tmʋa' ‑pʋn\" 'de nyʋ \"klein ‑ʋʋa fua nɔ\" Kea 'jea Selisalɛm seie‑ ‑pee. ");
INSERT INTO wob_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Sesi 'a \"bo ‑wi\" ‑kɔa' dɩ Kea 'a kɛ' \"sia 'nynɩ 'a nʋa' 'sʋ ɛ, ʋʋ muɛ Nasarɛtɩ de 'de Galile. ");
INSERT INTO wob_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","\"Ju‑saan\" a 'boa ɔɔ kuuɛ 'dii, ɔɔ' tɔ' ɔ 'kpa \"kpei ‑wɛe Kea 'a \"diwan nɩ ɔ \"kpei. ");
INSERT INTO wob_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","'De ‑sʋn \"o ‑sʋn 'di ɛ, Sesi 'a 'cɛ‑wi\" a muɛ kʋɔnkwla' 'wlʋ ‑kɔ ‑sɔn 'de Selisalɛm. ");
INSERT INTO wob_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","‑Ta Sesi 'blea ‑sɩn 'a ‑puue 'jɔ 'sɔɔn ɛ, ɔ ke ʋʋ mu' ‑ke ka ʋʋa nʋa see ɛ. ");
INSERT INTO wob_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","‑Kɔ' ‑kwɛa ja 'sʋ, ʋʋa muɛ ‑kwlɔ de. 'Kaa ka Sesiju sia Selisalɛm, ɔ \"bo ke ɔ de‑wi\" se ɛ \"jriɛ‑ o sie. ");
INSERT INTO wob_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","‑Bo ʋʋpʋ mɔɔ sea 'je 'de ɛ, ʋʋ 'na ‑mɛ ɔ ke ʋʋa' \"dɛi‑wi\" muɛ nya. 'Sʋ ʋʋ je na 'wɩ due', ‑wɛe ʋʋ ‑te ɔɔ' i ‑pɔan' ‑pʋn\" 'de ʋʋa' 'cɛ‑wi\" ke ʋʋa' \"ijuonyʋ \"klu. ");
INSERT INTO wob_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","'Kaa ʋʋ se ɔ 'je 'sʋ ɛ, ʋʋ muɛ Selisalɛm de, ‑wɛe ʋʋ 'je ɔ i‑pɔn. ");
INSERT INTO wob_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","'De ɛɛ' 'wɩ taan ‑sɔn 'di ɛ, 'bomɔ ʋʋ 'jee ɔ 'de Kea ‑gbu klaa\" 'di, ‑mɛ ɔ ‑teɛ i 'bo Kea 'a kɛ' wɔ‑saʋn 'a ‑kwea'‑, ‑wɛe ɔɔ po ʋʋpʋ 'a wlu doin\" o 'de ɔɔ ‑tee' ʋʋpʋ i. ");
INSERT INTO wob_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Nyʋ \"klein ‑a poa ɔɔ' wlu doin\" o ɛ, ʋʋ ‑ka' wɔn, ʋʋa je ɔ ja ‑gbʋn', dɛ‑nʋɛ' ɔɔ' tɔ' 'dinɩa' ke ɔɔ' ‑tɩ' wɔn \"kpei ‑sasʋn \"siɛ ʋʋpʋ \"i. ");
INSERT INTO wob_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","‑Ta ɔɔ' 'cɛ‑wi\" 'jeea ɔ \"jriɛ‑ ɛ, tai' \"maa ʋʋpʋ 'mɛ, 'sʋ ɔ de wlu' ɔ ‑pee ʋ 'na : 'Ma \"ju, dɛɛ ‑tɩ ‑ɩn nʋ ‑a kan' a‑ ? ‑Ɩn ‑gbʋn 'nɔ, ‑ɩn \"bo ke 'mɔ ‑ke ‑a ‑tuɛ\" ‑kwlʋ \"jɛi 'de ‑ma ‑tɩ' 'ʋn ‑aa jea ‑mii' ‑pɔn. ");
INSERT INTO wob_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","'Sʋ Sesi wluɛ ʋʋpʋ ‑pee ɔ 'na : Dɛɛ‑tɩ aoa ‑pɔn 'mi i ɛ‑ ? Ka 'ɩn 'jea 'ɩn \"Bo 'a ‑kwlʋ' ‑tɩ nʋ ao se ɛ juo‑ ? ");
INSERT INTO wob_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","'Kaa dɛ ɔ 'tmʋa 'mʋa‑, ʋʋ se 'e ɛ 'dei 'wɔn. ");
INSERT INTO wob_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","'Sʋ Sesi sɔn 'ʋn 'ɛ, ɔ ke ʋʋ muɛ Nasarɛtɩ. Dɛ‑nʋɛ' ɔɔ 'jeɛ ʋʋpʋ wɔn. Ɔ de ‑teɛ' dɩ \"klein ‑nɩa 'mʋa‑ i 'de ʋa' pɛe o. ");
INSERT INTO wob_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Sesi a 'boa jeejee, ɔɔ' tɔ' ɔ 'kpa \"kpei jeejee. Ɔɔ' kplɩn a nmɔɔ 'e Kea ke nyiɔpʋ‑ \"jri 'de i. ");
INSERT INTO wob_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Nɔ\" ‑ɛ 'di Tibɛɛ Sesaa ‑tea Rɔmɛ 'blʋa \"i ɛ, ɛɛ' ‑sɩn 'a ‑puue 'jɔ ‑mm\" ‑nɩ 'di, ‑mɛ Ponsɩ Pilatɩ nɩ ‑gbʋa'na 'de Suide. Nɔ\" ‑nɩa 'mʋa‑ 'di mɛ Erodɩ nɩ Galile 'a ‑gbʋa'na ‑wɛe ɔɔ' ‑fɛin' Filipʋ nɩ Itire ke Trakonitɩ 'a ‑gbʋa'na 'de Lisaniasɩ nɩ ‑gbʋa'na 'de Abilɛnɩ ‑ke. ");
INSERT INTO wob_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","'De ɛɛ' ‑sʋn ‑tu 'di, mɔ Anɩ ke Kaifʋ nɩɩ Kea 'a 'sraa ‑saʋn klae\". 'Bomɔ Kea a jaa Sakali 'a \"ju San wlu 'kwa 'de ‑pɩɩɔn\" blʋa \"kpei. ");
INSERT INTO wob_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","'Blʋa‑ \"klein ‑jiia Sudɛn ‑gbuu wɔin ɛ, ɩmɩ San a ple 'dii 'de ɔɔ bla Kea 'a ‑po' 'de nyʋ ‑pee ɔ 'na : Ao poo aoa' tɔ' fai\" ao \"biie 'de Kea o 'de Ɛ 'je aoa' dɩsaɩn ‑kɔ' ‑wɛe 'ɩn 'je aopʋ \"ni \"jru po. ");
INSERT INTO wob_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Ka ɛ 'crɩɩa 'de Kea 'a wlu 'kwajaai Esai 'a 'sbɛ 'di ɛ 'ka ka : \"Ju ‑nɩa 'e ‑pɩɩɔn\" blʋa \"kpei ɔɔ' weewlu ka : Ao nmae Tʋ\"bo 'a ‑jeblʋ, ao tɛɛn ɛ ‑wee' ‑kwlʋ ! ");
INSERT INTO wob_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Crʋɩ klae\" ke crʋɩ mɩɩ\" a muɛ iwaa', ‑wɛe ‑kancuin\" ‑wee' \"klein 'je kluuɛ‑, dɩ ‑klɩɩan 'ʋn ɩ ‑wee' a muɛ \"isrɛa', kbɔ kpi 'je iwaa‑ 'de ‑jeblʋ ‑wee' \"klein 'je ‑paii 'pɛn. ");
INSERT INTO wob_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","‑Wɛe nyʋ ‑wee' \"klein 'je Kea 'a ‑pɔia\" sʋn \"jriɛ‑ 'jee‑. ");
INSERT INTO wob_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Nyʋ ‑tuu\" ‑a ji 'e San o ‑wɛe ɔ 'je ʋʋpʋ \"ni \"jru po. 'Kaa ɔɔ wlu' 'de ʋʋ ‑pee ka ɔ 'na : Aopʋ jɔe 'a \"nynuu‑ ‑nʋ ! ‑Ɔ ‑na 'kamɔ ao 'je Kea 'a 'pee ‑ɛɛ jia \"juɔi ple ɛ‑ ? ");
INSERT INTO wob_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Ka ao pooa kplɩn fai\" ɛ, ao toɛ nyʋ 'jeɛ 'je, ao 'bo aoa' ‑cɛ\" pɛe 'dii ‑teɛ', ao 'bo nʋʋɛ ‑a ‑nɩɛ Ablaam 'a \"nynuu‑ ‑o, dɛ‑nʋɛ' 'ma 'tmʋʋ aopʋ 'mɛ Kea 'beeɛ' ɛ 'je \"soi ‑nɩ Ablaam 'a \"nynuu‑ ‑cɔʋn' 'ʋn nʋ. ");
INSERT INTO wob_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Ka tu ‑ɛɛ' poa \"bi 'dɔe nɩa ao 'bo kan' nɩɛ, dɛ‑nʋɛ' ‑gbo\" ‑pa 'pɛn i ‑wɛ‑ 'bo ɛɛ' 'sɩn \"kpei. Tu \"o tu ‑sea' \"bi 'dɔe poɛ ‑mɛ 'je dbaa ‑o, ‑wɛe ɛ 'je \"jri pooɛ‑. ");
INSERT INTO wob_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Nyʋ \"klein ‑kwea de a ‑teeɛ' San i ʋʋ 'na : 'De ka ‑a ‑je nʋ 'ja a‑ ? ");
INSERT INTO wob_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","'Bomɔ ɔ wlu ʋʋpʋ ‑pee ɔ 'na : Nyɔ ‑blea \"bai 'sɔɔn ɔ \"nyɩ ɛɛ' due' nyɔ ‑sea' dɛ 'ble ɛ, nyɔ ‑blea diidɛ ɔ ke nyɔ ‑sea' diidɛ 'ble ‑gble' ɛ 'ʋn. ");
INSERT INTO wob_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","'Bomɔ 'wɛi‑sanyʋ jii ‑ke, ‑wɛe ʋʋ 'je \"ni \"jru pooɛ 'sʋ ʋʋ ‑teeɛ' San i ka ʋʋ 'na : ‑Aa dɛtɔɔi, dɛ ‑a ‑je nʋ ɛ‑ ? ");
INSERT INTO wob_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Ɔ wlu' 'de ʋʋ ‑pee ɔ 'na : 'Wɛi nyʋ cɩɩan 'wɔn, ɩmɩ ao 'je nyʋ i ‑tee', ao 'bo ɛ dɛ jrɛ' \"kpei pooɛ. ");
INSERT INTO wob_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","\"Soa‑wi\" a ‑tee' ɛ San i ‑ke ʋʋ 'na : 'De ‑apʋ mɔ 'e dɛ ‑a ‑je nʋ ɛ‑ ? 'Sʋ ɔ 'na : Ao 'bo nyʋ \"jrui dii ɛ, ao 'bo nyʋ ‑pa \"kpei blaa, aoa' ‑kei\" 'a 'sʋ mɛ ‑nɩ aoa' dɛ. ");
INSERT INTO wob_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","See ɛ, Israɛ‑kɔʋn a fuɛ Nyʋ'pʋʋi, 'de ʋʋ wlu' 'e ba ‑pee ʋʋ 'na : San ‑nɔ se Klisɩ nɩ mɔ ‑taa ? ");
INSERT INTO wob_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","'Bomɔ San wlu 'de ʋʋ ‑wee' \"klein ‑pee, ɔ 'na : \"ni mɛ 'ma po aopʋ \"jru, 'kaa \"ju due' ‑ɔɔ mua jia' a, ɔ kmai\" ɔ je 'ʋn ‑sii. 'Ɩn se ɔɔ' ‑pʋn\" 'kpa ka nɩ ‑wɛe ɔɔ' \"kwlai 'a \"dbu ‑mɛɛ' \"ikain ‑tɩ. Ɔmɔ ‑ɔɔ mu aopʋ \"ni \"jru poa 'de Kea 'a ‑Suu ke 'de nɛ 'ʋn. ");
INSERT INTO wob_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Ɔ 'bleɛ ɔɔ' 'daa‑ kwa, ‑wɛe ɔ 'je ɔɔ' ko 'ʋn ‑fun'. 'De ɔ 'je ɩa' 'jɔ ‑cɛɛn'‑ \"jɛi ‑tu\", ‑wɛe ɔ 'je ɩa' flɩ \"jri po 'de nɛ ‑ɛ sea 'mʋ‑ta 'ble 'ʋn. ");
INSERT INTO wob_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","'Kamɔ San a nʋ ‑wɛe ɔɔ 'tmʋʋ nyʋ ‑pɔia\"‑tɩ, 'de ɔɔ kuu nyʋ 'a dɩ i. ");
INSERT INTO wob_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","'Kaa ɔ ‑cɛ' ‑gbʋa'na Erodɩ \"bli dɛ‑nʋɛ', Erodiadɩ ‑nɩa ɔɔ' de 'di 'a 'nynɔ ɛ ʋmʋ ɔ \"duo 'ʋn, foo\" 'sʋ ɛ ɔ nʋɛ dɩsaɩn ‑tuu\"‑tuu jrɩ'. ");
INSERT INTO wob_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","'Bo ‑mɛ 'de ɛ, Erodɩ nʋɛ dɛsaʋn jrɛ' ke'wlɛ, ɛmɛ ‑nɩ ɔ kpʋn San 'mɛ, ‑wɛe ɔ po ɔ ‑kaso 'di. ");
INSERT INTO wob_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","‑Ta nyiɔpʋ ‑wee' nɩɩa \"ni \"jru pooa 'bomɔ Sesi pooɛ \"ni \"jru ‑ke, ɔ siiɛ Kea baea' 'sʋ jaʋn kaiɛn wɔn ‑wɛe Kea 'a ‑suu \"si i 'bo ɔ \"kpei ka ‑gbɛɛ' nɩa, ");
INSERT INTO wob_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","‑wɛe Kea 'a ‑Suu \"sii‑ 'bo ɔ \"kpei, ka ‑gbɛɛ nɩa, 'kamɔ ɛ nɩ‑. 'Sʋ wlu due' ‑wlʋ nyʋ 'wɔn 'de jaʋn 'di ‑ɛ na : ‑Ɩn ‑nɩɛ 'ma ‑tɩ' kmaju ‑o. 'De ‑ɩn 'ʋn 'bomɔ 'ma ‑kwlʋ' ‑tɩ ‑wee' \"klein poo kɩn. ");
INSERT INTO wob_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","‑Ta Sesi ‑tea ɔɔ' dbo ‑pʋn\" ɛ, ‑mɛ ɔ 'bleɛ ‑sɩn 'a kwla taan. Dɛ nyʋ a naa tɔ' i 'de ɛ mɛ ‑nɩ ɔ nɩɛ Soseʋ 'a \"ju, Eli 'a \"ju. ");
INSERT INTO wob_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Matatɩ 'a \"ju, Matatɩ nɩɛ Lefi 'a \"ju, Lefi nɩɛ Mɛlki 'a \"ju, Mɛlki nɩɛ Sanai 'a \"ju, Sanai nɩɛ Soseʋ 'a \"ju, ");
INSERT INTO wob_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Soseʋ nɩɛ Matatiasɩ 'a \"ju, Matatiasɩ nɩɛ Amosɩ 'a \"ju, Amosɩ nɩɛ Naum 'a \"ju, Naum nɩɛ Esli 'a \"ju, Esli nɩɛ Nagai 'a \"ju, ");
INSERT INTO wob_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Nagai nɩɛ Matɩ 'a \"ju, Matɩ nɩɛ Matatiasɩ 'a \"ju, Matatiasɩ nɩɛ Semei 'a \"ju, Semei nɩɛ Sosɛkɩ 'a \"ju, Sosɛkɩ nɩɛ Soda 'a \"ju, ");
INSERT INTO wob_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Soda nɩɛ Soana 'a \"ju, Soana nɩɛ Resa 'a \"ju, Resa nɩɛ Sorobabɛ 'a \"ju, Sorobabɛ nɩɛ Salatiɛ 'a \"ju, Salatiɛ nɩɛ Neri 'a \"ju, ");
INSERT INTO wob_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Neri nɩɛ Mɛlki 'a \"ju, Mɛlki nɩɛ Adi 'a \"ju, Adi nɩɛ Kosan 'a \"ju, Kosan nɩɛ Ɛlmadam 'a \"ju, Ɛlmadam nɩɛ Ɛrɩ 'a \"ju, ");
INSERT INTO wob_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Ɛrɩ nɩɛ Sose 'a \"ju, Sose nɩɛ Eliesɛɛ 'ɛ \"ju, Eliesɛɛ nɩɛ Sorim 'a \"ju, Sorim nɩɛ Matatɩ 'a \"ju, Matatɩ nɩɛ Lefi 'a \"ju, ");
INSERT INTO wob_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Lefi nɩɛ Simeɔ 'ɔ \"ju, Simeɔ nɩɛ Suida 'a \"ju, Suida nɩɛ Soseʋ 'a \"ju, Soseʋ nɩɛ Sonam 'a \"ju, Sonam nɩɛ Eliakim 'a \"ju, ");
INSERT INTO wob_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Eliakim nɩɛ Melea 'a \"ju, Melea nɩɛ Mena 'a \"ju, Mena nɩɛ Matata 'a \"ju, Matata nɩɛ Natan 'a \"ju, Natan nɩɛ Dafidɩ 'a \"ju, ");
INSERT INTO wob_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Dafidɩ nɩɛ isai 'a \"ju, Isai nɩɛ Sobɛdɩ 'a \"ju, Sobɛdɩ nɩɛ Boosɩ 'a \"ju, Boosɩ nɩɛ Sala 'a \"ju, Sala nɩɛ Naasɔn 'ɔ \"ju, ");
INSERT INTO wob_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Naasɔn nɩɛ Aminadabʋ 'a \"ju, Aminadabʋ nɩɛ Adminɩ 'a \"ju, Adminɩ nɩɛ Aani 'a \"ju, Aani nɩɛ Esrɔm 'ɔ \"ju, Esrɔm nɩɛ Farɛsɩ 'a \"ju, Farɛsɩ nɩɛ Suida 'a \"ju, ");
INSERT INTO wob_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Suida nɩɛ Sakɔbʋ 'a \"ju, Sakɔbʋ nɩɛ Isaakɩ 'a \"ju, Isaakɩ nɩɛ Ablaam 'a \"ju, Ablaam nɩɛ Tara 'a \"ju, Tara nɩɛ Nakɔ 'ɔ \"ju, ");
INSERT INTO wob_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Nakɔ nɩɛ Serukʋ 'a \"ju, Serukʋ nɩɛ Ragau 'a \"ju, Ragau nɩɛ Falɛkɩ 'a \"ju, Falɛkɩ nɩɛ Ebɛɛ 'ɛ \"ju, Ebɛɛ nɩɛ Sala 'a \"ju, ");
INSERT INTO wob_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Sala nɩɛ Kainam 'a \"ju, Kainam nɩɛ Afasadɩ 'a \"ju, Afasadɩ nɩɛ Sem 'a \"ju, Sem nɩɛ Noe 'a \"ju, Noe nɩɛ Lamɛkɩ 'a \"ju, ");
INSERT INTO wob_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Lamɛkɩ nɩɛ Matusala 'a \"ju, Matusala nɩɛ Enɔkɩ 'a \"ju, Enɔkɩ nɩɛ Sarɛdɩ 'a \"ju, Sarɛdɩ nɩɛ Maleleɛlɩ 'a \"ju, Maleleɛ nɩɛ Kainan 'a \"ju, ");
INSERT INTO wob_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Kainan nɩɛ Enɔsɩ 'a \"ju, Enɔsɩ nɩɛ Sɛtɩ 'a \"ju, Sɛtɩ nɩɛ Adam 'a \"ju, Adam nɩɛ Kea 'a \"ju. ");
INSERT INTO wob_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Kea 'a ‑Suu \"ji 'e Sesi 'ʋn 'ɛ. ‑Ta ɔɔ 'wlʋa 'bo Sudɛn ‑gbuu wɔn ɛ, 'bomɔ ‑Suu ‑nɛ po ɔ ‑je o, 'sʋ ɔ muɛ 'e ‑pɩɩɔn\" blʋa \"kpei. ");
INSERT INTO wob_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","'Bomɔ ‑siɔn' ‑tɩn' ɔ dɛsaʋn nʋa' i 'de 'wɩ 'a kwla ‑nyiiɛ 'di. 'De ɩa' 'wɩ tu 'di ɛ, ɔ se dɛ di. Ɩ 'wlʋa 'o ‑jei\" 'sʋ 'mɩɩɛ‑ nʋ Sesi 'mɛ. ");
INSERT INTO wob_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","'Sʋ ‑siɔn' wlu' 'de Sesi ‑pee ɔ 'na : Ka ‑ɩn ‑nɩa Kea 'a \"Ju ‑mɔ 'ja a, ‑mɛ ‑ɩn ‑wlu 'de \"soukpo ‑nɛ ‑pee ‑wɛe ɛ 'je ‑di'pɛn 'ʋn‑snɛɛ. ");
INSERT INTO wob_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Sesi wlu' 'de ɛ ‑pee ɔ 'na : Ɛ 'crɩɩɛ' 'de Kea 'a 'sbɛ 'di ka : ‑Di'pɛn 'ɛ 'sʋ se ɛ 'bɛɛ‑ ɛ 'je nyiɔ 'kmʋnɩa' \"nyɩ. ");
INSERT INTO wob_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","'Sʋ ‑siɔn' kpɔ 'de crʋ \"kpei ‑tajrɔ ‑wɛe 'de \"jriɛ ‑tɛ due' 'di 'sʋ ɛ to ɔ 'blʋa‑ 'di 'a 'beɔdɩ ‑wee' \"klein \"i, ");
INSERT INTO wob_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","‑wɛe ɛ wlu 'de Sesi o ka ɛ 'na : 'Ma muɛ ‑ʋn ɩa' \"ikmaa' ‑nɩa 'e 'kmʋ \"kpei ‑ta ke 'blʋa‑ 'di 'a \"wlii‑ \"nyɩa', dɛ‑nʋɛ' ɩ \"nyɩɩɛ 'ʋn 'ɛ, 'de nyɔ 'ɩn nɩa \"i ɔmɔ 'ɩn \"nyɩ. ");
INSERT INTO wob_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","‑Bo ‑ɩn ‑sii\" 'kɔi‑ i 'bo 'ʋn \"juɔi 'de ‑ɩn ‑je 'ʋn ‑gbɛɛ', ɩ ‑wee' \"klein a muɛ ‑ma dɛ nɩa'. ");
INSERT INTO wob_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Sesi wlu' 'de ‑siɔn' ‑pee ɔ 'na : Ɛ 'crɩɩɛ' ka : ‑Ma Tʋ\"bo Kea 'a 'sʋ ‑ɩn ‑je \"juɔi ‑gbɛɛ'‑, ɛɛ' 'sʋ mɛ ‑ɩn ‑je \"juɛi nʋʋ‑ ");
INSERT INTO wob_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Ɛ 'wlʋa 'o mu ɛ, ‑siɔn' kpa Sesi 'de Selisalɛm ‑wɛe ɛ ‑te' ɔ 'e Kea ‑gbu klaa\" \"jru kpɔ', 'de ɛ 'na : ‑Bo ‑ɩn ‑nɩ Kea 'a \"Ju ɛ, ‑mɛ ‑ɩn ‑fiie\"‑ ‑ma ‑cɛ\" 'de ‑sɔn, 'kaa ɛ 'crɩɩɛ ka : ");
INSERT INTO wob_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Kea a muɛ ɛɛ' \"soa‑wi\" 'tmʋa' ‑wɛe ʋʋ 'je ‑ʋn kwa ‑sɔn i ‑te' 'de ʋʋ 'je ‑ʋn 'sa. ");
INSERT INTO wob_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Ʋʋ 'je ‑ʋn kwa 'ble ‑wɛe ‑ma bɩɛ se ‑tiie' i 'de \"soukpo \"jri. ");
INSERT INTO wob_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","'Sʋ Sesi 'na : Dɛ Kea 'a wlu 'tmʋa ɛ 'naa : ‑Ɩn ‑bo \"jrii 'jeeɛ, ‑ɩn ‑bo ‑ma Tʋ\"bo Kea i ‑tɩɛn'. ");
INSERT INTO wob_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","‑Siɔn' ‑kɔa' Sesi 'a i ‑tɩan' 'de dɩ \"klein ‑nɩa 'mʋa‑ 'ʋn 'sʋ ɔ tɛɛn ɛ o, ‑wɛe ɛɛ fuo nɔ\" jrɛ' ke'wlɛ. ");
INSERT INTO wob_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","‑Ta Sesi a mua Galile de ɛ, ‑mɛ Kea 'a ‑Suu 'a \"ikmaa' \"ji 'de ɔ 'ʋn 'ɛ. Ʋʋa 'tmʋɛ ɔɔ' 'nynɩ \"wɔin‑ ‑ta ‑wee' \"klein. ");
INSERT INTO wob_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Ɔɔ tɔɔ nyʋ dɛ 'de Suifʋ‑wi\" 'a \"jrui 'kɩɩn‑gbi 'dii, nyʋ ‑wee' \"klein a po ɔ ‑tɩ' o. ");
INSERT INTO wob_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Sesi muɛ Nasarɛtɩ ɔ 'bɛɛa \"i de. ‑Kwlewɩ o 'sʋ ɔ pa 'e Suifʋ‑wi\" 'a \"jrui 'kɩɩn‑gbu 'di ka ɔɔ nʋa see ɛ. Ɔ sɔn 'ʋn 'ɛ ‑wɛe ɔ 'je Kea 'a wlu 'dii nʋ. ");
INSERT INTO wob_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","'Sʋ ʋʋ \"nyɩ ɔ Esai 'a 'sbɛ‑ ‑wɛe ɔ ‑gbai' ɛ 'mii, 'sʋ ɔ jɛɛ wlu ‑ɛ ‑crɩɩa' 'de ‑ɛ 'naa : ");
INSERT INTO wob_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","Tʋ\"bo Kea 'a ‑Suu nɩɛ 'ʋn \"kpei, dɛ‑nʋɛ' ɛ poɛ 'ʋn 'cna \"jru, ɛ ‑teeɛ 'ʋn kpɔi\" ‑wɛe 'ɩn 'je ‑pɔia\" ‑tɩ 'tmʋ 'de wɛe nyʋ ‑pee. Ɛ dbo 'ʋn 'ɛ 'de 'ɩn 'je nyʋ ‑nɩa kʋɔnkwla' ‑seie', ‑wɛe nyʋ ‑ʋʋa' 'jea i ɛ, ʋʋa' \"jri 'je 'bai‑ 'de nyʋ ‑nɩa 'e 'kle 'di ɛ, ʋʋ 'je ʋʋa' ‑cɛ\" ‑pee ‑te, ");
INSERT INTO wob_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","‑wɛe 'ɩn 'je nɔ\" ‑ɛ 'di Kea 'jea nyʋ 'saaʋn \"jrii nʋ 'a ‑tɩ' 'tmʋ. ");
INSERT INTO wob_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","'Sʋ Sesi 'fea 'sbɛ i 'de ɔ \"nyɩ ɛ \"jrui 'kɩɩn‑gbu 'a dbonʋi ‑wɛe ɔ ‑te i. Nyʋ \"klein ‑nɩa 'e ‑gbu\" 'di ɛ, ʋʋa ‑gbʋn' ɔ ja ‑snii'. ");
INSERT INTO wob_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","'De Sesi ‑te ʋʋpʋ 'a ‑tɩ' ‑pee 'tmʋa' ‑pʋn\" ɔ 'na : Dɛ ‑crɩɩa' 'de Kea 'a 'sbɛ 'di sese, ‑wɛe aoa 'wlʋa 'wɔan' ‑ta, ɛɛ' wlu tu nyni 'o ‑wɛ‑ ‑sɩan. ");
INSERT INTO wob_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Nyʋ ‑wee' \"klein a poɛ Sesi ‑tɩ' o. Tai' \"maa ʋʋpʋ 'mɛ, dɛ‑nʋɛ' 'saaʋnwlu \"klein ɔɔ 'tmʋa ɩ nmɔɔ 'de ʋʋpʋ 'di wɔn. 'Sʋ ʋʋ 'na : Ɛ se Soseʋ 'a \"ju nɩ mɔ ‑taa ? ");
INSERT INTO wob_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","‑Wɛe Sesi wlu 'de ʋʋ ‑pee ɔ 'na : Aoa muɛ 'ʋn \"nɩɩa ipooa' ka see, ao 'je nʋ : ‑Dɔ'crɔi, ‑ɩn ‑bɔɔ' ‑ma ‑cɛ\" 'ɛ 'wɛ‑. Aoa muɛ 'ʋn ‑pee wlua' ka ao 'je 'nʋ : dɩ \"klein ‑ɩn nʋa 'de Kapɛnaʋm‑kwlɔ 'di ‑wɛe ‑a ‑wɔan ‑ɩn nʋ ɩa' jrɩ' ‑ta ‑ma ‑cɛ\" 'kpa o ‑kwlɔ, ‑a ‑je ‑ʋn 'je. ");
INSERT INTO wob_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","'Sʋ ɔ wlu' ke'wlɛ ɔ 'na : 'Ma 'tmʋ aopʋ tɔ' ‑tɩ, nyɔ se Kea 'a wlu 'kwajaai sɩn 'sɔɔn kpʋʋn due' 'bo ɔɔ' ‑cɛ\" o ‑kwlɔ. ");
INSERT INTO wob_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Ao ‑gbʋn 'nɔ, tɔ' ‑tɩ mɩ 'ɩn nɩa 'o ao ‑pee 'tmʋa'. Dɛ ‑nʋʋa tɛin\", 'de Kea 'a wlu 'kwajaai Eli 'a nɔi\" ɛ, ɛmɛ ‑nɩ ‑tiɔn\" 'nynʋkpae' ‑tuu\"‑tuu ‑nɩ 'e Israɛ‑blʋa \"kpei. ‑Ta \"ni sea dbaa 'de ɛ nʋa ‑sɩn taan 'cʋɩ ‑mɛɛo\"‑ ɛ, ‑wɛe 'mɩɩɛ‑ klaa\" jia 'de 'blʋa‑ ‑wee' \"klein \"kpei ɛ, ");
INSERT INTO wob_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Kea se Eli 'de ʋʋa' due' koʋn ka o dbo, ‑bo ɛ se 'de ‑tiɔn\" 'nynɔ ‑nɩa 'o Sarɛta 'de Sidɔnblʋa \"kpei nɩ ɛ. ");
INSERT INTO wob_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","'De ke'wlɛ, 'de Kea 'a wlu 'kwajaai Elise 'a nɔ\" 'di ɛ, 'jrʋwɛnʋn ‑tuu\"‑tuu ‑nɩ 'e Israɛ‑blʋa \"kpei, 'kaa ʋʋa' due' koʋn ‑gbai' 'a 'wɛ‑ se 'bɔ, ‑bo ɛ se Naaman Siriɛn i nɩ ɛ. ");
INSERT INTO wob_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Nyʋ \"klein ‑nɩa 'e \"jrui 'kɩɩn‑gbu 'di 'wɔan wlu Sesi 'tmʋa 'mʋa‑ 'sʋ 'cɛn ‑gbuu' ɛ ʋʋ wɔin‑. ");
INSERT INTO wob_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Ʋʋ sɔn 'ʋn 'ɛ jakaa‑, ‑wɛe ʋʋ nʋ Sesi i 'de ʋʋ ‑sɔ 'o ‑kwlɔ. Dɛ ʋʋa' ‑kwlɔ nɩa 'o crʋ \"kpei ɛ, ʋʋ kpɔ 'e crʋ \"jru ‑wɛe ʋʋ 'je ɔ ‑fiie\"‑ 'de ‑pouo ‑sɔn. ");
INSERT INTO wob_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","'Kaa Sesi nmaa ʋʋpʋ 'nynɩ i, ɔ e mu. ");
INSERT INTO wob_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Sesi muɛ Kapɛnaʋm 'de Galileblʋa 'a ‑kwlɔ due' 'di ‑wɛe ɔɔ tɔɔ nyʋ dɛ ‑kwlewɩ o. ");
INSERT INTO wob_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Dɩ \"klein ɔɔ 'tmʋa ɩa \"siɛ nyʋ \"i, dɛ‑nʋɛ' ɔɔ wlu' 'de 'kpɩ 'blea' 'ʋn. ");
INSERT INTO wob_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","'Sʋ \"ju due' ‑siɔn' 'ɔ ‑suu nɩa 'e 'ʋn 'de nyʋ \"klu 'de Suifʋ‑wi\" 'a \"jrui 'kɩɩn‑gbu 'di, ɔmɔ ‑kpa' wlu \"jɛi ‑ɔ ‑wɔ\" kpleiin ‑ɔ ‑na : ");
INSERT INTO wob_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","‑Ee'‑, Sesi ‑wlʋa Nasarɛtɩ ɛ, dɛ ‑nɩ 'o ‑ɩn ‑ke ‑a 'nynɩ ɛ‑ ? ‑Ɩn jiɛ ‑aa ‑ma\" i‑saa' ? 'Ɩn 'je kan' 'mɛ ka ‑ɩn ‑nɩa Kea 'a i ‑kwɛ‑ju ɛ. ");
INSERT INTO wob_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","'Sʋ Sesi ‑cɛ' ‑suusaʋn \"bli ɔ 'na : Ɛ \"mu wɔn, ɛ 'wlʋ 'e \"ju ‑nɔ 'ʋn ! ‑Suusaʋn ‑tuɛ\" \"ju ‑nɔ 'blʋɔ 'bo nyʋ ‑kwea 'mʋa‑ ‑wɛe ɛ 'wlʋ 'de ɔ 'ʋn. 'Kaa ɛ se ɔ i ‑kuuan mɔ \"pɩ. ");
INSERT INTO wob_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Nyʋ \"klein ‑jea ɛɛ' ‑ta a, ‑crima kpʋn ʋʋpʋ 'mɛ. 'Sʋ ʋʋa wlu' 'de ba ‑pee due 'due ʋʋ 'na : Wlu ‑jɛ ‑mɛ 'de 'a 'nynɩ wɛ‑ ‑sɩan kaa‑ ? Ɔɔ ‑teɛ' ‑siisaɩn ‑klan\" \"kpei ‑wɛe ɩa \"si \"kpae'. ");
INSERT INTO wob_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Ɛ 'wlʋa 'o mu ɛ, Sesi 'a 'nynɩ \"siiɛ ‑ta ‑wee' \"klein \"i. ");
INSERT INTO wob_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Sesi ke ɔɔ' klai\" nynuu 'wlʋa 'e \"jrui 'kɩɩn‑gbu 'di ɛ, ʋʋ muɛ 'de Simɔ o ‑gbu\". ‑Ta ʋʋa muua ‑mɛ ɔɔ' \"bianynɔ 'pɛn i, ʋa' \"jru ‑a ‑baia' ɛ kmai\". ‑Wɛe ʋʋ bae Sesi i 'de ʋa' ‑tɩ' 'ʋn. ");
INSERT INTO wob_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","'Sʋ Sesi 'kpaa 'bo ʋ ‑pʋn\" ‑wɛe ɔ wlu 'wɛ‑ ‑pee 'de \"ikmaa' 'ʋn, 'sʋ ɛ 'bɔɔ. 'Bo ɛ \"si ʋ sɔn 'ʋn ʋ pi dɛ, 'de ʋ \"nyɩ ʋʋpʋ. ");
INSERT INTO wob_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","'Jrʋ blua i ‑kwie\" ka ʋʋ ja nyʋ 'wɛ‑ 'ɛ kpɛ ‑tuu\"‑tuu kpʋan 'de Sesi o. ‑Wɛe ɔ ‑te' ʋʋpʋ kwa \"jru due 'due, ɔ 'bɔɔ‑ ʋʋpʋ 'a 'wɛ‑. ");
INSERT INTO wob_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","‑Siɔn 'ɔ ‑sii ‑wlʋ 'e 'wɛ‑nʋʋ ‑tuu\" 'ʋn ‑ke, ɩa \"wɔɔ' ɩ 'na : ‑Ɩn ‑nɩɛ Kea 'a \"Ju ‑o. 'Kaa Sesi se ɛ \"i nɩ ɩ 'je ɛɛ' dɛ tu 'tmʋ 'de nyʋ ‑pee, ɛmɛ ‑tɩ ɔ wlu ‑siisaɩn ‑pee 'de \"ikmaa' 'ʋn ɔ 'na : Ɩ \"mu wɔn ! Ɔ ‑sɩ wlu \"wɔin, dɛ‑nʋɛ' ɩ 'je kan' 'mɛ ka ɔ nɩa Klisɩ ɛ. ");
INSERT INTO wob_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","‑Sɔn' wɔin\" 'sʋ, Sesi 'wlʋ 'o ‑kwlɔ 'mɛ, ɔ muɛ ‑ta nyɔ sea nɩ ɛ. 'sʋ nyʋ ‑tuu\"‑tuu ‑teɛ ɔɔ' i ‑pɔan' ‑pʋn\", ʋʋ jɛɛ ɔ ʋʋ se ɛ \"inɩ ɔ 'je ʋʋpʋ o tɛɛn‑. ");
INSERT INTO wob_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","'Kaa Sesi wluɛ ʋʋpʋ ‑pee ka ɔ 'na : Ka Kea nʋa nyʋ 'blesʋn ɛ, 'ɩn 'je ɛɛ' ‑pɔia\" ‑tɩ 'tmʋ ‑o 'de ‑kwlɛ jrɩ' 'dii ‑ke, ɛmɛ ‑tɩ Kea dbo 'ʋn. ");
INSERT INTO wob_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","‑Wɛe ɔɔ mu Suifʋ‑wi\" 'a \"jrui 'kɩɩn‑gbi 'dii 'de ɔɔ 'tmʋ Kea 'a ‑tɩ'. ");
INSERT INTO wob_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","'Wɩ jrɛ' o Sesi nɩɛ 'o Senesarɛtɩ ‑ni wɔin\", 'bomɔ nyʋ ‑tuu\"‑tuu ‑gbae' ɔ 'de woi, 'de ʋʋa \"tuun ba i, ‑wɛe ʋʋa po Kea 'a wlu doin\" o. ");
INSERT INTO wob_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Ɔ 'jeɛ ‑kwɛɛ\" 'bo 'kpʋʋ ‑kwlɩ\", 'saipoʋn ‑wlʋ 'de ɩ 'di, ‑wɛe ‑ʋʋa wɔɔ ʋʋa' 'sai‑. ");
INSERT INTO wob_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","'Sʋ Sesi 'ja 'e ɩa' due' 'di, ‑mɛ nɩɛ Simɔ Piɛi 'a ‑nɛ ‑o, 'de ɔ 'na : ‑A ‑tɛɛn 'kpʋʋ kɩɩn ke dɛ‑saan\"‑. ‑Wɛe ɔ ‑te i 'de ‑kwɛɛ\" 'di, 'de ɔɔ tɔɔ nyʋ dɛ. ");
INSERT INTO wob_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Sesi ‑kɔa' nyʋ dɛ tɔɔa' 'sʋ, ɔ wluɛ Simɔ ‑pee ɔ 'na : ‑Ɩn ‑kɩɩn' ‑kwɛɛ\" 'de \"nibie' fɔ o ‑wɛe ao 'je aoa' 'sai‑ po. ");
INSERT INTO wob_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","'Sʋ Simɔ 'na : 'Ma dɛtɔɔi, ‑a po 'sai‑ 'mɛ ‑ta 'de \"maʋ'wɩ ‑wee' \"klein 'di, ‑a se dɛ jrɛ' ‑sa, 'kaa 'de ‑ma wlui\" ɛ, 'ma jiɛ 'sai‑ poa'. ");
INSERT INTO wob_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Ʋʋ ‑fii\" a 'sai‑ ɛ, ɛ kpʋɛn ‑smii' ‑tuu\"‑tuu. 'Sʋ ʋʋa' 'sai 'a 'jɔ ɔ cɛn'. ");
INSERT INTO wob_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","'Sʋ ʋʋ 'daa‑ ʋʋa' \"dɛi‑wi\" ‑nɩa 'e ‑kwɛɛ\" jrɛ' 'di \"i ‑wɛe ʋʋ 'je ʋʋpʋ sʋn o poa' ji. Ʋʋa' \"dɛi‑wi\" ‑nʋ jia, ʋʋ \"jiiɛ ‑kwɛɛ\" ‑nɩa 'sɔɔn ‑smii'‑, 'sʋ ɩa pa \"ni ‑sɔn. ");
INSERT INTO wob_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Simɔ Piɛi ‑gbʋan dɩ ‑nʋʋa 'mʋa‑ ja 'sʋ, ɔ \"siiɛ‑ 'kɔi‑ i 'bo Sesi \"juɔi ‑wɛe ɔ 'na : Tʋ\"bo, ‑ɩn ‑tɛɛn 'ʋn kɩn, dɛ‑nʋɛ' 'ɩn nɩɛ dɛsaʋn nʋi ‑o. ");
INSERT INTO wob_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Dɛ‑nʋɛ' ɛ tai' \"maa Piɛi ke ɔɔ' \"dɛi‑wi\" 'mɛ 'de ‑smii' ʋʋ ‑sa 'mʋa 'a ‑tɩ' 'ʋn. ");
INSERT INTO wob_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Dɛ due' ‑nɛ mɛ ‑nʋʋɛ Sebede 'a \"nynuu‑ Sakɩ ke San \"jrii, ʋʋ ke Simɔ ɔ nʋɛ dbo due'. 'Sʋ Sesi wlu' 'de Simɔ ‑pee ɔ 'na : Faʋn 'bo ‑ʋn nʋɛ, 'bode ɛ, ka ‑ma ‑sa' ‑smii' ɛ, 'kamɔ ‑ɩn 'je nyiɔ ‑cri' 'de ‑ɩn ‑je 'ʋn ja. ");
INSERT INTO wob_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Ʋʋ kpa ‑kwɛɛ\" 'bo 'kpʋʋ ‑kwlɩ\" 'sʋ, ʋʋ sie ʋʋa' dɩ ‑wee' \"klein 'mɛ, ‑wɛe ʋʋ bla 'o Sesi 'de. ");
INSERT INTO wob_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Sesi nɩɛ 'o ‑kwlɔ due' 'di, 'bomɔ 'jrʋwɛ‑nʋi due' 'jee ɔ. 'Sʋ ɔ tba \"jua i 'bo 'blʋɔ‑ ‑wɛe ɔ bae Sesi i 'de ɔ 'na : 'Ma 'blei, ‑bo ‑ɩn ‑nɩɛ \"i ɛ, ‑ɩn ‑beeɛ' ‑ɩn ‑je 'ma 'wɛ‑ 'bɔɔ‑ 'ɩn 'je 'pepe nɩ‑. ");
INSERT INTO wob_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","'Sʋ Sesi kpa sʋn, ɔ blɔ \"i 'de ɔ 'na : 'Ɩn nɩɛ \"i 'mɛ, ‑ɩn ‑nɩ 'pepe ! 'Bo ɛ \"si ɔɔ' 'jrʋwɛ‑ je 'bɔ. ");
INSERT INTO wob_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","‑Wɛe Sesi cri ɛɛ' ‑cɩɛ 'de ɔ 'na : ‑Ɩn ‑bo ɛ 'tmʋɛ 'de nyɔ jrɔ' ‑pee. ‑Ɩn mu ‑ɩn ‑je ‑ma ‑cɛ\" to‑ 'de Kea 'a 'sraa ‑sai o, 'de ‑ɩn ‑je 'sraa ‑sadɛ ja ka Moisɩ 'a kɛ' 'da, ‑wɛe ka ‑ma 'wɛ‑ 'bɔa nyʋ ‑wee' \"klein 'je ɛ juo‑. ");
INSERT INTO wob_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","'Kaa Sesi 'a 'nynɩ \"siiɛ‑ ‑ta ‑wee' \"klein \"i, 'sʋ nyʋ ‑tuu\"‑tuu a jiɛ ɔɔ' wlu doin\" o poa' 'de ɔ 'je ʋʋpʋ 'a 'wɛ‑ 'bɔɔ‑ ‑ke. ");
INSERT INTO wob_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","'Sʋ ɔmɔ ‑saa kɩn 'de ʋʋpʋ ‑pʋn\" ɔ muɛ ‑ta nyɔ jrɔ' sea nɩ ‑wɛe ɔɔ bae Kea. ");
INSERT INTO wob_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","'Wɩ jrɛ' o ɛ, Sesi a tɔɔ nyʋ dɛ. Fariseɛn‑wi\" ke kɛ' wɔ‑saʋn ji' ʋʋ ‑teɛ i, ʋʋ 'wlʋɛ Galile 'a ‑kwlɛ ke, Suide 'a ‑kwlɛ 'dii, ɛ ke 'o Selisalɛm ke‑. Tʋ\"bo 'a \"ikmaa' a poɛ \"jri \"kpae 'de Sesi 'a nyʋ 'a 'wɛ‑ 'bɔa 'ʋn. ");
INSERT INTO wob_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","'Sʋ nyʋ jrʋ' ‑blee' klɔɔi due 'sai‑ 'di ‑ʋʋ ji. Ʋʋa ‑pɔn ʋʋ 'je ɔ 'e ‑gbu\" 'di paa‑, ‑wɛe ʋʋ 'je ɔ i ‑te' 'bo Sesi \"juɔi. ");
INSERT INTO wob_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","'Kaa 'de nyiɔpʋ 'a \"i ‑tia' 'ʋn ɛ, ‑ta ʋʋ 'jea ‑sii‑ 'bo se nɩ‑. 'Sʋ ʋʋ 'ja 'e ‑gbu\" \"kpei, ‑wɛe ʋʋ ‑sa ‑po\". 'Bomɔ ʋʋ jaa klɔɔi 'a 'sai‑. 'De ʋʋ \"sii ɔ i 'bo nyʋ ‑kwea 'bo Sesi \"juɔi. ");
INSERT INTO wob_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Sesi 'jea nyʋ ‑nɩa 'mʋa 'a dɛ tɔ' \"itbaa' 'sʋ, ɔ wlu' 'de klɔɔi ‑pee ɔ 'na : ‑Ma dɩsaɩn ‑kwɛ'. ");
INSERT INTO wob_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Kɛ' wɔ‑saʋn ke Fariseɛn‑wi\" ‑teɛ 'mii wlua' ‑pʋn\" ʋʋ 'na : \"Ju ‑nɔ ‑mɔɔ dooa Kea 'a 'nynɩ kan' ‑mɔ ɛ. Nyɔ ‑beeɛ' ‑ɔ ‑je nyʋ 'a dɩsaɩn ‑kwɛ' ‑bo ɛ se Kea 'a 'sʋ nɩɛ. ");
INSERT INTO wob_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Ka ʋʋ nɩa tɔ' ‑nɛ 'ɛ inaa' a, Sesi 'je kan' 'mɛ. 'Sʋ ɔ wlu' 'de ʋʋpʋ ‑pee ɔ 'na : Dɛɛ‑tɩ aoa' tɔ' nɩ kan' 'de ao pɛe o ɛ‑ ? ");
INSERT INTO wob_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","‑Jɛ wɛ‑ ‑kɔan\" \"jrii ɛ‑ ? ‑Ɩn ‑wlu ‑ɩn ‑na ‑ma dɩsaɩn ‑kwɛ' ‑ae, ‑aee' ‑ɩn ‑na ‑ɩn sɔn 'ʋn ‑je naa‑ ? ");
INSERT INTO wob_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","'Ɩn nɩɛ \"i ao 'je ɛ juo‑ ka 'mɔ ‑nɩa nyiɔ 'ɔ \"Ju 'ɩn 'blea \"ikmaa' 'de 'blʋa‑ \"kpei ‑ta, 'ɩn 'jea nyʋ 'a dɩsaɩn ‑kɔ' ɛ, ɛmɛ ‑tɩ 'ma wlu 'de klɔɔi ‑pee : ‑Ɩn sɔn 'ʋn, ‑ɩn ‑duo\" ‑ma \"kpei 'pɛndɛ 'ʋn, ‑ɩn ‑je 'de ‑ʋn ‑wɔin\" mu. ");
INSERT INTO wob_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","'Bo ɛ \"si \"ju ‑nɔ je 'ʋn sɔn ‑cɛɛn'‑ 'bo nyʋ ‑wee' \"klein \"jri \"kpei, ɔ je ɔɔ' \"kpei 'pɛndɛ 'ʋn \"duo‑, ɔ je 'de ɔ wɔin\" de mu 'de Kea 'a 'nynɩ \"i 'bɛɛ‑ 'ʋn. ");
INSERT INTO wob_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Tai' \"maa nyʋ ‑wee' \"klein 'mɛ 'sʋ ʋʋa 'bɛɛ‑ Kea 'a 'nynɩ \"i ‑ke. Faʋn \"ji 'de ʋʋpʋ 'ʋn 'ɛ, ‑wɛe ʋʋa wlu ʋʋ 'na : Dɛ ‑a ‑jeea' \"jriɛ‑ ‑sɩan ‑ta ‑mɛ ‑siɛ' sʋn i o. ");
INSERT INTO wob_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","‑Mɛ 'wlʋa 'o ‑jei\" ɛ, Sesi \"sia \"kpae 'sʋ ɔ jɛɛ 'wɛi‑sai due' nyʋ a 'daa Lefi ‑ɔ ‑te i 'de ɔɔ' 'wɛi‑sagbu 'di. Sesi wlu' 'de ɔ ‑pee ɔ 'na : Lefi, ‑ɩn ji, ‑ɩn ‑ke 'ma ‑a ‑je na‑ ! ");
INSERT INTO wob_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","'Sʋ Lefi sɔn 'ʋn 'ɛ, ɔ sie ɔɔ' dɩ ‑wee' \"klein 'mɛ, ‑wɛe ɔ bla 'o Sesi 'de. ");
INSERT INTO wob_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Ɛ 'wlʋa 'o mu ɛ, Lefi 'da Sesi dɛdi ‑tɩ 'de ɔ o ‑gbu\". 'Wɛi ‑saʋn ‑tuu\" ke nyʋ jrʋ' ke ʋʋ nɩɛ dɛ dia' ‑tadue. ");
INSERT INTO wob_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Fariseɛn‑wi\" ke kɛ' wɔ‑saʋn a wluuɛ klai\" nynuu 'de i, ʋʋ wluɛ ʋʋpʋ ‑pee ʋʋ 'na : Dɛɛ‑tɩ ao ke 'wɛi‑sanyʋ ke nyiɔpʋ ‑saɩn jrʋ' a dii ‑tadue, 'de aoa 'naa ‑kaun\" due' 'di ɛ‑ ? ");
INSERT INTO wob_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","'Bomɔ Sesi \"duo wlu 'ʋn ɔ 'na : Nyʋ ‑a ‑ta sea pooa ʋʋa' ‑pɔn ‑dɔ'crɔi i, 'kaa nyʋ 'wɛ‑ ɛ nʋa ʋʋpʋ ‑a mu ‑dɔ'crɔ 'di. ");
INSERT INTO wob_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","'Ɩn se kplɩn fai\" poo‑tɩ 'tmʋa' ji 'de \"i \"isrɛnyʋ ‑pee, 'kaa 'ɩn jiɛ dɛsaʋnʋʋn 'a ‑tɩ'. ");
INSERT INTO wob_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Ʋʋ wlu' 'de Sesi o ʋʋ 'na : San 'a klai\" nynuu ke Fariseɛn‑wi\" 'a klai\" nynuu a 'bɔ wɔn, ʋʋa baeɛ Kea jeejee, 'kaa ‑ma ‑nɩ klai\" nynuu 'a nʋ kan', ʋʋa di', ʋʋa 'naa. ");
INSERT INTO wob_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Sesi wlu' 'de ʋʋpʋ ‑pee ɔ 'na : Nyʋ ‑jia' ba \"blitia 'a ‑kɔ' ‑sɔn ɛ, ao 'bɛɛ‑ ao 'je ʋʋpʋ wɔn 'bɔɔ‑ ? 'De ‑mɛ 'kamɔ 'nynɔjei ke ʋʋpʋ ‑te ii ? ");
INSERT INTO wob_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","'Wɩ jrɩ' a muɛ nynia' ‑wɛe 'nynɔjei 'je 'de ʋʋpʋ \"klu 'wlʋ. 'De ‑mɩ 'a 'wɩ tu 'di ɛ, ʋʋa muɛ wɔn 'bɔa'. ");
INSERT INTO wob_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Sesi pooɛ ‑tɩ' \"i ka ke'wlɛ ɔ 'na : Nyɔ se ɛ 'bɛɛ‑ ɔ 'je \"bai dee 'fɔ ‑pʋn\" ‑sa, ‑wɛe ɔ 'je ɛ 'o \"bai ‑gbau\" ‑pʋn\" \"paa‑. ‑Bo ɛ nɩ kan' a, ‑mɛ ɔ dooa \"bai dee 'mɛ, 'de ɛɛ' 'fɔ ‑jɛ ɔ \"paa‑ 'o \"bai ‑gbau\" ‑pʋn\" ɛ, ‑mɛ ke ɛ se ba kpʋn i. ");
INSERT INTO wob_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","'De nyɔ se ɛ 'bɛɛ‑ ke'wlɛ, ɔ 'je nmɔ dee 'de bi ‑gbai\" 'di po. ‑Bo ɛ nɩ kan' ‑mɔ ɛ, ‑mɛ nmɔ ɔ muɛ bi ‑gbau\" waa', ɛ 'je i 'wla 'de bi ‑wee' 'je idooa‑. ");
INSERT INTO wob_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","'Kaa 'de bi dee 'di 'bomɔ nyɔ 'je nmɔ dee po. ");
INSERT INTO wob_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","'De ‑bo nyɔ 'na nmɔ ‑kwlea 'e jae 'di 'bode ɛ, ‑mɛ ɔɔ' doin\" se 'dɩɩnmɔ inɩ‑, dɛ‑nʋɛ' ɔ 'na nmɔ ‑kwlea 'e jae 'di mɛ ‑nmɔi\". ");
INSERT INTO wob_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","'Wɩ jrɛ' o 'bo ‑kwlewɩ \"kpei, ʋʋa 'daa \"i‑saa ‑nɛ 'ɛ 'sɔɔn ‑nɛ, Sesi a cɛn kplaa ‑kle 'dii ‑tie\" 'sʋ ɔɔ' klai\" nynuu a cɩn' 'de ʋʋa sʋʋɩn 'kwai ‑wɛe ʋʋa di. ");
INSERT INTO wob_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","'Sʋ Fariseɛn‑wi\" 'a jrʋ' wlu' ka ʋʋ 'na : Dɛɛ‑tɩ aoa nʋ dɛ ‑sea' nʋ ka nɩ 'bo ‑kwlewɩ \"kpei ɛ‑ ? ");
INSERT INTO wob_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","'Sʋ Sesi wlu ʋʋpʋ ‑pee ka ɔ 'na : ‑Ta 'mɩɩɛ‑ nʋa Dafidɩ ke ɔɔ' 'cɛ‑wi\" ɛ, dɛ ɔ nʋa ao se ɛ 'dii nʋ 'de Kea 'a 'sbɛ 'dii ? ");
INSERT INTO wob_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Ka ɔ pa 'e Kea ‑gbu klaa\" 'di ‑wɛe ɔ \"dua ‑di'pɛn ‑nɩa 'e 'ʋn ɔ di ɛ, 'de ɔ \"nyɩ ɛɛ' jrɛ' ɔɔ' 'cɛ‑wi\" ‑ke ɔɔ na ao seɛ juuo‑, 'de ‑mɛ 'kamɔ nyɔ jrɔ' se ɛ 'bɛɛ‑ ɔ 'je ɛɛ' ‑di'pɛn tu di, ‑bo ɛ se 'sraa ‑saʋn 'a 'sʋ nɩ ɛ ? ");
INSERT INTO wob_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","‑Wɛe ɔ 'na : 'Mɔ nyiɔ 'ɔ \"Ju, 'mɔ ‑nɩ ‑kwlewɩ mɛ 'ɛ ‑cɛ' 'kpa 'a jei‑. ");
INSERT INTO wob_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Ɛ nʋʋɛ', 'bo ‑kwlewɩ jrɛ' \"kpei Sesi paa 'e ʋʋa' Kea ‑gbu 'di ‑wɛe ɔɔ tɔɔ nyʋ Kea 'a ‑tɩ'. 'Demɔ \"ju due' ‑ɔɔ diansʋn 'mɛa nɩ‑. ");
INSERT INTO wob_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Kɛ' wɔ‑saʋn ke Fariseɛn siɛ Sesi \"jriɛ‑ o ‑wɛe ‑bo ɔ 'bɔɔ‑ nyʋ 'a 'wɛ‑ 'bo ‑kwlewɩ \"kpei, 'de ʋʋ 'je kan' 'je. Dɛɛ‑tɩ ʋʋ nʋa kan' a, ɛmɛ ‑nɩ ʋʋa ‑pɔn Sesi 'a ‑kɔ i 'de ʋʋ 'je ɔ ‑tɩ' \"kpei 'nɛɛ‑. ");
INSERT INTO wob_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","'Kaa Sesi juo ʋʋpʋ 'a tɔ' 'mɛ. Ɔ wluɛ \"ju ‑ɔɔ sʋn jɛa 'soɛ ‑pee ɔ 'na : ‑Ɩn sɔn 'ʋn, ‑ɩn ‑je 'o nyʋ ‑kwea jii ‑ta ! 'Sʋ ɔ sɔn 'ʋn 'ɛ ‑wɛe ɔ jii 'o. ");
INSERT INTO wob_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","'Sʋ Sesi 'na 'ma ‑teeɛ' aopʋ dɛ due' i, ka Kea 'a kɛ 'daa‑ ? Nyʋ 'bɛɛ 'bo ‑kwle ‑wɩ \"kpei 'ee ɔ 'e dɛ 'dɔe nʋʋ ‑ɩn\" dɛsaʋn nyʋ 'bɛɛ' ɔ 'e nyʋ 'pʋʋ‑ ‑ɩn\" ɔ 'jeɔ ja ‑gbʋn ɔ 'e mɛɛ ? ");
INSERT INTO wob_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","'Sʋ Sesi a pleeɛ ʋʋpʋ \"jriɛ \"kpei‑, ‑wɛe ɔ wlu 'de \"ju ‑nɔ ‑pee ɔ 'na ‑Ɩn sro sʋn. 'Kamɔ ɔ nʋ ‑cɛɛn'‑, 'sʋ ɔɔ' sʋn nɩɛ 'pepe. ");
INSERT INTO wob_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","'Kaa dɛ Sesi nʋa 'mʋa‑ ɛɛ' 'cɛn ‑nɩa 'e ʋʋpʋ 'ʋn ɛ kmai\". 'Sʋ ʋʋ ‑teɛ ba i ‑teea' ‑pʋn\" 'de dɛ ʋʋ 'jea Sesi \"jrii nʋ 'a ‑tɩ' 'ʋn. ");
INSERT INTO wob_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","'De ɛɛ' nɔ\" tu 'di, Sesi muɛ 'e crʋ \"kpei, ‑wɛe ɔ bae Kea 'de \"maʋ' wɩ ‑wee' \"klein 'di. ");
INSERT INTO wob_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","‑Sɔn' ‑sɩan', ɔ 'da ɔɔ' klai\" nynuu ‑wee' 'mɛ, ‑wɛe ɔ ‑sa 'de ʋʋpʋ \"klu nyʋ 'a ‑puue 'jɔ 'sɔɔn, 'de ɔɔ 'daa‑ ‑wi\" ‑mʋ dboʋn. ");
INSERT INTO wob_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","nyʋ 'a ‑puue 'jɔ 'sɔɔn ‑nʋ ʋʋa' 'nynɩ ka : Simɔ ‑ɔ ‑tuua\" Piɛi ‑nynɩ ke ɔɔ' \"dei Ancre ke, Sakɩ ke San ke, Filipʋ ke Batelemi ke, ");
INSERT INTO wob_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Matie ke Toma ke, Alfe 'a \"ju Sakɩ ke Simɔ ‑ɔɔ \"kpei ‑tenynɩ nɩa Selɔtɩ ke, ");
INSERT INTO wob_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Sakɩ 'a \"ju Suidɩ ke Suida Isikario ‑jɔ ‑kpa Sesi 'a 'de toi ke‑. ");
INSERT INTO wob_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Sesi ke ɔɔ' klai\" nynuu 'wlʋɛ 'e crʋ \"kpei ʋʋ \"siɛ i, ‑wɛe ʋʋ nyna i ‑ta ‑nɩa pɛɛpɛɛ, 'bomɔ ɔ jɛɛ klai\" nynuu jrʋ' ‑sia de ke nyʋ ‑tuu\"‑tuu ke‑. Ʋʋa' nyʋ tu 'wlʋɛ 'o Selisalɛm ke Suideblʋa ‑wee' \"kpei‑, ‑wɛe jrʋ' 'wlʋ 'e Tii ke Sidɔn ‑bɔɔa' 'e 'tɔniɛ ‑kwlɩ\" fɔ o ɛ. ");
INSERT INTO wob_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Ʋʋ jiɛ ɔɔ' wlu doin\" o poa' ‑wɛe ɔ 'je ʋʋpʋ 'a 'wɛ‑ 'bɔɔ‑. Nyʋ \"klein ‑siisaɩn a ‑tua\" 'kle 'de ɛ, ɔ ‑seie' ʋʋpʋ 'mɛ 'de ɩ 'kwa ‑ke. ");
INSERT INTO wob_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Nyʋ ‑wee' \"klein a ‑pɔn Sesi 'a \"iblaa 'a ‑kɔ i, dɛ‑nʋɛ' \"ikmaa' jrɛ' ‑ɛɛ ‑wlʋ 'de ɔ 'ʋn ‑wɛe ‑ɛɛ ‑bɔɔ' ʋʋ ‑wee' \"klein 'a 'wɛ‑. ");
INSERT INTO wob_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Sesi ‑gbʋan ɔɔ' klai\" nynuu \"kpei ɛ ɔ 'na : Aomɔ ‑ɔɔ' 'daa‑ ɔɔ' ‑cɛ\" dɛwɔnɩʋn, ao nʋ 'mʋa‑, dɛ‑nʋɛ' Kea 'a 'beɔdɛ nɩɛ aoa' dɛ ‑o. ");
INSERT INTO wob_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Aopʋ 'mɩɩɛ‑ ɛ nʋa 'de kaanwɩ 'di ɛ, ao nʋ 'mʋa‑, dɛ‑nʋɛ' aoa muɛ dboa' 'de nya. Aopʋ ‑nɩa 'e ‑fɩn\" 'a 'ʋn kaan, ao nʋ 'mʋa‑, dɛ‑nʋɛ' aoa muɛ 'kɛɛa 'de nya. ");
INSERT INTO wob_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","‑Bo nyʋ 'nyɛ aopʋ 'ʋn, ‑bo nyʋ 'bɔ aopʋ, ‑bo nyʋ a sea ao ‑cree\"‑, ‑bo ʋʋa sea aoa' 'nynɩ ‑flɛɛn', ‑wɛe ʋʋa sea ao kpɛɛn' nyʋ 'daa‑ 'de 'mɔ nyiɔ 'ɔ \"Ju 'a ‑tɩ' 'ʋn ɛ, ‑mɛ aopʋ nʋ 'mʋa‑ ! ");
INSERT INTO wob_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Ao 'di nmɔ wɔn 'de ɛɛ' 'wɩ tu 'di, ‑wɛe ao 'je dee 'de 'mʋa‑ 'ʋn, dɛ‑nʋɛ' aoa' 'dɔe klaa\" ‑te ao 'dei 'de jaʋn 'di. Dɩ ʋʋa nʋa aopʋ \"jrii ɛ, ʋʋ \"bo ‑wi\" nʋɩ' ‑ke 'de Kea 'a wlu 'kwajaaʋn ‑nɩa tɛin\" ‑pee. ");
INSERT INTO wob_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","'Kaa ɛɛ muɛ \"nmia‑tɩ nɩa' 'de aopʋ ‑nɩa \"wliiɛjeʋn 'a ‑tɩ' 'ʋn, dɛ‑nʋɛ' ao 'je aoa' ‑nɩ 'dɔe ‑wɛ‑ 'de‑. ");
INSERT INTO wob_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Ɛɛ muɛ \"nmia‑tɩ nɩa' 'de aopʋ dboa' dɩ ‑wee' 'ʋn 'de kaanwɩ 'di 'a ‑tɩ' 'ʋn, dɛ‑nʋɛ' 'mɩɩɛ‑ ɛ muɛ aopʋ nʋa'. Ɛɛ muɛ \"nmia‑tɩ nɩa' 'de aopʋ ‑ɔɔ ‑keea' 'de kaanwɩ 'di 'a ‑tɩ' 'ʋn, dɛ‑nʋɛ' aoa muɛ 'kwɛ‑ paa', ‑wɛe ao 'je \"miini 'na. ");
INSERT INTO wob_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Ɛ nɩɛ \"nmia‑tɩ 'de aoa' ‑tɩ' 'ʋn ‑bo nyʋ ‑wee' \"klein a sea aoa' 'nynɩ 'dɔe \"wɔin‑ 'tmʋ ɛ, dɛ‑nʋɛ' 'kamɔ ʋʋ \"bo ‑wi\" nʋ 'de weepoʋn 'a ‑kewɛ‑wi\" ‑pee ‑ke. ");
INSERT INTO wob_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","'Kaa 'ma 'tmʋ aopʋ 'mɛ, ao ‑ɔɔ poa 'ma wlu doin\" o ɛ, ao kma aoa' tʋnyʋ 'a ‑tɩ' ! Ao nʋ nyʋ ‑ʋʋ ‑nyɛ aopʋ 'ʋn dɛ 'dɔe \"jrii ! ");
INSERT INTO wob_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Ao po nyʋ ‑ʋʋa pooa aopʋ ‑soo' o \"diwan ! Ao bae nyʋ ‑ʋʋa ‑tua\" aopʋ 'kle 'a baea' ! ");
INSERT INTO wob_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","‑Bo nyɔ po ‑ʋn 'kpa doun\" mɔ 'de ɛ, ‑ɩn ‑to 'e doun\" 'a 'fɔ due' ‑sia 'o mu ‑ke ‑wɛe ɔ 'je 'o 'kpa po. ‑Bo nyɔ \"duo ‑ma \"jiiɛ‑ 'ʋn ɛ, ‑ɩn ‑bo ɔ ‑je de kaan 'de ‑ma \"bai 'a 'ʋn \"duo ‑tɩ 'ʋn ‑ke. ");
INSERT INTO wob_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Nyɔ \"o nyɔ ‑teea' ‑ʋn dɛ i ɛ, ‑ɩn ‑nyɩ\" ɔ. ‑Bo nyɔ \"duo ‑ma dɛ 'ʋn, ‑ɩn ‑bo ɛ i ‑teeɛ' 'de ɔ o. ");
INSERT INTO wob_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Dɛ aoa ‑pɔan nyʋ 'jea aopʋ \"jrii nʋ ɛ, ɛmɛ ao 'je nʋ 'de nyʋ ‑pee. ");
INSERT INTO wob_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","Nyʋ ‑kma aoa' ‑tɩ' ɛ, ‑bo ao kma ʋʋpʋ 'a 'sʋ 'a ‑tɩ' 'ee, ‑mɛ dɛ jrɛ' wɛ‑ ‑pooɛ fai\" ɛ‑, ‑wɛe ‑ɛɛ sɛ' Kea 'je aopʋ po ɛ‑ ? Nyʋ ‑sea' Kea juo ɛ, 'kamɔ ʋʋa' ba 'a ‑tɩ' kmaa' nɩ ‑ke. ");
INSERT INTO wob_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Nyʋ ‑ʋʋa nʋa ao 'dɔe \"jrii ɛ, ‑bo aoa sea ʋʋa' 'sʋ 'dɔe \"jrii nʋ 'ee, ‑mɛ dɛ jrɛ' ‑wɛ ‑pooɛ fai\" ɛ‑, ‑wɛe ‑ɛɛ 'sɛ Kea 'je ao po ɛ‑ ? 'Kamɔ nyʋ sea Kea juo a nʋ ‑ke. ");
INSERT INTO wob_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","'De ‑bo ao po nyʋ ao 'jea dɛ ‑pʋn\" 'je 'a 'sʋ kpan' 'ee, ‑mɛ dɛ 'dɔe nʋa' ‑wɛ ‑nɩ 'e ‑mɛ 'ɛ ‑kɔ 'di ɛ‑ ? Nyʋ ‑sea' Kea juo ɛ, ʋʋa' 'sʋ a poɛ ba kpan' ‑ke. ");
INSERT INTO wob_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","'Kaa aopʋ mɔ ɛ, ao kma aoa' tʋnyʋ 'a ‑tɩ', ao nʋ dɛ 'dɔe ! ‑Bo ao po nyʋ kpan' a ‑mɛ ao 'bo dɛ ɔ 'jeɛ \"kpei ‑te' 'a tɔ' i naa. ‑Bo ɛ nɩ kan' a, ‑mɛ aoa' 'dɔe a muɛ \"i 'bɛa' ‑wɛe ao 'je Kea ‑nɩa 'e jaʋn 'di 'a \"nynuu‑ nɩ, dɛ‑nʋɛ' ɛɛ' Kea tu nmɔ 'di wɔn 'de ‑kwlʋnyniʋn ke 'diwɔnyniʋn ‑pee. ");
INSERT INTO wob_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","'Di wɔn nmɔa' \"ji 'de aopʋ 'ʋn ka ɛ \"jia 'de ao \"bo Kea 'ʋn ɛ. ");
INSERT INTO wob_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","Ao 'bo ba 'a 'pee 'jeɛ, ‑wɛe Kea je aoa' 'pee 'je ‑ke, ao 'bo nyʋ 'pee kpʋʋɛn, ‑wɛe Kea je ao 'pee kpʋʋn ‑ke. Ao ‑seea' ba 'a wlu \"kpei‑ ‑wɛe Kea 'je aoa' dɛsaʋn ‑kɔ'. ");
INSERT INTO wob_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Ao \"nyɩ nyʋ dɛ ‑wɛe Kea 'je ao dɛ \"nyɩ. Dɩ Kea a mu ao \"nyɩa' ɩa muɛ \"kpei‑ dua' ‑wɛe ɩ 'je dɛ \"ji, 'de ɩ 'je ‑sɔn 'wla, ‑wɛe ɩ 'je aopʋ i siie‑. 'Kaa ‑ta ao dbaa dɛ ‑wɛe ao \"nyɩa nyʋ ɛ, 'bomɔ Kea 'je dɛ dbaa‑ ‑wɛe ɛ 'je ao \"nyɩ ‑ke. ");
INSERT INTO wob_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","'Bomɔ Sesi poo ‑tɩ' \"i ka ɔ 'na : \"dɔi 'bɛɛ' ɔ 'je ɔ ‑po ‑dɔi tu \"juɔi 'blee‑ ? \"Ɩɩn‑ ɛ se 'bɛɛ ɛ. Dɛ‑nʋɛ' ka ʋʋ nɩa 'sɔɔn ɛ ʋʋa muɛ \"bie 'di blua' se. ");
INSERT INTO wob_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Klai\" ju se dɛwɔn nɩ, ɔ se ɔɔ' dɛtɔɔi ‑sii, 'kaa klai\" ju ‑kpʋan' 'snɩ ɛ, ‑mɛ ka ɔɔ' dɛtɔɔi nɩa, 'kamɔ ɔɔ mu nɩa'. ");
INSERT INTO wob_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","Dɛɛ‑tɩ ‑ma ‑je ‑ʋn ‑podɛi\" dɛ \"jri, 'de ‑maa' 'je tu ‑jɛ ‑nɩa 'e ‑ma ‑cɛ\" 'kpa \"jri ɛ‑ ? ");
INSERT INTO wob_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","'De ‑ɩn ‑beeɛ' ‑ɩn ‑je wlu ka 'de ‑ma ‑podɛi\" ‑pee, ‑ɩn ‑je nʋ : 'Ma de'di, ‑ɩn ‑tai\" 'mi \"i 'ɩn 'je ‑ʋn dɛ \"jri ‑sa. 'De ‑mɛ 'kamɔ ɛ ‑te ‑gbɛɛ 'de ‑ma ‑cɛ\" 'kpa \"jri. \"Jridepooi ! ‑Ɩn ‑sa ‑ma ‑cɛ\" tu \"jri ke, ‑wɛe ‑ɩn ‑je i 'je 'pepe. 'De ‑ɩn ‑je ‑ma ‑podɛi\" dɛ \"jri ‑sa ka 'je. ");
INSERT INTO wob_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","Tu 'dɔe se ɛ 'bɛɛ‑ ɛ 'je \"buo saʋn po, 'de tu saʋn se ɛ 'bɛɛ‑ ɛ 'e \"buo 'dɔe po. ");
INSERT INTO wob_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Nyʋ juo tu \"o tu 'mɛ 'de ɛɛ' \"buo 'ʋn, nyɔ se ɛ 'bɛɛ‑ ɔ 'je 'mawlobuo ke ‑fokabuo ‑sa 'de \"wi‑gbauo ja. ");
INSERT INTO wob_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Nyɔ 'dɔe a ‑sa ‑tɩ' 'dɔe 'de ɔɔ' pɛe 'dɔe 'a \"kɛ o, ‑wɛe ɔɔ po ɩ ‑sɔn. 'Diwɔnynii a ‑sa ‑tɩ' saɩn 'de ɔɔ' pɛe saʋn 'a \"kɛ o, ‑wɛe ɔɔ po ɩ ‑sɔn, dɛ‑nʋɛ' dɛ ‑jia\" 'e nyɔ pɛe o, ɛmɛ ɔɔ' wɔn ɔ 'tmʋ. ");
INSERT INTO wob_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","Dɛɛ‑tɩ aoa 'daa‑ 'ʋn Tʋ\"bo, Tʋ\"bo, 'de ka 'ma wlu \"sia 'nynɩ aoa' nʋ kan' a‑ ? ");
INSERT INTO wob_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Nyɔ \"o nyɔ ‑jia' 'nɔ 'ʋn o, 'de ‑ɔɔ poa 'ma wlu doin\" o, ‑wɛe ka 'ma wlu \"sia 'nynɩ ‑ɔɔ nʋa kan' a, nyɔ ‑ke ɔ ‑kɔɔa' ɔmɔ 'ma ji aopʋ tɔɔa'. ");
INSERT INTO wob_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Ɔ ‑kɔ' \"ju due' ‑ɔ sia nɔ\" nya 'de ‑ɔ ‑blua\" 'o 'soa‑ \"kpei ‑blu ‑blu ‑wɛe ‑ɔ poa 'o ‑gbu\" ɛ. \"Ni 'a ‑sɔugba dba', ‑wɛe ‑pie ji, 'de \"ni‑gbii ‑wee' \"ji ɩ bla ‑gbu\" ‑nɛ \"jri ‑bla ‑bla, ɩ se ɛ bluua‑, dɛ‑nʋɛ' ɛ pooɛ' ka ‑cɔɔn' ka. ");
INSERT INTO wob_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","'Kaa nyɔ ‑ɔɔ poa 'ma wlu doin\" o, 'de ka ɛ 'daa‑ ‑ɔɔ' nʋa kan' a, ɔ ‑kɔ' \"ju due' ‑ɔ poa ‑gbu\" 'bo ‑pɩɩɔn\" \"kpei ɛ. Ɔɔ' ‑gbu\" se ‑gban 'ble, \"ni dba', ɛ ‑siɛ' ‑gbuu ɛ bla ‑gbu\" ‑nɛ wɔn ‑bla ‑bla, 'bo ɛ \"sri, ɛ ‑wee' \"klein je blu piepie. Dɩ ‑dooa ɩ ‑tiɛi\". ");
INSERT INTO wob_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Sesi ‑kɔa' dɛ ‑nɛ 'ɛ 'tmʋa' 'de nyʋ ‑ʋʋa po ɔɔ' wlu doin\" o ‑pee 'sʋ ɛ, ɔ muɛ 'o Kapɛnaʋm. ");
INSERT INTO wob_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Rɔmɛ 'ɛ \"soa‑wi\" 'a ‑jeopoi due' nɩ‑ 'o mu. Ɔmɔ ‑ɔɔ dbonʋi 'wɛ‑ kpʋn 'mɛ ka‑. 'De ɔ kma ɔɔ' dbonʋi ‑nɔ 'ɔ ‑tɩ' ‑gblein'. ");
INSERT INTO wob_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Ɔ 'wɔan Sesi 'a 'nynɩ 'sʋ ɛ, ɔ dboɛ Suifʋ‑wi\" 'a nyʋ‑cɔɩn' jrʋ' ʋʋ 'je Sesi ibae 'de ɔ 'e ji, ‑wɛe ɔ 'je ɔɔ' dbonʋi 'a 'wɛ‑ 'bɔɔ‑. ");
INSERT INTO wob_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Ʋʋ nynia 'o Sesi ‑pʋn\", 'sʋ ʋʋa bae ɔ i 'de nai\" 'blea' 'ʋn ʋʋ 'na : \"Ju ‑nɔ nɩɛ sʋn o po ka‑, ");
INSERT INTO wob_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","dɛ‑nʋɛ' ɔ kma ‑aa 'blʋa 'a ‑tɩ'. Ɔmɔ ‑po' ‑aa \"jrui 'kɩɩɛn‑gbu ‑nɛ. ");
INSERT INTO wob_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","‑Ta Sesi ke ʋʋ nɩa 'e mua' a, ʋʋ se ‑gbu\" ʋʋa mua 'e 'di o tɛɛn‑ 'sʋ \"soa‑wi\" 'a ‑jeopoi ‑nɔ dboɛ ɔɔ' \"dɛi‑wi\" 'de Sesi o, ‑wɛe ɔ 'na : Tʋ\"bo, ‑ɩn ‑bo ‑ma ‑cɛ\" seaa kan' 'de 'ma ‑tɩ' 'ʋn, 'ɩn se ‑ma ‑teɩn \"nyɩ ka nɩ 'de 'ma ‑gbu\" ‑sɔn. ");
INSERT INTO wob_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","‑Wɛe 'ma ‑cɛ\" 'kpa se 'de ‑ɩn o ji ka nɩ‑, 'kaa ‑bo ‑ɩn ‑tmʋ wlu due' koun ‑gbai' mɔ 'de ɛ, 'ma dbonʋi 'a 'wɛ‑ ɛ muɛ 'bɔa' se. ");
INSERT INTO wob_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Dɛɛ ‑tɩ 'ɩn 'da kan' a, ɛmɛ ‑nɩ 'mɔ ‑ke ɛ, 'ɩn juo nyɔ wɔn ‑sii ‑tɩ 'mɛ. 'Mɔ ‑ɔ ‑blea klae\" ‑wi\", ‑wɛe ‑ɔɔ jaa \"jru ja 'de ʋʋpʋ ‑sɔn ɛ, 'ɩn 'bleɛ \"soa‑wi\" ‑ke 'bo 'ʋn ‑sɔn, ‑wɛe ‑bo 'ɩn 'na due' : ‑Mu' ! 'Sʋ ɔɔ mu'. ‑Bo 'ɩn 'na deejrɔ' : ji ! 'Sʋ ‑mɔɔ ji'. ‑Bo 'ɩn wlu 'e 'ma dbonʋi ‑pee 'ɩn 'na : ‑Ɩn nʋ dɛ ‑nɛ ! 'Sʋ ɔɔ nʋɛ'. ");
INSERT INTO wob_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Sesi 'wɔan \"ju ‑nɔ 'ɔ wlu 'sʋ, ɔ po ɔ ‑tɩ' o, ‑wɛe ɔ \"biie‑ 'de nyʋ ‑gbaea' ɔ 'de woi 'de ɔ 'na : 'Ma 'tmʋ aopʋ 'mɛ, 'de Israɛ‑blʋa 'di ‑ta 'ɩn se dɛ ‑kwlɩ\" ‑tea' ‑bɛa ka ‑mɛ 'je due' 'de nyɔ 'ʋn. ");
INSERT INTO wob_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","‑Ta nyʋ jra' jei dboa a mua ‑gbɛin\" de ɛ, ‑mɛ ʋʋ jɛɛ ɔɔ' dbonʋi 'mɛ ɔ 'pʋʋ. ");
INSERT INTO wob_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","‑Sɔn' jrɛ' ‑sɩan' 'sʋ ɛ, Sesi muɛ 'e ‑kwlɔ ‑ɛɛ 'nynɩ nɩa Nainɩ 'di, ɔ ke ɔɔ' klai\" nynuu ke nyʋ ‑tuu\"‑tuu a naa bɩ' i. ");
INSERT INTO wob_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","‑Ta ɔɔ \"kʋʋan ‑kwlɔ 'ɔ paa 'ɩn i 'sʋ ɛ, ʋʋ 'bleɛ \"ju due 'a 'dai‑ ʋʋa kpa i ‑tea'. Ɛ nɩ ‑tiɔn\" 'nynɔ 'ɔ \"junmɔuju due' koʋn ‑gbai' ‑o, ‑kwlɔʋn ‑tuu\"‑tuu ‑kɩɩn' \"jrui 'bomu. ");
INSERT INTO wob_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Tʋ\"bo 'jeea ‑tiɔn\" 'nynɔ ‑nʋ \"jriɛ‑ 'sʋ ʋa' wɛe a nʋɔ', 'sʋ ɔ 'na : A 'bo ‑fɩɛn\"‑ ! ");
INSERT INTO wob_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","'Sʋ ɔ 'kɩɩɛn 'o 'dai‑ ‑pʋn\", ‑wɛe ɔ blɛ \"i. 'Sʋ nyʋ ‑ʋʋ ‑bleɛ, ʋʋ nyna i. Ɔ wlu' ɔ 'na : ‑Kooai\" ‑tɔo, 'ma 'tmʋʋ ‑ʋn ‑ɛ, ‑ɩn sɔn 'ʋn ! ");
INSERT INTO wob_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","'Sʋ \"ju ‑nɔ sɔn 'ʋn 'ɛ, ɔ ‑teɛ i ‑wɛe ɔ ‑te wlua' ‑pʋn\". 'De Sesi 'na : 'Nynɔkpao', aa' \"ju ‑nao ! ");
INSERT INTO wob_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Nyʋ \"klein ‑jea ɛɛ' ‑ta, faʋn a nʋ ʋʋpʋ 'mɛ. Ʋʋa 'bɛɛ‑ Kea 'a 'nynɩ \"i, ʋʋ 'na : Kea 'a wlu 'kwajaai klaa\" sɔn 'ʋn 'de ‑a \"klu. Ɛ Kea mɛ ‑ji\" ɛɛ' 'bleenyʋ \"i ‑tea'. ");
INSERT INTO wob_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Dɛ Sesi nʋa 'mʋa‑ nyʋ a 'tmʋʋɛ' 'de Suideblʋa ke 'blʋa‑ jrɩ' ‑jiɛ' 'dei \"kpei‑. ");
INSERT INTO wob_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Dɩ \"klein ‑nʋʋa 'mʋa‑ San 'a klai\" nynuu po ɔ ɩa' \"kuan. 'Sʋ ɔ 'da ʋʋa' 'sɔɔn 'mɛ, ");
INSERT INTO wob_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","‑wɛe ɔ dbo ʋʋpʋ 'de Sesi o, 'de ɔ 'na : ‑Bo ao mu ɛ, ‑mɛ ao ‑tee' ɔ i ka, ao 'na ‑ɩn ‑nɩɛ \"ju ‑ɔ ‑jea ji ‑o, ‑aee' ‑a ‑je deejrɔ' fuo ke'wlɛɛ ? ");
INSERT INTO wob_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Ʋʋ nynia 'bo Sesi ‑pʋn\" 'sʋ, ʋʋ 'na : San Batisɩ ‑dbo' ‑aʋn 'nɔ ‑ɩn o, ‑wɛe ‑a ‑je ‑mi i ‑tee'‑. ‑Ɩn ‑nɩɛ \"ju ‑aa fua ‑oo, ‑aee' ‑a ‑je deejrɔ' fuo ‑o ke'wlɛɛ ? ");
INSERT INTO wob_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","‑Ta ɛɛ nʋʋa kan' a, ‑mɛ Sesi nɩɛ nyʋ ‑tuu\"‑tuu 'a 'wɛ‑ 'bɔɔa', ɔɔ 'pʋʋ‑ klɔɔʋn, ɔɔ nʋɛ ‑siisaɩn i 'de nyʋ 'ʋn, ɔɔ nʋɛ' ‑wɛe ɔɔ 'bai \"dɔʋn 'a \"jri. ");
INSERT INTO wob_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","'Sʋ ɔ wlu' 'de San 'a klai\" nynuu ‑pee ɔ 'na : ‑Bo ao mu ɛ, ‑mɛ dɩ \"klein ao 'jea 'de ao 'wɔan ao 'tmʋ ɩ 'de ɔ ‑pee. \"dɔʋn a 'jeɛi 'pepe, klɔɔʋn a na', 'jrʋwɛnʋn 'a 'wɛ‑ ɛ 'bɔɔ, doin\" 'a waʋn a 'wɔn i, 'mɛʋn a sɔn ‑klu', ‑pɔia\" ‑tɩ a 'tmʋʋɛ' 'de wɛenyʋ ‑pee. ");
INSERT INTO wob_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Nyɔ ‑ɔɔ \"maa 'mɔ sea nɩ ɛ, ‑mɛ ‑mɔ nʋ 'mʋa‑. ");
INSERT INTO wob_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","San 'a klai\" nynuu mua de 'sʋ, Sesi ‑teɛ ɔɔ' ‑tɩ' 'tmʋa' ‑pʋn\" 'de nyʋ ‑gbae' ɔ 'dei ‑pee ɔ 'na : Dɛ ao mu i 'jea' 'de ‑pɩɩɔn\" blʋa \"kpei 'de ɛ‑ ? ‑Aee' ‑gblokpau poɔ' ɔ ‑suua' i ɛ‑ ? ");
INSERT INTO wob_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","'De ‑mɛ nyɔ ao mu i 'jea' 'ja a‑ ? ‑Aee' \"ju due' ‑ɔ ‑paa dɩ 'dɔe 'ʋn ɛ‑ ? Ao ‑gbʋn 'nɔ, nyʋ ‑paa dɩ 'dɔe 'ʋn ɛ, ‑wi\" ‑mʋ a ‑teɛ' i 'de 'beɔ‑wi\" o ‑gbu\" 'di, ‑wɛe ʋʋ nɩ dɩ ‑wee' \"klein 'a jeʋn. ");
INSERT INTO wob_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","'De nyɔ ao mu i 'jea' ‑gbo' ɛ‑ ? Kea 'a wlu 'kwajaai duee' ? Kɩɩn tɔ' ‑o. 'Ma 'tmʋ aopʋ 'mɛ, ɛ ‑sii Kea 'a wlu 'kwajaai ‑mɔ 'mɛ. ");
INSERT INTO wob_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","San nɩɛ \"ju ‑ɔɔ ‑tɩ' 'ʋn Kea 'a wlu ‑crɩɩa' 'naa : ‑Gbʋn 'nɔ, 'ma dboɛ 'ma dboi 'de ‑ʋn \"juɔi, ‑wɛe ɔ 'je ‑ma ‑jeblʋ nmae‑. ");
INSERT INTO wob_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","'Ma 'tmʋ aopʋ 'mɛ, dɛ klein\" 'nynʋkpae' 'wlʋa a, nyɔ se \"i 'bɛ ɔ se San ‑sii. 'De ‑mɛ 'kamɔ nyɔ ‑piia' \"i 'de Kea 'a kɛɛma' ‑kwlɔ 'di, ɔ 'bɛi\" ɔ ‑sii ɔ. ");
INSERT INTO wob_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Nyʋ \"klein ‑wɔan San 'a wlu ɛ, ʋʋ ke 'wɛi‑sanyʋ cɛn ‑kɩn ʋʋ je Kea \"nyɩ, ‑wɛe San po ʋʋpʋ \"ni \"jru. ");
INSERT INTO wob_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","'Kaa Fariseɛn o, kɛ' wɔ‑saʋn se ɛ \"inɩ 'de San 'je ʋʋpʋ \"ni \"jru po. 'Pʋʋa' Kea nɩai\", ɛ 'jea ʋʋpʋ \"nyɩ ka ʋʋ nʋa ɛɛ' nya‑fuunsʋn, 'kamɔ ‑nao. ");
INSERT INTO wob_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","'Bomɔ Sesi 'na : Nyɔ 'ɩn 'je nyʋ ‑nɩa ‑sɩanwɩ 'di \"ipoo ɛ‑ ? Nyɔ ‑ke ʋʋpʋ ‑kooɔ ɔ‑ ? ");
INSERT INTO wob_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Ʋʋ ‑kɔ' \"nynumɩɩ\" ‑ʋʋ ‑tea i 'bo ‑kwlɔ ‑kwea ‑wɛe ‑ʋʋa wlua 'e ba ‑pee ka : ‑A bla aoa' \"kwi ‑kweɩn 'mɛ ‑bla ‑bla, ao se dee‑. ‑A ble \"nmia dʋ 'mɛ ‑ble ‑ble 'kaa wɛe se ao nʋ ao se ‑fɩn\". ");
INSERT INTO wob_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","San Batisɩ jia ‑wɛe ɔɔ diɛ ‑di'pɛn, 'de ɔɔ' 'na nmɔ, 'sʋ ao 'na ‑suusaʋn ‑nɩ 'de ɔ 'ʋn. ");
INSERT INTO wob_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","nyiɔ 'ɔ \"Ju jia, ɔɔ di', ɔɔ 'naa, 'sʋ ao 'na ɔ ‑kau', ɔ ke 'wɛi‑saʋn o, nyiɔpʋ 'a \"kwli saɩn dbɛɛ', ‑wɛe ʋʋa po sʋn ‑tadue, 'de ʋʋa 'naa ‑kaun\"‑ due' 'di. ");
INSERT INTO wob_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","'Kaa ka Kea 'a ‑tɩ' nɩa tɔ' ɛ, nyʋ ‑wɔɩn 'mii ɛ ʋʋ juɛ' ka ɛɛ nʋa nyʋ 'dɔe \"jrii ɛ. ");
INSERT INTO wob_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Fariseɛn due' 'da Sesi dɛdi ‑tɩ. Sesi pa 'e ɔ o ‑gbu\", ‑wɛe ɔ ‑te i 'de ʋʋ ‑te dɛ dia' ‑pʋn\". ");
INSERT INTO wob_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","'De 'bo ‑kwlɔ ‑nɩa 'mʋa‑ 'di ɛ, ‑kwlɔ i ‑te nynɔkpao' due' ‑nɩ 'o. Ka Sesi nɩa dɛ dia' 'de Fariseɛn o ‑gbu\" 'di ɛ, ʋ 'je kan' 'mɛ, 'sʋ ʋ kpa ‑dai'klɔ ‑sooɛ due' \"sou nʋa ‑ɛɛ 'nynɩ nɩ albatrɩ, ");
INSERT INTO wob_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","‑wɛe ʋ jii 'de Sesi bɩ o fɔ o. 'Sʋ ʋa ‑fɩn\", ʋa' \"miini \"pɛɛn‑ Sesi 'a bɩ 'mɛ. ‑Wɛe ʋa nʋ ʋa' \"mɩɩ‑ 'de ʋa ‑sa Sesi 'a bɩ \"miini kui. 'Sʋ ʋ ‑gbleeɛ ɩ ‑kwlɩ\", ‑wɛe ʋa po ɩ -dai'klɔ kui. ");
INSERT INTO wob_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Fariseɛn ‑ɔ ‑dɔ dɛdi ‑tɩ 'jeea dɛ ‑nɩa 'mʋa‑ \"jriɛ‑ 'sʋ ɛ, ɔ wlu' 'de ɔɔ' ‑cɛ\" 'ʋn ɔ 'na : ‑Bo \"ju ‑nɔ nɩ Kea 'a wlu 'kwajaai 'de ɛ, ‑mɛ ka 'nynɔkpao' ‑ʋa blɔ \"i 'mʋa‑ ‑nɩa dɛsaʋn nʋ nynɔkpao' ɛ, ɔɔ mu ɛ jua' 'de‑. ");
INSERT INTO wob_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","'Bomɔ Sesi \"duo wlu 'ʋn ɔ 'na : Simɔ, 'ɩn 'bleɛ ‑tɩ' ‑saɩn\"‑ 'ɩn 'je ‑mii' ‑tee'‑. 'Sʋ Simɔ 'na : 'Ma dɛtɔɔi, ‑ɩn ‑wlu ! ");
INSERT INTO wob_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","'Bomɔ Sesi poo ‑tɩ' \"i ɔ 'na : \"Ju due' mɔ ‑ɔɔ kpan nɩ nyʋ 'sɔɔn \"kpei. Due' 'bleɛ ɔɔ' 'wɛi 'a kmɛ' due', ‑wɛe due' 'ble ɔɔ' 'wɛi 'a kwla mm\". ");
INSERT INTO wob_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Ka ʋʋ nɩa 'sɔɔn ‑ta ʋʋ 'jea dɛ ‑sa, 'bo se nɩ‑. 'Sʋ \"ju ‑nɔ 'bɔ 'wɛi ‑nɩa 'de ʋʋpʋ \"kpei 'mɛ. 'Bo nyʋ 'sɔɔn ‑nʋ \"klu 'ee, nyɔ ‑je \"ju ‑nɔ 'ɔ ‑tɩ' kma ‑gblein' ɛ‑ ? ");
INSERT INTO wob_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Simɔ 'na : 'Mɔ naa tɔ' i ɛ, \"ju ‑jɔ ɔ nʋa 'saaʋn \"jrii ‑gblein' ɛ, ɔmɔ ‑nɩ ‑jɔ ɔ 'bɔɔa 'wɛi ‑tuu\" ɛ. 'Sʋ Sesi 'na : tɔ' ‑tɩ ‑o, ‑ɩn ‑sɛ \"kpei 'mɛ ka ‑cɔɔn' ka. ");
INSERT INTO wob_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","‑Wɛe Sesi \"biie 'de \"junynɔkpao' ‑nʋ o 'sʋ ɔ wluɛ Simɔ ‑pee ɔ 'na : ‑ma ‑je \"junynɔkpao' ‑nʋ 'mɛɛ ? ‑Ta 'ɩn paa 'nɔ ‑ɩn o ‑gbu\" ɛ, 'ɩn se 'ʋn \"ni \"nyɩ ‑ɩn se bɩ wɔɔ‑, 'kaa ʋmʋ ɛ, ʋ nʋɛ ʋa' \"mii ni ‑wɛe ʋ wɔɔ 'ʋn bɩ i 'de ʋ jaa ɩ ʋa' \"mɩɩ‑ kui. ");
INSERT INTO wob_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","‑Ɩn se 'ʋn ‑kwlɩ\" ‑gblee mɔ \"pɩ, 'kaa dɛ \"nana 'ɩn pa 'nɔ ‑ɩn o ‑gbu\" 'di ‑sɩan 'de ɛ, ʋ se 'ma bɩ 'a ‑kwlɩ\" ‑gbleetɩ 'bɔ ke. ");
INSERT INTO wob_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","‑Ɩn se 'ʋn 'cna \"jru po, 'kaa ʋmʋ ɛ, ʋ 'wla 'ʋn -dai'klɔ bɩ i. ");
INSERT INTO wob_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Ɛmɛ ‑tɩ 'ma 'tmʋʋ ‑ʋn ka : ʋ kma nyiɔ 'ɔ ‑tɩ' 'pepe, ɛmɛ ‑tɩ ʋa' dɩsaɩn ‑tuu 'kpe ‑nɩ ‑kwɛ‑. 'Kaa ‑bo nyɔ ‑ɔɔ dɩsaɩn ‑wee' sea ‑kwɛ‑ ɛ, ‑mɛ ɔɔ' nyiɔ 'ɔ ‑tɩ' kmaa' se \"jri \"kpae' po ke ‑gblein'. ");
INSERT INTO wob_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","'Sʋ Sesi wlu' 'de 'nynɔkpao' ‑pee ɔ 'na : Aa' dɩsaɩn ‑kwɛ'. ");
INSERT INTO wob_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Nyʋ ‑ke ɔ nɩa dɛ dia' ‑tadue ɛ, ʋʋ ‑teɛ wlua' ‑pʋn\" 'de ʋʋa' ‑cɛ\" 'ʋn, ʋʋ 'na : ‑Ta \"ju ‑nɔ ‑mɔ 'wlʋ ‑wɛe ɔɔ ‑kɔ' nyʋ 'a dɩsaɩn ‑ke ɛ‑ ? ");
INSERT INTO wob_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","'Kaa Sesi wlu' 'de \"junynɔkpao' ‑pee ɔ 'na : Aa' 'ma ‑tɩ' tɔ' 'ʋn 'jea' 'pʋʋ aʋn 'ɛ. A mu 'de pɛe 'a blua' 'ʋn ! ");
INSERT INTO wob_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Ɛ 'wlʋa 'o mu ɛ, Sesi a muɛ ‑kwlɛ klae\" ke ‑kwlɛ mɩɩ\" 'dii, ‑wɛe ɔɔ 'tmʋ Kea 'a 'kmʋ dee 'a ‑pɔia\" ‑tɩ. ");
INSERT INTO wob_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Ɔɔ' klai\" nynuu ‑nɩa ‑puue 'jɔ 'sɔɔn ke 'nynʋkpae' jrʋ' ɔ ‑sa 'wɛ‑ ke ‑siisaɩn 'ʋn ɛ, ʋʋpʋ ke ɔ mu' ‑ke. Ɛ nɩ Madi ‑wlʋa Madala ‑ʋ 'ʋn ‑siisaɩn ‑mɛ\" 'sɔn 'wlʋa ke. ");
INSERT INTO wob_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Erodɩ 'a dbonʋi due' ‑ɔɔ 'nynɩ nɩa Kusa ‑mɔ 'ɔ ‑nɛ 'nynɔ Sanɩ ke Sisanɩ o, 'nynʋkpae' jrʋ' ke ɔɔ na', ‑wɛe ‑ʋʋa po ɔ sʋn o 'de ʋʋa' 'bleedɩ 'ʋn. ");
INSERT INTO wob_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","‑Ta nyʋ ‑tuu\" ‑wlʋa ‑kwlɛ 'dii jia 'de Sesi o, ‑wɛe ʋʋ ‑gbae' ɔ 'dei ɛ, 'bomɔ ɔ poo ‑tɩ' \"i ka ɔ 'na : ");
INSERT INTO wob_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","Nyɔ due' ‑mu' ko ‑gbaa'. ‑Ta ɔɔ ‑gbaa' ko ɛ, ɩa' 'jɔ jrɩ' blu' 'bo ‑je ‑kpae\", ‑mɩ naa \"kpei‑, 'sʋ nʋʋɩ ji' ‑wɛe ɩ di. ");
INSERT INTO wob_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Ɩa' 'jɔ jrɩ' blu' 'bo 'soa‑ \"kpei, ‑mɩ mɛ' kpɩɩn‑, 'kaa ɩ jɛ 'soɛ, dɛ‑nʋɛ' \"ni se 'de ɩ ‑sɔn nɩ‑. ");
INSERT INTO wob_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Ɩa' 'jɔ jrɩ' blu' 'de \"wi 'ʋn, ‑mɩ ke \"wi mɛ' ‑tadue, 'kaa \"wi sɩɩn i. ");
INSERT INTO wob_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","'Kaa ɩa' 'jɔ jrɩ' blu' 'de 'blʋa‑ 'dɔe 'ʋn. ‑Mɩ mɛ', ɩ 'wlʋɛ dɛ 'ʋn, ɩa' kpau due' croɛ 'jɔ 'ɔ kmɛ' 'due. Sesi 'tmʋa dɛ ‑nɛ 'sʋ ɛ, ɔ kpa wlu \"jɛi ‑wɛe ɔ 'na : Nyɔ ‑blea doin\" ɔ 'wɔn i ! ");
INSERT INTO wob_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","'Sʋ ɔɔ' klai\" nynuu ‑tee' ɔ i ʋʋ 'na : ‑Ɩn ‑sa \"ipoo‑tɩ ‑nɛ wɔ 'de ‑a ‑pee. ");
INSERT INTO wob_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","'Sʋ ɔ 'na : Aopʋ mɔ ɛ, Kea 'a 'kmʋ dee 'a ‑tɩ' ‑wee' \"klein ‑saa wɔ 'de ao ‑pee, 'kaa nyʋ jrʋ' a 'wɔn ɩa' ‑tɩ' tu 'mɛ 'de \"ipoo‑tɩ 'ʋn. 'De ʋʋ 'je ɛ ja ‑gbʋn, ‑wɛe ʋʋ se ɛ \"jriɛ‑ 'jeei 'pepe. 'De ʋʋ 'je ɛ doin\" 'wɔɔn‑, ‑wɛe ʋʋ se ɛ 'mii 'wɔin 'pepe. ");
INSERT INTO wob_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Dɛ \"ipoo‑tɩ ‑nɛ ‑sa wɔ, ɛ ka : ka ko ‑gbaa' nɩa, 'kamɔ Kea 'a wlu 'tmʋa' nɩ. ");
INSERT INTO wob_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","'De nyʋ jrʋ' pɛe o ɛ, wlu ‑tmʋʋa' ‑kɔ' kojɔ ‑blua' 'o ‑je ‑kpae\" ɛ. ‑Bo ʋʋ 'wɔn wlu 'mʋa‑ kaan 'sʋ ‑siɔn' ji', ɛ ‑sɛ 'de ʋʋpʋ 'ʋn 'ɛ, dɛ‑nʋɛ' ɛɛ kaan ʋʋpʋ ‑je de, ‑wɛe ʋʋ je ɛ tɔ' 'ʋn 'je, 'de ʋʋ je 'pʋ. ");
INSERT INTO wob_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","'De nyʋ jrʋ' pɛe o ɛ, wlu ‑tmʋʋa' ‑kɔ' kojɔ ‑blua\" 'bo 'soa‑ \"kpei ɛ, ‑wɛe ‑ɩa 'sɩn sea ‑ta ‑tɔɔn nyni ɛ. Ʋʋa' nyʋ tu‑, ‑ta ʋʋ \"sia, ʋʋ 'wɔan Kea 'a wlu ɛ, 'bomɔ ʋʋ ‑sɛɛ 'o mu 'de 'mʋa‑ 'ʋn. 'Kaa ʋʋa' 'mʋa‑ nɔ\" se \"itɛn‑. ‑Bo 'kle ji ʋʋpʋ \"kpei, 'sʋ ʋʋ poɛ ʋʋa' dɛ ‑kwlɩ\" ‑tetɔ' i. ");
INSERT INTO wob_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Nyʋ jrʋ' 'a 'wɔn Kea 'a wlu 'mɛ ka kojɔ ‑kpa 'e \"wi 'ʋn nɩa. Ʋʋa' nyʋ tu a 'wɔn Kea 'a wlu 'mɛ kpɩɩn‑, 'kaa ‑bo ʋʋpʋ mu ɛ, ʋʋa' \"tai‑ ɛ \"i, ɛɛ' poo ʋʋa' kplɩn fai\", dɛ‑nʋɛ' ʋʋa 'wla 'kmʋ \"kpeidɩ ke \"wliiɛ 'ɛ ‑fli i 'de 'wɩ ‑wee' \"klein 'di. ");
INSERT INTO wob_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Nyʋ jrʋ' a 'wɔn Kea 'a wlu 'mɛ, ka kojɔ ‑kpa 'e 'blʋa‑ 'dɔe 'ʋn nɩa. Wlu ʋʋ 'wɔan, ʋʋ ‑te' ɛ i 'de tɔ' ikua' ke pɛe 'dɔe 'ʋn, ‑wɛe ɛ \"ti 'e ʋʋpʋ 'ʋn 'de ʋʋa nʋ Kea 'a ‑kwlʋtɩ. ");
INSERT INTO wob_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Nyɔ se ɛ 'bɛɛ‑ ɔ 'je nɛbi tba ‑wɛe ɔ 'je ɛ jae \"jri i‑crii\"‑ 'de ɔ 'je ɛ 'e 'dii ‑sɔn ‑te', 'kaa nyɔ ɔ ‑teɛ' ‑ta ‑tɛan ja, ‑wɛe nyʋ \"klein ‑a pa 'e ‑gbu\" 'je ɛ i 'je. ");
INSERT INTO wob_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","'Kamɔ ɛ 'e nɩ ‑ke, ‑tɩ' \"klein ‑ɩ pa 'kwla ɩa muɛ \"kpae' 'pɛɛan' ‑wɛe ‑tɩ' \"klein nyʋ sea juo ɛ, nyʋ a muɛ ɩ ‑wee' jua'. ");
INSERT INTO wob_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","‑Bo ɛ nɩ kan' a, ‑mɛ ao ‑tu\" aoa' ‑cɛ\" 'ɛ ‑tɩ' 'de aoa' dɛ doin\" oposʋn 'ʋn, dɛ‑nʋɛ' nyɔ ‑blea dɛ ɛ, nyʋ a mu ɔ jrɛ' \"nyɩa' ke'wlɛ, 'kaa nyɔ ‑jɔ sea dɛ 'ble ɛ, dɛ‑saan\" ‑jɛ ɔ 'blea mɔ 'de ɛ, nyʋ a mu ɛ ɔ ‑mɛ 'kwa ‑saa'. ");
INSERT INTO wob_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Sesi de ke ɔɔ' \"dei‑wi\" jiɛ 'de ɔ o, 'kaa ka ʋʋ 'jea ɔ ‑pʋn\" 'kpasʋn nʋ, 'ka se nɩ, dɛ‑nʋɛ' nyʋ ‑gbae' ɔ 'dei ʋʋ ‑tiɛi\". ");
INSERT INTO wob_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","'Sʋ nyʋ jrʋ' wlu' 'de ɔ ‑pee ʋʋ 'na : ‑Ɩn de ke ‑ma \"dei‑wi\" nɩɛ 'e \"kpae', ʋʋ nɩɛ \"i ʋʋ ke ‑ɩn ‑je 'jee‑. ");
INSERT INTO wob_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","'Kaa Sesi wlu' 'de ʋʋ ‑pee ɔ 'na : Nyʋ ‑ʋʋa poa 'ɩn 'Bo 'a wlu doin\" o ‑wɛe ka ɛ 'da‑ ‑ʋʋa nʋa kan' a, ʋʋpʋ ‑nɩ 'ɩn de ke 'ma \"dei‑wi\". ");
INSERT INTO wob_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","'Wɩ jrɛ' o Sesi ke ɔɔ' klai\" nynuu 'ja 'e ‑kwɛɛ\" due' 'di, ‑wɛe ɔ wlu 'de ʋʋ ‑pee ɔ 'na : ‑A mu 'e \"ni 'de fɔo. ");
INSERT INTO wob_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","‑Ta ʋʋ nɩɩa 'de 'a mua' a, ‑mɛ Sesi a 'mʋʋ. 'Sʋ ‑pie klaa\" ‑teɛ jia' ‑pʋn\" 'bo \"ni \"kpei. \"Ni a \"ji 'e ɛ 'di 'mɛ. 'Sʋ 'mɛa 'a faʋn ‑teɛ ʋʋa' nʋa' ‑pʋn\". ");
INSERT INTO wob_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","'Sʋ ʋʋ 'kpa Sesi ‑pʋn\", ‑wɛe ʋʋ ‑sɔ \"nyɩɔ' 'de ʋʋ 'na : ‑Aa 'blei, ‑aa 'blei, ‑a ‑kwɛ', ‑aa jiɛ 'mɛa' ! Ɔ sɔan 'ʋn 'sʋ ɛ, ɔ \"wɔɔ‑ ‑pie ke \"ni \"jrui ‑wɛe ɩ ji ja, 'sʋ ‑ta ‑wee' ‑teɛ 'tɩɩn. ");
INSERT INTO wob_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","‑Wɛe ɔ wlu 'de ʋʋ ‑pee ɔ 'na : Aoa' 'ma ‑kwlɩ\" ‑tea' ‑mɛ 'de ɛ‑ ? 'Sʋ faʋn ke tai' 'a \"maa \"ji 'de ʋʋpʋ 'ʋn 'ɛ, ‑wɛe ʋʋa' 'sʋ a wlu 'e ba ‑pee ʋʋ 'na : ‑Ta \"ju ‑nɔ ‑mɔ 'wlʋ 'ja a‑, ‑wɛe ‑ɔɔ wlu poɔ' ke \"ni ‑pee 'sʋ ɩa 'je ɔ wɔn ɛ‑ ? ");
INSERT INTO wob_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Ʋʋ kpʋɛn 'kpʋʋ 'de Seraseneɛn‑wi\" 'a 'blʋa‑ 'di. Ɛɛ' 'blʋa‑ tu ke Galileblʋa a ‑gbʋɛn' 'e ba \"jri. ");
INSERT INTO wob_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","‑Ta Sesi 'wlʋa 'e ‑kwɛɛ\" 'di ‑wɛe ɔ \"sia i 'sʋ ɛ, ‑kwlɔi due' ‑Siisaɩn ‑tuu\"‑tuu nɩa 'e 'ʋn ‑jɔɔ' \"i. Dɛ ‑wlʋa 'e sese o ɛ, ɔɔ' paa dɛ 'ʋn, ɔɔ' 'pɛn 'de ‑gbu\" 'di, ɔ \"tiɛ 'e ‑gbaɩn' \"klu. ");
INSERT INTO wob_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Ɔ 'jea Sesi i 'sʋ, ɔ \"siiɛ‑ 'kɔi‑ i 'bo ɔ \"juɔi ‑wɛe ɔ \"wɔ ɔ 'na : Sesi, Kea ‑nɩa 'e jaʋn 'di 'a \"ju, dɛ ‑ɩn ‑ke 'ma ‑a ‑plaan i ɛ‑ ? 'Ma bae ‑ʋn ‑ɛ, ‑ɩn ‑bo 'ʋn 'kle ‑tu\" ɛ ! ");
INSERT INTO wob_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Dɛɛ‑tɩ ɔ 'da kan' a, ɛmɛ ‑nɩ Sesi a wlu' 'de ‑suusaʋn ‑nɛ ‑pee, ‑wɛe ɛ 'je 'e \"ju ‑nɔ 'ʋn 'wlʋ. Dɛ‑nʋɛ' ɛmɛ ‑nɩ, ɛɛ' ‑suusaʋn tu ‑kwle ɔɔ' 'kle ‑tu\" 'a 'mɛ. 'De ɛɛ' ‑tɩ' 'ʋn ʋʋa po ɔ ‑gbaacɛe' \"dbi bɩ', 'kaa ɔɔ cɛn ‑gbaacɛe' \"dbi ‑nɩa 'mʋa‑ 'mɛ, ‑wɛe ‑suusaʋn a po ɔ ‑je o, 'de ɔɔ mu 'e 'kpaa \"kpei. ");
INSERT INTO wob_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Sesi ‑tee' ɔ i ɔ 'na : ‑Ma 'nynɩ wɛ‑ ? 'Sʋ ɔ 'na : 'Ma 'nynɩ ‑nɩ ‑pʋn' ‑tuun. Dɛɛ‑tɩ ɔ 'da kan' a, ɛmɛ ‑nɩ ‑siisaɩn ‑nɩa 'de ɔ 'ʋn ɛ, ɩ ‑tiɛi\". ");
INSERT INTO wob_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","'Sʋ ɩa bae Sesi 'mɛ ɩ 'na : ‑Ɩn ‑bo ‑aʋn 'de \"ni ‑tuun bluuɛ ! ");
INSERT INTO wob_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","‑Ta ɛ nʋʋa kan' a, ‑mɛ be\" 'a ‑gbaapʋ ‑nɩ idia' 'bo crʋ ‑kwlɩ\", ‑wɛe ‑siisaɩn bae Sesi i ɔ 'e 'wɔn 'de ɩ 'je 'e be\" ‑nɩ 'ʋn pa. 'Sʋ ɔ 'wɔɔn‑ 'o 'ɛ. ");
INSERT INTO wob_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","‑Siisaɩn 'wlʋa 'e \"ju ‑nɔ 'ʋn, ɩ pa 'e be\" 'ʋn ɛ. 'Sʋ be\" 'a ‑gbaapʋ ‑nɩa 'mʋa‑ ‑sa plea' 'de crʋ 'a ‑peenai\" ɩ 'kpa 'o \"ni wɔn, 'de ɩ ‑wee' blu \"ni ‑tun. ");
INSERT INTO wob_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Nyʋ ‑a fua be\" i ‑gbʋan ɛɛ' dɛ tu ja 'sʋ, ʋʋ 'kpa 'kwla, ‑wɛe ʋʋ kpa ɩa' ‑tɩ' tu, 'de ʋʋ 'tmʋ ɩ ‑kwlɔ ke ‑gbei\" 'dii. ");
INSERT INTO wob_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Nyiɔpʋ jiɛ dɛ ‑nʋʋa 'mʋa‑ \"jriɛ‑ 'jeea' a. ‑Ta ʋʋa muua, ‑mɛ ʋʋ jɛɛ \"ju ‑siisaɩn 'wlʋa' 'e 'ʋn ‑nɔ 'mɛ, ɔ paa dɩ 'ʋn, ‑wɛe ɔ ‑te i 'bo Sesi ‑pʋn\" ka ‑cɔɔn' ka. 'Sʋ tai' \"maa ʋʋpʋ 'mɛ. ");
INSERT INTO wob_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Nyʋ ‑jea dɩ \"klein ‑nʋʋa 'mʋa 'a ‑ta ka \"ju ‑siisaɩn nɩa 'ʋn ‑nɔ nʋa 'pʋ sʋn ɛ, ɛmɛ ‑ɛɛ \"kuan ʋʋ po 'de nyʋ ‑jia' ‑pee. ");
INSERT INTO wob_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Nyʋ \"klein ‑nɩa Senesarɛblʋa \"kpei ɛ, ʋʋ baeɛ Sesi 'de ɔ 'je ʋʋ kɩɩn tɛɛn‑. Dɛ‑nʋɛ', dɛ ʋʋ 'jeea \"jriɛ 'mʋa‑ ɛɛ' faʋn klaa\" a nʋ ʋʋpʋ 'mɛ. Sesi 'ja 'e ‑kwɛɛ\" 'di 'sʋ ɔ muɛ de. ");
INSERT INTO wob_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","\"Ju ‑suusaʋn 'wlʋa 'e 'ʋn a baeɛ Sesi i ‑wɛe ɔ ke ɔ 'je mu. 'Kaa Sesi po ɔ ‑jei\" ɔ 'na : ");
INSERT INTO wob_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","‑Ɩn mu 'de ‑ɩn o ‑gbu\" ‑sɔn de, ‑wɛe dɩ \"klein Kea nʋa ‑ʋn \"jrii ɛ, 'de ‑ɩn ‑jɩ 'tmʋ. \"Ju ‑nɔ mua' ‑cɛɛn'‑, dɩ \"klein Sesi nʋ ɔ \"jrii ɛ, ɔɔ 'tmʋ ɩ ‑kwlɔ \"kpeii ‑ta ‑wee'. ");
INSERT INTO wob_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","‑Ta Sesi a jii a de ɛ, nyʋ ‑tuu\" ‑mu' ɔ \"i 'jaa' 'de 'mʋa‑ 'ʋn, dɛ‑nʋɛ' ɔmɔ ʋʋ ‑wee' \"klein a fuo. ");
INSERT INTO wob_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","'Sʋ Suifʋ‑wi\" 'a Kea ‑gbu ‑jeopoi due' ‑ji\", ɔɔ' 'nynɩ ‑nɩ Sairisɩ. Ɔ ‑gbleeɛ Sesi bʋ wɔ, ɔ ‑teeɛ' ɔɔ' kwa 'di, ‑wɛe Sesi 'je 'de ɔ o ‑gbɛin\" mu, ");
INSERT INTO wob_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","dɛ‑nʋɛ' ɔɔ' \"junynɔkpao' jɔ due' ‑ʋ ‑blea ‑sɩn 'a ‑puue 'jɔ 'sɔɔn ɛ, ʋmʋ 'wɛ‑ kpʋn 'mɛ ka‑. ‑Ta Sesi nɩɩa 'e mua' a, nyʋ a \"tun ɔ i ‑ta ‑wee'. ");
INSERT INTO wob_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","'Sʋ 'nynɔkpao' due' ‑nɩ 'e nyʋ \"klu, nmi‑kwliwɛ‑ nɩ ‑pʋn\" 'de ‑sɩn 'a ‑puue 'jɔ 'sɔɔn 'di. 'De ɛɛ' ‑tɩ' 'ʋn ɛ, ʋ ple ʋa' dɩ ‑wee' \"klein 'mɛ 'de ‑dɔ'crɔ‑wi\" 'kwa. 'Kaa nyɔ ‑jea ʋ 'pʋʋ‑ ɛ, ɔ se nɩ‑. ");
INSERT INTO wob_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Ʋmʋ ‑kpa Sesi ‑pʋn\" 'de ɔ 'de fɔ o, ‑wɛe ‑ʋ bla ɔɔ' \"bai 'a wɔin\". 'Bo ɛ \"si ʋa' nmi‑kwliwɛ‑ je 'bɔ. ");
INSERT INTO wob_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","'Sʋ Sesi 'na : ‑Ɔ ‑bla' 'mi \"i kan' a‑ ? ‑Ta nyʋ ‑wee' \"klein nɩɩa ‑toa' a, 'bomɔ Piɛi ke nyʋ ‑ke ɔ nɩa 'o 'na : 'Ma 'blei, nyʋ ‑tuu\" a \"tuan ‑mi i ka ‑ta ‑wee' 'sʋ ɛ, ‑ɩn ‑na nyɔ ‑bla' 'mi \"i ɛ‑ ? ");
INSERT INTO wob_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","'Kaa Sesi 'na : \"Ɩɩn‑, nyɔ jrɔ' ‑bla' 'mi \"i, dɛ‑nʋɛ' 'ɩn 'je kan' 'mɛ ka 'ma \"ikmaa' jrɛ' 'wlʋa 'de 'ʋn ɛ. ");
INSERT INTO wob_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Ka 'nynɔkpao' ‑nʋ 'a nʋʋdɩ 'pɛɛan \"kpae, ʋ 'je kan' 'mɛ 'sʋ faʋn a nʋ', ʋa' dɩ a crɛ'. Ʋ \"siiɛ 'kɔi‑ i 'bo Sesi \"juɔi, ‑wɛe dɛ ‑ɛɛ ‑tɩ' 'ʋn ʋ bla Sesi \"i ke 'de ka ʋ blɔ \"i, 'sʋ ʋa' 'wɛ‑ \"sria 'o, ɛ 'bɔa, ʋ 'tmʋ ɛ 'bo nyʋ \"klein ‑kwea de \"juɔi. ");
INSERT INTO wob_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","'Sʋ Sesi wlu' 'de ʋ ‑pee ɔ 'na : 'Ma \"ju, aa' 'ma ‑kwlɩ\" ‑tea' 'pʋʋ‑ aʋn 'ɛ. A mu 'de pɛe 'a blua' 'ʋn ! ");
INSERT INTO wob_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","‑Ta Sesi nɩa wlua' kan' a, 'sʋ \"ju due' ‑wlʋ 'e Sairisɩ o ‑gbɛin\" ‑ɔ ji ɔ 'tmʋa' ‑ɔ 'na : ‑Ma \"ju 'mɛɛ. ‑Ɩn ‑bo nyʋ dɛtɔɔi seaa 'bode. ");
INSERT INTO wob_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Sesi 'wɔan ‑tɩ' ‑nɛ ɛ, ɔ wlu' 'de Sairisɩ ‑pee ɔ 'na : Faʋn 'bo ‑ʋn nʋɛ, 'kaa ‑ɩn ‑te' 'ʋn ‑kwlɩ\", ‑ma \"ju a muɛ 'kmʋnɩa'. ");
INSERT INTO wob_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Sesi nynia 'de Sairisɩ o ‑gbɛin\" ɛ, ɔ se 'wɔn ɔ ke nyɔ jrɔ' se 'e ‑gbu\" 'di pa, ‑bo ɛ se Piɛi o, San o, Sakɩ o, \"ju ‑saan\" \"bo ke ʋ de 'a 'sʋ nɩ ɛ. ");
INSERT INTO wob_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Nyʋ ‑nɩa 'e ‑gbu\" 'di ʋʋ ‑wee' \"klein a ‑fɩɩn\", ʋʋa kple' 'de \"ju ‑saan\" 'a ‑tɩ' 'ʋn. 'Sʋ Sesi 'na : Ao 'bo ‑fɩɛn\"‑ ! Ʋ se 'mɛ, 'kaa ʋa 'mʋʋ. ");
INSERT INTO wob_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Ɔ 'da kan' 'sʋ ɛ, ʋʋa wlɔɔ', dɛ‑nʋɛ' ʋʋ 'je kan' 'mɛ 'pepe ka ʋ 'mɛa. ");
INSERT INTO wob_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","'Kaa Sesi kpʋɛn \"ju ‑saan\" 'a sʋn, ‑wɛe ɔ kpa wlu \"jɛi ɔ 'na : 'ma \"Ju, a sɔn 'ʋn ! ");
INSERT INTO wob_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","'Bo ɛ \"si, ʋa' feeɛ' je 'de ʋ 'ʋn de ji, 'sʋ ʋ sɔn 'ʋn 'ɛ. ‑Wɛe Sesi 'na : Ao \"nyɩ ʋ dɛ, ʋ 'je di. ");
INSERT INTO wob_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Tai' \"maa ʋa' 'cɛ‑wi\" 'mɛ, 'sʋ Sesi ‑teɛ' ʋʋpʋ kɛ' \"i, ɔ 'na : Dɛ ‑nʋʋa ‑ta ao 'bo ɛ nyɔ jrɔ' ‑pee 'tmʋɛ ! ");
INSERT INTO wob_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Sesi 'kɩɩɛn ɔɔ' klai\" nynuu ‑nɩa ‑puue 'jɔ 'sɔɔn \"jrui, ‑wɛe ɔ \"nyɩ ʋʋpʋ \"ikmaa' ke dɛ \"wɔin 'bɛɛa' ke 'de ʋʋ 'je nyʋ ‑siisaɩn 'a \"kwli ‑wee' ke 'wɛ‑ \"kpei ‑sa. ");
INSERT INTO wob_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Ɔ dboɛ ʋʋpʋ Kea 'a 'beɔdɛ 'ɛ ‑tɩ' 'tmʋa', ‑wɛe ʋʋ 'je nyʋ 'a 'wɛ‑ 'bɔɔ‑ ‑ke. ");
INSERT INTO wob_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Ɔ wluɛ ʋʋ ‑pee 'de ɔ 'na : ‑Bo aoa sea mu ɛ, ao 'bo dɛ jrɛ' 'bleɛ. Ao 'bo itbatu o, ‑ke o, ‑di'pɛn ke 'wɛi 'bleɛ. Ao 'bo \"bai 'sɔɔn 'ʋn \"duɛ. ");
INSERT INTO wob_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","‑Gbu\" ‑ɛ 'di ao pa, ‑mɛ ao ‑te 'bo i mamaʋ, 'de ɛ 'di 'bomɔ ao 'je 'wlʋ, ‑wɛe ao 'je mu. ");
INSERT INTO wob_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","‑Ta \"o ‑ta ao mua ‑wɛe nyʋ sea ao sɩn 'sɔɔn kpʋʋn ɛ, ‑mɛ ao 'wlʋ 'o ɛɛ' ‑kwlɔ ‑tu 'di, ao ‑gbao' \"puue' ‑nɩa aoa' bɩ kui ɛ 'bo ʋʋpʋ \"juɔi, ‑wɛe ka ʋʋa' ‑cɛ\" 'kpa 'jea ʋʋa' 'kmʋ 'a \"kuan po, ɛmɛ ‑ɛɛ mu ʋʋpʋ 'pee kpʋan' 'de nya. ");
INSERT INTO wob_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","'Sʋ ʋʋ mu', ‑wɛe ʋʋa mu ‑kwlɛ 'dii due 'due 'de ʋʋa 'tmʋ ‑pɔia\" ‑tɩ, ‑wɛe ʋʋa 'bɔɔ‑ nyʋ 'a 'wɛ‑ ‑ta \"o ‑ta. ");
INSERT INTO wob_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","‑Gbʋa'na \"na Erodɩ 'wɔan dɩ \"klein ‑nʋʋa 'mʋa‑ 'sʋ ɛ, dɛ ɔ 'jea tɔ' \"kpei‑ naa ‑gblein', ɔɔ' 'je ɛ, dɛ‑nʋɛ' nyʋ jrʋ' 'naa : San Batisɩ ‑ji\" 'kmʋ de. ");
INSERT INTO wob_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Jrʋ' 'naa : Eli ‑to ɔɔ' ‑cɛ\". Jrʋ' 'naa : Kea 'a weepoʋn ‑nɩa tɛin\" 'a due' ‑ji\" 'kmʋ de. ");
INSERT INTO wob_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","'Kaa Erodɩ 'na : 'Ɩn cɛn San ‑mɔ \"jru \"i o, \"ju ‑jɔ ‑ɔ nʋa dɩ ‑ɩa 'nynɩ 'ma 'wɔan ‑ta 'ee, ‑ta ka ‑mɔ 'wlʋ ‑gbo' ɛ‑ ? 'Sʋ Erodɩ a ‑pɔn ɔ ke Sesi 'e 'jee‑. ");
INSERT INTO wob_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Nyʋ Sesi dboa jia de ɛ, ʋʋ poɔ dɩ klein\" ʋʋ nʋa ɩa' \"kuan, ‑wɛe ɔ \"duo ʋʋpʋ 'ʋn, 'de ɔ ke ʋʋ mu 'e ‑kwlɔ ‑ɛɛ 'nynɩ nɩa Besaida fɔ o. ");
INSERT INTO wob_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Ka Sesi mua nyʋ ‑tuu\" 'wɔɩn 'sʋ, ʋʋ mu ɔ kɩn. Sesi kpʋʋn ʋʋpʋ sɩn 'sɔɔn, ‑wɛe ɔ bla Kea 'a 'beɔdɛ 'ɛ ‑po. Nyʋ \"klein ‑nɩa \"i ɔ 'jea sʋn o po, ɔ 'bɔɔ‑ ʋʋpʋ 'a 'wɛ‑ 'mɛ ‑ke. ");
INSERT INTO wob_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","‑Ta 'jrʋ a blua i 'sʋ, Sesi 'a klai\" nynuu ‑nɩa ‑puue 'jɔ 'sɔɔn 'kpɔ ‑pʋn\" ʋʋ 'na : ‑Ɩn po nyʋ ‑nʋ ‑jei\", ʋʋ 'je ‑kwlɛ ke ‑gbei\" ‑kʋʋan\" i 'dii mu, ‑wɛe ʋʋ 'je 'pɛɩn' ke diidɛ ‑pɔn, dɛ‑nʋɛ' dɛ jrɛ' se ‑ta nɩ‑. ");
INSERT INTO wob_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Sesi 'na : Aoa' ‑cɛ\" 'kpa \"nyɩ ʋʋpʋ diidɛ. 'Sʋ klai\" nynuu 'na : ‑Bo ‑a se diidɛ ‑tɩan' mu 'de nyʋ ‑tuu\"‑tuu ‑nʋ 'a ‑tɩ' 'ʋn ɛ, ‑mɛ ʋʋ se dɛ dii, dɛ‑nʋɛ' ‑di'pɛn kplɩ ‑mm\" ke ‑smii' jɔ 'sɔɔn ‑gbai' mɩ ‑a ‑ble. ");
INSERT INTO wob_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","'De nyʋ ‑nɩa ‑ta 'bɛɛ \"nynunmai 'a \"wlu ‑mm\" 'mɛ. Sesi wluɛ klai\" nynuu ‑pee ɔ 'na : Ao po ʋʋpʋ kpɔi\" kwla ‑mm\" ‑mm\" ‑wɛe ʋʋ 'je i ‑te. ");
INSERT INTO wob_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","'Kamɔ klai\" nynuu nʋ ‑cɛɛn'‑, ‑wɛe ʋʋ ‑wee' \"klein ‑te i. ");
INSERT INTO wob_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Sesi \"dua ‑di'pɛn kplɩ ‑mm\" ke ‑smii' jɔ 'sɔɔn ‑nɩ 'ʋn ɔ kpa \"jri \"jɛi ‑wɛe ɔ po ɩa' Kea 'sɛ‑, 'de ɔ cɩn tii tii‑ ‑wɛe ɔ \"nyɩ ɔɔ' klai\" nynuu 'de ʋʋ 'jɩ nyʋ \"jrii ‑gble'. ");
INSERT INTO wob_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Ʋʋ ‑wee' \"klein di', ʋʋ je dbo. 'Sʋ ɩa' tɔo ‑sia 'o mu ɛ, ɩ \"jiɛ tooe\" 'a ‑puue 'jɔ 'sɔɔn. ");
INSERT INTO wob_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","'Wɩ jrɛ' o, Sesi ‑saa nyiɔpʋ kɩɩn ‑wɛe ɔ mu Kea baea' ‑tajrɔ. 'Bomɔ ɔɔ' klai\" nynuu muu ɔ kɩɩn, ‑wɛe ɔ ‑tee' ʋʋpʋ i ka ɔ 'na : Nyɔ nyiɔpʋ a 'daa‑ 'ʋn ‑ta' a‑ ? ");
INSERT INTO wob_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","'Sʋ ʋʋ 'na : Nyʋ ‑nʋʋ' a 'daa‑ ‑ʋn San Batisɩ, deejrʋ' 'na ‑ɩn ‑nɩɛ Eli ‑o, ‑wɛe jrʋ' 'na Kea 'a wlu 'kwajaaʋn ‑nɩa tɛin\" 'a due' ‑ji\" 'kmʋ de. ");
INSERT INTO wob_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","'De Sesi 'na : Aopʋ mɔ 'ee, nyɔ aoa 'daa‑ 'ʋn ‑ke ɛ‑ ? Piɛi 'na : ‑Ɩn ‑nɩɛ Nyʋ 'pʋʋi Klisɩ, \"ju Kea ‑tea' 'o mu ‑o. ");
INSERT INTO wob_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Sesi criɛ ‑cɩɛ 'de ʋʋ ‑pee ɔ 'na : Ao 'bo ɛ 'tmʋɛ 'de nyɔ jrɔ' ‑pee. ");
INSERT INTO wob_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","‑Wɛe ɔ wlu ke'wlɛ ɔ 'na : nyiɔ 'ɔ \"Ju 'je 'kle 'je ‑o kpleiin. Nyʋ ‑cɔʋn'‑wi\" o, 'sraa ‑saʋn 'a klae\" o, kɛ' wɔ‑saʋn a muɛ ɔ 'bɔa', ʋʋa muɛ ɔ 'dbaa', ‑wɛe 'de 'wɩ 'a taan ‑nɛ 'di ɔ 'je \"kunyɩɔ' sɔn‑. ");
INSERT INTO wob_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","‑Wɛe ɔ wlu 'de ʋʋ ‑wee' \"klein ‑pee ɔ 'na : ‑Bo nyɔ ‑nɩɛi\" ɔ ke 'ma ‑a ‑je na ‑mɛ ɔ 'bɔ ɔɔ' ‑cɛ\" 'ɛ 'tʋn nʋ‑tɩ. Ɔ 'wɔɔn‑ 'kle 'je ‑tɩ 'de nɔ\" \"o nɔ\" ‑wee' 'di, ‑wɛe ɔ 'je 'ʋn 'de bla. ");
INSERT INTO wob_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Dɛ‑nʋɛ' nyɔ ‑ɔ ‑nɩɛ \"i ‑ɔ ‑jea ɔɔ' 'kmʋ \"kpei‑ 'tɔan a, ‑mɛ ɛɛ mu ɔ kwa \"maa'. 'Kaa nyɔ ‑ɔ ‑toa 'e ɔɔ' 'kmʋ 'de 'ma ‑tɩ' 'ʋn ɛ, ɔmɔ ‑ɔɔ mu 'pʋʋa'. ");
INSERT INTO wob_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","'De ‑bo nyiɔ 'ble dɩ \"klein ‑nɩa ‑ta 'kmʋ ‑nɛ \"kpei, ‑wɛe ɔ \"maa ɔɔ' ‑cɛ\" 'de ɔ ke Kea 'je i ‑seea' 'ee, ‑mɛ dɛ ɔ 'je 'o ɛ‑ ? ");
INSERT INTO wob_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Nyɔ ‑nʋʋa 'ma wlu ke 'ma ‑cɛ\" 'kpa 'a ‑tɩ' ‑tɩn' 'ʋn ɛ, 'mɔ nyiɔ 'ɔ \"Ju 'ma mu ɔɔ' ‑tɩ' ‑tɩn' 'ʋn nʋʋa' ‑sɔntɩ 'ma mua de jia' ‑wɛe 'ɩn ke 'ɩn \"Bo ke ɛɛ' \"soa‑wi\" a muɛ 'nynɩ i 'wlʋa'. ");
INSERT INTO wob_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Sesi 'na : 'Ma 'tmʋʋɛ aopʋ tɔ' ‑tɩ, nyʋ ‑nɩa ‑ta ʋʋa' jrʋ' se 'mɛi 'sʋ ʋʋa jea Kea 'a \"ikmaa' \"jriɛ‑ 'jee‑. ");
INSERT INTO wob_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Sesi ‑kɔa' wlua' kan' a, ɛ nʋɛ 'wɩ ‑mɛ\" na, 'sʋ ɔ \"duo Piɛi ke San ke Sakɩ 'ʋn 'ɛ, ‑wɛe ʋʋ ke ɔ mu Kea baea' 'de crʋ \"kpei. ");
INSERT INTO wob_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","‑Ta ɔɔ baea 'sʋ ɔɔ' \"jua 'a nɩsʋn ‑saa \"i. Ɔɔ' 'ʋnpaadɩ foo\" 'sʋ \"pluu' \"puu', ɩa ‑flaan' 'e nyʋ \"jri. ");
INSERT INTO wob_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Ʋʋa kɔan 'emu 'sʋ, ɔ ke nyʋ 'sɔɔn ‑ɔ wlu, ɛ nɩ Moisɩ ke Eli ke‑. ");
INSERT INTO wob_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Ʋʋ ‑taan' 'de ‑sɔn' 'ʋn ka nyɔ ɔ nɩa 'e jaʋn 'di 'a tʋ\"bodɛ 'ʋn ɛ, ‑wɛe dɩ ‑ɩa mua Sesi \"jrii nʋa' 'de Selisalɛm ɛ, ‑wɛe ʋʋ ke ɔɔ 'tmʋ ɩ. ");
INSERT INTO wob_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","‑Ta ɛɛ nʋa kan' a, ‑mɛ \"nyɩɔ' kpʋn Piɛi ke ɔɔ' \"dɛi‑wi\" 'a \"jri 'mɛ, 'kaa ʋʋ \"jri 'de cɛɛan i 'sʋ ɛ, ʋʋa 'jeɛ Sesi i 'de ‑sɔn' 'ʋn ‑mɛ ɔ ke nyʋ 'sɔɔn ‑nʋ nɩɛ wlua'. ");
INSERT INTO wob_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","‑Ta nyʋ ‑nʋ ke Sesi nɩa \"icɛɛan' a, 'sʋ Piɛi wlu ɔ ‑pee ɔ 'na : 'Ma 'blei, ‑aa ‑ta nɩa' nmɔ \"jrii, ‑a po poe\" taan, ‑mɔ ‑ble due', Moisɩ 'ble due', Eli 'ble due'. Dɛ ɔ nɩa 'tmʋa' 'mʋa‑ ɔɔ' ‑cɛ\" 'ɛ 'wɔn ɛ 'mii. ");
INSERT INTO wob_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Piɛi siɛ wlua' 'sʋ bue\" je ʋʋpʋ \"jru i \"fian‑. 'Sʋ faʋn 'kpa 'de klai\" nynuu 'ʋn 'ɛ. ");
INSERT INTO wob_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","'Sʋ wlu due' ‑wlʋ 'e bue\" ‑nɛ 'di, 'de ‑ɛ ‑na : \"Ju ‑nɔ nɩɛ 'ma \"ju 'ɩn ‑tea' ‑o, ao po ɔɔ' wlu doin\" o ! ");
INSERT INTO wob_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Wlu ‑nɛ ‑kɔa' wlua' 'sʋ ɛ, Sesi nɩɛ due' ɔ je inyna. Klai\" nynuu \"muɛ wɔn. Dɛ ‑tba' 'o ɛɛ' nɔ\" tu 'di ɛ, dɩ \"klein ʋʋ 'jeea \"jriɛ‑ 'mʋa‑ ʋʋa' 'tmʋ ɩ 'de nyɔ jrɔ' ‑pee. ");
INSERT INTO wob_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Sesi ke ɔɔ' klai\" nynuu 'wlʋa 'e crʋ \"kpei ʋʋ \"siai ɛɛ' ‑sɔn' ‑sɩan', nyʋ ‑tuu\"‑tuu ‑jaa' Sesi \"i. ");
INSERT INTO wob_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","'De nyʋ ‑tuu\" ‑nʋ \"klu 'demɔ \"ju due' \"wɔɔ‑ ɔ 'na : 'Ma dɛtɔɔi, 'ma bae ‑ʋn ‑ɛ, ‑ɩn ‑gbʋn 'ma \"ju ‑nɔ ja, 'ma \"ju jɔ due' ‑o. ");
INSERT INTO wob_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","‑Bo ‑suusaʋn kpʋn ɔ 'sʋ ɛ, ɔɔ \"wɔɔ' \"jɛi woi, ɛɛ du ɔ \"i, 'sʋ tɔnfɩʋn' a ji ɔ wɔn i. ‑Bo ɛ 'je 'de ɔ 'ʋn 'wlʋ la a, ‑mɛ ɔ ‑wee' 'kpa dɛ jrɛ' 'ʋn. ");
INSERT INTO wob_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","'Ɩn bae ‑ma klai\" nynuu i 'mɛ, ‑wɛe ʋʋ 'je ɛ 'de ɔ 'ʋn ‑sa, 'kaa ʋʋ se ɛ kwai 'bɛɛ‑. ");
INSERT INTO wob_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","'Sʋ Sesi wlu' ka 'de ɔɔ' klai \"nynuu ‑pee ɔ 'na : Ao \"jrukuʋn ke 'diwɔn nyniʋn 'a ti, kpɛ ‑tiiɛ' ao ke 'ma ‑a ‑je na‑, ‑wɛe 'ɩn 'je aoa' kplɩn \"wɔin 'bɛɛ ‑ɛ ? ‑Wɛe ɔ wlu 'de \"ju ‑saan\" 'a \"bo ‑pee, ɔ 'na : ‑Ɩn ‑ja 'ʋn ‑ma \"ju ‑nɔ ! ");
INSERT INTO wob_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","‑Ta ɔ nɩa ɔɔ' \"ju 'de Sesi ‑pʋn\" kpaa' a, 'bomɔ ‑suusaʋn \"tun \"ju‑saan\"‑, 'sʋ ɔ ‑ka i 'bo 'blʋɔ, ‑wɛe ɔɔ ‑crɛɛn i ‑gbala ‑gbala. 'Kaa Sesi \"wɔɔɛ ‑suusaʋn ‑nɛ \"jrui ‑wɛe ɛ \"si \"kpae 'de \"ju‑saan\"‑ ‑nɔ 'pʋ, ‑wɛe ɔ \"nyɩ ɔ \"bo. ");
INSERT INTO wob_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Nyʋ ‑jea ɛɛ' ‑ta tai' \"maa ʋʋ ‑wee' \"klein 'mɛ 'de Kea 'a \"ikmasʋn ɛ toa 'mʋa 'a ‑tɩ' 'ʋn. ‑Ta ʋʋ nɩɩa dɩ ‑nʋʋa 'mʋa‑ 'jraa' 'bomɔ Sesi wluu 'de ɔɔ' klai\" nynuu ‑pee ɔ 'na : ");
INSERT INTO wob_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","Aopʋ mɔ po 'ma wlu ‑nɛ doin\" o ! nyiɔ 'ɔ \"Ju a muɛ 'e tooa' 'de nyiɔpʋ 'kwa. ");
INSERT INTO wob_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","'Kaa dɛ Sesi 'tmʋa 'mʋa‑ ɔɔ' klai\" nynuu se 'e ɛ 'dei 'wɔn, dɛ‑nʋɛ' ka dɛ ɛ ‑tu\" a 'kwla, 'kamɔ ɛ nɩ 'de ʋʋ ‑pee, ‑wɛe ʋʋ je ɛ 'mii 'wɔn. 'Kaa ʋʋa plee ɛɛ' Sesi 'a i ‑teea' 'mɛ. ");
INSERT INTO wob_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Klai\" nynuu ‑teɛ ‑tooa' ‑pʋn\" 'bo ʋʋpʋ 'a 'sʋ 'nynɩ, ‑wɛe nyɔ ‑nɩa ʋʋpʋ 'a klaa\" a, 'de ʋʋ 'je ɔ juo‑. ");
INSERT INTO wob_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Sesi juua tɔ' ‑nɩa 'e ʋʋ pɛe o 'sʋ, ɔ \"duɛ \"ju ‑saan\" due' 'ʋn, ‑wɛe ɔ nynaa ɔ i 'de ɔ ‑pʋn\", ");
INSERT INTO wob_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","‑wɛe ɔ wlu 'de ʋʋ ‑pee ɔ 'na : Nyɔ ‑kpʋʋn a \"nynumɩɩ\" ‑nɩa ka sɩn 'sɔɔn 'de 'ma 'nynɩ 'ʋn ɛ, ‑mɛ 'mɔ ɔ kpʋʋn sɩn 'sɔɔn. 'De nyɔ ‑kpʋʋn a 'mɔ sɩn 'sɔɔn, ‑mɛ \"ju ‑dboa' 'ʋn mɔ ɔ kpʋʋn a 'o sɩn 'sɔɔn 'mʋa‑. 'Kaa nyɔ ‑ɔ ‑nɩa ‑saan\"‑ 'de aopʋ \"klu ɛ, ɔmɔ ‑nɩ aoa' klaa\". ");
INSERT INTO wob_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","'Sʋ San \"duɛ wlu 'ʋn ɔ 'na : 'Ma dɛtɔɔi, ‑a ‑jɛɛ \"ju due' ‑ɔɔ nʋ ‑siisaɩn i 'de ‑ma 'nynɩ 'ʋn, 'kaa ‑a ‑kaan ɔ ‑je de, dɛ‑nʋɛ' ɔ ke ‑aa' na‑. ");
INSERT INTO wob_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","'Sʋ Sesi wlu' 'de ʋʋ ‑pee ɔ 'na : Ao 'bo ɔ ‑je de kaan, dɛ‑nʋɛ' nyɔ ‑sea' ao o ‑fɔn' ɛ, ‑mɛ ɔ ke ao na'. ");
INSERT INTO wob_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Sesi 'a 'kmʋ 'wlʋ nɔ\" \"kʋʋan‑ i 'sʋ ɛ, ɔ ‑tuɛ\" ‑kaan\"jua ‑wɛe ɔɔ mu Selisalɛm. ");
INSERT INTO wob_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","'Sʋ ɔ dboɛ nyʋ jrʋ' nya. Ʋʋ mua 'sʋ ɛ, ʋʋ paa 'o Samadi 'a ‑kwlɔ due' 'di, ‑wɛe ʋʋ 'je ‑ta ʋʋ ke Sesi 'jea 'pɛn i‑pɔn. ");
INSERT INTO wob_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","'Kaa nyɔ jrɔ' se ʋʋpʋ sɩn 'sɔɔn kpʋʋn‑, dɛ‑nʋɛ' ɛmɛ ‑nɩ ɔ toɛ \"jru 'e Selisalɛm fɔ o. ");
INSERT INTO wob_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Ɔɔ' klai\" nynuu 'sɔɔn Sakɩ ke San 'wɔan dɛ ‑nɛ 'sʋ, ʋʋ 'na : Tʋ\"bo, ‑ɩn ‑nɩɛi\" 'mɛ ‑a ‑je nɛ i ‑tee'‑, ɛ 'je 'e jaʋn 'di 'wlʋ, ‑wɛe ɛ 'je nyʋ ‑nʋ siin‑ ? ");
INSERT INTO wob_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Sesi \"biiɛ i 'de ʋʋpʋ o fɔ o, ‑wɛe ɔ ‑cɛ' ʋʋpʋ \"bli ɔ 'na : ‑Suu ‑ɛɛ ‑tua\" ao dɛ ‑nɛ wɔn ao seɛ juo‑ ? Dɛ‑nʋɛ' nyiɔ 'ɔ \"ju se ji ɔ 'je nyʋ i ‑sa, 'kaa ɔ ji' ɔ 'je nyʋ 'pʋʋ‑. ");
INSERT INTO wob_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","'Sʋ ʋʋ muɛ 'o ‑kwlɔ jrɛ' 'di. ");
INSERT INTO wob_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","‑Ta ʋʋ nɩa mua' 'bo ‑jei\" ɛ, 'bomɔ \"ju due' wluu ka ɔ 'na : ‑Ta \"o ‑ta ‑ma mua 'ɩn ke ‑ma muɛ 'o mua'. ");
INSERT INTO wob_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","'Sʋ Sesi wlu' 'de ɔ ‑pee ɔ 'na : Too'wɛ‑ ‑mɩ \"paa', ɩ je \"bie 'ble. Nʋʋɩ ‑mɩ \"paa', ɩ je 'jro 'ble, 'kaa nyiɔ 'ɔ \"ju se ‑ta ɔ 'jea \"jru 'wlaa‑ 'ble. ");
INSERT INTO wob_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","'Bo ‑mɛ 'de ɛ, Sesi wlu' 'e deejrɔ' o ɔ 'na : ‑Ɩn bla 'bo 'ʋn 'de ! 'Sʋ ‑mɔ 'na : Tʋ\"bo, ‑ɩn ‑tai\"‑ 'mi \"i, 'ɩn 'je 'ma \"bo inmaea' mu ke. ");
INSERT INTO wob_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","'Kaa Sesi wlu' 'de ɔ ‑pee ka ɔ 'na : ‑Ɩn ‑tai\"‑ 'mɛʋn \"i, ʋʋ 'je ʋʋa' 'mɛʋn inmae‑, ‑mɔ mu de 'de ‑ɩn ‑je Kea 'a 'beɔdɛ 'ɛ ‑tɩ' 'tmʋ. ");
INSERT INTO wob_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","'Sʋ \"ju deejrɔ' wlu' 'de Sesi o ɔ 'na : 'Ɩn ‑nɩɛi\", 'ɩn ke ‑ɩn ‑je mu, 'kaa ‑ɩn ‑nyɩ\" 'ʋn nɔ\" dɛ‑saan\" ke 'ɩn 'je 'ma 'cɛ‑wi\" wlu poa' mu 'de ‑gbɛin\". ");
INSERT INTO wob_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Sesi wlu' 'de ɔ ‑pee ɔ 'na : Nyɔ \"o nyɔ ‑tea' kopokla sʋn ‑pʋn\", ‑wɛe ‑ɔɔ ‑gbʋan' de sɔu\" sɔu\" ɛ, ‑mɛ ‑mɔ se Kea 'a 'beɔ ‑kwlɔ 'ɔ ka nɩ‑. ");
INSERT INTO wob_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","'Bo ‑mɛ 'de 'sʋ ɛ, Tʋ\"bo 'cra nyʋ 'a kwla ‑mɛ\" 'sɔn 'jɔ 'sɔɔn 'mii ke'wlɛ 'de nyʋ ‑ke ɔɔ na \"klu, ‑wɛe ɔ dbo ʋʋpʋ nya 'sɔn 'sɔn ‑kwlɛ ke ‑ta \"klein ɔɔ' ‑cɛ\" 'kpa 'jea 'mii mu 'de ɛ, 'de ʋʋ mu ɩ 'dii. ");
INSERT INTO wob_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Ɔ wlu ka 'de ʋʋ ‑pee ɔ 'na : Kea 'a dbo ‑kɔ' ko‑kle klaa\" ‑flu\" 'a, ‑wɛe ‑ɛ sea cɛʋn 'ble ɛ. Ao bae ‑kle' jei ‑wɛe ɔ 'je dbonʋʋn 'de ɔ o ‑kle' ja‑. ");
INSERT INTO wob_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Ao mu, 'ma dbo aopʋ 'mɛ, ka nyɔ ɔ dboa 'blae 'de ‑ci' \"klu ɛ. ");
INSERT INTO wob_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Ao 'bo 'wɛi 'dipodɛ 'ʋn \"duɛ. Ao 'bo ‑ke 'bleɛ, ao 'bo \"kwlai‑ bɩ' ‑tu\" ɛ. Ao 'bo inynaa, ‑wɛe ao 'bo nyɔ jrɔ' sʋn 'kwa poɛ 'bo ‑jei\" ! ");
INSERT INTO wob_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","‑Bo ao pa 'e ‑gbu\" jrɛ' 'di ɛ, ‑mɛ ao wlu ke tɛin\" ao 'na : 'Mɔ ‑je aopʋ, \"diwan kpʋn aopʋ ! Ao 'je pɛe 'a blua' ! ");
INSERT INTO wob_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","‑Bo nyɔ ‑nɩa pɛe 'a blua' \"i nɩ 'e ɛɛ' ‑gbu\" tu 'di ɛ, ‑mɛ aoa' pɛe 'a blua' a muɛ ‑teɩn 'jea' 'de ɔ 'ʋn. 'De ‑bo ɛ se kan' nɩ 'ja a, ‑mɛ aoa' pɛe 'a blua' a muɛ 'de aopʋ 'ʋn de jia'. ");
INSERT INTO wob_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Ao ‑te i 'de ɛɛ' ‑gbu\" tu 'di mamaʋ 'sʋ, diidɛ ʋʋa mua ao \"nyɩa' ao di ɛ, \"ni ʋʋa mua ao \"nyɩa' ao 'nɛ‑, dɛ‑nʋɛ' dɛ ‑ɛ ‑ke dbonʋi ‑kɔɔa' \"i ɛ, ɛmɛ ɔɔ 'je. Ao 'bo ‑gbi\" 'dii 'jreɛ‑. ");
INSERT INTO wob_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","‑Kwlɔ ‑ɛ 'di ao mua ‑wɛe ʋʋ kpʋʋn a ao sɩn 'sɔɔn ‑mɛ dɛ \"o dɛ ʋʋa mua ao \"nyɩa' ao di ɛ. ");
INSERT INTO wob_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Ao 'bɔɔ‑ nyʋ 'a 'wɛ‑ 'bo ɛɛ' ‑kwlɔ tu 'di, ‑wɛe ao 'je wlu ka 'de ‑kwlɔʋn ‑pee ao 'je nʋ : Kea 'a 'beɔdɛ \"kʋʋan‑ aopʋ i ‑wɛ‑. ");
INSERT INTO wob_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","'Kaa ‑bo ao mu 'o ‑kwlɔ jrɛ' 'di ‑wɛe ʋʋ se ao sɩn 'sɔɔn kpʋʋn ɛ, ‑mɛ ao ple ɛɛ' ‑jeblɩ o, ‑wɛe ao 'je wlu ka : ");
INSERT INTO wob_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","Aoa' ‑kwlɔ 'ɔ \"puue' ‑kpʋan' ‑aa bɩ mɔ 'ɔ ‑cɛ\" ɛ, ‑aa ‑gbaoɛ' 'de ao ‑pee, 'de ‑mɛ 'kamɔ ‑aa ‑tmʋʋ' aopʋ : Kea 'a 'beɔdɛ mɛ ‑kpaa' aopʋ ‑pʋn\" 'mʋa‑, 'kaa ao se ɛ \"jriɛ‑ o sie. ");
INSERT INTO wob_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","'Ma 'tmʋʋ aopʋ 'mɛ, 'de de 'bɔɔ ‑sɔn 'di ɛ, ɛɛ' ‑kwlɔ tu 'a 'pee a muɛ \"ikmaa' ɛ 'je Sodɔm ‑kwlɔ 'ɔ ‑nɛ ‑sii. ");
INSERT INTO wob_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Ɛ nɩɛ \"nmia‑tɩ 'de aopʋ Korasɛnyʋ ke Besaidanyʋ 'a ‑tɩ' 'ʋn, dɛ‑nʋɛ' jrii' ‑nʋʋa 'bo aoa' ‑kwea' ‑ta, ‑bo ɩ nʋʋɛ 'de Tii ke Sidɔn ‑kwlɛ ‑ɩ sea Suifʋ 'a ‑kwlɛ nɩ 'de ɛ, ‑mɛ nyʋ ‑nɩa 'o ɩa' ‑kwlɛ tu 'di ɛ, ʋʋ to ʋʋa' kplɩn fai\" poosʋn ‑wɛ‑ sese 'de‑ 'de blɔ 'ʋn paa' ke biun' \"jru 'wlaa' 'ʋn. ");
INSERT INTO wob_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Ɛmɛ ‑tɩ 'pee a 'wɩ o ɛ, Tii ‑nyʋ ke Sidɔn‑nyʋ 'a 'pee se \"ikmai, ɛ se aoa' 'pee ‑sii i. ");
INSERT INTO wob_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","'De ‑mɔ ɛ Kapɛnaʋm‑kwlɔ, ‑mɔ ‑na ‑ɩn ‑je mu 'sʋ ‑ɩn ‑je jaʋn tbaa‑ ? Ɛ se kan' nɩ‑. ‑Ma muɛ ‑sɔn jia' mamaʋ 'sʋ ‑ɩn ‑je 'e 'mɛʋn o ‑kwlɔ ‑taan'‑. ");
INSERT INTO wob_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","‑Wɛe ɔ wlu 'de ɔɔ' klai\" nynuu o ɔ 'na : Nyɔ ‑po' aoa' wlu doin\" o ɛ, ‑mɛ 'ma wlu mɛ ɔ po doin\" o. Nyɔ ‑fuuan aopʋ‑ nya a, ‑mɛ 'mɔ ɔ ‑fuun nya ‑ke. ");
INSERT INTO wob_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","‑Ta klai\" nynuu ‑nɩa kwla ‑mɛ\" 'sɔn 'jɔ 'sɔɔn jiia de ɛ, ʋʋ nɩɛ 'e 'mʋa‑ 'ʋn, ‑wɛe ʋʋ wlu ka ʋʋ 'na : Tʋ\"bo, ‑bo ‑a ‑wlu ‑siisaɩn ‑cɛɛn'‑ ‑nɩ ‑pee 'de ‑ma 'nynɩ 'ʋn ɛ, ɩa 'jeɛ ‑a wɔn ɩa ja 'de nyʋ 'ʋn 'wlʋ ! ");
INSERT INTO wob_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","'Sʋ Sesi wlu' 'de ʋʋ ‑pee ɔ 'na : 'Ɩn 'jeɛ ‑siɔn' i, ɔɔ jea 'e \"jɛi 'wlʋ ɔɔ jea blu ka \"sɩɩɩ se ‑ʋn ‑je a blʋa. ");
INSERT INTO wob_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Ao ‑gbʋn 'nɔ, 'ɩn \"nyɩ aopʋ \"ikmaa' 'mɛ, ‑wɛe ao 'je sɛn ke ‑kɩan\" ‑kɩan' \"kpei‑ na‑, ‑wɛe ao 'je ‑aa tʋnyɔ 'ɔ \"ikmaa' ‑wee' \"klein ɔ 'kwa ‑sa. 'De ɩ se aopʋ dɛ jrɛ' nʋʋi. ");
INSERT INTO wob_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","‑Bo ‑siisaɩn a sea aopʋ wɔn 'je ɛ, ao 'bo 'mʋa‑ nʋɛ 'de ɛɛ' ‑tɩ' 'ʋn, 'kaa ka ao 'kpa Kea 'a nyʋ mɛ ‑ɛɛ 'mʋa‑ ao 'je nʋ. ");
INSERT INTO wob_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","'De ɛɛ' nɔ\" tu 'di ɛ, Kea 'a ‑Suu \"jiiɛ Sesi 'mʋa‑ 'ʋn, ‑wɛe ɔ ‑ciian' ku' i 'de ɔ 'na : 'Oo, 'ɩn \"Bo, ɛmɛ ‑nɩa 'blʋa‑ ke jaʋn 'a 'beɔ ɛ, 'ma poɛ ɛ 'sɛ‑, dɛ‑nʋɛ' ɛ ‑tuɛ\" dɩ ‑nɩ 'kwla 'de tɔ' 'dinɩʋn ke dɛ \"ijuoʋn ‑pee, ‑wɛe ɛ ‑sɩ 'kwla 'de nynumɩɩ\" ‑pee. ‑Kai\" 'matɛ, 'ɩn \"Bo, dɛ ɛɛ' ‑cɛ\" 'kpa 'wɔɔan ɛɛ' dɛ tu ɛ, 'ma poɛ ɛ ɛɛ' 'sɛ‑. ");
INSERT INTO wob_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","'Sʋ ɔ 'na : 'Ɩn \"Bo \"nyɩ 'ʋn dɩ ‑wee' \"klein 'mɛ. Nyɔ jrɔ' se \"Ju juo‑, ‑bo ɛ se ɔ \"Bo nɩ ɛ. Nyɔ jrɔ' se \"Bo juo‑, ‑bo ɛ se ɔɔ' \"Ju nɩ ɛ. Ɛ ke nyɔ \"ju nɩɛ \"i ɔ 'jea ɔ \"Bo 'kwla ‑sa 'de ‑pee nɩ ɛ. ");
INSERT INTO wob_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Ɔ \"biia i 'de ɔɔ' klai\" nynuu o, ɔ wlu 'de ʋʋa' 'sʋ ‑pee ɔ 'na : Ao ‑jea ɩa' dɩ tu 'a ‑ta, aopʋ mɔ nʋ 'mʋa‑, ");
INSERT INTO wob_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","dɛ ɛɛ ‑tɩ 'ma 'da kan', ɛmɛ ‑nɩ Kea 'a wlu 'kwajaaʋn 'a ‑tuu\"‑tuu ke 'beɔ‑wi\" ‑nɩɛi\" dɩ ao 'jea ʋʋ 'jɩ 'je 'de‑, 'kaa ʋʋ sɩ 'je. Ʋʋ nɩɛ \"i ke'wlɛ dɩ ao 'wɔan ʋʋ 'jɩ 'wɔn 'de‑, 'kaa ʋʋ sɩ 'wɔn. ");
INSERT INTO wob_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Kɛ' wɔ‑sai due' ‑nɩɛ \"i ‑ɔ ‑je Sesi wlu 'a \"klɛ ‑pee ‑gba, ɔmɔ ‑sɔn 'ʋn 'de nyʋ \"klu ‑wɛe ɔ ‑teeɔ' i ‑ɔ ‑na : Nyʋ dɛtɔɔi dɛ 'ɩn 'je nʋ ‑wɛe 'ɩn 'je 'kmʋnɩa' ‑sea' ‑kwɛ ‑ta 'ble 'je ɛ‑ ? ");
INSERT INTO wob_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Sesi ‑tee' ɔ i ɔ 'na : Dɛ ‑wɛ ‑crɩɩɛ' 'de Kea 'a kɛ' 'di ɛ‑ ? ‑Bo ‑ɩn nʋ ɛ 'dii 'ee, ka ‑ma ‑wɔn ɛ 'mii ɛ‑ ? ");
INSERT INTO wob_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","\"Ju ‑nɔ 'na : ‑Ɩn ‑kma ‑ma Tʋ\"bo Kea 'a ‑tɩ' 'de ‑ma pɛe ‑wee' \"klein 'ʋn, 'de ‑ma 'kmʋnɩa' ‑wee' \"klein 'ʋn, 'de ‑ma tɔ' ‑wee' \"klein 'ʋn, ‑ma 'kpɩ ‑wee' \"klein 'ʋn, ‑wɛe ‑je ‑ma ‑ponyiɔ 'ɔ ‑tɩ' kma ka ‑ɩn ‑kma ‑ma ‑cɛ\" 'kpa 'a ‑tɩ' ɛ ! ");
INSERT INTO wob_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","'Bomɔ Sesi wluu 'de ɔ ‑pee ɔ 'na : Ɛ nmɔi\", ‑ɩn ‑sɛ \"kpei 'mɛ ka ‑cɔɔn' ka. ‑Bo ‑ɩn nʋ kan' a, ‑ma muɛ 'kmʋnɩa'. ");
INSERT INTO wob_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","'Kaa kɛ' wɔ‑sai ‑nɔ nɩa \"i ɔ 'jea ɔɔ' ‑cɛ\" ‑kɩn \"nyɩ ɛ, ɔ wlu' ka 'de Sesi ‑pee ɔ 'na : ‑Ɔ ‑nɩ 'ma ‑ponyiɔ ‑gblein' ɛ‑ ? ");
INSERT INTO wob_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","'Bomɔ Sesi \"duo wlu 'ʋn 'de ɔ poo ‑tɩ' \"i ɔ 'na : ‑Ta \"ju due' a 'wlʋa Selisalɛm ‑wɛe ɔɔ muua Seriko ɛ, 'bomɔ ɔ 'kpaa' 'e \"jriʋn 'a bɔ' 'di 'bo ‑jei\". 'Sʋ ʋʋ kpʋn ɔ', ʋʋ blɔ' 'mɛ ka, ‑wɛe ʋʋ \"duo ɔɔ' dɩ ‑wee' 'ʋn, 'de ʋʋ si ɔ 'o ‑jei\" 'mʋa‑. ");
INSERT INTO wob_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Kea 'a 'sraa ‑sai due' ‑kpa' ɛɛ' ‑je tu ɛ, ‑mɔ 'jeɔ', 'kaa ɔ se 'de ɔ o \"dɛɛ‑, ɔ cɩn ɔ \"kpei ‑tie\". ");
INSERT INTO wob_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","\"Ju due' ‑wlʋa 'e Lefi 'a \"ji 'di, ‑ɔɔ kpa ɛɛ' ‑je tu ɛ, ɔ 'je \"ju ‑nɔ 'mɛ ‑ke, 'kaa ɔ 'blaa ɔ je ‑si'. ");
INSERT INTO wob_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","'Kaa Samadi i due' ‑nynia' 'o \"ju ‑nɔ ‑pʋn\" ɔmɔ ‑nyna i, ‑ɔ ‑gbʋn ɔ ja, ‑wɛe ɔɔ' wɛe a nʋ. ");
INSERT INTO wob_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Ɔmɔ ‑kpɔ ‑pʋn\", 'de ‑ɔ po ɔɔ' blati 'a ‑kɔ 'cna ke nmɔ \"i, ‑wɛe ɔ blɩ dɛ \"i. 'Sʋ ɔ ‑te' ɔ 'o ɔɔ' ‑cɛ\" 'ɛ soofae' \"kpei ‑wɛe ɔ kpɔ 'o 'dʋɩ‑ 'a dɛdi‑gbu ‑kʋʋan\" ‑je i 'di. 'Bomɔ ɔɔ ‑tuu\"‑ ɔɔ' ‑tɩ'. ");
INSERT INTO wob_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","‑Sɔn' ‑sɩan' 'sʋ, ɔ \"nyɩɛ dɛdi‑gbu 'a jei 'wɛi ‑wɛe ɔ 'na : ‑Ɩn ‑tu\" ɔ \"jriɛ‑, dɩ \"klein ‑ma mua nʋa' 'bo ‑mɩ 'de ɛ, ‑bo 'ɩn ji de ɛ, ‑wɛe 'ɩn 'je ɩa' kpan ‑sa. ");
INSERT INTO wob_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","‑Wɛe Sesi ‑tee' kɛ' wɔ‑sai ‑nɔ i ɔ 'na : 'Bo nyʋ taan ‑nʋ \"klu 'ee, nyɔ ‑nɩ \"ju \"jriʋn bla ‑nɔ 'ɔ ‑ponyiɔ ɔ‑ ? ");
INSERT INTO wob_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","'Sʋ kɛ' wɔ‑sai 'na : Ɛ nɩ \"ju ‑ɔ ‑je ɔɔ' wɛe ‑o. 'Sʋ Sesi 'na : ‑Bo ‑ɩn mu ɛ, ‑mɛ ‑ɩn nʋ kan' ! ");
INSERT INTO wob_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","‑Ta Sesi ke ɔɔ' klai\" nynuu nɩa 'o ‑jei\" ɛ, 'bomɔ ʋʋ nyni 'o ‑kwlɔ due \"di, ‑wɛe 'nynɔkpao' due' 'da ʋʋpʋ dɛdi ‑tɩ 'de ʋ o ‑gbu\" 'di. Ʋa' 'nynɩ ‑nɩ Matɩ. ");
INSERT INTO wob_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Ʋ 'bleɛ \"deinynɔkpao' due' ‑ʋa 'nynɩ nɩ Madi, 'de ‑ʋ ‑te i 'bo Tʋ\"bo bɩ o, ‑wɛe ʋa po ɔɔ' wlu doin\" o. ");
INSERT INTO wob_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","'De Matɩ ‑mʋ a ‑siiɛ' 'ʋn 'de dɛpia' 'ʋn, 'sʋ ʋ 'kpa Sesi ‑pʋn\" ʋ 'na : Tʋ\"bo, ɛ se ‑ʋn dɛ jrɛ' nʋʋ mɔ ‑wee', ‑wɛe 'ma \"dei \"tai‑ 'mi \"i 'de 'ɩn nɩ due' 'ma ‑sii' 'ʋn kaa ? ‑Ɩn ‑tmʋʋ' ʋ ke ʋ 'je 'ʋn sʋn o po 'de ! ");
INSERT INTO wob_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","'Bomɔ Tʋ\"bo wluu 'de ʋ ‑pee ɔ 'na : Matɩ, Matɩ, aa ‑sii' 'ʋn 'ɛ, aa ‑tʋɛ\" ‑sɔɔn aa 'wla dɩ ‑tuu\"‑tuu 'a ‑fli i ‑tadue. ");
INSERT INTO wob_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Dɛ due' koʋn ‑gbai' ‑kɔan ‑tɩ' ɛ, ɛmɛ Madi ‑sa 'o, ɛ se ʋ 'kwa 'wlʋi 'nɔ 'kmʋ. ");
INSERT INTO wob_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","'Wɩ jrɛ' o Sesi nɩɛ Kea baea' 'de ‑tajrɔ. Ɔ ‑kɔa' baea' 'sʋ, ɔɔ' klai\" nynuu 'a due' wlu' 'de ɔ ‑pee ɔ 'na : Tʋ\"bo, ‑ɩn ‑tɔɔ ‑aʋn Kea bae ka‑, ka San tɔɔa ɛ ɔɔ' klai\" nynuu ɛ. ");
INSERT INTO wob_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","'Sʋ Sesi wlu' 'de ʋʋpʋ ‑pee ɔ 'na : ‑Bo aoa sea Kea bae ɛ, ao 'nʋ : ‑A \"Bo, ɛɛ' 'nynɩ ‑tee kpɔi\". Ɛ nʋɛ ‑wɛe ɛɛ' 'beɔdɛ 'je \"jri \"kpae po. ");
INSERT INTO wob_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Ɛ ‑nyɩ\" ‑aa ‑sɔn' 'di diidɛ. ");
INSERT INTO wob_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Ɛ 'wlʋ ‑aa dɩsaɩn \"kpei ka ‑aa ‑wlʋa nyʋ ‑nʋa' ‑aʋn dɩsaɩn \"jrii 'a ‑nɛ \"kpei ɛ. Ɛ nʋɛ ‑wɛe ‑siɔn' 'bo ‑aʋn 'de dɛsaʋn 'di poa' i ‑tɩɛn' ɛ. ");
INSERT INTO wob_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","‑Wɛe ɔ wlu 'de ʋʋ ‑pee ke'wlɛ ɔ 'na : ‑Bo aoa' due' 'ble \"dɛi, ‑wɛe ɔ 'je ɔ jɛɛ ‑too' ‑kwea, 'de ɔ 'je ɔ ‑pee wlu ka : 'Ɩn ba, ‑ɩn po 'ʋn ‑di'pɛn kplɩ taan kpan' ke, ");
INSERT INTO wob_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","dɛ‑nʋɛ' 'ma \"dɛi‑wi\" 'a due' ‑wlʋ 'doa' ‑ɔ ji 'de 'ʋn wɔin\", 'kaa dɛ 'ɩn 'je ɔ \"nyɩ ɔ 'jea di ɛ, ɛ se nɩ‑. ");
INSERT INTO wob_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","‑Bo ‑jɔ ‑mɔ nɩɛ 'e ‑gbu\" 'de ɔ 'je nʋ : ‑Ɩn ‑bo 'ʋn seaa 'bo ‑gbɛin\" kaan' ! 'ɩn ke 'ma \"nynuu‑ kpʋn 'pɛin ‑wɛ‑ 'bode. 'Ɩn se ɛ 'bɛɛ‑ 'ɩn 'je 'ʋnsɔn‑, ‑wɛe 'ɩn 'je ‑ʋn ‑di'pɛn \"nyɩ. ");
INSERT INTO wob_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","'Kaa ɔɔ' \"dɛi ‑nɔ, ka ɔɔ bla kpaa\" 'ka ɔɔ blɛ. 'Ma 'tmʋʋ aopʋ 'mɛ, ‑bo \"ju ‑pean i ‑nɔ se 'ʋn sɔn 'de ʋa' dbɛɛ dɛ 'ɛ ‑tɩ' 'ʋn ɛ, ɔɔ muɛ 'ʋn sʋan' 'de naɩ\" 'blea 'ʋn ‑wɛe ɔ 'je ɔ dɛ \"o dɛ ɔɔ ‑pɔan \"nyɩ. ");
INSERT INTO wob_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","'De 'mɔ 'naa : Ao ‑tee' dɛ i, nyʋ a mu ao \"nyɩa', ao ‑pɔn dɛ i, aoa mu ɛ 'jea', ao bla klu, nyʋ a mu ao \"wɔin kaian'. ");
INSERT INTO wob_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Dɛ‑nʋɛ' nyɔ \"o nyɔ ‑teea' dɛ i ɛ, nyʋ a \"nyɩɔ', nyɔ \"o nyɔ ‑pɔan dɛ i ɛ, ɔɔ 'jeɛ', nyɔ \"o nyɔ ‑bla' klu ɛ, nyʋ a kain ɔ \"wɔin. ");
INSERT INTO wob_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Ao ‑nɩa \"bo ‑wi\" 'ee, nyɔ ‑wɛ ‑nɩ 'de aopʋ \"klu, ‑bo ‑ɔɔ \"ju ‑tee' ɔ ‑di'pɛn i ‑wɛe ‑ɔɔ ‑nyɩɔ\" \"sou ɛ‑ ? 'De ‑bo ɔ ‑tee' ‑smii' i, ‑wɛe ɔɔ ‑nyɩ\" ɔ sɛn ɛ‑ ? ");
INSERT INTO wob_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","'De ‑bo ‑ɔɔ \"ju ‑tee' ɔ sʋn\" ‑kɩɩn i, 'sʋ ‑ɔɔ ‑nyɩ\" ɔ ‑kɩan\" ‑kɩan' a‑ ? ");
INSERT INTO wob_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Aopʋ ‑jɔ ‑nɩa 'diwɔnyniʋn ɛ, ‑bo ao juo aoa' \"nynuu‑ dɩ 'dɔe \"nyɩ ka 'ee, 'de ‑mɛ ‑a \"Bo Kea ‑nmɔa 'di wɔn ɛ se ɛ 'bɛɛ‑ ɛ 'je ɛɛ' ‑Suu nyʋ ‑ʋʋa ‑teeɛ' i \"nyɩ ? Ɛɛ mu ɛ ʋʋpʋ \"nyɩa'. ");
INSERT INTO wob_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","'Wɩ jrɛ' o Sesi ‑sa \"muu‑ due' ‑suusaʋn 'ʋn. ‑Ta ɛ 'wlʋa 'de ɔ 'ʋn 'sʋ ɛ, ɔ ‑teɛ wlua' ‑pʋn\", 'sʋ ɛ siɛ nyʋ ‑wee' 'kaa' 'kwa. ");
INSERT INTO wob_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","'Kaa nyʋ jrʋ' 'na : Bɛsebuilɩ ‑nɩa ‑siisaɩn 'a klaa\" a, ɛmɛ ‑nyɩ\" ɔ \"ikmaa' ‑wɛe ɔɔ nʋ ‑siisaɩn i. ");
INSERT INTO wob_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Nyʋ jrʋ' ‑nɩɛi\" ʋʋ 'jea Sesi i ‑tɩɛn' ɛ, 'sʋ ʋʋ 'na : ‑Ɩn nʋ jrii' ‑ɛ ‑je ɛ to ka ‑ma \"ikmaa' 'wlʋa 'e Kea 'ʋn ɛ. ");
INSERT INTO wob_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","'Kaa Sesi juo ʋʋpʋ 'a tɔ' 'mɛ, 'sʋ ɔ wlu' 'de ʋʋ ‑pee ɔ 'na : 'Blʋa‑ \"o 'blʋa‑ ‑ɛɛ 'bleenyʋ 'a 'sʋ a ‑seea' 'ʋn ɛ, ɛɛ' ‑kwle ja ‑gba' ‑tɩ, ‑wɛe ɛɛ' ‑gbi\" 'a se 'wla. ");
INSERT INTO wob_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","‑Bo ‑siɔn' ɔ sea ɔɔ' ‑cɛ\" o ‑fɔn' 'ee, ‑mɛ ka ɔɔ' tʋ\"bodɛ 'e dɛ 'ʋn 'wlʋsʋn nʋ ɛ‑ ? Ao 'na : Bɛsebuilɩ ‑nyɩ\" 'ʋn \"ikmaa' ‑wɛe 'ma nʋ ‑siɔn' 'ɔ ‑sii i. ");
INSERT INTO wob_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","‑Bo 'ma sea ‑siɔn' 'ɔ ‑sii inʋ kan' ‑mɔ 'ee, 'de ‑mɛ aoa' \"nynuu‑ mʋ 'ee, nyɔ ‑ɔɔ 'nynɩ 'ʋn ʋʋa nʋʋ ‑siɔn' 'ɔ ‑sii i ɛ‑ ? Ɛmɛ ‑tɩ ‑wɛe ʋʋa' ‑cɛ\" 'kpa a mu aoa' 'pee kpʋʋnyʋ nɩa'. ");
INSERT INTO wob_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","'Kaa ‑bo ɛ nɩ Kea 'a sʋn mɛ ‑nɛ 'ʋn \"kpei ‑wɛe 'ma nʋ ‑siɔn 'ɔ ‑sii i ɛ, ‑mɛ Kea 'a 'beɔdɛ mɛ ‑jɛɛa 'o aopʋ 'mʋa‑. ");
INSERT INTO wob_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Aoa 'jee, nyɔ ‑kmai\" 'de ‑ɔ ‑blea poodɩ ɛ, ‑bo ɔɔ sea ɔɔ' ‑gbu\" ifuo ɛ, ɔɔ' 'bleedɩ ‑wee' \"klein kpʋɛn \"i. ");
INSERT INTO wob_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","'Kaa ‑bo ‑jɔ ‑kmai\" ‑ɔ ‑sii ɔ ‑mɔ ji ɛ, ɔ sɔn' ‑wɛe ɔ ‑sɔ poodɩ ‑jɩ ɔ ‑tea' ‑kwlɩ\" 'kwa 'de ɔɔ ‑gble' \"ju ‑nɔ 'ɔ 'bleedɩ nyʋ jrʋ' \"jrii. ");
INSERT INTO wob_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Nyɔ ‑ke 'mɔ sea na a ‑mɔ ɔ ‑fɔn' 'ʋn o, 'de nyɔ ‑ke 'ma ‑aa' 'kɩɩan nyʋ \"jrui ‑tadue ɛ, ‑mɛ ɔɔ tɛɛn 'ʋn nyʋ o. ");
INSERT INTO wob_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","'Sʋ Sesi pooɛ ‑tɩ' \"i ɔ 'na : ‑Bo ‑suusaʋn 'wlʋ 'de nyɔ 'ʋn ɛ, ka nyɔ ɔ 'wlʋa 'e ‑gbu\" 'di ‑wɛe ɔɔ mua 'de \"miia \"kpei, 'kamɔ ɛ nɩ‑. Ɛɛ ‑pɔn ‑teɩn i. ‑Bo ɛ se ‑teɩn 'je 'sʋ ɛ, ɛ 'na : 'Ma jiɛ 'de 'ma ‑gbu\" ‑ɛ 'di 'ɩn 'wlʋa de mua'. ");
INSERT INTO wob_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Ɛ mua de, ɛɛ jɛɛa ɛɛ' ‑gbu\" ɛ, ‑mɛ ɛ wuuɛ 'dii 'pepe, dɩ ‑wee' ‑teeɛ kpɔi\", ‑wɛe ɛ nɩ foo\". ");
INSERT INTO wob_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","'Sʋ ɛ muɛ de ‑wɛe ɛ \"duo ‑siisaɩn ‑mɛ\" 'sɔn ‑ɩ ‑kmai\" ‑ɩ ‑sia ɛmɛ 'ʋn 'de ɩ ke ɛ ji 'de ‑gbu\" 'di de. 'Kamɔ ɛ nɩ 'de nyiɔ ‑nɔ 'ɔ ‑tɩ' 'ʋn. ‑Bo Kea 'a ‑Suu se 'de ɔ pɛe o nɩ 'sʋ ‑siisaɩn kpʋɛn ‑teɩn 'de ɔ 'ʋn, ‑wɛe \"ju ‑nɔ 'ɔ de 'bɔɔ‑ kplɩn nyni \"jrii, ɩ ‑sii ‑jɩ ‑nɩa tɛin\" ɛ. ");
INSERT INTO wob_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","‑Ta Sesi nɩɩa wlua' kan' a, 'sʋ 'nynɔkpao' due' wlu ɔ ‑pee 'de nyʋ \"klu ʋ 'na : 'Nynɔkpao' ‑ʋ ‑wlʋa ‑ʋn ‑wɛe ‑ʋa nyɩɩɛ ‑ɩn ‑nya' ‑mʋ 'a 'nynɔkpao' tu peeɛ \"juɔi. ");
INSERT INTO wob_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","‑Wɛe Sesi wlu ka ɔ 'na : Nyʋ ‑ʋʋa poa Kea 'a wlu doin\" o 'de ‑ʋʋa ‑teɛ' i 'de ʋʋpʋ 'ʋn ɛ, ‑wɛe ka ɛ \"sia 'nynɩ ‑ʋʋa nʋa kan' a, ‑wi\" ‑mʋ ‑peeɛ \"juɔi ka‑. ");
INSERT INTO wob_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","‑Ta nyiɔpʋ ‑tuu\"‑tuu ‑gbaea' Sesi 'dei ɛ, 'bomɔ ɔ ‑te wlua' ‑pʋn\" 'de ʋʋ ‑pee ɔ 'na : Nyʋ ‑nɩa ‑sɩan wɩ 'di ‑ʋʋ 'di nynia wɔn ɛ, ʋʋpʋ ‑a ‑tee' 'ʋn jrii' ‑ɛ ‑toɛ ka 'ɩn 'wlʋa 'de Kea o i. Jrii' jrɛ' se nʋʋɛi 'bode, ‑bo ɛ se ‑jɛ ‑nʋʋa 'de Sonasɩ 'a ‑tɩ' 'ʋn nɩ ɛ. ");
INSERT INTO wob_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Ka Kea nʋa ɛɛ' ‑cɛ\" tosʋn 'de Sonasɩ 'a 'kmʋ 'ʋn ‑wɛe nyʋ ‑nɩa Ninifʋ 'jee ɛ \"jriɛ‑ ɛ, 'kamɔ Kea a muɛ tooa' 'de nyiɔ 'ɔ \"ju 'a ‑tɩ' 'ʋn ‑wɛe nyʋ ‑nɩa ‑sɩanwɩ 'di 'je ɛ \"jriɛ‑ 'jee‑ ‑ke. ");
INSERT INTO wob_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Tʋ\"bo nynɔkpao' ‑wlʋa 'de 'jrʋ' 'a ‑gbɩnfɔ o 'de Sebablʋa \"kpei ɛ, ʋa muɛ 'ʋn sɔan' 'peewɩ o, ‑wɛe ʋ 'je nyʋ ‑nɩa ‑sɩanwɩ 'di 'pee kpʋʋn‑, dɛ‑nʋɛ' ʋ 'wlʋɛ 'de 'blʋa‑ ‑tɔɔn \"kpei ‑wɛe ʋ ji Salomɔ 'ɔ tɔ' wlu doin\" o poa'. Ao ‑gbʋn 'nɔ, ‑jɔ ‑nɩa ‑ta ‑mɔ 'bɛi\" ɔ je Salomɔ ‑sii. ");
INSERT INTO wob_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Nyʋ ‑wlua Ninifʋ ʋʋ ke nyʋ ‑nɩa ‑sɩanwɩ 'di a muɛ ‑tadue plaan' 'peewɩ o, ‑wɛe ʋʋ 'je 'ʋn sɔn 'de ʋʋ 'je ʋʋpʋ 'pee kpʋʋn‑, dɛ‑nʋɛ' ‑ta Sonasɩ 'tmʋa Kea 'a ‑tɩ' 'de ʋʋ ‑pee ɛ, ʋʋ pooɛ tɔ' fai\" 'bo ɔɔ' wlui\". Ʋʋ \"biiɛ 'e Kea o, ‑wɛe ʋʋ cɛn ʋʋa' dɩsaɩn 'a ‑kɩn ʋʋ \"nyɩ ɛ. Ao ‑gbʋn 'nɔ, ‑jɔ ‑nɩa ‑ta ‑mɔ 'bɛi\" ɔ je Sonasɩ ‑sii. ");
INSERT INTO wob_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Sesi pooɛ ‑tɩ' \"i ɔ 'na : Nyɔ se ɛ 'bɛɛ‑ ɔ 'je nɛbi tba ‑wɛe ɔ 'je ɛ i ‑tu\" 'de jae ‑sɔn, 'kaa nyɔ ɔ ‑teɛ' ‑ta ‑tɛan ja ‑wɛe nyʋ ‑wee' ‑a pa 'de ‑gbu\" 'di ɛ, ʋʋa 'je ɛ i. ");
INSERT INTO wob_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","‑Ma \"jriɛ‑ mɛ ‑nɩ ‑ma ku 'a ‑sɔn'. ‑Bo ‑ma \"jriɛ‑ se poa a, ‑mɛ ‑ma ku ‑sɔn i nɩɛ ‑faoo'. ");
INSERT INTO wob_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","‑Ɩn ‑tu\" ‑ma ‑cɛ\" 'ɛ ‑tɩ' ‑wɛe ‑sɔn' ‑nɩa 'de ‑ɩn 'ʋn ɛ, ɛ je kwie 'ʋn ‑snɛɛ. ");
INSERT INTO wob_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","‑Bo ‑ma 'kmʋ ‑wee' \"klein nɩ 'e ‑sɔn' 'ʋn ɛ, ‑wɛe ɛɛ' 'fɔ jrɛ' se 'de kwie 'ʋn nɩ ɛ, ‑mɛ ɛ ‑wee' nɩɛ 'de ‑sɔn' 'ʋn. Ka ‑dam'ba a wan 'bo ‑ʋn \"juɔi ‑wɛe ‑ma ‑jea i ɛ, 'kamɔ ɛ nɩ‑. ");
INSERT INTO wob_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","‑Ta Sesi nɩa wlua' kan', 'sʋ Fariseɛn due' 'dɔ dɛdi ‑tɩ 'de ɔ o ‑gbu\". Ɔ mua 'e ɛ, ɔ ‑teɛ dɛ dia' ‑pʋn\". ");
INSERT INTO wob_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Tai' \"maa Fariseɛn 'mɛ, dɛ‑nʋɛ' Sesi se kwa jre ka tɛin\"nyʋ a nʋa see ɛ, 'sʋ ɔ je dɛ dia' ‑pʋn\" ‑te. ");
INSERT INTO wob_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","'Kaa Sesi wlu' 'de ɔ ‑pee ɔ 'na : Ao Fariseɛn‑wi\", ka ao nɩa 'ka ka : aoa wɔɔ 'bo 'di 'naadɛ ke \"tiedɩ 'a ku ‑pʋn\" 'a 'sʋ, 'kaa \"jriia' ke 'diwɔnynia' \"ji 'de aoa' ‑cɛ\" 'kpa 'ʋn 'ɛ. ");
INSERT INTO wob_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Ao ‑gbʋn ka ao sea tɔ'di nɩ ɛ ! Kea ‑nʋa' dɛ 'ɛ ku ɛ, ɛmɛ se 'e ɛ 'di nʋ ‑kee ? ");
INSERT INTO wob_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Aoa' pɛe mɛ ao 'je wɔɔ ka‑ ! Dɛ ao 'jea nʋ ɛ, ɛmɛ ‑nɩ dɛ ‑nɩa 'de aoa' ‑kaun\" ke aoa' \"tiedɩ 'di ɛ, ao 'wɔɔn‑ ɛɛ' nɩɩa\" nyʋ \"nyɩ‑tɩ ‑wɛe dɩ ‑wee' \"klein 'je i‑kwɛ‑ 'de aoa' ‑tɩ' 'ʋn. ");
INSERT INTO wob_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","Ɛ nɩɛ \"nmia‑tɩ ‑o 'de aoa' ‑tɩ' 'ʋn Fariseɛn‑wi\", dɛ‑nʋɛ' sii\" mɩɩ\" ka 'bɛɛ‑ ke flɩ nɩa ‑ɩ ‑nɩa kan' a, ɩa' sɔɔn'ɔ ‑puue ‑nɛ ɩmɩ aoa \"duo 'ʋn ‑wɛe aoa ‑saa Kea wɔn, 'kaa \"isrɛa' ke Kea 'a ‑tɩ' kmaa' ‑mɩ aoa nʋʋ 'plʋ 'ʋn 'de ‑mɩ ao 'je nʋ ke tɛin\" 'de‑, ‑wɛe dɩ mɩɩ\" ‑jɩ ‑mɩ 'je de 'bɔɔ‑. ");
INSERT INTO wob_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","Ɛ nɩɛ \"nmia‑tɩ ‑o 'de aoa' ‑tɩ' 'ʋn Fariseɛn‑wi\", dɛ‑nʋɛ' \"kpa‑tɩ klae\" ‑nɩa 'e nya 'de \"jrui 'kɩɩn‑gbi 'dii ɛ, aoa 'jeɛ ɩa' \"kpei ‑tea' 'a \"dia, ‑wɛe aoa ‑pɔn 'de nyʋ 'je aopʋ‑ 'a ni' ‑te' 'bo nyʋ ‑kwea ka \"jrujeʋn nɩa. ");
INSERT INTO wob_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Ɛ nɩɛ \"nmia‑tɩ ‑o 'de aoa' ‑tɩ' 'ʋn, dɛ‑nʋɛ' ao ‑kɔ' ‑gbaɩn' ‑ɩ ‑nɩa 'o 'blʋ ‑sɔn, nyɔ ɔ na \"kpei‑ 'sʋ nyɔ 'ɔ jua. ");
INSERT INTO wob_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","'Bomɔ kɛ' wɔ‑sai due' \"duo wlu 'ʋn 'de nyʋ \"klu ɔ 'na : Nyʋ dɛtɔɔi, ‑bo ‑ma sea kan' ‑mɔ 'da 'ee, ‑mɛ ‑ma ‑cree\" ‑apʋ mɔ 'mɛ ‑kee ? ");
INSERT INTO wob_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","'Sʋ Sesi wlu' ɔ 'na : Ɛ nɩɛ \"nmia‑tɩ ‑o 'de aopʋ mɔ'ɔ ‑tɩ' 'ʋn ‑ke, kɛ' wɔ‑saʋn, dɛ‑nʋɛ' aoa ‑teɛ' nyiɔpʋ ‑gbɩ ‑ɩa 'blea' nɩa 'kle \"jru, ‑wɛe aoa' ‑cɛ\" 'kpa 'a ‑cɩɛjɔ due' koʋn ‑gbai' 'a blɩ \"i. ");
INSERT INTO wob_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Ɛ nɩɛ \"nmia‑tɩ ‑o 'de aoa' ‑tɩ' 'ʋn, dɛ‑nʋɛ' Kea 'a wlu 'kwajaaʋn ao \"bo ‑wi\" 'dba a, ʋʋpʋ 'a ‑gbaɩn' mɩ aoa ma. ");
INSERT INTO wob_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","‑Bo aoa sea ʋʋpʋ 'a ‑gbaɩn' ma a, ‑mɛ dɩ ao \"bo ‑wi\" nʋa ɩmɩ aoa po ‑tɩ' o. Ʋʋpʋ mɔ 'dba Kea 'a wlu 'kwajaaʋn, ‑wɛe aopʋ mɔɔ ma ʋʋa' ‑gbaɩn' ! ");
INSERT INTO wob_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Ɛmɛ ‑tɩ Kea ‑nɩa tɔ'di sie nɔ\" nya sese ɛ 'tmʋɛ ɛ 'na : 'Ma muɛ wlu 'kwajaaʋn ke dboʋn ʋʋpʋ \"idboa', ‑wɛe ʋʋ 'je jrʋ' 'dba 'de ʋʋ 'je jrʋ' 'kle ‑tu\". ");
INSERT INTO wob_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Kea 'a wlu 'kwajaaʋn ʋʋ 'dba ʋʋa' nymɔ ɔ muɛ nyʋ ‑nɩa ‑sɩanwɩ 'di kpʋn 'a. ");
INSERT INTO wob_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Dɛ ‑wlʋa 'e 'kmʋ 'a ‑teea' a, ‑wɛe ‑ɛ tba 'e Abɛlɩ 'a 'mɛa' \"kpei 'de ‑ɛ ‑jɛɛa Sakali ʋʋ 'dba 'bo 'sraa‑sa'ɩn 'de Kea ‑gbu klaa\" 'di tɛin\" ɛ, 'ma 'tmʋʋ aopʋ tɔ' ‑tɩ, Kea a muɛ ʋʋa' nmɔ nyʋ ‑nɩa ‑sɩanwɩ 'di i ‑teea'. ");
INSERT INTO wob_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","Ɛ nɩɛ \"nmia ‑tɩ ‑o 'de aoa' ‑tɩ' 'ʋn kɛ' wɔ‑saʋn, dɛ‑nʋɛ' ‑ta tɔ' ‑tɩ nɩa ao juo 'o 'ɛ, 'kaa aoa' ‑cɛ\" 'kpa 'a mu 'o. Ao ‑kɔ' nyʋ ‑blea ‑gbu\" 'a 'nynɩ 'de ‑ʋʋa ‑cɛ\" 'kpa 'a pa 'e ɛ 'di, 'de ‑ʋʋa kaan nyʋ ‑nɩai\" ‑ʋʋ ‑jea 'de ɛ 'di pa ‑je de ɛ. ");
INSERT INTO wob_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","‑Ta Sesi 'wlʋʋa 'mʋa‑ 'sʋ ɛ, Fariseɛn ke kɛ' wɔ‑saʋn 'kpa 'cɛn 'sʋ ʋʋ ‑te ɔɔ' \"kpei‑ crɛɛa' ‑pʋn\". Ʋʋa ‑tee' ɔ 'wɔn i, ‑wɛe dɩ ‑tuu\"‑tuu 'je 'de ɔ wɔn 'di ji. ");
INSERT INTO wob_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Ʋʋa ‑teɛ' Sesi \"klɛ bʋ 'dei ‑wɛe ‑bo ɛ nɩ kan' a, 'de ʋʋ 'je ɔ \"kpei kpʋʋn‑. ");
INSERT INTO wob_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","'De ɛɛ' nɔ\" tu 'di ɛ, nyiɔ ‑pʋ 'a \"wlu 'a \"wlu ‑kweade a na ba \"kpei‑. 'Sʋ Sesi ‑teɛ ɔɔ' klai\" nynuu ‑pee wlua' ‑pʋn\" ke kpɩɩn‑ ɔ 'na : Ao ‑tu\" aoa' ‑cɛ\" 'ɛ ‑tɩ' 'de Fariseɛn‑wi\" 'a ‑di'pɛn ‑puun\" dɛ 'ɛ ‑tɩ' 'ʋn, ɛmɛ ‑nɩ \"jridepooa'. ");
INSERT INTO wob_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Dɛ ‑pa' 'kwla ‑wɛe ‑ɛ sea \"kpae' 'pɛɛn, ɛ se nɩ‑. 'De dɛ ‑tua\" 'kwla ‑wɛe nyʋ sea juoi ɛ, ɛ se nɩ‑. ");
INSERT INTO wob_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Ɛmɛ ‑tɩ ‑wɛe dɩ \"klein aoa mua 'tmʋa' 'de kwie 'ʋn ɛ, ɩ ‑wee' a muɛ \"kpae' 'pɛɛan' 'de ‑sɔn' 'ʋn. Dɛ ao \"wuan 'ʋn 'de ba ‑pee ‑wɛe ao 'tmʋa 'de aoa' 'pɛn 'ɩn ɛ, nyʋ a mu ɩ wee 'ʋn poa' 'bo nyʋ ‑kwea. ");
INSERT INTO wob_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","Ao ‑nɩa 'ma \"dɛi‑wi\" ɛ, 'ma 'tmʋʋ aopʋ 'mɛ : ao 'bo nyʋ ‑a ‑dba 'blʋku pleeɛ, ʋʋ se ɛ 'bɛɛ‑ ʋʋ 'je dɛ jrɛ' nʋ 'bo ‑mɛ 'de. ");
INSERT INTO wob_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","\"Ju ao 'jea plee ɛ, ɔmɔ 'ma ji aopʋ tɔɔa'. Kea ‑bo ‑ɛ ‑sa nyʋ 'kmʋ, ‑wɛe ‑ɛ ‑beea' ‑ɛ ‑je ɔ 'de nɛ ‑sea' 'mʋ‑ta 'ble 'ʋn po ɛ, ɛmɛ ao 'je plee‑. Kɩɩn, tɔ' ‑o, ɛmɛ ao 'je plee‑. ");
INSERT INTO wob_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Aoa 'jee, ‑tɩɩn\" jɔ‑ ‑mm\" mɩ nyʋ a sea 'wɛijɔ 'sɔɔn 'ʋn plee ? 'De ‑mɛ 'kamɔ ɩa' due' koʋn ‑gbai' se \"ma 'bo Kea \"juɔi. ");
INSERT INTO wob_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","aoa' \"mɩɩ‑ ‑nɩa 'bo aopʋ mɔɔ' ‑cɛ\" \"jru ‑mɩ ‑wee' \"klein ‑srooɛ', ɛmɛ ‑tɩ faʋn 'bo ao nʋɛ, ao nɩɛ dɛwɔn, ao je \"jae ‑tuu\"‑tuu ‑sii. ");
INSERT INTO wob_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","'Ma 'tmʋʋ aopʋ 'mɛ, nyɔ \"o nyɔ ‑wlua 'o nyʋ \"juɔi ‑wɛe ‑ɔ ‑na ɔ nɩɛ 'ma nyɔ ‑o ɛ, 'mɔ nyiɔ 'ɔ \"Ju, 'ma muɛ ɔɔ' 'nynɩ \"sia' 'de 'ɩn \"Bo 'a \"soa‑wi\" \"juɔi ‑ke. ");
INSERT INTO wob_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","'Kaa nyɔ ‑ɔ ‑sa 'ʋn wɔn 'bo nyʋ \"juɔi ɛ, 'ma muɔ wɔn ‑saa' ‑ke 'bo 'ɩn 'Bo 'a \"soa‑wi\" \"juɔi. ");
INSERT INTO wob_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","'De nyɔ ‑toa 'mɔ nyiɔ 'ɔ \"Ju wɔn o ɛ, ɔɔ' dɛsaʋn 'bɛɛ‑ ɛ 'je ‑kwɛ‑, 'kaa nyɔ ‑ɔɔ mua Kea 'a ‑Suu wɔn iblaa' a, ɔɔ' dɛsaʋn se ‑kwɛi. ");
INSERT INTO wob_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","‑Bo nyʋ kpa aopʋ 'pee 'ʋn 'de Kea ‑gbi 'dii ɛ, ɛ ke 'de 'blʋajeʋn‑wi\" ke ‑gbajeʋn ‑wi\" \"juɔi ɛ, ao 'bo ‑flii 'wlaa 'de dɛ ao 'jea 'tmʋ ‑wɛe ao 'jea aoa' ‑cɛ\" ‑tɩ' \"kpei ‑sa 'a ‑tɩ' 'ʋn, ");
INSERT INTO wob_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","dɛ‑nʋɛ' dɛ ao 'jea 'tmʋ 'de nɔ\" ‑nɩa 'mʋa‑ 'di ɛ, Kea 'a ‑Suu 'a ‑cɛ\" 'kpa ‑a muɛ ɛ aopʋ tɔɔa'. ");
INSERT INTO wob_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","\"Ju due' ‑wlʋ 'e nyʋ \"klu ‑ɔ ‑wlu Sesi ‑pee ‑ɔ ‑na : Nyʋ dɛtɔɔi, ‑tmʋʋ' 'ma de'di ‑nɔ, ‑wɛe ɔ ke 'ma ‑a ‑je ‑aa 'kɛn 'ʋn ‑seea' ‑a. ");
INSERT INTO wob_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","'Sʋ Sesi wlu ɔ ‑pee ɔ 'na : 'Oo nyiɔ‑ ! ‑Ɔ ‑te 'ʋn 'bomu ‑wɛe 'ɩn 'je aoa' 'pee 'je 'de 'ɩn 'je aoa' 'kɛn 'ʋn ‑seea' ‑a ? ");
INSERT INTO wob_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","'Sʋ ɔ wlu' 'de ʋʋ ‑wee' \"klein ‑pee ɔ 'na : Ao ‑tu\" aoa' ‑cɛ\" 'ɛ ‑tɩ' 'mɔ, 'kwa i 'nɩɩa' se \"jrii nmɔ‑, dɛ‑nʋɛ' ‑bo nyiɔ nɩ \"wliiɛjei mɔ 'de ɛ, ɔɔ' 'kmʋnɩa' ‑cɛɛn'‑ se 'e \"wliiɛ‑ ‑tuu\"‑tuu 'blea' 'ʋn nɩ‑. ");
INSERT INTO wob_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","'Bomɔ Sesi poo ‑tɩ' ‑nɩ \"i ka 'de ʋʋ ‑pee ɔ 'na : \"Wliiɛjei due' mɔ ‑ɔ nʋ 'blʋ 'ʋn dbo‑ ‑ɛ \"nyɩ ɔ diidɩ ‑tuu\"‑. ");
INSERT INTO wob_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Ɔ naa tɔ' i 'de ɔɔ' ‑cɛ\" 'ʋn 'sʋ, ɔ 'na : Ka 'ɩn 'je diidɩ ‑nɩ ‑mɩ 'a ‑tɩ' nʋ la‑ ? ‑Ta 'ɩn 'jɩ ‑tu\" 'bo se nɩ‑. ");
INSERT INTO wob_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","'Sʋ ɔ 'na : Ka 'ɩn 'jea nʋ 'ka ka : 'ma jiɛ 'ma ‑gbi\" mɩɩ\" ‑nɩ 'wlaa', ‑wɛe 'ɩn 'je ‑gbi\" klae\" po 'de 'ɩn 'je 'ma diidɩ ke 'ma 'bleedɩ ‑wee' \"klein \"jrui 'kɩɩn‑ 'de ɩ 'di, ");
INSERT INTO wob_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","‑wɛe 'ɩn 'je wlu ka 'de 'ma ‑cɛ\" 'ʋn : ‑mɔ ɛ, ‑ɩn ‑bleɛ \"wliiɛ‑ ‑tuu\"‑tuu, ‑ɩn ‑bleɛ ‑sɩn ‑tuu\"‑tuu 'a diidɩ. ‑Ɩn ‑te i la, ‑ɩn ‑je di, ‑ɩn ‑je 'na, 'de ‑ɩn ‑je 'mʋa‑ nʋ, dɛ‑nʋɛ' ‑tɩ' se ka nɩ‑. ");
INSERT INTO wob_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","'Kaa Kea a muɛ ɔ ‑pee wlua' ka : ‑mɔ ‑kaan\" nyɔ‑, ‑gbʋn 'nɔ, 'De \"maʋ'wɩ ‑nɛ 'di ‑sɩan, 'ma muɛ ‑ma feeɛ' 'de ‑ʋn 'ʋn ‑saa', ‑wɛe dɩ \"klein ‑ɩn ‑nmaea nyɔ ‑jɩ kpa ‑ɩn ‑je ɔ 'je. ");
INSERT INTO wob_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","'Kamɔ ɛɛ mu nɩa' 'de nyɔ ‑pɔan' \"wliiɛ‑ i 'de ɔɔ' ‑cɛ\" 'ɛ 'sʋ 'a ‑tɩ' 'ʋn ‑wɛe ‑ɔɔ' ‑pɔn' ɛ i 'de Kea 'a ‑tɩ' 'ʋn ‑pee. ");
INSERT INTO wob_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Sesi wlu' ke ‑nɛ 'de ɔɔ' klai\" nynuu ‑pee ɔ 'na : 'Ma 'tmʋʋ aopʋ' 'mɛ ao 'bo aoa' 'kmʋ 'a ‑sɔɔn ‑tu\" ɛ, 'de dɛ ao 'jea di ke dɛ ao 'jea 'ʋnpaa 'a ‑tɩ' 'ʋn, ");
INSERT INTO wob_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","dɛ‑nʋɛ' 'kmʋnɩa' \"paa' ɛ je diidɛ ‑sii, 'de ku 'a kɛ' kma' ɛ je 'ʋnpaadɛ ‑sii. ");
INSERT INTO wob_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Ao ‑gbʋn wan\" ‑wi\" ‑nɩ ja kea' : ɩa' nʋ dbo, ɩa' ‑tu\", ɩa' ‑sa, ɩ se ‑gbu\" 'ble, ‑wɛe diidɛ \"jɛi ‑tu\" ‑tɩ. 'Kaa Kea a ‑gbaan' ɩ'. 'De aomɔ se dɛwɔn nɩ kpɛ ‑puue, ao se nʋʋɩ ‑sii ? ");
INSERT INTO wob_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Nyɔ wɛ‑ ‑nɩ 'e aopʋ \"klu ‑wɛe 'de ‑ɔɔ feeɛ' iwlaa' 'ʋn ‑ɔ ‑beeɛ' ‑ɔ ‑je ɔɔ' 'wɩ ‑pɛ 'mlai\" po ɛ‑ ? ");
INSERT INTO wob_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","'De ‑bo ao se dɩ mɩɩ\" ‑jɩ ‑mɩ 'a nʋa' 'bɛɛ‑ 'ee, ‑mɛ dɛɛ‑tɩ aoa ‑tu\" ‑sɔɔn 'de dɩ ‑jɩ ‑sia 'o 'a ‑tɩ' 'ʋn 'ja a‑ ? ");
INSERT INTO wob_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Ao ‑gbʋn sii\" 'a ‑fan' sʋn ja 'de 'kwla 'di : ɩa' nʋ dbo, ɩa' dba dɩ, 'kaa 'ma 'tmʋʋ aopʋ 'mɛ 'de Salomɔ 'ɔ 'beɔdɛ ‑wee' \"klein 'ʋn ɛ, ɔ se ‑pɛe ‑pʋn\" ‑tu\", ɔ se ɩa' due' koʋn ‑gbai' ka ‑sii. ");
INSERT INTO wob_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Sii\" ‑nɩa 'e 'kwla 'di ‑sɩan, ‑klae\" 'sʋ ‑ɩ ‑mɛa ‑wɛe nyʋ a poa 'o \"jri ɛ, ‑bo Kea a sea ‑mɩ dɩ 'ʋnpaa kan' 'ee, ‑mɛ ɛ se ɛ 'bɛɛ‑ ɛ 'je ɛɛ' dɛ tu nʋ 'de aoa' ‑tɩ' 'ʋn ‑kee ? ‑Gbʋn, ka aoa' Kea ‑kwlɩ\" ‑tea' sea \"i 'bɛ ɛ ! ");
INSERT INTO wob_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Ao 'bo dɛ ao 'jea di ke dɛ ao 'jea 'na 'a ‑fli i'wlaa jeejee ! ");
INSERT INTO wob_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","'Kmʋ \"kpei nyʋ, ʋʋpʋ ‑a ‑wla dɩ ‑nɩa 'mʋa 'a ‑fli i jeejee, 'kaa aopʋ mɔ ao 'bleɛ \"Bo ‑ɔ ‑juo dɩ \"klein aoa ‑pɔan i ɛ. ");
INSERT INTO wob_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","'Bo ‑mɛ 'de ɛ Kea 'a 'beɔdɛ mɛ ‑ɛɛ ‑fli ao 'je i 'wla ka‑, ‑wɛe dɩ \"klein ‑sia 'o ‑mɩ 'de, 'de Kea 'je ao ‑mɩ \"nyɩ ‑ke. ");
INSERT INTO wob_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Faʋn 'bo ao nʋɛ, ao Tʋ\"bo 'a 'blae 'a ‑gbʋn' ‑saan\"‑, 'kaa ao \"bo ‑nɩa 'e jaʋn 'di 'wɔɔn‑ 'beɔdɛ 'ɛ aoa' \"nyɩ ‑tɩ 'mɛ. ");
INSERT INTO wob_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Ao ple dɩ ao 'blea ‑wɛe ao 'je ɩa' 'wɛi nyʋ ‑sea' dɛ 'jea' 'bɛɛ‑ \"nyɩ. Ao \"pa 'wɛi 'dipo ‑ke ‑ɩa' dooa, ‑wɛe ao 'je aoa' \"wliiɛ‑ \"jrui 'kɩɩn‑ 'de jaʋn 'di. 'Demɔ \"jrii 'a bʋ se tɛɛn‑, 'demɔ wlɔn ‑ɩa dooa dɩ se nɩ‑. ");
INSERT INTO wob_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Dɛɛ‑tɩ 'ɩn 'da kan' a, ɛmɛ ‑nɩ ‑ta aoa' \"wliiɛ‑ nɩa 'bomɔ aoa' tɔ' ‑wee' \"klein nɩ ‑ke. ");
INSERT INTO wob_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","Ao nmae dɩ, ao bla aoa' wlʋ 'di ‑kli ! Aoa' nɛbi wan jeejee ! ");
INSERT INTO wob_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Ao nɩ ka nyʋ ‑ʋʋa 'blei mua ‑kɔ' ‑sɔn, 'de ‑ʋʋa fu ɔ ‑wɛe ‑bo ɔ ji ɔ bla klu 'de ‑ʋʋ ‑je ɔ \"wɔin kain nɩa. ");
INSERT INTO wob_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Ʋʋa' dbonʋʋn tu ‑ʋʋa mua \"jriɛ‑ \"i ‑tea' 'sʋ ‑ʋʋa 'blei 'jea ji ɛ, ʋʋ nʋ 'mʋa‑ ! 'Ma 'tmʋʋɛ aopʋ tɔ' ‑tɩ, ‑bo ɔ ji ɛ, ɔɔ' ‑cɛ\" 'kpa a muɛ dɩ nmaea' 'de ɔ 'je ʋʋpʋ dɛdi ‑tɩ 'da, ‑wɛe ɔɔ' ‑cɛ\" 'kpa 'je ʋʋpʋ diidɛ \"jrii ‑gble'. ");
INSERT INTO wob_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","‑Bo ɔ ji ‑too' ‑kwea o, ‑bo ɔ ji ‑sɔn' wɔin\" o, ɔɔ' dbonʋʋn ‑a mua \"jriɛ‑ \"i ‑tea' ɔ 'jea jɛɛ, 'mʋa‑ a muɛ ‑wi\" ‑mʋ nʋa' ! ");
INSERT INTO wob_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Ao 'wɔn ɛ 'mii ka ‑cɔɔn' ka ! ‑Bo ‑gbu\" jei juo nɔ\" ‑ɛ 'di \"jrii 'jea ɔ o ‑gbu\" pa 'de ɛ, ‑mɛ ɔ se ɛ 'bɛɛ‑ 'de ɔ 'je ɔɔ' ‑gbu\" \"i \"tai‑, ‑wɛe \"jrii 'je ɛ wa. ");
INSERT INTO wob_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Aopʋ mɔ ‑ke ɛ, ao nmae aoa' pɛe, dɛ‑nʋɛ' nɔ\" ‑ɛ 'di ao se ɛ ‑kwlɩ\" ‑tee ɛ, ɛmɛ nyiɔ 'ɔ \"Ju a mu de jia'. ");
INSERT INTO wob_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","'Sʋ Piɛi 'na : Tʋ\"bo, ‑ɩn ‑pooɛ ‑tɩ' ‑nɩ \"i 'de ‑aa 'sʋ 'a ‑tɩ' 'ʋn, ‑aee' 'de nyʋ ‑wee' \"klein 'a ‑tɩ' 'ʋn ‑oo ? ");
INSERT INTO wob_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","'Bomɔ Tʋ\"bo wluu ɔ 'na : Dbonʋi ‑jɔ ‑nɩa tɔ'di 'de ‑ɔɔ' pooa wlu fai\" ɛ, ɔmɔ ‑ɔɔ 'blei 'jeɔ ‑gbu\" kwa ‑te', ‑wɛe ‑ɔ ‑je dbonʋʋn jrʋ' diidɛ \"nyɩ 'de nɔ\" i. ");
INSERT INTO wob_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Dbonʋi ‑ɔɔ mua kan' nʋa' sia' 'sʋ ‑ɔɔ 'blei 'je ɔ jɛɛ ɛ, ‑mɔ 'ɔ jei tu a nʋɛ 'mʋa‑ ! ");
INSERT INTO wob_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","'Ma 'tmʋʋ ao tɔ' ‑tɩ, ɔɔ' 'blei a mu ɔ dɩ ‑wee' \"klein kwa ‑tea'. ");
INSERT INTO wob_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","'Kaa ‑bo ɔɔ' dbonʋi tu naa tɔ' i 'de ɔɔ' ‑cɛ\" 'ʋn ‑wɛe ɔ 'na : 'Ma 'blei 'a jia' se i \"kʋʋan‑ ke, 'de ɔ 'je dbonʋʋn jrʋ' 'a blaa' ‑pʋn\" ‑te, ‑wɛe ɔ 'je dɛ dia' ke nmɔ \"jru poa 'a 'sʋ nʋ ɛ, ");
INSERT INTO wob_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","ɔɔ' dbonʋi tu 'a 'blei a muɛ jia' 'de nɔ\" ɔ sea ‑kwlɩ\" ‑te 'di, ‑wɛe ɔ 'je ɔ 'kle ‑tu\" ka nyɔ ɔ ‑tua\" kʋɔnpʋ‑ 'kle ɛ. ");
INSERT INTO wob_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","Dbonʋi ‑jɔ ‑jua ɔɔ' 'blei 'a 'tʋn nʋ‑tɩ, ‑wɛe ‑ɔ sea dɩ nmae‑ 'de ɩa' nɔ\" tu 'di ɛ, nyʋ a mu ɔ klae 'a nya ‑tuu\"‑tuu blaa' ! ");
INSERT INTO wob_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","'Kaa nyɔ ‑jɔ seɛ juo‑, ‑wɛe ‑ɔ nʋa bladɩ ‑cɩɛi\" ɛ, nyʋ se ɔ klae 'a nya ‑tuu\"‑tuu blaai, dɛ‑nʋɛ' nyɔ nyʋ \"nyɩa ‑tuu\" ɛ, ɔmɔ nyʋ 'je ‑tuu\" i ‑tee'‑. 'De nyɔ nyʋ sia dɩ ‑tuu\" o ɛ, ɔmɔ nyʋ a ‑tee' dɩ ‑tuu\" i. ");
INSERT INTO wob_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Sesi wlu' ke'wlɛ ɔ 'naa : 'Ɩn ji' ‑wɛe 'ɩn 'je nɛ 'de 'kmʋ \"kpei po. ‑Bo ɛɛ' nɛ tu ‑te waan' ‑pʋn\" 'ee, ‑mɛ dɛ 'ɩn nɩ \"i 'bo ɛ 'de ɛ‑ ? ");
INSERT INTO wob_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Ka nyɔ pooa \"ni \"jru ɛ, 'kamɔ 'ɩn 'je 'e 'kle 'ʋn jii‑. ‑Bo ɛɛ' dɛ tu se nʋʋ ɛ, ‑mɛ 'ma pɛe se i ‑tei. ");
INSERT INTO wob_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Aomɔ 'na : pɛe 'a blua' mɛ 'ɩn ja 'nɔ 'blʋa‑ \"kpeii ? \"Ɩɩn‑, ɛ se kan' nɩ‑, i ‑seea' mɛ 'ɩn ja. ");
INSERT INTO wob_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","'Bode ɛ, nyʋ ‑mm\" ‑nɩa 'e ‑gbu\" due' 'di a muɛ i ‑seea', taan a muɛ 'sɔɔn 'dii 'blea', ‑wɛe 'sɔɔn 'je taan 'dii 'blee‑. ");
INSERT INTO wob_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","\"Bo a muɛ \"ju 'dii 'blea', \"ju a muɛ \"bo 'dii 'blea', de a muɛ ʋa' 'nynɔkpao' ju 'dii 'blea', ‑wɛe 'nynɔkpao' ju 'je ʋ de 'dii 'blee‑, kʋande a muɛ \"ju 'a 'nynɔ 'ʋn 'nyɛa', ‑wɛe \"ju 'a 'nynɔ 'je kʋande 'ʋn 'nyɛ. ");
INSERT INTO wob_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","‑Wɛe Sesi wlu 'e nyʋ ‑gbaea' ‑pee ɔ 'na : ‑Bo ao ‑gbʋn 'de jaʋn 'di ‑wɛe \"ni a sea i ji 'de \"jɛi 'de 'jrʋ ‑sɔn i fɔo 'sʋ ao 'na : \"Ni a jiɛ dbaa' ‑wɛe ɛɛ nɩ kan' ‑cɛɛn'‑. ");
INSERT INTO wob_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","'De ‑bo 'kao poɔ' sea 'e 'jrʋ ‑gbɩn \"kpei 'wlʋ ɛɛ sea ji ɛ 'sʋ ao 'na mɔɔ' ɔ jiɛ jia' ‑wɛe ɛɛ nɩ kan' ‑cɛɛn'‑. ");
INSERT INTO wob_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Ao \"jridepooʋn, ao juo 'blʋa‑ ke jaʋn 'a nɩsʋn 'a \"kpei‑ ‑seea' ka 'mɛ, 'de ‑mɛ dɛɛ‑tɩ nɔ\" ao nɩa 'e 'di ‑sɩan aoa' 'wɔn 'e ‑mɛ 'dei ‑ɛ ? ");
INSERT INTO wob_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","'De dɛɛ‑tɩ aoa' ‑cɛ\" 'kpa se \"isrɛdɩ 'a \"kpei‑ ‑seea' ka juo ɛ‑ ? ");
INSERT INTO wob_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","‑Bo ‑ɩn ‑ke nyɔ 'ble 'tmʋa' ‑wɛe ɔ 'je ‑ʋn \"kuan poo 'de ao 'je 'pee 'ʋn mua' nɩ ɛ, ‑mɛ ɔ ke ‑ɩn ‑seea' wlu \"kpei 'bo ‑jei\" ka ɛɛ' ‑kɔ sea 'ʋn tɛn ke ɛ, ‑bo ɛ se ‑mɛ nɩɛ, ‑mɛ 'pee a muɛ ‑ʋn ‑kpʋn 'a ‑wɛe 'pee 'jei 'je ‑ʋn \"soa‑wi\" kwa 'bɔɔ‑ 'de ‑wi\" ‑mʋ 'je ‑ʋn ‑kaso 'di po. ");
INSERT INTO wob_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","'Ma 'tmʋʋ ‑ʋn ‑ɛ, ‑ɩn se 'e ‑kaso ‑nɛ 'di 'wlʋi mamaʋ 'sʋ ‑ɩn ‑je ɔɔ' kpan ‑wee' \"klein ‑sa. Ɛɛ' 'jɔ due' se 'de siei. ");
INSERT INTO wob_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","'De ɛɛ' nɔ\" tu 'di ɛ, dɩ Pilatɩ nʋa Galile kɔʋn \"jrii ka ɔ beea ʋʋa' nymɔ ke ʋʋa' 'sraa dɩ 'a nymɔ \"jrii ɛ ɩmɩ ‑ɩa \"kuan nyʋ ‑jea ɩa' ‑ta po Sesi. ");
INSERT INTO wob_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","'Sʋ Sesi wlu' ka 'de ʋʋ ‑pee ɔ 'na : Nyʋ ‑wlʋa Galile ‑wɛe Pilatɩ 'dba 'mʋa‑ 'ee, dɛ aoa naa tɔ' i 'de Galile nyʋ ‑nʋ 'a ‑tɩ' 'ʋn ɛ‑ ? Dɛ ʋʋ 'jea 'kle kan', ‑mɛ ʋʋ nʋɛ' dɛsaʋnʋʋn klae\" la ʋʋ je Galilenyʋ ‑wee' ‑sii ? ");
INSERT INTO wob_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","\"Ɩɩn‑, ɛ se kan' nɩ‑, 'kaa 'ma 'tmʋʋ aopʋ 'mɛ, ‑bo ao se kplɩn fai\" poo ɛ, ka ʋʋ 'mɛa 'mʋa 'kamɔ aoa mu 'mɛa' ‑ke. ");
INSERT INTO wob_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","'De nyʋ 'a ‑puue 'jɔ ‑mɛ\" na Siloe 'a blo' ‑tɔɔn' ‑tɔɔn bla, ‑wɛe ‑ʋʋ ‑mɛa, dɛ aoa naa tɔ' i 'de ʋʋa' ‑tɩ' 'ʋn ɛ‑ ? Aomɔ 'naa ‑mɛ ʋʋ nɩɛ dɛsaʋnʋʋn ‑o la, ʋʋ je Selisalɛm‑nyʋ ‑wee' \"klein ‑sii ɛmɛ ‑tɩ ʋʋ 'mɛɛ ? ");
INSERT INTO wob_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","\"Ɩɩn‑, 'ma 'tmʋʋ aopʋ 'mɛ, ‑bo ao se aoa' kplɩn fai\" poo ɛ, ao ‑wee' a muɛ 'mɛa' ka ʋʋ 'mɛa ‑ke ɛ. ");
INSERT INTO wob_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Sesi pooɛ ‑tɩ' \"i ke'wlɛ ɔ 'na : \"Ju due' mɔ ‑do fikɩtu 'bo ɔ o ‑kle'. 'Wɩ jrɛ' o 'sʋ ɔ muɛ ɛɛ' \"buo du' ‑saa', 'kaa ɔ se ɛ \"buo ja jɛɛ‑. ");
INSERT INTO wob_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","'Sʋ ɔ 'tmʋʋɛ ɔɔ' dbonʋi ɔ 'na : ‑Sɩn taan ka ‑sɩan, ‑bo 'ɩn ji fikɩtu ‑nɛ 'ɛ \"buo ‑saa' a, 'maa 'jeeɛ dɛ ja. ‑Ɩn ‑cɩɛn', dɛɛ‑tɩ ɛ kaan 'blʋa‑ 'ʋn \"jɛi‑ ɛ‑ ? ");
INSERT INTO wob_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","'Bomɔ ɔɔ' dbonʋi 'na : 'Ma 'blei, ‑ɩn ‑tai\" ɛ \"i ke 'de ‑sʋn ‑nɛ 'di, 'ma muɛ ɛ wɔi \"blua', ‑wɛe 'ɩn 'je ɛ 'blʋ ‑jre 'dɔe wɔi po. ");
INSERT INTO wob_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","\"Ko 'de nya ɛɛ muɛ croa' a‑. ‑Bo ɛ se cro ɛ, ‑wɛe ‑ɩn ‑je ɛ cɛn. ");
INSERT INTO wob_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","'Wɩ jrɛ' ‑ɛ ‑nɩa ‑kwlewɩ ɛ, ɛmɛ Sesi a tɔɔ nyʋ dɛ 'de Kea ‑gbu 'di. ");
INSERT INTO wob_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","'Sʋ 'nynɔkpao' due' ‑nɩ 'e nyʋ \"klu. 'De ‑sɩn 'a ‑puue 'jɔ ‑mɛ\" na 'di ɛ, ʋa' ‑srɛi\", ʋa' na‑, dɛ‑nʋɛ' ‑suusaʋn ‑nɩa 'de ʋ 'ʋn ɛ, ɛmɛ ‑ɛ ‑tu\" nɩɩa 'wɛ‑ ‑nɛ ‑pʋn\". ");
INSERT INTO wob_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Sesi 'jeea ʋ \"jriɛ‑ 'sʋ ɛ, ɔ wlu' ka 'de ʋ ‑pee : 'Nynɔkpao', a 'pʋʋ ‑wɛ‑ 'de aa' nɩɩa 'wɛ‑ ‑nɛ 'kwa. ");
INSERT INTO wob_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","‑Wɛe ɔ ‑te' ʋ kwa \"jru. 'Bo ɛ \"sri, ʋ je \"isrɛ ʋ je Kea 'a 'nynɩ \"i 'bɛɛa' ‑pʋn\" ‑te. ");
INSERT INTO wob_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","'Kaa dɛ Sesi 'bɔɔa nyʋ 'a 'wɛ‑ 'bo ‑kwlewɩ \"kpei 'mʋa‑, ɛ nyaa Kea ‑gbu ‑jeopoi i, ‑wɛe ɔ wlu 'de nyʋ ‑gbaea' ‑pee ɔ 'na : 'Wɩ ‑mɛɛo\"‑ ‑nɩ 'e 'dɔɔ 'di, ɩmɩ nyʋ 'bɛɛ‑ ʋʋ 'je dbo inʋʋ‑. 'De ɩa' 'wɩ tu 'di mɔ ao 'je jii ‑wɛe ɔ 'je aoa' 'wɛ‑ 'bɔɔ‑. Ao 'bo jiɛ ‑kwlewɩ \"kpei ! ");
INSERT INTO wob_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","'Sʋ Tʋ\"bo wlu' 'de ɔ ‑pee ɔ 'na : Ao \"jridepooʋn 'a ti, 'mɔ 'naa : 'bo ‑kwlewɩ \"kpei ‑ta aoa' kain aoa' bli' ke aoa' soofae'‑ due due' ‑wɛe aoa' kpa ɩ \"ni \"nyɩa' 'a ? ");
INSERT INTO wob_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","'De 'nynɔkpao' ‑nʋ, ‑ʋ ‑nɩa Ablaam 'a \"naju ‑wɛe ‑siɔn' san 'de ‑sɩn 'a ‑puue 'jɔ ‑mɛ\" na 'di ɛ, ʋmʋ nyɔ se seie i ‑kwlewɩ \"kpei 'dee‑ ? ");
INSERT INTO wob_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Wlu Sesi 'tmʋa 'mʋa‑, ɛ 'dbaa ɔɔ' tʋnyʋ ‑tɩn' \"i, 'kaa nyʋ ‑gbaea' 'mʋa‑ a nʋ ‑wi\" ‑mʋ 'mɛ 'de dɩ 'dɔe \"klein ɔɔ nʋa 'a ‑tɩ' 'ʋn. ");
INSERT INTO wob_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Sesi pooɛ ‑tɩ' \"i ke'wlɛ ɔ 'na : Dɛ Kea 'a 'beɔdɛ ‑kɔ', 'de dɛ 'ɩn 'jeɛ \"ipoo ɛ‑ ? ");
INSERT INTO wob_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Ɛ ‑kɔ' tu jɔ ‑ɛ ‑piia' \"i, ‑wɛe \"ju due' doa 'de ɔ o ‑kle ɛ. Ɛ mɛa 'sʋ ɛ, ɛ 'kpa klaa\", ‑wɛe nʋʋɩ poo ɛ 'jro ja. ");
INSERT INTO wob_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Sesi wlu' ke'wlɛ ɔ 'na : Dɛ 'ɩn 'je Kea 'a 'beɔdɛ \"ipoo ɛ‑ ? ");
INSERT INTO wob_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Ɛ ke ‑di'pɛn 'pɛn ‑puun\"dɛ ‑kooɔ'‑. ‑Bo 'nynɔkpao' dbaa fai' pʋ 'a 'kɛinkɛ taan, ‑wɛe ʋ po 'e ‑di'pɛn ‑puun\"dɛ ɛ, 'sʋ fai' pʋ 'a 'pɔɔ ‑wee' \"klein ‑puun\"‑. ");
INSERT INTO wob_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","‑Ta Sesi a mua Selisalɛm ɛ, ɔɔ tɔɔ nyʋ Kea 'a ‑tɩ' 'de ‑kwlɛ klae\" ke ‑kwlɛ mɩɩ\" ɔɔ cɛɛan 'dii 'di. ");
INSERT INTO wob_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","'Bomɔ \"ju due' ‑tee' ɔ i ɔ 'na : 'Ma dɛtɔɔi, nyʋ ‑a mua 'pʋʋa' 'ee, ʋʋ se \"i ‑tieii ? 'Sʋ Sesi wlu' 'de ʋʋ ‑pee ɔ 'na : ");
INSERT INTO wob_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","Ao kpʋʋn aoa' ‑cɛ\" i ‑wɛe ao 'je 'o ‑gbɛin\" ‑je ‑saan\"‑ \"i paa‑. 'Ma 'tmʋʋ aopʋ 'mɛ nyʋ ‑tuu\"‑tuu ‑a mu 'bo 'a paa' i ‑pɔan', 'kaa ʋʋ se ɛ 'bɛɛi. ");
INSERT INTO wob_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","‑Bo ‑gbu\" jei sɔn 'ʋn 'de ɔ 'je 'o ‑gbɛin\" kan a, ‑wɛe ao 'je 'e \"kpae' sie‑, 'de ao 'je klu blaa' ‑pʋn\" ‑te ɛ, 'de ao 'je wlu ka : Tʋ\"bo, Tʋ\"bo, ‑ɩn ‑kain ‑a ‑wɔin\" ! Ɔɔ muɛ wlua' ka : ‑Ta ao 'wlʋa 'ɩn se 'o juo‑. ");
INSERT INTO wob_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","'Bomɔ aoa mu wlua ka : ‑Apʋ ‑ɔ ‑ke ‑ɩn ‑dia ‑tadue 'de ‑ɔ ‑ke ‑ɩn ‑naa ‑tadue, ‑wɛe ‑ɔɔ ‑kwlɔ 'dii ‑ɩn ‑tɔɔa nyʋ dɛ, ‑a ko ‑taa ? ");
INSERT INTO wob_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Ɔɔ muɛ wlua' ka 'de ao ‑pee : ‑Ta ao 'wlʋa 'ɩn se 'o juo‑, ao ‑wee' \"klein tɛɛn 'ʋn kɩɩn, ao dɛsaʋnʋʋn ! ");
INSERT INTO wob_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","'Bomɔ ‑bo aoa sea ao \"bo ‑wi\" Ablaam ke Isaakɩ ke Sakɔbʋ ke Kea 'a wlu 'kwajaaʋn ‑wee' \"klein i 'je 'de Kea 'a kɛɛma' ‑kwlɔ 'di ɛ, ‑wɛe aopʋ mɔ 'je 'e \"kpae' nɩ ɛ, 'bomɔ aoa muu ‑fɩn\" 'a 'de ao 'je 'nynɩ \"idii‑. ");
INSERT INTO wob_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Nyʋ a muɛ 'e 'jrʋ kwea ke 'jrʋ ‑sɔɩn 'wlʋa', ‑wɛe jrʋ' 'je 'de 'jrʋ 'a ‑gbɩnfɔ ‑nɩa 'sɔɔn o 'wlʋ 'de ʋʋ 'je ‑tadue dii‑ 'de Kea 'a kɛɛma' ‑kwlɔ 'di. ");
INSERT INTO wob_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Ao ‑gbʋn 'nɔ, nyʋ ‑bɔɔa' de ɛ, ʋʋa' jrʋ' a muɛ nya kɔan' ‑wɛe nyʋ ‑kɔan nya 'a jrʋ' 'je de 'bɔɔ‑. ");
INSERT INTO wob_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","'De 'wɩ due' ‑nɛ 'di 'sʋ Fariseɛn‑wi\" jrʋ' ‑ji' Sesi 'tmʋa' ʋʋ 'na : ‑Ɩn ‑wlʋ' ‑ta, ‑ɩn ‑mu', dɛ‑nʋɛ' Erodɩ a ‑pɔn ‑ma 'dbaa 'a ‑kɔ i. ");
INSERT INTO wob_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Sesi wlu' 'de ʋʋ ‑pee ɔ 'na : Ao mu ao 'je too' wɛ ‑ponyɔ ‑nɔ 'tmʋʋ‑ : 'Ɩn ka, 'ma nʋɛ ‑siisaɩn i, 'de 'ma 'bɔɔ‑ nyʋ 'a 'wɛ‑ ‑sɩan o, ‑klae\" o, 'de 'wɩ 'a taan ‑nɛ 'di, mɔ 'ma mu ɛɛ' dbo tu \"i ‑kɔa'. ");
INSERT INTO wob_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","'Kaa 'ɩn 'je na ‑o ‑sɩan o, ‑klae\" o, 'wɩ ‑tba' 'o ‑ɩ mua nya 'di, dɛ‑nʋɛ' ɛ se \"inmɔ ‑wɛe Kea 'a wlu 'kwajaai 'je 'kwla \"kpei 'mɛɛ, ‑bo ɛ se 'o Selisalɛm nɩ ɛ. ");
INSERT INTO wob_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","'De Sesi wlu ɔ 'na : Selisalɛm, Selisalɛm ‑kwlɔ, ‑mɔ ‑ɔɔ ‑dba Kea 'a wlu 'kwajaaʋn, ‑wɛe ‑ɔɔ tbaa nyʋ Kea dboa ‑ʋn \"i \"soi i ɛ, kpɛ ‑tiiɛ' 'ɩn nɩɛ \"i ‑ɩn 'je ‑ma \"nynuu‑ \"jrui 'kɩɩn‑ ka ‑gbaʋnsʋn\" a 'kɩɩan ɛɛ' \"nynuu‑ \"jrui 'bo ɛɛ' nai ‑sɔn ɛ, 'kaa ao seɛ 'wɔɔn. ");
INSERT INTO wob_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Ao ‑gbʋn 'nɔ, Kea a muɛ aoa' ‑gbu\" klaa\" sʋn \"kpei ‑saa'. 'Ma 'tmʋʋ aopʋ 'mɛ, ao se 'ʋn \"jriɛ‑ 'jeei 'bode mamaʋ 'sʋ ɛ 'je 'wɩ jrɛ' jɛɛ‑ ‑wɛe ao 'je wlu ka : \"Diwan kpʋn \"Ju ‑ɔɔ jia 'de Tʋ\"bo 'a 'nynɩ 'ʋn ɛ ! ");
INSERT INTO wob_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","'Wɩ jrɛ' o 'bo ‑kwlewɩ \"kpei ɛ, Sesi muɛ 'de Fariseɛn‑wi\" 'a klaa\" due' o ‑gbu\" 'di ‑wɛe ʋʋ 'je dɛ di. Nyʋ ‑nɩa 'o mu ɛ, ʋʋa siɛ Sesi \"jriɛ‑ o. ");
INSERT INTO wob_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","'Sʋ \"ju due' ‑pun\" wɛ‑ ɛ nʋa ji', ‑wɛe ɔ nyna i 'bo Sesi \"juɔi. ");
INSERT INTO wob_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","‑Wɛe Sesi wlu 'e kɛ' wɔ‑saʋn klae\" ke Fariseɛn‑wi\" ‑pee ɔ 'na : Nyɔ 'beeɛ' ɔ 'je 'wɛ‑ 'bɔɔ‑ ‑kwlewɩ \"kpei, ‑aee' nyɔ se ɛ 'bɛɛ‑ ? ");
INSERT INTO wob_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","'Kaa ʋʋ se 'e wlu ‑sa. 'Sʋ Sesi kpa sʋn ɔ bla \"ju ‑nɔ \"i, ɔ 'bɔɔ‑ ɔɔ' 'wɛ‑ 'sʋ ɔ 'na : ‑Ɩn mu ‑gbɛin\". ");
INSERT INTO wob_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","‑Wɛe ɔ wlu 'de ʋʋ ‑pee ka ɔ 'na : ‑Bo ɛ nɩ aoa' due' 'a \"ju, 'de ‑bo ɛ nɩ ɔɔ' bli' ‑kpa \"nibie 'di, 'bo ‑kwlewɩ \"kpei 'ee, ɔ se 'o \"sri i ɔ se ɛ 'e ‑sa ii ? ");
INSERT INTO wob_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","'Kaa dɛ ʋʋ 'jea 'tmʋ 'de ɛɛ' wlu tu 'a ‑tɩ' 'ʋn, ɛ se nɩ‑. ");
INSERT INTO wob_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Ka nyʋ ʋʋ 'da dɛdi ‑tɩ ʋʋa ‑pɔan ‑teɩn 'dɔe 'dɔe i ɛ, ɛmɛ Sesi sie \"jriɛ‑ o, 'sʋ ɔ pooɛ ‑tɩ' \"i ka, ɔ 'na : ");
INSERT INTO wob_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","‑Bo nyʋ 'da ‑ʋn dɛdi ‑tɩ 'de ba \"blitii ‑kɔ' ‑sɔn ɛ, ‑ɩn ‑bo i ‑teɛ tɛin\" 'bo ‑teɩn ‑nɩa 'e nya \"kpei. \"Ko nyɔ jrɔ' ‑nɩ dɛwɔn ‑ɔ ‑sii ‑ʋn ‑wɛe ʋʋ 'da dɛdi ‑tɩ 'de ɛ, ");
INSERT INTO wob_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","‑wɛe \"ju ‑ɔ ‑da ‑ʋn dɛdi ‑tɩ ɔ je ji, ɔ je ‑ʋn ‑jɛɛ ɔ je wlu ka 'de ‑ʋn ‑pee : ‑Ɩn sɔn 'ʋn, \"ju ‑nɔ 'je i ‑te. ‑Bo ‑ma sea 'e de jii 'de ‑ɩn ‑je i ‑te ɛ, ɛɛ muɛ ‑ʋn ‑tɩn' \"i 'dbaa. ");
INSERT INTO wob_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","'Kaa ‑bo nyɔ 'da ‑ʋn dɛdi ‑tɩ ɛ, ‑mɛ ‑ɩn kpʋn ‑tein 'de de fɔo. ‑Wɛe ‑bo \"ju ‑ɔ ‑da ‑ʋn dɛdi ‑tɩ ji ɛ, ɔ 'je wlu ka 'de ‑ʋn ‑pee : 'Ɩn ba, ‑ɩn ‑jii 'e nya 'de ‑ɩn ‑je i ‑te. ‑Bo ɛ nɩ kan' ‑mɔ ɛ, ‑mɛ ɛ 'bɛɛ ‑mii\" 'de nyʋ ‑ke ‑ma dia dɛ ‑tadue \"jri 'de, ");
INSERT INTO wob_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","'Kamɔ nyɔ ‑ɔɔ ‑bɛɛa' ɔɔ' ‑cɛi\" ɛ, Kea a mu ɔ ja jaa', 'de nyɔ ‑ɔɔ jaa ɔɔ' ‑cɛ\" ja, Kea a mu ɔ \"jɛi kpaa'. ");
INSERT INTO wob_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","‑Wɛe Sesi wlu ‑ke 'de \"ju ‑ɔ ‑dɔ dɛdi ‑tɩ ‑pee ɔ 'na : ‑Bo ‑ɩn ‑da nyʋ dɛdi ‑tɩ ɛ, ‑mɛ ɛ 'bo ‑ma \"dɛi‑wi\" ke ‑ma 'cɛ‑wi\" ke \"wliiɛjeʋn ‑ʋʋ ‑ke ‑ɩn ‑kʋʋan\" i nɩɛ, 'de ʋʋ je ‑ʋn dɛdi ‑tɩ 'da ‑ke. ");
INSERT INTO wob_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","'Kaa ‑bo ‑ɩn ‑je nyɔ dɛdi ‑tɩ 'da a, ‑mɛ ‑ɩn ‑da nɩɩa\" nyʋ ke nɩɩaʋn ke nyʋ ‑a ‑kpaa' ‑gbɔʋn\" \"kpei o, nyʋ ‑ʋʋa \"jri wa o. ");
INSERT INTO wob_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","‑Bo ɛ nɩ kan' a, ‑mɛ ‑ma muɛ 'e 'mʋa‑ 'ʋn nɩa', dɛ‑nʋɛ' dɛ ‑ɩn nʋa ʋʋpʋ \"jrii ɛ, ʋʋ se ɛɛ' kpan ‑sai se. ‑Sɔntɩ \"isrɛnyʋ a mua \"kunyɩɔ' sɔan' 'bomɔ Kea a mu ‑ʋn 'dɔe \"jrii nʋa'. ");
INSERT INTO wob_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Nyʋ ‑nɩa dɛ dia' 'a due' 'wɔan wlu Sesi 'tmʋa 'sʋ ɛ, ɔ wlu' ka 'de ɔ ‑pee ɔ 'na : Nyɔ ‑ɔɔ mua dɛ dia' 'de Kea 'a kɛɛma' ‑kwlɔ 'di ɛ, ‑mɔ nʋ 'mʋa‑. ");
INSERT INTO wob_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","'Bomɔ Sesi poo ‑tɩ' \"i ka 'de \"ju ‑nɔ ‑pee ɔ 'na : \"Ju due' mɔ ‑tu\" ‑kɔ', ‑wɛe ‑ɔ ‑da nyʋ ‑tuu\"‑tuu dɛdi ‑tɩ. ");
INSERT INTO wob_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Dɛ di nɔ\" nynia, ɔ dboɛ ɔɔ' dbonʋi due' nyʋ ‑nʋ 'daa'. Ɔ 'na : 'Ma 'blei 'na ao ji, dɩ ‑wee' \"klein ‑kwɛ‑ \"i ‑wɛ‑. ");
INSERT INTO wob_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","'Kaa ʋʋ ‑wee' klein\" poɛ wlu ‑tadue ʋʋ ‑teɛ ‑kɩn i ‑pɔan' ‑pʋn\" due 'due. ‑Jɔ ɔ mua 'e o tɛin\" ‑mɔ 'na : 'Ma 'wlʋɛ ‑kle' due' ‑tɩan', ɛɛ' ‑tɩ' kpʋn 'ʋn 'ɛ, ɛmɛ 'ma mu 'mi ipleea', 'ma bae ‑ʋn ‑ɛ, 'ɩn se jia' 'bɛɛ‑. ");
INSERT INTO wob_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","'De jrɔ' 'na : 'Ɩn ‑tɩɛn' kopo bli' ‑puue ɩmɩ 'ma mu ‑tɩɩan' ‑sɩan, 'ma bae ‑ʋn ‑ɛ, 'ɩn se 'o tɛɛn‑. ");
INSERT INTO wob_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","'De jrɔ' 'na : 'Ma 'wlʋɛ 'nynɔ pleea', ɛmɛ ‑tɩ 'ɩn se jia' 'bɛɛ‑. ");
INSERT INTO wob_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","'Bomɔ \"ju ‑nɔ mu 'de ɔɔ' 'blei o de, ‑wɛe wlu \"klein ʋʋ 'tmʋa 'mʋa‑, ɔ po ɩ ‑wee' 'a \"kuan. 'Sʋ ɔɔ' 'blei 'kpa 'cɛn, ɔ 'na : ‑Ɩn mu \"kpae' wei ke ‑kwlɔ 'ɔ ‑jeblʋɩ ‑wee' \"kpei‑ ‑too\"‑, nyɔ \"o nyɔ ‑ma mua 'jea', ‑bo ɔ nɩ nɩɩa\" nyɔ o, ‑bo ɔ klɔɔ o, ‑bo ɔɔ' \"jri wa o, ‑bo ɔɔ sea 'too‑ o, ‑ɩn ‑tmʋʋ' ʋʋpʋ ʋʋ 'je ji. ");
INSERT INTO wob_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Nɔ\" jrɛ' ‑sia 'o mu 'sʋ ɛ, dbonʋi ‑nɔ 'na : 'Ma 'blei, ka ‑ɩn ‑sia\" 'nynɩ 'ɩn nʋ kan' ‑wɛ‑, 'kaa ‑teɩn ‑tuu\" ‑sie 'o mu ke. ");
INSERT INTO wob_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","'Bomɔ \"ju ‑nɔ wluu 'de ɔɔ' dbonʋi ‑pee ɔ 'na : ‑Ɩn kpa ‑jeblʋɩ, ‑ɩn ple ‑kle' wɔin, nyɔ ‑ma mua jeea', ‑ɩn ‑te' ʋʋpʋ ‑klaan\" \"kpei ʋʋ 'je ji 'ma ‑gbu\" 'je \"ji. ");
INSERT INTO wob_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","'Ma 'tmʋʋ aopʋ 'mɛ, nyʋ 'ɩn 'da tɛin\" 'de ɛ, ʋʋa' due' koʋn ‑gbai' ka se 'ma diidɛ wɔn ‑tɩn' i. ");
INSERT INTO wob_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Nyʋ ‑tuu\"‑tuu ke Sesi a naa bɩ' i, 'sʋ ɔ \"biiɛ i 'de ʋʋpʋ o, ‑wɛe ɔ wlu ka 'de ʋʋ ‑pee ɔ 'na : ");
INSERT INTO wob_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","Nyɔ ‑jia' 'de 'ʋn o ‑bo ɔ se 'ma ‑tɩ' kma ɔ se ɔ \"bo ke ɔ de ke ɔɔ' 'nynɔ ke ɔɔ' \"nynuu‑ ke ɔɔ' de'dinmai ke ɔɔ' de'dinynʋkpae' ke ɔɔ' ‑cɛ\" 'ɛ 'kmʋ ‑sii ɛ, ‑mɛ ɔ se 'ma klai\" ju nɩa' 'bɛɛ‑. ");
INSERT INTO wob_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","'De nyɔ ‑bla' 'bo 'ʋn 'de ‑wɛe ‑ɔ sea 'kle 'je ‑tɩ 'wɔɔn‑ ɛ, ‑mɛ ɔ se 'ma klai\" ju nɩa' 'bɛɛ‑. ");
INSERT INTO wob_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","‑Bo aoa' nyɔ due' ‑nɩɛi\" ɔ 'je ‑gbu\" klaa\" po ɛ ɔɔ ‑teɛ i mɔ ke, ‑wɛe ɔ naa ɛɛ' sɔɔn'ɔ ‑tɩ' tɔ' \"kpei‑, \"ko dɛ ɔ 'blea a ɛ 'bɛɛ ɛ 'je ɔɔ' ‑gbu\" 'a dbo \"i ‑kɔ' ɛ. ");
INSERT INTO wob_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","‑Bo ɔ se kan' nʋ ɛ, 'de ɔ 'je ɛɛ' ‑gban ‑te' ‑wɛe ‑gbu\" se \"i ‑kwɛ‑ ɛ, nyʋ \"klein ‑ʋʋa mu ɛ \"jriɛ‑ 'jeea' a, ʋʋa mu ɔ wlaa'. ");
INSERT INTO wob_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","Ʋʋa muɛ wlua' ka ʋʋ 'je nʋ : \"Ju ‑nɔ ‑mɔ ‑tee ‑gbu\" poa' 'mɛ kpɩɩn‑, ‑wɛe ɔ se ɛɛ' \"i ‑kɔa' 'bɛɛ‑. ");
INSERT INTO wob_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","'De ‑bo 'beɔ due' 'je ɔ ‑po ‑beɔ tʋ \"bli kpa a, ɔɔ ‑teɛ i mɔ ke ɔ naa tɔ' i ‑bo ɔ 'bɛɛ‑ ɔ 'je nyʋ 'a ‑kwlʋ due' 'ʋn \"duo‑ ‑wɛe ɔ 'je nyʋ 'a ‑kwlʋ 'sɔɔn tʋ o ‑fɔan' mu ɛ. ");
INSERT INTO wob_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","‑Bo ɔ se ɛ 'bɛɛ‑ 'ja a, ‑mɛ ‑ta \"ju ɔɔ kpa tʋ \"bli tɛɛan o ke ɛ, ɔ 'je nyʋ \"i dbo ‑wɛe ɔ 'je ‑gbɛn' cɛn, ɔ 'je ɔ \"nyɩ. ");
INSERT INTO wob_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Nyɔ \"o nyɔ 'de aopʋ \"klu, ‑bo ɔ se ɔɔ' 'kmʋ kwa ‑sɔn ‑saa a, ‑mɛ ɔ se 'ma klai\" ju nɩa' 'bɛɛ‑. ");
INSERT INTO wob_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","'Tɔn nɩɛ dɛ 'dɔe ‑o, 'kaa ‑bo 'tɔn ‑kwɛ‑ wɔn 'ee, ‑mɛ ka nyʋ 'e nʋ ‑wɛe ɛ 'je wɔn nɩ ke'wlɛ ɛ‑ ? ");
INSERT INTO wob_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Ɛ se nʋʋdbo 'ble, ɛmɛ ‑tɩ nyʋ 'je ɛ i 'wla 'de \"kpae'. Nyɔ ‑blea i 'wɔn doin\" ɛ, ‑mɛ ɔ 'wɔn i. ");
INSERT INTO wob_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","'Wɩ jrɛ' o, 'wɛi‑sanyʋ ‑wee' ke, nyiɔpʋ 'a \"kwli saɩn 'kpa Sesi ‑pʋn\" ‑wɛe ʋʋ 'je ɔɔ' wlu doin\" o po. ");
INSERT INTO wob_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","'Sʋ Fariseɛn‑wi\" ke kɛ' wɔ‑saʋn a \"wuan‑ Sesi i ʋʋ 'na : \"Ju ‑nɔ ‑mɔ ɔ kpʋʋɛn nyʋ saɩn sɩn 'sɔɔn ‑wɛe ɔ ke ʋʋpʋ a dii ‑tadue. ");
INSERT INTO wob_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","'Bomɔ Sesi poo ‑tɩ' \"i ka 'de ʋʋ ‑pee ɔ 'na : ");
INSERT INTO wob_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","‑Bo nyɔ 'ble 'blae 'a kmɛ' 'due 'de aopʋ \"klu, ‑wɛe ɩa' due' 'je \"ma 'ee, ka ɔɔ nʋ ɛ‑ ? Ɔɔ sea ɩa' kwla ‑mɛ\" nyɛ 'jɔ ‑mɛ\" nyɛ ‑nɩ idia' sie, ‑wɛe ɔɔ sea ‑jɛ ‑ma\" i ‑pɔan' mu mamaʋ 'sʋ ɔɔ seɛ 'kwla ‑saa ? ");
INSERT INTO wob_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","‑Wɛe ‑bo ɔ ‑sɛ 'kwla 'sʋ ɔ po ɛ ‑kle 'wɔn ‑gbai\" 'de 'mʋa‑ 'ʋn. ");
INSERT INTO wob_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","‑Bo ɔ ji ‑gbɛin\" la ‑wɛe ɔɔ 'da ɔɔ' \"dɛi ‑wi\" ke nyʋ ‑ke ɔ \"kʋʋan i ke ‑wɛe ɔɔ nʋ aoa' ‑poi'‑ 'ma 'blaa ‑ma\" 'de ɛ, 'ɩn 'je ɛ ‑wɛ‑. ");
INSERT INTO wob_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","'ma 'tmʋʋ aopʋ 'mɛ, 'kamɔ ɛ nɩ‑, ‑bo dɛsaʋn nʋi due' koun ‑gbai' poo kplɩn fai\", ‑wɛe ɔ 'je 'e Kea o \"biie‑ ɛ, ɛ 'bleɛ 'mʋa‑ 'de jaʋn 'di, ɛ je \"isrɛnyʋ 'a kwla ‑mɛ\" nyɛ 'jɔ ‑mɛ\" nyɛ ‑ʋʋ sea kplɩn fai\" poo ‑tɩ ‑pɔn' ‑sii. ");
INSERT INTO wob_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","'De ‑bo 'nynɔkpao' due' 'ble 'wɛijɔ ‑puue, ‑wɛe ɩa' due' \"ma a, ʋa tba nɛbi ‑wɛe ʋ wuuo 'e ‑gbu\" 'dii 'de ʋa ‑pɔn ɛ i 'de ‑kwlɩ' i 'sroa' 'ʋn mamaʋ 'sʋ ʋa 'je ɛ. ");
INSERT INTO wob_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","‑Bo ʋ 'je ɛ, ʋa 'da ʋa' \"dɛi ‑wi\" ke nyʋ ‑ke ʋ \"kʋʋan i 'mɛ, ‑wɛe ʋʋa : Ao \"nya ‑a nʋ 'mʋa‑, dɛ‑nʋɛ' 'ma 'wɛijɔ ‑ma\" a, 'ɩn 'jeeɛ'. ");
INSERT INTO wob_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","'Kamɔ ɛ nɩ 'ma 'tmʋʋ‑ aopʋ 'mɛ, ‑bo dɛsaʋn nʋi due' koun poo kplɩn fai\" 'de ɔ 'je 'e Kea o \"biie‑ ɛ, ɛ nɩɛ 'mʋa‑tɩ ‑o 'bo Kea 'a \"soa‑wi\" \"juɔi. ");
INSERT INTO wob_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Sesi wlu' ke'wlɛ ɔ 'na : \"Ju due' 'bleɛ \"nynuu‑ 'sɔɔn. ");
INSERT INTO wob_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","'Sʋ ‑saan\" ‑nɔ wlu' 'de ɔ \"bo ‑pee ɔ 'na : 'Ɩn \"bo, ‑ɩn ‑nyɩ\" 'ʋn 'ma ‑nɩ \"wliiɛ‑. Ɔ \"bo se 'o wlu tba, 'sʋ ɔ ‑seea' \"wliiɛ‑ 'ʋn 'ɛ 'bo ɔ ke ɔɔ' ‑fɛin' 'nynɩ. ");
INSERT INTO wob_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Ɛ nʋa 'wɩ pla 'sʋ ‑Saan\" ‑nɔ 'tɛn ɔɔ' dɩ ‑wee' \"klein 'mɛ ‑wɛe ɔ mu 'e 'blʋa‑ ‑tɔɔn \"kpei. 'Demɔ ɔ ‑te ɔɔ' \"wliɛ ‑nɩ 'a dooa' ‑pʋn\" 'de ‑kooa\" dɛ nʋa' 'ʋn. ");
INSERT INTO wob_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Ɔ ‑kɔa' ɩ ‑wee' 'a dooa' 'sʋ ɛ, 'mɩɩɛ‑ ‑teɛ jia' ‑pʋn\" 'de 'blʋa‑ ‑nɛ \"kpei 'sʋ ‑tɩ' kpʋn 'ɔ, ‑ta ɔ 'jea dɛ ‑sa, 'bo se nɩ‑. ");
INSERT INTO wob_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","'Sʋ ɔ muɛ dbo i ‑pɔan' 'de \"ju due' 'kwa 'de 'blʋa ‑nɛ 'di, ‑wɛe ‑mɔ 'na : ‑Ɩn mu 'ma be\" 'dei ‑te 'de ‑kle. ");
INSERT INTO wob_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","‑Ta ɔɔ ‑teea' be\" 'dei ɛ, ɔ ‑nɩɛi\" 'mɛ ɔ 'je be\" 'a diidɩ di 'de‑, 'kaa nyɔ ‑ɔ ‑jɩ ɔ \"nyɩ ɔ se nɩ‑. ");
INSERT INTO wob_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","'Sʋ dɛ ɔ nɩa 'ʋn 'mʋa‑, ɔ ‑teɛ ɛɛ' tɔ' \"kpei‑ naa' ‑pʋn\" ɔ 'na : Diidɩ siiɛ 'ɩn \"bo 'a dbonʋʋn ‑wee' \"klein i, ‑wɛe 'mɔ nɩ 'nɔ, 'de 'mɩɩɛ‑ ɛ 'dba 'ʋn. ");
INSERT INTO wob_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","'Ma jiɛ 'ʋn sɔan' 'ɩn 'je 'ʋn \"bo o de mu, ‑wɛe 'ɩn 'je wlu ka 'de ɔ ‑pee : 'Ɩn \"bo, 'ɩn nʋɛ ‑ʋn ‑ke Kea dɛsaʋn \"jrii. ");
INSERT INTO wob_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","‑Ɩn ‑bo 'ʋn \"jujriɛ ja ‑gbʋɛn 'bode. Ka ‑ma nʋa ‑ma dbonʋʋn ɛ, 'kamɔ ‑ɩn ‑je 'ʋn nʋ. ");
INSERT INTO wob_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Ɔ sɔn 'ʋn 'sʋ ɔ muɛ ɔ \"bo o de. ‑Ta ɔ tɛɛan o ka kpɩɩn‑ 'sʋ ɛ, ɔ \"bo 'je ɔ i, wɛe a nʋɔ'. 'Sʋ ɔ 'jɔɔ \"i, ɔ bluu ɔ \"kpei ‑wɛe ɔ ‑gblee ɔ ‑kwlɩ\". ");
INSERT INTO wob_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","'Bo ‑ɔ wluu ɔ \"bo ‑pee ɔ 'na : 'Ɩn \"bo, 'ɩn nʋɛ ‑ʋn ‑ke Kea dɛsaʋn \"jrii. ‑Ɩn ‑bo 'ʋn \"jujriɛ ja ‑gbʋɛn 'bode. ");
INSERT INTO wob_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","'Kaa ɔ \"bo wluɛ ɔɔ' dbonʋʋn ‑pee ɔ 'na : Ao ‑too\"‑, ao ja \"bai 'dɔe, ao 'je ɔ 'ʋnpaa‑. Ao po ɔ dɛ ‑cɩɛ, ‑wɛe ao 'je ɔ \"kwlai‑ bɩ' ‑tu\". ");
INSERT INTO wob_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Ao ja 'ʋnwaabli' ao 'je ɛ 'dba 'de ‑a ‑je ɔ ‑kɔ' \"i ‑tuu\"‑, ‑a ‑je 'mʋa nʋ ");
INSERT INTO wob_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","dɛ‑nʋɛ' 'ma \"ju ‑nɔ ‑mɔ ka nyɔ ɔ 'mɛa, ‑wɛe ɔɔ jia 'kmʋ de ɛ, 'kamɔ ɔ nɩ‑. Ɔ \"maa' ‑wɛe 'ɩn 'je ɔ. 'Sʋ ʋʋ ‑teɛ 'mʋa‑ nʋa' ‑pʋn\". ");
INSERT INTO wob_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","‑Ta ɛɛ nʋʋa kan' a ‑mɛ \"ju ‑nɔ 'ɔ nyakɔnju nɩɛ 'e ‑kle. Ɔɔ jiia ‑kwlɔ de, ‑wɛe ɔɔ \"kʋʋan‑ ‑gbu\" i 'sʋ ɔɔ 'wɔn ble ‑cruɛn\" ke dee ‑cruɛn\" ke‑. ");
INSERT INTO wob_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","'Sʋ ɔ 'da dbonʋʋn 'a due', ‑wɛe ɔ ‑tee' ɔ dɛ ‑ɛɛ nʋʋa' 'a ‑pʋn\" ‑tɩ i. ");
INSERT INTO wob_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Dbonʋi ‑nɔ 'na : ‑Ma \"dei ‑ji' de, ‑wɛe ‑ɩn \"bo 'dba 'ʋnwaabli', dɛ‑nʋɛ' ɔ 'jeɔ' 'de kui‑sɔn iflɔan' 'ʋn. ");
INSERT INTO wob_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","'Sʋ \"i‑saaju ‑nɔ 'kpa 'cɛn, ɔ 'na ɔ se 'e ‑gbu\" pai. Ɔ \"bo \"siɛ \"kpae', ‑wɛe ɔ bae ɔ i 'de ɔ 'je ‑gbu\" pa. ");
INSERT INTO wob_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","'Kaa ɔ wlu' 'de ɔ \"bo ‑pee ɔ 'na : ‑Ɩn ‑gbʋn 'nɔ, 'ɩn nʋʋɛ ‑ʋn \"juɔi ‑sɩan 'de ‑sɩn ‑tuu\"‑tuu 'di, 'ɩn se ‑ma wlu wɔin blaa due', 'kaa ‑ɩn se 'ʋn ‑gbaa' ju \"nyɩ kpɛ due', 'ɩn ke 'ma \"dɛi‑wi\" se ba 'mʋa‑ inʋʋ‑. ");
INSERT INTO wob_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","'Kaa ‑jɛ ‑ma \"ju jia, ‑jɔ ‑dua\" ‑ma \"wlii‑ 'ʋn, ‑ɔ ‑jɩɩ' \"jɛi ‑wi\" ɛ, 'de ‑mɔ 'ɔ ‑tɩ' 'ʋn mɔ ‑ɩn ‑dba 'ʋnwaabli' ");
INSERT INTO wob_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","'Bomɔ ɔ \"bo wluu ka 'de ɔ ‑pee ɔ 'na : 'Ma \"ju, ‑mɔ e 'mɔ e‑, ‑a ‑teɛ i jeejee. Dɩ \"klein 'ɩn 'blea, ɩ nɩɛ ‑ma dɩ ‑o ‑ke. ");
INSERT INTO wob_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","'Kaa ‑a ‑je 'mʋa‑kɔ ‑tu\" ‑o, dɛ‑nʋɛ' ‑ma \"dei 'mɛɛ 'de‑, ‑wɛe ɔ ji 'kmʋ de. Ɔ \"maa 'de‑, ‑wɛe ɔ 'wlʋ 'kwla. ");
INSERT INTO wob_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Sesi pooɛ ‑tɩ' \"i 'de klai\" nynuu ‑pee ke'wlɛ ɔ 'na : \"Wliiɛjei due' mɔ ‑ble dɛ i ‑tei', 'sʋ ka ɔɔ' dɛ i ‑tei' ‑nɔɔ' dooa ɔɔ' \"wliɛ ɛ ʋʋ jɔ ɛɛ' \"kʋan. ");
INSERT INTO wob_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","'Sʋ ɔ 'dɔɔ ‑wɛe ɔ ‑tee' ɔ i ɔ 'na : Dɛ 'ma 'wɔn 'de ‑ma ‑tɩ' 'ʋn kan' ke ɛ‑ ? ‑Ɩn ji, ‑ɩn ‑je 'ma dɩ 'ɩn ‑tea' ‑ʋn kwa 'a \"kuan po, dɛ‑nʋɛ' 'ɩn se ‑ʋn 'ma dɩ kwa ‑tei 'bode. ");
INSERT INTO wob_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","'Bomɔ \"ju ‑nɔ naa tɔ' i 'de ɔɔ' ‑cɛ\" 'ʋn ɔ 'na : 'Ma 'blei se 'mi \"inɩ 'bode, dɛ 'ɩn 'je nʋ ɛ‑ ? 'Ɩn 'je dbo nʋ 'de 'blʋ 'ʋʋn ? \"Ɩɩn‑, 'ɩn se ‑mɛ 'ɛ 'kpɩ 'ble. 'Ɩn 'je nyʋ o ‑srɔɔ ? \"Ɩɩn‑, ‑mɛ 'bleɛ 'ma ‑tɩn'. ");
INSERT INTO wob_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","‑Ɩɩn', dɛ 'ɩn 'jea nʋ ‑wɛe ‑bo 'ma 'blei po 'ʋn ‑jei\" 'de nyʋ 'jea 'ʋn sɩn 'sɔɔn kpʋʋn ʋʋpʋ o ‑gbi\" 'dii ɛ, 'ɩn juuɛ' ‑wɛ‑. ");
INSERT INTO wob_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","'Sʋ nyʋ \"klein ‑ʋʋ ‑blea ɔɔ' 'blei 'a kpan ɔ 'da ʋʋpʋ 'mɛ due 'due, ‑wɛe ɔ wlu 'e ‑jɔ ‑saa \"i ‑pee ɔ 'na : 'Ma 'blei 'a dɛ ‑tiiɛ' ‑nɩ ‑ʋn \"kpei ɛ‑ ? ");
INSERT INTO wob_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","‑Mɔ 'na : Ɔɔ' 'cnabi 'a kmɛ' 'due ‑nɩ 'ʋn \"kpei. 'Sʋ ɔ 'na : ‑Ɩn ‑duo\" ‑ma kpansbɛ 'ʋn, ‑ɩn ‑te i ‑too\"‑, ‑ɩn ‑je kwla ‑mm\" 'crɩ. ");
INSERT INTO wob_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Ɔ wlu' 'de jrɔ' ‑pee ɔ 'na : Dɛ ‑tiiɛ' ‑nɩ ‑mɔ \"kpei ɛ‑ ? ‑Mɔ 'na : koblɔ 'ɔ kmɛ' 'due. 'Sʋ ɔ 'na : ‑Ɩn ‑duo\" ‑ma kpansbɛ 'ʋn, ‑ɩn ‑crɩ kwla ‑mɛ\" na. ");
INSERT INTO wob_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Ta ɔɔ' 'blei 'jea 'srɛ ɔ nʋa 'mʋa‑ 'sʋ ɛ, ɔ po ɔ ‑tɩ' o, dɛ‑nʋɛ' ɔ nɩɛ tɔ'di, ‑wɛe ɔ ‑te' 'de ɔɔ' 'kmʋ 'a nya. Aoa 'jee, 'blʋa ‑nɛ 'ɛ 'di nyʋ 'bleɛ tɔ' ‑wɛe ʋʋa ‑teɛ' 'e dɛ 'ɛ nya 'de ba ‑pee, ɛ je Kea 'a \"nynuu ‑ʋʋ ‑nɩa 'e ‑sɔn' 'ʋn ‑sii. ");
INSERT INTO wob_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Sesi 'na : 'Mɔ 'naa 'wliiɛ‑ ‑nɩa 'e 'kmʋ \"kpei ɩa pooɛ nyʋ 'srɛ i, 'kaa ao \"duɩ 'ʋn ‑wɛe ao 'je nyʋ 'dɔe \"jrii nʋ, 'de ‑sɔntɩ ɩa mua ao 'kwa ‑pɔan' a, 'de Kea 'je ao sɩn 'sɔɔn kpʋʋn‑ 'de ɛɛ' ‑tein ‑sea' isɔn‑ta 'ble \"kpei. ");
INSERT INTO wob_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Nyɔ ‑kpʋan' wlu \"kpei‑ 'de dɩ mɩ\" mɩ\" 'a ‑tɩ' 'ʋn ɛ, ɔɔ muɛ wlu \"kpei‑ kpʋan 'de dɩ klae\" 'a ‑tɩ' 'ʋn ‑ke. Nyɔ ‑sea' \"isrɛ 'de dɩ mɩ\" mɩ\" 'a ‑tɩ' 'ʋn ɛ, ɔ se \"isrɛi 'de dɩ 'a klae\" 'a ‑tɩ' 'ʋn ‑ke. ");
INSERT INTO wob_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","‑Bo ao sese wlʋ \"kpei kpʋn 'de 'bluadidɩ 'a ‑tɩ' 'ʋn ɛ, ‑mɛ ‑ɔ ‑je aopʋ dɩ ‑cɛɛn'‑ kwa ‑te' 'jaa‑ ? ");
INSERT INTO wob_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","'De ‑bo ao se wlʋ \"kpei kpʋn 'de nyɔ jrɔ' 'ɔ dɩ 'a ‑tɩ' 'ʋn 'ee, ‑mɛ ka ao 'je wlu \"kpei kpʋn sʋn nʋ 'de aoa' ‑cɛ\" 'ɛ dɩ 'a ‑tɩ' 'ʋn ɛ‑ ? ");
INSERT INTO wob_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Nyɔ se ɛ 'bɛɛ‑ ɔ 'je nyʋ 'sɔɔn \"juɔi nʋʋ ‑tadue, ‑bo ɛ nɩ kan' a ɔɔ muɛ due' 'ʋn 'nyɛa' ‑wɛe ɔ 'je due 'a ‑tɩ' kma. Ɔɔ muɛ due' o ‑sia' 'de ɔ 'je due' ‑flɛɛn. Ao se ɛ 'bɛɛ‑ ao 'je Kea 'a 'tʋn nʋ‑tɩ nʋ ‑wɛe ao 'je 'e 'wɛi 'a \"dia 'jea' 'blee‑. ");
INSERT INTO wob_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Fariseɛn‑wi\" ‑nɩa 'kwa i a poɛ wlu Sesi 'tmʋa ‑nɛ doin\" o ‑ke. ‑wɛe ʋʋa wlɔɔ, dɛ‑nʋɛ' ʋʋ kma 'wɛi 'a ‑tɩ'. ");
INSERT INTO wob_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","'Sʋ Sesi wlu' 'de ʋʋ ‑pee ɔ 'na : Aopʋ mɔ ɛ, aoa 'daa aoa' ‑cɛ\" \"isrɛʋn 'bo nyiɔ \"juɔi, 'kaa dɛ ‑ɛɛ 'kpa nyʋa poa 'bo nyʋ \"juɛi ɛ, ‑mɛ ɛ nyaa Kea i. ");
INSERT INTO wob_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","'De Moisɩ 'a kɛ' ‑sɔn ke Kea 'a wlu 'kwajaaʋn 'a nɔ\" 'di mɔ nyʋ nɩ mamaʋ 'sʋ San Batisɩ 'je ji. Dɛ ‑tba' 'o ‑mɔ ɛ, Kea 'a 'kmʋ dee 'a ‑pɔia\" ‑tɩ a 'tmʋʋɛ 'de nyʋ ‑wee' ‑pee. ‑Wɛe nyiɔpʋ a ‑pɔn ʋʋ 'je \"klaan‑ \"klan nʋ ʋʋ 'je 'e Kea 'a kɛɛma' ‑kwlɔ 'di pa. ");
INSERT INTO wob_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","'Kaa ‑bo 'blʋa‑ ke jaʋn 'a ‑nɩ ‑si' mɔ 'de ɛ, kɛ' se 'sbɛjri ‑saan\"‑ ka \"kpei 'wlʋi. ");
INSERT INTO wob_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Ɛmɛ ‑tɩ nyɔ \"o nyɔ ‑sa ɔɔ' 'nynɔ 'kwla ‑wɛe ‑ɔ ‑dua\" deejrʋ' 'ʋn, ‑mɛ ɔ 'jeɛ jɛi\". 'De nyɔ \"o nyɔ ‑ɔ ‑dua\" 'nynɔkpao' ‑ʋa kʋan ‑sʋ 'kwla 'ʋn, ‑wɛe ʋ \"tia \"bli ɛ, ‑mɛ ɔ 'jeɛ jɛi\" ‑ke. ");
INSERT INTO wob_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Sesi pooɛ ‑tɩ' \"i ke'wlɛ ɔ 'na : \"Ju due' ‑nɩ 'o mu, ‑ɔ ‑nɩ \"wliɛjei, ɔɔ paa dɩ 'dɔe 'dɔe 'a 'sʋ 'ʋn 'de ɔɔ' 'kmʋnɩa' 'ʋn, ɔɔ nʋɛ ɔɔ' ‑kwlʋ ‑tɩ, ɔɔ diɛ dɩ 'dɔe 'dɔe 'a 'sʋ wɩ \"o wɩ. ");
INSERT INTO wob_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Nɩɩa\" nyɔ due' ‑ɔɔ 'nynɩ nɩ Lasa, ‑wɛe ‑ɔɔ ku nɩ ‑ci\" 'a 'sʋ, ɔmɔ ‑pɛn i 'bo \"wliiɛjei ‑nɔ o ‑gbu\" wɔ. ");
INSERT INTO wob_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Ɔ nɩɛ ɔ 'je diidɩ ‑ɩa ‑wla \"wliiɛjei 'a 'tablʋ ‑sɔn i di. 'De Ke'wlɛɛ ‑gbe' ‑sei\" mɩ ‑ɩa ji ‑wɛe ‑ɩa bɛ ɔɔ' ‑ci\" \"jrii‑. ");
INSERT INTO wob_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Nɩɩa\" nyɔ ‑nɔ 'mɛa, Kea 'a \"soa‑wi\" kpɔ 'bo Ablaam ‑pʋn\". \"Wliiɛjei ‑nɔ 'mɛɛ ‑ke, ʋʋ nmae ɔ i. ");
INSERT INTO wob_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","'De 'mɛʋn o ‑kwlɔ ɔ ‑taan'‑ a, ɔɔ' pɛe a ‑siɛ' ‑sro 'de mu. Ɔ kpa \"jri \"jɛi 'sʋ ɔɔ 'jeɛ Lasa i ‑ta ‑tɔɔn' 'bo Ablaam ‑pʋn\". ");
INSERT INTO wob_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","'Sʋ ɔɔ 'daa ɔ 'na : 'Ɩn \"bo Ablaam, ‑ɩn ‑je 'ma wɛe 'de, ‑ɩn dbo Lasa ɔ 'je ɔɔ' ‑cɩɛ 'e \"ni o tba ɔ 'je ɛ 'o 'ma mɩɩɔ \"kpei \"too‑, dɛ‑nʋɛ' 'ma 'jeɛ 'ma ‑cɛ\" wɔn kpleiin 'nɔ nɛ 'ʋn. ");
INSERT INTO wob_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Ablaam 'na : 'Ma \"ju, ‑ɩn po ‑tɩ' ‑kwlʋ o, ‑ta ‑ɩn ‑nɩɩa 'de 'kmʋ \"kpei ɛ, ‑ɩn ‑je ‑ma ‑nɩ 'dɔe ‑wee' 'mɛ, ‑mɛ Lasa ‑mɔ nɩɛ kui wɔn 'jea. 'Kaa kaan ka la, ɔɔ ‑tuu\" ɛ ‑tɩ' ‑kwlɩ' i, ɔ nɩɛ 'e 'mʋa 'ʋn, ‑wɛe ‑mɔ ‑nɩ 'e 'kle 'di. ");
INSERT INTO wob_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","'Bo ‑mɛ 'de ɛ, ‑gble ‑bie ‑nɩ 'o ‑a ‑ke ao 'nynɩ, ‑wɛe ‑bo nyɔ ‑nɩɛ \"i mɔ 'de‑ ‑ɔ 'je 'nɔ ‑a o 'wlʋ 'de ɔ 'je 'de aopʋ o ji ɛ, ɔ se ɛ 'bɛɛi. 'De nyɔ se ɛ 'bɛɛ‑ ke'wlɛ ɛ, ɔ 'je 'nɩa‑ 'wlʋ ‑wɛe ɔ 'je 'nɔ ‑a o ji. ");
INSERT INTO wob_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","'Sʋ \"wliiɛjei ‑nɔ 'na : ‑Bo ɛ nɩ kan' a, ‑mɛ 'ma bae ‑ʋn ‑ɛ 'ja, 'ɩn \"bo Ablaam, ‑ɩn dbo Lasa 'de 'ɩn \"bo o ‑gbu\" ‑sɔn, ");
INSERT INTO wob_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","dɛ‑nʋɛ' 'ɩn 'bleɛ de'dinmai ‑mm\". 'De ɔ 'je ʋʋpʋ 'tmʋʋ‑, ‑wɛe 'nɔ 'klejeɩn' 'ɩn nɩa ‑ta ʋʋ je 'nɔ ji ‑ke. ");
INSERT INTO wob_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","'Sʋ Ablaam 'na : ‑Ma de'dinmai‑wi\" ke Moisɩ ke Kea 'a wlu 'kwajaaʋn ‑teɛ i, ‑Bo ʋʋ nʋ dɛ 'de ɛ, ʋʋ po ʋʋpʋ 'a wlu doin\" o. ");
INSERT INTO wob_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","‑Wɛe \"wliiɛjei ‑nɔ 'na : \"Ɩɩn‑, 'ɩn \"bo Ablaam, ɛ se kan' nɩ‑, 'kaa ‑bo nyɔ 'wlʋ 'nɔ 'mɛʋn o ‑wɛe ɔ 'je ʋʋpʋ jɛɛ, ‑mɛ ʋʋa muɛ tɔ' fai\" pooa' see. ");
INSERT INTO wob_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","'Kaa Ablaam 'na : ‑Bo ʋʋ se Moisɩ ke Kea 'a wlu 'kwajaaʋn 'a wlu doin\" o po ɛ, ‑mɛ ‑bo nyɔ sɔn \"kunyɩɔ' ɔ mɔ 'de ɛ ʋʋ se ɔɔ' wlu doin\" o poi see. ");
INSERT INTO wob_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Sesi wlu' 'de ɔɔ' klai\" nynuu ‑pee : Dɩ ‑ɩa ‑mua nyʋ 'de dɛsaʋn 'di bluua' a, ɩa muɛ jia' ka \"o ka‑, 'kaa nyɔ ‑ɔ 'ʋn ɩa mua jiia' a ‑mɔ 'jeɛ \"nmia ‑tɩ. ");
INSERT INTO wob_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","‑Bo nyʋ sɔɔn ɔ \"soukpo klaa\" ‑plun, ‑wɛe nyʋ ‑fii\" ɔ 'de 'tɔniɛ wɔn, ɛ \"paa' ɛ je ɔɔ' nʋʋdɩ bluua \"nynuu mɩɩ\" ‑nʋ 'a due' 'de dɛsaʋn 'di ‑sii. ");
INSERT INTO wob_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Ao ‑tu\" aoa' ‑cɛ\" 'ɛ ‑tɩ'. ‑Bo ‑ma de'di nʋ ‑ʋn dɛsaʋn \"jrii ɛ, ‑mɛ ‑ɩn poɛ 'de ɔ \"jri, ‑ɩn ‑tmʋ ɔ ‑pee ka ‑cɔɔn' ka. ‑Bo ɔ 'wɔɛn 'mii ɛ, ‑mɛ ‑ɩn ‑ke ɔ ‑seea' wlu \"kpei‑. ");
INSERT INTO wob_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","'De ‑bo ‑ma de'di nʋ ‑ʋn dɛsaʋn \"jrii kpɛ ‑mɛ\" 'sɔn 'de ‑sɔn' 'di, ‑wɛe ɔ 'jeɛ \"i jua' de ji kpɛ ‑mɛ\" 'sɔn ɔ, ‑mɛ ‑ɩn ‑wlʋ' ɔɔ' dɛsaʋn \"kpei kpɛ ‑mɛ\" 'sɔn ‑ke. ");
INSERT INTO wob_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","'Sʋ ɔɔ' dboʋn wlu' 'de ɔ ‑pee ʋʋ 'na : Tʋ\"bo, ‑ɩn po ‑aa Kea ‑kwlɩ\" ‑tetɔ' \"kpei ! ");
INSERT INTO wob_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","‑Wɛe Tʋ\"bo wluu ɔ 'na : ‑Bo aoa' Kea ‑kwlɩ\" ‑tea' 'piie\"i ka sii\" 'a 'jɔ nɩa mɔ 'de ɛ, aoa muɛ wlua' 'de tu klaa\" ‑nɛ ‑pee : Ɛ sɔn ‑klu' ‑ta, ‑wɛe ɛ 'je inyna 'de 'tɔniɛ wɔn ! Ɛɛ muɛ aopʋ wɔn 'jea' see. ");
INSERT INTO wob_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Nyɔ ‑nɩ 'de ao \"klu ‑bo ‑ɔ ‑ble kʋɔn‑ ‑bo ‑mɔ 'wlʋ ko poa' ke nɔ\"dɩ 'de i ‑tea' ‑wɛe ‑ɔɔ wluɔ ‑pee ka : ‑Ɩn ‑kɩɩn' ‑ta ‑too\"‑ ‑ɩn ‑je dɛ di ɛ‑ ? ");
INSERT INTO wob_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Aoa sea wlu ka, ‑ɩn pi 'ma ‑kwie\" diidɛ‑, ‑poo 'ʋnpaadɩ fai\" ‑je 'ma diidɛ ja mamaʋ 'sʋ 'ɩn 'je dia' ke 'naa ‑kɔ' ‑wɛe ‑mɔ ‑je dɛ di 'de ‑ɩn ‑je 'na. ");
INSERT INTO wob_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Aoa naa tɔ' i 'ee, \"ju ‑nɔ 'je ɔɔ' kʋɔn ‑nɔ ‑tɩ' opo ‑oo ? 'De ɔɔ' dbo ɔ 'jea nʋ see ‑nɛ ɛɛ ‑tɩ 'ʋn ? ");
INSERT INTO wob_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Aopʋ mɔ ‑ke ɛ, ‑bo ao nʋ dbo ‑nɩa aoa' ‑nɩ nʋʋdbo ɛ, ao 'na ‑a ‑nɩɛ kʋɔn ‑wi\" ‑o, dɛ ‑a ‑jea nʋ see ɛ ɛmɛ ‑a nʋa 'o. ");
INSERT INTO wob_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Sesi a muɛ Selisalɛm ‑wɛe ɔ cɛɛn 'o Samadi blʋa ke Galileblʋa 'nynɩ. ");
INSERT INTO wob_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","‑Ta ɔɔ pa 'o ‑kwlɔ due' 'di 'sʋ ɛ, 'jrʋwɛnʋʋn ‑puue ‑jɔɔ' \"i. Ʋʋ tɛɛn ɔ o kpɩɩn‑ ka 'sʋ ʋʋ kpa wlu \"jɛi ʋʋ 'na : ");
INSERT INTO wob_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","Sesi, nyʋ 'blei, ‑ɩn ‑je ‑aa wɛe 'de ! ");
INSERT INTO wob_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Ɔ 'jea ʋʋpʋ 'sʋ, ɔ wlu' 'de ʋʋ ‑pee ɔ 'na : Ao mu ao 'je aoa' ‑cɛ\" Kea 'a 'sraa ‑saʋn \"i to‑. ‑Ta ʋʋ nɩɩa 'e mua' 'sʋ, ʋʋa' 'wɛ‑ 'bɔɔ 'bo ‑jei\". ");
INSERT INTO wob_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Ʋʋa' due 'jea kan' ka ɔɔ' 'wɛ‑ 'bɔa 'sʋ ɔ jiɛ ‑ta ɔ 'wlua de, 'de Kea 'a 'nynɩ \"i 'bɛɛa 'ʋn. ");
INSERT INTO wob_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Ɔ tba \"jua‑ i 'bo Sesi bɩ wɔ, ‑wɛe ɔ po ɔ 'sɛ‑. Ɔɔ' \"ju tu nɩɛ Samadi i ‑o. ");
INSERT INTO wob_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","'Bomɔ Sesi \"duo‑ wlu 'ʋn ɔ 'na : Ʋʋ se ‑puue nɩ ʋʋ se 'pʋʋ ? 'De ‑mɛ\" nyɛ ‑sia o ‑wi\" ‑mʋ 'e ? ");
INSERT INTO wob_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","‑Ɩɩn\" dɛɛ ‑tɩ 'dʋɩ‑ ‑nɔ ‑mɔ 'ɔ 'sʋ ji de ɔɔ 'bɛɛ‑ Kea 'a 'nynɩ \"i ɛ‑ ? ");
INSERT INTO wob_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","'Sʋ Sesi wlu' 'de \"ju ‑nɔ ‑pee ɔ 'na : ‑Ɩn sɔn 'ʋn, ‑ɩn ‑je mu, ‑ma Kea ‑kwlɩ\" ‑tea' 'pʋʋ ‑ʋn ‑ɛ. ");
INSERT INTO wob_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Fariseɛn‑wi\" ‑teeɛ' Sesi i ʋʋ 'na : Nɔ\" ‑jɛ 'di Kea 'a 'beɔdɛ 'je ji ɛ‑ ? 'Sʋ ɔ 'na : Kea 'a 'beɔdɛ se ji i ‑wɛe nyʋ se ɛ \"jriɛ 'jee i ‑pɛɛ ka. ");
INSERT INTO wob_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","'De nyʋ se wlui ka ɔ se nʋ i ao ji ɛ nɩɛ ‑ta 'de ɛ nɩɛ 'nɔ, 'kaa ao siɛ \"jriɛ o Kea 'a 'beɔdɛ nɩɛ 'de ao \"klu. ");
INSERT INTO wob_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","‑Wɛe ɔ wlu 'de klai\" nynuu ‑pee ɔ 'na : Nɔ\" jrɛ' ‑ɛɛ mu nynia' 'de ao 'je nyiɔ 'ɔ \"ju 'a 'wɩ 'a due' \"jriɛ‑ 'jeea' i‑pɔn, 'kaa ao seɔ 'je i mɔ 'ɔ ‑cɛ\" 'de 'wɩ due' koun ‑gbai' 'di. ");
INSERT INTO wob_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Nyʋ a muɛ aopʋ ‑pee wlua' ka ʋʋ 'je nʋ ɔ nɩɛ ‑ta, ɔ nɩɛ 'nɔ. 'Kaa ao 'bo pleeɛ, ao 'bo 'e muɛ, ");
INSERT INTO wob_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","dɛ‑nʋɛ' ka \"ni 'a \"jrii‑ crɛa' nɩa 'de jaʋn‑kwlʋ ɛ, 'kamɔ nyiɔ 'ɔ \"ju 'a deji ‑sɔn ɔ mu nɩa'. ");
INSERT INTO wob_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","'Kaa ‑bo ‑mɛ 'je nʋʋɛ ɛ ao 'je 'kle 'je ‑o ke kpɩɩn‑ 'de 'kmʋ \"kpei nyʋ 'jeɔ nya ‑fuun. ");
INSERT INTO wob_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Dɛ ‑nʋʋa 'de Noe 'a nɔ\" 'di 'de ɛ, ɛmɛ ‑ɛɛ mu nʋʋa' 'de nyiɔ 'ɔ \"Ju 'a dejiwɩ o. ");
INSERT INTO wob_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Nyiɔpʋ a di', ʋʋa 'naa, ʋʋa 'bleɛ 'nynʋkpae', ʋʋa ‑tuɛ\" ʋʋa' \"nynuunynʋkpae' jrai, ʋʋa poɛ ʋʋa' \"nynuunmaɩ 'a 'nynʋkpae' 'a \"flu, mamaʋ 'sʋ, ɛ je Noe 'a 'de ‑bato' 'di paa' jɛɛ‑, ‑wɛe \"ni klaa\" dba, 'de ɛ ‑sa ʋʋpʋ i. ");
INSERT INTO wob_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Ka ɛ nɩa 'de Lɔtɩ 'a nɔ\" 'di ɛ, 'kamɔ ɛɛ mu nɩa'. Nyiɔpʋ a di', ʋʋa 'naa, ʋʋa ‑tɩɛn' dɩ, ʋʋa pleɛ dɩ, ʋʋa doɛ dɩ, ʋʋa poɛ ‑gbi\". ");
INSERT INTO wob_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","'Kaa 'wɩ ‑ɛ 'di Lɔtɩ 'wlʋʋa 'o Sodɔm ɛ, nɛ ke fuu\" mɩ ‑wlʋ 'e \"jɛi ‑ɩ ‑wla 'o mu ‑wɛe ‑ɩ ‑sa nyʋ ‑wee' \"klein i. ");
INSERT INTO wob_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","'Kamɔ ɛɛ' dɛ tu a mu nʋʋa', ‑sɔntɩ nyiɔ 'ɔ \"ju a mua de jia' a. ");
INSERT INTO wob_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","'De ɛɛ' 'wɩ tu 'di, nyɔ ‑nɩa 'de ɔ o ‑gbu\" wɔ 'de ‑ɔɔ dɩ sia 'e ‑gbu\" ɔ 'bo ɩ 'ʋn \"dua muɛ, 'de ‑jɔ ‑nɩa 'e ‑kle ɛ ‑mɔ 'bo ‑kwlɔ de muɛ. ");
INSERT INTO wob_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Ao po Lɔtɩ 'a 'nynɔ 'ɔ ‑tɩ' ‑kwlʋ o. ");
INSERT INTO wob_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Nyɔ ‑ɔ ‑nɩɛi\" ‑ɔ ‑jea ɔɔ' 'kmʋ \"kpei‑ 'tʋan, ɔɔ muɛ \"maa'. 'Kaa nyɔ ‑ɔɔ mua ɔɔ' 'kmʋ 'bɔa 'de 'ma ‑tɩ' 'ʋn ɛ, ɔɔ mu ɛ 'pʋʋa'. ");
INSERT INTO wob_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","'Ma 'tmʋʋ‑ aopʋ 'mɛ, 'de ɛɛ' \"maʋ'wɩ tu 'di ɛ, ‑bo nyʋ 'sɔɔn plaan‑ ‑tadue 'bo 'dii due' \"kpei ɛ, due' a muɛ 'ʋn \"duua', 'de due' 'je 'o sie‑. ");
INSERT INTO wob_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","‑Bo 'nynʋkpae' 'sɔɔn nɩ ‑tadue duua' 'bo ‑too \"kpei ɛ, due' a muɛ 'ʋn \"duua', 'de due' 'je 'o sie‑. ");
INSERT INTO wob_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Nyʋ 'sɔɔn ‑nɩa 'e ‑kle' \"kpei ɛ, due' a muɛ 'ʋn \"duua', ‑wɛe due' 'je 'o sie‑. ");
INSERT INTO wob_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","'Sʋ ɔɔ' klai\" nynuu ‑teeɛ' ɔ i ʋʋ 'na : Tʋ\"bo, ‑ta ka fɔ o ‑mɩ 'a dɩ tu 'je nʋʋ ɛ‑ ? 'Sʋ ɔ 'na : Aoa' \"jriɛ‑ ɛ mu ɛ 'jeea'. ‑Ta \"ku nɩa, 'bomɔ ‑tua a 'kɩɩn‑ \"jrui. ");
INSERT INTO wob_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Ka nyɔ 'jea Kea bae jeejee ‑wɛe 'kpɩ se ɔ \"iwai ɛ, ɛmɛ Sesi nɩ \"i ɔ 'je 'tmʋ 'de ʋʋ ‑pee, ‑wɛe ɔ poo ‑tɩ' \"i ka ɔ 'na : ");
INSERT INTO wob_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","'Bo ‑kwlɔ klaa\" jrɛ' 'di, 'bomɔ \"ju due' ‑ɔɔ ‑jea nyʋ 'a 'pee nɩ‑. Ɔɔ' \"ju tu 'a plee Kea, ɔɔ' ‑tɩ' se nyiɔ 'ɔ ‑tɩ' 'ʋn nɩ‑. ");
INSERT INTO wob_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","‑Tiɔn\" 'nynɔ due' ‑nɩ 'o ɛɛ' ‑kwlɔ tu 'di ‑ke, ‑ʋa ji 'e 'pee 'jei ‑nɔ o 'wɩ \"o 'wɩ, 'de ‑ʋa nʋ : 'Ɩn ji' ‑wɛe ‑ɩn ‑je nyʋ ‑ke 'ma‑ ‑blea ‑tɩ' 'a 'pee 'je. ");
INSERT INTO wob_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","'De 'wɩ ‑tuu\"‑tuu 'di ɛ, ɔɔ' po ʋa' wlu doin\" o. 'Sʋ ɔ naa tɔ' i 'de ɔɔ' ‑cɛ\" 'ʋn ɔ 'na : ‑Bo 'maa plee Kea mɔ 'de ɛ, ‑wɛe 'ma ‑tɩ' se nyiɔ 'ɔ ‑tɩ' 'ʋn nɩ ɛ, ");
INSERT INTO wob_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","'ma jiɛ ‑tiɔn\" 'nynɔ ‑nʋ 'a ‑tɩ' \"i ‑seea', dɛ‑nʋɛ' ʋa tɛɛn 'ʋn wɔin. ‑Bo ɛ se ɛ nɩ ɛ, ‑mɛ ʋ se 'ʋn doin\" \"jru cɛn‑tɩ 'bɔi. ");
INSERT INTO wob_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","‑Wɛe Tʋ\"bo poɛ \"kpei ka ɔ 'na : Ao ‑gbʋn, 'pee 'jei saʋn‑ ‑nɔ 'ɔ 'tmʋʋ ‑tɩ. ");
INSERT INTO wob_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","'De ‑mɛ Kea ‑mɛ 'e, nyʋ ɛ ‑tea' 'o ‑wɛe ‑ʋʋa baeɛ \"maʋ' o 'jrʋ ‑gbao ɛ se 'bɛɛ‑ ɛ 'e ‑wi\" ‑mʋ \"isrɛ ‑tɩ \"jrii nʋʋ ? Ɛɛ muɛ imaa' ke 'de ‑wi\" ‑mʋ 'a ‑tɩ' 'ʋn ? ");
INSERT INTO wob_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","'Ma 'tmʋʋ‑ aopʋ 'mɛ, ɛɛ muɛ \"isrɛdɩ nʋa' ‑too\"‑ 'de ʋʋ ‑pee. 'Kaa 'ma ‑teeɛ' aopʋ i ‑sɔntɩ nyiɔ 'ɔ \"Ju a mua de jia' 'ee, ɔɔ muɛ ɔɔ' ‑kwlɩ\" ‑tea' jɛɛa' 'de nyʋ 'ʋn 'nɔ 'blʋa‑ \"kpeii ? ");
INSERT INTO wob_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Sesi pooɛ ‑tɩ' \"i ke'wlɛ 'de nyʋ ‑ʋʋa ‑daa' ʋʋa' ‑cɛ\" \"isrɛnyʋ ‑wɛe ‑ʋʋa ‑flɛan' nyʋ jrʋ' 'a ‑tɩ' 'ʋn. ");
INSERT INTO wob_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","Ɔ 'na : Nyʋ 'sɔɔn ‑mu' baea' 'de Kea ‑gbu klaa\" 'di, due' nɩɛ Fariseɛn, ‑wɛe due' nɩ 'wɛi‑sai. ");
INSERT INTO wob_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Fariseɛn ‑mɔ nyna \"jɛi, ‑wɛe ɔɔ bae Kea ka 'de ɔ pɛe o ɔ 'na : 'Oo Kea, 'ma poɛ ɛ 'sɛ‑, dɛ‑nʋɛ' ka nyʋ ‑sia 'o nɩa \"jriʋn o, 'diwɔnyniʋn o, jɛi\" 'jeʋn, 'ɩn se kan' nɩ‑. 'Ma poɛ ɛ 'sɛ‑ ke'wlɛ, dɛ‑nʋɛ' ka 'wɛi‑sai ‑nɔ nɩa 'ɩn se kan' nɩ‑. ");
INSERT INTO wob_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","'Ma 'bɔ wɔn kpɛ 'sɔɔn 'de 'dɔɔ 'di. Dɩ \"klein 'ma 'jea, 'ma ja ɩa' ‑puue ‑nɛ 'mɛ, 'ma jea ɛ wɔn ‑saa'. ");
INSERT INTO wob_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","'Kaa 'wɛi‑sai ‑mɔ tɛɛn o, ɔ se \"jri \"jɛi kpa ‑wɛe 'de jaʋn 'di mɔ'ɔ ‑gbʋntɩ, ɔɔ bla ‑pɛɛ' ‑wɛe ɔ 'na : 'Oo Kea, 'mɔ ‑ɔ ‑nɩa dɛsaʋn nʋi ɛ, ɛ 'wla 'cɛn 'de 'ʋn ‑pee ! ");
INSERT INTO wob_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","'Bomɔ Sesi poɛ \"kpei ka ɔ 'na : 'Ma 'tmʋʋ‑ aopʋ 'mɛ, \"ju ‑nɔ, ‑ta ɔɔ muua 'de ɔ o ‑gbɛin\" de ɛ, ɔ ke Kea ‑kɔ', ɛ ke Fariseɛn ‑mɔ se ‑kɔ', dɛ‑nʋɛ' nyɔ \"o nyɔ ‑ɔɔ kpa ɔɔ' ‑cɛ\" \"jɛi ɛ, ɔɔ muɛ ‑sɔn jia', ‑wɛe nyɔ ‑jɔɔ jaa ɔɔ' ‑cɛ\" ja ɛ, ‑mɔ 'e \"jɛi mu. ");
INSERT INTO wob_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Ʋʋ ja Sesi \"nynumɩɩ\" ‑wɛe ɔ 'je ʋʋpʋ sʋn \"kpei ‑te'. 'Kaa ɔɔ' klai\" nynuu a ‑cɛ' nyʋ ‑ʋʋa ja \"nynumɩɩ\" \"bli. ");
INSERT INTO wob_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","'Sʋ Sesi 'da ʋʋpʋ, 'de ɔ 'na : Ao \"tai‑ \"nynumɩɩ\" \"i ʋʋ 'je 'nɔ 'ʋn o ji, ao 'bo ʋʋpʋ ‑je de kaan. Nyʋ ka ʋʋpʋ nɩa, ‑ʋʋ ‑nɩa kan' a, ʋʋpʋ a ‑tea' Kea 'a kɛɛma' ‑kwlɔ ‑te. ");
INSERT INTO wob_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","'Ma 'tmʋʋ‑ ao tɔ' ‑tɩ nyɔ \"o nyɔ ‑sea' Kea 'a 'beɔdɛ 'ɛ ‑tɩ' pɛe \"itba ka \"ju ‑saan\" a tba dɛ pɛe \"i ɛ, ɔ se 'e Kea 'a kɛɛma' ‑kwlɔ 'di pai. ");
INSERT INTO wob_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Suifʋ‑wi\" 'a klaa\" due' mɔ ‑tee' Sesi i ɔ 'na : nyʋ dɛtɔɔi 'dɔe, dɛ 'ɩn 'je nʋ ‑wɛe 'ɩn 'je 'kmʋnɩa' ‑sea' ‑kwɛ ‑ta 'ble 'je ɛ‑ ? ");
INSERT INTO wob_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Sesi 'na : Dɛɛ‑tɩ ‑ma ‑daa' 'ʋn nyɔ 'dɔe ɛ‑ ? Nyɔ jrɔ' se nyɔ 'dɔe nɩ‑, ‑bo ɛ se Kea 'a 'sʋ nɩ ɛ. ");
INSERT INTO wob_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","‑Ɩn ‑juo Kea 'a kɛ' 'mɛ, ɛ 'na : ‑Ɩn ‑bo jɛi\" 'jeɛ, ‑ɩn ‑bo \"ku 'dbaa, ‑ɩn ‑bo \"jriiɛ, ‑ɩn ‑bo nyʋ sɩ‑tɩ \"kpei ‑tuu\" ɛ, ‑ɩn ‑te' ‑ɩn \"bo ke ‑ɩn de 'a ni' ! ");
INSERT INTO wob_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","\"Ju ‑nɔ 'na : 'Ɩn ‑sa kɛ' ‑nɩa 'mʋa 'a wɔn 'jea' 'de ‑saan\"‑ 'ʋn. ");
INSERT INTO wob_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Sesi 'wɔan wlu ‑nɛ 'sʋ ɔ 'na : Dɛ due' ‑sie 'o ke, ‑ɩn ‑je nʋ. ‑Ɩn ple ‑ma dɩ ‑wee' \"klein, ‑ɩn ‑nyɩ\" ɩa' 'wɛi nɩɩa\" nyʋ, ‑wɛe ‑ɩn ‑je dɛ jei nɩ 'de jaʋn 'di. 'De ‑ɩn ‑je ji, ‑ɩn ‑je 'bo 'ʋn 'de bla. ");
INSERT INTO wob_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","'Kaa \"ju ‑nɔ 'wɔan wlu ‑nɩa 'mʋa‑, 'sʋ ɔ \"kaeɛ \"jrii \"kɩkɩ, dɛ‑nʋɛ' ɔ nɩɛ \"wliiɛjei klaa\" ‑o. ");
INSERT INTO wob_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Sesi 'jea ɔɔ' \"jrii \"kaea' ‑nɛ 'sʋ, ɔ 'na : Ka \"wliiɛjeʋn 'a Kea 'a Kɛɛma' ‑kwlɔ 'di paa' nɩ 'kle ka‑ ! ");
INSERT INTO wob_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","‑Sɛn \"kpei soo\" 'a 'bo \"padɛ 'ɛ ‑po\" \"icɛan' \"koan \"i ɛ je \"wliiɛjei 'a Kea 'a kɛɛma' ‑kwlɔ 'di paa' ‑sii. ");
INSERT INTO wob_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Nyʋ ‑wɔan ɔɔ' wlu ‑nɛ ʋʋ 'na : Dɛ nyɔ 'bɛɛ ɔ 'je nʋ 'ja a‑ ? ");
INSERT INTO wob_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Sesi 'na : Dɛ nyiɔpʋ‑ sea 'bɛɛ‑, Kea 'bɛɛ‑ ɛɛ' nʋa' 'mɛ. ");
INSERT INTO wob_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","'Sʋ Piɛi 'na : ‑Ɩn ‑gbʋn 'nɔ, ‑apʋ ‑ɔ ‑bɔa ‑ɔɔ dɩ ‑wee' \"klein 'de ‑ɔ bla 'bo ‑ʋn 'de 'e ? ");
INSERT INTO wob_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","'Sʋ Sesi wlu' ɔ 'na : 'Ma 'tmʋʋɛ aopʋ tɔ' ‑tɩ, nyɔ ‑bɔa ɔɔ' ‑gbu\", ɔɔ' 'nynɔ, ɔɔ' de'dinmai, ɔ \"bo ke ɔ de, ɔɔ' \"nynuu‑, 'de Kea 'a kɛɛma' ‑kwlɔ 'ɔ ‑tɩ' 'ʋn ɛ, ");
INSERT INTO wob_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","ɔɔ muɛ dɩ ‑tuu\"‑tuu 'jea' 'de kaanwɩ 'di, ‑wɛe 'de nya ɔ 'je 'kmʋnɩa' ‑sea' ‑kwɛ ‑ta 'ble 'je ‑ke. ");
INSERT INTO wob_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Sesi 'da ɔɔ' dboʋn ‑nɩa ‑puue 'jɔ 'sɔɔn 'mɛ 'bo ɔ ‑pʋn\", ‑wɛe ɔ wlu 'de ʋʋ ‑pee ɔ 'na : Ao ‑gbʋn 'nɔ, ‑aa muɛ Selisalɛm ‑wɛe dɩ \"klein Kea 'a wlu 'kwajaaʋn 'crɩa 'de 'mɔ nyiɔ 'ɔ \"ju 'a ‑tɩ' 'ʋn 'de ɛ, ɩ 'je 'o nyni. ");
INSERT INTO wob_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Dɩ ʋʋ 'crɩa ɩmɩ ‑nɩ nyiɔ 'ɔ \"Ju a muɛ 'e toa' 'de nyʋ sea' Kea juo 'kwa. Ʋʋ 'je ɔ wlaa‑, ʋʋ 'je ɔ ‑cree\"‑, ‑wɛe ʋʋ 'je ɔ tɔn \"jri wlan. ");
INSERT INTO wob_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Ʋʋ 'je ɔ klae 'ʋn kpa, 'de ʋʋ 'je ɔ 'dba, ‑wɛe 'de 'wɩ 'a taan ‑nɛ 'di ɛ, ɔ 'je \"kunyɩɔ' sɔn‑. ");
INSERT INTO wob_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","'Kaa dɛ Sesi 'tmʋa 'mʋa‑ ʋʋ seɛ 'dei 'wɔn, dɛ‑nʋɛ' ka dɛ ɛ ‑tua\" a 'kwla, 'kamɔ ɛɛ' wlu tu nɩ 'de ʋʋpʋ 'ʋn. ");
INSERT INTO wob_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","‑Ta Sesi 'a \"kʋʋan Seriko ‑kwlɔ i ɛ, ‑mɛ \"dɔi due' ‑teɛ i 'bo ‑je doun\" ‑wɛe ɔɔ ‑srɔ' nyʋ o. ");
INSERT INTO wob_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Ɔ 'wɔan nyiɔpʋ 'a ‑ciin 'sʋ ɛ, ɔ ‑teeɛ' nyʋ i ɔ 'na : Dɛ ‑nɩ 'emu kan' ‑a ? ");
INSERT INTO wob_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Ʋʋ 'na : Sesi ‑wlʋa Nasarɛtɩ mɔ ‑ɔɔ ‑si'. ");
INSERT INTO wob_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","'Sʋ ɔ \"wɔɔ' ɔ 'na : Sesi, Dafidɩ 'a \"ju, ‑ɩn ‑je 'ma wɛe 'de ! ");
INSERT INTO wob_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Nyʋ ‑nɩa 'e nya ʋʋa ‑sɔ' wlu \"wɔin, 'kaa ɔmɔɔ \"wɔɔ' ke'wlɛ ɔɔ jea \"jru o muu ɔ 'na : Dafidɩ 'a \"ju, ‑ɩn ‑je 'ma wɛe 'dee ! ");
INSERT INTO wob_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Sesi nyna i 'sʋ ɔ 'na : Ao jɔ 'ʋn ! ");
INSERT INTO wob_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","‑Ta \"dɔi 'kpaa' 'bo ɔ ‑pʋn\" ɛ, Sesi ‑tee' ɔ i ɔ 'na : Dɛ ‑ma ‑pɔn 'ɩn 'je ‑ʋn \"jrii nʋ ɛ‑ ? 'Sʋ ɔ 'na : 'Ma 'blei, ‑ɩn nʋɛ ‑wɛe 'ɩn 'je i 'je ke'wlɛ. ");
INSERT INTO wob_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","'Sʋ Sesi wlu ɔ ‑pee ɔ 'na : ‑Ma \"jri 'bai‑, ‑ma 'ma ‑kwlɩ\" ‑tea' 'pʋʋ ‑ʋn ‑ɛ. ");
INSERT INTO wob_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","'Bo ɛ \"si ɔɔ' \"jri je 'bai‑, 'sʋ ɔ bla 'o Sesi 'de, 'de Kea 'a 'nynɩ \"i 'bɛɛa' 'ʋn. Nyʋ \"klein ‑jeea' dɛ ‑nʋʋa 'mʋa‑ \"jriɛ‑ ɛ, ʋʋa 'bɛɛ‑ Kea 'a 'nynɩ \"i ‑ke. ");
INSERT INTO wob_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Sesi pa 'o Seriko ‑kwlɔ 'di 'sʋ ɛ, ɔɔ cɛn 'o ‑tie\". ");
INSERT INTO wob_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","\"Wliiɛjei due' ‑nɩ 'o mu, ɔɔ' 'nynɩ ‑nɩ Sase. Ɔ nɩɛ 'wɛi‑sanyʋ 'a klaa\" ‑o. Ɔmɔ ‑ɔɔ ‑pɔn \"ju ‑nɩa Sesi \"jriɛ‑ 'jea i. ");
INSERT INTO wob_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","'Kaa 'de nyiɔpʋ 'a \"i ‑tia' 'ʋn ɛ, ‑ta ɔ 'jea cɛɛn 'bo se nɩ‑, 'de ɔ \"kʋan i. ");
INSERT INTO wob_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","'Sʋ ɔ kpa plea' 'de ‑je 'a nya, ‑wɛe ɔ 'ja 'e sikomɔɔtu ja, 'de ɔ 'e Sesi \"jriɛ‑ 'jee‑ ka \"o ka, dɛ‑nʋɛ' 'bomɔ ɔɔ mu ‑sia' see. ");
INSERT INTO wob_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Sesi nynia 'o 'a ‑ta ‑tu 'sʋ, ɔ kpa \"jri \"jɛi ‑wɛe ɔ 'na : Sase, ‑ɩn ‑si\" i ‑too\"‑, dɛ‑nʋɛ' ‑ɩn ‑bleɛ 'ʋn 'dʋɩ‑ 'ʋn ‑sɩan. ");
INSERT INTO wob_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","'Sʋ Sase crɛɛ \"kpei‑ ɔ \"siɛ i ‑wɛe ɔ kpa Sesi 'de ɔ o ‑gbu\" 'de 'mʋa‑ 'ʋn. ");
INSERT INTO wob_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Nyʋ \"klein ‑jeea' dɛ ‑nɩa 'mʋa‑ \"jriɛ‑, ʋʋa \"wuan‑ Sesi 'dei, ʋʋ 'na : Ao ‑gbʋn 'nɔ, ɔmɔ ‑ɔɔ mua 'o 'de dɛsaʋn nʋi o ‑gbu\" 'di kooa' ! ");
INSERT INTO wob_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","'Kaa Sase ‑mɔ ɛ, ɔ nyna i 'bo Sesi \"juɛi, 'de ɔ 'na : Tʋ\"bo, ‑ɩn ‑gbʋn 'nɔ, 'ma muɛ 'ma \"wliiɛ‑ 'ʋn ‑seea', ‑wɛe 'ɩn 'je ɛɛ' tɔo nɩɩa\" nyʋ \"nyɩ, 'de nyɔ 'ɩn pooa 'srɛ i ‑wɛe 'ɩn ‑sa dɛ 'kwa 'ma muɛ \"kpei ‑tea' kpɛ ‑nyiiɛ 'ɩn 'jeɔ \"nyɩ. ");
INSERT INTO wob_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","'Sʋ Sesi wlu ɔ ‑pee ɔ 'na : 'Pʋʋa' pa 'nɔ ‑gbu\" ‑nɛ 'di 'mɛ ‑sɩan, dɛ‑nʋɛ' \"ju ‑nɔ nɩɛ Ablaam 'a \"ju ‑o ‑ke. ");
INSERT INTO wob_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","'Mɔ nyiɔ 'ɔ \"Ju 'ɩn jiɛ nyʋ ‑ma\" i‑pɔan' 'de 'ɩn 'je ʋʋpʋ 'pʋʋ‑. ");
INSERT INTO wob_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Sesi wlu' ke'wlɛ ɔ pooɛ ‑tɩ' \"i 'de nyʋ ‑ʋʋ jia wlu ‑nɩ doin\" o poa' ‑pee, dɛ‑nʋɛ' dɛ ɔɔ \"kʋʋan Selisalɛm‑kwlɔ i ɛ, ʋʋa naa tɔ' i ka ʋʋ 'na ‑mɛ 'bomɔ Kea 'a 'beɔdɛ 'je \"sri ɛ 'e \"jri \"kpae' poo 'de‑. ");
INSERT INTO wob_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Ɛmɛ ‑tɩ ɔ wlu ka ɔ 'na : \"Ju due' ‑wlʋa 'e 'beɔ ‑gbɛin\", ɔmɔ ‑mu' 'e 'blʋa‑ ‑tɔɔn' ‑tɔɔn \"kpei, ‑wɛe ‑bo ʋʋ ‑teɔ' 'o, 'de ‑ɔ ‑je de ji. ");
INSERT INTO wob_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","'Sʋ ɔ 'da ɔɔ' dbonʋʋn ‑puue, ‑wɛe ɔ \"nyɩ ʋʋpʋ 'sanikpi due 'due, 'de ɔ 'na : Ao poo ɩ 'dɔɔ 'ʋn mamaʋ, 'sʋ 'ɩn 'je de ji. ");
INSERT INTO wob_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","'Kaa nyʋ ‑nɩa 'e ɔɔ' 'blʋa \"kpei ‑nʋ a ‑flɛɛn 'ɔ ɛmɛ ‑tɩ ʋʋ dbo ɔ nyʋ kɩn ʋʋ wlu ka : ‑A se ɛ \"i nɩ \"ju ‑nɔ 'je 'o ‑teeɛ‑. ");
INSERT INTO wob_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Ʋʋ ‑teɔ' 'o, ɔ 'kpa 'beɔ 'sʋ, ɔ jiɛ 'e ɔɔ' 'blʋa‑ 'di de, ‑wɛe ɔ 'da ɔɔ' dbonʋʋn ɔ sia 'wɛi o ‑nʋ, 'de dɩ ʋʋ 'jea ‑wɛe ʋʋ 'je ɩa' \"kuan po. ");
INSERT INTO wob_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","‑Jɔ ‑saa \"i jia, ɔ 'na : 'Ma 'blei, 'ɩn 'jeɛ 'sanikpi ‑puue 'ɩn je kpo due' ‑ɩn sia 'ʋn o \"kpei po. ");
INSERT INTO wob_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","'Sʋ 'beɔ wlu' 'de ɔ ‑pee ɔ 'na : Ɛ nmɔ \"jrii, ‑ɩn nʋɛ dbo 'dɔe, ka ‑ɩn ‑bɛɛa' dɛ‑saan\" 'wɔn \"i ɛ, 'ɩn ‑teɛ' ‑ʋn ‑kwlɛ ‑puue kwa, ‑wɛe ‑ɩn ‑je ɩa' \"jrukpɔ' i ‑tei nɩ‑. ");
INSERT INTO wob_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Ʋʋa' 'sɔɔn ‑nɔ 'kpa 'o 'ɛ ɔ 'na : 'Ma 'blei, 'ɩn 'jeɛ 'sanikpi ‑mm\" 'ɩn 'je due' ‑ɩn sia 'ʋn o \"kpei po. ");
INSERT INTO wob_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","'Sʋ 'beɔ wlu' 'de ‑mɔ ‑pee ɔ 'na : ‑Mɔ ‑ke ɛ, 'ɩn ‑teɛ' ‑ʋn ‑kwlɛ ‑mm\" kwa, ‑wɛe ‑ɩn ‑je ɩa' \"jrukpɔ' i ‑tei nɩ‑. ");
INSERT INTO wob_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Dbonʋi deejrɔ' jia ‑mɔ 'na : 'Ma 'blei, ‑ma 'sanikpo ‑ɩn sia 'ʋn o, ɛ ka. 'Ɩn pooɛ tae' fɔ kpo \"i ‑wɛe ‑ta \"ni 'a 'kpa a, 'ɩn ‑te' ɛ 'o i. ");
INSERT INTO wob_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","'Ma plee ‑ʋn ‑ɛ, dɛ‑nʋɛ' ‑ma nyiɔ tu kma wɔn. Dɛ ‑ɩn sea i ‑te' ɛ, ɛmɛ ‑ma ‑duo\" 'ʋn, ‑ta ‑ɩn sea po, 'bomɔ ‑ma ‑sa' dɛ. ");
INSERT INTO wob_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","'Bomɔ ɔɔ' 'blei ‑nɔ wluu 'de ɔ ‑pee ɔ 'na : ‑Mɔ dbonʋi saʋn‑, 'bo ‑ma ‑cɛ\" 'kpa 'a wlu \"kpei 'bomɔ 'ma ji ‑ma 'pee 'jeea'. Ka 'ɩn kma wɔn ‑ɩn ‑jea kan' ‑mɔ 'ee, ‑wɛe dɛ 'ɩn sea i ‑te' 'ma \"duɛ 'ʋn, 'de ‑ta 'ɩn sea dɛ po 'ma ‑sa 'o dɛ 'ee, ");
INSERT INTO wob_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","‑mɛ dɛɛ‑tɩ ‑ɩn se 'ma 'wɛi 'de 'wɛi i ‑te' ‑gbu 'di kpa a‑ ? ‑wɛe ‑bo 'ɩn ji de, ‑bo 'ma sɩ 'e ‑sa' 'de ɩ se 'o crɔn' po ɛ‑ ? ");
INSERT INTO wob_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","'Sʋ ɔ wlu' 'e nyʋ ‑jea ɛɛ' ‑ta ‑pee ɔ 'na : Ao ‑sɔ 'sanikpo ‑nɛ 'kwa, ‑wɛe ao 'je ɛ \"ju ‑blea 'sanikpi ‑puue \"nyɩ. ");
INSERT INTO wob_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","'De ʋʋ wlu 'de ɔ ‑pee ʋʋ 'na : ‑Aa 'beɔ, \"ju ‑nɔ ‑mɔ 'ble 'sanikpi ‑puue wɛ‑ 'de ‑o ! ");
INSERT INTO wob_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","'Sʋ ɔ 'na : 'Ma 'tmʋʋ aopʋ 'mɛ, nyɔ ‑ɔ ‑blea dɛ ɛ, nyʋ a mu ɔ jrɛ' \"nyɩa' ke'wlɛ, 'kaa nyɔ ‑jɔ sea dɛ 'ble ɛ, dɛ ‑jɛ ɔ 'blea mɔ nyʋ a muɛ ‑mɛ ɔ 'kwa ‑saa'. ");
INSERT INTO wob_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","'De ‑jɛ ‑sia 'o la ɛmɛ ‑nɩ ao ja 'ʋn 'ma tʋnyʋ ‑ʋʋ seɛ \"i nɩ‑ 'ɩn 'jea ʋʋpʋ 'a 'beɔ nɩ ɛ ‑wɛe ao 'je ʋʋpʋ 'dba ‑ta 'ɩn \"juɔi. ");
INSERT INTO wob_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Sesi ‑kɔa' wlua' kan' 'sʋ ɛ, ɔ kɔn 'e nyʋ 'a nya ‑wɛe ʋʋ 'kpa Selisalɛm ‑jei\". ");
INSERT INTO wob_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","‑Ta ʋʋ \"kʋʋan Befase ke Betani i, 'bo olifɩ‑crʋ ‑pʋn\", 'sʋ Sesi dboɛ ɔɔ' klai\" nynuu 'sɔɔn nya 'de ɔ 'na : ");
INSERT INTO wob_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","Ao mu 'o ‑kwlɔ ‑nɩa 'o ‑a \"juɔi 'mʋa‑ 'di, aoa muɛ soofaeju ‑ɛ ‑mʋʋa i jɛɛa'. Nyɔ jrɔ' se ɛ \"kpei ‑te due'. Ao kain ɛ i, ‑wɛe ao 'je ɛ ‑ta ja‑. ");
INSERT INTO wob_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","‑Bo nyʋ ‑tee' aopʋ i ‑wɛe ɔ 'e nʋ : Dɛɛ‑tɩ aoa kain ɛ i ɛ, ‑mɛ ao wlu ka 'de ɔ ‑pee ao 'na : Tʋ\"bo ‑nɩ ɛ \"i. ");
INSERT INTO wob_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Nyʋ Sesi dboa mua, ka ɔ \"sia dɩ 'a 'nynɩ ɛ, 'kamɔ ʋʋ jɛɛ ɩ ‑cɛɛn'‑. ");
INSERT INTO wob_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","‑Ta ʋʋ nɩɩa soofaeju 'a i kaian' 'sʋ ɛ, ɛɛ' jeʋn ‑wi\" wlu' 'de ʋʋ ‑pee ʋʋ 'na : Dɛɛ‑tɩ aoa kain soofaeju i ɛ‑ ? ");
INSERT INTO wob_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","'Sʋ ʋʋ 'na : Tʋ\"bo ‑a ‑pɔn' ɛ. ");
INSERT INTO wob_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","‑Wɛe ʋʋ kpa Sesi soofae' ju 'de ʋʋ sro ʋʋa' 'ʋnpaadɩ 'bo ɛ \"kpei, ‑wɛe ʋʋ 'jaa‑ 'o Sesi. ");
INSERT INTO wob_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","‑Ta ʋʋ nɩɩa naa' a, nyiɔpʋ a sroɛ ʋʋa' 'ʋnpaadɩ ‑je woi ‑ta ‑wee' \"klein. ");
INSERT INTO wob_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","‑Ta ɔɔ \"kʋʋan Selisalɛm i 'sʋ ɛ, ‑wɛe ɔɔ ‑crea' olifɩ‑crʋ ɛ, 'mʋa‑ \"ji 'e nyʋ \"klein ‑ʋʋ ‑ke ɔɔ na 'ʋn 'ɛ, 'sʋ ʋʋ ‑teɛ Kea 'a 'nynɩ \"i 'bɛɛa' ‑pʋn\", ");
INSERT INTO wob_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","ʋʋ 'na : Kea 'a \"diwan kpʋn 'beɔ ‑ɔɔ jia 'de ɛɛ' 'nynɩ 'ʋn ɛ ! pɛe 'a blua' nɩ 'e jaʋn 'di ! Kea 'a 'nynɩ 'bɛi\" ‑ta \"o ‑ta ! ");
INSERT INTO wob_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Fariseɛn‑wi\" 'a jrʋ' ‑nɩa 'e nyʋ \"klu ɛ, ʋʋ wlu' 'de Sesi ‑pee ka ʋʋ 'na : Nyʋ dɛtɔɔi, ‑ɩn ‑kaa' ‑ma klai\" nynuu 'ʋn ke ʋʋ 'je wlu‑tɩ 'bɔ. ");
INSERT INTO wob_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","'Sʋ Sesi wlu' 'de ʋʋ o ɔ 'na : ‑Bo 'ma klai\" nynuu 'bɔ wlu‑tɩ mɔ 'de ɛ, \"soikpi a muɛ wlua'. ");
INSERT INTO wob_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","‑Ta ʋʋ \"kʋʋan Selisalɛm i, ‑wɛe Sesi ‑gbʋɛn \"kpei i 'sʋ ɔ ‑teɛ ‑fɩn\" 'a ‑pʋn\" 'de ɛɛ' ‑tɩ' 'ʋn 'de ɔ 'na : ");
INSERT INTO wob_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","Ɛmɛ Selisalɛm‑kwlɔ, dɩ ‑ɩ ‑tea ɛɛ' pɛe 'a blua 'a ‑tea', ‑bo ɛ 'wɔɩn 'mii‑ 'de 'wɩ ‑nɩ 'di 'de ɛ, ɛ \"paa', 'kaa kaan ka ɩa' dɩ tu pa 'kwla 'de ɛ \"jri 'de. ");
INSERT INTO wob_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","'Wɩ jrɩ' ‑ɩa mu nynia', 'de ɛɛ' tʋnyʋ 'je ɛ ‑sa, ‑wɛe ʋʋ 'je 'ɛ ‑gblo\" 'dei po ‑ta \"o ‑ta. ");
INSERT INTO wob_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Ʋʋa' muɛ ɛ ‑ke ɛɛ 'bleenyʋ i‑saa'. Ʋʋ se ɛɛ' ‑gbi\" a \"soukpo 'bo ɛ ‑posou\" \"kpei siei, dɛ‑nʋɛ' nɔ\" Kea ‑sa 'o, ‑wɛe ɛ jia ɛ \"i‑tea', ɛ se ɛɛ' nɔ\" tu \"jriɛ‑ o sie. ");
INSERT INTO wob_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","‑Wɛe Sesi pa 'e Kea ‑gbu klaa\" 'di, 'sʋ ɔ ‑teɛ nyʋ ‑ʋʋa poa 'dɔɔ 'demu 'a inʋa' ‑pʋn\". ");
INSERT INTO wob_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","'De ɔ wlu ka ɔ 'na : Dɛ ‑crɩɩa 'de Kea 'a 'sbɛ 'di ɛ, ɛ 'naa : 'Ma ‑gbu\" nɩɛ Kea bae‑gbu. 'Kaa aopʋ mɔ ɛ, ao nʋ ɛ \"jriʋn 'a \"jrui 'kɩɩn‑gbu 'ʋn. ");
INSERT INTO wob_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Ɛ 'wlʋa 'o mu ɛ, Sesi a tɔɔ nyʋ Kea 'a ‑tɩ' 'de Kea ‑gbu klaa\" 'di 'wɩ \"o 'wɩ. 'Kaa 'sraa ‑saʋn 'a klae\" o, kɛ' wɔ‑saʋn o, nyʋ \"jru kpɔ' i ‑teʋn ‑nɩa 'e nyʋ \"klu ke ʋʋa ‑pɔn Sesi 'a 'dba ‑kɔ i. ");
INSERT INTO wob_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","'Kaa ka ʋʋ 'jea nʋ 'ka se nɩ‑, dɛ‑nʋɛ' nyʋ ‑tuu\"‑tuu ‑a ‑jrɔ' ɔ ‑wɛe ‑ʋʋa ‑je ɔɔ' wlu doin\" o poa 'a \"dia. ");
INSERT INTO wob_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","'Wɩ jrɛ' o, ‑ta Sesi nɩa nyʋ dɛ tɔɔa' 'de Kea ‑gbu klaa\" 'di, ‑wɛe ɔɔ 'tmʋa ‑pɔia\" ‑tɩ 'de nyʋ ‑pee ɛ, 'bomɔ 'sraa ‑saʋn 'a klae\" o, kɛ' wɔ‑saʋn o, nyʋ‑cɔɩn' ‑wi\" jii‑, ");
INSERT INTO wob_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","‑ɩn ‑tmʋʋ' ‑aʋn, dɛ ‑ma \"ikmaa' ‑nɛ tba 'e \"jri ‑ta ‑gbo\" ɛ‑ ? 'De nyɔ ‑nyɩ\" ‑ʋn ɛɛ' \"ikmaa' tu ɛ‑ ? ");
INSERT INTO wob_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","'Sʋ Sesi wlu' 'de ʋʋ ‑pee ɔ 'na : 'Ma jiɛ aopʋ dɛ due' i ‑teea' ‑ke. ");
INSERT INTO wob_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Nyɔ ‑dbo' San nyʋ \"ni \"jru pooa a‑ ? Ɛ Kea ‑ae, ‑aee' nyiɔpʋ ‑oo ? Ao ‑sɛ \"kpei. ");
INSERT INTO wob_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","'Kaa ʋʋ ‑teɛ ɛɛ' 'mii dia' ‑pʋn\" 'bo ʋʋa' 'sʋ 'nynɩ ʋʋ 'na : ‑Bo ‑a ‑na Kea ‑dbo' ɔ ɛ, ‑mɛ ɔɔ muɛ nʋa' dɛɛ ‑tɩ ao se ɔɔ' wlu tɔ' 'ʋn 'je ɛ‑ ? ");
INSERT INTO wob_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","'De ‑bo ‑a ‑na nyiɔpʋ ‑dbo' ɔ ɛ, ‑mɛ nyʋ ‑wee' \"klein a muɛ ‑aʋn \"sei itbaa' 'de ʋʋ 'je ‑a ‑dba, dɛ‑nʋɛ' ʋʋ ‑wee' 'na : San nɩɛ Kea 'a weepoi ‑o. ");
INSERT INTO wob_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","'Sʋ ʋʋ wlu' 'de Sesi ‑pee ʋʋ 'na : Nyɔ ‑dboa' San nyʋ \"ni \"jru poo ‑a se ɔ juo‑. ");
INSERT INTO wob_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","'Sʋ Sesi 'na : ‑Ɛɛ, 'mɔ ‑ke ɛ, ‑ta 'ɩn ‑sa \"ikmaa' ‑wɛe 'ma nʋa dɩ ‑nɩ ɛ, 'ɩn se 'o 'a 'nynɩ \"sii‑ ‑ke 'de ao ‑pee. ");
INSERT INTO wob_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","'Bo ‑mɛ 'de ɛ, Sesi pooɛ ‑tɩ' \"i 'de ʋʋ ‑pee ɔ 'na : \"Ju due' mɔ ‑dba rɛsɛn ‑kle ‑wɛe ‑ɔ siɛ ‑busan dinyʋ o, 'de ‑ɔ mu 'dʋʋa' 'de 'blʋa‑ ‑tɔɔn \"kpei. ");
INSERT INTO wob_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","‑Ta rɛsɛn ‑sa nɔ\" nynia 'sʋ ɛ, ɔ dboɛ ɔɔ' dbonʋi due' 'de ‑busan dinyʋ o ‑wɛe ʋʋ 'je ɔɔ' ‑nɛ rɛsɛn jɔ 'o ‑sa, 'de ʋʋ 'je ɔ \"nyɩ. 'Kaa ‑busan dinyʋ kpʋn 'ɔ, ʋʋ blɔ', ‑wɛe ʋʋ po ɔ ‑jei\", ʋʋ se ɔ dɛ jrɛ' \"nyɩ. ");
INSERT INTO wob_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Ɔ dboɛ ɔɔ' dbonʋi jrɔ' ke'wlɛ, 'kaa ʋʋ bla ‑mɔ 'mɛ ‑ke. Ʋʋ ‑cree\" ɔ' ‑cree ‑cree\"‑, ‑wɛe ʋʋ po ɔɔ' foo\" ‑jei\". ");
INSERT INTO wob_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","‑Wɛe ɔ dbo ɔɔ' dbonʋʋn 'a kpɛ taan ‑nɔ ke'wlɛ, 'kaa ʋʋ bla ‑mɔ 'mɛ, ʋʋ je ɔ pooa‑, ‑wɛe ʋʋ nʋ ɔ i. ");
INSERT INTO wob_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","'Sʋ ‑kle' jei 'na : Ka 'ɩn 'je ‑jɛ ‑mɛ 'ɛ dɛ tu 'a sʋn nʋ 'ja a‑ ? 'Ma jiɛ 'ma ‑tɩ' kmaju dboa', ʋʋa muɛ ‑mɔ 'ɔ ni' ‑tea' dɛwɛ‑jɛ. ");
INSERT INTO wob_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","'Kaa ‑busan dinyʋ 'je ɔ i ɛ, ʋʋ pooɛ ‑tɩ' ʋʋ 'na : Ao ji, \"ju ‑kle' ‑nɛ 'jea 'kwa sie 'de nya, ɔ ka. ‑A ‑dbɔ', ‑wɛe ‑kle' ‑nɛ 'je ‑aa dɛ nɩ 'bode. ");
INSERT INTO wob_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","'Sʋ ʋʋ bluu ɔ \"kpei, ‑wɛe ʋʋ ‑sɔ 'o ‑kle' 'di 'de ʋʋ 'dbɔ. 'Sʋ Sesi ‑teeɛ' ʋʋpʋ i ɔ 'na : ‑Bo ‑kle' jei ‑nɔ ji 'ee, ka ɔ 'je ‑busan dinyʋ ‑nʋ 'a ‑tɩ' nʋ ɛ‑ ? ");
INSERT INTO wob_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Ɔɔ muɛ jia', ɔ 'je ʋʋpʋ 'dba, ‑wɛe ɔ 'je ɔɔ' ‑kle' nyʋ jrʋ' kwa ‑te'. ‑Ta ʋʋ 'wɔan wlu ‑nɛ, 'sʋ ʋʋ 'na : Kea 'bo ‑mɛ 'ɛ dɛ tu nʋʋɛ ! ");
INSERT INTO wob_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","'Kaa Sesi ‑gbʋɛn ʋʋpʋ ja ‑gbʋn ‑gbʋn, 'sʋ ɔ 'na : Wlu ‑crɩɩa' 'de Kea 'a 'sbɛ 'di ‑nɛ, ‑mɛ 'de 'deɛ‑ ? \"Soukpo ‑gbu\"poʋn pooa sʋn i ɛ, ɛmɛ ‑kpa ‑gbu\" po \"sou ‑cɛɛn'‑, ‑wɛe ‑ɛ ‑kɔ' ‑gbu\" \"i. ");
INSERT INTO wob_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Nyɔ \"o nyɔ ‑ka i 'bo ɛ \"jri ɛ, ɔɔ muɛ i ‑craa', 'de ‑bo ɛ blu 'bo nyɔ \"kpei ɛ, ɔɔ muɛ iwaa' see. ");
INSERT INTO wob_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Kɛ' wɔ‑saʋn o, 'sraa ‑saʋn 'a klae\" 'wɔan wlu ‑nɛ 'sʋ ɛ, ʋʋa ‑pɔn ʋʋ 'je 'o \"si ʋʋ 'je Sesi kpʋn, dɛ‑nʋɛ' ʋʋ 'je kan' 'mɛ ka Sesi pooa ‑tɩ' ‑nɛ \"i 'de ʋʋpʋ 'a ‑tɩ' 'ʋn ɛ. 'Kaa nyʋ 'a faʋn a nʋ ʋʋpʋ 'mɛ. ");
INSERT INTO wob_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","'Sʋ ʋʋ ‑teɛ Sesi 'a \"jriɛ‑ o sia' ‑pʋn\", ‑wɛe ʋʋ dbo nyʋ jrʋ' ʋʋ 'pɛn 'srɛi\" ‑wɛe ‑ʋʋ ‑je Sesi kpʋn 'bo ɔɔ' ‑cɛ\" 'ɛ wlu \"kpei. Ʋʋ nɩɛ \"i ʋʋ 'je ɔ 'de ‑kwlɔʋnjeʋn ‑wi\" \"juɔi ja‑. ");
INSERT INTO wob_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","‑Wɛe ʋʋpʋ ‑tee' ɔ i ka ʋʋ 'na : Nyʋ dɛtɔɔi, ‑a ‑je kan' 'mɛ dɛ ‑ma ‑tmʋa ke dɛ ‑ma tɔɔa nyʋ ɩ 'srɛi\", nyɔ jrɔ' 'ɔ faʋn 'a nʋ ‑ʋn, 'kaa ‑ma tɔɔ nyʋ Kea 'a ‑je 'de tɔ' ‑tɩ 'ʋn. ");
INSERT INTO wob_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Ɛmɛ ‑tɩ ‑a ‑nɩi\" ‑a ‑je ‑ʋn dɛ jrɛ' i ‑tee'‑. ‑A ‑bɛɛ' 'mɛɛ ‑a ‑je 'wɛi ‑sa ‑a ‑je Sesaa \"nyɩ ? ‑A ‑sɩ ‑aee ‑ɩn\" ‑a ‑bo ɩ ‑saa' ? ");
INSERT INTO wob_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Ka ʋʋa pooa Sesi 'srɛ i ɛ, ɔ 'je kan' 'mɛ, 'sʋ ɔ 'na : Ao to 'ʋn 'wɛijɔ due' \"i kea', 'ɩn 'je ɛ 'je. ");
INSERT INTO wob_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","Nyɔ ‑ɔɔ 'nynɩ ke ‑ɔɔ \"jrukpa\" nɩ 'bo ɛ \"kpei ɛ‑ ? Ʋʋ 'na : Sesaa ‑o. ");
INSERT INTO wob_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","'Sʋ Sesi 'na : Dɛ ‑nɩa Sesaa 'a dɛ, ao \"nyɩ ɛ Sesaa, ‑wɛe dɛ ‑nɩa Kea 'a dɛ, ao 'je ɛ Kea \"nyɩ. ");
INSERT INTO wob_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","'Sʋ dɛ ʋʋ 'jea 'je 'de ɔɔ' wlu 'di, ‑wɛe ʋʋ 'je ɔ \"kpei kpʋʋn ɛ se nɩ‑. Tai' \"maa ʋʋpʋ 'mɛ, 'sʋ ʋʋ \"muɛ wɔn. ");
INSERT INTO wob_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Ɛ 'wlʋa 'o ‑mɔ ɛ, Sadiseɛn‑wi\" ‑na \"kunyɩɔ' sɔan' se nɩ ɛ ʋʋa' jrʋ' jiɛ Sesi i ‑teea'. ");
INSERT INTO wob_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","Ʋʋ 'na : Nyʋ dɛtɔɔi, dɛ Moisɩ 'a kɛ' 'crɩa 'de ‑aa ‑tɩ' 'ʋn ɛ, ɛ ka : ‑Bo ‑ma de'dinmɔu 'ble 'nynɔ ‑wɛe ɔ ke ʋ se \"ju 'wlʋ 'de ɔ 'je 'mɛ, ‑mɛ ɔɔ' \"dei \"duo 'nynɔ ‑nʋ 'ʋn, 'de ɔ ke ʋ 'je \"nynuu‑ 'wlʋ 'de ɔɔ' ‑fɛin' ‑mɛa 'a 'nynɩ 'ʋn. ");
INSERT INTO wob_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","'Kaa de'dinmai ‑mɛ\" 'sɔn ‑nɩ 'emu, ʋʋa' ‑jɔ ‑saa \"i 'bleɛ 'nynɔ, ɔ ke ʋ se \"ju 'wlʋ 'sʋ ɔ 'mɛɛ. ");
INSERT INTO wob_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","'Kamɔ ʋʋa' 'sɔɔn ‑nɔ nʋ ‑ke. 'Sʋ ʋʋa' taan ‑nɔ \"duo ‑tiɔn\" 'nynɔ ‑nʋ 'ʋn 'ɛ, ");
INSERT INTO wob_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","'kamɔ ɛ nʋ 'de nyʋ ‑mɛ\" 'sɔn ‑nʋ 'a ‑tɩ' 'ʋn. Ʋʋ ke ʋ se \"ju 'wlʋ mamaʋ 'sʋ ʋʋ ‑wee' je 'mɛ. ");
INSERT INTO wob_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","'De ɛɛ' \"jru 'a \"ti 'ɩn 'sʋ ɛ, 'nynɔkpao' ‑nʋ 'mɛɛ ‑ke. ");
INSERT INTO wob_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","\"Kunyɩɔ' sɔnwɩ o 'ee, nyɔ wɛ‑ 'nynɔkpao' ‑nʋ 'je \"bli \"ti ‑gblein' ɛ‑ ? Dɛ‑nʋɛ' ʋ jiiɛ \"nynunmai ‑nɩa ‑mɛ\" 'sɔn ‑nʋ ‑wee' 'kwai. ");
INSERT INTO wob_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","'Sʋ Sesi 'na : \"Nynunmai ‑nɩa 'nɔ 'blʋa‑ \"kpei ɛ, ʋʋa 'bleɛ 'nynɔ, ‑wɛe 'nynʋkpae' ‑nɩa 'nɔ 'blʋa‑ \"kpei ɛ, ʋʋa \"ti jra. ");
INSERT INTO wob_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","'Kaa nyʋ ‑ʋʋa mua \"kunyiɔ' sɔn ka nɩa' de'bɔɔ‑ nɔ\", 'de ‑ʋʋ ‑jea 'kmʋnɩa' ‑sea' ‑kwɛ ‑ta 'ble 'je 'de jaʋn 'di ɛ, ʋʋ se 'nynʋkpae' 'blei, 'de 'nynʋkpae' se jra \"tii. ");
INSERT INTO wob_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","'De ke'wlɛ ɛ, ʋʋ se 'mɛi 'bode, ka Kea 'a \"soa‑wi\" nɩa, 'kamɔ ʋʋa mu nɩa', ‑wɛe ʋʋ 'je Kea 'a \"nynuu‑ nɩ‑, ʋʋ ‑teɛ \"kunyɩɔ' sɔan 'a ‑tea'. ");
INSERT INTO wob_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","\"Kunyɩɔ' sɔan 'a ‑tɩ' mɛ Moisɩ 'tmʋ 'de ɔɔ' 'sbɛ 'di tɛin\". ‑Ta ‑gbauo'‑ a waan nɛ i ‑wɛe ɔ 'jee ɛ \"jriɛ‑, 'bomɔ ɔɔ 'daa‑ Kea Ablaam ke Isaakɩ ke Sakɔbʋ 'a Kea. ");
INSERT INTO wob_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","'De Kea se 'mɛʋn 'a Kea nɩ‑, ɛ nɩɛ 'kmʋnɩʋn 'a Kea ‑o, dɛ‑nʋɛ' nyʋ \"klein ‑ʋʋa ‑mɛa ʋʋ nɩɛ 'kmʋ 'bo ɛ \"juɔi. ");
INSERT INTO wob_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","'Sʋ kɛ' wɔ‑saʋn jrʋ' wlu' ka ʋʋ 'na : Nyʋ dɛtɔɔi, ka nyɔ ɔ 'tmʋa ‑tɩ', 'kamɔ ‑nao. ");
INSERT INTO wob_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","'Bo ‑mɛ 'de ɛ, nyɔ jrɔ' se ɔɔ' dɛ i ‑teea' 'bɛɛ‑ la 'bode. ");
INSERT INTO wob_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","‑Wɛe Sesi wlu 'de ʋʋ ‑pee ɔ 'na : Ka nyʋ 'bɛɛ‑ ɔ 'je Nyʋ 'pʋʋi Kea ‑tea' 'o Dafidɩ 'a \"ju 'daa‑ ? ");
INSERT INTO wob_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","'De Dafidɩ 'a ‑cɛ\" 'kpa 'a 'sbɛ 'di ɛ, ɔ wlu' ka ɔ 'na : Kea ‑nɩa Tʋ\"bo ɛ, ɛ wlu' 'de 'ma Tʋ\"bo ‑pee ɛ 'na : ‑Ɩn ‑te i 'de 'ma dianfɔ o mamaʋ ");
INSERT INTO wob_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","'sʋ, 'ɩn 'je ‑ma tʋnyʋ ‑ma bʋ ‑sɔn ku 'ʋn nʋ. ");
INSERT INTO wob_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","‑Bo Dafidɩ ‑mɔ 'dɔɔ Tʋ\"bo 'ee, ‑mɛ ka ɔ nɩ Dafidɩ 'a \"ju nɩsʋn 'ja a‑ ? ");
INSERT INTO wob_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","‑Ta nyʋ ‑wee' \"klein nɩɩa ɔɔ' wlu doin\" o poa' a, 'bomɔ ɔ wluu 'de ɔɔ' klai\" nynuu ‑pee ɔ 'na : ");
INSERT INTO wob_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","Ao ‑tu\" aoa' ‑cɛ\" 'ɛ ‑tɩ', 'de kɛ' wɔ‑saʋn 'a ‑tɩ' 'ʋn. Ʋʋ paa \"bai ‑tɔɔn' ‑tɔɔn 'ʋn, ‑wɛe ʋʋ nɩ ɛ \"i 'de nyʋ 'je ʋʋpʋ 'jewlu o po ‑ta ‑wee', ɛmɛ ‑ɛɛ ‑teɩn 'dɔe 'dɔe ʋʋa ‑pɔn \"kpei ‑tea' i 'de Kea ‑gbi 'dii ke ‑kɔ' ‑sɔn i ke‑. ");
INSERT INTO wob_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Ʋʋa ‑sa' ‑tiɔn\" nynʋkpae' dɩ 'kwai ‑gbi\" 'dii, 'de ‑bo ʋʋa sea Kea bae ɛ, ʋʋa po baewlu ‑tɔɔn' ‑tɔɔn 'bo nyʋ \"juɔi, ‑wɛe nyʋ 'je ʋʋpʋ dɛ 'dɔenʋʋn 'daa‑. Ɛmɛ ‑tɩ ʋʋa' ‑nɛ 'pee a mu \"ikmaa'. ");
INSERT INTO wob_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Sesi kpa \"jri \"jɛi, ‑wɛe ɔɔ ‑gbʋʋn' nyʋ \"kpei‑ 'de Kea ‑gbu klaa\" 'di 'sʋ, ɔ 'jeɛ \"wliiɛjeʋn, ‑ʋʋa nʋ Kea ‑paan' \"jrii 'de ‑ʋʋa po 'wɛi 'de 'wɛi 'dipodɛ 'di. ");
INSERT INTO wob_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","'Bomɔ ɔ 'jee ‑tiɔn\" 'nynɔ due' \"jriɛ‑ ‑ke, ‑ʋ po 'e ʋa' nɩɩa\" wɛi' jɔ \"mɩɩ 'sɔɔn, ");
INSERT INTO wob_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","'sʋ ɔ 'na : 'Ma 'tmʋʋ aopʋ tɔ' ‑tɩ, ‑tiɔn\" 'nynɔ nɩɩa\" a 'dba ‑ta a, ʋmʋ ‑po' 'de dɛ ‑tuu\", ‑ɛ ‑sii \"wliiɛjeʋn, ");
INSERT INTO wob_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","dɛ‑nʋɛ' 'wɛi ‑ɩ ‑sia ʋʋpʋ i ɛ, ɩmɩ ʋʋa nʋʋ ‑paan' 'ʋn. 'Kaa ʋmʋ ɛ, ʋa' nɩɩa\" wɛi' jɔ‑ ʋ ‑tea' ‑kwlɩ\" ɛ, ɛmɛ ‑wee' ʋ po 'demu. ");
INSERT INTO wob_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","\"Soi 'dɔe ke ‑paan' dɩ ‑ɩ ‑nɩa Kea ‑gbu klaa\" 'a ‑pɛe ɛ, ‑ta nyʋ jrʋ' nɩa ɩa' \"wɔin 'tmʋa a 'bomɔ Sesi wluu ka ɔ 'na : ");
INSERT INTO wob_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","'Wɩ jrɩ' ‑a mu nynia', ‑wɛe dɩ \"klein aoa 'jea i ‑ta, ɩa mu blua' 'de ɩa' \"soukpo se 'bo ɛ ‑posou\" \"kpei siei. ");
INSERT INTO wob_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","'Sʋ ʋʋ ‑tee' ɔ i ka ʋʋ 'na : Nyʋ dɛtɔɔi, nɔ\" wɛ‑ 'di ɩa' dɩ tu ɩ 'je nʋʋ ɛ‑ ? 'De ‑bo ɩa' dɩ tu 'a nɔ\" ɔ se 'o nyni 'ee, ka ‑a ‑je ɛɛ' juosʋn nʋ ɛ‑ ? ");
INSERT INTO wob_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","'Sʋ Sesi 'na : Ao ‑tu\" aoa' ‑cɛ\" 'ɛ ‑tɩ', ‑wɛe nyʋ je aopʋ‑ 'srɛ ipoo‑. Nyʋ ‑tuu\"‑tuu ‑a mu 'ma 'nynɩ \"jru ‑tea' 'sʋ ‑ʋʋ ‑je ji ‑wɛe ‑ʋʋ ‑je wlu ka 'mɔ ‑nɩ Klisi, 'ma nɔ\" nyni', ao 'bo 'o ʋʋpʋ 'de blaa. ");
INSERT INTO wob_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Aoa muɛ tʋ ke ‑kli 'a 'kpa ‑cruɛn\" 'wɔan' ‑ta \"o ‑ta, ‑mɛ dɛ 'bo ao 'di iwaa, dɛ‑nʋɛ' ɩa' dɩ tu 'je nʋʋɛ ‑o \"i‑saa' nɔ\", 'kaa ‑mɛ se 'blʋa 'a ‑kwɛ‑ nɔ\" nɩ ke. ");
INSERT INTO wob_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","‑Wɛe ɔ wlu ʋʋ ‑pee ke'wlɛ ɔ 'na : nyʋ 'a kpɛ jrʋ' a muɛ ʋʋ ‑ponyiɔ o ‑fɔan' 'blʋa 'a blo' wɔn jrɛ' ɛ muɛ ɛ ‑poblʋa o ‑fɔan'. ");
INSERT INTO wob_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","'Blʋa‑ a muɛ crɛa' ‑ta \"o ‑ta, 'mɩɩɛ‑ ɛ muɛ jia', 'wɛ‑ ɛ muɛ isia', \"ikmadɩ a muɛ nʋa' 'de ɛɛ' nɔ\" tu 'di, ‑wɛe \"jriɛ o siedɩ klae\" klae\" 'je nʋʋɛ 'de jaʋn 'di. ");
INSERT INTO wob_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","'Kaa nɔ\" ‑tɩ ‑mɩ 'a dɩ tu 'je 'o nyni ɛ, ʋʋa muɛ aopʋ sʋn ‑pʋn\" kpaa', ‑wɛe ʋʋ 'je aopʋ 'kle ‑tu\". Ʋʋa muɛ aopʋ kea ‑gbi 'di kpaa', ‑wɛe ʋʋ 'je aoa' 'pee 'je. Ʋʋa muɛ aopʋ ‑kaso 'di poa', ʋʋa muɛ aopʋ \"kuan pooa' 'de 'beɔ‑wi\" ke 'blʋajeʋn \"juɔi 'de 'ma 'nyɩ 'ʋn. ");
INSERT INTO wob_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Ɩa' dɩ tu a muɛ ao \"jri i nʋʋa' ‑wɛe ɩ 'je ao 'ma ‑tɩ' 'tmʋa' ‑je wɔn kain‑. ");
INSERT INTO wob_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Ao ‑tu\" aoa' ‑cɛ\" 'ɛ ‑tɩ', ao kuu 'dii. Dɛ ao 'jea 'e \"jru 'di 'blee ɛ, ɛmɛ ‑nɩ Ka ao 'jea aoa' ‑cɛ\" 'ɛ o 'wlʋsʋn nʋ ɛ, ao 'bo ɛɛ' tɔ' i naa, ");
INSERT INTO wob_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","dɛ‑nʋɛ' 'ma ‑cɛ\" 'kpa ‑a mu aopʋ tɔ' ‑kwlɩ\" poa', 'ma muɛ ao wlu 'wɔn poa' ‑wɛe ao 'je ɛ 'tmʋ 'de aoa' tʋnyʋ se ao 'wɔn \"i 'bɛɛi. ");
INSERT INTO wob_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Ao \"bo ‑wi\" o, aoa' de'di ‑wi\" o, aoa' 'wlʋʋaʋn o, aoa' \"dɛi ‑wi\" a muɛ ao wɔn \"kpei cɛan' ʋʋ 'je nyʋ ‑tuu\"‑tuu 'dba 'de aopʋ \"klu. ");
INSERT INTO wob_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Nyʋ ‑wee' a muɛ aopʋ 'ʋn 'nyɛa' 'de 'ma 'nynɩ 'a ‑tɩ' 'ʋn. ");
INSERT INTO wob_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","'Kaa aoa' \"mɩɩjɔ due' koʋn ‑gbai ka se \"mai 'bo aopʋ \"jru. ");
INSERT INTO wob_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Ao kpʋn 'e nai\" 'blea' \"jri ‑wɛe ao 'je 'kmʋnɩa' ‑cɛɛn' 'je. ");
INSERT INTO wob_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","‑Bo ao 'jee‑ aoa' tʋ o ‑fɔʋn \"jriɛ‑, ‑wɛe ʋʋ 'je 'e Selisalɛm‑kwlɔ 'e po ɛ, ‑mɛ ao siɛ ‑kwlʋ o ka ɛɛ' ja ‑gba' nɔ\" nynia. ");
INSERT INTO wob_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","‑Mɛ nyʋ ‑nɩa 'de Suide ple, ʋʋ 'je crʋɩ \"kpei‑ mu. Nyʋ ‑ʋʋa mua 'o Selisalɛm nɩa' a, ʋʋ ‑too\"‑ ʋʋ 'je ɛ o tɛɛn‑. 'De nyʋ ‑ʋʋa mua ‑gbei\" woi nɩa' a, ʋʋ 'bo ‑kwlɔ de muɛ, ");
INSERT INTO wob_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","dɛ‑nʋɛ' ɩa' 'wɩ tu a muɛ Kea 'a 'pee 'jewɩ nɩa', ɛmɛ ‑nɩ dɩ \"klein ‑crɩɩa' 'de Kea sbɛ 'di 'a 'o nyni wɩ‑. ");
INSERT INTO wob_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","'De ɩa' 'wɩ tu 'di ɛ, ɛɛ muɛ \"nmia ‑tɩ nɩa' 'de \"kwlinynʋkpae' ke ‑gbaan ʋn 'a ‑tɩ' 'ʋn, dɛ‑nʋɛ' 'kle klaa\" a muɛ nyʋ ‑wee' \"kpei jia' 'de Suifʋ 'a 'blʋa‑ 'di ‑wɛe Kea 'a 'cɛn 'je \"kpae' 'pɛɛn‑ 'de Israɛ‑nyʋ \"kpei. ");
INSERT INTO wob_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Ʋʋa muɛ aoa' jrʋ' ‑cnɛ \"i 'dbaa', ʋʋa muɛ jrʋ' kʋɔn 'ʋn kpʋan', ‑wɛe ʋʋ 'je ʋʋpʋ 'blʋa 'a 'fɔ ‑wee' \"klein \"kpei‑ kpa. Nyʋ 'srʋ a muɛ Selisalɛm ‑kwlɔ bʋ ‑sɔn i sʋʋan' mamaʋ 'sʋ ʋʋa' ‑nɛ nɔ\" ‑tu\" a ɛ 'je 'o ‑kwɛ. ");
INSERT INTO wob_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","'De ɛɛ' nɔ\" tu 'di ɛ, dɩ klae\" ‑ɩa mua nʋʋa' 'de 'jrʋ o, 'cʋ o, 'cʋ‑sɩɩn 'a ‑tɩ' 'ʋn ɛ, ɩa muɛ nyʋ tai' \"maa'. Nyʋ ‑wee' \"klein a muɛ 'e faʋn 'ʋn nɩa' 'de 'tɔniɛ 'a ‑cruɛn\" 'ɛ ‑tɩ' 'ʋn. ");
INSERT INTO wob_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Faʋn 'a 'sʋ a muɛ nyiɔ 'dbaa' 'de dɩ ‑ɩa mua nʋʋa' 'de 'kmʋ \"kpei 'a ‑tɩ' 'ʋn, dɛ‑nʋɛ' \"ikmadɩ ‑nɩa 'e jaʋn 'di ɛ, ɩ ‑wee' \"klein a muɛ i ‑suua'. ");
INSERT INTO wob_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","‑Wɛe nyʋ 'je nyiɔ 'ɔ \"Ju \"jriɛ‑ 'jee‑, 'de ɔ 'e ji 'bo bue\" \"kpei, ɔ ke ɔɔ' tʋ\"bodɛ ke \"ikmaa' ke‑. ");
INSERT INTO wob_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","‑Bo ɩa' dɩ tu a sea jia' ‑tee ɛ, ‑mɛ ao \"duo 'kpɩ 'ʋn, ao kpa \"jru \"jɛi, dɛ‑nʋɛ' aoa' seie nɔ\" \"kʋʋan‑ i. ");
INSERT INTO wob_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","'Bo ‑mɛ 'de 'sʋ ɛ, Sesi pooɛ ‑tɩ' \"i ka 'de ʋʋ ‑pee ɔ 'na : Ao sie fikɩtu ke ti jrɩ' \"jriɛ‑ o kea' ! ");
INSERT INTO wob_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","‑Bo aoa sea ɩ 'je ‑wɛe ɩa sea wɩn dee tbaa' ‑tee 'sʋ ka ‑kua\" a \"kʋʋan i ɛ, ao 'je kan' 'mɛ. ");
INSERT INTO wob_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","'Kamɔ ɛɛ mu nɩa' ‑ke 'de nyiɔ 'ɔ \"ju 'a deji nɔ\" 'ʋn ‑tɩ' 'ʋn, ‑bo aoa sea dɩ ‑nɩ 'je ‑wɛe ɩa sea 'o nyni ɛ, ‑mɛ ao poɛ ‑kwlʋ o ka Kea 'a 'beɔdɛ 'ɛ \"jri \"kpaepo nɔ\" ɔ \"kʋʋan‑ i ɛ. ");
INSERT INTO wob_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","'Ma 'tmʋʋ aopʋ tɔ' ‑tɩ : Nyʋ ‑nɩa 'kmʋ 'de ‑sɩanwɩ ‑nɩ 'di ɛ, ʋʋ ‑wee' \"klein se 'mɛi, dɩ ‑nɩa 'mʋa‑ ɩ ‑wee' a jea 'o nyni. ");
INSERT INTO wob_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","'Blʋa ke jaʋn a muɛ i sɔan', 'kaa 'ma wlu se isɔin 'nɔ 'kmʋ. ");
INSERT INTO wob_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","'De ɔ 'na : Ao ‑tu\" aoa' ‑cɛ\" 'ɛ ‑tɩ', ao 'bo aoa' ‑cɛi\" \"taiɛ, ‑wɛe dɛ dia' ke nmɔ 'naa' ke 'kmʋ 'a dɩ ke 'wɛi 'a 'tʋn 'bo aopʋ kʋɔn 'ʋn 'bleɛ, 'de ɩa' 'wɩ tu je aopʋ \"jru ‑tiie'‑, ");
INSERT INTO wob_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","dɛ‑nʋɛ' ka nyɔ ɔ poa 'sai 'de ɛɛ \"fiian 'blʋa 'dinyʋ ‑wee' \"jru i ɛ 'kamɔ ɛɛ mu nɩa'. ");
INSERT INTO wob_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Ao 'bo 'mʋɛ, ao bae Kea jeejee, ‑wɛe ao 'je 'kpɩ 'ble 'de ao 'je dɩ ‑ɩa mua jia' 'mʋa‑ wɔin\" 'pʋ, ‑wɛe aoa' dɩ je crɛ 'de nyiɔ 'ɔ \"Ju \"juɔi. ");
INSERT INTO wob_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Ka ‑sɔn' ɔ ‑sɩan', 'kamɔ Sesi a tɔɔ nyʋ dɛ 'de Kea ‑gbu klaa\" 'di, ‑wɛe ‑bo kwie kpʋn ɛ, 'de ɔɔ mu \"maʋ'wɩ ‑wee' nʋa' 'de olifɩ‑crʋ \"kpei. ");
INSERT INTO wob_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","‑Wɛe ‑bo ‑klae\" pɛɛn \"o ‑klae\" pɛɛn ɛ, nyiɔpʋ a ji ɔɔ' wlu doin\" o poa' 'de Kea ‑gbu klaa\" 'di. ");
INSERT INTO wob_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Kʋɔnkwla' 'wlʋ ‑kɔ' ‑ɛɛ 'nynɩ nɩa pakɩ, ‑ɛ \"kpei ʋʋa diia ‑di'pɛn ‑sea' ‑puun\" dɛ o mu a \"kʋʋan i. ");
INSERT INTO wob_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","'Sʋ 'Sraa ‑saʋn 'a klae\" o, kɛ' wɔ‑saʋn a ‑pɔn Sesi 'a 'dba ‑kɔ i, 'kaa ka ʋʋ 'jea ɛɛ' sʋn nʋ ɛ, 'ka se nɩ, dɛ‑nʋɛ' ʋʋa plee nyʋ 'a \"jriɛ‑ 'mɛ. ");
INSERT INTO wob_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","'Sʋ ‑siɔn' paa 'e Suida ‑ɔɔ \"kpei ‑tenynɩ nɩa Isikario 'ʋn 'ɛ ɔ nɩɛ klai\" nynuu ‑nɩa ‑puue 'jɔ 'sɔɔn 'ɔ due' ‑o. ");
INSERT INTO wob_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Ɔmɔ ‑pooa a Sesi 'a dboʋn ‑puue 'jɔ 'sɔɔn 'de ɛ, ɔmɔ ‑mu' 'de ‑ɔ ‑ke 'sraa ‑saʋn 'a klae\" ke Kea ‑gbu i fuoʋn 'a \"jru o jɔ‑ 'je Sesi 'a 'de tosʋn 'a wlu 'ʋn 'bɛɛ‑. ");
INSERT INTO wob_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","'Sʋ ʋʋa nʋɛ 'mʋa‑, 'bomɔ 'wɛi ʋʋ 'jea Suida \"nyɩ ɛ, ʋʋ 'bɛɛ‑ ɩa' wlu 'ʋn ‑ke. ");
INSERT INTO wob_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Suida 'wɔɔn‑ 'wɛi \"nyɩ‑tɩ 'mɛ. Dɛ ‑tba' 'o mu ɛ, ka ɔ 'jea nʋ ‑wɛe ɔ 'jea Sesi 'e to 'de nyʋ ti \"i wɔɔ‑, ɛmɛ ɔɔ ‑pɔn i. ");
INSERT INTO wob_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","‑Di'pɛn ‑sea' ‑puun\" dɛ o mu 'a ‑kɔ' 'ɔ 'wɩ ‑ɛ 'di ʋʋa 'dbaa pakɩ 'a 'sraadɛ nyni'. 'De ɛɛ' 'wɩ tu 'di mɛ Suifʋ‑wi\" 'je 'blae ‑tɔo 'dba, ‑wɛe ʋʋ 'je Pakɩ 'a diidɛ pi. ");
INSERT INTO wob_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","'Sʋ Sesi dboɛ Piɛi ke San ɔ 'na : Ao mu ‑wɛe ao 'je ‑aa Pakɩ 'a diidɛ pi ‑a ‑je di. ");
INSERT INTO wob_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","‑Wɛe ʋʋpʋ ‑tee' ɔ i ʋʋ 'na : ‑Ta wɛ‑ ‑ɩn ‑nɩ \"i ‑a ‑je ɛ pii ɛ‑ ? ");
INSERT INTO wob_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","'Sʋ ɔ 'na : Ao po doin\" i, ‑bo aoa sea ‑kwlɔ i \"si ɛ, aoa muɛ \"ju due' jɛɛa', ɔ 'je \"nidɛ 'ble, ‑mɛ ao bla 'bo ɔ 'de, ‑wɛe ‑gbu\" ‑ɛ 'di ɔɔ mua paa' a, 'de ao ke ɔ 'je 'e pa ‑ke. ");
INSERT INTO wob_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","‑Wɛe ao 'je wlu ka 'de ‑gbu\" jei ‑pee : ‑Aa 'blei 'naa ‑ta ka ɔ ke ɔɔ' klai\" nynuu 'je Pakɩ 'a diidɛ dii ɛ‑ ? ");
INSERT INTO wob_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","‑Bo ao 'da kan' a, ɔɔ mu ao ‑gbu\" 'a \"jɛi wɔn klaa\" due' tɔɔa' ‑ɛ 'di \"kpei ‑tedɩ ke dɩ ‑wee' \"klein 'je kpɔi\" ‑tee ao 'je jɛɛ‑. 'bomɔ ao 'je Pakɩ 'a diidɛ pii‑. ");
INSERT INTO wob_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Ʋʋ mua, ka Sesi \"sia dɩ 'a 'nynɩ ɛ, 'kamɔ ʋʋ jɛɛ ɩ, ‑wɛe ʋʋ pi Pakɩ 'a diidɛ. ");
INSERT INTO wob_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","‑Ta dɛdi nɔ\" nynia 'sʋ ɛ, Sesi ke ɔɔ' dboʋn ‑teɛ dɛ dia' ‑pʋn\". ");
INSERT INTO wob_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","'Sʋ ɔ wlu' 'de ʋʋ ‑pee ɔ 'na : 'Ɩn nɩɛ \"i sese ao ke 'ɩn 'je Pakɩ 'a diidɛ ‑nɛ di ‑tadue ‑wɛe 'ɩn 'je 'ma ‑cɛ\" wɔn 'jea' mu, ");
INSERT INTO wob_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","dɛ‑nʋɛ' 'ma 'tmʋʋ aopʋ 'mɛ, 'ɩn se ɛ dii la 'bode mamaʋ 'sʋ ɛ 'je ɛɛ' ‑cɛɛn' ‑nɛ 'ɛ \"i ‑kwɛa' jɛɛ‑ 'de Kea 'a kɛɛma' ‑kwlɔ 'di. ");
INSERT INTO wob_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","'Sʋ Sesi \"duɛ nmɔ ‑saan ‑dɛ 'ʋn, ‑wɛe ɔ po ɛɛ' Kea 'sɛ‑, 'de ɔ 'na : Ao \"duɛ 'ʋn ‑wɛe ao 'je ɛ \"wɔin ‑seea', ");
INSERT INTO wob_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","dɛ‑nʋɛ' 'ma 'tmʋʋɛ aopʋ tɔ' ‑tɩ, dɛ ‑wlʋa ‑ta ‑ɛ mua nya 'ɩn se rɛsɛn 'jɔ 'ɔ nmɔ 'nai mamaʋ 'sʋ, Kea 'a tʋ\"bodɛ 'je \"jri \"kpae po. ");
INSERT INTO wob_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","‑Wɛe ɔ \"duo ‑di'pɛn 'ʋn, ɔ poɛ ɛɛ' Kea 'sɛ‑, ɔ cɛɛn ɛ i ɔ \"nyɩ ɛ ʋʋpʋ 'de ɔ 'na : ‑Di'pɛn ‑nɛ, ɛ nɩɛ 'ma ku 'ɩn toa 'de aoa' ‑tɩ' 'ʋn ‑o. Ao nʋ ɛɛ' dɛ tu jeejee 'de ao 'je 'ma ‑tɩ' ‑kwlʋ o po. ");
INSERT INTO wob_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Ʋʋ ‑kɔa' ‑di'pɛn ‑nɛ dia' 'sʋ ɔ \"duo nmɔ ‑saan 'a dɛ 'ʋn ɛ ‑ke 'de ɔ 'na : Nmɔ ‑nɛ ɛ nɩɛ 'ma nymɔ ‑ɛ ‑wla i 'de aoa' ‑tɩ' 'ʋn ‑o, ɛmɛ ‑po' dbɛɛ dɛ dee 'de ao ‑ke Kea 'nynɩ. ");
INSERT INTO wob_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Ao ‑gbʋn 'nɔ \"ju ‑ɔɔ mua 'ʋn 'e toa' 'a, ɔ ke 'ma ‑a ‑nɩɛ sʋn ‑tadue poa' ‑ta. ");
INSERT INTO wob_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Tɔ' ‑o, nyiɔ 'ɔ \"ju a jiɛ 'mɛa' la, ka Kea cɛan ɛɛ' wlu ‑tie\" see ɛ, 'kaa ɛ nɩɛ \"nmia‑tɩ ‑o 'de \"ju ‑ɔɔ mua ɔɔ' plei nɩa 'a ‑tɩ' 'ʋn. ");
INSERT INTO wob_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Ʋʋ 'wɔan wlu ‑nɛ 'sʋ, ʋʋ ‑teɛ ba i ‑teea' ‑pʋn\" due 'due ʋʋ 'na : Nyɔ wɛ‑ ‑bɛɛ' ‑mɛ 'ɛ nʋa' 'de ‑a \"klu ‑ta a‑ ? ");
INSERT INTO wob_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Ɛ 'wlʋa 'o mu ɛ, dboʋn 'a 'sʋ ‑teɛ ba o ‑toa' ‑pʋn\" 'bo ʋʋpʋ 'a 'sʋ 'nynɩ, ‑wɛe nyɔ ‑nɩa ʋʋa' klaa\" 'de ʋʋpʋ \"klu ɛ, ʋʋ 'je ɔ juo‑. ");
INSERT INTO wob_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","'Sʋ Sesi wluɛ ʋʋ ‑pee ɔ 'na : 'Beɔ‑wi\" ‑tea nyʋ \"jru kpɔ' i 'nɔ 'blʋa‑ \"kpei ɛ, ʋʋ ‑siiɛ nyʋ ʋʋ 'blea wɔn, ‑wɛe nyʋ ʋʋ ‑sia wɔn ‑nʋ, ‑wi\" ‑mʋ ʋʋa 'daa‑ ʋʋpʋ ʋʋa' dɛ 'dɔe \"jrii nʋʋn. ");
INSERT INTO wob_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","'Kaa aomɔ 'bo kan' nʋɛ, nyɔ ‑nɩa klaa\" 'de aopʋ \"klu ɛ, ɔ nʋ ɔɔ' ‑cɛ\" \"ju ‑saan\" 'ʋn, ‑wɛe nyʋ 'blei 'je ɔɔ' ‑cɛ\" nyʋ \"juɔinʋʋi 'ʋn nʋ. ");
INSERT INTO wob_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","'De nyiɔpʋ \"klu ɛ, nyɔ wɛ‑ ‑nɩ klaa\" a‑, ‑jɔɔ diia 'tablʋ \"kpei ‑ae, ‑aee' ‑jɔɔ nʋʋa nyʋ \"juɔi ɛ‑ ? Ɛ se ‑jɔɔ diia 'tablʋ \"kpei nɩɩ‑ ? 'De ‑mɛ 'kamɔ 'ɩn nɩ 'de aopʋ \"klu ‑ta ka nyʋ \"juɔinʋʋi nɩa. ");
INSERT INTO wob_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Aopʋ mɔ ɛ, 'kle 'ɩn 'jea ɛmɛ ao 'je ‑ke 'de nai\" 'blea' 'ʋn. ");
INSERT INTO wob_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Ɛmɛ ‑tɩ 'ɩn ‑tee aopʋ‑ 'beɔdɛ 'dei ka 'ɩn \"Bo ‑tee ɛ 'ʋn 'dei ‑ke ɛ, ");
INSERT INTO wob_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","'de ao ke 'ma ‑a ‑je ‑tadue dii, ‑a ‑je ‑tadue 'naa 'de 'ma kɛɛma' ‑kwlɔ 'di ‑wɛe ao 'je tʋ\"bokpae \"kpei ‑te, ‑wɛe ao 'je Israɛ‑blʋa 'a blo'wɔn ‑nɩa ‑puue 'jɔ 'sɔɔn 'ɔ 'pee 'je. ");
INSERT INTO wob_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","'Sʋ Tʋ\"bo wlu' ɔ 'na : Simɔ, Simɔ, ‑siɔn' ‑teeɛ' 'ʋn aopʋ i, ‑wɛe ɔ 'je aopʋ 'ʋn ‑gbao' ka nyɔ ɔ ‑fuan' ko 'ʋn ɛ. ");
INSERT INTO wob_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","'Kaa 'ɩn bae ‑ma Kea 'mɛ ‑wɛe ‑ma 'ma ‑kwlɩ\" ‑tea' je ‑kwlin 'wlʋ. 'De ‑bo ‑ɩn ‑biie\" 'nɔ 'ʋn o ɛ, ‑wɛe ‑ɩn ‑je ‑ma de'di ‑wi\" 'a dɩ ikuu‑. ");
INSERT INTO wob_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","'Sʋ Piɛi 'na : Tʋ\"bo, ‑ta ʋʋa mua ‑ʋn ‑kaso 'di pooa' a, 'de ‑ta ʋʋa mua ‑ʋn 'dbaa, 'bomɔ ʋʋ 'je 'ʋn ‑kaso 'di poo, 'de 'je 'ʋn 'dbaa ‑ke. ");
INSERT INTO wob_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","'Sʋ Sesi 'na : Piɛi, 'ma 'tmʋʋ ‑ʋn ‑ɛ, nɔ\" ‑tɩ sʋn\" 'je ‑sro' ‑sɩan a, ‑ma muɛ wlua' kpɛ taan ‑ɩn ‑je 'nʋ ‑ɩn se 'ʋn juo‑. ");
INSERT INTO wob_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","'Sʋ Sesi wlu' 'de ʋʋ ‑wee' ‑pee ke'wlɛ ɔ 'na : ‑Ta 'ɩn dboa aopʋ ‑wɛe ao sea 'wɛi 'dipodɛ ke, ‑ke ke \"kwlai‑ 'ble 'ee, dɛ jrɛ' ‑pɔn aopʋ 'kwa 'mɛɛ ? 'Sʋ ʋʋ 'na : \"Ɩɩn‑, dɛ jrɛ' se ‑a 'kwa ‑pɔn. ");
INSERT INTO wob_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","'De ɔ 'na : Kaan ka mɔ 'jaa nyɔ ‑blea ɔɔ' 'wɛi 'dipodɛ, ɔ \"duo ɛ 'ʋn. Nyɔ ‑blea ‑ke, ɔ \"duo ɛ 'ʋn ‑ke, 'de nyɔ sea' ‑cnɛ 'ble, ‑mɛ ɔ ple ɔɔ' 'ʋnpaadɛ 'de ɔ 'je ‑cnɛ due' ‑tɩn'. ");
INSERT INTO wob_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","'Ma 'tmʋ aopʋ 'mɛ : wlu ‑crɩɩa' 'de 'ma ‑tɩ' 'ʋn ‑nɛ, ɩ 'je 'o nyni ‑o. ɛɛ' wlu tu 'naa : Ɔ ‑srooɛ' 'bo 'diwɔnyniʋn 'a ‑tɔn \"i. De dɛ ‑crɩɩa' 'de 'ma ‑tɩ' 'ʋn ‑nɛ ‑teɛ 'o nyni ‑tɩ. ");
INSERT INTO wob_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","'Bomɔ klai\" nynuu 'na : Tʋ\"bo, ‑cnɩ 'sɔɔn ka ‑ta. 'Sʋ Sesi 'na : Ɩ ‑tiɛi\". ");
INSERT INTO wob_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Sesi \"sia \"kpae' 'sʋ, ɔ muɛ 'e olifɩ‑crʋ \"kpei ka ɔɔ nʋa see ɛ, 'sʋ ɔɔ' klai\" nynuu bla 'o ɔ 'de. ");
INSERT INTO wob_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Ɔ nynia 'bo 'a ‑ta ‑tu 'sʋ, ɔ wluɛ ɔɔ' klai\" nynuu ‑pee ɔ 'na : Ao bae Kea ‑wɛe ao je 'e dɛsaʋn 'di 'kpa. ");
INSERT INTO wob_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","'De ɔmɔ tɛɛn ʋʋpʋ kɩɩn dɛ‑saan\" ka, ka nyɔ ɔ ‑fii\" a \"soukpo ɛ, 'kamɔ 'bo tɛn‑, ‑wɛe ɔ tba 'kɔi‑ i 'de ɔɔ bae Kea ka ɔ 'na : ");
INSERT INTO wob_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","'Ɩn \"Bo, ‑bo ɛ ‑nɩɛ \"i ɛ 'je 'ʋn 'kle ‑nɛ o tɛɛn 'de ɛ, 'Kaa ka \"o ka ɛ 'je ɛ nɩ ɛ, 'ma ‑nɩ 'tʋn nʋ‑tɩ 'bo nʋʋɛ, ɛɛ' ‑nɩ 'tʋn nʋ‑tɩ nʋʋɛ‑. ");
INSERT INTO wob_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43"," 'Sʋ Kea 'a \"soai due' 'wluɛ 'e jaʋn 'di ɔ jiɛ ɔɔ' dɩ i kua'. ");
INSERT INTO wob_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","‑Ta 'mɛa 'a faʋn 'kpa 'de ɔ 'ʋn 'sʋ ɔɔ' Kea baewlu a cɛn nyʋ 'ʋn 'ɛ, ɔɔ' ‑su' ‑a ‑toa\" 'bo 'blʋɔ ɛ ‑kɔ' nymɔ kpɩn‑. ");
INSERT INTO wob_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Ɔ ‑kɔa' baea' 'sʋ, ɔ sɔn 'ʋn 'ɛ, ‑wɛe ɔ mu 'de ɔɔ' klai\" nynuu o de. ‑Ta ɔɔ mua ‑mɛ ʋʋ ‑wee' nɩɛ 'mʋa' 'de \"jrii \"kaea' 'ʋn. ");
INSERT INTO wob_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","'Sʋ ɔ wlu' 'de ʋʋ ‑pee ɔ 'na : Dɛɛ‑tɩ aoa 'mʋ ɛ‑ ? Ao sɔn 'ʋn, ao 'je Kea bae ‑wɛe ‑siɔn' je aopʋ i ‑tɩn'. ");
INSERT INTO wob_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Ɔ siiɛ wlua' 'sʋ, nyʋ ‑tuu\"‑tuu je i \"si. Suida ‑pooa ɔɔ' dboʋn ‑puue 'jɔ 'sɔɔn mɔ ‑kɔn 'e ʋʋpʋ 'mla. Ɔ 'kpa Sesi ‑pʋn\" ‑wɛe ɔ ‑gblee ɔ ‑kwlɩ\". ");
INSERT INTO wob_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","'Sʋ Sesi wlu ɔ ‑pee ɔ 'na : Suida, 'de ‑kwlɩ\" ‑gbleea' 'ʋn mɔ ‑ma cɛɛn ‑wɛe ‑ma poo nyiɔ 'ɔ \"Ju 'srɛ i ? ");
INSERT INTO wob_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Nyʋ ‑ke Sesi na 'jeea dɛ ‑ɛɛ jia nʋʋa' nya i 'sʋ ʋʋ 'na : Tʋ\"bo, ‑a po ‑cnɩɩ ? ");
INSERT INTO wob_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Ɛ \"siɛ 'de ʋʋpʋ 'wɔn 'sʋ ʋʋa' due' pooɛ 'sraa ‑sai klaa\" 'a dbonʋi ‑cnɛ, ‑wɛe ɔ cɛn ɔ dian o doun\" \"jru. ");
INSERT INTO wob_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","'De Sesi \"duo wlu 'ʋn ɔ 'na : \"Ɩɩn‑ 'de, ɛ sie kan', ao 'bo ‑cnɛ pooɛ ! ‑Wɛe ɔ bla \"ju ‑nɔ 'ɔ doun\" \"i 'sʋ ɛ jiɛ 'bo ‑kɔ o de. ");
INSERT INTO wob_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","‑Wɛe Sesi wlu 'de 'sraa ‑saʋn klae\" ke Kea ‑gbu ifʋoʋn 'a \"jru kpɔ' i ‑teʋn ke nyʋ‑cɔɩn' ‑wi\" ‑ji' ɔ kpʋan' ‑pee ɔ 'na : Ao 'bleɛ ‑cnɩ ke titii ‑wɛe ao ji 'ʋn kpʋan', ɛ ‑kɔ' ‑na 'ɩn nɩɛ \"ku 'dbai ‑oo ? ");
INSERT INTO wob_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","'De 'wɩ ‑wee' \"klein 'di ɛ, ao ke 'ma ‑a ‑nɩɛ ‑tadue 'de Kea ‑gbu klaa\" 'di, ao se 'ʋn sʋn ‑pʋn\" ‑te'. 'Kaa aoa' nɔ\" nyni' ‑wɛ‑ la, ‑jɛ' mɛ la ‑siɔn' ɔ' \"ikmaa' 'je \"kpae' 'pɛɛn‑. ");
INSERT INTO wob_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Ʋʋ ‑kɔa' Sesi kpʋan' 'sʋ ɛ, ʋʋ kpɔ 'e 'sraa ‑sai klaa\" o ‑gbɛin\". Piɛi a bla ʋʋpʋ bʋ ‑kɔ woi. ");
INSERT INTO wob_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Ʋʋ ‑tba' nɛ‑gban 'bo ‑gbɛin\" 'a ‑kwea'‑, ‑wɛe ʋʋ ‑gbaeɔ' 'de woi, 'sʋ Piɛi jiiɛ 'bo ʋʋpʋ \"klu ‑wɛe ɔ ‑te i. ");
INSERT INTO wob_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","'Sʋ dbonʋnynɔkpao' due' ‑je ‑ɔ, ‑mɛ ɔ ‑teɛ i 'bo nɛ wɔin\". 'Sʋ ʋ \"si ɔ \"jriɛ‑ ʋ 'na : \"Ju ‑nɔ ke ɔɔ na' ‑ke. ");
INSERT INTO wob_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","'Kaa Piɛi ‑too' ɔ 'na : 'Nynɔkpao', 'ɩn se ɔ juo‑. ");
INSERT INTO wob_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Nɔ\" ‑sia 'o mu dɛ‑saan\" ka 'sʋ, \"ju jrɔ' 'je ɔ, ‑mɔ 'na : ‑Ɩn ‑nɩɛ nyʋ ‑nʋ 'a due' ‑o. 'Sʋ Piɛi 'na : \"Ɩɩn‑, 'ɩn se ʋʋa' due' nɩ‑. ");
INSERT INTO wob_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Ɛ 'wlʋa 'o ‑mɔ 'sʋ, due' ji' ke'wlɛ ‑mɔ 'nɛ ɛɛ' wlu \"kpei ‑wee' ɔ 'na : tɔ' ‑tɩ ‑o, \"ju ‑nɔ nɩɛ nyʋ ‑nʋ 'a due' ‑o, dɛ‑nʋɛ' ɔ ‑nɩɛ Galilei ‑o. ");
INSERT INTO wob_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","'Kaa Piɛi wlu' 'de ɔ ‑pee ɔ 'na : \"Bo, dɛ ‑ɩn ‑nɩai\" ‑ɩn ‑jea 'tmʋ 'ɩn se ɛ juo‑. 'De ɛɛ' nɔ\" tu 'di, ɔ \"siɛ wlua' 'sʋ sʋn\" ‑sro'. ");
INSERT INTO wob_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Tʋ\"bo \"biia i, 'sʋ ɔ ‑gbʋɛn Piɛi ja. 'Sʋ wlu Tʋ\"bo 'tmʋa 'de ɔ ‑pee 'de ɛ, ɔ po ɛ ‑kwlʋ o. Tʋ\"bo wlu' ka 'de‑, ɔ 'na : Nɔ\" ‑tɩ sʋn\" 'je ‑sro' ‑sɩan ‑ma muɛ 'ʋn wɔn ‑saa' kpɛ taan ‑ɩn ‑je nʋ ‑ɩn se 'ʋn juo‑. ");
INSERT INTO wob_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Piɛi \"sia \"kpae' 'sʋ ɔ ‑teɛ ‑fɩn\" 'a ‑pʋn\". Ɔ ‑fɩɩn\" mamaʋ 'sʋ ɔɔ' wɔn 'di je i \"kae‑. ");
INSERT INTO wob_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Nyʋ ‑ʋʋa fua Sesi i ɛ, ʋʋa wlɔɔ' ‑wɛe ʋʋa blɔ. ");
INSERT INTO wob_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","‑Bo ʋʋ blɔ dɛfɔ \"jri ɛ, 'de ʋʋa blɔ ‑wɛe ʋʋ 'na : ‑Ɩn ‑si' dɩ, ‑ɔ bla ‑ʋn ɛ‑ ? ");
INSERT INTO wob_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","'De ʋʋa cɛn ‑cree\" i ‑tuu\"‑tuu ʋʋa ‑teɔ' kwa. ");
INSERT INTO wob_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","‑Sɔn' ‑sɩɩan' 'sʋ ɛ, nyʋ‑cɔɩn' ‑wee'‑ ke 'sraa ‑saʋn 'a klae\" ke kɛ' wɔ‑saʋn 'kɩɩɛn \"jrui, ‑wɛe ʋʋ kpa Sesi 'bo ʋʋa' ‑gbajeʋn \"juɔi, ");
INSERT INTO wob_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","‑wɛe ʋʋ ‑tee' ɔ i ka ʋʋ 'na : ‑Bo ‑ɩn ‑nɩ Klisɩ ɛ, ‑mɛ ‑ɩn ‑tmʋ ɛ 'de ‑a ‑pee. 'Bomɔ Sesi ‑sɛɛ \"kpei ɔ 'na : ‑Bo 'ɩn 'tmʋ ɛ 'de ao ‑pee ɛ, ao se ɛ tɔ' 'ʋn 'jei see. ");
INSERT INTO wob_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","'De ‑bo 'ɩn ‑tee' aopʋ i ɛ, ao se 'e wlu ‑sai see. ");
INSERT INTO wob_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","'Kaa dɛ ‑wlʋa ‑ta la ‑ɛ mua nya, nyiɔ 'ɔ \"Ju a muɛ i ‑tea' 'de \"ikma Kea 'a dianfɔ o. ");
INSERT INTO wob_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","'Sʋ ʋʋ ‑wee' \"klein 'na : ‑Ɩn ‑nɩɛ Kea 'a \"Ju ‑o 'jaa ? 'De Sesi 'na : Ɛmɛ aoa' ‑cɛ\" 'kpa 'tmʋa 'o, 'ɩn nɩ 'ɛ ‑cɛɛn'‑. ");
INSERT INTO wob_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","'Sʋ ʋʋ 'na : Ɛ jii 'de ɔɔ' ‑cɛ\" 'kpa 'wɔn ‑wɛ‑, ‑mɛ dɛ ‑ɛɛ i ‑teea' ‑a ‑je nyʋ i ‑tee' 'bode ɛ‑ ? ");
INSERT INTO wob_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","'Sʋ nyʋ ‑kwea de ‑wee' \"klein sɔn 'ʋn 'ɛ, ‑wɛe ʋʋ kpa Sesi 'bo Pilatɩ \"juɔi. ");
INSERT INTO wob_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","'Bomɔ ʋʋ ‑tee ɔɔ' ‑tɩ' \"kpei‑ ‑tu\" 'a ‑pʋn\" ʋʋ 'na : ‑A ‑nynaa \"ju ‑nɔ i, dɛ‑nʋɛ' ɔɔ paa nyʋ bɩ ‑sɔn ɔɔ dooa ʋʋa' \"jru ɔ 'na ʋʋ 'bo Sesaa 'a 'wɛi ‑saa, ‑wɛe ɔɔ 'daa‑ ɔɔ' ‑cɛ\" Klisɩ, 'beɔ. ");
INSERT INTO wob_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Pilatɩ ‑teeɛ' Sesi i ɔ 'na : ‑Ɩn ‑nɩɛ Suifʋ‑wi\" 'a 'beɔ ‑oo ? 'Sʋ Sesi wlu ɔ ‑pee ɔ 'na : Ɛmɛ ‑jia' 'o 'de ‑ma ‑cɛ\" 'wɔn. ");
INSERT INTO wob_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","‑Wɛe Pilatɩ wlu 'de 'sraa ‑saʋn 'a klae\" ke, nyʋ ‑kɩɩn' a \"jrui ‑pee ɔ 'na : Dɛ ‑ɛ ‑jea \"ju ‑nɔ 'pee kpʋʋn ɛ, 'ɩn seɛ 'je. ");
INSERT INTO wob_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","'Kaa ʋʋ ‑tʋɛ\" \"kpei ke'wlɛ ʋʋ 'na 'de ɔɔ' nyʋ dɛtɔɔsʋn 'ʋn ɛ, ɔ ‑teeɛ nyʋ 'a \"jru dooa' 'de Galile mamaʋ 'sʋ ɔ e Suide blʋa ‑wee' \"i \"sii‑ ɔ e ‑ta nyni. ");
INSERT INTO wob_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Pilatɩ 'wɔan Galile 'a 'nynɩ 'sʋ, ɔ ‑teeɛ' nyʋ i ‑bo Sesi nɩ Galile i ɛ. ");
INSERT INTO wob_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Ɔ 'wɔan ka Sesi 'wlʋa 'de Erodɩ 'a 'blee 'blʋa‑ \"kpei 'sʋ ɔ kpɔ 'de ɔ o. ‑Mɛ Erodɩ nɩɛ 'o Selisalɛm 'de ɛɛ' 'wɩ tu 'di. ");
INSERT INTO wob_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Erodɩ 'jeea Sesi \"jriɛ‑ 'sʋ 'mʋa‑ a nʋɔ', dɛ‑nʋɛ' ɔ ‑kwle Sesi 'a 'nynɩ 'wɔan' 'mɛ, ɔ ‑nɩɛi\" ɔ ke ɔ 'je 'jee‑, ‑wɛe Sesi 'je jrii' nʋ ɔ 'je ɛ \"jriɛ‑ 'jee‑. ");
INSERT INTO wob_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","'Sʋ Erodɩ ‑tee' ɔ dɩ ‑tuu\"‑tuu i, 'kaa Sesi se 'e wlu ‑sa. ");
INSERT INTO wob_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","‑Ta ɛ nɩɩa kan' ‑mɛ 'Sraa ‑saʋn 'a klae\" ke, kɛ' wɔ‑saʋn ‑wee' ‑nɩa 'o ʋʋa ‑tuu\"‑ ɛ Sesi ‑tɩ' \"kpei‑ sɔɔn‑ sɔɔn‑. ");
INSERT INTO wob_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","'Sʋ Erodɩ ke ɔɔ' \"soa‑wi\" a wlaa Sesi 'mɛ, ʋʋa ‑flɛɛn 'ɔ, ʋ paa ɔ \"bai ‑ɛɛ nʋa blɛblɛ 'ʋn, 'de ʋʋ kpɔ 'de Pilatɩ o de. ");
INSERT INTO wob_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","'De ɛɛ' 'wɩ tu 'di ɛ, Pilatɩ ke Erodɩ ‑ʋʋ ‑kɔan tʋ tɛin\" 'de ɛ, ʋʋ 'kpa dbɛɛʋn. ");
INSERT INTO wob_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Pilatɩ 'kɩɩɛn 'sraa ‑saʋn 'a klae\" ke nyʋ‑cɔɩn' ke nyʋ ‑wee' \"klein \"jrui, ‑wɛe ɔ wlu' ʋʋpʋ ‑pee ɔ 'na : ");
INSERT INTO wob_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","\"Ju ao ja 'ʋn ‑ta ‑wɛe ao 'na ɔɔ dooa nyʋ 'a \"jru ɛ, 'ɩn ‑tee' ɔ 'wɔn i ‑wɛ‑ 'bo ao ‑wee' \"klein \"juɔi. 'Kaa dɩsaɩn \"klein aoa ‑tuu\" ɔ \"kpei‑ ɛ, dɛ 'ɩn 'jea tɔ' 'ʋn 'je ɛ, ɛ se nɩ‑. ");
INSERT INTO wob_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Erodɩ foo\" 'sʋ se ɔ dɛsaʋn jrɛ' ‑pʋn\" 'je ‑ke, ɛmɛ ‑tɩ ɔ jɔ 'nɔ ‑a o de. Aoa 'jee, \"ju ‑nɔ, dɛ \"o dɛ jrɛ' ‑ɛ ‑jea ɔɔ' 'mɛa' 'je, ɔ se ɛ nʋ. ");
INSERT INTO wob_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","'Kaa 'ma mu ɔ klae‑ 'ʋn kpaa' ‑wɛe 'ɩn 'je ɔ i \"sii‑. ");
INSERT INTO wob_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","'De 'bo ‑kɔ' \"o ‑kɔ' ‑sɔn see ɛ, Pilatɩ a \"siiɛ‑ ‑kaso 'dii ʋʋ nɩa \"i i. ");
INSERT INTO wob_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","'Sʋ ʋʋ ‑wee' ‑saa ‑cruɛn\" ‑tadue, ʋʋ 'na : ‑Ɩn ‑dba \"ju ‑nɔ ‑wɛe ‑ɩn ‑je Barabasɩ i \"sii‑. ");
INSERT INTO wob_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","'De Barabasɩ nɩɛ ‑kaso 'di, dɛ‑nʋɛ' nyʋ ‑toa 'blʋajei wɔn o ‑wɛe ‑ʋʋ ‑dba \"ku ‑kwlɔ ‑gbai ‑fɔn' nɔ\" ɛ, ɔ nɩɛ 'e ʋʋpʋ \"klu. ");
INSERT INTO wob_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Pilatɩ nɩɛ \"i ɔ 'jea Sesi i \"sii‑ ɛ, ɔ wlu' 'de nyʋ ‑kwea de ‑pee ke'wlɛ. ");
INSERT INTO wob_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","'Kaa ʋʋ ‑wee' \"klein ‑saa ‑cruɛn\" ʋʋ 'na : ‑Ɩn kɔ ɔ 'bo tu ‑kwlɩ\", ‑ɩn kɔ ɔ 'bo tu ‑kwlɩ\" ! ");
INSERT INTO wob_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Pilatɩ \"duɛ wlu 'ʋn ke'wlɛ kpɛ 'ɛ taan ‑nɛ ɔ 'na : Dɛɛ‑tɩ ɛ‑, dɛsaʋn ‑jɛ wɛ‑ ɔ nʋ ɛ‑ ? Dɛ ɔ nʋa, ‑wɛe ɔ 'jea 'mɛ 'ɩn se ɛ 'je 'de ɔ 'ʋn. 'Ma mu ɔ klae‑ 'ʋn kpaa' 'de 'ɩn 'je ɔ i \"sii‑. ");
INSERT INTO wob_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","'Kaa ʋʋ 'nɛ Sesi 'a 'bo tu ‑kwlɩ\" kɔ ‑tɩ 'a wlu \"kpei mamaʋ 'sʋ ʋʋa' \"wɔ ‑cruɛn\" je 'o \"kpei 'bɔɔ‑. ");
INSERT INTO wob_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","'Sʋ Pilatɩ cɛn 'o wlu ɔ 'na : Dɛ ao ‑teea' i a muɛ nʋʋa'. ");
INSERT INTO wob_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","\"Ju ‑nɩa ‑kaso 'di 'de 'blʋajei wɔn o toa' ke \"ku 'dbaa 'a ‑tɩ' 'ʋn 'de ‑ɔɔ i \"sii ‑tɩ ʋʋ ‑teea' i ‑tee ‑tee\"‑ ɛ, ɔmɔ Pilatɩ \"sii‑ i. 'Sʋ ɔ 'bɔɔ‑ ʋʋpʋ Sesi kwa, ‑wɛe dɛ ʋʋ nɩa \"i, ʋʋ 'je ɔ \"jrii nʋ. ");
INSERT INTO wob_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","‑Ta ʋʋa kpaa Sesi 'dbaa' a, 'bomɔ ʋʋ ke Sirɛnɩ i due' nyʋ a 'daa‑ Simɔ ‑gbʋʋn' 'bo ‑jei\", ‑mɛ ɔɔ 'wlʋɛ ‑gbei\". 'Sʋ ʋʋ nynɔɔ i ‑wɛe ʋʋ ‑tu\" ɔ Sesi 'a 'mɛtu \"kpei 'de ɔ 'je ɛ 'ble 'bo ɔ 'de. ");
INSERT INTO wob_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Nyʋ ‑tuu\"‑tuu 'wla ʋʋpʋ 'dei. 'Nynʋkpae' a ‑fɩɩn\", ʋʋa bla pɛe‑ 'de ɔɔ' ‑tɩ' 'ʋn. ");
INSERT INTO wob_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","'Sʋ Sesi \"biiɛ i 'de ʋʋpʋ o fɔ o ‑wɛe ɔ 'na : Selisalɛm‑nynʋkpae', ao 'bo 'ʋn ‑fɩɛn\"‑, ao ‑fɩn\" aoa' ‑cɛ\" ke aoa' \"nynuu ke‑, ");
INSERT INTO wob_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","dɛ‑nʋɛ' 'wɩ jrɩ' ‑a mu nynia' ‑wɛe nyʋ 'je wlu ka : 'Mʋa nʋ ‑sran ‑sie nynʋkpae', 'mʋa‑ nʋ \"kwli ‑sea' \"ju 'wlʋ due' ɛ, ɛ ke nyɩɩɛ \"ju sea' 'nya due' ke‑. ");
INSERT INTO wob_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","'De ɛɛ' nɔ\" tu 'di ɛ, nyʋ a muɛ wlua' ka : Crʋɩ klae\" ɩ 'wla 'de ‑a \"kpei, crʋko\" ɩ kaan ‑a \"jrii‑. ");
INSERT INTO wob_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","'Kaa ‑bo ʋʋa sea dɩ ‑nɩ tu jao \"jrii nʋ 'ee 'de ‑mɛ tu soɛ ‑mɛ 'e ? ");
INSERT INTO wob_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","‑Ta ʋʋa kpaa Sesi ɛ, ʋʋ kpa 'diwɔnyniʋn 'sɔɔn ‑ke 'de ʋʋ ke Sesi 'e ‑tadue 'mɛɛ. ");
INSERT INTO wob_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Ʋʋ nynia 'o ‑ta nyʋ a 'daa‑ \"jru kpa\" a, 'bo ʋʋ kɔɔ Sesi tu ‑kwlɩ\". Ʋʋ kɔ 'diwɔnyniʋn 'sɔɔn ‑nʋ 'mɛ 'bo tu ‑kwlɩ\" ‑ke. Due' kɔɔɛ 'o Sesi 'a dianfɔ o, ‑wɛe due' ‑nɔ kɔɔɛ 'o ɔɔ' kʋanfɔ o. ");
INSERT INTO wob_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","'Sʋ Sesi wlu' ka ɔ 'na : 'Ɩn \"Bo, dɩ ʋʋa nʋa ‑ta ɛ 'bo ɩ ‑sroɛ' 'bo ʋʋpʋ \"jru, dɛ‑nʋɛ' ʋʋ se 'e ɩ 'de juo‑. Ɛ 'wlʋa 'o mu ɛ, \"soa‑wi\" pooɛ ɔɔ' 'ʋnpaadɩ soa', ‑wɛe ʋʋ ‑gblɩ' 'ʋn 'bo ʋʋ 'a 'sʋ 'nynɩ. ");
INSERT INTO wob_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","‑Ta ʋʋ kɔɔa Sesi 'bo tu ‑kwlɩ\" ɛ, nyʋ ‑tuu\"‑tuu ‑gbae'‑, ‑wɛe ‑ʋʋa ‑jraa' ʋʋpʋ. 'pee jeʋn ‑wi\" a wlaa Sesi 'mɛ, ʋʋ 'na : Ɔmɔ ‑ɔ ‑pʋʋa' nyʋ jrʋ' ɛ, ɔ 'pʋʋ‑ ɔɔ' ‑cɛ\" la ‑a ‑je ɔ 'je 'de ! ‑Bo ɔ nɩ Klisɩ, \"ju Kea 'cra i 'de nyʋ \"klu ɛ, ‑mɛ ɔ \"sii‑ la 'e ! ");
INSERT INTO wob_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","\"Soa‑wi\" a wlaa Sesi 'mɛ ‑ke, ʋʋ 'kpaa' 'bo ɔ ‑pʋn\", ‑wɛe ʋʋ \"nyɩ ɔ ‑koonmɔ. ");
INSERT INTO wob_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","'De ʋʋ 'na : ‑Bo ‑ɩn ‑nɩ Suifʋ‑wi\" 'a 'beɔ ɛ, ‑mɛ ‑ɩn ‑pʋʋ' ‑ma ‑cɛ\" la 'e ! ");
INSERT INTO wob_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Dɛ ‑crɩɩa' 'de Sesi \"jru kpɔ' fɔ o ɛ, ɛ 'naa : \"Ju ‑nɔ nɩɛ Suifʋ‑wi\" 'a 'beɔ ‑o. ");
INSERT INTO wob_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","'Diwɔnyniʋn ‑ʋʋ ‑kɔɔa 'bo tu ‑kwlɩ\" ɛ, ʋʋa' due' a ‑cree\"‑ Sesi 'mɛ ɔ 'na : ‑Ɩn se Klisɩ nɩ ‑nɛ ɛ‑ ? ‑Ɩn ‑pʋʋ' ‑ma ‑cɛ\", ‑wɛe ‑ɩn ‑je ‑a 'pʋʋ‑ ‑ke. ");
INSERT INTO wob_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Ɔ 'tmʋa dɛ ‑nɛ 'sʋ due' ‑sia 'o ‑teɛ ɔɔ' \"bli ‑cɛa' ‑pʋn\" ɔ 'na : Kea 'a faʋn 'a nʋ ‑ʋʋn ? 'Pee kpʋan ‑mɔ ‑ke ɛ, dɛ ‑nɛ mɛ ‑ma ‑tmʋʋ ? ");
INSERT INTO wob_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","‑Mɔ ‑ke 'mɔ ke‑ ‑a ‑nɩɛ kui wɔn 'je ka‑, dɛ‑nʋɛ' ‑aa kplɩn saɩn, 'a ‑kei\" mɛ ‑aa ‑je, 'kaa \"ju ‑nɔ ‑mɔ se dɛsaʋn jrɛ' nʋ. ");
INSERT INTO wob_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","'Sʋ ɔ wlu' 'de Sesi ‑pee ɔ 'na : ‑Bo ‑ma sea 'de ‑ma 'beɔdɛ 'ʋn de ji ɛ, ‑mɛ ‑ɩn po 'ma ‑tɩ' ‑kwlʋ o. ");
INSERT INTO wob_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","'Sʋ Sesi wlu' 'de ɔ ‑pee ɔ 'na : Tɔ' ‑tɩ 'a tɔ' ‑tɩ 'ma 'tmʋʋ ‑ʋn, 'de ‑sɩanwɩ 'di ɛ, ‑ɩn ‑ke ‑aa muɛ 'de Kea 'a kɛɛma' ‑kwlɔ 'di mua'. ");
INSERT INTO wob_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","'De ɛɛ' nɔ\" tu 'di ‑mɛ 'jrʋ ‑teɛ ‑gbao, 'kaa ɛ \"muɛ \"jri. 'Sʋ kwie kpʋn' 'de 'blʋa‑ ‑wee' \"klein \"kpei mamaʋ 'sʋ, ɛ je ‑kwie\" jrʋ ‑gbao jɛɛ‑. ");
INSERT INTO wob_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","'De ɛɛ' nɔ\" tu 'di ɛ, tae' fɔ ‑nɩa Kea ‑gbu klaa\" 'di ɛ, ɛ sɔn 'fɔ 'o 'bo ‑kwea'‑. ");
INSERT INTO wob_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","'Sʋ Sesi \"wɔ ɔ 'na : 'Ɩn \"Bo, 'ɩn ‑teɛ' ɛ 'ma 'kmʋ kwa. Ɔ 'da kan' 'sʋ, ɔɔ' feeɛ' bluɛ i‑. ");
INSERT INTO wob_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","\"Soa ‑wi\" 'a ‑jeopoi 'jeea dɛ ‑nʋʋa 'mʋa‑ \"jriɛ‑ 'sʋ ɔ 'bɛɛ‑ Kea 'a 'nynɩ \"i ɔ 'na : Tɔ' ‑tɩ ‑o, \"ju ‑nɔ nɩɛ 'pepe ‑cɛɛn'‑. ");
INSERT INTO wob_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Nyʋ \"klein ‑kwea de 'jeea dɛ ‑nʋʋa 'mʋa‑ \"jriɛ‑ 'sʋ, ʋʋ muɛ ‑gbɛin\" woi 'de kplea' 'ʋn. ");
INSERT INTO wob_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Sesi 'a \"dɛi‑wi\" ke, 'nynʋkpae' ‑wlʋa Galile 'de ‑ʋʋ ‑ke ɔ jia poɛ kɩɩn ‑ta ‑tɔɔn, ‑wɛe ʋʋa ‑gbʋn' dɛ ‑ɛɛ nʋʋa ja. ");
INSERT INTO wob_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","51","‑Gbajei due' ‑ɔɔ 'nynɩ nɩa Sosɛʋ, ɔ 'wlʋɛ 'o Arimate 'de Suide, ɔɔ fuɛ Kea 'a 'beɔ dɛ‑. Ta ‑gbajeʋn a pooa Sesi 'a 'mɛ ‑tɩ ɛ, ɔ ke ʋʋ se ɛ 'ʋn nɩ‑, dɛ‑nʋɛ' ɔ \"srɛi, ɔɔ pleeɛ Kea. ");
INSERT INTO wob_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Ɔmɔ ‑ɔ mu Sesi 'a \"ku i ‑teea' 'de Pilatɩ o. ");
INSERT INTO wob_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","'Sʋ ɔ ‑sa ɔɔ' \"ku 'bo tu ‑kwlɩ\", ɔ \"fin ɔ tae' plu \"jrui ‑wɛe ɔ ‑te' ɔ i 'de ‑gbaɩn' 'di. Ɛɛ' ‑gbaɩn' tu \"bluuɛ' 'de 'soa‑ 'di, ʋʋ se nyɔ i ‑te 'de ɛ 'di due'. ");
INSERT INTO wob_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Ɛ nɩɛ dɩ nmaewɩ ‑o, Suifʋ‑wi\" 'a ‑kwlewɩ 'a ‑kwie\". ");
INSERT INTO wob_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","'Nynʋkpae' ‑wlʋa Galile ‑ʋʋ ‑ke Sesi a na, ʋʋ ke Soseʋ mu' ‑wɛe ʋʋ sie Sesi 'a i ‑tesʋn ke ɔɔ' ‑gbaɩn' \"jriɛ‑ o. Ʋʋ 'jea Sesi 'a \"ku 'de ‑gbaɩn' 'di po‑ta 'sʋ ɛ, ");
INSERT INTO wob_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","ʋʋ 'wlua 'e ‑gbaɩn' \"kpei ʋʋ muɛ ‑kwlɔ de, ‑wɛe ʋʋ nmae 'cna ke -dai'klɔ ke‑ 'sʋ ʋʋ ‑kwle', dɛ‑nʋɛ' ɛ nɩɛ ‑kwle ‑wɩ ‑o 'kamɔ kɛ' 'da. ");
INSERT INTO wob_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Suifʋ‑wi\" 'a ‑kwlewɩ 'wlʋa 'o ‑jei\" ɛɛ' ‑sɔn' wɔin\" 'sʋ, 'nynʋkpae' ‑nʋ ‑cnʋʋn' 'de ‑gbaɩn' \"kpei, ʋʋ kpa 'e ‑dai'klɔ ʋʋ nmaea. ");
INSERT INTO wob_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","‑Ta ʋʋa mua ‑mɛ \"soukpo ‑ɛ ‑kaan 'bo ‑gbaɩn' \"wɔin 'wlʋ 'o 'wɛ‑. ");
INSERT INTO wob_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","'Sʋ ʋʋ pa 'de ‑gbaɩn' 'di, 'kaa ʋʋ se Tʋ\"bo Sesi 'a \"ku jɛɛ‑. ");
INSERT INTO wob_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","‑Ta ʋʋ nɩɛ tɔ' \"kpei naa' a, 'sʋ nyʋ 'sɔɔn jrʋ' ‑ʋʋa 'ʋnpaadɩ a fan ‑taan' ʋʋpʋ \"kpei. ");
INSERT INTO wob_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","'Sʋ dɛ waa ʋʋpʋ 'dii, ʋʋ bla \"jru ‑kwlɩ\". 'Sʋ nyʋ 'sɔɔn ‑nʋ wluɛ ʋʋ ‑pee ʋʋ 'na : Dɛɛ‑tɩ aoa ‑pɔn \"ju ‑nɩa 'kmʋ i 'de 'mɛʋn \"klu ɛ‑ ? ");
INSERT INTO wob_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","'Kaa ɔ se ‑ta nɩ‑, ɔ sɔn \"kunyɩɔ'. ‑Ta ɔ ke ao nɩɩa 'e Galile 'de ɛ, dɛ ɔ 'tmʋa ao po ɛ ‑kwlʋ o, ɔ wlu' ka 'de‑ ɔ 'na : ");
INSERT INTO wob_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","nyiɔ 'ɔ \"Ju 'je 'de tooɛ ‑o 'de dɛsaʋnʋʋn 'kwa, 'de ɔ 'je kɔɔɛ‑ 'bo tu ‑kwlɩ\", ‑wɛe ɔ 'je 'kmʋ de ji 'de 'wɩ 'a taan ‑nɛ 'di. ");
INSERT INTO wob_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","'Sʋ wlu Sesi 'tmʋa 'de ɛ, 'nynʋkpae' ‑nʋ po ɛ ‑kwlʋ o. ");
INSERT INTO wob_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Ʋʋ 'wlʋa 'de ‑gbaɩn' \"kpei ɛ, dɩ \"klein ʋʋ 'jeea \"jriɛ‑, ʋʋ 'tmʋ ɩ 'de dboʋn ‑nɩa ‑puue 'jɔ due' ke nyʋ jrʋ' ‑pee. ");
INSERT INTO wob_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Ɛ nɩ Madi ‑wlʋa Madala ke Saanɩ ke Sakɩ de Madi ke 'nynʋkpae' jrʋ' ‑ke ʋʋ nɩa 'o ke, ʋʋpʋ ‑tmʋ dɛ ‑nɛ 'de Sesi 'a dboʋn ‑pee. ");
INSERT INTO wob_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Dɛ 'nynʋkpae' ‑nʋ 'tmʋa 'mʋa‑ ʋʋ se ɛ tɔ' 'ʋn 'je, dɛ‑nʋɛ' ʋʋa 'wɔn ɛ 'mii ka ja jaa' nɩa. ");
INSERT INTO wob_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","'Kaa Piɛi sɔan 'ʋn 'sʋ ɔ kpa plea' 'de ‑gbaɩn' \"kpei ɔ ‑gbʋn 'de ɛ 'di, 'kaa tae' plu 'a 'sʋ mɛ ɔ 'jee \"jriɛ‑. Dɛ ɔ 'jea 'mʋa‑ ɛ \"mɔɔ‑ tai' 'sʋ ɔ muɛ ‑gbɛin\" de. ");
INSERT INTO wob_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","'De ɛɛ' 'wɩ tu 'di ɛ, klai\" nynuu 'sɔɔn ‑ʋʋa mu 'de ‑kwlɔ due' ‑ɛɛ 'nynɩ nɩa Emmaisɩ 'di. ‑Jeblʋ 'a ‑toe 'a ‑puue 'jɔ due' ‑nɩ 'o ɛɛ' ‑kwlɔ ‑tu ke Selisalɛm 'nynɩ. ");
INSERT INTO wob_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","'Sʋ dɩ \"klein ‑nʋʋa 'de Selisalɛm ɛ, ʋʋa 'tmʋ ɩ \"wɔin. ");
INSERT INTO wob_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","‑Ta ʋʋ nɩɩa wlua' 'de ba o ‑tooa' 'ʋn 'sʋ Sesi 'kpaa' 'bo ʋʋpʋ ‑pʋn\", ‑wɛe ɔ ke ʋʋpʋ a naa bɩ' i. ");
INSERT INTO wob_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","'Kaa ʋʋa' \"jri kuɛ kwa ʋʋ se ɔ \"i juo‑. ");
INSERT INTO wob_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","‑Wɛe ɔ wlu 'de ʋʋ ‑pee ɔ 'na : Dɛ aoa di 'mii 'de ao ‑wee' je \"jrii \"kɩkɩ nɩ kan' a‑ ? ");
INSERT INTO wob_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","'Sʋ ʋʋa' due' ‑ɔɔ 'nynɩ nɩa Kleopasɩ ɛ, ɔ wlu' 'de Sesi ‑pee ɔ 'na : ‑Ta ‑mɔ ‑wlʋ 'de Selisalɛm‑nyʋ \"klu, ‑wɛe dɩ \"klein ‑nʋʋa 'de 'wɩ ‑nɩ 'di ‑wɛe ‑ɩn sɩ juo ɛ‑ ? ");
INSERT INTO wob_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","'De Sesi 'na : ‑Mɩ 'a dɩ tu 'de ɛ‑ ? 'Sʋ ʋʋ 'na : Dɩ ‑ɩ ‑nʋʋa Sesi ‑wlʋa Nasarɛtɩ ‑ɔ ‑nɩa Kea 'a wlu 'kwajaai \"jrii ɛ, ɩmɩ ‑aa ‑tmʋ. Sesi ‑nɔ ɔɔ' \"ikmaa' poɛ \"jri \"kpae' 'de ɔɔ' nʋʋdɩ ke ɔɔ' wlusʋn 'ʋn 'bo Kea ke nyʋ ‑wee' \"juɔi. ");
INSERT INTO wob_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Ka ‑aa 'sraa ‑saʋn 'a klae\" ke nyʋ‑cɔɩn' ‑wi\" to ɔ 'emu ‑wɛe ʋʋ 'jea ɔɔ' 'pee, 'de ʋʋ kʋɔ ɔ 'bo tu ‑kwlɩ\" ɛ, ‑ɩn sɩ 'wɔɔn ? ");
INSERT INTO wob_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","‑Apʋ mɔɔ naa tɔ' i 'de ɛ, ‑a ‑na ɔmɔ ‑je israɛ‑nyʋ seie‑ 'de ʋʋa' tʋnyʋ 'kwa 'de‑, 'kaa ɩa' dɩ tu nʋʋa ‑sɩan ɛɛ' 'wɩ taan ‑nɛ ka. ");
INSERT INTO wob_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Tɔ' ‑o, 'nynʋkpae' jrʋ' ‑wlʋ 'e ‑a \"klu ‑ʋʋ ‑ma\" a ‑a tai', ʋʋ mua 'de ‑gbaɩn' \"kpei ‑sɔn' wɔin\" ɛ. ");
INSERT INTO wob_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","Ʋʋ se ɔɔ' \"ku jɛɛ‑, ʋʋ jia de 'sʋ ʋʋ 'na : Kea 'a \"soa‑wi\" ‑wlu 'de ʋʋ ‑pee ‑ʋʋ ‑na : Ɔ sɔn 'ʋn 'ɛ, ɔ nɩɛ 'kmʋ. ");
INSERT INTO wob_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","‑Wɛe nyʋ jrʋ' 'wlʋ 'e ‑a \"klu 'de ʋʋ mu 'e ‑gbaɩn' \"kpei ‑wɛe dɩ \"klein 'nynʋkpae' \"sia 'nynɩ ʋʋ jɛɛ ɩ kan' ‑cɛɛn'‑, 'kaa ʋʋ se ɔmɔ 'ɔ ‑cɛ\" 'kpa 'je. ");
INSERT INTO wob_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","'Sʋ Sesi wlu' 'de ʋʋpʋ ‑pee ɔ 'na : 'Oo nyiɔpʋ ao se ‑mɛ 'ɛ tɔ'di nɩ kan' a‑ ? Dɩ \"klein Kea 'a wlu 'kwajaaʋn 'tmʋa 'de ɛ, aoa' ɩa' tɔ 'ʋn nɩɛ 'kle ! ");
INSERT INTO wob_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Klisɩ se 'kle ‑nɛ 'ʋn cɛɛn i 'dee‑ ‑wɛe ɔɔ' 'beɔdɛ se 'de ɔ 'kwa 'kpai ? ");
INSERT INTO wob_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","‑Wɛe dɩ \"klein Moisɩ ke Kea 'a weepoʋn 'tmʋa 'de ɔɔ' ‑tɩ' 'ʋn 'de ʋʋa' 'sbɛ 'di tɛin\" ɛ, ɔ ‑tee ɩa' wɔ ‑saa 'de ʋʋ ‑pee. ");
INSERT INTO wob_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","‑Ta ʋʋa nynia 'o ‑kwlɔ ʋʋa mua 'di ‑pʋn\" 'sʋ, ka nyɔ ɔ ‑sia' ‑wɛe ɔɔ mua nyaa 'kamɔ Sesi a ‑pɔn ɔ 'je nʋ 'de‑. ");
INSERT INTO wob_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","'Kaa ʋʋ kpʋʋn ɔ i ʋʋ 'na : ‑Ɩn ‑ji' ‑ɩn ‑ke ‑a ‑je ‑ta 'pɛn, ‑kwlu' a ‑kɔ' 'sʋ Sesi ke ʋʋ paa 'o ‑kwlɔ. ");
INSERT INTO wob_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","‑Ta ɔ ke ʋʋ nɩa dɛ dia' 'bo 'tablʋ \"kpei 'sʋ ɛ, ɔ \"duɛ ‑di'pɛn 'ʋn ɔ ‑kɔ ɛɛ' Kea 'sɛ poa' ‑wɛe ɔ cɩɛn ɛ i 'de ɔ \"nyɩ ɛ ʋʋpʋ. ");
INSERT INTO wob_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","'Sʋ ʋʋa' \"jri 'bai' ʋʋ juo ɔ \"i, 'kaa ɔ \"maa ʋʋpʋ \"jrii. ");
INSERT INTO wob_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","'Sʋ ʋʋa wluɛ ba ‑pee, ʋʋ 'na : ‑A ‑blu\" ‑aa, ɔmɔ ‑o 'teɔ 'dee‑, ɛmɛ ‑tɩ ‑ta ɔɔ ‑saa' Kea 'a wlu wɔ 'de ‑a ‑pee 'sʋ ‑a 'di cɛn 'cna \"kpei 'dee‑. ");
INSERT INTO wob_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","'Bo ɛ \"sri ʋʋ je Selisalɛm de mu, ʋʋ je dboʋn ‑nɩa ‑puue 'jɔ due' ke nyʋ ‑ke ʋʋ 'kɩɩan \"jrui jɛɛ‑. ");
INSERT INTO wob_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","'Sʋ ‑wi\" ‑mʋ 'na : Tʋ\"bo jiɛ 'kmʋ de ‑cɛɛn'‑, ɔ ke Simɔ 'jee. ");
INSERT INTO wob_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","‑Wɛe dɛ ‑nʋʋa ʋʋpʋ \"jrii 'bo ‑jei\" ke 'de ka Sesi ke ʋʋ nɩa 'o 'tablʋ \"kpei ‑wɛe ɔ cɛɛan ‑di'pɛn i 'bo ʋʋ \"juɔi ɛ, 'de ʋʋ po ʋʋpʋ ɩa' \"kuan. ");
INSERT INTO wob_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Ʋʋ siiɛ wlua' kan' 'sʋ, Sesi 'a ‑cɛ\" 'kpa ‑taan' 'bo ʋʋa' ‑kwea'‑, 'sʋ ɔ 'na : Ao 'je pɛe 'a blua' ! ");
INSERT INTO wob_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","'Sʋ dɛɛ waa ʋʋpʋ 'di i, faʋn a nʋ ʋʋpʋ 'mɛ, ʋʋmʋ 'na ‑mɛ ʋʋ 'jeeɛ ‑suu jrɛ' \"jriɛ‑ 'de‑. ");
INSERT INTO wob_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","'Kaa Sesi wlu' 'de ʋʋ ‑pee ɔ 'na : Dɛ ‑ɛɛ tai' \"maa aopʋ ɛ‑ ? Dɛɛ‑tɩ aoa naa tɔ' ‑nɩa kan' i 'de ao pɛe o ɛ‑ ? ");
INSERT INTO wob_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Ao ‑gbʋn 'ma kwa ke 'ma bɩ ja, ɛ 'ma ‑cɛ\" 'kpa ‑o ! Ao 'tʋn 'mi i, ao 'je 'ʋn 'je, dɛ‑nʋɛ' ‑suu se ‑sɩɩɛn' ke 'kpa 'ble ka 'mɔ nɩa. ");
INSERT INTO wob_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","‑Ta ɔɔ 'tmʋa wlu ‑nɛ ‑mɛ, ɔɔ toɛ ʋʋpʋ ɔɔ' kwa ke ɔɔ' bɩ \"i. ");
INSERT INTO wob_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Ʋʋa nʋ 'mʋa‑ 'mɛ ‑mɔ, 'kaa ʋʋ se ɛ tɔ' 'ʋn 'je ke 'pepe. Ka ʋʋ nɩa 'de tai' 'a \"maa' 'ʋn Sesi 'jea kan' 'sʋ, ɔ ‑teeɛ' ʋʋpʋ i ɔ 'na : Ao 'ble diidɛ jrɛ' 'mɛ ‑taa ? ");
INSERT INTO wob_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","'Sʋ ʋʋ to ɔ daa‑smii 'a tie \"i, 'sʋ ɔ \"duo ɛ 'ʋn 'ɛ, ");
INSERT INTO wob_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","‑wɛe ɔ ‑te ɩa' dia' ‑pʋn\" 'bo ʋʋpʋ \"juɔi. ");
INSERT INTO wob_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","'Sʋ ɔ wlu' 'de ʋʋ ‑pee ke'wlɛ ɔ 'na : ‑Ta ao ke 'ma ‑a ‑teea i 'de ɛ, dɛ 'ɩn 'tmʋa, ɛ ka, 'ɩn wlu' ka 'ɩn 'naa : Dɩ \"klein Moisɩ o, Kea 'a wlu 'kwajaaʋn o, Dafidɩ 'crɩa 'de 'ma ‑tɩ' 'ʋn ɛ, ɩ 'je 'o nyni ‑o se. ");
INSERT INTO wob_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","'Sʋ ɔ kaiɛn ʋʋpʋ 'a tɔ' wɔn ‑wɛe ʋʋ 'je Kea 'a wlu ‑ɛ ‑crɩɩa' 'dei 'wɔn. ");
INSERT INTO wob_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","'Sʋ ɔ 'na : Dɛ ‑crɩɩa' 'de 'ma ‑tɩ' 'ʋn, ɛ ka : Klisɩ a muɛ 'kle 'jea' mamaʋ 'sʋ ɛ 'je ɔɔ' 'mɛa' jɛɛ‑, ‑wɛe ɔ 'je \"kunyɩɔ' sɔn 'de 'wɩ 'a taan ‑nɛ 'di. ");
INSERT INTO wob_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","‑Bo ɛ nɩ kan' a, ‑mɛ 'kmʋ fai\" poo ‑tɩ ke dɛsaʋn 'a ‑kwɛ‑tɩ a muɛ 'tmʋʋa' 'de ɔɔ' 'nynɩ 'ʋn 'de 'bluadidɩ ‑wee' \"klein ‑pee. 'Kaa 'bo Selisalɛm mɔ ɛɛ' 'tmʋa' 'je ‑tee. ");
INSERT INTO wob_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Aopʋ ‑nɩ ɩa' dɩ tu 'a ‑ta 'jeʋn. ");
INSERT INTO wob_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","'De ao ‑gbʋn 'nɔ ‑suu ‑ɛɛ wlu 'ɩn \"Bo cɛan ‑tie\" ɛ, 'ma mu ɛ jaa' 'de aopʋ 'ʋn. 'Kaa ao ‑te i 'bo Selisalɛm mamaʋ 'sʋ ɛɛ' \"ikmaa' ‑wlʋa 'e jaʋn 'di 'je aopʋ \"kpei ji. ");
INSERT INTO wob_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Ɛ 'wlʋa 'o muɛ, Sesi ke ʋʋpʋ muɛ 'de Betani fɔ o, 'bomɔ ɔ kpa sɩn \"jɛi ɔ poo ʋʋpʋ \"diwan. ");
INSERT INTO wob_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Ɔ \"siɛ ʋʋpʋ 'a \"diwan poa' 'sʋ ɔ je 'ʋnsɔn 'bo ʋʋpʋ \"klu, ɔ je jaʋn 'di mu. ");
INSERT INTO wob_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Ʋʋpʋ mɔ ‑kɔa' ɔɔ' \"juɔi ‑gbɛɛa' 'sʋ ʋʋ muɛ Selisalɛm de 'de 'mʋa‑ 'ʋn. ");
INSERT INTO wob_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Ʋʋa 'kɩɩɛn \"jrui jeejee 'de Kea ‑gbu klaa\" 'di ‑wɛe ʋʋa ble ʋʋa 'bɛɛ‑ Kea 'a 'nynɩ \"i.");
INSERT INTO wob_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","‑Ta 'kmʋ a ‑teea a, ‑mɛ wlu nɩ' sese, wlu nɩɛ 'de Kea 'ʋn ‑wɛe wlu nɩ Kea. ");
INSERT INTO wob_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Wlu ke Kea 'kpaa tɛin\" sese. ");
INSERT INTO wob_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Kea cɛɛn 'de wlu 'ʋn ‑wɛe ɛ po dɩ ‑wee' \"klein 'kmʋ. Dɛ \"o dɛ ‑ɛ ‑nɩa 'kmʋ ‑wɛe wlu sea nʋ, ‑mɛ se nɩ‑. ");
INSERT INTO wob_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","'De ɛ 'ʋn mɔ 'kmʋnɩa' ‑cɛɛn'‑ 'wlʋ. Ɛɛ' 'kmʋ tu mɛ ‑nɩ nyʋ ‑wee' 'a ‑sɔn'. ");
INSERT INTO wob_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","‑Sɔn' ‑nɩa 'mʋa‑ ɛ ‑sɩn' 'de kwie 'ʋn, 'kaa kwie se ‑sɔn' i \"fian‑. ");
INSERT INTO wob_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Kea dboɛ nyɔ due', ɔɔ' 'nynɩ ‑nɩ San. ");
INSERT INTO wob_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Ɔ ji' ‑wɛe ɔ 'e ‑sɔn' 'ɔ ‑tɩ' 'tmʋ, 'de nyʋ ‑wee' 'je ɛɛ' ‑tɩ' tɔ' 'ʋn 'je 'bo ɔɔ' wlui\". ");
INSERT INTO wob_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Ɔmɔ se ‑sɔn' nɩ‑, 'kaa ɔ ji' ‑wɛe ɔ 'je ‑sɔn' 'ɔ ‑tɩ' 'tmʋ. ");
INSERT INTO wob_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Ɛɛ' ‑sɔn' tu mɛ ‑nɩ ‑sɔn' ‑cɛɛn'‑ ‑ɛ ji 'kmʋ 'de ‑ɛ ‑sɩn' 'de nyʋ ‑wee' \"klein \"kpei. ");
INSERT INTO wob_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Sesi mɔ ‑nɩ Kea 'a wlu ‑ɔ ‑nɩ 'kmʋ sese, ɔmɔ Kea cɛɛn 'ʋn ‑wɛe ɛ nʋ 'kmʋ 'kaa 'kmʋ \"kpei nyʋ se ɔɔ' ‑tɩ' 'wɔɔn‑. ");
INSERT INTO wob_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Ɔ jiɛ 'e ɔɔ' ‑cɛ\" 'kpa 'a 'blʋa‑ \"kpei, 'kaa ɔɔ' 'cɛ‑wi\" se ɔ sɩn 'sɔɔn kpʋʋn‑. ");
INSERT INTO wob_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","'Kaa nyʋ klein\" ‑kpʋʋn ɔ sɩn 'sɔɔn ‑wɛe ‑ʋʋ ‑je ɔɔ' ‑tɩ' tɔ' 'ʋn, ɔ nʋɛ' 'sʋ ‑wi\" ‑mʋ 'bɛɛ' ʋʋ 'je Kea 'a \"nynuu‑ 'kpa. ");
INSERT INTO wob_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Ʋʋ 'jea Kea 'a \"nynuu‑ 'kpa a, ɛ se 'e nyiɔ 'ɔ nymɔ ke, ɔɔ' tɔ' 'ʋn 'wlʋ, ɛ 'wlʋɛ 'e Kea 'ʋn. ");
INSERT INTO wob_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Kea 'a wlu ‑nɛ mɛ ‑srɛɛn nyiɔ 'ʋn. Ɔ \"tiɛ 'de ‑a \"klu. Ɔmɔ \"diwan ke tɔ' ‑tɩ \"ji 'ʋn. ‑A ‑jraa' ɔɔ' \"ikmaa' 'mɛ, ka \"jujɔ due' koun ‑gbai' 'blea ɔ \"bo 'a \"ikmaa' ‑wee' \"klein. ");
INSERT INTO wob_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","San ‑nɩa ɔɔ' ‑tɩ' 'a ‑ta 'jei ɔmɔ ‑na : \"Ju ‑ɔɔ ‑tɩ' 'ɩn 'tmʋa 'de ɛ ‑wɛe 'ɩn 'na : ɔɔ muɛ jia' 'de 'ʋn 'de ɛ, ɔ nɩɛ dɛwɔn ɔ je 'ʋn ‑sii, dɛ‑nʋɛ' ɔ ke 'kmʋ 'kpaa 'bo 'ʋn \"juɔi. ");
INSERT INTO wob_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Dɩ ‑wee' \"klein pooɛ 'de ɔ 'ʋn kɩɩn, ɛmɛ ‑tɩ ɔ \"jii ‑aʋn \"diwan 'a \"kwli ‑wee' wɔn. ");
INSERT INTO wob_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Tɔ' ‑o, Kea jaa Moisɩ kɛ' 'kwa ‑wɛe ɛ \"nyɩ ‑aʋn, 'kaa ɛ cɛɛn 'de Sesi 'ʋn ‑wɛe ɛ \"nyɩ ‑aʋn 'saa 'ʋn ke tɔ' ‑tɩ. ");
INSERT INTO wob_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Nyɔ \"o nyɔ se Kea \"jriɛ 'jee due', 'kaa \"Ju jɔ due' ‑nɩa 'o \"Bo ‑pʋn\" ɛ mɔ ‑sɛ 'kwla 'de ‑a ‑pee. ");
INSERT INTO wob_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Ka San nʋa Sesi 'a ‑tɩ' 'tmʋ sʋn 'ka ka : Suifʋ‑wi\" 'a \"jru kpɔ' i ‑teʋn ‑nɩa Selisalɛm dboɛ 'sraa ‑saʋn jrʋ' ke Kea ‑gbu sʋn opoʋn ke 'de San o ‑wɛe ‑ʋʋ mu ɔ i‑teea', ʋʋ 'na : ‑Mɔ 'ee, ‑ɩn ‑nɩɛ nyɔɔ ‑o ɛ ? ");
INSERT INTO wob_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","San wa 'wɔn i ɔ je wlu‑, ɔ se dɛ jrɛ' ‑sie\"‑, ɔ 'na : 'Ɩn se Klisɩ nɩ‑. ");
INSERT INTO wob_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","'De ʋʋ ‑tee' ɔ i ke'wlɛ ʋʋ 'na : Nyɔ ‑ɩn ‑nɩ 'ja a‑ ? ‑Ɩn ‑nɩɛ Eli ‑o ? San 'na : \"Ɩɩn‑, 'ɩn se ɔ nɩ‑. 'De ʋʋ 'na : ‑Ɩn ‑nɩɛ Kea 'a wlu 'kwajaai ‑nɔ ‑oo ? San 'na : \"Ɩɩn‑, 'ɩn se ɔ nɩ‑. ");
INSERT INTO wob_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","'Sʋ ʋʋ 'na : 'De ‑mɛ ‑ma 'nynɩ wɛ‑ 'ja a‑ ? ‑Aa ‑teeɛ' ‑mii ‑wɛe nyʋ ‑dboa' ‑aʋn ‑a ‑je ʋʋpʋ \"kuan kpa. Dɛ ‑ma ‑daa' ‑ma ‑cɛ\" ‑gbo' ɛ‑ ? ");
INSERT INTO wob_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","'Bomɔ San wluu‑, ɔ 'na : 'Ɩn nɩɛ \"ju ‑nɩa 'e ‑pɩɩɔn\" blʋa \"kpei 'a wee po wlu ‑o, ɔ 'naa : Ao nmae Tʋ\"bo 'a ‑je ! Ka Kea 'a wlu 'kwajaai Esai 'tmʋ ɛ 'de ɔɔ' 'sbɛ 'di ɛ, 'kamɔ 'mɔ nɩ‑. ");
INSERT INTO wob_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","'De nyʋ ʋʋ dboa 'e San o 'mʋa‑ \"klu ɛ, Fariseɛn‑wi\" ‑nɩ 'e mu, ");
INSERT INTO wob_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","ʋʋ ‑tee' ɔ i ka, ʋʋ 'na : ‑Ɩn sea Klisɩ nɩ‑, ‑ɩn sea Eli nɩ‑, ‑ɩn sea Kea 'a wlu 'kwajaai nɩ 'ee, ‑mɛ dɛɛ ‑tɩ ‑ma po nyʋ \"ni \"jru ɛ‑ ? ");
INSERT INTO wob_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","'Sʋ San 'na : \"ni mɛ 'ma po nyʋ \"jru, 'kaa 'de aopʋ \"klu ɛ, \"ju due' ‑nɩ 'e 'mɔ 'de ao se juo‑, ");
INSERT INTO wob_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","'kaa 'ɩn se ɔɔ' \"kwlai 'a \"dbi \"ikain ka nɩ‑. ");
INSERT INTO wob_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Dɩ ‑nɩ ‑wee' nʋʋɛ' 'bo Betani 'de Sudɛn juuɔ 'de, ‑ta San a pooa nyʋ \"ni \"jru ɛ. ");
INSERT INTO wob_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Ɛɛ' ‑sɔn' jrɛ' ‑sɩan', Sesi jiɛ 'de San o. 'sʋ ɔ 'na : Kea 'a blaa ju ‑ɛɛ ‑kɔa' nyʋ ‑wee' 'a dɛsaʋn, ɛ ka ! ");
INSERT INTO wob_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Ɔmɔ ‑nɩ \"ju ‑ɔɔ ‑tɩ' 'ɩn 'tmʋa ‑wɛe 'ɩn 'na \"ju ‑ɔɔ jia 'bo 'ʋn 'de ɔ 'bɛi\" ɔ je 'ʋn ‑sii, dɛ‑nʋɛ' ɔ nɩɛ 'kmʋ sese 'bo 'ʋn \"juɔi. ");
INSERT INTO wob_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","'Ɩn se ɔ juo‑ ‑ke 'de‑, 'kaa 'ma poɛ nyʋ \"ni \"jru ‑wɛe Israɛ‑kɔʋn 'je ɔɔ' ‑tɩ' juo‑. ");
INSERT INTO wob_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","San wlu' ke'wlɛ ɔ 'na : ‑Ta Kea 'a ‑Suu 'wlʋa 'e jaʋn 'di, ‑wɛe ɛ \"sia i 'bo ɔ \"jru ɛ, 'ɩn 'je ɛɛ' ‑ta 'mɛ. Ka ‑gbɛɛ' nɩa, 'kamɔ ɛ nɩ‑. ");
INSERT INTO wob_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","'De ‑mɛ 'mɔ sɩ ɔ juo ke ‑wee' 'de‑, 'kaa Kea ‑dboa' 'ʋn nyʋ \"ni \"jru poa', ɛmɛ ‑wlu 'ʋn ‑pee ka, ɛ 'na : ‑Ma muɛ 'ma ‑Suu i 'jea', ɛ 'je i \"si 'bo \"ju due' \"kpei. Ɔɔ' \"ju tu mɔ ‑ɔɔ mu 'ma ‑Suu nyʋ \"jru poa. ");
INSERT INTO wob_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","‑wɛe 'ɩn 'je ɛɛ' ‑ta, 'de ka ɔ nɩa Kea 'a \"Ju, 'ɩn 'je kan' ‑wɛe 'ɩn 'tmʋ ɛ 'de ao ‑pee. ");
INSERT INTO wob_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Ɛɛ' ‑sɔn' jrɛ' ‑sɩan', ‑ta San nɩa 'bo ɔ nɩ‑ ke'wlɛ, ɔ ke ɔɔ' klai\" nynuu 'sɔɔn ke. ");
INSERT INTO wob_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Ɔ 'jea Sesi ɔɔ ‑sia' 'sʋ ɔ 'na : Kea 'a 'blaa ju ‑nao. ");
INSERT INTO wob_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","San 'a klai\" nynuu 'sɔɔn ‑nʋ 'wɔan wlu ɔ 'tmʋa ‑nɛ 'sʋ, ʋʋ bla 'o Sesi 'de. ");
INSERT INTO wob_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Sesi ‑gbʋan de 'sʋ ka ʋʋa ji ɔ kɩn ɔ 'je kan' 'mɛ, 'de ɔ ‑tee' ʋʋpʋ i, ɔ 'na : Dɛ aoa ‑pɔn i ɛ‑ ? Ʋʋ 'na : Rabbi, (ɛ 'de mɛ ‑nɩ nyʋ dɛtɔɔi) ‑ta ka ‑ɩn ‑koo ɛ‑ ? ");
INSERT INTO wob_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","'Sʋ ɔ wlu' 'de ʋʋ ‑pee ɔ 'na : Ao ji 'je ! Ʋʋ mu' ‑cɛɛn'‑, ʋʋ je ‑ta ɔ kooa 'je. 'Bomɔ ʋʋ ke ɔ nɩ 'de 'wɩ ‑nɩa 'mʋa‑ 'di. 'De ‑ta ɛɛ nʋʋa kan' ‑mɛ ‑kwie\" jrʋ ‑teɛ ‑gbao. ");
INSERT INTO wob_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Nyʋ 'sɔɔn ‑wɔan San 'a wlu ‑wɛe ‑ʋʋ bla 'o Sesi 'de ɛ, ʋʋa' due' 'a 'nynɩ ‑nɩ Ancre, ɔ nɩɛ Simɔ Piɛi 'a de'di ‑o. ");
INSERT INTO wob_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Ɔmɔ ‑saa \"i ‑ɔ ‑jɛɛ ɔɔ' de'di Simɔ 'de ɔ 'na : ‑A ‑jee' Mesi \"jriɛ‑ ‑wɛ‑ ! (Ɛ 'de mɛ ‑nɩ Klisɩ, Nyʋ'pʋʋi Kea ‑tea' 'o ɛ.) ");
INSERT INTO wob_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","‑Wɛe ɔ kpa Simɔ 'de Sesi o. Sesi ‑gbʋan Simɔ ja 'sʋ ɔ 'na : ‑Ɩn ‑nɩɛ Sonasɩ 'a \"ju Simɔ ‑o, 'bode ɛ, ‑ma 'nynɩ ‑nɩ Sefasɩ (ɛ 'de mɛ ‑nɩ Piɛi, \"sou). ");
INSERT INTO wob_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Ɛɛ' ‑sɔn' jrɛ' ‑sɩan' Sesi ‑nɩɛi\" ɔ 'je 'e Galile mu 'sʋ ɔ ke Filipʋ ‑gbʋʋn', ɔ wlu ɔ ‑pee ɔ 'na : ‑Ɩn bla 'bo 'ʋn 'de. ");
INSERT INTO wob_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Filipʋ ‑mɔ 'wlʋɛ 'o Besaida 'bo Ancre ke Piɛi o ‑kwlɔ. ");
INSERT INTO wob_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Filipʋ ke Natanaɛ 'jea 'sʋ ɔ wlu ɔ ‑pee ɔ 'na : Natanaɛ, \"ju ‑ɔɔ ‑tɩ' Moisɩ 'crɩa 'de kɛ'ɛ 'sbɛ 'di, ‑wɛe ‑ɔɔ ‑tɩ' Kea 'a wlu 'kwajaaʋn 'tmʋa ‑a ‑jeɔ' ‑wɛ‑. Ɛ Soseʋ 'a \"ju Sesi ‑ɔ ‑wlʋa Nasarɛtɩ ‑o. ");
INSERT INTO wob_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","'Bomɔ Natanaɛ wluu ɔ 'na : Dɛ 'dɔe 'beeɛ' ɛ 'je 'o Nasarɛtɩ ‑mɔ 'wlʋʋ ? Filipʋ 'na : ‑Mɔ ji 'je 'sʋ. ");
INSERT INTO wob_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Sesi 'jea Natanaɛ ɔɔ jia 'de ɔ o 'sʋ, ɔ wlu' 'de ɔɔ' ‑tɩ' 'ʋn, ɔ 'na : Israɛ i 'a ‑cɛ\" 'kpa ‑mɔ ka, sɩ ‑tɩ se 'de ɔ 'ʋn nɩ‑. ");
INSERT INTO wob_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","'De Natanaɛ ‑tee' ɔ i, ɔ 'na : ‑Ta ‑ɩn juo 'ʋn ɛ‑ ? Sesi 'na : ‑Ta ‑ɩn ‑nɩɩa 'bo fikɩtu ‑sɔn 'bo 'ɩn 'jee ‑ʋn, ‑mɛ Filipʋ se ‑ʋn 'daa‑ ji ke. ");
INSERT INTO wob_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","'Sʋ Natanaɛ 'na : Nyʋ dɛtɔɔi, ‑ɩn ‑nɩɛ Kea 'a \"Ju ‑wɛe ‑ɩn ‑nɩ Israɛ 'a 'beɔ. ");
INSERT INTO wob_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","'De Sesi wlu ɔ ‑pee ɔ 'na : Dɛ 'ɩn 'na 'ɩn 'je ‑ʋn ‑wɛ‑ 'bo fikɩtu ‑sɔn, ɛmɛ ‑tɩ ‑ɩn ‑je 'ma ‑tɩ' tɔ' 'ʋn ? ‑Ma muɛ dɩ klae\" klae\" \"jriɛ‑ 'jeea', ɛ 'je ‑jɩ ‑mɩ ‑sii. ");
INSERT INTO wob_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","‑Wɛe ɔ wlu ke'wlɛ ɔ 'na : 'Ma 'tmʋʋɛ aopʋ tɔ' ‑tɩ, aoa muɛ jaʋn 'jea' ɛ 'je wɔn kain‑, 'de Kea 'a \"soa‑wi\" 'je ‑ja ‑blu' nʋ 'bo nyiɔ 'ɔ \"Ju \"jru kpɔ'. ");
INSERT INTO wob_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Ɛ nʋɛ 'wɩ taan 'sʋ, ba \"blitii ‑kɔ ‑tuu\" ɛ 'bo Kana 'de Galile. Sesi de nɩ 'o 'ɛ. ");
INSERT INTO wob_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Ʋʋ 'da Sesi ke ɔɔ' klai\" nynuu ‑kɔ' ‑sɔn ‑ke. ");
INSERT INTO wob_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Nmɔ ‑kwɛa 'sʋ, Sesi de wlu' 'de ɔ ‑pee ʋ 'na : Ʋʋ se nmɔ 'ble 'bode ‑o. ");
INSERT INTO wob_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","'Sʋ Sesi 'na : \"Ju 'nynɔ, aa' tɔ' ke 'ma tɔ' se due' nɩ‑. 'Ma ‑nɛ nɔ\" se 'o nyni ke. ");
INSERT INTO wob_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","'Sʋ ʋ wlu' 'de nyʋdiidɛ \"jrii ‑gbleʋn' ‑pee, ʋ 'na : Dɛ \"klein ɔɔ mua ao ‑pee 'tmʋa' a, ao nʋ ɛ. ");
INSERT INTO wob_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","‑Ta ɛɛ nʋa kan' ‑mɛ \"soijae ‑mɛɛo\"‑ ‑nɩ 'o, Suifʋ‑wi\" a po \"ni 'di ‑wɛe ʋʋa ‑sa ‑flɛn\" kui ka ʋʋa nʋa 'de ʋʋpʋ \"bli see ɛ. Ɩa' jae tu ɛ, \"ni ‑sʋɩ 'a kwla ‑mɛ\" na a \"ji jrɩ' ‑wɛe kmɛ' 'due kwla 'sɔɔn ‑ɔ ‑ji\" jrɩ'. ");
INSERT INTO wob_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","'Sʋ Sesi wlu' 'de nyʋdiidɛ \"jrii ‑gbleʋn' ‑pee ɔ 'na : Ao \"jii‑ jae ‑nɩ \"ni ! ‑Wɛe ʋʋ po ɩ \"ni 'di 'sʋ ɩ \"ji. ");
INSERT INTO wob_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","'Sʋ Sesi 'na : Ao \"pliɛn la, ao 'je \"ju ‑ɔ ‑tea' diidɛ \"jru o i kpa. ʋʋ \"pliɛn 'sʋ ʋʋ kpɛ'. ");
INSERT INTO wob_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Diidɩ \"jruo ‑tei ‑nɔ ‑tɩan' \"ni ‑ɛ ‑snɛɛa nmɔ 'ʋn ‑nɛ wɔn 'sʋ ‑ta ɛɛ' nmɔ tu 'wlʋa ɔ se 'o juo‑, 'kaa diidɛ ‑gbleʋn ‑cria' \"ni ɛ, ‑wi\" ‑mʋ juo 'o 'ɛ 'pepe. 'Sʋ ɔ 'da 'nynɔjei 'mɛ, ");
INSERT INTO wob_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","‑wɛe ɔ wlu ɔ ‑pee ɔ 'na : Nyɔɔ 'nyɩɛ nyʋ nmɔ 'dɔe ke kpɩɩn‑, ‑wɛe ‑jɛ ‑sea wɔn nmɔ ɔ 'bɔɔ de, ‑mɛ nyʋ ‑wee' \"jii la. 'Kaa ‑mɔ ‑teɛ' nmɔ 'dɔe i mamaʋ 'sʋ ti je ka nɩ‑. ");
INSERT INTO wob_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Ka Sesi nʋa ɔɔ' \"i‑saa' jrii' nʋ sʋn, 'bo Kana 'de Galile 'kamɔ ‑nao. Ɔɔ' \"ikmaa' 'pɛɛn‑ \"kpae' 'bomu ‑wɛe ɔɔ' klai\" nynuu 'je ɔɔ' ‑tɩ' tɔ' 'ʋn. ");
INSERT INTO wob_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","'Bo ‑mɛ 'de ɛ, Sesi ke ɔ de o, ɔɔ' \"dei ‑wi\" o, ɔɔ' klai\" nynuu muɛ Kapɛnaʋm. 'Kaa ʋʋ se 'o 'wɩ ‑tuu\" nʋ. ");
INSERT INTO wob_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Suifʋ‑wi\" 'a kʋɔnkwla' 'wlʋ ‑kɔ nyʋ a 'daa‑ Pakɩ \"kʋʋan i 'sʋ, Sesi muɛ Selisalɛm. ");
INSERT INTO wob_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Ɔ paa 'e Kea ‑gbu klaa\" 'di 'sʋ, ɔ jɛɛ 'e bli' pleʋn o, 'blae pleʋn o, \"pai pleʋn o, ɛ ke 'wɛi fai\" poʋn ke, ‑mɛ ʋʋ ‑teɛ i 'de ʋʋpʋ 'a klukpa 'de. ");
INSERT INTO wob_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","'Sʋ ɔ \"duɛ \"dbu 'ʋn 'de ɔ nʋɛ klaejɔ 'ʋn ‑wɛe ɔɔ nʋ ʋʋpʋ i, ɛ ke ʋʋa' bli' ke 'blae ke. Ɔ ‑gba' 'wɛi fai\" pooʋn 'a 'wɛi mɩɩ\" ja, ɔ ‑gba' ʋʋa' klukpɩ ‑wee' ja. ");
INSERT INTO wob_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","‑Wɛe ɔ wlu 'e \"pai pleʋn ‑pee ɔ 'na : Ao ‑sa dɩ ‑nɩ ‑ta. Ao 'bo 'ʋn \"Bo 'a ‑gbu\" 'dɔɔpo‑gbu 'ʋn nʋɛ. ");
INSERT INTO wob_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","'Sʋ wlu ‑crɩɩa' 'de Kea 'a 'sbɛ 'di ɔɔ' klai\" nynuu po ɛ ‑kwlʋ o. Ɛɛ' wlu tu 'naa : 'Oo Kea, ɛɛ' ‑gbu\" 'a 'tʋn a 'dba 'ʋn 'ɛ. ");
INSERT INTO wob_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Suifʋ‑wi\" 'a \"jru kpɔ i ‑teʋn \"dua wlu 'ʋn 'sʋ ʋʋ 'na : jrii' wɛ‑ ‑ɩn nʋ kaan ‑a ‑jee' \"jriɛ 'sʋ ‑ma nʋ dɩ ‑nɩ ɛ‑ ? ");
INSERT INTO wob_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","'De Sesi 'na : Ao ‑gba' Kea ‑gbu klaa\" ‑nɛ \"jɛi‑, 'ma muɛ poa' 'de 'wɩ taan 'di. ");
INSERT INTO wob_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","'Sʋ Suifʋ‑wi\" wlu ɔ ‑pee ʋʋ 'na : ‑Ja\" ! Kea ‑gbu klaa\" ‑nɛ nyʋ poa 'de ‑sɩn 'a kwla ‑nyiiɛ 'jɔ ‑mɛɛo\"‑ 'di ɛ, ɛmɛ ‑mɔ ‑na ‑ɩn ‑je po 'de 'wɩ taan ‑gbai' 'dii ? ");
INSERT INTO wob_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","'Kaa Kea ‑gbu ‑jɛ Sesi a \"sia 'nynɩ ɛ, ɛmɛ ‑nɩ ɔɔ' nyiɔjɔ. ");
INSERT INTO wob_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Ɛmɛ ‑tɩ ‑ta Sesi sɔan \"kunyɩɔ' 'sʋ ɔɔ' klai\" nynuu po ɛɛ' wlu tu 'a ‑tɩ' ‑kwlʋ o. 'Sʋ dɩ \"klein ‑crɩɩa' ke wlu Sesi 'tmʋa 'de ɛ ʋʋ 'je ɩ tɔ' 'ʋn. ");
INSERT INTO wob_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","‑Ta Sesi nɩɩa 'o Selisalɛm, Pakɩ 'a ‑kɔ' nɔ\" ɔ, nyʋ ‑tuu\"‑tuu ‑je jrii' ‑wi\" ɔ nʋa ‑wɛe ‑ʋʋ ‑je ɔɔ' ‑tɩ' tɔ' 'ʋn. ");
INSERT INTO wob_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","'Kaa Sesi se ʋʋpʋ ‑kwlɩ\" ‑te', dɛ‑nʋɛ' ɔ juo ʋʋ ‑wee' \"klein 'mɛ. ");
INSERT INTO wob_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Dɩ \"klein ‑nɩa 'e nyiɔ pɛe o ɛ, ɔ juo ɩ ‑wee' 'mɛ. Ɛmɛ ‑tɩ nyɔ se ɛ 'bɛɛ‑ ɔ 'je nyiɔ 'ɔ ‑po' bla 'de ɔ ‑pee. ");
INSERT INTO wob_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","'Kaa \"ju due' ‑nɩ 'e Fariseɛn‑wi\" \"klu, ɔɔ' 'nynɩ ‑nɩ Nikodɛmʋ, ɔ nɩɛ Suifʋ‑wi\" 'a \"jru kpɔ' i ‑tei 'a due' ‑o. ");
INSERT INTO wob_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Ɔmɔ ‑ji' 'de Sesi o \"maʋ', ‑wɛe ‑ɔ ‑wlu ɔ ‑pee ka ‑ɔ 'na : Nyʋ dɛtɔɔi, ka ‑ɩn ‑wlʋa 'e Kea o ‑wɛe ‑ɩn ‑je ‑a dɛ tɔɔ ɛ, ‑a ‑je kan' 'mɛ, dɛ‑nʋɛ' jrii' ‑wi\" ‑ma nʋa nyɔ jrɔ' se ɛ 'bɛɛ‑ ɔ 'jɩ nʋ ‑bo Kea se ɔ o sie ɛ. ");
INSERT INTO wob_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Sesi wlu ɔ ‑pee, ɔ 'na : 'Ma 'tmʋʋɛ ‑ʋn tɔ' ‑tɩ 'a tɔ' ‑tɩ, nyɔ ‑sea' 'wlʋa' dee 'wlʋ ɛ, ɔ se ɛ 'bɛɛ‑ ɔ 'je Kea 'a 'bɩɔ dɛ 'je. ");
INSERT INTO wob_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","'Sʋ Nikodɛmʋ ‑tee' ɔ i, ɔ 'na : Ka nyɔ ‑kpa ‑kea\" ‑mɔ 'je 'wlʋa' dee 'wlʋsʋn nʋ ɛ‑ ? Ɔ 'je 'de ɔ de 'di de mu ‑o ‑wɛe ɔ 'e 'wlʋ ke'wlɛɛ ? ");
INSERT INTO wob_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Sesi 'na : tɔ' ‑tɩ 'ma 'tmʋʋ ‑ʋn, ‑bo nyɔ se 'wlʋ 'de \"ni ke ‑suu 'ʋn ɔ se 'bɛɛ‑ ɔ 'je 'e Kea 'a Tʋ\"bo ‑kwlɔ 'di pa. ");
INSERT INTO wob_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Dɛ ‑wlʋa 'e nyiɔ 'ʋn ‑mɛ nɩɛ nyiɔ ‑o, ‑wɛe dɛ ‑wlʋa 'e Kea 'a ‑Suu 'ʋn ‑mɛ nɩɛ Kea 'a dɛ ‑o. ");
INSERT INTO wob_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","‑Bo 'ɩn 'na ao 'je 'wlʋa' dee 'wlʋ ɛ, tai' 'bo ‑ʋn ‑maa\"‑. ");
INSERT INTO wob_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","‑Ma ‑jee', ‑ta poɔ' nɩai\" 'bo ɛɛ muu, 'de ‑ma ‑wɔn ɛɛ' ‑si' wlu 'mɛ, 'kaa ‑ta ɛɛ 'wlʋa, ‑ta ɛɛ mua, ‑ɩn se 'o juo‑. 'Kamɔ ɛ nɩ ‑ke 'de nyɔ ‑ɔ ‑wlʋa 'de Kea 'a ‑Suu 'ʋn 'a ‑tɩ' 'ʋn. ");
INSERT INTO wob_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","'Sʋ Nikodɛmʋ 'na : Ka ‑mɛ 'ɛ dɛ tu 'je nʋʋɛ 'emu ɛ‑ ? ");
INSERT INTO wob_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","'De Sesi 'na : ‑Mɔ ‑nɩa Israɛ‑nyʋ 'a dɛtɔɔi klaa\" a, ‑ɩn se dɩ ‑nɩ ‑mɩ juoo‑ ? ");
INSERT INTO wob_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","'Ma 'tmʋʋɛ ‑ʋn tɔ' ‑tɩ, dɛ ‑a ‑juua, ɛmɛ ‑aa ‑tmʋ 'de dɛ \"o dɛ ‑a ‑jea a ɛmɛ ‑ɛɛ ‑po' ‑aa bla, 'kaa ‑po' ‑aa bla a aoa' ‑tuɛ\" doin\". ");
INSERT INTO wob_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","‑Bo 'ma sea 'blʋa‑ \"kpei dɩ 'a ‑tɩ' 'tmʋ, ‑wɛe aoa' 'je ‑mɩ tɔ' 'ʋn 'ee, ‑mɛ ‑bo 'ma sea jaʋn 'di dɩ 'a ‑tɩ' 'tmʋ 'ee, ka ao 'je ɩa' tɔ' 'ʋn 'jesʋn nʋ ɛ‑ ? ");
INSERT INTO wob_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Nyɔ \"o nyɔ jrɔ' se 'e jaʋn 'di mu due', ‑bo ɛ se nyiɔ 'ɔ \"Ju ‑ɔ ‑wlʋa 'e jaʋn 'di nɩ ɛ. ");
INSERT INTO wob_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","'De ka Moisɩ crooa ‑tiɛn‑sɛn tu \"i 'de ‑pɩɩɔn\" blʋa \"kpei ɛ, 'kamɔ nyiɔ 'ɔ \"Ju 'je 'o tu ‑kwlɩ\" kɔɔɛ ‑ke, ‑wɛe ʋʋ 'je ɔ inynaa‑. ");
INSERT INTO wob_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","'De nyɔ \"o nyɔ ‑je ɔɔ' ‑tɩ' tɔ' 'ʋn ɛ, ɔ 'e 'kmʋnɩa' ‑sea' \"ti ‑ta 'ble 'je. ");
INSERT INTO wob_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Dɛ‑nʋɛ' Kea 'a nyiɔ 'ɔ ‑tɩ' kmaa' ‑siɛ' sʋn' i. Ɛmɛ ‑tɩ ɛ ‑tu\" ‑wɛe ɛ to 'e ɛɛ' \"Ju jɔ due' koʋn ‑gbai' 'de nyɔ \"o nyɔ ‑jea ɔɔ' ‑tɩ' tɔ' 'ʋn je ‑tuɔn blu 'kaa ɔɔ muɛ 'kmʋnɩa' ‑sea' ‑kwɛ‑ ‑ta 'ble 'jea. ");
INSERT INTO wob_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Kea mɛ 'de ɛ, ɛ se ɛɛ' \"Ju 'nɔ 'kmʋ \"kpei dbo 'de ɔ 'e nyiɔ 'pee kpʋʋn‑, 'kaa ɛ dboɔ' ‑wɛe nyiɔ 'je 'pʋʋa' 'je 'de ɔ 'ʋn. ");
INSERT INTO wob_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Nyɔ ‑jea ɔɔ' ‑tɩ' tɔ' 'ʋn ɛ, 'pee se ɔ kpʋn i, 'kaa nyɔ ‑sea' ɔɔ' ‑tɩ' tɔ' 'ʋn 'je ɛ, 'pee kpʋn ‑mɔ 'mɛ sese, dɛ‑nʋɛ' ɔ se Kea 'a \"Ju jɔ due' koʋn ‑gbai' 'a ‑tɩ' tɔ' 'ʋn 'je. ");
INSERT INTO wob_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","'De ɛɛ' 'pee tu mɛ ‑nɩ : ‑Sɔn' ‑jia' 'nɔ 'kmʋ \"kpei ɛ, nyiɔpʋ se ɛ \"inɩ‑, 'kaa kwie mɛ ʋʋa ‑pɔn, dɛ‑nʋɛ' ʋʋa' nʋʋdɩ nyniɛ \"jrii. ");
INSERT INTO wob_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Nyɔ \"o nyɔ ‑ɔɔ nʋʋkplɩn nynia \"jrii ɛ, ɔ 'nyɛ ‑sɔn' 'ʋn 'ɛ, ‑sɔn'ɔ faʋn a nʋɔ', dɛ‑nʋɛ' ɔɔ plee ɔɔ' kplɩn 'a \"kpae' 'pɛɛan' 'mɛ 'de ‑sɔn' 'ʋn. ");
INSERT INTO wob_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","'Kaa nyɔ ‑ɔɔ nʋa tɔi\" dɩ ɛ, ɔmɔ ‑ɔɔ ji 'e ‑sɔn' 'ʋn ‑wɛe ka ɔɔ 'jea Kea wɔn ɛ, nyʋ a 'je ɛ i 'pepe 'de ɔɔ' nʋʋdɩ 'ʋn. ");
INSERT INTO wob_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","'Bo ‑mɛ 'de ɛ, Sesi ke ɔɔ' klai\" nynuu muɛ 'e Suideblʋa \"kpei. 'Bomɔ ɔ ke ʋʋ nʋ 'wɩ pla‑, ‑wɛe ɔɔ po nyʋ \"ni \"jru. ");
INSERT INTO wob_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","San foo\" 'sʋ a poɛ nyʋ \"ni \"jru ‑ke 'bo Enon, ɛ ke Salimʋ \"kʋʋan‑ i. 'Bomɔ \"ni ‑tuu\" nɩ‑, ‑wɛe nyiɔpʋ a mu 'de ɔ o, 'de ɔɔ po ʋʋ \"ni \"jru. ");
INSERT INTO wob_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","‑Mɛ San se ‑kaso 'di mu ke. ");
INSERT INTO wob_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","'Sʋ San 'a klai\" nynuu 'a jrʋ' ke Suifʋi due' ‑teɛ ba o ‑tooa' ‑pʋn\" 'de dɩ nyʋ 'jea 'a nʋ ‑wɛe ʋʋ 'jea 'e Kea \"jri 'dei nmɔɔ 'ɔ ‑tɩ' 'ʋn. ");
INSERT INTO wob_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Ʋʋ jiɛ 'e San o, 'de ʋʋ 'na : ‑Aa dɛtɔɔi, \"ju ‑ɔ ‑ke ‑ɩn ‑nɩa 'e Sudɛn ‑gbuu 'de 'deɛ, ‑wɛe ‑ɔɔ ‑tɩ' ‑ɩn ‑tmʋa 'de ‑a ‑pee ɛ, ‑ɩn ‑gbʋn 'nɔ, ɔmɔ ‑ɔɔ poa nyʋ \"ni \"jru 'nɩa‑ ‑ke, nyʋ ‑tuu\"‑tuu a muɔ o ! ");
INSERT INTO wob_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","'De San wlu ka ɔ 'na : Nyɔ \"o nyɔ se ɛ 'bɛɛ‑ ɔ 'e dɛ 'ble ‑bo Kea 'a ‑cɛ\" 'kpa se ɔ \"nyɩ ɛ. ");
INSERT INTO wob_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","‑Ta 'ɩn wluua ‑wɛe 'ɩn 'na 'ɩn se Klisɩ nɩ ɛ aoa' ‑cɛ\" 'kpa 'je ɛɛ' ‑ta 'mɛ. 'kaa 'ɩn 'na 'ɩn nɩɛ ɔɔ' \"juɔi nai ‑o. ");
INSERT INTO wob_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Nyɔ ‑blea 'nynɔ ɛ, ɔmɔ ‑nɩ 'nynɔjei. 'Kaa 'nynɔjei 'a \"dɛi ‑mɔ nɩɛ 'bo ɔ ‑pʋn\" ‑wɛe ɔɔ po ɔɔ' wlu doin\" o, ‑wɛe dɩ ɔɔ 'tmʋ, ɩ 'ble ɔɔ' 'mʋa‑. Ɛmɛ ‑tɩ 'ma ‑nɛ 'mʋa‑ 'ma nʋa nɩ 'pepe. ");
INSERT INTO wob_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Ɔmɔ 'ɔ 'nynɩ 'je \"jɛi mu ‑o, ‑wɛe 'ma ‑nɛ 'nynɩ 'e ‑sɔn ji. ");
INSERT INTO wob_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Nyɔ ‑ɔ ‑wlʋa 'e jaʋn 'di, ɔ nɩɛ 'o nyʋ ‑wee' \"klein \"jru kpɔ', 'de nyɔ ‑ɔ ‑nɩa 'nɔ 'blʋa‑ \"kpei ɛ, ‑mɔ nɩɛ 'blʋa 'a nyɔ ‑o, ‑wɛe ɔɔ 'tmʋ 'bluadidɩ 'a 'sʋ 'a ‑tɩ', 'de nyɔ ‑wlʋa 'e jaʋn 'di, ‑mɔ nɩɛ 'o dɩ ‑wee' \"klein \"jru kpɔ'. ");
INSERT INTO wob_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Dɩ ɔ 'jea 'de ɔ 'wɔan, ɩmɩ ɔɔ 'tmʋ, 'kaa nyɔ ‑ɔ ‑jea ɔɔ' ‑tɩ' 'wɔɔn‑, ɔ se nɩ‑. ");
INSERT INTO wob_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Nyɔ ‑jɔ ‑wɔɔan' ɔɔ' ‑tɩ' ɛ, ‑mɔ 'na Kea nɩɛ tɔ' ‑o. ");
INSERT INTO wob_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Nyɔ Kea dboa, ɔɔ 'tmʋɛ Kea 'a wlu, dɛ‑nʋɛ' Kea ‑kwɛ‑ ɛɛ' ‑Suu \"kpei‑ ɛ je ɔ \"nyɩ, ɛ se ɛ dbaa‑. ");
INSERT INTO wob_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","\"Bo kma \"ju 'a ‑tɩ', ɛmɛ ‑tɩ ɛ ‑te' ɔ dɩ ‑wee' kwa. ");
INSERT INTO wob_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Nyɔ ‑jea Kea 'a \"ju 'a ‑tɩ' tɔ' 'ʋn ɛ, ɔ 'jeɛ 'kmʋnɩa' ‑sea' ‑kwɛ ‑ta 'ble ɛ, 'kaa nyɔ ‑sea' Kea 'a \"ju 'a ‑tɩ' tɔ' 'ʋn 'je ɛ, ɔ se 'kmʋnɩa' 'je i, ‑mɛ Kea 'a 'cɛn ‑nɩ ɔ \"kpei. ");
INSERT INTO wob_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Fariseɛn‑wi\" 'wɔn ɛ ka Sesi a 'da nyʋ ‑tuu\"‑tuu ‑wɛe ɔɔ' klai\" nynuu a 'kpa \"kpei 'de ɔɔ po nyʋ \"ni \"jru ɛ ‑sii San. ");
INSERT INTO wob_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","'De tɔ' ‑tɩ 'ʋn ɛ, Sesi 'a ‑cɛ\" 'kpa 'a po nyʋ \"ni \"jru ‑bo ɛ se ɔɔ' klai\" nynuu nɩɛ. ");
INSERT INTO wob_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Sesi 'wɔan dɛ ʋʋa 'tmʋa ‑nɛ 'sʋ, ɔ 'wlʋ 'e Suide 'mɛ ‑wɛe ɔ mu 'e Galile de. ");
INSERT INTO wob_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","‑Bo ɔ 'je 'emu ɛ, ɔ 'je Samadiblʋa 'ʋn ‑tie\" cɛn ‑o se. ");
INSERT INTO wob_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","'Sʋ ɔ nyniɛ 'o Samadi 'a ‑kwlɔ due' nyʋ a 'daa‑ Sikaa ‑pʋn\". Ɛɛ' ‑kwlɔ tu ke ‑kle' Sakɔbʋ \"nyɩa ɔɔ' \"ju Sosɛʋ tɛin\" \"kʋʋan‑ i. ");
INSERT INTO wob_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","'Bomɔ Sakɔbʋ 'a \"nibie nɩ‑. Sesi na ɔ sea 'sʋ ɛ, ɔ ‑teɛ i 'bo \"nibie wɔin\", ‑mɛ 'jrʋ ‑teɛ ‑gbao. ");
INSERT INTO wob_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","'Sʋ Samadi 'nynɔ due' ‑jia' \"niɔ‑ mʋ Sesi wlu ‑pee ɔ 'na : A \"nyɩ 'ʋn \"ni 'ɩn 'je 'na. ");
INSERT INTO wob_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","‑Ta ɛɛ nɩa kan' ‑mɛ ɔɔ' klai\" nynuu muɛ diidɛ ‑tɩan' 'de ‑kwlɔ. ");
INSERT INTO wob_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","'Sʋ Samadi 'nynɔ ‑nʋ wlu' 'de Sesi ‑pee, ʋ 'na : Ɛ dɛ‑, ‑mɔ ‑nɩa Suifʋi ɛ, ‑mɔ ‑ɔɔ ‑dbaa' 'mɔ ‑nɩa Samari 'nynɔ \"ni ? 'De see ɛ, Suifʋ‑wi\" ke Samadi kɔʋn 'nyɩɩɛ 'ʋn 'ɛ, ʋʋa' poo wɔn o. ");
INSERT INTO wob_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","'Bomɔ Sesi 'na : bo a juo dɛ Kea a \"nyɩa nyʋ foo\" 'ʋn 'de ɛ, 'de \"ju ‑jɔ ‑ɔɔ ‑dbaa' aʋn \"ni ‑bo a juo ‑mɔ ‑ke 'de ɛ, ‑mɛ ɔmɔ a 'je ‑ɔ \"ni 'dbaa 'de‑, ‑wɛe ‑ɔ ‑je aʋn \"ni ‑ɛ sea ma ‑ta 'ble \"nyɩ. ");
INSERT INTO wob_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","'Nynɔkpao' ‑nʋ 'na : \"Bo, ‑mɔ ‑sea' \"ni ‑cri' ‑dɛ 'ble, 'de \"nibie tɛan 'di 'ee, ‑ta ‑mɔ ‑je 'kmʋ nɩ ni ‑mɛ ‑sa ‑wɛe ‑ɩn ‑je ɛ 'mɔ \"nyɩ ɛ‑ ? ");
INSERT INTO wob_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","‑Mɔ ‑bɛ\"i ‑ɩn ‑je ‑a 'mɩa Sakɔbʋ ‑nyɩ\" ‑a \"nibie ‑nɛ ‑sii ? Ɔɔ' ‑cɛ\" 'kpa ke ɔɔ' \"nynuu‑ ke ɔɔ' nɔ\" dɩ 'na ɛɛ' \"ni tu 'mɛ. ");
INSERT INTO wob_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","'Sʋ Sesi 'na : Nyɔ \"o nyɔ ‑na \"ni ‑jɛ ‑mɛ ɛ, \"ni 'natʋn a mu ɔ nʋa' ke'wlɛ. ");
INSERT INTO wob_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","'Kaa nyɔ ‑na \"ni 'ma mu ɔ \"nyɩa', \"ni 'natʋn se ɔ nʋi 'bode. 'De \"ni 'ma mu ɔ \"nyɩa' ɛɛ muɛ 'kmʋnɩ ni 'a \"jru nɩa' 'de ɔ 'ʋn 'bomɔ 'kmʋ ‑sea' ‑kwɛ ‑ta 'ble 'je 'wlʋ ‑wɛe ɛ 'je i ‑si'. ");
INSERT INTO wob_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","'Sʋ 'nynɔkpao' ‑nʋ 'na : Tʋ\"bo ‑ɩn ‑nyɩ\" 'ʋn ɛɛ' \"ni tu 'de \"ni 'natʋn je 'ʋn nʋ ‑wɛe 'ɩn je \"ni ‑cria' ji ‑ta 'bode. ");
INSERT INTO wob_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","'Sʋ Sesi 'na : A mu a 'da aa' kʋan ‑mɛ a ji de ‑ta. ");
INSERT INTO wob_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","\"Ju nynɔkpao' ‑nʋ ‑sɛ \"kpei ʋ 'na : 'Ɩn se kʋan 'ble. Sesi 'na : A ‑sa tɔ' a je wlu ka : 'Ɩn se kʋan 'ble, ");
INSERT INTO wob_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","dɛ‑nʋɛ' a 'ble kʋan ‑wi\" ‑mm\" ‑wɛ‑ 'de‑, 'de ‑jɔ a nɩa 'e 'kwa kaan ‑mɔ se aa' kʋan nɩ ‑ke. 'De ‑mɛ 'ʋn ɛ, a 'tmʋɛ tɔ' ‑tɩ. ");
INSERT INTO wob_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","'Sʋ ʋ 'na : Tʋ\"bo, dɛ 'ma 'jea i 'de ‑ɩn 'ʋn ɛ, ɛmɛ ‑nɩ ‑ɩn ‑nɩɛ Kea 'a wlu 'kwajaai ‑o. ");
INSERT INTO wob_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","‑A \"bo ‑wi\" ‑gbɛɛ Kea \"juɔi 'bo crʋ ‑nɛ \"kpei, 'de aopʋ mɔ ɛ, ao 'na ‑ta nyʋ 'jea Kea \"juɔi ‑gbɛɛ' 'bo ‑nɩ Selisalɛm. ");
INSERT INTO wob_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","'De Sesi 'na : 'Nynɔkpao', a ‑gbʋn 'nɔ, nɔ\" jrɛ' ‑ɛɛ mu nynia' ‑wɛe ao se Kea ‑nɩa \"Bo \"juɔi ‑gbɛɛ i 'bo Selisalɛm ke crʋ ‑nɛ \"kpei. ");
INSERT INTO wob_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Aomɔ se dɛ aoa ‑gbɛɛa' juo‑, 'kaa ‑apʋ mɔ ɛ, dɛ ‑aa ‑gbɛɛ' a ‑a ‑juuɛ', dɛ‑nʋɛ' 'pʋʋa' cɛɛn 'e ‑a o Suifʋ 'ʋn. ");
INSERT INTO wob_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","'Mɔ ‑tmʋʋ' aʋn, nɔ\" jrɛ' ‑ɛɛ mu nynia', 'de ɛ nyni' ‑wɛ‑ mɔ. 'Bomɔ ‑gbɛɛʋn ‑cɔʋn' 'je \"Bo ‑gbɛɛ' ‑ta \"o ‑ta 'de ‑Suu ke tɔ' ‑tɩ 'ʋn. Dɛ‑nʋɛ' ‑gbɛɛʋn \"Bo a ‑pɔn a i ʋʋ ‑nao. ");
INSERT INTO wob_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Kea nɩɛ ‑Suu ‑o, ɛmɛ ‑tɩ nyʋ ‑a ‑gbɛɛ' ɛ \"juɔi ɛ, ʋʋ 'je ɛ \"juɔi ‑gbɛɛ' ‑o 'de ɛɛ' ‑Suu ke tɔ' ‑tɩ 'ʋn. ");
INSERT INTO wob_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","'Sʋ 'nynɔkpao' ‑nʋ 'na : 'Ɩn 'je kan' 'mɛ, Mesi, nyʋ a 'daa‑ Klisɩ ɛ, ɔɔ muɛ jia'. ‑Bo ɔ ji ‑wɛe ɔ 'je dɩ ‑wee' \"klein wɔ ‑sa 'de ‑a ‑pee. ");
INSERT INTO wob_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","'Sʋ Sesi 'na : Ɛ nɩ 'mɔ ‑ɔ ‑nɩa aʋn ‑pee wlua ‑ta. ");
INSERT INTO wob_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Ʋʋ siɛ wlua' Sesi 'a klai\" nynuu je de ji, 'sʋ dɛ ɔ ke 'nynɔkpao' ‑nʋ a wlua ɛɛ' tai' \"maa ʋʋpʋ 'mɛ, 'kaa ʋʋa' due' se nʋ : Dɛ ‑ma ‑tee' ʋ i ɛ‑ ? 'De dɛɛ‑tɩ ʋ ke ‑ma ‑tmʋ ɛ‑ ? ");
INSERT INTO wob_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","'Nynɔkpao' ‑nʋ siɛ ʋa' \"nijae 'mʋa‑, 'sʋ ʋ muɛ nyʋ 'tmʋa' 'de ‑kwlɔ. ");
INSERT INTO wob_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","Ʋ 'na : Ao ji \"ju ‑nɔ 'je, dɩ \"klein 'ɩn nʋa ɩmɩ ɔ \"si 'nynɩ, ɔ se Klisɩ nɩ ‑taa mɔɔ ? ");
INSERT INTO wob_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Ʋʋ 'wɔan wlu ‑nɛ 'sʋ ʋʋ ‑wee' ‑kwɛ 'e ‑kwlɔ i ‑wɛe ʋʋ mu Sesi \"jriɛ 'jeea. ");
INSERT INTO wob_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","‑Ta ɛɛ nʋʋa kan' 'sʋ klai\" nynuu a crɛɛ Sesi \"kpei dɛdi ‑tɩ, ʋʋ 'na : ‑Aa dɛtɔɔi, ‑ɩn di dɛ ke 'de ! ");
INSERT INTO wob_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","'Sʋ ɔ wlu' 'de ʋʋpʋ ‑pee ɔ 'na : 'Ɩn 'bleɛ diidɛ jrɛ', ao se juo‑. ");
INSERT INTO wob_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","'Sʋ klai\" nynuu a ‑teeɛ' ba i due 'due, ʋʋ 'na : Nyɔ jrɔ' ‑jɔ diidɛ ‑aee' ? ");
INSERT INTO wob_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","'Sʋ Sesi ‑sɛ \"kpei ɔ 'na : 'Ma diidɛ mɛ ‑nɩ \"ju ‑ɔ dboa 'ʋn 'a ‑kwlʋtɩ nʋa', ke dbo ɔ \"nyɩa 'ʋn 'a \"i ‑kɔa' ‑ke. ");
INSERT INTO wob_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Aoa wlu' kaan ao 'na 'cʋɩ ‑nyiiɛ' ‑sie 'o ‑wɛe nyʋ 'e ko cɛn, 'kaa 'mɔ 'na ao kpa \"jri \"jɛi, ao ‑gbʋʋn' ‑kle' \"kpei, ko ‑fluu\" ‑wɛe ɩ ‑teɛ cɛn‑tɩ. ");
INSERT INTO wob_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Nyɔ ‑ɔɔ cɛan ko ɛ, ‑mɔ 'je ɔɔ' ‑kei\" 'mɛ see, ‑wɛe ɔɔ 'kɩɩn‑ ɩa' 'jɔ \"jrui 'de 'kmʋnɩa' ‑sea' ‑kwɛ ‑ta 'ble 'a ‑tɩ' 'ʋn. ‑Bo ɛ nɩ kan' ‑mɛ nyɔ ‑poa' ko ke nyɔ cɛan ko ke ʋʋ ‑wee' a muɛ 'mʋa‑ nʋa' ‑tadue. ");
INSERT INTO wob_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","'De ɛɛ' ‑tɩ' 'ʋn ɛ, dɛ nyʋ a 'tmʋa nɩɛ tɔ' ‑o, nyʋ 'na : Nyɔ due' po ko ‑wɛe deejrɔ' 'je ɛ cɛn. ");
INSERT INTO wob_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","‑Kle' ‑ɛɛ dbo ao sea nʋ ɛ, ɛmɛ ‑ɛ 'di 'ɩn dbo ao ko cɛan'. Nyʋ jrʋ' ‑nʋ' ɛɛ' dbo ‑wɛe aopʋ mɔ paa 'bo ʋʋpʋ 'a dbo \"kpei. ");
INSERT INTO wob_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","'De 'nynɔkpao' ‑nʋ 'na : ɔ 'tmʋ dɩ \"klein 'ɩn nʋa 'mɛ 'de 'ʋn ‑pee, ɛmɛ ‑nʋɛ' ‑wɛe Samadi kɔʋn ‑tuu\"‑tuu 'je Sesi 'a ‑tɩ' tɔ' 'ʋn 'bo ɛɛ' ‑kwlɔ ‑tu 'di. ");
INSERT INTO wob_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Ɛmɛ ‑tɩ ‑ta Samaditɛn nyʋ jia 'de ɔ o ʋʋ bae ɔ i 'de ɔ ke ʋʋ 'je i ‑te. 'Sʋ ɔ nʋɛ 'wɩ 'sɔɔn 'mʋa‑. ");
INSERT INTO wob_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Nyʋ ‑tuu\"‑tuu ‑je ɔɔ' ‑tɩ' tɔ' 'ʋn ke'wlɛ, dɛ‑nʋɛ' ʋʋ 'wɔn ɔɔ' ‑cɛ\" 'kpa 'a wlu. ");
INSERT INTO wob_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","‑Wɛe ʋʋ wlu' 'e 'nynɔkpao' ‑pee, ʋʋ 'na : Kaan ka ‑a ‑je ɔɔ' ‑tɩ' tɔ' 'ʋn 'ɛ, ɛ se dɛ a 'tmʋa 'de ‑a ‑pee ‑mɛɛ' 'sʋ 'a ‑tɩ' nɩ‑, 'kaa ‑aa' ‑cɛ\" 'kpa 'wɔn ɔɔ' wlu 'mɛ, ɛmɛ ‑tɩ ‑a ‑je kan' ‑cɛɛn'‑ ka ɔ nɩa 'blʋa ‑wee' \"klein 'a 'pʋʋi ɛ. ");
INSERT INTO wob_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","'Wɩ 'sɔɔn ‑nɩ ‑sia' 'sʋ Sesi 'wlʋ 'mʋa‑ 'mɛ, ‑wɛe ɔ mu 'e Galile, ");
INSERT INTO wob_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","dɛ‑nʋɛ' ɔɔ' ‑cɛ\" 'kpa 'tmʋʋɛ' : Nyɔ 'ɔ ‑te' Kea 'a wlu 'kwajaai 'a ni' 'de ɔɔ' ‑cɛ\" 'ɛ 'blʋa‑ 'di see. ");
INSERT INTO wob_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","‑Ta ɔ nynia 'de Galile ɛ, ʋʋ kpʋʋn ɔ sɩn 'sɔɔn ka ‑cɔɔn' ka, dɛ‑nʋɛ' ʋʋ 'wlʋɛ Pakɩ 'a ‑kɔ' ‑sɔn 'de Selisalɛm ‑ke, 'bomɔ ʋʋ 'jee‑ dɩ \"klein ɔ nʋa 'o ‑kɔ' ‑sɔn \"jriɛ‑. ");
INSERT INTO wob_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","'Sʋ ɔ muɛ Kana de ‑ta ɔ nʋʋa \"ni nmɔ 'ʋn 'de ɛ, 'bomɔ \"jrujei klaa\" due' nɩ‑ ɔɔ nʋ 'beɔ 'ɔ dbo. Ɔmɔ ‑ɔɔ \"ju 'a dɛ ɛ pooa 'bo Kapɛnaʋm. ");
INSERT INTO wob_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Ka Sesi 'wlʋa 'e Suide ɔ jia 'e Galile ɔ 'wɔɩn 'sʋ ɛ, ɔ muɛ 'de ɔ o, ‑wɛe ɔ bae ɔ i 'de ɔ 'je Kapɛnaʋm mu, ɔ 'je ɔɔ' \"ju ‑ɔɔ jia 'mɛa' 'pʋʋ‑. ");
INSERT INTO wob_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","'Sʋ Sesi 'na : ‑Bo ao se jrii' ke dɩ klae\" \"jriɛ‑ 'jee‑ ɛ, ‑mɛ aoa' 'je 'ma ‑tɩ' tɔ' 'ʋn. ");
INSERT INTO wob_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","\"Jrujei ‑nɔ 'na : 'Ma 'blei, ‑ta 'ma \"ju sea 'mɛɛ ke ɛ, ‑ɩn ‑nya\" ‑a mu ‑too\"‑. ");
INSERT INTO wob_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","'De Sesi 'na : ‑Ɩn mu, ‑ma \"ju 'pʋʋ. Dɛ Sesi 'tmʋa 'mʋa‑, \"ju ‑nɔ 'je ɛ tɔ' 'ʋn 'ɛ, 'sʋ ɔ muɛ ‑kwlɔ. ");
INSERT INTO wob_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","‑Ta ɔɔ mua de ɛ, 'bomɔ ɔɔ' dbonʋʋn ‑a 'jɔɔ \"i ke ɔ ‑gbʋʋn', ‑wɛe ʋʋ wlu ɔ ‑pee ka, ʋʋ 'na : ‑Ma \"ju 'pʋʋ. ");
INSERT INTO wob_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Ɔ ‑teeɛ' ʋʋpʋ i, ɔ 'na : Blaa nɔ\" ɔ nɩ nma\" ka a‑ ? 'Sʋ ʋʋ 'na : ‑Saan' 'a ‑kwie\" jrʋ ‑gbao o mɛ ɔɔ' 'wɛ‑ 'bɔ. ");
INSERT INTO wob_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","'Sʋ ka ɛ nɩa 'e nɔ\" ‑nɩa 'mʋa‑ 'di mɛ Sesi 'na : ‑Ɩn mu, ‑ma \"ju 'pʋʋ, 'sʋ \"ju ‑saan\" \"bo po ɛ ‑tɩ' ‑kwlʋ o, 'sʋ ɔ ke ɔɔ' ‑gbu\" ‑sɔn nyʋ ‑wee' 'jeɛ Sesi 'a ‑tɩ' tɔ' 'ʋn. ");
INSERT INTO wob_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","‑Ta Sesi 'wlʋa Suide ‑wɛe ɔ mua 'e Galile ɛ, jrii' ɔ nʋa ɩa' kpɛ 'sɔɔn ‑nɛ ‑nao. ");
INSERT INTO wob_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","'Bo ‑mɛ 'de ɛ, Suifʋ‑wi\" a ‑tuɛ\" ‑kɔ' jrɛ' ɛmɛ Sesi mu 'ʋn 'bo Selisalɛm. ");
INSERT INTO wob_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","'De Selisalɛm blaa blo' 'dei ‑wɛe ɛɛ' blo' 'ble wɔn ‑tuu\". Ɛɛ' wɔn due' 'a 'nynɩ ‑nɩ 'blae 'a ‑gbɛin\" ‑je. ‑Pue\" wlo' due' ‑nɩ 'o, ɛɛ' 'nynɩ ‑nɩ Betɛsida 'de Suifʋwlu 'di. 'Bomɔ ʋʋ poo faa ‑mm\". ");
INSERT INTO wob_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Ɩmɩ 'Wɛnʋʋn 'pɛn ‑sɔn i blibli. \"dɔʋn o, nyʋ ‑ʋʋa ‑kpaa' ‑gbɔʋn\" \"kpei o, klɔɔʋn ke. ʋʋ ‑wee' a fuɛ \"ni 'a i‑suua', ");
INSERT INTO wob_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","dɛ‑nʋɛ' Tʋ\"bo 'a \"soai due' ‑a ji kpɛ due 'due 'de ‑ɔɔ ‑suua' \"ni i, ‑wɛe ‑bo 'wɛ‑nʋi ‑jɔ ‑saa \"i ‑ɔ ‑kpa 'o \"niɔ‑ 'sʋ ɛ, ka \"o ka mɔ'ɔ 'wɛ‑ 'je ɛ nɩ ɛ, ɛ 'bɔɔ. ");
INSERT INTO wob_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","'Bomɔ \"Ju due' ‑nɩ ‑ɔ nʋ 'o 'wɛ blʋɔ ‑sɩn 'a kwla taan 'jɔ ‑mɛ\" na. ");
INSERT INTO wob_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Ka 'wɛ‑ ‑kwle ɔ ‑pʋn\" ‑wɛe ɔ 'pɛan i Sesi 'jea kan' 'sʋ ɔ ‑tee' ɔ i, ɔ 'na : ‑Ɩn ‑nɩɛi\" 'mɛ ‑ɩn ‑je 'pʋʋ ? ");
INSERT INTO wob_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","'Sʋ 'wɛ‑ nʋi ‑nɔ 'na : Tʋ\"bo nyɔ ‑bo \"ni ‑suua' i ‑wɛe ɔ 'je 'ʋn 'bo \"niɔ‑ po ɛ, 'ɩn se ɔ 'ble. Nɔ\" ‑tɩ 'ɩn 'jea 'ʋnsɔn ‑mɛ nyɔ jrɔ' \"siɛ i 'bo 'ʋn \"juɔi sese. ");
INSERT INTO wob_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","'Sʋ Sesi 'na : ‑Ɩn sɔn 'ʋn, ‑ɩn ‑duo\" ‑ma srɛ' 'ʋn, ‑ɩn ‑je na‑. ");
INSERT INTO wob_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","'Bo ɛ \"sri \"ju ‑nɔ je 'pʋ. Ɔ \"dua ɔɔ' srɛ' 'ʋn 'sʋ ɔ ‑teɛ naa' ‑pʋn\". Dɛ ‑nʋʋa 'mʋa‑ ɛ nɩ 'bo ‑kwlewɩ \"kpei ‑o, ");
INSERT INTO wob_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","ɛmɛ ‑tɩ Suifʋ‑wi\" wlu 'de \"ju ‑nɔ ‑pee ʋʋ 'na : ‑Kwlewɩ ‑nɩ ‑sɩan, ‑ɩn se ɛ 'bɛɛ‑ ‑ɩn ‑je ‑ma srɛ' 'ble. ");
INSERT INTO wob_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","'Sʋ ɔ 'na : \"Ju ‑pʋʋa' 'ʋn mɔ ‑na ‑ɩn ‑duo\" ‑ma srɛ' 'ʋn, ‑ɩn ‑je na‑. ");
INSERT INTO wob_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","'De ʋʋ 'na : \"Ju ‑na ‑ɩn ‑duo\" ‑ma srɛ' 'ʋn ‑ɩn ‑je na ‑mɔ 'ɔ 'nynɩ wɛ‑ ? ");
INSERT INTO wob_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","'Kaa \"ju ‑a 'wɛ‑ 'bɔa se nyɔ ɛ nɩa juo‑, dɛ‑nʋɛ' Sesi \"maa' 'de nyʋ \"klu. ");
INSERT INTO wob_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Ɛ 'wlʋa 'o mu ɛ, Sesi jɛɛ \"ju ‑ɔ ‑pʋa ‑nɔ 'mɛ 'de Kea ‑gbu klaa\" 'di, ‑wɛe ɔ wlu ɔ ‑pee ɔ 'na : ‑Ɩn ‑pʋʋ' ‑wɛ‑ la, 'kaa ‑ɩn ‑bɔ dɛsaʋn nʋ‑tɩ 'bode, ‑wɛe ‑jɛ ‑ɛɛ mua ‑ʋn \"jrii nʋʋa' de'bɔɔ‑ nɔ\" je ‑je \"kpei ‑tie\" cɛn. ");
INSERT INTO wob_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","'Sʋ \"ju ‑nɔ mu', ‑wɛe ka Sesi 'pʋʋ‑ ɔ, ɔ 'tmʋ ɛ 'de Suifʋ‑wi\" ‑pee. ");
INSERT INTO wob_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Ɛmɛ ‑tɩ Suifʋ‑wi\" a ‑pɔn Sesi 'a ‑kɔ i, dɛ‑nʋɛ', ɔ 'pʋʋɛ nyɔ 'bo ‑kwlewɩ \"kpei. ");
INSERT INTO wob_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","'Kaa Sesi wlu' 'de ʋʋ ‑pee ɔ 'na : 'Ɩn \"Bo a nʋɛ dbo 'wɩ \"o 'wɩ ‑wee' 'di 'de 'ma nʋɛ dbo ‑ke. ");
INSERT INTO wob_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","'De wlu ‑nɩa 'mʋa‑ \"kpei ɛ, Suifʋ‑wi\" 'a \"jru kpɔ' i ‑teʋn 'a ‑pɔn Sesi 'a 'dbaa' ‑kɔ i ke'wlɛ, dɛ‑nʋɛ' ɛ se ɔɔ' 'je ‑kwlewɩ wɔɔn' 'sʋ nɩ‑, 'kaa ɔɔ 'daa‑ Kea ɔ \"Bo 'a ‑cɛ\" 'kpa ‑wɛe ɔɔ poo ɔɔ' ‑cɛ\" Kea \"i ? ");
INSERT INTO wob_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","'Bomɔ Sesi \"duo wlu 'ʋn ke'wlɛ ɔ 'na : 'Ma 'tmʋʋɛ aopʋ tɔ' ‑tɩ 'a tɔ' ‑tɩ, \"Ju se ɛ 'bɛɛ‑ ɔ 'je 'e ɔɔ' ‑cɛ\" 'kpa 'ʋn 'wlʋ ‑wɛe ɔ 'e dɛ jrɛ' nʋ, dɩ ɔ \"Bo nʋa ɔ 'jea ɩmɩ ɔɔ nʋ. 'De dɩ \"klein \"Bo a nʋa, ɩmɩ \"Ju a nʋ ‑ke, ");
INSERT INTO wob_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","dɛ‑nʋɛ' \"Bo kma \"Ju 'a ‑tɩ' ‑wɛe ɛɛ tɔɔ ɔ dɩ \"klein ɛɛ' ‑cɛ\" 'kpa a nʋa. Ɛɛ mu ɔ dɩ klae\" klae\" tɔɔa' ke'wlɛ ɔ 'jɩ nʋ, ‑wɛe ɩ 'je ao tai' \"maa. ");
INSERT INTO wob_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Ka \"Bo a ‑sa' 'mɛʋn ‑klu' ‑wɛe ɛɛ \"nyɩa ʋʋpʋ 'kmʋnɩa' a, 'kamɔ \"Ju a \"nyɩ nyʋ ɔ nɩai\" 'kmʋnɩa' ‑ke. ");
INSERT INTO wob_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","\"Bo 'a 'je nyɔ \"o nyɔ 'ɔ 'pee, dɛ‑nʋɛ' ɛ ‑teɛ' \"Ju 'pee ‑wee' \"klein kwa, ");
INSERT INTO wob_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","‑wɛe nyʋ ‑wee' \"klein 'je \"ju 'a ni' ‑te', ka ʋʋa ‑tea' 'Bo 'a ni' ɛ. Nyɔ ‑sea' \"Ju 'a ni' ‑te' ɛ, ‑mɛ ɔ se \"Bo ‑dboɔ' 'ɔ ni' ‑te' ‑ke. ");
INSERT INTO wob_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","'Ma 'tmʋʋɛ aopʋ tɔ' ‑tɩ 'a tɔ' ‑tɩ, nyɔ ‑poa' 'ma wlu doin\" o, ‑wɛe ‑ɔ ‑jea \"ju ‑dboa' 'ʋn 'a ‑tɩ' tɔ' 'ʋn ɛ, ‑mɛ ɔ 'jeɛ 'kmʋnɩa' ‑sea' ‑kwɛ ‑ta 'ble ɛ, ‑mɛ 'pee se ɔ kpʋn i, 'kaa ɔ cɛɛn 'e 'mɛa' 'ʋn, ‑wɛe ɔ ‑taan' 'e 'kmʋnɩa' 'ʋn. ");
INSERT INTO wob_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","'Ma 'tmʋʋ aopʋ tɔ' ‑tɩ 'a tɔ' ‑tɩ, nɔ\" jrɛ' ‑ɛɛ mu nynia', 'de ɛ nyni' ‑wɛ‑ mɔ, ‑wɛe 'mɛʋn 'je Kea 'a \"ju 'a wlu 'wɔn, ‑wɛe nyʋ ‑ʋʋa mu ɛ 'wɔan' ʋʋ 'je 'kmʋ nɩ‑, ");
INSERT INTO wob_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Ka 'kmʋnɩa' nɩa 'e \"Bo 'ʋn ɛ, 'kamɔ ɛ nɩ 'e \"ju 'ʋn ‑ke. ");
INSERT INTO wob_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Ɛ ‑teɛ' \"Ju nyʋ 'a 'pee kwa, dɛ‑nʋɛ' ɔ nɩɛ nyiɔ 'ɔ \"Ju ‑o. ");
INSERT INTO wob_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","‑Mɛ 'ɛ Tai' 'bo aopʋ \"maa, nɔ\" jrɛ' ‑ɛɛ mu nynia' ‑wɛe 'mɛʋn ‑nɩa 'e ‑gbaɩn' 'di 'je ɔɔ' wlu 'wɔn 'de ʋʋ 'je 'e ‑gbaɩn' 'di 'wlʋ. ");
INSERT INTO wob_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","Nyʋ ‑nʋa dɛ 'dɔe ɛ, ‑wi\" ‑mʋ a muɛ 'ʋnsɔan' ‑wɛe ʋʋ 'je 'kmʋnɩa' 'je, 'kaa nyʋ ‑nʋa dɛsaʋn ɛ, ‑wi\" ‑mʋ a muɛ 'ʋnsɔan' ‑wɛe ʋʋ 'je 'e 'pee 'ʋn mu. ");
INSERT INTO wob_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Sesi 'na : 'Ma ‑cɛ\" 'kpa se ɛ 'bɛɛ‑ 'ɩn 'je dɛ jrɛ' nʋ, ka Kea 'tmʋ ɛ 'de 'ʋn ‑pee ɛ, 'kamɔ 'ma 'je nyʋ 'a 'pee. 'De 'ma nyʋ 'a 'pee 'jesʋn ‑srɛi\", dɛ‑nʋɛ' 'maa ‑pɔn 'ma ‑cɛ\" 'ɛ ‑kwlʋtɩ nʋa' i, 'kaa \"ju ‑dboa' 'ʋn mɔ ‑ɔɔ ‑kwlʋtɩ 'ma ‑pɔn i. ");
INSERT INTO wob_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","‑Bo 'ma 'sʋ a sea 'ma ‑cɛ\" 'ɛ \"kpei ‑tɩ 'tmʋ ɛ, ‑mɛ dɩ 'ma 'tmʋa, se tɔ' ‑tɩ nɩ‑. ");
INSERT INTO wob_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","'Kaa nyɔ jrɔ' mɔ ‑ɔɔ ‑tmʋ 'ma \"kpei ‑tɩ 'de 'ɩn 'je kan' 'mɛ, dɛ ɔ 'tmʋa ɛ nɩɛ tɔ' ‑o. ");
INSERT INTO wob_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Ao dboɛ nyʋ 'e San o, ‑wɛe ɔ 'tmʋʋ‑ ʋʋpʋ tɔ' ‑tɩ 'a ‑tɩ'. ");
INSERT INTO wob_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","'Mɔ ɛ, ɛ se nyiɔ mɔ ‑je 'ma \"kpei ‑tɩ 'tmʋ nɩ, 'kaa 'ma 'da kan' mɛ ‑wɛe ao 'je 'pʋ. ");
INSERT INTO wob_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Ka ‑tau a wan ‑wɛe ɛɛ 'jea i ɛ, 'kamɔ San nɩ‑, 'de aoa' ‑cɛ\" 'kpa mɔ 'wɔɔn‑ 'mʋa‑ nʋ‑tɩ 'mɛ 'de ɔɔ' ‑sɔn' 'ʋn, 'de nɔ\" jrɛ' 'di. ");
INSERT INTO wob_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","'De 'mɔ ɛ, 'ma ‑nɩ \"kpei ‑tɩ ‑ɩa ‑tmʋʋa', 'bɛi\" ɩ je San 'a ‑nɩ ‑sii, dɛ‑nʋɛ' dɩ \"Bo \"nyɩa 'ʋn 'ɩn 'jea nʋ ‑wɛe 'ma nʋa, ɩ toɛ' ka \"Bo dboa 'ʋn ɛ. ");
INSERT INTO wob_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","'De \"Bo ‑dboa' 'ʋn ɛ, ɛmɛ ‑tmʋ 'ma \"kpei ‑tɩ ‑ke. Aomɔ se ɛɛ' wlu 'wɔn due', ao se ɛɛ' \"jua‑ 'je due'. ");
INSERT INTO wob_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Aoa' ‑te' ɛɛ' wlu i 'de aopʋ 'ʋn, dɛ‑nʋɛ' \"ju ‑jɔ ɛ dboa, ao se ɔɔ' ‑tɩ' tɔ' 'ʋn 'je. ");
INSERT INTO wob_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Aoa \"jrɛɛ‑ dɩ ‑ɩ ‑crɩɩa' 'de Kea 'a 'sbɛ 'di 'mɛ, dɛ‑nʋɛ' ao 'na 'demɔ ao 'je 'kmʋnɩa' ‑sea' \"ti ‑ta 'ble 'jee‑. 'De dɩ ‑crɩɩa' 'mʋa‑ mɩ ‑tmʋ 'ma ‑tɩ'. ");
INSERT INTO wob_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","'De ‑mɛ 'kamɔ ao 'na ao se 'nɔ 'ʋn o jii, ao se 'kmʋnɩa' ‑cɛɛn' 'jei. ");
INSERT INTO wob_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","'Ɩn se nyiɔpʋ 'a 'ma ‑tɩ' o poa' i ‑pɔn. ");
INSERT INTO wob_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","'Kaa 'ɩn juoɛ' 'pepe, Kea 'a ‑tɩ' kmaa' se 'de aopʋ 'ʋn nɩ‑. ");
INSERT INTO wob_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","'Ɩn ji' 'de 'ʋn \"Bo 'a 'nynɩ 'ʋn ‑wɛe ao 'na ao se 'ʋn sɩn 'sɔɔn kpʋʋɛn i, 'kaa ‑bo nyɔ jrɔ' ‑te ɔɔ' ‑cɛ\" 'ɛ 'nynɩ \"jru ɔ ji 'sʋ ɛ, aoa kpʋʋn ɔ ‑mɔ sɩn 'sɔɔn. ");
INSERT INTO wob_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Ka ao 'je dɛ tɔ' 'ʋn 'je sʋn nʋ mɔ 'de ɛ‑ ? Aopʋ ‑ɔɔ ‑pɔan dɛwɔn nɩa' i 'de ba 'nynɩ i ‑wɛe ‑ɔɔ' ‑pɔan ‑jɛ ‑wlʋa 'e Kea 'a 'sʋ o i ɛ. ");
INSERT INTO wob_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","'Kaa ao 'bo tɔ' inaa ka 'mɔ ‑je aopʋ ‑tɩ' \"bli kpa 'bo 'ɩn \"Bo \"juɔi, ɛ Moisɩ ao tba tɔ' \"i ɛ, ɔmɔ ‑je aopʋ ‑tɩ' \"bli kpa. ");
INSERT INTO wob_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","‑Bo ao 'je Moisɩ 'a ‑tɩ' tɔ' 'ʋn 'de ɛ, ‑mɛ ao 'bɛɛ‑ ao 'je 'ma ‑tɩ' tɔ' 'ʋn 'je ‑ke, dɛ‑nʋɛ' ɔ 'crɩ 'ma ‑pʋn\" ‑tɩ 'mɛ. ");
INSERT INTO wob_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","'Kaa dɛ ɔ 'crɩa ao sea ‑mɛ tɔ' 'ʋn 'je 'ee, ka ao 'je 'ma wlu tɔ' 'ʋn 'jesʋn nʋ ɛ‑ ? ");
INSERT INTO wob_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","'Bo ‑mɛ 'de ɛ, Sesi muɛ 'e \"ni 'a 'fɔ jrɛ' o, ɛɛ' \"ni tu nɩɛ 'e Tiberiadɩ 'de Galileblʋa \"kpei. ");
INSERT INTO wob_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","'Sʋ nyʋ ‑tuu\"‑tuu bla 'o ɔ 'de, dɛ‑nʋɛ' jrii' ɔɔ nʋa ‑wɛe ɔɔ 'bɔɔa nyʋ 'a 'wɛ‑ mɩ ʋʋa 'jei. ");
INSERT INTO wob_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Sesi ke ɔɔ' klai\" nynuu 'ja 'o crʋ due' \"kpei, ‑wɛe ʋʋ ‑te i. ");
INSERT INTO wob_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","‑Mɛ Pakɩ ‑nɩa Suifʋ‑wi\" 'a kʋɔnkwla' 'wlʋ ‑kɔ' klaa\" \"kʋʋan‑ i kɛkɛ‑. ");
INSERT INTO wob_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Sesi kpa \"jriɛ \"jɛi ɔ 'jea nyʋ ‑tuu\"‑tuu ‑ʋʋa jia 'de ɔ o 'sʋ ɔ wlu' 'de Filipʋ ‑pee ɔ 'na : Filipʋ, ‑ta ‑a ‑je diidɛ ‑tɩɩn ‑wɛe nyʋ ‑tia ka 'je di ɛ‑ ? ");
INSERT INTO wob_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Ɔɔ 'da kan' 'mɛ ‑wɛe ɔ 'je Filipʋ i‑tɩn', dɛ‑nʋɛ' dɛ ɔ 'jea nʋ ɛ, ɔɔ' ‑cɛ\" 'kpa juɛ'. ");
INSERT INTO wob_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","'De Filipʋ 'na : ‑Bo ɛ nɩ 'wɛi 'a ‑kwlʋ due' 'a ‑di'pɛn ‑tɩɩn ‑ɛ 'mɔ 'de ɛ, ɛ se ʋʋpʋ \"wɔin 'bɛɛi ‑wɛe nyɔ due' 'a tie due' di ‑tɩ. ");
INSERT INTO wob_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","'Sʋ ɔɔ' klai\" nynuu 'a due' Ancre ‑ɔ ‑nɩa Simɔ Piɛi 'a de'di wlu ɔ ‑pee, ɔ 'na : ");
INSERT INTO wob_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","\"Ju‑saan\" due' ‑nɩ 'e ‑a \"klu ‑ta, ‑ɔ ‑ble ‑di'pɛn kplɩ ‑mm\" ke ‑smii' jɔ 'sɔɔn ke, 'kaa dɛ ‑mɛ nɩ 'ʋn 'de nyʋ ‑tia ka ‑wi\" ‑mʋ 'a ‑tɩ' 'ʋn ɛ‑ ? ");
INSERT INTO wob_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","'Sʋ Sesi 'na : Ao 'tmʋʋ ʋʋpʋ ʋʋ 'je i ‑te. 'De 'bo 'a ‑ta ‑tu ɛ, sii\" ‑tuu\" ‑nɩ 'o. Ʋʋ ‑wee' beea o ɛ, ʋʋ 'bɛɛ‑ \"nynunmai 'a \"wlu ‑mm\" 'mɛ. ");
INSERT INTO wob_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","'Bomɔ Sesi \"duo ‑di'pɛn ‑nɩa 'mʋa‑ 'ʋn ‑wɛe ɔ po ɩa' Kea 'sɛ‑ 'de ɔ ‑gblɩ' nyʋ ‑tea i ‑wee' \"klein \"jrii, ɩ ke ‑smii' ke. Ʋʋ ‑wee' di' ʋʋa' ‑kwlʋ ka‑ 'sʋ ʋʋ je dbo. ");
INSERT INTO wob_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","‑Ta ʋʋ ‑wee' dboa la, 'bomɔ Sesi wluu ɔɔ' klai\" nynuu ‑pee ɔ 'na : Ao 'tɛn ɩa' tii ‑sia 'o ɛ, ‑wɛe ɩa' due' koʋn ‑gbai' je \"ma. ");
INSERT INTO wob_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Ʋʋ ‑kɔa' ‑di'pɛn kplɩ ‑mm\" ‑nɩ 'a dia' a, ɩa' tii ‑ɩ ‑sia 'omu ‑wɛe klai\" nynuu 'tɩan a, ɩ \"jiɛ toe\" 'a ‑puue 'jɔ 'sɔɔn. ");
INSERT INTO wob_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Nyʋ \"klein ‑jeea' jrii' Sesi nʋa 'mʋa‑ \"jriɛ‑ ɛ, ʋʋ 'na : \"Ju ‑nɔ nɩɛ Kea 'a wlu 'kwajaai ‑jea 'nɔ 'kmʋ \"kpei ji ‑o ‑cɛɛn'‑. ");
INSERT INTO wob_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Ka ʋʋa jia Sesi klan\" ‑klan klan\" kpʋan' ‑wɛe ʋʋ 'je ɔ 'beɔ 'ʋn nʋ ɔ 'jea kan' 'sʋ ɔ 'wlʋ 'o ʋʋpʋ \"klu 'mɛ wɔɔ‑, ‑wɛe ɔɔ' 'sʋ mu 'e crʋ \"kpei de. ");
INSERT INTO wob_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","‑Ta kwie a kpʋan 'sʋ ɛ, ɔɔ' klai\" nynuu \"siɛ i ‑wɛe ʋʋ mu 'o \"ni ‑kwlɩ\". ");
INSERT INTO wob_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Ʋʋ 'ja 'e ‑kwɛɛ\" 'di 'sʋ ʋʋ ‑teɛ \"ni cɛan' ‑pʋn\" ‑wɛe ʋʋa mu 'e Kapɛnaʋm fɔ o. Kwie a kpʋn' ‑mɛ Sesi se ʋʋpʋ jɛɛ ke. ");
INSERT INTO wob_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","'Sʋ poɔ' klaa\" ‑teɛ jia' ‑pʋn\", \"ni a 'fea srɩ' ‑gboe. ");
INSERT INTO wob_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Dɛ ʋʋa' ‑kwɛɛ\" na 'ʋn 'bo \"ni \"kpei ɛ 'bɛɛ‑ ‑je 'a ‑to ‑mm\" ke ‑mɛɛo\"‑ 'mɛ. 'Sʋ ʋʋa 'jeɛ Sesi i ɔɔ na' 'o \"ni \"kpei ɔɔ jiɛ 'de ‑kwɛɛ\" o fɔ o, 'sʋ faʋn a nʋ ʋʋpʋ 'mɛ. ");
INSERT INTO wob_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","'Kaa Sesi 'na : 'Mɔ ‑o, faʋn 'bo aopʋ‑ nʋɛ ! ");
INSERT INTO wob_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Ʋʋ nɩɛ \"i ɔ 'je 'e ‑kwɛɛ\" 'di 'ja, 'sʋ ‑kwɛɛ\" kpʋɛn 'kpʋʋ ‑ta ʋʋa mua fɔ o. ");
INSERT INTO wob_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Ka ‑kwɛɛ\" due' ‑gbai' 'a 'sʋ nɩa 'o mu ‑wɛe Sesi ke ɔɔ' klai\" nynuu sea 'e ɛ 'di 'ja ‑tadue, 'de ʋʋa' 'sʋ mua nyʋ ‑tuu\"‑tuu ‑sia 'e \"ni 'de ɔ 'je kan' 'mɛ. ");
INSERT INTO wob_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Ɛɛ' ‑sɔn' dee ‑sɩan' a, 'sʋ ‑kwɛɛ\" jrɩ' 'wlʋɛ 'e Tiberiadɩ ‑wɛe ‑ɩ ji ‑ta Sesi pooa ‑di'pɛn kplɩ 'a Kea 'sɛ‑ 'de ʋʋ di ɛ. ");
INSERT INTO wob_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Ka Sesi ke ɔɔ' klai\" nynuu sea 'mʋa‑ nɩ ʋʋ 'jea kan' 'sʋ ɛ, ʋʋ ‑wee' 'ja 'e ‑kwɛɛ\" ‑nɩ 'di ‑wɛe ʋʋ mu ɔ i ‑pɔan' 'de Kapɛnaʋm. ");
INSERT INTO wob_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Ʋʋ jɛɛɔ' 'de \"ni klaa\" 'de 'sʋ ʋʋ 'na : Nyʋ dɛtɔɔi, blaa nɔ\" ‑ɩn ji 'nɔ ɛ‑ ? ");
INSERT INTO wob_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","'Sʋ Sesi wlu' 'de ʋʋ ‑pee ɔ 'na : 'Ma 'tmʋʋ aopʋ‑ tɔ' ‑tɩ 'a tɔ' ‑tɩ, dɛɛ ‑tɩ aoa ‑pɔan' 'mi i ɛ, ɛmɛ ‑nɩ ao diɛ ‑di'pɛn ao je dbo, ao se 'mi i ‑pɔn' 'de jrii' 'ɩn nʋa ao 'jeea \"jriɛ 'ɛ ‑tɩ' 'ʋn. ");
INSERT INTO wob_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Diidɛ ‑jɛ ‑ɛɛ' ‑kwlea dooa ‑tɩ ɛ, ao 'bo ‑mɛ i ‑pɔɛn, 'kaa diidɛ ‑jɛɛ ‑kwlea 'ʋn 'de ‑ɛɛ ‑nyɩa\" nyʋ 'kmʋnɩa' ‑sea' ‑kwɛ ‑ta 'ble ɛ, ɛmɛ ao 'je i ‑pɔn. nyiɔ 'ɔ \"Ju mɔ ‑je aopʋ‑ ɛɛ' diidɛ tu \"nyɩ, dɛ‑nʋɛ' ɔmɔ \"Bo Kea ‑tu\" \"i juo 'ɩn ");
INSERT INTO wob_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","'Sʋ ʋʋ ‑tee' ɔ i ʋʋ 'na : Ka ‑a ‑je nʋ ‑wɛe dɩ \"klein Kea nɩa \"i ‑a ‑je ɩa' 'sʋ nʋ ɛ‑ ? ");
INSERT INTO wob_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","‑Wɛe Sesi 'na : Dbo Kea nɩa \"i ao 'jea nʋ ɛ, ɛmɛ ‑nɩ ao 'je \"ju ɛ dboa 'a ‑tɩ' tɔ' 'ʋn 'je. ");
INSERT INTO wob_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","'Sʋ ʋʋ 'na : Jrii' ‑jɛ wɛ‑ ‑ɩn ‑je nʋ ‑bo ‑a ‑je 'de ‑a ‑je ‑ma ‑tɩ' tɔ' 'ʋn 'je ɛ‑ ? 'De dbo ‑jɛ wɛ‑ ‑ma nʋ ‑gblein' ɛ‑ ? ");
INSERT INTO wob_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","‑A \"bo ‑wi\" diɛ 'maanɩ‑ 'de ‑pɩɩɔn\" blʋa \"kpei ka ɛ 'crɩɩa 'de Kea 'a 'sbɛ 'di ɛ : Ɛ \"nyɩɛ ʋʋpʋ jaʋn 'di diidɛ ʋʋ je di Ɛ \"nyɩɛ ʋʋpʋ diidɛ ‑wlʋa 'e jaʋn 'di ʋʋ je di. ");
INSERT INTO wob_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","'Sʋ Sesi 'na : Tɔ' ‑tɩ 'a tɔ' ‑tɩ 'ma 'tmʋ 'de ao ‑pee, ɛ se Moisɩ mɔ ‑nyɩ\" ao diidɛ ‑wlʋa 'e jaʋn 'di nɩ, 'kaa 'ɩn \"Bo mɛ ‑ɛɛ ‑nyɩ\" aopʋ‑ diidɛ ‑cɛɛn' ‑wlʋa 'e jaʋn 'di ɛ. ");
INSERT INTO wob_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Dɛ‑nʋɛ' ɛ, diidɛ ‑jɛ Kea \"nyɩa nyʋ ɛ, ɛmɛ ‑nɩ \"ju ‑jɔ ‑wlʋa 'e jaʋn 'di ‑wɛe ‑ɔɔ ‑nyɩa\" nyʋ 'kmʋnɩa' a. ");
INSERT INTO wob_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","'Sʋ ʋʋ 'na : Tʋ\"bo, ‑ɩn ‑nyɩ\" ‑aʋn ɛɛ' diidɛ tu jeejee. ");
INSERT INTO wob_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","'Sʋ Sesi 'na : 'Mɔ ‑nɩ diidɛ ‑ɛɛ ‑nyɩa\" nyʋ 'kmʋnɩa' a. Nyɔ ‑jia' 'nɔ 'mɔ o ɛ, 'mɩɩɛ‑ se ‑mɔ nʋ i 'bode, 'de nyɔ ‑jea 'ma ‑tɩ' tɔ' 'ʋn ɛ, \"ni 'natʋn se ɔ nʋ i 'bode. ");
INSERT INTO wob_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","'Ɩn 'tmʋʋɛ 'de aopʋ‑ ‑pee sese, 'kaa ao 'na ao se 'ma ‑tɩ' tɔ' 'ʋn 'jei 'de ‑mɛ 'kamɔ ao 'jee 'ʋn \"jriɛ‑ 'pepe. ");
INSERT INTO wob_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Nyʋ \"klein \"Bo \"nyɩa 'ʋn ɛ, ʋʋa muɛ 'nɔ 'ʋn o jia' se, 'de nyɔ ‑jia' 'nɔ 'mɔ 'o ɛ, 'ɩn se ɔ \"kpae' poi, ");
INSERT INTO wob_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","dɛ‑nʋɛ' 'ɩn 'wlʋɛ 'e jaʋn 'di, 'ɩn je ji ‑wɛe 'ɩn 'je \"ju ‑dboa' 'ʋn 'a ‑kwlʋtɩ nʋ. 'Ɩn se 'ma ‑cɛ\" 'ɛ ‑kwlʋtɩ nʋa' ji. ");
INSERT INTO wob_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","'De \"ju ‑dboa' 'ʋn 'a ‑kwlʋ ‑tɩ mɛ ‑nɩ nyʋ \"klein ɔ \"nyɩa 'ʋn ɛ, 'ɩn 'bo ʋʋa' due' koʋn ‑gbai' \"maa, 'kaa 'ɩn 'je ʋʋ ‑wee' \"klein \"kunyɩɔ' ‑sa 'de de 'bɔɔ‑ nɔ\" 'di, ");
INSERT INTO wob_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","'Ɩn \"Bo 'a ‑kwlʋtɩ ɛmɛ ‑nɩ nyɔ \"o nyɔ ‑ɔ ‑jeea' \"Ju \"jriɛ‑ ‑wɛe ‑ɔ ‑jea ɔɔ' ‑tɩ' tɔ' 'ʋn ɛ, ‑mɛ ‑mɔ 'jeɛ 'kmʋnɩa' ‑sea' ‑kwɛ ‑ta 'ble. 'De 'ɩn 'je ɔ \"kunyɩɔ' ‑sa de 'bɔɔ‑ nɔ\" 'di. ");
INSERT INTO wob_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","'Sʋ Suifʋ‑wi\" a wluuɛ Sesi 'dei, dɛ‑nʋɛ' ɔ 'na : 'Mɔ ‑nɩ diidɛ ‑wlʋa 'e jaʋn 'di ɛ. ");
INSERT INTO wob_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","'De ʋʋa wlu ka ʋʋ 'na : Soseʋ 'a \"ju Sesi ko ‑taa ? ‑A ‑juo ɔ \"bo ke ɔ de 'mɛ o, ‑mɛ kɛ nʋ ‑wɛe ɔ 'na ɔ 'wlʋɛ 'e jaʋn 'di ɔ je i \"si ɛ‑ ? ");
INSERT INTO wob_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","'Sʋ Sesi 'na : Ao 'bo 'mii wluɛ. ");
INSERT INTO wob_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Nyɔ se ɛ 'bɛɛ‑ ɔ 'je 'de 'ʋn o ji ‑bo \"Bo ‑dboa' 'ʋn se ɔɔ' \"jua‑ 'de 'ʋn o \"biie‑ ɛ. 'De nyɔ ‑jia' 'de 'mɔ o ɛ, 'ma muɛ ɔ \"kunyɩɔ' ‑saa' 'blʋa 'a ‑kwɛ‑ nɔ\". ");
INSERT INTO wob_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","'De ɛɛ' ‑tɩ' 'ʋn ɛ, dɛ Kea 'a wlu 'kwajaaʋn 'crɩa 'de ʋʋa' 'sbɛ 'di, ɛ ka : 'De Kea 'ʋn mɔ nyʋ ‑wee' \"klein 'je tɔ' ‑tɩ juo‑. ‑Bo ɛ nɩ kan' a, ‑mɛ nyɔ \"o nyɔ ‑ɔ ‑wɔan 'Bo 'a wlu ‑wɛe ‑ɔ ‑kpʋʋn ɛ sɩn 'sɔɔn ɛ, ɔɔ' nyɔ tu a muɛ 'de 'ʋn o jia' se. ");
INSERT INTO wob_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Ɛ se ‑mɛ nyɔ jrɔ' mɔ ‑jee' \"Bo \"jriɛ‑ nɩ‑, ‑bo ɛ se 'mɔ ‑ɔ ‑wlʋa 'e Kea o 'ma 'sʋ ‑jee' 'ɩn \"Bo \"jriɛ‑ nɩ ɛ. ");
INSERT INTO wob_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Tɔ' ‑tɩ 'a tɔ' ‑tɩ 'ma 'tmʋ 'de ao ‑pee nyɔ ‑jea 'ma ‑tɩ' tɔ' 'ʋn ‑mɛ ɔ 'jeɛ 'kmʋnɩa' ‑sea' ‑kwɛ ‑ta 'ble ɛ. ");
INSERT INTO wob_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","'Mɔ ‑nɩ 'kmʋnɩ diidɛ. ");
INSERT INTO wob_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Ao \"bo ‑wi\" diɛ 'maanɩ‑ 'de ‑pɩɩɔn\" blʋa \"kpei, 'kaa ʋʋ 'mɛɛ. ");
INSERT INTO wob_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Diidɛ ‑wlʋa 'e jaʋn 'di, ɛ ka, nyɔ ‑diɛ ‑mɛ ‑mɔ se 'mɛi 'bode. ");
INSERT INTO wob_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","'Mɔ ‑nɩ 'kmʋnɩ diidɛ ‑wlʋa 'e jaʋn 'di ɛ. ‑Bo nyɔ di ɛɛ' diidɛ tu ɛ, ɔɔ muɛ 'kmʋnɩa' jeejee. 'De diidɛ 'ma mua toa' a, ɛmɛ ‑nɩ 'ma ku. 'Ma to 'e 'ma ku 'mɛ 'de nyʋ ‑wee' \"klein 'a 'pʋ‑tɩ 'ʋn. ");
INSERT INTO wob_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","'Bo wlu ‑nɩa 'mʋa‑ \"kpei ɛ 'sʋ Suifʋ‑wi\" ‑teɛ 'ʋn ‑saa' ‑pʋn\" ʋʋ 'na : Ka \"ju ‑nɔ mɔ 'je 'e ɔɔ' ku 'e tosʋn nʋ ‑wɛe ‑a ‑je ɛ di ɛ‑ ? ");
INSERT INTO wob_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","'Sʋ Sesi pooɛ ‑tɩ' \"i ɔ 'na : tɔ' ‑tɩ 'a tɔ' ‑tɩ 'ma 'tmʋʋ aopʋ, ‑bo ao se nyiɔ 'ɔ \"ju 'a ku di ‑wɛe ao se ɔɔ' nmɔ 'na a, ‑mɛ 'kmʋnɩa' ‑sea' ‑kwɛ ‑ta 'ble se aopʋ‑ 'a dɛ nɩ‑. ");
INSERT INTO wob_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Nyɔ ‑dia' 'ma ku 'de nyɔ ‑na 'ma nmɔ ‑mɛ ɔ 'jeɛ 'kmʋnɩa' ‑sea' ‑kwɛ ‑ta 'ble ɛ, 'de 'ɩn 'je ɔ \"kunyɩɔ' ‑sa de'bɔɔ‑ nɔ\". ");
INSERT INTO wob_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Dɛ‑nʋɛ' 'ma ku nɩɛ diidɛ ‑cɛɛn' ‑o, 'de 'ma nmɔ nɩɛ 'naadɛ ‑cɛɛn' ‑o. ");
INSERT INTO wob_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Nyɔ ‑dia' 'ma ku 'de ‑ɔ ‑na 'ma nymɔ ‑mɛ ‑mɔ \"tiɛ 'de 'mɔ 'ʋn ‑wɛe 'mɔ \"ti 'de ɔ 'ʋn. ");
INSERT INTO wob_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Ka \"Bo ‑nɩa 'kmʋ dboa 'ʋn ‑wɛe 'ɩn nɩa 'kmʋ 'de ɔ 'ʋn ɛ, 'kamɔ nyɔ ‑dia' 'ma ku a mu 'kmʋnɩa' 'de 'ʋn ‑ke. ");
INSERT INTO wob_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","'Ma ku mɛ ‑nɩ 'kmʋ nɩ diidɛ ‑wlʋa 'e jaʋn 'di, ɛ ke maanɩ ao \"bo ‑wi\" dia ‑wɛe ʋʋ 'mɛa se ‑kooɔ'‑, 'kaa nyɔ ‑ɔ dia' 'ma ku, ɔɔ muɛ 'kmʋnɩa' jeejee. ");
INSERT INTO wob_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Sesi 'tmʋ wlu \"klein ‑nɩa 'mʋa‑ 'mɛ 'de Kea ‑gbu ‑nɩa 'o Kapɛnaʋm 'di. ");
INSERT INTO wob_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Sesi 'a klai\" nynuu 'wɔan wlu ‑nɛ 'sʋ, ʋʋa' ‑tuu\" 'na : ‑Ɔ ‑bɛɛ' wlu ‑kmai\" kan' ‑mɩ 'a doin\" o poa' a‑ ? ");
INSERT INTO wob_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Sesi 'jea kan' 'de ɔɔ' ‑cɛ\" 'ʋn ka ɔɔ' klai\" nynuu a \"wuan 'bo ʋʋa' 'sʋ 'nynɩ 'sʋ ɔ 'na : Wlu 'ɩn 'tmʋa ɛmɛ ‑kpʋn ao ‑kwlʋʋ ? ");
INSERT INTO wob_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","'De ‑mɛ ‑bo aoa sea nyiɔ 'ɔ \"Ju i 'je ɔɔ sea ‑ta ɔ nɩa tɛin\" de mu 'e ‑mɛ ka ɔ 'je nʋ ɛ‑ ? ");
INSERT INTO wob_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Kea 'a ‑Suu mɛ ‑ɛɛ ‑nyɩ\" nyʋ 'kmʋnɩa', 'blʋku ‑mɛ se dɛ jrɛ' 'bɛɛ‑. Wlu \"klein 'ɩn 'tmʋa 'de ao ‑pee ɛ, ɩmɩ ‑ɩa ja Kea 'a ‑Suu, ‑ɛɛ ‑nyɩa\" nyʋ 'kmʋnɩa'. ");
INSERT INTO wob_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","'Kaa nyʋ jrʋ' ‑nɩ 'de aopʋ‑ \"klu ‑ta ‑ʋʋa' 'je dɛ tɔ' 'ʋn. Dɛɛ ‑tɩ ɔ 'da kan' a, ɛmɛ ‑nɩ ɛ ‑teea ‑wee' 'sʋ Sesi juo nyʋ ‑ʋʋ sea dɛ tɔ' 'ʋn 'jei ke \"ju ‑jea ɔ 'e to 'mɛ. ");
INSERT INTO wob_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Ɛmɛ ‑tɩ ɔ ‑tuɛ\" \"kpei ɔ 'na : 'Ɩn wlu 'de ao ‑pee 'de 'ɩn 'na nyɔ seɛ 'bɛɛ‑ ɔ 'je 'nɔ 'ʋn o ji ‑bo ɛ se 'de \"Bo 'ʋn 'wlʋ ɛ. ");
INSERT INTO wob_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Dɛ ‑tba' 'o ɛɛ' nɔ\" tu 'di ɛ, ɔɔ' klai\" nynuu 'a ‑tuu\" 'wlʋ 'o ɔ 'de 'mɛ ‑wɛe ʋʋ ke ɔ 'bɔ na ‑tɩ. ");
INSERT INTO wob_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","'Sʋ Sesi wlu' 'de nyʋ 'a ‑puue 'jɔ 'sɔɔn ɔ ‑sa 'o ‑pee, ɔ 'na : Aopʋ‑ mɔ 'ee, ao se ɛ \"i nɩ ao 'je mu ‑kee ? ");
INSERT INTO wob_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","'Bomɔ Simɔ Piɛi wlu ɔ ‑pee ɔ 'na : Tʋ\"bo, nyɔ wɛ‑ ‑a ‑je 'e o mu ɛ‑ ? ‑Mɔ mɔ ‑ble wlu ‑ɩa ‑nyɩa\" nyʋ 'kmʋnɩa' ‑sea' ‑kwɛ ‑ta 'ble 'dee. ");
INSERT INTO wob_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Ɩmɩ ‑a ‑mɔ ‑je tɔ' 'ʋn, 'de ka ‑ɩn ‑nɩa \"Ju Kea ‑teea kpɔ \"i ɛ, ‑a ‑je kan' 'mɛ. ");
INSERT INTO wob_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","'Sʋ Sesi wlu' 'de ʋʋ ‑wee' ‑pee, ɔ 'na : Aopʋ‑ ‑nɩa ‑puue 'jɔ 'sɔɔn ɛ, 'mɔ ‑se' aopʋ 'e nyʋ \"klu ‑saa ? 'De ‑mɛ 'kamɔ aoa' due' nɩ ‑suusaʋn 'a nyɔ. ");
INSERT INTO wob_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","‑Mɛ Simɔ 'ɔ \"ju Suida Isikario mɔ ɔɔ 'da, dɛ‑nʋɛ' ɔmɔ ‑ɔɔ mu Sesi 'e toa', 'de ‑mɛ 'kamɔ ɔ nɩ klai\" nynuu ‑nɩa ‑puue 'jɔ 'sɔɔn 'ɔ due'. ");
INSERT INTO wob_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","'Bo ‑mɛ 'de ɛ, Sesi a pleɛ Galileblʋa \"kpei‑, ɔ se ɛ \"inɩ ɔ 'je Suide ‑te, dɛ‑nʋɛ' Suifʋ‑wi\" 'a \"jru kpɔ' i ‑teʋn a ‑pɔn ɔɔ' 'dba ‑kɔ i. ");
INSERT INTO wob_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","‑Kɔ' Suifʋ‑wi\" a ‑tu\" 'a ‑wɛe ʋʋa poa sɩaɩn'‑ \"jɛi \"kʋʋan‑ i. ");
INSERT INTO wob_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","'Sʋ Sesi 'a \"dei‑wi\" wlu' 'de ɔ ‑pee, ʋʋ 'na : ‑Ɩn ‑wlʋ ‑ta, ‑ɩn mu 'e Suide, ‑wɛe nyʋ ‑nɩa 'nɩa 'je ‑ma nʋʋdɩ \"jriɛ‑ 'jee‑ ‑ke. ");
INSERT INTO wob_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Nyɔ \"o nyɔ ‑nɩai\" nyʋ 'jea juo ɛ, ‑mɔɔ' nʋʋdɩ 'a pa 'kwla. Ka ‑ma nʋa dɩ ‑jɩ ‑mɩ kaan 'ja a, ‑mɛ ‑ɩn ‑to ‑ma ‑cɛ\" ‑wɛe nyʋ ‑wee' \"klein 'je ‑ʋn 'je. ");
INSERT INTO wob_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Sesi 'a \"dei‑wi\" foo\" 'sʋ se ɔɔ' ‑tɩ' tɔ' 'ʋn 'je ‑ke. ");
INSERT INTO wob_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Sesi wlu' 'de ʋʋpʋ ‑pee, ɔ 'na : 'Ma ‑nɛ nɔ\" se 'o nyni ke, 'kaa aomɔ ɛ, nɔ\" ‑wee' \"klein nmɔi\" 'de aoa' ‑tɩ' 'ʋn. ");
INSERT INTO wob_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","'Blʋa 'dinyʋ se aopʋ 'ʋn 'nyɛ, 'kaa ʋʋ 'nyɛ 'mɔ 'ʋn 'ɛ, dɛ‑nʋɛ' ka ʋʋa' nʋʋdɩ nynia \"jrii ɛ, ɩmɩ 'ma 'tmʋ. ");
INSERT INTO wob_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Aopʋ mɔ mu ‑kɔ' ‑sɔn, 'mɔ se ɛɛ' ‑kɔ' tu 'ʋn mui, dɛ‑nʋɛ' 'ma ‑nɛ nɔ\" se 'o nyni ke. ");
INSERT INTO wob_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Ɔ 'tmʋa wlu ‑nɩ 'de ʋʋ ‑pee 'sʋ ɔ siɛ 'e Galile. ");
INSERT INTO wob_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","‑Ta Sesi 'a \"dei‑wi\" mua ‑kɔ' ‑sɔn ɛ, Sesi mu' ‑ke, 'kaa nyɔ jrɔ' se ɛ juuo, ɔ mu' wɔɔ‑. ");
INSERT INTO wob_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","‑Kɔ'ɔ 'wɩ o 'sʋ Suifʋ‑wi\" a ‑pɔn ɔ i, ʋʋa ‑teeɛ' nyʋ i, ʋʋ 'na : ‑Ta ɔ nɩ ɛ‑ ? ");
INSERT INTO wob_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","'De nyʋ \"klu ɛ, ‑tuu\"‑tuu a jaa wlu ja ‑wɛe ʋʋa 'tmʋ ɔɔ' ‑tɩ'. Jrʋ' 'na : Ɔ nɩɛ nyɔ 'dɔe ‑o. Jrʋ' 'na : Ɔ se nyɔ 'dɔe nɩ‑, ɔɔ ‑saa nyʋ 'a \"jru ‑jei\". ");
INSERT INTO wob_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","'Kaa nyɔ jrɔ' 'ɔ wa' wɔn' i, ɔɔ' 'tmʋ ɔɔ' ‑pʋn\" ‑tɩ, dɛ‑nʋɛ' ʋʋa plee ʋʋa' \"jru kpɔ' i ‑teʋn 'mɛ. ");
INSERT INTO wob_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","‑Ta ɛ nynia 'o ‑kɔ'ɔ ‑kwea' 'sʋ, Sesi muɛ 'e Kea ‑gbu klaa\" 'di ‑wɛe ɔ ‑te nyʋ Kea 'a wlu tɔɔa' ‑pʋn\". ");
INSERT INTO wob_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","'Sʋ tai' \"maa Suifʋ‑wi\" 'mɛ, ʋʋ 'na : \"Ju ‑nɔ ‑mɔ sea 'sbɛ jrɛ' 'cɩan 'ee, kɛ nʋ 'sʋ ɔ juo dɩ ‑tia ka ‑mɩ ɛ‑ ? ");
INSERT INTO wob_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","'Bomɔ Sesi wluu‑ ʋʋ ‑pee, ɔ 'na : Dɛ 'ma tɔɔa nyʋ ‑ta, ɛ se 'de 'ma ‑cɛ\" 'ʋn 'wlʋ, 'kaa \"ju ‑ɔ dboa 'ʋn ɛ, 'de ɔ 'ʋn 'demɔ ɛ 'wlʋ. ");
INSERT INTO wob_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Nyɔ ‑nɩɛ \"i ‑ɔ ‑jea Kea 'a ‑kwlʋtɩ nʋ ɛ, ‑bo 'ma nyʋ dɛtɔɔsʋn 'wlʋ 'e Kea 'ʋn o, ‑bo ɛ 'wlʋ 'e 'ma ‑cɛ\" 'kpa 'ʋn o, ɔmɔ ‑je ɛ juo‑. ");
INSERT INTO wob_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Nyɔ ‑ɔɔ ‑tmʋa ɔɔ' 'blei 'a ‑tɩ' ‑mɔɔ' ‑pɔn ɔɔ' ‑cɛ\" 'ɛ 'nynɩ 'wlʋa i. 'Kaa nyɔ ‑ɔɔ ‑pɔan ɔɔ' dboi 'a 'nynɩ 'wlʋa' i ɛ, ‑mɔ ɔ' 'tmʋɛ tɔ' ‑tɩ. 'Kɔɔa' dɛ‑saan\" ka se 'de ‑mɔ 'ʋn nɩ‑ ");
INSERT INTO wob_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Moisɩ se aopʋ Kea 'a kɛ \"nyɩɩ ? 'Kaa aoa' due' koʋn ‑gbai' ka 'a 'je kɛ' ‑nɛ wɔn. Dɛɛ‑tɩ aoa ‑pɔn 'ma 'dbaa' i ɛ‑ ? ");
INSERT INTO wob_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","'Sʋ ʋʋ ‑wee' 'na : ‑Suusaʋn ‑nɩ 'de ‑ɩn 'ʋn, nyɔ ‑ɔɔ ‑pɔn ‑ma 'dba ‑kɔ i ɛ‑ ? ");
INSERT INTO wob_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","'De Sesi 'na : Dɛ 'ɛ kpɛ due' 'ɩn nʋa, ɛmɛ ‑maa\" ao ‑wee' \"klein tai'. ");
INSERT INTO wob_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Moisɩ mɔ ‑bla' 'klɛn mu‑tɩ 'a kɛ' ‑ɔ ‑nyɩ\" aopʋ. 'De ɛ se 'e Moisɩ mɔ 'ʋn 'wlʋ, ɛ 'wlʋɛ 'e ao \"bo ‑wi\" 'ʋn sese. ‑Wɛe aoa kpa nyʋ 'klɛn 'bo ‑kwlewɩ \"kpei. ");
INSERT INTO wob_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","‑Bo nyʋ 'klɛn kpa 'bo ‑kwlewɩ \"kpei ‑mɛ 'ɛ ‑saa Moisɩ 'a kɛ' 'ee ? ‑Mɛ dɛɛ‑tɩ ‑bo 'mɔ 'pʋʋ‑ nyɔ 'bo ‑kwlewɩ \"kpei ‑wɛe aoa 'kpa 'cɛn ɛ‑ ? ");
INSERT INTO wob_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Ka aoa' \"jriɛ‑ ɛ 'jea dɛ, ao 'bɔ ɛɛ' 'pee 'je ‑tɩ kan', 'kaa ao ‑srɛi\" 'de aoa' nyʋ 'a 'pee 'jesʋn 'ʋn. ");
INSERT INTO wob_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Nyʋ ‑nɩa 'o Selisalɛm ʋʋa' jrʋ' 'na : \"Ju ʋʋa ‑pɔan i ʋʋ 'jea 'dba, ɔ ko ‑taa ? ");
INSERT INTO wob_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Ao ‑gbʋn 'e, ɔɔ wlu' 'bo nyʋ ‑wee' \"juɔi ‑o, 'kaa nyɔ ‑je ɔ dɛ ‑pee 'tmʋ, ɔ se nɩ‑. ‑Aee' ka ɔ nɩa Nyʋ'pʋʋi ɛ, ‑aa klae\"‑wi\" 'je ɛ tɔ' 'ʋn ‑wɛ‑ ‑cɛɛn'‑ ? ");
INSERT INTO wob_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","'De ‑mɛ 'kamɔ Nyʋ 'pʋʋi ‑ɔɔ mua jia' a, ‑ta ɔɔ mua 'wlʋa' ‑a se 'o juoi, 'kaa ‑jɔ ‑mɔ ɛ, ‑ta ɔ 'wlʋa ‑a ‑juo 'o 'ɛ. ");
INSERT INTO wob_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","‑Ta ɛɛ nʋa kan' ‑mɛ Sesi nɩɛ nyʋ Kea 'a wlu tɔɔa' 'de Kea ‑gbu 'di. 'Sʋ ɔ kpa wlu \"jɛi ɔ 'naa : Ao 'na ao juo 'ʋn 'ɛ, ‑wɛe ‑ta 'ɩn 'wlʋa ao juo 'o ‑mɔ ? 'De ‑mɛ 'kamɔ 'ɩn se ji 'de 'ma ‑cɛ\" 'ɛ 'nynɩ 'ʋn, 'kaa \"ju ‑jɔ ‑dboa' 'ʋn ɔɔ' 'nynɩ 'ʋn mɛ 'ɩn jii‑. Ɔmɔ ‑nɩ tɔ' ‑tɩ 'a ‑cɛ\" 'kpa, 'kaa ao se ‑mɔ juuo‑. ");
INSERT INTO wob_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","'Mɔ juuɔ', dɛ‑nʋɛ' 'bo ɔ ‑pʋn\" mɔ 'ɩn 'wlʋ, 'de ɔmɔ ‑dbo' 'ʋn. ");
INSERT INTO wob_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","'Sʋ ʋʋa ‑pɔn ʋʋ 'je ɔ inynaa, 'kaa nyɔ jrɔ' se ɔ sʋn ‑pʋn\" ‑te', dɛ‑nʋɛ' ɔɔ' ‑nɛ nɔ\" se 'o nyni ke. ");
INSERT INTO wob_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","'De ‑mɛ 'kamɔ nyʋ ‑tuu\"‑tuu nɩ 'e nyʋ \"klu ʋʋ 'je ɔɔ' ‑tɩ' tɔ' 'ʋn ‑wɛe ʋʋa wlu ka, ʋʋ 'na : ‑Sɔntɩ Klisɩ ‑mɔ ɔ mua jia' 'ee, ɔɔ muɛ jrii' ‑tuu\"‑tuu nʋa' ɔ 'je \"ju ‑jɔ mɔ ‑sii ‑taa ? ");
INSERT INTO wob_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Dɛ nyʋ a \"wuan 'ʋn 'de Sesi 'a ‑tɩ' 'ʋn 'de nyʋ \"klu ɛ, ɛmɛ Fariseɛn‑wi\" 'wɔn, 'sʋ 'sraa ‑saʋn 'a klae\"‑wi\" ke Fariseɛn‑wi\" dboɛ nyʋ ‑wɛe ʋʋ 'je ɔ inynaa‑. ");
INSERT INTO wob_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","'Sʋ Sesi 'na : 'Ɩn ke ao nɩ ‑ta 'mɛ dɛ‑saan\" ke, ‑wɛe 'ɩn 'je 'e \"ju ‑dboa' 'ʋn o de mu. ");
INSERT INTO wob_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Aoa muɛ 'mi i ‑pɔan', 'kaa ao se 'ʋn 'jei, dɛ‑nʋɛ' ‑ta 'ma mua ao se 'bo 'a mua' 'bɛɛ‑. ");
INSERT INTO wob_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","'Sʋ Suifʋ‑wi\" a ‑teeɛ' ba i due 'due ʋʋ 'na : ‑Ta ɔ 'e paa ‑wɛe ‑a se ɔ 'jei ɛ‑ ? ‑Aee' ɔ 'je 'e Suifʋ‑wi\" ‑gbaa' Klɛkɩ‑blʋa \"kpei kɩn mu ‑wɛe ɔ 'je Glɛkɩ‑wi\" dɛ tɔɔ‑ ? ");
INSERT INTO wob_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Wlu ɔ 'tmʋa ‑nɛ, ‑mɛ 'de 'deɛ ‑gblein' ɛ‑ ? Dɛ ‑nɩ aoa muɛ 'mi i ‑pɔan', 'kaa ao se 'ʋn 'jei, dɛ‑nʋɛ' ‑ta 'ma mua nɩa' ao se 'bo 'a jia' 'bɛɛi ɛ‑. ");
INSERT INTO wob_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","'Bo ‑kɔ'ɔ de 'bɔɔwɩ ‑kɔan ‑tɩ' \"kpei ɛ, Sesi nyna i 'bo nyʋ ‑kwea ‑wɛe ɔ kpa wlu \"jɛi, 'de ɔ 'na : ‑Bo \"ni 'natʋn a sea nyɔ nʋ ɛ, ‑mɛ ɔ ji 'nɔ 'ʋn o ‑wɛe ɔ 'je 'na. ");
INSERT INTO wob_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Nyɔ ‑jea 'ma ‑tɩ' tɔ' 'ʋn ɛ, 'kmʋ nɩ ni 'a \"jru mɩ ‑ɛɛ mu 'de ɔ 'ʋn wlʋa' ‑wɛe ‑ɛ ‑je ‑gbuu ‑si'. 'Kamɔ ɛ 'crɩɩɛ 'de Kea 'a 'sbɛ 'di. ");
INSERT INTO wob_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Kea 'a ‑Suu nyʋ ‑jea Sesi 'a ‑tɩ' tɔ' 'ʋn a mua 'jea' a, ɛmɛ ‑ɛɛ ‑tɩ' ɔɔ 'tmʋa 'o 'mʋa‑. Ɛɛ' nɔ\" tu 'di ‑mɛ nyʋ se Kea 'a ‑Suu 'ble ke, dɛ‑nʋɛ' ‑mɛ Sesi se 'e Kea 'a kɛɛma'de 'ʋn mu ke. ");
INSERT INTO wob_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Nyʋ jrʋ' ‑nɩa 'e nyʋ \"klu 'wɔan ɔɔ' wlu ‑nɩ 'sʋ, ʋʋ 'na : \"Ju ‑nɔ, ɔ nɩɛ Kea 'a wlu 'kwajaai ‑o ‑cɛɛn'‑. ");
INSERT INTO wob_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Jrʋ' 'na : Ɔ nɩɛ Nyʋ'pʋʋi ‑o. 'Kaa deejrʋ' 'na : Ao mɔ ɔ naa tɔ' i 'ee, 'de Galileblʋa \"kpei mɔ Nyʋ'pʋʋi 'je 'wlʋʋ ? ");
INSERT INTO wob_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Wlu ‑ɛ ‑crɩɩa' 'de Kea 'a 'sbɛ 'di ɛ se ka 'da 'dee‑ ? Ɛ se 'na 'de Dafidɩ 'a \"ji 'di 'bo Bɛtelɛm Dafidɩ o ‑kwlɔ 'bomɔ Klisɩ 'je 'wlʋʋ‑ ? ");
INSERT INTO wob_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","'Sʋ 'de Sesi 'a ‑tɩ' 'ʋn ɛ, ʋʋa' 'sʋ ‑seea' 'ʋn 'ɛ. ");
INSERT INTO wob_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Nyʋ jrʋ' ‑nɩa 'de ʋʋpʋ \"klu ‑nɩɛi\" ʋʋ 'e Sesi inynaa‑, 'kaa nyɔ jrɔ' se ɔ sʋn ‑pʋn\" ‑te'. ");
INSERT INTO wob_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Ɛ nʋa kan' 'sʋ nyʋ Fariseɛn ke 'sraa ‑saʋn dboa ‑nʋ muɛ 'e ʋʋpʋ o de, ‑wɛe ‑wi\" ‑mʋ 'na : Dɛɛ‑tɩ ao se ɔ ja a‑ ? ");
INSERT INTO wob_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","'Sʋ dboun ‑nʋ 'na : Ka \"ju ‑nɔ ɔ wlua ‑a se nyɔ jrɔ' 'je, ɔ se kan' wlu due'. ");
INSERT INTO wob_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","'Bomɔ Fariseɛn‑wi\" wluu ka, ʋʋ 'na : ‑Ɛ, ao mɔ \"tai‑ aoa' ‑cɛi\" ‑wɛ‑, \"ju ‑nɔ je ao 'srɛ ipoo ‑kee ? ");
INSERT INTO wob_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","'De ‑aa klae\" ke Fariseɛn‑wi\" \"klu ɛ, nyɔ due' koʋn ‑gbai' se ɔɔ' ‑tɩ' tɔ' 'ʋn 'je. ");
INSERT INTO wob_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Nyʋ ‑ʋʋ sea Moisɩ 'a kɛ' juo, ʋʋ nɩɛ 'daɩn nyʋ ‑o ! ");
INSERT INTO wob_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","'Bomɔ ʋʋa' due', Nikodɛmʋ ‑ɔ mua 'e Sesi o \"maʋ\" wluu, ɔ 'na : ");
INSERT INTO wob_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","‑Bo ‑a se nyiɔ 'ɔ wlu 'wɔn, 'de dɛ ɔ nʋa ‑bo ‑a se ɛ juo 'e ‑a ‑bɛɛ' ‑a ‑je ɔ 'pee kpʋʋn‑ ? ");
INSERT INTO wob_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","'Sʋ ʋʋ 'na : ‑Mɔ 'ee, ‑ɩn ‑nɩɛ Galile i ‑o ‑kee ? ‑Mɛ ‑ɩn ‑gbʋn 'e 'sbɩ 'di kea' ka Kea 'a wlu 'kwajaai due' koʋn ‑gbai' ka sea 'e Galileblʋa \"kpei 'wlʋ due' ‑ma muɛ kan' 'jea' ! ");
INSERT INTO wob_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Ʋʋ ‑kɔa' kan' 'daa' 'sʋ ʋʋ muɛ ‑gbɛin\" woi due due'. ");
INSERT INTO wob_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","'Sʋ Sesi muɛ 'e olifɩ‑crʋ \"kpei. ");
INSERT INTO wob_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","‑Sɔn' 'ɔ ‑nɛɛ ‑sɩan' ‑klae\" pɛɛn 'sʋ, Sesi ‑cruuɛn 'de Kea ‑gbu klaa\" 'di ke'wlɛ ‑wɛe nyʋ ‑wee' \"klein a mu 'de ɔ o. 'Sʋ ɔ ‑teɛ i, ‑wɛe ɔɔ tɔɔ ʋʋpʋ dɛ. ");
INSERT INTO wob_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","'Sʋ 'nynɔkpao' due' ʋʋ kpʋʋn a jɛi\" \"kpei ɛ, ʋmʋ kɛ' wɔ‑saʋn o, Fariseɛn‑wi\" 'ble too' ‑too too\" 'sʋ ʋʋ ja 'o nyʋ ‑wee' \"juɔi. ");
INSERT INTO wob_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","'De ʋʋ wlu 'e Sesi ‑pee, ʋʋ 'na : Nyʋ dɛtɔɔi, 'nynɔkpao' ‑nʋ, nyʋ kpʋʋn jɛi\" \"kpei. ");
INSERT INTO wob_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Moisɩ 'a kɛ' 'na ʋʋa' 'nynʋkpae' tu ɛ, nyʋ tbaa ʋʋpʋ \"soi i 'sʋ ʋʋ 'e 'mɛ. 'De ‑mɔ 'ee, ka ‑ma ‑da a‑ ? ");
INSERT INTO wob_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Ʋʋa 'tmʋ ɛɛ' wlu tu 'mɛ ‑wɛe ʋʋ 'je ɔ wlu 'a \"klɛ bʋ 'dei ‑te' 'de ʋʋ 'je ɔ ‑tɩ' \"kpei bla. 'Kaa Sesi ‑criɛ\" \"jri i ‑wɛe ɔɔ nʋ ‑cɩɛ, ɔɔ 'crɩ 'o 'blʋɔ. ");
INSERT INTO wob_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Ka ʋʋpʋ a ‑tee' ɔ i sɔu\" sɔu\", 'kamɔ ʋʋa ‑tee' ɔ i. 'Sʋ Sesi kpa \"jru \"jɛi, ɔ 'na : Nyɔ ‑nɩa 'de aopʋ \"klu ‑wɛe ‑ɔ sea dɛsaʋn nʋ due' ɛ, ‑mɛ ‑mɔ ‑saa \"i ɔ 'e \"sou po. ");
INSERT INTO wob_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","'Sʋ ɔ ‑criɛ\" \"jrii ke'wlɛ ‑wɛe ɔɔ 'crɩ 'o 'blʋɔ. ");
INSERT INTO wob_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","‑Ta ʋʋ 'wɔan wlu ‑nɩa 'mʋa‑ 'sʋ ʋʋa' pɛe a ‑cɛ' ʋʋpʋ \"bli. 'Sʋ dɛ ‑tba' 'e ʋʋa' klae\" o ‑wɛe ‑ɛ ‑jɩɩa ʋʋa' mɩɩ\" ʋʋ ‑wee' a mu' due 'due, 'sʋ Sesi ke 'nynɔkpao' ‑nyna i 'bo ɔ \"juɔi ‑nʋ 'a 'sʋ sie 'o. ");
INSERT INTO wob_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","'Sʋ Sesi kpa \"jri \"jɛi ‑wɛe ɔ wlu 'de ʋ ‑pee, ɔ 'na : 'Nynɔkpao', ‑ta nyʋ ‑ʋʋa ‑nɩɩa' aʋn ‑tɩ' \"kpei ‑wee' mu ɛ‑ ? Nyɔ jrɔ' se aʋn 'pee kpʋʋn‑ ? ");
INSERT INTO wob_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Ʋ 'na : Ɩɩn Tʋ\"bo, nyɔ jrɔ' se 'ʋn 'pee kpʋʋn ‑o. 'Sʋ Sesi 'na : 'Mɔ se aʋn 'pee kpʋʋn i ‑ke. A mu, 'kaa a 'bo dɛsaʋn nʋɛ 'bode. ");
INSERT INTO wob_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Sesi wluɛ ʋʋ ‑pee ke'wlɛ, ɔ 'na : 'Mɔ ‑nɩ 'kmʋ 'a ‑sɔn'. Nyɔ ‑bla' 'bo 'ʋn 'de ɛ, ‑mɛ ɔ se 'e kwie 'di naai 'bode, 'kaa ɔ nɩɛ 'e ‑sɔn' ‑ɛɛ ‑nyɩa\" nyʋ 'kmʋnɩa' 'ʋn. ");
INSERT INTO wob_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","'Bo ‑mɛ \"kpei 'sʋ Fariseɛn‑wi\" wlu' 'de ɔ ‑pee, ʋʋ 'na : ‑Tɩ' ‑ma ‑tmʋa ɩ se tɔ' ‑tɩ nɩ‑, dɛ‑nʋɛ' ‑ma poɛ ‑ma ‑cɛ\" 'kpa ‑tɩ' o. ");
INSERT INTO wob_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","'Bomɔ Sesi 'na : ‑Bo 'ma sea 'ma ‑cɛ\" ‑tɩ' o po mɔ 'de ɛ, dɛ 'ma 'tmʋa ɛ nɩɛ tɔ' ‑o, dɛ‑nʋɛ' ‑ta 'ɩn 'wlʋa 'ɩn juo 'o 'ɛ, ‑ta 'ma mua 'ɩn juo 'o 'ɛ, 'kaa aopʋ‑ mɔ se ‑ta 'ɩn 'wlʋa ke, ‑ta 'ma mua juo‑. ");
INSERT INTO wob_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","'De nyiɔtɔ' 'ʋn mɔ aoa 'jee nyʋ 'a 'pee, 'kaa 'maa 'je nyɔ \"o nyɔ 'ɔ 'pee. ");
INSERT INTO wob_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","'De ‑bo 'ma sea nyʋ 'a 'pee 'je mɔ 'de ɛ, 'ma nyʋ 'a 'pee 'jesʋn nɩɛ tɔ', dɛ‑nʋɛ' 'ɩn se due' nɩ, 'ɩn \"Bo ‑dboa' 'ʋn ke 'ma ‑a ‑na'. ");
INSERT INTO wob_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Ɛ 'crɩɩɛ mɔ 'de aoa' kɛ' 'di, ɛ 'na : ‑Bo nyʋ 'sɔɔn 'je dɛ 'ɛ ‑ta, ‑wɛe ʋʋ 'tmʋ dɛ due' ɛ, ‑mɛ dɛ ʋʋ 'tmʋa ɛ nɩɛ tɔ' ‑o. ");
INSERT INTO wob_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","'Ma poɛ 'ma ‑cɛ\" 'kpa ‑tɩ' o ‑wɛe 'ɩn \"Bo ‑dboa' 'ʋn ‑mɔ ɔ po 'ʋn ‑tɩ' o ‑ke. ");
INSERT INTO wob_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","'Sʋ ʋʋ ‑tee' ɔ i, ʋʋ 'na : ‑Ta ‑ɩn \"Bo mɔ nɩ ɛ‑ ? 'Sʋ Sesi 'na : Ao se 'mɔ juo‑, ao se 'ʋn \"Bo juo‑. ‑Bo ao juo 'ʋn 'de ɛ, ‑mɛ ao 'bɛɛ‑ ao 'je 'ʋn \"Bo juo ‑ke 'de‑. ");
INSERT INTO wob_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","‑Ta Sesi a 'tmʋa wlu ‑nɩa 'mʋa‑ ‑mɛ ɔ nɩɛ nyʋ dɛ tɔɔa' 'de Kea ‑gbu klaa\" 'di, ‑ta 'wɛi 'dipodɛ nɩa fɔ o ɛ. Nyɔ jrɔ' se ɔ sʋn ‑pʋn\" ‑te', dɛ‑nʋɛ' ɔɔ' kpʋn nɔ\" se 'o nyni ke. ");
INSERT INTO wob_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Sesi wlu' ke'wlɛ, ɔ 'na : 'Ma muɛ mua' ‑wɛe ao 'je 'mi i ‑pɔn, 'kaa aoa muɛ 'mɛa' 'de aoa' dɛsaʋn 'di, dɛ‑nʋɛ' ‑ta 'ma mua ao se 'o 'a jia' 'bɛɛ‑ i. ");
INSERT INTO wob_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","'Bo ɛɛ' wlu tu \"kpei 'sʋ Suifʋ‑wi\" 'na : Ɔ 'je ɔɔ' ‑cɛ\" 'dba ‑ae, ‑aee' dɛɛ‑tɩ ɔ 'na ‑ta 'ma mua ao se 'o 'a jia' 'bɛɛi ɛ‑ ? ");
INSERT INTO wob_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","'Sʋ Sesi 'na : Aomɔ 'wlʋɛ 'nɔ 'blʋa‑ \"kpei, 'kaa 'mɔ 'wlʋɛ 'e jaʋn 'di, ao nɩɛ 'kmʋ ‑nɛ 'ɛ nyʋ ‑o, 'kaa 'mɔ se 'kmʋ ‑nɛ 'ɛ nyɔ nɩ‑. ");
INSERT INTO wob_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Ɛmɛ ‑tɩ 'ɩn 'na : Aoa muɛ 'mɛa' 'de aoa' dɩsaɩn 'di. Dɛ 'ɩn nɩa 'ʋn ‑bo ao se ɛ tɔ' 'ʋn 'je ɛ, aoa muɛ 'mɛa' 'de aoa' dɩsaɩn 'di. ");
INSERT INTO wob_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","'Sʋ ʋʋ ‑tee' ɔ i, ʋʋ 'na : Nyɔ ‑ɩn ‑nɩ mɔ 'de ɛ‑ ? Sesi 'na : Dɛ 'ɩn 'tmʋa ao ‑pee sese ɛmɛ 'ɩn nɩ 'ʋn. ");
INSERT INTO wob_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","'Ɩn 'bleɛ dɩ ‑tuu\"‑tuu 'ɩn 'je 'tmʋ 'de 'ɩn 'je ‑tɩ' ‑pʋn\" tba 'de aopʋ‑ 'ʋn 'de‑, 'kaa \"ju ‑dboa' 'ʋn a 'tmʋɛ tɔ' ‑tɩ. Dɩ 'ɩn 'wɔan 'de ɔ 'wɔn ɛ, ɩa' 'sʋ 'ma 'tmʋ 'de 'blʋa 'dinyʋ ‑pee. ");
INSERT INTO wob_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","'Kaa ka ɔɔ 'tmʋa \"Bo 'a ‑tɩ' 'de ʋʋ ‑pee ɛ, ʋʋ sɩ 'mii 'wɔn. ");
INSERT INTO wob_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","'Sʋ Sesi 'na : ‑Sɔntɩ aoa mua nyiɔ 'ɔ \"Ju tu ‑kwlɩ\" kɔa' a ‑wɛe ʋʋ 'jeɔ i nynaa a, 'bomɔ dɛ 'ɩn nɩa 'ʋn ao 'je ɛ juo‑. 'Maa ‑sa 'o 'ma ‑cɛ\" ‑kwlɩ\" 'maa nʋ dɛ. Dɛ 'ɩn \"Bo tɔɔa 'ʋn ɛmɛ 'ma nʋ. ");
INSERT INTO wob_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","\"Ju ‑dboa' 'ʋn ke 'ma ‑a ‑na', ɔ se 'ma 'sʋ \"i \"tai‑, dɛ‑nʋɛ' ɔɔ' ‑kwlʋtɩ mɩ 'ma nʋ jeejee. ");
INSERT INTO wob_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","‑Ta Sesi a wlua kan', 'sʋ nyʋ ‑tuu\"‑tuu ‑a ‑je ɔɔ' ‑tɩ' tɔ' 'ʋn. ");
INSERT INTO wob_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","'Sʋ Sesi wlu' 'de Suifʋ‑wi\" ‑jea ɔɔ' ‑tɩ' tɔ' 'ʋn ‑pee, ɔ 'na : Wlu 'ma tɔɔa aopʋ‑ ‑bo ao kpʋn ɛ i ‑sisi' ɛ, ‑mɛ ao nɩɛ 'ma klai\" nynuu ‑cɔɔn' ‑o. ");
INSERT INTO wob_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","‑Mɛ aoa muɛ tɔ' ‑tɩ jua', ‑wɛe tɔ' ‑tɩ 'je ao seie. ");
INSERT INTO wob_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","'Sʋ ʋʋ 'na : ‑A ‑mɔ ‑nɩɛ Ablaam 'a \"nynuu‑ ‑o, ‑a se nyɔ jrɔ' 'ɔ kʋɔn nɩ due', dɛɛ ‑tɩ ‑ɩn ‑na aoa muɛ aoa' ‑cɛ\" ‑pee ‑tea' a‑ ? ");
INSERT INTO wob_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","'De Sesi 'na : 'Ma 'tmʋʋɛ aopʋ‑ tɔ' ‑tɩ, nyɔ \"o nyɔ ‑ɔɔ nʋa dɛsaʋn ɛ, ‑mɛ ɔ nɩɛ dɛsaʋn 'a kʋɔn ‑o. ");
INSERT INTO wob_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","'De kʋɔn ‑mɔ ɛ, ‑gbu\" ‑ɛ 'di ɔɔ nʋʋa nyʋ \"juɔi ɛ, ɔ se 'o \"ikɔn‑, 'kaa \"ju mɔ ‑kɔn 'o \"i, ɔ nɩɛ ɔ \"bo 'a \"ju jeejee. ");
INSERT INTO wob_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","'De ‑bo Kea 'a \"Ju ‑mɔ seie aopʋ‑ ɛ, ‑mɛ ao ‑teɛ aoa' ‑cɛ\" ‑pee ‑cɛɛn'‑ ‑cɛn ‑cɛɛn'‑. ");
INSERT INTO wob_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Ka ao 'wlʋa' 'e Ablaam 'a \"ji 'di ɛ, 'ɩn juoɛ', 'kaa aoa ‑pɔn 'ma 'dbaa' i, dɛ‑nʋɛ' 'ma wlu 'a pa 'de aopʋ 'ʋn. ");
INSERT INTO wob_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Dɛ 'ɩn 'jea 'de 'ʋn \"Bo o ɛ, ɛmɛ 'ma 'tmʋ, 'kaa aomɔ ɛ, dɛ ao \"bo ‑tua\" ao wɔn ɛ, ɛmɛ aoa nʋ. ");
INSERT INTO wob_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","'Sʋ ʋʋ 'na : ‑A \"bo ‑nɩ Ablaam. 'Bomɔ Sesi 'na : ‑Bo ao nɩ Ablaam 'a \"nynuu 'de ɛ, ‑mɛ ao 'beeɛ' ao 'je ɔɔ' kplɩn nʋ 'de‑. ");
INSERT INTO wob_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","'Kaa kaan ka 'mɔ ‑ɔɔ ‑tmʋʋa aopʋ tɔ' ‑tɩ 'ɩn 'wɔan 'de Kea 'wɔn ɛ, aoa ‑pɔn 'ma 'dbaa' ‑kɔ i. Ablaam ‑mɔ se ‑mɛ nʋ o. ");
INSERT INTO wob_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Aoa nʋɛ ao \"bo 'a kplɩn. 'Sʋ ʋʋ 'na : ‑A se ‑pɔe' nynuu nɩ‑, Kea due' koʋn ‑gbai' mɛ ‑nɩ ‑a \"Bo. ");
INSERT INTO wob_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","'De Sesi 'na : ‑Bo Kea nɩ ao \"Bo 'de ɛ, ‑mɛ ao 'beeɛ' ao 'je 'ma ‑tɩ' kma‑, dɛ‑nʋɛ' 'de Kea o 'demɔ 'ɩn 'wlʋ ‑wɛe 'ɩn ji 'nɔ 'blʋa‑ \"kpei. 'Ɩn se ji 'de 'ma ‑cɛ\" 'kpa 'a 'nynɩ 'ʋn, 'kaa ɛmɛ ‑dbo' 'ʋn. ");
INSERT INTO wob_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Dɛɛ ‑tɩ aoa' 'wɔn 'ma wlu 'mii ɛ ? Ɛmɛ ‑nɩ ao se ɛ 'bɛɛ‑ ao 'je 'ma wlu doin\" o po see. ");
INSERT INTO wob_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Ao \"bo ‑nɩ ‑siɔn', ɛmɛ ‑tɩ ao nɩɛi\" ao 'je ao \"bo 'a ‑kwlʋtɩ nʋ. ‑Siɔn' nɩɛ \"ku 'dbai ‑o sese. Ɔɔ' nʋ tɔi\" ‑tɩ 'nɔ 'kmʋ, dɛ‑nʋɛ' tɔ' ‑tɩ se 'de ɔ 'ʋn nɩ‑. ‑Bo ɔɔ sea sɩ 'tmʋ ɛ, ‑mɛ ɔɔ ‑sa' 'bo ɔɔ' ‑cɛ\" ‑kwlɩ\" ɔɔ jea 'tmʋ, ka ɔ jua ɛ 'mii see ɛ, dɛ‑nʋɛ' ɔ nɩɛ sɩ 'tmʋ i, ɔmɔ ‑nɩ sɩ \"bo. ");
INSERT INTO wob_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","'Kaa 'mɔ ɛ, 'ma 'tmʋɛ tɔ' ‑tɩ, ɛmɛ ‑tɩ aoa' 'je 'ma ‑tɩ' tɔ' 'ʋn. ");
INSERT INTO wob_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Nyɔ wɛ‑ ‑je 'ma dɛsaʋn ‑cɩɛ \"kpei ‑te' kaan‑ 'de ao \"klu ɛ‑ ? 'De ‑bo 'ma sea tɔ' ‑tɩ 'tmʋ 'ee, ‑mɛ dɛɛ‑tɩ aoa' 'je 'ma ‑tɩ' tɔ' 'ʋn ɛ‑ ? ");
INSERT INTO wob_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Nyɔ ‑wlʋa 'e Kea 'ʋn ‑mɔ ɔ poɛ Kea 'a wlu doin\" o, 'kaa aomɔ se 'e Kea 'ʋn 'wlʋ, ɛmɛ ‑tɩ aoa' po ɛɛ' wlu doin\" o. ");
INSERT INTO wob_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","'Sʋ Suifʋ‑wi\" wlu ɔ ‑pee, ʋʋ 'na : ‑A ‑sa tɔ' ‑aa ‑jea ‑ʋn Samadikɔin 'daa‑, ‑siɔn' 'ɔ ‑suu ‑nɩ 'de ‑ɩn 'ʋn ‑cɛɛn'‑ ! ");
INSERT INTO wob_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","'Sʋ Sesi wlu' ka, ɔ 'na : ‑Siɔn' 'ɔ ‑suu se 'de 'ʋn nɩ‑, 'kaa 'ma 'bɛɛ‑ 'ʋn 'Bo 'a 'nynɩ \"i, 'de aopʋ mɔ ɔ ‑flɛɛn' 'ʋn 'ɛ. ");
INSERT INTO wob_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","'Ɩn se 'ma ‑cɛ\" 'ɛ 'nynɩ 'wlʋa i‑pɔn, \"ju due' ‑nɩ 'o ‑ɔɔ ‑pɔn 'ma 'nynɩ 'wlʋa' i, ɔmɔ ‑nɩ 'pee 'jei. ");
INSERT INTO wob_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","'Ma 'tmʋɛ tɔ' ‑tɩ 'a tɔ' ‑tɩ, nyɔ ‑ɔɔ ‑jea 'ma wlu wɔn ɛ, ɔ se 'mɛi 'nɔ 'kmʋ. ");
INSERT INTO wob_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","'Sʋ Suifʋ‑wi\" 'na : 'Aa ! \"Bo, ka ‑siɔn' 'ɔ ‑suu nɩa 'de ‑ɩn 'ʋn ɛ, ‑a ‑je kan' ‑wɛ‑ la, Ablaam ke Kea 'a wlu 'kwajaaʋn ‑wee' 'mɛɛ, ‑wɛe ‑mɔ ‑naa' nyɔ ‑jea 'ma wlu wɔn ɛ, ‑mɔ se 'mɛi \"pɩ. ");
INSERT INTO wob_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Ablaam ‑nɩa ‑a \"bo ‑mɔ 'mɛɛ, ‑maa naa tɔ' i ‑ɩn ‑bɛ\"i ‑ɩn je ɔ ‑sii ? 'De Kea 'a wlu'kwajaʋn‑wi\" ‑mʋ ‑wee' 'mɛɛ ‑ke, dɛ ‑ma ‑daa' ‑ma ‑cɛ\" ɛ‑ ? ");
INSERT INTO wob_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","'Sʋ Sesi 'na : ‑Bo 'ma sea 'ma ‑cɛi\" 'bɛɛ' 'de ɛ, ‑mɛ 'ma 'nynɩ se dɛwɔn nɩ‑, 'kaa 'ɩn \"Bo aoa 'daa‑ aoa' Kea a, ɛmɛ ‑ɛɛ ‑bɛɛ' 'mi \"i. ");
INSERT INTO wob_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","'Kaa ao se ɛ juo‑, 'mɔ juuɛ' 'mɛ. ‑Bo 'ɩn 'na 'ɩn se ɛ juo ɛ, ‑mɛ ka ao nɩa sɩ 'tmʋʋn, 'kamɔ 'ma mu nɩa'. 'Kaa 'ɩn juuɛ' ‑wɛe 'ma 'je ɛɛ' wlu wɔn. ");
INSERT INTO wob_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Ablaam ‑jɔ ‑nɩa aopʋ \"bo ɛ, 'ma jia' 'bleɛ ‑mɔɔ' 'mʋa‑, ‑sɔntɩ ɔ 'jee ɛ \"jriɛ‑, ɔ 'di nmɔ wɔn. ");
INSERT INTO wob_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","'Sʋ Suifʋ‑wi\" 'na : ‑Mɔ ‑sea' ‑sɩn 'a kwla ‑mm\" 'ble ke ɛ, ‑mɔ ‑jee' Ablaam \"jriɛ‑ ! ");
INSERT INTO wob_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","'De Sesi 'na : 'Ma 'tmʋ aopʋ tɔ' ‑tɩ 'a tɔ' ‑tɩ ‑ta Ablaam a 'wlʋʋa, ‑mɛ 'ɩn nɩ sese. ");
INSERT INTO wob_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Ɔ 'tmʋa wlu ‑nɛ 'sʋ ʋʋ 'tɩɩɛn \"sei kwa ‑wɛe ʋʋ 'je ɔ itbaa‑. 'Sʋ ɔ \"maa ʋʋpʋ \"jrii wɔɔ‑, ‑wɛe ɔ 'wlʋ 'e Kea ‑gbu klaa\" 'di. ");
INSERT INTO wob_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","‑Ta Sesi a ‑sia' 'sʋ ɛ, ɔ 'jeɛ \"ju due' ‑ɔ 'wlʋʋ‑ \"jri 'a waa' 'ʋn. ");
INSERT INTO wob_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","'Sʋ Sesi 'a klai\" nynuu ‑tee' ɔ i, ʋʋ 'na : Nyʋ dɛtɔɔi, ‑ɔ nʋ dɛsaʋn ‑wɛe \"ju ‑nɔ 'ɔ 'jei ɛ‑ ? Ɔɔ' ‑cɛ\" 'kpa ‑aee' ‑ɩn\" ɔ \"bo ke de kee‑ ? ");
INSERT INTO wob_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","'Sʋ Sesi ‑sɛ \"kpei ɔ 'na : Ɛ se ɔmɔ o, nyʋ ‑wlu ɔ ‑nʋ' dɛsaʋn ko‑, 'kaa ɛ nɩ kan' 'mɛ ‑wɛe Kea 'a nʋʋ dɩ 'je \"jri \"kpae po 'de ɔ 'ʋn. ");
INSERT INTO wob_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","‑Ta ‑sɔn' nɩɩa 'e ke ɛ, 'ɩn 'je \"ju ‑ɔ dboa 'ʋn 'a dbo nʋ ‑o, dɛ‑nʋɛ' kwie ‑ɛ 'ʋn nyɔ sea 'bɛɛ‑ ɔ 'jea dbo jrɛ' nʋʋ ɛ, ɛɛ kpʋn'. ");
INSERT INTO wob_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","‑Ta 'ɩn nɩɩa 'nɔ 'blʋa‑ \"kpei ke ɛ, 'ɩn nɩɛ 'kmʋ 'a ‑sɔn' ‑o. ");
INSERT INTO wob_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Sesi ‑kɔa' dɛ ‑nɛ 'ɛ 'tmʋa' 'sʋ, ɔ poɛ tɔn 'o 'blʋɔ ‑wɛe ɔ crii ɛɛ' 'pɔɔ ‑cɩɛi\", 'de ɔ cɛɛn \"dɔi ‑nɔ 'pɔɔ \"jri, ");
INSERT INTO wob_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","‑wɛe ɔ wlu ɔ ‑pee, ɔ 'na : ‑Ɩn mu 'e \"niɔ 'bo Siloe wɔn ‑wɛe ‑ɩn ‑je \"jri i 'sran. (Siloe ‑nɛ, ɛ 'de mɛ ‑nɩ ‑tadboi.) \"Dɔi mu 'e 'mɛ kan' ‑cɛɛn'‑, ‑wɛe ɔ 'sran \"jri i. ‑Ta ɔɔ jiia de ‑mɛ ɔɔ 'jeɛ i 'pepe. ");
INSERT INTO wob_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","'Sʋ nyʋ ‑ʋʋ ‑ke ɔ \"kʋʋan i ke nyʋ ‑ʋʋ ‑juɔ ‑ta ɔɔ ‑srɔɔa nyʋ o tɛin\" ‑ke, ʋʋ 'na : \"Ju ‑ɔɔ ‑tea i ‑wɛe ‑ɔɔ ‑srɔa' nyʋ o 'de ɛ, ɔ ko ‑taa ? ");
INSERT INTO wob_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Nyʋ jrʋ' 'na : Ɔmɔ ‑o. Jrʋ' 'na : \"Ɩɩn‑ ɔ ko‑, 'kaa ɔɔ' ‑kooɔ' i ‑o. 'Sʋ ɔmɔ 'ɔ ‑cɛ\" 'kpa 'na : 'Mɔ ‑o. ");
INSERT INTO wob_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","'Sʋ ʋʋ ‑tee' ɔ i, ʋʋ 'na : Ka ‑ma \"jri nʋ 'baisʋn ɛ‑ ? ");
INSERT INTO wob_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Ɔ ‑sɛ \"kpei ɔ 'na : \"Ju nyʋ a 'daa‑ Sesi ɛ, ɔmɔ ‑cɛn' 'ʋn 'pɔɔ \"jri ‑wɛe ‑ɔ ‑na ‑ɩn mu \"jrii 'sran 'de Siloe wɔn. 'Demɔ 'ɩn mu kan' ‑cɛɛn'‑ ‑wɛe 'ɩn 'sran \"jrii 'sʋ 'ma \"jri 'bai‑. ");
INSERT INTO wob_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","‑Wɛe ʋʋ ‑tee' ɔ i, ʋʋ 'na : ‑Taka ɔɔ' \"ju tu nɩ ɛ‑ ? 'Sʋ ɔ 'na : 'Ɩn se 'o juo‑. ");
INSERT INTO wob_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","'Sʋ ʋʋ kpa \"dɔi ‑ɔɔ \"jri ɔ 'baia' ‑nɔ 'e Fariseɛn‑wi\" \"juɔi. ");
INSERT INTO wob_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","'De 'wɩ ‑ɛ 'di Sesi nʋa 'pɔɔ ‑wɛe 'baia' \"ju ‑nɔ 'ɔ \"jri 'mʋa‑ ɛ nɩɛ ‑kwlewɩ ‑o. ");
INSERT INTO wob_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","'Sʋ Fariseɛn‑wi\" a ‑tee' ɔ i ke'wlɛ, 'de dɛ ‑nʋʋa ɔ \"jrii ‑wɛe ka ɔ nʋa i 'jesʋn 'a ‑po' bla. 'Bomɔ ɔ poo ʋʋpʋ \"kuan, ɔ 'na : Ɔ cɛn 'ʋn 'pɔɔ \"jri ‑wɛe 'ɩn 'sran \"jri i 'de 'ma 'je i 'pepe. ");
INSERT INTO wob_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Fariseɛn jrʋ' 'na : \"Ju ‑nʋa dɛ ‑nɛ ɛ, ɔ se 'e Kea 'ʋn 'wlʋ, dɛ‑nʋɛ' ɔɔ' 'je ‑kwlewɩ 'a kɛ' wɔn. 'Kaa deejrʋ' 'na : Dɛsaʋn nʋi 'beeɛ' ɔ 'je jrii' ‑nɩa kan' nʋʋ ? 'Sʋ ʋʋ ‑seea' 'ʋn 'ɛ 'bo ʋʋa' 'sʋ 'nynɩ. ");
INSERT INTO wob_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","'Sʋ Fariseɛn‑wi\" ‑teeɛ' \"dɔi ‑nɔ i ke'wlɛ, ʋʋ 'na : \"Ju ‑baia' ‑ma \"jri 'ee, ka ‑ma naa tɔ' i 'de ɔɔ' ‑tɩ' 'ʋn ɛ‑ ? 'Sʋ ɔ 'na : Ɔ nɩɛ Kea 'a wlu 'kwajaai due' ‑o. ");
INSERT INTO wob_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Ka \"ju ‑nɔ 'wlʋa 'sʋ ɔɔ' 'jea i ɛ, ‑wɛe ɔɔ 'jea i kaan ka a Suifʋ‑wi\" se ɛ \"inɩ ʋʋ 'je ɛ tɔ' 'ʋn 'je. Ʋʋ nʋɛ' mamaʋ 'sʋ ʋʋ je ɔ \"bo ‑wi\" 'da. ");
INSERT INTO wob_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","‑Wɛe ʋʋ ‑tee' ʋʋpʋ i, ʋʋ 'na : \"Ju ‑nɔ ao 'na aoa' \"ju ‑ɔ ‑wlʋʋa' \"jri 'a waa 'ʋn ‑oo ? 'De kɛ nʋ kaan ka ‑wɛe ɔɔ 'je i ɛ‑ ? ");
INSERT INTO wob_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","'Sʋ ɔ \"bo ‑wi\" 'na : Ɩɩn ‑aa \"ju ‑o, ɔ 'wlʋʋɛ \"jri 'a waa 'ʋn ‑cɛɛn'‑. ");
INSERT INTO wob_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","'Kaa ka ‑jɔ ɛ nʋa ‑wɛe ɔɔ 'jea i ke, 'de nyɔ ‑baia' ɔɔ' \"jri ɛ ‑a se ‑mɩ juo‑. Ao ‑tee' ɔɔ' ‑cɛ\" 'kpa i, ka \"junmɔu a 'bɛa ‑wɛe ɔɔ 'tmʋa ɔɔ' ‑cɛ\" 'ɛ \"kpei ‑tɩ ɛ, 'kamɔ ɔ 'bɛa 'o. ");
INSERT INTO wob_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Dɛɛ‑tɩ ‑wɛe ɔ \"bo ‑wi\" wlua dɛ ‑nɛ 'ʋn ɛ, ɛmɛ ‑nɩ faʋn ‑a nʋ ʋʋpʋ, dɛ‑nʋɛ' Suifʋ‑wi\" 'bɛɛ‑ wlu 'ʋn 'ɛ sese, ʋʋ 'na nyɔ \"o nyɔ ‑ɔɔ mua Sesi Nyʋ 'pʋi Klisɩ 'daa' a, ʋʋa muɔ 'de ʋʋa' Kea ‑gbu klaa\" 'di ‑saa'. ");
INSERT INTO wob_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Ɛmɛ ‑tɩ ‑wɛe ɔ \"bo ‑wi\" 'na : Ɔ ‑kwɛ‑ɛ \"junmɔu 'mɛ, ʋʋ ‑tee' ɔɔ' ‑cɛ\" 'kpa i. ");
INSERT INTO wob_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","'Sʋ Fariseɛn‑wi\" 'da \"ju ‑ɔɔ \"jri 'baia' ‑nɔ 'mɛ ke'wlɛ, ‑mɛ ɔɔ' 'daa kpɛ 'sɔɔn ‑nɩ ‑nao ‑wɛe ʋʋ 'na : ‑Ɩn ‑tmʋ tɔ' ‑tɩ 'bo Kea \"juɔi. ‑Apʋ mɔ juuɛ', \"ju ‑nɔ nɩɛ dɛsaʋn nʋi ‑o. ");
INSERT INTO wob_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","'Sʋ ɔ 'na : ‑Bo ɔ nɩ dɛsaʋn nʋi ɛ, 'mɔ se ‑mɛ juo‑. Dɛ due' koʋn ‑gbai' mɛ 'mɔ juo o, 'mɔ ‑dɔa\" 'de ɛ, 'ma 'jeɛ i kaan ka. ");
INSERT INTO wob_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","‑Wɛe ʋʋ ‑tee' ɔ i ka ʋʋ 'na : Dɛ ɔ nʋ ‑ʋn \"jri i ɛ‑ ? Ka ɔ nʋ ‑ma \"jri 'a 'baisʋn ɛ‑ ? ");
INSERT INTO wob_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","'Sʋ ɔ 'na : 'Ɩn 'tmʋɛ ‑wɛ‑ 'de ao ‑pee 'de‑ ‑wɛe ao 'na ao se ɛ doin\" ‑tu\" i, dɛɛ‑tɩ aoa ‑tee' ɛ 'mi i ke'wlɛ ɛ‑ ? ‑Aee' ao nɩɛ \"i ao 'je ɔɔ' klai\" nynuu nɩɩ‑ ? ");
INSERT INTO wob_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Wlu ‑nɛ seɔ 'wɔin ‑kwɛ 'sʋ ʋʋ ‑teɛ ɔɔ' ‑cree\" 'a ‑pʋn\" ʋʋ 'na : ‑Mɔ ‑nɩ \"ju ‑nɔ 'ɔ klai \"ju, ‑apʋ mɔ nɩɛ Moisɩ 'a klai\" nynuu ‑o. ");
INSERT INTO wob_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","‑A ‑je kan' 'mɛ, Kea wlu' 'de Moisɩ ‑pee, 'kaa ‑ta \"ju ‑nɔ ‑mɔ 'wlʋa ‑a se 'o juo‑ mɔ \"pɩ. ");
INSERT INTO wob_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","'Sʋ \"ju ‑nɔ 'na : ‑Jɛ ‑maa\" a nyʋ tai' ‑mɛ ‑nao, ɛmɛ ‑nɩ ao 'na ‑ta ɔ 'wlʋa ao se 'o juo‑, 'de ‑mɛ 'kamɔ ɔ 'bai‑ 'ma \"jri. ");
INSERT INTO wob_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","'Sʋ ɔ 'na : ‑A ‑je kan' 'mɛ Kea 'a kpʋn dɛsaʋnʋʋn 'a baewlu‑, 'kaa nyɔ ‑ɔɔ ‑je ɛ wɔn ‑wɛe ‑ɔɔ nʋa ɛɛ' ‑kwlʋtɩ ɛ, ɔmɔ ‑ɔɔ baewlu ɛɛ kpʋn. ");
INSERT INTO wob_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Nyɔ ‑wlʋa ‑ɔ sea i 'je due', nyɔ se ɔɔ' \"jri 'bai ke ‑a se ‑mɛ 'wɔn kpɛ due'. ");
INSERT INTO wob_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","‑Bo \"ju ‑nɔ se 'e Kea 'ʋn 'wlʋ 'de ɛ, ɔ se ɛ 'bɛɛ‑ ɔ 'e jrii' jrɛ' nʋ. ");
INSERT INTO wob_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","'Sʋ ʋʋ 'na : ‑Mɔ ‑ɔɔ nyiɔjɔ ‑wee' 'wlʋa 'de dɛsaʋn 'di ɛ, ‑mɔ ‑ɔɔ tɔɔ ‑apʋ mɔ dɛ ! 'Sʋ ʋʋ nʋ ɔ i. ");
INSERT INTO wob_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Ka ʋʋ nʋ ɔ i Sesi 'wɔɩn. Ɔ ke ɔ 'jeea 'de ɔ wlu ɔ ‑pee ɔ 'na : ‑Ɩn ‑je nyiɔ 'ɔ \"Ju 'a ‑tɩ' tɔ' 'ʋn 'ɛɛ ? ");
INSERT INTO wob_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","'Sʋ ɔ 'na : Nyʋ dɛtɔɔi, nyɔ ‑o wɛ‑ ? ‑Ɩn ‑too ɔ 'ʋn, ‑wɛe 'ɩn 'e ɔɔ' ‑tɩ' tɔ' 'ʋn 'je. ");
INSERT INTO wob_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","'Bomɔ Sesi wluu ɔ ‑pee ka, ɔ 'na : Ɔɔ' \"ju tu ‑ɩn ‑jee ɔ \"jriɛ‑ ‑wɛ‑, ɔmɔ ‑ɔ ‑ke ‑ma wlua 'o ‑ta. ");
INSERT INTO wob_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","'Sʋ ɔ 'na : 'Ɩn 'je ɛ tɔ' 'ʋn 'ɛ, 'ma 'blei ! ‑Wɛe ɔ \"sii‑ 'kɔi‑ i 'bo Sesi \"juɔi. ");
INSERT INTO wob_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","'Bomɔ Sesi 'na : 'Ɩn jiɛ 'pee 'je ‑tɩ 'de 'blʋa‑ ‑nɛ \"kpei, ‑wɛe nyʋ ‑ʋʋa' 'jea i ʋʋ 'je i 'je, 'de nyʋ ‑ʋʋa ‑jea i ʋʋ 'je \"dɔ. ");
INSERT INTO wob_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Fariseɛn jrʋ' ‑nɩa 'omu 'wɔan wlu ‑nɩ 'sʋ ɛ, ʋʋ ‑tee' ɔ i, ʋʋ 'na : ‑Apʋ mɔ nɩɛ \"dɔʋn ‑o ‑kee ? ");
INSERT INTO wob_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Sesi 'na : ‑Bo ɛ nɩ aoa' \"jri 'a 'sʋ mɩ ‑wa 'de ɛ, ‑mɛ ao se 'e dɛsaʋn 'di nɩi. 'Kaa aoa 'daa‑ aoa' ‑cɛ\" i 'jeʋn, ɛmɛ ‑tɩ aoa' dɛsaʋn a mu ao \"kpei nɩa' jeejee. ");
INSERT INTO wob_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Sesi pooɛ ‑tɩ' \"i ɔ 'na : 'Ma 'tmʋ aopʋ' tɔ' ‑tɩ, nyɔ ‑sea' 'o 'blae 'a ‑klɛe 'a pawɔn \"i cɛɛn‑, ‑wɛe ‑ɔ ‑jiia ‑klɛe \"jru ‑tajrɔ ɔ, ‑mɛ ‑mɔ 'ɔ jei tu nɩɛ \"jrii ‑o, ɔ nɩɛ \"ku 'dbai. ");
INSERT INTO wob_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","'Kaa nyɔ ‑jɔ ‑cɛɛan 'bo ‑klɛe wɔn \"i ‑wɛe ‑ɔ pa 'e 'blae o ɛ, ɔmɔ ‑nɩ 'blae 'a jei. ");
INSERT INTO wob_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Ɔmɔ 'blae ifuoi a kain \"wɔin ‑wɛe ‑ɔɔ pa 'e ɔɔ' 'blae o. 'De ɔɔ 'da ɔɔ' ‑nɩ 'a 'nynɩ due 'due ‑wɛe ɩa bla 'o ɔ 'de, dɛ‑nʋɛ' ɩ juo ɔɔ' wlu 'mɛ ‑wɛe ɔɔ kpɩ 'e \"kpae'. ");
INSERT INTO wob_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","‑Bo ɔ po ɩ ‑wee' \"klein \"kpae' ɛ, ‑wɛe ɔɔ na 'bo ɩ \"juɔi 'de ɔɔ' 'blae nɩ 'bo ɔ 'de, dɛ‑nʋɛ' ɩ juo ɔɔ' wlu 'mɛ. ");
INSERT INTO wob_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Ɩa' bla 'o nyɔ 'srʋ 'de, ‑bo ɩa se ɔ 'je ‑mɛ ɩa tɛɛn ɔ kɩn ɩa 'kpa 'kwla, dɛ‑nʋɛ' ɩ se nyɔ 'srʋ 'a wlu juo‑. ");
INSERT INTO wob_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Sesi poo ‑tɩ' ‑nɩa 'mʋa‑ \"i 'mɛ 'de ʋʋ ‑pee, 'kaa dɛ ɔ 'tmʋa, nyʋ ‑nɩa 'o ʋʋ se 'e ɛ 'dei 'wɔn. ");
INSERT INTO wob_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Ɛmɛ ‑tɩ Sesi wluu ke'wlɛ, ɔ 'na : Tɔ' ‑tɩ 'a tɔ' ‑tɩ 'ma 'tmʋʋ aopʋ, 'mɔ ‑nɩ 'blae 'a ‑klɛe 'a ‑gbɛin\" ‑je. ");
INSERT INTO wob_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Nyʋ \"klein 'mɔ sea ji ke ‑wɛe ‑ʋʋ jia tɛin\" ɛ, ʋʋ nɩɛ \"jriʋn ke \"ku 'dbaʋn ‑o. 'Kaa 'blae se ʋʋpʋ 'a wlu doin\" o po. ");
INSERT INTO wob_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","'Mɔ ‑nɩ ‑gbɛin\" ‑je, nyɔ ‑ɔ ‑cɛɛan 'o 'mɔ \"i ɛ, ɔɔ muɛ 'pʋʋa'. Ɔ 'bɛɛ‑ ɔ 'je \"kpae' \"si 'de ɔ 'je de ji 'de 'flɛʋn, ɔɔ muɛ diidɛ 'jea' ɔ 'je di. ");
INSERT INTO wob_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","\"Jrii ‑mɔ ɔ jiɛ \"jriia' ke \"ku 'dbaa' ke dɩ dooa 'a 'sʋ 'a jia', 'kaa 'mɔ ji' ‑wɛe 'blae 'je 'kmʋnɩa' 'je 'de 'kmʋnɩa' 'je i siie‑. ");
INSERT INTO wob_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","'Mɔ ‑nɩ 'blaejei ‑cɔɔn'‑. 'Blaejei ‑cɔɔn'‑ ‑mɔ, ɔ to 'e ɔɔ' 'kmʋ 'mɛ 'de ɔɔ' 'blae 'a ‑tɩ' 'ʋn. ");
INSERT INTO wob_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Nyɔ ‑ɔɔ ‑tea' 'blae 'dei ‑wɛe nyʋ 'jea ‑kei\" ‑sa' a, ‑mɔ se 'blae 'a jei ‑cɔɔn' nɩ‑. 'Blae se ‑mɔ 'ɔ dɛ nɩ‑, ɛmɛ ‑tɩ ‑bo ‑ci' a sea 'blae kpʋan' ji, ‑bo ɔ 'je ɛ i 'sʋ ɛ, ‑tbu ! 'Sʋ ɔ 'kpa 'kwla, ‑wɛe ‑ci' a kpʋn ɩ 'de ɛɛ ‑gbɩ' ja. ");
INSERT INTO wob_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Ɔ 'kpa 'kwla, dɛ‑nʋɛ' ɔɔ nʋɛ 'wɛi 'a 'sʋ 'a dbo, ɔɔ' ‑tu\" 'blae 'a ‑sɔɔn. ");
INSERT INTO wob_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","'Mɔ nɩ 'blaejei ‑cɔɔn'‑ ‑o, 'ɩn juo 'ma 'blae 'mɛ ‑wɛe 'ma 'blae juo 'ʋn. ");
INSERT INTO wob_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","Ka 'ɩn \"Bo jua 'ʋn 'kamɔ 'ɩn juo 'ɩn \"Bo, ‑wɛe 'ɩn to 'e 'ma 'kmʋ 'de 'ma 'blae 'a ‑tɩ' 'ʋn. ");
INSERT INTO wob_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","'Blae jrɩ' 'ɩn 'ble ‑ɩ se 'nɔ 'blae‑gbʋn 'di pa ke, 'ɩn 'je ‑mɩ 'nɔ paa ‑o ‑ke, ɩ ‑wee' a muɛ 'ma wlu doin\" o poa', ‑wɛe ɩ 'je 'blae 'a ‑gbʋn due' nɩ‑ 'de ɩa' jei 'je due' koʋn ‑gbai nɩ‑. ");
INSERT INTO wob_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","'Ɩn \"Bo kma 'ma ‑tɩ', dɛ‑nʋɛ' 'ɩn to 'e 'ma 'kmʋ 'mɛ, ‑wɛe 'ɩn 'je ɛ 'ʋn \"duo‑ ke'wlɛ. ");
INSERT INTO wob_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Nyɔ jrɔ' se ɛ 'bɛɛ‑ ɔ 'je 'ʋn 'ma 'kmʋ 'kwa ‑sa. 'Ma ‑cɛ\" 'kpa ‑toɛ 'e mu 'de 'ma ‑cɛ\" 'ɛ ‑kwlʋtɩ 'ʋn. 'Ɩn 'beeɛ' 'ɩn 'je ɛ 'e to‑, 'ɩn 'beeɛ' 'ɩn 'je ɛ 'e ‑cri', dɛ ‑ɛɛ wlu 'ɩn \"Bo ‑tua\" 'ʋn, ‑wɛe 'ɩn 'jea nʋ, ɛmɛ ‑nao. ");
INSERT INTO wob_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Suifʋ‑wi\" 'bɔɔ‑ de ke'wlɛ ʋʋ je 'ʋn ‑seea' 'bo ɔɔ' wlu ‑nɩ \"kpei. ");
INSERT INTO wob_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Aoa' ‑tuu\"‑tuu 'na : ‑Siɔn 'ɔ ‑suu ‑nɩ 'de ɔ 'ʋn, sɩɩan ‑a nʋ ɔ, dɛɛ ‑tɩ aoa po ɔɔ' wlu doin\" o ‑gblein' ɛ‑ ? ");
INSERT INTO wob_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Deejrʋ' 'na : Nyɔ ‑siɔn 'ɔ ‑suu nɩa 'e 'ʋn ɛ, ‑mɔ 'ɔ wlu kan'. 'De ‑suusaʋn mɛ 'bɛɛ‑, ɛ 'e \"dɔʋn 'a \"jri 'bai‑ ? ");
INSERT INTO wob_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Ʋʋ nɩɛ \"i ‑kwɛ‑ ‑kɔ ‑tua\" 'bo Selisalɛm, dee' 'a ji nɔ\". ");
INSERT INTO wob_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","'Sʋ Sesi a na i 'de Kea ‑gbu 'di ‑wɛe ɔɔ mu 'e ɛɛ' ‑gbu\" wɔ ʋʋ ‑tuu\" a Salomɔ 'ɔ 'nynɩ o fɔ o. ");
INSERT INTO wob_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","'Sʋ Suifʋ‑wi\" pooɔ 'o ‑kwea'‑, ‑wɛe ʋʋ 'na : ‑Aa pleeɛ tɔ' i 'de ‑ma ‑tɩ' 'ʋn 'sʋʋ ? ‑Bo ‑ɩn ‑nɩ Klisɩ ɛ, ‑mɛ ‑ɩn ‑tmʋ ɛ 'pepe ke 'de ‑a ‑pee ! ");
INSERT INTO wob_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","'Bomɔ ɔ 'na : 'Ɩn 'tmʋʋɛ aopʋ' ‑wɛ‑ 'de‑, 'kaa ao 'na ao se ɛ tɔ' 'ʋn 'jei. Dɩ \"klein 'ma nʋa 'de 'ɩn 'Bo 'a 'nynɩ 'ʋn ɛ, ɩmɩ ‑ɩa ‑tmʋ 'ma \"kpei ‑tɩ. ");
INSERT INTO wob_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","'Kaa ao 'na ao se ɛ tɔ' 'ʋn 'jei, dɛ‑nʋɛ' ao se 'o 'ma 'blae 'a ‑tɔin\" nɩ‑. ");
INSERT INTO wob_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","'Ma 'blae a poɛ 'ma wlu doin\" o, 'ɩn juo 'ma 'blae 'mɛ, dɛ‑nʋɛ' ɩa na 'ʋn o, ");
INSERT INTO wob_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","'Ma \"nyɩ ɩ 'kmʋnɩa' ‑ɛ sea ‑kwɛ ‑ta 'ble ɛ, ɩ se i sɔn i 'nɔ 'kmʋ 'de nyɔ ‑ɔ ‑jɩ 'de 'ʋn 'kwa \"fla, ‑mɔ se nɩ‑. ");
INSERT INTO wob_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","'Ɩn \"Bo ‑ɛ ‑nyɩ\" 'ʋn ɛ, ɛ 'bɛi\" ɛ je dɩ ‑wee' ‑sii, 'de nyɔ \"o nyɔ jrɔ' se ɛ 'bɛɛ‑ ɔ 'jɩ 'de 'ɩn \"Bo 'kwa \"fla. ");
INSERT INTO wob_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","'Ɩn ke 'ɩn \"Bo nɩɛ dɛ due'. ");
INSERT INTO wob_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Ɔ 'da kan' 'sʋ Suifʋ‑wi\" 'tɛn \"soi ke'wlɛ ʋʋ 'je ɔ itbaa‑. ");
INSERT INTO wob_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","‑Wɛe Sesi wlu ka, ɔ 'na : Dɩ 'dɔe ‑ɩ ‑wlʋa 'de 'ɩn \"Bo o ɛ, 'ɩn nʋɩ' ao jɩ 'je, ɩa' ‑jɛ ‑ɛɛ ‑tɩ' 'ʋn ao 'je 'ʋn \"soi itbaa ‑gbo' ɛ‑ ? ");
INSERT INTO wob_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","'Sʋ ʋʋ 'na : Ɛ se 'de dɛ 'dɔe ‑ma nʋa 'a ‑tɩ' 'ʋn mɔ ‑a ‑na ‑a ‑je ‑ʋn \"soi itbaa nɩ‑, 'kaa ‑ma toɛ Kea wɔn o, ‑mɔ ‑ɔ ‑nɩa nyiɔ ɛ, ‑mɔ ‑ɔɔ nʋ ɔɔ' ‑cɛ\" Kea 'ʋn. ");
INSERT INTO wob_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","'De Sesi 'na : Ɛ se 'crɩɩɛ ka 'de aoa' kɛ' 'di, 'ɩn 'na : Ao nɩɛ ‑kɩɩ' ‑oo ? ");
INSERT INTO wob_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Dɛ kɛ' 'tmʋa, nyɔ jrɔ' se ɛ 'bɛɛ‑ ɔ 'je ɛ i‑sa. 'De ‑bo kɛ' mɛ 'daa‑ nyʋ \"klein Kea 'a wlu 'tmʋʋa ‑pee ‑kɩɩ' 'ee, ‑mɛ dɛ jrɛ' wɛ‑ aoa 'tmʋ ke'wlɛɛ ? ");
INSERT INTO wob_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","'Mɔ Kea ‑sa ‑pʋn\" ‑wɛe ɛ dboa 'nɔ 'blʋa‑ \"kpei ɛ, ‑bo 'mɔ 'na : 'ɩn nɩɛ Kea 'a \"Ju ‑o ɛ ao 'na 'ma toɛ Kea wɔn o ? ");
INSERT INTO wob_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","‑Bo 'maa nʋ dɩ 'ɩn \"Bo \"sia 'nynɩ ɛ, ‑mɛ ao 'bo 'ma ‑tɩ' tɔ' 'ʋn 'jeɛ. ");
INSERT INTO wob_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","'De ‑bo 'ma sea dɩ 'ɩn \"Bo \"sia 'nynɩ nʋ ɛ, ‑mɛ ‑bo aoa' 'je 'ma wlu tɔ' 'ʋn mɔ 'de ɛ, ao 'je ɛɛ' nʋʋdɩ ‑mɩ tɔ' 'ʋn dɛwɛ‑jɛ. ‑Bo ao nʋ kan' a, ‑mɛ ka 'ɩn \"Bo nɩa 'de 'ʋn ‑wɛe 'ɩn nɩa 'de 'ɩn \"Bo 'ʋn ɛ, 'de ao 'je ɛ tɔ' 'ʋn 'je la. ");
INSERT INTO wob_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Ɔ 'da kan' 'sʋ ʋʋa ‑pɔn ɔɔ' kpʋn ‑kɔ i ke'wlɛ, 'kaa ɔ wan ʋʋpʋ 'kwa. ");
INSERT INTO wob_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Ɛ 'wlʋa 'o mu ɛ, Sesi cɛn Sudɛn ‑gbuu, ɔ muɛ 'e ɛ 'de. Ɛɛ' ‑ta San pooa nyʋ \"ni \"jru tɛin\" 'de ɛ, ‑wɛe ɔ ‑te 'bo i. ");
INSERT INTO wob_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","'De nyʋ ‑tuu\"‑tuu a ji 'de ɔ o, ‑wɛe ʋʋa wlu ka, ʋʋ 'na : San se jrii' jrɛ' nʋ ‑mɔ, 'kaa dɩ \"klein ɔ 'tmʋa 'de \"ju ‑nɔ 'ɔ ‑tɩ' 'ʋn ɛ, ɩ nɩɛ tɔ' ‑o. ");
INSERT INTO wob_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","'Sʋ nyʋ ‑tuu\"‑tuu ‑je Sesi 'a ‑tɩ' tɔ' 'ʋn 'bo 'a ‑ta ‑tu. ");
INSERT INTO wob_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","\"Ju due' ‑ɔɔ 'nynɩ ‑nɩa Lasa, ɔmɔ 'wɛ‑ kpʋn. Ɔɔ' \"ju tu \"tiɛ 'o Betani. 'Bo ɛɛ' ‑kwlɔ ‑tu 'di mɔ ɔɔ' de 'dinynʋkpae' Madi ke ʋa' jrɔ' Matɩ nɩ‑. ");
INSERT INTO wob_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Madi ‑nʋ ʋmʋ ‑wla Tʋ\"bo 'a bɩ ‑dai'klɔ \"jru ‑wɛe ‑ʋ ‑jaa ɩ ʋa' \"mɩɩ‑ kui, ʋmʋ ‑ʋa de 'di nmɔu Lasa 'a dɛ ɛ pooa. ");
INSERT INTO wob_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","De'dinynʋkpae' ‑nʋ ʋʋ dboɛ nyɔ Sesi \"i, ‑ʋʋ 'na : Tʋ\"bo, ju ‑ɔɔ ‑tɩ' ‑ɩn ‑kma ɔɔ' dɛ ‑ɛɛ pooa. ");
INSERT INTO wob_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Sesi 'wɔan dɛ ‑nɛ 'sʋ ɔ 'na : Ɛɛ' 'wɛ‑ tu se ɔ 'dbai, ɛ kpʋɔn' ‑wɛe ɛ 'je Kea 'a 'nynɩ \"i 'bɛɛ‑, 'de ɛ 'e Kea 'a \"Ju ‑cian\" \"kpei ‑tu\". ");
INSERT INTO wob_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","'De Sesi kma Matɩ ke ʋʋa' de'di nynɔkpao' ke ʋʋa' \"dei Lasa 'a ‑tɩ'. ");
INSERT INTO wob_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Ɔ 'wɔan Lasa 'a dɛ 'ɛ pooanynɩ ɛ, ‑ta ɔ nɩa, ɔ nʋɛ 'o 'wɩ 'sɔɔn dee‑, ");
INSERT INTO wob_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","‑wɛe ɔ wlu 'de ɔɔ' klai\" nynuu ‑pee, ɔ 'na : ‑A mu 'e Suide de. ");
INSERT INTO wob_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","'Sʋ ɔɔ' klai\" nynuu 'na : Nyʋ dɛtɔɔi, ‑ɩn ‑na dɛ‑ ? 'De Suide Suifʋ‑wi\" a ‑pɔan ‑ma \"soi kpi \"i 'dbaa' ‑kɔ i ɛ, ɛ sea 'ʋn ‑kwle ke ɛ, 'demɔ ‑ɩn ‑na ‑a mu de ke'wlɛɛ ? ");
INSERT INTO wob_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","'Bomɔ Sesi wluu 'de ʋʋ ‑pee ɔ 'na : Dɛ ‑ɛ ‑wlʋa 'e ‑sɔn'ɔ ‑sɩan' ‑wɛe ‑ɛ ‑jɛɛa kwie 'a kpʋan' a, ɛ se 'jrʋ 'a bɩ 'a ‑puue 'jɔ 'sɔɔn nɩ‑ ? ‑Bo ‑sɔn' ‑sɩn' ‑wɛe nyɔ 'e na a, ɔɔ' bɩɛ 'ɛ ‑tiie'‑, dɛ‑nʋɛ' ɔɔ 'jeɛ 'kmʋ 'a ‑sɔn' i. ");
INSERT INTO wob_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","'Kaa ‑bo kwie kpʋn ‑wɛe nyɔ 'e na a, ɔɔ' bɩɛ ɛ ‑tiie', dɛ‑nʋɛ' ɔ se 'de ‑sɔn' 'ʋn nɩ‑. ");
INSERT INTO wob_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Sesi 'tmʋa wlu ‑nɩ 'de ʋʋ ‑pee 'sʋ, ɔ poɛ \"kpei ɔ 'na : ‑Aa \"dɛi Lasa a 'kpa \"nyɩɔ', 'kaa 'ma mu' 'ɩn 'je ɔ \"nyɩɔ' ‑sa. ");
INSERT INTO wob_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","'Sʋ ɔɔ' klai\" nynuu 'na : Tʋ\"bo, ‑bo ɔɔ sea 'mʋ ɛ, ‑mɛ ɔɔ muɛ 'pʋʋa'. ");
INSERT INTO wob_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","‑Jaa'‑ ‑mɛ Lasa 'a 'mɛ ‑tɩ mɩ Sesi a 'tmʋa 'o, 'kaa \"nyɩɔ' ‑cɛɛn' 'kpa‑tɩ mɛ klai\" nynuu a 'wɔn 'mii. ");
INSERT INTO wob_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","'Sʋ Sesi wa wɔn 'mi i, ɔ 'tmʋɛ 'pepe 'de ʋʋ ‑pee, ɔ 'na : Lasa 'mɛɛ. ");
INSERT INTO wob_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","'Kaa ‑Jɛ 'ɩn sea 'o nɩ ‑wɛe ɔ 'mɛa, ɛ 'bleɛ 'ma 'mʋa ɛɛ muɛ nʋa' ‑wɛe aoa' Kea ‑kwlɩ\" ‑tea' 'je iku. 'Kaa ‑a mu 'de ɔ o. ");
INSERT INTO wob_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","'Sʋ Toma nyʋ a 'daa ‑gbaju wlu' 'de klai\" nynuu ‑sia o ‑pee, ɔ 'na : Ao \"nyɩ ‑a mu ‑ke, ‑wɛe ‑a ‑ke ɔ 'e 'mɛ ‑tadue. ");
INSERT INTO wob_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","‑Ta Sesi a nynia 'o Betani ‑mɛ Lasa nʋɛ 'e ‑gbaɩn' 'di 'wɩ ‑nyiiɛ sese. ");
INSERT INTO wob_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","'De Betani se Selisalɛm o tɛɛn‑, ‑je 'a ‑toe taan ‑nɩ 'o ɩ 'nynɩ, ");
INSERT INTO wob_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","ɛmɛ ‑tɩ Suifʋ ‑tuu\" ji Matɩ ke Madi ‑tɩ' ‑kwlɩ' i ‑tu\" 'a 'de ʋʋa' de'di 'a 'mɛ ‑tɩ 'ʋn. ");
INSERT INTO wob_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Matɩ 'wɔan Sesi 'a jinynɩ 'sʋ ɛ, ʋ 'jɔɔ \"i, ‑mɛ Madi ‑mʋ ‑teɛ i 'de ‑gbu\" 'di. ");
INSERT INTO wob_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","'Sʋ Matɩ wlu' 'e Sesi ‑pee, ʋ 'na : Tʋ\"bo, ‑bo ‑ɩn ‑nɩ ‑ta 'de ɛ, ‑mɛ 'ma de'di se 'mɛi 'de oo. ");
INSERT INTO wob_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","'De kaan ka mɔ 'de ɛ, 'ɩn juɛ' dɛ \"klein ‑ma mua Kea i ‑teea' a, ɛɛ muɛ nʋa' see. ");
INSERT INTO wob_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","'Sʋ Sesi wluɛ 'de ʋ ‑pee ɔ 'na : Aa' de'di a muɛ 'kmʋ de jia'. ");
INSERT INTO wob_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","'Bomɔ Matɩ wluu ka ʋ 'na : 'Ɩn 'je kan' 'mɛ, ‑sɔntɩ 'mɛʋn ‑wee' a mua 'kmʋ de jia' a, ɔɔ muɛ 'ʋnsɔan' 'e. ");
INSERT INTO wob_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","'De Sesi 'na : 'Mɔ ‑nɩ \"kunyɩɔ' sɔan', 'mɔ ‑nɩ 'kmʋnɩa', nyɔ ‑ɔ ‑jea 'ma ‑tɩ' tɔ' 'ʋn ɛ, ‑bo ɔ 'mɛ mɔ 'de ɛ, ɔɔ muɛ 'kmʋnɩa'. ");
INSERT INTO wob_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","'De ka nyɔ ‑nɩa 'kmʋ ‑wɛe ‑ɔ ‑jea 'ma ‑tɩ' tɔ' 'ʋn ‑mɔ sea 'mɛi 'bode, a 'je ‑mɛ tɔ' 'ʋn 'ɛɛ ? ");
INSERT INTO wob_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","'Sʋ ʋ 'na : Ɩɩn Tʋ\"bo, ka ‑ɩn ‑nɩa Klisɩ, Kea 'a \"Ju, 'de ‑ma 'nɔ 'blʋa‑ \"kpei ji ‑tɩ 'tmʋʋa sese ɛ, 'ɩn 'jɩ tɔ' 'ʋn 'ɛ. ");
INSERT INTO wob_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Matɩ ‑kɔa' kan' 'daa 'sʋ ʋ muɛ ʋa' \"dei Madi 'daa' ‑wɛe ʋ paa ʋ \"sɩan ʋ 'na : ‑Aa dɛtɔɔi ji' ‑wɛ‑, ɔ 'na a mu. ");
INSERT INTO wob_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Madi 'wɔan wlu ‑nɛ 'sʋ ʋ wan 'o 'blʋɔi ‑fai ‑wɛe ʋ mu 'e Sesi o. ");
INSERT INTO wob_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","‑Ta ɛɛ nʋʋa kan' ‑mɛ Sesi se ‑kwlɔ i \"si ke, ‑ta Matɩ 'jɔɔ \"i ‑wɛe ʋ ke ɔ ‑gbʋʋan' 'bo ɔ nɩ‑. ");
INSERT INTO wob_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","‑Ta Suifʋ‑wi\" ‑a ‑tua\" Madi ‑tɩ' ‑kwlɩ' i a kɔan 'e mu 'sʋ ɛ, ʋ \"siɛ \"kpae' ‑wii\", 'sʋ ʋʋ bla 'bo ʋ 'de, ʋʋmʋ a naa tɔ' i, ʋʋ 'na ‑mɛ ʋa muɛ ‑fɩn\" 'a 'de ‑gbaɩn' \"kpei 'de‑. ");
INSERT INTO wob_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Madi nynia ‑ta Sesi nɩa ‑wɛe ʋ 'jee ɔ \"jriɛ‑ 'sʋ, ʋ ‑gblee ɔ bɩ wɔ, 'de ʋ 'na : Tʋ\"bo, ‑bo ‑ɩn ‑nɩ ‑ta 'de ɛ, ‑mɛ 'ma de'di se 'mɛi 'de oo ‑ba. ");
INSERT INTO wob_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Sesi a kɔan 'e 'sʋ ʋa ‑fɩɩn\", Suifʋ‑wi\" ‑ke ʋ jia ʋʋa ‑fɩɩn\" ‑ke. 'Sʋ ɔ ‑ciian' kui', dɛ‑nʋɛ' ɛ cɛn ɔ pɛe \"i. ");
INSERT INTO wob_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","'De ɔ 'na : ‑Ta ao ‑tee ɔ i ɛ‑ ? 'Sʋ ʋʋ 'na : Tʋ\"bo, ‑ɩn ‑ji\" 'je. ");
INSERT INTO wob_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","'Sʋ Sesi ‑fɩɩn\". ");
INSERT INTO wob_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Suifʋ‑wi\" ‑jee ɔ \"jriɛ 'na : Ao ‑gbʋn dɛ ɔ kma ɔɔ' ‑tɩ' ɛ. ");
INSERT INTO wob_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","'Sʋ nyʋ jrʋ' wlu' ka 'de ʋʋpʋ \"klu, ʋʋ 'na : Ɔmɔ ‑baia' \"dɔi 'a \"jri ɛ, ɔ se ɛ 'bɛɛ‑ ɔ 'je ɛ nʋ ‑wɛe Lasa se 'mɛi 'de o ? ");
INSERT INTO wob_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","'Sʋ Sesi ‑ciian' ku' i ke'wlɛ, ‑wɛe ɔ mu 'e ‑gbaɩn' \"kpei. ‑Jaa'‑ ‑mɛ ʋʋ ‑teɛ' Lasa i 'de 'soa 'a ‑kwlewɔn 'di ‑wɛe ʋʋ nʋ \"soukpo ʋʋ kaan 'o mu. ");
INSERT INTO wob_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Sesi 'na : Ao ‑sa 'o \"soukpo ‑nɛ ! 'Sʋ \"ju ‑ɔ ‑mɛa 'a de'di Matɩ 'na : Tʋ\"bo, ɔ nʋɛ 'e ‑gbaɩn' 'di 'wɩ ‑nyiiɛ, ɔɔ' 'nʋ a ji' la o. ");
INSERT INTO wob_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Sesi 'na : 'Ɩn se 'na ‑bo a ‑te' 'ʋn ‑kwlɩ\" ɛ, aa muɛ Kea 'a 'nynɩ 'wlʋsʋn \"jriɛ‑ 'jeeaa' ? ");
INSERT INTO wob_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Ʋʋ ‑sa 'o \"sou 'mɛ, ‑wɛe Sesi kpa \"jri \"jɛi, 'de ɔ 'na : 'Ɩn \"Bo, 'ma poɛ ɛ 'sɛ‑ dɛ ɛ kpʋn a 'ma baewlu ɛ. ");
INSERT INTO wob_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Ka ɛɛ kpʋn a 'ma bae wlu jeejee ɛ, 'ɩn 'je kan' 'mɛ, 'kaa 'ɩn 'da kan' 'mɛ 'de nyʋ ‑gbaea' 'ʋn 'dei ‑ta 'a ‑tɩ' 'ʋn, ‑wɛe ka ɛ dboa 'ʋn ʋʋ 'je ɛ tɔ' 'ʋn 'je. ");
INSERT INTO wob_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Ɔ 'da kan' 'sʋ ɔ kpa wlu \"jɛi kpleiin, ɔ 'na : Lasa, ‑ɩn ‑si\" \"kpae' ! ");
INSERT INTO wob_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","'Sʋ \"ju ‑mɛa ‑nɔ sɔn 'ʋn 'ɛ. Ka ɔɔ' bɩ ke sɩn ‑piian' dɩfɔ i ɛ, 'kamɔ ʋʋ nʋ ɔɔ' \"jru ‑ke, 'sʋ ɔ nyna i. 'De Sesi wlu, ɔ 'na : Ao ‑sɔ dɩfɔ kui, ‑wɛe ɔ 'je naa' 'bɛɛ‑ ! ");
INSERT INTO wob_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Suifʋ ‑tuu\" ‑jia' Madi ‑tɩ' ‑kwlɩ' i ‑tu\" 'a a, ʋʋa' jrʋ' 'jeea dɛ Sesi nʋa \"jriɛ‑ 'sʋ ʋʋ 'je ɔɔ' ‑tɩ' tɔ' 'ʋn 'ɛ. ");
INSERT INTO wob_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","'Kaa ʋʋa' jrʋ' mu' ‑wɛe ʋʋ po ɛɛ' \"kuan Fariseɛn‑wi\". ");
INSERT INTO wob_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","'Sʋ Fariseɛn‑wi\" ke 'sraa ‑saʋn 'a klae\" 'kɩɩɛn ‑gbajeʋn \"jrui ‑wɛe ʋʋ 'na : Dɛ ‑a ‑je nʋ 'ja a‑ ? \"Ju ‑nɔ, ɔɔ nʋɛ jrii' ‑tuu\"‑tuu. ");
INSERT INTO wob_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","‑Bo ‑a ‑tai\" ɔ \"i ‑wɛe ɔ 'jɩ nya kpa 'ja a, ‑mɛ nyʋ ‑wee' \"klein a muɛ ɔɔ' ‑tɩ' tɔ' 'ʋn 'jea', ‑mɛ Rɔmɛ‑wi\" ‑blea 'blʋa‑ ‑nɛ ʋʋa muɛ jia' ‑wɛe ʋʋ 'je ‑aa ‑kwlɔ mɔ o ‑aa 'blʋa‑ ma\" i ‑sa. ");
INSERT INTO wob_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","'Bomɔ ʋʋa' due' Kaifʋ, ‑ɔ ‑nɩa 'sraa ‑sai klaa\" 'de ɛɛ' ‑sʋn ‑tu 'di wluu‑, ɔ 'na : Aoa' 'wɔn dɛ jrɛ' 'mii 'de ɔɔ' ‑kɔ 'di. ");
INSERT INTO wob_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","‑Bo nyɔ due' koʋn ‑gbai 'mɛ 'bo nyʋ ‑tuu\" 'a ‑kɔi\" ɛ \"paa' 'de aoa' ‑tɩ' 'ʋn, ɛ je 'blʋa‑ ‑wee' 'a isɔan' ‑sii. Aoa' 'wɔn ‑mɛ 'mii ‑ta kee ? ");
INSERT INTO wob_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Dɛ ɔ 'tmʋa 'mʋa‑ ɛ se 'e ɔɔ' ‑cɛ\" 'kpa 'ʋn 'wlʋ. 'Kaa ɔ nɩa Kea 'a 'sraa ‑sai klaa\" 'de ɛɛ' ‑sʋn ‑tu 'di ɛ, ɛmɛ ‑tɩ ka Sesi 'jea 'mɛ 'de Suifʋ‑wi\" 'a ‑tɩ' 'ʋn ɛ, Kea jɔɔ ɛɛ' wlu tu 'kwa, ‑wɛe ɔɔ 'tmʋ ɛ. ");
INSERT INTO wob_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","'De ɛ se 'e Suifʋ‑wi\" 'a 'sʋ 'a ‑tɩ' 'ʋn nɩ‑, 'kaa ɔ 'je 'mɛ ‑o ‑wɛe ɔ 'je Kea 'a \"nynuu‑ ‑gbaa dɩ 'mii \"jrui 'kɩɛn‑, 'de ʋʋ 'je kooa due 'a ‑cɩɩ ma. ");
INSERT INTO wob_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Dɛ ‑tba' 'o ɛɛ' 'wɩ tu 'di ɛ, Suifʋ 'a klae\" 'bɛɛ‑ Sesi 'a 'mɛ ‑tɩ 'a wlu 'ʋn 'ɛ. ");
INSERT INTO wob_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Ɛmɛ ‑tɩ 'de ɛɛ' nɔ\" tu 'di ɛ, ka Sesi a nʋa ‑mu' ‑ji\" 'de Suifʋ‑wi\" \"klu 'de ɛ, ɔ 'bɔ ‑mɛ o 'kaa ɔ muɛ 'e 'blʋa‑ jrɛ' ‑ke ‑pɩɩɔn\" blʋa \"kʋan i 'di ‑wɛe ɔ ke ɔɔ' klai\" nynuu ‑te i 'bo ‑kwlɔ due' ‑ɛɛ 'nynɩ nɩa Eflaim 'di. ");
INSERT INTO wob_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","'Sʋ Suifʋ‑wi\" 'a kʋɔnkwla' 'wlʋ‑kɔ \"kʋʋan‑ i. 'De ɛɛ' ‑tɩ' 'ʋn ɛ, nyʋ ‑tuu\" a muɛ Selisalɛm ‑wɛe dɛ ʋʋa nʋa see 'de 'pepenɩ ‑tɩ 'ʋn ɛ, ʋʋ 'je ɛ nʋ. ");
INSERT INTO wob_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","'Sʋ ʋʋa ‑pɔn Sesi i 'de Kea ‑gbu klaa\" 'di, ‑wɛe ʋʋa ‑tee' ba i due 'due ʋʋ 'na : Ka aoa naa tɔ' i ɛ‑ ? Ɔ se ‑kɔ' ‑sɔn jii ‑ae ? ");
INSERT INTO wob_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","'Sraa ‑saʋn 'a klae\" ke Fariseɛn‑wi\" 'tmʋʋɛ nyʋ, ʋʋ 'na : ‑Ta ɔ nɩa nyɔ ‑ɔ ‑jea 'o ɛ, ‑mɛ ɔ ji ‑a 'tmʋʋ‑ ‑wɛe ‑a ‑je ɔ kpʋn. ");
INSERT INTO wob_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Kʋɔnkwla' 'wlʋ‑kɔ sia 'wɩ ‑mɛɛo\" 'sʋ, Sesi muɛ Betani 'bo Lasa ɔ ja 'kmʋ de o ‑kwlɔ. ");
INSERT INTO wob_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","'Bomɔ ʋʋ pii ɔ ‑pee, ‑wɛe Matɩ a ‑gble' diidɛ. Lasa nɩɛ 'e nyʋ ‑ʋʋ ‑ke Sesi a diia ‑tadue \"klu. ");
INSERT INTO wob_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","'Sʋ Madi \"duɛ ‑dai'klɔ ‑sooɛ nyʋ a 'daa 'naa ‑ɛɛ sɔɔn kma 'a 'ʋn ? Ɛ ke dɛ jrɛ' se o beeɛ‑. Ɛmɛ ʋ 'wla Sesi 'a bɩ \"jru 'de ʋ jaa ɩ ʋa' \"mɩɩ‑ kui. 'Sʋ -dai'klɔni 'a 'nʋ \"jiɛ ‑gbu\". ");
INSERT INTO wob_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","'Sʋ Sesi 'a klai\" ju due' Suida Isikario, Simɔ 'ɔ \"ju ‑ɔɔ mua Sesi 'e toa' ɔ wlu ka, ɔ 'na : ");
INSERT INTO wob_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","Dɛɛ ‑tɩ nyʋ se ‑dai'klɔni ‑nɛ ple ɛ se 'wɛi ‑tuu\" 'je 'de nyʋ se ɛ nɩɩa\" nyʋ \"nyɩ ɛ‑ ? ");
INSERT INTO wob_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Dɛ ɔɔ 'tmʋa 'mʋa‑, ɛ se nɩɩa\" nyʋ mʋ ‑ʋʋa ‑tɩ' \"si ɔ \"i nɩ‑, kaa ɔ nɩɛ \"jrii ‑o. ‑Ke ʋʋa' 'wɛi nɩa 'di ɛ, ɔmɔ ‑ɔɔ ‑teɛ' i 'kaa ɔɔ ‑sa 'e 'ɛ mɩ\"mɩ\". ");
INSERT INTO wob_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","'Bomɔ Sesi wluu‑ ɔ 'na : ‑Ɩn ‑wlʋ 'o \"junynɔkpao' ‑nʋ o 'tɩɩn, dɛ ʋ 'jea 'ma \"ku \"jrii nʋ 'de ɛ, ɛmɛ ʋa nʋa 'o ‑ta. ");
INSERT INTO wob_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Ao ke nɩɩa\" nyʋ a muɛ i ‑tea' jeejee, 'kaa 'mɔ ke ao se i ‑tei jeejee. ");
INSERT INTO wob_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Ka Sesi nɩa 'o Betani, Suifʋ‑wi\" 'wɔn ɛ 'sʋ, ʋʋa' ‑tuu\"‑tuu mu 'o 'ɛ. 'Kaa ɛ se Sesi 'a \"jriɛ‑ 'jee‑tɩ 'a 'sʋ mɛ ʋʋ mu nɩ‑, ʋʋ mu' ‑wɛe ʋʋ 'e Lasa ɔ ‑sa \"kunyɩɔ' 'je ‑ke. ");
INSERT INTO wob_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","'Sʋ 'sraa ‑saʋn klae\" ‑wi\" pooɛ ‑tɩ' ‑wɛe ʋʋ 'e Lasa 'dba ‑ke, ");
INSERT INTO wob_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","dɛ‑nʋɛ' 'de ɔɔ' ‑tɩ' 'ʋn ɛ, Suifʋ ‑tuu\"‑tuu ‑ʋʋa ‑wlʋ 'e ʋʋpʋ \"klu ‑wɛe ‑ʋʋa ‑je Sesi 'a ‑tɩ' tɔ' 'ʋn. ");
INSERT INTO wob_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","‑Sɔn' jrɛ' ‑sɩan' 'sʋ ɛ, nyʋ ‑tuu\"‑tuu ‑ʋʋ jia ‑kɔ' ‑sɔn 'wɔn Sesi 'a 'bo Selisalɛm ji ‑tɩ 'mɛ. ");
INSERT INTO wob_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","'Sʋ ʋʋ cɛn ‑gbɛn' ‑wɛe ʋʋ 'jɔɔ \"i 'de ʋʋa kpa wlu \"jɛi ʋʋa nʋ : ‑Kai\" 'matɛ oo ! \"Ju ‑ɔɔ jia 'de Tʋ\"bo 'a 'nynɩ 'ʋn ɛ, \"diwan kpʋn ɔ oo ! Kea po Israɛ‑kɔʋn 'a 'beɔ \"diwan oo ! ");
INSERT INTO wob_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Sesi 'jeɛ soofae' ju due' mɛ ɔ ‑te \"kpei, ka wlu ‑crɩɩa' 'de Kea 'a 'sbɛ 'di 'da. ");
INSERT INTO wob_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","Ɛ 'na : Selisalɛm‑kɔʋn, faʋn 'bo ao nʋɛ, ao ‑gbʋn 'nɔ, aoa' 'beɔ ɔ ji', ɔ ‑teɛ soofae' ju \"kpei. ");
INSERT INTO wob_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Dɩ ‑nɩa 'mʋa‑ ɔɔ' klai\" nynuu sɩ 'mii 'wɔn \"i‑saa' nɔ\". 'Kaa Sesi mu jaʋn 'di la kpɩɩn‑ ‑wɛe ka dɩ ‑crɩɩa' 'de ɔɔ' ‑tɩ' 'ʋn 'de‑ ɩ nynia 'o ɛ, 'de ʋʋ po ɩ ‑kwlʋ o. ");
INSERT INTO wob_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","‑Ta Sesi 'daa‑ Lasa ‑wɛe ɔ 'wlʋa 'e ‑gbaɩn' 'di 'de ɔ jia 'kmʋ de ɛ, nyʋ \"klein ‑jea ɛɛ' ‑ta a, ʋʋa 'tmʋ ɩ jeejee 'de nyʋ ‑pee. ");
INSERT INTO wob_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Ɛmɛ ‑tɩ nyʋ ‑tuu\"‑tuu mu ɔ \"i 'jaa', dɛ‑nʋɛ' jrii' ɔ nʋa 'mʋa‑ ɛmɛ ‑ɛɛ 'nynɩ ʋʋpʋ 'wɔn. ");
INSERT INTO wob_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","'Sʋ Fariseɛn‑wi\" a wlu' 'bo ʋʋa' 'sʋ 'nynɩ, ʋʋ 'na : Aoa 'jee, nyʋ ‑wee' \"klein bla 'o ɔ 'de ‑wɛ‑. Ao se ɛ 'bɛɛ‑ ao 'je dɛ jrɛ' nʋ 'bode. ");
INSERT INTO wob_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Nyʋ ‑ʋʋ ‑jia' ‑gbɛɛa' 'bo Selisalɛm ‑kɔ 'ɔ 'wɩ o ɛ, Klɛkɩ nyʋ jrʋ' ‑nɩ 'e ʋʋpʋ \"klu. ");
INSERT INTO wob_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Ʋʋ ‑kpa Filipʋ ‑wlʋa 'o Besaida 'de Galile ‑pʋn\", ʋʋ 'na : \"Bo, ‑aa ‑pɔn ‑a ‑ke Sesi 'e 'jee‑. ");
INSERT INTO wob_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Filipʋ mua 'sʋ ‑mɔ 'tmʋʋ ɛ Ancre, ‑wɛe ka ʋʋ nɩa 'sɔɔn ʋʋ muɛ Sesi ‑pee 'tmʋa'. ");
INSERT INTO wob_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","'Bomɔ Sesi \"duo‑ wlu 'ʋn ɔ 'na : Nɔ\" ‑ɛ 'di nyiɔ 'ɔ \"Ju 'jea 'nynɩ 'wlʋʋ ɛ, ɛ nyni' ‑wɛ‑ la. ");
INSERT INTO wob_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","'Ma 'tmʋʋɛ aopʋ tɔ' ‑tɩ, kojɔ nyʋ poa 'e ‑klu' ‑bo ɛ se 'mɛ 'ja a, ‑mɛ ɛɛ muɛ due' sia' mamaʋ 'sʋ, 'kaa ‑bo ɛ 'mɛ 'de 'blʋ 'ʋn ɛ, ɛɛ' kpau a muɛ 'jɔ ‑tuu\" croa'. ");
INSERT INTO wob_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Nyɔ ‑ɔɔ ‑tʋʋan' ɔɔ' ‑cɛ\" 'ɛ 'kmʋ \"kpei‑ ɛ, ɛɛ muɔ kwa \"maa', 'de nyɔ ‑bɔa ɔɔ' ‑cɛ\" 'ɛ 'kmʋ 'de 'blʋa‑ ‑nɛ \"kpei ɛ, ɔmɔ ɛɛ mu 'kwa sia', ‑wɛe ‑ɔ ‑je 'kmʋ ‑sea' \"ti ‑ta 'ble 'je. ");
INSERT INTO wob_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","‑Bo nyɔ ‑nɩɛi\" ɔ 'je 'ʋn \"juɔi nʋʋ ɛ, ‑mɛ ɔ bla 'bo 'ʋn 'de, ‑wɛe ‑ta 'ɩn nɩa, 'ma \"juɔinʋʋi 'je 'o nɩ ‑ke. Nyɔ ‑ɔɔ nʋʋa 'ʋn \"juɔi a muɛ dɛwɔn nɩa' 'de 'ɩn \"Bo \"jri 'de. ");
INSERT INTO wob_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","'Sʋ ɔ 'na : Kaan ka 'ma pɛe nyna soo. ‑Wɛe ka 'ɩn 'je 'da la ? 'ɩn nʋ 'ɩn \"Bo, ɛ seie 'ʋn 'de 'kle ‑nɛ 'kwaa ? Ɛ 'bo kan' nɩɛ, dɛ‑nʋɛ' 'ɩn ji' ‑wɛe 'ɩn 'je 'e 'kle 'je nɔ\" ‑nɛ 'ʋn cɛɛn‑. ");
INSERT INTO wob_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Ɛmɛ ‑tɩ 'ɩn 'na 'ɩn \"Bo, ɛ 'bɛɛ' ɛɛ' 'nynɩ \"i. 'Sʋ wlu jrɛ' ‑wlʋ 'e jaʋn 'di ‑ɛ ‑na : 'Ɩn 'bɛɛ‑ ɛ \"i 'mɛ sese, 'de 'ma muɛ ɩ \"i 'bɛɛ‑ ke'wlɛ. ");
INSERT INTO wob_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Nyʋ ‑nɩa 'o ‑wɛe ‑ʋʋ ‑wɔan wlu ‑nɛ, ʋʋ 'na : Ɛ ‑tɛn ‑plan\". Jrʋ' 'na : \"Ɩɩn‑, ɛ Kea 'a \"soai ‑wlu ɔ ‑pee. ");
INSERT INTO wob_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","'Bomɔ Sesi 'na : Ɛ se 'de 'ma ‑tɩ' 'ʋn mɔ wlu ‑nɛ wluu nɩ‑, 'kaa 'de aoa' ‑tɩ' 'ʋn ‑o. ");
INSERT INTO wob_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Kaan ka la 'kmʋ \"kpeinyʋ 'a 'pee 'jeeɛ' ‑wɛ‑. ‑Jɛ mɛ la ʋʋa' \"jru kpɔ' i ‑tei ‑siɔn' ɔ jiɛ \"kpae pooa'. ");
INSERT INTO wob_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","'De 'mɔ ɛ, ‑sɔntɩ nyʋ a mua 'ʋn tu ‑kwlɩ\" koa' ‑wɛe ʋʋ 'je ɛ \"jɛi kpa a, 'ma muɛ nyʋ ‑wee' \"klein 'a \"jua‑ 'de 'ʋn o \"biia'. ");
INSERT INTO wob_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","‑Bo ɔ 'tmʋ wlu ‑nɛ ɛ, ‑mɛ ka ɔɔ' 'mɛsʋn 'jea nɩ ɛ, ɛmɛ ɔɔ 'tmʋa 'o 'mʋa‑. ");
INSERT INTO wob_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","'Bomɔ nyʋ ‑kwea de wluu ka, ʋʋ 'na : Dɛ ‑a ‑jea 'de ‑aa kɛ'ɛ 'sbɛ 'di ɛ, ɛmɛ ‑nɩ Klisɩ a muɛ 'kmʋnɩa' jeejee. ‑Mɛ dɛɛ‑tɩ ‑ɩn ‑na, ʋʋa muɛ nyiɔ 'ɔ \"Ju tu ‑kwlɩ\" kɔa' ‑wɛe ʋʋ 'je ɛ \"jɛi kpa a‑ ? ‑Ta ‑mɔ 'ɔ nyiɔ 'ɔ \"ju tu nɩ 'ja a‑ ? ");
INSERT INTO wob_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","'Sʋ Sesi wlu' 'de ʋʋ ‑pee, ɔ 'na : 'kmʋ 'a ‑sɔn' nɩ 'de aopʋ \"klu 'mɛ ke 'de 'wɩ pla 'di. ‑Ta ‑sɔn' nɩɩa 'e ke ɛ ao na 'de ɛ 'ʋn ‑wɛe \"bɛɛ‑kwie je aopʋ \"jru ‑tiie'‑. Nyɔ ‑ɔɔ na 'de kwie 'di ɛ, ‑ta ɔɔ mua ɔ se 'o juo‑. ");
INSERT INTO wob_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","‑Ta ‑sɔn' nɩɩa 'de aopʋ \"klu ke ɛ, ao 'je ɛɛ' ‑tɩ' tɔ' 'ʋn, ‑wɛe ao 'je ‑sɔn'ɔ nyʋ 'kpa. Sesi ‑kɔa' wlu ‑nɩa 'mʋa‑ 'tmʋa' 'sʋ, ɔ 'wlʋ 'de ʋʋpʋ \"klu 'mɛ ‑wɛe ɔ \"maa ʋʋpʋ \"jrii. ");
INSERT INTO wob_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","'Kamɔ ɔ nʋ jrii' ‑tuu\"‑tuu ‑nɩ 'bo Suifʋ‑wi\" \"juɔi, 'kaa ʋʋ se ɔɔ' ‑tɩ' tɔ' 'ʋn 'je. ");
INSERT INTO wob_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","‑Wɛe dɛ Kea 'a wlu 'kwajaai Esai 'tmʋa tɛin\" 'de ɛ, ɛ 'je 'o nyni. Ɔ wlu' ka 'de‑, ɔ 'naa : Tʋ\"bo, ‑a ‑tmʋa ‑ma ‑tɩ' ‑tmʋ ‑tmʋ 'dee, ‑ɔ ‑je ‑aa wlu tɔ' 'ʋn ɛ‑ ? 'De nyɔ ‑je Tʋ\"bo 'a \"ikma sʋn i 'de ɛ 'di ɛ‑ ? ");
INSERT INTO wob_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Ʋʋ se ɛ tɔ' 'ʋn 'jea 'bɛɛ‑, ɛmɛ Esai 'jee nya i ‑wɛe ɔ wlu ka ke'wlɛ ɔ 'na : ");
INSERT INTO wob_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","Kea \"sun ʋʋpʋ 'a \"jri 'mɛ ‑bo ɛ nɩ kan' ‑wɛe ʋʋa' \"jri 'je i 'je ‑tɩ 'bɔ, ʋʋa' pɛe 'je i 'wɔn ‑tɩ 'bɔ 'de ʋʋ je 'nɔ 'ʋn o \"biie‑, 'de 'ɩn je ʋʋpʋ 'a 'wɛ‑ 'bɔɔ‑. ");
INSERT INTO wob_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Wlu ‑nɩa 'mʋa‑ a, Esai 'jeeɛ Sesi 'a 'nynɩ 'wlʋsʋn nya, ɛmɛ ‑tɩ ɔɔ 'tmʋ ɩ. ");
INSERT INTO wob_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","'De ‑mɛ 'kamɔ Suifʋ‑wi\" 'a klae\" jrʋ' 'je Sesi 'a ‑tɩ' tɔ' 'ʋn, 'kaa ʋʋ se \"inyɩɩa 'de Fariseɛn‑wi\" je ʋʋpʋ inʋ 'de ʋʋa' \"jrui 'kɩɩn‑gbu 'di. ");
INSERT INTO wob_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Ʋʋa' nyʋ tu ɛ, ʋʋ se Kea 'a nyʋ ‑tɩ' o poa' i‑pɔn, nyiɔ 'ɔ ‑nɛ nyʋ ‑tɩ' o poa' mɛ ʋʋa ‑pɔn ‑gbɛin'. ");
INSERT INTO wob_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","'Bomɔ Sesi kpaa wlu \"jɛi, ɔ 'na : Nyɔ ‑jea 'ma ‑tɩ' tɔ' 'ʋn ɛ, ‑mɛ ɛ se 'mɔ ‑ɔɔ ‑tɩ' ɔ 'je tɔ' 'ʋn nɩ‑, ‑mɛ \"ju ‑dboa' 'ʋn mɔ ‑ɔɔ ‑tɩ' ɔ 'je tɔ' 'ʋn. ");
INSERT INTO wob_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","'De nyɔ ‑jeea' 'ʋn \"jriɛ‑, ‑mɛ ɔ 'jee \"ju ‑ɔ dboa 'ʋn \"jriɛ‑ 'mɛ ‑ke. ");
INSERT INTO wob_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","'Mɔ jiɛ 'e 'blʋa‑ \"kpei ‑ta, ka ‑sɔn' nɩa, ‑wɛe nyɔ \"o nyɔ ‑jea 'ma ‑tɩ' tɔ' 'ʋn ɛ, ɔ 'bo 'e kwie 'di \"ti ɛ. ");
INSERT INTO wob_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","‑Bo nyɔ 'wɔn 'ma wlu ‑wɛe ɔ se ɛ wɔn 'je ɛ, ‑mɛ ɛ se 'mɔ ‑je ɔ 'pee kpʋʋn nɩ‑, dɛ‑nʋɛ' 'ɩn ji' ‑wɛe 'ɩn 'je nyʋ 'pʋʋ‑, 'ɩn se ji ‑wɛe 'ɩn 'je nyʋ 'pee kpʋʋn‑. ");
INSERT INTO wob_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Nyɔ ‑saa 'ma wlu sʋn ‑sɔn, ‑wɛe ‑ɔ ‑na ‑ɔ se ɛ wɔn 'jei ɛ, ‑mɛ dɛ ‑jea ɔ 'pee kpʋʋn, ɛ ‑nao, ‑mɛ wlu 'ɩn 'tmʋa ɩmɩ ‑ɩa mu ɔ 'pee kpʋʋn 'a de'bɔɔwɩ o. ");
INSERT INTO wob_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Dɛ‑nʋɛ' 'ɩn se 'o 'ma ‑cɛ\" ‑kwlɩ\" 'wlʋ ‑wɛe 'ɩn se wlu‑, 'kaa dɩ \"klein 'ɩn 'tmʋa 'ɩn 'Bo 'a ‑cɛ\" 'kpa ‑tuɩ\" 'ʋn wɔn ‑wɛe 'ma tɔɔ ɩ nyʋ. ");
INSERT INTO wob_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","'De 'ɩn 'je kan' 'mɛ, wlu ɛɛ ‑tua\" 'ʋn wɔn ɛ, ɩa poɛ 'kmʋ ‑sea' \"ti ‑ta 'ble \"jru \"kpei‑. Dɩ 'ma 'tmʋa 'ja a, 'ɩn \"Bo mɔ ‑da kan' ‑wɛe 'ma 'tmʋ ɩ. ");
INSERT INTO wob_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Kʋɔnkwla' 'wlʋ ‑kɔ ɔ \"kʋʋan i 'sʋ, ka Sesi 'a 'nɔ 'blʋa‑ \"kpei 'wlʋ nɔ\" nynia ‑wɛe ɔ 'jea 'de ɔ \"Bo o mu, ɔ 'je kan' 'mɛ. Nyʋ ‑nɩa ɔɔ' dbɛɛʋn 'nɔ 'blʋa‑ \"kpei, ɔ kma ʋʋpʋ 'a ‑tɩ' 'mɛ mamaʋ 'sʋ ɔ je mu ɔ je nyni. ");
INSERT INTO wob_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","‑Ta Sesi ke ɔɔ' klai\" nynuu nɩɩa ‑kwie\" dɛ dia' a, ‑mɛ ‑siɔn' po ɔɔ' ple tɔ' 'bo Simɔ 'ɔ \"ju Suida Isikario ‑kwlɩ\" ‑wɛ‑ sese. ");
INSERT INTO wob_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Ka Sesi 'wlʋa 'e Kea 'ʋn 'de ɔɔ mua 'e Kea o de ɛ, 'de ka ɔ \"Bo ‑te' ɔ dɩ ‑wee' \"klein kwa a, ɔ juɩ'. ");
INSERT INTO wob_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Ɔ sɔn 'ʋn 'ɛ 'sʋ ɔ ‑sa dɩ ɔ paa 'ʋn 'bo \"kpei kui 'de ɔ \"duo ‑pua\" 'ʋn ɔ cɛn ɛ ‑sewei'. ");
INSERT INTO wob_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","‑Wɛe ɔ po \"ni dɛ 'di, 'sʋ ɔ ‑teɛ ɔɔ' klai\" nynuu bɩ iwɔɔa' ‑pʋn\", 'de ɔɔ cri ɩ ‑puua\"‑ ɔ cɛan ‑sewei' kui. ");
INSERT INTO wob_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","'Kamɔ ɔ nʋ ‑wɛe ɔ jɛɛ Simɔ Piɛi, 'sʋ Piɛi 'na : \"Ɩɩn‑ 'de, Tʋ\"bo, ‑mɔ ‑mɔ' ‑je 'mɔ bɩ iwɔɔ‑ ? ");
INSERT INTO wob_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","'Sʋ Sesi wlu ɔ ‑pee ɔ 'na : Dɛ 'ma nʋa ‑ta ‑ɩn se ɛɛ' bʋ juoi kaan ke, 'kaa ‑ma muɛ 'dei i'wɔan' 'de nya. ");
INSERT INTO wob_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","'De Piɛi 'na : Ɛ se 'bɛɛ‑, Tʋ\"bo, ‑ɩn se 'ʋn bɩ iwɔɔi. 'De Sesi 'na : ‑Bo 'ɩn se ‑ʋn bɩ iwɔɔ 'ja a, ‑mɛ ‑ɩn se 'ʋn dɛ 'kwa 'jei. ");
INSERT INTO wob_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","'Sʋ Simɔ Piɛi 'na : \"Aa Tʋ\"bo, ‑bo ɛ nɩ kan' a, ‑mɛ ɛ 'bo 'ma bɩ 'a 'sʋ nɩɛ, 'kaa ‑ɩn ‑jre 'ʋn kwa ‑ɩn ‑wɔɔ 'ma \"jru 'ʋn ‑ke. ");
INSERT INTO wob_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","'De Sesi 'na : Nyɔ ‑jrea 'bode ɛ, ‑mɔ se ɛ 'bɛɛ‑ ɔ 'e jre ke'wlɛ ‑wɛe ɔ 'je 'pepe nɩ‑ ‑bo ɛ se ɔɔ' bɩ 'a 'sʋ iwɔɔa' nɩɛ. 'De ao nɩɛ 'pepe ‑mɔ, 'kaa ɛ se ao ‑wee' \"klein nɩ‑. ");
INSERT INTO wob_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Dɛɛ‑tɩ ɔ 'da kan' a, ɛmɛ ‑nɩ ɔ juo \"ju ‑ɔ ‑jea ɔ 'e to 'mɛ 'de ʋʋpʋ \"klu, ɛmɛ ‑tɩ ɔ 'na ao ‑wee' \"klein se 'pepe nɩ‑. ");
INSERT INTO wob_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Sesi ‑kɔa' ʋʋa' bɩ iwɔɔa' 'sʋ, ɔ paa ɔɔ' dɩ 'ʋn 'ɛ, ‑wɛe ɔ ‑te i 'de ɔ wlu ʋʋpʋ ‑pee ɔ 'na : Dɛ 'ɩn nʋa ‑ta ao 'wɔn 'e ɛ 'dei 'mɛɛ ? ");
INSERT INTO wob_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Aoa 'daa‑ 'ʋn Nyʋ dɛtɔɔi ke Tʋ\"bo ke, 'de ao ‑sa tɔ', dɛ‑nʋɛ' ɩmɩ 'ɩn nɩ ‑cɛɛn'‑. ");
INSERT INTO wob_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","'Mɔ ‑jɔ ‑nɩa Tʋ\"bo ‑wɛe ‑ɔ ‑nɩa Nyʋ dɛtɔɔi ɛ, ‑bo 'mɔ wɔɔ aopʋ bɩ i ɛ, ‑mɛ ao 'je ba bɩ iwɔɔ ‑o due 'due ‑ke. ");
INSERT INTO wob_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","‑Kɔ ao 'jea 'o 'de bla a, ɛmɛ 'ɩn tɔɔ aopʋ 'mʋa‑, ‑wɛe ka 'ɩn nʋa a, 'de ao 'je kan' nʋ 'e ba ‑pee. ");
INSERT INTO wob_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","tɔ' ‑tɩ 'a tɔ' ‑tɩ 'ma 'tmʋʋ‑ aopʋ, nyɔ ‑ɔɔ nʋʋa nyʋ \"juɔi ɛ, ɔ se \"i 'bɛ ɔ se ‑jɔ ɔɔ nʋʋa \"juɔi ‑sii, 'de nyɔ nyʋ dboa ɔ se \"i 'bɛ ɔ se ‑jɔ ‑dbo' ɔ ‑sii. ");
INSERT INTO wob_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Kaan ka la, dɩ ao 'jea nʋ ɛ, ao juɩ' ‑wɛ‑. ‑Bo ka ɩ \"sia 'nynɩ ao nʋ kan' a, ‑mɛ \"diwan a muɛ aopʋ kpʋan'. ");
INSERT INTO wob_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","Ɛ se 'de ao ‑wee' \"klein 'a ‑tɩ' 'ʋn mɔ 'ma 'tmʋʋ ɛɛ' wlu tu nɩ‑. Nyʋ 'ɩn ‑sa 'o ɛ, 'ɩn juo ʋʋpʋ 'mɛ, 'kaa wlu ‑crɩɩa' 'de Kea 'a 'sbɛ 'di ɛ, ɛ 'je 'o nyni ‑o. Ɛɛ' wlu tu 'naa : Tʋ ‑ke 'ma di, \"ju ‑ɔ ‑ke 'ma poa sʋn ‑ta ‑due ɛ, ɔmɔ ‑tba' 'ʋn bʋ ‑pʋn\". ");
INSERT INTO wob_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Ɛɛ' dɛ tu se 'o nyni 'sʋ 'ɩn je nɔ\" nya sie 'ɩn je ɛ 'tmʋ 'de ao ‑pee, ‑wɛe ‑bo ɛ nyni 'o ɛ, 'de \"ju 'ɩn \"sia 'nynɩ, ka ɛ nɩa 'ma ‑cɛ\" 'kpa a, 'de ao 'je ɛ tɔ' 'ʋn 'je. ");
INSERT INTO wob_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Tɔ' ‑tɩ 'a tɔ' ‑tɩ 'ma 'tmʋʋ aopʋ, nyɔ 'ɩn dboa nyɔ ‑kpʋʋan ɔ sɩn 'sɔɔn ɔ, ‑mɛ ka nyɔ ɔ kpʋʋan 'mɔ sɩn 'sɔɔn ɔ, 'kamɔ ɛ nɩ‑. 'De nyɔ ‑kpʋʋan 'ʋn sɩn 'sɔɔn ɔ, ‑mɛ ka nyɔ ɔ kpʋʋan \"ju ‑dboa' 'ʋn sɩn 'sɔɔn, 'kamɔ ɛ nɩ ‑ke. ");
INSERT INTO wob_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Sesi ‑kɔa' wlu ‑nɩ 'a 'tmʋa' 'sʋ, ɔ pɛe o \"kaeɛ \"jrii 'sʋ ɔ wa wɔn 'mii 'pepe ɔ 'na : Tɔ' ‑tɩ 'a tɔ' ‑tɩ 'ma 'tmʋʋ aopʋ, aoa' due' ‑a mu 'ʋn 'e toa'. ");
INSERT INTO wob_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","'Sʋ ɛ \"maa ɔɔ' klai\" nynuu tai', ʋʋa ‑gbʋɛn' ba ja due 'due, dɛ‑nʋɛ' nyɔ Sesi a 'da 'de ʋʋpʋ \"klu ʋʋ se ɔ juo‑. ");
INSERT INTO wob_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","'De klai\" ju due' ‑jɔ ‑nɩa Sesi 'a ‑tɩ' kmaklai\" ju ‑mɔ 'pɛɔn jai. ");
INSERT INTO wob_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","'Sʋ Simɔ Piɛi 'wlɔɔ \"jri ja ‑wɛe ɔ 'je Sesi i ‑tee' 'de nyɔ ɔɔ 'daa 'a ‑tɩ' 'ʋn. ");
INSERT INTO wob_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","‑Wɛe klai\" ju ‑tu 'pɛan Sesi jai ‑nɔ, ‑tee' ɔ i ɔ 'na : Tʋ\"bo, ɛ nyɔ ‑o ɛ‑ ? ");
INSERT INTO wob_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","'Sʋ Sesi 'na : Nyɔ 'ma mua ‑di'pɛn tie 'e 'sma o tbaa' ‑wɛe 'ɩn 'je ɛ \"nyɩ ɛ, ‑mɛ ɔmɔ ‑nao. Ɔ tbɛ 'de 'sma o 'sʋ ɔ \"nyɩ ɛ Simɔ 'ɔ \"ju Suida Isikario. ");
INSERT INTO wob_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Suida 'a ‑nɛɛ kpʋn ‑di'pɛn tie 'sʋ Satan pa 'e ɔ 'ʋn 'ɛ. 'Sʋ Sesi wlu ɔ ‑pee ɔ 'na : Dɛ ‑ɩn ‑nɩai\" ‑ɩn ‑jea nʋ ɛ, ‑ɩn nʋ ɛ ‑too\"‑. ");
INSERT INTO wob_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Wlu Sesi 'tmʋa 'mʋa‑, nyʋ \"klein ‑ke ɔ nɩa dɛ dia' se 'e ɛ 'dei 'wɔn. ");
INSERT INTO wob_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Dɛ Suida nɩa 'wɛi i ‑tei ɛ, ɛmɛ ʋʋa' jrʋ' a naa tɔ' i, ʋʋ 'na ‑mɛ Sesi a wlu ɔ ‑pee 'de ɔ 'je ‑kɔ' diidɛ ‑tɩan' mu. 'De ‑bo ʋʋmʋ a sea 'je ke'wlɛ ɛ, ʋʋ 'na : ‑Mɛ Sesi a 'tmʋʋ‑ Suida 'mɛ ‑wɛe ɔ 'je wɛenyʋ dɛ \"nyɩ. ");
INSERT INTO wob_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Suida ‑mɔ kpʋan ‑di'pɛn tie 'sʋ ɔ crɛɛ \"kpei‑, ɔ je \"kpae' \"si, ‑mɛ kwie kpʋn'. ");
INSERT INTO wob_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Suida \"sia \"kpae' 'sʋ Sesi 'na : Kaan ka la nyiɔ 'ɔ \"ju 'a 'nynɩ 'wlʋa' po \"jri \"kpae' ‑wɛ‑, ‑wɛe Kea 'a 'nynɩ 'wlʋa' 'je \"kpae' 'pɛɛn‑ 'de ɔ 'ʋn. ");
INSERT INTO wob_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","'De ‑bo Kea 'a 'nynɩ 'wlʋa' po \"jri \"kpae' 'de ɔ 'ʋn ɛ, Kea a mu ɔ kɛɛma' 'ʋn nʋa' 'de ɛɛ' ‑cɛ\" 'kpa 'ʋn. 'De ɛ ‑te ɛɛ' nʋ‑tɩ ‑wɛ. ");
INSERT INTO wob_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","'Ma \"nynuu‑, ao ke 'ma ‑a ‑teɛ i 'de nɔ\" dɛwɛ‑ 'di ke. Aoa muɛ 'mi i ‑pɔan' 'de dɛ 'ɩn 'tmʋa 'de Suifʋ‑wi\" ‑pee 'de ɛ, ɛmɛ 'ma 'tmʋ la 'de ao ‑pee ‑ke. 'Ɩn 'naa, ‑ta 'ma mua ao se 'o 'a mua' 'bɛɛ i. ");
INSERT INTO wob_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","'Ma \"nyɩ aopʋ kɛ' dee‑, ao kma ba 'a ‑tɩ' due 'due, ka 'ɩn kma aopʋ 'a ‑tɩ' ɛ, 'kamɔ ao 'je ba 'a ‑tɩ' kma due 'due ‑ke. ");
INSERT INTO wob_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","‑Bo aopʋ kma ba 'a ‑tɩ' due 'due ɛ, 'bomɔ ka ao nɩa 'ma klai\" nynuu ɛ, nyʋ ‑wee' \"klein 'je ɛ juo‑. ");
INSERT INTO wob_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","'Sʋ Simɔ Piɛi ‑tee' ɔ i ɔ 'na : Tʋ\"bo, ‑ta ‑ma mu ɛ‑ ? 'De Sesi 'na : ‑Ta 'ma mua a, ‑ɩn se 'o ‑mɔ 'ɔ jia' 'bɛɛ‑ kaan ka ke, 'kaa ‑ma muɛ 'bo 'ʋn 'de blaa' 'de nya. ");
INSERT INTO wob_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","'Sʋ Piɛi 'na : Tʋ\"bo, dɛɛ‑tɩ 'ɩn se ɛ 'bɛɛ‑ 'ɩn 'je ‑ʋn 'de bla kaan ka a‑ ? 'Ɩn ‑teɛ 'ma 'kmʋ 'e toa' 'a kein\"ke 'de ‑ma ‑tɩ' 'ʋn. ");
INSERT INTO wob_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","'Sʋ Sesi 'na : ‑ɩn ‑teɛ' ‑ma 'kmʋ 'e toa' 'a kein\"ke 'de 'ma ‑tɩ' 'ʋn ‑cɛɛn'‑ ? 'Kaa tɔ' ‑tɩ 'a tɔ' ‑tɩ 'ma 'tmʋ ‑ʋn, nɔ\" ‑tɩ sʋn\" 'jea ‑sro' ‑sɩan a, ‑ma muɛ wlua' kpɛ taan ‑ɩn ‑je nʋ, ‑ɩn se 'ʋn juo‑. ");
INSERT INTO wob_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Ao 'bo ‑sɔɔn ‑tu\" ɛ 'de ao pɛe o, ao ‑te Kea ‑kwlɩ\" 'de ao 'je 'mɔ ‑kwlɩ\" ‑te' ‑ke. ");
INSERT INTO wob_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","‑Teɩn ‑tuu\"‑tuu ‑nɩ 'e 'ɩn \"Bo o ‑gbu\" ‑sɔn. ‑Bo ɛ se kan' nɩ 'de ɛ, ‑mɛ 'ɩn 'tmʋ ‑wɛ‑ 'de ao ‑pee 'de, 'kaa 'ma muɛ aoa' ‑teɩn nmaea'. ");
INSERT INTO wob_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","'De ‑bo 'ɩn mu ‑wɛe 'ɩn ‑kɔ' aoa' ‑teɩn nmaea' a, ‑mɛ 'ma jiɛ de ‑wɛe 'ɩn 'je aopʋ 'ʋn \"duo‑ 'de ‑ta 'ɩn nɩa ‑wɛe ao 'je 'o nɩ ‑ke. ");
INSERT INTO wob_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","‑Ta 'ma mua ao juo 'o 'ɛ, ao juo 'bo 'a ‑je 'mɛ. ");
INSERT INTO wob_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","'Sʋ Toma 'na : Tʋ\"bo, ‑ta ‑ma mua ‑a sea 'o juo 'ee, ka ‑a ‑je 'o 'a ‑jeblʋ 'a juosʋn nʋ ɛ‑ ? ");
INSERT INTO wob_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","‑Wɛe Sesi wlu ɔ ‑pee ɔ 'na : 'Mɔ ‑nɩ ‑jeblʋ, 'mɔ ‑nɩ tɔ' ‑tɩ, 'mɔ ‑nɩ 'kmʋnɩa'. Nyɔ \"o nyɔ ‑jea 'de 'ɩn \"Bo o ji ‑wɛe ‑ɔ sea 'de 'ʋn o cɛɛn, ‑mɔ se nɩ‑. ");
INSERT INTO wob_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","‑Bo ao juuo 'ʋn 'de ɛ, ‑mɛ aoa muɛ 'ɩn \"Bo juua' ‑ke, 'kaa dɛ ‑tba' ‑ta ‑sɩan a, ao juuɔ', 'de ao 'jee ɔ \"jriɛ‑ ‑wɛ‑. ");
INSERT INTO wob_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","'Sʋ Filipʋ 'na : Tʋ\"bo, ‑ɩn ‑tɔɔ ‑aʋn ‑ɩn \"Bo ‑wɛe ‑aa pɛe 'je i ‑te. ");
INSERT INTO wob_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","'De Sesi 'na : Filipʋ, 'nɔ ao ke 'ma ‑a ‑sa naa' 'de tɛan kan' 'sʋ ɛɛ, ‑ɩn se 'ʋn juuo kee ? Nyɔ ‑jea 'ʋn, ‑mɛ ɔ 'je 'ɩn \"Bo 'mɛ, ‑mɛ dɛɛ‑tɩ ‑ɩn ‑na ‑ɩn ‑tɔɔ ‑aʋn ‑ɩn \"Bo ɛ‑ ? ");
INSERT INTO wob_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Ka 'ɩn nɩa 'de \"Bo 'ʋn ‑wɛe \"Bo nɩa 'de 'ʋn ɛ, ‑ɩn se ɛ tɔ' 'ʋn 'jee ? Wlu \"klein 'ma 'tmʋa ɩa' 'wlʋ 'o 'ma ‑cɛ\" 'kpa ‑kwlɩ\". 'Ɩn \"Bo ‑tia\" 'de 'ʋn ɛ, ɛmɛ ‑ɛɛ nʋ ɛɛ' ‑cɛ\" 'ɛ nʋʋdɩ. ");
INSERT INTO wob_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Ka 'ɩn nɩa 'de 'ɩn \"Bo 'ʋn ‑wɛe 'ɩn \"Bo nɩa 'de 'ʋn ɛ, ao 'je ɛ tɔ' 'ʋn 'de ‑bo ɛ se ‑mɛ nɩ ɛ ao 'je nʋʋ dɩ ‑nɩ ‑mɩ tɔ' 'ʋn dɛwɛ‑jɛ. ");
INSERT INTO wob_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Tɔ' ‑tɩ 'a tɔ' ‑tɩ 'ma 'tmʋ 'de ao ‑pee : Nyɔ ‑jea 'ma ‑tɩ' tɔ' 'ʋn ɛ, dɩ 'ma nʋa ɔɔ mu ɩ nʋa' ‑ke, ɔɔ muɛ ɩa' klae\" ‑nɩ mɩ nʋa', ɛ 'je ‑jɩ 'mɔ nʋa ‑sii, dɛ‑nʋɛ' 'ma muɛ 'e 'ɩn \"Bo ‑pʋn\". ");
INSERT INTO wob_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","'De dɛ \"klein aoa mua i ‑teea' 'de 'ma 'nynɩ 'ʋn ɛ, 'ma mu ɛ nʋa', ‑wɛe 'ɩn \"Bo 'a 'nynɩ 'je \"i 'bɛ 'de \"ju 'ʋn. ");
INSERT INTO wob_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","‑Bo ao ‑tee' dɛ \"o dɛ i 'de 'ma 'nynɩ 'ʋn ɛ, 'ma mu ɛ nʋa'. ");
INSERT INTO wob_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","‑Bo ao kma 'ma ‑tɩ', ‑mɛ ao ‑te' 'ma kɛ' i 'de aopʋ 'ʋn. ");
INSERT INTO wob_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","‑Wɛe 'mɔ 'je 'ɩn \"Bo ibae 'de ɛ 'je aopʋ ‑tɩ' ‑kwlɩ' i ‑tu\" i deejrɔ' ja ‑wɛe ‑mɔ ke aopʋ 'je i ‑te 'de 'wɩ ‑wee' 'di. ");
INSERT INTO wob_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Ɔmɔ ‑nɩ Kea 'a ‑Suu ‑ɛɛ ‑tmʋa tɔ' ‑tɩ ɛ. 'Blʋa 'di nyʋ ‑sea' Kea 'a ‑tɩ' tɔ' 'ʋn 'je ɛ, ʋʋ se ɛ 'bɛɛ‑ ʋʋ 'e ɛɛ' ‑Suu ‑tu 'je, dɛ‑nʋɛ' ʋʋa' juo ɛɛ' nʋʋdɩ \"i, ʋʋ se ɛ juuo‑. 'Kaa aopʋ mɔ ɛ, ao juuɛ', dɛ‑nʋɛ' ɛ ke aopʋ \"ti ‑wɛe ɛɛ mu 'de aopʋ 'ʋn nɩa'. ");
INSERT INTO wob_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","'Ɩn se aopʋ \"kwie sie, 'ma muɛ aopʋ o jia'. ");
INSERT INTO wob_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","'De nɔ\" pla 'di ɛ, 'blʋa 'di nyʋ se 'ʋn \"jriɛ‑ 'jeei 'bode. 'Kaa aopʋ mɔ ɛ, aoa muɛ 'ʋn \"jriɛ‑ 'jeea', dɛ‑nʋɛ' 'ɩn nɩɛ 'kmʋ, 'de aoa muɛ 'kmʋnɩa' ‑ke. ");
INSERT INTO wob_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","'De ɛɛ' 'wɩ tu 'di ɛ, ka 'ɩn nɩa 'e \"Bo 'ʋn ‑wɛe aomɔ nɩa 'de 'mɔ 'ʋn, 'de 'mɔ nɩa 'e aopʋ 'ʋn ɛ, aoa muɛ jua'. ");
INSERT INTO wob_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Nyɔ ‑ɔ kpʋn a 'ma kɛ' i ‑wɛe ‑ɔɔ ‑je ɛ wɔn ɛ, ‑mɛ ɔmɔ ‑kma 'ma ‑tɩ'. 'De nyɔ ‑kma 'ma ‑tɩ' ɛ, 'ɩn \"Bo a muɛ ɔɔ' ‑tɩ' kmaa', 'ma muɛ ɔɔ' ‑tɩ' kmaa' ‑wɛe 'ɩn 'je 'ma ‑cɛ\" 'kwla ‑sa 'de ɔ ‑pee. ");
INSERT INTO wob_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","'Sʋ Suidɩ wlu ɔ ‑pee, ɛ se Suida Isikario ‑mɔ nɩ‑, ɔ 'na : Tʋ\"bo, dɛɛ‑tɩ ‑ɩn ‑je ‑ma ‑cɛ\" 'kwla ‑sa 'de ‑amɔ ‑pee, ‑wɛe ‑ɩn se ‑ma ‑cɛ\" toi 'de 'blʋa 'dinyʋ ‑pee ɛ‑ ? ");
INSERT INTO wob_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","'Bomɔ Sesi wluu ɔ ‑pee ɔ 'na : ‑Bo nyɔ kma 'ma ‑tɩ' ɛ, ɔɔ muɛ 'ma wlu i ‑tea' 'de ɔ 'ʋn se ‑wɛe 'ɩn \"Bo 'je ɔɔ' ‑tɩ' kma‑, 'de 'ɩn ke 'ɩn \"Bo ke ‑a ‑je 'de ɔ 'ʋn ji 'de ‑a ke ɔ 'je i ‑te. ");
INSERT INTO wob_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Nyɔ ‑sea' 'ma ‑tɩ' kma ‑mɔ 'ɔ ‑te' 'ma wlu i 'de ɔ 'ʋn. 'De ‑mɛ 'kamɔ wlu aoa 'wɔan ‑ta, ɛ se 'e 'ma ‑cɛ\" 'ʋn 'wlʋ, ɛ 'wlʋɛ 'e 'ɩn \"Bo dboa 'ʋn 'ʋn. ");
INSERT INTO wob_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","‑Ta ao ke 'ma ‑a ‑teea i ke ɛ, 'bomɔ 'ma 'tmʋʋ‑ ɩa' dɩ tu 'de ao ‑pee. ");
INSERT INTO wob_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","'Kaa aoa' ‑tɩ' ‑kwlɩ' i ‑tu\" i ‑Suu ‑kwɛai 'ɩn \"Bo a mua jaa' 'de 'ma 'nynɩ 'ʋn ɛ, ɛmɛ ‑ɛɛ mu ao dɩ ‑wee' tɔɔa', ‑wɛe ɛ 'je ao dɩ \"klein 'ɩn 'tmʋa ‑kwlʋ o poo‑. ");
INSERT INTO wob_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","'Ɩn siɛ aopʋ 'de pɛe 'a blua' 'ʋn 'ɩn \"nyɩ aopʋ 'ma pɛe 'a blua'. Ka 'blʋa 'dinyʋ a \"nyɩa nyʋ dɛ ɛ, 'ɩn se ao pɛe 'a blua' \"nyɩ kan'. Ao 'bo ‑sɔɔn ‑tu\" ɛ, aoa' bo pɛe i pleeɛ. ");
INSERT INTO wob_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Dɛ 'ɩn 'tmʋa ao 'wɔn ɛ, 'ɩn 'na : 'Ma mu', 'kaa 'ma muɛ aopʋ o de jia'. ‑Bo ao kma 'ma ‑tɩ' 'de ɛ, ‑mɛ dɛ 'ma mua 'de 'ɩn \"Bo o ɛ, ɛɛ' muɛ aoa' 'mʋa 'blea 'de‑, dɛ‑nʋɛ' 'ɩn \"Bo 'bɛi\" flifli ɛ je 'ʋn ‑sii. ");
INSERT INTO wob_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","'De kaan ka la, 'ɩn siɛ nɔ\" nya 'ɩn je ao dɩ ‑nɩ 'tmʋʋ‑, ‑wɛe ‑sɔntɩ ɩa mua 'o nynia' 'de ao 'jɩ tɔ' 'ʋn 'je. ");
INSERT INTO wob_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","'Ɩn ke ao se dɛ ‑tuu\" 'tmʋi, dɛ‑nʋɛ' \"ju ‑nɩa 'e nyʋ ‑sea' Kea juo 'de ɛ, ɔɔ ji'. 'De ɔ ke 'ma‑ se dɛ i plaan‑, ");
INSERT INTO wob_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","'kaa ka 'ɩn kma 'ɩn \"Bo 'a ‑tɩ', ‑wɛe 'ma nʋa dɩ ‑wee' 'bo 'ɩn \"Bo 'a wlu \"i ɛ, 'blʋa 'dinyʋ 'jɩ juo ‑o. Ao sɔn 'ʋn, ‑a ‑wlʋ ‑ta. ");
INSERT INTO wob_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","'Mɔ ‑nɩ Fiinyɛ tu ‑cɛɛn'‑, 'ɩn \"Bo ‑nɩ ɛɛ' jei. ");
INSERT INTO wob_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","'Dao ‑tba' 'bo 'ʋn ‑pʋn\" ‑wɛe ‑ɛɛ' croa a, ‑mɛ tujei a 'kpaeɛ. 'De 'dao ‑jɛ ‑ɛɛ croa ɔ nmɔ ‑mɛ 'kwa ‑wɛe ɛɛ' croa' 'je \"kpei 'kpa. ");
INSERT INTO wob_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Wlu 'ɩn 'tmʋa ao ‑pee 'de ɛɛ' ‑tɩ' 'ʋn ɛ, ao nɩɛ 'pepe 'bode. ");
INSERT INTO wob_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Ao \"ti 'de 'ɩn 'ʋn ‑wɛe 'ɩn 'je 'de aopʋ 'ʋn \"ti. Ka ‑bo tudao se 'o ɛɛ' ‑gboo ‑pʋn\" \"si, ‑mɛ ɛ sea croa' 'bɛɛ‑, 'kamɔ ‑bo ao ke 'ma ‑a se \"i \"sii‑ ɛ, ‑mɛ ao se ɛ 'bɛɛ‑ ao 'je dɛ 'jrɛ nʋ. ");
INSERT INTO wob_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","'Mɔ ‑nɩ Fiinyɛ tu ‑wɛe aomɔ nɩ ɛɛ' 'dae‑. Nyɔ ‑tia\" 'de 'mɔ 'ʋn ‑wɛe ‑ɔ 'ʋn 'mɔ \"tia, ‑mɛ ɔɔ 'bleɛ 'jɔ ‑tuu\". 'De ‑bo 'mɔ se 'e aopʋ 'ʋn nɩ ɛ, ao se ɛ 'bɛɛ‑ ao 'je dɛ jrɛ' nʋ. ");
INSERT INTO wob_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","‑Bo nyɔ ‑ke 'ma ‑a se \"i \"sii‑ ɛ, ‑mɛ ka tudao ‑ɛɛ' croa 'jɔ nɩa, 'kamɔ ɔ nɩ‑. Ɛɛ' tudao tu ɛ, tujei a ‑sɛ' 'o ɛɛ' ‑gboo ‑pʋn\" 'mɛ ‑wɛe ɔɔ po ɛ i, ‑wɛe nyʋ a po tudae soɛ \"jri 'de ɩa wan. ");
INSERT INTO wob_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","‑Bo ao \"ti 'de 'ʋn ‑wɛe 'ma wlu 'je 'e aopʋ 'ʋn \"ti ɛ, ‑mɛ dɛ ao nɩai\" ao ‑tee' ɛ i, aoa mu ɛ 'jea' see. ");
INSERT INTO wob_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","‑Bo ao cro 'jɔ ‑tuu\" ɛ ɛmɛ ‑ɛɛ muɛ nʋa' ‑wɛe 'ɩn \"Bo 'a 'nynɩ 'je \"i 'bɛ ‑wɛe aopʋ 'je 'ma klai\" nynuu nɩ‑. ");
INSERT INTO wob_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Ka \"Bo kma 'ma ‑tɩ' ɛ, 'kamɔ 'ɩn kma aopʋ 'a ‑tɩ' ‑ke. Ao ‑te' 'e 'ma nyʋ 'a ‑tɩ' kmaa' 'di i. ");
INSERT INTO wob_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","‑Bo ao 'je 'ma wlu wɔn ɛ, ‑mɛ aoa muɛ 'e 'ma nyʋ 'a ‑tɩ' kmaa' 'ʋn \"tia, ka 'ɩn 'jea 'ɩn \"Bo 'a wlu wɔn ‑wɛe 'ɩn \"tia 'de ɔɔ' nyʋ 'a ‑tɩ' kmaa' 'ʋn ɛ. ");
INSERT INTO wob_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","'Ɩn 'tmʋ ɩa' dɩ tu 'mɛ 'de ao ‑pee ‑wɛe 'ma 'mʋa‑ 'je 'e aopʋ 'ʋn nɩ‑, 'de aoa' 'mʋa‑ 'je 'pepe nɩ‑. ");
INSERT INTO wob_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","'Ma kɛ' ka : Ao kma ba 'a ‑tɩ' due 'due ka 'ɩn kma aopʋ 'a ‑tɩ' ɛ. ");
INSERT INTO wob_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Nyʋ 'a ‑tɩ' kmaa' ‑jɛ ‑jea \"i 'bɛ ‑ɛ ‑jea ‑ɩn ‑to 'e ‑ma 'kmʋ 'de ‑ma \"dɛi‑wi\" 'a ‑tɩ' 'ʋn ‑sii, ‑mɛ se nɩ‑. ");
INSERT INTO wob_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Dɛ 'ɩn 'tmʋa 'de ao ‑pee ‑bo ao nʋ ɛ, ‑mɛ aopʋ nɩɛ 'ma \"dɛi‑wi\" ‑o. ");
INSERT INTO wob_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","'Ɩn se aopʋ \"juɔinʋʋn 'daa‑ 'bode, dɛ‑nʋɛ' nyɔ ‑nɩa nyʋ \"juɔinʋʋi ɛ, dɛ ɔɔ' 'blei a nʋa ɔ se ɛ juo‑, 'kaa 'ma 'daa‑ aopʋ \"dɛi‑wi\", dɛ‑nʋɛ' dɩ \"klein 'ɩn 'cɩan 'bo \"Bo ‑pʋn\" ɛ, 'ɩn ‑sɩ 'kwla 'de ao ‑pee. ");
INSERT INTO wob_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Ɛ se aopʋ ‑sa 'ʋn 'bomu nɩ‑, ɛ 'mɔ ‑kpa 'e nyʋ \"klu sʋn ‑ɔ ‑cra aopʋ i ‑wɛe ao 'je mu, ao 'je 'jɔ cro 'de aoa' 'jɔ 'je sie 'kpa nʋ ‑wɛe dɩ aoa mua \"Bo i ‑teea' 'de 'ma 'nynɩ 'ʋn ɛ, ɛ 'je ɩ aopʋ \"nyɩ. ");
INSERT INTO wob_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Dɛ ‑ɛɛ ‑cɩɛ 'ma cria 'de ao ‑pee ‑gblein', ɛmɛ ‑nɩ ao kma ba 'a ‑tɩ' due 'due. ");
INSERT INTO wob_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","Ao si ɛ ‑kwlʋ o ‑bo 'kmʋ \"kpei nyʋ 'nyɛ aopʋ 'ʋn ɛ, ‑mɛ 'mɔ mɔ ʋʋ 'nyɛ 'ʋn tɛin\". ");
INSERT INTO wob_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","‑Bo ao nɩ 'blʋa \"kpei nyʋ 'de ɛ, ‑mɛ 'kmʋ a muɛ aoa' ‑tɩ' kmaa' 'de‑, ka ɛɛ' ‑cɛ\" 'ɛ 'bleedɩ nɩa. 'Kaa dɛ ao sea ɛɛ' nyʋ nɩ‑, ‑wɛe 'mɔ ‑sa aopʋ 'e 'kmʋ \"kpei nyʋ \"klu ɛ, ɛmɛ ‑tɩ ʋʋ 'nyɛ aopʋ 'ʋn. ");
INSERT INTO wob_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Wlu 'ɩn 'tmʋʋa aopʋ ɛ, ao po ɛ ‑kwlʋ o, nyʋ \"juɔinʋʋi se \"i 'bɛ ɔ se ɔɔ' 'blei ‑sii. ‑Bo ʋʋ ‑tu\" 'ʋn 'kle ɛ, ʋʋa muɛ aopʋ 'kle ‑tu\" 'a ‑ke. ‑Bo ʋʋ ‑te' 'ma wlu i ɛ, ‑mɛ ʋʋa muɛ aoa' ‑nɛ wlu i ‑tea' ‑ke. ");
INSERT INTO wob_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","'Kaa ʋʋa muɛ aopʋ dɩ ‑nɩ ‑wee' \"klein \"jrii nʋa' 'de 'ma ‑tɩ' 'ʋn, dɛ‑nʋɛ' ʋʋ se \"ju ‑dboa' 'ʋn juo‑. ");
INSERT INTO wob_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","‑Bo 'ɩn se ji ‑wɛe 'ɩn se ʋʋ 'tmʋʋ 'de ɛ, ‑mɛ ʋʋ se dɛsaʋnʋʋn nɩi 'de‑, 'kaa kaan ka ʋʋ se ‑too' ‑ta 'ble 'de ʋʋa' dɩsaɩn 'a ‑tɩ' 'ʋn 'bode. ");
INSERT INTO wob_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Nyɔ ‑nyɛa 'mɔ 'ʋn ɛ, ‑mɛ ɔ 'nyɛ 'ɩn \"Bo 'ʋn 'ɛ ‑ke. ");
INSERT INTO wob_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Dɩ nyɔ jrɔ' sea nʋ due', ‑bo 'ɩn sɩ nʋ 'de ʋʋpʋ \"klu 'de ɛ, ‑mɛ ʋʋa' dɩsaɩn se ‑srooɛ ‑i 'bo ʋʋ \"jru 'de‑, 'kaa kaan ka ʋʋ 'jee‑ 'ma nʋʋdɩ \"jriɛ‑ 'mɛ 'pepe, ‑wɛe ʋʋ 'nyɛ 'mɔ ke 'ɩn \"Bo 'ʋn. ");
INSERT INTO wob_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","'Kaa ɛɛ' dɛ tu nʋʋɛ' ‑wɛe wlu ‑crɩɩa' 'de ʋʋa' kɛ' 'di nyni 'o. Ɛɛ' wlu tu 'naa : Ʋʋ 'nyɛ 'ʋn 'ɛ foo\" 'ʋn. ");
INSERT INTO wob_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","\"Ju ‑jea aopʋ ‑tɩ' ‑kwlɩ' i ‑tu\", ɔɔ muɛ jia', ɛmɛ ‑nɛ Kea 'a ‑Suu ‑ɛɛ ‑tmʋa tɔ' ‑tɩ, ‑ɛ ‑wlʋa 'de 'ɩn \"Bo o ɛ. 'Ma muɛ ɛ aopʋ‑ ‑jei\" pooa' 'de 'ɩn \"Bo 'a 'nynɩ 'ʋn, ‑wɛe ‑bo ɛ ji ɛ, 'de ɛ 'je 'ma ‑pʋn\" ‑tɩ 'tmʋ. ");
INSERT INTO wob_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","'De aopʋ mɔ ɛ, ao 'je 'ma ‑po' bla ‑o ‑ke, dɛ‑nʋɛ' 'nɔ ao ke 'ma ‑a ‑sa naa' 'bo tɛn'. ");
INSERT INTO wob_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","'Ɩn 'tmʋ ɩa' dɩ tu 'mɛ 'de ao ‑pee, ‑wɛe ao je 'ma ‑kwlɩ\" ‑tea' o 'bɔ. ");
INSERT INTO wob_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Ʋʋa' muɛ aopʋ i nʋa' 'de \"jrui 'kɩɩn‑gbi 'dii. Nɔ\" jrɛ' ‑ɛɛ mu 'o nynia' ‑mɔ ‑wɛe ‑bo ʋʋa sea aopʋ 'dba a, ʋʋ 'je ‑mɛ Kea 'a ‑kwlʋtɩ nʋa' 'daa‑. ");
INSERT INTO wob_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","'Kamɔ ʋʋa mu nʋa', dɛ‑nʋɛ' ʋʋ se 'ɩn ke 'ɩn \"Bo juo‑. ");
INSERT INTO wob_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","'Ɩn 'tmʋ ɩa' wlu tu 'mɛ 'de ao ‑pee ‑wɛe ‑bo ɩa' nɔ\" nyni ɛ, 'de ka 'ɩn sia nɔ\" nya ‑wɛe 'ɩn ‑saa aopʋ fɛn' ɛ, ao 'je ɛ ‑kwlʋ o po. 'Ɩn se \"i‑saa' 'ɩn sɩ 'tmʋ, dɛ‑nʋɛ' ɛmɛ ‑nɩ ao ke 'ma ‑a ‑teɛ i. ");
INSERT INTO wob_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","'Kaa kaan ka la 'ma muɛ 'o \"ju ‑dboa' 'ʋn ‑pʋn\", 'de aoa' due' koʋn ‑gbai' ka se 'mi i ‑tee' ɔ se 'na : ‑Ta ‑ma mu ɛ‑ ? ");
INSERT INTO wob_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","'Kaa dɛ 'ɩn 'tmʋa 'de ao ‑pee ɛ, ‑mɛ \"kaeɛ aoa' pɛe \"jrii. ");
INSERT INTO wob_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","'De ‑mɛ 'kamɔ dɛ 'ma 'tmʋa aopʋ nɩɛ tɔ' ‑tɩ, 'ma mua' \"paa' 'de aoa' ‑tɩ' 'ʋn, ɛ je 'ma i ‑tea' ‑sii, dɛ‑nʋɛ' ‑bo 'ɩn se mu 'ja a, ‑mɛ aoa' ‑tɩ' kwlɩ' i ‑tu\" i se jii. 'Kaa ‑bo 'ɩn mu ‑wɛe 'ɩn 'je ɔ ao ‑jei\" poo‑. ");
INSERT INTO wob_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","'De ‑bo ‑tɩ' kwlɩ' i ‑tu\" i ji ɛ, ɔɔ muɛ kmʋ ‑nɛ 'ɛ \"jri ‑gbaia' 'de dɛsaʋn o, ‑tɩ' \"i ‑klɛɛa' o, 'pee 'a ‑tɩ' 'ʋn. ");
INSERT INTO wob_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Ɔɔ muɛ 'kmʋ ‑nɛ 'ɛ \"jri ‑gbaia' 'de dɛsaʋn 'a ‑tɩ' 'ʋn ɛ, dɛ‑nʋɛ' 'kmʋ \"kpei nyʋ 'a 'je 'ma ‑tɩ' tɔ' 'ʋn. ");
INSERT INTO wob_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Ɔɔ muɛ 'kmʋ ‑nɛ 'ɛ \"jri ‑gbaia' 'de \"i ‑klɛɛ ‑tɩ' 'ʋn ɛ, dɛ‑nʋɛ' 'ma muɛ 'ɩn \"Bo o, 'de ao se 'ʋn \"jriɛ‑ 'jeei 'bode. ");
INSERT INTO wob_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Ɔɔ muɛ 'kmʋ ‑nɛ 'ɛ \"jri ‑gbaia' 'de 'pee 'a ‑tɩ' 'ʋn, dɛ‑nʋɛ' 'blʋa ‑nɛ 'ɛ kɛɛma' 'a 'pee 'jeeɛ ‑wɛ. ");
INSERT INTO wob_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","'Ɩn 'bleɛ dɩ ‑tuu\"‑tuu ke'wlɛ 'ɩn 'je ao 'tmʋʋ‑, 'kaa ao sɩ \"wɔin 'bɛɛi kaan ka ke. ");
INSERT INTO wob_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","‑Bo aoa' ‑tɩ' ‑kwlɩ' i ‑tu\" i ji ɛ, ‑wɛe ɛ 'je aopʋ tɔ' ‑tɩ ‑wee' tɔɔ‑, dɛ‑nʋɛ' ɔmɔ ‑nɩ tɔ' ‑Suu. Dɩ ɛ 'wɔan 'de \"Bo 'wɔn ɩmɩ ‑ɛɛ mu 'tmʋa', ɛ se ‑tɩ' 'bo ɛɛ' ‑cɛ\" ‑kwlɩ\" ‑sai 'sʋ ɛ sɩ 'tmʋi. ‑Wɛe dɩ ‑ɩa mua nʋʋa' 'de nya a, ɛ 'je ‑mɩ 'kwla ‑sa ‑ke 'de ao ‑pee. ");
INSERT INTO wob_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Ɛɛ muɛ 'ma 'nynɩ \"i 'bɛɛ‑, dɛ‑nʋɛ' dɩ ‑nɩa 'de 'ʋn ɛ, ɩmɩ ɛ 'je 'ʋn \"duo‑ ‑wɛe ɛ 'je wɔ ‑sa 'de ao ‑pee. ");
INSERT INTO wob_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Dɩ \"klein 'ɩn \"Bo 'blea ɩ nɩɛ 'ma dɛ ‑o ‑ke, ɛmɛ ‑tɩ 'ɩn 'na dɩ ‑nɩa 'de 'ʋn ɛ, ɩmɩ ɛ 'je 'ʋn \"duo‑ ‑wɛe ɛ 'je wɔ ‑sa 'de ao ‑pee, ");
INSERT INTO wob_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","'Sʋ Sesi 'na : Ao se 'ʋn \"jriɛ‑ \"kpei poi 'de 'wɩ pla 'di, ‑wɛe ‑bo nɔ\" jrɛ' ‑sii 'o 'de ao 'je 'ʋn \"jriɛ‑ 'jee‑ ke'wlɛ. ");
INSERT INTO wob_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","'Bo wlu ‑nɩa 'mʋa‑ \"kpei 'sʋ ɔɔ' klai\" nynuu jrʋ' ‑teɛ wlua' ‑pʋn\" 'bo ʋʋa' 'sʋ 'nynɩ, ʋʋ 'na : Dɛ ɔɔ 'tmʋa 'de ‑a ‑pee ‑ta 'ee, ‑mɛ 'de 'a 'nynɩ wɛ‑ ? ‑Jɛ ‑nɩ ao se 'ʋn \"jriɛ‑ \"kpei poi 'de 'wɩ pla 'di ‑wɛe ‑bo nɔ\" jrɛ' ‑sii 'o 'de ao 'je 'ʋn \"jriɛ‑ 'jee ɛ‑ ? 'De ‑jɛ ‑nɩ 'ma muɛ 'de 'ɩn \"Bo o ɛ‑ ? ");
INSERT INTO wob_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Nɔ\" ‑ɛɛ ‑tɩ' ɔɔ 'tmʋa 'mʋa‑ ‑mɛ 'de 'a 'nynɩ wɛ‑ ? Dɛ ɔ nɩai\" ɔ 'jea 'tmʋ, ‑a se ɛ juo‑. ");
INSERT INTO wob_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Ka ʋʋa ‑pɔan Sesi 'a i ‑tee' ‑kɔ i ɔ 'jea kan' 'sʋ, ɔ wlu 'de ʋʋ ‑pee ɔ 'na : Dɛ 'ɩn 'na ao se 'ʋn \"jriɛ‑ \"kpei poi 'de nɔ\" jrɛ' 'di, ‑wɛe ‑bo nɔ\" jrɛ' ‑si' 'de ao 'je 'ʋn \"jriɛ‑ 'jee ɛ, ɛmɛ ‑ɛɛ ba aoa ‑tee' ii ? ");
INSERT INTO wob_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Tɔ' ‑tɩ 'a tɔ' ‑tɩ 'ma 'tmʋʋ aopʋ, aoa muɛ ‑fɩn\" 'a, aoa muɛ kpleea', 'kaa 'blʋa 'dinyʋ a muɛ 'mʋa‑ nʋa'. Aoa muɛ \"jrii \"kaea', 'kaa aoa' \"jrii \"kaea' a muɛ 'mʋa‑ 'ʋn ‑snɛɛa'. ");
INSERT INTO wob_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","‑Bo 'nynɔkpao' a sea ‑gbaan ʋa \"kaeɛ \"jrii \"kɩkɩ, dɛ‑nʋɛ' ʋa' ‑nɛ 'kle 'je nɔ\" mɛ ‑nyni' 'o. 'Kaa ‑bo ʋa' \"ju 'wlʋ 'sʋ ʋ \"mae ʋa' 'kle o ‑wɛe ʋ nɩ 'e 'mʋa‑ 'ʋn 'de nyiɔju ‑jia' 'kmʋ 'a ‑tɩ' 'ʋn. ");
INSERT INTO wob_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Aomɔ ‑ke 'ja a, ao nɩɛ 'e \"jrii \"kaea' 'ʋn kaan, 'kaa ao ke 'ma muɛ 'jeea' ‑wɛe aoa' pɛe 'je 'e 'mʋa‑ 'ʋn nɩ‑ 'de nyɔ jrɔ' se ɛɛ' 'mʋa‑ tu 'de aopʋ 'ʋn ‑sai. ");
INSERT INTO wob_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","'De ɛɛ' nɔ\" tu 'di ɛ, ao se 'mi i ‑tee' i 'bode 'de dɛ jrɛ'ɛ ‑tɩ' 'ʋn. tɔ' ‑tɩ 'a tɔ' ‑tɩ 'ma 'tmʋʋ aopʋ, dɛ \"o dɛ aoa mua 'ɩn \"Bo i ‑teea' 'de 'ma 'nynɩ 'ʋn ɛ, ɛɛ mu ɛ aopʋ \"nyɩa'. ");
INSERT INTO wob_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Dɛ \"nana ‑nɩa 'de ɛ, ao se dɛ jrɛ' i ‑tee' ke 'de 'ma 'nynɩ 'ʋn. Ao ‑tee' dɛ i aoa mu ɛ 'jea', ‑wɛe aoa' 'mʋa‑ 'je 'pepe nɩ‑. ");
INSERT INTO wob_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","'Kaa nɔ\" jrɛ' ‑ɛɛ mu nynia' ‑wɛe 'ɩn se aopʋ ‑pee wlui 'de ‑tɩ' \"ipooa' 'ʋn, 'ma muɛ wɔn' iwaa' 'ɩn 'je 'ɩn \"Bo 'a ‑tɩ' 'tmʋ 'de ao ‑pee. ");
INSERT INTO wob_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","‑Bo ɛɛ' nɔ\" tu nyni 'o ɛ, aoa' ‑cɛ\" 'kpa a muɛ dɛ i ‑teea' 'de 'ma 'nynɩ 'ʋn. 'Ɩn se 'na 'ma muɛ 'ɩn \"Bo baea' 'de aoa' ‑tɩ' 'ʋn. ");
INSERT INTO wob_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","'ɩn \"Bo 'a ‑cɛ\" 'kpa ‑kma aoa' ‑tɩ', dɛ‑nʋɛ' ao kma 'ma ‑tɩ' ‑wɛe ka 'ɩn 'wlʋa 'e Kea 'ʋn ao 'je ɛ tɔ' 'ʋn. ");
INSERT INTO wob_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","'Ɩn 'wlʋɛ 'de \"Bo 'ʋn ‑wɛe 'ɩn ji 'nɔ 'kmʋ \"kpei. Kaan ka a, 'ma 'wlʋ 'nɔ 'kmʋ \"kpei 'mɛ la ‑wɛe 'ma mu 'o 'ɩn \"Bo ‑pʋn\" de. ");
INSERT INTO wob_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","'Sʋ ɔɔ' klai\" nynuu 'na : kaan ka ‑ma wa wɔn' i ‑ma jea ‑a ‑tmʋʋ', ɛ se 'e ‑tɩ' \"ipooa' 'ʋn nɩ‑. ");
INSERT INTO wob_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Ka ‑ɩn ‑jua dɩ ‑wee' \"klein ‑wɛe dɩ nyɔ 'jea ‑mi i ‑tee' ‑ɩn ‑jua ‑mɩ ‑ke ɛ, ‑a ‑je kan' ‑wɛ‑ la. Ɛmɛ ‑tɩ ka ‑ɩn ‑wlʋa 'e Kea 'ʋn ‑a ‑je ɛ tɔ' 'ʋn. ");
INSERT INTO wob_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","'Sʋ Sesi 'na : Aopʋ 'je ɛ tɔ' 'ʋn ‑wɛ‑ laa ? ");
INSERT INTO wob_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Ao ‑gbʋn 'nɔ, nɔ\" jrɛ' ‑ɛɛ mu nynia', 'de ɛ nyni 'o ‑wɛ‑ mɔ'ɔ ‑cɛ\", 'de ɛɛ' nɔ\" tu 'di ɛ, aoa muɛ ja ‑gbaa', jrɔ' 'je ɔɔ' ‑nɛ ka 'kpaa', jrɔ' 'je ɔɔ' ‑nɛ ka 'kpaa', ‑wɛe ao 'je 'ma 'sʋ sie‑, 'kaa 'ɩn se due' nɩ‑, 'ɩn \"Bo ke 'ma ‑a ‑na'. ");
INSERT INTO wob_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","'Ɩn 'tmʋ ɩa' dɩ tu 'mɛ 'de ao ‑pee ‑wɛe aoa' pɛe 'je blu 'de ao ke 'ma \"i \"siia 'ʋn. Aoa muɛ 'kle 'jea' 'de 'kmʋ \"kpei, 'kaa ao kuu dɩ i, 'ɩn du 'kmʋ 'a tʋ 'mɛ. ");
INSERT INTO wob_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Sesi ‑kɔa' wlua' kan' 'sʋ, ɔ kpa \"jri \"jɛi 'de ɔ ‑gbʋn 'e jaʋn‑kwlʋ, 'de ɔ 'na : 'Ɩn \"Bo, nɔ\" nyni' ‑wɛ‑, ɛ 'bɛɛ ɛɛ' \"ju \"i ‑wɛe ɛɛ' \"ju 'je ɛ \"i 'bɛɛ‑ ‑ke, ");
INSERT INTO wob_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","'De ɔ 'je nyʋ \"klein ɛ ‑tea' ɔ kwa 'kmʋnɩa' ‑sea' ‑kwɛ ‑ta 'ble \"nyɩ, dɛ‑nʋɛ' ɛ ‑nyɩ\" 'ʋn \"ikmaa' 'bo nyʋ ‑wee' \"jru kpɔ'. ");
INSERT INTO wob_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","'Kmʋnɩa' ‑sea' ‑kwɛ ‑ta ble ‑nɛ, ɛɛ' 'jea' mɛ ‑nɩ ɛmɛ Kea ‑cɛɛn'‑ ɛɛ' juua', ɛ ke Sesi Klisɩ ɛ dboa 'a juua' ke‑. ");
INSERT INTO wob_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","'Ɩn 'bɛɛ‑ ɛɛ' 'nynɩ \"i 'mɛ 'de 'blʋa‑ \"kpei, dbo ɛ ‑nyɩa\" 'ʋn 'ɩn ‑kɔ' ɛɛ' nʋa' ‑wɛ‑. ");
INSERT INTO wob_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Kaan la 'ja a, 'ɩn \"Bo, 'ma tʋ\"bodɛ 'ɩn nɩa 'ʋn 'bo ɛ ‑pʋn\" 'de ɛ, ‑mɛ 'kmʋ sea nʋʋɛ ke ɛ, ɛ ‑nyɩɛ\" 'ʋn. ");
INSERT INTO wob_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","Nyʋ ɛ ‑sa 'e 'blʋa 'dinyʋ \"klu ‑wɛe ɛ ‑nyɩa\" 'ʋn ɛ, 'ɩn tɔɔ ʋʋpʋ ɛɛ' 'nynɩ ‑wɛ‑, ʋʋ nɩɛ ɛɛ' nyʋ ‑o 'de‑, ‑wɛe ɛ ‑te' ʋʋpʋ 'ʋn kwa, 'de ʋʋ 'jeɛ ɛɛ' wlu wɔn. ");
INSERT INTO wob_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Ka dɩ \"klein ɛ ‑nyɩa\" 'ʋn ɩ 'wlʋa 'de ɛ 'ʋn ɛ, ʋʋ 'je kan' ‑wɛ‑ la, ");
INSERT INTO wob_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","dɛ‑nʋɛ' wlu ɛ ‑tua\" 'ʋn ɛ, ɩmɩ 'ɩn 'tmʋʋ ʋʋpʋ, ʋʋ kpʋn ɩ sɩn 'sɔɔn. Ka 'ɩn 'wlʋa 'de ɛ 'ʋn ɛ, ʋʋ 'je kan' 'mɛ ‑cɛɛn'‑, ‑wɛe ka ɛ ‑dboa' 'ʋn ʋʋ 'je ɛ tɔ' 'ʋn. ");
INSERT INTO wob_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","Ʋʋpʋ a baea' 'ma bae, 'ɩn se ɛ ‑bae 'de 'kmʋ \"kpei nyʋ 'a ‑tɩ' 'ʋn, 'kaa nyʋ ɛ ‑tea' 'ʋn kwa ʋʋpʋ a baea' 'ma bae, dɛ‑nʋɛ' ʋʋ nɩɛ ɛɛ' nyʋ ‑o. ");
INSERT INTO wob_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","'De dɛ \"klein 'ɩn 'blea ɛ nɩɛ ɛɛ' dɛ ‑o, 'de dɛ \"klein ɛ ‑blea ɛ nɩɛ 'ma dɛ ‑o ‑wɛe 'ma 'nynɩ 'bɛɛ \"i 'de ʋʋpʋ 'ʋn. ");
INSERT INTO wob_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","'Mɔ se 'e 'blʋa‑ \"kpei nɩ 'bode, 'kaa ʋʋmʋ siɛ 'nɔ 'blʋa‑ \"kpei, 'de 'ma jiɛ 'de ɛ o. 'Ɩn \"Bo ‑nɩa 'pepe nyʋ ɛ ‑nyɩa\" 'ʋn, ɛ ‑tu\" ʋa' ‑tɩ', ‑wɛe ʋʋ 'je due' nɩ ka ɛ ‑ke 'ma ‑a ‑nɩa 'due ɛ. ");
INSERT INTO wob_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","‑Ta ʋʋ ke 'ma ‑a ‑nɩɩa 'de 'blʋa‑ \"kpei 'de ɛ, 'ma ‑tuɛ\" ʋʋpʋ 'a ‑tɩ' 'de ɛɛ' 'nynɩ 'ʋn. Nyʋ ɛ ‑tea' 'ʋn kwa ʋʋa' due' koʋn ‑gbai' ka se \"ma, ‑bo ɛ se ‑jɔ ‑jea \"ma see nɩ ɛ, ‑mɛ 'ɛ dɛ tu nʋʋɛ' ‑wɛe wlu ‑crɩɩa' ɛ je 'o nyni. ");
INSERT INTO wob_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","'Kaa kaan ka la, 'ma jiɛ 'de ɛ o, ‑wɛe 'ma 'tmʋ wlu ‑nɩ 'nɔ 'blʋa‑ \"kpei 'de 'mʋa‑ ‑cɛɛn'‑ ‑nɩa 'de 'ɩn 'ʋn ɛ, ɛ 'je 'e ʋʋpʋ 'ʋn nɩ‑ ‑ke. ");
INSERT INTO wob_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","'Ɩn \"nyɩ ʋʋpʋ ɛɛ' wlu 'mɛ ‑wɛe 'blʋa dinyʋ 'nyɛ ʋʋpʋ 'ʋn, dɛ‑nʋɛ' ʋʋ se 'blʋa 'di nyʋ nɩ‑ ka 'mɔ sea 'blʋa 'dinyɔ nɩ ‑ke ɛ. ");
INSERT INTO wob_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","'Ɩn se ɛ ‑bae ‑wɛe ɛ ‑je ʋʋpʋ 'de 'blʋa‑ \"kpei ‑sa, 'kaa 'ma bae ɛ ‑wɛe ɛ 'je ʋʋpʋ 'a ‑tɩ' ‑tu\" 'de nyɔsaʋn 'a ‑tɩ' 'ʋn. ");
INSERT INTO wob_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Ʋʋ se 'blʋa 'dinyʋ nɩ‑, ka 'mɔ sea 'blʋa 'dinyɔ nɩ ‑ke ɛ. ");
INSERT INTO wob_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Ɛ nʋ ɛɛ' wlu ɛ 'je ʋʋpʋ kpɔi\" ‑tee, ɛɛ' wlu nɩɛ tɔ' ‑tɩ o. ");
INSERT INTO wob_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Ka ɛ dboa 'ʋn 'de 'kmʋ \"kpei ɛ, 'kamɔ 'ɩn dbo ʋʋpʋ 'de 'blʋa 'dinyʋ \"klu ‑ke. ");
INSERT INTO wob_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","'Ɩn \"nyɩ ɛ 'ma ‑cɛ\" 'mɛ 'de ʋʋpʋ 'a ‑tɩ' 'ʋn, ‑wɛe ʋʋmʋ ‑ke ɛ, ʋʋ 'je ɛɛ' ‑tea' ‑te ‑cɛɛn'‑ ‑cɛn ‑cɛɛn'‑. ");
INSERT INTO wob_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","'Ɩn se ɛ ‑bae 'de ʋʋpʋ 'a 'sʋ 'a ‑tɩ' 'ʋn, 'kaa nyʋ ‑ʋʋa mua 'ma ‑tɩ' tɔ' 'ʋn 'jea' 'de nya 'bo ʋʋa' wlu \"i ɛ, 'ma bae 'ɛ ‑ke 'de ‑wi\" ‑mʋ 'a ‑tɩ' 'ʋn, ");
INSERT INTO wob_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","‑wɛe ʋʋ 'je due' nɩ‑ ka ɛmɛ ‑nɩa 'ɩn \"Bo ɛ nɩa 'de 'mɔ 'ʋn 'de 'mɔ nɩa 'e ɛmɛ 'ʋn ɛ. 'De ʋʋmʋ 'je due' nɩ 'de ‑a 'ʋn, ‑wɛe ka ɛ dboa 'ʋn 'blʋa 'dinyʋ 'je ɛ tɔ' 'ʋn 'je. ");
INSERT INTO wob_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Tʋ\"bodɛ ɛ ‑nyɩa\" 'ʋn ɛ, 'ɩn \"nyɩ ɛ ʋʋpʋ 'mɛ, ‑wɛe ʋʋ 'je due' nɩ‑ ka ɛ ke 'ma ‑a ‑nɩa due' ɛ : ");
INSERT INTO wob_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","'Mɔ nɩ 'e ʋʋpʋ 'ʋn ‑wɛe ɛmɛ ‑nɩ 'e 'mɔ 'ʋn, 'de ʋʋpʋ 'je due' nɩ 'pepe, ‑wɛe 'blʋa 'dinyʋ 'je ɛ juo‑ ka ɛmɛ ‑dboa' 'ʋn ɛ, ɛ kma ʋʋa' ‑tɩ 'ka ɛ kma 'ma ‑tɩ' ɛ. ");
INSERT INTO wob_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","'Ɩn \"Bo, 'ma ‑pɔn ‑ta 'ɩn nɩa, nyʋ ɛ nyɩa\" 'ʋn 'je 'o nɩ ‑ke, ‑wɛe ʋʋ 'je 'ma tʋ\"bodɛ \"jriɛ‑ 'jee‑, tʋ\"bodɛ ɛ nyɩa\" 'ʋn 'de 'ma ‑tɩ' kmaa' 'ʋn ‑mɛ 'kmʋ sea nʋʋɛ ke ɛ. ");
INSERT INTO wob_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","'Ɩn \"Bo ɛ ‑srɛi\", 'blʋa 'dinyʋ se ɛ juo‑, 'kaa 'mɔ juo ɛ, 'de ka ɛ dboa 'ʋn ɛ, nyʋ ‑jʋ ‑nʋ ‑wi\" ‑mʋ juɩ'. ");
INSERT INTO wob_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","'Ɩn tɔɔ ʋʋpʋ ɛɛ' 'nynɩ 'mɛ, 'de 'ɩn 'je ɛɛ' 'nynɩ ʋʋpʋ tɔɔ ‑o ke'wlɛ, ‑wɛe 'ma ‑tɩ' kmaa' ‑ɛ ‑nɩa 'de ɛ 'ʋn ɛ, ɛ 'je 'e ʋʋpʋ 'ʋn nɩ‑, 'de 'mɔ 'je 'e ʋʋpʋ 'ʋn nɩ‑. ");
INSERT INTO wob_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Sesi ‑kɔa' wlua' kan' 'sʋ ɛ, ɔ ke ɔɔ' klai\" nynuu muɛ 'e \"niju ‑ɛɛ 'nynɩ nɩa Sedrɔn 'de. 'Bomɔ ‑kle' jrɛ' nɩ ‑wɛe ɔ ke ɔɔ' klai\" nynuu paa 'bo ɛ 'di. ");
INSERT INTO wob_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Suida ‑jɔɔ to ɔ 'e ɛ, ‑mɔ juo 'bo 'a ‑ta ‑tu 'mɛ see, dɛ‑nʋɛ' Sesi ke ɔɔ' klai\" nynuu ‑kwle \"jrui 'kɩɩan' 'mɛ 'bomu. ");
INSERT INTO wob_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Suida ‑nɔ kɔn 'e \"soa‑wi\" o, 'sraa ‑saʋn 'a klae\" ke Fariseɛn dboa 'mla ‑wɛe ʋʋ 'ble ‑tai ke ‑dam'ba ke poodɩ ke 'de ɔ ke ʋʋ mu 'o ‑kle' ‑nɛ 'di. ");
INSERT INTO wob_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Sesi jua dɩ ‑ɩa ji ɔ \"jrii nʋʋa' 'sʋ ɛ, ɔ 'jaa nyʋ ‑ʋʋa ji ɔ kpʋan' \"i, 'de ɔ 'na : Nyɔ aoa ‑pɔn i ɛ‑ ? ");
INSERT INTO wob_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Ʋʋ 'na : ‑Aa ‑pɔn Sesi ‑wlʋa Nasarɛtɩ i. 'Sʋ ɔ 'na : 'Ɩn ka. 'De Suida ‑ɔɔ to ɔ 'e ɛ, ‑mɔ ke ʋʋ ‑wee' nɩ 'mʋa‑ 'mɛ. ");
INSERT INTO wob_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","‑Ta Sesi wluua 'de ʋʋ ‑pee ‑wɛe ɔ 'na 'ɩn ka 'sʋ, ʋʋ ‑saa kɩn ‑wɛe ʋʋ ‑wee' 'wla 'blae 'bo 'blʋɔ. ");
INSERT INTO wob_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Sesi ‑teɛ' ʋʋpʋ i ke'wlɛ, ɔ 'na : Nyɔ aoa ‑pɔn' i ɛ‑ ? 'Sʋ ʋʋ 'na : Sesi ‑wlʋa Nasarɛtɩ ɛ, ɔmɔ ‑aa ‑pɔn i. ");
INSERT INTO wob_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","'De Sesi 'na : 'Ɩn wlu ao ‑pee 'mɛ 'teɔ sese 'ɩn 'naa : 'Ɩn ka. ‑Bo ɛ nɩ 'mɔ aoa ‑pɔn i ɛ, ‑mɛ ao \"tai‑ 'ma 'cɛ ‑jʋ ‑mʋ \"i, ʋʋ 'je mu. ");
INSERT INTO wob_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Ɔ 'da kan' 'mɛ ‑wɛe wlu ‑crɩɩa' 'je 'o nyni, ɛɛ' wlu tu 'naa : Nyʋ ɛ \"nyɩa 'ʋn 'ɩn se ʋʋa' due' \"maa. ");
INSERT INTO wob_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","'Sʋ Simɔ Piɛi ‑sa ‑cnɛ kpla' ɔ poɛ' 'sʋ ɔ cɛn 'o 'sraa ‑sai klaa\" 'a dbonʋi 'a dian o doun\" 'mɛ. Ɔɔ' dbonʋi tu 'a 'nynɩ ‑nɩ Malɩkisɩ. ");
INSERT INTO wob_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","'Sʋ Sesi wlu' 'de Piɛi ‑pee, ɔ 'na : ‑Ɩn ‑tu\" ‑ma ‑cnɛ 'e kpla 'di de. ‑Kaʋn\"‑ \"Bo tba 'ʋn wɔn 'ɩn seɛ 'na i 'dee‑ ? ");
INSERT INTO wob_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","'Sʋ \"soa‑wi\" ke ʋʋa' klaa\" ke nyʋ Suifʋ 'a klae\" dboa kpʋn Sesi 'mɛ ‑wɛe ʋʋ sɔn. ");
INSERT INTO wob_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","'De ʋʋ kpɔ 'e Anɩ \"juɔi ke tɛin\", Kaifʋ ‑nɩa 'sraa ‑sai klaa\" 'de ɛɛ' ‑sʋn ‑tu 'di, Anɩ nɩɛ ɔɔ' \"bia‑ ‑o. ");
INSERT INTO wob_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","'De Kaifʋ mɔ ‑tu\" Suifʋ‑wi\" 'a klae\" 'snɩ ka 'de‑, ‑ɔ ‑na : Ɛ \"paa' ‑wɛe nyɔ due' koʋn ‑gbai' 'je nyʋ ‑wee' 'a 'mɛa' 'mɛ. ");
INSERT INTO wob_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Simɔ Piɛi ke klai\" ju jrɔ' bla Sesi bʋ ‑kɔ o i. Ɔɔ' klai\" ju tu ɛ, 'sraa ‑sai klaa\" juuɔ' see, 'sʋ ɔ ke Sesi pa 'o 'sraa ‑sai klaa\" o ‑gbɛin\". ");
INSERT INTO wob_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","'Kaa Piɛi siɛ 'e \"kpae' 'bo ‑gbɛin\" ‑jei\". Klai\" ju ‑jɔ 'sraa ‑sai klaa\" juua ‑nɔ jiɛ de, 'de ɔ 'tmʋʋ 'nynɔkpao' ‑a fua ‑gbɛin\" ‑je i ɛ, ‑wɛe ɔ paa Piɛi 'bo ‑gbɛin\". ");
INSERT INTO wob_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","'Sʋ dbonʋnynɔkpao' ‑a fua ‑gbɛin\" ‑je i ‑teeɛ' Piɛi i, ʋ 'na : ‑Mɔ ‑nɔ, ‑ɩn ‑nɩɛ \"ju ‑nɔ 'ɔ klai\" ju due' ‑o ‑kee ? 'Sʋ ɔ 'na : \"Ɩɩn‑, 'ɩn se ɔɔ' klai\" ju nɩ‑ ! ");
INSERT INTO wob_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","‑Gbɛin\" ifuoʋn o, 'sraa ‑sai 'a dbonʋʋn ‑tba' nɛ ‑wɛe ʋʋa 'wooa, dɛ‑nʋɛ' dee' ‑a ji. 'Sʋ Piɛi jiiɛ 'bo ʋʋpʋ \"klu ‑wɛe ɔɔ 'wooa ‑ke. ");
INSERT INTO wob_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","'Sraa ‑sai klaa\" Anɩ ‑teeɛ' Sesi i 'de ɔɔ' klai\" nynuu ke ɔɔ' nyʋ dɛtɔɔsʋn 'a ‑tɩ' 'ʋn. ");
INSERT INTO wob_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","'Bomɔ Sesi wluu 'de ɔ ‑pee, ɔ 'na : Dɛ 'ɩn 'tmʋa, 'ɩn 'tmʋɛ 'bo nyʋ ‑kwea, 'ɩn tɔɔ nyʋ Kea 'a ‑tɩ' 'mɛ 'de \"jrui 'kɩɩn‑gbi ke Kea ‑gbu klaa\" 'di, ɩmɩ ‑nɩ Suifʋ‑wi\" 'a \"jrui 'kɩɩn‑ta, 'ɩn se dɛ jrɛ' 'kwla ‑tu\". ");
INSERT INTO wob_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Dɛɛ‑tɩ ‑ma ‑tee' 'mi i ɛ‑ ? Nyʋ ‑ʋʋ ‑wɔan 'ma wlu ɛ, ‑ɩn ‑tee' ʋʋpʋ i ka‑, dɩ 'ɩn 'tmʋa 'de ʋʋ ‑pee ɛ, ʋʋ juɩ' 'pepe. ");
INSERT INTO wob_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","'Bo ɛɛ' wlu tu \"kpei 'sʋ Kea ‑gbu ifuoi due' ‑nɩa 'o mu poɛ Sesi 'kpa doun\", 'de ɔ 'na : 'Kamɔ ‑ma wlu 'sraa ‑sai klaa\" ‑pee ? ");
INSERT INTO wob_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","'Sʋ Sesi wlu ɔ ‑pee, ɔ 'na : Dɛ 'ɩn 'tmʋa ‑ɛ ‑nyniia \"jrii ‑ɩn ‑si\" ɛɛ' 'nynɩ, 'de ‑bo dɛ 'ɩn 'tmʋa nmɔ \"jrii 'ee, ‑mɛ dɛ ‑ɛɛ blaa' ‑ma bla 'ʋn ɛ‑ ? ");
INSERT INTO wob_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Ɛ 'wlʋa 'o mu ɛ, 'kamɔ Sesi nɩ 'e \"dbi 'di 'sʋ Anɩ kpɔ 'e 'sraa ‑sai klaa\" Kaifʋ o. ");
INSERT INTO wob_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","'De nɔ\" ‑nɩa 'mʋa‑ 'di ‑mɛ Simɔ Piɛi nɩɛ nɛ 'wooa' ke, 'sʋ ʋʋ ‑tee' ɔ i, ʋʋ 'na : ‑Mɔ ‑nɔ, ‑ɩn se \"ju ‑nɔ 'ɔ klai\" nynuu 'a due' nɩ ‑taa ? 'Kaa Piɛi 'na : 'Ɩn se ɔɔ' klai\" ju 'a due' nɩ‑ 'de ! ");
INSERT INTO wob_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","'Sʋ 'sraa ‑sai klaa\" 'a dbonʋi due', ‑ɔ ‑nɩa \"ju Piɛi cɛan doun\" \"jru 'a de'di ɛ, ɔmɔ ‑wlu, ɔ ‑na : ‑Mɔ ‑nɔ, 'ɩn se ‑ʋn ‑ke ɔ 'je 'de ‑kle' 'di 'teɔɔ ? ");
INSERT INTO wob_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","'Kaa Piɛi ‑too' ɛ 'ʋn 'ɛ ke'wlɛ, ɔ 'na : 'Ɩn ko‑. 'Bomɔ ɛ \"si 'sʋ sʋn\" ‑sro'. ");
INSERT INTO wob_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","‑Wɛe ʋʋ ‑sa Sesi 'o Kaifʋ \"juɔi 'de ʋʋ kpɔ 'e Pilatɩ o ‑gbɛin\", ‑mɛ ‑sɔn' ‑sɩn', ʋʋa' ‑cɛ\" 'kpa 'na ʋʋ se 'o ‑gbɛin\" pai ʋʋ je mla' ‑pʋn\" nɩ‑ ‑wɛe Pakɩ 'a diidɛ di ‑tɩ je ʋʋpʋ kpʋn. ");
INSERT INTO wob_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Ɛmɛ ‑tɩ Pilatɩ \"si 'e \"kpae' 'de ʋʋpʋ o. 'De ɔ ‑tee' ʋʋpʋ i, ɔ 'na : ‑Aa 'wɔn 'e, dɛɛ‑tɩ ao ke \"ju ‑nɔ 'ble ɛ‑ ? ");
INSERT INTO wob_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","'Sʋ ʋʋ 'na : ‑Bo ɔ se dɛsaʋn nʋi nɩ 'de ɛ, ‑mɛ ‑a se ɔ 'bo ‑ʋn \"juɔi ja i. ");
INSERT INTO wob_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","'De Pilatɩ 'na : ‑Mɛ aoa' ‑cɛ\" 'kpa \"duɔ 'ʋn ‑wɛe ka aoa' kɛ' \"sia 'nynɩ ɛ, ao 'je ɔɔ' 'pee 'je kan' 'ja. 'Sʋ ʋʋa' klae\" 'na : ‑A ‑mɔ se ɛ 'bɛɛ‑ ‑a ‑je nyɔ 'dba. ");
INSERT INTO wob_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","'Kamɔ ɛ nɩ‑, ‑wɛe wlu Sesi 'tmʋa 'de ka ɔɔ' 'mɛsʋn 'jea nɩ 'a ‑tɩ' 'ʋn ɛ, ‑wɛe ɛ 'je 'o nyni. ");
INSERT INTO wob_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","'Sʋ Pilatɩ pa 'o ‑gbu\" de, ‑wɛe ɔ 'da Sesi 'de ɔ ‑tee' ɔ i ɔ 'na : ‑Ɩn ‑nɩɛ Suifʋ‑wi\" 'a 'beɔ ‑oo ? ");
INSERT INTO wob_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","'Sʋ Sesi 'na : Ɛ 'bo ‑ma ‑cɛ\" ‑kwlɩ\" mɔ wlu ‑jɛ ‑mɛ 'wlʋ ‑wɛe ‑ɩn ‑tmʋ ɛɛ, ‑aee' nyʋ jrʋ' ‑tmʋ ɛ 'de ‑ʋn ‑pee 'de 'ma ‑tɩ' 'ʋn ? ");
INSERT INTO wob_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","'De Pilatɩ 'na : 'Mɔ nɩɛ Suifʋi ‑oo ? ‑Ma 'cɛ‑wi\" ke ‑ma 'sraa ‑saʋn 'a klae\" ‑to 'e ‑ʋn 'de 'ʋn 'kwa. Ka ‑ɩn nʋ ‑gbo' ɛ‑ ? ");
INSERT INTO wob_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","'Sʋ Sesi 'na : 'Ma tʋ\"bodɛ se 'e 'blʋa‑ \"kpei nɩ ‑ta. ‑Bo 'ma tʋ\"bodɛ nɩ 'e 'blʋa‑ \"kpei 'de ɛ, ‑mɛ 'ma dbonʋʋn a muɛ 'ma tʋ ‑fɔan' 'de‑, ‑wɛe Suifʋ‑wi\" 'a klae\" se 'ʋn 'de toi, 'kaa 'ma tʋ\"bodɛ se 'e 'blʋa‑ \"kpei nɩ ‑ta. ");
INSERT INTO wob_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","'Bomɔ Pilatɩ wluu ɔ ‑pee, ɔ 'na : ‑Ɩn ‑nɩɛ 'beɔ ‑o 'jaa ? 'Sʋ Sesi 'na : ‑Ɩn ‑sa tɔ' ‑ɩn je kan' 'da, 'ɩn nɩɛ 'beɔ ‑o. 'Ɩn 'wlʋʋ ‑wɛe 'ɩn ji 'nɔ 'kmʋ \"kpei 'de 'ɩn 'je tɔ' ‑tɩ 'tmʋ ‑wɛe nyɔ \"o nyɔ ‑jea tɔ' ‑tɩ 'a \"dia a, dɛ 'ma 'tmʋa ɔ 'je ɛ doin\" o po. ");
INSERT INTO wob_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","'Sʋ Pilatɩ ‑tee' ɔ i, ɔ 'na : Dɛ ‑nɩ tɔ' ‑tɩ ɛ‑ ? Pilatɩ ‑kɔa' wlu ‑nɩ 'a 'tmʋa' 'sʋ ɛ, ɔ \"siɛ 'e Suifʋ o \"kpae' de, 'de ɔ 'na : ‑Ta 'ɩn 'jea tba ‑wɛe 'ɩn 'jea \"ju ‑nɔ 'pee kpʋʋn 'ɩn se 'o 'je. ");
INSERT INTO wob_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","'Kaa ka ɛɛ nʋʋa see 'de aopʋ \"klu, ‑wɛe ‑bo Pakɩ 'a ‑kɔ'ɔ 'wɩ o 'de 'ma \"sia ‑kaso 'dii due' i ɛ, ao ‑nɩɛi\" 'mɛɛ 'ɩn 'je Suifʋ‑wi\" 'a 'beɔ i \"sii‑ ? ");
INSERT INTO wob_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","'Sʋ ʋʋ ‑wee' ‑saa ‑cruɛn\", ʋʋ 'na : \"Ɩɩn‑, ɛ 'bo ɔmɔ nɩɛ, 'kaa Barabasɩ mɔ ‑ɩn ‑je i \"sii‑. 'De Barabasɩ nɩɛ \"ku 'dbai ‑o. ");
INSERT INTO wob_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","'Sʋ Pilatɩ 'tmʋʋɛ \"soa‑wi\" ‑wɛe ʋʋ kpa Sesi klae 'ʋn ‑kpa ‑kpa. ");
INSERT INTO wob_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","\"Soa‑wi\" dba \"wifan‑, 'de ʋʋ ‑tuɛ\" Sesi \"jru, ‑wɛe ʋʋ pɔɔ 'beɔ flae' ‑saan 'ʋn 'de ʋʋa wlɔɔ. ");
INSERT INTO wob_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","‑Wɛe ‑bo ʋʋ 'kɩɩn‑ 'bo ɔ ‑pʋn\", 'de ʋʋa ‑gblee' ɔ, ʋʋa nʋ : ‑A 'snɛ, Suifʋ 'a 'beɔ ! ‑Wɛe ʋʋa poɔ 'kpɩ doin\" i. ");
INSERT INTO wob_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","‑Wɛe Pilatɩ \"si \"kpae' 'de Suifʋ‑wi\" 'a klae\" o de ke'wlɛ, 'de ɔ 'na : Ao ‑gbʋn 'nɔ, 'ma ji ɔ 'nɔ aopʋ o \"kpae' jaa' ‑wɛe ao 'je ɛ juo ka 'ɩn sea dɛsaʋn jrɛ' 'je 'de ɔ 'ʋn ɛ. ");
INSERT INTO wob_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","'Sʋ \"wifan nɩɛ 'o Sesi \"jru, 'beɔ \"bai ‑saan nɩɛ 'de ɔ 'ʋn, 'sʋ ɔ je \"kpae' \"si, ‑wɛe Pilatɩ wlu 'de ʋʋ ‑pee, ɔ 'na : \"Ju aoa ‑pɔan, ɔ ka ! ");
INSERT INTO wob_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","‑Ta 'sraa ‑saʋn klae\" o, Kea ‑gbu 'dei ‑teʋn 'jeea Sesi \"jriɛ‑ 'sʋ, ʋʋ ‑saa ‑cruɛn\" ʋʋ 'na : ‑Ɩn koɔ 'bo tu ‑kwlɩ\", ‑ɩn koɔ 'bo tu ‑kwlɩ\" ! 'De Pilatɩ 'na : Aoa' ‑cɛ\" 'kpa \"duo ɔ 'ʋn ao 'jeɔ 'bo tu ‑kwlɩ\" kɔ, dɛ‑nʋɛ' 'mɔ se dɛsaʋn jrɛ' 'je 'de ɔ 'ʋn. ");
INSERT INTO wob_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","'Sʋ Suifʋ‑wi\" 'na : ‑A bleɛ kɛ', 'de ‑bo ɛ nɩ 'de ‑aa kɛ' 'di ɛ, ‑mɛ ɔ 'je 'mɛ ‑o, dɛ‑nʋɛ' ɔɔ nʋɛ ɔɔ' ‑cɛ\" Kea 'a \"ju 'ʋn. ");
INSERT INTO wob_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Pilatɩ 'wɔan wlu ‑nɛ 'sʋ ɔɔ' faʋn 'kpa \"kpei. ");
INSERT INTO wob_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","'Sʋ ɔ ke Sesi pa 'o ‑gbu\" 'di de, ‑wɛe ɔ ‑tee' ɔ i, ɔ 'na : ‑Ta ‑ɩn ‑wlʋ ɛ‑ ? 'Kaa Sesi se 'e wlu ‑sa. ");
INSERT INTO wob_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","'Sʋ Pilatɩ 'na : 'Mɔ ‑ɔɔ ‑tee' ‑mi i ‑wɛe ‑maa' wluu‑ ? ‑Ɩn se ɛ juo ka 'ɩn 'bɛɛa 'ɩn 'jea ‑mi i \"sii‑ 'de 'ɩn 'bɛɛa 'ɩn 'jea ‑ʋn kɔ 'bo tu ‑kwlɩ\" ɛ ? ");
INSERT INTO wob_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","'De Sesi 'na : ‑Ɩn se dɛ jrɛ' 'bɛɛ‑ 'bo 'mɔ \"kpei ‑bo ɛ se ‑jɛ Kea \"nyɩa ‑ʋn nɩ ɛ, ɛmɛ ‑tɩ \"ju ‑tua\" 'ʋn 'de ‑ʋn 'kwa a, ɔ nʋɛ dɛsaʋn klaa\", ɔ je ‑ʋn ‑sii. ");
INSERT INTO wob_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Ɛ 'wlʋa 'o mu ɛ, Pilatɩ a ‑pɔn Sesi 'a i \"sii‑ ‑kɔ i, 'kaa Suifʋ‑wi\" a \"wɔɔ‑, ʋʋ 'na : ‑Bo ‑ɩn ‑sii\" \"ju ‑nɔ i 'ja a, ‑mɛ ‑ɩn se Sesaa 'a dbɛɛ i nɩ‑, dɛ‑nʋɛ' nyɔ \"o nyɔ ‑ɔɔ nʋa ɔɔ' ‑cɛ\" 'beɔ 'ʋn ɛ, ‑mɛ ɔ nɩɛ Sesaa 'a tʋnyɔ ‑o. ");
INSERT INTO wob_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Pilatɩ 'wɔan wlu ‑nɩ 'sʋ ɔ poɛ Sesi \"kpae', ‑wɛe ɔ jii 'bo ɔɔ' nyʋ 'a 'pee 'je 'ɩn 'de ɔ ‑te i 'bo \"sou \"kpei, ʋʋa 'daa 'bo 'a ‑ta ‑tu Gabata 'de Eble wlu 'di. ");
INSERT INTO wob_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Ɛ nɩɛ kʋɔnkwla' 'wlʋ ‑kɔ'ɔ ‑kwie\" ‑o ‑mɛ 'jrʋ a \"kʋʋan‑ ‑gbao ‑tea' i. 'Sʋ Pilatɩ wlu' 'de Suifʋ‑wi\" ‑pee, ɔ 'na : 'Ɩn, aoa' 'beɔ ‑nao ! ");
INSERT INTO wob_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","'Kaa ʋʋ ‑teɛ \"wɔɔa' ‑pʋn\" ke'wlɛ, ʋʋ 'na : ‑Ɩn ‑dbɔ', ‑ɩn ‑dbɔ', ‑ɩn koɔ 'bo tu ‑kwlɩ\" ! 'De Pilatɩ 'na : Aoa' 'beɔ mɔ 'ɩn 'je kɔ 'bo tu ‑kwlɩɩ\" ? 'Sʋ 'sraa ‑saʋn 'a klae\" ‑wi\" 'na : ‑A se 'beɔ jrɔ' 'ble ‑bo ɛ se Sesaa nɩ ɛ. ");
INSERT INTO wob_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","'Sʋ Pilatɩ 'bɔɔ‑ Sesi ʋʋpʋ kwa, ‑wɛe ʋʋ 'je ɔ 'o tu ‑kwlɩ\" kɔ 'sʋ ʋʋ \"duɔ 'ʋn 'ɛ ‑wɛe ʋʋ kpɔ. ");
INSERT INTO wob_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","‑Ta Sesi a 'wlʋa 'o ‑kwlɔ ‑mɛ ɔɔ' ‑cɛ\" ‑ble ɔɔ' 'daɩntu, ‑wɛe ʋʋ kpɔ 'o ‑ta nyʋ a 'daa‑ \"jru \"kpa 'a ‑ta, ɛmɛ ‑nɩ Gogota 'de Eblewlu 'di. ");
INSERT INTO wob_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","'Bomɔ ʋʋ kɔɔ Sesi ke nyʋ 'sɔɔn jrʋ 'bo tu ‑kwlɩ\", jrɔ' nɩ 'nɔ, jrɔ' nɩ 'nɔ, ‑wɛe Sesi nɩ 'o ‑kwea'‑. ");
INSERT INTO wob_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Pilatɩ 'crɩɛ wlu jrɛ' ɛmɛ ɔ ‑tu\" 'o Sesi 'a 'daɩntu ‑kwlɩ\". Wlu ɔ 'crɩa, ɛ ka : Sesi Suifʋ 'a 'beɔ ‑wlʋa Nasarɛtɩ ɛ. ");
INSERT INTO wob_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Dɛ ‑crɩɩa' 'mʋa‑ Suifʋ ‑tuu\" a nʋ ɛ 'dii, dɛ‑nʋɛ' ‑ta ʋʋ kɔɔa Sesi ɛ, 'bo nɩɛ 'o ‑kwlɔ wɔin\", 'de dɛ ‑crɩɩa' ɛ 'crɩɩɛ 'de Eblewlu ke Latɛnwlu ke Klɛkɩwlu 'di. ");
INSERT INTO wob_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","'Sʋ Suifʋ 'a klae\" wluɛ Pilatɩ ‑pee, ʋʋ 'na : ‑Ɩn ‑bo Suifʋ‑wi\" 'a 'beɔ 'crɩɛ, 'kaa ‑ɩn ‑crɩ, \"ju ‑nɔ 'na ɔ nɩɛ Suifʋ‑wi\" 'a 'beɔ ‑o. ");
INSERT INTO wob_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","'De Pilatɩ 'na : Dɛ 'mɔ 'crɩa, 'ɩn 'crɩɛ' 'bode. ");
INSERT INTO wob_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","\"Soa‑wi\" ‑kɔa' Sesi 'a 'bo tu ‑kwlɩ\" kɔɔa' 'sʋ, ʋʋ ‑seea' ɔɔ' 'ʋnpaadɩ 'ʋn 'ɛ kpɛ ‑nyiiɛ', ‑wɛe \"soai due' 'ble ɔɔ' ‑nɛ, due' 'ble ɔɔ' ‑nɛ, 'de ʋʋ \"duo‑ ɔɔ' \"bai ‑tɔɔn ‑ɛ ‑wlʋa 'e \"jɛi ‑ɛ tba i ‑wɛe ‑ɛ sea \"pajri 'ble ‑nɛ 'ʋn, ");
INSERT INTO wob_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","'de ʋʋ 'na : ‑A ‑bo ɛ i'faeɛ, 'kaa ‑a ‑pooɛ soa' ‑wɛe nyɔ ‑je ɛ kpa 'de ‑a ‑je ɔ 'je. Ka ɛ nʋa ‑wɛe wlu ‑crɩɩa' see, ɛ jea 'o nyni, 'ka ‑nao. Ɛɛ' wlu tu 'naa : Ʋʋ ‑gble' 'ma 'ʋnpaadɩ 'ʋn 'ɛ, ‑wɛe ʋʋ poo 'ma \"bai ‑tɔɔn soa'. Dɛ \"soa‑wi\" nʋa ɛ ‑nao. ");
INSERT INTO wob_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","'Bo Sesi 'a 'daɩntu ‑pʋn\" ɛ, 'bomɔ ɔ de ke ʋa' de'dinynɔkpao' nɩ‑, 'bomɔ Klopa 'a 'nynɔ Madi nɩ‑, 'bomɔ Madi ‑wlʋa Madala nɩ ‑ke. ");
INSERT INTO wob_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Sesi 'jea ɔ de 'bo ɔɔ' ‑tɩ' ‑kma klai\" ju ‑pʋn\" 'sʋ ɛ, ɔ wlu ʋ ‑pee, ɔ 'na : \"ju 'nynɔ, aa' \"ju ‑nao. ");
INSERT INTO wob_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","'De ɔ wlu 'e klai\" ju ‑nɔ ‑pee, ɔ 'na : ‑Ɩn de ‑nao. Dɛ ‑tba' 'o ɛ, klai\" ju ‑nɔ \"duo Madi 'ʋn 'mɛ 'de ɔ wɔin\". ");
INSERT INTO wob_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","'Bo ‑mɛ 'de ɛ, ka dɩ ‑wee' \"klein ‑jea ɔ \"jrii nʋʋ ɩ nynia 'o la, Sesi 'je kan' 'mɛ 'sʋ ɔ 'na : \"Ni 'natʋn ‑a nʋ 'ʋn. Ɔ 'da kan' 'mɛ ‑wɛe dɩ ‑crɩɩa' 'je 'o nyni. ");
INSERT INTO wob_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","'De jae due' ‑nɩ 'o ‑ɛ ‑ji\" ‑koonmɔ, 'sʋ \"soa‑wi\" bla ɛ dɛ o i ‑wɛe ʋʋ crooɛ tu \"i 'de ʋʋ kpɛ 'o Sesi \"wɔin. ");
INSERT INTO wob_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Sesi ‑tɩɛn' wɔn, 'sʋ ɔ 'na : Dɩ ‑wee' kɔn \"jru ‑wɛ‑. Ɔ bla \"jru ‑kwlɩ\", 'sʋ ɔ 'mɛɛ. ");
INSERT INTO wob_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","'De 'wɩ ‑ɛ 'di Sesi 'mɛa ‑nɛ ɛ nɩɛ ‑kwlewɩ 'a ‑kwie\" ‑o. 'De Suifʋ‑wi\" se ɛ \"i nɩ \"ku 'je 'o tu ‑kwlɩ\" nɩ ‑kwlewɩ 'e nyni, dɛ‑nʋɛ' ‑kwlewɩ ‑nɛ kɔn ‑tɩ'. Ɛmɛ ‑tɩ ʋʋ mu 'e Pilatɩ o ‑wɛe ʋʋ 'tmʋ ɔ 'de \"soa‑wi\" 'je nyʋ ‑ʋʋ ‑kɔɔa 'bo tu ‑kwlɩ\" 'a bɩ i‑craa‑ 'a mu, ‑wɛe ʋʋ 'je ʋʋa' \"ku 'bo tu ‑kwlɩ\" ‑sa. ");
INSERT INTO wob_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","'Sʋ \"soa‑wi\" jia ʋʋ ‑craa' nyʋ ‑ʋʋ ‑ke Sesi kɔɔa 'o tu ‑kwlɩ\" 'a bɩ i. ");
INSERT INTO wob_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","‑Ta ʋʋa jeea Sesi ‑mɔ ɛ, ‑mɛ ɔ 'mɛɛ sese, ɛmɛ ‑tɩ ʋʋ se ɔɔ' bɩ i‑craa‑. ");
INSERT INTO wob_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","'Kaa \"soai due' nʋɛ \"di ‑wɛe ɔ \"fiie 'bo Sesi ‑gbɩn 'sʋ nymɔ ke \"ni mɩ ‑a jii 'bomu. ");
INSERT INTO wob_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","\"Ju ‑ɔ ‑jea dɩ ‑nɩ 'a ‑ta ɔmɔ ‑ɔɔ ‑tmʋ ɩ, dɩ ɔ 'tmʋa ɩ nɩɛ tɔ'. Ɔ 'je kan' 'mɛ dɩ ɔɔ 'tmʋa ɩ nɩɛ tɔ' ‑tɩ. ‑Wɛe ao 'jɩ tɔ' 'ʋn 'je ‑ke. ");
INSERT INTO wob_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Ɩa' dɩ tu nʋʋɛ' ‑wɛe wlu ‑crɩɩa' 'de Kea 'a 'sbɛ 'di see ɛ, 'de ɛ je 'o nyni. Ɛɛ' wlu tu 'naa : Ɔɔ' 'kpa due' koʋn ‑gbai' ka se ‑crai. ");
INSERT INTO wob_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","‑Wɛe ɛ 'crɩɩɛ ka 'de 'fɔ jrɛ' o 'wlɛ, ɛ 'naa : \"Ju ‑ɔ ‑gbɩn o ʋʋ \"fiia ʋʋa muɛ ɔ \"jriɛ‑ 'jeea'. ");
INSERT INTO wob_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","‑Mɛ 'wlʋa 'o ‑jei\" ɛ, Sosɛʋ ‑wlʋa 'o Arimate ‑teeɛ' Pilatɩ Sesi 'a \"ku i. Ɔɔ' Sosɛʋ ‑tu ɛ, ɔ nɩɛ Sesi 'a klai\" ju ‑o see, 'kaa ɔ se ɛ 'tmʋ due', dɛ‑nʋɛ' ɔɔ plee Suifʋ‑wi\" 'mɛ. 'Sʋ dɛ ɔ ‑teea' i Pilatɩ 'wɔɔn‑ 'ɛ, ‑wɛe ɔ mu 'de ɔ \"duo‑ Sesi 'a \"ku 'ʋn. ");
INSERT INTO wob_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Nikodɛmʋ ‑ɔ mua 'e Sesi o \"maʋ' 'de ɛ, ‑mɔ ji' ‑ke. Ɔ ja ‑dai'klɔni 'a kpɛ 'sɔɔn, mii‑ o, aloɛ o, ɩ 'beeɛ' ɩ 'je 'cilo 'a kwla taan nɩ‑. ");
INSERT INTO wob_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","‑Wɛe ka ʋʋ nɩa 'sɔɔn, ʋʋ \"duo‑ Sesi 'a \"ku 'ʋn 'de ʋʋ po ɔ ‑dai'klɔni kui. ‑Bo Suifʋ‑wi\" 'je nyɔ i ‑te' ɛ, 'kamɔ ʋʋa nʋ see. Ʋʋ ‑piian' ɔ tae' plu i. ");
INSERT INTO wob_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","‑Ta ʋʋ kɔɔa Sesi 'bo tu ‑kwlɩ\" ɛ, ‑kle' jrɛ' ‑nɩ 'o ɛ ‑pʋn\". 'Bo ‑kle' ‑nɛ 'di ‑gbaɩn' dee due' ‑nɩ 'o ‑ɛ 'di nyɔ jrɔ' se i ‑teeɛ due'. ");
INSERT INTO wob_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","'Bomɔ ʋʋ ‑te' Sesi 'a \"ku i, dɛ‑nʋɛ' ‑gbaɩn' ‑nɛ ‑kʋʋan\"‑ i, 'de ‑kwlewɩ 'a ‑kwie\" ‑nɩ. ");
INSERT INTO wob_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","'Dɔɔ \"i‑saawɩ 'a ‑klae\" pɛɛn 'sʋ Madi ‑wlʋa Madala ‑cruuɛn 'de ‑gbaɩn' \"kpei, ‑mɛ ‑sɔn' kwie nɩɛ 'blʋɔi ke. ‑Ta ʋa mua, ‑mɛ \"soukpo ‑nɩa 'o ‑gbaɩn' \"wɔin 'wlʋ 'o 'ɛ. ");
INSERT INTO wob_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","'Sʋ ʋ kpa plea' 'de Simɔ Piɛi ke klai\" ju jrɔ' ‑ɔɔ ‑tɩ' Sesi kma o, ‑wɛe ʋ 'tmʋ ʋʋpʋ, ʋ 'na : Ʋʋ ‑sa Tʋ\"bo 'a \"ku 'de ‑gbaɩn' 'di 'mɛ, ‑ta ʋʋ ‑tu\" ɔ ‑a se 'o juo‑. ");
INSERT INTO wob_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Piɛi ke klai\" ju jrɔ' ‑nɔ \"siɛ \"kpae' ‑wɛe ʋʋ mu 'e ‑gbaɩn' \"kpei. ");
INSERT INTO wob_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Ka ʋʋ nɩa 'sɔɔn ʋʋ ‑wee' a ple' ‑tadue. 'Kaa klai\" ju ‑nɔ ‑mɔ ple' ɔ siɛ Piɛi bɩ' i, ‑wɛe ɔ nyni 'e ‑gbaɩn' \"wɔin tɛin\". ");
INSERT INTO wob_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Ɔ bla \"jri 'de ɔ ‑gbʋɛn 'di, ‑wɛe ɔ 'jee tae' fɔ plu ‑pɛan 'blʋɔi 'a 'sʋ \"jriɛ‑, 'kaa ɔ se 'e ɛ 'di pa. ");
INSERT INTO wob_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Simɔ Piɛi ‑kɔan 'bo ɔ 'de ɛ, ɔmɔ ‑ji' ‑wɛe ‑ɔ pa 'e ‑gbaɩn' 'di. Ɔ 'jeeɛ tae' fɔ plu ‑pɛan 'blʋɔi \"jriɛ‑. ");
INSERT INTO wob_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","Tae' fɔ ‑piian' Sesi 'a \"jrui ke tae' ‑nɩa ɔ kui se ‑tadue nɩ‑, ɛ pooɛ ʋn ‑wɛe ‑ɛ ‑nɩ ‑ta ‑jrɔ. ");
INSERT INTO wob_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","'Sʋ klai\" ju ‑jɔ ‑saa \"i ‑ɔ nynia 'e ‑gbaɩn' \"kpei tɛin\" ɛ, ‑mɔ pa 'e ‑gbaɩn' 'di ‑ke, ‑wɛe ɔ 'jee dɩ ‑nɩa 'mʋa‑ \"jriɛ‑ 'sʋ ka Sesi sɔan \"kunyɩɔ' ɔ 'je ɛ tɔ' 'ʋn 'ɛ. ");
INSERT INTO wob_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Dɛ‑nʋɛ' ‑mɛ wlu ‑crɩɩa' ‑wɛe ‑ɛ ‑tmʋa Sesi 'a \"kunyɩɔ' sɔn‑tɩ ɛ, ɔɔ' klai\" nynuu se 'e ɛ 'dei 'wɔn ke 'de‑. ");
INSERT INTO wob_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Sesi 'a klai\" nynuu muɛ ‑ta ʋʋ 'wlʋa de. ");
INSERT INTO wob_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","'Kaa Madi ‑mʋ siɛ 'o ‑gbaɩn' ‑pʋn\" 'nɔ \"kpae' ‑wɛe ʋa ‑fɩn\". ‑Ta ʋ nɩɩa ‑fɩn\" 'a 'sʋ ʋ jiɛ ja ‑wɛe ʋ ‑soo' \"jru 'de ‑gbaɩn' 'di. ");
INSERT INTO wob_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","'Sʋ ʋ 'jeeɛ Kea 'a \"sʋɩ 'sɔɔn \"jriɛ‑ ‑ʋʋ ‑paa dɩplu 'ʋn ‑ʋʋ ‑te i, ‑ta Sesi 'a \"ku 'pɛan i 'de ɛ, due' nɩ 'e ɔɔ' \"jru o, due' nɩ 'e ɔɔ' bɩ o. ");
INSERT INTO wob_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","'Sʋ ʋʋ 'na : 'Nynɔkpao', dɛɛ‑tɩ aa ‑fɩn\" ɛ‑ ? 'Sʋ ʋ 'na : Ʋʋ \"duo‑ 'ma Tʋ\"bo 'ʋn 'ɛ, ‑ta ʋʋ po ɔ 'ɩn se 'o 'je. ");
INSERT INTO wob_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","‑Ta ʋ nɩɩa wlu ‑nɛ 'ɛ 'tmʋa' a, ʋ \"biia i 'sʋ ʋ 'je Sesi 'mɛ, ɔ nyna i, 'kaa ka ɛ nɩa Sesi la ʋ seɛ juo‑. ");
INSERT INTO wob_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","'Sʋ Sesi ‑teeɛ' ʋ i, ɔ 'na : 'Nynɔkpao', dɛɛ‑tɩ aa ‑fɩn\" ɛ‑ ? 'De nyɔ aa ‑pɔn i ɛ‑ ? ‑Bo ʋmʋ a sea 'je 'de ɛ, ʋmʋ 'na ‑mɛ ‑kle' ‑nɛ 'ɛ ifuoi ‑o 'de‑, 'sʋ ʋ 'na : 'Ma ‑fɛin', ‑bo ɛ nɩ ‑mɔ ‑duo\" ɔɔ' \"ku 'ʋn ɛ, ‑mɛ ‑ta ‑ɩn po ɔ ‑ɩn ‑tɔɔ 'ʋn 'bomu ‑wɛe 'ɩn 'je ɔ 'ʋn \"duo‑. ");
INSERT INTO wob_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","'Sʋ Sesi 'na : Madi ! Ʋ \"biia i 'sʋ ʋ wlu ɔ ‑pee 'de Eblewlu 'di, ʋ 'na : ‑Wee' ! Rabuni ! (Ɛ 'de mɛ ‑nɩ 'ma dɛtɔɔi). ");
INSERT INTO wob_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","'De Sesi 'na : A 'bo 'mi \"iblaa ke, dɛ‑nʋɛ' 'ɩn se 'de 'ʋn \"Bo o de mu ke. 'Kaa a mu a 'je 'ma de'di ‑wi\" 'tmʋʋ‑, ka 'ɩn \"Bo ‑ɔ ‑nɩa aoa' \"Bo ‑ke ɛ, 'de ɔ o 'demɔ 'ma mu de, 'ma Kea ‑ɛ ‑nɩa aoa' Kea ‑ke ɛ, 'de ɛ o 'bo 'ma mu de. ");
INSERT INTO wob_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","'Sʋ Madi ‑wlʋa Madala mu' ‑wɛe ʋ 'tmʋʋ‑ klai\" nynuu, ʋ 'na : 'Ɩn 'jee Tʋ\"bo \"jriɛ 'mɛ ! ‑Wɛe dɩ \"klein ɔ 'tmʋa 'de ʋ ‑pee ɛ, ʋ po ɩa' \"kuan. ");
INSERT INTO wob_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","'De 'dɔɔ \"i‑saawɩ ‑nɩa 'mʋa 'a ‑kwie\" ka a, klai\" nynuu nɩɛ 'e ‑gbu\" due' 'di ‑wɛe ʋʋ kan 'o ‑gbɛin\", dɛ‑nʋɛ' ʋʋa pleeɛ Suifʋ‑wi\" 'a klae\". 'Sʋ Sesi ‑taan' 'bo ʋʋpʋ 'a ‑kwea'‑, 'de ɔ wlu ʋʋ ‑pee ɔ 'na : Ao 'je pɛe 'a blua' ! ");
INSERT INTO wob_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","'Sʋ ɔ toɛ ʋʋpʋ ɔɔ' kwa 'sɔɔn \"i ɛ ke 'bo ɔ ‑gbɩn ke‑. 'Sʋ dɛ klai\" nynuu 'jeea Tʋ\"bo \"jriɛ‑ ɛɛ' 'mʋa‑ nʋ ʋʋpʋ 'mɛ. ");
INSERT INTO wob_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","‑Wɛe Sesi wlu ʋʋ ‑pee ke'wlɛ ɔ 'na : Ao 'je pɛe 'a blua' ! Ka 'ɩn \"Bo dboa 'ʋn ɛ, 'kamɔ 'ma dbo aopʋ ‑ke. ");
INSERT INTO wob_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Wlu ‑nɩ ‑kwɛ‑a 'de ɔ 'wɔn i 'sʋ ɔ poɛ ʋʋpʋ poɔ' ‑wɛe ɔ 'na : Ao 'je Kea 'a ‑Suu ‑kwɛai ɛ. ");
INSERT INTO wob_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Nyʋ ‑ʋʋa dɩsaɩn ao 'wlʋa \"kpei ɛ, ‑mɛ ʋʋa' dɩsaɩn a muɛ ‑kwɛa, 'de nyʋ ‑ʋʋa dɩsaɩn ao sea \"kpei 'wlʋ ɛ, ‑mɛ ʋʋa' dɩsaɩn se ‑kwɛi. ");
INSERT INTO wob_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","'De ‑ta Sesi a jia, ‑mɛ Toma nyʋ a 'daa ‑gbaju ɛ, ‑wɛe ‑ɔ ‑nɩa klai\" nynuu ‑nɩa ‑puue 'jɔ 'sɔɔn 'ɔ due' se 'e ʋʋpʋ \"klu nɩ‑. ");
INSERT INTO wob_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Ɛmɛ ‑tɩ klai\" nynuu po Toma \"kʋan, ʋʋ 'na : ‑A ‑je Tʋ\"bo 'mɛ ! 'Kaa Toma 'na : ‑Bo 'ɩn se 'pɔnte 'a ‑kɔ \"jriɛ 'jee 'de ɔ 'kwa, ‑bo 'ɩn se 'o 'ma ‑cɩɛ tba, 'de ‑bo 'ɩn se 'o ɔ ‑gbɩn 'ma kwa ‑te' ɛ, ‑mɛ 'ɩn se ɛ tɔ' 'ʋn 'jei. ");
INSERT INTO wob_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","'Wɩ ‑mɛ\" na ‑sia' 'sʋ Sesi 'a klai\" nynuu 'kɩɩɛn \"jrui 'de ‑gbu\" 'di ke'wlɛ, ‑mɛ Toma nɩɛ 'e ʋʋpʋ \"klu, 'Sʋ Sesi ‑taan' 'bo ʋʋpʋ 'a ‑kwea'‑, 'de 'bo ‑gbɛin\" kaan'. 'De ɔ 'na : Ao 'je pɛe 'a blua' ! ");
INSERT INTO wob_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","'Sʋ ɔ wlu' 'de Toma ‑pee ɔ 'na : Toma, ‑ɩn ‑kpaa' ‑ma ‑cɩɛ ‑ta, ‑ɩn ‑gbʋn 'ma kwa ja, ‑ɩn ‑kpaa' sʋn ‑ta ‑ɩn ‑teɛ 'bo 'ʋn ‑gbɩn. ‑Ɩn ‑bo pɛe \"ikmuuɛ ‑ɩn ‑je dɛ tɔ' 'ʋn ! ");
INSERT INTO wob_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","'Sʋ Toma 'na : 'Ma Tʋ\"bo, 'ma Kea ! ");
INSERT INTO wob_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","'De Sesi 'na : Dɛ ‑ɩn ‑jeea' 'ʋn \"jriɛ‑, ɛmɛ ‑tɩ ‑ɩn ‑je 'ma ‑tɩ' tɔ' 'ʋn ? Nyʋ ‑sea' 'ʋn \"jriɛ‑ 'jee‑ 'sʋ ‑ʋʋ ‑jea 'ma ‑tɩ' tɔ' 'ʋn ɛ, ʋʋ nʋ 'mʋa‑. ");
INSERT INTO wob_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Sesi nʋɛ jrii' ‑tuu\"‑tuu jrɩ' ke'wlɛ 'bo ɔɔ' klai\" nynuu \"juɔi, ‑wɛe ‑ɩ se 'crɩɩɛ 'de 'sbɛ ‑nɛ 'di. ");
INSERT INTO wob_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","'Kaa dɩ ‑jɩ ‑mɩ 'crɩɩɛ ‑wɛe ka Sesi nɩa Klisɩ Kea 'a \"Ju ɛ, ao 'je ɛ tɔ' 'ʋn 'je ‑wɛe ao 'je 'kmʋnɩa' ‑sea' ‑kwɛ ‑ta 'ble 'je 'de ɔɔ' 'nynɩ 'ʋn. ");
INSERT INTO wob_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","‑Mɛ 'wlʋa 'o mu ɛ, Sesi to ɔɔ' ‑cɛ\" 'mɛ ke'wlɛ 'de ɔɔ' klai\" nynuu ‑pee 'bo Tiberiadɩ ‑ni ‑kwlɩ\". 'De ka ɔ nʋa ɔɔ' ‑cɛ\" tosʋn, 'ka ka : ");
INSERT INTO wob_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Simɔ Piɛi ke, Toma ʋʋa 'daa‑ ‑gbaju ke, Natanaɛ ‑wlʋa Kana 'de Galile ke, Sebede 'a \"nynuu‑ ke, klai\" nynuu 'sɔɔn jrʋ' ke, ʋʋpʋ ‑nɩ ‑tadue. ");
INSERT INTO wob_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","'Sʋ Simɔ Piɛi wlu' 'de ʋʋ ‑pee ɔ 'na : 'Ma muɛ 'sai‑ poa'. 'De ʋʋ ‑wee' 'na : ‑A ‑ke ‑ma mu ‑ke. 'Sʋ ʋʋ mu', ‑wɛe ʋʋ 'ja 'e ‑kwɛɛ\" 'di 'de ʋʋ ‑te 'sai‑ poa' ‑pʋn\", 'kaa ʋʋ se dɛ jrɛ' ‑sa 'de ɛɛ' \"maʋ'wɩ tu 'di. ");
INSERT INTO wob_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","‑Ta ‑sɔɔn' ‑sɩɩan' 'sʋ ɛ, Sesi ‑taan' 'de 'kpʋʋ \"kpei, 'kaa kɛ nɩa ɔmɔ ɛ, klai\" nynuu se ɛ juo‑. ");
INSERT INTO wob_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","'Sʋ Sesi 'da ʋʋpʋ 'mɛ ɔ 'na : \"Nynuu‑, ao 'je dɛ 'mɛɛ ? 'Sʋ ʋʋ 'na : \"Ɩɩn‑. ");
INSERT INTO wob_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","'De ɔ 'na : Ao po 'sai‑ 'bo ‑kwɛɛ\" 'ɛ dianfɔ o kea', aoa muɛ dɛ 'jea'. Ʋʋ poa 'sai‑ kan' ‑cɛɛn'‑ 'sʋ, 'kaa ʋʋ se ɛɛ' ‑cria' 'bɛɛ‑ de'bɔɔ‑ nɔ\" 'de ‑smii' 'a \"i ‑tietɩ 'ʋn. ");
INSERT INTO wob_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","'Sʋ Sesi 'a ‑tɩ' ‑kma klai\" ju wluɛ Piɛi ‑pee ɔ 'na : Ɛ Tʋ\"bo ‑o ! Simɔ Piɛi 'wɔan ɛ Tʋ\"bo ‑o 'sʋ ɔmɔ ‑cɛan' kui 'de ɛ, ɔ paa ɔɔ' dɩ 'ʋn 'ɛ, 'sʋ ɔ 'kpa \"niɔ‑ ‑pluu‑. ");
INSERT INTO wob_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Klai\" nynuu ‑jʋ ‑sia 'o ‑mʋ nɩɛ 'e ‑kwɛɛ\" 'di ‑wɛe ʋʋa mu ɔ kɩn, ka ʋʋa mua, 'kamɔ ʋʋa ‑cri' 'sai‑ ‑smii' \"jia 'di ɛ. Dɛ‑nʋɛ' ‑ta ʋʋ pooa 'sai‑ ɛ, 'bo ke 'kpʋʋ 'nynɩ 'a tɛnsʋn 'beeɛ ɛ 'e dɩ\" 'a kmɛ' 'sɔɔn nɩ‑. ");
INSERT INTO wob_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Ʋʋa 'wlʋa 'de ‑kwɛɛ\" 'di ʋʋa \"sia i ɛ, ‑mɛ ʋʋ jɛɛ nɛ ‑ɛ ‑tbaa' ‑wɛe ‑smii' nɩ 'o \"jri, 'de ‑di'pɛn nɩ 'o. ");
INSERT INTO wob_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","‑Wɛe Sesi wlu ʋʋ ‑pee ɔ 'na : Ao ja ‑smii' ao ‑sa 'a jrɩ'. ");
INSERT INTO wob_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","'Sʋ Simɔ Piɛi 'ja 'e ‑kwɛɛ\" 'di de ‑wɛe ɔɔ ‑cri' 'sai‑ 'nɔ 'kpʋʋ \"kpei. ‑Smii' klae\" 'a kmɛ' 'due kwla ‑mm\" 'jɔ taan (153) ‑nɩ 'e ɛ 'di. 'Kaa ‑smii' ‑jia\" 'e 'sai‑ ‑nɛ 'di ɛ, ɩ se ɛɛ' 'jɔ cɛn. ");
INSERT INTO wob_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","'Sʋ Sesi wlu' 'de ʋʋ ‑pee ɔ 'na : Ao ji dɛ di ! Nyɔ ‑je ɔ i ‑tee' 'de klai\" nynuu \"klu ɔ ‑jea nʋ : ‑Ma 'nynɩ wɛ‑ ? Ɔ se nɩ‑, dɛ‑nʋɛ' ka ɛ nɩa Tʋ\"bo ɛ, ʋʋ ‑wee' 'je kan' 'mɛ. ");
INSERT INTO wob_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Sesi 'kɩɩan 'o 'sʋ ɔ \"duo ‑di'pɛn 'ʋn 'ɛ, ‑wɛe ɔ \"nyɩ ɛ ʋʋpʋ, 'de ɔ \"nyɩ ʋʋpʋ ‑smii' ‑ke. ");
INSERT INTO wob_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Sesi sɔan \"kunyɩɔ' ɛ, ɔ ke ɔɔ' klai\" nynuu 'a 'jeea 'a kpɛ taan ‑nɛ ‑nao. ");
INSERT INTO wob_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Ʋʋ ‑kɔa' dɛ dia' 'sʋ, Sesi ‑tee' ɛ Simɔ Piɛi ɔ 'na : Sonasɩ 'a \"ju Simɔ, ‑ɩn ‑kma 'ma ‑tɩ' 'mɛ ‑ta, ɛ je nyʋ ‑nʋ ‑sii ? 'Sʋ Piɛi 'na : Kɩɩn Tʋ\"bo, ka 'ɩn kma ‑ma ‑tɩ', ‑ɩn ‑juɛ'. 'De Sesi 'na : ‑Ɩn ‑tu\" 'ma 'blae nynu 'a ‑tɩ'. ");
INSERT INTO wob_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Ɔ ‑tee' ɔ i kpɛ 'sɔɔn ‑nɛ ke'wlɛ, ɔ 'na : Sonasɩ 'a \"ju Simɔ, ‑ɩn ‑kma 'ma ‑tɩ' 'mɛ ‑taa ? 'Sʋ ɔ 'na : Kɩɩn, Tʋ\"bo, ka 'ɩn kma ‑ma ‑tɩ' ɛ, ‑ɩn ‑juɛ' 'pepe. 'De Sesi 'na : ‑Ɩn ‑tu\" 'ma 'blae nynu 'a ‑tɩ'. ");
INSERT INTO wob_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","‑Wɛe Sesi ‑sa wlu de kpɛ taan ke'wlɛ, ɔ ‑tee' ɔ i 'de ɔ 'na : Sonasɩ 'a \"ju Simɔ, ‑ɩn kma 'ma ‑tɩ' 'mɛ ‑cɛɛn'‑ ? 'Sʋ dɛ Sesi ‑tee' ɔ i kpɛ taan ‑wɛe ɔ 'na ‑ɩn kma 'ma ‑tɩ' 'mɛ ‑cɛɛn'‑, ‑ɛ kpʋn ɔ ‑kwlʋ 'sʋ ɛ \"kaeɛ ɔ \"jrii, 'de ɔ 'na : Tʋ\"bo, ‑ɩn ‑juo dɩ ‑wee' \"klein 'mɛ, ka 'ɩn kma 'ma ‑tɩ', ‑ɩn ‑juɛ'. 'De Sesi 'na : ‑Ɩn ‑tu\" 'ma 'blae nynu 'a ‑tɩ'. ");
INSERT INTO wob_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Tɔ' ‑tɩ 'a tɔ' ‑tɩ 'ma 'tmʋʋ‑ ‑ʋn, ‑ta ‑ɩn ‑nɩɩa ‑kooai\" ‑saan\" a, ‑mɛ ‑ma ‑cɛ\" ‑ɛ paa ‑ma dɩ 'ʋn, ‑wɛe ‑ta ‑ɩn ‑nɩai\" ‑ma mu 'o, 'kaa ‑sɔntɩ ‑ma mua ‑kea\" 'kpaa' a, ‑ma muɛ sɩn sroa', ‑wɛe nyɔ jrɔ' 'je ‑ʋn dɛ 'ʋn paa‑ 'de ‑ta ‑ɩn sea \"inɩ ɛ, ɔ 'je ‑ʋn 'bo kpa. ");
INSERT INTO wob_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Ka Piɛi 'a 'mɛsʋn 'jea Kea 'a 'nynɩ \"i 'bɛɛ‑ 'de nya a, ɛmɛ ɔ 'tmʋa 'o 'mʋa‑ 'de wlu ‑nɛ 'ʋn. Sesi ‑kɔa' ɩa' 'tmʋa' kan' 'sʋ ɔ 'na : ‑Ɩn bla 'bo 'ʋn 'de. ");
INSERT INTO wob_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Piɛi \"biia de 'sʋ ɔ 'je Sesi 'a ‑tɩ' kmaklai\" ju 'mɛ, ‑mɛ ɔ jiɛ ʋʋpʋ kɩn ɔmɔ ‑pɛn Sesi jai dɛdi nɔ\", ‑wɛe ‑ɔ ‑tee' ɔ i ka : Tʋ\"bo, nyɔ wɛ‑ ‑je ‑ʋn 'de to ɛ‑ ? ");
INSERT INTO wob_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Piɛi 'je ɔ i 'sʋ ɔ ‑tee' ɛ Sesi i ɔ 'na : 'De ‑jɔ ‑mɔ 'e ? Dɛ ‑je ɔ \"jrii nʋʋɛ‑ ? ");
INSERT INTO wob_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","'Bomɔ Sesi wluu ɔ 'na : ‑Bo 'ɩn nɩɛ \"i ɔ 'e 'kmʋ nɩ mamaʋ 'sʋ 'ɩn 'je de ji 'ee, ‑ma ‑tɩ' wɛ‑ ‑sie 'o ‑mɔ ɛ‑ ? ‑Mɔ bla 'bo 'ʋn 'de 'sʋ. ");
INSERT INTO wob_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","'Bo wlu ‑nɛ \"kpei la, ʋʋ 'jrɛɛ‑ ɛɛ' kɛ' i 'de ɔɔ' \"dɛi‑wi\" \"klu, ʋʋ 'na klai \"ju ‑nɔ se 'mɛi. 'De Sesi se kan' ‑mɔ 'da, 'kaa ɔ 'naa : ‑Bo 'ɩn nɩɛ \"i ɔ 'e 'kmʋ nɩ‑ mamaʋ 'sʋ 'ɩn 'je de ji 'ee, ‑ma ‑tɩ' wɛ‑ ‑sie 'o ‑mɔ ɛ‑ ? ");
INSERT INTO wob_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Klai\" ju ‑nɔ, ɔmɔ ‑ɔɔ po dɩ ‑nɩ 'a \"kuan ‑wɛe ‑ɔ ‑crɩ'. 'De ‑a ‑je kan' 'mɛ dɩ ɔ 'tmʋa ɩ nɩɛ tɔ' ‑tɩ ‑o ‑cɛɛn'‑. ");
INSERT INTO wob_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Sesi nʋɛ dɩ ‑tuu\"‑tuu jrɩ' ke'wlɛ. ‑Bo nyʋ 'crɩɩ ‑wee' dodo‑ 'de ɛ, 'ma naa tɔ' i, 'sbɩ nyʋ a mua 'crɩa' se 'nɔ 'kmʋ ‑nɛ \"kpei 'bɛɛi.");
INSERT INTO wob_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","2","Teofi, dɩ \"klein Sesi nʋa o, ‑jɩ ɔ tɔɔa nyʋ dɛ ‑wlʋa 'e sese o ‑wɛe ‑ɛ jia mamaʋ 'sʋ ‑ɛ ‑jɛɛa ɔɔ' jaʋn 'di mua' a, ɩmɩ 'ɩn 'tmʋ 'de 'ma \"i‑saasbɛ 'di. Nɔ\" ‑ɛ 'di ɔ 'jea jaʋn 'di mu ɛ, 'bomɔ ɔ jii 'de Kea 'a ‑Suu 'ʋn ‑wɛe ɔ sie ɔɔ' dboʋn ɔ ‑sa 'o wlu o. ");
INSERT INTO wob_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Ɔɔ' 'klejewɩ 'wlʋa 'o ‑jei\" ɛ, ɔ to ɔɔ' ‑cɛ\" 'mɛ 'de ʋʋ ‑pee, ka ɔ nɩa 'kmʋ ɛ, ɔ to ɛɛ' sʋn 'mɛ kpɛ ‑tuu\"‑tuu 'ʋn 'de 'wɩ 'a kwla ‑nyiiɛ 'di, ‑wɛe ɔ 'tmʋ Kea 'a tʋ\"bodɛ 'ɛ ‑tɩ' 'de ʋʋ ‑pee. ");
INSERT INTO wob_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","‑Ta ɔ ke ʋʋ ‑teea i 'wɩ jrɛ' o ɛ, 'bomɔ ɔ ‑tuu\" ʋʋpʋ wlu, ɔ 'na : Ao 'bo Selisalɛm o tɩɩɛn, 'kaa ao fuo dɛ \"Bo \"sia 'nynɩ ‑wɛe ‑ɛɛ ‑tɩ' 'ɩn 'tmʋa 'de ao ‑pee 'de ɛ. ");
INSERT INTO wob_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Dɛ‑nʋɛ' San nʋɛ \"ni ‑wɛe ɔ po nyiɔpʋ‑ \"ni \"jru, 'kaa aopʋ‑ mɔ ɛ, 'de 'wɩ pla 'di ɛ, Kea a muɛ ɛɛ' ‑Suu nʋa' ‑wɛe ɛ 'je aopʋ‑ \"ni \"jru po. ");
INSERT INTO wob_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","'Sʋ dboʋn ‑kɩɩan' \"jrui ‑tee' ɔ i, ʋʋ 'na : Tʋ\"bo, 'de ɛɛ' nɔ\" tu 'di mɔ ‑ɩn ‑jea Israɛ 'a 'beɔdɛ 'ɛ ‑gbɔɔ ‑dee \"ni po ? ");
INSERT INTO wob_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","'Bomɔ Sesi wluu 'de ʋʋ ‑pee ɔ 'na : Dɛ \"Bo ‑tea' ‑wɛe ɛ 'jea nʋ 'de ɛɛ' 'sʋ 'a ‑kwlʋtɩ 'ʋn ɛ, ɛ se ɛmɛ ‑ɛɛ 'wɩ ke ‑ɛɛ nɔ\" aopʋ‑ mɔ 'je juo nɩ‑. ");
INSERT INTO wob_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","'Kaa aoa muɛ \"ikmaa' 'jeea', Kea 'a ‑Suu a muɛ 'e aopʋ‑ 'ʋn jia', ‑wɛe ao 'je 'ma ‑tɩ' 'a ‑ta 'jeʋn nɩ‑ 'bo Selisalɛm, 'de Suideblʋa ke Samadiblʋa \"kpei, 'de ao 'je mu mamaʋ 'sʋ ao 'je 'e 'blʋa 'a \"ti 'ɩn nyni. ");
INSERT INTO wob_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Sesi ‑kɔa' wlu ‑nɩ 'a 'tmʋa' 'sʋ ɔ sɔn 'ʋn 'ɛ, ‑wɛe ɔ mu \"jɛi 'de ɔ mu jaʋn 'di. Ʋʋ siɛ ɔɔ' ja ‑gbʋan' 'sʋ ɔ je ʋʋpʋ \"jrii \"maa 'de bue\" 'ʋn. ");
INSERT INTO wob_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","'Bo jaʋn ‑kwlʋ Sesi sɔan 'ʋn ɛ, ʋʋa ‑gbʋn' 'o 'ɛ jojo, ‑mɛ ɔ nɩɛ mua'. Ʋʋ siɛ 'e ‑gbʋan' 'sʋ nyʋ 'sɔɔn ‑paa dɩ plu 'ʋn ‑ʋʋ ‑taan' ʋʋpʋ \"kpei, ");
INSERT INTO wob_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Ʋʋ ‑na : Galilenyʋ, dɛɛ‑tɩ ao nyna i ‑ta, ‑wɛe aoa ‑gbʋn 'e jaʋn‑kwlʋ ɛ‑ ? Sesi ‑nɔ ‑sɔan 'ʋn 'bo aoa' ‑kwea'‑, ‑wɛe ‑ɔ mua jaʋn 'di ‑ta, ka ɔɔ' jaʋn 'di musʋn nɩa, 'kamɔ ɔɔ' dejisʋn a mu nɩa'. ");
INSERT INTO wob_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","'Sʋ ʋʋ 'wlʋ 'e crʋ ‑ɛɛ 'nynɩ nɩa olifie crʋ \"kpei 'mɛ ‑wɛe ʋʋ mu Selisalɛm de. Dɛ ‑wlʋa 'o ‑wɛe ‑ɛ mua de ɛ, ɛ 'bɛɛ‑ ‑je 'a ‑to due' 'mɛ. ");
INSERT INTO wob_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","‑Ta ʋʋ nynia 'sʋ ɛ, ʋʋ 'ja 'e \"jɛi ‑gbu 'a wɔn due' 'di ‑ta ʋʋa ‑tea i see ɛ. Ɛ nɩ Piɛi o, San o, Sakɩ o, Ancre o, Filipʋ o, Toma o, Batelemi o, Matie o, Alfe 'a \"ju Sakɩ o, Simɔ ‑ɔ ‑pɔan ‑ɔɔ 'blʋa‑ 'jea ɛɛ' ‑cɛ\" ‑pee ‑te ke Sakɩ 'a \"ju Suidɩ ke‑. ");
INSERT INTO wob_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Ʋʋ ‑wee' 'bɛɛ‑ wlu 'ʋn, ‑wɛe ʋʋa bae Kea 'de nai\" 'blea' 'ʋn. Ʋʋ ke 'nynʋkpae' ke‑, Sesi de Madi ke ɔɔ' \"dei ‑wi\" ke‑. ");
INSERT INTO wob_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","'De ɩa' 'wɩ tu 'di 'sʋ Piɛi sɔn 'ʋn 'ɛ 'bo ɔɔ' de 'di‑wi\" 'a ‑kwea'‑, nyʋ ‑ʋʋ ‑kɩɩan' \"jrui 'de ɛɛ' nɔ\" tu 'di ɛ, ʋʋ 'bɛɛ‑ kmɛ' 'due kwla 'sɔɔn 'mɛ, ‑wɛe ɔ 'na : ");
INSERT INTO wob_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","'Ma de 'di‑wi\", dɛ Kea 'a ‑Suu 'tmʋa sese, 'de ‑ɛ ‑jiia 'e Dafidɩ 'wɔn ‑wɛe ‑ɛ ‑crɩɩa' 'de Suida ‑ɔ ‑kɔan Sesi 'a kpʋʋn \"juɔi 'a ‑tɩ' 'ʋn ɛ, ɛ 'je 'o nyni ‑o see. ");
INSERT INTO wob_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","'De ‑mɛ 'kamɔ ɔ ‑srooɛ 'de ‑a \"klu 'de‑, ‑wɛe ɔ ke ‑a ‑gble' dbo 'ʋn. ");
INSERT INTO wob_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Ɔɔ' \"ju tu 'wɛi ʋʋ \"nyɩ ɔ 'de ɔɔ' \"ku 'dba ‑tɩ' 'ʋn ɛ, ɩmɩ ɔ ‑tɩɩn ‑kle'. ‑Ta ɔ ‑kaa' i ɛ, ɔ cɛn ‑tie\" 'bo ‑kwea'‑, ‑wɛe ɔɔ' 'mɩ ‑wee'‑ ‑gbaa dɩ 'mii. ");
INSERT INTO wob_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Nyʋ \"klein ‑nɩa 'o Selisalɛm ɛ, ʋʋ ‑wee' juo ɩa' dɩ tu 'mɛ, ɛmɛ ‑tɩ ʋʋa 'daa‑ ‑kle' ‑nɛ Akɛdama 'de ʋʋ \"bliwlu 'di, ɛ 'de mɛ ‑nɩ nmɔ 'ɔ ‑kle'. ");
INSERT INTO wob_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","'De dɛ ‑crɩɩa' 'e Dafidɩ 'a 'dʋ 'di, ɛ ka : Ɔɔ' ‑gbu\" do', nyɔ \"o nyɔ 'bo 'e ɛ 'di \"tiɛ. 'De nyɔ jrɔ' \"duo ɔɔ' dbo 'ʋn. ");
INSERT INTO wob_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","22","Ɛmɛ ‑tɩ nyɔ due' 'je 'e ‑a \"klu 'kpa, ‑wɛe ɔ 'je Tʋ\"bo Sesi 'a \"kunyɩɔ' sɔn‑tɩ 'a ‑ta 'jei nɩ‑. Ɔɔ' \"ju tu 'je nyʋ ‑ʋʋ ‑ke ‑a mua dɩ 'mii mamaʋ dɛ ‑wlʋa 'e San 'a Sesi 'a \"ni \"jru poa', ‑wɛe ‑ɛ ‑jɛɛa 'wɩ ‑ɩ 'di Sesi 'wlʋa 'de ‑a \"klu ‑wɛe ɔ mua jaʋn 'di ɛ, 'de ʋʋpʋ \"klu 'de ɔ 'e 'wlʋ. ");
INSERT INTO wob_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","'Sʋ ʋʋ nynaa nyʋ 'sɔɔn i : Soseʋ, nyʋ a 'daa‑ Basabasɩ 'de ‑ɔɔ \"kpei ‑tenynɩ nɩa Suistisɩ ke Matiasɩ ke. ");
INSERT INTO wob_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","‑Wɛe ʋʋ bae Kea ka ʋʋ 'na : Tʋ\"bo, ɛmɛ ‑juua nyʋ ‑wee' \"klein 'a pɛe ɛ, nyɔ ɛ ‑sa 'o 'bo nyʋ 'sɔɔn ‑nʋ \"klu ɛ, ɛ ‑to ɔ ‑cɩɛ, ");
INSERT INTO wob_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","'de ɔ 'je ‑teɩn ke dbo Suida 'bɔa o ‑wɛe ɔ 'mɛa 'ʋn \"duo‑. ");
INSERT INTO wob_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Ʋʋ poa soa' \"jɛi 'sʋ ɛ ‑sa 'o Matiasɩ ‑wɛe ɔ nynia dboʋn ‑nɩa ‑puue 'jɔ due' \"i. ");
INSERT INTO wob_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Pantekɔtɩ 'a 'wɩ o ɛ, ʋʋ ‑wee' \"klein 'kɩɩɛn \"jrui ‑tadue. ");
INSERT INTO wob_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Ʋʋa ‑gbʋan 'e mu kaan 'sʋ ‑cruɛn\" ‑wlʋ 'e jaʋn 'di, ka ‑pie klaa\" a jia, 'kamɔ ɛ nɩ‑, 'sʋ ɛ \"ji 'e ‑gbu\" 'di ʋʋ ‑tea i 'mɛ. ");
INSERT INTO wob_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","'Sʋ ʋʋ 'jeeɛ mɩɩɔ ‑tuu\"‑tuu \"jriɛ‑, ka nɛmɩɩɔ nɩa ‑ɩ ‑nɩ kan', ‑ɩa ‑seea' 'ʋn 'de ‑ɩa ‑te' ʋʋpʋ \"jrui due 'due. ");
INSERT INTO wob_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","'Sʋ Kea 'a ‑Suu \"ji 'de ʋʋ ‑wee' \"klein 'ʋn 'ɛ, 'sʋ ʋʋ ‑teɛ wlu 'srʋ 'a poa' ‑pʋn\", ka Kea 'a ‑Suu ‑tuɛ\" 'de ʋʋpʋ ‑kwlɩ\" ɛ. ");
INSERT INTO wob_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","'De ɛɛ' 'wɩ tu 'di ɛ, Suifʋ ‑a naa Kea 'a ‑jei\" ‑wlʋa 'blʋɩ ‑wee' 'dii 'kɩɩɛn \"jrui 'bo Selisalɛm. ");
INSERT INTO wob_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Ʋʋ 'wɔan ‑cruɛn\" ‑nɛ 'sʋ, ʋʋ ‑wee' 'bleɛ plea' ʋʋ je 'o ji, tai' \"maa ʋʋpʋ 'mɛ, dɛ‑nʋɛ' ʋʋa a 'wɔn ʋʋ \"bliwlu 'mɛ due due' 'de ʋʋpʋ 'wɔn. ");
INSERT INTO wob_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Tai' a \"maa' \"ji 'de ʋʋpʋ 'ʋn 'ɛ ʋʋ ‑ga' wɔn ‑wɛe ʋʋa 'jraa dɩ ‑ɩa nʋʋa, 'sʋ ʋʋa wluɛ ba ‑pee ka, ʋʋ 'na : Nyʋ ‑nʋ ʋʋ ‑wee' \"klein se Galile 'wlʋ 'dee‑ ? ");
INSERT INTO wob_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","‑Aee' kɛ nʋ 'sʋ ‑wɛe ‑aa ‑wɔn ‑a \"bli wlu due 'due 'de ʋʋpʋ 'wɔin ɛ‑ ? ");
INSERT INTO wob_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","‑A ‑wlʋɛ Patɩ‑blʋa o, Mɛdɩblʋa o, Elamitɩ‑blʋa o, Mesopotamiblʋa o, Suideblʋa ke Kapadɔsɩ‑blʋa, Pɔn ke Asiblʋa o, ");
INSERT INTO wob_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","Friki ke Pamfiliblʋa o, Esipʋ‑blʋa o, Libi 'a 'blʋa ‑ɛ ‑ke Sirɛnɩ‑kwlɔ \"kʋʋan i 'dii o, ɛ ke nyʋ ‑ʋʋ ‑wlʋa Rɔmʋ ke‑. ");
INSERT INTO wob_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","Nyʋ ‑nɩa Suifʋ‑wi\" 'a ‑cɛ\" 'kpa o, nyʋ ‑ʋʋ ‑sa Suifʋ‑wi\" 'a kplɩn \"kpei, Kletoa ke Rabʋ o, kɛ nʋ 'sʋ ‑aa ‑wɔn ʋʋpʋ 'a wlu 'mii due 'due 'de ‑a \"bliwlu 'di ‑wɛe ʋʋa 'tmʋ dɩ 'dɔe 'dɔe Kea nʋa 'a ‑tɩ' ɛ‑ ? ");
INSERT INTO wob_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Tai' \"maa ʋʋ ‑wee' \"klein 'mɛ dɛ ʋʋ 'jea tɔ' \"kpei‑ naa ‑gblein', ʋʋa' 'je ɛ, 'sʋ ʋʋa wlu' 'e ba ‑pee ʋʋ 'na : 'De dɛ ‑nɛ ‑mɛ 'de 'a 'nynɩ wɛ‑ ‑sɩan ka a‑ ? ");
INSERT INTO wob_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","'Kaa nyʋ jrʋ' a wlaa ʋʋpʋ 'mɛ, ʋʋa wlu ka, ʋʋ 'na : nmɔ ‑si' ʋʋpʋ \"i. ");
INSERT INTO wob_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","'Bomɔ Piɛi sɔn 'ʋn ɔ ke dboun ‑nɩa ‑puue 'jɔ due' ke‑, ‑wɛe ɔ kpa wlu \"jɛi 'de ʋʋ ‑pee ka, ɔ 'na : Ao Suifʋ ke nyʋ \"klein ‑kooa' ‑ta Selisalɛm, ao sie dɛ ‑nɛ tɔ' o, ‑wɛe dɛ 'ma jia 'tmʋa' ao 'je ɛ doin\" o po. ");
INSERT INTO wob_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Nyʋ aoa 'jea i ‑ta, ʋʋ se nmɔ 'na, ka aoa nɛɛ tɔ' \"kpei ɛ, dɛ‑nʋɛ' ‑ta ‑sɔn' ‑sɩɩan' 'bo se 'ʋn ‑kwle ke, ‑klae\" jrʋ nɩɛ ‑gbao. ");
INSERT INTO wob_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","'Kaa dɛ Kea 'a wlu 'kwajaai Soɛlɩ 'tmʋa 'de ɛ, ɛɛ' 'o nynisʋn ka. ");
INSERT INTO wob_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","Kea wlu' ka, ɛ 'na : 'De de 'bɔɔwɩ 'di ɛ, 'ma muɛ 'ma ‑Suu 'de nyɔ ‑wee' 'ʋn poa', ‑wɛe aoa' \"nynunmai nynuu ke aoa' \"nynuunynʋkpae' 'je 'ma ‑tɩ' 'tmʋ, aoa' ‑kʋɩɩ\" mɩɩ\" a muɛ dɩ Kea a tɔɔa ʋʋpʋ 'jea', aoa' nyʋ ‑cɔʋn'‑wi\" a muɛ jɩ jaa'. ");
INSERT INTO wob_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Kɩɩn, \"nynunmai ke 'nynʋkpae' ‑ʋʋ ‑nɩa 'ma dbonʋʋn ɛ, 'ma muɛ 'ma ‑Suu 'de ʋʋpʋ‑ 'ʋn jaa' ‑wɛe ʋʋ 'je 'ma ‑tɩ' 'tmʋ 'de ɩa' 'wɩ tu 'di. ");
INSERT INTO wob_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","'Ma muɛ dɩ klae\" klae\" nʋa' 'de jaʋn 'di, ‑wɛe 'ɩn 'je jrii' ‑tuu\"‑tuu nʋ 'nɔ 'blʋa‑ \"kpei. Nymɔ ke, nɛ ke dao' ‑gblʋn a muɛ 'e nɩa' ‑ke. ");
INSERT INTO wob_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","'Jrʋ a muɛ fai\" pooa', ɛ 'e kwie 'ʋn ‑snɛɛ, ‑wɛe 'cʋ 'e ‑sain' ka nymɔ nɩa ‑wɛe Tʋ\"bo 'a 'wɩ 'je 'o nyni. Ɛɛ' 'wɩ tu nɩɛ ɔɔ' 'nynɩ 'wlʋwɩ klaa\" ‑o. ");
INSERT INTO wob_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","‑Mɛ Nyɔ \"o nyɔ ‑ɔɔ mua Tʋ\"bo 'a 'nynɩ ‑too\"‑ \"i poa' a, ɔɔ muɛ 'pʋʋa'. ");
INSERT INTO wob_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","Israɛ‑kɔʋn, ao po wlu ‑nɩ doin\" o ! Sesi ‑wlʋa Nasarɛtɩ ka Kea \"nyɩ ɔ \"ikmaa' ɛɛ' ‑cɛ\" 'kpa to ɛ 'bo ao ‑wee' \"juɔi 'de jrii' ke dɩ \"klein ɔ nʋa 'bo aoa' ‑kwea' 'ʋn ɛ, aoa' ‑cɛ\" 'kpa juɩ' 'pepe. ");
INSERT INTO wob_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Ɔɔ' \"ju tu tooɛ 'e 'mɛ 'de Kea 'a ‑cɛ\" 'ɛ ‑kwlʋtɩ 'ʋn, dɛ‑nʋɛ' Kea ‑te' ɛɛ' dɛ tu 'mɛ sese. Ɔmɔ ao kɔ 'bo tu ‑kwlɩ\" ao 'bɔɔ dɛsaʋnʋʋn kwa ‑wɛe ʋʋ 'dba. ");
INSERT INTO wob_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","'Kaa Kea jɔ 'kmʋ de, ɛ cɛn ɔ 'mɛɛa' 'a \"dbi kui, dɛ‑nʋɛ' 'mɛa' seɛ 'bɛɛ‑ ɛ 'je ɔ bʋ wɔ kpʋn. ");
INSERT INTO wob_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Ɛmɛ ‑nʋɛ' ‑wɛe Dafidɩ wlu 'de ɔɔ' ‑tɩ' 'ʋn, ɔ 'na : 'Ma 'jeɛ 'ma Tʋ\"bo i jeejee 'bo 'ʋn \"juɔi, dɛ‑nʋɛ' ɛɛ poɛ 'ʋn sʋn o ‑wɛe 'ma dɩ je crɛ. ");
INSERT INTO wob_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Ɛmɛ ‑tɩ 'mʋa 'a 'sʋ \"ji 'ʋn pɛe o, ‑wɛe ‑pɔia\" wlu 'a 'sʋ a ji 'de 'ʋn 'wɔn. ‑Bo 'mɛa' ‑sa 'ma 'blʋku ‑je 'kwa mɔ 'de ɛ, ‑ta 'ɩn 'jea tɔ' tba 'ɩn 'ble 'o 'ɛ 'bode, ");
INSERT INTO wob_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","dɛ‑nʋɛ' 'ma Tʋ\"bo, ɛ se 'ma ‑suu 'bɔi 'de 'mɛʋn o ‑kwlɔ. Nyɔ ‑nɩa ɛɛ' nyɔ ɛ, ɛ se ɛ 'bɛɛ‑ ɛ 'je ɔ \"i \"tai‑ ɔ 'je 'e ‑sɔan' 'ʋn cɛɛn‑. ");
INSERT INTO wob_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Ɛ ‑tɔɔ 'ʋn 'kmʋnɩ ‑jeblʋ 'mɛ. 'De ‑sɔntɩ 'ɩn ke ɛɛ mua \"jua‑ \"i ‑tea' a, ɛɛ muɛ 'ʋn 'mʋa‑ 'ʋn \"jiia'. ");
INSERT INTO wob_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","'Ma de 'di‑wi\", 'ɩn 'bɛɛ 'ɩn 'je wlu 'flɛʋn 'de ao ‑pee 'de ‑a 'mɩa Dafidɩ 'a ‑tɩ' 'ʋn. Ɔ 'mɛa ɔ nmaeɛ i, ɔɔ' ‑gbaɩn' nɩɛ 'de ‑a \"klu 'de ‑sɩanwɩ 'di ‑ke. ");
INSERT INTO wob_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","'Kaa ka ɔ nɩa Kea 'a wlu 'kwajaai ɛ, ‑wɛe ɔ juɛ 'pepe ka Kea cɛan wlu ‑tie\" 'de ɔ ‑pee, ɛ 'na : ‑Ma \"ju due' ‑a mu 'beɔ nɩa' 'bo ‑ma ‑kɔi\". ");
INSERT INTO wob_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Dɛ Dafidɩ 'jea sese ‑wɛe ɔ 'tmʋa, ɛ nɩɛ Kea 'a 'o‑tei Klisɩ 'a \"kunyɩɔ' sɔn‑tɩ 'ʋn ‑o. ‑Bo ɔ wlu ka ɔ 'na : Ɛ se ɔ 'bɔ 'de 'mɛʋn o ‑kwlɔ ɔ, ‑wɛe ɔɔ' ku se 'e ‑sɔan' 'ʋn cɛɛn ɛ, ");
INSERT INTO wob_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","‑mɛ ɔɔ' Sesi tu mɔ Kea ‑sa \"kunyɩɔ', ɔmɔ ‑ɔɔ ‑tɩ' 'ma 'tmʋ 'de ao ‑pee. ‑A ‑wee' \"klein nɩɛ ɛɛ' ‑ta 'jeʋn ‑o. ");
INSERT INTO wob_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Ɔ muɛ 'e Kea 'a dianfɔ o, ‑wɛe ɔ 'je ‑Suu ‑ɛɛ ‑tɩ' 'tmʋa sese 'de ɔ \"Bo 'kwa ja. Ɛmɛ ɔ \"jii ‑a 'ʋn ‑wɛe ‑ɛɛ nʋʋdɩ aoa 'jea 'de aoa 'wɔan ‑ta. ");
INSERT INTO wob_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Dafidɩ mɔ se 'e jaʋn 'di mu kpɛ due', 'kaa ɔɔ' ‑cɛ\" wlu' 'wɩ jrɛ' o ka, ɔ 'na : Tʋ\"bo wlu' 'de 'ma Tʋ\"bo ‑pee, ɛ 'na ‑ɩn ‑te i 'de 'ma dianfɔ o, ");
INSERT INTO wob_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","mamaʋ 'sʋ 'ɩn 'je ‑ma tʋnyʋ ‑ma \"kpeinaadɛ 'ʋn nʋ. ");
INSERT INTO wob_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","Israɛ‑kɔʋn ‑wee' \"klein juo 'ɛ 'pepe, Sesi ao kɔa 'o tu ‑kwlɩ\" ‑nɔ, ɔmɔ Kea nʋ Tʋ\"bo ke ɛɛ' 'o ‑tei 'ʋn. ");
INSERT INTO wob_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Ʋʋ 'wɔɔan wlu ‑nɛ 'sʋ, ɛ ‑suua' ʋʋpʋ 'a pɛe i, ‑wɛe ʋʋ wlu ka 'de Piɛi ke dboʋn ‑sia 'e ‑pee ʋʋ 'na : ‑Aa de'di ‑wi\", ka ‑a ‑je nʋ 'ja a‑ ? ");
INSERT INTO wob_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","'Sʋ Piɛi wluɛ ʋʋ ‑pee ɔ 'na : Ao juo aoa' dɛsaʋn \"i, ao 'je 'e Kea o \"biie‑ ‑wɛe ao 'je \"ni \"jru pooɛ due 'due 'de Sesi Klisɩ 'a 'nynɩ 'ʋn ‑wɛe aoa' dɩsaɩn 'je ‑kwɛ‑. 'De ao 'je Kea 'a ‑Suu 'je, ɛmɛ Kea ja ‑wɛe ɛ nʋ ‑a ‑paan' \"jrii, ");
INSERT INTO wob_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Kea cɛn ɛɛ' wlu ‑tie\" sese 'de ao ke aoa' \"nynuu 'a ‑tɩ' 'ʋn, ɛ ke nyʋ \"klein ‑ʋʋ ‑tɛɛan o ke ‑ʋʋa ‑tuu\" ‑aa Tʋ\"bo Kea a mua 'daa' 'de nya ke‑. ");
INSERT INTO wob_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Piɛi 'tmʋɛ wlu ‑tuu\"‑tuu jrɩ' ke'wlɛ 'de ʋʋ ‑pee ‑wɛe ɔ 'je ʋʋpʋ 'a dɩ i kuu, 'de ɔ 'na : Ao 'wɔɔn‑ 'pʋ‑tɩ, ao ke \"manyʋ ‑nʋ 'je i ‑seea'. ");
INSERT INTO wob_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","'De ʋʋ \"klu ɛ, nyʋ ‑tuu\"‑tuu ‑je wlu Piɛi 'tmʋa tɔ' 'ʋn, ‑wɛe ‑ʋʋ ‑poo \"ni \"jru. 'De ɛɛ' 'wɩ tu 'di ɛ, nyʋ ‑ʋʋ ‑kpa 'o klai\" nynuu \"kpei ʋʋ 'bɛɛ‑ ʋʋ 'je nyiɔpʋ 'a \"wlu taan nɩ‑. ");
INSERT INTO wob_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Ʋʋ ‑teɛ 'tɩɩn ‑wɛe ʋʋa po Kea 'a wlu doin\" o 'de dboun 'wɔn jeejee, ʋʋ ‑wee' a poɛ de'diwlʋʋa‑, ʋʋa cɩɩɛn ‑di'pɛn i jejee ʋa jeɛ di ‑wɛe ʋʋa bae Kea 'de nai\" 'blea' 'ʋn. ");
INSERT INTO wob_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Faʋn \"ji 'de ʋʋpʋ 'ʋn 'ɛ due 'due, dɛ‑nʋɛ' nyʋ 'pʋʋ jrii' ke dɩ klae\" ‑tuu\"‑tuu ‑a nʋʋɛ 'bo dboʋn 'a wlui\". ");
INSERT INTO wob_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Nyʋ \"klein ‑ʋʋ ‑jea Sesi 'a ‑tɩ' tɔ' 'ʋn ɛ, ʋʋ ‑wee' 'kɩɩɛn \"jrui ‑tadue, ‑wɛe ʋʋ po ʋʋa' 'bleedɩ ‑wee' \"klein ‑tadue. ");
INSERT INTO wob_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Ʋʋa ple ʋʋa' 'bleedɩ ‑wee' \"klein ke ʋʋa' \"wlii‑ ‑wee' 'mɛ ‑wɛe ʋʋa ‑gble' ɩa' 'wɛi 'ʋn due 'due ka jrɔ' nɩa \"i ɔ 'jea 'je ɛ, 'kamɔ ʋʋa \"nyɩ ɔ. ");
INSERT INTO wob_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Ʋʋa' tɔ' nɩɛ due', ʋʋa 'kɩɩɛn \"jrui 'de Kea ‑gbu klaa\" 'di 'wɩ \"o 'wɩ. ‑Wɛe ʋʋa di Tʋ\"bo 'a diidɛ 'de ʋʋpʋ o ‑gbi\" 'dii. Ʋʋa di ʋʋa' diidɛ 'mɛ 'de 'mʋa‑ ke pɛe 'a \"kpei‑ flɔan' 'ʋn. ");
INSERT INTO wob_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Ʋʋa 'bɛɛ‑ Kea 'a 'nynɩ \"i, ʋʋ nmɔɔ 'e nyʋ ‑wee' \"klein \"jri 'dei, ‑wɛe Tʋ\"bo a nʋɛ 'de 'pʋnyʋ a 'kpa 'de ʋʋpʋ \"klu 'wɩ \"o 'wɩ. ");
INSERT INTO wob_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Piɛi ke San a muɛ 'e Kea ‑gbu klaa\" 'di ‑tadue Kea bae nɔ\", ‑kwie\" jrʋ ‑gbao. ");
INSERT INTO wob_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","'Bo Kea ‑gbu klaa\" 'a ‑gbɛin\" ‑je ʋʋa 'daa‑ \"jriinmɔ‑tua\" ‑pʋn\" ɛ, 'bomɔ ʋʋa ja \"ju due' ‑ɔ ‑wlʋa 'sʋ ‑ɔɔ bɩ 'mɛa, ʋʋa ‑te' ɔ i jeejee, 'de ɔɔ ‑srɔ 'wɛi 'de nyʋ ‑a pa 'e Kea ‑gbu klaa\" 'di o. ");
INSERT INTO wob_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","\"ju ‑nɔ 'jeea Piɛi ke San ʋʋa jia 'e Kea ‑gbu klaa\" 'di paa' \"jriɛ 'sʋ ɔ ‑srɔ ʋʋ ‑pʋ o. ");
INSERT INTO wob_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Piɛi ke San \"sii ɔ \"jriɛ‑, 'sʋ Piɛi 'na : ‑Ɩn ‑gbʋn ‑a ja kea' ! ");
INSERT INTO wob_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","'Sʋ ɔɔ ‑gbʋɛn ʋʋpʋ ja jojo, ɔmɔ 'na ‑mɛ ɔ 'je ʋʋpʋ dɛ 'kwa 'je 'de‑. ");
INSERT INTO wob_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","'Bomɔ Piɛi wlu ɔ ‑pee ka, ɔ 'na : 'Ɩn se 'wɛi ke 'sani 'ble, 'kaa dɛ 'ɩn 'blea ɛmɛ 'ma ji ‑ʋn \"nyɩa'. 'De Sesi Klisɩ ‑wlʋa Nasarɛtɩ 'a 'nynɩ 'ʋn ɛ, ‑ɩn ‑sɔn 'ʋn ‑ɩn ‑je na‑ ! ");
INSERT INTO wob_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Piɛi kpʋɛn ɔɔ' diansʋn 'sʋ, ɔ kpɔ \"jɛi. 'Bo ɛ \"sri \"ju ‑nɔ 'ɔ bɩ ke ɔɔ' klɔsʋɩ\" je 'o \"si. ");
INSERT INTO wob_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","‑Fai 'sʋ ɔ sɔn 'ʋn 'ɛ, ɔ nyna bɩ \"kpei, ‑wɛe ɔ ‑te naa' ‑pʋn\". 'De ɔ ke Piɛi e San pa 'e Kea ‑gbu klaa\" 'di, ɔɔ na', ɔɔ ‑pliin\" ɛ \"jɛi‑ ‑wɛe ɔɔ 'bɛɛ‑ Kea 'a 'nynɩ \"i. ");
INSERT INTO wob_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Nyʋ ‑wee' \"klein 'jeeɔ', ɔɔ na', ɔɔ 'bɛɛ‑ Kea 'a 'nynɩ \"i. ");
INSERT INTO wob_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Ʋʋ juuɔ \"i 'pepe ka ɛ nɩa \"ju ‑ɔɔ ‑tea i 'bo Kea ‑gbu klaa\" 'a wɔn nyʋ a 'daa‑ \"jriinmɔ‑tua\" ‑pʋn\" ‑wɛe ‑ɔɔ ‑srɔa', 'sʋ ɛɛ jiiɛ ʋʋ mian', tai' \"maa' ʋʋpʋ 'mɛ 'de dɛ ‑nʋʋa \"ju ‑nɔ \"jrii 'a ‑tɩ' 'ʋn. ");
INSERT INTO wob_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Ka \"ju ‑nɔ 'nɩa Piɛi ke San ‑pʋn\", nyʋ ‑wee' 'jea kan' 'sʋ ɛɛ' tai' \"maa ʋʋpʋ 'mɛ 'sʋ ʋʋa ple', ʋʋa muɛ 'de ʋʋpʋ o 'de Kea ‑gbu klaa\" 'a 'fɔ ʋʋa 'daa Salomɔ ‑nynɩ ɛ. ");
INSERT INTO wob_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Piɛi 'jea kan' 'sʋ ɔ wlu' 'de nyʋ ‑gbaea' ‑pee ɔ 'na : Israɛ‑kɔʋn, dɛɛ ‑tɩ dɛ ‑nɛ 'ɛ tai' a \"maa aopʋ‑ ɛ‑ ? 'De dɛɛ‑tɩ aoa ‑gbʋn ‑apʋ mɔ ja jojo ɛ‑ ? Nyʋ ‑na ‑apʋ mɔ 'ɔ \"ikmaa' ke ‑aa Kea 'a ‑jei\" naa' mɩ ‑nʋɛ' ‑wɛe \"ju ‑nɔ naa‑ ? ");
INSERT INTO wob_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Kea ‑nɩa Ablaam Ke, Isaakɩ Ke, Sakɔbʋ 'a Kea ‑wɛe ‑ɛ ‑nɩa ‑a \"bo ‑wi\" 'a Kea a, ɛmɛ ‑bɛɛ' ɛɛ' dbonʋi Sesi \"i. Ɔɔ' Sesi tu ɛ, ɔmɔ ao to 'e ‑wɛe ao cɛn wlu \"kpei 'bo Pilatɩ ‑ɔ ‑nɩɛi\" ‑ɔ ‑je ɔ i \"sii‑ \"juɔi. ");
INSERT INTO wob_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","\"Ju ‑ɔ ‑kwɛai ‑wɛe ‑ɔ ‑srɛai\" ɛ, ao 'bɔ ‑mɔ 'mɛ ‑wɛe ao ‑tee' Pilatɩ i 'de ɔ 'e \"ku 'dbai 'saaʋn \"jrii nʋ. ");
INSERT INTO wob_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Ao 'dba \"ju ‑ɔ ‑nɩa 'kmʋnɩa' 'a jei 'mɛ, kaa Kea ‑sɔ 'e 'mɛa' 'ʋn, ‑wɛe ɛ jɔ 'kmʋ de. ‑A ‑wee' \"klein ‑nɩ ‑mɛɛ' ‑ta 'jeʋn. ");
INSERT INTO wob_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","\"Ju ‑nɔ ao juua 'pepe 'de aoa 'jea i ‑ta ɔ 'pʋʋ 'de Sesi 'a 'nynɩ 'ʋn. 'De ɔɔ' 'nynɩ ‑kwlɩ\" ‑tea' mɛ ‑nʋɛ' ‑wɛe ɔ 'ble 'kpɩ 'de ɔ nyna i ‑ta. Sesi ‑kwlɩ\" ‑tea' mɛ ‑nyɩ\" ɔ 'pʋʋa' ‑cɛɛn'‑ 'bo ao ‑wee' \"klein \"juɔi. ");
INSERT INTO wob_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","'De kaan ka la 'jaa‑, 'ma de'di ‑wi\", 'ɩn 'je kan' 'mɛ dɩ \"klein ao ke aoa' klae\" ‑wi\" nʋa tɛin\" ɛ, ao sɩ \"i juo‑. ");
INSERT INTO wob_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","'Kaa Kea nʋ ɩa' dɩ tu 'mɛ ‑wɛe dɩ \"klein ɛɛ' wlu 'kwajaaʋn 'tmʋa sese 'de Nyʋ'pʋʋi 'a 'kle 'je ‑tɩ 'ʋn 'je 'o nyni. ");
INSERT INTO wob_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","‑Jɛ ɛ nɩa kan' ‑mɔ 'ja a, ‑mɛ ao juo aoa' dɩsaɩn \"i, ao \"biie‑ 'de Kea o, ‑wɛe ɛ 'je aoa' dɩsaɩn ‑kɔ'. ");
INSERT INTO wob_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","‑Wɛe aoa' kupeeɛ' 'ʋn ‑tea' 'je 'e Tʋ\"bo o fɔ o 'wlʋ, 'de ɛ 'je Nyʋ 'pʋʋi Sesi ‑ɔɔ ‑tɩ' 'tmʋʋa sese dbo 'de ao ‑pee. ");
INSERT INTO wob_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Ɔmɔ ‑je 'e jaʋn 'di i ‑te mamaʋ 'sʋ ɛ 'e dɩ ‑wee' \"klein 'a 'o nynia' jɛɛ‑ ka Kea 'a ‑cɛ\" 'kpa 'tmʋɛ sese 'de ɛɛ' wlu 'kwajaaʋn 'wɔn ɛ. ");
INSERT INTO wob_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Moisɩ wlu' ka 'de‑ ɔ 'na : Aoa' Kea Tʋ\"bo a muɛ nʋa' ‑wɛe 'de aoa' de 'di‑wi\" \"klu ɛ, ɛɛ' wlu 'kwajaai due' 'je 'e 'wlʋ ‑wɛe ka 'mɔ nɩa ɔ 'je kan' nɩ‑. Dɩ \"klein ɔɔ mua 'tmʋa' a, ao po ɩ doin\" o. ");
INSERT INTO wob_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","'De nyɔ \"o nyɔ ‑sea' wlu Kea jɔɔ 'kwa doin\" o po ɛ, ‑mɛ Kea a mu ɔ i‑saa', ‑wɛe ɔ 'je 'o ɛɛ' 'cɛ 'ɛ ‑kwea' 'wlʋ. ");
INSERT INTO wob_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Kea 'a wlu 'kwajaaʋn ‑wee' \"klein ‑ʋʋ ‑wlua dɛ ‑tba' 'e Samiɛlɩ \"kpei ɛ, ʋʋ ‑wee' 'tmʋ 'wɩ ‑nɩ 'a ‑tɩ' 'mɛ ‑ke. ");
INSERT INTO wob_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Ao nɩɛ Kea 'a wlu 'kwajaaʋn 'a \"nynuu ‑o. Dbɛɛdɛ Kea ke ‑a \"bo ‑wi\" ‑tua\" 'emu tɛin\" 'de ɛɛ' ‑tɩ' 'ʋn ɛ, ɛ wlu' ka 'de Ablaam ‑pee, ɛ 'na : 'De ‑ma \"nynuu‑ 'ʋn ɛ, 'demɔ 'ɩn 'je jii ‑wɛe 'ɩn 'je 'kmʋ ‑wee' \"klein \"diwan po. ");
INSERT INTO wob_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","'Kamɔ Kea nʋ ‑wɛe ɛ ja ɛɛ' dbonʋi 'de ao \"klu tɛin\", ɛ dboɔ' ‑wɛe ɔ 'je ao \"diwan po, 'de ɔ 'je aoa' \"jua‑ 'de dɩsaɩn \"kpei ‑sa due 'due. ");
INSERT INTO wob_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","‑Ta Piɛi ke San nɩa nyʋ ‑pee wlua' 'sʋ 'sraa ‑saʋn o, Kea ‑gbu 'dei ‑tei 'a klae\" o, Sadiseɛn‑wi\" ji'. ");
INSERT INTO wob_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Dɛ Piɛi ke San a tɔɔa nyʋ Sesi 'a ‑tɩ', ‑wɛe ʋʋa 'tmʋa \"kunyɩɔ' sɔn ‑tɩ 'de ɔɔ' 'nynɩ 'ʋn ɛ, ɛ se ʋʋpʋ 'tʋn nʋ. ");
INSERT INTO wob_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","'Sʋ ʋʋ kpʋ ʋʋpʋ sʋn ‑pʋn\" ʋʋ po ʋʋpʋ ‑kaso 'di mamaʋ 'sʋ ‑sɔn' je ‑sɩn', dɛ‑nʋɛ' ‑ta ʋʋa kpʋʋn a ʋʋpʋ ɛ, ‑mɛ kwie kpʋn'. ");
INSERT INTO wob_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","'Kaa wlu ‑tmʋʋa' nyʋ ‑ʋʋ ‑wɔɛn ɛ, ʋʋa' ‑tuu\"‑tuu ‑je ɛ tɔ' 'ʋn, ʋʋ 'kpa \"kpei ʋʋ 'bɛɛ‑ nyʋ 'a \"wlu ‑mm\" 'mɛ. ");
INSERT INTO wob_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","‑Sɔn' ‑sɩan', Suifʋ‑wi\" 'a klae\" o, nyʋ ‑cɔʋn'‑wi\" o, kɛ' wɔ ‑saʋn 'kɩɩɛn \"jrui 'bo Selisalɛm. ");
INSERT INTO wob_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Ʋʋ ke Anɩ, ‑ɔ ‑nɩa 'sraa ‑sai klaa\" ke, Kaifʋ ke, San ke Alɛsandrɩ ke, ɛ ke nyʋ \"klein ‑ʋʋ ‑wlʋa 'e 'sraa ‑saʋn klae\" 'a \"ji 'di ke. ");
INSERT INTO wob_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Ʋʋ kpa Piɛi ke San 'bo ʋʋa' ‑kwea'‑, 'de ʋʋ ‑tee' ʋʋpʋ i, ʋʋ 'na : ‑Ta ao ‑sa \"ikmaa', 'de nyɔ ‑ɔɔ 'nynɩ 'ʋn ao nʋ ɛɛ' dɛ tu ɛ‑ ? ");
INSERT INTO wob_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","'Bomɔ Piɛi Kea 'a ‑Suu \"jia 'e 'ʋn wlu 'de ʋʋ ‑pee ɔ 'na : Aopʋ‑ Suifʋ 'a ‑jeopoʋn ke ʋʋa' nyʋ ‑cɔʋn'‑wi\" ke‑, ");
INSERT INTO wob_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","ka aoa ‑teea' ‑a i 'de ‑sɩanwɩ 'di 'de 'dɔe ‑nʋʋa klɔɔi ‑nɔ \"jrii 'a ‑tɩ' 'ʋn ‑wɛe ka ɔ nʋa 'pʋsʋn ‑a ‑je ɛ 'tmʋ 'de ao ‑pee. ");
INSERT INTO wob_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","Ao ‑wee' \"klein 'wɔɛn 'mii ‑wɛe Israɛ‑kɔʋn 'je ɛ juo‑, 'de Sesi Klisɩ ‑ɔ ‑wlʋa Nasarɛtɩ, ao kɔa 'o tu ‑kwlɩ\" ‑wɛe Kea ‑sa \"kunyɩɔ' ɛ, 'de ɔɔ' 'nynɩ 'ʋn mɔ \"ju ‑nɔ nyna i 'bo aopʋ‑ \"juɔi ‑ta, 'de kui ‑sɔn i flɔan' 'ʋn. ");
INSERT INTO wob_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Wlu ‑crɩɩa' 'de Kea 'a 'sbɛ 'di tɛin\" 'naa : \"Soukpo, ao ‑ɔɔ poa ‑gbu\" poa i ɛ, ‑wɛe ao 'na ɛ se nʋʋdbo 'ble ɛ, ɛmɛ ‑snɛɛ \"soukpo ‑cɛɛn' 'ʋn. ");
INSERT INTO wob_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","'Pʋʋa' se 'e nyɔ \"o nyɔ jrɔ' 'ʋn nɩ‑, ‑bo ɛ se Sesi 'a 'sʋ 'ʋn nɩ ɛ, dɛ‑nʋɛ', Kea se nyɔ deejrɔ' to‑ 'nɔ 'kmʋ \"kpei ‑ɔɔ 'nynɩ 'ʋn nyʋ 'e 'pʋʋa' 'jee‑. ");
INSERT INTO wob_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Ʋʋ 'jea Piɛi ke San 'a wlu 'a ikusʋn 'bo ‑gbajeʋn ‑nʋ \"jɔi tai' \"maa ʋʋpʋ 'mɛ, dɛ‑nʋɛ' ʋʋa 'dʋʋpʋ nyʋ ‑sea' dɛ \"i juo‑ ‑wɛe ‑ʋʋa 'nynɩ nyʋ sea juo ɛ, 'de ka ʋʋ ke Sesi na tɛin\" ɛ, ʋʋ 'je kan' ‑mɔ 'mɛ. ");
INSERT INTO wob_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","'Kaa ʋʋa 'jeɛ \"ju ‑ɔ ‑pʋa i 'bo Piɛi ke San ‑pʋn\", dɛ ʋʋ 'jea 'tmʋ, ɛ se nɩ‑. ");
INSERT INTO wob_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","'Sʋ ʋʋ wlu ɛ ʋʋ ‑pee ʋʋ 'na : Ao 'wlʋ 'nɔ ‑a \"klu ao \"si \"kpae'. 'De ʋʋa' 'sʋ diɛ 'mii 'bo ʋʋa' 'sʋ 'nynɩ ʋʋ 'na : ");
INSERT INTO wob_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","Ka ‑a ‑je nyʋ ‑nʋ 'a ‑tɩ' nʋ ‑gbo' ɛ‑ ? Nyʋ 'pʋʋjrii' ʋʋ nʋa, ɛ se 'ʋn ‑too' ‑ta 'ble Selisalɛm ‑nyʋ ‑wee' juɛ', ‑a se ɛ 'bɛɛ‑ ‑a ‑je ɛ 'kwla ‑tu\". ");
INSERT INTO wob_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","'Kaa ɩa' ‑tɩ' tu 'bo 'blʋa‑ ja ‑kɔɛ, ‑bo ɛ nɩ kan' a, ‑mɛ ‑a ‑kmaa wlu \"i 'de ʋʋ ‑pee, ‑wɛe ‑a ‑je ʋʋpʋ kɛ' \"i ‑te' ʋʋ 'bo Sesi 'a 'nynɩ \"si ke'wlɛ 'de nyɔ jrɔ' ‑pee. ");
INSERT INTO wob_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","'Sʋ ʋʋ 'da Piɛi ke San 'mɛ ke'wlɛ, ‑wɛe ʋʋ ‑te' ʋʋpʋ kɛ' \"i 'de ʋʋ 'na : Nyʋ 'bo Sesi 'a 'nynɩ 'wɔɛn 'de aopʋ 'wɔn, 'de ao 'bo ɔɔ' 'nynɩ \"siiɛ 'de nyɔ jrɔ' ‑pee 'bode. ");
INSERT INTO wob_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","'Bomɔ Piɛi ke San wluu ka ʋʋ 'na : Aoa ‑gbʋn ɛ ja 'ee, ɛ ‑srɛi\" 'mɛ 'bo Kea \"juɔi ‑wɛe nyʋ 'e aomɔ wɔn 'je, ɛ 'e Kea ‑sii ? ");
INSERT INTO wob_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","‑Apʋ mɔ ɛ, dɛ ‑a ‑wɔan 'de ‑a ‑jeea' \"jriɛ‑ ɛ, ‑a se ɛ 'bɛɛ‑ ‑a ‑jɩ wɔn \"muu‑. ");
INSERT INTO wob_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","'Sʋ ʋʋ ‑teɛ ʋʋpʋ kɛ' \"i ke'wlɛ ‑wɛe ʋʋ \"tai‑ ʋʋpʋ \"i 'de nyʋ ‑kwea de \"juɔi, dɛ‑nʋɛ' ka ʋʋ 'jea Piɛi ke San 'a 'pee kpʋʋnsʋn nʋ ‑gblein', 'ka se nɩ‑. 'De dɩ ‑nʋʋa 'mʋa 'a ‑tɩ' 'ʋn nyʋ ‑wee' a 'bɛɛ‑ Kea 'a 'nynɩ \"i. ");
INSERT INTO wob_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","'De \"ju ‑jɔ ‑pʋa 'de jrii' 'ʋn 'mʋa‑, ‑mɔ cɛn ‑sɩn 'a kwla ‑nyiiɛ \"kpei ‑tie\". ");
INSERT INTO wob_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Piɛi ke San \"sia i 'sʋ, ʋʋ mu ɛ 'e ʋʋa' \"dɛi‑wi\" o, ‑wɛe dɩ \"klein 'sraa ‑saʋn 'a klae\" ke nyʋ‑cɔɩn' 'tmʋa ʋʋpʋ ‑pee ɛ, ʋʋ po ɩa' \"kuan. ");
INSERT INTO wob_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Ʋʋ 'wɔan \"kuan ‑nɛ ʋʋ ‑wee' poɛ wlu ‑tadue ‑wɛe ʋʋ bae Kea, ʋʋ 'na : Tʋ\"bo, ɛmɛ ‑nʋa' 'blʋa‑ ke jaʋn ɛ, ‑wɛe ‑ɛ nʋa 'tɔniɛ ke dɩ \"klein ‑nɩa 'nɔ 'kmʋ ɛ, ");
INSERT INTO wob_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","ɛmɛ ‑ɛ ‑nyɩ\" ɛɛ' ‑Suu ‑a 'mɩa Dafidɩ ‑nɩa ɛɛ' dbonʋi, 'de ɛ ‑na : Dɛɛ‑tɩ ‑wɛe 'blʋa‑ ke ‑blʋa nyna ja ‑wɛe tɔ' saɩn inaa 'a 'sʋ \"ji 'de ʋʋpʋ 'ʋn ɛ‑ ? ");
INSERT INTO wob_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","'Beɔ‑wi\" ‑nɩa 'e 'blʋa‑ \"kpei ʋʋ ‑wee' nyna ja ‑wɛe kɛɛma' ‑wee' po kɩɩn ‑ta ‑due 'de Tʋ\"bo ke ɛɛ' \"ju ‑teea kpɔi\" 'a o ‑fɔn' ‑tɩ' 'ʋn. ");
INSERT INTO wob_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","'Kamɔ ɩ nɩ 'de ɛɛ' dbonʋi Sesi ‑ɔ ‑teea kpɔi\" 'a ‑tɩ' 'ʋn. Erodɩ ke Ponsɩ Pilatɩ poɛ kɩɩn ‑ta ‑kwlɔ ‑nɛ 'di ‑wɛe ʋʋ ke nyʋ 'srʋ ke Israɛ‑blʋa blo' wɔn 'bɛɛ‑ wlu 'ʋn. ");
INSERT INTO wob_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Dɛ ɛɛ' ‑cɛ\" 'kpa ‑tea' sese ɛ jea nʋ 'de ɛɛ' ‑kwlʋtɩ 'ʋn ɛ, ɛmɛ ʋʋa nynia 'o mu. ");
INSERT INTO wob_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","kaan ka la 'jaa Tʋ\"bo, ɛ ‑gbʋn 'kle ʋʋa ‑tua\" ɛɛ' \"nynuu‑ ja, 'de ‑apʋ ‑ɔ ‑nɩa ɛɛ' dbonʋʋn ɛ, ɛ je ‑a 'kpɩ \"nyɩ ‑wɛe ‑a ‑je ɛɛ' ‑tɩ' 'tmʋ 'de ‑kwlɩ\" tbaa' 'ʋn. ");
INSERT INTO wob_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Ɛɛ' \"ikmasʋn nɩ ‑a \"kpei ‑wɛe ‑a ‑je nyʋ 'pʋʋ‑ 'de ‑a ‑je jrii' nʋ 'de Sesi ‑ɔ ‑nɩa ɛɛ' dbonʋi ɛ ‑teea kpɔi\" 'a 'nynɩ 'ʋn. ");
INSERT INTO wob_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Ʋʋ ‑kɔa' baea' 'sʋ ɛ, ‑ta ʋʋ 'kɩɩan \"jrui ‑suua' i 'sʋ Kea 'a ‑Suu \"ji 'de ʋʋ ‑wee' \"klein 'ʋn 'ɛ, ‑wɛe ʋʋ ‑te Kea 'a wlu 'tmʋa' ‑pʋn\" 'de ‑kwlɩ\" tbaa' ke pɛe i kua' 'ʋn. ");
INSERT INTO wob_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Nyʋ \"klein ‑ʋʋ ‑jea Sesi 'a ‑tɩ' tɔ' 'ʋn ɛ, ʋʋ ‑wee' \"siiɛ \"i ‑wɛe ʋʋa' tɔ' nɩ due'. Dɛ due' 'blea, ‑mɛ ʋʋ ‑wee' ‑ble ɛ, nyɔ 'ɔ wlu 'de ʋʋpʋ \"klu ɔɔ' nʋ 'ma dɛ. Ʋʋa' dɩ ‑wee' nɩɛ due'. ");
INSERT INTO wob_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Tʋ\"bo 'a dboʋn a 'tmʋ ɔɔ' \"kunyɩɔ' sɔn‑tɩ 'mɛ 'de 'kpɩ 'blea' ke 'diikua' 'ʋn, ‑wɛe Kea 'a 'saaʋn klaa\" nɩ ʋʋ ‑wee' \"klein \"kpei. ");
INSERT INTO wob_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Nyɔ ‑jea 'de ʋʋpʋ \"klu nɩ ‑wɛe dɛ 'jea 'kwa ‑pɔn ɔ se nɩ‑, dɛ‑nʋɛ' nyʋ ‑ʋʋ ‑blea ‑kle' o, nyʋ ‑ʋʋ ‑blea ‑gbi\" o, ʋʋ plɩ ‑wee' 'mɛ. ‑Wɛe ʋʋ ja ɩa' sɔɔn', 'de ʋʋ po ɩ ‑tadue. ");
INSERT INTO wob_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","'De ʋʋa jɩ Sesi 'a dboʋn, ‑wɛe ʋʋa ‑gblɩ' nyʋ \"jrii due 'due ka jrɔ' nɩa \"i ɛ, ɔ 'jea 'je ɛ, 'kamɔ ʋʋa \"nyɩ ɔ. ");
INSERT INTO wob_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","'Kamɔ \"ju due' ‑wlʋa Siprʋ nʋ ‑ke. Ɔɔ' \"ju tu 'a 'nynɩ ‑nɩ Soseʋ ‑wɛe Sesi 'a dboʋn blɔ 'nynɩ \"kpei 'de ʋʋa 'dɔɔ Banabasɩ, ɛ 'de mɛ ‑nɩ nyʋ 'kpɩ \"nyɩi. Ɔ 'wlʋɛ 'e Lefi 'a \"ji 'di. ");
INSERT INTO wob_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Ɔ ple ‑kle' ɔ 'blea 'mɛ ‑wɛe ɔ ja ɛɛ' 'wɛi 'de ɔ \"nyɩ Sesi 'a dboʋn. ");
INSERT INTO wob_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","'Kaa \"ju due' ‑ɔɔ 'nynɩ nɩa Ananiasɩ ɛ, ɔ ke ɔɔ' 'nynɔ Safira pleɛ ʋʋa' ‑kle'. ");
INSERT INTO wob_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","'Sʋ ɔ ‑tuɛ\" ɛɛ' 'jeewɛi 'a tɔo i, ‑wɛe ɔ kpa ɩa' tɔo 'de Sesi 'a dboʋn o, ɔɔ' 'nynɔ juɩ' 'pepe. ");
INSERT INTO wob_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","'Sʋ Piɛi wlu ɔ ‑pee, ɔ 'na : Ananiasɩ, dɛɛ‑tɩ ‑ɩn ‑tai\" nyɔsaʋn \"i ‑wɛe ɔ \"duo ‑ma pɛe ‑wee' 'ʋn kan', 'de ‑ma dii Kea 'a ‑Suu sɩ wɔn ? 'De ‑ɩn ‑te' ‑ma ‑kle' 'a 'jeewɛi 'a tɔo i ɛ‑ ? ");
INSERT INTO wob_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","‑Bo ‑ɩn se ‑ma ‑kle' mɛ ple 'de ɛ, ɛ se ‑ma dɛ nɩ‑ ? 'De ‑bo ‑ɩn pleɛ mɔ 'dee, ɛɛ' 'wɛi se ‑ma ‑tea' ‑tee ? Ka tɔ' saʋn ‑nɛ ‑mɛ nʋ 'e ‑ma pɛe o 'kpasʋn ɛ‑ ? Ɛ se nyiɔ mɔ ‑ɩn ‑dii sɩ wɔn nɩ‑, 'kaa Kea mɛ ‑ɩn ‑dii sɩ wɔn. ");
INSERT INTO wob_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Ananiasɩ 'wɔan wlu ‑nɩ 'sʋ ɛ, ɔ ‑ka i 'bo 'blʋɔ 'sʋ ɔ 'mɛɛ. Nyʋ \"klein ‑jea ɛɛ' ‑ta, faʋn klaa\" 'kpa 'de ʋʋ 'ʋn 'ɛ. ");
INSERT INTO wob_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","‑Kwɩɩ\" mɩɩ\" pla sɔan ʋn 'sʋ ʋʋ \"fin ɔ dɛ \"jrui ‑wɛe ʋʋ kpɔ i nmaea'. ");
INSERT INTO wob_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Nɔ\" 'ɔ \"jri taan ‑sia' 'o mu 'sʋ ɛ, ɔɔ' 'nynɔ pa ‑gbu\", dɛ ‑ɛ ‑nʋʋa ʋ se ɛɛ' jrɛ' 'wɔn. ");
INSERT INTO wob_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Piɛi ‑teeɛ' ʋ i, ɔ 'na : Aoa' ‑kle' ao plea 'ee, ɛɛ' sɔɔn' ‑wee' kaa ? A 'tmʋ ɛ 'de 'ʋn ‑pee. 'Sʋ ʋ 'na : Kɩɩn, ɛɛ' sɔɔn' ‑wee' ‑nao. ");
INSERT INTO wob_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","'Sʋ Piɛi wlu' 'de ʋ ‑pee, ɔ 'na : Ka ao nʋ ‑mɛɛ' wlu 'ʋn 'bɛɛsʋn ‑wɛe aoa ‑tɩn' Tʋ\"bo 'a ‑Suu i ɛ‑ ? A ‑gbʋn 'nɔ, nyʋ ‑ʋʋa ‑wlʋa aa' kʋan i nmaea', ʋʋ ka 'bo ‑gbɛin\" ‑jei\". Ʋʋa ji aʋn kpaa' ‑ke. ");
INSERT INTO wob_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","'Bo ɛ \"sri, ʋ je i ‑ka' 'bo Sesi 'a dboʋn bɩ o, ʋ je 'mɛ. ‑Ta ‑kwɩɩ\" mɩɩ\" ‑nʋ a paa ‑gbu\", ‑mɛ ʋʋ jɛɛ ʋa' \"ku. 'Sʋ ʋʋ kpʋ' ‑wɛe ʋʋ nmae ʋ i 'bo ʋa' kʋan ‑pʋn\". ");
INSERT INTO wob_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Dɛ ‑nʋʋa 'mʋa‑ ɛɛ' faʋn ‑kpa 'e Kea ‑gbu ke nyʋ \"klein ‑ʋʋ ‑wɔan ɛ 'ʋn ɛ, ɛ 'bɛi\". ");
INSERT INTO wob_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Sesi 'a dboʋn a nʋɛ jrii' ‑tuu\"‑tuu 'bo nyʋ 'a ‑kwea'‑, nyʋ ‑ʋʋ ‑jea Sesi 'a ‑tɩ' tɔ' 'ʋn ɛ, ʋʋ nɩɛ ‑tadue 'de Kea ‑gbu klaa\" 'a ‑gbu\" wɔ ʋʋ ‑tuu\" a Salomɔ nynɩ 'di. ");
INSERT INTO wob_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Nyɔ ‑sea' Sesi 'a ‑tɩ' tɔ' 'ʋn 'je ɛ, ‑mɔɔ' 'kpa 'de ʋʋpʋ \"klu, 'kaa nyʋ a 'jeɛ ʋʋpʋ 'a \"dia, ʋʋa poɛ ʋʋpʋ ‑tɩ' o kpleiin. ");
INSERT INTO wob_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Nyʋ ‑ʋʋa ‑jea Tʋ\"bo 'a ‑tɩ' tɔ' 'ʋn a 'kpa \"kpei sɔɔn‑ sɔɔn‑ 'de 'nynʋkpae' ke \"nynunmai 'ʋn. ");
INSERT INTO wob_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","‑Wɛe ʋʋa ja 'wɛnʋʋ ‑tuu\"‑tuu ‑je woi ʋʋa ‑te' jrʋ' i 'bo ʋʋa' \"kpei 'pɛndɛ \"kpei, 'de ʋʋa 'pɛɛn‑ jrʋ' i 'bo srɛ' \"kpei, ‑wɛe ‑bo Piɛi a sea ‑si' ɛ, 'de ɔɔ' ‑fli 'je nyʋ \"kpei crii‑ 'de ʋʋpʋ \"klu. ");
INSERT INTO wob_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Nyiɔpʋ a ‑kwɛ' ‑kwlɛ 'dii ʋʋa jea ji ‑gbli ‑gbli 'bo Selisalɛm ʋʋa ja ʋʋa' nyʋ ‑ʋʋa dɩ a pooa, ɛ ke nyʋ ‑siisaɩn nɩa 'e 'ʋn ke, ‑wɛe ʋʋ ‑wee' \"klein a 'pʋ. ");
INSERT INTO wob_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","'Sraa ‑sai klaa\" ke Sadiseɛn‑wi\" ‑ʋʋ ‑ke ɔ nɩa kpɔi\" ɛ, ‑kwlɛn \"ji 'de ʋʋpʋ 'ʋn 'ɛ 'sʋ ʋʋ 'bɛɛ‑ wlu 'ʋn 'ɛ ‑wɛe ʋʋ 'e Sesi 'a dboʋn sʋn ‑pʋn\" kpa. ");
INSERT INTO wob_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Ʋʋ nynaa ʋʋpʋ i, ‑wɛe ʋʋ po ʋʋpʋ 'de nyʋ ‑wee' \"klein 'a ‑kasogbu 'di. ");
INSERT INTO wob_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","'Kaa Tʋ\"bo 'a \"soai due' ‑ji' \"maʋ\", ‑wɛe ɔ kain ‑kasogbu \"wɔin 'de ‑ɔ ‑sii\" ʋʋpʋ \"kpae' ‑wɛe ‑ɔ ‑wlu 'de ʋʋ ‑pee ‑ɔ ‑na : ");
INSERT INTO wob_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","Ao mu 'e Kea ‑gbu klaa\" 'di ‑wɛe ao 'je 'kmʋ dee nɩa 'a ‑tɩ' ‑wee' 'tmʋ 'de nyʋ ‑pee. ");
INSERT INTO wob_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Sesi 'a dboʋn 'jeɛ wlu ‑nɛ wɔn. ‑Ta ‑sɔn' ‑sɩɩan' ‑mɛ ʋʋ muɛ 'e Kea ‑gbu klaa\" 'di ‑wɛe ʋʋa tɔɔ nyʋ Kea 'a wlu. 'Sraa ‑sai klaa\" ke nyʋ ‑ʋʋ ‑ke ɔ na, ʋʋ 'kɩɩɛn Israɛ 'a nyʋ‑cɔɩn' \"jrui ‑wɛe ʋʋ 'je ‑tɩ' poo‑. 'Sʋ ʋʋ dboɛ nyʋ ‑wɛe ʋʋ mu Sesi 'a dboʋn 'booa' 'de ‑kasogbu 'di. ");
INSERT INTO wob_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","'Kaa nyʋ ʋʋ dboa nynia 'bo ‑kasogbu 'di ɛ, ʋʋ se ʋʋpʋ jɛɛ‑. 'Sʋ ʋʋ muɛ de ‑wɛe ʋʋ po \"kuan. ");
INSERT INTO wob_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","Ʋʋ 'na : ‑Ta ‑aa mua ‑mɛ ‑kasogbu 'a kpae\" ‑wee' kaan \"wɔin, nyʋ ‑ʋʋa fua ‑kasogbu i ɛ, ‑a ‑jɛɛ ʋʋ ‑wee' 'mɛ, 'kaa ‑a ‑kaian 'o ‑gbɛin\" ‑a se nyɔ jrɔ' 'je 'de ɛ 'di. ");
INSERT INTO wob_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Kea ‑gbu 'dei ‑tei 'a klaa\" o, 'sraa ‑saʋn 'a klae\" 'wɔan wlu ‑nɩ ɛ, dɛ ʋʋ 'jea tɔ' \"kpei‑ naa ‑gblein' 'de Sesi 'a dboʋn 'a ‑tɩ' 'ʋn, 'de ‑ta ʋʋ 'jeɛ ‑tu\" ɛ, ʋʋa' 'je ɛ. ");
INSERT INTO wob_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Ʋʋ si ɛ wlua' 'sʋ \"ju due' ji' ɔ 'na : Ao ‑gbʋn 'nɔ, nyɔ ao poa ‑kaso 'di ɛ, ʋʋ nɩɛ 'e Kea ‑gbu klaa\" 'di ‑wɛe ʋʋa tɔɔ nyʋ Kea 'a wlu. ");
INSERT INTO wob_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","'Sʋ Kea ‑gbu 'dei ‑tei 'a klaa\" ke ɔɔ' 'cɛ‑wi\" mu' ‑wɛe ʋʋ 'da Sesi 'a dboʋn wɔɔ. 'Kaa ʋʋ se ʋʋpʋ sʋn ‑pʋn\" kpa, dɛ‑nʋɛ' faʋn a nʋ ʋʋpʋ 'mɛ, ʋʋa pleeɛ' nyʋ je ʋʋ \"soi itbaa‑. ");
INSERT INTO wob_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Ʋʋ ke ʋʋ mua, ʋʋ kpa ʋʋpʋ 'e ‑gbajeʋn \"juɔi ‑wɛe 'sraa ‑sai klaa\" a ‑tee' ʋʋpʋ 'wɔn i ka, ");
INSERT INTO wob_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","ɔ 'na : ‑A se aopʋ kɛ' \"i ‑te' 'de‑ ? ‑A se 'na ao 'bo \"ju ‑nɔ 'ɔ 'nynɩ \"siiɛ 'de nyɔ \"o nyɔ jrɔ' ‑pee ? 'De dɛɛ ‑tɩ aoa nʋ kan', ‑wɛe ao ‑kɔ' Selisalɛm‑kwlɔ ja 'de aoa' nyʋdɛtɔɔa' 'ʋn ɛ‑ ? ‑Aee' aoa ‑pɔn ‑wɛe \"ju ‑nɔ 'ɔ nymɔ 'je 'o ‑a \"jru 'kpaa ? ");
INSERT INTO wob_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Piɛi ke ɔɔ' \"dɛi‑wi\" 'na : Kea mɛ ‑a ‑je wɔn 'je, ɛ 'je nyiɔpʋ ‑sii‑. ");
INSERT INTO wob_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Sesi ao 'dba 'bo tu ‑kwlɩ\" ɛ, ‑a \"bo ‑wi\" 'a Kea jɔ 'kmʋ de. ");
INSERT INTO wob_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Kea kpɔ \"jɛi 'de ɛɛ' dianfɔ o, ɛ nʋɔ ɛɛ' kɛɛma' ju ke Nyʋ 'pʋʋi 'ʋn ‑wɛe ɔ 'e Israɛ‑nyʋ nɔ\" \"nyɩ 'de ʋʋ 'e 'kmʋ fai\" poo‑ 'de ʋʋa' dɩsaɩn 'je ‑kwɛ‑. ");
INSERT INTO wob_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","‑A ‑wee' nɩɛ dɩ ‑nɩa 'mʋa 'a ‑ta 'jeʋn ‑o, ɛ ke Kea 'a ‑Suu ɛ \"nyɩa nyʋ ‑ʋʋa ‑jeɛ wɔn ke. ");
INSERT INTO wob_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","‑Gbajeʋn‑wi\" 'wɔan wlu ‑nɩ 'sʋ ʋʋ 'kpa 'cɛn, 'sʋ ʋʋa ‑pɔn ʋʋ 'je Sesi 'a dboʋn 'kmʋ ‑sa. ");
INSERT INTO wob_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","'Kaa Fariseɛn due' ‑ɔɔ 'nynɩ nɩa Gamaliɛ, ɔ nɩɛ kɛ' wɔ ‑sai ‑o, nyʋ ‑wee' ‑te' ɔ 'e 'wɛ, ɔmɔ ‑sɔn 'ʋn 'bo ‑gbajeʋn 'a ‑kwea'‑, ‑ɔ 'na : Ao \"sii‑ ʋʋpʋ \"kpae' ke dɛ ‑saan\". Ʋʋ \"sia ʋʋpʋ \"kpae' 'sʋ, ");
INSERT INTO wob_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","ɔ wlu' 'de nyʋ ‑gbaea' ‑pee, ɔ 'na : Israɛ‑kɔʋn, ao ‑tu\" aoa' ‑cɛ\" 'ɛ ‑tɩ' 'de dɛ ao 'jea nyʋ ‑nʋ \"jrii nʋ 'a ‑tɩ' 'ʋn. ");
INSERT INTO wob_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Dɛ‑nʋɛ' \"ju due' ʋʋa 'daa‑ Tedasɩ ‑ɔɔ ‑daa' ɔɔ' ‑cɛ\" dɛwɔnɩi ‑wɛe nyiɔpʋ 'a kmɛ' ‑nyiiɛ bla 'o 'de ɛ, ‑ta ɔ jiia 'bo se 'ʋn‑kwle ke, 'kaa ʋʋ 'dbɔ ‑kwlɔi. Nyʋ \"klein ‑bla' 'bo ɔ 'de ɛ, dɛ ʋʋ 'wlʋa 'ʋn ‑a se ɛ juo‑ ‑sɩan, 'nɔ 'kmʋ ti je ka nɩ‑. ");
INSERT INTO wob_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","'Bo ‑mɔ 'de ɛ, \"ju due' ʋʋa 'daa‑ Suida ‑ɔ ‑wlʋa Galile ɛ, ‑mɔ 'wlʋɛ \"blo ke'wlɛ 'nynɩ 'sbɛ 'dipo nɔ\", ‑mɔ ‑criɛ' nyʋ ‑tuu\"‑tuu 'bo ɔ 'de. Ɔ 'mɛa ‑ke ɛ, nyʋ \"klein ‑bla' 'bo ɔ 'de ɛ, ʋʋ ‑wee' cɩɛn \"i 'paɩɩn. ");
INSERT INTO wob_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Kaan ka 'ja a, 'ma 'tmʋʋ aopʋ 'mɛ, ao ‑saa nyʋ ‑nʋ 'a ‑tɩ' kwa ‑sɔn, ao \"tai‑ ʋʋpʋ \"i ʋʋ 'je mu. Ʋʋa' dbo ʋʋa nʋa ‑ta ‑bo ɛ 'wlʋ 'e nyiɔpʋ 'ʋn ɛ, ɛɛ muɛ i sɔan' 'de ɛɛ' ‑cɛ\" ‑pee. ");
INSERT INTO wob_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","'Kaa ‑bo ɛ 'wlʋ 'e Kea 'ʋn ‑cɛɛn'‑, ‑mɛ ao se ɛ 'bɛɛ‑ ao 'je ɛ i ‑sa. Ao ‑tu\" aoa' ‑cɛ\" 'ɛ ‑tɩ' ‑wɛe ao je Kea 'a tʋ o ‑fɔʋn' ʋn 'kpa. ");
INSERT INTO wob_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Dɛ Gamaliɛ 'tmʋa ʋʋ ‑wee' 'wɔɔn‑ 'o 'ɛ. 'Sʋ ʋʋ 'da Sesi 'a dboʋn 'mɛ, ʋʋ kpa ʋʋpʋ klae 'ʋn ‑kpa ‑kpa, ‑wɛe ʋʋ ‑te' ʋʋpʋ kɛ' \"i, ʋʋ 'na : Nyɔ 'bo aopʋ Sesi 'a 'nynɩ 'wɔn 'wɔɛn 'bode ! 'Sʋ ʋʋ \"taiɛ ʋʋpʋ \"i. ");
INSERT INTO wob_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","‑Ta Sesi 'a dboʋn 'wlʋa 'bo ʋʋpʋ \"juɔi ɛ, ʋʋ nɩɛ 'e 'mʋa‑ 'ʋn, dɛ‑nʋɛ' Kea 'a ‑cɛ\" 'kpa 'wɔɔn‑ ɛ, ‑wɛe ʋʋ nɩ 'e 'kle 'di 'de nyʋ a ‑flɛɛn ʋʋpʋ 'de Sesi 'a 'nynɩ 'a ‑tɩ' 'ʋn. ");
INSERT INTO wob_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","'De 'wɩ \"o 'wɩ 'di ɛ, ʋʋa' 'bɔ nyʋ dɛ tɔɔa' ke Sesi Klisɩ 'a ‑pɔia\" ‑tɩ 'a 'tmʋ ‑tɩ 'de Kea ‑gbu klaa\" ke ‑gbi\" 'dii. ");
INSERT INTO wob_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","'De ɛɛ' nɔ\" tu 'di ɛ, klai\" nynuu a 'kpa \"kpei sɔɔn‑ sɔɔn‑. 'De ʋʋpʋ \"klu ɛ, Suifʋ‑wi\" ‑a poa Klɛkɩwlu a wluuɛ Suifʋ‑wi\" ‑blea 'blʋa‑ 'dei, dɛ‑nʋɛ' ʋʋ 'na : ‑Bo diidɩ ‑gble' nɔ\" ɛ, ʋʋa blaa ʋʋa' ‑nɛ ‑tiɔn\" nynʋkpae' 'blʋɔ. ");
INSERT INTO wob_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","'Sʋ dboun ‑nɩa ‑puue 'jɔ 'sɔɔn 'kɩɩɛn klai\" nynuu ‑wee' \"klein \"jrui, ‑wɛe ʋʋ wlu ʋʋpʋ ‑pee ka, ʋʋ 'na : Ɛ se \"isrɛ ‑wɛe ‑a ‑je Kea 'a wlu 'tmʋ ‑tɩ \"i \"tai‑ 'de ‑a ‑je dɛdi ‑sae 'a 'sʋ ‑si'. ");
INSERT INTO wob_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Ɛmɛ ‑tɩ ɛ, ‑aa de'di ‑wi\", ao ‑gbʋn 'e aopʋ \"klu ao 'je nyʋ ‑mɛ\" 'sɔn 'e ‑sa, ‑ʋʋ ‑blea kplɩn 'dɔe, Kea 'a ‑Suu \"jia 'e 'ʋn ‑ʋʋ ‑nɩa tɔ'di, ‑wɛe ‑a ‑je ʋʋpʋ ɛɛ' dbo tu kwa ‑te'. ");
INSERT INTO wob_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","'De ‑apʋ mɔ 'je Kea baea' ke Kea 'a wlu 'tmʋa' nya kpa. ");
INSERT INTO wob_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Dɛ ‑tmʋa' 'mʋa‑, ɛ nʋɛ nyʋ ‑kwea de ‑wee' 'tʋn. 'Sʋ ʋʋ ‑sa 'o Etiɛin. Sesi ‑kwlɩ\" ‑tea' ke Kea 'a ‑Suu \"jia 'e 'ʋn 'ɛ. ‑Wɛe ʋʋ ‑sa 'o Filipʋ o, Plokɔɔ o, Nikanɔɔ o, Timɔ o, Pamenasi o, Nikola ke, ‑mɔ 'wlʋɛ Antiɔsɩ ‑wɛe ɔ nʋ ɔɔ' ‑cɛ\" Suifʋi 'ʋn tɛin\". ");
INSERT INTO wob_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Ʋʋ to ʋʋpʋ Sesi 'a dboʋn \"i, 'de ʋʋ bae ʋʋpʋ 'a Kea ‑wɛe ʋʋ ‑te' ʋʋpʋ kwa \"jru. ");
INSERT INTO wob_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Kea 'a wlu 'tmʋa' a 'kpa \"kpei sɔɔn‑ sɔɔn‑, nyʋ ‑tuu\"‑tuu ‑a ‑je Sesi 'a ‑tɩ' tɔ' 'ʋn, ‑wɛe ‑ʋʋa ‑kpa 'o klai\" nynuu \"kpei 'bo Selisalɛm. 'Sraa ‑saʋn ‑tuu\"‑tuu ‑je Sesi 'a ‑tɩ' tɔ' 'ʋn ‑ke. ");
INSERT INTO wob_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Etiɛin Kea 'a \"diwan ke \"ikmaa' \"jia 'ʋn ɛ, ɔɔ nʋɛ jrii' klae\" klae\" 'de nyʋ \"klu. ");
INSERT INTO wob_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Nyʋ jrʋ' ‑wlʋa 'e Suifʋ‑wi\" 'a \"jrui 'kɩɩn‑gbu ʋʋa 'daa‑ kʋɔnkwla' 'wlʋʋn 'a ‑gbu\" 'di ɛ, ʋʋ ke Etiɛin a ‑tooɛ' ba o. 'De ɛɛ' \"jrui 'kɩɩn‑gbu ‑tu 'di ɛ, nyʋ ‑nɩa 'e ʋʋ ka : Suifʋ‑wi\" ‑wlʋa Sirɛnɩ ke, Suifʋ‑wi\" ‑wlʋa Alɛsandri ke, jrʋ' ‑wlʋa 'e Silisiblʋa \"kpei ke Asi 'a 'blee‑blʋa 'a 'fɔ ‑wee' \"kpei‑ ke. ");
INSERT INTO wob_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","'Kaa ʋʋ se ɔɔ' wɔn 'bɛɛ‑, dɛ‑nʋɛ' ɔɔ wlu' 'de tɔ' 'dinɩa' ke Kea 'a ‑Suu 'ʋn. ");
INSERT INTO wob_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","'Sʋ ʋʋ paa nyʋ ‑sɔn ʋʋ 'na : ‑A ‑wɔn Etiɛin 'a wlu 'mɛ, ɔɔ jea Moisɩ ke Kea wɔn i ‑flɛɛn. ");
INSERT INTO wob_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","'Kamɔ ʋʋ nʋ 'sʋ ʋʋ ‑sa 'blʋa ‑wee' o, nyʋ‑cɔɩn' o, kɛ' wɔ‑saʋn \"blo ‑wɛe ʋʋ 'wla 'e Etiɛin \"kpei, ʋʋ kpʋn ɔ ‑wɛe ʋʋ kpɔ 'e ‑gbajeʋn \"juɔi. ");
INSERT INTO wob_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Ʋʋ nʋɛ sɩ 'tmʋʋn ‑tɩ' 'a ‑ta 'jeʋn 'ʋn ‑wɛe ʋʋ 'na : \"Ju ‑nɔ, ɔɔ ‑flɛɛn ‑ta ‑kwɛai ke Moisɩ 'a kɛ' wɔn i jeejee. ");
INSERT INTO wob_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Dɛ‑nʋɛ' dɛ ‑a ‑wɔan 'de ɔ 'wɔn, ɛmɛ ka Sesi ‑wlʋa Nasarɛtɩ ɛ, Kea 'a kɛ' ɛ jaa Moisɩ 'kwa ‑wɛe ɛ \"nyɩ ‑aʋn, ɔmɔ ‑je ɛ fai\" poo‑, 'de ‑ɔ ‑je Kea ‑gbu 'wla. ");
INSERT INTO wob_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","'Sʋ ‑gbajeʋn ‑wee' \"klein \"siiɛ Etiɛin \"jriɛ‑, 'kaa ɔɔ' \"jua a fan' 'de ʋʋpʋ \"jri 'de, ka Kea 'a \"soai 'a \"jua‑ nɩa. ");
INSERT INTO wob_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","'Sraa ‑sai klaa\" ‑tee' ɔ i ɔ 'na : 'Kamɔ ɩ nɩ ‑cɛɛn'‑ ? ");
INSERT INTO wob_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","'Bomɔ Etiɛin \"duo wlu 'ʋn ɔ 'na : Ao ‑nɩa 'ma de 'di‑wi\", ‑ɔ ‑nɩa 'ʋn \"bo ‑wi\", ao po 'ma wlu doin\" o ! Tɛin\" sese, ‑aa Kea ‑ɛɛ 'nynɩ 'bɛa \"i ɛ, ɛ to ɛɛ' ‑cɛ\" 'mɛ 'de ‑a \"bo Ablaam ‑pee 'de Mesopotamiblʋa \"kpei, ‑wɛe ɔɔ jea 'e Karan \"tia' ji. Ɛ wlu ɔ ‑pee ɛ 'na : ");
INSERT INTO wob_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","‑Ɩn ‑wlʋ 'nɔ ‑ma \"bliblʋa 'di ‑ɩn \"bli ‑gbu ‑sɔn, ‑wɛe ‑ɩn ‑je 'e 'blʋa‑ 'ma mua ‑ʋn tɔɔa' 'di mu. ");
INSERT INTO wob_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","'Sʋ ɔ 'wlʋ 'e Kalde‑kɔʋn 'a 'blʋa‑ \"kpei 'mɛ, ‑wɛe ɔ mu 'de ɔ \"ti 'o Karan. 'Bomɔ ɔ \"bo 'mɛɛ, ‑wɛe Kea jɔ 'nɔ 'blʋa‑ ‑ɛ 'di ‑a ‑tia\" ‑ta ‑sɩan \"kpei. ");
INSERT INTO wob_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Ɛ se ɔ ‑teɩn dɛ‑saan\" ka \"nyɩ 'nɔ 'blʋa‑ ‑nɛ \"kpei, ‑wɛe ‑ta ɔ 'jea \"jru 'wlaa‑ mɔ'ɔ ‑tɩ'. 'kaa ɛ cɛn wlu ‑tie\", ɛ 'na : 'blʋa‑ ‑nɛ, ɛ nɩɛ ɔ ke ɔɔ' \"nynuu 'a dɛ ‑o, 'de ‑mɛ 'kamɔ ɔ se \"ju 'ble ke 'de ɛɛ' nɔ\" tu 'di. ");
INSERT INTO wob_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Kea wlu ɔ ‑pee ka, ɛ 'na : ‑Ma \"nynuu‑ a muɛ kʋɔnkwla' muua' 'de 'blʋa‑ 'srʋ \"kpei, ʋʋa muɛ kʋɔnpʋ‑ nɩa' ‑wɛe nyʋ 'e ʋʋpʋ 'kwa nynii‑ 'de ‑sɩn 'a kmɛ' ‑nyiiɛ 'di. ");
INSERT INTO wob_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","'Kaa Kea 'na nyʋ ‑ʋʋ ‑jea ʋʋpʋ kʋɔn 'ʋn 'ble ɛ, ɛɛ' 'pee a muɛ ʋʋpʋ kpʋn 'a. ‑Bo ‑mɛ 'wlʋ 'o ‑jei\" ɛ, ʋʋa muɛ 'e ɛɛ' 'blʋa‑ tu \"kpei 'wlʋa' ‑wɛe ʋʋ 'je 'e 'blʋa‑ ‑nɛ \"kpei ji 'de ʋʋ 'je ɛ ‑gbɛɛ'‑. ");
INSERT INTO wob_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","'Sʋ Kea ke Ablaam ‑tu\" 'e dbɛɛdɛ. Ɛɛ' dbɛɛdɛ tu 'a juo 'ɩn ‑nɩ 'klɛn mua'. 'Kamɔ ɛ nɩ ‑wɛe Ablaam 'wlʋ Isaakɩ 'de ɔ kpɔ 'klɛn 'bo 'wɩ ‑mɛ\" na ‑nɩ \"kpei. 'De Isaakɩ 'wlʋ Sakɔbʋ 'de ɔ kpɔ 'klɛn, ‑wɛe Sakɔbʋ 'wlʋ \"nynuu 'a ‑puue 'jɔ 'sɔɔn, ʋʋpʋ ‑nɩ ‑a \"bo ‑wi\". ");
INSERT INTO wob_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","‑A \"bo ‑wi\" nʋa Soseʋ ‑kwlɛn o ɛ, ʋʋ pleɔ' ‑wɛe ɔ mu 'de Esipʋ‑blʋa \"kpei. ");
INSERT INTO wob_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","'Kaa Kea ke ɔ na' ‑wɛe ɛ seie ɔ 'de 'kle ke ‑cɛ\" wɔn 'jea' \"klein 'kwa, ɛ \"nyɩ ɔ tɔ' ‑wɛe ɛ nʋɛ 'de ɔ nmɔɔ Esipʋ‑blʋa 'a 'bɩɔ Faraɔn \"jri 'dei. ‑Mɔɔ' 'beɔ tu ‑teɛ ɔɔ' 'blʋa‑ ke ɔɔ' ‑gbu\" Soseʋ kwa ‑wɛe ɔɔ po ɩ ‑je o. ");
INSERT INTO wob_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","'Sʋ 'mɩɩɛ‑ ‑teɛ jia' ‑pʋn\" 'de Esipʋ‑blʋa ke Kananblʋa ‑wee' \"klein \"kpei. Ɛɛ' 'kle klaa\" jiɛ nyʋ ‑wee' \"kpei, ‑wɛe ‑ta ‑a \"bo ‑wi\" 'jea dɛ ‑sa ʋʋ 'jea di, 'bo se nɩ‑. ");
INSERT INTO wob_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Sakɔbʋ 'wɔan diidɛ 'ɛ 'nynɩ 'de Esipʋ‑blʋa \"kpei 'sʋ ɛ, ɔ dbo 'e ‑a \"bo ‑wi\" 'mɛ \"i‑saa nɔ\". ");
INSERT INTO wob_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","'De ɛɛ' kpɛ 'sɔɔn ‑nɛ \"kpei ɛ, Soseʋ 'a de'di ‑wi\" juuo ɔ \"i, ‑wɛe Faraɔn juuo Soseʋ 'a ‑gbu\" ‑sɔn nyʋ. ");
INSERT INTO wob_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","'Sʋ Soseʋ dboɛ nyʋ ‑wɛe ʋʋ mu ɔ \"bo Sakɔbʋ ‑jei\", ɛ ke ɔɔ' ‑gbu\" ‑sɔn nyʋ ‑ʋʋ ‑nɩa kwla ‑mɛ\" 'sɔn 'jɔ ‑mm\" ke. ");
INSERT INTO wob_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Sakɔbʋ mua 'e Esipʋ ɛ, 'demɔ ɔ 'mɛɛ, 'demɔ ‑a \"bo ‑wi\" ‑wee' 'mɛɛ ‑ke. ");
INSERT INTO wob_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Ʋʋ \"duo‑ ʋʋpʋ 'a 'kpɩ 'ʋn 'ɛ ‑wɛe ʋʋ kpa ʋʋpʋ 'bo Sisɛm ‑wɛe ʋʋ nmae ʋʋpʋ i 'de ‑gba 'ɩn Ablaam ja 'wɛi ‑wɛe ɔ ‑tɩan' 'de Emɔɔ 'ɔ \"nynuu‑ 'kwa 'bo Sisɛm 'di. ");
INSERT INTO wob_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","‑Ta dɩ Kea \"sia 'nynɩ 'de Ablaam ‑pee ɩa' 'o nyni nɔ\" ɔ \"kʋʋan i ɛ, ‑mɛ ‑a \"bo ‑wi\" 'a \"i ‑tiesʋn a 'kpa \"kpei sɔɔn‑ sɔɔn‑ 'de Esipʋ‑blʋa \"kpei. ");
INSERT INTO wob_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","'Sʋ Esipʋ‑blʋa 'a 'bɩɔ dee ‑kpao' se Soseʋ juo‑. ");
INSERT INTO wob_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Ɔɔ' 'beɔ tu toɛ ‑a \"bo ‑wi\" dɛ \"i ‑to ‑to, ɔ pooɛ ʋʋpʋ 'srɛ i, ɔɔ kpʋn ʋʋpʋ klaan\" ‑klan klaan\" ‑wɛe ʋʋ 'je ʋʋa' \"nynupliiɛ i po 'de ʋʋ 'je 'mɛ. ");
INSERT INTO wob_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","'De ɛɛ' nɔ\" tu 'di 'bomɔ Moisɩ 'wlʋʋ‑. Ɔɔ' \"jupliiɛ ‑nɛ nmɔɔ 'e Kea \"jri 'dei. Ɔ \"bo ke de‑wi\" ‑gbɔɔn' 'de 'cʋɩ taan 'di. ");
INSERT INTO wob_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","‑Ta ʋʋ poo ɔ i ɛ, 'bomɔ Faraɔn 'a \"junynɔkpao' \"duɔ 'ʋn ‑wɛe ʋ ‑gbɔɔn' ka ʋa' \"ju nɩa. ");
INSERT INTO wob_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Moisɩ 'cɩan Esipʋ‑kɔʋn 'a tɔ' ke ʋʋa' kplɩn ‑wee' \"klein 'mɛ, ɔ jɩ juo‑. Ɔ kmai\" 'de ɔɔ' wlu ke ɔɔ' nʋʋdɩ 'ʋn. ");
INSERT INTO wob_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","‑Ta ɔ 'blea ‑sɩn 'a kwla ‑nyiiɛ 'sʋ, Moisɩ 'a de 'di‑wi\" Israɛ‑kɔʋn 'a \"i ‑teea' 'kpa 'bo ɔ ‑kwlɩ\". ");
INSERT INTO wob_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","‑Ta ɔɔ mua, ‑mɛ Esipʋi due' nɩɛ ɔɔ' de'di ‑wi\" 'a due' blaa' 'sʋ ɔ 'wlʋɛ ɔɔ' de'di o, ‑wɛe ɔ 'dba Esipʋi. ");
INSERT INTO wob_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Ɔ naa tɔ' i 'de ɛ, ɔmɔ 'na ‑mɛ ɔɔ' de'di ‑wi\" 'je ɛ 'mii 'wɔn 'de‑ ka Kea nɩa \"i ɛ 'jea ʋʋpʋ seie 'de ɔɔ' sʋn 'ʋn ɛ, 'kaa ʋʋ se ɛ 'mii 'wɔn. ");
INSERT INTO wob_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","‑Sɔn' jrɛ' ‑sɩan' 'sʋ ɛ, nyʋ 'sɔɔn ‑cɛ' 'de Israɛ‑kɔʋn \"klu, ‑wɛe ɔɔ ‑tu\" ʋʋpʋ 'snɩ ‑wɛe ʋʋ 'je ‑cɛ' ‑tɩ 'bɔ. Ɔ 'na : 'Ma de 'di‑wi\", dɛɛ ‑tɩ aoa' 'sʋ a ‑cɛ' ɛ‑ ? Ao nɩɛ de 'di‑wi\" 'a 'sʋ ‑o. ");
INSERT INTO wob_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","'Kaa ‑jɔ ‑ɔɔ ‑bla ɔɔ' de'di ‑nɔ ‑fuuɛn Moisɩ nya, ɔ 'na : ‑Ɔ po ‑ʋn 'bomu ‑wɛe ‑ma ‑je ‑aa 'pee ɛ‑ ? ");
INSERT INTO wob_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","‑Aee' ‑ɩn ‑nɩɛi\" ‑ɩn ‑je 'ʋn 'dba, ka ‑ɩn ‑dba Esipʋi ‑kwie\"‑ ɛɛ ? ");
INSERT INTO wob_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Ɔ 'tmʋa wlu ‑nɛ 'sʋ Moisɩ 'kpa 'kwla, ɔ muɛ 'e Madian‑wi\" 'a 'blʋa‑ 'di, 'demɔ ɔ 'wlʋʋ‑ \"nynuu‑ 'sɔɔn. ");
INSERT INTO wob_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","Ɔ nʋɛ 'e ‑sɩn 'a kwla ‑nyiiɛ. ‑Ta ɔ mua 'e Sinai crʋ ‑kwlɩ\" 'de ‑pɩɩɔn\" blʋa \"kpei ɛ, 'bomɔ Kea 'a \"soai due' nɩ 'e ‑gbauo ‑ɛɛ wan 'di. ");
INSERT INTO wob_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Moisɩ 'jea ɛɛ' dɛ tu 'sʋ ɛ, ɛ \"maa ɔ tai', 'sʋ ɔɔ 'kpa 'bo ɛ ‑pʋn\" ‑wɛe ɔ 'je ɛ ja ‑gbʋn, 'sʋ ɔ 'wɔn Kea 'a wlu ‑ɛ ‑na : ");
INSERT INTO wob_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","'Ɩn nɩɛ ‑ɩn \"bo ‑wi\" 'a Kea ‑o, Ablaam ke Isaakɩ ke Sakɔbʋ 'a Kea ‑o. 'Sʋ Moisɩ 'a dɩ a crɛ', ɔ se ‑ɩn kpa \"jua‑ \"jɛi ‑wɛe ‑gbʋn 'o 'bɛɛ‑. ");
INSERT INTO wob_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","'Sʋ Tʋ\"bo wlu ɔ ‑pee ɛ 'na : ‑Ɩn ‑sa ‑ma \"kwlai‑ bɩ', dɛ‑nʋɛ' 'blʋa‑ ‑ɩn ‑nyna \"kpei ɛɛ' 'blʋa‑ tu ‑kwɛ‑ i 'pepe. ");
INSERT INTO wob_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","'Kle 'ma 'cɛ‑wi\" a 'jea 'de Esipʋ‑blʋa \"kpei ɛ, 'ɩn 'jeeɛ', 'ɩn 'wɔn ʋʋpʋ 'a ‑fɩn\" wlu 'mɛ, ‑wɛe 'ɩn \"sii 'de 'ɩn 'je ʋʋpʋ seie‑. ‑Ɩn ji la ‑wɛe 'ɩn 'je ‑ʋn dbo 'de Esipʋ. ");
INSERT INTO wob_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","Moisɩ ʋʋ ‑flɛɛan 'de ɛ, ‑wɛe ʋʋ 'na ‑ɔ ‑te' 'o ‑ʋn 'de ‑ɩn ‑je ‑aa 'ble i ke ‑aa 'pee 'jei nɩ ɛ‑ ? Ɔmɔ Kea dbo ‑wɛe ‑ɔ ‑je ʋʋa' ‑jeopoi ke ʋʋa' ‑seiei nɩ‑. Kea 'a \"soai ‑ɔ ‑wlua Moisɩ ‑pee 'de nɛ‑gbauo 'di ɛ, ɔmɔ ‑je ɔ sʋn o po. ");
INSERT INTO wob_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Moisɩ ‑nɔ mɔ ‑sa Israɛ‑kɔʋn kʋɔnkwla' 'de Esipʋ, ‑wɛe ‑ɔ nʋ jrii' ke dɩ ‑tuu\"‑tuu 'de ɛɛ' 'blʋa‑ tu 'di, ɔ nʋ jrɩ' 'bo 'tɔniɛ ‑saan wɔn, ɛ ke 'de ‑pɩɩɔn\" blʋa \"kpei ke 'de ‑sɩn 'a kwla ‑nyiiɛ 'di ke‑. ");
INSERT INTO wob_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Moisɩ due' ‑nɔ ‑wlu' 'de Israɛ‑kɔʋn ‑pee ‑wɛe ‑ɔ ‑na : Kea a muɛ nʋa' ɛɛ' wlu 'kwajaai due' 'je 'wlʋ ka 'ɩn nɩa ɔ 'je kan nɩ 'de ɛ 'jeɔ dbo. ");
INSERT INTO wob_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Moisɩ ‑nɔ mɔ ‑nɩ 'o Israɛ‑kɔʋn ‑pʋn\" 'de ‑pɩɩɔn\" blʋa \"kpei, ɔ ke ‑a \"bo ‑wi\" a na ‑wɛe Kea 'a \"soai a jɔɔ wlu 'kwa 'de Sinaicrʋ \"kpei, ɔmɔ ‑ɔɔ ‑wɔn Kea 'a 'kmʋnɩ wlu ‑wɛe ‑ɔɔ ‑tmʋ ɩ 'de ‑a ‑pee. ");
INSERT INTO wob_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","‑A \"bo ‑wi\" se ɔɔ' wɔn 'je ‑tɩ 'wɔɔn‑, ʋʋ ‑fuun ɔ nya ‑wɛe ʋʋ \"biie‑ ʋʋa' pɛe 'de Esipʋ‑blʋa \"kpei de, ‑wɛe ʋʋ wlu 'de Aarɔn ‑pee ʋʋ 'na : ");
INSERT INTO wob_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","‑Ɩn ma ‑aa ‑kɩɩ'‑ jrɩ' ‑a ‑jɩ \"jriɛ‑ 'jee‑, ‑wɛe nyɔ 'jɩ 'ble 'bo ‑a \"juɔi, dɛ‑nʋɛ' Moisɩ ‑ɔ ‑sa ‑aʋn 'de Esipʋ‑blʋa \"kpei ‑ta, dɛ ɔ ‑snɛɛa 'ʋn, ‑a se ɛ juo‑. ");
INSERT INTO wob_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","'Sʋ 'de ɛɛ' 'wɩ tu 'di ɛ, ʋʋ nʋɛ bli' ‑kea'‑ ʋʋa ‑sa' 'sraa‑ ‑pee, 'de ʋʋa nʋ 'mʋa‑ 'bo ʋʋa' ‑cɛ\" 'kpa 'a sʋn 'a nʋʋdɩ \"juɔi. ");
INSERT INTO wob_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","'Sʋ Kea ‑sa ʋʋpʋ \"jriɛ‑ ‑pʋn\", ‑wɛe ɛ \"tai‑ ʋʋpʋ \"i, 'de ʋʋ ‑te dɩ ‑nɩa 'e jaʋn 'di 'a \"juɔi ‑gbɛɛa' ‑pʋn\". Ka ɛ 'crɩɩa 'de Kea 'a wlu 'kwajaaʋn 'a 'sbɛ 'di ɛ, ɛ 'na : Israɛ‑kɔʋn, ɛ 'mɔ ao ‑saa nmi 'sraa‑ 'ʋn ao \"nyɩ 'de ‑sɩn 'a kwla ‑nyiiɛ 'di 'de ‑pɩɩɔn\" blʋa \"kpeii ? ");
INSERT INTO wob_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Ɛ se kɔun ‑ɛɛ 'nynɩ nɩa Molɔkɩ, ɛmɛ ‑ɛɛ ‑tan 'tanfɔ ao se \"jɛi po ‑wɛe aoa sea blee, ɛ ke 'cʋ‑sɩɩn 'a ‑kɔun Refan ao se ma aoa sea ‑kɩɩ' a 'daa, ‑wɛe aoa sea \"juɔi ‑gbɛɛ' ? Ɛmɛ ‑tɩ 'ma mu ao kʋɔnkwla' kpaa' 'de Babilɔnɩ‑kwlɔ 'de. ");
INSERT INTO wob_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","‑A \"bo ‑wi\" 'bleɛ ‑tan 'tanfɔ ‑ɛɛ ‑poo kɛ' ‑gbau \"jrui 'bo ‑pɩɩɔn\" blʋa \"kpei, 'de ɛ ‑nɩ Kea ‑gbu klaa\" 'a ‑sii, ɛɛ nʋʋɛ ka Kea \"sia 'nynɩ 'de Moisɩ ‑pee ɛ. Ɛ wlu' 'de Moisɩ ‑pee ka 'de‑, ɛ 'na : Ka ‑jɛ ‑ɩn ‑jeea \"jriɛ‑ nɩa, 'kamɔ ‑ɩn ‑je ɛ nʋ. ");
INSERT INTO wob_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Ɛɛ' ‑tan 'tanfɔ tu jiiɛ ‑a \"bo ‑wi\" 'kwai mamaʋ 'sʋ ɛ je Sosue jɛɛ‑. Ɔmɔ ‑paa ɛ 'de nyʋ jrʋ' Kea nʋa i 'de ʋʋpʋ \"juɔi 'a 'blʋa‑ 'di, ‑wɛe ɛ ‑te i 'demu mamaʋ 'sʋ ɛ jɛɛ Dafidɩ 'a nɔ\". ");
INSERT INTO wob_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Dafidɩ nmɔɔɛ 'e Kea \"jri 'dei, ɔ ‑tee' ɛ i 'de ɔ 'je Sakɔbʋ 'a Kea 'a ‑gbu\" po. ");
INSERT INTO wob_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","'Kaa ɔɔ' \"ju Salomɔ mɔ ‑po' ɛɛ' ‑gbu\". ");
INSERT INTO wob_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","'De ‑mɛ 'kamɔ Kea ‑nɩa 'e jaʋn 'di ɛɛ' \"ti 'de nyiɔ 'ɔ poo‑gbu 'di, ka ɛ 'tmʋʋa 'de Kea 'a wlu 'kwajaai 'a 'sbɛ 'di ɛ : ");
INSERT INTO wob_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","Tʋ\"bo 'na : Jaʋn mɛ ‑nɩ 'ma 'beɔkpa‑tɛ, ‑wɛe 'blʋa‑ nɩ 'ma bɩ \"kpei ‑te ‑dɛ. ‑Mɛ ‑gbu\" ‑jɛwɛ‑ ao 'je po ‑wɛe ao 'je 'ʋn \"nyɩ ɛ‑ ? 'De ‑tawɛ‑ aomɔ 'je 'ʋn \"nyɩ ‑wɛe 'ɩn 'je \"jru 'wlaa a‑ ? ");
INSERT INTO wob_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","'Ma sʋn mɛ ‑se' dɩ ‑nɩa 'mʋa‑ ‑wee' \"klein nʋʋ ? ");
INSERT INTO wob_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","'Oo, ao \"jrukuʋn 'a ti, ‑ɔɔ pɛe kmuai\" ‑wɛe ‑ɔɔ doin\" \"suan 'de Kea 'a ‑Suu 'a wlu 'a 'wɔn ‑tɩ 'ʋn ɛ, aoa ‑fɔn' Kea 'a ‑Suu o jeejee. Dɛ ao \"bo ‑wi\" nɩa 'ʋn 'de ɛ, ɛmɛ aopʋ nɩ 'ʋn ‑ke. ");
INSERT INTO wob_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Kea 'a wlu 'kwajaai ‑jɔwɛ‑ ao \"bo ‑wi\" se 'kle ‑tu\" ɛ‑ ? Nyʋ ‑ʋʋ ‑tmʋa \"ju ‑ɔ ‑srɛai\" 'a ji ‑tɩ ɛ, ʋʋ 'dba ʋʋpʋ 'mɛ, ɔɔ' \"ju tu mɔ aopʋ‑ to 'e ‑wɛe ‑ɔɔ 'dbaʋn ao 'kpa. ");
INSERT INTO wob_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Aopʋ‑ Kea' jaa ɛɛ' \"sʋɩ kɛ' 'kwa ɛ \"nyɩa, ‑wɛe ‑ɔ sea ‑mɛɛ' kɛ' tu wɔn 'je ɛ, aopʋ‑. ");
INSERT INTO wob_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Ʋʋ 'wɔan wlu ‑nɛ 'sʋ ʋʋ 'kpa 'cɛn, ʋʋa diiɛ 'nynɩ \"i 'de Etiɛin ‑pee. ");
INSERT INTO wob_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","'kaa Etiɛin ‑mɔ ɛ Kea 'a ‑Suu \"jiɔ 'ʋn 'ɛ, ‑wɛe ɔɔ ‑gbʋn 'e jaʋn ‑kwlʋ jojo, 'sʋ ɔ 'jeɛ Kea 'a tʋ\"bodɛ i, ‑wɛe Sesi nyna i 'de Kea 'a dianfɔ o. ");
INSERT INTO wob_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","'Sʋ ɔ 'na : Ao ‑gbʋn 'nɔ, jaʋn 'ma 'jea i ɛ, ɩ kaiɛn wɔn, ‑wɛe nyiɔ 'ɔ \"Ju nyna i 'de Kea 'a dianfɔ o. ");
INSERT INTO wob_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","'Sʋ ʋʋ ‑saa \"wɔ ‑cruɛn\", ʋʋ \"suɛn ‑cɩɩ doun\" ‑wɛe ʋʋ ‑wee' \"klein bluu ɔ \"kpei ‑tadue. ");
INSERT INTO wob_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","'De ʋʋ 'klɔ i, ʋʋ ‑sɔ 'o ‑kwlɔ, ‑wɛe ʋʋa tbɔɔ \"soi i. Nyʋ ‑jea ɛɛ' ‑ta ‑teɛ' ʋʋa' 'ʋnpaadɩ i 'bo ‑kooai\" ‑saan\" due' ‑ɔɔ 'nynɩ nɩa Sɔo ‑pʋn\". ");
INSERT INTO wob_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","‑Ta ʋʋa tbaa Etiɛin \"soi i ɛ, ‑mɛ ɔɔ bae', ɔ 'na : Tʋ\"bo Sesi, ‑ɩn ‑kpʋʋn 'ma ‑suu sɩn 'sɔɔn. ");
INSERT INTO wob_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","'Sʋ ɔ poɛ 'kɔi‑ ‑klu' ‑wɛe ɔ \"wɔ kpleiin, ɔ 'na : Tʋ\"bo, dɛ ʋʋ nʋa ‑ta ‑ɩn ‑bo ɛ ‑sroɛ' 'bo ʋʋpʋ \"jru. Ɔ 'tmʋa wlu ‑nɩ 'sʋ ɛ, ɔ 'mɛɛ. ");
INSERT INTO wob_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Sɔo poɛ Etiɛin 'a 'dbaʋn ‑tɩ' o. 'De ɛɛ' 'wɩ tu 'di mɔ 'kle klaa\" ‑jia' Kea ‑gbu \"kpei 'bo Selisalɛm ‑tee ‑wɛe nyʋ ‑jea Sesi 'a ‑tɩ' tɔ' 'ʋn ‑wee' ‑gba' ja 'de ʋʋ mu Suideblʋa o, Samadiblʋa \"kpei. Sesi 'a dboʋn 'a 'sʋ sie 'o Selisalɛm. ");
INSERT INTO wob_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Kea 'a ‑jei\" naaʋn mʋ ‑ji' ‑wɛe ‑ʋʋ ‑nmae Etiɛin i, ‑ʋʋ pa ɔɔ' 'kwɛ‑ 'de ‑ʋʋ ‑fɩn\" ɔ kplein. ");
INSERT INTO wob_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Sɔo ‑mɔ ɛ, ɔɔ ‑sa' Kea ‑gbu i, 'sʋ ɔɔ jea 'ʋn ‑sii'. Ɔɔ pa ‑gbi\" 'dii ‑wɛe ɔɔ kpʋn 'nynʋkpae' ke \"nynunmai 'de ɔɔ po ʋʋpʋ ‑kaso 'di. ");
INSERT INTO wob_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Nyʋ ‑ʋʋ ‑gbaa dɩ 'mii ɛ, ʋʋa muɛ ‑ta \"o ‑ta ‑wɛe ʋʋa 'tmʋ ‑pɔia\" ‑tɩ. ");
INSERT INTO wob_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Filipʋ muɛ 'e Samadi blʋa 'a ‑kwlɔ due' 'di, ‑wɛe ɔ 'tmʋ Klisɩ 'a ‑tɩ' 'bomu. ");
INSERT INTO wob_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Nyʋ ‑tuu\"‑tuu ‑kɩɩan' \"jrui ɛ, ʋʋa poɛ dɛ Filipʋ a 'tmʋa doin\" o ‑snii', ‑wɛe ʋʋa 'jee jrii' ɔɔ nʋa \"jriɛ‑ ‑ke. ");
INSERT INTO wob_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Dɛ‑nʋɛ' ‑siisaɩn ‑wlʋ 'e 'wɛnʋʋ ‑tuu\"‑tuu 'ʋn 'de \"wɔɔa' 'ʋn, ‑wɛe klɔɔʋn ‑tuu\"‑tuu ke 'tooʋn a 'pʋ. ");
INSERT INTO wob_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","'Sʋ 'mʋa‑cruɛn\" klaa\" 'kpaa 'bo ɛɛ' ‑kwlɔ tu 'di. ");
INSERT INTO wob_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","'De \"ju due' ‑nɩ 'bo ɛɛ' ‑kwlɔ ‑tu 'di see, ʋʋa 'dɔɔ Simɔ, ɔɔ 'daa ɔɔ' ‑cɛ\" dɛwɔnɩ i. 'De ɔɔ' jrii' ɔɔ nʋa 'a ‑tɩ' 'ʋn ɛ, ɔɔ \"maa nyʋ ‑nɩa 'o Samadi ‑wee' tai'. ");
INSERT INTO wob_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Mɩɩ\" ke klae\" ‑wee' a poɛ ɔɔ' wlu doin\" o ‑snii' see ‑wɛe ʋʋa wlu ka : \"Ju ‑nɔ ‑mɔ 'bleɛ Kea 'a \"ikmaa' nyʋ a 'daa \"ikmaa' klaa\" a. ");
INSERT INTO wob_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Ʋʋ ‑wee' a po ɔɔ' wlu doin\" o ‑snii', dɛ‑nʋɛ' ɔ ‑kwle ʋʋa' tai' \"maa' 'mɛ 'de ɔɔ' jrii' 'ʋn. ");
INSERT INTO wob_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","'Kaa ʋʋ 'wɔan Filipʋ 'a wlu ɔɔ 'tmʋa Kea 'a tʋ\"bodɛ ke ‑pɔia\" ‑tɩ ‑nɩa 'de Sesi Klisɩ 'a 'nynɩ 'ʋn 'a ‑tɩ' 'sʋ ɛ, ʋʋ 'je ɔɔ' wlu tɔ' 'ʋn 'ɛ, ‑wɛe 'nynʋkpae' ke nmai ‑wee' a poo \"ni \"jru. ");
INSERT INTO wob_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Simɔ mɔ 'ɔ ‑cɛ\" 'jeɛ Sesi 'a ‑tɩ' tɔ' 'ʋn ‑ke. Ɔ ‑kɔa' \"ni \"jru pooa' 'sʋ ɔɔ' tɛɛn Filipʋ o, dɛ‑nʋɛ' nyʋ 'pʋʋ jrii' ke dɩ klae\" ‑ɩa nʋʋa ɩ \"mɔɔ‑ tai'. ");
INSERT INTO wob_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Ka Kea 'a wlu pa 'e Samadiblʋa \"kpei ɛ, ɩmɩ Sesi 'a dboʋn ‑nɩa Selisalɛm 'wɔn, 'sʋ ʋʋ dbo 'e Piɛi ke San 'mɛ. ");
INSERT INTO wob_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","‑Wi\" ‑mʋ nynia 'e Samadi ɛ, ʋʋ baeɛ nyʋ ‑ʋʋ ‑jea Sesi 'a ‑tɩ' tɔ' 'ʋn 'a baea', ‑wɛe ʋʋ 'e Kea 'a ‑Suu 'je, ");
INSERT INTO wob_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","dɛ‑nʋɛ' ‑mɛ Kea 'a ‑Suu se 'e ʋʋpʋ 'a due' koʋn ‑gbai' 'ʋn \"ti ke. Ʋʋ pooɛ \"ni \"jru 'de Sesi 'a 'sʋ 'a 'nynɩ 'ʋn. ");
INSERT INTO wob_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","'Sʋ Piɛi ke San ‑teɛ ʋʋpʋ kwa \"jru, ‑wɛe ʋʋ 'je Kea 'a ‑Suu. ");
INSERT INTO wob_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Simɔ 'jea Sesi 'a dboʋn ‑tea nyʋ kwa \"jru ‑wɛe Kea 'a ‑Suu jia 'de ʋʋpʋ 'ʋn 'sʋ ɛ, ɔ \"nyɩɛ ʋʋpʋ 'wɛi, ");
INSERT INTO wob_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","'De ɔ 'na : Ao \"nyɩ 'ʋn \"ikmaa' ‑nɛ ‑ke, ‑wɛe nyɔ \"o nyɔ 'ɩn ‑te' kwa \"jru ɔ 'e Kea 'a ‑Suu 'je. ");
INSERT INTO wob_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","'Kaa Piɛi wlu ɔ ‑pee ɔ 'na : ‑Ɩn ‑ke ‑ma 'wɛi cɛn 'e ‑klu' ‑tie\", dɛ‑nʋɛ' ‑ma naa tɔ' i ‑mɔ ‑na nyɔ 'beeɛ' ɔ 'je 'wɛi ja‑ ‑wɛe ɔ 'je Kea 'a ‑paan' ‑tɩn' ! ");
INSERT INTO wob_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Dɛ ‑ɛɛ nʋʋa ‑ta ‑ma dɛ \"o dɛ jrɛ' se ɛ 'di nɩ‑, dɛ‑nʋɛ' ‑ma pɛe se \"isrɛ 'bo Kea \"juɔi. ");
INSERT INTO wob_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Tɔ' saʋn ‑ma naa i ‑nɛ ‑ɩn ‑bɔ ɛ o. 'De ‑ɩn ‑je Tʋ\"bo ‑bae ‑wɛe ɛ 'je ‑ʋn ɛɛ' tɔ' tu 'ʋn ‑sa, ‑bo ɛ 'bɛɛ‑ ɛ 'je nʋʋɛ 'de, Kea 'je ‑ma dɛsaʋn ‑kɔ'. ");
INSERT INTO wob_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Dɛ 'ma 'jea i 'de ‑ʋn 'ʋn ɛ, mɛ ‑nɩ ‑ɩn 'di nyniɛ wɔn ‑wɛe dɛsaʋn 'ble ‑ʋn kʋɔn 'ʋn ke. ");
INSERT INTO wob_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","'Sʋ Simɔ 'na : Aoa' ‑cɛ\" 'kpa bae 'ma Kea, ‑wɛe dɩ ao \"sia 'nynɩ ɩa' dɩ tu je 'ʋn \"jrii nʋʋɛ‑. ");
INSERT INTO wob_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Piɛi ke San ‑kɔa' ‑po blaa' 'de nyʋ ‑pee 'sʋ ʋʋ muɛ Selisalɛm de. Ka ʋʋa mua, 'kamɔ ʋʋa 'tmʋ ‑pɔia\" ‑tɩ 'de Samadikɔʋn 'a ‑kwlɛ 'dii. ");
INSERT INTO wob_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Tʋ\"bo 'a \"soai due' wluɛ 'de Filipʋ ‑pee, ɛ 'na : ‑Ɩn ‑sɔn 'ʋn ‑ɩn mu 'e 'jrʋ 'a kʋaanfɔ o, 'de ‑jeblʋ ‑ɛ ‑wlʋa Selisalɛm ‑wɛe ‑ɛ mua Gasa \"i, 'de ‑pɩɩɔn\" blʋa \"kpei. ");
INSERT INTO wob_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Filipʋ sɔan 'ʋn 'sʋ ɔ 'kpa 'o 'ɛ. Ɔɔ ‑gbʋan 'e mu 'sʋ \"ju due' mɔ ‑nɩ 'bo ɔɔ' \"kpeinaadɛ 'di ‑ɔɔ ‑si'. Ɔɔ' \"ju tu 'wlʋɛ Etiopi, ɔ nɩɛ \"jrujei klaa\" ‑o. Ɔɔ' nyiɔ tu wa 'ʋn 'ɛ, ‑wɛe ɔɔ ‑te' Kandasɩ ‑ʋ ‑nɩa 'beɔnynɔkpao' 'de Etiopiblʋa \"kpei 'a \"wliɛ‑ ‑wee' \"jru o. Ɔmɔ ‑ɔ ji Kea \"juɔi ‑gbɛɛa' 'de Selisalɛm, ");
INSERT INTO wob_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","‑Wɛe ‑ɔɔ mu 'de ɔ \"bli de, 'sʋ ɔ ‑teɛ i 'de ɔɔ' \"kpeinaadɛ 'di ‑wɛe ɔɔ ‑sro' 'e Kea 'a wlu 'kwajaai Esai 'a 'sbɛ 'dii. ");
INSERT INTO wob_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","'Sʋ Kea 'a ‑Suu wlu' 'de Filipʋ ‑pee, ɛ 'na : ‑Ɩn mu, ‑ɩn ‑kpaa' 'bo ɔɔ' \"kpeinaadɛ ‑pʋn\". ");
INSERT INTO wob_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Filipʋ 'kpa plea' 'sʋ, ɔɔ 'wɔn Etiopi i ‑nɔ 'ɔ wlu, ‑mɛ ɔɔ nʋɛ 'e Kea 'a wlu 'kwajaai Esai 'a 'sbɛ 'dii, 'sʋ Filipʋ wlu ɔ ‑pee ɔ 'na : Dɛ ‑ma ‑sroa' 'ee, ‑ma ‑wɔn ɛ 'mii 'mɛɛ ? ");
INSERT INTO wob_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","'Sʋ ɔ 'na ‑bo nyɔ se 'ʋn ‑je o po 'ee, ka 'ɩn 'je ɛɛ' 'mii 'wɔnsʋn nʋ ɛ‑ ? ‑Wɛe ɔ 'da Filipʋ ɔ ‑te' i 'bo 'ʋn ‑pʋn\". 'Sʋ Filipʋ 'jaa ‑wɛe ɔ ‑te i 'bo ɔ ‑pʋn\". ");
INSERT INTO wob_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Kea 'a wlu ɔ nɩa ‑sroa', ɛ ka : Ʋʋ kpɔ' ka nyɔ ɔ kpa 'sraa ‑sa 'blaanynɔ ‑wɛe ɔ 'je ɛ 'dba, 'de ka 'blaaju sea wlu 'ble 'bo nyʋ ‑ʋʋa cɛn ɛ \"mɩɩ‑ kui \"juɔi nɩa ɔ nɩ kan', ɔ se wɔn 'bai‑ mɔ \"pɩ. ");
INSERT INTO wob_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","'De ɔɔ' ‑cɛ\" 'ɛ ja jaa' 'ʋn, 'pee 'wlʋ 'bo ɔ \"jru 'mɛ. ‑Ɔ ‑je ɔɔ' \"ji 'a 'nynɩ \"si 'bode ɛ‑ ? Dɛ‑nʋɛ' ɔɔ' ‑nɛ 'kmʋnɩa' \"tii ‑wɛ‑ 'de 'blʋa‑ \"kpei. ");
INSERT INTO wob_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","'Sʋ \"jrujei ‑nɔ ‑teeɛ' Filipʋ i, ɔ 'na : 'Ma bae ‑ʋn ‑ɛ, nyɔ ‑ɔɔ ‑tɩ' Kea 'a wlu 'kwajaai a 'tmʋ kan' ‑ta a‑ ? Ɛ ɔɔ' ‑cɛ\" 'kpa ‑ae, ‑ɩn\" ɔɔ 'da nyɔ jrɔ' ? ");
INSERT INTO wob_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","'Sʋ Filipʋ \"duɛ wlu 'ʋn, ‑wɛe ɔ tba 'o wlu ‑ɛ ‑crɩɩa' ‑nɛ \"kpei, 'de ɔ ‑te Sesi 'a ‑pɔia\" ‑tɩ 'tmʋa' ‑pʋn\" 'de \"ju ‑nɔ ‑pee. ");
INSERT INTO wob_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","‑Ta ʋʋ nɩa naa' 'sʋ ɛ, ʋʋ jɛɛ \"ni ‑gbuu, 'sʋ \"jru jei ‑nɔ 'na : \"Ni ka, dɛ ‑nɩ 'e la ‑wɛe 'ɩn se \"ni \"jru poo i ɛ‑ ? ");
INSERT INTO wob_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","'Sʋ Filipʋ 'na : ‑Bo ‑ɩn ‑je Sesi 'a ‑tɩ' tɔ' 'ʋn 'de ‑ma pɛe ‑wee' \"klein 'ʋn ɛ, ‑ɩn ‑bɛɛ' ‑ɩn ‑je \"ni \"jru pooɛ‑. 'Sʋ \"ju ‑nɔ 'na : Ka Sesi Klisɩ nɩa Kea 'a \"Ju ɛ, 'ɩn 'je ɛ tɔ' 'ʋn 'ɛ. ");
INSERT INTO wob_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","'Sʋ ɔ nynaa dɛ ʋʋ ‑tea 'di i, ‑wɛe Filipʋ ke \"jrujei \"sii‑ 'bo \"niɔ‑ ka ʋʋ nɩa 'sɔɔn ɛ, 'de Filipʋ poɔ \"ni \"jru. ");
INSERT INTO wob_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Ʋʋ 'wlʋa 'o \"niɔ‑ 'sʋ, Tʋ\"bo 'a ‑Suu \"fla Filipʋ 'mɛ. 'Sʋ \"jrujei se ɔ \"jriɛ‑ 'jee 'bode, 'kaa ɔmɔ ‑tuɛ\" ɔɔ' ‑je \"jriɛ‑ ɔɔ jea mu 'de 'mʋa‑ 'ʋn. ");
INSERT INTO wob_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","'De Filipʋ ‑mɔ ‑taan' 'e Asotɩ 'bo ɔ 'wlʋ, ‑wɛe ɔ mu mamaʋ 'sʋ ɔ nyni Sesare. Ɔ cɛɛn ‑kwlɛ ‑wee' \"klein 'dii ɔɔ 'tmʋɛ Sesi 'a ‑pɔia\" ‑tɩ. ");
INSERT INTO wob_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","'De ɛɛ' nɔ\" tu 'di ‑mɛ Sɔo nɩɛ 'cɛn 'mla \"i 'de Tʋ\"bo 'a klai\" nynuu 'a ‑kwlʋ kpʋan' ke ʋʋa' 'dbaa ‑tɩ' 'ʋn. Ɔ muɛ 'e 'sraa ‑sai klaa\" o, ");
INSERT INTO wob_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","‑wɛe ɔ ‑tee' ɔ 'sbɩ i 'de ɔ 'je 'e Suifʋ‑wi\" 'a \"jrui 'kɩɩn‑gbi ‑ɩ ‑nɩa 'e Damasɩ 'dii mu ‑wɛe ‑bo ‑ʋʋa Tʋ\"bo 'a ‑jei\" naa nyʋ nɩ 'e mu, 'de ɔ 'je 'nynʋkpae' ke nmai kpʋn, ɔ 'je ʋʋpʋ san 'de ɔ 'je ʋʋpʋ Selisalɛm ja‑. ");
INSERT INTO wob_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","‑Ta ɔɔ \"kʋʋan Damasɩ i, 'sʋ ‑nɩain ‑sɔn' klaa\" ‑wlʋa 'e jaʋn 'di crɛ \"jrii 'bo ‑jei\", ɔ 'dewei ‑wee' nɩɛ \"puu'‑. ");
INSERT INTO wob_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","'Sʋ ɔ ‑ka i 'bo 'blʋɔ, ‑wɛe ɔ 'wɔn wlu due' ‑ɛ ‑wlu 'de ɔ ‑pee ‑ɛ ‑na : Sɔo ! Sɔo ! Dɛɛ‑tɩ ‑ma ‑fɔn' 'ʋn tʋ o ɛ‑ ? ");
INSERT INTO wob_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","'Sʋ ɔ 'na : ‑Mɔ nyɔ ‑o ɛ‑, Tʋ\"bo ? ‑Wɛe wlu ‑nɛ 'na : Ɛ 'mɔ Sesi ‑ma ‑fɔan' tʋ o ‑o. ");
INSERT INTO wob_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","'Kaa ‑ɩn ‑sɔn 'ʋn ‑ɩn mu 'o ‑kwlɔ, ‑wɛe dɛ ‑ɩn ‑jea nʋ ʋʋ 'je ɛ ‑ʋn tɔɔ‑. ");
INSERT INTO wob_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Nyʋ ‑ʋʋa kpa Sɔo ɛ, ‑cni'ma kpʋ ʋʋpʋ 'mɛ, dɛ ʋʋ 'jea 'tmʋ, ɛ se nɩ‑. Ʋʋ 'wɔn wlu ‑nɛ 'mɛ ‑ke, 'kaa ʋʋ se nyɔ \"jriɛ‑ 'jee‑. ");
INSERT INTO wob_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Sɔo sɔan 'ʋn 'bo 'blʋɔ, ɔɔ ‑pɔn \"jri 'baia 'a ‑kɔ i, 'kaa ɔɔ' 'je dɛ jrɛ' i. Ʋʋ kpʋn ɔ ‑cɩɛi\" ‑wɛe ʋʋ kpɔ Damasɩ. ");
INSERT INTO wob_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","'De 'wɩ taan 'di ɛ, ɔ se i 'je, ɔ se diidɛ wɔn ‑tɩn', ɔ se \"ni 'na. ");
INSERT INTO wob_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","'De 'bo Damasɩ ‑mɔ ɛ, klai\" ju due' ‑nɩ 'o ‑ɔɔ 'nynɩ nɩ Ananiasɩ, ɔmɔ Tʋ\"bo jɛɛ 'de jajri 'ʋn, ‑wɛe ɛ wlu 'de ɔ ‑pee ɛ 'na : Ananiasɩ ! 'Sʋ ɔ 'wɔɔn ɔ 'na : Tʋ\"bo ! 'Ɩn ka. ");
INSERT INTO wob_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","'De Tʋ\"bo 'na : ‑Ɩn ‑sɔn 'ʋn, ‑ɩn mu 'e ‑jeblʋ nyʋ a 'daa‑ \"isrɛ ‑jei\" ‑wɛe ‑ɩn ‑je 'e Suida o ‑gbu\" pa 'de ‑ɩn ‑je \"ju ‑ɔɔ 'nynɩ nɩa Sɔo i ‑pɔn, ɔ 'wlʋɛ Tasɩ. ");
INSERT INTO wob_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","Ɔ nɩɛ Kea baea', 'sʋ ɔ 'jeeɛ \"ju due' ‑ɔɔ 'nynɩ nɩ Ananiasɩ \"jriɛ‑, ‑wɛe ‑ɔ pɔ o 'de ‑ɔ ‑te ɔ kwa \"jru, ‑wɛe ɔ 'je i 'je ke'wlɛ. ");
INSERT INTO wob_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","'Sʋ Ananiasɩ 'na : Tʋ\"bo nyʋ ‑tuu\"‑tuu ‑kwle \"ju ‑nɔ 'ɔ ‑tɩ' 'tmʋa' 'mɛ, ʋʋ 'na ɔɔ ‑tuɛ\" ‑ma nyʋ ‑ɩn ‑teea kpɔi\" 'bo Selisalɛm 'kle. ");
INSERT INTO wob_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","‑Wɛe 'sraa ‑saʋn 'a klae\" ‑wi\" \"nyɩ ɔ 'sbɛ 'de ɔ ji 'nɔ, ‑wɛe ɔ 'je nyʋ \"klein ‑ʋʋa ‑sia\" ‑ma 'nynɩ kpʋn 'de ɔ 'je ʋʋpʋ san. ");
INSERT INTO wob_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","'Kaa Tʋ\"bo wlu 'e Ananiasɩ ‑pee, ɛ 'na : ‑Ɩn mu 'sʋ, dɛ‑nʋɛ' \"ju ‑nɩa 'mʋa‑ 'ɩn ‑tee ɔ kpɔi\", ‑wɛe 'ɩn 'je ɔ dbo 'ʋn nʋʋ‑ 'de ɔ 'je 'ma 'nynɩ 'e 'blʋa‑ jrɩ' o, 'beɔ‑wi\" \"juɔi o, Israɛ‑blʋa \"kpei kpa. ");
INSERT INTO wob_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Ka ɔɔ mua 'kle 'jea' 'de 'ma 'nynɩ 'a ‑tɩ' 'ʋn 'ma ‑cɛ\" 'kpa a muɛ 'tmʋa' 'de ɔ ‑pee. ");
INSERT INTO wob_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Ananiasɩ \"sia \"kpae' 'sʋ ɔ 'kpa 'o 'ɛ. Ɔ nynia 'de ‑gbu\" 'di 'sʋ, ɔ ‑teɛ Sɔo kwa \"jru 'de ɔ 'na : Sɔo, 'ma de'di, Tʋ\"bo Sesi ‑ɔ ‑ke ‑ɩn ‑jeea' ‑ta ‑ma jiia 'bo ‑jei\" ɛ, ɔmɔ dbo 'ʋn ‑wɛe ‑ma \"jri 'e 'bai‑ 'de Kea 'a ‑Suu 'je 'e ‑ɩn 'ʋn \"ji. ");
INSERT INTO wob_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","'Bo ɛ \"sri dɩ jrɩ' ka ‑smii' flɩ nɩa, ‑ɩ ‑nɩa kan', ɩ je 'e ɔ \"jri 'wlʋ. 'Sʋ ɔɔ' \"jri ‑gbai', ɔ sɔn 'ʋn 'ɛ, ‑wɛe ɔ pooɛ \"ni \"jru. ");
INSERT INTO wob_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Ɔ ‑koa' dɛ dia' 'sʋ ɔɔ 'bleɛ jiɛ 'de ɔ 'ʋn de. Sɔo ke klai\" nynuu nʋɛ 'o Damasɩ 'wɩ pla‑. ");
INSERT INTO wob_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","'Bo ɛ \"sri ka Sesi nɩa Kea 'a \"Ju ɛ, ɔ je ɛɛ' 'tmʋa' ‑pʋn\" ‑te 'de Suifʋ‑wi\" 'a \"jrui 'kɩɩn‑gbi 'dii. ");
INSERT INTO wob_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Nyʋ \"klein ‑ʋʋa ‑wɔan ɔɔ' wlu ɛ, tai' \"maa ʋʋ 'mɛ, ʋʋ 'na : Ɛ se \"ju ‑ɔɔ ‑tua\" nyʋ ‑ʋʋa ‑sia\" Sesi 'a 'nynɩ 'kle 'de Selisalɛm, ɔ ko ‑taa ? 'De ɔ se ‑ta ji ‑wɛe ɔ 'je Kletiɛn‑wi\" kpʋn 'de ɔ 'je ʋʋpʋ sʋn \"wɔin saan 'de ɔ 'je ʋʋpʋ 'sraa ‑saʋn klae\" \"juɔi kpaa ? ");
INSERT INTO wob_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","'Kaa Sɔo \"duɛ 'kpɩ 'ʋn, ‑wɛe ɔɔ 'tmʋ Kea 'a ‑tɩ' ɔɔ mu nya. 'Sʋ Suifʋ‑wi\" ‑tia\" 'o Damasɩ ‑wee' 'kpa \"kɔun kɔun‑. Ka Sesi nɩa Klisɩ ɛ, ɩmɩ ɔɔ 'tmʋ ɔɔ kpa nya. ");
INSERT INTO wob_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","'Wɩ jrɩ' ‑sia' 'o 'sʋ ɛ, Suifʋ‑wi\" pooɛ ɔɔ' 'dba ‑tɩ. ");
INSERT INTO wob_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","'Kaa nyʋ jrʋ' ‑saa Sɔo fɛn'. Nyʋ ‑pooa ‑tɩ' ‑nʋ, ʋʋa fuɛ ‑kwlɔ 'ɔ kpae\" i 'de \"maʋ'wɩ o, 'jrʋ‑gbaowɩ 'di ‑wɛe ʋʋ 'je ɔ 'dba. ");
INSERT INTO wob_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","'Sʋ klai\" nynuu \"duo‑ Sɔo 'ʋn 'ɛ \"maʋ\", ʋʋ ‑te' ɔ 'e too\" 'di ‑wɛe ʋʋ jɔɔ blo' \"jru, 'de ʋʋ \"sii ɔ i. ");
INSERT INTO wob_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","‑Ta ɔ nynia Selisalɛm ɛ, ɔ ‑tɩɛn' Sesi 'a klai\" nynuu 'a ‑pʋn\" 'kpa ‑kɔ i, 'kaa faʋn a nʋ ʋʋ ‑wee' \"klein 'mɛ, dɛ‑nʋɛ' ka ɔ 'jea Sesi 'a klai\" ju 'kpa, ʋʋ se ɛ tɔ' 'ʋn 'je. ");
INSERT INTO wob_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","'Sʋ Banabasɩ \"duo‑ Sɔo 'ʋn 'ɛ, ‑wɛe ɔ ke ɔ kpɔ 'e Sesi 'a dboʋn o, ‑wɛe ka Sɔo ke Tʋ\"bo 'jeea 'bo ‑jei\", 'de ka ɔ 'tmʋa Kea 'a ‑tɩ' 'de Sesi 'a 'nynɩ 'ʋn ka ‑cɔɔn' ka 'de Damasɩ ɛ, ɔ po ʋʋpʋ ɩa' \"kuan. ");
INSERT INTO wob_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Dɛ ‑tba' 'o ɛɛ' nɔ\" tu 'di ɛ, Sɔo nɩɛ 'bo ʋʋ ‑pʋn\", ‑wɛe ɔ ke ʋʋa nʋ ‑mu' ‑ji' 'bo Selisalɛm. Ɔɔ wa' i ‑wɛe ɔɔ 'tmʋ Kea 'a ‑tɩ' 'de Tʋ\"bo 'a 'nynɩ 'ʋn. ");
INSERT INTO wob_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Ɔɔ wlu' ‑ke 'de Suifʋ‑wi\" ‑a ‑poa' Klɛkɩwlu ‑pee 'de ɔ ke ʋʋpʋ a ‑too' ba o, 'kaa ‑wi\" ‑mʋ a ‑pɔn ɔɔ' 'dba ‑kɔ i. ");
INSERT INTO wob_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Ɔɔ' de'di ‑wi\" 'wɔɩn 'sʋ ɛ, ʋʋ kpɔ Sesare, ‑wɛe ɔ 'wlʋ 'e ‑mɔ 'de ɔ mu Tasɩ. ");
INSERT INTO wob_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","'De ɛɛ' nɔ\" tu 'di ɛ, Kea ‑gbu ‑teɛ 'flɛʋn 'de Suide o, Galile o, Samadiblʋɩ \"kpei. Nyʋ ‑wee' 'bleɛ 'kpɩ ‑wɛe Tʋ\"bo 'a wɔn 'jea' ke ɔɔ' pleea' nɩ 'de ʋʋpʋ 'ʋn. Kea 'a ‑Suu a nʋɛ 'de nyʋ ‑jea Sesi 'a ‑tɩ' tɔ' 'ʋn a 'kpa \"kpei. ");
INSERT INTO wob_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","‑Ta Piɛi a ‑teea' nyʋ ‑ʋʋ ‑jea Sesi 'a ‑tɩ' tɔ' 'ʋn \"i ‑kwlɛ 'dii ɛ, ɔ mu Lida, Kea 'a ‑jei\" naaʋn ‑nɩa ‑ke ɛ. ");
INSERT INTO wob_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Ɔ jɛɛ \"ju due' 'bo ‑kwlɔ ‑nɛ 'di, ɔɔ' 'nynɩ ‑nɩ Ene, ‑ɔ nʋ 'o 'wɛ blʋɔ ‑sɩn ‑mɛ\" na, dɛ‑nʋɛ' ɔɔ' 'dae‑ 'mɛɛ. ");
INSERT INTO wob_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","'Sʋ Piɛi wlu ɔ ‑pee ɔ 'na : Ene, Sesi Klisɩ 'bɔɔ‑ ‑ma 'wɛ‑ 'mɛ, ‑ɩn ‑sɔn 'ʋn ‑ɩn ‑je ‑ma \"kpei 'pɛndɛ nmae‑. 'Bo ɛ \"sri ɔ sɔn 'ʋn. ");
INSERT INTO wob_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Nyʋ \"klein ‑nɩa 'o Lida ke, nyʋ ‑nɩa 'e Sarɔn 'jeea dɩ ‑nʋʋa 'mʋa‑ \"jriɛ‑ 'sʋ ɛ, ʋʋ ‑wee' \"biiɛ 'e Kea o. ");
INSERT INTO wob_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","'De klai\" nynuu \"klu 'bo Sope ɛ, 'nynɔkpao' due' ‑nɩ 'o, ‑ʋa 'nynɩ ‑nɩ Tabita. 'De Klɛkɩwlu 'di ʋa' 'nynɩ ‑nɩ Dɔkasɩ, ɛ 'de mɛ ‑nɩ \"wlɛ mɛʋn‑. Ʋa nʋɛ dbo 'dɔe ‑tuu\"‑tuu, ‑wɛe ʋa ‑te' wɛenyʋ kwa wɔi. ");
INSERT INTO wob_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Ʋmʋ 'wɛ‑ kpʋn 'de ɛɛ' nɔ\" tu 'di ‑wɛe ‑ʋ ‑mɛ. Ʋʋ ‑kɔa' ʋa' \"ku jrea' 'sʋ ɛ, ʋʋ kpʋ 'e \"jɛi‑gbu 'a wɔn due' 'di, ‑wɛe ʋʋ 'pɛɛn ʋ i. ");
INSERT INTO wob_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","'Sʋ klai\" nynuu ‑nɩa 'o Sope 'wɔn Piɛi 'a 'nynɩ 'bo Lida, ‑wɛe ʋʋ dbo nyʋ 'sɔɔn \"i, 'de ʋʋ 'je ɔ i bae‑ ‑wɛe ɔ 'e ‑too\" ɔ 'e ji, dɛ‑nʋɛ' Lida ke Sope se ba o tɛɛn‑. ");
INSERT INTO wob_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Piɛi sɔan 'ʋn 'sʋ ɔ ke nyʋ ‑nʋ 'kpa 'o 'ɛ. ‑Ta ʋʋ nynia 'bo Sope 'sʋ ɛ, ʋʋ kpa Piɛi 'de \"jɛi‑gbu 'a wɔn 'di. ‑Tiɔn\" nynʋkpae' ‑wee' \"klein ‑gbaeɛ' ɔ 'dei, 'de ʋʋa ‑fɩn\", ‑wɛe ‑ta Dɔkasɩ ke ʋʋ ‑teea i 'de ɛ, \"bai ke dɩ \"klein ʋ nʋa ʋʋa to ɩ Piɛi \"i. ");
INSERT INTO wob_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","'Sʋ Piɛi poɛ nyʋ ‑wee' \"klein \"kpae', ‑wɛe ɔ po 'kɔi‑ ‑klu' ɔ bae Kea, ‑wɛe ɔ \"biie‑ 'de ʋa' \"ku o 'de ɔ 'na : Tabita, a sɔn 'ʋn. 'Sʋ ʋ 'baiɛ \"jri. Ʋ 'jea Piɛi 'sʋ ʋ sɔn 'ʋn 'ɛ, ‑wɛe ʋ ‑te i. ");
INSERT INTO wob_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Ɔ kpa sʋn, ɔ kpʋ \"jɛi, 'de ʋ nyna i. ‑Wɛe ɔ 'da Sesi 'a ‑tɩ' tɔ' 'ʋn 'jeʋn ke ‑tiɔn\" nynʋkpae' 'de ɔ to ʋa' 'kmʋ de ji ‑nɛ ʋʋpʋ \"i. ");
INSERT INTO wob_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Nyʋ \"klein ‑nɩa 'o Sope ‑wee' 'wɔn ɛɛ' dɛ tu 'mɛ, 'sʋ nyʋ ‑tuu\"‑tuu ‑je Tʋ\"bo 'a ‑tɩ' tɔ' 'ʋn. ");
INSERT INTO wob_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Piɛi nʋɛ 'o Sope 'wɩ pla, 'de Simɔ ‑ɔɔ ‑pa\" nmikui o ‑gbu\". ");
INSERT INTO wob_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","\"Ju due' ‑nɩ 'o Sesare, ɔɔ' 'nynɩ ‑nɩ Kɔnɛi, ɔ ‑teɛ Rɔmʋ 'a \"soa‑wi\" 'a kpɔ jrɛ' \"jru o i. Ʋʋa 'daa ʋʋpʋ Italiblʋa 'a ‑nɛ \"sʋɩ. ");
INSERT INTO wob_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Ɔɔ' \"ju tu 'srɛ\", ɔ ke ɔɔ' ‑gbu\" ‑sɔn nyʋ ‑wee' \"klein a pleɛ Kea, ɔɔ poɛ Suifʋ 'a nɩɩa\" nyʋ sʋn o, ‑wɛe ɔɔ bae Kea jeejee. ");
INSERT INTO wob_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","‑Kwie\" jrʋ‑gbao jrɛ' o 'sʋ ɔ 'jeɛ Kea 'a \"soai due' i 'pepe 'de jajri 'ʋn, ‑ɔ pa 'e ɔ o ‑gbu\", 'de ‑ɔ ‑wlu ɔ ‑pee ‑ɔ ‑na : Kɔnɛi ! ");
INSERT INTO wob_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Kɔnɛi \"sii‑ ɔ \"jriɛ‑ ‑sɛɛn', 'sʋ faʋn a nʋɔ', ɔ 'na : Dɛ ‑nɩ kan' a‑ Tʋ\"bo ? 'sʋ Kea 'a \"soai 'na : ‑Ma baewlu ke ‑ma dɩ 'dɔe ‑ma nʋa ji', ɩ je Kea jɛɛ‑, 'de ɛ po ɩa' ‑tɩ' ‑kwlʋ o. ");
INSERT INTO wob_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","‑Ɩn dbo nyʋ 'de Sope, ‑ɩn ‑je Simɔ ‑ɔɔ \"kpei ‑tenynɩ nɩa Piɛi 'da. ");
INSERT INTO wob_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Ɔ kooɛ 'de \"ju due' nyʋ a 'daa‑ Simɔ nmiku \"pa i o ‑gbu\". Ɔɔ' ‑gbu\" nɩɛ 'e 'tɔniɛ ‑kwlɩ\" fɔ o. ");
INSERT INTO wob_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Kea 'a \"soai ‑ɔ ‑wlu ɔ ‑pee 'a ‑nɩ ‑ɛ mua 'sʋ Kɔnɛi 'da ɔɔ' dbonʋʋn 'sɔɔn 'mɛ, ɛ ke ɔɔ' \"sʋɩ 'a due' ‑kma ɔɔ' ‑tɩ' ‑wɛe ‑ɔɔ pleea Kea ke‑. ");
INSERT INTO wob_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","‑Wɛe dɩ \"klein ɔ 'jea jajri ‑nɩ, ɔ po ʋʋpʋ ɩa' \"kuan, ‑wɛe ɔ dbo ʋʋpʋ 'de Sope. ");
INSERT INTO wob_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Ɛɛ' ‑sɔn' ‑sɩan', ‑ta ʋʋ nɩɩa 'o ‑jei\" ‑wɛe ʋʋa \"kʋʋan‑ Sope i ɛ, ‑mɛ Piɛi 'ja 'e ‑gbu\" \"jru ‑nɩa pɛɛpɛɛ 'jrʋ‑gbao, ‑wɛe ɔɔ bae Kea. ");
INSERT INTO wob_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","'Sʋ 'mɩɩɛ‑ ɛ nʋɔ', ɔ nɩɛ \"i ɔ 'je dɛ di. ‑Ta ʋʋ siia dɛ pia' a 'sʋ ɔ blu' 'de ja jri 'ʋn. ");
INSERT INTO wob_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","Ɔɔ 'jeɛ jaʋn i, ɛ kaiɛn wɔn, ‑wɛe dɛ jrɛ' ka tae'fɔ nɩa ‑ɛ ‑nɩa kan' ‑wlʋ 'e jaʋn 'di ‑ɛɛ ‑si\" i 'bo 'blʋɔ, ɛɛ' 'fɔ ‑nɩa ‑nyiiɛ ‑wee' \"sriɛ \"dbu. ");
INSERT INTO wob_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Ɔɔ 'jeɛ nmi 'a \"kwli ‑wee' i 'de ɛ 'di : ‑Jɩ ‑a naa bɩ ‑nyiiɛ \"i o, ‑jɩ ‑a cnia ‑pɛɛ' o, ɩ ke nʋʋɩ 'a \"kwli ‑wee' ke‑. ");
INSERT INTO wob_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","'Sʋ ɔ 'wɔn wlu jrɛ' ‑ɛ ‑na : Piɛi, ‑ɩn ‑sɔn 'ʋn ‑ɩn ‑dba, ‑ɩn di. ");
INSERT INTO wob_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","'Kaa Piɛi 'na : \"Ɩɩn‑ 'de, Tʋ\"bo, ɩa' dɩ tu se 'ma wɔn \"i bla due' ɩ se i ‑kwɛ‑, ɩ kpʋɛn ‑flɛn\". ");
INSERT INTO wob_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","'Sʋ wlu ‑nɛ 'ɛ kpɛ 'sɔɔn ‑nɛ wlu' ke'wlɛ ɛ 'na : Dɩ Kea 'na ɩ nmɔ \"jrii ɛ ‑ɩn ‑bo nʋɛ ɩ kpʋn ɛ ‑flɛn\". ");
INSERT INTO wob_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Ɛɛ' dɛ tu nʋɛ' kpɛ taan ‑wɛe tae'fɔ ‑nɛ \"sri 'o, ɛ mu jaʋn 'di de. ");
INSERT INTO wob_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","‑Ta Piɛi nɩɩa ɔɔ' ‑cɛ\" i‑teea' 'de dɛ ɔ 'jeea \"jriɛ ‑nɛ 'ɛ ‑tɩ' 'ʋn ɛ, ‑mɛ nyʋ Kɔnɛi dboa ‑nʋ ‑teeɛ' nyʋ i mamaʋ 'sʋ ʋʋ je Simɔ 'ɔ ‑gbu\" 'je, ‑wɛe ʋʋ nyna i 'bo ɛ \"wɔin. ");
INSERT INTO wob_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Ʋʋ kpa wlu \"jɛi ‑wɛe ʋʋ ‑tee' nyʋ i ʋʋ 'na : ‑Ta mɔ Simɔ ‑ɔɔ \"kpei ‑tenynɩ nɩa Piɛi koo‑ ɛ‑ ? ");
INSERT INTO wob_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Dɛ Piɛi 'jeea \"jriɛ 'mʋa‑ ɔ nɩɛ tɔ' \"kpei naa', 'sʋ Kea 'a ‑Suu wlu' 'de ɔ ‑pee ɛ 'na : ‑Ɩn ‑gbʋn 'nɔ, nyʋ taan ‑a ‑pɔn' ‑mii. ");
INSERT INTO wob_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","‑Ɩn ‑sɔn 'ʋn, ‑ɩn ‑si\" i, ‑ɩn ‑ke ʋʋpʋ 'e mu. ‑Ɩn ‑bo tɔ' i pleeɛ, dɛ‑nʋɛ' 'mɔ ‑dbo' ʋʋpʋ. ");
INSERT INTO wob_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","'Sʋ Piɛi \"siɛ i ‑wɛe ɔ wlu 'e nyʋ ‑nʋ ‑pee ɔ 'na : 'Mɔ aoa ‑pɔan i 'ɩn ka, dɛɛ‑tɩ ao ji ɛ‑ ? ");
INSERT INTO wob_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Ʋʋ 'na : Kɔnɛi ‑ɔ ‑nɩa \"sʋɩ 'a jra' jei klaa\" mɔ ‑dbo' ‑aʋn. Ɔɔ' \"ju tu 'srɛi\", ɔɔ pleeɛ Kea. Suifʋ ‑wee' \"klein a po ɔ ɛɛ' ‑tɩ' o. Kea 'a \"soai due' mɔ ‑tmʋʋ' ɔ ‑ɔ ‑na : ‑Ɩn ‑je 'de ɔ o ‑gbu\" mu 'de ɔ 'je ‑ma wlu doin\" o po. ");
INSERT INTO wob_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Piɛi paa ʋʋpʋ ‑gbu\" ‑wɛe ɔ \"nyɩ ʋʋpʋ 'pɛn 'ɩn. ‑Sɔn' ‑sɩan' ɔ sɔn 'ʋn 'ɛ, ‑wɛe ɔ ke ʋʋ mu. Ɔɔ' de'di ‑wi\" ‑nɩa Sope 'a jrʋ' kpɔ'. ");
INSERT INTO wob_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","‑Sɔn' dee ‑sɩan', ɛmɛ ʋʋ nyni Sesare. Kɔnɛi 'da ɔɔ' 'cɛ‑wi\" o, ɔɔ' \"dɛi‑wi\" ‑ʋʋa \"dia ɔɔ 'jea 'mɛ, ‑wɛe ʋʋa fuo ʋʋpʋ. ");
INSERT INTO wob_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Piɛi 'a ‑nɛɛ pa ‑gbu\" 'sʋ Kɔnɛi 'jɔɔ \"i ɔ ‑gbleeɛ bɩ wɔ, 'de ɔ tba 'kɔu i 'bo ɔ \"juɔi. ");
INSERT INTO wob_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","'Kaa Piɛi kpɔ \"jɛi ɔ 'na : ‑Ɩn ‑sɔn 'ʋn, 'mɔ nɩɛ nyiɔ ‑o ‑ke. ");
INSERT INTO wob_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Ɔ ke Kɔnɛi nɩɛ 'tmʋwlu 'wɔn \"i 'sʋ ʋʋ je 'e ‑gbu\" pa. Piɛi jɛɛ 'e nyʋ ‑tuu\"‑tuu ‑ʋʋ ‑kɩɩɛn' \"jrui. ");
INSERT INTO wob_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","'Sʋ ɔ wlu' 'de ʋʋ ‑pee ɔ 'na : Ao ‑wee' juɛ', ‑apʋ Suifʋ‑wi\" ɛ, ‑a ‑ke nyʋ ‑sea' Suifʋ nɩ 'a dbɛɛ‑, ‑wɛe 'de ʋʋ o ‑gbu\" 'di mɔ'ɔ pa ‑tɩ, 'kaa dɛ Kea ‑sa 'kwla 'de 'ʋn ‑pee ɛ, ɛ ka, ɛ 'na : ‑Ɩn ‑bo nyɔ \"o nyɔ ja ‑gbʋn ‑ɛ ka ‑flɛn\" nyʋ nɩa. ");
INSERT INTO wob_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Ɛmɛ ‑tɩ ao 'da 'ʋn ‑wɛe 'ɩn se 'o wlu tba 'sʋ 'ɩn ji. ‑A ‑wɔn 'e ? Dɛɛ ‑tɩ ao dbo nyʋ \"i ɛ‑ ? ");
INSERT INTO wob_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","'Bomɔ Kɔnɛi 'na : Ɛɛ' dɛ tu nʋʋa 'ʋn \"jrii ɛ, ɛɛ' 'wɩ ‑nyiiɛ, ka ti nɩa ‑ta kaan 'kamɔ ɛ nɩ‑. 'Ma baeɛ Kea 'de 'ɩn o ‑gbu\" 'di ‑kwie\" jrʋ ‑gbao o. 'Ma ‑gbʋan 'e mu 'sʋ \"ju due' ‑jɛɛ 'ʋn. Ɔɔ' 'a 'ʋnpaadɩ a nʋɛ ‑blɛ ‑blɛ. ");
INSERT INTO wob_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","'Sʋ ɔ wluɛ 'ʋn ‑pee ɔ 'na : Kɔnɛi, Kea 'wɔn ‑ma baewlu 'mɛ, ‑ma dɩ 'dɔe \"klein ‑ma nʋa nɩɩa\" nyʋ \"jrii ɛ, ɛ poɛ ɩa' ‑tɩ' ‑kwlʋ o. ");
INSERT INTO wob_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","'Kaa ‑ɩn dbo nyʋ 'e Sope ‑wɛe ʋʋ 'je Simɔ ‑ɔɔ \"kpei ‑tenynɩ nɩa Piɛi 'da, ɔ kooɛ 'de Simɔ nmiku o ‑gbu\" 'di, 'de 'tɔniɛ ‑kwlɩ\" fɔ o. ");
INSERT INTO wob_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","'Bo ɛ \"si 'ɩn je ‑ʋn nyʋ \"i dbo, dɛ ‑ɩn jia ‑mɛ nmɔ \"jrii. Kaan ka la 'ja a, ‑a ‑wee' ka ‑ta Kea \"juɔi ‑wɛe dɩ \"klein Tʋ\"bo ‑tua\" ‑ʋn ‑wɔn ɛ, ‑ɩn ‑jɩ 'tmʋ 'de ‑a ‑pee ‑wɛe ‑a ‑jɩ 'wɔn. ");
INSERT INTO wob_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","'Sʋ Piɛi \"duɛ wlu 'ʋn ɔ 'na : tɔ' ‑tɩ, ka Kea 'a 'cra nyʋ 'mii ɛ, 'ɩn 'wɔɩn 'mii ‑wɛ‑ la ‑cɛɛn'‑. ");
INSERT INTO wob_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","'Kaa ‑bo ka nyɔ 'je ɔ nɩ, ‑ta \"o ‑ta ɔ 'wlʋ ‑wɛe ɔ 'je Kea plee 'de ɔ 'je \"i \"srɛdɩ nʋ ɛ, ɔmɔ ‑ɔɔ \"dia ɛɛ 'je. ");
INSERT INTO wob_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Ɛ ja ɛɛ' wlu 'de Israɛ‑kɔʋn o ‑wɛe ɔ 'tmʋʋ‑ ʋʋpʋ pɛe 'a blu ‑tɩ 'de Sesi Klisɩ ‑ɔ ‑nɩa nyʋ ‑wee' \"klein 'a Tʋ\"bo 'ʋn. ");
INSERT INTO wob_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Dɛ ‑ɛ ‑nʋʋa 'de Suideblʋa ‑wee' \"kpei ɛ, ao 'wɔɛn, ɛɛ' dɛ tu ‑tee' 'de Galile, dɛ ‑tba' 'e \"ni \"jru poa' ‑ɛɛ ‑tɩ' San 'tmʋa \"kpei ɛ. ");
INSERT INTO wob_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Ao juɛ' ka Kea \"nyɩa Sesi ‑wlʋa Nasarɛtɩ ɛɛ' ‑Suu ke 'kpɩ ke, ‑wɛe ɔɔ mua ‑ta \"o ‑ta ɔɔ nʋa dɩ 'dɔe, ɔɔ 'bɔɔa nyʋ 'a 'wɛ‑ ‑wɛe ɔɔ ‑seia nyʋ \"klein ‑ʋʋ ‑nɩa 'e ‑siɔn' 'kwa, dɛ‑nʋɛ' Kea 'a ‑cɛ\" 'kpa ‑ke ɔ na‑. ");
INSERT INTO wob_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","Dɩ \"klein ɔ nʋa 'de Suifʋ‑wi\" 'a 'blʋa‑ \"kpei o, dɩ ɔ nʋa 'de Selisalɛm, 'de ka ʋʋ 'dbɔ 'bo tu ‑kwlɩ\" ɛ, ‑a ‑wee' \"klein nɩ ɛɛ' ‑ta 'jeʋn ‑o. ");
INSERT INTO wob_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","'Kaa Kea jɔ 'kmʋ de 'de 'wɩ 'a taan ‑nɛ 'di, ‑wɛe ɔ to ɔɔ' ‑cɛ\". ");
INSERT INTO wob_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","Ɛ se 'de nyʋ ‑wee' ‑pee nɩ‑, 'kaa ɛ nɩ 'de ‑apʋ Kea ‑sa 'o sese, ‑wɛe ‑ɔ ‑nɩa ɛɛ' ‑ta 'jeʋn ‑pee o. ‑Ta ɔ jia 'kmʋ de ɛ, ɔ ke ‑aa ‑dii ‑tadue 'de ‑a ‑naa ‑tadue. ");
INSERT INTO wob_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","‑Wɛe ɔ 'na ‑a ‑tmʋ ɔɔ' ‑tɩ' 'de nyʋ ‑pee, 'de ka Kea ‑te' ɔ 'o ‑wɛe ɔ nɩa 'kmʋnɩʋn ke 'mɛʋn 'a 'pee 'jei ɛ, 'de ‑a ‑je ɛ \"kpei‑ 'nyɛ 'de ʋʋ ‑pee. ");
INSERT INTO wob_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Kea 'a wlu 'kwajaaʋn ‑wee' \"klein 'tmʋ ɔɔ' ‑tɩ' 'mɛ, ʋʋ 'na nyɔ \"o nyɔ ‑jea ɔɔ' ‑tɩ' tɔ' 'ʋn ‑mɔɔ' dɩsaɩn ‑kwɛ' 'de ɔɔ' 'nynɩ 'ʋn. ");
INSERT INTO wob_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Piɛi nɩɛ wlu ‑nɩ 'a 'tmʋa' 'sʋ Kea 'a ‑Suu \"siɛ i 'de nyʋ \"klein ‑ʋʋa poa ɔɔ' wlu doin\" o \"kpei. ");
INSERT INTO wob_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Dɛ Kea \"nyɩa nyʋ ‑sea' Suifʋ nɩ ɛɛ' ‑Suu \"maa Suifʋ‑wi\" ‑ʋʋ ‑jea Sesi 'a ‑tɩ' tɔ' 'ʋn ‑wɛe ‑ʋʋ ‑ke Piɛi jia tai'. ");
INSERT INTO wob_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","Dɛ \"maa ʋʋpʋ tai' ɛ, ɛmɛ ‑nɩ nyʋ ‑nʋ a poɛ wlu dee‑ ‑wɛe ʋʋa 'bɛɛ‑ Kea 'a 'nynɩ \"i. ");
INSERT INTO wob_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","'Sʋ Piɛi 'na : Nyʋ ‑jea Kea 'a ‑Suu ‑ke ka ‑apʋ mɔ nɩa 'ee, nyʋ 'bɛɛ‑ nyʋ 'e ʋʋpʋ 'a \"ni \"jru pooa' 'ʋn \"nao ‑o ? ");
INSERT INTO wob_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","'Sʋ ɔ 'na : Ao po ʋʋpʋ \"ni \"jru 'de Sesi Klisɩ 'a 'nynɩ 'ʋn. ‑Wɛe Kɔnɛi ke ɔɔ' 'cɛ‑wi\" bae Piɛi i, 'de ɔ 'e 'wɩ pla nʋ 'bo ʋʋ ‑pʋn\". ");
INSERT INTO wob_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Ka nyʋ ‑sea' Suifʋ nɩ 'wɔan Kea 'a wlu ‑wɛe ʋʋ kpʋʋn ɛ sʋn 'sɔɔn ɛ, ɩmɩ ‑tadboʋn‑ ke ɔɔ' ‑tɩ' tɔ' 'ʋn 'jeʋn ‑nɩa 'e Suide 'wɔn. ");
INSERT INTO wob_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Piɛi jiia Selisalɛm de 'sʋ, Suifʋ‑wi\" ‑teɛ ɔɔ' \"bli ‑cɛa' ‑pʋn\". ");
INSERT INTO wob_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","Ʋʋ 'na : Piɛi, ‑ɩn pa 'e nyʋ ‑sea' Suifʋ nɩ o, ‑wɛe ʋʋ ke ‑ɩn dii ‑tadue ! ");
INSERT INTO wob_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","'Sʋ dɩ \"klein ‑nʋʋa Piɛi bla ɩ ‑wee' 'a ‑po' do‑ do‑, ɔ se dɛ 'o sie. ");
INSERT INTO wob_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","Ɔ 'na : ‑Ta 'ɩn nɩɩa 'o Sope ɛ, ‑wɛe 'ma baea Kea a, 'bomɔ 'ɩn ja ja, dɛ 'ɩn 'jea ‑ɛɛ ‑wlʋa 'e jaʋn 'di 'de ‑ɛɛ jia 'mi \"i ɛ, ɛ ‑kɔ' \"jiɛ klaa\". Ɛɛ' 'fɔ ‑nɩa ‑nyiiɛ ‑wee' \"sriɛ \"dbu, ‑wɛe ɛ ji mamaʋ 'sʋ ɛ \"si i 'bo 'ʋn ‑pʋn\". ");
INSERT INTO wob_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","'Ma ‑gbʋn 'e ɛ 'di 'mɛ 'tɩɩn, 'sʋ 'ɩn 'jeɛ 'kwla 'dinmi ‑blea bɩ ‑nyiiɛ' ke, cniɛ ‑pɛɛ' ke nʋʋɩ 'demu. ");
INSERT INTO wob_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","'Sʋ 'ɩn 'wɔn wlu due' ‑ɛ ‑na : Piɛi, ‑ɩn ‑sɔn 'ʋn, ‑ɩn ‑dba ‑ɩn ‑je di. ");
INSERT INTO wob_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","'Kaa 'ɩn 'na : \"Ɩɩn‑ 'de, Tʋ\"bo, dɩ ‑nɩ, ɩ nɩɛ ‑apʋ Suifʋ‑wi\" 'a ‑gban ‑o, ɩ se 'ma wɔn \"i bla due'. ");
INSERT INTO wob_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","'Sʋ wlu ‑nɩa 'mʋa‑ 'wlʋ 'e \"jɛi, ɛ je wlu ke'wlɛ, ɛ 'na : Dɩ Kea 'na ɩ nɩɛ 'pepe nyɔ 'bɛɛ‑ ɔ 'jɩ di ɛ, ‑ɩn ‑bo nʋɛ ɩ se 'ma di ka nɩ‑. ");
INSERT INTO wob_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Ɛɛ' dɛ tu nʋʋɛ 'ʋn \"jrii kpɛ taan, 'sʋ ɛ muɛ 'e jaʋn 'di de. ");
INSERT INTO wob_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","'De ɛɛ' nɔ\" tu 'di 'sʋ nyʋ taan ‑sri\" 'o ‑ʋʋ ji 'e ‑gbu\" ‑ɛ 'di 'ɩn kooa \"wɔin, ʋʋ 'wlʋɛ Sesare ‑wɛe ʋʋ dbo ʋʋpʋ 'mi \"i. ");
INSERT INTO wob_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","'Sʋ Kea 'a ‑Suu wlu' 'de 'ʋn ‑pee ɛ 'na : Ʋʋ ke ‑ɩn mu, ‑ɩn ‑bo tɔ' i pleeɛ ! ‑Aa de'di ‑wi\" ‑mɛɛo\"‑ ‑nʋ ʋʋpʋ ‑kpa' 'ʋn 'bo Kɔnɛi o ‑gbu\". ");
INSERT INTO wob_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","'De ka ɔ nɩa Kea baea' 'de ɔ o ‑gbu\" 'di, ‑wɛe ɔ 'jeea Kea 'a \"soai \"jriɛ‑, 'de ‑mɔ wlu ɔ ‑pee ɔ 'na : ‑Ɩn dbo nyʋ 'e Sope ‑wɛe ʋʋ 'e Simɔ nyʋ a 'daa‑ Piɛi 'da, ");
INSERT INTO wob_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","‑wɛe wlu ‑bo ‑ɩn ‑ke ‑ma ‑gbu\" ‑sɔn nyʋ 'wɔn 'de ao 'jea 'pʋ ɛ, ‑wɛe ɔ 'jɩ 'tmʋ 'de ao ‑pee. Dɩ ‑nɩ ɩmɩ ‑ɩa \"kuan ɔ po ‑aʋn. ");
INSERT INTO wob_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","'Ɩn ‑tea wlua' ‑pʋn\" 'sʋ, Kea 'a ‑Suu \"siɛ i 'bo ʋʋ \"kpei, ka ɛ nʋa 'de ‑aa ‑tɩ' 'ʋn tɛin\" ‑ke ɛ. ");
INSERT INTO wob_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","'Sʋ Tʋ\"bo 'a wlu ‑tmʋa' 'de ɛ 'ɩn poɛ ‑kwlʋ o, ‑ɛ ‑na San nʋɛ \"ni mɛ ɔ po nyʋ \"jru, 'kaa aopʋ mɔ ɛ, aoa muɛ \"ni \"jru poa' 'de Kea 'a ‑Suu 'ʋn. ");
INSERT INTO wob_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","‑Ta ‑a ‑jea Tʋ\"bo Sesi Klisɩ 'a ‑tɩ' tɔ' 'ʋn ɛ, ‑paan' Kea nʋa ‑a \"jrii ɛ, ɛmɛ ɛ nʋ ʋʋpʋ \"jrii ‑ke, 'mɔ 'beeɛ' 'sʋ 'ɩn 'je Kea o ‑fɔɔn' ? ");
INSERT INTO wob_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Ʋʋ 'wɔan wlu ‑nɛ 'sʋ ʋʋ ‑crai\", ‑wɛe ʋʋa po Kea 'sɛ‑, 'de ʋʋ 'na : Kea 'wɔɔn nyʋ ‑sea' Suifʋ nɩ ‑kɩn kwa ‑wɛe ʋʋa poo kplɩn fai\" ‑ke 'de ʋʋ 'je 'pʋ. ");
INSERT INTO wob_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Dɛ ‑tba' 'o Etiɛin 'a 'mɛa', 'kle ‑jia' Kea ‑gbu \"kpei ɛ, ɛ nʋɛ' Sesi 'a ‑tɩ' tɔ' 'ʋn 'jeʋn ‑wee' \"klein je ja ‑gba' 'bo Selisalɛm, ʋʋa' jrʋ' mu' mamaʋ 'sʋ ʋʋ je 'e Fenisi o, Siprʋ‑blʋa o, Antiɔsɩ nyni, 'kaa 'de Suifʋ‑wi\" 'a 'sʋ ‑pee mɔ ʋʋa 'tmʋʋ Sesi 'a ‑tɩ'. ");
INSERT INTO wob_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","'De ʋʋ \"klu ɛ, nyʋ jrʋ' ‑nɩ 'e ‑ʋʋ ‑wlʋ Siprʋ ke Sirɛnɩ ke ‑wɛe ‑ʋʋ ji Antiɔsɩ 'de ‑ʋʋ ‑wlu 'e Glɛkɩ‑wi\" ‑pee ‑ke, 'de ʋʋ ‑tmʋʋ' ʋʋpʋ Tʋ\"bo Sesi 'a ‑pɔia\" ‑tɩ. ");
INSERT INTO wob_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Tʋ\"bo 'a sʋn nɩɛ ʋʋpʋ \"kpei, ‑wɛe nyʋ ‑tuu\"‑tuu a 'je ʋʋa' wlu tɔ' 'ʋn 'de ʋʋa \"biie 'e Tʋ\"bo o. ");
INSERT INTO wob_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Ɩmɩ nyʋ ‑nɩa 'e Kea ‑gbu 'di 'e Selisalɛm 'wɔn 'sʋ ʋʋ dboɛ Banabasɩ 'de Antiɔsɩ. ");
INSERT INTO wob_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","‑Ta ɔ nynia 'demu ‑wɛe ɔ 'jea ka Kea nʋa ʋʋpʋ 'saaʋn \"jri 'sʋ ɛ 'bleɛ ɔɔ' 'mʋa‑, ‑wɛe ɔ kuu ʋʋ ‑wee' \"klein 'a dɩ i 'de ʋʋ 'je Tʋ\"bo 'a ‑tɩ' kpʋn ‑kli 'de ʋʋ pɛe o. ");
INSERT INTO wob_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Ɔɔ' Banabasɩ ‑tu ɛ, ɔ nɩɛ 'diwɔnmɔi ‑o, ‑wɛe Kea 'a ‑Suu \"ji 'de ɔ 'ʋn, 'de ɔɔ' Sesi ‑kwlɩ\" ‑tea' kuɛ 'e 'dei. 'De ɛɛ' nɔ\" tu 'di nyʋ ‑tuu\"‑tuu ‑sa 'o Sesi 'a ‑tɩ'. ");
INSERT INTO wob_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","'Bomɔ Banabasɩ cɛɛn ɔ je Sɔo ‑jei\" mu 'de Tasɩ. Banabasɩ jɛɛ ɔ 'sʋ, ɔ ke ɔ jiɛ Antiɔsɩ de. ");
INSERT INTO wob_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","'De ‑sʋn due' ‑nɛ 'di ɛ, ʋʋ ke Kea ‑gbu beeɛ o ‑wɛe ʋʋa 'kɩɩɛn nyiɔpʋ ‑tuu\"‑tuu \"jrui 'de ʋʋa tɔɔ ʋʋpʋ Kea 'a wlu. 'Bo Antiɔsɩ mɔ ʋʋ 'daa‑ Sesi 'a dboʋn Kletiɛn \"i‑saa nɔ\". ");
INSERT INTO wob_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","'De ɛɛ' nɔ\" tu 'di ɛ, Kea 'a wlu 'kwajaaʋn jrʋ' 'wlʋɛ 'o Selisalɛm ‑wɛe ʋʋ mu Antiɔsɩ. ");
INSERT INTO wob_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Ʋʋa' due' 'a 'nynɩ ‑nɩ Akabisɩ. Ɔmɔ Kea 'a ‑Suu po ‑je o, 'de ka 'mɩɩɛ‑ klaa\" 'jea ji 'de 'blʋa‑ ‑wee' \"klein \"kpei ɛ, ‑ɔ ‑tmʋ ɩ. Ɛɛ' 'mɩɩɛ‑ tu ji' kan' ‑cɛɛn'‑, Klodɩ 'a 'blʋajei nɩ nɔ\". ");
INSERT INTO wob_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Klai\" nynuu ‑wee' poɛ wlu ‑tadue, ‑wɛe dɛ jrɔ' 'blea ɔ 'je ɛ ja‑, 'de ʋʋ 'je ʋʋa' de 'di‑wi\" ‑nɩa 'e Suide kwa wɔi ‑te'. ");
INSERT INTO wob_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Ɛmɛ ʋʋ nʋ ‑wɛe ʋʋ dbo Banabasɩ ke Sɔo, 'de ʋʋ kpa ‑paan' ‑nɩa 'mʋa‑ Kea ‑gbu ‑jeopoʋn ‑nɩa 'e Suide ɛ. ");
INSERT INTO wob_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","'De nɔ\" due' ‑nɛ 'di ɛ, 'beɔ Erodɩ ‑teɛ Kea ‑gbu 'kle ‑tua\" ‑pʋn\". ");
INSERT INTO wob_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Ɔ 'dbaa San 'a de'di Sakɩ ‑cnɛ \"i. ");
INSERT INTO wob_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","4","Ɔ 'jea kan' ka dɩ ɔɔ nʋa nmɔa 'e Suifʋ‑wi\" 'di wɔn ɛ, ɔ kpʋn Piɛi 'mɛ 'bo ‑di'pɛn ‑sea' ‑puun\"‑ dɛ o mu 'a ‑kɔ' 'ɔ 'wɩ o, ɔ po ɔ ‑kaso 'di, 'de ɔ ‑teɛ' ɔ \"sʋɩ ‑nyiiɛ 'ɛ kpɛ ‑nyiiɛ 'dei ‑ʋʋa fuo ɔ i, ‑wɛe ‑bo Pakɩ 'a ‑kɔ' 'wlʋ 'o ‑jei\" ɛ, 'de ɔ 'je ɔ 'e nyʋ \"juɔi kpa. ");
INSERT INTO wob_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Ʋʋ ‑teɛ Piɛi 'dei 'de ‑kaso 'di, 'kaa Kea ‑gbu a 'kɩɩɛn \"jrui ‑wɛe ʋʋa bae ɔɔ' Kea 'de nai\" 'blea' 'ʋn. ");
INSERT INTO wob_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","\"Maʋwɩ ‑bo ‑ɛ ‑wlʋ 'o ‑jei\" ‑wɛe Erodɩ 'jea Piɛi 'de nyʋ \"juɔi kpa a, Piɛi a 'mʋʋ 'bo \"sʋɩ 'sɔɔn 'nynɩ. Ʋʋ sɔɔn ‑gbaacɩɛ' \"dbi 'sɔɔn i, ‑wɛe ‑kasogbu i fuoʋn‑wi\" ‑mʋ a fuo kpaa\" i 'bo ‑kasogbu \"wɔin. ");
INSERT INTO wob_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Ʋʋa ‑gbʋan 'emu 'sʋ Kea 'a \"soai due' ‑taan' 'sʋ ‑ta ‑wee' nɩɛ \"puu 'de ‑kasogbu 'a wɔn 'di. Kea 'a \"soai bla Piɛi ‑pʋn\" ‑wɛe ɔ ‑sɔ \"nyɩɔ' 'de ɔ 'na : ‑Ɩn ‑sɔn 'ʋn ‑too\"‑ ! Piɛi sɔan 'ʋn 'sʋ ‑gbaacɩɛ' \"dbi 'wlaa. ");
INSERT INTO wob_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","'Sʋ Kea 'a \"soai wlu ɔ ‑pee ɔ 'na : ‑Ɩn bla ‑ma wlʋ 'di. ‑Ɩn ‑paa ‑ma \"kwlai bʋ'. 'Sʋ 'kamɔ Piɛi nʋ, ‑wɛe Kea 'a \"soai 'na : ‑Ɩn ‑wla ‑ma tae' \"kpei‑ 'de ‑ɩn ‑je 'bo 'ɩn 'de bla. ");
INSERT INTO wob_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Piɛi \"sia \"kpae' 'sʋ ɔ bla 'o Kea 'a \"soai 'de, 'kaa dɩ \"klein Kea 'a \"soai nʋa 'mʋa‑, ɔɔ' 'wɔn 'e ɩ 'dei 'mii, ka nyɔ ɔ jaa ja 'ka ɩ nɩ 'de ɔ 'ʋn. ");
INSERT INTO wob_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","‑Ta ʋʋ ‑sia' nyʋ ‑ʋʋa fuɔ i 'a \"i‑saa ‑nɔ ke ʋʋa' 'sɔɔn ‑nɔ i, ‑wɛe ʋʋ jɛɛa ‑kasogbu 'a nɩɩɛkpaa\" ‑mɛ 'sʋ ɛɛ' ‑cɛ\" ‑kain 'bo ‑gbɛin\" ‑wɛe ʋʋ \"si 'o ‑jei\". 'Bo ɛ \"sri Kea 'a \"soai je 'o Piɛi 'de 'wlʋ. ");
INSERT INTO wob_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Piɛi \"jri 'de cɛɛan i 'sʋ, ɔ 'na : 'Ɩn 'je kan' ‑wɛ‑ la ‑cɛɛn' ka Tʋ\"bo dboa ɛɛ' \"soai 'de ɔ seie 'ʋn 'de Erodɩ ke dɩ \"klein nyiɔpʋ a \"plian ʋʋ 'jea 'ʋn \"jrii nʋ 'kwa. ");
INSERT INTO wob_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Ɔ naa tɔ' i ‑paii 'sʋ, ɔ kpʋɛn 'e San ʋʋa 'daa Makɩ de Madi o ‑gbɛin\" ‑je i. Nyʋ ‑tuu\"‑tuu ‑kɩɩɛn' \"jrui 'demu ‑wɛe ‑ʋʋa bae Kea. ");
INSERT INTO wob_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Piɛi nynia 'o ‑gbɛin\" ‑jei\" 'sʋ ɔ ‑teɛ klu blaa' ‑pʋn\". Dbonʋ nynɔkpao' due' ‑ʋa 'nynɩ nɩa Rodɩ 'kpaa' 'o klu ‑pʋn\" ‑wɛe ʋa po doin\" i. ");
INSERT INTO wob_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Ʋ jua Piɛi 'a wlu \"i 'sʋ 'mʋa‑ \"ji ʋ 'ʋn 'ɛ 'kaa ʋ 'je 'o ‑gbɛin\" kain ɛ ʋ se ‑mɛ nʋ, ʋ kpa plea' ʋ je nyʋ ‑nɩa 'e ‑gbu\" 'di 'tmʋa' mu ʋ 'na : Piɛi ‑a bla klu‑. ");
INSERT INTO wob_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","'Sʋ ʋʋ saa ʋʋ wɔn ja ʋʋ 'na : Sɩɩan ‑a nʋ aʋn ! 'Kaa ʋa 'nyɩɛ \"kpei ʋ 'na : Tɔ' ‑o ‑cɛɛn'‑. 'Sʋ ʋʋ 'na : ‑Mɛ ɔɔ' Kea 'a \"soai ‑o. ");
INSERT INTO wob_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","'De ‑mɛ 'kamɔ Piɛi nɩ klu blaa' sɔɔn‑ sɔɔn‑. Ʋʋ kaian 'o ‑gbɛin\", ʋʋ 'je ɔ 'sʋ tai' \"maa ʋʋpʋ 'mɛ. ");
INSERT INTO wob_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Ɔ ‑kaa' ʋʋpʋ kwai\" 'de ʋʋ 'e wlu‑tɩ 'bɔ, ‑wɛe ka Tʋ\"bo nʋa ɔ ‑kaso 'di ‑sa ‑sʋn ɔ po ʋʋpʋ ɛɛ' \"kuan, ‑wɛe ɔ 'na : ‑Bo ao mu ɛ, ‑mɛ ao po Sakɩ ke ‑aa de'di ‑wi\" \"kuan. Ɔ \"sia \"kpae' 'sʋ ɔ muɛ ‑tajrɔ. ");
INSERT INTO wob_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","‑Sɔn' ‑sɩan' 'sʋ, \"sʋɩ a ‑sii 'ʋn 'ɛ crii‑, ‑wɛe dɛ Piɛi ‑snɛɛa 'ʋn ʋʋ 'je ɛ juo‑. ");
INSERT INTO wob_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Erodɩ foo\" 'sʋ ‑teɛ ɔɔ' i ‑pɔan' ‑pʋn\", 'kaa ɔ se ɔ 'je, 'sʋ ɔ ‑teeɛ' ‑kasogbu ifuoʋn i, ‑wɛe ɔ cɛn ʋʋpʋ wlu \"kpei 'de ʋʋ 'e 'mɛ. ‑Mɛ 'wlʋa 'o ‑jei\" ɛ, 'sʋ ɔ 'wlʋ 'e Suide 'mɛ ‑wɛe ɔ mu 'e Sesare, 'de ɔ nʋʋ 'e 'wɩ pla‑. ");
INSERT INTO wob_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Erodɩ 'kpaa Tii ‑nyʋ ke Sidɔn nyʋ 'cɛn i. 'Kaa ‑wi\" ‑mʋ jia ʋʋ ke Blatisɩ ‑ɔɔ fua Erodɩ 'a ‑gbu\" 'a wɔn i 'bɛɛ‑ wlu 'ʋn, ‑wɛe ʋʋ ji ‑gbɩn' cɩan' ʋʋ 'jeɔ \"nyɩ, dɛ‑nʋɛ' diidɩ ‑wee' a 'wlʋɛ 'e ɔɔ' 'blʋa‑ 'di. ");
INSERT INTO wob_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","'Wɩ jrɛ' ‑ɛ ‑tuu\" 'a 'di ɛ, Erodɩ paa ɔɔ' 'beɔdɩ 'ʋn ‑wɛe ɔ ‑te i 'bo ɔɔ' 'beɔkpa‑tɛ \"kpei, 'de ɔɔ 'tmʋʋ ʋʋpʋ wlu ‑pee 'bo nyʋ \"juɔi. ");
INSERT INTO wob_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","'Sʋ nyʋ ‑wee' ‑saa ‑cruɛn\" ʋʋ 'na : ‑Jɛ ‑mɛ Kea ‑wlu, ɛ se nyiɔ nɩ‑. ");
INSERT INTO wob_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","'Kaa 'bo ɛ \"sri Tʋ\"bo 'a \"soai je Erodɩ bla, dɛ‑nʋɛ' ɔ se Kea 'a ni' ‑te'. cɩaɩn\"‑ 'a 'sʋ ‑paa ɔ \"jɛi ɔ je 'mɛ. ");
INSERT INTO wob_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","'De ‑mɛ 'kamɔ Kea 'a wlu a 'tmʋʋɛ, ɛɛ ‑kɔ' 'blʋa‑ ja ‑wɛe klai\" nynuu a 'kpaa \"kpei sɔɔn‑ sɔɔn‑ ʋʋa ‑tii\". ");
INSERT INTO wob_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Banabasɩ ke Sɔo ‑kɔa' dɛ ‑ɛɛ ‑tɩ' ʋʋ mua \"i 'de Selisalɛm 'sʋ ɛ, ʋʋ muɛ Antiɔsɩ de, ʋʋ ke San Makɩ ke‑. ");
INSERT INTO wob_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","'De Antiɔsɩ Kea ‑gbu 'di ɛ, Kea 'a wlu 'kwajaaʋn ke nyʋ Kea 'a wlu tɔɔʋn ‑nɩ 'emu, Banabasɩ o Simeɔ ʋʋa 'daa‑ nyiɔ ‑jre o, Lisisɩ ‑ɔ ‑wlʋa Sirɛnɩ o, Manaɩn ‑ɔ ‑ke ‑gbʋa'na Erodɩ ‑sa \"nynue' ‑tadue o Sɔo ke‑. ");
INSERT INTO wob_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","'Wɩ jrɛ' o, ‑ta ʋʋ nɩa Kea baea' ‑wɛe ʋʋ 'bɔa wɔn ɛ, Kea 'a ‑Suu wlu 'de ʋʋ ‑pee ɛ 'na : Ao ‑tee Banabasɩ ke Sɔo kpɔi\" ‑wɛe dbo ‑ɛɛ 'daa' 'ɩn 'dʋʋpʋ ɛ, ʋʋ 'je ɛ nʋ. ");
INSERT INTO wob_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Ʋʋ ‑kɔa' wɔn 'bɔa' ke baea' 'sʋ ʋʋ ‑teɛ Banabasɩ ke Sɔo kwa \"jru 'de ʋʋ \"tai‑ ʋʋpʋ \"i ‑wɛe ʋʋ mu. ");
INSERT INTO wob_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Banabasɩ ke Sɔo Kea 'a ‑Suu dboa, ʋʋ muɛ 'o Selesi, 'bomɔ ʋʋ \"duo‑ ‑bato' 'ʋn ‑wɛe ʋʋ mu 'e Siprʋ. ‑ɛ ‑nɩa 'e 'tɔniɛ 'a ‑kwea'‑. ");
INSERT INTO wob_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Ʋʋ nynia 'o Salaminɩ ‑kwlɔ 'di 'sʋ ɛ, ʋʋ 'tmʋɛ Kea 'a ‑tɩ' 'de Suifʋ‑wi\" 'a \"jrui 'kɩɩn‑gbi 'di i. San Makɩ mɔ ‑ɔɔ ‑te' ʋʋpʋ kwa wɔi. ");
INSERT INTO wob_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Ʋʋ ‑gbee' ɛɛ' 'blʋa‑ tu 'mɛ ʋʋ je ɛ 'ʋn ‑tie\" cɛn, ‑wɛe ʋʋ mu mamaʋ 'sʋ ʋʋ nyni Pafɔsɩ, 'bo ʋʋ jɛɛ jrii' poi due', ‑ɔɔ 'nynɩ ‑nɩ Baasesi. Ɔ nɩɛ Suifʋi ‑o, ‑wɛe ɔɔ 'daa‑ ɔɔ' ‑cɛ\" Kea 'a wlu 'kwajaai. ");
INSERT INTO wob_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","'Bo Sɛsisɩ Polisɩ ‑ɔ ‑nɩa 'blʋa ‑nɛ 'ɛ jei ‑pʋn\" 'bo ɔ ‑te i. ‑Mɔɔ' 'blʋajei tu nɩɛ tɔ'di, ɔ 'da Banabasɩ ke Sɔo 'mɛ, ‑wɛe ɔ 'na : Kea 'a wlu doin\" o poa 'a 'tʋn a nʋ 'ʋn 'ɛ. ");
INSERT INTO wob_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","'Kaa Baasesi ‑ɔɔ poa jrii' ‑nɔ (ɔɔ' 'nynɩ ‑nɩ Elimasɩ 'de Klɛkɩwlu 'ʋn) ɔɔ' 'wɔn ʋʋa' po wlu i, dɛ‑nʋɛ' ɔɔ ‑pɔn ɔ 'e 'blʋajei 'a \"jru ‑jei\" ‑saa 'de Kea ‑kwlɩ\" ‑tetɩ 'ʋn. ");
INSERT INTO wob_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","'Sʋ Sɔo ‑ɔɔ 'nynɩ nɩa Pɔo ‑ke ɛ, ‑wɛe Kea 'a ‑Suu \"jia 'ʋn ɛ, ɔ \"siiɛ jrii' poi ‑nɔ \"jriɛ‑ ");
INSERT INTO wob_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","'De ɔ 'na : ‑Ɩn ‑gbʋn ka ‑ma nyiɔ 'ɔ \"kwli tu 'blea 'srɛ ‑wɛe ‑ɩn ‑nyniia 'di wɔn ɛ, ‑mɔ ‑siɔn' 'ɔ \"ju ‑ɔ ‑nɩa dɛ 'dɔe 'a tʋ o ‑fɔin ɛ, Tʋ\"bo 'a ‑je ‑srɛai\" ‑ɩn se ɛɛ' 'ʋn ‑klɛɛntɩ 'bɔi ‑wee'‑ ? ");
INSERT INTO wob_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Kaan ka la Tʋ\"bo a jiɛ ‑ʋn sʋn ‑pʋn\" kpaa', ‑ma muɛ \"dɔa' ‑wɛe ‑ɩn se 'jrʋ i 'jei 'de nɔ\" pla 'di. 'Bo ɛ \"sri kwiekpan je 'e Elimasɩ \"jri 'de kaan‑, ‑wɛe ɔɔ bli i, ɔɔ ‑pɔn nyɔ ‑ɔ ‑jea ɔ ‑cɩɛi\" kpʋn i. ");
INSERT INTO wob_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","'Blʋajei ‑nɔ 'jea dɛ ‑nʋʋa 'mʋa‑ 'sʋ ɔ 'jeɛ Tʋ\"bo 'a ‑tɩ' tɔ' 'ʋn, dɛ‑nʋɛ' wlu ɔ 'wɔan a, ɛ ‑si\" 'ɔ \"i. ");
INSERT INTO wob_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Pɔo ke ɔɔ' \"dɛi‑wi\" 'kpa ‑bato' 'di 'bo Pafɔsɩ ‑wɛe ʋʋ mu Pɛɛse 'de Pamfili. 'Bomɔ San Makɩ ke ʋʋ ‑seea' i ‑wɛe ‑mɔ mu Selisalɛm de. ");
INSERT INTO wob_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","'Bo Pɛɛse ‑nɔ 'bomɔ ʋʋ 'wlʋ ‑wɛe ʋʋ mu Antiɔsɩ jrɛ' ‑ɛ ‑nɩa 'e Pisidiblʋa \"kpei ɛ, 'de ʋʋ pa 'e Suifʋ‑wi\" 'a \"jrui 'kɩɩn‑gbu 'di ‑kwlewɩ o, ‑wɛe ʋʋ ‑tei. ");
INSERT INTO wob_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Ʋʋ ‑kɔa' Kea 'a kɛ' ke dɩ Kea 'a wlu 'kwajaaʋn 'tmʋa 'a ‑sroa' 'sʋ \"jrui 'kɩɩn‑gbu 'a ‑jeopoʋn dboɛ Pɔo ke Banabasɩ nyʋ \"i ‑wɛe ʋʋ 'na : ‑Bo ao 'ble wlu ao 'jea 'tmʋ 'de ‑a ‑pee ‑wɛe ‑ɛ ‑jea ‑aa dɩ 'o \"sii ɛ, ‑mɛ ao 'bɛɛ‑ ao 'je wlu la. ");
INSERT INTO wob_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","'Bomɔ Pɔo sɔɔn 'ʋn ‑wɛe ɔ ‑kaa' nyʋ kwai\" 'de ɔ wlu ka : Israɛ‑kɔʋn, 'de ao nyʋ ‑ɔɔ pleea Kea ke ao ‑wee' po doin\" i. ");
INSERT INTO wob_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Kea ‑ɛ ‑nɩa Israɛ‑nyʋ 'a Kea a, ɛ ‑sa 'o ‑a \"bo ‑wi\" 'mɛ ‑ta ʋʋ nɩɩa 'de 'blʋa‑ 'srʋ nyʋ a 'daa‑ Esipʋ 'di ɛ, ɛmɛ ‑nʋɛ' ‑wɛe ʋʋ ‑gbɛn' 'de ʋʋ ‑tii\". ɛmɛ ‑sa ʋʋpʋ 'emu 'de ɛɛ' \"ikmasʋn 'ʋn. ");
INSERT INTO wob_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","‑Wɛe ɛ ‑gbaan ʋʋpʋ mamaʋ 'sʋ 'de ‑sɩn 'a kwla ‑nyiiɛ 'di 'bo ‑pɩɩɔn\" blʋa \"kpei. ");
INSERT INTO wob_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","'De ɛ ‑sa 'blʋa 'a blo' wɔn ‑mɛ\" 'sɔn i 'de Kananblʋa \"kpei ‑wɛe ɛ \"nyɩ ɛɛ' 'blʋa‑ tu ‑a \"bo ‑wi\" 'de ɛ nɩ ʋʋpʋ 'a dɛ. ");
INSERT INTO wob_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","‑Mɛ 'wlʋa 'o ‑jei\" ɛ, ɛ 'bɛɛ‑ ‑sɩn 'a kmɛ' ‑nyiiɛ kwla ‑mm\" ‑wɛe ɛ ‑te' ʋʋpʋ 'pee 'jeʋn \"jru kpɔ' i mamaʋ 'sʋ ɛ je Kea 'a wlu 'kwajaai Samiɛlɩ jɛɛ‑. ");
INSERT INTO wob_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","'Bo ‑mɛ 'de ɛ, ʋʋ ‑teeɛ 'beɔ i ‑wɛe Kea \"nyɩ ʋʋpʋ Kisɩ 'a \"ju Sauilɩ ‑ɔ ‑wlʋa 'e Bɛnsamɛ 'ɛ \"ji 'di ɛ, ‑wɛe ‑mɔ 'ble ʋʋpʋ mamaʋ 'de ‑sɩn 'a kwla ‑nyiiɛ 'di. ");
INSERT INTO wob_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","'Sʋ Kea poɛ Sauilɩ i ‑wɛe ɛ \"nyɩ ʋʋpʋ Dafidɩ 'de ‑mɔ nɩ ʋʋa' 'beɔ. 'De Dafidɩ 'a ‑tɩ' 'ʋn ɛ wlu' ka ɛ 'na : 'Ɩn 'je isai 'a \"ju Dafidɩ ‑wɛ‑, ɔɔ' nyiɔ tu nmɔɔ 'de 'ʋn \"jri 'dei. Ɔmɔ ‑ɔɔ mu 'ma 'tʋn nʋ‑tɩ ‑wee' \"klein nʋa'. ");
INSERT INTO wob_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","'De Dafidɩ 'a \"ji 'di mɔ Sesi 'wlʋʋ‑, ‑wɛe Kea ‑te' ɔ 'o, 'de ka ɛɛ' ‑cɛ\" 'kpa cɛn a ɛɛ' wlu ‑tie\" sese 'de ɔ nɩ Israɛ nyʋ 'a 'pʋʋ i. ");
INSERT INTO wob_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","‑Ta Sesi sea 'wlʋʋ ke ɛ, San Batisɩ wlu' ka 'de Israɛ‑kɔʋn ‑wee' \"klein ‑pee ɔ 'na : Ao juo aoa' dɩsaɩn \"i, ao \"biia 'e Kea o, 'de aoa' \"ni \"jru pooɛ‑. ");
INSERT INTO wob_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","‑Ta San 'a 'kmʋ 'wlʋ nɔ\" ɔ \"kʋʋan i ɛ, ɔ wlu' ka ɔ 'na : 'Ɩn se \"ju aoa naa tɔ' \"kpei aoa fua nɩ‑, 'kaa ao ‑gbʋn 'nɔ, ɔɔ ji' 'de 'ʋn 'de. Ɔɔ' \"ju tu ɛ, 'ɩn se ɔɔ' \"kwlai 'a \"dbu ‑pɔn' i ka nɩ‑. ");
INSERT INTO wob_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","'Ma de'di ‑wi\", ao ‑nɩa Ablaam 'a \"nynuu‑ ɛ, 'de aopʋ ‑ɔɔ pleea Kea ke ɛ, aopʋ Kea ja 'pʋwlu ‑nɛ. ");
INSERT INTO wob_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","'Kaa dɛ Sesi nɩa 'ʋn ɛ, nyʋ ‑nɩa Selisalɛm ke ʋʋa' klae\" ‑wi\" se ɛ 'mii 'wɔn, ‑wɛe ʋʋ se wlu \"klein Kea 'a wlu 'kwajaaʋn 'tmʋa 'de ‑ɩa nʋʋa 'dii ‑kwlewɩ \"o ‑kwlewɩ \"kpei ɛ, ʋʋ sɩ 'mii 'wɔn ‑ke, 'kaa ʋʋ nynia 'o ɩa' wlu tu 'mɛ 'de Sesi 'a 'dbaa' 'ʋn. ");
INSERT INTO wob_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Ʋʋ ‑teeɛ' Pilatɩ i ‑wɛe ‑mɔ 'je ɔ 'dba, 'de ‑mɛ 'kamɔ dɛ ‑jea ɔɔ' 'mɛa' 'je, ɛ se 'nynɩ kɔn‑. ");
INSERT INTO wob_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Dɩ \"klein ‑ɩ ‑crɩɩa' 'de ɔɔ' ‑tɩ' 'ʋn ʋʋ ‑kɔa' ɩa' 'bo nynia' 'sʋ ɛ, ʋʋ ‑sɔ 'o tu ‑kwlɩ\" 'mɛ, ‑wɛe ʋʋ ‑teɔ' i 'de ‑gbaɩn' 'di. ");
INSERT INTO wob_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","'Kaa Kea ‑sɔ 'de 'mɛʋn \"klu ‑wɛe ɛ jɔ 'kmʋ de. ");
INSERT INTO wob_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","'De 'wɩ ‑tuu\" 'di ɛ, Sesi to ɔɔ' ‑cɛ\" 'mɛ 'de nyʋ ‑ʋʋ ‑ke ɔ ‑sa naa' 'de Galile mamaʋ ‑wɛe ‑ʋʋ nynia Selisalɛm ‑pee. Ʋʋa' nyʋ tu ɛ, ʋʋpʋ ‑nɩ ɔɔ' ‑tɩ' 'a ‑ta 'jeʋn kaan ‑wɛe ‑ʋʋa ‑tmʋɩ 'de israɛ‑nyʋ ‑pee. ");
INSERT INTO wob_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","33","‑Pɔia\" ‑tɩ ‑a jia ao 'tmʋa', ɛ ka : Dɛ Kea 'tmʋa 'de ‑a \"bo ‑wi\" ‑pee ɛ, ‑apʋ ‑ɔ ‑nɩa ʋʋa' \"nynuu‑ ɛ, ‑apʋ ‑je ɛɛ' 'o nyni ‑ta. Kea ‑nɛ mɛ ‑ja Sesi 'kmʋ de, ka ɛ 'crɩɩa 'de Dafidɩ 'a 'dʋ 'a 'sɔɔn ‑nɛ 'di. Ɛɛ' wlu tu 'na : ‑Ɩn ‑nɩɛ 'ma \"Ju ‑o, 'ɩn 'wlʋ ‑ʋn ‑ɛ ‑wɛ‑ ‑sɩan. ");
INSERT INTO wob_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","Ka Kea 'je ɔ \"kunyɩɔ' ‑sa ‑wɛe ɔɔ' \"ku sea ‑sɔan' \"i blai ɛ 'tmʋɛ sese, ɛ 'na : 'Ma \"diwan ‑cɛɛn'‑ 'ɩn \"sia 'nynɩ 'de Dafidɩ ‑pee 'de ɛ, 'ma muɛ aopʋ‑ ɛ \"nyɩa' see. ");
INSERT INTO wob_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Ɛmɛ ‑tɩ ɛ 'nyɩɛ \"kpei‑ ka 'de Dafidɩ 'a 'dʋ jrɛ' 'di ɛ 'na : \"Ju ‑ɔ ‑nɩa ɛɛ' nyɔ ɛ, ɛ se ɔɔ' ‑sɔn' ‑tɩ 'wɔɔin. ");
INSERT INTO wob_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","'De Dafidɩ ‑mɔ ɛ, ɔ nʋʋ Kea \"juɔi 'mɛ 'de ɔɔ' ‑nɛ nɔ\" 'di, 'sʋ ɔ 'mɛɛ, ‑wɛe nyʋ nmae ɔ i 'bo ɔ \"bo ‑wi\" ‑pʋn\", 'de ɔ ‑sɔn'. ");
INSERT INTO wob_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","'Kaa \"ju ‑jɔ Kea ja 'kmʋ de, ‑mɔ se ‑sɔan. ");
INSERT INTO wob_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","Ɛmɛ ‑tɩ 'ma de'di ‑wi\", dɛ ao 'jea juo ɛmɛ ‑nɩ 'de Sesi 'ʋn mɔ dɛsaʋn 'a ‑kwɛ‑tɩ a 'tmʋʋɛ 'de ao ‑pee. ");
INSERT INTO wob_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","'De nyɔ \"o nyɔ ‑jea ɔɔ' ‑tɩ' tɔ' 'ʋn ɛ, ‑mɛ dɩsaɩn ‑ɩ 'kwa Moisɩ 'a kɛ' sea nyʋ ‑seia' 'bɛɛ‑, ɔ seie nyʋ 'mɛ 'de ɩ 'kwa. ");
INSERT INTO wob_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Ao ‑tu\" aoa' ‑cɛ\" 'ɛ ‑tɩ' dɩ Kea 'a wlu 'kwajaaʋn 'tmʋa, ɩ je 'o nyni 'de aoa' ‑tɩ' 'ʋn. Ʋʋ 'naa : ");
INSERT INTO wob_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","Ao ‑gbʋn 'nɔ, ao nyʋ ‑flɛɛan' \"jia 'e 'ʋn ɛ, tai' \"maa aopʋ, ao \"maa 'kwlɩ i, dɛ‑nʋɛ' dɛ 'ma mua nʋa' 'de aoa' nɔ\" 'di ɛ, ‑bo nyɔ 'tmʋ ɛɛ' dɛ tu 'de ao ‑pee 'de ɛ, ao se ɛ tɔ' 'ʋn 'jei. ");
INSERT INTO wob_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Pɔo ke Banabasɩ ‑kɔa' wlua' ‑wɛe ʋʋ \"sia \"kpae' ɛ, ʋʋa bae ʋʋpʋ i ʋʋ 'je 'de ji ‑kwlewɩ ‑ɛɛ mua nynia' \"kpei, 'de ʋʋ 'je dɩ due' ‑nɛ 'tmʋ ke'wlɛ. ");
INSERT INTO wob_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","\"Jrui 'kɩɩan' 'wlʋa 'o ‑jei\" ɛ, Suifʋ 'a ‑tuu\"‑tuu ‑ke nyʋ ‑ʋʋ ‑kpa ʋʋpʋ o ɛ ʋʋ bla 'o Pɔo ke Banabasɩ 'de, ‑wɛe ‑wi\" ‑mʋ a kuu ʋʋpʋ 'a dɩ i, 'de ʋʋ 'je Kea 'a 'saaʋn 'a ‑tɩ' ‑kli kpʋn. ");
INSERT INTO wob_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","‑Kwlewɩ ‑tba' 'o ɛ, ‑kwlɔ ‑wee' ‑kwɛ‑ de, ‑wɛe ʋʋ ji Kea 'a wlu doin\" o poa'. ");
INSERT INTO wob_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Suifʋ‑wi\" 'jea nyʋ ‑nʋ 'a \"i‑tisʋn kaan 'sʋ \"cɛi nʋa' \"ji 'de ʋʋpʋ 'ʋn 'ɛ. 'Sʋ dɛ Pɔo a 'tmʋa ʋʋa ‑tuɛ\" ‑tɩ' ‑kɔ' o i, ‑wɛe ʋʋa ‑cree\" ɔ. ");
INSERT INTO wob_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","'Bomɔ Pɔo ke Banabasɩ \"duo‑ 'kpɩ 'ʋn ‑wɛe ʋʋ wlu ka ʋʋ 'na : 'De aopʋ ‑pee mɔ Kea 'a wlu 'je 'tmʋʋɛ tɛin\" 'de‑, 'kaa ka aomɔ ɔ ‑fuun ɛ nya ‑wɛe ao 'na ao se 'kmʋ dee 'a ‑tɩ' 'wɔɔin 'ja a, ‑mɛ ao se ɛɛ' ka nɩ, ‑mɛ ‑apʋ mɔ muɛ 'e nyʋ sea' Suifʋ nɩ o, ");
INSERT INTO wob_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","'kamɔ Tʋ\"bo 'tmʋɛ 'de ‑a ‑pee, ɛ 'naa : 'Ɩn ‑te 'o ‑ʋn ‑ɛ, 'de ‑ɩn ‑je 'blʋa 'a ‑sɔn' nɩ, ‑wɛe ‑ɩn ‑je 'pʋʋa' 'a ‑tɩ' 'de 'blʋa 'a \"ti 'ɩn kpa. ");
INSERT INTO wob_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Nyʋ ‑sea' Suifʋ nɩ 'wɔan wlu ‑nɛ 'sʋ ʋʋa nʋɛ 'mʋa‑, ʋʋa poɛ Kea 'a wlu ‑tɩ' o. Nyʋ \"klein ‑ʋʋ ‑nʋʋa 'de 'kmʋnɩa' ‑sea' ‑kwɛ ‑ta 'ble 'a ‑tɩ' 'ʋn ɛ, ʋʋ ‑wee' 'jeɛ Sesi 'a ‑tɩ' tɔ' 'ʋn. ");
INSERT INTO wob_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Kea 'a wlu ‑kɔ' Pisidiblʋa ‑wee' \"klein ja. ");
INSERT INTO wob_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","'Kaa dɛwɔnɩnynʋkpae' ‑ʋʋa ni' nyʋ ‑wee' a ‑tea' ‑wɛe ‑ʋʋa ‑gbɛɛa' Kea ke nyʋ ‑nɩa nyʋ \"jrukpɔ' i ‑teʋn 'bo Antiɔsɩ ɛ, ʋʋpʋ Suifʋ‑wi\" paa ʋʋ bɩ ‑sɔn, ‑wɛe ‑ʋʋ ‑te' Pɔo ke Banabasɩ 'a 'kle ‑tu\" 'a ‑pʋn\", 'de ʋʋ nʋ ʋʋpʋ i 'de ʋʋa' 'blʋa‑ 'di. ");
INSERT INTO wob_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Pɔo ke Banabasɩ ‑gbao' ɛ ʋʋa' ‑kwlɔ 'ɔ \"puue' ‑nɩa ʋʋ bʋ i ɛ, ‑wɛe ʋʋ mu Ikɔnɩ. ");
INSERT INTO wob_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","'Kaa nyʋ ‑jea Sesi 'a ‑tɩ' tɔ' 'ʋn ɛ, Kea 'a ‑Suu ‑nɩ 'de ʋʋpʋ 'ʋn ‑wɛe 'mʋa‑ a nʋ ʋʋpʋ. ");
INSERT INTO wob_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","'Bo Ikɔnɩ ɛ, Pɔo ke Banabasɩ muɛ 'e Suifʋ‑wi\" 'a \"jrui 'kɩɩn‑gbu 'di ‑ke, ‑wɛe ʋʋ 'tmʋ Kea 'a ‑tɩ', 'sʋ Suifʋ o, Glɛkɩ‑wi\" 'a nɩ 'a ‑tuu\"‑tuu ‑je Sesi 'a ‑tɩ' tɔ' 'ʋn. ");
INSERT INTO wob_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","'Kaa Suifʋ jrʋ' ‑ʋʋ ‑nao\" 'a Sesi 'a ‑tɩ' tɔ' 'ʋn 'je ‑tɩ ɛ, ʋʋ paa nyʋ ‑sea' Suifʋ nɩ bɩ ‑sɔn 'de Pɔo ke Banabasɩ 'a ‑tɩ' 'ʋn ‑wɛe ʋʋ 'je ʋʋpʋ dɛsaʋn \"jrii nʋ. ");
INSERT INTO wob_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","'Kaa Pɔo ke Banabasɩ ‑kwle 'o Ikɔnɩ 'mɛ kpɩɩn‑, ʋʋ ‑teɛ' Tʋ\"bo ‑kwlɩ\" ‑sisi' ‑wɛe ʋʋ 'pɛn 'e Tʋ\"bo jai 'de ʋʋa wlu. Ka 'saaʋn 'a ‑tɩ' ʋʋa 'tmʋa ɩ nɩa tɔ' ɛ, Tʋ\"bo 'a ‑cɛ\" 'kpa a to ɛɛ' sʋn 'mɛ 'de jrii' ke dɩ klae\" klae\" ʋʋa nʋa 'ʋn. ");
INSERT INTO wob_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Ɛɛ' dɛ tu nʋɛ' nyiɔpʋ ‑nɩa 'o Ikɔnɩ ʋʋ je 'ʋn ‑seea', jrʋ' nɩɛ 'e Suifʋ‑wi\" 'a 'fɔ o, ‑wɛe jrʋ' nɩ 'e Sesi 'a dboʋn 'a 'fɔ o. ");
INSERT INTO wob_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","'Sʋ Suifʋ ke nyʋ ‑sea' Suifʋ nɩ 'a klae\" ‑wi\" poɛ wlu ‑tadue ‑wɛe ʋʋa nmae dɩ 'de ʋʋ 'je Pɔo ke Banabasɩ 'kwa nynii ‑wɛe ʋʋ 'je ʋʋpʋ \"soi i tbaa‑. ");
INSERT INTO wob_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","Ɩ 'kpa 'e Pɔo ke Banabasɩ doun\" 'sʋ ʋʋ muɛ 'e Likaoniblʋa 'a ‑kwlɛ ‑ɩa 'nynɩ nɩa Litrɩ ke Dɛɛbʋ ke ɛ ‑kwlɛ jrɩ' ‑jia' ɩ 'dei 'dii. ");
INSERT INTO wob_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","‑Wɛe ʋʋ ‑te ‑pɔia\" ‑tɩ 'tmʋa' ‑pʋn\" 'de ɩa' ‑kwlɛ tu 'dii. ");
INSERT INTO wob_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","'Bo Litrɩ ɛ, \"ju due' ‑nɩ 'o ‑ɔ ‑te 'blʋɔi ‑crɔɔn', dɛ‑nʋɛ' ɔɔ' bɩ 'mɛɛ, ɔ klɔɔ' dɛ ‑tba' 'e ɔɔ' 'wlʋ nɔ\" o, ɔ se na due'. ");
INSERT INTO wob_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","Dɛ Pɔo a 'tmʋa ɔɔ po ɛ doin\" o, ‑wɛe Pɔo \"si ɔ \"jriɛ‑ 'sʋ ka ɔ ‑tea Kea ‑kwlɩ\" ‑wɛe ɛ 'bɛɛa ɛ 'jea ɔɔ' 'wɛ‑ 'bɔɔ‑ ɔ 'jeɛ 'de ɔ 'ʋn. 'Sʋ ɔ kpa wlu \"jɛi 'de ɔ ‑pee ɔ 'na : ");
INSERT INTO wob_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","‑Ɩn ‑sɔn 'ʋn, ‑ɩn ‑srɛi\", ‑ɩn ‑je ‑ma bɩ \"kpei nyna ! 'Sʋ \"ju ‑nɔ ‑pliin\" ɛ ɔɔ' bɩ \"kpei kpleiin ‑wɛe ɔ ‑te naa' ‑pʋn\". ");
INSERT INTO wob_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","‑Ta nyʋ ‑kaan ʋʋpʋ 'de 'jeea dɛ Pɔo nʋa \"jriɛ‑ 'sʋ, ʋʋ ‑saa ‑cruɛn\" 'de Likaoniwlu 'di ʋʋ 'na : Nyʋ ‑jʋ ‑mʋ ‑kɩɩ' ‑snɛɛ nyiɔ 'ʋn ‑wɛe ‑ɩ ‑si\" i 'de ‑ɩ ji ‑a \"i ‑teea', ‑mɛ se nyiɔpʋ nɩ‑. ");
INSERT INTO wob_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Ʋʋ 'daa‑ Banabasɩ Sipitɛɛ ‑kea, ‑wɛe ʋʋ 'daa‑ Pɔo Mɛɛkii ‑kea, dɛ‑nʋɛ' Pɔo mɔ ‑ɔɔ ‑sa wlu' i. ");
INSERT INTO wob_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","'Sʋ ʋʋa' kɔun ‑ɛɛ ‑gbu\" nɩa 'o ‑kwlɔ ‑sɔn ʋʋa 'daa‑ Sipitɛɛ ɛɛ' 'sraa ‑sai \"duɛ bli' 'ʋn ‑wɛe ɔ blɩ ‑gbɩn' 'di. 'Sʋ ɔ kpɩ 'e ‑kwlɔ 'ɔ kpae\" \"wɔin, ɔ ke nyiɔpʋ a ‑pɔn ʋʋ 'jɩ 'sraa‑ ‑sa ʋʋ 'e Banabasɩ ke Pɔo \"nyɩ. ");
INSERT INTO wob_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Ɩmɩ Sesi 'a dboʋn Banabasɩ ke Pɔo 'wɔn 'sʋ ʋʋ 'faeɛ ʋʋa' 'ʋnpaadɩ i ‑wɛe ʋʋ kpa plea' 'de nyʋ ‑kwea 'de \"wɔɔa' 'ʋn ʋʋ 'na : ");
INSERT INTO wob_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","'Oo nyiɔpʋ, dɛɛ‑tɩ aoa nʋ kan' ‑mɔ' ɛ ? ‑Amɔ se Kea nɩ‑, ‑a ‑nɩɛ nyiɔ ‑o ‑ke ka ao nɩa, ‑wɛe ‑a ‑ja aopʋ ‑pɔia\" ‑tɩ. ‑Aa ‑da aopʋ 'mɛ ‑wɛe ao 'je dɩ ‑gbai\" ‑nɩ kwa ‑sɔn ‑saa‑, 'de ao 'je 'e 'kmʋnɩ Kea o \"biie‑. Ɛmɛ ‑nʋ' 'blʋa‑ ke jaʋn ke, 'tɔniɛ ke dɩ \"klein ‑nɩa 'e ɛ ‑sɔn ke‑. ");
INSERT INTO wob_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Ɛɛ' Kea tu tɛin\" ɛ, ɛ \"taiɛ 'blʋa‑ ‑wee' \"i, ʋʋa jea ʋʋa' ‑nɛ 'tʋnnʋ ‑je kpa. ");
INSERT INTO wob_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","'Kaa ɛɛ to ɛɛ' ‑cɛ\" 'mɛ jeejee 'de dɩ 'dɔe ɛɛ nʋa nyʋ \"jrii 'ʋn. Ɛɛ dbaa \"ni 'mɛ 'de ao \"kpei, ‑wɛe aoa nʋ ‑tiɔn 'de ɛɛ 'wlʋ dɛ 'ʋn. Ɛɛ \"nyɩ ao diidɛ 'mɛ, ‑wɛe dɛ \"o dɛ jrɛ' 'ɛ ‑pɔn aopʋ 'kwa, 'de ɛɛ \"jii 'mʋa‑ 'de ao pɛe o. ");
INSERT INTO wob_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Wlu Sesi 'a dboʋn 'tmʋa 'mʋa‑, ‑wɛe ʋʋ 'jea nyiɔpʋ ‑nʋ ‑je de kaan 'de ʋʋa' 'sraa‑satɩ 'ʋn ɛ, ʋʋ 'jeeɛ 'kle i. ");
INSERT INTO wob_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","'Sʋ Suifʋ‑wi\" ‑wlʋa Antiɔsɩ ke Ikɔnɩ ‑ji', ‑ʋʋ ‑paa nyiɔpʋ bɩ ‑sɔn, ‑wɛe ʋʋ tbaa Pɔo \"soi 'de ʋʋ \"klɔ i ‑wɛe ʋʋ ‑sɔ 'o ‑kwlɔ. ‑Bo ʋʋpʋ mɔ ɔ sea 'je ɛ, ʋʋ 'na ‑mɛ ɔ 'mɛɛ 'de‑. ");
INSERT INTO wob_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","'Kaa Sesi 'a ‑tɩ' tɔ' 'ʋn 'jeʋn ‑gbae' ɔ 'dei 'sʋ ɔ sɔn 'ʋn 'ɛ, ‑wɛe ɔ mu 'o ‑kwlɔ ‑nɛ 'di de. Ɛɛ' ‑sɔn' jrɛ' ‑sɩn' ɔ ke Banabasɩ muɛ Dɛɛbʋ. ");
INSERT INTO wob_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","'Sʋ ʋʋ 'tmʋɛ Kea 'a ‑pɔia\" ‑tɩ 'bo Dɛɛbʋ, ʋʋ 'je 'o klai\" nynuu ‑tuu\"‑tuu, ‑wɛe ʋʋ mu Litrɩ ke Ikɔnɩ de, 'de ʋʋa jea Antiɔsɩ de mu. ");
INSERT INTO wob_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","Ʋʋ ‑tuɛ\" nyʋ ‑jea Sesi 'a ‑tɩ' tɔ' 'ʋn ‑tɩ' ‑kwlɩ' i, ‑wɛe ʋʋ kuu ʋʋpʋ 'a dɩ i 'de ʋʋ 'je nai\" 'ble 'de Kea ‑kwlɩ\" ‑tea' 'ʋn, ʋʋ 'na : 'De 'kle ‑tuu\"‑tuu 'ʋn mɔ ‑a ‑je cɛɛn‑ ‑wɛe ‑a ‑je Kea 'a tʋ\"bo ‑kwlɔ 'di mu. ");
INSERT INTO wob_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","‑Kwlɔ \"o ‑kwlɔ ʋʋa mua 'dii ɛ, ʋʋa ‑teɛ' nyʋsoa ‑wi\" Kea ‑gbu \"jru kpɔ' i due 'due, ʋʋ ke ʋʋa bae Kea, ʋʋa 'bɔ wɔn ‑tadue, ‑wɛe ‑bo ʋʋ ‑kwɛ‑ ‑mɛ \"i ɛ, ʋʋa ‑teɛ' ʋʋpʋ Tʋ\"bo ‑ɛɛ ‑tɩ' ʋʋ 'jea tɔ' 'ʋn kwa. ");
INSERT INTO wob_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","'Sʋ ʋʋ 'kpa ‑jei\" ‑wɛe ʋʋ cɛn Pisidiblʋa 'ʋn ‑tie\" 'de ʋʋ nyni 'e Pamfiliblʋa \"kpei. ");
INSERT INTO wob_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","Ʋʋ 'tmʋɛ Kea 'a ‑tɩ' 'bo Pɛɛse ‑wɛe ʋʋ cɛn 'o ‑mɔ ‑tie\" 'de ʋʋ mu Atali. ");
INSERT INTO wob_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","'Bomɔ ʋʋ 'jaa ‑bato' ‑wɛe ʋʋ mu Antiɔsɩ ʋʋ 'wlʋa de. 'Bo ɛɛ' ‑kwlɔ ‑tu 'di mɔ ʋʋ ‑tee ʋʋ Kea 'a 'saaʋn kwa 'de dbo ʋʋa 'wlʋa nʋa' 'a ‑tɩ' 'ʋn. ");
INSERT INTO wob_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","‑Ta ʋʋ nynia, ʋʋ 'da Kea ‑gbu ‑wee' 'mɛ, ‑wɛe dɩ \"klein Kea nʋa ʋʋ po ɩa' \"kuan ʋʋ 'na : Kea kaiɛn ɛɛ' tɔ' 'ʋn 'je ‑je wɔn 'de nyʋ ‑sea' Suifʋ nɩ ‑pee ‑wɛe ‑wi\" ‑mʋ 'je Sesi 'a ‑tɩ' tɔ' 'ʋn 'je ‑ke. ");
INSERT INTO wob_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Ɛ 'wlʋa 'o ɛ, ʋʋ ke nyʋ ‑jea Sesi 'a ‑tɩ' tɔ' 'ʋn ‑teɛ i 'de nɔ\" ‑tuu\"‑tuu 'di 'bo Antiɔsɩ. ");
INSERT INTO wob_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Nyʋ jrʋ' ‑wlʋ 'e Suide ‑wɛe ‑ʋʋ mu 'e Antiɔsɩ 'de ‑ʋʋ ‑te Kletiɛn‑wi\" ‑nɩa 'e dɛ tɔɔa' ‑pʋn\" ʋʋ 'na : ‑Bo ao se 'klɛn mu ɛ, ‑mɛ ao se 'pʋi, 'kamɔ Moisɩ 'a kɛ' 'da. ");
INSERT INTO wob_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Pɔo ke Banabasɩ ke ʋʋ ‑siɛ' 'wɔin, ɛ nʋɛ' ʋʋa jea ba o ‑too'. 'De ɛɛ' ‑tɩ' 'ʋn Kletiɛn‑wi\" ‑nɩa 'o Antiɔsɩ 'bɛɛ‑ wlu 'ʋn ‑wɛe Pɔo ke Banabasɩ ke nyʋ jrʋ' 'je 'e ʋʋ \"klu 'wlʋ 'de ʋʋ 'je Sesi 'a dboʋn ke nyʋ‑cɔɩn' ‑wi\" muɛ 'e Selisalɛm, ‑wɛe ʋʋ 'je ‑tɩ' ‑nɩ \"kpei‑ ‑seea'. ");
INSERT INTO wob_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Ʋʋ ‑kɔa' ‑tɩ' pooa' 'sʋ Kea ‑gbu dboɛ ʋʋpʋ Selisalɛm ‑wɛe ʋʋ mu. Ʋʋ cɛn Fenisi ke Samadi 'ʋn, ‑wɛe ka nyʋ 'srʋ \"biia 'de Kea o ɛ, ʋʋa 'tmʋ ɩ 'de Kletiɛn‑wi\" ‑pee. 'Sʋ ɩa' ‑tɩ' tu \"jiiɛ ʋʋpʋ 'mʋa‑ 'ʋn. ");
INSERT INTO wob_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Ʋʋ nynia Selisalɛm ɛ, Kea ‑gbu ke Sesi 'a dboʋn ke nyʋ‑cɔɩn' kpʋʋn ɛ ʋʋ sɩn 'sɔɔn, ‑wɛe dɩ \"klein ʋʋ ke Kea nʋa 'de ʋʋ po ɩa' \"kuan. ");
INSERT INTO wob_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","'Sʋ Fariseɛn‑wi\" 'a jrʋ' ‑jea Sesi 'a ‑tɩ' tɔ' 'ʋn sɔn 'ʋn 'ɛ, ‑wɛe ʋʋ wlu ‑ke ʋʋ 'na : Nyʋ ‑sea' Suifʋ nɩ ɛ, ‑wɛe ‑ʋʋ ‑jea Sesi 'a ‑tɩ' tɔ' 'ʋn ɛ, ʋʋ 'je 'klɛn mu ‑o, ‑wɛe ʋʋ 'e Moisɩ 'a kɛ' wɔn 'je ‑ke. ");
INSERT INTO wob_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","‑Wɛe Sesi 'a dboʋn ke nyʋ‑cɔɩn' 'kɩɩn‑ \"jrui 'de ʋʋ 'je ɩa' ‑tɩ' tu 'mii bla 'pepe. ");
INSERT INTO wob_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Ʋʋ 'tmʋɛ ‑tmʋ ‑tmʋ 'sʋ ɛ, Piɛi sɔn 'ʋn 'ɛ, 'de ɔ 'na : 'Ma de'di ‑wi\", ka Kea kpa 'de ao \"klu sʋn sese ‑wɛe ɛ ‑sa 'e 'ʋn ɛ, ‑wɛe nyʋ ‑sea' Suifʋ nɩ 'je ‑pɔia\" wlu 'wɔn 'de 'ʋn 'wɔn ‑wɛe ʋʋ 'je ɛ tɔ' 'ʋn 'je, ao 'je kan' 'mɛ. ");
INSERT INTO wob_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","Kea ‑ɛ ‑jua nyʋ ‑wee' 'a pɛe ka ɛ kpʋn a ʋʋpʋ sɩn 'sɔɔn ɛ, ɛɛ to ɛɛ' sʋn 'mɛ. Ɛmɛ ‑tɩ ɛ \"nyɩ ʋʋpʋ ɛɛ' ‑Suu ka ɛ nʋa 'de ‑aa ‑tɩ' 'ʋn ‑ke ɛ. ");
INSERT INTO wob_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","Ɛ se ʋʋ ke ‑a \"kpei ‑seea', ɛ wɔɔ ʋʋa' pɛe 'mɛ, dɛ‑nʋɛ' ʋʋ 'jeɛ Sesi 'a ‑tɩ' tɔ' 'ʋn. ");
INSERT INTO wob_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","Kaan la 'ja 'ee, dɛɛ‑tɩ aoa ‑tɩn' Kea i, ‑wɛe ‑gbɛ ‑a ‑ke ‑a \"bo ‑wi\" sea 'blea 'bɛɛ‑, 'de aoa ‑teɛ' 'o nyʋ 'srʋ ‑jea Sesi 'a ‑tɩ' tɔ' 'ʋn \"jru ɛ‑ ? ");
INSERT INTO wob_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","'Kaa 'de Tʋ\"bo Sesi 'a 'saaʋn mɔ ‑a ‑je ɔɔ' ‑tɩ' tɔ' 'ʋn, ‑wɛe ‑a ‑je 'pʋʋa', 'kamɔ ʋʋpʋ mʋ nʋ 'pʋʋa' 'jesʋn ‑ke. ");
INSERT INTO wob_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","'Bo ɔɔ' wlu \"kpei 'sʋ 'cɛ ‑kwea de ‑wee' nʋɛ ‑tun\" a ‑wɛe ʋʋa po 'e Banabasɩ ke Pɔo 'wɔn doin\" i, 'de jrii' ke dɩ \"klein Kea cɛɛan 'de ʋʋpʋ 'ʋn ‑wɛe ɛ nʋa 'de nyʋ sea' Suifʋ nɩ \"klu ɛ, 'de ʋʋa po ɩa' \"kuan. ");
INSERT INTO wob_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Ʋʋ ‑kɔa' wlua' 'sʋ Sakɩ \"duɛ wlu 'ʋn ɔ 'na : 'Ma de'di ‑wi\", ao po 'ma wlu doin\" o. ");
INSERT INTO wob_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Ka Kea kpa 'de 'blʋa 'dinyʋ \"klu sʋn ‑wɛe ɛ ‑teea nyʋ kpɔi\" 'de ʋʋ 'jea ɛɛ' nyʋ nɩ ɛ, ɩmɩ Simɔ Piɛi 'tmʋ. ");
INSERT INTO wob_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","Ɛɛ' dɛ tu ɛ, ɛ ke wlu Kea 'a wlu 'kwajaaʋn 'tmʋa sese ɛ, ɩmɩ ‑kooɔ'‑. Ɩa' wlu tu 'naa : ");
INSERT INTO wob_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","'Bo ‑mɛ 'de ɛ, 'ma muɛ jia' ‑wɛe 'ɩn 'je Dafidɩ 'a ‑gbu\" blua ‑klu' ‑sa, ‑wɛe 'ɩn 'je ɛɛ' 'ka ‑gbɩn nmae, 'de 'ɩn 'je ɛ \"jɛi \"i kpa. ");
INSERT INTO wob_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","‑Bo ɛ nɩ kan' ‑wɛe nyʋ \"klein ‑sia 'o 'je Tʋ\"bo i ‑pɔn ɛ ke 'blʋa 'a blo' wɔn ‑wee' ‑sia\" 'ma 'nynɩ \"kpei ke‑. ");
INSERT INTO wob_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","Tʋ\"bo ‑ɛ ‑sa dɩ ‑nɩ 'kwla a, dɛ ɛ 'tmʋa tɛin\" sese, ɛmɛ ‑nao. ");
INSERT INTO wob_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","Ɛmɛ ‑tɩ 'mɔ 'naa nyʋ ‑sea' Suifʋ nɩ ‑wɛe ‑ʋʋ \"biia 'e Kea o ɛ, ‑a ‑bo ʋʋpʋ 'kle \"kpei jaa. ");
INSERT INTO wob_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","'Kaa ‑a ‑crɩ 'sbɛ‑ ‑a ‑je ʋʋpʋ kpa, ‑wɛe ʋʋ 'je nmi ʋʋ ‑saa 'sraa 'ʋn ʋʋ \"nyɩa kɔin 'a di ‑tɩ 'bɔ, ʋʋ 'je 'nynɩ ‑san nʋ‑tɩ 'bɔ, ʋʋ 'je nmi ‑ɛ ‑mɛa fuan \"fun di ‑tɩ 'bɔ, ɛ ke nmi 'a nmɔ ke‑. ");
INSERT INTO wob_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Dɛ‑nʋɛ' dɛ ‑wlʋa 'e sese o ɛ, nyʋ ‑te ‑kwlɔ 'dii dodo‑ ‑wɛe ‑ʋʋa nʋ Moisɩ 'a kɛ' 'dii ‑kwlewɩ \"o ‑kwlewɩ \"kpei 'de Suifʋ‑wi\" 'a \"jrui 'kɩɩn‑gbi 'dii jeejee. ");
INSERT INTO wob_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","'Sʋ Sesi 'a dboʋn o, nyʋ‑cɔɩn' o, Kea ‑gbu ‑wee' 'bɛɛ‑ wlu 'ʋn 'ɛ ‑wɛe ʋʋ 'je 'o nyʋ jrʋ' 'de ʋʋpʋ \"klu ‑sa 'de ʋʋ 'je ʋʋpʋ ke Pɔo ke Banabasɩ Antiɔsɩ dbo. 'Sʋ ʋʋ ‑sa 'o Suidɩ ‑ʋʋa 'daa Basabasɩ ke Silasɩ ke, ka ʋʋ nɩa 'sɔɔn ɔ, ʋʋ nɩɛ dɛwɔn 'de ʋʋa' de'di ‑wi\" \"klu. ");
INSERT INTO wob_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","Ʋʋpʋ ʋʋ ‑tu\" 'sbɛ ‑nɛ kwa ‑ʋʋ ‑je ɛ kpa. Dɛ ‑crɩɩa' 'de ɛ 'di ɛ ka : Sesi 'a dboʋn ke nyʋ ‑cɔʋn' ke aoa' de'di ‑wi\" ‑nɩa 'nɔ Selisalɛm, ‑apʋ ‑ɔɔ ja aopʋ nyʋ ‑ɔ sea Suifʋ nɩ 'jewlu. Ao ‑nɩa 'o Antiɔsɩ o, ‑ɔ ‑nɩa 'e Siri ke Silisi ‑ɔ ‑jea Sesi 'a ‑tɩ' tɔ' 'ʋn ɛ, ao nɩɛ ‑aa de'di ‑wi\" ‑o. ");
INSERT INTO wob_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","Ka nyʋ 'wlʋa 'nɔ ‑a o ‑wɛe ʋʋ ‑tua\" ao tɔ' i pleea' ‑pʋn\", 'de wlu ʋʋ 'tmʋa ao ‑pee ‑wɛe aoa' pɛe a ‑sian. Ʋʋa' nyʋ tu ɛ, ‑a se ʋʋpʋ wlu ‑tu\". ");
INSERT INTO wob_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","'De ɛɛ' ‑tɩ' 'ʋn ɛ, ‑a ‑wee' 'kɩɩn‑ \"jrui ‑wɛe ‑a ‑sa nyʋ ‑pʋn\" 'de ‑aa dbo ʋʋpʋ 'de ao o, ‑wɛe ʋʋa mu Banabasɩ ke Pɔo ‑ʋʋ ‑nɩa ‑aa ‑tɩ' kmaʋn ‑jei\" jaa'. ");
INSERT INTO wob_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","nyʋ 'sɔɔn ‑nʋ to 'e ʋʋa' ‑cɛ\" 'ɛ 'kmʋ 'mɛ 'de Sesi Klisɩ 'a 'nynɩ 'a ‑tɩ' 'ʋn. ");
INSERT INTO wob_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","‑Aa dbo Suidɩ ke Silasɩ 'mɛ, ‑wɛe dɛ ‑a ‑crɩa 'nɔ ɛ, ʋʋa' ‑cɛ\" 'kpa 'je ɛ 'e 'wɔn jaa‑ 'de ʋʋ 'je ɛ 'tmʋ 'de ao ‑pee. ");
INSERT INTO wob_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","Dɛ‑nʋɛ' Kea 'a ‑Suu ke ‑a poɛ wlu ‑tadue ‑wɛe ‑a ‑bo aopʋ ‑gbɛ jrɛ' \"jru ‑teɛ', ‑bo ɛ se dɩ ‑kɔan ‑tɩ' mɩ ‑a ‑tmʋ 'de ao ‑pee nɩ ɛ. ");
INSERT INTO wob_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","Ɩa' dɩ tu ka : ao 'bo nmi ʋʋ ‑saa 'sraa‑ ‑wɛe ʋʋ \"nyɩa kɔin diiɛ, ao 'bo nmi ‑ɛ ‑mɛa fuan \"fun 'ʋn diiɛ, ao 'bo nmi 'a nymɔ diiɛ, ao 'bɔ 'nynɩ ‑san o ‑ke. ‑Bo aoa sea aoa' ‑cɛ\" 'ɛ ‑tɩ' ‑tu\" 'de ɩa' ‑tɩ' 'ʋn ɛ, ‑mɛ ɛ nmɔ \"jrii. Kea sie aopʋ o ! ");
INSERT INTO wob_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Ʋʋpʋ mɔ poa Kea ‑gbu wlu 'sʋ ʋʋ 'kpao 'wɛ ʋʋ muɛ Antiɔsɩ. ‑Wɛe ʋʋ 'kɩɩɛn Kletiɛn‑wi\" \"jrui 'de ʋʋ \"nyɩ ʋʋpʋ 'sbɛ ‑nɛ. ");
INSERT INTO wob_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","Ʋʋ ‑kɔa' ɛ 'dii nʋa' 'sʋ ɛɛ' wlu \"sii ʋʋpʋ 'a dɩ 'e 'wɛ. ");
INSERT INTO wob_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Suidɩ ke Silasɩ ‑nɩa Kea 'a wlu 'kwajaaʋn ɛ, ‑wi\" ‑mʋ 'tmʋɛ ɩ ‑tuu\"‑tuu ‑wɛe ʋʋ kuu Kletiɛn‑wi\" 'a dɩ i 'de ʋʋ \"nyɩ ʋʋpʋ 'kpɩ. ");
INSERT INTO wob_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","Ʋʋ nʋa 'o Antiɔsɩ 'wɩ pla ‑wɛe ʋʋa' de'di ‑wi\" po ʋʋpʋ \"diwan ‑wɛe ʋʋ \"tai ʋʋpʋ \"i 'de 'flɛ 'ʋn 'de ʋʋ 'je nyʋ ‑dbʋʋ' ‑pʋ' o de mu. ");
INSERT INTO wob_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","'Kaa Silasɩ 'na ɔɔ' 'mʋa‑ sia' nʋɔ 'tʋn. ");
INSERT INTO wob_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","Pɔo ke Banabasɩ ‑teɛ i 'bo Antiɔsɩ ‑wɛe ʋʋ ke nyʋ jrʋ' a tɔɔ nyʋ Tʋ\"bo 'a ‑pɔia\" wlu‑. ");
INSERT INTO wob_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Nɔ\" jrɛ' ‑sia' 'o 'sʋ Pɔo wluɛ Banabasɩ ‑pee ɔ 'na : ‑A mu ‑kwlɛ \"klein ‑a ‑jiia 'dii 'de ‑a ‑tmʋa Tʋ\"bo 'a wlu ɛ, ‑aa de'di ‑wi\" ‑nɩa ɩ 'dii ɛ, ‑a ‑je ʋʋpʋ \"i ‑tee' ‑wɛe ‑a ‑je ʋʋa' Kea 'a ‑jei\" naasʋn‑ 'je. ");
INSERT INTO wob_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","'Sʋ Banabasɩ nɩɛ \"i ʋʋ ke San Makɩ 'je mu. ");
INSERT INTO wob_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","'Kaa ɔɔ' mu ‑tɩ se Pɔo 'tʋn nʋ, dɛ‑nʋɛ' ɔ siɛ ʋʋpʋ 'de Panfili, ɔ se ʋʋpʋ kpa dbo ʋʋa nʋa ɔɔ' 'je ɛɛ' ‑ta. ");
INSERT INTO wob_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","'De ɛɛ' ‑tɩ' 'ʋn ɛ, ʋʋ se ba 'a wlu 'mii 'wɔn 'sʋ ʋʋ je i ‑seea'. Banabasɩ \"dua Makɩ 'ʋn ɛ, ɔ ke ɔ muɛ 'e Siprɩ 'bo 'tɔniɛ 'ɛ bɩ 'nynɩ. ");
INSERT INTO wob_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","Pɔo ‑mɔ ‑sa 'o Silasɩ, ʋʋa' de'di ‑wi\" ‑te' ʋʋ Tʋ\"bo 'a 'saaʋn kwa 'sasa, ‑wɛe ʋʋ 'kpa ‑jei\". ");
INSERT INTO wob_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","Ʋʋ pleɛ Siriblʋa ke Silisiblʋa \"kpei‑, ‑wɛe ʋʋ kuu Kea ‑gbi 'a dɩ i. ");
INSERT INTO wob_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","'Bo ɔ nyni 'o Dɛɛbʋ ‑wɛe ɔ mu Litrɩ, 'bomɔ \"ju due' nɩ, ɔ 'je Sesi 'a ‑tɩ' tɔ' 'ʋn, ɔɔ' 'nynɩ ‑nɩ Timote. Ɔ de nɩɛ Suifʋ 'nynɔ ‑wɛe ʋ 'je Sesi 'a ‑tɩ' tɔ' 'ʋn ‑sisi', 'kaa ɔ \"bo nɩɛ Klɛkɩi ‑o. ");
INSERT INTO wob_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","Kletiɛn‑wi\" ‑nɩa 'o Litrɩ ke Ikɔnɩ ɛ, ʋʋa poɛ ɔɔ' Kea 'a ‑jei\" naa 'a 'kpa. ");
INSERT INTO wob_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","Pɔo nɩɛ \"i ɔ ke Timote 'je mu. 'Sʋ ɔ \"duo‑ ɔ 'ʋn 'ɛ, ‑wɛe ɔ kpɔ 'klɛn 'de Suifʋ‑wi\" ‑ʋʋ ‑nɩa 'e ɛɛ' 'blʋa 'a 'fɔ tu o 'a ‑tɩ' 'ʋn, dɛ‑nʋɛ' ʋʋ ‑wee' \"klein juɛ' ka ɔ \"bo nɩa Klɛkɩi ɛ. ");
INSERT INTO wob_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","‑Kwlɔ \"o ‑kwlɔ ɔɔ jiia 'dii ɛ, dɩ \"klein Sesi 'a dboʋn ke nyʋ ‑cɔʋn'‑wi\" 'bɛɛa wlu 'ʋn 'bo Selisalɛm ɛ, ɩmɩ ɔɔ 'tmʋ 'de nyʋ ‑ʋʋ ‑jea Sesi 'a ‑tɩ' tɔ' 'ʋn ‑pee ‑wɛe ʋʋ 'jɩ wɔn 'je. ");
INSERT INTO wob_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Kea ‑gbi a 'bleɛ 'kpɩ 'de Kea ‑kwlɩ\" ‑tea' 'ʋn ‑wɛe ɩa 'kpa \"kpei 'wɩ \"o 'wɩ. ");
INSERT INTO wob_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","Pɔo‑wi\" mua Kea 'a ‑tɩ' 'tmʋa' 'de Asi 'a 'blee‑blʋɩ \"kpei ɛ, Tʋ\"bo 'a ‑Suu kaan ʋʋpʋ ‑je de. 'De ɛɛ' ‑tɩ' 'ʋn ɛ, ʋʋ ‑gbee' Frisiblʋa ke Galasiblʋa 'mɛ, ʋʋ jɩ 'ʋn ‑tie\" cɛn. ");
INSERT INTO wob_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","‑Ta ʋʋ nynia 'o Misiblʋa ‑pʋn\" ɛ, ʋʋ nɩɛ \"i ʋʋ 'je 'e Bitini mu 'de‑, 'kaa Sesi 'a ‑Suu se ʋʋ ɛɛ' ‑je \"nyɩ. ");
INSERT INTO wob_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","'Sʋ ʋʋ cɛn Misiblʋa 'ʋn ‑tie\" ‑wɛe ʋʋ mu 'o ‑kwlɔ ‑ɛɛ 'nynɩ nɩa Troasɩ. 'Bo ʋʋa' ‑bato' kpʋʋn 'kpʋʋ. ");
INSERT INTO wob_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","\"Maʋ' 'sʋ ɛ Pɔo 'jeɛ Masedoanɩ i due' 'de jajri 'ʋn ‑ɔɔ bae ɔ i, 'de ‑ɔ ‑na : ‑Ɩn ji 'nɔ ‑a o 'de Masedoanɩ ‑wɛe ‑ɩn ‑je ‑a sʋn o po. ");
INSERT INTO wob_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Pɔo ‑kɔa' ja ‑nɛ 'ɛ jaa' 'sʋ ɛ, 'bomɔ ‑a ‑sri\" ‑aa ‑pɔn 'e Masedoanɩ‑blʋa \"kpei mu ‑kɔ i, dɛ‑nʋɛ' ‑a ‑je kan' 'mɛ Kea 'a ‑cɛ\" ‑da ‑aʋn 'de ɛɛ' 'blʋa‑ tu \"kpei ‑wɛe ‑a ‑je ‑pɔia\" ‑tɩ 'tmʋ 'de nyʋ ‑nɩa 'emu ‑pee. ");
INSERT INTO wob_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","‑A ‑kpa ‑bato' 'di 'bo Troasɩ ‑a muɛ Samotrasɩ ‑wɛe ‑sɔn' ‑sɩn' 'de ‑a mu Neapoli. ");
INSERT INTO wob_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","'Bomɔ ‑a ‑wlʋ 'de ‑a mu 'o Filipʋ. Ɛmɛ ‑nɩ Masedoanɩ ‑blʋa 'a \"i‑saa ‑kwlɔ Rɔmʋ 'a \"sʋɩ ‑wi\" 'blea. ‑A nʋɛ 'o 'wɩ pla. ");
INSERT INTO wob_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","‑Kwlewɩ o ɛ, ‑a ‑wlʋ 'o ‑kwlɔ 'mɛ, ‑wɛe ‑a mu 'e \"ni ‑kwlɩ\". ‑Amɔ ‑ɔɔ naa tɔ' i 'de ɛ, ‑a ‑na 'bomɔ Suifʋ‑wi\" 'a Kea bae 'ɩn nɩ‑. ‑A ‑teɛ i 'bomu ‑wɛe ‑aa ‑wlu 'nynʋkpae' ‑ʋʋ ‑kɩɩan' \"jrui ‑pee. ");
INSERT INTO wob_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Ʋʋa' due 'a 'nynɩ ‑nɩ Lidi. Ʋ 'wlʋɛ 'o ‑kwlɔ Tiatii 'di ‑wɛe ʋa ple \"wlii‑, ɩa' \"jri ‑sain 'a. Ʋʋa' 'nynɔkpao' tu ɛ, ʋa pleeɛ Kea ‑wɛe ʋa po ‑aa wlu doin\" o. 'Sʋ Tʋ\"bo kaiɛn ʋa' pɛe wɔn ‑wɛe dɛ Pɔo a 'tmʋa ʋa poɛ doun\" o ‑snii'. ");
INSERT INTO wob_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","Ʋ ke ʋa' ‑gbu\" ‑sɔn nyʋ ‑wee' pooa \"ni \"jru 'sʋ ɛ, ʋ 'da ‑aʋn 'ɛ 'de ʋ 'na : Ka 'ɩn 'jea Tʋ\"bo 'a ‑tɩ' tɔ' 'ʋn ‑cɛɛn'‑, ‑bo ao 'je kan' ‑mɔ 'ja a, ‑mɛ ao ji 'de 'ʋn wɔin\" koo‑. ‑Wɛe ʋ 'nɛ ‑a \"mlai mamaʋ 'sʋ ‑a ‑wɔɔn' 'o. ");
INSERT INTO wob_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","'Wɩ jrɛ' o, ‑ta ‑aa mua 'e Kea bae 'ɩn ɛ, dbonʋnynɔkpao' due' ‑jaa' ‑a \"i. sɛn 'ɛ ‑suu ‑nɩ 'de ʋ 'ʋn ɛmɛ ‑ɛɛ nʋɛ 'de ʋa ‑si' dɩ ‑wɛe ʋa 'je 'wɛi ‑tuu\" 'de ʋa \"nyɩ ʋa' jeʋn ‑wi\". ");
INSERT INTO wob_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","'Sʋ ʋ ‑teɛ ‑a ‑ke Pɔo 'a 'de naa' ‑pʋn\", ‑wɛe ʋa \"wɔ ʋ 'na : Nyʋ ‑nʋ, ʋʋ nɩɛ Kea ‑nɩa 'e jaʋn 'di 'a dbonʋʋn ‑o, 'pʋ‑je mɛ ‑ɛɛ ‑tɩ' ʋʋa 'tmʋ 'de ao ‑pee. ");
INSERT INTO wob_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","Ʋ nʋ ɛɛ' dɛ tu 'mɛ 'de 'wɩ pla 'di. Pɔo sea 'de ɛɛ' ‑tɩ' 'ʋn 'sʋ ɔ \"biiɛ i 'de ʋ o, ‑wɛe ɔ wlu ‑suusaʋn ‑pee ɔ 'na : 'Ma 'tmʋʋ ɛ 'de Sesi Klisɩ 'a 'nynɩ 'ʋn, ɛ 'wlʋ 'e \"junynɔkpao' ‑nʋ 'ʋn ! 'Bo ɛ \"sri, ɛ je 'de ʋ 'ʋn 'wlʋ. ");
INSERT INTO wob_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Nyʋ ‑blea dbonʋnynɔkpao' ‑nʋ 'jea kan' ka ʋʋa' crɔn' 'ɔ ‑jeblʋ a jia \"i cean' 'sʋ, ʋʋ kpʋn Pɔo ke Silasɩ 'mɛ, ‑wɛe ʋʋ kpa ʋʋpʋ 'bo ‑kwlɔʋnjeʋn \"juɔi. ");
INSERT INTO wob_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","'De ʋʋ kpa ʋʋpʋ 'e Rɔmʋ‑kɔʋn 'a 'pee 'jeʋn o, ‑wɛe ʋʋ 'na : Nyʋ ‑ʋʋa dooa ‑aa ‑kwlɔ, ʋʋ ka. ");
INSERT INTO wob_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","Ʋʋ nɩɛ Suifʋ‑wi\" ‑o, kplɩn ‑aa kɛ' 'na nyʋ 'bo nʋɛ, ɩmɩ ʋʋa tɔɔ ‑apʋ ‑ɔ ‑nɩa Rɔmʋ‑kɔʋn ‑wɛe ‑a ‑je 'wɔɔn' 'de ‑a ‑je nʋ. ");
INSERT INTO wob_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","'Sʋ nyʋ ‑wee' \"klein nyna ja, ‑wɛe ‑kwlɔʋnjeʋn ‑sa Pɔo ke Silasɩ dɩ kui, 'de ʋʋ cɛn 'o wlu ‑wɛe ʋʋ kpa ʋʋpʋ klae 'ʋn. ");
INSERT INTO wob_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","Ʋʋ ‑kɔa' ʋʋpʋ 'a blaa' 'sʋ ʋʋ po ʋʋpʋ ‑kaso 'di, ‑wɛe ʋʋ 'tmʋʋ ‑kasogbu i fuoi 'de ɔ 'je ʋʋpʋ i fuo ka ‑cɔɔn' ka. ");
INSERT INTO wob_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","‑Kasogbu i fuoi ‑mɔ 'wɔan ‑mɛ 'sʋ ɛ, ɔ kpa ʋʋpʋ 'de ‑kasogbu 'a wɔn ‑nɩa 'e de 'di ‑wee' ɔ po ʋʋpʋ ‑gbii‑ bʋ'. ");
INSERT INTO wob_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","‑Too' ‑kwea 'sʋ Pɔo ke Silasɩ ‑teɛ baea' ke blea' ‑pʋn\" ‑wɛe ʋʋa 'bɛɛ‑ Kea 'a 'nynɩ \"i. Nyʋ ‑nɩa 'e ‑kaso 'di ‑wee' a 'wɔn ʋʋpʋ 'a wlu 'mɛ. ");
INSERT INTO wob_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","Ʋʋa ‑gbʋan 'emu 'sʋ 'blʋa‑ crɛ', 'sʋ ‑kasogbu 'a ‑gban ‑wee' a ‑suua' i. 'Bomɔ ‑kasogbu 'a kpae\" ‑wee' \"sri ɩ kain \"wɔin, ‑gbaacɩɛ' dbi ‑sria\" ‑kaso 'diʋn ‑wee' cɛn'. ");
INSERT INTO wob_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","‑Ta ‑kasogbu i fuoi a sɔan \"nyɩɔ' 'sʋ ɛ, ‑mɛ ‑kasogbu 'a kpae\" ‑wee' flɔn wɔn, 'sʋ ɔ ‑sa ɔɔ' ‑cnɛ kpla', ɔ 'e ɔɔ' ‑cɛ\" 'dbaa', ɔɔ naa tɔ' i ɔ 'na ‑mɛ nyʋ ‑nɩa ‑kaso 'di ‑wee' 'kpa 'kwla 'de‑. ");
INSERT INTO wob_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","'Kaa Pɔo bla ‑ke, ɔ 'na : ‑Ɩn ‑bo ‑ma ‑cɛ\" dɛsaʋn \"jrii nʋɛ, ‑a ‑wee' \"klein nɩ ‑ta 'mɛ. ");
INSERT INTO wob_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","'Sʋ ‑kasogbu ifuoi ‑teeɛ' nɛ i, ‑wɛe ɔ 'wlaa 'e ‑kasogbu 'di 'de \"kpei crɛɛa' 'ʋn. Ɔɔ' dɩ a crɛ', faʋn a nʋɔ'. 'Sʋ ɔ \"siiɛ 'kɔi‑ i 'bo Pɔo ke Silasɩ \"juɔi. ");
INSERT INTO wob_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","Ɔ \"siiɛ ʋʋpʋ \"kpae', ‑wɛe ɔ 'na : Tʋ\"bo ‑wi\", dɛ 'ɩn 'je nʋ 'de 'ɩn 'je 'pʋ ɛ‑ ? ");
INSERT INTO wob_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","'Sʋ Pɔo ke Silasɩ 'na : ‑Ɩn ‑je Tʋ\"bo Sesi 'a ‑tɩ' tɔ' 'ʋn ‑wɛe ‑ɩn ‑je 'pʋ, ‑mɔ e ‑ma ‑gbu\" ‑sɔn nyʋ e‑. ");
INSERT INTO wob_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","‑Wɛe ʋʋ ‑te Tʋ\"bo 'a wlu 'tmʋa' ‑pʋn\" 'de ɔ ke ɔɔ' ‑gbu\" ‑sɔnyʋ ‑pee. ");
INSERT INTO wob_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","'De ɛɛ' \"maʋ'wɩ tu 'di ɛ, ɔ \"duo‑ ʋʋpʋ 'ʋn 'ɛ ‑wɛe ʋʋ mu 'de ɔ wɔin\" 'de ɔ jre ʋʋpʋ 'a ‑ci\". 'Bo ɛ \"sri ɔ ke ɔɔ' ‑gbu\" ‑sɔn nyʋ je \"ni \"jru pooɛ‑. ");
INSERT INTO wob_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","'De ɔ \"nyɩ ʋʋpʋ diidɛ, 'sʋ ɔ ke ɔɔ' ‑gbu\" ‑sɔnyʋ a nʋɛ 'mʋa‑, dɛ‑nʋɛ' ʋʋ 'jeɛ Kea 'a ‑tɩ' tɔ' 'ʋn. ");
INSERT INTO wob_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","‑Sɔn' ‑sɩan' 'sʋ ‑kwlɔʋnjeʋn dboɛ nyʋ 'de ‑kasogbu ifuoi o ‑wɛe ʋʋ 'na : ‑Ɩn ‑sii\" nyʋ ‑nʋ i. ");
INSERT INTO wob_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","‑Wɛe ‑kasogbu ifuoi 'tmʋ ɩ 'de Pɔo ke Silasɩ ‑pee ɔ 'na : Rɔmʋ 'a ‑kwlɔʋnjeʋn dboɛ nyʋ ʋʋ 'naa 'ɩn \"sii aopʋ i, ao 'bɛɛ‑ ao 'je \"kpae' \"si la ‑wɛe ao 'je mu 'de 'flɛ 'ʋn. ");
INSERT INTO wob_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","'Kaa Pɔo wlu' 'de nyʋ ʋʋ dboa ‑pee ɔ 'na : Ʋʋ bla ‑aʋn ɛ 'bo nyʋ ‑kwea, 'de ʋʋ se ‑aa 'pee 'je 'sʋ ʋʋ po ‑a ‑kaso 'di, ‑jɛ kaan 'sʋ ʋʋa dboɛ nyʋ ‑wɛe ʋʋ 'je ‑a i \"sii wɔɔ‑. 'De ‑mɛ 'kamɔ ‑a ‑nɩ Romɛ koun 'a ‑cɛ\" 'kpa, ɛ se 'bɛɛ‑. ‑Bo ao mu ɛ, ʋʋa' ‑cɛ\" 'kpa ji ‑wɛe ʋʋ 'je ‑a i \"sii‑. ");
INSERT INTO wob_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","Nyʋ ʋʋ dboa kpa wlu ‑nɛ ‑wɛe ʋʋ 'tmʋ ɛ 'de ‑kwlɔʋnjeʋn ‑pee 'sʋ ka Pɔo ke Silasɩ nɩa Rɔmʋ‑kɔʋn ɛɛ' dɛ waa ʋʋpʋ 'dii. ");
INSERT INTO wob_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","'Sʋ ʋʋa' ‑cɛ\" 'kpa ji' ‑wɛe ʋʋ jaa Pɔo ke Silasɩ 'a pɛe ja 'de ʋʋ ‑sʋ ‑kaso 'di, ‑wɛe ʋʋ bae ʋʋpʋ i 'de ʋʋ 'je 'o ‑kwlɔ 'wlʋ. ");
INSERT INTO wob_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","Pɔo‑wi\" 'wlʋa ‑kaso 'di ɛ, ʋʋ muɛ 'e Lidi o ‑gbɛin\", ʋʋ ke ʋʋa' de'di ‑wi\" 'jeea 'sʋ ɛ, ʋʋ kuuɛ ʋʋpʋ 'a dɩ i ‑wɛe ʋʋ 'kpa ‑jei\". ");
INSERT INTO wob_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","Pɔo ke Silasɩ cɛɛn Anfipoli ke Apoloni ‑wɛe ʋʋ nyni Tesalonikɩ. 'Bomɔ Suifʋ‑wi\" 'a \"jrui 'kɩɩn‑gbu due' nɩ‑. ");
INSERT INTO wob_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","Pɔo pa 'e ɛ 'di, ka ɔɔ nʋa see ɛ. 'De ‑kwlewɩ taan 'di ɛ, ɔ ke ʋʋa ‑too' ɛ ba o 'de Kea 'a wlu ‑ɛ ‑crɩɩa' 'a ‑tɩ' 'ʋn. ");
INSERT INTO wob_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","Ka Sesi 'jea 'kle 'je 'de ɔ 'jea \"kunyɩɔ' sɔn ɛ, ɔɔ ‑sɛ' wɔ 'pepe 'de ʋʋ ‑pee, ɔ 'na : Sesi ‑ɔɔ ‑tɩ' 'ma 'tmʋa 'de ao ‑pee ‑ta, ɔmɔ ‑nɩ Klisɩ. ");
INSERT INTO wob_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","Suifʋ jrʋ' 'je ɔɔ' wlu tɔ' 'ʋn 'ɛ, ‑wɛe ʋʋ ke Pɔo ke Silasɩ po kɩɩn ‑tadue. 'Kamɔ Glɛkɩ‑wi\" 'a ‑tuu\"‑tuu ‑ʋʋa pleea Kea nʋ ‑ke, ɛ ke dɛwɔnɩnynʋkpae' ‑tuu\"‑tuu ke‑. ");
INSERT INTO wob_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","'Kaa \"cɛi nʋa' \"ji 'e Suifʋ jrʋ' 'ʋn 'ɛ, 'sʋ ʋʋ 'kɩɩɛn 'diwɔnyniʋn ‑gbai\" \"jrui ‑kɩɩn ‑kɩɩn\"‑, ‑wɛe ʋʋ ‑sa ‑tiba ‑klu' 'bo ‑kwlɔ. 'Sʋ ʋʋ muɛ 'e Sasɔn o ‑gbu\" 'de ʋʋ 'je Pɔo ke Silasɩ kpʋn ‑wɛe ʋʋ 'je ʋʋpʋ 'bo nyʋ \"juɔi ja‑. ");
INSERT INTO wob_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","Ʋʋ sea Pɔo ke Silasɩ 'je 'sʋ ɛ, ʋʋ kpʋn Sasɔn ke Kea 'a ‑jei\" naaʋn jrʋ' 'mɛ, ‑wɛe ʋʋ kpa ʋʋpʋ 'de ‑kwlɔʋnjeʋn \"juɔi, ‑wɛe ʋʋ ‑te ‑cruɛn\" ‑saa' ‑pʋn\" ʋʋ 'na : Nyʋ ‑nʋ, ‑ʋʋ ‑gbɔoa' 'kmʋ ‑wee', ʋʋpʋ ‑ji\" ‑ta ‑kwlɔ ‑ke ‑wɛe Sasɔn po ‑gbu\". ");
INSERT INTO wob_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","Ʋʋa' nyʋ tu ɛ, ʋʋ ‑wee' \"klein a blaa 'blʋajei Sesaa 'a kɛ' wɔn, dɛ‑nʋɛ' ʋʋ 'na : 'Beɔ deejrɔ' ‑nɩ 'kmʋ ‑ɔɔ 'nynɩ nɩ Sesi. ");
INSERT INTO wob_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","Wlu ‑nɩa 'mʋa‑ \"siɛ ‑kwlɔʋnjeʋn ke nyʋ ‑kwea de \"i. ");
INSERT INTO wob_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","'De ɛɛ' ‑tɩ' 'ʋn ɛ, Sasɔn ke ɔɔ' \"dɛi‑wi\" ‑teɛ' 'o dɛ i ‑wɛe ʋʋ \"tai‑ ʋʋpʋ \"i. ");
INSERT INTO wob_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","'Bomɔ Kea 'a ‑jei\" naaʋn \"sri \"maʋ' ʋʋ kpa Pɔo ke Silasɩ ‑jei\" 'de Bere. Ʋʋ nynia 'o Bere ɛ, ʋʋ muɛ 'e Suifʋ‑wi\" 'a \"jrui 'kɩɩn‑gbu 'di. ");
INSERT INTO wob_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","Suifʋ‑wi\" ‑nɩa 'o ‑mɔ ɛ, ʋʋ juɛ nyiiɔ ‑tɩ, ɛ je ‑jʋ ‑nɩa Tesalonikɩ ‑sii‑. Ʋʋ kpʋʋɛn Tʋ\"bo 'a wlu sɩn 'sɔɔn. Ʋʋa 'cɩan dɛ 'de 'wɩ \"o 'wɩ ‑wee' 'di. Ʋʋa \"jrɛɛ‑ ɛ jeejee, ‑wɛe wlu Pɔo a 'tmʋa ‑bo ɛ nɩ tɔ', 'de ʋʋ 'e kan' 'je. ");
INSERT INTO wob_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","Ʋa' ‑tuu\"‑tuu ‑je Sesi 'a ‑tɩ' tɔ' 'ʋn 'bomu. Glɛkɩ‑wi\" 'a dɛwɔn nɩnynʋkpae' ‑tuu\" ke \"nynunmainynu ‑tuu\" ‑jeɛ tɔ' 'ʋn ‑ke. ");
INSERT INTO wob_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","'Kaa ‑ta Suifʋ‑wi\" ‑nɩa Tesalonikɩ 'wɔan ka Pɔo nɩa Kea 'a wlu 'tmʋa' 'bo Bere ‑ke ɛ, ʋʋ ji 'o 'ɛ, ‑wɛe ʋʋ paa nyiɔpʋ bɩ ‑sɔn. ");
INSERT INTO wob_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","'Bomɔ Kletiɛn‑wi\" \"sri ʋʋ po Pɔo ‑je o, ‑wɛe ɔ mu 'e 'tɔniɛ ‑kwlɩ\" fɔ o, 'kaa Silasɩ ke Timote sie 'o Bere 'mɛ. ");
INSERT INTO wob_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","Nyʋ ‑ʋʋ kpa Pɔo ‑jei\" ɛ, ʋʋ kpɔ' mamaʋ 'sʋ ʋʋ je Atɛnɩ nyni. ‑Ta ʋʋa jia de ɛ, 'bomɔ ɔ ‑tu\" ʋʋpʋ wlu 'de Silasɩ ke Timote 'je ɔ jɛɛ ‑too\"‑. ");
INSERT INTO wob_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","‑Ta Pɔo a fua Silasɩ ke Timote 'bo Atɛnɩ ɛ, ɔɔ' ‑suu \"kaeɛ \"jrii 'de ɔ 'ʋn, dɛ‑nʋɛ' 'bo ɛɛ' ‑kwlɔ ‑tu 'di ɛ, \"juɔi ‑gbɛɛ' kɔin 'a 'sʋ ‑ji\" 'o. ");
INSERT INTO wob_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","'De ɛɛ' ‑tɩ' 'ʋn ɛ, ɔ ke Suifʋ‑wi\" o, nyʋ jrʋ' ‑ʋʋa pleea Kea 'tmʋɛ Kea \"juɔi ‑gbɛɛ' ‑tɩ 'de Suifʋ‑wi\" 'a \"jrui 'kɩɩn‑gbu 'di, ‑wɛe ɔ ke nyʋ jrʋ' ɔɔ jɛɛa 'bo ‑kwlɔ ‑kwea a wlu jeejee. ");
INSERT INTO wob_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","Glɛkɩ‑wi\" 'a dɛ \"ijuoʋn klae\", ʋʋpʋ ‑ke ɔ ‑te wlua' ‑pʋn\", ʋʋa' jrʋ' 'na : Dɛ \"ju ‑nɔ ‑mɔ ɔ 'tmʋ ‑ta ɔɔ jea ‑sɔɔ wlu ɛ‑ ? 'De jrʋ' 'na : Ɛ ‑kɔ' ‑na ɔɔ 'tmʋɛ 'dʋɩ ‑kea' jrɛ'ɛ ‑tɩ'. Dɛ ‑tɩ ʋʋa 'da kan' a, ɛmɛ ‑nɩ Pɔo a 'tmʋɛ Sesi 'a ‑tɩ' ke \"kunyɩɔ' sɔn‑tɩ 'de ʋʋ ‑pee. ");
INSERT INTO wob_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","'Sʋ ʋʋ kpa Pɔo 'de ʋʋa' 'sra klaa\" ‑sɔn. 'Bo 'a ‑ta tu 'a 'nynɩ ‑nɩ Areopasɩ. 'De ʋʋ 'na : ‑Ma dɛ dee ‑ɛ jia i ‑wɛe ‑ɛɛ ‑tɩ' ‑ma ‑tmʋa a, ‑a ‑bɛɛ' ‑a ‑je ɛɛ' \"kpei ‑tɩ 'wɔɔn ? ");
INSERT INTO wob_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","Dɩ ‑a sea 'wɔn due' ɩmɩ ‑ma ‑tmʋ 'de ‑a ‑pee, ‑a ‑nɩɛ \"i ‑a ‑je 'e ɩ 'de i 'wɔn. ");
INSERT INTO wob_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","'De Atɛnɩ‑kɔʋn ‑wee' \"klein ke 'dʋɩ‑ ‑ʋʋ ‑tia\" 'o Atɛnɩ ke ʋʋ ‑wee' a nʋ ʋʋa' nɔ\" ‑wee' 'mɛ 'de 'tmʋa' ke ‑tɩ' dee 'a doin\" o poa' 'ʋn. ");
INSERT INTO wob_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","'Sʋ Pɔo nyna i 'bo 'sra 'a ‑kwea'‑ ‑wɛe ɔ 'na : Ao Atɛnɩ‑kɔʋn, dɛ 'ɩn sia \"jriɛ‑ o ɛ, ɛmɛ ‑nɩ aoa' nyʋ tu ɛ, ao nɩɛ ‑gbɛɛ' ʋn ‑o 'pepe ‑cɛɛn'‑. ");
INSERT INTO wob_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","‑Ta 'ma plea aoa' ‑kwlɔ ɛ, ‑wɛe 'ma ‑sia' dɩ aoa ‑gbɛɛa' \"jriɛ‑ o ɛ, 'bomɔ 'ɩn 'jee 'kwlan due' ‑ɛ ‑kwlɩ\" ao 'crɩɩ : kea 'srʋ. Ɛ nmɔ \"i, Kea ao sea juo ‑wɛe aoa ‑gbɛɛa' \"juɔi ɛ, ɛmɛ ‑ɛɛ ‑tɩ' 'ma 'tmʋ 'de ao ‑pee. ");
INSERT INTO wob_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","Kea ‑ɛ nʋa 'kmʋ ke dɩ \"klein ‑nɩa 'e 'kmʋ \"kpei ‑wɛe ‑ɛ ‑nɩa 'blʋa‑ ke jaʋn 'a Tʋ\"bo, ɛɛ' \"ti 'e ‑gbi\" nyiɔ 'ɔ sʋn poa 'di. ");
INSERT INTO wob_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","Ɛ se ɛ ‑pɔn 'de nyiɔpʋ 'je ɛ dɛ \"o dɛ \"nyɩ, dɛ‑nʋɛ' ɛmɛ ‑ɛɛ ‑nyɩ\" nyiɔpʋ 'kmʋnɩfeeɛ' ke dɩ ‑wee' \"klein ke‑. ");
INSERT INTO wob_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","Nyʋ \"klein ‑ʋʋ ‑jia\" 'kmʋ ɛ, ʋʋ 'wlʋɛ 'e nyɔ due' ‑gbai ɛ nʋa 'ʋn, ‑wɛe ɛ ‑te' ʋʋpʋ 'blʋa‑ 'dii dodo‑ 'de ɛ \"nyɩ ʋʋpʋ nɔ\" ‑wɛe 'blʋa‑ ʋʋ 'jea 'di \"ti ɛ, ɛ ‑gble' ɛ 'ʋn. ");
INSERT INTO wob_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","Ɛ nʋ ɛɛ' dɛ tu 'mɛ ‑wɛe nyʋ 'je ɛ i ‑pɔn, ‑wɛe ‑bo nyʋ a se ɛ dbɛɛdɛ 'kwa i ‑pɔɔn ɛ, 'de ʋʋ 'je ɛ 'je. 'De ‑mɛ 'kamɔ Kea se nyɔ \"o nyɔ o tɛɛn‑. ");
INSERT INTO wob_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","‑Jɛ ɛ nɩa kan' a, ‑mɛ ‑aa nyiɔjɔ 'bleɛ 'kmʋnɩa' ke i ‑suua' ke, ɛmɛ aoa' dɛ \"ijuoʋn jrʋ' 'tmʋ ‑ke ʋʋ 'na : ‑A ‑nɩɛ ɛɛ' ‑kooɔ' i ‑o. ");
INSERT INTO wob_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","Ka ‑a ‑nɩa ɛɛ' \"nynuu ‑mɔ 'ja a, ‑mɛ ‑a se ɛ 'bɛɛ‑ ‑a ‑je tɔ' i naa 'de ‑a ‑je 'kmʋnɩ Kea 'sani ke 'wɛi ke \"sou \"i poo‑. ‑Mɩ 'a dɩ tu ɛ, ɩ nɩɛ nyiɔ 'ɔ ‑paadɩ ‑o. ");
INSERT INTO wob_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","Dɩ \"klein nyiɔ sea \"i juo‑ 'de ɔ nʋa tɛin\" ‑nʋ ‑nʋ ‑wɛe ‑ɛ ‑jɛɛa 'de ‑sɩanwɩ 'di ɛ, Kea se ‑mɩ kɩɩn 'kpa, 'kaa ɛɛ 'da nyʋ ‑ʋʋ ‑nɩa dɩ ‑wee' \"klein 'mii 'mɛ la, ‑wɛe ʋʋ 'je ʋʋa' dɩsaɩn \"i juo 'de ʋʋ 'je 'e ɛ o \"biie‑. ");
INSERT INTO wob_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","Ɛ ‑tuɛ\" nɔ\" ‑wɛe \"ju ɛ ‑tea' 'o ɛ, ɔ 'e 'kmʋ ‑wee' \"klein 'a 'pee 'je 'de \"isrɛa' 'ʋn. Ɛ to ɛɛ' sʋn 'mɛ 'bo nyʋ ‑wee' \"juɔi, 'de ɔɔ' \"ju tu 'a \"kunyɩɔ' sɔan' 'ʋn. ");
INSERT INTO wob_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","Ʋʋ 'wɔan \"kunyɩɔ' sɔn‑tɩ 'de Pɔo 'wɔn 'sʋ ʋʋa' jrʋ' ‑teɛ ɔɔ' wlaa' ‑pʋn\", jrʋ' 'na : ‑Ɩn ‑bɔ, ‑aa muɛ ‑ma wlu doin\" o poa' 'wɩ jrɛ' 'de ɩa' dɩ tu 'a ‑tɩ' 'ʋn. ");
INSERT INTO wob_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","'Kamɔ ʋʋ nʋ ‑wɛe Pɔo 'wlʋ 'o ʋʋa' ‑kwea'‑. ");
INSERT INTO wob_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","'Kaa ʋʋa' jrʋ' ‑wlʋ 'e ʋʋpʋ \"klu ‑ʋʋ ‑jea Kea 'a ‑tɩ' tɔ' 'ʋn. Ʋʋa' due' ‑nɩ Deinsɩ, ‑mɔ nɩɛ ‑gbajei ‑o 'de ʋʋa' 'sra klaa\" ‑nɛ ‑sɔn, ɛ ke 'nynɔkpao' due' ‑ʋa 'nynɩ nɩ Damarisɩ ke nyʋ jrʋ' ke‑. ");
INSERT INTO wob_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","Ɛ 'wlʋa 'o mu ɛ, Pɔo 'wlʋ 'o Atɛnɩ 'mɛ ‑wɛe ɔ mu Korɛntɩ. ");
INSERT INTO wob_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","'Bomɔ ɔ jɛɛ Suifʋi due' ɔɔ' 'nynɩ ‑nɩ Akilasɩ. Ɔ 'wlʋʋ 'de Pɔnblʋa \"kpei. Ɔ ke ɔɔ' 'nynɔ Plisilɩ a 'wlʋɛ 'e Itali dɛ‑nʋɛ' Klodɩ ‑ɔ ‑nɩa 'blʋajei 'demu ɛ, ɔ nʋɛ Suifʋ ‑wee' \"klein i ʋʋ 'je 'o Rɔmʋ 'wlʋ. 'Sʋ Pɔo mu' ɔ ke ʋʋ 'e 'jee‑ ‑wɛe ɔ 'nɛ 'e ʋʋpʋ ‑pʋn\". ");
INSERT INTO wob_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","'De see ɛ, Pɔo 'a dbo ɔɔ nʋa mɛ ‑nɩ ɔɔ dba ‑tan 'tanfɔ. 'De dbo due' ‑nɛ mɛ Akilasɩ a nʋ ‑ke. Ɔ ke ʋʋ \"tii‑ ‑wɛe ɔ ke ʋʋa nʋ dbo ‑tadue. ");
INSERT INTO wob_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","‑Kwlewɩ \"o ‑kwlewɩ o ɛ, Pɔo a muɛ 'e Suifʋ‑wi\" 'a \"jrui 'kɩɩn‑gbu 'di ‑wɛe ɔɔ tɔɔ nyʋ Sesi 'a ‑tɩ', dɛ‑nʋɛ' ɔɔ nɩɛi\" Suifʋ ke Glɛkɩ‑wi\" 'je Sesi 'a ‑tɩ' tɔ' 'ʋn 'je. ");
INSERT INTO wob_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","'Kaa Silasɩ ke Timote 'wlʋa 'e Masedoanɩ ‑wɛe ʋʋ jia 'bomɔ Pɔo a \"duo ɔɔ' nɔ\" ‑wee' 'ʋn 'de ɔɔ 'tmʋ Sesi 'a ‑tɩ' ‑wɛe ka Sesi nɩa Klisɩ, 'de ɔɔ 'nyɩɛ \"kpei 'de Suifʋ‑wi\" ‑pee. ");
INSERT INTO wob_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","'Kaa Suifʋ‑wi\" 'a 'wɔn ʋʋa' po ɔɔ' wlu doin\" o, ʋʋa ‑cree\" 'ɔ. 'Sʋ Pɔo bla ɔɔ' 'ʋnpaadɩ 'mii 'de ʋʋ ‑pee, ka nyɔ ɔ ‑gbaoa' kwa i 'de nyɔ 'ɔ ‑tɩ' 'ʋn ɔɔ nʋa : 'Ɩn se ‑ma ‑tɩ' 'ʋn nɩ 'bode, 'kamɔ ɛ nɩ‑. 'De ɔ wlu ka ɔ 'na : ‑Bo ao \"ma a, ‑mɛ aoa' ‑cɛ\" 'kpa \"jru ‑o, ɛ se 'ma ‑tɩ' nɩ, aoa' nymɔ se 'bo 'ʋn \"jru nɩ‑. Dɛ ‑tba' ‑ta kaan la 'ma muɛ 'e nyʋ ‑sea' Suifʋ nɩ o \"biia'. ");
INSERT INTO wob_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","'Sʋ Pɔo \"siɛ \"kpae' ‑wɛe ɔ mu 'e \"ju due' ‑ɔɔ 'nynɩ nɩa Titisɩ Sitisɩ wɔin\". Ɔɔ' \"ju tu a pleeɛ Kea. Ɔɔ' ‑gbu\" ke Suifʋ‑wi\" 'a \"jrui 'kɩɩn‑gbu tbaa ba \"i. ");
INSERT INTO wob_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","'De \"jrui 'kɩɩn‑gbu ‑nɛ, \"ju ‑nɩa ɛɛ' ‑jeopoi ɔɔ' 'nynɩ nɩa Krisipuisɩ ‑mɔ 'jeɛ Tʋ\"bo 'a ‑tɩ' tɔ' 'ʋn, ɔ ke ɔɔ' ‑gbu\" ‑sɔn nyʋ ke. Korɛntɩ nyʋ ‑tuu\"‑tuu ‑poa' Pɔo 'a wlu doin\" ɛ, ʋʋ ‑wee' 'jeɛ Sesi 'a ‑tɩ' tɔ' 'ʋn ‑wɛe ʋʋ nʋ ʋʋ poo \"ni \"jru. ");
INSERT INTO wob_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","'De \"maʋ'wɩ due' ‑nɛ 'di 'sʋ Pɔo ja ja. 'De ɛɛ' ja tu 'ʋn Tʋ\"bo wlu ɔ ‑pee ɛ 'na : Faʋn 'bo ‑ʋn nʋɛ ! ‑Ɩn kpa 'ma ‑tɩ' 'tmʋa' nya, ‑ɩn ‑bo wɔn \"muɛ, ");
INSERT INTO wob_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","dɛ‑nʋɛ' 'ɩn ke ‑ɩn ‑na', nyɔ jrɔ' se ‑ʋn sʋn ‑pʋn\" kpai ‑wɛe ‑ma dɛsaʋn \"jrii nʋ‑tɩ. 'Kaa nyʋ ‑ʋʋ ‑nɩa 'ma nyʋ ɛ, ʋʋ ‑tiɛi\" 'bo ‑kwlɔ ‑nɛ 'di. ");
INSERT INTO wob_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","'Sʋ Pɔo nʋɛ 'o Korɛntɩ ‑sʋn due' 'cʋɩ ‑mɛɛo\"‑ ‑wɛe ɔ tɔɔ nyʋ Kea 'a wlu. ");
INSERT INTO wob_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","Nɔ\" ‑ɛ 'di Galiɔn nɩa 'blʋajei 'de Akaiblʋa \"kpei ɛ, 'bomɔ Suifʋ‑wi\" poo wlu ‑tadue 'de Pɔo 'a 'dii 'blea 'a ‑tɩ' 'ʋn ‑wɛe ʋʋ kpɔ 'e 'pee 'jei \"juɔi. ");
INSERT INTO wob_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","'De ʋʋ wlu ka ʋʋ 'na : \"Ju ‑nɔ ɔɔ ‑pɔn ɔ 'je nyiɔpʋ 'a \"jru ‑jei\" ‑saa 'de ʋʋ se Kea ‑gbɛɛ' i ka Moisɩ 'a kɛ' \"sia 'nynɩ ɛ. ");
INSERT INTO wob_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","Pɔo a jiɛ wlua' ‑pʋn\" ‑tea' 'sʋ Galiɔn wlu 'e Suifʋ‑wi\" ‑pee ɔ 'na : 'Oo Suifʋ, ‑bo ɛ nɩ nyʋ 'srɛ i poo ‑tɩ ke \"ikma ‑tɩ jrɩ' kaan 'de ɛ, ‑mɛ 'ɩn 'beeɛ' 'ɩn 'je 'ma nɔ\" 'ʋn \"duo‑ ‑wɛe 'ɩn 'je aoa' wlu doin\" o po. ");
INSERT INTO wob_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","'Kaa ‑bo ɛ nɩ ba o ‑too' ‑tɩ 'de 'nynɩ jrɩ' ke aoa' ‑cɛ\" 'kpa 'a kɛ'ɛ ‑tɩ' 'ʋn ɛ, ‑mɛ aoa' 'sʋ 'a ‑tɩ' ‑nao, 'ɩn se dɩ ‑nɩa 'mʋa 'a 'pee 'jei. ");
INSERT INTO wob_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","‑Wɛe ɔ nʋ ʋʋpʋ i 'de ʋʋ 'wlʋ 'e 'pee 'je ‑gbu 'di. ");
INSERT INTO wob_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","'Sʋ ʋʋ ‑wee' 'wla 'e Sostɛnɩ ‑nɩa Suifʋ‑wi\" 'a \"jrui 'kɩɩn‑gbu 'a ‑jeopoi \"kpei ʋʋ ‑te ɔɔ' blaa' ‑pʋn\" 'bo 'pee 'je ‑gbu \"juɔi 'mʋa‑, 'kaa ɛ se Galiɔn ka \"i da mɔ \"pɩ. ");
INSERT INTO wob_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","Pɔo ‑kwle 'o Korɛntɩ 'mɛ kpɩɩn‑ ke'wlɛ, ‑wɛe ɔ ke ɔɔ' de'di ‑wi\" poo wlu 'sʋ ɔ 'ja 'e ‑bato' 'di ‑wɛe ɔ ke Prisilɩ ke Akilasɩ mu 'e Siri. Ʋʋ 'wɔan 'e ‑bato' 'di 'kpa‑tɩ 'bo Sankre ɛ, Pɔo 'wla \"jru i, dɛ‑nʋɛ' ɔ cɛn ɛɛ' wlu ‑tie\" 'bo Kea \"juɔi 'de‑. ");
INSERT INTO wob_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","Ʋʋ nynia 'o Efɛsɩ ɛ, 'bomɔ Pɔo sie ɔ \"dɛi ‑wi\" 'sʋ ɔ pa 'e Suifʋ‑wi\" 'a \"jrui 'kɩɩn‑gbu 'di ‑wɛe ɔ ke Suifʋ‑wi\" a wlu. ");
INSERT INTO wob_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","'Sʋ ʋʋa baeɔ' 'de ɔ 'je 'o ʋʋpʋ o 'wɩ nʋ, 'kaa ɔ sɩ 'wɔɔn‑, ");
INSERT INTO wob_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","‑wɛe ɔ ke ʋʋ cɩɩɛn \"i 'de ɔ 'na : 'Ɩn 'je ‑kɔ' ‑ɔ jia nynia' ‑sɔn mu ‑o mamaʋ 'de Selisalɛm. 'Ma muɛ 'nɔ aopʋ o de jia' ‑bo Kea ‑nɩɛi\" ɛ. 'Sʋ ɔ 'wlʋ 'o Efɛsɩ 'mɛ. ");
INSERT INTO wob_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","Ɔ 'wlʋa 'de ‑bato' 'di ɔ \"siɛ i 'bo Sesare 'sʋ ɛ, ɔ muɛ Selisalɛm de. Ɔ ke Kea ‑gbu ‑koa' 'jeea 'sʋ ɔ muɛ Antiɔsɩ. ");
INSERT INTO wob_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","Ɔ nʋa 'bo Antiɔsɩ 'wɩ pla 'sʋ ɛ, ɔ 'kpa ‑jei\" ‑wɛe ɔɔ jii Galasiblʋa ke Frisiblʋa \"kpei i 'de ɔɔ kuu nyʋ \"klein ‑ʋʋ ‑jea Sesi 'a ‑tɩ' tɔ' 'ʋn 'a dɩ i. ");
INSERT INTO wob_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","Suifʋi due' ‑ɔɔ 'nynɩ nɩ Apolɔsɩ, ɔ 'wlʋʋ 'de Alɛsandri ɔmɔ ‑ji' 'o Efɛsɩ. Ɔɔ' \"ju tu cɛn wɔn i. Kea 'a wlu ‑crɩɩa' ɔ juo ɛɛ' wɔ ‑sa ka 'mɛ 'pepe. ");
INSERT INTO wob_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","Ɔ ‑tuu\" ɛ 'snɩ 'bo Tʋ\"bo 'a ‑jei\" ‑wɛe ɔ nɩ nɛ \"kpei. Ka Sesi 'a \"kpei ‑tɩ nɩa \"klein, 'kamɔ ɔɔ ‑sɛ' wɔ 'de nyʋ ‑pee, ɔɔ' sie 'o dɛ jrɛ', 'kaa San 'a nyʋ \"ni \"jru po ‑tɩ 'a 'sʋ mɛ ɔ juo‑. ");
INSERT INTO wob_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","Ɔ ‑teɛ wlua' ‑pʋn\" 'de 'flɛ 'ʋn 'de \"jrui 'kɩɩn‑gbu 'di. Prisilɩ ke Akilasɩ 'wɔan ɔɔ' wlu 'sʋ, ʋʋ \"duo ɔ 'ʋn 'ɛ, 'de ʋʋ ke ɔ mu 'e ʋʋ wɔin\", ‑wɛe ka Kea 'a ‑jei\" naa ‑tɩ 'pɛan 'de ʋʋ ‑sɛ' wɔ 'pepe 'de ɔ ‑pee. ");
INSERT INTO wob_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","Ɛ 'wlʋa 'o ɛ, Apolɔsɩ nɩɛ \"i ɔ 'je 'e Akai mu. 'De ɛɛ' ‑tɩ' 'ʋn Kletiɛn‑wi\" kuuɛ ɔɔ' dɩ i 'sʋ ʋʋ 'crɩɛ 'sbɛ‑ ‑wɛe ʋʋ \"nyɩ ɔ, 'de nyʋ ‑jea Sesi 'a ‑tɩ' tɔ' 'ʋn 'de ɛɛ' 'blʋa 'a 'fɔ tu o 'je ɔ sɩn 'sɔɔn kpʋʋn‑. Ɔ nynia 'e mu ɛ, nyʋ Kea nʋa 'saaʋn \"jrii, ‑wɛe ‑ʋʋ ‑jea ɛɛ' ‑tɩ' tɔ' 'ʋn ɛ, ɔ poɛ ʋʋpʋ sʋn o. ");
INSERT INTO wob_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","Ɔ tba Kea 'a wlu ‑ɛ ‑crɩɩa' ‑gbɔo \"jri ‑sisi' ‑wɛe ɔɔ toɛ 'bo nyʋ ‑wee' \"klein \"juɔi ka Sesi nɩa Nyʋ 'pʋʋi ɛ. 'De ɛɛ' ‑tɩ' 'ʋn ɛ, dɛ ʋʋ 'jea 'tmʋ, ɛ se nɩ 'bode. ");
INSERT INTO wob_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","‑Ta Apolɔsɩ nɩɩa Korɛntɩ ɛ, 'bo Pɔo plee Asiblʋa 'a crʋɩ \"kpei‑ ‑wɛe ɔ nyni 'o Efɛsɩ. Ɔ jɛɛ 'o Kea 'a ‑jei\" naaʋn jrʋ' ‑wɛe ɔ ‑tee' ʋʋpʋ i, ɔ 'na : ");
INSERT INTO wob_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","‑Ta ao ‑teea Kea ‑kwlɩ\" 'dee, ao 'je ɛɛ' ‑Suu 'mɛɛ ? 'Sʋ ʋʋ wlu' 'de ɔ o ka, ʋʋ 'na : Ka Kea 'a ‑Suu mɛ nɩa 'kmʋ ‑a se ɛ juo. ");
INSERT INTO wob_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","'Sʋ Pɔo ‑teeɛ' ʋʋpʋ i ɔ 'na : batise ‑jɛwɛ‑ ʋʋ nʋ aopʋ ɛ‑ ? Ʋʋ 'na : Ɛ San 'a nyʋ batise nʋsʋn mɛ ʋʋ nʋ ‑aʋn. ");
INSERT INTO wob_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","'Sʋ Pɔo 'na : Nyʋ ‑ʋʋ ‑wɔɔan' dɛsaʋn 'a \"i juo ‑tɩ, ʋʋpʋ San po \"ni \"jru ‑wɛe ɔ wlu 'e ‑pee 'de ʋʋ 'je \"ju ‑ɔɔ jia 'e de 'a ‑tɩ' tɔ' 'ʋn 'je, ɔmɔ ‑nɩ Sesi. ");
INSERT INTO wob_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","Ʋʋ 'wɔan ɛɛ' wlu tu 'sʋ ʋʋ pooɛ \"ni \"jru 'de Tʋ\"bo Sesi 'a 'nynɩ 'ʋn. ");
INSERT INTO wob_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","Pɔo ‑tea' ʋʋpʋ kwa \"jru 'sʋ Kea 'a ‑Suu \"ji 'de ʋʋpʋ 'ʋn 'ɛ, ‑wɛe ʋʋ ‑te wlu dee poa' ‑pʋn\" 'de Kea a jaa ʋʋpʋ wlu 'kwa. ");
INSERT INTO wob_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","Ʋʋ beea o ɛ, ʋʋ 'bɛɛ‑ \"nynunmai 'a ‑puue 'jɔ 'sɔɔn 'mɛ. ");
INSERT INTO wob_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","'Bo ‑mɛ 'de ɛ, Pɔo muɛ 'e Suifʋ‑wi\" 'a \"jrui 'kɩɩn‑gbu 'di ‑wɛe ɔ wai ɔɔ tɔɔ nyʋ dɛ. 'De 'cʋɩ taan 'di, ɔɔ ‑pɔn nyʋ ‑ʋʋa poa ɔɔ' wlu doin\" o ɛ, ʋʋ 'je Kea 'a tʋ\"bodɛ 'ɛ ‑tɩ' tɔ' 'ʋn 'je. ");
INSERT INTO wob_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","'Kaa Suifʋ‑wi\" 'a jrʋ' kuɛ \"jru, ʋʋ kmuuɛ pɛe \"i ‑wɛe ʋʋa ‑flɛɛn Tʋ\"bo 'a ‑je 'bo nyʋ ‑kwea de \"juɔi. 'Sʋ Pɔo ke ʋʋpʋ cɩɩɛn \"i ‑wɛe ɔ ke Kletiɛn‑wi\" 'wlʋ 'de ʋʋa' \"jrui 'kɩɩn‑gbu 'di, 'de ʋʋ mu 'de Tiranisɩ 'a klai\" ‑gbu 'di. 'Bomɔ ɔɔ tɔɔ nyʋ dɛ 'wɩ \"o 'wɩ. ");
INSERT INTO wob_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","'Kamɔ Pɔo nʋ mamaʋ 'de ‑sɩn 'sɔɔn 'di. 'Sʋ Suifʋ ke Glɛkɩ‑wi\" ‑nɩa 'e Asi ‑wee' 'wɔn Tʋ\"bo 'a wlu 'mɛ. ");
INSERT INTO wob_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","Kea a nʋɛ jrii' klae\" klae\" 'bo Pɔo ‑cɩɛi\". ");
INSERT INTO wob_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","Ɛ nʋɛ 'sʋ tae'fɔ ke ‑misrɔ ‑ɩ bla Pɔo 'a ku \"i ɛ, ɩmɩ nyʋ a ‑te 'o 'wɛ‑nʋʋ \"kpei ‑wɛe ʋʋa' 'wɛ‑ ɛ 'bɔ, 'de ‑siisaɩn a 'wlʋ 'e ʋʋpʋ 'ʋn. ");
INSERT INTO wob_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","'Sʋ Suifʋ jrʋ' ‑ʋʋa plea dɩ 'mii ‑wɛe ‑ʋʋa nʋa ‑siisaɩn, ʋ ‑pʋ' ‑a ‑pɔn ‑ʋʋ ‑je ‑siisaɩn i nʋ 'de Sesi 'a 'nynɩ 'ʋn ‑ke. Ʋʋpʋ ‑wlu ka 'de ‑siisaɩn ‑pee ʋʋ 'na : 'Ma wluɛ ɩ ‑pee ɩ \"si \"kpae' 'de Sesi ‑ɔɔ ‑tɩ' Pɔo a 'tmʋa 'a 'nynɩ 'ʋn. ");
INSERT INTO wob_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","Nyʋ ‑ʋʋa nʋa dɛ ‑nɩa 'mʋa‑ Suifʋ‑wi\" 'a 'sraa ‑sai klaa\" Sefa 'a \"nynunmai ‑nɩa ‑mɛ\" 'sɔn, ‑o. ");
INSERT INTO wob_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","'Sʋ ‑suusaʋn due' wluɛ ʋʋpʋ ‑pee, ɛ 'na : 'Ɩn juo Sesi 'mɛ, ‑wɛe dɛ Pɔo nɩa 'ʋn ɛ, 'ɩn juo ‑mɛ, 'kaa aopʋ mɔ 'ee, aoa' 'nynɩ wɛ‑ ? ");
INSERT INTO wob_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","'Sʋ \"ju ‑suusaʋn nɩa 'e 'ʋn ‑teɛ ʋʋpʋ blaa' ‑pʋn\", 'kamɔ ɔ bla ʋʋpʋ mamaʋ 'sʋ ʋʋ 'kpa 'kwla ‑wɛe ʋʋ 'wlʋ 'o ɔ \"juɔi. ‑Ta ʋʋ muua ʋʋ cɛn kui, ʋʋ nɩɛ ‑kɔ'ɔ 'sʋ ‑ta ‑wee'. ");
INSERT INTO wob_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","Dɛ ‑nʋʋa 'mʋa‑ Suifʋ o, Glɛkɩ‑wi\" ‑nɩa 'o Efɛsɩ ɛ, ʋʋ ‑wee' \"klein 'wɔɛn, 'de ɛɛ' ‑tɩ' 'ʋn ɛ, faʋn \"ji 'e nyʋ ‑wee' \"klein 'ʋn 'ɛ, 'sʋ ʋʋa ‑teɛ' Tʋ\"bo Sesi 'a 'nynɩ 'a ni'. ");
INSERT INTO wob_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","Nyʋ ‑ʋʋ ‑jea Sesi 'a ‑tɩ' tɔ' 'ʋn ɛ, ʋʋa' ‑tuu\"‑tuu ji' ‑wɛe dɩ saɩn ʋʋ nʋa ʋʋa 'tmʋ ɩ 'bo nyʋ ‑kwea‑. ");
INSERT INTO wob_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","'De ʋʋpʋ \"klu ɛ, nyʋ ‑tuu\"‑tuu ‑nɩ 'e ‑ʋʋ po nyʋ 'srɛ i po jrii' tɛin\" ‑poo ‑poo\"‑. Ʋʋa' jrʋ' ja ʋʋa' jrii' posbɩ 'mɛ ‑wɛe ʋʋ po ɩ \"jri 'bo nyʋ ‑wee' \"juɔi. Nyʋ a naa tɔ' i ɩa' 'sbɩ tu 'a sɔɔn' nɩɛ 'wɛi 'a ‑kwlʋ due'. ");
INSERT INTO wob_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","'Kamɔ Tʋ\"bo 'a wlu a 'kpa \"kpei, ɛɛ kmaa' \"i, ɛɛ \"nyɩ nyʋpʋ‑ 'kpɩ. ");
INSERT INTO wob_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","Ɩa' dɩ tu 'wlʋa 'o ‑jei\" ɛ, Pɔo nɩɛ \"i ɔ 'je Masedoanɩ ke Akai 'ʋn ‑tie\" cɛn ‑wɛe ɔ 'je Selisalɛm mu, 'de ɔ wlu ka ɔ 'na : ‑Bo 'ɩn nyni 'e ɛ, ‑mɛ 'ɩn 'je Rɔmʋ 'je ‑o ‑ke. ");
INSERT INTO wob_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","'Sʋ ɔ dboɛ nyʋ ‑ʋʋa po ɔ sʋn o 'a 'sɔɔn nya 'de Masedoanɩ. Timote ke Erasɩ ke‑ mʋ ɔ dbo, ‑wɛe ɔ mɔ'ɔ ‑cɛ\" 'kpa nʋ 'e Asi nɔ\" pla ke'wlɛ. ");
INSERT INTO wob_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","'De ɛɛ' nɔ\" tu 'di nyʋ tai' \"maa' dɩ klae\" nʋʋɛ' 'de Tʋ\"bo 'a ‑jei\" naa ‑tɩ 'ʋn. ");
INSERT INTO wob_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","\"Ju due' nyʋ a 'daa‑ Demetrisɩ ɔ nɩɛ nɩɩblai ‑o, ɔɔ nʋɛ 'wɛi ‑wɛe ɔɔ bla ‑gbi\" nynuu mɩɩ\" ‑ɩ ‑ke ʋʋa' kɔun‑ kea Dianɩ 'a ‑gbu\" ‑kooa', ɩmɩ ɔɔ ple ‑wɛe ɔ ke ɔɔ' dbonʋʋn a 'je \"wliiɛ‑. ");
INSERT INTO wob_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","Ɔ 'kɩɩɛn ɔɔ' dbonʋʋn ke nyʋ ‑ʋʋ ‑ke ɔ 'blea dbo due' \"jrui, 'de ɔ wlu ʋʋpʋ ‑pee ka ɔ 'na : 'Ma 'cɛ, ao 'je kan' 'mɛ 'de dbo ‑nɛ 'ʋn ɛ, 'bomɔ ‑aa dɛ 'ʋn 'wlʋa' ‑wee' nɩ‑. ");
INSERT INTO wob_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","'Kaa dɩ \"klein Pɔo 'tmʋa aoa 'wɔɩn, ɛ se ‑ta Efɛsɩ 'a 'sʋ nɩ‑. Ɔɔ 'tmʋ ɛɛ' dɛ tu 'mɛ 'de Asi 'a ‑kwlɛ ‑tuu\"‑tuu 'dii ɔ 'na : ‑Kɩɩ' ‑jɩ nyiɔ 'ɔ sʋn nʋa ‑mɩ se Kea nɩ‑. Ɛɛ' wlu tu ɛ, ɛ dooa ‑aa dbo 'mɛ. ");
INSERT INTO wob_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","Ɛ se ‑aa dbo 'a 'sʋ ɛɛ dooa nɩ‑, 'kaa ɛɛ dooa Dianɩ ‑ɛ ‑nɩa ‑aa kea 'a ‑gbu\" 'a 'nynɩ. ‑Wɛe Dianɩ ‑kea'‑ Asiblʋa ke 'kmʋ ‑wee' a ‑gbɛɛa' 'je \"ku \"kpei 'wlʋ 'de ʋʋ seɛ dɛ 'daa i. ");
INSERT INTO wob_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","Ʋʋ 'wɔan wlu ‑nɩa 'mʋa‑ 'sʋ ʋʋ 'kpa 'cɛn, ʋʋ ‑teɛ ‑cruɛn\" ‑saa' ‑pʋn\" ʋʋ 'na : Dianɩ ‑ɛ ‑nɩa Efɛsɩ‑kɔʋn 'a ‑kea ɛ 'bɛi\" ! ");
INSERT INTO wob_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","'Sʋ ʋʋ ‑teɛ ‑kli poa' ‑pʋn\" 'bo ‑kwlɔ ‑wɛe ʋʋ ‑wee' 'kɩɩɛn \"jrui 'bo ‑kwlɔ ‑kwea. Kaisɩ ke Aritakɩ ‑ʋʋ ‑nɩa Masedoanɩ ‑nyʋ ‑wɛe ʋʋ ‑ke Pɔo a na ʋʋ kpʋn ʋʋpʋ 'mɛ ‑wɛe ʋʋ kpa ʋʋpʋ 'e ‑kwlɔ ‑kwea. ");
INSERT INTO wob_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","Pɔo nɩɛ \"i ɔɔ' ‑cɛ\" 'kpa 'je de 'wlʋʋ‑ 'bo nyʋ ‑kwea de \"juɔi, 'kaa Kletiɛn‑wi\" kaan ɔ ‑je de. ");
INSERT INTO wob_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","Dɛ \"ijuoʋn jrʋ' ‑ʋʋ ‑nɩa 'e Asi ‑ʋʋ ‑ke Pɔo dbɛɛa ʋʋ dboɛ nyʋ 'de Pɔo o ‑wɛe ʋʋ 'je ɔ 'tmʋʋ‑ 'de ɔ je 'e ‑kwlɔ ‑kwea mu. ");
INSERT INTO wob_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","Nyʋ ‑ʋʋ ‑kɩɩan' \"jrui 'de ɛɛ' nɔ\" tu 'di 'de ‑kli poa 'a 'ʋn ɛ, dɛ jrʋ' a 'tmʋa jrʋ' 'a 'wɔn ɛ 'mii, nyʋ jrʋ' ‑nɩa 'de ʋʋ \"klu ɛ, dɛ ‑ɛɛ \"jrui ʋʋ 'kɩɩan ‑gblein' ɛ, ʋʋ se ɛ juo‑. ");
INSERT INTO wob_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","'Sʋ ʋʋ ‑sa Alɛsandrɩ 'de nyʋ \"klu, ɔmɔ Suifʋ‑wi\" a poo 'e nya ‑wɛe ɔ ‑kaa' nyʋ kwai\" 'de ɔ nɩɛ \"i ɔ 'je ʋʋ ‑pee wlu‑. ");
INSERT INTO wob_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","'Kaa ka ɔ nɩa Suifʋi ʋʋ 'jea kan' 'sʋ ʋʋ ‑teɛ \"wɔa' ‑pʋn\" ʋʋ 'na : Dianɩ ‑nɩa Efɛsɩ‑kɔʋn 'a ‑kea'‑ ɛ 'bɛi\" ! ");
INSERT INTO wob_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","‑Kwlɔnjei mɔ ‑ɔ ji' ‑wɛe ‑ɔ ‑kaa' ʋʋpʋ 'ʋn 'de ‑ɔ wlu ka ‑ɔ 'na : Aopʋ Efɛsɩ‑kɔʋn, nyʋ ‑wɛ ‑seɛ' juo ka Efɛsɩ‑kwlɔ nɩa Dianɩ ‑kea 'a ‑gbu\" ke ɛɛ' kooɔ' dɛ ‑wlʋa 'e jaʋn 'di 'a 'deifuoi ɛ ? ");
INSERT INTO wob_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","Nyɔ ‑ɔ ‑jea ɛɛ' dɛ tu 'ʋn ‑too' ɔ se nɩ‑. Ao ‑te 'tɩɩn, ao 'bo dɛ \"o dɛ‑nʋɛ' 'de \"kpeicrɛa' 'ʋn. ");
INSERT INTO wob_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","Dɛ‑nʋɛ' nyʋ ao ja ‑ta se dɛsaʋn jrɛ' nʋ 'de ʋʋ se ‑aa Dianɩ ‑kea wɔn o to‑. ");
INSERT INTO wob_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","'De ‑bo Demetrisɩ ke ɔɔ' dbonʋʋn nɩɛ \"i ʋʋ 'je nyɔ \"kuan poo ɛ, ‑mɛ 'wɩ nyʋ a 'jea 'pee i ɛ, ʋʋ juɩ'. 'De ʋʋ juo nyʋ ‑ʋʋa ‑jea nyʋ 'a 'pee 'mɛ ‑ke, ‑mɛ 'demɔ ʋʋ 'je mu ‑wɛe ʋʋ 'e \"kuan po ka‑. ");
INSERT INTO wob_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","'De ‑bo aoa sea dɛ jrɛ' i ‑tee' ɛ, nyʋ a muɛ ‑mɛ 'tmʋa' 'bo nyʋ ‑wee' \"juɔi. ");
INSERT INTO wob_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","Nyʋ a muɛ ‑a ‑klipoʋn 'daa' 'de dɛ ‑nʋʋa ‑sɩan ‑ta 'a ‑tɩ' 'ʋn, 'de bɔ' ‑a bla ‑ta, ɛ se 'jɔ 'ble. ‑Bo nyɔ ‑tee' ‑a i ɛ, ‑ta ‑a ‑jea \"kuan ‑sa ‑wɛe ‑a ‑je ɛ po, 'bo se nɩ‑. ");
INSERT INTO wob_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","Ɔ ‑kɔa' wlu ‑nɩ 'a 'tmʋa' 'sʋ ɔ poɛ ʋʋ ‑wee' ‑jei\", ‑wɛe ʋʋ mu ‑gbɛin\" o i. ");
INSERT INTO wob_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","‑Ta ʋʋa' ‑kli ‑nɛ 'bɔa 'sʋ Pɔo 'kɩɩɛn nyʋ ‑ʋʋ ‑jea Sesi 'a ‑tɩ' tɔ' 'ʋn \"jrui ‑wɛe ɔ kuu ʋʋpʋ 'a dɩ i, 'de ɔ ke ʋʋpʋ poo wlu, ‑wɛe ɔ mu Masedoanɩ de. ");
INSERT INTO wob_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","Ɔ pleɛ ɛɛ' 'blʋa‑ tu \"kpei‑ ‑wɛe ɔɔ \"nyɩ Kletiɛn‑wi\" 'kpɩ 'de wlu ɔɔ 'tmʋa 'ʋn. 'Sʋ ɔ muɛ 'e Grɛsɩ. ");
INSERT INTO wob_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","'Bomɔ ɔ nʋ 'cɩ taan. Ɔ ‑teɛ ‑bato' 'di 'kpa ‑tɩ ‑wɛe ɔ 'je 'e Siri mu 'de‑. 'Sʋ ka Suifʋ pooa ɔɔ' dɛsaʋn \"jrii nʋ ‑tɩ, ɔ 'wɔɩn 'sʋ ɔ 'na : ‑Bo ɛ nɩ kan', ‑mɛ 'ma muɛ 'e Masedoanɩ de. ");
INSERT INTO wob_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","Nyʋ ‑ke ɔ mua mamaʋ ‑ʋʋ nynia 'de Asi 'a 'nynɩ ka : Pirisɩ 'a \"ju Sopatɛɛ ‑mɔ 'wlʋɛ Bere, Aritakɩ o Sekɔn 'wlʋɛ Tesalonikɩ, Kaisɩ ‑wlʋa Dɛɛbʋ ke Timote ke, ɛ ke Tisikɩ ke Trofimʋ, ‑wi\" ‑mʋ 'wlʋɛ 'e Asi. ");
INSERT INTO wob_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","Nyʋ ‑nʋ ʋʋ ‑pʋ ‑si' 'e nya ‑wɛe ‑ʋʋa fuo ‑aʋn 'bo Troasɩ. ");
INSERT INTO wob_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","‑Apʋ mɔ ɛ, ‑bo Suifʋ‑wi\" 'a ‑kɔ' ‑ɛɛ 'nynɩ nɩa ‑di'pɛn ‑ɛ sea ‑puun\" dɛ o mu 'a ‑kɔ' 'wlʋ 'o ‑jei\", ‑wɛe ‑a ‑kpa ‑bato' 'di 'bo Filipʋ 'de ‑a nʋ 'wɩ ‑mm\" 'bo ‑jei\" ‑wɛe ‑a ‑jɛɛ ʋʋpʋ 'bo Troasɩ 'de ‑a ‑wee' nʋ 'o 'dɔɔ due'. ");
INSERT INTO wob_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","'Dɔɔ \"i‑saawɩ 'a ‑kwie\" ka a, ‑a ‑kɩɩɛn' \"jrui ‑tadue ‑wɛe ‑a ‑je Tʋ\"bo 'a diidɛ di 'sʋ Pɔo a wlu 'de Kletiɛn‑wi\" ‑pee, dɛ‑nʋɛ' ‑bo ‑sɔn' ‑sɩn' ɛ, ɔɔ muɛ mua', 'kamɔ ɔ wlu mamaʋ 'sʋ ‑too' cɛn 'ʋn. ");
INSERT INTO wob_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","'De nɛbi ‑tuu\"‑tuu ‑nɩ 'e \"jɛi ‑gbu 'di ‑a ‑kɩɩan' \"jrui ɛ. ");
INSERT INTO wob_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","'De ‑kooa\" i ‑tɔo due' ‑ɔɔ 'nynɩ nɩa Etisisɩ ɛ, ɔ ‑teɛ 'bo flɛn'mɛtɩ \"i. ‑Ta Pɔo nɩɩa wlu ‑tɔɔn ‑nɩ 'a 'tmʋa 'a, ‑mɛ ɔ nɩɛ 'e \"nyɩɔ 'ɔ bie'. Ɔɔ' \"nyɩɔ' 'mʋa‑ nʋɛ' 'sʋ ɔ je 'e \"jɛi‑gbu 'a taan ‑nɛ 'di 'wlʋ, ɔ je i ‑ka 'nɔ ‑sɔn. ‑Ta nyʋ a kpɔɔ \"jɛi, ‑mɛ ɔ 'mɛɛ. ");
INSERT INTO wob_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","'Kaa Pɔo \"siɛ i, ɔ jiɛ ja 'bo ɔ \"kpei ‑wɛe ɔ \"duo ɔ 'ʋn, ɔ po ɔ sɩn 'dii 'de ɔ 'na : Ao 'bo pɛe i pleɛ, dɛ‑nʋɛ' ɔɔ' ‑suu nɩ 'de ɔ 'ʋn 'ɛ ke. ");
INSERT INTO wob_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","'Sʋ ɔ 'ja 'e ‑gbu\" 'di de ‑wɛe ɔ cɩɛn ‑di'pɛn i 'de ʋʋ di ɛ, ‑wɛe ɔ ‑te wlua' ‑pʋn\" ke'wlɛ. Ɔ wlu' mamaʋ 'sʋ ‑sɔn' je ‑sɩn'. Ɔ ‑kɔa' wlua' 'sʋ ɔ 'kpa ‑jei\". ");
INSERT INTO wob_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","Ʋʋ ja ‑kooa\" i ‑tɔo ‑nɔ 'ɔ \"kunyɩɔ' sɔn ‑nɛ 'mɛ 'bo ʋʋa' ‑kwea'‑. Ɛɛ' dɛ tu nɩɛ ʋʋa' 'mʋa ‑tɩ klae\" ‑wɛe ɛ kuu ʋʋpʋ 'a dɩ i. ");
INSERT INTO wob_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","‑Apʋ mɔ ɛ, ‑aa muɛ nya ‑wɛe ‑a ‑je ‑bato' 'di 'kpa 'de ɛ 'je ‑a Asɔsɩ kpa. 'Bomɔ ‑a ‑je Pɔo 'ʋn \"duo‑, 'kamɔ ɔɔ' ‑cɛ\" 'kpa nɛɛ tɔ' \"kpei‑, dɛ‑nʋɛ' ɔ nɩɛ \"i ɔ 'je 'blʋɔi naa‑ ‑wɛe ɔ 'je 'o mu. ");
INSERT INTO wob_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","Ɔ jɛɛa ‑aʋn 'bo Asɔsɩ 'sʋ ɛ, ‑a \"duo ɔ 'ʋn 'de ‑bato' 'di ‑wɛe ‑a ‑wee' mu Mitilɛnɩ. ");
INSERT INTO wob_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","‑A ‑wlʋa 'o ‑mɔ ɛ, ‑a ‑naa \"ni \"kpei. ‑Ta ‑sɔn' ɔ ‑sɩan' 'sʋ ‑a nyniɛ 'o Kiosɩ ‑blʋa ‑pʋn\". ‑Sɔn' jrɛ' ‑sɩan' ke'wlɛ ‑a nyniɛ 'o Samɔsɩ‑blʋa \"kpei ‑wɛe ‑a ‑wlʋ 'o ‑mɔ 'de ‑a kpʋn 'kpʋʋ 'bo Mile. ");
INSERT INTO wob_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","Pɔo 'a ‑cɛ\" 'kpa ‑nɩɛ \"i ‑wɛe ‑ɔ ‑blaa Efɛsɩ‑kwlɔ 'de ‑ɔ se bʋ kɔ, ‑wɛe ɔ je nɔ\" ‑wee' ‑sii 'de Asi, dɛ‑nʋɛ' ɔɔ crɛɛ \"kpei‑ ‑wɛe ‑bo ɛɛ' dɛ tu 'bɛɛ‑ ɛ 'je nʋʋ ɛ, 'de ɔ 'je Selisalɛm nɩ‑ Pantekɔtɩ 'a ‑kɔ' wɩ o. ");
INSERT INTO wob_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","'Bo Mile mɔ Pɔo nɩ ‑wɛe ɔ dbo nyʋ Efɛsɩ ʋʋ mu Kea ‑gbu ‑jeopoʋn ‑nɩa 'emu 'daa'. ");
INSERT INTO wob_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","‑Ta ʋʋ nynia 'bo ɔ ‑pʋn\" 'sʋ ɛ, ɔ wluɛ ʋʋ ‑pee ka ɔ 'na : Dɛ ‑wlʋa 'e \"i‑saawɩ ‑ɛ 'di 'ɩn jia 'nɔ Asi ‑wɛe ‑ɛ ‑jɛɛa ‑sɩanwɩ ɛ, ka 'ɩn nʋa nasʋn 'de ao ‑pee ɛ, ao ‑wee' juɛ'. ");
INSERT INTO wob_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","'Ɩn nʋɛ Tʋ\"bo 'a dbo 'de ‑cɛ\" ja jaa' ke \"miini 'ʋn 'de 'kle Suifʋ‑wi\" a ‑tua\" 'ʋn 'a ‑kwea'‑. ");
INSERT INTO wob_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","Ao 'je kan' 'mɛ dɩ \"klein ‑kɔan ‑tɩ' 'de aoa' ‑tɩ' 'ʋn ɛ, 'ɩn se ɩa' dɛ ka 'kwla ‑tu\", faʋn jrɛ' se 'ʋn nʋ. 'Ɩn pleɛ \"kpae' woi ke ‑gbi\" 'dii ‑wɛe 'ɩn 'tmʋ ɩ 'de ao ‑pee, 'de 'ɩn tɔɔ ɩ aopʋ‑. ");
INSERT INTO wob_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","'Ɩn 'da Suifʋ o, nyʋ ‑sea' Suifʋ nɩ 'mɛ 'de ʋʋ 'je ʋʋa' dɩsaɩn \"i juo‑, ‑wɛe ʋʋ 'je 'e Kea o \"biie‑, 'de ʋʋ 'je Tʋ\"bo Sesi 'a ‑tɩ' tɔ' 'ʋn 'je. ");
INSERT INTO wob_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","'De kaan ka, Kea 'a ‑Suu ‑teɛ' 'ʋn ‑klaan\" \"kpei 'de 'ma mu Selisalɛm. Dɛ ‑ɛ ‑jea 'ʋn \"jrii nʋʋɛ 'demu ɛ, 'ɩn se ɛ juo‑, ");
INSERT INTO wob_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","Kea 'a ‑Suu a 'tmʋa 'ʋn ‑pee ‑kwlɔ \"o ‑kwlɔ 'ma cɛɛan 'dii, ɛ 'na : 'De Selisalɛm ‑ma mua, \"cɩn ke 'kle ‑a fuo ‑ʋn 'demu. ");
INSERT INTO wob_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","'Kaa 'ɩn se 'ma ‑cɛ\" 'ɛ 'kmʋ ‑mɛ dɛ 'ʋn 'je. Dɛ ‑kɔan ‑tɩ' mɛ ‑nɩ 'ɩn 'je 'ma plea' nya kpa 'de 'mʋa‑ 'ʋn, ‑wɛe dbo Sesi ‑tea' 'ʋn kwa 'ɩn 'je ɛ \"jru ‑cra'. Ɛɛ' dbo tu mɛ ‑nɩ Kea 'a 'saaʋn ke ‑pɔia\" ‑tɩ 'a 'tmʋa'. ");
INSERT INTO wob_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","Dɛ 'ɩn jua' ɛmɛ ‑nɩ kaan ka la 'ja a, aopʋ ‑ɔ \"klu 'ɩn jiia 'de 'ɩn 'tmʋa Kea 'a tʋ\"bodɛ 'ɛ ‑tɩ' ɛ, 'ɩn 'je kan' 'mɛ ao se 'ma \"jua‑ \"jriɛ‑ 'jeei 'bode. ");
INSERT INTO wob_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","26","Ɛmɛ ‑tɩ 'ma 'tmʋɛ 'pepe 'de aopʋ ‑pee ‑sɩan aoa' nyɔ due' 'a nymɔ se 'ʋn \"jru nɩ‑. ");
INSERT INTO wob_vpl VALUES ("AC20_27","074_20_27","ACT","20","27","27","'Ɩn ‑tu\" ao Kea wlu 'a 'snɩ ‑wee' \"klein 'mɛ, 'ɩn se dɛ jrɛ' 'kwla ‑tu\". ");
INSERT INTO wob_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","Ao ‑tu\" aoa' ‑cɛ\" 'kpa ke aoa' de'di ‑wi\" Kea 'a ‑Suu ‑te ao kwa 'a ‑tɩ'. Kea 'a ‑gbu\" ɛɛ' \"ju 'a nymɔ ‑wla i ‑tɩan' a, ao ‑tu\" ɛɛ' ‑tɩ'. ");
INSERT INTO wob_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","'Ɩn juɛ' ‑bo 'ɩn 'wlʋ 'nɔ nyʋ ka ‑ci' nɩa ‑ʋʋ ‑nɩa kan' a, ʋʋa muɛ 'de aopʋ \"klu jia'. Ʋʋa' nyʋ tu ɛ, ʋʋ se aopʋ \"i \"tai. ");
INSERT INTO wob_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","‑Wɛe 'de aopʋ \"klu nyʋ jrʋ' 'je 'e 'wlʋ 'de ʋʋ 'je sɩ 'tmʋ ‑wɛe ʋʋ 'e Sesi 'a ‑tɩ' tɔ' 'ʋn 'jeʋn 'a \"jru ‑jei\" ‑saa‑. ");
INSERT INTO wob_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","Ao ‑tu\" aoa' ‑cɛ\" 'ɛ ‑tɩ' 'ja, ‑wɛe ka 'de ‑sɩn taan 'di 'ɩn ‑saa aopʋ fɛn' due 'due 'de \"miini 'ʋn jeejee ɛ, ao 'je ɛ ‑kwlʋ o po. ");
INSERT INTO wob_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","Kaan la 'ja a, 'ɩn ‑teɛ' aopʋ‑ Kea ke ɛɛ' 'saaʋnwlu kwa, dɛ‑nʋɛ' ɛmɛ ‑bɛɛ' ‑ɛ ‑je aopʋ‑ 'kpɩ \"nyɩ, ‑wɛe ao ke nyʋ ɛ ‑teea kpɔi\" 'je 'kɛn i plaan‑. ");
INSERT INTO wob_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","Nyɔ jrɔ' 'ɔ 'wɛi o, ɔɔ' 'sani o, ɔɔ' 'ʋnpaadɩ 'a 'tʋn se 'ʋn 'de po. ");
INSERT INTO wob_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","Aoa' ‑cɛ\" 'kpa 'je kan' 'mɛ 'ma sɩn ‑nɩ, ɩmɩ 'ɩn nʋʋ dbo 'ʋn ‑wɛe 'ɩn ke 'ma 'cɛ‑wi\" 'je dɛ ‑a di. ");
INSERT INTO wob_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","Dɛ 'ɩn tɔɔa aopʋ 'de ‑mɛɛ' ‑kɔ 'di ɛ, ɛmɛ ‑nɩ 'kamɔ nyʋ 'je dbo nʋ ‑wɛe ɔ 'je nɩɩa\" nyʋ kwa wɔi ‑te'. ‑Bo ‑aa sea kan' ‑mɔ nʋ ɛ, ‑mɛ wlu Tʋ\"bo Sesi 'a ‑cɛ\" 'kpa 'tmʋa ‑a ‑bleeɛ' ‑kwlɩ\" ɔ 'na : Nyʋ dɛ \"nyɩa' 'bleɛ 'mʋa‑, ɛ je nyʋ \"nyɩ ‑ʋn dɛ ‑sii‑. ");
INSERT INTO wob_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","Pɔo ‑kɔa' wlua' kan' 'sʋ ɛ, ɔ ke ʋʋ ‑wee' poɛ 'kɔi‑ ‑klu' ‑wɛe ʋʋ bae Kea. ");
INSERT INTO wob_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","37","'Sʋ ʋʋ ‑wee' a ‑fɩɩn\" ‑blɛ ‑blɛ, ʋʋ ‑gbleeɛ Pɔo ‑kwlɩ\" ‑wɛe ɔ ke ʋʋa poo wlu. ");
INSERT INTO wob_vpl VALUES ("AC20_38","074_20_38","ACT","20","38","38","Dɛ \"kaea' ʋʋpʋ \"jrii kpleiin, ɛmɛ ‑nɩ ɔ 'na ʋʋ ke ɔ se 'jeei 'bode. Ʋʋ kpɔ ‑jei\" mamaʋ 'sʋ ʋʋ nynii ɔ 'e ‑bato' wɔin\". ");
INSERT INTO wob_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","‑A ‑ke ʋʋ cɛɛan \"i 'sʋ ‑a ‑ja ‑bato' 'di ‑wɛe ‑a mu Kɔsɩ. ‑Sɔn' ‑sɩan' ‑a muɛ 'e Rodɛsɩ. 'Bomɔ ‑a ‑wlʋ ‑wɛe ‑a mu Patara. ");
INSERT INTO wob_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","‑A ‑jɛɛ 'o ‑bato' ‑ɛɛ mu 'e Fenisiblʋa \"kpei ɛ, 'sʋ ‑a ‑kpɛ 'di ‑wɛe ‑a mu. ");
INSERT INTO wob_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","‑Ta ‑aa ‑jeea Siprʋ ‑blʋa i 'sʋ ɛ, ‑a siɛ 'e kʋan o fɔ o, ‑wɛe ‑a ‑muu 'de Siriblʋa o fɔ o, 'de ‑a kpʋn 'kpʋʋ 'bo Tii. 'Bomɔ dɩ ‑ɩ ‑nɩa 'e ‑bato' 'di 'je i \"sii‑. ");
INSERT INTO wob_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","‑A ‑jɛɛ 'o Sesi 'a ‑tɩ' tɔ' 'ʋn 'jeʋn, ‑wɛe ‑a ‑ke ʋʋ ‑te i 'de 'dɔɔ due' 'di. Kea 'a ‑Suu ‑saa ʋʋpʋ fɛn' 'de Pɔo 'a ‑tɩ' 'ʋn ‑wɛe ʋʋ wlu ɔ ‑pee ka ʋʋ 'na : ‑Ɩn ‑bo Selisalɛm muɛ. ");
INSERT INTO wob_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","'Kaa 'dɔɔ due' ‑nɛ ‑cra \"jru 'sʋ ɛ, ‑a kpʋɛn ‑aa ‑je i ʋʋ ke ʋʋa' 'nynʋkpae' ke \"nynuu‑ ‑wee' ja ‑a ‑jei\" mamaʋ 'sʋ ‑a je ‑kwlɔ 'mii ‑kwɛ‑ ‑wɛe ‑a po 'kɔi‑ ‑klu' 'bo \"ni ‑kwlɩ\", 'de ‑a ‑bae Kea. ");
INSERT INTO wob_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","Ʋʋ ke ‑a ‑wee' pooɛ wlu due 'due 'sʋ ‑a ‑ja 'e ‑bato' 'di ‑wɛe ʋʋpʋ mu ‑kwlɔ de. ");
INSERT INTO wob_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","‑Aa ‑bato' 'di 'kpaa' ‑nɛ 'bo Tii mɔ ‑a ‑crɛɛ \"jru ‑wɛe ‑a mu Putolemaisɩ 'de ‑a ‑ke ‑aa de'di ‑wi\" 'je 'jee‑. ‑A nʋɛ 'o ʋʋpʋ o 'wɩ due'. ");
INSERT INTO wob_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","‑Sɔn' jrɛ' ‑sɩan' 'sʋ ‑a ‑kpa ‑jei\", ‑wɛe ‑a nyni Sesare 'de ‑a pa 'e Filipʋ ‑ɔ ‑nɩa Kea 'a ‑tɩ' 'tmʋi o ‑gbu\", nyʋ ‑mɛ\" 'sɔn ʋʋ 'cra i ‑wɛe ʋʋ ‑tea dbo kwa 'de Selisalɛm Kea ‑gbu 'di 'de ɛ, ɔ nɩɛ ʋʋpʋ 'a due' ‑o. ");
INSERT INTO wob_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","Ɔ 'bleɛ \"nynuunynʋkpae' ‑nyiiɛ ‑ʋʋ se jra \"ti due' ‑wɛe ‑ʋʋ ‑nɩ Kea 'a wlu 'kwajaaʋn. ");
INSERT INTO wob_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","‑A nʋɛ 'o 'wɩ pla, 'sʋ Kea 'a wlu 'kwajaai due' ‑wlʋ 'e Suide ‑ɔ ji, ɔɔ' 'nynɩ ‑nɩ Akabisɩ. ");
INSERT INTO wob_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","Ɔ ji' ɔ je ‑a ‑jɛɛ, 'sʋ ɔ \"duɛ Pɔo 'a wlʋ 'ʋn ‑wɛe ɔ san ɔɔ' ‑cɛ\" 'ɛ bɩ ke sɩn ke‑, 'de ɔ 'na : Dɛ Kea 'a ‑Suu 'tmʋa, ɛ ka : \"ju ‑ɔ ‑blea wlʋ ‑nɛ ka Suifʋ‑wi\" a mu ɔ saan' ka 'de Selisalɛm ‑wɛe ʋʋ 'je ɔ nyʋ 'srʋ \"nyɩ. ");
INSERT INTO wob_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","‑Ta ‑a ‑ke nyʋ ‑nɩa 'o mu 'wɔan wlu ‑nɛ 'sʋ ɛ, ‑aa baeɛ Pɔo i ‑wɛe ɔ je Selisalɛm mu. ");
INSERT INTO wob_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","'Kaa ɔ wlu' ka ɔ 'na : Dɛɛ ‑tɩ aoa ‑fɩɩn\" 'ʋn, ‑wɛe aoa pooa 'ma pɛe ɛ‑ ? Ɛ se 'ma saan 'a 'sʋ ‑mɛ nɩ‑, ‑bo ɛ nɩ 'ɩn 'je Selisalɛm mu ‑wɛe 'ɩn 'je 'mɛ 'de Tʋ\"bo Sesi 'a 'nynɩ 'ʋn mɔ 'de ɛ, 'ɩn ‑teɛ ɛɛ' kein\"ke. ");
INSERT INTO wob_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","‑A nʋɛ' ‑nʋ ‑nʋ, 'kaa ‑a se ɔ \"wɔin 'bɛɛ‑, 'sʋ ‑a ‑bɔ ɔɔ' i bae ‑tɩ 'mɛ, ‑wɛe ‑a ‑na dɛ Tʋ\"bo nɩa \"i, ɛmɛ ‑ɛ ‑je nʋʋɛ‑. ");
INSERT INTO wob_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","'Wɩ ‑a nʋa 'o mu ‑kwɛa 'sʋ ‑a ‑nmaeɛ ‑aa dɩ ‑wɛe ‑a mu Selisalɛm. ");
INSERT INTO wob_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","Sesi 'a ‑tɩ' tɔ' 'ʋn 'jeʋn ‑nɩa Sesare 'a jrʋ' kpa ‑a ‑jei\", ‑wɛe ʋʋ kpa ‑aʋn 'de \"ju due' ‑a ‑jea 'ʋn koo wɔin\". Ɔɔ' 'nynɩ ‑nɩ Manasɔn, ɔ 'wlʋɛ 'e Siprʋ‑blʋa \"kpei, ɔ nɩɛ Sesi 'a ‑tɩ' tɔ' 'ʋn 'jei ‑o sese. ");
INSERT INTO wob_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","‑A nynia Selisalɛm ɛ, ‑aa de 'di‑wi\" kpʋʋɛn ‑a sɩn 'sɔɔn 'de 'mʋa‑ 'ʋn. ");
INSERT INTO wob_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","Ɛɛ' ‑sɔn' ‑sɩan' Pɔo ke ‑a muɛ 'e Sakɩ wɔin\", 'demɔ Kea ‑gbu ‑jeopoʋn ‑wee' 'kɩɩn‑ \"jrui. ");
INSERT INTO wob_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","Pɔo ke ʋʋ 'jee la 'sasa ‑wɛe dɩ \"klein Kea nʋa 'de ɔɔ' dbo 'a ‑tɩ' 'ʋn 'de nyʋ ‑sea' Suifʋ nɩ \"klu ɛ, ɔ ‑tee ‑wɛe ɔ po ɩa' \"kuan. ");
INSERT INTO wob_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","Ʋʋ kɔa' ɔɔ' \"kuan ‑nɛ 'wɔan 'sʋ ʋʋ poɛ Kea 'sɛ‑ ‑wɛe ʋʋ wlu ɔ ‑pee ka, ʋʋ 'na : ‑Aa de'di, ‑ma ‑jee', Suifʋ ‑tuu\"‑tuu ‑ʋʋ ‑kpa Sesi 'a ‑tɩ' tɔ' 'ʋn 'jeʋn ɛ, ʋʋ ‑wee' \"klein ‑siɛ' Moisɩ 'a kɛ' o. ");
INSERT INTO wob_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","'Kaa dɛ ʋʋ 'wɔan 'de ‑ma ‑tɩ' 'ʋn ɛ ka : Dɛ ‑ma tɔɔa Suifʋ‑wi\" ‑ʋʋ ‑tia\" 'e nyʋ 'srʋ \"klu ɛ, ɛmɛ ‑nɩ ‑ɩn ‑na ʋʋ 'je dɩ \"klein Moisɩ 'a kɛ' 'tmʋa kwa ‑sɔn ‑saa, 'de ʋʋ 'bo ʋʋa' \"nynuu‑ 'klɛn kpaa ‑wɛe ʋʋ 'bo 'o ‑a \"bo ‑wi\" 'a kplɩn 'de blaa. ");
INSERT INTO wob_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","Ka ‑a ‑je nʋ 'ja a‑ ? Dɛ‑nʋɛ' ka ‑ɩn jia ʋʋ ‑wee' a muɛ 'wɔan' see. ");
INSERT INTO wob_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","23","Dɛ ‑aa mua 'tmʋa' 'de ‑ʋn ‑pee ɛ, ‑ɩn nʋ ɛ. ‑A ‑bleɛ nyʋ ‑nyiiɛ ‑ʋʋ cɛn wlu ‑tie\" 'bo Kea \"juɔi. ");
INSERT INTO wob_vpl VALUES ("AC21_24","074_21_24","ACT","21","24","24","Ʋʋ ke ‑ɩn mu ‑wɛe ka Suifʋ‑wi\" 'a kɛ' \"sia 'nynɩ ɛ, ʋʋ ke ‑ɩn ‑je kan' nʋ, ‑ɩn ‑sa nyʋ ‑kei\" ‑wɛe ʋʋ 'je ʋʋa' \"mɩɩ‑ cɛn. ‑Bo ɛ nɩ kan' a, ‑mɛ nyʋ ‑wee' a muɛ jua' ka dɩ ʋʋ 'tmʋa 'de ‑ma ‑tɩ' 'ʋn, ɩ nɩa sɩ ɛ. 'De ‑mɔ ‑nɩɛ kɛ' wɔn 'jei ‑o ‑ke. ");
INSERT INTO wob_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","‑Bo ɛ nɩ nyʋ ‑sea' Suifʋ nɩ ‑wɛe ‑ʋʋ ‑kpa Kletiɛn‑wi\" ‑mʋ ɛ, ‑mɛ dɛ ‑a ‑bɛɛa' wlu \"kpei ɛ, ɛmɛ ‑a ‑tmʋ 'de ʋʋ ‑pee 'de ʋʋa' 'sbɛ kpaa' 'ʋn. ‑A ‑na ʋʋ 'bo nmi ‑ɛ ‑wlʋa 'e kɔin 'a 'sraa ‑sa 'ɩn diɛ, ʋʋ 'bo nmi 'a nymɔ ke nmi ‑ɛ ‑mɛa fuan \"fun diɛ, ‑wɛe ʋʋ 'je 'nynɩ ‑san nʋ‑tɩ 'bɔ. ");
INSERT INTO wob_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","'Sʋ Pɔo ke nyʋ ‑nʋ mu' ‑wɛe dɛ Suifʋ‑wi\" 'a kɛ' \"sia 'nynɩ ɛ, ʋʋ nʋɛ. ‑wɛe 'wɩ ‑ɛ 'di ɛɛ' dɛ tu 'jea nʋʋɛ, 'de ɔ 'tmʋ ɩ 'de Kea ‑gbu klaa\" 'di, ɛ ke 'wɩ ‑ɛ 'di ʋʋa' 'sraa‑ 'jea ‑saa due 'due ke‑. ");
INSERT INTO wob_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","27","'Wɩ ‑mɛ\" 'sɔn ‑nɩ a jiɛ ‑sia' 'sʋ Suifʋ‑wi\" ‑wlʋa 'e Asi 'je Pɔo 'mɛ 'de Kea ‑gbu klaa\" 'di, 'sʋ ʋʋ paa nyʋ bɩ ‑sɔn, ‑wɛe ʋʋ kpʋn ɔ. ");
INSERT INTO wob_vpl VALUES ("AC21_28","074_21_28","ACT","21","28","28","'De ʋʋa \"wɔ ʋʋ 'na : Israɛ‑kɔʋn, ao ‑too\" ‑a \"i, \"ju ‑ɔ ‑wlua 'blʋa ‑wee' \"klein ke Israɛ‑kɔʋn ke Moisɩ 'a kɛ' ke Kea ‑gbu klaa\" ‑nɛ 'dei ‑ta \"o ‑ta a, ɔ ka. \"Ju due' ‑sea' Suifʋi nɩ ɛ, ɔmɔ ɔ paa 'e Kea ‑gbu klaa\" 'di, Kea 'a ‑gbu\" klaa\" ‑ɛ ‑kwɛai ɛ, 'de ɔ ‑sɛ ‑gban. ");
INSERT INTO wob_vpl VALUES ("AC21_29","074_21_29","ACT","21","29","29","Dɛ‑nʋɛ' ‑wɛe ʋʋa 'da kan' a, ɛmɛ ‑nɩ ʋʋ 'je Trofimʋ ‑ɔ ‑wlʋa Efɛsɩ ke Pɔo 'mɛ 'bo ‑kwlɔ 'de‑, ʋʋpʋ a naa tɔ' i ʋʋ 'na : ‑Mɛ ɔmɔ Pɔo paa 'e Kea ‑gbu klaa\" 'di. ");
INSERT INTO wob_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","Ɛɛ' dɛ tu 'a ‑kli ‑teɛ 'kpaa' ‑pʋn\" 'bo ‑kwlɔ. Nyiɔpʋ‑ a ple' ‑ta \"o ‑ta 'sʋ ʋʋ kpʋn Pɔo 'mɛ, ‑wɛe ʋʋ \"klɔ i 'de ʋʋ ‑sɔ 'e Kea ‑gbu klaa\" 'di. 'Bomɔ ʋʋ \"sri ʋʋ je ɛɛ' kpae\" ‑wee' \"wɔin kan. ");
INSERT INTO wob_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","31","Ʋʋa ‑pɔn Pɔo 'a 'dbaa ‑kɔ i 'sʋ ka ɛɛ' ‑kli nɩa 'kpaa' 'bo Selisalɛm ɛɛ' ‑cnuɛ\" ɛ mu' ɛ je 'a \"soa 'a 'blei jɛɛ‑. ");
INSERT INTO wob_vpl VALUES ("AC21_32","074_21_32","ACT","21","32","32","'Bo ɛ \"sri ɔ je \"jru jeʋn ke \"soa‑wi\" 'ʋn \"duo‑ ɔ ke ʋʋ kpa 'e ʋʋpʋ o plea'. Suifʋ‑wi\" 'jeea \"sʋɩ 'a 'blei ke ɔɔ' \"sʋɩ \"jriɛ‑ 'sʋ ʋʋ 'bɔ Pɔo 'a bla‑tɩ 'mɛ. ");
INSERT INTO wob_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","'Sʋ \"sʋɩ 'a 'blei 'kpa Pɔo ‑pʋn\" ‑wɛe ɔ kpʋn ɔ, ɔ sɔɔn ‑gbaacɩɛ' 'ɛ \"dbi 'sɔɔn ! ‑Wɛe ɔ ‑tee' dɛ ɔ nɩa 'ʋn ke dɛ ɔ nʋa 'a ‑tɩ' i. ");
INSERT INTO wob_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","'Kaa 'de nyʋ \"klu ɛ, jrʋ' a ‑sa 'ʋn 'ɛ 'nɔ, jrʋ' a ‑sa 'ʋn 'ɛ 'nɔ, ɔɔ' 'wɔn dɛ jrɛ' i ‑gblein', 'sʋ ɔ 'na : Ao kpa Pɔo 'de ao 'je ɔ 'e ‑gbu\" ‑ɛ ‑pooa 'saan 'dei 'di kpa. ");
INSERT INTO wob_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","35","‑Ta Pɔo a mua ‑wɛe ɔɔ tba ‑gbu\" ‑nɛ 'ɛ wɔn bʋ \"i, ‑mɛ \"sʋɩ 'blee ɔ \"jɛi 'de nyiɔpʋ 'a ‑tɩ' 'ʋn, ");
INSERT INTO wob_vpl VALUES ("AC21_36","074_21_36","ACT","21","36","36","dɛ‑nʋɛ' nyʋ \"klein ‑ʋʋ ‑kaan ʋʋpʋ 'de ɛ, ʋʋa \"wɔɔ‑ ʋʋ 'na : Ao 'dbɔ ! Ao 'dbɔ ! ");
INSERT INTO wob_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","37","‑Ta ʋʋa kpaa Pɔo 'de ‑gbu\" 'bomɔ ɔ ‑tee' \"sʋɩ 'a klaa\" i ka 'de Klɛkɩwlu 'di ɔ 'na : 'Ɩn 'bɛɛ‑ 'ɩn 'je dɛ‑saan\" 'tmʋʋ ? 'Sʋ ɔ ‑teeɛ' Pɔo i ɔ 'na : ‑Ɩn ‑juo Klɛkɩwlu po ka 'mɛ 'dee‑ ? ");
INSERT INTO wob_vpl VALUES ("AC21_38","074_21_38","ACT","21","38","38","‑Ɩn se Esipʋ i ‑ɔ ‑ke nyʋ 'dbaʋn 'a \"wlu ‑nyiiɛ poa ‑kli 'wɩ 'sɔɔn ‑ta ‑wɛe ‑ɔ ‑ke ʋʋ mua 'e ‑pɩɩɔn\" blʋa \"kpei nɩɩ‑ ? ");
INSERT INTO wob_vpl VALUES ("AC21_39","074_21_39","ACT","21","39","39","'Sʋ Pɔo \"duɛ wlu 'ʋn, ɔ 'na : \"Ɩɩn‑, 'ɩn nɩɛ Suifʋi ‑o, 'ɩn 'wlʋʋ 'bo Tasɩ 'de Silisi. 'Ɩn 'wlʋɛ dɛwɔn nɩ ‑Kwlɔ 'di. 'Ma bae ‑ʋn ‑ɛ, ‑ɩn ‑nyɩ\" 'ʋn wlu ‑wɛe 'ɩn 'je ʋʋ ‑pee wlu. ");
INSERT INTO wob_vpl VALUES ("AC21_40","074_21_40","ACT","21","40","40","'Sʋ \"sʋɩ 'a klaa\" 'na : ‑Ɩn ‑wlu. ‑Wɛe Pɔo nyna i 'bo \"kplo \"kpei, 'de ɔ 'kaa‑ nyʋ 'ʋn 'sʋ ʋʋ ‑wee' nʋɛ ‑snii' ‑wɛe Pɔo po Suifʋwlu 'a ‑cɛ\" 'kpa ɔ 'na : ");
INSERT INTO wob_vpl VALUES ("AC22_1","074_22_1","ACT","22","1","1","'Ma de'di ‑wi\" ke 'ma \"bo ‑wi\" ke ao po doin\" i la ‑wɛe dɛ 'ɩn 'jea 'tmʋ 'de 'ma \"kpei ‑tɩ 'ʋn ao 'je ɛ 'wɔn. ");
INSERT INTO wob_vpl VALUES ("AC22_2","074_22_2","ACT","22","2","2","‑Ta ʋʋ 'wɔan Suifʋ‑ ‑wlu 'de ɔ 'wɔn 'sʋ ʋʋ ‑wee' 'a ‑snii' ‑teea' 'kpa \"kpei ke'wlɛ, ‑wɛe Pɔo 'na : ");
INSERT INTO wob_vpl VALUES ("AC22_3","074_22_3","ACT","22","3","3","'Ɩn nɩɛ Suifʋi ‑o, 'ɩn 'wlʋʋ 'bo Tasɩ 'de Silisi, 'kaa ‑ta Selisalɛm mɔ 'ɩn 'bɛɛ \"i, Gamaliɛ mɔ ‑paa 'ʋn ‑a \"bo ‑wi\" 'a kɛ' 'ɛ klai\" 'pepe. Ka ao 'blea 'kpɩ 'de Kea 'a ‑tɩ' 'ʋn ‑sɩanwɩ 'di, 'kamɔ 'ɩn nɩ tɛin\" ‑ke 'de‑. ");
INSERT INTO wob_vpl VALUES ("AC22_4","074_22_4","ACT","22","4","4","Nyʋ ‑ʋʋa naa Tʋ\"bo 'a ‑jei\" ɛ, 'ɩn 'nyɛ ʋʋpʋ 'ʋn 'ɛ mamaʋ 'sʋ ɛ je ʋʋpʋ 'a 'dbaa' \"jru \"kpei‑ po. 'Ma nynaa 'nynʋkpae' ke nmai i ‑wɛe 'ma po ʋʋpʋ ‑kaso 'di. ");
INSERT INTO wob_vpl VALUES ("AC22_5","074_22_5","ACT","22","5","5","'Sraa ‑sai klaa\" ke nyʋ‑cɔɩn' ‑wi\" ‑nɩa 'e aopʋ \"klu ɛ, ka ‑tɩ' 'ma 'tmʋa ɩ nɩa tɔ' ɛ, ʋʋ juɩ'. ʋʋa' ‑cɛ\" 'kpa ‑nyɩ\" 'ʋn 'sbɛ 'de Kletiɛn‑wi\" ‑nɩa Damasɩ 'a ‑tɩ' 'ʋn. 'Bomɔ 'ma mu ‑wɛe 'ɩn 'je nyʋ ‑ʋʋ ‑jea Sesi 'a ‑tɩ' tɔ' 'ʋn kpʋn 'de 'ɩn 'je ʋʋpʋ san ‑wɛe 'ɩn 'je ʋʋpʋ Selisalɛm ja‑ 'de ʋʋ 'e ‑kaso 'di mu. ");
INSERT INTO wob_vpl VALUES ("AC22_6","074_22_6","ACT","22","6","6","‑Ta 'ɩn nɩa mua' a, ‑wɛe 'ma \"kʋʋan Damasɩ i ɛ, ‑mɛ 'jrʋ ‑teɛ ‑gbao'. 'Sʋ ‑sɔn' klaa\" ‑wlʋ 'e jaʋn 'di ‑ɛ ‑sɩn' 'de 'ʋn 'dewoi. ");
INSERT INTO wob_vpl VALUES ("AC22_7","074_22_7","ACT","22","7","7","'Sʋ 'ɩn ‑ka i 'bo 'blʋɔ ‑wɛe 'ɩn 'wɔn wlu jrɛ' ‑ɛ ‑wlu 'ʋn ‑pee ka ‑ɛ ‑na : Sɔo, Sɔo, dɛɛ‑tɩ ‑ma ‑tu\" 'ʋn 'kle ɛ‑ ? ");
INSERT INTO wob_vpl VALUES ("AC22_8","074_22_8","ACT","22","8","8","‑Wɛe 'ɩn ‑tee' ɛ i ka, 'ɩn 'na : ‑Mɔ nyɔ ‑o ɛ‑, Tʋ\"bo ? 'Sʋ ɔ 'na : 'Mɔ Sesi ‑wlʋa Nasarɛtɩ ‑ma ‑fɔan' tʋ o ɛ, 'mɔ ‑o. ");
INSERT INTO wob_vpl VALUES ("AC22_9","074_22_9","ACT","22","9","9","Nyʋ ‑ʋʋ ‑ke 'ma ‑a ‑na ʋʋ 'jee‑ ‑sɔn' ‑nɛ \"jriɛ‑ 'mɛ 'pepe, 'kaa wlu ‑jɛ ‑wlua 'ʋn ‑pee ɛ, ʋʋ se ‑mɛ 'wɔn. 'Sʋ 'ɩn 'na : Tʋ\"bo, dɛ 'ɩn 'je nʋ ɛ‑ ? ");
INSERT INTO wob_vpl VALUES ("AC22_10","074_22_10","ACT","22","10","10","‑Wɛe Tʋ\"bo wlu 'ʋn ‑pee ɔ 'na : ‑Ɩn sɔn 'ʋn, ‑ɩn mu Damasɩ, 'bomɔ dɛ \"klein ‑ɩn ‑jea nʋ ɛ, ʋʋ 'je ɛ ‑ʋn ‑tɔɔ. ");
INSERT INTO wob_vpl VALUES ("AC22_11","074_22_11","ACT","22","11","11","‑Sɔn' klaa\" ‑ɛ ‑sɩan' 'ʋn kwa 'jrʋ‑gbao 'bo ‑jei\" 'mʋa‑ 'a ‑tɩ' 'ʋn ɛ, 'maa 'je i ‑wɛe 'ma 'cɛ‑wi\" ‑ke 'ɩn na ʋʋpʋ ‑kpʋn' 'ʋn ‑cɩɛi\" ‑ʋʋ kpa 'ʋn Damasɩ. ");
INSERT INTO wob_vpl VALUES ("AC22_12","074_22_12","ACT","22","12","12","‑Ta ɛ nɩa kan' ‑mɛ \"ju due' ‑nɩ 'o Damasɩ ɔɔ' 'nynɩ ‑nɩ Ananiasɩ, ɔɔ' \"ju tu ‑srɛi\" ɔɔ 'jeɛ Kea 'a kɛ' wɔn. Suifʋ‑wi\" ‑nɩa 'o Damasɩ ‑wee' a po ɔ ‑tɩ' o. ");
INSERT INTO wob_vpl VALUES ("AC22_13","074_22_13","ACT","22","13","13","Ɔmɔ ‑ji\" ‑ɔ ‑jɛɛ 'ʋn 'de ‑ɔ ‑wlu 'ʋn ‑pee ka ɔ 'na : Sɔo 'ma de'di, ‑ma \"jri 'bai‑ ‑ɩn ‑je i 'je. 'Bo ɛ \"sri 'ma \"jri je 'bai‑ 'ɩn je i 'jea' ‑pʋn\" ‑te. ");
INSERT INTO wob_vpl VALUES ("AC22_14","074_22_14","ACT","22","14","14","'De ɔ 'na : ‑A \"bo ‑wi\" 'a Kea ‑teeɛ ‑ʋn kpɔi\" sese ‑wɛe ‑ɩn ‑je ɛɛ' ‑kwlʋtɩ juo‑ 'de ‑ɩn ‑je \"Ju ‑srɛai\" \"jriɛ‑ 'jee‑, ‑wɛe ‑ɩn ‑je ɔɔ' ‑cɛ\" 'kpa 'a wlu 'wɔn, ");
INSERT INTO wob_vpl VALUES ("AC22_15","074_22_15","ACT","22","15","15","dɛ‑nʋɛ' ‑ɩn ‑je ɔɔ' ‑tɩ 'a ‑ta 'jei nɩ ‑o, ‑wɛe dɩ ‑ɩn ‑jea 'de ‑ɩn ‑wɔan ‑wɛe ‑ɩn ‑jɩ 'tmʋ 'de nyʋ ‑wee' \"klein \"juɔi. ");
INSERT INTO wob_vpl VALUES ("AC22_16","074_22_16","ACT","22","16","16","‑Jɛ ɛ nɩa kan' ‑mɔ 'ja a, ‑ɩn ‑bo imaa, ‑ɩn sɔn 'ʋn ‑ɩn ‑je \"ni \"jru pooɛ 'de ‑ɩn ‑je Sesi ‑ma Tʋ\"bo 'daa‑ ‑wɛe ‑ma dɩsaɩn 'je ‑kwɛ‑. ");
INSERT INTO wob_vpl VALUES ("AC22_17","074_22_17","ACT","22","17","17","‑Ta 'ɩn jia Selisalɛm de, ‑wɛe 'ɩn nɩɩa Kea baea' 'de Kea ‑gbu klaa\" 'di ɛ, 'bomɔ Kea tɔɔ 'ʋn dɛ jrɛ' 'de jajri 'ʋn. ");
INSERT INTO wob_vpl VALUES ("AC22_18","074_22_18","ACT","22","18","18","'Ɩn 'jeeɛ Tʋ\"bo \"jriɛ‑, ‑wɛe ɔ wlu 'ʋn ‑pee ɔ 'na : ‑Ɩn ‑wlʋ ‑ta Selisalɛm ‑too\"‑, dɛ‑nʋɛ' dɩ ‑ma mua 'tmʋa' 'de 'ma ‑tɩ' 'ʋn ɛ, ʋʋ sɩ 'wɔɔin see. ");
INSERT INTO wob_vpl VALUES ("AC22_19","074_22_19","ACT","22","19","19","'Sʋ 'ɩn 'na : Tʋ\"bo, ka 'ma mua \"jrui 'kɩɩn‑gbu 'dii ‑wɛe nyʋ ‑jea ‑ma ‑tɩ' tɔ' 'ʋn 'ma bla ʋʋpʋ 'de 'ma poa ʋʋpʋ ‑kaso 'di ɛ, ʋʋ juɩ' 'pepe. ");
INSERT INTO wob_vpl VALUES ("AC22_20","074_22_20","ACT","22","20","20","'De ‑ta ʋʋ 'dbaa Etiɛin ‑ma ‑tɩ' 'a ‑ta 'jei ɛ, 'ɩn nɩ 'o 'ɛ ‑ke. Nyʋ ‑ʋʋ ‑dbɔ 'ma poɛ ʋʋpʋ ‑tɩ' o, ‑wɛe 'ɩn ‑te' ʋʋpʋ 'a 'ʋnpaadɩ i 'bo 'ʋn ‑pʋn\". ");
INSERT INTO wob_vpl VALUES ("AC22_21","074_22_21","ACT","22","21","21","'Sʋ Tʋ\"bo 'na : ‑Ɩn mu, 'ma muɛ ‑ʋn ‑ta ‑tɔɔn dboa' 'de 'blʋa 'srʋ ‑pee. ");
INSERT INTO wob_vpl VALUES ("AC22_22","074_22_22","ACT","22","22","22","Ʋʋ poɛ Pɔo 'a wlu doin\" o mamaʋ ɛ je wlu ‑nɛ jɛɛ‑, 'sʋ ʋʋ ‑wee' ‑saa ‑cruɛn\", ʋʋ 'na : Ao ‑sa \"ju ‑nɔ 'kmʋ, ɔ se 'kmʋ nɩ ka nɩ‑ ! ");
INSERT INTO wob_vpl VALUES ("AC22_23","074_22_23","ACT","22","23","23","Ʋʋa bla ‑kɩ ʋʋa ‑sa ʋʋa' 'ʋnpaadɩ 'ʋn, ʋʋa poo ɩ 'blʋɔ o i ‑wɛe ʋʋa po \"puue' \"jɛi. ");
INSERT INTO wob_vpl VALUES ("AC22_24","074_22_24","ACT","22","24","24","'Sʋ \"sʋɩ 'a 'blei‑ 'tmʋʋɛ nyʋ ‑wɛe ʋʋ 'je Pɔo 'de ‑gbu\" ‑pooa 'saan 'dei 'di kpa 'de ʋʋ 'je ɔ klae 'ʋn kpa ‑wɛe ɔ 'je dɛ ‑ɛɛ ‑tɩ' nyʋ a ‑sɔɔ ‑cruɛn\" \"kpei 'tmʋ. ");
INSERT INTO wob_vpl VALUES ("AC22_25","074_22_25","ACT","22","25","25","'Kaa ‑ta ʋʋ saan Pɔo ‑wɛe ʋʋ 'je ɔ bla 'sʋ ɛ, ɔ wlu' 'de \"sʋɩ 'a 'blei‑ ‑pee ɔ 'na : Ao 'bɛɛ‑ 'mɛ ao 'je Rɔmɛ i bla, 'de ‑mɛ 'kamɔ nyɔ jrɔ' se ɔɔ' 'pee 'jee ? ");
INSERT INTO wob_vpl VALUES ("AC22_26","074_22_26","ACT","22","26","26","\"Sʋɩ 'a 'blei‑ 'wɔan wlu ‑nɛ 'sʋ ɔ muɛ \"sʋɩ 'a klaa\" fɛn' ‑saa' ɔ 'na : Ka ‑ɩn ‑je ɛɛ' sʋn nʋ ɛ‑ ? \"Ju ‑nɔ, ɔ nɩɛ Rɔmɛ i ‑o. ");
INSERT INTO wob_vpl VALUES ("AC22_27","074_22_27","ACT","22","27","27","'Sʋ \"sʋɩ 'a klaa\" ‑nɔ ji' ‑wɛe ɔ ‑tee' Pɔo i, ɔ 'na : ‑Ɩn ‑nɩɛ Rɔmɛ i ‑oo ? ‑ɩn ‑tmʋ ɛ 'de 'ʋn ‑pee'. 'Sʋ Pɔo 'na : Kɩɩn. ");
INSERT INTO wob_vpl VALUES ("AC22_28","074_22_28","ACT","22","28","28","‑Wɛe \"sʋɩ 'a klaa\" \"duo wlu 'ʋn, ɔ 'na : 'Ɩn 'wɔan Rɔmɛ i 'kpa‑tɩ ɛ, 'ɩn ja 'wɛi ‑tuu\". 'Sʋ Pɔo 'na : 'Mɔ 'wlʋʋ ɛ 'ʋn 'ɛ. ");
INSERT INTO wob_vpl VALUES ("AC22_29","074_22_29","ACT","22","29","29","'Bo ɛ \"sri nyʋ ‑ʋʋa ji ɔ blaa' ‑wɛe ɔ 'jea wlu ɛ, ʋʋ je ɔ kɩɩn ‑saa. \"Soa 'a klaa\" 'a ‑cɛ\" 'kpa ‑mɔ ɛ, ka Pɔo nɩa Rɔmɛ i ‑wɛe ɔ sɔɔn ‑gbaacɩɛ' 'ɛ \"dbi i ɔ 'jea kan' 'sʋ faʋn nʋɔ'. ");
INSERT INTO wob_vpl VALUES ("AC22_30","074_22_30","ACT","22","30","30","Dɛ ‑ɛɛ ‑tɩ' 'ʋn Suifʋ‑wi\" bla Pɔo ‑tɩ' \"kpei ɛ, \"soa 'a klaa\" ‑nɩɛi\" ɔ 'je ɛɛ' bʋ 'mii 'wɔn 'pepe. Ɛmɛ ‑tɩ ‑sɔn' ‑sɩn' 'sʋ ɔ kain Pɔo i ‑wɛe ɔ 'tmʋʋ 'sraa ‑saʋn 'a klae\" o, ‑gbajeʋn ‑wi\" 'de ʋʋ 'kɩɩn‑ \"jrui ‑wɛe ɔ ja Pɔo 'bo ʋʋa' ‑kwea'‑. ");
INSERT INTO wob_vpl VALUES ("AC23_1","074_23_1","ACT","23","1","1","Pɔo \"sia ‑gbajeʋn ‑nʋ \"jriɛ‑ 'sʋ ɔ 'na : 'Ma de'di ‑wi\", 'ɩn nʋʋɛ Kea \"juɔi 'de pɛe 'dɔe 'ʋn, ɛmɛ ‑tɩ 'ma pɛe se 'ʋn \"bli ‑cɛ' mamaʋ 'sʋ ɛ je 'e ‑sɩanwɩ 'di jɛɛ‑. ");
INSERT INTO wob_vpl VALUES ("AC23_2","074_23_2","ACT","23","2","2","'Sʋ 'sraa ‑sai klaa\" Ananiasɩ wlu' 'de nyʋ ‑ʋʋ ‑tea Pɔo 'a blaa' kein\"ke ‑pee ɔ 'na : Ao po ɔ 'kpa 'wɔn ! ");
INSERT INTO wob_vpl VALUES ("AC23_3","074_23_3","ACT","23","3","3","'Sʋ Pɔo wlu ɔ ‑pee ɔ 'na : Kea mɛ ‑je ‑ʋn bla, ‑mɔ ‑ɔ ‑kɔ' blo' nyʋ 'wla \"ko \"jru ɛ, ‑ɩn ‑teɛ i ‑ma jea 'ma 'pee 'je ka kɛ' 'da‑, ‑wɛe ‑ma ‑cɛ\" 'kpa ‑saa kɛ' 'de ‑ma ‑tmʋʋ' nyʋ ʋʋa bla 'ʋn. ");
INSERT INTO wob_vpl VALUES ("AC23_4","074_23_4","ACT","23","4","4","'Sʋ nyʋ ‑ʋʋ ‑nɩa 'o ɔ ‑pʋn\" ʋʋ 'na : Kea 'a 'sraa ‑sai klaa\" mɔ ‑ma ‑cree\" a 'oo ? ");
INSERT INTO wob_vpl VALUES ("AC23_5","074_23_5","ACT","23","5","5","'Sʋ Pɔo 'na : 'Ma de'di ‑wi\", ka ɛ nɩa 'sraa ‑sai klaa\" 'ɩn sɩ juo‑. Ao kɔn ‑kɩn. dɛ‑nʋɛ' wlu ‑crɩɩa' ɛ 'na : Nyɔ ‑nɩa ‑ma klaa\" ‑ɩn ‑bo ɔ wlu saʋn ‑pee 'tmʋɛ. ");
INSERT INTO wob_vpl VALUES ("AC23_6","074_23_6","ACT","23","6","6","Ka Fariseɛn ke Sadiseɛn nɩa ‑gbajeʋn ‑wɛe ʋʋa 'jea ɔɔ' 'pee ɔ 'jea kan' 'sʋ ɔ kpa wlu' \"jɛi 'bo ʋʋpʋ \"juɔi ɔ 'na : 'Ma de'di ‑wi\", 'ɩn nɩɛ Fariseɛn 'ɛ \"ju Fariseɛn ‑o. \"Kunyɩɔ' sɔn ‑tɩ ‑a ‑wee' 'jea tɔ' 'ʋn ɛ, ɛmɛ ‑ɛɛ ‑tɩ' 'ʋn nyʋ a 'je 'ma 'pee. ");
INSERT INTO wob_vpl VALUES ("AC23_7","074_23_7","ACT","23","7","7","Ɔ 'tmʋa wlu ‑nɩa 'mʋa‑ 'sʋ ‑cruɛn\" sɔn 'ʋn 'ɛ 'bo Fariseɛn‑wi\" ke Sadiseɛn‑wi\" 'nynɩ, 'sʋ ʋʋ ‑seea' 'ʋn, ");
INSERT INTO wob_vpl VALUES ("AC23_8","074_23_8","ACT","23","8","8","dɛ‑nʋɛ' Sadiseɛn‑wi\" ‑mʋ 'na : \"Kunyɩɔ' sɔn‑tɩ o, Kea 'a \"sʋɩ 'a ‑tɩ' o, ‑suu 'a ‑tɩ' se tɔ' nɩ‑. 'De dɩ 'a kpɛ taan ‑nɩ, Fariseɛn‑wi\" 'je ‑mɩ tɔ' 'ʋn 'ɛ. ");
INSERT INTO wob_vpl VALUES ("AC23_9","074_23_9","ACT","23","9","9","Ʋʋa \"wɔɔ‑ ʋʋa muuɛ \"jru o 'sʋ kɛ' wɔ‑saʋn jrʋ' ‑nɩa 'e Fariseɛn‑wi\" 'a 'fɔ o ɛ, ʋʋ sɔn 'ʋn 'ɛ, ʋʋ ke nyʋ ‑teɛ 'wɔin ‑sia' ‑pʋn\" 'de ʋʋ 'na : Dɛsaʋn ‑a ‑jea 'je 'de \"ju ‑nɔ 'ʋn, ɛ se nɩ‑. \"Ko ‑suu jrɛ' o, \"ko Kea 'a \"soai jrɔ' ‑tuu\" ɔ wlu wɔn ‑ɛ, ‑a se ‑mɛ o juo‑. ");
INSERT INTO wob_vpl VALUES ("AC23_10","074_23_10","ACT","23","10","10","Ʋʋa' ba o ‑tooa' a 'kpa \"kpei ɛɛ muɛ nya. 'Sʋ ʋʋ je Pɔo tii cɛn, ɛɛ' faʋn a nʋ \"sʋɩ 'a klaa\" 'mɛ. Ɛmɛ ‑tɩ ɔ 'tmʋʋ‑ \"sʋɩ ‑wɛe ʋʋ 'je Pɔo 'ʋn \"duo‑ ʋʋ 'jeɔ 'bo ʋʋa' ‑kwea'‑ ‑sa, ‑wɛe ʋʋ 'je ɔ 'e ‑gbu\" 'di de kpa. ");
INSERT INTO wob_vpl VALUES ("AC23_11","074_23_11","ACT","23","11","11","Kwie jrɛ' ‑kpʋn a 'sʋ Tʋ\"bo 'wlʋɛ 'kwla 'de Pɔo ‑pee ɛ 'na : ‑Ɩn ‑duo\" 'kpɩ 'ʋn, ka ‑ma ‑tmʋa 'ma ‑tɩ' 'bo Selisalɛm ‑ta, 'kamɔ ‑ɩn ‑je 'ma ‑tɩ' 'tmʋ 'de Rɔmʋ ‑ke. ");
INSERT INTO wob_vpl VALUES ("AC23_12","074_23_12","ACT","23","12","12","‑Sɔn' ‑sɩan' 'sʋ Suifʋ‑wi\" pooɛ ‑tɩ' ‑wɛe ʋʋ ‑te ʋʋa' ‑cɛ\" \"kwi \"jru ʋʋ 'na : Ʋʋ 'na ‑a se dɛ dii 'de ‑a se \"ni 'na i ‑bo ‑a se pɔo 'dba a. ");
INSERT INTO wob_vpl VALUES ("AC23_13","074_23_13","ACT","23","13","13","Nyʋ ‑ʋʋ ‑pooa ɩa' ‑tɩ' tu ɛ, ʋʋ cɛn nyiɔpʋ 'a kwla ‑nyiiɛ \"kpei ‑tie\". ");
INSERT INTO wob_vpl VALUES ("AC23_14","074_23_14","ACT","23","14","14","Ʋʋ mu 'e 'sraa ‑saʋn 'a klae\" ke nyʋ‑cɔɩn' ‑wi\" o 'de ʋʋ 'na : ‑A ‑bla', ‑a ‑je ‑aa ‑cɛ\" 'kpa 'ʋn po, ‑a ‑na ‑a se dɛ wɔn ‑tɩn' i mamaʋ 'sʋ ‑a ‑je Pɔo 'dba. ");
INSERT INTO wob_vpl VALUES ("AC23_15","074_23_15","ACT","23","15","15","‑Bo ɛ nɩ kan' la 'ja a, ‑mɛ aomɔ ke ‑gbajeʋn mu 'e \"soa‑wi\" 'a klaa\" o ‑wɛe ɔ 'je Pɔo 'bo ao \"juɔi ja, 'de ka nyʋ 'jea nyɔ 'ɔ 'tmʋ ‑tɩ 'ʋn ‑sa, ao 'je kan' nʋ. ‑Mɛ nɔ\" ‑tɩ ɔ 'jea ji ‑wɛe ɔ 'jea ‑ta nyni, ‑mɛ ‑amɔ ‑teɛ ɔɔ' 'dbaa' kein\"ke. ");
INSERT INTO wob_vpl VALUES ("AC23_16","074_23_16","ACT","23","16","16","Ka Suifʋ‑wi\" ‑gba 'srɛ ‑nɛ Pɔo 'a de'dinynɔkpao' 'a \"ju 'wɔɛn 'sʋ ɔ muɛ Pɔo fɛn' ‑saa' 'de ‑gbu\" ‑blaa 'saan 'dei 'di. ");
INSERT INTO wob_vpl VALUES ("AC23_17","074_23_17","ACT","23","17","17","'Sʋ Pɔo 'da \"sʋɩ 'a \"jru jei due' ‑wɛe ɔ 'na : ‑Ɩn kpa ‑kooa\" i‑saan\" ‑nɔ 'de aoa' klaa\" o, dɛ‑nʋɛ' ɔ 'bleɛ ‑tɩ' jrɩ' ɔ 'je ɔ 'tmʋʋ‑. ");
INSERT INTO wob_vpl VALUES ("AC23_18","074_23_18","ACT","23","18","18","‑Wɛe \"soai \"duo ‑kooa\" i‑saan\" ‑nɔ 'ʋn ɔ ke ɔ mu 'e ʋʋa' klaa\" o 'de ɔ 'na : Pɔo ‑ɔ ‑nɩa ‑kaso 'di ɛ, ɔmɔ ‑da 'ʋn ‑wɛe ‑ɔ ‑na 'ɩn ja ‑ʋn ‑kooa\" i‑saan\" ‑nɔ, ɔ 'bleɛ ‑tɩ' ‑saɩn\"‑, ɔ 'je ‑ʋn 'tmʋʋ‑. ");
INSERT INTO wob_vpl VALUES ("AC23_19","074_23_19","ACT","23","19","19","\"Sʋɩ 'a ‑jeopoi ‑nɔ kpʋn \"ju ‑saan\" ‑cɩɛi\" 'de ɔ ke ɔɔ' 'sʋ mu ‑tajrɔ ‑wɛe ɔ ‑tee' ɔ i, ɔ 'na : Dɛ ‑ɩn ‑ble ‑ɩn ‑je 'ʋn 'tmʋʋ ɛ‑ ? ");
INSERT INTO wob_vpl VALUES ("AC23_20","074_23_20","ACT","23","20","20","'Sʋ ‑kooa\" i‑saan\" ‑nɔ 'na : Suifʋ‑wi\" poɛ wlu ‑tadue ‑wɛe ʋʋ 'je ‑mii bae‑ 'de ‑ɩn ‑je Pɔo 'bo ‑gbajeʋn \"juɔi kpa ‑klae\"‑, ‑wɛe ka ‑gbajeʋn 'jea nyʋ 'a 'pee 'je ka ‑cɔɔn' ka, ɛ 'e kan' nɩ‑. ");
INSERT INTO wob_vpl VALUES ("AC23_21","074_23_21","ACT","23","21","21","‑Ɩn ‑bo ʋʋa' wlu doin\" o pooɛ, dɛ‑nʋɛ' ʋʋa' kwla ‑nyiiɛ ‑gba 'srɛ ‑wɛe ‑ʋʋ bla ‑ʋʋ po ʋʋa' ‑cɛ\" 'ʋn ‑ʋʋ ‑na ‑ʋʋ se dɛ dii, ‑ʋʋ se \"ni 'nai mamaʋ 'sʋ ‑ʋʋ ‑je Pɔo 'dba. Ʋʋ ‑teɛ ɛɛ' kein\"ke, 'kaa ‑mɔ ʋʋa fuo. ");
INSERT INTO wob_vpl VALUES ("AC23_22","074_23_22","ACT","23","22","22","'Sʋ \"sʋɩ 'a klaa\" poɛ ‑kooa\" i‑saan\" ‑nɔ ‑jei\" ‑wɛe ɔ ‑tu\" ɔ wlu, ɔ 'na : Dɛ ‑ɩn ‑tmʋa 'de 'ʋn ‑pee ‑ta, ‑ɩn ‑bo ɛ 'tmʋɛ 'de nyɔ jrɔ' ‑pee. ");
INSERT INTO wob_vpl VALUES ("AC23_23","074_23_23","ACT","23","23","23","'Bo ‑mɛ 'de ɛ, \"sʋɩ 'a klaa\" 'da jra' jeʋn 'sɔɔn ‑wɛe ɔ 'na : Ao nmae dɩ, ‑bo nyʋ 'a nabʋ a sea cɛɛn 'sʋ ɛ, ao ke \"sʋɩ 'a kmɛ' 'sɔɔn ke \"sʋɩ 'a kwla ‑mɛ\" 'sɔn ‑ʋʋa ‑tea soo\" \"kpei ke \"sʋɩ ‑a poa \"di 'a kmɛ' 'sɔɔn 'je Sesare mu. ");
INSERT INTO wob_vpl VALUES ("AC23_24","074_23_24","ACT","23","24","24","Ao nmae soo\" Pɔo 'jea \"kpei ‑te ɛ, ‑wɛe ‑bo ɔɔ sea ‑gbʋa'na Foisi jɛɛ ɔ 'je \"i ‑gbla' ‑gbla' nɩ‑. ");
INSERT INTO wob_vpl VALUES ("AC23_25","074_23_25","ACT","23","25","25","‑Wɛe ɔ 'crɩ 'sbɛ ɔ \"nyɩ ʋʋpʋ, wlu ɔ 'crɩa, ɛ ka : ");
INSERT INTO wob_vpl VALUES ("AC23_26","074_23_26","ACT","23","26","26","'Mɔ Klodɩ Lisiasɩ, 'mɔ ‑ɔɔ ‑crɩ 'sbɛ ‑ɔɔ ja ‑gbʋa'na Foisi 'de ‑ɔɔ po ɔ 'jewlu o. ");
INSERT INTO wob_vpl VALUES ("AC23_27","074_23_27","ACT","23","27","27","Suifʋ‑wi\" kpʋn \"ju ‑nɔ 'mɛ, ‑wɛe ʋʋa ‑pɔn ʋʋ 'je ɔ 'dba. Ka ɔ nɩa Rɔmɛ i ‑ta 'ɩn 'wɔɩn 'sʋ 'ɩn po ‑jei\" ‑wɛe ʋʋ ‑sei' ɔ 'de ʋʋpʋ 'kwa. ");
INSERT INTO wob_vpl VALUES ("AC23_28","074_23_28","ACT","23","28","28","Dɛ ‑ɛɛ ‑pa Suifʋ‑wi\" a blɔ \"kpei ɛ, 'ɩn nɩɛ \"i 'ɩn 'je ɛ 'mii 'wɔn 'sʋ 'ɩn kpɔ 'e ʋʋa' ‑gbajeʋn \"juɔi. ");
INSERT INTO wob_vpl VALUES ("AC23_29","074_23_29","ACT","23","29","29","Dɛ 'ɩn 'wɔan ‑wɛe ‑ɛɛ ‑pa ʋʋa blɔ \"kpei ɛ, ɛmɛ ‑nɩ ʋʋa' ‑cɛ\" 'kpa 'a kɛ' ɛɛ' ‑tɩ'. 'Kaa dɛ ɔ nʋa ‑wɛe ‑ɛ ‑jea ɔɔ' ‑kaso 'di pooa' ke ɔɔ' 'mɛa' 'je, ɛ se nɩ‑. ");
INSERT INTO wob_vpl VALUES ("AC23_30","074_23_30","ACT","23","30","30","'De dɛɛ ‑tɩ 'ma jɔ ‑ʋn ɛ, ɛmɛ ‑nɩ nyʋ jrʋ' ‑saa 'ʋn fɛn', ʋʋ 'na : Suifʋ‑wi\" ‑gba' 'srɛ 'de ɔɔ' ‑tɩ' 'ʋn. Ɛmɛ 'ɩn 'wɔn 'sʋ 'ɩn \"sri 'o 'ma jɔ ‑ʋn, ‑wɛe 'ɩn 'tmʋʋ nyʋ ‑ʋʋ ‑ke ɔ 'blea ‑tɩ' ɛ, 'de ʋʋa' ‑cɛ\" 'kpa 'je ʋʋa' 'pee 'de ‑ʋn o ja‑. ");
INSERT INTO wob_vpl VALUES ("AC23_31","074_23_31","ACT","23","31","31","Wlu \"sʋɩ 'a 'blei ‑tua\" ʋʋpʋ \"i ɛ, ʋʋ nʋɛ'. Ʋʋ \"duo Pɔo 'ʋn 'ɛ \"maʋ' ‑wɛe ʋʋ ke ɔ mu mamaʋ ʋʋ nyni Antipatrisɩ. ");
INSERT INTO wob_vpl VALUES ("AC23_32","074_23_32","ACT","23","32","32","‑Sɔn' ‑sɩan', \"sʋɩ ‑jʋ ‑naa 'blʋɔi ɛ, ‑wi\" ‑mʋ muɛ de, ‑wɛe nyʋ ‑ʋʋ ‑blea soe\" ‑ke Pɔo mu. ");
INSERT INTO wob_vpl VALUES ("AC23_33","074_23_33","ACT","23","33","33","Ʋʋ nynia Sesare ɛ, \"sʋɩ \"nyɩɛ ‑gbʋa'na 'sbɛ‑ ‑wɛe ʋʋ \"nyɩ ɔ Pɔo. ");
INSERT INTO wob_vpl VALUES ("AC23_34","074_23_34","ACT","23","34","34","‑Gbʋa'na nʋa 'sbɛ 'dii 'sʋ ɛ, ɔ ‑teeɛ' Pɔo i ‑wɛe ɔ 'je ɔɔ' 'blʋa 'a 'nynɩ \"si. Ka Pɔo 'wlʋa 'e Silisi ɔ 'wɔɩn 'sʋ ɛ, ");
INSERT INTO wob_vpl VALUES ("AC23_35","074_23_35","ACT","23","35","35","ɔ wlu ɔ ‑pee ɔ 'na : ‑Bo nyʋ ‑ʋʋ ‑ke ‑ɩn ‑blea ‑tɩ' ji ɛ, ‑wɛe 'ɩn 'je ‑mii ‑tee'‑. 'Sʋ ɔ 'tmʋʋɛ nyʋ ‑wɛe ʋʋ kpa Pɔo 'de Erodɩ 'a tʋ\"bo ‑gbu 'di. ");
INSERT INTO wob_vpl VALUES ("AC24_1","074_24_1","ACT","24","1","1","Ɛ nʋɛ 'wɩ ‑mm\" 'sʋ, 'sraa ‑sai klaa\" Ananiasɩ ji ɔ ke nyʋ‑cɔɩn' ke \"ju due' ɔɔ' 'nynɩ ‑nɩ Tɛtuilɩ ke‑. Ɔɔ' \"ju tu cɛn wɔn i. ‑Wɛe ʋʋ po Pɔo 'de ‑gbʋa'na \"juɔi. ");
INSERT INTO wob_vpl VALUES ("AC24_2","074_24_2","ACT","24","2","2","Ʋʋ 'da Pɔo la ‑wɛe Tɛtuilɩ ‑te ɔɔ' ‑tɩ' \"kpei‑ ‑tu\" 'a ‑pʋn\" ɔ 'na : ‑Aa nyɔ ‑cɔɔn'‑ Foisi, ‑ma 'saaʋn mɛ ‑nʋɛ' ‑sɩan ‑wɛe ‑a ‑nɩ 'e pɛe 'a blua' 'ʋn ! ‑Ma nyʋ ‑jeopoa' 'de tɔ' 'dinɩa' nʋɛ' 'blʋa ‑wee' \"klein je pee ‑te. ");
INSERT INTO wob_vpl VALUES ("AC24_3","074_24_3","ACT","24","3","3","'De dɩ 'dɔe ‑ma nʋa 'blʋa‑ \"jrii, ‑wɛe ‑aa ‑jea ‑ta \"o ‑ta a, ‑aa poɛ ‑ʋn ɩa' 'sɛ‑. ");
INSERT INTO wob_vpl VALUES ("AC24_4","074_24_4","ACT","24","4","4","'Kaa 'ɩn se ɛ \"i nɩ 'ɩn 'je ‑ʋn 'kpʋ ‑kwlee 'ma bae ‑ʋn ‑ɛ 'de ‑ma 'diwɔnmɔa' 'ʋn ɛ, dɛ klea\" ‑aa jia 'tmʋa ‑ta, ‑ɩn po ɛ doin\" o. ");
INSERT INTO wob_vpl VALUES ("AC24_5","074_24_5","ACT","24","5","5","Dɛ ‑a ‑jea 'de \"ju ‑nɔ 'ʋn ɛ, ɛmɛ ‑nɩ ɔɔ' ‑tɩ' siɛ ‑a kwai, ɔ nɩɛ 'wɛ‑ ‑o, ɔ je ‑a ‑pʋn\" nɩ‑, ɔ poɛ 'ʋn ‑seea' 'bo Suifʋ \"klein ‑nɩa 'e 'blʋa‑ \"kpei 'nynɩ, ‑wɛe ɔ dooa ʋʋ ‑pʋ a \"jru, ɔmɔ ‑ɔ ‑nɩa 'e Nasareɛn‑wi\" 'a 'fɔ o ɛ. ");
INSERT INTO wob_vpl VALUES ("AC24_6","074_24_6","ACT","24","6","6","Ɔ nʋɛ' mɔ ‑wee' 'sʋ ɔ je Kea ‑gbu klaa\" ‑gban' ‑sa, ‑wɛe ‑a ‑nynɔɔ i. ‑A ‑nɩɛi\" ka ‑aa kɛ' 'da ‑a ‑je ɔɔ' 'pee 'je kan'. ");
INSERT INTO wob_vpl VALUES ("AC24_7","074_24_7","ACT","24","7","7","'Kaa Lisiasɩ ‑ɔ ‑nɩa \"sʋɩ 'a klaa\" mɔ ‑kaan 'bo i ‑wɛe ‑ɔ ‑te ‑a ‑klan\" \"kpei ‑ɔ ‑sɔ 'de ‑a 'kwa 'de \"ikmaa' 'ʋn. ");
INSERT INTO wob_vpl VALUES ("AC24_8","074_24_8","ACT","24","8","8","‑Wɛe ɔ 'na ‑a ji 'nɔ ‑ʋn \"juɔi 'de ‑ɩn ‑jɩ 'tmʋ. ‑Bo ‑ma ‑cɛ\" 'kpa ‑tee' ɔ i ɛ, ka dɩ \"klein ‑a ‑tmʋa ɩ nɩa tɔ' ‑ma muɛ kan' 'jea'. ");
INSERT INTO wob_vpl VALUES ("AC24_9","074_24_9","ACT","24","9","9","Dɛ Tɛtuilɩ 'tmʋa 'mʋa‑ mɛ Suifʋ ‑wee' a 'nyɛ \"kpei‑ ʋʋ 'na : Dɛ ‑nʋʋa, mɛ ‑nao. ");
INSERT INTO wob_vpl VALUES ("AC24_10","074_24_10","ACT","24","10","10","Ʋʋ ‑kɔa' \"i 'sʋ ‑gbʋa'na \"nyɩɛ Pɔo wlu, ‑wɛe Pɔo wlu ka ɔ 'na : 'Ma ‑gbʋa'na, 'ɩn 'je kan' 'mɛ ‑ɩn ‑kwle 'blʋa ‑nɛ 'ɛ 'pee 'jea' ‑wɛ‑ 'de ‑sɩn ‑tuu\" 'di. Ɛmɛ ‑tɩ 'ma tɔ' kui ‑wɛe 'ma ji 'ma ‑cɛ\" 'ɛ \"kpei ‑tɩ' 'a wlu 'ʋn \"dua'. ");
INSERT INTO wob_vpl VALUES ("AC24_11","074_24_11","ACT","24","11","11","‑Ɩn ‑beeɛ' ‑ɩn juo ɛɛ' 'wɩ ‑puue 'jɔ 'sɔɔn ka, ‑wɛe 'ɩn ji Kea \"juɔi ‑gbɛɛa' 'bo Selisalɛm. ");
INSERT INTO wob_vpl VALUES ("AC24_12","074_24_12","ACT","24","12","12","'Ɩn ke nyɔ se ‑tooa' nɩ 'de Kea ‑gbu klaa\" 'di ʋʋ se 'ʋn jɛɛ‑, 'ɩn ke nyʋ jrʋ' se ‑tooa' nɩ 'de Suifʋ‑wi\" 'a \"jrui 'kɩɩn‑gbi 'dii, ʋʋ se 'ʋn jɛɛ‑ mɔ foo\" 'sʋ, ʋʋ se 'ʋn ‑kli poa' jɛɛ 'de ‑kwlɔ ‑kwea ‑tajrɔ. ");
INSERT INTO wob_vpl VALUES ("AC24_13","074_24_13","ACT","24","13","13","'De ‑tɩ' ʋʋ bla 'ʋn \"kpei ‑ta, ‑wɛe ‑ɛɛ wlua' ʋʋa wlua kaan, ɛ se bʋ 'ble. ");
INSERT INTO wob_vpl VALUES ("AC24_14","074_24_14","ACT","24","14","14","Dɛ 'ma jua \"i 'de ‑ʋn ‑pee ɛ, mɛ ‑nɩ 'ma ‑gbɛɛ' 'ɩn \"bo ‑wi\" 'a Kea. 'Ma Kea ‑gbɛɛ' sʋn ‑nɛ, mɛ ʋʋ 'na ɛ se ka ‑cɔɔn' ka nɩ. 'Kaa dɩ \"klein ‑ɩ ‑crɩɩa' 'de Kea 'a kɛ' ke Kea 'a wlu 'kwajaaʋn 'a 'sbɛ 'di ɛ, 'mɔ 'jɩ tɔ' 'ʋn 'ɛ, ɩmɩ 'ɩn tba tɔ' \"i. ");
INSERT INTO wob_vpl VALUES ("AC24_15","074_24_15","ACT","24","15","15","Ka 'mɔ 'jea \"isrɛʋn o, nyʋ ‑sea' \"isrɛ ʋʋa' \"kunyɩɔ' sɔn ‑tɩ tɔ' 'ʋn ɛ, 'kamɔ ʋʋmʋ 'jɩ tɔ' 'ʋn ‑wɛe ʋʋ tbɩ tɔ' \"i ‑ke. ");
INSERT INTO wob_vpl VALUES ("AC24_16","074_24_16","ACT","24","16","16","Ɛmɛ ‑tɩ 'ma kpʋʋn 'ma ‑cɛ\" i ‑wɛe 'ma tɔ' 'e 'pepe nɩ 'bo Kea ke nyiɔ \"juɔi. ");
INSERT INTO wob_vpl VALUES ("AC24_17","074_24_17","ACT","24","17","17","'Ɩn nʋa ‑sɩn ‑tuu\"‑tuu 'de 'kwla \"kpei ɛ 'ɩn jiɛ Selisalɛm de. 'Ɩn ja 'ma 'cɛ 'ɛ sʋn o powɛi' ‑wɛe 'ɩn je 'sraa‑ ‑sa 'ɩn 'je Kea \"nyɩ. ");
INSERT INTO wob_vpl VALUES ("AC24_18","074_24_18","ACT","24","18","18","Dɛ Kea 'a kɛ' \"sia 'nynɩ 'de 'pepe nɩ ‑tɩ 'ʋn ɛ, mɛ 'ɩn nɩ nʋa' 'de Kea ‑gbu klaa\" 'di ‑wɛe Suifʋ‑wi\" ‑wlʋa 'e Asi jɛɛ 'ʋn, nyɔ jrɔ' se bɔ' bla ‑wɛe ‑kli po‑tɩ. ");
INSERT INTO wob_vpl VALUES ("AC24_19","074_24_19","ACT","24","19","19","Ɛ nɩ ʋʋpʋ ‑mɔ ‑je de 'wlʋʋ‑ 'bo ‑ʋn \"juɔi ‑ta 'de‑ ‑wɛe ‑ʋʋ ‑je 'ʋn ‑pa \"kpei bla ‑bo ʋʋ 'ble dɛ deejrɛ' ʋʋ 'je 'tmʋ 'de 'ma ‑tɩ' 'ʋn ɛ. ");
INSERT INTO wob_vpl VALUES ("AC24_20","074_24_20","ACT","24","20","20","'De ‑bo ɛ nɩ nyʋ ‑nʋ ‑mʋ ɛ, ‑mɛ ‑ta ʋʋ kpaa 'ʋn 'bo ‑gbajeʋn \"juɔi ɛ, dɛ ʋʋ 'jea 'ʋn ‑pʋn\" ‑gblein' ɛ, ʋʋ 'tmʋ ɛ. ");
INSERT INTO wob_vpl VALUES ("AC24_21","074_24_21","ACT","24","21","21","'Ɩn se dɛ jrɛ' nʋ ‑bo ɛ se \"kunyɩɔ' sɔn‑tɩ ‑gbai' 'a 'sʋ mɩ 'ɩn 'tmʋ 'bo nyʋ ‑wee' 'a ‑kwea' nɩ ɛ. 'De ɛɛ' ‑tɩ' 'ʋn ɛ, mɔ 'ma 'pee a 'jeeɛ ‑sɩan 'bo ‑ʋn ‑juɔi\". ");
INSERT INTO wob_vpl VALUES ("AC24_22","074_24_22","ACT","24","22","22","'Sʋ Foisi ‑ɔ ‑jua Kea 'a ‑jei\" naa‑tɩ 'pepe ɛ, ɔ ‑teɛ ʋʋa' 'tmʋa' kwai\" ‑wɛe ɔ 'na : ‑Ta \"sʋɩ 'a klaa\" Lisiasɩ jii ɛ, ‑wɛe 'ɩn 'je aoa' 'pee 'je. ");
INSERT INTO wob_vpl VALUES ("AC24_23","074_24_23","ACT","24","23","23","‑Wɛe ɔ wlu 'e \"soai ‑pee ɔ 'na : ‑Ɩn ‑fuo ɔ 'dei 'de 'diwɔnmɔa' 'ʋn. ‑Ɩn ‑bɛɛ' ‑ɩn ‑je ɔ nɔ\" \"nyɩ ‑wɛe ɔ ke ɔɔ' \"dɛi‑wi\" 'je 'jee‑, 'de ʋʋ 'je ɔ 'dɔe \"jrii nʋ, ‑ɩn ‑bo ʋʋpʋ ‑je de kaan. ");
INSERT INTO wob_vpl VALUES ("AC24_24","074_24_24","ACT","24","24","24","'Wɩ jrɩ' ‑sia' 'sʋ, Foisi ke ɔɔ' 'nynɔ Druisilɩ nɩɛ Suifʋ 'nynɔ ji'. 'Sʋ ɔ dbo nyɔ ‑wɛe ɔ 'da Pɔo, 'de dɛ ɔ 'jea 'tmʋ 'de Sesi Klisɩ 'a ‑kwlɩ\" ‑te' ‑tɩ 'ʋn ʋʋ 'je ɛ doin\" o po. ");
INSERT INTO wob_vpl VALUES ("AC24_25","074_24_25","ACT","24","25","25","'Kaa ‑ta Pɔo ‑tea \"isrɛ ‑tɩ ke ‑cɛ\" \"wɔin 'bɛɛ tɩ ke Kea 'a 'pee ‑a mua jia 'a ‑tɩ' 'tmʋa' ‑pʋn\" 'sʋ, faʋn a nʋ Foisi 'mɛ, 'sʋ ɔ 'na : ‑Ɩn ‑bɛɛ' ‑ɩn ‑je mu la, ‑bo 'ɩn 'je nɔ\" ke'wlɛ ɛ, ‑wɛe 'ɩn 'je ‑ʋn 'da. ");
INSERT INTO wob_vpl VALUES ("AC24_26","074_24_26","ACT","24","26","26","Dɛ ɔɔ naa tɔ' i 'de ɛ, ɛmɛ ‑nɩ Pɔo 'je ɔ 'wɛi \"nyɩ, ɛ mɛ ‑tɩ ɔɔ 'da Pɔo jeejee 'de ɔ ke ɔɔ wlu. ");
INSERT INTO wob_vpl VALUES ("AC24_27","074_24_27","ACT","24","27","27","'Kamɔ ɔ nʋ 'sʋ ‑sɩn 'sɔɔn je ‑si' 'sʋ Pɔɔsisɩ Fɛtisɩ \"sii‑ 'bo ɔɔ' ‑kɔi\" ka ‑gbʋa'na nɩa. Foisi nɩɛ \"i ɔ 'jea 'e Suifʋ‑wi\" \"jri 'dei nmɔɔ 'sʋ ɛ, ɔ \"taiɛ Pɔo \"i 'de ‑kaso 'di. ");
INSERT INTO wob_vpl VALUES ("AC25_1","074_25_1","ACT","25","1","1","‑Ta Fɛtisɩ jia 'de ɛɛ' 'blʋa 'a 'fɔ tu o ɛ, ɔ nʋɛ 'wɩ taan 'bo Sesare ‑wɛe ɔ 'wlʋ 'o 'de ɔ mu Selisalɛm. ");
INSERT INTO wob_vpl VALUES ("AC25_2","074_25_2","ACT","25","2","2","'Bomɔ 'sraa ‑saʋn klae\" ke nyʋ ‑ʋʋ ‑nɩa dɛwɔn 'de Suifʋ‑wi\" \"klu poo Pɔo \"kuan 'de ɔ o ‑wɛe ʋʋ ‑tee' ɔ i ");
INSERT INTO wob_vpl VALUES ("AC25_3","074_25_3","ACT","25","3","3","ɔ 'je ʋʋpʋ ‑kɩn kwa 'wɔɔn‑, ɔ 'je Pɔo Selisalɛm ja‑, dɛ‑nʋɛ' ʋʋ poo ɔɔ' ‑tɩ' 'mɛ, ʋʋ nɩɛ \"i ʋʋ 'je ɔ 'dba 'bo ‑jei\". ");
INSERT INTO wob_vpl VALUES ("AC25_4","074_25_4","ACT","25","4","4","'Kaa Fɛtisɩ 'na Pɔo nɩɛ ‑kaso 'di 'bo Sesare ‑wɛe ɔ mɔɔ' ‑cɛ\" 'kpa ‑teɛ 'e de mu ‑tɩ ‑ta 'wɩ 'sɔɔn. ");
INSERT INTO wob_vpl VALUES ("AC25_5","074_25_5","ACT","25","5","5","'De ɔ 'na : 'Ɩn nɩɛ \"i aoa' klae\" ‑wi\" ke 'ma ‑a ‑je mu ‑wɛe ‑bo \"ju ‑nɔ nʋ dɛsaʋn ɛ, 'de ʋʋ 'je ɛ 'tmʋ. ");
INSERT INTO wob_vpl VALUES ("AC25_6","074_25_6","ACT","25","6","6","'Wɩ Fɛtisɩ nʋa 'o ʋʋpʋ ɩ 'bɛɛ ‑mɛ\" na ke ‑puue 'mɛ, ‑wɛe ɔ mu Sesare de. Ɛɛ' ‑sɔn' ‑sɩan ɔ ‑teɛ i 'bo ɔɔ' 'pee 'jekpa‑tɛ \"kpei 'de ɔɔ' 'sra ‑sɔn, ‑wɛe ɔ 'tmʋʋ nyʋ 'de ʋʋ 'je Pɔo ja‑. ");
INSERT INTO wob_vpl VALUES ("AC25_7","074_25_7","ACT","25","7","7","Pɔo jia 'sʋ ɛ, Suifʋ‑wi\" ‑wlʋa Selisalɛm ‑gbae' ɔ 'dei, ‑wɛe ʋʋa ‑tu\" ɔ ‑tɩ' klae\" klae\" ‑tuu\"‑tuu ‑sea' 'jɔ 'ble \"kpei. Dɛ ʋʋ 'jea 'nynɩ \"si ‑gblein', ɛ se nɩ‑ ");
INSERT INTO wob_vpl VALUES ("AC25_8","074_25_8","ACT","25","8","8","Pɔo \"dua ɔɔ' ‑cɛ\" 'ɛ ‑tɩ' \"kpei‑sawlu 'ʋn ɔ 'na : 'Ɩn se Suifʋ‑wi\" 'a kɛ'ɛ wlu wɔn blaa‑, 'ɩn se dɛ ‑nyniia \"jrii nʋ 'de Kea ‑gbu klaa\" ‑pee. 'Ɩn se dɛsaʋn jrɛ' 'tmʋ 'de Sesaa 'blʋa jei ‑pee. ");
INSERT INTO wob_vpl VALUES ("AC25_9","074_25_9","ACT","25","9","9","'Kaa Fɛtisɩ nɩa \"i ɔ 'jea 'e Suifʋ‑wi\" \"jri 'dei nmɔɔ ɛ, ɔ wlu' 'de Pɔo ‑pee ɔ 'na : ‑Ɩn ‑nɩɛ \"i 'mɛ ‑ɩn ‑je Selisalɛm mu ‑wɛe ‑ma 'pee 'je 'jeeɛ‑ 'bo 'ma ‑cɛ\" 'kpa \"juɔi 'de 'tmʋa' ‑nɛ 'ɛ ‑tɩ' 'ʋʋn ? ");
INSERT INTO wob_vpl VALUES ("AC25_10","074_25_10","ACT","25","10","10","'Sʋ Pɔo 'na : 'Bo 'blʋajei klaa\" \"juɔi mɔ 'ɩn 'je mu, 'bomɔ 'ma 'pee 'e 'jeeɛ‑. 'Ɩn se dɛsaʋn jrɛ' nʋ 'de Suifʋ‑wi\" ‑pee, ‑ma ‑cɛ\" 'kpa juɩ' 'pepe. ");
INSERT INTO wob_vpl VALUES ("AC25_11","074_25_11","ACT","25","11","11","‑Bo 'ma nʋʋdɩ se \"isrɛ, 'de ‑bo 'ɩn nʋ dɛsaʋn klaa\" ‑ɛ ‑nɩ 'ma 'dba ka a, 'ɩn se 'mɛa' plee‑, 'kaa ‑bo ‑tɩ' ʋʋa bla 'ʋn \"kpei se tɔ' nɩ ɛ, ‑mɛ nyɔ \"o nyɔ se ɛ 'bɛɛ‑ ɔ 'je 'ʋn ʋʋpʋ \"nyɩ. 'Ɩn nɩɛ \"i 'ɩn 'je 'e Sesaa \"juɔi mu. ");
INSERT INTO wob_vpl VALUES ("AC25_12","074_25_12","ACT","25","12","12","'Sʋ Fɛtisɩ ke ɔɔ' ‑sae' ‑siʋn 'wlʋa \"sɩan 'sʋ ɔmɔ wlu Pɔo ‑pee, ɔ 'na : Ka ‑ɩn ‑sia\" ‑bluajei 'a 'nynɩ ‑mɔ kaan 'ja a, ‑mɛ ‑ma muɛ 'de ɔ \"juɔi mua'. ");
INSERT INTO wob_vpl VALUES ("AC25_13","074_25_13","ACT","25","13","13","Ɛ nʋa 'wɩ pla 'sʋ, 'beɔ Aklipa ke ɔɔ' 'nynɔ Berenisɩ jiɛ 'o Sesare ‑wɛe ʋʋ ke Fɛtisɩ 'e 'jee‑. ");
INSERT INTO wob_vpl VALUES ("AC25_14","074_25_14","ACT","25","14","14","Ʋʋ nʋa 'o 'wɩ 'sʋ, Fɛtisɩ toɛ Pɔo 'a ‑tɩ' 'beɔ \"i ɔ 'na : \"Ju due' Foisi sie ‑kaso 'di ‑ta. ");
INSERT INTO wob_vpl VALUES ("AC25_15","074_25_15","ACT","25","15","15","‑Ta 'ɩn mua Selisalɛm ɛ, 'sraa ‑saʋn klae\" o, Suifʋ‑wi\" 'a nyʋ‑cɔɩn' poo ɔ \"kuan 'de 'ʋn o, ʋʋ ‑teeɛ' 'mii, 'ɩn 'je ɔɔ' 'pee 'je. ");
INSERT INTO wob_vpl VALUES ("AC25_16","074_25_16","ACT","25","16","16","‑Wɛe 'ɩn wlu ka 'de ʋʋ ‑pee 'ɩn 'na : Nyɔ nyʋ bla ‑tɩ' \"kpei ɛ, ‑bo nyʋ ‑ʋʋ ‑ke ɔ 'blea ‑tɩ' se \"jriɛ‑ \"i ‑te ‑wɛe ɔ se ɔɔ' ‑cɛ\" 'ɛ \"kpei ‑tɩ 'tmʋ ɛ, ‑mɛ Rɔmʋ‑kɔʋn 'a 'je ɔɔ' 'pee, ɛ se ʋʋa' \"bli kplɩn nɩ‑. ");
INSERT INTO wob_vpl VALUES ("AC25_17","074_25_17","ACT","25","17","17","Ʋʋ ke 'ma ‑a jia ‑ta, 'ɩn se nɔ\" \"i \"tai‑ ɛ se ‑si', ‑sɔn' ‑sɩan' 'sʋ 'ɩn ‑teɛ 'bo 'ma 'sra ‑sɔn ‑wɛe 'ɩn dbo nyʋ ʋʋ mu \"ju ‑nɔ 'daa'. ");
INSERT INTO wob_vpl VALUES ("AC25_18","074_25_18","ACT","25","18","18","Nyʋ ‑ke ɔ 'blea 'tmʋa' ‑kwɛa de ɛ, dɩsaɩn ‑jɩ 'ma ‑a naa tɔ' i 'de ɛ, ʋʋ se ɩa' jrɛ' 'tmʋ 'de ɔɔ' ‑tɩ' 'ʋn. ");
INSERT INTO wob_vpl VALUES ("AC25_19","074_25_19","ACT","25","19","19","Dɛ ʋʋ ke ɔɔ ‑tooa' 'ʋn ɛ, ɛmɛ ‑nɩ 'de ʋʋa' Kea ‑gbɛɛ' sʋn 'a ‑tɩ' 'ʋn, ɛ ke \"ju jrɔ' ʋʋa 'daa‑ Sesi ‑ɔ ‑mɛa ɔmɔ Pɔo ‑mɔ 'na ɔ nɩɛ 'kmʋ. ");
INSERT INTO wob_vpl VALUES ("AC25_20","074_25_20","ACT","25","20","20","‑Ta 'ɩn 'je ‑foo 'de ɛɛ' 'tmʋa' tu 'ʋn ‑gblein' 'ɩn se 'o 'je, 'sʋ 'ɩn toɛ Pɔo \"i ‑bo ɔ nɩɛ \"i ɔ 'e Selisalɛm mu 'de ɔɔ' 'pee 'e 'jeeɛ 'demu ɛ. ");
INSERT INTO wob_vpl VALUES ("AC25_21","074_25_21","ACT","25","21","21","'Kaa Pɔo ‑tuɛ\" 'beɔ klaa\" ‑wɛe ɔɔ' 'pee 'je ɔ \"juɔi mu. ‑Wɛe 'ɩn 'tmʋʋ nyʋ ‑wɛe ʋʋ 'je ɔ i fuo mamaʋ dɛ ‑jɛɛa ɔɔ' 'de Sesaa \"juɔi mua'. ");
INSERT INTO wob_vpl VALUES ("AC25_22","074_25_22","ACT","25","22","22","'Sʋ Aklipa 'na : Fɛtisɩ, 'ɩn nɩɛ \"i 'ɩn 'je \"ju ‑nɔ 'ɔ wlu 'wɔn ‑ke. Fɛtisɩ 'na : ‑Bo ‑klae\" ɛ, ‑ma muɛ ɔɔ' wlu 'wɔan'. ");
INSERT INTO wob_vpl VALUES ("AC25_23","074_25_23","ACT","25","23","23","‑Sɔn' ‑sɩan' 'sʋ Aklipa ke Berenisɩ paa dɩ 'ʋn ‑wɛe \"sʋɩ 'a klae\" o, nyʋ ‑ʋʋ ‑nɩa dɛwɔn 'bo ‑kwlɔ ‑nɛ 'di ɛ, ʋʋ ‑wee' ‑kwɛ‑ de 'de 'peeje na', ‑wɛe Fɛtisɩ dbo nyʋ 'de ʋʋ ja Pɔo. ");
INSERT INTO wob_vpl VALUES ("AC25_24","074_25_24","ACT","25","24","24","Fɛtisɩ \"dua wlu 'ʋn ɔ 'na : 'Beɔ Aklipa ke ao ‑wee' \"klein ‑ɔ ‑ke ‑a ‑nɩa ‑ta ke‑, ao ‑gbʋn 'nɔ, \"ju Suifʋ‑wi\" ‑nɩa Selisalɛm o, ‑jʋ ‑nɩa ‑ta pooa \"kuan 'de 'ʋn o ‑wɛe ʋʋ 'na ɔ 'je 'mɛ ‑o \"kpɔ \"kpɔ ɛ, ɔ ka. ");
INSERT INTO wob_vpl VALUES ("AC25_25","074_25_25","ACT","25","25","25","‑Bo ɛ nɩ 'mɔ ɛ, ‑mɛ dɛsaʋn ‑jɛ ɔ nʋa ‑wɛe ɔ 'jea 'kmʋ 'wlʋ, 'ɩn se ɛ 'je. 'Kaa ka ɔɔ' ‑cɛ\" 'kpa 'na ɔ 'je 'e Sesaa \"juɔi mu ɛ, ɛmɛ ‑tɩ 'ma ji ɔ 'e kpaa'. ");
INSERT INTO wob_vpl VALUES ("AC25_26","074_25_26","ACT","25","26","26","Dɛ 'ɩn 'jea 'crɩ ‑gblein' 'de ɔɔ' ‑tɩ' 'ʋn ‑wɛe 'ɩn 'jea Sesaa kpa, ɛ se nɩ‑. Ɛmɛ ‑tɩ 'ɩn 'dɔɔ 'bo ao ke ‑mɔ 'beɔ Aklipa \"juɔi 'de ‑bo nyʋ ‑tee' ɔ i, ‑wɛe 'ɩn 'je dɛ 'ɩn 'jea 'crɩ 'je ");
INSERT INTO wob_vpl VALUES ("AC25_27","074_25_27","ACT","25","27","27","dɛ‑nʋɛ' 'mɔ 'na ɛ se ka ‑cɔɔn' ka nɩ nyʋ 'je ‑kaso 'di mu 'de dɛ ‑ɛɛ ‑kaso ɔ mua 'di, ɛ se bʋ 'ble 'pepe. ");
INSERT INTO wob_vpl VALUES ("AC26_1","074_26_1","ACT","26","1","1","‑Wɛe Aklipa wlu 'de Pɔo ‑pee ɔ 'na : ‑Ɩn ‑bɛɛ' ‑ɩn ‑je ‑ma ‑cɛ\" 'kpa 'a \"kpei ‑tɩ 'tmʋ. 'Sʋ Pɔo ‑kaa' nyʋ kwai\" ‑wɛe ɔɔ 'tmʋ ɔɔ' ‑cɛ\" 'ɛ \"kpei ‑tɩ. ");
INSERT INTO wob_vpl VALUES ("AC26_2","074_26_2","ACT","26","2","2","Ɔ 'na : 'Beɔ Aklipa, dɛ 'ɩn 'jea 'ma ‑cɛ\" 'ɛ \"kpei ‑tɩ 'tmʋ 'bo ‑ɩn \"juɔi 'de dɩ \"klein Suifʋ‑wi\" bla 'ʋn \"kpei 'a ‑tɩ' 'ʋn ɛ, ɛ nmɔɔ 'ʋn 'di wɔn, ");
INSERT INTO wob_vpl VALUES ("AC26_3","074_26_3","ACT","26","3","3","dɛ‑nʋɛ' ‑ma ‑cɛ\" 'kpa juo Suifʋ‑wi\" 'a \"bli kplɩn o, ʋʋa' 'ʋn ‑too' ‑tɩ 'mɛ 'pepe. 'Ma bae ‑ʋn ‑ɛ, ‑wɛe ‑ɩn ‑je 'ma wlu doin\" o po 'de tɔ' i kua' 'ʋn. ");
INSERT INTO wob_vpl VALUES ("AC26_4","074_26_4","ACT","26","4","4","Dɛ ‑tba' 'e 'ma ‑saan\" nɔ\" ‑wɛe ‑ɛ ‑jɛɛa ‑sɩan a, dɛ 'ma 'kmʋnɩa' 'ʋn ɛ, Suifʋ ‑wee' \"klein juɛ', dɛ‑nʋɛ' ka 'ɩn nʋa 'kmʋ nɩsʋn 'de 'ma 'cɛ‑wi\" \"klu 'bo Selisalɛm ɛ, ʋʋ juɩ' ‑ke. ");
INSERT INTO wob_vpl VALUES ("AC26_5","074_26_5","ACT","26","5","5","Ʋʋ juo 'ʋn 'ɛ sese, ʋʋ 'beeɛ' ʋʋ 'je ɛ 'tmʋ ‑bo ʋʋ nɩɛ \"i ɛ. Fariseɛn‑wi\" ‑ʋʋa ‑jea Kea 'a kɛ' ‑wee' wɔn ‑wɛe ‑ʋʋa' poa ɛɛ' due' i ɛ, 'ɩn nɩɛ ʋʋpʋ 'a due' ‑o 'de‑. ");
INSERT INTO wob_vpl VALUES ("AC26_6","074_26_6","ACT","26","6","6","Kaan ka dɛ ‑ɛɛ 'ma 'pee nyʋ a 'jea, ɛmɛ ‑nɩ dɛ ‑ɛɛ wlu Kea cɛan ‑tie\" 'de ‑a \"bo ‑wi\" ‑pee ɛ, ɛɛ' 'o nyni ‑tɩ mɩ 'ɩn tba tɔ' \"i. ");
INSERT INTO wob_vpl VALUES ("AC26_7","074_26_7","ACT","26","7","7","'De ‑aa 'blʋa 'a blo' wɔn ‑nɩa ‑puue 'jɔ 'sɔɔn ‑wɛe ‑ʋʋa ‑gbɛɛa' Kea \"maʋ' o, 'jrʋ ‑gbao ɛ, ɛmɛ ‑ɛɛ ‑fli ʋʋa 'wlai ‑ke. 'Oo 'beɔ, 'de dɛ ‑a ‑wee' ‑tea ‑kwlɩ\" 'mʋa‑ 'a ‑tɩ' 'ʋn ɛ, ɛmɛ ‑ɛɛ ‑tɩ' Suifʋ‑wi\" a bla 'ʋn ‑pa \"kpei. ");
INSERT INTO wob_vpl VALUES ("AC26_8","074_26_8","ACT","26","8","8","Ao Suifʋ‑wi\" ‑kwea de ‑ta, dɛɛ‑tɩ ‑wɛe ao 'na Kea 'a nyʋ \"kunyɩɔ' ‑satɩ se tɔ' 'ʋn 'je ka nɩ ɛ‑ ? ");
INSERT INTO wob_vpl VALUES ("AC26_9","074_26_9","ACT","26","9","9","Dɛ 'ma ‑cɛ\" 'kpa naa tɔ' i tɛin\" 'de ɛ, ɛmɛ ‑nɩ : 'ɩn 'je Sesi ‑wlʋa Nasarɛtɩ tʋ o ‑fɔn' ka \"o ka 'de‑. ");
INSERT INTO wob_vpl VALUES ("AC26_10","074_26_10","ACT","26","10","10","Ɛmɛ 'ɩn nʋ 'bo Selisalɛm ‑nʋ ‑nʋ. Nyʋ ‑jea Sesi 'a ‑tɩ' tɔ' 'ʋn ɛ, 'ɩn poɛ ʋʋpʋ 'a ‑tuu\"‑tuu ‑kaso 'di ‑po ‑po. 'Sraa ‑saʋn 'a klae\" ‑wi\" ‑nyɩ\" 'ʋn ɛɛ' 'sbɛ‑ ‑wɛe nyʋ ‑a ‑dba ʋʋpʋ ɛ, ʋʋ ke 'ma ‑a ‑ble wlu due'. ");
INSERT INTO wob_vpl VALUES ("AC26_11","074_26_11","ACT","26","11","11","'Ɩn ‑tuɛ\" ʋʋpʋ 'kle kpɛ ‑tuu\"‑tuu \"jrui 'kɩɩɛn‑gbi 'dii ‑wɛe 'ma kpʋn ʋʋpʋ \"klaan‑ \"klan 'de ʋʋ 'je ʋʋa' Kea ‑kwlɩ\" ‑tea' wɔn ‑sa. 'Cɛn 'ɩn 'kpa 'de ʋʋ ‑pee 'de ɛɛ' \"ikmaa' ‑tɩ' 'ʋn 'ma muɛ ‑kwlɛ 'srʋɩ 'dii ‑wɛe 'ma ‑tu\" ʋʋpʋ 'kle. ");
INSERT INTO wob_vpl VALUES ("AC26_12","074_26_12","ACT","26","12","12","'De ɛɛ' ‑tɩ' 'ʋn mɔ 'ma mu Damasɩ. ‑Ta 'ma muua, 'sraa ‑saʋn 'a klae\" ‑wi\" cɛn 'o wlu ‑wɛe ‑ʋʋ ‑nyɩ\" 'ʋn 'sbɛ‑. ");
INSERT INTO wob_vpl VALUES ("AC26_13","074_26_13","ACT","26","13","13","'Oo 'beɔ, ‑ta 'ma muua 'jrʋ‑gbao 'bo ‑jei\" ɛ, 'ɩn 'jeeɛ ‑sɔn' klaa\" \"jriɛ‑. Ɛɛ' ‑sɔn' tu 'wlʋɛ 'e jaʋn 'di ɛɛ fan', ɛ je 'jrʋ ‑sii. ‑Ta nyʋ ‑ʋʋ ‑ke 'ma ‑a mua nɩa, 'bomɔ ɛ ‑sɩɩn. ");
INSERT INTO wob_vpl VALUES ("AC26_14","074_26_14","ACT","26","14","14","‑A ‑wee' \"klein 'blʋɔ 'sʋ 'ɩn 'wɔn wlu due' ‑ɛ ‑wlu 'ʋn ‑pee ka 'de Suifʋwlu 'ʋn, ɛ 'na : Sɔo, Sɔo, dɛɛ‑tɩ ‑ma ‑fɔn' 'ʋn o ɛ‑ ? 'De ‑ma \"jruku‑tɩ 'ʋn ɛ, ‑ma kpʋɛn ‑ma ‑cɛ\" ‑kwlʋ. Ka bli' a ‑fun\" a \"jru 'de ɛɛ' jei 'a kwa'bletu ‑nɩa 'mɩmɩ ‑pee ɛ, 'kamɔ ‑ɩn ‑nɩ. ");
INSERT INTO wob_vpl VALUES ("AC26_15","074_26_15","ACT","26","15","15","‑Wɛe 'ɩn wlu ka 'ɩn 'na : ‑Mɔ nyɔ ‑o ɛ‑, Tʋ\"bo ? 'Sʋ Tʋ\"bo 'na : 'Mɔ Sesi ‑ma ‑fɔan' tʋ o, 'mɔ ‑o. ");
INSERT INTO wob_vpl VALUES ("AC26_16","074_26_16","ACT","26","16","16","‑Ɩn sɔn 'ʋn la, ‑wɛe ‑ɩn ‑je bɩ \"kpei nyna‑, dɛ‑nʋɛ' 'ɩn ‑sa 'ma ‑cɛ\" 'kwla 'mɛ 'de ‑ʋn ‑pee ‑wɛe 'ɩn 'je ‑ʋn 'ma ‑tɩ' 'tmʋi 'ʋn nʋ. 'De dɩ ‑ɩn ‑jeea' \"jriɛ‑ o, ‑jɩ ‑ɩa ‑tɩ' 'ʋn 'ɩn ‑sa 'ma ‑cɛ\" 'kwla 'de ‑ʋn ‑pee o, ‑ɩn ‑je ɩa' ‑ta 'jei nɩ‑. ");
INSERT INTO wob_vpl VALUES ("AC26_17","074_26_17","ACT","26","17","17","'Ɩn ‑sa ‑ʋn 'de ‑ma 'cɛ ke nyʋ 'srʋ \"klu, ‑wɛe 'ma dbo ‑ʋn 'de ʋʋpʋ ‑pee. ");
INSERT INTO wob_vpl VALUES ("AC26_18","074_26_18","ACT","26","18","18","‑wɛe ‑ɩn ‑je ʋʋa' \"jri 'bai‑. Ʋʋ 'je 'e kwie 'ʋn 'wlʋ 'de ʋʋ 'je 'e ‑sɔn' 'ʋn ji, ʋʋ 'je 'e ‑siɔn' 'kwa 'wlʋ, 'de ʋʋ 'je 'e Kea 'kwa ji ‑wɛe 'de ʋʋa' Sesi 'a ‑tɩ' tɔ' 'ʋn 'jea' 'ʋn ɛ, ʋʋa' dɛsaʋn 'je ‑kwɛ‑ ‑wɛe ʋʋ 'je 'kɛn kpa ʋʋ ke nyʋ ‑kweai ke‑. ");
INSERT INTO wob_vpl VALUES ("AC26_19","074_26_19","ACT","26","19","19","'De ɛɛ' ‑tɩ' 'ʋn ɛ, 'beɔ Aklipa, 'ɩn se wlu ‑ɛ ‑wlʋa 'e jaʋn 'di 'mʋa‑ 'klee i po. ");
INSERT INTO wob_vpl VALUES ("AC26_20","074_26_20","ACT","26","20","20","'Sʋ 'ɩn ‑teɛ Kea 'a ‑tɩ' 'tmʋa' ‑pʋn\" 'de nyʋ ‑nɩa 'o Damasɩ ‑pee ke ‑ba. ‑Wɛe 'ɩn 'tmʋɩ 'de Selisalɛm ‑nyʋ ‑pee, 'ɩn 'tmʋɩ 'de Suideblʋa jrɩ' 'dii, 'ɩn 'na : Ao juo aoa' dɩsaɩn \"i, 'de ao 'je 'e Kea o \"biie‑. 'De dɩ ao 'jea nʋ, ɩ 'je ɛ to‑ ka aoa' 'kmʋ pooa fai\" ɛ. ");
INSERT INTO wob_vpl VALUES ("AC26_21","074_26_21","ACT","26","21","21","Dɛ ‑ɛɛ ‑tɩ' Suifʋ‑wi\" kpʋn a 'ʋn 'de Kea ‑gbu klaa\" 'di ‑wɛe ʋʋa ‑pɔn 'ma 'dbaa 'a ‑kɔ i Ɛmɛ ‑nao. ");
INSERT INTO wob_vpl VALUES ("AC26_22","074_26_22","ACT","26","22","22","'Kaa Kea 'a 'saaʋn mɛ ‑nʋɛ' ‑wɛe 'ɩn nɩ 'kmʋ mamaʋ ‑sɩan ke, ‑wɛe 'ma 'tmʋ Kea 'a ‑tɩ'. Dɩ \"klein Kea 'a wlu 'kwajaaʋn ke Moisɩ 'tmʋa ‑wɛe ʋʋ 'na ɩa muɛ 'o nynia', ɩmɩ 'ma 'tmʋ 'de mɩɩ\" ke klae\" \"juɔi, 'ɩn se dɛ jrɛ' \"i ‑si'. ");
INSERT INTO wob_vpl VALUES ("AC26_23","074_26_23","ACT","26","23","23","Ɛmɛ ‑nɩ Klisɩ a muɛ 'kle 'jea' ‑wɛe ɔ 'e \"kunyɩɔ' sɔn tɛin\" 'de 'mɛʋn \"klu, ‑wɛe ‑sɔn' ‑ɛ ‑sa nyʋ 'e kwie 'di ɛ, ɔ 'je ɛɛ' ‑tɩ' 'tmʋ 'de ɔɔ' 'cɛ ke nyʋ jrʋ' ‑pee. ");
INSERT INTO wob_vpl VALUES ("AC26_24","074_26_24","ACT","26","24","24","Pɔo siɛ ɔɔ' ‑cɛ\" 'ɛ \"kpei ‑tɩ 'a 'tmʋa' 'sʋ Fɛtisɩ kpa wlu \"jɛi 'de ɔ 'na : Sɩɩan ‑a nʋ ‑ʋn Pɔo, ‑ma dɛ \"i jua' klaa\" ‑nɛ po ‑ʋn sɩɩan \"jri ‑wɛ‑ la. ");
INSERT INTO wob_vpl VALUES ("AC26_25","074_26_25","ACT","26","25","25","'Sʋ Pɔo 'na : \"Ɩɩn‑, nyɔ ‑cɔɔn'‑, ɛ tɔ' ‑tɩ 'a tɔ' ‑tɩ 'ma 'tmʋ, ɛ se \"jri 'a ‑si' ‑tɩ nɩ‑. ");
INSERT INTO wob_vpl VALUES ("AC26_26","074_26_26","ACT","26","26","26","'Beɔ Aklipa mɔ 'ɔ ‑cɛ\" juɩ', ɛmɛ ‑tɩ 'ɩn wa i ‑wɛe 'ma 'tmʋ ɩ 'bo ɔ \"juɔi, dɛ‑nʋɛ' ɩa' dɩ tu se nʋʋɛ 'de 'kwla paa' 'ʋn. ");
INSERT INTO wob_vpl VALUES ("AC26_27","074_26_27","ACT","26","27","27","'Sʋ ɔ wlu' 'de Aklipa ‑pee ɔ 'na : 'Beɔ Aklipa, 'mɔ 'na ‑ɩn ‑je Kea 'a wlu 'kwajaaʋn 'a ‑tɩ' tɔ' 'ʋn 'ɛ o ? 'Ɩn juɛ' ‑ɩn ‑jɩ tɔ' 'ʋn 'ɛ see. ");
INSERT INTO wob_vpl VALUES ("AC26_28","074_26_28","ACT","26","28","28","'Sʋ Aklipa 'na : ‑Ma pooɛ 'ʋn tɔ' i ‑wɛe 'ɩn 'je 'jrʋ ‑gbao Kletiɛn 'kpa. ");
INSERT INTO wob_vpl VALUES ("AC26_29","074_26_29","ACT","26","29","29","'Sʋ Pɔo 'na : ‑Bo ɛ nɩ 'e ‑sɩanwɩ 'di o, ‑bo ɛ nɩ ‑klae\"wɩ 'di o, 'ɩn nɩɛ \"i Kea 'je 'ʋn ‑kɩn kwa 'wɔɔn‑ ɛ se ‑ma 'sʋ mɔ nɩ‑, 'kaa ao ‑wee' ‑ɔɔ poa 'ma wlu doin\" o ‑ta ‑sɩan, 'ɩn nɩɛ \"i ka 'ɩn nɩa, ao 'je kan' nɩ, ɛ se ao 'je \"cɩn sʋn' mu ‑mɛ nɩ‑. ");
INSERT INTO wob_vpl VALUES ("AC26_30","074_26_30","ACT","26","30","30","'Sʋ 'beɔ o, ‑gbʋa'na o, Berenisɩ o, nyʋ \"klein ‑ke ʋʋ ‑tea i ɛ, ʋʋ ‑wee' sɔn 'ʋn 'ɛ, ");
INSERT INTO wob_vpl VALUES ("AC26_31","074_26_31","ACT","26","31","31","‑wɛe ʋʋa ‑saa kɩɩn ʋʋa wlu ba ‑pee due 'due ʋʋ 'na : \"Ju ‑nɔ se dɛ jrɛ' nʋ ‑wɛe ‑ɛ ‑je ɔɔ' 'mɛa' ke ɔɔ' ‑kaso 'dipoa' 'je. ");
INSERT INTO wob_vpl VALUES ("AC26_32","074_26_32","ACT","26","32","32","'De Aklipa ke Fɛtisɩ 'na : ‑Bo \"ju ‑nɔ se 'na ɔ 'je 'e Sesaa \"juɔi mu 'de ɛ, ‑mɛ nyʋ \"sii ɔ i 'de‑. ");
INSERT INTO wob_vpl VALUES ("AC27_1","074_27_1","ACT","27","1","1","‑Ta Fɛtisɩ cɛɛan 'o wlu ‑wɛe ‑a ‑jea ‑bato' 'ja 'de ‑a ‑jea Itali muɛ, \"ju due' ‑ɔɔ 'nynɩ nɩ Silisɩ ‑wɛe ‑ɔ ‑nɩ 'blʋajei klaa\" Okisɩ 'a jra' jei, ɔmɔ ʋʋ ‑tu\" Pɔo ke ‑kaso 'dinyʋ jrʋ' \"kpei. ");
INSERT INTO wob_vpl VALUES ("AC27_2","074_27_2","ACT","27","2","2","‑bato' ‑ɛɛ ‑wlʋa Adramitɩ ‑wɛe ‑ɛ ‑jea 'kpʋʋ kpʋn 'de Asiblʋa \"kpei ɛ, ɛmɛ ‑a ‑ja 'di. Nyɔ ‑ke ‑a mua 'e ɛ, ɛmɛ ‑nɩ Aritakɩ, ‑ɔ ‑wlʋa Tesalonikɩ 'de Masedoanɩ. ");
INSERT INTO wob_vpl VALUES ("AC27_3","074_27_3","ACT","27","3","3","'Wɩ ‑tba' 'o ɛ, ‑a kpʋɛn 'kpʋʋ 'bo Sidɔn. Silisɩ nmɔ 'di wɔn 'de Pɔo ‑pee, ɔɔ \"nyɩ ɔ nɔ\" ‑wɛe ɔɔ mu ɔɔ' \"dɛi‑wi\" o i 'de ʋʋa nʋ ɔ 'dɔe \"jrii. ");
INSERT INTO wob_vpl VALUES ("AC27_4","074_27_4","ACT","27","4","4","‑A ‑wlʋa 'o ‑mɔ ɛ, ‑aa pleɛ 'tɔniɛ 'a du' ‑ɛɛ 'nynɩ nɩa Siprʋ wɔn i, dɛ‑nʋɛ' poɔ' ɔ bla ‑a \"jri. ");
INSERT INTO wob_vpl VALUES ("AC27_5","074_27_5","ACT","27","5","5","‑A cɛan 'tɔniɛ 'a 'fɔ ‑ɛ ‑bɔɔa' 'de Silisi ke Pamfili \"kpei ‑tie\" 'sʋ, ‑a nyniɛ 'o Mira 'de Lisi. ");
INSERT INTO wob_vpl VALUES ("AC27_6","074_27_6","ACT","27","6","6","'Bomɔ jra' jei jɛɛ ‑bato' jrɛ' ‑ɛɛ ‑wlʋ Alɛsandri ‑wɛe ‑ɛɛ mu 'e Itali 'sʋ ɔ 'jaa ‑aʋn ɛ. ");
INSERT INTO wob_vpl VALUES ("AC27_7","074_27_7","ACT","27","7","7","'De 'wɩ ‑tuu\"‑tuu 'di ɛ, ‑aa ‑bato' a na' mɩ\"mɩ\", ‑a ‑wɔan Kinidɩ ‑kwlɔ 'di nyni ‑tɩ ɛ, ‑a ‑jeɛ 'kle. Poɔ' ‑sa ‑a ‑wa 'kwa 'sʋ ‑a ‑jiiɛ 'tɔniɛ 'ɛ du' 'bo Krɛtɩ 'a ‑sɔn i 'de Salamɔnɩ fɔ o. ");
INSERT INTO wob_vpl VALUES ("AC27_8","074_27_8","ACT","27","8","8","'Kamɔ ‑a pleɛ wɔn i 'de 'kle 'ʋn mamaʋ 'sʋ ‑a nyni ‑tajrɔ, ʋʋa 'daa‑ 'kpʋʋkpʋn 'ɩn 'dɔe ɛ, ɛ nɩɛ 'o Lase‑kwlɔ ‑pʋn\". ");
INSERT INTO wob_vpl VALUES ("AC27_9","074_27_9","ACT","27","9","9","Nɔ\" ‑siɛ' ‑a i 'bo ‑jei\". ‑Aa ‑bato' 'a naa' 'bo 'tɔniɛ \"kpei nɩɛ 'kle. Ɛ nʋɛ' mɔ 'sʋ wɔn 'bɔ nɔ\" je ‑a i ‑si'. ");
INSERT INTO wob_vpl VALUES ("AC27_10","074_27_10","ACT","27","10","10","Ɔ 'na : 'Ma 'cɛ, dɛ 'ma 'jea i ɛ, ɛmɛ ‑nɩ ‑bo ‑a ‑sɔn 'ʋn ‑wɛe ‑a ‑je mu 'de \"jri ‑nɩ 'di ɛ, ‑aa muɛ 'pʋʋa' 'kle i 'jea' see. Ɛ se dɩ \"klein ‑nɩa 'e ‑bato' 'di ke ‑bato' 'a dooa 'a 'sʋ nɩ‑. 'Kaa ‑aa nyiɔjɔ ɔ muɛ 'o blaa' ‑ke. ");
INSERT INTO wob_vpl VALUES ("AC27_11","074_27_11","ACT","27","11","11","'Kaa jra' jei poɛ ‑bato' 'a tbaai ke ɛɛ' jei 'a wlu doin\" o, ɛ je Pɔo 'a wlu ‑sii‑. ");
INSERT INTO wob_vpl VALUES ("AC27_12","074_27_12","ACT","27","12","12","'Bo ‑bato' 'a 'kpʋʋ kpʋn 'ɩn ‑a ‑nɩa 'mʋa‑ se ka ‑cɔɔn' ka nɩ ‑wɛe ‑a ‑je 'o i ‑te mamaʋ 'sʋ dee 'a ji nɔ\" 'e nyni 'sʋ nyʋ ‑tuu\" nɩɛ \"i ‑a ‑je 'o 'wlʋ ‑wɛe ‑a ‑je 'kpʋʋ kpʋn 'bo Fenisɩ 'de Krɛtɩ‑blʋa 'a 'kpʋʋ \"kpei ‑ɛ ‑gbʋn' a 'jrʋ ‑gbɩn ‑fɔ ‑sɔn, ‑wɛe ‑a ‑je 'o dee' 'a ji nɔ\" ‑wee' nʋʋ‑. ");
INSERT INTO wob_vpl VALUES ("AC27_13","074_27_13","ACT","27","13","13","Poɔ' flee \"flee ‑wlʋa 'e 'jrʋ 'a kʋanfɔ o a jia' 'sʋ ʋʋ naa tɔ' i, ʋmʋ 'na dɛ ʋʋ ‑teea 'dii 'bɛɛ ɛ 'je nʋʋɛ. ‑Wɛe ʋʋ kpa ‑bato' 'a nɩɩɛ ‑ɛ kpʋn ɛ i \"jɛi ‑wɛe ʋʋ ‑te Krɛtɩ‑blʋa ‑kwlɩ' i plea' ‑pʋn\". ");
INSERT INTO wob_vpl VALUES ("AC27_14","074_27_14","ACT","27","14","14","'Kaa ‑pie klaa\" ‑ɛɛ 'nynɩ nɩa Erakilɔn cɛn \"jɛi 'de 'blʋa‑ 'fɔ ʋʋa plea ‑kwlɩ' i \"kpei. ");
INSERT INTO wob_vpl VALUES ("AC27_15","074_27_15","ACT","27","15","15","Ɛ \"tuɛn ‑bato' ‑ta ‑tɔɔn' ‑tɔɔn. Ɛɛ' 'wɔn 'bode ‑aa' muɛ \"i 'sʋ ‑a ‑tai' ɛ ‑aa ‑cɛi\". Ɛ ‑teɛ ‑aa ‑bato' ‑cɩɛ 'klee ‑wɛe ɛɛ kpa ‑aʋn. ");
INSERT INTO wob_vpl VALUES ("AC27_16","074_27_16","ACT","27","16","16","‑A ‑jiiɛ 'e 'tɔniɛ 'a du' ‑ɛɛ 'nynɩ nɩa Kloda 'a ‑sɔn i fɔ o, ‑a mua ‑bato' ‑saan\" nmaea' ‑a ‑jeeɛ' 'kle i. ");
INSERT INTO wob_vpl VALUES ("AC27_17","074_27_17","ACT","27","17","17","Ʋʋ ‑kɔa' ɛɛ' ‑cria' 'sʋ ʋʋ sɛɛn 'bo ‑bato' klaa\" ‑pʋn\". Ʋʋa plea ‑bato' je 'blʋa‑ \"i bla 'de Libiblʋa o fɔ o 'sʋ ʋʋ 'wla ‑bato' 'a tae' ‑wɛe ʋʋ \"tai‑ ʋʋa' ‑cɛi\" la 'de poɔ' 'kwa. ");
INSERT INTO wob_vpl VALUES ("AC27_18","074_27_18","ACT","27","18","18","‑Pie ‑ɛɛ jiia ‑a 'ʋn ɛ, ɛɛ' 'wɔn ɛɛ' 'ka, ɛɛ' ‑sɔn' jrɛ' ‑sɩan 'sʋ ɛ, ʋʋa poɛ dɩ ‑nɩa 'e ‑bato' 'di \"niɔ‑. ");
INSERT INTO wob_vpl VALUES ("AC27_19","074_27_19","ACT","27","19","19","'De 'wɩ 'a taan ‑nɩ 'di 'sʋ ‑a ‑wee' ‑teɛ ‑bato' 'a dɩ ‑nɩa 'o ɛ ‑pʋn\" 'a \"niɔ‑ poa' ‑pʋn\". ");
INSERT INTO wob_vpl VALUES ("AC27_20","074_27_20","ACT","27","20","20","‑Pie ‑nɛ 'ɛ \"ikmaa' nʋɛ' 'sʋ ‑a se 'cʋ‑sɩɩn ke 'jrʋ \"jriɛ‑ 'jee‑ 'de 'wɩ pla 'di. 'De ɛɛ' ‑tɩ' 'ʋn ɛ, ‑a se 'pʋʋa' ‑mɛ ‑kwlɩ\" ‑te' la 'bode. ");
INSERT INTO wob_vpl VALUES ("AC27_21","074_27_21","ACT","27","21","21","‑A se dɛ di 'de 'wɩ ‑tuu\"‑tuu 'di. 'Sʋ Pɔo sɔn 'ʋn 'ɛ 'bo ʋʋa' ‑kwea'‑ ‑wɛe ɔ wlu ʋʋ ‑pee ɔ 'na : 'Ma 'cɛ, ‑bo ao po 'ma wlu doin\" o 'de‑, ‑wɛe ‑a ‑je i ‑te 'bo Krɛtɩ 'de ɛ, ‑mɛ ‑a se 'mɛɛa' 'wɔin dia' ke dɩ 'a \"maa' ‑nɩ 'jei. ");
INSERT INTO wob_vpl VALUES ("AC27_22","074_27_22","ACT","27","22","22","Kaan la 'ja a, 'ma kuuɛ aoa' dɩ i, ao \"duo 'kpɩ 'ʋn, dɛ‑nʋɛ' aoa' nyɔ due' koun ‑gbai' se 'mɛi, ‑aa ‑bato' 'a 'sʋ mɛ ‑je dooa‑. ");
INSERT INTO wob_vpl VALUES ("AC27_23","074_27_23","ACT","27","23","23","Kea ‑ɛɛ nyɔ 'ɩn nɩa ‑wɛe 'ma ‑gbɛɛa', ɛ dboɛ ɛɛ' \"soai due' ɔ wlu 'ʋn ‑pee ka 'de \"maʋ'wɩ ‑nɩ 'di. ");
INSERT INTO wob_vpl VALUES ("AC27_24","074_27_24","ACT","27","24","24","Ɔ 'na Pɔo, faʋn 'bo ‑ʋn nʋɛ, dɛ‑nʋɛ' ‑ɩn ‑je 'o Sesaa \"juɔi mu ‑o, 'de nyʋ \"klein ‑ʋʋ ‑ke ‑ɩn ‑nɩa 'e ‑bato' 'di ‑ta, Kea ‑teɛ' ‑ʋn ʋʋa' 'kmʋ kwa. ");
INSERT INTO wob_vpl VALUES ("AC27_25","074_27_25","ACT","27","25","25","Ɛmɛ ‑tɩ 'ma 'cɛ, ao \"duo 'kpɩ 'ʋn, dɛ‑nʋɛ' 'ɩn ‑teɛ' Kea ‑kwlɩ\", kɛ 'da 'de 'ʋn ‑pee ɛ, 'kamɔ ɛɛ mu nɩa' see. ");
INSERT INTO wob_vpl VALUES ("AC27_26","074_27_26","ACT","27","26","26","'Kaa poɔ' ɔ mu ‑aʋn 'de 'tɔniɛ 'a du' jrɛ' \"kpei poa' se. ");
INSERT INTO wob_vpl VALUES ("AC27_27","074_27_27","ACT","27","27","27","'De \"maʋ'wɩ 'a ‑puue 'jɔ ‑nyiiɛ 'di ɛ, 'ka ‑pie ‑te ‑a ‑cɩɛ 'klee mamaʋ 'sʋ ɛ je ‑aʋn 'de 'tɔniɛ ‑ɛ ‑nɩa 'o 'blʋa a ‑kwea' \"kpei kpa. ‑Too' ‑kwea 'sʋ ka ‑aa ‑kʋʋan\" 'blʋa‑ i ɛ, nyʋ ‑ʋʋa nʋa dbo 'e ‑bato' 'di 'je kan' 'mɛ. ");
INSERT INTO wob_vpl VALUES ("AC27_28","074_27_28","ACT","27","28","28","‑Wɛe ʋʋ po dɛ ‑ɛɛ dbaa \"ni 'a ‑sɔn tɛnsʋn \"niɔ‑, 'sʋ dɛ ‑tba' ‑ta ʋʋ nɩa ‑wɛe ‑ɛ mua 'e \"ni ‑sɔn ɛ, ɛ nɩɛ dɩ\" 'a kwla ‑nyiiɛ. Ʋʋ 'kpaa 'o nya dɛ‑saan\" ka ʋʋ poɛ \"niɔ‑ ke'wlɛ, 'sʋ \"ni 'a ‑sɔn tɛnsʋn nɩɛ dɩ\" 'a ‑puue 'jɔ ‑mm\". ");
INSERT INTO wob_vpl VALUES ("AC27_29","074_27_29","ACT","27","29","29","Ʋʋ pleea ‑bato' 'a 'de \"sou \"jri blaa' 'sʋ ʋʋ poɛ ‑bato' 'a \"klɩ ‑nyiiɛ' ‑ɩ ‑bɔɔa' de \"niɔ‑ ‑wɛe ʋʋ ‑te jekaa ‑ʋʋa fuo ‑sɔn'ɔ ‑sɩan'. ");
INSERT INTO wob_vpl VALUES ("AC27_30","074_27_30","ACT","27","30","30","'Sʋ nyʋ ‑ʋʋa nʋa dbo 'e ‑bato' 'di a ‑pɔn plea 'a ‑kɔ i, 'sʋ ʋʋ poɛ ‑bato' ‑saan\" \"niɔ‑, ‑wɛe ka nyɔ ɔ ‑pɔan ɔ 'jea ‑bato' 'a \"klɩ ‑nɩa 'e nya \"niɔ po ‑wɛe ʋʋa nʋ kan'. ");
INSERT INTO wob_vpl VALUES ("AC27_31","074_27_31","ACT","27","31","31","'Sʋ Pɔo wlu' 'de \"sʋɩ ke ʋʋa' klaa\" ‑pee ɔ 'na : ‑Bo nyʋ ‑nʋ se ‑teɩn kpʋn 'de ‑bato' 'di ‑ta 'ja a, ‑mɛ ao se 'pʋi. ");
INSERT INTO wob_vpl VALUES ("AC27_32","074_27_32","ACT","27","32","32","'Sʋ \"sʋɩ cɛn \"dbi ‑ɩ ‑saan ‑bato' ‑saan\" 'bo klaa\" ‑nɛ ‑pʋn\" 'mɛ, ‑wɛe ʋʋ \"tai‑ ɛ \"i 'de ɛ blu. ");
INSERT INTO wob_vpl VALUES ("AC27_33","074_27_33","ACT","27","33","33","‑Sɔn' 'ɔ ‑sɩan' siɛ 'e nya 'sʋ Pɔo kɩɩɛn nyʋ ‑wee' \"jrui ‑wɛe ʋʋ 'e dɛ di 'sʋ ɔ 'na : Ao ‑teɛ 'kpʋ 'de 'wɩ 'a ‑puue 'jɔ ‑nyiiɛ 'di ‑sɩan ao se dɛ \"o dɛ jrɛ' di. ");
INSERT INTO wob_vpl VALUES ("AC27_34","074_27_34","ACT","27","34","34","'Ma 'da aopʋ 'mɛ ao 'je dɛ wɔn ‑tɩn, dɛ‑nʋɛ' ɛ kɔn ‑tɩ' 'de aoa' 'pʋ‑tɩ 'ʋn ‑ke, 'kaa aoa' due' koun ‑gbai 'a \"mɩɩjɔ se \"mai 'bo ɔ \"jru. ");
INSERT INTO wob_vpl VALUES ("AC27_35","074_27_35","ACT","27","35","35","Pɔo 'tmʋa wlu ‑nɛ 'sʋ ɔ \"duɛ ‑di'pɛn 'ʋn ɔ po ɛɛ' Kea 'sɛ‑ 'bo nyʋ ‑wee' \"klein \"juɔi ‑wɛe ɔ cɛɛn ɛ i 'sʋ ɔ ‑tee ɛɛ' dia' ‑pʋn\". ");
INSERT INTO wob_vpl VALUES ("AC27_36","074_27_36","ACT","27","36","36","'Sʋ nyʋ ‑wee' \"duɛ 'kpɩ 'ʋn ‑wɛe ʋʋ ‑te dɛ dia' ‑ke. ");
INSERT INTO wob_vpl VALUES ("AC27_37","074_27_37","ACT","27","37","37","‑Apʋ ‑nɩa 'e ‑bato' 'di ɛ, ‑a ‑wee' nɩɛ nyiɔpʋ 'a kmɛ' 'sɔɔn kwla ‑mɛ\" 'sɔn 'jɔ ‑mɛɛo\"‑. ");
INSERT INTO wob_vpl VALUES ("AC27_38","074_27_38","ACT","27","38","38","Ʋʋ ‑wee' dia ʋʋ dboa 'sʋ ʋʋ poɛ diidɩ ‑sia 'o 'tɔniɛ wɔn, ‑wɛe ‑bato' 'je kwa \"fee‑. ");
INSERT INTO wob_vpl VALUES ("AC27_39","074_27_39","ACT","27","39","39","‑Sɔn' ‑sɩan' nyʋ ‑ʋʋa poa ‑bato' ‑je o se 'blʋa‑ \"i juo‑, 'kaa ʋʋa 'jeɛ 'e 'tɔniɛ 'a bʋ jrɛ' ‑kwlɩ\" i. 'Sʋ ʋʋ 'na : ‑A ‑kpaa' ‑bato' 'emu fɔ o ‑wɛe ‑a ‑je 'kpʋʋ kpʋn 'a i ‑tɩn' ‑bo ɛ 'bɛɛ‑ ɛ 'je 'wɔn ɛ. ");
INSERT INTO wob_vpl VALUES ("AC27_40","074_27_40","ACT","27","40","40","'Sʋ ʋʋ kain i ‑bato' 'a \"klɩ 'mɛ ‑wɛe ɩ blu i 'de 'tɔniɛ ‑sɔn. 'Bomɔ ʋʋ \"tai‑ \"cɩndbi ‑ɩa poa ‑bato' ‑je o \"i ‑ke ‑tan 'tanfɔ ‑nɩa 'de ‑bato' 'a nya, ‑wɛe poɔ' 'je ɛ 'di ‑te 'de ɛ 'je ‑bato' 'nɔ ʋʋa mua \"tuun‑. ");
INSERT INTO wob_vpl VALUES ("AC27_41","074_27_41","ACT","27","41","41","'Kaa ‑bato' bla 'e ‑pɩɩɔn\" \"jri 'bo \"ni 'a bɩ 'sɔɔn 'nynɩ, 'sʋ ɛ ‑se'. Ɛɛ' 'mla pa ‑pɩɩɔn\" ‑sɔn 'sʋ ɛ 'bɔ i ‑suua' ‑tɩ 'mɛ ‑wɛe 'tɔniɛ 'a 'plɩ a blɛɛ' ‑gbɔo wɔn, 'kamɔ ɩ nʋ mamaʋ 'sʋ ɛ waa \"i. ");
INSERT INTO wob_vpl VALUES ("AC27_42","074_27_42","ACT","27","42","42","\"Sʋɩ nɩɛ \"i ʋʋ 'e ‑kaso 'diʋn 'dba, ‑wɛe ʋʋa' nyɔ due' je jre, ɔ je 'kwla 'kpa. ");
INSERT INTO wob_vpl VALUES ("AC27_43","074_27_43","ACT","27","43","43","'Kaa jra' jei nɩa \"i ɔ 'jea Pɔo 'pʋʋ ɛ, ɔ 'kaa‑ ʋʋpʋ 'ʋn 'ɛ, 'de ɔ 'na nyʋ ‑jua jre ka 'kpa \"niɔ‑ tɛin\", ʋʋ 'je 'e 'kpʋʋ \"kpei mu. ");
INSERT INTO wob_vpl VALUES ("AC27_44","074_27_44","ACT","27","44","44","‑Wɛe nyʋ jrʋ' 'e ‑bato' 'a tifɔe' \"kpei ‑te 'de ʋʋ 'je 'o ʋʋpʋ 'de bla. 'Kamɔ ʋʋ ‑wee' nʋ ‑wɛe ʋʋa' nyɔ jrɔ' se 'mɛ 'de ʋʋ ‑wee' kpʋn 'kpʋʋ. ");
INSERT INTO wob_vpl VALUES ("AC28_1","074_28_1","ACT","28","1","1","‑A ‑pʋ 'mɛa' wɔin\" la ‑wɛe ka 'tɔniɛ 'ɛ du' 'a 'nynɩ nɩa Maltɩ ‑a ‑juɛ. ");
INSERT INTO wob_vpl VALUES ("AC28_2","074_28_2","ACT","28","2","2","Nyʋ ‑ʋʋ ‑nɩa 'o ɛɛ' 'blʋa‑ tu \"kpei ɛ, ʋʋ se ‑a juo‑, 'kaa ʋʋ kpʋʋn ‑a sɩn 'sɔɔn 'bo nɛ wɔin\", dɛ‑nʋɛ' ɛ nɩɛ \"ni 'a dba nɔ\" ‑o, ‑wɛe dee' a ji, ɛmɛ ‑tɩ ʋʋ ‑tba' nɛ‑gban klaa\". ");
INSERT INTO wob_vpl VALUES ("AC28_3","074_28_3","ACT","28","3","3","Pɔo a 'tɛn ti \"klaɩn ‑wɛe ɔ 'jɩ 'o \"jri po. Nɛ 'wlaa sii\" 'sʋ, jɔ wan 'e ɩ 'dii ‑wɛe ɛ \"sri Pɔo 'a sʋn 'de ɛ ‑pee. ");
INSERT INTO wob_vpl VALUES ("AC28_4","074_28_4","ACT","28","4","4","Nyʋ ‑nɩa 'o ɛɛ' 'blʋa‑ tu 'di 'jeea sɛn ‑peea' Pɔo 'a sʋn \"i \"jriɛ‑ 'sʋ, ʋʋ 'na : \"Ju ‑nɔ ‑mɔ nɩɛ \"ku 'dbai ‑o ‑cɛɛn'‑ 'e, ɔ se 'kmʋ nɩ ka nɩ‑. Ɛmɛ ‑ɛɛ ‑kao ‑craa ɔ 'ʋn, 'de ‑mɛ 'kamɔ ɔɔ 'wlʋ 'mɛa' wɔin\" i waan' 'bo 'tɔniɛ \"kpei. ");
INSERT INTO wob_vpl VALUES ("AC28_5","074_28_5","ACT","28","5","5","'Kaa Pɔo ‑fuan' sʋn i 'sʋ sɛn ‑nɛ ‑ka i 'bo \"jri, 'de dɛ‑saan\" ka se ɔ i ‑kuuan. ");
INSERT INTO wob_vpl VALUES ("AC28_6","074_28_6","ACT","28","6","6","Nyʋ ‑nɩa 'omu, naa tɔ' i ʋʋ mʋ 'na ‑mɛ ɔ 'e ‑pun\", ‑ɩn\" ɔ 'je 'o \"sri, ɔ 'je 'mɛ 'de‑. 'Kaa ʋʋ fɔan 'o ‑fɔn ‑fɔn ka Pɔo nɩa, ɔ nɩa kan 'sʋ ʋʋ pooɛ tɔ' fai\" ʋʋ 'na : \"Ju ‑nɔ, ɔ nɩɛ ‑kea' ‑o. ");
INSERT INTO wob_vpl VALUES ("AC28_7","074_28_7","ACT","28","7","7","'De 'blʋa‑ ‑nɛ, \"ju ‑bleɛ', ɔɔ' 'nynɩ ‑nɩ Publisɩ. Ɔɔ' \"ju tu nɩɛ dɛjei, ɔɔ' ‑gbɛin\" \"kʋʋan‑ i. Ɔmɔ ‑nyɩ\" ‑a 'pɛn 'ɩn 'de ɔ wɔin\" ‑wɛe ‑ɔ ‑nyɩ\" ‑a diidɛ 'wɩ taan 'di. Ka ɔɔ' \"dɛi ‑wi\" nɩa, 'kamɔ ɔ kpʋn ‑aʋn. ");
INSERT INTO wob_vpl VALUES ("AC28_8","074_28_8","ACT","28","8","8","'De Publisɩ \"bo 'pɛn i, ɔɔ' \"jru ‑a ‑bai', ‑wɛe 'klaa ‑a nʋ ɔ. Pɔo muɛ 'e ɔ o, ɔ ‑te' ɔ kwa \"jru ɔ baeɛ ɔɔ' Kea, 'sʋ ɔ 'pʋʋ. ");
INSERT INTO wob_vpl VALUES ("AC28_9","074_28_9","ACT","28","9","9","'Sʋ nyʋ jrʋ' 'wɛ‑ kpʋn a 'bo ɛɛ' 'blʋa‑ tu \"kpei jiɛ 'de ɔ o ‑ke, ‑wɛe ʋʋa' 'wɛ‑ 'bɔ. ");
INSERT INTO wob_vpl VALUES ("AC28_10","074_28_10","ACT","28","10","10","Ʋʋa' ‑aa ni' ‑tea' ‑siɛ' sʋn' i, ‑wɛe ‑ta ‑aa jia 'o 'wlʋa a, dɩ \"klein ‑kɔan ‑tɩ' 'bo ‑jei\" ʋʋ \"nyɩ ‑aʋn ‑ɛ. ");
INSERT INTO wob_vpl VALUES ("AC28_11","074_28_11","ACT","28","11","11","'Cɩ taan ‑sia' 'o mu 'sʋ, ‑a ‑kpa ‑bato' ‑ɛ ‑wlʋa Alɛsandri 'de ‑ɛ nʋa dee' 'a ji nɔ\" ‑wee' 'o mu ‑ke 'di. Ɛɛ' ‑bato' tu 'a 'nynɩ ʋʋ ‑tuu\" ɛ ɛmɛ ‑nɩ Diosiki, ɛ 'de mɛ ‑nɩ ‑gbanynuu. ");
INSERT INTO wob_vpl VALUES ("AC28_12","074_28_12","ACT","28","12","12","‑A nynia 'o Sirakisɩ ɛ, ‑a nʋɛ 'o 'wɩ taan. ");
INSERT INTO wob_vpl VALUES ("AC28_13","074_28_13","ACT","28","13","13","‑A ‑wlʋa 'omu ɛ, ‑a pleɛ 'kpʋʋ ‑kwlɩ' i mamaʋ ‑a je Rekio nyni. Ɛɛ' ‑sɔn' dee ‑sɩan', poɔ' ‑ɛ ‑wlʋa 'e 'jrʋ 'a 'wlʋ 'ɩn 'a kʋanfɔ o ‑teɛ jia' ‑pʋn\". Ɛmɛ ‑tɩ ‑a nʋ 'wɩ 'sɔɔn 'bo ‑jei\" ‑wɛe ‑a nyni Pussolɩ. ");
INSERT INTO wob_vpl VALUES ("AC28_14","074_28_14","ACT","28","14","14","'Bo ɛɛ' ‑kwlɔ ‑tu 'di ɛ, ‑a ‑jɛɛ 'o ‑aa de 'di‑wi\" jrʋ' ʋʋ kpʋʋn ‑a i 'de ‑a ‑je 'o ʋʋpʋ o 'dɔɔ due' nʋ, 'kamɔ ‑a nʋ ‑wɛe ‑a mu Rɔmʋ. ");
INSERT INTO wob_vpl VALUES ("AC28_15","074_28_15","ACT","28","15","15","‑Aa de 'di‑wi\" ‑nɩa 'e Rɔmʋ 'wɔan ‑aa 'nynɩ 'sʋ, ʋʋ 'jaa ‑a \"i. Ʋʋa' jrʋ' ji' mamaʋ ʋʋ je 'o Apisɩ 'a 'dɔɔkpae\" nyni. Jrʋ' ji' mamaʋ ʋʋ je 'o 'dʋɩ 'a koo‑gbi nyʋ a 'daa ‑gbi\" nynuu taan 'a nɩ 'ɩn nyni. Pɔo 'jeea ʋʋpʋ \"jriɛ‑ 'sʋ ɔɔ' dɩ \"si 'o 'ɛ, ‑wɛe ɔ po Kea 'sɛ‑. ");
INSERT INTO wob_vpl VALUES ("AC28_16","074_28_16","ACT","28","16","16","‑A nyniia Rɔmʋ ɛ, ʋʋ 'wɔɔn Pɔo 'a ‑ta jrɔ' koo ‑tɩ 'mɛ ‑wɛe \"soai‑ due' a fuo ɔ i. ");
INSERT INTO wob_vpl VALUES ("AC28_17","074_28_17","ACT","28","17","17","‑A nʋa 'wɩ taan 'sʋ Pɔo 'da Suifʋ‑wi\" 'a klae\" ‑nɩa 'o Rɔmʋ 'mɛ. ‑Ta ʋʋ 'kɩɩan \"jrui 'sʋ, ɔ wlu ʋʋ ‑pee ɔ 'na : 'Ma de 'di‑wi\", 'ɩn se 'ma 'cɛ‑wi\" dɛ jrɛ' \"jrii nʋ 'ɩn se ‑a \"bo ‑wi\" 'a kplɩn wɔn blaa‑, 'kaa ʋʋ poɛ 'ʋn ‑kaso 'di 'de Selisalɛm ‑wɛe ʋʋ to 'ʋn 'de Rɔmʋ‑kɔʋn 'kwa. ");
INSERT INTO wob_vpl VALUES ("AC28_18","074_28_18","ACT","28","18","18","Ʋʋ ‑teea' 'mii ɛ, ʋʋ nɩɛ \"i ʋʋ 'je 'mii \"sii‑, dɛ‑nʋɛ' dɛ ‑ɛɛ 'dbaa' ʋʋ 'jea 'ʋn 'dba ‑gblein' ɛ se 'de 'ʋn nɩ‑. ");
INSERT INTO wob_vpl VALUES ("AC28_19","074_28_19","ACT","28","19","19","'Kaa Suifʋ‑wi\" 'na ʋʋ se 'o 'wɔɔn‑. 'De ɛɛ' ‑tɩ' 'ʋn ɛ, 'ɩn kpʋɛn 'ma ‑cɛ\" \"klaan‑ \"klan ‑wɛe 'ɩn ja 'ma ‑tɩ' 'nɔ 'blʋajei \"juɔi, ‑bo ɛ se ‑mɛ nɩ 'de ɛ, ‑mɛ 'ɩn se 'nɔ jii, dɛ‑nʋɛ' 'ɩn se ɛ \"i nɩ ‑wɛe 'ɩn 'je 'ma 'cɛ‑wi\" \"kuan poo 'de‑. ");
INSERT INTO wob_vpl VALUES ("AC28_20","074_28_20","ACT","28","20","20","Ɛmɛ ‑tɩ 'ɩn ‑tee' aoa' ‑tɩ' i, ‑wɛe 'ɩn 'je ao \"kuan po, dɛ‑nʋɛ' dɛ Israɛ‑blʋa ‑wee' ‑tea' ‑kwlɩ\" ʋʋa fua, ɛmɛ ‑ɛɛ ‑tɩ' 'ʋn nyʋ po 'ʋn \"cɩn ‑nɛ sʋn'. ");
INSERT INTO wob_vpl VALUES ("AC28_21","074_28_21","ACT","28","21","21","Ʋʋ wlu ɔ ‑pee ʋʋ 'na : ‑Ma \"kpei ‑te' 'sbɛ jrɛ' se 'e Suide 'wlʋ ɛ se ‑a ‑jɛɛ‑, 'de ‑aa de 'di jrɔ' se 'e ɛɛ' 'fɔ tu o 'wlʋ, ɔ se ‑aʋn ‑ma \"kuan saʋn ja‑. ");
INSERT INTO wob_vpl VALUES ("AC28_22","074_28_22","ACT","28","22","22","'Kaa ‑a ‑nɩɛ \"i ‑a ‑je dɛ ‑ma naa tɔ' i 'mii 'wɔn 'pepe 'de ‑ɩn wɔn, dɛ‑nʋɛ' Kea 'a \"juɔi ‑gbɛɛ' sʋn dee ‑nɛ, nyʋ ‑wee' \"klein a tbɛ ‑tɩ' ‑pʋn\" ‑ta \"o ‑ta. ");
INSERT INTO wob_vpl VALUES ("AC28_23","074_28_23","ACT","28","23","23","‑Wɛe ʋʋ ‑tu\" Pɔo 'wɩ \"i 'de ɛɛ' 'wɩ tu 'di ɛ, nyʋ ‑tuu\"‑tuu mu 'nɔ ɔ kooa. ‑Wɛe Pɔo 'tmʋ Kea 'a 'beɔdɛ 'ɛ ‑tɩ' 'de ʋʋ ‑pee. Ɔ cɛɛn 'e Moisɩ 'a 'sbɛ o, dɩ \"klein Kea 'a wlu 'kwajaaʋn‑ 'tmʋa 'ʋn 'de ɔɔ flɔɔn Sesi 'a ‑tɩ' \"i 'de ʋʋ ‑pee ‑wɛe ɔɔ ‑pɔn ʋʋpʋ 'a ɩa' tɔ' 'ʋn 'jea' i. Dɛ ‑wlʋa 'e ‑klae\" pɛɛn o, 'kamɔ ʋʋ wlu mamaʋ 'sʋ kwie kpʋn‑. ");
INSERT INTO wob_vpl VALUES ("AC28_24","074_28_24","ACT","28","24","24","Dɛ ɔ 'tmʋa ɛ \"siɛ nyʋ jrʋ' \"i 'kaa jrʋ' se ɛɛ' tɔ' 'ʋn 'je. ");
INSERT INTO wob_vpl VALUES ("AC28_25","074_28_25","ACT","28","25","25","‑Ta ʋʋa' 'sʋ sea wlu 'ʋn 'bɛɛ‑ ‑wɛe ʋʋa mua, wlu tiie Pɔo poa 'o ɛ \"kpei ɛ ka, ɔ na : Dɛ Kea 'a ‑Suu jaa ɛɛ' wlu 'kwajaai Esai 'ʋn ‑wɛe ɛ 'tmʋa ‑a \"bo ‑wi\" ‑pee ɛ 'bleɛ ‑kɩn 'dee‑ ! ");
INSERT INTO wob_vpl VALUES ("AC28_26","074_28_26","ACT","28","26","26","Ɛ wlu' 'de‑ ɛ 'na : ‑Ɩn mu 'e nyʋ ‑nʋ o ‑wɛe ‑ɩn ‑je wlu ka, ‑ɩn ‑na : Aoa muɛ dɛ doin\" 'wɔɔn‑, 'kaa ao se 'e ɛ 'dei 'wɔn 'pepe, aoa \"jri a muɛ dɛ ja ‑gbʋan' ‑pɛɛ, 'kaa ao se ɛ \"i juoi, ");
INSERT INTO wob_vpl VALUES ("AC28_27","074_28_27","ACT","28","27","27","dɛ‑nʋɛ' dɛ 'ɛ pa nyʋ ‑nʋ 'a pɛe \"i, ʋʋ \"suɛn ‑cɩɩ doin\", ʋʋ \"muɛ \"jri ‑wɛe ʋʋa' \"jri je i 'je, ʋa' doin\" je i 'wɔn, ʋʋa' pɛe je dɛ 'mii 'wɔn ‑wɛe ʋʋ je 'de 'ʋn o \"biie‑ 'de 'ɩn je ʋʋpʋ 'pʋʋ‑. ");
INSERT INTO wob_vpl VALUES ("AC28_28","074_28_28","ACT","28","28","28","'De ɔ 'na : Aopʋ siɛ ‑kwlʋ o, 'pʋʋa' ‑nɛ Kea kpɛ e nyʋ ‑sea' Suifʋ nɩ o, ʋʋpʋ ‑a muɛ doin\" o poa'. ");
INSERT INTO wob_vpl VALUES ("AC28_29","074_28_29","ACT","28","29","29","Pɔo ‑koa' dɛ ‑nɛ 'ɛ 'tmʋa 'sʋ Suifʋ‑wi\" \"siɛ \"kpae' ‑wɛe ʋʋa' 'sʋ a kpʋʋn \"wɔin. ");
INSERT INTO wob_vpl VALUES ("AC28_30","074_28_30","ACT","28","30","30","‑Gbu\" Pɔo kpʋn a ‑wɛe ɔɔ ‑sa ‑kei\" ɛ, ɔ nʋɛ 'e ɛ 'di ‑sɩn 'sɔɔn ‑gbla' ‑gbla', 'demɔ nyʋ \"klein ‑a ji ɔ \"i ‑tea' ke ɔɔ 'jee‑. ");
INSERT INTO wob_vpl VALUES ("AC28_31","074_28_31","ACT","28","31","31","‑Wɛe ɔɔ 'tmʋ Kea 'a 'bɩɔ dɛ 'ɛ ‑tɩ' 'de dɩ \"klein ‑tmʋa Tʋ\"bo Sesi Klisɩ 'a ‑tɩ' ɛ, ɔɔ tɔɔ ‑mɩ nyʋ 'de 'flɛ 'ʋn, nyɔ jrɔ' 'ɔ kaan ɔ ‑je de.");
INSERT INTO wob_vpl VALUES ("RM1_1","075_1_1","ROM","1","1","1","'Mɔ Pɔo 'ɩn nɩɛ Sesi Klisɩ 'a \"juɔinʋʋi ‑o. Ɔ 'da 'ʋn 'ɛ 'de nyʋ \"klu, ‑wɛe 'ɩn 'je ɔɔ' dboi nɩ‑. Ɔ ‑teeɛ 'ʋn kpɔi\" ‑wɛe 'ɩn 'je Kea 'a ‑pɔia\" ‑tɩ 'tmʋ 'de nyʋ ‑pee. ");
INSERT INTO wob_vpl VALUES ("RM1_2","075_1_2","ROM","1","2","2","Ɩa' ‑pɔia\" ‑tɩ tu ɛ, Kea cɛn ɩa' wlu ‑tie\" tɛin\" sese ‑wɛe ɛɛ' wlu 'kwajaaʋn 'tmʋ ɩ, 'de ɩ 'crɩɩɛ 'de ɛɛ' 'sbɛ 'di. ");
INSERT INTO wob_vpl VALUES ("RM1_3","075_1_3","ROM","1","3","3","Dɛ ɩa' a, mɛ ‑nɩ ɛɛ' \"Ju 'a ‑tɩ'. Ɛɛ' \"Ju ‑nɔ ɔ nɩɛ nyiɔ 'ɔ \"ju ‑o, ɔ 'wlʋʋ 'de Dafidɩ 'a \"ji 'di. ");
INSERT INTO wob_vpl VALUES ("RM1_4","075_1_4","ROM","1","4","4","'De ka ɔ nɩa Kea 'a \"Ju ‑wɛe ɛ ‑te' ɔ 'o 'de ɛ \"nyɩ ɔ \"ikmaa', ‑ta Kea 'a ‑Suu ‑kwea i ‑sɔ 'de 'mɛʋn \"klu ɛ, 'bomɔ ɛ poo \"jri \"kpae' 'pepe. Sesi Klisɩ ‑nɔ ɔmɔ ‑nɩ ‑aa Tʋ\"bo. ");
INSERT INTO wob_vpl VALUES ("RM1_5","075_1_5","ROM","1","5","5","Ɔmɔ ‑nʋ 'ʋn 'saaʋn \"jrii, 'de ‑ɔ dbo 'ʋn ‑wɛe 'ɩn 'je ɔɔ' ‑tɩ' 'tmʋ 'de nyʋ \"klein sea Suifʋ nɩ ‑pee, ‑wɛe ʋʋ 'je ɔɔ' ‑tɩ' tɔ' 'ʋn 'je, 'de ʋʋ 'je ɔ wɔn 'je. ‑Bo ɛ nɩ kan', ‑wɛe ɔɔ' 'nynɩ 'je \"i 'bɛ. ");
INSERT INTO wob_vpl VALUES ("RM1_6","075_1_6","ROM","1","6","6","Aopʋ Sesi Klisɩ 'da a, ao nɩ 'e ʋʋa' nyʋ tu \"klu 'mɛ ‑ke. ");
INSERT INTO wob_vpl VALUES ("RM1_7","075_1_7","ROM","1","7","7","Aopʋ nyʋ \"klein ‑ʋʋa ‑tɩ' Kea kma, 'de ɛ 'da ‑wɛe ‑ɔ ‑jea ɛɛ' nyʋ nɩ 'bo Rɔmʋ‑kwlɔ 'di, aopʋ 'ma ja 'sbɛ‑. 'Ɩn nɩɛ \"i ‑a \"Bo Kea ke ‑aa Tʋ\"bo Sesi Klisɩ 'je aopʋ \"diwan po ‑wɛe ɛ 'je aopʋ pɛe 'a blua' \"nyɩ ! ");
INSERT INTO wob_vpl VALUES ("RM1_8","075_1_8","ROM","1","8","8","'Ma poɛ 'ma Kea 'sɛ‑ ke \"i‑saa nɔ\" 'de Sesi Klisɩ 'a 'nynɩ 'ʋn, 'de ao ‑wee' \"klein 'a ‑tɩ' 'ʋn dɛ‑nʋɛ' aoa' Kea 'a ‑jei\" naanynɩ \"siiɛ 'blʋa‑ ‑wee' \"klein \"i. ");
INSERT INTO wob_vpl VALUES ("RM1_9","075_1_9","ROM","1","9","9","Kea 'ma nʋʋa \"juɔi 'de 'ma pɛe ‑wee' \"klein 'ʋn, ‑wɛe ‑ɛɛ \"ju 'a ‑pɔia\" ‑tɩ 'ma 'tmʋa a, ɛ 'je kan' 'mɛ, 'ma cɛn aopʋ 'nynɩ jeejee. ");
INSERT INTO wob_vpl VALUES ("RM1_10","075_1_10","ROM","1","10","10","Dɛ 'ma ‑teea' Kea i 'de 'ma baewlu 'di ɛ, ɛmɛ ‑nɩ ‑bo ɛ nɩɛ \"i ɛ, ɛ 'je 'mi \"i \"tai‑ la ‑wɛe 'ɩn 'je 'de aopʋ o ji 'wɩ jrɛ' o. ");
INSERT INTO wob_vpl VALUES ("RM1_11","075_1_11","ROM","1","11","11","'Ɩn ‑nɩɛi\" 'ɩn 'je aopʋ \"jriɛ‑ 'jee‑, ‑wɛe 'ɩn 'je ao Kea 'a ‑suu 'a ‑paan' jrɛ' \"nyɩ 'de ɛ 'je aoa' dɩ i kuu‑. ");
INSERT INTO wob_vpl VALUES ("RM1_12","075_1_12","ROM","1","12","12","'De ɛ se ‑mɛ 'ɛ 'sʋ nɩ‑, Aomɔ o 'mɔ o, ‑a ‑wee' \"klein 'a dɩ 'je i ku 'de ‑aa Kea ‑kwlɩ\" ‑tea' ‑nɩa due' 'ʋn. ");
INSERT INTO wob_vpl VALUES ("RM1_13","075_1_13","ROM","1","13","13","'Ma de'di ‑wi\", ka 'ma naa 'de aopʋ o ji ‑tɩ tɔ' \"kpei‑ ‑wɛe dɛ jrɛ' kaan 'ʋn ‑je de jeejee ɛ, 'ɩn nɩɛ \"i ao 'je ɛ juo‑. Dɛɛ‑tɩ 'ma ‑pɔan 'de aopʋ o jia' i ɛ, ɛmɛ ‑nɩ ka 'ɩn 'tmʋa Klisɩ 'a ‑tɩ' 'de 'blʋa‑ jrɩ' \"kpei ‑wɛe nyʋ 'je ɛ tɔ' 'ʋn ɛ, 'kamɔ 'ɩn nɩɛ \"i ɛ 'je kan' dbo nʋa' 'de ao \"klu ‑ke ‑wɛe 'ɩn 'je ɛ 'je dɛwɛ‑jɛ. ");
INSERT INTO wob_vpl VALUES ("RM1_14","075_1_14","ROM","1","14","14","Ɛ se aoa' 'sʋ 'mɔ 'ɩn 'je Kea 'a ‑tɩ' ‑pee 'tmʋ ko‑, Glɛkɩ‑wi\" o, nyʋ sea' Klɛkɩ nɩ o, dɛ \"ijuoʋn o, nyʋ sea' dɛ \"ijuoʋn nɩ o, 'ɩn 'je ʋʋ ‑wee' \"klein Klisɩ 'a ‑tɩ' 'tmʋʋ ‑o. Dɛ ‑ɛ ‑crɩɩa' 'bo 'ʋn \"jru ɛ, ɛmɛ ‑nao. ");
INSERT INTO wob_vpl VALUES ("RM1_15","075_1_15","ROM","1","15","15","Ɛmɛ ‑tɩ aopʋ‑ ‑ɔ ‑tia\" 'o Rɔmʋ. 'De aopʋ o jia' 'a 'tʋn a 'dba 'ʋn 'ɛ ‑wɛe 'ɩn 'je aopʋ Klisɩ 'a ‑pɔia\" ‑tɩ 'tmʋʋ‑ ‑ke. ");
INSERT INTO wob_vpl VALUES ("RM1_16","075_1_16","ROM","1","16","16","Klisɩ 'a ‑tɩ' 'tmʋa 'a ‑tɩn' se 'ʋn nʋ, dɛ‑nʋɛ' Kea 'a \"ikmaa' ‑nɩ 'de ɛ 'di, ɛmɛ ɛɛ cɛɛn 'ʋn ‑wɛe ɛɛ 'pʋʋ nyɔ \"o nyɔ ‑jea Sesi 'a ‑tɩ' tɔ' 'ʋn. Suifʋ‑wi\" mʋ ‑wɔn ɩ tɛin\" ‑wɛe nyʋ ‑sea' Suifʋ nɩ 'wɔn ɩ 'bo ʋʋpʋ 'de ‑ke. ");
INSERT INTO wob_vpl VALUES ("RM1_17","075_1_17","ROM","1","17","17","Ka Kea nʋɛ ‑wɛe nyɔ 'bɛɛa ɔ 'jea \"isrɛi 'kpa 'bo ɛ \"juɔi ɛ, 'de ɛɛ' wlu 'di mɔ ɩ 'wlʋʋ 'kwla 'de nyʋ ‑pee. Nyɔ ‑tea Kea ‑kwlɩ\" ɛ, ɔmɔ ‑kpa \"isrɛi 'bo ɛ \"juɔi, ‑wɛe ɔɔ' \"isrɛa' ‑mɛ nʋɛ ‑wɛe ɔɔ' Kea ‑kwlɩ\" ‑tea' a 'kpa \"kpei sɔɔn‑ sɔɔn‑. 'Kamɔ wlu ‑crɩɩa' 'da, ɛ 'naa : \"Isrɛi a muɛ 'kmʋnɩa' 'de ɔɔ' Kea ‑kwlɩ\" ‑tea' 'ʋn. ");
INSERT INTO wob_vpl VALUES ("RM1_18","075_1_18","ROM","1","18","19","Kea 'a 'cɛn 'wlʋɛ 'e jaʋn 'di ɛ je \"jri \"kpae' po 'de nyʋ ‑flɛɛʋn ke nyʋ ‑sea' \"isrɛ ‑wɛe ‑ʋʋ ‑saan tɔ' ‑tɩ sʋn \"wɔin ‑pee. Kaa dɛ nyʋ 'jea juo de Kea mɛɛ' ‑tɩ' 'ʋn, mɛ poɛ \"jri kpae. Kea 'a ‑cɛ\" 'kpa mɛ ‑sɩ 'kwla 'pepe 'de ʋʋ pee‑. ");
INSERT INTO wob_vpl VALUES ("RM1_20","075_1_20","ROM","1","20","20","Tɔ' ‑o, dɛ ‑tba' 'e 'kmʋ 'a nʋʋa' a, dɩ \"klein Kea nyɔ 'ɔ 'jeea \"jriɛ‑ nɩa 'ʋn ɛ, ɛɛ' \"ikmaa' ‑ɛ sea ‑kwɛ ‑ta 'ble ke ɛɛ' nɩsʋn ke ɩ ‑wee' 'pɛɛn \"kpae' 'de ɛɛ' nʋʋdɩ 'ʋn. 'De ɛɛ' ‑tɩ' 'ʋn nyiɔpʋ se ‑too' ‑ta 'ble 'bode. ");
INSERT INTO wob_vpl VALUES ("RM1_21","075_1_21","ROM","1","21","21","Ka Kea nɩa 'kmʋ ʋʋ 'je kan' 'mɛ ‑mɔ, 'kaa ʋʋ 'na ʋʋ se ɛɛ' 'nynɩ \"i 'bɛɛi, ʋʋ se ɛ 'sɛ poi. Ʋʋa' tɔ' ‑wee' \"biiɛ 'e foo\" 'ʋn dɩ \"kpei, ɛmɛ ‑tɩ ʋʋ se Kea 'a ‑kwlʋtɩ juo‑ ‑wɛe 'de ʋʋa' pɛe ‑wee' o kpe ‑plipli. ");
INSERT INTO wob_vpl VALUES ("RM1_22","075_1_22","ROM","1","22","22","Ʋʋa 'daa‑ ʋʋa' ‑cɛ\" dɛ \"jriijuoʋn, 'kaa ka ʋʋ 'kpa sɩɩanʋʋn, ʋʋ se ‑mɛ juo‑. ");
INSERT INTO wob_vpl VALUES ("RM1_23","075_1_23","ROM","1","23","23","Kea ‑jɛ ‑ɛɛ 'nynɩ 'bɛa \"i ‑ɛ sea 'mɛ ‑ta 'ble, ʋʋa' ‑gbɛɛ' ‑mɛ \"juɔi, 'kaa dɩ nyiɔ ‑ɔ ‑mɛa ‑pa' ‑ɩ ‑nɩa nyiɔ 'ɔ ‑kooɔ' dɩ o, nʋʋɩ 'a ‑kooɔ' dɩ o, kɔɔkpɩ 'a ‑kooɔ' dɩ ke cniɛ ‑pɛɛ' 'ɛ ‑kooɔ' dɩ ke ɩmɩ ʋʋa ‑gbɛɛ' \"juɔi. ");
INSERT INTO wob_vpl VALUES ("RM1_24","075_1_24","ROM","1","24","24","Ɛmɛ ‑tɩ Kea ‑saa ʋʋpʋ 'a ‑tɩ' kwa ‑sɔn ‑wɛe ɛ 'bɔɔ‑ ʋʋpʋ ‑flɛn\" dɩ kwa, 'de ʋʋa nʋ ʋʋa' pɛe 'a 'tʋn nʋ‑tɩ saɩn. Ɛmɛ ‑tɩ dɩ ʋʋa nʋa ʋʋa' ‑cɛ\" 'ɛ ku \"jrii ɛ, ɩa' 'tmʋa' 'bleɛ ‑tɩn'. ");
INSERT INTO wob_vpl VALUES ("RM1_25","075_1_25","ROM","1","25","25","tɔ' ‑tɩ ‑ɩa ‑tmʋa Kea 'a ‑nɩ ‑pʋn\" ‑tɩ ɛ, ɩmɩ ʋʋ poo fai\" ‑wɛe ʋʋ nʋ sɩ ‑tɩ 'ʋn. Kea ‑ɛ nʋa dɩ ‑wee' \"klein ɛ, ʋʋa' ‑gbeɛ' ‑mɛ ‑wɛe ɛɛ' \"juɔi nʋʋ ‑tɩ. Dɩ ‑jɩ Kea nʋa, ɩmɩ ʋʋa ‑gbɛɛ' ‑wɛe ʋʋa nʋʋ \"juɔi ! ");
INSERT INTO wob_vpl VALUES ("R